package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Human skeleton reference example providing all bones, with no polygonal normals precomputed or embedded. Scaled to normal size. </p>
 <p> Related links: Catalog page <a href="../../../Medical/SkeletonCompleteNoNormalsIndex.html" target="_blank">SkeletonCompleteNoNormals</a>,  source <a href="../../../Medical/SkeletonCompleteNoNormals.java">SkeletonCompleteNoNormals.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/SkeletonCompleteNoNormals.x3d">SkeletonCompleteNoNormals.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Human skeleton reference example providing all bones, with no polygonal normals precomputed or embedded. Scaled to normal size. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> TODO </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Damon Hernandez, Joe D. Williams, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="../../../Medical/SkeletonCompleteNormals.x3d">SkeletonCompleteNormals.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> UltraEdit, <a href="http://www.ultraedit.com" target="_blank">http://www.ultraedit.com</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/SkeletonCompleteNoNormals.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/SkeletonCompleteNoNormals.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Damon Hernandez, Joe D. Williams, Don Brutzman
 */

public class SkeletonCompleteNoNormals
{
	/** Default constructor to create this object. */
	public SkeletonCompleteNoNormals ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SkeletonCompleteNoNormals.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Human skeleton reference example providing all bones, with no polygonal normals precomputed or embedded. Scaled to normal size."))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent(meta.NAME_TODO       ))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Damon Hernandez, Joe D. Williams, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("SkeletonCompleteNormals.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("UltraEdit, http://www.ultraedit.com"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/SkeletonCompleteNoNormals.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SkeletonCompleteNoNormals.x3d"))
    .addChild(new NavigationInfo())
    .addChild(new Background("Background1").setGroundColor(new MFColor(new double[] {0.0,0.0,0.0})).setSkyColor(new MFColor(new double[] {.64314,.64314,.64314})))
    .addComments(" Translation to move rotated and scaled shape to std hanim 0 0 0 ")
    .addChild(new Transform()
      .addComments(" rotations and scale to std hanim 0 0 0 origin, facing +z, and humanoid size ")
      .addChild(new Transform().setScale(0.029,0.029,0.029)
        .addChild(new Transform()
          .addChild(new Transform()
            .addChild(new Viewpoint("Intro").setDescription("Intro").setFieldOfView(0.785).setPosition(.35784,30.17213,74.93772))
            .addChild(new Viewpoint("Right").setDescription("Right").setFieldOfView(0.785).setOrientation(0.0,1.0,0.0,1.571).setPosition(77.90892,29.85694,-2.52271))
            .addChild(new Viewpoint("Left").setDescription("Left").setFieldOfView(0.785).setOrientation(-0.0,-1.0,0.0,1.571).setPosition(-75.97132,30.7287,-.47994))
            .addChild(new Viewpoint("Skull").setDescription("Skull").setFieldOfView(0.785).setPosition(.08991,54.9537,19.04078))
            .addChild(new Viewpoint("Chest").setDescription("Chest").setFieldOfView(0.785).setPosition(-.19509,43.5537,19.0408))
            .addChild(new Viewpoint("Hips").setDescription("Hips").setFieldOfView(0.785).setPosition(.22486,32.4387,13.51968))
            .addChild(new Viewpoint("Feet").setDescription("Feet").setFieldOfView(0.785).setOrientation(-1.0,-0.0,0.0,.408).setPosition(-.28544,6.11975,11.78506))
            .addChild(new Shape("atlas")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("atlas_Geo").setDEF("atlas_Geo").setCreaseAngle(1.571).setCoordIndex(getatlas_Geo_8_24_coordIndex())
                .setCoord(new Coordinate("atlas_Coord").setPoint(getatlas_Coord_9_24_point()))))
            .addChild(new Shape("axis")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("axis_Geo").setDEF("axis_Geo").setCreaseAngle(1.571).setCoordIndex(getaxis_Geo_8_29_coordIndex())
                .setCoord(new Coordinate("axis_Coord").setPoint(getaxis_Coord_9_29_point()))))
            .addChild(new Shape("c2disc")
              .addComments(" skullbase ")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("c2disc_Geo").setDEF("c2disc_Geo").setCreaseAngle(1.571).setCoordIndex(getc2disc_Geo_8_34_coordIndex())
                .setCoord(new Coordinate("c2disc_Coord").setPoint(getc2disc_Coord_9_34_point()))))
            .addChild(new Shape("c3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("c3_Geo").setDEF("c3_Geo").setCreaseAngle(1.571).setCoordIndex(getc3_Geo_8_39_coordIndex())
                .setCoord(new Coordinate("c3_Coord").setPoint(getc3_Coord_9_39_point()))))
            .addChild(new Shape("c3disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("c3disc_Geo").setDEF("c3disc_Geo").setCreaseAngle(1.571).setCoordIndex(getc3disc_Geo_8_44_coordIndex())
                .setCoord(new Coordinate("c3disc_Coord").setPoint(getc3disc_Coord_9_44_point()))))
            .addChild(new Shape("c4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("c4_Geo").setDEF("c4_Geo").setCreaseAngle(1.571).setCoordIndex(getc4_Geo_8_49_coordIndex())
                .setCoord(new Coordinate("c4_Coord").setPoint(getc4_Coord_9_49_point()))))
            .addChild(new Shape("c4disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("c4disc_Geo").setDEF("c4disc_Geo").setCreaseAngle(1.571).setCoordIndex(getc4disc_Geo_8_54_coordIndex())
                .setCoord(new Coordinate("c4disc_Coord").setPoint(getc4disc_Coord_9_54_point()))))
            .addChild(new Shape("c5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("c5_Geo").setDEF("c5_Geo").setCreaseAngle(1.571).setCoordIndex(getc5_Geo_8_59_coordIndex())
                .setCoord(new Coordinate("c5_Coord").setPoint(getc5_Coord_9_59_point()))))
            .addChild(new Shape("c5disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("c5disc_Geo").setDEF("c5disc_Geo").setCreaseAngle(1.571).setCoordIndex(getc5disc_Geo_8_64_coordIndex())
                .setCoord(new Coordinate("c5disc_Coord").setPoint(getc5disc_Coord_9_64_point()))))
            .addChild(new Shape("c6")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("c6_Geo").setDEF("c6_Geo").setCreaseAngle(1.571).setCoordIndex(getc6_Geo_8_69_coordIndex())
                .setCoord(new Coordinate("c6_Coord").setPoint(getc6_Coord_9_69_point()))))
            .addChild(new Shape("c6disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("c6disc_Geo").setDEF("c6disc_Geo").setCreaseAngle(1.571).setCoordIndex(getc6disc_Geo_8_74_coordIndex())
                .setCoord(new Coordinate("c6disc_Coord").setPoint(getc6disc_Coord_9_74_point()))))
            .addChild(new Shape("c7")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("c7_Geo").setDEF("c7_Geo").setCreaseAngle(1.571).setCoordIndex(getc7_Geo_8_79_coordIndex())
                .setCoord(new Coordinate("c7_Coord").setPoint(getc7_Coord_9_79_point()))))
            .addChild(new Shape("c7disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("c7disc_Geo").setDEF("c7disc_Geo").setCreaseAngle(1.571).setCoordIndex(getc7disc_Geo_8_84_coordIndex())
                .setCoord(new Coordinate("c7disc_Coord").setPoint(getc7disc_Coord_9_84_point()))))
            .addChild(new Shape("coccyx")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("coccyx_Geo").setDEF("coccyx_Geo").setCreaseAngle(1.571).setCoordIndex(getcoccyx_Geo_8_89_coordIndex())
                .setCoord(new Coordinate("coccyx_Coord").setPoint(getcoccyx_Coord_9_89_point()))))
            .addChild(new Shape("ethmoid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ethmoid_Geo").setDEF("ethmoid_Geo").setCreaseAngle(1.571).setCoordIndex(getethmoid_Geo_8_94_coordIndex())
                .setCoord(new Coordinate("ethmoid_Coord").setPoint(getethmoid_Coord_9_94_point()))))
            .addChild(new Shape("ethmoid2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ethmoid2_Geo").setDEF("ethmoid2_Geo").setCreaseAngle(1.571).setCoordIndex(getethmoid2_Geo_8_99_coordIndex())
                .setCoord(new Coordinate("ethmoid2_Coord").setPoint(getethmoid2_Coord_9_99_point()))))
            .addChild(new Shape("frontal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("frontal_Geo").setDEF("frontal_Geo").setCreaseAngle(1.571).setCoordIndex(getfrontal_Geo_8_104_coordIndex())
                .setCoord(new Coordinate("frontal_Coord").setPoint(getfrontal_Coord_9_104_point()))))
            .addChild(new Shape("inconl")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("inconl_Geo").setDEF("inconl_Geo").setCreaseAngle(1.571).setCoordIndex(getinconl_Geo_8_109_coordIndex())
                .setCoord(new Coordinate("inconl_Coord").setPoint(getinconl_Coord_9_109_point()))))
            .addChild(new Shape("inconr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("inconr_Geo").setDEF("inconr_Geo").setCreaseAngle(1.571).setCoordIndex(getinconr_Geo_8_114_coordIndex())
                .setCoord(new Coordinate("inconr_Coord").setPoint(getinconr_Coord_9_114_point()))))
            .addChild(new Shape("l1disk")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("l1disk_Geo").setDEF("l1disk_Geo").setCreaseAngle(1.571).setCoordIndex(getl1disk_Geo_8_119_coordIndex())
                .setCoord(new Coordinate("l1disk_Coord").setPoint(getl1disk_Coord_9_119_point()))))
            .addChild(new Shape("l2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("l2_Geo").setDEF("l2_Geo").setCreaseAngle(1.571).setCoordIndex(getl2_Geo_8_124_coordIndex())
                .setCoord(new Coordinate("l2_Coord").setPoint(getl2_Coord_9_124_point()))))
            .addChild(new Shape("l2disk")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("l2disk_Geo").setDEF("l2disk_Geo").setCreaseAngle(1.571).setCoordIndex(getl2disk_Geo_8_129_coordIndex())
                .setCoord(new Coordinate("l2disk_Coord").setPoint(getl2disk_Coord_9_129_point()))))
            .addChild(new Shape("l3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("l3_Geo").setDEF("l3_Geo").setCreaseAngle(1.571).setCoordIndex(getl3_Geo_8_134_coordIndex())
                .setCoord(new Coordinate("l3_Coord").setPoint(getl3_Coord_9_134_point()))))
            .addChild(new Shape("l3disk")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("l3disk_Geo").setDEF("l3disk_Geo").setCreaseAngle(1.571).setCoordIndex(getl3disk_Geo_8_139_coordIndex())
                .setCoord(new Coordinate("l3disk_Coord").setPoint(getl3disk_Coord_9_139_point()))))
            .addChild(new Shape("l4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("l4_Geo").setDEF("l4_Geo").setCreaseAngle(1.571).setCoordIndex(getl4_Geo_8_144_coordIndex())
                .setCoord(new Coordinate("l4_Coord").setPoint(getl4_Coord_9_144_point()))))
            .addChild(new Shape("l4disk")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("l4disk_Geo").setDEF("l4disk_Geo").setCreaseAngle(1.571).setCoordIndex(getl4disk_Geo_8_149_coordIndex())
                .setCoord(new Coordinate("l4disk_Coord").setPoint(getl4disk_Coord_9_149_point()))))
            .addChild(new Shape("l5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("l5_Geo").setDEF("l5_Geo").setCreaseAngle(1.571).setCoordIndex(getl5_Geo_8_154_coordIndex())
                .setCoord(new Coordinate("l5_Coord").setPoint(getl5_Coord_9_154_point()))))
            .addChild(new Shape("l5disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("l5disc_Geo").setDEF("l5disc_Geo").setCreaseAngle(1.571).setCoordIndex(getl5disc_Geo_8_159_coordIndex())
                .setCoord(new Coordinate("l5disc_Coord").setPoint(getl5disc_Coord_9_159_point()))))
            .addChild(new Shape("lacl")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lacl_Geo").setDEF("lacl_Geo").setCreaseAngle(1.571).setCoordIndex(getlacl_Geo_8_164_coordIndex())
                .setCoord(new Coordinate("lacl_Coord").setPoint(getlacl_Coord_9_164_point()))))
            .addChild(new Shape("lacr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lacr_Geo").setDEF("lacr_Geo").setCreaseAngle(1.571).setCoordIndex(getlacr_Geo_8_169_coordIndex())
                .setCoord(new Coordinate("lacr_Coord").setPoint(getlacr_Coord_9_169_point()))))
            .addChild(new Shape("lcalc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lcalc_Geo").setDEF("lcalc_Geo").setCreaseAngle(1.571).setCoordIndex(getlcalc_Geo_8_174_coordIndex())
                .setCoord(new Coordinate("lcalc_Coord").setPoint(getlcalc_Coord_9_174_point()))))
            .addChild(new Shape("lcaninec")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lcaninec_Geo").setDEF("lcaninec_Geo").setCreaseAngle(1.571).setCoordIndex(getlcaninec_Geo_8_179_coordIndex())
                .setCoord(new Coordinate("lcaninec_Coord").setPoint(getlcaninec_Coord_9_179_point()))))
            .addChild(new Shape("lcaniner")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lcaniner_Geo").setDEF("lcaniner_Geo").setCreaseAngle(1.571).setCoordIndex(getlcaniner_Geo_8_184_coordIndex())
                .setCoord(new Coordinate("lcaniner_Coord").setPoint(getlcaniner_Coord_9_184_point()))))
            .addChild(new Shape("lcaninlc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lcaninlc_Geo").setDEF("lcaninlc_Geo").setCreaseAngle(1.571).setCoordIndex(getlcaninlc_Geo_8_189_coordIndex())
                .setCoord(new Coordinate("lcaninlc_Coord").setPoint(getlcaninlc_Coord_9_189_point()))))
            .addChild(new Shape("lcaninlr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lcaninlr_Geo").setDEF("lcaninlr_Geo").setCreaseAngle(1.571).setCoordIndex(getlcaninlr_Geo_8_194_coordIndex())
                .setCoord(new Coordinate("lcaninlr_Coord").setPoint(getlcaninlr_Coord_9_194_point()))))
            .addChild(new Shape("lcaptate")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lcaptate_Geo").setDEF("lcaptate_Geo").setCreaseAngle(1.571).setCoordIndex(getlcaptate_Geo_8_199_coordIndex())
                .setCoord(new Coordinate("lcaptate_Coord").setPoint(getlcaptate_Coord_9_199_point()))))
            .addChild(new Shape("lcartend")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("lcartend_Geo").setDEF("lcartend_Geo").setCreaseAngle(1.571).setCoordIndex(getlcartend_Geo_8_204_coordIndex())
                .setCoord(new Coordinate("lcartend_Coord").setPoint(getlcartend_Coord_9_204_point()))))
            .addChild(new Shape("lccart")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("lccart_Geo").setDEF("lccart_Geo").setCreaseAngle(1.571).setCoordIndex(getlccart_Geo_8_209_coordIndex())
                .setCoord(new Coordinate("lccart_Coord").setPoint(getlccart_Coord_9_209_point()))))
            .addChild(new Shape("lccart2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("lccart2_Geo").setDEF("lccart2_Geo").setCreaseAngle(1.571).setCoordIndex(getlccart2_Geo_8_214_coordIndex())
                .setCoord(new Coordinate("lccart2_Coord").setPoint(getlccart2_Coord_9_214_point()))))
            .addChild(new Shape("lcenincc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lcenincc_Geo").setDEF("lcenincc_Geo").setCreaseAngle(1.571).setCoordIndex(getlcenincc_Geo_8_219_coordIndex())
                .setCoord(new Coordinate("lcenincc_Coord").setPoint(getlcenincc_Coord_9_219_point()))))
            .addChild(new Shape("lcenincr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lcenincr_Geo").setDEF("lcenincr_Geo").setCreaseAngle(1.571).setCoordIndex(getlcenincr_Geo_8_224_coordIndex())
                .setCoord(new Coordinate("lcenincr_Coord").setPoint(getlcenincr_Coord_9_224_point()))))
            .addChild(new Shape("lceninlc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lceninlc_Geo").setDEF("lceninlc_Geo").setCreaseAngle(1.571).setCoordIndex(getlceninlc_Geo_8_229_coordIndex())
                .setCoord(new Coordinate("lceninlc_Coord").setPoint(getlceninlc_Coord_9_229_point()))))
            .addChild(new Shape("lceninlr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lceninlr_Geo").setDEF("lceninlr_Geo").setCreaseAngle(1.571).setCoordIndex(getlceninlr_Geo_8_234_coordIndex())
                .setCoord(new Coordinate("lceninlr_Coord").setPoint(getlceninlr_Coord_9_234_point()))))
            .addChild(new Shape("lclavcle")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lclavcle_Geo").setDEF("lclavcle_Geo").setCreaseAngle(1.571).setCoordIndex(getlclavcle_Geo_8_239_coordIndex())
                .setCoord(new Coordinate("lclavcle_Coord").setPoint(getlclavcle_Coord_9_239_point()))))
            .addChild(new Shape("lcoscart")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("lcoscart_Geo").setDEF("lcoscart_Geo").setCreaseAngle(1.571).setCoordIndex(getlcoscart_Geo_8_244_coordIndex())
                .setCoord(new Coordinate("lcoscart_Coord").setPoint(getlcoscart_Coord_9_244_point()))))
            .addChild(new Shape("lcuboid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.98).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lcuboid_Geo").setDEF("lcuboid_Geo").setCreaseAngle(1.571).setCoordIndex(getlcuboid_Geo_8_249_coordIndex())
                .setCoord(new Coordinate("lcuboid_Coord").setPoint(getlcuboid_Coord_9_249_point()))))
            .addChild(new Shape("ldphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ldphal_Geo").setDEF("ldphal_Geo").setCreaseAngle(1.571).setCoordIndex(getldphal_Geo_8_254_coordIndex())
                .setCoord(new Coordinate("ldphal_Coord").setPoint(getldphal_Coord_9_254_point()))))
            .addChild(new Shape("ldphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ldphal2_Geo").setDEF("ldphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getldphal2_Geo_8_259_coordIndex())
                .setCoord(new Coordinate("ldphal2_Coord").setPoint(getldphal2_Coord_9_259_point()))))
            .addChild(new Shape("ldphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.98).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ldphal3_Geo").setDEF("ldphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getldphal3_Geo_8_264_coordIndex())
                .setCoord(new Coordinate("ldphal3_Coord").setPoint(getldphal3_Coord_9_264_point()))))
            .addChild(new Shape("ldphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ldphal4_Geo").setDEF("ldphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getldphal4_Geo_8_269_coordIndex())
                .setCoord(new Coordinate("ldphal4_Coord").setPoint(getldphal4_Coord_9_269_point()))))
            .addChild(new Shape("ldphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ldphal5_Geo").setDEF("ldphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getldphal5_Geo_8_274_coordIndex())
                .setCoord(new Coordinate("ldphal5_Coord").setPoint(getldphal5_Coord_9_274_point()))))
            .addChild(new Shape("lfdphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfdphal_Geo").setDEF("lfdphal_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal_Geo_8_279_coordIndex())
                .setCoord(new Coordinate("lfdphal_Coord").setPoint(getlfdphal_Coord_9_279_point()))))
            .addChild(new Shape("lfdphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfdphal2_Geo").setDEF("lfdphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal2_Geo_8_284_coordIndex())
                .setCoord(new Coordinate("lfdphal2_Coord").setPoint(getlfdphal2_Coord_9_284_point()))))
            .addChild(new Shape("lfdphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfdphal3_Geo").setDEF("lfdphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal3_Geo_8_289_coordIndex())
                .setCoord(new Coordinate("lfdphal3_Coord").setPoint(getlfdphal3_Coord_9_289_point()))))
            .addChild(new Shape("lfdphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfdphal4_Geo").setDEF("lfdphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal4_Geo_8_294_coordIndex())
                .setCoord(new Coordinate("lfdphal4_Coord").setPoint(getlfdphal4_Coord_9_294_point()))))
            .addChild(new Shape("lfemur")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfemur_Geo").setDEF("lfemur_Geo").setCreaseAngle(1.571).setCoordIndex(getlfemur_Geo_8_299_coordIndex())
                .setCoord(new Coordinate("lfemur_Coord").setPoint(getlfemur_Coord_9_299_point()))))
            .addChild(new Shape("lfibula")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfibula_Geo").setDEF("lfibula_Geo").setCreaseAngle(1.571).setCoordIndex(getlfibula_Geo_8_304_coordIndex())
                .setCoord(new Coordinate("lfibula_Coord").setPoint(getlfibula_Coord_9_304_point()))))
            .addChild(new Shape("lfmet")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfmet_Geo").setDEF("lfmet_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmet_Geo_8_309_coordIndex())
                .setCoord(new Coordinate("lfmet_Coord").setPoint(getlfmet_Coord_9_309_point()))))
            .addChild(new Shape("lfmphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfmphal_Geo").setDEF("lfmphal_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal_Geo_8_314_coordIndex())
                .setCoord(new Coordinate("lfmphal_Coord").setPoint(getlfmphal_Coord_9_314_point()))))
            .addChild(new Shape("lfmphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfmphal2_Geo").setDEF("lfmphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal2_Geo_8_319_coordIndex())
                .setCoord(new Coordinate("lfmphal2_Coord").setPoint(getlfmphal2_Coord_9_319_point()))))
            .addChild(new Shape("lfmphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfmphal3_Geo").setDEF("lfmphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal3_Geo_8_324_coordIndex())
                .setCoord(new Coordinate("lfmphal3_Coord").setPoint(getlfmphal3_Coord_9_324_point()))))
            .addChild(new Shape("lfmphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfmphal4_Geo").setDEF("lfmphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal4_Geo_8_329_coordIndex())
                .setCoord(new Coordinate("lfmphal4_Coord").setPoint(getlfmphal4_Coord_9_329_point()))))
            .addChild(new Shape("lfpprox")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfpprox_Geo").setDEF("lfpprox_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox_Geo_8_334_coordIndex())
                .setCoord(new Coordinate("lfpprox_Coord").setPoint(getlfpprox_Coord_9_334_point()))))
            .addChild(new Shape("lfpprox2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfpprox2_Geo").setDEF("lfpprox2_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox2_Geo_8_339_coordIndex())
                .setCoord(new Coordinate("lfpprox2_Coord").setPoint(getlfpprox2_Coord_9_339_point()))))
            .addChild(new Shape("lfpprox3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfpprox3_Geo").setDEF("lfpprox3_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox3_Geo_8_344_coordIndex())
                .setCoord(new Coordinate("lfpprox3_Coord").setPoint(getlfpprox3_Coord_9_344_point()))))
            .addChild(new Shape("lfpprox4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfpprox4_Geo").setDEF("lfpprox4_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox4_Geo_8_349_coordIndex())
                .setCoord(new Coordinate("lfpprox4_Coord").setPoint(getlfpprox4_Coord_9_349_point()))))
            .addChild(new Shape("lfpprox5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lfpprox5_Geo").setDEF("lfpprox5_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox5_Geo_8_354_coordIndex())
                .setCoord(new Coordinate("lfpprox5_Coord").setPoint(getlfpprox5_Coord_9_354_point()))))
            .addChild(new Shape("lfreecrt")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("lfreecrt_Geo").setDEF("lfreecrt_Geo").setCreaseAngle(1.571).setCoordIndex(getlfreecrt_Geo_8_359_coordIndex())
                .setCoord(new Coordinate("lfreecrt_Coord").setPoint(getlfreecrt_Coord_9_359_point()))))
            .addChild(new Shape("lhamate")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lhamate_Geo").setDEF("lhamate_Geo").setCreaseAngle(1.571).setCoordIndex(getlhamate_Geo_8_364_coordIndex())
                .setCoord(new Coordinate("lhamate_Coord").setPoint(getlhamate_Coord_9_364_point()))))
            .addChild(new Shape("lhumrus")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lhumrus_Geo").setDEF("lhumrus_Geo").setCreaseAngle(1.571).setCoordIndex(getlhumrus_Geo_8_369_coordIndex())
                .setCoord(new Coordinate("lhumrus_Coord").setPoint(getlhumrus_Coord_9_369_point()))))
            .addChild(new Shape("licun")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("licun_Geo").setDEF("licun_Geo").setCreaseAngle(1.571).setCoordIndex(getlicun_Geo_8_374_coordIndex())
                .setCoord(new Coordinate("licun_Coord").setPoint(getlicun_Coord_9_374_point()))))
            .addChild(new Shape("llatincc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("llatincc_Geo").setDEF("llatincc_Geo").setCreaseAngle(1.571).setCoordIndex(getllatincc_Geo_8_379_coordIndex())
                .setCoord(new Coordinate("llatincc_Coord").setPoint(getllatincc_Coord_9_379_point()))))
            .addChild(new Shape("llatincr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("llatincr_Geo").setDEF("llatincr_Geo").setCreaseAngle(1.571).setCoordIndex(getllatincr_Geo_8_384_coordIndex())
                .setCoord(new Coordinate("llatincr_Coord").setPoint(getllatincr_Coord_9_384_point()))))
            .addChild(new Shape("llatinlc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("llatinlc_Geo").setDEF("llatinlc_Geo").setCreaseAngle(1.571).setCoordIndex(getllatinlc_Geo_8_389_coordIndex())
                .setCoord(new Coordinate("llatinlc_Coord").setPoint(getllatinlc_Coord_9_389_point()))))
            .addChild(new Shape("llatinlr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("llatinlr_Geo").setDEF("llatinlr_Geo").setCreaseAngle(1.571).setCoordIndex(getllatinlr_Geo_8_394_coordIndex())
                .setCoord(new Coordinate("llatinlr_Coord").setPoint(getllatinlr_Coord_9_394_point()))))
            .addChild(new Shape("llcun")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("llcun_Geo").setDEF("llcun_Geo").setCreaseAngle(1.571).setCoordIndex(getllcun_Geo_8_399_coordIndex())
                .setCoord(new Coordinate("llcun_Coord").setPoint(getllcun_Coord_9_399_point()))))
            .addChild(new Shape("llunate")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("llunate_Geo").setDEF("llunate_Geo").setCreaseAngle(1.571).setCoordIndex(getllunate_Geo_8_404_coordIndex())
                .setCoord(new Coordinate("llunate_Coord").setPoint(getllunate_Coord_9_404_point()))))
            .addChild(new Shape("lmc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmc_Geo").setDEF("lmc_Geo").setCreaseAngle(1.571).setCoordIndex(getlmc_Geo_8_409_coordIndex())
                .setCoord(new Coordinate("lmc_Coord").setPoint(getlmc_Coord_9_409_point()))))
            .addChild(new Shape("lmc2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmc2_Geo").setDEF("lmc2_Geo").setCreaseAngle(1.571).setCoordIndex(getlmc2_Geo_8_414_coordIndex())
                .setCoord(new Coordinate("lmc2_Coord").setPoint(getlmc2_Coord_9_414_point()))))
            .addChild(new Shape("lmc3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmc3_Geo").setDEF("lmc3_Geo").setCreaseAngle(1.571).setCoordIndex(getlmc3_Geo_8_419_coordIndex())
                .setCoord(new Coordinate("lmc3_Coord").setPoint(getlmc3_Coord_9_419_point()))))
            .addChild(new Shape("lmc4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmc4_Geo").setDEF("lmc4_Geo").setCreaseAngle(1.571).setCoordIndex(getlmc4_Geo_8_424_coordIndex())
                .setCoord(new Coordinate("lmc4_Coord").setPoint(getlmc4_Coord_9_424_point()))))
            .addChild(new Shape("lmc5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmc5_Geo").setDEF("lmc5_Geo").setCreaseAngle(1.571).setCoordIndex(getlmc5_Geo_8_429_coordIndex())
                .setCoord(new Coordinate("lmc5_Coord").setPoint(getlmc5_Coord_9_429_point()))))
            .addChild(new Shape("lmcun")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmcun_Geo").setDEF("lmcun_Geo").setCreaseAngle(1.571).setCoordIndex(getlmcun_Geo_8_434_coordIndex())
                .setCoord(new Coordinate("lmcun_Coord").setPoint(getlmcun_Coord_9_434_point()))))
            .addChild(new Shape("lmet2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmet2_Geo").setDEF("lmet2_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet2_Geo_8_439_coordIndex())
                .setCoord(new Coordinate("lmet2_Coord").setPoint(getlmet2_Coord_9_439_point()))))
            .addChild(new Shape("lmet3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmet3_Geo").setDEF("lmet3_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet3_Geo_8_444_coordIndex())
                .setCoord(new Coordinate("lmet3_Coord").setPoint(getlmet3_Coord_9_444_point()))))
            .addChild(new Shape("lmet4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmet4_Geo").setDEF("lmet4_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet4_Geo_8_449_coordIndex())
                .setCoord(new Coordinate("lmet4_Coord").setPoint(getlmet4_Coord_9_449_point()))))
            .addChild(new Shape("lmet5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmet5_Geo").setDEF("lmet5_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet5_Geo_8_454_coordIndex())
                .setCoord(new Coordinate("lmet5_Coord").setPoint(getlmet5_Coord_9_454_point()))))
            .addChild(new Shape("lmolar1c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolar1c_Geo").setDEF("lmolar1c_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolar1c_Geo_8_459_coordIndex())
                .setCoord(new Coordinate("lmolar1c_Coord").setPoint(getlmolar1c_Coord_9_459_point()))))
            .addChild(new Shape("lmolar1r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolar1r_Geo").setDEF("lmolar1r_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolar1r_Geo_8_464_coordIndex())
                .setCoord(new Coordinate("lmolar1r_Coord").setPoint(getlmolar1r_Coord_9_464_point()))))
            .addChild(new Shape("lmolar2c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolar2c_Geo").setDEF("lmolar2c_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolar2c_Geo_8_469_coordIndex())
                .setCoord(new Coordinate("lmolar2c_Coord").setPoint(getlmolar2c_Coord_9_469_point()))))
            .addChild(new Shape("lmolar2r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolar2r_Geo").setDEF("lmolar2r_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolar2r_Geo_8_474_coordIndex())
                .setCoord(new Coordinate("lmolar2r_Coord").setPoint(getlmolar2r_Coord_9_474_point()))))
            .addChild(new Shape("lmolar3c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolar3c_Geo").setDEF("lmolar3c_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolar3c_Geo_8_479_coordIndex())
                .setCoord(new Coordinate("lmolar3c_Coord").setPoint(getlmolar3c_Coord_9_479_point()))))
            .addChild(new Shape("lmolar3r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolar3r_Geo").setDEF("lmolar3r_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolar3r_Geo_8_484_coordIndex())
                .setCoord(new Coordinate("lmolar3r_Coord").setPoint(getlmolar3r_Coord_9_484_point()))))
            .addChild(new Shape("lmolr1lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolr1lc_Geo").setDEF("lmolr1lc_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolr1lc_Geo_8_489_coordIndex())
                .setCoord(new Coordinate("lmolr1lc_Coord").setPoint(getlmolr1lc_Coord_9_489_point()))))
            .addChild(new Shape("lmolr1lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolr1lr_Geo").setDEF("lmolr1lr_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolr1lr_Geo_8_494_coordIndex())
                .setCoord(new Coordinate("lmolr1lr_Coord").setPoint(getlmolr1lr_Coord_9_494_point()))))
            .addChild(new Shape("lmolr2lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolr2lc_Geo").setDEF("lmolr2lc_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolr2lc_Geo_8_499_coordIndex())
                .setCoord(new Coordinate("lmolr2lc_Coord").setPoint(getlmolr2lc_Coord_9_499_point()))))
            .addChild(new Shape("lmolr2lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolr2lr_Geo").setDEF("lmolr2lr_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolr2lr_Geo_8_504_coordIndex())
                .setCoord(new Coordinate("lmolr2lr_Coord").setPoint(getlmolr2lr_Coord_9_504_point()))))
            .addChild(new Shape("lmolr3lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolr3lc_Geo").setDEF("lmolr3lc_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolr3lc_Geo_8_509_coordIndex())
                .setCoord(new Coordinate("lmolr3lc_Coord").setPoint(getlmolr3lc_Coord_9_509_point()))))
            .addChild(new Shape("lmolr3lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lmolr3lr_Geo").setDEF("lmolr3lr_Geo").setCreaseAngle(1.571).setCoordIndex(getlmolr3lr_Geo_8_514_coordIndex())
                .setCoord(new Coordinate("lmolr3lr_Coord").setPoint(getlmolr3lr_Coord_9_514_point()))))
            .addChild(new Shape("lmphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmphal2_Geo").setDEF("lmphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getlmphal2_Geo_8_519_coordIndex())
                .setCoord(new Coordinate("lmphal2_Coord").setPoint(getlmphal2_Coord_9_519_point()))))
            .addChild(new Shape("lmphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmphal3_Geo").setDEF("lmphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getlmphal3_Geo_8_524_coordIndex())
                .setCoord(new Coordinate("lmphal3_Coord").setPoint(getlmphal3_Coord_9_524_point()))))
            .addChild(new Shape("lmphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmphal4_Geo").setDEF("lmphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getlmphal4_Geo_8_529_coordIndex())
                .setCoord(new Coordinate("lmphal4_Coord").setPoint(getlmphal4_Coord_9_529_point()))))
            .addChild(new Shape("lmphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lmphal5_Geo").setDEF("lmphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getlmphal5_Geo_8_534_coordIndex())
                .setCoord(new Coordinate("lmphal5_Coord").setPoint(getlmphal5_Coord_9_534_point()))))
            .addChild(new Shape("lnaviclr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lnaviclr_Geo").setDEF("lnaviclr_Geo").setCreaseAngle(1.571).setCoordIndex(getlnaviclr_Geo_8_539_coordIndex())
                .setCoord(new Coordinate("lnaviclr_Coord").setPoint(getlnaviclr_Coord_9_539_point()))))
            .addChild(new Shape("loscoxae")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("loscoxae_Geo").setDEF("loscoxae_Geo").setCreaseAngle(1.571).setCoordIndex(getloscoxae_Geo_8_544_coordIndex())
                .setCoord(new Coordinate("loscoxae_Coord").setPoint(getloscoxae_Coord_9_544_point()))))
            .addChild(new Shape("lowleg")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lowleg_Geo").setDEF("lowleg_Geo").setCreaseAngle(1.571).setCoordIndex(getlowleg_Geo_8_549_coordIndex())
                .setCoord(new Coordinate("lowleg_Coord").setPoint(getlowleg_Coord_9_549_point()))))
            .addChild(new Shape("lpisform")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lpisform_Geo").setDEF("lpisform_Geo").setCreaseAngle(1.571).setCoordIndex(getlpisform_Geo_8_554_coordIndex())
                .setCoord(new Coordinate("lpisform_Coord").setPoint(getlpisform_Coord_9_554_point()))))
            .addChild(new Shape("lpphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lpphal_Geo").setDEF("lpphal_Geo").setCreaseAngle(1.571).setCoordIndex(getlpphal_Geo_8_559_coordIndex())
                .setCoord(new Coordinate("lpphal_Coord").setPoint(getlpphal_Coord_9_559_point()))))
            .addChild(new Shape("lpphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lpphal2_Geo").setDEF("lpphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getlpphal2_Geo_8_564_coordIndex())
                .setCoord(new Coordinate("lpphal2_Coord").setPoint(getlpphal2_Coord_9_564_point()))))
            .addChild(new Shape("lpphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lpphal3_Geo").setDEF("lpphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getlpphal3_Geo_8_569_coordIndex())
                .setCoord(new Coordinate("lpphal3_Coord").setPoint(getlpphal3_Coord_9_569_point()))))
            .addChild(new Shape("lpphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lpphal4_Geo").setDEF("lpphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getlpphal4_Geo_8_574_coordIndex())
                .setCoord(new Coordinate("lpphal4_Coord").setPoint(getlpphal4_Coord_9_574_point()))))
            .addChild(new Shape("lpphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lpphal5_Geo").setDEF("lpphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getlpphal5_Geo_8_579_coordIndex())
                .setCoord(new Coordinate("lpphal5_Coord").setPoint(getlpphal5_Coord_9_579_point()))))
            .addChild(new Shape("lprem1lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lprem1lc_Geo").setDEF("lprem1lc_Geo").setCreaseAngle(1.571).setCoordIndex(getlprem1lc_Geo_8_584_coordIndex())
                .setCoord(new Coordinate("lprem1lc_Coord").setPoint(getlprem1lc_Coord_9_584_point()))))
            .addChild(new Shape("lprem1lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lprem1lr_Geo").setDEF("lprem1lr_Geo").setCreaseAngle(1.571).setCoordIndex(getlprem1lr_Geo_8_589_coordIndex())
                .setCoord(new Coordinate("lprem1lr_Coord").setPoint(getlprem1lr_Coord_9_589_point()))))
            .addChild(new Shape("lprem2lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lprem2lc_Geo").setDEF("lprem2lc_Geo").setCreaseAngle(1.571).setCoordIndex(getlprem2lc_Geo_8_594_coordIndex())
                .setCoord(new Coordinate("lprem2lc_Coord").setPoint(getlprem2lc_Coord_9_594_point()))))
            .addChild(new Shape("lprem2lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lprem2lr_Geo").setDEF("lprem2lr_Geo").setCreaseAngle(1.571).setCoordIndex(getlprem2lr_Geo_8_599_coordIndex())
                .setCoord(new Coordinate("lprem2lr_Coord").setPoint(getlprem2lr_Coord_9_599_point()))))
            .addChild(new Shape("lpreo1lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lpreo1lc_Geo").setDEF("lpreo1lc_Geo").setCreaseAngle(1.571).setCoordIndex(getlpreo1lc_Geo_8_604_coordIndex())
                .setCoord(new Coordinate("lpreo1lc_Coord").setPoint(getlpreo1lc_Coord_9_604_point()))))
            .addChild(new Shape("lpreol1r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lpreol1r_Geo").setDEF("lpreol1r_Geo").setCreaseAngle(1.571).setCoordIndex(getlpreol1r_Geo_8_609_coordIndex())
                .setCoord(new Coordinate("lpreol1r_Coord").setPoint(getlpreol1r_Coord_9_609_point()))))
            .addChild(new Shape("lpreol2c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lpreol2c_Geo").setDEF("lpreol2c_Geo").setCreaseAngle(1.571).setCoordIndex(getlpreol2c_Geo_8_614_coordIndex())
                .setCoord(new Coordinate("lpreol2c_Coord").setPoint(getlpreol2c_Coord_9_614_point()))))
            .addChild(new Shape("lpreol2r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("lpreol2r_Geo").setDEF("lpreol2r_Geo").setCreaseAngle(1.571).setCoordIndex(getlpreol2r_Geo_8_619_coordIndex())
                .setCoord(new Coordinate("lpreol2r_Coord").setPoint(getlpreol2r_Coord_9_619_point()))))
            .addChild(new Shape("lradius")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lradius_Geo").setDEF("lradius_Geo").setCreaseAngle(1.571).setCoordIndex(getlradius_Geo_8_624_coordIndex())
                .setCoord(new Coordinate("lradius_Coord").setPoint(getlradius_Coord_9_624_point()))))
            .addChild(new Shape("lrib10")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib10_Geo").setDEF("lrib10_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib10_Geo_8_629_coordIndex())
                .setCoord(new Coordinate("lrib10_Coord").setPoint(getlrib10_Coord_9_629_point()))))
            .addChild(new Shape("lrib11")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib11_Geo").setDEF("lrib11_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib11_Geo_8_634_coordIndex())
                .setCoord(new Coordinate("lrib11_Coord").setPoint(getlrib11_Coord_9_634_point()))))
            .addChild(new Shape("lrib12")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib12_Geo").setDEF("lrib12_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib12_Geo_8_639_coordIndex())
                .setCoord(new Coordinate("lrib12_Coord").setPoint(getlrib12_Coord_9_639_point()))))
            .addChild(new Shape("lrib2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib2_Geo").setDEF("lrib2_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib2_Geo_8_644_coordIndex())
                .setCoord(new Coordinate("lrib2_Coord").setPoint(getlrib2_Coord_9_644_point()))))
            .addChild(new Shape("lrib3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib3_Geo").setDEF("lrib3_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib3_Geo_8_649_coordIndex())
                .setCoord(new Coordinate("lrib3_Coord").setPoint(getlrib3_Coord_9_649_point()))))
            .addChild(new Shape("lrib4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib4_Geo").setDEF("lrib4_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib4_Geo_8_654_coordIndex())
                .setCoord(new Coordinate("lrib4_Coord").setPoint(getlrib4_Coord_9_654_point()))))
            .addChild(new Shape("lrib5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib5_Geo").setDEF("lrib5_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib5_Geo_8_659_coordIndex())
                .setCoord(new Coordinate("lrib5_Coord").setPoint(getlrib5_Coord_9_659_point()))))
            .addChild(new Shape("lrib6")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib6_Geo").setDEF("lrib6_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib6_Geo_8_664_coordIndex())
                .setCoord(new Coordinate("lrib6_Coord").setPoint(getlrib6_Coord_9_664_point()))))
            .addChild(new Shape("lrib7")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib7_Geo").setDEF("lrib7_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib7_Geo_8_669_coordIndex())
                .setCoord(new Coordinate("lrib7_Coord").setPoint(getlrib7_Coord_9_669_point()))))
            .addChild(new Shape("lrib8")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib8_Geo").setDEF("lrib8_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib8_Geo_8_674_coordIndex())
                .setCoord(new Coordinate("lrib8_Coord").setPoint(getlrib8_Coord_9_674_point()))))
            .addChild(new Shape("lrib9")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrib9_Geo").setDEF("lrib9_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib9_Geo_8_679_coordIndex())
                .setCoord(new Coordinate("lrib9_Coord").setPoint(getlrib9_Coord_9_679_point()))))
            .addChild(new Shape("lrrib")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lrrib_Geo").setDEF("lrrib_Geo").setCreaseAngle(1.571).setCoordIndex(getlrrib_Geo_8_684_coordIndex())
                .setCoord(new Coordinate("lrrib_Coord").setPoint(getlrrib_Coord_9_684_point()))))
            .addChild(new Shape("lscapula")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lscapula_Geo").setDEF("lscapula_Geo").setCreaseAngle(1.571).setCoordIndex(getlscapula_Geo_8_689_coordIndex())
                .setCoord(new Coordinate("lscapula_Coord").setPoint(getlscapula_Coord_9_689_point()))))
            .addChild(new Shape("lscphoid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lscphoid_Geo").setDEF("lscphoid_Geo").setCreaseAngle(1.571).setCoordIndex(getlscphoid_Geo_8_694_coordIndex())
                .setCoord(new Coordinate("lscphoid_Coord").setPoint(getlscphoid_Coord_9_694_point()))))
            .addChild(new Shape("ltalus")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ltalus_Geo").setDEF("ltalus_Geo").setCreaseAngle(1.571).setCoordIndex(getltalus_Geo_8_699_coordIndex())
                .setCoord(new Coordinate("ltalus_Coord").setPoint(getltalus_Coord_9_699_point()))))
            .addChild(new Shape("ltibia")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ltibia_Geo").setDEF("ltibia_Geo").setCreaseAngle(1.571).setCoordIndex(getltibia_Geo_8_704_coordIndex())
                .setCoord(new Coordinate("ltibia_Coord").setPoint(getltibia_Coord_9_704_point()))))
            .addChild(new Shape("ltrpzium")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ltrpzium_Geo").setDEF("ltrpzium_Geo").setCreaseAngle(1.571).setCoordIndex(getltrpzium_Geo_8_709_coordIndex())
                .setCoord(new Coordinate("ltrpzium_Coord").setPoint(getltrpzium_Coord_9_709_point()))))
            .addChild(new Shape("ltrpzoid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ltrpzoid_Geo").setDEF("ltrpzoid_Geo").setCreaseAngle(1.571).setCoordIndex(getltrpzoid_Geo_8_714_coordIndex())
                .setCoord(new Coordinate("ltrpzoid_Coord").setPoint(getltrpzoid_Coord_9_714_point()))))
            .addChild(new Shape("ltrqtral")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ltrqtral_Geo").setDEF("ltrqtral_Geo").setCreaseAngle(1.571).setCoordIndex(getltrqtral_Geo_8_719_coordIndex())
                .setCoord(new Coordinate("ltrqtral_Coord").setPoint(getltrqtral_Coord_9_719_point()))))
            .addChild(new Shape("lulna")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lulna_Geo").setDEF("lulna_Geo").setCreaseAngle(1.571).setCoordIndex(getlulna_Geo_8_724_coordIndex())
                .setCoord(new Coordinate("lulna_Coord").setPoint(getlulna_Coord_9_724_point()))))
            .addChild(new Shape("lum")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("lum_Geo").setDEF("lum_Geo").setCreaseAngle(1.571).setCoordIndex(getlum_Geo_8_729_coordIndex())
                .setCoord(new Coordinate("lum_Coord").setPoint(getlum_Coord_9_729_point()))))
            .addChild(new Shape("mand")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("mand_Geo").setDEF("mand_Geo").setCreaseAngle(1.571).setCoordIndex(getmand_Geo_8_734_coordIndex())
                .setCoord(new Coordinate("mand_Coord").setPoint(getmand_Coord_9_734_point()))))
            .addChild(new Shape("maxl")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("maxl_Geo").setDEF("maxl_Geo").setCreaseAngle(1.571).setCoordIndex(getmaxl_Geo_8_739_coordIndex())
                .setCoord(new Coordinate("maxl_Coord").setPoint(getmaxl_Coord_9_739_point()))))
            .addChild(new Shape("maxr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("maxr_Geo").setDEF("maxr_Geo").setCreaseAngle(1.571).setCoordIndex(getmaxr_Geo_8_744_coordIndex())
                .setCoord(new Coordinate("maxr_Coord").setPoint(getmaxr_Coord_9_744_point()))))
            .addChild(new Shape("nasall")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("nasall_Geo").setDEF("nasall_Geo").setCreaseAngle(1.571).setCoordIndex(getnasall_Geo_8_749_coordIndex())
                .setCoord(new Coordinate("nasall_Coord").setPoint(getnasall_Coord_9_749_point()))))
            .addChild(new Shape("nasalr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("nasalr_Geo").setDEF("nasalr_Geo").setCreaseAngle(1.571).setCoordIndex(getnasalr_Geo_8_754_coordIndex())
                .setCoord(new Coordinate("nasalr_Coord").setPoint(getnasalr_Coord_9_754_point()))))
            .addChild(new Shape("occip")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("occip_Geo").setDEF("occip_Geo").setCreaseAngle(1.571).setCoordIndex(getoccip_Geo_8_759_coordIndex())
                .setCoord(new Coordinate("occip_Coord").setPoint(getoccip_Coord_9_759_point()))))
            .addChild(new Shape("palatl")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("palatl_Geo").setDEF("palatl_Geo").setCreaseAngle(1.571).setCoordIndex(getpalatl_Geo_8_764_coordIndex())
                .setCoord(new Coordinate("palatl_Coord").setPoint(getpalatl_Coord_9_764_point()))))
            .addChild(new Shape("palatr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("palatr_Geo").setDEF("palatr_Geo").setCreaseAngle(1.571).setCoordIndex(getpalatr_Geo_8_769_coordIndex())
                .setCoord(new Coordinate("palatr_Coord").setPoint(getpalatr_Coord_9_769_point()))))
            .addChild(new Shape("parietl")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("parietl_Geo").setDEF("parietl_Geo").setCreaseAngle(1.571).setCoordIndex(getparietl_Geo_8_774_coordIndex())
                .setCoord(new Coordinate("parietl_Coord").setPoint(getparietl_Coord_9_774_point()))))
            .addChild(new Shape("parietr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("parietr_Geo").setDEF("parietr_Geo").setCreaseAngle(1.571).setCoordIndex(getparietr_Geo_8_779_coordIndex())
                .setCoord(new Coordinate("parietr_Coord").setPoint(getparietr_Coord_9_779_point()))))
            .addChild(new Shape("rcalc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rcalc_Geo").setDEF("rcalc_Geo").setCreaseAngle(1.571).setCoordIndex(getrcalc_Geo_8_784_coordIndex())
                .setCoord(new Coordinate("rcalc_Coord").setPoint(getrcalc_Coord_9_784_point()))))
            .addChild(new Shape("rcaninec")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rcaninec_Geo").setDEF("rcaninec_Geo").setCreaseAngle(1.571).setCoordIndex(getrcaninec_Geo_8_789_coordIndex())
                .setCoord(new Coordinate("rcaninec_Coord").setPoint(getrcaninec_Coord_9_789_point()))))
            .addChild(new Shape("rcaniner")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rcaniner_Geo").setDEF("rcaniner_Geo").setCreaseAngle(1.571).setCoordIndex(getrcaniner_Geo_8_794_coordIndex())
                .setCoord(new Coordinate("rcaniner_Coord").setPoint(getrcaniner_Coord_9_794_point()))))
            .addChild(new Shape("rcaninlc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rcaninlc_Geo").setDEF("rcaninlc_Geo").setCreaseAngle(1.571).setCoordIndex(getrcaninlc_Geo_8_799_coordIndex())
                .setCoord(new Coordinate("rcaninlc_Coord").setPoint(getrcaninlc_Coord_9_799_point()))))
            .addChild(new Shape("rcaninlr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rcaninlr_Geo").setDEF("rcaninlr_Geo").setCreaseAngle(1.571).setCoordIndex(getrcaninlr_Geo_8_804_coordIndex())
                .setCoord(new Coordinate("rcaninlr_Coord").setPoint(getrcaninlr_Coord_9_804_point()))))
            .addChild(new Shape("rcaptate")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rcaptate_Geo").setDEF("rcaptate_Geo").setCreaseAngle(1.571).setCoordIndex(getrcaptate_Geo_8_809_coordIndex())
                .setCoord(new Coordinate("rcaptate_Coord").setPoint(getrcaptate_Coord_9_809_point()))))
            .addChild(new Shape("rcartend")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("rcartend_Geo").setDEF("rcartend_Geo").setCreaseAngle(1.571).setCoordIndex(getrcartend_Geo_8_814_coordIndex())
                .setCoord(new Coordinate("rcartend_Coord").setPoint(getrcartend_Coord_9_814_point()))))
            .addChild(new Shape("rccart")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("rccart_Geo").setDEF("rccart_Geo").setCreaseAngle(1.571).setCoordIndex(getrccart_Geo_8_819_coordIndex())
                .setCoord(new Coordinate("rccart_Coord").setPoint(getrccart_Coord_9_819_point()))))
            .addChild(new Shape("rccart2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("rccart2_Geo").setDEF("rccart2_Geo").setCreaseAngle(1.571).setCoordIndex(getrccart2_Geo_8_824_coordIndex())
                .setCoord(new Coordinate("rccart2_Coord").setPoint(getrccart2_Coord_9_824_point()))))
            .addChild(new Shape("rcenincc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rcenincc_Geo").setDEF("rcenincc_Geo").setCreaseAngle(1.571).setCoordIndex(getrcenincc_Geo_8_829_coordIndex())
                .setCoord(new Coordinate("rcenincc_Coord").setPoint(getrcenincc_Coord_9_829_point()))))
            .addChild(new Shape("rcenincr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rcenincr_Geo").setDEF("rcenincr_Geo").setCreaseAngle(1.571).setCoordIndex(getrcenincr_Geo_8_834_coordIndex())
                .setCoord(new Coordinate("rcenincr_Coord").setPoint(getrcenincr_Coord_9_834_point()))))
            .addChild(new Shape("rceninlc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rceninlc_Geo").setDEF("rceninlc_Geo").setCreaseAngle(1.571).setCoordIndex(getrceninlc_Geo_8_839_coordIndex())
                .setCoord(new Coordinate("rceninlc_Coord").setPoint(getrceninlc_Coord_9_839_point()))))
            .addChild(new Shape("rceninlr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rceninlr_Geo").setDEF("rceninlr_Geo").setCreaseAngle(1.571).setCoordIndex(getrceninlr_Geo_8_844_coordIndex())
                .setCoord(new Coordinate("rceninlr_Coord").setPoint(getrceninlr_Coord_9_844_point()))))
            .addChild(new Shape("rclavcle")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rclavcle_Geo").setDEF("rclavcle_Geo").setCreaseAngle(1.571).setCoordIndex(getrclavcle_Geo_8_849_coordIndex())
                .setCoord(new Coordinate("rclavcle_Coord").setPoint(getrclavcle_Coord_9_849_point()))))
            .addChild(new Shape("rcoscart")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("rcoscart_Geo").setDEF("rcoscart_Geo").setCreaseAngle(1.571).setCoordIndex(getrcoscart_Geo_8_854_coordIndex())
                .setCoord(new Coordinate("rcoscart_Coord").setPoint(getrcoscart_Coord_9_854_point()))))
            .addChild(new Shape("rcuboid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rcuboid_Geo").setDEF("rcuboid_Geo").setCreaseAngle(1.571).setCoordIndex(getrcuboid_Geo_8_859_coordIndex())
                .setCoord(new Coordinate("rcuboid_Coord").setPoint(getrcuboid_Coord_9_859_point()))))
            .addChild(new Shape("rdphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rdphal_Geo").setDEF("rdphal_Geo").setCreaseAngle(1.571).setCoordIndex(getrdphal_Geo_8_864_coordIndex())
                .setCoord(new Coordinate("rdphal_Coord").setPoint(getrdphal_Coord_9_864_point()))))
            .addChild(new Shape("rdphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rdphal2_Geo").setDEF("rdphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getrdphal2_Geo_8_869_coordIndex())
                .setCoord(new Coordinate("rdphal2_Coord").setPoint(getrdphal2_Coord_9_869_point()))))
            .addChild(new Shape("rdphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rdphal3_Geo").setDEF("rdphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getrdphal3_Geo_8_874_coordIndex())
                .setCoord(new Coordinate("rdphal3_Coord").setPoint(getrdphal3_Coord_9_874_point()))))
            .addChild(new Shape("rdphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rdphal4_Geo").setDEF("rdphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getrdphal4_Geo_8_879_coordIndex())
                .setCoord(new Coordinate("rdphal4_Coord").setPoint(getrdphal4_Coord_9_879_point()))))
            .addChild(new Shape("rdphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rdphal5_Geo").setDEF("rdphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getrdphal5_Geo_8_884_coordIndex())
                .setCoord(new Coordinate("rdphal5_Coord").setPoint(getrdphal5_Coord_9_884_point()))))
            .addChild(new Shape("rfdphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfdphal_Geo").setDEF("rfdphal_Geo").setCreaseAngle(1.571).setCoordIndex(getrfdphal_Geo_8_889_coordIndex())
                .setCoord(new Coordinate("rfdphal_Coord").setPoint(getrfdphal_Coord_9_889_point()))))
            .addChild(new Shape("rfdphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfdphal2_Geo").setDEF("rfdphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getrfdphal2_Geo_8_894_coordIndex())
                .setCoord(new Coordinate("rfdphal2_Coord").setPoint(getrfdphal2_Coord_9_894_point()))))
            .addChild(new Shape("rfdphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfdphal3_Geo").setDEF("rfdphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getrfdphal3_Geo_8_899_coordIndex())
                .setCoord(new Coordinate("rfdphal3_Coord").setPoint(getrfdphal3_Coord_9_899_point()))))
            .addChild(new Shape("rfdphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfdphal4_Geo").setDEF("rfdphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getrfdphal4_Geo_8_904_coordIndex())
                .setCoord(new Coordinate("rfdphal4_Coord").setPoint(getrfdphal4_Coord_9_904_point()))))
            .addChild(new Shape("rfdphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfdphal5_Geo").setDEF("rfdphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getrfdphal5_Geo_8_909_coordIndex())
                .setCoord(new Coordinate("rfdphal5_Coord").setPoint(getrfdphal5_Coord_9_909_point()))))
            .addChild(new Shape("rfemur")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfemur_Geo").setDEF("rfemur_Geo").setCreaseAngle(1.571).setCoordIndex(getrfemur_Geo_8_914_coordIndex())
                .setCoord(new Coordinate("rfemur_Coord").setPoint(getrfemur_Coord_9_914_point()))))
            .addChild(new Shape("rfmet")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfmet_Geo").setDEF("rfmet_Geo").setCreaseAngle(1.571).setCoordIndex(getrfmet_Geo_8_919_coordIndex())
                .setCoord(new Coordinate("rfmet_Coord").setPoint(getrfmet_Coord_9_919_point()))))
            .addChild(new Shape("rfmphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfmphal_Geo").setDEF("rfmphal_Geo").setCreaseAngle(1.571).setCoordIndex(getrfmphal_Geo_8_924_coordIndex())
                .setCoord(new Coordinate("rfmphal_Coord").setPoint(getrfmphal_Coord_9_924_point()))))
            .addChild(new Shape("rfmphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfmphal2_Geo").setDEF("rfmphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getrfmphal2_Geo_8_929_coordIndex())
                .setCoord(new Coordinate("rfmphal2_Coord").setPoint(getrfmphal2_Coord_9_929_point()))))
            .addChild(new Shape("rfmphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfmphal3_Geo").setDEF("rfmphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getrfmphal3_Geo_8_934_coordIndex())
                .setCoord(new Coordinate("rfmphal3_Coord").setPoint(getrfmphal3_Coord_9_934_point()))))
            .addChild(new Shape("rfmphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfmphal4_Geo").setDEF("rfmphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getrfmphal4_Geo_8_939_coordIndex())
                .setCoord(new Coordinate("rfmphal4_Coord").setPoint(getrfmphal4_Coord_9_939_point()))))
            .addChild(new Shape("rfpprox2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfpprox2_Geo").setDEF("rfpprox2_Geo").setCreaseAngle(1.571).setCoordIndex(getrfpprox2_Geo_8_944_coordIndex())
                .setCoord(new Coordinate("rfpprox2_Coord").setPoint(getrfpprox2_Coord_9_944_point()))))
            .addChild(new Shape("rfpprox3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfpprox3_Geo").setDEF("rfpprox3_Geo").setCreaseAngle(1.571).setCoordIndex(getrfpprox3_Geo_8_949_coordIndex())
                .setCoord(new Coordinate("rfpprox3_Coord").setPoint(getrfpprox3_Coord_9_949_point()))))
            .addChild(new Shape("rfpprox4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfpprox4_Geo").setDEF("rfpprox4_Geo").setCreaseAngle(1.571).setCoordIndex(getrfpprox4_Geo_8_954_coordIndex())
                .setCoord(new Coordinate("rfpprox4_Coord").setPoint(getrfpprox4_Coord_9_954_point()))))
            .addChild(new Shape("rfpprox5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfpprox5_Geo").setDEF("rfpprox5_Geo").setCreaseAngle(1.571).setCoordIndex(getrfpprox5_Geo_8_959_coordIndex())
                .setCoord(new Coordinate("rfpprox5_Coord").setPoint(getrfpprox5_Coord_9_959_point()))))
            .addChild(new Shape("rfprox")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rfprox_Geo").setDEF("rfprox_Geo").setCreaseAngle(1.571).setCoordIndex(getrfprox_Geo_8_964_coordIndex())
                .setCoord(new Coordinate("rfprox_Coord").setPoint(getrfprox_Coord_9_964_point()))))
            .addChild(new Shape("rfreecrt")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("rfreecrt_Geo").setDEF("rfreecrt_Geo").setCreaseAngle(1.571).setCoordIndex(getrfreecrt_Geo_8_969_coordIndex())
                .setCoord(new Coordinate("rfreecrt_Coord").setPoint(getrfreecrt_Coord_9_969_point()))))
            .addChild(new Shape("rhamate")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rhamate_Geo").setDEF("rhamate_Geo").setCreaseAngle(1.571).setCoordIndex(getrhamate_Geo_8_974_coordIndex())
                .setCoord(new Coordinate("rhamate_Coord").setPoint(getrhamate_Coord_9_974_point()))))
            .addChild(new Shape("rhumerus")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rhumerus_Geo").setDEF("rhumerus_Geo").setCreaseAngle(1.571).setCoordIndex(getrhumerus_Geo_8_979_coordIndex())
                .setCoord(new Coordinate("rhumerus_Coord").setPoint(getrhumerus_Coord_9_979_point()))))
            .addChild(new Shape("ricun")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("ricun_Geo").setDEF("ricun_Geo").setCreaseAngle(1.571).setCoordIndex(getricun_Geo_8_984_coordIndex())
                .setCoord(new Coordinate("ricun_Coord").setPoint(getricun_Coord_9_984_point()))))
            .addChild(new Shape("rlatincc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rlatincc_Geo").setDEF("rlatincc_Geo").setCreaseAngle(1.571).setCoordIndex(getrlatincc_Geo_8_989_coordIndex())
                .setCoord(new Coordinate("rlatincc_Coord").setPoint(getrlatincc_Coord_9_989_point()))))
            .addChild(new Shape("rlatincr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rlatincr_Geo").setDEF("rlatincr_Geo").setCreaseAngle(1.571).setCoordIndex(getrlatincr_Geo_8_994_coordIndex())
                .setCoord(new Coordinate("rlatincr_Coord").setPoint(getrlatincr_Coord_9_994_point()))))
            .addChild(new Shape("rlatinlc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rlatinlc_Geo").setDEF("rlatinlc_Geo").setCreaseAngle(1.571).setCoordIndex(getrlatinlc_Geo_8_999_coordIndex())
                .setCoord(new Coordinate("rlatinlc_Coord").setPoint(getrlatinlc_Coord_9_999_point()))))
            .addChild(new Shape("rlatinlr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rlatinlr_Geo").setDEF("rlatinlr_Geo").setCreaseAngle(1.571).setCoordIndex(getrlatinlr_Geo_8_1004_coordIndex())
                .setCoord(new Coordinate("rlatinlr_Coord").setPoint(getrlatinlr_Coord_9_1004_point()))))
            .addChild(new Shape("rlcun")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rlcun_Geo").setDEF("rlcun_Geo").setCreaseAngle(1.571).setCoordIndex(getrlcun_Geo_8_1009_coordIndex())
                .setCoord(new Coordinate("rlcun_Coord").setPoint(getrlcun_Coord_9_1009_point()))))
            .addChild(new Shape("rlunate")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rlunate_Geo").setDEF("rlunate_Geo").setCreaseAngle(1.571).setCoordIndex(getrlunate_Geo_8_1014_coordIndex())
                .setCoord(new Coordinate("rlunate_Coord").setPoint(getrlunate_Coord_9_1014_point()))))
            .addChild(new Shape("rmc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmc_Geo").setDEF("rmc_Geo").setCreaseAngle(1.571).setCoordIndex(getrmc_Geo_8_1019_coordIndex())
                .setCoord(new Coordinate("rmc_Coord").setPoint(getrmc_Coord_9_1019_point()))))
            .addChild(new Shape("rmc2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmc2_Geo").setDEF("rmc2_Geo").setCreaseAngle(1.571).setCoordIndex(getrmc2_Geo_8_1024_coordIndex())
                .setCoord(new Coordinate("rmc2_Coord").setPoint(getrmc2_Coord_9_1024_point()))))
            .addChild(new Shape("rmc3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmc3_Geo").setDEF("rmc3_Geo").setCreaseAngle(1.571).setCoordIndex(getrmc3_Geo_8_1029_coordIndex())
                .setCoord(new Coordinate("rmc3_Coord").setPoint(getrmc3_Coord_9_1029_point()))))
            .addChild(new Shape("rmc4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmc4_Geo").setDEF("rmc4_Geo").setCreaseAngle(1.571).setCoordIndex(getrmc4_Geo_8_1034_coordIndex())
                .setCoord(new Coordinate("rmc4_Coord").setPoint(getrmc4_Coord_9_1034_point()))))
            .addChild(new Shape("rmc5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmc5_Geo").setDEF("rmc5_Geo").setCreaseAngle(1.571).setCoordIndex(getrmc5_Geo_8_1039_coordIndex())
                .setCoord(new Coordinate("rmc5_Coord").setPoint(getrmc5_Coord_9_1039_point()))))
            .addChild(new Shape("rmcun")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmcun_Geo").setDEF("rmcun_Geo").setCreaseAngle(1.571).setCoordIndex(getrmcun_Geo_8_1044_coordIndex())
                .setCoord(new Coordinate("rmcun_Coord").setPoint(getrmcun_Coord_9_1044_point()))))
            .addChild(new Shape("rmet2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmet2_Geo").setDEF("rmet2_Geo").setCreaseAngle(1.571).setCoordIndex(getrmet2_Geo_8_1049_coordIndex())
                .setCoord(new Coordinate("rmet2_Coord").setPoint(getrmet2_Coord_9_1049_point()))))
            .addChild(new Shape("rmet3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmet3_Geo").setDEF("rmet3_Geo").setCreaseAngle(1.571).setCoordIndex(getrmet3_Geo_8_1054_coordIndex())
                .setCoord(new Coordinate("rmet3_Coord").setPoint(getrmet3_Coord_9_1054_point()))))
            .addChild(new Shape("rmet4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmet4_Geo").setDEF("rmet4_Geo").setCreaseAngle(1.571).setCoordIndex(getrmet4_Geo_8_1059_coordIndex())
                .setCoord(new Coordinate("rmet4_Coord").setPoint(getrmet4_Coord_9_1059_point()))))
            .addChild(new Shape("rmet5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmet5_Geo").setDEF("rmet5_Geo").setCreaseAngle(1.571).setCoordIndex(getrmet5_Geo_8_1064_coordIndex())
                .setCoord(new Coordinate("rmet5_Coord").setPoint(getrmet5_Coord_9_1064_point()))))
            .addChild(new Shape("rmolar1c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolar1c_Geo").setDEF("rmolar1c_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolar1c_Geo_8_1069_coordIndex())
                .setCoord(new Coordinate("rmolar1c_Coord").setPoint(getrmolar1c_Coord_9_1069_point()))))
            .addChild(new Shape("rmolar1r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolar1r_Geo").setDEF("rmolar1r_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolar1r_Geo_8_1074_coordIndex())
                .setCoord(new Coordinate("rmolar1r_Coord").setPoint(getrmolar1r_Coord_9_1074_point()))))
            .addChild(new Shape("rmolar2c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolar2c_Geo").setDEF("rmolar2c_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolar2c_Geo_8_1079_coordIndex())
                .setCoord(new Coordinate("rmolar2c_Coord").setPoint(getrmolar2c_Coord_9_1079_point()))))
            .addChild(new Shape("rmolar2r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolar2r_Geo").setDEF("rmolar2r_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolar2r_Geo_8_1084_coordIndex())
                .setCoord(new Coordinate("rmolar2r_Coord").setPoint(getrmolar2r_Coord_9_1084_point()))))
            .addChild(new Shape("rmolar3c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolar3c_Geo").setDEF("rmolar3c_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolar3c_Geo_8_1089_coordIndex())
                .setCoord(new Coordinate("rmolar3c_Coord").setPoint(getrmolar3c_Coord_9_1089_point()))))
            .addChild(new Shape("rmolar3r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolar3r_Geo").setDEF("rmolar3r_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolar3r_Geo_8_1094_coordIndex())
                .setCoord(new Coordinate("rmolar3r_Coord").setPoint(getrmolar3r_Coord_9_1094_point()))))
            .addChild(new Shape("rmolr1lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolr1lc_Geo").setDEF("rmolr1lc_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolr1lc_Geo_8_1099_coordIndex())
                .setCoord(new Coordinate("rmolr1lc_Coord").setPoint(getrmolr1lc_Coord_9_1099_point()))))
            .addChild(new Shape("rmolr1lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolr1lr_Geo").setDEF("rmolr1lr_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolr1lr_Geo_8_1104_coordIndex())
                .setCoord(new Coordinate("rmolr1lr_Coord").setPoint(getrmolr1lr_Coord_9_1104_point()))))
            .addChild(new Shape("rmolr2lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolr2lc_Geo").setDEF("rmolr2lc_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolr2lc_Geo_8_1109_coordIndex())
                .setCoord(new Coordinate("rmolr2lc_Coord").setPoint(getrmolr2lc_Coord_9_1109_point()))))
            .addChild(new Shape("rmolr2lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolr2lr_Geo").setDEF("rmolr2lr_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolr2lr_Geo_8_1114_coordIndex())
                .setCoord(new Coordinate("rmolr2lr_Coord").setPoint(getrmolr2lr_Coord_9_1114_point()))))
            .addChild(new Shape("rmolr3lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolr3lc_Geo").setDEF("rmolr3lc_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolr3lc_Geo_8_1119_coordIndex())
                .setCoord(new Coordinate("rmolr3lc_Coord").setPoint(getrmolr3lc_Coord_9_1119_point()))))
            .addChild(new Shape("rmolr3lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rmolr3lr_Geo").setDEF("rmolr3lr_Geo").setCreaseAngle(1.571).setCoordIndex(getrmolr3lr_Geo_8_1124_coordIndex())
                .setCoord(new Coordinate("rmolr3lr_Coord").setPoint(getrmolr3lr_Coord_9_1124_point()))))
            .addChild(new Shape("rmphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmphal2_Geo").setDEF("rmphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getrmphal2_Geo_8_1129_coordIndex())
                .setCoord(new Coordinate("rmphal2_Coord").setPoint(getrmphal2_Coord_9_1129_point()))))
            .addChild(new Shape("rmphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmphal3_Geo").setDEF("rmphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getrmphal3_Geo_8_1134_coordIndex())
                .setCoord(new Coordinate("rmphal3_Coord").setPoint(getrmphal3_Coord_9_1134_point()))))
            .addChild(new Shape("rmphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmphal4_Geo").setDEF("rmphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getrmphal4_Geo_8_1139_coordIndex())
                .setCoord(new Coordinate("rmphal4_Coord").setPoint(getrmphal4_Coord_9_1139_point()))))
            .addChild(new Shape("rmphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rmphal5_Geo").setDEF("rmphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getrmphal5_Geo_8_1144_coordIndex())
                .setCoord(new Coordinate("rmphal5_Coord").setPoint(getrmphal5_Coord_9_1144_point()))))
            .addChild(new Shape("rnaviclr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rnaviclr_Geo").setDEF("rnaviclr_Geo").setCreaseAngle(1.571).setCoordIndex(getrnaviclr_Geo_8_1149_coordIndex())
                .setCoord(new Coordinate("rnaviclr_Coord").setPoint(getrnaviclr_Coord_9_1149_point()))))
            .addChild(new Shape("roscoxae")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("roscoxae_Geo").setDEF("roscoxae_Geo").setCreaseAngle(1.571).setCoordIndex(getroscoxae_Geo_8_1154_coordIndex())
                .setCoord(new Coordinate("roscoxae_Coord").setPoint(getroscoxae_Coord_9_1154_point()))))
            .addChild(new Shape("rpisform")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rpisform_Geo").setDEF("rpisform_Geo").setCreaseAngle(1.571).setCoordIndex(getrpisform_Geo_8_1159_coordIndex())
                .setCoord(new Coordinate("rpisform_Coord").setPoint(getrpisform_Coord_9_1159_point()))))
            .addChild(new Shape("rpphal")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rpphal_Geo").setDEF("rpphal_Geo").setCreaseAngle(1.571).setCoordIndex(getrpphal_Geo_8_1164_coordIndex())
                .setCoord(new Coordinate("rpphal_Coord").setPoint(getrpphal_Coord_9_1164_point()))))
            .addChild(new Shape("rpphal2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rpphal2_Geo").setDEF("rpphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getrpphal2_Geo_8_1169_coordIndex())
                .setCoord(new Coordinate("rpphal2_Coord").setPoint(getrpphal2_Coord_9_1169_point()))))
            .addChild(new Shape("rpphal3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rpphal3_Geo").setDEF("rpphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getrpphal3_Geo_8_1174_coordIndex())
                .setCoord(new Coordinate("rpphal3_Coord").setPoint(getrpphal3_Coord_9_1174_point()))))
            .addChild(new Shape("rpphal4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rpphal4_Geo").setDEF("rpphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getrpphal4_Geo_8_1179_coordIndex())
                .setCoord(new Coordinate("rpphal4_Coord").setPoint(getrpphal4_Coord_9_1179_point()))))
            .addChild(new Shape("rpphal5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rpphal5_Geo").setDEF("rpphal5_Geo").setCreaseAngle(1.571).setCoordIndex(getrpphal5_Geo_8_1184_coordIndex())
                .setCoord(new Coordinate("rpphal5_Coord").setPoint(getrpphal5_Coord_9_1184_point()))))
            .addChild(new Shape("rprem1lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rprem1lc_Geo").setDEF("rprem1lc_Geo").setCreaseAngle(1.571).setCoordIndex(getrprem1lc_Geo_8_1189_coordIndex())
                .setCoord(new Coordinate("rprem1lc_Coord").setPoint(getrprem1lc_Coord_9_1189_point()))))
            .addChild(new Shape("rprem1lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rprem1lr_Geo").setDEF("rprem1lr_Geo").setCreaseAngle(1.571).setCoordIndex(getrprem1lr_Geo_8_1194_coordIndex())
                .setCoord(new Coordinate("rprem1lr_Coord").setPoint(getrprem1lr_Coord_9_1194_point()))))
            .addChild(new Shape("rprem2lc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rprem2lc_Geo").setDEF("rprem2lc_Geo").setCreaseAngle(1.571).setCoordIndex(getrprem2lc_Geo_8_1199_coordIndex())
                .setCoord(new Coordinate("rprem2lc_Coord").setPoint(getrprem2lc_Coord_9_1199_point()))))
            .addChild(new Shape("rprem2lr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rprem2lr_Geo").setDEF("rprem2lr_Geo").setCreaseAngle(1.571).setCoordIndex(getrprem2lr_Geo_8_1204_coordIndex())
                .setCoord(new Coordinate("rprem2lr_Coord").setPoint(getrprem2lr_Coord_9_1204_point()))))
            .addChild(new Shape("rpreol1c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rpreol1c_Geo").setDEF("rpreol1c_Geo").setCreaseAngle(1.571).setCoordIndex(getrpreol1c_Geo_8_1209_coordIndex())
                .setCoord(new Coordinate("rpreol1c_Coord").setPoint(getrpreol1c_Coord_9_1209_point()))))
            .addChild(new Shape("rpreol1r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rpreol1r_Geo").setDEF("rpreol1r_Geo").setCreaseAngle(1.571).setCoordIndex(getrpreol1r_Geo_8_1214_coordIndex())
                .setCoord(new Coordinate("rpreol1r_Coord").setPoint(getrpreol1r_Coord_9_1214_point()))))
            .addChild(new Shape("rpreol2c")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rpreol2c_Geo").setDEF("rpreol2c_Geo").setCreaseAngle(1.571).setCoordIndex(getrpreol2c_Geo_8_1219_coordIndex())
                .setCoord(new Coordinate("rpreol2c_Coord").setPoint(getrpreol2c_Coord_9_1219_point()))))
            .addChild(new Shape("rpreol2r")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.400).setDiffuseColor(1.0,.9843,.9843).setShininess(0.050)))
              .setGeometry(new IndexedFaceSet("rpreol2r_Geo").setDEF("rpreol2r_Geo").setCreaseAngle(1.571).setCoordIndex(getrpreol2r_Geo_8_1224_coordIndex())
                .setCoord(new Coordinate("rpreol2r_Coord").setPoint(getrpreol2r_Coord_9_1224_point()))))
            .addChild(new Shape("rradius")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rradius_Geo").setDEF("rradius_Geo").setCreaseAngle(1.571).setCoordIndex(getrradius_Geo_8_1229_coordIndex())
                .setCoord(new Coordinate("rradius_Coord").setPoint(getrradius_Coord_9_1229_point()))))
            .addChild(new Shape("rrib10")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib10_Geo").setDEF("rrib10_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib10_Geo_8_1234_coordIndex())
                .setCoord(new Coordinate("rrib10_Coord").setPoint(getrrib10_Coord_9_1234_point()))))
            .addChild(new Shape("rrib11")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib11_Geo").setDEF("rrib11_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib11_Geo_8_1239_coordIndex())
                .setCoord(new Coordinate("rrib11_Coord").setPoint(getrrib11_Coord_9_1239_point()))))
            .addChild(new Shape("rrib12")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib12_Geo").setDEF("rrib12_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib12_Geo_8_1244_coordIndex())
                .setCoord(new Coordinate("rrib12_Coord").setPoint(getrrib12_Coord_9_1244_point()))))
            .addChild(new Shape("rrib2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib2_Geo").setDEF("rrib2_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib2_Geo_8_1249_coordIndex())
                .setCoord(new Coordinate("rrib2_Coord").setPoint(getrrib2_Coord_9_1249_point()))))
            .addChild(new Shape("rrib3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib3_Geo").setDEF("rrib3_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib3_Geo_8_1254_coordIndex())
                .setCoord(new Coordinate("rrib3_Coord").setPoint(getrrib3_Coord_9_1254_point()))))
            .addChild(new Shape("rrib4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib4_Geo").setDEF("rrib4_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib4_Geo_8_1259_coordIndex())
                .setCoord(new Coordinate("rrib4_Coord").setPoint(getrrib4_Coord_9_1259_point()))))
            .addChild(new Shape("rrib5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib5_Geo").setDEF("rrib5_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib5_Geo_8_1264_coordIndex())
                .setCoord(new Coordinate("rrib5_Coord").setPoint(getrrib5_Coord_9_1264_point()))))
            .addChild(new Shape("rrib6")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib6_Geo").setDEF("rrib6_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib6_Geo_8_1269_coordIndex())
                .setCoord(new Coordinate("rrib6_Coord").setPoint(getrrib6_Coord_9_1269_point()))))
            .addChild(new Shape("rrib7")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib7_Geo").setDEF("rrib7_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib7_Geo_8_1274_coordIndex())
                .setCoord(new Coordinate("rrib7_Coord").setPoint(getrrib7_Coord_9_1274_point()))))
            .addChild(new Shape("rrib8")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib8_Geo").setDEF("rrib8_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib8_Geo_8_1279_coordIndex())
                .setCoord(new Coordinate("rrib8_Coord").setPoint(getrrib8_Coord_9_1279_point()))))
            .addChild(new Shape("rrib9")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrib9_Geo").setDEF("rrib9_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib9_Geo_8_1284_coordIndex())
                .setCoord(new Coordinate("rrib9_Coord").setPoint(getrrib9_Coord_9_1284_point()))))
            .addChild(new Shape("rrrib")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rrrib_Geo").setDEF("rrrib_Geo").setCreaseAngle(1.571).setCoordIndex(getrrrib_Geo_8_1289_coordIndex())
                .setCoord(new Coordinate("rrrib_Coord").setPoint(getrrrib_Coord_9_1289_point()))))
            .addChild(new Shape("rscapula")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rscapula_Geo").setDEF("rscapula_Geo").setCreaseAngle(1.571).setCoordIndex(getrscapula_Geo_8_1294_coordIndex())
                .setCoord(new Coordinate("rscapula_Coord").setPoint(getrscapula_Coord_9_1294_point()))))
            .addChild(new Shape("rscphoid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rscphoid_Geo").setDEF("rscphoid_Geo").setCreaseAngle(1.571).setCoordIndex(getrscphoid_Geo_8_1299_coordIndex())
                .setCoord(new Coordinate("rscphoid_Coord").setPoint(getrscphoid_Coord_9_1299_point()))))
            .addChild(new Shape("rtalus")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rtalus_Geo").setDEF("rtalus_Geo").setCreaseAngle(1.571).setCoordIndex(getrtalus_Geo_8_1304_coordIndex())
                .setCoord(new Coordinate("rtalus_Coord").setPoint(getrtalus_Coord_9_1304_point()))))
            .addChild(new Shape("rtibia")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rtibia_Geo").setDEF("rtibia_Geo").setCreaseAngle(1.571).setCoordIndex(getrtibia_Geo_8_1309_coordIndex())
                .setCoord(new Coordinate("rtibia_Coord").setPoint(getrtibia_Coord_9_1309_point()))))
            .addChild(new Shape("rtrpzium")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rtrpzium_Geo").setDEF("rtrpzium_Geo").setCreaseAngle(1.571).setCoordIndex(getrtrpzium_Geo_8_1314_coordIndex())
                .setCoord(new Coordinate("rtrpzium_Coord").setPoint(getrtrpzium_Coord_9_1314_point()))))
            .addChild(new Shape("rtrpzoid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rtrpzoid_Geo").setDEF("rtrpzoid_Geo").setCreaseAngle(1.571).setCoordIndex(getrtrpzoid_Geo_8_1319_coordIndex())
                .setCoord(new Coordinate("rtrpzoid_Coord").setPoint(getrtrpzoid_Coord_9_1319_point()))))
            .addChild(new Shape("rtrqtral")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rtrqtral_Geo").setDEF("rtrqtral_Geo").setCreaseAngle(1.571).setCoordIndex(getrtrqtral_Geo_8_1324_coordIndex())
                .setCoord(new Coordinate("rtrqtral_Coord").setPoint(getrtrqtral_Coord_9_1324_point()))))
            .addChild(new Shape("rulna")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("rulna_Geo").setDEF("rulna_Geo").setCreaseAngle(1.571).setCoordIndex(getrulna_Geo_8_1329_coordIndex())
                .setCoord(new Coordinate("rulna_Coord").setPoint(getrulna_Coord_9_1329_point()))))
            .addChild(new Shape("sacrum")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("sacrum_Geo").setDEF("sacrum_Geo").setCreaseAngle(1.571).setCoordIndex(getsacrum_Geo_8_1334_coordIndex())
                .setCoord(new Coordinate("sacrum_Coord").setPoint(getsacrum_Coord_9_1334_point()))))
            .addChild(new Shape("sphenoid")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("sphenoid_Geo").setDEF("sphenoid_Geo").setCreaseAngle(1.571).setCoordIndex(getsphenoid_Geo_8_1339_coordIndex())
                .setCoord(new Coordinate("sphenoid_Coord").setPoint(getsphenoid_Coord_9_1339_point()))))
            .addChild(new Shape("sternum")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("sternum_Geo").setDEF("sternum_Geo").setCreaseAngle(1.571).setCoordIndex(getsternum_Geo_8_1344_coordIndex())
                .setCoord(new Coordinate("sternum_Coord").setPoint(getsternum_Coord_9_1344_point()))))
            .addChild(new Shape("sympubis")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("sympubis_Geo").setDEF("sympubis_Geo").setCreaseAngle(1.571).setCoordIndex(getsympubis_Geo_8_1349_coordIndex())
                .setCoord(new Coordinate("sympubis_Coord").setPoint(getsympubis_Coord_9_1349_point()))))
            .addChild(new Shape("t")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t_Geo").setDEF("t_Geo").setCreaseAngle(1.571).setCoordIndex(gett_Geo_8_1354_coordIndex())
                .setCoord(new Coordinate("t_Coord").setPoint(gett_Coord_9_1354_point()))))
            .addChild(new Shape("t10")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t10_Geo").setDEF("t10_Geo").setCreaseAngle(1.571).setCoordIndex(gett10_Geo_8_1359_coordIndex())
                .setCoord(new Coordinate("t10_Coord").setPoint(gett10_Coord_9_1359_point()))))
            .addChild(new Shape("t10disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t10disc_Geo").setDEF("t10disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett10disc_Geo_8_1364_coordIndex())
                .setCoord(new Coordinate("t10disc_Coord").setPoint(gett10disc_Coord_9_1364_point()))))
            .addChild(new Shape("t11")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t11_Geo").setDEF("t11_Geo").setCreaseAngle(1.571).setCoordIndex(gett11_Geo_8_1369_coordIndex())
                .setCoord(new Coordinate("t11_Coord").setPoint(gett11_Coord_9_1369_point()))))
            .addChild(new Shape("t11disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t11disc_Geo").setDEF("t11disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett11disc_Geo_8_1374_coordIndex())
                .setCoord(new Coordinate("t11disc_Coord").setPoint(gett11disc_Coord_9_1374_point()))))
            .addChild(new Shape("t12")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t12_Geo").setDEF("t12_Geo").setCreaseAngle(1.571).setCoordIndex(gett12_Geo_8_1379_coordIndex())
                .setCoord(new Coordinate("t12_Coord").setPoint(gett12_Coord_9_1379_point()))))
            .addChild(new Shape("t12disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t12disc_Geo").setDEF("t12disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett12disc_Geo_8_1384_coordIndex())
                .setCoord(new Coordinate("t12disc_Coord").setPoint(gett12disc_Coord_9_1384_point()))))
            .addChild(new Shape("t1disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t1disc_Geo").setDEF("t1disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett1disc_Geo_8_1389_coordIndex())
                .setCoord(new Coordinate("t1disc_Coord").setPoint(gett1disc_Coord_9_1389_point()))))
            .addChild(new Shape("t2")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t2_Geo").setDEF("t2_Geo").setCreaseAngle(1.571).setCoordIndex(gett2_Geo_8_1394_coordIndex())
                .setCoord(new Coordinate("t2_Coord").setPoint(gett2_Coord_9_1394_point()))))
            .addChild(new Shape("t2disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t2disc_Geo").setDEF("t2disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett2disc_Geo_8_1399_coordIndex())
                .setCoord(new Coordinate("t2disc_Coord").setPoint(gett2disc_Coord_9_1399_point()))))
            .addChild(new Shape("t3")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t3_Geo").setDEF("t3_Geo").setCreaseAngle(1.571).setCoordIndex(gett3_Geo_8_1404_coordIndex())
                .setCoord(new Coordinate("t3_Coord").setPoint(gett3_Coord_9_1404_point()))))
            .addChild(new Shape("t3disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t3disc_Geo").setDEF("t3disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett3disc_Geo_8_1409_coordIndex())
                .setCoord(new Coordinate("t3disc_Coord").setPoint(gett3disc_Coord_9_1409_point()))))
            .addChild(new Shape("t4")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t4_Geo").setDEF("t4_Geo").setCreaseAngle(1.571).setCoordIndex(gett4_Geo_8_1414_coordIndex())
                .setCoord(new Coordinate("t4_Coord").setPoint(gett4_Coord_9_1414_point()))))
            .addChild(new Shape("t4disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t4disc_Geo").setDEF("t4disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett4disc_Geo_8_1419_coordIndex())
                .setCoord(new Coordinate("t4disc_Coord").setPoint(gett4disc_Coord_9_1419_point()))))
            .addChild(new Shape("t5")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t5_Geo").setDEF("t5_Geo").setCreaseAngle(1.571).setCoordIndex(gett5_Geo_8_1424_coordIndex())
                .setCoord(new Coordinate("t5_Coord").setPoint(gett5_Coord_9_1424_point()))))
            .addChild(new Shape("t5disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t5disc_Geo").setDEF("t5disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett5disc_Geo_8_1429_coordIndex())
                .setCoord(new Coordinate("t5disc_Coord").setPoint(gett5disc_Coord_9_1429_point()))))
            .addChild(new Shape("t6")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t6_Geo").setDEF("t6_Geo").setCreaseAngle(1.571).setCoordIndex(gett6_Geo_8_1434_coordIndex())
                .setCoord(new Coordinate("t6_Coord").setPoint(gett6_Coord_9_1434_point()))))
            .addChild(new Shape("t6disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t6disc_Geo").setDEF("t6disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett6disc_Geo_8_1439_coordIndex())
                .setCoord(new Coordinate("t6disc_Coord").setPoint(gett6disc_Coord_9_1439_point()))))
            .addChild(new Shape("t7")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t7_Geo").setDEF("t7_Geo").setCreaseAngle(1.571).setCoordIndex(gett7_Geo_8_1444_coordIndex())
                .setCoord(new Coordinate("t7_Coord").setPoint(gett7_Coord_9_1444_point()))))
            .addChild(new Shape("t7disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t7disc_Geo").setDEF("t7disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett7disc_Geo_8_1449_coordIndex())
                .setCoord(new Coordinate("t7disc_Coord").setPoint(gett7disc_Coord_9_1449_point()))))
            .addChild(new Shape("t8")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t8_Geo").setDEF("t8_Geo").setCreaseAngle(1.571).setCoordIndex(gett8_Geo_8_1454_coordIndex())
                .setCoord(new Coordinate("t8_Coord").setPoint(gett8_Coord_9_1454_point()))))
            .addChild(new Shape("t8disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t8disc_Geo").setDEF("t8disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett8disc_Geo_8_1459_coordIndex())
                .setCoord(new Coordinate("t8disc_Coord").setPoint(gett8disc_Coord_9_1459_point()))))
            .addChild(new Shape("t9")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("t9_Geo").setDEF("t9_Geo").setCreaseAngle(1.571).setCoordIndex(gett9_Geo_8_1464_coordIndex())
                .setCoord(new Coordinate("t9_Coord").setPoint(gett9_Coord_9_1464_point()))))
            .addChild(new Shape("t9disc")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
              .setGeometry(new IndexedFaceSet("t9disc_Geo").setDEF("t9disc_Geo").setCreaseAngle(1.571).setCoordIndex(gett9disc_Geo_8_1469_coordIndex())
                .setCoord(new Coordinate("t9disc_Coord").setPoint(gett9disc_Coord_9_1469_point()))))
            .addChild(new Shape("templ")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("templ_Geo").setDEF("templ_Geo").setCreaseAngle(1.571).setCoordIndex(gettempl_Geo_8_1474_coordIndex())
                .setCoord(new Coordinate("templ_Coord").setPoint(gettempl_Coord_9_1474_point()))))
            .addChild(new Shape("tempr")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("tempr_Geo").setDEF("tempr_Geo").setCreaseAngle(1.571).setCoordIndex(gettempr_Geo_8_1479_coordIndex())
                .setCoord(new Coordinate("tempr_Coord").setPoint(gettempr_Coord_9_1479_point()))))
            .addChild(new Shape("vom")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("vom_Geo").setDEF("vom_Geo").setCreaseAngle(1.571).setCoordIndex(getvom_Geo_8_1484_coordIndex())
                .setCoord(new Coordinate("vom_Coord").setPoint(getvom_Coord_9_1484_point()))))
            .addChild(new Shape("zygol")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("zygol_Geo").setDEF("zygol_Geo").setCreaseAngle(1.571).setCoordIndex(getzygol_Geo_8_1489_coordIndex())
                .setCoord(new Coordinate("zygol_Coord").setPoint(getzygol_Coord_9_1489_point()))))
            .addChild(new Shape("zygor")
              .setAppearance(new Appearance()
                .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setShininess(0.050).setSpecularColor(.349,.349,.349)))
              .setGeometry(new IndexedFaceSet("zygor_Geo").setDEF("zygor_Geo").setCreaseAngle(1.571).setCoordIndex(getzygor_Geo_8_1494_coordIndex())
                .setCoord(new Coordinate("zygor_Coord").setPoint(getzygor_Coord_9_1494_point())))))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getatlas_Geo_8_24_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,3,7,-1,8,9,10,-1,11,12,13,-1,14,6,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,22,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,32,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,52,51,53,-1,48,54,55,-1,36,52,54,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,58,-1,40,39,73,-1,74,75,76,-1,77,78,79,-1,80,81,79,-1,39,82,73,-1,43,42,83,-1,84,85,77,-1,86,87,88,-1,72,89,90,-1,91,59,92,-1,11,65,93,-1,94,95,96,-1,97,98,96,-1,99,100,101,-1,102,103,100,-1,103,104,105,-1,72,71,106,-1,107,108,109,-1,30,110,111,-1,112,113,114,-1,115,116,117,-1,117,118,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,89,135,136,-1,137,138,139,-1,140,141,142,-1,143,144,145,-1,146,147,148,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,149,9,161,-1,162,163,164,-1,165,166,167,-1,168,169,170,-1,171,172,173,-1,174,175,176,-1,170,177,178,-1,173,168,179,-1,180,181,182,-1,172,183,184,-1,184,185,186,-1,187,188,189,-1,190,191,192,-1,193,194,156,-1,195,196,197,-1,198,181,180,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,200,209,-1,116,210,211,-1,212,109,213,-1,214,215,213,-1,216,217,218,-1,219,64,59,-1,220,221,222,-1,223,224,225,-1,226,224,189,-1,227,131,130,-1,228,229,230,-1,229,219,231,-1,232,233,234,-1,235,236,237,-1,238,239,240,-1,17,240,18,-1,241,242,148,-1,243,17,244,-1,245,246,27,-1,247,248,249,-1,145,250,251,-1,252,253,254,-1,255,256,257,-1,203,258,235,-1,259,21,260,-1,261,234,262,-1,263,5,262,-1,264,265,266,-1,267,268,269,-1,270,271,272,-1,273,274,252,-1,275,143,141,-1,276,246,277,-1,278,279,247,-1,280,147,146,-1,76,281,282,-1,283,284,285,-1,286,287,288,-1,289,187,290,-1,83,291,292,-1,293,294,295,-1,296,88,268,-1,297,254,132,-1,298,86,88,-1,299,300,301,-1,154,302,303,-1,128,189,224,-1,304,305,306,-1,307,164,308,-1,0,10,220,-1,309,301,310,-1,134,311,301,-1,164,166,0,-1,135,312,313,-1,314,312,106,-1,159,196,195,-1,226,225,224,-1,157,152,190,-1,179,315,171,-1,66,65,316,-1,94,317,165,-1,318,319,320,-1,321,322,323,-1,324,325,326,-1,327,328,329,-1,330,327,331,-1,332,333,334,-1,335,336,337,-1,338,331,339,-1,340,341,342,-1,343,344,345,-1,346,347,348,-1,346,349,338,-1,350,348,347,-1,351,352,353,-1,354,355,356,-1,354,357,358,-1,359,360,361,-1,362,363,364,-1,365,366,367,-1,368,369,370,-1,357,371,358,-1,359,372,373,-1,374,372,375,-1,376,374,371,-1,371,375,377,-1,378,379,380,-1,381,382,383,-1,382,384,385,-1,383,386,387,-1,388,389,364,-1,390,391,392,-1,393,394,395,-1,396,393,397,-1,398,367,366,-1,397,399,400,-1,401,402,403,-1,404,405,386,-1,406,407,408,-1,409,410,337,-1,411,412,413,-1,414,415,416,-1,417,418,419,-1,420,421,422,-1,416,415,422,-1,405,423,387,-1,424,425,108,-1,426,427,356,-1,428,429,430,-1,431,432,433,-1,434,435,436,-1,436,437,438,-1,439,440,441,-1,442,443,444,-1,445,446,447,-1,448,449,450,-1,451,452,405,-1,453,454,455,-1,456,455,457,-1,458,459,460,-1,461,462,463,-1,464,465,466,-1,467,468,469,-1,470,471,472,-1,473,474,475,-1,476,477,466,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,488,489,-1,490,491,492,-1,493,494,484,-1,495,493,496,-1,497,498,487,-1,499,500,485,-1,500,497,485,-1,500,498,497,-1,501,502,503,-1,504,505,506,-1,507,508,509,-1,510,505,504,-1,511,512,513,-1,495,514,510,-1,515,516,517,-1,518,519,520,-1,521,522,523,-1,524,525,520,-1,431,526,527,-1,528,425,424,-1,528,529,530,-1,531,532,533,-1,534,535,492,-1,502,536,537,-1,538,445,539,-1,359,377,375,-1,528,424,540,-1,541,349,542,-1,543,544,545,-1,546,547,548,-1,549,550,551,-1,550,461,552,-1,553,439,554,-1,555,556,557,-1,558,559,560,-1,561,562,563,-1,564,458,565,-1,546,566,567,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_2()
		{
			int[] value = {543,568,519,-1,517,345,569,-1,340,570,571,-1,329,572,340,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,457,460,585,-1,586,558,587,-1,563,437,588,-1,463,462,589,-1,590,591,592,-1,593,594,595,-1,596,394,597,-1,598,503,599,-1,600,601,398,-1,602,603,604,-1,605,449,448,-1,606,607,608,-1,609,502,610,-1,501,611,612,-1,480,613,324,-1,608,607,614,-1,324,481,478,-1,423,452,615,-1,616,387,423,-1,513,474,477,-1,484,617,618,-1,619,469,470,-1,489,620,621,-1,622,621,620,-1,483,623,412,-1,624,625,626,-1,627,628,629,-1,627,624,628,-1,630,413,625,-1,631,632,381,-1,633,335,337,-1,469,475,506,-1,634,488,498,-1,485,484,618,-1,450,607,635,-1,636,635,615,-1,490,492,637,-1,638,639,478,-1,332,334,325,-1,637,479,640,-1,641,450,449,-1,604,449,602,-1,642,611,643,-1,609,610,644,-1,645,611,642,-1,646,448,647,-1,648,649,402,-1,603,650,651,-1,601,600,403,-1,652,403,653,-1,595,654,655,-1,656,592,391,-1,657,597,658,-1,659,395,660,-1,391,395,656,-1,388,363,591,-1,562,561,589,-1,661,662,559,-1,663,577,664,-1,665,666,343,-1,667,572,326,-1,668,329,669,-1,670,426,671,-1,672,673,674,-1,675,676,677,-1,678,651,679,-1,664,662,661,-1,460,581,680,-1,681,380,379,-1,366,365,682,-1,551,550,341,-1,550,683,341,-1,461,550,549,-1,684,463,561,-1,566,342,341,-1,685,670,518,-1,543,355,544,-1,686,343,346,-1,687,532,531,-1,540,531,529,-1,573,350,347,-1,688,689,690,-1,691,332,613,-1,536,692,617,-1,503,537,490,-1,482,330,623,-1,693,567,554,-1,690,694,695,-1,355,696,544,-1,696,530,544,-1,432,672,697,-1,698,516,699,-1,513,691,535,-1,700,701,702,-1,485,497,487,-1,703,622,704,-1,704,620,489,-1,493,484,486,-1,486,485,487,-1,705,617,484,-1,482,481,324,-1,353,526,431,-1,587,353,438,-1,559,706,560,-1,636,647,448,-1,707,445,447,-1,399,539,445,-1,503,598,611,-1,464,444,465,-1,642,589,462,-1,708,642,462,-1,709,706,454,-1,588,437,436,-1,434,677,710,-1,353,711,526,-1,712,430,713,-1,543,519,518,-1,429,427,430,-1,419,714,715,-1,716,411,417,-1,715,717,718,-1,411,719,412,-1,694,409,336,-1,615,720,721,-1,398,601,722,-1,402,723,722,-1,400,679,651,-1,539,724,538,-1,654,658,396,-1,725,364,600,-1,394,393,396,-1,726,727,728,-1,595,594,657,-1,729,590,656,-1,381,632,384,-1,730,731,732,-1,385,733,379,-1,734,681,735,-1,362,725,366,-1,736,370,357,-1,555,362,682,-1,354,737,696,-1,427,736,356,-1,711,353,352,-1,362,555,557,-1,738,739,350,-1,338,349,541,-1,350,568,545,-1,338,541,740,-1,738,741,739,-1,336,741,695,-1,629,742,335,-1,623,330,331,-1,482,743,328,-1,743,326,572,-1,321,744,322,-1,318,317,319,-1,70,66,745,-1,746,747,748,-1,158,153,152,-1,311,134,133,-1,749,133,313,-1,222,221,176,-1,164,750,167,-1,751,8,10,-1,752,134,309,-1,753,297,752,-1,754,74,755,-1,756,305,757,-1,758,759,223,-1,132,254,253,-1,760,87,761,-1,296,267,295,-1,762,253,763,-1,764,298,765,-1,764,766,298,-1,283,764,767,-1,768,287,286,-1,769,81,80,-1,767,768,770,-1,284,771,285,-1,76,282,772,-1,275,280,248,-1,247,773,278,-1,142,774,251,-1,775,776,777,-1,250,145,778,-1,30,779,31,-1,2,780,263,-1,780,781,5,-1,259,262,5,-1,779,111,204,-1,782,783,784,-1,785,786,777,-1,787,144,143,-1,788,41,43,-1,238,241,148,-1,249,146,773,-1,17,256,244,-1,202,204,789,-1,790,31,235,-1,22,19,25,-1,791,792,218,-1,215,792,791,-1,793,794,795,-1,266,796,24,-1,220,797,221,-1,220,10,797,-1,798,225,226,-1,176,188,187,-1,317,7,799,-1,800,255,801,-1,64,802,62,-1,228,803,219,-1,804,805,806,-1,790,214,31,-1,807,210,116,-1,205,808,206,-1,809,221,797,-1,158,810,159,-1,702,701,811,-1,811,812,702,-1,172,813,169,-1,704,315,703,-1,704,814,171,-1,182,168,170,-1,173,172,169,-1,170,798,177,-1,799,1,0,-1,120,211,28,-1,121,28,276,-1,140,280,275,-1,245,815,816,-1,90,817,42,-1,132,762,313,-1,129,818,819,-1,818,131,227,-1,305,290,187,-1,150,126,151,-1,754,138,137,-1,137,816,754,-1,118,117,278,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_3()
		{
			int[] value = {783,782,115,-1,820,821,113,-1,204,235,779,-1,822,71,823,-1,824,101,100,-1,825,102,99,-1,96,826,827,-1,748,323,828,-1,95,829,826,-1,830,831,832,-1,833,93,62,-1,834,822,835,-1,834,836,312,-1,83,42,291,-1,291,761,87,-1,294,84,296,-1,837,78,227,-1,768,767,764,-1,82,285,73,-1,38,83,292,-1,768,765,79,-1,770,284,283,-1,772,282,771,-1,66,70,69,-1,93,838,839,-1,58,57,840,-1,839,51,63,-1,841,842,50,-1,843,844,46,-1,43,38,845,-1,846,47,33,-1,847,845,848,-1,849,33,32,-1,850,29,28,-1,851,848,845,-1,852,853,23,-1,852,854,237,-1,855,856,26,-1,237,266,853,-1,15,855,26,-1,13,12,854,-1,746,13,857,-1,317,318,6,-1,781,2,1,-1,781,780,2,-1,781,1,799,-1,6,7,317,-1,746,857,747,-1,854,852,13,-1,858,4,14,-1,237,236,266,-1,19,858,25,-1,237,853,852,-1,852,23,859,-1,845,40,851,-1,850,860,29,-1,32,31,849,-1,29,847,848,-1,846,861,47,-1,847,43,845,-1,841,50,35,-1,839,53,51,-1,58,840,862,-1,90,56,72,-1,93,839,62,-1,69,67,66,-1,771,288,772,-1,74,769,863,-1,79,287,768,-1,292,39,38,-1,765,768,764,-1,864,837,227,-1,294,865,84,-1,291,817,761,-1,42,817,291,-1,312,314,834,-1,833,62,802,-1,830,832,866,-1,748,828,867,-1,96,827,868,-1,825,97,102,-1,114,110,869,-1,204,203,235,-1,821,114,113,-1,211,850,28,-1,783,115,119,-1,117,122,278,-1,816,815,754,-1,757,304,870,-1,871,872,870,-1,302,151,758,-1,187,306,305,-1,818,227,85,-1,873,129,819,-1,129,131,818,-1,313,133,132,-1,90,136,817,-1,245,816,775,-1,141,140,275,-1,140,757,280,-1,121,120,28,-1,125,124,874,-1,799,0,166,-1,875,876,877,-1,173,169,168,-1,182,170,178,-1,704,171,315,-1,315,878,703,-1,186,185,192,-1,809,797,195,-1,807,879,210,-1,214,849,31,-1,804,806,230,-1,228,219,229,-1,803,802,219,-1,64,219,802,-1,165,317,799,-1,876,875,176,-1,187,876,176,-1,219,880,231,-1,24,853,266,-1,793,881,794,-1,880,91,882,-1,883,791,218,-1,215,791,213,-1,22,884,19,-1,202,789,885,-1,17,16,256,-1,148,872,238,-1,43,847,788,-1,886,787,143,-1,777,776,785,-1,760,887,268,-1,783,888,784,-1,111,789,204,-1,5,4,259,-1,2,263,18,-1,19,884,20,-1,785,269,889,-1,778,890,250,-1,137,251,816,-1,246,775,777,-1,137,142,251,-1,280,249,248,-1,281,40,891,-1,772,81,769,-1,863,769,80,-1,768,286,770,-1,769,76,772,-1,283,766,764,-1,766,86,298,-1,86,292,291,-1,294,296,295,-1,761,892,760,-1,762,132,253,-1,757,305,304,-1,759,224,223,-1,756,757,140,-1,753,752,293,-1,752,309,893,-1,875,163,222,-1,10,0,751,-1,164,167,166,-1,222,176,875,-1,312,749,313,-1,749,311,133,-1,894,170,169,-1,184,183,895,-1,896,158,152,-1,11,746,748,-1,747,323,748,-1,66,316,745,-1,317,94,319,-1,744,320,322,-1,743,572,328,-1,331,625,623,-1,629,542,742,-1,695,694,336,-1,741,742,739,-1,339,668,344,-1,350,573,568,-1,686,344,343,-1,350,545,738,-1,362,557,363,-1,352,897,711,-1,427,898,736,-1,696,355,354,-1,555,682,352,-1,736,357,354,-1,362,366,682,-1,385,379,378,-1,386,380,404,-1,730,732,409,-1,384,382,381,-1,656,596,729,-1,660,391,390,-1,728,899,726,-1,394,396,658,-1,600,398,725,-1,389,593,900,-1,396,655,654,-1,539,901,724,-1,902,400,651,-1,402,722,601,-1,722,367,398,-1,615,721,616,-1,903,904,721,-1,694,730,409,-1,715,718,633,-1,905,716,417,-1,714,717,715,-1,383,387,904,-1,671,543,518,-1,712,713,906,-1,434,433,677,-1,588,436,435,-1,709,454,453,-1,709,907,706,-1,708,645,642,-1,708,908,612,-1,644,464,909,-1,611,501,503,-1,399,445,707,-1,707,447,910,-1,910,911,707,-1,448,912,636,-1,706,907,560,-1,589,642,913,-1,353,431,438,-1,553,440,439,-1,324,743,482,-1,914,915,640,-1,486,487,916,-1,493,486,496,-1,489,814,704,-1,622,620,704,-1,917,918,500,-1,702,919,700,-1,474,504,475,-1,691,492,535,-1,522,548,523,-1,516,515,699,-1,432,527,672,-1,482,623,483,-1,490,640,915,-1,490,915,503,-1,613,492,691,-1,347,574,573,-1,920,408,689,-1,531,540,687,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_4()
		{
			int[] value = {528,540,529,-1,343,666,346,-1,685,518,520,-1,341,921,566,-1,549,908,461,-1,365,922,682,-1,681,923,380,-1,460,459,581,-1,661,924,664,-1,678,604,651,-1,578,925,648,-1,676,710,677,-1,674,697,672,-1,518,670,671,-1,669,569,668,-1,329,328,572,-1,667,340,572,-1,355,671,356,-1,706,564,454,-1,661,559,558,-1,588,684,563,-1,562,589,585,-1,656,590,592,-1,593,729,594,-1,657,658,654,-1,395,391,660,-1,597,394,658,-1,655,653,595,-1,652,653,655,-1,396,652,655,-1,926,646,647,-1,650,902,651,-1,649,723,402,-1,646,927,448,-1,928,609,644,-1,643,913,642,-1,899,390,709,-1,449,605,602,-1,641,614,450,-1,332,325,324,-1,478,481,638,-1,637,640,490,-1,636,912,635,-1,635,912,450,-1,469,468,475,-1,631,929,632,-1,413,623,625,-1,624,626,628,-1,629,718,627,-1,624,630,625,-1,623,413,412,-1,929,410,632,-1,489,621,916,-1,930,619,470,-1,609,692,536,-1,513,512,474,-1,423,615,616,-1,636,615,452,-1,324,478,480,-1,607,450,614,-1,931,608,614,-1,613,332,324,-1,932,478,933,-1,611,645,612,-1,502,442,610,-1,934,909,467,-1,608,935,606,-1,401,403,652,-1,448,927,605,-1,603,651,604,-1,403,600,653,-1,654,595,657,-1,936,910,447,-1,595,900,593,-1,937,503,915,-1,561,463,589,-1,680,938,562,-1,563,939,437,-1,586,661,558,-1,438,586,587,-1,582,940,583,-1,581,941,579,-1,576,578,650,-1,671,355,543,-1,574,942,575,-1,943,542,349,-1,340,669,329,-1,571,669,340,-1,569,944,517,-1,568,945,519,-1,564,946,458,-1,561,563,684,-1,351,558,560,-1,921,341,683,-1,552,683,550,-1,667,551,341,-1,551,947,549,-1,545,568,543,-1,570,948,949,-1,688,690,950,-1,951,950,952,-1,538,446,445,-1,502,609,536,-1,692,609,928,-1,637,492,613,-1,531,533,953,-1,540,424,687,-1,530,696,528,-1,431,527,432,-1,524,520,954,-1,515,517,944,-1,510,955,495,-1,513,535,511,-1,955,510,504,-1,956,507,509,-1,504,506,475,-1,471,509,957,-1,917,619,930,-1,502,537,503,-1,500,918,498,-1,498,488,487,-1,496,514,495,-1,494,705,484,-1,491,534,492,-1,489,916,487,-1,503,937,599,-1,483,638,481,-1,478,932,479,-1,476,333,477,-1,475,468,473,-1,471,957,472,-1,464,466,473,-1,463,552,461,-1,460,565,458,-1,456,457,913,-1,453,455,456,-1,404,451,405,-1,452,423,405,-1,450,912,448,-1,612,645,708,-1,610,442,444,-1,438,431,436,-1,436,433,434,-1,433,436,431,-1,428,430,712,-1,356,671,426,-1,424,108,107,-1,405,387,386,-1,422,958,416,-1,420,422,959,-1,421,420,715,-1,413,417,411,-1,960,961,962,-1,337,336,409,-1,406,92,407,-1,641,678,963,-1,402,601,403,-1,399,679,400,-1,594,597,657,-1,366,725,398,-1,393,395,659,-1,393,901,397,-1,391,592,392,-1,364,363,388,-1,383,378,386,-1,381,383,964,-1,384,632,410,-1,378,380,386,-1,371,374,375,-1,371,965,376,-1,374,966,372,-1,359,375,372,-1,357,965,371,-1,368,734,369,-1,367,404,365,-1,364,725,362,-1,361,377,359,-1,354,358,737,-1,356,736,354,-1,351,555,352,-1,338,686,346,-1,346,666,347,-1,345,665,343,-1,340,667,341,-1,338,740,331,-1,332,691,333,-1,329,668,327,-1,324,326,743,-1,747,321,323,-1,744,318,320,-1,95,94,165,-1,315,179,878,-1,171,173,179,-1,152,191,190,-1,894,798,170,-1,967,159,195,-1,106,71,314,-1,312,135,106,-1,0,162,164,-1,309,134,301,-1,0,220,162,-1,871,304,306,-1,759,128,224,-1,301,311,299,-1,132,752,297,-1,268,267,296,-1,295,753,293,-1,766,292,86,-1,770,283,767,-1,129,873,968,-1,285,82,283,-1,876,187,969,-1,280,146,249,-1,248,970,886,-1,278,122,279,-1,246,777,277,-1,276,277,121,-1,273,971,274,-1,272,787,270,-1,267,269,890,-1,235,31,779,-1,265,796,266,-1,856,857,859,-1,263,780,5,-1,234,263,262,-1,21,199,260,-1,258,236,235,-1,254,271,252,-1,774,145,251,-1,249,773,247,-1,245,775,246,-1,851,972,848,-1,800,125,874,-1,241,243,242,-1,240,241,238,-1,808,973,257,-1,237,790,235,-1,857,856,855,-1,791,212,213,-1,52,36,35,-1,227,130,864,-1,188,226,189,-1,221,809,174,-1,216,218,792,-1,883,212,791,-1,213,849,214,-1,116,211,120,-1,200,974,209,-1,260,199,201,-1,180,975,198,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_5()
		{
			int[] value = {197,809,195,-1,187,189,306,-1,813,184,186,-1,172,184,813,-1,182,178,180,-1,168,182,179,-1,177,976,178,-1,176,221,174,-1,171,183,172,-1,289,969,187,-1,165,799,166,-1,163,308,164,-1,149,967,9,-1,160,153,158,-1,155,193,156,-1,160,149,151,-1,148,242,146,-1,145,774,143,-1,140,142,139,-1,139,142,137,-1,89,136,90,-1,89,106,135,-1,132,134,752,-1,870,304,871,-1,126,128,759,-1,117,120,122,-1,119,115,117,-1,116,120,117,-1,114,869,112,-1,111,779,30,-1,107,109,212,-1,72,106,89,-1,105,977,103,-1,102,100,99,-1,105,104,978,-1,95,826,96,-1,979,980,981,-1,93,833,11,-1,92,406,91,-1,982,983,893,-1,86,291,87,-1,84,865,85,-1,770,286,284,-1,83,38,43,-1,39,292,82,-1,77,79,765,-1,81,287,79,-1,76,769,74,-1,40,73,891,-1,71,58,823,-1,862,67,69,-1,68,823,69,-1,62,839,63,-1,61,92,59,-1,58,72,56,-1,36,54,48,-1,48,55,49,-1,52,53,54,-1,50,52,35,-1,47,49,34,-1,44,46,984,-1,41,90,42,-1,40,845,38,-1,36,861,37,-1,33,47,34,-1,30,32,985,-1,29,848,27,-1,24,23,853,-1,26,856,22,-1,24,884,22,-1,21,858,19,-1,16,18,263,-1,14,15,26,-1,11,13,746,-1,11,833,12,-1,9,797,10,-1,3,5,781,-1,2,751,0,-1,855,747,857,-1,747,855,321,-1,854,803,986,-1,854,12,803,-1,858,259,4,-1,21,259,858,-1,859,22,856,-1,859,23,22,-1,972,815,245,-1,972,75,815,-1,987,850,112,-1,987,860,850,-1,849,846,33,-1,213,846,849,-1,788,29,860,-1,788,847,29,-1,44,988,985,-1,44,984,988,-1,843,57,844,-1,843,840,57,-1,60,51,50,-1,63,51,60,-1,840,67,862,-1,840,989,67,-1,771,73,285,-1,73,771,891,-1,74,990,755,-1,990,74,863,-1,77,227,78,-1,227,77,85,-1,314,822,834,-1,71,822,314,-1,991,992,993,-1,991,994,992,-1,311,995,299,-1,311,749,995,-1,996,997,998,-1,997,996,999,-1,978,1000,1001,-1,1000,978,827,-1,825,323,322,-1,323,825,828,-1,1002,1003,1004,-1,1002,1005,1003,-1,105,981,866,-1,105,978,981,-1,821,110,114,-1,821,111,110,-1,210,850,211,-1,210,1006,850,-1,247,970,248,-1,247,279,970,-1,758,126,759,-1,758,151,126,-1,968,1007,1008,-1,968,756,1007,-1,136,762,763,-1,136,313,762,-1,135,313,136,-1,1009,279,277,-1,970,279,1009,-1,1010,301,300,-1,1010,1011,301,-1,1012,894,169,-1,894,1012,1013,-1,190,812,811,-1,192,812,190,-1,508,1014,194,-1,508,507,1014,-1,507,878,1014,-1,507,703,878,-1,1015,1016,1017,-1,1015,1018,1016,-1,1016,794,1019,-1,209,794,1016,-1,1020,790,237,-1,1020,214,790,-1,805,216,806,-1,805,217,216,-1,1021,803,228,-1,986,803,1021,-1,782,116,115,-1,782,807,116,-1,201,206,1022,-1,206,201,1023,-1,793,265,264,-1,793,795,265,-1,861,1024,37,-1,846,1024,861,-1,228,806,1021,-1,230,806,228,-1,1025,883,218,-1,1026,883,1025,-1,1027,200,199,-1,1027,974,200,-1,773,874,124,-1,874,773,146,-1,41,56,90,-1,56,41,1028,-1,890,295,267,-1,890,778,295,-1,784,807,782,-1,784,1029,807,-1,1030,821,820,-1,821,1030,1031,-1,1031,111,821,-1,111,1031,789,-1,1027,796,265,-1,1027,20,796,-1,273,970,1009,-1,970,273,270,-1,785,971,786,-1,785,889,971,-1,145,1032,778,-1,145,144,1032,-1,141,774,142,-1,141,143,774,-1,983,819,818,-1,983,982,819,-1,864,1008,1033,-1,1008,864,130,-1,81,288,287,-1,772,288,81,-1,87,268,88,-1,87,760,268,-1,139,756,140,-1,1007,756,139,-1,1034,239,238,-1,1034,161,239,-1,184,1035,185,-1,184,895,1035,-1,191,154,303,-1,191,152,154,-1,70,1036,68,-1,70,745,1036,-1,1037,1005,1002,-1,1037,831,1005,-1,979,1038,991,-1,979,1001,1038,-1,629,541,542,-1,628,541,629,-1,542,739,742,-1,739,542,943,-1,519,954,520,-1,519,945,954,-1,592,363,557,-1,363,592,591,-1,898,429,1039,-1,429,898,427,-1,1040,425,1041,-1,425,1040,108,-1,1042,1043,1044,-1,1043,1042,1039,-1,1044,681,1042,-1,1044,923,681,-1,1045,1046,376,-1,1045,1047,1046,-1,1046,731,966,-1,731,1046,732,-1,92,1048,407,-1,92,61,1048,-1,410,732,384,-1,410,409,732,-1,596,594,729,-1,594,596,597,-1,364,900,600,-1,389,900,364,-1,539,397,901,-1,399,397,539,-1,904,616,721,-1,616,904,387,-1,1049,1050,1051,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_6()
		{
			int[] value = {1049,1052,1050,-1,1053,607,606,-1,1053,635,607,-1,1054,1055,1056,-1,1057,1055,1054,-1,1058,414,1059,-1,716,414,1058,-1,718,714,627,-1,717,714,718,-1,1060,1061,1062,-1,1060,1063,1061,-1,1064,421,715,-1,1064,1065,421,-1,427,713,430,-1,427,426,713,-1,711,527,526,-1,711,1066,527,-1,938,563,562,-1,938,939,563,-1,444,644,610,-1,444,464,644,-1,1067,936,1068,-1,1067,643,936,-1,647,451,926,-1,636,451,647,-1,451,636,452,-1,939,1069,586,-1,1069,939,938,-1,608,1070,935,-1,608,1071,1070,-1,494,535,534,-1,535,494,511,-1,1072,702,1073,-1,702,1072,919,-1,1074,444,443,-1,1074,465,444,-1,622,507,956,-1,622,703,507,-1,1075,673,1076,-1,1075,1077,673,-1,1078,1075,1079,-1,1075,1078,1080,-1,544,1081,545,-1,544,530,1081,-1,953,1082,1083,-1,953,533,1082,-1,690,407,1084,-1,689,407,690,-1,689,408,407,-1,1085,545,1081,-1,1085,738,545,-1,326,551,667,-1,326,325,551,-1,684,435,440,-1,588,435,684,-1,567,921,554,-1,921,567,566,-1,574,666,665,-1,666,574,347,-1,920,406,408,-1,920,1086,406,-1,531,1087,529,-1,1087,531,953,-1,1088,1089,942,-1,1089,1088,1090,-1,552,553,554,-1,552,463,553,-1,927,941,605,-1,579,941,927,-1,603,576,650,-1,603,1091,576,-1,697,675,677,-1,697,674,675,-1,713,1092,906,-1,1093,1092,713,-1,426,1093,713,-1,670,1093,426,-1,574,1088,942,-1,574,665,1088,-1,938,584,1069,-1,580,584,938,-1,583,664,924,-1,583,663,664,-1,1094,458,1091,-1,1094,459,458,-1,565,457,455,-1,565,460,457,-1,911,678,707,-1,911,963,678,-1,1068,538,727,-1,446,538,1068,-1,596,395,394,-1,395,596,656,-1,578,402,401,-1,578,648,402,-1,649,926,723,-1,649,646,926,-1,1095,1051,1096,-1,1049,1051,1095,-1,644,934,928,-1,934,644,909,-1,709,726,899,-1,709,453,726,-1,641,604,678,-1,641,449,604,-1,1071,640,479,-1,1071,914,640,-1,411,1058,719,-1,411,716,1058,-1,700,1097,701,-1,700,472,1097,-1,410,633,337,-1,929,633,410,-1,1056,1098,1099,-1,1056,1055,1098,-1,1051,1100,1096,-1,961,1100,1051,-1,719,639,638,-1,719,1058,639,-1,639,1059,1101,-1,639,1058,1059,-1,1102,1096,1100,-1,1102,1063,1096,-1,1055,964,1098,-1,1055,1103,964,-1,500,619,917,-1,619,500,499,-1,691,477,333,-1,691,513,477,-1,608,914,1071,-1,608,931,914,-1,453,1067,726,-1,453,456,1067,-1,606,1049,1095,-1,935,1049,606,-1,577,925,578,-1,925,577,663,-1,447,1068,936,-1,447,446,1068,-1,963,937,915,-1,911,937,963,-1,680,585,460,-1,680,562,585,-1,586,437,939,-1,586,438,437,-1,663,940,925,-1,940,663,583,-1,941,459,1094,-1,941,581,459,-1,646,940,582,-1,646,649,940,-1,602,1091,603,-1,1094,1091,602,-1,1104,693,1105,-1,1104,547,693,-1,665,517,1088,-1,517,665,345,-1,906,1076,1106,-1,1092,1076,906,-1,342,570,340,-1,570,342,948,-1,605,1094,602,-1,605,941,1094,-1,555,560,556,-1,555,351,560,-1,1090,1078,1089,-1,1078,1090,1080,-1,1107,950,951,-1,1107,688,950,-1,1108,953,1083,-1,1108,1087,953,-1,360,1040,1041,-1,360,1109,1040,-1,617,491,536,-1,617,705,491,-1,1087,1085,1081,-1,1087,1108,1085,-1,1082,951,1083,-1,951,1082,1110,-1,1082,1111,1112,-1,1082,533,1111,-1,533,1025,1111,-1,532,1025,533,-1,525,685,520,-1,1113,685,525,-1,521,699,522,-1,521,1114,699,-1,674,1077,1115,-1,674,673,1077,-1,670,1113,1093,-1,670,685,1113,-1,547,523,548,-1,1104,523,547,-1,622,510,514,-1,622,956,510,-1,510,509,505,-1,510,956,509,-1,471,505,509,-1,505,471,506,-1,928,1116,692,-1,928,934,1116,-1,499,934,619,-1,499,1116,934,-1,1073,634,1072,-1,1073,1117,634,-1,705,534,491,-1,534,705,494,-1,935,1052,1049,-1,935,1070,1052,-1,639,933,478,-1,1101,933,639,-1,957,1097,472,-1,957,1118,1097,-1,467,473,468,-1,473,909,464,-1,473,467,909,-1,439,693,554,-1,439,1105,693,-1,913,585,589,-1,585,913,457,-1,404,722,451,-1,367,722,404,-1,614,963,931,-1,614,641,963,-1,1068,726,1067,-1,727,726,1068,-1,708,461,908,-1,708,462,461,-1,440,434,441,-1,435,434,440,-1,929,715,633,-1,1064,715,929,-1,422,1119,958,-1,422,421,1119,-1,715,959,419,-1,715,420,959,-1,958,1120,416,-1,1121,1120,958,-1,1122,1120,1121,-1,714,624,627,-1,714,419,624,-1,1122,1100,1120,-1,1122,1102,1100,-1,631,1064,929,-1,1065,1064,631,-1,1053,615,635,-1,1053,720,615,-1,606,1060,1053,-1,1095,1060,606,-1,400,401,652,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_7()
		{
			int[] value = {400,902,401,-1,900,653,600,-1,900,595,653,-1,392,709,390,-1,392,907,709,-1,382,378,383,-1,382,385,378,-1,1123,407,1048,-1,407,1123,1084,-1,732,1047,384,-1,1047,732,1046,-1,61,373,1048,-1,842,373,61,-1,734,1045,369,-1,734,735,1045,-1,1047,735,733,-1,735,1047,1045,-1,358,377,361,-1,358,371,377,-1,359,1109,360,-1,1109,359,841,-1,368,1039,1042,-1,1039,368,898,-1,1041,528,1124,-1,528,1041,425,-1,557,392,592,-1,556,392,557,-1,339,686,338,-1,339,344,686,-1,571,949,1125,-1,571,570,949,-1,353,558,351,-1,587,558,353,-1,1001,750,1038,-1,1001,1000,750,-1,1126,831,830,-1,1126,1005,831,-1,68,996,1127,-1,68,1036,996,-1,181,179,182,-1,181,878,179,-1,157,811,155,-1,157,190,811,-1,812,185,1035,-1,192,185,812,-1,128,872,871,-1,128,127,872,-1,161,8,239,-1,161,9,8,-1,162,222,163,-1,220,222,162,-1,128,306,189,-1,128,871,306,-1,980,866,981,-1,830,866,980,-1,308,1011,1010,-1,163,1011,308,-1,990,864,1033,-1,990,837,864,-1,122,277,279,-1,122,121,277,-1,274,889,887,-1,971,889,274,-1,144,272,1032,-1,144,787,272,-1,786,273,1009,-1,786,971,273,-1,270,886,970,-1,886,270,787,-1,233,256,16,-1,233,257,256,-1,264,236,258,-1,266,236,264,-1,1029,879,807,-1,1029,1015,879,-1,234,16,263,-1,233,16,234,-1,1032,297,753,-1,1032,272,297,-1,777,1009,277,-1,777,786,1009,-1,57,1028,844,-1,57,56,1028,-1,17,241,240,-1,17,243,241,-1,794,974,795,-1,209,974,794,-1,229,1128,230,-1,229,231,1128,-1,216,1021,806,-1,216,1129,1021,-1,1040,37,1024,-1,1040,1109,37,-1,175,798,226,-1,175,177,798,-1,986,1129,1020,-1,986,1021,1129,-1,1086,804,882,-1,1086,1130,804,-1,214,1129,215,-1,1020,1129,214,-1,1026,212,883,-1,1026,107,212,-1,885,881,202,-1,881,885,1131,-1,1023,207,206,-1,1023,1132,207,-1,1019,1017,1016,-1,1017,1019,1030,-1,264,1133,793,-1,258,1133,264,-1,197,975,180,-1,196,975,197,-1,810,196,159,-1,810,975,196,-1,193,508,194,-1,193,1118,508,-1,303,1012,191,-1,303,1013,1012,-1,895,1073,1035,-1,895,1117,1073,-1,174,177,175,-1,976,177,174,-1,994,300,992,-1,994,1010,300,-1,307,750,164,-1,750,307,1038,-1,1097,193,155,-1,1097,1118,193,-1,160,154,153,-1,302,160,151,-1,302,154,160,-1,801,125,800,-1,801,1134,125,-1,785,251,250,-1,785,776,251,-1,982,309,310,-1,982,893,309,-1,1135,1008,1007,-1,1008,1135,1033,-1,148,870,872,-1,148,147,870,-1,870,280,757,-1,870,147,280,-1,879,1006,210,-1,879,1136,1006,-1,113,1136,820,-1,113,1006,1136,-1,868,103,102,-1,868,104,103,-1,867,825,99,-1,867,828,825,-1,866,977,105,-1,866,1137,977,-1,1137,866,832,-1,320,825,322,-1,320,97,825,-1,1036,999,996,-1,999,1036,824,-1,1127,835,822,-1,1127,1138,835,-1,1139,1005,1126,-1,1005,1139,1003,-1,837,79,78,-1,837,80,79,-1,754,75,74,-1,754,815,75,-1,58,69,823,-1,58,862,69,-1,59,63,60,-1,64,63,59,-1,989,838,67,-1,1140,838,989,-1,45,55,1141,-1,49,55,45,-1,55,53,1140,-1,54,53,55,-1,36,47,861,-1,36,48,47,-1,1109,35,37,-1,841,35,1109,-1,1142,984,1143,-1,988,984,1142,-1,213,1024,846,-1,109,1024,213,-1,112,1142,987,-1,869,1142,112,-1,25,14,26,-1,25,858,14,-1,232,261,1022,-1,232,234,261,-1,321,15,744,-1,321,855,15,-1,7,781,799,-1,7,3,781,-1,246,28,27,-1,28,246,276,-1,12,802,803,-1,802,12,833,-1,3,14,4,-1,3,6,14,-1,75,851,76,-1,851,75,972,-1,985,110,30,-1,985,988,110,-1,1144,860,987,-1,1144,788,860,-1,985,34,44,-1,32,34,985,-1,788,1028,41,-1,788,1144,1028,-1,44,49,45,-1,34,49,44,-1,843,989,840,-1,1141,989,843,-1,1141,46,45,-1,1141,843,46,-1,50,61,60,-1,61,50,842,-1,822,68,1127,-1,822,823,68,-1,282,891,771,-1,282,281,891,-1,755,1033,1135,-1,755,990,1033,-1,766,82,292,-1,766,283,82,-1,88,84,298,-1,88,296,84,-1,1003,299,995,-1,299,1003,1139,-1,312,995,749,-1,312,836,995,-1,1145,745,316,-1,745,1145,101,-1,981,1001,979,-1,1001,981,978,-1,94,98,319,-1,94,96,98,-1,832,1037,1137,-1,1037,832,831,-1,104,827,978,-1,827,104,868,-1,824,1146,999,-1,100,1146,824,-1,1146,103,977,-1,1146,100,103,-1,867,316,748,-1,316,867,1145,-1,119,124,123,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_8()
		{
			int[] value = {124,119,118,-1,310,876,982,-1,877,876,310,-1,136,761,817,-1,136,763,761,-1,150,161,1034,-1,150,149,161,-1,896,157,156,-1,157,896,152,-1,967,160,159,-1,160,967,149,-1,994,1038,307,-1,1038,994,991,-1,171,1147,183,-1,814,1147,171,-1,197,178,976,-1,180,178,197,-1,1013,798,894,-1,798,1013,225,-1,1147,895,183,-1,1147,1117,895,-1,1013,223,225,-1,1013,303,223,-1,1148,156,194,-1,896,156,1148,-1,194,198,1148,-1,194,1014,198,-1,198,878,181,-1,198,1014,878,-1,205,973,808,-1,973,205,1149,-1,1131,789,1031,-1,1131,885,789,-1,1018,1029,1150,-1,1018,1015,1029,-1,1023,200,208,-1,1023,201,200,-1,1018,209,1016,-1,1150,209,1018,-1,1150,208,209,-1,794,1131,1019,-1,794,881,1131,-1,1025,217,1111,-1,217,1025,218,-1,1111,805,1112,-1,1111,217,805,-1,1029,1132,1150,-1,1132,1029,784,-1,1022,260,201,-1,1022,261,260,-1,226,176,175,-1,176,226,188,-1,1128,880,882,-1,1128,231,880,-1,1143,46,844,-1,1143,984,46,-1,808,1022,206,-1,808,232,1022,-1,257,232,808,-1,257,233,232,-1,239,751,240,-1,239,8,751,-1,242,244,800,-1,242,243,244,-1,245,848,972,-1,245,27,848,-1,294,983,865,-1,294,293,983,-1,1134,1151,1152,-1,1134,1149,1151,-1,1017,820,1136,-1,820,1017,1030,-1,199,20,1027,-1,21,20,199,-1,801,1149,1134,-1,801,973,1149,-1,778,753,295,-1,753,778,1032,-1,274,253,252,-1,274,892,253,-1,273,271,270,-1,273,252,271,-1,275,886,143,-1,275,248,886,-1,969,982,876,-1,982,969,819,-1,1008,129,968,-1,1008,130,129,-1,887,269,268,-1,889,269,887,-1,992,299,1139,-1,299,992,300,-1,1007,138,1135,-1,1007,139,138,-1,877,301,1011,-1,877,310,301,-1,967,797,9,-1,967,195,797,-1,191,186,192,-1,1012,186,191,-1,1138,1037,1002,-1,1138,998,1037,-1,980,991,993,-1,991,980,979,-1,167,95,165,-1,829,95,167,-1,328,330,482,-1,328,327,330,-1,740,628,626,-1,740,541,628,-1,339,327,668,-1,339,331,327,-1,348,739,943,-1,348,350,739,-1,1039,428,1043,-1,428,1039,429,-1,897,1044,1043,-1,897,922,1044,-1,358,1124,737,-1,358,361,1124,-1,923,922,365,-1,923,1044,922,-1,965,370,369,-1,370,965,357,-1,841,373,842,-1,359,373,841,-1,966,376,1046,-1,376,966,374,-1,376,369,1045,-1,369,376,965,-1,1123,966,731,-1,1123,372,966,-1,964,904,1098,-1,964,383,904,-1,388,590,729,-1,388,591,590,-1,393,724,901,-1,393,659,724,-1,1063,1095,1096,-1,1060,1095,1063,-1,903,1098,904,-1,903,1099,1098,-1,1057,1103,1055,-1,1153,1103,1057,-1,1059,960,962,-1,414,960,1059,-1,418,413,630,-1,418,417,413,-1,1154,1122,1121,-1,1102,1122,1154,-1,716,415,414,-1,905,415,716,-1,1119,1153,1057,-1,1153,421,1065,-1,1153,1119,421,-1,422,905,959,-1,422,415,905,-1,1106,712,906,-1,1106,1066,712,-1,1066,672,527,-1,1066,1106,672,-1,915,931,963,-1,931,915,914,-1,723,451,722,-1,723,926,451,-1,564,664,946,-1,564,662,664,-1,476,465,1074,-1,476,466,465,-1,470,506,471,-1,469,506,470,-1,473,477,474,-1,466,477,473,-1,1101,1052,933,-1,1050,1052,1101,-1,1147,489,488,-1,489,1147,814,-1,493,511,494,-1,511,493,495,-1,617,1116,618,-1,692,1116,617,-1,634,1147,488,-1,634,1117,1147,-1,508,957,509,-1,508,1118,957,-1,512,504,474,-1,512,955,504,-1,955,511,495,-1,511,955,512,-1,954,575,524,-1,575,954,945,-1,1076,1079,1075,-1,1092,1079,1076,-1,1080,1077,1075,-1,1080,1115,1077,-1,1080,698,1115,-1,1113,1078,1079,-1,1113,525,1078,-1,424,1026,687,-1,424,107,1026,-1,1087,530,529,-1,530,1087,1081,-1,1110,1086,920,-1,1110,1130,1086,-1,695,950,690,-1,950,695,952,-1,694,1084,730,-1,694,690,1084,-1,1114,674,1115,-1,675,674,1114,-1,944,1125,515,-1,944,571,1125,-1,490,536,491,-1,537,536,490,-1,524,1078,525,-1,1089,1078,524,-1,689,1107,920,-1,689,688,1107,-1,734,1042,681,-1,734,368,1042,-1,1125,548,522,-1,1125,949,548,-1,949,546,548,-1,949,948,546,-1,325,947,551,-1,325,334,947,-1,921,552,554,-1,921,683,552,-1,1069,661,586,-1,1069,924,661,-1,1155,1105,1156,-1,1155,1104,1105,-1,568,575,945,-1,575,568,573,-1,566,948,342,-1,566,546,948,-1,680,580,938,-1,581,580,680,-1,584,924,1069,-1,584,583,924,-1,576,458,946,-1,576,1091,458,-1,579,584,580,-1,579,582,584,-1,455,564,565,-1,564,455,454,-1,538,728,727,-1,538,724,728,-1,1071,932,1070,-1,932,1071,479,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_9()
		{
			int[] value = {1120,961,960,-1,961,1120,1100,-1,501,442,502,-1,501,612,442,-1,637,480,479,-1,480,637,613,-1,334,476,947,-1,334,333,476,-1,908,442,612,-1,908,443,442,-1,918,919,1072,-1,919,918,917,-1,700,470,472,-1,700,930,470,-1,621,514,496,-1,621,622,514,-1,335,718,629,-1,633,718,335,-1,1154,1099,1061,-1,1154,1056,1099,-1,1050,961,1051,-1,962,961,1050,-1,412,638,483,-1,638,412,719,-1,1101,962,1050,-1,1101,1059,962,-1,1063,1154,1061,-1,1063,1102,1154,-1,1103,381,964,-1,1103,631,381,-1,467,619,934,-1,467,469,619,-1,1072,498,918,-1,1072,634,498,-1,947,1074,549,-1,947,476,1074,-1,643,456,913,-1,456,643,1067,-1,902,578,401,-1,650,578,902,-1,397,652,396,-1,400,652,397,-1,728,659,660,-1,724,659,728,-1,910,598,599,-1,936,598,910,-1,706,662,564,-1,706,559,662,-1,577,946,664,-1,577,576,946,-1,649,925,940,-1,649,648,925,-1,546,693,547,-1,546,567,693,-1,1106,673,672,-1,1076,673,1106,-1,676,1156,710,-1,676,1155,1156,-1,571,569,669,-1,944,569,571,-1,927,582,579,-1,582,927,646,-1,380,365,404,-1,923,365,380,-1,553,684,440,-1,463,684,553,-1,516,1088,517,-1,516,1090,1088,-1,687,1025,532,-1,1025,687,1026,-1,1083,952,1108,-1,952,1083,951,-1,1041,361,360,-1,361,1041,1124,-1,942,524,575,-1,942,1089,524,-1,522,515,1125,-1,699,515,522,-1,432,677,433,-1,432,697,677,-1,695,1108,952,-1,1108,695,1085,-1,1107,1110,920,-1,1107,951,1110,-1,1082,1130,1110,-1,1082,1112,1130,-1,1090,698,1080,-1,1090,516,698,-1,1115,699,1114,-1,1115,698,699,-1,521,675,1114,-1,676,675,521,-1,1079,1093,1113,-1,1093,1079,1092,-1,1104,521,523,-1,521,1155,676,-1,1155,521,1104,-1,919,930,700,-1,930,919,917,-1,618,499,485,-1,1116,499,618,-1,496,916,621,-1,496,486,916,-1,1070,933,1052,-1,1070,932,933,-1,1156,439,441,-1,439,1156,1105,-1,679,707,678,-1,399,707,679,-1,611,936,643,-1,936,611,598,-1,908,1074,443,-1,908,549,1074,-1,911,599,937,-1,911,910,599,-1,710,441,434,-1,441,710,1156,-1,428,1066,711,-1,428,712,1066,-1,1057,958,1119,-1,958,1054,1121,-1,958,1057,1054,-1,959,417,419,-1,959,905,417,-1,960,416,1120,-1,416,960,414,-1,1121,1056,1154,-1,1056,1121,1054,-1,630,419,418,-1,419,630,624,-1,1153,631,1103,-1,1153,1065,631,-1,1062,1099,903,-1,1062,1061,1099,-1,1062,1053,1060,-1,1062,720,1053,-1,903,720,1062,-1,903,721,720,-1,728,390,899,-1,660,390,728,-1,389,729,593,-1,388,729,389,-1,731,1084,1123,-1,1084,731,730,-1,384,733,385,-1,384,1047,733,-1,372,1048,373,-1,1048,372,1123,-1,379,735,681,-1,379,733,735,-1,898,370,736,-1,898,368,370,-1,352,922,897,-1,352,682,922,-1,1124,696,737,-1,696,1124,528,-1,711,1043,428,-1,711,897,1043,-1,907,556,560,-1,907,392,556,-1,346,943,349,-1,346,348,943,-1,569,344,668,-1,344,569,345,-1,695,738,1085,-1,695,741,738,-1,742,336,335,-1,742,741,336,-1,331,626,625,-1,331,740,626,-1,750,829,167,-1,750,1000,829,-1,830,993,1126,-1,993,830,980,-1,1127,998,1138,-1,1127,996,998,-1,748,65,11,-1,65,748,316,-1,1097,811,701,-1,1097,155,811,-1,1000,826,829,-1,1000,827,826,-1,875,1011,163,-1,875,877,1011,-1,293,893,983,-1,293,752,893,-1,1135,754,755,-1,1135,138,754,-1,303,758,223,-1,302,758,303,-1,993,1139,1126,-1,1139,993,992,-1,763,892,761,-1,763,253,892,-1,298,77,765,-1,77,298,84,-1,80,990,863,-1,990,80,837,-1,290,873,289,-1,873,290,968,-1,776,816,251,-1,776,775,816,-1,250,269,785,-1,250,890,269,-1,887,892,274,-1,887,760,892,-1,801,257,973,-1,801,255,257,-1,1015,1136,879,-1,1136,1015,1017,-1,1152,888,783,-1,1152,1151,888,-1,259,261,262,-1,261,259,260,-1,272,254,297,-1,254,272,271,-1,874,242,800,-1,874,146,242,-1,795,1027,265,-1,974,1027,795,-1,1129,792,215,-1,216,792,1129,-1,406,882,91,-1,406,1086,882,-1,884,796,20,-1,24,796,884,-1,244,255,800,-1,256,255,244,-1,118,773,124,-1,773,118,278,-1,240,2,18,-1,240,751,2,-1,237,986,1020,-1,237,854,986,-1,59,880,219,-1,59,91,880,-1,804,1128,882,-1,804,230,1128,-1,1130,805,804,-1,1130,1112,805,-1,793,202,881,-1,1133,202,793,-1,1023,1150,1132,-1,1023,208,1150,-1,784,207,1132,-1,207,784,888,-1,1031,1019,1131,-1,1030,1019,1031,-1,207,1149,205,-1,1151,207,888,-1};
			return value;
		}
		private int[] getatlas_Geo_8_24_coordIndex_10()
		{
			int[] value = {1149,207,1151,-1,975,1148,198,-1,810,1148,975,-1,810,896,1148,-1,158,896,810,-1,126,1034,127,-1,126,150,1034,-1,702,1035,1073,-1,812,1035,702,-1,813,1012,169,-1,813,186,1012,-1,809,976,174,-1,197,976,809,-1,307,1010,994,-1,307,308,1010,-1,125,1152,123,-1,1134,1152,125,-1,818,865,983,-1,865,818,85,-1,968,305,756,-1,290,305,968,-1,1034,872,127,-1,1034,238,872,-1,289,819,969,-1,289,873,819,-1,123,783,119,-1,1152,783,123,-1,1006,112,850,-1,1006,113,112,-1,99,1145,867,-1,1145,99,101,-1,977,999,1146,-1,997,977,1137,-1,997,999,977,-1,96,102,97,-1,96,868,102,-1,998,1137,1037,-1,997,1137,998,-1,97,319,98,-1,320,319,97,-1,745,824,1036,-1,745,101,824,-1,1138,1004,835,-1,1138,1002,1004,-1,995,1004,1003,-1,995,836,1004,-1,836,835,1004,-1,836,834,835,-1,284,288,771,-1,286,288,284,-1,838,65,67,-1,838,93,65,-1,839,1140,53,-1,838,1140,839,-1,1140,1141,55,-1,1140,989,1141,-1,844,1144,1143,-1,844,1028,1144,-1,987,1143,1144,-1,1142,1143,987,-1,109,1040,1024,-1,108,1040,109,-1,869,988,1142,-1,110,988,869,-1,40,76,851,-1,281,76,40,-1,1133,203,202,-1,1133,258,203,-1,852,857,13,-1,859,857,852,-1,744,6,318,-1,744,15,6,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getatlas_Coord_9_24_point_1()
		{
			double[] value = {.56424,55.72501,-1.53774,.53378,55.77236,-1.50028,.51967,55.84565,-1.56414,.42326,55.8298,-1.36641,.47295,55.91718,-1.36086,.48194,55.91447,-1.42629,.3868,55.81091,-1.26749,.4254,55.77234,-1.36063,.52062,55.79399,-1.62962,.4955,55.76616,-1.67308,.55755,55.71889,-1.57094,.40127,55.79779,-.93734,.34503,55.84444,-.909,.37026,55.84602,-.95989,.4317,55.88227,-1.27315,.37901,55.82806,-1.19167,.57388,55.9868,-1.63273,.59351,55.90835,-1.63887,.57778,55.89226,-1.60742,.51884,55.96802,-1.24456,.55178,56.02781,-1.25962,.54789,55.99084,-1.29907,.41172,55.9517,-1.18413,.387,55.97293,-1.11271,.44867,56.01799,-1.15767,.47332,55.92614,-1.2315,.4211,55.87501,-1.19577,1.05856,55.98032,-1.30286,.97791,56.06065,-1.26473,1.01314,55.9955,-1.20366,.42188,56.26435,-.94432,.34298,56.22393,-.95351,.37161,56.18575,-.88212,.28073,56.16775,-.85901,.40257,56.1578,-.85938,.08761,56.04019,-.60755,.21286,56.04273,-.69091,.08993,56.08444,-.6737,1.14871,55.82152,-1.12853,1.22446,55.76608,-1.14296,1.23945,55.85009,-1.16106,.98364,55.89581,-1.07612,1.05299,55.80155,-1.12318,1.07241,55.85687,-1.10987,.50484,56.16532,-.88896,.52951,56.06764,-.85926,.64912,56.04163,-.91003,.28464,56.12378,-.80568,.30852,56.06556,-.77499,.42731,56.06951,-.82705,.10085,55.99328,-.58226,.23507,55.95018,-.67947,.22298,56.00349,-.6929,.34194,55.91864,-.76501,.3293,55.99507,-.76214,.44776,55.98221,-.83431,.89667,55.88439,-1.00288,.791,55.88635,-.96007,.78381,55.79577,-.9549,.14568,55.80452,-.65059,.12134,55.90625,-.58906,0.0,55.89948,-.56295,.34203,55.7913,-.79718,.23669,55.88113,-.67906,.25393,55.80277,-.73699,.5074,55.75074,-.90003,.51542,55.74591,-.89887,.54532,55.79967,-.85677,.75338,55.62169,-.9512,.66682,55.74108,-.89692,.66096,55.68113,-.90097,.84831,55.68967,-1.00187,.87414,55.78066,-1.00905,1.3292,55.7291,-1.15553,1.28973,55.90312,-1.4135,1.23455,55.91877,-1.37006,1.32557,55.87034,-1.27539,1.17972,55.71111,-1.36968,1.20527,55.78957,-1.40299,1.2781,55.80311,-1.34756,1.314,55.85817,-1.41239,1.3781,55.83794,-1.33992,1.29527,55.68712,-1.18724,1.12666,55.77159,-1.16001,1.14568,55.69681,-1.35247,1.11631,55.73101,-1.43904,1.18147,55.70558,-1.25838,1.08825,55.75483,-1.23068,1.13082,55.72497,-1.28902,.91652,55.74558,-1.0935,.99034,55.81983,-1.0811,.12386,55.75362,-.77838,0.0,55.8274,-.6244,.42205,55.78321,-.85451,.43934,55.71582,-1.35835,.49577,55.6776,-1.42476,.51868,55.69031,-1.31206,.46519,55.72393,-1.18332,.48847,55.70773,-1.24849,.59033,55.65305,-1.09384};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_2()
		{
			double[] value = {.66087,55.6396,-1.06424,.64531,55.65727,-.94804,.57107,55.65719,-1.18273,.66321,55.62269,-1.17383,.6651,55.60422,-1.25997,.72021,55.58799,-1.23481,.90597,55.70579,-1.10347,0.0,56.14372,-.89811,0.0,56.1356,-.8092,.08912,56.14381,-.83725,.58867,56.27792,-.97626,.54081,56.34356,-1.0286,.81889,56.20578,-1.11423,.76691,56.27716,-1.1481,.68636,56.28658,-1.04457,.83303,56.12463,-1.49516,.81548,56.14424,-1.38811,.86305,56.06524,-1.49528,.89139,56.05235,-1.59188,.86981,56.13325,-1.59648,.88365,56.10415,-1.38718,.91573,56.02119,-1.35799,.87602,55.98575,-1.46387,.8278,56.14744,-1.717,.8576,56.06025,-1.72491,.76551,56.1037,-1.77192,.60251,55.69416,-1.85848,.69515,55.72401,-1.79095,.7664,55.70073,-1.80429,.97869,55.77723,-1.5865,1.07116,55.8144,-1.52571,1.06531,55.78057,-1.51747,.94567,55.75628,-1.29986,.93953,55.7201,-1.29441,.90077,55.70323,-1.41343,.94874,55.70421,-1.17621,.98444,55.74091,-1.15235,1.06833,55.89201,-1.4507,1.14131,55.89016,-1.50247,1.03403,55.85453,-1.53245,.94134,55.84589,-1.58332,.9311,55.85187,-1.55745,1.01252,55.8618,-1.52324,.92726,55.84881,-1.5483,.93514,55.8224,-1.52478,1.00983,55.83218,-1.48331,.78353,55.94108,-1.71599,.78207,55.87883,-1.67787,.71533,55.87343,-1.69114,.49445,55.73365,-1.78526,.54675,55.71768,-1.83531,.49943,55.70307,-1.92374,.30442,55.72474,-2.08846,.37551,55.70994,-1.98265,.43529,55.70555,-2.03189,.09561,55.76231,-2.12072,.14951,55.76938,-2.04416,.17864,55.76089,-2.11241,.33096,55.71197,-1.93894,.39415,55.68941,-1.83598,.43844,55.70717,-1.86584,.52954,55.78316,-1.71542,.61497,55.70554,-1.55038,.71831,55.68663,-1.54442,.58984,55.65516,-1.5125,.49408,55.68336,-1.43017,.55117,55.68764,-1.47814,.53853,55.64532,-1.45669,.28193,55.43622,-1.9538,.31798,55.49296,-2.05171,.41961,55.44485,-1.91736,.10608,55.45452,-1.97831,.18707,55.47152,-2.11212,.16413,55.4533,-1.9755,.56058,55.58116,-1.73612,.64151,55.55645,-1.7919,.72637,55.63618,-1.68472,.54409,55.51332,-1.85029,.35666,55.47252,-1.87261,.14563,55.45817,-1.91621,.31075,55.52381,-1.84316,.23087,55.52323,-1.87376,.25975,55.45708,-1.88584,.13643,55.45978,-2.13979,.18749,55.51323,-2.19019,.19324,55.60605,-2.20475,.25562,55.61297,-2.16018,.85091,55.72144,-1.68018,.76941,55.6529,-1.74925,.77066,55.69347,-1.80369,.17925,55.75398,-2.12394,.31005,55.71577,-2.09621,.19588,55.67422,-2.16592,.07124,55.75329,-2.04524,.13106,55.66947,-1.97058,.44586,55.68651,-1.71331,.36259,55.63728,-1.78977,.4039,55.57209,-1.77051,.21589,55.62077,-1.90461,.55101,55.99739,-1.30206};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_3()
		{
			double[] value = {.60463,56.05743,-1.31861,.61606,56.03897,-1.39486,.48601,56.20198,-1.05559,.36255,56.1662,-1.0121,.41724,56.28862,-.98453,.70546,56.10943,-1.61414,.65917,56.07352,-1.5194,.73301,56.11721,-1.53556,.6594,56.09131,-1.33535,.63772,56.13023,-1.26238,.84659,56.20401,-1.32848,.91133,56.12998,-1.30355,.0816,56.13431,-.90881,.17135,56.15342,-.87374,.26972,56.1137,-.94591,.1905,56.10367,-.92792,.20836,56.03424,-.92016,.09889,56.03152,-.89995,.0882,56.11914,-.9388,.23506,55.78742,-.80473,.61782,55.70882,-1.56506,.62558,55.6647,-1.65074,.71276,55.69115,-1.55521,.55022,55.68411,-1.9836,.68452,55.66825,-1.89239,.58128,55.6144,-1.97295,.69203,55.59157,-1.84777,1.14124,55.79719,-1.46327,.21194,55.86278,-.86047,.20952,55.8588,-.85719,.20361,55.86295,-.86394,.18562,55.79764,-.82141,.59344,56.01712,-1.59831,.57518,55.99298,-1.63073,.55241,55.98234,-1.56321,.35793,56.16337,-1.00674,.392,56.10006,-1.05048,.36782,56.0055,-.97675,.61646,55.81051,-1.71299,.56135,55.81678,-1.68167,.57615,55.84468,-1.65398,.64559,55.862,-1.6818,.72524,55.93362,-1.7052,.65934,55.91987,-1.67625,.63344,55.95135,-1.69024,1.11566,55.95981,-1.35492,1.01501,55.97401,-1.33698,.87544,55.95536,-1.55734,.8806,55.88768,-1.54259,.85283,55.9197,-1.63645,1.06109,55.86632,-1.43571,1.06329,55.88711,-1.44503,.96916,55.81089,-1.24221,.97917,55.7742,-1.21461,.94683,55.77041,-1.30219,.6087,56.01691,-1.69426,.60661,56.01354,-1.691,.6066,56.01895,-1.68819,.39285,56.10674,-1.05641,.54941,55.98186,-1.37253,.55374,55.98799,-1.37428,.54544,55.99011,-1.45139,.54096,55.98379,-1.45114,.54923,55.97503,-1.5604,.43497,56.06417,-1.11226,.49368,56.0506,-1.18677,.43351,56.05687,-1.10757,1.10439,55.72743,-1.34086,1.12144,55.7356,-1.29242,1.09045,55.81344,-1.3323,.89296,55.8522,-1.37845,.92485,55.80811,-1.34183,.91257,55.7831,-1.46157,.93879,55.85684,-1.26139,1.03288,55.81464,-1.24353,.9245,55.85464,-1.55699,.9208,56.01848,-1.35146,.91807,56.0112,-1.35362,.87687,55.96447,-1.56194,.87686,55.97506,-1.46031,.86386,55.87252,-1.61925,1.33732,55.83257,-1.1764,1.37675,55.83922,-1.24186,1.30284,55.66284,-1.25394,1.37832,55.71176,-1.23538,1.36673,55.71227,-1.19873,1.37821,55.73909,-1.31025,1.37399,55.74683,-1.31755,1.37982,55.74918,-1.31115,.8983,55.75664,-1.64253,.89989,55.76606,-1.64523,1.11258,55.7542,-1.20325,1.18197,55.73866,-1.18577,.9857,55.71219,-1.43383,1.06416,55.71863,-1.38898,1.06239,55.73049,-1.38689,1.10938,55.71537,-1.34336,.9341,55.74139,-1.42185,1.19692,55.68702,-1.28981,.91468,55.58013,-1.38858};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_4()
		{
			double[] value = {.87395,55.58518,-1.44964,.87648,55.6722,-1.47377,.44379,55.70512,-2.0275,.44071,55.69957,-2.03621,.87323,55.81981,-1.65027,.88324,55.8149,-1.64569,.82613,55.76167,-1.73142,.7021,55.59017,-1.50319,.70887,55.6283,-1.521,.88433,55.68242,-1.47575,.88016,55.68161,-1.48207,.89626,55.69008,-1.41142,.94276,55.69193,-1.17912,.94764,55.70618,-1.18245,.90438,55.69125,-1.10419,.11461,55.46316,-1.91971,.51362,55.74191,-.907,.43365,55.72241,-1.36109,.3879,55.7441,-1.27357,.39972,55.73569,-1.27297,.38447,55.76124,-1.18174,.37863,55.79896,-1.08999,.38475,55.79272,-1.08983,.39028,55.79198,-1.00695,-.56424,55.72501,-1.53774,-.52962,55.80836,-1.60481,-.51967,55.84565,-1.56414,-.42326,55.8298,-1.36641,-.48179,55.83016,-1.43975,-.48194,55.91447,-1.42629,-.4254,55.77234,-1.36063,-.3868,55.81091,-1.26749,-.55755,55.71889,-1.57094,-.4955,55.76616,-1.67308,-.52062,55.79399,-1.62962,-.39907,55.79679,-.9481,-.36835,55.79288,-.88548,-.40127,55.79779,-.93734,-.4211,55.87501,-1.19577,-.4317,55.88227,-1.27315,-.54923,55.97503,-1.5604,-.59351,55.90835,-1.63887,-.57388,55.9868,-1.63273,-.51884,55.96802,-1.24456,-.48605,55.93063,-1.28027,-.54789,55.99084,-1.29907,-.41172,55.9517,-1.18413,-.44867,56.01799,-1.15767,-.387,55.97293,-1.11271,-.38439,55.88374,-1.15156,-.38542,55.99434,-1.05262,-1.05856,55.98032,-1.30286,-1.01314,55.9955,-1.20366,-.97791,56.06065,-1.26473,-.37161,56.18575,-.88212,-.34298,56.22393,-.95351,-.42188,56.26435,-.94432,-.40257,56.1578,-.85938,-.28464,56.12378,-.80568,-.08761,56.04019,-.60755,-.08993,56.08444,-.6737,-.18693,56.10599,-.73954,-1.15209,55.87172,-1.15176,-1.23945,55.85009,-1.16106,-1.22446,55.76608,-1.14296,-.98364,55.89581,-1.07612,-1.07241,55.85687,-1.10987,-1.05299,55.80155,-1.12318,-.64172,56.1313,-.92257,-.52951,56.06764,-.85926,-.50484,56.16532,-.88896,-.30852,56.06556,-.77499,-.23507,55.95018,-.67947,-.10085,55.99328,-.58226,-.3293,55.99507,-.76214,-.22298,56.00349,-.6929,-.44776,55.98221,-.83431,-.21286,56.04273,-.69091,-.78381,55.79577,-.9549,-.791,55.88635,-.96007,-.89667,55.88439,-1.00288,-.66096,55.68113,-.90097,-.66682,55.74108,-.89692,-.77896,55.68201,-.93652,-.54532,55.79967,-.85677,-.66507,55.79208,-.90238,-.87414,55.78066,-1.00905,-.84831,55.68967,-1.00187,-1.34236,55.79495,-1.15962,-1.3292,55.7291,-1.15553,-1.28973,55.90312,-1.4135,-1.37545,55.84506,-1.3436,-1.23455,55.91877,-1.37006,-1.2781,55.80311,-1.34756,-1.37399,55.74683,-1.31755,-1.3781,55.83794,-1.33992,-1.24006,55.70953,-1.33166,-1.17972,55.71111,-1.36968,-1.12666,55.77159,-1.16001,-1.11631,55.73101,-1.43904};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_5()
		{
			double[] value = {-1.14568,55.69681,-1.35247,-1.13082,55.72497,-1.28902,-1.08825,55.75483,-1.23068,-1.18147,55.70558,-1.25838,-.99034,55.81983,-1.0811,-.91652,55.74558,-1.0935,0.0,55.75655,-.7487,-.14568,55.80452,-.65059,-.12386,55.75362,-.77838,-.42205,55.78321,-.85451,-.5074,55.75074,-.90003,-.5519,55.64688,-1.36205,-.49577,55.6776,-1.42476,-.43934,55.71582,-1.35835,-.67256,55.57675,-1.3653,-.6651,55.60422,-1.25997,-.72021,55.58799,-1.23481,-.51868,55.69031,-1.31206,-.48847,55.70773,-1.24849,-.46519,55.72393,-1.18332,-.59033,55.65305,-1.09384,-.66087,55.6396,-1.06424,-.66321,55.62269,-1.17383,-.90597,55.70579,-1.10347,-.0816,56.13431,-.90881,-.08912,56.14381,-.83725,-.54081,56.34356,-1.0286,-.58867,56.27792,-.97626,-.81889,56.20578,-1.11423,-.70715,56.24514,-1.03899,-.68636,56.28658,-1.04457,-.88365,56.10415,-1.38718,-.81548,56.14424,-1.38811,-.83303,56.12463,-1.49516,-.86981,56.13325,-1.59648,-.89139,56.05235,-1.59188,-.86305,56.06524,-1.49528,-.87602,55.98575,-1.46387,-.91573,56.02119,-1.35799,-.76551,56.1037,-1.77192,-.8576,56.06025,-1.72491,-.8278,56.14744,-1.717,-.7664,55.70073,-1.80429,-.69515,55.72401,-1.79095,-.60251,55.69416,-1.85848,-1.06531,55.78057,-1.51747,-1.07116,55.8144,-1.52571,-.97869,55.77723,-1.5865,-.94567,55.75628,-1.29986,-.93154,55.73071,-1.41662,-.90077,55.70323,-1.41343,-.98444,55.74091,-1.15235,-.94874,55.70421,-1.17621,-1.14131,55.89016,-1.50247,-1.06833,55.89201,-1.4507,-1.01252,55.8618,-1.52324,-1.03403,55.85453,-1.53245,-.9311,55.85187,-1.55745,-1.00983,55.83218,-1.48331,-.93514,55.8224,-1.52478,-.92726,55.84881,-1.5483,-.71533,55.87343,-1.69114,-.78207,55.87883,-1.67787,-.78353,55.94108,-1.71599,-.49943,55.70307,-1.92374,-.54675,55.71768,-1.83531,-.49445,55.73365,-1.78526,-.43529,55.70555,-2.03189,-.37551,55.70994,-1.98265,-.30442,55.72474,-2.08846,-.17864,55.76089,-2.11241,-.14951,55.76938,-2.04416,-.09561,55.76231,-2.12072,-.43844,55.70717,-1.86584,-.39415,55.68941,-1.83598,-.33096,55.71197,-1.93894,-.52954,55.78316,-1.71542,-.44625,55.72364,-1.73142,-.58984,55.65516,-1.5125,-.71831,55.68663,-1.54442,-.61497,55.70554,-1.55038,-.55117,55.68764,-1.47814,-.51249,55.72644,-1.444,-.49408,55.68336,-1.43017,-.41961,55.44485,-1.91736,-.31798,55.49296,-2.05171,-.28193,55.43622,-1.9538,-.18707,55.47152,-2.11212,-.13643,55.45978,-2.13979,-.10608,55.45452,-1.97831,-.72637,55.63618,-1.68472,-.64151,55.55645,-1.7919,-.62558,55.6647,-1.65074,-.35666,55.47252,-1.87261,-.4699,55.52774,-1.79051,-.31075,55.52381,-1.84316,-.25975,55.45708,-1.88584,-.24032,55.53798,-2.13951,-.18749,55.51323,-2.19019,-.3377,55.61769,-2.10829};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_6()
		{
			double[] value = {-.25562,55.61297,-2.16018,-.82613,55.76167,-1.73142,-.77066,55.69347,-1.80369,-.85091,55.72144,-1.68018,-.30026,55.68048,-1.90729,-.229,55.68238,-1.94837,-.25968,55.74704,-2.00348,0.0,55.60202,-1.93842,0.0,55.66299,-1.97913,-.13106,55.66947,-1.97058,-.21589,55.62077,-1.90461,-.4039,55.57209,-1.77051,-.36259,55.63728,-1.78977,-.44586,55.68651,-1.71331,-.23087,55.52323,-1.87376,-.61606,56.03897,-1.39486,-.60463,56.05743,-1.31861,-.55101,55.99739,-1.30206,-.41724,56.28862,-.98453,-.36255,56.1662,-1.0121,-.48601,56.20198,-1.05559,-.73301,56.11721,-1.53556,-.65917,56.07352,-1.5194,-.70546,56.10943,-1.61414,-.50944,56.11206,-1.1231,-.547,56.19824,-1.11339,-.91133,56.12998,-1.30355,-.84659,56.20401,-1.32848,-.17135,56.15342,-.87374,-.1905,56.10367,-.92792,-.26972,56.1137,-.94591,-.18355,56.09862,-.93016,-.0882,56.11914,-.9388,-.09889,56.03152,-.89995,-.56058,55.58116,-1.73612,-.47477,55.60918,-1.72823,-.69203,55.59157,-1.84777,-.76941,55.6529,-1.74925,-1.17334,55.85241,-1.49629,-1.14124,55.79719,-1.46327,-.17577,56.10647,-.92516,-.37058,55.8491,-1.12931,-.36406,55.8579,-1.03052,-.35793,56.16337,-1.00674,-.34408,56.15676,-.99383,-.36782,56.0055,-.97675,-.6066,56.01895,-1.68819,-.65674,56.07674,-1.70954,-.63558,56.05618,-1.63297,-.61646,55.81051,-1.71299,-.64559,55.862,-1.6818,-.57615,55.84468,-1.65398,-.72524,55.93362,-1.7052,-.78666,56.01413,-1.76971,-.68215,56.0143,-1.76013,-1.11516,55.9399,-1.23095,-1.18278,55.92873,-1.30432,-1.20854,55.90775,-1.26046,-1.01501,55.97401,-1.33698,-1.07278,55.91595,-1.37394,-1.11566,55.95981,-1.35492,-.85283,55.9197,-1.63645,-.8806,55.88768,-1.54259,-.87544,55.95536,-1.55734,-1.06329,55.88711,-1.44503,-1.00772,55.85847,-1.51572,-.60661,56.01354,-1.691,-.6087,56.01691,-1.69426,-.392,56.10006,-1.05048,-.54941,55.98186,-1.37253,-.55241,55.98234,-1.56321,-.54544,55.99011,-1.45139,-.50329,55.90792,-1.48851,-.43351,56.05687,-1.10757,-.49305,56.04208,-1.18579,-.43497,56.06417,-1.11226,-1.08967,55.7939,-1.39112,-1.09045,55.81344,-1.3323,-1.12144,55.7356,-1.29242,-.92485,55.80811,-1.34183,-.89296,55.8522,-1.37845,-.89089,55.83109,-1.50294,-.96916,55.81089,-1.24221,-1.02251,55.85052,-1.26886,-.93879,55.85684,-1.26139,-.9245,55.85464,-1.55699,-.91807,56.0112,-1.35362,-.9208,56.01848,-1.35146,-.87687,55.96447,-1.56194,-.86386,55.87252,-1.61925,-1.37675,55.83922,-1.24186,-1.33732,55.83257,-1.1764,-1.32557,55.87034,-1.27539,-1.36673,55.71227,-1.19873,-1.37832,55.71176,-1.23538,-1.30284,55.66284,-1.25394,-1.37982,55.74918,-1.31115,-1.37821,55.73909,-1.31025,-.89989,55.76606,-1.64523,-.8983,55.75664,-1.64253};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_7()
		{
			double[] value = {-1.18197,55.73866,-1.18577,-1.11258,55.7542,-1.20325,-.98709,55.72245,-1.43216,-1.06239,55.73049,-1.38689,-.9857,55.71219,-1.43383,-.9341,55.74139,-1.42185,-.91468,55.58013,-1.38858,-.89626,55.69008,-1.41142,-.87648,55.6722,-1.47377,-.68452,55.66825,-1.89239,-.68167,55.67555,-1.88951,-.88324,55.8149,-1.64569,-.82034,55.769,-1.73302,-.61782,55.70882,-1.56506,-.88433,55.68242,-1.47575,-.94276,55.69193,-1.17912,-.90438,55.69125,-1.10419,-.58309,55.54246,-1.92331,-.44754,55.51718,-1.99978,-.31005,55.71577,-2.09621,-.11461,55.46316,-1.91971,-.14563,55.45817,-1.91621,-.1216,55.52428,-1.91073,-.43365,55.72241,-1.36109,-.38447,55.76124,-1.18174,-.3879,55.7441,-1.27357,-.37879,55.77099,-1.18178,-.38475,55.79272,-1.08983,-.37863,55.79896,-1.08999,-.37568,55.80077,-1.00931,-.39972,55.73569,-1.27297,-.65677,55.67412,-.90714,-.51542,55.74591,-.89887,-.40788,55.7903,-.94437,-.11372,55.50461,-2.21214,-.93679,55.7057,-1.29266,-.94764,55.70618,-1.18245,-.71276,55.69115,-1.55521,-.53853,55.64532,-1.45669,-.5901,55.61036,-1.4768,-.72964,55.69282,-1.55213,-.9213,55.6969,-1.47563,-.87974,55.82526,-1.64319,-.94617,55.8377,-1.58789,-.54802,55.69062,-1.97822,-.87323,55.81981,-1.65027,-.97917,55.7742,-1.21461,-.97744,55.76211,-1.20742,-1.08274,55.76148,-1.24235,-1.04152,55.78473,-1.22241,-1.10439,55.72743,-1.34086,-1.06416,55.71863,-1.38898,-1.19692,55.68702,-1.28981,-1.23303,55.69178,-1.24278,-1.29982,55.6912,-1.29976,-1.24307,55.68755,-1.29079,-1.383,55.83975,-1.33372,-1.30985,55.69277,-1.29781,-1.2996,55.69309,-1.3055,-1.314,55.85817,-1.41239,-1.31578,55.86681,-1.41382,-1.0096,55.96665,-1.33799,-1.0658,55.90848,-1.37176,-1.07046,55.82726,-1.30633,-1.0636,55.89363,-1.37181,-.55178,56.02781,-1.25962,-.48425,55.99587,-1.20261,-.57778,55.89226,-1.60742,-.47295,55.91718,-1.36086,-.54096,55.98379,-1.45114,-.53852,56.34273,-1.03219,-.41571,56.28924,-.97892,-.78257,56.24068,-1.34558,-.77658,56.23953,-1.3457,-.78236,56.18691,-1.39967,-.8003,56.18177,-1.49521,-.79995,56.17764,-1.58509,-.80471,56.18102,-1.49495,-1.00879,55.68141,-1.47045,-1.09299,55.69012,-1.39809,-.88264,55.88331,-1.53397,-.7799,55.98298,-.95164,-1.04746,55.91772,-1.14988,-.65934,55.91987,-1.67625,-.8571,55.96376,-1.6626,-.52668,56.25055,-1.07471,-.47332,55.92614,-1.2315,-.08707,56.12523,-.93773,-.18562,55.79764,-.82141,-.12905,55.75406,-.78301,-.23506,55.78742,-.80473,-.49013,55.70674,-1.65283,-.58128,55.6144,-1.97295,-.65811,56.0742,-1.71576,-.29822,55.78899,-.84174,-.27448,55.8642,-.86722,-.26347,56.17497,-.91824,-.78812,56.18626,-1.39915,-.6594,56.09131,-1.33535,-.66048,56.07515,-1.41956};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_8()
		{
			double[] value = {-.09693,55.75603,-2.13238,0.0,55.72951,-2.12864,0.0,55.65372,-2.19451,0.0,55.52726,-1.91881,0.0,55.48161,-1.93265,-.54409,55.51332,-1.85029,-1.0693,55.89458,-1.4453,-1.05562,55.73632,-1.50575,-.78966,55.81564,-1.69648,-1.22476,55.91783,-1.45601,-.80582,56.17799,-1.58595,-.89443,56.14707,-1.18749,-.76691,56.27716,-1.1481,-.63424,56.35669,-1.09892,-.46448,55.75047,-1.09964,-.49592,55.71565,-.9804,-.59903,55.61129,-1.37451,-.472,55.73901,-1.02732,-.39028,55.79198,-1.00695,-.53919,55.63983,-1.44914,-.94061,55.59868,-1.17299,-.91568,55.60708,-1.08833,-1.05259,55.75722,-1.17406,-1.045,55.77664,-1.21072,-1.2512,55.84493,-1.46788,-1.14871,55.82152,-1.12853,-1.14567,55.88319,-1.50746,-1.17323,55.86241,-1.49985,-1.25246,55.85359,-1.47135,-1.39041,55.78316,-1.22971,-.34203,55.7913,-.79718,-.35502,55.83837,-.7591,-.45288,55.81151,-.82311,-.66143,55.87566,-.91846,-.64912,56.04163,-.91003,-.64994,55.96298,-.91485,-.46301,56.22049,-.90826,-.28073,56.16775,-.85901,-.36098,55.91591,-.94303,-.36488,55.92082,-.99799,-.37901,55.82806,-1.19167,-.34503,55.84444,-.909,-.37026,55.84602,-.95989,-.53378,55.77236,-1.50028,.37879,55.77099,-1.18178,.65677,55.67412,-.90714,.39907,55.79679,-.9481,.37568,55.80077,-1.00931,.40788,55.7903,-.94437,.93679,55.7057,-1.29266,.5901,55.61036,-1.4768,.52962,55.80836,-1.60481,.93154,55.73071,-1.41662,.98709,55.72245,-1.43216,1.22476,55.91783,-1.45601,1.23072,55.91099,-1.46074,.94617,55.8377,-1.58789,.87974,55.82526,-1.64319,.54802,55.69062,-1.97822,.68167,55.67555,-1.88951,1.08274,55.76148,-1.24235,1.045,55.77664,-1.21072,.97744,55.76211,-1.20742,.9812,55.76511,-1.20338,1.24307,55.68755,-1.29079,1.24006,55.70953,-1.33166,1.23303,55.69178,-1.24278,1.29982,55.6912,-1.29976,1.2996,55.69309,-1.3055,1.37545,55.84506,-1.3436,1.30985,55.69277,-1.29781,1.39041,55.78316,-1.22971,1.383,55.83975,-1.33372,.8571,55.96376,-1.6626,1.00772,55.85847,-1.51572,1.07278,55.91595,-1.37394,1.0658,55.90848,-1.37176,1.0096,55.96665,-1.33799,1.03521,55.77786,-1.43386,.41571,56.28924,-.97892,.50329,55.90792,-1.48851,.48179,55.83016,-1.43975,.80471,56.18102,-1.49495,.80582,56.17799,-1.58595,.8003,56.18177,-1.49521,1.0636,55.89363,-1.37181,1.00948,55.9241,-1.31665,.89089,55.83109,-1.50294,.96714,55.96978,-1.0861,.53852,56.34273,-1.03219,.34408,56.15676,-.99383,.17577,56.10647,-.92516,.18355,56.09862,-.93016,.50944,56.11206,-1.1231,.58879,56.16625,-1.17691,.55027,56.09636,-1.19194,.49305,56.04208,-1.18579,.49013,55.70674,-1.65283,.58309,55.54246,-1.92331,.51249,55.72644,-1.444};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_9()
		{
			double[] value = {.68215,56.0143,-1.76013,.65811,56.0742,-1.71576,.29822,55.78899,-.84174,.27448,55.8642,-.86722,.10817,55.85844,-.82269,.10082,55.94762,-.8595,.21716,55.94392,-.89004,.78812,56.18626,-1.39915,.63558,56.05618,-1.63297,.47477,55.60918,-1.72823,.30026,55.68048,-1.90729,.09693,55.75603,-2.13238,.11264,55.66782,-2.19013,.24032,55.53798,-2.13951,0.0,55.43722,-1.98567,1.17275,55.9393,-1.40699,1.0693,55.89458,-1.4453,1.05259,55.75722,-1.17406,1.05562,55.73632,-1.50575,.93444,55.73949,-1.57024,.6972,56.31437,-1.19003,.63424,56.35669,-1.09892,.85096,55.61809,-.99249,.77896,55.68201,-.93652,.72686,55.60842,-.9908,.46448,55.75047,-1.09964,.5519,55.64688,-1.36205,.59903,55.61129,-1.37451,.472,55.73901,-1.02732,.53919,55.63983,-1.44914,.87252,55.45028,-1.33983,.90473,55.44676,-1.2643,.82771,55.48836,-1.23512,.36835,55.79288,-.88548,.91568,55.60708,-1.08833,.91144,55.55369,-1.07984,.94061,55.59868,-1.17299,1.2512,55.84493,-1.46788,.45288,55.81151,-.82311,.35502,55.83837,-.7591,.66143,55.87566,-.91846,0.0,56.04077,-.58744,0.0,55.968,-.56094,.64994,55.96298,-.91485,.7799,55.98298,-.95164,1.15209,55.87172,-1.15176,.17976,56.14235,-.79826,1.04746,55.91772,-1.14988,1.11516,55.9399,-1.23095,.26347,56.17497,-.91824,.89443,56.14707,-1.18749,1.20854,55.90775,-1.26046,.36488,55.92082,-.99799,.38542,55.99434,-1.05262,.36098,55.91591,-.94303,.37058,55.8491,-1.12931,.38439,55.88374,-1.15156,.36406,55.8579,-1.03052,.48605,55.93063,-1.28027,.36042,55.90977,-1.07717,.93096,56.05386,-1.1379,.18693,56.10599,-.73954,.66507,55.79208,-.90238,1.31578,55.86681,-1.41382,1.17334,55.85241,-1.49629,1.09299,55.69012,-1.39809,.79316,55.51216,-1.28444,.49592,55.71565,-.9804,.59769,55.63618,-1.2422,.70715,56.24514,-1.03899,.78966,55.81564,-1.69648,.82034,55.769,-1.73302,.70253,55.79767,-1.71585,.96102,55.77274,-1.59514,.78666,56.01413,-1.76971,.72964,55.69282,-1.55213,.84161,55.68891,-1.59851,.82572,55.67569,-1.51774,.1216,55.52428,-1.91073,.78257,56.24068,-1.34558,.12905,55.75406,-.78301,.547,56.19824,-1.11339,.12114,55.7547,-.78522,.08707,56.12523,-.93773,.48425,55.99587,-1.20261,.52668,56.25055,-1.07471,.88264,55.88331,-1.53397,1.07731,55.7807,-1.2628,.79995,56.17764,-1.58509,1.07046,55.82726,-1.30633,1.08967,55.7939,-1.39112,1.34236,55.79495,-1.15962,1.04152,55.78473,-1.22241,.9213,55.6969,-1.47563,.44754,55.51718,-1.99978,.11372,55.50461,-2.21214,.25968,55.74704,-2.00348,-.93096,56.05386,-1.1379,-.62611,56.19759,-.94529,-1.23072,55.91099,-1.46074};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_10()
		{
			double[] value = {-1.29527,55.68712,-1.18724,-1.20527,55.78957,-1.40299,-1.10938,55.71537,-1.34336,-.91144,55.55369,-1.07984,-.85096,55.61809,-.99249,-.59769,55.63618,-1.2422,-.6972,56.31437,-1.19003,-1.17275,55.9393,-1.40699,-.70253,55.79767,-1.71585,-.44379,55.70512,-2.0275,-.96102,55.77274,-1.59514,-.93444,55.73949,-1.57024,-.93953,55.7201,-1.29441,-.94134,55.84589,-1.58332,-.82572,55.67569,-1.51774,-.84161,55.68891,-1.59851,-.16413,55.4533,-1.9755,-.19588,55.67422,-2.16592,-.19324,55.60605,-2.20475,-.11264,55.66782,-2.19013,-.12114,55.7547,-.78522,-.63344,55.95135,-1.69024,-.96714,55.96978,-1.0861,-.89925,55.94922,-1.00993,-1.00948,55.9241,-1.31665,-1.07731,55.7807,-1.2628,-.9812,55.76511,-1.20338,-.94683,55.77041,-1.30219,-.55022,55.68411,-1.9836,-.51362,55.74191,-.907,-.17925,55.75398,-2.12394,-.88016,55.68161,-1.48207,-.70887,55.6283,-1.521,-.7021,55.59017,-1.50319,-.44071,55.69957,-2.03621,-.87395,55.58518,-1.44964,-.96259,55.78199,-1.59719,-.87166,55.72481,-1.62184,-.87891,55.90504,-1.41179,-.87686,55.97506,-1.46031,-1.03288,55.81464,-1.24353,-.91257,55.7831,-1.46157,-.49368,56.0506,-1.18677,-.36042,55.90977,-1.07717,-.55374,55.98799,-1.37428,-.39285,56.10674,-1.05641,-1.06109,55.86632,-1.43571,-.56135,55.81678,-1.68167,-.57518,55.99298,-1.63073,-.59344,56.01712,-1.59831,-.20952,55.8588,-.85719,-.20361,55.86295,-.86394,-.21194,55.86278,-.86047,-.20836,56.03424,-.92016,-.46549,56.14015,-1.0804,-.28865,55.62528,-1.85171,-.12734,55.61746,-1.92519,-.07124,55.75329,-2.04524,-.7369,55.5793,-1.16942,-.57107,55.65719,-1.18273,-.75,55.53312,-1.32338,-.83591,55.46755,-1.38644,-.78571,55.49516,-1.42322,-.911,55.70106,-1.53805,-.75338,55.62169,-.9512,-.42731,56.06951,-.82705,-.34194,55.91864,-.76501,.44625,55.72364,-1.73142,.96259,55.78199,-1.59719,.87166,55.72481,-1.62184,.87891,55.90504,-1.41179,1.02251,55.85052,-1.26886,1.18278,55.92873,-1.30432,.65674,56.07674,-1.70954,.59111,56.08067,-1.26077,.28865,55.62528,-1.85171,.4699,55.52774,-1.79051,.7369,55.5793,-1.16942,.67256,55.57675,-1.3653,.78571,55.49516,-1.42322,.83591,55.46755,-1.38644,.75,55.53312,-1.32338,.911,55.70106,-1.53805,1.00879,55.68141,-1.47045,.64172,56.1313,-.92257,.46301,56.22049,-.90826,.27913,55.95052,-.89328,.85955,56.10587,-1.07555,.62611,56.19759,-.94529,.54788,55.88007,-.8748,1.25246,55.85359,-1.47135,.79099,55.49711,-1.43042,.86402,55.5136,-1.42393,.84256,55.46896,-1.39232,.81228,55.54067,-1.4577,.94511,55.59831,-1.27763,.83723,55.55357,-1.01361,.81241,55.53039,-1.10244,.89586,55.49819,-1.09453,.78963,55.5628,-1.04097};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_11()
		{
			double[] value = {.589,55.60637,-1.46764,.69435,55.54726,-1.4674,.92363,55.46559,-1.17555,.92991,55.48649,-1.26732,.93424,55.49939,-1.17346,.91253,55.44892,-1.26651,.81971,56.25088,-1.23913,1.03776,55.84728,-1.53765,1.0687,55.82447,-1.52874,.92453,55.93149,-1.31195,.81612,55.6004,-1.48946,.82173,55.66713,-1.50896,.3377,55.61769,-2.10829,.45986,55.61824,-2.04256,.12734,55.61746,-1.92519,.77658,56.23953,-1.3457,.68342,56.1916,-1.26997,.75542,56.28719,-1.27074,.70003,56.16914,-1.31604,.64389,56.24599,-1.18081,.27991,56.03978,-.92936,.22541,55.94551,-.88755,.60288,56.03114,-1.49006,.66048,56.07515,-1.41956,.09225,56.11626,-.73459,0.0,56.12448,-.94023,0.0,56.13021,-.93924,.55471,56.03552,-1.26197,.89925,55.94922,-1.00993,.78236,56.18691,-1.39967,.69269,56.31297,-1.19218,.6305,56.35554,-1.102,.96018,55.76944,-1.47582,1.17323,55.86241,-1.49985,.58327,55.7738,-1.75437,.11659,55.59129,-2.22177,.74733,55.61604,-.95621,.91598,55.46261,-1.17484,.69839,55.5496,-1.47578,-.74121,56.15706,-1.00766,0.0,56.1118,-.7164,-.09225,56.11626,-.73459,-.76918,56.07612,-.97168,-.85955,56.10587,-1.07555,-.89603,56.01276,-1.02632,-.54849,55.97382,-.87798,-.45477,55.88927,-.83538,-.54788,55.88007,-.8748,-.12134,55.90625,-.58906,-.86402,55.5136,-1.42393,-.79099,55.49711,-1.43042,-.84256,55.46896,-1.39232,-.81228,55.54067,-1.4577,-.94511,55.59831,-1.27763,-.81241,55.53039,-1.10244,-.83723,55.55357,-1.01361,-.89586,55.49819,-1.09453,-.78963,55.5628,-1.04097,-.589,55.60637,-1.46764,-.69435,55.54726,-1.4674,-.92991,55.48649,-1.26732,-.92363,55.46559,-1.17555,-.93424,55.49939,-1.17346,-.91253,55.44892,-1.26651,-.55836,55.69457,-.94402,-.64531,55.65727,-.94804,-.81971,56.25088,-1.23913,-1.03776,55.84728,-1.53765,-1.0687,55.82447,-1.52874,-.92453,55.93149,-1.31195,-.81612,55.6004,-1.48946,-.82173,55.66713,-1.50896,-.11659,55.59129,-2.22177,0.0,55.57864,-2.23472,-.58327,55.7738,-1.75437,-.68342,56.1916,-1.26997,-.75542,56.28719,-1.27074,-.70003,56.16914,-1.31604,-.58879,56.16625,-1.17691,-.64389,56.24599,-1.18081,-.63772,56.13023,-1.26238,-.27991,56.03978,-.92936,-.10082,55.94762,-.8595,-.21716,55.94392,-.89004,-.25393,55.80277,-.73699,-.27913,55.95052,-.89328,0.0,55.75697,-.7561,-.21625,56.03577,-.918,-.55471,56.03552,-1.26197,-.55027,56.09636,-1.19194,-.59111,56.08067,-1.26077,-1.03521,55.77786,-1.43386,-.69269,56.31297,-1.19218,-.6305,56.35554,-1.102,-.96018,55.76944,-1.47582,-.89926,55.49586,-1.37091,-.87981,55.45171,-1.34366,0.0,55.73479,-2.11615,-.84446,55.55823,-1.0099,-.90336,55.50198,-1.09318};
			return value;
		}
		private double[] getatlas_Coord_9_24_point_12()
		{
			double[] value = {-.87252,55.45028,-1.33983,-.69839,55.5496,-1.47578,-.90473,55.44676,-1.2643,-.74733,55.61604,-.95621,-.72731,56.14652,-1.71169,-.7306,56.14609,-1.71771,-.76038,56.28875,-1.26845,-.17871,55.80003,-.82589,-.22541,55.94551,-.88755,0.0,56.0774,-.64636,-.10817,55.85844,-.82269,0.0,56.02528,-.88496,0.0,55.94099,-.84156,-.56502,56.25607,-1.109,-.73216,56.1146,-1.45665,-.70375,56.11846,-1.36258,-.45986,55.61824,-2.04256,0.0,55.49811,-2.23002,0.0,55.7302,-2.044,-.70584,55.60898,-1.09796,-.79316,55.51216,-1.28444,-.82593,55.50678,-1.16039,-.82771,55.48836,-1.23512,-.23669,55.88113,-.67906,-.17976,56.14235,-.79826,-.60288,56.03114,-1.49006,.87981,55.45171,-1.34366,.84446,55.55823,-1.0099,.17871,55.80003,-.82589,.21625,56.03577,-.918,0.0,55.86764,-.8067,.56502,56.25607,-1.109,.73216,56.1146,-1.45665,.46549,56.14015,-1.0804,.7306,56.14609,-1.71771,1.14567,55.88319,-1.50746,.76038,56.28875,-1.26845,.82593,55.50678,-1.16039,.90336,55.50198,-1.09318,.89926,55.49586,-1.37091,.45477,55.88927,-.83538,.54849,55.97382,-.87798,.74121,56.15706,-1.00766,.76918,56.07612,-.97168,.89603,56.01276,-1.02632,.55836,55.69457,-.94402,.70584,55.60898,-1.09796,0.0,55.44468,-2.15472,.229,55.68238,-1.94837,.72731,56.14652,-1.71169,.70375,56.11846,-1.36258,.78241,56.17966,-1.6608,.78827,56.18033,-1.66427,-.72686,55.60842,-.9908,-.91598,55.46261,-1.17484,-.78241,56.17966,-1.6608,-.78827,56.18033,-1.66427};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getaxis_Geo_8_29_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,0,10,-1,11,12,13,-1,14,15,16,-1,17,18,13,-1,19,20,21,-1,22,7,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,22,36,37,-1,38,13,18,-1,39,40,41,-1,42,43,15,-1,44,45,46,-1,39,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,52,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,76,73,-1,77,73,76,-1,78,79,80,-1,81,79,68,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,94,58,57,-1,95,96,97,-1,98,99,100,-1,96,101,102,-1,103,104,105,-1,106,105,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,97,102,-1,118,119,120,-1,117,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,127,144,145,-1,121,146,147,-1,148,149,150,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,160,163,164,-1,161,165,166,-1,167,168,169,-1,59,169,168,-1,170,57,171,-1,172,173,111,-1,174,175,176,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,188,-1,189,190,191,-1,192,193,194,-1,195,189,192,-1,196,194,197,-1,119,118,198,-1,199,200,201,-1,202,203,204,-1,205,206,204,-1,207,34,33,-1,208,209,41,-1,210,46,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,213,222,-1,223,224,225,-1,224,226,65,-1,227,210,225,-1,228,229,65,-1,230,231,232,-1,231,61,60,-1,233,234,106,-1,234,233,110,-1,235,236,237,-1,238,239,240,-1,241,80,242,-1,243,244,245,-1,246,247,248,-1,249,250,251,-1,252,253,237,-1,126,128,254,-1,255,256,257,-1,258,256,195,-1,258,259,260,-1,261,262,263,-1,217,264,63,-1,265,266,267,-1,268,267,269,-1,270,271,272,-1,270,273,274,-1,158,275,276,-1,277,278,279,-1,279,280,277,-1,281,123,282,-1,283,284,285,-1,286,287,285,-1,288,289,290,-1,291,292,293,-1,294,295,296,-1,297,155,298,-1,299,300,164,-1,301,302,303,-1,299,304,300,-1,305,306,307,-1,308,307,309,-1,310,311,312,-1,313,314,315,-1,316,317,318,-1,319,320,321,-1,319,322,320,-1,323,309,324,-1,325,326,69,-1,84,327,328,-1,329,330,331,-1,0,332,333,-1,38,334,335,-1,334,11,335,-1,334,336,337,-1,338,339,340,-1,341,342,343,-1,344,345,346,-1,347,348,349,-1,350,351,352,-1,353,354,355,-1,356,357,358,-1,37,359,360,-1,361,334,38,-1,362,344,347,-1,363,334,337,-1,364,365,366,-1,367,368,369,-1,370,371,42,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,388,389,-1,390,391,392,-1,393,394,395,-1,396,397,398,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,406,405,367,-1,398,408,409,-1,410,411,412,-1,413,414,415,-1,416,417,418,-1,419,420,421,-1,422,423,382,-1,391,424,425,-1,389,388,426,-1,427,428,429,-1,430,431,432,-1,433,434,435,-1,436,437,434,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,468,469,470,-1,471,472,473,-1,474,475,476,-1,475,477,460,-1,478,479,454,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,489,490,491,-1,492,493,494,-1,495,496,492,-1,497,498,494,-1,499,500,501,-1,502,391,503,-1,504,505,506,-1,507,449,392,-1,445,409,446,-1,508,509,510,-1,511,512,513,-1,514,515,516,-1,182,517,180,-1,518,519,520,-1,521,522,523,-1,524,525,526,-1,527,528,529,-1,530,531,452,-1,532,533,534,-1,535,536,537,-1,532,536,533,-1,538,539,540,-1,358,357,541,-1,542,363,543,-1,356,544,545,-1,546,547,548,-1,549,550,551,-1,552,553,554,-1,555,556,557,-1,557,558,559,-1,558,560,393,-1,560,548,547,-1,367,560,368,-1,561,562,563,-1,564,565,566,-1,567,568,566,-1,442,441,569,-1,570,443,571,-1,439,570,572,-1,573,574,575,-1,419,411,410,-1,420,415,414,-1,245,576,243,-1,577,578,574,-1,579,580,581,-1,574,582,583,-1,461,584,585,-1,443,586,587,-1,458,587,586,-1,588,589,552,-1,590,591,592,-1,593,590,594,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_2()
		{
			int[] value = {595,596,597,-1,598,599,597,-1,600,601,490,-1,540,602,538,-1,529,603,604,-1,528,605,606,-1,607,606,608,-1,609,610,611,-1,486,612,613,-1,614,615,616,-1,617,618,619,-1,620,621,622,-1,623,495,624,-1,620,625,626,-1,627,628,629,-1,630,627,631,-1,632,633,634,-1,635,636,633,-1,637,638,639,-1,638,640,639,-1,315,314,641,-1,318,317,642,-1,637,322,643,-1,644,636,635,-1,401,400,504,-1,645,646,416,-1,394,393,645,-1,647,648,649,-1,650,651,652,-1,504,390,408,-1,653,654,635,-1,322,318,655,-1,642,628,655,-1,643,638,637,-1,634,636,640,-1,656,630,624,-1,657,629,658,-1,657,626,631,-1,631,626,659,-1,624,495,497,-1,660,488,621,-1,615,602,661,-1,662,614,641,-1,613,663,664,-1,665,666,607,-1,609,667,668,-1,669,670,671,-1,667,606,607,-1,529,528,606,-1,538,602,615,-1,598,672,599,-1,598,673,600,-1,594,674,675,-1,593,676,677,-1,677,678,679,-1,589,680,553,-1,681,584,461,-1,682,586,442,-1,443,442,586,-1,573,632,574,-1,683,623,659,-1,421,580,579,-1,579,581,683,-1,684,577,583,-1,421,625,622,-1,685,580,686,-1,578,575,574,-1,439,687,441,-1,688,569,441,-1,689,568,690,-1,564,566,568,-1,563,562,559,-1,368,560,547,-1,691,560,558,-1,554,395,552,-1,546,692,693,-1,694,695,696,-1,697,362,544,-1,698,536,539,-1,540,699,531,-1,700,536,532,-1,532,701,700,-1,451,702,703,-1,703,702,704,-1,704,527,703,-1,705,526,528,-1,527,706,528,-1,434,437,524,-1,707,452,531,-1,708,709,519,-1,508,710,484,-1,711,712,713,-1,714,715,534,-1,485,716,483,-1,483,513,512,-1,717,718,719,-1,717,511,513,-1,408,392,449,-1,717,720,398,-1,649,500,425,-1,501,721,722,-1,723,724,499,-1,687,438,688,-1,624,497,656,-1,493,725,494,-1,726,578,727,-1,412,592,418,-1,728,666,665,-1,508,709,708,-1,729,730,714,-1,731,485,484,-1,476,460,732,-1,474,733,734,-1,470,469,735,-1,472,736,450,-1,737,472,738,-1,466,465,479,-1,473,450,739,-1,740,741,444,-1,742,608,482,-1,681,477,464,-1,460,459,743,-1,467,744,745,-1,707,450,452,-1,523,739,450,-1,746,702,451,-1,704,747,454,-1,388,748,749,-1,688,750,749,-1,524,432,435,-1,751,433,752,-1,753,754,755,-1,425,500,503,-1,756,576,686,-1,417,757,410,-1,402,399,645,-1,402,645,367,-1,758,367,369,-1,403,383,759,-1,413,396,398,-1,413,720,760,-1,394,588,395,-1,761,690,553,-1,565,762,561,-1,392,391,502,-1,384,763,689,-1,764,378,765,-1,766,547,767,-1,768,374,769,-1,696,765,378,-1,542,366,365,-1,345,355,354,-1,360,359,343,-1,697,358,770,-1,771,772,773,-1,347,344,774,-1,772,774,346,-1,775,776,777,-1,343,342,778,-1,353,779,780,-1,781,343,778,-1,782,87,783,-1,308,323,654,-1,784,318,322,-1,784,785,786,-1,321,312,787,-1,300,312,166,-1,788,786,301,-1,299,789,302,-1,155,303,298,-1,155,154,303,-1,293,292,296,-1,314,313,291,-1,790,290,289,-1,791,792,793,-1,794,795,285,-1,796,797,286,-1,791,283,795,-1,283,282,192,-1,798,293,277,-1,273,799,274,-1,268,800,801,-1,800,802,801,-1,802,803,804,-1,216,263,217,-1,54,805,62,-1,806,256,258,-1,252,237,236,-1,807,248,808,-1,809,789,810,-1,251,250,811,-1,810,249,251,-1,157,239,812,-1,811,159,297,-1,245,244,685,-1,811,240,239,-1,813,814,815,-1,61,816,54,-1,817,816,61,-1,818,819,817,-1,223,232,231,-1,820,227,229,-1,224,229,225,-1,217,65,226,-1,821,822,823,-1,824,825,826,-1,280,206,798,-1,280,204,206,-1,204,827,828,-1,829,203,202,-1,830,831,829,-1,199,828,832,-1,119,833,194,-1,197,194,833,-1,193,834,194,-1,192,189,835,-1,192,836,193,-1,191,837,107,-1,187,838,198,-1,185,184,839,-1,152,840,841,-1,713,842,174,-1,201,150,149,-1,153,843,151,-1,844,845,153,-1,846,847,173,-1,171,848,114,-1,172,66,173,-1,167,92,849,-1,91,850,92,-1,167,851,93,-1,814,852,108,-1,305,236,853,-1,854,807,163,-1,162,855,856,-1,727,246,726,-1,82,857,858,-1,792,859,804,-1,860,839,841,-1,149,148,729,-1,152,151,731,-1,861,127,862,-1,863,138,140,-1,142,864,865,-1,863,865,864,-1,147,866,867,-1,120,868,869,-1,147,134,133,-1,870,120,139,-1,864,113,112,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_3()
		{
			int[] value = {281,871,872,-1,128,127,861,-1,806,125,132,-1,118,120,187,-1,188,187,120,-1,122,121,873,-1,874,108,852,-1,58,875,876,-1,104,100,191,-1,56,93,851,-1,79,81,877,-1,877,83,82,-1,328,70,74,-1,77,74,73,-1,878,77,879,-1,880,75,881,-1,79,882,846,-1,846,66,79,-1,264,84,64,-1,261,216,62,-1,883,884,818,-1,88,885,57,-1,816,52,54,-1,886,39,887,-1,888,46,227,-1,889,890,891,-1,886,821,40,-1,41,40,892,-1,893,30,894,-1,8,7,22,-1,33,35,895,-1,12,209,13,-1,8,896,6,-1,897,7,6,-1,31,5,32,-1,897,898,7,-1,899,900,901,-1,25,24,902,-1,902,903,25,-1,904,905,906,-1,895,907,33,-1,8,22,360,-1,30,208,894,-1,40,39,886,-1,890,374,891,-1,227,820,888,-1,39,48,887,-1,885,908,848,-1,816,55,52,-1,57,59,88,-1,909,331,86,-1,261,62,805,-1,215,60,216,-1,64,63,264,-1,66,68,79,-1,908,910,325,-1,880,51,75,-1,77,76,879,-1,77,328,74,-1,845,846,882,-1,80,79,877,-1,244,911,912,-1,168,913,89,-1,56,914,93,-1,103,105,915,-1,191,107,104,-1,875,852,814,-1,58,94,875,-1,873,916,122,-1,188,120,870,-1,170,101,96,-1,806,258,125,-1,917,128,861,-1,918,281,872,-1,112,863,864,-1,870,139,138,-1,147,146,134,-1,136,139,869,-1,120,869,139,-1,867,873,147,-1,865,143,142,-1,863,140,865,-1,871,793,919,-1,127,141,862,-1,731,920,152,-1,921,149,729,-1,922,923,924,-1,804,793,792,-1,797,925,290,-1,727,247,246,-1,855,926,856,-1,163,927,854,-1,166,165,300,-1,814,108,815,-1,167,169,851,-1,849,913,167,-1,89,913,329,-1,66,846,173,-1,171,885,848,-1,846,845,847,-1,845,843,153,-1,843,928,151,-1,929,201,149,-1,923,839,930,-1,174,176,711,-1,174,711,713,-1,841,931,152,-1,185,839,860,-1,187,198,118,-1,187,186,838,-1,191,190,837,-1,192,835,836,-1,193,916,834,-1,194,834,119,-1,832,200,199,-1,199,204,828,-1,198,838,279,-1,280,827,204,-1,932,933,895,-1,822,212,823,-1,783,818,884,-1,217,63,65,-1,820,229,228,-1,917,254,128,-1,883,818,230,-1,818,934,819,-1,61,230,817,-1,54,62,61,-1,813,935,814,-1,813,815,110,-1,236,235,246,-1,244,250,685,-1,297,936,811,-1,810,937,249,-1,251,809,810,-1,807,808,163,-1,236,305,252,-1,256,938,257,-1,806,938,256,-1,126,939,940,-1,216,261,263,-1,804,941,802,-1,800,269,802,-1,799,158,274,-1,798,277,280,-1,196,283,192,-1,791,282,283,-1,796,286,942,-1,285,287,794,-1,790,943,290,-1,662,314,291,-1,293,296,277,-1,944,945,925,-1,165,164,300,-1,789,809,302,-1,785,787,304,-1,300,787,312,-1,321,787,319,-1,784,786,316,-1,784,322,319,-1,654,946,308,-1,848,908,325,-1,783,947,782,-1,781,896,8,-1,334,363,948,-1,772,771,774,-1,774,348,347,-1,771,773,352,-1,372,949,950,-1,697,356,358,-1,360,343,8,-1,345,543,355,-1,11,951,952,-1,11,948,951,-1,378,366,696,-1,374,890,769,-1,377,766,767,-1,764,379,378,-1,408,390,392,-1,689,953,384,-1,502,389,392,-1,422,647,423,-1,761,553,680,-1,553,567,954,-1,394,416,588,-1,413,398,720,-1,504,955,390,-1,403,407,383,-1,758,406,367,-1,367,405,402,-1,760,720,513,-1,755,956,753,-1,434,524,435,-1,749,426,388,-1,750,438,431,-1,454,453,704,-1,736,746,451,-1,450,707,523,-1,428,755,507,-1,744,682,745,-1,732,460,743,-1,464,957,681,-1,742,958,608,-1,444,959,740,-1,473,472,450,-1,466,479,478,-1,472,737,736,-1,470,735,742,-1,959,734,740,-1,734,959,474,-1,960,665,958,-1,476,475,460,-1,484,920,731,-1,729,714,921,-1,961,962,510,-1,665,679,728,-1,612,963,669,-1,578,577,727,-1,493,964,725,-1,965,574,966,-1,438,750,688,-1,723,499,501,-1,722,967,968,-1,501,500,721,-1,717,398,409,-1,969,408,449,-1,717,513,720,-1,717,445,718,-1,483,716,513,-1,485,970,716,-1,714,534,971,-1,972,709,962,-1,711,176,973,-1,711,973,712,-1,484,509,508,-1,708,519,518,-1,531,699,707,-1,699,521,707,-1,437,525,524,-1,706,705,528,-1,530,703,974,-1,703,530,451,-1,532,975,701,-1,976,831,830,-1,533,535,976,-1,700,539,536,-1,698,539,538,-1,977,698,538,-1,978,979,980,-1,549,694,696,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_4()
		{
			int[] value = {546,548,692,-1,762,565,652,-1,554,393,395,-1,368,547,766,-1,459,585,743,-1,566,565,561,-1,568,689,564,-1,953,689,690,-1,687,688,441,-1,981,419,421,-1,685,686,245,-1,622,489,421,-1,411,981,491,-1,684,982,577,-1,581,983,683,-1,683,659,579,-1,632,966,574,-1,682,442,745,-1,690,761,953,-1,552,589,553,-1,679,984,677,-1,677,985,593,-1,598,596,673,-1,598,490,672,-1,538,615,977,-1,606,603,529,-1,667,603,606,-1,671,611,669,-1,668,610,609,-1,613,612,663,-1,641,314,662,-1,661,616,615,-1,963,986,618,-1,621,620,660,-1,659,623,631,-1,657,631,627,-1,627,630,628,-1,656,638,630,-1,634,633,636,-1,643,630,638,-1,642,629,628,-1,655,643,322,-1,653,946,654,-1,652,987,650,-1,647,649,988,-1,393,367,645,-1,416,394,645,-1,504,408,401,-1,637,320,322,-1,642,655,318,-1,641,989,315,-1,635,633,653,-1,632,634,966,-1,631,624,630,-1,629,657,627,-1,625,659,626,-1,624,631,623,-1,620,622,625,-1,661,617,619,-1,616,641,614,-1,613,990,486,-1,991,992,678,-1,993,994,675,-1,611,671,609,-1,606,457,608,-1,529,604,974,-1,540,995,602,-1,600,490,598,-1,598,597,596,-1,595,673,596,-1,593,985,590,-1,590,592,996,-1,395,588,552,-1,589,957,680,-1,458,586,682,-1,458,605,587,-1,443,587,571,-1,585,459,461,-1,573,997,632,-1,574,965,582,-1,574,583,577,-1,245,686,576,-1,420,419,415,-1,419,981,411,-1,572,751,439,-1,567,566,563,-1,561,563,566,-1,367,393,560,-1,560,691,548,-1,393,554,558,-1,557,691,558,-1,556,692,557,-1,553,954,554,-1,551,694,549,-1,546,767,547,-1,356,697,544,-1,542,365,363,-1,541,998,358,-1,536,698,537,-1,536,535,533,-1,534,975,532,-1,452,451,530,-1,974,703,529,-1,703,527,529,-1,705,524,526,-1,521,523,707,-1,519,999,520,-1,514,1000,515,-1,511,961,512,-1,1001,708,518,-1,445,717,409,-1,392,389,507,-1,955,504,506,-1,503,499,502,-1,499,503,500,-1,722,723,501,-1,684,496,495,-1,494,656,497,-1,496,1002,492,-1,492,494,498,-1,986,486,488,-1,584,589,1003,-1,487,621,488,-1,1004,1005,1000,-1,480,482,456,-1,478,454,747,-1,475,1006,477,-1,476,733,474,-1,470,738,468,-1,466,744,467,-1,464,1007,462,-1,465,753,479,-1,959,1008,474,-1,682,744,458,-1,744,456,458,-1,445,741,718,-1,450,736,451,-1,448,969,449,-1,444,741,445,-1,438,687,439,-1,434,433,436,-1,433,435,752,-1,432,1009,430,-1,429,430,427,-1,426,507,389,-1,425,503,391,-1,987,422,382,-1,416,418,588,-1,396,413,1010,-1,413,1011,414,-1,398,401,408,-1,407,403,405,-1,402,405,403,-1,401,1012,399,-1,987,1013,422,-1,502,387,389,-1,384,386,763,-1,953,1014,384,-1,383,1015,381,-1,380,364,378,-1,377,767,375,-1,371,43,42,-1,366,378,364,-1,347,544,362,-1,37,1016,359,-1,356,1017,357,-1,353,780,354,-1,779,350,352,-1,1018,347,349,-1,344,346,774,-1,341,343,359,-1,340,1019,338,-1,334,361,336,-1,1020,371,380,-1,334,948,11,-1,338,0,333,-1,8,343,781,-1,779,1021,350,-1,2,332,0,-1,331,1022,329,-1,328,64,84,-1,69,848,325,-1,316,318,784,-1,313,315,1023,-1,310,312,321,-1,308,309,323,-1,305,307,252,-1,304,787,300,-1,302,298,303,-1,164,789,299,-1,298,936,297,-1,294,944,295,-1,291,313,292,-1,290,156,288,-1,941,1024,1025,-1,285,942,286,-1,795,283,285,-1,281,282,791,-1,282,259,192,-1,276,274,158,-1,270,1026,273,-1,1026,270,272,-1,268,269,800,-1,265,857,266,-1,217,263,264,-1,258,195,259,-1,255,195,256,-1,254,939,126,-1,248,236,246,-1,243,911,244,-1,80,240,242,-1,238,812,239,-1,110,915,234,-1,106,837,233,-1,255,257,233,-1,935,813,938,-1,231,230,61,-1,230,818,817,-1,232,883,230,-1,228,65,77,-1,227,225,229,-1,65,229,224,-1,223,225,1027,-1,213,212,222,-1,220,1027,218,-1,217,226,215,-1,823,212,214,-1,210,227,46,-1,208,41,892,-1,207,33,1028,-1,279,827,280,-1,202,204,199,-1,205,204,203,-1,201,202,199,-1,198,833,119,-1,259,195,192,-1,196,192,194,-1,189,191,835,-1,188,1029,186,-1,183,1030,184,-1,178,1031,179,-1,922,931,841,-1,1032,172,111,-1,57,885,171,-1,59,168,88,-1,167,913,168,-1,167,93,92,-1,164,163,808,-1,166,162,161,-1,160,927,163,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_5()
		{
			int[] value = {162,856,160,-1,154,156,945,-1,1033,263,939,-1,155,1034,156,-1,1031,1035,1036,-1,150,1037,148,-1,873,121,147,-1,145,141,127,-1,143,862,141,-1,135,137,1038,-1,132,125,133,-1,131,1039,129,-1,146,1040,134,-1,142,1041,864,-1,260,125,258,-1,260,123,125,-1,1042,112,111,-1,119,868,120,-1,121,117,102,-1,171,114,116,-1,1032,111,113,-1,257,938,813,-1,110,815,108,-1,107,837,106,-1,104,107,105,-1,96,102,97,-1,98,100,874,-1,97,98,95,-1,57,170,94,-1,914,91,93,-1,88,168,89,-1,85,909,86,-1,811,242,240,-1,84,264,82,-1,80,241,78,-1,858,812,238,-1,73,881,75,-1,72,881,73,-1,69,326,70,-1,86,1043,87,-1,216,60,62,-1,885,88,908,-1,58,1044,59,-1,56,1045,52,-1,51,85,49,-1,47,14,48,-1,888,44,46,-1,374,373,906,-1,42,15,1046,-1,878,228,77,-1,41,47,39,-1,1047,13,209,-1,37,360,22,-1,34,1048,35,-1,30,893,31,-1,27,1049,28,-1,25,894,26,-1,7,898,23,-1,21,10,19,-1,1047,17,13,-1,335,11,13,-1,335,13,38,-1,9,1,0,-1,1050,1051,1052,-1,1053,1051,1050,-1,36,900,899,-1,36,1054,900,-1,893,1055,31,-1,903,1055,893,-1,1056,28,932,-1,1056,29,28,-1,895,826,907,-1,826,895,933,-1,1050,1057,1058,-1,1050,1052,1057,-1,19,0,1059,-1,0,19,10,-1,1060,4,1061,-1,1060,1058,4,-1,1047,208,30,-1,1047,209,208,-1,900,1062,901,-1,900,1063,1062,-1,933,892,826,-1,933,208,892,-1,888,1064,1065,-1,888,820,1064,-1,16,43,1066,-1,15,43,16,-1,1067,1053,9,-1,1067,1051,1053,-1,1067,1068,1051,-1,1069,1070,1071,-1,1069,1072,1070,-1,1073,1074,1070,-1,1073,1065,1074,-1,49,87,782,-1,49,85,87,-1,1022,909,1075,-1,1022,331,909,-1,934,914,819,-1,934,91,914,-1,876,52,1045,-1,876,53,52,-1,881,1076,880,-1,1076,881,72,-1,1077,1078,1079,-1,1078,1077,1080,-1,328,71,70,-1,328,327,71,-1,882,843,845,-1,843,882,1081,-1,81,83,877,-1,1082,83,81,-1,244,1083,250,-1,244,912,1083,-1,1040,131,134,-1,1084,131,1040,-1,95,875,94,-1,95,852,875,-1,834,873,867,-1,834,916,873,-1,132,1085,806,-1,1085,132,130,-1,917,1086,919,-1,917,861,1086,-1,863,870,138,-1,112,870,863,-1,864,115,113,-1,115,864,1041,-1,145,1087,1041,-1,1087,145,1039,-1,869,137,136,-1,1088,137,869,-1,254,919,793,-1,254,917,919,-1,1088,872,137,-1,1088,918,872,-1,1089,918,1088,-1,124,918,1089,-1,930,924,923,-1,178,924,930,-1,842,182,183,-1,713,182,842,-1,794,859,792,-1,1090,859,794,-1,263,266,264,-1,1033,266,263,-1,158,297,159,-1,158,799,297,-1,1091,856,926,-1,1091,854,856,-1,807,1091,853,-1,854,1091,807,-1,103,110,109,-1,915,110,103,-1,1044,56,851,-1,1044,1045,56,-1,850,849,92,-1,850,1092,849,-1,1076,910,1075,-1,1076,325,910,-1,177,173,847,-1,173,177,1093,-1,920,840,152,-1,840,920,1094,-1,181,148,1037,-1,1095,148,181,-1,839,922,841,-1,923,922,839,-1,174,183,185,-1,174,842,183,-1,924,845,844,-1,845,924,847,-1,201,1096,150,-1,201,200,1096,-1,835,100,99,-1,191,100,835,-1,831,203,829,-1,203,831,1097,-1,827,838,828,-1,827,279,838,-1,40,826,892,-1,824,826,40,-1,1062,895,35,-1,1062,932,895,-1,1098,214,1099,-1,1098,825,214,-1,218,1099,219,-1,1099,218,1100,-1,222,783,884,-1,947,783,222,-1,231,215,223,-1,60,215,231,-1,55,817,819,-1,55,816,817,-1,938,54,935,-1,938,805,54,-1,937,1101,1102,-1,937,1103,1101,-1,239,159,811,-1,157,159,239,-1,789,808,810,-1,789,164,808,-1,802,1104,801,-1,802,941,1104,-1,265,271,276,-1,265,272,271,-1,284,196,197,-1,284,283,196,-1,1105,942,1106,-1,942,1105,796,-1,1107,1108,1104,-1,1109,1108,1107,-1,1109,1110,1108,-1,289,1111,1112,-1,288,1111,289,-1,1025,1104,941,-1,1025,1107,1104,-1,1090,1024,859,-1,1024,1090,1025,-1,273,1034,799,-1,273,1113,1034,-1,303,944,294,-1,154,944,303,-1,154,945,944,-1,809,298,302,-1,809,936,298,-1,786,304,301,-1,786,785,304,-1,785,319,787,-1,319,785,784,-1,911,1081,78,-1,911,1114,1081,-1,1115,782,1116,-1,782,1115,49,-1,778,332,781,-1,1117,332,778,-1,1118,332,1117,-1,1118,333,332,-1,778,1119,1117,-1,342,1119,778,-1,339,1120,1121,-1,339,1122,1120,-1,364,951,365,-1,370,951,364,-1,349,774,771,-1,349,348,774,-1,347,1123,544,-1,347,1018,1123,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_6()
		{
			int[] value = {978,697,770,-1,362,697,978,-1,1124,1125,1126,-1,1124,1127,1125,-1,0,1019,1059,-1,338,1019,0,-1,1021,1128,1129,-1,1021,1126,1128,-1,543,337,355,-1,543,363,337,-1,1130,768,769,-1,1130,376,768,-1,380,1131,1020,-1,1131,380,379,-1,1132,1131,1133,-1,1131,1132,1134,-1,1135,1133,764,-1,1135,1136,1133,-1,695,650,1137,-1,651,650,695,-1,390,424,391,-1,424,390,955,-1,1138,1139,1013,-1,1138,967,1139,-1,762,1140,561,-1,762,1141,1140,-1,505,403,759,-1,404,403,505,-1,1136,1132,1133,-1,1142,1132,1136,-1,1012,645,399,-1,1012,646,645,-1,716,760,513,-1,1143,760,716,-1,759,506,505,-1,423,506,759,-1,428,956,755,-1,427,956,428,-1,440,435,432,-1,435,440,752,-1,747,702,746,-1,747,704,702,-1,1144,467,745,-1,463,467,1144,-1,735,743,960,-1,735,732,743,-1,739,740,473,-1,740,739,741,-1,448,959,444,-1,1008,959,448,-1,1145,1006,1008,-1,1007,1006,1145,-1,470,737,738,-1,737,470,481,-1,960,585,665,-1,960,743,585,-1,742,481,470,-1,742,482,481,-1,509,483,512,-1,483,509,484,-1,1005,1146,1147,-1,1005,1004,1146,-1,182,712,520,-1,712,182,713,-1,728,668,666,-1,668,728,1148,-1,591,589,588,-1,589,591,1003,-1,622,490,489,-1,622,672,490,-1,493,1149,964,-1,493,1150,1149,-1,1149,582,965,-1,582,1149,1150,-1,439,752,440,-1,752,439,751,-1,386,387,724,-1,386,385,387,-1,721,967,722,-1,721,1139,967,-1,408,446,409,-1,446,408,969,-1,522,718,523,-1,719,718,522,-1,731,970,485,-1,731,1151,970,-1,1152,714,971,-1,1152,921,714,-1,708,710,508,-1,708,1001,710,-1,973,1001,518,-1,973,176,1001,-1,1146,534,715,-1,1146,975,534,-1,432,705,1009,-1,705,432,524,-1,587,528,526,-1,528,587,605,-1,976,1152,971,-1,976,830,1152,-1,698,1153,537,-1,1153,698,977,-1,770,979,978,-1,770,1154,979,-1,550,1154,1155,-1,550,979,1154,-1,1155,692,556,-1,693,692,1155,-1,565,1138,652,-1,565,1156,1138,-1,559,555,557,-1,559,562,555,-1,1101,983,1102,-1,1101,982,983,-1,489,981,421,-1,981,489,491,-1,684,623,683,-1,684,495,623,-1,761,745,442,-1,745,761,1144,-1,680,1144,761,-1,957,1144,680,-1,1003,677,984,-1,677,1003,985,-1,674,595,597,-1,674,594,595,-1,1153,615,614,-1,977,615,1153,-1,671,1157,1158,-1,670,1157,671,-1,674,993,675,-1,674,1159,993,-1,599,1160,597,-1,1161,1160,599,-1,993,664,1162,-1,993,1159,664,-1,675,991,678,-1,991,675,994,-1,1162,663,1163,-1,664,663,1162,-1,617,963,618,-1,670,963,617,-1,670,669,963,-1,1002,493,492,-1,493,1002,1150,-1,619,657,658,-1,657,619,660,-1,629,989,658,-1,989,629,642,-1,1143,576,1011,-1,1143,1164,576,-1,1165,1166,1167,-1,1165,1168,1166,-1,760,1011,413,-1,760,1143,1011,-1,639,320,637,-1,639,1169,320,-1,658,641,616,-1,641,658,989,-1,997,633,632,-1,653,633,997,-1,995,670,617,-1,995,1157,670,-1,1161,486,990,-1,486,1161,487,-1,678,728,679,-1,992,728,678,-1,664,1170,613,-1,664,1159,1170,-1,1159,597,1160,-1,1159,674,597,-1,1158,609,671,-1,1158,604,609,-1,530,604,1158,-1,974,604,530,-1,614,1171,1153,-1,614,662,1171,-1,590,1003,591,-1,985,1003,590,-1,1172,997,573,-1,1172,1173,997,-1,727,982,1101,-1,727,577,982,-1,414,1174,420,-1,1174,414,756,-1,525,570,571,-1,525,437,570,-1,565,1175,1156,-1,564,1175,565,-1,555,561,1140,-1,555,562,561,-1,651,694,1141,-1,651,695,694,-1,692,691,557,-1,692,548,691,-1,549,979,550,-1,549,980,979,-1,541,767,546,-1,541,375,767,-1,998,770,358,-1,1154,770,998,-1,1176,1153,1171,-1,1176,537,1153,-1,537,1097,535,-1,537,1176,1097,-1,534,976,971,-1,976,534,533,-1,701,522,521,-1,701,514,522,-1,520,517,182,-1,520,999,517,-1,999,1177,517,-1,1177,999,1147,-1,1001,1094,710,-1,176,1094,1001,-1,1005,709,972,-1,519,709,1005,-1,729,1178,730,-1,729,1179,1178,-1,649,424,988,-1,649,425,424,-1,749,1014,688,-1,749,748,1014,-1,582,1002,496,-1,582,1150,1002,-1,656,725,634,-1,656,494,725,-1,672,621,487,-1,672,622,621,-1,591,418,592,-1,588,418,591,-1,1148,610,668,-1,610,1148,1163,-1,715,1147,1146,-1,1177,1147,715,-1,510,512,961,-1,510,509,512,-1,753,454,479,-1,753,956,454,-1,469,732,735,-1,469,476,732,-1,734,473,740,-1,734,471,473,-1,1180,747,746,-1,1180,478,747,-1,1006,464,477,-1,1006,1007,464,-1,1006,474,1008,-1,474,1006,475,-1,464,1144,957,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_7()
		{
			int[] value = {464,463,1144,-1,447,507,755,-1,447,449,507,-1,741,523,718,-1,741,739,523,-1,750,430,429,-1,750,431,430,-1,724,502,499,-1,724,387,502,-1,410,415,419,-1,410,757,415,-1,756,1011,576,-1,1011,756,414,-1,396,1181,397,-1,396,1010,1181,-1,970,1143,716,-1,1164,1143,970,-1,1015,1142,1136,-1,1182,1142,1015,-1,758,407,406,-1,758,1182,407,-1,400,402,404,-1,399,402,400,-1,386,1175,763,-1,386,1183,1175,-1,647,1013,1139,-1,422,1013,647,-1,388,385,748,-1,388,387,385,-1,696,1137,765,-1,1137,696,695,-1,381,1136,1135,-1,381,1015,1136,-1,764,1131,379,-1,1133,1131,764,-1,1134,1020,1131,-1,1020,1134,1167,-1,376,949,768,-1,375,949,376,-1,1167,1066,1020,-1,1066,1167,1166,-1,766,369,368,-1,1184,369,766,-1,544,1185,545,-1,544,1123,1185,-1,355,336,353,-1,355,337,336,-1,1129,1123,1021,-1,1185,1123,1129,-1,1186,336,340,-1,353,336,1186,-1,1126,1119,1128,-1,1126,1125,1119,-1,950,357,1017,-1,950,949,357,-1,543,344,362,-1,543,345,344,-1,349,350,1018,-1,350,349,351,-1,771,351,349,-1,771,352,351,-1,951,363,365,-1,951,948,363,-1,952,370,42,-1,952,951,370,-1,1125,1117,1119,-1,1125,1118,1117,-1,338,1122,339,-1,338,333,1122,-1,243,1114,911,-1,243,1187,1114,-1,72,325,1076,-1,72,326,325,-1,323,1188,654,-1,1188,323,324,-1,315,316,1023,-1,315,317,316,-1,309,310,324,-1,311,310,309,-1,306,309,307,-1,311,309,306,-1,299,301,304,-1,299,302,301,-1,796,278,295,-1,796,1105,278,-1,156,1113,288,-1,1034,1113,156,-1,859,941,804,-1,941,859,1024,-1,1112,790,289,-1,1112,1110,790,-1,1026,1110,1189,-1,1026,1108,1110,-1,285,1106,942,-1,285,284,1106,-1,284,833,1106,-1,833,284,197,-1,1171,291,1190,-1,1171,662,291,-1,267,272,265,-1,267,268,272,-1,857,276,275,-1,276,857,265,-1,189,255,190,-1,189,195,255,-1,1102,249,937,-1,1191,249,1102,-1,1192,237,1172,-1,235,237,1192,-1,233,813,110,-1,233,257,813,-1,935,53,814,-1,54,53,935,-1,883,220,221,-1,883,232,220,-1,212,947,222,-1,212,822,947,-1,225,218,1027,-1,225,210,218,-1,213,1099,214,-1,213,219,1099,-1,1100,1098,1099,-1,1100,1028,1098,-1,35,901,1062,-1,901,35,1048,-1,34,45,905,-1,207,45,34,-1,1029,832,186,-1,1029,179,832,-1,181,183,182,-1,181,1030,183,-1,1037,1030,181,-1,1193,1030,1037,-1,1094,175,840,-1,175,1094,176,-1,839,1035,930,-1,1035,839,184,-1,1095,729,148,-1,1095,1179,729,-1,1093,179,1029,-1,177,179,1093,-1,330,1092,331,-1,849,1092,330,-1,165,160,164,-1,161,160,165,-1,855,166,306,-1,855,162,166,-1,155,799,1034,-1,155,297,799,-1,82,266,857,-1,266,82,264,-1,287,1090,794,-1,1194,1090,287,-1,1193,150,1096,-1,150,1193,1037,-1,844,922,924,-1,844,931,922,-1,121,1040,146,-1,121,102,1040,-1,861,1038,1086,-1,861,862,1038,-1,866,1088,869,-1,1089,1088,866,-1,130,134,131,-1,130,132,134,-1,1039,1084,1087,-1,1084,1039,131,-1,144,262,129,-1,262,144,940,-1,1085,129,262,-1,1085,130,129,-1,119,867,868,-1,119,834,867,-1,113,114,1032,-1,114,113,115,-1,106,915,105,-1,234,915,106,-1,1084,102,101,-1,1084,1040,102,-1,98,852,95,-1,98,874,852,-1,59,851,169,-1,59,1044,851,-1,783,1043,1195,-1,783,87,1043,-1,250,242,811,-1,250,1083,242,-1,1082,84,83,-1,1082,327,84,-1,1082,68,67,-1,1082,81,68,-1,1081,928,843,-1,928,1081,1114,-1,1080,50,1078,-1,50,1080,1196,-1,75,879,76,-1,75,1196,879,-1,74,326,72,-1,326,74,70,-1,819,56,55,-1,819,914,56,-1,1043,331,1092,-1,331,1043,86,-1,1045,58,876,-1,1045,1044,58,-1,1116,821,886,-1,822,821,1116,-1,1078,49,1115,-1,1078,50,49,-1,1197,887,48,-1,887,1197,1079,-1,16,1071,1197,-1,1069,1071,16,-1,905,44,891,-1,44,905,45,-1,1066,1069,16,-1,1166,1069,1066,-1,878,820,228,-1,820,878,1064,-1,1063,932,1062,-1,1063,1056,932,-1,17,30,32,-1,17,1047,30,-1,1056,1061,4,-1,1061,1056,1063,-1,17,1198,20,-1,1198,17,32,-1,1199,1058,1060,-1,1199,1050,1058,-1,34,904,1048,-1,34,905,904,-1,1200,903,902,-1,1200,1055,903,-1,1055,5,31,-1,1055,1200,5,-1,1049,26,28,-1,1049,24,26,-1,1201,902,27,-1,1201,1200,902,-1,22,1054,36,-1,22,23,1054,-1,17,19,18,-1,17,20,19,-1,1046,14,47,-1,14,1046,15,-1,1052,1068,1202,-1,1051,1068,1052,-1,6,2,1,-1,6,896,2,-1,1058,5,4,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_8()
		{
			int[] value = {1058,1057,5,-1,1067,10,21,-1,1067,9,10,-1,1203,1050,1199,-1,1203,1053,1050,-1,1046,952,42,-1,1046,1204,952,-1,209,1204,41,-1,209,12,1204,-1,894,903,893,-1,25,903,894,-1,3,27,29,-1,1201,27,3,-1,26,208,933,-1,26,894,208,-1,1057,1202,1198,-1,1052,1202,1057,-1,20,1202,21,-1,1202,20,1198,-1,23,1061,1054,-1,1060,1061,23,-1,899,37,36,-1,37,899,1205,-1,4,29,1056,-1,4,3,29,-1,901,1205,899,-1,1205,901,1206,-1,12,952,1204,-1,952,12,11,-1,44,1065,1073,-1,44,888,1065,-1,1168,889,1072,-1,890,889,1168,-1,1206,1048,904,-1,901,1048,1206,-1,1072,1073,1070,-1,889,1073,1072,-1,1071,1074,1077,-1,1071,1070,1074,-1,909,51,880,-1,51,909,85,-1,90,1075,910,-1,1075,90,1022,-1,850,934,1195,-1,934,850,91,-1,66,71,67,-1,66,69,71,-1,1074,1080,1077,-1,1080,1074,1207,-1,1207,1065,1064,-1,1065,1207,1074,-1,67,327,1082,-1,327,67,71,-1,858,877,82,-1,858,238,877,-1,78,912,911,-1,241,912,78,-1,80,238,240,-1,80,877,238,-1,96,94,170,-1,96,95,94,-1,108,100,109,-1,108,874,100,-1,188,112,1042,-1,188,870,112,-1,170,116,101,-1,170,171,116,-1,918,123,281,-1,123,918,124,-1,871,1086,872,-1,871,919,1086,-1,142,145,1041,-1,141,145,142,-1,129,145,144,-1,129,1039,145,-1,137,1086,1038,-1,872,1086,137,-1,1041,116,115,-1,116,1041,1087,-1,125,1089,133,-1,125,124,1089,-1,930,1031,178,-1,1031,930,1035,-1,797,943,286,-1,290,943,797,-1,939,803,1033,-1,803,939,254,-1,157,275,158,-1,275,157,812,-1,925,156,290,-1,925,945,156,-1,853,926,305,-1,1091,926,853,-1,53,875,814,-1,53,876,875,-1,90,329,1022,-1,90,89,329,-1,1093,111,173,-1,1093,1042,111,-1,178,847,924,-1,847,178,177,-1,180,1095,181,-1,1179,1095,180,-1,1036,200,832,-1,1096,200,1036,-1,99,836,835,-1,117,836,99,-1,117,122,836,-1,829,201,929,-1,202,201,829,-1,1097,205,203,-1,1097,1176,205,-1,1190,1176,1171,-1,1190,205,1176,-1,907,1028,33,-1,1028,907,1098,-1,46,207,211,-1,46,45,207,-1,825,823,214,-1,825,824,823,-1,210,1100,218,-1,1100,210,211,-1,219,221,220,-1,219,213,221,-1,226,223,215,-1,226,224,223,-1,233,190,255,-1,233,837,190,-1,1083,241,242,-1,912,241,1083,-1,1103,727,1101,-1,1103,247,727,-1,247,808,248,-1,247,1103,808,-1,253,1172,237,-1,253,1173,1172,-1,1033,267,266,-1,267,1033,269,-1,268,1104,1108,-1,801,1104,268,-1,276,270,274,-1,276,271,270,-1,279,1105,198,-1,279,278,1105,-1,282,260,259,-1,260,282,123,-1,871,791,793,-1,281,791,871,-1,1112,1189,1110,-1,1112,1111,1189,-1,1189,288,1113,-1,1189,1111,288,-1,1208,1107,1025,-1,1208,1109,1107,-1,1194,1025,1090,-1,1025,1194,1208,-1,295,277,296,-1,278,277,295,-1,294,292,788,-1,292,294,296,-1,307,253,252,-1,253,307,308,-1,313,788,292,-1,1023,788,313,-1,320,310,321,-1,320,1169,310,-1,78,882,79,-1,78,1081,882,-1,1166,1072,1069,-1,1166,1168,1072,-1,779,1126,1021,-1,779,1124,1126,-1,2,781,332,-1,2,896,781,-1,1120,1127,1121,-1,1127,1120,1209,-1,380,370,364,-1,371,370,380,-1,1019,336,361,-1,1019,340,336,-1,1210,359,1016,-1,1210,341,359,-1,772,345,354,-1,345,772,346,-1,779,773,780,-1,779,352,773,-1,1121,1124,1186,-1,1124,1121,1127,-1,1121,340,339,-1,1186,340,1121,-1,1129,341,1210,-1,341,1129,1128,-1,777,37,1205,-1,777,1016,37,-1,1018,1021,1123,-1,1018,350,1021,-1,1205,775,777,-1,1206,775,1205,-1,1211,376,1130,-1,1211,377,376,-1,769,1168,1165,-1,1168,769,890,-1,1017,1206,950,-1,1206,1017,775,-1,1130,1165,1212,-1,1165,1130,769,-1,1213,1134,1132,-1,1213,1212,1134,-1,383,423,759,-1,382,423,383,-1,506,424,955,-1,988,424,506,-1,1156,967,1138,-1,968,967,1156,-1,1012,398,397,-1,1012,401,398,-1,1142,1213,1132,-1,1214,1213,1142,-1,1211,1214,1184,-1,1213,1214,1211,-1,646,397,1181,-1,1012,397,646,-1,412,417,410,-1,412,418,417,-1,757,413,415,-1,757,1010,413,-1,416,1181,417,-1,416,646,1181,-1,420,580,421,-1,420,1174,580,-1,1013,652,1138,-1,1013,987,652,-1,724,1183,386,-1,724,723,1183,-1,426,428,507,-1,426,429,428,-1,432,438,440,-1,432,431,438,-1,751,436,433,-1,436,751,572,-1,969,444,446,-1,448,444,969,-1,457,482,608,-1,456,482,457,-1,735,958,742,-1,735,960,958,-1,754,1007,1145,-1,462,1007,754,-1,465,463,462,-1,465,467,463,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_9()
		{
			int[] value = {481,1180,737,-1,1180,481,480,-1,447,1008,448,-1,1145,1008,447,-1,480,744,466,-1,480,456,744,-1,1000,972,515,-1,1005,972,1000,-1,663,669,611,-1,669,663,612,-1,984,584,1003,-1,585,584,984,-1,601,491,490,-1,411,491,601,-1,486,963,612,-1,486,986,963,-1,964,965,966,-1,965,964,1149,-1,492,497,495,-1,497,492,498,-1,1139,648,647,-1,648,1139,721,-1,514,719,522,-1,719,514,516,-1,511,515,961,-1,516,515,511,-1,1178,180,517,-1,180,1178,1179,-1,975,1004,701,-1,1004,975,1146,-1,706,1009,705,-1,706,455,1009,-1,706,453,455,-1,375,357,949,-1,357,375,541,-1,775,356,545,-1,1017,356,775,-1,1154,693,1155,-1,1154,998,693,-1,1155,551,550,-1,1155,556,551,-1,1140,556,555,-1,1140,551,556,-1,559,554,954,-1,559,558,554,-1,1014,569,688,-1,569,1014,953,-1,441,570,439,-1,441,443,570,-1,573,1192,1172,-1,1192,573,575,-1,581,1102,983,-1,1102,581,1191,-1,583,496,684,-1,496,583,582,-1,571,526,525,-1,571,587,526,-1,600,592,601,-1,996,592,600,-1,675,593,594,-1,675,676,593,-1,595,590,996,-1,595,594,590,-1,1157,540,531,-1,1157,995,540,-1,458,606,605,-1,457,606,458,-1,607,958,665,-1,958,607,608,-1,1160,1170,1159,-1,1160,1215,1170,-1,990,1160,1161,-1,990,1215,1160,-1,994,1162,991,-1,994,993,1162,-1,991,1163,1148,-1,1162,1163,991,-1,602,617,661,-1,617,602,995,-1,616,619,658,-1,661,619,616,-1,639,636,644,-1,636,639,640,-1,642,315,989,-1,642,317,315,-1,1188,635,654,-1,644,635,1188,-1,504,404,505,-1,504,400,404,-1,1164,243,576,-1,1164,1187,243,-1,650,1135,1137,-1,381,1135,650,-1,1173,653,997,-1,1173,946,653,-1,644,1169,639,-1,644,1188,1169,-1,643,628,630,-1,655,628,643,-1,634,638,656,-1,640,638,634,-1,626,660,620,-1,660,626,657,-1,618,660,619,-1,618,488,660,-1,618,986,488,-1,487,599,672,-1,487,1161,599,-1,992,1148,728,-1,991,1148,992,-1,1215,613,1170,-1,613,1215,990,-1,666,667,607,-1,666,668,667,-1,604,667,609,-1,604,603,667,-1,531,1158,1157,-1,530,1158,531,-1,673,996,600,-1,673,595,996,-1,675,677,676,-1,675,678,677,-1,659,421,579,-1,659,625,421,-1,683,982,684,-1,683,983,982,-1,578,1192,575,-1,1192,578,726,-1,1191,580,685,-1,1191,581,580,-1,437,572,570,-1,437,436,572,-1,953,442,569,-1,953,761,442,-1,564,763,1175,-1,564,689,763,-1,954,563,559,-1,563,954,567,-1,652,1141,762,-1,1141,652,651,-1,1141,551,1140,-1,1141,694,551,-1,980,696,366,-1,549,696,980,-1,546,998,541,-1,693,998,546,-1,978,366,542,-1,366,978,980,-1,699,539,700,-1,699,540,539,-1,535,831,976,-1,1097,831,535,-1,527,453,706,-1,527,704,453,-1,1000,701,1004,-1,1000,514,701,-1,521,700,701,-1,521,699,700,-1,1147,519,1005,-1,519,1147,999,-1,520,973,518,-1,520,712,973,-1,510,709,508,-1,709,510,962,-1,730,517,1177,-1,517,730,1178,-1,710,920,484,-1,1094,920,710,-1,717,516,511,-1,719,516,717,-1,648,500,649,-1,648,721,500,-1,455,430,1009,-1,455,427,430,-1,634,964,966,-1,634,725,964,-1,412,601,592,-1,412,411,601,-1,984,665,585,-1,665,984,679,-1,1163,611,610,-1,611,1163,663,-1,714,1177,715,-1,730,1177,714,-1,961,972,962,-1,972,961,515,-1,755,1145,447,-1,754,1145,755,-1,471,738,472,-1,471,468,738,-1,471,733,468,-1,733,471,734,-1,737,746,736,-1,737,1180,746,-1,1180,466,478,-1,1180,480,466,-1,468,476,469,-1,468,733,476,-1,681,460,477,-1,460,681,461,-1,589,681,957,-1,589,584,681,-1,427,454,956,-1,427,455,454,-1,749,429,426,-1,749,750,429,-1,462,753,465,-1,753,462,754,-1,723,968,1183,-1,723,722,968,-1,1174,686,580,-1,1174,756,686,-1,417,1010,757,-1,1010,417,1181,-1,970,1187,1164,-1,1187,970,1151,-1,764,1137,1135,-1,764,765,1137,-1,758,1184,1214,-1,758,369,1184,-1,383,1182,1015,-1,407,1182,383,-1,1182,1214,1142,-1,758,1214,1182,-1,690,567,553,-1,690,568,567,-1,384,748,385,-1,384,1014,748,-1,1183,1156,1175,-1,1183,968,1156,-1,423,988,506,-1,423,647,988,-1,987,381,650,-1,987,382,381,-1,1213,1130,1212,-1,1213,1211,1130,-1,1212,1167,1134,-1,1212,1165,1167,-1,1118,1122,333,-1,1209,1122,1118,-1,1209,1120,1122,-1,43,1020,1066,-1,1020,43,371,-1,1184,377,1211,-1,1184,766,377,-1,542,362,978,-1,542,543,362,-1,545,776,775,-1,545,1185,776,-1,353,1124,779,-1};
			return value;
		}
		private int[] getaxis_Geo_8_29_coordIndex_10()
		{
			int[] value = {353,1186,1124,-1,1185,1210,776,-1,1210,1185,1129,-1,1059,361,38,-1,1019,361,1059,-1,1128,342,341,-1,342,1128,1119,-1,372,768,949,-1,372,374,768,-1,373,950,1206,-1,373,372,950,-1,773,354,780,-1,354,773,772,-1,776,1016,777,-1,776,1210,1016,-1,1209,1125,1127,-1,1125,1209,1118,-1,328,65,64,-1,328,77,65,-1,308,1173,253,-1,308,946,1173,-1,1169,324,310,-1,1169,1188,324,-1,1023,786,788,-1,316,786,1023,-1,312,306,166,-1,306,312,311,-1,301,294,788,-1,303,294,301,-1,856,927,160,-1,854,927,856,-1,925,295,944,-1,925,796,295,-1,925,797,796,-1,943,1208,1194,-1,1208,943,790,-1,790,1109,1208,-1,790,1110,1109,-1,1189,273,1026,-1,273,1189,1113,-1,795,792,791,-1,795,794,792,-1,1106,198,1105,-1,198,1106,833,-1,293,1190,291,-1,1190,293,798,-1,272,1108,1026,-1,272,268,1108,-1,802,1033,803,-1,269,1033,802,-1,1085,261,805,-1,261,1085,262,-1,806,805,938,-1,1085,805,806,-1,248,853,236,-1,248,807,853,-1,811,809,251,-1,811,936,809,-1,1103,810,808,-1,1103,937,810,-1,1192,246,235,-1,726,246,1192,-1,250,1191,685,-1,250,249,1191,-1,220,223,1027,-1,220,232,223,-1,1195,818,783,-1,1195,934,818,-1,821,824,40,-1,824,821,823,-1,1028,211,207,-1,211,1028,1100,-1,825,907,826,-1,825,1098,907,-1,1190,206,205,-1,798,206,1190,-1,1152,829,929,-1,1152,830,829,-1,122,193,836,-1,122,916,193,-1,832,1031,1036,-1,832,179,1031,-1,828,186,832,-1,828,838,186,-1,184,1193,1035,-1,1030,1193,184,-1,185,175,174,-1,185,860,175,-1,840,860,841,-1,840,175,860,-1,149,1152,929,-1,149,921,1152,-1,928,731,151,-1,928,1151,731,-1,1042,1029,188,-1,1029,1042,1093,-1,1032,848,172,-1,114,848,1032,-1,913,330,329,-1,913,849,330,-1,98,117,99,-1,98,97,117,-1,926,306,305,-1,926,855,306,-1,275,858,857,-1,275,812,858,-1,793,803,254,-1,804,803,793,-1,286,1194,287,-1,943,1194,286,-1,1096,1035,1193,-1,1096,1036,1035,-1,153,931,844,-1,152,931,153,-1,1087,101,116,-1,101,1087,1084,-1,136,140,139,-1,136,135,140,-1,143,140,135,-1,865,140,143,-1,867,869,868,-1,867,866,869,-1,133,866,147,-1,133,1089,866,-1,862,135,1038,-1,862,143,135,-1,127,940,144,-1,126,940,127,-1,940,263,262,-1,940,939,263,-1,104,109,100,-1,103,109,104,-1,1075,880,1076,-1,880,1075,909,-1,172,69,66,-1,172,848,69,-1,1187,928,1114,-1,1151,928,1187,-1,1116,887,1115,-1,1116,886,887,-1,1064,879,1207,-1,1064,878,879,-1,1196,51,50,-1,51,1196,75,-1,1207,1196,1080,-1,1196,1207,879,-1,221,884,883,-1,221,222,884,-1,1092,1195,1043,-1,1092,850,1195,-1,90,908,88,-1,910,908,90,-1,782,822,1116,-1,822,782,947,-1,1079,1115,887,-1,1079,1078,1115,-1,1197,1077,1079,-1,1071,1077,1197,-1,1197,14,16,-1,48,14,1197,-1,891,1073,889,-1,891,44,1073,-1,933,28,26,-1,28,933,932,-1,1057,32,5,-1,1057,1198,32,-1,1054,1063,900,-1,1061,1063,1054,-1,18,1059,38,-1,1059,18,19,-1,898,1060,23,-1,1199,1060,898,-1,891,906,905,-1,891,374,906,-1,904,373,1206,-1,904,906,373,-1,1200,3,5,-1,1200,1201,3,-1,24,27,902,-1,24,1049,27,-1,1204,47,41,-1,47,1204,1046,-1,1068,21,1202,-1,1068,1067,21,-1,1199,897,1203,-1,897,1199,898,-1,1,897,6,-1,1,1203,897,-1,1,1053,1203,-1,1,9,1053,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getaxis_Coord_9_29_point_1()
		{
			double[] value = {0.0,54.74915,-2.35768,-.02328,54.74797,-2.39959,0.0,54.78218,-2.38669,-.12526,54.78897,-2.17927,-.10023,54.81324,-2.22443,-.14381,54.73204,-2.18302,-.02328,54.79874,-2.42156,-.04422,54.83658,-2.42003,0.0,54.86434,-2.40753,-.03414,54.71598,-2.38575,-.02043,54.69968,-2.3608,0.0,54.78877,-2.02645,-.04019,54.77467,-2.01348,-.03907,54.77438,-2.10382,-.09224,54.83042,-1.88334,-.06721,54.83371,-1.88895,-.07805,54.91042,-1.89844,-.07296,54.68465,-2.16878,-.03648,54.74237,-2.19376,-.03106,54.71014,-2.28115,-.06212,54.65262,-2.25626,-.04085,54.67392,-2.34965,-.03074,54.93437,-2.37817,-.04017,54.90144,-2.3625,-.15953,54.80649,-2.07294,-.15581,54.78013,-2.0728,-.14502,54.80771,-2.05172,-.14384,54.82466,-2.12582,-.12861,54.84302,-2.08449,-.12316,54.83066,-2.12786,-.12357,54.73244,-2.08568,-.13639,54.71525,-2.15134,-.12357,54.6719,-2.16327,-.11547,55.07348,-2.00871,-.06917,55.16623,-1.99946,-.08597,55.05629,-2.05998,-.02534,55.01472,-2.31161,0.0,55.05135,-2.32746,0.0,54.80009,-2.21874,-.21567,54.78023,-1.82636,-.23329,54.78306,-1.8477,-.13566,54.76928,-1.9193,0.0,54.7987,-1.91854,0.0,54.84256,-1.904,-.15093,55.1964,-1.92718,-.15749,55.18978,-1.93563,-.23041,55.20284,-1.86881,-.10298,54.78126,-1.88009,-.21014,54.82068,-1.83554,-.41947,54.90777,-1.56191,-.39749,54.96906,-1.58021,-.39393,54.97471,-1.4899,-.81501,55.08763,-1.32166,-.81764,55.09024,-1.30889,-.81693,55.15651,-1.30925,-.80603,55.04759,-1.36658,-.79805,55.04441,-1.35949,-.58284,55.10685,-1.20341,-.69788,55.09667,-1.25624,-.57804,55.10047,-1.21436,-.72701,55.18648,-1.48967,-.7654,55.14705,-1.42264,-.79148,55.18418,-1.33601,-.48416,55.34912,-1.52454,-.45019,55.35196,-1.52105,-.41001,55.29207,-1.61262,-.32018,55.28801,-1.23208,-.34006,55.34854,-1.29215,-.30466,55.38043,-1.28622,-.39594,55.25851,-1.27903,-.36373,55.27544,-1.43938,-.41002,55.30886,-1.33939,-.33327,55.15731,-1.42343,-.34619,55.19704,-1.54649,-.34886,55.25242,-1.47072,-.36972,55.07861,-1.53011,-.34577,55.18239,-1.57079,-.3614,55.28139,-1.60318,-.14825,55.39405,-1.27411,-.23144,55.4046,-1.26493,-.23514,55.50676,-1.30089,-.29981,55.40927,-1.30312,-.39622,55.50452,-1.43227,-.37778,55.45985,-1.39915,-.46113,55.41023,-1.46635,-.40178,54.9103,-1.46754,-.35965,54.89048,-1.38372,-.4183,54.88246,-1.45424,-.49069,55.09807,-1.20688,-.40494,55.01117,-1.25961,-.37705,55.0389,-1.26176,-.61289,54.93487,-1.43532,-.552,54.9435,-1.35572,-.64812,54.99205,-1.34787,-.69275,55.09204,-1.20533,-.70563,55.08548,-1.18439,-.61882,55.11035,-1.15261,-.68251,55.10246,-1.11578,-.7227,55.05632,-1.13596,-.74838,55.04095,-1.10117};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_2()
		{
			double[] value = {-.81304,54.99566,-1.1381,-.6093,55.12791,-1.16438,-.67969,55.11716,-1.11605,-.89984,54.96509,-1.17011,-.86619,54.96644,-1.14341,-.91679,54.96398,-1.15687,-.95859,54.98768,-1.12297,-.88133,54.97503,-1.12752,-.83004,55.03153,-1.20405,-.86764,55.00244,-1.19191,-.93174,55.03085,-1.22891,-.38368,55.23466,-1.04705,-.39663,55.25421,-1.03857,-.41936,55.23149,-1.10744,-.46352,55.18016,-1.15186,-.47401,55.19508,-1.14681,-.53199,55.16672,-1.16553,-.69976,55.0941,-1.04415,-.44719,55.25963,-.87673,-.55225,55.27116,-.87714,-.45034,55.25791,-.89308,-.70059,55.10738,-1.04354,-.70186,55.10674,-1.02708,-.7985,55.32255,-1.05956,-.79215,55.32085,-1.06304,-.81283,55.27637,-1.06731,-.76052,55.35293,-1.2823,-.7561,55.35771,-1.26472,-.77541,55.36157,-1.27256,-.72021,55.28893,-1.25157,-.73958,55.23311,-1.21417,-.70232,55.19231,-1.20685,-.79098,55.22217,-1.16073,-.77789,55.23503,-1.03561,-.77453,55.17495,-1.12859,-.5988,55.40546,-1.09226,-.61259,55.34262,-.99908,-.69838,55.36626,-1.05152,-.44997,55.34925,-1.01902,-.53083,55.31319,-.95261,-.53064,55.41121,-1.08234,-.64703,55.34428,-1.22634,-.57779,55.32466,-1.19709,-.58335,55.39076,-1.17204,-.7295,55.33487,-1.26903,-.6176,55.25792,-1.23025,-.73504,55.13891,-1.08583,-.72514,55.19379,-1.00005,-.09209,54.97259,-.65103,-.09657,54.97966,-.6381,-.1528,55.01839,-.67732,-.09333,55.05261,-1.19313,-.1105,55.03562,-1.17802,-.12019,55.05093,-1.18981,-.37952,55.73192,-.93446,-.35269,55.74369,-1.05344,-.38847,55.72964,-.93868,-.33625,55.69684,-1.25255,-.34698,55.69892,-1.24912,-.33659,55.69949,-1.24901,-.20466,55.93377,-1.19808,-.19534,55.96089,-1.14609,-.20681,56.03334,-1.14822,-.17665,55.93626,-1.25513,-.17565,55.89028,-1.19209,-.16828,55.93445,-1.11949,-.19156,56.04027,-1.11526,-.55842,54.98256,-1.30696,-.47841,55.05062,-1.23751,-.55462,55.05171,-1.26372,-.59757,55.11735,-1.16769,-.52364,55.15,-1.16765,-.37604,55.22835,-1.15973,-.32244,55.20759,-1.1049,-.04076,55.08509,-.94665,-.04231,55.05455,-1.05414,0.0,55.05766,-1.05028,-.27823,55.13739,-.99614,-.23613,55.07732,-1.00279,-.28649,55.12974,-.92947,0.0,55.02062,-.71215,-.09916,55.00714,-.72567,0.0,55.10987,-.79856,-.07641,55.08579,-.8464,-.16917,55.057,-.9197,-.11043,55.07109,-.93075,-.35775,55.21205,-.86571,-.43017,55.25008,-.88313,-.39726,55.23893,-.95854,-.85619,55.14939,-1.01518,-.90159,55.08174,-1.04708,-.84478,55.00348,-1.10524,-.78415,55.22759,-.95607,-.70712,55.17903,-.93512,-.6567,55.25805,-.87036,-.87108,55.18817,-1.06503,-.70903,55.30205,-.86508,-.64476,55.32001,-.82816,-.46659,55.36466,-.81292,-.2062,55.21756,-.71696};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_3()
		{
			double[] value = {-.21867,55.11059,-.73643,-.20621,55.07517,-.65146,-.16762,55.17948,-.62988,-.11099,55.27959,-.62295,-.14199,55.27766,-.69694,-.08822,55.36712,-.66019,-.17732,55.39497,-.71234,-.16986,55.16122,-1.93623,-.12357,54.77026,-1.99826,-.08072,54.78106,-2.00293,-.33516,55.2022,-1.78619,-.24865,55.17236,-1.86884,-.42284,54.88063,-1.68792,-.43653,54.95136,-1.72821,-.34138,54.91538,-1.79894,-.65699,55.21427,-1.52987,-.72988,55.25117,-1.40081,-.59256,55.31151,-1.50524,-.38464,55.13251,-1.78344,-.43349,55.02879,-1.75985,-.52202,55.05411,-1.70447,-.51819,54.97993,-1.67497,-.49145,54.90726,-1.62074,-.57285,55.1712,-1.63583,-.44421,55.23844,-1.66961,-.41304,55.22377,-1.7055,-.50351,55.28606,-1.59223,-.30756,55.23407,-1.78242,-.33964,55.25709,-1.69731,-.37055,55.25981,-1.69874,-.73564,55.06748,-1.52918,-.69016,55.10063,-1.57073,-.6245,55.08455,-1.63121,-.96485,55.05473,-1.15134,-.9671,54.99251,-1.15359,-.07643,56.15248,-1.3602,-.10028,56.09657,-1.34407,-.073,56.19436,-1.33557,-.32408,55.56197,-1.36033,-.27037,55.64877,-1.28216,-.25632,55.60441,-1.31204,-.15856,55.51844,-1.30256,-.18519,55.5921,-1.26349,0.0,55.38535,-1.26904,-.05483,55.51065,-1.31886,0.0,55.48848,-1.31581,-.07577,56.06372,-1.37749,-.07059,55.99156,-1.35525,-.1363,56.01629,-1.32336,-.08042,55.69871,-1.26379,-.06887,55.62192,-1.28475,-.15029,55.71917,-1.21013,-.12846,56.20117,-1.25783,-.05912,56.25938,-1.25279,-.80943,55.40683,-1.29138,-.93095,55.13406,-1.10949,-.87432,55.21879,-1.12959,-.93005,55.14287,-1.18719,-.82612,55.26611,-1.08543,-.82956,55.25469,-1.02712,-.8226,55.27556,-1.06584,-.75512,55.28036,-1.33254,-.73604,55.2946,-1.26411,-.67654,55.38788,-1.41175,-.53049,55.43005,-1.46855,-.48075,55.54168,-1.37522,-.5341,55.4379,-1.46142,-.57426,55.47901,-1.3934,-.59786,55.54831,-1.29698,-.68602,55.47206,-1.33317,-.50868,55.64782,-1.18539,-.52269,55.6168,-1.24549,-.55564,55.57969,-1.27932,-.4095,55.70976,-1.14336,-.42962,55.68312,-1.20311,-.34214,55.62649,-1.32957,-.44723,55.6173,-1.29862,-.2459,55.53051,-.78739,-.33467,55.49549,-.80178,-.34069,55.39578,-.80254,-.25138,55.41316,-.77441,-.79336,55.36822,-1.08594,-.78554,55.3262,-.98081,-.73226,55.36107,-.8805,-.66993,55.38891,-.83223,-.68767,55.48042,-.8448,-.59056,55.5893,-.82618,-.69916,55.54022,-.86744,-.4358,55.69419,-.98529,-.49549,55.65695,-.90967,-.48161,55.63665,-.84508,-.06395,55.55014,-.74087,-.15923,55.64121,-.7833,-.15251,55.54062,-.77415,-.24233,55.68621,-.85774,-.3474,55.59536,-.8158,-.24668,55.62257,-.80918,-.34688,55.74863,-1.13891,-.27548,55.7241,-1.02761,-.16684,55.85018,-1.06789};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_4()
		{
			double[] value = {-.15101,55.90346,-1.08052,-.19192,55.7931,-.94596,-.22208,55.78414,-1.04915,-.27338,55.72566,-.9191,-.14582,55.86581,-.96249,-.14209,56.13771,-1.23702,-.16289,56.11998,-1.16151,-.10347,56.19465,-1.18096,-.0433,56.24235,-1.17269,-.09609,56.15737,-1.08587,-.08305,56.11258,-1.0115,-.1162,56.10227,-1.05702,-.13344,56.02791,-1.00754,-.0648,55.65668,-.77016,0.0,55.66096,-.76344,0.0,55.76465,-.79721,-.0598,55.80206,-.86746,0.0,55.80909,-.83293,0.0,55.85268,-.85825,-.06363,55.93879,-.92029,0.0,56.03521,-.9443,-.09298,56.03238,-.97116,0.0,55.93262,-.88504,-.04565,56.21804,-1.08962,-.04754,56.16646,-1.03431,-.36243,55.14414,-1.29616,-.36301,55.20334,-1.36074,-.4241,55.35922,-1.39975,-.38062,55.32867,-1.49738,-.36467,54.96259,-1.30835,-.40143,54.9179,-1.3438,-.35797,54.8969,-1.36487,.02328,54.74797,-2.39959,.03414,54.71598,-2.38575,.03907,54.77438,-2.10382,0.0,54.80487,-2.11702,.07296,54.68465,-2.16878,.07815,54.74388,-2.09063,.02043,54.69968,-2.3608,.04085,54.67392,-2.34965,.06212,54.65262,-2.25626,.04017,54.90144,-2.3625,.05332,54.81766,-2.41258,.04422,54.83658,-2.42003,.14502,54.80771,-2.05172,.13848,54.77431,-2.06036,.15581,54.78013,-2.0728,.12861,54.84302,-2.08449,.14445,54.83034,-2.09561,.14384,54.82466,-2.12582,.12526,54.78897,-2.17927,.14081,54.79158,-2.16756,.15835,54.74243,-2.17566,.12357,54.6719,-2.16327,.1375,54.74304,-2.08807,.12357,54.73244,-2.08568,.08597,55.05629,-2.05998,.06917,55.16623,-1.99946,.11547,55.07348,-2.00871,.03074,54.93437,-2.37817,0.0,54.94633,-2.38335,.03648,54.74237,-2.19376,.14139,54.81682,-2.01841,.08072,54.78106,-2.00293,.10298,54.78126,-1.88009,.13566,54.76928,-1.9193,.23329,54.78306,-1.8477,.3614,55.28139,-1.60318,.33964,55.25709,-1.69731,.33218,55.24935,-1.69362,.05773,54.78503,-1.89517,.06721,54.83371,-1.88895,.01227,55.20796,-2.04189,0.0,55.19164,-2.08485,0.0,55.22117,-2.00188,.15749,55.18978,-1.93563,.15093,55.1964,-1.92718,.224,55.21197,-1.86676,.21567,54.78023,-1.82636,.21014,54.82068,-1.83554,.09224,54.83042,-1.88334,.41947,54.90777,-1.56191,.40178,54.9103,-1.46754,.39393,54.97471,-1.4899,.81501,55.08763,-1.32166,.79651,55.08604,-1.31917,.79805,55.04441,-1.35949,.69408,55.09303,-1.26725,.69788,55.09667,-1.25624,.58284,55.10685,-1.20341,.47915,55.10387,-1.21152,.49069,55.09807,-1.20688,.49547,55.10766,-1.198,.41001,55.29207,-1.61262,.45019,55.35196,-1.52105,.48416,55.34912,-1.52454,.30466,55.38043,-1.28622,.34006,55.34854,-1.29215,.32018,55.28801,-1.23208,.36373,55.27544,-1.43938};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_5()
		{
			double[] value = {.36301,55.20334,-1.36074,.39594,55.25851,-1.27903,.34886,55.25242,-1.47072,.345,55.08789,-1.48462,.33327,55.15731,-1.42343,.34619,55.19704,-1.54649,.34577,55.18239,-1.57079,.36972,55.07861,-1.53011,.42796,55.18841,-1.1907,.37604,55.22835,-1.15973,.32408,55.56197,-1.36033,.33152,55.62521,-1.33052,.38267,55.51861,-1.41983,.23144,55.4046,-1.26493,.15856,55.51844,-1.30256,.23514,55.50676,-1.30089,.46113,55.41023,-1.46635,.37778,55.45985,-1.39915,.39622,55.50452,-1.43227,.25632,55.60441,-1.31204,.18519,55.5921,-1.26349,.21183,55.66577,-1.22443,.35965,54.89048,-1.38372,.34742,54.90384,-1.3769,.37705,55.0389,-1.26176,.40494,55.01117,-1.25961,.69275,55.09204,-1.20533,.68251,55.10246,-1.11578,.61882,55.11035,-1.15261,.70563,55.08548,-1.18439,.7227,55.05632,-1.13596,.80151,55.03812,-1.18594,.81304,54.99566,-1.1381,.91679,54.96398,-1.15687,.88133,54.97503,-1.12752,.86619,54.96644,-1.14341,.95859,54.98768,-1.12297,.9356,55.02419,-1.07964,.83004,55.03153,-1.20405,.93174,55.03085,-1.22891,.86764,55.00244,-1.19191,.90652,55.12598,-1.24769,.82676,55.20691,-1.19831,.93005,55.14287,-1.18719,.41936,55.23149,-1.10744,.38368,55.23466,-1.04705,.40373,55.21723,-1.11114,.53199,55.16672,-1.16553,.47401,55.19508,-1.14681,.52364,55.15,-1.16765,.45034,55.25791,-.89308,.55225,55.27116,-.87714,.44719,55.25963,-.87673,.70186,55.10674,-1.02708,.70059,55.10738,-1.04354,.69976,55.0941,-1.04415,.79215,55.32085,-1.06304,.7985,55.32255,-1.05956,.8226,55.27556,-1.06584,.77541,55.36157,-1.27256,.7561,55.35771,-1.26472,.76052,55.35293,-1.2823,.70232,55.19231,-1.20685,.73958,55.23311,-1.21417,.72021,55.28893,-1.25157,.77453,55.17495,-1.12859,.77789,55.23503,-1.03561,.79098,55.22217,-1.16073,.5988,55.40546,-1.09226,.67909,55.39737,-1.1297,.69838,55.36626,-1.05152,.53064,55.41121,-1.08234,.53083,55.31319,-.95261,.44997,55.34925,-1.01902,.57779,55.32466,-1.19709,.64703,55.34428,-1.22634,.66586,55.38751,-1.19894,.7295,55.33487,-1.26903,.72514,55.19379,-1.00005,.73504,55.13891,-1.08583,.7507,55.29667,-1.01941,.71994,55.3353,-1.01542,.7853,55.36144,-1.08849,.12019,55.05093,-1.18981,.1105,55.03562,-1.17802,.09333,55.05261,-1.19313,.38847,55.72964,-.93868,.36221,55.74296,-1.0555,.37952,55.73192,-.93446,.33659,55.69949,-1.24901,.34698,55.69892,-1.24912,.33625,55.69684,-1.25255,.20466,55.93377,-1.19808,.20833,56.02708,-1.20577,.20681,56.03334,-1.14822,.17565,55.89028,-1.19209,.17665,55.93626,-1.25513,.16828,55.93445,-1.11949,.19534,55.96089,-1.14609,.55462,55.05171,-1.26372};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_6()
		{
			double[] value = {.46911,54.97059,-1.29868,.55842,54.98256,-1.30696,.57804,55.10047,-1.21436,.47841,55.05062,-1.23751,.36243,55.14414,-1.29616,.32758,55.07315,-1.3788,.32793,54.9742,-1.334,.59757,55.11735,-1.16769,.14184,55.02936,-1.11399,.17405,55.03793,-1.13379,.19984,55.05821,-1.08393,.26326,55.14175,-1.0835,.18596,55.05299,-1.14622,.22218,55.14887,-1.17489,.28649,55.12974,-.92947,.23613,55.07732,-1.00279,.27823,55.13739,-.99614,.09916,55.00714,-.72567,.11043,55.07109,-.93075,.16917,55.057,-.9197,.07641,55.08579,-.8464,.35775,55.21205,-.86571,.3438,55.1958,-.94047,.39726,55.23893,-.95854,.84478,55.00348,-1.10524,.90159,55.08174,-1.04708,.85619,55.14939,-1.01518,.70712,55.17903,-.93512,.78415,55.22759,-.95607,.70903,55.30205,-.86508,.57061,55.33678,-.81528,.46659,55.36466,-.81292,.2062,55.21756,-.71696,.16762,55.17948,-.62988,.20621,55.07517,-.65146,.11099,55.27959,-.62295,.14199,55.27766,-.69694,.08822,55.36712,-.66019,.25138,55.41316,-.77441,.26976,55.3553,-.77336,.34069,55.39578,-.80254,.16986,55.16122,-1.93623,.16219,54.78782,-1.95374,.12357,54.77026,-1.99826,.11022,54.91313,-2.06436,.06606,55.02862,-2.11048,.24865,55.17236,-1.86884,.30756,55.23407,-1.78242,.33516,55.2022,-1.78619,.34439,54.85411,-1.7716,.34138,54.91538,-1.79894,.43653,54.95136,-1.72821,.59256,55.31151,-1.50524,.72988,55.25117,-1.40081,.50351,55.28606,-1.59223,.52202,55.05411,-1.70447,.43349,55.02879,-1.75985,.46834,55.15133,-1.70691,.44421,55.23844,-1.66961,.57285,55.1712,-1.63583,.37055,55.25981,-1.69874,.63009,55.0092,-1.59406,.6245,55.08455,-1.63121,.69016,55.10063,-1.57073,.77873,55.03553,-1.48312,.62808,54.9486,-1.49996,.73564,55.06748,-1.52918,.72701,55.18648,-1.48967,.7654,55.14705,-1.42264,.86904,55.13265,-1.27243,.96485,55.05473,-1.15134,.93095,55.13406,-1.10949,.9671,54.99251,-1.15359,.073,56.19436,-1.33557,.10028,56.09657,-1.34407,.07643,56.15248,-1.3602,.08308,55.39002,-1.27745,.07059,55.99156,-1.35525,.07577,56.06372,-1.37749,.15029,55.71917,-1.21013,.06887,55.62192,-1.28475,.08042,55.69871,-1.26379,.16819,56.0167,-1.28356,.1363,56.01629,-1.32336,.68654,55.388,-1.39819,.80943,55.40683,-1.29138,.87432,55.21879,-1.12959,.87108,55.18817,-1.06503,.53049,55.43005,-1.46855,.67654,55.38788,-1.41175,.57426,55.47901,-1.3934,.5341,55.4379,-1.46142,.39631,55.51397,-1.42486,.65161,55.541,-1.24975,.59786,55.54831,-1.29698,.55564,55.57969,-1.27932,.50868,55.64782,-1.18539,.49864,55.65587,-1.15444,.42962,55.68312,-1.20311,.4095,55.70976,-1.14336};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_7()
		{
			double[] value = {.44723,55.6173,-1.29862,.34214,55.62649,-1.32957,.2459,55.53051,-.78739,.73226,55.36107,-.8805,.66993,55.38891,-.83223,.82956,55.25469,-1.02712,.78554,55.3262,-.98081,.79342,55.39191,-1.00904,.79336,55.36822,-1.08594,.68767,55.48042,-.8448,.69916,55.54022,-.86744,.59056,55.5893,-.82618,.48161,55.63665,-.84508,.49549,55.65695,-.90967,.06395,55.55014,-.74087,.15251,55.54062,-.77415,.15923,55.64121,-.7833,.3474,55.59536,-.8158,.37058,55.66395,-.84718,.24233,55.68621,-.85774,.27548,55.7241,-1.02761,.35269,55.74369,-1.05344,.34688,55.74863,-1.13891,.1744,55.82043,-1.15777,.15101,55.90346,-1.08052,.24807,55.69759,-1.14209,.22208,55.78414,-1.04915,.14582,55.86581,-.96249,.11312,55.86522,-.91658,.1235,55.80259,-.88345,.1344,55.93817,-.96186,.16684,55.85018,-1.06789,.12846,56.20117,-1.25783,.10347,56.19465,-1.18096,.16289,56.11998,-1.16151,.04565,56.21804,-1.08962,.09609,56.15737,-1.08587,.09298,56.03238,-.97116,.13344,56.02791,-1.00754,.08305,56.11258,-1.0115,.1162,56.10227,-1.05702,.0648,55.65668,-.77016,.0598,55.80206,-.86746,.06363,55.93879,-.92029,.04754,56.16646,-1.03431,.38062,55.32867,-1.49738,.4241,55.35922,-1.39975,.35797,54.8969,-1.36487,.40143,54.9179,-1.3438,.36467,54.96259,-1.30835,.43732,54.87912,-1.5528,.44933,54.87199,-1.55934,.50799,54.89533,-1.4639,.0433,56.24235,-1.17269,0.0,56.24226,-1.08618,.0639,55.86833,-.8827,.19156,56.04027,-1.11526,.19192,55.7931,-.94596,.15037,55.73603,-.83802,.21573,55.73383,-1.13634,.27338,55.72566,-.9191,.24668,55.62257,-.80918,0.0,55.56283,-.7263,.5923,55.59556,-.83317,.59167,55.61209,-.91118,.8532,55.43101,-1.15002,.82625,55.46336,-1.03463,.75513,55.43309,-.91038,.78248,55.49892,-.93259,.47807,55.62778,-.83284,.44481,55.55655,-.80713,.58405,55.51467,-.81478,.35602,55.74835,-1.13922,.52269,55.6168,-1.24549,.5902,55.60359,-1.14956,.70232,55.5422,-1.15223,.69041,55.53614,-1.21056,.7799,55.47772,-1.25099,.79352,55.48629,-1.16458,.8522,55.43902,-1.15207,.75512,55.28036,-1.33254,.74034,55.3362,-1.28133,.82612,55.26611,-1.08543,.1487,55.79468,-1.26192,.14662,55.88617,-1.30191,0.0,55.59769,-1.30375,.05483,55.51065,-1.31886,.9107,55.05124,-1.25329,.86892,55.0659,-1.2696,.83354,55.08427,-1.39771,.79148,55.18418,-1.33601,.41304,55.22377,-1.7055,.38464,55.13251,-1.78344,.28948,55.10557,-1.85739,.42284,54.88063,-1.68792,.39231,54.83958,-1.65151,.3293,54.80698,-1.72922,.12975,54.93547,-2.03097,.17732,55.39497,-.71234,.36289,55.29634,-.8263};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_8()
		{
			double[] value = {.26944,55.2472,-.78266,.26536,55.12829,-.84092,.62548,55.23899,-.91507,.6567,55.25805,-.87036,.67315,55.15795,-.96872,.79272,55.05255,-1.06364,.74396,55.11845,-.99756,.43017,55.25008,-.88313,.10254,55.05442,-1.02591,.17021,55.04762,-1.01664,.07595,55.0292,-1.12859,0.0,55.07729,-.94583,.02727,55.09233,-.89573,0.0,55.10045,-.86946,.09657,54.97966,-.6381,.1528,55.01839,-.67732,.12897,55.16136,-1.22089,.32244,55.20759,-1.1049,.38427,55.23357,-1.03397,.33659,55.1951,-1.01829,.2819,55.25322,-1.20499,.46176,54.91066,-1.35052,.552,54.9435,-1.35572,.64812,54.99205,-1.34787,.68354,55.0445,-1.31553,.18828,56.08484,-1.1781,0.0,56.0627,-1.37809,0.0,55.98584,-1.37224,.8245,55.47081,-1.03914,0.0,54.97569,-.62117,.09209,54.97259,-.65103,0.0,55.0709,-1.18287,.7712,55.36848,-1.23203,.58335,55.39076,-1.17204,.51592,55.3913,-1.15368,.78619,55.37643,-1.15946,.54935,55.27348,-.89192,.63877,55.30126,-.94468,.61259,55.34262,-.99908,.41195,55.25745,-.96425,.43719,55.34389,-1.09222,.39663,55.25421,-1.03857,.7809,55.36487,-1.09147,.78963,55.37537,-1.24011,.81283,55.27637,-1.06731,.80449,55.22487,-1.17188,.62261,55.24533,-.92607,.6709,55.16451,-.97827,.8048,55.08933,-1.3022,.78794,55.06673,-1.24297,.79244,55.06062,-1.21618,.944,54.98139,-1.18715,.89984,54.96509,-1.17011,.71057,55.13709,-1.12385,.65331,55.15214,-1.18753,.6093,55.12791,-1.16438,.10669,55.51454,-1.31071,.31085,55.48477,-1.34444,.34273,55.16722,-1.65482,.3438,54.97873,-1.42274,.22681,55.27674,-1.21991,.77472,55.21487,-1.26212,.57944,54.93348,-1.53895,.80603,55.04759,-1.36658,.30321,54.84121,-1.7308,.3154,54.81065,-1.72471,.29337,55.23898,-1.7758,.23041,55.20284,-1.86881,.04182,55.2106,-1.98269,.03718,55.20549,-1.97529,.15928,54.95933,-2.00251,.16599,54.77921,-2.11103,.1534,54.75569,-2.09345,.15441,54.73199,-2.14836,.15953,54.80649,-2.07294,.02534,55.11309,-2.14661,.03718,55.03708,-2.21671,.02534,55.07526,-2.23402,.04679,54.78873,-2.41723,.14381,54.73204,-2.18302,.13639,54.71525,-2.15134,.02328,54.79874,-2.42156,-.43732,54.87912,-1.5528,-.50799,54.89533,-1.4639,-.0639,55.86833,-.8827,-.11312,55.86522,-.91658,-.1235,55.80259,-.88345,-.1344,55.93817,-.96186,-.15037,55.73603,-.83802,-.1744,55.82043,-1.15777,-.59167,55.61209,-.91118,-.79342,55.39191,-1.00904,-.82625,55.46336,-1.03463,-.8532,55.43101,-1.15002,-.78248,55.49892,-.93259,-.75513,55.43309,-.91038,-.44481,55.55655,-.80713,-.47807,55.62778,-.83284,-.16536,55.44532,-.73183,-.35602,55.74835,-1.13922};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_9()
		{
			double[] value = {-.65161,55.541,-1.24975,-.69041,55.53614,-1.21056,-.7799,55.47772,-1.25099,-.80869,55.41564,-1.29241,-.8522,55.43902,-1.15207,-.77472,55.21487,-1.26212,-.80449,55.22487,-1.17188,-.16819,56.0167,-1.28356,-.14662,55.88617,-1.30191,-.21573,55.73383,-1.13634,-.1487,55.79468,-1.26192,-.21183,55.66577,-1.22443,-.33152,55.62521,-1.33052,-.90652,55.12598,-1.24769,-.86892,55.0659,-1.2696,-.9107,55.05124,-1.25329,-.83354,55.08427,-1.39771,-.77873,55.03553,-1.48312,-.62808,54.9486,-1.49996,-.74514,54.98921,-1.41838,-.29337,55.23898,-1.7758,-.3293,54.80698,-1.72922,-.39231,54.83958,-1.65151,-.34439,54.85411,-1.7716,-.25196,54.82131,-1.87297,-.24965,54.87971,-1.89678,-.18256,54.83689,-1.98342,-.26976,55.3553,-.77336,-.26944,55.2472,-.78266,-.09226,55.14384,-.6045,0.0,55.11226,-.58249,0.0,55.193,-.59655,-.26536,55.12829,-.84092,-.57061,55.33678,-.81528,-.62548,55.23899,-.91507,-.79272,55.05255,-1.06364,-.74396,55.11845,-.99756,-.9356,55.02419,-1.07964,-.36289,55.29634,-.8263,-.17021,55.04762,-1.01664,-.07595,55.0292,-1.12859,-.14184,55.02936,-1.11399,-.02727,55.09233,-.89573,-.12897,55.16136,-1.22089,-.18596,55.05299,-1.14622,-.22218,55.14887,-1.17489,-.2819,55.25322,-1.20499,-.26326,55.14175,-1.0835,-.42796,55.18841,-1.1907,-.46176,54.91066,-1.35052,-.5228,54.89882,-1.4058,-.68354,55.0445,-1.31553,-.79244,55.06062,-1.21618,-.14627,56.08168,-1.28158,-.19687,56.01851,-1.26189,-.18828,56.08484,-1.1781,-.20833,56.02708,-1.20577,-.39631,55.51397,-1.42486,-.38267,55.51861,-1.41983,-.8245,55.47081,-1.03914,-.10254,55.05442,-1.02591,-.7712,55.36848,-1.23203,-.66586,55.38751,-1.19894,-.43719,55.34389,-1.09222,-.49753,55.27903,-1.1557,-.51592,55.3913,-1.15368,-.68737,55.26818,-.96537,-.62261,55.24533,-.92607,-.54935,55.27348,-.89192,-.63877,55.30126,-.94468,-.41195,55.25745,-.96425,-.80234,55.37463,-1.10539,-.7809,55.36487,-1.09147,-.6709,55.16451,-.97827,-.80151,55.03812,-1.18594,-.78794,55.06673,-1.24297,-.8048,55.08933,-1.3022,-.31085,55.48477,-1.34444,-.33218,55.24935,-1.69362,-.34273,55.16722,-1.65482,-.3438,54.97873,-1.42274,-.345,55.08789,-1.48462,-.22681,55.27674,-1.21991,-.63009,55.0092,-1.59406,-.57944,54.93348,-1.53895,-.49547,55.10766,-1.198,-.3154,54.81065,-1.72471,-.30321,54.84121,-1.7308,-.224,55.21197,-1.86676,-.03718,55.20549,-1.97529,0.0,55.21358,-1.98588,-.04182,55.2106,-1.98269,-.16219,54.78782,-1.95374,-.1375,54.74304,-2.08807,-.13848,54.77431,-2.06036,-.12975,54.93547,-2.03097,0.0,54.82058,-2.4033,-.04679,54.78873,-2.41723,-.05332,54.81766,-2.41258,-.02534,55.07526,-2.23402};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_10()
		{
			double[] value = {-.03718,55.03708,-2.21671,-.02534,55.11309,-2.14661,-.16599,54.77921,-2.11103,-.1534,54.75569,-2.09345,-.02454,55.18236,-2.07654,-.05464,55.20149,-1.99308,-.01227,55.20796,-2.04189,-.15928,54.95933,-2.00251,-.47915,55.10387,-1.21152,-.34742,54.90384,-1.3769,-.37015,55.0495,-1.26592,-.08308,55.39002,-1.27745,-.10669,55.51454,-1.31071,-.46911,54.97059,-1.29868,-.7405,54.98853,-1.4078,-.944,54.98139,-1.18715,-.67315,55.15795,-.96872,-.78963,55.37537,-1.24011,-.7853,55.36144,-1.08849,-.80598,55.38273,-1.16075,0.0,55.06053,-1.16348,0.0,54.98528,-.60965,-.19984,55.05821,-1.08393,-.20783,55.06326,-1.06452,-.22245,55.07834,-1.08027,-.4722,55.63488,-.83549,-.17484,56.0963,-1.2269,-.19717,55.96613,-1.2386,-.06135,55.1865,-1.21472,-.127,55.03455,-.61483,-.22394,55.06747,-1.00507,-.17405,55.03793,-1.13379,-.11022,54.91313,-2.06436,-.14139,54.81682,-2.01841,-.61266,54.93392,-1.44735,-.86904,55.13265,-1.27243,-.24807,55.69759,-1.14209,-.07572,55.78925,-1.29674,-.82676,55.20691,-1.19831,-.68654,55.388,-1.39819,-.74034,55.3362,-1.28133,-.79352,55.48629,-1.16458,-.58405,55.51467,-.81478,-.5923,55.59556,-.83317,-.37058,55.66395,-.84718,-.38393,55.7272,-.92876,0.0,56.25012,-1.16969,-.44933,54.87199,-1.55934,.04019,54.77467,-2.01348,.05464,55.20149,-1.99308,.02454,55.18236,-2.07654,.05744,54.7713,-1.96216,0.0,54.785,-1.98312,.81693,55.15651,-1.30925,.65699,55.21427,-1.52987,.37015,55.0495,-1.26592,.67969,55.11716,-1.11605,.73604,55.2946,-1.26411,.80234,55.37463,-1.10539,.49753,55.27903,-1.1557,.80598,55.38273,-1.16075,.22245,55.07834,-1.08027,.20783,55.06326,-1.06452,.4722,55.63488,-.83549,.17484,56.0963,-1.2269,.14627,56.08168,-1.28158,.14209,56.13771,-1.23702,.5228,54.89882,-1.4058,.61289,54.93487,-1.43532,.46352,55.18016,-1.15186,.06135,55.1865,-1.21472,.127,55.03455,-.61483,.22394,55.06747,-1.00507,.04076,55.08509,-.94665,.64476,55.32001,-.82816,.21867,55.11059,-.73643,.09226,55.14384,-.6045,.16536,55.44532,-.73183,.18256,54.83689,-1.98342,.24965,54.87971,-1.89678,.25196,54.82131,-1.87297,.27037,55.64877,-1.28216,.07101,55.8798,-1.3297,.07572,55.78925,-1.29674,.80869,55.41564,-1.29241,.68602,55.47206,-1.33317,.38393,55.7272,-.92876,.4183,54.88246,-1.45424,.33547,54.96789,-1.32626,.06747,55.74589,-.82834,.4358,55.69419,-.98529,.73968,55.53693,-.9929,.77474,55.50459,-1.07443,.64842,55.5885,-1.03003,.68252,55.56641,-1.07776,.33467,55.49549,-.80178,.48075,55.54168,-1.37522,.05912,56.25938,-1.25279,.20521,55.08206,-1.93118,.122,55.04489,-.81006};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_11()
		{
			double[] value = {.22301,55.07529,-.91649,.04231,55.05455,-1.05414,.19717,55.96613,-1.2386,.67899,55.39599,-1.4042,.22019,55.07462,-.90715,.21134,55.06792,-.91561,.6176,55.25792,-1.23025,.65159,55.23497,-1.23027,.54092,55.22049,-1.19296,.74838,55.04095,-1.10117,.29981,55.40927,-1.30312,.14825,55.39405,-1.27411,.41002,55.30886,-1.33939,.43576,54.87718,-1.39343,.81764,55.09024,-1.30889,.39749,54.96906,-1.58021,.02534,55.01472,-2.31161,.04726,55.13966,-2.07303,.12316,54.83066,-2.12786,.03106,54.71014,-2.28115,.07805,54.91042,-1.89844,.10023,54.81324,-2.22443,-.33547,54.96789,-1.32626,-.06747,55.74589,-.82834,-.77474,55.50459,-1.07443,-.73968,55.53693,-.9929,-.49864,55.65587,-1.15444,-.46834,55.15133,-1.70691,-.20521,55.08206,-1.93118,-.3438,55.1958,-.94047,-.122,55.04489,-.81006,-.22301,55.07529,-.91649,-.40373,55.21723,-1.11114,-.67899,55.39599,-1.4042,-.36221,55.74296,-1.0555,-.21134,55.06792,-.91561,-.22019,55.07462,-.90715,-.14305,55.01252,-.68829,-.67909,55.39737,-1.1297,-.65159,55.23497,-1.23027,-.71057,55.13709,-1.12385,-.54092,55.22049,-1.19296,-.38427,55.23357,-1.03397,-.43576,54.87718,-1.39343,-.69408,55.09303,-1.26725,-.79651,55.08604,-1.31917,-.05773,54.78503,-1.89517,-.07815,54.74388,-2.09063,-.04726,55.13966,-2.07303,-.14445,54.83034,-2.09561,-.08272,54.73301,-2.37521,-.07849,54.70779,-2.3822,-.10388,54.68428,-2.35413,-.06724,54.73369,-2.39341,-.0372,54.97661,-2.29415,-.15441,54.73199,-2.14836,-.10023,54.87378,-2.14684,-.13066,54.6793,-2.2678,-.09522,54.7609,-2.30311,0.0,54.76767,-2.30604,-.06631,54.85702,-2.3447,-.06734,54.92258,-2.27174,-.06606,55.02862,-2.11048,-.06828,54.97469,-2.19958,-.29022,55.23441,-1.77168,-.22143,55.20841,-1.86197,0.0,54.93186,-1.91552,-.045,54.70229,-2.37982,-.07362,54.69508,-2.3767,-.06042,55.01463,-1.92405,-.16372,55.10601,-1.89889,-.1826,55.00541,-1.87357,-.04401,55.11239,-1.95276,-.1474,55.19213,-1.92215,-.2403,55.12273,-1.83105,-.32793,54.9742,-1.334,-.32758,55.07315,-1.3788,-.26633,55.013,-1.7929,-.34936,54.93827,-1.67284,-.29391,54.9033,-1.75642,-.32771,55.04306,-1.70721,-.13861,55.27771,-1.2475,-.35995,55.40908,-1.35221,-.10305,55.57197,-1.29236,-.65331,55.15214,-1.18753,-.7531,55.23651,-1.22508,-.78619,55.37643,-1.15946,-.59228,55.19215,-1.20161,-.71994,55.3353,-1.01542,-.7507,55.29667,-1.01941,-.781,55.50634,-.93781,-.18417,56.06009,-1.25569,-.43845,54.87978,-1.38294,-.33659,55.1951,-1.01829,0.0,55.04438,-1.11429,-.06096,54.96622,-.67714,-.17229,55.06052,-.76606,0.0,55.28601,-.60152,-.23478,54.97019,-1.92574,-.33565,55.00423,-1.83437};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_12()
		{
			double[] value = {-.28948,55.10557,-1.85739,0.0,55.86829,-1.33998,0.0,55.77766,-1.31474,-.07101,55.8798,-1.3297,-.70232,55.5422,-1.15223,-.43628,55.4691,-.7988,-.56565,55.41172,-.80704,-.68252,55.56641,-1.07776,-.5902,55.60359,-1.14956,-.64842,55.5885,-1.03003,-.60205,55.61419,-1.01179,-.51096,55.65185,-1.03848,-.539,55.63942,-1.01084,-.40217,55.71694,-1.06887,-.07221,55.28826,-1.24609,-.36408,54.87579,-1.65194,-.37584,54.84558,-1.64612,.05659,54.76911,-2.40874,.06724,54.73369,-2.39341,.06266,54.79966,-2.40406,.07362,54.69508,-2.3767,.09471,54.66034,-2.34377,.045,54.70229,-2.37982,.10023,54.87378,-2.14684,.13066,54.6793,-2.2678,.08272,54.73301,-2.37521,.09522,54.7609,-2.30311,.10388,54.68428,-2.35413,.06631,54.85702,-2.3447,.06734,54.92258,-2.27174,.1474,55.19213,-1.92215,.19959,54.89797,-1.85308,.26633,55.013,-1.7929,.29391,54.9033,-1.75642,.1826,55.00541,-1.87357,.36408,54.87579,-1.65194,.34936,54.93827,-1.67284,.37584,54.84558,-1.64612,.52044,54.89628,-1.41714,.43845,54.87978,-1.38294,.51819,54.97993,-1.67497,.49145,54.90726,-1.62074,.32771,55.04306,-1.70721,.13861,55.27771,-1.2475,.7531,55.23651,-1.22508,.59228,55.19215,-1.20161,.17229,55.06052,-.76606,.15993,55.05236,-.77208,.781,55.50634,-.93781,.18417,56.06009,-1.25569,.19687,56.01851,-1.26189,0.0,55.19142,-1.20928,0.0,55.03881,-.58538,.08814,55.43782,-.69857,.23478,54.97019,-1.92574,.33565,55.00423,-1.83437,.61266,54.93392,-1.44735,.43628,55.4691,-.7988,.56565,55.41172,-.80704,.60205,55.61419,-1.01179,.47929,55.66815,-1.08468,.40217,55.71694,-1.06887,.6783,55.57374,-.93708,.69908,55.54726,-.87464,.07221,55.28826,-1.24609,.04401,55.11239,-1.95276,0.0,55.02946,-1.93532,.06042,55.01463,-1.92405,0.0,55.12123,-1.96292,0.0,56.10709,-.9793,.539,55.63942,-1.01084,0.0,55.46272,-.67472,0.0,56.20505,-1.3359,0.0,56.27007,-1.25312,.10305,55.57197,-1.29236,.74514,54.98921,-1.41838,0.0,55.37359,-.63918,.14305,55.01252,-.68829,.06096,54.96622,-.67714,0.0,54.96356,-.66517,.68737,55.26818,-.96537,.35995,55.40908,-1.35221,.36587,55.06626,-1.61786,.7405,54.98853,-1.4078,.29022,55.23441,-1.77168,.06828,54.97469,-2.19958,.11531,54.63921,-2.25046,0.0,55.28838,-1.23916,0.0,56.18871,-1.0333,-.47929,55.66815,-1.08468,-.08814,55.43782,-.69857,0.0,55.69407,-1.29105,0.0,56.15008,-1.35961,-.15993,55.05236,-.77208,-.69908,55.54726,-.87464,-.52044,54.89628,-1.41714,-.36587,55.06626,-1.61786,-.19959,54.89797,-1.85308,-.11531,54.63921,-2.25046,-.06266,54.79966,-2.40406};
			return value;
		}
		private double[] getaxis_Coord_9_29_point_13()
		{
			double[] value = {-.15835,54.74243,-2.17566,-.14081,54.79158,-2.16756,-.09471,54.66034,-2.34377,-.05659,54.76911,-2.40874,-.05744,54.7713,-1.96216,0.0,55.11189,-2.24987,0.0,55.14972,-2.16246,-.306,55.14748,-1.74168,-.6783,55.57374,-.93708,.07849,54.70779,-2.3822,.0372,54.97661,-2.29415,.22143,55.20841,-1.86197,.16372,55.10601,-1.89889,.2403,55.12273,-1.83105,.306,55.14748,-1.74168,.51096,55.65185,-1.03848};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc2disc_Geo_8_34_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,8,7,9,-1,10,11,12,-1,13,11,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,16,25,-1,26,16,20,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,33,-1,41,42,43,-1,41,43,40,-1,44,45,46,-1,47,44,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,59,61,62,-1,63,64,65,-1,4,3,66,-1,67,65,68,-1,52,69,70,-1,71,72,73,-1,70,74,75,-1,13,14,76,-1,76,77,78,-1,9,7,79,-1,23,50,8,-1,80,68,3,-1,81,82,15,-1,81,83,82,-1,83,84,85,-1,6,79,7,-1,86,87,37,-1,37,4,86,-1,88,15,89,-1,63,67,35,-1,34,90,91,-1,92,75,93,-1,71,94,52,-1,71,73,94,-1,95,93,64,-1,96,93,78,-1,97,86,4,-1,4,66,98,-1,3,68,99,-1,54,60,62,-1,69,56,100,-1,94,53,52,-1,101,102,55,-1,79,61,59,-1,0,57,82,-1,1,0,82,-1,103,44,47,-1,44,104,33,-1,44,105,104,-1,45,40,43,-1,106,107,36,-1,108,33,35,-1,38,37,87,-1,109,31,30,-1,110,29,31,-1,111,27,112,-1,12,11,113,-1,81,15,17,-1,23,22,28,-1,88,18,16,-1,114,85,115,-1,91,116,117,-1,91,90,118,-1,89,15,82,-1,98,119,97,-1,119,101,97,-1,101,120,97,-1,82,57,89,-1,116,91,118,-1,19,50,23,-1,115,86,114,-1,18,20,16,-1,121,81,17,-1,111,112,122,-1,27,123,112,-1,11,124,113,-1,17,24,121,-1,24,25,125,-1,87,126,38,-1,108,127,33,-1,106,36,128,-1,39,129,41,-1,45,33,40,-1,44,33,45,-1,130,41,129,-1,41,130,42,-1,103,105,44,-1,82,83,1,-1,8,131,6,-1,101,55,2,-1,132,61,131,-1,94,73,133,-1,94,133,53,-1,62,134,54,-1,68,65,99,-1,98,97,4,-1,117,95,91,-1,52,135,71,-1,92,93,96,-1,91,63,34,-1,63,35,34,-1,67,108,35,-1,88,89,136,-1,4,37,5,-1,137,84,83,-1,85,114,83,-1,86,115,87,-1,81,137,83,-1,3,5,80,-1,21,23,8,-1,79,12,9,-1,76,78,138,-1,139,13,76,-1,70,75,92,-1,100,140,69,-1,117,116,78,-1,70,135,52,-1,67,63,65,-1,59,62,60,-1,54,69,52,-1,136,49,51,-1,141,89,57,-1,49,132,50,-1,142,106,128,-1,38,128,36,-1,127,39,33,-1,39,41,40,-1,36,5,37,-1,33,104,34,-1,30,32,113,-1,123,143,112,-1,26,112,143,-1,22,32,31,-1,27,111,28,-1,26,20,122,-1,112,26,122,-1,24,17,16,-1,21,32,22,-1,19,28,20,-1,15,88,16,-1,32,21,9,-1,13,124,11,-1,12,79,10,-1,9,21,8,-1,19,23,28,-1,99,66,3,-1,84,144,145,-1,144,84,137,-1,123,25,143,-1,123,125,25,-1,123,110,125,-1,29,22,31,-1,29,28,22,-1,9,113,32,-1,9,12,113,-1,110,109,146,-1,110,31,109,-1,124,30,113,-1,147,30,124,-1,148,149,150,-1,151,149,148,-1,152,153,154,-1,155,153,152,-1,85,156,115,-1,157,156,85,-1,127,80,107,-1,127,108,80,-1,130,107,106,-1,130,129,107,-1,38,158,128,-1,158,38,126,-1,159,160,161,-1,159,162,160,-1,163,164,165,-1,164,163,152,-1,166,156,157,-1,166,167,156,-1,114,1,83,-1,120,1,114,-1,6,61,79,-1,61,6,131,-1,54,133,60,-1,54,53,133,-1,55,100,56,-1,100,55,102,-1,93,117,78,-1,95,117,93,-1,71,70,92,-1,71,135,70,-1,75,99,65,-1,74,99,75,-1,51,19,18,-1,19,51,50,-1,51,88,136,-1,18,88,51,-1,138,116,118,-1,138,78,116,-1,140,70,69,-1,140,74,70,-1,66,74,140,-1,99,74,66,-1,58,168,10,-1,73,168,58,-1,49,61,132,-1,62,61,49,-1,132,8,50,-1,132,131,8,-1,159,152,163,-1,152,159,155,-1,158,161,160,-1,161,158,167,-1,47,139,103,-1,139,47,165,-1,48,46,162,-1,48,44,46,-1,105,118,90,-1,118,103,138,-1,105,103,118,-1,107,39,127,-1,39,107,129,-1,104,90,34,-1,104,105,90,-1,145,166,157,-1,145,151,166,-1,164,154,147,-1,152,154,164,-1,150,153,148,-1,150,146,153,-1,149,121,24,-1,144,121,149,-1,123,29,110,-1,123,27,29,-1,111,20,28,-1,111,122,20,-1,145,85,84,-1,85,145,157,-1};
			return value;
		}
		private int[] getc2disc_Geo_8_34_coordIndex_2()
		{
			int[] value = {14,77,76,-1,168,77,14,-1,137,121,144,-1,137,81,121,-1,16,143,25,-1,16,26,143,-1,125,146,150,-1,125,110,146,-1,109,147,154,-1,109,30,147,-1,151,144,149,-1,145,144,151,-1,155,148,153,-1,169,148,155,-1,5,107,80,-1,36,107,5,-1,106,42,130,-1,142,42,106,-1,142,46,42,-1,160,128,158,-1,160,142,128,-1,163,162,159,-1,163,48,162,-1,165,13,139,-1,13,165,164,-1,167,169,161,-1,169,167,166,-1,49,89,141,-1,49,136,89,-1,141,62,49,-1,62,141,134,-1,91,64,63,-1,91,95,64,-1,170,101,119,-1,170,102,101,-1,93,65,64,-1,65,93,75,-1,168,72,77,-1,72,168,73,-1,100,170,140,-1,102,170,100,-1,10,14,11,-1,10,168,14,-1,67,80,108,-1,67,68,80,-1,92,72,71,-1,92,96,72,-1,77,96,78,-1,77,72,96,-1,140,98,66,-1,119,140,170,-1,119,98,140,-1,97,114,86,-1,114,97,120,-1,54,56,69,-1,54,134,56,-1,134,57,56,-1,57,134,141,-1,133,58,60,-1,133,73,58,-1,59,10,79,-1,59,58,10,-1,0,55,57,-1,0,2,55,-1,161,155,159,-1,155,161,169,-1,126,167,158,-1,167,126,156,-1,165,48,163,-1,165,47,48,-1,162,142,160,-1,162,46,142,-1,139,138,103,-1,139,76,138,-1,45,42,46,-1,45,43,42,-1,126,115,156,-1,87,115,126,-1,169,151,148,-1,166,151,169,-1,13,147,124,-1,164,147,13,-1,146,154,153,-1,146,109,154,-1,24,150,149,-1,24,125,150,-1,120,2,1,-1,101,2,120,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc2disc_Coord_9_34_point_1()
		{
			double[] value = {-.10274,54.9724,-.65812,-.09943,54.95951,-.65651,-.08404,54.96524,-.66089,.20682,55.03216,-.75613,.17272,54.98617,-.69333,.22825,55.0025,-.75881,-.19984,55.05656,-1.08393,-.20947,55.05343,-1.08372,-.23791,55.07225,-1.05795,-.21909,55.05031,-1.08352,-.07595,55.02756,-1.12859,-.07931,55.01614,-1.13051,-.14135,55.01943,-1.1133,0.0,55.00358,-1.11833,0.0,55.01726,-1.12587,-.2418,54.99968,-.75712,-.28353,55.0125,-.82505,-.24082,54.97961,-.76267,-.29346,55.05125,-.88875,-.28046,55.06802,-.95595,-.29488,55.0311,-.89013,-.25073,55.06406,-1.0496,-.25558,55.05728,-1.00669,-.27158,55.0684,-1.00386,-.21118,54.95672,-.78208,-.25294,54.98017,-.8468,-.29157,55.00596,-.8746,-.26779,55.00679,-.92018,-.2868,55.05053,-.95059,-.2494,55.01486,-.93726,-.12897,55.01328,-1.04961,-.18128,55.01241,-1.00138,-.22432,55.05256,-1.05445,.28662,55.05027,-.95052,.26569,55.06766,-1.01945,.2827,55.07234,-.96703,.24208,54.98058,-.76184,.17402,54.95196,-.70569,.17324,54.92991,-.71985,.29505,55.01987,-.89243,.28758,55.0202,-.91505,.2883,55.00073,-.89681,.24521,54.99316,-.90637,.26779,55.00679,-.92018,.18128,55.01241,-1.00138,.2494,55.01486,-.93726,.19918,54.98983,-.91432,.12897,55.01328,-1.04961,.1341,54.99381,-1.00315,-.21134,55.06628,-.91561,-.26306,55.07911,-.98645,-.25678,55.0673,-.90237,0.0,55.0988,-.86946,-.02727,55.09068,-.89573,-.07641,55.08415,-.8464,-.06096,54.96458,-.67714,-.09916,55.0055,-.72567,-.14305,55.01088,-.68829,-.04231,55.05291,-1.05414,-.10254,55.05278,-1.02591,-.11043,55.06945,-.93075,-.17021,55.04598,-1.01664,-.16917,55.05535,-.9197,.27211,55.07911,-.98026,.22394,55.06583,-1.00507,.21134,55.06628,-.91561,.14305,55.01088,-.68829,.26919,55.06497,-.89718,.2579,55.0592,-.86072,0.0,55.09125,-.80454,.07641,55.08415,-.8464,.04076,55.08345,-.94665,.04231,55.05291,-1.05414,0.0,55.05601,-1.05028,.122,55.04324,-.81006,.16917,55.05535,-.9197,.07767,55.01611,-1.13202,.07595,55.02756,-1.12859,.14184,55.02771,-1.11399,-.14184,55.02771,-1.11399,.27633,55.04356,-.84141,-.19723,54.9597,-.72162,-.17253,54.98646,-.69317,-.10713,54.94738,-.66399,-.06278,54.91393,-.67426,-.00113,54.91041,-.66839,.1053,54.95069,-.66295,.11997,54.92354,-.68772,-.27798,55.02899,-.82298,-.2108,55.03431,-.75085,.238,55.06075,-1.06829,.23535,55.07204,-1.07142,.11043,55.06945,-.93075,.17021,55.04598,-1.01664,0.0,55.07565,-.94583,.20783,55.06162,-1.06452,.10254,55.05278,-1.02591,.09862,54.96111,-.65644,.10253,54.97309,-.65851,.15993,55.05072,-.77208};
			return value;
		}
		private double[] getc2disc_Coord_9_34_point_2()
		{
			double[] value = {0.0,55.01897,-.71215,-.00002,54.95533,-.64593,0.0,54.96192,-.66517,.1503,55.02129,-1.09507,.24935,55.05701,-1.01661,.22833,55.05361,-1.05887,.25294,54.98017,-.8468,.28133,55.01017,-.82662,.28837,55.05071,-.89045,-.1341,54.99381,-1.00315,-.19918,54.98983,-.91432,-.28758,55.0202,-.91505,-.28576,55.00306,-.89577,-.14992,55.02089,-1.09456,-.00045,54.92765,-.65239,.06057,54.91339,-.67329,.21164,55.05803,-1.09347,.19984,55.05656,-1.08393,.22519,55.05565,-1.08735,.08384,54.96574,-.66117,-.00017,54.94391,-.64167,-.20494,54.94676,-.74365,-.29234,55.01778,-.89288,-.24521,54.99316,-.90637,-.07938,55.01261,-1.1168,-.20161,54.97628,-.85812,.11797,54.90492,-.70395,.2974,55.02926,-.89048,.21118,54.95672,-.78208,.29157,55.00596,-.8746,.27288,54.9892,-.87446,-.20783,55.06162,-1.06452,-.22394,55.06583,-1.00507,-.04076,55.08345,-.94665,-.122,55.04324,-.81006,.02727,55.09068,-.89573,-.2423,55.05966,-.85901,-.11184,54.92341,-.68625,.14565,55.02205,-1.11004,.07808,55.0146,-1.12105,.09916,55.0055,-.72567,-.15993,55.05072,-.77208,.20161,54.97628,-.85812,-.27288,54.9892,-.87446,-.11694,54.90629,-.70475,-.05261,54.89561,-.68475,-.13401,54.96301,-.92299,-.0721,55.00893,-1.05916,-.05838,54.93798,-.85018,-.12128,54.92684,-.77523,-.13244,54.95263,-.8587,-.05231,54.91686,-.76796,0.0,54.97773,-.99405,-.06407,54.95763,-.92288,-.07167,54.98603,-1.00034,0.0,54.95281,-.92526,.05261,54.89561,-.68475,0.0,54.89285,-.67654,.12128,54.92684,-.77523,.06407,54.95763,-.92288,.13244,54.95263,-.8587,.05838,54.93798,-.85018,.13401,54.96301,-.92299,.07167,54.98603,-1.00034,0.0,54.99827,-1.06566,.0721,55.00893,-1.05916,0.0,54.9167,-.76364,.05231,54.91686,-.76796,0.0,55.03534,-1.12115,0.0,54.93377,-.84515,.06096,54.96458,-.67714};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc3_Geo_8_39_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,26,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,47,62,63,-1,64,65,66,-1,67,68,60,-1,49,69,62,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,67,56,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,95,-1,100,101,102,-1,103,104,105,-1,106,103,107,-1,108,109,110,-1,111,112,113,-1,112,114,115,-1,116,117,118,-1,119,120,108,-1,121,119,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,142,144,129,-1,145,146,147,-1,148,149,150,-1,151,152,149,-1,51,153,154,-1,36,155,156,-1,157,158,159,-1,160,161,162,-1,2,1,163,-1,164,165,166,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,176,177,178,-1,179,180,181,-1,182,183,162,-1,184,185,186,-1,187,188,189,-1,190,150,149,-1,191,179,192,-1,193,194,195,-1,196,197,198,-1,199,200,6,-1,201,202,14,-1,203,166,174,-1,204,205,206,-1,207,208,209,-1,210,198,197,-1,211,212,213,-1,214,215,25,-1,216,217,55,-1,53,218,214,-1,11,217,216,-1,219,220,221,-1,222,223,44,-1,224,225,226,-1,227,228,224,-1,229,230,231,-1,229,232,233,-1,234,235,46,-1,66,226,225,-1,61,236,237,-1,238,239,240,-1,241,147,242,-1,195,243,244,-1,245,246,247,-1,241,248,249,-1,250,241,251,-1,252,253,192,-1,254,255,256,-1,257,133,132,-1,258,259,260,-1,185,261,262,-1,263,264,265,-1,106,266,103,-1,58,267,268,-1,269,268,270,-1,271,267,272,-1,269,270,273,-1,82,274,275,-1,118,276,128,-1,277,278,43,-1,279,34,280,-1,281,282,283,-1,165,164,284,-1,168,285,286,-1,287,288,283,-1,289,290,291,-1,292,293,294,-1,295,296,297,-1,298,299,167,-1,300,301,80,-1,302,298,303,-1,303,304,305,-1,306,307,308,-1,100,102,309,-1,310,311,312,-1,313,314,315,-1,316,107,317,-1,305,318,319,-1,319,320,302,-1,321,154,322,-1,323,324,325,-1,326,327,10,-1,328,329,330,-1,331,332,329,-1,333,334,335,-1,336,337,338,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,349,355,-1,356,357,358,-1,359,360,361,-1,362,363,364,-1,338,365,366,-1,69,367,368,-1,369,370,371,-1,372,373,374,-1,375,376,359,-1,377,378,379,-1,380,381,371,-1,359,376,69,-1,382,383,384,-1,385,386,387,-1,388,389,382,-1,390,371,381,-1,391,392,393,-1,394,395,396,-1,397,398,399,-1,400,401,402,-1,403,404,405,-1,406,407,408,-1,409,410,411,-1,412,413,414,-1,415,416,417,-1,418,417,419,-1,420,421,422,-1,423,424,425,-1,422,426,427,-1,428,429,430,-1,431,432,433,-1,434,426,422,-1,426,434,435,-1,436,124,123,-1,437,438,439,-1,440,441,442,-1,443,444,445,-1,446,447,448,-1,449,450,451,-1,452,453,454,-1,453,455,442,-1,456,457,458,-1,459,460,461,-1,461,447,462,-1,364,363,463,-1,464,340,465,-1,466,467,468,-1,469,470,471,-1,163,1,472,-1,473,474,475,-1,476,477,478,-1,479,480,481,-1,482,474,483,-1,484,485,486,-1,487,488,489,-1,469,490,491,-1,492,493,494,-1,495,496,497,-1,461,460,498,-1,499,489,500,-1,501,502,503,-1,368,367,504,-1,202,505,506,-1,368,507,508,-1,473,509,483,-1,510,511,512,-1,513,512,514,-1,515,516,517,-1,518,519,520,-1,436,521,518,-1,522,523,524,-1,522,525,523,-1,526,527,336,-1,352,528,529,-1,338,366,530,-1,531,532,533,-1,534,357,531,-1,535,536,537,-1,537,538,535,-1,539,540,541,-1,542,507,543,-1,544,545,543,-1,377,387,546,-1,536,535,547,-1,548,549,550,-1,551,552,374,-1,553,554,555,-1,489,499,471,-1,556,557,558,-1,559,558,560,-1,499,561,562,-1,560,563,564,-1,443,565,566,-1,567,568,569,-1,493,570,571,-1,572,573,574,-1,417,575,419,-1,576,577,369,-1,578,579,577,-1,580,581,582,-1,583,584,585,-1,586,587,391,-1,588,510,464,-1,589,339,590,-1,591,592,593,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_2()
		{
			int[] value = {594,595,596,-1,597,475,598,-1,599,600,601,-1,591,602,603,-1,604,605,606,-1,607,495,608,-1,609,610,611,-1,612,613,614,-1,612,573,613,-1,615,616,617,-1,393,618,619,-1,620,617,621,-1,622,623,620,-1,624,625,626,-1,627,412,414,-1,628,629,630,-1,631,632,633,-1,634,418,635,-1,636,637,622,-1,638,639,640,-1,481,498,460,-1,641,474,642,-1,643,388,644,-1,645,364,646,-1,636,647,432,-1,435,434,648,-1,409,649,650,-1,413,410,651,-1,411,652,653,-1,654,404,403,-1,655,630,629,-1,656,657,398,-1,402,658,659,-1,660,661,627,-1,662,622,429,-1,615,617,620,-1,663,657,400,-1,664,663,394,-1,665,666,667,-1,613,573,668,-1,669,670,610,-1,615,496,476,-1,604,671,672,-1,603,673,674,-1,675,676,677,-1,678,599,679,-1,674,595,680,-1,679,677,681,-1,682,683,606,-1,684,685,686,-1,687,510,513,-1,655,585,688,-1,689,348,690,-1,530,582,691,-1,690,579,578,-1,577,576,584,-1,390,692,576,-1,577,579,693,-1,694,695,565,-1,448,696,697,-1,454,698,462,-1,699,562,700,-1,560,558,456,-1,701,702,501,-1,487,703,488,-1,502,501,702,-1,557,704,558,-1,705,706,707,-1,708,555,554,-1,379,378,709,-1,710,551,374,-1,550,555,711,-1,712,713,537,-1,534,714,715,-1,716,717,538,-1,693,712,536,-1,716,538,718,-1,719,720,356,-1,721,722,544,-1,723,724,720,-1,365,337,532,-1,202,725,726,-1,327,326,529,-1,352,727,527,-1,728,729,341,-1,687,513,730,-1,731,732,733,-1,514,512,734,-1,735,734,512,-1,473,736,509,-1,737,542,738,-1,504,367,739,-1,740,498,741,-1,642,460,459,-1,742,743,569,-1,744,485,458,-1,468,467,480,-1,593,475,597,-1,745,746,732,-1,598,474,747,-1,566,748,749,-1,466,744,750,-1,751,703,752,-1,471,490,469,-1,744,753,486,-1,744,466,753,-1,687,341,340,-1,598,754,755,-1,515,756,463,-1,757,643,758,-1,759,635,418,-1,442,759,440,-1,696,448,447,-1,760,441,440,-1,451,454,462,-1,761,762,696,-1,648,445,444,-1,446,445,449,-1,763,441,764,-1,755,647,765,-1,572,492,470,-1,766,433,767,-1,433,432,647,-1,768,660,624,-1,769,622,637,-1,425,770,417,-1,634,635,771,-1,772,619,665,-1,411,773,406,-1,774,650,775,-1,407,776,408,-1,777,630,633,-1,404,778,405,-1,396,779,780,-1,392,394,393,-1,586,391,667,-1,546,781,384,-1,782,645,640,-1,373,370,693,-1,546,384,378,-1,383,382,389,-1,386,644,781,-1,370,373,372,-1,693,783,710,-1,784,785,786,-1,580,582,350,-1,691,787,338,-1,584,583,346,-1,788,347,346,-1,789,667,666,-1,465,340,790,-1,791,738,792,-1,793,794,795,-1,335,796,328,-1,506,797,329,-1,798,326,726,-1,726,799,798,-1,800,798,801,-1,802,803,804,-1,793,805,323,-1,806,794,323,-1,807,159,808,-1,809,175,209,-1,810,78,811,-1,812,74,321,-1,813,322,154,-1,319,814,815,-1,107,103,317,-1,816,110,817,-1,818,119,121,-1,819,820,99,-1,821,98,101,-1,822,823,824,-1,94,93,825,-1,826,312,827,-1,828,829,830,-1,831,89,91,-1,832,308,309,-1,115,114,305,-1,303,298,833,-1,301,834,80,-1,835,836,837,-1,838,839,263,-1,293,840,841,-1,169,188,833,-1,842,843,844,-1,845,846,286,-1,843,842,847,-1,848,299,298,-1,849,850,845,-1,851,291,852,-1,853,854,855,-1,204,856,857,-1,858,273,827,-1,859,272,860,-1,220,861,221,-1,272,862,860,-1,270,268,267,-1,863,268,864,-1,865,866,267,-1,266,106,867,-1,868,869,870,-1,257,871,133,-1,872,873,135,-1,151,142,141,-1,162,161,264,-1,256,147,250,-1,874,195,194,-1,241,875,248,-1,876,877,878,-1,240,239,879,-1,880,64,881,-1,882,59,883,-1,884,236,61,-1,225,224,862,-1,885,886,222,-1,227,887,888,-1,862,866,865,-1,889,225,865,-1,890,228,227,-1,891,24,219,-1,892,893,894,-1,202,10,9,-1,895,217,11,-1,54,896,55,-1,33,35,39,-1,204,857,897,-1,170,898,899,-1,212,211,900,-1,901,165,902,-1,903,206,205,-1,208,207,206,-1,174,901,209,-1,368,230,904,-1,19,905,231,-1,63,62,906,-1,906,907,908,-1,195,909,243,-1,910,193,875,-1,152,911,808,-1,912,150,809,-1,260,259,868,-1,839,182,264,-1,913,914,145,-1,158,898,159,-1,164,166,281,-1,284,164,281,-1,915,900,746,-1,916,203,173,-1,917,914,807,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_3()
		{
			int[] value = {918,246,919,-1,184,920,247,-1,183,252,160,-1,176,157,807,-1,33,897,857,-1,118,902,165,-1,197,921,922,-1,923,811,924,-1,316,925,926,-1,926,925,129,-1,136,135,911,-1,151,149,148,-1,131,130,927,-1,903,928,929,-1,809,209,930,-1,138,136,151,-1,917,808,911,-1,931,134,140,-1,140,134,137,-1,133,137,134,-1,932,130,148,-1,320,116,118,-1,161,186,264,-1,276,117,933,-1,116,815,117,-1,832,115,934,-1,305,302,303,-1,817,935,936,-1,104,103,937,-1,105,938,316,-1,836,300,837,-1,939,95,940,-1,819,821,941,-1,96,817,97,-1,313,312,311,-1,92,942,93,-1,943,944,83,-1,80,85,81,-1,835,82,275,-1,71,70,945,-1,813,946,888,-1,57,59,882,-1,64,71,945,-1,76,72,238,-1,70,810,74,-1,59,57,56,-1,882,889,865,-1,947,948,949,-1,950,861,951,-1,219,952,220,-1,32,953,273,-1,953,31,274,-1,37,835,954,-1,38,280,36,-1,219,26,40,-1,905,19,955,-1,956,955,19,-1,957,958,959,-1,16,201,960,-1,961,12,14,-1,961,11,216,-1,15,8,7,-1,957,3,962,-1,963,3,964,-1,472,1,564,-1,1,0,564,-1,963,4,3,-1,957,964,3,-1,15,20,8,-1,892,961,216,-1,961,14,9,-1,9,11,961,-1,16,965,201,-1,960,13,21,-1,959,964,957,-1,19,966,956,-1,952,219,40,-1,280,155,36,-1,37,954,38,-1,28,277,967,-1,32,273,270,-1,26,25,215,-1,234,45,968,-1,224,969,970,-1,971,968,45,-1,25,972,54,-1,947,53,948,-1,56,60,59,-1,238,77,76,-1,64,945,65,-1,865,57,882,-1,322,813,888,-1,70,76,810,-1,76,78,810,-1,865,58,57,-1,835,837,82,-1,85,84,81,-1,86,828,87,-1,83,88,943,-1,942,973,93,-1,311,314,313,-1,817,936,97,-1,941,974,819,-1,940,822,939,-1,831,975,89,-1,105,316,317,-1,104,937,936,-1,817,109,935,-1,934,308,832,-1,105,104,976,-1,815,933,117,-1,109,817,110,-1,276,933,977,-1,148,912,932,-1,133,871,137,-1,137,138,140,-1,931,140,818,-1,911,873,917,-1,151,141,138,-1,208,903,929,-1,130,932,978,-1,144,151,148,-1,136,911,152,-1,131,926,129,-1,107,316,926,-1,923,924,979,-1,197,196,921,-1,165,980,118,-1,155,33,857,-1,176,807,913,-1,160,162,183,-1,247,981,184,-1,257,918,919,-1,914,913,807,-1,869,246,918,-1,901,174,165,-1,746,745,915,-1,284,281,288,-1,898,172,159,-1,145,177,913,-1,839,264,263,-1,868,982,260,-1,152,808,190,-1,193,195,244,-1,193,244,875,-1,907,904,908,-1,203,983,166,-1,206,903,208,-1,205,210,903,-1,900,984,212,-1,899,985,170,-1,897,986,204,-1,39,897,33,-1,54,972,896,-1,327,895,11,-1,202,9,14,-1,22,892,894,-1,891,219,987,-1,234,968,235,-1,233,988,989,-1,45,234,46,-1,890,990,228,-1,225,862,865,-1,227,888,890,-1,885,222,990,-1,224,970,862,-1,61,991,884,-1,883,237,882,-1,881,992,880,-1,878,884,876,-1,241,242,875,-1,147,177,145,-1,195,874,909,-1,147,241,250,-1,151,144,142,-1,873,911,135,-1,257,993,871,-1,869,918,870,-1,994,266,867,-1,865,267,58,-1,863,864,79,-1,267,271,270,-1,272,866,862,-1,860,995,859,-1,858,269,273,-1,856,156,857,-1,27,34,279,-1,853,855,996,-1,849,845,997,-1,848,298,998,-1,847,999,843,-1,845,286,1000,-1,850,1001,1002,-1,844,287,842,-1,1003,290,289,-1,169,833,167,-1,841,294,293,-1,838,263,296,-1,835,37,836,-1,85,834,1004,-1,115,305,1005,-1,309,1006,832,-1,100,309,307,-1,91,1007,831,-1,830,87,828,-1,1008,826,827,-1,822,824,939,-1,1009,821,101,-1,97,315,940,-1,121,931,818,-1,816,817,820,-1,815,116,319,-1,154,153,813,-1,74,923,321,-1,78,927,811,-1,175,174,209,-1,808,917,807,-1,323,1010,806,-1,323,794,793,-1,802,804,331,-1,800,326,798,-1,726,725,799,-1,328,506,329,-1,795,1011,793,-1,792,1012,791,-1,792,738,542,-1,340,339,790,-1,790,789,666,-1,581,1013,344,-1,584,346,345,-1,1014,336,1015,-1,724,356,720,-1,713,358,537,-1,356,724,366,-1,527,727,336,-1,786,1016,784,-1,370,372,371,-1,383,389,553,-1,377,546,378,-1,710,373,693,-1,717,782,640,-1,370,369,693,-1,391,772,667,-1,392,395,394,-1,398,657,399,-1,780,397,396,-1,404,1017,778,-1,633,632,777,-1,407,425,776,-1,774,651,650,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_4()
		{
			int[] value = {411,406,1018,-1,402,1019,658,-1,634,771,415,-1,425,417,416,-1,620,621,622,-1,769,429,622,-1,768,428,660,-1,423,416,415,-1,647,767,433,-1,427,776,420,-1,766,767,1020,-1,764,459,763,-1,446,449,451,-1,648,449,445,-1,696,741,761,-1,462,447,451,-1,1021,641,642,-1,1022,764,441,-1,763,461,698,-1,461,462,698,-1,447,740,696,-1,442,455,759,-1,759,455,635,-1,757,1023,643,-1,463,1024,515,-1,598,755,1025,-1,687,1026,341,-1,471,562,490,-1,494,751,752,-1,466,750,761,-1,483,509,1027,-1,732,1028,745,-1,597,602,593,-1,593,473,475,-1,480,479,468,-1,458,750,744,-1,569,1029,742,-1,741,696,740,-1,1030,501,503,-1,1031,701,501,-1,540,504,739,-1,739,376,375,-1,504,507,368,-1,641,747,474,-1,512,511,735,-1,514,734,517,-1,754,598,747,-1,733,520,731,-1,730,1026,687,-1,341,1026,728,-1,527,528,352,-1,529,895,327,-1,726,10,202,-1,365,338,337,-1,718,1032,716,-1,693,536,783,-1,693,579,712,-1,717,1033,538,-1,715,1032,534,-1,712,537,536,-1,547,535,377,-1,711,548,550,-1,710,374,373,-1,709,1034,379,-1,707,711,705,-1,704,1035,558,-1,458,485,456,-1,487,752,703,-1,560,456,563,-1,572,470,469,-1,562,561,700,-1,454,453,698,-1,696,762,697,-1,694,1036,695,-1,369,577,693,-1,390,576,1037,-1,584,1038,577,-1,690,712,579,-1,689,690,578,-1,655,583,585,-1,687,464,510,-1,1039,590,342,-1,1040,684,686,-1,1041,679,681,-1,1042,617,1043,-1,617,616,1043,-1,674,596,595,-1,679,1044,678,-1,674,680,603,-1,476,478,615,-1,669,610,609,-1,573,1045,668,-1,772,665,667,-1,393,663,618,-1,400,1046,663,-1,662,429,428,-1,660,627,624,-1,625,627,414,-1,659,400,402,-1,656,1047,657,-1,655,629,1048,-1,411,653,773,-1,413,651,1049,-1,406,631,407,-1,648,444,435,-1,634,417,418,-1,432,1050,636,-1,646,640,645,-1,643,760,388,-1,474,482,642,-1,481,480,498,-1,640,646,638,-1,622,621,636,-1,425,631,770,-1,408,776,649,-1,406,1051,631,-1,633,770,631,-1,628,630,777,-1,659,658,412,-1,624,627,625,-1,622,662,623,-1,394,663,393,-1,619,772,393,-1,615,478,616,-1,612,574,573,-1,612,614,497,-1,609,611,614,-1,591,603,680,-1,678,477,1052,-1,679,675,677,-1,598,1025,597,-1,594,596,1053,-1,593,602,591,-1,1054,1040,347,-1,589,590,1039,-1,1040,686,1055,-1,586,788,587,-1,581,691,582,-1,578,577,1038,-1,1037,576,369,-1,417,688,575,-1,574,570,572,-1,571,1056,493,-1,567,569,743,-1,742,749,1057,-1,443,694,565,-1,447,446,451,-1,1058,560,564,-1,562,471,499,-1,499,1059,1060,-1,1030,1031,501,-1,1035,456,558,-1,555,550,553,-1,551,1061,552,-1,547,783,536,-1,719,723,720,-1,543,539,544,-1,542,737,507,-1,539,504,540,-1,537,718,538,-1,531,533,534,-1,1062,1063,721,-1,531,365,532,-1,530,691,338,-1,800,529,326,-1,352,529,800,-1,336,1014,526,-1,524,1064,522,-1,518,520,733,-1,517,1065,515,-1,513,510,512,-1,474,473,483,-1,725,202,506,-1,1066,200,199,-1,499,500,1059,-1,498,740,461,-1,469,491,572,-1,470,752,487,-1,1067,1068,1069,-1,488,500,489,-1,486,1070,484,-1,481,1071,479,-1,683,676,671,-1,476,1052,477,-1,474,598,475,-1,472,1072,163,-1,1057,703,751,-1,466,468,753,-1,485,744,486,-1,464,687,340,-1,463,646,364,-1,1022,441,760,-1,461,740,447,-1,459,461,763,-1,459,1021,642,-1,442,698,453,-1,454,1073,452,-1,446,448,1036,-1,445,694,443,-1,764,1021,459,-1,439,1020,437,-1,525,522,1074,-1,426,435,1075,-1,566,1076,443,-1,434,422,1077,-1,433,1078,431,-1,755,767,647,-1,428,430,660,-1,1046,430,1079,-1,425,416,423,-1,631,425,407,-1,422,427,420,-1,417,634,415,-1,1051,405,778,-1,411,1018,409,-1,406,408,1018,-1,652,411,1019,-1,396,664,394,-1,391,393,772,-1,390,1037,371,-1,388,1080,389,-1,382,384,781,-1,69,49,359,-1,372,380,371,-1,547,377,379,-1,375,359,361,-1,550,383,553,-1,374,552,372,-1,369,371,1037,-1,362,364,360,-1,49,1081,359,-1,719,356,358,-1,356,531,357,-1,354,1082,349,-1,790,666,465,-1,729,590,341,-1,345,347,1083,-1,344,1013,342,-1,341,590,339,-1,438,465,666,-1,338,1015,336,-1,332,330,329,-1,725,796,799,-1,326,10,726,-1,803,802,1066,-1,325,1010,323,-1,322,812,321,-1,319,116,320,-1,319,302,305,-1,937,315,936,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_5()
		{
			int[] value = {820,817,96,-1,315,1084,940,-1,315,937,313,-1,312,826,310,-1,102,831,1007,-1,307,309,308,-1,304,1005,305,-1,80,834,85,-1,80,837,300,-1,167,833,298,-1,297,187,295,-1,294,295,292,-1,1085,189,1086,-1,283,842,287,-1,1087,1088,846,-1,845,850,1002,-1,165,284,980,-1,283,288,281,-1,31,996,1089,-1,279,280,1090,-1,277,43,42,-1,996,1091,1092,-1,156,856,1093,-1,118,117,276,-1,82,1094,274,-1,267,866,272,-1,269,864,268,-1,58,268,863,-1,266,858,103,-1,265,1095,263,-1,185,262,265,-1,260,1096,258,-1,1097,869,868,-1,132,918,257,-1,138,137,136,-1,256,250,254,-1,192,160,252,-1,1098,1099,192,-1,180,245,247,-1,160,192,179,-1,238,1100,239,-1,883,61,237,-1,1100,1101,880,-1,66,225,889,-1,945,73,65,-1,229,233,1102,-1,229,231,905,-1,224,226,227,-1,222,44,1103,-1,989,1104,1105,-1,221,971,219,-1,53,214,54,-1,216,55,896,-1,214,25,54,-1,1106,1107,1108,-1,1109,1110,125,-1,211,213,1109,-1,197,1111,210,-1,209,901,207,-1,206,856,204,-1,206,207,856,-1,174,173,203,-1,508,230,368,-1,201,505,202,-1,904,907,368,-1,218,196,198,-1,1099,191,192,-1,149,152,190,-1,264,182,162,-1,181,920,161,-1,910,1112,245,-1,179,191,180,-1,178,1113,176,-1,898,170,172,-1,290,1001,291,-1,167,285,168,-1,165,174,166,-1,163,1114,2,-1,981,247,1097,-1,157,159,807,-1,176,913,177,-1,155,857,156,-1,154,921,51,-1,927,130,978,-1,151,136,152,-1,148,150,912,-1,809,930,912,-1,142,129,925,-1,142,1115,143,-1,871,135,137,-1,132,134,931,-1,912,930,932,-1,128,276,126,-1,1074,1106,525,-1,1116,121,122,-1,132,870,918,-1,108,122,119,-1,115,832,112,-1,110,122,108,-1,97,936,315,-1,108,1117,109,-1,105,317,103,-1,942,92,1084,-1,95,939,98,-1,95,97,940,-1,975,939,824,-1,85,1004,83,-1,837,80,82,-1,56,863,79,-1,77,1118,78,-1,70,72,76,-1,62,47,49,-1,56,67,60,-1,881,64,66,-1,1119,47,63,-1,238,72,1100,-1,61,883,59,-1,863,56,58,-1,53,55,948,-1,368,907,69,-1,971,987,219,-1,50,153,51,-1,1119,50,47,-1,41,1120,42,-1,26,215,39,-1,1121,896,1122,-1,950,1120,995,-1,31,953,32,-1,27,277,28,-1,37,36,127,-1,26,219,24,-1,18,966,19,-1,17,1123,15,-1,17,16,960,-1,10,327,11,-1,5,1124,3,-1,2,255,0,-1,965,15,7,-1,965,16,15,-1,21,17,960,-1,21,1125,17,-1,963,959,1126,-1,963,964,959,-1,1127,4,1128,-1,5,4,1127,-1,1129,1127,1130,-1,1131,1127,1129,-1,959,18,1123,-1,958,18,959,-1,1132,956,1129,-1,956,1132,955,-1,155,34,33,-1,280,34,155,-1,1133,859,1134,-1,1133,1135,859,-1,1136,25,24,-1,1136,972,25,-1,952,29,28,-1,952,40,29,-1,235,221,970,-1,968,221,235,-1,971,221,968,-1,1137,1136,1138,-1,1136,1137,1122,-1,1105,1139,886,-1,1139,1105,1104,-1,885,890,1140,-1,885,990,890,-1,237,1141,992,-1,1141,237,236,-1,1142,876,1143,-1,1142,877,876,-1,74,945,70,-1,74,73,945,-1,1143,867,1142,-1,1143,994,867,-1,313,827,312,-1,313,858,827,-1,310,1144,1145,-1,310,826,1144,-1,982,1146,260,-1,982,1147,1146,-1,975,102,101,-1,975,831,102,-1,1148,941,1149,-1,1148,974,941,-1,935,104,936,-1,976,104,935,-1,1148,816,974,-1,816,1148,1116,-1,1150,132,1151,-1,1150,870,132,-1,977,126,276,-1,126,977,1152,-1,1153,143,1154,-1,1153,139,143,-1,208,930,209,-1,208,929,930,-1,130,144,148,-1,129,144,130,-1,107,1155,1156,-1,107,926,1155,-1,979,321,923,-1,321,979,922,-1,922,1111,197,-1,1111,922,979,-1,1157,118,128,-1,118,1157,902,-1,1158,1159,1160,-1,1158,1161,1159,-1,993,919,1162,-1,993,257,919,-1,176,1163,157,-1,1163,176,1113,-1,983,916,1164,-1,916,983,203,-1,1165,1166,1167,-1,1166,1165,1168,-1,281,983,282,-1,281,166,983,-1,1086,168,1088,-1,1086,169,168,-1,1169,852,1170,-1,1165,852,1169,-1,875,1171,1172,-1,875,242,1171,-1,1099,909,874,-1,1098,909,1099,-1,1098,249,909,-1,928,979,924,-1,979,928,1111,-1,908,63,906,-1,908,1173,63,-1,6,231,199,-1,6,8,231,-1,907,62,69,-1,62,907,906,-1,211,746,900,-1,1174,746,211,-1,170,213,173,-1,213,170,985,-1,985,1107,1110,-1,985,899,1107,-1,125,1175,1109,-1,125,124,1175,-1,523,1106,1108,-1,523,525,1106,-1,1176,204,986,-1,1176,205,204,-1,1177,948,1178,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_6()
		{
			int[] value = {949,948,1177,-1,40,35,29,-1,39,35,40,-1,988,1122,1137,-1,988,1121,1122,-1,44,891,987,-1,223,891,44,-1,1140,888,946,-1,890,888,1140,-1,1105,1179,989,-1,1179,1105,1180,-1,1100,992,1141,-1,880,992,1100,-1,991,60,68,-1,991,61,60,-1,64,1101,71,-1,64,880,1101,-1,1171,1181,1182,-1,146,1181,1171,-1,1183,1184,1185,-1,1183,251,1184,-1,1186,183,182,-1,1159,183,1186,-1,1187,1188,1185,-1,1188,1187,1189,-1,818,139,1153,-1,140,139,818,-1,135,993,872,-1,993,135,871,-1,1190,1186,1191,-1,1190,1192,1186,-1,79,266,994,-1,79,864,266,-1,967,861,220,-1,861,967,951,-1,1092,853,996,-1,1092,1193,853,-1,1134,1092,1133,-1,1134,1193,1092,-1,279,853,278,-1,1090,853,279,-1,1090,854,853,-1,1001,849,1170,-1,1001,850,849,-1,1194,847,1195,-1,1194,999,847,-1,849,1196,1197,-1,997,1196,849,-1,1198,1169,1197,-1,1199,1169,1198,-1,1200,1201,1202,-1,1203,1201,1200,-1,745,1204,915,-1,745,1205,1204,-1,980,320,118,-1,980,998,320,-1,286,999,1000,-1,843,999,286,-1,1002,846,845,-1,1002,1087,846,-1,1206,293,1207,-1,1206,840,293,-1,169,189,188,-1,169,1086,189,-1,838,841,1208,-1,841,838,294,-1,297,263,1095,-1,296,263,297,-1,1096,115,1005,-1,1096,934,115,-1,301,113,834,-1,301,111,113,-1,91,829,828,-1,91,90,829,-1,81,1094,82,-1,81,1144,1094,-1,823,92,94,-1,92,823,822,-1,1009,941,821,-1,941,1009,1209,-1,820,95,99,-1,820,96,95,-1,1148,121,1116,-1,1148,1151,121,-1,818,815,814,-1,815,818,1153,-1,318,814,319,-1,318,120,814,-1,74,811,923,-1,74,810,811,-1,809,171,175,-1,809,150,171,-1,48,1210,49,-1,48,1177,1210,-1,797,505,1211,-1,797,506,505,-1,506,796,725,-1,506,328,796,-1,806,1212,1213,-1,1010,1212,806,-1,1214,793,1011,-1,1214,805,793,-1,1215,1216,1217,-1,1215,324,1216,-1,1012,1214,791,-1,1012,1217,1214,-1,1218,738,791,-1,804,738,1218,-1,1012,1219,1220,-1,792,1219,1012,-1,1082,350,349,-1,580,350,1082,-1,667,1054,586,-1,667,789,1054,-1,583,1048,346,-1,583,655,1048,-1,1015,728,1014,-1,1221,728,1015,-1,530,723,713,-1,530,724,723,-1,724,530,366,-1,337,1222,532,-1,1223,1222,337,-1,1224,715,1225,-1,1224,1226,715,-1,548,551,1034,-1,1061,551,548,-1,706,1227,1228,-1,706,705,1227,-1,546,386,781,-1,546,387,386,-1,1229,1228,1227,-1,1229,1230,1228,-1,655,633,630,-1,655,688,633,-1,1231,628,1232,-1,1231,629,628,-1,1233,1029,569,-1,1233,1234,1029,-1,412,1019,413,-1,412,658,1019,-1,774,1235,1236,-1,774,775,1235,-1,624,1233,768,-1,1233,624,626,-1,1237,423,415,-1,1238,423,1237,-1,443,1239,1240,-1,443,1076,1239,-1,439,766,1020,-1,1241,766,439,-1,1073,431,1078,-1,1073,450,431,-1,1021,735,641,-1,1021,1242,735,-1,698,441,763,-1,441,698,442,-1,1243,418,1244,-1,1243,759,418,-1,638,757,758,-1,756,757,638,-1,1065,756,515,-1,757,756,1065,-1,755,1245,437,-1,754,1245,755,-1,1246,1158,1160,-1,1246,699,1158,-1,1247,695,1248,-1,1247,565,695,-1,1249,486,753,-1,1070,486,1249,-1,1027,736,1250,-1,509,736,1027,-1,1166,1251,1252,-1,1168,1251,1166,-1,736,593,592,-1,736,473,593,-1,1052,607,600,-1,1052,476,607,-1,682,1253,1254,-1,1253,682,1251,-1,1255,704,1256,-1,1255,1035,704,-1,701,1059,702,-1,701,1060,1059,-1,701,556,1060,-1,516,1024,1257,-1,516,515,1024,-1,619,1258,1238,-1,619,618,1258,-1,805,324,323,-1,805,1216,324,-1,746,733,732,-1,733,746,1174,-1,519,1071,483,-1,1259,1071,519,-1,1064,1259,521,-1,1064,1260,1259,-1,513,1261,730,-1,513,514,1261,-1,527,1257,785,-1,527,526,1257,-1,1262,1210,1263,-1,1262,1264,1210,-1,798,334,801,-1,334,798,799,-1,1265,545,544,-1,1265,1266,545,-1,721,1267,722,-1,1063,1267,721,-1,717,1226,782,-1,1226,717,716,-1,357,1032,718,-1,357,534,1032,-1,1034,710,379,-1,1034,551,710,-1,708,711,555,-1,705,711,708,-1,485,563,456,-1,485,484,563,-1,1068,1248,1256,-1,1068,1247,1248,-1,1268,1269,1270,-1,1268,559,1269,-1,490,1271,491,-1,1271,490,1246,-1,1188,1272,1270,-1,1189,1272,1188,-1,450,648,431,-1,648,450,449,-1,695,448,697,-1,1036,448,695,-1,1271,1190,1273,-1,1271,1192,1190,-1,575,390,1230,-1,575,692,390,-1,713,690,530,-1,713,712,690,-1,1274,1040,1055,-1,1274,1275,1040,-1,1274,1276,1277,-1,1274,1055,1276,-1,686,1039,1278,-1,686,589,1039,-1,686,685,589,-1,681,676,1254,-1,681,677,676,-1,1053,1279,1280,-1,1281,1279,1053,-1,682,1252,1251,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_7()
		{
			int[] value = {1252,682,606,-1,1282,1279,1283,-1,1284,1279,1282,-1,594,1285,1286,-1,594,1287,1285,-1,1288,1289,1286,-1,1290,1289,1288,-1,591,595,1289,-1,680,595,591,-1,599,675,679,-1,599,601,675,-1,1291,1166,1252,-1,1292,1166,1291,-1,670,1293,1294,-1,1293,670,669,-1,1045,1295,668,-1,1045,1273,1295,-1,428,568,662,-1,428,768,568,-1,1046,618,663,-1,1046,1079,618,-1,1047,400,657,-1,1047,401,400,-1,587,392,391,-1,587,1231,392,-1,405,653,403,-1,773,653,405,-1,774,1049,651,-1,1296,1049,774,-1,1018,649,409,-1,1018,408,649,-1,435,1235,1075,-1,435,1240,1235,-1,432,648,1050,-1,431,648,432,-1,1050,637,636,-1,1050,1077,637,-1,1081,1016,362,-1,1264,1016,1081,-1,1242,764,1022,-1,1021,764,1242,-1,467,498,480,-1,467,741,498,-1,741,466,761,-1,467,466,741,-1,617,765,621,-1,617,1042,765,-1,422,1079,769,-1,422,421,1079,-1,1079,1258,618,-1,1079,421,1258,-1,452,1078,1297,-1,452,1073,1078,-1,1051,632,631,-1,1051,778,632,-1,395,1231,1232,-1,1231,395,392,-1,662,567,623,-1,662,568,567,-1,620,1298,615,-1,1298,620,623,-1,609,613,668,-1,614,613,609,-1,497,611,495,-1,614,611,497,-1,1294,1291,670,-1,1291,1294,1292,-1,1043,1025,1042,-1,1043,597,1025,-1,1028,1286,1285,-1,1288,1286,1028,-1,1287,1205,1285,-1,1287,1200,1205,-1,1283,1198,1282,-1,1283,1299,1198,-1,1299,1254,1253,-1,1254,1299,681,-1,1287,1053,1280,-1,1053,1287,594,-1,339,685,790,-1,685,339,589,-1,1275,1277,1083,-1,1275,1274,1277,-1,354,686,1278,-1,355,686,354,-1,355,1055,686,-1,754,511,1245,-1,754,747,511,-1,419,1230,1229,-1,419,575,1230,-1,1271,1045,491,-1,1045,1271,1273,-1,567,1056,571,-1,567,743,1056,-1,566,742,1076,-1,566,749,742,-1,1189,700,1272,-1,1300,700,1189,-1,0,1058,564,-1,1301,1058,0,-1,559,1058,1269,-1,559,560,1058,-1,499,1302,561,-1,499,1060,1302,-1,1303,1256,1248,-1,1256,1303,1255,-1,706,1304,707,-1,380,1304,706,-1,385,377,535,-1,385,387,377,-1,537,357,718,-1,537,358,357,-1,545,542,543,-1,545,792,542,-1,782,1224,375,-1,1226,1224,782,-1,691,344,787,-1,344,691,581,-1,1263,529,1262,-1,529,1263,895,-1,1261,1257,526,-1,1261,516,1257,-1,521,522,1064,-1,522,521,436,-1,1260,524,1305,-1,524,1260,1064,-1,1249,468,1305,-1,1249,753,468,-1,520,1250,731,-1,520,1027,1250,-1,514,516,1261,-1,514,517,516,-1,507,199,508,-1,507,737,199,-1,1211,802,797,-1,1211,1306,802,-1,430,769,1079,-1,429,769,430,-1,786,1257,1024,-1,1257,786,785,-1,701,557,556,-1,701,1031,557,-1,1030,1069,704,-1,1030,503,1069,-1,494,1056,751,-1,493,1056,494,-1,491,573,572,-1,573,491,1045,-1,1069,1256,704,-1,1068,1256,1069,-1,1072,484,1070,-1,472,484,1072,-1,672,601,608,-1,672,675,601,-1,683,1254,676,-1,683,682,1254,-1,673,1043,616,-1,1043,673,603,-1,1288,732,731,-1,732,1288,1028,-1,697,1248,695,-1,1303,1248,697,-1,470,494,752,-1,492,494,470,-1,1023,1242,1022,-1,1023,1307,1242,-1,440,388,760,-1,440,1080,388,-1,1307,735,1242,-1,1307,734,735,-1,750,457,1308,-1,457,750,458,-1,455,452,635,-1,452,455,453,-1,446,694,445,-1,446,1036,694,-1,1237,439,665,-1,1237,1241,439,-1,1029,1076,742,-1,1076,1029,1239,-1,434,1050,648,-1,434,1077,1050,-1,1238,665,619,-1,1238,1237,665,-1,427,1075,1309,-1,426,1075,427,-1,420,425,424,-1,425,420,776,-1,1051,773,405,-1,773,1051,406,-1,401,653,652,-1,401,1047,653,-1,1234,626,1296,-1,1233,626,1234,-1,1231,1048,629,-1,1231,587,1048,-1,656,397,780,-1,398,397,656,-1,402,652,1019,-1,401,652,402,-1,396,399,664,-1,396,397,399,-1,1230,381,1228,-1,1230,390,381,-1,389,1243,1310,-1,1080,1243,389,-1,1033,386,385,-1,1033,639,386,-1,705,1311,1227,-1,1311,705,708,-1,1225,540,1224,-1,1225,541,540,-1,1063,1222,1267,-1,1063,1312,1222,-1,365,356,366,-1,365,531,356,-1,786,362,1016,-1,363,362,786,-1,361,364,645,-1,360,364,361,-1,723,358,713,-1,723,719,358,-1,351,727,352,-1,727,351,1223,-1,347,586,1054,-1,788,586,347,-1,1276,348,689,-1,348,1276,349,-1,729,342,590,-1,729,343,342,-1,1221,338,787,-1,1221,1015,338,-1,1313,1219,333,-1,1219,1313,1220,-1,791,1011,1218,-1,791,1214,1011,-1,1212,1313,1314,-1,1313,1212,1315,-1,1217,805,1214,-1,1217,1216,805,-1,150,172,171,-1,150,190,172,-1,977,1154,1316,-1,1154,977,933,-1,105,1152,938,-1,105,1317,1152,-1,314,1084,315,-1,314,942,1084,-1,1144,84,1145,-1,81,84,1144,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_8()
		{
			int[] value = {834,91,828,-1,834,113,91,-1,833,1095,1318,-1,833,297,1095,-1,1319,1191,1208,-1,1319,1190,1191,-1,1208,1293,1319,-1,1293,1208,841,-1,1207,292,289,-1,1207,293,292,-1,1167,1207,851,-1,1207,1167,1206,-1,286,1088,168,-1,846,1088,286,-1,980,848,998,-1,980,284,848,-1,1320,915,1204,-1,915,1320,1321,-1,1205,1202,1204,-1,1205,1200,1202,-1,1198,1196,1282,-1,1198,1197,1196,-1,1170,1197,1169,-1,849,1197,1170,-1,1194,1202,1201,-1,1195,1202,1194,-1,854,280,38,-1,1090,280,854,-1,1133,1091,30,-1,1133,1092,1091,-1,853,43,278,-1,853,41,43,-1,853,1193,41,-1,207,902,1157,-1,207,901,902,-1,1318,265,262,-1,265,1318,1095,-1,186,265,264,-1,186,185,265,-1,1146,1096,260,-1,1096,1146,934,-1,1322,1189,1187,-1,1189,1322,1300,-1,254,0,255,-1,0,254,1301,-1,1185,1323,1187,-1,1185,1184,1323,-1,251,249,1184,-1,251,241,249,-1,920,180,247,-1,180,920,181,-1,1172,1182,1162,-1,1171,1182,1172,-1,991,876,884,-1,876,991,68,-1,65,226,66,-1,65,75,226,-1,65,73,75,-1,989,1102,233,-1,1102,989,1179,-1,1102,230,229,-1,1102,904,230,-1,886,223,222,-1,886,1139,223,-1,1139,891,223,-1,1139,1138,891,-1,1121,233,893,-1,233,1121,988,-1,217,1263,1178,-1,895,1263,217,-1,218,1176,214,-1,218,198,1176,-1,1106,1110,1107,-1,125,1110,1106,-1,1108,899,1324,-1,1107,899,1108,-1,158,1163,1324,-1,158,157,1163,-1,1132,22,894,-1,23,22,1132,-1,955,894,232,-1,1132,894,955,-1,874,191,1099,-1,874,194,191,-1,261,184,981,-1,184,261,185,-1,146,242,147,-1,1171,242,146,-1,180,910,245,-1,191,910,180,-1,175,170,173,-1,170,175,171,-1,1088,1085,1086,-1,1085,1088,1087,-1,282,1164,1325,-1,282,983,1164,-1,843,285,844,-1,843,286,285,-1,1113,1326,1163,-1,1326,1113,1114,-1,184,161,920,-1,161,184,186,-1,156,127,36,-1,156,1093,127,-1,922,154,321,-1,154,922,921,-1,1316,316,938,-1,1316,1115,316,-1,139,141,143,-1,138,141,139,-1,126,1317,836,-1,126,1152,1317,-1,870,982,868,-1,1150,982,870,-1,814,119,818,-1,814,120,119,-1,836,1327,300,-1,836,1317,1327,-1,1149,1209,1147,-1,941,1209,1149,-1,822,1084,92,-1,940,1084,822,-1,823,90,824,-1,823,829,90,-1,306,1147,1209,-1,1147,306,1146,-1,1008,1144,826,-1,1008,1094,1144,-1,88,830,943,-1,830,88,87,-1,824,89,975,-1,89,824,90,-1,86,83,1004,-1,86,88,83,-1,67,994,1143,-1,67,79,994,-1,1155,77,1328,-1,77,1155,1118,-1,74,887,75,-1,74,812,887,-1,1329,877,1142,-1,879,877,1329,-1,908,1180,1173,-1,908,1179,1180,-1,1138,1104,1137,-1,1138,1139,1104,-1,45,987,971,-1,45,44,987,-1,52,947,949,-1,947,52,51,-1,153,1119,813,-1,1119,153,50,-1,969,235,970,-1,969,46,235,-1,972,1122,896,-1,1136,1122,972,-1,275,31,1089,-1,31,275,274,-1,995,1134,859,-1,1120,1134,995,-1,27,35,34,-1,27,29,35,-1,15,18,20,-1,1123,18,15,-1,1330,1129,956,-1,1330,1131,1129,-1,1131,5,1127,-1,1124,5,1131,-1,1126,1123,17,-1,1126,959,1123,-1,1125,1126,17,-1,1126,1125,1128,-1,6,1306,7,-1,1306,6,200,-1,962,1330,1331,-1,962,1332,1330,-1,1130,1128,1125,-1,1127,1128,1130,-1,958,966,18,-1,958,1331,966,-1,1132,1130,23,-1,1129,1130,1132,-1,1121,216,896,-1,893,216,1121,-1,892,216,893,-1,951,277,42,-1,277,951,967,-1,30,1135,1133,-1,30,32,1135,-1,279,277,27,-1,278,277,279,-1,897,215,986,-1,215,897,39,-1,47,52,48,-1,47,50,52,-1,886,1180,1105,-1,886,885,1180,-1,63,813,1119,-1,813,63,946,-1,236,878,1141,-1,878,236,884,-1,68,1143,876,-1,67,1143,68,-1,1328,238,240,-1,238,1328,77,-1,889,881,66,-1,889,882,881,-1,1156,1142,867,-1,1329,1142,1156,-1,953,1094,1008,-1,1094,953,274,-1,1145,1333,310,-1,1333,1145,944,-1,825,973,1333,-1,825,93,973,-1,101,307,1009,-1,101,100,307,-1,1149,1151,1148,-1,1151,1149,1150,-1,935,1117,1334,-1,1117,935,109,-1,1116,110,816,-1,110,1116,122,-1,318,114,1335,-1,318,305,114,-1,935,1327,976,-1,935,1334,1327,-1,1074,125,1106,-1,1074,123,125,-1,128,1093,1157,-1,128,127,1093,-1,931,1151,132,-1,1151,931,121,-1,1115,925,316,-1,142,925,1115,-1,146,914,1181,-1,145,914,146,-1,78,131,927,-1,78,1118,131,-1,929,924,978,-1,929,928,924,-1,1326,163,1336,-1,1114,163,1326,-1,1162,872,993,-1,872,1162,1182,-1,900,1321,984,-1,915,1321,900,-1,848,844,299,-1,287,844,848,-1,1170,291,1001,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_9()
		{
			int[] value = {1170,852,291,-1,1087,1003,1085,-1,1087,1002,1003,-1,178,1114,1113,-1,1114,178,2,-1,1172,910,875,-1,910,1172,1112,-1,179,161,160,-1,179,181,161,-1,188,297,833,-1,187,297,188,-1,248,909,249,-1,248,243,909,-1,218,947,196,-1,53,947,218,-1,1335,112,111,-1,112,1335,114,-1,7,1211,965,-1,7,1306,1211,-1,8,19,231,-1,19,8,20,-1,199,230,508,-1,199,231,230,-1,198,205,1176,-1,198,210,205,-1,1164,212,984,-1,1164,916,212,-1,985,1109,213,-1,1109,985,1110,-1,1174,1109,1175,-1,1174,211,1109,-1,1336,1108,1326,-1,523,1108,1336,-1,217,948,55,-1,1178,948,217,-1,28,220,952,-1,967,220,28,-1,1173,946,63,-1,946,1173,1140,-1,905,232,229,-1,905,955,232,-1,1103,224,228,-1,1103,969,224,-1,1141,239,1100,-1,878,239,1141,-1,1101,72,71,-1,1101,1100,72,-1,2,256,255,-1,256,2,178,-1,246,1112,919,-1,1112,246,245,-1,1323,192,253,-1,1323,1098,192,-1,254,251,1183,-1,254,250,251,-1,252,1322,253,-1,1322,252,1161,-1,1185,1337,1183,-1,1337,1185,1188,-1,1192,1159,1186,-1,1160,1159,1192,-1,261,258,262,-1,261,259,258,-1,839,1186,182,-1,1191,1186,839,-1,858,864,269,-1,858,266,864,-1,32,271,1135,-1,270,271,32,-1,127,836,37,-1,127,126,836,-1,1120,1193,1134,-1,1120,41,1193,-1,954,854,38,-1,855,854,954,-1,1194,1000,999,-1,1338,1000,1194,-1,1196,1338,1339,-1,1338,1196,997,-1,1165,1199,1168,-1,1169,1199,1165,-1,1201,1284,1339,-1,1284,1201,1203,-1,1340,1195,847,-1,1320,1195,1340,-1,283,1325,1340,-1,1325,283,282,-1,1206,1294,840,-1,1292,1294,1206,-1,292,187,189,-1,187,292,295,-1,296,294,838,-1,294,296,295,-1,1318,303,833,-1,304,303,1318,-1,258,1005,304,-1,258,1096,1005,-1,1006,91,113,-1,1006,1007,91,-1,973,310,1333,-1,973,311,310,-1,1150,1147,982,-1,1149,1147,1150,-1,1154,1115,1316,-1,1154,143,1115,-1,1334,111,301,-1,1334,1117,111,-1,111,108,1335,-1,111,1117,108,-1,320,298,302,-1,320,998,298,-1,1306,1066,802,-1,200,1066,1306,-1,1213,1314,330,-1,1212,1314,1213,-1,332,1213,330,-1,332,795,1213,-1,325,1215,1315,-1,1215,325,324,-1,1220,1217,1012,-1,1220,1215,1217,-1,1218,331,804,-1,331,1218,332,-1,800,353,352,-1,800,1265,353,-1,1265,800,801,-1,1013,580,1082,-1,581,580,1013,-1,1341,1083,1277,-1,1341,345,1083,-1,1013,1039,342,-1,1039,1013,1278,-1,1014,1026,730,-1,728,1026,1014,-1,362,359,1081,-1,362,360,359,-1,1225,714,1062,-1,1225,715,714,-1,645,375,361,-1,782,375,645,-1,711,1061,548,-1,707,1061,711,-1,1228,380,706,-1,380,1228,381,-1,553,1310,554,-1,389,1310,553,-1,379,783,547,-1,379,710,783,-1,388,781,644,-1,388,382,781,-1,1227,1244,1229,-1,1244,1227,1311,-1,587,346,1048,-1,788,346,587,-1,1342,1232,628,-1,779,1232,1342,-1,1017,654,1342,-1,1017,404,654,-1,625,413,1049,-1,625,414,413,-1,1240,1236,1235,-1,1239,1236,1240,-1,421,424,1258,-1,420,424,421,-1,1296,1236,1234,-1,1236,1296,774,-1,1238,424,423,-1,1238,1258,424,-1,436,1074,522,-1,436,123,1074,-1,588,437,1245,-1,588,438,437,-1,1240,444,443,-1,435,444,1240,-1,454,450,1073,-1,450,454,451,-1,635,1297,771,-1,635,452,1297,-1,646,756,638,-1,463,756,646,-1,438,464,465,-1,438,588,464,-1,163,1343,1336,-1,1343,163,1072,-1,748,565,1247,-1,748,566,565,-1,1343,1070,1249,-1,1072,1070,1343,-1,477,674,673,-1,477,678,674,-1,1250,592,1290,-1,1250,736,592,-1,608,600,607,-1,601,600,608,-1,1071,482,483,-1,481,482,1071,-1,1069,488,1067,-1,488,1069,500,-1,1035,457,456,-1,457,1035,1255,-1,470,489,471,-1,470,487,489,-1,612,496,615,-1,496,612,497,-1,500,702,1059,-1,500,502,702,-1,1266,792,545,-1,792,1266,1219,-1,334,1219,1266,-1,1219,334,333,-1,738,803,737,-1,738,804,803,-1,1071,1260,479,-1,1260,1071,1259,-1,518,1259,519,-1,521,1259,518,-1,518,1174,1175,-1,518,733,1174,-1,524,1336,1343,-1,1336,524,523,-1,784,529,528,-1,529,784,1262,-1,1266,801,334,-1,1266,1265,801,-1,544,353,1265,-1,722,353,544,-1,532,1312,533,-1,532,1222,1312,-1,533,714,534,-1,533,1312,714,-1,507,539,543,-1,507,504,539,-1,539,721,544,-1,541,721,539,-1,1304,1061,707,-1,1061,1304,552,-1,383,549,384,-1,383,550,549,-1,563,472,564,-1,484,472,563,-1,1068,748,1247,-1,1067,748,1068,-1,556,559,1268,-1,556,558,559,-1,1302,1270,1272,-1,1302,1268,1270,-1,1337,1270,1269,-1,1188,1270,1337,-1,1246,1192,1271,-1,1192,1246,1160,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_10()
		{
			int[] value = {568,1233,569,-1,768,1233,568,-1,570,492,572,-1,570,493,492,-1,570,1298,571,-1,574,1298,570,-1,692,688,585,-1,692,575,688,-1,1038,345,1341,-1,345,1038,584,-1,665,438,666,-1,665,439,438,-1,1055,349,1276,-1,1055,355,349,-1,685,789,790,-1,789,685,684,-1,1044,1053,596,-1,1053,1044,1281,-1,1281,1283,1279,-1,1041,1283,1281,-1,1199,1251,1168,-1,1251,1199,1253,-1,1284,1280,1279,-1,1203,1280,1284,-1,594,1289,595,-1,1289,594,1286,-1,1290,591,1289,-1,592,591,1290,-1,600,678,1052,-1,678,600,599,-1,605,1252,606,-1,1291,1252,605,-1,611,605,604,-1,611,610,605,-1,1293,1295,1319,-1,669,1295,1293,-1,1273,1319,1295,-1,1273,1190,1319,-1,574,615,1298,-1,574,612,615,-1,400,661,1046,-1,400,659,661,-1,628,1017,1342,-1,628,777,1017,-1,1234,1239,1029,-1,1239,1234,1236,-1,776,1309,649,-1,776,427,1309,-1,1241,415,771,-1,1241,1237,415,-1,1078,766,1297,-1,433,766,1078,-1,758,639,638,-1,758,386,639,-1,1210,1081,49,-1,1210,1264,1081,-1,481,642,482,-1,481,460,642,-1,643,386,758,-1,643,644,386,-1,647,621,765,-1,621,647,636,-1,769,1077,422,-1,769,637,1077,-1,775,649,1309,-1,649,775,650,-1,411,413,1019,-1,411,410,413,-1,770,688,417,-1,770,633,688,-1,396,1232,779,-1,396,395,1232,-1,661,412,627,-1,661,659,412,-1,430,661,660,-1,1046,661,430,-1,623,571,1298,-1,623,567,571,-1,669,668,1295,-1,609,668,669,-1,495,476,496,-1,495,607,476,-1,610,1291,605,-1,610,670,1291,-1,606,671,604,-1,606,683,671,-1,596,678,1044,-1,678,596,674,-1,765,1025,755,-1,765,1042,1025,-1,1285,745,1028,-1,1285,1205,745,-1,1280,1200,1287,-1,1200,1280,1203,-1,1253,1198,1299,-1,1198,1253,1199,-1,1283,681,1299,-1,681,1283,1041,-1,679,1281,1044,-1,1281,679,1041,-1,1083,1040,1275,-1,1040,1083,347,-1,1082,1278,1013,-1,1082,354,1278,-1,437,767,755,-1,437,1020,767,-1,1341,578,1038,-1,1341,689,578,-1,585,576,692,-1,584,576,585,-1,1229,418,419,-1,1229,1244,418,-1,699,1300,1158,-1,699,700,1300,-1,1301,1269,1058,-1,1337,1269,1301,-1,1272,561,1302,-1,700,561,1272,-1,1060,1268,1302,-1,1060,556,1268,-1,1067,703,748,-1,703,1067,488,-1,1308,1255,1303,-1,1255,1308,457,-1,549,378,384,-1,549,709,378,-1,372,1304,380,-1,372,552,1304,-1,1034,549,548,-1,1034,709,549,-1,541,1062,721,-1,1225,1062,541,-1,538,385,535,-1,538,1033,385,-1,351,722,1267,-1,351,353,722,-1,729,1221,343,-1,1221,729,728,-1,784,1264,1262,-1,1264,784,1016,-1,730,526,1014,-1,730,1261,526,-1,1175,436,518,-1,436,1175,124,-1,1343,1305,524,-1,1343,1249,1305,-1,1305,479,1260,-1,1305,468,479,-1,520,483,1027,-1,519,483,520,-1,747,735,511,-1,747,641,735,-1,376,367,69,-1,739,367,376,-1,737,1066,199,-1,737,803,1066,-1,375,540,739,-1,375,1224,540,-1,757,1307,1023,-1,1065,1307,757,-1,557,1030,704,-1,1031,1030,557,-1,503,500,1069,-1,502,500,503,-1,604,495,611,-1,604,608,495,-1,608,604,672,-1,743,751,1056,-1,742,751,743,-1,742,1057,751,-1,675,671,676,-1,675,672,671,-1,597,603,602,-1,597,1043,603,-1,731,1290,1288,-1,731,1250,1290,-1,478,673,616,-1,478,477,673,-1,762,1303,697,-1,762,1308,1303,-1,1057,748,703,-1,748,1057,749,-1,562,1246,490,-1,562,699,1246,-1,1024,363,786,-1,463,363,1024,-1,1022,643,1023,-1,1022,760,643,-1,1080,759,1243,-1,1080,440,759,-1,734,1065,517,-1,1307,1065,734,-1,761,1308,762,-1,1308,761,750,-1,766,771,1297,-1,1241,771,766,-1,510,1245,511,-1,510,588,1245,-1,1309,1235,775,-1,1075,1235,1309,-1,409,651,410,-1,651,409,650,-1,403,1047,656,-1,1047,403,653,-1,1296,625,1049,-1,626,625,1296,-1,780,1342,654,-1,779,1342,780,-1,656,654,403,-1,780,654,656,-1,777,778,1017,-1,777,632,778,-1,664,657,663,-1,664,399,657,-1,789,1040,1054,-1,1040,789,684,-1,1310,1244,1311,-1,1243,1244,1310,-1,717,639,1033,-1,717,640,639,-1,1311,554,1310,-1,1311,708,554,-1,527,784,528,-1,784,527,785,-1,716,715,1226,-1,716,1032,715,-1,1312,1062,714,-1,1063,1062,1312,-1,1223,1267,1222,-1,351,1267,1223,-1,690,582,530,-1,348,582,690,-1,582,348,350,-1,343,787,344,-1,343,1221,787,-1,336,1223,337,-1,336,727,1223,-1,689,1277,1276,-1,689,1341,1277,-1,799,335,334,-1,799,796,335,-1,1314,333,335,-1,1314,1313,333,-1,1218,795,332,-1,795,1218,1011,-1,1315,1220,1313,-1,1220,1315,1215,-1,1010,1315,1212,-1,1315,1010,325,-1,795,806,1213,-1};
			return value;
		}
		private int[] getc3_Geo_8_39_coordIndex_11()
		{
			int[] value = {795,794,806,-1,330,335,328,-1,330,1314,335,-1,331,797,802,-1,331,329,797,-1,190,159,172,-1,190,808,159,-1,932,929,978,-1,929,932,930,-1,949,48,52,-1,48,949,1177,-1,120,1335,108,-1,120,318,1335,-1,820,974,816,-1,819,974,820,-1,101,939,975,-1,101,98,939,-1,858,937,103,-1,858,313,937,-1,1145,83,944,-1,1145,84,83,-1,102,1006,309,-1,102,1007,1006,-1,1006,112,832,-1,112,1006,113,-1,262,304,1318,-1,262,258,304,-1,1208,839,838,-1,1208,1191,839,-1,1293,840,1294,-1,841,840,1293,-1,1166,1206,1167,-1,1206,1166,1292,-1,289,851,1207,-1,291,851,289,-1,847,283,1340,-1,283,847,842,-1,1340,1321,1320,-1,1321,1340,1325,-1,1204,1195,1320,-1,1204,1202,1195,-1,1339,1282,1196,-1,1282,1339,1284,-1,1167,852,1165,-1,851,852,1167,-1,1339,1194,1201,-1,1194,1339,1338,-1,1338,845,1000,-1,997,845,1338,-1,996,30,1091,-1,31,30,996,-1,272,1135,271,-1,272,859,1135,-1,860,970,221,-1,860,862,970,-1,107,867,106,-1,107,1156,867,-1,1300,1161,1158,-1,1300,1322,1161,-1,1183,1301,254,-1,1301,1183,1337,-1,253,1187,1323,-1,1187,253,1322,-1,1184,1098,1323,-1,1184,249,1098,-1,1162,1112,1172,-1,1162,919,1112,-1,256,177,147,-1,256,178,177,-1,878,879,239,-1,879,878,877,-1,882,992,881,-1,882,237,992,-1,990,1103,228,-1,990,222,1103,-1,1179,904,1102,-1,1179,908,904,-1,75,227,226,-1,75,887,227,-1,1137,989,988,-1,989,1137,1104,-1,232,893,233,-1,232,894,893,-1,22,961,892,-1,12,961,22,-1,1210,1178,1263,-1,1210,1177,1178,-1,214,986,215,-1,214,1176,986,-1,1324,1326,1108,-1,1324,1163,1326,-1,898,1324,899,-1,898,158,1324,-1,173,212,916,-1,212,173,213,-1,1124,962,3,-1,1124,1332,962,-1,1334,300,1327,-1,1334,301,300,-1,244,248,875,-1,248,244,243,-1,191,193,910,-1,193,191,194,-1,189,289,292,-1,1085,289,189,-1,1003,289,1085,-1,981,259,261,-1,981,868,259,-1,981,1097,868,-1,290,1002,1001,-1,290,1003,1002,-1,287,284,288,-1,287,848,284,-1,1325,984,1321,-1,1325,1164,984,-1,844,167,299,-1,844,285,167,-1,1182,873,872,-1,1182,1181,873,-1,246,1097,247,-1,869,1097,246,-1,1159,252,183,-1,1159,1161,252,-1,51,196,947,-1,196,51,921,-1,811,978,924,-1,811,927,978,-1,926,1118,1155,-1,926,131,1118,-1,1111,903,210,-1,903,1111,928,-1,1181,917,873,-1,914,917,1181,-1,938,977,1316,-1,977,938,1152,-1,1157,856,207,-1,1157,1093,856,-1,1154,815,1153,-1,815,1154,933,-1,976,1317,105,-1,1317,976,1327,-1,1146,308,934,-1,306,308,1146,-1,821,99,98,-1,819,99,821,-1,829,94,830,-1,823,94,829,-1,307,1209,1009,-1,1209,307,306,-1,1333,943,825,-1,943,1333,944,-1,825,830,94,-1,830,825,943,-1,942,311,973,-1,942,314,311,-1,828,1004,834,-1,828,86,1004,-1,996,954,1089,-1,855,954,996,-1,1156,1328,1329,-1,1328,1156,1155,-1,812,888,887,-1,812,322,888,-1,240,1329,1328,-1,240,879,1329,-1,885,1173,1180,-1,885,1140,1173,-1,1138,24,891,-1,24,1138,1136,-1,46,1103,44,-1,46,969,1103,-1,861,860,221,-1,861,995,860,-1,950,995,861,-1,1008,273,953,-1,1008,827,273,-1,1089,835,275,-1,1089,954,835,-1,950,42,1120,-1,42,950,951,-1,21,12,22,-1,21,13,12,-1,23,1125,21,-1,23,1130,1125,-1,1331,956,966,-1,1331,1330,956,-1,1332,1131,1330,-1,1332,1124,1131,-1,957,1331,958,-1,957,962,1331,-1,1128,963,1126,-1,963,1128,4,-1,13,201,14,-1,13,960,201,-1,505,965,1211,-1,505,201,965,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc3_Coord_9_39_point_1()
		{
			double[] value = {0.0,54.99906,-1.11157,0.0,54.99443,-1.12548,-.1021,55.00642,-1.12684,-.21434,54.23622,-2.09192,-.19653,54.21913,-2.07998,-.22055,54.221,-2.06121,-.028,54.40435,-2.02718,-.04036,54.32457,-2.03773,-.06105,54.38005,-2.03629,-.07429,54.35682,-1.81269,0.0,54.34506,-1.85208,-.07537,54.36398,-1.80183,-.06005,54.29091,-1.88123,-.05796,54.28717,-1.89235,-.05013,54.29607,-1.8835,-.05997,54.29375,-2.03339,-.05406,54.27208,-2.01138,-.09098,54.23529,-2.06549,-.11992,54.2907,-2.095,-.16779,54.34026,-1.99331,-.08748,54.33217,-2.04562,-.07654,54.25303,-1.95014,-.12399,54.26739,-1.86164,-.11617,54.24666,-1.90716,-.31441,54.42852,-1.62521,-.30865,54.42857,-1.6259,-.35955,54.41014,-1.52858,-.44227,54.3879,-1.38104,-.48166,54.37554,-1.42107,-.43511,54.38572,-1.38791,-.82452,54.62327,-1.25533,-.79222,54.67027,-1.14862,-.82766,54.63004,-1.25917,-.41149,54.42395,-1.32927,-.41934,54.42205,-1.32587,-.41475,54.41577,-1.33996,-.57046,54.62509,-1.15163,-.57816,54.6292,-1.14335,-.58088,54.61811,-1.14824,-.37719,54.42694,-1.41083,-.39688,54.39795,-1.44334,-.62844,54.44644,-1.40428,-.57086,54.40166,-1.4534,-.58766,54.44114,-1.38625,-.38238,54.57061,-1.55772,-.39847,54.57187,-1.5421,-.43736,54.60203,-1.54406,-.11826,54.75617,-1.67847,-.09898,54.7231,-1.68077,0.0,54.73719,-1.70114,-.17708,54.76557,-1.65366,-.22608,54.73132,-1.62658,-.16069,54.7278,-1.65535,-.21799,54.61947,-1.6327,-.23869,54.52566,-1.63737,-.19183,54.48927,-1.68496,-.78125,54.83178,-1.3434,-.72372,54.80018,-1.38006,-.72335,54.77052,-1.37883,-.71917,54.80848,-1.37845,-.77511,54.83956,-1.34536,-.71659,54.86948,-1.32711,-.12462,54.7529,-1.6852,-.19524,54.78287,-1.6538,-.44662,54.83158,-1.33552,-.44059,54.82828,-1.33712,-.51724,54.7694,-1.37927,-.80518,54.90158,-1.26141,-.8005,54.90726,-1.26554,0.0,54.73951,-1.70861,-.40193,54.89063,-1.29092,-.40971,54.89254,-1.29287,-.44262,54.95902,-1.22558,-.39654,54.82568,-1.37585,-.38808,54.82172,-1.38001,-.39567,54.82143,-1.38521,-.43856,54.95998,-1.21917,-.45217,54.97477,-1.20083,-.43983,54.93645,-1.21304,-.78353,54.87203,-1.22975,-.70726,54.6576,-.98306,-.78455,54.66892,-1.01123,-.72816,54.68693,-1.07087,-.90658,54.62966,-.9477,-.8779,54.63796,-.98698,-.82602,54.60876,-.96617,-.85359,54.62691,-.90596,-.87626,54.66828,-.88606,-.90847,54.64476,-.91834,-.71924,54.80566,-.76022,-.7409,54.79618,-.80216,-.70953,54.77417,-.78426,-.90878,54.83213,-.94695,-.94518,54.77313,-.95691,-.90909,54.75357,-.89347,-.73598,54.87606,-.84502,-.71447,54.8711,-.86266,-.75866,54.84726,-.91214,-.7192,54.94852,-.78983,-.71669,54.95096,-.80162};
			return value;
		}
		private double[] getc3_Coord_9_39_point_2()
		{
			double[] value = {-.68063,54.89653,-.71065,-.69066,54.90254,-.71412,-.68661,54.88619,-.71311,-.71176,54.85697,-1.04971,-.66573,54.84564,-.98875,-.60248,54.8435,-1.02911,-.69861,54.91619,-1.09514,-.61119,54.94024,-1.0947,-.55961,54.83736,-.85891,-.64388,54.83936,-.87825,-.57131,54.88292,-.85476,-.61146,54.74797,-.86192,-.59535,54.75201,-.84015,-.66802,54.73998,-.82323,-.52865,54.76411,-.83291,-.52355,54.81982,-.80208,-.43,54.74453,-1.0189,-.45665,54.75101,-1.03844,-.39237,54.67787,-1.08048,-.49499,54.88271,-.86491,-.48254,54.83131,-.86138,-.50789,54.93415,-.86115,-.55545,54.88263,-.85543,0.0,54.71655,-1.19025,0.0,54.68469,-1.18474,-.0322,54.7165,-1.18241,-.53477,54.74425,-1.05593,-.50515,54.67251,-1.11287,-.46293,54.70026,-1.09289,-.45998,54.90479,-1.13905,-.42081,54.85887,-1.174,-.48002,54.91534,-1.16053,-.45951,55.00956,-.88313,-.43406,55.01818,-.93399,-.44994,54.9606,-.96323,-.37142,55.0208,-1.06519,-.38269,54.94117,-1.08034,-.4315,54.96247,-1.012,-.45315,54.93771,-1.0313,-.46691,54.91824,-1.01282,-.46019,54.92345,-.98211,-.46914,54.93113,-1.06309,-.48274,54.92818,-1.0874,-.48726,54.91137,-1.04355,-.44289,54.90796,-1.122,-.26012,55.06112,-1.10833,-.27551,55.07889,-1.06881,-.23863,55.04623,-1.06331,-.39091,54.85485,-1.15115,-.36932,54.8855,-1.12657,-.30666,54.83046,-1.147,-.41782,54.92348,-1.10136,-.34188,54.92495,-1.11113,-.22998,54.77169,-1.62351,-.30163,54.78606,-1.5634,-.47928,54.53152,-1.23097,-.51255,54.62779,-1.18609,-.23825,55.00169,-1.1523,-.21909,54.94427,-1.16831,-.26216,54.96426,-1.15788,-.21779,54.9338,-.74004,-.23858,54.93585,-.71367,-.21839,54.91769,-.73005,0.0,54.98828,-1.14173,-.30953,54.54374,-1.15989,-.33579,54.60405,-1.14743,-.2978,54.53224,-1.17798,-.30051,54.59811,-.81061,-.29202,54.58312,-.79165,-.29159,54.59269,-.78227,-.20446,54.7306,-1.1685,-.25556,54.78053,-1.15775,-.2509,54.8782,-1.1518,-.22714,54.63232,-1.19261,-.31433,54.61903,-1.16828,-.27193,54.68516,-1.18362,-.23507,55.0124,-1.14386,-.234,55.03301,-1.10912,-.16897,55.01927,-1.12001,-.259,54.99529,-.75076,-.31617,55.03957,-.78897,-.27429,54.99546,-.72576,-.13077,54.85068,-.65537,-.12124,54.89153,-.68992,-.29593,54.97047,-.71541,-.29274,54.91981,-.71641,-.26715,54.92119,-.70617,-.22906,54.63893,-.70959,-.25627,54.62207,-.7351,-.24694,54.5759,-.69749,-.31062,54.90753,-1.1325,-.29742,55.02883,-.81518,-.21118,54.95836,-.78208,-.30832,55.01731,-.8945,-.29157,55.00761,-.8746,-.2883,55.00237,-.89681,-.28751,54.71146,-1.56545,-.33953,54.71592,-1.48382,-.33245,54.65751,-1.48014,0.0,54.47397,-1.98459};
			return value;
		}
		private double[] getc3_Coord_9_39_point_3()
		{
			double[] value = {0.0,54.40964,-2.02357,-.03529,54.27804,-1.99237,0.0,54.30637,-1.906,-.26452,54.53412,-1.19592,-.41052,54.57918,-1.30145,-.37686,54.63096,-1.37496,-.39858,54.6802,-1.28079,-.39046,54.70015,-1.18437,-.35862,54.73413,-1.21821,-.33839,54.71752,-1.17059,-.36707,54.68917,-1.40749,-.06946,54.55881,-1.21223,-.14817,54.55307,-1.21004,-.14311,54.64061,-1.19345,-.30992,54.5404,-1.55782,-.33873,54.45474,-1.52065,-.15305,54.35504,-1.7605,-.10241,54.47004,-1.75155,-.29349,54.62319,-1.5693,-.38447,54.40438,-1.52998,-.48278,54.40522,-1.50372,-.49306,54.49398,-1.53845,-.34971,54.63329,-1.61786,-.34323,54.56272,-1.61251,-.47123,54.69824,-1.53519,-.5317,54.71885,-1.50219,-.4564,54.75794,-1.43745,-.40401,54.78084,-1.50688,-.41253,54.72237,-1.56827,-.16155,54.45047,-1.88905,-.10357,54.57263,-1.88099,-.09392,54.47146,-1.96246,-.21138,54.36474,-1.88427,-.20984,54.43075,-1.81784,-.42014,54.57038,-1.53143,-.46665,54.57793,-1.54068,-.67014,54.87009,-1.29727,-.6246,54.82151,-1.3431,-.45362,54.97522,-1.2055,-.58281,54.96281,-1.20192,-.5469,55.01419,-1.15852,-.18128,55.01405,-1.00138,-.26508,55.06896,-1.02013,-.26779,55.00843,-.92018,-.28758,55.02185,-.91505,-.35351,55.05077,-.86192,-.38023,55.04469,-.83992,-.33509,55.03141,-.77249,-.2494,55.0165,-.93726,-.19918,54.99148,-.91432,-.12897,55.01492,-1.04961,-.1341,54.99545,-1.00315,-.12005,54.89998,-.70192,-.12128,54.92849,-.77523,-.0721,55.01058,-1.05916,-.09735,55.00993,-1.10372,-.16444,55.02424,-1.08998,-.39248,55.06638,-.91178,-.40781,54.88295,-.7939,-.41384,54.94742,-.79972,-.48725,54.9494,-.79407,-.33195,54.93232,-.76405,-.32588,54.86327,-.76137,-.21494,54.7862,-.68279,-.22044,54.8628,-.696,-.28268,54.86182,-.72157,-.75175,54.88351,-1.12788,-.73184,54.72648,-1.37574,-.77599,54.77127,-1.30885,-.77731,54.78256,-1.18211,-.79131,54.70855,-1.28113,-.76702,54.66032,-1.36457,-.71865,54.5797,-1.45339,-.78189,54.75285,-1.17264,-.78636,54.6782,-1.14199,-.74239,54.66106,-1.12775,-.48331,54.75749,-1.05798,-.49195,54.37985,-1.41516,-.54689,54.43584,-1.36821,-.52536,54.45371,-1.33316,-.48691,54.52584,-1.23149,-.30396,54.52462,-1.16606,-.28184,54.50898,-1.18323,-.27973,54.50462,-1.10888,-.32917,54.56453,-1.10677,-.29699,54.58557,-.81961,-.26606,54.54791,-.84861,-.32318,54.5547,-1.03108,-.32152,54.55265,-1.10297,-.19784,54.49321,-.66393,-.19562,54.44064,-.68441,-.18971,54.43122,-.68255,-.19476,54.58947,-.64808,-.13375,54.58969,-.61514,-.12075,54.65461,-.62321,-.1826,54.64899,-.66824,-.19663,54.71401,-.67979,-.23259,54.70273,-.73303,-.33323,54.63797,-.9189,-.32282,54.60764,-.92581};
			return value;
		}
		private double[] getc3_Coord_9_39_point_4()
		{
			double[] value = {-.63352,54.71356,-1.00659,-.65829,54.69577,-.94441,-.37792,54.69272,-.933,-.37845,54.71485,-.83169,-.39394,54.80044,-.81736,-.46399,54.76451,-.83198,-.57672,54.93994,-.76027,-.64135,54.93435,-.7108,-.57347,54.88389,-.76842,-.64608,54.8866,-.72231,-.91907,54.7094,-1.01381,-.89354,54.76346,-1.0189,-.81705,54.77641,-1.0503,-.79857,54.82808,-1.04586,-.84932,54.82625,-1.01165,-.79752,54.8489,-.9587,-.55093,54.91342,-1.06893,-.60404,54.88849,-1.05274,-.47286,54.76229,-.85412,-.426,54.74979,-.94481,-.38581,54.67543,-1.02076,-.3693,54.78221,-1.47409,-.32311,54.82315,-1.53857,.21434,54.23622,-2.09192,.24619,54.24016,-2.05899,.22055,54.221,-2.06121,.07537,54.36398,-1.80183,0.0,54.36893,-1.83472,.04724,54.26896,-1.98853,.05406,54.27208,-2.01138,.09098,54.23529,-2.06549,.05997,54.29375,-2.03339,.10334,54.26854,-2.08658,.11617,54.24666,-1.90716,.12399,54.26739,-1.86164,.07654,54.25303,-1.95014,.30865,54.42857,-1.6259,.31441,54.42852,-1.62521,.38447,54.40438,-1.52998,.48691,54.52584,-1.23149,.47928,54.53152,-1.23097,.41149,54.42395,-1.32927,.44227,54.3879,-1.38104,.43511,54.38572,-1.38791,.48166,54.37554,-1.42107,.82766,54.63004,-1.25917,.79269,54.68275,-1.15032,.79222,54.67027,-1.14862,.65395,54.43847,-1.47892,.65255,54.4338,-1.47237,.64174,54.43038,-1.48008,.25414,54.40988,-1.70293,.24858,54.41018,-1.70186,.24988,54.40732,-1.70944,.58766,54.44114,-1.38625,.62844,54.44644,-1.40428,.39847,54.57187,-1.5421,.394,54.63701,-1.57951,.452,54.63481,-1.54815,.11826,54.75617,-1.67847,.17708,54.76557,-1.65366,.18667,54.7812,-1.64884,.16069,54.7278,-1.65535,.22608,54.73132,-1.62658,.22998,54.77169,-1.62351,.39439,54.49175,-1.56261,.41601,54.48811,-1.54086,.06026,54.71436,-1.74759,0.0,54.66318,-1.8215,.72335,54.77052,-1.37883,.72372,54.80018,-1.38006,.78125,54.83178,-1.3434,.77511,54.83956,-1.34536,.71917,54.80848,-1.37845,.67985,54.83879,-1.34297,.19524,54.78287,-1.6538,.12462,54.7529,-1.6852,.44059,54.82828,-1.33712,.44662,54.83158,-1.33552,.5214,54.77549,-1.37758,.8005,54.90726,-1.26554,.80518,54.90158,-1.26141,.43856,54.95998,-1.21917,.44262,54.95902,-1.22558,.40971,54.89254,-1.29287,.39567,54.82143,-1.38521,.38808,54.82172,-1.38001,.39654,54.82568,-1.37585,.43983,54.93645,-1.21304,.45217,54.97477,-1.20083,.78353,54.87203,-1.22975,.72816,54.68693,-1.07087,.78455,54.66892,-1.01123,.70726,54.6576,-.98306,.82602,54.60876,-.96617,.8779,54.63796,-.98698,.90658,54.62966,-.9477,.90847,54.64476,-.91834,.87626,54.66828,-.88606,.85359,54.62691,-.90596};
			return value;
		}
		private double[] getc3_Coord_9_39_point_5()
		{
			double[] value = {.70953,54.77417,-.78426,.7409,54.79618,-.80216,.71924,54.80566,-.76022,.90909,54.75357,-.89347,.94518,54.77313,-.95691,.90878,54.83213,-.94695,.80211,54.83158,-.88874,.75866,54.84726,-.91214,.71447,54.8711,-.86266,.71669,54.95096,-.80162,.7192,54.94852,-.78983,.74602,54.86869,-.82328,.68661,54.88619,-.71311,.69066,54.90254,-.71412,.68063,54.89653,-.71065,.60248,54.8435,-1.02911,.66573,54.84564,-.98875,.71176,54.85697,-1.04971,.61119,54.94024,-1.0947,.69861,54.91619,-1.09514,.64388,54.83936,-.87825,.63043,54.80145,-.87148,.55961,54.83736,-.85891,.64547,54.82325,-.98853,.66607,54.80331,-.93285,.692,54.85865,-.94177,.55545,54.88263,-.85543,.57131,54.88292,-.85476,.52355,54.81982,-.80208,.52865,54.76411,-.83291,.59535,54.75201,-.84015,.47718,54.89295,-.9976,.46358,54.83393,-.99828,.485,54.82704,-1.02907,.49499,54.88271,-.86491,.50789,54.93415,-.86115,.0322,54.7165,-1.18241,.46293,54.70026,-1.09289,.50515,54.67251,-1.11287,.53477,54.74425,-1.05593,.48002,54.91534,-1.16053,.42081,54.85887,-1.174,.45998,54.90479,-1.13905,.45951,55.00956,-.88313,.46474,54.94669,-.91586,.44994,54.9606,-.96323,.4315,54.96247,-1.012,.38269,54.94117,-1.08034,.37142,55.0208,-1.06519,.46019,54.92345,-.98211,.46691,54.91824,-1.01282,.45315,54.93771,-1.0313,.51003,54.91663,-1.06094,.48274,54.92818,-1.0874,.46914,54.93113,-1.06309,.50082,54.92958,-1.10432,.23863,55.04623,-1.06331,.27551,55.07889,-1.06881,.26012,55.06112,-1.10833,.35576,54.80481,-1.163,.30666,54.83046,-1.147,.36932,54.8855,-1.12657,.41782,54.92348,-1.10136,.29118,54.74728,-1.56348,.51255,54.62779,-1.18609,.57046,54.62509,-1.15163,.26131,55.01505,-1.15558,.26216,54.96426,-1.15788,.21909,54.94427,-1.16831,.21839,54.91769,-.73005,.23858,54.93585,-.71367,.21779,54.9338,-.74004,.1021,55.00642,-1.12684,.2978,54.53224,-1.17798,.31433,54.61903,-1.16828,.30953,54.54374,-1.15989,.29159,54.59269,-.78227,.29699,54.58557,-.81961,.30051,54.59811,-.81061,.20541,54.85482,-1.17214,.2509,54.8782,-1.1518,.25556,54.78053,-1.15775,.27193,54.68516,-1.18362,.22714,54.63232,-1.19261,.16897,55.01927,-1.12001,.234,55.03301,-1.10912,.23507,55.0124,-1.14386,.27429,54.99546,-.72576,.31617,55.03957,-.78897,.259,54.99529,-.75076,.12124,54.89153,-.68992,.13077,54.85068,-.65537,.26715,54.92119,-.70617,.29274,54.91981,-.71641,.29593,54.97047,-.71541,.24694,54.5759,-.69749,.25627,54.62207,-.7351,.22906,54.63893,-.70959,.31062,54.90753,-1.1325,.21118,54.95836,-.78208};
			return value;
		}
		private double[] getc3_Coord_9_39_point_6()
		{
			double[] value = {.29742,55.02883,-.81518,.2883,55.00237,-.89681,.29157,55.00761,-.8746,.30832,55.01731,-.8945,.13071,54.64549,-1.80837,0.0,54.30568,-1.98101,.03529,54.27804,-1.99237,.10357,54.57263,-1.88099,0.0,54.58135,-1.89207,.26452,54.53412,-1.19592,.43965,54.65445,-1.22013,.39046,54.70015,-1.18437,.39858,54.6802,-1.28079,.41052,54.57918,-1.30145,.37686,54.63096,-1.37496,.33953,54.71592,-1.48382,.33245,54.65751,-1.48014,.36707,54.68917,-1.40749,.06355,54.63954,-1.18207,.14311,54.64061,-1.19345,.14817,54.55307,-1.21004,.06439,54.71646,-1.17456,.03783,54.79829,-1.1805,0.0,54.89303,-1.17219,.08428,54.90036,-1.17145,0.0,54.846,-1.17889,.30992,54.5404,-1.55782,.23869,54.52566,-1.63737,.19183,54.48927,-1.68496,.10241,54.47004,-1.75155,.49306,54.49398,-1.53845,.38238,54.57061,-1.55772,.33872,54.50115,-1.61866,.34323,54.56272,-1.61251,.34971,54.63329,-1.61786,.4564,54.75794,-1.43745,.5317,54.71885,-1.50219,.47123,54.69824,-1.53519,.40401,54.78084,-1.50688,.17243,54.56351,-1.81339,.18542,54.70437,-1.71443,.20711,54.64836,-1.73639,.16307,54.38411,-1.95562,.16155,54.45047,-1.88905,.20984,54.43075,-1.81784,.21138,54.36474,-1.88427,.40954,54.87856,-1.30837,.51724,54.7694,-1.37927,.62243,54.87242,-1.26846,.48637,54.87103,-1.27117,.51441,54.90618,-1.23314,.6246,54.82151,-1.3431,.71659,54.86948,-1.32711,.45362,54.97522,-1.2055,.5469,55.01419,-1.15852,.58281,54.96281,-1.20192,.19918,54.99148,-.91432,.2494,55.0165,-.93726,.18128,55.01405,-1.00138,.1341,54.99545,-1.00315,.12897,55.01492,-1.04961,.12128,54.92849,-.77523,.12005,54.89998,-.70192,.16444,55.02424,-1.08998,.09735,55.00993,-1.10372,.39248,55.06638,-.91178,.39443,55.04183,-.84195,.40781,54.88295,-.7939,.48475,54.87898,-.79906,.48725,54.9494,-.79407,.28268,54.86182,-.72157,.32588,54.86327,-.76137,.22044,54.8628,-.696,.21494,54.7862,-.68279,.25822,54.78249,-.72965,.75175,54.88351,-1.12788,.77599,54.77127,-1.30885,.73184,54.72648,-1.37574,.71865,54.5797,-1.45339,.67554,54.68069,-1.43298,.56735,54.40054,-1.46303,.49328,54.3798,-1.42706,.56942,54.41641,-1.49426,.78189,54.75285,-1.17264,.79131,54.70855,-1.28113,.77731,54.78256,-1.18211,.74239,54.66106,-1.12775,.77024,54.71702,-1.08336,.47878,54.65453,-1.16829,.53241,54.49251,-1.27638,.41934,54.42205,-1.32587,.27973,54.50462,-1.10888,.28184,54.50898,-1.18323,.30396,54.52462,-1.16606,.1301,54.48078,-1.06893,.22132,54.49378,-1.06183,.2211,54.49811,-.96745,.32917,54.56453,-1.10677,.33579,54.60405,-1.14743,.25087,54.5162,-.78142};
			return value;
		}
		private double[] getc3_Coord_9_39_point_7()
		{
			double[] value = {.27724,54.55982,-.75472,.24276,54.50067,-.71743,.32152,54.55265,-1.10297,.32318,54.5547,-1.03108,.19784,54.49321,-.66393,.13725,54.50229,-.62794,.14146,54.43077,-.64684,.27728,54.56978,-.7449,.24224,54.50891,-.70603,.12075,54.65461,-.62321,.13375,54.58969,-.61514,.19476,54.58947,-.64808,.23259,54.70273,-.73303,.19663,54.71401,-.67979,.1826,54.64899,-.66824,.29407,54.68838,-.78145,.32282,54.60764,-.92581,.33323,54.63797,-.9189,.65829,54.69577,-.94441,.63352,54.71356,-1.00659,.37845,54.71485,-.83169,.37792,54.69272,-.933,.46399,54.76451,-.83198,.39394,54.80044,-.81736,.57347,54.88389,-.76842,.64135,54.93435,-.7108,.57672,54.93994,-.76027,.64608,54.8866,-.72231,.91907,54.7094,-1.01381,.83136,54.72997,-1.04014,.81705,54.77641,-1.0503,.79752,54.8489,-.9587,.84932,54.82625,-1.01165,.79857,54.82808,-1.04586,.60404,54.88849,-1.05274,.55093,54.91342,-1.06893,.426,54.74979,-.94481,.47286,54.76229,-.85412,.3693,54.78221,-1.47409,.36991,54.8203,-1.45469,.32311,54.82315,-1.53857,.33839,54.71752,-1.17059,.32111,54.76142,-1.16888,.3913,54.84081,-1.31014,.39353,54.86853,-1.3022,.24209,54.80322,-1.61497,.30163,54.78606,-1.5634,.43,54.74453,-1.0189,.46293,54.904,-.93249,.68573,54.91909,-.84564,.68163,54.98241,-.78756,.67825,54.98173,-.76821,.74436,54.80954,-.80404,.80082,54.79141,-.8536,.96482,54.70806,-.95851,.7788,54.78308,-1.10068,.8964,54.71371,-.88147,.78882,54.69922,-.85048,.71296,54.81146,-.75386,.69678,54.81153,-.75833,.5782,54.82187,-.79077,.65273,54.80694,-.77734,.47211,54.81402,-.81473,.7452,54.67552,-.8915,.84327,54.60885,-.92977,.58623,54.731,-1.05388,.57816,54.6292,-1.14335,.68997,54.64165,-1.11129,.12736,54.72531,-.6296,.06489,54.65635,-.60178,.06677,54.58708,-.60117,.19562,54.44064,-.68441,.23476,54.49746,-.7007,.3157,54.59481,-.9249,.27477,54.5425,-.94499,.23482,54.49072,-.71265,.19492,54.43265,-.69547,.19292,54.4435,-.74566,.26606,54.54791,-.84861,.19214,54.46786,-.8081,.27317,54.5196,-1.04171,.13371,54.39667,-.77183,.13244,54.37708,-.68495,.18971,54.43122,-.68255,.68451,54.58531,-1.18891,.60877,54.55935,-1.2195,.6336,54.53535,-1.27327,.44472,54.55269,-1.26556,.76319,54.8256,-1.10605,.75518,54.48675,-1.43979,.64619,54.53476,-1.50158,.48278,54.40522,-1.50372,.77249,54.83798,-1.20293,.66282,54.7796,-1.40393,.43406,55.01818,-.93399,.36187,55.08938,-.96843,.34646,55.00629,-1.10435,.33178,55.09813,-1.03948,.44289,54.90796,-1.122,.05261,54.89726,-.68475};
			return value;
		}
		private double[] getc3_Coord_9_39_point_8()
		{
			double[] value = {.05231,54.9185,-.76796,.24521,54.99481,-.90637,.27288,54.99084,-.87446,.33509,55.03141,-.77249,.28551,55.06069,-.94839,.70132,54.99873,-1.13407,.77784,54.96295,-1.1775,.70242,54.93641,-1.23919,.63534,55.01832,-1.12697,.50664,54.82484,-1.3147,.65521,54.78685,-1.40058,.66199,54.94723,-1.20986,.59757,54.62382,-1.51505,.5106,54.58661,-1.54138,.30641,54.61799,-1.6657,.28853,54.71251,-1.65842,.33522,54.78305,-1.57969,.32818,54.82179,-1.54253,.41253,54.72237,-1.56827,.43736,54.60203,-1.54406,.42014,54.57038,-1.53143,.2393,54.53348,-1.74356,.25073,54.4565,-1.7302,.46665,54.57793,-1.54068,.41936,54.52868,-1.54042,.05013,54.29607,-1.8835,.07429,54.35682,-1.81269,.27932,54.42212,-1.66282,.37719,54.42694,-1.41083,.41475,54.41577,-1.33996,.37453,54.50153,-1.39047,.14019,54.47349,-1.21683,.07073,54.47229,-1.20723,.06946,54.55881,-1.21223,.37013,54.72433,-1.31116,.35862,54.73413,-1.21821,.27985,54.51685,-1.19111,.09392,54.47146,-1.96246,.16779,54.34026,-1.99331,.13794,54.74639,-1.69479,.34188,54.92495,-1.11113,.31261,54.98766,-1.14566,.41768,54.98855,-.80344,.41384,54.94742,-.79972,.25385,55.02326,-1.1485,0.0,54.46706,-1.20009,0.0,54.48204,-1.20597,.36222,54.68722,-1.14813,.38023,55.04469,-.83992,.39103,55.03782,-.83403,.28709,55.05651,-1.13562,.3396,55.01926,-.76743,.29074,54.98391,-.71796,.23825,55.00169,-1.1523,.382,54.67869,-1.11415,.39237,54.67787,-1.08048,.35235,54.75067,-1.48309,.36871,54.75293,-1.41072,.3842,54.78844,-1.39364,.54501,54.93946,-1.11976,.41811,54.8973,-1.20885,.29796,55.04915,-1.14024,.31675,55.07332,-1.09177,.39091,54.85485,-1.15115,.37096,54.81007,-1.1884,.38581,54.67543,-1.02076,.51041,54.8167,-1.04169,.45665,54.75101,-1.03844,.53096,54.88155,-.78571,.53354,54.76465,-.85017,.75485,54.85737,-1.00268,.56593,54.8616,-1.0323,.68607,54.65683,-1.05838,.80762,54.82158,-.87941,.58653,54.9652,-.79156,.59023,54.96365,-.80319,.66269,54.86899,-.87274,.89354,54.76346,-1.0189,.89785,54.8431,-.96731,.95325,54.67504,-.9762,.96048,54.67794,-.95655,.40193,54.89063,-1.29092,.24379,54.8025,-1.61965,.6523,54.77636,-1.40539,.1518,54.61578,-1.67311,.21799,54.61947,-1.6327,.21976,54.69992,-1.6324,.42921,54.38539,-1.47557,.78636,54.6782,-1.14199,.69233,54.63155,-1.11824,.58088,54.61811,-1.14824,.19961,54.30929,-2.04651,.20594,54.32902,-1.95016,.18932,54.25453,-2.11825,.18342,54.24145,-2.11141,.13826,54.25454,-2.11372,.05796,54.28717,-1.89235,.03963,54.28751,-2.01234,.08052,54.35339,-1.80585,.06005,54.29091,-1.88123};
			return value;
		}
		private double[] getc3_Coord_9_39_point_9()
		{
			double[] value = {.15305,54.35504,-1.7605,.15378,54.34963,-1.7711,.04036,54.32457,-2.03773,.06105,54.38005,-2.03629,.08748,54.33217,-2.04562,.22521,54.26117,-2.09534,.17752,54.22838,-2.10457,-.26131,55.01505,-1.15558,-.31261,54.98766,-1.14566,-.32111,54.76142,-1.16888,-.39353,54.86853,-1.3022,-.3913,54.84081,-1.31014,-.36991,54.8203,-1.45469,-.24209,54.80322,-1.61497,-.44436,54.82944,-.94093,-.46358,54.83393,-.99828,-.58186,54.92203,-.84165,-.66269,54.86899,-.87274,-.46293,54.904,-.93249,-.68163,54.98241,-.78756,-.68573,54.91909,-.84564,-.67825,54.98173,-.76821,-.80762,54.82158,-.87941,-.80082,54.79141,-.8536,-.74436,54.80954,-.80404,-.96482,54.70806,-.95851,-.83136,54.72997,-1.04014,-.7788,54.78308,-1.10068,-.78882,54.69922,-.85048,-.79653,54.77838,-.84902,-.8964,54.71371,-.88147,-.71296,54.81146,-.75386,-.5782,54.82187,-.79077,-.29407,54.68838,-.78145,-.7452,54.67552,-.8915,-.68997,54.64165,-1.11129,-.58623,54.731,-1.05388,-.68607,54.65683,-1.05838,-.12736,54.72531,-.6296,-.13009,54.78862,-.63854,-.06677,54.58708,-.60117,-.06489,54.65635,-.60178,-.27317,54.5196,-1.04171,-.27477,54.5425,-.94499,-.3157,54.59481,-.9249,-.19214,54.46786,-.8081,-.25087,54.5162,-.78142,-.22132,54.49378,-1.06183,-.3311,54.56654,-1.03325,-.13371,54.39667,-.77183,-.19292,54.4435,-.74566,-.14146,54.43077,-.64684,-.13244,54.37708,-.68495,-.6336,54.53535,-1.27327,-.60877,54.55935,-1.2195,-.68451,54.58531,-1.18891,-.43965,54.65445,-1.22013,-.44472,54.55269,-1.26556,-.76319,54.8256,-1.10605,-.75518,54.48675,-1.43979,-.64619,54.53476,-1.50158,-.56942,54.41641,-1.49426,-.59757,54.62382,-1.51505,-.77596,54.80499,-1.32675,-.77249,54.83798,-1.20293,-.66282,54.7796,-1.40393,-.67554,54.68069,-1.43298,-.69608,54.956,-1.11931,-.41768,54.98855,-.80344,-.39103,55.03782,-.83403,-.45539,55.00916,-.83837,-.40729,55.01442,-.99037,-.33178,55.09813,-1.03948,-.31675,55.07332,-1.09177,-.27288,54.99084,-.87446,-.28551,55.06069,-.94839,-.77784,54.96295,-1.1775,-.70132,54.99873,-1.13407,-.66199,54.94723,-1.20986,-.63534,55.01832,-1.12697,-.50664,54.82484,-1.3147,-.5214,54.77549,-1.37758,-.65521,54.78685,-1.40058,-.67985,54.83879,-1.34297,-.70242,54.93641,-1.23919,-.28853,54.71251,-1.65842,-.30641,54.61799,-1.6657,-.37707,54.81928,-1.4568,-.32818,54.82179,-1.54253,-.6523,54.77636,-1.40539,-.33522,54.78305,-1.57969,-.33872,54.50115,-1.61866,-.15378,54.34963,-1.7711,-.20895,54.35129,-1.79523,-.21425,54.31475,-1.86174,0.0,54.43726,-1.79491,-.24858,54.41018,-1.70186,-.38942,54.45535,-1.36299,-.20541,54.85482,-1.17214,-.14339,54.80508,-1.16904};
			return value;
		}
		private double[] getc3_Coord_9_39_point_10()
		{
			double[] value = {-.07073,54.47229,-1.20723,-.36222,54.68722,-1.14813,-.382,54.67869,-1.11415,-.37013,54.72433,-1.31116,-.13071,54.64549,-1.80837,-.16307,54.38411,-1.95562,-.13794,54.74639,-1.69479,-.06026,54.71436,-1.74759,-.18542,54.70437,-1.71443,-.24521,54.99481,-.90637,-.32539,55.03648,-.89059,-.34646,55.00629,-1.10435,-.35576,54.80481,-1.163,-.25385,55.02326,-1.1485,-.28332,55.05716,-1.13181,-.06996,54.4641,-1.1991,-.22797,54.53394,-1.20573,-.29419,55.04979,-1.13643,-.39443,55.04183,-.84195,-.38037,55.07068,-.90787,-.29074,54.98391,-.71796,-.29118,54.74728,-1.56348,-.35235,54.75067,-1.48309,-.3842,54.78844,-1.39364,-.37793,54.78749,-1.31536,-.50082,54.92958,-1.10432,-.54501,54.93946,-1.11976,-.41811,54.8973,-1.20885,-.36564,54.74916,-1.31741,-.36305,54.75602,-1.21741,-.34613,54.75735,-1.17745,-.46474,54.94669,-.91586,-.37096,54.81007,-1.1884,-.485,54.82704,-1.02907,-.53096,54.88155,-.78571,-.66607,54.80331,-.93285,-.692,54.85865,-.94177,-.75485,54.85737,-1.00268,-.56593,54.8616,-1.0323,-.74602,54.86869,-.82328,-.80211,54.83158,-.88874,-.58653,54.9652,-.79156,-.89785,54.8431,-.96731,-.96048,54.67794,-.95655,-.95325,54.67504,-.9762,-.40954,54.87856,-1.30837,-.24379,54.8025,-1.61965,-.21976,54.69992,-1.6324,-.1518,54.61578,-1.67311,-.15309,54.69558,-1.65925,-.64174,54.43038,-1.48008,-.56735,54.40054,-1.46303,-.42921,54.38539,-1.47557,-.79269,54.68275,-1.15032,-.69233,54.63155,-1.11824,-.20594,54.32902,-1.95016,-.23758,54.30932,-2.00574,-.18932,54.25453,-2.11825,-.15122,54.27554,-2.11912,-.13826,54.25454,-2.11372,-.04724,54.26896,-1.98853,-.08052,54.35339,-1.80585,-.22521,54.26117,-2.09534,-.17752,54.22838,-2.10457,-.18342,54.24145,-2.11141,-.03963,54.28751,-2.01234,-.19961,54.30929,-2.04651,-.49328,54.3798,-1.42706,-.41936,54.52868,-1.54042,-.452,54.63481,-1.54815,-.5106,54.58661,-1.54138,-.41601,54.48811,-1.54086,-.27932,54.42212,-1.66282,-.93431,54.77098,-.97979,-.59023,54.96365,-.80319,-.72187,54.81935,-.75939,-.64547,54.82325,-.98853,-.51041,54.8167,-1.04169,-.38617,54.81534,-1.21381,-.36871,54.75293,-1.41072,-.34136,54.6167,-1.1009,-.3396,55.01926,-.76743,-.49164,54.96043,-.79964,-.27985,54.51685,-1.19111,-.14019,54.47349,-1.21683,-.13974,54.71984,-1.17726,-.37453,54.50153,-1.39047,-.39439,54.49175,-1.56261,-.25073,54.4565,-1.7302,-.2393,54.53348,-1.74356,-.35285,54.72138,-1.61555,-.73193,54.89815,-1.29452,-.54625,54.81065,-1.33531,-.36187,55.08938,-.96843,-.76614,54.92146,-1.15651,-.65395,54.43847,-1.47892,-.72519,54.59753,-1.19884,-.13471,54.44611,-.82965,-.34237,54.62414,-1.01568,-.2211,54.49811,-.96745};
			return value;
		}
		private double[] getc3_Coord_9_39_point_11()
		{
			double[] value = {-.21329,54.4922,-.89871,-.19492,54.43265,-.69547,-.23482,54.49072,-.71265,-.23476,54.49746,-.7007,-.84327,54.60885,-.92977,-.47211,54.81402,-.81473,-.65273,54.80694,-.77734,-.69678,54.81153,-.75833,-.78066,54.74644,-1.09125,-.64713,54.94546,-.71349,.19653,54.21913,-2.07998,.15122,54.27554,-2.11912,.23758,54.30932,-2.00574,.49195,54.37985,-1.41516,.33873,54.45474,-1.52065,.35955,54.41014,-1.52858,.15309,54.69558,-1.65925,.93431,54.77098,-.97979,.73598,54.87606,-.84502,.72187,54.81935,-.75939,.48331,54.75749,-1.05798,.34613,54.75735,-1.17745,.38617,54.81534,-1.21381,.37793,54.78749,-1.31536,.28751,54.71146,-1.56545,.34136,54.6167,-1.1009,.38942,54.45535,-1.36299,.22797,54.53394,-1.20573,.06996,54.4641,-1.1991,.49164,54.96043,-.79964,.28758,55.02185,-.91505,.26779,55.00843,-.92018,.35285,54.72138,-1.61555,.37707,54.81928,-1.4568,.54625,54.81065,-1.33531,.26508,55.06896,-1.02013,.40729,55.01442,-.99037,.77596,54.80499,-1.32675,.76702,54.66032,-1.36457,.52536,54.45371,-1.33316,.72519,54.59753,-1.19884,.13471,54.44611,-.82965,.34237,54.62414,-1.01568,.3311,54.56654,-1.03325,.21329,54.4922,-.89871,.13009,54.78862,-.63854,.66802,54.73998,-.82323,.79653,54.77838,-.84902,.78066,54.74644,-1.09125,.64713,54.94546,-.71349,.44436,54.82944,-.94093,.88414,54.84779,-.9568,.29202,54.58312,-.79165,.1337,54.47404,-.99003,.74302,54.65095,-1.1341,.68717,54.48602,-1.38095,.33195,54.93232,-.76405,.34892,55.02465,-.77171,.0721,55.01058,-1.05916,.25294,54.98181,-.8468,.20161,54.97792,-.85812,.67014,54.87009,-1.29727,.27286,54.57573,-1.70463,.2712,54.54054,-1.70127,.07566,54.79822,-1.17094,.35855,54.7247,-1.41197,.028,54.40435,-2.02718,.35351,55.05077,-.86192,.35288,55.06356,-.89513,.32539,55.03648,-.89059,.1743,55.00289,-1.13678,.20446,54.7306,-1.1685,.10628,54.99586,-1.13847,.48726,54.91137,-1.04355,0.0,54.79836,-1.19006,.55746,54.92307,-.84291,.45539,55.00916,-.83837,.48254,54.83131,-.86138,.50166,54.88435,-1.02477,.61146,54.74797,-.86192,.47079,54.94547,-1.18889,.09898,54.7231,-1.68077,.57086,54.40166,-1.4534,.82452,54.62327,-1.25533,-.88414,54.84779,-.9568,-.24224,54.50891,-.70603,-.27728,54.56978,-.7449,-.24276,54.50067,-.71743,-.27724,54.55982,-.75472,-.74302,54.65095,-1.1341,-.53241,54.49251,-1.27638,-.72943,54.57011,-1.26021,-.72363,54.53477,-1.32601,-.47878,54.65453,-1.16829,-.77024,54.71702,-1.08336,-.25822,54.78249,-.72965,-.48475,54.87898,-.79906,-.34892,55.02465,-.77171,-.20161,54.97792,-.85812,-.25294,54.98181,-.8468};
			return value;
		}
		private double[] getc3_Coord_9_39_point_12()
		{
			double[] value = {-.51441,54.90618,-1.23314,-.48637,54.87103,-1.27117,-.17243,54.56351,-1.81339,-.394,54.63701,-1.57951,-.2712,54.54054,-1.70127,-.27286,54.57573,-1.70463,-.03783,54.79829,-1.1805,-.07566,54.79822,-1.17094,-.08428,54.90036,-1.17145,-.06355,54.63954,-1.18207,-.06439,54.71646,-1.17456,-.35855,54.7247,-1.41197,-.35288,55.06356,-.89513,-.1743,55.00289,-1.13678,-.10628,54.99586,-1.13847,-.51003,54.91663,-1.06094,-.55746,54.92307,-.84291,-.63043,54.80145,-.87148,-.47079,54.94547,-1.18889,-.18667,54.7812,-1.64884,-.65255,54.4338,-1.47237,-.24988,54.40732,-1.70944,-.25414,54.40988,-1.70293,-.10334,54.26854,-2.08658,-.24619,54.24016,-2.05899,-.12526,54.22071,-2.02266,-.12881,54.22774,-2.09601,-.18814,54.20977,-2.02547,-.15675,54.21223,-2.06071,-.24111,54.27708,-1.97717,-.16403,54.21883,-1.98074,-.25001,54.25594,-2.01984,-.20614,54.29451,-1.91097,-.80931,54.55796,-1.34308,-.7529,54.48184,-1.43544,-.8115,54.56302,-1.34788,-.28442,54.42113,-1.66558,-.27469,54.47357,-1.69909,-.29864,54.49063,-1.66799,-.30309,54.54761,-1.65899,-.26279,54.76788,-1.63642,-.62243,54.87242,-1.26846,-.70328,54.99599,-1.12744,-.78073,54.95932,-1.17101,-.82038,54.70146,-1.03439,-.91945,54.67899,-1.0073,-.5318,54.94146,-.78286,-.53513,54.95283,-.78805,-.54871,54.96199,-.81398,-.54411,54.96362,-.80352,-.50542,54.97133,-.81826,-.50927,54.9686,-.82833,-.55007,54.80252,-1.04192,-.47718,54.89295,-.9976,-.50166,54.88435,-1.02477,-.5476,54.97523,-1.14528,-.62618,54.97764,-1.11631,-.42695,54.69558,-1.14096,0.0,54.8945,-.67654,-.05343,54.88952,-.67255,0.0,54.88636,-.66498,-.05261,54.89726,-.68475,-.35068,55.09394,-.96409,-.17683,54.9907,-1.14443,-.22348,54.48404,-1.21062,-.05919,54.37737,-.67023,0.0,54.43389,-.62725,-.07241,54.43524,-.62391,0.0,54.3786,-.67445,-.0592,54.37088,-.71501,-.13379,54.3734,-.71645,-.29089,55.09667,-1.02929,-.31796,55.08775,-.95317,-.22144,54.74721,-1.6727,0.0,54.56086,-1.2102,0.0,54.65223,-1.18369,-.34589,54.58294,-1.45279,-.09115,54.69166,-1.68447,-.08572,54.61041,-1.70842,-.20711,54.64836,-1.73639,-.24782,54.68044,-1.6974,-.30569,55.07951,-1.08831,-.32052,55.10315,-1.03718,-.07167,54.98768,-1.00034,-.13401,54.96466,-.92299,-.06407,54.95928,-.92288,-.05938,54.84604,-.63744,-.05838,54.93962,-.85018,0.0,54.95446,-.92526,0.0,54.93541,-.84515,0.0,54.7875,-.61458,-.0618,54.78723,-.61882,0.0,54.84725,-.63457,-.68717,54.48602,-1.38095,-.1337,54.47404,-.99003,-.1301,54.48078,-1.06893,-.06763,54.44255,-.83507,-.06765,54.39163,-.78292,0.0,54.39064,-.78433,0.0,54.36999,-.71913};
			return value;
		}
		private double[] getc3_Coord_9_39_point_13()
		{
			double[] value = {0.0,54.482,-1.08627,-.05869,54.46722,-1.00181,-.06252,54.4761,-1.08009,0.0,54.47195,-1.00782,-.0637,54.46362,-1.1451,0.0,54.46757,-1.1445,-.06657,54.50118,-.60954,-.13725,54.50229,-.62794,-.06372,54.73315,-.6096,-.58083,54.95102,-.76464,0.0,54.69145,-1.70181,0.0,54.31764,-2.0069,.15675,54.21223,-2.06071,.12881,54.22774,-2.09601,.21586,54.29134,-2.08024,.25001,54.25594,-2.01984,.24425,54.25791,-2.07472,.24656,54.28745,-2.04776,.11992,54.2907,-2.095,.20614,54.29451,-1.91097,.24111,54.27708,-1.97717,.39688,54.39795,-1.44334,.29864,54.49063,-1.66799,.28442,54.42113,-1.66558,.22144,54.74721,-1.6727,.24782,54.68044,-1.6974,.26279,54.76788,-1.63642,.70328,54.99599,-1.12744,.78073,54.95932,-1.17101,.69608,54.956,-1.11931,.76614,54.92146,-1.15651,.82038,54.70146,-1.03439,.91945,54.67899,-1.0073,.5318,54.94146,-.78286,.53513,54.95283,-.78805,.54871,54.96199,-.81398,.54411,54.96362,-.80352,.59408,54.78685,-1.0393,.63747,54.76821,-.99524,.50542,54.97133,-.81826,.50927,54.9686,-.82833,.55007,54.80252,-1.04192,.36305,54.75602,-1.21741,.5476,54.97523,-1.14528,.62618,54.97764,-1.11631,.42695,54.69558,-1.14096,.05343,54.88952,-.67255,.38037,55.07068,-.90787,.35068,55.09394,-.96409,.17683,54.9907,-1.14443,.22348,54.48404,-1.21062,.05919,54.37737,-.67023,.07241,54.43524,-.62391,.0592,54.37088,-.71501,.13379,54.3734,-.71645,.29089,55.09667,-1.02929,.31796,55.08775,-.95317,.29349,54.62319,-1.5693,.65994,54.74972,-.93878,.13974,54.71984,-1.17726,.14339,54.80508,-1.16904,.34589,54.58294,-1.45279,.08572,54.61041,-1.70842,0.0,54.55391,-1.74865,.09115,54.69166,-1.68447,.20895,54.35129,-1.79523,.21425,54.31475,-1.86174,.27469,54.47357,-1.69909,.13401,54.96466,-.92299,.07167,54.98768,-1.00034,.06407,54.95928,-.92288,.05938,54.84604,-.63744,.05838,54.93962,-.85018,.0618,54.78723,-.61882,.72363,54.53477,-1.32601,.72943,54.57011,-1.26021,.7529,54.48184,-1.43544,.80931,54.55796,-1.34308,.54689,54.43584,-1.36821,.06012,54.457,-.92127,.05869,54.46722,-1.00181,.13435,54.46399,-.91158,0.0,54.44417,-.84302,.06763,54.44255,-.83507,0.0,54.46112,-.92838,.0637,54.46362,-1.1451,.13249,54.4674,-1.14964,.06252,54.4761,-1.08009,.13931,54.46637,-1.20986,.21834,54.47397,-1.14193,.22507,54.47648,-1.20314,.06657,54.50118,-.60954,0.0,54.50082,-.60693,0.0,54.65505,-.59493,0.0,54.58337,-.59664,.06372,54.73315,-.6096,.58083,54.95102,-.76464,.52937,54.87969,-1.03548,.31077,54.77765,-.77566,.06765,54.39163,-.78292};
			return value;
		}
		private double[] getc3_Coord_9_39_point_14()
		{
			double[] value = {0.0,54.91834,-.76364,0.0,54.99992,-1.06566,.13244,54.95428,-.8587,.32052,55.10315,-1.03718,.73193,54.89815,-1.29452,.15073,54.9136,-1.16414,0.0,54.34274,-2.02972,.36564,54.74916,-1.31741,.30569,55.07951,-1.08831,.58186,54.92203,-.84165,.5443,55.01286,-1.153,.63374,55.01689,-1.1207,.30309,54.54761,-1.65899,.16403,54.21883,-1.98074,.12526,54.22071,-2.02266,.18814,54.20977,-2.02547,-.52937,54.87969,-1.03548,-.59408,54.78685,-1.0393,-.31077,54.77765,-.77566,0.0,54.73696,-.60499,-.13249,54.4674,-1.14964,-.13931,54.46637,-1.20986,-.05231,54.9185,-.76796,-.13244,54.95428,-.8587,-.15073,54.9136,-1.16414,-.22507,54.47648,-1.20314,-.10627,54.9835,-1.14617,-.63747,54.76821,-.99524,-.5443,55.01286,-1.153,-.63374,55.01689,-1.1207,-.24656,54.28745,-2.04776,-.21586,54.29134,-2.08024,-.24425,54.25791,-2.07472,-.95553,54.70221,-.98274,-.65994,54.74972,-.93878,-.53354,54.76465,-.85017,0.0,54.9748,-1.1512,0.0,54.97937,-.99405,-.13435,54.46399,-.91158,-.06012,54.457,-.92127,-.21834,54.47397,-1.14193,.8115,54.56302,-1.34788,.95553,54.70221,-.98274,.10627,54.9835,-1.14617};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc3disc_Geo_8_44_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,0,15,7,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,37,53,-1,54,55,56,-1,43,57,58,-1,59,60,49,-1,61,50,56,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,4,-1,73,74,75,-1,76,77,78,-1,79,77,80,-1,81,82,83,-1,84,85,79,-1,86,87,88,-1,10,89,90,-1,91,92,93,-1,93,92,6,-1,94,95,96,-1,97,98,11,-1,61,67,66,-1,99,100,101,-1,102,69,68,-1,38,103,72,-1,44,104,105,-1,44,42,104,-1,41,106,107,-1,26,108,109,-1,39,38,71,-1,108,26,22,-1,110,111,19,-1,55,112,67,-1,113,114,115,-1,116,117,98,-1,92,7,6,-1,93,118,119,-1,120,121,116,-1,122,123,87,-1,108,88,124,-1,125,126,110,-1,127,128,129,-1,14,130,115,-1,131,132,133,-1,80,134,135,-1,81,136,137,-1,83,138,139,-1,140,135,134,-1,141,74,71,-1,142,143,56,-1,47,144,43,-1,145,146,46,-1,147,64,148,-1,46,146,149,-1,149,103,38,-1,53,39,150,-1,151,102,152,-1,153,154,155,-1,29,28,156,-1,157,114,34,-1,158,159,160,-1,35,113,161,-1,156,162,20,-1,163,34,158,-1,164,31,33,-1,22,26,25,-1,16,165,17,-1,99,166,100,-1,9,167,10,-1,168,169,170,-1,94,6,124,-1,171,3,172,-1,105,104,173,-1,173,172,105,-1,3,5,172,-1,6,8,124,-1,173,171,172,-1,34,163,157,-1,165,21,17,-1,22,25,23,-1,164,174,31,-1,175,176,18,-1,20,24,156,-1,23,25,177,-1,35,114,113,-1,114,35,34,-1,156,177,29,-1,153,155,101,-1,178,151,152,-1,179,53,150,-1,37,149,38,-1,147,62,64,-1,43,48,47,-1,142,56,50,-1,180,67,112,-1,74,73,71,-1,140,134,181,-1,182,83,139,-1,83,3,138,-1,82,183,184,-1,135,84,80,-1,133,185,131,-1,14,186,130,-1,128,9,129,-1,126,111,110,-1,124,109,108,-1,122,87,86,-1,187,15,2,-1,116,97,120,-1,93,96,118,-1,98,97,116,-1,130,113,115,-1,61,55,67,-1,153,101,100,-1,19,165,110,-1,86,108,22,-1,39,71,73,-1,109,27,26,-1,42,41,107,-1,42,107,104,-1,105,45,44,-1,38,72,71,-1,150,39,73,-1,73,75,150,-1,68,152,102,-1,99,101,188,-1,66,189,61,-1,18,113,175,-1,97,11,90,-1,190,191,118,-1,91,93,192,-1,90,11,10,-1,88,108,86,-1,115,132,131,-1,79,80,84,-1,3,171,138,-1,83,193,81,-1,79,78,77,-1,76,78,194,-1,105,172,195,-1,74,196,75,-1,4,141,71,-1,68,70,197,-1,67,180,65,-1,62,52,63,-1,56,55,61,-1,43,144,57,-1,54,100,55,-1,48,145,46,-1,48,43,45,-1,58,40,42,-1,53,37,39,-1,61,51,50,-1,34,36,198,-1,31,199,32,-1,200,201,202,-1,30,203,28,-1,27,204,25,-1,205,22,24,-1,165,19,21,-1,176,16,18,-1,206,207,140,-1,11,129,9,-1,7,15,8,-1,3,184,4,-1,0,2,15,-1,14,89,186,-1,13,89,14,-1,197,85,84,-1,85,197,70,-1,141,137,74,-1,183,137,141,-1,87,191,190,-1,191,87,123,-1,195,208,209,-1,195,210,208,-1,174,211,31,-1,174,212,211,-1,213,198,214,-1,198,213,159,-1,32,202,33,-1,200,202,32,-1,164,202,215,-1,164,33,202,-1,30,201,200,-1,29,201,30,-1,204,201,29,-1,23,156,24,-1,23,177,156,-1,216,217,162,-1,216,36,217,-1,40,218,211,-1,40,219,218,-1,220,221,222,-1,223,221,220,-1,224,225,226,-1,225,224,221,-1,226,159,213,-1,160,159,226,-1,214,28,203,-1,214,216,28,-1,155,178,152,-1,154,178,155,-1,142,227,228,-1,60,227,142,-1,62,37,52,-1,62,149,37,-1,153,54,154,-1,100,54,153,-1,61,229,51,-1,61,189,229,-1,230,231,232,-1,223,231,230,-1,233,234,232,-1,233,59,234,-1,228,143,142,-1,228,235,143,-1,236,112,166,-1,112,236,169,-1,107,173,104,-1,237,173,107,-1,139,171,173,-1,139,138,171,-1,194,238,239,-1,240,238,194,-1,106,237,107,-1,106,241,237,-1,242,239,238,-1,243,239,242,-1,76,244,77,-1,244,76,245,-1,170,134,244,-1,181,134,170,-1};
			return value;
		}
		private int[] getc3disc_Geo_8_44_coordIndex_2()
		{
			int[] value = {81,183,82,-1,81,137,183,-1,116,191,117,-1,116,118,191,-1,12,115,131,-1,12,14,115,-1,127,125,110,-1,129,125,127,-1,246,9,128,-1,9,246,167,-1,247,119,121,-1,248,119,247,-1,249,248,250,-1,248,249,192,-1,251,252,253,-1,241,252,251,-1,254,255,256,-1,243,255,254,-1,257,258,185,-1,257,259,258,-1,120,90,260,-1,90,120,97,-1,157,115,114,-1,115,157,132,-1,176,127,16,-1,128,127,176,-1,68,155,152,-1,155,68,261,-1,122,22,205,-1,122,86,22,-1,27,262,263,-1,27,109,262,-1,2,174,164,-1,2,1,174,-1,1,212,174,-1,1,264,212,-1,215,2,164,-1,187,2,215,-1,205,111,122,-1,111,205,19,-1,261,101,155,-1,101,261,188,-1,66,265,189,-1,265,66,266,-1,267,132,157,-1,132,267,133,-1,268,185,258,-1,185,268,131,-1,259,256,258,-1,259,254,256,-1,251,249,269,-1,251,253,249,-1,91,249,253,-1,192,249,91,-1,247,120,270,-1,247,121,120,-1,7,91,0,-1,7,92,91,-1,0,264,1,-1,264,0,252,-1,82,3,83,-1,82,184,3,-1,78,81,193,-1,81,78,79,-1,180,244,245,-1,168,244,180,-1,168,170,244,-1,76,271,245,-1,76,272,271,-1,269,238,273,-1,242,238,269,-1,274,173,237,-1,173,274,139,-1,272,194,239,-1,194,272,76,-1,5,72,210,-1,5,4,72,-1,172,210,195,-1,172,5,210,-1,166,206,236,-1,166,99,206,-1,112,168,180,-1,112,169,168,-1,65,266,66,-1,266,65,257,-1,275,276,277,-1,275,278,276,-1,279,144,277,-1,57,144,279,-1,51,59,49,-1,229,59,51,-1,234,59,229,-1,280,232,234,-1,230,232,280,-1,265,229,189,-1,229,265,281,-1,282,178,283,-1,282,151,178,-1,209,48,45,-1,209,145,48,-1,275,46,147,-1,275,47,46,-1,50,60,142,-1,49,60,50,-1,36,214,198,-1,36,216,214,-1,284,226,225,-1,284,160,226,-1,221,230,225,-1,230,221,223,-1,211,199,31,-1,211,218,199,-1,156,216,162,-1,28,216,156,-1,161,18,17,-1,18,161,113,-1,25,29,177,-1,25,204,29,-1,200,285,30,-1,200,32,285,-1,159,34,198,-1,34,159,158,-1,20,205,24,-1,19,205,20,-1,117,123,126,-1,117,191,123,-1,190,88,87,-1,190,95,88,-1,136,74,137,-1,136,196,74,-1,135,207,286,-1,135,140,207,-1,181,169,236,-1,181,170,169,-1,84,286,197,-1,84,135,286,-1,4,183,141,-1,184,183,4,-1,117,125,98,-1,117,126,125,-1,186,10,167,-1,89,10,186,-1,146,209,208,-1,145,209,146,-1,212,40,211,-1,212,41,40,-1,213,203,287,-1,214,203,213,-1,17,217,161,-1,21,217,17,-1,32,288,285,-1,32,199,288,-1,289,157,163,-1,289,267,157,-1,284,281,289,-1,281,284,280,-1,222,219,220,-1,222,218,219,-1,224,222,221,-1,224,288,222,-1,224,213,287,-1,226,213,224,-1,58,44,43,-1,58,42,44,-1,148,227,278,-1,227,148,228,-1,208,149,146,-1,208,103,149,-1,54,143,283,-1,54,56,143,-1,149,147,46,-1,149,62,147,-1,63,53,179,-1,63,52,53,-1,283,235,282,-1,283,143,235,-1,57,40,58,-1,57,219,40,-1,231,220,279,-1,220,231,223,-1,232,276,233,-1,231,276,232,-1,60,233,227,-1,233,60,59,-1,64,228,148,-1,64,235,228,-1,136,79,85,-1,136,81,79,-1,197,261,68,-1,261,197,286,-1,207,99,188,-1,207,206,99,-1,193,194,78,-1,194,193,240,-1,240,273,238,-1,182,273,240,-1,237,251,274,-1,251,237,241,-1,239,254,272,-1,254,239,243,-1,271,257,65,-1,271,259,257,-1,134,77,244,-1,80,77,134,-1,122,126,123,-1,111,126,122,-1,248,93,119,-1,192,93,248,-1,250,247,255,-1,247,250,248,-1,252,106,264,-1,252,241,106,-1,255,242,250,-1,242,255,243,-1,260,270,120,-1,268,270,260,-1,90,13,260,-1,13,90,89,-1,95,118,96,-1,95,190,118,-1,175,128,176,-1,246,128,175,-1,16,110,165,-1,127,110,16,-1,263,187,215,-1,187,263,262,-1,45,195,209,-1,45,105,195,-1,265,133,267,-1,265,266,133,-1,103,210,72,-1,103,208,210,-1,69,150,75,-1,102,150,69,-1,166,55,100,-1,112,55,166,-1,6,96,93,-1,6,94,96,-1,118,121,119,-1,116,121,118,-1,260,131,268,-1,260,12,131,-1,12,260,13,-1,258,270,268,-1,258,256,270,-1,250,269,249,-1,269,250,242,-1,0,253,252,-1,91,253,0,-1,247,256,255,-1};
			return value;
		}
		private int[] getc3disc_Geo_8_44_coordIndex_3()
		{
			int[] value = {270,256,247,-1,109,8,262,-1,109,124,8,-1,262,15,187,-1,262,8,15,-1,130,167,246,-1,186,167,130,-1,266,185,133,-1,257,185,266,-1,65,245,271,-1,180,245,65,-1,272,259,271,-1,272,254,259,-1,273,251,269,-1,273,274,251,-1,273,139,274,-1,139,273,182,-1,83,240,193,-1,240,83,182,-1,188,286,207,-1,286,188,261,-1,70,75,196,-1,75,70,69,-1,227,276,278,-1,276,227,233,-1,279,276,231,-1,279,277,276,-1,219,279,220,-1,219,57,279,-1,281,234,229,-1,280,234,281,-1,235,63,282,-1,63,235,64,-1,282,179,151,-1,282,63,179,-1,277,47,275,-1,277,144,47,-1,154,283,178,-1,154,54,283,-1,147,278,275,-1,278,147,148,-1,150,151,179,-1,151,150,102,-1,224,285,288,-1,224,287,285,-1,199,222,288,-1,222,199,218,-1,160,163,158,-1,160,289,163,-1,289,160,284,-1,225,280,284,-1,280,225,230,-1,289,265,267,-1,281,265,289,-1,162,21,20,-1,21,162,217,-1,36,161,217,-1,36,35,161,-1,204,263,201,-1,204,27,263,-1,287,30,285,-1,203,30,287,-1,215,201,263,-1,215,202,201,-1,264,41,212,-1,264,106,41,-1,113,246,175,-1,130,246,113,-1,129,98,125,-1,11,98,129,-1,95,124,88,-1,95,94,124,-1,196,85,70,-1,136,85,196,-1,140,236,206,-1,140,181,236,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc3disc_Coord_9_44_point_1()
		{
			double[] value = {.13379,54.37176,-.71645,.14265,54.35487,-.68903,.21425,54.39606,-.7044,-.23135,54.48756,-.72327,-.2514,54.49425,-.71892,-.24353,54.48221,-.71457,.23135,54.48756,-.72327,.19445,54.43357,-.70734,.24256,54.48229,-.71392,.31298,54.52943,-1.16522,.29763,54.51729,-1.15836,.31316,54.54359,-1.10012,.21393,54.47352,-1.20401,.22382,54.47437,-1.19178,.22879,54.47423,-1.20651,.20319,54.42305,-.70409,.39364,54.55997,-1.12219,.39337,54.54571,-1.12437,.37067,54.53723,-1.16405,.43222,54.57453,-.95391,.43704,54.55127,-.96649,.41142,54.55194,-1.06962,.38649,54.53051,-.79237,.40006,54.51245,-.81359,.43335,54.53319,-.88201,.36854,54.47763,-.77995,.34745,54.50115,-.76471,.3083,54.44857,-.74553,.3298,54.43936,-.89508,.33135,54.43419,-.82866,.28627,54.36615,-.83663,.16514,54.30867,-.70486,.26441,54.34039,-.78124,.25782,54.33656,-.7505,.20145,54.42268,-1.13045,.26427,54.46393,-1.15549,.29041,54.45913,-1.07599,-.36854,54.47763,-.77995,-.35079,54.49795,-.76566,-.39083,54.52774,-.79284,0.0,54.3032,-.6606,0.0,54.31938,-.65974,-.07631,54.32025,-.66825,-.16401,54.31096,-.70435,-.15657,54.32682,-.69458,-.24569,54.35311,-.73241,-.27605,54.34615,-.77827,-.26441,54.34039,-.78124,-.25366,54.34322,-.74306,-.19325,54.4172,-1.11685,-.20145,54.42268,-1.13045,-.18765,54.42024,-1.12748,-.38127,54.48415,-.81543,-.40473,54.508,-.81109,-.34337,54.51257,-1.14957,-.25706,54.46293,-1.21152,-.26427,54.46393,-1.15549,-.07892,54.32259,-.7172,-.08144,54.30354,-.67541,-.16505,54.4032,-1.04964,-.23353,54.41002,-1.05602,-.18335,54.43247,-1.19146,-.33135,54.43419,-.82866,-.40381,54.49682,-.88495,-.3298,54.43936,-.89508,-.06996,54.46246,-1.1991,-.08048,54.44873,-1.19448,-.15541,54.45523,-1.21037,-.36862,54.5665,-1.04632,-.36898,54.59272,-.93767,-.32714,54.59408,-.92359,-.30724,54.53953,-.75336,-.26869,54.4847,-.72189,-.33221,54.56514,-.7866,-.30237,54.57727,-.79035,-.35495,54.57901,-.82947,-.1301,54.47914,-1.06893,-.22132,54.49214,-1.06183,-.2211,54.49646,-.96745,-.27477,54.54085,-.94499,-.27317,54.51795,-1.04171,-.26606,54.54627,-.84861,-.25087,54.51455,-.78142,-.19214,54.46622,-.8081,-.31444,54.54581,-1.02984,-.30749,54.58503,-.9248,.33142,54.56564,-.78651,.30238,54.57731,-.7903,.28684,54.55233,-.75417,.27792,54.50466,-1.1729,.27973,54.50297,-1.10888,.13371,54.39503,-.77183,.19292,54.44185,-.74566,.19214,54.46622,-.8081,.23923,54.49576,-.72766,.27315,54.55185,-.76342,.25087,54.51455,-.78142,.27317,54.51795,-1.04171,.31444,54.54581,-1.02984,-.30976,54.5206,-1.19096};
			return value;
		}
		private double[] getc3disc_Coord_9_44_point_2()
		{
			double[] value = {-.32527,54.51216,-1.19392,-.37101,54.54251,-1.1708,-.42915,54.57541,-.95312,-.30786,54.44928,-.74528,-.14227,54.35562,-.68888,-.21461,54.39556,-.70473,0.0,54.34395,-.66602,-.06806,54.34697,-.66921,.30619,54.54054,-.75306,.26812,54.48508,-.72154,.36379,54.5663,-1.04463,.37027,54.59235,-.938,-.23718,54.47233,-1.21345,.32145,54.51207,-1.20328,.25706,54.46293,-1.21152,.23624,54.47303,-1.21325,.27477,54.54085,-.94499,.30749,54.58503,-.9248,.26606,54.54627,-.84861,.21329,54.49055,-.89871,.22132,54.49214,-1.06183,.2211,54.49646,-.96745,.357,54.57835,-.83018,.3079,54.58187,-.81785,.25121,54.49438,-.7188,.3342,54.55606,-1.03143,.32715,54.59401,-.92358,.35331,54.56179,-1.11254,.33102,54.54234,-1.16355,.33177,54.55448,-1.10606,.29696,54.51223,-1.19753,.13931,54.46473,-1.20986,.1566,54.45393,-1.20987,.08074,54.44814,-1.19414,-.27973,54.50297,-1.10888,-.31305,54.54367,-1.10056,-.29031,54.57612,-.82148,-.28571,54.57291,-.79625,-.19292,54.44185,-.74566,-.13371,54.39503,-.77183,-.30246,54.51971,-1.15806,-.28679,54.55225,-.75428,-.24593,54.41575,-1.06079,-.29041,54.45913,-1.07599,-.15693,54.3241,-.74834,-.26481,54.35241,-.74579,-.30832,54.41293,-.7611,-.28627,54.36615,-.83663,-.28292,54.38567,-.89576,-.3289,54.43296,-.76974,-.42375,54.55696,-.85331,-.43673,54.552,-.96589,-.422,54.56878,-1.0649,-.38,54.54146,-1.16668,-.39816,54.54925,-1.12241,-.4018,54.5596,-1.12414,.40381,54.49682,-.88495,.18335,54.43247,-1.19146,.19325,54.4172,-1.11685,.23353,54.41002,-1.05602,.16505,54.4032,-1.04964,.34337,54.51257,-1.14957,.39815,54.51667,-.97937,.18765,54.42024,-1.12748,.24443,54.35483,-.73129,.41673,54.56855,-1.06306,-.2972,54.51219,-1.19762,.31004,54.52616,-1.17032,-.21393,54.47352,-1.20401,-.22911,54.474,-1.20657,-.22382,54.47437,-1.19178,-.19445,54.43357,-.70734,-.20321,54.42306,-.70405,-.13379,54.37176,-.71645,.15742,54.32509,-.69493,.34925,54.53468,-1.1798,.36432,54.54272,-1.16923,.38127,54.48415,-.81543,-.41709,54.55717,-1.06837,-.43669,54.53391,-.88149,-.13931,54.46473,-1.20986,-.27822,54.50508,-1.17276,-.13471,54.44446,-.82965,-.27315,54.55185,-.76342,-.23923,54.49576,-.72766,.06996,54.46246,-1.1991,.28473,54.50731,-1.18852,.22426,54.40389,-.70794,-.34607,54.54167,-1.16737,-.08918,54.4337,-1.17482,.28571,54.57291,-.79625,.29031,54.57612,-.82148,.13471,54.44446,-.82965,-.21329,54.49055,-.89871,-.1337,54.4724,-.99003,-.22388,54.40436,-.70762,-.30791,54.58191,-.81784,-.33424,54.55588,-1.03139,.24593,54.41575,-1.06079,.15693,54.3241,-.74834};
			return value;
		}
		private double[] getc3disc_Coord_9_44_point_3()
		{
			double[] value = {.27605,54.34615,-.77827,.31187,54.40507,-.76777,.26896,54.34574,-.75323,.28292,54.38567,-.89576,.3289,54.43296,-.76974,.4211,54.5578,-.8524,-.30949,54.52378,-1.17447,-.32008,54.53013,-1.16656,-.29906,54.43347,-.74368,-.25893,54.3614,-.7364,-.26197,54.46769,-.71864,.08144,54.30354,-.67541,.07662,54.31925,-.66822,.26153,54.40041,-.98874,.27446,54.40633,-.99005,.25598,54.36501,-.73398,.31439,54.45074,-.99433,.37166,54.52038,-1.0744,.07892,54.32259,-.7172,0.0,54.32343,-.70543,0.0,54.3469,-.78443,.07781,54.36858,-.87392,.07951,54.34501,-.79057,0.0,54.36749,-.87347,.15787,54.36508,-.88978,.07836,54.38582,-.95726,.15938,54.38839,-.97736,-.26153,54.40041,-.98874,-.27446,54.40633,-.99005,-.08824,54.4211,-1.11765,0.0,54.38505,-.95313,-.07781,54.36858,-.87392,-.07836,54.38582,-.95726,-.15938,54.38839,-.97736,-.08489,54.40429,-1.04178,-.31439,54.45074,-.99433,-.2846,54.50699,-1.1886,-.0592,54.36923,-.71501,-.06012,54.45536,-.92127,-.05869,54.46557,-1.00181,-.13435,54.46235,-.91158,0.0,54.36835,-.71913,0.0,54.45948,-.92838,0.0,54.47031,-1.00782,-.21834,54.47232,-1.14193,-.13249,54.46576,-1.14964,.32219,54.53253,-1.17884,.1337,54.4724,-.99003,.13435,54.46235,-.91158,.06763,54.44091,-.83507,.06012,54.45536,-.92127,0.0,54.38899,-.78433,.0592,54.36923,-.71501,.06765,54.38999,-.78292,0.0,54.48036,-1.08627,.05869,54.46557,-1.00181,.06252,54.47446,-1.08009,0.0,54.46542,-1.20009,.0637,54.46198,-1.1451,0.0,54.46592,-1.1445,.21834,54.47232,-1.14193,-.3587,54.56155,-1.11383,.25804,54.46871,-.71646,.29715,54.43075,-.74307,.06844,54.34575,-.66916,0.0,54.43655,-1.1757,0.0,54.44992,-1.19248,.08918,54.4337,-1.17482,.13249,54.46576,-1.14964,0.0,54.44252,-.84302,.1301,54.47914,-1.06893,-.0637,54.46198,-1.1451,-.06252,54.47446,-1.08009,-.06763,54.44091,-.83507,-.06765,54.38999,-.78292,-.2744,54.35952,-.83715,-.15787,54.36508,-.88978,-.15917,54.34106,-.80085,-.27006,54.37953,-.89539,-.07951,54.34501,-.79057,0.0,54.40217,-1.0319,0.0,54.41855,-1.10895,-.39815,54.51667,-.97937,-.37166,54.52038,-1.0744,.08489,54.40429,-1.04178,.2744,54.35952,-.83715,-.33194,54.55396,-1.10602,.27006,54.37953,-.89539,.15917,54.34106,-.80085,.08824,54.4211,-1.11765};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc4_Geo_8_49_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,3,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,40,-1,43,44,45,-1,46,47,48,-1,45,49,50,-1,51,52,53,-1,54,55,56,-1,51,53,57,-1,58,59,45,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,67,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,105,110,111,-1,112,113,114,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,121,124,125,-1,126,127,128,-1,129,130,128,-1,129,107,109,-1,128,131,132,-1,133,134,135,-1,107,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,119,-1,149,150,151,-1,151,150,152,-1,153,154,11,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,164,165,166,-1,167,168,169,-1,170,171,172,-1,173,116,174,-1,175,176,177,-1,178,176,179,-1,180,181,182,-1,183,184,185,-1,186,184,183,-1,187,188,189,-1,190,191,192,-1,193,194,195,-1,196,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,21,3,5,-1,58,208,64,-1,209,210,211,-1,37,212,213,-1,213,214,35,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,224,226,33,-1,227,228,229,-1,230,227,231,-1,232,233,9,-1,154,232,9,-1,72,234,235,-1,7,73,236,-1,76,237,238,-1,239,240,241,-1,242,243,244,-1,239,241,245,-1,71,246,247,-1,208,60,64,-1,248,249,250,-1,251,252,253,-1,254,255,227,-1,256,252,257,-1,258,259,260,-1,261,262,263,-1,65,62,81,-1,63,67,70,-1,264,265,266,-1,267,268,269,-1,270,271,50,-1,272,273,51,-1,274,275,276,-1,277,186,278,-1,279,280,281,-1,282,283,284,-1,190,285,281,-1,286,287,196,-1,288,289,290,-1,193,195,291,-1,292,293,294,-1,204,295,296,-1,297,298,299,-1,95,300,301,-1,125,124,302,-1,138,303,145,-1,123,120,124,-1,304,94,93,-1,142,141,170,-1,103,305,306,-1,80,68,67,-1,146,137,136,-1,307,308,274,-1,132,309,310,-1,311,192,191,-1,312,313,189,-1,110,314,315,-1,316,164,134,-1,317,318,319,-1,320,321,322,-1,156,149,157,-1,323,324,325,-1,326,327,328,-1,329,330,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,336,-1,343,344,345,-1,346,347,348,-1,349,347,350,-1,337,351,348,-1,352,353,354,-1,355,356,357,-1,1,358,354,-1,359,356,360,-1,361,362,363,-1,364,365,366,-1,361,367,368,-1,369,370,371,-1,372,373,374,-1,369,375,376,-1,377,378,379,-1,378,380,381,-1,382,383,384,-1,385,386,387,-1,388,373,387,-1,389,380,390,-1,381,391,392,-1,381,393,394,-1,395,396,397,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,406,411,-1,412,413,414,-1,415,416,417,-1,418,419,420,-1,403,421,422,-1,423,424,425,-1,426,427,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,443,435,434,-1,442,444,445,-1,446,447,448,-1,443,442,436,-1,449,450,451,-1,452,453,454,-1,449,451,455,-1,456,452,457,-1,458,459,460,-1,453,461,462,-1,333,463,464,-1,371,465,466,-1,467,332,334,-1,466,468,469,-1,463,333,470,-1,471,472,469,-1,473,474,475,-1,476,477,478,-1,479,480,481,-1,472,414,413,-1,482,483,484,-1,485,414,486,-1,487,488,489,-1,490,491,492,-1,493,490,492,-1,494,495,496,-1,497,498,499,-1,500,501,455,-1,502,477,503,-1,504,505,382,-1,506,505,507,-1,508,401,509,-1,510,511,512,-1,335,512,513,-1,356,514,515,-1,516,517,229,-1,518,519,329,-1,520,521,522,-1,523,524,525,-1,526,527,528,-1,529,530,531,-1,532,533,534,-1,535,528,536,-1,537,538,539,-1,540,541,542,-1,543,544,405,-1,415,545,546,-1,547,548,492,-1,549,550,551,-1,552,553,489,-1,554,555,556,-1,557,558,554,-1,559,560,561,-1,562,563,564,-1,495,565,566,-1,567,568,569,-1,570,571,572,-1,476,573,574,-1,575,576,577,-1,578,454,459,-1,407,409,406,-1,579,580,581,-1,582,583,584,-1,585,583,582,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_2()
		{
			int[] value = {586,587,588,-1,589,590,586,-1,591,592,448,-1,593,594,595,-1,490,493,412,-1,596,597,366,-1,598,599,600,-1,442,601,602,-1,448,603,604,-1,589,425,590,-1,493,487,605,-1,558,424,489,-1,606,440,581,-1,607,417,416,-1,608,580,609,-1,610,411,611,-1,439,612,613,-1,614,600,591,-1,615,616,617,-1,500,618,437,-1,462,454,453,-1,619,620,621,-1,622,623,624,-1,625,626,627,-1,628,567,629,-1,630,499,631,-1,632,633,495,-1,496,634,635,-1,565,636,637,-1,557,560,583,-1,638,639,559,-1,561,640,559,-1,641,549,642,-1,643,375,644,-1,645,646,647,-1,648,643,649,-1,610,611,394,-1,405,544,387,-1,650,372,651,-1,541,537,542,-1,539,504,652,-1,539,653,654,-1,655,519,656,-1,657,535,536,-1,658,388,659,-1,660,661,522,-1,401,531,543,-1,662,663,664,-1,531,530,543,-1,395,665,529,-1,399,526,528,-1,360,515,666,-1,515,667,668,-1,669,222,335,-1,670,671,672,-1,509,673,674,-1,675,676,420,-1,505,506,382,-1,677,678,507,-1,211,511,510,-1,346,357,679,-1,336,342,337,-1,567,564,680,-1,681,633,632,-1,424,583,585,-1,487,492,488,-1,555,550,549,-1,553,550,555,-1,682,485,683,-1,684,685,686,-1,614,687,685,-1,616,688,600,-1,621,478,689,-1,620,478,621,-1,503,476,603,-1,690,691,481,-1,692,693,694,-1,693,463,694,-1,691,471,695,-1,524,523,696,-1,465,467,468,-1,334,464,469,-1,501,462,461,-1,456,502,449,-1,456,449,453,-1,609,580,697,-1,449,502,450,-1,698,427,699,-1,447,698,448,-1,441,579,581,-1,429,700,500,-1,437,701,429,-1,433,432,702,-1,703,688,430,-1,704,426,428,-1,705,706,697,-1,704,582,707,-1,613,408,439,-1,673,422,431,-1,421,403,404,-1,708,420,615,-1,587,413,588,-1,605,412,493,-1,386,611,405,-1,409,577,709,-1,406,405,611,-1,692,663,710,-1,396,395,711,-1,528,527,661,-1,610,393,392,-1,712,411,610,-1,388,544,543,-1,379,372,374,-1,713,714,715,-1,380,391,381,-1,546,644,375,-1,646,377,379,-1,383,382,506,-1,716,522,521,-1,362,670,511,-1,38,717,363,-1,344,718,507,-1,719,720,721,-1,722,352,355,-1,353,723,1,-1,2,338,0,-1,724,346,725,-1,726,727,728,-1,513,719,729,-1,510,512,335,-1,332,730,470,-1,731,365,364,-1,329,331,732,-1,524,696,365,-1,400,399,733,-1,135,134,164,-1,734,735,736,-1,89,91,737,-1,738,315,89,-1,105,190,739,-1,105,740,190,-1,132,310,136,-1,737,91,275,-1,741,742,82,-1,145,303,743,-1,168,744,164,-1,93,175,304,-1,745,746,747,-1,748,200,749,-1,750,751,752,-1,753,291,195,-1,754,755,756,-1,281,285,283,-1,191,281,280,-1,757,758,759,-1,760,187,311,-1,761,186,277,-1,188,762,763,-1,764,53,52,-1,81,62,239,-1,261,765,257,-1,256,766,37,-1,253,73,767,-1,241,768,245,-1,240,238,237,-1,767,73,6,-1,769,232,234,-1,770,771,230,-1,772,230,231,-1,14,231,229,-1,228,224,32,-1,226,773,774,-1,775,221,20,-1,776,775,19,-1,301,218,98,-1,777,218,245,-1,213,212,778,-1,766,765,779,-1,46,212,766,-1,780,166,165,-1,120,148,124,-1,781,294,782,-1,178,783,784,-1,785,786,787,-1,788,789,752,-1,107,790,108,-1,763,791,325,-1,792,280,183,-1,182,793,87,-1,182,181,794,-1,795,88,325,-1,90,793,796,-1,176,784,177,-1,797,175,93,-1,167,171,165,-1,798,788,799,-1,149,796,800,-1,16,15,159,-1,801,802,149,-1,152,150,803,-1,801,151,804,-1,150,156,159,-1,805,147,138,-1,805,145,806,-1,807,141,143,-1,139,147,119,-1,140,143,303,-1,137,743,142,-1,747,746,798,-1,318,317,127,-1,808,735,734,-1,131,317,809,-1,118,810,127,-1,309,101,144,-1,120,123,810,-1,811,118,812,-1,192,314,739,-1,314,192,313,-1,780,811,813,-1,100,301,98,-1,216,215,814,-1,156,155,159,-1,87,90,323,-1,180,86,795,-1,815,816,817,-1,68,80,742,-1,95,97,82,-1,301,300,245,-1,7,818,114,-1,17,242,153,-1,819,63,54,-1,54,69,820,-1,821,56,55,-1,248,44,822,-1,60,208,61,-1,819,823,59,-1,823,819,54,-1,45,59,49,-1,824,57,825,-1,825,326,328,-1,826,827,828,-1,829,322,10,-1,40,827,830,-1,33,4,34,-1,29,773,831,-1,5,774,832,-1,833,834,835,-1,22,21,836,-1,24,837,833,-1,838,839,36,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_3()
		{
			int[] value = {840,20,835,-1,27,26,260,-1,841,20,221,-1,150,15,803,-1,842,770,772,-1,4,359,34,-1,30,831,28,-1,359,679,357,-1,13,842,772,-1,260,843,27,-1,212,37,766,-1,835,844,840,-1,838,845,839,-1,833,21,24,-1,833,835,841,-1,26,28,831,-1,5,4,774,-1,773,846,831,-1,33,774,4,-1,40,42,827,-1,829,10,847,-1,828,848,826,-1,849,825,57,-1,44,208,58,-1,824,51,57,-1,59,823,49,-1,54,56,823,-1,779,47,46,-1,60,65,64,-1,208,248,61,-1,248,208,44,-1,54,70,69,-1,63,70,54,-1,114,113,76,-1,76,8,114,-1,114,8,7,-1,218,301,245,-1,82,81,95,-1,850,102,741,-1,80,82,742,-1,87,323,88,-1,308,307,764,-1,814,92,216,-1,100,96,301,-1,315,314,313,-1,110,133,111,-1,173,851,116,-1,812,813,811,-1,123,318,810,-1,117,319,122,-1,127,126,118,-1,809,852,131,-1,734,853,808,-1,810,318,127,-1,811,780,139,-1,137,142,854,-1,303,138,140,-1,119,811,139,-1,807,143,140,-1,855,805,806,-1,855,148,805,-1,159,15,150,-1,801,804,849,-1,803,856,152,-1,149,151,801,-1,16,159,158,-1,149,800,157,-1,799,747,798,-1,165,744,167,-1,93,161,797,-1,176,178,784,-1,90,87,793,-1,182,794,857,-1,182,87,86,-1,311,187,189,-1,325,188,763,-1,188,325,324,-1,290,195,194,-1,178,858,783,-1,781,292,294,-1,202,199,859,-1,120,119,148,-1,165,807,780,-1,766,779,46,-1,778,327,213,-1,768,777,245,-1,775,210,209,-1,20,19,775,-1,774,33,226,-1,229,517,14,-1,231,14,772,-1,770,230,772,-1,769,860,232,-1,73,72,236,-1,237,241,240,-1,861,862,863,-1,241,237,768,-1,253,767,864,-1,37,865,256,-1,261,257,262,-1,866,263,822,-1,239,300,81,-1,764,867,53,-1,761,184,186,-1,311,185,760,-1,757,868,758,-1,280,792,191,-1,281,283,282,-1,203,754,756,-1,753,869,291,-1,752,204,750,-1,748,749,789,-1,172,745,747,-1,168,167,744,-1,870,871,305,-1,316,168,164,-1,170,172,747,-1,95,81,300,-1,82,850,741,-1,274,737,275,-1,132,136,129,-1,105,104,740,-1,89,737,738,-1,734,736,316,-1,135,164,166,-1,126,130,872,-1,521,520,873,-1,365,731,524,-1,516,329,732,-1,731,364,873,-1,332,470,333,-1,336,513,729,-1,679,350,347,-1,346,874,725,-1,337,348,347,-1,353,1,354,-1,722,355,357,-1,34,360,32,-1,507,875,344,-1,38,363,39,-1,511,363,362,-1,379,374,876,-1,506,877,383,-1,379,876,646,-1,546,545,644,-1,380,389,391,-1,369,546,375,-1,379,651,372,-1,544,388,387,-1,410,878,407,-1,610,879,712,-1,392,879,610,-1,711,880,396,-1,527,881,882,-1,409,709,406,-1,878,712,883,-1,615,884,708,-1,709,421,404,-1,431,674,673,-1,885,705,697,-1,428,582,704,-1,688,616,430,-1,451,434,455,-1,408,440,439,-1,429,886,700,-1,441,594,579,-1,581,444,441,-1,447,427,698,-1,699,702,698,-1,697,887,609,-1,449,461,453,-1,452,888,457,-1,455,501,461,-1,468,334,469,-1,467,334,468,-1,523,730,696,-1,471,464,695,-1,690,481,480,-1,503,477,476,-1,889,574,573,-1,478,477,689,-1,600,617,616,-1,614,685,479,-1,890,684,686,-1,682,683,484,-1,553,555,558,-1,556,555,549,-1,487,493,492,-1,424,557,583,-1,495,494,632,-1,632,891,681,-1,892,571,893,-1,564,894,680,-1,895,896,897,-1,346,679,347,-1,385,373,372,-1,898,211,510,-1,507,505,875,-1,507,718,677,-1,419,675,420,-1,674,899,509,-1,670,672,727,-1,669,335,337,-1,515,668,666,-1,360,666,32,-1,518,656,519,-1,731,873,520,-1,882,525,527,-1,528,733,399,-1,400,733,665,-1,395,400,665,-1,397,900,398,-1,664,534,901,-1,662,664,902,-1,881,901,903,-1,402,401,543,-1,660,522,716,-1,385,387,373,-1,658,659,904,-1,657,536,653,-1,655,656,905,-1,653,906,654,-1,340,907,908,-1,539,654,504,-1,541,538,537,-1,405,387,386,-1,393,610,394,-1,645,647,909,-1,643,644,649,-1,489,553,558,-1,561,554,640,-1,638,910,639,-1,557,561,560,-1,565,633,636,-1,633,565,495,-1,631,897,630,-1,628,911,567,-1,627,912,625,-1,623,913,624,-1,403,402,404,-1,914,500,700,-1,462,459,454,-1,437,429,500,-1,617,884,615,-1,612,575,613,-1,409,408,613,-1,608,606,580,-1,879,883,712,-1,558,557,424,-1,487,423,605,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_4()
		{
			int[] value = {425,428,590,-1,448,698,603,-1,602,436,442,-1,600,915,598,-1,366,916,596,-1,471,469,464,-1,412,917,490,-1,448,604,591,-1,586,588,589,-1,584,707,582,-1,580,606,581,-1,417,883,879,-1,406,410,407,-1,402,405,404,-1,918,621,689,-1,617,479,884,-1,570,680,571,-1,569,629,567,-1,495,566,919,-1,562,920,563,-1,559,639,560,-1,554,561,557,-1,556,640,554,-1,489,488,552,-1,642,549,551,-1,546,921,415,-1,922,923,924,-1,405,402,543,-1,539,652,537,-1,535,925,528,-1,529,665,530,-1,733,528,925,-1,523,525,882,-1,525,520,522,-1,329,516,518,-1,516,229,518,-1,32,666,228,-1,515,360,356,-1,513,336,335,-1,513,512,726,-1,673,509,403,-1,509,926,508,-1,507,715,506,-1,503,450,502,-1,500,455,618,-1,927,893,894,-1,499,630,497,-1,928,929,930,-1,568,570,474,-1,706,931,697,-1,491,547,492,-1,555,554,558,-1,485,486,683,-1,482,484,683,-1,490,917,932,-1,472,486,414,-1,481,884,479,-1,478,573,476,-1,473,475,918,-1,471,933,472,-1,470,694,463,-1,469,934,466,-1,467,935,332,-1,465,468,466,-1,464,334,333,-1,462,501,460,-1,459,462,460,-1,457,502,456,-1,455,461,449,-1,452,456,453,-1,475,936,918,-1,443,436,435,-1,446,448,592,-1,445,601,442,-1,434,595,443,-1,441,444,442,-1,701,602,703,-1,435,437,618,-1,434,451,432,-1,688,915,600,-1,585,425,424,-1,423,425,589,-1,432,451,450,-1,422,673,403,-1,420,708,418,-1,463,695,464,-1,917,412,414,-1,932,485,682,-1,937,938,939,-1,406,611,411,-1,404,406,709,-1,401,403,509,-1,398,400,397,-1,523,903,730,-1,397,400,395,-1,381,394,650,-1,392,393,381,-1,388,658,373,-1,651,378,650,-1,378,381,650,-1,378,651,379,-1,376,370,369,-1,713,678,370,-1,368,940,361,-1,364,366,597,-1,363,717,361,-1,360,34,359,-1,358,514,354,-1,356,359,357,-1,352,354,355,-1,723,2,1,-1,337,342,351,-1,348,874,346,-1,345,941,343,-1,336,729,341,-1,504,875,505,-1,340,0,338,-1,330,942,331,-1,326,213,327,-1,325,88,323,-1,320,322,829,-1,319,809,317,-1,316,134,734,-1,738,110,315,-1,312,189,324,-1,311,191,792,-1,84,83,66,-1,136,310,146,-1,103,102,850,-1,103,306,101,-1,142,170,943,-1,736,173,944,-1,304,174,94,-1,124,121,123,-1,145,805,138,-1,172,945,745,-1,297,946,298,-1,750,204,296,-1,292,205,293,-1,291,196,193,-1,286,196,291,-1,190,281,191,-1,282,284,947,-1,282,279,281,-1,792,185,311,-1,276,307,274,-1,272,51,267,-1,270,50,265,-1,264,270,265,-1,63,80,67,-1,65,60,62,-1,59,58,819,-1,866,261,263,-1,256,948,252,-1,227,230,254,-1,253,864,251,-1,250,61,248,-1,247,769,71,-1,239,245,300,-1,243,861,949,-1,818,112,114,-1,238,8,76,-1,238,6,8,-1,7,6,73,-1,154,234,232,-1,227,229,231,-1,33,32,224,-1,224,950,225,-1,223,841,221,-1,218,220,98,-1,217,951,215,-1,46,778,212,-1,213,326,214,-1,209,211,898,-1,21,5,24,-1,841,835,20,-1,204,749,202,-1,198,193,196,-1,192,739,190,-1,188,324,189,-1,186,183,952,-1,792,183,185,-1,182,86,180,-1,178,179,953,-1,175,177,944,-1,174,304,173,-1,170,165,171,-1,172,171,945,-1,164,744,165,-1,797,161,163,-1,158,160,79,-1,155,157,162,-1,11,17,153,-1,151,152,804,-1,149,156,150,-1,147,805,148,-1,144,806,145,-1,139,807,140,-1,138,147,139,-1,137,854,107,-1,780,807,139,-1,135,954,133,-1,132,129,128,-1,129,136,107,-1,126,128,130,-1,125,955,121,-1,101,309,102,-1,119,118,811,-1,120,810,118,-1,135,813,812,-1,115,174,116,-1,112,956,113,-1,105,111,106,-1,108,957,109,-1,98,220,99,-1,95,301,96,-1,94,216,92,-1,86,88,795,-1,324,323,312,-1,81,80,65,-1,235,244,72,-1,76,113,74,-1,69,67,66,-1,68,84,66,-1,741,85,742,-1,65,80,63,-1,239,62,61,-1,45,44,58,-1,327,958,328,-1,54,820,55,-1,51,273,52,-1,50,43,45,-1,48,778,46,-1,860,769,247,-1,40,210,41,-1,40,830,38,-1,35,37,213,-1,959,960,18,-1,29,831,30,-1,23,837,24,-1,961,962,776,-1,840,18,20,-1,221,775,209,-1,15,17,803,-1,13,772,14,-1,11,154,9,-1,233,232,860,-1,669,223,222,-1,4,679,359,-1,4,3,679,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_5()
		{
			int[] value = {770,963,964,-1,842,963,770,-1,242,861,243,-1,862,861,242,-1,838,35,965,-1,35,838,36,-1,776,18,961,-1,776,19,18,-1,966,23,25,-1,23,966,967,-1,968,31,30,-1,31,968,969,-1,23,843,837,-1,843,23,27,-1,844,258,970,-1,259,258,844,-1,828,42,971,-1,42,828,827,-1,972,326,825,-1,972,973,326,-1,12,974,975,-1,974,12,976,-1,963,829,847,-1,977,829,963,-1,826,830,827,-1,826,975,830,-1,804,321,972,-1,804,152,321,-1,271,779,978,-1,779,271,47,-1,863,79,78,-1,158,79,863,-1,979,980,981,-1,980,979,982,-1,163,817,816,-1,163,800,817,-1,276,849,867,-1,801,849,276,-1,215,77,814,-1,77,215,983,-1,984,112,985,-1,956,112,984,-1,318,122,319,-1,123,122,318,-1,871,125,305,-1,871,955,125,-1,131,83,132,-1,131,852,83,-1,853,737,808,-1,853,738,737,-1,853,134,133,-1,734,134,853,-1,812,126,872,-1,812,118,126,-1,743,143,142,-1,743,303,143,-1,943,747,799,-1,170,747,943,-1,787,953,815,-1,953,787,786,-1,180,325,791,-1,180,795,325,-1,986,815,987,-1,815,986,787,-1,988,989,990,-1,988,991,989,-1,990,791,992,-1,990,180,791,-1,198,993,994,-1,993,198,197,-1,868,278,758,-1,995,278,868,-1,996,997,998,-1,999,997,996,-1,785,986,287,-1,785,787,986,-1,1000,1001,298,-1,1002,1001,1000,-1,1003,1004,1005,-1,1003,1006,1004,-1,195,289,753,-1,290,289,195,-1,1007,859,781,-1,1007,754,859,-1,292,206,205,-1,292,201,206,-1,785,286,1008,-1,287,286,785,-1,748,1009,200,-1,748,1010,1009,-1,75,777,768,-1,75,981,777,-1,1011,1012,980,-1,951,1012,1011,-1,962,1013,41,-1,962,965,1013,-1,209,222,221,-1,209,898,222,-1,985,949,984,-1,949,985,243,-1,982,1014,1015,-1,1014,982,1016,-1,247,1017,860,-1,1017,247,1018,-1,1019,225,950,-1,225,1019,1020,-1,262,249,263,-1,262,251,249,-1,1021,254,1022,-1,254,1021,960,-1,1021,838,961,-1,845,838,1021,-1,58,63,819,-1,58,64,63,-1,261,43,978,-1,43,261,866,-1,47,1023,48,-1,1023,47,1024,-1,52,69,764,-1,52,820,69,-1,762,1025,763,-1,762,1026,1025,-1,1027,1028,1029,-1,1030,1028,1027,-1,1031,277,1032,-1,1031,761,277,-1,762,187,760,-1,187,762,188,-1,952,759,758,-1,952,279,759,-1,759,1033,757,-1,1033,759,947,-1,284,1034,1035,-1,284,1036,1034,-1,1034,1037,1038,-1,1034,1039,1037,-1,1040,293,1041,-1,293,1040,294,-1,755,1003,756,-1,755,1042,1003,-1,1043,1044,1045,-1,1046,1044,1043,-1,1047,1048,1045,-1,1047,288,1048,-1,1049,869,753,-1,1049,1040,869,-1,798,789,788,-1,798,748,789,-1,953,858,178,-1,953,786,858,-1,298,1050,1000,-1,946,1050,298,-1,1051,799,1052,-1,1051,943,799,-1,1053,799,788,-1,1052,799,1053,-1,135,780,813,-1,135,166,780,-1,1054,371,370,-1,1054,465,371,-1,364,1055,873,-1,1055,364,1056,-1,351,340,339,-1,907,340,351,-1,352,1057,353,-1,1058,1057,352,-1,1059,725,338,-1,1059,1060,725,-1,724,357,346,-1,724,722,357,-1,1061,1062,908,-1,1061,1063,1062,-1,345,875,1064,-1,875,345,344,-1,1065,916,1054,-1,596,916,1065,-1,670,1066,671,-1,670,362,1066,-1,1067,331,367,-1,732,331,1067,-1,974,717,38,-1,974,1067,717,-1,1068,646,876,-1,647,646,1068,-1,527,1069,881,-1,1069,527,526,-1,663,1070,710,-1,663,662,1070,-1,1071,880,711,-1,1071,1072,880,-1,921,369,371,-1,369,921,546,-1,466,1073,1074,-1,1073,466,934,-1,1075,431,430,-1,1075,674,431,-1,1076,463,693,-1,463,1076,695,-1,425,582,428,-1,425,585,582,-1,1077,396,880,-1,396,1077,1078,-1,703,915,688,-1,602,915,703,-1,575,409,613,-1,577,409,575,-1,914,575,612,-1,700,575,914,-1,598,1079,599,-1,598,1080,1079,-1,607,446,1079,-1,607,586,446,-1,593,702,699,-1,433,702,593,-1,887,578,609,-1,887,888,578,-1,889,478,620,-1,889,573,478,-1,574,591,604,-1,614,591,574,-1,685,912,686,-1,687,912,685,-1,486,933,937,-1,486,472,933,-1,1081,681,1082,-1,1083,681,1081,-1,1084,1085,1086,-1,1084,1087,1085,-1,1088,483,1082,-1,1088,1089,483,-1,891,1090,1088,-1,891,1091,1090,-1,1092,1093,1094,-1,1093,1092,1095,-1,1096,584,1097,-1,1096,707,584,-1,1098,891,632,-1,1098,1091,891,-1,929,1099,930,-1,929,1100,1099,-1,622,1101,623,-1,622,895,1101,-1,1102,562,911,-1,1102,1103,562,-1,1104,919,1105,-1,919,1104,634,-1,563,894,564,-1,927,894,563,-1,566,637,1106,-1,566,565,637,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_6()
		{
			int[] value = {1107,1108,1106,-1,1107,1109,1108,-1,624,936,1110,-1,624,619,936,-1,351,874,348,-1,351,339,874,-1,1111,1087,1084,-1,1111,1112,1087,-1,926,1113,1071,-1,926,1114,1113,-1,675,1070,1115,-1,419,1070,675,-1,674,676,899,-1,1075,676,674,-1,356,354,514,-1,356,355,354,-1,519,330,329,-1,519,1116,330,-1,733,530,665,-1,530,733,925,-1,1117,902,664,-1,1117,1118,902,-1,1117,1119,1118,-1,902,1120,662,-1,902,1118,1120,-1,661,536,528,-1,661,660,536,-1,388,530,659,-1,388,543,530,-1,653,660,906,-1,653,536,660,-1,519,1121,1116,-1,1121,519,655,-1,1062,1,0,-1,358,1,1062,-1,538,653,539,-1,538,657,653,-1,941,1121,1122,-1,941,1123,1121,-1,0,908,1062,-1,908,0,340,-1,728,720,719,-1,720,728,1122,-1,374,542,876,-1,540,542,374,-1,1124,922,924,-1,1124,909,922,-1,1125,380,378,-1,390,380,1125,-1,383,909,647,-1,909,383,922,-1,375,648,376,-1,648,375,643,-1,1126,552,548,-1,1126,1127,552,-1,1128,1129,1130,-1,1129,1128,1131,-1,1132,1133,1134,-1,1133,1132,1135,-1,553,1127,1136,-1,553,552,1127,-1,638,640,1137,-1,559,640,638,-1,1138,638,1139,-1,1138,910,638,-1,639,1140,1141,-1,910,1140,639,-1,1142,1140,1143,-1,1142,628,1140,-1,1144,1106,1108,-1,1144,566,1106,-1,1006,1145,1103,-1,1006,1146,1145,-1,1147,1148,1149,-1,1046,1148,1147,-1,1150,1151,1152,-1,1151,1150,1148,-1,1152,634,1104,-1,635,634,1152,-1,1105,499,498,-1,1105,1144,499,-1,474,569,568,-1,569,474,1097,-1,480,685,684,-1,685,480,479,-1,889,913,625,-1,913,889,620,-1,460,500,914,-1,500,460,501,-1,603,574,604,-1,603,476,574,-1,438,612,439,-1,458,612,438,-1,438,606,608,-1,438,440,606,-1,879,415,417,-1,879,392,415,-1,581,878,883,-1,878,581,407,-1,599,591,600,-1,591,599,592,-1,934,472,413,-1,469,472,934,-1,713,507,678,-1,713,715,507,-1,450,702,432,-1,450,503,702,-1,473,1097,474,-1,1097,473,1096,-1,473,1153,1096,-1,473,1154,1153,-1,709,576,421,-1,709,577,576,-1,1100,890,686,-1,1100,929,890,-1,570,475,474,-1,570,572,475,-1,566,1105,919,-1,566,1144,1105,-1,1155,1152,1151,-1,1155,635,1152,-1,1148,1043,1151,-1,1043,1148,1046,-1,1103,920,562,-1,1103,1145,920,-1,631,1144,1108,-1,499,1144,631,-1,1037,1143,1038,-1,1037,1142,1143,-1,1143,910,1138,-1,1143,1140,910,-1,1139,1137,1156,-1,638,1137,1139,-1,1137,556,1157,-1,1137,640,556,-1,488,548,552,-1,492,548,488,-1,642,1134,1133,-1,642,551,1134,-1,1130,1136,1127,-1,1136,1130,1129,-1,1158,548,547,-1,1158,1126,548,-1,1074,607,416,-1,1074,1073,607,-1,648,714,376,-1,924,714,648,-1,377,1125,378,-1,1125,377,1159,-1,876,537,1068,-1,542,537,876,-1,719,1160,729,-1,1160,719,721,-1,1063,1160,1161,-1,1160,1063,1061,-1,1123,345,1162,-1,345,1123,941,-1,906,1064,654,-1,1163,1064,906,-1,1116,1123,1164,-1,1123,1116,1121,-1,659,925,535,-1,659,530,925,-1,508,395,529,-1,711,395,508,-1,1118,1165,1120,-1,1119,1165,1118,-1,664,1166,1117,-1,664,901,1166,-1,527,522,661,-1,525,522,527,-1,524,520,525,-1,731,520,524,-1,1164,330,1116,-1,330,1164,1055,-1,518,228,656,-1,518,229,228,-1,222,510,335,-1,222,898,510,-1,692,418,693,-1,692,710,418,-1,509,1114,926,-1,509,899,1114,-1,1089,1084,1167,-1,1084,1089,1111,-1,622,1110,1168,-1,622,624,1110,-1,1101,1108,1109,-1,1101,631,1108,-1,563,1169,1170,-1,563,920,1169,-1,1106,1099,1107,-1,1106,637,1099,-1,680,568,567,-1,680,570,568,-1,1104,498,1171,-1,1105,498,1104,-1,911,564,567,-1,911,562,564,-1,1168,895,622,-1,1168,896,895,-1,1100,1107,1099,-1,1100,627,1107,-1,1098,1172,1091,-1,1098,1173,1172,-1,1174,1097,584,-1,569,1097,1174,-1,1175,547,491,-1,1158,547,1175,-1,1091,1176,1090,-1,1091,1172,1176,-1,1088,1111,1089,-1,1088,1090,1111,-1,1086,999,1177,-1,999,1086,1085,-1,1081,937,939,-1,1081,482,937,-1,482,486,937,-1,482,683,486,-1,938,480,684,-1,480,938,690,-1,889,614,574,-1,687,614,889,-1,458,608,459,-1,608,458,438,-1,885,699,705,-1,885,593,699,-1,586,447,446,-1,586,590,447,-1,883,444,581,-1,883,445,444,-1,579,697,580,-1,885,697,579,-1,443,594,441,-1,594,443,595,-1,700,576,575,-1,700,886,576,-1,701,436,602,-1,436,701,437,-1,900,1117,1166,-1,1117,900,1078,-1,710,419,418,-1,1070,419,710,-1,371,1074,921,-1,1074,371,466,-1,1113,1072,1071,-1,1165,1072,1113,-1,692,532,663,-1,532,692,694,-1,394,386,385,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_7()
		{
			int[] value = {386,394,611,-1,713,376,714,-1,713,370,376,-1,365,935,366,-1,365,696,935,-1,1178,368,1179,-1,1178,940,368,-1,368,331,942,-1,331,368,367,-1,671,1180,677,-1,671,1066,1180,-1,1065,1178,596,-1,1178,1065,1180,-1,1063,358,1062,-1,1063,667,358,-1,1181,1060,1059,-1,1182,1060,1181,-1,1057,1060,1182,-1,1058,1060,1057,-1,1183,1060,1058,-1,1184,1060,1183,-1,347,669,337,-1,349,669,347,-1,1181,338,2,-1,1181,1059,338,-1,1183,352,722,-1,1183,1058,352,-1,341,351,342,-1,341,907,351,-1,1056,330,1055,-1,330,1056,942,-1,857,993,987,-1,857,794,993,-1,152,322,321,-1,152,856,322,-1,319,1185,809,-1,1185,319,851,-1,85,132,83,-1,741,132,85,-1,310,144,146,-1,310,309,144,-1,306,144,101,-1,144,306,806,-1,174,1186,94,-1,174,115,1186,-1,100,121,955,-1,100,99,121,-1,297,945,946,-1,745,945,297,-1,784,169,177,-1,169,784,1050,-1,751,788,752,-1,1053,788,751,-1,294,1049,782,-1,294,1040,1049,-1,289,1047,1187,-1,1047,289,288,-1,1045,1188,1047,-1,1044,1188,1045,-1,1044,1147,1189,-1,1147,1044,1046,-1,1042,1006,1003,-1,1042,1146,1006,-1,1190,1040,1041,-1,1190,869,1040,-1,1036,1039,1034,-1,1036,296,1039,-1,1036,283,1191,-1,283,1036,284,-1,947,1035,1033,-1,947,284,1035,-1,279,947,759,-1,947,279,282,-1,1029,185,1027,-1,1029,760,185,-1,1032,1132,1031,-1,1135,1132,1032,-1,1030,1128,1028,-1,1131,1128,1030,-1,760,1026,762,-1,760,1029,1026,-1,268,51,824,-1,267,51,268,-1,270,47,271,-1,1024,47,270,-1,56,1192,823,-1,1192,56,821,-1,264,821,272,-1,266,821,264,-1,266,1192,821,-1,765,978,779,-1,978,765,261,-1,960,961,18,-1,1021,961,960,-1,258,26,1193,-1,260,26,258,-1,1022,845,1021,-1,1022,1194,845,-1,252,262,257,-1,252,251,262,-1,831,1193,26,-1,1193,831,846,-1,1022,230,771,-1,254,230,1022,-1,246,252,948,-1,246,253,252,-1,240,61,250,-1,240,239,61,-1,253,71,73,-1,253,246,71,-1,78,861,863,-1,949,861,78,-1,1195,982,979,-1,1016,982,1195,-1,243,1196,244,-1,985,1196,243,-1,234,153,235,-1,234,154,153,-1,160,92,814,-1,92,160,1197,-1,951,219,1012,-1,951,217,219,-1,1087,1198,991,-1,1087,1112,1198,-1,837,834,833,-1,837,843,834,-1,746,297,1010,-1,746,745,297,-1,1041,1199,1190,-1,1041,1002,1199,-1,286,869,1190,-1,286,291,869,-1,781,1200,1007,-1,1200,781,782,-1,199,749,200,-1,749,199,202,-1,206,200,1009,-1,206,201,200,-1,1002,783,1199,-1,1002,1000,783,-1,196,986,197,-1,196,287,986,-1,998,992,1025,-1,997,992,998,-1,758,186,952,-1,278,186,758,-1,1112,1201,1198,-1,1112,1176,1201,-1,997,990,992,-1,988,990,997,-1,180,989,181,-1,180,990,989,-1,815,179,816,-1,179,815,953,-1,736,168,316,-1,168,736,944,-1,171,169,945,-1,171,167,169,-1,957,133,954,-1,133,957,111,-1,738,133,110,-1,853,133,738,-1,852,308,83,-1,852,1202,308,-1,130,109,872,-1,129,109,130,-1,305,302,306,-1,302,305,125,-1,850,305,103,-1,305,850,870,-1,851,117,116,-1,117,851,319,-1,99,122,121,-1,115,122,99,-1,115,117,122,-1,1016,956,984,-1,1195,956,1016,-1,956,1195,1203,-1,216,1186,217,-1,216,94,1186,-1,89,323,90,-1,323,89,312,-1,74,981,75,-1,74,979,981,-1,983,78,77,-1,983,1204,78,-1,1196,72,244,-1,236,72,1196,-1,273,820,52,-1,273,55,820,-1,778,958,327,-1,778,48,958,-1,977,320,829,-1,977,1205,320,-1,842,977,963,-1,848,977,842,-1,39,210,40,-1,39,211,210,-1,973,214,326,-1,973,1206,214,-1,828,1206,1205,-1,971,1206,828,-1,773,225,846,-1,773,226,225,-1,960,255,254,-1,959,255,960,-1,31,832,29,-1,832,31,1207,-1,23,1208,27,-1,23,967,1208,-1,969,1207,31,-1,1207,969,1209,-1,260,834,843,-1,834,260,259,-1,964,847,233,-1,963,847,964,-1,849,972,825,-1,849,804,972,-1,669,836,223,-1,669,349,836,-1,350,836,349,-1,350,22,836,-1,7,1196,818,-1,7,236,1196,-1,11,803,17,-1,11,856,803,-1,517,12,14,-1,976,12,517,-1,16,242,17,-1,16,862,242,-1,965,961,838,-1,965,962,961,-1,1210,966,25,-1,1210,1211,966,-1,1212,30,28,-1,30,1212,968,-1,5,25,24,-1,5,1210,25,-1,1193,970,258,-1,1193,1020,970,-1,37,839,865,-1,36,839,37,-1,321,973,972,-1,973,321,320,-1,971,41,1013,-1,971,42,41,-1,13,975,826,-1,975,13,12,-1,830,974,38,-1,830,975,974,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_8()
		{
			int[] value = {50,978,43,-1,978,50,271,-1,68,85,84,-1,85,68,742,-1,158,862,16,-1,158,863,862,-1,980,1015,1011,-1,980,982,1015,-1,57,867,849,-1,53,867,57,-1,275,801,276,-1,802,801,275,-1,99,1186,115,-1,99,220,1186,-1,159,1197,160,-1,155,1197,159,-1,105,314,110,-1,105,739,314,-1,113,1203,74,-1,956,1203,113,-1,741,309,132,-1,309,741,102,-1,955,96,100,-1,955,871,96,-1,131,127,317,-1,127,131,128,-1,1213,1185,1214,-1,1213,1202,1185,-1,808,274,1213,-1,808,737,274,-1,135,872,954,-1,872,135,812,-1,155,161,1197,-1,155,162,161,-1,170,807,165,-1,141,807,170,-1,304,944,173,-1,304,175,944,-1,800,793,817,-1,800,796,793,-1,197,987,993,-1,987,197,986,-1,1085,991,988,-1,1085,1087,991,-1,794,994,993,-1,794,1215,994,-1,1201,198,994,-1,1201,1216,198,-1,1093,995,868,-1,1095,995,1093,-1,740,1052,1053,-1,740,104,1052,-1,198,1217,193,-1,198,1216,1217,-1,1008,786,785,-1,1008,858,786,-1,1001,299,298,-1,1001,207,299,-1,756,1005,295,-1,756,1003,1005,-1,753,1187,1049,-1,289,1187,753,-1,202,754,203,-1,754,202,859,-1,199,781,859,-1,199,292,781,-1,292,199,201,-1,293,207,1001,-1,293,205,207,-1,181,1215,794,-1,181,989,1215,-1,214,965,35,-1,214,1013,965,-1,980,777,981,-1,980,1012,777,-1,983,951,1011,-1,951,983,215,-1,217,220,219,-1,220,217,1186,-1,29,774,773,-1,29,832,774,-1,1218,233,860,-1,233,1218,964,-1,240,6,238,-1,767,6,240,-1,1219,984,949,-1,1014,984,1219,-1,1014,1016,984,-1,1015,1219,1204,-1,1015,1014,1219,-1,246,1018,247,-1,246,948,1018,-1,249,864,250,-1,251,864,249,-1,1017,1218,860,-1,1194,1218,1017,-1,255,950,227,-1,1019,950,255,-1,248,263,249,-1,263,248,822,-1,1017,865,839,-1,1017,1018,865,-1,959,1019,255,-1,1220,1019,959,-1,840,970,1220,-1,840,844,970,-1,866,44,43,-1,44,866,822,-1,1023,264,269,-1,1024,264,1023,-1,1024,270,264,-1,266,50,49,-1,265,50,266,-1,48,269,958,-1,269,48,1023,-1,55,272,821,-1,55,273,272,-1,1025,1221,998,-1,1025,1026,1221,-1,1029,1221,1026,-1,1029,1028,1221,-1,761,1030,1027,-1,761,1031,1030,-1,1032,278,995,-1,277,278,1032,-1,183,279,952,-1,183,280,279,-1,757,1222,1223,-1,1222,757,1033,-1,1038,1035,1034,-1,1035,1038,1224,-1,190,1225,285,-1,740,1225,190,-1,750,1225,751,-1,750,1191,1225,-1,1173,1226,1217,-1,1226,1173,1227,-1,1228,1045,1048,-1,1043,1045,1228,-1,194,288,290,-1,1226,288,194,-1,1048,288,1226,-1,1189,755,1229,-1,1042,755,1189,-1,1007,1188,1229,-1,1007,1200,1188,-1,1005,1037,1039,-1,1005,1004,1037,-1,176,797,179,-1,175,797,176,-1,946,169,1050,-1,945,169,946,-1,124,855,302,-1,148,855,124,-1,854,943,1051,-1,854,142,943,-1,764,83,308,-1,69,83,764,-1,66,83,69,-1,790,1052,104,-1,790,1051,1052,-1,192,189,313,-1,192,311,189,-1,736,1214,173,-1,735,1214,736,-1,796,802,90,-1,802,796,149,-1,1166,398,900,-1,1166,1069,398,-1,534,903,901,-1,903,534,533,-1,718,343,672,-1,344,343,718,-1,719,726,728,-1,719,513,726,-1,725,1184,724,-1,1060,1184,725,-1,353,1182,723,-1,1057,1182,353,-1,339,725,874,-1,338,725,339,-1,908,341,1061,-1,341,908,907,-1,362,940,1066,-1,361,940,362,-1,678,1054,370,-1,678,1065,1054,-1,974,732,1067,-1,976,732,974,-1,597,1056,364,-1,1056,597,1179,-1,717,367,361,-1,717,1067,367,-1,916,465,1054,-1,916,467,465,-1,384,647,1068,-1,383,647,384,-1,523,881,903,-1,881,523,882,-1,662,1115,1070,-1,662,1120,1115,-1,1072,1077,880,-1,1077,1072,1230,-1,937,690,938,-1,937,933,690,-1,414,932,917,-1,932,414,485,-1,587,934,413,-1,934,587,1073,-1,921,416,415,-1,921,1074,416,-1,884,1076,708,-1,481,1076,884,-1,423,588,605,-1,423,589,588,-1,426,706,705,-1,704,706,426,-1,1078,397,396,-1,397,1078,900,-1,455,435,618,-1,434,435,455,-1,914,458,460,-1,612,458,914,-1,1080,601,445,-1,598,601,1080,-1,1079,417,607,-1,417,1079,1080,-1,1079,592,599,-1,1079,446,592,-1,595,433,593,-1,595,434,433,-1,452,578,888,-1,452,454,578,-1,471,690,933,-1,471,691,690,-1,918,1154,473,-1,1154,918,689,-1,890,928,939,-1,929,928,890,-1,490,682,491,-1,490,932,682,-1,939,1083,1081,-1,928,1083,939,-1,1167,1086,1231,-1,1167,1084,1086,-1,491,1231,1175,-1,491,682,1231,-1,1082,891,1088,-1,681,891,1082,-1,641,1094,1157,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_9()
		{
			int[] value = {1094,641,1092,-1,1177,996,1232,-1,996,1177,999,-1,1083,930,636,-1,1083,928,930,-1,1101,626,623,-1,626,1101,1109,-1,1004,1103,1102,-1,1004,1006,1103,-1,634,495,919,-1,495,634,496,-1,927,1170,497,-1,927,563,1170,-1,896,630,897,-1,896,892,630,-1,637,930,1099,-1,930,637,636,-1,1168,572,571,-1,1168,1110,572,-1,926,711,508,-1,926,1071,711,-1,1114,1115,1113,-1,1115,1114,675,-1,670,512,511,-1,670,726,512,-1,726,670,727,-1,666,656,228,-1,666,668,656,-1,1162,716,521,-1,1163,716,1162,-1,667,1161,668,-1,1063,1161,667,-1,904,538,541,-1,904,657,538,-1,655,1122,1121,-1,720,1122,655,-1,343,1122,728,-1,1122,343,941,-1,394,372,650,-1,394,385,372,-1,645,1124,1159,-1,645,909,1124,-1,648,1124,924,-1,649,1124,648,-1,923,383,877,-1,922,383,923,-1,392,545,415,-1,392,391,545,-1,1232,1233,1234,-1,996,1233,1232,-1,1233,1130,1234,-1,1233,1128,1130,-1,1129,1132,1134,-1,1131,1132,1129,-1,1135,1092,1133,-1,1135,1095,1092,-1,550,1136,551,-1,550,553,1136,-1,1093,1156,1094,-1,1156,1093,1223,-1,1139,1224,1138,-1,1222,1224,1139,-1,1141,560,639,-1,1141,1174,560,-1,1141,628,629,-1,1141,1140,628,-1,1235,632,494,-1,1235,1098,632,-1,1155,1227,1235,-1,1227,1155,1228,-1,1149,1146,1147,-1,1149,1145,1146,-1,1150,1149,1148,-1,1150,1169,1149,-1,1150,1104,1171,-1,1152,1104,1150,-1,1142,911,628,-1,1142,1102,911,-1,1110,475,572,-1,475,1110,936,-1,625,623,626,-1,623,625,913,-1,1154,457,888,-1,1154,689,457,-1,609,459,608,-1,609,578,459,-1,931,887,697,-1,931,1153,887,-1,931,704,707,-1,704,931,706,-1,1082,482,1081,-1,1082,483,482,-1,366,467,916,-1,366,935,467,-1,598,602,601,-1,915,602,598,-1,702,603,698,-1,503,603,702,-1,487,424,423,-1,487,489,424,-1,1096,931,707,-1,1096,1153,931,-1,586,1073,587,-1,1073,586,607,-1,1154,887,1153,-1,1154,888,887,-1,1075,616,615,-1,1075,430,616,-1,429,422,886,-1,429,431,422,-1,620,624,913,-1,624,620,619,-1,889,912,687,-1,625,912,889,-1,936,621,918,-1,936,619,621,-1,1037,1102,1142,-1,1037,1004,1102,-1,1150,1170,1169,-1,1150,1171,1170,-1,920,1149,1169,-1,1149,920,1145,-1,635,494,496,-1,635,1235,494,-1,1235,635,1155,-1,1151,1228,1155,-1,1228,1151,1043,-1,1235,1173,1098,-1,1227,1173,1235,-1,1174,629,569,-1,1174,1141,629,-1,1174,583,560,-1,583,1174,584,-1,1138,1038,1143,-1,1224,1038,1138,-1,1222,1156,1223,-1,1139,1156,1222,-1,1157,1156,1137,-1,1157,1094,1156,-1,641,1133,1092,-1,1133,641,642,-1,1129,551,1136,-1,1129,1134,551,-1,1234,1127,1126,-1,1234,1130,1127,-1,1234,1158,1232,-1,1234,1126,1158,-1,649,389,390,-1,649,644,389,-1,924,877,714,-1,923,877,924,-1,646,1159,377,-1,1159,646,645,-1,390,1124,649,-1,390,1159,1124,-1,390,1125,1159,-1,1068,652,384,-1,537,652,1068,-1,504,1064,875,-1,654,1064,504,-1,1061,729,1160,-1,1061,341,729,-1,1161,721,905,-1,721,1161,1160,-1,1064,1162,345,-1,1064,1163,1162,-1,541,658,904,-1,540,658,541,-1,668,905,656,-1,905,668,1161,-1,1164,1162,521,-1,1162,1164,1123,-1,535,904,659,-1,904,535,657,-1,1163,660,716,-1,1163,906,660,-1,529,401,508,-1,401,529,531,-1,534,663,532,-1,663,534,664,-1,1165,1230,1072,-1,1230,1165,1119,-1,1069,901,881,-1,901,1069,1166,-1,873,1164,521,-1,1055,1164,873,-1,708,693,418,-1,1076,693,708,-1,899,675,1114,-1,899,676,675,-1,382,652,504,-1,382,384,652,-1,672,677,718,-1,672,671,677,-1,1089,484,483,-1,1089,1167,484,-1,895,631,1101,-1,895,897,631,-1,497,893,927,-1,630,893,497,-1,892,893,630,-1,627,686,912,-1,627,1100,686,-1,1171,497,1170,-1,498,497,1171,-1,680,893,571,-1,894,893,680,-1,571,896,1168,-1,571,892,896,-1,627,1109,1107,-1,627,626,1109,-1,1083,633,681,-1,1083,636,633,-1,1175,1232,1158,-1,1232,1175,1177,-1,549,1157,556,-1,1157,549,641,-1,1090,1112,1111,-1,1090,1176,1112,-1,1231,1177,1175,-1,1177,1231,1086,-1,1167,682,484,-1,1167,1231,682,-1,684,939,938,-1,890,939,684,-1,614,617,600,-1,614,479,617,-1,502,689,477,-1,689,502,457,-1,481,695,1076,-1,481,691,695,-1,427,705,699,-1,426,705,427,-1,427,590,428,-1,590,427,447,-1,417,445,883,-1,417,1080,445,-1,885,594,593,-1,594,885,579,-1,421,886,422,-1,421,576,886,-1,440,407,581,-1,408,407,440,-1,701,430,429,-1,701,703,430,-1,1078,1119,1117,-1,1078,1230,1119,-1,1077,1230,1078,-1,1075,420,676,-1,1075,615,420,-1};
			return value;
		}
		private int[] getc4_Geo_8_49_coordIndex_10()
		{
			int[] value = {412,588,413,-1,605,588,412,-1,1120,1113,1115,-1,1120,1165,1113,-1,533,694,470,-1,533,532,694,-1,878,411,712,-1,410,411,878,-1,540,373,658,-1,540,374,373,-1,391,644,545,-1,391,389,644,-1,714,506,715,-1,714,877,506,-1,596,1179,597,-1,596,1178,1179,-1,1179,942,1056,-1,942,1179,368,-1,511,39,363,-1,511,211,39,-1,677,1065,678,-1,677,1180,1065,-1,1180,940,1178,-1,940,1180,1066,-1,667,514,358,-1,667,515,514,-1,905,720,655,-1,720,905,721,-1,723,1181,2,-1,1182,1181,723,-1,1184,722,724,-1,1184,1183,722,-1,728,672,343,-1,728,727,672,-1,903,470,730,-1,903,533,470,-1,732,517,516,-1,517,732,976,-1,332,696,730,-1,332,935,696,-1,1069,399,398,-1,1069,526,399,-1,1214,851,173,-1,1214,1185,851,-1,106,790,104,-1,108,790,106,-1,854,790,107,-1,854,1051,790,-1,145,137,146,-1,145,743,137,-1,871,97,96,-1,871,870,97,-1,1000,784,783,-1,1050,784,1000,-1,798,1010,748,-1,746,1010,798,-1,295,1039,296,-1,295,1005,1039,-1,1187,1188,1200,-1,1188,1187,1047,-1,1189,1188,1044,-1,1189,1229,1188,-1,1146,1189,1147,-1,1146,1042,1189,-1,1227,1048,1226,-1,1228,1048,1227,-1,193,1226,194,-1,193,1217,1226,-1,296,1191,750,-1,296,1036,1191,-1,285,1191,283,-1,285,1225,1191,-1,1224,1033,1035,-1,1033,1224,1222,-1,757,1093,868,-1,1223,1093,757,-1,1027,184,761,-1,1027,185,184,-1,995,1135,1032,-1,995,1095,1135,-1,1132,1030,1031,-1,1030,1132,1131,-1,1028,1233,1221,-1,1028,1128,1233,-1,1233,998,1221,-1,998,1233,996,-1,958,268,824,-1,268,958,269,-1,1192,49,823,-1,266,49,1192,-1,264,267,269,-1,264,272,267,-1,766,257,765,-1,766,256,257,-1,1220,18,840,-1,959,18,1220,-1,1220,1020,1019,-1,970,1020,1220,-1,839,1194,1017,-1,845,1194,839,-1,865,948,256,-1,948,865,1018,-1,1194,771,1218,-1,1022,771,1194,-1,767,250,864,-1,767,240,250,-1,76,768,237,-1,768,76,75,-1,1204,949,78,-1,1219,949,1204,-1,769,72,71,-1,72,769,234,-1,770,1218,771,-1,964,1218,770,-1,227,224,228,-1,227,950,224,-1,775,41,210,-1,776,41,775,-1,962,41,776,-1,814,79,160,-1,814,77,79,-1,1012,218,777,-1,1012,219,218,-1,991,1215,989,-1,1198,1215,991,-1,1010,299,1009,-1,1010,297,299,-1,1041,1001,1002,-1,1041,293,1001,-1,1229,754,1007,-1,1229,755,754,-1,1008,1190,1199,-1,1008,286,1190,-1,752,749,204,-1,752,789,749,-1,782,1187,1200,-1,1187,782,1049,-1,203,295,204,-1,203,756,295,-1,207,1009,299,-1,207,206,1009,-1,1199,858,1008,-1,1199,783,858,-1,1172,1217,1216,-1,1172,1173,1217,-1,1053,1225,740,-1,1225,1053,751,-1,763,992,791,-1,992,763,1025,-1,1176,1216,1201,-1,1176,1172,1216,-1,1198,994,1215,-1,1198,1201,994,-1,999,988,997,-1,1085,988,999,-1,817,987,815,-1,817,857,987,-1,793,857,817,-1,793,182,857,-1,797,816,179,-1,163,816,797,-1,944,169,168,-1,169,944,177,-1,163,157,800,-1,163,162,157,-1,954,109,957,-1,954,872,109,-1,735,1213,1214,-1,735,808,1213,-1,308,1213,274,-1,1202,1213,308,-1,809,1202,852,-1,1202,809,1185,-1,806,302,855,-1,302,806,306,-1,108,111,957,-1,111,108,106,-1,89,313,312,-1,89,315,313,-1,1197,93,92,-1,93,1197,161,-1,307,867,764,-1,307,276,867,-1,802,91,90,-1,275,91,802,-1,870,82,97,-1,82,870,850,-1,1203,979,74,-1,1195,979,1203,-1,1011,1204,983,-1,1011,1015,1204,-1,244,153,242,-1,235,153,244,-1,824,328,958,-1,824,825,328,-1,856,10,322,-1,856,11,10,-1,848,1205,977,-1,848,828,1205,-1,13,848,842,-1,826,848,13,-1,1206,1013,214,-1,1206,971,1013,-1,1205,973,320,-1,1206,973,1205,-1,846,1020,1193,-1,846,225,1020,-1,967,1212,1208,-1,967,968,1212,-1,967,969,968,-1,967,1209,969,-1,967,1211,1209,-1,1211,967,966,-1,832,1210,5,-1,832,1207,1210,-1,841,21,833,-1,223,21,841,-1,836,21,223,-1,27,1212,28,-1,27,1208,1212,-1,1207,1211,1210,-1,1207,1209,1211,-1,834,844,835,-1,834,259,844,-1,10,233,847,-1,233,10,9,-1,818,985,112,-1,818,1196,985,-1,3,350,679,-1,350,3,22,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc4_Coord_9_49_point_1()
		{
			double[] value = {-.22437,53.79685,-2.11766,-.18684,53.8298,-2.14655,-.21356,53.77437,-2.17786,.00565,53.81727,-2.05914,.00699,53.83348,-2.06093,.07212,53.73799,-2.12656,.78023,54.29529,-1.46957,.74022,54.37685,-1.44992,.83868,54.41628,-1.43282,.41988,54.32903,-1.4452,.41602,54.32457,-1.44236,.44186,54.32361,-1.39244,.08778,54.22777,-1.70959,.18627,54.24464,-1.66405,.08885,54.23197,-1.71521,.48051,54.31519,-1.264,.44289,54.42374,-1.28841,.44241,54.39747,-1.31636,.22019,53.8236,-1.78525,.21214,53.81995,-1.78603,.19458,53.77844,-1.88053,.03477,53.74762,-2.05196,.00531,53.77223,-2.03547,.1322,53.7086,-2.15938,.07046,53.70826,-2.117,.11926,53.71406,-2.16051,.22437,53.79685,-2.11766,.21544,53.72265,-2.16461,.21356,53.77437,-2.17786,.17398,53.82843,-2.14598,.17757,53.79049,-2.18131,.17045,53.78793,-2.18051,0.0,54.05855,-1.93332,.05582,53.93838,-2.00816,0.0,53.93653,-2.00848,.39364,53.85273,-1.55447,.40334,53.8559,-1.58133,.47713,53.85215,-1.53376,0.0,54.10121,-1.78156,0.0,54.0351,-1.82818,.1105,54.04751,-1.77692,.22268,53.95371,-1.72084,.2135,54.02941,-1.71543,.87794,53.84084,-1.39909,.91556,53.97344,-1.34568,.89405,53.93263,-1.31461,.66197,53.77147,-1.47585,.67271,53.77226,-1.47029,.57567,53.78669,-1.44352,.88661,53.92725,-1.31299,.87352,53.83807,-1.39423,.57463,53.97579,-1.28554,.63201,54.01498,-1.23959,.56926,53.98414,-1.28062,.73543,54.01999,-1.22963,.68912,54.01252,-1.23617,.73487,54.01156,-1.23701,.56876,53.98445,-1.28127,.88873,54.03593,-1.27883,.8542,54.00644,-1.25627,.85205,54.18959,-1.27399,.85305,54.19541,-1.28601,.84856,54.19528,-1.27302,.80917,54.08622,-1.21537,.83744,54.09823,-1.2316,.774,54.13306,-1.1964,.69026,54.06019,-1.17243,.70503,54.06765,-1.18006,.71255,54.07681,-1.15943,.67949,54.04572,-1.19307,.70534,54.05168,-1.19487,.57941,54.22123,-1.49312,.53374,54.35242,-1.40028,.67143,54.24694,-1.48179,.89321,54.55823,-1.2147,.89799,54.55434,-1.21087,.90755,54.50024,-1.32811,.51725,54.49329,-1.18674,.52004,54.49669,-1.19227,.5166,54.49312,-1.18707,.75267,54.12628,-1.18748,.76585,54.14647,-1.18882,.76267,54.13983,-1.17687,.65072,54.10835,-1.1175,.70145,54.0745,-1.15429,.70741,54.07664,-1.14031,.3418,54.07939,-1.17008,.36042,54.08072,-1.15581,.35609,54.03512,-1.15207,.40774,54.0823,-1.11874,.40739,54.09068,-1.12812,.42136,54.08483,-1.12693,.51695,54.38733,-1.15673,.49935,54.37485,-1.14008,.56354,54.36194,-1.14498,.79999,54.23929,-1.17418,.77684,54.32239,-1.13348,.80146,54.22961,-1.16239,.7682,54.34489,-1.1339,.70508,54.33425,-1.12166};
			return value;
		}
		private double[] getc4_Coord_9_49_point_2()
		{
			double[] value = {.76436,54.33216,-1.12751,.80315,54.04964,-.96177,.77122,54.01381,-1.01765,.81932,54.06282,-1.02156,.41634,54.11962,-.88533,.433,54.07283,-.93808,.45873,54.08208,-.93622,.61746,54.10614,-.92731,.51933,54.10557,-.93397,.61756,54.10904,-.935,.44071,54.07523,-.94619,.45783,54.08362,-.94075,.78505,54.44696,-1.35317,.90114,54.50496,-1.32902,.83272,54.42636,-1.43224,.65055,54.32055,-1.12898,.56813,54.28231,-1.11185,.63238,54.27559,-1.10121,.65178,54.20936,-.95491,.65814,54.21713,-.95463,.68421,54.19875,-.99388,.7233,54.24313,-1.07184,.64117,54.26834,-1.09565,.6801,54.21422,-1.04921,.7436,54.17388,-1.00644,.83036,54.1455,-1.01393,.6497,54.1803,-.95539,.66795,54.1793,-.98897,.66493,54.14257,-.9883,.64882,54.09629,-.95567,.65048,54.15533,-.95444,.66905,54.12584,-1.02749,.67761,54.07106,-1.01731,.46103,54.13818,-.94505,.48293,54.20446,-.94775,.53738,54.22358,-.93118,.65443,54.07805,-.93927,.66671,54.14906,-.89387,.70222,54.25536,-.88585,.64963,54.25459,-.93085,.65716,54.28174,-.88621,.59433,54.29029,-.88293,.62327,54.22721,-.89184,.65487,54.28186,-.87721,.77361,54.07912,-.9267,.73582,54.18924,-.89657,.71909,54.11686,-.90024,.68951,54.23122,-.92096,.72965,54.17437,-.95457,.48148,54.19777,-1.1902,.48888,54.24246,-1.25118,.5029,54.15894,-1.23856,.49377,54.18676,-1.32411,.45277,54.38778,-1.32992,.44589,54.32713,-1.39629,.49046,54.35479,-1.17835,.49041,54.28589,-1.19346,.48375,54.28863,-1.17938,.46524,54.46159,-1.24371,.49513,54.35842,-1.20459,.51823,54.41622,-1.17105,.48869,54.37673,-1.15291,.48166,54.35512,-1.166,.46,54.35964,-1.15597,.5034,54.27111,-.94877,.53717,54.32365,-.8959,.54591,54.28466,-.92793,.5136,54.38256,-.94043,.49536,54.35669,-.98389,.50842,54.44201,-.97327,.54077,54.31818,-.88279,.51543,54.38522,-.89328,.50514,54.38042,-.867,.51881,54.30686,-1.08806,.56598,54.31948,-1.12731,.48648,54.39031,-1.10688,.47425,54.42323,-1.10892,.48504,54.42597,-1.06425,.45815,54.50691,-1.13007,.45406,54.43966,-1.15484,.29093,54.03794,-1.2107,.28193,54.14311,-1.20727,.33739,54.17129,-1.18281,.29037,53.92458,-.86006,.27706,53.92035,-.86378,.2702,53.94009,-.95659,.24985,53.8894,-.77883,.3352,53.94743,-1.05899,.34626,53.94324,-1.14164,.34594,53.95519,-1.05799,.34708,54.07852,-.86996,.32672,54.03512,-.88381,.35725,54.03167,-.95365,.18335,54.43412,-1.19146,.18765,54.42188,-1.12748,.20145,54.42433,-1.13045,.25706,54.46458,-1.21152,.25953,54.45756,-1.21805,.18196,54.42789,-1.1991,.31187,54.40671,-.76777};
			return value;
		}
		private double[] getc4_Coord_9_49_point_3()
		{
			double[] value = {.33522,54.43028,-.76181,.3289,54.43461,-.76974,.27592,54.33704,-.76357,.26478,54.32786,-.76083,.27263,54.31795,-.75641,.38127,54.48579,-.81543,.36854,54.47928,-.77995,.41848,54.5097,-.8032,.90463,54.05328,-1.30381,.06362,53.89364,-1.85132,.10938,53.97386,-1.81597,0.0,53.96788,-1.86823,.57107,53.7989,-1.4891,.45959,53.85384,-1.48875,.36741,53.94525,-1.55457,.58027,54.44268,-1.14125,.57047,54.39224,-1.14744,.66077,54.39596,-1.13497,.79045,54.40291,-1.14153,.71899,54.40639,-1.11541,.70543,54.3482,-1.12462,.07083,53.82211,-1.89717,0.0,53.82912,-1.95153,.00702,53.78154,-1.98043,.0903,54.04346,-1.92562,.16431,53.94449,-2.01224,.1448,53.94778,-2.01555,.15692,54.08095,-1.84415,0.0,54.13829,-1.86295,0.0,54.19572,-1.81361,.22533,54.13477,-1.75101,.11659,54.17256,-1.79646,.43109,54.32382,-1.48035,.38075,54.30689,-1.49875,.47028,54.30729,-1.43421,.5245,54.351,-1.39626,.66288,54.35554,-1.43886,.91422,54.37176,-1.31347,.87052,54.32129,-1.41237,.85388,54.24466,-1.29321,.84764,54.22592,-1.38705,.8889,54.31336,-1.3044,.44776,54.40608,-1.31884,.57652,54.42386,-1.32671,.52941,54.36254,-1.39428,.86989,54.37316,-1.2046,.58959,54.1647,-1.50311,.51473,54.17979,-1.51081,.90243,54.05815,-1.32757,.83452,54.06616,-1.40526,.84893,54.16433,-1.37723,.73907,54.05442,-1.47439,.67562,54.06647,-1.49387,.67398,54.14898,-1.49346,.24911,54.02154,-1.77206,.21477,53.99298,-1.83441,.58152,53.94346,-1.52429,.66944,53.94648,-1.52413,.21322,53.78957,-2.01862,.2084,53.75435,-2.01131,.21954,53.74386,-2.05702,.78284,53.86095,-1.49852,.75998,53.95498,-1.48251,.85792,53.95702,-1.43237,.71257,53.88077,-1.368,.79918,53.86291,-1.37179,.80671,53.90823,-1.33617,.63234,53.9308,-1.32722,.60552,53.9027,-1.35491,.59762,53.85772,-1.39038,.74621,53.83548,-1.41751,.78454,53.78754,-1.45501,.68004,53.95471,-1.30929,.63704,54.00763,-1.24663,.49989,54.10197,-1.14847,.48316,54.0926,-1.17847,.51872,54.07786,-1.21536,.18575,53.8638,-.77509,.17928,53.84623,-.72385,.24887,53.94755,-.75738,.2838,53.96233,-.82448,.27439,54.02767,-.80054,.23148,54.01217,-.74302,.2239,54.06833,-.74318,.1802,54.05763,-.69441,.28055,54.08819,-.80212,.34337,54.51421,-1.14957,.32145,54.51372,-1.20328,.16505,54.40484,-1.04964,.23353,54.41166,-1.05602,.19325,54.41885,-1.11685,.26427,54.46558,-1.15549,.33135,54.43583,-.82866,.40381,54.49847,-.88495,.3298,54.441,-.89508,.17236,54.29663,-.70089,.19379,54.20345,-.69014,.44754,54.48013,-.79545,.47735,54.54141,-.87189,.42683,54.50643,-.79667};
			return value;
		}
		private double[] getc4_Coord_9_49_point_4()
		{
			double[] value = {.82577,54.28771,-1.22298,.77909,54.33204,-1.1427,.82504,54.11954,-.97522,.69986,54.2525,-.87859,.50762,54.34469,-1.11806,.83738,54.13638,-1.01602,.82889,54.1118,-.97194,.54888,54.0807,-1.18301,.57799,54.11377,-1.14426,.74019,54.01904,-.97783,.69364,54.0504,-.95613,.31618,53.9665,-.95662,.37475,54.02801,-1.11314,.38524,54.03621,-1.03228,.39695,54.05736,-.95302,.42076,54.08305,-1.02832,.47055,54.2646,-.99183,.66808,54.18142,-1.03955,.6732,54.20827,-1.0506,.63158,54.2651,-1.10012,.40312,54.12608,-1.49069,.45132,54.12448,-1.41379,.43317,54.22951,-1.44142,.36982,54.0289,-1.12671,.35289,53.95672,-1.13634,.35147,53.94919,-1.15387,.41788,53.94212,-1.47615,.4986,53.84099,-1.40858,.49963,53.84837,-1.40461,-.18778,54.24674,-1.66792,-.27173,54.26602,-1.61062,-.18627,54.24464,-1.66405,-.48186,54.30577,-1.28092,-.48051,54.31519,-1.264,-.48888,54.24246,-1.25118,-.07083,53.82211,-1.89717,-.19458,53.77844,-1.88053,-.07368,53.7625,-1.96436,-.21544,53.72265,-2.16461,-.21387,53.73247,-2.06711,-.21954,53.74386,-2.05702,-.19497,53.767,-1.95622,-.1865,53.75991,-1.95531,-.33367,53.86681,-1.6318,-.40334,53.8559,-1.58133,-.41957,53.96887,-1.58259,-.07046,53.70826,-2.117,-.03477,53.74762,-2.05196,-.07953,53.73064,-2.03458,-.00599,53.77736,-1.99415,-.00531,53.77223,-2.03547,-.2001,53.74614,-2.01123,-.13702,53.75944,-2.1725,-.17045,53.78793,-2.18051,-.17398,53.82843,-2.14598,-.11215,53.79473,-2.12995,-.07808,53.86077,-2.06472,-.07212,53.73799,-2.12656,-.17116,53.89244,-2.0822,-.00699,53.83348,-2.06093,-.05582,53.93838,-2.00816,-.20431,54.104,-1.70338,-.2135,54.02941,-1.71543,-.1105,54.04751,-1.77692,-.37892,54.3058,-1.49564,-.41602,54.32457,-1.44236,-.43317,54.22951,-1.44142,-.19513,54.17674,-1.68024,-.27952,54.18814,-1.61395,-.56876,53.98445,-1.28127,-.48761,53.9144,-1.35853,-.54155,54.06076,-1.2612,-.88873,54.03593,-1.27883,-.90463,54.05328,-1.30381,-.91556,53.97344,-1.34568,-.57463,53.97579,-1.28554,-.49532,53.90884,-1.35531,-.88661,53.92725,-1.31299,-.84653,53.99975,-1.25727,-.89405,53.93263,-1.31461,-.73487,54.01156,-1.23701,-.73543,54.01999,-1.22963,-.66197,53.77147,-1.47585,-.67271,53.77226,-1.47029,-.67218,53.77336,-1.47694,-.83744,54.09823,-1.2316,-.774,54.13306,-1.1964,-.85205,54.18959,-1.27399,-.85305,54.19541,-1.28601,-.68912,54.01252,-1.23617,-.7356,53.95684,-1.29365,-.68756,54.01962,-1.22755,-.67949,54.04572,-1.19307,-.70534,54.05168,-1.19487,-.80917,54.08622,-1.21537,-.90755,54.50024,-1.32811,-.90114,54.50496,-1.32902,-.83272,54.42636,-1.43224,-.74123,54.38911,-1.44584,-.74022,54.37685,-1.44992};
			return value;
		}
		private double[] getc4_Coord_9_49_point_5()
		{
			double[] value = {-.83868,54.41628,-1.43282,-.86989,54.37316,-1.2046,-.82577,54.28771,-1.22298,-.77909,54.33204,-1.1427,-.79999,54.23929,-1.17418,-.76585,54.14647,-1.18882,-.76267,54.13983,-1.17687,-.72989,54.05062,-1.07411,-.77122,54.01381,-1.01765,-.82054,54.09776,-1.09483,-.71771,54.07878,-1.14566,-.71255,54.07681,-1.15943,-.36982,54.0289,-1.12671,-.40739,54.09068,-1.12812,-.36042,54.08072,-1.15581,-.59401,54.0471,-1.21366,-.54888,54.0807,-1.18301,-.57799,54.11377,-1.14426,-.52774,54.42028,-1.16649,-.58027,54.44268,-1.14125,-.57047,54.39224,-1.14744,-.77684,54.32239,-1.13348,-.76436,54.33216,-1.12751,-.38524,54.03621,-1.03228,-.35725,54.03167,-.95365,-.39695,54.05736,-.95302,-.45783,54.08362,-.94075,-.46103,54.13818,-.94505,-.44071,54.07523,-.94619,-.7233,54.24313,-1.07184,-.65055,54.32055,-1.12898,-.70508,54.33425,-1.12166,-.61025,54.21641,-.93275,-.61191,54.20529,-.93326,-.65178,54.20936,-.95491,-.67808,54.19598,-.99417,-.6732,54.20827,-1.0506,-.6801,54.21422,-1.04921,-.77361,54.07912,-.9267,-.80315,54.04964,-.96177,-.74019,54.01904,-.97783,-.66493,54.14257,-.9883,-.66808,54.18142,-1.03955,-.66795,54.1793,-.98897,-.66905,54.12584,-1.02749,-.64496,54.16247,-1.11097,-.46353,54.16475,-1.07455,-.44268,54.15002,-1.01432,-.45667,54.20731,-1.00326,-.64963,54.25459,-.93085,-.59854,54.27106,-.93094,-.6526,54.22161,-.95128,-.65487,54.28186,-.87721,-.70222,54.25536,-.88585,-.69986,54.2525,-.87859,-.65814,54.21713,-.95463,-.65716,54.28174,-.88621,-.59433,54.29029,-.88293,-.79046,54.12682,-.93798,-.73582,54.18924,-.89657,-.78453,54.13768,-.94321,-.68951,54.23122,-.92096,-.73914,54.19725,-.90415,-.49513,54.35842,-1.20459,-.49041,54.28589,-1.19346,-.51893,54.1204,-1.29098,-.51102,54.0883,-1.22968,-.49377,54.18676,-1.32411,-.5029,54.15894,-1.23856,-.48148,54.19777,-1.1902,-.44289,54.42374,-1.28841,-.48375,54.28863,-1.17938,-.4308,54.17958,-1.15047,-.45009,54.26019,-.85376,-.38109,54.29287,-.81853,-.416,54.38718,-.80009,-.51626,54.34017,-.9399,-.53717,54.32365,-.8959,-.51543,54.38522,-.89328,-.48648,54.39031,-1.10688,-.4695,54.39892,-1.14799,-.48869,54.37673,-1.15291,-.33753,54.28723,-1.19579,-.27459,54.24846,-1.20902,-.28193,54.14311,-1.20727,-.3418,54.07939,-1.17008,-.37062,54.18526,-1.16678,-.34594,53.95519,-1.05799,-.3352,53.94743,-1.05899,-.31618,53.9665,-.95662,-.35147,53.94919,-1.15387,-.29872,53.9338,-1.20888,-.34626,53.94324,-1.14164,-.35289,53.95672,-1.13634,-.18765,54.42188,-1.12748,-.20145,54.42433,-1.13045,-.19325,54.41885,-1.11685,-.28627,54.36779,-.83663,-.28292,54.38732,-.89576,-.3298,54.441,-.89508};
			return value;
		}
		private double[] getc4_Coord_9_49_point_6()
		{
			double[] value = {-.7436,54.17388,-1.00644,-.72965,54.17437,-.95457,-.59417,54.29223,-.8922,-.54591,54.28466,-.92793,-.58406,53.8458,-1.53576,-.57107,53.7989,-1.4891,-.57084,53.78308,-1.45188,-.45959,53.85384,-1.48875,-.90803,54.44114,-1.20365,-.79045,54.40291,-1.14153,-.06362,53.89364,-1.85132,-.10938,53.97386,-1.81597,-.12752,53.88678,-1.82261,-.21214,53.81995,-1.78603,-.15245,53.89826,-2.07945,-.1448,53.94778,-2.01555,-.08885,54.23197,-1.71521,0.0,54.23598,-1.72233,-.11659,54.17256,-1.79646,-.22533,54.13477,-1.75101,-.43109,54.32382,-1.48035,-.44966,54.21576,-1.54157,-.50516,54.21917,-1.49724,-.45277,54.38778,-1.32992,-.44589,54.32713,-1.39629,-.47028,54.30729,-1.43421,-.66288,54.35554,-1.43886,-.53374,54.35242,-1.40028,-.67143,54.24694,-1.48179,-.91422,54.37176,-1.31347,-.84764,54.22592,-1.38705,-.8889,54.31336,-1.3044,-.46902,54.46553,-1.2473,-.44739,54.42944,-1.29092,-.56803,54.45165,-1.28266,-.74579,54.159,-1.45545,-.67398,54.14898,-1.49346,-.78284,53.86095,-1.49852,-.75998,53.95498,-1.48251,-.66944,53.94648,-1.52413,-.90924,53.97594,-1.36715,-.85792,53.95702,-1.43237,-.8707,53.88662,-1.43288,-.85388,54.24466,-1.29321,-.84856,54.19528,-1.27302,-.63201,54.01498,-1.23959,-.56926,53.98414,-1.28062,-.29523,53.92716,-1.2016,-.2876,53.93529,-1.13933,-.24985,53.8894,-.77883,-.27706,53.92035,-.86378,-.19544,53.91288,-.85463,-.27165,53.9382,-1.04951,-.2702,53.94009,-.95659,-.2838,53.96233,-.82448,-.29037,53.92458,-.86006,-.25535,53.89667,-.77227,-.32672,54.03512,-.88381,-.308,53.96259,-.91339,-.23148,54.01217,-.74302,-.28055,54.08819,-.80212,-.27439,54.02767,-.80054,-.16678,54.30671,-.70798,-.26441,54.34203,-.78124,-.26478,54.32786,-.76083,-.26427,54.46558,-1.15549,-.29041,54.46078,-1.07599,-.27263,54.31795,-.75641,-.32404,54.31372,-.76491,-.31086,54.23058,-.78534,-.3285,54.32814,-.76292,-.33522,54.43028,-.76181,-.36649,54.41095,-.76048,-.5136,54.38256,-.94043,-.49536,54.35669,-.98389,-.83738,54.13638,-1.01602,-.82065,54.2358,-1.08524,-.83727,54.17849,-1.09111,-.67982,54.20751,-.88886,-.64882,54.09629,-.95567,-.65443,54.07805,-.93927,-.67761,54.07106,-1.01731,-.433,54.07283,-.93808,-.34708,54.07852,-.86996,-.35532,54.12507,-.85634,-.39187,54.05637,-.94319,-.45399,54.10419,-1.09786,-.42136,54.08483,-1.12693,-.40774,54.0823,-1.11874,-.42076,54.08305,-1.02832,-.42857,54.09335,-1.02746,-.4678,54.279,-1.03679,-.46567,54.22188,-1.05567,-.61507,54.16834,-.93539,-.65048,54.15533,-.95444,-.6497,54.1803,-.95539,-.40312,54.12608,-1.49069,-.3857,54.21842,-1.49053,-.57162,54.2226,-1.12118,-.51251,54.23857,-1.10819};
			return value;
		}
		private double[] getc4_Coord_9_49_point_7()
		{
			double[] value = {-.51881,54.30686,-1.08806,-.63921,54.21659,-1.10443,-.63158,54.2651,-1.10012,-.5034,54.27111,-.94877,-.47055,54.2646,-.99183,-.37475,54.02801,-1.11314,-.69364,54.0504,-.95613,-.49989,54.10197,-1.14847,-.71909,54.11686,-.90024,-.66671,54.14906,-.89387,-.70503,54.06765,-1.18006,-.75267,54.12628,-1.18748,-.82889,54.1118,-.97194,-.81932,54.06282,-1.02156,-.48509,54.37791,-1.05635,-.56354,54.36194,-1.14498,-.56598,54.31948,-1.12731,-.50762,54.34469,-1.11806,-.68421,54.19875,-.99388,-.47345,54.43111,-.82538,-.50406,54.44753,-.87791,-.50514,54.38042,-.867,-.42683,54.50643,-.79667,-.47735,54.54141,-.87189,-.44754,54.48013,-.79545,-.49948,54.51415,-.96956,-.47747,54.56316,-.96553,-.45894,54.572,-1.07776,-.19379,54.20345,-.69014,-.25232,54.21716,-.73763,-.33135,54.43583,-.82866,-.40381,54.49847,-.88495,-.18335,54.43412,-1.19146,-.25706,54.46458,-1.21152,-.23353,54.41166,-1.05602,-.16505,54.40484,-1.04964,-.32145,54.51372,-1.20328,-.34337,54.51421,-1.14957,-.17316,53.99063,-.69323,-.2239,54.06833,-.74318,-.24887,53.94755,-.75738,-.17928,53.84623,-.72385,-.18575,53.8638,-.77509,-.63234,53.9308,-1.32722,-.63704,54.00763,-1.24663,-.79918,53.86291,-1.37179,-.87352,53.83807,-1.39423,-.78454,53.78754,-1.45501,-.60552,53.9027,-1.35491,-.68004,53.95471,-1.30929,-.84706,54.00895,-1.25185,-.8542,54.00644,-1.25627,-.67149,53.84314,-1.52437,-.67562,54.06647,-1.49387,-.58152,53.94346,-1.52429,-.24911,54.02154,-1.77206,-.15692,54.08095,-1.84415,-.73907,54.05442,-1.47439,-.90243,54.05815,-1.32757,-.84893,54.16433,-1.37723,-.58959,54.1647,-1.50311,-.57941,54.22123,-1.49312,-.58022,54.5141,-1.16124,-.52004,54.49669,-1.19227,-.59945,54.47928,-1.23531,-.87052,54.32129,-1.41237,-.0903,54.04346,-1.92562,-.16431,53.94449,-2.01224,-.15429,54.01631,-1.91725,-.00702,53.78154,-1.98043,-.22268,53.95371,-1.72084,-.31058,53.94225,-1.62629,-.32516,53.86702,-1.62721,-.7682,54.34489,-1.1339,-.70543,54.3482,-1.12462,-.65402,54.4584,-1.11091,-.66077,54.39596,-1.13497,-.36741,53.94525,-1.55457,-.41788,53.94212,-1.47615,-.00565,53.81727,-2.05914,-.28422,54.33204,-.75717,-.25953,54.45756,-1.21805,-.29093,54.03794,-1.2107,-.33739,54.17129,-1.18281,-.45406,54.43966,-1.15484,-.47425,54.42323,-1.10892,-.45815,54.50691,-1.13007,-.48504,54.42597,-1.06425,-.56813,54.28231,-1.11185,-.54077,54.31818,-.88279,-.46,54.35964,-1.15597,-.48166,54.35512,-1.166,-.5166,54.49312,-1.18707,-.51823,54.41622,-1.17105,-.46524,54.46159,-1.24371,-.49046,54.35479,-1.17835,-.44186,54.32361,-1.39244,-.61746,54.10614,-.92731,-.48293,54.20446,-.94775,-.52885,54.1625,-.93443};
			return value;
		}
		private double[] getc4_Coord_9_49_point_8()
		{
			double[] value = {-.83036,54.1455,-1.01393,-.64117,54.26834,-1.09565,-.53738,54.22358,-.93118,-.63238,54.27559,-1.10121,-.45873,54.08208,-.93622,-.52119,54.10768,-.93735,-.51933,54.10557,-.93397,-.41634,54.11962,-.88533,-.51695,54.38733,-1.15673,-.80146,54.22961,-1.16239,-.51725,54.49329,-1.18674,-.89799,54.55434,-1.21087,-.70145,54.0745,-1.15429,-.49963,53.84837,-1.40461,-.50627,53.84291,-1.40147,-.4986,53.84099,-1.40858,-.51473,54.17979,-1.51081,-.10306,54.11105,-1.75343,-.39364,53.85273,-1.55447,-.22019,53.8236,-1.78525,-.24629,53.91348,-1.78285,-.23784,53.90746,-1.80423,-.11689,53.73103,-2.16481,-.17757,53.79049,-2.18131,-.11926,53.71406,-2.16051,-.1322,53.7086,-2.15938,-.24536,53.84988,-1.74018,-.25153,53.85446,-1.73348,-.25404,53.85436,-1.73727,-.2025,53.78334,-1.88053,-.44241,54.39747,-1.31636,-.41988,54.32903,-1.4452,-.08778,54.22777,-1.70959,-.78023,54.29529,-1.46957,.45667,54.20731,-1.00326,.46567,54.22188,-1.05567,.4678,54.279,-1.03679,.45399,54.10419,-1.09786,.42857,54.09335,-1.02746,.39187,54.05637,-.94319,.35532,54.12507,-.85634,.72989,54.05062,-1.07411,.71771,54.07878,-1.14566,.67982,54.20751,-.88886,.51626,54.34017,-.9399,.47345,54.43111,-.82538,.44472,54.40915,-.81273,.48839,54.34248,-.86157,.36649,54.41095,-.76048,.28422,54.33204,-.75717,.25232,54.21716,-.73763,.31086,54.23058,-.78534,.32404,54.31372,-.76491,.24593,54.41739,-1.06079,.26441,54.34203,-.78124,.15693,54.32574,-.74834,.16678,54.30671,-.70798,.08436,53.88313,-.66532,.18159,53.85198,-.71457,.18742,53.91333,-.70478,.27165,53.9382,-1.04951,.19544,53.91288,-.85463,.2876,53.93529,-1.13933,.29523,53.92716,-1.2016,.59401,54.0471,-1.21366,.67149,53.84314,-1.52437,.58406,53.8458,-1.53576,.77235,54.23125,-1.45554,.90803,54.44114,-1.20365,.50516,54.21917,-1.49724,.27173,54.26602,-1.61062,.29259,54.15678,-1.68138,.18778,54.24674,-1.66792,.15245,53.89826,-2.07945,.07808,53.86077,-2.06472,.12752,53.88678,-1.82261,.24536,53.84988,-1.74018,.82219,54.47086,-1.11968,.57084,53.78308,-1.45188,.67218,53.77336,-1.47694,.59854,54.27106,-.93094,.28627,54.36779,-.83663,.28292,54.38732,-.89576,.45894,54.572,-1.07776,.47944,54.50852,-1.07563,.39039,54.54566,-1.17534,.40292,54.54481,-1.17581,.3932,54.53981,-1.18135,.38109,54.29287,-.81853,.3285,54.32814,-.76292,.51447,54.12593,-.9158,.29872,53.9338,-1.20888,.308,53.96259,-.91339,.37062,54.18526,-1.16678,.27459,54.24846,-1.20902,.345,54.04369,-1.1668,.4308,54.17958,-1.15047,.4695,54.39892,-1.14799,.416,54.38718,-.80009,.45009,54.26019,-.85376};
			return value;
		}
		private double[] getc4_Coord_9_49_point_9()
		{
			double[] value = {.44105,54.28562,-1.15751,.51102,54.0883,-1.22968,.47601,54.10214,-1.18707,.48186,54.30577,-1.28092,.51893,54.1204,-1.29098,.73914,54.19725,-.90415,.79046,54.12682,-.93798,.59417,54.29223,-.8922,.46353,54.16475,-1.07455,.63921,54.21659,-1.10443,.67808,54.19598,-.99417,.6526,54.22161,-.95128,.61191,54.20529,-.93326,.61025,54.21641,-.93275,.52774,54.42028,-1.16649,.39172,54.46964,-1.1925,.4294,54.39293,-1.16653,.38279,54.30895,-1.18166,.74123,54.38911,-1.44584,.84706,54.00895,-1.25185,.68756,54.01962,-1.22755,.7356,53.95684,-1.29365,.90924,53.97594,-1.36715,.84653,53.99975,-1.25727,.49532,53.90884,-1.35531,.48761,53.9144,-1.35853,.19513,54.17674,-1.68024,.20431,54.104,-1.70338,.29096,54.10602,-1.61919,.3857,54.21842,-1.49053,.10306,54.11105,-1.75343,.18684,53.8298,-2.14655,.11215,53.79473,-2.12995,.07953,53.73064,-2.03458,.2001,53.74614,-2.01123,.1865,53.75991,-1.95531,.00599,53.77736,-1.99415,.10191,53.70931,-2.10459,.33367,53.86681,-1.6318,.41957,53.96887,-1.58259,.2025,53.78334,-1.88053,.07368,53.7625,-1.96436,.2689,54.2645,-1.60823,.21387,53.73247,-2.06711,.19497,53.767,-1.95622,.34758,53.95242,-1.64732,.17116,53.89244,-2.0822,.37892,54.3058,-1.49564,.27952,54.18814,-1.61395,.54155,54.06076,-1.2612,.82054,54.09776,-1.09483,.56876,54.27148,-1.11081,.64496,54.16247,-1.11097,.44268,54.15002,-1.01432,.61426,54.17259,-.90203,.78453,54.13768,-.94321,.4686,54.25312,-1.35724,.33753,54.28723,-1.19579,.43413,54.55978,-1.13188,.27605,54.3478,-.77827,.44966,54.21576,-1.54157,.56803,54.45165,-1.28266,.44739,54.42944,-1.29092,.46902,54.46553,-1.2473,.74579,54.159,-1.45545,.50826,53.97158,-1.53382,.8707,53.88662,-1.43288,.5497,54.05326,-1.25289,.09736,53.83094,-.69018,.29041,54.46078,-1.07599,.83727,54.17849,-1.09111,.82065,54.2358,-1.08524,.61507,54.16834,-.93539,-.38075,54.30689,-1.49875,-.10191,53.70931,-2.10459,-.47713,53.85215,-1.53376,-.87794,53.84084,-1.39909,-.57567,53.78669,-1.44352,-.70741,54.07664,-1.14031,-.69026,54.06019,-1.17243,-.89321,54.55823,-1.2147,-.52941,54.36254,-1.39428,-.5245,54.351,-1.39626,-.65072,54.10835,-1.1175,-.49935,54.37485,-1.14008,-.61756,54.10904,-.935,-.81135,54.2382,-1.07651,-.61426,54.17259,-.90203,-.62327,54.22721,-.89184,-.50842,54.44201,-.97327,-.43063,54.50268,-1.16862,-.18196,54.42789,-1.1991,-.3289,54.43461,-.76974,-.31187,54.40671,-.76777,-.27592,54.33704,-.76357,-.41848,54.5097,-.8032,-.36854,54.47928,-.77995,-.38127,54.48579,-.81543,0.0,53.89802,-1.90136,-.71899,54.40639,-1.11541};
			return value;
		}
		private double[] getc4_Coord_9_49_point_10()
		{
			double[] value = {-.78505,54.44696,-1.35317,-.57652,54.42386,-1.32671,-.64074,54.49945,-1.21621,-.44776,54.40608,-1.31884,-.83452,54.06616,-1.40526,-.21477,53.99298,-1.83441,-.58064,54.06227,-1.50861,-.2084,53.75435,-2.01131,-.21322,53.78957,-2.01862,-.74621,53.83548,-1.41751,-.1802,54.05763,-.69441,-.17236,54.29663,-.70089,-.47944,54.50852,-1.07563,-.49924,54.50367,-.87408,-.82504,54.11954,-.97522,-.56876,54.27148,-1.11081,-.45132,54.12448,-1.41379,-.35609,54.03512,-1.15207,-.48839,54.34248,-.86157,-.24593,54.41739,-1.06079,-.15693,54.32574,-.74834,-.5497,54.05326,-1.25289,-.67776,53.81805,-1.42902,-.62887,53.82965,-1.41528,-.59762,53.85772,-1.39038,-.77235,54.23125,-1.45554,-.82219,54.47086,-1.11968,-.27605,54.3478,-.77827,-.3932,54.53981,-1.18135,-.40292,54.54481,-1.17581,-.39039,54.54566,-1.17534,-.51447,54.12593,-.9158,-.345,54.04369,-1.1668,-.44105,54.28562,-1.15751,-.47601,54.10214,-1.18707,-.4686,54.25312,-1.35724,-.44472,54.40915,-.81273,-.38279,54.30895,-1.18166,-.4294,54.39293,-1.16653,-.39172,54.46964,-1.1925,-.29096,54.10602,-1.61919,-.34758,53.95242,-1.64732,-.2689,54.2645,-1.60823,.53113,54.24738,-.88354,.48509,54.37791,-1.05635,.50406,54.44753,-.87791,.49924,54.50367,-.87408,.17316,53.99063,-.69323,.58064,54.06227,-1.50861,.59945,54.47928,-1.23531,.15429,54.01631,-1.91725,.65402,54.4584,-1.11091,.25535,53.89667,-.77227,.43063,54.50268,-1.16862,.52885,54.1625,-.93443,.81135,54.2382,-1.07651,.80894,54.49926,-1.29573,.52119,54.10768,-.93735,.50627,53.84291,-1.40147,.23784,53.90746,-1.80423,.24629,53.91348,-1.78285,.25404,53.85436,-1.73727,.25153,53.85446,-1.73348,.33212,54.28011,-1.55032,.33602,54.2819,-1.55244,.32516,53.86702,-1.62721,.12951,53.72102,-2.17492,.13906,53.717,-2.17408,.17255,53.77744,-2.19025,.1673,53.77555,-2.18966,.2056,53.8447,-1.97249,.30085,54.02371,-1.62279,.46946,54.01944,-1.38616,.41129,54.03337,-1.48446,0.0,54.16844,-1.7416,.09741,54.17488,-1.72554,0.0,54.23294,-1.71903,.34096,54.2008,-1.55159,.78724,53.78876,-1.46056,.82098,54.57652,-1.14145,.7448,54.56475,-1.11263,.82303,54.57326,-1.13588,.74362,54.56827,-1.119,.57771,54.51061,-1.15519,.72689,54.48428,-1.27399,.69211,54.41457,-1.36851,.32579,54.50885,-1.20835,.33264,54.43368,-1.20845,.11037,54.03433,-1.21336,.1999,54.1259,-1.20273,.20544,54.02742,-1.21106,.10551,54.13125,-1.20041,.21155,53.9232,-1.21417,.26605,54.37111,-1.21878,.18846,54.3237,-1.19954,.09689,53.82689,-.70008,0.0,53.93291,-1.2056,.11583,53.93033,-1.22145,.11651,53.92329,-1.2145,0.0,53.93885,-1.21251};
			return value;
		}
		private double[] getc4_Coord_9_49_point_11()
		{
			double[] value = {.47747,54.56316,-.96553,.46758,54.54397,-.87466,.46727,54.56525,-.96596,.08144,54.30519,-.67541,0.0,54.29413,-.65287,.08464,54.2949,-.66729,0.0,54.30484,-.6606,.2744,54.36116,-.83715,.42301,54.56171,-1.13074,.37568,54.47584,-.77268,.40392,54.45133,-.77299,.66357,54.53873,-1.12461,.73867,54.47383,-1.09352,.31058,53.94225,-1.62629,.68651,54.51661,-1.20437,.66373,54.54211,-1.13151,.74561,54.53748,-1.19822,.44697,54.07733,-1.56793,.5248,54.06768,-1.5187,.18709,53.95768,-1.91649,.19036,53.9167,-1.99575,.29298,53.93733,-1.71962,.30297,54.046,-1.70129,.62887,53.82965,-1.41528,.67776,53.81805,-1.42902,.21221,53.91743,-1.2071,.21443,53.93498,-1.13282,.20611,53.93827,-.9548,.11861,53.94813,-1.03767,.21173,53.94028,-1.03879,.1163,53.94556,-.93786,.11854,53.91776,-.85179,.1147,53.85347,-.7645,.08616,53.97088,-.6529,.10029,54.12459,-.65382,.09296,54.03883,-.65443,.19728,54.12672,-.6977,0.0,54.21908,-.63987,0.0,54.11483,-.64198,.10649,54.21124,-.65277,.31439,54.45239,-.99433,.39815,54.51831,-.97937,.07892,54.32423,-.7172,0.0,54.3867,-.95313,.07781,54.37022,-.87392,.07836,54.38746,-.95726,0.0,54.36914,-.87347,.15938,54.39004,-.97736,.08489,54.40593,-1.04178,.27446,54.40797,-.99005,.49948,54.51415,-.96956,.51201,54.18317,-.89163,.42356,54.19502,-.8633,.36716,54.2101,-.83148,-.46946,54.01944,-1.38616,-.33602,54.2819,-1.55244,-.33212,54.28011,-1.55032,-.1673,53.77555,-2.18966,-.14263,53.75452,-2.18376,-.20051,53.72737,-2.17794,-.13906,53.717,-2.17408,-.2056,53.8447,-1.97249,-.2049,53.86512,-2.06323,-.19036,53.9167,-1.99575,-.50826,53.97158,-1.53382,-.41129,54.03337,-1.48446,-.30085,54.02371,-1.62279,-.09741,54.17488,-1.72554,-.78724,53.78876,-1.46056,-.66147,54.36734,-1.43464,-.57771,54.51061,-1.15519,-.82303,54.57326,-1.13588,-.82098,54.57652,-1.14145,-.48316,54.0926,-1.17847,-.51872,54.07786,-1.21536,-.65774,54.34884,-1.13612,-.5043,54.38434,-1.16311,-.80438,54.52673,-1.24741,-.80894,54.49926,-1.29573,-.5062,54.17027,-1.12833,-.5748,54.16819,-1.13272,-.33264,54.43368,-1.20845,-.26605,54.37111,-1.21878,-.32579,54.50885,-1.20835,-.10551,54.13125,-1.20041,0.0,54.04312,-1.20639,-.11037,54.03433,-1.21336,0.0,54.13604,-1.19018,-.18846,54.3237,-1.19954,-.19411,54.22465,-1.19978,-.09505,54.32591,-1.19066,-.08959,54.4299,-1.18257,-.09689,53.82689,-.70008,0.0,53.82368,-.66829,-.09736,53.83094,-.69018,0.0,53.81988,-.67822,-.42356,54.19502,-.8633,-.36716,54.2101,-.83148,-.08918,54.43534,-1.17482,-.42301,54.56171,-1.13074};
			return value;
		}
		private double[] getc4_Coord_9_49_point_12()
		{
			double[] value = {-.43413,54.55978,-1.13188,-.46758,54.54397,-.87466,-.08464,54.2949,-.66729,-.08144,54.30519,-.67541,-.26153,54.40205,-.98874,-.27446,54.40797,-.99005,-.37166,54.52203,-1.0744,-.4498,54.57512,-1.07519,-.39815,54.51831,-.97937,-.46727,54.56525,-.96596,-.40392,54.45133,-.77299,-.10041,54.22844,-1.19284,0.0,54.23073,-1.18462,-.7448,54.56475,-1.11263,-.73867,54.47383,-1.09352,-.66357,54.53873,-1.12461,-.29259,54.15678,-1.68138,-.72689,54.48428,-1.27399,-.68651,54.51661,-1.20437,-.74561,54.53748,-1.19822,-.66373,54.54211,-1.13151,-.30297,54.046,-1.70129,-.29298,53.93733,-1.71962,-.35904,54.05145,-1.63327,-.71257,53.88077,-1.368,-.79417,53.9448,-1.30529,-.21443,53.93498,-1.13282,-.21173,53.94028,-1.03879,0.0,53.95711,-1.03358,-.1163,53.94556,-.93786,-.11861,53.94813,-1.03767,0.0,53.94919,-.93082,0.0,53.92098,-.8447,-.1147,53.85347,-.7645,-.11854,53.91776,-.85179,0.0,53.85247,-.75168,-.20611,53.93827,-.9548,-.18742,53.91333,-.70478,-.09296,54.03883,-.65443,-.08616,53.97088,-.6529,-.19728,54.12672,-.6977,-.24664,54.14102,-.74707,-.10649,54.21124,-.65277,-.10029,54.12459,-.65382,-.31439,54.45239,-.99433,-.07892,54.32423,-.7172,0.0,54.32507,-.70543,0.0,54.34855,-.78443,-.07781,54.37022,-.87392,-.07951,54.34665,-.79057,-.15787,54.36672,-.88978,-.07836,54.38746,-.95726,-.15938,54.39004,-.97736,-.51201,54.18317,-.89163,-.53113,54.24738,-.88354,-.08489,54.40593,-1.04178,-.08436,53.88313,-.66532,-.18159,53.85198,-.71457,-.21221,53.91743,-1.2071,-.80671,53.90823,-1.33617,-.2146,53.88234,-1.89347,-.18709,53.95768,-1.91649,-.44697,54.07733,-1.56793,-.5248,54.06768,-1.5187,-.34749,54.18503,-1.62172,-.74362,54.56827,-1.119,-.69211,54.41457,-1.36851,-.1999,54.1259,-1.20273,-.37568,54.47584,-.77268,-.15917,54.3427,-.80085,-.2744,54.36116,-.83715,-.27006,54.38117,-.89539,0.0,54.43148,-1.1836,0.0,54.43819,-1.1757,-.30177,54.14829,-.80432,-.21155,53.9232,-1.21417,0.0,54.32543,-1.17906,-.11583,53.93033,-1.22145,-.34978,54.11562,-1.55258,-.34096,54.2008,-1.55159,-.35859,54.03043,-1.55358,-.19912,53.76555,-2.18771,-.17255,53.77744,-2.19025,-.12776,53.73355,-2.17809,-.12951,53.72102,-2.17492,.57162,54.2226,-1.12118,.65774,54.34884,-1.13612,.26153,54.40205,-.98874,.15787,54.36672,-.88978,.07951,54.34665,-.79057,.37166,54.52203,-1.0744,.24664,54.14102,-.74707,.79417,53.9448,-1.30529,.2049,53.86512,-2.06323,.35904,54.05145,-1.63327,.78684,54.53893,-1.21827,.66147,54.36734,-1.43464,.5043,54.38434,-1.16311,.10041,54.22844,-1.19284,.4498,54.57512,-1.07519};
			return value;
		}
		private double[] getc4_Coord_9_49_point_13()
		{
			double[] value = {.27006,54.38117,-.89539,.09505,54.32591,-1.19066,.5748,54.16819,-1.13272,.80438,54.52673,-1.24741,.58022,54.5141,-1.16124,.34978,54.11562,-1.55258,.35859,54.03043,-1.55358,.13702,53.75944,-2.1725,.20051,53.72737,-2.17794,.14263,53.75452,-2.18376,.11689,53.73103,-2.16481,.12776,53.73355,-2.17809,.19912,53.76555,-2.18771,.5062,54.17027,-1.12833,.51251,54.23857,-1.10819,.19411,54.22465,-1.19978,.08959,54.4299,-1.18257,.08918,54.43534,-1.17482,.34749,54.18503,-1.62172,.64074,54.49945,-1.21621,.2146,53.88234,-1.89347,.12026,53.93727,-1.12943,0.0,53.96231,-.63883,0.0,53.87227,-.64809,0.0,54.02954,-.64007,.30177,54.14829,-.80432,.08824,54.42275,-1.11765,0.0,54.42019,-1.10895,0.0,54.40381,-1.0319,.15917,54.3427,-.80085,-.78684,54.53893,-1.21827,-.20544,54.02742,-1.21106,-.11651,53.92329,-1.2145,0.0,53.9485,-1.1319,-.12026,53.93727,-1.12943,-.08824,54.42275,-1.11765};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc4disc_Geo_8_54_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,5,6,-1,7,8,9,-1,10,11,12,-1,13,11,10,-1,14,15,16,-1,17,18,19,-1,12,11,20,-1,21,22,23,-1,10,24,25,-1,16,26,27,-1,28,29,30,-1,31,30,29,-1,32,33,34,-1,35,36,9,-1,23,8,37,-1,38,31,39,-1,40,41,42,-1,43,44,45,-1,46,47,0,-1,48,49,50,-1,51,45,4,-1,1,4,3,-1,52,53,54,-1,54,55,52,-1,53,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,35,-1,66,67,33,-1,57,56,18,-1,14,59,68,-1,69,14,70,-1,70,14,71,-1,72,1,0,-1,46,0,73,-1,49,40,34,-1,56,13,19,-1,20,74,75,-1,65,76,36,-1,77,22,78,-1,60,79,58,-1,53,57,80,-1,81,52,55,-1,82,83,84,-1,62,85,84,-1,54,86,87,-1,88,62,87,-1,68,58,79,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,45,51,98,-1,50,99,100,-1,43,101,102,-1,103,104,105,-1,106,107,101,-1,47,95,97,-1,28,41,40,-1,7,108,109,-1,32,110,33,-1,110,32,111,-1,111,112,110,-1,113,31,73,-1,40,114,34,-1,115,16,116,-1,117,118,119,-1,14,16,115,-1,21,119,120,-1,117,37,8,-1,121,9,112,-1,122,123,69,-1,26,16,15,-1,93,2,3,-1,2,1,3,-1,34,33,67,-1,3,94,93,-1,91,122,69,-1,124,121,112,-1,7,117,8,-1,120,12,21,-1,111,124,112,-1,18,17,125,-1,115,71,14,-1,20,11,13,-1,19,13,25,-1,117,109,118,-1,125,126,127,-1,113,73,128,-1,112,36,110,-1,7,109,117,-1,39,31,113,-1,101,99,106,-1,103,105,129,-1,101,105,102,-1,99,98,100,-1,45,98,43,-1,95,46,96,-1,92,130,93,-1,89,91,70,-1,68,79,131,-1,88,63,62,-1,55,54,87,-1,81,62,84,-1,84,132,82,-1,81,133,52,-1,80,54,53,-1,78,75,77,-1,65,36,35,-1,75,78,20,-1,66,33,110,-1,67,49,34,-1,47,72,0,-1,71,89,70,-1,14,69,59,-1,46,73,29,-1,29,96,46,-1,57,18,80,-1,56,19,18,-1,64,35,134,-1,58,68,59,-1,53,52,56,-1,70,91,69,-1,1,72,4,-1,51,4,72,-1,50,100,48,-1,46,95,47,-1,40,42,114,-1,38,30,31,-1,23,134,8,-1,36,112,9,-1,34,114,32,-1,31,29,73,-1,28,30,41,-1,116,16,27,-1,37,21,23,-1,12,20,78,-1,19,25,17,-1,10,25,13,-1,12,120,10,-1,121,7,9,-1,94,3,6,-1,122,91,135,-1,125,80,18,-1,2,73,0,-1,136,137,138,-1,136,90,137,-1,21,117,119,-1,117,21,37,-1,139,140,24,-1,139,141,140,-1,142,143,144,-1,143,142,145,-1,146,147,148,-1,147,146,149,-1,126,141,150,-1,126,140,141,-1,151,128,152,-1,151,113,128,-1,108,121,153,-1,121,108,7,-1,154,108,153,-1,154,155,108,-1,38,156,157,-1,38,158,156,-1,159,113,151,-1,39,113,159,-1,107,65,129,-1,107,76,65,-1,50,106,99,-1,106,50,160,-1,104,161,162,-1,104,103,161,-1,101,98,99,-1,98,101,43,-1,163,164,165,-1,164,163,166,-1,100,96,48,-1,97,96,100,-1,90,167,137,-1,167,90,89,-1,131,86,168,-1,131,79,86,-1,135,169,61,-1,136,169,135,-1,169,170,85,-1,171,170,169,-1,87,81,55,-1,87,62,81,-1,161,132,162,-1,132,161,82,-1,172,82,161,-1,77,82,172,-1,66,36,76,-1,66,110,36,-1,125,168,80,-1,168,125,127,-1,93,152,128,-1,93,130,152,-1,130,173,152,-1,130,174,173,-1,48,29,28,-1,48,96,29,-1,23,64,134,-1,172,64,23,-1,69,60,59,-1,60,69,123,-1,52,74,56,-1,52,133,74,-1,85,61,169,-1,85,62,61,-1,171,136,138,-1,171,169,136,-1,174,137,167,-1,174,175,137,-1,6,165,164,-1,176,165,6,-1,44,102,176,-1,102,44,43,-1,49,160,50,-1,160,49,67,-1,64,129,65,-1,129,64,103,-1,157,30,38,-1,157,41,30,-1,151,149,159,-1,151,177,149,-1,146,156,158,-1,156,146,145,-1,155,109,108,-1,155,142,109,-1,17,24,140,-1,25,24,17,-1,116,148,147,-1,116,27,148,-1,144,150,141,-1,150,144,143,-1,120,24,10,-1,120,139,24,-1,78,21,12,-1,21,78,22,-1,177,178,179,-1,173,178,177,-1,173,167,178,-1,173,174,167,-1,92,6,164,-1,92,94,6,-1,175,138,137,-1,166,138,175,-1};
			return value;
		}
		private int[] getc4disc_Geo_8_54_coordIndex_2()
		{
			int[] value = {109,144,118,-1,109,142,144,-1,143,146,148,-1,145,146,143,-1,149,179,147,-1,149,177,179,-1,26,150,27,-1,26,126,150,-1,152,177,151,-1,177,152,173,-1,8,35,9,-1,134,35,8,-1,180,121,124,-1,180,153,121,-1,157,155,154,-1,156,155,157,-1,158,39,159,-1,158,38,39,-1,180,114,42,-1,114,180,32,-1,44,4,45,-1,44,5,4,-1,51,47,97,-1,51,72,47,-1,76,106,66,-1,106,76,107,-1,181,162,182,-1,181,104,162,-1,182,165,181,-1,163,165,182,-1,98,97,100,-1,98,51,97,-1,79,87,86,-1,87,79,88,-1,171,182,170,-1,171,163,182,-1,162,170,182,-1,132,170,162,-1,83,77,75,-1,83,82,77,-1,60,88,79,-1,60,123,88,-1,61,122,135,-1,61,63,122,-1,48,40,49,-1,48,28,40,-1,68,15,14,-1,15,68,131,-1,178,89,71,-1,178,167,89,-1,15,168,127,-1,15,131,168,-1,2,128,73,-1,2,93,128,-1,20,56,74,-1,56,20,13,-1,77,23,22,-1,77,172,23,-1,135,90,136,-1,90,135,91,-1,75,133,83,-1,74,133,75,-1,83,81,84,-1,83,133,81,-1,132,85,170,-1,84,85,132,-1,168,54,80,-1,168,86,54,-1,138,163,171,-1,138,166,163,-1,63,123,122,-1,63,88,123,-1,92,174,130,-1,175,174,92,-1,176,5,44,-1,176,6,5,-1,181,176,102,-1,181,165,176,-1,102,104,181,-1,102,105,104,-1,101,129,105,-1,129,101,107,-1,66,160,67,-1,106,160,66,-1,103,172,161,-1,103,64,172,-1,154,41,157,-1,154,42,41,-1,159,146,158,-1,149,146,159,-1,156,142,155,-1,145,142,156,-1,42,153,180,-1,42,154,153,-1,180,111,32,-1,111,180,124,-1,17,126,125,-1,17,140,126,-1,115,147,179,-1,147,115,116,-1,143,27,150,-1,143,148,27,-1,118,141,139,-1,118,144,141,-1,120,118,139,-1,119,118,120,-1,71,179,178,-1,71,115,179,-1,126,15,127,-1,126,26,15,-1,164,175,92,-1,175,164,166,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc4disc_Coord_9_54_point_1()
		{
			double[] value = {-.27309,53.79235,-.73396,-.24914,53.75068,-.74387,-.22763,53.74748,-.74604,-.223,53.70555,-.75947,-.23941,53.70579,-.76522,-.22677,53.70134,-.77423,-.16324,53.69224,-.76181,-.117,53.92347,-1.20341,-.10808,53.89732,-1.19871,-.20861,53.90666,-1.18822,.29028,53.93079,-1.16121,.28178,53.92147,-1.17246,.20922,53.90674,-1.18689,.31234,53.92787,-1.15583,.268,53.84321,-.75936,.32432,53.9249,-.82918,.24985,53.88776,-.77883,.31071,53.94223,-1.05534,.33878,53.94566,-1.05549,.32972,53.93746,-1.13085,.2621,53.90567,-1.17308,.1091,53.89924,-1.19965,.08822,53.85775,-1.17156,0.0,53.8586,-1.17077,.2876,53.93365,-1.13933,.31878,53.93787,-1.14056,.27706,53.91871,-.86378,.19544,53.91123,-.85463,-.32286,53.95091,-.90482,-.316,53.9092,-.82904,-.27706,53.91871,-.86378,-.22753,53.87439,-.77621,-.31917,53.93793,-1.14057,-.32984,53.93803,-1.13375,-.34594,53.95355,-1.05799,-.19074,53.88837,-1.17978,-.26203,53.90664,-1.17595,0.0,53.9016,-1.19138,-.19544,53.91123,-.85463,-.18575,53.86215,-.77509,-.32956,53.95655,-.96166,-.2702,53.93845,-.95659,-.27165,53.93655,-1.04951,-.22115,53.77498,-.92511,-.22525,53.73963,-.84191,-.234,53.7452,-.84071,-.29338,53.8369,-.74314,-.28801,53.79082,-.73871,-.35009,53.93251,-.88912,-.36394,53.93519,-.97461,-.32994,53.90744,-.97837,-.26589,53.78492,-.82213,.28712,53.89407,-1.07416,.32317,53.90751,-1.04193,.32994,53.90744,-.97837,.276,53.86743,-.98934,.29868,53.91149,-1.11095,.32471,53.93017,-1.05058,.29897,53.82527,-.75565,.29032,53.81412,-.72664,.28801,53.79082,-.73871,.22525,53.73963,-.84191,.22115,53.77498,-.92511,.234,53.7452,-.84071,-.07454,53.81864,-1.13736,-.16815,53.85112,-1.1351,-.30251,53.91307,-1.10794,-.35335,53.94523,-1.07256,.30676,53.84272,-.73788,.2479,53.74959,-.72815,.2171,53.73515,-.72361,.17477,53.79434,-.71052,-.26723,53.75338,-.74205,-.24798,53.83816,-.76424,.22468,53.8756,-1.12783,.16867,53.85193,-1.13588,-.22464,53.87552,-1.12765,.07463,53.81873,-1.13718,.18616,53.88085,-1.17093,.31619,53.86719,-.80757,.36553,53.93649,-.97443,.2172,53.81059,-1.0006,.07203,53.79952,-1.10239,.15667,53.82957,-1.09663,.15854,53.78328,-.99507,.16197,53.75755,-.91546,.32752,53.89497,-.88803,.27512,53.82644,-.9131,.26589,53.78492,-.82213,.16547,53.71784,-.70499,.16561,53.6941,-.74217,.21681,53.70268,-.75453,-.07234,53.67906,-.72613,-.16646,53.72603,-.70558,-.16632,53.69502,-.74284,-.29897,53.82527,-.75565,-.33055,53.89402,-.80768,-.31619,53.86719,-.80757,-.27512,53.82644,-.9131,-.276,53.86743,-.98934};
			return value;
		}
		private double[] getc4disc_Coord_9_54_point_2()
		{
			double[] value = {-.32752,53.89497,-.88803,-.2172,53.81059,-1.0006,-.16197,53.75755,-.91546,-.07203,53.79952,-1.10239,-.07547,53.76764,-.99375,-.15854,53.78328,-.99507,-.28712,53.89407,-1.07416,-.21509,53.85649,-1.08336,-.12026,53.93562,-1.12943,0.0,53.94686,-1.1319,-.31884,53.93122,-1.15496,-.29893,53.93189,-1.16202,-.28159,53.92197,-1.17201,-.17928,53.84458,-.72385,-.31798,53.94329,-1.05642,.17928,53.84458,-.72385,.18575,53.86215,-.77509,0.0,53.92568,-1.1848,.12026,53.93562,-1.12943,.117,53.92347,-1.20341,.20983,53.92085,-1.18393,-.2097,53.92091,-1.18371,.23632,53.70518,-.75895,.26723,53.75338,-.74205,-.29011,53.93098,-1.1598,.32963,53.95251,-.96292,.2702,53.93845,-.95659,.32712,53.94886,-.90259,-.17517,53.79761,-.71076,-.15667,53.82957,-1.09663,-.07783,53.70566,-.68179,.34349,53.90407,-.80063,.07547,53.76764,-.99375,.21509,53.85649,-1.08336,-.08907,53.86017,-1.17369,.21441,53.69957,-.77181,.16324,53.69224,-.76181,.07249,53.6801,-.7266,.06947,53.67873,-.74708,.21443,53.93334,-1.13282,.27165,53.93655,-1.04951,.21173,53.93864,-1.03879,0.0,53.95546,-1.03358,.1163,53.94391,-.93786,.11861,53.94649,-1.03767,0.0,53.94755,-.93082,0.0,53.91934,-.8447,.1147,53.85182,-.7645,.11854,53.91612,-.85179,0.0,53.85083,-.75168,.20611,53.93662,-.9548,-.09689,53.82525,-.70008,-.08842,53.77271,-.68634,-.21443,53.93334,-1.13282,-.21173,53.93864,-1.03879,-.11861,53.94649,-1.03767,-.1163,53.94391,-.93786,-.20611,53.93662,-.9548,-.11854,53.91612,-.85179,-.1147,53.85182,-.7645,-.32689,53.91935,-1.04721,0.0,53.78316,-1.09408,0.0,53.75294,-.99226,0.0,53.69201,-.8036,-.06947,53.67873,-.74708,-.07885,53.70341,-.81955,0.0,53.66764,-.73952,.07735,53.70265,-.68159,.35971,53.92825,-.88417,.16444,53.72344,-.83381,.07771,53.7335,-.9058,.07885,53.70341,-.81955,0.0,53.81252,-1.13694,0.0,53.76856,-.6685,0.0,53.69521,-.66879,0.0,53.66886,-.71904,-.16444,53.72344,-.83381,0.0,53.81823,-.67822,.08887,53.77551,-.68653,.09689,53.82525,-.70008,-.2876,53.93365,-1.13933,-.07771,53.7335,-.9058,0.0,53.71684,-.88501};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc5_Geo_8_59_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,11,10,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,32,31,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,63,62,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,109,118,-1,100,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,126,125,61,-1,130,131,132,-1,133,134,135,-1,136,132,137,-1,113,138,139,-1,140,141,142,-1,143,144,145,-1,146,147,121,-1,148,149,130,-1,150,151,152,-1,151,146,152,-1,153,146,151,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,98,97,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,176,177,178,-1,179,180,181,-1,181,101,182,-1,101,183,184,-1,185,186,187,-1,73,79,78,-1,188,189,190,-1,170,191,192,-1,183,193,155,-1,187,194,195,-1,196,197,198,-1,199,200,201,-1,161,202,203,-1,204,198,158,-1,205,206,207,-1,208,209,210,-1,165,211,208,-1,212,213,214,-1,165,215,163,-1,216,217,218,-1,20,24,219,-1,220,221,222,-1,223,9,11,-1,224,225,226,-1,227,27,26,-1,228,229,230,-1,231,232,233,-1,234,235,236,-1,237,30,238,-1,239,240,238,-1,241,22,242,-1,243,225,224,-1,244,245,246,-1,247,248,249,-1,250,251,252,-1,244,253,1,-1,254,255,256,-1,257,241,258,-1,259,260,261,-1,262,244,263,-1,264,2,1,-1,265,42,41,-1,266,39,267,-1,268,41,269,-1,270,271,272,-1,273,274,271,-1,37,275,276,-1,277,278,276,-1,279,280,48,-1,281,282,57,-1,51,283,49,-1,284,285,286,-1,287,65,70,-1,69,62,288,-1,289,64,290,-1,291,292,149,-1,149,292,293,-1,294,66,65,-1,44,46,295,-1,296,297,298,-1,299,72,300,-1,80,301,302,-1,303,304,300,-1,304,305,299,-1,102,111,119,-1,183,101,120,-1,306,90,85,-1,84,307,308,-1,309,310,311,-1,312,313,314,-1,315,316,317,-1,315,318,319,-1,320,321,312,-1,322,323,308,-1,324,325,326,-1,327,328,329,-1,329,330,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,343,-1,344,345,346,-1,347,348,340,-1,349,350,351,-1,352,353,354,-1,352,355,356,-1,352,357,358,-1,351,359,360,-1,361,362,348,-1,363,344,364,-1,365,366,367,-1,368,369,370,-1,371,360,359,-1,372,373,374,-1,375,361,376,-1,377,375,378,-1,379,380,381,-1,382,383,384,-1,385,386,387,-1,388,389,390,-1,391,392,393,-1,394,395,396,-1,397,398,399,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,401,403,408,-1,409,410,411,-1,412,413,414,-1,415,416,412,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,420,-1,428,429,424,-1,430,431,432,-1,433,0,434,-1,435,436,437,-1,434,431,438,-1,439,440,441,-1,442,443,444,-1,445,446,447,-1,448,449,450,-1,451,452,453,-1,454,455,456,-1,457,458,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,484,488,-1,489,490,491,-1,492,493,394,-1,494,495,496,-1,480,497,498,-1,499,500,501,-1,502,503,504,-1,483,505,506,-1,507,508,509,-1,510,511,512,-1,513,514,515,-1,449,448,516,-1,517,518,519,-1,520,486,485,-1,520,333,486,-1,521,522,523,-1,524,469,525,-1,469,526,525,-1,527,498,528,-1,488,529,475,-1,499,504,503,-1,530,375,531,-1,532,533,534,-1,363,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,508,507,-1,547,548,549,-1,550,410,551,-1,548,547,507,-1,549,548,552,-1,553,554,544,-1,555,506,556,-1,557,558,556,-1,559,560,561,-1,562,563,564,-1,517,564,563,-1,565,508,546,-1,566,567,568,-1,569,570,571,-1,572,449,332,-1,573,574,575,-1,365,367,576,-1,577,578,579,-1,345,344,580,-1,581,582,583,-1,381,380,384,-1,584,585,586,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_2()
		{
			int[] value = {587,588,589,-1,590,591,348,-1,396,404,400,-1,592,593,594,-1,595,596,597,-1,598,599,600,-1,601,584,602,-1,603,601,604,-1,602,605,606,-1,607,608,411,-1,609,610,611,-1,407,422,612,-1,423,573,613,-1,614,615,616,-1,415,617,618,-1,619,620,621,-1,622,623,624,-1,416,415,618,-1,625,626,627,-1,628,626,629,-1,630,631,632,-1,633,634,635,-1,623,636,624,-1,637,638,639,-1,640,641,642,-1,639,643,644,-1,645,646,647,-1,458,648,649,-1,650,651,652,-1,464,463,653,-1,654,655,656,-1,0,657,434,-1,658,659,660,-1,661,662,459,-1,644,467,663,-1,664,665,573,-1,652,651,638,-1,467,637,663,-1,650,466,666,-1,667,653,463,-1,668,669,635,-1,444,445,670,-1,671,672,673,-1,674,675,676,-1,673,416,671,-1,677,678,615,-1,424,429,679,-1,680,679,426,-1,420,616,615,-1,598,681,599,-1,409,682,683,-1,684,600,511,-1,518,685,560,-1,588,587,686,-1,390,687,404,-1,688,689,382,-1,690,686,389,-1,691,585,584,-1,592,692,491,-1,693,694,695,-1,582,696,393,-1,697,580,581,-1,577,698,699,-1,367,697,700,-1,520,365,334,-1,701,613,702,-1,555,703,704,-1,705,706,519,-1,377,532,567,-1,508,565,707,-1,558,708,709,-1,557,710,711,-1,554,712,713,-1,549,552,714,-1,714,715,685,-1,716,541,540,-1,542,538,537,-1,540,551,717,-1,718,719,708,-1,720,721,569,-1,493,722,723,-1,724,396,395,-1,725,712,554,-1,712,378,726,-1,532,377,712,-1,727,728,703,-1,725,535,533,-1,476,482,481,-1,729,730,501,-1,731,355,354,-1,471,732,473,-1,733,734,576,-1,521,735,630,-1,516,448,514,-1,410,550,607,-1,488,484,505,-1,736,737,730,-1,736,729,728,-1,728,481,704,-1,499,528,498,-1,661,650,662,-1,738,342,366,-1,739,597,740,-1,506,505,486,-1,741,636,742,-1,506,555,704,-1,498,743,480,-1,744,500,479,-1,745,746,747,-1,745,477,746,-1,477,476,748,-1,737,504,730,-1,749,750,751,-1,752,753,754,-1,755,756,757,-1,755,758,732,-1,759,760,761,-1,759,471,470,-1,666,468,653,-1,762,763,462,-1,467,655,468,-1,464,764,465,-1,632,631,634,-1,765,766,435,-1,441,442,435,-1,767,667,439,-1,647,640,656,-1,642,768,764,-1,769,770,771,-1,772,773,774,-1,775,776,777,-1,439,257,767,-1,260,259,647,-1,768,263,769,-1,432,434,657,-1,430,778,779,-1,425,424,780,-1,781,428,423,-1,782,783,784,-1,416,673,785,-1,412,416,413,-1,413,786,787,-1,515,788,608,-1,414,789,408,-1,614,407,406,-1,404,401,400,-1,405,790,791,-1,792,724,793,-1,794,713,795,-1,598,796,681,-1,586,797,692,-1,689,383,382,-1,693,798,372,-1,376,381,384,-1,799,375,383,-1,376,591,379,-1,570,706,705,-1,704,703,728,-1,367,366,345,-1,536,344,363,-1,800,364,362,-1,590,801,373,-1,352,356,802,-1,352,354,355,-1,337,801,335,-1,340,344,803,-1,350,804,805,-1,191,806,807,-1,808,322,809,-1,308,323,810,-1,811,812,322,-1,325,320,314,-1,813,328,814,-1,315,815,316,-1,816,813,817,-1,314,313,814,-1,818,819,811,-1,150,310,309,-1,306,820,821,-1,822,823,824,-1,181,99,101,-1,825,301,313,-1,304,826,818,-1,105,305,304,-1,827,826,828,-1,103,829,104,-1,71,830,303,-1,831,67,832,-1,833,834,835,-1,292,291,834,-1,144,836,74,-1,64,837,838,-1,288,62,64,-1,69,839,840,-1,841,289,842,-1,843,283,51,-1,52,51,49,-1,286,276,284,-1,844,845,846,-1,265,847,42,-1,848,849,850,-1,851,852,850,-1,853,854,855,-1,264,856,857,-1,263,244,433,-1,238,240,436,-1,248,858,859,-1,248,247,858,-1,1,253,860,-1,225,861,862,-1,261,863,3,-1,22,241,240,-1,864,865,238,-1,866,867,29,-1,868,869,870,-1,871,222,872,-1,23,221,220,-1,873,163,215,-1,164,874,875,-1,876,212,205,-1,877,878,879,-1,203,202,204,-1,196,880,881,-1,183,882,184,-1,177,176,883,-1,74,836,142,-1,884,885,852,-1,232,886,887,-1,888,889,890,-1,882,155,176,-1,127,108,891,-1,57,892,55,-1,175,280,171,-1,191,170,172,-1,893,894,104,-1,895,883,896,-1,896,883,192,-1,873,215,216,-1,897,898,873,-1,328,326,814,-1,813,816,329,-1,317,899,900,-1,901,902,187,-1,178,203,903,-1,185,902,889,-1,904,905,906,-1,121,907,146,-1,150,307,151,-1,133,908,909,-1,135,148,132,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_3()
		{
			int[] value = {122,910,131,-1,911,912,913,-1,914,891,915,-1,127,916,128,-1,917,173,136,-1,918,916,919,-1,920,914,921,-1,920,922,923,-1,147,924,910,-1,121,123,293,-1,925,60,59,-1,894,926,112,-1,926,894,893,-1,891,110,107,-1,106,927,107,-1,113,928,119,-1,191,870,929,-1,13,93,930,-1,91,90,821,-1,87,931,88,-1,85,84,308,-1,82,932,933,-1,934,829,935,-1,303,830,936,-1,937,938,72,-1,939,940,297,-1,68,145,69,-1,312,811,819,-1,298,297,941,-1,812,321,942,-1,54,925,76,-1,943,934,935,-1,44,58,45,-1,944,945,946,-1,947,282,281,-1,54,53,925,-1,174,917,49,-1,148,144,143,-1,948,949,950,-1,846,951,842,-1,268,952,13,-1,953,845,39,-1,954,887,955,-1,956,957,958,-1,229,959,230,-1,887,954,37,-1,960,961,962,-1,254,962,963,-1,963,237,255,-1,964,236,235,-1,965,966,25,-1,10,967,15,-1,968,969,9,-1,861,225,243,-1,9,969,967,-1,970,261,971,-1,972,973,8,-1,7,6,3,-1,24,23,226,-1,223,862,968,-1,862,861,968,-1,226,219,24,-1,7,3,5,-1,8,974,972,-1,19,5,4,-1,9,967,10,-1,975,960,962,-1,976,861,243,-1,968,9,223,-1,18,10,15,-1,230,959,977,-1,235,25,964,-1,167,234,978,-1,963,28,237,-1,254,963,255,-1,37,31,887,-1,869,979,980,-1,229,981,959,-1,956,982,957,-1,39,38,953,-1,952,93,13,-1,842,983,846,-1,858,984,985,-1,986,987,988,-1,266,267,989,-1,148,135,144,-1,48,174,49,-1,990,947,281,-1,946,991,944,-1,945,947,940,-1,44,992,58,-1,937,943,935,-1,76,75,54,-1,298,941,75,-1,819,825,312,-1,66,993,832,-1,940,941,297,-1,936,828,303,-1,932,994,933,-1,821,166,91,-1,896,192,807,-1,13,930,995,-1,929,806,191,-1,97,96,996,-1,113,115,928,-1,104,894,111,-1,107,915,891,-1,893,927,926,-1,111,894,112,-1,120,119,928,-1,997,927,893,-1,925,53,60,-1,193,156,155,-1,293,998,121,-1,910,122,147,-1,920,124,922,-1,920,999,914,-1,918,128,916,-1,173,909,136,-1,921,124,920,-1,915,921,914,-1,153,911,913,-1,131,130,122,-1,135,132,908,-1,919,133,909,-1,907,1000,146,-1,904,906,304,-1,1001,61,125,-1,921,915,997,-1,902,890,889,-1,901,1002,1003,-1,900,318,317,-1,873,216,897,-1,896,1004,895,-1,104,1001,893,-1,191,172,870,-1,1005,1006,167,-1,55,281,57,-1,127,891,914,-1,175,174,280,-1,170,1007,175,-1,888,180,889,-1,194,187,186,-1,852,1008,884,-1,63,74,142,-1,1009,77,1010,-1,162,178,177,-1,883,895,177,-1,882,159,184,-1,881,194,196,-1,203,204,157,-1,876,205,1011,-1,874,1012,875,-1,873,1013,163,-1,220,226,23,-1,222,1014,872,-1,1015,6,973,-1,1016,1017,1018,-1,172,868,870,-1,980,34,1005,-1,866,29,28,-1,864,238,30,-1,22,240,239,-1,3,971,261,-1,1,860,1019,-1,1020,238,436,-1,433,1,0,-1,264,1019,856,-1,853,1021,854,-1,851,1008,852,-1,269,41,43,-1,267,844,848,-1,268,984,41,-1,844,846,1022,-1,33,270,958,-1,954,275,37,-1,276,275,284,-1,52,49,917,-1,841,842,951,-1,840,70,69,-1,288,64,289,-1,290,64,838,-1,144,74,145,-1,835,1023,833,-1,294,287,843,-1,303,300,71,-1,103,935,829,-1,936,827,828,-1,304,906,105,-1,818,904,304,-1,301,1024,313,-1,822,824,1025,-1,821,90,306,-1,309,308,150,-1,811,311,818,-1,816,817,1026,-1,315,1027,1028,-1,315,317,318,-1,315,319,1029,-1,813,329,328,-1,811,322,309,-1,308,810,85,-1,808,323,322,-1,807,192,191,-1,350,805,1030,-1,350,349,804,-1,340,364,344,-1,337,1031,801,-1,352,358,353,-1,352,1032,357,-1,801,1031,373,-1,364,348,362,-1,536,580,344,-1,345,697,367,-1,705,1033,570,-1,376,361,591,-1,799,378,375,-1,376,384,383,-1,383,375,376,-1,372,374,693,-1,689,799,383,-1,797,1034,692,-1,794,793,713,-1,793,794,792,-1,791,399,405,-1,404,403,401,-1,787,614,406,-1,408,1035,414,-1,1036,411,1037,-1,606,512,600,-1,512,511,600,-1,608,607,515,-1,787,414,413,-1,416,785,413,-1,782,784,1038,-1,419,1039,1038,-1,428,424,423,-1,1040,426,615,-1,424,679,780,-1,430,1041,778,-1,769,433,434,-1,647,658,260,-1,257,258,767,-1,769,434,770,-1,777,1042,775,-1,774,1043,772,-1,771,1044,769,-1,642,641,768,-1,667,440,439,-1,435,437,441,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_4()
		{
			int[] value = {435,444,765,-1,633,632,634,-1,1045,1046,1047,-1,464,642,764,-1,467,644,655,-1,762,465,763,-1,468,1048,653,-1,759,732,471,-1,759,761,752,-1,755,732,754,-1,755,1049,756,-1,752,1050,753,-1,1051,749,751,-1,477,748,744,-1,1052,475,745,-1,744,479,1053,-1,506,704,483,-1,742,1054,741,-1,1055,695,694,-1,661,651,650,-1,499,498,497,-1,728,729,481,-1,736,730,729,-1,488,505,529,-1,1056,516,556,-1,1057,1058,619,-1,550,513,607,-1,516,514,513,-1,521,630,1059,-1,1060,733,576,-1,766,765,1061,-1,354,1030,731,-1,1062,487,1052,-1,748,476,481,-1,1056,556,506,-1,725,1063,535,-1,535,1064,533,-1,377,378,712,-1,724,541,793,-1,541,716,793,-1,725,533,712,-1,394,493,723,-1,569,709,720,-1,531,1065,1066,-1,708,711,718,-1,540,717,543,-1,542,1067,538,-1,540,543,716,-1,714,685,1068,-1,710,1069,1070,-1,507,1071,1072,-1,1072,1073,507,-1,714,1068,549,-1,554,713,545,-1,727,703,570,-1,709,571,558,-1,509,508,707,-1,567,566,377,-1,519,739,705,-1,1074,728,727,-1,613,575,702,-1,365,734,334,-1,700,576,367,-1,699,578,577,-1,697,345,580,-1,582,393,392,-1,695,798,693,-1,491,593,592,-1,1075,492,400,-1,382,1055,688,-1,1076,390,404,-1,686,690,588,-1,400,399,1075,-1,685,561,560,-1,684,1077,600,-1,1078,1079,594,-1,409,1036,682,-1,420,615,426,-1,680,426,1080,-1,495,1081,496,-1,664,573,423,-1,1082,1057,1083,-1,672,417,673,-1,670,765,444,-1,635,1084,668,-1,440,667,463,-1,1085,650,666,-1,638,637,652,-1,665,1086,573,-1,431,434,432,-1,459,458,661,-1,638,651,649,-1,659,1087,660,-1,649,651,661,-1,655,1088,656,-1,464,653,1048,-1,652,466,650,-1,661,458,649,-1,1085,660,1087,-1,644,663,639,-1,1089,626,625,-1,656,640,642,-1,639,663,637,-1,1090,635,1091,-1,634,1084,635,-1,629,1061,628,-1,416,618,671,-1,450,1092,452,-1,622,1093,623,-1,620,418,621,-1,614,677,615,-1,613,781,423,-1,790,407,612,-1,1094,1095,425,-1,1096,1097,1098,-1,1040,1080,426,-1,411,410,607,-1,594,559,1078,-1,605,512,606,-1,604,1099,603,-1,1077,598,600,-1,597,1100,595,-1,593,559,594,-1,347,1101,335,-1,492,396,400,-1,801,590,348,-1,1076,404,396,-1,584,586,1102,-1,596,689,688,-1,380,1103,384,-1,1100,597,1104,-1,1067,542,395,-1,582,392,583,-1,365,576,734,-1,520,334,333,-1,613,573,575,-1,572,332,1105,-1,1060,698,1106,-1,571,709,569,-1,519,706,564,-1,567,565,546,-1,517,563,568,-1,564,706,562,-1,703,571,570,-1,1107,517,568,-1,561,1078,559,-1,558,555,556,-1,554,545,544,-1,548,1108,552,-1,507,1073,548,-1,550,551,1109,-1,1071,1070,1072,-1,507,547,546,-1,716,543,545,-1,542,537,540,-1,539,1109,537,-1,532,712,533,-1,1066,530,531,-1,517,1107,1068,-1,547,1107,546,-1,503,528,499,-1,527,1110,1111,-1,351,350,1112,-1,349,1113,1114,-1,469,1115,526,-1,521,572,522,-1,1116,520,485,-1,519,564,517,-1,516,332,449,-1,1059,630,1117,-1,1079,510,512,-1,509,1071,507,-1,513,515,607,-1,516,513,1118,-1,504,737,502,-1,499,497,500,-1,1047,618,1119,-1,494,1120,495,-1,492,1075,493,-1,505,484,486,-1,483,704,481,-1,478,1121,479,-1,477,745,475,-1,1122,1123,1124,-1,473,1125,474,-1,471,1126,469,-1,466,468,666,-1,463,465,762,-1,462,763,460,-1,451,1127,452,-1,1128,448,450,-1,1092,1059,674,-1,447,670,445,-1,442,444,435,-1,439,441,437,-1,642,654,656,-1,438,770,434,-1,435,1020,436,-1,263,433,769,-1,432,1041,430,-1,779,665,1129,-1,779,778,665,-1,427,1130,1131,-1,780,679,680,-1,422,616,420,-1,414,1035,412,-1,411,1036,409,-1,386,1036,1037,-1,408,789,401,-1,405,407,790,-1,687,402,404,-1,401,405,399,-1,399,791,397,-1,394,396,492,-1,723,391,393,-1,794,1132,792,-1,1132,388,390,-1,691,588,690,-1,382,384,1103,-1,379,381,376,-1,377,531,375,-1,375,530,361,-1,372,590,373,-1,359,1133,371,-1,736,728,1074,-1,368,1134,369,-1,365,738,366,-1,363,364,800,-1,361,348,591,-1,1031,1113,373,-1,351,1112,359,-1,352,802,1032,-1,351,1113,349,-1,1135,1031,337,-1,348,364,340,-1,346,803,344,-1,341,366,342,-1,340,803,338,-1,335,1101,336,-1,1105,332,334,-1,331,327,329,-1,324,326,1136,-1,308,309,322,-1,312,314,320,-1,315,1029,1027,-1,315,1028,815,-1,312,825,313,-1,311,811,309,-1,307,150,308,-1,90,86,85,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_5()
		{
			int[] value = {102,119,1137,-1,299,300,304,-1,80,1024,301,-1,72,71,300,-1,298,1138,296,-1,294,65,287,-1,149,293,123,-1,291,149,143,-1,289,290,842,-1,839,69,288,-1,287,70,840,-1,284,47,285,-1,282,58,57,-1,280,174,48,-1,277,276,286,-1,271,1139,273,-1,269,952,268,-1,41,984,265,-1,244,1,433,-1,260,863,261,-1,241,1140,258,-1,1141,254,256,-1,250,252,1142,-1,247,249,1143,-1,244,246,253,-1,243,224,262,-1,261,861,976,-1,242,1140,241,-1,239,238,865,-1,237,238,1144,-1,236,978,234,-1,228,230,1016,-1,227,26,1145,-1,226,220,224,-1,11,1146,223,-1,220,222,871,-1,1146,20,219,-1,216,218,897,-1,165,214,215,-1,214,205,212,-1,208,206,165,-1,210,1147,208,-1,207,1011,205,-1,180,179,889,-1,158,157,204,-1,199,201,1148,-1,198,1149,196,-1,155,882,183,-1,170,192,154,-1,977,188,190,-1,155,883,176,-1,103,1150,935,-1,820,306,1151,-1,902,185,187,-1,184,182,101,-1,182,179,181,-1,178,903,176,-1,154,156,170,-1,1152,982,1153,-1,173,917,174,-1,170,175,171,-1,169,1005,167,-1,97,91,166,-1,1144,255,237,-1,182,1154,179,-1,158,184,159,-1,911,153,151,-1,100,120,101,-1,152,1155,150,-1,121,998,305,-1,148,143,149,-1,146,153,147,-1,142,836,140,-1,113,139,115,-1,906,905,1156,-1,132,131,137,-1,135,908,133,-1,148,130,132,-1,61,1157,126,-1,129,108,127,-1,129,118,108,-1,124,126,922,-1,121,147,122,-1,1158,117,118,-1,109,108,118,-1,114,928,115,-1,113,119,111,-1,110,891,108,-1,907,105,107,-1,102,104,111,-1,193,183,120,-1,98,1159,96,-1,95,930,93,-1,86,90,92,-1,996,87,89,-1,86,932,84,-1,82,933,83,-1,80,302,78,-1,298,75,77,-1,831,940,939,-1,67,1023,65,-1,72,938,73,-1,70,835,68,-1,66,832,67,-1,61,1001,59,-1,992,56,58,-1,52,1160,50,-1,49,283,47,-1,884,1008,1161,-1,12,268,13,-1,1162,1163,1152,-1,33,1164,31,-1,28,30,237,-1,25,27,964,-1,242,22,24,-1,1165,19,21,-1,18,15,17,-1,14,855,12,-1,1019,264,1,-1,973,6,8,-1,15,974,16,-1,3,863,4,-1,974,8,16,-1,3,1015,971,-1,6,1015,3,-1,863,1166,4,-1,863,260,1166,-1,1167,857,853,-1,857,1167,960,-1,226,862,219,-1,226,225,862,-1,221,865,222,-1,239,865,221,-1,236,1168,1169,-1,236,964,1168,-1,254,975,962,-1,1170,975,254,-1,1171,1172,1173,-1,1172,1171,1174,-1,1175,1176,1177,-1,1175,886,1176,-1,35,190,36,-1,35,1178,190,-1,957,1152,1163,-1,957,982,1152,-1,1179,272,1180,-1,272,1179,1153,-1,951,845,953,-1,951,846,845,-1,989,1143,250,-1,989,847,1143,-1,952,94,93,-1,952,1181,94,-1,838,1182,1183,-1,838,1184,1182,-1,847,267,42,-1,847,989,267,-1,54,281,55,-1,54,990,281,-1,60,1157,61,-1,1157,60,892,-1,943,77,76,-1,1010,77,943,-1,819,301,825,-1,301,819,827,-1,77,1138,298,-1,77,1009,1138,-1,948,1185,931,-1,950,1185,948,-1,821,807,166,-1,821,896,807,-1,166,806,98,-1,806,166,807,-1,1159,995,930,-1,995,1159,1186,-1,14,995,1173,-1,14,13,995,-1,927,915,107,-1,997,915,927,-1,1158,129,156,-1,1158,118,129,-1,916,914,999,-1,127,914,916,-1,52,923,922,-1,137,923,52,-1,112,1156,905,-1,112,926,1156,-1,133,911,134,-1,911,133,912,-1,152,1187,1155,-1,1188,1187,152,-1,919,912,133,-1,916,912,919,-1,1000,110,109,-1,907,110,1000,-1,110,907,107,-1,105,121,305,-1,105,907,121,-1,128,1007,129,-1,918,1007,128,-1,1189,162,177,-1,160,162,1189,-1,203,162,161,-1,203,178,162,-1,902,1003,890,-1,902,901,1003,-1,1190,879,878,-1,1190,1191,879,-1,815,99,181,-1,99,815,1028,-1,319,900,330,-1,900,319,318,-1,1192,1193,1194,-1,1192,1195,1193,-1,324,218,1196,-1,324,1197,218,-1,1198,1199,808,-1,1199,1198,1200,-1,1201,1202,1203,-1,1202,1201,1204,-1,320,324,1196,-1,320,325,324,-1,89,933,994,-1,89,1205,933,-1,1174,866,1206,-1,1207,866,1174,-1,1208,965,959,-1,965,1208,966,-1,82,151,307,-1,151,82,81,-1,934,59,829,-1,59,934,925,-1,235,189,188,-1,235,234,189,-1,877,195,878,-1,877,1002,195,-1,18,21,11,-1,17,21,18,-1,45,991,46,-1,45,944,991,-1,141,1205,1209,-1,1205,141,140,-1,822,177,895,-1,177,822,1189,-1,1210,880,1211,-1,1212,880,1210,-1,1213,202,201,-1,204,202,1213,-1,1214,1215,1216,-1,1214,1003,1215,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_6()
		{
			int[] value = {1147,1204,1201,-1,210,1204,1147,-1,212,1200,1198,-1,1200,212,876,-1,211,164,875,-1,165,164,211,-1,1217,1012,1218,-1,1012,1217,875,-1,1012,1219,1193,-1,874,1219,1012,-1,1220,872,1014,-1,872,1220,1221,-1,1222,1208,1223,-1,1224,1208,1222,-1,872,245,871,-1,245,872,246,-1,1225,1226,1224,-1,1227,1226,1225,-1,228,1228,1229,-1,1228,228,1230,-1,1231,1230,1018,-1,1231,1232,1230,-1,979,1018,35,-1,979,1231,1018,-1,870,980,1005,-1,980,870,869,-1,1207,867,866,-1,1207,978,867,-1,19,7,5,-1,19,1165,7,-1,1233,860,1234,-1,860,1233,1235,-1,1227,249,248,-1,1227,1225,249,-1,854,1236,859,-1,854,1021,1236,-1,238,1237,1144,-1,1237,238,1020,-1,12,854,985,-1,855,854,12,-1,988,850,849,-1,988,851,850,-1,849,844,1022,-1,848,844,849,-1,1182,987,1183,-1,987,1182,1238,-1,957,1239,1164,-1,1240,1239,957,-1,233,887,31,-1,233,232,887,-1,275,279,284,-1,954,279,275,-1,955,279,954,-1,47,840,839,-1,283,840,47,-1,837,1184,838,-1,837,1241,1184,-1,88,1185,1209,-1,88,931,1185,-1,835,291,68,-1,835,834,291,-1,833,292,834,-1,296,292,833,-1,947,941,940,-1,947,990,941,-1,1242,79,1150,-1,1242,1243,79,-1,827,818,826,-1,818,827,819,-1,1244,1245,1216,-1,1245,1244,1246,-1,1247,1025,824,-1,1025,1247,1248,-1,1249,823,1151,-1,1249,824,823,-1,816,1137,99,-1,1026,1137,816,-1,1250,1246,1251,-1,1252,1246,1250,-1,326,314,814,-1,325,314,326,-1,1151,1253,1249,-1,1151,1254,1253,-1,1202,1253,1203,-1,1202,1255,1253,-1,323,1199,810,-1,1199,323,808,-1,25,1226,26,-1,1226,25,966,-1,1256,1257,1258,-1,1256,1259,1257,-1,349,1260,804,-1,1114,1260,349,-1,343,1261,1262,-1,1263,1261,343,-1,1264,1265,1263,-1,1264,1266,1265,-1,1258,1267,1256,-1,1258,1250,1267,-1,536,581,580,-1,582,581,536,-1,1268,1269,1270,-1,1269,1268,1271,-1,1272,1273,1274,-1,1273,1272,1275,-1,555,571,703,-1,558,571,555,-1,693,371,694,-1,371,693,374,-1,489,689,490,-1,489,799,689,-1,1102,594,605,-1,592,594,1102,-1,794,1034,797,-1,795,1034,794,-1,398,1075,399,-1,398,493,1075,-1,699,1276,578,-1,699,391,1276,-1,1037,387,386,-1,387,1037,402,-1,608,1035,408,-1,608,788,1035,-1,1077,683,682,-1,684,683,1077,-1,787,677,614,-1,677,787,786,-1,1038,785,419,-1,1038,784,785,-1,1277,428,781,-1,1277,1120,428,-1,1278,1279,612,-1,1278,1096,1279,-1,496,1130,494,-1,496,1280,1130,-1,768,1281,263,-1,641,1281,768,-1,767,1166,660,-1,767,258,1166,-1,437,257,439,-1,257,437,436,-1,1282,430,779,-1,1283,430,1282,-1,774,775,1042,-1,774,773,775,-1,1284,1042,1285,-1,1284,774,1042,-1,1286,1282,1287,-1,1286,1283,1282,-1,1044,768,769,-1,764,768,1044,-1,646,658,647,-1,658,646,659,-1,443,445,444,-1,443,1288,445,-1,735,631,630,-1,735,1289,631,-1,515,1290,1291,-1,515,514,1290,-1,1292,1293,1294,-1,451,1293,1292,-1,1295,1093,1296,-1,1295,1297,1093,-1,1298,1285,1299,-1,1298,1284,1285,-1,1300,1287,668,-1,1300,1286,1287,-1,764,763,465,-1,764,1044,763,-1,1298,1091,1301,-1,1091,1298,1302,-1,1303,1304,474,-1,1304,1303,1305,-1,760,1306,1307,-1,760,1308,1306,-1,1309,1125,758,-1,1125,1309,1310,-1,754,759,752,-1,754,732,759,-1,757,1311,1312,-1,756,1311,757,-1,761,1050,752,-1,761,1313,1050,-1,1314,753,1315,-1,1314,1049,753,-1,749,1275,750,-1,1275,749,1316,-1,501,744,748,-1,744,501,500,-1,1317,1318,1319,-1,1317,1320,1318,-1,744,746,477,-1,1053,746,744,-1,1321,479,1121,-1,1053,479,1321,-1,482,505,483,-1,505,482,529,-1,1322,1269,1323,-1,1270,1269,1322,-1,639,649,648,-1,639,638,649,-1,1124,1324,478,-1,1124,1190,1324,-1,1057,1325,1058,-1,1057,1082,1325,-1,1326,1325,1082,-1,1326,1327,1325,-1,1328,735,1329,-1,1289,735,1328,-1,1330,1331,1332,-1,1331,1330,1333,-1,1334,1335,1336,-1,1334,1337,1335,-1,1306,336,1101,-1,336,1306,1338,-1,1339,1340,805,-1,1340,1339,1304,-1,473,1126,471,-1,1126,473,472,-1,1030,353,350,-1,1030,354,353,-1,1032,1341,736,-1,1341,1032,802,-1,1316,1111,1110,-1,1316,1122,1111,-1,529,476,475,-1,476,529,482,-1,1320,1342,1318,-1,1320,1343,1342,-1,1343,1323,1342,-1,1343,1322,1323,-1,362,1344,800,-1,362,1345,1344,-1,549,1107,547,-1,549,1068,1107,-1,518,1068,685,-1,1068,518,517,-1,719,1344,720,-1,719,1346,1344,-1,1063,696,535,-1,1067,696,1063,-1,720,708,719,-1,720,709,708,-1,377,1065,531,-1,377,566,1065,-1,1347,1072,1348,-1,1347,1073,1072,-1,1109,540,537,-1,1109,551,540,-1,725,1348,1063,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_7()
		{
			int[] value = {725,1347,1348,-1,683,552,409,-1,683,714,552,-1,1349,1072,1070,-1,1349,539,1072,-1,557,708,558,-1,557,711,708,-1,727,1033,1074,-1,1033,727,570,-1,1350,579,609,-1,579,1350,577,-1,523,1351,1329,-1,574,1351,523,-1,365,1116,738,-1,520,1116,365,-1,393,1067,395,-1,696,1067,393,-1,795,489,1034,-1,726,489,795,-1,798,379,372,-1,380,379,798,-1,596,490,689,-1,596,595,490,-1,389,687,390,-1,389,686,687,-1,347,801,348,-1,335,801,347,-1,796,1036,386,-1,1036,796,682,-1,542,724,395,-1,542,541,724,-1,1352,496,1081,-1,1352,1280,496,-1,1279,397,791,-1,397,1279,1353,-1,1350,1277,701,-1,1350,1354,1277,-1,775,1040,776,-1,1080,1040,775,-1,1117,632,1054,-1,1117,630,632,-1,418,672,621,-1,418,417,672,-1,1355,636,623,-1,1355,742,636,-1,1127,1290,1128,-1,1290,1127,1356,-1,629,1357,1141,-1,1358,1357,629,-1,462,443,442,-1,443,462,461,-1,1085,653,667,-1,1085,666,653,-1,432,625,1041,-1,432,1089,625,-1,1086,778,1359,-1,665,778,1086,-1,457,645,1360,-1,457,646,645,-1,425,664,423,-1,425,1095,664,-1,457,659,646,-1,457,459,659,-1,1166,658,660,-1,260,658,1166,-1,1041,1359,778,-1,1041,625,1359,-1,654,464,1048,-1,464,654,642,-1,442,762,462,-1,442,441,762,-1,1361,634,1362,-1,634,1361,1084,-1,1089,629,626,-1,1089,1358,629,-1,1363,1329,1351,-1,1363,1328,1329,-1,1356,1291,1290,-1,1291,1356,1119,-1,742,676,675,-1,1355,676,742,-1,1057,621,1083,-1,621,1057,619,-1,1039,1325,1364,-1,1039,1058,1325,-1,616,407,614,-1,407,616,422,-1,773,1080,775,-1,680,1080,773,-1,701,781,613,-1,1277,781,701,-1,1365,397,1353,-1,1366,397,1365,-1,796,385,681,-1,386,385,796,-1,604,602,606,-1,601,602,604,-1,604,600,599,-1,604,606,600,-1,559,595,1100,-1,593,595,559,-1,589,691,584,-1,589,588,691,-1,1103,798,695,-1,1103,380,798,-1,596,740,597,-1,596,688,740,-1,581,700,697,-1,581,583,700,-1,1105,734,733,-1,1105,334,734,-1,574,522,575,-1,574,523,522,-1,574,1086,1351,-1,573,1086,574,-1,700,1060,576,-1,700,698,1060,-1,569,706,570,-1,706,569,562,-1,1069,516,1118,-1,1069,556,516,-1,553,1108,548,-1,553,544,1108,-1,550,539,1349,-1,550,1109,539,-1,717,410,409,-1,717,551,410,-1,1070,509,710,-1,1070,1071,509,-1,359,705,1133,-1,359,1033,705,-1,1347,554,553,-1,725,554,1347,-1,553,1073,1347,-1,553,548,1073,-1,565,534,707,-1,565,532,534,-1,565,567,532,-1,363,1344,1346,-1,363,800,1344,-1,510,1078,561,-1,1078,510,1079,-1,1367,1323,1368,-1,1367,1342,1323,-1,1369,1342,1367,-1,1369,1318,1342,-1,501,504,499,-1,501,730,504,-1,749,1122,1316,-1,749,1123,1122,-1,503,1273,1110,-1,1273,503,502,-1,1341,356,1274,-1,1341,802,356,-1,1304,1259,1340,-1,1259,1304,1305,-1,1338,1370,336,-1,1370,1338,526,-1,1336,1371,338,-1,1336,1335,1371,-1,1331,1314,1261,-1,1331,1333,1314,-1,1370,337,336,-1,337,1370,1135,-1,392,699,583,-1,391,699,392,-1,447,1328,1372,-1,447,1289,1328,-1,1090,1302,624,-1,1090,1091,1302,-1,535,582,536,-1,535,696,582,-1,560,1100,1104,-1,560,559,1100,-1,1054,633,741,-1,633,1054,632,-1,743,1122,1124,-1,1111,1122,743,-1,1096,1353,1279,-1,1096,1098,1353,-1,1368,1269,369,-1,1368,1323,1269,-1,1121,1210,1321,-1,1121,1212,1210,-1,1319,1369,747,-1,1319,1318,1369,-1,1333,1049,1314,-1,1333,756,1049,-1,1335,761,1371,-1,1335,1313,761,-1,473,758,1125,-1,473,732,758,-1,474,1310,1303,-1,474,1125,1310,-1,1308,1338,1306,-1,1308,524,1338,-1,1373,1305,1303,-1,1305,1373,1374,-1,1084,1300,668,-1,1361,1300,1084,-1,1364,1327,1375,-1,1327,1364,1325,-1,1300,1376,1286,-1,1377,1376,1300,-1,1301,1284,1298,-1,1301,1378,1284,-1,1294,1297,1295,-1,1294,1293,1297,-1,1093,455,623,-1,1093,1297,455,-1,1047,1294,1045,-1,1047,1292,1294,-1,451,1356,1127,-1,1292,1356,451,-1,514,1128,1290,-1,514,448,1128,-1,449,521,1059,-1,572,521,449,-1,446,1288,1362,-1,446,445,1288,-1,1379,1287,1282,-1,1287,1379,1380,-1,777,1285,1042,-1,1285,777,1381,-1,438,430,1283,-1,438,431,430,-1,1129,1094,1379,-1,1129,1095,1094,-1,1237,435,766,-1,1237,1020,435,-1,429,1130,427,-1,429,494,1130,-1,429,426,679,-1,429,427,426,-1,1097,1352,1098,-1,1097,1280,1352,-1,1278,422,421,-1,422,1278,612,-1,1354,1120,1277,-1,1354,495,1120,-1,418,1039,419,-1,418,620,1039,-1,673,419,785,-1,419,673,417,-1,788,412,1035,-1,788,415,412,-1,788,617,415,-1,598,682,796,-1,598,1077,682,-1,402,408,403,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_8()
		{
			int[] value = {402,1037,408,-1,686,402,687,-1,686,387,402,-1,701,577,1350,-1,701,702,577,-1,493,1382,722,-1,1382,493,398,-1,724,1076,396,-1,1076,724,792,-1,388,690,389,-1,388,691,690,-1,585,691,388,-1,1102,602,584,-1,605,602,1102,-1,694,1133,740,-1,1133,694,371,-1,530,721,1345,-1,721,530,1066,-1,1272,750,1275,-1,1272,1383,750,-1,369,1271,370,-1,369,1269,1271,-1,368,1264,342,-1,370,1264,368,-1,1033,1112,1074,-1,1033,359,1112,-1,1383,1250,1251,-1,1383,1267,1250,-1,1031,1114,1113,-1,1031,1135,1114,-1,1263,342,1264,-1,343,342,1263,-1,1263,1331,1261,-1,1265,1331,1263,-1,1336,803,346,-1,1336,338,803,-1,1114,1370,1260,-1,1135,1370,1114,-1,1259,1384,1340,-1,1384,1259,1256,-1,1345,361,530,-1,361,1345,362,-1,330,1194,331,-1,330,1385,1194,-1,321,1196,942,-1,321,320,1196,-1,1203,1254,1386,-1,1203,1253,1254,-1,1255,1249,1253,-1,1249,1255,1387,-1,1385,900,1388,-1,1385,330,900,-1,1246,1388,1245,-1,1388,1246,1252,-1,1387,824,1249,-1,1387,1247,824,-1,751,1246,1244,-1,751,1251,1246,-1,1242,817,1243,-1,817,1242,1026,-1,1243,80,79,-1,1243,1024,80,-1,296,939,297,-1,296,833,939,-1,66,46,991,-1,294,46,66,-1,63,837,64,-1,142,837,63,-1,1209,89,88,-1,89,1209,1205,-1,839,285,47,-1,839,288,285,-1,277,285,841,-1,286,285,277,-1,279,1175,280,-1,955,1175,279,-1,1139,276,278,-1,1389,276,1139,-1,1164,233,31,-1,1164,1239,233,-1,271,1180,272,-1,271,274,1180,-1,1163,1240,957,-1,1163,1390,1240,-1,1161,1182,949,-1,1238,1182,1161,-1,849,986,988,-1,1022,986,849,-1,1022,1391,986,-1,43,885,269,-1,43,852,885,-1,259,976,1392,-1,259,261,976,-1,256,1144,1237,-1,256,255,1144,-1,252,40,1142,-1,252,273,40,-1,273,1393,274,-1,252,1393,273,-1,248,1145,1227,-1,859,1145,248,-1,246,860,253,-1,246,1234,860,-1,29,864,30,-1,1394,864,29,-1,978,168,167,-1,168,978,1207,-1,1177,280,1175,-1,280,1177,171,-1,231,886,232,-1,886,231,1176,-1,1017,230,1178,-1,1016,230,1017,-1,1230,1016,1018,-1,1230,228,1016,-1,274,1395,1180,-1,1393,1395,274,-1,1145,1226,1227,-1,1145,26,1226,-1,872,1234,246,-1,872,1221,1234,-1,223,219,862,-1,223,1146,219,-1,1395,1223,1396,-1,1222,1223,1395,-1,1221,1168,1397,-1,1221,1220,1168,-1,1193,1218,1012,-1,1193,1195,1218,-1,217,213,1398,-1,213,217,216,-1,875,1399,211,-1,875,1217,1399,-1,214,206,205,-1,165,206,214,-1,1311,209,1312,-1,1311,210,209,-1,876,1400,1200,-1,1400,876,1011,-1,1330,210,1311,-1,1330,1204,210,-1,1148,202,161,-1,1148,201,202,-1,201,1401,1213,-1,201,200,1401,-1,1402,1211,1401,-1,1402,1210,1211,-1,881,195,194,-1,195,881,878,-1,1239,1229,1228,-1,1239,1390,1229,-1,1239,1240,1390,-1,1189,1025,1403,-1,822,1025,1189,-1,1150,73,938,-1,79,73,1150,-1,969,972,967,-1,969,1404,972,-1,1002,187,195,-1,1002,901,187,-1,197,185,1154,-1,186,185,197,-1,1179,1152,1153,-1,1162,1152,1179,-1,1179,1405,1162,-1,1405,1179,1396,-1,168,1174,1171,-1,168,1207,1174,-1,1406,1203,1386,-1,1203,1406,1201,-1,1198,809,1398,-1,808,809,1198,-1,1407,324,1136,-1,324,1407,1197,-1,1374,1192,1257,-1,1192,1374,1195,-1,1408,815,181,-1,1408,316,815,-1,1002,1215,1003,-1,1215,1002,877,-1,157,903,203,-1,157,159,903,-1,1409,1320,199,-1,1320,1409,1343,-1,1410,1343,1409,-1,1343,1410,1322,-1,1411,311,310,-1,1412,311,1411,-1,997,124,921,-1,997,125,124,-1,125,893,1001,-1,125,997,893,-1,1411,1187,139,-1,1187,1411,1155,-1,81,911,151,-1,81,134,911,-1,116,139,1187,-1,139,116,115,-1,1156,105,906,-1,106,105,1156,-1,916,913,912,-1,999,913,916,-1,132,909,908,-1,909,132,136,-1,103,1242,1150,-1,1242,103,102,-1,927,1156,926,-1,927,106,1156,-1,156,114,1158,-1,114,156,193,-1,116,1158,114,-1,1158,116,117,-1,1137,100,99,-1,1137,119,100,-1,931,1413,948,-1,931,87,1413,-1,1173,1186,1171,-1,1173,995,1186,-1,1004,821,820,-1,1004,896,821,-1,71,78,830,-1,71,73,78,-1,145,62,69,-1,145,74,62,-1,56,892,57,-1,56,1157,892,-1,946,66,991,-1,946,993,66,-1,1008,1238,1161,-1,851,1238,1008,-1,838,1414,290,-1,838,1183,1414,-1,1181,1413,94,-1,1413,1181,1415,-1,266,250,1142,-1,266,989,250,-1,234,1006,189,-1,167,1006,234,-1,1164,958,957,-1,33,958,1164,-1,977,1178,230,-1,1178,977,190,-1,1177,1416,868,-1,1177,1176,1416,-1,1357,254,1141,-1,1357,1170,254,-1,1220,1169,1168,-1,1394,1169,1220,-1,23,239,221,-1,22,239,23,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_9()
		{
			int[] value = {960,264,857,-1,975,264,960,-1,853,14,1167,-1,853,855,14,-1,16,21,17,-1,21,16,1165,-1,12,984,268,-1,985,984,12,-1,970,1015,1404,-1,1015,970,971,-1,1170,0,2,-1,1170,1357,0,-1,24,19,242,-1,19,24,20,-1,864,222,865,-1,864,1014,222,-1,1206,1172,1174,-1,961,1172,1206,-1,1167,1173,1172,-1,1167,14,1173,-1,34,979,35,-1,34,980,979,-1,1163,1405,1417,-1,1163,1162,1405,-1,1153,956,272,-1,956,1153,982,-1,1018,1178,35,-1,1018,1017,1178,-1,1143,265,247,-1,847,265,1143,-1,949,1184,950,-1,1184,949,1182,-1,51,295,843,-1,51,50,295,-1,312,812,811,-1,312,321,812,-1,70,1023,835,-1,1023,70,65,-1,1010,937,72,-1,943,937,1010,-1,827,302,301,-1,827,936,302,-1,1009,293,1138,-1,1009,998,293,-1,135,83,144,-1,134,83,135,-1,134,81,83,-1,994,996,89,-1,996,994,92,-1,98,929,1159,-1,806,929,98,-1,930,96,1159,-1,930,95,96,-1,922,1160,52,-1,1160,922,126,-1,146,1188,152,-1,1000,1188,146,-1,137,910,923,-1,137,131,910,-1,109,1188,1000,-1,117,1188,109,-1,905,113,112,-1,905,138,113,-1,140,144,83,-1,140,836,144,-1,123,130,149,-1,123,122,130,-1,998,299,305,-1,1009,299,998,-1,918,175,1007,-1,918,173,175,-1,155,192,883,-1,155,154,192,-1,160,1403,1418,-1,160,1189,1403,-1,1418,161,160,-1,1148,161,1418,-1,182,158,1154,-1,158,182,184,-1,879,1051,1419,-1,1051,879,1191,-1,99,1027,816,-1,99,1028,1027,-1,1029,330,329,-1,330,1029,319,-1,1013,164,163,-1,1013,874,164,-1,1194,1219,331,-1,1194,1193,1219,-1,1196,217,942,-1,1196,218,217,-1,1200,1420,1199,-1,1420,1200,1400,-1,1202,1330,1332,-1,1202,1204,1330,-1,1407,898,1197,-1,1407,873,898,-1,929,1186,1159,-1,929,169,1186,-1,28,1206,866,-1,28,963,1206,-1,981,1208,959,-1,981,1223,1208,-1,1408,180,888,-1,180,1408,181,-1,1324,878,881,-1,1190,878,1324,-1,974,967,972,-1,15,967,974,-1,1248,1322,1410,-1,1248,1270,1322,-1,176,159,882,-1,176,903,159,-1,196,1211,880,-1,196,1149,1211,-1,1213,198,204,-1,1213,1149,198,-1,199,1317,200,-1,1320,1317,199,-1,198,1154,158,-1,198,197,1154,-1,1216,1419,1244,-1,1216,1215,1419,-1,207,1201,1406,-1,1147,1201,207,-1,1147,206,208,-1,207,206,1147,-1,209,211,1399,-1,209,208,211,-1,1398,212,1198,-1,212,1398,213,-1,1218,1421,1217,-1,1373,1421,1218,-1,1013,1407,1422,-1,873,1407,1013,-1,11,20,1146,-1,11,21,20,-1,966,1224,1226,-1,966,1208,1224,-1,871,224,220,-1,224,871,245,-1,227,1397,27,-1,1233,1397,227,-1,1423,1224,1222,-1,1225,1224,1423,-1,229,1229,1417,-1,1229,229,228,-1,1230,231,1228,-1,1230,1232,231,-1,1416,1231,979,-1,1416,1232,1231,-1,978,1169,867,-1,978,236,1169,-1,242,4,1140,-1,242,19,4,-1,262,245,244,-1,262,224,245,-1,1236,1233,227,-1,1235,1233,1236,-1,251,1225,1423,-1,249,1225,251,-1,250,249,251,-1,1143,249,250,-1,856,1236,1021,-1,856,1235,1236,-1,257,240,241,-1,257,436,240,-1,1166,1140,4,-1,258,1140,1166,-1,1281,262,263,-1,1281,243,262,-1,1414,1391,983,-1,1391,1414,986,-1,269,1181,952,-1,885,1181,269,-1,1389,271,270,-1,1139,271,1389,-1,38,277,953,-1,38,278,277,-1,1160,992,50,-1,1160,56,992,-1,284,48,47,-1,279,48,284,-1,287,283,843,-1,287,840,283,-1,1185,1184,1241,-1,1184,1185,950,-1,141,1185,1241,-1,1209,1185,141,-1,1205,83,933,-1,1205,140,83,-1,1138,292,296,-1,1138,293,292,-1,54,941,990,-1,54,75,941,-1,72,1009,1010,-1,1009,72,299,-1,1412,139,138,-1,1411,139,1412,-1,928,193,120,-1,928,114,193,-1,1214,1245,899,-1,1214,1216,1245,-1,1248,1268,1270,-1,1248,1247,1268,-1,932,307,84,-1,932,82,307,-1,1252,1258,1424,-1,1250,1258,1252,-1,306,1254,1151,-1,306,1425,1254,-1,1255,1332,1426,-1,1332,1255,1202,-1,810,1420,1425,-1,1420,810,1199,-1,1136,328,327,-1,1136,326,328,-1,1257,1424,1258,-1,1192,1424,1257,-1,1301,635,669,-1,1301,1091,635,-1,1101,340,339,-1,340,1101,347,-1,1262,341,343,-1,1262,1334,341,-1,1426,1266,1427,-1,1265,1266,1426,-1,345,341,346,-1,345,366,341,-1,1256,1428,1384,-1,1267,1428,1256,-1,1428,1274,731,-1,1274,1428,1272,-1,360,1113,351,-1,373,1113,360,-1,1427,1271,1268,-1,1427,1266,1271,-1,368,485,1134,-1,1116,485,368,-1,1274,502,1341,-1,502,1274,1273,-1,371,373,360,-1,374,373,371,-1,518,1104,519,-1,518,560,1104,-1,584,603,589,-1,603,584,601,-1,587,387,686,-1,587,385,387,-1,794,388,1132,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_10()
		{
			int[] value = {794,797,388,-1,792,390,1076,-1,1132,390,792,-1,1429,578,1276,-1,579,578,1429,-1,1366,398,397,-1,398,1366,1382,-1,401,406,405,-1,401,789,406,-1,783,786,784,-1,678,786,783,-1,678,677,786,-1,618,1046,671,-1,1046,618,1047,-1,1045,621,672,-1,1045,1430,621,-1,1098,1365,1353,-1,1098,1352,1365,-1,420,1131,421,-1,420,427,1131,-1,1130,1097,1131,-1,1097,1130,1280,-1,1129,664,1095,-1,1129,665,664,-1,641,1392,1281,-1,640,1392,641,-1,1061,1141,256,-1,629,1141,1061,-1,1282,1129,1379,-1,779,1129,1282,-1,774,1378,1043,-1,1378,774,1284,-1,438,1286,1376,-1,438,1283,1286,-1,662,1085,1087,-1,650,1085,662,-1,446,1289,447,-1,631,1289,446,-1,1092,449,1059,-1,1092,450,449,-1,456,452,676,-1,453,452,456,-1,1293,453,456,-1,453,1293,451,-1,1431,1296,1083,-1,1431,1295,1296,-1,1299,1381,1375,-1,1299,1285,1381,-1,669,1287,1380,-1,668,1287,669,-1,1044,460,763,-1,1044,771,460,-1,1302,1299,1432,-1,1302,1298,1299,-1,460,1433,461,-1,460,1377,1433,-1,1339,474,1304,-1,1339,472,474,-1,759,1308,760,-1,470,1308,759,-1,1434,1310,1309,-1,1434,1421,1310,-1,1309,1312,1434,-1,1312,1309,757,-1,1315,1050,1337,-1,1315,753,1050,-1,1316,1273,1275,-1,1110,1273,1316,-1,1402,1319,1435,-1,1402,1317,1319,-1,1053,1435,746,-1,1321,1435,1053,-1,478,1212,1121,-1,1324,1212,478,-1,332,1056,333,-1,332,516,1056,-1,484,1134,485,-1,484,1436,1134,-1,391,722,1276,-1,391,723,722,-1,1099,599,681,-1,599,1099,604,-1,466,637,467,-1,466,652,637,-1,500,480,479,-1,497,480,500,-1,683,715,714,-1,715,683,684,-1,1432,1326,622,-1,1326,1432,1327,-1,521,1329,735,-1,521,523,1329,-1,524,526,1338,-1,525,526,524,-1,1339,804,1437,-1,805,804,1339,-1,1262,1337,1334,-1,1262,1315,1337,-1,1101,1307,1306,-1,1101,339,1307,-1,1260,1437,804,-1,1260,1115,1437,-1,1437,472,1339,-1,472,1437,1126,-1,353,1112,350,-1,1112,353,358,-1,1074,1032,736,-1,1074,357,1032,-1,1123,1190,1124,-1,1191,1190,1123,-1,1110,528,503,-1,527,528,1110,-1,487,475,1052,-1,475,487,488,-1,487,1436,484,-1,487,1062,1436,-1,1118,1070,1069,-1,1118,1349,1070,-1,1346,535,363,-1,1346,1064,535,-1,1348,539,538,-1,1348,1072,539,-1,719,1064,1346,-1,719,718,1064,-1,1063,538,1067,-1,1063,1348,538,-1,1065,562,1066,-1,563,562,1065,-1,1108,409,552,-1,1108,717,409,-1,1069,557,556,-1,710,557,1069,-1,710,707,711,-1,707,710,509,-1,546,568,567,-1,546,1107,568,-1,522,1060,1106,-1,1060,522,733,-1,611,495,1354,-1,611,1081,495,-1,577,1106,698,-1,577,702,1106,-1,738,368,342,-1,1116,368,738,-1,1429,609,579,-1,1429,610,609,-1,1034,491,692,-1,489,491,1034,-1,372,591,590,-1,372,379,591,-1,491,595,593,-1,491,490,595,-1,715,561,685,-1,715,510,561,-1,512,594,1079,-1,605,594,512,-1,1037,608,408,-1,608,1037,411,-1,612,791,790,-1,791,612,1279,-1,609,1354,1350,-1,609,611,1354,-1,1094,780,772,-1,425,780,1094,-1,776,615,678,-1,1040,615,776,-1,675,1054,742,-1,675,1117,1054,-1,1117,674,1059,-1,675,674,1117,-1,1119,617,1291,-1,617,1119,618,-1,1296,622,1326,-1,1296,1093,622,-1,452,1128,450,-1,1128,452,1127,-1,625,1363,1359,-1,625,627,1363,-1,626,1372,627,-1,626,628,1372,-1,741,635,1090,-1,635,741,633,-1,461,1288,443,-1,1288,461,1433,-1,636,1090,624,-1,636,741,1090,-1,656,645,647,-1,645,656,1088,-1,657,1089,432,-1,657,1358,1089,-1,648,457,1360,-1,458,457,648,-1,1360,1088,643,-1,1088,1360,645,-1,1087,459,662,-1,459,1087,659,-1,0,1358,657,-1,1357,1358,0,-1,655,643,1088,-1,643,655,644,-1,441,463,762,-1,441,440,463,-1,1362,1433,1361,-1,1362,1288,1433,-1,1061,670,628,-1,670,1061,765,-1,1363,1372,1328,-1,1363,627,1372,-1,1351,1359,1363,-1,1086,1359,1351,-1,452,674,676,-1,1092,674,452,-1,1326,1083,1296,-1,1083,1326,1082,-1,620,1058,1039,-1,620,619,1058,-1,1355,456,676,-1,456,1355,454,-1,780,773,772,-1,780,680,773,-1,1366,611,610,-1,1366,1365,611,-1,587,603,1099,-1,589,603,587,-1,510,684,511,-1,715,684,510,-1,586,592,1102,-1,586,692,592,-1,695,382,1103,-1,382,695,1055,-1,698,583,699,-1,698,700,583,-1,572,733,522,-1,572,1105,733,-1,1106,575,522,-1,702,575,1106,-1,726,713,712,-1,726,795,713,-1,1065,568,563,-1,568,1065,566,-1,1133,739,740,-1,1133,705,739,-1,718,533,1064,-1,718,534,533,-1,544,717,1108,-1,543,717,544,-1,718,707,534,-1,718,711,707,-1,569,1066,562,-1,1066,569,721,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_11()
		{
			int[] value = {395,723,393,-1,394,723,395,-1,716,713,793,-1,545,713,716,-1,799,726,378,-1,799,489,726,-1,513,1349,1118,-1,1349,513,550,-1,333,506,486,-1,506,333,1056,-1,1368,1062,1367,-1,1062,1368,1436,-1,1052,1367,1062,-1,1052,1369,1367,-1,748,729,501,-1,748,481,729,-1,1051,1123,749,-1,1051,1191,1123,-1,358,1074,1112,-1,1074,358,357,-1,356,731,1274,-1,731,356,355,-1,1259,1374,1257,-1,1259,1305,1374,-1,1370,1115,1260,-1,1370,526,1115,-1,339,1371,1307,-1,339,338,1371,-1,1261,1315,1262,-1,1261,1314,1315,-1,470,524,1308,-1,524,470,469,-1,1372,670,447,-1,670,1372,628,-1,1302,622,624,-1,622,1302,1432,-1,737,1341,502,-1,737,736,1341,-1,498,1111,743,-1,1111,498,527,-1,648,643,639,-1,643,648,1360,-1,1055,740,688,-1,1055,694,740,-1,369,1436,1368,-1,369,1134,1436,-1,1295,1045,1294,-1,1431,1045,1295,-1,1431,1430,1045,-1,743,478,480,-1,743,1124,478,-1,1321,1402,1435,-1,1210,1402,1321,-1,1435,747,746,-1,747,1435,1319,-1,745,1369,1052,-1,747,1369,745,-1,756,1330,1311,-1,1330,756,1333,-1,1337,1313,1335,-1,1337,1050,1313,-1,754,1049,755,-1,754,753,1049,-1,758,757,1309,-1,757,758,755,-1,761,1307,1371,-1,761,760,1307,-1,1421,1303,1310,-1,1421,1373,1303,-1,1115,1126,1437,-1,1115,469,1126,-1,1361,1377,1300,-1,1433,1377,1361,-1,1432,1375,1327,-1,1432,1299,1375,-1,1048,655,654,-1,468,655,1048,-1,1376,460,771,-1,460,1376,1377,-1,1301,1380,1378,-1,669,1380,1301,-1,1375,782,1364,-1,1375,1381,782,-1,455,1293,456,-1,455,1297,1293,-1,623,454,1355,-1,623,455,454,-1,1119,1292,1047,-1,1119,1356,1292,-1,1362,631,446,-1,634,631,1362,-1,660,667,767,-1,667,660,1085,-1,438,771,770,-1,771,438,1376,-1,1380,1043,1378,-1,1380,1379,1043,-1,1381,783,782,-1,1381,777,783,-1,678,777,776,-1,777,678,783,-1,772,1379,1094,-1,772,1043,1379,-1,766,256,1237,-1,1061,256,766,-1,640,259,1392,-1,647,259,640,-1,1120,429,428,-1,1120,494,429,-1,1096,1131,1097,-1,1096,421,1131,-1,1278,421,1096,-1,1365,1081,611,-1,1365,1352,1081,-1,1430,1083,621,-1,1083,1430,1431,-1,1364,1038,1039,-1,1038,1364,782,-1,1046,672,671,-1,672,1046,1045,-1,413,784,786,-1,413,785,784,-1,1291,788,515,-1,1291,617,788,-1,789,787,406,-1,789,414,787,-1,1366,1429,1382,-1,1366,610,1429,-1,1429,722,1382,-1,1429,1276,722,-1,681,587,1099,-1,681,385,587,-1,585,797,586,-1,797,585,388,-1,597,519,1104,-1,597,739,519,-1,720,1345,721,-1,720,1344,1345,-1,1383,751,750,-1,751,1383,1251,-1,370,1266,1264,-1,1271,1266,370,-1,1428,1383,1272,-1,1428,1267,1383,-1,731,1384,1428,-1,1384,731,1030,-1,1332,1265,1426,-1,1332,1331,1265,-1,1334,346,341,-1,1334,1336,346,-1,1340,1030,805,-1,1030,1340,1384,-1,818,1412,904,-1,818,311,1412,-1,1385,1192,1194,-1,1385,1424,1192,-1,322,942,809,-1,322,812,942,-1,1425,1386,1254,-1,1386,1425,1420,-1,1387,1426,1427,-1,1387,1255,1426,-1,1425,85,810,-1,85,1425,306,-1,1388,1424,1385,-1,1388,1252,1424,-1,899,1388,900,-1,899,1245,1388,-1,814,817,813,-1,814,313,817,-1,1247,1427,1268,-1,1427,1247,1387,-1,895,823,822,-1,895,1004,823,-1,888,899,1408,-1,888,1214,899,-1,313,1243,817,-1,313,1024,1243,-1,138,904,1412,-1,138,905,904,-1,828,304,303,-1,828,826,304,-1,829,1001,104,-1,59,1001,829,-1,946,940,993,-1,946,945,940,-1,67,833,1023,-1,831,833,67,-1,831,939,833,-1,68,143,145,-1,68,291,143,-1,1241,142,141,-1,1241,837,142,-1,87,94,1413,-1,95,94,87,-1,841,288,289,-1,285,288,841,-1,953,841,951,-1,953,277,841,-1,50,44,295,-1,44,50,992,-1,278,273,1139,-1,278,40,273,-1,40,278,38,-1,1389,37,276,-1,1389,32,37,-1,270,32,1389,-1,270,33,32,-1,272,958,270,-1,272,956,958,-1,885,1415,1181,-1,884,1415,885,-1,846,1391,1022,-1,846,983,1391,-1,1238,988,987,-1,988,1238,851,-1,267,43,42,-1,43,267,848,-1,850,43,848,-1,852,43,850,-1,856,853,857,-1,856,1021,853,-1,1392,243,1281,-1,1392,976,243,-1,858,854,859,-1,985,854,858,-1,856,860,1235,-1,1019,860,856,-1,1423,252,251,-1,1423,1393,252,-1,227,859,1236,-1,227,1145,859,-1,1394,867,1169,-1,867,1394,29,-1,169,870,1005,-1,169,929,870,-1,868,171,1177,-1,171,868,172,-1,1176,1232,1416,-1,1176,231,1232,-1,233,1228,231,-1,233,1239,1228,-1,1417,1390,1163,-1,1390,1417,1229,-1,1393,1222,1395,-1,1423,1222,1393,-1,1234,1397,1233,-1,1234,1221,1397,-1,1396,1180,1395,-1,1396,1179,1180,-1};
			return value;
		}
		private int[] getc5_Geo_8_59_coordIndex_12()
		{
			int[] value = {1397,964,27,-1,1397,1168,964,-1,1195,1373,1218,-1,1195,1374,1373,-1,216,214,213,-1,216,215,214,-1,1217,1434,1399,-1,1434,1217,1421,-1,1312,1399,1434,-1,1312,209,1399,-1,1011,1406,1400,-1,207,1406,1011,-1,1051,1244,1419,-1,1051,751,1244,-1,200,1402,1401,-1,1402,200,1317,-1,1401,1149,1213,-1,1401,1211,1149,-1,1212,881,880,-1,1212,1324,881,-1,1248,1403,1025,-1,1403,1248,1410,-1,1183,986,1414,-1,987,986,1183,-1,8,1165,16,-1,8,7,1165,-1,194,197,196,-1,194,186,197,-1,1157,1160,126,-1,1157,56,1160,-1,1405,1223,981,-1,1405,1396,1223,-1,1171,169,168,-1,169,1171,1186,-1,1197,897,218,-1,1197,898,897,-1,327,1219,1422,-1,327,331,1219,-1,1400,1386,1420,-1,1386,1400,1406,-1,1398,942,217,-1,809,942,1398,-1,1422,1136,327,-1,1136,1422,1407,-1,874,1422,1219,-1,874,1013,1422,-1,816,1029,329,-1,816,1027,1029,-1,317,1408,899,-1,1408,317,316,-1,1214,890,1003,-1,1214,888,890,-1,877,1419,1215,-1,1419,877,879,-1,889,1154,185,-1,1154,889,179,-1,1409,1148,1418,-1,199,1148,1409,-1,1410,1418,1403,-1,1409,1418,1410,-1,53,892,60,-1,53,55,892,-1,1411,150,1155,-1,310,150,1411,-1,1187,117,116,-1,1187,1188,117,-1,999,924,913,-1,920,924,999,-1,147,913,924,-1,147,153,913,-1,102,1026,1242,-1,1026,102,1137,-1,917,137,52,-1,137,917,136,-1,919,173,918,-1,173,919,909,-1,923,924,920,-1,924,923,910,-1,170,129,1007,-1,129,170,156,-1,97,92,91,-1,996,92,97,-1,884,949,1415,-1,1161,949,884,-1,96,87,996,-1,95,87,96,-1,823,820,1151,-1,823,1004,820,-1,92,932,86,-1,932,92,994,-1,1150,937,935,-1,938,937,1150,-1,302,830,78,-1,936,830,302,-1,831,993,940,-1,993,831,832,-1,943,925,934,-1,943,76,925,-1,58,944,45,-1,944,58,282,-1,947,944,282,-1,947,945,944,-1,294,295,46,-1,294,843,295,-1,39,844,267,-1,845,844,39,-1,290,983,842,-1,290,1414,983,-1,1415,948,1413,-1,948,1415,949,-1,265,858,247,-1,265,984,858,-1,39,1142,40,-1,39,266,1142,-1,189,36,190,-1,1006,36,189,-1,34,1006,1005,-1,34,36,1006,-1,955,886,1175,-1,955,887,886,-1,981,1417,1405,-1,229,1417,981,-1,868,979,869,-1,868,1416,979,-1,1172,960,1167,-1,960,1172,961,-1,1206,962,961,-1,962,1206,963,-1,25,188,965,-1,25,235,188,-1,1394,1014,864,-1,1394,1220,1014,-1,965,977,959,-1,188,977,965,-1,970,861,261,-1,970,968,861,-1,975,2,264,-1,1170,2,975,-1,1015,972,1404,-1,1015,973,972,-1,968,1404,969,-1,968,970,1404,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc5_Coord_9_59_point_1()
		{
			double[] value = {0.0,53.82202,-1.76814,-.12786,53.76951,-1.82154,-.06137,53.82115,-1.75411,-.08286,53.41889,-2.27255,-.04873,53.41271,-2.19331,-.07927,53.39055,-2.24244,-.11143,53.39068,-2.31553,-.1141,53.3685,-2.28827,-.14578,53.31215,-2.35443,-.19636,53.42911,-2.29284,-.20165,53.35865,-2.31984,-.1703,53.36728,-2.27368,-.39331,53.86847,-1.41602,-.38895,53.86957,-1.40898,-.33645,53.85249,-1.49252,-.18802,53.29708,-2.33971,-.16601,53.28234,-2.31909,-.16967,53.28137,-2.31577,-.19295,53.29934,-2.33048,-.11456,53.33898,-2.18953,-.11727,53.3396,-2.18899,-.13675,53.32764,-2.24788,-.13166,53.3707,-2.03615,-.13447,53.372,-2.03761,-.1115,53.33491,-2.12926,-.39925,53.43061,-1.59222,-.40039,53.54354,-1.58035,-.35008,53.54131,-1.64526,-.15501,53.60473,-1.72153,-.18938,53.51729,-1.74443,-.11624,53.5213,-1.81352,-.8711,53.5544,-1.2363,-.87101,53.55887,-1.23886,-.91568,53.50623,-1.29032,-.44296,53.44075,-1.44379,-.44746,53.43586,-1.44524,-.4411,53.43844,-1.44744,-.87021,53.56177,-1.23459,-.76994,53.76449,-1.40872,-.76463,53.77596,-1.41509,-.76791,53.76269,-1.41461,-.46941,53.84153,-1.38102,-.54377,53.82169,-1.39125,-.56967,53.87369,-1.32172,-.91011,53.46552,-1.0376,-.91371,53.45016,-1.00778,-.98407,53.49584,-1.0115,-.83985,53.69188,-1.17363,-.76688,53.63233,-1.16361,-.78839,53.60219,-1.11407,-.84563,53.50541,-1.06692,-.84143,53.54998,-1.08749,-.69549,53.55652,-1.06593,-.76556,53.41705,-.93737,-.77379,53.4271,-.93291,-.76832,53.41696,-.94048,-.74822,53.41197,-1.04821,-.77785,53.40243,-.99959,-.86081,53.42675,-1.01835,-.70473,53.39801,-.92386,-.72077,53.39575,-.95967,-.69299,53.40241,-.96685,-.78263,53.85071,-1.07101,-.77722,53.86683,-1.06404,-.82341,53.94666,-1.06099,-.91961,53.65889,-.98848,-.97315,53.57491,-.9677,-.91406,53.65139,-.97874,-.80532,53.76443,-1.06361,-.81271,53.77835,-1.07104,-.83815,53.71308,-1.04501,-.75128,53.63351,-.77925,-.74635,53.53984,-.82364,-.75007,53.62903,-.76958,-.76951,53.84924,-1.06622,-.78297,53.4591,-.92671,-.77085,53.46268,-.90582,-.77331,53.47409,-.90549,-.71902,53.68152,-.74735,-.68119,53.63396,-.7144,-.65973,53.71424,-.72283,-.56627,53.69607,-1.10756,-.50634,53.73443,-1.1248,-.58099,53.73474,-1.11063,-.43788,53.77051,-1.11354,-.39256,53.80573,-1.14105,-.42144,53.78056,-1.17648,-.4619,53.90598,-1.1916,-.50687,53.87216,-1.15403,-.51256,53.79211,-1.1646,-.37329,53.74569,-1.22187,-.41256,53.74584,-1.22692,-.45171,53.7863,-1.18542,-.40945,53.90757,-1.31026,-.43256,53.94493,-1.25071,-.42736,53.90136,-1.24839,-.43337,53.82995,-1.24253,-.43792,53.7759,-1.23809,-.42757,53.72432,-1.27449,-.38227,53.47528,-.894};
			return value;
		}
		private double[] getc5_Coord_9_59_point_2()
		{
			double[] value = {-.41278,53.47489,-.92652,-.37273,53.43765,-.94311,-.57357,53.5035,-.85942,-.65335,53.47577,-.83905,-.63646,53.43353,-.88542,-.65586,53.58668,-.92095,-.65631,53.53939,-.92789,-.64285,53.5367,-.99842,-.58098,53.56186,-1.03428,-.581,53.56654,-1.03062,-.61258,53.55131,-1.01432,-.56665,53.48412,-.88781,-.56665,53.48655,-.89199,-.50411,53.50115,-.9201,-.49167,53.5352,-1.03039,-.48045,53.52986,-.96954,-.49315,53.54432,-1.02407,-.53475,53.56719,-1.04291,-.5397,53.56123,-1.04771,-.49979,53.4972,-.91831,-.43886,53.48472,-.96239,-.66325,53.57934,-1.00412,-.68888,53.5851,-1.02685,-.69582,53.57888,-1.01875,-.64801,53.527,-1.01454,-.67544,53.46827,-.9884,-.69608,53.46056,-1.03478,-.58341,53.56376,-1.0414,-.58044,53.56521,-1.05143,-.55844,53.56101,-1.07391,-.70127,53.59869,-1.05577,-.69527,53.5957,-1.06142,-.67953,53.63669,-1.08001,-.59623,53.66915,-1.0967,-.59007,53.67944,-1.0987,-.63221,53.6857,-1.09841,-.67973,53.58969,-1.08566,-.69251,53.56706,-1.06262,-.49982,53.57825,-.92031,-.48624,53.58779,-.97595,-.59571,53.7734,-1.1137,-.6057,53.84227,-1.09404,-.68146,53.83675,-1.06852,-.71129,53.66971,-1.08182,-.63907,53.73196,-1.10128,-.80357,53.77944,-1.06419,-.61416,53.62355,-1.02238,-.65635,53.59337,-1.01451,-.68509,53.64733,-1.08004,-.71575,53.58485,-1.04447,-.48229,53.74154,-1.01967,-.56096,53.68843,-1.04382,-.55356,53.65473,-1.03936,-.62528,53.62534,-1.02397,-.49373,53.5419,-1.16718,-.47965,53.52643,-1.14995,-.52076,53.54171,-1.10475,-.37498,53.39404,-1.15261,-.3756,53.39349,-1.03515,-.38456,53.39896,-1.15212,-.29718,53.37563,-1.28089,-.29666,53.36994,-1.27553,-.30674,53.37789,-1.27716,-.234,53.74684,-.84071,-.22525,53.74127,-.84191,-.22115,53.77663,-.92511,-.40718,53.70589,-1.24602,-.35806,53.5096,-1.49957,-.33963,53.58503,-1.50039,-.39038,53.66177,-1.38836,-.53754,53.56,-1.21874,-.63878,53.58674,-1.21681,-.54287,53.56463,-1.25822,-.62901,53.58155,-1.10999,-.69914,53.60147,-1.15355,-.62958,53.57888,-1.15109,-.41528,53.44554,-1.20215,-.37231,53.44782,-1.23569,-.37035,53.40207,-1.22319,-.35237,53.34352,-.92879,-.34674,53.32371,-.88504,-.35552,53.40125,-.89784,-.35587,53.35679,-.94409,-.41056,53.464,-1.02947,-.38284,53.40067,-1.03331,-.33728,53.2835,-.88119,-.26309,53.27578,-.92061,-.25313,53.24362,-.88283,-.46102,53.38649,-1.57165,-.42031,53.43039,-1.53094,-.48657,53.37804,-1.525,-.49052,53.57951,-1.25985,-.45087,53.58072,-1.23716,-.47868,53.51751,-1.04378,-.19005,53.27108,-.89973,-.17517,53.23647,-.84531,-.19044,53.32223,-.97368,-.25761,53.30521,-.96929,-.26688,53.35101,-1.05499,-.11181,53.34152,-1.27828};
			return value;
		}
		private double[] getc5_Coord_9_59_point_3()
		{
			double[] value = {-.11496,53.35716,-1.21968,-.20144,53.35985,-1.21925,-.27646,53.36751,-1.22065,-.36427,53.39576,-1.21776,-.27363,53.37478,-1.15211,-.276,53.86907,-.98934,-.2172,53.81223,-1.0006,-.21509,53.85813,-1.08336,-.15854,53.78492,-.99507,-.07547,53.76929,-.99375,-.07203,53.80117,-1.10239,-.16197,53.75919,-.91546,-.32994,53.90908,-.97837,-.32752,53.89662,-.88803,-.27512,53.82808,-.9131,-.26589,53.78657,-.82213,-.31619,53.86883,-.80757,-.37028,53.9292,-.78738,-.33122,53.86734,-.7065,-.12546,53.44961,-2.14259,-.15084,53.5023,-2.00856,-.14081,53.41841,-1.96784,-.14239,53.43447,-1.92091,-.15642,53.4766,-2.22155,-.13935,53.58472,-2.0226,-.13287,53.56954,-2.08568,-.13,53.47398,-2.06982,-.33893,53.6206,-1.62835,-.65512,53.38889,-1.46799,-.65615,53.3323,-1.5324,-.56067,53.33827,-1.55355,-.69252,53.50485,-1.32129,-.76673,53.50864,-1.30146,-.82721,53.4935,-1.31928,-.37617,53.4667,-1.54379,-.39784,53.42924,-1.58978,-.33583,53.42871,-1.63333,-.08481,53.59214,-1.77353,-.05754,53.5112,-1.87389,-.137,53.4166,-1.96683,-.04003,53.46401,-1.95477,-.0421,53.42813,-2.04108,-.10859,53.3342,-2.12835,-.07812,53.614,-2.09559,-.10474,53.70433,-1.92573,-.16035,53.5956,-1.94031,-.18228,53.60721,-1.86916,-.5064,53.75375,-1.46156,-.49467,53.71418,-1.51059,-.59221,53.69659,-1.49759,-.64507,53.75252,-1.45031,-.6514,53.68857,-1.48625,-.72539,53.67853,-1.47124,-.15641,53.69819,-1.85662,-.06238,53.74344,-1.73724,-.0681,53.66574,-1.75338,0.0,53.65995,-1.78296,0.0,53.44627,-2.03341,0.0,53.4455,-2.10664,0.0,53.54024,-2.1998,0.0,53.4773,-2.20334,-.0577,53.50646,-2.22004,-.09451,53.65486,-2.01848,0.0,53.71472,-1.96947,-.14035,53.82291,-1.72363,-.50913,53.76588,-1.45779,-.68726,53.76927,-1.44781,-.66288,53.83682,-1.38115,-.39908,53.87774,-1.40965,-.46615,53.90741,-1.32217,-.91784,53.53939,-1.36675,-.87908,53.5723,-1.43083,-.90924,53.44833,-1.44543,-.78792,53.67218,-1.45545,-.8209,53.59329,-1.48201,-.85402,53.61476,-1.24939,-.85316,53.66637,-1.3107,-.84591,53.77846,-1.30062,-.81121,53.72191,-1.361,-.77155,53.61118,-1.18919,-.69118,53.60049,-1.20069,-.80696,53.41009,-.97112,-.86203,53.42016,-.97975,-.84465,53.62157,-1.10688,-.83535,53.66255,-1.20367,-.86944,53.77221,-1.21368,-.84913,53.73767,-1.25932,-.92378,53.6456,-1.02047,-.86506,53.82487,-1.15211,-.85826,53.90294,-1.17802,-.82042,54.02045,-1.11883,-.74465,53.64612,-1.07907,-.74543,53.56595,-1.03101,-.72466,53.56419,-.99343,-.98692,53.56986,-1.01861,-.91236,53.51981,-1.05128,-.78016,53.53779,-.98395,-.80849,53.46954,-.94948,-.78323,53.47175,-.92556,-.71415,53.58752,-.88295};
			return value;
		}
		private double[] getc5_Coord_9_59_point_4()
		{
			double[] value = {-.70194,53.64691,-.84381,-.59147,53.74413,-.77965,-.67012,53.7405,-.74436,-.69584,53.70126,-.81799,-.63614,53.66351,-.86789,-.66496,53.62691,-.9085,-.31696,53.78423,-1.21857,-.48319,53.7353,-1.08603,-.46231,53.82011,-1.00828,-.45875,53.81613,-.92562,-.46385,53.73399,-.95244,-.49267,53.71712,-.88517,-.45308,53.82309,-.81003,-.51155,53.70916,-.78931,-.42417,53.78113,-.77478,-.27549,53.48448,-.84121,-.28668,53.43685,-.83538,-.25709,53.42728,-.80399,-.24055,53.4683,-.80533,-.25268,53.52178,-.79458,-.39371,53.82705,-.72637,-.42508,53.86657,-.80097,-.4362,53.88727,-.91103,-.42188,53.89269,-.99951,-.31856,53.79936,-.68836,-.37215,53.78889,-.71916,-.36536,53.73406,-.72901,-.24778,53.6643,-.73483,-.35418,53.67233,-.76237,-.32346,53.60667,-.79401,-.22987,53.55908,-.74808,-.24116,53.6578,-.73415,.49052,53.57951,-1.25985,.45087,53.58072,-1.23716,.41003,53.66698,-1.25762,.42508,53.86657,-.80097,.33811,53.86635,-.70335,.39371,53.82705,-.72637,.39664,53.95627,-.97139,.38958,53.95284,-.88133,.4362,53.88727,-.91103,.30534,53.84864,-1.20658,.24279,53.72722,-1.24578,.23137,53.80291,-1.22002,.46231,53.82011,-1.00828,.39256,53.80573,-1.14105,.39004,53.87934,-1.12314,.4283,53.8711,-.81457,.45898,53.8208,-.819,.35418,53.67233,-.76237,.32346,53.60667,-.79401,.40377,53.63624,-.7932,.27549,53.48448,-.84121,.29947,53.54558,-.81754,.25268,53.52178,-.79458,.24055,53.4683,-.80533,.25709,53.42728,-.80399,.32888,53.47988,-.8676,.32968,53.50737,-.84796,.49382,53.57386,-.83252,.49447,53.64451,-.80295,.53896,53.72793,-.84709,.49267,53.71712,-.88517,.48229,53.74154,-1.01967,.45875,53.81613,-.92562,.37719,53.70105,-1.23577,.31696,53.78423,-1.21857,.37329,53.74569,-1.22187,.26609,53.61057,-1.26564,.18253,53.49668,-1.28441,.17337,53.58838,-1.25814,.60882,53.64701,-.7545,.59147,53.74413,-.77965,.51155,53.70916,-.78931,.60456,53.70275,-.7514,.63614,53.66351,-.86789,.61474,53.71663,-.82401,.65586,53.58668,-.92095,.66496,53.62691,-.9085,.59355,53.74593,-.78557,.6729,53.74405,-.75496,.66326,53.72881,-.80055,.75128,53.63351,-.77925,.70194,53.64691,-.84381,.69584,53.70126,-.81799,.98692,53.56986,-1.01861,.9146,53.5741,-1.06505,.92378,53.6456,-1.02047,.82217,53.57649,-.98418,.91187,53.65522,-.98155,.82991,53.71144,-1.04013,.55153,53.77263,-1.13971,.53115,53.75263,-1.13701,.58099,53.73474,-1.11063,.64592,53.77821,-1.10416,.63907,53.73196,-1.10128,.80357,53.77944,-1.06419,.72728,54.03577,-1.09942,.70583,53.92016,-1.05579,.82341,53.94666,-1.06099};
			return value;
		}
		private double[] getc5_Coord_9_59_point_5()
		{
			double[] value = {.78263,53.85071,-1.07101,.86506,53.82487,-1.15211,.85399,53.67522,-1.07104,.84064,53.7525,-1.1425,.81271,53.77835,-1.07104,.85826,53.90294,-1.17802,.8755,53.83091,-1.26626,.85319,53.91442,-1.28002,.83985,53.69188,-1.17363,.69549,53.55652,-1.06593,.67922,53.58514,-1.09291,.78839,53.60219,-1.11407,.85402,53.61476,-1.24939,.85316,53.66637,-1.3107,.84913,53.73767,-1.25932,.79129,53.57018,-1.23461,.87021,53.56177,-1.23459,.91568,53.50623,-1.29032,.92947,53.42214,-1.37768,.91784,53.53939,-1.36675,.72166,53.88106,-1.34364,.75877,53.9401,-1.27024,.84612,53.91985,-1.28278,.39908,53.87774,-1.40965,.46941,53.84153,-1.38102,.4304,53.80317,-1.4558,.66288,53.83682,-1.38115,.65004,53.88438,-1.31034,.46615,53.90741,-1.32217,.56967,53.87369,-1.32172,.26104,53.76883,-1.67585,.20419,53.76112,-1.76449,.14035,53.82291,-1.72363,0.0,53.76693,-1.87148,.12786,53.76951,-1.82154,.05754,53.5112,-1.87389,0.0,53.48298,-1.94557,.04003,53.46401,-1.95477,.21821,53.69458,-1.77329,.0421,53.42813,-2.04108,.13166,53.3707,-2.03615,.137,53.4166,-1.96683,.13515,53.4319,-1.9182,.17492,53.43321,-1.8607,.11624,53.5213,-1.81352,.18938,53.51729,-1.74443,.24103,53.51804,-1.67666,.23703,53.59586,-1.65115,.54287,53.56463,-1.25822,.46216,53.58164,-1.34391,.48867,53.49802,-1.36504,.60932,53.49085,-1.35429,.49297,53.49265,-1.36732,.55139,53.45994,-1.39302,.54139,53.40152,-1.46981,.59001,53.38495,-1.47767,.52421,53.43001,-1.4331,.13056,53.42983,-2.31765,.13679,53.36828,-2.34892,.11143,53.39068,-2.31553,.19349,53.53464,-1.87814,.18036,53.43504,-1.86506,.14239,53.43447,-1.92091,.13447,53.372,-2.03761,.13,53.47398,-2.06982,.15084,53.5023,-2.00856,.13675,53.32764,-2.24788,.1703,53.36728,-2.27368,.14885,53.41816,-2.20421,.26723,53.75503,-.74205,.26589,53.78657,-.82213,.234,53.74684,-.84071,.23398,53.69832,-.76557,.22525,53.74127,-.84191,.16564,53.68969,-.75165,.36427,53.39576,-1.21776,.37498,53.39404,-1.15261,.27363,53.37478,-1.15211,.09677,53.28842,-.88253,.19044,53.32223,-.97368,.19005,53.27108,-.89973,.38284,53.40067,-1.03331,.38456,53.39896,-1.15212,.44373,53.45777,-1.13721,.37231,53.44782,-1.23569,.35096,53.5585,-1.243,.40753,53.55834,-1.22754,.30674,53.37789,-1.27716,.37035,53.40207,-1.22319,.74211,53.53759,-.92144,.76852,53.47895,-.87151,.77331,53.47409,-.90549,.76951,53.84924,-1.06622,.68146,53.83675,-1.06852,.56893,53.92049,-1.2592,.52444,53.96413,-1.23503,.58739,53.94216,-1.23713,.26309,53.27578,-.92061,.25313,53.24362,-.88283,.33728,53.2835,-.88119};
			return value;
		}
		private double[] getc5_Coord_9_59_point_6()
		{
			double[] value = {.25761,53.30521,-.96929,.34918,53.34852,-.94534,.3026,53.28913,-.81751,.29556,53.24528,-.81665,.3414,53.2885,-.87495,.41528,53.44554,-1.20215,.47965,53.52643,-1.14995,.61218,53.55206,-1.02033,.61178,53.54689,-1.0169,.58098,53.56186,-1.03428,.7475,53.39853,-.97803,.77785,53.40243,-.99959,.80696,53.41009,-.97112,.62958,53.57888,-1.15109,.63878,53.58674,-1.21681,.69118,53.60049,-1.20069,.53754,53.56,-1.21874,.65795,53.47301,-.93594,.66757,53.42136,-.92688,.63646,53.43353,-.88542,.38277,53.6616,-1.244,.39038,53.66177,-1.38836,.41659,53.76718,-1.33069,.38714,53.74161,-1.39267,.29897,53.82691,-.75565,.28801,53.79246,-.73871,.31174,53.80094,-.69095,.2423,53.20698,-.78127,.29379,53.24058,-.82374,.37408,53.40087,-1.21658,.54313,53.65055,-.87201,.63663,53.59389,-.89304,.65073,53.55884,-.99617,.61416,53.62355,-1.02238,.60229,53.59215,-1.02414,.56096,53.68843,-1.04382,.48319,53.7353,-1.08603,.63096,53.67092,-1.09929,.59623,53.66915,-1.0967,.59362,53.57926,-1.09052,.67953,53.63669,-1.08001,.68509,53.64733,-1.08004,.63221,53.6857,-1.09841,.69527,53.5957,-1.06142,.68127,53.58796,-1.03515,.68888,53.5851,-1.02685,.64475,53.53012,-1.00337,.64429,53.53169,-1.01125,.6467,53.53736,-1.01688,.64801,53.527,-1.01454,.62901,53.58155,-1.10999,.67973,53.58969,-1.08566,.67701,53.53263,-1.03559,.65567,53.58984,-1.01872,.65635,53.59337,-1.01451,.47868,53.51751,-1.04378,.52076,53.54171,-1.10475,.53491,53.55962,-1.04806,.49167,53.5352,-1.03039,.74126,53.42648,-.91847,.70473,53.39801,-.92386,.72077,53.39575,-.95967,.56665,53.48655,-.89199,.63259,53.47305,-.91172,.63443,53.46262,-.90979,.61258,53.55131,-1.01432,.65631,53.53939,-.92789,.64285,53.5367,-.99842,.65625,53.48407,-.93356,.50411,53.50115,-.9201,.49979,53.4972,-.91831,.47515,53.52101,-.97284,.4218,53.67298,-1.3442,.38895,53.86957,-1.40898,.38925,53.82223,-1.40129,.41987,53.86177,-1.32049,.41256,53.74584,-1.22692,.4619,53.90598,-1.1916,.50687,53.87216,-1.15403,.50135,53.91607,-1.15421,.43788,53.77051,-1.11354,.46382,53.76222,-1.1474,.50634,53.73443,-1.1248,.49026,53.77355,-1.16113,.86727,53.52043,-.9442,.85964,53.53143,-.94593,.80849,53.46954,-.94948,.97315,53.57491,-.9677,.9551,53.57843,-.94374,.96606,53.56806,-.94294,.53002,53.76455,-.79124,.53285,53.7661,-.79664,.78297,53.4591,-.92671,.77085,53.46268,-.90582,.77379,53.4271,-.93291,.76462,53.46873,-.86578,.74384,53.52993,-.8174,.70698,53.49207,-.81158,.91011,53.46552,-1.0376,.91371,53.45016,-1.00778};
			return value;
		}
		private double[] getc5_Coord_9_59_point_7()
		{
			double[] value = {.86081,53.42675,-1.01835,.9086,53.44972,-.97205,.8614,53.42542,-.96998,.97425,53.49029,-.96513,.91252,53.44504,-.98184,.81058,53.41854,-.96177,.86203,53.42016,-.97975,.69914,53.60147,-1.15355,.76688,53.63233,-1.16361,.51196,53.99716,-1.15276,.5146,53.99844,-1.15033,.51558,54.00144,-1.1571,.85531,53.97947,-1.20671,.40945,53.90757,-1.31026,.81652,53.8364,-1.3438,.76463,53.77596,-1.41509,.80924,53.84283,-1.34673,.78596,53.5702,-1.23043,.7867,53.56357,-1.23434,.92711,53.41376,-1.38575,.92883,53.41682,-1.38272,.92678,53.41537,-1.3783,.65688,53.33286,-1.53711,.56067,53.33827,-1.55355,.56015,53.33965,-1.55802,.22325,53.83898,-1.643,.14159,53.7431,-1.70988,.2258,53.76277,-1.6421,.14338,53.6825,-1.70963,.06238,53.74344,-1.73724,.35806,53.5096,-1.49957,.29711,53.50795,-1.59765,.37617,53.4667,-1.54379,.39784,53.42924,-1.58978,.33583,53.42871,-1.63333,.39925,53.43061,-1.59222,.54803,53.34243,-1.55585,.19295,53.29934,-2.33048,.18802,53.29708,-2.33971,.19462,53.36087,-2.32772,.07299,53.56251,-2.15704,.07812,53.614,-2.09559,.13287,53.56954,-2.08568,.1852,53.43551,-2.2982,.19636,53.42911,-2.29284,.10034,53.4708,-2.27171,.09459,53.46458,-2.27211,.0577,53.50646,-2.22004,.14424,53.36389,-2.35642,.15321,53.30447,-2.35934,.13295,53.3274,-2.24918,.16601,53.28234,-2.31909,.16967,53.28137,-2.31577,.1115,53.33491,-2.12926,.13612,53.53585,-2.15199,.15642,53.4766,-2.22155,.12553,53.54236,-2.15303,.06137,53.82115,-1.75411,.04879,53.43952,-2.23936,.08286,53.41889,-2.27255,.04873,53.41271,-2.19331,.14578,53.31215,-2.35443,.1141,53.3685,-2.28827,.20165,53.35865,-2.31984,.39331,53.86847,-1.41602,.34203,53.85411,-1.49493,.11727,53.3396,-2.18899,.10859,53.3342,-2.12835,.35008,53.54131,-1.64526,.40039,53.54354,-1.58035,.15501,53.60473,-1.72153,.8711,53.5544,-1.2363,.91194,53.50289,-1.28758,.87101,53.55887,-1.23886,.44296,53.44075,-1.44379,.4411,53.43844,-1.44744,.44746,53.43586,-1.44524,.76994,53.76449,-1.40872,.76791,53.76269,-1.41461,.54377,53.82169,-1.39125,.59539,53.76778,-1.45393,.98407,53.49584,-1.0115,.84563,53.50541,-1.06692,.71945,53.45757,-1.07119,.74822,53.41197,-1.04821,.69299,53.40241,-.96685,.91961,53.65889,-.98848,.83815,53.71308,-1.04501,.7434,53.5376,-.81254,.74635,53.53984,-.82364,.91406,53.65139,-.97874,.86753,53.53611,-.94461,.78323,53.47175,-.92556,.65973,53.71424,-.72283,.68119,53.63396,-.7144,.71902,53.68152,-.74735,.56627,53.69607,-1.10756,.42144,53.78056,-1.17648,.47359,53.81159,-1.18948,.51256,53.79211,-1.1646};
			return value;
		}
		private double[] getc5_Coord_9_59_point_8()
		{
			double[] value = {.45171,53.7863,-1.18542,.43256,53.94493,-1.25071,.42736,53.90136,-1.24839,.43886,53.48472,-.96239,.41056,53.464,-1.02947,.57357,53.5035,-.85942,.56665,53.48412,-.88781,.581,53.56654,-1.03062,.49315,53.54432,-1.02407,.48045,53.52986,-.96954,.5397,53.56123,-1.04771,.53475,53.56719,-1.04291,.66325,53.57934,-1.00412,.69582,53.57888,-1.01875,.69608,53.46056,-1.03478,.7206,53.40719,-1.00753,.70127,53.59869,-1.05577,.69251,53.56706,-1.06262,.54591,53.60799,-1.04218,.50411,53.61345,-1.02949,.48624,53.58779,-.97595,.49982,53.57825,-.92031,.6057,53.84227,-1.09404,.59571,53.7734,-1.1137,.71129,53.66971,-1.08182,.62528,53.62534,-1.02397,.70388,53.56242,-.95586,.41278,53.47489,-.92652,.37273,53.43765,-.94311,.35587,53.35679,-.94409,.35237,53.34352,-.92879,.22178,53.45725,-.77524,.22115,53.77663,-.92511,.42757,53.72432,-1.27449,.40718,53.70589,-1.24602,.33963,53.58503,-1.50039,.35552,53.40125,-.89784,.34674,53.32371,-.88504,.32863,53.71393,-1.22802,.65335,53.47577,-.83905,.69242,53.55568,-.76291,.46102,53.38649,-1.57165,.48657,53.37804,-1.525,.17517,53.23647,-.84531,.26688,53.35101,-1.05499,.27646,53.36751,-1.22065,.20492,53.36052,-1.15258,.20144,53.35985,-1.21925,.3756,53.39349,-1.03515,.07505,53.20563,-.70068,.05998,53.28462,-.69011,0.0,53.28306,-.68145,.276,53.86907,-.98934,.21509,53.85813,-1.08336,.2172,53.81223,-1.0006,.15854,53.78492,-.99507,.07203,53.80117,-1.10239,.07547,53.76929,-.99375,.16197,53.75919,-.91546,.27512,53.82808,-.9131,.32752,53.89662,-.88803,.32994,53.90908,-.97837,.14081,53.41841,-1.96784,.16865,53.52138,-1.94057,.13935,53.58472,-2.0226,.08481,53.59214,-1.77353,.06106,53.58788,-1.79113,.03586,53.41741,-2.11679,.09451,53.65486,-2.01848,.10474,53.70433,-1.92573,.15641,53.69819,-1.85662,.18228,53.60721,-1.86916,.5064,53.75375,-1.46156,.59515,53.75459,-1.4561,.59221,53.69659,-1.49759,.64507,53.75252,-1.45031,.68925,53.75589,-1.44789,.72539,53.67853,-1.47124,.30024,53.85092,-1.5637,.31279,53.78553,-1.59338,.50913,53.76588,-1.45779,.41384,53.91215,-1.31341,.8209,53.59329,-1.48201,.78792,53.67218,-1.45545,.83563,53.63784,-1.40079,.87355,53.60674,-1.33257,.81121,53.72191,-1.361,.84591,53.77846,-1.30062,.77155,53.61118,-1.18919,.86944,53.77221,-1.21368,.861,53.97512,-1.20192,.82042,54.02045,-1.11883,.74465,53.64612,-1.07907,.71575,53.58485,-1.04447,.74543,53.56595,-1.03101,.72466,53.56419,-.99343,.91236,53.51981,-1.05128,.78016,53.53779,-.98395,.67012,53.7405,-.74436,.71415,53.58752,-.88295};
			return value;
		}
		private double[] getc5_Coord_9_59_point_9()
		{
			double[] value = {.46385,53.73399,-.95244,.45308,53.82309,-.81003,.28668,53.43685,-.83538,.42188,53.89269,-.99951,.24778,53.6643,-.73483,.24116,53.6578,-.73415,-.42731,53.67197,-1.29071,-.41003,53.66698,-1.25762,-.39664,53.95627,-.97139,-.38958,53.95284,-.88133,-.39004,53.87934,-1.12314,-.45898,53.8208,-.819,-.4283,53.8711,-.81457,-.40377,53.63624,-.7932,-.4142,53.71475,-.77342,-.31551,53.44287,-.86946,-.38386,53.53026,-.85472,-.49447,53.64451,-.80295,-.53896,53.72793,-.84709,-.53285,53.7661,-.79664,-.32863,53.71393,-1.22802,-.37719,53.70105,-1.23577,-.27219,53.51967,-1.27759,-.26609,53.61057,-1.26564,-.17337,53.58838,-1.25814,-.53002,53.76455,-.79124,-.61474,53.71663,-.82401,-.59355,53.74593,-.78557,-.66326,53.72881,-.80055,-.69575,53.39564,-.88943,-.72032,53.68636,-.75799,-.86753,53.53611,-.94461,-.9551,53.57843,-.94374,-.82217,53.57649,-.98418,-.78701,53.62871,-1.04916,-.82991,53.71144,-1.04013,-.64592,53.77821,-1.10416,-.70583,53.92016,-1.05579,-.72728,54.03577,-1.09942,-.84064,53.7525,-1.1425,-.85399,53.67522,-1.07104,-.8755,53.83091,-1.26626,-.861,53.97512,-1.20192,-.9146,53.5741,-1.06505,-.72166,53.88106,-1.34364,-.80924,53.84283,-1.34673,-.84612,53.91985,-1.28278,-.59539,53.76778,-1.45393,-.65004,53.88438,-1.31034,-.6907,53.92775,-1.26624,-.63581,53.91428,-1.27207,-.62158,53.94936,-1.22596,-.56893,53.92049,-1.2592,-.30024,53.85092,-1.5637,-.36546,53.78859,-1.53019,-.34203,53.85411,-1.49493,-.26104,53.76883,-1.67585,-.22737,53.84065,-1.64699,-.42285,53.79226,-1.45924,-.40554,53.71717,-1.52247,-.21821,53.69458,-1.77329,-.12553,53.54236,-2.15303,-.13612,53.53585,-2.15199,-.04879,53.43952,-2.23936,-.17492,53.43321,-1.8607,-.13515,53.4319,-1.9182,-.23703,53.59586,-1.65115,-.24103,53.51804,-1.67666,-.56032,53.53357,-1.29969,-.48867,53.49802,-1.36504,-.46216,53.58164,-1.34391,-.16865,53.52138,-1.94057,-.19349,53.53464,-1.87814,-.26723,53.75503,-.74205,-.23398,53.69832,-.76557,-.16444,53.72508,-.83381,-.32317,53.90915,-1.04193,-.15636,53.19932,-.73402,-.08824,53.23472,-.80468,-.07381,53.20176,-.70669,-.10451,53.32227,-.96478,-.09677,53.28842,-.88253,-.44373,53.45777,-1.13721,-.40753,53.55834,-1.22754,-.52444,53.96413,-1.23503,-.4901,53.93851,-1.27737,-.72315,53.56365,-1.23162,-.7867,53.56357,-1.23434,-.3026,53.28913,-.81751,-.3414,53.2885,-.87495,-.29556,53.24528,-.81665,-.61178,53.54689,-1.0169,-.7475,53.39853,-.97803,-.65795,53.47301,-.93594,-.63443,53.46262,-.90979,-.35096,53.5585,-1.243,-.38277,53.6616,-1.244,-.29897,53.82691,-.75565,-.28801,53.79246,-.73871,-.23869,53.37009,-.76683};
			return value;
		}
		private double[] getc5_Coord_9_59_point_10()
		{
			double[] value = {-.22178,53.45725,-.77524,-.2423,53.20698,-.78127,-.29379,53.24058,-.82374,-.37408,53.40087,-1.21658,-.54313,53.65055,-.87201,-.55571,53.56689,-.88517,-.63663,53.59389,-.89304,-.65073,53.55884,-.99617,-.63096,53.67092,-1.09929,-.62906,53.58753,-1.10404,-.68127,53.58796,-1.03515,-.58672,53.67474,-1.05162,-.59283,53.66509,-1.05991,-.62381,53.62208,-1.02974,-.61218,53.55206,-1.02033,-.64475,53.53012,-1.00337,-.58565,53.57074,-1.04746,-.67922,53.58514,-1.09291,-.58956,53.57256,-1.09407,-.59362,53.57926,-1.09052,-.6467,53.53736,-1.01688,-.64429,53.53169,-1.01125,-.67701,53.53263,-1.03559,-.67558,53.54461,-1.03399,-.65567,53.58984,-1.01872,-.74126,53.42648,-.91847,-.63259,53.47305,-.91172,-.65625,53.48407,-.93356,-.47515,53.52101,-.97284,-.4218,53.67298,-1.3442,-.41987,53.86177,-1.32049,-.50135,53.91607,-1.15421,-.46382,53.76222,-1.1474,-.53115,53.75263,-1.13701,-.73264,53.42916,-.87532,-.70698,53.49207,-.81158,-.6729,53.74405,-.75496,-.74384,53.52993,-.8174,-.7434,53.5376,-.81254,-.85964,53.53143,-.94593,-.86727,53.52043,-.9442,-.81333,53.4555,-.95031,-.3776,53.92903,-.78594,-.76462,53.46873,-.86578,-.91252,53.44504,-.98184,-.9086,53.44972,-.97205,-.97425,53.49029,-.96513,-.8614,53.42542,-.96998,-.51196,53.99716,-1.15276,-.51558,54.00144,-1.1571,-.5146,53.99844,-1.15033,-.85319,53.91442,-1.28002,-.41384,53.91215,-1.31341,-.81652,53.8364,-1.3438,-.79129,53.57018,-1.23461,-.78596,53.5702,-1.23043,-.92883,53.41682,-1.38272,-.92678,53.41537,-1.3783,-.92947,53.42214,-1.37768,-.56015,53.33965,-1.55802,-.22325,53.83898,-1.643,-.2258,53.76277,-1.6421,-.14159,53.7431,-1.70988,-.14338,53.6825,-1.70963,-.34011,53.43048,-1.63705,-.4637,53.38802,-1.5762,-.46662,53.42726,-1.59118,-.19462,53.36087,-2.32772,-.14804,53.48529,-2.22816,-.1852,53.43551,-2.2982,-.10034,53.4708,-2.27171,-.09459,53.46458,-2.27211,-.14424,53.36389,-2.35642,-.13679,53.36828,-2.34892,-.15321,53.30447,-2.35934,-.13395,53.81897,-1.71782,-.07299,53.56251,-2.15704,-.54803,53.34243,-1.55585,-.29711,53.50795,-1.59765,-.49297,53.49265,-1.36732,-.48727,53.49686,-1.36745,-.65688,53.33286,-1.53711,-.92711,53.41376,-1.38575,-.85531,53.97947,-1.20671,-.4304,53.80317,-1.4558,-.42065,53.79632,-1.46049,-.75711,54.00213,-1.18565,-.68591,54.01129,-1.16485,-.66836,53.94512,-1.2338,-.64436,53.76582,-1.44916,-.81058,53.41854,-.96177,-.97747,53.48589,-.98083,-.85119,53.45761,-1.0522,-.96606,53.56806,-.94294,-.49026,53.77355,-1.16113,-.38925,53.82223,-1.40129,-.47359,53.81159,-1.18948,-.65907,53.47748,-.94299,-.70388,53.56242,-.95586,-.61677,53.55804,-1.02291};
			return value;
		}
		private double[] getc5_Coord_9_59_point_11()
		{
			double[] value = {-.60229,53.59215,-1.02414,-.66757,53.42136,-.92688,-.23773,53.20589,-.77727,-.2414,53.20962,-.77218,-.34031,53.64363,-1.23771,-.42146,53.55988,-1.40318,-.3835,53.48751,-1.48067,-.57835,53.56943,-1.10538,-.58739,53.94216,-1.23713,-.74211,53.53759,-.92144,-.76852,53.47895,-.87151,-.28712,53.89571,-1.07416,-.16564,53.68969,-.75165,-.2422,53.70304,-.76377,-.18036,53.43504,-1.86506,-.13056,53.42983,-2.31765,-.59001,53.38495,-1.47767,-.54139,53.40152,-1.46981,-.52421,53.43001,-1.4331,-.20419,53.76112,-1.76449,0.0,53.50903,-1.88269,-.31279,53.78553,-1.59338,-.75877,53.9401,-1.27024,-.91187,53.65522,-.98155,-.60456,53.70275,-.7514,-.18253,53.49668,-1.28441,-.49382,53.57386,-.83252,-.32968,53.50737,-.84796,-.32888,53.47988,-.8676,-.29947,53.54558,-.81754,.22987,53.55908,-.74808,.42417,53.78113,-.77478,.31551,53.44287,-.86946,.5027,53.51215,-.87434,.76114,53.53769,-.95269,.83535,53.66255,-1.20367,.84143,53.54998,-1.08749,.84465,53.62157,-1.10688,.87908,53.5723,-1.43083,.90924,53.44833,-1.44543,.68726,53.76927,-1.44781,.22737,53.84065,-1.64699,.6514,53.68857,-1.48625,.49467,53.71418,-1.51059,.16035,53.5956,-1.94031,.85342,53.46401,-1.35263,.82721,53.4935,-1.31928,.76673,53.50864,-1.30146,.12546,53.44961,-2.14259,.15667,53.83121,-1.09663,.28712,53.89571,-1.07416,0.0,53.20964,-.69727,.29666,53.36994,-1.27553,.1992,53.34589,-1.06445,.42031,53.43039,-1.53094,.75007,53.62903,-.76958,.49373,53.5419,-1.16718,.87235,53.35308,-1.47183,.89849,53.40608,-1.46269,.42146,53.55988,-1.40318,.43792,53.7759,-1.23809,.0681,53.66574,-1.75338,.29718,53.37563,-1.28089,.58672,53.67474,-1.05162,.55356,53.65473,-1.03936,.6348,53.53905,-.90144,.55571,53.56689,-.88517,.59007,53.67944,-1.0987,.67544,53.46827,-.9884,.55844,53.56101,-1.07391,.58044,53.56521,-1.05143,.58341,53.56376,-1.0414,.58565,53.57074,-1.04746,.61677,53.55804,-1.02291,.38227,53.47528,-.894,.77722,53.86683,-1.06404,.80532,53.76443,-1.06361,.85119,53.45761,-1.0522,.76556,53.41705,-.93737,.76832,53.41696,-.94048,.64436,53.76582,-1.44916,.54919,53.97729,-1.21063,.86817,53.34997,-1.47448,.86717,53.34965,-1.46977,.34011,53.43048,-1.63705,.11456,53.33898,-2.18953,.33645,53.85249,-1.49252,.07927,53.39055,-2.24244,.14804,53.48529,-2.22816,.13395,53.81897,-1.71782,.4637,53.38802,-1.5762,.46662,53.42726,-1.59118,.48727,53.49686,-1.36745,.65615,53.3323,-1.5324,.42285,53.79226,-1.45924,.42065,53.79632,-1.46049,.75711,54.00213,-1.18565,.66836,53.94512,-1.2338,.68591,54.01129,-1.16485,.97747,53.48589,-.98083};
			return value;
		}
		private double[] getc5_Coord_9_59_point_12()
		{
			double[] value = {.73264,53.42916,-.87532,.3776,53.92903,-.78594,.81333,53.4555,-.95031,.72032,53.68636,-.75799,.69575,53.39564,-.88943,.42731,53.67197,-1.29071,.43337,53.82995,-1.24253,.65907,53.47748,-.94299,.67558,53.54461,-1.03399,.62906,53.58753,-1.10404,.2414,53.20962,-.77218,.23773,53.20589,-.77727,.38386,53.53026,-.85472,.4142,53.71475,-.77342,.36536,53.73406,-.72901,.27775,53.72975,-.70455,.34031,53.64363,-1.23771,.3835,53.48751,-1.48067,.57835,53.56943,-1.10538,.72315,53.56365,-1.23162,.4901,53.93851,-1.27737,.10451,53.32227,-.96478,.15636,53.19932,-.73402,.07381,53.20176,-.70669,.08824,53.23472,-.80468,.16444,53.72508,-.83381,.2422,53.70304,-.76377,.56444,53.5272,-1.30286,.56032,53.53357,-1.29969,.36546,53.78859,-1.53019,.63581,53.91428,-1.27207,.6907,53.92775,-1.26624,.78701,53.62871,-1.04916,.5965,53.56211,-.80941,.27219,53.51967,-1.27759,.37215,53.78889,-.71916,-.2838,53.72509,-.70263,-.5027,53.51215,-.87434,-.76114,53.53769,-.95269,-.83563,53.63784,-1.40079,-.03586,53.41741,-2.11679,0.0,53.74001,-1.75504,-.68925,53.75589,-1.44789,-.59515,53.75459,-1.4561,-.06106,53.58788,-1.79113,-.41076,53.62175,-1.55702,-.14885,53.41816,-2.20421,-.15667,53.83121,-1.09663,-.18747,53.35058,-1.28498,-.1992,53.34589,-1.06445,-.69242,53.55568,-.76291,-.24279,53.72722,-1.24578,-.87235,53.35308,-1.47183,-.89849,53.40608,-1.46269,-.34918,53.34852,-.94534,-.49385,53.67843,-1.02653,-.6348,53.53905,-.90144,-.7206,53.40719,-1.00753,-.53491,53.55962,-1.04806,-.41659,53.76718,-1.33069,-.71945,53.45757,-1.07119,-.54919,53.97729,-1.21063,-.86817,53.34997,-1.47448,-.86717,53.34965,-1.46977,-.91194,53.50289,-1.28758,-.13295,53.3274,-2.24918,0.0,53.45373,-2.17146,-.29529,53.84964,-1.56131,-.28406,53.43966,-1.71382,-.27919,53.43799,-1.71065,-.05973,53.81608,-1.7438,-.33282,53.6912,-1.49314,-.29326,53.7724,-1.56307,-.33525,53.79921,-1.49259,-.29053,53.66856,-1.56587,-.72166,53.57044,-1.22765,-.65962,53.54887,-1.25931,-.65696,53.55507,-1.25526,-.49105,53.37856,-1.5192,-.8432,53.39921,-1.5254,-.84291,53.46892,-1.51672,-.43679,53.94897,-1.25527,-.61628,54.02291,-1.12347,-.72801,54.03864,-1.10668,-.61567,54.01996,-1.11619,-.54079,53.92616,-1.11681,-.38714,53.74161,-1.39267,-.50411,53.61345,-1.02949,-.54591,53.60799,-1.04218,-.27889,53.44479,-1.2817,0.0,53.23075,-.81171,0.0,53.20542,-.70397,-.06436,53.60727,-.67249,-.15471,53.63105,-.69859,-.15815,53.62164,-.69638,-.06356,53.61698,-.67567,-.33811,53.86635,-.70335,-.31174,53.80094,-.69095,-.38954,53.95774,-.97178,-.36812,53.9451,-1.08253};
			return value;
		}
		private double[] getc5_Coord_9_59_point_13()
		{
			double[] value = {-.36148,53.94662,-1.07865,-.16832,53.85656,-1.1567,-.06642,53.81564,-1.18172,-.17036,53.85411,-1.16532,-.06553,53.81882,-1.17317,-.55153,53.77263,-1.13971,-.22822,53.69047,-1.64149,-.29329,53.57368,-1.57288,-.5763,53.41506,-1.58513,-.55026,53.85087,-1.11651,0.0,53.35407,-1.07687,-.11465,53.34413,-1.069,0.0,53.33167,-.97957,-.20492,53.36052,-1.15258,-.24081,53.28075,-.75878,-.15811,53.20288,-.72848,-.1531,53.2822,-.71884,-.07885,53.70506,-.81955,-.07141,53.67673,-.73661,-.23608,53.66629,-.73512,-.23445,53.44726,-1.77825,-.24499,53.53925,-1.79838,-.67508,53.49369,-1.5552,-.67201,53.40223,-1.57372,-.58464,53.50203,-1.57112,-.58547,53.60008,-1.54626,-.48039,53.5284,-1.57691,-.49747,53.61628,-1.55883,-.72742,53.45275,-1.39141,-.74001,53.39578,-1.44387,-.64226,53.43836,-1.4215,-.55139,53.45994,-1.39302,-.60932,53.49085,-1.35429,-.30068,53.62008,-1.69867,-.23114,53.60731,-1.78982,-.2818,53.70717,-1.68807,-.3239,53.71125,-1.61377,0.0,53.57331,-1.819,-.60638,53.9979,-1.17885,-.85342,53.46401,-1.35263,-.85628,53.43129,-1.38772,-.63321,53.92819,-1.07479,-.5965,53.56211,-.80941,-.60882,53.64701,-.7545,-.05998,53.28462,-.69011,-.14668,53.34854,-.72559,-.0547,53.34596,-.69432,-.08787,53.57795,-1.26078,-.10116,53.48477,-1.28151,-.17158,53.68217,-1.24834,0.0,53.41348,-.68582,0.0,53.34179,-.68629,-.05457,53.41259,-.69759,-.16142,53.78213,-1.22112,-.23137,53.80291,-1.22002,-.07093,53.74801,-1.23249,.05966,53.51239,-.67913,0.0,53.60304,-.66533,0.0,53.50524,-.6686,.06436,53.60727,-.67249,.2838,53.72509,-.70263,.17036,53.85411,-1.16532,.23239,53.88562,-1.16165,.16142,53.78213,-1.22112,.17158,53.68217,-1.24834,.07093,53.74801,-1.23249,.07864,53.6635,-1.24532,.05457,53.41259,-.69759,0.0,53.5642,-1.25963,.10116,53.48477,-1.28151,0.0,53.4752,-1.28314,.08787,53.57795,-1.26078,.14668,53.34854,-.72559,.24081,53.28075,-.75878,.23869,53.37009,-.76683,.1531,53.2822,-.71884,.55026,53.85087,-1.11651,.43679,53.94897,-1.25527,.78869,53.97355,-1.2259,.81639,54.02348,-1.12616,.62158,53.94936,-1.22596,0.0,53.647,-2.07887,.3239,53.71125,-1.61377,.2818,53.70717,-1.68807,.58547,53.60008,-1.54626,.66857,53.60088,-1.52259,.30068,53.62008,-1.69867,.33893,53.6206,-1.62835,.22929,53.44532,-1.7744,.29329,53.57368,-1.57288,.65696,53.55507,-1.25526,.72166,53.57044,-1.22765,.69252,53.50485,-1.32129,.64226,53.43836,-1.4215,.72742,53.45275,-1.39141,.74001,53.39578,-1.44387,.76321,53.33291,-1.50818,.65512,53.38889,-1.46799,.58464,53.50203,-1.57112,.67508,53.49369,-1.5552};
			return value;
		}
		private double[] getc5_Coord_9_59_point_14()
		{
			double[] value = {.30317,53.5416,-1.71586,.48039,53.5284,-1.57691,.5763,53.41506,-1.58513,.07141,53.67673,-.73661,.15471,53.63105,-.69859,.06356,53.61698,-.67567,.37028,53.9292,-.78738,.38257,53.95352,-.88144,.31619,53.86883,-.80757,.07771,53.73515,-.9058,.07885,53.70506,-.81955,0.0,53.7848,-1.09408,0.0,53.75458,-.99226,.32317,53.90915,-1.04193,.16832,53.85656,-1.1567,.23005,53.88796,-1.15276,.15811,53.20288,-.72848,0.0,53.35346,-1.23146,.11181,53.34152,-1.27828,.11496,53.35716,-1.21968,0.0,53.34334,-1.29195,.11465,53.34413,-1.069,0.0,53.4116,-1.28998,.10614,53.41522,-1.2825,0.0,53.28611,-.87877,.8432,53.39921,-1.5254,.7642,53.3332,-1.5129,.76402,53.38827,-1.55017,.29053,53.66856,-1.56587,.33282,53.6912,-1.49314,0.0,53.80935,-1.17292,.06642,53.81564,-1.18172,0.0,53.80628,-1.1821,.06553,53.81882,-1.17317,.30692,53.91808,-1.14514,.36148,53.94662,-1.07865,.36812,53.9451,-1.08253,.30218,53.92057,-1.13726,.33122,53.86734,-.7065,.23608,53.66629,-.73512,.15815,53.62164,-.69638,.29788,53.38921,-.82962,.11111,53.34567,-1.28367,0.0,53.348,-1.29698,.47589,53.68264,-.96672,.49662,53.67981,-.90062,.49385,53.67843,-1.02653,.62381,53.62208,-1.02974,.59283,53.66509,-1.05991,.58956,53.57256,-1.09407,.46877,53.97149,-1.20037,.33525,53.79921,-1.49259,.60638,53.9979,-1.17885,.72801,54.03864,-1.10668,.47282,53.97559,-1.20527,.49105,53.37856,-1.5192,.65962,53.54887,-1.25931,0.0,53.81611,-1.75774,.05973,53.81608,-1.7438,.29529,53.84964,-1.56131,.13999,53.43832,-2.31993,.28406,53.43966,-1.71382,.27919,53.43799,-1.71065,.29326,53.7724,-1.56307,.84291,53.46892,-1.51672,.61628,54.02291,-1.12347,.61567,54.01996,-1.11619,.18736,53.35549,-1.29039,.18495,53.42608,-1.2873,.18747,53.35058,-1.28498,.31856,53.79936,-.68836,.38954,53.95774,-.97178,.22822,53.69047,-1.64149,0.0,53.66528,-.72901,0.0,53.61271,-.66912,.76035,53.48139,-1.53823,.23114,53.60731,-1.78982,.24499,53.53925,-1.79838,.49747,53.61628,-1.55883,.40554,53.71717,-1.52247,.41076,53.62175,-1.55702,.74115,53.5982,-1.50243,.63321,53.92819,-1.07479,.0547,53.34596,-.69432,.14822,53.53124,-.70084,-.14822,53.53124,-.70084,-.23239,53.88562,-1.16165,-.07864,53.6635,-1.24532,-.13389,53.42428,-.72862,-.87355,53.60674,-1.33257,-.81281,53.4037,-1.42386,-.78869,53.97355,-1.2259,0.0,53.59386,-2.15187,-.74115,53.5982,-1.50243,-.22929,53.44532,-1.7744,-.76035,53.48139,-1.53823,-.76402,53.38827,-1.55017,-.30317,53.5416,-1.71586,-.38257,53.95352,-.88144,-.07771,53.73515,-.9058};
			return value;
		}
		private double[] getc5_Coord_9_59_point_15()
		{
			double[] value = {-.30218,53.92057,-1.13726,-.11808,53.35482,-1.15722,0.0,53.35888,-1.15748,-.18495,53.42608,-1.2873,-.13999,53.43832,-2.31993,-.7642,53.3332,-1.5129,-.23005,53.88796,-1.15276,-.27775,53.72975,-.70455,-.29788,53.38921,-.82962,-.11111,53.34567,-1.28367,-.10614,53.41522,-1.2825,-.47589,53.68264,-.96672,-.49662,53.67981,-.90062,-.46877,53.97149,-1.20037,-.81639,54.02348,-1.12616,-.47282,53.97559,-1.20527,-.56444,53.5272,-1.30286,-.76321,53.33291,-1.50818,-.18736,53.35549,-1.29039,-.07505,53.20563,-.70068,-.30692,53.91808,-1.14514,0.0,53.69365,-.8036,-.24402,53.67271,-.73478,-.66857,53.60088,-1.52259,-.05966,53.51239,-.67913,-.30534,53.84864,-1.20658,0.0,53.73691,-1.23102,0.0,53.65028,-1.24416,.13389,53.42428,-.72862,.54079,53.92616,-1.11681,.85628,53.43129,-1.38772,.81281,53.4037,-1.42386,.67201,53.40223,-1.57372,.23445,53.44726,-1.77825,0.0,53.71849,-.88501,.11808,53.35482,-1.15722,.27889,53.44479,-1.2817,.24402,53.67271,-.73478};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc5disc_Geo_8_64_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,0,2,12,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,23,14,24,-1,5,25,13,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,46,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,57,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,64,69,70,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,75,-1,82,83,84,-1,85,83,86,-1,87,88,89,-1,90,91,76,-1,92,93,94,-1,95,61,60,-1,96,97,8,-1,53,65,6,-1,98,99,100,-1,101,63,52,-1,102,89,103,-1,102,32,34,-1,102,103,32,-1,104,105,101,-1,53,52,63,-1,106,6,97,-1,107,108,96,-1,22,93,92,-1,19,109,110,-1,110,12,76,-1,89,102,86,-1,111,82,84,-1,112,113,114,-1,115,66,116,-1,7,117,118,-1,119,120,121,-1,122,71,123,-1,123,70,69,-1,124,125,126,-1,101,105,127,-1,128,11,10,-1,129,57,56,-1,56,41,129,-1,49,96,108,-1,130,95,131,-1,132,42,41,-1,48,133,44,-1,46,45,134,-1,50,135,51,-1,57,59,104,-1,136,137,138,-1,104,52,55,-1,139,39,38,-1,4,25,5,-1,140,36,35,-1,25,24,14,-1,44,28,27,-1,18,30,20,-1,141,142,143,-1,144,100,99,-1,20,19,18,-1,145,13,15,-1,146,147,29,-1,148,10,9,-1,149,79,78,-1,103,145,32,-1,8,97,6,-1,30,18,31,-1,91,90,150,-1,78,151,149,-1,15,32,145,-1,16,33,15,-1,99,33,144,-1,152,31,18,-1,27,153,44,-1,14,13,25,-1,140,154,36,-1,4,37,25,-1,139,155,39,-1,136,138,156,-1,104,55,57,-1,46,134,47,-1,48,44,46,-1,132,157,42,-1,131,50,130,-1,56,158,41,-1,128,107,11,-1,101,127,69,-1,8,11,107,-1,123,127,126,-1,123,69,127,-1,121,159,119,-1,160,161,9,-1,7,121,117,-1,74,12,2,-1,112,80,113,-1,83,82,112,-1,111,81,82,-1,111,98,90,-1,102,85,86,-1,91,110,76,-1,162,149,151,-1,151,163,162,-1,17,19,110,-1,22,164,93,-1,107,96,8,-1,165,17,110,-1,100,150,90,-1,63,65,53,-1,104,59,105,-1,59,166,105,-1,34,167,102,-1,89,168,103,-1,52,104,101,-1,100,90,98,-1,106,53,6,-1,150,165,91,-1,60,169,95,-1,19,163,109,-1,92,94,170,-1,76,111,90,-1,171,87,89,-1,171,89,86,-1,83,85,84,-1,112,172,83,-1,173,80,75,-1,76,12,74,-1,174,175,87,-1,73,119,71,-1,70,123,71,-1,70,159,64,-1,66,115,67,-1,8,7,118,-1,61,148,62,-1,176,177,135,-1,58,57,129,-1,108,130,49,-1,54,55,52,-1,178,179,158,-1,50,49,130,-1,47,169,48,-1,44,153,45,-1,41,43,129,-1,38,40,43,-1,35,37,4,-1,99,34,33,-1,32,15,33,-1,28,180,26,-1,13,145,5,-1,24,181,23,-1,20,30,21,-1,143,16,14,-1,12,110,0,-1,149,170,79,-1,11,160,9,-1,110,91,165,-1,182,49,51,-1,168,3,5,-1,58,166,59,-1,183,35,184,-1,140,35,183,-1,185,58,40,-1,185,166,58,-1,170,186,79,-1,170,94,186,-1,62,187,188,-1,189,187,62,-1,21,29,190,-1,21,30,29,-1,23,191,147,-1,23,181,191,-1,33,142,144,-1,16,142,33,-1,143,142,16,-1,21,164,22,-1,21,180,164,-1,190,192,26,-1,190,191,192,-1,193,194,195,-1,193,196,194,-1,24,37,195,-1,24,25,37,-1,139,140,155,-1,154,140,139,-1,138,157,156,-1,138,42,157,-1,134,197,198,-1,134,45,197,-1,106,182,199,-1,97,182,106,-1,47,200,131,-1,47,134,200,-1,136,201,202,-1,136,197,201,-1,177,178,203,-1,179,178,177,-1,158,132,41,-1,158,179,132,-1,204,205,188,-1,206,205,204,-1,63,69,64,-1,63,101,69,-1,207,116,208,-1,115,116,207,-1,123,125,122,-1,123,126,125,-1,122,72,71,-1,66,72,122,-1,209,210,211,-1,209,212,210,-1,211,213,214,-1,211,215,213,-1,161,189,9,-1,161,213,189,-1,64,121,7,-1,64,159,121,-1,216,210,217,-1,216,218,210,-1,217,173,219,-1,173,217,220,-1,221,114,113,-1,114,221,222,-1,87,172,174,-1,172,87,171,-1,109,151,1,-1,151,109,163,-1,84,102,167,-1,102,84,85,-1,223,204,224,-1};
			return value;
		}
		private int[] getc5disc_Geo_8_64_coordIndex_2()
		{
			int[] value = {223,206,204,-1,92,20,22,-1,20,92,162,-1,206,48,205,-1,133,48,206,-1,167,99,98,-1,34,99,167,-1,3,89,88,-1,89,3,168,-1,183,207,225,-1,183,226,207,-1,124,227,208,-1,185,227,124,-1,130,61,95,-1,130,128,61,-1,228,206,223,-1,228,133,206,-1,93,224,94,-1,93,223,224,-1,84,98,111,-1,167,98,84,-1,170,162,92,-1,170,149,162,-1,68,175,174,-1,175,68,67,-1,171,83,172,-1,86,83,171,-1,114,172,112,-1,114,174,172,-1,210,220,217,-1,220,210,212,-1,229,217,219,-1,216,217,229,-1,186,77,79,-1,77,186,229,-1,78,74,2,-1,74,78,77,-1,215,189,213,-1,189,215,187,-1,161,214,213,-1,214,161,117,-1,73,212,209,-1,212,73,221,-1,159,71,119,-1,159,70,71,-1,226,115,207,-1,67,115,226,-1,6,64,7,-1,6,65,64,-1,135,131,200,-1,131,135,50,-1,230,132,176,-1,157,132,230,-1,178,55,54,-1,178,56,55,-1,178,158,56,-1,40,129,43,-1,58,129,40,-1,198,200,134,-1,200,198,230,-1,137,154,139,-1,137,231,154,-1,181,195,194,-1,195,181,24,-1,232,26,192,-1,27,26,232,-1,152,150,233,-1,152,165,150,-1,190,180,21,-1,26,180,190,-1,191,194,192,-1,181,194,191,-1,100,233,150,-1,100,144,233,-1,189,148,9,-1,189,62,148,-1,234,94,224,-1,94,234,186,-1,118,11,8,-1,118,160,11,-1,227,40,39,-1,227,185,40,-1,184,4,3,-1,184,35,4,-1,145,168,5,-1,103,168,145,-1,155,183,225,-1,183,155,140,-1,235,188,187,-1,235,204,188,-1,151,2,1,-1,2,151,78,-1,236,183,184,-1,236,226,183,-1,23,143,14,-1,141,143,23,-1,142,146,237,-1,142,141,146,-1,201,196,202,-1,196,201,232,-1,180,228,164,-1,180,28,228,-1,17,152,18,-1,17,165,152,-1,147,190,29,-1,190,147,191,-1,231,196,193,-1,231,202,196,-1,36,195,37,-1,195,36,193,-1,38,42,138,-1,43,42,38,-1,45,201,197,-1,45,153,201,-1,51,199,182,-1,199,51,203,-1,169,131,95,-1,131,169,47,-1,203,135,177,-1,135,203,51,-1,198,136,156,-1,136,198,197,-1,54,203,178,-1,54,199,203,-1,179,176,132,-1,176,179,177,-1,188,60,62,-1,205,60,188,-1,208,125,124,-1,116,125,208,-1,122,116,66,-1,122,125,116,-1,72,221,73,-1,72,222,221,-1,120,211,214,-1,120,209,211,-1,210,215,211,-1,218,215,210,-1,75,111,76,-1,81,111,75,-1,234,218,216,-1,234,235,218,-1,219,75,74,-1,75,219,173,-1,80,220,113,-1,220,80,173,-1,222,174,114,-1,222,68,174,-1,87,236,88,-1,87,175,236,-1,19,162,163,-1,19,20,162,-1,205,169,60,-1,48,169,205,-1,225,208,227,-1,225,207,208,-1,88,184,3,-1,88,236,184,-1,166,124,105,-1,166,185,124,-1,128,108,107,-1,130,108,128,-1,164,223,93,-1,164,228,223,-1,109,0,110,-1,109,1,0,-1,175,226,236,-1,175,67,226,-1,112,81,80,-1,81,112,82,-1,212,113,220,-1,212,221,113,-1,219,77,229,-1,219,74,77,-1,186,216,229,-1,186,234,216,-1,117,160,118,-1,117,161,160,-1,218,187,215,-1,187,218,235,-1,121,214,117,-1,121,120,214,-1,209,119,73,-1,209,120,119,-1,66,222,72,-1,222,66,68,-1,128,148,61,-1,128,10,148,-1,124,127,105,-1,124,126,127,-1,53,199,54,-1,53,106,199,-1,156,230,198,-1,156,157,230,-1,182,96,49,-1,96,182,97,-1,200,176,135,-1,200,230,176,-1,136,231,137,-1,202,231,136,-1,138,139,38,-1,138,137,139,-1,154,193,36,-1,231,193,154,-1,201,27,232,-1,153,27,201,-1,233,31,152,-1,233,237,31,-1,133,28,44,-1,133,228,28,-1,29,237,146,-1,29,31,237,-1,196,192,194,-1,196,232,192,-1,237,144,142,-1,144,237,233,-1,147,141,23,-1,147,146,141,-1,224,235,234,-1,224,204,235,-1,39,225,227,-1,225,39,155,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc5disc_Coord_9_64_point_1()
		{
			double[] value = {.36761,53.39464,-1.20697,.36172,53.39094,-1.20919,.35549,53.3918,-1.20656,.21867,53.11637,-.77273,.21548,53.10974,-.78514,.27812,53.13169,-.81766,-.38467,53.3772,-1.005,-.3756,53.39185,-1.03517,-.38196,53.39062,-1.13309,-.29275,53.36783,-1.26494,-.29441,53.36302,-1.26538,-.35363,53.38834,-1.21808,.36612,53.39071,-1.15259,.33064,53.16346,-.87776,.3128,53.19157,-.91986,.34045,53.17208,-.88105,.32465,53.19867,-.91701,.38522,53.38868,-1.10599,.33954,53.34176,-1.12005,.3377,53.36867,-1.16526,.28214,53.34041,-1.22714,.21705,53.25802,-1.14806,.2107,53.32167,-1.22544,.29111,53.21212,-.95727,.25736,53.15516,-.87728,.26815,53.13768,-.83376,.15178,53.20794,-1.06964,.08072,53.19635,-1.07228,.07405,53.2385,-1.1493,.2935,53.26666,-1.06172,.27922,53.29603,-1.13256,.32668,53.30337,-1.04082,.34703,53.17149,-.8433,.35785,53.24323,-.89434,.37086,53.24444,-.86221,.11547,53.08989,-.75634,.10699,53.10384,-.80274,.21318,53.12383,-.80371,-.21318,53.12383,-.80371,-.21548,53.10974,-.78514,-.27812,53.13169,-.81766,-.3128,53.19157,-.91986,-.25736,53.15516,-.87728,-.26815,53.13768,-.83376,0.0,53.22053,-1.14741,-.08072,53.19635,-1.07228,-.07405,53.2385,-1.1493,-.14389,53.24003,-1.15015,-.06749,53.27947,-1.22579,-.33954,53.34176,-1.12005,-.27922,53.29603,-1.13256,-.32668,53.30337,-1.04082,-.38299,53.29899,-.88368,-.38336,53.32798,-.9204,-.36218,53.29839,-.92219,-.35785,53.24323,-.89434,-.32465,53.19867,-.91701,-.34045,53.17208,-.88105,-.33827,53.15679,-.85154,-.34781,53.17045,-.8437,-.15234,53.30584,-1.24117,-.23442,53.33602,-1.24066,-.18852,53.34215,-1.27608,-.37472,53.31915,-.89757,-.34918,53.34687,-.94536,-.37053,53.34225,-.93199,-.08824,53.23308,-.80471,0.0,53.20377,-.70399,0.0,53.2291,-.81173,-.33728,53.28186,-.88121,-.26309,53.27414,-.92063,-.19005,53.26943,-.89975,-.09677,53.28678,-.88255,-.10451,53.32063,-.9648,.27363,53.37313,-1.15213,.26688,53.34937,-1.05501,.3756,53.39185,-1.03517,.27646,53.36587,-1.22068,.3387,53.38589,-1.21863,.29275,53.36783,-1.26494,.19044,53.32058,-.9737,.25761,53.30357,-.96931,.26309,53.27414,-.92063,.25313,53.24198,-.88285,.33728,53.28186,-.88121,.29379,53.23894,-.82376,.2423,53.20534,-.78129,.15636,53.19768,-.73404,.17106,53.18136,-.73829,.24852,53.19445,-.77856,.36727,53.35211,-.93697,.38185,53.39195,-1.03429,.23156,53.33429,-1.23882,.15391,53.30799,-1.24337,.18852,53.34216,-1.27607,-.2107,53.32167,-1.22544,-.37149,53.37457,-1.11021,-.38717,53.3714,-1.02809,.36307,53.32265,-.91144,.37637,53.27698,-.88358};
			return value;
		}
		private double[] getc5disc_Coord_9_64_point_2()
		{
			double[] value = {.38658,53.33248,-.92013,-.35024,53.27667,-.87065,.30145,53.23214,-.81972,.33639,53.16389,-.83793,-.37242,53.24481,-.86127,-.30161,53.23182,-.8198,-.38674,53.35245,-.97287,-.35011,53.38361,-1.20331,-.3377,53.36867,-1.16526,.35664,53.38458,-1.19199,.38434,53.39754,-1.13647,.34918,53.34687,-.94536,.19005,53.26943,-.89975,.10451,53.32063,-.9648,.09677,53.28678,-.88255,-.07381,53.20011,-.70671,-.15636,53.19768,-.73404,-.27363,53.37313,-1.15213,-.36459,53.39042,-1.15258,-.19044,53.32058,-.9737,-.1992,53.34425,-1.06448,-.26688,53.34937,-1.05501,-.17517,53.23483,-.84533,-.25313,53.24198,-.88285,-.2469,53.19752,-.77711,-.23773,53.20425,-.77729,-.2423,53.20534,-.78129,-.29379,53.23894,-.82376,-.28909,53.35053,-1.24127,-.33064,53.16346,-.87776,-.28214,53.34041,-1.22714,-.21705,53.25802,-1.14806,-.29111,53.21212,-.95727,0.0,53.27448,-1.22045,-.15178,53.20794,-1.06964,-.2935,53.26666,-1.06172,-.08594,53.16508,-.94824,-.09492,53.13594,-.87845,-.18906,53.14679,-.87666,-.10699,53.10384,-.80274,0.0,53.07409,-.76564,.30215,53.22169,-.95506,.32718,53.25233,-.94051,.31974,53.20493,-.9265,.36218,53.29839,-.92219,.33827,53.15679,-.85154,.29862,53.24593,-1.00619,.28831,53.23726,-1.00857,-.28129,53.36033,-1.26694,.29459,53.3631,-1.26523,.39546,53.36417,-.97208,.34574,53.38414,-1.22108,.37127,53.35276,-1.02723,0.0,53.19506,-1.06837,0.0,53.09517,-.8043,-.11547,53.08989,-.75634,-.16789,53.16526,-.95161,-.23666,53.17961,-.95253,-.31974,53.20493,-.9265,-.25761,53.30357,-.96931,-.34639,53.38837,-1.21837,-.27646,53.36587,-1.22068,.29028,53.35226,-1.2437,.34572,53.37944,-1.19574,.14317,53.29326,-1.22826,.39317,53.37843,-1.02842,-.33639,53.16389,-.83793,.35081,53.276,-.87037,.2802,53.13928,-.80693,-.14317,53.29326,-1.22826,.2814,53.36032,-1.26694,.23773,53.20425,-.77729,.17517,53.23483,-.84533,.1992,53.34425,-1.06448,.08824,53.23308,-.80471,.07381,53.20011,-.70671,-.28831,53.23726,-1.00857,-.29862,53.24593,-1.00619,-.32718,53.25233,-.94051,-.30215,53.22169,-.95506,.14389,53.24003,-1.15015,.23666,53.17961,-.95253,-.37127,53.35276,-1.02723,0.0,53.08494,-.74888,.11599,53.09742,-.7418,-.28021,53.13928,-.80692,.18731,53.35035,-1.27367,-.1124,53.34282,-1.26731,-.11209,53.3319,-1.27033,-.18731,53.35035,-1.27367,.22179,53.22626,-1.07451,.22968,53.19991,-1.0065,.15983,53.1866,-1.01063,.09492,53.13594,-.87845,.16789,53.16526,-.95161,.18906,53.14679,-.87666,.08594,53.16508,-.94824,-.08364,53.17879,-1.00675,-.15983,53.1866,-1.01063,-.36673,53.32557,-.97471};
			return value;
		}
		private double[] getc5disc_Coord_9_64_point_3()
		{
			double[] value = {-.22179,53.22626,-1.07451,0.0,53.17494,-1.00723,0.0,53.15747,-.94927,-.3327,53.28351,-.98669,0.0,53.33403,-1.28382,-.07681,53.29327,-1.23817,0.0,53.28577,-1.23248,-.08243,53.18356,-.70848,-.17044,53.18231,-.73782,-.11465,53.34249,-1.06903,0.0,53.35724,-1.15751,-.11808,53.35318,-1.15724,0.0,53.35242,-1.07689,-.20144,53.3582,-1.21928,-.20492,53.35887,-1.15261,-.11496,53.35551,-1.21971,.11496,53.35551,-1.21971,.11808,53.35318,-1.15724,0.0,53.35182,-1.23148,.20492,53.35887,-1.15261,.11465,53.34249,-1.06903,0.0,53.33002,-.97959,0.0,53.28446,-.87879,.07818,53.2953,-1.23999,.11209,53.3319,-1.27033,-.11599,53.09742,-.7418,0.0,53.18185,-.70818,-.21868,53.11637,-.77273,.06749,53.27947,-1.22579,.20144,53.3582,-1.21928,-.22968,53.19991,-1.0065,0.0,53.12977,-.87191,.08364,53.17879,-1.00675,.36673,53.32557,-.97471,.1124,53.34282,-1.26731,0.0,53.34358,-1.28075,.08385,53.17961,-.70998,.3327,53.28351,-.98669};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc6_Geo_8_69_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,11,30,31,-1,11,32,30,-1,33,34,35,-1,36,37,38,-1,37,36,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,57,59,-1,14,60,61,-1,62,63,64,-1,65,66,67,-1,68,66,65,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,83,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,36,-1,103,104,61,-1,105,106,107,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,108,115,109,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,96,-1,127,128,129,-1,130,14,13,-1,106,131,132,-1,133,134,135,-1,54,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,150,148,27,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,109,169,110,-1,170,142,171,-1,143,142,170,-1,172,173,9,-1,174,175,63,-1,176,177,178,-1,179,180,181,-1,182,183,184,-1,15,185,186,-1,187,188,189,-1,190,191,192,-1,193,183,182,-1,194,195,196,-1,197,191,190,-1,198,199,200,-1,46,201,62,-1,180,202,203,-1,180,204,205,-1,206,207,208,-1,209,210,160,-1,26,25,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,158,-1,226,227,228,-1,229,102,55,-1,39,230,231,-1,232,233,52,-1,234,235,236,-1,237,238,239,-1,240,241,242,-1,243,244,245,-1,246,247,248,-1,249,250,251,-1,252,253,254,-1,255,256,129,-1,257,128,12,-1,258,259,260,-1,261,262,263,-1,92,264,265,-1,81,83,86,-1,266,267,268,-1,198,200,11,-1,269,270,271,-1,272,270,269,-1,273,274,275,-1,276,277,38,-1,278,279,280,-1,281,282,283,-1,284,122,285,-1,286,287,288,-1,122,78,285,-1,289,124,290,-1,291,292,293,-1,294,127,295,-1,296,130,297,-1,298,299,300,-1,301,302,284,-1,303,304,305,-1,306,307,308,-1,309,310,311,-1,312,313,314,-1,315,217,216,-1,218,316,26,-1,317,318,216,-1,319,220,320,-1,320,321,322,-1,223,323,324,-1,216,8,317,-1,325,326,152,-1,327,236,328,-1,329,330,331,-1,332,333,334,-1,335,336,332,-1,337,338,339,-1,338,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,42,355,-1,356,357,358,-1,257,359,360,-1,58,361,362,-1,363,364,365,-1,366,361,364,-1,367,368,369,-1,370,371,372,-1,227,226,373,-1,374,375,68,-1,95,376,377,-1,378,379,76,-1,197,380,381,-1,382,383,94,-1,384,385,386,-1,387,388,389,-1,390,391,387,-1,345,392,393,-1,45,394,395,-1,243,396,397,-1,398,384,246,-1,399,400,401,-1,402,403,404,-1,405,406,64,-1,19,240,407,-1,408,409,410,-1,47,411,48,-1,234,20,407,-1,412,413,235,-1,414,415,416,-1,105,417,418,-1,419,240,245,-1,420,421,422,-1,120,423,144,-1,424,425,426,-1,427,7,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,454,456,455,-1,457,458,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,460,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,484,489,490,-1,491,492,493,-1,494,492,491,-1,491,495,496,-1,497,498,499,-1,500,501,502,-1,503,504,505,-1,506,507,508,-1,509,510,511,-1,512,503,513,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,458,523,524,-1,525,526,527,-1,528,529,530,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,533,544,-1,545,546,1,-1,547,548,549,-1,550,551,552,-1,553,554,555,-1,556,557,558,-1,559,560,561,-1,562,563,564,-1,565,566,567,-1,566,568,569,-1,570,566,571,-1,572,6,559,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,582,584,588,-1,589,590,591,-1,592,593,594,-1,595,596,588,-1,597,598,599,-1,600,601,602,-1,603,604,605,-1,606,607,3,-1,608,609,610,-1,611,612,613,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_2()
		{
			int[] value = {614,615,616,-1,617,618,619,-1,620,621,622,-1,602,601,619,-1,623,624,625,-1,626,627,280,-1,628,629,630,-1,631,632,275,-1,633,513,503,-1,634,635,636,-1,637,638,639,-1,634,640,641,-1,642,643,644,-1,645,646,647,-1,648,649,650,-1,651,652,653,-1,518,654,655,-1,656,657,519,-1,658,659,660,-1,661,662,663,-1,664,461,665,-1,666,667,668,-1,669,450,670,-1,671,430,429,-1,672,673,432,-1,624,628,674,-1,675,676,677,-1,678,679,680,-1,516,498,500,-1,681,682,683,-1,684,685,686,-1,562,687,685,-1,571,688,575,-1,565,689,690,-1,691,692,559,-1,557,693,694,-1,573,695,696,-1,568,697,698,-1,699,436,700,-1,446,701,702,-1,703,701,445,-1,704,705,706,-1,707,435,708,-1,635,709,710,-1,711,706,712,-1,713,714,715,-1,716,717,718,-1,640,719,720,-1,448,467,721,-1,713,722,723,-1,724,722,702,-1,725,726,727,-1,728,729,730,-1,662,441,725,-1,731,732,733,-1,734,704,731,-1,735,443,442,-1,736,737,738,-1,595,739,740,-1,741,742,743,-1,744,562,685,-1,745,746,747,-1,557,748,749,-1,750,751,752,-1,753,754,752,-1,755,593,756,-1,732,757,758,-1,759,760,761,-1,762,763,675,-1,469,471,764,-1,765,766,767,-1,768,608,610,-1,769,770,771,-1,553,772,773,-1,553,774,772,-1,539,775,536,-1,776,777,778,-1,779,780,781,-1,782,783,679,-1,784,785,786,-1,645,487,787,-1,788,789,790,-1,643,791,792,-1,426,793,644,-1,495,794,496,-1,795,791,796,-1,539,536,535,-1,502,797,798,-1,799,800,801,-1,785,802,786,-1,803,728,730,-1,804,672,805,-1,806,5,807,-1,808,809,810,-1,811,810,678,-1,812,813,676,-1,669,805,814,-1,815,816,504,-1,817,818,440,-1,819,664,820,-1,821,822,527,-1,782,628,630,-1,630,783,782,-1,823,824,825,-1,28,826,751,-1,573,579,827,-1,828,2,553,-1,804,438,829,-1,448,830,449,-1,704,734,831,-1,584,590,595,-1,497,501,500,-1,832,833,834,-1,832,777,776,-1,835,836,837,-1,838,826,28,-1,839,840,841,-1,808,674,809,-1,453,842,454,-1,482,843,819,-1,844,456,454,-1,845,846,847,-1,543,818,848,-1,815,504,512,-1,849,850,801,-1,851,852,786,-1,853,763,637,-1,854,714,648,-1,855,624,674,-1,856,587,857,-1,857,587,858,-1,669,438,804,-1,859,860,786,-1,861,862,863,-1,864,797,501,-1,849,800,865,-1,866,867,868,-1,869,870,871,-1,872,796,873,-1,495,874,861,-1,494,875,876,-1,642,796,791,-1,873,796,877,-1,644,643,426,-1,463,646,645,-1,784,860,770,-1,786,802,878,-1,879,789,792,-1,880,596,740,-1,881,882,835,-1,551,550,539,-1,883,884,885,-1,536,531,886,-1,549,2,1,-1,587,586,858,-1,769,615,887,-1,653,888,889,-1,608,768,4,-1,610,656,890,-1,891,892,893,-1,704,757,731,-1,894,895,896,-1,647,897,898,-1,899,900,485,-1,901,636,635,-1,902,455,456,-1,555,554,903,-1,752,754,556,-1,750,691,904,-1,556,754,748,-1,905,567,906,-1,907,742,698,-1,737,908,738,-1,607,909,910,-1,613,911,912,-1,613,612,911,-1,735,442,913,-1,894,914,915,-1,661,915,914,-1,700,704,845,-1,733,916,917,-1,436,699,803,-1,661,464,788,-1,790,789,913,-1,918,919,920,-1,921,662,725,-1,708,730,919,-1,850,500,799,-1,445,444,922,-1,854,715,714,-1,717,716,720,-1,641,923,711,-1,924,919,729,-1,925,921,874,-1,636,926,719,-1,490,927,928,-1,929,930,854,-1,854,650,929,-1,441,707,708,-1,730,435,437,-1,705,449,712,-1,931,703,896,-1,847,846,720,-1,435,707,848,-1,932,933,697,-1,690,689,428,-1,575,688,934,-1,935,742,936,-1,937,689,687,-1,685,684,744,-1,938,514,939,-1,816,476,475,-1,630,629,940,-1,941,432,942,-1,943,944,945,-1,429,946,947,-1,669,668,450,-1,451,842,453,-1,948,949,950,-1,475,764,471,-1,951,952,470,-1,953,954,955,-1,791,956,879,-1,907,933,957,-1,519,518,890,-1,869,958,870,-1,649,520,650,-1,900,899,487,-1,853,959,866,-1,960,488,901,-1,961,828,745,-1,811,503,808,-1,868,962,963,-1,964,631,274,-1,965,966,632,-1,967,823,675,-1,968,969,970,-1,971,625,627,-1,972,973,555,-1,974,956,785,-1,975,976,977,-1,908,737,978,-1,979,883,980,-1,981,982,614,-1,983,616,615,-1,611,610,609,-1,606,856,857,-1,593,903,756,-1,586,588,596,-1,984,985,986,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_3()
		{
			int[] value = {586,585,987,-1,806,856,5,-1,988,827,579,-1,583,989,591,-1,692,558,990,-1,690,7,6,-1,991,568,570,-1,906,686,905,-1,742,935,992,-1,686,906,993,-1,687,686,685,-1,560,6,8,-1,749,994,995,-1,996,673,0,-1,997,548,547,-1,829,545,0,-1,998,546,545,-1,541,533,532,-1,534,999,1000,-1,1001,1002,1003,-1,1001,1004,1002,-1,527,822,524,-1,681,472,521,-1,808,505,1005,-1,1006,1007,511,-1,955,509,1008,-1,1009,1010,509,-1,498,497,500,-1,876,875,798,-1,1011,859,852,-1,1012,495,491,-1,484,490,926,-1,487,486,1013,-1,1014,481,480,-1,1015,1016,478,-1,1017,473,472,-1,683,1018,927,-1,952,479,478,-1,913,1000,999,-1,459,1019,821,-1,1020,454,842,-1,667,1021,1022,-1,479,917,665,-1,470,705,831,-1,914,894,1023,-1,915,803,895,-1,804,805,669,-1,758,438,732,-1,1024,848,818,-1,432,805,672,-1,1025,433,1026,-1,961,947,1027,-1,814,1028,666,-1,773,756,903,-1,84,421,93,-1,7,427,1029,-1,1030,1031,239,-1,1032,1033,235,-1,46,1034,1035,-1,408,410,18,-1,1036,1037,143,-1,206,64,406,-1,1038,201,110,-1,1039,1040,205,-1,15,1041,399,-1,1042,242,1037,-1,394,243,1043,-1,1044,1045,248,-1,385,1046,386,-1,1047,91,90,-1,1048,1049,186,-1,133,1050,399,-1,1051,1052,358,-1,1053,1054,1055,-1,387,385,384,-1,385,1056,372,-1,1057,1058,1046,-1,1059,352,1060,-1,1061,381,1062,-1,383,1063,94,-1,1064,381,1065,-1,378,1066,1067,-1,379,1067,1068,-1,1069,76,379,-1,373,1070,227,-1,226,1071,67,-1,271,1072,50,-1,1056,366,1073,-1,371,370,369,-1,1074,367,1075,-1,1076,369,1077,-1,1078,1079,257,-1,357,356,1080,-1,1044,42,354,-1,354,350,1044,-1,353,348,354,-1,111,1081,108,-1,1082,117,346,-1,331,330,343,-1,111,341,340,-1,338,1083,1084,-1,339,1084,1085,-1,1086,331,334,-1,329,112,116,-1,22,1087,1088,-1,1089,1090,213,-1,1091,561,560,-1,317,8,7,-1,225,324,323,-1,1092,225,224,-1,162,1093,1094,-1,1095,324,225,-1,1029,317,7,-1,217,1096,1090,-1,1097,1098,1099,-1,1100,988,1101,-1,1102,313,312,-1,1103,1104,1105,-1,1106,1107,313,-1,299,130,296,-1,1108,295,291,-1,1109,1110,289,-1,1111,290,123,-1,1112,1113,1114,-1,1115,166,1116,-1,347,1117,80,-1,98,1118,1119,-1,283,1120,278,-1,283,282,1120,-1,1121,1122,1123,-1,274,273,1124,-1,1125,1123,137,-1,271,57,58,-1,415,1126,21,-1,1127,268,267,-1,264,94,1128,-1,356,263,1080,-1,1129,957,933,-1,1118,87,392,-1,1074,1130,1131,-1,1132,400,399,-1,1055,391,1050,-1,1133,1134,1135,-1,1136,1042,1137,-1,1043,245,240,-1,239,1138,416,-1,1139,1140,1141,-1,234,1142,1032,-1,37,1143,1144,-1,51,1145,1055,-1,356,1146,1147,-1,157,1148,224,-1,222,1149,323,-1,1094,936,162,-1,1150,218,1151,-1,1029,221,223,-1,933,1152,1153,-1,48,110,201,-1,1154,189,188,-1,1155,202,192,-1,16,401,194,-1,62,1034,46,-1,1038,176,1156,-1,1157,184,183,-1,1065,380,190,-1,197,200,191,-1,172,1158,77,-1,1159,1160,174,-1,1161,1162,194,-1,191,189,192,-1,262,1163,193,-1,1164,1039,204,-1,1165,226,1166,-1,174,62,1156,-1,172,177,176,-1,1159,174,1167,-1,393,1168,250,-1,89,91,251,-1,64,206,1035,-1,1036,1169,1132,-1,1170,1171,408,-1,251,404,405,-1,1172,1039,1164,-1,115,1082,109,-1,293,1173,1174,-1,293,1175,1176,-1,1177,1178,1179,-1,166,1180,1116,-1,1129,209,162,-1,324,1095,321,-1,1091,215,150,-1,1089,149,148,-1,423,1088,1087,-1,1181,1104,1182,-1,143,241,410,-1,32,11,200,-1,264,1128,1061,-1,265,1183,1184,-1,406,403,1155,-1,1185,1186,1187,-1,12,128,13,-1,97,126,292,-1,125,96,79,-1,1188,1189,313,-1,1084,327,23,-1,118,117,115,-1,1113,113,1190,-1,112,114,1191,-1,1192,1193,1194,-1,1106,302,301,-1,87,1168,393,-1,100,1195,1196,-1,1197,79,96,-1,90,93,92,-1,83,84,1198,-1,74,1199,1200,-1,74,69,81,-1,1068,252,375,-1,76,1201,1202,-1,74,73,1199,-1,1200,1203,383,-1,117,1082,115,-1,1204,71,70,-1,1205,1127,1206,-1,1207,1208,1209,-1,66,1210,67,-1,1202,1201,1211,-1,257,360,1078,-1,1189,1188,299,-1,60,1188,1102,-1,60,130,299,-1,1212,365,58,-1,262,261,1163,-1,1213,1214,1142,-1,267,266,1215,-1,1216,1217,1166,-1,50,49,139,-1,1218,175,10,-1,48,411,111,-1,1219,45,395,-1,1044,40,42,-1,1046,385,372,-1,1209,198,1165,-1,841,417,1220,-1,28,1221,1222,-1,837,836,1194,-1,1223,1224,1225,-1,1226,1192,107,-1,1226,1227,1098,-1,373,226,67,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_4()
		{
			int[] value = {314,1107,163,-1,171,401,400,-1,297,13,128,-1,393,169,109,-1,1228,1229,1215,-1,1,0,545,-1,853,639,638,-1,655,4,768,-1,886,735,999,-1,638,959,853,-1,1215,266,1228,-1,393,109,1082,-1,127,297,128,-1,171,400,170,-1,314,163,311,-1,22,1088,120,-1,1098,1230,1226,-1,1192,1231,107,-1,1225,1232,1223,-1,1194,1233,837,-1,1222,1234,28,-1,1220,1235,841,-1,58,59,1212,-1,1137,395,394,-1,395,1236,1219,-1,1154,188,207,-1,110,48,111,-1,411,341,111,-1,1218,63,175,-1,139,1237,50,-1,1216,1207,1217,-1,1195,100,377,-1,1215,1238,267,-1,1213,1239,1214,-1,1212,281,365,-1,60,299,1188,-1,60,1102,61,-1,1189,299,298,-1,240,19,410,-1,95,100,99,-1,1202,1211,1240,-1,1210,373,67,-1,1209,1217,1207,-1,1206,373,1205,-1,70,422,1204,-1,1200,383,382,-1,1118,72,88,-1,73,1241,1199,-1,1202,77,76,-1,375,374,1068,-1,81,88,74,-1,74,1200,69,-1,86,83,1198,-1,90,92,1242,-1,96,99,1197,-1,1196,1243,100,-1,393,392,87,-1,71,1244,69,-1,301,164,1106,-1,1192,1194,1232,-1,1191,116,112,-1,1190,1114,1113,-1,118,115,108,-1,121,120,144,-1,1110,125,79,-1,259,97,292,-1,295,129,256,-1,1185,1187,1245,-1,171,142,141,-1,1155,1154,406,-1,1184,402,265,-1,1061,1183,264,-1,200,197,32,-1,1246,1236,1247,-1,1087,1248,423,-1,148,150,1089,-1,150,27,1091,-1,212,153,149,-1,149,1089,212,-1,1249,1148,157,-1,160,1250,161,-1,1179,294,1177,-1,1176,1173,293,-1,289,1251,1109,-1,406,405,403,-1,405,404,403,-1,1036,1132,398,-1,1035,1034,64,-1,251,250,89,-1,250,1038,393,-1,1159,1167,1240,-1,249,172,176,-1,1156,1167,174,-1,1166,1217,1165,-1,204,203,1164,-1,193,1252,262,-1,191,199,189,-1,1162,195,194,-1,1160,175,174,-1,77,177,172,-1,200,199,191,-1,190,1253,1065,-1,1157,1254,184,-1,1156,201,1038,-1,194,196,16,-1,1155,203,202,-1,201,46,48,-1,1153,1255,933,-1,1150,219,218,-1,222,323,223,-1,224,158,157,-1,1256,1094,1093,-1,1146,1257,1147,-1,51,1055,1054,-1,1144,276,37,-1,138,1237,139,-1,234,1213,1142,-1,1139,238,1140,-1,239,416,1258,-1,240,242,1043,-1,1136,1137,394,-1,1172,1133,1135,-1,1050,135,1055,-1,399,390,1132,-1,1074,1259,1130,-1,1118,88,87,-1,210,1250,160,-1,257,129,128,-1,257,1079,129,-1,71,1204,1244,-1,356,1147,263,-1,264,92,94,-1,267,1238,1127,-1,30,32,1063,-1,415,414,1126,-1,58,1072,271,-1,1125,137,136,-1,274,1124,1260,-1,1123,273,1121,-1,1261,232,33,-1,102,56,55,-1,1248,1087,1182,-1,98,1119,1197,-1,1262,347,80,-1,1116,1263,1115,-1,1102,103,61,-1,1102,1264,103,-1,1112,1265,1113,-1,290,124,123,-1,1109,125,1110,-1,1108,291,1174,-1,296,300,299,-1,306,144,423,-1,1106,313,1189,-1,1103,309,1104,-1,1102,312,1264,-1,60,14,130,-1,1100,1101,24,-1,1266,310,1099,-1,217,1267,1096,-1,1029,318,317,-1,321,1250,322,-1,324,320,223,-1,1268,1256,1093,-1,1092,1095,225,-1,323,158,225,-1,222,1269,1149,-1,216,1091,560,-1,1089,150,1090,-1,213,212,1089,-1,1181,214,213,-1,22,155,1087,-1,329,116,330,-1,1086,334,333,-1,339,1085,1270,-1,338,1084,339,-1,111,340,1081,-1,331,343,342,-1,1271,1191,114,-1,117,1272,346,-1,1081,344,108,-1,353,354,351,-1,351,355,1060,-1,1246,1219,1236,-1,357,1080,1187,-1,1078,254,1079,-1,1076,1273,369,-1,1074,1075,1274,-1,371,369,368,-1,1056,1073,370,-1,50,1237,271,-1,1071,65,67,-1,373,1206,1070,-1,379,374,1069,-1,1068,374,379,-1,379,378,1067,-1,381,380,1065,-1,1062,1183,1061,-1,1059,1060,1275,-1,1057,1276,1058,-1,385,389,1056,-1,1055,135,1053,-1,358,357,1051,-1,1277,1278,1279,-1,399,1041,133,-1,1242,1047,90,-1,355,41,1280,-1,248,40,1044,-1,394,1281,243,-1,1042,1136,242,-1,399,16,15,-1,205,204,1039,-1,110,169,1038,-1,1036,143,1169,-1,1170,408,18,-1,1035,47,46,-1,1032,235,234,-1,1030,239,1258,-1,427,221,1029,-1,85,83,82,-1,93,90,84,-1,666,669,814,-1,961,1282,947,-1,1025,434,433,-1,432,941,805,-1,758,439,438,-1,670,450,732,-1,450,1283,732,-1,465,914,1023,-1,470,449,705,-1,665,461,479,-1,451,450,668,-1,1022,1284,667,-1,842,1284,1020,-1,459,821,664,-1,913,879,1000,-1,1285,952,478,-1,478,1286,1015,-1,479,461,460,-1,1014,1287,481,-1,1013,787,487,-1,484,926,485,-1,1012,1288,495,-1,786,852,859,-1,852,1289,1011,-1,875,496,798,-1,497,867,864,-1,1290,759,761,-1,1009,508,1010,-1,955,510,509,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_5()
		{
			int[] value = {511,510,1006,-1,1005,1291,808,-1,518,1292,654,-1,472,522,521,-1,524,525,527,-1,1000,975,534,-1,532,542,541,-1,998,544,546,-1,997,547,546,-1,996,0,1293,-1,555,973,1294,-1,995,1295,749,-1,560,559,6,-1,937,564,563,-1,687,905,686,-1,993,684,686,-1,1296,992,1297,-1,905,689,565,-1,567,566,569,-1,568,566,570,-1,6,572,690,-1,990,1298,692,-1,1299,989,834,-1,988,579,1101,-1,586,987,582,-1,986,589,984,-1,596,858,586,-1,606,857,603,-1,609,612,611,-1,615,769,983,-1,982,1300,614,-1,980,1301,979,-1,908,978,1302,-1,975,977,621,-1,785,784,974,-1,971,627,626,-1,679,678,810,-1,968,1303,969,-1,965,632,631,-1,274,1260,964,-1,963,866,868,-1,503,505,808,-1,961,1027,828,-1,853,866,963,-1,487,645,900,-1,649,521,520,-1,518,768,890,-1,568,741,569,-1,791,879,792,-1,953,955,1304,-1,951,470,831,-1,1285,475,471,-1,1305,949,948,-1,453,452,451,-1,669,666,668,-1,947,1282,429,-1,943,945,1306,-1,941,942,1307,-1,760,1308,512,-1,630,940,1309,-1,475,1016,816,-1,938,515,514,-1,1297,992,935,-1,684,1310,744,-1,687,564,937,-1,934,577,575,-1,932,1152,933,-1,707,443,848,-1,896,716,931,-1,705,712,706,-1,441,708,725,-1,928,718,490,-1,926,717,719,-1,921,727,874,-1,924,920,919,-1,923,706,711,-1,720,719,717,-1,854,1311,715,-1,703,445,922,-1,850,799,801,-1,918,708,919,-1,921,725,727,-1,920,862,918,-1,790,913,441,-1,661,788,790,-1,437,436,803,-1,733,917,951,-1,440,439,817,-1,700,757,704,-1,915,895,894,-1,1305,922,444,-1,735,913,999,-1,616,983,1312,-1,613,912,1313,-1,607,1314,909,-1,741,743,569,-1,1315,744,1310,-1,557,556,748,-1,750,904,751,-1,750,752,556,-1,555,903,972,-1,1316,973,986,-1,732,438,670,-1,901,926,636,-1,900,898,485,-1,647,1023,897,-1,895,847,896,-1,893,1317,891,-1,608,4,3,-1,889,771,653,-1,887,770,769,-1,772,756,773,-1,536,775,531,-1,980,883,885,-1,551,539,538,-1,835,1318,881,-1,880,600,596,-1,869,877,958,-1,879,913,789,-1,786,878,851,-1,784,770,887,-1,645,424,463,-1,643,1319,426,-1,877,1320,873,-1,642,877,796,-1,494,876,658,-1,495,861,794,-1,872,873,1321,-1,956,791,795,-1,536,886,999,-1,871,1322,869,-1,867,497,868,-1,849,801,800,-1,501,497,864,-1,794,861,863,-1,518,517,1292,-1,858,604,857,-1,856,806,587,-1,674,808,855,-1,639,853,637,-1,849,1290,850,-1,512,1308,815,-1,848,443,543,-1,543,998,818,-1,844,454,1020,-1,819,820,482,-1,458,822,1019,-1,462,1010,460,-1,800,799,634,-1,839,841,1235,-1,838,28,1234,-1,835,837,581,-1,881,832,776,-1,832,834,1323,-1,553,773,554,-1,595,588,584,-1,831,705,704,-1,829,672,804,-1,2,1293,0,-1,500,1324,799,-1,596,600,858,-1,573,696,579,-1,751,29,28,-1,489,1325,927,-1,460,1286,478,-1,630,1326,783,-1,821,1019,822,-1,664,821,820,-1,435,848,1024,-1,815,476,816,-1,676,763,812,-1,633,811,678,-1,810,811,808,-1,806,807,781,-1,730,437,803,-1,502,501,797,-1,502,798,863,-1,877,869,1322,-1,872,795,796,-1,642,644,1327,-1,426,425,793,-1,643,642,791,-1,788,464,463,-1,787,424,645,-1,784,786,860,-1,872,1321,802,-1,779,781,807,-1,777,765,778,-1,531,735,886,-1,539,550,775,-1,545,829,440,-1,771,889,769,-1,890,768,610,-1,4,655,5,-1,764,1328,469,-1,762,1329,763,-1,759,1308,760,-1,732,731,757,-1,647,898,900,-1,756,1330,755,-1,670,438,669,-1,554,773,903,-1,559,904,691,-1,693,557,749,-1,747,1295,745,-1,992,743,742,-1,741,698,742,-1,684,993,1310,-1,736,605,737,-1,983,1313,912,-1,441,913,442,-1,731,733,734,-1,788,1319,789,-1,662,790,441,-1,729,919,730,-1,931,724,701,-1,702,701,724,-1,713,1331,722,-1,448,447,467,-1,640,720,846,-1,718,931,716,-1,715,1331,713,-1,711,712,930,-1,1332,635,710,-1,435,730,708,-1,704,706,923,-1,703,931,701,-1,446,445,701,-1,845,699,700,-1,698,741,568,-1,557,694,1333,-1,1334,935,936,-1,690,571,565,-1,571,575,570,-1,428,689,937,-1,562,564,687,-1,683,1335,681,-1,500,850,516,-1,678,680,1336,-1,1326,1337,1338,-1,677,967,675,-1,624,623,628,-1,673,433,432,-1,671,429,943,-1,805,941,1339,-1,666,1340,667,-1,668,842,451,-1,665,459,664,-1,950,949,1341,-1,661,790,662,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_6()
		{
			int[] value = {956,795,785,-1,494,658,660,-1,656,519,890,-1,518,655,768,-1,1011,651,653,-1,648,650,854,-1,647,900,645,-1,800,634,641,-1,637,1342,638,-1,634,924,635,-1,503,811,633,-1,763,676,675,-1,631,275,274,-1,628,623,629,-1,626,280,279,-1,623,625,971,-1,603,1343,606,-1,602,619,618,-1,622,1344,620,-1,617,619,977,-1,616,981,614,-1,613,888,611,-1,608,910,609,-1,3,856,606,-1,603,857,604,-1,600,880,601,-1,595,740,596,-1,593,1345,594,-1,591,984,589,-1,588,586,582,-1,1346,559,692,-1,575,577,573,-1,559,1346,572,-1,566,565,571,-1,567,905,565,-1,689,905,687,-1,904,559,561,-1,556,558,750,-1,557,1333,558,-1,1316,1333,694,-1,555,746,553,-1,552,1347,550,-1,549,1,547,-1,546,547,1,-1,544,998,543,-1,542,1347,540,-1,536,999,534,-1,533,543,531,-1,528,530,1348,-1,458,524,822,-1,902,456,844,-1,522,891,520,-1,519,659,517,-1,761,514,516,-1,512,513,760,-1,1009,509,511,-1,508,1009,506,-1,503,512,504,-1,502,1324,500,-1,499,868,497,-1,875,491,496,-1,494,491,875,-1,1012,491,493,-1,489,927,490,-1,483,485,898,-1,480,482,526,-1,475,477,764,-1,522,472,474,-1,1349,1017,1350,-1,469,447,470,-1,465,646,463,-1,527,820,821,-1,458,1019,459,-1,452,1283,450,-1,447,449,470,-1,444,446,1351,-1,441,443,707,-1,699,895,803,-1,440,829,438,-1,435,1024,436,-1,434,942,432,-1,431,946,429,-1,7,690,428,-1,793,1327,644,-1,463,424,426,-1,420,93,421,-1,419,245,1352,-1,105,1220,417,-1,416,1138,414,-1,235,1033,412,-1,407,1213,234,-1,409,143,410,-1,404,1047,402,-1,401,16,399,-1,384,386,246,-1,1136,1043,242,-1,243,1281,396,-1,45,1281,394,-1,393,1082,345,-1,387,384,390,-1,1353,1065,1254,-1,1279,358,1052,-1,387,1145,388,-1,382,94,420,-1,381,1061,197,-1,76,1354,378,-1,100,95,377,-1,376,1355,377,-1,68,1069,374,-1,373,1210,1205,-1,1216,1356,140,-1,372,1056,370,-1,367,369,1273,-1,366,364,1073,-1,1357,363,365,-1,58,362,1072,-1,358,1146,356,-1,355,351,354,-1,351,1060,352,-1,350,354,348,-1,345,1082,346,-1,342,344,1081,-1,341,1083,338,-1,327,1084,1083,-1,339,1270,337,-1,335,332,1358,-1,332,334,1358,-1,331,1086,329,-1,328,1359,327,-1,1087,1360,1182,-1,325,152,156,-1,216,560,8,-1,159,1149,1269,-1,320,324,321,-1,322,1250,210,-1,320,322,319,-1,318,315,216,-1,218,26,1151,-1,1361,1362,1151,-1,24,1233,1363,-1,312,314,1266,-1,1102,1188,313,-1,313,1107,314,-1,309,1103,310,-1,308,1364,306,-1,301,284,1365,-1,300,167,298,-1,296,297,1179,-1,294,295,1108,-1,1174,291,293,-1,289,1110,124,-1,78,80,285,-1,286,1117,287,-1,285,1365,284,-1,300,296,1366,-1,281,277,282,-1,278,1120,279,-1,38,37,276,-1,275,1121,273,-1,54,232,52,-1,272,1367,270,-1,270,57,271,-1,11,1160,198,-1,268,1228,266,-1,1242,92,265,-1,263,1147,261,-1,258,376,259,-1,12,359,257,-1,129,1079,255,-1,252,1068,253,-1,1118,98,72,-1,251,173,249,-1,1134,1368,1135,-1,246,386,247,-1,1043,1136,394,-1,245,1043,243,-1,407,1239,1213,-1,239,1031,237,-1,236,20,234,-1,232,1261,233,-1,55,1369,229,-1,226,228,1166,-1,220,319,218,-1,1370,936,1094,-1,214,151,212,-1,209,1255,210,-1,208,1035,206,-1,205,181,180,-1,203,204,180,-1,201,1156,62,-1,198,187,199,-1,380,197,190,-1,30,9,31,-1,195,1371,196,-1,193,1163,183,-1,192,202,190,-1,189,199,187,-1,1041,15,186,-1,182,184,1372,-1,179,181,1372,-1,202,180,179,-1,63,62,174,-1,172,249,173,-1,89,1168,1198,-1,170,1169,143,-1,1038,169,393,-1,1109,1176,1175,-1,168,1180,166,-1,224,1148,1092,-1,209,160,162,-1,1093,162,161,-1,155,1126,156,-1,153,212,151,-1,216,215,1091,-1,1088,423,120,-1,241,240,410,-1,144,306,145,-1,265,264,1183,-1,143,409,141,-1,140,1356,138,-1,137,232,54,-1,133,135,1050,-1,297,130,13,-1,129,295,127,-1,126,97,96,-1,124,78,122,-1,1083,1170,18,-1,119,22,120,-1,116,1191,117,-1,113,1113,114,-1,107,1231,105,-1,103,1373,104,-1,73,1243,1241,-1,98,1197,99,-1,95,99,96,-1,93,420,94,-1,89,250,1168,-1,88,81,86,-1,85,421,84,-1,76,1069,1201,-1,79,1262,80,-1,75,1354,76,-1,72,74,88,-1,1191,1272,117,-1,65,1211,68,-1,1165,1217,1209,-1,98,100,1243,-1,1034,62,64,-1,19,407,20,-1,14,61,104,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_7()
		{
			int[] value = {57,56,59,-1,57,270,55,-1,53,52,1374,-1,240,419,407,-1,51,1054,49,-1,1171,1170,411,-1,1219,43,45,-1,41,355,42,-1,101,36,38,-1,385,387,389,-1,1064,1065,1375,-1,27,1221,28,-1,26,1100,24,-1,1106,1189,302,-1,226,1165,1071,-1,23,327,1359,-1,18,410,19,-1,1085,1084,23,-1,11,31,9,-1,18,327,1083,-1,960,1332,710,-1,5,856,3,-1,1363,25,24,-1,1363,1376,25,-1,1231,1232,1225,-1,1192,1232,1231,-1,836,1232,1194,-1,1232,836,1223,-1,1235,1225,1224,-1,1220,1225,1235,-1,33,137,1377,-1,33,232,137,-1,1275,1130,1059,-1,1275,1276,1130,-1,1378,1379,1380,-1,1378,1381,1379,-1,139,1382,140,-1,1382,139,1245,-1,1383,1277,1384,-1,1385,1277,1383,-1,1214,1228,268,-1,1228,1214,1239,-1,278,1386,1387,-1,278,280,1386,-1,1388,1367,1389,-1,1388,1369,1367,-1,1390,1125,1391,-1,1390,1124,1125,-1,14,359,12,-1,1392,359,14,-1,1033,360,412,-1,360,1033,1078,-1,1167,1202,1240,-1,178,1202,1167,-1,1071,198,1160,-1,1165,198,1071,-1,1393,1199,1241,-1,1393,1394,1199,-1,1395,1394,75,-1,1395,1203,1394,-1,1226,1373,103,-1,1226,107,1373,-1,298,302,1189,-1,298,1115,302,-1,414,1139,325,-1,414,1138,1139,-1,1185,1396,1186,-1,1396,1185,1053,-1,229,1397,230,-1,1398,1397,229,-1,1399,1400,1401,-1,1399,1402,1400,-1,1184,403,402,-1,403,1184,1155,-1,197,1128,32,-1,1128,197,1061,-1,1181,1360,214,-1,1181,1182,1360,-1,1116,1403,1111,-1,1180,1403,1116,-1,1177,1404,1178,-1,1404,1177,1405,-1,1173,1406,1407,-1,1173,1176,1406,-1,1174,1407,1108,-1,1173,1407,1174,-1,1408,288,287,-1,288,1408,1409,-1,1049,1040,1135,-1,1049,1048,1040,-1,1169,400,1132,-1,1169,170,400,-1,249,1038,250,-1,249,176,1038,-1,405,173,251,-1,405,1218,173,-1,188,1162,1161,-1,188,187,1162,-1,193,17,1252,-1,17,193,1410,-1,1202,177,77,-1,1202,178,177,-1,1253,1254,1065,-1,1254,1253,184,-1,1411,195,1208,-1,1411,1371,195,-1,194,171,1161,-1,401,171,194,-1,192,1154,1155,-1,1154,192,189,-1,1382,1208,1207,-1,1208,1382,1411,-1,1206,1412,1070,-1,1206,1413,1412,-1,1414,1415,1416,-1,1414,418,1415,-1,238,131,1140,-1,237,131,238,-1,244,1352,245,-1,1417,1352,244,-1,1418,1417,1419,-1,1417,1418,1420,-1,1421,1137,1042,-1,1421,1045,1137,-1,391,399,1050,-1,391,390,399,-1,1158,75,77,-1,1158,1395,75,-1,1255,1129,933,-1,1255,209,1129,-1,1127,1214,268,-1,1205,1214,1127,-1,1422,1423,1424,-1,1422,1390,1423,-1,1124,1123,1125,-1,1124,273,1123,-1,233,1374,52,-1,233,1425,1374,-1,1377,34,33,-1,1426,34,1377,-1,1400,1427,1428,-1,1400,1429,1427,-1,1430,1120,282,-1,1428,1120,1430,-1,1119,347,1262,-1,1119,345,347,-1,1251,1176,1109,-1,1251,1406,1176,-1,1406,1431,1405,-1,1406,1251,1431,-1,1117,346,287,-1,1117,347,346,-1,1365,286,305,-1,1365,285,286,-1,1364,145,306,-1,1364,1432,145,-1,1107,164,163,-1,164,1107,1106,-1,1181,1105,1104,-1,1105,1181,213,-1,103,1227,1226,-1,1264,1227,103,-1,1193,1376,1363,-1,1193,1230,1376,-1,1433,1100,1434,-1,1433,988,1100,-1,310,1435,1099,-1,310,1103,1435,-1,1361,1097,1099,-1,1361,211,1097,-1,220,318,1029,-1,219,318,220,-1,321,1268,1250,-1,1095,1268,321,-1,1093,1250,1268,-1,1250,1093,161,-1,1092,1249,1370,-1,1249,1092,1148,-1,561,27,29,-1,561,1091,27,-1,149,1436,147,-1,1436,149,153,-1,1415,1436,1416,-1,1415,147,1436,-1,1360,155,154,-1,1360,1087,155,-1,329,113,112,-1,1086,113,329,-1,335,1085,119,-1,335,1270,1085,-1,1437,1081,340,-1,1437,342,1081,-1,1265,114,1113,-1,1271,114,1265,-1,108,343,118,-1,108,344,343,-1,528,1438,1439,-1,1438,528,1440,-1,1441,529,1442,-1,1441,1443,529,-1,1444,1219,1246,-1,1444,43,1219,-1,1205,1142,1214,-1,1205,1210,1142,-1,1386,1445,1387,-1,1446,1445,1386,-1,1077,370,1073,-1,1077,369,370,-1,1057,368,1131,-1,368,1057,371,-1,51,1072,362,-1,50,1072,51,-1,65,1160,1159,-1,1160,65,1071,-1,258,253,1447,-1,258,255,253,-1,378,1195,1066,-1,378,1196,1195,-1,1060,1280,1275,-1,1060,355,1280,-1,1276,1131,1130,-1,1276,1057,1131,-1,1382,1187,1080,-1,1245,1187,1382,-1,1385,1448,1368,-1,1385,1383,1448,-1,1146,1279,1449,-1,1146,358,1279,-1,1133,1450,1134,-1,1133,1064,1450,-1,265,1047,1242,-1,265,402,1047,-1,1046,247,386,-1,1058,247,1046,-1,1137,1044,1247,-1,1137,1045,1044,-1,1451,1452,1453,-1,1452,1451,1454,-1,1036,1042,1037,-1,1421,1042,1036,-1,382,69,1200,-1,382,70,69,-1,871,1013,1322,-1,787,1013,871,-1,953,1274,954,-1,1455,1274,953,-1,1456,818,817,-1,818,1456,1024,-1,1283,733,732,-1,1283,916,733,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_8()
		{
			int[] value = {951,479,952,-1,951,917,479,-1,1284,668,667,-1,1284,842,668,-1,1457,1451,1379,-1,1458,1451,1457,-1,1350,489,1459,-1,489,1350,1325,-1,1017,1460,473,-1,1017,1349,1460,-1,474,891,522,-1,474,892,891,-1,1008,819,843,-1,1008,462,819,-1,795,802,785,-1,802,795,872,-1,1011,1461,651,-1,1289,1461,1011,-1,797,876,798,-1,797,864,876,-1,1006,1274,1075,-1,1006,954,1274,-1,511,1462,1463,-1,1007,1462,511,-1,1464,506,1463,-1,1465,506,1464,-1,1466,1464,1467,-1,1466,1468,1464,-1,864,942,876,-1,1307,942,864,-1,1003,1469,1001,-1,1469,1003,1470,-1,1471,525,524,-1,1471,1472,525,-1,1001,1440,1004,-1,1473,1440,1001,-1,1474,541,540,-1,1475,541,1474,-1,1476,772,774,-1,772,1476,1477,-1,1478,884,1479,-1,1478,1480,884,-1,1347,775,550,-1,1347,542,775,-1,1295,961,745,-1,1295,995,961,-1,994,1481,945,-1,994,1482,1481,-1,826,752,751,-1,826,753,752,-1,1483,428,937,-1,427,428,1483,-1,906,1297,993,-1,906,1296,1297,-1,1334,1484,1315,-1,1484,1334,936,-1,1298,1485,578,-1,1298,990,1485,-1,834,583,1323,-1,834,989,583,-1,1333,990,558,-1,985,990,1333,-1,986,972,592,-1,986,973,972,-1,755,1345,593,-1,1486,1345,755,-1,622,601,598,-1,619,601,622,-1,534,621,620,-1,621,534,975,-1,1487,1488,1489,-1,1488,1487,1312,-1,912,1312,983,-1,1312,912,1488,-1,975,974,976,-1,1000,974,975,-1,626,1303,971,-1,626,969,1303,-1,1427,970,969,-1,970,1427,1429,-1,825,1490,823,-1,825,1491,1490,-1,813,677,676,-1,1492,677,813,-1,965,964,1493,-1,631,964,965,-1,513,939,514,-1,939,513,633,-1,1494,1495,1496,-1,1494,1497,1495,-1,907,697,933,-1,698,697,907,-1,1498,925,874,-1,1499,925,1498,-1,470,1285,471,-1,952,1285,470,-1,453,1500,452,-1,1500,453,457,-1,1501,1497,1502,-1,1501,1495,1497,-1,1028,1340,666,-1,1028,1501,1340,-1,767,943,1306,-1,767,671,943,-1,1503,1504,1481,-1,1504,1503,1505,-1,1016,1285,478,-1,1016,475,1285,-1,865,1506,849,-1,865,929,1506,-1,847,716,896,-1,847,720,716,-1,803,1507,728,-1,803,915,1507,-1,711,929,865,-1,929,711,930,-1,1018,928,927,-1,1018,723,928,-1,727,861,874,-1,861,727,726,-1,830,715,1311,-1,830,1508,715,-1,641,846,923,-1,640,846,641,-1,710,662,921,-1,662,710,663,-1,863,920,502,-1,920,863,862,-1,831,733,951,-1,734,733,831,-1,1351,468,949,-1,466,468,1351,-1,1344,1509,620,-1,1344,1510,1509,-1,1511,612,609,-1,1511,911,612,-1,1488,911,1511,-1,911,1488,912,-1,1512,909,1314,-1,1512,1489,909,-1,1513,908,982,-1,1513,738,908,-1,1294,1316,694,-1,1316,1294,973,-1,899,926,901,-1,899,485,926,-1,894,897,1023,-1,894,896,897,-1,970,1514,968,-1,1515,1514,970,-1,1516,680,1338,-1,1516,1517,680,-1,1518,893,892,-1,1518,477,893,-1,944,961,995,-1,1282,961,944,-1,611,653,652,-1,653,611,888,-1,600,604,858,-1,978,604,600,-1,883,1479,884,-1,883,1330,1479,-1,543,735,531,-1,543,443,735,-1,779,832,780,-1,832,779,777,-1,1519,1499,1498,-1,1520,1499,1519,-1,770,859,771,-1,860,859,770,-1,1498,495,1288,-1,1498,874,495,-1,486,1499,1520,-1,1499,486,488,-1,496,863,798,-1,496,794,863,-1,763,1496,637,-1,1329,1496,763,-1,962,1492,813,-1,962,1521,1492,-1,1468,624,855,-1,625,624,1468,-1,947,1026,996,-1,1026,947,946,-1,1459,1349,1350,-1,1349,1459,1522,-1,850,761,516,-1,1290,761,850,-1,1523,844,1020,-1,1470,844,1523,-1,482,1304,843,-1,482,481,1304,-1,762,823,1490,-1,675,823,762,-1,1332,901,635,-1,901,1332,960,-1,1524,1235,1224,-1,1524,839,1235,-1,882,836,835,-1,882,1223,836,-1,882,776,1524,-1,882,881,776,-1,696,580,579,-1,580,696,1525,-1,774,2,549,-1,774,553,2,-1,835,580,1318,-1,580,835,581,-1,563,1483,937,-1,1483,563,1526,-1,1325,683,927,-1,683,1325,1335,-1,467,1527,468,-1,1527,467,1528,-1,674,782,809,-1,628,782,674,-1,1470,1457,1469,-1,1470,1523,1457,-1,728,709,729,-1,728,1507,709,-1,946,1025,1026,-1,1025,946,431,-1,1339,814,805,-1,638,814,1339,-1,633,1336,939,-1,678,1336,633,-1,1494,1329,1493,-1,1494,1496,1329,-1,963,813,812,-1,963,962,813,-1,1017,1325,1350,-1,1017,1335,1325,-1,486,1320,1013,-1,1520,1320,486,-1,1519,1288,1529,-1,1288,1519,1498,-1,1327,877,642,-1,1327,958,877,-1,1519,1320,1520,-1,1320,1519,873,-1,618,1302,602,-1,618,1300,1302,-1,777,766,765,-1,777,779,766,-1,772,1330,756,-1,1330,772,1479,-1,431,1530,654,-1,431,430,1530,-1,1293,828,1027,-1,1293,2,828,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_9()
		{
			int[] value = {1317,815,1308,-1,1317,893,815,-1,1338,824,1516,-1,824,1338,1337,-1,1531,970,1429,-1,1531,1515,970,-1,1295,693,749,-1,747,693,1295,-1,584,591,590,-1,584,583,591,-1,1489,1513,1487,-1,1512,1513,1489,-1,1344,1532,1510,-1,1344,597,1532,-1,922,948,483,-1,922,1305,948,-1,709,663,710,-1,709,1507,663,-1,722,928,723,-1,724,928,722,-1,1331,702,722,-1,1331,1533,702,-1,1508,448,721,-1,830,448,1508,-1,854,712,1311,-1,930,712,854,-1,1533,715,1508,-1,1533,1331,715,-1,1534,573,827,-1,1534,574,573,-1,681,649,682,-1,681,521,649,-1,682,1018,683,-1,1018,682,1535,-1,823,1516,824,-1,967,1516,823,-1,638,1028,814,-1,638,1342,1028,-1,767,1504,765,-1,1504,767,1306,-1,1502,1340,1501,-1,1502,1536,1340,-1,1536,667,1340,-1,1536,1021,667,-1,1537,1538,1539,-1,1538,1537,1424,-1,660,519,657,-1,660,659,519,-1,1327,870,958,-1,1327,793,870,-1,637,1495,1342,-1,1496,1495,637,-1,1517,967,677,-1,1516,967,1517,-1,1531,632,1515,-1,1531,275,632,-1,629,971,1303,-1,971,629,623,-1,981,1312,1487,-1,1312,981,616,-1,781,987,585,-1,987,781,780,-1,982,1302,1300,-1,982,908,1302,-1,621,619,622,-1,977,619,621,-1,607,608,3,-1,607,910,608,-1,880,598,601,-1,599,598,880,-1,1345,595,594,-1,1345,739,595,-1,986,594,589,-1,594,986,592,-1,881,833,832,-1,881,1318,833,-1,1534,1152,932,-1,1433,1152,1534,-1,989,578,1485,-1,578,989,576,-1,576,573,577,-1,573,576,695,-1,688,1346,934,-1,688,572,1346,-1,1526,1315,1484,-1,1526,563,1315,-1,751,561,29,-1,904,561,751,-1,1482,754,753,-1,1482,748,754,-1,1482,1503,1481,-1,1503,1482,753,-1,746,1294,747,-1,555,1294,746,-1,540,552,1540,-1,540,1347,552,-1,884,1540,885,-1,884,1480,1540,-1,1541,1477,1476,-1,1477,1541,1478,-1,1475,1541,997,-1,1475,1474,1541,-1,539,1509,537,-1,539,535,1509,-1,1002,524,523,-1,1471,524,1002,-1,529,1014,530,-1,1014,529,1443,-1,523,455,902,-1,458,455,523,-1,1381,1001,1469,-1,1381,1473,1001,-1,517,658,434,-1,658,517,659,-1,761,513,514,-1,760,513,761,-1,1467,1386,1466,-1,1467,1446,1386,-1,507,1465,1291,-1,507,506,1465,-1,1542,1462,1007,-1,1542,1543,1462,-1,505,816,1005,-1,505,504,816,-1,924,502,920,-1,924,1324,502,-1,660,651,1461,-1,657,651,660,-1,851,1012,493,-1,1012,851,878,-1,820,526,482,-1,526,820,527,-1,462,509,1010,-1,462,1008,509,-1,815,477,476,-1,815,893,477,-1,1544,1328,1518,-1,1545,1328,1544,-1,468,1341,949,-1,468,1527,1341,-1,483,897,922,-1,897,483,898,-1,458,453,455,-1,453,458,457,-1,1546,1451,1458,-1,1546,1454,1451,-1,452,916,1283,-1,452,1500,916,-1,1537,1502,1497,-1,1539,1502,1537,-1,787,425,424,-1,787,871,425,-1,382,422,70,-1,382,420,422,-1,1274,1259,1074,-1,1274,1455,1259,-1,411,1547,1171,-1,411,47,1547,-1,1421,398,246,-1,1421,1036,398,-1,1451,1380,1379,-1,1451,1453,1380,-1,1247,395,1137,-1,395,1247,1236,-1,1064,1278,1450,-1,1064,1375,1278,-1,1384,1279,1052,-1,1277,1279,1384,-1,1187,1051,357,-1,1186,1051,1187,-1,1243,72,98,-1,1243,73,72,-1,1447,376,258,-1,1447,1355,376,-1,375,66,68,-1,1210,66,375,-1,1542,367,1273,-1,1542,1075,367,-1,363,1073,364,-1,1073,363,1077,-1,1387,363,1357,-1,1387,1445,363,-1,271,138,269,-1,271,1237,138,-1,1032,1210,375,-1,1032,1142,1210,-1,1378,1444,1548,-1,1378,43,1444,-1,1442,352,1441,-1,353,352,1442,-1,1439,349,348,-1,349,1439,1438,-1,349,1246,350,-1,349,1444,1246,-1,340,337,1437,-1,338,337,340,-1,337,335,1358,-1,337,1270,335,-1,1549,336,121,-1,332,336,1549,-1,118,330,116,-1,343,330,118,-1,414,156,1126,-1,156,414,325,-1,1416,326,1141,-1,1436,326,1416,-1,148,1221,27,-1,1221,148,147,-1,1249,1526,1484,-1,1526,1249,1269,-1,210,319,322,-1,210,1550,319,-1,218,1550,316,-1,319,1550,218,-1,1150,1362,1267,-1,1151,1362,1150,-1,1096,1103,1105,-1,1435,1103,1096,-1,1101,1233,24,-1,1101,837,1233,-1,1227,312,1266,-1,1227,1264,312,-1,163,309,311,-1,163,308,309,-1,1248,306,423,-1,1248,307,306,-1,304,1364,165,-1,304,1432,1364,-1,145,1551,1112,-1,145,1432,1551,-1,167,1115,298,-1,167,166,1115,-1,1175,292,126,-1,293,292,1175,-1,1409,1271,1265,-1,1409,1408,1271,-1,288,305,286,-1,305,288,303,-1,168,1178,1404,-1,168,1366,1178,-1,345,1118,392,-1,1119,1118,345,-1,282,276,1430,-1,282,277,276,-1,1401,1428,1430,-1,1401,1400,1428,-1,1399,1377,1122,-1,1399,1426,1377,-1,102,59,56,-1,102,101,59,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_10()
		{
			int[] value = {1413,1127,1238,-1,1413,1206,1127,-1,1390,1418,1423,-1,1390,1391,1418,-1,1128,1063,32,-1,1128,94,1063,-1,1184,203,1155,-1,1184,1164,203,-1,255,260,256,-1,255,258,260,-1,1079,253,255,-1,254,253,1079,-1,1538,1423,1552,-1,1538,1424,1423,-1,243,1553,244,-1,1553,243,397,-1,244,1419,1417,-1,1419,244,1553,-1,1414,131,106,-1,1414,1140,131,-1,1352,1228,419,-1,1228,1352,1229,-1,1397,33,35,-1,1397,1261,33,-1,1554,1367,272,-1,1554,1389,1367,-1,1080,1411,1382,-1,1411,1080,263,-1,26,1434,1100,-1,1434,26,316,-1,193,1555,1410,-1,182,1555,193,-1,1371,263,262,-1,1411,263,1371,-1,190,179,1253,-1,179,190,202,-1,1556,1041,186,-1,133,1041,1556,-1,1048,205,1040,-1,1048,1557,205,-1,172,30,1158,-1,172,9,30,-1,1551,288,1409,-1,303,288,1551,-1,1403,1405,1431,-1,1403,1404,1405,-1,310,314,311,-1,1266,314,310,-1,151,156,152,-1,151,154,156,-1,1554,227,1070,-1,1554,228,227,-1,1401,1426,1399,-1,1426,1401,1144,-1,1369,1398,229,-1,1388,1398,1369,-1,135,1396,1053,-1,134,1396,135,-1,238,1138,239,-1,1138,238,1139,-1,237,132,131,-1,237,1558,132,-1,146,121,144,-1,146,1549,121,-1,132,107,106,-1,1373,107,132,-1,1263,122,284,-1,122,1263,123,-1,1200,1394,1203,-1,1200,1199,1394,-1,69,82,81,-1,82,69,1244,-1,1354,1394,1393,-1,1354,75,1394,-1,178,1156,176,-1,178,1167,1156,-1,1374,1238,53,-1,1238,1374,1413,-1,136,1391,1125,-1,1559,1391,136,-1,1369,270,1367,-1,1369,55,270,-1,1215,53,1238,-1,1215,54,53,-1,415,328,416,-1,1359,328,415,-1,1051,1384,1052,-1,1051,1560,1384,-1,206,1154,207,-1,206,406,1154,-1,1380,43,1378,-1,43,1380,44,-1,1280,1276,1275,-1,1280,1058,1276,-1,39,1143,37,-1,1143,39,231,-1,1384,1561,1383,-1,1384,1560,1561,-1,1363,1194,1193,-1,1363,1233,1194,-1,23,119,1085,-1,22,119,23,-1,327,20,236,-1,327,18,20,-1,211,1376,1097,-1,25,1376,211,-1,1483,1269,222,-1,1483,1526,1269,-1,1353,1375,1065,-1,1353,1449,1375,-1,1448,186,1049,-1,1448,1556,186,-1,101,1212,59,-1,101,38,1212,-1,1259,1059,1130,-1,1259,1562,1059,-1,412,1258,413,-1,412,1030,1258,-1,419,1239,407,-1,419,1228,1239,-1,283,1387,1357,-1,283,278,1387,-1,1388,1412,1425,-1,1389,1412,1388,-1,1124,1422,1260,-1,1390,1422,1124,-1,1375,1279,1278,-1,1449,1279,1375,-1,1033,375,252,-1,1032,375,1033,-1,376,97,259,-1,376,95,97,-1,1392,104,1558,-1,104,1392,14,-1,1231,1220,105,-1,1231,1225,1220,-1,411,1083,341,-1,411,1170,1083,-1,260,295,256,-1,260,291,295,-1,1392,1030,359,-1,1031,1030,1392,-1,21,1359,415,-1,23,1359,21,-1,49,1245,139,-1,1185,1245,49,-1,35,230,1397,-1,35,231,230,-1,1400,1531,1429,-1,1402,1531,1400,-1,21,155,22,-1,155,21,1126,-1,167,1366,168,-1,167,300,1366,-1,1180,1404,1403,-1,1180,168,1404,-1,1407,1405,1177,-1,1407,1406,1405,-1,1272,287,346,-1,287,1272,1408,-1,1133,1164,1062,-1,1164,1133,1172,-1,171,208,207,-1,141,208,171,-1,173,10,9,-1,1218,10,173,-1,1253,1372,184,-1,1253,179,1372,-1,181,182,1372,-1,1555,182,181,-1,15,1410,185,-1,15,17,1410,-1,196,262,1252,-1,196,1371,262,-1,1208,1162,1209,-1,1208,195,1162,-1,207,1161,171,-1,207,188,1161,-1,1410,1557,185,-1,1557,1410,1555,-1,1153,210,1255,-1,1153,1550,210,-1,1370,1256,1092,-1,1370,1094,1256,-1,217,1150,1267,-1,217,315,1150,-1,1254,1257,1353,-1,1254,1157,1257,-1,230,102,229,-1,230,36,102,-1,36,230,39,-1,418,106,105,-1,1414,106,418,-1,1563,1552,1564,-1,1538,1552,1563,-1,1454,1564,1452,-1,1563,1564,1454,-1,1229,1417,1420,-1,1352,1417,1229,-1,1045,246,248,-1,1421,246,1045,-1,1204,82,1244,-1,82,1204,85,-1,1420,1215,1229,-1,1420,1559,1215,-1,1261,1398,233,-1,1261,1397,1398,-1,1121,1531,1402,-1,1531,1121,275,-1,1428,279,1120,-1,279,1428,1427,-1,1251,290,1431,-1,1251,289,290,-1,1263,1111,123,-1,1116,1111,1263,-1,285,1117,286,-1,285,80,1117,-1,127,1179,297,-1,1179,127,294,-1,305,301,1365,-1,305,304,301,-1,163,1364,308,-1,1364,163,165,-1,308,1104,309,-1,308,307,1104,-1,1230,1192,1226,-1,1193,1192,1230,-1,1152,1434,1153,-1,1152,1433,1434,-1,1362,1099,1435,-1,1362,1361,1099,-1,26,1361,1151,-1,26,211,1361,-1,315,219,1150,-1,318,219,315,-1,1415,1221,147,-1,1415,1222,1221,-1,214,154,151,-1,154,214,1360,-1,1190,332,1549,-1,332,1190,333,-1,121,335,119,-1,121,336,335,-1,342,334,331,-1,342,1437,334,-1,1440,1548,1438,-1,1440,1473,1548,-1,529,1439,1442,-1,529,528,1439,-1,359,412,360,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_11()
		{
			int[] value = {359,1030,412,-1,228,272,1356,-1,272,228,1554,-1,361,365,364,-1,365,361,58,-1,1446,1076,1445,-1,1076,1446,1543,-1,361,388,362,-1,388,361,366,-1,1145,362,388,-1,51,362,1145,-1,1447,1068,1067,-1,1447,253,1068,-1,377,1066,1195,-1,377,1355,1066,-1,378,1393,1196,-1,1393,378,1354,-1,1562,1443,1441,-1,1565,1443,1562,-1,1207,140,1382,-1,140,1207,1216,-1,1561,133,1556,-1,1561,134,133,-1,1368,1450,1385,-1,1368,1134,1450,-1,1135,1039,1172,-1,1039,1135,1040,-1,45,396,1281,-1,44,396,45,-1,1452,396,1453,-1,397,396,1452,-1,384,1132,390,-1,1132,384,398,-1,208,409,1547,-1,141,409,208,-1,1416,1140,1414,-1,1416,1141,1140,-1,87,1198,1168,-1,87,86,1198,-1,1319,463,426,-1,788,463,1319,-1,877,1013,1320,-1,1013,877,1322,-1,840,778,1505,-1,839,778,840,-1,1456,436,1024,-1,1456,700,436,-1,1566,467,466,-1,1566,721,467,-1,1458,1523,1022,-1,1458,1457,1523,-1,664,462,461,-1,664,819,462,-1,465,647,646,-1,1023,647,465,-1,1459,948,950,-1,948,1459,489,-1,1017,681,1335,-1,681,1017,472,-1,1527,1522,1341,-1,1522,1527,1567,-1,891,1506,520,-1,891,1317,1506,-1,955,843,1304,-1,1008,843,955,-1,878,1321,1529,-1,1321,878,802,-1,492,1289,493,-1,492,1461,1289,-1,507,1286,508,-1,1015,1286,507,-1,1009,1463,506,-1,511,1463,1009,-1,1463,1467,1464,-1,1463,1462,1467,-1,1468,1465,1464,-1,1468,855,1465,-1,1307,867,1568,-1,864,867,1307,-1,844,1003,902,-1,1470,1003,844,-1,526,1472,480,-1,526,525,1472,-1,1471,530,1472,-1,1348,530,1471,-1,1004,528,1348,-1,1004,1440,528,-1,542,531,775,-1,532,531,542,-1,538,1301,980,-1,538,537,1301,-1,533,1475,544,-1,1475,533,541,-1,549,1476,774,-1,548,1476,549,-1,1474,1478,1541,-1,1480,1478,1474,-1,885,552,551,-1,885,1540,552,-1,748,994,749,-1,748,1482,994,-1,840,1503,838,-1,1503,840,1505,-1,692,750,558,-1,750,692,691,-1,991,575,574,-1,991,570,575,-1,578,934,1298,-1,578,577,934,-1,984,990,985,-1,984,1485,990,-1,581,1101,579,-1,1101,581,837,-1,582,1323,583,-1,1323,582,987,-1,589,595,590,-1,595,589,594,-1,593,972,903,-1,592,972,593,-1,1345,599,739,-1,599,1345,1486,-1,1532,755,979,-1,755,1532,1486,-1,978,605,604,-1,605,978,737,-1,888,1313,889,-1,888,613,1313,-1,537,1510,1301,-1,1509,1510,537,-1,598,1344,622,-1,598,597,1344,-1,1314,736,1512,-1,1343,736,1314,-1,956,1000,879,-1,956,974,1000,-1,279,969,626,-1,279,1427,969,-1,1490,1514,966,-1,1491,1514,1490,-1,809,679,810,-1,679,809,782,-1,762,1493,1329,-1,965,1493,762,-1,1497,1569,1537,-1,1569,1497,1494,-1,488,899,901,-1,899,488,487,-1,703,897,896,-1,897,703,922,-1,652,657,656,-1,651,657,652,-1,665,457,459,-1,665,1500,457,-1,1501,1342,1495,-1,1501,1028,1342,-1,1570,1454,1546,-1,1570,1563,1454,-1,1539,1563,1570,-1,1539,1538,1563,-1,765,1505,778,-1,765,1504,1505,-1,679,1338,680,-1,783,1338,679,-1,783,1326,1338,-1,929,520,1506,-1,929,650,520,-1,934,692,1298,-1,1346,692,934,-1,1297,1334,993,-1,1334,1297,935,-1,568,932,697,-1,932,568,991,-1,1566,1508,721,-1,1566,1533,1508,-1,923,845,704,-1,845,923,846,-1,641,865,800,-1,865,641,711,-1,723,1535,713,-1,1018,1535,723,-1,724,718,928,-1,724,931,718,-1,447,1528,467,-1,447,469,1528,-1,446,466,1351,-1,1566,466,446,-1,960,921,925,-1,921,960,710,-1,620,535,534,-1,620,1509,535,-1,1489,1511,909,-1,1511,1489,1488,-1,1512,738,1513,-1,738,1512,736,-1,1343,605,736,-1,603,605,1343,-1,746,828,553,-1,746,745,828,-1,498,515,499,-1,516,515,498,-1,1491,968,1514,-1,1491,940,968,-1,1517,1336,680,-1,1517,1571,1336,-1,1518,764,477,-1,1518,1328,764,-1,1282,943,429,-1,1282,944,943,-1,766,671,767,-1,671,766,1572,-1,610,652,656,-1,652,610,611,-1,545,818,998,-1,818,545,440,-1,839,776,778,-1,1524,776,839,-1,807,1530,1572,-1,807,5,1530,-1,771,1011,653,-1,859,1011,771,-1,876,434,658,-1,876,942,434,-1,708,726,725,-1,726,708,918,-1,585,806,781,-1,587,806,585,-1,1422,964,1260,-1,1422,1569,964,-1,1521,1571,1492,-1,1521,938,1571,-1,1466,625,1468,-1,627,625,1466,-1,1339,1307,1568,-1,1339,941,1307,-1,853,812,763,-1,853,963,812,-1,996,1027,947,-1,996,1293,1027,-1,1460,474,473,-1,474,1460,1544,-1,847,699,845,-1,847,895,699,-1,481,953,1304,-1,953,481,1287,-1,1309,1326,630,-1,1309,1337,1326,-1,1545,1460,1567,-1,1460,1545,1544,-1,1524,1223,882,-1,1524,1224,1223,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_12()
		{
			int[] value = {1525,695,1299,-1,1525,696,695,-1,672,0,673,-1,0,672,829,-1,1525,834,833,-1,1525,1299,834,-1,838,841,840,-1,838,1234,841,-1,1528,1567,1527,-1,1567,1528,1545,-1,825,1337,1309,-1,824,1337,825,-1,1287,1455,953,-1,1287,1565,1455,-1,1379,1469,1457,-1,1381,1469,1379,-1,1506,1308,759,-1,1506,1317,1308,-1,1349,1567,1460,-1,1349,1522,1567,-1,638,1568,959,-1,638,1339,1568,-1,1386,627,1466,-1,280,627,1386,-1,939,1571,938,-1,1336,1571,939,-1,1493,1569,1494,-1,1569,1493,964,-1,654,5,655,-1,654,1530,5,-1,1292,434,1025,-1,1292,517,434,-1,861,918,862,-1,861,726,918,-1,634,1324,924,-1,634,799,1324,-1,873,1529,1321,-1,1529,873,1519,-1,617,976,887,-1,617,977,976,-1,976,784,887,-1,976,974,784,-1,1302,600,602,-1,600,1302,978,-1,1572,779,807,-1,779,1572,766,-1,551,980,885,-1,551,538,980,-1,1300,617,614,-1,618,617,1300,-1,430,1572,1530,-1,430,671,1572,-1,433,996,1026,-1,433,673,996,-1,1518,474,1544,-1,892,474,1518,-1,1309,1491,825,-1,1491,1309,940,-1,938,499,515,-1,938,1521,499,-1,907,936,742,-1,907,957,936,-1,1487,982,981,-1,1513,982,1487,-1,607,1343,1314,-1,606,1343,607,-1,1486,597,599,-1,597,1486,1532,-1,489,483,948,-1,484,483,489,-1,661,465,464,-1,914,465,661,-1,1456,439,758,-1,1456,817,439,-1,663,915,661,-1,1507,915,663,-1,960,1499,488,-1,960,925,1499,-1,1533,446,702,-1,1533,1566,446,-1,729,635,924,-1,635,729,709,-1,717,490,718,-1,926,490,717,-1,648,713,1535,-1,648,714,713,-1,719,634,636,-1,640,634,719,-1,449,1311,712,-1,830,1311,449,-1,574,932,991,-1,1534,932,574,-1,649,1535,682,-1,649,648,1535,-1,1521,868,499,-1,868,1521,962,-1,995,945,944,-1,995,994,945,-1,1539,1536,1502,-1,1539,1570,1536,-1,1570,1021,1536,-1,1570,1546,1021,-1,955,1006,510,-1,954,1006,955,-1,793,871,870,-1,425,871,793,-1,1568,866,959,-1,1568,867,866,-1,1537,1422,1424,-1,1569,1422,1537,-1,1490,965,762,-1,1490,966,965,-1,677,1571,1517,-1,1571,677,1492,-1,1515,966,1514,-1,1515,632,966,-1,940,1303,968,-1,940,629,1303,-1,563,744,1315,-1,563,562,744,-1,887,614,617,-1,614,887,615,-1,909,609,910,-1,909,1511,609,-1,1510,979,1301,-1,1510,1532,979,-1,889,983,769,-1,889,1313,983,-1,1330,979,755,-1,1330,883,979,-1,740,599,880,-1,740,739,599,-1,985,1316,986,-1,985,1333,1316,-1,1323,780,832,-1,1323,987,780,-1,1525,1318,580,-1,1318,1525,833,-1,827,1433,1534,-1,1433,827,988,-1,1485,591,989,-1,591,1485,984,-1,1299,576,989,-1,576,1299,695,-1,572,571,690,-1,572,688,571,-1,1296,567,569,-1,1296,906,567,-1,569,992,1296,-1,569,743,992,-1,1315,993,1334,-1,1315,1310,993,-1,826,1503,753,-1,1503,826,838,-1,747,694,693,-1,747,1294,694,-1,1474,1540,1480,-1,540,1540,1474,-1,1477,1479,772,-1,1477,1478,1479,-1,1476,997,1541,-1,997,1476,548,-1,997,544,1475,-1,997,546,544,-1,902,1002,523,-1,1002,902,1003,-1,1002,1348,1471,-1,1002,1004,1348,-1,480,530,1014,-1,480,1472,530,-1,1025,654,1292,-1,654,1025,431,-1,855,1291,1465,-1,855,808,1291,-1,1462,1446,1467,-1,1462,1543,1446,-1,1015,1291,1005,-1,1015,507,1291,-1,1075,1007,1006,-1,1542,1007,1075,-1,1005,1016,1015,-1,1005,816,1016,-1,494,1461,492,-1,660,1461,494,-1,493,852,851,-1,852,493,1289,-1,1529,1012,878,-1,1529,1288,1012,-1,1443,1287,1014,-1,1443,1565,1287,-1,460,508,1286,-1,460,1010,508,-1,759,849,1506,-1,759,1290,849,-1,469,1545,1528,-1,1545,469,1328,-1,1459,1341,1522,-1,950,1341,1459,-1,444,949,1305,-1,444,1351,949,-1,1022,1020,1284,-1,1022,1523,1020,-1,1022,1546,1458,-1,1022,1021,1546,-1,917,1500,665,-1,1500,917,916,-1,758,700,1456,-1,758,757,700,-1,1306,1481,1504,-1,1481,1306,945,-1,1319,792,789,-1,643,792,1319,-1,90,1198,84,-1,90,89,1198,-1,1419,1423,1418,-1,1419,1552,1423,-1,1035,1547,47,-1,208,1547,1035,-1,242,143,1037,-1,242,241,143,-1,186,1557,1048,-1,1557,186,185,-1,44,1453,396,-1,1380,1453,44,-1,248,41,40,-1,248,247,41,-1,1184,1062,1164,-1,1184,1183,1062,-1,1368,1049,1135,-1,1049,1368,1448,-1,134,1560,1396,-1,134,1561,1560,-1,1053,49,1054,-1,1185,49,1053,-1,371,1046,372,-1,1046,371,1057,-1,1441,1059,1562,-1,1441,352,1059,-1,1241,1196,1393,-1,1241,1243,1196,-1,1355,1067,1066,-1,1067,1355,1447,-1,389,366,1056,-1,389,388,366,-1,1273,1543,1542,-1,1273,1076,1543,-1,1445,1077,363,-1,1077,1445,1076,-1,269,1356,272,-1,269,138,1356,-1};
			return value;
		}
		private int[] getc6_Geo_8_69_coordIndex_13()
		{
			int[] value = {252,1078,1033,-1,252,254,1078,-1,1548,1381,1378,-1,1381,1548,1473,-1,1247,350,1246,-1,1247,1044,350,-1,348,1442,1439,-1,1442,348,353,-1,1438,1444,349,-1,1438,1548,1444,-1,1408,1191,1271,-1,1272,1191,1408,-1,1358,1437,337,-1,334,1437,1358,-1,1086,1190,113,-1,333,1190,1086,-1,326,153,152,-1,153,326,1436,-1,1415,417,1222,-1,1415,418,417,-1,150,217,1090,-1,150,215,217,-1,222,427,1483,-1,221,427,222,-1,1256,1095,1092,-1,1095,1256,1268,-1,1484,1370,1249,-1,1484,936,1370,-1,1435,1267,1362,-1,1096,1267,1435,-1,1266,1098,1227,-1,1099,1098,1266,-1,1096,213,1090,-1,1096,1105,213,-1,1248,1104,307,-1,1104,1248,1182,-1,304,164,301,-1,164,304,165,-1,1112,146,145,-1,146,1112,1114,-1,1109,126,125,-1,1175,126,1109,-1,1112,1409,1265,-1,1551,1409,1112,-1,1108,1177,294,-1,1407,1177,1108,-1,124,79,78,-1,124,1110,79,-1,157,1269,1249,-1,159,1269,157,-1,1430,1144,1401,-1,276,1144,1430,-1,1122,1402,1399,-1,1402,1122,1121,-1,1388,233,1398,-1,1388,1425,233,-1,1123,1377,137,-1,1377,1123,1122,-1,1420,1391,1559,-1,1418,1391,1420,-1,1162,198,1209,-1,198,1162,187,-1,422,85,1204,-1,422,421,85,-1,367,1131,368,-1,367,1074,1131,-1,397,1564,1553,-1,1564,397,1452,-1,1553,1552,1419,-1,1552,1553,1564,-1,1141,325,1139,-1,325,1141,326,-1,281,38,277,-1,281,1212,38,-1,391,1145,387,-1,1145,391,1055,-1,1257,1449,1353,-1,1449,1257,1146,-1,1157,1147,1257,-1,261,1147,1157,-1,159,323,1149,-1,159,158,323,-1,223,220,1029,-1,223,320,220,-1,1153,316,1550,-1,1153,1434,316,-1,1252,16,196,-1,1252,17,16,-1,1218,64,63,-1,405,64,1218,-1,183,261,1157,-1,261,183,1163,-1,11,175,1160,-1,11,10,175,-1,205,1555,181,-1,1557,1555,205,-1,1395,30,1063,-1,1158,30,1395,-1,1159,1211,65,-1,1159,1240,1211,-1,408,1547,409,-1,1171,1547,408,-1,1047,251,91,-1,1047,404,251,-1,1062,1064,1133,-1,1062,381,1064,-1,303,1432,304,-1,303,1551,1432,-1,1366,1179,1178,-1,1366,296,1179,-1,1111,1431,290,-1,1111,1403,1431,-1,936,1129,162,-1,957,1129,936,-1,1070,1389,1554,-1,1389,1070,1412,-1,1426,1143,34,-1,1426,1144,1143,-1,1051,1396,1560,-1,1051,1186,1396,-1,328,235,413,-1,236,235,328,-1,1558,1031,1392,-1,237,1031,1558,-1,259,291,260,-1,259,292,291,-1,1549,1114,1190,-1,146,1114,1549,-1,1373,1558,104,-1,1373,132,1558,-1,302,1263,284,-1,302,1115,1263,-1,1197,1262,79,-1,1119,1262,1197,-1,1395,383,1203,-1,1395,1063,383,-1,1211,1069,68,-1,1201,1069,1211,-1,1559,54,1215,-1,1559,136,54,-1,1425,1413,1374,-1,1412,1413,1425,-1,281,1357,365,-1,281,283,1357,-1,413,416,328,-1,413,1258,416,-1,1277,1450,1278,-1,1277,1385,1450,-1,1356,1166,228,-1,1356,1216,1166,-1,1455,1562,1259,-1,1565,1562,1455,-1,1058,41,247,-1,1058,1280,41,-1,231,34,1143,-1,231,35,34,-1,1383,1556,1448,-1,1383,1561,1556,-1,841,1222,417,-1,1222,841,1234,-1,1098,1376,1230,-1,1376,1098,1097,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc6_Coord_9_69_point_1()
		{
			double[] value = {-.50283,53.06068,-1.44633,-.49849,53.0575,-1.4496,-.44375,52.98255,-1.55065,-.4424,53.45789,-1.42165,-.43874,53.45551,-1.41829,-.41996,53.42117,-1.49292,-.01728,52.967,-2.24353,0.0,52.97641,-2.33182,0.0,52.98638,-2.23863,.74475,53.1478,-1.15171,.70296,53.12849,-1.14318,.696,53.15044,-1.12451,.43773,53.45548,-1.41775,.43874,53.45551,-1.41829,.41996,53.42117,-1.49292,.56177,52.98213,-1.01962,.53831,52.99806,-1.03641,.5654,52.99894,-1.0145,.53465,53.07633,-1.36371,.45732,53.09985,-1.32307,.51375,53.13973,-1.34694,.41254,52.98489,-1.60272,.4304,52.92897,-1.62361,.44375,52.98255,-1.55001,.06238,53.26434,-2.05039,.13422,53.23251,-2.0418,.12434,53.18552,-2.14522,.01551,53.03897,-1.98106,0.0,53.10747,-1.94721,0.0,53.06159,-1.98862,.76531,53.14226,-1.1245,.73066,53.14635,-1.12451,.78067,53.13188,-1.09989,.2935,53.2683,-1.06214,.28831,53.2389,-1.00916,.29862,53.24757,-1.0067,.32465,53.20032,-.91774,.3128,53.19322,-.92067,.33064,53.16511,-.87872,.31974,53.20658,-.9272,.33666,52.82638,-1.10073,.36529,52.77494,-1.0279,.31179,52.82535,-1.09868,.17002,52.86192,-1.37376,.171,52.88125,-1.38913,.24581,52.89329,-1.38495,.69308,53.10036,-1.2529,.61898,53.0732,-1.27288,.66656,53.09241,-1.28122,.50796,53.17181,-.89299,.46592,53.17157,-.87469,.46401,53.10572,-.90634,.33954,53.34341,-1.12011,.3377,53.37032,-1.16527,.28214,53.34205,-1.22725,.40147,53.32437,-.86911,.37822,53.24605,-.85726,.38299,53.2436,-.84827,.35412,53.15212,-.83815,.35161,53.16705,-.84653,.41005,53.42708,-1.51058,.36289,53.41366,-1.59287,.68507,53.13626,-1.20419,.67687,53.13704,-1.16034,.6728,53.09681,-1.18136,.61279,53.25845,-1.15588,.57449,53.30582,-1.16502,.55933,53.3061,-1.12016,.59104,53.2982,-1.22169,.97922,53.20918,-1.12249,.98447,53.17203,-1.10323,1.05288,53.17865,-1.09723,.91633,53.28399,-1.15792,.91355,53.27949,-1.13655,.91766,53.23962,-1.1354,.79997,53.21933,-1.16307,.74464,53.25649,-1.19279,.75288,53.21705,-1.1748,.85596,53.35705,-1.38828,.91857,53.41917,-1.27617,.85416,53.28355,-1.43354,.96349,53.19238,-1.14703,1.05113,53.14938,-1.12468,.97514,53.148,-1.16236,.93149,53.12591,-1.16015,1.03574,53.11094,-1.12975,.94315,53.16067,-1.17528,.91294,53.1826,-1.20704,.91768,53.23976,-1.15077,.86236,53.12215,-1.19242,.88587,53.10076,-1.1608,.8373,53.0825,-1.18105,.86839,53.07427,-1.11723,.91673,53.08866,-1.12114,.85051,53.10465,-1.08869,.82231,53.51072,-1.14573,.89474,53.48604,-1.21769,.82032,53.54276,-1.17104,.90778,53.36524,-1.17478,.87982,53.45362,-1.1823};
			return value;
		}
		private double[] getc6_Coord_9_69_point_2()
		{
			double[] value = {.86756,53.42696,-1.1532,.34045,53.17372,-.88192,.35785,53.24487,-.89468,.31463,53.40097,-1.66962,.37134,53.41498,-1.57228,.13599,53.32782,-1.81936,.21855,53.3154,-1.77419,.24108,53.38118,-1.7537,.80824,53.11931,-1.33987,.79352,53.13002,-1.33279,.70469,53.11668,-1.29067,.70278,53.10414,-1.29206,.90314,52.9184,-1.52284,.83438,52.87013,-1.58692,.90661,52.91855,-1.53,.79811,53.12827,-1.34336,.9144,52.99317,-1.45669,.88073,53.06616,-1.39019,.87628,53.06196,-1.38135,.44316,52.92928,-1.61902,.51057,52.8649,-1.65723,.53126,52.85532,-1.65354,.79052,53.30586,-1.46473,.78703,53.32185,-1.46668,.85394,53.3719,-1.39416,.89342,53.48965,-1.22421,.81895,53.54362,-1.1765,.50153,53.50745,-1.34444,.4966,53.50615,-1.33956,.55468,53.54744,-1.26606,.41962,53.43229,-1.49293,.29005,53.30524,-1.68705,.29864,53.34305,-1.66986,.55678,52.98974,-.95113,.56473,53.0427,-.90921,.53741,53.04326,-.92572,.2107,53.32332,-1.22568,.21705,53.25967,-1.14867,.48586,53.27118,-.91708,.5171,53.23524,-.91711,.52201,53.24835,-.9462,.51782,53.03646,-1.19649,.49677,53.01991,-1.17304,.45716,53.01064,-1.23548,.52363,52.86527,-1.66542,.63701,52.96741,-1.70154,.65615,52.86245,-1.66691,.13292,53.07624,-1.88169,.10046,53.02281,-1.92725,.1509,53.01784,-1.89394,.08187,52.98906,-1.96008,.26906,52.97311,-1.79164,.26219,53.0097,-1.77861,.20633,53.01478,-1.84919,.34152,52.96054,-1.71783,.39472,52.96087,-1.67546,.33831,52.99616,-1.70744,.13189,52.93144,-2.60105,.18508,52.92704,-2.5806,.115,52.92333,-2.56301,.14602,53.1553,-2.4767,.17055,53.15145,-2.53923,.11763,53.15043,-2.53891,.48614,53.16161,-1.65674,.54382,53.19632,-1.62895,.5439,53.15996,-1.65124,.6154,53.33031,-1.49073,.56592,53.34492,-1.48465,.60053,53.37368,-1.4245,.75456,53.14113,-1.28031,.47573,53.00336,-1.14959,.51148,53.03848,-1.14425,.75144,53.17274,-1.16872,.74757,53.12926,-1.16854,.67209,53.1696,-1.18088,.66285,53.15946,-1.14444,.73562,53.16655,-1.20391,.74692,53.19054,-1.18811,.72151,53.18435,-1.19859,.70209,53.04679,-.9922,.69244,53.00498,-1.01838,.66992,53.01567,-.99149,.64592,53.0536,-.97445,.66418,53.10986,-.94633,.69948,53.0989,-.94956,.59979,52.9563,-.9924,.59197,52.90813,-.99839,.60588,53.1532,-1.09657,.5821,53.11252,-1.12214,.66601,53.10229,-1.11319,.74206,53.05901,-1.00649,.74556,53.09858,-1.06355,.73136,53.08148,-1.07552,.61445,53.04591,-.96909,.52622,53.10677,-1.04143,.54746,53.16996,-1.01678,.55297,53.08767,-1.01317,.76003,53.10229,-1.05988,.61729,53.17815,-1.09918,.6806,53.12364,-1.10756};
			return value;
		}
		private double[] getc6_Coord_9_69_point_3()
		{
			double[] value = {.69407,53.14311,-1.10045,.71413,53.11497,-1.24835,.73015,53.03866,-1.02233,.71929,52.99157,-1.05327,.69461,52.98116,-1.02051,.66273,52.97168,-1.00293,.63504,53.12728,-1.16269,.577,53.07954,-1.14945,.56936,53.05788,-1.21224,.08919,53.16544,-2.46645,.12876,53.14354,-2.41208,.16571,53.21856,-2.03803,.21406,52.98025,-1.87114,.23926,52.94539,-1.90352,.29563,52.92949,-1.80524,.06728,52.97145,-2.03127,.01273,52.97146,-2.11885,.13456,52.94679,-2.03686,.13804,53.10409,-2.23444,.10244,53.0481,-2.23088,.1103,53.03669,-2.33092,.06649,52.94326,-2.40364,.06649,52.93831,-2.45962,.12366,52.96444,-2.4257,.17735,52.96452,-2.61849,.20241,52.97146,-2.58109,.53432,53.29023,-1.08484,.49736,53.34786,-1.05102,.50325,53.33799,-.99533,.36218,53.30003,-.9223,.32718,53.25397,-.94088,.30215,53.22333,-.95569,.27922,53.29767,-1.13286,.37127,53.3544,-1.02723,.4662,53.23132,-1.32856,.46987,53.24347,-1.3647,.49568,53.14987,-1.38462,.35708,53.31384,-1.59841,.35987,53.25544,-1.62079,.39747,53.26467,-1.53228,.39601,53.07886,-1.31335,.42816,53.04993,-1.30553,.38663,53.01709,-1.30423,.23851,53.03241,-1.32891,.23776,53.10403,-1.30384,.30922,53.09897,-1.31992,.38887,52.86705,-1.0907,.39457,52.78069,-1.0309,.36293,52.82806,-1.1027,.75045,53.1591,-1.18293,.76965,53.10824,-1.21873,.76901,53.09855,-1.18842,.55001,53.34951,-1.27622,.6008,53.43555,-1.2282,.5405,53.42829,-1.27332,.58283,53.52316,-1.22722,.55902,53.54778,-1.26327,.49175,53.47913,-1.31732,.65037,53.54304,-1.1792,.72335,53.56813,-1.14916,.63432,53.56711,-1.20226,.64668,53.16242,-.92932,.59851,53.13726,-.9532,.60186,53.19437,-.92827,.8229,53.06894,-1.08551,.82649,53.04033,-1.0965,.28323,53.34256,-1.23828,.28416,53.34333,-1.23766,.33621,53.33319,-1.24709,.45215,53.31736,-.87675,.40999,53.32432,-.86735,.43354,53.2518,-.84996,.47007,53.37394,-.91906,.07405,53.24014,-1.1502,0.0,53.22217,-1.14852,0.0,53.1967,-1.06967,.25736,53.1568,-.87843,.26815,53.13933,-.83499,.11742,53.08835,-.7475,0.0,53.09681,-.80625,0.0,53.07052,-.75804,.2831,53.13034,-.81086,.21318,53.12547,-.8051,.22042,53.10719,-.77732,.71542,53.28666,-1.50456,.80488,53.26598,-1.49865,.80599,53.20126,-1.54353,.87481,53.15064,-1.51595,.80605,53.1341,-1.57489,.78932,53.42979,-1.35186,.77963,53.40242,-1.38056,.63685,53.56841,-1.20616,.7244,53.56922,-1.15479,.6939,53.52298,-1.256,.54015,53.47898,-1.35475,.55995,53.54803,-1.26906,.49257,53.41489,-1.43541,.4424,53.45789,-1.42165,.52015,53.33341,-1.54036,.46231,53.38602,-1.53318};
			return value;
		}
		private double[] getc6_Coord_9_69_point_4()
		{
			double[] value = {.51238,53.37448,-1.4706,.64846,53.22308,-1.61559,.62191,53.30132,-1.53213,.70945,53.14099,-1.63126,.64421,53.15389,-1.65442,.71317,53.17878,-1.61576,.51516,52.96693,-1.71826,.47598,52.97892,-1.73885,.47676,53.06705,-1.69348,.40391,53.07704,-1.76188,.32854,53.16528,-1.83836,.40849,53.17219,-1.73484,.38718,53.2643,-1.70997,.47008,53.31047,-1.60623,.39032,53.22444,-1.7146,.08869,52.97864,-2.133,.11546,53.16895,-2.24933,.01728,52.967,-2.24351,.05113,52.99709,-2.23435,.13122,53.0972,-2.33188,.14901,53.02777,-2.39926,.18846,53.05486,-2.49009,.15758,53.08155,-2.40392,.19127,52.90794,-2.53183,.2074,52.99038,-2.49092,.32841,53.06472,-1.67911,.26101,53.07084,-1.76547,.50283,53.06068,-1.44576,.46481,53.15951,-1.4378,.83282,52.98116,-1.50717,.83354,53.00328,-1.4747,.7916,52.98917,-1.49908,.66852,52.91468,-1.60226,.72848,52.91244,-1.57933,.71559,52.97801,-1.52356,.53283,52.9584,-1.58082,.57513,52.92911,-1.59799,.58609,53.02289,-1.49728,.57706,53.04761,-1.44978,.52156,53.03551,-1.49141,.6456,53.06607,-1.40518,.62222,53.07615,-1.32648,.77121,53.04728,-1.44866,.81481,53.03582,-1.43353,.79254,53.07395,-1.39844,.89243,53.22555,-1.32517,.90255,53.16286,-1.40897,.88878,53.22518,-1.38229,.17619,52.84187,-1.08678,.1696,52.85451,-1.16793,.26615,52.86812,-1.17284,.2577,52.79449,-1.01156,.17122,52.75232,-.94317,.18186,52.80303,-1.0008,.2647,52.84069,-1.08832,.31659,52.79263,-1.009,.64122,53.2048,-.86601,.61589,53.19194,-.83206,.67122,53.19628,-.80677,.43272,53.40633,-1.40947,.45769,53.4127,-1.35648,.35006,53.06339,-.86869,.40471,53.08976,-.89523,.21474,53.0117,-.80576,.28769,53.03116,-.84033,.28591,53.12597,-.80247,.33908,52.9942,-.88843,.10679,52.81972,-.83374,.2149,52.82481,-.83584,.21776,52.89759,-.83683,.2874,52.91037,-.86029,.2908,52.83787,-.84506,.35538,52.85315,-.89057,.50716,53.34267,-1.11417,.63675,53.3212,-1.24006,.55124,53.31431,-1.25881,.73285,53.54239,-1.13627,.82826,53.47134,-1.1278,.80726,53.32232,-1.17589,.72684,53.31766,-1.22113,.76906,53.09076,-.98998,.78035,53.05359,-.9833,.91607,53.16541,-1.10929,.85664,53.15914,-1.11826,.42682,52.87651,-.9894,.41228,52.86746,-.94117,.40442,52.80787,-1.01708,.46077,52.97039,-.95184,.39878,53.0114,-.92223,.40212,52.94181,-.92341,.47953,52.94532,-1.0142,.50259,52.98367,-.95949,.90117,53.20905,-1.25761,.81398,53.1693,-1.26233,.32451,52.92932,-1.35046,.30414,52.89463,-1.34465,.17051,52.92878,-1.36563,.16726,53.02348,-1.31366,.41667,52.90888,-1.08525,.51947,52.94742,-1.0273};
			return value;
		}
		private double[] getc6_Coord_9_69_point_5()
		{
			double[] value = {.47748,52.96934,-1.07007,.49441,53.02605,-1.06603,.80141,53.01801,-1.12256,.73998,53.04893,-1.12998,.74858,53.05835,-1.15663,.71478,53.08463,-1.16447,.66486,53.1181,-1.14653,.42104,53.14266,-1.32616,.53131,53.05217,-1.30979,.51923,53.03536,-1.24721,.47422,53.07202,-1.31929,.61831,53.07683,-1.31594,.44358,53.33025,-1.38078,.45028,53.25243,-1.41004,.36988,53.07337,-1.61828,.41349,53.06554,-1.56702,.42866,53.16863,-1.49909,.06395,53.26445,-1.85641,.14018,53.25866,-1.83065,.36161,53.15791,-1.31379,.92363,53.11398,-1.09369,.97811,53.10265,-1.12172,.97614,53.12144,-1.09186,.49403,52.89104,-1.68758,-.91673,53.08866,-1.12168,-.97811,53.10265,-1.12217,-.93149,53.12591,-1.16058,0.0,52.98755,-2.38432,-.06649,52.94326,-2.4037,-.39747,53.26467,-1.53248,-.40532,53.31645,-1.51942,-.42868,53.32603,-1.42128,-.4662,53.23132,-1.32884,-.46987,53.24347,-1.36496,-.47943,53.33214,-1.3257,-.69308,53.10036,-1.25348,-.60801,53.07387,-1.22667,-.67383,53.11061,-1.21248,-.47422,53.07202,-1.31983,-.53131,53.05217,-1.31041,-.54694,53.07186,-1.35426,-.75615,53.11932,-1.2501,-.75456,53.14113,-1.2808,-.70469,53.11668,-1.29122,-.72004,52.91766,-1.02617,-.69461,52.98116,-1.02131,-.66273,52.97168,-1.00374,-.53958,52.93517,-1.02385,-.56177,52.98213,-1.02035,-.53831,52.99806,-1.03708,-.38663,53.01709,-1.30476,-.35317,52.97391,-1.32475,-.37237,52.92483,-1.24882,-.34578,52.89673,-1.26788,-.30414,52.89463,-1.34521,-.30503,52.88555,-1.27468,-.28024,52.87944,-1.32329,-.34956,52.87774,-1.18674,-.31409,52.86875,-1.18625,-.36293,52.82806,-1.10342,-.41228,52.86711,-.94305,-.40442,52.80756,-1.01857,-.35959,52.75839,-.92409,-.88587,53.10076,-1.16133,-.8373,53.0825,-1.18166,-.8178,53.03413,-1.14949,-.63726,52.89628,-1.00764,-.59197,52.90813,-.99928,-.64399,52.89605,-.98419,-.55678,52.98974,-.95181,-.51947,52.94742,-1.02805,-.53628,52.99284,-.95713,-.67122,53.19628,-.807,-.66896,53.16652,-.81341,-.61375,53.16949,-.83082,-.50586,53.03606,-.94243,-.50553,53.11281,-.90157,-.53632,53.11702,-.89437,-.46077,52.97039,-.95247,-.42682,52.87651,-.99014,-.17122,52.72393,-.95945,-.16664,52.69371,-.92647,-.26755,52.70215,-.9573,-.77384,53.01145,-1.01271,-.78035,53.05359,-.98393,-.7876,53.07337,-1.03529,-.85664,53.15914,-1.11863,-.85051,53.10465,-1.08921,-.81519,53.14421,-1.12507,-.77233,53.06229,-.91552,-.76906,53.09076,-.99052,-.72684,53.31766,-1.22118,-.70594,53.37513,-1.20423,-.79573,53.39017,-1.16196,-.62481,53.36,-1.24724,-.74464,53.25649,-1.19298,-.65989,53.2882,-1.23356,-.50716,53.34267,-1.11424,-.49736,53.34786,-1.05108,-.46138,53.40024,-1.03629};
			return value;
		}
		private double[] getc6_Coord_9_69_point_6()
		{
			double[] value = {-.53432,53.29023,-1.08499,-.55933,53.3061,-1.12029,-.61279,53.25845,-1.1561,-.43354,53.2518,-.85012,-.46592,53.17157,-.87499,-.4208,53.16356,-.8631,-.28909,52.97183,-.8545,-.33908,52.99408,-.88889,-.34058,52.92174,-.88708,-.2908,52.8188,-.86011,-.2149,52.79511,-.85531,-.21776,52.8762,-.84615,-.47119,53.24398,-.88915,-.45215,53.31736,-.87682,-.47007,53.37394,-.91906,-.46906,53.38926,-.97733,-.50325,53.33799,-.99539,-.48937,53.4153,-1.31195,-.49175,53.47913,-1.31732,-.53718,53.50012,-1.26729,-.60017,53.20665,-.90124,-.64122,53.2048,-.86626,-.61589,53.19194,-.83232,-.26615,52.86812,-1.17336,-.2647,52.83752,-1.09001,-.2577,52.77986,-1.0207,-.27045,52.74344,-.97956,-.31659,52.78469,-1.01645,0.0,52.82316,-1.08817,0.0,52.79843,-1.0089,-.11051,52.78781,-1.01229,-.80824,53.11931,-1.3404,-.79254,53.07395,-1.3991,-.75077,53.07369,-1.39598,-.90255,53.16286,-1.40933,-.91417,53.08273,-1.44321,-.88073,53.06616,-1.39085,-.90042,52.97886,-1.53723,-.90661,52.91855,-1.53106,-.92588,52.99055,-1.45976,-.7916,52.98917,-1.49994,-.77121,53.04728,-1.44938,-.81481,53.03582,-1.43428,-.70278,53.10414,-1.29264,-.6456,53.06607,-1.40583,-.54628,53.07211,-1.36743,-.57706,53.04761,-1.45043,-.52156,53.03551,-1.49204,-.51136,53.00319,-1.52516,-.45918,52.98332,-1.54578,-.9144,52.99317,-1.45754,-.90314,52.9184,-1.5239,-.83282,52.98116,-1.50806,-.4304,52.92897,-1.6243,-.46048,52.90837,-1.65549,-.40497,52.92388,-1.69372,-.17189,52.97504,-1.93006,-.21406,52.98025,-1.87144,-.18408,52.96044,-1.96806,-.01273,52.97146,-2.11887,0.0,52.99791,-2.12516,0.0,53.02356,-2.04228,-.115,52.92333,-2.5631,-.06678,52.94883,-2.51002,-.10071,52.91497,-2.52591,-.14901,53.02777,-2.39936,-.15758,53.08155,-2.404,-.18846,53.05486,-2.49017,-.12876,53.14354,-2.41212,-.17827,53.12853,-2.49164,-.13122,53.0972,-2.33194,-.1103,53.03669,-2.331,-.05113,52.99709,-2.2344,-.12434,53.18552,-2.14528,-.11546,53.16895,-2.24937,-.13804,53.10409,-2.23452,-.21596,53.15803,-2.02983,-.16086,53.12019,-2.14684,-.23041,53.11522,-2.02943,-.06238,53.26434,-2.05041,-.10151,53.30064,-1.95936,-.06359,53.31514,-1.95633,-.38718,53.2643,-1.71014,-.31336,53.20437,-1.83468,-.39032,53.22444,-1.71482,-.4155,53.35963,-1.60671,-.47008,53.31047,-1.60636,-.44523,53.37604,-1.55407,-.48335,53.25096,-1.62118,-.40391,53.07704,-1.7623,-.40849,53.17219,-1.73514,-.32854,53.16528,-1.8386,-.47598,52.97892,-1.73949,-.51516,52.96693,-1.71896,-.47676,53.06705,-1.69398,-.48614,53.16161,-1.6571,-.54145,53.27766,-1.58449,-.70945,53.14099,-1.63172,-.71317,53.17878,-1.61613,-.64421,53.15389,-1.65483};
			return value;
		}
		private double[] getc6_Coord_9_69_point_7()
		{
			double[] value = {-.62191,53.30132,-1.53227,-.72615,53.25046,-1.56337,-.71542,53.28666,-1.50469,-.51238,53.37448,-1.47063,-.52015,53.33341,-1.54045,-.56592,53.34492,-1.48472,-.49257,53.41489,-1.43541,-.49935,53.44898,-1.41087,-.50153,53.50745,-1.34444,-.58671,53.50848,-1.30988,-.55995,53.54803,-1.26906,-.63685,53.56841,-1.20616,-.65296,53.53466,-1.27201,-.6939,53.52298,-1.256,-.85394,53.3719,-1.39416,-.91456,53.42468,-1.28567,-.78932,53.42979,-1.35186,-.85596,53.35705,-1.38828,-.79052,53.30586,-1.46477,-.80488,53.26598,-1.49878,-.87481,53.15064,-1.51635,-.87056,53.21465,-1.47282,-.80599,53.20126,-1.54382,-.26815,53.13933,-.83521,-.2831,53.13034,-.81109,-.22042,53.10719,-.77752,-.10699,53.10548,-.80459,-.11742,53.08832,-.74756,-.33064,53.16511,-.87897,-.25736,53.1568,-.87864,-.3128,53.19322,-.92088,-.07405,53.24014,-1.15025,-.08072,53.198,-1.07359,-.40999,53.32432,-.86741,-.61729,53.17815,-1.09955,-.696,53.15044,-1.12496,-.69407,53.14311,-1.10091,-.28231,53.34234,-1.23852,-.33707,53.24211,-1.28651,-.28323,53.34256,-1.23836,-.60588,53.1532,-1.097,-.56094,53.16901,-1.06294,-.96349,53.19238,-1.14722,-.94315,53.16067,-1.1756,-.97514,53.148,-1.16268,-.86839,53.07427,-1.11783,-.85052,53.06063,-1.13658,-.82649,53.04033,-1.0972,-.64668,53.16242,-.92968,-.65701,53.19298,-.90375,-.60186,53.19437,-.92857,-.65037,53.54304,-1.1792,-.63432,53.56711,-1.20226,-.72335,53.56813,-1.14916,-.43272,53.40633,-1.40948,-.43773,53.45548,-1.41775,-.55902,53.54778,-1.26327,-.58283,53.52316,-1.22722,-.55001,53.34951,-1.27628,-.5405,53.42829,-1.27332,-.6008,53.43555,-1.2282,-.76901,53.09855,-1.189,-.75045,53.1591,-1.18336,-.74757,53.12926,-1.16903,-.39457,52.78004,-1.03293,-.38887,52.86705,-1.09141,-.30922,53.09897,-1.32027,-.23851,53.03241,-1.32924,-.31827,53.02339,-1.32703,-.39601,53.07886,-1.31381,-.42816,53.04993,-1.30606,-.35708,53.31384,-1.59853,-.51375,53.13973,-1.34739,-.49568,53.14987,-1.38505,-.34146,53.15564,-.8418,-.27922,53.29767,-1.13298,-.33954,53.34341,-1.12019,-.37127,53.3544,-1.02729,-.40147,53.32437,-.86917,-.35785,53.24487,-.89485,-.36218,53.30003,-.9224,-.68194,53.20139,-.84844,-.70086,53.18497,-.88089,-.75295,53.16124,-.87655,-.17735,52.96452,-2.61858,-.18508,52.92704,-2.58072,-.20241,52.97146,-2.5812,-.19127,52.90794,-2.53198,-.10244,53.0481,-2.23097,-.12366,52.96444,-2.4258,-.06109,52.98255,-2.33373,-.06728,52.97145,-2.03136,-.13456,52.94679,-2.03704,-.26906,52.97311,-1.79203,-.29563,52.92949,-1.80571,-.16571,53.21856,-2.03811,-.13422,53.23251,-2.04185,-.06075,53.18044,-2.39401,-.08919,53.16544,-2.46646,-.63504,53.12728,-1.16318};
			return value;
		}
		private double[] getc6_Coord_9_69_point_8()
		{
			double[] value = {-.56936,53.05788,-1.21286,-.69244,53.00498,-1.01913,-.66992,53.01567,-.9922,-.71929,52.99157,-1.05408,-.51148,53.03848,-1.14486,-.49441,53.02605,-1.06663,-.52622,53.10677,-1.0419,-.71413,53.11497,-1.2489,-.7063,53.16233,-1.21324,-.70296,53.12849,-1.14368,-.74475,53.1478,-1.15216,-.54746,53.16996,-1.01714,-.55297,53.08767,-1.01369,-.66418,53.10986,-.94681,-.63038,53.127,-.94987,-.61445,53.04591,-.96971,-.73136,53.08148,-1.07611,-.74556,53.09858,-1.0641,-.74206,53.05901,-1.00712,-.6806,53.12364,-1.10806,-.66601,53.10229,-1.11374,-.59979,52.9563,-.9932,-.67786,53.06242,-.97783,-.69948,53.0989,-.95007,-.70209,53.04679,-.99284,-.73562,53.16655,-1.20433,-.72151,53.18435,-1.19897,-.74692,53.19054,-1.18846,-.67687,53.13704,-1.16083,-.66285,53.15946,-1.14486,-.68507,53.13626,-1.20468,-.49677,53.01991,-1.17367,-.45716,53.01064,-1.23609,-.45212,52.97487,-1.15724,-.47573,53.00336,-1.15023,-.79352,53.13002,-1.3333,-.60053,53.37368,-1.42451,-.6154,53.33031,-1.49081,-.6426,53.36135,-1.44157,-.5439,53.15996,-1.65163,-.54382,53.19632,-1.62927,-.14602,53.1553,-2.47672,-.11763,53.15043,-2.53892,-.17055,53.15145,-2.53923,-.13189,52.93144,-2.60114,-.3821,52.99206,-1.6572,-.39472,52.96087,-1.67605,-.34152,52.96054,-1.71834,-.20633,53.01478,-1.84946,-.26219,53.0097,-1.77896,-.08187,52.98906,-1.96019,-.01551,53.03897,-1.98107,-.10046,53.02281,-1.92737,-.13292,53.07624,-1.88183,-.1509,53.01784,-1.89413,-.63701,52.96741,-1.70234,-.52363,52.86527,-1.66633,-.51782,53.03646,-1.19711,-.51923,53.03536,-1.24784,-.52201,53.24835,-.9464,-.48586,53.27118,-.91723,-.503,53.31098,-.95233,-.21705,53.25967,-1.1488,-.28214,53.34205,-1.22734,-.53741,53.04326,-.92628,-.21855,53.3154,-1.77425,-.29864,53.34305,-1.66992,-.29005,53.30524,-1.68716,-.4966,53.50615,-1.33956,-.89342,53.48965,-1.22421,-.89474,53.48604,-1.21769,-.82032,53.54276,-1.17104,-.53126,52.85532,-1.65447,-.51057,52.8649,-1.65812,-.44316,52.92928,-1.61973,-.87628,53.06196,-1.38202,-.13142,53.38115,-1.80373,-.24108,53.38118,-1.75372,-.13599,53.32782,-1.8194,-.3122,53.40022,-1.66782,-.31463,53.40097,-1.66963,-.36289,53.41366,-1.59287,-.34045,53.17372,-.88216,-.32465,53.20032,-.91795,-.91985,53.39573,-1.22607,-.90778,53.36524,-1.17478,-.86756,53.42696,-1.1532,-.92363,53.11398,-1.09414,-.86236,53.12215,-1.19291,-.84948,53.14158,-1.21611,-.76965,53.10824,-1.21928,-.91768,53.23976,-1.15086,-.91294,53.1826,-1.20732,-1.03574,53.11094,-1.13012,-.68751,53.25492,-1.19797,-.91633,53.28399,-1.15793,-.91766,53.23962,-1.13549,-.57449,53.30582,-1.16516,-.59104,53.2982,-1.22184,-.56587,53.22711,-1.08748};
			return value;
		}
		private double[] getc6_Coord_9_69_point_9()
		{
			double[] value = {-.57017,53.21623,-1.03984,-.55209,53.24422,-1.03254,-.90363,53.34022,-1.12956,-.6728,53.09681,-1.18194,-.45732,53.09985,-1.32355,-.42104,53.14266,-1.32655,-.41005,53.42708,-1.51058,-.37134,53.41498,-1.57228,-.35412,53.15212,-.83841,-.35161,53.16705,-.84677,-.37822,53.24605,-.85742,-.38299,53.2436,-.84844,-.3377,53.37032,-1.16532,-.39327,53.39858,-1.10352,-.36161,53.15791,-1.31412,-.50796,53.17181,-.8933,-.46401,53.10572,-.90675,-.57181,53.06438,-1.31644,-.61831,53.07683,-1.31656,-.35818,52.73503,-.97271,-.33492,52.73679,-.99392,-.36529,52.77242,-1.03181,-.31179,52.82444,-1.0999,-.2935,53.2683,-1.06229,-.29862,53.24757,-1.00686,-.28831,53.2389,-1.00933,-.05251,53.09216,-1.92385,-.06186,53.2361,-2.14764,-.41254,52.98489,-1.60331,-.53465,53.07633,-1.36429,-.5654,52.99894,-1.01519,-.47748,52.96934,-1.07075,-.24416,53.38239,-1.75873,-.19275,53.3042,-1.88849,-.237,53.2643,-1.90743,-.08177,53.35805,-1.88657,0.0,53.36783,-1.90074,0.0,53.33806,-1.96691,-.05755,53.16497,-1.89428,-.06284,53.33016,-1.83426,-.06395,53.26445,-1.85644,0.0,53.26641,-1.86391,-.32451,52.92932,-1.35102,-.2838,52.7019,-.9288,-.23878,52.87319,-1.36515,-.577,53.07954,-1.15003,-.5821,53.11252,-1.12264,-.65832,53.08944,-1.12611,-.66656,53.09241,-1.28181,-.54377,53.24143,-.97855,-.52925,53.27139,-1.02676,-.8545,53.39179,-1.13913,-.82826,53.47134,-1.1278,-.28416,53.34333,-1.23774,-.59851,53.13726,-.95362,-.28591,53.12597,-.80271,-.41962,53.43229,-1.49293,-.46231,53.38602,-1.53319,-.5147,53.32443,-1.54141,-.82231,53.51072,-1.14573,-.87982,53.45362,-1.1823,-.71444,53.21292,-1.18616,-.68523,53.20923,-1.19494,-.64782,53.25641,-1.18884,-.50562,53.32277,-1.2087,-.55614,53.21076,-.99278,-.39651,53.36712,-1.19089,-.44674,53.35609,-1.19918,-.43319,53.39599,-1.11529,-1.05288,53.17865,-1.09735,-1.03746,53.13455,-1.09671,-.97614,53.12144,-1.09224,-.91355,53.27949,-1.13657,-.89265,53.22965,-1.13694,-.75288,53.21705,-1.17508,-.63675,53.3212,-1.24015,-.55124,53.31431,-1.25895,-.97922,53.20918,-1.1226,-.86646,53.33138,-1.14868,-.90117,53.20905,-1.25784,-.64846,53.22308,-1.61587,-.14127,53.38409,-1.80745,-.07508,53.38759,-1.8181,-.71413,52.86357,-1.64372,-.72036,52.85123,-1.62623,-.83438,52.87013,-1.58809,-.79811,53.12827,-1.34387,-.91857,53.41917,-1.27617,-.7244,53.56922,-1.15479,-.81895,53.54362,-1.1765,-.55468,53.54744,-1.26606,-.57315,53.183,-.86547,-.5713,53.17048,-.86404,-.53912,53.17193,-.88739,-.73998,53.04893,-1.13067,-.66486,53.1181,-1.14705,-.73139,53.03951,-1.10403,-.78228,53.00895,-1.09312,-.8002,53.03649,-1.05824,-.81547,53.08832,-1.06187};
			return value;
		}
		private double[] getc6_Coord_9_69_point_10()
		{
			double[] value = {-.8229,53.06894,-1.08613,-.78067,53.13188,-1.10036,-.24698,52.88533,-1.27766,-.49403,52.89104,-1.6884,-.01523,53.0057,-2.02959,-.2074,52.99038,-2.49105,-.22606,53.05614,-2.56871,-.05881,53.17609,-2.45636,-.70381,53.34566,-1.47171,-.58424,53.44687,-1.36616,-.54015,53.47898,-1.35475,-.66658,53.51186,-1.28326,-.7154,53.48468,-1.28655,-.81398,53.1693,-1.26272,-.74858,53.05835,-1.1573,-.71478,53.08463,-1.16507,-.40215,52.93968,-1.1666,-.41667,52.90888,-1.08595,-.69611,53.17816,-1.20948,-.67209,53.1696,-1.18129,-.66508,53.20063,-1.16229,-.75144,53.17274,-1.16911,-.74625,52.96108,-1.03981,-.52877,53.10973,-1.10236,-.63986,53.20108,-1.12654,-.76999,53.18246,-1.15235,-.76003,53.10229,-1.06042,-.7647,53.121,-.92656,-.72211,53.08235,-.96144,-.57008,53.19479,-.95007,-.56516,53.15399,-.97671,-.73015,53.03866,-1.02301,-.06308,53.17965,-2.33361,0.0,53.20174,-2.3738,-.16416,53.04447,-2.13541,-.10681,53.11709,-2.56912,0.0,53.08985,-2.52503,-.06649,52.93831,-2.45968,-.42529,53.39567,-.97038,-.42396,53.3755,-.91679,-.23666,53.18125,-.95379,-.42217,53.2331,-1.30155,-.48646,53.29737,-1.29766,-.35987,53.25544,-1.62098,-.34816,53.16557,-1.64104,-.28006,53.16685,-1.74633,-.42621,53.25937,-1.45282,-.42866,53.16863,-1.49944,-.76692,52.99911,-.96726,-.69602,52.88397,-.96906,-.73164,52.93555,-.89782,-.44707,52.93911,-1.07831,-.47953,52.94532,-1.0149,-.08011,52.70503,-.87292,-.0948,52.73676,-.85164,-.20249,52.72353,-.85907,-.91352,53.27553,-1.2192,0.0,53.1458,-2.44933,-1.05698,53.16505,-1.10578,-.33621,53.33319,-1.24719,-.76531,53.14226,-1.12495,-.36988,53.07337,-1.6187,-.4019,53.40007,-1.11248,-.34303,53.3717,-1.17501,-.06749,53.28112,-1.22642,-.14389,53.24168,-1.15108,-.15178,53.20958,-1.07081,-.32668,53.30502,-1.04111,-.16789,53.16691,-.95307,-.09492,53.13758,-.88011,-.08594,53.16672,-.94971,-.21318,53.12547,-.80529,-.43882,52.92005,-1.71587,-.38079,52.92956,-1.76411,-.90799,53.28762,-1.29095,-.88878,53.22518,-1.38248,-.90422,53.29028,-1.34724,-.85416,53.28355,-1.4336,-.6227,53.31407,-1.5326,-.71012,52.96096,-1.66833,-.83971,52.8756,-1.59732,-.77963,53.40242,-1.38056,-.74564,53.37391,-1.43111,-.77366,53.46567,-1.29787,-.33987,53.08619,-1.86375,-.31762,52.9909,-1.89634,-.40826,52.98604,-1.79757,-.359,53.33314,-1.69056,0.0,53.25369,-2.14894,-.26685,53.17807,-1.94395,-.26539,53.01904,-1.98261,-.11584,53.14719,-2.33036,-.18147,53.14941,-2.57318,-.15907,53.01884,-2.62586,-.26101,53.07084,-1.76577,-.32841,53.06472,-1.6795,-.46481,53.15951,-1.43819,-.58609,53.02289,-1.49798,-.62222,53.07615,-1.3271,-.83647,53.16313,-1.34902};
			return value;
		}
		private double[] getc6_Coord_9_69_point_11()
		{
			double[] value = {-.89243,53.22555,-1.32535,-.09277,52.86324,-1.26288,-.1696,52.85405,-1.16916,-.16547,52.87833,-1.27333,-.09585,52.85037,-1.16501,-.40471,53.08976,-.89562,-.10679,52.79565,-.84991,-.11453,52.87009,-.83069,-.29459,52.7396,-.88307,-.2874,52.89949,-.8664,-.35538,52.84646,-.89803,-.73285,53.54239,-1.13627,-.80726,53.32232,-1.1759,-.91607,53.16541,-1.1096,-.09362,52.73296,-.95158,-.39878,53.0114,-.92272,-.46121,53.03202,-.93198,-.72688,53.15349,-.78788,-.71779,53.13775,-.91751,-.33666,52.8262,-1.10161,-.24581,52.89329,-1.38542,-.16726,53.02348,-1.3139,-.17051,52.92878,-1.36594,-.80141,53.01801,-1.12332,-.61898,53.0732,-1.27351,-.44358,53.33025,-1.3809,-.45028,53.25243,-1.41027,-.41349,53.06554,-1.5675,-.29067,53.16892,-1.29628,.06109,52.98255,-2.33368,.42868,53.32603,-1.42115,.40532,53.31645,-1.51929,.48646,53.29737,-1.29749,.47943,53.33214,-1.32558,.67383,53.11061,-1.21193,.60801,53.07387,-1.22606,.40215,52.93968,-1.16595,.40729,52.96404,-1.24056,.75615,53.11932,-1.24956,.72004,52.91766,-1.0252,.68255,52.88443,-1.01497,.53958,52.93517,-1.02306,.37237,52.92483,-1.24818,.31827,53.02339,-1.32659,.31409,52.86875,-1.18565,.34956,52.87774,-1.18609,.35959,52.76794,-.91166,.8178,53.03413,-1.14875,.63726,52.89628,-1.00669,.64399,52.89605,-.98324,.53628,52.99284,-.95647,.61375,53.16949,-.83051,.66896,53.16652,-.81312,.53632,53.11702,-.89395,.50553,53.11281,-.90115,.50586,53.03606,-.94187,.34058,52.92503,-.88413,.29459,52.76246,-.86214,.35818,52.7427,-.96226,.16664,52.72414,-.90696,.27045,52.76335,-.96452,.7876,53.07337,-1.03469,.77384,53.01145,-1.01197,.81519,53.14421,-1.12464,.77233,53.06229,-.91494,.7647,53.121,-.92612,.79573,53.39017,-1.16196,.70594,53.37513,-1.20423,.62481,53.36,-1.24722,.65989,53.2882,-1.2334,.46138,53.40024,-1.03629,.58626,53.24777,-1.10976,.4208,53.16356,-.86281,.28909,52.97535,-.85339,.0948,52.76029,-.83476,0.0,52.82119,-.84119,.10877,52.94401,-.80124,.21247,52.96103,-.82232,.48937,53.4153,-1.31195,.53718,53.50012,-1.26729,.60017,53.20665,-.90098,.75077,53.07369,-1.39532,.83647,53.16313,-1.34862,.54628,53.07211,-1.36684,.49849,53.0575,-1.44902,.45918,52.98332,-1.54513,.78975,52.94634,-1.5483,.40497,52.92388,-1.69307,.46048,52.90837,-1.65474,.17189,52.97504,-1.92983,.18408,52.96044,-1.96781,.01523,53.0057,-2.02957,.15907,53.01884,-2.62581,.18147,53.14941,-2.57318,.10681,53.11709,-2.56911,.22606,53.05614,-2.56865,.26539,53.01904,-1.98231,.21128,53.24302,-1.95832,.237,53.2643,-1.90734,.26685,53.17807,-1.94379};
			return value;
		}
		private double[] getc6_Coord_9_69_point_12()
		{
			double[] value = {.06186,53.2361,-2.14762,0.0,53.29584,-2.0512,.4155,53.35963,-1.60665,.33987,53.08619,-1.86342,.40826,52.98604,-1.79703,.31762,52.9909,-1.89593,.54145,53.27766,-1.58431,.48335,53.25096,-1.62096,.58671,53.50848,-1.30988,.77366,53.46567,-1.29787,.91456,53.42468,-1.28567,.74564,53.37391,-1.43111,.71012,52.96096,-1.66746,.83971,52.8756,-1.59616,.71413,52.86357,-1.64261,.6227,53.31407,-1.53249,.70381,53.34566,-1.47169,.87056,53.21465,-1.4726,.91352,53.27553,-1.21917,.90799,53.28762,-1.29093,.10699,53.10548,-.80449,.08072,53.198,-1.07353,.15178,53.20958,-1.0707,.14389,53.24168,-1.15098,.06749,53.28112,-1.22639,.14317,53.29491,-1.22871,.3821,52.99206,-1.65666,.39651,53.36712,-1.19083,.81547,53.08832,-1.06131,.05881,53.17609,-2.45635,.18429,52.72411,-.87202,.20249,52.75643,-.83485,.44707,52.93911,-1.07762,.76692,52.99911,-.9665,.73164,52.93555,-.89694,.69602,52.88397,-.96806,.35317,52.97391,-1.32421,.34578,52.89673,-1.26725,.38915,53.16917,-1.56631,.34816,53.16557,-1.64075,.28193,53.24455,-1.71567,.28006,53.16685,-1.74611,.44747,53.30042,-1.25854,.29111,53.21377,-.95799,.23666,53.18125,-.95361,.46121,53.03202,-.93145,.68194,53.20139,-.8482,.65701,53.19298,-.90347,.14548,52.97514,-2.61336,.10071,52.91497,-2.52583,.16416,53.04447,-2.13526,.16086,53.12019,-2.14674,0.0,53.20965,-2.31864,.06308,53.17965,-2.33359,.65832,53.08944,-1.12553,.73139,53.03951,-1.10333,.7063,53.16233,-1.21281,.68208,53.15001,-.92045,.76999,53.18246,-1.152,.66508,53.20063,-1.16195,.63986,53.20108,-1.12621,.52877,53.10973,-1.10187,.56094,53.16901,-1.06256,.63038,53.127,-.94942,.74625,52.96108,-1.03893,.56587,53.22711,-1.08721,.52925,53.27139,-1.02658,.69611,53.17816,-1.20909,.84948,53.14158,-1.21567,.45212,52.97487,-1.15658,.54694,53.07186,-1.35367,.57181,53.06438,-1.31582,.72849,52.9242,-1.01298,.66658,53.51186,-1.28326,.65296,53.53466,-1.27201,.74657,53.50617,-1.26222,.7154,53.48468,-1.28655,.58424,53.44687,-1.36616,.5607,53.42009,-1.39656,.49935,53.44898,-1.41087,.6426,53.36135,-1.44155,.32605,52.934,-1.81694,.38079,52.92956,-1.76352,.8002,53.03649,-1.05754,.78228,53.00895,-1.09234,.53912,53.17193,-.88707,.5713,53.17048,-.86373,.57315,53.183,-.86518,.44523,53.37604,-1.55403,.5147,53.32443,-1.5413,.72036,52.85123,-1.62508,.92588,52.99055,-1.45891,.14127,53.38409,-1.80744,.12807,53.34184,-1.88115,.08177,53.35805,-1.88657,.8545,53.39179,-1.13913,.86646,53.33138,-1.14868,.91985,53.39573,-1.22607,.90276,53.14141,-1.18381,.89265,53.22965,-1.13679};
			return value;
		}
		private double[] getc6_Coord_9_69_point_13()
		{
			double[] value = {.90309,53.20035,-1.12389,.68751,53.25492,-1.19775,.71444,53.21292,-1.18585,.85468,53.18955,-1.13414,1.03746,53.13455,-1.09643,.44674,53.35609,-1.19911,.43319,53.39599,-1.11529,.54377,53.24143,-.97833,.55614,53.21076,-.9925,.57017,53.21623,-1.03956,.50562,53.32277,-1.20858,.64782,53.25641,-1.18862,.34146,53.15564,-.84155,.42217,53.2331,-1.30129,.38827,53.32306,-1.25651,.28231,53.34234,-1.23843,.52456,53.25647,-.97453,.55209,53.24422,-1.03231,.71205,53.1162,-1.1551,.23878,52.87319,-1.36468,.06284,53.33016,-1.83424,.05251,53.09216,-1.9238,.05755,53.16497,-1.89423,0.0,53.39351,-1.81875,0.0,53.38998,-1.81507,.05933,53.38487,-1.81611,.24416,53.38239,-1.75871,.28064,53.2945,-1.81094,.33707,53.24211,-1.2863,.29123,53.23612,-1.27193,.19275,53.3042,-1.88844,.13142,53.38115,-1.80372,.07508,53.38759,-1.8181,.06359,53.31514,-1.95632,0.0,53.16345,-1.90923,0.0,53.32994,-1.83225,.28024,52.87944,-1.32275,.47119,53.24398,-.88897,.34303,53.3717,-1.17495,.38043,53.24355,-1.2934,.68523,53.20923,-1.19462,.90226,53.27955,-1.13258,.85052,53.06063,-1.13593,.90363,53.34022,-1.12956,1.05698,53.16505,-1.10562,.54932,53.19252,-.89272,.24698,52.88533,-1.27719,.30503,52.88555,-1.27411,.43882,52.92005,-1.71517,.07587,52.98992,-2.55884,.17827,53.12853,-2.49161,.73145,53.43521,-1.34109,.58371,53.06679,-.99114,.72211,53.08235,-.96089,.71779,53.13775,-.91711,.06075,53.18044,-2.394,.1857,53.10097,-2.61242,.70086,53.18497,-.88061,.42621,53.25937,-1.4526,.08011,52.7253,-.85848,0.0,53.27612,-1.22111,.32668,53.30502,-1.04099,.90422,53.29028,-1.34722,.71399,53.30824,-1.50863,.359,53.33314,-1.69048,.8304,52.9607,-1.60385,.31336,53.20437,-1.83449,.22405,53.02215,-2.03833,.22662,53.11179,-2.58002,.06678,52.94883,-2.50997,.51136,53.00319,-1.52448,.90042,52.97886,-1.53635,.91417,53.08273,-1.44262,.11453,52.88989,-.82164,0.0,52.74661,-.85321,.26755,52.7256,-.93886,.2838,52.72505,-.90842,.71038,53.0788,-.81431,.75263,53.08826,-.81072,.72688,53.15349,-.78758,.33492,52.74602,-.98313,.24955,52.93801,-1.36169,-.38915,53.16917,-1.56663,-.40729,52.96404,-1.24119,-.24955,52.93801,-1.36212,-.50259,52.98367,-.96014,-.40212,52.94181,-.92401,-.07606,52.70527,-.90499,-.80402,53.26336,-1.17146,-.76994,53.46532,-1.14357,-.52456,53.25647,-.97472,-.35006,53.06339,-.86906,-.45769,53.4127,-1.35648,-.44502,53.05873,-1.51106,-.36651,52.91916,-1.72864,-.33831,52.99616,-1.70791,-.22662,53.11179,-2.58004,-.1857,53.10097,-2.61243,-.22405,53.02215,-2.03857,-.21128,53.24302,-1.95841};
			return value;
		}
		private double[] getc6_Coord_9_69_point_14()
		{
			double[] value = {-.78703,53.32185,-1.46669,-.8304,52.9607,-1.60477,-.71399,53.30824,-1.50871,-.18906,53.14843,-.87816,-.18429,52.69182,-.8946,-.72849,52.9242,-1.01393,-.28193,53.24455,-1.71583,-.44747,53.30042,-1.25871,-.5171,53.23524,-.91732,-.29111,53.21377,-.95817,-.14548,52.97514,-2.61343,-.58371,53.06679,-.9917,-.73145,53.43521,-1.34109,-.74657,53.50617,-1.26222,-.5607,53.42009,-1.39656,-.07587,52.98992,-2.55888,-.32605,52.934,-1.81744,-.54932,53.19252,-.89301,-.12807,53.34184,-1.88117,-.90276,53.14141,-1.18422,-.90309,53.20035,-1.12411,-.90226,53.27955,-1.1326,-.98447,53.17203,-1.10345,-.28064,53.2945,-1.81103,-.58626,53.24777,-1.11,-.76646,53.12443,-.8667,-.31974,53.20658,-.9274,-1.05113,53.14938,-1.1249,-.56473,53.0427,-.90978,-.2107,53.32332,-1.22576,-.65615,52.86245,-1.66797,-.64592,53.0536,-.97506,-.73066,53.14635,-1.12496,-.23926,52.94539,-1.90387,-.08913,53.05148,-2.57507,-.75166,53.16155,-.84066,-.41529,53.37423,-.91777,-.30215,53.22333,-.95587,-.32718,53.25397,-.94104,-.38043,53.24355,-1.29363,-.23776,53.10403,-1.30412,-.69285,52.94439,-.89527,-.29123,53.23612,-1.27213,-.53926,53.39733,-1.42226,-.80605,53.1341,-1.57536,-.54522,53.06658,-1.68823,-.08869,52.97864,-2.13311,-.83354,53.00328,-1.47554,-.10115,52.82594,-1.08732,-.71038,53.0788,-.8148,-.75263,53.08826,-.81119,-.68255,52.88443,-1.01598,.29067,53.16892,-1.29602,.75295,53.16124,-.87623,.80402,53.26336,-1.17133,.76994,53.46532,-1.14357,.503,53.31098,-.95223,.22393,53.10012,-.76177,.64627,52.96665,-1.55086,.44502,53.05873,-1.51053,.36651,52.91916,-1.72804,.21596,53.15803,-2.02969,.23041,53.11522,-2.02925,.10151,53.30064,-1.95934,.54522,53.06658,-1.68768,.72615,53.25046,-1.56316,.53926,53.39733,-1.42225,.42396,53.3755,-.91679,.69285,52.94439,-.89444,.41529,53.37423,-.91777,.08913,53.05148,-2.57504,.56516,53.15399,-.97633,.67786,53.06242,-.97723,.3122,53.40022,-1.66781,.39327,53.39858,-1.10351,.76646,53.12443,-.8663,.17123,53.26616,-1.96,.22179,53.22791,-1.07532,.0981,52.85321,-1.36622,0.0,52.87177,-1.38207,.0996,52.87315,-1.38236,0.0,52.85109,-1.36323,.56398,53.20806,-.92725,.64874,53.02286,-.86081,.65953,53.0948,-.82847,.69449,53.01108,-.84564,0.0,53.06325,-.74243,.12028,53.08142,-.73181,.41669,53.39432,-.97016,.42529,53.39567,-.97038,.06745,53.28141,-1.23741,.14338,53.29543,-1.23966,.41793,53.38116,-1.49732,.86105,53.26827,-1.15048,.85271,53.21996,-1.15006,.80544,53.17753,-1.14404,.56617,53.11416,-.87654,.3327,53.28516,-.98693,.36673,53.32722,-.97476,.15983,53.18824,-1.01183};
			return value;
		}
		private double[] getc6_Coord_9_69_point_15()
		{
			double[] value = {.08594,53.16672,-.94964,.16789,53.16691,-.95293,.08364,53.18044,-1.00809,.66924,53.38222,-1.41313,.62159,53.39428,-1.39947,.64361,53.42081,-1.36795,.67596,53.45334,-1.32601,.62184,53.482,-1.31728,.89004,53.07824,-1.53537,.8193,53.0632,-1.60027,.60698,53.00029,-.98087,.57008,53.19479,-.94976,.42261,53.4056,-1.02996,.4019,53.40007,-1.11247,.21102,53.25248,-1.78995,.13727,53.1636,-1.85665,.21572,53.16252,-1.81605,.23683,53.17468,-1.27945,.15318,53.22577,-1.25522,.15796,53.1587,-1.27599,.22903,53.2428,-1.25771,.37534,52.90626,-1.16848,0.0,53.27681,-1.23215,.07242,53.20746,-1.25389,0.0,53.20323,-1.2561,.41388,53.40434,-1.02955,.22968,53.20155,-1.00747,0.0,53.13141,-.87361,.09492,53.13758,-.88002,0.0,53.15911,-.95081,.18906,53.14843,-.878,.70212,53.40834,-1.37517,.64598,53.06455,-1.68217,0.0,53.22639,-2.24206,.06388,53.2041,-2.2468,.28145,53.09818,-1.96499,.20575,53.07468,-1.83292,.69416,53.03307,-1.46775,.09585,52.8515,-1.1638,.10115,52.83373,-1.08766,0.0,52.84785,-1.16286,.09362,52.7537,-.93944,.11051,52.80448,-1.00732,0.0,52.74906,-.95438,.16547,52.87833,-1.27301,.11104,52.99355,-.78467,0.0,52.98449,-.78608,.68156,53.4527,-1.18625,.6451,52.95844,-.90668,.75166,53.16155,-.84036,.74415,53.00135,-.84626,0.0,52.91823,-1.36509,.09575,53.01378,-1.31478,.09979,52.91831,-1.36011,0.0,53.01461,-1.32559,0.0,52.71713,-.87425,-.57483,53.05676,-1.26111,-.0996,52.87315,-1.38256,-.09979,52.91831,-1.36029,-.74415,53.00135,-.84695,-.65953,53.0948,-.82894,-.68156,53.4527,-1.18625,-.10877,52.93037,-.80278,-.21247,52.94922,-.82347,-.21474,53.00751,-.80484,-.28769,53.0309,-.84057,-.12028,53.08135,-.73182,-.11104,52.98522,-.78192,-.22393,53.10012,-.76198,-.0981,52.85321,-1.36643,-.17002,52.86192,-1.37411,-.17619,52.83396,-1.08813,-.18186,52.78206,-1.00905,0.0,52.86097,-1.25713,-.71559,52.97801,-1.52443,-.69416,53.03307,-1.46849,-.53283,52.9584,-1.58159,-.57513,52.92911,-1.59885,-.66852,52.91468,-1.60323,-.65847,52.84681,-1.65165,-.72848,52.91244,-1.58035,-.21572,53.16252,-1.81622,-.20575,53.07468,-1.83314,0.0,52.99081,-2.43204,0.0,53.04592,-2.52094,-.28145,53.09818,-1.96524,-.64598,53.06455,-1.68278,-.70212,53.40834,-1.37517,-.67596,53.45334,-1.32601,-.64361,53.42081,-1.36795,-.22179,53.22791,-1.07547,-.22968,53.20155,-1.00764,-.41388,53.40434,-1.02955,-.14317,53.29491,-1.22878,-.14338,53.29543,-1.23973,-.22903,53.2428,-1.25786,-.2109,53.32411,-1.2367,-.15318,53.22577,-1.25533,-.79997,53.21933,-1.16332,-.80544,53.17753,-1.1444};
			return value;
		}
		private double[] getc6_Coord_9_69_point_16()
		{
			double[] value = {-.37534,52.90626,-1.16914,-.23683,53.17468,-1.27967,-.15796,53.1587,-1.27615,-.13727,53.1636,-1.85676,-.21102,53.25248,-1.79006,-.14018,53.25866,-1.83072,-.56398,53.20806,-.92752,-.71205,53.1162,-1.15563,-.60698,53.00029,-.98158,-.89004,53.07824,-1.53597,-.8193,53.0632,-1.60091,-.62184,53.482,-1.31728,-.62159,53.39428,-1.39947,-.66924,53.38222,-1.41313,-.15983,53.18824,-1.01195,-.08364,53.18044,-1.00816,-.3327,53.28516,-.98706,-.36673,53.32722,-.97484,-.56617,53.11416,-.87697,-.85271,53.21996,-1.15027,-.85468,53.18955,-1.13443,-.42261,53.4056,-1.02996,-.69449,53.01108,-.8463,-.171,52.88125,-1.38947,-.05933,53.38487,-1.81612,-.17123,53.26616,-1.96006,0.0,52.99408,-2.47977,-.6451,52.95844,-.90746,-.59931,52.97316,-.92516,-.86105,53.26827,-1.15055,-.41793,53.38116,-1.49735,0.0,53.17658,-1.00867,-.71065,53.06005,-1.65849,-.63845,53.00798,-.98689,-.06388,53.2041,-2.24682,-.68208,53.15001,-.92083,-.16265,53.09129,-1.29478,-.07242,53.20746,-1.25395,0.0,53.14243,-1.27604,-.08016,53.1432,-1.27561,-.78975,52.94634,-1.54926,-.64627,52.96665,-1.55171,0.0,52.87822,-.83047,0.0,52.93485,-.80802,-.60909,53.10442,-.84489,-.60268,53.03514,-.88289,-.09575,53.01378,-1.31492,.57483,53.05676,-1.26048,.09277,52.86324,-1.26269,.65847,52.84681,-1.65055,.11584,53.14719,-2.33032,.71065,53.06005,-1.65786,.08016,53.1432,-1.27552,.16265,53.09129,-1.29459,.46906,53.38926,-.97733,.63845,53.00798,-.98618,.59931,52.97316,-.92442,.63126,52.96399,-.99767,.3584,53.35617,-1.58403,.2109,53.32411,-1.23663,.60909,53.10442,-.84445,.60268,53.03514,-.8823,.07606,52.72429,-.89209,0.0,53.07818,-1.29807,.08784,53.07861,-1.29494,0.0,52.71606,-.90518,-.63126,52.96399,-.99847,-.64874,53.02286,-.86143,-.38827,53.32306,-1.25663,-.06745,53.28141,-1.23745,-.08784,53.07861,-1.29505,-.41669,53.39432,-.97016,-.3584,53.35617,-1.58409};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc6disc_Geo_8_74_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,4,10,-1,11,12,13,-1,14,15,16,-1,0,2,17,-1,18,19,20,-1,21,18,20,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,6,35,-1,36,37,33,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,45,-1,47,49,48,-1,50,51,52,-1,53,54,55,-1,56,47,45,-1,57,58,59,-1,60,61,58,-1,62,63,64,-1,65,66,67,-1,65,68,69,-1,70,71,72,-1,72,73,74,-1,73,75,76,-1,77,78,79,-1,80,81,82,-1,83,14,84,-1,85,86,82,-1,81,80,87,-1,88,89,90,-1,20,91,21,-1,92,93,94,-1,40,19,95,-1,96,97,98,-1,61,99,43,-1,59,61,100,-1,101,102,22,-1,103,104,23,-1,105,106,104,-1,55,107,0,-1,85,108,40,-1,54,109,110,-1,54,111,107,-1,100,55,0,-1,102,103,23,-1,43,99,112,-1,96,44,64,-1,98,113,114,-1,20,19,40,-1,92,115,93,-1,116,117,118,-1,90,89,91,-1,90,119,120,-1,86,121,80,-1,85,82,81,-1,16,122,87,-1,86,95,19,-1,14,123,124,-1,125,102,126,-1,127,93,128,-1,76,75,129,-1,68,127,69,-1,60,130,62,-1,63,131,64,-1,98,97,131,-1,66,57,59,-1,132,130,69,-1,56,133,134,-1,100,42,135,-1,134,136,49,-1,96,133,44,-1,38,137,138,-1,33,37,138,-1,6,36,35,-1,104,27,24,-1,36,39,38,-1,139,140,20,-1,17,59,141,-1,89,21,91,-1,142,128,93,-1,11,13,4,-1,6,143,144,-1,12,145,92,-1,5,4,13,-1,125,103,102,-1,40,39,139,-1,13,92,5,-1,146,143,116,-1,92,13,12,-1,144,36,6,-1,4,9,11,-1,96,98,114,-1,139,20,40,-1,37,36,38,-1,23,104,24,-1,35,32,34,-1,35,33,32,-1,33,138,31,-1,29,24,30,-1,38,108,137,-1,133,56,44,-1,134,49,47,-1,9,136,11,-1,9,147,136,-1,42,41,148,-1,55,100,135,-1,134,47,56,-1,58,61,59,-1,149,67,2,-1,131,63,130,-1,127,128,69,-1,150,2,1,-1,131,97,64,-1,60,151,130,-1,74,127,70,-1,76,129,152,-1,153,80,121,-1,14,16,154,-1,126,155,156,-1,80,82,86,-1,153,21,89,-1,126,157,125,-1,87,154,16,-1,81,158,85,-1,155,124,159,-1,153,160,159,-1,90,120,88,-1,90,161,119,-1,91,118,90,-1,117,162,118,-1,115,142,93,-1,96,64,97,-1,46,43,112,-1,15,101,22,-1,163,105,104,-1,100,0,141,-1,107,55,54,-1,54,110,164,-1,95,85,40,-1,54,164,111,-1,100,141,59,-1,106,25,104,-1,103,163,104,-1,102,23,22,-1,122,16,165,-1,94,5,92,-1,153,89,160,-1,80,166,87,-1,85,95,86,-1,14,154,123,-1,126,84,155,-1,73,76,167,-1,70,72,74,-1,130,132,131,-1,64,112,62,-1,60,99,61,-1,63,62,130,-1,79,168,169,-1,67,17,2,-1,133,96,115,-1,55,135,53,-1,50,170,51,-1,134,11,136,-1,135,42,148,-1,44,56,45,-1,42,100,43,-1,40,108,38,-1,33,35,36,-1,34,7,6,-1,31,171,32,-1,104,25,27,-1,22,24,29,-1,37,38,138,-1,17,141,0,-1,101,83,102,-1,43,100,61,-1,11,134,12,-1,10,172,9,-1,6,8,143,-1,173,145,12,-1,139,144,140,-1,115,92,145,-1,107,1,0,-1,111,1,107,-1,111,150,1,-1,174,175,176,-1,174,106,175,-1,8,116,143,-1,8,117,116,-1,3,10,4,-1,10,3,177,-1,178,179,180,-1,178,181,179,-1,182,52,183,-1,184,52,182,-1,51,180,185,-1,51,178,180,-1,24,186,30,-1,24,27,186,-1,165,138,137,-1,138,165,28,-1,187,188,189,-1,53,188,187,-1,170,9,172,-1,170,147,9,-1,50,190,191,-1,50,192,190,-1,190,148,48,-1,188,148,190,-1,115,173,133,-1,115,145,173,-1,193,127,68,-1,127,193,70,-1,112,60,62,-1,99,60,112,-1,149,194,195,-1,149,2,194,-1,131,113,98,-1,113,131,132,-1,194,196,169,-1,194,197,196,-1,168,198,199,-1,198,168,79,-1,200,70,193,-1,200,71,70,-1,127,94,93,-1,127,74,94,-1,89,201,160,-1,88,201,89,-1,202,157,126,-1,202,203,157,-1,84,124,155,-1,84,14,124,-1,204,120,205,-1,120,204,206,-1,156,159,207,-1,155,159,156,-1,198,204,208,-1,198,209,204,-1,166,153,159,-1,166,80,153,-1,205,208,204,-1,208,205,210,-1};
			return value;
		}
		private int[] getc6disc_Geo_8_74_coordIndex_2()
		{
			int[] value = {152,211,212,-1,152,129,211,-1,177,152,213,-1,177,76,152,-1,106,214,25,-1,106,174,214,-1,165,15,22,-1,16,15,165,-1,213,212,215,-1,213,152,212,-1,211,216,217,-1,211,129,216,-1,216,205,217,-1,216,210,205,-1,206,209,218,-1,204,209,206,-1,207,219,156,-1,207,218,219,-1,166,154,87,-1,154,166,123,-1,77,176,175,-1,79,176,77,-1,77,219,78,-1,77,202,219,-1,207,160,201,-1,207,159,160,-1,73,220,75,-1,220,73,72,-1,221,72,71,-1,72,221,220,-1,222,193,223,-1,193,222,200,-1,168,222,195,-1,168,199,222,-1,151,66,65,-1,66,151,57,-1,176,169,196,-1,169,176,79,-1,195,169,168,-1,195,194,169,-1,150,194,2,-1,150,197,194,-1,54,187,109,-1,54,53,187,-1,192,188,190,-1,188,192,189,-1,49,190,48,-1,190,49,191,-1,172,51,170,-1,178,51,172,-1,41,48,148,-1,48,41,45,-1,189,224,187,-1,189,225,224,-1,22,28,165,-1,29,28,22,-1,186,26,226,-1,186,27,26,-1,183,51,185,-1,183,52,51,-1,171,183,32,-1,182,183,171,-1,30,171,31,-1,30,186,171,-1,214,110,109,-1,214,174,110,-1,8,180,179,-1,7,180,8,-1,213,10,177,-1,181,10,213,-1,146,144,143,-1,144,146,140,-1,103,157,163,-1,103,125,157,-1,196,174,176,-1,196,110,174,-1,150,164,197,-1,111,164,150,-1,106,203,175,-1,106,105,203,-1,8,215,117,-1,8,179,215,-1,10,178,172,-1,178,10,181,-1,14,101,15,-1,101,14,83,-1,167,5,94,-1,3,5,167,-1,224,25,214,-1,25,224,26,-1,226,184,182,-1,226,225,184,-1,7,185,180,-1,185,7,34,-1,144,39,36,-1,144,139,39,-1,45,43,46,-1,45,41,43,-1,188,135,148,-1,135,188,53,-1,170,191,147,-1,191,170,50,-1,52,192,50,-1,52,184,192,-1,142,113,128,-1,114,113,142,-1,68,223,193,-1,68,65,223,-1,65,149,223,-1,149,65,67,-1,227,198,208,-1,227,199,198,-1,69,151,65,-1,69,130,151,-1,208,221,227,-1,210,221,208,-1,167,74,73,-1,94,74,167,-1,102,84,126,-1,84,102,83,-1,198,78,209,-1,79,78,198,-1,88,206,201,-1,88,120,206,-1,212,161,162,-1,212,211,161,-1,167,177,3,-1,177,167,76,-1,108,158,137,-1,85,158,108,-1,137,122,165,-1,158,122,137,-1,112,44,46,-1,112,64,44,-1,114,115,96,-1,115,114,142,-1,140,91,20,-1,140,146,91,-1,215,162,117,-1,215,212,162,-1,90,162,161,-1,162,90,118,-1,217,161,211,-1,119,161,217,-1,119,205,120,-1,217,205,119,-1,201,218,207,-1,206,218,201,-1,218,78,219,-1,218,209,78,-1,124,166,159,-1,123,166,124,-1,175,202,77,-1,175,203,202,-1,18,86,19,-1,121,86,18,-1,202,156,219,-1,202,126,156,-1,87,158,81,-1,158,87,122,-1,121,21,153,-1,21,121,18,-1,216,75,220,-1,216,129,75,-1,221,216,220,-1,221,210,216,-1,199,200,222,-1,200,199,227,-1,195,223,149,-1,195,222,223,-1,58,151,60,-1,57,151,58,-1,71,227,221,-1,200,227,71,-1,66,17,67,-1,66,59,17,-1,128,132,69,-1,113,132,128,-1,109,224,214,-1,109,187,224,-1,184,189,192,-1,189,184,225,-1,136,191,49,-1,136,147,191,-1,133,12,134,-1,133,173,12,-1,224,226,26,-1,225,226,224,-1,31,28,30,-1,31,138,28,-1,185,32,183,-1,34,32,185,-1,186,182,171,-1,186,226,182,-1,146,118,91,-1,116,118,146,-1,181,215,179,-1,181,213,215,-1,105,157,203,-1,105,163,157,-1,197,110,196,-1,164,110,197,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc6disc_Coord_9_74_point_1()
		{
			double[] value = {-.27147,52.80947,-1.40805,-.24473,52.79464,-1.41642,-.25321,52.76124,-1.36298,-.16048,52.67988,-.93298,-.1654,52.69153,-.93699,-.17855,52.67758,-.94078,.27045,52.76175,-.96456,.17122,52.7507,-.94317,.16214,52.72752,-.91763,-.17122,52.72229,-.95949,-.07389,52.70771,-.91907,-.27045,52.74179,-.97967,-.33291,52.74515,-1.00047,-.2699,52.7048,-.9684,.31128,52.807,-1.33049,.32661,52.84766,-1.37257,.36135,52.849,-1.30352,-.28224,52.78412,-1.34706,.39066,52.72523,-1.15698,.41458,52.74423,-1.15603,.36461,52.67932,-1.08374,.33947,52.68457,-1.15789,.30729,52.8757,-1.35656,.2447,52.85262,-1.40224,.23878,52.87155,-1.36478,.0969,52.83368,-1.39738,.0981,52.85157,-1.36632,.17002,52.86027,-1.37386,.30503,52.8839,-1.2742,.28024,52.8778,-1.32285,.24698,52.88368,-1.27728,.26615,52.86648,-1.17293,.17619,52.84033,-1.08684,.2647,52.83911,-1.08838,.18186,52.80149,-1.00087,.2577,52.79293,-1.01162,.31659,52.79104,-1.00906,.31179,52.82374,-1.09874,.33666,52.82475,-1.1008,.36529,52.77332,-1.02797,.40323,52.77201,-1.08038,-.30503,52.8839,-1.27478,-.28024,52.8778,-1.32339,-.35234,52.88579,-1.27017,-.37595,52.82536,-1.12085,-.31409,52.86711,-1.18634,-.36461,52.87123,-1.19426,-.31179,52.8228,-1.1,-.26615,52.86648,-1.17345,-.2647,52.83587,-1.09013,-.10115,52.82434,-1.0874,0.0,52.79688,-1.00902,0.0,52.8216,-1.08824,-.17002,52.86027,-1.37421,-.17296,52.8456,-1.3975,-.25143,52.86006,-1.39622,-.33666,52.82456,-1.1017,-.32483,52.79445,-1.29601,-.3438,52.8199,-1.29856,-.31128,52.807,-1.33116,-.37622,52.82614,-1.25821,-.36135,52.849,-1.30424,-.38594,52.81652,-1.21456,-.37788,52.79504,-1.18573,-.4077,52.8228,-1.16312,-.28823,52.71709,-1.25174,-.29695,52.76561,-1.29689,-.2676,52.73756,-1.30817,-.28161,52.69451,-1.1853,-.3193,52.69794,-1.18591,-.20491,52.67099,-1.1013,-.13192,52.66371,-1.10428,-.12692,52.65989,-1.04131,-.12785,52.65449,-1.00485,-.21469,52.65822,-1.06142,-.06038,52.65337,-.99223,-.06888,52.64606,-.92627,.06835,52.72473,-1.34997,.06265,52.72182,-1.34509,0.0,52.71562,-1.35581,.35917,52.76121,-1.21226,.38594,52.81652,-1.21377,.37788,52.79504,-1.18493,.29039,52.80847,-1.36807,.28224,52.78412,-1.34642,.4077,52.8228,-1.1623,.3837,52.75529,-1.19102,.37622,52.82614,-1.25744,.20491,52.68096,-1.09624,.26683,52.6794,-1.0893,.21469,52.67308,-1.05382,.29022,52.65895,-1.02315,-.27252,52.69199,-.97483,-.286,52.65798,-1.01913,-.21552,52.63621,-.97288,.41681,52.77488,-1.15011,-.39879,52.76581,-1.06682,-.41681,52.77488,-1.15101,-.41397,52.74506,-1.1535,-.38685,52.85808,-1.25449};
			return value;
		}
		private double[] getc6disc_Coord_9_74_point_2()
		{
			double[] value = {-.29777,52.86134,-1.34574,.29854,52.83283,-1.38974,.27147,52.80947,-1.40746,.24353,52.81118,-1.42062,.17472,52.84111,-1.39853,.15513,52.79014,-1.40567,.08946,52.77429,-1.42167,-.24468,52.81109,-1.42062,.37806,52.82519,-1.1229,-.09676,52.83165,-1.39839,-.08946,52.77429,-1.42188,-.18613,52.79913,-1.41083,-.40131,52.85935,-1.21238,-.39066,52.72523,-1.15793,-.39067,52.71082,-1.12273,-.36146,52.71789,-1.00283,.25927,52.71003,-.94796,.16451,52.71117,-.91545,.24224,52.66225,-.96696,.12692,52.67635,-1.03649,.13192,52.67414,-1.10227,.37296,52.74573,-1.19002,.38685,52.85808,-1.25375,.32483,52.79445,-1.2953,.29695,52.76561,-1.2962,.24473,52.79464,-1.41588,.25321,52.76124,-1.36239,-.26683,52.67295,-1.09557,-.33947,52.68457,-1.16003,0.0,52.65534,-.99386,-.35917,52.76121,-1.21307,-.3837,52.75529,-1.19189,-.36856,52.74181,-1.19047,-.36529,52.77078,-1.03193,-.31659,52.78304,-1.0166,-.23878,52.87155,-1.36525,-.2577,52.77822,-1.02084,.37115,52.86911,-1.19679,.31409,52.86711,-1.18574,.35572,52.75203,-1.01231,.33969,52.73434,-1.0082,-.2878,52.81178,-1.34655,-.3699,52.67798,-1.08274,.26379,52.72272,-.9514,.33393,52.74802,-.9995,-.33966,52.73535,-.99832,.27112,52.70966,-.96095,-.18186,52.78044,-1.00921,-.24698,52.88368,-1.27775,-.25171,52.73465,-1.31255,-.19246,52.78303,-1.40481,-.33828,52.77525,-1.25309,0.0,52.66082,-.92412,.3193,52.69794,-1.18406,.3438,52.8199,-1.29784,.2676,52.73756,-1.30753,.25171,52.73465,-1.31194,.19231,52.78375,-1.40418,.39921,52.85349,-1.21191,.28823,52.71709,-1.25086,.28161,52.69453,-1.18241,.12785,52.6744,-.9967,.15082,52.66938,-.92238,.18603,52.79993,-1.41021,-.15526,52.79018,-1.40603,.34817,52.888,-1.27289,.33828,52.77525,-1.25233,-.14739,52.63195,-.94005,-.06265,52.72182,-1.34526,-.06835,52.72473,-1.35014,-.11051,52.78622,-1.01243,.1696,52.85289,-1.16799,-.09362,52.73132,-.95159,-.34504,52.74702,-1.00638,0.0,52.76106,-1.42949,.09129,52.75868,-1.41528,0.0,52.74594,-1.42393,-.07374,52.69276,-.91492,0.0,52.74744,-.95439,.0739,52.72581,-.90697,.09362,52.75207,-.93943,0.0,52.71802,-.91953,.09585,52.8499,-1.16385,.10115,52.83219,-1.08773,0.0,52.84624,-1.1629,.11051,52.80295,-1.00741,.16547,52.87669,-1.2731,-.0981,52.85157,-1.36653,-.16547,52.87669,-1.27343,-.09277,52.86159,-1.26298,-.1696,52.85241,-1.16925,-.17619,52.83231,-1.08822,-.09585,52.84872,-1.16508,-.21205,52.68817,-1.18302,-.15704,52.74171,-1.34853,-.15415,52.73052,-1.32584,-.09129,52.75868,-1.41549,-.15804,52.77347,-1.39959,0.0,52.69713,-1.29402,-.06537,52.7011,-1.28807};
			return value;
		}
		private double[] getc6disc_Coord_9_74_point_3()
		{
			double[] value = {-.13209,52.67942,-1.19483,.21205,52.68942,-1.1789,.15704,52.74171,-1.34815,.15804,52.77347,-1.39922,.06595,52.67792,-1.20079,.06485,52.66979,-1.1148,.13209,52.68109,-1.19145,.23549,52.71056,-1.26502,0.0,52.67337,-1.20996,.06537,52.7011,-1.28722,0.0,52.66415,-1.12529,.06038,52.6648,-.98719,.06902,52.66256,-.91622,0.0,52.70479,-.91477,0.0,52.82301,-1.40251,.07378,52.71129,-.90287,0.0,52.66252,-1.05684,.06515,52.67278,-1.04888,.14827,52.70775,-1.27805,.15415,52.73052,-1.32543,-.06515,52.66358,-1.05035,-.06485,52.66405,-1.1153,-.14827,52.70775,-1.2795,-.23549,52.71056,-1.26616,0.0,52.84945,-1.36333,0.0,52.85933,-1.25723,.09277,52.86159,-1.26279,-.06595,52.67679,-1.2027};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc7_Geo_8_79_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,22,21,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,0,43,44,-1,1,0,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,53,25,-1,76,43,0,-1,77,78,70,-1,79,80,81,-1,82,78,77,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,105,108,-1,86,96,101,-1,109,110,111,-1,88,87,112,-1,113,114,115,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,127,-1,128,129,130,-1,130,131,132,-1,124,133,114,-1,134,135,121,-1,92,136,93,-1,137,138,139,-1,140,119,141,-1,142,143,144,-1,145,146,9,-1,147,148,149,-1,14,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,146,162,-1,163,156,164,-1,165,145,9,-1,166,167,168,-1,169,170,171,-1,172,173,174,-1,175,176,22,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,183,-1,154,188,189,-1,154,190,191,-1,192,114,113,-1,115,193,113,-1,194,195,196,-1,187,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,102,209,-1,210,95,211,-1,66,212,67,-1,213,214,215,-1,216,106,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,227,228,229,-1,230,231,232,-1,233,234,235,-1,236,237,238,-1,239,240,241,-1,242,243,8,-1,244,245,246,-1,247,248,249,-1,250,251,252,-1,253,254,211,-1,255,256,257,-1,258,259,260,-1,261,262,263,-1,8,7,261,-1,264,265,266,-1,267,268,269,-1,97,270,271,-1,210,96,95,-1,272,273,274,-1,275,276,277,-1,236,238,278,-1,238,279,278,-1,6,280,281,-1,265,282,283,-1,284,263,285,-1,267,286,285,-1,287,288,289,-1,287,290,288,-1,291,292,293,-1,294,295,42,-1,296,297,298,-1,299,300,301,-1,302,303,304,-1,305,306,307,-1,276,308,309,-1,180,310,186,-1,186,183,311,-1,188,312,126,-1,193,313,202,-1,192,314,315,-1,125,127,313,-1,170,316,300,-1,74,118,72,-1,221,182,317,-1,318,319,320,-1,321,131,130,-1,322,323,324,-1,325,323,322,-1,326,327,328,-1,329,326,330,-1,331,332,59,-1,333,334,332,-1,335,336,337,-1,338,339,340,-1,339,341,342,-1,343,344,345,-1,346,347,348,-1,349,350,351,-1,348,352,353,-1,354,353,355,-1,356,357,358,-1,359,360,361,-1,362,176,363,-1,22,364,23,-1,365,366,367,-1,159,368,160,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,380,388,-1,389,390,391,-1,392,393,5,-1,394,47,395,-1,396,397,398,-1,399,210,400,-1,249,401,254,-1,402,249,403,-1,404,403,405,-1,406,55,407,-1,407,55,54,-1,408,409,410,-1,411,409,62,-1,409,412,413,-1,414,415,416,-1,417,418,416,-1,417,419,420,-1,420,421,417,-1,422,423,424,-1,425,426,427,-1,166,428,424,-1,429,430,156,-1,431,432,433,-1,1,434,2,-1,435,436,437,-1,438,212,66,-1,439,440,441,-1,442,443,78,-1,444,32,445,-1,446,447,448,-1,449,20,19,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,467,85,468,-1,469,470,471,-1,472,473,373,-1,474,475,476,-1,476,477,478,-1,479,480,477,-1,245,218,481,-1,229,228,482,-1,483,484,485,-1,486,487,488,-1,489,392,490,-1,491,492,493,-1,494,495,496,-1,497,498,499,-1,500,501,502,-1,503,504,505,-1,506,507,508,-1,507,506,509,-1,510,511,512,-1,513,514,515,-1,516,517,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,528,529,530,-1,528,530,487,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,547,548,-1,549,550,547,-1,551,552,553,-1,554,555,556,-1,557,558,559,-1,486,488,560,-1,561,562,563,-1,512,537,564,-1,565,566,567,-1,568,560,488,-1,569,570,558,-1,571,572,573,-1,570,569,574,-1,572,571,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,588,589,590,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_2()
		{
			int[] value = {591,592,593,-1,594,595,596,-1,597,593,587,-1,598,599,600,-1,601,602,603,-1,604,605,606,-1,607,563,608,-1,609,610,611,-1,612,613,614,-1,615,616,617,-1,618,619,620,-1,621,622,623,-1,612,614,599,-1,624,611,625,-1,626,627,628,-1,593,629,591,-1,609,615,630,-1,631,632,633,-1,634,635,636,-1,637,638,639,-1,640,641,497,-1,574,642,568,-1,643,644,645,-1,646,647,631,-1,648,649,650,-1,651,496,652,-1,653,654,655,-1,656,657,658,-1,659,509,506,-1,660,661,662,-1,663,662,664,-1,665,666,667,-1,668,667,666,-1,666,669,668,-1,670,671,672,-1,673,671,670,-1,674,599,614,-1,674,675,676,-1,677,678,679,-1,680,681,669,-1,682,683,684,-1,685,686,687,-1,688,565,689,-1,690,691,692,-1,691,685,693,-1,694,695,592,-1,696,697,698,-1,553,699,700,-1,518,701,516,-1,702,703,704,-1,705,219,706,-1,707,708,709,-1,710,711,709,-1,595,710,708,-1,712,713,714,-1,715,716,595,-1,617,717,718,-1,719,720,721,-1,722,723,724,-1,725,726,727,-1,491,493,728,-1,729,730,244,-1,731,732,733,-1,734,697,735,-1,736,737,722,-1,738,739,740,-1,741,742,738,-1,734,743,585,-1,744,745,746,-1,575,747,748,-1,749,688,689,-1,750,492,751,-1,752,739,753,-1,754,755,737,-1,754,756,757,-1,758,759,760,-1,761,762,758,-1,763,764,765,-1,527,766,767,-1,765,768,769,-1,770,683,771,-1,566,772,773,-1,774,775,688,-1,668,776,663,-1,667,668,663,-1,686,685,777,-1,614,613,778,-1,676,675,779,-1,780,561,563,-1,781,782,711,-1,623,622,783,-1,784,785,637,-1,786,787,788,-1,789,786,790,-1,548,791,792,-1,793,794,791,-1,795,796,797,-1,338,340,798,-1,799,798,800,-1,801,800,344,-1,802,803,804,-1,805,802,806,-1,807,806,808,-1,809,810,808,-1,640,811,812,-1,813,814,809,-1,815,816,813,-1,817,818,819,-1,820,818,506,-1,508,821,822,-1,643,823,824,-1,825,826,827,-1,828,829,830,-1,831,832,833,-1,834,835,836,-1,837,838,839,-1,840,841,842,-1,843,834,844,-1,845,846,847,-1,489,393,392,-1,848,849,850,-1,851,852,847,-1,535,853,854,-1,855,856,857,-1,523,856,858,-1,859,696,860,-1,524,523,861,-1,862,731,733,-1,863,862,864,-1,865,866,867,-1,743,868,869,-1,870,528,486,-1,410,871,408,-1,872,871,873,-1,874,416,415,-1,416,874,875,-1,876,420,419,-1,877,423,420,-1,878,879,880,-1,878,504,881,-1,882,883,432,-1,884,881,504,-1,870,885,699,-1,560,886,887,-1,569,642,574,-1,517,888,889,-1,890,891,892,-1,504,503,893,-1,894,895,896,-1,897,898,899,-1,556,900,901,-1,902,903,904,-1,905,906,907,-1,908,909,589,-1,910,576,909,-1,911,912,913,-1,829,914,915,-1,916,917,918,-1,919,920,916,-1,920,921,922,-1,923,924,706,-1,925,923,706,-1,634,484,926,-1,927,651,928,-1,708,596,595,-1,929,921,567,-1,922,930,931,-1,918,932,916,-1,915,914,933,-1,934,931,930,-1,935,641,640,-1,936,501,500,-1,937,590,909,-1,904,938,555,-1,939,940,941,-1,942,943,892,-1,944,892,945,-1,573,572,946,-1,945,947,516,-1,948,571,701,-1,642,886,560,-1,744,743,869,-1,699,553,949,-1,950,951,952,-1,504,878,880,-1,881,654,878,-1,953,954,653,-1,875,874,788,-1,546,871,872,-1,955,549,873,-1,585,743,744,-1,956,660,957,-1,594,702,595,-1,865,863,866,-1,866,958,867,-1,864,959,866,-1,731,861,523,-1,960,695,694,-1,961,962,963,-1,964,535,534,-1,965,847,849,-1,966,967,844,-1,846,850,849,-1,846,968,850,-1,845,843,969,-1,845,852,970,-1,971,972,841,-1,837,971,840,-1,834,836,966,-1,834,843,838,-1,839,838,843,-1,973,974,975,-1,973,704,976,-1,565,977,689,-1,829,828,978,-1,539,564,537,-1,643,645,826,-1,645,644,680,-1,822,821,979,-1,632,817,980,-1,656,981,819,-1,982,814,981,-1,983,812,811,-1,809,814,982,-1,807,896,984,-1,985,986,815,-1,987,988,989,-1,990,991,992,-1,990,992,804,-1,993,804,803,-1,994,995,796,-1,797,637,542,-1,792,791,785,-1,720,764,763,-1,783,671,673,-1,996,997,998,-1,672,783,999,-1,1000,999,1001,-1,1002,779,675,-1,1003,667,997,-1,668,669,681,-1,690,692,1004,-1,561,684,1005,-1,683,682,930,-1,1006,1007,859,-1,768,519,526,-1,526,1006,1008,-1,1007,1006,525,-1,1009,1010,527,-1,1009,1011,1012,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_3()
		{
			int[] value = {765,769,1013,-1,741,1014,521,-1,756,1015,757,-1,750,740,752,-1,739,742,753,-1,1016,1017,794,-1,424,655,431,-1,837,1018,1019,-1,697,734,698,-1,621,1020,1021,-1,1022,1023,1024,-1,1025,751,1026,-1,1019,1027,837,-1,696,859,1007,-1,1028,697,696,-1,1029,858,856,-1,730,729,925,-1,1030,1031,1032,-1,521,766,519,-1,1033,720,1034,-1,664,1035,1036,-1,716,1037,714,-1,1038,711,714,-1,708,710,709,-1,1039,596,1040,-1,517,516,888,-1,1041,1042,719,-1,693,1043,774,-1,774,688,749,-1,773,772,775,-1,770,1044,1045,-1,677,1046,678,-1,1047,1048,1049,-1,1002,1000,779,-1,1050,1051,1000,-1,928,662,663,-1,662,928,951,-1,707,660,956,-1,656,819,657,-1,935,658,905,-1,718,717,1052,-1,1053,1006,1054,-1,1055,1056,926,-1,953,653,655,-1,1057,952,651,-1,1058,1059,833,-1,654,881,1060,-1,1061,646,1062,-1,1063,1064,1065,-1,927,776,681,-1,649,1066,1058,-1,485,634,1047,-1,1062,633,1067,-1,1068,1069,987,-1,495,659,632,-1,627,1070,1071,-1,1072,597,1073,-1,582,1071,576,-1,1074,1075,1076,-1,599,1077,600,-1,659,817,632,-1,999,783,622,-1,616,1013,617,-1,610,609,1078,-1,1074,611,610,-1,563,1079,610,-1,578,629,624,-1,912,1080,913,-1,589,588,1081,-1,909,1071,937,-1,627,1071,582,-1,606,1082,604,-1,606,586,1082,-1,860,587,695,-1,562,1083,563,-1,1084,559,1085,-1,936,1086,555,-1,811,640,1087,-1,1088,503,505,-1,1089,639,1017,-1,1090,594,1091,-1,540,1092,1093,-1,933,914,932,-1,865,545,869,-1,863,868,735,-1,1094,1018,853,-1,985,813,1095,-1,1014,1096,1097,-1,768,526,1008,-1,1098,948,518,-1,513,515,512,-1,657,820,508,-1,1099,509,644,-1,657,822,514,-1,564,978,1100,-1,905,658,906,-1,498,1081,502,-1,1087,640,497,-1,1023,1022,753,-1,965,849,848,-1,1101,9,11,-1,227,107,1102,-1,475,303,479,-1,373,473,1103,-1,1104,465,1105,-1,272,303,273,-1,1106,103,469,-1,1107,461,17,-1,1107,1108,461,-1,1108,1109,459,-1,1110,1111,447,-1,447,1111,79,-1,1112,81,80,-1,213,1113,17,-1,1114,1115,1116,-1,1117,443,76,-1,1118,270,1119,-1,1120,67,437,-1,449,164,430,-1,157,1121,155,-1,157,163,1122,-1,1123,427,19,-1,427,167,1124,-1,168,426,1125,-1,417,1126,327,-1,418,327,329,-1,1127,62,409,-1,62,61,1128,-1,1129,1130,443,-1,97,1131,1119,-1,1132,1133,1134,-1,404,407,1135,-1,1136,1137,402,-1,249,248,38,-1,1138,209,210,-1,38,250,1139,-1,1140,1141,1142,-1,1143,49,252,-1,398,397,1144,-1,46,1145,395,-1,387,1146,1147,-1,258,391,1148,-1,259,258,395,-1,260,388,389,-1,381,390,389,-1,386,1149,1150,-1,387,1147,378,-1,379,388,380,-1,389,388,382,-1,975,974,1151,-1,1152,216,1153,-1,373,275,1154,-1,1155,52,51,-1,53,75,51,-1,1156,158,370,-1,197,1157,158,-1,365,29,28,-1,363,176,144,-1,362,357,173,-1,361,1158,358,-1,1159,356,358,-1,1158,360,1160,-1,1161,355,353,-1,349,1162,1163,-1,989,1164,1165,-1,346,1162,1166,-1,347,346,1166,-1,1167,347,1168,-1,337,1169,1170,-1,64,323,336,-1,322,331,330,-1,1171,191,1172,-1,129,191,190,-1,181,180,311,-1,1173,321,190,-1,140,232,231,-1,125,1173,189,-1,313,127,1174,-1,188,311,183,-1,310,1157,187,-1,1175,1154,205,-1,74,307,306,-1,199,305,307,-1,399,1176,1177,-1,299,36,35,-1,1178,36,299,-1,1177,40,1178,-1,40,1176,1179,-1,1180,1181,1182,-1,41,1183,294,-1,1184,294,1180,-1,293,1185,291,-1,1186,1187,292,-1,1188,1189,290,-1,1190,1191,34,-1,267,269,286,-1,283,1192,281,-1,265,1193,282,-1,333,1194,334,-1,431,166,424,-1,1195,1196,383,-1,95,271,211,-1,1197,1198,131,-1,1199,1200,264,-1,1201,1202,6,-1,261,1203,262,-1,383,1204,1195,-1,399,400,1205,-1,400,211,254,-1,1206,1207,1202,-1,1202,1201,1206,-1,36,295,34,-1,234,233,1172,-1,181,1208,317,-1,1209,1210,223,-1,223,222,318,-1,221,1210,1102,-1,1146,1145,5,-1,203,202,1211,-1,277,276,309,-1,199,308,1212,-1,305,199,201,-1,1156,1213,197,-1,194,145,165,-1,1049,1214,147,-1,113,193,204,-1,127,1215,1174,-1,126,312,1215,-1,180,178,1216,-1,1217,1216,178,-1,177,179,1218,-1,172,362,173,-1,1219,174,1220,-1,170,1221,230,-1,316,301,300,-1,483,1222,1223,-1,166,433,167,-1,166,168,1125,-1,165,1101,1224,-1,163,164,1225,-1,1226,1227,1228,-1,1229,1230,142,-1,1228,1064,1226,-1,10,1157,310,-1,163,157,156,-1,412,409,408,-1,433,166,431,-1,350,143,1230,-1,1165,351,1226,-1,161,144,175,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_4()
		{
			int[] value = {87,86,1231,-1,1232,85,94,-1,134,1233,135,-1,114,1234,125,-1,131,321,1173,-1,231,1185,1235,-1,1236,117,141,-1,1236,121,135,-1,1236,1237,72,-1,1238,1239,83,-1,469,103,470,-1,1240,1241,466,-1,100,85,467,-1,137,94,99,-1,209,96,210,-1,72,1242,73,-1,430,1243,449,-1,33,444,1130,-1,1109,1108,1107,-1,458,1244,1245,-1,1159,1246,1247,-1,66,68,1119,-1,106,105,217,-1,1093,1248,1249,-1,1118,56,55,-1,55,406,1118,-1,253,405,403,-1,397,1250,1251,-1,359,1252,1163,-1,1253,268,1254,-1,301,1178,299,-1,31,445,32,-1,25,30,26,-1,367,23,172,-1,1255,1256,24,-1,365,172,1219,-1,1257,1154,75,-1,463,1219,464,-1,16,15,1240,-1,14,151,1247,-1,1200,1258,265,-1,394,1148,1259,-1,265,264,1200,-1,61,60,332,-1,16,1240,13,-1,1161,1260,355,-1,1257,374,1154,-1,362,172,364,-1,29,365,1219,-1,367,172,365,-1,25,1261,30,-1,31,1116,445,-1,1253,1254,34,-1,267,1192,1262,-1,56,1263,104,-1,1264,1265,481,-1,1250,1196,1251,-1,253,1266,405,-1,1104,473,465,-1,1249,1267,1093,-1,1263,105,104,-1,1194,1268,1269,-1,18,20,1270,-1,1247,151,1159,-1,1107,1271,1109,-1,33,1130,1129,-1,164,156,430,-1,430,69,1243,-1,1237,135,1272,-1,43,76,1273,-1,89,91,474,-1,137,99,1274,-1,100,99,85,-1,466,150,1240,-1,83,134,1238,-1,133,124,93,-1,1272,122,1242,-1,72,117,1236,-1,135,1237,1236,-1,1236,141,119,-1,116,169,171,-1,1173,1197,131,-1,125,115,114,-1,144,176,175,-1,1275,1234,114,-1,1233,123,135,-1,85,99,94,-1,86,1276,1231,-1,99,98,1274,-1,175,1277,161,-1,351,1227,1226,-1,143,142,1230,-1,147,149,485,-1,155,429,156,-1,310,11,10,-1,1064,1063,1226,-1,142,162,1229,-1,1278,1124,167,-1,1121,1279,155,-1,1224,1280,165,-1,1125,428,166,-1,433,1278,167,-1,1281,483,1223,-1,377,1282,1121,-1,316,1177,301,-1,170,300,1221,-1,1220,464,1219,-1,1218,1132,177,-1,188,126,189,-1,127,126,1215,-1,204,314,113,-1,1049,147,485,-1,194,165,195,-1,1156,197,158,-1,305,201,304,-1,199,1212,200,-1,1211,277,309,-1,1211,309,203,-1,235,1207,1206,-1,444,33,32,-1,318,224,223,-1,223,226,1209,-1,229,217,227,-1,238,1283,284,-1,181,317,182,-1,128,191,129,-1,1172,1284,234,-1,295,1253,34,-1,243,1206,1201,-1,1285,246,245,-1,254,1205,400,-1,1205,1176,399,-1,1192,283,282,-1,1198,132,131,-1,1235,1286,140,-1,327,326,329,-1,265,1258,1193,-1,1192,1287,281,-1,1288,269,287,-1,1190,34,1254,-1,239,1188,290,-1,1185,1289,291,-1,1180,1290,1184,-1,42,41,294,-1,1180,1182,1291,-1,40,1177,1176,-1,1178,301,1177,-1,291,299,35,-1,399,1177,316,-1,303,272,304,-1,306,1292,74,-1,1175,205,1293,-1,187,186,310,-1,183,1294,188,-1,313,1174,1295,-1,125,189,126,-1,1173,190,189,-1,181,311,153,-1,190,321,129,-1,65,1249,1248,-1,335,64,336,-1,337,1296,1169,-1,1166,1297,347,-1,353,352,18,-1,346,1298,1162,-1,989,1299,1164,-1,354,360,1300,-1,1158,361,360,-1,454,1159,358,-1,358,357,361,-1,361,357,1252,-1,1301,1252,362,-1,28,1302,365,-1,367,366,21,-1,1157,1255,158,-1,158,160,370,-1,53,1261,25,-1,1155,51,1175,-1,1154,374,373,-1,275,1303,1304,-1,1152,1153,1305,-1,975,1151,1305,-1,382,381,389,-1,379,382,388,-1,378,380,387,-1,386,1150,383,-1,386,385,1149,-1,381,1306,390,-1,389,258,260,-1,258,1148,395,-1,387,1307,1146,-1,46,395,47,-1,1148,391,1259,-1,50,398,1144,-1,1140,1142,1308,-1,1138,210,1309,-1,38,401,249,-1,404,1136,402,-1,1135,1136,404,-1,404,405,406,-1,227,217,105,-1,1134,177,1132,-1,1119,270,97,-1,411,62,1128,-1,409,57,1127,-1,418,329,414,-1,417,327,418,-1,18,1123,19,-1,157,1122,1310,-1,436,1120,437,-1,1118,1119,68,-1,76,439,1117,-1,1116,31,1114,-1,214,213,17,-1,475,474,1311,-1,1312,447,79,-1,1260,1112,355,-1,447,446,1110,-1,1109,1313,459,-1,467,1314,100,-1,17,16,1107,-1,151,150,1220,-1,303,1311,273,-1,465,473,472,-1,476,1104,474,-1,475,1311,303,-1,179,178,182,-1,11,1216,1101,-1,1023,753,742,-1,793,550,549,-1,498,502,501,-1,896,1315,984,-1,978,828,1100,-1,818,657,819,-1,658,657,514,-1,822,657,508,-1,512,511,513,-1,518,517,1098,-1,521,1014,1097,-1,1316,740,757,-1,1090,1091,544,-1,924,923,1317,-1,1018,854,853,-1,735,862,863,-1,545,544,869,-1,540,1093,1267,-1,702,594,703,-1,744,551,700,-1,1087,1318,811,-1,941,1319,556,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_5()
		{
			int[] value = {936,555,554,-1,1085,649,648,-1,1085,893,1084,-1,1320,1074,1079,-1,1321,568,530,-1,918,580,579,-1,627,582,628,-1,909,576,1071,-1,1081,641,589,-1,624,625,578,-1,583,612,598,-1,1083,613,1320,-1,610,608,563,-1,610,1079,1074,-1,1078,608,610,-1,1322,1323,1324,-1,622,1021,999,-1,1074,1076,625,-1,582,576,1325,-1,1072,1073,605,-1,495,632,631,-1,1326,1068,987,-1,1327,1062,1067,-1,431,655,882,-1,408,871,1328,-1,649,1329,650,-1,927,681,494,-1,1326,1063,1065,-1,1062,1327,1061,-1,1065,1068,1326,-1,884,648,650,-1,651,1046,1057,-1,953,655,1330,-1,1055,926,1331,-1,833,950,831,-1,1053,1008,1006,-1,717,1053,1052,-1,935,1332,658,-1,707,661,660,-1,672,1000,1003,-1,1002,1050,1000,-1,1049,485,1047,-1,1046,652,678,-1,683,770,1045,-1,773,775,1044,-1,774,749,693,-1,693,685,1043,-1,1031,1041,719,-1,1031,1333,1041,-1,489,1334,967,-1,596,956,1040,-1,714,713,1038,-1,716,714,710,-1,595,702,715,-1,737,1335,722,-1,664,1036,998,-1,619,673,620,-1,1033,721,720,-1,521,1097,766,-1,493,1030,1032,-1,1030,1333,1031,-1,1029,1336,858,-1,696,1337,1028,-1,1007,1337,696,-1,739,752,740,-1,493,492,1338,-1,1021,622,621,-1,615,618,616,-1,790,786,788,-1,739,738,742,-1,750,1339,740,-1,758,1015,759,-1,521,1340,741,-1,764,1341,1342,-1,765,1013,763,-1,1009,767,1011,-1,1009,1343,1010,-1,525,1344,1007,-1,526,525,1006,-1,859,1054,1006,-1,1005,1045,1044,-1,561,780,684,-1,692,978,1004,-1,681,776,668,-1,1003,1345,667,-1,675,777,1002,-1,1000,672,999,-1,617,630,615,-1,672,671,783,-1,997,663,998,-1,673,619,783,-1,1033,673,1346,-1,720,763,1034,-1,1092,540,1347,-1,797,542,541,-1,796,795,994,-1,804,1348,990,-1,505,805,807,-1,990,986,991,-1,988,1299,989,-1,806,809,808,-1,982,810,809,-1,983,811,898,-1,981,983,982,-1,813,981,814,-1,819,813,816,-1,822,979,514,-1,507,1349,508,-1,644,681,680,-1,826,1350,643,-1,512,515,537,-1,978,689,829,-1,973,1351,704,-1,973,1352,974,-1,843,845,839,-1,834,838,1353,-1,966,844,834,-1,971,841,840,-1,845,970,839,-1,845,969,846,-1,849,847,846,-1,967,1354,844,-1,964,853,535,-1,855,1355,1356,-1,961,1357,962,-1,1358,856,523,-1,960,860,695,-1,523,858,731,-1,864,1359,959,-1,866,959,958,-1,957,1040,956,-1,744,746,585,-1,642,1360,1361,-1,549,872,873,-1,546,872,547,-1,788,1362,875,-1,504,880,505,-1,1058,833,1329,-1,1085,648,893,-1,950,1363,951,-1,699,949,1364,-1,551,744,869,-1,560,568,642,-1,701,518,948,-1,945,516,701,-1,931,918,917,-1,1365,944,945,-1,896,946,1315,-1,942,892,944,-1,556,939,941,-1,904,555,1086,-1,902,1086,936,-1,500,902,936,-1,913,1080,591,-1,934,930,682,-1,908,933,932,-1,1366,914,829,-1,922,931,917,-1,566,929,567,-1,664,662,661,-1,927,496,651,-1,634,485,484,-1,1367,1368,715,-1,706,730,925,-1,922,917,920,-1,916,1366,919,-1,916,920,917,-1,911,913,1369,-1,908,589,933,-1,915,905,907,-1,1318,1087,499,-1,590,589,909,-1,1086,902,904,-1,556,901,939,-1,898,1370,899,-1,894,1371,895,-1,890,892,943,-1,889,1098,517,-1,560,887,1372,-1,699,1364,870,-1,486,528,487,-1,882,432,431,-1,649,1085,1066,-1,424,1330,655,-1,878,954,879,-1,877,420,876,-1,876,419,875,-1,875,419,416,-1,874,415,1373,-1,1374,789,1328,-1,870,1375,528,-1,543,545,867,-1,867,545,865,-1,863,864,866,-1,862,733,864,-1,1028,861,731,-1,860,960,859,-1,535,854,1376,-1,851,847,965,-1,848,850,1377,-1,1334,1354,967,-1,847,852,845,-1,969,843,844,-1,1018,1094,1019,-1,837,839,971,-1,834,1353,835,-1,840,1018,837,-1,831,1378,832,-1,977,829,689,-1,825,1350,826,-1,824,507,1099,-1,508,1349,821,-1,818,817,506,-1,819,980,817,-1,819,981,813,-1,815,813,985,-1,809,1095,813,-1,983,981,812,-1,896,807,808,-1,807,805,806,-1,988,986,990,-1,802,804,992,-1,344,343,801,-1,1379,799,800,-1,798,1380,338,-1,797,541,795,-1,793,1016,794,-1,548,793,791,-1,789,792,786,-1,786,784,787,-1,637,797,784,-1,638,637,785,-1,783,619,623,-1,781,711,1038,-1,1035,664,709,-1,563,607,780,-1,1053,1054,1052,-1,779,1001,676,-1,778,1381,614,-1,777,675,686,-1,663,997,667,-1,1382,666,665,-1,775,772,688,-1,773,929,566,-1,1005,684,1045,-1,683,930,771,-1,1008,1053,768,-1,767,1009,527,-1,1383,520,765,-1,760,761,758,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_6()
		{
			int[] value = {740,1316,738,-1,753,1384,752,-1,750,1338,492,-1,698,587,860,-1,734,585,698,-1,1015,1096,757,-1,1022,1024,1041,-1,1026,1385,491,-1,755,1025,1026,-1,969,968,846,-1,257,1386,1387,-1,697,1028,735,-1,855,1029,856,-1,1388,729,244,-1,493,1032,728,-1,725,1389,726,-1,721,1031,719,-1,719,1042,720,-1,602,618,615,-1,718,630,617,-1,715,1368,716,-1,714,1037,712,-1,595,716,710,-1,710,714,711,-1,705,220,219,-1,704,1390,702,-1,699,1391,700,-1,860,696,698,-1,694,592,1392,-1,691,777,685,-1,690,1393,691,-1,687,1043,685,-1,770,773,1044,-1,683,1045,684,-1,669,1394,680,-1,679,636,677,-1,674,686,675,-1,674,614,1381,-1,673,670,1346,-1,672,1003,670,-1,666,1394,669,-1,665,667,1345,-1,664,998,663,-1,662,1395,660,-1,506,817,659,-1,658,1332,656,-1,1322,718,1323,-1,718,1052,1323,-1,1329,833,832,-1,651,652,1046,-1,1059,1396,833,-1,881,884,650,-1,631,1062,646,-1,1329,649,1058,-1,819,816,980,-1,637,639,542,-1,634,636,1047,-1,496,647,652,-1,633,1062,631,-1,630,1078,609,-1,593,597,629,-1,626,1397,627,-1,1398,910,581,-1,611,1074,625,-1,599,598,612,-1,621,623,1399,-1,618,623,619,-1,779,1000,1001,-1,612,1075,613,-1,611,1400,609,-1,607,608,1324,-1,676,599,674,-1,604,1401,605,-1,601,1399,602,-1,597,587,1073,-1,1039,594,596,-1,703,594,1090,-1,591,1080,592,-1,937,1071,1070,-1,585,587,698,-1,584,628,582,-1,581,910,579,-1,606,605,1073,-1,578,1325,576,-1,570,574,1402,-1,573,1365,571,-1,557,569,558,-1,488,530,568,-1,567,977,565,-1,486,560,1372,-1,889,557,559,-1,551,553,700,-1,1347,542,1403,-1,547,872,549,-1,548,1374,546,-1,543,1090,544,-1,542,1347,540,-1,930,922,771,-1,1404,1405,1406,-1,535,1355,536,-1,533,1377,531,-1,530,488,487,-1,525,527,1010,-1,524,1344,522,-1,514,979,515,-1,509,1099,507,-1,508,820,506,-1,657,818,820,-1,1315,1088,984,-1,748,747,1084,-1,499,1087,497,-1,556,1319,554,-1,496,927,494,-1,491,1385,492,-1,392,4,490,-1,483,485,149,-1,477,475,479,-1,478,1103,476,-1,475,477,476,-1,274,469,471,-1,465,467,1105,-1,462,464,472,-1,12,1247,1246,-1,467,466,1314,-1,459,461,1108,-1,1407,456,458,-1,453,1408,454,-1,452,355,450,-1,446,448,1409,-1,445,71,444,-1,441,1117,439,-1,66,1119,438,-1,437,215,435,-1,19,1124,1225,-1,432,1410,433,-1,1124,19,427,-1,1123,425,427,-1,422,424,428,-1,416,419,417,-1,414,416,418,-1,1118,1266,270,-1,407,404,406,-1,404,402,403,-1,402,1411,249,-1,401,38,37,-1,399,1309,210,-1,248,250,38,-1,1412,250,252,-1,396,1250,397,-1,395,1148,394,-1,1146,1307,1145,-1,389,391,258,-1,387,388,260,-1,1195,1251,1196,-1,1150,381,383,-1,378,1413,379,-1,383,1196,386,-1,377,1121,375,-1,275,373,1303,-1,369,1156,370,-1,24,21,159,-1,365,1302,366,-1,22,176,364,-1,362,364,176,-1,1252,357,362,-1,361,1252,359,-1,356,1159,151,-1,354,1160,360,-1,354,1300,353,-1,353,1300,348,-1,349,351,1162,-1,347,1167,348,-1,345,1414,343,-1,342,345,339,-1,338,1415,339,-1,1416,1417,1418,-1,1416,1296,1417,-1,337,1170,335,-1,331,333,332,-1,330,331,59,-1,329,330,413,-1,328,325,326,-1,325,336,323,-1,321,130,129,-1,318,222,319,-1,74,1292,118,-1,313,115,125,-1,315,122,192,-1,73,1419,74,-1,73,315,1419,-1,313,1295,202,-1,188,1294,312,-1,311,180,186,-1,185,184,1213,-1,276,1212,308,-1,302,304,201,-1,1289,299,291,-1,296,1420,297,-1,294,1184,295,-1,291,35,1421,-1,287,289,1288,-1,1193,1262,1192,-1,283,266,265,-1,281,1203,6,-1,274,471,272,-1,1422,1423,1424,-1,1131,438,1119,-1,271,95,97,-1,1193,1258,1190,-1,1192,282,1193,-1,238,284,1425,-1,253,211,271,-1,1411,1426,249,-1,247,249,1426,-1,244,246,1388,-1,243,1201,8,-1,241,1188,239,-1,235,1206,233,-1,234,1427,235,-1,140,1286,111,-1,230,1221,231,-1,227,1209,228,-1,226,223,224,-1,221,223,1210,-1,221,1102,1218,-1,218,220,1428,-1,216,217,1429,-1,33,1114,31,-1,214,1430,215,-1,212,437,67,-1,211,400,210,-1,208,209,1138,-1,205,207,1293,-1,275,1304,276,-1,204,193,202,-1,187,1157,197,-1,196,1431,194,-1,115,313,193,-1,314,192,113,-1,1171,154,191,-1,154,189,190,-1,185,1294,183,-1,182,178,180,-1,177,1432,178,-1,22,1256,175,-1,1219,172,174,-1,170,230,171,-1,375,1121,157,-1,165,9,1101,-1,1121,1433,1279,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_7()
		{
			int[] value = {163,1225,1124,-1,162,142,161,-1,76,443,442,-1,154,1171,152,-1,363,1301,362,-1,147,196,148,-1,144,161,142,-1,232,140,141,-1,137,1274,138,-1,90,468,1434,-1,136,133,93,-1,134,121,1238,-1,114,192,124,-1,132,1435,130,-1,128,130,1286,-1,231,1235,140,-1,192,122,124,-1,121,1236,119,-1,117,72,118,-1,88,112,1436,-1,111,1435,109,-1,1275,114,133,-1,101,1276,86,-1,107,227,105,-1,101,103,1106,-1,1314,466,1241,-1,96,1437,97,-1,92,94,137,-1,89,468,90,-1,1232,83,85,-1,1424,1115,81,-1,82,442,78,-1,81,1115,79,-1,70,1438,77,-1,0,439,76,-1,69,1438,70,-1,458,1109,1271,-1,67,1439,68,-1,1127,60,62,-1,59,1127,57,-1,56,104,54,-1,302,479,303,-1,1440,1441,1442,-1,49,398,50,-1,47,1443,45,-1,44,434,1,-1,42,1178,40,-1,39,1179,37,-1,30,1261,28,-1,24,1256,22,-1,23,367,21,-1,23,364,172,-1,1161,1270,1260,-1,1243,1423,1422,-1,14,1247,12,-1,1271,1244,458,-1,9,1277,10,-1,8,1201,6,-1,4,392,5,-1,277,1154,275,-1,277,205,1154,-1,368,21,366,-1,368,159,21,-1,27,374,1257,-1,27,372,374,-1,1444,56,1439,-1,56,1444,1263,-1,1298,1163,1162,-1,1298,359,1163,-1,1445,1259,1135,-1,1445,394,1259,-1,1440,1446,1441,-1,1440,1447,1446,-1,396,49,1143,-1,396,398,49,-1,406,1266,1118,-1,1266,406,405,-1,1448,1296,1416,-1,1296,1448,1169,-1,1449,1194,1269,-1,1449,334,1194,-1,1244,1246,1245,-1,1246,1244,12,-1,1409,1313,457,-1,1409,1450,1313,-1,1451,1129,1452,-1,1451,33,1129,-1,69,429,1438,-1,69,430,429,-1,214,1453,1430,-1,460,1453,214,-1,1408,1245,1246,-1,1408,1454,1245,-1,84,1239,1106,-1,1239,84,83,-1,138,1455,1113,-1,138,1274,1455,-1,117,171,141,-1,117,116,171,-1,125,1197,1173,-1,125,1234,1197,-1,1456,109,1457,-1,109,1456,1458,-1,110,1458,112,-1,110,109,1458,-1,133,1198,1275,-1,136,1198,133,-1,112,1459,1436,-1,1458,1459,112,-1,1165,1063,989,-1,1165,1226,1063,-1,1460,1461,1462,-1,1463,1461,1460,-1,1228,1431,1214,-1,1228,1229,1431,-1,1255,159,158,-1,1255,24,159,-1,9,161,1277,-1,9,146,161,-1,1310,1281,1223,-1,1464,1281,1310,-1,377,1224,1282,-1,1280,1224,377,-1,1465,436,435,-1,1465,1134,436,-1,1218,107,1132,-1,107,1218,1102,-1,1432,1217,178,-1,1432,1466,1217,-1,1435,1286,130,-1,1435,111,1286,-1,307,308,199,-1,307,1467,308,-1,202,206,1211,-1,202,1295,206,-1,441,1452,1117,-1,441,1468,1452,-1,77,429,155,-1,77,1438,429,-1,106,54,104,-1,106,1469,54,-1,1429,1428,1470,-1,1429,482,1428,-1,1102,1209,227,-1,1102,1210,1209,-1,1283,237,1471,-1,238,237,1283,-1,319,1208,1472,-1,1208,319,317,-1,1284,191,128,-1,1284,1172,191,-1,1191,35,34,-1,1421,35,1191,-1,1199,1427,1187,-1,1427,1199,1473,-1,279,224,278,-1,279,225,224,-1,266,1207,1473,-1,266,280,1207,-1,1474,1156,369,-1,1213,1156,1474,-1,324,331,322,-1,324,333,331,-1,1475,256,1476,-1,257,256,1475,-1,1288,1477,1478,-1,1288,289,1477,-1,1479,1189,1188,-1,1479,1480,1189,-1,1481,268,1253,-1,1481,269,268,-1,1180,240,1290,-1,1291,240,1180,-1,1291,297,1482,-1,1291,1182,297,-1,39,1183,41,-1,1483,1183,39,-1,1178,295,36,-1,42,295,1178,-1,208,118,470,-1,208,116,118,-1,1484,200,1212,-1,200,1484,1485,-1,1474,1486,1487,-1,1488,1486,1474,-1,1489,243,242,-1,1489,1490,243,-1,293,128,1185,-1,128,293,1284,-1,63,1460,1269,-1,63,1491,1460,-1,1492,1493,1494,-1,1495,1493,1492,-1,1416,341,1448,-1,1416,1496,341,-1,1167,1497,1498,-1,1168,1497,1167,-1,1164,1297,1166,-1,1297,1164,1414,-1,1298,348,1300,-1,348,1298,346,-1,360,1298,1300,-1,359,1298,360,-1,1158,452,455,-1,1160,452,1158,-1,144,1301,363,-1,144,143,1301,-1,174,357,356,-1,174,173,357,-1,1302,1499,1500,-1,1302,28,1499,-1,51,1154,1175,-1,51,75,1154,-1,483,1501,484,-1,1281,1501,483,-1,1151,1152,1305,-1,1151,45,1152,-1,1204,382,379,-1,1204,383,382,-1,1195,1502,1503,-1,1204,1502,1195,-1,1504,1503,1505,-1,1504,1506,1503,-1,1145,259,395,-1,1145,1307,259,-1,1507,391,390,-1,1259,391,1507,-1,385,1508,1441,-1,385,384,1508,-1,1509,1510,1511,-1,1509,1512,1510,-1,49,1509,1513,-1,49,48,1509,-1,1139,1308,1483,-1,1308,1139,1140,-1,1426,1447,1440,-1,1426,1411,1447,-1,1483,38,1139,-1,1483,39,38,-1,434,435,2,-1,434,1465,435,-1,1310,375,157,-1,1310,1223,375,-1,1279,77,155,-1,82,77,1279,-1,441,1453,1514,-1,441,440,1453,-1,1112,450,355,-1,80,450,1112,-1,1241,15,1455,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_8()
		{
			int[] value = {15,1241,1240,-1,1240,14,13,-1,1240,150,14,-1,91,1311,474,-1,273,1311,91,-1,1104,1103,473,-1,1103,1104,476,-1,11,180,1216,-1,11,310,180,-1,978,749,689,-1,978,692,749,-1,507,823,1349,-1,507,824,823,-1,828,510,1100,-1,828,830,510,-1,544,1515,552,-1,1091,1515,544,-1,985,991,986,-1,985,1095,991,-1,965,1516,958,-1,965,848,1516,-1,1517,1406,1405,-1,1517,1518,1406,-1,1355,1376,1356,-1,1355,535,1376,-1,868,865,869,-1,863,865,868,-1,541,1519,795,-1,540,1519,541,-1,548,550,793,-1,550,548,547,-1,1315,575,748,-1,946,575,1315,-1,946,572,575,-1,891,1520,1521,-1,1520,891,890,-1,747,1098,1084,-1,1098,747,948,-1,942,895,1371,-1,895,942,944,-1,577,913,591,-1,1398,913,577,-1,746,586,585,-1,746,1082,586,-1,937,588,590,-1,937,1070,588,-1,613,562,778,-1,562,613,1083,-1,1072,611,624,-1,1072,1400,611,-1,718,1078,630,-1,1322,1078,718,-1,582,1076,583,-1,582,1325,1076,-1,583,1522,584,-1,583,598,1522,-1,1020,598,600,-1,598,1020,1522,-1,1523,1401,604,-1,1401,1523,1524,-1,1069,1327,1067,-1,1068,1327,1069,-1,1092,1525,1093,-1,1092,1526,1525,-1,996,1346,670,-1,996,1527,1346,-1,652,646,678,-1,652,647,646,-1,631,496,495,-1,631,647,496,-1,1331,1528,1055,-1,1528,1331,1529,-1,952,831,950,-1,831,952,1057,-1,1364,1375,870,-1,1364,957,1375,-1,768,717,769,-1,717,768,1053,-1,928,952,951,-1,651,952,928,-1,618,1399,623,-1,618,602,1399,-1,1530,690,1531,-1,1393,690,1530,-1,1532,887,886,-1,1532,1521,887,-1,904,1520,938,-1,904,1533,1520,-1,1351,1534,1535,-1,1534,1351,1536,-1,723,1335,1537,-1,1335,723,722,-1,1036,782,1538,-1,1035,782,1036,-1,673,1034,620,-1,673,1033,1034,-1,520,1340,521,-1,1340,520,1383,-1,1042,1024,1341,-1,1041,1024,1042,-1,713,1539,1540,-1,713,712,1539,-1,1333,1384,1041,-1,1333,1338,1384,-1,732,858,1336,-1,732,731,858,-1,736,1541,1542,-1,736,722,1541,-1,1384,1022,1041,-1,1384,753,1022,-1,760,1543,1544,-1,1545,1543,760,-1,791,638,785,-1,791,794,638,-1,722,1540,1539,-1,1540,722,724,-1,1386,1475,1546,-1,1475,1386,257,-1,1545,759,1547,-1,1545,760,759,-1,1548,1479,725,-1,1548,1480,1479,-1,1096,1549,1097,-1,1096,1015,1549,-1,726,1012,1011,-1,1012,726,1550,-1,1551,1552,1550,-1,1551,1553,1552,-1,1552,961,1554,-1,961,1552,1357,-1,1344,1010,522,-1,525,1010,1344,-1,1054,960,1052,-1,859,960,1054,-1,682,780,911,-1,684,780,682,-1,1555,1005,1556,-1,1005,1555,561,-1,1530,1557,1558,-1,1557,1530,1531,-1,561,778,562,-1,561,1555,778,-1,924,1368,1367,-1,1317,1368,924,-1,998,1527,996,-1,1527,998,1036,-1,1346,721,1033,-1,721,1346,1559,-1,720,1341,764,-1,1042,1341,720,-1,1362,1560,1561,-1,1362,1562,1560,-1,787,995,1562,-1,796,995,787,-1,1562,1563,1560,-1,1562,995,1563,-1,1564,993,1565,-1,1564,1566,993,-1,993,1348,804,-1,1379,1348,993,-1,1567,505,880,-1,805,505,1567,-1,988,1069,986,-1,988,987,1069,-1,1067,986,1069,-1,986,1067,815,-1,816,632,980,-1,816,633,632,-1,981,1332,812,-1,981,656,1332,-1,1568,821,1569,-1,1568,979,821,-1,978,539,1004,-1,978,564,539,-1,1501,926,484,-1,926,1501,1331,-1,976,1352,973,-1,976,532,1352,-1,838,1027,1353,-1,838,837,1027,-1,1570,1019,1571,-1,1019,1570,1027,-1,1571,1504,1505,-1,1571,1572,1504,-1,968,1334,850,-1,968,1354,1334,-1,972,1573,1517,-1,972,970,1573,-1,534,1574,964,-1,534,1575,1574,-1,1576,962,1357,-1,1576,1577,962,-1,857,962,1578,-1,963,962,857,-1,1091,1039,1515,-1,594,1039,1091,-1,871,1374,1328,-1,871,546,1374,-1,424,877,1330,-1,424,423,877,-1,432,1529,1579,-1,432,883,1529,-1,1396,950,833,-1,1396,529,950,-1,552,869,544,-1,869,552,551,-1,1580,887,1533,-1,1580,1372,887,-1,895,946,896,-1,946,895,573,-1,502,588,1581,-1,1081,588,502,-1,497,1081,498,-1,497,641,1081,-1,931,580,918,-1,580,931,934,-1,1366,932,914,-1,916,932,1366,-1,709,661,707,-1,709,664,661,-1,1582,831,1057,-1,1582,1378,831,-1,1582,636,635,-1,636,1582,677,-1,919,921,920,-1,567,921,919,-1,913,581,1369,-1,913,1398,581,-1,910,908,579,-1,910,909,908,-1,894,899,1371,-1,899,894,897,-1,1583,1584,500,-1,1583,1585,1584,-1,888,557,889,-1,557,888,1360,-1,885,486,1586,-1,885,870,486,-1,648,504,893,-1,648,884,504,-1,1587,881,650,-1,881,1587,1060,-1,1579,1331,1501,-1,1529,1331,1579,-1,877,1561,1588,-1,876,1561,877,-1,874,790,788,-1,1373,790,874,-1,873,410,1589,-1,871,410,873,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_9()
		{
			int[] value = {524,1028,1337,-1,861,1028,524,-1,1029,1404,1336,-1,1029,1590,1404,-1,856,963,857,-1,856,1358,963,-1,1577,1578,962,-1,1577,1591,1578,-1,1591,1592,536,-1,1591,1512,1592,-1,841,1517,1405,-1,841,972,1517,-1,490,1334,489,-1,531,1334,490,-1,854,840,842,-1,840,854,1018,-1,1570,1353,1027,-1,1570,835,1353,-1,1516,1593,543,-1,1593,1516,533,-1,1569,825,1568,-1,1569,1350,825,-1,1569,1349,823,-1,821,1349,1569,-1,633,815,1067,-1,633,816,815,-1,983,897,982,-1,983,898,897,-1,807,1088,505,-1,807,984,1088,-1,801,1299,988,-1,801,343,1299,-1,1566,1379,993,-1,1566,799,1379,-1,1594,798,799,-1,1380,798,1594,-1,1380,1492,338,-1,1380,1595,1492,-1,540,1495,1519,-1,540,1267,1495,-1,1562,788,787,-1,788,1562,1362,-1,1526,1347,1403,-1,1526,1092,1347,-1,1013,618,620,-1,1013,616,618,-1,721,1032,1031,-1,721,1559,1032,-1,782,709,711,-1,782,1035,709,-1,617,769,717,-1,617,1013,769,-1,1043,1555,1556,-1,687,1555,1043,-1,1531,827,1557,-1,1531,1596,827,-1,929,770,771,-1,773,770,929,-1,694,1052,960,-1,1323,1052,694,-1,1357,1553,1576,-1,1552,1553,1357,-1,1554,1550,1552,-1,1550,1554,1012,-1,764,1383,765,-1,764,1342,1383,-1,1015,1597,1549,-1,1015,758,1597,-1,762,1598,1548,-1,1598,762,761,-1,1544,761,760,-1,761,1544,1598,-1,1599,1547,1600,-1,1547,1599,1545,-1,1386,1599,1542,-1,1386,1546,1599,-1,1339,755,754,-1,755,1339,1025,-1,1541,729,1387,-1,1541,1601,729,-1,745,1082,746,-1,1082,745,1602,-1,1333,493,1338,-1,1333,1030,493,-1,1542,1387,1386,-1,1542,1541,1387,-1,1336,1406,732,-1,1406,1336,1404,-1,1540,1038,713,-1,1038,1540,724,-1,1603,491,728,-1,1537,491,1603,-1,1341,1023,1342,-1,1024,1023,1341,-1,1597,726,1011,-1,1597,727,726,-1,1539,1541,722,-1,1539,1601,1541,-1,1392,1080,912,-1,1080,1392,592,-1,1538,1527,1036,-1,1538,1604,1527,-1,1317,716,1368,-1,1317,1037,716,-1,1367,706,924,-1,1367,705,706,-1,704,1593,976,-1,1593,704,703,-1,903,1533,904,-1,1580,1533,903,-1,892,947,945,-1,947,892,891,-1,1583,1602,745,-1,1602,1583,1397,-1,1574,1572,964,-1,1504,1572,1574,-1,774,1556,775,-1,774,1043,1556,-1,1382,645,680,-1,645,1382,826,-1,686,1381,687,-1,1381,686,674,-1,1558,1050,1530,-1,1558,1051,1050,-1,635,1378,1582,-1,635,1056,1378,-1,1529,1587,1528,-1,1587,1529,883,-1,678,1061,679,-1,678,646,1061,-1,997,670,1003,-1,997,996,670,-1,1017,638,794,-1,638,1017,639,-1,1463,1526,1605,-1,1526,1463,1525,-1,1606,1523,626,-1,1523,1606,1524,-1,1522,621,1607,-1,621,1522,1020,-1,1606,1522,1607,-1,584,1522,1606,-1,597,624,629,-1,597,1072,624,-1,626,584,1606,-1,626,628,584,-1,1608,1401,603,-1,1401,1608,605,-1,606,587,586,-1,606,1073,587,-1,1040,1515,1039,-1,1040,949,1515,-1,1397,1523,1602,-1,1397,626,1523,-1,625,1325,578,-1,1325,625,1076,-1,503,1084,893,-1,503,748,1084,-1,1371,1609,942,-1,1609,1371,899,-1,948,575,571,-1,747,575,948,-1,1584,902,500,-1,1584,903,902,-1,977,1610,829,-1,919,977,567,-1,977,919,1610,-1,1084,889,559,-1,889,1084,1098,-1,516,1360,888,-1,1361,1360,516,-1,900,555,938,-1,555,900,556,-1,1016,549,1611,-1,549,1016,793,-1,994,1380,1594,-1,994,1595,1380,-1,536,1575,534,-1,1575,536,1592,-1,1518,1573,1359,-1,1517,1573,1518,-1,848,533,1516,-1,533,848,1377,-1,1547,1015,756,-1,1015,1547,759,-1,949,552,1515,-1,949,553,552,-1,1337,1344,524,-1,1337,1007,1344,-1,1363,529,528,-1,529,1363,950,-1,748,1088,1315,-1,503,1088,748,-1,494,659,495,-1,494,509,659,-1,196,1612,148,-1,195,1612,196,-1,1613,1485,1484,-1,1613,480,1485,-1,1103,1614,373,-1,478,1614,1103,-1,465,464,466,-1,472,464,465,-1,454,1246,1159,-1,454,1408,1246,-1,453,452,451,-1,455,452,453,-1,1514,1468,441,-1,1450,1468,1514,-1,70,444,71,-1,1130,444,70,-1,2,215,1430,-1,2,435,215,-1,82,1433,1273,-1,82,1279,1433,-1,1615,422,1616,-1,422,1615,421,-1,412,329,413,-1,414,329,412,-1,1445,407,54,-1,1445,1135,407,-1,1137,1411,402,-1,1137,1447,1411,-1,1617,252,251,-1,1143,252,1617,-1,296,1511,1510,-1,1511,296,298,-1,384,396,1508,-1,384,1250,396,-1,1507,1306,1618,-1,1507,390,1306,-1,1145,3,5,-1,3,1145,46,-1,1195,1506,1251,-1,1503,1506,1195,-1,1502,1505,1503,-1,1619,1505,1502,-1,378,1620,1413,-1,1621,1620,378,-1,1223,376,375,-1,376,1223,1222,-1,371,1500,1499,-1,371,370,1500,-1,366,1500,368,-1,1500,366,1302,-1,349,143,350,-1,349,1301,143,-1,455,358,1158,-1,455,454,358,-1,1270,353,18,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_10()
		{
			int[] value = {1270,1161,353,-1,1299,1414,1164,-1,1299,343,1414,-1,342,1496,1168,-1,342,341,1496,-1,339,1448,341,-1,1448,339,1415,-1,1492,1415,338,-1,1492,1494,1415,-1,1495,1249,1493,-1,1495,1267,1249,-1,327,1417,328,-1,1126,1417,327,-1,65,1491,63,-1,65,1248,1491,-1,1284,292,234,-1,1284,293,292,-1,1490,152,1171,-1,1490,1489,152,-1,315,204,1419,-1,204,315,314,-1,1487,1213,1474,-1,1487,185,1213,-1,1304,1212,276,-1,1304,1484,1212,-1,1292,470,118,-1,470,1292,471,-1,297,1142,298,-1,1142,297,1182,-1,1291,241,240,-1,1291,1482,241,-1,1622,290,1189,-1,288,290,1622,-1,288,1623,289,-1,1622,1623,288,-1,1478,1624,1625,-1,1477,1624,1478,-1,1624,256,1626,-1,1624,1476,256,-1,263,1287,285,-1,262,1287,263,-1,246,1627,255,-1,246,1628,1627,-1,1629,438,1131,-1,1630,438,1629,-1,255,1626,256,-1,255,1627,1626,-1,7,1203,261,-1,7,6,1203,-1,281,266,283,-1,266,281,280,-1,1285,1628,246,-1,1628,1285,1265,-1,237,318,320,-1,318,237,236,-1,1200,1187,1186,-1,1187,1200,1199,-1,240,1631,1290,-1,240,239,1631,-1,1627,279,238,-1,1627,1628,279,-1,103,208,470,-1,102,208,103,-1,152,1472,1208,-1,152,1489,1472,-1,1209,1264,228,-1,1209,226,1264,-1,1470,220,1534,-1,1470,1428,220,-1,1470,216,1429,-1,1153,216,1470,-1,446,457,456,-1,457,446,1409,-1,215,212,213,-1,212,215,437,-1,1473,235,1427,-1,235,1473,1207,-1,1630,1113,438,-1,138,1113,1630,-1,1506,1574,1144,-1,1574,1506,1504,-1,1467,309,308,-1,1467,203,309,-1,1234,1198,1197,-1,1275,1198,1234,-1,1215,1487,1486,-1,1215,312,1487,-1,376,148,1612,-1,376,1222,148,-1,1122,1464,1310,-1,1410,1464,1122,-1,1214,1064,1228,-1,1064,1214,1049,-1,1220,466,464,-1,466,1220,150,-1,1462,1632,1128,-1,1461,1632,1462,-1,1436,1630,1629,-1,1436,1459,1630,-1,123,93,124,-1,1233,93,123,-1,1633,119,140,-1,1633,120,119,-1,87,120,1633,-1,1231,120,87,-1,1457,1435,132,-1,109,1435,1457,-1,1238,1276,1239,-1,1238,1231,1276,-1,92,139,1456,-1,92,137,139,-1,112,1633,110,-1,87,1633,112,-1,96,88,1437,-1,96,86,88,-1,1444,1133,108,-1,1444,1120,1133,-1,1459,138,1630,-1,1459,139,138,-1,1437,1436,1629,-1,1436,1437,88,-1,1232,134,83,-1,1233,134,1232,-1,1243,20,449,-1,1243,1422,20,-1,1634,451,1110,-1,453,451,1634,-1,1424,1116,1115,-1,1116,1424,1423,-1,461,214,17,-1,461,460,214,-1,1614,1303,373,-1,1303,478,1613,-1,1614,478,1303,-1,71,1243,69,-1,445,1243,71,-1,1468,1451,1452,-1,448,1451,1468,-1,1269,64,63,-1,1269,1268,64,-1,1494,1170,1169,-1,1494,1493,1170,-1,330,58,413,-1,330,59,58,-1,1575,48,50,-1,1592,48,1575,-1,1618,1447,1137,-1,1447,1618,1446,-1,1443,394,1445,-1,47,394,1443,-1,269,1478,286,-1,1288,1478,269,-1,1439,1120,1444,-1,1439,67,1120,-1,1179,1205,37,-1,1179,1176,1205,-1,44,1466,434,-1,1282,1466,44,-1,1270,1422,1260,-1,1422,1270,20,-1,175,10,1277,-1,175,1256,10,-1,1244,13,12,-1,1271,13,1244,-1,27,462,372,-1,27,26,462,-1,25,1257,75,-1,25,27,1257,-1,1130,78,443,-1,1130,70,78,-1,1465,1466,1432,-1,1465,434,1466,-1,46,1151,3,-1,46,45,1151,-1,1259,1136,1135,-1,1136,1259,1507,-1,1441,1617,1442,-1,1617,1441,1508,-1,1508,1143,1617,-1,396,1143,1508,-1,1415,1169,1448,-1,1415,1494,1169,-1,61,334,1449,-1,332,334,61,-1,1109,457,1313,-1,458,457,1109,-1,1271,16,13,-1,1107,16,1271,-1,440,1430,1453,-1,440,2,1430,-1,442,1273,76,-1,82,1273,442,-1,80,1111,450,-1,80,79,1111,-1,453,1454,1408,-1,453,1634,1454,-1,85,1434,468,-1,85,84,1434,-1,1455,17,1113,-1,17,1455,15,-1,1455,98,1241,-1,98,1455,1274,-1,209,101,96,-1,101,209,102,-1,1134,1120,436,-1,1120,1134,1133,-1,123,1272,135,-1,122,1272,123,-1,136,1456,1457,-1,1456,136,92,-1,132,136,1457,-1,1198,136,132,-1,1459,1456,139,-1,1458,1456,1459,-1,1491,1463,1460,-1,1525,1463,1491,-1,324,1194,333,-1,1268,1194,324,-1,154,311,188,-1,154,153,311,-1,1229,194,1431,-1,1229,162,194,-1,1214,196,147,-1,1214,1431,196,-1,1157,1256,1255,-1,1157,10,1256,-1,1280,195,165,-1,195,1280,1612,-1,1294,1487,312,-1,1294,185,1487,-1,1174,1486,207,-1,1486,1174,1215,-1,184,197,1213,-1,184,198,197,-1,1211,205,277,-1,1211,206,205,-1,208,169,116,-1,208,1138,169,-1,1451,447,1312,-1,448,447,1451,-1,1514,460,459,-1,460,1514,1453,-1,1469,216,1152,-1,106,216,1469,-1,218,482,481,-1,218,1428,482,-1,108,1132,107,-1,1133,1132,108,-1,319,1635,320,-1,1472,1635,319,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_11()
		{
			int[] value = {1188,1636,1479,-1,241,1636,1188,-1,1253,1184,1481,-1,295,1184,1253,-1,8,1635,242,-1,1635,8,1471,-1,318,278,224,-1,236,278,318,-1,1440,247,1426,-1,1442,247,1440,-1,247,250,248,-1,250,247,251,-1,1637,1147,1146,-1,1638,1147,1637,-1,1283,263,284,-1,1283,261,263,-1,1202,280,6,-1,1202,1207,280,-1,1254,1193,1190,-1,1262,1193,1254,-1,1191,1258,1200,-1,1190,1258,1191,-1,1497,1616,425,-1,1497,1639,1616,-1,1125,425,1616,-1,1125,426,425,-1,1471,261,1283,-1,1471,8,261,-1,1425,285,1625,-1,284,285,1425,-1,1475,1640,1641,-1,1475,1476,1640,-1,1287,267,285,-1,1287,1192,267,-1,1623,1641,1640,-1,1641,1623,1642,-1,1631,269,1481,-1,1631,287,269,-1,1421,292,291,-1,1421,1186,292,-1,1420,1482,297,-1,1643,1482,1420,-1,1181,1483,1308,-1,1181,1183,1483,-1,170,1138,1309,-1,1138,170,169,-1,201,1485,302,-1,1485,201,200,-1,369,1488,1474,-1,369,1155,1488,-1,1419,203,1467,-1,203,1419,204,-1,1289,231,1221,-1,1289,1185,231,-1,221,319,222,-1,221,317,319,-1,243,233,1206,-1,243,1490,233,-1,1286,1185,128,-1,1286,1235,1185,-1,1639,1615,1616,-1,1639,1418,1615,-1,330,325,322,-1,325,330,326,-1,1269,1462,1449,-1,1462,1269,1460,-1,337,325,328,-1,337,336,325,-1,1496,1418,1639,-1,1418,1496,1416,-1,340,345,344,-1,340,339,345,-1,425,1498,1497,-1,425,1123,1498,-1,1414,342,1297,-1,342,1414,345,-1,1498,348,1167,-1,352,348,1498,-1,1160,355,452,-1,355,1160,354,-1,1220,356,151,-1,356,1220,174,-1,371,1155,369,-1,371,52,1155,-1,1469,1445,54,-1,1443,1445,1469,-1,379,1502,1204,-1,379,1413,1502,-1,386,1250,384,-1,1196,1250,386,-1,260,1307,387,-1,260,259,1307,-1,1446,385,1441,-1,1446,1149,385,-1,1592,1509,48,-1,1592,1512,1509,-1,1513,1511,1141,-1,1513,1509,1511,-1,1140,250,1412,-1,1140,1139,250,-1,1442,251,247,-1,1442,1617,251,-1,254,37,1205,-1,37,254,401,-1,410,411,1589,-1,411,410,409,-1,1126,421,1615,-1,421,1126,417,-1,428,1616,422,-1,1125,1616,428,-1,426,167,427,-1,426,168,167,-1,1281,1579,1501,-1,1579,1281,1464,-1,1124,1122,163,-1,1278,1122,1124,-1,19,164,449,-1,19,1225,164,-1,1224,1466,1282,-1,1224,1217,1466,-1,213,438,1113,-1,212,438,213,-1,1312,33,1451,-1,1114,33,1312,-1,1454,458,1245,-1,1454,1407,458,-1,1105,468,89,-1,1105,467,468,-1,90,469,274,-1,90,1434,469,-1,480,478,477,-1,478,480,1613,-1,217,482,1429,-1,229,482,217,-1,244,218,245,-1,244,219,218,-1,498,1319,499,-1,1319,498,554,-1,907,510,830,-1,907,511,510,-1,1100,512,564,-1,1100,510,512,-1,569,1360,642,-1,569,557,1360,-1,1363,1375,1395,-1,1363,528,1375,-1,1352,531,490,-1,1352,532,531,-1,959,965,958,-1,851,965,959,-1,1590,1405,1404,-1,1644,1405,1590,-1,1356,1644,1590,-1,1644,1356,1376,-1,1374,792,789,-1,1374,548,792,-1,795,1595,994,-1,795,1519,1595,-1,542,1089,1403,-1,542,639,1089,-1,947,1521,1532,-1,1521,947,891,-1,501,554,498,-1,554,501,936,-1,1586,1372,1580,-1,1586,486,1372,-1,1321,574,568,-1,574,1321,1402,-1,944,573,895,-1,944,1365,573,-1,940,899,1370,-1,940,1609,899,-1,1398,576,910,-1,1398,577,576,-1,500,1581,1583,-1,502,1581,500,-1,1070,1581,588,-1,627,1581,1070,-1,593,695,587,-1,592,695,593,-1,949,957,1364,-1,1040,957,949,-1,1320,1075,1074,-1,1075,1320,613,-1,1077,676,1001,-1,1077,599,676,-1,1399,1607,621,-1,1607,1399,601,-1,1400,605,1608,-1,605,1400,1072,-1,609,1608,615,-1,609,1400,1608,-1,583,1075,612,-1,1075,583,1076,-1,1602,604,1082,-1,1602,1523,604,-1,1632,1645,955,-1,1645,1632,1461,-1,589,935,905,-1,641,935,589,-1,1064,1048,1065,-1,1049,1048,1064,-1,1060,655,654,-1,1060,882,655,-1,636,1048,1047,-1,636,679,1048,-1,509,681,644,-1,509,494,681,-1,677,1057,1046,-1,1582,1057,677,-1,1558,1345,1051,-1,1558,665,1345,-1,1530,1002,1393,-1,1050,1002,1530,-1,1020,1077,1021,-1,1077,1020,600,-1,680,666,1382,-1,680,1394,666,-1,692,693,749,-1,692,691,693,-1,1323,1392,1324,-1,1323,694,1392,-1,1391,885,1585,-1,699,885,1391,-1,900,943,901,-1,890,943,900,-1,704,1535,1390,-1,1535,704,1351,-1,220,1535,1534,-1,220,705,1535,-1,1603,782,781,-1,782,1603,1538,-1,1479,1389,725,-1,1479,1636,1389,-1,767,1097,1549,-1,1097,767,766,-1,1038,723,781,-1,724,723,1038,-1,1601,925,729,-1,923,925,1601,-1,1384,750,752,-1,1338,750,1384,-1,751,1385,1026,-1,751,492,1385,-1,966,1637,967,-1,1637,966,1638,-1,755,1335,737,-1,755,1026,1335,-1,738,1014,741,-1,1014,738,1316,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_12()
		{
			int[] value = {742,1340,1023,-1,1340,742,741,-1,1588,1565,879,-1,1588,1564,1565,-1,879,953,1588,-1,879,954,953,-1,1026,1537,1335,-1,1026,491,1537,-1,754,736,1600,-1,736,754,737,-1,1543,1475,1641,-1,1543,1546,1475,-1,757,1339,754,-1,757,740,1339,-1,1641,1544,1543,-1,1642,1544,1641,-1,762,725,727,-1,762,1548,725,-1,1389,1550,726,-1,1389,1551,1550,-1,1553,1643,1420,-1,1553,1551,1643,-1,1646,1554,961,-1,1646,1343,1554,-1,765,519,768,-1,520,519,765,-1,912,780,607,-1,911,780,912,-1,772,565,688,-1,772,566,565,-1,1382,1558,1557,-1,1382,665,1558,-1,687,778,1555,-1,1381,778,687,-1,1527,1559,1346,-1,1527,1604,1559,-1,1561,1564,1588,-1,1561,1560,1564,-1,784,792,785,-1,786,792,784,-1,1645,1089,1611,-1,1605,1089,1645,-1,784,796,787,-1,784,797,796,-1,1560,1566,1564,-1,1563,1566,1560,-1,800,340,344,-1,800,798,340,-1,1567,879,1565,-1,1567,880,879,-1,1379,801,1348,-1,800,801,1379,-1,802,1567,803,-1,1567,802,805,-1,896,810,894,-1,808,810,896,-1,812,935,640,-1,1332,935,812,-1,1596,825,827,-1,1596,538,825,-1,1004,538,1596,-1,1004,539,538,-1,1378,1055,832,-1,1056,1055,1378,-1,1620,836,835,-1,836,1620,1621,-1,1505,1570,1571,-1,1570,1505,1619,-1,1572,1019,1094,-1,1019,1572,1571,-1,1354,969,844,-1,1354,968,969,-1,850,531,1377,-1,850,1334,531,-1,970,851,1573,-1,970,852,851,-1,1376,842,1644,-1,1376,854,842,-1,1577,296,1510,-1,1576,296,1577,-1,855,1590,1029,-1,1590,855,1356,-1,733,1359,864,-1,733,1518,1359,-1,867,1516,543,-1,867,958,1516,-1,790,1328,789,-1,1328,790,1373,-1,876,1362,1561,-1,875,1362,876,-1,1588,1330,877,-1,1330,1588,953,-1,654,954,878,-1,654,653,954,-1,1528,650,1329,-1,1528,1587,650,-1,1396,1402,1321,-1,1396,1059,1402,-1,745,1585,1583,-1,1585,745,1391,-1,1521,1533,887,-1,1533,1521,1520,-1,1318,898,811,-1,1318,1370,898,-1,905,933,589,-1,933,905,915,-1,1610,1366,829,-1,1366,1610,919,-1,1367,702,1390,-1,702,1367,715,-1,706,244,730,-1,706,219,244,-1,663,927,928,-1,663,776,927,-1,771,921,929,-1,921,771,922,-1,907,829,915,-1,907,830,829,-1,579,932,918,-1,932,579,908,-1,1369,580,934,-1,581,580,1369,-1,939,1609,940,-1,939,901,1609,-1,1365,701,571,-1,945,701,1365,-1,901,942,1609,-1,901,943,942,-1,642,1532,886,-1,1361,1532,642,-1,744,1391,745,-1,1391,744,700,-1,570,1059,1058,-1,1059,570,1402,-1,832,1528,1329,-1,832,1055,1528,-1,1328,415,408,-1,1328,1373,415,-1,955,1589,1632,-1,873,1589,955,-1,743,735,868,-1,734,735,743,-1,523,1646,1358,-1,523,522,1646,-1,1518,732,1406,-1,1518,733,732,-1,961,1358,1646,-1,963,1358,961,-1,1591,1355,1578,-1,1591,536,1355,-1,1510,1591,1577,-1,1510,1512,1591,-1,1644,841,1405,-1,1644,842,841,-1,533,976,1593,-1,532,976,533,-1,971,970,972,-1,839,970,971,-1,1619,835,1570,-1,1619,1620,835,-1,836,1638,966,-1,1621,1638,836,-1,973,1536,1351,-1,975,1536,973,-1,1568,538,537,-1,538,1568,825,-1,979,537,515,-1,537,979,1568,-1,823,1350,1569,-1,823,643,1350,-1,894,982,897,-1,982,894,810,-1,991,809,806,-1,809,991,1095,-1,802,991,806,-1,992,991,802,-1,1348,988,990,-1,801,988,1348,-1,1565,803,1567,-1,803,1565,993,-1,799,1563,1594,-1,799,1566,1563,-1,1519,1492,1595,-1,1492,1519,1495,-1,1605,1403,1089,-1,1605,1526,1403,-1,620,763,1013,-1,1034,763,620,-1,1032,1604,728,-1,1032,1559,1604,-1,1051,1003,1000,-1,1051,1345,1003,-1,1596,690,1004,-1,1596,1531,690,-1,607,1392,912,-1,607,1324,1392,-1,766,526,519,-1,526,766,527,-1,1343,522,1010,-1,522,1343,1646,-1,1420,1576,1553,-1,1576,1420,296,-1,1012,1343,1009,-1,1012,1554,1343,-1,1636,1551,1389,-1,1551,1636,1643,-1,758,727,1597,-1,758,762,727,-1,1647,1548,1598,-1,1647,1480,1548,-1,1544,1647,1598,-1,1544,1642,1647,-1,1546,1545,1599,-1,1545,1546,1543,-1,1542,1600,736,-1,1542,1599,1600,-1,751,1339,750,-1,1025,1339,751,-1,1388,1387,729,-1,1387,1388,257,-1,955,1611,549,-1,1645,1611,955,-1,911,934,682,-1,911,1369,934,-1,826,1557,827,-1,1557,826,1382,-1,967,393,489,-1,393,967,1637,-1,712,1601,1539,-1,712,923,1601,-1,1537,781,723,-1,1537,1603,781,-1,1023,1383,1342,-1,1023,1340,1383,-1,1549,1011,767,-1,1549,1597,1011,-1,728,1538,1603,-1,1538,728,1604,-1,1317,712,1037,-1,1317,923,712,-1,705,1390,1535,-1,705,1367,1390,-1,543,703,1090,-1,543,1593,703,-1,1066,570,1058,-1,1066,558,570,-1,1585,1586,1584,-1,885,1586,1585,-1,964,1094,853,-1,1572,1094,964,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_13()
		{
			int[] value = {775,1005,1044,-1,775,1556,1005,-1,777,1393,1002,-1,777,691,1393,-1,951,1395,662,-1,951,1363,1395,-1,596,707,956,-1,708,707,596,-1,1056,634,926,-1,635,634,1056,-1,882,1587,883,-1,1060,1587,882,-1,1061,1068,1065,-1,1327,1068,1061,-1,824,644,643,-1,824,1099,644,-1,679,1065,1048,-1,679,1061,1065,-1,1461,1605,1645,-1,1605,1461,1463,-1,1063,987,989,-1,1063,1326,987,-1,615,603,602,-1,615,1608,603,-1,1524,603,1401,-1,1524,601,603,-1,601,1606,1607,-1,1524,1606,601,-1,1021,1001,999,-1,1021,1077,1001,-1,1322,608,1078,-1,1322,1324,608,-1,1581,1397,1583,-1,1581,627,1397,-1,629,577,591,-1,578,577,629,-1,941,1370,1318,-1,941,940,1370,-1,1580,1584,1586,-1,1584,1580,903,-1,1320,563,1083,-1,1320,1079,563,-1,1066,559,558,-1,1066,1085,559,-1,1361,947,1532,-1,1361,516,947,-1,938,890,900,-1,938,1520,890,-1,1318,1319,941,-1,499,1319,1318,-1,1017,1611,1089,-1,1017,1016,1611,-1,995,1594,1563,-1,994,1594,995,-1,862,1028,731,-1,862,735,1028,-1,1359,851,959,-1,1573,851,1359,-1,4,1352,490,-1,974,1352,4,-1,756,1600,1547,-1,756,754,1600,-1,957,1395,1375,-1,660,1395,957,-1,1096,1316,757,-1,1014,1316,1096,-1,855,1578,1355,-1,855,857,1578,-1,1321,529,1396,-1,529,1321,530,-1,658,513,906,-1,658,514,513,-1,906,511,907,-1,906,513,511,-1,377,1612,1280,-1,377,376,1612,-1,179,221,1218,-1,179,182,221,-1,1285,481,1265,-1,245,481,1285,-1,480,302,1485,-1,479,302,480,-1,373,462,472,-1,373,372,462,-1,1104,89,474,-1,1105,89,1104,-1,91,274,273,-1,274,91,90,-1,1634,1407,1454,-1,1634,456,1407,-1,1114,79,1115,-1,79,1114,1312,-1,1110,456,1634,-1,1110,446,456,-1,1452,443,1117,-1,443,1452,1129,-1,1118,1439,56,-1,68,1439,1118,-1,1282,1433,1121,-1,1282,44,1433,-1,1464,432,1579,-1,1464,1410,432,-1,421,423,422,-1,421,420,423,-1,415,412,408,-1,415,414,412,-1,413,57,409,-1,413,58,57,-1,1589,1128,1632,-1,1128,1589,411,-1,253,270,1266,-1,270,253,271,-1,108,1263,1444,-1,1263,108,105,-1,1141,1412,1513,-1,1412,1141,1140,-1,1141,298,1142,-1,1141,1511,298,-1,1574,50,1144,-1,1574,1575,50,-1,1618,1149,1446,-1,1618,1306,1149,-1,1152,1443,1469,-1,1443,1152,45,-1,1306,1150,1149,-1,1150,1306,381,-1,1413,1619,1502,-1,1413,1620,1619,-1,1638,378,1147,-1,378,1638,1621,-1,1536,1305,1153,-1,1305,1536,975,-1,52,1499,53,-1,371,1499,52,-1,53,28,1261,-1,1499,28,53,-1,370,368,1500,-1,370,160,368,-1,1301,1163,1252,-1,1163,1301,349,-1,351,1166,1162,-1,351,1164,1166,-1,351,1165,1164,-1,18,1498,1123,-1,1498,18,352,-1,1297,1168,347,-1,1168,1297,342,-1,1168,1639,1497,-1,1168,1496,1639,-1,1296,328,1417,-1,328,1296,337,-1,1418,1126,1615,-1,1418,1417,1126,-1,1187,234,292,-1,234,1187,1427,-1,233,1171,1172,-1,1490,1171,233,-1,152,181,153,-1,1208,181,152,-1,228,481,482,-1,481,228,1264,-1,1293,1155,1175,-1,1293,1488,1155,-1,307,1419,1467,-1,74,1419,307,-1,1292,272,471,-1,272,1292,306,-1,1309,316,170,-1,316,1309,399,-1,41,1179,39,-1,1179,41,40,-1,1308,1182,1181,-1,1142,1182,1308,-1,1183,1180,294,-1,1183,1181,1180,-1,1643,241,1482,-1,1643,1636,241,-1,239,287,1631,-1,239,290,287,-1,1189,1647,1622,-1,1189,1480,1647,-1,1647,1623,1622,-1,1647,1642,1623,-1,1477,1476,1624,-1,1640,1476,1477,-1,1625,1626,1425,-1,1625,1624,1626,-1,1287,1203,281,-1,1203,1287,262,-1,255,1388,246,-1,257,1388,255,-1,1449,1128,61,-1,1128,1449,1462,-1,1640,289,1623,-1,289,1640,1477,-1,1199,266,1473,-1,266,1199,264,-1,1627,1425,1626,-1,1627,238,1425,-1,393,1146,5,-1,1637,1146,393,-1,1628,225,279,-1,1628,1265,225,-1,320,1471,237,-1,320,1635,1471,-1,1421,1200,1186,-1,1421,1191,1200,-1,1290,1481,1184,-1,1290,1631,1481,-1,1472,242,1635,-1,1489,242,1472,-1,225,1264,226,-1,225,1265,1264,-1,1534,1153,1470,-1,1536,1153,1534,-1,1450,459,1313,-1,1450,1514,459,-1,1251,1144,397,-1,1144,1251,1506,-1,1293,1486,1488,-1,1486,1293,207,-1,306,304,272,-1,306,305,304,-1,207,1295,1174,-1,207,206,1295,-1,183,198,184,-1,187,198,183,-1,1224,1216,1217,-1,1216,1224,1101,-1,1221,299,1289,-1,300,299,1221,-1,149,1222,483,-1,1222,149,148,-1,1122,433,1410,-1,433,1122,1278,-1,1227,1229,1228,-1,1229,1227,1230,-1,162,145,194,-1,162,146,145,-1,324,64,1268,-1,64,324,323,-1,1525,1248,1093,-1,1525,1491,1248,-1,1230,351,350,-1,351,1230,1227,-1,1239,101,1106,-1,1239,1276,101,-1,110,140,111,-1,110,1633,140,-1,1233,94,93,-1};
			return value;
		}
		private int[] getc7_Geo_8_79_coordIndex_14()
		{
			int[] value = {1233,1232,94,-1,141,230,232,-1,230,141,171,-1,121,1231,1238,-1,121,120,1231,-1,73,122,315,-1,1242,122,73,-1,1241,100,1314,-1,1241,98,100,-1,1437,1131,97,-1,1437,1629,1131,-1,469,84,1106,-1,84,469,1434,-1,450,1110,451,-1,1111,1110,450,-1,1613,1304,1303,-1,1613,1484,1304,-1,72,1272,1242,-1,72,1237,1272,-1,2,439,0,-1,440,439,2,-1,445,1423,1243,-1,1116,1423,445,-1,1450,448,1468,-1,1409,448,1450,-1,1424,1260,1422,-1,1424,1112,1260,-1,1424,81,1112,-1,60,59,332,-1,1127,59,60,-1,1493,335,1170,-1,335,1493,1249,-1,335,65,64,-1,335,1249,65,-1,254,403,249,-1,254,253,403,-1,1507,1137,1136,-1,1137,1507,1618,-1,1151,4,3,-1,4,1151,974,-1,1625,286,1478,-1,1625,285,286,-1,1432,1134,1465,-1,1134,1432,177,-1,1262,268,267,-1,268,1262,1254,-1,1513,252,49,-1,1513,1412,252,-1,44,1273,1433,-1,43,1273,44,-1,30,1219,463,-1,30,29,1219,-1,26,463,462,-1,26,30,463,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc7_Coord_9_79_point_1()
		{
			double[] value = {-.39589,52.56039,-1.74983,-.40569,52.58166,-1.71808,-.46109,52.56315,-1.69313,-.07777,52.34705,-1.59057,0.0,52.35076,-1.58532,-.07216,52.34378,-1.54112,-.36135,52.85065,-1.30414,-.34188,52.83687,-1.31763,-.32661,52.8493,-1.37313,-.31494,52.81045,-1.69123,-.33221,52.89247,-1.62181,-.34903,52.82706,-1.63149,-.7671,52.47864,-1.72377,-.72905,52.49666,-1.68465,-.76538,52.53043,-1.67188,-.68262,52.54324,-1.6586,-.6969,52.51408,-1.67105,-.64794,52.53855,-1.66012,-.33729,52.39066,-2.07589,-.19017,52.37194,-2.08453,-.32809,52.38999,-2.03098,-.43104,52.82615,-1.64942,-.42143,52.81362,-1.65626,-.49917,52.76848,-1.68801,-.36588,52.89706,-1.63051,-.87028,52.79256,-1.59066,-.85175,52.75458,-1.61007,-.89419,52.79228,-1.57143,-.68722,52.80974,-1.63175,-.71025,52.7599,-1.67294,-.78516,52.75517,-1.63958,-.34194,52.37285,-1.95586,-.3307,52.38407,-1.94722,-.37849,52.40342,-1.92884,-.43215,52.6971,-1.14178,-.45342,52.70889,-1.13979,-.45385,52.67424,-1.14471,-.43425,52.43386,-1.23211,-.3972,52.38306,-1.18601,-.38445,52.45176,-1.16891,-.44771,52.52421,-1.18751,-.38701,52.51854,-1.14218,-.38563,52.59688,-1.1223,-.34175,52.54909,-1.78527,-.33408,52.5811,-1.76591,-.13766,52.36625,-1.59836,-.13868,52.35687,-1.59018,-.22517,52.37625,-1.58867,-.06606,52.15704,-1.10078,-.15064,52.16456,-1.1018,-.06753,52.15528,-1.1126,-.79939,52.91105,-1.53911,-.7293,52.95472,-1.51207,-.79297,52.86941,-1.57117,-.28363,52.45291,-1.5658,-.34268,52.4798,-1.51403,-.3449,52.51172,-1.52269,-.08153,52.56846,-2.7708,-.08472,52.56486,-2.75059,-.14969,52.59372,-2.83537,-.15044,52.65883,-2.84167,-.15237,52.67657,-2.84342,-.1137,52.6021,-2.83887,-.08089,52.7907,-2.65911,-.09165,52.78395,-2.65809,-.07736,52.78915,-2.65475,-.4467,52.53829,-1.5199,-.41159,52.54654,-1.54749,-.42723,52.52638,-1.49839,-.2528,52.39651,-1.97189,-.28598,52.44524,-1.90822,-.26776,52.39534,-1.96297,-.73879,52.61381,-1.34275,-.75316,52.63718,-1.35704,-.84818,52.64194,-1.35234,-.86234,52.87148,-1.54932,-.34564,52.53856,-1.78858,-.29474,52.48633,-1.87384,-.30008,52.47686,-1.86834,-.44566,52.31725,-2.00333,-.44557,52.31863,-2.01094,-.38089,52.31535,-2.01536,-.30687,52.50424,-1.84582,-.71864,52.53262,-1.45209,-.73091,52.52233,-1.45987,-.73927,52.54787,-1.49741,-.60574,52.53019,-1.4047,-.60346,52.54895,-1.40286,-.59837,52.53401,-1.42169,-.88803,52.55665,-1.52108,-.80927,52.51722,-1.47569,-.89435,52.53883,-1.49083,-.64841,52.59526,-1.50275,-.69789,52.61314,-1.48403,-.70352,52.5809,-1.50219,-.55727,52.49269,-1.38028,-.59824,52.51278,-1.391,-.54144,52.49772,-1.42821,-.70735,52.56677,-1.54475,-.71285,52.55683,-1.51692};
			return value;
		}
		private double[] getc7_Coord_9_79_point_2()
		{
			double[] value = {-.73745,52.56719,-1.54905,-.65783,52.50358,-1.39661,-.67088,52.50526,-1.3744,-.73043,52.501,-1.3969,-.28718,52.50329,-1.55547,-.29748,52.57133,-1.54322,-.21549,52.48932,-1.5887,-.2988,52.62611,-1.53754,-.33131,52.58084,-1.54336,-.58149,52.62926,-1.43488,-.57667,52.61592,-1.41109,-.5654,52.6493,-1.39292,-.59067,52.56654,-1.43422,-.74053,52.7573,-1.41088,-.7054,52.72315,-1.44261,-.72054,52.77409,-1.43617,-.68438,52.58629,-1.30855,-.68488,52.59416,-1.33483,-.73636,52.58307,-1.32403,-.63877,52.58771,-1.3502,-.64324,52.56428,-1.3731,-.69004,52.55219,-1.39463,-.74854,52.67998,-1.39612,-.73591,52.63464,-1.43263,-.7131,52.66122,-1.44825,-.65838,52.79355,-1.4395,-.64435,52.84125,-1.43162,-.68876,52.83472,-1.42265,-.50863,52.70586,-1.34147,-.51925,52.71733,-1.39512,-.55,52.69397,-1.40508,-.57782,52.71688,-1.4215,-.59348,52.68612,-1.43418,-.68408,52.66324,-1.46193,-.71288,52.55855,-1.43248,-.7155,52.58384,-1.40339,-.63955,52.64969,-1.46834,-.65466,52.57637,-1.51962,-.63232,52.5632,-1.53505,-.62573,52.56687,-1.50293,-.58899,52.61516,-1.34016,-.64167,52.59584,-1.32405,-.23366,52.79618,-1.84914,-.23687,52.79899,-1.85053,-.27589,52.80825,-1.78168,-.27047,52.76354,-1.78552,-.27316,52.7856,-1.784,-.10541,52.71178,-1.94902,-.162,52.68042,-1.92342,-.1015,52.6876,-1.96704,-.77058,52.56612,-1.65445,-.77573,52.60139,-1.73762,-.39447,52.77428,-1.45009,-.41843,52.78397,-1.48346,-.46626,52.79738,-1.45959,-.25346,52.49979,-1.90383,-.21072,52.45537,-1.97758,-.20017,52.52751,-1.94611,-.4509,53.00251,-1.53168,-.45848,52.89134,-1.60619,-.49766,52.93597,-1.55526,-.27259,52.80594,-1.7791,-.23746,52.77447,-1.85692,-.15987,52.46783,-2.02993,-.19144,52.43261,-2.01109,-.2671,52.73187,-1.7903,-.05478,52.44541,-2.21273,-.09073,52.40789,-2.19214,-.09409,52.40682,-2.22829,-.63407,52.56186,-1.29202,-.60457,52.55776,-1.27678,-.64324,52.58515,-1.29301,-.60144,52.7644,-1.69034,-.59424,52.72484,-1.7494,-.70585,52.69337,-1.72528,-.3183,52.87665,-1.67661,-.40248,52.81349,-1.69524,-.38764,52.64216,-1.57362,-.37386,52.69758,-1.60622,-.3781,52.68638,-1.54921,-.36343,52.78853,-1.5786,-.38899,52.76017,-1.50759,-.3769,52.72898,-1.52052,-.43875,52.88896,-1.50938,-.45409,52.91216,-1.49977,-.53528,52.91803,-1.43615,-.43278,52.89318,-1.51201,-.43275,52.89967,-1.51495,-.522,52.85644,-1.45609,-.5597,52.81457,-1.45145,-.50064,52.76464,-1.44162,-.47547,52.75505,-1.37379,-.73731,52.69999,-1.41616,-.77999,52.78121,-1.4001,-.23176,52.74667,-1.87107,-.21656,52.71518,-1.87156,-.16867,52.71492,-1.91818,-.44118,52.99563,-1.51275,-.44112,52.91081,-1.50952,-1.02884,52.66727,-1.37967};
			return value;
		}
		private double[] getc7_Coord_9_79_point_3()
		{
			double[] value = {-1.09401,52.67372,-1.39962,-1.06351,52.61515,-1.38698,-.83826,52.80153,-1.40446,-.88358,52.75708,-1.42106,-.8131,52.74141,-1.39834,-.8404,52.9144,-1.43766,-.81711,52.883,-1.39837,-.76635,52.91355,-1.39814,-.68499,52.51241,-1.34742,-.61571,52.5118,-1.35979,-.5632,52.50288,-1.33479,-.51027,52.44635,-1.33943,-.49435,52.54183,-1.56129,-.5419,52.54586,-1.6106,-.57643,52.5241,-1.67046,-.50165,52.56122,-1.63293,-.12908,52.45507,-1.59207,-.21838,52.5578,-1.57172,-.08436,52.7042,-1.46465,0.0,52.69315,-1.47287,0.0,52.59834,-1.50194,-.32716,52.7174,-1.5151,-.29769,52.75477,-1.47254,-.25657,52.75334,-1.4792,-.21393,52.7954,-1.43931,-.18665,52.78467,-1.43367,-.22468,52.74629,-1.47533,-.26215,52.62705,-1.54257,-.19981,52.65683,-1.51733,-.20518,52.62826,-1.53978,-.61042,52.58683,-1.28037,-.56978,52.63915,-1.30142,-.60221,52.59826,-1.32347,-.42562,52.84776,-1.30583,-.45001,52.8589,-1.23966,-.40334,52.89583,-1.26496,-.24323,52.8022,-1.42579,-.27147,52.81111,-1.40795,-.25321,52.76288,-1.36288,-.14227,52.61736,-.94318,-.14451,52.59975,-.93502,-.05663,52.58964,-.92905,-.33704,52.85142,-1.38826,-.38239,52.87191,-1.3453,0.0,52.75606,-1.43723,-.09022,52.75872,-1.44076,-.0919,52.76529,-1.42538,-.39673,52.25611,-1.2271,-.40029,52.32152,-1.20519,-.41583,52.36391,-1.28457,-.33555,52.28493,-1.13303,-.34244,52.22831,-1.15281,-.25488,52.1945,-1.12288,-.44822,52.42299,-1.37409,-.46916,52.40466,-1.30749,-.06835,52.72637,-1.35003,-.06265,52.72347,-1.34515,0.0,52.71726,-1.3557,-.17721,52.35239,-1.4309,-.15928,52.35065,-1.44553,-.15657,52.37479,-1.41247,-.31128,52.80865,-1.33106,-.32483,52.7961,-1.29591,-.29695,52.76725,-1.29679,-.41596,52.8428,-1.14585,-.4077,52.82444,-1.16302,-.40131,52.861,-1.21229,-.3193,52.69959,-1.1858,-.33947,52.68621,-1.15993,-.26683,52.67459,-1.09551,-.49646,52.48347,-1.43009,-.5065,52.4433,-1.3792,-.93732,52.50741,-1.3798,-.91134,52.50921,-1.43149,-.82442,52.49424,-1.42381,-.95694,52.85158,-1.47398,-1.01305,52.80461,-1.43357,-.93399,52.84708,-1.45253,-.21739,52.79746,-1.42043,-.19011,52.78673,-1.41477,-.38685,52.85973,-1.2544,-.37622,52.82779,-1.25811,-.37788,52.79668,-1.18564,-.38594,52.81816,-1.21447,-.2676,52.73921,-1.30807,-.28823,52.71873,-1.25163,-.28161,52.69615,-1.18519,-.21469,52.65987,-1.06141,-.12692,52.66156,-1.04135,-.13192,52.66537,-1.10425,-.12785,52.65618,-1.00494,-.48438,52.72298,-1.17744,-.4824,52.79554,-1.17391,-.50549,52.7587,-1.22623,-.31533,52.56626,-1.04174,-.38088,52.64807,-1.11067,0.0,52.35106,-.99475,-.06251,52.43493,-.96797,-.05977,52.35507,-1.00359,-.50517,52.62505,-1.19522};
			return value;
		}
		private double[] getc7_Coord_9_79_point_4()
		{
			double[] value = {-.55102,52.578,-1.22912,-.50314,52.59279,-1.20077,-1.06894,52.60992,-1.42308,-.9963,52.54153,-1.40164,-1.00735,52.55101,-1.37926,-.9836,52.59882,-1.35519,-.93387,52.58452,-1.33863,-.92906,52.65858,-1.37821,-1.01816,52.73796,-1.41896,-.96623,52.7821,-1.41727,-.35251,52.83925,-1.59378,-.42247,52.84444,-1.50756,-.61742,52.90035,-1.40596,-.74487,52.81645,-1.41027,-.77154,52.7263,-1.40253,-.79033,52.68968,-1.39328,-.54288,52.54351,-1.24432,-.34959,52.73636,-1.49341,-.245,52.80053,-1.44512,-.32904,52.77394,-1.45589,-.28004,52.81236,-1.42434,-.54487,52.7369,-1.42887,-.12326,52.65254,-2.70263,-.11019,52.72985,-2.67507,-.12282,52.72972,-2.70947,-.09921,52.62492,-2.63045,-.10332,52.55143,-2.64407,-.07159,52.52568,-2.55864,-.10971,52.59058,-2.54641,-.05042,52.54417,-2.63131,-.12762,52.57356,-2.72082,-.16093,52.66484,-2.75211,-.16123,52.67459,-2.83474,-.15889,52.73841,-2.74679,-.14461,52.75705,-2.81252,-.05693,52.74614,-2.6133,-.07642,52.70852,-2.6199,-.08733,52.69,-2.5419,0.0,52.76063,-2.39016,-.06022,52.73608,-2.32449,0.0,52.77444,-2.32876,-.09713,52.69898,-2.32265,-.1464,52.7077,-2.20562,0.0,52.80353,-2.12909,0.0,52.79282,-2.22921,-.06997,52.75251,-2.21759,-.29226,52.63569,-2.07559,-.22676,52.62711,-2.15043,-.3189,52.57532,-2.08691,-.27758,52.76504,-1.90344,-.18995,52.80228,-1.89692,-.13803,52.81363,-1.91429,-.34865,52.45363,-2.09262,-.43033,52.46362,-2.04185,-.4728,52.54324,-1.9644,-.52685,52.44075,-2.00009,-.69534,52.63774,-1.7799,-.5726,52.68285,-1.8061,-.64681,52.61144,-1.85737,-.40459,52.6751,-1.93958,-.45098,52.61261,-1.94214,-.5063,52.64118,-1.8931,-.45903,52.74685,-1.77678,-.35479,52.78383,-1.76942,-.48553,52.7588,-1.69954,-.60226,52.77555,-1.68687,-.49613,52.81324,-1.64691,-.50458,52.78044,-1.67815,-.49251,52.88921,-1.59799,-.65357,53.02597,-1.4422,-.57923,52.95508,-1.51769,-.6676,52.96625,-1.50822,-.90746,52.79058,-1.56186,-.93342,52.79964,-1.54134,-.90545,52.82915,-1.54303,-.20354,52.58765,-1.90546,-.2082,52.6338,-1.88921,-.25805,52.62549,-1.81315,-.06259,52.34204,-1.35824,-.12497,52.32001,-1.30005,-.1131,52.35044,-1.3623,-.20576,52.31781,-1.33697,-.17868,52.32116,-1.31081,-.17611,52.29222,-1.24432,-.3106,52.18568,-1.23251,-.32169,52.2198,-1.2915,-.18998,52.25017,-1.25681,-.11145,52.38793,-1.42915,-.16935,52.3662,-1.38284,-.1956,52.34941,-1.39526,-.29189,52.33501,-1.43569,-.29204,52.35541,-1.46623,0.0,52.34139,-1.54476,0.0,52.34201,-1.54245,-.27472,52.38844,-1.56147,-.21875,52.38034,-1.55108,-.24457,52.16897,-1.15145,-.14284,52.18382,-1.16555,-.14904,52.16043,-1.11457,-.53308,52.49642,-1.26629};
			return value;
		}
		private double[] getc7_Coord_9_79_point_5()
		{
			double[] value = {-.52197,52.47918,-1.29731,-.42847,52.40734,-1.25627,-.37008,52.37905,-1.38179,-.41064,52.39624,-1.36751,-.3667,52.39682,-1.43441,-.39941,52.42746,-1.42601,-.39124,52.4523,-1.45473,-.34208,52.4385,-1.50563,0.0,52.5745,-2.70907,-.04247,52.57095,-2.78111,0.0,52.58044,-2.77146,-.06595,52.62173,-2.83323,-.02484,52.54959,-2.72185,-.07346,52.55794,-2.71063,-.0201,52.53955,-2.63356,0.0,52.55742,-2.62846,0.0,52.54837,-2.5408,-.01313,52.52417,-2.47995,-.01127,52.53169,-2.55281,0.0,52.52332,-2.47166,0.0,52.50772,-2.4063,-.01481,52.49981,-2.41666,-.02509,52.45863,-2.36196,0.0,52.48485,-2.35541,0.0,52.46711,-2.25898,-.15097,52.37492,-2.25591,-.11771,52.38362,-2.23764,-.13536,52.36183,-2.17499,-.04121,52.44008,-2.28648,-.25015,52.45342,-1.941,-.24132,52.40502,-1.98149,0.0,52.47461,-2.18452,0.0,52.5012,-2.13627,-.06483,52.46274,-2.15228,-.41549,52.60293,-1.68633,-.45566,52.5801,-1.63659,-.43335,52.58942,-1.58142,-.45773,52.55586,-1.58469,-.54339,52.55743,-1.53427,-.4024,52.55415,-1.75347,-.4627,52.5586,-1.70025,-.46728,52.51958,-1.78009,-.31513,52.49763,-1.84125,-.35354,52.48523,-1.84242,-.31947,52.3953,-1.93859,-.27273,52.38175,-1.97244,-.5734,52.41982,-1.8625,-.51005,52.39188,-1.90253,-.4899,52.44401,-1.85501,-.25248,52.39686,-1.99192,-.52483,52.35875,-1.97971,-.58967,52.40794,-1.93679,-.59967,52.46529,-1.96268,-.67752,52.42236,-1.85588,-.71335,52.51179,-1.86801,-.65803,52.49054,-1.91587,-.64258,52.42866,-1.81368,-.62794,52.45894,-1.76688,-.68093,52.46229,-1.7473,-.60196,52.49122,-1.72635,-.57759,52.51966,-1.67916,-.64673,52.5345,-1.66591,-.85587,52.74379,-1.6099,-.78716,52.74652,-1.63884,-.78268,52.69966,-1.66836,-.84563,52.62805,-1.58605,-.77981,52.60857,-1.61745,-.79262,52.57173,-1.53251,-.80162,52.54934,-1.50424,-.77071,52.50653,-1.42657,-.75107,52.50432,-1.36862,-.84469,52.50196,-1.37797,-.84074,52.69957,-1.63111,-.85752,52.66468,-1.58573,-.97303,52.60623,-1.51892,-1.00764,52.61444,-1.48595,-.98189,52.64709,-1.53402,-1.04792,52.66023,-1.5046,-1.0415,52.74223,-1.52328,-1.06419,52.61521,-1.46082,-1.08778,52.67081,-1.46913,-.13484,52.72642,-1.46433,-.1331,52.61902,-1.51978,-.08138,52.64649,-1.9921,0.0,52.66078,-2.01061,0.0,52.70367,-1.9743,.46109,52.56315,-1.69183,.40569,52.58166,-1.71695,.39589,52.56039,-1.74871,.07216,52.34378,-1.54084,.07777,52.34705,-1.59027,.32661,52.8493,-1.37247,.36135,52.85065,-1.30343,.3669,52.88036,-1.32718,.33221,52.89247,-1.62121,.31218,52.87371,-1.67826,.31494,52.81045,-1.69059,.76538,52.53043,-1.6699,.72905,52.49666,-1.68266,.7671,52.47864,-1.72168};
			return value;
		}
		private double[] getc7_Coord_9_79_point_6()
		{
			double[] value = {.64794,52.53855,-1.65836,.6969,52.51408,-1.66915,.68262,52.54324,-1.65679,.32809,52.38999,-2.02993,.19017,52.37194,-2.0839,.33729,52.39066,-2.07484,.42143,52.81362,-1.65541,.43104,52.82615,-1.64857,.50458,52.78044,-1.67713,.35178,52.89586,-1.63655,.89419,52.79228,-1.57001,.85175,52.75458,-1.60857,.87028,52.79256,-1.58926,.78516,52.75517,-1.63814,.71025,52.7599,-1.67159,.78792,52.79148,-1.61261,.37849,52.40342,-1.92761,.3307,52.38407,-1.94612,.34194,52.37285,-1.95472,.45385,52.67424,-1.14358,.45342,52.70889,-1.13872,.43215,52.6971,-1.14074,.38445,52.45176,-1.16732,.3972,52.38306,-1.1846,.43425,52.43386,-1.23066,.44771,52.52421,-1.18616,.4568,52.60957,-1.15451,.38563,52.59688,-1.11986,.41549,52.60293,-1.68521,.33408,52.5811,-1.76497,.34175,52.54909,-1.78428,.13868,52.35687,-1.58966,.13766,52.36625,-1.59784,.2248,52.38396,-1.59687,.06753,52.15528,-1.11229,.14904,52.16043,-1.1139,.06606,52.15704,-1.10046,.79297,52.86941,-1.57,.7293,52.95472,-1.51114,.79939,52.91105,-1.53805,.04447,52.75437,-2.60874,.05693,52.74614,-2.61325,.09165,52.78395,-2.65802,.28363,52.45291,-1.56483,.3449,52.51172,-1.5216,.34268,52.4798,-1.5129,.08153,52.56846,-2.77071,.14272,52.59674,-2.84261,.14969,52.59372,-2.83522,.15237,52.67657,-2.8433,.15044,52.65883,-2.84155,.42723,52.52638,-1.49709,.38303,52.52994,-1.53025,.41159,52.54654,-1.54626,.72371,52.4912,-1.68257,.67165,52.47581,-1.72545,.68093,52.46229,-1.74534,.28598,52.44524,-1.90731,.27751,52.45114,-1.91345,.2528,52.39651,-1.97105,.4024,52.55415,-1.75231,.84818,52.64194,-1.3505,.75316,52.63718,-1.35529,.73879,52.61381,-1.34097,.86234,52.87148,-1.54813,1.03935,52.79306,-1.45136,1.0966,52.74845,-1.44361,1.09221,52.74035,-1.48287,.34564,52.53856,-1.78756,.30008,52.47686,-1.86741,.29474,52.48633,-1.87293,.37744,52.31831,-2.00334,.38089,52.31535,-2.01405,.44557,52.31863,-2.00944,.31513,52.49763,-1.84028,.3678,52.31678,-2.01198,.73927,52.54787,-1.49547,.73091,52.52233,-1.45788,.71864,52.53262,-1.45015,.88803,52.55665,-1.51898,.89435,52.53883,-1.48866,.80927,52.51722,-1.47357,.70352,52.5809,-1.50039,.69789,52.61314,-1.48231,.64841,52.59526,-1.50107,.54144,52.49772,-1.42656,.58324,52.52489,-1.42284,.59824,52.51278,-1.38924,.71173,52.56264,-1.61588,.77981,52.60857,-1.61563,.75514,52.56514,-1.58628,.71497,52.50341,-1.42275,.67088,52.50526,-1.37248,.65783,52.50358,-1.39471,.29748,52.57133,-1.54233,.26215,52.62705,-1.54184,.2988,52.62611,-1.53671,.65039,52.51837,-1.40007,.68408,52.66324,-1.46034,.7054,52.72315,-1.44114};
			return value;
		}
		private double[] getc7_Coord_9_79_point_7()
		{
			double[] value = {.67548,52.71472,-1.43933,.58149,52.62926,-1.4334,.5654,52.6493,-1.3915,.57667,52.61592,-1.40958,.59331,52.54542,-1.44681,.60346,52.54895,-1.40117,.59837,52.53401,-1.41997,.73636,52.58307,-1.32218,.68488,52.59416,-1.33308,.63877,52.58771,-1.34852,.6854,52.57874,-1.35798,.69004,52.55219,-1.39278,.7131,52.66122,-1.44661,.74854,52.67998,-1.39448,.73731,52.69999,-1.41458,.58899,52.61516,-1.33864,.56239,52.64631,-1.32078,.56978,52.63915,-1.29998,.54047,52.66105,-1.37156,.51925,52.71733,-1.39392,.50863,52.70586,-1.34027,.59348,52.68612,-1.43279,.57782,52.71688,-1.42019,.55,52.69397,-1.40378,.69751,52.52807,-1.41556,.71288,52.55855,-1.43061,.62573,52.56687,-1.50124,.65839,52.56482,-1.53718,.65466,52.57637,-1.51789,.70608,52.51505,-1.42293,.60221,52.59826,-1.32188,.27259,52.80594,-1.77854,.27589,52.80825,-1.78112,.23687,52.79899,-1.85004,.1015,52.6876,-1.9668,.162,52.68042,-1.92303,.16867,52.71492,-1.91779,.11019,52.72985,-2.67498,.12282,52.72972,-2.70937,.12244,52.79782,-2.71924,.77573,52.60139,-1.73584,.77058,52.56612,-1.65255,.35354,52.48523,-1.84134,.49766,52.93597,-1.55448,.35992,52.90308,-1.62751,.4509,53.00251,-1.53107,.23746,52.77447,-1.85642,.27316,52.7856,-1.78342,.19144,52.43261,-2.01048,.21072,52.45537,-1.97692,.15987,52.46783,-2.02944,.31728,52.75696,-1.70119,.27047,52.76354,-1.78493,.09409,52.40682,-2.22802,.09073,52.40789,-2.19187,.05478,52.44541,-2.21258,.59424,52.72484,-1.74815,.60144,52.7644,-1.68914,.70922,52.74761,-1.67335,.3183,52.87665,-1.67603,.38764,52.64216,-1.57259,.3781,52.68638,-1.54826,.37386,52.69758,-1.6053,.36343,52.78853,-1.57781,.3769,52.72898,-1.51962,.53528,52.91803,-1.43529,.45409,52.91216,-1.499,.43875,52.88896,-1.5086,.43278,52.89318,-1.51124,.43275,52.89967,-1.5142,.46626,52.79738,-1.45862,.50064,52.76464,-1.44054,.5597,52.81457,-1.45036,.47547,52.75505,-1.37273,.74053,52.7573,-1.40945,.74487,52.81645,-1.40898,.72054,52.77409,-1.4348,.21656,52.71518,-1.87106,.23176,52.74667,-1.87056,.17358,52.7441,-1.91182,.44118,52.99563,-1.51214,.3396,52.89944,-1.60914,.93732,52.50741,-1.3775,1.00735,52.55101,-1.37705,.93387,52.58452,-1.33656,.83826,52.80153,-1.40306,.77999,52.78121,-1.39869,.8131,52.74141,-1.3968,1.01305,52.80461,-1.43216,.95694,52.85158,-1.47271,.79027,52.95683,-1.41241,.81711,52.883,-1.3972,.8404,52.9144,-1.43658,.90959,52.81614,-1.41167,.63215,52.51125,-1.32152,.61571,52.5118,-1.35799,.52197,52.47918,-1.29568,.51027,52.44635,-1.33777,.55727,52.49269,-1.37858,.45773,52.55586,-1.58336};
			return value;
		}
		private double[] getc7_Coord_9_79_point_8()
		{
			double[] value = {.4467,52.53829,-1.51857,.38691,52.361,-1.95304,.21838,52.5578,-1.57105,.21549,52.48932,-1.58799,.12908,52.45507,-1.59162,.07412,52.60889,-1.50663,.08436,52.7042,-1.46443,.32803,52.66806,-1.53833,.30154,52.66684,-1.52963,.32716,52.7174,-1.5143,.29871,52.69987,-1.50905,.29769,52.75477,-1.47184,.18665,52.78467,-1.43324,.21393,52.7954,-1.43883,.25657,52.75334,-1.47859,.20518,52.62826,-1.5392,.25714,52.6841,-1.51567,.56203,52.6094,-1.25952,.61042,52.58683,-1.27874,.40334,52.89583,-1.26424,.45001,52.8589,-1.23881,.42562,52.84776,-1.30501,.25321,52.76288,-1.36228,.27147,52.81111,-1.40736,.24323,52.8022,-1.42525,.0668,52.6448,-.92364,.14451,52.62301,-.92244,.14227,52.6413,-.93011,.33704,52.85142,-1.38759,.0919,52.76529,-1.42516,.09022,52.75872,-1.44054,.41583,52.36391,-1.28306,.40107,52.29433,-1.28284,.40324,52.31345,-1.31146,.5065,52.4433,-1.37754,.44822,52.42299,-1.37256,.25171,52.7363,-1.31183,.2676,52.73921,-1.30742,.3837,52.75694,-1.19092,.37788,52.79668,-1.18483,.35917,52.76285,-1.21216,.41458,52.74587,-1.15593,.41681,52.77652,-1.15002,.49646,52.48347,-1.42853,.49795,52.54518,-1.48133,.54339,52.55743,-1.53273,.53784,52.52611,-1.47066,.29265,52.33383,-1.99443,.33208,52.37811,-2.01555,.93399,52.84708,-1.45125,.37622,52.82779,-1.25735,.3438,52.82154,-1.29774,.38594,52.81816,-1.21367,.4077,52.82444,-1.16221,.28823,52.71873,-1.25076,.29695,52.76725,-1.2961,.28161,52.69618,-1.18234,.3193,52.69959,-1.18398,.21469,52.67478,-1.0538,.20491,52.68263,-1.0962,.13192,52.67582,-1.10225,.12692,52.67806,-1.03652,.12785,52.67614,-.99676,.50549,52.7587,-1.22513,.4824,52.79554,-1.17292,.48438,52.72298,-1.17632,.38088,52.64807,-1.10827,.30411,52.63341,-1.03089,.50517,52.62505,-1.1939,.5149,52.66315,-1.23245,1.06351,52.61515,-1.38497,1.06894,52.60992,-1.42104,1.07998,52.75509,-1.41511,1.09401,52.67372,-1.3978,.96623,52.7821,-1.41578,1.01816,52.73796,-1.41734,.35251,52.83925,-1.59308,.78633,52.84801,-1.40302,.79033,52.68968,-1.39162,.68876,52.83472,-1.42145,.85232,52.57613,-1.33715,.28004,52.81236,-1.42373,.32904,52.77394,-1.45515,.54487,52.7369,-1.42765,.09921,52.62492,-2.63033,.12326,52.65254,-2.7025,.10332,52.55143,-2.64393,.10971,52.59058,-2.54626,.07159,52.52568,-2.55853,.07346,52.55794,-2.71054,.05042,52.54417,-2.63124,.16093,52.66484,-2.75196,.12762,52.57356,-2.72067,.16123,52.67459,-2.83462,.15889,52.73841,-2.74667,.05912,52.72872,-2.54319,.08733,52.69,-2.5418,.07642,52.70852,-2.61982,.06022,52.73608,-2.3244,.09713,52.69898,-2.32249};
			return value;
		}
		private double[] getc7_Coord_9_79_point_9()
		{
			double[] value = {.06997,52.75251,-2.21746,.08846,52.76959,-2.129,.3189,52.57532,-2.08611,.23048,52.59353,-2.15554,.22676,52.62711,-2.1499,.34865,52.45363,-2.09161,.39448,52.55745,-2.02103,.43033,52.46362,-2.04062,.4728,52.54324,-1.96315,.45098,52.61261,-1.94103,.52074,52.55175,-1.94132,.78682,52.55572,-1.78078,.69534,52.63774,-1.77834,.44038,52.71341,-1.86924,.5063,52.64118,-1.8919,.27758,52.76504,-1.90286,.31273,52.77817,-1.83835,.40248,52.81349,-1.69443,.48553,52.7588,-1.69851,.45903,52.74685,-1.7758,.49917,52.76848,-1.68697,.59915,52.80764,-1.64108,.60226,52.77555,-1.68569,.49251,52.88921,-1.59715,.45848,52.89134,-1.6054,.6676,52.96625,-1.50735,.54207,53.01744,-1.47615,.65357,53.02597,-1.44146,.90545,52.82915,-1.54171,.93342,52.79964,-1.53993,.90746,52.79058,-1.56044,.25805,52.62549,-1.81246,.20354,52.58765,-1.90491,.25405,52.56383,-1.85767,.1131,52.35044,-1.36187,.06628,52.3176,-1.28738,.06259,52.34204,-1.35799,.17611,52.29222,-1.2433,.17868,52.32116,-1.3101,.20576,52.31781,-1.33615,.18998,52.25017,-1.25602,.32169,52.2198,-1.29015,.3106,52.18568,-1.23116,.16935,52.3662,-1.3822,.11145,52.38793,-1.42873,.1956,52.34941,-1.39451,.17721,52.35239,-1.43022,.29204,52.35541,-1.46513,.27472,52.38844,-1.56047,.28102,52.37832,-1.5256,.21875,52.38034,-1.55027,.33661,52.35135,-1.44773,.29189,52.33501,-1.43457,.14284,52.18382,-1.16492,.23193,52.18012,-1.19351,.25488,52.1945,-1.1218,.33555,52.28493,-1.1317,.25251,52.23847,-1.09033,.40029,52.32152,-1.20368,.53308,52.49642,-1.26467,.5632,52.50288,-1.3331,.42847,52.40734,-1.25479,.41064,52.39624,-1.36606,.39941,52.42746,-1.42464,.37008,52.37905,-1.38045,.39124,52.4523,-1.45342,.3667,52.39682,-1.4331,.34208,52.4385,-1.50446,.43063,52.46262,-1.42146,.41577,52.50777,-1.4738,.45566,52.5801,-1.63532,.04247,52.57095,-2.78106,.1137,52.6021,-2.83875,.06595,52.62173,-2.83317,.01127,52.53169,-2.55279,.01313,52.52417,-2.47993,.01481,52.49981,-2.41663,.02509,52.45863,-2.3619,.13536,52.36183,-2.17455,.15097,52.37492,-2.25545,.21192,52.35853,-2.17029,.11846,52.42026,-2.12823,.06483,52.46274,-2.15209,.06481,52.4997,-2.11496,.16398,52.41911,-2.06182,.50165,52.56122,-1.63152,.40553,52.50947,-1.81069,.46728,52.51958,-1.77874,.31947,52.3953,-1.93753,.26776,52.39534,-1.96209,.55892,52.45147,-1.80947,.4899,52.44401,-1.85351,.51005,52.39188,-1.90091,.25248,52.39686,-1.99109,.59967,52.46529,-1.96102,.52483,52.35875,-1.97804,.52685,52.44075,-1.99856,.65803,52.49054,-1.91411,.71335,52.51179,-1.86617,.67752,52.42236,-1.8539};
			return value;
		}
		private double[] getc7_Coord_9_79_point_10()
		{
			double[] value = {.62794,52.45894,-1.76503,.64258,52.42866,-1.81176,.64673,52.5345,-1.66415,.57759,52.51966,-1.67751,.60196,52.49122,-1.72461,.78268,52.69966,-1.66679,.78716,52.74652,-1.63738,.85587,52.74379,-1.60838,.86269,52.59072,-1.5576,.79262,52.57173,-1.53056,.80162,52.54934,-1.50221,.84469,52.50196,-1.37575,.75107,52.50432,-1.36654,.77071,52.50653,-1.42447,.85752,52.66468,-1.58397,.84074,52.69957,-1.62949,.98189,52.64709,-1.53214,1.00764,52.61444,-1.48395,.97303,52.60623,-1.51691,1.0415,52.74223,-1.5217,1.04792,52.66023,-1.50274,1.08778,52.67081,-1.46731,1.06419,52.61521,-1.45881,.16014,52.77955,-1.42793,.13484,52.72642,-1.46399,.09513,52.76478,-1.43645,.08138,52.64649,-1.9919,.34903,52.82706,-1.63079,.36321,52.75917,-1.64813,1.09875,52.67257,-1.42932,.9963,52.54153,-1.39941,.96401,52.56312,-1.46168,.93255,52.6317,-1.5551,.84563,52.62805,-1.58421,.91134,52.50921,-1.42922,.77434,52.65337,-1.70144,.69281,52.50691,-1.6694,.73745,52.56719,-1.54717,.61495,52.47508,-1.74646,.67244,52.44425,-1.77445,.70562,52.43488,-1.8066,.76241,52.46518,-1.74532,.58475,52.40385,-1.92827,.5734,52.41982,-1.86075,.52274,52.35566,-1.97071,.43853,52.36034,-1.94451,.42895,52.34064,-2.02753,.4342,52.42371,-1.88828,.29841,52.33644,-1.98701,.38669,52.56698,-1.55267,.32642,52.61311,-1.74571,.37739,52.69129,-1.66571,.32075,52.69477,-1.72044,.09717,52.4088,-2.30647,.11771,52.38362,-2.23729,.07419,52.68553,-2.8475,.33745,52.62331,-1.55022,.40349,52.61042,-1.58537,.33733,52.38469,-1.49851,.34708,52.36171,-1.44563,.58746,52.51034,-1.29896,.23214,52.39749,-1.03993,.15732,52.30003,-1.03017,.24659,52.32165,-1.05749,.0738,52.18934,-1.15124,.32641,52.37377,-1.49788,.06526,52.36301,-1.43846,.0698,52.34126,-1.51083,.15928,52.35065,-1.44492,.15657,52.37479,-1.41188,.31078,52.28583,-1.37931,.20688,52.27812,-1.28811,.32038,52.25793,-1.34761,.06473,52.40066,-1.59451,0.0,52.35863,-1.59377,0.0,52.40064,-1.58312,.13379,52.40634,-1.595,1.02522,52.78647,-1.47692,.86947,52.92731,-1.46385,.68722,52.80974,-1.63053,.35479,52.78383,-1.76868,.5726,52.68285,-1.80482,.57384,52.58578,-1.90384,.64681,52.61144,-1.85586,.43302,52.4072,-2.0438,.34009,52.71901,-1.9227,.24663,52.72224,-1.9712,.11856,52.81924,-1.92198,.10145,52.78376,-2.03627,0.0,52.83885,-1.91238,.21031,52.71803,-2.03933,.34586,52.6532,-2.00499,.29226,52.63569,-2.07491,.18739,52.62201,-2.22146,.06471,52.71748,-2.46961,.08774,52.65778,-2.462,.41843,52.78397,-1.48256,.42247,52.84444,-1.50674,.38899,52.76017,-1.50671,.59288,52.76963,-1.44406};
			return value;
		}
		private double[] getc7_Coord_9_79_point_11()
		{
			double[] value = {.64435,52.84125,-1.43048,.65838,52.79355,-1.43824,.72855,52.88404,-1.4032,.522,52.85644,-1.45513,.8062,52.97073,-1.44698,.92906,52.65858,-1.37636,.49427,52.53024,-1.20998,.47624,52.48356,-1.24295,.50314,52.59279,-1.19939,.31533,52.57024,-1.0338,.38701,52.51854,-1.14004,.24165,52.62201,-.9705,.23639,52.54626,-.9749,.52613,52.68748,-1.27981,.39066,52.72687,-1.15689,.26683,52.68106,-1.08925,.14461,52.75705,-2.81244,.12765,52.79703,-2.72425,.17458,52.23266,-1.23443,.1332,52.26465,-1.20052,.63109,52.69554,-1.44427,.61569,52.73573,-1.44115,.41596,52.8428,-1.14505,.44245,52.79491,-1.11875,.42367,52.85992,-1.12909,.32483,52.7961,-1.2952,.31128,52.80865,-1.33039,.13327,52.29185,-1.23303,.46916,52.40466,-1.30588,.34244,52.22831,-1.1514,.38179,52.88886,-1.28898,.40067,52.89212,-1.27166,.38239,52.87191,-1.34458,.46833,52.77617,-1.35946,.4872,52.76922,-1.30043,.34959,52.73636,-1.49258,.37203,52.75532,-1.47088,.22468,52.74629,-1.47479,.245,52.80053,-1.44457,.33131,52.58084,-1.54239,.36178,52.58741,-1.55906,.41278,52.89294,-1.21001,.42291,52.89544,-1.21497,.88358,52.75708,-1.41952,1.02884,52.66727,-1.37782,.9836,52.59882,-1.35314,.2671,52.73187,-1.78969,.10541,52.71178,-1.94878,.11275,52.74163,-1.94464,0.0,52.73138,-1.94755,.68459,52.90107,-1.40087,.61742,52.90035,-1.40497,.60457,52.55776,-1.27511,.55102,52.578,-1.22761,.54288,52.54351,-1.24276,.146,52.59699,-1.95325,.15495,52.64043,-1.93365,.25977,52.6865,-1.79352,.25346,52.49979,-1.90307,.27984,52.52793,-1.85242,.09164,52.4393,-2.14238,.18272,52.781,-1.89618,.23366,52.79618,-1.84866,0.0,52.83417,-1.90837,0.0,52.77869,-1.92673,.12334,52.78277,-1.92368,.25015,52.45342,-1.94022,.18995,52.80228,-1.89654,.13647,52.81162,-1.91106,.13803,52.81363,-1.91402,.70735,52.56677,-1.54291,.71285,52.55683,-1.51505,.65011,52.54381,-1.39049,.60574,52.53019,-1.40296,.7155,52.58384,-1.40156,.73591,52.63464,-1.4309,.71868,52.5906,-1.46602,.66701,52.74773,-1.43797,.64167,52.59584,-1.32238,.72496,52.61259,-1.36393,.73043,52.501,-1.39485,.71789,52.54768,-1.65383,.57291,52.54153,-1.45882,.74261,52.63819,-1.35779,.26127,52.38379,-1.97761,.24132,52.40502,-1.9807,.66334,52.49537,-1.70724,.77198,52.49078,-1.72259,.4141,52.39864,-2.051,.11381,52.80526,-2.72255,.28718,52.50329,-1.55454,.32119,52.54153,-1.53197,.04429,52.78062,-2.65073,0.0,52.7692,-2.64663,.13728,52.20824,-1.18114,.40459,52.6751,-1.93866,.33947,52.68621,-1.15781,.37324,52.66382,-1.11421,.27273,52.38175,-1.97153,.36588,52.89706,-1.62986};
			return value;
		}
		private double[] getc7_Coord_9_79_point_12()
		{
			double[] value = {.89942,52.83539,-1.54333,-.31728,52.75696,-1.7019,-.30154,52.66684,-1.53043,-.95646,52.69675,-1.53721,-.93255,52.6317,-1.557,-.86269,52.59072,-1.55957,-.71497,52.50341,-1.42476,-.69281,52.50691,-1.67132,-.66334,52.49537,-1.70911,-.67165,52.47581,-1.72737,-.58475,52.40385,-1.93004,-.52274,52.35566,-1.97239,-.42895,52.34064,-2.02894,-.60392,52.55665,-1.58246,-.38691,52.361,-1.95434,-.37744,52.31831,-2.00464,-.29841,52.33644,-1.98805,-.40553,52.50947,-1.81189,-.41577,52.50777,-1.47511,-.49795,52.54518,-1.48278,-.38669,52.56698,-1.5538,-.25405,52.56383,-1.8584,-.11575,52.48008,-2.06861,-.21192,52.35853,-2.17096,-.11846,52.42026,-2.12859,-.09717,52.4088,-2.30674,-.07381,52.50042,-2.47914,-.14272,52.59674,-2.84275,-.07419,52.68553,-2.84755,-.36601,52.44432,-1.88561,-.33496,52.44502,-1.89412,-.53784,52.52611,-1.47225,-.33745,52.62331,-1.55115,-.36178,52.58741,-1.56009,-.40349,52.61042,-1.58648,-.33733,52.38469,-1.49974,-.34708,52.36171,-1.44692,-.37476,52.30888,-1.38079,-.63215,52.51125,-1.32335,-.32485,52.3439,-1.11485,-.24659,52.32165,-1.06184,-.15732,52.30003,-1.03423,-.15902,52.373,-1.00691,-.24903,52.17398,-1.13797,-.0738,52.18934,-1.1517,-.1398,52.35234,-1.53635,-.0698,52.34126,-1.5111,-.06526,52.36301,-1.4387,-.28102,52.37832,-1.52664,-.32038,52.25793,-1.34892,-.20688,52.27812,-1.28896,-.07696,52.35753,-1.59909,-.13379,52.40634,-1.59549,-.06627,52.44678,-1.58414,-.86947,52.92731,-1.4649,-.72232,53.01745,-1.44036,-.54207,53.01744,-1.47683,-.3396,52.89944,-1.60975,-.57384,52.58578,-1.90525,-.78682,52.55572,-1.78267,-.52074,52.55175,-1.94268,-.43302,52.4072,-2.04512,-.24663,52.72224,-1.97174,-.34009,52.71901,-1.92345,-.10145,52.78376,-2.03647,-.11856,52.81924,-1.92221,-.21031,52.71803,-2.03978,-.23048,52.59353,-2.1561,-.18739,52.62201,-2.22188,-.06471,52.71748,-2.46969,-.05912,52.72872,-2.54325,-.43491,52.77764,-1.41235,-.46833,52.77617,-1.36047,-.59288,52.76963,-1.44528,-.72855,52.88404,-1.40431,-.8062,52.97073,-1.4479,-.47624,52.48356,-1.24445,-.49427,52.53024,-1.21144,-.4568,52.60957,-1.15574,-.43969,52.46896,-1.2115,-.23639,52.53345,-.9848,-.23085,52.46501,-1.01432,-.15374,52.44126,-.97631,-.309,52.486,-1.07409,-.30411,52.62571,-1.04041,-.52613,52.68748,-1.28107,-.45524,52.79601,-1.12056,-.43389,52.86205,-1.13214,-.0668,52.63065,-.93213,-.06038,52.65509,-.99236,-.41458,52.74587,-1.15688,-.43796,52.7375,-1.13041,-.35917,52.76285,-1.21297,-.3837,52.75694,-1.19179,-.12765,52.79703,-2.72432,-.1332,52.26465,-1.20182,-.17458,52.23266,-1.23517,-.61569,52.73573,-1.44248,-.63109,52.69554,-1.44571,-.42367,52.85992,-1.12987};
			return value;
		}
		private double[] getc7_Coord_9_79_point_13()
		{
			double[] value = {-.44245,52.79491,-1.11966,-.3669,52.88036,-1.32787,-.38179,52.88886,-1.28968,-.3438,52.82154,-1.29846,-.13327,52.29185,-1.23428,-.47398,52.45828,-1.26461,-.40067,52.89212,-1.27238,-.39388,52.89366,-1.26036,-.37203,52.75532,-1.47174,-.25714,52.6841,-1.51634,-.29871,52.69987,-1.50981,-.90959,52.81614,-1.41305,-1.07998,52.75509,-1.41666,-.54426,52.99952,-1.44145,-.11275,52.74163,-1.94488,-.68459,52.90107,-1.40192,-.36321,52.75917,-1.64894,-.37739,52.69129,-1.66664,-.32803,52.66806,-1.53919,-.70922,52.74761,-1.67473,-.77434,52.65337,-1.7031,-.56203,52.6094,-1.261,-.15495,52.64043,-1.93404,-.146,52.59699,-1.95364,-.32075,52.69477,-1.72122,-.16398,52.41911,-2.06234,-.11751,52.81558,-1.91824,-.13647,52.81162,-1.91133,-.12334,52.78277,-1.92393,-.18272,52.781,-1.89656,-.1866,52.79999,-1.89324,-.65011,52.54381,-1.39229,-.72551,52.56528,-1.484,-.71868,52.5906,-1.46782,-.66701,52.74773,-1.43934,-.56239,52.64631,-1.32219,-.6854,52.57874,-1.35977,-.72496,52.61259,-1.3657,-.69751,52.52807,-1.41748,-.70608,52.51505,-1.4249,-.71789,52.54768,-1.6557,-.71173,52.56264,-1.61771,-.74261,52.63819,-1.35952,-.26127,52.38379,-1.97848,-.76054,52.47324,-1.72196,-.76241,52.46518,-1.74741,-.77018,52.47052,-1.7498,-.77198,52.49078,-1.72465,-.04429,52.78062,-2.65077,-.04447,52.75437,-2.60879,-.23193,52.18012,-1.19452,-.13728,52.20824,-1.18181,-.44038,52.71341,-1.87021,-.37324,52.66382,-1.11656,-.39066,52.72687,-1.15783,-.35992,52.90308,-1.62813,-.35178,52.89586,-1.63717,-.89942,52.83539,-1.54463,-.41681,52.77652,-1.15091,-.32641,52.37377,-1.49908,-.43594,52.38872,-2.04168,-.78792,52.79148,-1.61397,-.36856,52.74345,-1.19037,-.32119,52.54153,-1.53296,-.18312,52.7371,-1.47026,-.16014,52.77955,-1.4283,-.43063,52.46262,-1.42288,0.0,52.76419,-2.60211,-.12244,52.79782,-2.71932,-.11381,52.80526,-2.72261,-.4141,52.39864,-2.05227,-.72371,52.4912,-1.68457,-.73326,52.63233,-1.37199,-.33703,52.54451,-1.79377,-.65839,52.56482,-1.53893,-.67548,52.71472,-1.44078,-.65039,52.51837,-1.40192,-.31218,52.87371,-1.67883,-.09164,52.4393,-2.14265,-.27984,52.52793,-1.85324,-.25977,52.6865,-1.79416,-.07274,52.60031,-2.02795,-.32642,52.61311,-1.74659,-.28224,52.78577,-1.34695,-.4872,52.76922,-1.30148,-.09513,52.76478,-1.43667,-.54047,52.66105,-1.3729,-.33828,52.7769,-1.25299,-.20491,52.67264,-1.10124,-.5149,52.66315,-1.23373,-.24165,52.60261,-.98401,-.1457,52.52638,-.9458,-.85232,52.57613,-1.33917,-.79027,52.95683,-1.41337,-.53576,52.89553,-1.43902,-.78633,52.84801,-1.40427,-.08774,52.65778,-2.46213,-.17808,52.71451,-2.12734,-.34586,52.6532,-2.0058,0.0,52.81892,-2.0281};
			return value;
		}
		private double[] getc7_Coord_9_79_point_14()
		{
			double[] value = {-.39448,52.55745,-2.02206,-.31273,52.77817,-1.839,-.59915,52.80764,-1.6422,-1.02522,52.78647,-1.47837,-1.03935,52.79306,-1.4528,-.06473,52.40066,-1.59475,-.31078,52.28583,-1.38056,-.12343,52.34716,-1.47476,-.23214,52.39747,-1.04657,-.58746,52.51034,-1.30069,-.13647,52.53791,-1.99448,-.96401,52.56312,-1.46383,-.43853,52.36034,-1.94597,-.61495,52.47508,-1.74825,-.75514,52.56514,-1.58818,.43594,52.38872,-2.04032,.36856,52.74345,-1.18952,.18312,52.7371,-1.46981,.77018,52.47052,-1.74771,.76054,52.47324,-1.71988,.73326,52.63233,-1.37026,.33703,52.54451,-1.79279,.64324,52.58515,-1.29132,.63407,52.56186,-1.2903,.68438,52.58629,-1.30679,.72551,52.56528,-1.48213,.11751,52.81558,-1.91801,.1866,52.79999,-1.89286,.02484,52.54959,-2.72182,.20017,52.52751,-1.94553,.04121,52.44008,-2.28637,.07274,52.60031,-2.02776,.70585,52.69337,-1.72381,.39388,52.89366,-1.25966,.1398,52.35234,-1.53582,.28224,52.78577,-1.34632,.39673,52.25611,-1.22551,.47398,52.45828,-1.26307,.38685,52.85973,-1.25366,.33828,52.7769,-1.25223,.43796,52.7375,-1.12942,.43389,52.86205,-1.13134,.45524,52.79601,-1.11962,.309,52.4862,-1.06764,.43969,52.46896,-1.21008,.53576,52.89553,-1.43812,.43491,52.77764,-1.4114,.07736,52.78915,-2.65469,.17808,52.71451,-2.12697,.49613,52.81324,-1.64594,.57923,52.95508,-1.51687,.06627,52.44678,-1.5839,.07696,52.35753,-1.59879,.12497,52.32001,-1.29945,.12343,52.34716,-1.47428,.15064,52.16456,-1.10113,.24903,52.17398,-1.13689,.15902,52.37335,-1.00102,.32485,52.3439,-1.11255,.37476,52.30888,-1.37934,.33496,52.44502,-1.89306,.36601,52.44432,-1.88446,.07381,52.50042,-2.47901,.39267,52.65033,-1.67516,.43335,52.58942,-1.58021,.44566,52.31725,-2.00182,.95646,52.69675,-1.53549,.1331,52.61902,-1.5194,.19981,52.65683,-1.51678,.82442,52.49424,-1.42159,.70825,52.43761,-1.81547,.58967,52.40794,-1.93502,.4627,52.5586,-1.69894,.0201,52.53955,-2.63353,.08472,52.56486,-2.75048,.41665,52.60653,-1.63413,.24457,52.16897,-1.15038,.22517,52.37625,-1.58784,.2082,52.6338,-1.88867,.1464,52.7077,-2.20533,.05394,52.73837,-2.38473,.77154,52.7263,-1.40099,.54426,52.99952,-1.44073,.45341,52.73571,-1.12935,.40131,52.861,-1.21153,.34188,52.83687,-1.31693,.06265,52.72347,-1.34498,.06835,52.72637,-1.34986,0.0,52.75213,-1.43401,.05663,52.60035,-.92329,.13782,52.54329,-1.55451,.49435,52.54183,-1.55985,.68499,52.51241,-1.34549,.76635,52.91355,-1.39707,.44112,52.91081,-1.50877,.39253,52.65317,-1.62003,.30228,52.5474,-1.82083,.63232,52.5632,-1.53334,.77877,52.52266,-1.46403,.57399,52.66704,-1.41259};
			return value;
		}
		private double[] getc7_Coord_9_79_point_15()
		{
			double[] value = {.64324,52.56428,-1.37135,.59067,52.56654,-1.43259,.30687,52.50424,-1.84489,.08089,52.7907,-2.65905,.38741,52.21416,-1.24101,.37706,52.20638,-1.24749,.38786,52.21901,-1.2499,-.67244,52.44425,-1.77642,-.70825,52.43761,-1.8175,-.55892,52.45147,-1.81116,-.06481,52.4997,-2.11514,-.40324,52.31345,-1.313,-.25251,52.23847,-1.09183,-.06628,52.3176,-1.28792,-.08846,52.76959,-2.12917,-.05394,52.73837,-2.3848,-.11011,52.63998,-2.37922,-.11192,52.56259,-2.46371,-.12258,52.54337,-2.39126,-.83618,52.70183,-1.39204,0.0,52.43518,-.96528,-.45341,52.73571,-1.13037,-.33208,52.37811,-2.01663,-.29265,52.33383,-1.99545,-.3678,52.31678,-2.01325,-.25171,52.7363,-1.31245,-.40107,52.29433,-1.2844,-.42291,52.89544,-1.21571,-.07412,52.60889,-1.50685,-.13782,52.54329,-1.55494,-.51763,52.54355,-1.67756,-.17358,52.7441,-1.9122,-.39253,52.65317,-1.62105,-.30228,52.5474,-1.82171,-.77877,52.52266,-1.4661,-.57399,52.66704,-1.41398,-.59331,52.54542,-1.44849,-.58324,52.52489,-1.42454,-.27751,52.45114,-1.91432,-.38303,52.52994,-1.53142,-.38786,52.21901,-1.25151,-.37706,52.20638,-1.24907,-.38741,52.21416,-1.24262,-.2248,52.38396,-1.59769,-.35717,52.55539,-1.5374,-.28061,52.39938,-1.56797,-.38232,52.25606,-1.34058,-.39286,52.26449,-1.33505,-.0817,52.70845,-2.38202,-.13373,52.76208,-2.81961,-.54691,52.47756,-1.78067,-.4342,52.42371,-1.88965,-.41986,52.46659,-1.85088,-.51971,52.53964,-1.68525,-.70562,52.43488,-1.80863,-.66118,52.55983,-1.60595,-.61954,52.59048,-1.48664,-.59881,52.64171,-1.45245,-.59389,52.58578,-1.46111,-.59746,52.56594,-1.47598,-.06119,52.7915,-2.74912,0.0,52.75353,-2.82568,-.07118,52.75808,-2.82072,0.0,52.77611,-2.78074,-.06814,52.54178,-2.07901,-.41665,52.60653,-1.63527,-.39267,52.65033,-1.67617,-.91817,52.71938,-1.4185,-.47859,52.48179,-1.8188,-.22869,52.43538,-1.59618,-.07627,52.53264,-1.54372,-.29854,52.83447,-1.39026,-.35358,52.79295,-1.4372,-.41278,52.89294,-1.21074,-.64333,53.01026,-1.40985,0.0,52.69877,-1.29393,-.06537,52.70275,-1.28798,-.13209,52.68106,-1.19475,-.21205,52.68981,-1.18293,0.0,52.63928,-.93183,0.0,52.65707,-.99398,-.29381,52.64164,-1.04664,-.05541,52.52408,-.94122,-.31338,52.42131,-1.10059,-1.0966,52.74845,-1.44517,-1.09875,52.67257,-1.43114,-.69955,52.93172,-1.39269,-.61511,52.9227,-1.40277,-.71235,52.99997,-1.40529,-.37451,52.8109,-1.421,-.40023,52.83618,-1.3747,-.04429,52.78433,-2.67318,0.0,52.75811,-2.48499,-.04664,52.739,-2.54058,-.05146,52.73116,-2.47306,0.0,52.75917,-2.55836,-.12788,52.63416,-2.32379,-.20566,52.49636,-2.23637,-.24989,52.45029,-2.16591,-.68677,52.8766,-1.58713};
			return value;
		}
		private double[] getc7_Coord_9_79_point_16()
		{
			double[] value = {-.59346,52.87415,-1.58573,0.0,52.60986,-2.05156,-.06699,52.29487,-1.22894,-.06833,52.25445,-1.18354,0.0,52.20559,-1.16418,0.0,52.26073,-1.18618,-.06852,52.20936,-1.16655,-.33661,52.35135,-1.44899,-.33612,52.17506,-1.20412,-.06254,52.21451,-1.05727,0.0,52.27496,-1.03178,-.06532,52.28576,-1.03267,0.0,52.21421,-1.05484,-.15528,52.22039,-1.0665,-.53489,52.50366,-1.74988,.35717,52.55539,-1.53632,.28061,52.39938,-1.56696,.38232,52.25606,-1.33903,.39286,52.26449,-1.33347,.04664,52.739,-2.54053,.54691,52.47756,-1.77905,.47859,52.48179,-1.81737,.63955,52.64969,-1.46679,.59746,52.56594,-1.47434,.59389,52.58578,-1.45951,0.0,52.7766,-2.69153,.04429,52.78433,-2.67314,.39447,52.77428,-1.44921,.13647,52.53791,-1.99409,.06814,52.54178,-2.07882,.69955,52.93172,-1.3917,.71235,52.99997,-1.40446,.41986,52.46659,-1.84959,.53489,52.50366,-1.74832,0.0,52.52138,-1.5364,.07627,52.53264,-1.54347,0.0,52.44441,-1.57115,.29854,52.83447,-1.38964,.35358,52.79295,-1.43643,.19011,52.78673,-1.41434,.21739,52.79746,-1.41994,.15704,52.74335,-1.34804,.15415,52.73216,-1.32533,.06595,52.67957,-1.20072,.06485,52.67147,-1.11477,.13209,52.68274,-1.19139,.06537,52.70275,-1.28713,.21205,52.69107,-1.17883,.06038,52.66655,-.98729,.29381,52.65035,-1.03714,.1457,52.54291,-.93895,.05541,52.53176,-.93923,.15374,52.44797,-.97163,.06251,52.43909,-.96631,.23085,52.46926,-1.00717,.83618,52.70183,-1.39037,.91817,52.71938,-1.41683,.64333,53.01026,-1.40908,.61511,52.9227,-1.40183,.40023,52.83618,-1.3739,.12258,52.54337,-2.39103,.07529,52.47544,-2.41286,.11192,52.56259,-2.46352,.11011,52.63998,-2.37904,.15051,52.52714,-2.331,.20566,52.49636,-2.23583,.12788,52.63416,-2.32356,.24989,52.45029,-2.16519,.68677,52.8766,-1.58605,.59346,52.87415,-1.58474,.06699,52.29487,-1.22804,.06833,52.25445,-1.18263,.06852,52.20936,-1.16598,.36433,52.29988,-1.38429,0.0,52.18919,-1.15045,0.0,52.15262,-1.11479,.05977,52.35511,-1.00104,.06532,52.28576,-1.03073,.15528,52.22039,-1.06459,0.0,52.54707,-2.09845,.51971,52.53964,-1.68377,.66118,52.55983,-1.60419,.21156,52.68123,-1.87449,.60392,52.55665,-1.58081,.57643,52.5241,-1.66882,.5419,52.54586,-1.60906,.51763,52.54355,-1.67609,.11575,52.48008,-2.06827,.08422,52.42368,-2.3553,0.0,52.63789,-2.82916,.34082,52.17958,-1.19029,.06254,52.21451,-1.05623,0.0,52.15607,-1.10164,.22869,52.43538,-1.59539,.0817,52.70845,-2.3819,.05146,52.73116,-2.473,.72232,53.01745,-1.43957,.23289,52.64022,-.97697,.06515,52.67448,-1.0489,.14827,52.70939,-1.27797};
			return value;
		}
		private double[] getc7_Coord_9_79_point_17()
		{
			double[] value = {.23549,52.7122,-1.26493,.15822,52.78097,-1.40853,.58104,52.56335,-1.49207,.30694,52.83566,-1.40588,.37451,52.8109,-1.42021,.06119,52.7915,-2.74908,.61954,52.59048,-1.48501,.59881,52.64171,-1.45096,.59522,52.58689,-1.36889,.67492,52.4183,-1.84508,.98732,52.77171,-1.53216,.13373,52.76208,-2.81953,-.21156,52.68123,-1.87501,-1.09221,52.74035,-1.48446,-.98732,52.77171,-1.53366,-.07529,52.47544,-2.41302,-.08422,52.42368,-2.35551,-.34082,52.17958,-1.19175,-.36433,52.29988,-1.38572,0.0,52.30038,-1.23467,0.0,52.31711,-1.29159,0.0,52.34077,-1.3639,-.06515,52.66527,-1.05039,-.06485,52.66572,-1.11526,-.14827,52.70939,-1.2794,-.23549,52.7122,-1.26605,-.15415,52.73216,-1.32573,-.15704,52.74335,-1.34842,-.15822,52.78097,-1.4089,-.57291,52.54153,-1.46046,-.58104,52.56335,-1.49368,-.23289,52.61942,-.99041,0.0,52.70376,-2.84966,-.59522,52.58689,-1.37049,-.67492,52.4183,-1.84707,-.30694,52.83566,-1.40651,0.0,52.58962,-.93093,0.0,52.34044,-1.51619,0.0,52.35849,-1.43803,-.15051,52.52714,-2.33133,-.06595,52.67844,-1.20263,0.0,52.67502,-1.20989,0.0,52.66582,-1.12526,0.0,52.5271,-.93942,.33612,52.17506,-1.20266,.07118,52.75808,-2.82068,.31338,52.42131,-1.09592,0.0,52.66423,-1.05686};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getc7disc_Geo_8_84_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,36,40,-1,41,42,43,-1,33,44,31,-1,34,45,46,-1,28,27,47,-1,48,6,49,-1,50,51,52,-1,53,5,4,-1,54,55,56,-1,57,58,59,-1,10,9,60,-1,61,62,63,-1,64,65,66,-1,67,68,69,-1,70,71,15,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,79,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,77,76,104,-1,78,105,93,-1,106,107,108,-1,109,110,111,-1,112,113,114,-1,115,114,113,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,121,114,109,-1,124,125,126,-1,124,111,110,-1,127,128,129,-1,130,124,131,-1,132,126,84,-1,133,107,134,-1,135,136,83,-1,93,137,138,-1,139,137,96,-1,140,141,88,-1,142,2,143,-1,144,145,146,-1,91,147,89,-1,148,149,150,-1,151,152,153,-1,72,17,154,-1,155,133,156,-1,157,29,28,-1,126,122,121,-1,109,114,129,-1,158,120,159,-1,160,112,118,-1,115,161,162,-1,163,164,160,-1,157,165,127,-1,28,47,166,-1,145,100,99,-1,167,168,102,-1,135,169,104,-1,137,93,105,-1,170,138,137,-1,141,92,91,-1,171,172,173,-1,82,81,174,-1,79,175,176,-1,177,76,153,-1,144,130,131,-1,131,178,144,-1,179,73,180,-1,72,74,181,-1,182,68,18,-1,65,64,183,-1,184,3,185,-1,186,62,61,-1,181,60,9,-1,187,188,64,-1,55,0,56,-1,50,5,53,-1,189,190,191,-1,192,193,51,-1,68,182,194,-1,183,64,188,-1,195,196,197,-1,198,199,200,-1,36,39,198,-1,201,202,43,-1,39,40,203,-1,40,36,38,-1,31,203,204,-1,31,45,34,-1,30,24,46,-1,205,41,35,-1,24,197,196,-1,30,32,206,-1,207,23,208,-1,209,19,210,-1,13,12,66,-1,184,211,4,-1,59,54,188,-1,55,54,58,-1,212,10,213,-1,214,212,213,-1,58,215,55,-1,59,188,187,-1,4,3,184,-1,13,66,216,-1,217,20,19,-1,19,209,217,-1,207,208,200,-1,206,218,30,-1,196,25,24,-1,35,219,205,-1,30,46,45,-1,30,197,24,-1,34,33,31,-1,204,32,31,-1,38,220,40,-1,203,44,39,-1,43,42,201,-1,221,39,222,-1,27,205,223,-1,199,207,200,-1,188,56,183,-1,182,53,194,-1,193,52,51,-1,191,49,189,-1,50,53,51,-1,0,224,56,-1,64,225,187,-1,70,181,9,-1,212,226,10,-1,226,11,10,-1,218,8,195,-1,3,63,185,-1,183,227,65,-1,68,67,18,-1,15,72,181,-1,90,179,180,-1,76,75,153,-1,175,228,176,-1,229,82,174,-1,88,141,91,-1,139,170,137,-1,105,96,137,-1,135,230,169,-1,168,103,102,-1,99,146,145,-1,157,28,166,-1,158,106,160,-1,115,162,116,-1,160,113,112,-1,106,231,163,-1,114,115,129,-1,121,111,126,-1,165,128,127,-1,155,108,133,-1,73,72,154,-1,153,75,151,-1,88,91,89,-1,146,86,144,-1,95,142,143,-1,87,140,88,-1,232,139,96,-1,138,94,93,-1,135,83,82,-1,233,234,235,-1,133,108,107,-1,132,122,126,-1,130,125,124,-1,117,127,129,-1,124,126,111,-1,121,109,111,-1,121,123,112,-1,118,120,158,-1,160,118,158,-1,117,129,115,-1,115,113,161,-1,114,121,112,-1,160,106,163,-1,231,106,108,-1,85,125,130,-1,79,78,93,-1,77,104,169,-1,236,101,103,-1,173,98,100,-1,96,105,97,-1,175,79,94,-1,179,90,92,-1,178,87,89,-1,237,229,174,-1,83,238,81,-1,79,176,80,-1,77,239,75,-1,73,179,74,-1,15,181,70,-1,69,12,67,-1,225,64,66,-1,63,3,61,-1,240,190,241,-1,60,213,10,-1,58,54,59,-1,54,56,188,-1,4,194,53,-1,242,50,52,-1,48,49,191,-1,27,243,47,-1,39,221,198,-1,44,203,31,-1,41,43,35,-1,198,221,199,-1,35,43,33,-1,30,45,31,-1,223,205,219,-1,24,26,223,-1,38,63,220,-1,38,185,63,-1,207,21,23,-1,72,15,17,-1,12,14,67,-1,71,241,209,-1,241,217,209,-1,14,18,67,-1,14,19,18,-1,11,244,9,-1,6,48,7,-1,5,61,3,-1,142,0,2,-1,215,0,55,-1,0,215,1,-1,186,242,245,-1,50,242,186,-1};
			return value;
		}
		private int[] getc7disc_Geo_8_84_coordIndex_2()
		{
			int[] value = {216,246,13,-1,247,246,216,-1,248,246,247,-1,248,249,246,-1,248,250,249,-1,251,252,210,-1,253,252,251,-1,210,16,209,-1,210,252,16,-1,37,208,254,-1,200,208,37,-1,206,204,62,-1,204,206,32,-1,223,46,24,-1,219,46,223,-1,202,255,222,-1,201,255,202,-1,33,202,44,-1,33,43,202,-1,199,21,207,-1,199,256,21,-1,56,257,183,-1,257,56,224,-1,53,192,51,-1,182,192,53,-1,0,258,224,-1,0,142,258,-1,259,181,74,-1,181,259,60,-1,7,11,226,-1,7,48,11,-1,1,260,2,-1,1,22,260,-1,184,254,57,-1,184,185,254,-1,261,182,18,-1,192,182,261,-1,212,25,226,-1,212,26,25,-1,62,245,206,-1,186,245,62,-1,262,236,98,-1,236,262,263,-1,86,132,84,-1,86,264,132,-1,144,85,130,-1,144,86,85,-1,153,175,177,-1,175,153,228,-1,139,265,170,-1,139,134,265,-1,147,145,89,-1,145,147,100,-1,170,136,138,-1,170,83,136,-1,230,102,169,-1,230,167,102,-1,258,266,267,-1,266,258,97,-1,155,231,108,-1,268,231,155,-1,269,116,162,-1,116,269,270,-1,271,272,273,-1,272,271,274,-1,268,163,231,-1,163,268,273,-1,166,165,157,-1,275,165,166,-1,265,120,238,-1,265,159,120,-1,150,176,228,-1,149,176,150,-1,276,73,154,-1,180,73,276,-1,233,276,234,-1,233,277,276,-1,234,151,235,-1,234,278,151,-1,279,280,281,-1,280,279,282,-1,283,284,278,-1,284,283,281,-1,282,285,280,-1,286,285,282,-1,264,146,168,-1,146,264,86,-1,95,232,96,-1,95,143,232,-1,82,230,135,-1,230,82,229,-1,176,148,80,-1,148,176,149,-1,281,148,284,-1,280,148,281,-1,287,278,234,-1,287,283,278,-1,154,234,276,-1,234,154,287,-1,233,288,263,-1,235,288,233,-1,235,239,288,-1,238,119,81,-1,238,120,119,-1,126,85,84,-1,85,126,125,-1,110,165,124,-1,110,128,165,-1,289,290,271,-1,256,290,289,-1,272,163,273,-1,163,272,164,-1,113,164,161,-1,113,160,164,-1,141,291,292,-1,140,291,141,-1,76,293,104,-1,76,177,293,-1,98,103,99,-1,98,236,103,-1,94,177,175,-1,177,94,293,-1,147,90,171,-1,90,147,91,-1,232,134,139,-1,232,133,134,-1,80,266,78,-1,266,80,285,-1,47,140,166,-1,47,291,140,-1,101,263,288,-1,101,236,263,-1,71,240,241,-1,70,240,71,-1,243,212,214,-1,212,243,26,-1,294,190,189,-1,190,294,241,-1,267,295,257,-1,267,286,295,-1,23,1,215,-1,1,23,22,-1,48,244,11,-1,48,191,244,-1,211,57,59,-1,184,57,211,-1,242,49,6,-1,242,52,49,-1,296,41,205,-1,296,297,41,-1,297,42,41,-1,297,270,42,-1,201,274,255,-1,269,274,201,-1,36,200,37,-1,36,198,200,-1,34,219,35,-1,219,34,46,-1,62,220,63,-1,220,62,204,-1,298,22,21,-1,260,22,298,-1,13,251,14,-1,13,246,251,-1,20,294,299,-1,20,241,294,-1,241,20,217,-1,17,252,300,-1,252,17,16,-1,227,250,248,-1,227,295,250,-1,295,282,250,-1,295,286,282,-1,6,245,242,-1,6,8,245,-1,273,289,271,-1,273,268,289,-1,50,61,5,-1,186,61,50,-1,191,240,244,-1,190,240,191,-1,246,253,251,-1,246,249,253,-1,250,279,249,-1,250,282,279,-1,14,210,19,-1,251,210,14,-1,15,209,16,-1,15,71,209,-1,65,216,66,-1,65,247,216,-1,38,254,185,-1,37,254,38,-1,223,243,27,-1,223,26,243,-1,221,256,199,-1,221,290,256,-1,221,255,290,-1,221,222,255,-1,222,44,202,-1,44,222,39,-1,257,258,267,-1,257,224,258,-1,194,211,301,-1,4,211,194,-1,292,60,259,-1,292,213,60,-1,254,58,57,-1,58,254,208,-1,225,12,69,-1,225,66,12,-1,195,7,196,-1,8,7,195,-1,206,8,218,-1,245,8,206,-1,193,294,189,-1,193,299,294,-1,264,174,132,-1,264,237,174,-1,131,87,178,-1,87,131,275,-1,77,288,239,-1,77,101,288,-1,265,83,170,-1,83,265,238,-1,260,143,2,-1,143,260,156,-1,89,144,178,-1,144,89,145,-1,179,259,74,-1,179,92,259,-1,258,95,97,-1,142,95,258,-1,101,169,102,-1,101,77,169,-1,266,105,78,-1,266,97,105,-1,256,298,21,-1,256,289,298,-1,117,296,127,-1,296,117,297,-1,116,297,117,-1,270,297,116,-1,274,162,272,-1,274,269,162,-1,118,123,119,-1,112,123,118,-1,124,275,131,-1,124,165,275,-1,123,132,174,-1};
			return value;
		}
		private int[] getc7disc_Geo_8_84_coordIndex_3()
		{
			int[] value = {123,122,132,-1,134,159,265,-1,134,107,159,-1,180,277,172,-1,180,276,277,-1,75,235,151,-1,235,75,239,-1,283,300,302,-1,283,287,300,-1,281,302,279,-1,281,283,302,-1,284,150,152,-1,150,284,148,-1,168,237,264,-1,168,167,237,-1,138,293,94,-1,136,293,138,-1,229,167,230,-1,229,237,167,-1,171,100,147,-1,171,173,100,-1,152,228,153,-1,152,150,228,-1,280,80,148,-1,80,280,285,-1,287,17,300,-1,287,154,17,-1,262,233,263,-1,172,233,262,-1,172,277,233,-1,278,152,151,-1,284,152,278,-1,156,298,155,-1,156,260,298,-1,119,174,81,-1,119,123,174,-1,128,109,129,-1,128,110,109,-1,107,158,159,-1,158,107,106,-1,272,161,164,-1,272,162,161,-1,127,29,157,-1,29,127,296,-1,99,168,146,-1,168,99,103,-1,136,104,293,-1,136,135,104,-1,92,292,259,-1,141,292,92,-1,143,133,232,-1,143,156,133,-1,285,267,266,-1,267,285,286,-1,173,262,98,-1,173,172,262,-1,87,166,140,-1,87,275,166,-1,171,180,172,-1,171,90,180,-1,299,192,261,-1,193,192,299,-1,214,47,243,-1,47,214,291,-1,226,196,7,-1,226,25,196,-1,257,227,183,-1,257,295,227,-1,208,215,58,-1,215,208,23,-1,70,244,240,-1,70,9,244,-1,69,187,225,-1,69,301,187,-1,52,189,49,-1,193,189,52,-1,301,68,194,-1,69,68,301,-1,291,213,292,-1,291,214,213,-1,29,205,27,-1,29,296,205,-1,42,269,201,-1,42,270,269,-1,255,271,290,-1,255,274,271,-1,204,40,220,-1,204,203,40,-1,195,30,218,-1,195,197,30,-1,299,18,20,-1,299,261,18,-1,300,253,302,-1,253,300,252,-1,302,249,279,-1,253,249,302,-1,248,65,227,-1,248,247,65,-1,301,59,187,-1,301,211,59,-1,298,268,155,-1,268,298,289,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getc7disc_Coord_9_84_point_1()
		{
			double[] value = {.07392,52.11133,-1.11317,.06861,52.14787,-1.11244,0.0,52.14527,-1.11372,.38541,52.25048,-1.3439,.39794,52.23356,-1.37168,.38895,52.28411,-1.42072,.3528,52.359,-1.53088,.27782,52.38471,-1.56661,.332,52.37017,-1.50223,.16988,52.3294,-1.63175,.15673,52.33658,-1.6239,.25481,52.35791,-1.61572,.35833,52.15322,-1.34968,.27875,52.14031,-1.31601,.31195,52.1808,-1.42069,.08717,52.24849,-1.61279,.07944,52.22656,-1.58798,0.0,52.22124,-1.57255,.39123,52.24098,-1.47551,.32033,52.22274,-1.4969,.31118,52.26331,-1.55409,.0738,52.18934,-1.15124,.06842,52.16009,-1.1178,.14822,52.16355,-1.1207,.21875,52.38034,-1.55027,.22388,52.37707,-1.58026,.13884,52.35623,-1.58205,.07216,52.34378,-1.54084,0.0,52.34139,-1.54476,0.0,52.34201,-1.54245,.29204,52.35541,-1.46513,.1956,52.34941,-1.39451,.29189,52.33501,-1.43457,.16935,52.3662,-1.3822,.15657,52.37479,-1.41188,.11145,52.38793,-1.42873,.18998,52.25017,-1.25602,.3106,52.18568,-1.23116,.32169,52.2198,-1.29015,.17611,52.29222,-1.2433,.20688,52.27812,-1.28811,.06526,52.36301,-1.43846,.06259,52.34204,-1.35799,.1131,52.35044,-1.36187,.17868,52.32116,-1.3101,.17721,52.35239,-1.43022,.15928,52.35065,-1.44492,0.0,52.34759,-1.56923,.29233,52.3673,-1.5953,.35881,52.34961,-1.54893,.38983,52.29134,-1.42429,.39415,52.27669,-1.4403,.37772,52.32394,-1.50235,.39564,52.27111,-1.43572,.24987,52.12846,-1.16428,.16195,52.11778,-1.12001,.17146,52.10077,-1.12962,.33178,52.16973,-1.21044,.24552,52.16175,-1.15285,.32942,52.14134,-1.22513,.07769,52.29495,-1.61846,.36847,52.29723,-1.39042,.35713,52.29799,-1.38363,.37468,52.25514,-1.33912,.2471,52.09153,-1.20193,.24074,52.08941,-1.21227,.29973,52.1144,-1.26472,.38341,52.20252,-1.42496,.39238,52.20876,-1.41757,.36879,52.15693,-1.34162,.19038,52.30366,-1.64344,.19341,52.29136,-1.64016,0.0,52.23268,-1.59794,-.08717,52.24849,-1.61316,0.0,52.24321,-1.60557,-.38341,52.20252,-1.42658,-.39238,52.20876,-1.41922,-.39821,52.24883,-1.46977,-.17634,52.07075,-1.15442,-.2471,52.09153,-1.20309,-.17413,52.06825,-1.1653,-.37468,52.25514,-1.34064,-.38541,52.25048,-1.34546,-.37199,52.20107,-1.25801,-.3201,52.3704,-1.49305,-.31128,52.37529,-1.50827,-.332,52.37017,-1.50345,-.13963,52.3517,-1.59612,-.15673,52.33658,-1.62451,-.25481,52.35791,-1.61667,-.19038,52.30366,-1.64419,-.16988,52.3294,-1.63241,-.07769,52.29495,-1.61878,-.25358,52.11605,-1.17691,-.32604,52.13266,-1.23352,-.07392,52.11133,-1.11352,-.16195,52.11778,-1.12075,-.07806,52.09247,-1.1196,-.3673,52.32282,-1.57589,-.35881,52.34961,-1.55026};
			return value;
		}
		private double[] getc7disc_Coord_9_84_point_2()
		{
			double[] value = {-.29442,52.35475,-1.61049,-.39544,52.25446,-1.47723,-.39415,52.27669,-1.44186,-.37772,52.32394,-1.50379,-.39983,52.22703,-1.38829,-.17146,52.10077,-1.13041,-.17458,52.23266,-1.23517,-.23193,52.18012,-1.19452,-.14284,52.18382,-1.16555,-.15657,52.37479,-1.41247,-.15928,52.35065,-1.44553,-.17721,52.35239,-1.4309,-.20576,52.31781,-1.33697,-.17868,52.32116,-1.31081,-.16935,52.3662,-1.38284,-.1131,52.35044,-1.3623,-.06259,52.34204,-1.35824,-.06526,52.36301,-1.4387,-.20688,52.27812,-1.28896,-.32038,52.25793,-1.34892,-.32169,52.2198,-1.2915,-.1956,52.34941,-1.39526,-.29189,52.33501,-1.43569,-.31078,52.28583,-1.38056,-.21875,52.38034,-1.55108,-.28102,52.37832,-1.52664,-.29204,52.35541,-1.46623,-.0698,52.34126,-1.5111,-.12343,52.34716,-1.47476,-.11145,52.38793,-1.42915,-.26999,52.38679,-1.5555,-.22388,52.37707,-1.58109,-.32987,52.34889,-1.44699,-.14822,52.16355,-1.12136,-.24118,52.17121,-1.15788,-.39794,52.23356,-1.37332,-.37879,52.17861,-1.28881,-.24987,52.12846,-1.16541,-.32942,52.14134,-1.2266,-.24552,52.16175,-1.15393,-.07811,52.34047,-1.59482,-.07964,52.31076,-1.61408,0.0,52.10833,-1.10837,-.06861,52.14787,-1.11275,-.27782,52.38471,-1.56762,-.29233,52.3673,-1.59638,-.3528,52.359,-1.53219,-.27507,52.35076,-1.62136,-.18444,52.09206,-1.2115,-.22782,52.10538,-1.23717,-.26897,52.12522,-1.27515,-.31195,52.1808,-1.42206,-.27875,52.14031,-1.31727,-.35833,52.15322,-1.35126,-.07944,52.22656,-1.58832,-.0738,52.18934,-1.1517,-.06842,52.16009,-1.11812,-.07216,52.34378,-1.54112,-.18998,52.25017,-1.25681,-.3106,52.18568,-1.23251,-.17611,52.29222,-1.24432,-.12497,52.32001,-1.30005,-.06628,52.3176,-1.28792,-.1332,52.26465,-1.20182,-.13327,52.29185,-1.23428,-.1398,52.35234,-1.53635,-.07849,52.3463,-1.58296,-.38983,52.29134,-1.42582,-.36837,52.33391,-1.48241,-.39564,52.27111,-1.4373,-.33178,52.16973,-1.21188,-.29786,52.32315,-1.62939,-.30261,52.31205,-1.62568,-.30163,52.32342,-1.62759,-.35713,52.29799,-1.38503,-.30953,52.1157,-1.25673,-.24074,52.08941,-1.2134,-.36879,52.15693,-1.34325,-.22758,52.37206,-1.59517,-.08341,52.25999,-1.61872,-.19341,52.29136,-1.64093,.08341,52.25999,-1.61837,.39821,52.24883,-1.46815,.17634,52.07075,-1.15358,.37199,52.20107,-1.25644,.36386,52.20841,-1.25507,.36865,52.29843,-1.39107,.32604,52.13266,-1.23206,.25358,52.11605,-1.17575,.3673,52.32282,-1.5745,.30163,52.32342,-1.62644,.29442,52.35475,-1.60939,.39544,52.25446,-1.47564,.38717,52.29852,-1.53414,.39983,52.22703,-1.38664,.31128,52.37529,-1.50713,.26999,52.38679,-1.55452,.28102,52.37832,-1.5256,.17458,52.23266,-1.23443,.13728,52.20824,-1.18114};
			return value;
		}
		private double[] getc7disc_Coord_9_84_point_3()
		{
			double[] value = {.23193,52.18012,-1.19351,.06628,52.3176,-1.28738,.12497,52.32001,-1.29945,.20576,52.31781,-1.33615,.31078,52.28583,-1.37931,.0698,52.34126,-1.51083,.32987,52.34889,-1.44575,.14284,52.18382,-1.16492,.24118,52.17121,-1.15682,.20149,52.25147,-1.5988,.19422,52.19945,-1.50504,.37879,52.17861,-1.28718,.13963,52.3517,-1.59559,.07964,52.31076,-1.61377,.07811,52.34047,-1.59452,.14956,52.15285,-1.11481,.26897,52.12522,-1.27392,.29753,52.27038,-1.57457,.3201,52.3704,-1.49187,.12343,52.34716,-1.47428,.32038,52.25793,-1.34761,.1332,52.26465,-1.20052,.13327,52.29185,-1.23303,.1398,52.35234,-1.53582,.07806,52.09247,-1.11924,.30953,52.1157,-1.25531,.22758,52.37206,-1.59432,.17413,52.06825,-1.16447,-.29973,52.1144,-1.2661,-.36847,52.29723,-1.39186,-.38895,52.28411,-1.42225,-.13728,52.20824,-1.18181,-.14956,52.15285,-1.11548,-.31118,52.26331,-1.55535,-.19422,52.19945,-1.50588,-.32033,52.22274,-1.49825,-.38717,52.29852,-1.53564,-.36865,52.29843,-1.39251,-.36386,52.20841,-1.2566,-.39123,52.24098,-1.47711,.29786,52.32315,-1.62825,.30261,52.31205,-1.62451,.36837,52.33391,-1.48102,.07849,52.3463,-1.58265,.27507,52.35076,-1.62033,.34158,52.34862,-1.45294,.18949,52.12123,-1.29422,.22782,52.10538,-1.23611,.18444,52.09206,-1.21063,.08567,52.1091,-1.28312,.0847,52.08246,-1.1868,.18968,52.16159,-1.4132,.08243,52.18404,-1.49541,.08509,52.14858,-1.40132,.32749,52.17865,-1.21231,.06699,52.29487,-1.22804,.06852,52.20936,-1.16598,.08027,52.05993,-1.14029,0.0,52.08484,-1.11431,0.0,52.28238,-1.60919,0.0,52.15787,-1.11993,.38956,52.24589,-1.48197,-.36373,52.31217,-1.57869,-.38202,52.29101,-1.54288,-.34158,52.34862,-1.45422,-.32749,52.17865,-1.21373,-.08027,52.05993,-1.14068,0.0,52.05086,-1.13484,-.06852,52.20936,-1.16655,0.0,52.31711,-1.29159,0.0,52.34077,-1.3639,0.0,52.26073,-1.18618,-.06699,52.29487,-1.22894,-.06833,52.25445,-1.18354,0.0,52.30038,-1.23467,-.13884,52.35623,-1.58258,-.20149,52.25147,-1.59964,-.29753,52.27038,-1.57577,-.18968,52.16159,-1.41406,0.0,52.09261,-1.27204,-.0847,52.08246,-1.1872,-.08567,52.1091,-1.28352,0.0,52.06912,-1.17724,-.08509,52.14858,-1.40172,-.18949,52.12123,-1.2951,-.07953,52.05725,-1.15118,0.0,52.04826,-1.14517,-.08243,52.18404,-1.49578,-.38956,52.24589,-1.48356,0.0,52.20936,-1.16628,.06833,52.25445,-1.18263,0.0,52.34287,-1.58077,0.0,52.308,-1.60279,-.37981,52.17165,-1.30886,.36373,52.31217,-1.5773,.07953,52.05725,-1.15079,0.0,52.34044,-1.51619,0.0,52.35849,-1.43803,0.0,52.18919,-1.15045,.38202,52.29101,-1.54139};
			return value;
		}
		private double[] getc7disc_Coord_9_84_point_4()
		{
			double[] value = {0.0,52.17247,-1.48976,.37981,52.17165,-1.30722,0.0,52.13495,-1.39041};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getcoccyx_Geo_8_89_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,9,13,-1,13,14,12,-1,15,16,17,-1,16,18,17,-1,19,20,21,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,30,33,31,-1,34,33,30,-1,34,35,33,-1,36,37,38,-1,36,39,37,-1,40,41,42,-1,41,43,42,-1,44,41,40,-1,44,45,41,-1,46,47,48,-1,46,49,47,-1,50,51,52,-1,52,53,50,-1,54,55,56,-1,56,57,54,-1,58,54,57,-1,58,59,54,-1,60,61,62,-1,60,63,61,-1,62,64,65,-1,62,61,64,-1,65,66,67,-1,65,64,66,-1,68,69,70,-1,70,71,68,-1,72,73,74,-1,72,75,73,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,80,83,81,-1,84,85,86,-1,84,87,85,-1,86,85,88,-1,88,89,86,-1,89,90,91,-1,89,88,90,-1,92,93,94,-1,92,95,93,-1,80,77,83,-1,80,78,77,-1,96,97,98,-1,97,99,98,-1,100,101,102,-1,102,103,100,-1,104,105,106,-1,107,108,109,-1,108,110,109,-1,111,112,113,-1,113,114,111,-1,115,116,117,-1,117,118,115,-1,119,120,121,-1,119,122,120,-1,123,124,125,-1,123,126,124,-1,27,127,128,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,133,17,134,-1,136,137,138,-1,139,140,141,-1,139,142,140,-1,143,144,145,-1,144,146,145,-1,59,147,148,-1,59,149,147,-1,150,151,66,-1,66,152,150,-1,153,154,155,-1,153,156,154,-1,157,158,159,-1,159,160,157,-1,114,161,162,-1,114,163,161,-1,164,165,166,-1,166,99,164,-1,167,168,169,-1,168,170,169,-1,171,160,172,-1,160,159,172,-1,173,174,175,-1,176,177,178,-1,178,179,176,-1,180,181,182,-1,180,15,181,-1,183,184,185,-1,183,186,184,-1,187,188,189,-1,187,190,188,-1,191,192,187,-1,187,189,191,-1,157,193,192,-1,192,194,157,-1,195,196,197,-1,197,198,195,-1,199,200,201,-1,201,202,199,-1,203,204,205,-1,205,124,203,-1,120,206,207,-1,120,125,206,-1,208,28,209,-1,208,26,28,-1,210,126,211,-1,210,212,126,-1,123,122,213,-1,213,214,123,-1,214,215,211,-1,214,216,215,-1,217,218,219,-1,220,221,222,-1,222,141,220,-1,223,224,225,-1,175,174,226,-1,226,227,175,-1,228,174,173,-1,173,229,228,-1,230,228,231,-1,228,232,231,-1,233,234,30,-1,234,34,30,-1,144,235,236,-1,144,143,235,-1,237,49,51,-1,51,238,237,-1,239,237,240,-1,237,241,240,-1,242,243,244,-1,244,245,242,-1,246,247,248,-1,248,249,246,-1,247,250,251,-1,251,252,247,-1,253,254,255,-1,255,256,253,-1,11,257,258,-1,11,116,257,-1,259,260,261,-1,259,118,260,-1,162,262,263,-1,263,264,162,-1,265,259,137,-1,259,138,137,-1,266,267,268,-1,266,269,267,-1,270,271,272,-1,273,274,275,-1,102,276,103,-1,102,277,276,-1,278,279,280,-1,279,281,280,-1,282,170,283,-1,283,284,282,-1,270,272,285,-1,285,286,270,-1,278,287,288,-1,287,219,288,-1,289,290,291,-1,290,292,291,-1,293,294,295,-1,295,296,293,-1,297,298,299,-1,297,300,298,-1,301,302,303,-1,304,268,305,-1,305,306,304,-1,307,100,165,-1,307,308,100,-1,256,309,302,-1,269,310,311,-1,312,167,98,-1,313,276,277,-1,277,5,313,-1,314,315,302,-1,302,309,314,-1,294,316,258,-1,294,315,316,-1,96,98,169,-1,98,167,169,-1,168,167,313,-1,317,318,319,-1,317,320,318,-1,321,136,322,-1,323,83,77,-1,77,324,323,-1,325,326,327,-1,327,328,325,-1,329,68,206,-1,68,207,206,-1,74,198,197,-1,197,72,74,-1,330,331,201,-1,331,332,201,-1,76,333,334,-1,76,78,333,-1,82,159,158,-1,158,80,82,-1,84,86,251,-1,86,252,251,-1,91,335,336,-1,336,89,91,-1,92,337,338,-1,92,94,337,-1,10,339,340,-1,341,55,20,-1,342,343,344,-1,344,345,342,-1,8,346,347,-1,8,7,346,-1,348,58,349,-1,57,350,349,-1,349,58,57,-1,65,67,351,-1,67,352,351,-1,60,62,353,-1,62,354,353,-1,355,356,357,-1,355,358,356,-1,359,360,361,-1,359,362,360,-1,363,364,365,-1,364,366,365,-1,367,368,369,-1,369,370,367,-1,48,371,372,-1,371,373,372,-1,374,375,376,-1,376,377,374,-1,378,379,380,-1,378,381,379,-1,382,383,384,-1,385,386,93,-1,386,387,93,-1,388,389,390,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_2()
		{
			int[] value = {389,391,390,-1,392,393,394,-1,393,395,394,-1,396,397,398,-1,397,399,398,-1,400,401,402,-1,400,403,401,-1,404,405,406,-1,405,407,406,-1,408,409,410,-1,409,411,410,-1,412,413,414,-1,415,416,417,-1,418,419,420,-1,421,422,423,-1,424,425,426,-1,427,428,429,-1,430,431,432,-1,430,433,431,-1,434,435,436,-1,436,437,434,-1,438,439,440,-1,440,441,438,-1,442,443,444,-1,444,445,442,-1,446,447,428,-1,428,427,446,-1,448,449,450,-1,451,452,422,-1,422,421,451,-1,416,415,453,-1,453,454,416,-1,455,424,456,-1,455,457,424,-1,458,442,459,-1,458,450,442,-1,460,459,461,-1,459,445,461,-1,462,463,464,-1,463,430,464,-1,465,466,467,-1,468,469,470,-1,469,446,470,-1,439,471,472,-1,472,440,439,-1,467,473,465,-1,467,474,473,-1,475,429,476,-1,475,427,429,-1,477,478,479,-1,477,480,478,-1,481,482,483,-1,482,484,480,-1,482,485,484,-1,486,487,488,-1,486,489,487,-1,490,491,492,-1,490,493,491,-1,494,495,496,-1,437,450,458,-1,497,412,498,-1,499,406,407,-1,499,500,406,-1,449,501,502,-1,449,503,501,-1,504,505,506,-1,504,507,505,-1,398,399,508,-1,399,509,508,-1,510,511,512,-1,511,513,512,-1,514,515,516,-1,515,517,516,-1,518,519,520,-1,518,521,519,-1,522,523,524,-1,522,525,523,-1,526,527,528,-1,527,529,528,-1,530,527,531,-1,531,532,530,-1,533,467,466,-1,466,534,533,-1,534,535,533,-1,534,536,535,-1,537,538,539,-1,537,540,538,-1,541,356,542,-1,541,536,356,-1,543,535,544,-1,543,545,535,-1,546,547,548,-1,549,550,551,-1,550,552,551,-1,553,554,555,-1,553,556,554,-1,557,558,559,-1,559,560,557,-1,561,562,563,-1,561,564,562,-1,565,566,567,-1,547,546,496,-1,546,494,496,-1,568,399,569,-1,568,509,399,-1,570,571,572,-1,571,573,572,-1,574,575,576,-1,530,577,578,-1,577,579,578,-1,555,580,581,-1,555,582,580,-1,583,584,585,-1,583,586,584,-1,587,588,501,-1,501,503,587,-1,553,555,589,-1,555,581,589,-1,515,514,590,-1,514,591,590,-1,511,592,593,-1,511,510,592,-1,594,432,431,-1,594,595,432,-1,539,596,597,-1,539,598,596,-1,599,600,492,-1,492,601,599,-1,342,108,602,-1,602,603,342,-1,107,604,605,-1,107,606,604,-1,456,417,416,-1,607,495,608,-1,396,609,397,-1,610,611,612,-1,610,613,611,-1,405,385,328,-1,405,386,385,-1,404,386,405,-1,404,614,386,-1,615,616,617,-1,617,618,615,-1,397,609,619,-1,619,620,397,-1,619,621,622,-1,622,620,619,-1,623,624,625,-1,623,626,624,-1,627,408,628,-1,627,409,408,-1,629,410,400,-1,629,630,410,-1,361,631,632,-1,632,366,361,-1,366,633,365,-1,366,632,633,-1,360,631,361,-1,360,634,631,-1,635,634,360,-1,635,636,634,-1,637,636,635,-1,637,638,636,-1,639,640,641,-1,639,642,640,-1,643,644,645,-1,178,646,647,-1,647,648,178,-1,649,650,651,-1,649,644,650,-1,645,652,653,-1,645,644,652,-1,652,654,523,-1,523,653,652,-1,380,655,656,-1,657,658,659,-1,658,660,659,-1,661,662,645,-1,519,662,661,-1,519,521,662,-1,663,664,665,-1,663,666,664,-1,667,500,499,-1,448,503,449,-1,448,414,503,-1,384,668,669,-1,384,383,668,-1,541,542,382,-1,670,671,672,-1,673,674,675,-1,676,537,677,-1,678,566,565,-1,679,674,673,-1,680,670,681,-1,414,498,412,-1,414,413,587,-1,587,503,414,-1,666,682,664,-1,666,683,682,-1,657,659,684,-1,685,686,687,-1,685,688,686,-1,689,541,382,-1,689,544,541,-1,690,32,31,-1,690,691,32,-1,654,691,690,-1,654,692,691,-1,644,693,650,-1,644,643,693,-1,694,651,650,-1,694,695,651,-1,696,562,695,-1,695,694,696,-1,697,562,696,-1,697,563,562,-1,646,698,699,-1,699,647,646,-1,700,48,47,-1,700,371,48,-1,701,367,702,-1,701,368,367,-1,703,704,368,-1,368,701,703,-1,705,704,703,-1,705,706,704,-1,707,706,705,-1,705,708,707,-1,63,709,580,-1,63,60,709,-1,580,710,581,-1,580,709,710,-1,581,362,589,-1,581,710,362,-1,711,363,712,-1,711,364,363,-1,712,707,708,-1,712,363,707,-1,411,403,410,-1,403,400,410,-1,713,714,715,-1,713,716,714,-1,717,718,719,-1,719,720,717,-1,721,622,621,-1,621,722,721,-1,609,393,723,-1,609,396,393,-1,723,392,724,-1,723,393,392,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_3()
		{
			int[] value = {724,389,725,-1,724,392,389,-1,387,94,93,-1,387,388,94,-1,721,722,719,-1,719,718,721,-1,441,570,572,-1,572,726,441,-1,452,727,728,-1,452,451,727,-1,557,577,558,-1,108,107,605,-1,605,602,108,-1,729,496,495,-1,729,730,496,-1,486,731,732,-1,732,489,486,-1,733,734,460,-1,733,735,734,-1,736,737,596,-1,596,598,736,-1,539,597,738,-1,738,537,539,-1,382,542,383,-1,129,638,130,-1,129,739,638,-1,682,740,741,-1,682,742,740,-1,594,743,595,-1,510,744,592,-1,744,745,592,-1,514,511,591,-1,511,593,591,-1,712,708,379,-1,708,746,379,-1,747,589,748,-1,747,553,589,-1,749,750,751,-1,749,752,750,-1,753,754,755,-1,753,756,754,-1,757,573,758,-1,757,572,573,-1,759,440,472,-1,759,760,440,-1,756,569,754,-1,756,568,569,-1,761,531,762,-1,559,561,560,-1,559,564,561,-1,763,178,648,-1,763,179,178,-1,764,765,766,-1,766,683,764,-1,656,767,768,-1,656,769,767,-1,770,769,771,-1,770,767,769,-1,772,753,771,-1,753,773,771,-1,774,549,775,-1,549,551,775,-1,199,585,200,-1,199,583,585,-1,776,777,778,-1,776,738,777,-1,596,401,779,-1,779,597,596,-1,544,536,541,-1,544,535,536,-1,539,780,598,-1,539,538,780,-1,534,466,357,-1,518,520,781,-1,520,745,781,-1,782,529,578,-1,762,531,526,-1,531,527,526,-1,762,783,761,-1,783,784,761,-1,783,785,786,-1,786,649,783,-1,787,788,692,-1,788,691,692,-1,789,590,591,-1,789,790,590,-1,514,516,513,-1,513,511,514,-1,791,792,700,-1,792,702,700,-1,791,239,793,-1,239,240,793,-1,794,795,796,-1,794,797,795,-1,798,799,504,-1,799,507,504,-1,508,798,398,-1,798,395,398,-1,444,667,490,-1,444,443,667,-1,498,436,435,-1,435,732,498,-1,486,800,801,-1,486,488,800,-1,481,802,485,-1,485,482,481,-1,488,595,743,-1,488,487,595,-1,483,482,480,-1,480,477,483,-1,457,455,803,-1,803,804,457,-1,805,469,806,-1,476,429,479,-1,807,727,808,-1,807,728,727,-1,809,810,671,-1,810,811,671,-1,471,812,472,-1,471,813,812,-1,469,805,446,-1,805,447,446,-1,465,810,466,-1,810,814,466,-1,735,462,815,-1,462,464,815,-1,734,434,437,-1,437,458,734,-1,733,460,816,-1,460,461,816,-1,445,459,442,-1,456,454,455,-1,456,416,454,-1,418,758,451,-1,451,421,418,-1,443,442,817,-1,804,431,433,-1,571,570,760,-1,808,675,807,-1,675,674,807,-1,449,442,450,-1,449,817,442,-1,437,436,448,-1,448,450,437,-1,464,430,432,-1,432,818,464,-1,570,441,440,-1,440,760,570,-1,759,675,760,-1,470,475,594,-1,405,328,407,-1,328,327,407,-1,623,779,401,-1,401,403,623,-1,714,716,551,-1,716,775,551,-1,628,585,584,-1,584,627,628,-1,717,552,819,-1,819,718,717,-1,622,755,754,-1,622,721,755,-1,393,396,395,-1,396,398,395,-1,389,392,391,-1,392,394,391,-1,94,388,337,-1,388,390,337,-1,617,609,723,-1,617,616,609,-1,412,820,821,-1,822,684,703,-1,342,603,343,-1,603,823,343,-1,670,672,824,-1,824,681,670,-1,363,365,707,-1,706,707,639,-1,707,365,639,-1,362,710,360,-1,710,635,360,-1,60,353,637,-1,637,709,60,-1,210,218,825,-1,210,826,218,-1,827,828,352,-1,352,67,827,-1,829,348,830,-1,348,349,830,-1,53,52,831,-1,52,832,831,-1,46,48,833,-1,48,372,833,-1,834,835,147,-1,147,836,834,-1,27,837,127,-1,385,93,95,-1,95,838,385,-1,91,92,335,-1,92,338,335,-1,86,89,252,-1,89,336,252,-1,71,839,207,-1,207,68,71,-1,325,840,326,-1,840,841,326,-1,842,843,844,-1,843,845,844,-1,846,847,69,-1,847,70,69,-1,10,9,12,-1,320,317,306,-1,307,848,849,-1,308,319,318,-1,850,851,852,-1,853,275,854,-1,855,856,311,-1,311,310,855,-1,294,258,257,-1,257,295,294,-1,857,169,858,-1,857,96,169,-1,302,301,256,-1,301,253,256,-1,285,854,286,-1,285,853,854,-1,316,315,314,-1,101,100,318,-1,100,308,318,-1,320,306,859,-1,306,305,859,-1,268,304,850,-1,850,266,268,-1,293,303,302,-1,302,315,293,-1,300,860,298,-1,860,857,298,-1,303,297,301,-1,297,299,301,-1,287,861,219,-1,272,862,285,-1,862,321,285,-1,858,170,282,-1,858,169,170,-1,861,287,863,-1,863,864,861,-1,322,273,275,-1,275,853,322,-1,262,865,263,-1,263,866,867,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_4()
		{
			int[] value = {867,264,263,-1,264,111,162,-1,111,114,162,-1,115,259,265,-1,115,118,259,-1,254,868,869,-1,869,870,254,-1,871,113,112,-1,294,293,315,-1,872,11,10,-1,873,326,841,-1,841,874,873,-1,314,875,844,-1,844,13,314,-1,249,876,877,-1,249,248,876,-1,878,251,250,-1,250,879,878,-1,143,142,880,-1,880,235,143,-1,515,144,517,-1,144,236,517,-1,221,220,881,-1,881,882,221,-1,883,884,885,-1,883,886,884,-1,887,888,889,-1,889,890,887,-1,227,226,891,-1,891,225,227,-1,227,892,175,-1,892,893,175,-1,894,219,861,-1,894,217,219,-1,211,123,214,-1,211,126,123,-1,28,128,825,-1,825,209,28,-1,895,26,208,-1,895,896,26,-1,897,898,899,-1,900,198,334,-1,900,195,198,-1,182,901,180,-1,182,902,901,-1,182,903,904,-1,182,181,903,-1,104,905,105,-1,905,906,105,-1,907,44,40,-1,40,908,907,-1,1,909,2,-1,171,172,878,-1,878,879,171,-1,910,284,911,-1,284,283,911,-1,312,98,166,-1,98,99,166,-1,912,913,914,-1,106,892,224,-1,224,915,106,-1,104,916,917,-1,917,905,104,-1,918,64,61,-1,61,919,918,-1,202,201,332,-1,332,920,202,-1,13,844,845,-1,845,14,13,-1,918,66,64,-1,918,152,66,-1,144,515,146,-1,515,590,146,-1,142,143,140,-1,143,145,140,-1,123,125,120,-1,120,122,123,-1,906,908,921,-1,921,922,906,-1,923,868,924,-1,923,925,868,-1,108,342,345,-1,345,110,108,-1,107,109,926,-1,926,606,107,-1,304,306,317,-1,927,928,112,-1,84,929,87,-1,930,931,323,-1,323,324,930,-1,838,328,385,-1,838,325,328,-1,932,325,838,-1,932,840,325,-1,933,842,934,-1,934,935,933,-1,87,929,936,-1,936,937,87,-1,937,82,81,-1,937,936,82,-1,938,939,940,-1,938,329,939,-1,846,330,847,-1,846,331,330,-1,630,71,70,-1,630,629,71,-1,941,828,830,-1,830,942,941,-1,942,349,943,-1,942,830,349,-1,944,828,941,-1,944,352,828,-1,945,351,352,-1,352,944,945,-1,131,351,945,-1,131,354,351,-1,130,354,131,-1,130,353,354,-1,946,947,948,-1,946,350,947,-1,36,885,39,-1,646,178,177,-1,177,949,646,-1,45,44,950,-1,950,949,45,-1,41,135,134,-1,134,43,41,-1,232,951,37,-1,37,39,232,-1,885,884,952,-1,952,39,885,-1,835,190,953,-1,954,19,955,-1,19,21,955,-1,883,885,956,-1,882,883,956,-1,882,881,883,-1,16,957,18,-1,16,958,957,-1,255,873,874,-1,9,316,13,-1,316,314,13,-1,837,959,960,-1,960,127,837,-1,28,27,128,-1,8,347,281,-1,4,313,5,-1,212,961,126,-1,305,270,859,-1,305,271,270,-1,127,212,128,-1,127,961,212,-1,962,959,837,-1,962,963,959,-1,309,255,874,-1,256,255,309,-1,882,957,958,-1,882,956,957,-1,36,956,885,-1,36,957,956,-1,18,134,17,-1,134,18,38,-1,955,964,954,-1,964,955,965,-1,953,25,966,-1,967,25,953,-1,22,967,193,-1,22,25,967,-1,968,965,955,-1,968,24,965,-1,246,964,969,-1,246,970,964,-1,971,21,20,-1,971,972,21,-1,973,147,835,-1,148,147,973,-1,224,974,975,-1,224,223,974,-1,952,34,231,-1,952,35,34,-1,232,952,231,-1,232,39,952,-1,43,951,42,-1,43,37,951,-1,177,45,949,-1,976,45,177,-1,646,950,698,-1,646,949,950,-1,51,46,52,-1,51,49,46,-1,53,55,50,-1,56,55,53,-1,151,67,66,-1,67,151,827,-1,829,149,348,-1,829,977,149,-1,827,977,829,-1,827,151,977,-1,59,348,149,-1,348,59,58,-1,330,978,847,-1,979,978,330,-1,72,846,75,-1,331,846,72,-1,74,79,76,-1,74,73,79,-1,843,980,981,-1,843,982,980,-1,842,982,843,-1,842,933,982,-1,95,91,90,-1,91,95,92,-1,166,276,312,-1,166,103,276,-1,110,7,6,-1,110,345,7,-1,983,984,985,-1,984,983,986,-1,983,987,986,-1,983,988,987,-1,989,3,990,-1,989,4,3,-1,991,99,97,-1,992,99,991,-1,868,993,869,-1,925,993,868,-1,927,260,994,-1,995,260,927,-1,296,300,297,-1,290,300,296,-1,922,105,906,-1,105,922,893,-1,908,42,921,-1,908,40,42,-1,996,944,997,-1,996,945,944,-1,998,942,999,-1,998,941,942,-1,1000,946,1001,-1,1000,943,946,-1,0,1000,1,-1,0,999,1000,-1,993,910,1002,-1,993,284,910,-1,282,923,858,-1,282,925,923,-1,161,262,162,-1,912,262,161,-1,1003,213,1004,-1,1005,213,1003,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_5()
		{
			int[] value = {120,839,121,-1,120,207,839,-1,1006,920,1007,-1,920,1006,202,-1,919,1008,918,-1,1008,919,1009,-1,1010,996,1011,-1,1010,132,996,-1,904,186,183,-1,904,903,186,-1,177,1012,976,-1,176,1012,177,-1,905,1013,907,-1,905,917,1013,-1,104,915,916,-1,104,106,915,-1,1014,1006,155,-1,1014,1015,1006,-1,1016,826,215,-1,1016,288,826,-1,971,59,148,-1,971,54,59,-1,1017,914,1018,-1,914,1017,865,-1,180,0,2,-1,180,901,0,-1,1019,871,1020,-1,897,871,1019,-1,23,879,1021,-1,23,171,879,-1,906,907,908,-1,906,905,907,-1,915,975,1022,-1,915,224,975,-1,917,1023,1024,-1,1023,917,916,-1,173,893,922,-1,893,173,175,-1,1013,1024,1025,-1,1013,917,1024,-1,921,951,229,-1,921,42,951,-1,181,1012,903,-1,1012,181,133,-1,909,16,2,-1,909,958,16,-1,904,902,182,-1,904,1011,902,-1,1026,132,1010,-1,1026,129,132,-1,63,919,61,-1,1027,919,63,-1,998,902,997,-1,901,902,998,-1,977,147,149,-1,836,147,977,-1,1028,152,1029,-1,1028,150,152,-1,1027,1009,919,-1,1009,1027,1030,-1,1031,1008,156,-1,1008,1031,1029,-1,1028,188,834,-1,1028,1032,188,-1,1033,1031,1034,-1,1033,1032,1031,-1,155,1035,1014,-1,155,154,1035,-1,1036,1034,1037,-1,1034,1036,1033,-1,22,171,23,-1,160,171,22,-1,900,1036,195,-1,900,191,1036,-1,196,1007,920,-1,196,1037,1007,-1,333,900,334,-1,194,900,333,-1,1038,959,1039,-1,960,959,1038,-1,896,897,1019,-1,897,896,898,-1,1040,896,895,-1,1040,898,896,-1,1004,1041,1003,-1,1042,1041,1004,-1,218,209,825,-1,218,217,209,-1,894,895,208,-1,894,1043,895,-1,161,1040,1044,-1,1040,161,163,-1,1044,1045,913,-1,1044,1043,1045,-1,1046,215,216,-1,1016,215,1046,-1,1003,606,926,-1,1003,1041,606,-1,279,1046,1047,-1,1016,1046,279,-1,1048,225,891,-1,223,225,1048,-1,1049,1048,233,-1,1049,1050,1048,-1,234,226,230,-1,234,891,226,-1,1051,888,887,-1,1051,1052,888,-1,890,884,886,-1,890,889,884,-1,38,957,36,-1,38,18,957,-1,1053,886,1054,-1,886,1053,890,-1,1055,887,1056,-1,1051,887,1055,-1,1057,1053,1058,-1,1057,1056,1053,-1,1059,881,220,-1,1054,881,1059,-1,222,909,1,-1,221,909,222,-1,140,1058,1059,-1,1058,140,145,-1,590,1057,146,-1,790,1057,590,-1,948,142,139,-1,142,948,880,-1,1060,55,341,-1,1060,50,55,-1,1061,1060,242,-1,1060,1061,238,-1,241,1062,1063,-1,241,1061,1062,-1,1064,244,970,-1,244,1064,245,-1,1065,1062,1066,-1,1062,1065,1063,-1,1067,1065,1068,-1,1067,1069,1065,-1,877,1064,249,-1,877,1066,1064,-1,244,19,954,-1,243,19,244,-1,1021,250,969,-1,1021,879,250,-1,1070,877,876,-1,877,1070,1068,-1,338,1071,1070,-1,1071,338,337,-1,335,248,336,-1,876,248,335,-1,963,1039,959,-1,963,1072,1039,-1,874,1073,309,-1,874,841,1073,-1,1074,326,873,-1,1074,327,326,-1,340,872,10,-1,340,1075,872,-1,258,9,11,-1,9,258,316,-1,1076,873,870,-1,873,1076,1074,-1,112,1020,871,-1,1020,112,928,-1,1075,117,872,-1,1075,994,117,-1,868,253,924,-1,254,253,868,-1,1077,870,869,-1,1076,870,1077,-1,115,1078,1079,-1,265,1078,115,-1,867,111,264,-1,867,995,111,-1,1080,867,866,-1,867,1080,261,-1,310,1081,992,-1,1081,269,266,-1,310,269,1081,-1,913,1018,914,-1,913,1045,1018,-1,866,865,1017,-1,263,865,866,-1,1080,273,138,-1,1080,274,273,-1,864,275,274,-1,864,863,275,-1,863,278,280,-1,863,287,278,-1,1047,6,8,-1,6,1047,1082,-1,347,990,3,-1,347,346,990,-1,988,343,987,-1,344,343,988,-1,97,289,991,-1,860,289,97,-1,168,283,170,-1,985,283,168,-1,136,862,311,-1,862,136,321,-1,992,855,310,-1,992,991,855,-1,97,857,860,-1,97,96,857,-1,266,852,1081,-1,266,850,852,-1,318,859,101,-1,859,318,320,-1,253,299,924,-1,301,299,253,-1,923,857,858,-1,298,857,923,-1,292,257,1079,-1,292,295,257,-1,1078,855,291,-1,855,1078,856,-1,853,321,322,-1,853,285,321,-1,850,317,851,-1,850,304,317,-1,308,849,319,-1,308,307,849,-1,852,849,848,-1,852,851,849,-1,339,837,27,-1,339,962,837,-1,73,1083,79,-1,940,1083,73,-1,846,938,75,-1,69,938,846,-1,847,630,70,-1,630,847,978,-1,982,81,980,-1,937,81,982,-1,204,939,205,-1,1084,939,204,-1,1039,930,1038,-1,931,930,1039,-1,981,845,843,-1,981,1072,845,-1,875,842,844,-1,934,842,875,-1,841,1085,1073,-1,840,1085,841,-1,71,1086,839,-1,71,629,1086,-1,172,929,878,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_6()
		{
			int[] value = {936,929,172,-1,85,933,935,-1,933,85,87,-1,838,90,932,-1,838,95,90,-1,52,833,832,-1,52,46,833,-1,53,947,56,-1,53,831,947,-1,828,829,830,-1,827,829,828,-1,128,210,825,-1,212,210,128,-1,288,218,826,-1,288,219,218,-1,677,668,383,-1,776,668,677,-1,637,710,709,-1,710,637,635,-1,704,639,641,-1,704,706,639,-1,823,681,824,-1,603,681,823,-1,725,1087,724,-1,614,1087,725,-1,617,724,1087,-1,617,723,724,-1,620,754,569,-1,620,622,754,-1,819,721,718,-1,721,819,755,-1,979,585,628,-1,979,200,585,-1,716,584,775,-1,716,627,584,-1,717,551,552,-1,717,714,551,-1,623,777,779,-1,623,625,777,-1,618,1088,502,-1,618,1089,1088,-1,501,1090,615,-1,1090,501,588,-1,612,1091,1092,-1,612,1093,1091,-1,610,778,1094,-1,610,1095,778,-1,619,616,1096,-1,619,609,616,-1,722,1097,611,-1,1097,722,621,-1,613,720,719,-1,613,1098,720,-1,713,624,626,-1,624,713,715,-1,1099,412,821,-1,412,1099,413,-1,426,423,417,-1,426,419,423,-1,447,674,428,-1,674,447,807,-1,1100,464,818,-1,815,464,1100,-1,816,600,599,-1,816,461,600,-1,675,571,760,-1,571,675,808,-1,804,468,431,-1,804,803,468,-1,758,420,757,-1,758,418,420,-1,757,425,1101,-1,420,425,757,-1,1102,816,438,-1,1102,733,816,-1,434,735,815,-1,734,735,434,-1,1103,675,759,-1,675,1103,673,-1,758,727,451,-1,758,573,727,-1,984,812,911,-1,984,1104,812,-1,757,1105,572,-1,757,1101,1105,-1,1106,824,1107,-1,824,1106,823,-1,671,679,672,-1,671,674,679,-1,805,807,447,-1,805,728,807,-1,605,680,602,-1,605,1108,680,-1,809,670,1109,-1,809,671,670,-1,811,429,428,-1,811,473,429,-1,803,469,468,-1,469,803,806,-1,475,743,594,-1,743,475,476,-1,1110,474,467,-1,474,1110,1111,-1,432,487,818,-1,595,487,432,-1,743,800,488,-1,800,743,478,-1,485,730,729,-1,485,802,730,-1,1112,800,484,-1,801,800,1112,-1,735,1102,462,-1,733,1102,735,-1,458,460,734,-1,458,459,460,-1,732,497,498,-1,497,732,731,-1,1113,608,1114,-1,608,1113,607,-1,493,667,499,-1,490,667,493,-1,1114,1115,820,-1,608,1115,1114,-1,817,502,1088,-1,817,449,502,-1,394,798,504,-1,798,394,395,-1,506,390,391,-1,506,1116,390,-1,1116,1067,1071,-1,1117,1067,1116,-1,798,1118,799,-1,508,1118,798,-1,1119,507,799,-1,1119,1120,507,-1,1121,1117,505,-1,1122,1117,1121,-1,1122,1123,1069,-1,1124,1123,1122,-1,797,1121,1120,-1,797,1125,1121,-1,1126,660,1127,-1,1126,659,660,-1,1128,797,794,-1,1128,1125,797,-1,793,1123,1124,-1,240,1123,793,-1,791,1128,792,-1,1128,791,793,-1,700,239,791,-1,239,700,47,-1,792,701,702,-1,792,1129,701,-1,745,1130,781,-1,745,744,1130,-1,591,377,789,-1,377,591,593,-1,592,520,374,-1,520,592,745,-1,663,518,567,-1,663,521,518,-1,1131,790,789,-1,1055,790,1131,-1,525,1131,376,-1,525,522,1131,-1,661,375,519,-1,661,1132,375,-1,645,1132,661,-1,1132,645,653,-1,1049,691,788,-1,1049,32,691,-1,785,692,786,-1,785,787,692,-1,649,784,783,-1,784,649,651,-1,762,785,783,-1,526,785,762,-1,528,788,787,-1,1133,788,528,-1,782,1050,1133,-1,782,974,1050,-1,1130,565,781,-1,565,1130,1134,-1,809,814,810,-1,814,809,1135,-1,605,1136,1108,-1,605,604,1136,-1,1136,1137,1138,-1,1137,1136,1139,-1,1140,467,533,-1,1140,1110,467,-1,574,1141,1142,-1,574,576,1141,-1,545,1141,1140,-1,545,1143,1141,-1,358,1144,540,-1,1144,358,355,-1,1139,538,1137,-1,1139,780,538,-1,736,1042,1145,-1,736,1146,1042,-1,737,1086,402,-1,737,1147,1086,-1,597,777,738,-1,597,779,777,-1,776,1095,668,-1,776,778,1095,-1,544,1148,543,-1,1148,544,689,-1,775,586,774,-1,586,775,584,-1,773,755,819,-1,755,773,753,-1,774,1149,549,-1,1149,774,1150,-1,770,773,550,-1,771,773,770,-1,756,772,688,-1,756,753,772,-1,1151,380,1152,-1,380,1151,655,-1,1149,767,770,-1,1149,1153,767,-1,752,1150,1154,-1,752,1155,1150,-1,749,1155,752,-1,1156,1155,749,-1,1157,767,1153,-1,768,767,1157,-1,656,378,380,-1,768,378,656,-1,556,1157,1156,-1,556,1158,1157,-1,751,1030,1159,-1,1035,1030,751,-1,378,747,381,-1,378,1158,747,-1,1160,1161,678,-1,1161,1160,1162,-1,1163,1164,1165,-1,1164,1163,1166,-1,583,1015,1167,-1,199,1015,583,-1,765,1161,1165,-1,765,764,1161,-1,1168,1026,185,-1,1026,1168,1169,-1,765,1170,766,-1,765,1171,1170,-1,683,566,764,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_7()
		{
			int[] value = {666,566,683,-1,742,683,766,-1,742,682,683,-1,184,763,1172,-1,184,179,763,-1,1173,742,1174,-1,742,1173,740,-1,698,1175,699,-1,1025,1175,698,-1,1176,784,1177,-1,761,784,1176,-1,1022,1178,1023,-1,1178,1022,579,-1,532,577,530,-1,532,558,577,-1,689,1115,1148,-1,1115,689,820,-1,1111,479,474,-1,1111,477,479,-1,813,911,812,-1,813,910,911,-1,730,547,496,-1,730,1179,547,-1,822,794,796,-1,822,1129,794,-1,684,705,703,-1,705,684,1180,-1,529,530,578,-1,527,530,529,-1,560,1178,557,-1,560,1181,1178,-1,561,699,1175,-1,561,563,699,-1,1170,763,1174,-1,1170,1172,763,-1,1164,1168,1171,-1,1164,1169,1168,-1,1159,749,751,-1,554,749,1159,-1,1154,750,752,-1,1154,1167,750,-1,1146,598,780,-1,598,1146,736,-1,604,1139,1136,-1,1139,604,1182,-1,813,601,1183,-1,601,813,471,-1,381,748,711,-1,381,747,748,-1,1152,1127,1151,-1,1127,1152,1126,-1,587,1091,588,-1,587,1184,1091,-1,642,744,640,-1,1130,744,642,-1,633,1160,1134,-1,1160,633,632,-1,631,1163,1162,-1,1163,631,634,-1,739,636,638,-1,739,1166,636,-1,820,382,821,-1,820,689,382,-1,537,776,677,-1,537,738,776,-1,1145,737,736,-1,1145,1147,737,-1,1177,559,1176,-1,564,559,1177,-1,548,1179,1143,-1,1179,548,547,-1,1100,732,435,-1,489,732,1100,-1,486,1113,731,-1,486,801,1113,-1,495,1112,729,-1,1112,495,607,-1,1002,491,1077,-1,1002,1183,491,-1,428,671,811,-1,428,674,671,-1,1185,1107,1103,-1,1185,1106,1107,-1,1103,1104,1185,-1,759,1104,1103,-1,453,728,805,-1,453,452,728,-1,483,574,481,-1,574,483,575,-1,1087,404,1089,-1,1087,614,404,-1,617,1089,618,-1,617,1087,1089,-1,1097,612,611,-1,612,1097,1093,-1,1094,613,610,-1,1094,1098,613,-1,624,1094,625,-1,624,1098,1094,-1,411,623,403,-1,411,626,623,-1,638,353,130,-1,353,638,637,-1,639,633,642,-1,365,633,639,-1,512,641,640,-1,641,512,369,-1,369,513,370,-1,369,512,513,-1,516,370,513,-1,370,516,373,-1,517,373,516,-1,373,517,372,-1,647,563,697,-1,563,647,699,-1,697,740,1173,-1,697,696,740,-1,741,696,694,-1,740,696,741,-1,694,693,741,-1,694,650,693,-1,654,524,523,-1,654,690,524,-1,1052,690,31,-1,524,690,1052,-1,1136,1109,1108,-1,1136,1138,1109,-1,1126,746,1180,-1,746,1126,1152,-1,684,796,657,-1,684,822,796,-1,1186,687,1187,-1,685,687,1186,-1,1151,687,686,-1,1151,1127,687,-1,658,1119,1188,-1,658,795,1119,-1,769,772,771,-1,772,769,1189,-1,1189,656,655,-1,1189,769,656,-1,1187,1118,1186,-1,1188,1118,1187,-1,1184,413,1099,-1,413,1184,587,-1,806,455,454,-1,455,806,803,-1,805,454,453,-1,454,805,806,-1,676,383,542,-1,383,676,677,-1,669,1099,384,-1,1099,669,1184,-1,667,817,500,-1,667,443,817,-1,665,521,663,-1,521,665,662,-1,662,643,645,-1,665,643,662,-1,741,664,682,-1,741,693,664,-1,1188,660,658,-1,1188,1187,660,-1,686,655,1151,-1,686,1189,655,-1,1189,688,772,-1,688,1189,686,-1,1187,1127,660,-1,687,1127,1187,-1,1188,799,1118,-1,799,1188,1119,-1,659,1180,684,-1,1126,1180,659,-1,379,1152,380,-1,379,746,1152,-1,974,578,975,-1,782,578,974,-1,692,652,786,-1,652,692,654,-1,652,649,786,-1,644,649,652,-1,697,648,647,-1,697,1173,648,-1,371,702,367,-1,702,371,700,-1,362,748,589,-1,362,359,748,-1,711,359,364,-1,748,359,711,-1,978,628,408,-1,978,979,628,-1,409,716,713,-1,409,627,716,-1,720,714,717,-1,715,714,720,-1,1097,1090,1093,-1,1096,1090,1097,-1,1096,615,1090,-1,616,615,1096,-1,389,387,725,-1,389,388,387,-1,808,573,571,-1,727,573,808,-1,681,602,680,-1,603,602,681,-1,984,1185,1104,-1,984,986,1185,-1,987,1185,986,-1,1185,987,1106,-1,679,1103,1107,-1,673,1103,679,-1,572,463,726,-1,572,1105,463,-1,1183,492,491,-1,1183,601,492,-1,801,607,1113,-1,801,1112,607,-1,558,1176,559,-1,558,532,1176,-1,695,564,1177,-1,564,695,562,-1,634,1166,1163,-1,1166,634,636,-1,632,1162,1160,-1,1162,632,631,-1,642,1134,1130,-1,1134,642,633,-1,1134,678,565,-1,678,1134,1160,-1,910,1183,1002,-1,1183,910,813,-1,599,471,439,-1,601,471,599,-1,481,1142,802,-1,481,574,1142,-1,780,1182,1146,-1,780,1139,1182,-1,402,596,737,-1,596,402,401,-1,586,1167,1154,-1,586,583,1167,-1,554,582,555,-1,554,1159,582,-1,1166,1169,1164,-1,1169,1166,739,-1,1172,1171,1168,-1,1170,1171,1172,-1,1174,648,1173,-1,1174,763,648,-1,1175,560,561,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_8()
		{
			int[] value = {560,1175,1181,-1,579,557,1178,-1,577,557,579,-1,1167,1014,750,-1,1015,1014,1167,-1,355,1135,1144,-1,814,1135,355,-1,708,1180,746,-1,1180,708,705,-1,1179,802,1142,-1,1179,730,802,-1,575,477,1111,-1,575,483,477,-1,678,764,566,-1,1161,764,678,-1,494,1148,1115,-1,494,546,1148,-1,509,685,1186,-1,568,685,509,-1,975,579,1022,-1,579,975,578,-1,1023,1181,1024,-1,1023,1178,1181,-1,532,761,1176,-1,532,531,761,-1,1024,1175,1025,-1,1181,1175,1024,-1,651,1177,784,-1,1177,651,695,-1,1174,766,1170,-1,1174,742,766,-1,666,567,566,-1,663,567,666,-1,1168,184,1172,-1,1168,185,184,-1,1165,1171,765,-1,1164,1171,1165,-1,739,1026,1169,-1,1026,739,129,-1,582,63,580,-1,582,1027,63,-1,1165,1162,1163,-1,1165,1161,1162,-1,379,711,712,-1,379,381,711,-1,553,1158,556,-1,747,1158,553,-1,1159,1027,582,-1,1159,1030,1027,-1,554,1156,749,-1,554,556,1156,-1,768,1158,378,-1,1157,1158,768,-1,1156,1153,1155,-1,1157,1153,1156,-1,1035,750,1014,-1,751,750,1035,-1,1155,1149,1150,-1,1155,1153,1149,-1,568,688,685,-1,568,756,688,-1,1149,550,549,-1,770,550,1149,-1,1154,774,586,-1,1150,774,1154,-1,550,819,552,-1,550,773,819,-1,669,1095,1092,-1,669,668,1095,-1,546,543,1148,-1,546,548,543,-1,543,1143,545,-1,548,1143,543,-1,540,676,358,-1,676,540,537,-1,1041,1146,1182,-1,1041,1042,1146,-1,1137,540,1144,-1,1137,538,540,-1,536,357,356,-1,357,536,534,-1,545,533,535,-1,533,545,1140,-1,1143,1142,1141,-1,1143,1179,1142,-1,1110,1141,576,-1,1141,1110,1140,-1,1144,1138,1137,-1,1144,1135,1138,-1,606,1182,604,-1,1041,1182,606,-1,1138,809,1109,-1,1138,1135,809,-1,529,1133,528,-1,529,782,1133,-1,1133,1049,788,-1,1050,1049,1133,-1,526,787,785,-1,528,787,526,-1,524,1051,522,-1,1051,524,1052,-1,653,525,1132,-1,525,653,523,-1,665,693,643,-1,693,665,664,-1,1132,376,375,-1,1132,525,376,-1,522,1055,1131,-1,522,1051,1055,-1,376,789,377,-1,1131,789,376,-1,519,374,520,-1,519,375,374,-1,567,781,565,-1,567,518,781,-1,377,592,374,-1,377,593,592,-1,510,640,744,-1,510,512,640,-1,703,1129,822,-1,1129,703,701,-1,1129,1128,794,-1,1129,792,1128,-1,1125,793,1124,-1,793,1125,1128,-1,795,1120,1119,-1,795,797,1120,-1,1125,1122,1121,-1,1125,1124,1122,-1,1122,1067,1117,-1,1069,1067,1122,-1,1120,505,507,-1,505,1120,1121,-1,657,795,658,-1,657,796,795,-1,508,1186,1118,-1,509,1186,508,-1,505,1116,506,-1,505,1117,1116,-1,1071,390,1116,-1,1071,337,390,-1,504,391,394,-1,504,506,391,-1,1092,1184,669,-1,1184,1092,1091,-1,1088,500,817,-1,500,1088,406,-1,407,1074,499,-1,1074,407,327,-1,497,820,412,-1,1114,820,497,-1,414,436,498,-1,414,448,436,-1,499,1076,493,-1,499,1074,1076,-1,1115,495,494,-1,1115,608,495,-1,731,1114,497,-1,1114,731,1113,-1,444,492,600,-1,444,490,492,-1,493,1077,491,-1,493,1076,1077,-1,818,489,1100,-1,818,487,489,-1,729,484,485,-1,1112,484,729,-1,484,478,480,-1,484,800,478,-1,1101,433,1105,-1,804,1101,457,-1,804,433,1101,-1,1111,576,575,-1,1110,576,1111,-1,476,478,743,-1,479,478,476,-1,429,474,479,-1,474,429,473,-1,810,473,811,-1,465,473,810,-1,680,1109,670,-1,680,1108,1109,-1,1107,672,679,-1,672,1107,824,-1,343,1106,987,-1,343,823,1106,-1,462,726,463,-1,462,1102,726,-1,812,759,472,-1,812,1104,759,-1,468,594,431,-1,468,470,594,-1,430,1105,433,-1,463,1105,430,-1,438,726,1102,-1,726,438,441,-1,425,457,1101,-1,457,425,424,-1,453,422,452,-1,453,415,422,-1,461,444,600,-1,461,445,444,-1,438,599,439,-1,438,816,599,-1,435,815,1100,-1,434,815,435,-1,470,427,475,-1,427,470,446,-1,417,424,426,-1,456,424,417,-1,419,421,423,-1,418,421,419,-1,419,425,420,-1,426,425,419,-1,417,422,415,-1,417,423,422,-1,384,821,382,-1,821,384,1099,-1,1098,715,720,-1,1098,624,715,-1,626,409,713,-1,626,411,409,-1,630,408,410,-1,630,978,408,-1,719,611,613,-1,611,719,722,-1,621,1096,1097,-1,621,619,1096,-1,625,778,777,-1,625,1094,778,-1,610,1092,1095,-1,610,612,1092,-1,588,1093,1090,-1,1093,588,1091,-1,615,502,501,-1,615,618,502,-1,1089,406,1088,-1,1089,404,406,-1,1086,400,402,-1,629,400,1086,-1,397,569,399,-1,397,620,569,-1,725,386,614,-1,386,725,387,-1,373,367,370,-1,371,367,373,-1,641,368,704,-1,368,641,369,-1,364,361,366,-1,364,359,361,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_9()
		{
			int[] value = {358,542,356,-1,358,676,542,-1,357,814,355,-1,814,357,466,-1,960,961,127,-1,960,203,961,-1,65,354,62,-1,65,351,354,-1,350,56,947,-1,57,56,350,-1,1058,1054,1059,-1,1054,1058,1053,-1,7,344,346,-1,7,345,344,-1,1190,90,88,-1,1190,932,90,-1,88,935,1190,-1,935,88,85,-1,929,251,878,-1,929,84,251,-1,159,936,172,-1,82,936,159,-1,80,333,78,-1,80,158,333,-1,201,979,330,-1,979,201,200,-1,332,72,197,-1,331,72,332,-1,198,76,334,-1,74,76,198,-1,205,329,206,-1,939,329,205,-1,1073,934,875,-1,1085,934,1073,-1,1072,931,1039,-1,981,931,1072,-1,204,930,1084,-1,930,204,1038,-1,933,937,982,-1,87,937,933,-1,980,83,323,-1,980,81,83,-1,79,324,77,-1,1083,324,79,-1,940,75,938,-1,940,73,75,-1,10,962,339,-1,10,12,962,-1,319,851,317,-1,851,319,849,-1,5,286,854,-1,5,277,286,-1,291,1079,1078,-1,291,292,1079,-1,924,298,923,-1,299,298,924,-1,312,313,167,-1,312,276,313,-1,862,269,311,-1,267,269,862,-1,848,165,164,-1,165,848,307,-1,852,164,1081,-1,852,848,164,-1,290,295,292,-1,290,296,295,-1,991,291,855,-1,991,289,291,-1,313,989,168,-1,313,4,989,-1,103,165,100,-1,166,165,103,-1,283,984,911,-1,984,283,985,-1,992,164,99,-1,1081,164,992,-1,346,988,990,-1,346,344,988,-1,3,281,347,-1,5,281,3,-1,277,270,286,-1,102,270,277,-1,6,109,110,-1,109,6,1082,-1,8,279,1047,-1,281,279,8,-1,275,280,854,-1,280,275,863,-1,272,267,862,-1,272,271,267,-1,138,322,136,-1,138,273,322,-1,1080,1017,274,-1,866,1017,1080,-1,864,1045,861,-1,864,1018,1045,-1,265,856,1078,-1,265,137,856,-1,261,138,259,-1,261,1080,138,-1,261,995,867,-1,261,260,995,-1,860,290,289,-1,860,300,290,-1,297,293,296,-1,303,293,297,-1,872,116,11,-1,872,117,116,-1,928,994,1075,-1,928,927,994,-1,255,870,873,-1,255,254,870,-1,1020,1075,340,-1,1020,928,1075,-1,875,309,1073,-1,314,309,875,-1,247,336,248,-1,247,252,336,-1,338,876,335,-1,1070,876,338,-1,1067,1070,1071,-1,1067,1068,1070,-1,969,247,246,-1,969,250,247,-1,249,970,246,-1,1064,970,249,-1,1068,1066,877,-1,1068,1065,1066,-1,1123,1065,1069,-1,1123,1063,1065,-1,1066,245,1064,-1,245,1066,1062,-1,955,972,968,-1,21,972,955,-1,245,1061,242,-1,1062,1061,245,-1,1123,241,1063,-1,1123,240,241,-1,1061,237,238,-1,1061,241,237,-1,239,49,237,-1,239,47,49,-1,50,238,51,-1,1060,238,50,-1,1001,141,222,-1,141,1001,139,-1,1058,146,1057,-1,1058,145,146,-1,220,140,1059,-1,220,141,140,-1,221,958,909,-1,882,958,221,-1,790,1056,1057,-1,790,1055,1056,-1,1056,890,1053,-1,890,1056,887,-1,1054,883,881,-1,886,883,1054,-1,30,1049,233,-1,1049,30,32,-1,34,230,231,-1,234,230,34,-1,229,232,228,-1,229,951,232,-1,230,174,228,-1,230,226,174,-1,233,891,234,-1,233,1048,891,-1,1050,223,1048,-1,974,223,1050,-1,1,1001,222,-1,1,1000,1001,-1,288,279,278,-1,288,1016,279,-1,1191,109,1082,-1,109,1191,926,-1,216,1191,1046,-1,216,1005,1191,-1,861,1043,894,-1,1045,1043,861,-1,1044,912,161,-1,912,1044,913,-1,1044,895,1043,-1,895,1044,1040,-1,217,208,209,-1,217,894,208,-1,215,210,211,-1,215,826,210,-1,214,1005,216,-1,213,1005,214,-1,1042,119,1145,-1,119,1042,1004,-1,1086,121,839,-1,1147,121,1086,-1,205,125,124,-1,125,205,206,-1,1038,203,960,-1,203,1038,204,-1,1019,26,896,-1,1019,29,26,-1,920,197,196,-1,920,332,197,-1,158,194,333,-1,158,157,194,-1,1036,196,195,-1,1036,1037,196,-1,194,191,900,-1,194,192,191,-1,193,160,22,-1,160,193,157,-1,835,966,973,-1,835,953,966,-1,189,1036,191,-1,1033,1036,189,-1,1037,153,1007,-1,153,1037,1034,-1,1034,156,153,-1,1034,1031,156,-1,189,1032,1033,-1,189,188,1032,-1,834,190,835,-1,834,188,190,-1,1032,1029,1031,-1,1029,1032,1028,-1,1030,154,1009,-1,1030,1035,154,-1,1029,918,1008,-1,1029,152,918,-1,150,834,836,-1,834,150,1028,-1,901,999,0,-1,901,998,999,-1,1011,997,902,-1,1011,996,997,-1,1015,202,1006,-1,1015,199,202,-1,1026,183,185,-1,1026,1010,183,-1,2,15,180,-1,2,16,15,-1,15,133,181,-1,17,133,15,-1,176,184,186,-1,179,184,176,-1,133,976,1012,-1,133,135,976,-1,1013,698,950,-1,1013,1025,698,-1,229,922,921,-1,229,173,922,-1};
			return value;
		}
		private int[] getcoccyx_Geo_8_89_coordIndex_10()
		{
			int[] value = {916,1022,1023,-1,916,915,1022,-1,106,893,892,-1,893,106,105,-1,1020,29,1019,-1,1020,340,29,-1,897,113,871,-1,897,899,113,-1,274,1018,864,-1,1017,1018,274,-1,899,114,113,-1,114,899,163,-1,242,341,243,-1,1060,341,242,-1,54,20,55,-1,54,971,20,-1,892,225,224,-1,892,227,225,-1,950,907,1013,-1,907,950,44,-1,176,903,1012,-1,903,176,186,-1,183,1011,904,-1,1011,183,1010,-1,156,1009,154,-1,156,1008,1009,-1,155,1007,153,-1,1007,155,1006,-1,122,1004,213,-1,122,119,1004,-1,1005,926,1191,-1,1005,1003,926,-1,925,284,993,-1,925,282,284,-1,151,836,977,-1,150,836,151,-1,968,973,966,-1,968,972,973,-1,137,311,856,-1,137,136,311,-1,1072,14,845,-1,963,14,1072,-1,139,946,948,-1,139,1001,946,-1,999,943,1000,-1,999,942,943,-1,997,941,998,-1,997,944,941,-1,945,132,131,-1,996,132,945,-1,27,340,339,-1,29,340,27,-1,203,126,961,-1,126,203,124,-1,121,1145,119,-1,1145,121,1147,-1,163,898,1040,-1,163,899,898,-1,116,1079,257,-1,116,115,1079,-1,994,118,117,-1,260,118,994,-1,995,112,111,-1,995,927,112,-1,869,1002,1077,-1,993,1002,869,-1,281,854,280,-1,5,854,281,-1,990,983,989,-1,983,990,988,-1,985,989,983,-1,985,168,989,-1,102,859,270,-1,859,102,101,-1,912,865,262,-1,912,914,865,-1,840,1190,1085,-1,1190,840,932,-1,1085,935,934,-1,935,1085,1190,-1,931,980,323,-1,931,981,980,-1,324,1084,930,-1,1083,1084,324,-1,1084,940,939,-1,940,1084,1083,-1,329,69,68,-1,69,329,938,-1,943,350,946,-1,943,349,350,-1,947,880,948,-1,947,831,880,-1,235,831,832,-1,880,831,235,-1,832,236,235,-1,832,833,236,-1,833,517,236,-1,833,372,517,-1,135,45,976,-1,45,135,41,-1,38,43,134,-1,43,38,37,-1,889,952,884,-1,952,889,35,-1,888,35,889,-1,35,888,33,-1,33,1052,31,-1,33,888,1052,-1,1047,1191,1082,-1,1191,1047,1046,-1,148,972,971,-1,148,973,972,-1,243,20,19,-1,341,20,243,-1,24,1021,965,-1,24,23,1021,-1,24,966,25,-1,968,966,24,-1,970,954,964,-1,244,954,970,-1,193,187,192,-1,193,967,187,-1,190,967,953,-1,187,967,190,-1,969,965,1021,-1,969,964,965,-1,12,963,962,-1,12,14,963,-1,268,271,305,-1,268,267,271,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getcoccyx_Coord_9_89_point_1()
		{
			double[] value = {-.28921,30.29935,-2.84002,-.31384,30.22245,-2.86205,-.30326,30.26881,-2.79749,-.3206,31.21421,-3.51363,-.3198,31.19294,-3.56899,-.41429,31.19785,-3.54175,-.18665,31.27077,-3.34611,-.18918,31.23288,-3.38181,-.30771,31.23961,-3.37251,-.50858,30.77054,-3.37924,-.68185,30.87913,-3.43763,-.58431,30.8482,-3.45605,-.54356,30.78476,-3.36199,-.48995,30.69074,-3.35277,-.52459,30.71591,-3.31331,-.26454,30.26217,-2.74475,-.2816,30.22587,-2.75714,-.2403,30.23764,-2.65052,-.24773,30.19564,-2.66703,-.29144,30.23039,-3.03614,-.27034,30.19241,-2.97595,-.30848,30.25105,-3.01668,-.46635,30.50912,-3.06943,-.45764,30.46278,-3.10655,-.41074,30.42059,-3.07694,-.4245,30.46028,-3.03767,-.79901,31.07039,-3.402,-.69404,30.9703,-3.32973,-.68826,31.01159,-3.31981,-.82203,31.01577,-3.40891,-.06161,30.09323,-2.61254,0.0,30.11943,-2.62035,0.0,30.09568,-2.61567,-.06179,30.11158,-2.62126,-.13831,30.09542,-2.61773,-.13839,30.11491,-2.62161,-.22659,30.13679,-2.6301,-.21053,30.17325,-2.59706,-.22704,30.18194,-2.60871,-.19301,30.13298,-2.6128,-.19631,30.23301,-2.56008,-.20221,30.22812,-2.57552,-.2109,30.20279,-2.57189,-.21018,30.19533,-2.58931,-.16212,30.26426,-2.55077,-.16569,30.25731,-2.5688,-.09186,30.21471,-2.96563,0.0,30.21308,-2.98353,0.0,30.21579,-2.96945,-.08589,30.21792,-2.97806,-.19478,30.19708,-2.97036,-.14525,30.20783,-2.97819,-.15294,30.20487,-2.96807,-.20062,30.19839,-2.95411,-.25225,30.21898,-2.93521,-.22412,30.19708,-2.95821,-.22483,30.20067,-2.94526,-.2454,30.2242,-2.92698,-.25336,30.27768,-2.9044,-.25972,30.26885,-2.90985,0.0,30.43314,-2.87921,-.08649,30.43343,-2.88364,-.08677,30.41949,-2.88345,0.0,30.44749,-2.88334,-.16018,30.42278,-2.87809,-.15971,30.41148,-2.88215,-.2038,30.39991,-2.8761,-.2041,30.38753,-2.8762,-.15068,30.77327,-3.07839,-.15577,30.76602,-3.0805,-.08052,30.77166,-3.06543,-.07792,30.77993,-3.05926,-.23262,30.75043,-3.06238,-.33249,30.7335,-3.10671,-.33579,30.72858,-3.09943,-.23571,30.7494,-3.08551,-.39449,30.70077,-3.12471,-.42088,30.68793,-3.149,-.43653,30.67977,-3.13977,-.38579,30.71117,-3.13393,-.47212,30.65764,-3.16963,-.47379,30.64281,-3.20386,-.48335,30.63216,-3.19864,-.45632,30.66191,-3.17849,-.46198,30.58765,-3.28358,-.40896,30.60481,-3.29702,-.40362,30.58549,-3.30859,-.45584,30.6009,-3.2725,-.30624,30.61367,-3.30237,-.30414,30.58285,-3.33138,-.21344,30.62309,-3.31066,-.21558,30.58679,-3.33262,-.1112,30.58481,-3.32972,0.0,30.61337,-3.32116,0.0,30.58793,-3.33102,-.11117,30.61247,-3.31167,-.33025,31.03343,-3.72392,-.36279,31.02339,-3.77839,-.34613,31.11435,-3.75953,-.35985,31.09873,-3.82747};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_2()
		{
			double[] value = {-.36195,31.23455,-3.77677,-.40674,31.25921,-3.75589,-.41508,31.19827,-3.70866,-.34158,31.18966,-3.72909,-.10003,30.1826,-2.37069,-.11722,30.15387,-2.37566,-.09357,30.15543,-2.3558,0.0,31.20388,-3.27394,0.0,31.22498,-3.32304,-.0986,31.26764,-3.27669,-.09887,31.25991,-3.33729,-1.01425,31.14417,-3.66096,-1.01723,31.1025,-3.60401,-1.10093,31.14364,-3.58169,-1.10553,31.1958,-3.62424,-.59993,30.98305,-3.63759,-.60026,30.92512,-3.56913,-.72396,30.97109,-3.60128,-.71853,31.02682,-3.64884,-.07525,30.86242,-3.06788,-.14633,30.82019,-3.06613,-.07536,30.82334,-3.05931,-.1455,30.86292,-3.08244,-.23125,30.8678,-3.12695,-.33785,30.81953,-3.13126,-.23232,30.81904,-3.09713,-.34176,30.88539,-3.15818,-.50463,30.87851,-3.21875,-.5596,30.93612,-3.26686,0.0,30.42901,-2.84629,0.0,30.44195,-2.86728,-.08785,30.42724,-2.86614,-.08882,30.42745,-2.84172,-.21559,30.26972,-2.63701,-.22387,30.21504,-2.59719,-.21065,30.23886,-2.5855,-.573,31.12854,-3.73836,-.57503,31.09585,-3.74112,-.68917,31.16508,-3.73618,-.25444,30.16673,-2.92941,-.23449,30.13171,-2.92759,-.27122,30.14436,-2.90449,-.22067,30.15434,-2.94463,-.16738,30.16168,-2.95728,-.09046,30.15752,-2.96748,-.1663,30.14491,-2.9418,-.08678,30.14199,-2.94591,-.29372,30.32477,-2.89127,-.29354,30.26951,-2.91764,-.25426,30.30451,-2.89947,-.24468,30.39361,-2.87849,-.23434,30.37789,-2.88015,-.205,30.41798,-2.87981,-.15655,30.59302,-2.97037,-.07834,30.55047,-2.9453,-.07945,30.60362,-2.97362,-.15563,30.54506,-2.93403,-.49972,30.60983,-3.10022,-.47852,30.65299,-3.16098,-.48787,30.62626,-3.19063,-.50116,30.58224,-3.13502,-1.08931,31.26802,-3.6154,-1.09323,31.25015,-3.66908,-1.09319,31.21342,-3.57382,-.3632,31.16978,-3.85823,-.35643,31.19696,-3.82502,-.33774,31.15389,-3.77301,-.31643,31.11597,-3.73402,-.21171,31.14444,-3.65639,-.30983,31.03679,-3.70101,-.22784,31.03287,-3.672,-.49498,30.55556,-3.17992,-.49087,30.60405,-3.21995,-.16445,30.11431,-2.48815,-.1527,30.08123,-2.50167,-.12743,30.07622,-2.40963,-.08362,30.32468,-2.63487,-.08217,30.28531,-2.58068,0.0,30.30401,-2.58035,0.0,30.33118,-2.63531,-.28464,30.30714,-2.78098,-.22523,30.31103,-2.72246,-.23255,30.35557,-2.76508,-.0918,30.40411,-2.75776,0.0,30.37022,-2.70846,0.0,30.39793,-2.76573,-.0941,30.36791,-2.70864,-.40256,30.5176,-2.98839,-.33181,30.49239,-2.94133,-.35669,30.5339,-2.97624,-.36284,30.4611,-2.95851,-.39926,30.5958,-2.9899,-.44846,30.57358,-3.01464,-.46468,30.5516,-3.03524,-.47205,30.62976,-3.0749,-.34156,30.68802,-3.02842,-.24212,30.70512,-3.02359,-.2339,30.74115,-3.04872,-.33777,30.72418,-3.08327,0.0,30.72877,-3.0257};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_3()
		{
			double[] value = {0.0,30.75623,-3.03627,-.07848,30.75071,-3.03948,-.07773,30.72819,-3.02206,-.41555,30.81286,-3.16047,-.40315,30.75392,-3.14154,-.33063,30.77099,-3.10717,-.22981,30.78814,-3.08724,-.14747,30.79479,-3.06611,-.77898,31.1241,-3.40036,-.66709,31.07033,-3.33068,-.47434,30.99922,-3.24069,-.35723,30.96502,-3.19906,-.43803,30.9115,-3.2049,-.15997,30.93915,-3.12121,-.25653,30.9478,-3.15619,-.3945,31.05094,-3.22612,-.28128,31.03395,-3.19127,-.6559,31.1299,-3.34429,-.62955,31.11623,-3.32657,-.64808,31.20402,-3.37282,-.27526,30.12039,-2.85177,-.30375,30.14249,-2.83962,-.30894,30.15662,-2.88523,-.04463,30.07802,-2.38629,-.04248,30.11582,-2.3517,-.07249,30.07598,-2.39477,-.14105,30.07285,-2.50766,-.10654,30.07043,-2.4044,-.20435,30.0844,-2.56235,-.2106,30.13083,-2.5472,-.17921,30.06466,-2.56712,-.19932,30.08758,-2.61752,-.21246,30.11619,-2.60438,-.06244,30.0728,-2.55496,-.12697,30.06697,-2.56261,-.15975,30.17633,-2.97055,-.09062,30.17533,-2.9727,-.09166,30.21435,-3.0143,-.15083,30.19901,-3.01329,0.0,30.2126,-3.01867,0.0,30.24836,-3.07953,-.09972,30.24078,-3.07808,-.20424,30.21666,-3.06596,-.25792,30.21936,-3.05319,-.27509,30.27917,-3.10837,-.21409,30.2855,-3.11507,-.33286,30.38892,-3.21781,-.386,30.49813,-3.30518,-.28548,30.49367,-3.32929,-.24824,30.4005,-3.23093,-.44097,30.51103,-3.26679,-.464,30.57963,-3.28245,-.40137,30.57681,-3.31126,-.33201,30.76978,-3.47286,-.24929,30.75465,-3.48271,-.23696,30.69497,-3.42402,-.34273,30.70714,-3.43253,-.51736,30.88697,-3.55874,-.49541,30.79614,-3.4811,-.71009,31.09134,-3.70353,-.807,31.06735,-3.6634,-.79251,31.13549,-3.70391,-1.07652,31.31096,-3.69956,-1.00068,31.28465,-3.74269,-1.00714,31.21072,-3.69787,-.5973,31.03616,-3.69879,-.49961,31.21777,-3.83676,-.53672,31.21086,-3.7599,-.51113,31.25694,-3.78836,-.51713,31.16536,-3.79955,-.48299,31.21038,-3.70298,-.52375,31.22735,-3.72373,-.54112,31.1926,-3.69141,-.67523,31.20562,-3.67144,-.75515,31.24989,-3.64631,-.65111,31.20999,-3.59889,-.33218,31.17333,-3.67924,-.41283,31.15651,-3.64643,-.54118,31.24194,-3.38027,-.41202,31.22433,-3.33612,-.53478,31.22615,-3.44351,-.41583,31.22781,-3.40037,-.2409,30.96051,-3.64065,-.13524,31.04292,-3.66399,-.14584,30.9448,-3.64907,-.55103,31.18966,-3.67855,-.50009,31.1644,-3.64065,-.64387,31.24383,-3.42265,-.53875,31.18287,-3.32362,-.48017,30.97632,-3.72918,-.4658,30.91879,-3.66079,-.51521,31.00533,-3.7109,-.516,30.95073,-3.64531,-.44114,30.77469,-3.50024,-.47578,30.78908,-3.49475,-.49427,30.8825,-3.56475,-.45944,30.85361,-3.57831,-.37255,30.82642,-3.57585,-.33645,30.9014,-3.60657,-.34111,30.84471,-3.53617};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_4()
		{
			double[] value = {-.37793,30.89775,-3.64454,-.34403,30.76909,-3.47648,-.36024,30.71634,-3.44112,-.36913,30.76268,-3.49908,-.49952,31.26302,-3.7907,-.50334,31.2682,-3.76173,-.48859,31.26531,-3.76977,-.36553,31.20414,-3.83101,-.3723,31.23611,-3.7864,-.34455,30.6665,-3.39161,-.51441,31.14675,-3.79838,-.53855,31.11541,-3.74907,-.33499,31.13829,-3.7472,-.31892,31.17149,-3.64941,-.42666,30.66869,-3.37774,-.43864,30.73833,-3.41999,-.45693,30.73826,-3.40644,-.46303,31.2673,-3.78705,-.4099,31.26232,-3.7677,-.40861,31.25626,-3.78521,-.46814,31.27003,-3.76708,-.57037,31.17837,-3.70929,-.62272,31.19177,-3.67746,-.45734,30.67514,-3.18351,-.41893,30.70211,-3.15455,-.10972,30.6218,-3.33324,-.10881,30.62658,-3.34672,0.0,30.61381,-3.34768,0.0,30.62109,-3.33241,-.23197,30.77446,-3.08828,-.07905,30.7614,-3.05167,-.15321,30.75595,-3.04835,-.1534,30.74817,-3.03427,-.44666,30.67354,-3.13253,-.39774,30.69572,-3.11581,-.21533,30.57263,-3.33611,-.30411,30.57048,-3.33716,0.0,30.57151,-3.33721,-.11146,30.56924,-3.32983,-.6893,30.90901,-3.39267,-.82407,30.9694,-3.46982,-.23845,30.18926,-3.00415,0.0,31.2138,-3.35419,0.0,31.20915,-3.36853,-.1015,31.22136,-3.38225,-.10083,31.22829,-3.3696,-.19006,31.22575,-3.39424,-.30887,31.23815,-3.38733,-.25197,30.28628,-2.90218,-.25422,30.27892,-2.90085,-.24541,30.22296,-2.9251,-.15917,30.40966,-2.87946,-.20356,30.38521,-2.87502,0.0,30.43235,-2.87567,-.08703,30.41782,-2.88028,.51036,31.08312,-3.26413,.59827,31.04056,-3.29109,.62955,31.11623,-3.32657,.47434,30.99922,-3.24069,.2318,30.36641,-2.88109,.20356,30.38521,-2.87502,.23169,30.36524,-2.87893,.2041,30.38753,-2.8762,.25197,30.28628,-2.90218,.2406,30.33474,-2.89069,.25422,30.27892,-2.90085,.24072,30.33372,-2.88824,.15294,30.20487,-2.96807,.20062,30.19839,-2.95411,.20022,30.19668,-2.95259,.15418,30.19222,-2.96979,.09186,30.21471,-2.96563,0.0,30.19849,-2.96976,.09021,30.19384,-2.97136,.23622,30.10806,-2.86971,.2282,30.11304,-2.80332,.15787,30.11655,-2.81628,.16523,30.12138,-2.88644,.30558,30.43692,-2.90647,.29372,30.32477,-2.89127,.3312,30.39864,-2.92504,.26896,30.36491,-2.88399,.69404,30.9703,-3.32973,.50463,30.87851,-3.21875,.54146,30.8688,-3.24917,0.0,30.61259,-3.32008,.11073,30.62,-3.31544,.11117,30.61247,-3.31167,.1112,30.58481,-3.32972,.21558,30.58679,-3.33262,.11146,30.56924,-3.32983,.21533,30.57263,-3.33611,.30414,30.58285,-3.33138,.40362,30.58549,-3.30859,.30411,30.57048,-3.33716,.40137,30.57681,-3.31126,.46198,30.58765,-3.28358,.48034,30.59374,-3.26709,.464,30.57963,-3.28245,.48338,30.58508,-3.26156};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_5()
		{
			double[] value = {.07792,30.77993,-3.05926,.14747,30.79479,-3.06611,.08085,30.79593,-3.05647,.15068,30.77327,-3.07839,.21568,30.6234,-3.338,.10972,30.6218,-3.33324,.21569,30.6318,-3.35265,.10881,30.62658,-3.34672,.07944,30.76552,-3.06271,.1556,30.75846,-3.07522,.08052,30.77166,-3.06543,.15577,30.76602,-3.0805,.68185,30.87913,-3.43763,.54356,30.78476,-3.36199,.50858,30.77054,-3.37924,.46814,31.27003,-3.76708,.48859,31.26531,-3.76977,.46303,31.2673,-3.78705,.36553,31.20414,-3.83101,.39891,31.21354,-3.84375,.36974,31.18335,-3.85653,.3723,31.23611,-3.7864,.4099,31.26232,-3.7677,.40861,31.25626,-3.78521,.49039,31.22567,-3.83833,.46209,31.18591,-3.8663,.45232,31.22161,-3.84688,.59378,31.20952,-3.61255,.51807,31.19939,-3.55226,.65111,31.20999,-3.59889,.51468,31.07115,-3.76166,.53855,31.11541,-3.74907,.53126,31.07639,-3.75038,.51441,31.14675,-3.79838,.49427,30.8825,-3.56475,.51736,30.88697,-3.55874,.49541,30.79614,-3.4811,.47578,30.78908,-3.49475,.3323,30.97258,-3.66111,.31205,30.97526,-3.65282,.30983,31.03679,-3.70101,.33025,31.03343,-3.72392,.36024,30.71634,-3.44112,.34273,30.70714,-3.43253,.33201,30.76978,-3.47286,.34403,30.76909,-3.47648,.55103,31.18966,-3.67855,.50009,31.1644,-3.64065,.45693,30.73826,-3.40644,.42666,30.66869,-3.37774,.43864,30.73833,-3.41999,.36195,31.23455,-3.77677,.40674,31.25921,-3.75589,.46925,31.26919,-3.75487,.50334,31.2682,-3.76173,.51113,31.25694,-3.78836,.49952,31.26302,-3.7907,.49961,31.21777,-3.83676,.44114,30.77469,-3.50024,.36913,30.76268,-3.49908,.37255,30.82642,-3.57585,.34111,30.84471,-3.53617,.48017,30.97632,-3.72918,.48036,31.03728,-3.79191,.51521,31.00533,-3.7109,.64387,31.24383,-3.42265,.64808,31.20402,-3.37282,.73835,31.24577,-3.47762,.55038,31.17437,-3.71527,.54112,31.1926,-3.69141,.57037,31.17837,-3.70929,.2409,30.96051,-3.64065,.22784,31.03287,-3.672,.64303,31.22537,-3.49847,.73843,31.25427,-3.5626,.62272,31.19177,-3.67746,.67523,31.20562,-3.67144,.86811,31.27772,-3.69917,.77423,31.20626,-3.72702,.75515,31.24989,-3.64631,.88112,31.25577,-3.7277,1.07652,31.31096,-3.69956,1.00068,31.28465,-3.74269,.99346,31.31132,-3.72469,.89382,31.16943,-3.71137,1.00714,31.21072,-3.69787,.71853,31.02682,-3.64884,.5973,31.03616,-3.69879,.71009,31.09134,-3.70353,.59993,30.98305,-3.63759,.24929,30.75465,-3.48271,.14591,30.80312,-3.5475,.24753,30.8266,-3.53927,.14489,30.73836,-3.48008,1.03167,31.09821,-3.5491,1.01723,31.1025,-3.60401,1.10093,31.14364,-3.58169,.71611,30.90782,-3.50298,.58431,30.8482,-3.45605,.11994,30.66252,-3.41147};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_6()
		{
			double[] value = {.23287,30.67389,-3.39952,.48078,30.62199,-3.3152,.42246,30.61922,-3.33283,.48995,30.69074,-3.35277,.28548,30.49367,-3.32929,.19017,30.40509,-3.24387,.20914,30.50119,-3.33177,.24824,30.4005,-3.23093,.44097,30.51103,-3.26679,.47424,30.5326,-3.22225,.22067,30.15434,-2.94463,.16738,30.16168,-2.95728,.20485,30.17587,-2.955,.15975,30.17633,-2.97055,.09046,30.15752,-2.96748,0.0,30.15572,-2.97,.09062,30.17533,-2.9727,0.0,30.18076,-2.97357,.30375,30.14249,-2.83962,.26482,30.12246,-2.79099,.27526,30.12039,-2.85177,.27535,30.14632,-2.77836,.06902,30.11021,-2.72207,.14307,30.10193,-2.64479,.06216,30.09366,-2.64592,.14815,30.10647,-2.7225,.14105,30.07285,-2.50766,.10654,30.07043,-2.4044,.10052,30.07073,-2.50277,.07249,30.07598,-2.39477,.09292,30.10905,-2.36663,.12743,30.07622,-2.40963,.12483,30.11721,-2.39107,.75489,31.18506,-3.4314,.6559,31.1299,-3.34429,.77898,31.1241,-3.40036,.66709,31.07033,-3.33068,.34176,30.88539,-3.15818,.25653,30.9478,-3.15619,.23125,30.8678,-3.12695,.35723,30.96502,-3.19906,.68826,31.01159,-3.31981,.5596,30.93612,-3.26686,.90871,31.12155,-3.45724,.79901,31.07039,-3.402,.8899,31.17292,-3.47306,1.03113,31.12937,-3.51235,1.088,31.1728,-3.55075,1.01787,31.15893,-3.51416,.34156,30.68802,-3.02842,.42671,30.65438,-3.047,.33777,30.72418,-3.08327,.39774,30.69572,-3.11581,.205,30.41798,-2.87981,.15327,30.49288,-2.90072,.15781,30.44029,-2.87878,.21314,30.47903,-2.89841,.10003,30.1826,-2.37069,.11722,30.15387,-2.37566,.14757,30.20144,-2.46062,.12136,30.22982,-2.46015,.15748,30.25443,-2.50523,.19631,30.23301,-2.56008,.16212,30.26426,-2.55077,.18646,30.21594,-2.51647,.31384,30.22245,-2.86205,.30326,30.26881,-2.79749,.31019,30.19761,-2.82371,.49498,30.55556,-3.17992,.49087,30.60405,-3.21995,.34613,31.11435,-3.75953,.33499,31.13829,-3.7472,.35985,31.09873,-3.82747,.33774,31.15389,-3.77301,1.0682,31.32914,-3.66264,.99096,31.32696,-3.67836,.984,31.31074,-3.62043,.09357,30.15543,-2.3558,.04248,30.11582,-2.3517,.04524,30.16355,-2.34869,.08649,30.43343,-2.88364,.16018,30.42278,-2.87809,.07872,30.44528,-2.89365,.07773,30.72819,-3.02206,.1534,30.74817,-3.03427,.07848,30.75071,-3.03948,.15536,30.72109,-3.01918,.52459,30.71591,-3.31331,.50563,30.64707,-3.26463,.2038,30.39991,-2.8761,0.0,30.13407,-2.95097,.08678,30.14199,-2.94591,.23449,30.13171,-2.92759,.1663,30.14491,-2.9418,.573,31.12854,-3.73836,.57503,31.09585,-3.74112,.14633,30.82019,-3.06613,.23232,30.81904,-3.09713,.1455,30.86292,-3.08244,.31493,30.90168,-3.59893};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_7()
		{
			double[] value = {.32906,30.84594,-3.53397,.24825,30.88991,-3.58955,.09887,31.25991,-3.33729,.10083,31.22829,-3.3696,.08952,31.15268,-3.19711,.0986,31.26764,-3.27669,0.0,31.1488,-3.18965,.9096,31.06031,-3.62001,.92088,31.03178,-3.56615,.45584,30.6009,-3.2725,.44208,30.71801,-3.15419,.45734,30.67514,-3.18351,.49621,30.69973,-3.16833,.41893,30.70211,-3.15455,.21348,30.63038,-3.31551,.47247,30.60815,-3.29889,.45561,30.60745,-3.28048,.40842,30.61186,-3.30146,.41662,30.60875,-3.31926,.47317,30.61648,-3.23338,.48709,30.6125,-3.22513,.47379,30.64281,-3.20386,.48335,30.63216,-3.19864,.23197,30.77446,-3.08828,.33317,30.74163,-3.11286,.33258,30.75247,-3.10656,.23356,30.75907,-3.09141,.15321,30.75595,-3.04835,.07905,30.7614,-3.05167,0.0,30.78075,-3.05533,0.0,30.7718,-3.05619,.23774,30.36628,-2.87317,.25315,30.33141,-2.88219,.2843,30.25854,-2.89785,.2016,30.3904,-2.87153,.15917,30.40966,-2.87946,.15749,30.41317,-2.87081,.08703,30.41782,-2.88028,.08785,30.42724,-2.86614,.24541,30.22296,-2.9251,.237,30.18712,-2.94021,.22439,30.19877,-2.94367,.27586,30.19993,-2.92427,.22659,30.13679,-2.6301,.19301,30.13298,-2.6128,.21826,30.11214,-2.63879,0.0,30.29253,-2.57421,.07893,30.2677,-2.57416,.08217,30.28531,-2.58068,.21246,30.11619,-2.60438,.21053,30.17325,-2.59706,.21907,30.1621,-2.58293,.18265,30.10632,-2.62311,.20049,30.09774,-2.64527,.13839,30.11491,-2.62161,.36981,30.44512,-2.97181,.36284,30.4611,-2.95851,.29144,30.23039,-3.03614,.31825,30.29358,-3.08763,.30848,30.25105,-3.01668,.34477,30.31801,-3.06739,.23645,30.10798,-2.71155,.23981,30.13125,-2.70314,.28185,30.17104,-2.77185,.24773,30.19564,-2.66703,.24391,30.15361,-2.69081,.2816,30.22587,-2.75714,.23696,30.69497,-3.42402,.478,30.81149,-3.18965,.52664,30.79668,-3.20694,.30771,31.23961,-3.37251,.41583,31.22781,-3.40037,.30887,31.23815,-3.38733,.3198,31.19294,-3.56899,.41429,31.19785,-3.54175,.31892,31.17149,-3.64941,.43803,30.9115,-3.2049,.43258,30.88757,-3.19412,.28921,30.29935,-2.84002,.3206,31.21421,-3.51363,.18665,31.27077,-3.34611,.18918,31.23288,-3.38181,.2403,30.23764,-2.65052,.26454,30.26217,-2.74475,.27034,30.19241,-2.97595,.45764,30.46278,-3.10655,.4245,30.46028,-3.03767,.41074,30.42059,-3.07694,.46635,30.50912,-3.06943,.82203,31.01577,-3.40891,.06179,30.11158,-2.62126,.06161,30.09323,-2.61254,.13831,30.09542,-2.61773,.22704,30.18194,-2.60871,.21018,30.19533,-2.58931,.2109,30.20279,-2.57189,.20221,30.22812,-2.57552,.16569,30.25731,-2.5688,0.0,30.30565,-2.5521,.08308,30.29083,-2.54871};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_8()
		{
			double[] value = {.08589,30.21792,-2.97806,.19478,30.19708,-2.97036,.14525,30.20783,-2.97819,.22412,30.19708,-2.95821,.22483,30.20067,-2.94526,.25225,30.21898,-2.93521,.2454,30.2242,-2.92698,.25336,30.27768,-2.9044,.25972,30.26885,-2.90985,.08677,30.41949,-2.88345,.15971,30.41148,-2.88215,.24183,30.34342,-2.89009,.25426,30.30451,-2.89947,.23571,30.7494,-3.08551,.33579,30.72858,-3.09943,.33249,30.7335,-3.10671,.23262,30.75043,-3.06238,.39449,30.70077,-3.12471,.43653,30.67977,-3.13977,.42088,30.68793,-3.149,.38579,30.71117,-3.13393,.47212,30.65764,-3.16963,.45632,30.66191,-3.17849,.40896,30.60481,-3.29702,.30624,30.61367,-3.30237,.21344,30.62309,-3.31066,.36279,31.02339,-3.77839,.34158,31.18966,-3.72909,.41508,31.19827,-3.70866,1.01425,31.14417,-3.66096,1.10553,31.1958,-3.62424,.72396,30.97109,-3.60128,.60026,30.92512,-3.56913,.37793,30.89775,-3.64454,.45944,30.85361,-3.57831,.4658,30.91879,-3.66079,.07525,30.86242,-3.06788,.07536,30.82334,-3.05931,.33785,30.81953,-3.13126,.08882,30.42745,-2.84172,.21065,30.23886,-2.5855,.22387,30.21504,-2.59719,.21559,30.26972,-2.63701,.68917,31.16508,-3.73618,.25444,30.16673,-2.92941,.27122,30.14436,-2.90449,.29354,30.26951,-2.91764,.24468,30.39361,-2.87849,.23434,30.37789,-2.88015,.15563,30.54506,-2.93403,.07945,30.60362,-2.97362,.07834,30.55047,-2.9453,.15655,30.59302,-2.97037,.49972,30.60983,-3.10022,.48787,30.62626,-3.19063,.47852,30.65299,-3.16098,.50116,30.58224,-3.13502,.3632,31.16978,-3.85823,.35643,31.19696,-3.82502,.21171,31.14444,-3.65639,.31643,31.11597,-3.73402,.16445,30.11431,-2.48815,.1527,30.08123,-2.50167,.08362,30.32468,-2.63487,.28464,30.30714,-2.78098,.23255,30.35557,-2.76508,.22523,30.31103,-2.72246,.35669,30.5339,-2.97624,.33181,30.49239,-2.94133,.40256,30.5176,-2.98839,.39926,30.5958,-2.9899,.44846,30.57358,-3.01464,.46468,30.5516,-3.03524,.47205,30.62976,-3.0749,.24212,30.70512,-3.02359,.2339,30.74115,-3.04872,.41555,30.81286,-3.16047,.33063,30.77099,-3.10717,.40315,30.75392,-3.14154,.22981,30.78814,-3.08724,.15997,30.93915,-3.12121,.30894,30.15662,-2.88523,.04463,30.07802,-2.38629,.20435,30.0844,-2.56235,.2106,30.13083,-2.5472,.17921,30.06466,-2.56712,.19932,30.08758,-2.61752,.12697,30.06697,-2.56261,.06244,30.0728,-2.55496,.0812,30.12391,-2.89178,0.0,30.12295,-2.89343,.09166,30.21435,-3.0143,.15083,30.19901,-3.01329,.09972,30.24078,-3.07808,.20424,30.21666,-3.06596,.27509,30.27917,-3.10837,.25792,30.21936,-3.05319,.21409,30.2855,-3.11507,.386,30.49813,-3.30518,.33286,30.38892,-3.21781};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_9()
		{
			double[] value = {.79251,31.13549,-3.70391,.807,31.06735,-3.6634,1.09323,31.25015,-3.66908,.53672,31.21086,-3.7599,.51713,31.16536,-3.79955,.48299,31.21038,-3.70298,.52375,31.22735,-3.72373,.41283,31.15651,-3.64643,.33218,31.17333,-3.67924,.41202,31.22433,-3.33612,.54118,31.24194,-3.38027,.53478,31.22615,-3.44351,.13524,31.04292,-3.66399,.14584,30.9448,-3.64907,.53875,31.18287,-3.32362,.516,30.95073,-3.64531,.33645,30.9014,-3.60657,.34455,30.6665,-3.39161,.53294,31.01088,-3.70322,.44666,30.67354,-3.13253,.82407,30.9694,-3.46982,.6893,30.90901,-3.39267,.23845,30.18926,-3.00415,.1015,31.22136,-3.38225,.19006,31.22575,-3.39424,-.59827,31.04056,-3.29109,-.51036,31.08312,-3.26413,-.2318,30.36641,-2.88109,-.23169,30.36524,-2.87893,-.2406,30.33474,-2.89069,-.24072,30.33372,-2.88824,-.20022,30.19668,-2.95259,-.15418,30.19222,-2.96979,-.09021,30.19384,-2.97136,-.30558,30.43692,-2.90647,-.3312,30.39864,-2.92504,-.26896,30.36491,-2.88399,-.54146,30.8688,-3.24917,-.11073,30.62,-3.31544,-.08085,30.79593,-3.05647,-.21568,30.6234,-3.338,-.21569,30.6318,-3.35265,-.47247,30.60815,-3.29889,-.49917,30.62877,-3.25211,-.48078,30.62199,-3.3152,-.50563,30.64707,-3.26463,-.1556,30.75846,-3.07522,-.07944,30.76552,-3.06271,-.36974,31.18335,-3.85653,-.39891,31.21354,-3.84375,-.49039,31.22567,-3.83833,-.45232,31.22161,-3.84688,-.46209,31.18591,-3.8663,-.59378,31.20952,-3.61255,-.51807,31.19939,-3.55226,-.51468,31.07115,-3.76166,-.53126,31.07639,-3.75038,-.3323,30.97258,-3.66111,-.31205,30.97526,-3.65282,-.46925,31.26919,-3.75487,-.37324,30.959,-3.71394,-.73835,31.24577,-3.47762,-.55038,31.17437,-3.71527,-.64303,31.22537,-3.49847,-.73843,31.25427,-3.5626,-.99346,31.31132,-3.72469,-.88112,31.25577,-3.7277,-.89382,31.16943,-3.71137,-.24753,30.8266,-3.53927,-.14591,30.80312,-3.5475,-.14489,30.73836,-3.48008,-1.03167,31.09821,-3.5491,-.71611,30.90782,-3.50298,-.11994,30.66252,-3.41147,-.23287,30.67389,-3.39952,-.42246,30.61922,-3.33283,-.20914,30.50119,-3.33177,-.19017,30.40509,-3.24387,-.48338,30.58508,-3.26156,-.47424,30.5326,-3.22225,-.20485,30.17587,-2.955,-.26482,30.12246,-2.79099,-.27535,30.14632,-2.77836,-.23645,30.10798,-2.71155,-.20049,30.09774,-2.64527,-.21826,30.11214,-2.63879,-.2122,30.09817,-2.7197,-.06902,30.11021,-2.72207,-.06216,30.09366,-2.64592,-.14307,30.10193,-2.64479,-.14815,30.10647,-2.7225,-.10052,30.07073,-2.50277,-.09292,30.10905,-2.36663,-.12483,30.11721,-2.39107,-.75489,31.18506,-3.4314,-.8899,31.17292,-3.47306,-.90871,31.12155,-3.45724,-1.03113,31.12937,-3.51235,-1.01787,31.15893,-3.51416,-1.088,31.1728,-3.55075};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_10()
		{
			double[] value = {-.42671,30.65438,-3.047,-.27027,30.33947,-2.8299,-.21936,30.37686,-2.8192,-.17075,30.34892,-2.71175,-.17258,30.38693,-2.75621,-.12136,30.22982,-2.46015,-.14757,30.20144,-2.46062,-.15748,30.25443,-2.50523,-.18646,30.21594,-2.51647,-.31019,30.19761,-2.82371,0.0,30.93428,-3.65112,0.0,31.01582,-3.68286,-1.0682,31.32914,-3.66264,-.984,31.31074,-3.62043,-.99096,31.32696,-3.67836,-.04524,30.16355,-2.34869,-.055,30.21169,-2.37399,-.06939,30.25133,-2.46423,-.15781,30.44029,-2.87878,-.07872,30.44528,-2.89365,-.15536,30.72109,-3.01918,-.20215,30.1817,-2.52817,-.15689,30.15894,-2.4722,-.31493,30.90168,-3.59893,-.32906,30.84594,-3.53397,-.24825,30.88991,-3.58955,-.08952,31.15268,-3.19711,-.9096,31.06031,-3.62001,-.92088,31.03178,-3.56615,-.48034,30.59374,-3.26709,-.44208,30.71801,-3.15419,-.49621,30.69973,-3.16833,-.21348,30.63038,-3.31551,-.45561,30.60745,-3.28048,-.41662,30.60875,-3.31926,-.40842,30.61186,-3.30146,-.48709,30.6125,-3.22513,-.47317,30.61648,-3.23338,-.23356,30.75907,-3.09141,-.33258,30.75247,-3.10656,-.33317,30.74163,-3.11286,-.23774,30.36628,-2.87317,-.25315,30.33141,-2.88219,-.2843,30.25854,-2.89785,-.2016,30.3904,-2.87153,-.15749,30.41317,-2.87081,-.27586,30.19993,-2.92427,-.22439,30.19877,-2.94367,-.237,30.18712,-2.94021,-.07893,30.2677,-2.57416,-.08308,30.29083,-2.54871,-.21907,30.1621,-2.58293,-.18265,30.10632,-2.62311,-.36981,30.44512,-2.97181,-.31825,30.29358,-3.08763,-.34477,30.31801,-3.06739,-.23981,30.13125,-2.70314,-.24391,30.15361,-2.69081,-.28185,30.17104,-2.77185,-.52664,30.79668,-3.20694,-.478,30.81149,-3.18965,-.43258,30.88757,-3.19412,-.55073,30.82692,-3.30317,-.53802,30.75611,-3.25349,-.34592,30.36389,-3.14296,-.38091,30.38612,-3.11395,-.37952,30.40079,-2.99842,-.4169,30.49828,-3.00583,-.36951,30.35367,-3.03282,-.39475,30.40273,-3.18818,-.3008,30.34964,-3.15709,-.28324,30.2164,-2.94666,-.32447,30.284,-2.98854,-.3329,30.33229,-2.95431,0.0,30.07935,-2.38398,0.0,30.1214,-2.35087,-.16646,30.26953,-2.57535,-.24183,30.34342,-2.89009,0.0,30.7651,-3.05371,0.0,30.76315,-3.04498,-.47526,30.65397,-3.21045,-.50983,30.67494,-3.19839,-.47452,30.62605,-3.23955,-.11382,31.15641,-3.59228,0.0,31.1259,-3.65975,-.12305,31.1362,-3.65647,0.0,31.14457,-3.5697,0.0,31.18072,-3.46641,-.10609,31.19889,-3.47915,-.21269,31.16735,-3.59596,-.1966,31.2048,-3.48512,-.48036,31.03728,-3.79191,-.47357,31.10396,-3.83878,-.14771,30.86984,-3.59092,-.81491,31.01758,-3.60963,-.90398,31.10324,-3.66795,-.16088,30.41041,-2.84383,-.20876,30.38782,-2.84649,-.25666,30.35612,-2.85317,-.27363,30.31902,-2.86578};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_11()
		{
			double[] value = {-.29962,30.2434,-2.88584,-.29185,30.18231,-2.91026,0.0,30.85573,-3.59714,-.08542,31.01938,-3.14367,-.07092,30.92829,-3.10182,-.17661,31.02651,-3.15351,-.07851,30.67063,-2.98531,-.15475,30.6614,-2.98059,-.15327,30.49288,-2.90072,-.07679,30.49706,-2.91321,-.08943,30.42588,-2.81826,-.16559,30.40537,-2.81684,-.16434,30.30327,-2.63092,-.0754,30.28666,-2.50632,0.0,30.60493,-2.97621,0.0,30.67188,-2.99643,-.4163,31.17457,-3.28266,-.86811,31.27772,-3.69917,-.85194,31.28871,-3.62289,-.92392,31.0693,-3.45695,-.92074,31.01998,-3.50725,-.43763,30.43071,-3.14955,0.0,30.1724,-2.34486,0.0,30.22479,-2.37233,0.0,30.26503,-2.46182,0.0,30.29739,-2.50601,0.0,30.42851,-2.82567,0.0,30.45967,-2.89739,-.2741,30.45723,-2.90225,-.21314,30.47903,-2.89841,0.0,30.50119,-2.91853,-.21642,30.53154,-2.93236,-.29046,30.50976,-2.93448,-.30262,30.55999,-2.96497,-.22707,30.58201,-2.96711,0.0,30.55236,-2.95041,-.32628,30.62335,-2.97459,-.23265,30.6488,-2.97764,-.45137,30.74448,-3.16055,-.5035,30.72312,-3.17248,-1.00042,31.20653,-3.53157,0.0,31.0207,-3.13391,0.0,30.92297,-3.0915,-.8676,31.22697,-3.51134,-.98552,31.25549,-3.56505,-.85578,31.27828,-3.56267,-.30033,31.17297,-3.23681,-.30232,31.24042,-3.28752,-.05349,30.07577,-2.49637,0.0,30.07288,-2.55307,0.0,30.07416,-2.49579,0.0,30.1097,-2.72237,0.0,30.09854,-2.64316,-.15787,30.11655,-2.81628,-.2282,30.11304,-2.80332,0.0,30.12335,-2.81892,-.07671,30.12065,-2.81701,-.0812,30.12391,-2.89178,-.16523,30.12138,-2.88644,-.23622,30.10806,-2.86971,-.19272,30.18802,-3.01269,-.15471,30.22752,-3.07208,-.16221,30.2892,-3.11873,-.10376,30.30026,-3.12154,-.22868,30.35411,-3.16867,-.10618,30.36097,-3.18418,-.17425,30.35612,-3.17971,0.0,30.41102,-3.24688,-.10852,30.41071,-3.25005,0.0,30.36659,-3.1876,-.11202,30.50831,-3.32678,0.0,30.5123,-3.33054,-.51655,30.6886,-3.20816,-.31514,30.62767,-3.35052,0.0,30.64612,-3.41824,-.82849,30.98215,-3.52833,0.0,30.7202,-3.48959,0.0,30.78448,-3.54647,-.53294,31.01088,-3.70322,-.53575,30.95563,-3.63883,-.77423,31.20626,-3.72702,-.46956,31.17257,-3.86815,-.18426,31.2825,-3.28004,-.38405,30.72204,-3.1381,-.39287,30.73628,-3.13363,-.30984,30.61826,-3.33609,0.0,30.79757,-3.05269,.30245,30.62368,-3.30739,.31514,30.62767,-3.35052,.30984,30.61826,-3.33609,.49917,30.62877,-3.25211,.51655,30.6886,-3.20816,.5035,30.72312,-3.17248,.50983,30.67494,-3.19839,.39287,30.73628,-3.13363,.45137,30.74448,-3.16055,.47452,30.62605,-3.23955,.47526,30.65397,-3.21045,.38405,30.72204,-3.1381,.55073,30.82692,-3.30317};
			return value;
		}
		private double[] getcoccyx_Coord_9_89_point_12()
		{
			double[] value = {.53575,30.95563,-3.63883,.46956,31.17257,-3.86815,.37324,30.959,-3.71394,.21269,31.16735,-3.59596,.12305,31.1362,-3.65647,.47357,31.10396,-3.83878,.10609,31.19889,-3.47915,.1966,31.2048,-3.48512,.18426,31.2825,-3.28004,.30232,31.24042,-3.28752,.85578,31.27828,-3.56267,.85194,31.28871,-3.62289,.90398,31.10324,-3.66795,.81491,31.01758,-3.60963,.82849,30.98215,-3.52833,.92074,31.01998,-3.50725,.11202,30.50831,-3.32678,.10852,30.41071,-3.25005,.39475,30.40273,-3.18818,.3008,30.34964,-3.15709,.22868,30.35411,-3.16867,.17425,30.35612,-3.17971,.10618,30.36097,-3.18418,0.0,30.30261,-3.12845,.10376,30.30026,-3.12154,.16221,30.2892,-3.11873,.32447,30.284,-2.98854,.36951,30.35367,-3.03282,.15471,30.22752,-3.07208,.19272,30.18802,-3.01269,.29185,30.18231,-2.91026,.07671,30.12065,-2.81701,.2122,30.09817,-2.7197,.05349,30.07577,-2.49637,.29962,30.2434,-2.88584,.4163,31.17457,-3.28266,.18029,31.16418,-3.20498,.28128,31.03395,-3.19127,.30033,31.17297,-3.23681,.17661,31.02651,-3.15351,.8676,31.22697,-3.51134,.98552,31.25549,-3.56505,1.08931,31.26802,-3.6154,1.00042,31.20653,-3.53157,.3945,31.05094,-3.22612,0.0,30.85379,-3.05896,.07092,30.92829,-3.10182,0.0,30.82195,-3.0531,.92392,31.0693,-3.45695,.32628,30.62335,-2.97459,.23265,30.6488,-2.97764,.37952,30.40079,-2.99842,.3329,30.33229,-2.95431,.30262,30.55999,-2.96497,.15475,30.6614,-2.98059,.22707,30.58201,-2.96711,.21642,30.53154,-2.93236,.29046,30.50976,-2.93448,.2741,30.45723,-2.90225,.07679,30.49706,-2.91321,.27363,30.31902,-2.86578,.27027,30.33947,-2.8299,.25666,30.35612,-2.85317,.20876,30.38782,-2.84649,.16559,30.40537,-2.81684,.21936,30.37686,-2.8192,.16088,30.41041,-2.84383,.07851,30.67063,-2.98531,.0918,30.40411,-2.75776,.08943,30.42588,-2.81826,.17075,30.34892,-2.71175,.17258,30.38693,-2.75621,.0941,30.36791,-2.70864,.16646,30.26953,-2.57535,.16434,30.30327,-2.63092,.0754,30.28666,-2.50632,.15689,30.15894,-2.4722,.20215,30.1817,-2.52817,.055,30.21169,-2.37399,1.09319,31.21342,-3.57382,.28324,30.2164,-2.94666,.06939,30.25133,-2.46423,.08542,31.01938,-3.14367,.14771,30.86984,-3.59092,.53802,30.75611,-3.25349,.11382,31.15641,-3.59228,.43763,30.43071,-3.14955,.38091,30.38612,-3.11395,.34592,30.36389,-3.14296,.4169,30.49828,-3.00583,-.30245,30.62368,-3.30739,-.18029,31.16418,-3.20498};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getethmoid_Geo_8_94_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,37,-1,41,42,43,-1,44,45,46,-1,47,30,48,-1,27,34,33,-1,29,49,50,-1,20,51,50,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,25,61,15,-1,62,39,36,-1,63,64,65,-1,65,66,63,-1,41,67,65,-1,37,68,38,-1,69,70,71,-1,72,73,17,-1,74,75,76,-1,77,78,79,-1,64,63,80,-1,64,80,70,-1,81,82,83,-1,84,67,41,-1,85,86,87,-1,88,89,90,-1,91,88,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,107,106,108,-1,12,109,110,-1,111,112,113,-1,114,115,116,-1,117,118,99,-1,116,115,12,-1,98,119,111,-1,120,121,122,-1,123,124,125,-1,126,95,94,-1,127,128,129,-1,130,131,132,-1,133,134,135,-1,136,137,138,-1,139,140,141,-1,142,143,144,-1,130,145,131,-1,146,147,148,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,164,165,88,-1,166,167,168,-1,169,170,155,-1,171,172,147,-1,173,174,146,-1,175,136,176,-1,177,178,179,-1,180,181,119,-1,182,183,184,-1,185,186,187,-1,188,150,152,-1,189,117,190,-1,191,192,193,-1,147,172,191,-1,194,195,196,-1,197,198,199,-1,200,201,202,-1,197,203,204,-1,123,130,205,-1,206,207,208,-1,209,210,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,135,134,-1,222,223,224,-1,225,226,227,-1,228,229,230,-1,231,232,124,-1,233,234,235,-1,236,237,233,-1,220,219,238,-1,239,240,159,-1,241,242,243,-1,172,224,223,-1,244,245,196,-1,246,247,248,-1,249,191,250,-1,251,252,253,-1,254,255,256,-1,257,258,246,-1,259,260,261,-1,262,263,264,-1,265,266,263,-1,267,268,269,-1,93,270,271,-1,272,273,184,-1,10,274,275,-1,276,277,278,-1,279,280,24,-1,281,282,283,-1,218,284,285,-1,286,287,145,-1,288,289,128,-1,214,290,144,-1,291,214,143,-1,292,262,293,-1,110,98,294,-1,295,296,262,-1,274,297,277,-1,298,299,300,-1,301,302,303,-1,304,305,306,-1,307,308,309,-1,310,311,312,-1,313,314,315,-1,316,317,318,-1,314,305,304,-1,319,320,321,-1,300,299,322,-1,323,324,325,-1,326,327,328,-1,329,321,320,-1,329,330,321,-1,331,332,333,-1,334,335,336,-1,337,338,339,-1,340,339,341,-1,342,332,330,-1,343,318,344,-1,345,346,347,-1,348,349,350,-1,351,352,195,-1,194,196,245,-1,353,163,162,-1,354,355,356,-1,357,358,359,-1,360,254,361,-1,362,363,364,-1,225,250,226,-1,365,244,366,-1,367,368,139,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,256,382,-1,253,383,249,-1,313,384,385,-1,386,387,252,-1,388,389,390,-1,391,390,392,-1,393,394,356,-1,395,396,397,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,411,412,-1,413,414,415,-1,416,417,418,-1,419,420,421,-1,422,423,424,-1,86,425,426,-1,427,428,429,-1,430,414,418,-1,431,413,432,-1,433,434,435,-1,96,436,97,-1,433,435,437,-1,438,439,114,-1,440,85,87,-1,441,442,443,-1,444,86,445,-1,98,438,294,-1,446,447,440,-1,448,433,449,-1,450,451,452,-1,451,453,454,-1,454,452,451,-1,455,456,457,-1,458,459,460,-1,457,461,462,-1,463,452,464,-1,465,466,467,-1,468,469,470,-1,471,472,465,-1,473,474,475,-1,476,477,470,-1,478,479,480,-1,481,477,482,-1,483,484,485,-1,474,486,487,-1,488,489,490,-1,491,492,489,-1,493,494,495,-1,496,497,498,-1,499,500,501,-1,502,479,503,-1,504,505,506,-1,507,508,509,-1,510,487,507,-1,506,505,511,-1,512,513,488,-1,514,515,516,-1,517,518,519,-1,519,520,521,-1,522,523,521,-1,524,525,526,-1,527,515,528,-1,529,530,531,-1,517,532,533,-1,534,535,531,-1,536,537,538,-1,539,540,541,-1,542,543,544,-1,545,546,547,-1,548,549,550,-1,551,552,553,-1,554,555,556,-1,557,547,546,-1,558,559,560,-1,561,562,552,-1,549,563,561,-1,564,565,566,-1,567,568,569,-1,567,569,570,-1,571,572,573,-1,574,575,576,-1,572,577,573,-1,578,579,580,-1,581,577,582,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_2()
		{
			int[] value = {583,584,585,-1,586,587,588,-1,589,586,588,-1,590,591,592,-1,593,594,595,-1,596,597,595,-1,598,599,600,-1,601,602,603,-1,604,605,606,-1,607,606,608,-1,609,496,610,-1,611,612,613,-1,613,614,611,-1,615,616,617,-1,618,619,620,-1,621,622,623,-1,615,624,625,-1,626,627,628,-1,629,630,631,-1,632,628,627,-1,631,633,634,-1,635,636,616,-1,637,638,639,-1,640,641,642,-1,643,644,645,-1,642,641,646,-1,647,645,648,-1,649,650,651,-1,652,653,654,-1,655,656,657,-1,658,659,660,-1,661,662,663,-1,654,664,665,-1,657,666,667,-1,659,668,669,-1,662,670,671,-1,665,672,637,-1,673,669,668,-1,674,675,676,-1,677,623,622,-1,678,679,680,-1,616,615,625,-1,622,681,682,-1,682,683,684,-1,685,686,687,-1,688,635,689,-1,690,691,684,-1,692,693,687,-1,688,694,695,-1,696,697,698,-1,699,700,701,-1,702,703,704,-1,705,706,707,-1,708,709,710,-1,711,712,713,-1,714,715,716,-1,717,718,719,-1,720,721,722,-1,723,724,725,-1,726,727,728,-1,729,730,731,-1,732,714,726,-1,731,722,733,-1,725,734,735,-1,736,728,727,-1,709,730,729,-1,737,738,739,-1,740,741,742,-1,701,700,743,-1,698,697,744,-1,745,743,746,-1,707,747,748,-1,749,750,744,-1,751,752,753,-1,754,755,756,-1,757,758,759,-1,760,761,762,-1,763,764,765,-1,766,767,768,-1,769,770,771,-1,772,773,767,-1,774,752,751,-1,772,775,773,-1,776,777,778,-1,779,751,753,-1,759,779,753,-1,740,780,781,-1,782,783,784,-1,785,782,786,-1,787,782,785,-1,788,789,790,-1,791,792,793,-1,794,795,796,-1,797,798,799,-1,800,801,802,-1,803,804,805,-1,806,807,808,-1,809,810,811,-1,812,813,814,-1,815,816,817,-1,818,819,820,-1,821,822,823,-1,824,825,826,-1,827,828,829,-1,830,831,832,-1,833,834,835,-1,836,837,838,-1,839,840,841,-1,842,843,844,-1,845,846,847,-1,848,840,849,-1,839,850,830,-1,851,852,833,-1,844,853,854,-1,847,855,856,-1,857,858,859,-1,841,860,861,-1,862,863,846,-1,864,857,865,-1,866,867,843,-1,868,869,870,-1,871,872,873,-1,874,875,876,-1,877,878,879,-1,880,881,882,-1,883,884,878,-1,885,886,887,-1,888,889,890,-1,891,892,893,-1,894,895,896,-1,897,898,899,-1,900,901,902,-1,903,904,905,-1,906,907,908,-1,907,909,908,-1,910,911,912,-1,913,914,912,-1,915,916,917,-1,918,919,920,-1,921,922,923,-1,924,925,926,-1,927,928,929,-1,930,931,932,-1,933,934,935,-1,936,937,938,-1,939,940,916,-1,941,942,920,-1,943,944,945,-1,946,947,948,-1,948,949,950,-1,951,904,952,-1,953,954,955,-1,956,957,958,-1,954,932,959,-1,960,961,962,-1,790,789,963,-1,964,965,966,-1,816,967,968,-1,969,970,971,-1,972,973,541,-1,492,491,974,-1,975,976,977,-1,978,979,980,-1,981,982,983,-1,981,984,982,-1,985,986,987,-1,988,989,990,-1,991,992,993,-1,994,995,996,-1,997,998,999,-1,1000,1001,1002,-1,1003,1004,1005,-1,1006,1007,1008,-1,1007,1009,1008,-1,1010,292,293,-1,1011,1012,1013,-1,1014,1015,1016,-1,1017,1018,1019,-1,1020,1017,1019,-1,1021,1022,1023,-1,964,1024,1025,-1,1026,1027,1028,-1,1029,1030,1031,-1,1032,1033,1034,-1,1035,1036,1037,-1,790,1038,1039,-1,1040,1041,1042,-1,977,1043,975,-1,1044,980,1045,-1,1046,1047,1048,-1,1049,1050,1051,-1,1052,1053,1054,-1,1054,1055,991,-1,1056,1057,1058,-1,991,1059,1054,-1,1060,1061,1062,-1,1063,1064,1065,-1,1066,1067,1068,-1,1069,1070,1071,-1,1072,1073,1074,-1,1075,1076,1077,-1,1078,1079,1080,-1,1081,1082,1083,-1,1084,1085,1086,-1,1005,513,1087,-1,1088,1089,1090,-1,1091,1092,1093,-1,1094,1095,1096,-1,1097,1098,1099,-1,1100,1101,1102,-1,1103,1104,1105,-1,783,1106,784,-1,1107,1108,1109,-1,1110,1109,1111,-1,1112,1113,1114,-1,1112,1115,1116,-1,1110,1117,1118,-1,1108,1119,1120,-1,1121,1122,1123,-1,1123,1122,1124,-1,1125,1126,1127,-1,1128,520,1129,-1,1130,1131,1132,-1,1133,1134,1135,-1,1136,1135,1137,-1,1138,1139,1140,-1,1050,1049,990,-1,1141,1142,1143,-1,1144,1145,1146,-1,1078,1147,1148,-1,1149,1150,1151,-1,1152,1153,1154,-1,1155,1156,1132,-1,1157,1149,1158,-1,1159,1160,966,-1,1161,1162,1163,-1,1099,1164,1097,-1,1101,1100,1165,-1,1166,780,742,-1,1167,784,1168,-1,1169,1170,1171,-1,1172,1171,1056,-1,968,967,1173,-1,1165,1100,1035,-1,1174,1175,1176,-1,1177,1178,1179,-1,1148,1147,281,-1,1180,1181,1182,-1,1183,1184,1185,-1,1186,1096,1095,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_3()
		{
			int[] value = {1187,1188,1189,-1,1187,1190,813,-1,1191,814,813,-1,1192,443,966,-1,1193,1194,1195,-1,1196,1197,1198,-1,1199,1200,1201,-1,1202,1203,1204,-1,1205,1206,1207,-1,1208,1209,1210,-1,1211,1082,1003,-1,1212,1213,1214,-1,1215,1216,1217,-1,283,1218,1184,-1,1219,1220,1221,-1,1222,1223,1177,-1,1224,1225,1206,-1,1194,1226,1227,-1,1195,1228,1199,-1,1069,1071,1229,-1,1230,1231,1232,-1,1233,1234,1235,-1,1236,1066,1204,-1,1228,1237,1238,-1,1239,1240,1241,-1,1242,1243,1244,-1,1245,1246,1247,-1,1235,1234,1248,-1,1249,1250,1245,-1,1251,1252,1247,-1,1251,1253,1252,-1,1254,1255,1146,-1,1256,1257,1258,-1,1259,1258,1257,-1,1260,1261,1262,-1,1263,1264,790,-1,1265,1266,1040,-1,1267,1179,1178,-1,1268,1269,1270,-1,1271,1272,1002,-1,1273,1274,1005,-1,1275,1276,1277,-1,289,1278,1279,-1,1280,1021,1281,-1,1282,1011,1283,-1,1014,1011,1282,-1,1284,1285,1122,-1,1286,1287,1157,-1,1152,1288,1114,-1,1113,1289,1290,-1,1151,1158,1149,-1,1291,1292,1293,-1,1294,1295,1296,-1,1297,1298,1299,-1,1300,1301,1302,-1,1303,1129,543,-1,1304,1305,1306,-1,1307,1308,1309,-1,1310,1311,1294,-1,1312,1127,1313,-1,1310,1314,1315,-1,1316,1317,1318,-1,1319,1320,1321,-1,1322,1321,1323,-1,1324,1325,1326,-1,1327,1328,1329,-1,1330,1331,540,-1,1332,1333,1334,-1,1306,1335,538,-1,1325,971,1336,-1,1337,1338,1339,-1,1340,1341,1342,-1,1343,1344,1345,-1,1346,1347,1348,-1,1349,1350,1351,-1,1352,1353,1354,-1,1355,1356,1357,-1,1358,1359,1360,-1,1361,1362,1363,-1,1364,1365,1366,-1,1367,1352,1368,-1,1343,1369,1368,-1,1370,1371,1372,-1,1373,1341,1371,-1,1374,1375,1376,-1,1377,1378,1379,-1,970,1336,971,-1,534,1380,1362,-1,1381,1360,1359,-1,1382,1201,1383,-1,1202,1384,1231,-1,1317,1385,1309,-1,1386,448,1387,-1,1388,1389,1390,-1,1391,1392,1388,-1,1393,1394,1395,-1,1018,1396,1397,-1,1377,1398,1399,-1,1351,1400,1401,-1,1402,1403,1404,-1,1288,1152,1154,-1,1117,1405,1406,-1,1407,1134,1408,-1,1134,1409,1410,-1,1138,1140,1411,-1,1412,1143,1138,-1,1018,1413,1396,-1,1414,1116,1413,-1,1415,1190,1187,-1,1416,1417,1418,-1,1289,1419,1420,-1,1049,1421,1422,-1,1205,1194,1206,-1,1183,1423,1184,-1,1182,1181,1424,-1,1222,1425,1426,-1,1427,1428,1429,-1,1430,1431,1432,-1,1433,1434,1234,-1,1435,964,1436,-1,1437,1438,1439,-1,1166,1440,1102,-1,1441,1442,792,-1,1032,1029,1164,-1,1098,1443,1444,-1,1445,1443,1446,-1,1254,1447,974,-1,974,1447,1448,-1,1449,1450,1451,-1,1452,1453,1454,-1,1455,1456,1457,-1,1458,1459,1460,-1,1461,1462,1463,-1,1449,1464,1465,-1,1466,1467,1468,-1,1469,1470,1471,-1,1465,1464,1472,-1,1473,1474,1475,-1,1476,1473,1472,-1,1477,1478,1479,-1,1479,1480,1477,-1,1481,1482,1483,-1,1484,1481,1485,-1,1486,1487,1488,-1,1474,1489,1475,-1,1490,1491,1492,-1,1460,1493,1456,-1,1494,1495,1496,-1,1491,1497,1492,-1,1498,1499,1494,-1,1499,1495,1494,-1,1500,1501,1502,-1,1503,1504,1505,-1,1506,1507,1501,-1,1505,1506,1508,-1,1508,1509,1510,-1,1511,1512,1513,-1,1514,1515,1516,-1,1517,1518,1519,-1,1520,1521,1522,-1,1523,1524,1525,-1,1526,1527,1528,-1,1529,1530,1531,-1,1532,1533,1534,-1,1535,1536,1537,-1,1538,1539,1540,-1,1541,1542,1537,-1,1537,1538,1543,-1,1531,1544,1545,-1,1546,1526,1528,-1,1534,1547,1540,-1,1528,1548,1546,-1,1549,1550,1551,-1,1552,1528,1527,-1,1537,1536,1553,-1,1554,1555,1556,-1,926,1557,944,-1,1558,1559,926,-1,1560,534,1545,-1,1540,1561,1538,-1,1545,534,530,-1,530,1562,1545,-1,1547,514,1540,-1,901,1558,904,-1,1563,944,1564,-1,1565,1566,936,-1,1567,1568,1569,-1,1570,1571,1572,-1,1532,1573,1533,-1,1530,1529,1574,-1,1575,1576,1577,-1,1549,1569,1578,-1,1532,1579,1573,-1,1539,1580,1540,-1,1581,1582,1545,-1,1526,1583,1582,-1,1537,1584,1535,-1,1585,1586,1587,-1,1588,1547,1534,-1,1589,1590,1579,-1,1582,1527,1526,-1,1544,1591,1581,-1,1525,1524,1592,-1,1593,1594,1595,-1,1596,1597,1598,-1,1599,1519,1600,-1,1601,1602,1603,-1,495,1604,1512,-1,1601,1605,1602,-1,1506,1501,1509,-1,1507,1606,1607,-1,1504,1608,1609,-1,1610,1611,1609,-1,1612,1515,1456,-1,1492,1497,1612,-1,1613,1614,1615,-1,1615,1491,1613,-1,1494,1496,1454,-1,1616,1457,1498,-1,1459,1492,1493,-1,1617,1491,1490,-1,1485,1618,1619,-1,1481,1620,1621,-1,1622,1623,1477,-1,1624,1625,1473,-1,1465,1472,1475,-1,1462,1471,1626,-1,1449,1627,1628,-1,1629,1630,1464,-1,1450,1449,1631,-1,1460,1456,1632,-1,1453,1633,1454,-1,1450,1452,1634,-1,1464,1635,1617,-1,974,491,1636,-1,1637,1258,1259,-1,1445,1446,1259,-1,1443,1445,792,-1,1164,1638,1032,-1,1035,1639,1165,-1,1441,1440,1640,-1,1641,793,792,-1,1642,1437,1643,-1,1263,1644,1433,-1,1645,1433,792,-1,1044,1263,978,-1,1046,1430,1432,-1,1646,1427,1429,-1,1161,443,1647,-1,1178,1648,1267,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_4()
		{
			int[] value = {1081,1083,1086,-1,1009,1144,1649,-1,1650,1235,1246,-1,1228,1227,1237,-1,1150,1416,1186,-1,967,1415,1017,-1,967,1017,1651,-1,1053,1412,1652,-1,1138,1653,1139,-1,1654,1655,1656,-1,1655,1657,1658,-1,1659,1406,1653,-1,1399,1660,1661,-1,1402,1010,1403,-1,1662,1353,1352,-1,1115,1399,1398,-1,1663,1281,1016,-1,1664,1665,1666,-1,1282,1667,1668,-1,1669,1651,1022,-1,1392,1386,1670,-1,1049,1051,1671,-1,1672,971,1673,-1,1674,1363,1675,-1,1651,1017,1676,-1,1364,1677,1365,-1,1352,1678,1679,-1,1340,1680,1681,-1,1340,1372,1371,-1,1367,1368,1369,-1,1375,1369,1682,-1,1376,1677,1119,-1,1348,1366,1365,-1,1683,1362,1381,-1,1684,1685,1561,-1,1367,1010,1662,-1,1349,1354,1350,-1,1686,1346,1687,-1,1688,1689,1690,-1,1691,1338,1344,-1,1340,1342,1680,-1,1692,1693,1373,-1,973,972,1694,-1,1338,1337,1695,-1,1357,971,1325,-1,1696,1697,1321,-1,1327,1326,1325,-1,1321,1697,1323,-1,1322,1291,1698,-1,1318,1317,1699,-1,1127,1156,1700,-1,1308,1699,1309,-1,1309,1385,1701,-1,1305,1702,1697,-1,1301,1300,1292,-1,1301,1703,1704,-1,1705,1704,1286,-1,1697,1706,1707,-1,1292,1291,1323,-1,1708,1709,1703,-1,1708,1703,1710,-1,1285,1711,1154,-1,1419,1149,1420,-1,1712,1713,1714,-1,1021,1715,1022,-1,1716,1717,1718,-1,1719,264,266,-1,1720,1400,1721,-1,1024,964,966,-1,1722,1723,1724,-1,1725,1726,1727,-1,1728,1726,1725,-1,1729,1179,1267,-1,1730,978,1433,-1,1642,1731,1732,-1,999,1732,1733,-1,1264,1263,1044,-1,1441,1260,1440,-1,1639,1035,1734,-1,1041,1266,1038,-1,1412,1138,1735,-1,1433,1645,1434,-1,1736,1256,1254,-1,1257,1736,1737,-1,1738,1146,1739,-1,1740,1245,1250,-1,1253,1741,1252,-1,1242,1181,1243,-1,1742,1743,1744,-1,1238,1237,1745,-1,1746,1747,1231,-1,1748,1198,1744,-1,1236,1204,1198,-1,1200,1383,1201,-1,1200,1749,1383,-1,1750,1751,1752,-1,1753,1754,1755,-1,1086,1756,1084,-1,1757,1758,1759,-1,1760,1278,1761,-1,1762,1082,1211,-1,1197,1241,1198,-1,1197,1763,1239,-1,1219,1764,1765,-1,1206,1194,1193,-1,965,1766,1767,-1,1093,1092,1768,-1,1769,1427,1646,-1,1770,1771,1085,-1,448,1386,1174,-1,1772,1031,1773,-1,444,1026,1774,-1,1775,1140,1776,-1,1056,1655,1777,-1,1640,1440,1166,-1,1166,742,1640,-1,1168,780,1778,-1,1440,1100,1102,-1,1099,1779,1164,-1,1780,1781,780,-1,1782,443,1161,-1,964,1783,965,-1,1124,1122,1784,-1,997,1318,1785,-1,1154,1153,1786,-1,1787,1788,1789,-1,1790,1791,1792,-1,1210,1147,1078,-1,1793,1741,1739,-1,1144,1146,1255,-1,1794,1795,1636,-1,1278,1796,1797,-1,1052,1141,1143,-1,1054,1798,1055,-1,1194,1205,1226,-1,1799,1800,1801,-1,1802,1799,1803,-1,1804,1805,1806,-1,1046,1807,1047,-1,1808,1809,1810,-1,1811,1139,1653,-1,1137,1135,1410,-1,1134,1809,1656,-1,1812,1813,1130,-1,997,1814,1812,-1,1815,1646,997,-1,1129,1303,1126,-1,1816,542,1301,-1,543,542,1816,-1,1122,1121,1284,-1,1817,1115,1818,-1,1417,1150,1819,-1,1109,1110,1118,-1,1419,1113,1820,-1,1121,1821,1822,-1,1418,1417,1823,-1,1824,1638,1167,-1,1105,1825,1103,-1,1164,1779,1638,-1,1189,1826,1769,-1,1151,1150,1186,-1,1827,1828,1829,-1,1097,492,1448,-1,1830,1831,1005,-1,1832,1086,1085,-1,1210,1833,1208,-1,1007,1834,1835,-1,1183,1836,1837,-1,1838,1839,1840,-1,1202,1841,1842,-1,1843,1751,1746,-1,1193,1382,1224,-1,1207,1844,1845,-1,1846,995,1847,-1,1847,1140,1846,-1,1653,1138,1143,-1,1848,989,988,-1,1227,985,987,-1,1799,1801,1803,-1,1807,1805,1849,-1,1046,1805,1807,-1,1802,1849,1804,-1,1850,1428,1437,-1,790,1041,1038,-1,1040,1731,1439,-1,1438,1851,1265,-1,1435,1436,1852,-1,443,1782,1159,-1,1853,1028,1854,-1,1772,1773,1855,-1,1856,1857,1858,-1,1859,1217,1216,-1,1860,1209,1208,-1,1770,1861,1862,-1,1179,1729,1863,-1,1395,1713,1712,-1,1663,1389,1669,-1,1391,1668,1395,-1,1015,1663,1016,-1,1864,1865,1866,-1,1395,1712,1867,-1,1435,1868,1783,-1,1868,1869,1783,-1,1380,1583,1360,-1,1081,1870,1004,-1,1773,1854,1871,-1,1310,1777,1654,-1,1226,1872,985,-1,1051,1050,1873,-1,1874,1875,1876,-1,975,1877,1730,-1,1805,1878,1806,-1,1879,1043,977,-1,970,1880,1881,-1,534,1560,1380,-1,1882,1433,1644,-1,1883,927,961,-1,1884,932,954,-1,1885,1883,960,-1,1886,1884,953,-1,1887,1888,952,-1,1887,952,1889,-1,901,1890,1891,-1,901,1892,1890,-1,1893,1894,901,-1,1895,1896,1897,-1,1898,1565,1899,-1,932,931,921,-1,959,923,955,-1,923,1900,955,-1,910,1901,1902,-1,1903,1904,918,-1,935,934,1905,-1,910,912,1906,-1,941,920,919,-1,919,1907,941,-1,1908,917,916,-1,1909,1910,934,-1,1911,1912,1913,-1,1914,907,906,-1,1915,1912,797,-1,879,878,884,-1,1916,1917,1918,-1,1919,1920,902,-1,899,898,1921,-1,893,1922,1923,-1,1578,889,896,-1,1924,1925,1926,-1,1927,1926,1925,-1,1928,1590,1929,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_5()
		{
			int[] value = {1930,1931,1932,-1,1933,1934,1935,-1,1935,883,1936,-1,1937,1938,1916,-1,1917,1939,878,-1,884,883,880,-1,884,1940,1941,-1,1942,1943,1944,-1,875,1945,876,-1,1946,1947,1948,-1,1949,1950,1951,-1,1952,871,1947,-1,842,1953,1954,-1,1955,1956,1957,-1,1958,863,862,-1,864,1959,863,-1,1960,1961,1962,-1,1963,841,1964,-1,860,859,858,-1,829,856,855,-1,853,847,838,-1,1965,833,852,-1,835,830,850,-1,840,839,832,-1,1966,848,1967,-1,843,845,853,-1,854,838,837,-1,1968,834,833,-1,832,1969,849,-1,1967,1970,1971,-1,1972,1973,1974,-1,821,824,806,-1,1975,1976,809,-1,806,808,1977,-1,803,805,1978,-1,1979,801,800,-1,1980,802,1981,-1,797,796,798,-1,1982,1983,795,-1,1441,1984,1261,-1,1882,1644,963,-1,1168,784,1106,-1,753,756,1985,-1,756,753,752,-1,751,1986,1987,-1,772,1988,1989,-1,752,773,754,-1,767,773,774,-1,771,770,1990,-1,768,767,1991,-1,753,1992,759,-1,1993,1994,1995,-1,747,707,706,-1,750,745,746,-1,746,700,698,-1,1996,1997,1998,-1,1999,744,697,-1,741,2000,1640,-1,2001,699,2002,-1,2003,2004,2005,-1,2006,724,2007,-1,2008,730,709,-1,728,2009,729,-1,726,716,2010,-1,2011,2007,723,-1,731,2008,2012,-1,719,2013,714,-1,2014,2015,2016,-1,2016,2017,2014,-1,2018,2019,2020,-1,2021,708,2022,-1,2023,2024,2025,-1,2026,2027,706,-1,2028,707,2029,-1,2030,745,721,-1,737,2031,1998,-1,692,2032,2033,-1,2034,2035,2036,-1,686,2037,2032,-1,689,684,694,-1,684,689,682,-1,677,682,628,-1,2038,2039,2040,-1,675,2041,679,-1,634,2042,638,-1,634,638,637,-1,663,671,668,-1,664,2043,657,-1,654,665,2044,-1,659,658,2045,-1,646,650,649,-1,2046,2047,655,-1,2048,642,2046,-1,2049,2050,2051,-1,2052,2053,641,-1,695,2049,2054,-1,635,616,2055,-1,636,688,695,-1,636,2056,639,-1,619,618,2057,-1,619,630,629,-1,2058,632,627,-1,626,615,2059,-1,2060,2059,615,-1,677,628,632,-1,2061,618,623,-1,630,2057,2062,-1,2063,2064,2065,-1,2066,613,612,-1,2067,2068,2069,-1,610,2070,2071,-1,344,496,609,-1,605,2072,608,-1,603,602,595,-1,2073,2074,2075,-1,2076,612,599,-1,2077,600,597,-1,2078,2070,610,-1,2079,2080,585,-1,585,2081,2079,-1,2080,2082,2083,-1,583,2084,578,-1,2085,2083,2082,-1,2086,2087,2088,-1,2084,2089,579,-1,2087,2090,2091,-1,336,333,575,-1,2092,576,2093,-1,333,332,2094,-1,2095,568,567,-1,545,547,556,-1,2096,341,560,-1,2097,2098,562,-1,559,558,2099,-1,341,2100,589,-1,555,2101,2102,-1,2087,582,577,-1,2103,551,553,-1,552,2104,545,-1,2105,572,571,-1,543,1129,520,-1,1325,1336,1328,-1,539,525,1334,-1,537,522,2106,-1,530,529,2107,-1,526,525,2108,-1,531,544,2109,-1,521,520,522,-1,2110,2111,529,-1,523,2112,532,-1,1772,512,488,-1,1831,489,488,-1,507,487,508,-1,2113,2114,2115,-1,2115,504,1625,-1,2114,480,479,-1,2116,498,497,-1,2117,501,500,-1,496,498,610,-1,2118,2119,1483,-1,1097,1164,490,-1,489,492,490,-1,486,2120,487,-1,2121,485,484,-1,477,480,482,-1,472,466,465,-1,471,2122,2123,-1,2124,2125,2126,-1,2122,2127,2128,-1,2128,2127,462,-1,464,452,2129,-1,2130,2131,2132,-1,455,457,2133,-1,462,461,2134,-1,460,459,2135,-1,2136,2137,2138,-1,2139,2140,458,-1,2141,2142,2143,-1,461,457,2144,-1,463,2137,2145,-1,2146,2147,2145,-1,449,2148,2149,-1,439,1174,1176,-1,448,449,1387,-1,393,1797,2150,-1,2151,2152,2153,-1,968,2149,2151,-1,96,98,2154,-1,438,97,439,-1,2155,440,447,-1,2156,86,426,-1,437,435,2157,-1,2157,427,429,-1,1026,444,2158,-1,2159,416,2160,-1,432,2161,425,-1,434,2162,2163,-1,431,425,2164,-1,2165,2166,2161,-1,2167,417,2168,-1,2169,2170,411,-1,2171,2172,400,-1,2172,2173,2174,-1,2172,2174,400,-1,2175,2176,2177,-1,2178,2179,2180,-1,2180,395,2178,-1,396,2173,2172,-1,499,497,2072,-1,2181,500,2182,-1,355,354,165,-1,85,165,86,-1,2183,2184,392,-1,2185,2186,2187,-1,386,252,2188,-1,2187,252,387,-1,313,2189,384,-1,2190,2191,2192,-1,2193,2194,381,-1,2191,2195,2196,-1,255,254,2197,-1,2198,2199,2200,-1,2201,2202,2203,-1,380,2204,2205,-1,2206,2207,2208,-1,2209,2210,2211,-1,377,2212,2213,-1,362,2214,2215,-1,374,2216,369,-1,225,2217,2218,-1,2219,2220,2221,-1,2222,138,166,-1,2223,362,364,-1,374,2224,2225,-1,377,2226,2227,-1,2197,2228,2229,-1,2230,2231,2232,-1,2233,2234,2193,-1,165,163,353,-1,347,2065,2235,-1,2236,2063,347,-1,352,310,312,-1,2237,2189,343,-1,313,2234,312,-1,349,2237,2238,-1,345,2239,2240,-1,2069,351,2240,-1,2241,310,352,-1,2242,2243,2244,-1,335,334,322,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_6()
		{
			int[] value = {330,2245,321,-1,2246,2100,341,-1,2247,2248,328,-1,2246,339,338,-1,308,2249,315,-1,2250,310,2251,-1,2252,2189,2249,-1,2253,2254,259,-1,115,114,1176,-1,2255,2256,2257,-1,16,120,14,-1,2258,2259,2260,-1,212,291,2261,-1,114,116,294,-1,2262,2259,2258,-1,275,277,11,-1,276,11,277,-1,1142,2263,1143,-1,2258,1143,2263,-1,1664,2264,2265,-1,295,262,264,-1,292,2266,262,-1,1,2267,4,-1,259,2268,2269,-1,2270,2269,2268,-1,383,253,252,-1,247,246,129,-1,151,2271,2272,-1,194,245,353,-1,194,353,162,-1,228,126,2273,-1,215,238,219,-1,282,2274,283,-1,169,2275,170,-1,135,206,2276,-1,2277,2278,2279,-1,2280,209,200,-1,211,210,231,-1,2281,2282,231,-1,211,2283,123,-1,2284,258,2285,-1,139,368,2286,-1,2287,2288,2289,-1,135,221,207,-1,2290,2278,2277,-1,2276,204,133,-1,205,130,2291,-1,200,2292,201,-1,2293,2294,368,-1,2295,171,2296,-1,2297,186,185,-1,187,183,182,-1,2298,177,2299,-1,178,2300,179,-1,176,2301,2302,-1,179,2300,2293,-1,167,166,2303,-1,2304,146,2305,-1,2304,2305,169,-1,2306,168,162,-1,2293,368,2307,-1,2302,2308,2309,-1,2310,2311,2303,-1,141,174,173,-1,161,164,2312,-1,2312,164,2302,-1,2308,2313,2314,-1,160,132,131,-1,2315,2316,243,-1,2304,155,157,-1,167,151,2272,-1,147,2304,2296,-1,133,204,2317,-1,368,367,2307,-1,282,2318,246,-1,271,125,124,-1,2319,95,2320,-1,271,232,2273,-1,2313,2299,2314,-1,2321,123,125,-1,2155,92,85,-1,180,119,109,-1,2322,112,111,-1,2323,2324,107,-1,181,180,2325,-1,2325,180,122,-1,2326,2327,2328,-1,2325,100,181,-1,89,2329,2308,-1,91,2330,88,-1,89,2308,90,-1,88,2331,89,-1,68,37,40,-1,2332,2333,2334,-1,2335,81,83,-1,29,31,2336,-1,2337,2338,2339,-1,62,2340,2341,-1,2342,20,19,-1,2343,38,80,-1,2344,2345,2346,-1,44,84,41,-1,2347,2348,2337,-1,276,2257,2349,-1,2335,2350,2344,-1,2351,2257,2256,-1,2352,2353,2354,-1,2350,2335,78,-1,42,2355,2356,-1,36,38,2340,-1,17,73,75,-1,2357,2358,2340,-1,2340,2358,2359,-1,64,70,2355,-1,2360,2361,58,-1,51,2362,50,-1,29,2336,49,-1,2363,50,49,-1,27,2364,34,-1,2349,2257,2351,-1,2365,2366,2334,-1,2367,2368,2332,-1,2356,70,69,-1,2369,2338,2337,-1,82,2370,2352,-1,74,25,75,-1,22,60,23,-1,51,20,2342,-1,2371,17,16,-1,14,72,2372,-1,45,2373,2374,-1,2343,2340,38,-1,5,4,6,-1,2,1,2375,-1,2270,2266,1,-1,259,2254,2268,-1,2270,1,2376,-1,2377,1,0,-1,2378,4,3,-1,7,6,4,-1,45,2374,46,-1,2379,10,9,-1,2380,13,115,-1,14,2371,16,-1,11,276,2381,-1,2342,2382,51,-1,60,59,23,-1,25,74,2359,-1,31,30,2336,-1,68,71,80,-1,2356,2355,70,-1,84,46,67,-1,2383,2365,2334,-1,2349,2351,2384,-1,18,2363,2256,-1,27,29,2364,-1,2360,58,2385,-1,79,78,2386,-1,2355,2387,64,-1,2340,2343,2357,-1,73,76,75,-1,2340,62,36,-1,65,64,2387,-1,42,2388,2355,-1,2389,2332,2390,-1,2335,2386,78,-1,2354,83,2352,-1,2336,2351,2256,-1,2335,2344,81,-1,2349,2381,276,-1,2347,2337,2370,-1,2350,2390,2344,-1,43,44,41,-1,2344,2346,81,-1,2372,72,2371,-1,80,2391,2343,-1,19,21,2342,-1,2340,74,2341,-1,25,15,75,-1,29,28,31,-1,2334,2367,2332,-1,68,40,2392,-1,88,90,2393,-1,2393,2302,164,-1,2330,2331,88,-1,89,113,2329,-1,104,103,2327,-1,105,2394,106,-1,2325,122,121,-1,102,2395,103,-1,2299,2313,2298,-1,2324,105,107,-1,2396,280,2397,-1,2397,2325,121,-1,2155,97,436,-1,85,440,2155,-1,124,123,2283,-1,2273,94,271,-1,95,126,2320,-1,232,271,124,-1,217,2398,2399,-1,2317,2400,133,-1,130,2401,2291,-1,146,148,193,-1,147,146,2304,-1,157,2296,2304,-1,2315,243,2402,-1,160,159,132,-1,2308,2329,2313,-1,161,163,164,-1,2403,141,173,-1,137,2310,2303,-1,2302,2309,176,-1,2307,2404,2293,-1,173,146,154,-1,169,155,2304,-1,146,174,2305,-1,2303,149,167,-1,2405,2309,2314,-1,2293,2404,179,-1,178,2406,2300,-1,383,2407,2408,-1,182,2409,187,-1,185,2410,2297,-1,2296,157,2295,-1,2294,134,368,-1,2411,199,198,-1,2291,2292,200,-1,199,203,197,-1,205,211,123,-1,2277,229,2290,-1,206,135,207,-1,2289,208,2287,-1,2294,2293,2300,-1,217,287,2398,-1,2284,246,258,-1,2412,257,2221,-1,231,210,2281,-1,211,231,2283,-1,123,2321,184,-1,209,2291,200,-1,2278,202,2279,-1,2276,133,135,-1,2413,134,133,-1,2221,257,248,-1,215,2414,238,-1,246,2284,282,-1,228,2273,2282,-1,349,2189,2237,-1,162,2189,348,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_7()
		{
			int[] value = {151,2415,2271,-1,191,249,192,-1,2217,255,2191,-1,2416,381,2194,-1,2253,2264,263,-1,4,2267,7,-1,2380,1394,1393,-1,1664,265,2264,-1,2417,2418,93,-1,2419,2294,2300,-1,10,275,11,-1,2262,278,2259,-1,2258,2255,2262,-1,130,132,240,-1,116,110,294,-1,2260,1143,2258,-1,120,12,14,-1,2257,2262,2255,-1,1391,115,1392,-1,2376,2269,2270,-1,2420,310,2250,-1,313,315,2249,-1,312,314,313,-1,304,308,315,-1,2246,338,2421,-1,2247,328,2422,-1,341,339,2246,-1,2096,329,340,-1,2096,342,329,-1,330,331,2245,-1,322,2423,335,-1,2243,325,2244,-1,352,592,2241,-1,2239,2069,2240,-1,2424,349,2238,-1,2236,2425,2424,-1,2189,349,348,-1,2240,351,195,-1,312,195,352,-1,347,2235,2067,-1,195,2233,196,-1,2193,381,366,-1,2426,2427,361,-1,2428,2429,359,-1,375,377,2227,-1,372,374,2225,-1,364,2430,2223,-1,2218,250,225,-1,222,2431,227,-1,374,2432,2216,-1,362,2215,363,-1,377,2213,2223,-1,2433,2434,375,-1,2434,376,375,-1,2209,2435,2210,-1,2207,2436,2208,-1,380,379,2204,-1,2202,378,2203,-1,2198,2437,2199,-1,381,2416,2438,-1,2191,2196,2192,-1,313,2249,2189,-1,386,2188,2439,-1,2187,387,2185,-1,392,2426,2183,-1,164,163,165,-1,354,86,165,-1,2182,2440,2181,-1,2072,2441,499,-1,2172,397,396,-1,2177,2442,2175,-1,2174,2443,400,-1,400,399,2171,-1,2169,2444,2170,-1,417,416,2168,-1,2164,2445,431,-1,434,2446,2162,-1,2157,2447,2448,-1,2159,2160,2445,-1,2446,2156,2449,-1,2157,2448,427,-1,435,2447,2157,-1,433,448,440,-1,447,97,2155,-1,97,447,439,-1,968,2151,2450,-1,2451,2151,2153,-1,2150,394,393,-1,1176,114,439,-1,438,98,97,-1,2146,2145,2137,-1,2145,450,463,-1,2144,2139,461,-1,2143,2131,2141,-1,458,461,2139,-1,2137,463,2138,-1,459,2146,2135,-1,461,458,2134,-1,2133,2452,455,-1,2131,2143,2132,-1,452,454,2129,-1,2128,462,2134,-1,2122,465,2127,-1,2123,2453,471,-1,472,2454,466,-1,477,2455,480,-1,484,2456,2121,-1,2120,2457,487,-1,490,492,1097,-1,490,1164,1029,-1,2118,1483,1482,-1,500,2181,2117,-1,497,499,2116,-1,479,502,2114,-1,1625,1624,2115,-1,2115,1622,2113,-1,487,2457,508,-1,488,1029,1772,-1,523,532,521,-1,2110,2458,2111,-1,2459,1562,515,-1,519,544,520,-1,2109,2110,531,-1,526,2108,527,-1,2107,1562,530,-1,525,541,2108,-1,1332,536,538,-1,543,520,544,-1,2460,1358,1546,-1,573,577,581,-1,2105,2090,572,-1,545,550,552,-1,2103,553,2461,-1,2087,2086,582,-1,555,2102,2462,-1,341,589,560,-1,559,2099,2463,-1,2097,562,561,-1,546,545,2104,-1,560,565,2096,-1,556,548,545,-1,566,2095,567,-1,333,2094,575,-1,2093,2464,2092,-1,336,575,574,-1,2087,2091,2088,-1,579,578,2084,-1,2086,2088,2465,-1,2082,2466,2085,-1,583,578,2467,-1,2080,2083,585,-1,594,596,595,-1,2077,598,600,-1,2073,2075,2468,-1,605,608,606,-1,2469,2470,2078,-1,2470,2471,2078,-1,609,2472,344,-1,344,608,496,-1,2069,2239,2067,-1,612,2076,2066,-1,347,2063,2065,-1,630,2062,2473,-1,2474,619,629,-1,618,620,623,-1,2474,621,620,-1,615,617,2060,-1,626,624,615,-1,2058,2061,632,-1,2057,630,619,-1,636,639,638,-1,616,636,638,-1,695,2475,2049,-1,2476,2052,641,-1,2051,2054,2049,-1,642,2047,2046,-1,2046,655,653,-1,646,649,2477,-1,2045,663,659,-1,2056,654,2044,-1,657,667,664,-1,668,659,663,-1,679,676,675,-1,2038,2478,2039,-1,684,691,694,-1,686,2032,692,-1,2036,2479,2034,-1,692,2033,2052,-1,1998,1997,737,-1,2480,2030,721,-1,2028,2029,2481,-1,2026,706,705,-1,2025,2482,2023,-1,2022,2483,2021,-1,2019,2484,2020,-1,719,718,2013,-1,731,730,2008,-1,2007,724,723,-1,726,714,716,-1,708,2008,709,-1,2006,2007,2021,-1,699,2485,2002,-1,742,741,1640,-1,697,2486,1999,-1,1996,1998,1994,-1,746,743,700,-1,746,744,750,-1,706,2487,747,-1,1993,2488,1994,-1,752,774,773,-1,756,752,754,-1,2489,757,2490,-1,768,1991,2491,-1,771,1990,766,-1,767,774,1991,-1,1989,775,772,-1,751,779,1986,-1,2492,781,780,-1,2493,1640,2000,-1,1441,1261,1260,-1,1882,1641,792,-1,795,2494,1982,-1,797,794,796,-1,1981,2495,1980,-1,1979,800,2496,-1,1978,807,803,-1,1977,810,806,-1,1191,2497,814,-1,809,2498,1975,-1,806,810,821,-1,2499,2500,826,-1,1972,2501,1973,-1,1970,827,1971,-1,1969,2502,849,-1,1965,1968,833,-1,837,2503,854,-1,853,844,843,-1,1967,1971,1966,-1,832,849,840,-1,851,835,850,-1,844,1965,852,-1,838,854,853,-1,2504,829,855,-1,861,860,858,-1,2505,1963,1964,-1,1962,2506,1960,-1,843,862,845,-1,1959,846,863,-1,1953,842,1961,-1,862,2507,1958,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_8()
		{
			int[] value = {2508,2509,2510,-1,1957,2511,1955,-1,1954,866,842,-1,871,1948,1947,-1,1951,2512,1949,-1,1946,1948,2513,-1,1945,2514,876,-1,2515,1942,1944,-1,883,881,880,-1,1939,1936,878,-1,1937,2516,1938,-1,885,1935,1936,-1,1935,885,1933,-1,2517,1930,1932,-1,1928,1929,1927,-1,1925,1928,1927,-1,1924,1926,2518,-1,896,1550,1578,-1,2519,2520,2521,-1,2519,888,2520,-1,1923,2522,893,-1,899,1921,2523,-1,1919,902,903,-1,1917,877,1918,-1,884,1941,879,-1,1912,1911,797,-1,2524,1914,906,-1,2525,1911,1913,-1,2526,913,912,-1,2527,1903,920,-1,1901,910,1906,-1,2528,935,1905,-1,1903,939,1904,-1,1902,1910,910,-1,923,2529,1900,-1,924,949,2530,-1,932,921,959,-1,1899,2531,1898,-1,1895,1897,1898,-1,901,1891,1893,-1,2532,1887,1889,-1,1941,1886,953,-1,1887,1885,1888,-1,958,2533,1900,-1,1884,954,953,-1,960,1888,1885,-1,1884,962,932,-1,961,960,1883,-1,1882,792,1433,-1,972,970,1694,-1,2108,973,1684,-1,1433,2534,1730,-1,1730,2534,975,-1,1874,1876,1043,-1,1800,2535,1848,-1,1205,1845,2536,-1,1845,2537,2536,-1,1138,1411,1735,-1,2538,964,1025,-1,1773,1031,1854,-1,1003,1081,1004,-1,1360,1381,1380,-1,1869,1768,1783,-1,1864,2539,1865,-1,1651,1676,1022,-1,1280,1669,1715,-1,1389,2540,1390,-1,1282,1390,2540,-1,1770,1079,1861,-1,1860,1208,1762,-1,1216,2541,1859,-1,1425,1725,1426,-1,1856,1858,2542,-1,2164,1774,1162,-1,1853,2543,1028,-1,1032,2544,2545,-1,1165,1639,2546,-1,2547,2548,788,-1,1437,1439,1643,-1,1731,1643,1439,-1,1429,1642,998,-1,1879,2549,1874,-1,1432,2550,981,-1,1805,1804,1849,-1,1422,988,990,-1,1800,1848,988,-1,1047,2551,1048,-1,1140,1847,1411,-1,1846,2552,996,-1,1056,2553,2554,-1,1205,1207,1845,-1,2555,2556,2557,-1,1765,2558,2559,-1,1758,1757,2560,-1,1244,2561,2562,-1,1181,2563,2564,-1,1215,1217,1861,-1,1003,1274,1211,-1,1005,1004,1830,-1,1097,1448,1637,-1,2565,2566,2567,-1,813,1093,2568,-1,2568,1188,813,-1,1769,1096,1189,-1,792,1442,1443,-1,1105,1275,1825,-1,1638,1779,1167,-1,1821,1111,1822,-1,1113,1112,1820,-1,1823,1417,1819,-1,1820,1116,1819,-1,1117,1107,1118,-1,1816,2569,543,-1,1126,1125,1129,-1,1812,2570,997,-1,997,2570,1815,-1,1812,1130,2571,-1,1656,1658,1134,-1,2572,1136,1137,-1,1811,1653,2573,-1,2574,1133,2575,-1,1804,1806,2576,-1,1056,1058,2553,-1,1797,1279,1278,-1,2577,297,1659,-1,1424,1252,1182,-1,1255,1649,1144,-1,1145,1793,1146,-1,1784,2578,1789,-1,1789,2578,1787,-1,1786,2579,1154,-1,1785,1814,997,-1,1784,1789,1124,-1,816,1191,967,-1,1168,2492,780,-1,1099,2580,1779,-1,1104,1778,780,-1,1780,780,1166,-1,1056,1657,1655,-1,2581,1140,1775,-1,1868,1435,1852,-1,1161,2582,1782,-1,1774,2164,444,-1,448,1174,446,-1,1215,1078,2583,-1,1770,1862,1771,-1,1094,1769,1646,-1,1092,1783,1768,-1,1219,1765,1063,-1,1763,2584,1239,-1,976,975,2534,-1,1194,1227,1195,-1,1860,1762,1211,-1,1760,1761,2585,-1,1757,1759,2586,-1,1086,1083,1756,-1,2587,1753,1755,-1,1750,1752,2588,-1,1231,1749,1232,-1,1204,2589,1198,-1,1198,1748,1236,-1,1746,1231,1384,-1,1206,1059,1207,-1,2584,1238,2590,-1,1743,1242,1744,-1,1650,1246,1245,-1,1740,2591,1245,-1,1249,1245,1247,-1,2592,1007,1180,-1,1738,2593,1146,-1,1233,1240,1239,-1,1257,1256,1736,-1,1256,1447,1254,-1,1652,1412,1735,-1,1041,1040,1266,-1,1035,1037,1734,-1,1264,1044,1733,-1,1733,1432,999,-1,1733,1732,1731,-1,1642,1643,1731,-1,2594,1000,2595,-1,1725,1425,1728,-1,1727,1857,1725,-1,1722,1724,2596,-1,1831,513,1005,-1,1721,1397,1720,-1,2597,1717,2598,-1,1714,2599,1712,-1,1419,1150,1149,-1,1285,1154,2579,-1,1710,2600,1708,-1,1709,1704,1703,-1,534,1293,535,-1,1705,1301,1704,-1,1301,1292,1703,-1,1302,1301,542,-1,1697,1306,1305,-1,1702,1706,1697,-1,1307,1309,1701,-1,1700,1313,1127,-1,1385,1317,1316,-1,1785,1318,1699,-1,1319,1321,1322,-1,1322,1323,1291,-1,2601,1355,1324,-1,2601,2602,1355,-1,1325,1328,1327,-1,1696,1321,1320,-1,1325,1324,1357,-1,1338,1695,1345,-1,1357,1324,1355,-1,1691,1681,1680,-1,1692,2603,1693,-1,1342,1339,1680,-1,1338,1345,1344,-1,1682,1688,1690,-1,2604,1686,1687,-1,1692,2605,2603,-1,1349,2606,1354,-1,1010,293,1662,-1,1381,2607,1683,-1,1365,1687,1348,-1,1677,1120,1119,-1,1369,2608,1682,-1,1369,1010,1367,-1,1371,1341,1340,-1,1681,1372,1340,-1,1681,1691,1678,-1,1379,1378,1692,-1,1352,2606,1678,-1,1364,1120,1677,-1,1017,1020,1676,-1,971,1357,1673,-1,1143,2260,1653,-1,1246,1235,1248,-1,1386,1392,1175,-1,1388,1670,2609,-1,1022,1715,1669,-1,1282,1668,1390,-1,1664,1666,265,-1,1663,1280,1281,-1,1720,1401,1400,-1,1352,1367,1662,-1,1821,1123,1110,-1,2573,1653,1409,-1,1406,1405,1653,-1,1656,1655,1658,-1,2610,1054,1059,-1,1651,1669,967,-1,1415,1413,1017,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_9()
		{
			int[] value = {1150,1417,1416,-1,1315,1049,1777,-1,1206,1193,1224,-1,1244,2611,1744,-1,1424,1181,1743,-1,1086,1832,1081,-1,1648,2612,1267,-1,964,1435,1783,-1,1646,1429,997,-1,998,997,1429,-1,2549,1879,2613,-1,1874,1043,1879,-1,2534,1433,976,-1,1264,1041,790,-1,1441,1640,1442,-1,1033,1032,2545,-1,1772,1029,1031,-1,1097,1443,1098,-1,1259,1645,1445,-1,1259,1446,1637,-1,1254,974,1255,-1,2614,1522,1521,-1,1464,1449,1635,-1,1634,1451,1450,-1,1453,2615,1633,-1,1632,1458,1460,-1,1631,1449,1628,-1,1463,1462,1630,-1,1449,1465,1627,-1,1462,1626,1630,-1,1627,1465,1466,-1,1471,1470,1626,-1,1475,1466,1465,-1,1624,1473,1476,-1,1477,2616,1622,-1,1481,1621,1618,-1,1485,1481,1618,-1,1617,1613,1491,-1,1493,1460,1459,-1,1633,1494,1454,-1,1492,1612,1493,-1,1498,1457,1499,-1,1610,2617,1611,-1,1609,2618,1504,-1,1507,1607,1502,-1,1505,1504,1506,-1,1504,1507,1506,-1,1508,1506,1509,-1,1601,2619,1605,-1,495,2620,1604,-1,1516,1601,1603,-1,1599,1517,1519,-1,1596,1598,2621,-1,2622,1593,1595,-1,1525,1592,2623,-1,1579,1539,1537,-1,1582,1581,1527,-1,2624,897,2625,-1,2624,1548,1528,-1,1585,1584,1586,-1,1530,1574,1591,-1,1583,1526,1546,-1,1545,1544,1581,-1,1578,1550,1549,-1,1552,2626,1933,-1,1933,887,1552,-1,1934,1933,1581,-1,1573,1579,1590,-1,1570,2627,1571,-1,1567,1569,1549,-1,1577,1556,1575,-1,1565,936,1899,-1,1564,2628,1563,-1,1558,2629,904,-1,2459,514,1545,-1,1540,516,1561,-1,1583,1560,1545,-1,1545,1562,2459,-1,1558,926,1563,-1,944,1563,926,-1,1556,1577,1554,-1,2626,1527,1581,-1,2626,1552,1527,-1,1933,2626,1581,-1,1581,1591,1574,-1,1541,1537,2630,-1,1540,1580,1534,-1,1545,1582,1583,-1,1543,2630,1537,-1,1537,1539,1538,-1,2631,1586,1584,-1,1545,514,1547,-1,2624,2625,1585,-1,1534,1580,1532,-1,1588,1529,1531,-1,1523,2632,1524,-1,1517,2633,1518,-1,1516,1603,1514,-1,1511,495,1512,-1,2634,1508,1510,-1,1508,2635,1505,-1,1507,1502,1501,-1,1503,1608,1504,-1,2636,2617,1610,-1,2636,2623,2617,-1,1502,1607,1500,-1,1499,1457,2632,-1,1493,1612,1456,-1,1491,1615,1497,-1,1495,2637,1496,-1,1490,1492,1459,-1,1474,2638,1489,-1,2639,2640,2641,-1,2639,2642,2640,-1,1488,2643,1486,-1,1484,1482,1481,-1,1483,1620,1481,-1,1476,1472,1464,-1,1473,1475,1472,-1,2644,1469,1471,-1,1627,1466,1468,-1,1630,1626,1464,-1,2645,1461,1463,-1,2646,1629,1464,-1,1458,2647,1459,-1,1455,1632,1456,-1,1452,1454,1634,-1,1449,1451,1635,-1,1636,1255,974,-1,792,1445,1645,-1,1032,1638,1825,-1,1441,792,791,-1,2493,2648,1443,-1,1102,1780,1166,-1,1042,1264,1733,-1,1438,1265,1439,-1,1433,978,1263,-1,1234,976,1433,-1,978,980,1044,-1,983,1432,981,-1,1850,1642,1429,-1,1428,1850,1429,-1,443,1159,966,-1,1274,1003,1005,-1,1245,2591,1650,-1,1198,2589,1196,-1,1183,2649,1423,-1,985,1227,1226,-1,1049,1315,1421,-1,1289,1113,1419,-1,1414,1415,1187,-1,1415,1414,1413,-1,1115,1112,1818,-1,1059,991,993,-1,2572,1405,1123,-1,1135,1134,1410,-1,1809,1134,1133,-1,1288,1154,1711,-1,292,1010,1402,-1,1401,1370,1351,-1,1018,1397,1718,-1,1663,1015,2540,-1,2650,1393,1395,-1,2540,1389,1663,-1,1388,1392,1670,-1,2651,1669,1389,-1,1309,1699,1317,-1,1846,1140,2581,-1,1231,1203,1202,-1,1049,1671,1777,-1,1382,1193,1201,-1,1359,2607,1381,-1,969,1880,970,-1,1380,1381,1362,-1,1377,1379,2652,-1,1374,1376,1119,-1,1373,1371,1379,-1,1370,1401,1371,-1,1343,2608,1369,-1,1352,1679,1368,-1,2653,1364,1366,-1,1675,2654,2655,-1,2656,2657,1683,-1,1360,1546,1358,-1,1354,2606,1352,-1,1370,1349,1351,-1,1687,1346,1348,-1,1345,2658,1343,-1,1339,1338,1691,-1,1691,1680,1339,-1,1379,1692,1373,-1,1336,970,972,-1,1339,2659,1337,-1,1320,2660,1696,-1,538,537,1306,-1,1330,540,539,-1,2661,1327,1329,-1,1326,2601,1324,-1,1318,999,1316,-1,1431,2662,1432,-1,1313,1304,1312,-1,1310,1294,1314,-1,1316,1701,1385,-1,1316,2662,1701,-1,1314,1294,1308,-1,543,2569,1303,-1,1323,1703,1292,-1,1298,2663,1299,-1,1294,1296,1308,-1,531,530,534,-1,1292,1300,1293,-1,1114,1113,1290,-1,1290,1152,1114,-1,1157,1705,1286,-1,1285,2579,1122,-1,1283,1667,1282,-1,1280,1715,1021,-1,1666,266,265,-1,1672,969,971,-1,289,1761,1278,-1,1005,2664,1273,-1,1002,1863,1271,-1,964,2538,2665,-1,1439,1265,1040,-1,1044,1432,1733,-1,790,1644,1263,-1,1731,1042,1733,-1,2666,1234,1434,-1,2666,1248,1234,-1,1258,1447,1256,-1,2593,1254,1146,-1,1251,1247,1246,-1,1424,1247,1252,-1,1743,1181,1242,-1,1244,1744,1242,-1,2611,1748,1744,-1,1228,1238,1199,-1,1072,2611,1244,-1,1236,1748,2611,-1,1235,1240,1233,-1,1230,1203,1231,-1,1197,1239,1241,-1,1199,1238,2667,-1,1227,1799,1237,-1,1223,2668,1177,-1,283,1184,1423,-1,1229,234,2555,-1,1210,1209,1761,-1,1082,1081,1003,-1,1227,1228,1195,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_10()
		{
			int[] value = {1066,1202,1204,-1,1879,1799,1802,-1,1199,1201,1195,-1,1195,1201,1193,-1,2669,1192,966,-1,1190,1191,813,-1,1187,813,1188,-1,1418,1187,1189,-1,1186,1416,1096,-1,1075,1183,1185,-1,1177,1179,1425,-1,1425,1222,1177,-1,1174,1386,1175,-1,1032,1030,1029,-1,2670,1852,2671,-1,1852,1036,2671,-1,1132,1131,1155,-1,1658,1408,1134,-1,1655,1654,1777,-1,1171,1657,1056,-1,1171,2672,1169,-1,1168,1778,1167,-1,780,1781,1104,-1,1034,1030,1032,-1,1777,1310,1315,-1,1155,1700,1156,-1,1152,2600,1153,-1,2583,1078,1148,-1,288,1147,1210,-1,1793,1739,1146,-1,1180,1182,2592,-1,1846,996,995,-1,1777,1671,2673,-1,1049,1422,990,-1,1653,1410,1409,-1,1410,2572,1137,-1,1132,2571,1130,-1,1812,1814,1813,-1,1129,1125,1128,-1,973,2108,541,-1,1720,2652,1401,-1,1123,1821,1121,-1,1120,1109,1108,-1,2674,1406,2675,-1,1112,1116,1820,-1,1661,1285,1284,-1,1818,1112,1114,-1,1821,1110,1111,-1,1118,1107,1109,-1,742,780,740,-1,1167,1778,1824,-1,2676,1781,1101,-1,1032,1825,1275,-1,2677,1260,1262,-1,1096,1769,1094,-1,1301,2678,1791,-1,2679,2680,2681,-1,2682,1005,1087,-1,512,1087,513,-1,1761,1209,2585,-1,1084,1770,1085,-1,1006,1771,2683,-1,1180,2684,2685,-1,2649,2686,1216,-1,1243,2687,2688,-1,1759,2689,2586,-1,1384,2690,2691,-1,2588,1224,1382,-1,1062,1061,1752,-1,1061,1225,1752,-1,1383,1747,1750,-1,1059,993,2692,-1,1054,2693,1798,-1,1801,2694,1803,-1,1799,2535,1800,-1,1432,983,1878,-1,1879,2695,2613,-1,1642,1850,1437,-1,1040,1042,1731,-1,1264,1042,1041,-1,1869,2670,2696,-1,964,2665,1734,-1,1277,2697,1275,-1,966,1160,1024,-1,1161,1163,2582,-1,1028,1774,1026,-1,1076,2698,1077,-1,2650,1395,1867,-1,1669,1280,1663,-1,1676,2699,1022,-1,1397,1396,1720,-1,1017,1413,1018,-1,1013,1283,1011,-1,1583,1546,1360,-1,1182,2700,2592,-1,1000,1002,2595,-1,999,1318,997,-1,994,996,2701,-1,2554,2702,2552,-1,1804,2576,2695,-1,492,974,1448,-1,1684,1561,516,-1,1560,1583,1380,-1,2450,2703,817,-1,790,963,1644,-1,960,962,1884,-1,954,959,955,-1,958,2704,956,-1,953,955,2705,-1,904,1889,952,-1,948,2706,946,-1,943,1564,944,-1,936,1566,937,-1,932,962,930,-1,927,1883,928,-1,1559,924,926,-1,921,923,959,-1,1903,918,920,-1,917,2707,915,-1,914,1906,912,-1,905,1919,903,-1,902,1920,900,-1,897,2708,898,-1,894,896,2709,-1,893,2520,891,-1,885,887,1933,-1,890,889,1578,-1,2710,2711,892,-1,878,1936,883,-1,880,882,905,-1,877,1917,878,-1,876,2712,874,-1,871,1952,872,-1,868,870,2713,-1,843,842,866,-1,2714,2715,2716,-1,843,2507,862,-1,865,1959,864,-1,846,845,862,-1,1961,842,1962,-1,1964,841,861,-1,859,865,857,-1,856,838,847,-1,854,1965,844,-1,833,835,851,-1,830,832,839,-1,849,1967,848,-1,847,853,845,-1,844,852,842,-1,841,1963,839,-1,856,836,838,-1,834,2717,835,-1,831,1969,832,-1,1971,827,829,-1,1973,2501,2718,-1,826,2500,824,-1,821,1976,822,-1,818,820,2719,-1,2720,2721,1972,-1,2721,2501,1972,-1,2722,2669,1767,-1,2723,1783,1092,-1,810,1977,811,-1,807,1978,808,-1,804,2724,805,-1,802,1980,800,-1,799,1915,797,-1,794,2494,795,-1,1262,2725,2677,-1,791,1984,1441,-1,787,783,782,-1,782,1444,2726,-1,2727,776,778,-1,775,754,773,-1,751,2728,774,-1,767,1990,772,-1,771,2729,769,-1,766,1990,767,-1,764,2730,765,-1,761,2731,762,-1,759,1992,757,-1,1985,1992,753,-1,749,744,1999,-1,748,2029,707,-1,745,2030,743,-1,744,746,698,-1,743,748,701,-1,739,2031,737,-1,2002,2485,2732,-1,2732,2733,2002,-1,2734,2735,2736,-1,709,729,2009,-1,736,727,2737,-1,725,735,723,-1,722,717,733,-1,732,719,714,-1,731,733,729,-1,728,732,726,-1,724,2738,725,-1,720,2480,721,-1,717,2739,718,-1,714,2013,715,-1,712,2740,713,-1,710,2022,708,-1,707,2028,705,-1,704,2732,702,-1,701,2485,699,-1,698,2741,696,-1,694,2475,695,-1,687,686,692,-1,684,683,690,-1,689,694,688,-1,685,2742,686,-1,682,681,683,-1,677,622,682,-1,616,625,2055,-1,678,676,679,-1,676,673,674,-1,2474,629,672,-1,668,674,673,-1,665,664,672,-1,671,663,662,-1,669,660,659,-1,657,656,666,-1,654,2043,664,-1,663,2045,661,-1,660,649,658,-1,655,2477,656,-1,653,2043,654,-1,651,658,649,-1,647,648,2743,-1,646,2047,642,-1,643,645,647,-1,640,2476,641,-1,639,2056,2044,-1,688,636,635,-1,689,625,682,-1,634,2744,631,-1,629,631,2744,-1,628,624,626,-1,634,637,2744,-1,620,621,623,-1,619,2474,620,-1,2473,2745,630,-1,2746,2747,627,-1,610,2071,609,-1,608,344,607,-1,604,606,591,-1,2748,601,603,-1,612,611,599,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_11()
		{
			int[] value = {598,2076,599,-1,596,2077,597,-1,590,604,591,-1,589,588,558,-1,586,2081,587,-1,585,2083,583,-1,2467,578,2749,-1,578,2750,2749,-1,582,2751,581,-1,580,2750,578,-1,576,2089,574,-1,573,2752,571,-1,2464,567,570,-1,568,2753,569,-1,565,2095,566,-1,561,550,549,-1,552,550,561,-1,560,589,558,-1,546,2754,557,-1,555,2462,556,-1,551,2104,552,-1,550,545,548,-1,607,2755,2251,-1,542,544,531,-1,2106,522,1128,-1,541,525,539,-1,536,522,537,-1,515,514,2459,-1,2756,2757,2758,-1,2756,2759,2757,-1,532,2760,533,-1,531,2110,529,-1,2761,1562,2107,-1,527,2108,515,-1,524,536,525,-1,519,2109,544,-1,520,1128,522,-1,518,2109,519,-1,1540,514,516,-1,2762,6,8,-1,1831,488,513,-1,1830,489,1831,-1,505,2763,511,-1,510,503,487,-1,509,2763,507,-1,1625,504,506,-1,502,503,510,-1,499,501,2116,-1,493,495,1511,-1,490,1029,488,-1,474,487,503,-1,485,2764,483,-1,481,482,2765,-1,2455,478,480,-1,476,2455,477,-1,474,478,475,-1,469,476,470,-1,471,465,2122,-1,2123,2766,2453,-1,465,467,2127,-1,2767,2128,2134,-1,2134,460,2767,-1,464,2138,463,-1,2143,455,2452,-1,2452,2132,2143,-1,462,2133,457,-1,460,2134,458,-1,456,2144,457,-1,463,450,452,-1,2149,968,449,-1,92,2155,436,-1,294,438,114,-1,440,448,446,-1,2164,428,2159,-1,425,431,432,-1,430,418,2768,-1,2769,2447,435,-1,2164,2159,2445,-1,421,2770,419,-1,418,2160,416,-1,415,432,413,-1,410,2169,411,-1,407,2771,408,-1,404,2772,405,-1,401,2773,402,-1,398,400,2774,-1,2179,2775,442,-1,395,2180,396,-1,2776,1279,1797,-1,2777,2778,2428,-1,2184,391,392,-1,391,388,390,-1,2779,313,385,-1,225,255,2217,-1,382,366,381,-1,2437,2198,2780,-1,2203,378,380,-1,2210,2781,2211,-1,376,2212,377,-1,373,2432,374,-1,369,2216,370,-1,355,165,353,-1,366,382,365,-1,196,2233,244,-1,363,2782,364,-1,2783,2784,2229,-1,2785,392,2232,-1,366,2233,2193,-1,366,244,2233,-1,2234,2233,312,-1,344,2472,343,-1,2425,346,350,-1,2241,592,591,-1,342,330,329,-1,341,2096,340,-1,339,340,337,-1,336,2466,334,-1,331,330,332,-1,326,328,2421,-1,323,325,2422,-1,300,322,2244,-1,319,306,320,-1,304,315,314,-1,343,2786,318,-1,317,344,318,-1,310,2420,311,-1,308,2787,309,-1,306,319,304,-1,303,2788,301,-1,300,316,298,-1,2267,1,2266,-1,263,266,264,-1,1392,115,1175,-1,262,296,293,-1,214,144,143,-1,2255,18,2256,-1,115,1176,1175,-1,286,145,2789,-1,285,158,218,-1,1147,127,2318,-1,280,61,24,-1,275,274,277,-1,258,156,2790,-1,184,2321,272,-1,93,271,94,-1,269,2791,267,-1,265,263,2264,-1,2380,115,1394,-1,2267,1402,7,-1,2269,260,259,-1,259,261,2253,-1,262,2266,2254,-1,246,248,257,-1,257,2412,2295,-1,2792,247,129,-1,2271,2793,2272,-1,2233,195,312,-1,223,191,172,-1,242,2794,243,-1,240,132,159,-1,238,2795,220,-1,233,2796,236,-1,213,212,234,-1,231,124,2283,-1,2291,209,205,-1,228,2290,229,-1,2797,2412,2221,-1,224,2220,222,-1,134,2294,221,-1,220,284,218,-1,2399,215,217,-1,212,214,291,-1,211,205,209,-1,208,2289,206,-1,2400,169,2798,-1,198,2279,2411,-1,130,240,2401,-1,239,2799,2800,-1,204,2276,197,-1,191,148,147,-1,148,191,193,-1,383,192,249,-1,189,118,117,-1,152,2801,188,-1,185,187,2409,-1,182,184,273,-1,103,189,2802,-1,2803,2300,2406,-1,179,2299,177,-1,175,2804,136,-1,257,2295,258,-1,147,2296,171,-1,168,2306,166,-1,2312,2302,2301,-1,2805,2306,2806,-1,2314,2309,2308,-1,158,2807,159,-1,152,154,2407,-1,151,167,149,-1,146,193,2408,-1,2401,2800,2291,-1,139,2286,140,-1,2301,136,138,-1,2222,2805,2312,-1,2301,176,136,-1,94,2273,126,-1,2298,2313,2808,-1,2428,2778,2784,-1,2809,92,436,-1,122,12,120,-1,119,2322,111,-1,12,110,116,-1,279,117,99,-1,2810,112,2323,-1,112,2810,113,-1,2405,2314,2299,-1,2325,101,100,-1,2323,107,2810,-1,105,2811,2394,-1,2329,113,2313,-1,2330,2154,98,-1,95,2417,93,-1,2809,91,92,-1,88,2393,164,-1,2156,2446,86,-1,82,2352,83,-1,74,2340,2359,-1,80,71,70,-1,63,2391,80,-1,2341,74,76,-1,17,2371,72,-1,2812,69,71,-1,68,80,38,-1,30,47,2336,-1,2353,2352,2339,-1,2355,2388,2387,-1,65,2387,41,-1,61,25,24,-1,77,2389,78,-1,60,2385,58,-1,55,57,2813,-1,54,2814,52,-1,50,2363,20,-1,50,2364,29,-1,33,2815,27,-1,48,2816,47,-1,46,84,44,-1,2383,2334,2333,-1,41,2388,42,-1,37,36,39,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_12()
		{
			int[] value = {2388,41,2387,-1,33,35,2817,-1,35,34,2364,-1,32,48,30,-1,47,2351,2336,-1,25,2359,26,-1,21,23,2342,-1,18,20,2363,-1,17,75,15,-1,14,2372,2371,-1,12,115,13,-1,2818,2819,2374,-1,2376,1,2377,-1,6,2762,5,-1,2268,2266,2270,-1,2268,2254,2266,-1,2383,2820,2365,-1,2820,2383,2818,-1,2269,2377,2821,-1,2269,2376,2377,-1,2822,58,2823,-1,2822,59,58,-1,2824,2825,2826,-1,2824,2827,2825,-1,2357,52,2358,-1,2357,53,52,-1,2828,2370,82,-1,2828,2347,2370,-1,2368,2829,2830,-1,2368,2367,2829,-1,2364,2362,2338,-1,2364,50,2362,-1,2354,2822,2386,-1,2354,2831,2822,-1,2832,2361,2360,-1,2832,2833,2361,-1,2834,63,2835,-1,63,2834,2391,-1,2826,2836,2824,-1,2836,2826,66,-1,2332,2837,2333,-1,2837,2332,2389,-1,2386,83,2354,-1,2335,83,2386,-1,2363,2336,2256,-1,2336,2363,49,-1,2386,2823,79,-1,2386,2822,2823,-1,2838,31,28,-1,2838,32,31,-1,2382,23,2831,-1,2342,23,2382,-1,2339,2370,2337,-1,2339,2352,2370,-1,2319,2839,2840,-1,2319,2841,2839,-1,111,89,2331,-1,111,113,89,-1,181,2842,2843,-1,2842,181,100,-1,2808,113,2810,-1,2808,2313,113,-1,99,280,279,-1,99,101,280,-1,91,2154,2330,-1,2154,91,2809,-1,108,178,177,-1,108,106,178,-1,2326,2844,2845,-1,2844,2326,2328,-1,2320,2841,2319,-1,2841,2320,2846,-1,2310,367,2403,-1,2804,367,2310,-1,203,2317,204,-1,203,2847,2317,-1,2292,2848,201,-1,2292,2799,2848,-1,285,243,2794,-1,2402,243,285,-1,2306,2222,166,-1,2805,2222,2306,-1,174,140,2305,-1,141,140,174,-1,166,137,2303,-1,138,137,166,-1,2404,2299,179,-1,2405,2299,2404,-1,2185,2849,2850,-1,2849,2185,2851,-1,2852,2418,2853,-1,2854,2418,2852,-1,2410,1142,2297,-1,2263,1142,2410,-1,2799,2855,2848,-1,239,2855,2799,-1,2275,2847,2856,-1,2275,2317,2847,-1,2277,2287,229,-1,2277,2288,2287,-1,2857,237,236,-1,237,2857,290,-1,2858,2285,2859,-1,2858,2284,2285,-1,207,2860,2791,-1,207,221,2860,-1,2287,269,2861,-1,2287,208,269,-1,2280,202,2278,-1,2280,200,202,-1,2276,2289,197,-1,206,2289,2276,-1,2295,2797,171,-1,2797,2295,2412,-1,2862,1221,2863,-1,2864,1221,2862,-1,1218,2274,2795,-1,1218,283,2274,-1,2865,2398,2866,-1,2865,2864,2398,-1,2274,2284,2858,-1,2274,282,2284,-1,2867,190,2868,-1,189,190,2867,-1,2794,2855,2807,-1,242,2855,2794,-1,194,348,195,-1,194,162,348,-1,2869,2,2375,-1,2870,2,2869,-1,262,2253,263,-1,2253,262,2254,-1,1664,2380,1393,-1,2265,2380,1664,-1,2297,2261,291,-1,1142,2261,2297,-1,142,183,187,-1,183,142,2871,-1,189,2839,2802,-1,189,2867,2839,-1,2790,2285,258,-1,2315,2285,2790,-1,24,117,279,-1,24,2814,117,-1,2852,2872,2854,-1,2813,2872,2852,-1,2360,273,272,-1,2360,2385,273,-1,185,19,2410,-1,185,21,19,-1,2396,61,280,-1,61,2396,15,-1,327,2873,2874,-1,2873,327,326,-1,2875,317,316,-1,2755,317,2875,-1,2876,2250,2251,-1,2250,2876,2874,-1,338,303,302,-1,303,338,337,-1,2248,2421,328,-1,2248,2246,2421,-1,335,2245,331,-1,335,2423,2245,-1,2243,2079,2247,-1,2080,2079,2243,-1,310,607,2251,-1,2241,607,310,-1,2238,343,2472,-1,2238,2237,343,-1,2877,2070,2878,-1,2070,2877,2071,-1,2067,345,347,-1,345,2067,2239,-1,371,2879,2880,-1,371,2881,2879,-1,2882,2225,2883,-1,2882,372,2225,-1,2884,2792,2776,-1,2884,2885,2792,-1,355,245,2884,-1,355,353,245,-1,2415,2886,385,-1,2886,2415,188,-1,2887,2888,2889,-1,2890,2888,2887,-1,2891,2892,2893,-1,2891,2894,2892,-1,2890,2895,2896,-1,2890,2887,2895,-1,2889,2897,2887,-1,2898,2897,2889,-1,2899,2893,2892,-1,2899,2900,2893,-1,2901,2433,2881,-1,2901,2434,2433,-1,2214,2223,2213,-1,2223,2214,362,-1,2435,2902,2210,-1,2435,373,2902,-1,2901,2204,379,-1,2901,370,2204,-1,2212,2437,2213,-1,2437,2212,2199,-1,2436,2209,2208,-1,2436,2435,2209,-1,2200,2202,2201,-1,2200,2199,2202,-1,2781,2903,2211,-1,2903,2781,2062,-1,2205,2904,2905,-1,2205,2206,2904,-1,2906,2201,2907,-1,2906,2200,2201,-1,2880,360,361,-1,360,2880,2879,-1,364,357,359,-1,357,364,2782,-1,2429,364,359,-1,2430,364,2429,-1,2416,2908,2183,-1,2909,2908,2416,-1,2229,2195,2197,-1,2784,2195,2229,-1,2899,2416,2194,-1,2899,2909,2416,-1,2191,2197,2195,-1,255,2197,2191,-1,2900,2194,2193,-1,2900,2899,2194,-1,2192,2910,2190,-1,2192,2911,2910,-1,2190,2912,251,-1,2190,2910,2912,-1,389,2779,385,-1,388,2779,389,-1,386,2185,387,-1,2185,386,2851,-1,358,2913,2186,-1,2230,2913,358,-1,357,2230,358,-1,357,2231,2230,-1,392,2427,2426,-1,2427,392,2785,-1,2914,2915,2916,-1,2914,2917,2915,-1,393,2776,1797,-1,393,2918,2776,-1,497,608,2072,-1,497,496,608,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_13()
		{
			int[] value = {2182,2919,2440,-1,2919,2182,2920,-1,500,2441,2182,-1,500,499,2441,-1,2921,2177,2922,-1,2442,2177,2921,-1,2774,2443,2923,-1,400,2443,2774,-1,2924,2925,2926,-1,2924,2927,2925,-1,2173,2928,2174,-1,1192,2928,2173,-1,2172,2929,397,-1,2171,2929,2172,-1,2930,2931,2921,-1,2932,2931,2930,-1,2931,2773,401,-1,2931,2932,2773,-1,407,2171,2771,-1,2929,2171,407,-1,2933,2934,2444,-1,2933,2935,2934,-1,402,2924,403,-1,402,2927,2924,-1,2936,408,2937,-1,409,408,2936,-1,2170,2938,2939,-1,2170,2940,2938,-1,2153,2923,2451,-1,2153,2176,2923,-1,2451,2443,2151,-1,2923,2443,2451,-1,433,2148,449,-1,437,2148,433,-1,2941,2167,2168,-1,2942,2167,2941,-1,2943,420,2944,-1,2945,420,2943,-1,2167,2946,417,-1,2946,2167,2947,-1,2445,413,431,-1,2445,2160,413,-1,2448,2941,427,-1,2448,2948,2941,-1,2948,2447,423,-1,2448,2447,2948,-1,440,434,433,-1,87,434,440,-1,2949,2947,2147,-1,2949,2946,2947,-1,456,2950,2144,-1,456,2951,2950,-1,2952,453,451,-1,2952,2953,453,-1,458,2949,459,-1,458,2140,2949,-1,2146,2136,2135,-1,2146,2137,2136,-1,454,2130,2129,-1,454,2131,2130,-1,462,467,2133,-1,2127,467,462,-1,2129,2954,2124,-1,2954,2129,2130,-1,2955,2136,468,-1,2955,2135,2136,-1,2956,2957,2958,-1,2956,2959,2957,-1,466,2960,2958,-1,2454,2960,466,-1,475,2125,473,-1,475,2126,2125,-1,2456,472,471,-1,2456,484,472,-1,486,2961,2120,-1,2961,486,2962,-1,2456,2963,2121,-1,2456,2964,2963,-1,2965,2966,2967,-1,2965,2968,2966,-1,2115,502,504,-1,2115,2114,502,-1,1624,1622,2115,-1,1623,1622,1624,-1,2969,2616,2970,-1,2969,2971,2616,-1,2119,2972,2973,-1,2118,2972,2119,-1,508,1488,509,-1,508,2643,1488,-1,494,1603,1602,-1,494,493,1603,-1,2112,524,2974,-1,524,2112,523,-1,2111,2107,529,-1,2111,2975,2107,-1,2976,527,2977,-1,527,2976,526,-1,2978,2979,2980,-1,2981,2979,2978,-1,2982,2974,2983,-1,2112,2974,2982,-1,2984,2111,2985,-1,2975,2111,2984,-1,2986,2987,2988,-1,2986,2989,2987,-1,2757,2990,2991,-1,2759,2990,2757,-1,2992,2993,2994,-1,2993,2992,2995,-1,2996,2997,2998,-1,2999,2997,2996,-1,3000,2758,3001,-1,3000,2756,2758,-1,3002,3003,3004,-1,3002,3005,3003,-1,3006,3007,3008,-1,3009,3007,3006,-1,3010,3011,3012,-1,3010,3013,3011,-1,3014,3015,3016,-1,3014,3017,3015,-1,3018,3019,3020,-1,3021,3019,3018,-1,3022,3023,3024,-1,3025,3023,3022,-1,3026,3027,3028,-1,3026,3029,3027,-1,3030,3031,3032,-1,3033,3031,3030,-1,3034,3035,3036,-1,3034,3037,3035,-1,3038,3039,3040,-1,3039,3038,3041,-1,3042,3043,3044,-1,3042,3045,3043,-1,3046,3047,3048,-1,3046,3049,3047,-1,3050,3051,3052,-1,3051,3050,3053,-1,1329,1336,972,-1,1336,1329,1328,-1,1300,535,1293,-1,1300,1302,535,-1,3054,2105,571,-1,3055,2105,3054,-1,582,3056,3057,-1,2086,3056,582,-1,3058,3059,3060,-1,3058,3061,3059,-1,2102,3062,2091,-1,2101,3062,2102,-1,2463,2098,2097,-1,2463,2099,2098,-1,560,2095,565,-1,560,559,2095,-1,3063,554,557,-1,554,3063,3064,-1,3064,555,554,-1,555,3064,3065,-1,3066,571,2752,-1,3066,3054,571,-1,2093,575,2094,-1,575,2093,576,-1,2101,3067,3062,-1,2101,3068,3067,-1,2084,574,2089,-1,2085,574,2084,-1,2083,2084,583,-1,2083,2085,2084,-1,3057,2751,582,-1,3069,2751,3057,-1,3070,2467,2749,-1,3071,2467,3070,-1,3072,3061,3058,-1,3061,3072,3073,-1,3070,3074,3071,-1,3074,3070,3075,-1,3073,3076,3061,-1,3076,3073,3077,-1,3078,2461,553,-1,3078,3079,2461,-1,2099,3080,2098,-1,2099,3081,3080,-1,3082,2754,3083,-1,2754,3082,3084,-1,2075,3085,3086,-1,2074,3085,2075,-1,2066,3087,3088,-1,3087,2066,3089,-1,3090,2468,3091,-1,3090,2073,2468,-1,2078,498,2469,-1,498,2078,610,-1,3092,2078,2471,-1,2078,3092,2070,-1,3092,2878,2070,-1,3092,3093,2878,-1,2235,2068,2067,-1,2068,2235,3094,-1,3088,3095,3096,-1,3088,3087,3095,-1,3097,3098,3099,-1,3097,3095,3098,-1,3100,3099,3098,-1,3099,3100,3101,-1,3102,3101,3100,-1,3101,3102,3103,-1,3102,2469,3103,-1,3102,2470,2469,-1,2937,3104,2936,-1,3104,2937,3105,-1,2058,2062,2057,-1,2058,2903,2062,-1,2905,626,2059,-1,626,2905,2904,-1,2906,633,631,-1,633,2906,2907,-1,633,2042,634,-1,3106,2042,633,-1,695,2051,636,-1,695,2054,2051,-1,3107,2049,2475,-1,3107,2048,2049,-1,2046,2049,2048,-1,2049,2046,2050,-1,653,2050,2046,-1,2050,653,652,-1,2743,661,2045,-1,2743,648,661,-1,671,3108,3109,-1,671,670,3108,-1,678,3110,3111,-1,3110,678,621,-1,679,685,680,-1,679,2742,685,-1,689,2055,625,-1,2055,689,635,-1,2037,2034,2032,-1,2037,2035,2034,-1,2476,692,2052,-1,693,692,2476,-1,2428,358,2850,-1,2428,359,358,-1,3112,2031,3113,-1,1998,2031,3112,-1,3114,3115,3116,-1,3114,3117,3115,-1,749,2013,718,-1,749,3118,2013,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_14()
		{
			int[] value = {2480,2029,2030,-1,2481,2029,2480,-1,2006,2482,2025,-1,2482,2006,3119,-1,736,2009,728,-1,3120,2009,736,-1,2014,3121,3122,-1,3123,3121,2014,-1,3124,3125,3126,-1,3124,3127,3125,-1,3128,3129,3130,-1,3128,3131,3129,-1,1987,2019,2018,-1,1987,3132,2019,-1,2015,3133,2016,-1,2015,3134,3133,-1,3135,3136,3137,-1,3135,3130,3136,-1,734,2026,705,-1,3138,2026,734,-1,3139,3140,2003,-1,3140,3139,2010,-1,2010,711,3140,-1,2010,716,711,-1,3141,713,3138,-1,3142,713,3141,-1,2007,708,2021,-1,2007,2008,708,-1,2005,3143,2024,-1,2005,2004,3143,-1,736,3144,3127,-1,736,2737,3144,-1,3145,2483,2022,-1,3122,2483,3145,-1,3131,2023,3129,-1,3131,3146,2023,-1,3147,786,3148,-1,3147,3149,786,-1,3150,2734,2736,-1,3150,2733,2734,-1,3151,3152,3153,-1,3151,3154,3152,-1,782,3148,786,-1,782,2726,3148,-1,3155,704,3117,-1,2734,704,3155,-1,3156,696,3154,-1,3156,3157,696,-1,1994,3112,1995,-1,1994,1998,3112,-1,703,747,2487,-1,703,702,747,-1,1993,3158,3159,-1,3158,1993,1995,-1,778,3160,3161,-1,777,3160,778,-1,3162,3163,3164,-1,3163,3162,3165,-1,3166,3167,762,-1,3166,3168,3167,-1,3169,3170,3171,-1,3169,3172,3170,-1,3173,3172,3169,-1,3173,2727,3172,-1,761,2727,3173,-1,761,776,2727,-1,760,776,761,-1,760,3174,776,-1,3175,3174,760,-1,3175,3176,3174,-1,3177,3178,3179,-1,3177,3180,3178,-1,757,3181,758,-1,757,2489,3181,-1,3180,3182,3178,-1,3180,3183,3182,-1,3184,3181,2489,-1,3184,3185,3181,-1,3183,3186,3182,-1,3183,3187,3186,-1,3188,3189,3190,-1,3189,3188,3191,-1,2731,3173,3192,-1,761,3173,2731,-1,3193,3190,3194,-1,3190,3193,3188,-1,3192,3169,3165,-1,3173,3169,3192,-1,3195,3193,3194,-1,3195,3196,3193,-1,2491,3197,3198,-1,2491,3199,3197,-1,2729,2730,764,-1,2729,771,2730,-1,3199,1991,3200,-1,2491,1991,3199,-1,774,3200,1991,-1,774,2728,3200,-1,3172,778,3201,-1,3172,2727,778,-1,3202,3203,1989,-1,3202,3204,3203,-1,3204,3179,3203,-1,3204,3177,3179,-1,740,3205,3206,-1,781,3205,740,-1,1982,3207,1983,-1,1982,3208,3207,-1,3209,1979,2496,-1,3210,1979,3209,-1,3211,2720,3212,-1,2721,2720,3211,-1,3213,819,818,-1,3213,3214,819,-1,1976,810,809,-1,810,1976,821,-1,803,2718,804,-1,803,2499,2718,-1,1975,3215,3216,-1,1975,3217,3215,-1,2503,2499,1968,-1,2718,2499,2503,-1,3216,1970,2502,-1,3216,3215,1970,-1,834,825,2717,-1,826,825,834,-1,2502,1967,849,-1,2502,1970,1967,-1,865,855,1959,-1,855,865,2504,-1,851,2506,1962,-1,850,2506,851,-1,1960,1963,2505,-1,1960,2506,1963,-1,2508,858,2715,-1,2508,861,858,-1,1955,1961,1960,-1,1953,1961,1955,-1,864,1958,3218,-1,864,863,1958,-1,2510,1957,1956,-1,1957,2510,2509,-1,3219,1958,2507,-1,3220,1958,3219,-1,3221,2715,3222,-1,3221,2508,2715,-1,1954,3223,3224,-1,1954,2511,3223,-1,3219,3225,3220,-1,3225,3219,3226,-1,1947,3227,1952,-1,3227,1947,1943,-1,3228,3229,3230,-1,3228,3231,3229,-1,3232,3233,3234,-1,869,3233,3232,-1,3235,3236,3237,-1,3235,3222,3236,-1,3238,3239,3240,-1,3238,3241,3239,-1,3242,3243,3244,-1,3242,3245,3243,-1,3241,3246,3247,-1,3246,3241,3238,-1,3248,3245,3242,-1,3248,3249,3245,-1,3246,3250,3247,-1,3251,3250,3246,-1,3252,3249,3248,-1,3252,3253,3249,-1,3250,3254,3255,-1,3254,3250,3251,-1,3256,3252,3257,-1,3256,3253,3252,-1,3255,3258,3259,-1,3258,3255,3254,-1,3260,3257,3261,-1,3260,3256,3257,-1,3259,3262,3263,-1,3262,3259,3258,-1,3264,3261,3265,-1,3264,3260,3261,-1,3263,3266,3267,-1,3266,3263,3262,-1,1951,3265,3268,-1,1951,3264,3265,-1,3266,2513,3267,-1,3269,2513,3266,-1,2512,3268,3270,-1,2512,1951,3268,-1,3225,1949,2514,-1,3225,3226,1949,-1,1952,3271,872,-1,1952,3227,3271,-1,3272,2514,1945,-1,3272,3225,2514,-1,1944,3273,2515,-1,3273,1944,3274,-1,3275,875,874,-1,3275,3276,875,-1,2515,3240,3239,-1,3240,2515,3273,-1,900,3277,3278,-1,900,3279,3277,-1,1938,1917,1916,-1,1938,1939,1917,-1,886,1936,1939,-1,886,885,1936,-1,882,3280,3281,-1,2517,3280,882,-1,3282,3277,3283,-1,3282,3284,3277,-1,891,3285,3286,-1,891,890,3285,-1,3287,3288,3289,-1,3288,3287,3290,-1,1931,1935,1934,-1,1930,1935,1931,-1,1573,1928,3291,-1,1573,1590,1928,-1,3292,1571,2627,-1,1571,3292,3293,-1,1927,3294,1926,-1,1927,3295,3294,-1,3296,1924,3297,-1,3296,1925,1924,-1,1568,3285,1569,-1,1568,3298,3285,-1,2518,3299,2711,-1,2518,3300,3299,-1,889,2519,3301,-1,889,888,2519,-1,1922,3302,1923,-1,1922,3303,3302,-1,3301,2708,1575,-1,3301,2519,2708,-1,1923,3304,3305,-1,1923,3302,3304,-1,886,1554,887,-1,886,3306,1554,-1,904,880,905,-1,904,951,880,-1,1916,1891,1937,-1,1916,1918,1891,-1,3208,907,3210,-1,3208,909,907,-1,1981,3307,3308,-1,802,3307,1981,-1,3309,797,1911,-1,797,3309,794,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_15()
		{
			int[] value = {3308,3310,3311,-1,3308,3307,3310,-1,1911,3312,3309,-1,3312,1911,2525,-1,935,1908,933,-1,917,1908,935,-1,919,3313,1907,-1,919,3314,3313,-1,3315,915,2707,-1,915,3315,2524,-1,1901,3316,1902,-1,1901,1913,3316,-1,3317,3318,3319,-1,3317,3320,3318,-1,3321,3320,3317,-1,2528,917,935,-1,917,2528,2707,-1,3322,938,937,-1,3322,3323,938,-1,2705,1900,2533,-1,955,1900,2705,-1,3324,3322,1909,-1,3322,3324,3323,-1,925,2530,3325,-1,924,2530,925,-1,1883,2532,928,-1,1883,1887,2532,-1,1883,1885,1887,-1,929,3326,927,-1,929,1896,3326,-1,929,3327,1896,-1,2704,3328,3329,-1,2704,2529,3328,-1,1908,3330,3331,-1,1908,3332,3330,-1,3333,1899,930,-1,3333,2531,1899,-1,1565,1897,943,-1,1898,1897,1565,-1,3334,2526,3335,-1,2526,3334,942,-1,946,3335,947,-1,3335,946,3334,-1,3336,2532,1889,-1,928,2532,3336,-1,3337,3338,3339,-1,3338,3337,3340,-1,1893,953,2705,-1,1891,953,1893,-1,3317,3339,3341,-1,3339,3317,3337,-1,1886,960,1884,-1,1888,960,1886,-1,791,795,1983,-1,793,795,791,-1,788,1980,2495,-1,2548,1980,788,-1,1984,3209,1261,-1,1984,3207,3209,-1,1766,3211,1767,-1,1766,2724,3211,-1,3342,814,2497,-1,3342,811,814,-1,812,808,1091,-1,812,1977,808,-1,3343,1874,2549,-1,1875,1874,3343,-1,3344,1845,1844,-1,2537,1845,3344,-1,1847,1735,1411,-1,1847,3345,1735,-1,3346,2544,2596,-1,3346,2545,2544,-1,1727,2565,3347,-1,1727,2566,2565,-1,1855,3348,1089,-1,1855,3349,3348,-1,1030,1854,1031,-1,1030,1853,1854,-1,2681,1272,1753,-1,2681,2680,1272,-1,1865,1712,2599,-1,1865,1867,1712,-1,2539,3350,3351,-1,3350,2539,1864,-1,1015,1282,2540,-1,1015,1014,1282,-1,1668,1713,1395,-1,1667,1713,1668,-1,2698,1836,1077,-1,2698,3352,1836,-1,2664,3353,1760,-1,3354,3353,2664,-1,3355,3356,3357,-1,1755,3356,3355,-1,1080,1770,1084,-1,1079,1770,1080,-1,1760,1273,2664,-1,1760,2585,1273,-1,2542,3358,3359,-1,3358,2542,1858,-1,1163,3360,2582,-1,1163,3361,3360,-1,1723,1159,1724,-1,1160,1159,1723,-1,1723,2538,1025,-1,1722,2538,1723,-1,1852,1037,1036,-1,1037,1852,1436,-1,2677,3362,2671,-1,2677,2547,3362,-1,1044,2550,1432,-1,2550,1044,1045,-1,979,1876,3363,-1,979,1877,1876,-1,985,1873,986,-1,1051,1873,985,-1,1412,1052,1143,-1,1052,1412,1053,-1,2693,994,1798,-1,3345,994,2693,-1,1746,1750,1747,-1,1746,1751,1750,-1,2562,2586,2689,-1,2586,2562,2561,-1,2564,2698,1076,-1,2564,2563,2698,-1,1860,1274,1273,-1,1274,1860,1211,-1,3358,3348,3364,-1,3358,3365,3348,-1,3366,1213,2150,-1,3366,1214,1213,-1,2668,3367,3368,-1,2668,1223,3367,-1,3369,2612,1212,-1,3369,3370,2612,-1,1791,3371,1792,-1,1791,2678,3371,-1,1099,1444,2580,-1,1099,1098,1444,-1,1404,7,1402,-1,1404,8,7,-1,1121,1661,1284,-1,1121,1822,1661,-1,1419,1819,1150,-1,1820,1819,1419,-1,1115,1660,1399,-1,1660,1115,1817,-1,1398,2652,1720,-1,2652,1398,1377,-1,1808,1656,1809,-1,1654,1656,1808,-1,2662,1421,1701,-1,1421,2662,1431,-1,1432,1805,1046,-1,1805,1432,1878,-1,1802,2694,1849,-1,2694,1802,1803,-1,2551,1800,988,-1,2551,1801,1800,-1,2673,1872,2536,-1,1671,1872,2673,-1,2692,1207,1059,-1,2692,1844,1207,-1,297,3372,1659,-1,297,274,3372,-1,3373,1636,491,-1,1636,3373,1794,-1,1739,1253,3374,-1,1739,1741,1253,-1,1810,3375,3376,-1,2574,3375,1810,-1,1122,1786,1784,-1,1122,2579,1786,-1,1157,1420,1149,-1,1287,1420,1157,-1,3377,2571,3378,-1,2571,3377,1812,-1,3379,1814,1785,-1,1814,3379,1813,-1,1314,1307,1315,-1,1307,1314,1308,-1,1105,1781,2676,-1,1105,1104,1781,-1,3380,3381,1172,-1,3381,3380,3382,-1,3382,3383,1169,-1,3382,3384,3383,-1,1846,1172,1056,-1,3380,1172,1846,-1,1815,1792,3385,-1,1790,1792,1815,-1,1027,1854,1028,-1,1027,1871,1854,-1,1085,1006,1832,-1,1085,1771,1006,-1,1186,3386,1151,-1,1186,1095,3386,-1,2559,1063,1765,-1,1063,2559,1064,-1,1196,1230,3387,-1,2589,1230,1196,-1,977,1234,3388,-1,1234,977,976,-1,212,2610,1060,-1,2261,2610,212,-1,1764,1071,1765,-1,235,1071,1764,-1,1834,1859,2541,-1,1834,2683,1859,-1,3389,3368,3390,-1,3389,3391,3368,-1,1829,2681,1827,-1,1829,2679,2681,-1,1073,2689,1840,-1,2562,2689,1073,-1,2584,2667,1238,-1,2584,1763,2667,-1,1206,1061,1059,-1,1206,1225,1061,-1,2561,1243,2688,-1,1244,1243,2561,-1,1741,1182,1252,-1,1741,1793,1182,-1,1737,1248,2666,-1,1737,1736,1248,-1,1737,1434,1645,-1,1737,2666,1434,-1,991,2554,992,-1,2702,2554,991,-1,2547,3392,3362,-1,2547,1039,3392,-1,1642,999,998,-1,1732,999,1642,-1,1875,3363,1876,-1,3393,3363,1875,-1,3346,3360,3394,-1,3395,3360,3346,-1,1719,1880,264,-1,1881,1880,1719,-1,1665,1393,3351,-1,1393,1665,1664,-1,2597,3396,2699,-1,2597,2598,3396,-1,1023,1587,1021,-1,1548,1587,1023,-1,3378,1303,3377,-1,1126,1303,3378,-1,537,3397,1306,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_16()
		{
			int[] value = {537,2106,3397,-1,3398,1785,1699,-1,3398,3379,1785,-1,1298,3379,3398,-1,1298,3399,3379,-1,2678,1705,1157,-1,2678,1301,1705,-1,1701,1315,1307,-1,1421,1315,1701,-1,1695,2602,2601,-1,1337,2602,1695,-1,3400,2661,1331,-1,3401,2661,3400,-1,1306,3402,1335,-1,3402,1306,3403,-1,1345,3404,2658,-1,1345,1695,3404,-1,1686,3400,3405,-1,1689,3400,1686,-1,3403,1693,2603,-1,3403,3406,1693,-1,1373,1342,1341,-1,1373,1693,1342,-1,2608,1688,1682,-1,2608,3407,1688,-1,1561,3350,1864,-1,1561,1685,3350,-1,1683,1721,1400,-1,1721,1683,2607,-1,3408,1350,1354,-1,1350,3408,3409,-1,293,3410,1662,-1,293,1673,3410,-1,1348,3411,1366,-1,1348,2605,3411,-1,1369,1374,1010,-1,1374,1369,1375,-1,1378,1399,3411,-1,1377,1399,1378,-1,2604,1365,1677,-1,1365,2604,1687,-1,2657,1675,1363,-1,2654,1675,2657,-1,3412,3410,1356,-1,3410,3412,3413,-1,1662,3413,1353,-1,1662,3410,3413,-1,1016,1542,1012,-1,1016,2631,1542,-1,1347,2605,1348,-1,2603,2605,1347,-1,2651,1387,1173,-1,2651,2609,1387,-1,2650,3351,1393,-1,2650,2539,3351,-1,1405,1410,1653,-1,2572,1410,1405,-1,1788,1133,1135,-1,1788,2575,1133,-1,1229,2557,1069,-1,2557,1229,2555,-1,1236,1072,1066,-1,1236,2611,1072,-1,1073,1244,2562,-1,1073,1072,1244,-1,2583,1423,2649,-1,1423,2583,1148,-1,1772,1089,1088,-1,1772,1855,1089,-1,1768,1438,3414,-1,1768,1869,1438,-1,1799,1745,1237,-1,1799,1879,1745,-1,1879,3388,1745,-1,1879,977,3388,-1,788,1039,2547,-1,790,1039,788,-1,1032,2697,2544,-1,1032,1275,2697,-1,2615,1616,1633,-1,2615,3415,1616,-1,3415,3416,3417,-1,2615,3416,3415,-1,3418,1458,3419,-1,1458,3418,2647,-1,1452,1631,3420,-1,1450,1631,1452,-1,3416,3421,3422,-1,3423,3421,3416,-1,2645,3424,3425,-1,3424,2645,3419,-1,3422,3426,3427,-1,3421,3426,3422,-1,3428,2645,3425,-1,3428,1461,2645,-1,2644,1462,1461,-1,2644,1471,1462,-1,3427,3429,3430,-1,3426,3429,3427,-1,2640,3431,3430,-1,2640,1619,3431,-1,1464,3432,1476,-1,3432,1464,1626,-1,2118,1486,2972,-1,1486,2118,1487,-1,1488,3433,509,-1,1488,3434,3433,-1,2639,1489,2638,-1,2639,2641,1489,-1,1634,1496,3435,-1,1454,1496,1634,-1,1614,3436,3437,-1,3436,1614,1613,-1,1516,1612,1497,-1,1516,1515,1612,-1,1495,3438,2637,-1,1495,1523,3438,-1,1509,1595,1510,-1,1501,1595,1509,-1,1500,1595,1501,-1,1523,3439,3438,-1,1523,1525,3439,-1,1611,2618,1609,-1,1611,3440,2618,-1,3441,3439,2636,-1,3442,3439,3441,-1,2618,1507,1504,-1,2618,1606,1507,-1,3443,3441,3444,-1,3445,3441,3443,-1,1503,3446,3443,-1,3446,1503,3447,-1,3448,3446,2620,-1,3448,3449,3446,-1,1602,3448,494,-1,1602,1605,3448,-1,2634,3450,3451,-1,2634,1510,3450,-1,1522,3452,3453,-1,1522,1513,3452,-1,3454,1456,3455,-1,1457,1456,3454,-1,3456,1597,1520,-1,1597,3456,1598,-1,1592,3454,3457,-1,1524,3454,1592,-1,1598,2622,2621,-1,1598,1593,2622,-1,1596,3440,1611,-1,1596,2621,3440,-1,1588,1545,1547,-1,1588,1531,1545,-1,1931,1581,1574,-1,1934,1581,1931,-1,3292,1529,1533,-1,1529,3292,2627,-1,1567,3458,1572,-1,3458,1567,3459,-1,1575,897,1576,-1,1575,2708,897,-1,899,2625,897,-1,899,1535,2625,-1,3460,944,1557,-1,944,3460,945,-1,2628,3336,2629,-1,3336,2628,3461,-1,2629,1889,904,-1,1889,2629,3336,-1,3461,928,3336,-1,928,3461,929,-1,3462,929,3461,-1,929,3462,3327,-1,1535,2523,1536,-1,899,2523,1535,-1,1577,887,1554,-1,1577,1552,887,-1,1568,1572,1571,-1,1572,1568,1567,-1,1553,1579,1537,-1,1553,1589,1579,-1,1535,1585,2625,-1,1535,1584,1585,-1,1579,1580,1539,-1,1532,1580,1579,-1,2621,3463,3440,-1,2621,2622,3463,-1,3464,3457,3465,-1,1592,3457,3464,-1,3456,1593,1598,-1,3456,1599,1593,-1,3457,3455,3466,-1,3454,3455,3457,-1,3466,2614,1521,-1,3466,3467,2614,-1,2633,3453,3452,-1,3453,2633,1517,-1,3450,2633,3451,-1,2633,3450,1518,-1,2634,3468,3469,-1,3468,2634,3451,-1,2620,3447,1604,-1,2620,3446,3447,-1,1505,3447,1503,-1,3447,1505,2635,-1,3470,3471,3472,-1,3470,3473,3471,-1,3443,1608,1503,-1,3443,3444,1608,-1,3444,2636,1610,-1,3441,2636,3444,-1,3440,1606,2618,-1,3440,3463,1606,-1,1594,1510,1595,-1,1600,1510,1594,-1,1519,1510,1600,-1,1519,3450,1510,-1,1519,1518,3450,-1,2637,3474,3475,-1,2637,3438,3474,-1,2619,3437,3470,-1,3437,2619,1614,-1,3435,2637,3475,-1,1496,2637,3435,-1,511,1474,506,-1,511,2638,1474,-1,2642,3433,3434,-1,3433,2642,2639,-1,1484,1488,1487,-1,1488,1484,3434,-1,1479,1621,1620,-1,1479,1469,1621,-1,1626,1478,3432,-1,1478,1626,1470,-1,506,1473,1625,-1,506,1474,1473,-1,1621,2644,3476,-1,1621,1469,2644,-1,3430,2641,2640,-1,3429,2641,3430,-1,1468,3429,3426,-1,1468,1467,3429,-1,3476,1461,3428,-1,3476,2644,1461,-1,3477,3425,3478,-1,3477,3428,3425,-1,3421,1468,3426,-1,3479,1468,3421,-1,3425,3480,3478,-1,3480,3425,3424,-1,3423,3479,3421,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_17()
		{
			int[] value = {3420,3479,3423,-1,3419,1632,3424,-1,1632,3419,1458,-1,2615,3423,3416,-1,1453,3423,2615,-1,3415,1457,1616,-1,3415,1455,1457,-1,1795,3481,1008,-1,3481,1795,1794,-1,1437,3414,1438,-1,1428,3414,1437,-1,1268,2567,2566,-1,1268,1270,2567,-1,1198,1742,1744,-1,1198,1241,1742,-1,1059,1060,2610,-1,1059,1061,1060,-1,3482,1838,1759,-1,1838,3482,1220,-1,3371,1151,3386,-1,1151,3371,1158,-1,1190,967,1191,-1,1415,967,1190,-1,1396,1116,1115,-1,1396,1413,1116,-1,1171,1658,1657,-1,1658,1171,1170,-1,2674,1117,1406,-1,1107,1117,2674,-1,1388,1668,1391,-1,1390,1668,1388,-1,2651,1388,2609,-1,2651,1389,1388,-1,1170,1408,1658,-1,3483,1408,1170,-1,3370,1267,2612,-1,1267,3370,1729,-1,1021,1586,1281,-1,1587,1586,1021,-1,1672,295,969,-1,295,1672,296,-1,2654,2656,3409,-1,2654,2657,2656,-1,2699,1023,1022,-1,3396,1023,2699,-1,1375,1690,1376,-1,1375,1682,1690,-1,1378,2605,1692,-1,1378,3411,2605,-1,1343,1679,1344,-1,1368,1679,1343,-1,3484,1881,1719,-1,3484,3485,1881,-1,1353,3408,1354,-1,3413,3408,1353,-1,1319,1675,2655,-1,1674,1675,1319,-1,2656,1400,1351,-1,2656,1683,1400,-1,1881,1694,970,-1,1694,1881,3485,-1,3407,1343,2658,-1,1343,3407,2608,-1,3402,2603,1347,-1,3402,3403,2603,-1,1689,3401,3400,-1,1688,3401,1689,-1,2659,1342,3486,-1,1342,2659,1339,-1,1333,3402,3487,-1,1333,1335,3402,-1,3401,1327,2661,-1,3488,1327,3401,-1,2659,2602,1337,-1,2659,2660,2602,-1,1335,1332,538,-1,1332,1335,1333,-1,1331,1329,540,-1,1331,2661,1329,-1,1674,1322,1698,-1,1319,1322,1674,-1,999,2662,1316,-1,2662,999,1432,-1,1706,2578,1784,-1,1706,1702,2578,-1,1304,3489,1305,-1,1304,1299,3489,-1,3397,1127,1312,-1,3397,1125,1127,-1,1298,1296,2663,-1,1296,1298,3398,-1,1297,3399,1298,-1,3490,3399,1297,-1,3490,1313,1700,-1,1297,1313,3490,-1,1125,2106,1128,-1,2106,1125,3397,-1,1816,3491,2569,-1,1790,3491,1816,-1,1013,2630,3492,-1,1013,1541,2630,-1,1281,2631,1016,-1,1281,1586,2631,-1,3366,3353,3357,-1,3366,1796,3353,-1,2682,3355,3354,-1,3493,3355,2682,-1,3362,1851,2696,-1,3392,1851,3362,-1,1258,1448,1447,-1,1448,1258,1637,-1,1254,3494,1736,-1,3494,1254,2593,-1,1248,3494,1246,-1,1736,3494,1248,-1,3495,1250,3496,-1,1740,1250,3495,-1,2700,1144,1009,-1,2700,1145,1144,-1,1181,2687,1243,-1,2564,2687,1181,-1,1650,1240,1235,-1,1650,1241,1240,-1,1749,3497,1232,-1,1749,1200,3497,-1,1840,1759,1838,-1,2689,1759,1840,-1,1839,1067,1074,-1,1839,1065,1067,-1,1062,2555,1060,-1,2555,1062,2556,-1,1747,1749,1231,-1,1749,1747,1383,-1,3365,1858,3347,-1,3358,1858,3365,-1,3390,3367,3498,-1,3368,3367,3390,-1,1185,1758,1075,-1,1185,3499,1758,-1,3499,3500,3501,-1,3500,3499,1185,-1,1229,235,234,-1,1229,1071,235,-1,2649,1837,2686,-1,2649,1183,1837,-1,1796,2150,1797,-1,1796,3366,2150,-1,1215,2649,1216,-1,1215,2583,2649,-1,1233,3388,1234,-1,1233,2590,3388,-1,1066,1841,1202,-1,1068,1841,1066,-1,1200,2667,3497,-1,2667,1200,1199,-1,1826,3414,1428,-1,1826,2568,3414,-1,1218,1185,1184,-1,1185,1218,3500,-1,1180,2563,1181,-1,1180,2685,2563,-1,3482,3501,2863,-1,3501,3482,3499,-1,1008,1649,1795,-1,1649,1008,1009,-1,2671,1035,2677,-1,2671,1036,1035,-1,1301,1790,1816,-1,1791,1790,1301,-1,1775,1407,1408,-1,1775,1776,1407,-1,1169,3381,3382,-1,1169,2672,3381,-1,1172,2672,1171,-1,1172,3381,2672,-1,2676,1275,1105,-1,1275,2676,1276,-1,1311,1295,1294,-1,1311,3376,1295,-1,1155,3490,1700,-1,1131,3490,1155,-1,1812,3491,2570,-1,1812,3377,3491,-1,1287,1289,1420,-1,1287,1709,1289,-1,2574,3502,3375,-1,2575,3502,2574,-1,274,2379,3372,-1,274,10,2379,-1,1135,1789,1788,-1,1136,1789,1135,-1,1720,1115,1398,-1,1720,1396,1115,-1,1374,1108,3503,-1,1374,1119,1108,-1,1660,1285,1661,-1,1660,1711,1285,-1,1403,2674,2675,-1,2674,1403,3503,-1,782,2580,1444,-1,784,2580,782,-1,1440,3504,1100,-1,1260,3504,1440,-1,1094,3386,1095,-1,1094,3385,3386,-1,2151,2669,2450,-1,2151,1192,2669,-1,2151,2928,1192,-1,1753,1271,1754,-1,1753,1272,1271,-1,1223,2542,3367,-1,2542,1223,1856,-1,2150,3389,394,-1,2150,1213,3389,-1,1005,3354,2664,-1,1005,2682,3354,-1,1756,1082,1762,-1,1083,1082,1756,-1,1074,1840,1839,-1,1074,1073,1840,-1,1065,1068,1067,-1,1065,1064,1068,-1,1225,2588,1752,-1,1225,1224,2588,-1,1057,3344,1058,-1,2537,3344,1057,-1,1052,2610,1141,-1,2610,1052,1054,-1,1039,1266,3392,-1,1039,1038,1266,-1,1734,2546,1639,-1,1734,2665,2546,-1,3361,3394,3360,-1,3361,3505,3394,-1,1025,1160,1723,-1,1160,1025,1024,-1,2158,1027,1026,-1,2158,3506,1027,-1,1774,2543,1162,-1,1774,1028,2543,-1,1084,1833,1080,-1,1756,1833,1084,-1,3369,1755,1754,-1,3369,3356,1755,-1,2541,2686,3507,-1,2686,2541,1216,-1,2597,1019,1717,-1,2597,1020,1019,-1,1013,1714,1283,-1,3492,1714,1013,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_18()
		{
			int[] value = {1666,1719,266,-1,1719,1666,3484,-1,1009,2592,2700,-1,2592,1009,1007,-1,2680,1002,1272,-1,2595,1002,2680,-1,3505,1033,3394,-1,3505,1034,1033,-1,3365,1089,3348,-1,1089,3365,1090,-1,1269,1726,1728,-1,1269,1268,1726,-1,2596,2697,1722,-1,2697,2596,2544,-1,995,3345,1847,-1,3345,995,994,-1,2692,3344,1844,-1,3344,2692,3508,-1,980,3363,1045,-1,3363,980,979,-1,1806,983,982,-1,1806,1878,983,-1,1088,512,1772,-1,512,1088,1829,-1,965,2669,966,-1,965,1767,2669,-1,1766,805,2724,-1,1766,2723,805,-1,3509,815,817,-1,3510,815,3509,-1,1978,2723,1092,-1,805,2723,1978,-1,2725,1980,2548,-1,2725,800,1980,-1,800,1262,2496,-1,800,2725,1262,-1,796,1882,798,-1,796,1641,1882,-1,956,3341,957,-1,956,3511,3341,-1,957,3339,3512,-1,957,3341,3339,-1,2533,1893,2705,-1,1893,2533,950,-1,3338,3513,3514,-1,3338,3340,3513,-1,2706,3515,946,-1,2706,3514,3515,-1,3515,3334,946,-1,3334,3515,3516,-1,3516,942,3334,-1,942,3516,3517,-1,911,2526,912,-1,911,3518,2526,-1,1566,943,945,-1,1565,943,1566,-1,3519,940,2527,-1,940,3519,3520,-1,916,3332,1908,-1,916,940,3332,-1,938,931,936,-1,931,938,921,-1,3332,3320,3330,-1,3332,3318,3320,-1,3329,956,2704,-1,3329,3331,956,-1,3319,3519,3521,-1,3319,3520,3519,-1,3318,3520,3319,-1,3522,3325,3518,-1,925,3325,3522,-1,3328,3323,3324,-1,3323,3328,922,-1,949,1559,1894,-1,949,924,1559,-1,937,3523,3322,-1,3460,3523,937,-1,1906,1913,1901,-1,1906,2525,1913,-1,3310,2707,2528,-1,2707,3310,3315,-1,918,3314,919,-1,918,908,3314,-1,3309,3313,3524,-1,3312,3313,3309,-1,3315,3307,3525,-1,3310,3307,3315,-1,3309,2494,794,-1,3309,3524,2494,-1,802,3525,3307,-1,801,3525,802,-1,1982,909,3208,-1,1982,3526,909,-1,900,1892,901,-1,900,3278,1892,-1,1536,3527,3289,-1,1536,2523,3527,-1,3306,1555,1554,-1,3306,3528,1555,-1,2519,898,2708,-1,2519,2521,898,-1,3528,894,1555,-1,3528,3282,894,-1,889,2709,896,-1,2709,889,3301,-1,892,1922,893,-1,892,2711,1922,-1,895,3529,1551,-1,3283,3529,895,-1,3286,3298,3297,-1,3285,3298,3286,-1,3293,3297,3298,-1,3293,3296,3297,-1,3291,3293,3292,-1,3293,3291,3296,-1,3530,1590,1589,-1,1590,3530,1929,-1,1553,3289,3288,-1,1553,1536,3289,-1,890,1569,3285,-1,890,1578,1569,-1,2516,3282,3528,-1,3282,2516,3284,-1,3531,3281,3280,-1,3531,3532,3281,-1,1939,3306,886,-1,3306,1939,1938,-1,1920,3279,900,-1,1920,3532,3279,-1,3239,1942,2515,-1,3239,2713,1942,-1,3276,1945,875,-1,3276,3237,1945,-1,3271,874,2712,-1,3533,874,3271,-1,1946,1943,1947,-1,1944,1943,1946,-1,2514,2512,876,-1,2514,1949,2512,-1,3270,873,872,-1,3270,3268,873,-1,1948,3267,2513,-1,1948,3534,3267,-1,1950,3264,1951,-1,1950,3535,3264,-1,3263,3534,3536,-1,3267,3534,3263,-1,3535,3260,3264,-1,3535,3537,3260,-1,3538,3263,3536,-1,3263,3538,3259,-1,3537,3256,3260,-1,3537,3539,3256,-1,3540,3259,3538,-1,3259,3540,3255,-1,3539,3253,3256,-1,3539,3541,3253,-1,3542,3255,3540,-1,3255,3542,3250,-1,3253,3543,3249,-1,3253,3541,3543,-1,3544,3250,3542,-1,3250,3544,3247,-1,3249,3545,3245,-1,3249,3543,3545,-1,868,3247,3544,-1,3247,868,3241,-1,3245,3235,3243,-1,3245,3545,3235,-1,3241,2713,3239,-1,3241,868,2713,-1,3243,3237,3276,-1,3243,3235,3237,-1,3546,869,3232,-1,870,869,3546,-1,3547,3228,3230,-1,3548,3228,3547,-1,3549,1943,1942,-1,3549,3227,1943,-1,3219,3550,3226,-1,3219,867,3550,-1,2511,3551,3223,-1,2511,1957,3551,-1,3222,2714,3236,-1,3222,2715,2714,-1,867,2507,843,-1,3219,2507,867,-1,857,3218,2716,-1,857,864,3218,-1,1955,2505,1956,-1,1955,1960,2505,-1,857,2715,858,-1,2715,857,2716,-1,847,1959,855,-1,847,846,1959,-1,1963,850,839,-1,1963,2506,850,-1,859,2504,865,-1,2504,859,1966,-1,835,831,830,-1,835,2717,831,-1,1968,826,834,-1,2499,826,1968,-1,2502,822,3216,-1,822,2502,1969,-1,820,836,828,-1,820,1974,836,-1,825,821,823,-1,824,821,825,-1,3217,2719,3215,-1,3217,818,2719,-1,2501,804,2718,-1,2721,804,2501,-1,3552,818,3217,-1,3552,3213,818,-1,2669,2703,2450,-1,2722,2703,2669,-1,1766,1783,2723,-1,965,1783,1766,-1,2498,811,3342,-1,2498,809,811,-1,3212,3214,3553,-1,2720,3214,3212,-1,3554,1915,799,-1,3555,1915,3554,-1,2725,2547,2677,-1,2548,2547,2725,-1,2000,2735,2493,-1,2736,2735,2000,-1,787,1106,783,-1,3556,1106,787,-1,2648,1444,1443,-1,2726,1444,2648,-1,3177,3557,3558,-1,3557,3177,3204,-1,3160,3204,3202,-1,3160,3557,3204,-1,3161,769,3559,-1,3161,3560,769,-1,2728,2020,3200,-1,2728,2018,2020,-1,3561,3200,2020,-1,3199,3200,3561,-1,771,3195,2730,-1,771,766,3195,-1,3199,3135,3197,-1,3199,3561,3135,-1,2730,3194,765,-1,2730,3195,3194,-1,3135,3562,3197,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_19()
		{
			int[] value = {3562,3135,3137,-1,3190,765,3194,-1,3563,765,3190,-1,3137,3564,3562,-1,3564,3137,3565,-1,3190,3186,3563,-1,3186,3190,3189,-1,3565,3185,3564,-1,3185,3565,2017,-1,3189,3182,3186,-1,3182,3189,3566,-1,2017,3181,3185,-1,3181,2017,2016,-1,3178,3566,3567,-1,3178,3182,3566,-1,2016,758,3181,-1,758,2016,3133,-1,3567,3179,3178,-1,3179,3567,3568,-1,3133,759,758,-1,759,3133,3569,-1,1985,755,3570,-1,1985,756,755,-1,3571,3168,3558,-1,3167,3168,3571,-1,3572,3165,3162,-1,3165,3572,3192,-1,3559,778,3161,-1,778,3559,3201,-1,1999,3118,749,-1,3118,1999,1996,-1,2029,743,2030,-1,2029,748,743,-1,3115,2487,3573,-1,3115,703,2487,-1,2741,3154,696,-1,3154,2741,3152,-1,2031,3149,3113,-1,3149,2031,739,-1,2734,2732,704,-1,2733,2732,2734,-1,3556,3154,3151,-1,3556,3156,3154,-1,2002,3150,3206,-1,2002,2733,3150,-1,3149,785,786,-1,3149,739,785,-1,3574,3146,3131,-1,3574,3575,3146,-1,3122,3119,2483,-1,3121,3119,3122,-1,3120,3127,3124,-1,3120,736,3127,-1,3140,713,3142,-1,3140,711,713,-1,2011,735,3576,-1,723,735,2011,-1,719,733,717,-1,733,719,732,-1,2010,727,726,-1,2010,3139,727,-1,2738,3141,725,-1,2738,3143,3141,-1,735,705,2028,-1,734,705,735,-1,717,721,2739,-1,722,721,717,-1,3561,3130,3135,-1,3561,3128,3130,-1,3125,1987,1986,-1,3125,3132,1987,-1,3131,2484,3574,-1,2484,3131,3128,-1,3577,3126,3134,-1,3577,3124,3126,-1,3136,3121,3123,-1,3136,3578,3121,-1,2005,3575,2003,-1,3575,2005,3146,-1,750,718,2739,-1,750,749,718,-1,3159,712,1993,-1,712,3159,2740,-1,2732,701,702,-1,2732,2485,701,-1,697,3157,2486,-1,697,696,3157,-1,2850,2777,2428,-1,2777,2850,2849,-1,693,640,690,-1,693,2476,640,-1,687,690,683,-1,687,693,690,-1,2037,2742,3579,-1,2742,2037,686,-1,679,3579,2742,-1,679,2041,3579,-1,676,3111,673,-1,3111,676,678,-1,666,673,3111,-1,666,669,673,-1,639,665,637,-1,2044,665,639,-1,649,656,2477,-1,649,660,656,-1,654,3580,652,-1,3580,654,2056,-1,652,2051,2050,-1,2051,652,3580,-1,646,2053,650,-1,641,2053,646,-1,2048,640,642,-1,3107,640,2048,-1,682,624,628,-1,682,625,624,-1,2042,616,638,-1,617,616,2042,-1,2907,3106,633,-1,3106,2907,3581,-1,626,2746,627,-1,626,2904,2746,-1,2936,2894,3582,-1,2894,2936,3104,-1,2074,3102,3085,-1,3102,2074,2470,-1,3100,3085,3102,-1,3100,3583,3085,-1,3098,3583,3100,-1,3098,3584,3583,-1,3087,3098,3095,-1,3087,3584,3098,-1,3089,2076,598,-1,2076,3089,2066,-1,3093,3585,3586,-1,3093,3587,3585,-1,3588,2071,2877,-1,609,2071,3588,-1,593,2468,2075,-1,593,601,2468,-1,3587,3091,614,-1,3587,3090,3091,-1,3089,3584,3087,-1,3584,3089,3589,-1,601,595,602,-1,601,593,595,-1,352,2069,592,-1,351,2069,352,-1,2098,3078,562,-1,2098,3080,3078,-1,586,2100,3590,-1,2100,586,589,-1,3079,3080,3075,-1,3080,3079,3078,-1,2081,3590,2079,-1,3590,2081,586,-1,3591,3075,3070,-1,3075,3591,3079,-1,2749,3591,3070,-1,2749,3069,3591,-1,2086,3060,3056,-1,2086,2465,3060,-1,2751,580,581,-1,2750,580,2751,-1,3592,581,580,-1,3592,573,581,-1,2091,2105,2102,-1,2090,2105,2091,-1,2102,3055,2462,-1,2105,3055,2102,-1,2464,566,567,-1,2093,566,2464,-1,556,3055,548,-1,3055,556,2462,-1,342,565,564,-1,342,2096,565,-1,568,559,2463,-1,2095,559,568,-1,3083,546,3593,-1,3083,2754,546,-1,2091,3594,2088,-1,3062,3594,2091,-1,3061,3595,3059,-1,3061,3076,3595,-1,3054,548,3055,-1,548,3054,549,-1,317,607,344,-1,607,317,2755,-1,1548,2460,1546,-1,1548,3596,2460,-1,2985,3053,3050,-1,3053,2985,3597,-1,3042,3048,3047,-1,3048,3042,2989,-1,3044,3039,3052,-1,3044,3043,3039,-1,3038,2984,3041,-1,3038,2980,2984,-1,3036,3033,3045,-1,3036,3035,3033,-1,3040,3032,3028,-1,3030,3032,3040,-1,3029,2978,3027,-1,3029,3598,2978,-1,3031,3024,3021,-1,3022,3024,3031,-1,3026,3020,3016,-1,3018,3020,3026,-1,3017,3599,3015,-1,3017,2983,3599,-1,3011,3019,3012,-1,3011,3009,3019,-1,3014,3008,3004,-1,3006,3008,3014,-1,3005,2982,3003,-1,3005,2760,2982,-1,3007,2758,2999,-1,3001,2758,3007,-1,2996,2993,3002,-1,2996,2998,2993,-1,3600,2995,2992,-1,2995,3600,533,-1,2997,2991,2986,-1,2757,2991,2997,-1,2988,3051,2994,-1,2988,2987,3051,-1,2990,3049,3046,-1,2990,3034,3049,-1,2759,3034,2990,-1,2759,3037,3034,-1,2756,3037,2759,-1,2756,3025,3037,-1,3000,3025,2756,-1,3000,3023,3025,-1,3013,3023,3000,-1,3013,3010,3023,-1,518,533,3600,-1,518,517,533,-1,2983,2976,3599,-1,2974,2976,2983,-1,2980,2975,2984,-1,2979,2975,2980,-1,524,522,536,-1,523,522,524,-1,532,519,521,-1,532,517,519,-1,2761,2975,2979,-1,2107,2975,2761,-1,9,8,2379,-1,9,2762,8,-1,494,2620,495,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_20()
		{
			int[] value = {3448,2620,494,-1,509,511,2763,-1,511,509,3433,-1,2972,2764,485,-1,1486,2764,2972,-1,2121,2969,2973,-1,2121,2963,2969,-1,2971,482,2113,-1,2971,2765,482,-1,1477,2970,2616,-1,2970,1477,1480,-1,2878,3586,2968,-1,2878,3093,3586,-1,2964,2765,2963,-1,2964,481,2765,-1,481,470,477,-1,470,481,2766,-1,473,486,474,-1,2962,486,473,-1,2454,484,483,-1,472,484,2454,-1,476,2126,475,-1,476,469,2126,-1,2958,2961,2956,-1,2960,2961,2958,-1,2958,467,466,-1,2958,2957,467,-1,468,2138,469,-1,2138,468,2136,-1,2954,2132,2959,-1,2954,2130,2132,-1,460,2955,2767,-1,2955,460,2135,-1,3601,451,450,-1,3601,2952,451,-1,2943,456,2142,-1,2943,2951,456,-1,2140,2946,2949,-1,2140,2768,2946,-1,3602,356,394,-1,356,3602,354,-1,419,2446,2449,-1,419,2162,2446,-1,2168,2159,428,-1,2159,2168,416,-1,2161,426,425,-1,426,2161,2166,-1,2942,2947,2167,-1,2947,2942,3603,-1,2950,414,430,-1,2950,415,414,-1,421,2945,2953,-1,421,420,2945,-1,2948,2942,2941,-1,3604,2942,2948,-1,415,2161,432,-1,415,2165,2161,-1,437,2152,2148,-1,2157,2152,437,-1,2152,2922,2177,-1,2152,3605,2922,-1,2177,2153,2152,-1,2176,2153,2177,-1,411,2939,3606,-1,411,2170,2939,-1,3582,409,2936,-1,405,409,3582,-1,2940,2924,2938,-1,2940,403,2924,-1,405,407,409,-1,2772,407,405,-1,2934,403,2940,-1,2934,401,403,-1,2771,399,410,-1,2171,399,2771,-1,3607,2773,2932,-1,3607,404,2773,-1,2931,2442,2921,-1,2931,2935,2442,-1,397,3608,395,-1,2929,3608,397,-1,441,396,2180,-1,396,441,3609,-1,2926,2938,2924,-1,2888,2938,2926,-1,2182,3610,2920,-1,2182,2441,3610,-1,2440,2235,2065,-1,2235,2440,2919,-1,2784,2429,2428,-1,2784,2783,2429,-1,2232,390,2230,-1,392,390,2232,-1,2850,2186,2185,-1,358,2186,2850,-1,3611,388,391,-1,3611,2897,388,-1,2913,385,2886,-1,389,385,2913,-1,252,2912,2188,-1,252,251,2912,-1,250,253,249,-1,2218,253,250,-1,2915,3612,2916,-1,3612,2915,3613,-1,360,2197,254,-1,2228,2197,360,-1,3614,3615,3616,-1,3614,3617,3615,-1,3618,3617,3614,-1,3618,3619,3617,-1,3613,3619,3618,-1,3613,3620,3619,-1,2915,3620,3613,-1,3620,2915,2917,-1,2883,2232,2231,-1,2883,2225,2232,-1,2782,2231,357,-1,2782,2883,2231,-1,2879,2228,360,-1,2879,3621,2228,-1,3581,2201,2203,-1,2907,2201,3581,-1,2206,2746,2904,-1,2206,2208,2746,-1,2780,2062,2781,-1,2062,2780,2473,-1,2212,2202,2199,-1,2212,376,2202,-1,2207,370,2216,-1,2204,370,2207,-1,2215,2210,2902,-1,2210,2215,2781,-1,372,2902,373,-1,2882,2902,372,-1,3622,3623,2908,-1,3623,3622,3624,-1,3625,2893,2900,-1,3625,3626,2893,-1,2895,2897,3611,-1,2897,2895,2887,-1,2896,3624,3627,-1,2896,2895,3624,-1,2893,2925,2891,-1,2925,2893,3626,-1,365,245,244,-1,3628,245,365,-1,384,162,2271,-1,384,2189,162,-1,2187,188,2801,-1,188,2187,2886,-1,2776,355,2884,-1,2776,2918,355,-1,3629,371,2880,-1,369,371,3629,-1,2878,2965,2877,-1,2878,2968,2965,-1,2238,609,3588,-1,609,2238,2472,-1,2247,3590,2248,-1,2079,3590,2247,-1,2242,2080,2243,-1,2242,2082,2080,-1,336,331,333,-1,335,331,336,-1,302,2421,338,-1,302,326,2421,-1,300,325,324,-1,300,2244,325,-1,2245,319,321,-1,2787,319,2245,-1,2788,314,312,-1,2788,305,314,-1,2249,307,2252,-1,307,2249,308,-1,2755,2876,2251,-1,2876,2755,2875,-1,2250,2873,2420,-1,2874,2873,2250,-1,304,2787,308,-1,304,319,2787,-1,326,301,2873,-1,301,326,302,-1,307,299,298,-1,307,309,299,-1,2378,2869,2375,-1,2869,2378,3630,-1,2789,2857,286,-1,2857,2789,3631,-1,158,216,218,-1,160,216,158,-1,281,2318,282,-1,281,1147,2318,-1,22,185,2409,-1,22,21,185,-1,2360,3632,2832,-1,2360,272,3632,-1,2813,2868,55,-1,2813,2852,2868,-1,2577,277,297,-1,2577,278,277,-1,2859,2315,2402,-1,2285,2315,2859,-1,2867,2840,2839,-1,2867,2853,2840,-1,2871,184,183,-1,184,2871,123,-1,2860,2845,2844,-1,2860,2419,2845,-1,2217,2190,2218,-1,2217,2191,2190,-1,2431,2220,2219,-1,2431,222,2220,-1,230,2846,2320,-1,2861,2846,230,-1,2273,231,2282,-1,2273,232,231,-1,2856,170,2275,-1,2856,2316,170,-1,2858,2795,2274,-1,220,2795,2858,-1,2866,2796,2865,-1,236,2796,2866,-1,2863,2414,2862,-1,2863,3501,2414,-1,2796,235,1764,-1,233,235,2796,-1,197,2288,198,-1,2289,2288,197,-1,229,2861,230,-1,229,2287,2861,-1,226,222,227,-1,223,222,226,-1,248,2219,2221,-1,248,247,2219,-1,215,218,216,-1,215,219,218,-1,286,236,2866,-1,236,286,2857,-1,210,2280,2281,-1,209,2280,210,-1,202,2411,2279,-1,201,2411,202,-1,2848,242,3633,-1,2855,242,2848,-1,169,2317,2275,-1,169,2400,2317,-1,2791,2844,267,-1,2791,2860,2844,-1,385,2271,2415,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_21()
		{
			int[] value = {384,2271,385,-1,93,2854,3634,-1,93,2418,2854,-1,103,118,189,-1,103,2395,118,-1,2303,153,149,-1,153,2303,2311,-1,2798,2305,140,-1,2798,169,2305,-1,2790,155,170,-1,156,155,2790,-1,2408,154,146,-1,2407,154,2408,-1,290,3631,144,-1,290,2857,3631,-1,2291,2799,2292,-1,2291,2800,2799,-1,199,2847,203,-1,199,3635,2847,-1,2403,139,141,-1,367,139,2403,-1,2301,2222,2312,-1,2301,138,2222,-1,2846,3636,2841,-1,3636,2846,268,-1,2811,2845,2803,-1,2845,2811,2326,-1,92,165,85,-1,165,92,88,-1,2397,120,2396,-1,121,120,2397,-1,101,2397,280,-1,101,2325,2397,-1,2842,2323,2843,-1,2324,2323,2842,-1,100,102,2842,-1,102,100,2395,-1,2326,105,2327,-1,2326,2811,105,-1,2331,98,111,-1,2330,98,2331,-1,95,2840,2417,-1,95,2319,2840,-1,2831,59,2822,-1,2831,23,59,-1,2344,2830,2345,-1,2830,2344,2368,-1,2353,2338,2362,-1,2339,2338,2353,-1,65,2819,3637,-1,67,2819,65,-1,2837,2836,3637,-1,2837,3638,2836,-1,2824,3638,3639,-1,2824,2836,3638,-1,3640,2833,2832,-1,3640,2827,2833,-1,2353,2831,2354,-1,2353,2382,2831,-1,2812,68,2392,-1,2812,71,68,-1,2816,2351,47,-1,2384,2351,2816,-1,26,2358,52,-1,2359,2358,26,-1,2826,57,2835,-1,2826,2825,57,-1,2823,2361,3641,-1,2823,58,2361,-1,2821,0,3642,-1,2821,2377,0,-1,2819,2383,2333,-1,2819,2818,2383,-1,46,2819,67,-1,2819,46,2374,-1,2827,3639,2833,-1,2824,3639,2827,-1,53,2834,56,-1,2357,2834,53,-1,2815,28,27,-1,2815,2838,28,-1,2369,2348,3643,-1,2369,2337,2348,-1,24,52,2814,-1,24,26,52,-1,2338,35,2364,-1,2369,35,2338,-1,56,54,53,-1,54,56,55,-1,2825,2813,57,-1,2813,2825,2872,-1,2357,2391,2834,-1,2391,2357,2343,-1,2835,66,2826,-1,66,2835,63,-1,2389,3638,2837,-1,2389,77,3638,-1,1391,1394,115,-1,1394,1391,1395,-1,2841,2802,2839,-1,2841,3636,2802,-1,96,2809,436,-1,2154,2809,96,-1,2324,2327,105,-1,2327,2324,104,-1,108,2810,107,-1,108,2808,2810,-1,112,2843,2323,-1,112,2322,2843,-1,110,119,98,-1,110,109,119,-1,2406,106,2394,-1,106,2406,178,-1,2328,267,2844,-1,267,2328,3644,-1,2318,129,246,-1,129,2318,127,-1,2806,2312,2805,-1,161,2312,2806,-1,137,2804,2310,-1,136,2804,137,-1,140,2413,2798,-1,2286,2413,140,-1,201,3633,2411,-1,201,2848,3633,-1,123,145,130,-1,145,123,2789,-1,152,149,153,-1,150,149,152,-1,2794,158,285,-1,2794,2807,158,-1,162,2806,2306,-1,162,161,2806,-1,2307,2405,2404,-1,175,2405,2307,-1,2851,3645,2849,-1,3645,2851,3646,-1,2852,2867,2868,-1,2852,2853,2867,-1,125,270,2321,-1,271,270,125,-1,188,151,150,-1,151,188,2415,-1,192,2408,193,-1,192,383,2408,-1,2401,239,2800,-1,240,239,2401,-1,2856,3635,241,-1,2856,2847,3635,-1,213,290,214,-1,213,237,290,-1,220,2859,284,-1,220,2858,2859,-1,171,224,172,-1,224,171,2797,-1,2791,208,207,-1,269,208,2791,-1,1219,2864,2865,-1,1219,1221,2864,-1,2795,3500,1218,-1,238,3500,2795,-1,234,237,213,-1,234,233,237,-1,2399,2864,2862,-1,2398,2864,2399,-1,131,287,217,-1,131,145,287,-1,2320,228,230,-1,2320,126,228,-1,268,2861,269,-1,268,2846,2861,-1,250,223,226,-1,191,223,250,-1,3,3630,2378,-1,3630,3,3647,-1,383,152,2407,-1,383,2801,152,-1,18,2410,19,-1,18,2263,2410,-1,143,187,186,-1,187,143,142,-1,3632,2321,270,-1,3632,272,2321,-1,2286,134,2413,-1,134,2286,368,-1,2814,190,117,-1,2814,54,190,-1,3640,2854,2872,-1,3640,3634,2854,-1,2385,182,273,-1,2385,60,182,-1,2255,2263,18,-1,2255,2258,2263,-1,2402,284,2859,-1,285,284,2402,-1,120,15,2396,-1,15,120,16,-1,2871,144,3631,-1,2871,142,144,-1,288,127,1147,-1,288,128,127,-1,323,2874,2876,-1,2874,323,327,-1,2788,306,305,-1,2788,303,306,-1,300,2875,316,-1,300,324,2875,-1,318,298,316,-1,318,2786,298,-1,2420,301,311,-1,2873,301,2420,-1,337,306,303,-1,306,337,320,-1,309,322,299,-1,309,2423,322,-1,327,2422,328,-1,327,323,2422,-1,340,320,337,-1,340,329,320,-1,325,2247,2422,-1,2243,2247,325,-1,2424,350,349,-1,2424,2425,350,-1,2424,3588,2236,-1,2238,3588,2424,-1,347,2425,2236,-1,346,2425,347,-1,2881,3621,2879,-1,2881,2433,3621,-1,363,2883,2782,-1,363,2882,2883,-1,2885,247,2792,-1,2885,2219,247,-1,2884,3628,2885,-1,245,3628,2884,-1,382,227,365,-1,227,382,225,-1,252,2801,383,-1,2187,2801,252,-1,2889,2926,3648,-1,2888,2926,2889,-1,2894,3649,2892,-1,2894,3104,3649,-1,3627,3622,3105,-1,3627,3624,3622,-1,2898,3648,3650,-1,2898,2889,3648,-1,2909,2892,3649,-1,2909,2899,2892,-1,371,2901,2881,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_22()
		{
			int[] value = {371,370,2901,-1,373,2436,2432,-1,2436,373,2435,-1,379,2434,2901,-1,378,2434,379,-1,2213,2780,2214,-1,2780,2213,2437,-1,2209,2903,2747,-1,2209,2211,2903,-1,380,2905,3651,-1,380,2205,2905,-1,2745,2200,2906,-1,2745,2198,2200,-1,2783,2430,2429,-1,2226,2430,2783,-1,2785,3629,2427,-1,2224,3629,2785,-1,3621,2229,2228,-1,3621,2227,2229,-1,2416,2426,2438,-1,2416,2183,2426,-1,2784,2196,2195,-1,2784,2778,2196,-1,3613,2911,3612,-1,2911,3613,3618,-1,256,225,382,-1,256,255,225,-1,2911,3614,2910,-1,2911,3618,3614,-1,2910,3616,2912,-1,2910,3614,3616,-1,2779,3650,313,-1,2898,3650,2779,-1,2897,2779,388,-1,2897,2898,2779,-1,2439,2851,386,-1,2851,2439,3646,-1,2230,389,2913,-1,390,389,2230,-1,3623,391,2184,-1,3623,3611,391,-1,3645,2917,2914,-1,3645,3620,2917,-1,2777,2916,2778,-1,2777,2914,2916,-1,2920,3652,2919,-1,3652,2920,3653,-1,605,3654,3610,-1,3654,605,604,-1,2775,2921,2922,-1,2921,2775,2930,-1,3655,2925,2927,-1,2925,3655,2891,-1,2890,3606,2939,-1,2896,3606,2890,-1,2774,2933,398,-1,2933,2774,2175,-1,2178,2932,2930,-1,3607,2932,2178,-1,2935,401,2934,-1,2935,2931,401,-1,2772,2929,407,-1,3608,2929,2772,-1,398,2444,2169,-1,398,2933,2444,-1,404,402,2773,-1,404,406,402,-1,412,2771,410,-1,2771,412,408,-1,406,2927,402,-1,406,3655,2927,-1,3656,408,412,-1,408,3656,2937,-1,2775,3605,442,-1,2775,2922,3605,-1,2443,2928,2151,-1,2443,2174,2928,-1,442,1647,443,-1,1647,442,429,-1,2944,419,2449,-1,2944,420,419,-1,2160,414,413,-1,418,414,2160,-1,421,424,2770,-1,421,422,424,-1,2951,2944,2165,-1,2943,2944,2951,-1,417,2768,418,-1,2768,417,2946,-1,2952,3604,422,-1,3601,3604,2952,-1,419,2163,2162,-1,419,2770,2163,-1,427,2168,428,-1,2941,2168,427,-1,434,2769,435,-1,2769,434,2163,-1,86,2164,425,-1,2164,86,444,-1,2151,2148,2152,-1,2151,2149,2148,-1,968,1387,449,-1,968,1173,1387,-1,2147,3603,2145,-1,2147,2947,3603,-1,2144,430,2139,-1,2144,2950,430,-1,2953,2141,453,-1,2953,2945,2141,-1,2141,454,453,-1,454,2141,2131,-1,2957,2133,467,-1,2957,2452,2133,-1,464,2124,2126,-1,2124,464,2129,-1,2767,2766,2123,-1,2766,2767,2955,-1,3657,2959,2956,-1,3657,2954,2959,-1,2955,470,2766,-1,470,2955,468,-1,473,3657,2962,-1,473,2125,3657,-1,471,2964,2456,-1,2453,2964,471,-1,2961,3658,2120,-1,2960,3658,2961,-1,2455,475,478,-1,475,2455,476,-1,479,474,503,-1,478,474,479,-1,2764,3658,483,-1,3658,2764,3659,-1,2968,3096,2966,-1,2968,3586,3096,-1,3467,1511,2614,-1,3467,493,1511,-1,510,504,502,-1,504,510,505,-1,2963,2971,2969,-1,2963,2765,2971,-1,485,2973,2972,-1,485,2121,2973,-1,3659,508,2457,-1,508,3659,2643,-1,507,505,510,-1,505,507,2763,-1,489,3373,491,-1,489,1830,3373,-1,3467,1603,493,-1,1603,3467,1514,-1,526,2974,524,-1,526,2976,2974,-1,528,2977,527,-1,528,2981,2977,-1,1562,528,515,-1,1562,2761,528,-1,3598,2981,2978,-1,2977,2981,3598,-1,532,2982,2760,-1,532,2112,2982,-1,2111,3597,2985,-1,2111,2458,3597,-1,2991,2989,2986,-1,2991,3048,2989,-1,3597,2992,3053,-1,2992,3597,3600,-1,2998,2994,2993,-1,2998,2988,2994,-1,2758,2997,2999,-1,2758,2757,2997,-1,533,3005,2995,-1,3005,533,2760,-1,3004,2996,3002,-1,3008,2996,3004,-1,3009,3001,3007,-1,3011,3001,3009,-1,3003,2983,3017,-1,3003,2982,2983,-1,3006,3016,3020,-1,3006,3014,3016,-1,3021,3012,3019,-1,3024,3012,3021,-1,3015,3598,3029,-1,3015,3599,3598,-1,3028,3018,3026,-1,3032,3018,3028,-1,3033,3022,3031,-1,3035,3022,3033,-1,3027,2980,3038,-1,3027,2978,2980,-1,3043,3040,3039,-1,3043,3030,3040,-1,3047,3045,3042,-1,3047,3036,3045,-1,2984,3050,3041,-1,3050,2984,2985,-1,3052,2987,3044,-1,2987,3052,3051,-1,540,972,541,-1,972,540,1329,-1,535,542,531,-1,1302,542,535,-1,3056,3660,3057,-1,3056,3661,3660,-1,3662,3060,2465,-1,3662,3058,3060,-1,556,557,554,-1,557,556,547,-1,2753,561,563,-1,2753,2097,561,-1,563,569,2753,-1,569,563,3066,-1,332,564,2094,-1,332,342,564,-1,570,3066,2752,-1,570,569,3066,-1,570,573,3592,-1,570,2752,573,-1,579,576,2092,-1,2089,576,579,-1,336,2085,2466,-1,336,574,2085,-1,3069,2750,2751,-1,2749,2750,3069,-1,3071,583,2467,-1,584,583,3071,-1,3661,3060,3059,-1,3661,3056,3060,-1,587,3071,3074,-1,587,584,3071,-1,2103,3059,3595,-1,2103,3661,3059,-1,588,3074,3081,-1,588,587,3074,-1,3595,551,2103,-1,551,3595,3593,-1,558,3081,2099,-1,558,588,3081,-1,3593,2104,551,-1,2104,3593,546,-1,3653,604,590,-1,3654,604,3653,-1,603,611,2748,-1,611,603,599,-1,3086,3583,3663,-1,3085,3583,3086,-1,3585,2066,3088,-1,3585,613,2066,-1,597,603,595,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_23()
		{
			int[] value = {603,600,599,-1,597,600,603,-1,2073,3092,2471,-1,2073,3090,3092,-1,3092,3587,3093,-1,3092,3090,3587,-1,2967,3097,3664,-1,2967,2966,3097,-1,3664,3099,2117,-1,3664,3097,3099,-1,501,3099,3101,-1,2117,3099,501,-1,2116,3101,3103,-1,501,3101,2116,-1,498,3103,2469,-1,2116,3103,498,-1,3105,3656,3627,-1,3105,2937,3656,-1,627,2903,2058,-1,627,2747,2903,-1,3651,2059,2060,-1,2059,3651,2905,-1,2745,631,630,-1,631,2745,2906,-1,629,637,672,-1,629,2744,637,-1,3106,617,2042,-1,617,3106,2060,-1,2051,2056,636,-1,3580,2056,2051,-1,643,3665,2033,-1,643,647,3665,-1,647,651,3665,-1,647,2743,651,-1,2743,658,651,-1,2743,2045,658,-1,2043,655,657,-1,653,655,2043,-1,660,666,656,-1,660,669,666,-1,664,3110,672,-1,664,667,3110,-1,668,3109,674,-1,668,671,3109,-1,621,672,3110,-1,672,621,2474,-1,675,3109,2038,-1,674,3109,675,-1,680,621,678,-1,621,680,622,-1,622,685,681,-1,622,680,685,-1,2039,3666,2040,-1,2039,3667,3666,-1,681,687,683,-1,681,685,687,-1,3667,2035,3666,-1,3667,2036,2035,-1,691,2475,694,-1,691,3107,2475,-1,2034,644,643,-1,2034,2479,644,-1,3116,3113,3114,-1,3112,3113,3116,-1,700,2741,698,-1,700,699,2741,-1,3117,703,3115,-1,3117,704,703,-1,2013,2488,715,-1,2013,3118,2488,-1,2483,2006,2021,-1,3119,2006,2483,-1,3120,709,2009,-1,710,709,3120,-1,2015,3122,3145,-1,2014,3122,2015,-1,3127,3132,3125,-1,3127,3144,3132,-1,3574,2019,3668,-1,2019,3574,2484,-1,3134,3569,3133,-1,3134,3126,3569,-1,3136,3565,3137,-1,3136,3123,3565,-1,712,716,715,-1,716,712,711,-1,2481,720,3576,-1,2481,2480,720,-1,2740,3138,713,-1,2740,2026,3138,-1,3142,2003,3140,-1,2004,2003,3142,-1,732,729,733,-1,732,728,729,-1,731,720,722,-1,2012,720,731,-1,725,3138,734,-1,3141,3138,725,-1,3139,2737,727,-1,2737,3139,3669,-1,2024,2738,2025,-1,2024,3143,2738,-1,3669,3144,2737,-1,3144,3669,3668,-1,2022,3577,3145,-1,2022,710,3577,-1,3129,2482,3578,-1,3129,2023,2482,-1,3670,3147,3148,-1,3670,3155,3147,-1,787,3156,3556,-1,787,738,3156,-1,3205,3152,2001,-1,3153,3152,3205,-1,3670,2726,2648,-1,3670,3148,2726,-1,3147,3117,3114,-1,3155,3117,3147,-1,3157,738,737,-1,738,3157,3156,-1,3112,3158,1995,-1,3112,3116,3158,-1,747,701,748,-1,747,702,701,-1,2027,3158,3573,-1,2027,3159,3158,-1,777,3557,3160,-1,3671,3557,777,-1,3164,3672,3673,-1,3672,3164,3163,-1,762,3674,3166,-1,2731,3674,762,-1,2490,3675,2489,-1,3675,2490,3676,-1,2490,1992,1985,-1,1992,2490,757,-1,3180,3558,3168,-1,3558,3180,3177,-1,3168,3183,3180,-1,3168,3166,3183,-1,3191,2489,3675,-1,3191,3184,2489,-1,3166,3187,3183,-1,3166,3674,3187,-1,3677,3191,3188,-1,3191,3677,3184,-1,3674,3678,3187,-1,3674,3572,3678,-1,3193,3677,3188,-1,3193,3679,3677,-1,3162,3678,3572,-1,3162,763,3678,-1,3196,3679,3193,-1,3196,3198,3679,-1,3164,763,3162,-1,3164,764,763,-1,768,3198,3196,-1,768,2491,3198,-1,3673,764,3164,-1,3673,2729,764,-1,3559,2729,3673,-1,3559,769,2729,-1,1988,1990,770,-1,1988,772,1990,-1,751,2018,2728,-1,751,1987,2018,-1,3202,3161,3160,-1,3161,3202,3560,-1,3680,1989,3203,-1,1989,3680,775,-1,3569,779,759,-1,779,3569,1986,-1,3568,3203,3179,-1,3203,3568,3680,-1,781,3153,3205,-1,781,2492,3153,-1,3670,2493,2735,-1,3670,2648,2493,-1,3153,1168,3151,-1,3153,2492,1168,-1,3208,3209,3207,-1,3208,3210,3209,-1,3213,3510,3509,-1,3213,3552,3510,-1,2721,2724,804,-1,2721,3211,2724,-1,813,1091,1093,-1,812,1091,813,-1,2720,819,3214,-1,2720,1972,819,-1,803,2500,2499,-1,803,807,2500,-1,819,1974,820,-1,819,1972,1974,-1,3216,1976,1975,-1,1976,3216,822,-1,3215,827,1970,-1,3215,2719,827,-1,2717,823,831,-1,825,823,2717,-1,1973,836,1974,-1,1973,837,836,-1,828,856,829,-1,828,836,856,-1,860,840,848,-1,860,841,840,-1,852,1962,842,-1,851,1962,852,-1,2510,861,2508,-1,2510,1964,861,-1,3220,3218,1958,-1,3681,3218,3220,-1,2508,3682,2509,-1,3682,2508,3221,-1,866,3224,3683,-1,866,1954,3224,-1,3272,3220,3225,-1,3272,3681,3220,-1,3231,3684,3229,-1,3231,3685,3684,-1,3234,3686,3687,-1,3233,3686,3234,-1,3688,3689,3690,-1,3691,3689,3688,-1,3691,3692,3689,-1,3693,3692,3691,-1,3693,3694,3692,-1,3695,3694,3693,-1,3695,3696,3694,-1,3697,3696,3695,-1,3697,3698,3696,-1,3697,3699,3698,-1,3275,3232,3244,-1,3232,3275,3546,-1,3240,3699,3238,-1,3699,3240,3698,-1,3234,3244,3232,-1,3234,3242,3244,-1,3699,3246,3238,-1,3697,3246,3699,-1,3687,3242,3234,-1,3687,3248,3242,-1,3697,3251,3246,-1,3695,3251,3697,-1,3547,3248,3687,-1,3547,3252,3248,-1,3251,3693,3254,-1,3693,3251,3695,-1,3230,3252,3547,-1,3230,3257,3252,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_24()
		{
			int[] value = {3254,3691,3258,-1,3691,3254,3693,-1,3261,3230,3229,-1,3261,3257,3230,-1,3258,3688,3262,-1,3688,3258,3691,-1,3265,3229,3684,-1,3265,3261,3229,-1,3262,3690,3266,-1,3690,3262,3688,-1,3268,3684,873,-1,3268,3265,3684,-1,3690,3269,3266,-1,3689,3269,3690,-1,3689,3700,3269,-1,3692,3700,3689,-1,872,2712,3270,-1,3271,2712,872,-1,3692,3274,3700,-1,3694,3274,3692,-1,3274,3696,3273,-1,3696,3274,3694,-1,3546,874,3533,-1,3546,3275,874,-1,3273,3698,3240,-1,3698,3273,3696,-1,3278,3284,3701,-1,3278,3277,3284,-1,905,3281,1919,-1,905,882,3281,-1,2517,881,1930,-1,2517,882,881,-1,3283,3279,3529,-1,3283,3277,3279,-1,892,3286,2710,-1,892,891,3286,-1,3702,3290,3287,-1,3304,3290,3702,-1,3304,3703,3290,-1,3302,3703,3304,-1,3302,3704,3703,-1,3303,3704,3302,-1,3303,3295,3704,-1,3299,3295,3303,-1,3299,3294,3295,-1,3299,3300,3294,-1,3290,3530,3288,-1,3530,3290,3703,-1,3280,1932,3458,-1,3280,2517,1932,-1,3280,3459,3531,-1,3280,3458,3459,-1,1551,3531,3459,-1,3529,3531,1551,-1,1924,2711,2710,-1,1924,2518,2711,-1,890,2520,888,-1,890,891,2520,-1,894,3283,895,-1,3282,3283,894,-1,1575,2709,3301,-1,1556,2709,1575,-1,2522,3305,1921,-1,2522,1923,3305,-1,3304,3527,3305,-1,3527,3304,3702,-1,880,1940,884,-1,880,951,1940,-1,3278,1890,1892,-1,3701,1890,3278,-1,1979,907,1914,-1,3210,907,1979,-1,3705,1981,3308,-1,1981,3705,3555,-1,3705,3311,3316,-1,3705,3308,3311,-1,908,3526,3314,-1,908,909,3526,-1,3312,1907,3313,-1,914,1907,3312,-1,2524,1904,915,-1,1904,2524,906,-1,3316,1905,1902,-1,1905,3316,3311,-1,3319,3337,3317,-1,3340,3319,3513,-1,3340,3337,3319,-1,939,915,1904,-1,939,916,915,-1,3323,921,938,-1,3323,922,921,-1,1557,925,3522,-1,926,925,1557,-1,911,3322,3523,-1,911,1909,3322,-1,3330,3321,3511,-1,3330,3320,3321,-1,961,930,962,-1,961,3333,930,-1,933,3331,3329,-1,933,1908,3331,-1,3326,2531,3333,-1,3326,3706,2531,-1,933,1909,934,-1,933,3324,1909,-1,910,1909,911,-1,1910,1909,910,-1,3517,920,942,-1,920,3517,2527,-1,943,3462,1564,-1,1897,3462,943,-1,3518,3335,2526,-1,3518,3325,3335,-1,3325,947,3335,-1,3325,2530,947,-1,2530,948,947,-1,2530,949,948,-1,3707,948,950,-1,948,3707,2706,-1,3339,3707,3512,-1,3707,3339,3338,-1,1891,1941,953,-1,1891,879,1941,-1,1891,877,879,-1,877,1891,1918,-1,958,2529,2704,-1,1900,2529,958,-1,2495,789,788,-1,3554,789,2495,-1,1983,1984,791,-1,3207,1984,1983,-1,796,793,1641,-1,793,796,795,-1,814,1977,812,-1,1977,814,811,-1,1767,3212,2722,-1,3212,1767,3211,-1,2497,3510,3342,-1,2497,815,3510,-1,968,817,816,-1,817,968,2450,-1,2567,1829,1088,-1,1829,2567,2679,-1,3708,2549,2613,-1,3708,3343,2549,-1,984,2550,3393,-1,984,981,2550,-1,990,1873,1050,-1,1873,990,989,-1,2552,2701,996,-1,2701,2552,2702,-1,3394,2545,3346,-1,2545,3394,1033,-1,1726,2566,1727,-1,2566,1726,1268,-1,1773,3349,1855,-1,3349,1773,1871,-1,2587,1828,1827,-1,2587,3493,1828,-1,1753,1827,2681,-1,1753,2587,1827,-1,1832,1008,3481,-1,1832,1006,1008,-1,2599,1866,1865,-1,3709,1866,2599,-1,3351,3710,1665,-1,3710,3351,3350,-1,1011,1016,1012,-1,1011,1014,1016,-1,1718,1019,1018,-1,1019,1718,1717,-1,1837,3352,3711,-1,1836,3352,1837,-1,1271,1729,3370,-1,1271,1863,1729,-1,3357,3354,3355,-1,3353,3354,3357,-1,3364,3359,3358,-1,3359,3364,3712,-1,3395,2582,3360,-1,3395,1782,2582,-1,1782,1724,1159,-1,1782,3395,1724,-1,3395,2596,1724,-1,2596,3395,3346,-1,2671,2696,2670,-1,2696,2671,3362,-1,3393,3343,984,-1,1875,3343,3393,-1,1054,1652,2693,-1,1054,1053,1652,-1,2701,991,1055,-1,2702,991,2701,-1,2556,1843,2557,-1,1751,1843,2556,-1,1070,2691,2690,-1,1070,1069,2691,-1,2688,2560,1757,-1,2688,2687,2560,-1,3711,2685,2684,-1,3711,3352,2685,-1,1771,1859,2683,-1,1771,1862,1859,-1,3602,3498,445,-1,3390,3498,3602,-1,3357,1214,3366,-1,3356,1214,3357,-1,3391,2668,3368,-1,1648,2668,3391,-1,3498,3712,445,-1,3498,3359,3712,-1,1792,3386,3385,-1,1792,3371,3386,-1,1276,2546,1277,-1,1165,2546,1276,-1,2676,1165,1276,-1,1101,1165,2676,-1,1442,2493,1443,-1,2493,1442,1640,-1,2379,1404,3372,-1,2379,8,1404,-1,2674,1108,1107,-1,2674,3503,1108,-1,1288,1818,1114,-1,1817,1818,1288,-1,1111,2653,1822,-1,1111,1364,2653,-1,1399,1822,2653,-1,1399,1661,1822,-1,515,1684,516,-1,515,2108,1684,-1,1139,1776,1140,-1,1776,1139,1811,-1,1431,1422,1421,-1,1422,1431,1430,-1,2694,1807,1849,-1,2694,1047,1807,-1,1848,1873,989,-1,986,1873,1848,-1,2551,1422,1048,-1,2551,988,1422,-1,1058,3508,2553,-1,1058,3344,3508,-1,1251,3374,1253,-1,3713,3374,1251,-1,1808,3376,1311,-1,1810,3376,1808,-1,1708,1152,1290,-1,1708,2600,1152,-1,1158,2678,1157,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_25()
		{
			int[] value = {3371,2678,1158,-1,3378,1132,1156,-1,1132,3378,2571,-1,1130,3379,3399,-1,1813,3379,1130,-1,3376,3714,1295,-1,3376,3375,3714,-1,2543,3505,3361,-1,1853,3505,2543,-1,1781,1102,1101,-1,1781,1780,1102,-1,1170,3383,3483,-1,3383,1170,1169,-1,3384,3380,3715,-1,3382,3380,3384,-1,3715,1846,2581,-1,3380,1846,3715,-1,1815,1094,1646,-1,1094,1815,3385,-1,1869,1852,2670,-1,1868,1852,1869,-1,1648,1177,2668,-1,1648,1178,1177,-1,1182,1145,2700,-1,1793,1145,1182,-1,1183,1077,1836,-1,1077,1183,1075,-1,1427,1826,1428,-1,1769,1826,1427,-1,1093,3414,2568,-1,1093,1768,3414,-1,816,2497,1191,-1,2497,816,815,-1,3387,1197,1196,-1,1197,3387,1763,-1,2559,1068,1064,-1,2559,1841,1068,-1,1230,1204,1203,-1,1204,1230,2589,-1,1870,1830,1004,-1,1870,3373,1830,-1,1080,1210,1078,-1,1833,1210,1080,-1,1060,234,212,-1,1060,2555,234,-1,1220,1063,1838,-1,1219,1063,1220,-1,1423,281,283,-1,281,1423,1148,-1,3507,2684,1835,-1,3507,3711,2684,-1,3367,3359,3498,-1,3367,2542,3359,-1,2565,1088,1090,-1,2565,2567,1088,-1,1069,1843,2691,-1,2557,1843,1069,-1,1750,1382,1383,-1,1750,2588,1382,-1,2561,1757,2586,-1,1757,2561,2688,-1,3387,1232,3497,-1,3387,1230,1232,-1,1238,3388,2590,-1,3388,1238,1745,-1,2591,1241,1650,-1,2591,1742,1241,-1,1743,1247,1424,-1,1247,1743,1249,-1,3496,1249,1743,-1,1250,1249,3496,-1,1246,3713,1251,-1,1246,3494,3713,-1,2536,1057,2673,-1,1057,2536,2537,-1,985,1671,1051,-1,1872,1671,985,-1,1222,1856,1223,-1,1222,1426,1856,-1,1001,1425,1179,-1,1001,1728,1425,-1,296,1673,293,-1,296,1672,1673,-1,1867,2539,2650,-1,1865,2539,1867,-1,2460,1717,1358,-1,2460,2598,1717,-1,1012,1541,1013,-1,1542,1541,1012,-1,1707,1784,1786,-1,1784,1707,1706,-1,1787,1702,1305,-1,1702,1787,2578,-1,1126,1156,1127,-1,1126,3378,1156,-1,1308,3398,1699,-1,1308,1296,3398,-1,1299,3714,3489,-1,1299,2663,3714,-1,1707,1710,1697,-1,3716,1710,1707,-1,1710,1323,1697,-1,1710,1703,1323,-1,3502,1305,3489,-1,1305,3502,1787,-1,1286,1709,1287,-1,1704,1709,1286,-1,1362,1293,534,-1,1361,1293,1362,-1,1333,539,1334,-1,539,1333,1330,-1,1696,3406,1697,-1,3406,1696,3486,-1,3404,2601,1326,-1,1695,2601,3404,-1,3405,1331,1330,-1,3400,1331,3405,-1,1697,3403,1306,-1,3403,1697,3406,-1,2658,3488,3407,-1,2658,3404,3488,-1,3405,1346,1686,-1,3405,3487,1346,-1,1356,1320,3412,-1,1355,1320,1356,-1,1359,1717,1716,-1,1359,1358,1717,-1,1683,1363,1362,-1,1363,1683,2657,-1,2655,3409,3408,-1,3409,2655,2654,-1,1356,1673,1357,-1,3410,1673,1356,-1,2653,3411,1399,-1,1366,3411,2653,-1,1401,1379,1371,-1,1379,1401,2652,-1,3396,1548,1023,-1,3396,3596,1548,-1,3717,1684,973,-1,1684,3717,1685,-1,1685,3710,3350,-1,1685,3717,3710,-1,3409,1351,1350,-1,3409,2656,1351,-1,3412,1319,2655,-1,1320,1319,3412,-1,2651,967,1669,-1,2651,1173,967,-1,1283,1713,1667,-1,1283,1714,1713,-1,1010,3503,1403,-1,3503,1010,1374,-1,1407,1409,1134,-1,2573,1409,1407,-1,1124,2572,1123,-1,1124,1136,2572,-1,1136,1124,1789,-1,1777,1057,1056,-1,1777,2673,1057,-1,1116,1823,1819,-1,1414,1823,1116,-1,1823,1187,1418,-1,1823,1414,1187,-1,1070,1765,1071,-1,1070,2558,1765,-1,1072,1067,1066,-1,1074,1067,1072,-1,1007,2683,1834,-1,1007,1006,2683,-1,1829,1087,512,-1,1829,1828,1087,-1,1438,2696,1851,-1,1438,1869,2696,-1,1778,1103,1824,-1,1104,1103,1778,-1,1459,2646,1490,-1,2647,2646,1459,-1,1455,3417,3480,-1,3415,3417,1455,-1,2647,1629,2646,-1,2647,3418,1629,-1,3417,3422,3718,-1,3416,3422,3417,-1,1463,3419,2645,-1,3419,1463,3418,-1,3427,3718,3422,-1,3427,3719,3718,-1,3477,3431,3720,-1,3719,3431,3477,-1,3719,3430,3431,-1,3427,3430,3719,-1,3720,1619,1618,-1,3431,1619,3720,-1,1476,1623,1624,-1,1623,1476,3432,-1,1478,1469,1479,-1,1478,1470,1469,-1,1482,1487,2118,-1,1487,1482,1484,-1,1619,2642,1485,-1,2642,1619,2640,-1,3433,2638,511,-1,3433,2639,2638,-1,3436,1451,3721,-1,1451,3436,1635,-1,1451,3435,3721,-1,1634,3435,1451,-1,3437,3721,3722,-1,3721,3437,3436,-1,1601,1497,1615,-1,1601,1516,1497,-1,1495,2632,1523,-1,1499,2632,1495,-1,3470,3722,3473,-1,3722,3470,3437,-1,2636,1525,2623,-1,3439,1525,2636,-1,3438,3442,3474,-1,3438,3439,3442,-1,3445,3442,3441,-1,3471,3442,3445,-1,3449,3443,3446,-1,3449,3445,3443,-1,1605,3449,3448,-1,1605,3472,3449,-1,2635,2634,3469,-1,2635,1508,2634,-1,1513,3468,3452,-1,1513,1512,3468,-1,2614,1513,1522,-1,2614,1511,1513,-1,3455,1515,1514,-1,1456,1515,3455,-1,1520,3453,3456,-1,1520,1522,3453,-1,3465,1520,1597,-1,3465,1521,1520,-1,2632,3454,1524,-1,2632,1457,3454,-1,1611,3464,1596,-1,2617,3464,1611,-1,1544,1530,1591,-1,1544,1531,1530,-1,1585,1548,2624,-1,1585,1587,1548,-1,1537,2631,1584,-1,1537,1542,2631,-1,1529,1570,1574,-1,1529,2627,1570,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_26()
		{
			int[] value = {3292,1573,3291,-1,1573,3292,1533,-1,1528,897,2624,-1,1576,897,1528,-1,1897,3327,3462,-1,3327,1897,1896,-1,1563,2629,1558,-1,2629,1563,2628,-1,903,901,904,-1,903,902,901,-1,1558,1894,1559,-1,901,1894,1558,-1,1564,3461,2628,-1,3461,1564,3462,-1,930,936,931,-1,1899,936,930,-1,1576,1552,1577,-1,1576,1528,1552,-1,3459,1549,1551,-1,3459,1567,1549,-1,3458,1570,1572,-1,1932,1570,3458,-1,1932,1574,1570,-1,1931,1574,1932,-1,1588,1533,1529,-1,1533,1588,1534,-1,2622,1500,3463,-1,2622,1595,1500,-1,2617,1592,3464,-1,2623,1592,2617,-1,1596,3465,1597,-1,3464,3465,1596,-1,1599,1594,1593,-1,1599,1600,1594,-1,3465,3466,1521,-1,3457,3466,3465,-1,1517,3456,3453,-1,3456,1517,1599,-1,3466,1514,3467,-1,3455,1514,3466,-1,3451,3452,3468,-1,3452,3451,2633,-1,3469,1512,1604,-1,1512,3469,3468,-1,2635,1604,3447,-1,1604,2635,3469,-1,2619,3472,1605,-1,2619,3470,3472,-1,3472,3445,3449,-1,3472,3471,3445,-1,3471,3474,3442,-1,3473,3474,3471,-1,1608,1610,1609,-1,3444,1610,1608,-1,3463,1607,1606,-1,3463,1500,1607,-1,3473,3475,3474,-1,3475,3473,3722,-1,2619,1615,1614,-1,2619,1601,1615,-1,3721,3475,3722,-1,3435,3475,3721,-1,1498,1633,1616,-1,1498,1494,1633,-1,1613,1635,3436,-1,1635,1613,1617,-1,1485,3434,1484,-1,3434,1485,2642,-1,1620,1480,1479,-1,1483,1480,1620,-1,1623,1478,1477,-1,1623,3432,1478,-1,1489,1466,1475,-1,1466,1489,1467,-1,3476,1618,1621,-1,3720,1618,3476,-1,2641,1467,1489,-1,1467,2641,3429,-1,3720,3428,3477,-1,3720,3476,3428,-1,3719,3478,3718,-1,3719,3477,3478,-1,1468,1628,1627,-1,1628,1468,3479,-1,1630,3418,1463,-1,3418,1630,1629,-1,3480,3718,3478,-1,3417,3718,3480,-1,3420,1628,3479,-1,1631,1628,3420,-1,3424,1455,3480,-1,1455,3424,1632,-1,1453,3420,3423,-1,1452,3420,1453,-1,1490,1464,1617,-1,2646,1464,1490,-1,1097,1446,1443,-1,1097,1637,1446,-1,1870,1794,3373,-1,1794,1870,3481,-1,2679,2595,2680,-1,2679,2594,2595,-1,1007,2684,1180,-1,1835,2684,1007,-1,1202,2690,1384,-1,2690,1202,1842,-1,1065,1838,1063,-1,1065,1839,1838,-1,1056,2552,1846,-1,2552,1056,2554,-1,2260,1659,1653,-1,2260,2577,1659,-1,2675,1659,3372,-1,2675,1406,1659,-1,1109,1364,1111,-1,1109,1120,1364,-1,2609,1386,1387,-1,1386,2609,1670,-1,2607,1716,1721,-1,2607,1359,1716,-1,3484,3717,3485,-1,3484,3710,3717,-1,2699,1020,2597,-1,2699,1676,1020,-1,1349,1678,2606,-1,1681,1678,1349,-1,1344,1678,1691,-1,1679,1678,1344,-1,1372,1349,1370,-1,1349,1372,1681,-1,1376,2604,1677,-1,1690,2604,1376,-1,264,969,295,-1,1880,969,264,-1,2655,3413,3412,-1,2655,3408,3413,-1,3485,973,1694,-1,3485,3717,973,-1,1538,1864,1866,-1,1864,1538,1561,-1,1690,1686,2604,-1,1690,1689,1686,-1,3487,1347,1346,-1,3487,3402,1347,-1,1688,3488,3401,-1,3407,3488,1688,-1,3486,1693,3406,-1,1693,3486,1342,-1,1330,3487,3405,-1,1330,1333,3487,-1,3488,1326,1327,-1,3404,1326,3488,-1,3486,2660,2659,-1,3486,1696,2660,-1,1355,2660,1320,-1,2602,2660,1355,-1,1361,1291,1293,-1,1698,1291,1361,-1,1674,1361,1363,-1,1674,1698,1361,-1,1710,1153,2600,-1,3716,1153,1710,-1,3397,1304,1306,-1,3397,1312,1304,-1,2663,1295,3714,-1,1295,2663,1296,-1,1313,1299,1304,-1,1299,1313,1297,-1,3716,1786,1153,-1,1786,3716,1707,-1,3377,2569,3491,-1,1303,2569,3377,-1,2630,3709,3492,-1,3709,2630,1543,-1,2598,3596,3396,-1,2598,2460,3596,-1,1716,1397,1721,-1,1718,1397,1716,-1,3349,3364,3348,-1,3349,3506,3364,-1,1002,1179,1863,-1,1179,1002,1001,-1,1734,1436,964,-1,1734,1037,1436,-1,984,3708,982,-1,3708,984,3343,-1,2538,2546,2665,-1,1277,2546,2538,-1,1259,1737,1645,-1,1257,1737,1259,-1,2593,3713,3494,-1,3713,2593,1738,-1,3374,1738,1739,-1,3374,3713,1738,-1,1740,1742,2591,-1,3495,1742,1740,-1,1742,3496,1743,-1,3496,1742,3495,-1,1062,1751,2556,-1,1062,1752,1751,-1,1842,1070,2690,-1,1842,2558,1070,-1,2691,1746,1384,-1,1843,1746,2691,-1,1269,2594,1270,-1,1269,1000,2594,-1,3356,1212,1214,-1,3356,3369,1212,-1,3391,1213,1212,-1,3389,1213,3391,-1,1076,2687,2564,-1,2560,2687,1076,-1,1220,2863,1221,-1,2863,1220,3482,-1,2560,1075,1758,-1,1076,1075,2560,-1,289,1210,1761,-1,289,288,1210,-1,978,1877,979,-1,1730,1877,978,-1,2584,1233,1239,-1,2584,2590,1233,-1,1763,3497,2667,-1,1763,3387,3497,-1,1418,1096,1416,-1,1418,1189,1096,-1,3352,2563,2685,-1,2563,3352,2698,-1,1759,3499,3482,-1,3499,1759,1758,-1,1215,1079,1078,-1,1215,1861,1079,-1,1408,2581,1775,-1,1408,3715,2581,-1,3715,1408,3483,-1,3483,3384,3715,-1,3384,3483,3383,-1,1638,1103,1825,-1,1638,1824,1103,-1,2677,3504,1260,-1,2677,1100,3504,-1,1035,1100,2677,-1,784,1779,2580,-1,784,1167,1779,-1,1161,2164,1162,-1,1647,2164,1161,-1,3375,3489,3714,-1,3489,3375,3502,-1,1131,3399,3490,-1,1130,3399,1131,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_27()
		{
			int[] value = {2570,1790,1815,-1,2570,3491,1790,-1,1709,1290,1289,-1,1708,1290,1709,-1,2575,1787,3502,-1,1788,1787,2575,-1,1311,1654,1808,-1,1311,1310,1654,-1,1255,1795,1649,-1,1255,1636,1795,-1,1760,1796,1278,-1,1796,1760,3353,-1,1055,994,2701,-1,1055,1798,994,-1,987,1799,1227,-1,987,2535,1799,-1,1804,1879,1802,-1,1804,2695,1879,-1,1430,1048,1422,-1,1048,1430,1046,-1,2574,1809,1133,-1,1810,1809,2574,-1,1407,1811,2573,-1,1776,1811,1407,-1,1117,1123,1405,-1,1110,1123,1117,-1,1711,1817,1288,-1,1711,1660,1817,-1,2675,1404,1403,-1,2675,3372,1404,-1,1189,2568,1826,-1,1189,1188,2568,-1,1648,1212,2612,-1,1212,1648,3391,-1,1857,3347,1858,-1,3347,1857,1727,-1,1755,3493,2587,-1,1755,3355,3493,-1,3390,394,3389,-1,3390,3602,394,-1,2541,1835,1834,-1,2541,3507,1835,-1,2558,1841,2559,-1,1842,1841,2558,-1,992,2553,3508,-1,2554,2553,992,-1,1652,3345,2693,-1,1652,1735,3345,-1,1141,2261,1142,-1,2261,1141,2610,-1,2551,2694,1801,-1,2551,1047,2694,-1,2576,982,3708,-1,2576,1806,982,-1,3392,1265,1851,-1,1265,3392,1266,-1,1871,3506,3349,-1,1871,1027,3506,-1,3361,1162,2543,-1,1163,1162,3361,-1,3506,3712,3364,-1,3712,3506,2158,-1,1426,1857,1856,-1,1857,1426,1725,-1,2585,1860,1273,-1,2585,1209,1860,-1,1756,1208,1833,-1,1756,1762,1208,-1,1861,1859,1862,-1,1217,1859,1861,-1,1754,3370,3369,-1,1754,1271,3370,-1,2686,3711,3507,-1,2686,1837,3711,-1,3492,2599,1714,-1,3709,2599,3492,-1,3710,1666,1665,-1,3484,1666,3710,-1,3709,1538,1866,-1,3709,1543,1538,-1,1081,3481,1870,-1,1081,1832,3481,-1,1087,3493,2682,-1,1828,3493,1087,-1,1853,1034,3505,-1,1853,1030,1034,-1,3347,1090,3365,-1,1090,3347,2565,-1,1728,1000,1269,-1,1728,1001,1000,-1,1277,1722,2697,-1,1277,2538,1722,-1,3508,993,992,-1,3508,2692,993,-1,2536,1226,1205,-1,1872,1226,2536,-1,986,2535,987,-1,986,1848,2535,-1,3393,1045,3363,-1,3393,2550,1045,-1,3708,2695,2576,-1,3708,2613,2695,-1,1876,975,1043,-1,1877,975,1876,-1,1270,2679,2567,-1,2679,1270,2594,-1,2722,3553,2703,-1,2722,3212,3553,-1,2703,3509,817,-1,2703,3553,3509,-1,1091,1978,1092,-1,1091,808,1978,-1,789,799,963,-1,789,3554,799,-1,1261,2496,1262,-1,1261,3209,2496,-1,963,798,1882,-1,963,799,798,-1,3511,3317,3341,-1,3511,3321,3317,-1,958,3512,2533,-1,958,957,3512,-1,1941,1888,1886,-1,952,1888,1941,-1,3512,950,2533,-1,950,3512,3707,-1,1941,951,952,-1,1941,1940,951,-1,3338,2706,3707,-1,2706,3338,3514,-1,3514,3723,3515,-1,3514,3513,3723,-1,3723,3516,3515,-1,3516,3723,3724,-1,3724,3517,3516,-1,3517,3724,3521,-1,3521,2527,3517,-1,2527,3521,3519,-1,937,945,3460,-1,1566,945,937,-1,3706,1898,2531,-1,3706,1895,1898,-1,3520,3332,940,-1,3332,3520,3318,-1,3329,3324,933,-1,3329,3328,3324,-1,927,3333,961,-1,927,3326,3333,-1,3331,3511,956,-1,3331,3330,3511,-1,1896,3706,3326,-1,1896,1895,3706,-1,949,1893,950,-1,1893,949,1894,-1,3523,3518,911,-1,3522,3518,3523,-1,2529,922,3328,-1,922,2529,923,-1,3460,3522,3523,-1,1557,3522,3460,-1,941,914,913,-1,941,1907,914,-1,1905,1910,1902,-1,1910,1905,934,-1,3521,3513,3319,-1,3521,3723,3513,-1,3724,3723,3521,-1,3311,2528,1905,-1,2528,3311,3310,-1,906,918,1904,-1,918,906,908,-1,2525,914,3312,-1,1906,914,2525,-1,939,2527,940,-1,1903,2527,939,-1,942,913,2526,-1,942,941,913,-1,3314,3524,3313,-1,3314,3526,3524,-1,2524,3525,1914,-1,3315,3525,2524,-1,3705,1913,1912,-1,1913,3705,3316,-1,1912,3555,3705,-1,3555,1912,1915,-1,801,1914,3525,-1,1979,1914,801,-1,3526,2494,3524,-1,2494,3526,1982,-1,1890,1937,1891,-1,1890,3701,1937,-1,3702,3289,3527,-1,3289,3702,3287,-1,3305,2523,1921,-1,2523,3305,3527,-1,2522,898,2521,-1,898,2522,1921,-1,1555,2709,1556,-1,1555,894,2709,-1,893,2521,2520,-1,2521,893,2522,-1,3299,1922,2711,-1,1922,3299,3303,-1,896,1551,1550,-1,895,1551,896,-1,3297,2710,3286,-1,3297,1924,2710,-1,1926,3300,2518,-1,1926,3294,3300,-1,1571,3298,1568,-1,1571,3293,3298,-1,3291,1925,3296,-1,3291,1928,1925,-1,1929,3295,1927,-1,1929,3704,3295,-1,3703,1929,3530,-1,1929,3703,3704,-1,3288,1589,1553,-1,1589,3288,3530,-1,3532,3529,3279,-1,3531,3529,3532,-1,881,1935,1930,-1,1935,881,883,-1,3528,1938,2516,-1,3528,3306,1938,-1,1919,3532,1920,-1,1919,3281,3532,-1,2516,3701,3284,-1,3701,2516,1937,-1,3549,2713,870,-1,3549,1942,2713,-1,3237,3272,1945,-1,3237,3236,3272,-1,3227,3533,3271,-1,3227,3549,3533,-1,3700,1944,1946,-1,3274,1944,3700,-1,876,3270,2712,-1,876,2512,3270,-1,3269,1946,2513,-1,3700,1946,3269,-1,3226,1950,1949,-1,3226,3550,1950,-1,3534,871,3685,-1,1948,871,3534,-1,3550,3535,1950,-1,3550,3683,3535,-1,3536,3685,3231,-1,3534,3685,3536,-1,3683,3537,3535,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_28()
		{
			int[] value = {3683,3224,3537,-1,3538,3231,3228,-1,3536,3231,3538,-1,3224,3539,3537,-1,3224,3223,3539,-1,3538,3548,3540,-1,3538,3228,3548,-1,3223,3541,3539,-1,3223,3551,3541,-1,3686,3540,3548,-1,3540,3686,3542,-1,3541,3682,3543,-1,3541,3551,3682,-1,3233,3542,3686,-1,3542,3233,3544,-1,3543,3221,3545,-1,3543,3682,3221,-1,869,3544,3233,-1,3544,869,868,-1,3545,3222,3235,-1,3545,3221,3222,-1,3244,3276,3275,-1,3244,3243,3276,-1,3533,870,3546,-1,3549,870,3533,-1,3687,3548,3547,-1,3686,3548,3687,-1,3685,873,3684,-1,3685,871,873,-1,3236,3681,3272,-1,3236,2714,3681,-1,867,3683,3550,-1,867,866,3683,-1,1957,3682,3551,-1,1957,2509,3682,-1,2714,3218,3681,-1,2714,2716,3218,-1,1953,2511,1954,-1,1953,1955,2511,-1,1956,1964,2510,-1,1956,2505,1964,-1,2504,1971,829,-1,1966,1971,2504,-1,859,848,1966,-1,859,860,848,-1,854,1968,1965,-1,854,2503,1968,-1,2718,837,1973,-1,2718,2503,837,-1,1969,823,822,-1,823,1969,831,-1,2719,828,827,-1,2719,820,828,-1,824,807,806,-1,807,824,2500,-1,2498,3217,1975,-1,2498,3552,3217,-1,3342,3552,2498,-1,3552,3342,3510,-1,3553,3213,3509,-1,3214,3213,3553,-1,1981,3554,2495,-1,1981,3555,3554,-1,3206,741,740,-1,3150,741,3206,-1,3556,1168,1106,-1,3556,3151,1168,-1,741,2736,2000,-1,2736,741,3150,-1,3671,3176,3571,-1,3174,3176,3671,-1,3570,3680,3568,-1,3680,3570,755,-1,777,3174,3671,-1,776,3174,777,-1,755,775,3680,-1,775,755,754,-1,1988,3202,1989,-1,3560,3202,1988,-1,770,3560,1988,-1,769,3560,770,-1,3170,3201,3672,-1,3170,3172,3201,-1,3171,3672,3163,-1,3171,3170,3672,-1,766,3196,3195,-1,766,768,3196,-1,3165,3171,3163,-1,3169,3171,3165,-1,3198,3562,3679,-1,3198,3197,3562,-1,3563,763,765,-1,3678,763,3563,-1,3562,3677,3679,-1,3677,3562,3564,-1,3186,3678,3563,-1,3187,3678,3186,-1,3564,3184,3677,-1,3184,3564,3185,-1,3191,3566,3189,-1,3566,3191,3675,-1,3175,762,3167,-1,3175,760,762,-1,3675,3567,3566,-1,3567,3675,3676,-1,3176,3167,3571,-1,3176,3175,3167,-1,3676,3568,3567,-1,3568,3676,3570,-1,2490,3570,3676,-1,2490,1985,3570,-1,3671,3558,3557,-1,3571,3558,3671,-1,3674,3192,3572,-1,3192,3674,2731,-1,3673,3201,3559,-1,3201,3673,3672,-1,3118,1994,2488,-1,3118,1996,1994,-1,3573,706,2027,-1,706,3573,2487,-1,3573,3116,3115,-1,3158,3116,3573,-1,1999,1997,1996,-1,1999,2486,1997,-1,699,3152,2741,-1,3152,699,2001,-1,3149,3114,3113,-1,3147,3114,3149,-1,2001,3206,3205,-1,2001,2002,3206,-1,739,787,785,-1,739,738,787,-1,2735,3155,3670,-1,2735,2734,3155,-1,3121,2482,3119,-1,3578,2482,3121,-1,710,3124,3577,-1,710,3120,3124,-1,3575,3668,3669,-1,3668,3575,3574,-1,2006,2738,724,-1,2025,2738,2006,-1,2003,3669,3139,-1,3669,2003,3575,-1,2012,3576,720,-1,2011,3576,2012,-1,2008,2011,2012,-1,2008,2007,2011,-1,2004,3141,3143,-1,3141,2004,3142,-1,2028,3576,735,-1,2028,2481,3576,-1,3123,2017,3565,-1,3123,2014,2017,-1,3126,1986,3569,-1,3126,3125,1986,-1,2020,3128,3561,-1,2020,2484,3128,-1,3668,3132,3144,-1,3132,3668,2019,-1,3134,3145,3577,-1,2015,3145,3134,-1,3130,3578,3136,-1,3130,3129,3578,-1,2024,3146,2005,-1,3146,2024,2023,-1,2026,3159,2027,-1,2740,3159,2026,-1,2739,745,750,-1,721,745,2739,-1,715,1993,712,-1,715,2488,1993,-1,737,2486,3157,-1,2486,737,1997,-1,2849,2914,2777,-1,2914,2849,3645,-1,2034,2033,2032,-1,2034,643,2033,-1,690,3107,691,-1,690,640,3107,-1,3666,2037,3579,-1,3666,2035,2037,-1,2040,3579,2041,-1,2040,3666,3579,-1,2038,2041,675,-1,2038,2040,2041,-1,3108,2038,3109,-1,3108,2478,2038,-1,667,3111,3110,-1,667,666,3111,-1,646,655,2047,-1,646,2477,655,-1,650,3665,651,-1,2053,3665,650,-1,2053,2033,3665,-1,2052,2033,2053,-1,644,648,645,-1,644,661,648,-1,2479,661,644,-1,2479,662,661,-1,2036,662,2479,-1,2036,670,662,-1,3667,670,2036,-1,3667,3108,670,-1,2039,3108,3667,-1,2478,3108,2039,-1,2061,2057,618,-1,2061,2058,2057,-1,677,2061,623,-1,632,2061,677,-1,3581,2060,3106,-1,2060,3581,3651,-1,3582,2891,3655,-1,2891,3582,2894,-1,2075,594,593,-1,3086,594,2075,-1,3663,594,3086,-1,596,594,3663,-1,2077,3663,3589,-1,2077,596,3663,-1,598,3589,3089,-1,598,2077,3589,-1,2919,3094,2235,-1,3094,2919,3652,-1,2063,3664,2064,-1,2063,2967,3664,-1,3586,3088,3096,-1,3586,3585,3088,-1,2748,614,3091,-1,2748,611,614,-1,601,3091,2468,-1,601,2748,3091,-1,2074,2471,2470,-1,2074,2073,2471,-1,590,3652,3653,-1,590,3094,3652,-1,2068,3094,590,-1,3587,613,3585,-1,3587,614,613,-1,3589,3583,3584,-1,3583,3589,3663,-1,592,2068,590,-1,2069,2068,592,-1,562,553,552,-1,562,3078,553,-1,3077,3083,3076,-1,3083,3077,3082,-1,3081,3075,3080,-1,3081,3074,3075,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_29()
		{
			int[] value = {3079,3660,2461,-1,3079,3591,3660,-1,2081,584,587,-1,2081,585,584,-1,3660,3069,3057,-1,3591,3069,3660,-1,3662,3072,3058,-1,3662,3725,3072,-1,3594,3725,3662,-1,3594,3726,3725,-1,3062,3726,3594,-1,3062,3067,3726,-1,580,2092,3592,-1,579,2092,580,-1,2464,3592,2092,-1,2464,570,3592,-1,555,3068,2101,-1,555,3065,3068,-1,2093,564,566,-1,2094,564,2093,-1,549,3066,563,-1,3066,549,3054,-1,568,2097,2753,-1,568,2463,2097,-1,2754,3063,557,-1,2754,3084,3063,-1,3063,3065,3064,-1,3084,3065,3063,-1,3084,3068,3065,-1,3082,3068,3084,-1,3082,3067,3068,-1,3077,3067,3082,-1,3077,3726,3067,-1,3073,3726,3077,-1,3073,3725,3726,-1,3072,3725,3073,-1,2088,3662,2465,-1,3594,3662,2088,-1,3595,3083,3593,-1,3076,3083,3595,-1,3660,2103,2461,-1,3661,2103,3660,-1,572,2087,577,-1,2090,2087,572,-1,525,1332,1334,-1,525,536,1332,-1,3044,2989,3042,-1,2989,3044,2987,-1,3041,3052,3039,-1,3052,3041,3050,-1,3049,3036,3047,-1,3049,3034,3036,-1,3045,3030,3043,-1,3045,3033,3030,-1,3027,3040,3028,-1,3040,3027,3038,-1,3035,3025,3022,-1,3037,3025,3035,-1,3032,3021,3018,-1,3031,3021,3032,-1,3016,3029,3026,-1,3016,3015,3029,-1,3024,3010,3012,-1,3023,3010,3024,-1,3020,3009,3006,-1,3019,3009,3020,-1,3004,3017,3014,-1,3004,3003,3017,-1,3013,3001,3011,-1,3013,3000,3001,-1,3007,2996,3008,-1,3007,2999,2996,-1,2995,3002,2993,-1,3002,2995,3005,-1,2998,2986,2988,-1,2997,2986,2998,-1,2994,3053,2992,-1,2994,3051,3053,-1,2991,3046,3048,-1,2990,3046,2991,-1,3600,2458,518,-1,2458,3600,3597,-1,3599,2977,3598,-1,2976,2977,3599,-1,2761,2981,528,-1,2761,2979,2981,-1,518,2110,2109,-1,518,2458,2110,-1,2643,2764,1486,-1,2643,3659,2764,-1,2970,2973,2969,-1,2119,2973,2970,-1,2971,1622,2616,-1,2971,2113,1622,-1,2113,480,2114,-1,2113,482,480,-1,2064,2117,2181,-1,2064,3664,2117,-1,1480,2119,2970,-1,2119,1480,1483,-1,2966,3095,3097,-1,2966,3096,3095,-1,2457,3658,3659,-1,2120,3658,2457,-1,2964,2766,481,-1,2766,2964,2453,-1,2960,483,3658,-1,2454,483,2960,-1,2956,2962,3657,-1,2961,2962,2956,-1,3657,2124,2954,-1,3657,2125,2124,-1,2767,2122,2128,-1,2123,2122,2767,-1,2126,2138,464,-1,2126,469,2138,-1,2959,2452,2957,-1,2959,2132,2452,-1,2146,2949,2147,-1,459,2949,2146,-1,2143,456,455,-1,2143,2142,456,-1,2145,3601,450,-1,2145,3603,3601,-1,2945,2142,2141,-1,2945,2943,2142,-1,2139,2768,2140,-1,2139,430,2768,-1,445,2158,444,-1,445,3712,2158,-1,439,446,1174,-1,447,446,439,-1,354,445,86,-1,445,354,3602,-1,1192,441,443,-1,3609,441,1192,-1,1647,428,2164,-1,429,428,1647,-1,2446,87,86,-1,434,87,2446,-1,426,2449,2156,-1,426,2166,2449,-1,2769,423,2447,-1,2769,424,423,-1,2770,2769,2163,-1,2769,2770,424,-1,3604,3603,2942,-1,3603,3604,3601,-1,2165,2950,2951,-1,2165,415,2950,-1,2953,422,421,-1,2952,422,2953,-1,423,3604,2948,-1,422,3604,423,-1,2944,2166,2165,-1,2944,2449,2166,-1,429,2152,2157,-1,442,2152,429,-1,2152,442,3605,-1,441,2179,442,-1,2179,441,2180,-1,2173,3609,1192,-1,3609,2173,396,-1,3606,412,411,-1,412,3606,3656,-1,3655,405,3582,-1,406,405,3655,-1,2444,2940,2170,-1,2444,2934,2940,-1,2169,399,398,-1,399,2169,410,-1,404,3608,2772,-1,3607,3608,404,-1,2935,2175,2442,-1,2935,2933,2175,-1,395,3607,2178,-1,3608,3607,395,-1,2888,2939,2938,-1,2890,2939,2888,-1,3627,3606,2896,-1,3627,3656,3606,-1,2175,2923,2176,-1,2774,2923,2175,-1,2179,2930,2775,-1,2930,2179,2178,-1,605,2441,2072,-1,3610,2441,605,-1,3610,3653,2920,-1,3653,3610,3654,-1,2065,2181,2440,-1,2065,2064,2181,-1,289,2776,2792,-1,289,1279,2776,-1,2183,3623,2184,-1,2908,3623,2183,-1,3646,3620,3645,-1,3646,3619,3620,-1,3617,3646,2439,-1,3646,3617,3619,-1,2186,2886,2187,-1,2913,2886,2186,-1,3615,2439,2188,-1,2439,3615,3617,-1,3616,2188,2912,-1,2188,3616,3615,-1,313,3625,2234,-1,3650,3625,313,-1,2234,2900,2193,-1,3625,2900,2234,-1,3612,2192,2196,-1,2192,3612,2911,-1,256,2438,254,-1,381,2438,256,-1,2916,2196,2778,-1,2196,2916,3612,-1,254,2426,361,-1,2438,2426,254,-1,2427,2880,361,-1,3629,2880,2427,-1,2232,2224,2785,-1,2232,2225,2224,-1,2227,2783,2229,-1,2783,2227,2226,-1,2198,2473,2780,-1,2473,2198,2745,-1,3651,2203,380,-1,3581,2203,3651,-1,2747,2208,2209,-1,2746,2208,2747,-1,2204,2206,2205,-1,2204,2207,2206,-1,376,378,2202,-1,376,2434,378,-1,2216,2436,2207,-1,2216,2432,2436,-1,2214,2781,2215,-1,2781,2214,2780,-1,2882,2215,2902,-1,363,2215,2882,-1,3649,2908,2909,-1,2908,3649,3622,-1,3650,3626,3625,-1,3650,3648,3626,-1,3624,3611,3623,-1,3611,3624,2895,-1,3105,3649,3104,-1,3105,3622,3649,-1,3626,2926,2925,-1,2926,3626,3648,-1,3628,227,2431,-1};
			return value;
		}
		private int[] getethmoid_Geo_8_94_coordIndex_30()
		{
			int[] value = {365,227,3628,-1,2431,2885,3628,-1,2431,2219,2885,-1,2918,356,355,-1,2918,393,356,-1,377,2430,2226,-1,377,2223,2430,-1,2224,369,3629,-1,374,369,2224,-1,2433,2227,3621,-1,2433,375,2227,-1,2236,2967,2063,-1,2965,2967,2236,-1,2236,2877,2965,-1,2877,2236,3588,-1,606,2241,591,-1,2241,606,607,-1,348,2240,195,-1,348,350,2240,-1,346,2240,350,-1,346,345,2240,-1,322,2242,2244,-1,334,2242,322,-1,2246,3590,2100,-1,3590,2246,2248,-1,334,2082,2242,-1,334,2466,2082,-1,2787,2423,309,-1,2787,2245,2423,-1,311,2788,312,-1,301,2788,311,-1,2786,307,298,-1,2786,2252,307,-1,2252,343,2189,-1,2252,2786,343,-1,2875,323,2876,-1,2875,324,323,-1,160,217,216,-1,217,160,131,-1,2409,60,22,-1,60,2409,182,-1,3634,2832,3632,-1,3640,2832,3634,-1,54,2868,190,-1,54,55,2868,-1,2259,2577,2260,-1,2577,2259,278,-1,122,109,12,-1,109,122,180,-1,2853,2417,2840,-1,2853,2418,2417,-1,186,291,143,-1,186,2297,291,-1,2262,276,278,-1,276,2262,2257,-1,1402,2266,292,-1,2266,1402,2267,-1,2218,251,253,-1,2190,251,2218,-1,243,2856,241,-1,2856,243,2316,-1,2807,239,159,-1,2855,239,2807,-1,258,157,156,-1,258,2295,157,-1,215,2862,2414,-1,2399,2862,215,-1,3501,238,2414,-1,3501,3500,238,-1,2865,1764,1219,-1,2796,1764,2865,-1,99,2395,100,-1,118,2395,99,-1,221,2419,2860,-1,2294,2419,221,-1,198,2277,2279,-1,2288,2277,198,-1,228,2281,2290,-1,2282,2281,228,-1,2220,2797,2221,-1,224,2797,2220,-1,2866,287,286,-1,2866,2398,287,-1,2803,2419,2300,-1,2419,2803,2845,-1,2280,2290,2281,-1,2280,2278,2290,-1,3633,241,3635,-1,242,241,3633,-1,270,3634,3632,-1,270,93,3634,-1,2307,2804,175,-1,2307,367,2804,-1,154,2311,173,-1,154,153,2311,-1,2793,162,168,-1,162,2793,2271,-1,175,2309,2405,-1,176,2309,175,-1,2311,2403,173,-1,2310,2403,2311,-1,2315,170,2316,-1,2790,170,2315,-1,2272,168,167,-1,2793,168,2272,-1,123,3631,2789,-1,123,2871,3631,-1,3635,2411,3633,-1,199,2411,3635,-1,2798,133,2400,-1,2413,133,2798,-1,2792,128,289,-1,2792,129,128,-1,177,2808,108,-1,177,2298,2808,-1,3644,268,267,-1,268,3644,3636,-1,2803,2394,2811,-1,2803,2406,2394,-1,2843,119,181,-1,119,2843,2322,-1,2327,3644,2328,-1,103,3644,2327,-1,102,2324,2842,-1,104,2324,102,-1,103,3636,3644,-1,3636,103,2802,-1,2302,90,2308,-1,2302,2393,90,-1,2390,2368,2344,-1,2368,2390,2332,-1,3637,66,65,-1,3637,2836,66,-1,2366,2367,2334,-1,2366,2829,2367,-1,82,2346,2828,-1,2346,82,81,-1,2390,78,2389,-1,2390,2350,78,-1,2333,3637,2819,-1,2333,2837,3637,-1,79,3641,77,-1,79,2823,3641,-1,77,3639,3638,-1,77,3641,3639,-1,2872,2827,3640,-1,2872,2825,2827,-1,2362,2382,2353,-1,2362,51,2382,-1,3643,35,2369,-1,3643,2817,35,-1,2835,56,2834,-1,2835,57,56,-1,2833,3641,2361,-1,3639,3641,2833,-1,3642,2,2870,-1,2,3642,0,-1,2818,2373,2820,-1,2373,2818,2374,-1,2762,3,5,-1,3,2762,3647,-1,4,2375,1,-1,2375,4,2378,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getethmoid_Coord_9_94_point_1()
		{
			double[] value = {-.0199,57.69641,2.13369,-.02442,57.62037,2.20924,-.01983,57.71733,2.15678,-.01888,57.71954,2.27586,-.02461,57.66131,2.2896,-.02015,57.70207,2.34669,-.0208,57.69128,2.3564,-.03973,57.5934,2.35544,-.05901,57.66414,2.35145,0.0,57.75625,2.34451,-.0463,57.65886,2.36689,0.0,57.67272,2.39451,-.04171,57.11411,1.48368,0.0,57.14092,1.46941,0.0,57.08708,1.48796,-.03168,57.16834,1.55817,-.01428,57.14836,1.52292,-.02587,56.94582,1.52121,-.06251,57.43324,2.37314,-.05405,57.42175,2.3205,-.06287,57.32239,2.36508,-.04502,57.42101,2.27129,-.06374,57.40889,2.19412,-.04132,57.24239,2.2589,-.05695,57.21581,1.6361,-.03346,56.91948,1.63225,-.03745,57.04562,1.71386,-.02318,57.26692,2.52738,-.0223,57.27656,2.52958,-.0197,57.3008,2.49809,-.02248,57.33775,2.54074,-.01577,57.32851,2.54134,-.00001,57.40783,2.57173,-.00025,57.29659,2.56307,-.02444,57.21639,2.51583,-.02455,57.20434,2.51305,-.01924,56.64882,1.91725,-.01697,56.65013,1.92852,-.01771,56.65684,1.92211,0.0,56.65876,2.0164,0.0,56.66293,2.03317,-.01593,56.67606,2.0752,0.0,56.66929,2.16308,0.0,56.66967,2.17252,0.0,56.66725,2.18799,0.0,56.66637,2.20648,-.01112,56.66807,2.10412,-.03718,57.42103,2.51388,-0.0,57.42062,2.56911,-.03839,57.31701,2.47664,-.02753,57.27431,2.45094,-.03077,57.21722,2.41457,-.03765,57.05517,1.72782,-.0284,57.08876,1.79226,-.06888,57.299,1.72556,-.06759,57.30529,1.79916,-.02902,57.10318,1.86239,-.03291,57.10956,1.9119,-.03602,57.19686,2.19538,-.03933,57.21613,2.23033,-.07539,57.39728,2.15953,-.05532,57.2048,1.62182,0.0,56.63954,1.9497,-.02284,56.71743,2.04068,-.01664,56.69307,2.05577,-.02416,56.6929,2.10307,-.03024,56.72931,2.10201,-.01656,56.67954,2.10024,-.01066,56.6601,1.98485,0.0,56.66736,2.13084,-.01338,56.68185,2.04114,-.01039,56.66324,1.99592,0.0,57.01745,1.48688,0.0,56.91409,1.52561,-.0202,56.72813,1.63992,-.02596,56.85004,1.54332,0.0,56.80812,1.60823,-.03137,56.75181,2.28921,-.02698,56.76727,2.35292,-.02722,56.77561,2.34477,-.02052,56.6685,1.98965,-.02587,56.84056,2.4022,-.01879,56.94858,2.4161,-.02952,56.8526,2.40628,-.0125,56.67092,2.09087,-.26838,56.74474,1.52579,-.28641,56.74586,1.55268,-.28975,56.74744,1.55214,-.25629,56.76331,1.55762,-.20414,56.8469,1.55788,-.20205,56.8577,1.58612,-.24449,56.77708,1.52824,-.26641,56.74847,1.5211,-.1064,57.20578,2.01006,-.0958,57.13634,2.03494,-.0852,57.08418,1.98715,-.21761,56.84235,1.52073,-.27062,56.86664,1.45735,-.16775,56.88808,1.54675,-.11527,57.08257,1.65516};
			return value;
		}
		private double[] getethmoid_Coord_9_94_point_2()
		{
			double[] value = {-.10595,56.98103,1.67921,-.10868,57.06747,1.63482,-.10908,57.02388,1.7131,-.10054,57.0376,1.75511,-.11079,57.03589,1.70885,-.12471,57.00281,1.6721,-.11789,56.94642,1.65835,-.14214,56.98169,1.62402,-.12803,56.93133,1.6362,-.09028,57.0061,1.54846,-.10014,57.00352,1.50985,-.16919,56.89735,1.56789,-.15482,56.95006,1.58479,-.17558,56.89744,1.57831,-.19086,57.01526,1.43689,-.04266,57.13423,1.46312,-.09491,57.02657,1.48846,-.12873,57.23124,1.66066,-.1107,57.1086,1.6895,-.14063,56.92741,1.58877,-.05009,57.13646,1.52337,-.05637,57.11642,1.52423,-.04663,57.10797,1.51679,-.11271,57.17927,2.19382,-.11329,57.17825,2.13399,-.11307,57.18592,2.13065,-.08531,57.08184,1.99057,-.09811,56.74814,1.7635,-.10947,56.74169,1.72942,-.11544,56.79982,1.70587,-.13178,57.23657,2.1023,-.12915,57.08171,2.0985,-.14576,57.25026,2.04951,-.1224,56.92861,1.73044,-.1301,56.92052,1.71572,-.12889,56.91918,1.74442,-.17283,56.91511,1.61653,-.16769,56.98955,1.58994,-.18416,56.97953,1.58215,-.135,56.92911,1.68259,-.12967,57.02033,1.66274,-.12916,57.01765,1.6532,-.11621,57.18372,2.2725,-.10332,57.20197,2.35114,-.10699,57.13316,2.28999,-.11312,57.0959,2.15271,-.13106,57.08228,1.62785,-.15779,57.00179,1.67255,-.15708,56.9984,1.66568,-.16566,57.04067,1.56509,-.17996,56.96514,1.60162,-.19139,56.95857,1.59779,-.16747,56.97426,1.6114,-.15124,57.05165,1.58102,-.13506,57.0662,1.6006,-.13639,57.10703,1.6565,-.1421,57.01172,1.70879,-.14736,57.00531,1.6877,-.14627,57.06919,1.98014,-.13949,57.26008,1.992,-.14177,57.07502,2.04621,-.19684,56.8824,1.59029,-.21732,56.85749,1.59246,-.21351,56.85027,1.58513,-.20563,56.85979,1.58367,-.25815,56.76112,1.5623,-.19333,57.02605,1.56217,-.19543,57.02715,1.56344,-.20585,57.0107,1.55767,-.13326,57.10853,1.65839,-.13822,57.1449,1.69046,-.15743,56.88319,1.71022,-.15995,56.88388,1.7063,-.13404,57.06564,1.6001,-.13041,57.08163,1.62583,-.15865,56.90471,1.63573,-.17337,56.89621,1.61695,-.12925,56.92592,1.63794,-.11905,56.94078,1.65964,-.13531,56.91523,1.65488,-.08907,57.01656,1.57177,-.11694,56.94724,1.63209,-.10299,57.39706,2.15943,-.11342,57.27232,2.20216,-.11501,57.26594,2.16398,-.07404,57.42216,2.27657,-.10395,57.31061,2.31235,-.11539,57.28506,2.23521,-.18299,56.90016,1.61917,-.10414,57.14022,1.74965,-.10601,57.29484,1.72513,-.17597,56.88571,1.69495,-.1699,56.89629,1.68633,-.15796,56.99791,1.66033,-.22646,56.83316,1.60496,-.25771,56.83272,1.61078,-.27264,56.82094,1.62017,-.11316,56.96558,1.78749,-.11178,56.99791,1.86748,-.09871,57.03173,1.85584};
			return value;
		}
		private double[] getethmoid_Coord_9_94_point_3()
		{
			double[] value = {-.11361,57.12653,2.03609,-.10852,57.10021,1.973,-.11121,57.07974,1.98544,-.10904,56.97231,1.77848,-.12027,56.94332,1.75074,-.11991,57.16606,2.13765,-.12404,56.9224,1.76536,-.12372,56.92196,1.76325,-.10979,56.93561,1.79815,-.12384,57.14591,2.08707,-.12229,57.14627,2.08717,-.11662,57.16492,2.13866,-.10306,57.12686,2.42915,-.08846,57.0792,2.39042,-.10569,57.1543,2.36951,-.08326,56.89305,2.10752,-.12054,56.98787,2.07245,-.10866,57.00353,2.12385,-.12255,56.95733,2.00992,-.098,56.87926,2.04022,-.10082,56.87383,1.97236,-.12477,56.91764,1.74391,-.17819,56.86055,1.68834,-.17734,56.874,1.69399,-.15139,56.86468,1.6983,-.23106,56.89386,1.7032,-.22862,56.88791,1.7235,-.2555,56.85677,1.72866,-.09223,57.06508,1.99676,-.10108,56.98988,1.93508,-.09096,57.00585,1.932,-.11118,57.1526,2.0844,-.11071,57.16099,2.08001,-.09413,56.94306,2.35464,-.09563,57.00475,2.41341,-.10744,56.87665,2.37312,-.08023,56.97689,2.30264,-.07982,57.00939,2.33078,-.09163,56.81144,2.06256,-.12724,57.26089,1.99319,-.1322,57.2493,2.04925,-.12041,57.23824,1.80207,-.12299,57.2498,1.85843,-.12778,57.2365,1.80117,-.30072,56.81021,1.65838,-.23081,56.81325,1.62471,-.10199,56.81167,1.7592,-.1194,56.82511,1.68801,-.11927,56.83906,1.71632,-.18441,56.90577,1.71345,-.20865,56.90794,1.71642,-.19373,56.91833,1.68412,-.19095,56.92035,1.68009,-.18886,56.9118,1.68366,-.2551,56.90584,1.65906,-.24265,56.90881,1.67276,-.2547,56.89214,1.65569,-.13697,56.8582,1.73902,-.1402,56.86852,1.76587,-.02207,57.57765,2.12945,0.0,57.60484,2.11457,0.0,57.5037,2.06132,-.04645,57.41229,2.18542,-.02522,57.39305,2.08111,-.15507,57.42746,2.15616,-.15239,57.34872,2.0176,-.1531,57.38956,2.09021,-.09743,56.96145,1.76088,-.0895,56.97684,1.78795,-.09943,56.94936,1.79849,-.11393,57.23756,2.05743,-.10943,57.16538,2.07812,-.12746,57.36666,2.06772,-.11028,57.38785,2.12215,-.07209,57.61761,2.36325,-.04663,57.59828,2.39251,-.03212,57.51677,2.44855,-.05693,57.54219,2.41667,-.07098,57.52746,2.43493,-.12418,57.19827,1.63284,-.11664,57.16313,1.6011,-.08828,56.71211,1.89741,-.08812,56.77537,1.86363,-.08958,56.73039,1.96744,-.1385,56.93318,1.94738,-.14731,57.04794,1.91562,-.09022,57.04156,2.23788,-.09027,57.02055,2.18383,-.10641,56.71457,1.74039,-.13143,56.71823,1.65713,-.09511,57.0826,2.30746,-.10402,57.21925,2.39809,-.06172,57.4238,2.26322,-.17704,57.44678,2.19606,-.18749,57.00776,1.44161,-.15328,57.42887,2.16396,-.1561,57.43184,2.17056,-.09371,57.56284,2.39854,-.26858,56.86079,1.59349,-.26937,56.8609,1.59363};
			return value;
		}
		private double[] getethmoid_Coord_9_94_point_4()
		{
			double[] value = {-.27078,56.85766,1.59249,-.27806,56.85652,1.60165,-.27776,56.8571,1.60079,-.27691,56.85955,1.60158,-.27337,56.86438,1.60232,-.27491,56.86262,1.60269,-.27517,56.86257,1.60192,-.2693,56.86378,1.59693,-.2712,56.86527,1.60049,-.26987,56.86388,1.59704,-.27082,56.83958,1.5871,-.28332,56.85507,1.6076,-.28719,56.85674,1.61402,-.28774,56.88597,1.62425,-.27856,56.86184,1.60684,-.2742,56.86407,1.60338,-.26961,56.85768,1.59216,-.26802,56.85616,1.58932,-.26443,56.86178,1.5897,-.27395,56.86442,1.60202,-.27686,56.86743,1.6012,-.27423,56.86763,1.60127,-.27014,56.86479,1.59408,-.2737,56.85476,1.59384,-.27286,56.85523,1.59314,-.27662,56.86337,1.59184,-.27691,56.85603,1.59902,-.27563,56.8555,1.59696,-.28167,56.86408,1.59463,-.2734,56.88605,1.60343,-.26981,56.88596,1.60293,-.26695,56.88534,1.60116,-.2556,56.91071,1.60348,-.24967,56.90818,1.60082,-.26672,56.88329,1.59558,-.26579,56.88436,1.59845,-.24728,56.90605,1.59636,-.28014,56.86682,1.6004,-.28256,56.86595,1.59902,-.27886,56.88481,1.60094,-.27668,56.88562,1.60269,-.26624,56.91349,1.59952,-.26149,56.91238,1.60328,-.25413,56.8632,1.58777,-.2619,56.85918,1.58517,-.24288,56.84006,1.58103,-.23588,56.85,1.58136,-.228,56.83962,1.56949,-.23572,56.85838,1.59612,-.2388,56.86165,1.59012,-.23588,56.8535,1.584,-.26078,56.83157,1.58497,-.26545,56.83357,1.58536,-.24566,56.79702,1.60154,-.25511,56.74052,1.54057,-.20439,56.77121,1.57081,-.21414,56.72894,1.5548,-.26214,56.95043,1.67002,-.24785,56.95776,1.66584,-.26088,56.95522,1.67622,-.2623,56.92905,1.66797,-.26374,56.92502,1.66208,-.26267,56.94829,1.6727,-.26315,56.94747,1.66973,-.26138,56.95011,1.67337,-.27608,56.82921,1.68398,-.27619,56.86082,1.65427,-.14201,56.92593,1.65642,-.13525,56.91754,1.68544,-.2675,56.93587,1.66678,-.27606,56.94046,1.67373,-.26729,56.93512,1.66831,-.26573,56.94192,1.66488,-.2704,56.94342,1.66763,-.26632,56.93946,1.66472,-.26421,56.93926,1.67508,-.27283,56.94513,1.67927,-.26408,56.94244,1.67621,-.27578,56.94605,1.67944,-.27657,56.94439,1.67741,-.28412,56.95723,1.6797,-.266,56.88873,1.64698,-.25649,56.86833,1.66386,-.15551,56.89619,1.66288,-.23568,56.88362,1.60027,-.23701,56.8991,1.60672,-.19073,56.93829,1.67479,-.19164,56.93088,1.65554,-.29379,56.90378,1.6306,-.25182,56.91497,1.61784,-.2683,56.92691,1.635,-.29378,56.91063,1.63962,-.27715,56.92711,1.64849,-.20273,56.72348,1.55912,-.21157,56.64184,1.49014,-.39409,56.83804,1.65355,-.3961,56.83921,1.65585,-.39626,56.83916,1.65565,-.39966,56.83792,1.65337,-.39954,56.83921,1.65435};
			return value;
		}
		private double[] getethmoid_Coord_9_94_point_5()
		{
			double[] value = {-.39902,56.8373,1.65754,-.39676,56.83807,1.64783,-.3956,56.84141,1.64637,-.39665,56.84198,1.64526,-.39522,56.83899,1.64922,-.39555,56.84289,1.64955,-.39518,56.84177,1.648,-.39775,56.84144,1.65252,-.39784,56.8456,1.6503,-.39656,56.84435,1.65044,-.40085,56.84207,1.65316,-.39931,56.84586,1.64754,-.39889,56.84618,1.6492,-.31173,56.77728,1.57837,-.31204,56.77721,1.57821,-.31174,56.77655,1.57784,-.31293,56.77862,1.5796,-.31321,56.77841,1.57938,-.31237,56.77785,1.57859,-.31498,56.77438,1.57948,-.31506,56.77479,1.57934,-.31705,56.77535,1.58079,-.31813,56.77663,1.58191,-.31826,56.77679,1.58239,-.31808,56.77645,1.58214,-.30937,56.77589,1.57692,-.31066,56.77457,1.57723,-.31729,56.78112,1.58315,-.31571,56.78265,1.58264,-.34582,56.8041,1.60614,-.31288,56.77738,1.57724,-.31111,56.77702,1.57787,-.31132,56.7766,1.57793,-.35169,56.80898,1.54602,-.31668,56.77235,1.57569,-.3237,56.77856,1.58194,-.26726,56.79662,1.49492,-.34927,56.79815,1.60465,-.23891,56.96874,1.43864,-.24836,56.97421,1.43565,-.2898,56.76427,1.48794,-.39395,56.83812,1.65375,-.38404,56.8315,1.64379,-.40197,56.81842,1.67569,-.29284,56.7353,1.56239,-.27988,56.6798,1.49167,-.32475,56.88175,1.4702,-.27844,56.8751,1.45171,-.33348,56.88523,1.47823,-.41264,56.85368,1.60433,-.31966,56.77827,1.58063,-.31977,56.77686,1.58021,-.31564,56.7841,1.56281,-.3186,56.7755,1.57901,-.31488,56.78171,1.56176,-.30761,56.7825,1.56126,-.3131,56.77613,1.57577,-.30695,56.78363,1.56162,-.30694,56.78642,1.56271,-.30777,56.78743,1.5632,-.30457,56.79254,1.54754,-.30676,56.78515,1.56219,-.3018,56.78989,1.54609,-.31463,56.78657,1.5637,-.31588,56.79023,1.54841,-.29977,56.80559,1.5318,-.30043,56.8046,1.52968,-.29911,56.79168,1.53492,-.31228,56.79939,1.54072,-.31817,56.79836,1.53932,-.31194,56.80146,1.5398,-.29992,56.80794,1.53384,-.30016,56.80883,1.53202,-.32238,56.80262,1.53284,-.32922,56.80719,1.53636,-.32257,56.80045,1.53704,-.31852,56.8,1.53961,-.31691,56.80293,1.54459,-.32902,56.80277,1.54091,-.33879,56.81513,1.55322,-.33388,56.80896,1.5561,-.30824,56.80636,1.54174,-.32427,56.80704,1.55645,-.30238,56.81766,1.53327,-.30003,56.8133,1.53414,-.28686,56.85627,1.53883,-.32265,56.81267,1.53276,-.3346,56.84347,1.54087,-.20999,56.79067,1.61846,-.15115,56.79698,1.66336,-.20256,56.83364,1.67987,-.1552,56.81455,1.73121,-.19048,56.85251,1.76962,-.30072,56.94593,1.68784,-.30921,56.94284,1.69865,-.2838,56.9636,1.72368,-.25818,56.87026,1.56196,-.25512,56.86209,1.53868,-.2705,56.88665,1.54017,-.25944,56.85683,1.52153};
			return value;
		}
		private double[] getethmoid_Coord_9_94_point_6()
		{
			double[] value = {-.25435,56.8529,1.5146,-.25906,56.87769,1.51027,-.35422,56.82533,1.57514,-.34303,56.82614,1.54961,-.36853,56.85733,1.60966,-.36345,56.87471,1.6049,-.36122,56.91778,1.63374,-.34088,56.87791,1.5742,-.31733,56.89433,1.56888,-.32563,56.91693,1.5837,-.35557,56.84016,1.57309,-.35081,56.9281,1.61556,-.23351,56.66749,1.57688,-.18271,56.59812,1.5994,-.16176,57.19217,1.99309,-.15721,57.19567,2.02833,-.2096,57.38171,1.98927,-.21104,57.1818,2.14582,-.2201,57.17882,2.13566,-.21116,57.18255,2.14525,-.20845,57.19722,2.16463,-.19926,57.18404,2.14669,-.18514,57.20034,2.14852,-.18793,57.18356,2.14088,-.1797,57.1812,2.12967,-.16236,57.20256,2.11844,-.17688,57.17767,2.11579,-.18074,57.17369,2.10193,-.19016,57.17063,2.09207,-.22251,57.17176,2.1032,-.23966,57.17602,2.07343,-.24566,57.17337,2.13636,-.19942,57.18293,2.14729,-.2457,57.16032,2.23289,-.26,57.17186,2.10306,-.26177,57.17158,2.16121,-.17433,57.20164,2.13364,-.18988,57.22347,2.17269,-.18125,57.23344,2.17265,-.17015,57.2499,2.17777,-.16167,57.26908,2.18174,-.14358,57.20488,2.09759,-.26549,57.17323,2.28808,-.24612,57.19281,2.28672,-.2266,57.18572,2.14892,-.27206,57.10501,1.59627,-.27148,57.10645,1.58068,-.2652,57.12076,1.5996,-.25959,57.10704,1.60332,-.25855,57.09511,1.60053,-.27288,57.0939,1.59508,-.26685,57.07551,1.54672,-.28001,57.08825,1.57895,-.27348,57.06837,1.54771,-.24994,57.12803,1.60286,-.24304,57.12898,1.60748,-.25596,57.1248,1.60816,-.25982,57.12452,1.59592,-.29731,56.98507,1.59741,-.29005,56.9841,1.59994,-.26753,56.93634,1.59857,-.27964,57.06798,1.57972,-.28643,57.06435,1.56953,-.2643,57.0687,1.58824,-.24909,56.93542,1.60678,-.26299,56.93431,1.60099,-.24934,56.97793,1.62211,-.25399,56.99547,1.62046,-.28064,57.00191,1.61367,-.24456,57.0495,1.61259,-.21804,57.0496,1.62054,-.21376,57.0981,1.61838,-.19967,57.09615,1.61389,-.202,57.06674,1.60273,-.22891,56.93136,1.59926,-.23414,56.935,1.60492,-.22059,56.96786,1.6152,-.18588,57.07611,1.58801,-.22799,56.96872,1.55917,-.20587,56.97271,1.59396,-.1972,57.02713,1.57916,-.1921,57.05022,1.57226,-.20266,57.05391,1.5408,-.24999,56.95837,1.55352,-.26363,56.9618,1.55011,-.25547,56.93399,1.57571,-.26607,56.93711,1.58784,-.2785,56.96791,1.55851,-.29109,56.97648,1.57677,-.26857,56.93794,1.59594,-.26756,56.82889,1.57794,-.27051,56.83279,1.57977,-.26631,56.83302,1.58241,-.23596,56.98591,1.52914,-.23465,56.98525,1.52172,-.22967,56.99281,1.52516,-.22695,56.9843,1.51913,-.21866,56.99188,1.52553,-.20451,56.98395,1.53012,-.20524,56.99418,1.54058};
			return value;
		}
		private double[] getethmoid_Coord_9_94_point_7()
		{
			double[] value = {-.20811,56.99254,1.53211,-.23024,56.9857,1.53842,-.22362,56.99335,1.53081,-.21596,56.99402,1.5371,-.27333,56.82956,1.57727,-.27392,56.83154,1.57032,-.27126,56.8428,1.57939,-.26999,56.84811,1.58491,-.26576,56.85409,1.57571,-.24958,56.87378,1.57901,-.25998,56.88836,1.56177,-.20639,56.98504,1.5489,-.19915,56.98486,1.54651,-.19662,56.96691,1.54938,-.20645,56.96645,1.55451,-.29141,56.96507,1.67271,-.29117,56.98677,1.68638,-.28712,56.96943,1.67998,-.23922,56.96771,1.65531,-.23288,56.97196,1.66011,-.22476,56.98266,1.65389,-.19342,57.02441,1.65753,-.2292,57.01264,1.63504,-.23686,56.97523,1.64547,-.27797,56.96507,1.6607,-.30034,56.96958,1.67019,-.27