package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> MetadataSets demonstrating sample medical ontology integration with X3D scene graph. </p>
 <p> Related links: Catalog page <a href="../../../Medical/MedicalMetadataIndex.html" target="_blank">MedicalMetadata</a>,  source <a href="../../../Medical/MedicalMetadata.java">MedicalMetadata.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/MedicalMetadata.x3d">MedicalMetadata.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> MetadataSets demonstrating sample medical ontology integration with X3D scene graph. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Nick Polys and Andrew Ray </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 1 November 2007 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.web3d.org/x3d/workgroups/medical" target="_blank">https://www.web3d.org/x3d/workgroups/medical</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> medical metadata </td>
		</tr>
		<tr style="color:burntorange">
			<td style="text-align:right; vertical-align: text-top;"> <i> warning </i> </td>
			<td> incomplete development </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/MedicalMetadata.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/MedicalMetadata.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> FluxStudio </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> (VT application for metadata generation) </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Nick Polys and Andrew Ray
 */

public class MedicalMetadata
{
	/** Default constructor to create this object. */
	public MedicalMetadata ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_1)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("MedicalMetadata.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("MetadataSets demonstrating sample medical ontology integration with X3D scene graph."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Nick Polys and Andrew Ray"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("1 November 2007"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.web3d.org/x3d/workgroups/medical"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("medical metadata"))
    .addMeta(new meta().setName(meta.NAME_WARNING    ).setContent("incomplete development"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/MedicalMetadata.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("FluxStudio"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("(VT application for metadata generation)"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("MedicalMetadata.x3d"))
    .addChild(new Transform("Body")
      .addChild(new Transform("BodyShape")
        .addChild(new Switch("SkinSwitch").setWhichChoice(0)
          .addChild(new Inline().setUrl(new String[] {"BodySkinIndexedFaceSetNIST.x3d","https://www.web3d.org/x3d/content/examples/Basic/Medical/BodySkinIndexedFaceSetNIST.x3d","BodySkinIndexedFaceSetNIST.wrl","https://www.web3d.org/x3d/content/examples/Basic/Medical/BodySkinIndexedFaceSetNIST.wrl"}))
          .addChild(new Group())))
      .addChild(new Group("BodyParts")
        .addChild(new Group("RespiratorySystem")
          .setMetadata(new MetadataSet("m7334").setName("Upper_lobe_of_lung").setReference("FMA")
            .setMetadata(new MetadataString().setName("has inherent 3-D shape").setValue(new String[] {"true"}))
            .setMetadata(new MetadataSet().setName("regional part").setReference("FMA")
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Bronchopulmonary_segment"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Bronchopulmonary_segment"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Bronchopulmonary_segment"})))
            .setMetadata(new MetadataString().setName("regional part of").setValue(new String[] {"blank"}))
            .setMetadata(new MetadataSet().setName("constitutional part").setReference("FMA")
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Parenchyma_of_lobe_of_lung"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Lobar_bronchial_tree"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Pleura_of_lobe_of_lung"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Neural_network_of_lobe_of_lung"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Vasculature_of_lobe_of_lung"})))
            .setMetadata(new MetadataString().setName("dimension").setValue(new String[] {"3-dimension"}))
            .setMetadata(new MetadataString().setName("has dimension").setValue(new String[] {"true"}))
            .setMetadata(new MetadataString().setName("has boundary").setValue(new String[] {"true"}))
            .setMetadata(new MetadataInteger().setName("FMAID").setValue(new int[] {7334}))
            .setMetadata(new MetadataString().setName("Preferred name").setValue(new String[] {"Upper_lobe_of_lung"}))
            .setMetadata(new MetadataSet().setName("Synonym").setReference("FMA")
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Lobus_superior"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Superior_lobe_of_lung"})))
            .setMetadata(new MetadataSet().setName("part").setReference("FMA")
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Parenchyma_of_lobe_of_lung"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Lobar_bronchial_tree"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Pleura_of_lobe_of_lung"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Bronchopulmonary_segment"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Bronchopulmonary_segment"}))
              .setMetadata(new MetadataString().setName("SetName").setReference("FMA").setValue(new String[] {"Bronchopulmonary_segment"})))
            .setMetadata(new MetadataString().setName("part of").setValue(new String[] {"Lobular_organ"}))
            .setMetadata(new MetadataString().setName("Non-English equivalent").setValue(new String[] {"Lobus_superior_pulmonis"}))
            .setMetadata(new MetadataString().setName("constitutional part of").setValue(new String[] {"blank"})))
          .addChild(new Transform("RespiratoryShape").setRotation(-.995,.102,0.0,3.142).setScale(3.96357,4.0229,6.98914).setTranslation(-9.65146,62.0249,-3.89403)
            .addChild(new Shape("airway")
              .setAppearance(new Appearance()
                .setMaterial(new Material("White").setAmbientIntensity(0.200).setDiffuseColor(1.0,1.0,1.0).setShininess(0.200)))
              .setGeometry(new IndexedFaceSet("airway_Geo").setDEF("airway_Geo").setCreaseAngle(0.524).setCoordIndex(getairway_Geo_8_53_coordIndex())
                .setCoord(new Coordinate("airway_Coord").setPoint(getairway_Coord_9_53_point())))))
          .addChild(new Group("RespiratoryParts")))
        .addChild(new Group("DigestiveSystem")
          .addChild(new Group("Liver")
            .setMetadata(new MetadataSet("m123654").setName("FMA-XML").setReference("FMA")
              .setMetadata(new MetadataInteger().setName("frame").setValue(new int[] {26212}))
              .setMetadata(new MetadataInteger().setName("frame_type").setValue(new int[] {6}))
              .setMetadata(new MetadataInteger().setName("slot").setValue(new int[] {2002}))
              .setMetadata(new MetadataInteger().setName("facet").setValue(new int[] {0}))
              .setMetadata(new MetadataInteger().setName("is_template").setValue(new int[] {0}))
              .setMetadata(new MetadataInteger().setName("value_index").setValue(new int[] {0}))
              .setMetadata(new MetadataInteger().setName("value_type").setValue(new int[] {3}))
              .setMetadata(new MetadataString().setName("short_value").setValue(new String[] {"Liver"})))
            .addChild(new Group("LiverParts"))
            .addChild(new Transform("LiverShape").setRotation(.964,.197,-.18,1.86).setScale(2.99435,2.25363,4.39602).setTranslation(10.6182,24.9426,-4.66205)
              .addChild(new Shape("liver")
                .setAppearance(new Appearance()
                  .setMaterial(new Material("Red").setAmbientIntensity(0.200).setDiffuseColor(1.0,0.0,0.0).setShininess(0.200)))
                .setGeometry(new IndexedFaceSet("GeoSculptedSurface1").setDEF("GeoSculptedSurface1").setCreaseAngle(1.047).setCoordIndex(getGeoSculptedSurface1_9_71_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_71_point()))))))
          .addChild(new Group("Colon")
            .setMetadata(new MetadataSet("m123456").setName("SNOMED-XML").setReference("SNOMED")
              .setMetadata(new MetadataSet().setName("concepts")
                .setMetadata(new MetadataSet().setName("Concept").setReference("SNOMED")
                  .setMetadata(new MetadataString().setName("conceptId").setValue(new String[] {"369445005"}))
                  .setMetadata(new MetadataString().setName("conceptStatus").setValue(new String[] {"0"}))
                  .setMetadata(new MetadataString().setName("fullySpecfiedName").setValue(new String[] {"Chronic proctocolitis (disorder)"}))
                  .setMetadata(new MetadataString().setName("ctv3id").setValue(new String[] {"XUU7a"}))
                  .setMetadata(new MetadataString().setName("snomedId").setValue(new String[] {"D5-45285"}))
                  .setMetadata(new MetadataString().setName("isPrimitive").setValue(new String[] {"1"}))
                  .setMetadata(new MetadataSet().setName("Description").setReference("SNOMED")
                    .setMetadata(new MetadataString().setName("descriptionId").setValue(new String[] {"774149015"}))
                    .setMetadata(new MetadataString().setName("term").setValue(new String[] {"Chronic proctocolitis (disorder)"}))
                    .setMetadata(new MetadataString().setName("descriptionType").setValue(new String[] {"3"}))
                    .setMetadata(new MetadataString().setName("initialCapitalStatus").setValue(new String[] {"0"}))
                    .setMetadata(new MetadataString().setName("languageCode").setValue(new String[] {"en"}))
                    .setMetadata(new MetadataString().setName("descriptionStatus").setValue(new String[] {"0"})))
                  .setMetadata(new MetadataSet().setName("History").setReference("SNOMED")
                    .setMetadata(new MetadataString().setName("releaseVersion").setValue(new String[] {"20020131"}))
                    .setMetadata(new MetadataString().setName("changeType").setValue(new String[] {"0"}))
                    .setMetadata(new MetadataString().setName("reason").setValue(new String[] {"null"})))
                  .setMetadata(new MetadataSet().setName("relationshipSet")
                    .setMetadata(new MetadataSet().setName("relationship").setReference("SNOMED")
                      .setMetadata(new MetadataString().setName("relationshipId").setValue(new String[] {"2398318025"}))
                      .setMetadata(new MetadataString().setName("relationshipType").setValue(new String[] {"246100006"}))
                      .setMetadata(new MetadataString().setName("conceptId2").setValue(new String[] {"385315009"}))
                      .setMetadata(new MetadataString().setName("characteristicType").setValue(new String[] {"1"}))
                      .setMetadata(new MetadataString().setName("refinability").setValue(new String[] {"1"})))
                    .setMetadata(new MetadataSet().setName("relationship").setReference("SNOMED")
                      .setMetadata(new MetadataString().setName("relationshipId").setValue(new String[] {"2398319022"}))
                      .setMetadata(new MetadataString().setName("relationshipType").setValue(new String[] {"246100006"}))
                      .setMetadata(new MetadataString().setName("conceptId2").setValue(new String[] {"61751001"}))
                      .setMetadata(new MetadataString().setName("characteristicType").setValue(new String[] {"1"}))
                      .setMetadata(new MetadataString().setName("refinability").setValue(new String[] {"1"})))
                    .setMetadata(new MetadataSet().setName("relationshipGroup")
                      .setMetadata(new MetadataSet().setName("relationship").setReference("SNOMED")
                        .setMetadata(new MetadataString().setName("relationshipId").setValue(new String[] {"1082140022"}))
                        .setMetadata(new MetadataString().setName("relationshipType").setValue(new String[] {"116676008"}))
                        .setMetadata(new MetadataString().setName("conceptId2").setValue(new String[] {"23583003"}))
                        .setMetadata(new MetadataString().setName("characteristicType").setValue(new String[] {"0"}))
                        .setMetadata(new MetadataString().setName("refinability").setValue(new String[] {"2"})))
                      .setMetadata(new MetadataSet().setName("relationship").setReference("SNOMED")
                        .setMetadata(new MetadataString().setName("relationshipId").setValue(new String[] {"1082141021"}))
                        .setMetadata(new MetadataString().setName("relationshipType").setValue(new String[] {"363698007"}))
                        .setMetadata(new MetadataString().setName("conceptId2").setValue(new String[] {"34402009"}))
                        .setMetadata(new MetadataString().setName("characteristicType").setValue(new String[] {"0"}))
                        .setMetadata(new MetadataString().setName("refinability").setValue(new String[] {"2"})))
                      .addComments(" End relationshipGroup tag "))
                    .addComments(" End relationshipSet tag "))
                  .addComments(" End concept tag "))
                .addComments(" End concepts tag "))
              .addComments(" Final closing tag "))
            .addChild(new Group("ColonParts"))
            .addChild(new Transform("ColonShape").setRotation(.614,-.789,0.0,.222).setTranslation(-.14727,5.15789,-8.63757)
              .addChild(new Shape("colon")
                .setAppearance(new Appearance()
                  .setMaterial(new Material("Shiny_Rust").setAmbientIntensity(0.200).setDiffuseColor(.69,.47,.46).setShininess(0.100).setSpecularColor(.69,.47,.46)))
                .setGeometry(new IndexedFaceSet("GeoSculptedSurface2").setDEF("GeoSculptedSurface2").setCreaseAngle(1.047).setCoordIndex(getGeoSculptedSurface2_9_125_coordIndex())
                  .setCoord(new Coordinate().setPoint(getCoordinate_10_125_point())))))))))
    .addChild(new Viewpoint().setPosition(0.0,40.0,145.0)));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getairway_Geo_8_53_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,2,3,-1,0,3,4,-1,0,4,5,-1,0,5,6,-1,0,6,7,-1,0,7,8,-1,0,8,9,-1,0,9,10,-1,0,10,11,-1,0,11,12,-1,0,12,13,-1,0,13,14,-1,0,14,15,-1,3,2,16,-1,3,16,17,-1,2,1,18,-1,2,18,16,-1,1,0,19,-1,1,19,18,-1,15,20,21,-1,15,21,22,-1,15,22,19,-1,15,19,0,-1,14,23,24,-1,14,24,20,-1,14,20,15,-1,26,23,14,-1,26,14,13,-1,26,13,25,-1,28,25,13,-1,28,13,12,-1,28,12,27,-1,30,27,12,-1,30,12,11,-1,30,11,29,-1,33,29,11,-1,33,11,10,-1,33,10,31,-1,33,31,32,-1,10,9,34,-1,10,34,35,-1,10,35,36,-1,10,36,37,-1,10,37,38,-1,10,38,39,-1,10,39,40,-1,10,40,31,-1,9,8,41,-1,9,41,42,-1,9,42,43,-1,9,43,44,-1,9,44,45,-1,9,45,46,-1,9,46,47,-1,9,47,34,-1,7,48,49,-1,7,49,50,-1,7,50,41,-1,7,41,8,-1,51,52,48,-1,51,48,7,-1,51,7,6,-1,51,6,53,-1,6,5,54,-1,6,54,53,-1,5,4,55,-1,5,55,54,-1,4,3,17,-1,4,17,55,-1,56,57,58,-1,56,58,59,-1,60,58,57,-1,60,57,61,-1,62,63,64,-1,65,63,62,-1,65,62,66,-1,67,68,69,-1,63,68,67,-1,63,67,64,-1,70,71,72,-1,68,71,70,-1,68,70,69,-1,73,74,75,-1,74,73,76,-1,74,76,72,-1,74,72,71,-1,77,78,79,-1,74,78,77,-1,74,77,75,-1,78,80,81,-1,78,81,79,-1,82,83,84,-1,83,82,85,-1,83,85,86,-1,83,86,87,-1,88,89,90,-1,89,88,91,-1,89,91,84,-1,89,84,83,-1,92,93,94,-1,89,93,92,-1,89,92,90,-1,95,96,97,-1,96,95,98,-1,96,98,94,-1,96,94,93,-1,99,100,101,-1,96,100,99,-1,96,99,97,-1,102,103,104,-1,103,102,105,-1,103,105,101,-1,103,101,100,-1,106,107,108,-1,103,107,106,-1,103,106,104,-1,49,109,50,-1,107,109,49,-1,107,49,48,-1,107,48,52,-1,107,52,110,-1,107,110,108,-1,42,111,43,-1,41,50,109,-1,41,109,111,-1,41,111,42,-1,44,112,45,-1,111,112,44,-1,111,44,43,-1,46,113,47,-1,46,45,112,-1,46,112,113,-1,35,114,36,-1,34,47,113,-1,34,113,114,-1,34,114,35,-1,37,115,38,-1,114,115,37,-1,114,37,36,-1,39,116,40,-1,115,116,39,-1,115,39,38,-1,117,65,66,-1,118,32,31,-1,118,31,40,-1,118,40,116,-1,118,116,117,-1,117,116,65,-1,119,63,65,-1,120,119,65,-1,121,68,63,-1,119,121,63,-1,122,71,68,-1,121,122,68,-1,123,74,71,-1,122,123,71,-1,124,78,74,-1,123,124,74,-1,80,78,125,-1,80,125,126,-1,124,125,78,-1,128,126,125,-1,128,125,127,-1,129,130,131,-1,132,130,129,-1,133,134,135,-1,134,133,136,-1,134,136,131,-1,134,131,130,-1,137,138,139,-1,134,138,137,-1,134,137,135,-1,140,141,142,-1,140,142,61,-1,140,61,57,-1,140,57,56,-1,138,140,56,-1,138,56,59,-1,138,59,143,-1,138,143,139,-1,144,83,87,-1,144,87,145,-1,140,144,145,-1,140,145,141,-1,146,89,83,-1,144,146,83,-1,147,93,89,-1,146,147,89,-1,148,96,93,-1,147,148,93,-1,149,100,96,-1,148,149,96,-1,150,103,100,-1,149,150,100,-1,151,107,103,-1,150,151,103,-1,152,109,107,-1,151,152,107,-1,153,111,109,-1,152,153,109,-1,154,112,111,-1,153,154,111,-1,155,113,112,-1,154,155,112,-1,156,114,113,-1,155,156,113,-1,157,115,114,-1,156,157,114,-1,158,116,115,-1,157,158,115,-1,120,65,116,-1,158,120,116,-1,159,119,120,-1,160,159,120,-1,161,121,119,-1,159,161,119,-1,162,122,121,-1,161,162,121,-1,163,123,122,-1,162,163,122,-1,164,124,123,-1,163,164,123,-1,165,125,124,-1,164,165,124,-1,125,166,167,-1,125,167,168,-1,125,168,127,-1,165,166,125,-1,170,130,132,-1,170,132,171,-1,170,171,172,-1,170,172,174,-1,170,174,169,-1,174,172,173,-1,166,170,169,-1,166,169,167,-1,175,134,130,-1,170,175,130,-1,176,138,134,-1,175,176,134,-1,177,140,138,-1,176,177,138,-1,178,144,140,-1,177,178,140,-1,179,146,144,-1,178,179,144,-1,180,147,146,-1,179,180,146,-1,181,148,147,-1};
			return value;
		}
		private int[] getairway_Geo_8_53_coordIndex_2()
		{
			int[] value = {180,181,147,-1,182,149,148,-1,181,182,148,-1,183,150,149,-1,182,183,149,-1,184,151,150,-1,183,184,150,-1,185,152,151,-1,184,185,151,-1,186,153,152,-1,185,186,152,-1,187,154,153,-1,186,187,153,-1,188,155,154,-1,187,188,154,-1,189,156,155,-1,188,189,155,-1,190,157,156,-1,189,190,156,-1,191,158,157,-1,190,191,157,-1,160,120,158,-1,191,160,158,-1,192,159,160,-1,193,192,160,-1,194,161,159,-1,192,194,159,-1,195,162,161,-1,194,195,161,-1,196,163,162,-1,195,196,162,-1,197,164,163,-1,196,197,163,-1,198,165,164,-1,197,198,164,-1,199,166,165,-1,198,199,165,-1,200,170,166,-1,199,200,166,-1,201,175,170,-1,200,201,170,-1,202,176,175,-1,201,202,175,-1,203,177,176,-1,202,203,176,-1,204,178,177,-1,203,204,177,-1,205,179,178,-1,204,205,178,-1,206,180,179,-1,205,206,179,-1,207,181,180,-1,206,207,180,-1,208,182,181,-1,207,208,181,-1,209,183,182,-1,208,209,182,-1,210,184,183,-1,209,210,183,-1,211,185,184,-1,210,211,184,-1,212,186,185,-1,211,212,185,-1,213,187,186,-1,212,213,186,-1,214,188,187,-1,213,214,187,-1,215,189,188,-1,214,215,188,-1,216,190,189,-1,215,216,189,-1,217,191,190,-1,216,217,190,-1,193,160,191,-1,217,193,191,-1,218,192,193,-1,219,218,193,-1,220,194,192,-1,218,220,192,-1,221,195,194,-1,220,221,194,-1,222,196,195,-1,221,222,195,-1,223,197,196,-1,222,223,196,-1,224,198,197,-1,223,224,197,-1,225,199,198,-1,224,225,198,-1,226,200,199,-1,225,226,199,-1,227,201,200,-1,226,227,200,-1,228,202,201,-1,227,228,201,-1,229,203,202,-1,228,229,202,-1,230,204,203,-1,229,230,203,-1,231,205,204,-1,230,231,204,-1,232,206,205,-1,231,232,205,-1,233,207,206,-1,232,233,206,-1,234,208,207,-1,233,234,207,-1,235,209,208,-1,234,235,208,-1,236,210,209,-1,235,236,209,-1,237,211,210,-1,236,237,210,-1,238,212,211,-1,237,238,211,-1,239,213,212,-1,238,239,212,-1,240,214,213,-1,239,240,213,-1,241,215,214,-1,240,241,214,-1,242,216,215,-1,241,242,215,-1,243,217,216,-1,242,243,216,-1,219,193,217,-1,243,219,217,-1,244,218,219,-1,244,219,245,-1,246,220,218,-1,246,218,244,-1,247,221,220,-1,247,220,246,-1,248,222,221,-1,248,221,247,-1,249,223,222,-1,249,222,248,-1,250,224,223,-1,250,223,249,-1,251,225,224,-1,251,224,250,-1,252,226,225,-1,252,225,251,-1,253,227,226,-1,253,226,252,-1,254,228,227,-1,254,227,253,-1,255,229,228,-1,255,228,254,-1,256,230,229,-1,256,229,255,-1,257,231,230,-1,257,230,256,-1,258,232,231,-1,258,231,257,-1,259,234,233,-1,259,233,232,-1,259,232,258,-1,259,258,260,-1,261,235,234,-1,261,234,259,-1,262,236,235,-1,262,235,261,-1,263,237,236,-1,263,236,262,-1,264,238,237,-1,264,237,263,-1,265,239,238,-1,265,238,264,-1,266,240,239,-1,266,239,265,-1,267,241,240,-1,267,240,266,-1,268,242,241,-1,268,241,267,-1,269,243,242,-1,269,242,268,-1,245,219,243,-1,245,243,269,-1,270,244,245,-1,271,270,245,-1,272,246,244,-1,272,244,270,-1,273,247,246,-1,272,273,246,-1,274,248,247,-1,273,274,247,-1,275,249,248,-1,274,275,248,-1,276,250,249,-1,275,276,249,-1,277,251,250,-1,276,277,250,-1,278,252,251,-1,277,278,251,-1,279,253,252,-1,278,279,252,-1,280,254,253,-1,279,280,253,-1,281,255,254,-1,280,281,254,-1,282,256,255,-1,281,282,255,-1,283,257,256,-1,282,283,256,-1,284,258,257,-1,283,284,257,-1,285,260,258,-1,284,285,258,-1,286,259,260,-1,285,286,260,-1,287,261,259,-1,286,287,259,-1,288,262,261,-1,287,288,261,-1,289,263,262,-1,288,289,262,-1,290,264,263,-1,289,290,263,-1,291,265,264,-1,290,291,264,-1,292,266,265,-1,291,292,265,-1,293,267,266,-1,292,293,266,-1,294,268,267,-1,293,294,267,-1,295,269,268,-1,294,295,268,-1,271,245,269,-1,295,271,269,-1,296,270,271,-1,297,296,271,-1,298,272,270,-1,298,270,296,-1,299,273,272,-1,298,299,272,-1,300,274,273,-1,299,300,273,-1,301,275,274,-1,300,301,274,-1,302,276,275,-1,301,302,275,-1,303,277,276,-1,302,303,276,-1,304,278,277,-1,303,304,277,-1,305,279,278,-1,304,305,278,-1,306,280,279,-1};
			return value;
		}
		private int[] getairway_Geo_8_53_coordIndex_3()
		{
			int[] value = {305,306,279,-1,307,281,280,-1,306,307,280,-1,308,282,281,-1,307,308,281,-1,309,283,282,-1,308,309,282,-1,310,284,283,-1,309,310,283,-1,311,285,284,-1,310,311,284,-1,312,286,285,-1,311,312,285,-1,313,287,286,-1,312,313,286,-1,314,288,287,-1,313,314,287,-1,315,289,288,-1,314,315,288,-1,316,290,289,-1,315,316,289,-1,317,291,290,-1,316,317,290,-1,318,292,291,-1,317,318,291,-1,319,293,292,-1,318,319,292,-1,320,294,293,-1,319,320,293,-1,321,295,294,-1,320,321,294,-1,297,271,295,-1,321,297,295,-1,322,296,297,-1,323,322,297,-1,324,298,296,-1,322,324,296,-1,325,299,298,-1,324,325,298,-1,326,300,299,-1,325,326,299,-1,327,301,300,-1,326,327,300,-1,328,302,301,-1,327,328,301,-1,329,303,302,-1,328,329,302,-1,330,304,303,-1,329,330,303,-1,331,305,304,-1,330,331,304,-1,332,306,305,-1,331,332,305,-1,333,307,306,-1,332,333,306,-1,334,308,307,-1,333,334,307,-1,335,309,308,-1,334,335,308,-1,336,310,309,-1,335,336,309,-1,337,311,310,-1,336,337,310,-1,338,312,311,-1,337,338,311,-1,339,313,312,-1,338,339,312,-1,340,314,313,-1,339,340,313,-1,341,315,314,-1,340,341,314,-1,342,316,315,-1,341,342,315,-1,343,317,316,-1,342,343,316,-1,344,318,317,-1,343,344,317,-1,345,319,318,-1,344,345,318,-1,346,320,319,-1,345,346,319,-1,347,321,320,-1,346,347,320,-1,323,297,321,-1,347,323,321,-1,348,322,323,-1,349,348,323,-1,350,324,322,-1,348,350,322,-1,351,325,324,-1,350,351,324,-1,352,326,325,-1,351,352,325,-1,353,327,326,-1,352,353,326,-1,354,328,327,-1,353,354,327,-1,355,329,328,-1,354,355,328,-1,356,330,329,-1,355,356,329,-1,357,331,330,-1,356,357,330,-1,358,332,331,-1,357,358,331,-1,359,333,332,-1,358,359,332,-1,360,334,333,-1,359,360,333,-1,361,335,334,-1,360,361,334,-1,362,336,335,-1,361,362,335,-1,363,337,336,-1,362,363,336,-1,364,338,337,-1,363,364,337,-1,365,339,338,-1,364,365,338,-1,366,340,339,-1,365,366,339,-1,367,341,340,-1,366,367,340,-1,368,342,341,-1,367,368,341,-1,369,343,342,-1,368,369,342,-1,370,344,343,-1,369,370,343,-1,371,345,344,-1,370,371,344,-1,372,346,345,-1,371,372,345,-1,373,347,346,-1,372,373,346,-1,349,323,347,-1,373,349,347,-1,355,354,358,-1,358,354,353,-1,358,353,359,-1,359,353,352,-1,359,352,360,-1,360,352,351,-1,360,351,361,-1,361,351,350,-1,361,350,348,-1,364,363,373,-1,373,363,362,-1,373,362,349,-1,349,362,361,-1,349,361,348,-1,371,367,372,-1,372,367,366,-1,372,366,373,-1,373,366,365,-1,373,365,364,-1,370,369,368,-1,370,368,367,-1,370,367,371,-1,355,358,357,-1,355,357,356,-1,22,374,19,-1,19,374,377,-1,19,377,18,-1,18,377,378,-1,18,378,16,-1,16,378,379,-1,16,379,17,-1,17,379,381,-1,17,381,55,-1,55,381,382,-1,55,382,54,-1,54,382,383,-1,54,383,53,-1,53,383,384,-1,53,384,51,-1,374,375,376,-1,374,376,377,-1,381,379,380,-1,86,85,385,-1,385,85,379,-1,385,379,58,-1,58,379,143,-1,58,143,59,-1,379,85,380,-1,385,58,60,-1,137,139,143,-1,137,143,379,-1,137,379,378,-1,137,378,136,-1,137,136,133,-1,137,133,135,-1,136,378,377,-1,136,377,132,-1,136,132,129,-1,136,129,131,-1,132,377,171,-1,377,376,172,-1,377,172,171,-1,173,172,376,-1,173,376,375,-1,51,384,110,-1,51,110,52,-1,383,105,102,-1,383,102,104,-1,383,104,106,-1,383,106,108,-1,383,108,110,-1,383,110,384,-1,105,383,382,-1,105,382,98,-1,105,98,95,-1,105,95,97,-1,105,97,99,-1,105,99,101,-1,98,382,381,-1,98,381,88,-1,98,88,90,-1,98,90,92,-1,98,92,94,-1,88,381,91,-1,82,84,91,-1,82,91,381,-1,82,381,380,-1,82,380,85,-1,142,385,60,-1,142,60,61,-1,385,142,141,-1,385,141,145,-1,385,145,87,-1,385,87,86,-1,386,387,388,-1,387,389,390,-1,387,390,391,-1,387,391,388,-1,392,393,394,-1,394,393,387,-1,394,387,386,-1,395,396,397,-1,397,396,393,-1,397,393,392,-1,398,399,400,-1,400,399,396,-1,400,396,395,-1,401,402,403,-1,403,402,399,-1,403,399,398,-1,404,405,406,-1,405,402,401,-1,405,401,407,-1};
			return value;
		}
		private int[] getairway_Geo_8_53_coordIndex_4()
		{
			int[] value = {405,407,406,-1,408,409,410,-1,410,409,405,-1,410,405,404,-1,411,409,408,-1,412,413,414,-1,414,413,415,-1,416,417,418,-1,419,418,417,-1,419,417,413,-1,419,413,412,-1,420,421,422,-1,422,421,417,-1,422,417,416,-1,423,424,425,-1,426,425,424,-1,426,424,421,-1,426,421,420,-1,427,428,429,-1,429,428,424,-1,429,424,423,-1,430,431,432,-1,432,431,434,-1,434,431,428,-1,434,428,433,-1,433,428,427,-1,435,436,437,-1,437,436,431,-1,437,431,430,-1,438,439,440,-1,436,435,441,-1,436,441,440,-1,436,440,439,-1,442,443,444,-1,444,443,439,-1,444,439,438,-1,445,446,447,-1,447,446,443,-1,447,443,442,-1,448,449,450,-1,446,445,451,-1,446,451,450,-1,446,450,449,-1,452,453,454,-1,454,453,449,-1,454,449,448,-1,390,389,455,-1,455,389,453,-1,455,453,452,-1,389,387,456,-1,389,456,457,-1,387,393,458,-1,387,458,456,-1,393,396,459,-1,393,459,458,-1,396,399,460,-1,396,460,459,-1,399,402,461,-1,399,461,460,-1,402,405,462,-1,402,462,461,-1,405,409,463,-1,405,463,464,-1,405,464,465,-1,405,465,466,-1,405,466,462,-1,409,411,467,-1,468,469,470,-1,409,467,463,-1,471,470,469,-1,471,469,466,-1,471,466,465,-1,472,473,474,-1,472,474,475,-1,476,475,474,-1,476,474,469,-1,476,469,468,-1,477,478,479,-1,479,478,474,-1,479,474,473,-1,480,481,482,-1,478,477,483,-1,478,483,482,-1,478,482,481,-1,484,485,486,-1,484,486,487,-1,485,484,481,-1,485,481,480,-1,488,489,490,-1,488,490,491,-1,489,488,484,-1,489,484,487,-1,492,493,494,-1,492,494,415,-1,492,415,413,-1,493,492,488,-1,493,488,491,-1,413,417,495,-1,413,495,492,-1,417,421,496,-1,417,496,495,-1,421,424,497,-1,421,497,496,-1,424,428,498,-1,424,498,497,-1,428,431,499,-1,428,499,498,-1,431,436,500,-1,431,500,499,-1,436,439,501,-1,436,501,500,-1,439,443,502,-1,439,502,501,-1,443,446,503,-1,443,503,502,-1,446,449,504,-1,446,504,503,-1,449,453,505,-1,449,505,504,-1,453,389,457,-1,453,457,505,-1,457,456,506,-1,457,506,507,-1,456,458,508,-1,456,508,506,-1,458,459,509,-1,458,509,508,-1,459,460,510,-1,459,510,509,-1,460,461,511,-1,460,511,510,-1,461,462,512,-1,461,512,511,-1,462,466,513,-1,462,513,512,-1,466,469,514,-1,466,514,513,-1,469,474,515,-1,469,515,514,-1,474,478,516,-1,474,516,515,-1,478,481,517,-1,478,517,516,-1,481,484,518,-1,481,518,517,-1,484,488,519,-1,484,519,518,-1,488,492,520,-1,488,520,519,-1,492,495,521,-1,492,521,520,-1,495,496,522,-1,495,522,521,-1,496,497,523,-1,496,523,522,-1,497,498,524,-1,497,524,523,-1,498,499,525,-1,498,525,524,-1,499,500,526,-1,499,526,525,-1,500,501,527,-1,500,527,526,-1,501,502,528,-1,501,528,527,-1,502,503,529,-1,502,529,528,-1,503,504,530,-1,503,530,529,-1,504,505,531,-1,504,531,530,-1,505,457,507,-1,505,507,531,-1,507,506,532,-1,507,532,533,-1,506,508,534,-1,506,534,532,-1,508,509,535,-1,508,535,534,-1,509,510,536,-1,509,536,535,-1,510,511,537,-1,510,537,536,-1,511,512,538,-1,511,538,537,-1,512,513,539,-1,512,539,538,-1,513,514,540,-1,513,540,539,-1,514,515,541,-1,514,541,540,-1,515,516,542,-1,515,542,541,-1,516,517,543,-1,516,543,542,-1,517,518,544,-1,517,544,543,-1,518,519,545,-1,518,545,544,-1,519,520,546,-1,519,546,545,-1,520,521,547,-1,520,547,546,-1,521,522,548,-1,521,548,547,-1,522,523,549,-1,522,549,548,-1,523,524,550,-1,523,550,549,-1,524,525,551,-1,524,551,550,-1,525,526,552,-1,525,552,551,-1,526,527,553,-1,526,553,552,-1,527,528,554,-1,527,554,553,-1,528,529,555,-1,528,555,554,-1,529,530,556,-1,529,556,555,-1,530,531,557,-1,530,557,556,-1,531,507,533,-1,531,533,557,-1,533,532,558,-1,533,558,559,-1,532,534,560,-1,532,560,558,-1,534,535,561,-1,534,561,560,-1,535,536,562,-1,535,562,561,-1,536,537,563,-1,536,563,562,-1,537,538,564,-1,537,564,563,-1,538,539,565,-1,538,565,564,-1,539,540,566,-1,539,566,565,-1,540,541,567,-1,540,567,566,-1,541,542,568,-1,541,568,567,-1,542,543,569,-1,542,569,568,-1,543,544,570,-1,543,570,569,-1,544,545,571,-1};
			return value;
		}
		private int[] getairway_Geo_8_53_coordIndex_5()
		{
			int[] value = {544,571,570,-1,545,546,572,-1,545,572,571,-1,546,547,573,-1,546,573,572,-1,547,548,574,-1,547,574,573,-1,548,549,575,-1,548,575,574,-1,549,550,576,-1,549,576,575,-1,550,551,577,-1,550,577,576,-1,551,552,578,-1,551,578,577,-1,552,553,579,-1,552,579,578,-1,553,554,580,-1,553,580,579,-1,554,555,581,-1,554,581,580,-1,555,556,582,-1,555,582,581,-1,556,557,583,-1,556,583,582,-1,557,533,559,-1,557,559,583,-1,559,558,584,-1,559,584,585,-1,558,560,586,-1,558,586,584,-1,560,561,587,-1,560,587,586,-1,561,562,588,-1,561,588,587,-1,562,563,589,-1,562,589,588,-1,563,564,590,-1,563,590,589,-1,564,565,591,-1,564,591,590,-1,565,566,592,-1,565,592,591,-1,566,567,593,-1,566,593,592,-1,567,568,594,-1,567,594,593,-1,568,569,595,-1,568,595,594,-1,569,570,596,-1,569,596,595,-1,570,571,597,-1,570,597,596,-1,571,572,598,-1,571,598,597,-1,573,574,599,-1,573,599,600,-1,573,600,598,-1,573,598,572,-1,574,575,601,-1,574,601,599,-1,575,576,602,-1,575,602,601,-1,576,577,603,-1,576,603,602,-1,577,578,604,-1,577,604,603,-1,578,579,605,-1,578,605,604,-1,579,580,606,-1,579,606,605,-1,580,581,607,-1,580,607,606,-1,581,582,608,-1,581,608,607,-1,582,583,609,-1,582,609,608,-1,583,559,585,-1,583,585,609,-1,585,584,610,-1,585,610,611,-1,584,586,612,-1,584,612,610,-1,586,587,613,-1,586,613,612,-1,587,588,614,-1,587,614,613,-1,588,589,615,-1,588,615,614,-1,589,590,616,-1,589,616,615,-1,590,591,617,-1,590,617,616,-1,591,592,618,-1,591,618,617,-1,592,593,619,-1,592,619,618,-1,593,594,620,-1,593,620,619,-1,594,595,621,-1,594,621,620,-1,595,596,622,-1,595,622,621,-1,596,597,623,-1,596,623,622,-1,597,598,624,-1,597,624,623,-1,598,600,625,-1,598,625,624,-1,600,599,626,-1,600,626,625,-1,599,601,627,-1,599,627,626,-1,601,602,628,-1,601,628,627,-1,602,603,629,-1,602,629,628,-1,603,604,630,-1,603,630,629,-1,604,605,631,-1,604,631,630,-1,605,606,632,-1,605,632,631,-1,606,607,633,-1,606,633,632,-1,607,608,634,-1,607,634,633,-1,608,609,635,-1,608,635,634,-1,609,585,611,-1,609,611,635,-1,611,610,636,-1,611,636,637,-1,610,612,638,-1,610,638,636,-1,612,613,639,-1,612,639,638,-1,613,614,640,-1,613,640,639,-1,614,615,641,-1,614,641,640,-1,615,616,642,-1,615,642,641,-1,616,617,643,-1,616,643,642,-1,617,618,644,-1,617,644,643,-1,618,619,645,-1,618,645,644,-1,619,620,646,-1,619,646,645,-1,620,621,647,-1,620,647,646,-1,621,622,648,-1,621,648,647,-1,622,623,649,-1,622,649,648,-1,623,624,650,-1,623,650,649,-1,624,625,651,-1,624,651,650,-1,625,626,652,-1,625,652,651,-1,626,627,653,-1,626,653,652,-1,627,628,654,-1,627,654,653,-1,628,629,655,-1,628,655,654,-1,629,630,656,-1,629,656,655,-1,630,631,657,-1,630,657,656,-1,631,632,658,-1,631,658,657,-1,632,633,659,-1,632,659,658,-1,633,634,660,-1,633,660,659,-1,634,635,661,-1,634,661,660,-1,635,611,637,-1,635,637,661,-1,637,636,662,-1,637,662,663,-1,636,638,664,-1,636,664,662,-1,638,639,665,-1,638,665,664,-1,639,640,666,-1,639,666,665,-1,640,641,667,-1,640,667,666,-1,641,642,668,-1,641,668,667,-1,642,643,669,-1,642,669,668,-1,643,644,670,-1,643,670,669,-1,644,645,671,-1,644,671,670,-1,645,646,672,-1,645,672,671,-1,646,647,673,-1,646,673,672,-1,647,648,674,-1,647,674,673,-1,648,649,675,-1,648,675,674,-1,649,650,676,-1,649,676,675,-1,650,651,677,-1,650,677,676,-1,651,652,678,-1,651,678,677,-1,652,653,679,-1,652,679,678,-1,653,654,680,-1,653,680,679,-1,654,655,681,-1,654,681,680,-1,655,656,682,-1,655,682,681,-1,656,657,683,-1,656,683,682,-1,657,658,684,-1,657,684,683,-1,658,659,685,-1,658,685,684,-1,659,660,686,-1,659,686,685,-1,660,661,687,-1,660,687,686,-1,661,637,663,-1,661,663,687,-1,663,662,688,-1,663,688,689,-1,662,664,690,-1,662,690,688,-1,664,665,691,-1,664,691,690,-1,665,666,692,-1,665,692,691,-1,666,667,693,-1,666,693,692,-1,667,668,694,-1,667,694,693,-1,668,669,695,-1,668,695,694,-1,669,670,696,-1};
			return value;
		}
		private int[] getairway_Geo_8_53_coordIndex_6()
		{
			int[] value = {669,696,695,-1,670,671,697,-1,670,697,696,-1,671,672,698,-1,671,698,697,-1,672,673,699,-1,672,699,698,-1,673,674,700,-1,673,700,699,-1,674,675,701,-1,674,701,700,-1,675,676,702,-1,675,702,701,-1,676,677,703,-1,676,703,702,-1,677,678,704,-1,677,704,703,-1,678,679,705,-1,678,705,704,-1,679,680,706,-1,679,706,705,-1,680,681,707,-1,680,707,706,-1,681,682,708,-1,681,708,707,-1,682,683,709,-1,682,709,708,-1,683,684,710,-1,683,710,709,-1,684,685,711,-1,684,711,710,-1,685,686,712,-1,685,712,711,-1,686,687,713,-1,686,713,712,-1,687,663,689,-1,687,689,713,-1,710,711,712,-1,710,712,713,-1,710,713,689,-1,710,689,688,-1,710,688,690,-1,710,690,691,-1,710,691,692,-1,710,692,693,-1,710,693,694,-1,710,694,695,-1,710,695,696,-1,710,696,697,-1,710,697,698,-1,710,698,699,-1,710,699,700,-1,710,700,701,-1,710,701,702,-1,710,702,703,-1,710,703,704,-1,710,704,705,-1,710,705,706,-1,710,706,707,-1,710,707,708,-1,710,708,709,-1,714,715,716,-1,714,716,374,-1,714,374,22,-1,714,22,21,-1,714,21,717,-1,714,717,718,-1,714,718,719,-1,714,719,720,-1,714,720,721,-1,714,721,722,-1,714,722,723,-1,714,723,724,-1,714,724,725,-1,714,725,726,-1,714,726,727,-1,714,727,728,-1,729,730,714,-1,729,714,728,-1,729,728,731,-1,732,715,714,-1,732,714,730,-1,733,716,715,-1,733,715,732,-1,734,174,733,-1,733,174,173,-1,733,173,716,-1,716,173,375,-1,716,375,374,-1,735,168,167,-1,735,167,169,-1,735,169,174,-1,735,174,734,-1,24,717,21,-1,24,21,20,-1,736,128,127,-1,736,127,168,-1,736,168,735,-1,26,718,717,-1,26,717,24,-1,26,24,23,-1,80,126,736,-1,80,736,737,-1,80,737,738,-1,80,738,81,-1,736,126,128,-1,28,719,718,-1,28,718,26,-1,28,26,25,-1,739,76,73,-1,739,73,75,-1,739,75,77,-1,739,77,79,-1,739,79,81,-1,739,81,738,-1,30,720,719,-1,30,719,28,-1,30,28,27,-1,740,118,117,-1,740,117,66,-1,740,66,62,-1,740,62,64,-1,740,64,67,-1,740,67,69,-1,740,69,70,-1,740,70,72,-1,740,72,76,-1,740,76,739,-1,33,721,720,-1,33,720,30,-1,33,30,29,-1,741,722,721,-1,741,721,33,-1,741,33,32,-1,741,32,118,-1,741,118,740,-1,742,743,723,-1,742,723,722,-1,742,722,741,-1,744,724,723,-1,744,723,743,-1,745,746,725,-1,745,725,724,-1,745,724,744,-1,747,726,725,-1,747,725,746,-1,748,749,727,-1,748,727,726,-1,748,726,747,-1,731,728,727,-1,731,727,749,-1,750,494,493,-1,750,493,491,-1,750,491,490,-1,750,490,751,-1,752,753,419,-1,752,419,412,-1,752,412,414,-1,752,414,415,-1,752,415,494,-1,752,494,750,-1,754,426,420,-1,754,420,422,-1,754,422,416,-1,754,416,418,-1,754,418,419,-1,754,419,753,-1,755,756,433,-1,755,433,427,-1,755,427,429,-1,755,429,423,-1,755,423,425,-1,755,425,426,-1,755,426,754,-1,757,434,433,-1,757,433,756,-1,758,759,441,-1,758,441,435,-1,758,435,437,-1,758,437,430,-1,758,430,432,-1,758,432,434,-1,758,434,757,-1,760,451,445,-1,760,445,447,-1,760,447,442,-1,760,442,444,-1,760,444,438,-1,760,438,440,-1,760,440,441,-1,760,441,759,-1,761,391,390,-1,761,390,455,-1,761,455,452,-1,761,452,454,-1,761,454,448,-1,761,448,450,-1,761,450,451,-1,761,451,760,-1,762,763,407,-1,762,407,401,-1,762,401,403,-1,762,403,398,-1,762,398,400,-1,762,400,395,-1,762,395,397,-1,762,397,392,-1,762,392,394,-1,762,394,386,-1,762,386,388,-1,762,388,391,-1,762,391,761,-1,764,464,463,-1,764,463,467,-1,764,467,411,-1,764,411,408,-1,764,408,410,-1,764,410,404,-1,764,404,406,-1,764,406,407,-1,764,407,763,-1,765,471,465,-1,765,465,464,-1,765,464,764,-1,766,476,468,-1,766,468,470,-1,766,470,471,-1,766,471,765,-1,767,472,475,-1,767,475,476,-1,767,476,766,-1,473,472,767,-1,473,767,768,-1,473,768,477,-1,473,477,479,-1,483,477,768,-1,769,486,485,-1,769,485,480,-1,769,480,482,-1,769,482,483,-1,769,483,768,-1,770,751,490,-1,770,490,489,-1,770,489,487,-1,770,487,486,-1,770,486,769,-1,771,772,773,-1,771,773,774,-1,771,774,775,-1,771,775,776,-1};
			return value;
		}
		private int[] getairway_Geo_8_53_coordIndex_7()
		{
			int[] value = {771,776,777,-1,771,777,778,-1,771,778,779,-1,771,779,780,-1,771,780,781,-1,771,781,782,-1,771,782,783,-1,771,783,784,-1,771,784,785,-1,771,785,786,-1,789,790,788,-1,788,790,791,-1,788,791,787,-1,787,791,770,-1,787,770,769,-1,763,736,764,-1,764,736,735,-1,764,735,765,-1,765,735,734,-1,765,734,766,-1,766,734,733,-1,766,733,767,-1,767,733,732,-1,767,732,768,-1,768,732,730,-1,768,730,769,-1,769,730,729,-1,769,729,787,-1,794,795,793,-1,793,795,796,-1,793,796,792,-1,792,796,737,-1,792,737,762,-1,762,737,736,-1,762,736,763,-1,771,786,790,-1,771,790,789,-1,786,785,791,-1,786,791,790,-1,791,785,784,-1,791,784,750,-1,791,750,751,-1,791,751,770,-1,750,784,752,-1,784,783,755,-1,784,755,754,-1,784,754,753,-1,784,753,752,-1,783,782,758,-1,783,758,757,-1,783,757,756,-1,783,756,755,-1,762,761,792,-1,792,761,760,-1,792,760,782,-1,782,760,759,-1,782,759,758,-1,792,782,781,-1,781,780,793,-1,781,793,792,-1,780,779,794,-1,780,794,793,-1,779,778,795,-1,779,795,794,-1,778,777,796,-1,778,796,795,-1,741,740,777,-1,777,740,739,-1,777,739,796,-1,796,739,738,-1,796,738,737,-1,777,776,742,-1,777,742,741,-1,776,775,745,-1,776,745,744,-1,776,744,743,-1,776,743,742,-1,775,774,748,-1,775,748,747,-1,775,747,746,-1,775,746,745,-1,729,731,787,-1,787,731,749,-1,787,749,773,-1,773,749,748,-1,773,748,774,-1,773,772,788,-1,773,788,787,-1,772,771,789,-1,772,789,788,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getairway_Coord_9_53_point_1()
		{
			double[] value = {.7409,-1.60579,.01665,.67517,-1.6374,.05939,.57712,-1.68485,.08764,.46166,-1.74091,.09708,.34637,-1.79704,.0863,.24881,-1.84471,.05692,.18382,-1.87665,.01342,.16131,-1.888,-.03757,.18469,-1.87703,-.0883,.25041,-1.84542,-.13104,.34847,-1.79797,-.15928,.46393,-1.74192,-.16873,.57922,-1.68578,-.15794,.67678,-1.63811,-.12857,.74177,-1.60617,-.08507,.76428,-1.59482,-.03407,.57993,-1.69049,.08768,.46459,-1.7468,.09713,.67786,-1.6428,.05943,.74349,-1.611,.01669,1.00639,-2.08088,-.03052,.76448,-1.60086,-.02911,.75349,-1.60626,-.00504,1.10464,-2.33468,-.07975,.99298,-2.10633,-.07763,1.10591,-2.49963,-.12227,1.05184,-2.38368,-.12113,1.06405,-2.65913,-.15083,1.02262,-2.56689,-.1504,1.00959,-2.83738,-.16073,.9639,-2.73522,-.16107,.9838,-3.07346,-.14997,.98385,-3.07345,-.14997,.90899,-2.91126,-.15153,.87012,-3.08955,-.12195,.88507,-3.08959,-.12538,.89099,-3.08841,-.12687,.91199,-3.08607,-.13197,.91888,-3.08484,-.1337,.96028,-3.0775,-.14408,.97386,-3.07523,-.14747,.79268,-3.09763,-.07939,.79804,-3.09786,-.08212,.8004,-3.09707,-.08356,.8349,-3.09582,-.1019,.83948,-3.09372,-.10485,.86087,-3.09244,-.11635,.86464,-3.0905,-.11884,.77072,-3.11147,-.02864,.78563,-3.10369,-.06168,.78675,-3.10035,-.06657,.16548,-1.89384,-.03523,.77524,-3.11424,-.02294,.18699,-1.88301,.01347,.25193,-1.85099,.05696,.34942,-1.80316,.08634,1.23223,-3.03139,.12065,1.22444,-3.02983,.12575,1.20564,-3.02599,.11421,1.24788,-3.03453,.11191,1.20485,-3.03195,.11448,1.22336,-3.0357,.12584,1.04045,-3.06686,-.15516,.89581,-2.95224,-.29827,1.04603,-3.06674,-.15553,.81783,-2.94135,-.32187,1.02078,-3.07116,-.1537,1.06766,-3.06555,-.15702,.9478,-2.95224,-.29827,1.07246,-3.0654,-.15735,1.11127,-3.05949,-.16015,1.04941,-2.96214,-.27681,1.11899,-3.05923,-.16067,1.18805,-3.05303,-.15657,1.18647,-2.98193,-.23389,1.19734,-3.05364,-.15591,1.12678,-3.05757,-.16125,1.24413,-3.03965,-.15194,1.25264,-3.0047,-.18454,1.24691,-3.03956,-.15174,1.27083,-3.02232,-.14632,1.25715,-3.03106,-.15066,1.14866,-3.15659,.12007,1.13921,-3.15118,.13304,1.14717,-3.15743,.11993,1.16311,-3.15063,.12142,1.17141,-3.14812,.12081,1.1742,-3.14619,.12222,1.0189,-3.1535,.1096,.9927,-3.14623,.12231,1.01682,-3.15369,.10907,1.02095,-3.15341,.11012,.929,-3.1651,.08619,.80365,-3.14524,.12017,.92439,-3.16624,.08493,.88293,-3.16109,.06938,.72803,-3.13535,.09871,.88028,-3.16061,.06807,.90449,-3.16355,.08037,.86447,-3.1588,.06002};
			return value;
		}
		private double[] getairway_Coord_9_53_point_2()
		{
			double[] value = {.69022,-3.1304,.08798,.86312,-3.15855,.05936,.80671,-3.13805,.02932,.64769,-3.10664,.03648,.80449,-3.13618,.02699,.81228,-3.14128,.03649,.78317,-3.12374,-.00039,.6146,-3.08784,-.00429,.7814,-3.12225,-.00224,.54607,-3.04033,-.10729,.77149,-3.11617,-.0147,.51535,-3.02251,-.14592,.49172,-2.99282,-.21029,.47754,-2.96907,-.26179,.49409,-2.95323,-.29612,.55553,-2.9463,-.31114,.71149,-2.94333,-.31758,1.00964,-3.07152,-.15294,.99035,-3.07228,-.15162,.24023,-2.11831,-.70308,.05635,-2.08302,-.77355,.36631,-2.12203,-.69316,.60798,-2.15631,-.62323,.93084,-2.22014,-.49599,1.08034,-2.287,-.36711,1.15439,-2.38966,-.17287,1.2443,-2.8203,-.12812,1.1461,-2.43655,-.08514,1.21776,-2.71203,-.12131,1.19025,-2.53299,.04416,1.18545,-2.50735,.04854,1.19281,-2.54099,.04496,1.18145,-2.50328,.04082,1.24498,-2.81602,.08649,1.18498,-2.57523,.17582,1.26626,-2.90503,.09232,1.23466,-2.76403,.08261,1.25507,-2.96825,.10244,1.10237,-2.61896,.25589,1.25134,-3.03048,.11074,1.01163,-2.64344,.29968,1.21029,-3.05294,.13238,1.21374,-3.03381,.13213,1.24817,-3.03384,.11187,.73463,-2.67872,.35937,1.19441,-3.08588,.12695,.38168,-2.65474,.30616,-.07633,-2.63853,.26504,-.25496,-2.6061,.20007,-.34427,-2.58989,.16759,-.43598,-2.52201,.03816,-.50715,-2.46832,-.06419,-.65045,-2.33375,-.3199,-.71636,-2.28292,-.41674,-.75936,-2.20019,-.5729,-.7823,-2.13433,-.69692,-.73454,-2.09229,-.77464,-.58219,-2.07777,-.79831,-.20251,-2.08082,-.78372,-.1101,-1.31142,-.88367,-.33792,-1.28338,-.95043,.04107,-1.311,-.8858,.3375,-1.33625,-.82637,.73797,-1.38726,-.7048,.93258,-1.44667,-.56127,1.0461,-1.54278,-.32757,1.0487,-1.61314,-.1559,1.12894,-2.34758,-.05257,1.13958,-2.39646,-.0778,1.13738,-2.34931,-.03901,1.11209,-1.65467,-.05504,1.18013,-2.49275,.03871,1.15146,-2.378,-.0125,1.15101,-2.37809,-.01339,1.14346,-2.34797,-.02687,1.12824,-1.71978,.10372,1.04056,-1.76433,.21306,.93845,-1.79067,.27809,.61704,-1.83326,.38435,.19054,-1.82141,.35855,-.35927,-1.82032,.35991,-.58011,-1.79487,.29942,-.69054,-1.78215,.26917,-.81654,-1.71995,.11832,-.91457,-1.6707,-.00113,-1.11847,-1.54617,-.30352,-1.20954,-1.49951,-.41671,-1.28115,-1.42152,-.60649,-1.32469,-1.35909,-.7585,-1.27814,-1.31726,-.86091,-1.10016,-1.29852,-.90792,-.64694,-1.28945,-.93337,-.21683,-.45855,-1.06488,-.4716,-.44479,-1.15281,-.04616,-.45874,-1.06243,.28629,-.47136,-.98104,.73399,-.49636,-.82138,.94864,-.52476,-.64208,1.06864,-.5702,-.35688,1.06564,-.60325,-.15005};
			return value;
		}
		private double[] getairway_Coord_9_53_point_3()
		{
			double[] value = {1.13367,-.62292,-.02649,1.14641,-.65354,.16524,1.04367,-.67424,.29402,.92619,-.68635,.36895,.55981,-.70552,.48628,.07941,-.69885,.44108,-.54107,-.69692,.42452,-.78819,-.6844,.34436,-.91175,-.67813,.30427,-1.04872,-.64859,.11843,-1.15521,-.62521,-.02868,-1.37483,-.56619,-.39959,-1.47367,-.54404,-.53892,-1.54791,-.50723,-.76984,-1.59178,-.47779,-.95435,-1.5357,-.45827,-1.07614,-1.33323,-.44993,-1.12687,-.8209,-.44684,-1.1425,-.2771,.68564,-1.0639,-.52968,.68564,-1.14809,-.10872,.68564,-1.0639,.2204,.68564,-.98736,.66433,.68564,-.83428,.87864,.68564,-.65824,1.00111,.68564,-.37504,1.00111,.68564,-.16839,1.06999,.68564,-.04592,1.0853,.68564,.14543,.9858,.68564,.27554,.87099,.68564,.35208,.51125,.68564,.47455,.03671,.68564,.43628,-.57561,.68564,.42862,-.82053,.68564,.35208,-.943,.68564,.31381,-1.08077,.68564,.13012,-1.18792,.68564,-.01531,-1.40989,.68564,-.3827,-1.59358,.68564,-.44393,-1.58593,.68564,-.75009,-1.57828,.68564,-.66589,-1.57828,.68564,-1.05625,-1.37927,.68564,-1.10982,-.87411,.68564,-1.13278,-.18741,1.64073,-1.08201,-.4443,1.64073,-1.16764,-.01616,1.64073,-1.08201,.31856,1.64073,-1.00417,.77005,1.64073,-.84849,.98801,1.64073,-.66945,1.11256,1.64073,-.38143,1.11256,1.64073,-.17125,1.18262,1.64073,-.04671,1.19819,1.64073,.1479,1.09699,1.64073,.28023,.98023,1.64073,.35808,.61437,1.64073,.48262,.13174,1.64073,.4437,-.491,1.64073,.43592,-.86465,1.64073,.31915,-.7401,1.64073,.35808,-1.00476,1.64073,.13233,-1.11374,1.64073,-.01557,-1.33949,1.64073,-.38921,-1.52631,1.64073,-.45149,-1.51852,1.64073,-.76286,-1.51074,1.64073,-.67723,-1.51074,1.64073,-1.07423,-1.30835,1.64073,-1.12872,-.79459,1.64073,-1.15207,.1724,2.70202,-.96447,-.06642,2.72464,-1.0408,.33161,2.70202,-.96447,.6428,2.68146,-.89508,1.06254,2.64033,-.75631,1.26518,2.59303,-.59672,1.38097,2.51695,-.33999,1.38097,2.46143,-.15265,1.4461,2.42853,-.04163,1.46057,2.37712,.13183,1.36649,2.34216,.24979,1.25794,2.3216,.31918,.9178,2.28869,.4302,.46911,2.29898,.3955,-.10984,2.30103,.38856,-.34142,2.3216,.31918,-.45722,2.33188,.28448,-.58748,2.38123,.11796,-.6888,2.4203,-.01388,-.89867,2.519,-.34693,-1.07236,2.53546,-.40244,-1.06512,2.61771,-.67999,-1.05788,2.59509,-.60366,-1.05788,2.69996,-.95753,-.86972,2.71436,-1.0061,-.39208,2.72053,-1.02692,.66697,3.33287,-.88417,.44707,3.35471,-.95414,.81356,3.33287,-.88417,1.1001,3.31302,-.82056};
			return value;
		}
		private double[] getairway_Coord_9_53_point_4()
		{
			double[] value = {1.48658,3.27331,-.69334,1.67316,3.22765,-.54704,1.77978,3.1542,-.31169,1.77978,3.10059,-.13994,1.83975,3.06883,-.03817,1.85308,3.0192,.12086,1.76645,2.98545,.22899,1.6665,2.9656,.2926,1.35331,2.93383,.39438,.94017,2.94376,.36257,.40709,2.94574,.35621,.19385,2.9656,.2926,.08724,2.97552,.2608,-.03271,3.02317,.10814,-.126,3.06089,-.01272,-.31924,3.15618,-.31805,-.47916,3.17206,-.36893,-.4725,3.25147,-.62337,-.46584,3.22964,-.5534,-.46584,3.33088,-.87781,-.29258,3.34478,-.92234,.14721,3.35074,-.94142,.95977,3.86806,-.71565,.76754,3.90069,-.77763,1.08911,3.86714,-.71208,1.3403,3.83693,-.65362,1.67805,3.77768,-.54126,1.83893,3.71116,-.41832,1.92699,3.60538,-.22527,1.92261,3.52867,-.08629,1.97293,3.48283,-.00247,1.98062,3.41172,.12654,1.90143,3.36397,.21193,1.81162,3.33618,.26097,1.5327,3.29269,.3357,1.169,3.30949,.2999,.69882,3.31568,.28176,.51231,3.34543,.22509,.41905,3.3603,.19676,.31712,3.42924,.0703,.2379,3.48381,-.02978,.07519,3.62139,-.28156,-.06461,3.64512,-.32663,-.05224,3.75872,-.53237,-.04815,3.72743,-.47558,-.03987,3.87232,-.7381,.11413,3.89112,-.76991,.50265,3.89689,-.77464,1.63048,4.37699,-.1091,1.59172,4.38879,-.12128,1.65711,4.37589,-.10673,1.70808,4.36452,-.09426,1.77614,4.34316,-.07232,1.80755,4.32053,-.05127,1.82294,4.28556,-.02054,1.82003,4.26062,.00064,1.8292,4.2454,.01415,1.82892,4.22221,.03397,1.81136,4.20716,.0459,1.79212,4.19867,.05212,1.7335,4.18623,.05961,1.65899,4.19393,.049,1.56226,4.19883,.0396,1.5246,4.20966,.02831,1.50577,4.21507,.02267,1.48657,4.23813,.00191,1.47167,4.25638,-.0145,1.44173,4.30215,-.05526,1.41354,4.31073,-.06412,1.41906,4.34763,-.09538,1.41909,4.33742,-.08664,1.42458,4.38452,-.12663,1.45681,4.38969,-.12932,1.53703,4.38918,-.12456,.75547,-1.60529,-.00405,.7616,-1.60237,-.01743,.76187,-1.60224,-.01683,.73848,-1.61334,.0338,.67278,-1.64518,.07636,.57475,-1.69291,.10438,.45934,-1.74926,.11359,.3441,-1.80565,.10259,.24658,-1.8535,.07305,.18164,-1.88553,.02948,.15914,-1.89685,-.02151,1.18655,-3.0283,.11548,2.36829,-3.19642,-.15092,2.70752,-3.13945,-.31996,2.37945,-3.19898,-.15163,2.79047,-3.16136,-.33343,2.38804,-3.20394,-.1509,2.37955,-3.19902,-.15164,2.34655,-3.19109,-.14951,2.66118,-3.11883,-.32604,2.35598,-3.1933,-.15011,2.31342,-3.18177,-.14728,2.55838,-3.08672,-.31738,2.32902,-3.18533,-.14827,2.27063,-3.16848,-.14432,2.41175,-3.04875,-.29233};
			return value;
		}
		private double[] getairway_Coord_9_53_point_5()
		{
			double[] value = {2.29053,-3.17309,-.1456,2.24858,-3.15728,-.14252,2.32465,-3.04135,-.25284,2.25815,-3.16032,-.14319,2.22603,-3.13355,-.13584,2.24571,-3.05666,-.18127,2.23268,-3.13696,-.13767,2.24289,-3.14788,-.14165,2.21211,-3.08595,-.12371,2.21269,-3.07878,-.12583,2.21243,-3.08663,-.1239,2.20726,-3.07944,-.12154,2.53619,-3.33173,.08404,2.55121,-3.33572,.09127,2.5357,-3.33134,.0842,2.52317,-3.32347,.08796,2.5935,-3.3475,.06601,2.63084,-3.35752,.07957,2.59283,-3.34736,.06633,2.57592,-3.34265,.07501,2.61385,-3.35311,.0556,2.67066,-3.36842,.07373,2.6134,-3.35302,.05581,2.68472,-3.35314,.01906,2.73792,-3.36563,.02941,2.68375,-3.35347,.01982,2.6721,-3.35541,.03207,2.71686,-3.3475,-.01428,2.79064,-3.36319,-.00574,2.71591,-3.34783,-.01355,2.67472,-3.31198,-.08783,2.91042,-3.35105,-.0963,2.6802,-3.31618,-.08382,2.72117,-3.34666,-.01863,2.70619,-3.32581,-.06941,2.64502,-3.30013,-.10467,2.95981,-3.34849,-.12967,2.64714,-3.30189,-.10305,2.58385,-3.27802,-.12409,3.01756,-3.33329,-.18852,2.59316,-3.28286,-.1215,2.63169,-3.29412,-.11254,2.54458,-3.264,-.13373,3.05954,-3.31925,-.23614,2.5518,-3.26818,-.13164,2.51888,-3.25287,-.14043,3.06437,-3.29959,-.27094,2.52559,-3.25689,-.13846,2.48491,-3.24033,-.14365,3.01816,-3.26949,-.29249,2.49762,-3.24515,-.1427,2.51526,-3.25107,-.14142,2.42514,-3.21787,-.14813,2.88281,-3.20518,-.31689,2.44927,-3.22683,-.14633,2.40412,-3.20991,-.14971,3.78379,-2.65266,-.60419,3.98898,-2.69613,-.65003,3.6661,-2.60566,-.60941,3.41003,-2.53836,-.57083,3.04766,-2.46359,-.48701,2.83797,-2.46029,-.38145,2.656,-2.51703,-.20475,2.29856,-2.96473,-.11367,2.3128,-2.94603,-.11228,2.31943,-2.937,-.11072,2.58568,-2.58338,-.07304,2.22507,-3.058,-.1202,2.39384,-2.75569,-.02831,2.49586,-2.60346,.00288,2.41103,-2.74585,-.03568,2.45918,-2.72621,-.06844,2.29199,-2.86943,.03254,2.27244,-2.89278,.03547,2.42004,-2.66063,.12436,2.31014,-2.84962,.02611,2.39916,-2.7443,-.01778,2.25143,-2.98795,.07012,2.44531,-2.73018,.21037,2.26295,-2.95184,.05835,2.25825,-3.04931,.08641,2.49951,-2.7868,.26271,2.2599,-3.01816,.08048,2.25658,-2.99494,.07526,2.70926,-2.92653,.35191,2.30336,-3.0936,.10311,2.30479,-3.09623,.10389,2.31597,-3.16449,.10843,3.05395,-3.0467,.34222,2.38655,-3.17938,.11304,2.399,-3.18371,.11395,2.471,-3.23297,.1073,3.48452,-3.21517,.35631,2.50827,-3.25624,.10399,2.50921,-3.25744,.10387,3.68175,-3.25896,.31512,3.78037,-3.28086,.29452,3.93917,-3.26034,.18171,4.06355,-3.24356,.09235,4.34371,-3.18756,-.13493};
			return value;
		}
		private double[] getairway_Coord_9_53_point_6()
		{
			double[] value = {4.46014,-3.17111,-.21966,4.59177,-3.11875,-.36364,4.68638,-3.07259,-.47929,4.69061,-3.01832,-.559,4.56975,-2.94557,-.59932,4.2245,-2.79719,-.6296,4.49104,-2.06051,-.70641,4.73103,-2.12789,-.74378,4.35728,-2.00026,-.72614,4.06007,-1.9034,-.70384,3.63588,-1.78636,-.63411,3.38336,-1.75774,-.51922,3.15372,-1.79124,-.30835,3.05713,-1.84767,-.14401,2.94517,-1.85645,-.05469,2.84357,-1.90322,.09569,2.8618,-1.97435,.21083,2.91723,-2.03632,.28515,3.14575,-2.19847,.42469,3.5406,-2.35782,.44986,4.03058,-2.57481,.51551,4.26091,-2.64155,.48334,4.37608,-2.67492,.46726,4.57137,-2.67406,.33731,4.72446,-2.67269,.23421,5.0725,-2.6518,-.03195,5.21593,-2.64979,-.12986,5.38405,-2.61448,-.3035,5.50639,-2.58076,-.4442,5.52107,-2.52816,-.54787,5.38803,-2.44232,-.6138,4.99748,-2.25531,-.69125,4.99995,-1.32968,-.83582,5.26633,-1.42168,-.89129,4.84682,-1.26208,-.8534,4.51416,-1.1385,-.81335,4.04376,-.97737,-.71091,3.77217,-.911,-.56218,3.53744,-.89348,-.29973,3.44742,-.91657,-.09889,3.33143,-.90259,.01295,3.23416,-.91783,.19731,3.26797,-.97231,.33416,3.33904,-1.02696,.42052,3.61285,-1.18507,.57708,4.06109,-1.37131,.58941,4.62129,-1.61628,.64587,4.87737,-1.70606,.59704,5.00541,-1.75096,.57262,5.21072,-1.78574,.40847,5.37152,-1.81252,.27832,5.73342,-1.86058,-.05557,5.88392,-1.88513,-.17909,6.05355,-1.89021,-.39426,6.17533,-1.88812,-.56799,6.17995,-1.85293,-.6926,6.02231,-1.76705,-.76544,5.5729,-1.56167,-.84047,5.51514,-.30651,-.78092,5.77258,-.41008,-.83356,5.36505,-.23973,-.80061,5.04233,-.10612,-.76439,4.5879,.07612,-.6669,4.32933,.16822,-.52015,4.11152,.22822,-.25809,4.03223,.23656,-.05641,3.92384,.26882,.05505,3.83678,.28262,.24001,3.87555,.24841,.37863,3.94851,.20597,.46675,4.22217,.06825,.62832,4.65984,-.1215,.64645,5.20856,-.36464,.71057,5.45624,-.46486,.66451,5.58008,-.51498,.64148,5.77336,-.57703,.47832,5.92467,-.6254,.34892,6.26348,-.72826,.01632,6.45071,-.80358,-.02196,6.56135,-.8129,-.32164,6.52223,-.80647,-.24037,6.672,-.82223,-.62133,6.51517,-.74547,-.69688,6.07371,-.54606,-.77835,5.82767,.60233,-.76994,6.08949,.497,-.82348,5.67502,.67024,-.78997,5.3468,.80613,-.75313,4.88464,.99147,-.65398,4.62167,1.08514,-.50473,4.40014,1.14616,-.23821,4.3195,1.15464,-.03309,4.20927,1.18746,.08027,4.12073,1.20149,.26837,4.16015,1.1667,.40935,4.23436,1.12353,.49897,4.51268,.98346,.6633,4.9578,.79049,.68174,5.51586,.54321,.74695,5.89371,.39031,.67668};
			return value;
		}
		private double[] getairway_Coord_9_53_point_7()
		{
			double[] value = {5.76776,.44128,.7001,6.09028,.3272,.51074,6.24416,.27801,.37914,6.58874,.1734,.04088,6.77916,.09679,.00195,6.89169,.08731,-.30284,6.85189,.09386,-.22019,7.00421,.07783,-.60763,6.84472,.1559,-.68447,6.39574,.3587,-.76733,5.89023,1.72095,-.6538,6.14152,1.64386,-.69944,5.74832,1.78409,-.67241,5.43602,1.89149,-.64192,4.99204,2.02592,-.55725,4.7311,2.06944,-.42713,4.49868,2.0561,-.19324,4.40439,2.01286,-.01268,4.29046,2.01306,.0867,4.19025,1.97876,.2522,4.21474,1.91422,.37688,4.27658,1.85516,.45645,4.52388,1.69464,.60321,4.94127,1.5247,.62223,5.46081,1.2967,.68323,5.70216,1.22087,.64344,5.82283,1.18296,.62354,6.02275,1.16974,.47827,6.17941,1.15999,.36306,6.53411,1.15363,.0666,6.71686,1.09757,.03341,6.8501,1.1645,-.23493,6.80523,1.14975,-.16222,6.98334,1.23144,-.50327,6.84007,1.31727,-.57208,6.42481,1.5115,-.64799,5.67323,2.49762,-.6074,5.90489,2.42757,-.64908,5.54256,2.55576,-.62454,5.25474,2.65379,-.59677,4.84541,2.77587,-.51943,4.60454,2.81398,-.40034,4.38956,2.79855,-.18612,4.30203,2.75643,-.02071,4.1967,2.75526,.07031,4.10378,2.72155,.22191,4.12588,2.66067,.33619,4.18255,2.60543,.40914,4.40984,2.45627,.54378,4.7943,2.30022,.56145,5.2727,2.09037,.61765,5.49518,2.0214,.58131,5.60642,1.98692,.56315,5.79114,1.97679,.43014,5.93589,1.96943,.32464,6.26374,1.96767,.05316,6.43223,1.91673,.02285,6.55597,1.98176,-.22299,6.51436,1.96725,-.15638,6.6797,2.0468,-.46883,6.54797,2.12643,-.53197,6.16569,2.30553,-.60177,5.56361,3.11029,-.45523,5.7719,3.06141,-.49191,5.44658,3.16089,-.46691,5.18806,3.23522,-.44046,4.81999,3.31948,-.37272,4.60257,3.32738,-.27428,4.4073,3.27329,-.10051,4.32692,3.20697,.0325,4.23141,3.18837,.10654,4.14635,3.13156,.22863,4.16489,3.0599,.31927,4.21492,3.00083,.37649,4.41731,2.85344,.48025,4.76201,2.72312,.48852,5.19055,2.54159,.52604,5.39055,2.49255,.49376,5.49055,2.46804,.47762,5.65775,2.48559,.36895,5.78879,2.50007,.28278,6.08595,2.55128,.06172,6.23744,2.51573,.03505,6.3512,2.61629,-.16252,6.31313,2.59157,-.10887,6.46496,2.71685,-.36009,6.34749,2.79384,-.40837,6.00533,2.953,-.45817,4.93848,3.86649,.07916,4.98247,3.86142,.07229,4.91339,3.87614,.07832,4.85858,3.88646,.08407,4.78088,3.89479,.09664,4.73567,3.88738,.11258,4.69605,3.86272,.13935,4.68045,3.83961,.15933,4.66095,3.82986,.17082,4.64423,3.80933,.18924,4.64923,3.78907,.20232,4.66056,3.77392,.2103};
			return value;
		}
		private double[] getairway_Coord_9_53_point_8()
		{
			double[] value = {4.70492,3.73959,.22394,4.77851,3.71666,.22263,4.87032,3.68241,.22496,4.91259,3.67693,.21879,4.93373,3.67418,.2157,4.96812,3.68683,.19863,4.99506,3.69696,.18511,5.05585,3.72533,.15071,5.08784,3.72164,.14571,5.10981,3.75633,.11607,5.10231,3.74735,.12417,5.13177,3.79102,.08643,5.10616,3.80843,.08025,5.03263,3.83996,.0755,.5794,-1.69183,.0954,.67716,-1.64377,.06704,.74257,-1.61162,.02425,.74294,-1.61147,-.07736,.67785,-1.6435,-.12071,.58029,-1.69148,-.14991,.46514,-1.74812,-.16052,.34991,-1.80478,-.15091,.25215,-1.85285,-.12255,.18674,-1.885,-.07976,.16364,-1.89634,-.02906,.18637,-1.88514,.02185,.25146,-1.85312,.0652,.34902,-1.80513,.0944,.46417,-1.7485,.10501,1.1945,-3.02574,.0986,1.2599,-3.0386,.09464,1.17779,-3.16082,.10422,1.39533,-3.06508,.06625,1.48583,-3.0826,.02343,1.51764,-3.08849,-.02729,1.4859,-3.08185,-.07818,1.39545,-3.0637,-.12151,1.27717,-3.0402,-.14698,1.27717,-3.07067,-.15069,1.24787,-3.29722,-.16138,1.19376,-3.47485,-.15184,1.12307,-3.5765,-.12352,1.06751,-3.58391,-.09243,1.05677,-3.60687,-.08073,1.02989,-3.61074,-.03002,1.0242,-3.56879,-.00219,1.03637,-3.56739,.02091,1.07547,-3.4839,.06429,1.11427,-3.35475,.08929,1.12449,-3.33987,.09354,2.18799,-3.53164,.10267,2.20886,-3.34603,.11325,2.19719,-3.57643,.09193,2.18632,-3.67523,.07356,2.18966,-3.76725,.03028,2.20323,-3.77487,.00083,2.18653,-3.80306,-.02062,2.16312,-3.7894,-.07143,2.16164,-3.75045,-.08953,2.12315,-3.72824,-.11443,2.09762,-3.60759,-.14298,2.11705,-3.4231,-.15262,2.17451,-3.2171,-.14259,2.16417,-3.21507,-.14195,2.02868,-3.18858,-.11334,1.93809,-3.17104,-.07039,1.90619,-3.16513,-.01962,1.93784,-3.17175,.03123,2.02822,-3.18989,.07441,2.16357,-3.21678,.10336,2.24137,-3.23216,.10838,1.1486,-5.96164,.22464,.924,-5.91723,.20612,.7336,-5.87931,.15449,.60641,-5.85367,.0776,.56177,-5.84419,-.01282,.60649,-5.85233,-.10303,.73375,-5.87685,-.17929,.9242,-5.91401,-.22998,1.14882,-5.95815,-.24739,1.37342,-6.00256,-.22887,1.56381,-6.04048,-.17724,1.69101,-6.06612,-.10035,1.73565,-6.0756,-.00992,1.69093,-6.06746,.08028,1.56366,-6.04294,.15654,1.37322,-6.00578,.20723,1.30886,-3.04879,.16772,1.49925,-3.08671,.21935,1.72386,-3.13112,.23787,1.94848,-3.17526,.22046,2.13892,-3.21242,.16977,2.13907,-3.20996,-.16401,1.94868,-3.17204,-.21564,1.72407,-3.12763,-.23416,1.49945,-3.08349,-.21675,1.30901,-3.04633,-.16606};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getGeoSculptedSurface1_9_71_coordIndex_1()
		{
			int[] value = {0,1,29,-1,0,29,28,-1,1,2,30,-1,1,30,29,-1,2,3,31,-1,2,31,30,-1,3,4,32,-1,3,32,31,-1,4,5,33,-1,4,33,32,-1,5,6,34,-1,5,34,33,-1,6,7,35,-1,6,35,34,-1,7,8,36,-1,7,36,35,-1,8,9,37,-1,8,37,36,-1,9,10,38,-1,9,38,37,-1,10,11,39,-1,10,39,38,-1,11,12,40,-1,11,40,39,-1,12,13,41,-1,12,41,40,-1,13,14,42,-1,13,42,41,-1,14,15,43,-1,14,43,42,-1,15,16,44,-1,15,44,43,-1,16,17,45,-1,16,45,44,-1,17,18,46,-1,17,46,45,-1,18,19,47,-1,18,47,46,-1,19,20,48,-1,19,48,47,-1,20,21,49,-1,20,49,48,-1,21,22,50,-1,21,50,49,-1,22,23,51,-1,22,51,50,-1,23,24,52,-1,23,52,51,-1,24,25,53,-1,24,53,52,-1,25,26,54,-1,25,54,53,-1,26,27,55,-1,26,55,54,-1,28,29,57,-1,28,57,56,-1,29,30,58,-1,29,58,57,-1,30,31,59,-1,30,59,58,-1,31,32,60,-1,31,60,59,-1,32,33,61,-1,32,61,60,-1,33,34,62,-1,33,62,61,-1,34,35,63,-1,34,63,62,-1,35,36,64,-1,35,64,63,-1,36,37,65,-1,36,65,64,-1,37,38,66,-1,37,66,65,-1,38,39,67,-1,38,67,66,-1,39,40,68,-1,39,68,67,-1,40,41,69,-1,40,69,68,-1,41,42,70,-1,41,70,69,-1,42,43,71,-1,42,71,70,-1,43,44,72,-1,43,72,71,-1,44,45,73,-1,44,73,72,-1,45,46,74,-1,45,74,73,-1,46,47,75,-1,46,75,74,-1,47,48,76,-1,47,76,75,-1,48,49,77,-1,48,77,76,-1,49,50,78,-1,49,78,77,-1,50,51,79,-1,50,79,78,-1,51,52,80,-1,51,80,79,-1,52,53,81,-1,52,81,80,-1,53,54,82,-1,53,82,81,-1,54,55,83,-1,54,83,82,-1,56,57,85,-1,56,85,84,-1,57,58,86,-1,57,86,85,-1,58,59,87,-1,58,87,86,-1,59,60,88,-1,59,88,87,-1,60,61,89,-1,60,89,88,-1,61,62,90,-1,61,90,89,-1,62,63,91,-1,62,91,90,-1,63,64,92,-1,63,92,91,-1,64,65,93,-1,64,93,92,-1,65,66,94,-1,65,94,93,-1,66,67,95,-1,66,95,94,-1,67,68,96,-1,67,96,95,-1,68,69,97,-1,68,97,96,-1,69,70,98,-1,69,98,97,-1,70,71,99,-1,70,99,98,-1,71,72,100,-1,71,100,99,-1,72,73,101,-1,72,101,100,-1,73,74,102,-1,73,102,101,-1,74,75,103,-1,74,103,102,-1,75,76,104,-1,75,104,103,-1,76,77,105,-1,76,105,104,-1,77,78,106,-1,77,106,105,-1,78,79,107,-1,78,107,106,-1,79,80,108,-1,79,108,107,-1,80,81,109,-1,80,109,108,-1,81,82,110,-1,81,110,109,-1,82,83,111,-1,82,111,110,-1,84,85,113,-1,84,113,112,-1,85,86,114,-1,85,114,113,-1,86,87,115,-1,86,115,114,-1,87,88,116,-1,87,116,115,-1,88,89,117,-1,88,117,116,-1,89,90,118,-1,89,118,117,-1,90,91,119,-1,90,119,118,-1,91,92,120,-1,91,120,119,-1,92,93,121,-1,92,121,120,-1,93,94,122,-1,93,122,121,-1,94,95,123,-1,94,123,122,-1,95,96,124,-1,95,124,123,-1,96,97,125,-1,96,125,124,-1,97,98,126,-1,97,126,125,-1,98,99,127,-1,98,127,126,-1,99,100,128,-1,99,128,127,-1,100,101,129,-1,100,129,128,-1,101,102,130,-1,101,130,129,-1,102,103,131,-1,102,131,130,-1,103,104,132,-1,103,132,131,-1,104,105,133,-1,104,133,132,-1,105,106,134,-1,105,134,133,-1,106,107,135,-1,106,135,134,-1,107,108,136,-1,107,136,135,-1,108,109,137,-1,108,137,136,-1,109,110,138,-1,109,138,137,-1,110,111,139,-1,110,139,138,-1,112,113,141,-1,112,141,140,-1,113,114,142,-1,113,142,141,-1,114,115,143,-1,114,143,142,-1,115,116,144,-1,115,144,143,-1,116,117,145,-1,116,145,144,-1,117,118,146,-1,117,146,145,-1,118,119,147,-1,118,147,146,-1,119,120,148,-1,119,148,147,-1,120,121,149,-1,120,149,148,-1,121,122,150,-1,121,150,149,-1,122,123,151,-1,122,151,150,-1,123,124,152,-1,123,152,151,-1,124,125,153,-1,124,153,152,-1,125,126,154,-1,125,154,153,-1,126,127,155,-1,126,155,154,-1,127,128,156,-1,127,156,155,-1,128,129,157,-1,128,157,156,-1};
			return value;
		}
		private int[] getGeoSculptedSurface1_9_71_coordIndex_2()
		{
			int[] value = {129,130,158,-1,129,158,157,-1,130,131,159,-1,130,159,158,-1,131,132,160,-1,131,160,159,-1,132,133,161,-1,132,161,160,-1,133,134,162,-1,133,162,161,-1,134,135,163,-1,134,163,162,-1,135,136,164,-1,135,164,163,-1,136,137,165,-1,136,165,164,-1,137,138,166,-1,137,166,165,-1,138,139,167,-1,138,167,166,-1,140,141,169,-1,140,169,168,-1,141,142,170,-1,141,170,169,-1,142,143,171,-1,142,171,170,-1,143,144,172,-1,143,172,171,-1,144,145,173,-1,144,173,172,-1,145,146,174,-1,145,174,173,-1,146,147,175,-1,146,175,174,-1,147,148,176,-1,147,176,175,-1,148,149,177,-1,148,177,176,-1,149,150,178,-1,149,178,177,-1,150,151,179,-1,150,179,178,-1,151,152,180,-1,151,180,179,-1,152,153,181,-1,152,181,180,-1,153,154,182,-1,153,182,181,-1,154,155,183,-1,154,183,182,-1,155,156,184,-1,155,184,183,-1,156,157,185,-1,156,185,184,-1,157,158,186,-1,157,186,185,-1,158,159,187,-1,158,187,186,-1,159,160,188,-1,159,188,187,-1,160,161,189,-1,160,189,188,-1,161,162,190,-1,161,190,189,-1,162,163,191,-1,162,191,190,-1,163,164,192,-1,163,192,191,-1,164,165,193,-1,164,193,192,-1,165,166,194,-1,165,194,193,-1,166,167,195,-1,166,195,194,-1,168,169,197,-1,168,197,196,-1,169,170,198,-1,169,198,197,-1,170,171,199,-1,170,199,198,-1,171,172,200,-1,171,200,199,-1,172,173,201,-1,172,201,200,-1,173,174,202,-1,173,202,201,-1,174,175,203,-1,174,203,202,-1,175,176,204,-1,175,204,203,-1,176,177,205,-1,176,205,204,-1,177,178,206,-1,177,206,205,-1,178,179,207,-1,178,207,206,-1,179,180,208,-1,179,208,207,-1,180,181,209,-1,180,209,208,-1,181,182,210,-1,181,210,209,-1,182,183,211,-1,182,211,210,-1,183,184,212,-1,183,212,211,-1,184,185,213,-1,184,213,212,-1,185,186,214,-1,185,214,213,-1,186,187,215,-1,186,215,214,-1,187,188,216,-1,187,216,215,-1,188,189,217,-1,188,217,216,-1,189,190,218,-1,189,218,217,-1,190,191,219,-1,190,219,218,-1,191,192,220,-1,191,220,219,-1,192,193,221,-1,192,221,220,-1,193,194,222,-1,193,222,221,-1,194,195,223,-1,194,223,222,-1,196,197,225,-1,196,225,224,-1,197,198,226,-1,197,226,225,-1,198,199,227,-1,198,227,226,-1,199,200,228,-1,199,228,227,-1,200,201,229,-1,200,229,228,-1,201,202,230,-1,201,230,229,-1,202,203,231,-1,202,231,230,-1,203,204,232,-1,203,232,231,-1,204,205,233,-1,204,233,232,-1,205,206,234,-1,205,234,233,-1,206,207,235,-1,206,235,234,-1,207,208,236,-1,207,236,235,-1,208,209,237,-1,208,237,236,-1,209,210,238,-1,209,238,237,-1,210,211,239,-1,210,239,238,-1,211,212,240,-1,211,240,239,-1,212,213,241,-1,212,241,240,-1,213,214,242,-1,213,242,241,-1,214,215,243,-1,214,243,242,-1,215,216,244,-1,215,244,243,-1,216,217,245,-1,216,245,244,-1,217,218,246,-1,217,246,245,-1,218,219,247,-1,218,247,246,-1,219,220,248,-1,219,248,247,-1,220,221,249,-1,220,249,248,-1,221,222,250,-1,221,250,249,-1,222,223,251,-1,222,251,250,-1,224,225,253,-1,224,253,252,-1,225,226,254,-1,225,254,253,-1,226,227,255,-1,226,255,254,-1,227,228,256,-1,227,256,255,-1,228,229,257,-1,228,257,256,-1,229,230,258,-1,229,258,257,-1,230,231,259,-1,230,259,258,-1,231,232,260,-1,231,260,259,-1,232,233,261,-1,232,261,260,-1,233,234,262,-1,233,262,261,-1,234,235,263,-1,234,263,262,-1,235,236,264,-1,235,264,263,-1,236,237,265,-1,236,265,264,-1,237,238,266,-1,237,266,265,-1,238,239,267,-1,238,267,266,-1,239,240,268,-1,239,268,267,-1,240,241,269,-1,240,269,268,-1,241,242,270,-1,241,270,269,-1,242,243,271,-1,242,271,270,-1,243,244,272,-1,243,272,271,-1,244,245,273,-1,244,273,272,-1,245,246,274,-1,245,274,273,-1,246,247,275,-1,246,275,274,-1,247,248,276,-1,247,276,275,-1,248,249,277,-1,248,277,276,-1,249,250,278,-1,249,278,277,-1,250,251,279,-1,250,279,278,-1,252,253,281,-1,252,281,280,-1,253,254,282,-1,253,282,281,-1,254,255,283,-1,254,283,282,-1,255,256,284,-1,255,284,283,-1,256,257,285,-1,256,285,284,-1,257,258,286,-1,257,286,285,-1,258,259,287,-1,258,287,286,-1};
			return value;
		}
		private int[] getGeoSculptedSurface1_9_71_coordIndex_3()
		{
			int[] value = {259,260,288,-1,259,288,287,-1,260,261,289,-1,260,289,288,-1,261,262,290,-1,261,290,289,-1,262,263,291,-1,262,291,290,-1,263,264,292,-1,263,292,291,-1,264,265,293,-1,264,293,292,-1,265,266,294,-1,265,294,293,-1,266,267,295,-1,266,295,294,-1,267,268,296,-1,267,296,295,-1,268,269,297,-1,268,297,296,-1,269,270,298,-1,269,298,297,-1,270,271,299,-1,270,299,298,-1,271,272,300,-1,271,300,299,-1,272,273,301,-1,272,301,300,-1,273,274,302,-1,273,302,301,-1,274,275,303,-1,274,303,302,-1,275,276,304,-1,275,304,303,-1,276,277,305,-1,276,305,304,-1,277,278,306,-1,277,306,305,-1,278,279,307,-1,278,307,306,-1,281,282,283,-1,281,283,304,-1,281,304,305,-1,281,305,306,-1,281,306,280,-1,295,296,291,-1,295,291,292,-1,295,292,293,-1,295,293,294,-1,296,297,289,-1,296,289,290,-1,296,290,291,-1,299,300,286,-1,299,286,287,-1,299,287,288,-1,299,288,289,-1,299,289,297,-1,283,284,303,-1,303,284,285,-1,303,285,301,-1,301,285,286,-1,301,286,300,-1,304,283,303,-1,303,301,302,-1,11,10,16,-1,11,16,15,-1,11,15,14,-1,11,14,13,-1,11,13,12,-1,9,8,19,-1,9,19,18,-1,9,18,16,-1,9,16,10,-1,21,20,6,-1,6,20,19,-1,6,19,7,-1,7,19,8,-1,2,24,3,-1,3,24,23,-1,3,23,4,-1,4,23,22,-1,4,22,5,-1,5,22,21,-1,5,21,6,-1,1,0,26,-1,1,26,25,-1,1,25,24,-1,1,24,2,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_71_point_1()
		{
			double[] value = {-1.15086,-3.15436,-.04591,-1.16427,-3.15687,-.04319,-1.17304,-3.1567,-.04366,-1.19041,-3.15888,-.04147,-1.21398,-3.16345,-.03648,-1.22564,-3.169,-.02993,-1.23282,-3.17814,-.01877,-1.23339,-3.18489,-.01037,-1.23732,-3.18883,-.00559,-1.23865,-3.19507,.00214,-1.23383,-3.19942,.0077,-1.22806,-3.20204,.01113,-1.20964,-3.20639,.0171,-1.1848,-3.20561,.01687,-1.15286,-3.20596,.01826,-1.13988,-3.20369,.01583,-1.13339,-3.20256,.01462,-1.12569,-3.19669,.00754,-1.12569,-3.19669,.00754,-1.1197,-3.19204,.00193,-1.10711,-3.18025,-.01237,-1.10154,-3.17584,-.01769,-1.09691,-3.16841,-.0268,-1.09401,-3.16245,-.03414,-1.09646,-3.15839,-.03926,-1.10668,-3.15645,-.04199,-1.13295,-3.1552,-.04433,-1.15086,-3.15436,-.04591,-.81783,-2.94135,-.32187,-.89581,-2.95224,-.29827,-.9478,-2.95224,-.29827,-1.04941,-2.96214,-.27681,-1.18647,-2.98193,-.23389,-1.25264,-3.0047,-.18454,-1.29044,-3.04132,-.10514,-1.29044,-3.06804,-.04721,-1.31171,-3.08388,-.01287,-1.31644,-3.10862,.04077,-1.28572,-3.12545,.07725,-1.25027,-3.13535,.09871,-1.13921,-3.15118,.13304,-.9927,-3.14623,.12231,-.80365,-3.14524,.12017,-.72803,-3.13535,.09871,-.69022,-3.1304,.08798,-.64769,-3.10664,.03648,-.64769,-3.10664,.03648,-.6146,-3.08784,-.00429,-.54607,-3.04033,-.10729,-.51535,-3.02251,-.14592,-.49172,-2.99282,-.21029,-.47754,-2.96907,-.26179,-.49409,-2.95323,-.29612,-.55553,-2.9463,-.31114,-.71149,-2.94333,-.31758,-.81783,-2.94135,-.32187,-.05635,-2.08302,-.77355,-.24023,-2.11831,-.70308,-.36631,-2.12203,-.69316,-.60798,-2.15631,-.62323,-.93084,-2.22014,-.49599,-1.08034,-2.287,-.36711,-1.15439,-2.38966,-.17287,-1.1415,-2.4626,-.03639,-1.18545,-2.50735,.04854,-1.18498,-2.57523,.17582,-1.10237,-2.61896,.25589,-1.01163,-2.64344,.29968,-.73463,-2.67872,.35937,-.38168,-2.65474,.30616,.07633,-2.63853,.26504,.25496,-2.6061,.20007,.34427,-2.58989,.16759,.43598,-2.52201,.03816,.43598,-2.52201,.03816,.50715,-2.46832,-.06419,.65045,-2.33375,-.3199,.71636,-2.28292,-.41674,.75936,-2.20019,-.5729,.7823,-2.13433,-.69692,.73454,-2.09229,-.77464,.58219,-2.07777,-.79831,.20251,-2.08082,-.78372,-.05635,-2.08302,-.77355,.33792,-1.28338,-.95043,.1101,-1.31142,-.88367,-.04107,-1.311,-.8858,-.3375,-1.33625,-.82637,-.73797,-1.38726,-.7048,-.93258,-1.44667,-.56127,-1.0461,-1.54278,-.32757,-1.0487,-1.61314,-.1559,-1.11209,-1.65467,-.05504,-1.12824,-1.71978,.10372,-1.04056,-1.76433,.21306,-.93845,-1.79067,.27809,-.61704,-1.83326,.38435,-.19054,-1.82141,.35855,.35927,-1.82032,.35991,.58011,-1.79487,.29942};
			return value;
		}
		private double[] getCoordinate_10_71_point_2()
		{
			double[] value = {.69054,-1.78215,.26917,.81654,-1.71995,.11832,.81654,-1.71995,.11832,.91457,-1.6707,-.00113,1.11847,-1.54617,-.30352,1.20954,-1.49951,-.41671,1.28115,-1.42152,-.60649,1.32469,-1.35909,-.7585,1.27814,-1.31726,-.86091,1.10016,-1.29852,-.90792,.64694,-1.28945,-.93337,.33792,-1.28338,-.95043,.4716,-.44479,-1.15281,.21683,-.45855,-1.06488,.04616,-.45874,-1.06243,-.28629,-.47136,-.98104,-.73399,-.49636,-.82138,-.94864,-.52476,-.64208,-1.06864,-.5702,-.35688,-1.06564,-.60325,-.15005,-1.13367,-.62292,-.02649,-1.14641,-.65354,.16524,-1.04367,-.67424,.29402,-.92619,-.68635,.36895,-.55981,-.70552,.48628,-.07941,-.69885,.44108,.54107,-.69692,.42452,.78819,-.6844,.34436,.91175,-.67813,.30427,1.04872,-.64859,.11843,1.04872,-.64859,.11843,1.15521,-.62521,-.02868,1.37483,-.56619,-.39959,1.47367,-.54404,-.53892,1.54791,-.50723,-.76984,1.59178,-.47779,-.95435,1.5357,-.45827,-1.07614,1.33323,-.44993,-1.12687,.8209,-.44684,-1.1425,.4716,-.44479,-1.15281,.52968,.68564,-1.14809,.2771,.68564,-1.0639,.10872,.68564,-1.0639,-.2204,.68564,-.98736,-.66433,.68564,-.83428,-.87864,.68564,-.65824,-1.00111,.68564,-.37504,-1.00111,.68564,-.16839,-1.06999,.68564,-.04592,-1.0853,.68564,.14543,-.9858,.68564,.27554,-.87099,.68564,.35208,-.51125,.68564,.47455,-.03671,.68564,.43628,.57561,.68564,.42862,.82053,.68564,.35208,.943,.68564,.31381,1.08077,.68564,.13012,1.08077,.68564,.13012,1.18792,.68564,-.01531,1.40989,.68564,-.3827,1.59358,.68564,-.44393,1.58593,.68564,-.75009,1.57828,.68564,-.66589,1.57828,.68564,-1.05625,1.37927,.68564,-1.10982,.87411,.68564,-1.13278,.52968,.68564,-1.14809,.4443,1.64073,-1.16764,.18741,1.64073,-1.08201,.01616,1.64073,-1.08201,-.31856,1.64073,-1.00417,-.77005,1.64073,-.84849,-.98801,1.64073,-.66945,-1.11256,1.64073,-.38143,-1.11256,1.64073,-.17125,-1.18262,1.64073,-.04671,-1.19819,1.64073,.1479,-1.09699,1.64073,.28023,-.98023,1.64073,.35808,-.61437,1.64073,.48262,-.13174,1.64073,.4437,.491,1.64073,.43592,.7401,1.64073,.35808,.86465,1.64073,.31915,1.00476,1.64073,.13233,1.00476,1.64073,.13233,1.11374,1.64073,-.01557,1.33949,1.64073,-.38921,1.52631,1.64073,-.45149,1.51852,1.64073,-.76286,1.51074,1.64073,-.67723,1.51074,1.64073,-1.07423,1.30835,1.64073,-1.12872,.79459,1.64073,-1.15207,.4443,1.64073,-1.16764,.06642,2.72464,-1.0408,-.1724,2.70202,-.96447,-.33161,2.70202,-.96447,-.6428,2.68146,-.89508};
			return value;
		}
		private double[] getCoordinate_10_71_point_3()
		{
			double[] value = {-1.06254,2.64033,-.75631,-1.26518,2.59303,-.59672,-1.38097,2.51695,-.33999,-1.38097,2.46143,-.15265,-1.4461,2.42853,-.04163,-1.46057,2.37712,.13183,-1.36649,2.34216,.24979,-1.25794,2.3216,.31918,-.9178,2.28869,.4302,-.46911,2.29898,.3955,.10984,2.30103,.38856,.34142,2.3216,.31918,.45722,2.33188,.28448,.58748,2.38123,.11796,.58748,2.38123,.11796,.6888,2.4203,-.01388,.89867,2.519,-.34693,1.07236,2.53546,-.40244,1.06512,2.61771,-.67999,1.05788,2.59509,-.60366,1.05788,2.69996,-.95753,.86972,2.71436,-1.0061,.39208,2.72053,-1.02692,.06642,2.72464,-1.0408,-.44707,3.35471,-.95414,-.66697,3.33287,-.88417,-.81356,3.33287,-.88417,-1.1001,3.31302,-.82056,-1.48658,3.27331,-.69334,-1.67316,3.22765,-.54704,-1.77978,3.1542,-.31169,-1.77978,3.10059,-.13994,-1.83975,3.06883,-.03817,-1.85308,3.0192,.12086,-1.76645,2.98545,.22899,-1.6665,2.9656,.2926,-1.35331,2.93383,.39438,-.94017,2.94376,.36257,-.40709,2.94574,.35621,-.19385,2.9656,.2926,-.08724,2.97552,.2608,.03271,3.02317,.10814,.03271,3.02317,.10814,.126,3.06089,-.01272,.31924,3.15618,-.31805,.47916,3.17206,-.36893,.4725,3.25147,-.62337,.46584,3.22964,-.5534,.46584,3.33088,-.87781,.29258,3.34478,-.92234,-.14721,3.35074,-.94142,-.44707,3.35471,-.95414,-.76754,3.90069,-.77763,-.95977,3.86806,-.71565,-1.08911,3.86714,-.71208,-1.3403,3.83693,-.65362,-1.67805,3.77768,-.54126,-1.83893,3.71116,-.41832,-1.92699,3.60538,-.22527,-1.92261,3.52867,-.08629,-1.97293,3.48283,-.00247,-1.98062,3.41172,.12654,-1.90143,3.36397,.21193,-1.81162,3.33618,.26097,-1.5327,3.29269,.3357,-1.169,3.30949,.2999,-.69882,3.31568,.28176,-.51231,3.34543,.22509,-.41905,3.3603,.19676,-.31712,3.42924,.0703,-.31712,3.42924,.0703,-.2379,3.48381,-.02978,-.07519,3.62139,-.28156,.06461,3.64512,-.32663,.05224,3.75872,-.53237,.04815,3.72743,-.47558,.03987,3.87232,-.7381,-.11413,3.89112,-.76991,-.50265,3.89689,-.77464,-.76754,3.90069,-.77763,-1.59172,4.38879,-.12128,-1.63048,4.37699,-.1091,-1.65711,4.37589,-.10673,-1.70808,4.36452,-.09426,-1.77614,4.34316,-.07232,-1.80755,4.32053,-.05127,-1.82294,4.28556,-.02054,-1.82003,4.26062,.00064,-1.8292,4.2454,.01415,-1.82892,4.22221,.03397,-1.81136,4.20716,.0459,-1.79212,4.19867,.05212,-1.7335,4.18623,.05961,-1.65899,4.19393,.049,-1.56226,4.19883,.0396,-1.5246,4.20966,.02831,-1.50577,4.21507,.02267,-1.48657,4.23813,.00191,-1.48657,4.23813,.00191,-1.47167,4.25638,-.0145};
			return value;
		}
		private double[] getCoordinate_10_71_point_4()
		{
			double[] value = {-1.44173,4.30215,-.05526,-1.41354,4.31073,-.06412,-1.41906,4.34763,-.09538,-1.41909,4.33742,-.08664,-1.42458,4.38452,-.12663,-1.45681,4.38969,-.12932,-1.53703,4.38918,-.12456,-1.59172,4.38879,-.12128};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getGeoSculptedSurface2_9_125_coordIndex_1()
		{
			int[] value = {0,1,26,-1,0,26,25,-1,1,2,27,-1,1,27,26,-1,2,3,28,-1,2,28,27,-1,3,4,29,-1,3,29,28,-1,4,5,30,-1,4,30,29,-1,5,6,31,-1,5,31,30,-1,6,7,32,-1,6,32,31,-1,7,8,33,-1,7,33,32,-1,8,9,34,-1,8,34,33,-1,9,10,35,-1,9,35,34,-1,10,11,36,-1,10,36,35,-1,11,12,37,-1,11,37,36,-1,12,13,38,-1,12,38,37,-1,13,14,39,-1,13,39,38,-1,14,15,40,-1,14,40,39,-1,15,16,41,-1,15,41,40,-1,16,17,42,-1,16,42,41,-1,17,18,43,-1,17,43,42,-1,18,19,44,-1,18,44,43,-1,19,20,45,-1,19,45,44,-1,20,21,46,-1,20,46,45,-1,21,22,47,-1,21,47,46,-1,22,23,48,-1,22,48,47,-1,23,24,49,-1,23,49,48,-1,25,26,51,-1,25,51,50,-1,26,27,52,-1,26,52,51,-1,27,28,53,-1,27,53,52,-1,28,29,54,-1,28,54,53,-1,29,30,55,-1,29,55,54,-1,30,31,56,-1,30,56,55,-1,31,32,57,-1,31,57,56,-1,32,33,58,-1,32,58,57,-1,33,34,59,-1,33,59,58,-1,34,35,60,-1,34,60,59,-1,35,36,61,-1,35,61,60,-1,36,37,62,-1,36,62,61,-1,37,38,63,-1,37,63,62,-1,38,39,64,-1,38,64,63,-1,39,40,65,-1,39,65,64,-1,40,41,66,-1,40,66,65,-1,41,42,67,-1,41,67,66,-1,42,43,68,-1,42,68,67,-1,43,44,69,-1,43,69,68,-1,44,45,70,-1,44,70,69,-1,45,46,71,-1,45,71,70,-1,46,47,72,-1,46,72,71,-1,47,48,73,-1,47,73,72,-1,48,49,74,-1,48,74,73,-1,50,51,76,-1,50,76,75,-1,51,52,77,-1,51,77,76,-1,52,53,78,-1,52,78,77,-1,53,54,79,-1,53,79,78,-1,54,55,80,-1,54,80,79,-1,55,56,81,-1,55,81,80,-1,56,57,82,-1,56,82,81,-1,57,58,83,-1,57,83,82,-1,58,59,84,-1,58,84,83,-1,59,60,85,-1,59,85,84,-1,60,61,86,-1,60,86,85,-1,61,62,87,-1,61,87,86,-1,62,63,88,-1,62,88,87,-1,63,64,89,-1,63,89,88,-1,64,65,90,-1,64,90,89,-1,65,66,91,-1,65,91,90,-1,66,67,92,-1,66,92,91,-1,67,68,93,-1,67,93,92,-1,68,69,94,-1,68,94,93,-1,69,70,95,-1,69,95,94,-1,70,71,96,-1,70,96,95,-1,71,72,97,-1,71,97,96,-1,72,73,98,-1,72,98,97,-1,73,74,99,-1,73,99,98,-1,75,76,101,-1,75,101,100,-1,76,77,102,-1,76,102,101,-1,77,78,103,-1,77,103,102,-1,78,79,104,-1,78,104,103,-1,79,80,105,-1,79,105,104,-1,80,81,106,-1,80,106,105,-1,81,82,107,-1,81,107,106,-1,82,83,108,-1,82,108,107,-1,83,84,109,-1,83,109,108,-1,84,85,110,-1,84,110,109,-1,85,86,111,-1,85,111,110,-1,86,87,112,-1,86,112,111,-1,87,88,113,-1,87,113,112,-1,88,89,114,-1,88,114,113,-1,89,90,115,-1,89,115,114,-1,90,91,116,-1,90,116,115,-1,91,92,117,-1,91,117,116,-1,92,93,118,-1,92,118,117,-1,93,94,119,-1,93,119,118,-1,94,95,120,-1,94,120,119,-1,95,96,121,-1,95,121,120,-1,96,97,122,-1,96,122,121,-1,97,98,123,-1,97,123,122,-1,98,99,124,-1,98,124,123,-1,100,101,126,-1,100,126,125,-1,101,102,127,-1,101,127,126,-1,102,103,128,-1,102,128,127,-1,103,104,129,-1,103,129,128,-1,104,105,130,-1,104,130,129,-1,105,106,131,-1,105,131,130,-1,106,107,132,-1,106,132,131,-1,107,108,133,-1,107,133,132,-1,108,109,134,-1,108,134,133,-1,109,110,135,-1,109,135,134,-1,110,111,136,-1,110,136,135,-1,111,112,137,-1,111,137,136,-1,112,113,138,-1,112,138,137,-1,113,114,139,-1,113,139,138,-1,114,115,140,-1,114,140,139,-1,115,116,141,-1,115,141,140,-1,116,117,142,-1,116,142,141,-1,117,118,143,-1,117,143,142,-1,118,119,144,-1,118,144,143,-1,119,120,145,-1,119,145,144,-1,120,121,146,-1,120,146,145,-1,121,122,147,-1,121,147,146,-1,122,123,148,-1,122,148,147,-1,123,124,149,-1,123,149,148,-1,125,126,151,-1,125,151,150,-1,126,127,152,-1,126,152,151,-1,127,128,153,-1,127,153,152,-1,128,129,154,-1,128,154,153,-1,129,130,155,-1,129,155,154,-1};
			return value;
		}
		private int[] getGeoSculptedSurface2_9_125_coordIndex_2()
		{
			int[] value = {130,131,156,-1,130,156,155,-1,131,132,157,-1,131,157,156,-1,132,133,158,-1,132,158,157,-1,133,134,159,-1,133,159,158,-1,134,135,160,-1,134,160,159,-1,135,136,161,-1,135,161,160,-1,136,137,162,-1,136,162,161,-1,137,138,163,-1,137,163,162,-1,138,139,164,-1,138,164,163,-1,139,140,165,-1,139,165,164,-1,140,141,166,-1,140,166,165,-1,141,142,167,-1,141,167,166,-1,142,143,168,-1,142,168,167,-1,143,144,169,-1,143,169,168,-1,144,145,170,-1,144,170,169,-1,145,146,171,-1,145,171,170,-1,146,147,172,-1,146,172,171,-1,147,148,173,-1,147,173,172,-1,148,149,174,-1,148,174,173,-1,150,151,176,-1,150,176,175,-1,151,152,177,-1,151,177,176,-1,152,153,178,-1,152,178,177,-1,153,154,179,-1,153,179,178,-1,154,155,180,-1,154,180,179,-1,155,156,181,-1,155,181,180,-1,156,157,182,-1,156,182,181,-1,157,158,183,-1,157,183,182,-1,158,159,184,-1,158,184,183,-1,159,160,185,-1,159,185,184,-1,160,161,186,-1,160,186,185,-1,161,162,187,-1,161,187,186,-1,162,163,188,-1,162,188,187,-1,163,164,189,-1,163,189,188,-1,164,165,190,-1,164,190,189,-1,165,166,191,-1,165,191,190,-1,166,167,192,-1,166,192,191,-1,167,168,193,-1,167,193,192,-1,168,169,194,-1,168,194,193,-1,169,170,195,-1,169,195,194,-1,170,171,196,-1,170,196,195,-1,171,172,197,-1,171,197,196,-1,172,173,198,-1,172,198,197,-1,173,174,199,-1,173,199,198,-1,175,176,201,-1,175,201,200,-1,176,177,202,-1,176,202,201,-1,177,178,203,-1,177,203,202,-1,178,179,204,-1,178,204,203,-1,179,180,205,-1,179,205,204,-1,180,181,206,-1,180,206,205,-1,181,182,207,-1,181,207,206,-1,182,183,208,-1,182,208,207,-1,183,184,209,-1,183,209,208,-1,184,185,210,-1,184,210,209,-1,185,186,211,-1,185,211,210,-1,186,187,212,-1,186,212,211,-1,187,188,213,-1,187,213,212,-1,188,189,214,-1,188,214,213,-1,189,190,215,-1,189,215,214,-1,190,191,216,-1,190,216,215,-1,191,192,217,-1,191,217,216,-1,192,193,218,-1,192,218,217,-1,193,194,219,-1,193,219,218,-1,194,195,220,-1,194,220,219,-1,195,196,221,-1,195,221,220,-1,196,197,222,-1,196,222,221,-1,197,198,223,-1,197,223,222,-1,198,199,224,-1,198,224,223,-1,200,201,226,-1,200,226,225,-1,201,202,227,-1,201,227,226,-1,202,203,228,-1,202,228,227,-1,203,204,229,-1,203,229,228,-1,204,205,230,-1,204,230,229,-1,205,206,231,-1,205,231,230,-1,206,207,232,-1,206,232,231,-1,207,208,233,-1,207,233,232,-1,208,209,234,-1,208,234,233,-1,209,210,235,-1,209,235,234,-1,210,211,236,-1,210,236,235,-1,211,212,237,-1,211,237,236,-1,212,213,238,-1,212,238,237,-1,213,214,239,-1,213,239,238,-1,214,215,240,-1,214,240,239,-1,215,216,241,-1,215,241,240,-1,216,217,242,-1,216,242,241,-1,217,218,243,-1,217,243,242,-1,218,219,244,-1,218,244,243,-1,219,220,245,-1,219,245,244,-1,220,221,246,-1,220,246,245,-1,221,222,247,-1,221,247,246,-1,222,223,248,-1,222,248,247,-1,223,224,249,-1,223,249,248,-1,225,226,251,-1,225,251,250,-1,226,227,252,-1,226,252,251,-1,227,228,253,-1,227,253,252,-1,228,229,254,-1,228,254,253,-1,229,230,255,-1,229,255,254,-1,230,231,256,-1,230,256,255,-1,231,232,257,-1,231,257,256,-1,232,233,258,-1,232,258,257,-1,233,234,259,-1,233,259,258,-1,234,235,260,-1,234,260,259,-1,235,236,261,-1,235,261,260,-1,236,237,262,-1,236,262,261,-1,237,238,263,-1,237,263,262,-1,238,239,264,-1,238,264,263,-1,239,240,265,-1,239,265,264,-1,240,241,266,-1,240,266,265,-1,241,242,267,-1,241,267,266,-1,242,243,268,-1,242,268,267,-1,243,244,269,-1,243,269,268,-1,244,245,270,-1,244,270,269,-1,245,246,271,-1,245,271,270,-1,246,247,272,-1,246,272,271,-1,247,248,273,-1,247,273,272,-1,248,249,274,-1,248,274,273,-1,250,251,276,-1,250,276,275,-1,251,252,277,-1,251,277,276,-1,252,253,278,-1,252,278,277,-1,253,254,279,-1,253,279,278,-1,254,255,280,-1,254,280,279,-1,255,256,281,-1,255,281,280,-1,256,257,282,-1,256,282,281,-1,257,258,283,-1,257,283,282,-1,258,259,284,-1,258,284,283,-1,259,260,285,-1,259,285,284,-1};
			return value;
		}
		private int[] getGeoSculptedSurface2_9_125_coordIndex_3()
		{
			int[] value = {260,261,286,-1,260,286,285,-1,261,262,287,-1,261,287,286,-1,262,263,288,-1,262,288,287,-1,263,264,289,-1,263,289,288,-1,264,265,290,-1,264,290,289,-1,265,266,291,-1,265,291,290,-1,266,267,292,-1,266,292,291,-1,267,268,293,-1,267,293,292,-1,268,269,294,-1,268,294,293,-1,269,270,295,-1,269,295,294,-1,270,271,296,-1,270,296,295,-1,271,272,297,-1,271,297,296,-1,272,273,298,-1,272,298,297,-1,273,274,299,-1,273,299,298,-1,275,276,301,-1,275,301,300,-1,276,277,302,-1,276,302,301,-1,277,278,303,-1,277,303,302,-1,278,279,304,-1,278,304,303,-1,279,280,305,-1,279,305,304,-1,280,281,306,-1,280,306,305,-1,281,282,307,-1,281,307,306,-1,282,283,308,-1,282,308,307,-1,283,284,309,-1,283,309,308,-1,284,285,310,-1,284,310,309,-1,285,286,311,-1,285,311,310,-1,286,287,312,-1,286,312,311,-1,287,288,313,-1,287,313,312,-1,288,289,314,-1,288,314,313,-1,289,290,315,-1,289,315,314,-1,290,291,316,-1,290,316,315,-1,291,292,317,-1,291,317,316,-1,292,293,318,-1,292,318,317,-1,293,294,319,-1,293,319,318,-1,294,295,320,-1,294,320,319,-1,295,296,321,-1,295,321,320,-1,296,297,322,-1,296,322,321,-1,297,298,323,-1,297,323,322,-1,298,299,324,-1,298,324,323,-1,300,301,326,-1,300,326,325,-1,301,302,327,-1,301,327,326,-1,302,303,328,-1,302,328,327,-1,303,304,329,-1,303,329,328,-1,304,305,330,-1,304,330,329,-1,305,306,331,-1,305,331,330,-1,306,307,332,-1,306,332,331,-1,307,308,333,-1,307,333,332,-1,308,309,334,-1,308,334,333,-1,309,310,335,-1,309,335,334,-1,310,311,336,-1,310,336,335,-1,311,312,337,-1,311,337,336,-1,312,313,338,-1,312,338,337,-1,313,314,339,-1,313,339,338,-1,314,315,340,-1,314,340,339,-1,315,316,341,-1,315,341,340,-1,316,317,342,-1,316,342,341,-1,317,318,343,-1,317,343,342,-1,318,319,344,-1,318,344,343,-1,319,320,345,-1,319,345,344,-1,320,321,346,-1,320,346,345,-1,321,322,347,-1,321,347,346,-1,322,323,348,-1,322,348,347,-1,323,324,349,-1,323,349,348,-1,325,326,351,-1,325,351,350,-1,326,327,352,-1,326,352,351,-1,327,328,353,-1,327,353,352,-1,328,329,354,-1,328,354,353,-1,329,330,355,-1,329,355,354,-1,330,331,356,-1,330,356,355,-1,331,332,357,-1,331,357,356,-1,332,333,358,-1,332,358,357,-1,333,334,359,-1,333,359,358,-1,334,335,360,-1,334,360,359,-1,335,336,361,-1,335,361,360,-1,336,337,362,-1,336,362,361,-1,337,338,363,-1,337,363,362,-1,338,339,364,-1,338,364,363,-1,339,340,365,-1,339,365,364,-1,340,341,366,-1,340,366,365,-1,341,342,367,-1,341,367,366,-1,342,343,368,-1,342,368,367,-1,343,344,369,-1,343,369,368,-1,344,345,370,-1,344,370,369,-1,345,346,371,-1,345,371,370,-1,346,347,372,-1,346,372,371,-1,347,348,373,-1,347,373,372,-1,348,349,374,-1,348,374,373,-1,350,351,376,-1,350,376,375,-1,351,352,377,-1,351,377,376,-1,352,353,378,-1,352,378,377,-1,353,354,379,-1,353,379,378,-1,354,355,380,-1,354,380,379,-1,355,356,381,-1,355,381,380,-1,356,357,382,-1,356,382,381,-1,357,358,383,-1,357,383,382,-1,358,359,384,-1,358,384,383,-1,359,360,385,-1,359,385,384,-1,360,361,386,-1,360,386,385,-1,361,362,387,-1,361,387,386,-1,362,363,388,-1,362,388,387,-1,363,364,389,-1,363,389,388,-1,364,365,390,-1,364,390,389,-1,365,366,391,-1,365,391,390,-1,366,367,392,-1,366,392,391,-1,367,368,393,-1,367,393,392,-1,368,369,394,-1,368,394,393,-1,369,370,395,-1,369,395,394,-1,370,371,396,-1,370,396,395,-1,371,372,397,-1,371,397,396,-1,372,373,398,-1,372,398,397,-1,373,374,399,-1,373,399,398,-1,375,376,401,-1,375,401,400,-1,376,377,402,-1,376,402,401,-1,377,378,403,-1,377,403,402,-1,378,379,404,-1,378,404,403,-1,379,380,405,-1,379,405,404,-1,380,381,406,-1,380,406,405,-1,381,382,407,-1,381,407,406,-1,382,383,408,-1,382,408,407,-1,383,384,409,-1,383,409,408,-1,384,385,410,-1,384,410,409,-1,385,386,411,-1,385,411,410,-1,386,387,412,-1,386,412,411,-1,387,388,413,-1,387,413,412,-1,388,389,414,-1,388,414,413,-1,389,390,415,-1,389,415,414,-1};
			return value;
		}
		private int[] getGeoSculptedSurface2_9_125_coordIndex_4()
		{
			int[] value = {390,391,416,-1,390,416,415,-1,391,392,417,-1,391,417,416,-1,392,393,418,-1,392,418,417,-1,393,394,419,-1,393,419,418,-1,394,395,420,-1,394,420,419,-1,395,396,421,-1,395,421,420,-1,396,397,422,-1,396,422,421,-1,397,398,423,-1,397,423,422,-1,398,399,424,-1,398,424,423,-1,400,401,426,-1,400,426,425,-1,401,402,427,-1,401,427,426,-1,402,403,428,-1,402,428,427,-1,403,404,429,-1,403,429,428,-1,404,405,430,-1,404,430,429,-1,405,406,431,-1,405,431,430,-1,406,407,432,-1,406,432,431,-1,407,408,433,-1,407,433,432,-1,408,409,434,-1,408,434,433,-1,409,410,435,-1,409,435,434,-1,410,411,436,-1,410,436,435,-1,411,412,437,-1,411,437,436,-1,412,413,438,-1,412,438,437,-1,413,414,439,-1,413,439,438,-1,414,415,440,-1,414,440,439,-1,415,416,441,-1,415,441,440,-1,416,417,442,-1,416,442,441,-1,417,418,443,-1,417,443,442,-1,418,419,444,-1,418,444,443,-1,419,420,445,-1,419,445,444,-1,420,421,446,-1,420,446,445,-1,421,422,447,-1,421,447,446,-1,422,423,448,-1,422,448,447,-1,423,424,449,-1,423,449,448,-1,425,426,451,-1,425,451,450,-1,426,427,452,-1,426,452,451,-1,427,428,453,-1,427,453,452,-1,428,429,454,-1,428,454,453,-1,429,430,455,-1,429,455,454,-1,430,431,456,-1,430,456,455,-1,431,432,457,-1,431,457,456,-1,432,433,458,-1,432,458,457,-1,433,434,459,-1,433,459,458,-1,434,435,460,-1,434,460,459,-1,435,436,461,-1,435,461,460,-1,436,437,462,-1,436,462,461,-1,437,438,463,-1,437,463,462,-1,438,439,464,-1,438,464,463,-1,439,440,465,-1,439,465,464,-1,440,441,466,-1,440,466,465,-1,441,442,467,-1,441,467,466,-1,442,443,468,-1,442,468,467,-1,443,444,469,-1,443,469,468,-1,444,445,470,-1,444,470,469,-1,445,446,471,-1,445,471,470,-1,446,447,472,-1,446,472,471,-1,447,448,473,-1,447,473,472,-1,448,449,474,-1,448,474,473,-1,450,451,476,-1,450,476,475,-1,451,452,477,-1,451,477,476,-1,452,453,478,-1,452,478,477,-1,453,454,479,-1,453,479,478,-1,454,455,480,-1,454,480,479,-1,455,456,481,-1,455,481,480,-1,456,457,482,-1,456,482,481,-1,457,458,483,-1,457,483,482,-1,458,459,484,-1,458,484,483,-1,459,460,485,-1,459,485,484,-1,460,461,486,-1,460,486,485,-1,461,462,487,-1,461,487,486,-1,462,463,488,-1,462,488,487,-1,463,464,489,-1,463,489,488,-1,464,465,490,-1,464,490,489,-1,465,466,491,-1,465,491,490,-1,466,467,492,-1,466,492,491,-1,467,468,493,-1,467,493,492,-1,468,469,494,-1,468,494,493,-1,469,470,495,-1,469,495,494,-1,470,471,496,-1,470,496,495,-1,471,472,497,-1,471,497,496,-1,472,473,498,-1,472,498,497,-1,473,474,499,-1,473,499,498,-1,475,476,501,-1,475,501,500,-1,476,477,502,-1,476,502,501,-1,477,478,503,-1,477,503,502,-1,478,479,504,-1,478,504,503,-1,479,480,505,-1,479,505,504,-1,480,481,506,-1,480,506,505,-1,481,482,507,-1,481,507,506,-1,482,483,508,-1,482,508,507,-1,483,484,509,-1,483,509,508,-1,484,485,510,-1,484,510,509,-1,485,486,511,-1,485,511,510,-1,486,487,512,-1,486,512,511,-1,487,488,513,-1,487,513,512,-1,488,489,514,-1,488,514,513,-1,489,490,515,-1,489,515,514,-1,490,491,516,-1,490,516,515,-1,491,492,517,-1,491,517,516,-1,492,493,518,-1,492,518,517,-1,493,494,519,-1,493,519,518,-1,494,495,520,-1,494,520,519,-1,495,496,521,-1,495,521,520,-1,496,497,522,-1,496,522,521,-1,497,498,523,-1,497,523,522,-1,498,499,524,-1,498,524,523,-1,500,501,526,-1,500,526,525,-1,501,502,527,-1,501,527,526,-1,502,503,528,-1,502,528,527,-1,503,504,529,-1,503,529,528,-1,504,505,530,-1,504,530,529,-1,505,506,531,-1,505,531,530,-1,506,507,532,-1,506,532,531,-1,507,508,533,-1,507,533,532,-1,508,509,534,-1,508,534,533,-1,509,510,535,-1,509,535,534,-1,510,511,536,-1,510,536,535,-1,511,512,537,-1,511,537,536,-1,512,513,538,-1,512,538,537,-1,513,514,539,-1,513,539,538,-1,514,515,540,-1,514,540,539,-1,515,516,541,-1,515,541,540,-1,516,517,542,-1,516,542,541,-1,517,518,543,-1,517,543,542,-1,518,519,544,-1,518,544,543,-1,519,520,545,-1,519,545,544,-1};
			return value;
		}
		private int[] getGeoSculptedSurface2_9_125_coordIndex_5()
		{
			int[] value = {520,521,546,-1,520,546,545,-1,521,522,547,-1,521,547,546,-1,522,523,548,-1,522,548,547,-1,523,524,549,-1,523,549,548,-1,525,526,551,-1,525,551,550,-1,526,527,552,-1,526,552,551,-1,527,528,553,-1,527,553,552,-1,528,529,554,-1,528,554,553,-1,529,530,555,-1,529,555,554,-1,530,531,556,-1,530,556,555,-1,531,532,557,-1,531,557,556,-1,532,533,558,-1,532,558,557,-1,533,534,559,-1,533,559,558,-1,534,535,560,-1,534,560,559,-1,535,536,561,-1,535,561,560,-1,536,537,562,-1,536,562,561,-1,537,538,563,-1,537,563,562,-1,538,539,564,-1,538,564,563,-1,539,540,565,-1,539,565,564,-1,540,541,566,-1,540,566,565,-1,541,542,567,-1,541,567,566,-1,542,543,568,-1,542,568,567,-1,543,544,569,-1,543,569,568,-1,544,545,570,-1,544,570,569,-1,545,546,571,-1,545,571,570,-1,546,547,572,-1,546,572,571,-1,547,548,573,-1,547,573,572,-1,548,549,574,-1,548,574,573,-1,550,551,576,-1,550,576,575,-1,551,552,577,-1,551,577,576,-1,552,553,578,-1,552,578,577,-1,553,554,579,-1,553,579,578,-1,554,555,580,-1,554,580,579,-1,555,556,581,-1,555,581,580,-1,556,557,582,-1,556,582,581,-1,557,558,583,-1,557,583,582,-1,558,559,584,-1,558,584,583,-1,559,560,585,-1,559,585,584,-1,560,561,586,-1,560,586,585,-1,561,562,587,-1,561,587,586,-1,562,563,588,-1,562,588,587,-1,563,564,589,-1,563,589,588,-1,564,565,590,-1,564,590,589,-1,565,566,591,-1,565,591,590,-1,566,567,592,-1,566,592,591,-1,567,568,593,-1,567,593,592,-1,568,569,594,-1,568,594,593,-1,569,570,595,-1,569,595,594,-1,570,571,596,-1,570,596,595,-1,571,572,597,-1,571,597,596,-1,572,573,598,-1,572,598,597,-1,573,574,599,-1,573,599,598,-1,575,576,601,-1,575,601,600,-1,576,577,602,-1,576,602,601,-1,577,578,603,-1,577,603,602,-1,578,579,604,-1,578,604,603,-1,579,580,605,-1,579,605,604,-1,580,581,606,-1,580,606,605,-1,581,582,607,-1,581,607,606,-1,582,583,608,-1,582,608,607,-1,583,584,609,-1,583,609,608,-1,584,585,610,-1,584,610,609,-1,585,586,611,-1,585,611,610,-1,586,587,612,-1,586,612,611,-1,587,588,613,-1,587,613,612,-1,588,589,614,-1,588,614,613,-1,589,590,615,-1,589,615,614,-1,590,591,616,-1,590,616,615,-1,591,592,617,-1,591,617,616,-1,592,593,618,-1,592,618,617,-1,593,594,619,-1,593,619,618,-1,594,595,620,-1,594,620,619,-1,595,596,621,-1,595,621,620,-1,596,597,622,-1,596,622,621,-1,597,598,623,-1,597,623,622,-1,598,599,624,-1,598,624,623,-1,600,601,626,-1,600,626,625,-1,601,602,627,-1,601,627,626,-1,602,603,628,-1,602,628,627,-1,603,604,629,-1,603,629,628,-1,604,605,630,-1,604,630,629,-1,605,606,631,-1,605,631,630,-1,606,607,632,-1,606,632,631,-1,607,608,633,-1,607,633,632,-1,608,609,634,-1,608,634,633,-1,609,610,635,-1,609,635,634,-1,610,611,636,-1,610,636,635,-1,611,612,637,-1,611,637,636,-1,612,613,638,-1,612,638,637,-1,613,614,639,-1,613,639,638,-1,614,615,640,-1,614,640,639,-1,615,616,641,-1,615,641,640,-1,616,617,642,-1,616,642,641,-1,617,618,643,-1,617,643,642,-1,618,619,644,-1,618,644,643,-1,619,620,645,-1,619,645,644,-1,620,621,646,-1,620,646,645,-1,621,622,647,-1,621,647,646,-1,622,623,648,-1,622,648,647,-1,623,624,649,-1,623,649,648,-1,625,626,651,-1,625,651,650,-1,626,627,652,-1,626,652,651,-1,627,628,653,-1,627,653,652,-1,628,629,654,-1,628,654,653,-1,629,630,655,-1,629,655,654,-1,630,631,656,-1,630,656,655,-1,631,632,657,-1,631,657,656,-1,632,633,658,-1,632,658,657,-1,633,634,659,-1,633,659,658,-1,634,635,660,-1,634,660,659,-1,635,636,661,-1,635,661,660,-1,636,637,662,-1,636,662,661,-1,637,638,663,-1,637,663,662,-1,638,639,664,-1,638,664,663,-1,639,640,665,-1,639,665,664,-1,640,641,666,-1,640,666,665,-1,641,642,667,-1,641,667,666,-1,642,643,668,-1,642,668,667,-1,643,644,669,-1,643,669,668,-1,644,645,670,-1,644,670,669,-1,645,646,671,-1,645,671,670,-1,646,647,672,-1,646,672,671,-1,647,648,673,-1,647,673,672,-1,648,649,674,-1,648,674,673,-1,650,651,676,-1,650,676,675,-1};
			return value;
		}
		private int[] getGeoSculptedSurface2_9_125_coordIndex_6()
		{
			int[] value = {651,652,677,-1,651,677,676,-1,652,653,678,-1,652,678,677,-1,653,654,679,-1,653,679,678,-1,654,655,680,-1,654,680,679,-1,655,656,681,-1,655,681,680,-1,656,657,682,-1,656,682,681,-1,657,658,683,-1,657,683,682,-1,658,659,684,-1,658,684,683,-1,659,660,685,-1,659,685,684,-1,660,661,686,-1,660,686,685,-1,661,662,687,-1,661,687,686,-1,662,663,688,-1,662,688,687,-1,663,664,689,-1,663,689,688,-1,664,665,690,-1,664,690,689,-1,665,666,691,-1,665,691,690,-1,666,667,692,-1,666,692,691,-1,667,668,693,-1,667,693,692,-1,668,669,694,-1,668,694,693,-1,669,670,695,-1,669,695,694,-1,670,671,696,-1,670,696,695,-1,671,672,697,-1,671,697,696,-1,672,673,698,-1,672,698,697,-1,673,674,699,-1,673,699,698,-1,675,676,701,-1,675,701,700,-1,676,677,702,-1,676,702,701,-1,677,678,703,-1,677,703,702,-1,678,679,704,-1,678,704,703,-1,679,680,705,-1,679,705,704,-1,680,681,706,-1,680,706,705,-1,681,682,707,-1,681,707,706,-1,682,683,708,-1,682,708,707,-1,683,684,709,-1,683,709,708,-1,684,685,710,-1,684,710,709,-1,685,686,711,-1,685,711,710,-1,686,687,712,-1,686,712,711,-1,687,688,713,-1,687,713,712,-1,688,689,714,-1,688,714,713,-1,689,690,715,-1,689,715,714,-1,690,691,716,-1,690,716,715,-1,691,692,717,-1,691,717,716,-1,692,693,718,-1,692,718,717,-1,693,694,719,-1,693,719,718,-1,694,695,720,-1,694,720,719,-1,695,696,721,-1,695,721,720,-1,696,697,722,-1,696,722,721,-1,697,698,723,-1,697,723,722,-1,698,699,724,-1,698,724,723,-1,700,701,726,-1,700,726,725,-1,701,702,727,-1,701,727,726,-1,702,703,728,-1,702,728,727,-1,703,704,729,-1,703,729,728,-1,704,705,730,-1,704,730,729,-1,705,706,731,-1,705,731,730,-1,706,707,732,-1,706,732,731,-1,707,708,733,-1,707,733,732,-1,708,709,734,-1,708,734,733,-1,709,710,735,-1,709,735,734,-1,710,711,736,-1,710,736,735,-1,711,712,737,-1,711,737,736,-1,712,713,738,-1,712,738,737,-1,713,714,739,-1,713,739,738,-1,714,715,740,-1,714,740,739,-1,715,716,741,-1,715,741,740,-1,716,717,742,-1,716,742,741,-1,717,718,743,-1,717,743,742,-1,718,719,744,-1,718,744,743,-1,719,720,745,-1,719,745,744,-1,720,721,746,-1,720,746,745,-1,721,722,747,-1,721,747,746,-1,722,723,748,-1,722,748,747,-1,723,724,749,-1,723,749,748,-1,725,726,751,-1,725,751,750,-1,726,727,752,-1,726,752,751,-1,727,728,753,-1,727,753,752,-1,728,729,754,-1,728,754,753,-1,729,730,755,-1,729,755,754,-1,730,731,756,-1,730,756,755,-1,731,732,757,-1,731,757,756,-1,732,733,758,-1,732,758,757,-1,733,734,759,-1,733,759,758,-1,734,735,760,-1,734,760,759,-1,735,736,761,-1,735,761,760,-1,736,737,762,-1,736,762,761,-1,737,738,763,-1,737,763,762,-1,738,739,764,-1,738,764,763,-1,739,740,765,-1,739,765,764,-1,740,741,766,-1,740,766,765,-1,741,742,767,-1,741,767,766,-1,742,743,768,-1,742,768,767,-1,743,744,769,-1,743,769,768,-1,744,745,770,-1,744,770,769,-1,745,746,771,-1,745,771,770,-1,746,747,772,-1,746,772,771,-1,747,748,773,-1,747,773,772,-1,748,749,774,-1,748,774,773,-1,750,751,776,-1,750,776,775,-1,751,752,777,-1,751,777,776,-1,752,753,778,-1,752,778,777,-1,753,754,779,-1,753,779,778,-1,754,755,780,-1,754,780,779,-1,755,756,781,-1,755,781,780,-1,756,757,782,-1,756,782,781,-1,757,758,783,-1,757,783,782,-1,758,759,784,-1,758,784,783,-1,759,760,785,-1,759,785,784,-1,760,761,786,-1,760,786,785,-1,761,762,787,-1,761,787,786,-1,762,763,788,-1,762,788,787,-1,763,764,789,-1,763,789,788,-1,764,765,790,-1,764,790,789,-1,765,766,791,-1,765,791,790,-1,766,767,792,-1,766,792,791,-1,767,768,793,-1,767,793,792,-1,768,769,794,-1,768,794,793,-1,769,770,795,-1,769,795,794,-1,770,771,796,-1,770,796,795,-1,771,772,797,-1,771,797,796,-1,772,773,798,-1,772,798,797,-1,773,774,799,-1,773,799,798,-1,775,776,777,-1,775,777,778,-1,775,778,779,-1,775,779,780,-1,775,780,781,-1,775,781,782,-1,775,782,783,-1,775,783,784,-1,775,784,785,-1,775,785,786,-1,775,786,787,-1,775,787,788,-1};
			return value;
		}
		private int[] getGeoSculptedSurface2_9_125_coordIndex_7()
		{
			int[] value = {775,788,789,-1,775,789,790,-1,775,790,791,-1,775,791,792,-1,775,792,793,-1,775,793,794,-1,775,794,795,-1,775,795,796,-1,775,796,797,-1,775,797,798,-1,23,22,21,-1,23,21,20,-1,23,20,19,-1,23,19,18,-1,23,18,17,-1,23,17,16,-1,23,16,15,-1,23,15,14,-1,23,14,13,-1,23,13,12,-1,23,12,11,-1,23,11,10,-1,23,10,9,-1,23,9,8,-1,23,8,7,-1,23,7,6,-1,23,6,5,-1,23,5,4,-1,23,4,3,-1,23,3,2,-1,23,2,1,-1,23,1,0,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getCoordinate_10_125_point_1()
		{
			double[] value = {-.52328,-7.0,.00376,-.48187,-7.0,.128,-.41411,-7.0,.26352,-.30117,-7.0,.33129,-.15058,-7.0,.39152,.01506,-7.0,.39528,.21458,-7.0,.37646,.35011,-7.0,.31623,.44799,-7.0,.19952,.50446,-7.0,.11294,.53081,-7.0,.00376,.53081,-7.0,-.11294,.50446,-7.0,-.21835,.44046,-7.0,-.34634,.33129,-7.0,-.44799,.1807,-7.0,-.50069,0.0,-7.0,-.51952,-.12047,-7.0,-.50446,-.22211,-7.0,-.4894,-.33129,-7.0,-.44422,-.41411,-7.0,-.39152,-.47058,-7.0,-.31246,-.52328,-7.0,-.1807,-.53081,-7.0,-.08282,-.52328,-7.0,.00376,-.86455,-6.0,.00622,-.79613,-6.0,.21147,-.68418,-6.0,.43539,-.49758,-6.0,.54734,-.24879,-6.0,.64686,.02488,-6.0,.65308,.35453,-6.0,.62198,.57844,-6.0,.52246,.74016,-6.0,.32965,.83345,-6.0,.18659,.87699,-6.0,.00622,.87699,-6.0,-.18659,.83345,-6.0,-.36075,.72772,-6.0,-.57222,.54734,-6.0,-.74016,.29855,-6.0,-.82723,0.0,-6.0,-.85833,-.19903,-6.0,-.83345,-.36697,-6.0,-.80857,-.54734,-6.0,-.73394,-.68418,-6.0,-.64686,-.77747,-6.0,-.51624,-.86455,-6.0,-.29855,-.87699,-6.0,-.13684,-.86455,-6.0,.00622,-.88161,-5.0,.00634,-.81185,-5.0,.21565,-.69768,-5.0,.44398,-.5074,-5.0,.55814,-.2537,-5.0,.65963,.02537,-5.0,.66597,.36153,-5.0,.63426,.58986,-5.0,.53277,.75476,-5.0,.33616,.8499,-5.0,.19028,.8943,-5.0,.00634,.8943,-5.0,-.19028,.8499,-5.0,-.36787,.74208,-5.0,-.58351,.55814,-5.0,-.75476,.30444,-5.0,-.84356,0.0,-5.0,-.87527,-.20296,-5.0,-.8499,-.37421,-5.0,-.82453,-.55814,-5.0,-.74842,-.69768,-5.0,-.65963,-.79282,-5.0,-.52643,-.88161,-5.0,-.30444,-.8943,-5.0,-.13954,-.88161,-5.0,.00634,-1.07906,-4.0,.00776,-.99367,-4.0,.26394,-.85394,-4.0,.54341,-.62104,-4.0,.68315,-.31052,-4.0,.80736,.03105,-4.0,.81512,.44249,-4.0,.7763,.72196,-4.0,.6521,.9238,-4.0,.41144,1.04025,-4.0,.23289,1.09459,-4.0,.00776,1.09459,-4.0,-.23289,1.04025,-4.0,-.45026,.90828,-4.0,-.7142,.68315,-4.0,-.9238,.37263,-4.0,-1.03249,0.0,-4.0,-1.0713,-.24842,-4.0,-1.04025,-.45802,-4.0,-1.0092,-.68315,-4.0,-.91604,-.85394,-4.0,-.80736,-.97038,-4.0,-.64433,-1.07906,-4.0,-.37263,-1.09459,-4.0,-.17079,-1.07906,-4.0,.00776};
			return value;
		}
		private double[] getCoordinate_10_125_point_2()
		{
			double[] value = {-1.17413,-3.0,.00845,-1.08121,-3.0,.2872,-.92917,-3.0,.59129,-.67576,-3.0,.74334,-.33788,-3.0,.87849,.03379,-3.0,.88693,.48148,-3.0,.8447,.78557,-3.0,.70955,1.00519,-3.0,.44769,1.1319,-3.0,.25341,1.19103,-3.0,.00845,1.19103,-3.0,-.25341,1.1319,-3.0,-.48993,.9883,-3.0,-.77712,.74334,-3.0,-1.00519,.40546,-3.0,-1.12345,0.0,-3.0,-1.16568,-.2703,-3.0,-1.1319,-.49837,-3.0,-1.09811,-.74334,-3.0,-.99674,-.92917,-3.0,-.87849,-1.05587,-3.0,-.7011,-1.17413,-3.0,-.40546,-1.19103,-3.0,-.18583,-1.17413,-3.0,.00845,-1.39839,-2.0,.01006,-1.28773,-2.0,.34205,-1.10664,-2.0,.70423,-.80483,-2.0,.88531,-.40242,-2.0,1.04628,.04024,-2.0,1.05634,.57344,-2.0,1.00604,.93562,-2.0,.84507,1.19719,-2.0,.5332,1.34809,-2.0,.30181,1.41852,-2.0,.01006,1.41852,-2.0,-.30181,1.34809,-2.0,-.5835,1.17707,-2.0,-.92556,.88531,-2.0,-1.19719,.4829,-2.0,-1.33803,0.0,-2.0,-1.38833,-.32193,-2.0,-1.34809,-.59356,-2.0,-1.30785,-.88531,-2.0,-1.18713,-1.10664,-2.0,-1.04628,-1.25755,-2.0,-.83501,-1.39839,-2.0,-.4829,-1.41852,-2.0,-.22133,-1.39839,-2.0,.01006,-1.43252,-1.0,.01031,-1.31916,-1.0,.3504,-1.13365,-1.0,.72141,-.82447,-1.0,.90692,-.41224,-1.0,1.07181,.04122,-1.0,1.08212,.58744,-1.0,1.03059,.95845,-1.0,.8657,1.2264,-1.0,.54621,1.38099,-1.0,.30918,1.45313,-1.0,.01031,1.45313,-1.0,-.30918,1.38099,-1.0,-.59774,1.20579,-1.0,-.94814,.90692,-1.0,-1.2264,.49468,-1.0,-1.37069,0.0,-1.0,-1.42222,-.32979,-1.0,-1.38099,-.60805,-1.0,-1.33977,-.90692,-1.0,-1.2161,-1.13365,-1.0,-1.07181,-1.28824,-1.0,-.85539,-1.43252,-1.0,-.49468,-1.45313,-1.0,-.22673,-1.43252,-1.0,.01031,-1.48609,.38406,.00917,-1.36804,.35718,.3737,-1.17511,.31128,.77145,-.85412,.23033,.97061,-.42625,.12154,1.14782,.04418,.00011,1.15946,.61076,-.14682,1.10497,.99544,-.24796,.92878,1.27299,-.32308,.58683,1.43305,-.36695,.33307,1.5075,-.38937,.01295,1.50708,-.39266,-.32935,1.43187,-.3763,-.63862,1.24965,-.33296,-1.01428,.93924,-.25572,-1.31281,.51139,-.14672,-1.46793,-.00186,-.01466,-1.52379,-.34393,.07416,-1.48005,-.63255,.14916,-1.43625,-.94244,.23054,-1.30414,-1.17746,.2928,-1.14985,-1.33755,.33646,-.91817,-1.48675,.37885,-.53189,-1.50779,.38714,-.24483,-1.48609,.38406,.00917};
			return value;
		}
		private double[] getCoordinate_10_125_point_3()
		{
			double[] value = {-1.68808,1.82961,.02585,-1.55742,1.75135,.47127,-1.34202,1.63015,.95665,-.9793,1.44415,1.19747,-.49497,1.19921,1.41036,.03962,.93762,1.36588,.70815,.61187,1.26631,1.12175,.4119,1.15508,1.44041,.26923,.70638,1.62461,.18843,.39393,1.71219,.15768,.00103,1.65377,.19745,-.35023,1.63241,.22197,-.79645,1.42898,.33644,-1.25486,1.19975,.45637,-1.48314,.49728,.8107,-1.76206,.01223,1.0526,-1.86673,-.37672,1.24215,-1.80979,-.70496,1.40185,-1.75329,-1.05819,1.57044,-1.58839,-1.3266,1.69647,-1.39706,-1.51062,1.77803,-1.11166,-1.68373,1.84829,-.63698,-1.71032,1.85032,-.28509,-1.68808,1.82961,.02585,-.67675,2.62556,-.10053,-.44725,2.60402,.65551,-.07075,2.52909,1.48558,.559,2.31159,1.91923,1.3991,2.00394,2.3165,2.32432,1.6201,2.28764,3.48101,1.13313,2.17806,4.19625,.82399,2.02726,4.74465,.52831,1.30401,5.06124,.34899,.79715,5.20997,.22503,.14753,5.10624,.21056,-.44489,5.06596,.15493,-1.19295,4.71038,.2257,-1.97691,4.31184,.3511,-2.37819,3.09358,.80204,-2.90448,2.25305,1.12733,-3.12084,1.58006,1.4105,-3.05873,1.0122,1.6508,-2.99219,.40186,1.92589,-2.7465,-.06142,2.14538,-2.44939,-.3779,2.32029,-1.98776,-.67412,2.5175,-1.20865,-.71756,2.59198,-.62244,-.67675,2.62556,-.10053,1.63051,3.20173,.02272,1.8569,3.09581,.77255,2.22736,2.92249,1.59055,2.84479,2.63362,1.99954,3.66803,2.24847,2.3631,4.57359,1.82479,2.29493,5.70555,1.2952,2.13588,6.4053,.96782,1.9541,6.94041,.71747,1.20427,7.24913,.57304,.68166,7.39319,.50564,.02272,7.29029,.55378,-.56805,7.24913,.57304,-1.31788,6.89925,.73673,-2.09043,6.50821,.91968,-2.47671,5.31451,1.47815,-2.95387,4.49127,1.86331,-3.13565,3.83268,2.17143,-3.04476,3.27699,2.43142,-2.95387,2.68014,2.71065,-2.68121,2.22736,2.92249,-2.3631,1.91864,3.06692,-1.88593,1.63051,3.20173,-1.09066,1.58935,3.22098,-.49989,1.63051,3.20173,.02272,5.36946,3.27172,.01079,5.51588,3.22298,.47613,5.75503,3.1408,.98392,6.15263,2.99821,1.23831,6.68258,2.80701,1.46475,7.26502,2.59392,1.42352,7.99301,2.32712,1.32617,8.44295,2.1617,1.21423,8.78638,2.03159,.74977,8.98442,1.95599,.42598,9.0764,1.91826,.01744,9.00959,1.93894,-.3491,8.98233,1.94418,-.81423,8.75646,2.02179,-1.2938,8.50451,2.11134,-1.53384,7.73615,2.38888,-1.83118,7.20639,2.58116,-1.94487,6.78284,2.73638,-1.88926,6.42548,2.86743,-1.83353,6.04183,3.00922,-1.6651,5.7509,3.11744,-1.46831,5.55281,3.19277,-1.17271,5.3683,3.26514,-.67978,5.34244,3.2783,-.3134,5.36946,3.27172,.01079};
			return value;
		}
		private double[] getCoordinate_10_125_point_4()
		{
			double[] value = {8.18736,4.23491,-.01264,8.33147,4.18994,.45379,8.56383,4.10213,.96379,8.94302,3.92255,1.22282,9.44707,3.67678,1.45563,9.99757,3.39013,1.42188,10.68507,3.02925,1.33396,11.10936,2.80326,1.22793,11.42865,2.60917,.7686,11.6121,2.49406,.44787,11.69419,2.42589,.04117,11.62657,2.43763,-.32562,11.59518,2.42444,-.79033,11.37573,2.50738,-1.27199,11.1345,2.61668,-1.51484,10.40405,2.97479,-1.82146,9.90154,3.2269,-1.94172,9.50153,3.43681,-1.89158,9.16414,3.61441,-1.84049,8.80323,3.81127,-1.67722,8.53039,3.96448,-1.48446,8.34656,4.078,-1.19187,8.17794,4.19614,-.70209,8.15789,4.22963,-.33665,8.18736,4.23491,-.01264,8.36042,6.29467,.0139,8.54134,6.24975,.57533,8.83698,6.17331,1.18793,9.32878,6.03904,1.4947,9.98433,5.85872,1.76769,10.70498,5.65699,1.71765,11.60571,5.40431,1.59984,12.16245,5.2475,1.46456,12.58759,5.1232,.90396,12.83277,5.05084,.51317,12.94678,5.01409,.02016,12.8643,5.03271,-.4221,12.8308,5.03647,-.98333,12.55158,5.10866,-1.5619,12.23999,5.19278,-1.85142,11.28949,5.45462,-2.20983,10.63411,5.63625,-2.34677,10.11005,5.78325,-2.27946,9.66788,5.90739,-2.21205,9.19313,6.04198,-2.00863,8.83309,6.14489,-1.77104,8.58786,6.21692,-1.41426,8.35933,6.28667,-.81938,8.32715,6.30006,-.37728,8.36042,6.29467,.0139,9.41412,7.9815,.0139,9.56703,7.9815,.47263,9.81725,7.9815,.97307,10.23428,7.9815,1.22329,10.79032,7.9815,1.4457,11.40196,7.9815,1.404,12.16652,7.9815,1.30669,12.63915,7.9815,1.19549,13.00058,7.9815,.73675,13.20909,7.9815,.41703,13.3064,7.9815,.0139,13.23689,7.9815,-.34752,13.20909,7.9815,-.80626,12.97277,7.9815,-1.27889,12.70866,7.9815,-1.51521,11.9024,7.9815,-1.80713,11.34636,7.9815,-1.91834,10.90153,7.9815,-1.86273,10.5262,7.9815,-1.80713,10.12307,7.9815,-1.64032,9.81725,7.9815,-1.4457,9.60873,7.9815,-1.15378,9.41412,7.9815,-.66725,9.38632,7.9815,-.30582,9.41412,7.9815,.0139,8.3379,10.1953,.01739,8.52921,10.1953,.59133,8.84227,10.1953,1.21745,9.36403,10.1953,1.5305,10.05972,10.1953,1.80878,10.82497,10.1953,1.7566,11.78153,10.1953,1.63486,12.37286,10.1953,1.49572,12.82506,10.1953,.92178,13.08594,10.1953,.52176,13.20768,10.1953,.01739,13.12072,10.1953,-.4348,13.08594,10.1953,-1.00874,12.79027,10.1953,-1.60007,12.45982,10.1953,-1.89574,11.45108,10.1953,-2.26097,10.7554,10.1953,-2.40011,10.19885,10.1953,-2.33054,9.72927,10.1953,-2.26097,9.2249,10.1953,-2.05227,8.84227,10.1953,-1.80878,8.58139,10.1953,-1.44354,8.3379,10.1953,-.83482,8.30312,10.1953,-.38263,8.3379,10.1953,.01739};
			return value;
		}
		private double[] getCoordinate_10_125_point_5()
		{
			double[] value = {8.44724,11.30216,.01448,8.60652,11.30216,.49231,8.86715,11.30216,1.01358,9.30155,11.30216,1.27422,9.88073,11.30216,1.50589,10.51784,11.30216,1.46245,11.31423,11.30216,1.36109,11.80654,11.30216,1.24526,12.18301,11.30216,.76743,12.40021,11.30216,.43439,12.50156,11.30216,.01448,12.42917,11.30216,-.36199,12.40021,11.30216,-.83982,12.15405,11.30216,-1.33213,11.87894,11.30216,-1.57829,11.03911,11.30216,-1.88236,10.45992,11.30216,-1.9982,9.99657,11.30216,-1.94028,9.60562,11.30216,-1.88236,9.18571,11.30216,-1.70861,8.86715,11.30216,-1.50589,8.64996,11.30216,-1.20182,8.44724,11.30216,-.69503,8.41828,11.30216,-.31855,8.44724,11.30216,.01448,7.90817,12.48093,.02968,8.08367,12.55404,.58591,8.37252,12.66201,1.19215,8.8578,12.81473,1.49333,9.50558,13.01317,1.75983,10.22003,13.21809,1.70512,11.11339,13.47213,1.58185,11.66599,13.62679,1.44363,12.09104,13.72763,.884,12.33662,13.78324,.49424,12.45291,13.79734,.00391,12.37415,13.75697,-.43467,12.34473,13.72617,-.99172,12.07193,13.6242,-1.56428,11.7651,13.52384,-1.8496,10.82562,13.23754,-2.19886,10.1771,13.04429,-2.33027,9.65734,12.89644,-2.25978,9.21872,12.77209,-2.18975,8.74691,12.64353,-1.98445,8.38854,12.54918,-1.74602,8.14314,12.49227,-1.39003,7.91268,12.44915,-.79773,7.87782,12.45661,-.35851,7.90817,12.48093,.02968,6.87419,14.75852,.38028,6.91457,15.03335,.80019,7.01199,15.39981,1.24245,7.24751,15.81632,1.40818,7.57548,16.33467,1.52033,7.97211,16.80957,1.36344,8.47357,17.38816,1.12313,8.78996,17.72885,.92461,9.07872,17.86504,.40709,9.25222,17.92529,.05463,9.36499,17.86892,-.35835,9.3658,17.69312,-.69886,9.40548,17.51827,-1.14251,9.31347,17.17217,-1.5602,9.17406,16.88247,-1.74135,8.69468,16.14105,-1.87403,8.35278,15.6597,-1.87734,8.06115,15.32273,-1.73851,7.814,15.0413,-1.61287,7.53513,14.77465,-1.37312,7.31504,14.59502,-1.12463,7.14503,14.52552,-.79938,6.95953,14.53188,-.28631,6.89646,14.62992,.07267,6.87419,14.75852,.38028,5.52461,15.62479,.10451,5.59906,15.79241,.56574,5.73257,16.04294,1.065,5.98238,16.40506,1.30099,6.32065,16.87732,1.50209,6.70614,17.36962,1.43092,7.19012,17.9807,1.29583,7.49169,18.35362,1.16019,7.73976,18.60331,.67492,7.88546,18.74213,.33873,7.96532,18.78281,-.07742,7.93863,18.6921,-.4432,7.94264,18.62599,-.91028,7.81655,18.38937,-1.3818,7.66197,18.15264,-1.61074,7.17004,17.47077,-1.87111,6.82657,17.00906,-1.95867,6.54503,16.65343,-1.8811,6.30708,16.35418,-1.80679,6.04649,16.04294,-1.61763,5.84562,15.81329,-1.40462,5.70123,15.67182,-1.09682,5.55645,15.56012,-.59096,5.52212,15.57188,-.22064,5.52461,15.62479,.10451};
			return value;
		}
		private double[] getCoordinate_10_125_point_6()
		{
			double[] value = {1.48529,15.4115,.09421,1.49001,15.63295,.69566,1.50754,15.98434,1.3485,1.55968,16.54436,1.66348,1.63355,17.28617,1.93618,1.72605,18.0896,1.85696,1.84344,19.0919,1.69812,1.91801,19.70927,1.53232,1.9897,20.16497,.91069,2.03322,20.42546,.47914,2.06349,20.53588,-.05849,2.06734,20.42851,-.53435,2.08121,20.37178,-1.1407,2.06464,20.03991,-1.75728,2.03468,19.68182,-2.05985,1.92636,18.60753,-2.41477,1.84813,17.87059,-2.54022,1.77987,17.28739,-2.44914,1.72193,16.7957,-2.36078,1.6555,16.27228,-2.12408,1.60244,15.87819,-1.85438,1.56001,15.61648,-1.45964,1.51201,15.38161,-.80775,1.4937,15.36087,-.32807,1.48529,15.4115,.09421,-.62295,14.95711,.66798,-.62564,15.34699,1.32583,-.6272,15.90122,2.01559,-.62317,16.62953,2.2628,-.61654,17.56338,2.42052,-.60599,18.49477,2.15142,-.59228,19.64389,1.74522,-.58324,20.33716,1.4152,-.57207,20.74223,.58526,-.56501,20.9575,.02133,-.55883,20.97297,-.63431,-.55587,20.74457,-1.16967,-.55112,20.54806,-1.86939,-.54964,20.02461,-2.52083,-.55131,19.5373,-2.79771,-.56128,18.19345,-2.97915,-.56918,17.29682,-2.96499,-.57714,16.6279,-2.73021,-.58395,16.06642,-2.5187,-.59249,15.49918,-2.12599,-.59974,15.09164,-1.72287,-.60649,14.86707,-1.20191,-.61522,14.72913,-.38481,-.61978,14.80713,.18311,-.62295,14.95711,.66798,-2.604,14.96389,.38803,-2.71903,15.27501,1.06288,-2.85977,15.74224,1.78324,-2.98353,16.42326,2.08802,-3.12744,17.31266,2.32377,-3.2314,18.24308,2.1437,-3.35278,19.39855,1.8493,-3.41812,20.10429,1.58897,-3.39717,20.58144,.81651,-3.37463,20.8475,.28637,-3.31592,20.92917,-.35065,-3.23461,20.76216,-.89202,-3.14247,20.64278,-1.59061,-3.00955,20.20151,-2.27095,-2.91639,19.75717,-2.58343,-2.71352,18.47266,-2.87833,-2.59072,17.60186,-2.94343,-2.51991,16.92942,-2.7737,-2.46181,16.36351,-2.61715,-2.41973,15.77359,-2.28469,-2.40073,15.33746,-1.92804,-2.41799,15.06674,-1.44056,-2.47473,14.8499,-.6571,-2.53824,14.86778,-.09726,-2.604,14.96389,.38803,-5.94386,15.64228,.97444,-6.30852,15.92791,1.56679,-6.78168,16.3367,2.17181,-7.28196,16.88134,2.33015,-7.89408,17.58149,2.37938,-8.426,18.28462,2.01662,-9.06858,19.15294,1.49739,-9.44061,19.67777,1.10208,-9.54055,19.99162,.25573,-9.57102,20.1598,-.31272,-9.45984,20.17883,-.94769,-9.21858,20.0132,-1.43956,-8.96693,19.8734,-2.0937,-8.52005,19.48731,-2.6651,-8.16477,19.12415,-2.87873,-7.2923,18.11609,-2.90558,-6.7351,17.44197,-2.7929,-6.36073,16.93653,-2.49227,-6.04915,16.5121,-2.22597,-5.76737,16.08129,-1.78403,-5.58722,15.77041,-1.34967,-5.54302,15.59573,-.82169,-5.60749,15.48281,-.01724,-5.76086,15.53503,.52268,-5.94386,15.64228,.97444};
			return value;
		}
		private double[] getCoordinate_10_125_point_7()
		{
			double[] value = {-9.67583,15.6729,.53048,-9.90317,15.8154,.91205,-10.20814,16.0231,1.30598,-10.56,16.30981,1.42473,-10.99935,16.68075,1.48063,-11.40593,17.05963,1.27835,-11.90204,17.52862,.98388,-12.19505,17.81334,.75482,-12.31899,17.99301,.23545,-12.37575,18.09106,-.11492,-12.33421,18.11095,-.51232,-12.1899,18.0306,-.82661,-12.04802,17.96646,-1.24171,-11.75999,17.7703,-1.61374,-11.51629,17.58079,-1.76066,-10.88741,17.04604,-1.81354,-10.47785,16.68642,-1.76701,-10.18894,16.41344,-1.59661,-9.94749,16.18401,-1.44484,-9.71685,15.94849,-1.18319,-9.56012,15.77675,-.92199,-9.49591,15.67587,-.59723,-9.49334,15.60352,-.09694,-9.57119,15.62292,.24342,-9.67583,15.6729,.53048,-9.7907,13.73414,.30748,-10.00223,13.76917,.71762,-10.31044,13.822,1.15234,-10.7356,13.89958,1.32523,-11.28561,14.00101,1.45068,-11.84721,14.10745,1.3181,-12.54235,14.23969,1.10969,-12.96434,14.32052,.93262,-13.23038,14.37562,.44413,-13.37551,14.40642,.11028,-13.40473,14.41623,-.28544,-13.2854,14.39756,-.61635,-13.19003,14.38446,-1.04555,-12.89894,14.33456,-1.45612,-12.61787,14.28403,-1.63917,-11.82499,14.1375,-1.79217,-11.29184,14.03806,-1.81254,-10.88723,13.9611,-1.69224,-10.54717,13.89633,-1.58253,-10.19815,13.82868,-1.36351,-9.9437,13.77858,-1.13304,-9.79435,13.74728,-.82546,-9.68742,13.72191,-.33611,-9.7164,13.72353,.00962,-9.7907,13.73414,.30748,-9.76922,12.99402,.29504,-9.96073,12.90275,.70636,-10.23806,12.7639,1.14291,-10.6162,12.55698,1.31859,-11.10436,12.28575,1.44771,-11.6001,11.99942,1.31906,-12.21327,11.6434,1.11553,-12.58496,11.42545,.94146,-12.81538,11.27447,.4551,-12.94038,11.18968,.12245,-12.96215,11.16076,-.27282,-12.85308,11.20866,-.60432,-12.7642,11.24101,-1.0339,-12.50227,11.37214,-1.44619,-12.25158,11.50646,-1.63104,-11.54814,11.89846,-1.78936,-11.07599,12.16502,-1.81336,-10.71909,12.3722,-1.6959,-10.41921,12.54664,-1.58858,-10.11254,12.72952,-1.37209,-9.8897,12.86539,-1.1435,-9.76069,12.95136,-.83714,-9.67112,13.0226,-.34883,-9.70037,13.02053,-.00313,-9.76922,12.99402,.29504,-9.98414,11.83334,.47124,-10.1625,11.69133,.78111,-10.39943,11.48937,1.09927,-10.66612,11.22369,1.18874,-10.99728,10.88296,1.22408,-11.29869,10.54295,1.04674,-11.66554,10.12343,.79097,-11.88111,9.87029,.59431,-11.9639,9.72212,.16179,-11.99958,9.64332,-.12932,-11.96048,9.6374,-.45688,-11.84583,9.72053,-.71317,-11.731,9.79194,-1.05288,-11.50723,9.98269,-1.35337,-11.32124,10.16041,-1.4688,-10.84776,10.65075,-1.49695,-10.54101,10.97796,-1.44832,-10.32735,11.22217,-1.30027,-10.14899,11.42717,-1.16879,-9.98092,11.63434,-.94673,-9.86836,11.78323,-.72687,-9.82658,11.8654,-.45676,-9.83459,11.91609,-.04302,-9.89983,11.88786,.23648,-9.98414,11.83334,.47124};
			return value;
		}
		private double[] getCoordinate_10_125_point_8()
		{
			double[] value = {-9.14178,11.30716,.51169,-9.33327,11.17218,.75221,-9.56864,10.97823,.99289,-9.77899,10.71778,1.03721,-10.0248,10.38248,1.02833,-10.20595,10.04444,.84356,-10.41832,9.62676,.58499,-10.53368,9.37405,.39394,-10.50546,9.22099,.01947,-10.47201,9.13861,-.23023,-10.37727,9.12748,-.50193,-10.24258,9.20528,-.70472,-10.0908,9.27019,-.97783,-9.86851,9.45337,-1.20513,-9.71103,9.6267,-1.28077,-9.36413,10.1096,-1.24921,-9.15298,10.43294,-1.17238,-9.02911,10.67607,-1.02255,-8.9273,10.88027,-.89083,-8.85132,11.08808,-.6839,-8.81489,11.23841,-.48532,-8.83967,11.32377,-.25262,-8.92951,11.38042,.09541,-9.03332,11.35712,.32353,-9.14178,11.30716,.51169,-7.37229,10.27605,.17507,-7.4086,10.14918,.41688,-7.44634,9.96385,.67346,-7.45868,9.70693,.77647,-7.4655,9.37428,.85198,-7.44821,9.03385,.77582,-7.42268,8.61234,.6555,-7.40247,8.35632,.55274,-7.35466,8.1938,.26638,-7.32231,8.10495,.07055,-7.28522,8.08609,-.16202,-7.25547,8.15737,-.35695,-7.21636,8.21385,-.60961,-7.18072,8.38889,-.85193,-7.16616,8.55853,-.96045,-7.15892,9.03816,-1.05293,-7.16172,9.36091,-1.06661,-7.17649,9.60624,-.99717,-7.1897,9.81247,-.93375,-7.21317,10.02444,-.80609,-7.23686,10.17918,-.67139,-7.26681,10.27051,-.49102,-7.3133,10.33669,-.20365,-7.34522,10.32016,-.00029,-7.37229,10.27605,.17507,-6.97333,10.52484,.17789,-6.91363,10.44537,.33364,-6.82552,10.3379,.49608,-6.70102,10.21143,.55121,-6.53929,10.05284,.58363,-6.37234,9.90422,.51355,-6.16539,9.72252,.40925,-6.03941,9.6148,.32593,-5.95738,9.56613,.12419,-5.91217,9.54302,-.01253,-5.90079,9.55513,-.17011,-5.93378,9.60504,-.29737,-5.959,9.65334,-.46431,-6.04222,9.75484,-.61773,-6.12404,9.84196,-.68139,-6.35739,10.06915,-.71711,-6.51487,10.21771,-.70847,-6.63531,10.32352,-.64816,-6.73661,10.41201,-.59407,-6.84131,10.4974,-.49642,-6.91813,10.55604,-.39721,-6.96441,10.58166,-.27075,-6.99941,10.58627,-.07367,-6.99323,10.5606,.0623,-6.97333,10.52484,.17789,-5.60268,11.57347,.0056,-5.65619,11.51597,.1554,-5.71258,11.42415,.31876,-5.73383,11.27636,.40028,-5.74831,11.08032,.47265,-5.72857,10.86725,.45869,-5.69826,10.60132,.42647,-5.67316,10.43739,.38988,-5.60742,10.31539,.2398,-5.56263,10.24551,.13523,-5.5101,10.21518,.00346,-5.46673,10.24269,-.11458,-5.41025,10.25652,-.26445,-5.35699,10.34325,-.41873,-5.33383,10.43755,-.4958,-5.31665,10.72153,-.59073,-5.31602,10.91658,-.62676,-5.33353,11.07131,-.60835,-5.34938,11.20178,-.58998,-5.37975,11.34096,-.53525,-5.41127,11.44593,-.4715,-5.45259,11.51607,-.37601,-5.51783,11.5796,-.21694,-5.56352,11.58605,-.09884,-5.60268,11.57347,.0056};
			return value;
		}

		/** Large attribute array: IndexedFaceSet DEF='airway_Geo' coordIndex field, scene-graph level=8, element #53, 6360 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getairway_Geo_8_53_coordIndex()
		{
			MFInt32 airway_Geo_8_53_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_1()))
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_2()))
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_3()))
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_4()))
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_5()))
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_6()))
				.append(new MFInt32(getairway_Geo_8_53_coordIndex_7()));
			return airway_Geo_8_53_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='airway_Coord' point field, scene-graph level=9, element #53, 2391 total numbers made up of 797 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getairway_Coord_9_53_point()
		{
			MFVec3f airway_Coord_9_53_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getairway_Coord_9_53_point_1()))
				.append(new MFVec3f(getairway_Coord_9_53_point_2()))
				.append(new MFVec3f(getairway_Coord_9_53_point_3()))
				.append(new MFVec3f(getairway_Coord_9_53_point_4()))
				.append(new MFVec3f(getairway_Coord_9_53_point_5()))
				.append(new MFVec3f(getairway_Coord_9_53_point_6()))
				.append(new MFVec3f(getairway_Coord_9_53_point_7()))
				.append(new MFVec3f(getairway_Coord_9_53_point_8()));
			return airway_Coord_9_53_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='GeoSculptedSurface1' coordIndex field, scene-graph level=9, element #71, 2352 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getGeoSculptedSurface1_9_71_coordIndex()
		{
			MFInt32 GeoSculptedSurface1_9_71_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getGeoSculptedSurface1_9_71_coordIndex_1()))
				.append(new MFInt32(getGeoSculptedSurface1_9_71_coordIndex_2()))
				.append(new MFInt32(getGeoSculptedSurface1_9_71_coordIndex_3()));
			return GeoSculptedSurface1_9_71_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #71, 924 total numbers made up of 308 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_71_point()
		{
			MFVec3f Coordinate_10_71_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_71_point_1()))
				.append(new MFVec3f(getCoordinate_10_71_point_2()))
				.append(new MFVec3f(getCoordinate_10_71_point_3()))
				.append(new MFVec3f(getCoordinate_10_71_point_4()));
			return Coordinate_10_71_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='GeoSculptedSurface2' coordIndex field, scene-graph level=9, element #125, 6128 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getGeoSculptedSurface2_9_125_coordIndex()
		{
			MFInt32 GeoSculptedSurface2_9_125_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_1()))
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_2()))
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_3()))
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_4()))
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_5()))
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_6()))
				.append(new MFInt32(getGeoSculptedSurface2_9_125_coordIndex_7()));
			return GeoSculptedSurface2_9_125_coordIndex;
		}
		/** Large attribute array: Coordinate point field, scene-graph level=10, element #125, 2400 total numbers made up of 800 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getCoordinate_10_125_point()
		{
			MFVec3f Coordinate_10_125_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getCoordinate_10_125_point_1()))
				.append(new MFVec3f(getCoordinate_10_125_point_2()))
				.append(new MFVec3f(getCoordinate_10_125_point_3()))
				.append(new MFVec3f(getCoordinate_10_125_point_4()))
				.append(new MFVec3f(getCoordinate_10_125_point_5()))
				.append(new MFVec3f(getCoordinate_10_125_point_6()))
				.append(new MFVec3f(getCoordinate_10_125_point_7()))
				.append(new MFVec3f(getCoordinate_10_125_point_8()));
			return Coordinate_10_125_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return MedicalMetadata model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new MedicalMetadata().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Medical.MedicalMetadata\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Medical.MedicalMetadata self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Medical/MedicalMetadata_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Medical/MedicalMetadata_JavaExport.x3d"; 
                String filenameX3DV = "Medical/MedicalMetadata_JavaExport.x3dv"; 
                String filenameJSON = "Medical/MedicalMetadata_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
