####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesTeethcTop.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesTeethcTop.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Teeth cTop',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesTeethcTop.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesTeethcTop.x3d'),
    Transform(DEF='TeethTopCSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Viewpoint(DEF='TeethTop',description='Teeth Top',position=(0,55,10)),
      Group(DEF='AllTeeth',
        children=[
        Shape(DEF='lcenincc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lcenincc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,26,33,24,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,27,49,50,-1,51,52,53,-1,54,55,56,-1,57,31,30,-1,58,59,60,-1,61,62,63,-1,46,64,65,-1,33,26,66,-1,67,68,69,-1,70,71,72,-1,73,74,75,-1,76,77,73,-1,78,79,80,-1,81,82,62,-1,83,84,63,-1,85,32,86,-1,87,31,88,-1,71,89,72,-1,83,90,91,-1,92,93,67,-1,94,41,65,-1,65,6,94,-1,58,60,95,-1,95,96,58,-1,96,95,93,-1,97,98,36,-1,99,72,100,-1,36,98,101,-1,18,102,103,-1,48,104,105,-1,42,41,106,-1,107,103,108,-1,61,63,84,-1,73,109,110,-1,111,112,113,-1,13,114,115,-1,112,116,117,-1,118,119,115,-1,21,97,22,-1,120,77,76,-1,121,47,40,-1,122,38,123,-1,124,39,38,-1,125,126,99,-1,127,1,128,-1,129,130,6,-1,131,132,133,-1,131,134,132,-1,134,131,135,-1,127,128,136,-1,99,137,125,-1,124,38,122,-1,9,138,10,-1,12,139,13,-1,15,140,16,-1,21,23,113,-1,49,27,29,-1,112,111,116,-1,115,14,13,-1,115,24,14,-1,111,113,23,-1,73,75,109,-1,84,140,61,-1,2,127,141,-1,142,143,144,-1,39,145,146,-1,39,147,145,-1,107,11,103,-1,48,148,104,-1,18,149,102,-1,136,141,127,-1,99,100,4,-1,97,36,150,-1,151,67,93,-1,93,152,96,-1,90,63,62,-1,6,130,94,-1,91,153,83,-1,67,69,154,-1,89,73,110,-1,31,57,88,-1,85,155,32,-1,83,63,90,-1,156,81,89,-1,89,71,156,-1,157,158,82,-1,158,159,82,-1,78,7,79,-1,158,135,160,-1,161,162,163,-1,82,159,62,-1,72,126,70,-1,157,82,164,-1,67,151,68,-1,33,66,104,-1,46,65,41,-1,94,130,165,-1,61,166,62,-1,58,167,59,-1,30,117,57,-1,54,56,168,-1,51,53,155,-1,126,72,99,-1,49,169,50,-1,117,116,57,-1,48,105,46,-1,43,170,44,-1,106,41,94,-1,39,146,37,-1,36,138,34,-1,30,32,171,-1,117,30,112,-1,28,172,29,-1,118,152,119,-1,18,20,149,-1,120,76,166,-1,121,40,173,-1,170,121,173,-1,170,174,121,-1,122,123,175,-1,129,6,8,-1,3,5,176,-1,1,127,2,-1,143,177,2,-1,134,157,132,-1,165,129,178,-1,130,129,165,-1,179,178,180,-1,178,179,165,-1,70,181,182,-1,183,181,70,-1,132,184,133,-1,184,132,185,-1,186,177,143,-1,177,186,187,-1,124,188,189,-1,188,124,190,-1,191,138,9,-1,138,191,34,-1,170,192,174,-1,43,192,170,-1,14,193,12,-1,194,193,14,-1,15,61,140,-1,15,195,61,-1,196,101,98,-1,196,197,101,-1,149,198,114,-1,149,20,198,-1,115,92,24,-1,92,115,119,-1,22,111,23,-1,199,111,22,-1,109,86,87,-1,75,86,109,-1,104,200,105,-1,104,66,200,-1,201,202,203,-1,50,202,201,-1,175,144,204,-1,123,144,175,-1,123,142,144,-1,108,147,107,-1,147,108,145,-1,146,45,44,-1,146,145,45,-1,179,186,106,-1,179,187,186,-1,205,40,42,-1,205,173,40,-1,104,194,33,-1,148,194,104,-1,100,206,4,-1,100,207,206,-1,208,5,209,-1,141,5,208,-1,141,136,5,-1,57,49,29,-1,49,57,116,-1,114,102,149,-1,114,139,102,-1,114,13,139,-1,55,93,95,-1,55,151,93,-1,210,211,212,-1,210,213,211,-1,214,159,158,-1,214,91,159,-1,215,26,25,-1,215,66,26,-1,65,7,6,-1,65,79,7,-1,91,216,153,-1,216,91,214,-1,154,216,163,-1,216,154,69,-1,89,100,72,-1,110,100,89,-1,32,87,86,-1,32,31,87,-1,168,83,54,-1,84,83,168,-1,164,81,156,-1,164,82,81,-1,80,217,162,-1,217,80,79,-1,78,160,135,-1,78,80,160,-1,164,132,157,-1,185,132,164,-1,162,218,163,-1,162,217,218,-1,164,182,185,-1,164,156,182,-1,74,77,219,-1,77,74,73,-1,51,84,168,-1,16,84,51,-1,84,16,140,-1,151,54,68,-1,55,54,151,-1,153,69,68,-1,216,69,153,-1,64,79,65,-1,79,64,217,-1,159,90,62,-1,90,159,91,-1,112,213,113,-1,213,112,211,-1,60,55,95,-1,60,56,55,-1,32,53,171,-1,155,53,32,-1,209,4,206,-1,209,5,4,-1,209,201,208,-1,28,201,209,-1,88,29,172,-1,57,29,88,-1,101,138,36,-1,101,10,138,-1,139,220,102,-1,139,221,220,-1,222,106,186,-1,106,222,42,-1,220,145,108,-1,45,145,220,-1,142,37,222,-1,123,37,142,-1,38,37,123,-1,204,190,175,-1,190,204,203,-1,35,50,169,-1,35,202,50,-1,144,2,141,-1,144,143,2,-1,24,194,14,-1,194,24,33,-1,49,150,169,-1,49,199,150,-1,119,93,92,-1,93,119,152,-1,20,96,198,-1,20,58,96,-1,197,167,19,-1,197,210,167,-1,213,21,113,-1,21,213,196,-1,219,120,195,-1,219,77,120,-1,194,192,193,-1,194,148,192,-1,174,47,121,-1,174,48,47,-1,191,147,189,-1,191,107,147,-1,187,223,177,-1,187,224,223,-1,181,185,182,-1,181,184,185,-1,136,176,5,-1,136,128,176,-1,157,135,158,-1,135,157,134,-1,187,180,224,-1,180,187,179,-1,70,125,183,-1,125,70,126,-1,135,225,78,-1,135,131,225,-1,39,189,147,-1,189,39,124,-1,107,9,11,-1,9,107,191,-1,174,148,48,-1,192,148,174,-1,12,221,139,-1,193,221,12,-1,17,195,15,-1,17,219,195,-1,210,196,213,-1,196,210,197,-1,19,58,20,-1,19,167,58,-1,114,118,115,-1,118,114,198,-1,112,171,211,-1,112,30,171,-1,203,208,201,-1,203,204,208,-1,202,34,188,-1,34,202,35,-1,146,205,37,-1,205,146,44,-1,106,165,179,-1,106,94,165,-1,170,205,44,-1,170,173,205,-1,40,46,41,-1,47,46,40,-1,207,172,206,-1,207,88,172,-1,50,28,27,-1,28,50,201,-1,52,168,56,-1,168,52,51,-1,53,59,212,-1,59,53,52,-1,167,212,59,-1,167,210,212,-1,163,214,161,-1,163,216,214,-1,64,105,200,-1,105,64,46,-1,66,218,200,-1,218,66,215,-1,154,25,67,-1,215,25,154,-1,110,207,100,-1,109,207,110,-1,75,85,86,-1,75,74,85,-1,62,76,81,-1,62,166,76,-1,162,160,80,-1,160,162,161,-1,182,71,70,-1,182,156,71,-1,89,76,73,-1,89,81,76,-1,85,219,17,-1,219,85,74,-1,17,155,85,-1,17,51,155,-1,16,51,17,-1,88,109,87,-1,88,207,109,-1,83,68,54,-1,153,68,83,-1,163,215,154,-1,215,163,218,-1,217,200,218,-1,217,64,200,-1,158,161,214,-1,161,158,160,-1,52,60,59,-1,60,52,56,-1,212,171,53,-1,212,211,171,-1,206,28,209,-1,206,172,28,-1,11,18,103,-1,11,101,18,-1,101,11,10,-1,45,221,43,-1,221,45,220,-1,42,37,205,-1,42,222,37,-1,220,103,102,-1,220,108,103,-1,143,222,186,-1,142,222,143,-1,188,203,202,-1,188,190,203,-1,141,204,144,-1,208,204,141,-1,169,36,35,-1,150,36,169,-1,150,22,97,-1,199,22,150,-1,24,67,25,-1,24,92,67,-1,199,116,111,-1,199,49,116,-1,152,198,96,-1,152,118,198,-1,19,101,197,-1,101,19,18,-1,98,21,196,-1,97,21,98,-1,166,195,120,-1,61,195,166,-1,43,193,192,-1,221,193,43,-1,34,189,188,-1,34,191,189,-1,175,124,122,-1,190,124,175,-1,177,0,2,-1,0,177,223,-1,225,7,78,-1,7,225,8,-1,3,99,4,-1,3,137,99,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lcenincc_Coord',point=[(.04483,55.22987,3.34911),(.02977,55.19933,3.34065),(.04501,55.21437,3.35414),(.01745,55.11031,3.22389),(.01727,55.09589,3.21559),(.00308,55.10297,3.30169),(.21838,55.21498,3.2923),(.23629,55.16999,3.2602),(.23102,55.18426,3.25493),(.08123,54.86571,3.35404),(.08263,54.85694,3.34587),(.09561,54.86563,3.35149),(.22208,54.87579,3.31929),(.2215,54.86837,3.31262),(.23838,54.88037,3.31129),(.12968,54.98547,3.23669),(.13168,54.97462,3.24302),(.11848,54.98541,3.23724),(.129,54.85412,3.33246),(.12829,54.84359,3.32144),(.18384,54.84803,3.30584),(.01439,54.85092,3.32916),(.00892,54.86076,3.32982),(.00967,54.8586,3.32127),(.2684,54.89003,3.2945),(.27162,54.95369,3.28809),(.27091,54.9614,3.30341),(-.00167,54.9688,3.32609),(-.00458,55.02807,3.31747),(-.00132,54.95978,3.29589),(.01295,54.90277,3.27152),(.02082,54.94824,3.24471),(.05617,54.9438,3.25839),(.26031,54.9509,3.32261),(.06804,54.93325,3.3649),(.03587,54.92033,3.36879),(.03734,54.87022,3.35563),(.12315,55.10929,3.37796),(.0948,55.10783,3.37947),(.09362,55.04301,3.37373),(.19633,55.13028,3.34309),(.19278,55.18351,3.34133),(.15519,55.18057,3.35914),(.20444,55.00437,3.35121),(.17357,55.05399,3.36081),(.17724,55.00047,3.3576),(.22624,55.11919,3.33099),(.20686,55.11799,3.33935),(.21668,55.06727,3.34071),(-.0003,54.905,3.32808),(.00594,54.97408,3.36068),(.13324,54.94582,3.25986),(.1336,54.90358,3.26862),(.08676,54.90318,3.27466),(.20954,54.93951,3.22627),(.20983,54.90488,3.24296),(.17311,54.90265,3.25989),(.00543,54.94434,3.2545),(.1809,54.85308,3.29084),(.13083,54.85303,3.29136),(.17682,54.86037,3.27882),(.13508,55.02156,3.19111),(.14005,55.06744,3.12868),(.15528,55.01713,3.1798),(.25091,55.12006,3.297),(.23343,55.17668,3.30505),(.26701,55.02128,3.31329),(.27223,54.93336,3.24783),(.24251,54.954,3.21081),(.26777,54.97458,3.2217),(.06204,55.20051,3.07876),(.07539,55.15443,3.07689),(.05397,55.14066,3.10285),(.08621,55.06642,3.13264),(.08252,55.02198,3.19156),(.06751,55.02233,3.18911),(.10914,55.08205,3.11705),(.10198,55.07107,3.12853),(.22875,55.15105,3.20468),(.23933,55.15913,3.26014),(.22959,55.14407,3.20645),(.1069,55.11507,3.07718),(.13736,55.11637,3.07926),(.20113,54.98583,3.20376),(.16549,54.98214,3.23032),(.08408,54.98523,3.23912),(.05961,54.98708,3.22879),(.02538,54.98462,3.22139),(.00922,54.99339,3.23511),(.07914,55.10694,3.09074),(.18989,55.01793,3.17244),(.21556,55.03903,3.16269),(.2688,54.88651,3.27258),(.26276,54.87581,3.25627),(.1844,55.23193,3.33447),(.21449,54.86357,3.2665),(.21626,54.85924,3.27706),(.01232,54.86014,3.33846),(.04262,54.85531,3.3427),(.02752,55.15416,3.16173),(.02629,55.06935,3.16262),(.08337,54.85234,3.34067),(.18335,54.86615,3.33096),(.13282,54.86673,3.34204),(.24627,55.01375,3.33614),(.23496,55.07345,3.33869),(.15091,55.23054,3.35164),(.08987,54.93212,3.36287),(.13406,54.94147,3.36579),(.03554,55.02308,3.18409),(.05435,55.05043,3.13855),(.00647,54.86818,3.31551),(.01316,54.85002,3.29796),(.01135,54.84749,3.3134),(.22087,54.86396,3.30767),(.26691,54.87904,3.29059),(.00248,54.90063,3.28229),(.00527,54.901,3.2721),(.26569,54.87149,3.28086),(.26749,54.88019,3.27605),(.10987,55.07339,3.12649),(.19719,55.11739,3.34356),(.0839,55.1047,3.3809),(.08482,55.11751,3.37997),(.08271,55.043,3.37318),(.04986,55.21381,3.10288),(.05121,55.19897,3.10134),(.02973,55.18691,3.34818),(.0152,55.13846,3.31806),(.21511,55.23189,3.28823),(.20919,55.23015,3.29876),(.20441,55.18127,3.1564),(.16893,55.21914,3.08424),(.16829,55.23434,3.08598),(.1991,55.17643,3.13859),(.20747,55.16582,3.15483),(.01728,55.14194,3.33518),(.02547,55.16174,3.17624),(.06512,54.86705,3.35532),(.20776,54.87182,3.32428),(.14074,54.98444,3.23468),(.01984,55.14247,3.35763),(.08265,55.16765,3.37671),(.07417,55.21215,3.36915),(.05618,55.15885,3.37463),(.13433,54.99602,3.37318),(.12909,55.04902,3.38058),(.09231,54.98776,3.37153),(.22407,55.00693,3.34471),(.18502,54.85636,3.31827),(.01014,54.87357,3.34463),(.24982,54.91056,3.23314),(.26422,54.8734,3.26667),(.22941,54.99398,3.19228),(.27364,54.98367,3.23695),(.09048,54.94659,3.2591),(.09851,55.16139,3.05725),(.17296,55.14631,3.0851),(.20454,55.09856,3.13574),(.17942,55.07832,3.12439),(.21935,55.12759,3.17731),(.2423,55.0795,3.20031),(.2482,55.08451,3.21859),(.26056,55.03596,3.22119),(.13399,55.1639,3.05851),(.18096,55.26746,3.31903),(.11993,55.0714,3.1272),(.12603,54.8481,3.30628),(.17067,54.94642,3.25098),(.0104,54.90698,3.35322),(.19728,55.06392,3.3482),(.04752,54.89986,3.27395),(.002,55.01035,3.27438),(.18788,55.11458,3.34979),(.20753,55.06559,3.34341),(.07293,55.10162,3.38027),(.00654,55.11315,3.29762),(.0764,55.24937,3.35581),(.18079,55.28048,3.3124),(.15062,55.2767,3.33734),(.1493,55.28986,3.3323),(.09596,55.21538,3.05503),(.0967,55.20079,3.05495),(.06175,55.21527,3.07816),(.13044,55.22117,3.05591),(.132,55.20668,3.05589),(.11953,55.23762,3.36237),(.12113,55.27532,3.35297),(.07048,54.989,3.37248),(.08138,54.98838,3.37109),(.0718,55.04301,3.37396),(.07894,54.9327,3.36361),(.21511,55.00579,3.34798),(.22113,54.94675,3.34121),(.23135,54.94804,3.33603),(.1243,55.02215,3.19428),(.04643,54.84277,3.33112),(.08276,54.8406,3.32888),(.21969,54.85551,3.29408),(.00564,54.87287,3.32922),(.26226,55.06163,3.30298),(.00502,55.03346,3.35647),(.03612,54.97513,3.37593),(.03677,55.04174,3.37724),(.0462,55.0941,3.37887),(.16934,55.10896,3.36234),(.0036,55.05579,3.24797),(.01532,55.0292,3.20164),(.01285,55.0925,3.35705),(-.00097,55.084,3.30508),(.0812,54.84459,3.31181),(.04686,54.84569,3.29707),(.08502,54.84914,3.29716),(.0453,54.84161,3.31364),(.23636,55.05118,3.17247),(.27085,55.00866,3.27628),(.25181,55.01137,3.19938),(.25559,55.09846,3.26537),(.26398,55.05246,3.2707),(.11297,55.02101,3.196),(.18089,54.94358,3.35078),(.21033,54.94566,3.34394),(.12004,55.17562,3.37348),(.07406,55.2627,3.35012),(.11822,55.2885,3.34822),(.22366,55.16794,3.20217)]))),
        Shape(DEF='lcaninec',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lcaninec_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,1,0,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,16,19,17,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,32,35,36,-1,37,36,38,-1,39,40,41,-1,42,41,40,-1,43,15,44,-1,45,46,47,-1,47,48,49,-1,50,51,52,-1,53,54,49,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,66,-1,67,63,62,-1,66,68,58,-1,69,70,41,-1,21,71,72,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,79,82,83,-1,84,78,77,-1,85,67,86,-1,47,56,87,-1,88,89,5,-1,90,91,92,-1,61,66,65,-1,93,94,52,-1,56,47,49,-1,95,90,96,-1,97,98,99,-1,100,84,101,-1,102,103,104,-1,101,105,106,-1,25,107,108,-1,109,110,42,-1,111,16,112,-1,113,114,115,-1,18,112,16,-1,105,33,116,-1,24,23,117,-1,118,119,120,-1,121,122,123,-1,124,31,125,-1,126,127,112,-1,128,129,130,-1,131,132,133,-1,134,35,34,-1,125,31,30,-1,27,135,118,-1,30,136,137,-1,138,139,140,-1,141,142,121,-1,143,144,145,-1,118,146,27,-1,117,120,119,-1,107,33,105,-1,106,114,113,-1,90,92,96,-1,147,148,100,-1,1,149,150,-1,80,151,74,-1,73,97,99,-1,152,10,153,-1,154,155,156,-1,157,14,60,-1,158,159,48,-1,160,161,162,-1,71,163,164,-1,94,165,166,-1,41,42,69,-1,152,11,10,-1,167,99,98,-1,46,45,156,-1,168,155,154,-1,149,169,150,-1,75,170,171,-1,98,97,172,-1,120,117,92,-1,108,173,95,-1,174,21,72,-1,67,59,63,-1,110,109,65,-1,175,66,176,-1,109,61,65,-1,177,178,60,-1,179,180,181,-1,57,49,54,-1,161,49,50,-1,182,183,50,-1,46,48,47,-1,49,57,56,-1,93,184,174,-1,33,32,116,-1,185,145,174,-1,134,24,186,-1,36,35,38,-1,28,27,187,-1,1,188,2,-1,189,163,190,-1,191,13,15,-1,13,191,152,-1,192,169,149,-1,16,193,194,-1,71,164,195,-1,194,19,16,-1,192,196,169,-1,193,16,111,-1,197,81,74,-1,152,191,198,-1,87,56,177,-1,123,199,136,-1,38,200,37,-1,166,39,41,-1,185,174,72,-1,94,41,70,-1,174,165,93,-1,48,201,49,-1,52,162,50,-1,161,53,49,-1,180,175,181,-1,175,64,66,-1,146,86,62,-1,67,157,59,-1,41,94,166,-1,108,95,96,-1,12,197,73,-1,202,77,76,-1,81,11,79,-1,96,92,25,-1,73,75,171,-1,154,88,168,-1,156,158,46,-1,98,154,167,-1,21,184,22,-1,20,159,163,-1,160,203,161,-1,46,158,48,-1,60,59,157,-1,64,69,110,-1,156,167,154,-1,153,13,152,-1,73,99,12,-1,80,74,81,-1,172,188,150,-1,150,188,1,-1,108,107,101,-1,107,105,101,-1,146,61,109,-1,146,62,61,-1,106,116,114,-1,116,204,114,-1,107,34,33,-1,143,145,185,-1,199,123,122,-1,205,206,207,-1,27,124,135,-1,129,208,209,-1,132,127,126,-1,126,204,132,-1,111,112,210,-1,131,127,132,-1,211,111,212,-1,124,125,135,-1,213,214,215,-1,146,118,120,-1,117,186,24,-1,25,24,134,-1,105,116,106,-1,113,115,216,-1,110,69,42,-1,108,96,25,-1,106,100,101,-1,197,12,81,-1,173,108,77,-1,53,161,203,-1,22,159,20,-1,20,71,21,-1,93,52,51,-1,160,94,70,-1,61,68,66,-1,5,4,88,-1,86,217,85,-1,218,164,163,-1,79,83,80,-1,73,197,74,-1,94,93,165,-1,58,176,66,-1,86,67,62,-1,160,52,94,-1,64,110,65,-1,63,68,61,-1,60,178,58,-1,57,181,55,-1,14,177,60,-1,182,201,22,-1,162,161,50,-1,45,47,153,-1,12,219,10,-1,51,50,183,-1,43,191,15,-1,52,160,162,-1,208,220,209,-1,208,129,186,-1,200,38,128,-1,32,34,35,-1,28,187,221,-1,123,205,121,-1,26,124,27,-1,21,174,184,-1,114,222,115,-1,163,71,20,-1,11,81,12,-1,7,9,223,-1,6,192,1,-1,3,224,4,-1,225,226,227,-1,1,192,149,-1,228,227,229,-1,227,228,225,-1,230,19,231,-1,232,19,230,-1,233,234,235,-1,234,233,236,-1,237,238,239,-1,238,237,240,-1,218,241,164,-1,218,242,241,-1,13,177,14,-1,13,87,177,-1,168,190,155,-1,168,189,190,-1,31,26,29,-1,31,124,26,-1,35,186,38,-1,35,134,186,-1,223,72,7,-1,223,185,72,-1,40,243,42,-1,40,139,243,-1,51,184,93,-1,51,183,184,-1,54,181,57,-1,54,179,181,-1,55,58,178,-1,55,176,58,-1,244,75,245,-1,75,244,170,-1,169,89,150,-1,169,5,89,-1,239,189,168,-1,239,238,189,-1,90,246,91,-1,246,90,247,-1,71,7,72,-1,71,195,7,-1,159,190,163,-1,159,158,190,-1,179,160,180,-1,179,203,160,-1,64,180,69,-1,175,180,64,-1,219,156,45,-1,219,167,156,-1,248,82,249,-1,248,83,82,-1,250,172,171,-1,188,172,250,-1,188,103,2,-1,250,103,188,-1,104,113,216,-1,147,113,104,-1,234,213,215,-1,251,213,234,-1,134,107,25,-1,134,34,107,-1,223,143,185,-1,223,235,143,-1,142,145,144,-1,145,142,252,-1,253,243,254,-1,253,221,243,-1,136,255,137,-1,199,255,136,-1,256,255,199,-1,137,257,258,-1,255,257,137,-1,259,135,125,-1,259,260,135,-1,261,262,263,-1,264,262,261,-1,265,262,212,-1,262,265,266,-1,130,267,133,-1,267,130,268,-1,127,210,112,-1,210,127,131,-1,210,212,111,-1,210,265,212,-1,268,129,209,-1,268,130,129,-1,211,262,264,-1,211,212,262,-1,259,268,260,-1,259,267,268,-1,125,269,259,-1,258,269,125,-1,255,263,257,-1,214,263,255,-1,252,141,270,-1,252,142,141,-1,215,235,234,-1,235,215,143,-1,18,126,112,-1,222,126,18,-1,261,251,226,-1,261,213,251,-1,106,147,100,-1,106,113,147,-1,102,2,103,-1,0,2,102,-1,171,271,250,-1,171,170,271,-1,77,101,84,-1,77,108,101,-1,249,272,247,-1,249,82,272,-1,157,85,44,-1,157,67,85,-1,91,85,217,-1,91,246,85,-1,54,203,179,-1,53,203,54,-1,189,218,163,-1,238,218,189,-1,202,83,248,-1,202,80,83,-1,151,78,245,-1,151,76,78,-1,181,176,55,-1,176,181,175,-1,139,254,243,-1,139,138,254,-1,140,166,270,-1,140,39,166,-1,200,130,133,-1,200,128,130,-1,221,26,28,-1,253,26,221,-1,29,205,123,-1,205,29,206,-1,264,273,211,-1,228,273,264,-1,122,142,144,-1,122,121,142,-1,164,274,195,-1,164,241,274,-1,194,231,19,-1,231,194,275,-1,242,238,240,-1,218,238,242,-1,251,236,276,-1,251,234,236,-1,232,6,0,-1,232,230,6,-1,277,193,273,-1,193,277,278,-1,233,223,9,-1,235,223,233,-1,239,224,237,-1,239,4,224,-1,276,226,251,-1,276,227,226,-1,17,222,18,-1,222,17,115,-1,184,182,22,-1,184,183,182,-1,220,186,117,-1,220,208,186,-1,29,253,206,-1,29,26,253,-1,32,37,132,-1,32,36,37,-1,186,128,38,-1,129,128,186,-1,165,270,166,-1,252,270,165,-1,44,14,157,-1,14,44,15,-1,10,45,153,-1,219,45,10,-1,47,13,153,-1,87,13,47,-1,178,56,55,-1,56,178,177,-1,59,68,63,-1,58,68,59,-1,245,84,244,-1,245,78,84,-1,4,168,88,-1,4,239,168,-1,43,247,272,-1,43,246,247,-1,260,209,119,-1,260,268,209,-1,180,70,69,-1,180,160,70,-1,95,247,90,-1,95,249,247,-1,80,76,151,-1,76,80,202,-1,173,249,95,-1,173,248,249,-1,244,100,148,-1,244,84,100,-1,250,104,103,-1,104,250,271,-1,216,102,104,-1,216,279,102,-1,279,115,17,-1,216,115,279,-1,119,220,117,-1,119,209,220,-1,109,27,146,-1,109,187,27,-1,42,187,109,-1,221,42,243,-1,42,221,187,-1,205,141,121,-1,205,207,141,-1,256,214,255,-1,215,214,256,-1,30,258,125,-1,30,137,258,-1,118,260,119,-1,135,260,118,-1,266,263,262,-1,263,266,257,-1,266,280,269,-1,266,265,280,-1,280,133,267,-1,280,131,133,-1,132,200,133,-1,132,37,200,-1,32,204,116,-1,32,132,204,-1,131,265,210,-1,265,131,280,-1,267,269,280,-1,269,267,259,-1,257,269,258,-1,257,266,269,-1,263,213,261,-1,263,214,213,-1,206,254,207,-1,206,253,254,-1,141,254,138,-1,254,141,207,-1,256,143,215,-1,256,144,143,-1,138,270,141,-1,270,138,140,-1,222,204,126,-1,114,204,222,-1,232,17,19,-1,17,232,279,-1,226,264,261,-1,226,228,264,-1,225,228,226,-1,120,86,146,-1,120,217,86,-1,279,0,102,-1,232,0,279,-1,271,147,104,-1,271,148,147,-1,98,150,89,-1,150,98,172,-1,148,170,244,-1,271,170,148,-1,198,82,79,-1,82,198,272,-1,44,246,43,-1,246,44,85,-1,92,217,120,-1,217,92,91,-1,272,191,43,-1,191,272,198,-1,99,219,12,-1,167,219,99,-1,158,155,190,-1,158,156,155,-1,89,154,98,-1,89,88,154,-1,22,48,159,-1,22,201,48,-1,97,171,172,-1,73,171,97,-1,92,23,25,-1,117,23,92,-1,77,248,173,-1,248,77,202,-1,245,74,151,-1,74,245,75,-1,201,50,49,-1,201,182,50,-1,252,174,145,-1,252,165,174,-1,39,139,40,-1,140,139,39,-1,123,30,29,-1,123,136,30,-1,211,193,111,-1,273,193,211,-1,152,79,11,-1,152,198,79,-1,256,122,144,-1,199,122,256,-1,193,275,194,-1,193,278,275,-1,195,8,7,-1,195,274,8,-1,229,273,228,-1,273,229,277,-1,169,3,5,-1,169,196,3,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lcaninec_Coord',point=[(.46165,55.15754,3.07854),(.42787,55.1775,2.99905),(.44062,55.15675,3.03303),(.40591,55.23378,2.92666),(.42544,55.23123,2.90289),(.40535,55.21763,2.92112),(.46538,55.17135,3.07865),(.60266,55.21205,2.89734),(.60103,55.22732,2.89954),(.6258,55.21906,2.92166),(.46023,55.08116,2.93402),(.45867,55.06604,2.96444),(.44396,55.07311,2.96238),(.4907,55.0682,2.92392),(.50543,55.05009,2.92959),(.49875,55.05049,2.93272),(.56312,55.20797,3.15574),(.51292,55.151,3.14519),(.53595,55.15019,3.1583),(.51642,55.18865,3.14197),(.53554,55.15703,2.86185),(.58514,55.1474,2.86911),(.55765,55.1218,2.87099),(.56091,54.90313,3.05739),(.56612,54.93691,3.08896),(.54257,54.90762,3.07577),(.65492,54.97007,2.99046),(.6406,54.92451,2.98373),(.64371,54.93013,2.97614),(.66151,55.01718,2.99301),(.6625,55.03098,2.99806),(.66166,55.01474,3.00242),(.54009,55.00067,3.13588),(.52373,54.98648,3.13092),(.55079,54.96369,3.10984),(.56144,54.97532,3.11812),(.56007,54.99099,3.13248),(.56771,55.01,3.13785),(.57175,54.98651,3.12688),(.6647,54.99375,2.88531),(.66053,54.9605,2.89551),(.64429,54.99031,2.88317),(.64528,54.93888,2.91012),(.50845,55.00272,2.96452),(.51839,54.99916,2.94673),(.47686,55.09322,2.90709),(.49567,55.09938,2.8925),(.50062,55.09054,2.89808),(.5191,55.09768,2.8824),(.52343,55.08954,2.88731),(.58766,55.08962,2.88714),(.61848,55.08066,2.88304),(.61933,55.07004,2.88421),(.54531,55.07815,2.88766),(.53832,55.07307,2.89285),(.54172,55.04625,2.91086),(.51775,55.07493,2.9035),(.53236,55.07324,2.89978),(.55485,55.01022,2.93286),(.54805,55.00592,2.93663),(.52019,55.04838,2.92153),(.59851,54.93,2.94964),(.58846,54.91254,2.96962),(.56576,54.97384,2.9514),(.59058,54.98181,2.93149),(.6014,54.935,2.94393),(.58365,54.98625,2.94132),(.55478,54.96759,2.95179),(.57459,54.98034,2.94732),(.6124,54.97335,2.90866),(.62597,55.0203,2.88012),(.57083,55.18145,2.8665),(.61519,55.17739,2.89289),(.4297,55.07431,2.98262),(.4515,55.0443,2.99855),(.44183,55.04386,3.00583),(.48227,54.9589,3.03947),(.49082,54.93383,3.06224),(.47319,54.96189,3.04439),(.46967,55.04581,2.97671),(.47814,54.99799,3.01024),(.45847,55.05342,2.99011),(.48843,55.00114,2.99637),(.48459,54.9999,3.00129),(.45569,54.97232,3.06929),(.53829,54.95639,2.96099),(.58018,54.90797,2.97516),(.50723,55.07243,2.90808),(.42362,55.20476,2.89961),(.40706,55.18734,2.92156),(.53179,54.9114,3.02582),(.55086,54.90423,3.00701),(.5577,54.89534,3.03947),(.62673,55.07609,2.88377),(.63311,55.06156,2.88205),(.51923,54.91938,3.03629),(.5267,54.9026,3.065),(.41793,55.11128,2.95314),(.41134,55.14227,2.92351),(.4275,55.10473,2.93453),(.46009,54.98258,3.09582),(.47777,54.92665,3.09259),(.45913,55.12682,3.0853),(.44887,55.12199,3.06253),(.45301,55.06967,3.09036),(.49596,54.95714,3.1152),(.47889,54.99604,3.12436),(.51862,54.92993,3.1029),(.50235,54.90783,3.0804),(.62074,54.9109,2.9574),(.60382,54.94353,2.93607),(.61732,55.1974,3.1468),(.56947,55.14602,3.15857),(.47231,55.04215,3.12851),(.5046,55.0632,3.15203),(.50078,55.09139,3.15033),(.50896,55.01579,3.14132),(.56397,54.90237,3.05433),(.62781,54.90967,3.00669),(.60741,54.90861,3.0431),(.59079,54.88407,3.01564),(.66707,55.08913,2.95374),(.66353,55.10608,2.95475),(.6656,55.09023,2.96427),(.65593,54.969,3.00014),(.65962,55.00454,3.0452),(.54714,55.08357,3.15741),(.57327,55.07465,3.14838),(.58242,54.97642,3.11907),(.58004,54.9537,3.09812),(.5923,54.96789,3.10778),(.60892,55.063,3.13702),(.56387,55.03202,3.14622),(.60026,55.02492,3.12831),(.56293,54.9557,3.09929),(.64582,54.94645,3.03004),(.66641,55.08166,2.97812),(.66733,55.06193,3.00964),(.6777,54.99794,2.91765),(.6716,54.97003,2.90754),(.67308,54.99502,2.89678),(.67953,55.04474,2.91682),(.67057,55.08465,2.91719),(.64657,55.18788,2.93804),(.65431,55.1422,2.93319),(.64791,55.13521,2.90485),(.61033,54.89338,2.98328),(.4542,55.02912,3.09846),(.444,55.02938,3.06848),(.42186,55.18506,2.9895),(.40685,55.16332,2.95734),(.46852,55.00096,3.01628),(.46999,55.06587,2.94817),(.48303,55.08538,2.91543),(.42476,55.1609,2.8966),(.44471,55.18274,2.87673),(.4574,55.12773,2.8823),(.53626,55.0001,2.94008),(.47923,55.13608,2.87409),(.5017,55.14599,2.87038),(.60585,55.04365,2.8802),(.57877,55.08007,2.88208),(.59625,55.0705,2.88743),(.50501,55.20849,2.86049),(.53591,55.2279,2.86662),(.65213,55.07535,2.87466),(.65944,55.03027,2.87798),(.44064,55.11449,2.90594),(.44578,55.21939,2.88471),(.40369,55.22006,2.95329),(.42934,55.04915,3.02696),(.42061,55.0798,3.00656),(.41068,55.11997,2.97352),(.49589,54.9301,3.05771),(.637,55.12575,2.8788),(.57155,55.01463,2.91927),(.56299,55.01533,2.92458),(.51077,55.0646,2.91368),(.53091,55.04645,2.917),(.55224,55.05067,2.89675),(.58081,55.01132,2.90394),(.54811,55.04505,2.90647),(.57856,55.09819,2.87827),(.60275,55.09965,2.8806),(.61222,55.10691,2.88009),(.63176,55.183,2.91272),(.5739,54.94776,3.09212),(.63816,54.92505,2.97141),(.42227,55.13664,2.99589),(.47331,55.22436,2.86933),(.47332,55.19737,2.86163),(.49383,55.04981,2.94048),(.42952,55.19501,2.99962),(.61209,55.26017,3.14545),(.56321,55.22648,3.15343),(.56872,55.22036,2.87519),(.40481,55.23504,2.95714),(.44216,55.06304,2.98087),(.48024,55.04828,2.96284),(.66629,55.10545,2.9663),(.58111,54.99782,3.12766),(.53044,55.09571,2.88169),(.48872,54.95718,3.03673),(.56367,55.06644,2.88321),(.53316,55.05108,3.1523),(.6674,55.07478,2.96196),(.66462,55.02152,2.97795),(.67317,55.04338,2.95774),(.57959,54.93802,3.08488),(.58661,54.92671,3.0739),(.61431,55.12931,3.14405),(.64247,55.23033,3.12777),(.64425,55.17822,3.12474),(.66831,55.22207,3.0344),(.67056,55.1644,3.03156),(.66283,55.19613,2.97602),(.47506,55.08786,3.12527),(.56805,54.90339,2.98676),(.5008,55.23742,2.86223),(.45547,55.08926,2.92704),(.56817,54.90689,3.05796),(.64754,54.9339,2.96834),(.51486,55.08987,3.15832),(.62841,55.20516,2.91771),(.42421,55.24563,2.90562),(.66216,55.25801,3.0791),(.66378,55.25627,3.0703),(.66236,55.27104,3.07096),(.65615,55.26121,3.10311),(.65388,55.27502,3.10222),(.487,55.17646,3.11189),(.51926,55.20615,3.1397),(.48709,55.16279,3.11733),(.64171,55.22091,2.94465),(.66214,55.21762,2.98376),(.64411,55.20687,2.94145),(.65869,55.23115,2.98163),(.4444,55.25138,2.8873),(.47243,55.24012,2.87043),(.44476,55.23699,2.88562),(.47182,55.25456,2.87191),(.53607,55.24118,2.86782),(.50213,55.25211,2.8641),(.66173,54.9505,2.93528),(.43967,55.01885,3.04737),(.45601,55.0053,3.02496),(.52681,54.95564,2.98209),(.51841,54.95399,2.99845),(.49637,54.95522,3.0278),(.50796,54.95248,3.015),(.4296,55.10233,3.02606),(.66745,55.24176,3.03977),(.66346,55.08069,2.89463),(.658,54.97311,2.97846),(.67294,55.00014,2.95339),(.67015,55.11661,3.02085),(.66705,55.13827,2.97106),(.66808,55.11056,3.06484),(.66735,55.04456,3.05444),(.64585,55.00278,3.07478),(.63077,54.94617,3.06254),(.6647,55.23276,3.07052),(.66172,55.17247,3.1011),(.66818,55.16237,3.07197),(.65845,55.24152,3.10389),(.6402,55.11902,3.12188),(.6578,55.11328,3.09832),(.6241,55.00813,3.10213),(.60905,54.95743,3.09064),(.65452,55.04779,3.08578),(.67111,55.03785,2.89615),(.43673,55.06045,3.05357),(.49778,55.00333,2.98152),(.63854,55.26156,3.12576),(.5682,55.23513,2.87989),(.56387,55.24204,3.15072),(.66521,55.25688,3.04004),(.63646,55.27525,3.12415),(.61069,55.27404,3.144),(.48299,55.1428,3.11842),(.63332,55.06435,3.11423)]))),
        Shape(DEF='lmolar1c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lmolar1c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,17,28,-1,29,30,31,-1,32,33,34,-1,26,25,35,-1,36,24,17,-1,37,38,39,-1,40,41,42,-1,43,21,23,-1,44,23,1,-1,45,46,47,-1,48,49,50,-1,47,51,52,-1,53,54,55,-1,48,50,56,-1,57,58,59,-1,45,60,61,-1,62,63,64,-1,62,60,55,-1,65,66,67,-1,68,66,69,-1,53,70,54,-1,71,0,72,-1,73,70,74,-1,48,75,49,-1,76,69,77,-1,50,78,56,-1,79,80,81,-1,81,82,83,-1,84,85,29,-1,86,84,33,-1,85,84,86,-1,44,1,0,-1,87,88,32,-1,89,90,91,-1,92,93,94,-1,95,38,37,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,18,20,6,-1,87,114,115,-1,19,116,117,-1,118,119,120,-1,121,118,122,-1,123,115,114,-1,124,125,126,-1,127,128,129,-1,130,131,121,-1,124,132,125,-1,121,131,133,-1,120,119,19,-1,119,7,6,-1,134,18,135,-1,136,117,111,-1,119,20,19,-1,137,103,102,-1,100,138,40,-1,99,139,95,-1,37,92,94,-1,140,10,14,-1,87,141,88,-1,142,143,34,-1,26,28,24,-1,24,36,80,-1,36,16,80,-1,83,42,41,-1,79,144,145,-1,56,78,146,-1,76,147,68,-1,77,148,76,-1,149,150,1,-1,146,138,151,-1,148,62,54,-1,64,152,61,-1,45,47,52,-1,60,153,55,-1,99,67,100,-1,76,48,56,-1,154,155,51,-1,155,156,157,-1,70,73,50,-1,52,158,55,-1,149,1,23,-1,101,40,42,-1,41,144,159,-1,38,160,161,-1,16,36,17,-1,16,15,82,-1,132,30,85,-1,35,25,34,-1,162,163,164,-1,7,165,166,-1,116,167,112,-1,9,12,10,-1,18,134,167,-1,135,6,8,-1,168,169,50,-1,73,170,168,-1,29,171,35,-1,4,156,5,-1,157,4,3,-1,172,173,174,-1,173,163,162,-1,172,163,173,-1,2,1,150,-1,156,175,5,-1,4,157,156,-1,73,74,170,-1,168,176,169,-1,18,6,135,-1,104,107,177,-1,12,14,10,-1,167,134,178,-1,165,43,166,-1,162,164,179,-1,35,34,33,-1,91,31,180,-1,30,29,85,-1,28,26,171,-1,16,82,81,-1,38,161,39,-1,101,42,181,-1,32,143,142,-1,176,168,149,-1,46,167,47,-1,49,70,50,-1,157,182,155,-1,51,155,182,-1,54,62,55,-1,62,64,60,-1,61,60,64,-1,60,45,153,-1,54,75,148,-1,178,183,47,-1,151,147,146,-1,158,182,53,-1,49,75,70,-1,148,48,76,-1,146,147,56,-1,79,159,144,-1,83,184,42,-1,16,81,80,-1,34,185,142,-1,88,86,32,-1,21,142,22,-1,140,14,89,-1,37,94,95,-1,186,57,97,-1,99,95,59,-1,100,40,101,-1,111,187,136,-1,116,18,167,-1,6,20,119,-1,125,188,141,-1,141,115,125,-1,133,123,121,-1,124,189,132,-1,130,190,131,-1,127,191,128,-1,131,126,133,-1,123,133,115,-1,121,123,118,-1,118,192,119,-1,117,193,19,-1,115,141,87,-1,19,18,116,-1,111,113,109,-1,108,194,109,-1,107,195,105,-1,102,104,177,-1,98,196,96,-1,95,139,38,-1,92,197,93,-1,89,14,90,-1,32,142,87,-1,86,188,85,-1,33,32,86,-1,28,171,29,-1,28,17,24,-1,81,159,79,-1,185,24,80,-1,56,147,76,-1,76,68,69,-1,48,148,75,-1,5,71,72,-1,70,75,54,-1,66,198,69,-1,66,151,67,-1,69,63,77,-1,178,47,167,-1,153,52,55,-1,58,99,59,-1,157,53,182,-1,158,53,55,-1,50,73,168,-1,45,52,153,-1,142,21,87,-1,44,43,23,-1,40,144,41,-1,37,39,199,-1,26,35,171,-1,143,32,34,-1,31,28,29,-1,27,28,31,-1,31,200,27,-1,15,17,27,-1,201,9,11,-1,135,8,134,-1,8,178,134,-1,5,72,3,-1,0,2,72,-1,183,71,175,-1,5,175,71,-1,74,202,170,-1,11,203,201,-1,204,203,11,-1,93,205,196,-1,206,205,93,-1,195,207,105,-1,208,207,195,-1,209,128,210,-1,209,211,128,-1,212,213,214,-1,213,212,215,-1,216,217,218,-1,216,219,217,-1,202,150,170,-1,202,2,150,-1,202,157,3,-1,202,74,157,-1,175,154,183,-1,175,220,154,-1,221,176,22,-1,176,221,169,-1,177,106,222,-1,107,106,177,-1,160,223,161,-1,160,184,223,-1,99,181,139,-1,99,101,181,-1,224,122,225,-1,226,122,224,-1,227,64,63,-1,152,64,227,-1,154,47,183,-1,51,47,154,-1,185,22,142,-1,185,221,22,-1,185,25,24,-1,185,34,25,-1,228,229,180,-1,229,228,230,-1,163,140,164,-1,231,140,163,-1,184,181,42,-1,184,160,181,-1,9,199,12,-1,9,232,199,-1,57,233,58,-1,233,57,186,-1,227,234,235,-1,198,234,227,-1,236,137,102,-1,236,235,137,-1,113,45,237,-1,45,113,46,-1,222,102,177,-1,222,238,102,-1,187,239,136,-1,240,239,187,-1,112,46,113,-1,112,167,46,-1,124,131,241,-1,124,126,131,-1,242,136,239,-1,243,136,242,-1,244,243,242,-1,244,224,243,-1,121,226,130,-1,226,121,122,-1,245,130,226,-1,245,246,130,-1,247,248,190,-1,247,191,248,-1,191,210,128,-1,191,247,210,-1,212,245,244,-1,249,245,212,-1,248,250,241,-1,248,251,250,-1,242,212,244,-1,212,242,215,-1,118,225,122,-1,225,118,120,-1,239,215,242,-1,239,252,215,-1,189,30,132,-1,30,189,228,-1,116,111,117,-1,116,112,111,-1,237,109,113,-1,110,109,237,-1,238,108,110,-1,238,222,108,-1,253,152,236,-1,253,61,152,-1,233,235,234,-1,233,137,235,-1,58,234,65,-1,234,58,233,-1,58,67,99,-1,65,67,58,-1,9,254,232,-1,9,201,254,-1,255,161,223,-1,256,161,255,-1,200,91,90,-1,91,200,31,-1,89,180,229,-1,89,91,180,-1,188,88,141,-1,188,86,88,-1,80,221,185,-1,80,79,221,-1,40,146,144,-1,40,138,146,-1,0,178,166,-1,0,183,178,-1,0,71,183,-1,227,69,198,-1,63,69,227,-1,182,52,51,-1,182,158,52,-1,244,226,224,-1,245,226,244,-1,92,199,232,-1,92,37,199,-1,191,251,248,-1,191,127,251,-1,13,90,14,-1,13,256,90,-1,222,257,108,-1,106,257,222,-1,155,175,156,-1,154,175,155,-1,220,175,154,-1,252,213,215,-1,258,213,252,-1,259,210,260,-1,259,209,210,-1,207,217,105,-1,207,218,217,-1,196,261,96,-1,205,261,196,-1,201,262,254,-1,203,262,201,-1,263,11,231,-1,263,204,11,-1,197,206,93,-1,264,206,197,-1,265,208,195,-1,266,208,265,-1,211,129,128,-1,211,267,129,-1,249,214,268,-1,214,249,212,-1,219,269,270,-1,216,269,219,-1,2,3,72,-1,2,202,3,-1,194,240,187,-1,271,240,194,-1,27,255,15,-1,255,27,200,-1,82,184,83,-1,184,82,223,-1,87,43,165,-1,43,87,21,-1,97,59,98,-1,97,57,59,-1,146,145,144,-1,146,78,145,-1,147,66,68,-1,147,151,66,-1,169,78,50,-1,169,145,78,-1,15,223,82,-1,15,255,223,-1,29,33,84,-1,29,35,33,-1,230,189,250,-1,230,228,189,-1,229,179,164,-1,179,229,230,-1,139,160,38,-1,160,139,181,-1,13,199,39,-1,12,199,13,-1,94,196,98,-1,94,93,196,-1,96,104,97,-1,265,104,96,-1,265,107,104,-1,107,265,195,-1,152,235,236,-1,152,227,235,-1,61,237,45,-1,253,237,61,-1,106,217,257,-1,106,105,217,-1,257,219,271,-1,257,217,219,-1,252,240,270,-1,252,239,240,-1,87,192,114,-1,87,165,192,-1,117,243,193,-1,136,243,117,-1,118,114,192,-1,118,123,114,-1,224,193,243,-1,224,225,193,-1,115,126,125,-1,126,115,133,-1,250,179,230,-1,251,179,250,-1,260,247,246,-1,210,247,260,-1,129,162,127,-1,173,162,129,-1,190,246,247,-1,246,190,130,-1,190,241,131,-1,248,241,190,-1,241,189,124,-1,241,250,189,-1,225,19,193,-1,225,120,19,-1,132,188,125,-1,132,85,188,-1,7,192,165,-1,192,7,119,-1,109,187,111,-1,187,109,194,-1,271,270,240,-1,270,271,219,-1,110,253,238,-1,110,237,253,-1,238,236,102,-1,253,236,238,-1,186,137,233,-1,103,137,186,-1,66,234,198,-1,234,66,65,-1,97,103,186,-1,104,103,97,-1,98,95,94,-1,59,95,98,-1,39,256,13,-1,39,161,256,-1,231,10,140,-1,10,231,11,-1,89,164,140,-1,229,164,89,-1,30,180,31,-1,30,228,180,-1,43,0,166,-1,0,43,44,-1,221,145,169,-1,221,79,145,-1,22,149,23,-1,149,22,176,-1,148,63,62,-1,148,77,63,-1,67,138,100,-1,67,151,138,-1,149,170,150,-1,168,170,149,-1,249,246,245,-1,249,260,246,-1,41,81,83,-1,41,159,81,-1,232,197,92,-1,197,232,254,-1,127,179,251,-1,127,162,179,-1,8,166,178,-1,8,7,166,-1,200,256,255,-1,256,200,90,-1,108,271,194,-1,257,271,108,-1,53,74,70,-1,53,157,74,-1,270,258,252,-1,269,258,270,-1,268,260,249,-1,268,259,260,-1,267,173,129,-1,267,174,173,-1,261,265,96,-1,261,266,265,-1,254,264,197,-1,262,264,254,-1,172,231,163,-1,172,263,231,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lmolar1c_Coord',point=[(.7602,54.99391,2.21401),(.77437,55.00585,2.1718),(.79099,55.04606,2.2093),(.8041,55.07204,2.25498),(.8012,55.0728,2.26038),(.7676,55.03726,2.24983),(.69572,54.98754,2.22898),(.70333,54.98281,2.19693),(.70574,54.99063,2.22576),(.97067,55.30222,2.11708),(.95258,55.29786,2.10284),(.94745,55.31396,2.10591),(.98943,55.20783,2.09451),(.99233,55.1823,2.08918),(.96204,55.19609,2.07758),(.96413,55.03657,2.06205),(.95827,55.02278,2.09703),(.93451,55.05973,2.05508),(.69465,55.01893,2.27054),(.65016,55.05693,2.24605),(.67568,55.00606,2.23962),(.76958,55.01118,2.12797),(.81457,55.03274,2.13667),(.78836,55.01633,2.14561),(.8827,55.09025,2.08515),(.87017,55.08794,2.08428),(.87637,55.0893,2.08055),(.93833,55.05977,2.0454),(.89868,55.07778,2.02326),(.84213,55.05778,1.99945),(.83725,55.06768,1.98929),(.89956,55.07922,2.01963),(.7816,55.04454,2.06631),(.83068,55.04633,2.06407),(.84062,55.08099,2.11072),(.84817,55.06054,2.04787),(.92911,55.05668,2.08695),(1.01394,55.2172,2.16133),(1.02017,55.15808,2.15034),(1.01571,55.16724,2.11125),(.98455,55.04422,2.19709),(.98041,55.00153,2.15056),(1.00127,55.03638,2.16264),(.75556,54.98777,2.16275),(.76981,54.99863,2.16977),(.8028,55.05686,2.35852),(.77366,55.0524,2.34256),(.77848,55.04165,2.3299),(.9063,55.06031,2.24786),(.86582,55.09805,2.22383),(.86635,55.09945,2.21653),(.789,55.0549,2.3163),(.80597,55.0617,2.32904),(.83015,55.08009,2.27559),(.84425,55.07457,2.30725),(.83425,55.06099,2.32987),(.91765,55.06933,2.22455),(.99982,55.19295,2.30246),(1.00483,55.13271,2.30199),(1.00899,55.20917,2.24036),(.86509,55.04484,2.38032),(.85972,55.06238,2.38629),(.87504,55.05064,2.33895),(.92101,55.0118,2.37386),(.89377,55.02755,2.38096),(.99606,55.07742,2.29629),(.98374,55.0388,2.28541),(.99301,55.08763,2.24908),(.96357,55.00692,2.28005),(.94881,55.00044,2.32853),(.83784,55.0951,2.24076),(.75884,54.99927,2.2378),(.78338,55.0301,2.23511),(.83296,55.09283,2.23476),(.82721,55.09391,2.24621),(.85618,55.07377,2.26359),(.94774,55.02162,2.26072),(.91531,55.00569,2.30243),(.91332,55.05808,2.20194),(.90521,55.03018,2.13815),(.91277,55.0367,2.11426),(.97122,55.00085,2.11919),(.98778,55.01168,2.08236),(.99012,54.99884,2.11713),(.81243,55.03093,2.01763),(.79536,55.0335,1.99145),(.78633,55.01451,2.02632),(.74673,55.01496,2.11705),(.77184,55.008,2.07475),(.89882,55.17795,2.05974),(.95401,55.12193,2.05076),(.90592,55.11507,2.03014),(.99087,55.29882,2.17093),(.98704,55.31301,2.19967),(.99639,55.28845,2.20594),(1.01151,55.21689,2.19712),(.97835,55.30071,2.31531),(.99268,55.25791,2.30719),(.99818,55.27698,2.24533),(.99949,55.14811,2.23367),(.99263,55.0917,2.22937),(1.00092,55.09282,2.20718),(.91602,55.18271,2.3923),(.9553,55.2008,2.3733),(.96029,55.25545,2.36033),(.88937,55.28178,2.36847),(.88812,55.25962,2.36392),(.91817,55.26261,2.37118),(.84116,55.216,2.34984),(.7773,55.15451,2.34444),(.82419,55.16,2.37095),(.7154,55.13479,2.32186),(.71567,55.07288,2.31542),(.77087,55.09726,2.35379),(.70664,55.03738,2.11614),(.7061,55.01462,2.064),(.68844,55.06254,2.29106),(.66837,55.13443,2.2868),(.65808,55.04731,2.14499),(.67655,55.00035,2.19231),(.64139,55.04981,2.18926),(.65729,55.11741,2.11097),(.64309,55.11497,2.1449),(.6816,55.06298,2.11468),(.72523,55.06515,1.98898),(.73217,55.01435,2.00348),(.69307,55.06059,2.02995),(.74691,55.24399,2.0361),(.72215,55.26568,2.04994),(.75792,55.27004,2.04747),(.65331,55.17918,2.11366),(.6734,55.11715,2.05872),(.79427,55.03873,1.97889),(.68,55.06052,2.0664),(.71548,55.00389,2.27685),(.70559,55.00501,2.25268),(.66202,55.19126,2.27365),(.94941,55.15369,2.38109),(.97067,55.05215,2.21537),(1.01163,55.1489,2.18431),(.89679,55.26234,2.09644),(.73556,55.00543,2.06533),(.79591,55.0644,2.10891),(.80028,55.06419,2.10379),(.95464,55.01856,2.18753),(.90977,55.04719,2.17818),(.95391,55.03181,2.20719),(.9617,55.02773,2.23111),(.88182,55.03352,2.281),(.80207,55.05043,2.19387),(.79276,55.05029,2.20067),(.97408,55.04923,2.23957),(.89897,55.05839,2.38986),(.81851,55.05893,2.34417),(.77087,55.02944,2.284),(.79464,55.06112,2.29033),(.79507,55.07076,2.26371),(.82207,55.08434,2.27265),(.82087,55.07616,2.29195),(.96506,55.00371,2.14372),(1.0193,55.10046,2.13671),(1.02046,55.10866,2.09507),(.7906,55.25683,2.04416),(.84479,55.28212,2.06741),(.8478,55.22465,2.06359),(.73647,54.98344,2.15732),(.73391,54.97781,2.20866),(.72594,55.03632,2.31052),(.823,55.08445,2.22303),(.86001,55.07683,2.1698),(.8138,55.086,2.22998),(.85437,55.06072,2.04525),(.84245,55.2938,2.07029),(.79471,55.27448,2.05191),(.79325,55.28547,2.05714),(.76738,55.03623,2.25686),(.82149,55.05928,2.18576),(.91566,55.2379,2.37442),(.74039,54.99928,2.28544),(.78678,55.20734,2.01959),(.87587,55.10673,2.01414),(1.01296,55.09321,2.17307),(.82195,55.07938,2.27934),(.75611,55.00999,2.28546),(1.00903,55.04535,2.1201),(.84388,55.08024,2.11859),(.99374,55.18986,2.32526),(.72242,55.20322,2.3044),(.74302,55.00629,2.02222),(.77632,55.08607,1.97758),(.67325,55.18515,2.07164),(.71833,55.23716,2.04078),(.69937,55.00397,2.14965),(.6383,55.12041,2.23893),(.79313,55.20859,2.33253),(.92235,55.2899,2.36738),(.98455,55.30557,2.2439),(.98003,55.31863,2.1718),(.96205,55.03522,2.33501),(1.00683,55.21673,2.12347),(.94439,55.07973,2.03981),(.96521,55.31694,2.12242),(.81058,55.07977,2.23686),(.96142,55.32809,2.12543),(.94449,55.32547,2.10887),(.97988,55.31661,2.24329),(.98246,55.32406,2.20212),(.88836,55.2936,2.36714),(.92007,55.30154,2.36511),(.6847,55.27279,2.09783),(.6834,55.26124,2.09423),(.72342,55.27685,2.05484),(.65596,55.25905,2.17982),(.65214,55.27001,2.22411),(.65955,55.27051,2.18146),(.64851,55.25862,2.22462),(.80683,55.29215,2.33666),(.84993,55.2816,2.3552),(.84969,55.29349,2.35378),(.80718,55.28039,2.33867),(.76996,55.03243,2.27149),(.85788,55.05923,2.13711),(.88724,55.22567,2.36787),(1.00406,55.05277,2.07699),(.6327,55.17264,2.18085),(.63328,55.10686,2.18528),(.64299,55.17591,2.1472),(.92903,55.04424,2.38066),(.81574,55.0953,1.98353),(.85557,55.16926,2.03409),(.80042,55.15091,1.99661),(.89741,55.29812,2.10102),(.98202,55.30453,2.13787),(.99196,55.13891,2.33293),(.97646,55.08417,2.34022),(.9406,55.10481,2.38464),(.90926,55.11972,2.3995),(.80755,55.1117,2.37096),(.87857,55.17381,2.38626),(.67188,55.24181,2.26731),(.73247,55.23881,2.30432),(.71297,55.13385,2.00704),(.64243,55.23767,2.22483),(.63284,55.18936,2.23328),(.63995,55.22118,2.18691),(.64989,55.22153,2.15327),(.66035,55.22182,2.11988),(.6837,55.23337,2.08339),(.7065,55.18991,2.0257),(.66061,55.25925,2.15261),(.75108,55.14326,1.99207),(.7394,55.19713,2.0178),(.6783,55.26193,2.27213),(.86135,55.11813,2.39514),(.97558,55.31873,2.14342),(.9764,55.06511,2.0537),(.99001,55.11583,2.06855),(.84693,55.2524,2.34784),(.68007,55.27355,2.26936),(.66855,55.27105,2.12581),(.66577,55.25932,2.12405),(.97378,55.31183,2.31526),(.97114,55.32968,2.14576),(.89495,55.30992,2.10335),(.9751,55.32959,2.17237),(.95769,55.29863,2.354),(.95497,55.31001,2.35161),(.75715,55.28097,2.05296),(.66408,55.27077,2.15345),(.74233,55.28523,2.30547),(.7426,55.27365,2.30815),(.80148,55.24482,2.33117)]))),
        Shape(DEF='lmolar2c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lmolar2c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,4,-1,8,9,1,-1,10,11,12,-1,13,14,15,-1,16,14,17,-1,18,16,19,-1,20,21,22,-1,23,24,25,-1,15,26,13,-1,27,2,1,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,35,41,-1,42,5,4,-1,43,44,45,-1,46,47,23,-1,23,48,49,-1,50,51,48,-1,52,53,54,-1,55,56,51,-1,57,58,59,-1,60,61,45,-1,62,63,64,-1,65,66,67,-1,68,69,19,-1,70,71,72,-1,73,43,74,-1,75,76,77,-1,58,73,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,87,86,-1,89,90,91,-1,92,93,81,-1,90,89,94,-1,95,89,50,-1,96,97,47,-1,98,97,96,-1,46,99,100,-1,101,102,103,-1,104,24,105,-1,106,92,80,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,111,116,117,-1,118,119,120,-1,37,121,122,-1,5,42,123,-1,2,124,125,-1,126,127,63,-1,29,28,37,-1,89,91,128,-1,128,106,129,-1,74,130,81,-1,131,132,133,-1,34,104,134,-1,135,136,137,-1,102,101,138,-1,139,22,19,-1,140,141,142,-1,143,144,145,-1,146,49,135,-1,147,49,48,-1,103,148,105,-1,82,86,85,-1,130,74,43,-1,80,129,106,-1,99,23,25,-1,149,127,126,-1,150,2,125,-1,123,42,151,-1,152,123,151,-1,153,154,155,-1,122,156,157,-1,112,117,114,-1,158,159,160,-1,161,54,53,-1,162,98,96,-1,163,164,94,-1,89,95,94,-1,129,80,79,-1,94,165,133,-1,47,163,166,-1,41,167,168,-1,82,85,169,-1,85,36,170,-1,82,171,133,-1,172,77,173,-1,174,27,71,-1,175,176,68,-1,177,152,178,-1,39,179,170,-1,180,30,145,-1,181,73,58,-1,182,56,55,-1,137,138,101,-1,52,54,45,-1,141,136,147,-1,51,50,128,-1,23,47,166,-1,151,42,183,-1,34,184,185,-1,34,41,35,-1,32,186,33,-1,31,33,187,-1,167,145,30,-1,153,188,189,-1,190,176,175,-1,191,175,21,-1,192,193,194,-1,146,101,103,-1,192,195,196,-1,197,26,15,-1,12,11,198,-1,72,9,199,-1,200,8,1,-1,201,65,67,-1,174,202,140,-1,203,204,201,-1,205,9,8,-1,206,159,207,-1,75,208,209,-1,116,210,211,-1,114,212,213,-1,192,20,139,-1,213,115,114,-1,211,117,116,-1,209,76,75,-1,122,157,214,-1,206,207,215,-1,201,216,203,-1,3,6,4,-1,201,204,65,-1,199,70,72,-1,197,15,18,-1,192,196,20,-1,23,146,103,-1,195,192,194,-1,192,139,193,-1,194,17,186,-1,71,27,1,-1,188,217,189,-1,30,29,167,-1,187,218,31,-1,32,144,186,-1,34,185,41,-1,184,34,134,-1,23,166,219,-1,128,53,220,-1,101,146,137,-1,45,54,161,-1,181,221,73,-1,52,222,55,-1,223,33,186,-1,40,39,170,-1,178,224,177,-1,63,216,225,-1,63,203,216,-1,174,7,27,-1,128,79,161,-1,173,78,172,-1,161,79,130,-1,133,165,82,-1,170,169,85,-1,169,83,82,-1,41,226,167,-1,47,97,163,-1,128,91,106,-1,94,133,132,-1,94,95,163,-1,164,165,94,-1,53,128,161,-1,49,146,23,-1,201,67,227,-1,158,160,228,-1,114,113,112,-1,122,229,156,-1,153,155,230,-1,151,178,152,-1,6,3,2,-1,150,0,2,-1,10,231,13,-1,232,180,233,-1,106,91,90,-1,43,161,130,-1,82,165,86,-1,103,234,148,-1,222,182,55,-1,147,135,49,-1,135,137,146,-1,140,142,235,-1,199,9,236,-1,139,19,193,-1,102,138,202,-1,237,10,13,-1,147,136,135,-1,171,131,133,-1,238,74,81,-1,106,90,92,-1,128,50,89,-1,100,88,96,-1,29,37,239,-1,63,225,126,-1,2,3,124,-1,240,5,241,-1,122,38,37,-1,118,242,119,-1,117,112,111,-1,115,243,113,-1,110,112,244,-1,109,245,107,-1,66,227,67,-1,104,105,134,-1,220,51,128,-1,102,69,103,-1,100,96,46,-1,47,46,96,-1,50,219,95,-1,96,88,162,-1,80,92,81,-1,128,129,79,-1,88,100,87,-1,90,94,132,-1,85,87,36,-1,82,84,171,-1,79,81,130,-1,173,58,78,-1,75,77,172,-1,246,84,83,-1,74,78,73,-1,19,22,68,-1,68,176,69,-1,65,247,66,-1,62,203,63,-1,60,45,44,-1,57,181,58,-1,51,220,55,-1,50,48,219,-1,48,23,219,-1,23,99,46,-1,45,161,43,-1,221,248,73,-1,40,41,168,-1,39,239,37,-1,144,249,186,-1,250,218,187,-1,72,71,1,-1,196,191,21,-1,139,20,22,-1,20,196,21,-1,70,199,19,-1,186,195,194,-1,19,16,193,-1,251,199,236,-1,10,237,11,-1,149,252,127,-1,9,72,1,-1,174,102,202,-1,1,0,200,-1,38,122,214,-1,253,254,242,-1,253,255,254,-1,256,257,258,-1,256,259,257,-1,260,261,215,-1,262,261,260,-1,263,243,264,-1,263,245,243,-1,265,266,267,-1,268,266,265,-1,269,270,271,-1,272,270,269,-1,273,255,274,-1,273,254,255,-1,210,76,209,-1,116,76,210,-1,275,218,250,-1,275,276,218,-1,179,157,277,-1,157,179,214,-1,177,241,152,-1,278,241,177,-1,150,203,62,-1,150,204,203,-1,66,279,228,-1,66,247,279,-1,125,204,150,-1,204,125,65,-1,280,198,281,-1,280,12,198,-1,252,231,280,-1,282,231,252,-1,249,191,196,-1,249,283,191,-1,21,68,22,-1,175,68,21,-1,143,190,283,-1,226,190,143,-1,51,147,48,-1,51,56,147,-1,284,285,108,-1,284,286,285,-1,282,13,231,-1,282,287,13,-1,144,180,145,-1,144,32,180,-1,288,287,282,-1,288,289,287,-1,178,57,224,-1,178,181,57,-1,246,169,277,-1,83,169,246,-1,172,290,75,-1,238,290,172,-1,35,170,36,-1,35,40,170,-1,164,162,165,-1,98,162,164,-1,259,291,257,-1,292,291,259,-1,293,159,206,-1,159,293,160,-1,294,215,207,-1,294,260,215,-1,284,260,294,-1,284,295,260,-1,59,244,285,-1,110,244,59,-1,267,212,296,-1,212,267,213,-1,296,122,297,-1,229,122,296,-1,155,297,230,-1,155,265,297,-1,275,271,189,-1,275,269,271,-1,298,289,299,-1,298,300,289,-1,151,181,178,-1,151,221,181,-1,300,287,289,-1,223,287,300,-1,277,156,246,-1,277,157,156,-1,53,55,220,-1,53,52,55,-1,27,6,2,-1,7,6,27,-1,26,199,251,-1,26,197,199,-1,16,15,14,-1,16,18,15,-1,198,205,301,-1,205,198,11,-1,105,23,103,-1,105,24,23,-1,38,179,39,-1,38,214,179,-1,33,300,187,-1,33,223,300,-1,116,77,76,-1,116,111,77,-1,302,298,303,-1,302,250,298,-1,230,122,121,-1,230,297,122,-1,299,254,273,-1,254,299,304,-1,297,267,296,-1,297,265,267,-1,113,244,112,-1,244,113,109,-1,294,286,284,-1,286,294,305,-1,291,293,257,-1,291,160,293,-1,306,118,120,-1,307,118,306,-1,190,234,176,-1,234,190,185,-1,95,166,163,-1,219,166,95,-1,97,164,163,-1,97,98,164,-1,74,172,78,-1,74,238,172,-1,209,84,246,-1,209,208,84,-1,235,183,42,-1,235,60,183,-1,65,124,247,-1,125,124,65,-1,32,233,180,-1,32,31,233,-1,60,248,183,-1,60,44,248,-1,108,295,284,-1,295,108,107,-1,40,239,39,-1,40,168,239,-1,226,145,167,-1,226,143,145,-1,11,9,205,-1,236,9,11,-1,197,19,199,-1,197,18,19,-1,17,13,186,-1,17,14,13,-1,283,144,143,-1,249,144,283,-1,237,236,11,-1,237,251,236,-1,288,252,149,-1,288,282,252,-1,279,124,240,-1,247,124,279,-1,306,216,292,-1,306,225,216,-1,152,5,123,-1,241,5,152,-1,170,277,169,-1,277,170,179,-1,31,276,233,-1,276,31,218,-1,188,232,217,-1,232,188,28,-1,308,303,309,-1,302,303,308,-1,271,310,154,-1,270,310,271,-1,266,213,267,-1,266,311,213,-1,312,245,263,-1,312,107,245,-1,215,313,206,-1,261,313,215,-1,307,256,314,-1,256,307,259,-1,315,242,118,-1,242,315,253,-1,316,257,293,-1,316,258,257,-1,262,295,317,-1,262,260,295,-1,115,264,243,-1,318,264,115,-1,268,155,319,-1,265,155,268,-1,302,272,269,-1,308,272,302,-1,250,269,275,-1,269,250,302,-1,278,320,158,-1,278,177,320,-1,0,62,200,-1,0,150,62,-1,64,200,62,-1,64,301,200,-1,228,227,66,-1,160,227,228,-1,227,160,291,-1,140,7,174,-1,140,4,7,-1,252,281,127,-1,252,280,281,-1,304,242,254,-1,304,119,242,-1,231,12,280,-1,231,10,12,-1,174,70,102,-1,71,70,174,-1,26,237,13,-1,26,251,237,-1,17,193,16,-1,17,194,193,-1,191,190,175,-1,191,283,190,-1,87,24,104,-1,24,87,25,-1,148,134,105,-1,134,148,184,-1,44,73,248,-1,44,43,73,-1,56,141,147,-1,182,141,56,-1,182,142,141,-1,45,222,52,-1,45,61,222,-1,59,286,57,-1,286,59,285,-1,127,64,63,-1,281,64,127,-1,102,19,69,-1,102,70,19,-1,75,131,208,-1,290,131,75,-1,162,86,165,-1,162,88,86,-1,93,90,132,-1,92,90,93,-1,238,93,290,-1,93,238,81,-1,207,305,294,-1,320,305,207,-1,285,109,108,-1,285,244,109,-1,211,296,212,-1,211,229,296,-1,149,120,119,-1,120,149,126,-1,28,121,37,-1,188,121,28,-1,189,276,275,-1,276,189,217,-1,299,303,298,-1,299,273,303,-1,59,173,110,-1,58,173,59,-1,210,246,156,-1,209,246,210,-1,132,290,93,-1,131,290,132,-1,202,141,140,-1,202,138,141,-1,103,176,234,-1,176,103,69,-1,185,226,41,-1,190,226,185,-1,142,60,235,-1,61,60,142,-1,233,217,232,-1,233,276,217,-1,281,301,64,-1,281,198,301,-1,110,77,111,-1,173,77,110,-1,187,298,250,-1,298,187,300,-1,230,188,153,-1,188,230,121,-1,304,289,288,-1,304,299,289,-1,156,211,210,-1,156,229,211,-1,243,109,113,-1,109,243,245,-1,57,305,224,-1,57,286,305,-1,320,224,305,-1,177,224,320,-1,279,158,228,-1,279,278,158,-1,120,225,306,-1,120,126,225,-1,99,87,100,-1,99,25,87,-1,208,171,84,-1,131,171,208,-1,4,235,42,-1,140,235,4,-1,278,240,241,-1,240,278,279,-1,239,167,29,-1,167,239,168,-1,223,13,287,-1,223,186,13,-1,183,221,151,-1,221,183,248,-1,138,136,141,-1,137,136,138,-1,182,61,142,-1,182,222,61,-1,184,234,185,-1,184,148,234,-1,104,36,87,-1,36,104,34,-1,189,154,153,-1,154,189,271,-1,196,186,249,-1,196,195,186,-1,288,119,304,-1,288,149,119,-1,240,3,5,-1,124,3,240,-1,292,227,291,-1,216,227,292,-1,201,227,216,-1,8,301,205,-1,301,8,200,-1,292,307,306,-1,307,292,259,-1,207,158,320,-1,159,158,207,-1,180,28,30,-1,180,232,28,-1,212,117,211,-1,114,117,212,-1,273,309,303,-1,274,309,273,-1,319,154,310,-1,319,155,154,-1,311,115,213,-1,311,318,115,-1,107,317,295,-1,312,317,107,-1,206,316,293,-1,313,316,206,-1,314,118,307,-1,118,314,315,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lmolar2c_Coord',point=[(.81471,55.059,1.77964),(.84464,55.05859,1.78149),(.80909,55.06814,1.80271),(.80132,55.05473,1.83135),(.82419,55.03535,1.84746),(.79405,55.03871,1.87177),(.81588,55.05036,1.82423),(.83163,55.04641,1.81927),(.85058,55.05413,1.75669),(.86792,55.07314,1.75654),(.88423,55.08207,1.69116),(.86085,55.059,1.71927),(.85461,55.06344,1.69735),(.92161,55.11382,1.69585),(.92741,55.11439,1.70693),(.92114,55.11409,1.70624),(.92166,55.11631,1.76394),(.95301,55.12049,1.70997),(.91817,55.11613,1.76543),(.91814,55.11578,1.7721),(.95209,55.11674,1.75409),(.97181,55.09616,1.74861),(.9255,55.1133,1.77152),(.94782,55.1194,1.87068),(.95153,55.11252,1.85901),(.95132,55.11685,1.87142),(.91264,55.10697,1.71129),(.83909,55.05747,1.79111),(1.07432,55.1016,1.77075),(1.05508,55.0635,1.77671),(1.05234,55.08114,1.74744),(1.01328,55.12599,1.71797),(1.01093,55.11017,1.72154),(.97194,55.1319,1.70948),(1.01517,55.05958,1.83373),(1.0212,55.05111,1.8358),(1.01991,55.06547,1.87817),(1.08146,55.09109,1.82618),(1.07489,55.0965,1.85667),(1.05004,55.05656,1.8436),(1.04056,55.04554,1.84079),(1.02529,55.04549,1.79256),(.81923,55.02733,1.89838),(.88445,55.06673,1.9855),(.87284,55.0558,1.96508),(.88811,55.06482,1.96196),(.94838,55.11558,1.88245),(.94569,55.11443,1.88441),(.94326,55.1185,1.87363),(.94347,55.12016,1.87036),(.93276,55.10729,1.91775),(.92399,55.10261,1.93423),(.89508,55.0683,1.93159),(.92086,55.09925,1.93886),(.89337,55.06676,1.96005),(.89456,55.07015,1.92143),(.89601,55.07147,1.91198),(.82591,55.09721,1.98384),(.87391,55.07909,2.00316),(.8685,55.11007,2.01009),(.85956,55.04393,1.94163),(.86825,55.05101,1.93826),(.79831,55.0644,1.7585),(.79518,55.07347,1.72626),(.8059,55.06194,1.72852),(.79274,55.08705,1.8081),(.75161,55.12906,1.84),(.76018,55.12875,1.81579),(.93178,55.10724,1.77613),(.94167,55.10234,1.79262),(.91166,55.10933,1.77371),(.86289,55.06733,1.7832),(.86035,55.0705,1.77963),(.87581,55.07527,1.99998),(.93122,55.06228,2.01721),(1.00338,55.0355,2.0219),(1.01001,55.04827,2.0217),(.98459,55.06439,2.04103),(.92892,55.07145,2.02475),(.94885,55.06501,1.99969),(.9717,55.06462,2.00359),(.97654,55.05076,2.01864),(1.02438,55.03504,1.91396),(1.04395,55.03402,1.91763),(1.04442,55.02376,1.94324),(1.02037,55.05199,1.88973),(1.01235,55.05796,1.90044),(1.00179,55.08001,1.88222),(1.0062,55.06809,1.90279),(.9743,55.07059,1.95911),(.99282,55.05483,1.98121),(.97462,55.07838,1.98014),(.98654,55.05266,1.9953),(.99494,55.03422,2.0024),(.99303,55.04669,1.94246),(.98179,55.05955,1.9348),(1.00144,55.06957,1.90666),(.99816,55.06843,1.9104),(1.00109,55.06529,1.91378),(.94848,55.11563,1.87799),(1.002,55.07187,1.90185),(.9375,55.09681,1.79714),(.93165,55.09738,1.79085),(.9445,55.09975,1.79502),(1.00374,55.07004,1.84765),(.95161,55.1107,1.85376),(.97264,55.07657,1.98876),(.84802,55.26932,1.99695),(.84983,55.2257,1.99979),(.91998,55.22461,2.02471),(.93179,55.11458,2.03613),(.99638,55.10279,2.04901),(.99593,55.1527,2.0539),(.99175,55.21924,2.04631),(1.0271,55.21663,2.04054),(1.01576,55.26195,2.03677),(1.02288,55.09058,2.02966),(1.02751,55.14141,2.03906),(.76883,55.23344,1.718),(.81476,55.18606,1.67675),(.77632,55.17436,1.70426),(1.0883,55.13549,1.83299),(1.08451,55.14189,1.893),(.79486,55.03799,1.89879),(.78919,55.06587,1.83267),(.80092,55.0776,1.8054),(.78694,55.12646,1.70053),(.81294,55.07654,1.6983),(.92618,55.10199,1.9384),(.9657,55.07754,1.99058),(.93527,55.05899,2.008),(1.01919,55.02574,1.98365),(1.01139,55.02961,1.97668),(1.01593,55.02497,1.94399),(1.0056,55.0668,1.83124),(.90471,55.07846,1.85628),(.89187,55.06765,1.85627),(.90264,55.07566,1.84837),(.88877,55.06479,1.80898),(.92493,55.11468,1.76676),(.83732,55.03636,1.85184),(.84903,55.04117,1.85674),(.84803,55.03958,1.90226),(1.02488,55.07451,1.74572),(1.00605,55.10018,1.72183),(1.04642,55.07748,1.7427),(.944,55.11705,1.86511),(.90233,55.07711,1.87019),(.95171,55.10871,1.84806),(.82108,55.13518,1.67726),(.79957,55.07077,1.78111),(.80854,55.04569,1.94018),(.77858,55.05301,1.90622),(1.08224,55.22,1.82516),(1.07011,55.26924,1.83674),(1.07913,55.26732,1.86839),(1.07194,55.08827,1.95535),(1.06968,55.09686,1.91245),(.74261,55.12806,1.88908),(.73106,55.18607,1.89218),(.72871,55.18621,1.85855),(.89318,55.06728,1.96994),(1.00735,55.05844,1.912),(.98904,55.06437,1.92197),(.99969,55.05805,1.92738),(1.01257,55.04397,1.91952),(.94183,55.11224,1.89279),(1.04907,55.05661,1.77187),(1.04396,55.04473,1.80546),(1.04196,55.04456,1.89641),(1.03997,55.05509,1.87521),(1.03023,55.02177,1.94069),(.98336,55.05759,2.03832),(.92905,55.07897,2.02907),(.87011,55.05951,1.79202),(.96982,55.0934,1.75718),(.94591,55.10115,1.78858),(.76549,55.07573,1.91473),(.80218,55.05541,1.94409),(1.0457,55.06455,1.87762),(1.0484,55.08974,1.73925),(.83735,55.06674,1.97464),(.88227,55.06224,1.91604),(.84293,55.0413,1.94272),(1.00557,55.06245,1.81989),(1.00724,55.05222,1.78596),(.96415,55.12416,1.70664),(.99904,55.15881,1.7194),(1.08245,55.13838,1.7847),(1.07,55.22563,1.78943),(1.00608,55.05893,1.77112),(.99687,55.07845,1.75299),(.94781,55.12153,1.75016),(.92489,55.11702,1.76244),(.96108,55.12361,1.71098),(.96456,55.11661,1.71976),(.9674,55.1046,1.73824),(.91614,55.11369,1.76682),(.83605,55.05592,1.70661),(.91385,55.11176,1.7682),(.82012,55.0502,1.75749),(.76234,55.12641,1.78936),(.88156,55.06174,1.80232),(.79029,55.07646,1.75765),(.79151,55.08174,1.78279),(.85578,55.05438,1.73768),(.72643,55.23889,1.89717),(.73566,55.18602,1.92547),(1.02644,55.02685,1.99445),(1.03145,55.03366,1.99683),(1.04384,55.08064,2.00316),(1.05438,55.13093,2.01613),(1.05122,55.2139,2.02489),(1.04566,55.25795,2.029),(1.06834,55.10192,1.88719),(.73841,55.24299,1.9313),(.76714,55.12505,1.75874),(1.06638,55.15452,1.75771),(1.02281,55.15806,1.72839),(.9373,55.10672,1.90345),(.92262,55.10222,1.93716),(.84299,55.05741,1.97063),(.8863,55.06416,1.92745),(.96405,55.13144,1.70559),(.78731,55.08554,1.94957),(.77611,55.125,1.7249),(1.02525,55.05751,1.7675),(.74651,55.16599,1.81928),(.74547,55.13031,1.86126),(1.07997,55.12528,1.96948),(1.08663,55.21296,1.86207),(.88053,55.08642,1.68787),(1.05886,55.11465,1.74158),(1.0501,55.11952,1.735),(.95028,55.09696,1.79253),(.83748,55.0315,1.90069),(.8755,55.07579,1.73348),(.8868,55.08387,1.69816),(.97854,55.05083,2.02911),(1.05058,55.05112,1.80832),(.7799,55.05681,1.87177),(.77831,55.05498,1.88064),(.80997,55.24397,1.69818),(.98566,55.26509,2.03495),(.92513,55.15992,2.03006),(.92045,55.27182,2.01358),(1.0508,55.03187,1.94607),(.77795,55.08077,1.83439),(.85777,55.0549,1.96881),(.98367,55.09983,1.729),(1.01138,55.23114,1.75146),(.89141,55.08866,1.71625),(.8419,55.08389,1.68512),(.80822,55.25751,1.70463),(.84647,55.25617,1.70172),(.84274,55.26904,1.70781),(.74436,55.24788,1.7727),(.73197,55.23913,1.82303),(.73301,55.25339,1.82459),(.74323,55.23358,1.77082),(.76684,55.25561,1.95718),(.7386,55.2575,1.92947),(.76667,55.26981,1.95472),(.92177,55.28592,2.01176),(.98747,55.27935,2.03301),(1.08395,55.26858,1.92642),(1.07595,55.27523,1.98688),(1.08001,55.2615,1.98536),(1.07992,55.28226,1.9282),(1.03501,55.2688,1.78415),(1.05589,55.28453,1.80913),(1.06011,55.27104,1.80519),(1.03182,55.28238,1.78899),(.88074,55.26437,1.71587),(.87878,55.27761,1.72248),(1.04218,55.22919,1.76813),(1.04747,55.15699,1.74227),(1.04733,55.0541,1.89948),(.76462,55.07572,1.89088),(.76841,55.07798,1.86784),(.84621,55.07053,1.68994),(.82233,55.06494,1.7002),(.87536,55.09881,1.68466),(1.00316,55.07549,1.75144),(.80683,55.21408,1.98149),(.85945,55.16078,2.00932),(.81779,55.15063,1.98502),(.91782,55.12136,1.69348),(.8623,55.14167,1.67432),(.90239,55.152,1.68385),(.99785,55.0331,2.01165),(.73967,55.18984,1.81894),(.74971,55.18631,1.76357),(.72192,55.23461,1.8639),(.76508,55.20228,1.96015),(.80703,55.26265,1.97901),(1.08509,55.20115,1.97681),(1.08767,55.21452,1.91612),(.95632,55.21118,1.71592),(.88848,55.20136,1.68679),(.96371,55.15725,1.70185),(.8274,55.04987,1.73353),(1.00697,55.26472,1.7676),(.9421,55.26652,1.74453),(.85468,55.19516,1.67753),(.7776,55.14038,1.95778),(.75927,55.17878,1.7336),(.75612,55.2332,1.74131),(1.00497,55.27828,1.77322),(.93965,55.27985,1.75046),(1.06534,55.28281,1.83948),(1.0426,55.27205,2.02856),(.84759,55.28367,1.99503),(.72778,55.25325,1.89773),(.75765,55.2475,1.74379),(.76894,55.24737,1.72272),(.723,55.2489,1.86513),(.80688,55.27687,1.97678),(1.01703,55.27622,2.03426),(1.07487,55.28108,1.87005),(.74388,55.12783,1.91765)]))),
        Shape(DEF='lmolar3c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lmolar3c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,11,-1,14,15,16,-1,17,18,16,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,27,23,28,-1,29,26,25,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,15,48,49,-1,50,49,51,-1,52,53,54,-1,55,56,53,-1,57,58,59,-1,60,58,61,-1,32,62,63,-1,64,65,66,-1,52,67,55,-1,68,30,69,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,62,79,80,-1,81,82,83,-1,84,85,86,-1,43,87,44,-1,88,89,90,-1,91,92,93,-1,94,95,96,-1,97,98,99,-1,100,60,101,-1,102,22,103,-1,104,99,105,-1,106,107,108,-1,109,110,111,-1,96,112,113,-1,114,115,116,-1,114,117,118,-1,111,110,118,-1,42,119,120,-1,120,121,42,-1,122,55,123,-1,124,103,125,-1,126,127,128,-1,129,130,131,-1,131,12,10,-1,132,73,133,-1,67,65,134,-1,135,51,136,-1,137,47,46,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,88,148,-1,85,84,7,-1,49,48,51,-1,149,150,80,-1,101,151,28,-1,152,24,153,-1,154,41,117,-1,35,36,155,-1,156,40,39,-1,157,156,34,-1,120,119,156,-1,158,35,34,-1,36,158,37,-1,159,118,41,-1,160,41,161,-1,23,22,102,-1,162,163,122,-1,163,164,165,-1,166,15,167,-1,31,30,82,-1,138,168,169,-1,170,124,125,-1,171,172,173,-1,174,137,175,-1,66,52,176,-1,73,177,133,-1,178,179,180,-1,181,182,183,-1,10,9,184,-1,185,186,187,-1,152,188,189,-1,190,22,24,-1,191,192,193,-1,120,85,194,-1,95,154,112,-1,82,30,83,-1,195,109,88,-1,148,111,159,-1,110,196,115,-1,117,114,197,-1,191,198,199,-1,116,92,193,-1,115,93,92,-1,200,201,202,-1,203,77,204,-1,102,103,124,-1,205,91,93,-1,206,207,208,-1,207,209,87,-1,210,211,212,-1,86,213,214,-1,85,120,213,-1,8,84,144,-1,215,208,216,-1,217,218,219,-1,131,127,220,-1,129,221,222,-1,81,146,79,-1,162,80,150,-1,31,223,62,-1,62,223,79,-1,128,127,131,-1,30,224,83,-1,176,52,225,-1,224,226,83,-1,65,52,66,-1,69,32,63,-1,227,228,229,-1,230,57,229,-1,135,231,54,-1,165,50,56,-1,232,48,15,-1,233,168,234,-1,41,40,119,-1,44,87,209,-1,119,44,235,-1,61,230,155,-1,26,236,27,-1,25,27,28,-1,124,237,100,-1,238,14,16,-1,239,18,240,-1,11,13,201,-1,10,12,11,-1,241,182,70,-1,241,70,72,-1,124,170,237,-1,201,242,11,-1,200,243,244,-1,240,19,239,-1,245,246,16,-1,142,141,247,-1,185,22,190,-1,151,25,28,-1,160,161,248,-1,155,36,61,-1,157,34,33,-1,44,209,235,-1,235,41,119,-1,43,207,87,-1,233,249,168,-1,250,47,21,-1,232,15,14,-1,165,49,50,-1,53,56,54,-1,50,54,56,-1,231,225,54,-1,57,245,229,-1,227,166,228,-1,69,63,123,-1,65,67,52,-1,52,54,225,-1,30,68,224,-1,128,131,251,-1,150,163,162,-1,81,79,223,-1,129,184,221,-1,219,179,217,-1,215,252,253,-1,8,144,254,-1,85,213,86,-1,86,214,145,-1,210,212,255,-1,42,44,119,-1,215,89,208,-1,207,43,208,-1,3,256,178,-1,113,94,96,-1,101,102,124,-1,22,185,103,-1,77,221,204,-1,115,92,116,-1,192,116,193,-1,191,257,198,-1,115,114,110,-1,159,235,148,-1,195,88,106,-1,258,116,192,-1,7,6,244,-1,95,112,96,-1,63,122,123,-1,190,24,189,-1,191,259,192,-1,189,24,152,-1,97,260,261,-1,187,103,185,-1,10,184,129,-1,4,181,183,-1,180,3,178,-1,73,262,177,-1,176,175,66,-1,137,263,175,-1,173,46,171,-1,169,264,138,-1,57,265,245,-1,265,246,245,-1,166,227,15,-1,165,56,163,-1,23,102,28,-1,196,109,205,-1,160,26,41,-1,41,235,159,-1,40,156,119,-1,34,266,158,-1,156,157,120,-1,156,266,34,-1,39,266,156,-1,35,158,36,-1,154,117,112,-1,41,118,117,-1,26,29,41,-1,153,94,152,-1,28,102,101,-1,80,267,149,-1,122,163,56,-1,85,7,194,-1,147,148,206,-1,81,144,146,-1,138,268,139,-1,46,173,137,-1,136,231,135,-1,67,134,269,-1,132,133,270,-1,10,129,131,-1,202,218,255,-1,180,4,3,-1,181,126,128,-1,25,151,38,-1,120,194,121,-1,118,159,111,-1,150,164,163,-1,243,7,244,-1,114,118,110,-1,114,116,197,-1,109,196,110,-1,108,195,106,-1,104,105,271,-1,101,124,100,-1,154,95,153,-1,97,99,104,-1,153,95,94,-1,272,259,273,-1,89,147,208,-1,88,147,89,-1,208,147,206,-1,42,121,216,-1,274,81,83,-1,80,162,62,-1,62,32,31,-1,203,274,83,-1,77,226,78,-1,73,132,74,-1,70,275,71,-1,55,53,52,-1,64,66,276,-1,245,227,229,-1,265,57,59,-1,50,135,54,-1,55,122,56,-1,51,135,50,-1,49,167,15,-1,47,250,45,-1,39,41,29,-1,35,228,33,-1,32,69,30,-1,25,38,29,-1,27,236,23,-1,236,26,160,-1,16,246,17,-1,9,11,242,-1,6,277,244,-1,7,84,8,-1,278,177,279,-1,278,280,177,-1,2,281,0,-1,2,282,281,-1,283,284,285,-1,283,286,284,-1,287,288,289,-1,290,288,287,-1,291,292,172,-1,291,293,292,-1,294,233,234,-1,294,295,233,-1,296,297,298,-1,299,297,296,-1,300,19,240,-1,20,19,300,-1,301,19,21,-1,301,239,19,-1,136,225,231,-1,225,136,302,-1,228,149,33,-1,166,149,228,-1,0,303,304,-1,281,303,0,-1,176,302,305,-1,176,225,302,-1,251,70,128,-1,70,251,275,-1,223,82,81,-1,223,31,82,-1,79,267,80,-1,146,267,79,-1,130,222,270,-1,130,129,222,-1,306,200,202,-1,306,243,200,-1,219,180,179,-1,180,219,126,-1,253,306,212,-1,252,306,253,-1,217,255,218,-1,217,210,255,-1,89,253,90,-1,89,215,253,-1,272,152,258,-1,188,152,272,-1,105,199,307,-1,273,199,105,-1,272,105,99,-1,272,273,105,-1,308,9,277,-1,308,184,9,-1,191,309,257,-1,191,193,309,-1,310,107,311,-1,310,108,107,-1,309,109,195,-1,309,205,109,-1,205,309,91,-1,274,144,81,-1,144,274,254,-1,312,313,314,-1,313,312,271,-1,97,315,98,-1,97,261,315,-1,316,261,260,-1,186,261,316,-1,317,103,187,-1,317,125,103,-1,198,108,310,-1,108,198,257,-1,254,203,204,-1,254,274,203,-1,217,178,311,-1,217,179,178,-1,221,76,222,-1,221,77,76,-1,226,318,78,-1,224,318,226,-1,281,319,303,-1,281,320,319,-1,175,305,174,-1,305,175,176,-1,292,321,322,-1,292,323,321,-1,21,305,301,-1,21,174,305,-1,142,17,324,-1,142,247,17,-1,140,168,138,-1,140,234,168,-1,59,60,100,-1,60,59,58,-1,154,161,41,-1,154,248,161,-1,158,39,37,-1,158,266,39,-1,60,151,101,-1,60,61,151,-1,249,250,143,-1,249,45,250,-1,174,47,137,-1,21,47,174,-1,322,276,263,-1,322,321,276,-1,136,325,302,-1,232,325,136,-1,326,304,327,-1,326,0,304,-1,68,318,224,-1,328,318,68,-1,320,75,319,-1,75,320,329,-1,132,222,76,-1,132,270,222,-1,219,202,220,-1,202,219,218,-1,126,220,127,-1,220,126,219,-1,330,3,5,-1,331,3,330,-1,316,298,332,-1,316,296,298,-1,296,260,290,-1,316,260,296,-1,307,271,105,-1,307,313,271,-1,164,49,165,-1,49,164,167,-1,90,106,88,-1,90,211,106,-1,257,195,108,-1,257,309,195,-1,188,315,189,-1,188,98,315,-1,333,313,307,-1,313,333,331,-1,333,199,198,-1,199,333,307,-1,248,153,24,-1,248,154,153,-1,260,104,334,-1,260,97,104,-1,94,197,116,-1,94,113,197,-1,208,42,216,-1,208,43,42,-1,128,182,181,-1,182,128,70,-1,204,8,254,-1,308,8,204,-1,76,74,132,-1,76,78,74,-1,283,4,183,-1,283,5,4,-1,335,303,336,-1,303,335,304,-1,267,33,149,-1,267,214,33,-1,265,337,324,-1,265,59,337,-1,136,48,232,-1,136,51,48,-1,239,325,238,-1,301,325,239,-1,21,300,250,-1,21,20,300,-1,169,142,338,-1,143,142,169,-1,229,155,230,-1,228,155,229,-1,35,155,228,-1,24,160,248,-1,23,160,24,-1,23,236,160,-1,247,18,17,-1,247,240,18,-1,243,252,7,-1,243,306,252,-1,299,290,287,-1,299,296,290,-1,140,294,234,-1,140,339,294,-1,172,340,291,-1,340,172,171,-1,326,1,0,-1,341,1,326,-1,284,342,285,-1,284,343,342,-1,281,344,320,-1,281,282,344,-1,177,345,279,-1,345,177,262,-1,280,346,275,-1,280,278,346,-1,320,347,329,-1,344,347,320,-1,286,183,348,-1,286,283,183,-1,349,289,288,-1,350,289,349,-1,293,323,292,-1,323,293,351,-1,295,352,233,-1,295,353,352,-1,298,354,139,-1,298,297,354,-1,9,244,277,-1,9,242,244,-1,29,37,39,-1,37,29,38,-1,352,46,45,-1,171,46,352,-1,61,57,230,-1,57,61,58,-1,321,64,276,-1,327,64,321,-1,269,328,68,-1,328,269,134,-1,301,302,325,-1,301,305,302,-1,73,329,262,-1,73,75,329,-1,226,203,83,-1,77,203,226,-1,63,162,122,-1,63,62,162,-1,355,270,133,-1,355,130,270,-1,220,12,131,-1,220,13,12,-1,180,181,4,-1,180,126,181,-1,196,93,115,-1,93,196,205,-1,188,99,98,-1,188,272,99,-1,113,117,197,-1,113,112,117,-1,330,342,314,-1,342,330,285,-1,271,334,104,-1,334,271,312,-1,107,211,210,-1,211,107,106,-1,258,94,116,-1,152,94,258,-1,235,206,148,-1,235,207,206,-1,235,209,207,-1,314,349,312,-1,314,342,349,-1,315,186,185,-1,186,315,261,-1,187,268,317,-1,332,268,187,-1,333,310,256,-1,198,310,333,-1,210,311,107,-1,210,217,311,-1,251,130,355,-1,251,131,130,-1,308,6,8,-1,308,277,6,-1,356,78,318,-1,78,356,74,-1,336,319,356,-1,303,319,336,-1,134,64,335,-1,65,64,134,-1,15,245,16,-1,227,245,15,-1,172,322,173,-1,322,172,292,-1,264,268,138,-1,264,317,268,-1,170,337,237,-1,170,338,337,-1,121,7,252,-1,121,194,7,-1,167,149,166,-1,164,149,167,-1,149,164,150,-1,143,300,141,-1,143,250,300,-1,45,233,352,-1,249,233,45,-1,264,338,170,-1,264,169,338,-1,264,125,317,-1,170,125,264,-1,173,263,137,-1,263,173,322,-1,263,66,175,-1,263,276,66,-1,327,335,64,-1,327,304,335,-1,328,356,318,-1,336,356,328,-1,74,319,75,-1,74,356,319,-1,275,355,280,-1,275,251,355,-1,256,331,333,-1,256,3,331,-1,332,139,268,-1,298,139,332,-1,332,186,316,-1,187,186,332,-1,290,334,288,-1,290,260,334,-1,199,259,191,-1,199,273,259,-1,285,5,283,-1,5,285,330,-1,146,214,267,-1,214,146,145,-1,109,148,88,-1,109,111,148,-1,193,91,309,-1,193,92,91,-1,258,259,272,-1,258,192,259,-1,255,306,202,-1,255,212,306,-1,288,312,349,-1,288,334,312,-1,190,315,185,-1,190,189,315,-1,314,331,330,-1,314,313,331,-1,311,256,310,-1,256,311,178,-1,90,212,211,-1,90,253,212,-1,144,86,145,-1,84,86,144,-1,201,220,202,-1,220,201,13,-1,204,184,308,-1,184,204,221,-1,133,280,355,-1,280,133,177,-1,123,67,269,-1,55,67,123,-1,246,324,17,-1,265,324,246,-1,134,336,328,-1,336,134,335,-1,323,327,321,-1,326,327,323,-1,69,269,68,-1,69,123,269,-1,324,338,142,-1,324,337,338,-1,14,325,232,-1,325,14,238,-1,168,143,169,-1,249,143,168,-1,38,61,36,-1,38,151,61,-1,214,157,33,-1,213,157,214,-1,120,157,213,-1,59,237,337,-1,237,59,100,-1,240,141,300,-1,247,141,240,-1,18,238,16,-1,239,238,18,-1,201,244,242,-1,201,200,244,-1,252,216,121,-1,252,215,216,-1,357,275,346,-1,275,357,71,-1,354,140,139,-1,354,339,140,-1,171,353,340,-1,353,171,352,-1,351,326,323,-1,351,341,326,-1,342,350,349,-1,343,350,342,-1,182,348,183,-1,241,348,182,-1,347,262,329,-1,347,345,262,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lmolar3c_Coord',point=[(.9768,55.34945,1.49925),(.97521,55.36339,1.50359),(.97709,55.3635,1.50374),(1.12339,55.22687,1.68837),(1.14191,55.29329,1.6653),(1.12375,55.29022,1.68162),(1.08386,55.1252,1.56629),(1.07821,55.13075,1.57311),(1.07912,55.11108,1.54256),(1.09433,55.14798,1.56504),(1.11498,55.20159,1.56613),(1.11363,55.20249,1.57823),(1.11688,55.22018,1.58077),(1.11779,55.19615,1.59156),(.87543,55.10576,1.50795),(.89261,55.10617,1.51358),(.87457,55.10328,1.5147),(.84951,55.11132,1.51692),(.85225,55.11892,1.50795),(.83559,55.13854,1.49426),(.82837,55.153,1.49315),(.83639,55.14652,1.47509),(.91846,55.11662,1.67534),(.93224,55.10734,1.66457),(.95819,55.1247,1.68229),(.911,55.09841,1.63209),(.94179,55.12275,1.62951),(.92005,55.10126,1.64034),(.90625,55.08999,1.64693),(.94229,55.12485,1.62005),(1.04264,55.13992,1.46672),(1.03938,55.14387,1.47964),(1.02176,55.15606,1.47191),(.9873,55.16017,1.52733),(.97246,55.14305,1.5647),(.94077,55.1103,1.55564),(.92925,55.09942,1.5652),(.93735,55.10723,1.57295),(.91994,55.10284,1.61533),(.96412,55.13837,1.581),(.99991,55.17641,1.57557),(.98108,55.15104,1.61146),(1.0358,55.15588,1.5885),(1.03093,55.15456,1.60535),(1.00219,55.17233,1.5848),(.79836,55.25368,1.49611),(.80725,55.26366,1.48128),(.81656,55.19229,1.47719),(.89455,55.1186,1.49397),(.91763,55.1525,1.49038),(.91789,55.15641,1.47093),(.89551,55.12971,1.47732),(.93109,55.15984,1.45122),(.93757,55.15577,1.45688),(.93103,55.1526,1.4573),(.96153,55.15649,1.45418),(.94855,55.1888,1.49659),(.87876,55.08058,1.5334),(.87655,55.07453,1.55529),(.86198,55.0782,1.54908),(.87311,55.07364,1.57013),(.88837,55.07236,1.56217),(1.01974,55.17175,1.48723),(1.00117,55.16642,1.46357),(.95191,55.23833,1.45724),(.96153,55.18651,1.4507),(.93055,55.17853,1.44694),(.96079,55.16809,1.45148),(1.02574,55.16414,1.46195),(1.01712,55.15648,1.4628),(1.13458,55.34816,1.63359),(1.13038,55.35765,1.61426),(1.13091,55.35563,1.62841),(1.10141,55.32647,1.53304),(1.08785,55.25412,1.49264),(1.08138,55.32626,1.51398),(1.10201,55.19572,1.50675),(1.09006,55.15029,1.50005),(1.08936,55.19202,1.48497),(1.02268,55.15655,1.49106),(.96863,55.18725,1.50986),(1.05481,55.12022,1.49411),(1.04726,55.13253,1.47664),(1.06395,55.1309,1.4765),(1.07059,55.11866,1.54894),(1.05374,55.13829,1.56316),(1.0446,55.13137,1.55086),(.99796,55.16681,1.59313),(1.07144,55.08256,1.65196),(1.07034,55.09893,1.62565),(1.0758,55.09084,1.62859),(1.05784,55.10715,1.70228),(1.05181,55.11563,1.71238),(1.04925,55.11558,1.69775),(.98521,55.12729,1.69512),(.97289,55.12867,1.68254),(.98374,55.12922,1.68648),(.98122,55.21896,1.71185),(.98316,55.16326,1.70719),(1.01082,55.15785,1.71715),(.85616,55.07688,1.57807),(.86529,55.08332,1.61957),(.88687,55.09991,1.65328),(.86929,55.11478,1.65546),(1.01103,55.22129,1.71803),(1.04735,55.15126,1.7268),(1.08607,55.07858,1.65681),(1.10291,55.0911,1.66515),(1.09072,55.0932,1.69188),(1.05988,55.09632,1.67692),(1.02248,55.12811,1.67678),(1.02958,55.11018,1.6605),(.97553,55.14286,1.64433),(.99166,55.12918,1.68107),(1.0116,55.133,1.68064),(1.03772,55.12439,1.69756),(1.02977,55.12415,1.70597),(.97783,55.14563,1.6369),(.97959,55.14774,1.6312),(1.00642,55.17786,1.57647),(1.00662,55.17876,1.571),(1.05833,55.1332,1.59042),(.95672,55.19322,1.49849),(.98998,55.16875,1.45507),(.85109,55.08769,1.61656),(.83931,55.10421,1.62091),(1.13921,55.22422,1.63648),(1.13125,55.2388,1.61099),(1.1436,55.29917,1.62038),(1.11472,55.20133,1.55423),(1.11925,55.25889,1.56287),(1.12549,55.25334,1.58467),(1.10321,55.25954,1.51472),(1.1157,55.32568,1.55578),(.99233,55.19384,1.45566),(.91339,55.14732,1.46752),(.87841,55.12515,1.46725),(.82471,55.20659,1.45563),(.7804,55.23921,1.5778),(.79498,55.29742,1.62217),(.78585,55.30069,1.58319),(.82308,55.14482,1.51294),(.82985,55.12008,1.52412),(.80398,55.17435,1.52392),(1.06198,55.10854,1.51809),(1.03277,55.12698,1.52438),(1.02671,55.14475,1.50435),(1.05825,55.09936,1.6303),(1.03667,55.09838,1.64052),(.97177,55.17576,1.51818),(.95621,55.19307,1.5107),(.88168,55.08386,1.61963),(.98616,55.12604,1.70073),(.96351,55.12842,1.68329),(.9716,55.13509,1.6653),(.92838,55.10201,1.55805),(.99974,55.18007,1.57193),(1.00076,55.1776,1.56935),(.93983,55.10905,1.56605),(.98113,55.14768,1.62391),(.952,55.12494,1.63994),(.97825,55.14721,1.62223),(.96572,55.19417,1.50574),(.95326,55.19366,1.50479),(.94494,55.18644,1.50786),(.94553,55.18889,1.50214),(.92858,55.13075,1.51605),(.91737,55.14858,1.50985),(.78178,55.24901,1.54787),(.79534,55.16985,1.54609),(.82827,55.09882,1.58861),(.81089,55.32197,1.49348),(.82005,55.32721,1.48679),(.81859,55.27351,1.46821),(.84469,55.15221,1.45374),(.86937,55.15812,1.44198),(.8826,55.14046,1.44385),(1.10916,55.36676,1.56273),(1.12249,55.16936,1.68193),(1.12868,55.17155,1.65626),(1.13576,55.2253,1.66024),(1.14674,55.28997,1.64361),(1.13483,55.34771,1.6364),(1.13457,55.34314,1.66011),(1.09691,55.14817,1.54937),(.9057,55.14215,1.68108),(.90936,55.21133,1.68903),(.8524,55.19985,1.66424),(.98477,55.13584,1.70386),(.95868,55.13534,1.68963),(.93956,55.1287,1.68511),(1.06432,55.1172,1.72383),(1.03382,55.11857,1.71697),(1.0538,55.11455,1.71782),(1.05915,55.14029,1.57924),(1.07576,55.0885,1.68589),(1.04522,55.11285,1.68801),(1.00104,55.12943,1.68034),(1.08259,55.11305,1.7155),(1.0669,55.12868,1.72395),(1.08792,55.12898,1.57698),(1.09541,55.14321,1.58132),(1.1029,55.13113,1.60041),(1.08019,55.13054,1.49872),(1.09021,55.13084,1.52286),(1.05524,55.10491,1.68921),(1.04494,55.1094,1.62504),(1.02319,55.14192,1.60881),(1.0514,55.12657,1.61616),(.99398,55.16161,1.60098),(1.10792,55.10109,1.64109),(1.08767,55.08631,1.63276),(1.09024,55.09819,1.61093),(1.00576,55.17098,1.55273),(.99371,55.15985,1.5276),(1.07333,55.11081,1.6055),(1.05751,55.12611,1.6016),(1.12119,55.11848,1.65038),(1.11895,55.13519,1.63008),(1.13082,55.17487,1.63511),(1.12366,55.18827,1.60783),(1.09642,55.1499,1.52493),(1.10842,55.20117,1.53115),(1.03681,55.14598,1.48757),(1.06061,55.15182,1.47099),(.8895,55.13481,1.44825),(1.07475,55.15356,1.47864),(.89346,55.09575,1.5191),(.93786,55.11831,1.52331),(.89376,55.08512,1.52944),(.89113,55.0773,1.54199),(.89721,55.1368,1.45528),(.87789,55.11289,1.48859),(.79566,55.30639,1.51923),(.78956,55.29784,1.55156),(.9865,55.15182,1.61577),(.93439,55.1154,1.64089),(.84482,55.08432,1.58207),(.87352,55.10461,1.50656),(.85171,55.11887,1.4975),(.83645,55.13534,1.50536),(1.12978,55.36209,1.63433),(1.09136,55.1485,1.57354),(1.08565,55.12429,1.57695),(1.08514,55.12952,1.57172),(.88075,55.09403,1.51971),(.86918,55.0959,1.52164),(.83315,55.12771,1.51473),(.96815,55.13348,1.66084),(.79098,55.2523,1.51967),(.81265,55.17885,1.50176),(1.13683,55.30955,1.60318),(1.07957,55.11643,1.59022),(1.08114,55.10325,1.60743),(1.07269,55.10609,1.5173),(1.10509,55.11629,1.62035),(1.11228,55.16569,1.69562),(1.07499,55.10597,1.71079),(1.0173,55.12698,1.71457),(1.04264,55.13157,1.72658),(.97735,55.27685,1.70466),(.96855,55.21794,1.70706),(1.09719,55.36121,1.54683),(.86233,55.22655,1.44318),(.798,55.17108,1.58554),(.86379,55.08853,1.52858),(.96794,55.14015,1.57334),(.98012,55.1747,1.51797),(.796,55.23562,1.61931),(.99079,55.17644,1.45366),(1.11282,55.26396,1.54047),(1.05464,55.22373,1.72289),(1.0124,55.13714,1.71651),(1.04394,55.13715,1.72705),(1.06659,55.116,1.49202),(1.13056,55.35082,1.60649),(.91279,55.23372,1.44494),(1.0863,55.12842,1.56574),(1.11727,55.37265,1.58901),(1.1056,55.3811,1.56587),(1.11973,55.35954,1.58247),(1.01133,55.35094,1.50311),(1.01107,55.36509,1.50689),(1.12388,55.33539,1.67428),(1.10468,55.34281,1.6859),(1.10961,55.32892,1.68606),(1.11728,55.34851,1.67594),(.98144,55.32558,1.69222),(1.02322,55.31545,1.70372),(1.02417,55.32955,1.70109),(.981,55.3116,1.69513),(.81975,55.34111,1.49242),(.86055,55.33403,1.46947),(.85959,55.34844,1.47415),(.79216,55.31226,1.55308),(.797,55.3203,1.5247),(.90338,55.3062,1.68071),(.83297,55.31336,1.65064),(.83274,55.29901,1.65253),(.90206,55.32023,1.67755),(.82394,55.15658,1.50313),(.85479,55.12391,1.47935),(.86821,55.12378,1.45907),(1.00936,55.3064,1.48585),(.97584,55.30225,1.47874),(.86077,55.13053,1.4552),(1.08758,55.11328,1.59127),(1.07332,55.15665,1.72387),(1.09058,55.12855,1.54734),(1.06304,55.10356,1.7062),(1.10141,55.10214,1.69514),(1.11812,55.10657,1.67266),(1.0526,55.27539,1.71671),(1.07797,55.225,1.71841),(1.08197,55.28125,1.7065),(.96241,55.16732,1.69976),(.90999,55.26853,1.68983),(.81494,55.18171,1.62367),(1.05135,55.18438,1.46821),(1.04286,55.31053,1.49306),(1.04716,55.35209,1.50934),(.90958,55.28798,1.46388),(.8601,55.28165,1.45546),(.906,55.34253,1.47895),(.84616,55.10297,1.52519),(.8728,55.1122,1.4845),(.94137,55.34844,1.48911),(.94272,55.29512,1.47126),(1.02201,55.18909,1.46134),(1.08293,55.35497,1.52737),(1.10833,55.2863,1.6923),(1.09856,55.22558,1.70889),(.83538,55.25009,1.65626),(1.09576,55.16108,1.71096),(1.01708,55.27649,1.71059),(.99025,55.24929,1.46675),(1.01883,55.24991,1.47023),(.84279,55.08934,1.54965),(.82631,55.10407,1.5518),(.78791,55.31516,1.58386),(.80969,55.33515,1.50094),(.94043,55.36245,1.49414),(1.08307,55.32408,1.70109),(1.07938,55.33816,1.69984),(1.0456,55.36628,1.51202),(1.09203,55.37483,1.54646),(1.12517,55.36622,1.6066),(1.0794,55.36919,1.52904),(1.12824,55.3569,1.66331),(1.0537,55.31856,1.71246),(1.05376,55.33279,1.70979),(.90515,55.35656,1.48396),(.80418,55.31604,1.50406),(.80371,55.32892,1.51177),(.79658,55.31189,1.62192),(1.12628,55.31762,1.57947),(1.04755,55.25056,1.47382),(1.12584,55.36507,1.60755)]))),
        Shape(DEF='rcaninec',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rcaninec_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,1,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,38,-1,41,42,43,-1,14,44,45,-1,46,47,48,-1,13,49,11,-1,50,51,52,-1,47,53,41,-1,21,54,55,-1,56,57,15,-1,58,59,60,-1,56,61,62,-1,63,64,65,-1,66,67,68,-1,69,43,42,-1,70,62,63,-1,71,72,73,-1,74,75,22,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,3,80,88,-1,89,90,91,-1,67,66,92,-1,48,43,69,-1,93,87,86,-1,94,91,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,99,-1,107,24,94,-1,108,68,109,-1,110,19,111,-1,112,26,25,-1,113,114,115,-1,116,117,118,-1,119,120,121,-1,122,30,28,-1,110,123,124,-1,125,37,33,-1,126,123,127,-1,128,129,130,-1,124,126,131,-1,115,132,133,-1,134,135,31,-1,116,136,137,-1,138,139,140,-1,109,141,115,-1,142,128,143,-1,99,106,143,-1,101,144,145,-1,0,2,146,-1,147,77,76,-1,148,11,96,-1,50,149,16,-1,150,151,79,-1,56,15,152,-1,153,154,155,-1,41,53,42,-1,156,157,75,-1,158,159,69,-1,73,108,71,-1,13,12,149,-1,97,96,160,-1,150,51,155,-1,79,151,80,-1,161,162,0,-1,163,164,148,-1,165,98,97,-1,89,112,113,-1,94,95,166,-1,74,22,167,-1,64,152,83,-1,67,109,68,-1,66,168,169,-1,67,92,109,-1,56,170,57,-1,59,169,171,-1,172,93,60,-1,47,93,53,-1,47,46,55,-1,87,153,51,-1,86,60,93,-1,167,173,159,-1,174,175,142,-1,167,140,139,-1,36,25,130,-1,34,129,176,-1,33,35,177,-1,135,178,179,-1,180,27,119,-1,120,32,179,-1,57,86,85,-1,181,44,149,-1,182,76,183,-1,111,19,184,-1,185,186,156,-1,0,187,1,-1,188,184,19,-1,185,156,75,-1,19,18,188,-1,0,162,187,-1,185,189,186,-1,149,44,16,-1,14,16,44,-1,190,157,191,-1,192,146,2,-1,120,179,193,-1,27,29,119,-1,194,133,27,-1,125,33,177,-1,195,35,34,-1,71,196,158,-1,74,167,139,-1,72,71,69,-1,167,197,173,-1,93,54,153,-1,47,41,43,-1,93,198,53,-1,169,199,171,-1,169,70,66,-1,65,82,141,-1,64,61,152,-1,158,69,71,-1,94,166,107,-1,148,183,11,-1,200,201,202,-1,203,12,76,-1,24,89,94,-1,204,163,148,-1,151,205,80,-1,150,52,51,-1,160,79,97,-1,21,197,22,-1,157,154,23,-1,53,206,42,-1,153,155,51,-1,152,61,56,-1,68,73,168,-1,202,147,200,-1,202,77,147,-1,79,160,150,-1,50,13,149,-1,96,98,148,-1,76,182,147,-1,161,146,165,-1,146,161,0,-1,99,143,107,-1,94,89,91,-1,207,131,174,-1,143,106,142,-1,40,39,114,-1,140,208,138,-1,209,179,178,-1,193,210,211,-1,121,120,193,-1,132,28,133,-1,31,30,122,-1,124,123,126,-1,212,110,111,-1,127,177,126,-1,213,111,214,-1,132,122,28,-1,215,216,217,-1,121,218,119,-1,179,209,210,-1,116,137,117,-1,113,115,141,-1,25,36,112,-1,130,25,24,-1,19,110,17,-1,219,220,221,-1,108,73,68,-1,107,143,24,-1,99,101,105,-1,76,11,183,-1,201,107,166,-1,206,53,198,-1,23,154,21,-1,22,75,23,-1,48,69,173,-1,72,69,42,-1,66,63,92,-1,3,81,80,-1,84,222,82,-1,157,156,223,-1,97,79,81,-1,201,224,100,-1,78,225,203,-1,76,78,203,-1,224,201,200,-1,159,173,69,-1,66,70,63,-1,64,83,82,-1,82,65,64,-1,66,68,168,-1,65,92,63,-1,56,62,170,-1,60,86,58,-1,93,172,198,-1,43,48,47,-1,93,153,87,-1,50,87,51,-1,226,14,45,-1,227,71,108,-1,71,227,196,-1,34,176,195,-1,176,142,175,-1,180,194,27,-1,210,193,179,-1,27,133,28,-1,197,167,22,-1,228,229,207,-1,23,75,157,-1,11,76,12,-1,8,10,230,-1,6,2,1,-1,3,88,4,-1,192,2,6,-1,221,231,219,-1,231,220,232,-1,221,220,231,-1,18,233,234,-1,233,18,235,-1,236,237,238,-1,239,237,236,-1,240,241,242,-1,243,241,240,-1,186,223,156,-1,186,244,223,-1,57,16,15,-1,57,85,16,-1,190,205,151,-1,190,191,205,-1,29,30,32,-1,29,28,30,-1,176,128,142,-1,176,129,128,-1,136,196,227,-1,196,136,116,-1,167,245,140,-1,167,159,245,-1,47,54,93,-1,47,55,54,-1,182,246,147,-1,164,246,182,-1,247,201,166,-1,202,201,247,-1,26,89,24,-1,89,26,112,-1,204,98,165,-1,98,204,148,-1,153,21,154,-1,153,54,21,-1,191,242,205,-1,191,240,242,-1,248,91,90,-1,249,91,248,-1,230,75,74,-1,230,185,75,-1,190,154,157,-1,190,155,154,-1,42,171,199,-1,42,206,171,-1,199,168,73,-1,168,199,169,-1,150,49,52,-1,150,160,49,-1,225,247,250,-1,225,78,247,-1,165,251,204,-1,251,165,146,-1,103,146,192,-1,146,103,251,-1,252,102,253,-1,102,252,145,-1,217,236,215,-1,236,217,254,-1,253,207,252,-1,253,228,207,-1,131,229,124,-1,229,131,207,-1,143,130,24,-1,143,128,130,-1,138,8,139,-1,138,238,8,-1,138,255,215,-1,138,208,255,-1,218,117,137,-1,121,117,218,-1,256,135,134,-1,256,178,135,-1,178,256,255,-1,257,134,258,-1,134,257,256,-1,132,259,122,-1,132,260,259,-1,261,262,263,-1,262,261,264,-1,261,265,213,-1,266,265,261,-1,267,125,177,-1,268,125,267,-1,212,123,110,-1,127,123,212,-1,177,269,267,-1,177,127,269,-1,261,214,264,-1,261,213,214,-1,268,259,260,-1,268,267,259,-1,270,122,259,-1,122,270,258,-1,263,256,257,-1,256,263,216,-1,258,31,122,-1,31,258,134,-1,117,193,211,-1,193,117,121,-1,117,245,118,-1,117,211,245,-1,238,215,236,-1,138,215,238,-1,113,40,114,-1,40,113,112,-1,124,17,110,-1,17,124,229,-1,228,271,20,-1,271,228,253,-1,65,109,92,-1,109,65,141,-1,145,105,101,-1,145,252,105,-1,192,104,103,-1,104,192,6,-1,272,204,251,-1,272,163,204,-1,99,201,100,-1,99,107,201,-1,273,250,249,-1,273,225,250,-1,84,152,226,-1,84,83,152,-1,84,90,222,-1,84,248,90,-1,206,172,171,-1,172,206,198,-1,223,191,157,-1,191,223,240,-1,78,202,247,-1,78,77,202,-1,224,147,246,-1,224,200,147,-1,70,59,58,-1,169,59,70,-1,218,136,274,-1,218,137,136,-1,158,116,118,-1,158,196,116,-1,195,175,126,-1,195,176,175,-1,36,40,112,-1,36,38,40,-1,55,197,21,-1,55,46,197,-1,229,20,17,-1,228,20,229,-1,234,188,18,-1,275,188,234,-1,240,244,243,-1,244,240,223,-1,239,254,276,-1,239,236,254,-1,7,235,6,-1,7,233,235,-1,184,277,278,-1,279,277,184,-1,8,237,9,-1,237,8,238,-1,4,242,241,-1,4,88,242,-1,219,276,254,-1,219,231,276,-1,211,209,208,-1,211,210,209,-1,278,264,214,-1,264,278,220,-1,119,32,120,-1,119,29,32,-1,33,36,34,-1,36,33,37,-1,118,159,158,-1,159,118,245,-1,15,226,152,-1,14,226,15,-1,52,13,50,-1,13,52,49,-1,16,87,50,-1,87,16,85,-1,86,170,58,-1,57,170,86,-1,63,61,64,-1,61,63,62,-1,100,246,280,-1,100,224,246,-1,205,88,80,-1,205,242,88,-1,249,45,273,-1,249,248,45,-1,39,260,114,-1,39,268,260,-1,72,199,73,-1,72,42,199,-1,249,95,91,-1,249,250,95,-1,250,166,95,-1,250,247,166,-1,101,280,144,-1,101,100,280,-1,102,251,103,-1,272,251,102,-1,104,253,102,-1,104,271,253,-1,254,262,219,-1,254,217,262,-1,174,252,207,-1,252,174,105,-1,115,194,109,-1,115,133,194,-1,194,108,109,-1,108,180,274,-1,194,180,108,-1,216,255,256,-1,255,216,215,-1,260,115,114,-1,115,260,132,-1,263,266,261,-1,257,266,263,-1,269,266,270,-1,269,265,266,-1,38,268,39,-1,37,268,38,-1,37,125,268,-1,213,212,111,-1,213,265,212,-1,35,126,177,-1,35,195,126,-1,131,175,174,-1,131,126,175,-1,265,127,212,-1,269,127,265,-1,270,267,269,-1,259,267,270,-1,270,257,258,-1,270,266,257,-1,217,263,262,-1,217,216,263,-1,274,119,218,-1,274,180,119,-1,140,211,208,-1,245,211,140,-1,105,142,106,-1,105,174,142,-1,20,235,18,-1,271,235,20,-1,264,219,262,-1,219,264,220,-1,82,113,141,-1,82,222,113,-1,6,271,104,-1,271,6,235,-1,145,272,102,-1,145,144,272,-1,161,97,81,-1,165,97,161,-1,163,144,280,-1,144,163,272,-1,225,181,203,-1,273,181,225,-1,248,226,45,-1,84,226,248,-1,222,89,113,-1,90,89,222,-1,44,273,45,-1,181,273,44,-1,49,96,11,-1,96,49,160,-1,151,155,190,-1,151,150,155,-1,81,162,161,-1,81,3,162,-1,164,280,246,-1,163,280,164,-1,164,183,148,-1,164,182,183,-1,62,58,170,-1,62,70,58,-1,59,172,60,-1,59,171,172,-1,197,48,173,-1,197,46,48,-1,274,227,108,-1,274,136,227,-1,74,8,230,-1,74,139,8,-1,36,129,34,-1,36,130,129,-1,31,179,32,-1,31,135,179,-1,184,214,111,-1,214,184,278,-1,203,149,12,-1,203,181,149,-1,209,255,208,-1,255,209,178,-1,275,184,188,-1,275,279,184,-1,10,185,230,-1,10,189,185,-1,278,232,220,-1,277,232,278,-1,5,162,3,-1,5,187,162,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rcaninec_Coord',point=[(-.42186,55.18506,2.98285),(-.42952,55.19501,2.99269),(-.42787,55.1775,2.99244),(-.40535,55.21763,2.91438),(-.42421,55.24563,2.89826),(-.40591,55.23378,2.91963),(-.46165,55.15754,3.07173),(-.46538,55.17135,3.07155),(-.62841,55.20516,2.9097),(-.6258,55.21906,2.9133),(-.60103,55.22732,2.89119),(-.44396,55.07311,2.95762),(-.45867,55.06604,2.95972),(-.46023,55.08116,2.92913),(-.49875,55.05049,2.9283),(-.50543,55.05009,2.92518),(-.4907,55.0682,2.91921),(-.53595,55.15019,3.15093),(-.51642,55.18865,3.13395),(-.56312,55.20797,3.14695),(-.51292,55.151,3.13797),(-.55765,55.1218,2.86527),(-.58514,55.1474,2.8628),(-.53554,55.15703,2.8555),(-.54257,54.90762,3.07389),(-.56612,54.93691,3.08648),(-.56091,54.90313,3.05571),(-.64371,54.93013,2.97451),(-.65593,54.969,2.99764),(-.65492,54.97007,2.98797),(-.66166,55.01474,2.99878),(-.6625,55.03098,2.99403),(-.66151,55.01718,2.98935),(-.58242,54.97642,3.11565),(-.57175,54.98651,3.12318),(-.58111,54.99782,3.12371),(-.5739,54.94776,3.08941),(-.58004,54.9537,3.09528),(-.57959,54.93802,3.08244),(-.58661,54.92671,3.07179),(-.56817,54.90689,3.05623),(-.59625,55.0705,2.88277),(-.60585,55.04365,2.87623),(-.61933,55.07004,2.87964),(-.49383,55.04981,2.93605),(-.50845,55.00272,2.96092),(-.60275,55.09965,2.87531),(-.58766,55.08962,2.88203),(-.61848,55.08066,2.87821),(-.45547,55.08926,2.92206),(-.48303,55.08538,2.91045),(-.49567,55.09938,2.8873),(-.47686,55.09322,2.90202),(-.57877,55.08007,2.87722),(-.53044,55.09571,2.87652),(-.57856,55.09819,2.87302),(-.52019,55.04838,2.91716),(-.51077,55.0646,2.90903),(-.54172,55.04625,2.90658),(-.54811,55.04505,2.90224),(-.53236,55.07324,2.89499),(-.54805,55.00592,2.93311),(-.55485,55.01022,2.92927),(-.57459,54.98034,2.94439),(-.56576,54.97384,2.94856),(-.58846,54.91254,2.96812),(-.58365,54.98625,2.9383),(-.6014,54.935,2.94213),(-.60382,54.94353,2.93414),(-.63311,55.06156,2.87774),(-.56299,55.01533,2.92092),(-.64429,54.99031,2.88066),(-.62597,55.0203,2.8768),(-.6124,54.97335,2.90624),(-.61519,55.17739,2.88571),(-.57083,55.18145,2.85948),(-.45847,55.05342,2.98554),(-.47814,54.99799,3.0066),(-.48459,54.9999,2.99763),(-.42476,55.1609,2.89071),(-.42362,55.20476,2.89298),(-.40706,55.18734,2.91529),(-.58018,54.90797,2.9737),(-.55478,54.96759,2.94906),(-.53829,54.95639,2.95842),(-.50723,55.07243,2.90331),(-.51775,55.07493,2.89868),(-.50062,55.09054,2.89301),(-.42544,55.23123,2.89578),(-.5577,54.89534,3.03798),(-.55086,54.90423,3.00542),(-.53179,54.9114,3.02396),(-.59851,54.93,2.94791),(-.52343,55.08954,2.88225),(-.5267,54.9026,3.0632),(-.51923,54.91938,3.03419),(-.4275,55.10473,2.92941),(-.41134,55.14227,2.91793),(-.41793,55.11128,2.94791),(-.47777,54.92665,3.09013),(-.45569,54.97232,3.06601),(-.46009,54.98258,3.09228),(-.45301,55.06967,3.08522),(-.44887,55.12199,3.05653),(-.45913,55.12682,3.07906),(-.47889,54.99604,3.12046),(-.49596,54.95714,3.11208),(-.50235,54.90783,3.07838),(-.64528,54.93888,2.90857),(-.62074,54.9109,2.95609),(-.56947,55.14602,3.15114),(-.61732,55.1974,3.13801),(-.56397,54.90237,3.05269),(-.59079,54.88407,3.01451),(-.60741,54.90861,3.04152),(-.62781,54.90967,3.00528),(-.67308,54.99502,2.89425),(-.67953,55.04474,2.91295),(-.67111,55.03785,2.89254),(-.658,54.97311,2.97597),(-.66462,55.02152,2.97427),(-.67317,55.04338,2.95364),(-.65962,55.00454,3.04164),(-.57327,55.07465,3.14259),(-.54714,55.08357,3.15146),(-.5923,54.96789,3.10462),(-.56387,55.03202,3.14142),(-.60892,55.063,3.13154),(-.55079,54.96369,3.10666),(-.56144,54.97532,3.11468),(-.56293,54.9557,3.09634),(-.53316,55.05108,3.14709),(-.64582,54.94645,3.0279),(-.6406,54.92451,2.98216),(-.66733,55.06193,3.00478),(-.66641,55.08166,2.97289),(-.6716,54.97003,2.9055),(-.6777,54.99794,2.91497),(-.64657,55.18788,2.93031),(-.63176,55.183,2.90527),(-.64791,55.13521,2.89862),(-.61033,54.89338,2.98216),(-.52373,54.98648,3.12716),(-.51862,54.92993,3.1004),(-.444,55.02938,3.06418),(-.4542,55.02912,3.09405),(-.42227,55.13664,2.99004),(-.46852,55.00096,3.01258),(-.4297,55.07431,2.97784),(-.46999,55.06587,2.94347),(-.4574,55.12773,2.87681),(-.44471,55.18274,2.87038),(-.53626,55.0001,2.93665),(-.5191,55.09768,2.87721),(-.5017,55.14599,2.86436),(-.47923,55.13608,2.86836),(-.53591,55.2279,2.85878),(-.50501,55.20849,2.85328),(-.65944,55.03027,2.8746),(-.65213,55.07535,2.87012),(-.44064,55.11449,2.90068),(-.40685,55.16332,2.95132),(-.40369,55.22006,2.9464),(-.42934,55.04915,3.02249),(-.44183,55.04386,3.00145),(-.41068,55.11997,2.96813),(-.49589,54.9301,3.05528),(-.637,55.12575,2.87295),(-.59058,54.98181,2.92865),(-.57155,55.01463,2.91568),(-.53091,55.04645,2.91269),(-.55224,55.05067,2.89244),(-.53832,55.07307,2.88809),(-.62673,55.07609,2.87907),(-.50896,55.01579,3.13693),(-.54009,55.00067,3.1318),(-.56007,54.99099,3.12864),(-.60026,55.02492,3.12376),(-.66629,55.10545,2.96052),(-.6656,55.09023,2.95889),(-.64754,54.9339,2.96667),(-.48024,55.04828,2.95838),(-.4515,55.0443,2.99415),(-.44216,55.06304,2.97623),(-.61209,55.26017,3.13519),(-.56872,55.22036,2.86728),(-.53607,55.24118,2.85969),(-.40481,55.23504,2.94999),(-.56321,55.22648,3.14423),(-.5682,55.23513,2.87163),(-.47332,55.19737,2.85486),(-.47331,55.22436,2.86202),(-.44062,55.15675,3.02655),(-.6674,55.07478,2.95699),(-.63816,54.92505,2.96987),(-.56771,55.01,3.13358),(-.6647,54.99375,2.88282),(-.61222,55.10691,2.87464),(-.54531,55.07815,2.8828),(-.58081,55.01132,2.90052),(-.48227,54.9589,3.0365),(-.49082,54.93383,3.05972),(-.48872,54.95718,3.03381),(-.46967,55.04581,2.97228),(-.42061,55.0798,3.00166),(-.44578,55.21939,2.87766),(-.56367,55.06644,2.87863),(-.5046,55.0632,3.14665),(-.65431,55.1422,2.92663),(-.66353,55.10608,2.949),(-.66707,55.08913,2.94844),(-.67057,55.08465,2.91223),(-.61431,55.12931,3.13693),(-.64425,55.17822,3.11643),(-.64247,55.23033,3.11815),(-.66283,55.19613,2.96787),(-.67056,55.1644,3.02394),(-.66831,55.22207,3.0253),(-.67294,55.00014,2.95045),(-.66378,55.25627,3.06018),(-.65615,55.26121,3.09275),(-.66216,55.25801,3.0689),(-.56805,54.90339,2.9853),(-.5008,55.23742,2.85447),(-.47319,54.96189,3.04136),(-.48843,55.00114,2.9927),(-.51839,54.99916,2.94328),(-.66053,54.9605,2.89367),(-.50078,55.09139,3.14439),(-.51486,55.08987,3.15234),(-.60266,55.21205,2.88935),(-.66236,55.27104,3.06047),(-.65388,55.27502,3.09153),(-.487,55.17646,3.10442),(-.51926,55.20615,3.13129),(-.48709,55.16279,3.11012),(-.66214,55.21762,2.97502),(-.64171,55.22091,2.93608),(-.64411,55.20687,2.93323),(-.65869,55.23115,2.97257),(-.47243,55.24012,2.86283),(-.4444,55.25138,2.87971),(-.44476,55.23699,2.87828),(-.47182,55.25456,2.86404),(-.50213,55.25211,2.85604),(-.66346,55.08069,2.88988),(-.45601,55.0053,3.02118),(-.49637,54.95522,3.02495),(-.52681,54.95564,2.97943),(-.51841,54.95399,2.99574),(-.50796,54.95248,3.01225),(-.4296,55.10233,3.02066),(-.47231,55.04215,3.12372),(-.47506,55.08786,3.11958),(-.66745,55.24176,3.03014),(-.66705,55.13827,2.96441),(-.67015,55.11661,3.01452),(-.66808,55.11056,3.05848),(-.66735,55.04456,3.04984),(-.64585,55.00278,3.07109),(-.63077,54.94617,3.06022),(-.66172,55.17247,3.093),(-.6647,55.23276,3.06099),(-.66818,55.16237,3.06424),(-.65845,55.24152,3.09402),(-.6402,55.11902,3.11507),(-.6578,55.11328,3.09175),(-.6241,55.00813,3.09812),(-.60905,54.95743,3.08785),(-.63332,55.06435,3.10881),(-.65452,55.04779,3.08094),(-.48299,55.1428,3.11163),(-.43673,55.06045,3.04878),(-.49778,55.00333,2.97785),(-.66173,54.9505,2.93348),(-.56387,55.24204,3.14117),(-.66521,55.25688,3.03003),(-.63646,55.27525,3.11345),(-.63854,55.26156,3.11539),(-.61069,55.27404,3.13342),(-.43967,55.01885,3.04333)]))),
        Shape(DEF='rmolar1c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rmolar1c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,4,3,6,-1,7,8,2,-1,9,10,11,-1,12,13,14,-1,12,14,15,-1,16,17,18,-1,19,20,21,-1,19,22,23,-1,23,24,25,-1,26,23,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,37,41,-1,42,43,44,-1,45,46,47,-1,48,49,42,-1,50,51,7,-1,52,45,47,-1,53,54,55,-1,56,57,44,-1,58,59,60,-1,50,57,60,-1,61,62,63,-1,64,62,65,-1,51,8,7,-1,10,66,3,-1,2,8,67,-1,68,69,47,-1,70,65,71,-1,52,72,45,-1,73,74,75,-1,76,77,78,-1,26,79,80,-1,81,80,82,-1,82,79,83,-1,66,40,41,-1,29,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,53,-1,100,101,102,-1,103,104,105,-1,106,107,108,-1,109,104,110,-1,111,112,113,-1,85,114,115,-1,116,117,118,-1,119,120,118,-1,121,122,115,-1,123,124,125,-1,126,127,128,-1,128,129,126,-1,130,131,132,-1,125,133,134,-1,135,127,126,-1,121,123,125,-1,116,112,111,-1,136,113,137,-1,138,139,109,-1,36,140,99,-1,141,142,53,-1,143,55,144,-1,145,146,92,-1,91,147,148,-1,149,150,38,-1,29,82,84,-1,150,151,30,-1,35,34,76,-1,77,152,153,-1,74,154,155,-1,52,156,157,-1,70,71,47,-1,8,68,46,-1,7,158,159,-1,157,156,160,-1,42,6,13,-1,69,68,51,-1,161,44,57,-1,48,42,44,-1,50,161,57,-1,99,61,53,-1,52,47,71,-1,49,162,163,-1,45,8,46,-1,42,136,43,-1,164,39,38,-1,37,40,165,-1,34,36,98,-1,75,155,35,-1,166,167,93,-1,25,168,20,-1,77,21,20,-1,26,27,135,-1,28,169,32,-1,170,171,87,-1,172,164,173,-1,174,136,137,-1,147,91,17,-1,136,12,113,-1,14,111,15,-1,45,175,176,-1,176,0,67,-1,163,162,177,-1,32,31,26,-1,5,177,11,-1,9,11,178,-1,179,180,181,-1,170,180,182,-1,179,182,180,-1,183,40,184,-1,5,4,177,-1,177,178,11,-1,0,2,67,-1,45,185,175,-1,15,111,113,-1,186,102,187,-1,91,188,17,-1,13,12,136,-1,172,39,164,-1,87,180,170,-1,81,28,32,-1,189,23,89,-1,135,79,26,-1,31,33,24,-1,78,77,20,-1,190,166,93,-1,191,34,98,-1,150,30,29,-1,165,176,175,-1,38,85,164,-1,50,159,48,-1,45,67,8,-1,158,162,49,-1,50,60,51,-1,57,58,60,-1,51,60,69,-1,160,140,157,-1,40,183,165,-1,47,69,70,-1,65,156,71,-1,157,72,52,-1,155,75,74,-1,153,21,77,-1,34,192,76,-1,73,168,193,-1,193,24,33,-1,151,28,30,-1,84,114,85,-1,148,86,91,-1,92,94,145,-1,141,94,142,-1,99,98,36,-1,194,195,196,-1,197,112,116,-1,109,198,138,-1,15,113,12,-1,111,173,116,-1,197,116,199,-1,125,119,121,-1,200,135,126,-1,119,125,134,-1,130,132,201,-1,124,200,126,-1,115,123,121,-1,118,121,119,-1,199,116,118,-1,198,197,202,-1,198,137,197,-1,85,115,122,-1,137,113,197,-1,110,174,109,-1,106,108,203,-1,103,105,204,-1,102,205,100,-1,95,97,143,-1,93,142,94,-1,89,91,86,-1,86,148,87,-1,85,150,29,-1,82,80,79,-1,82,29,81,-1,26,31,24,-1,193,25,24,-1,75,78,73,-1,73,193,151,-1,71,156,52,-1,70,64,65,-1,47,46,68,-1,10,3,5,-1,51,68,8,-1,64,206,62,-1,61,160,62,-1,70,59,64,-1,136,42,13,-1,50,48,161,-1,55,141,53,-1,158,7,178,-1,50,7,159,-1,176,67,45,-1,161,48,44,-1,85,38,150,-1,37,39,41,-1,35,155,36,-1,25,193,168,-1,32,169,33,-1,28,81,29,-1,26,24,23,-1,25,19,23,-1,33,169,193,-1,37,149,38,-1,112,197,113,-1,19,25,20,-1,91,207,188,-1,16,147,17,-1,14,173,111,-1,10,5,11,-1,2,178,7,-1,208,181,180,-1,208,209,181,-1,210,211,212,-1,211,210,213,-1,214,215,95,-1,214,216,215,-1,182,217,130,-1,182,179,217,-1,218,219,220,-1,218,221,219,-1,222,203,223,-1,203,222,224,-1,40,10,184,-1,10,40,66,-1,107,204,105,-1,204,107,225,-1,226,22,153,-1,90,22,226,-1,172,14,13,-1,172,173,14,-1,171,201,227,-1,171,170,201,-1,212,228,146,-1,211,228,212,-1,152,167,166,-1,152,192,167,-1,191,53,142,-1,191,98,53,-1,120,229,230,-1,229,120,231,-1,58,232,59,-1,232,58,233,-1,42,163,6,-1,163,42,49,-1,149,151,150,-1,149,234,151,-1,169,151,193,-1,169,28,151,-1,88,235,189,-1,236,235,88,-1,147,208,148,-1,16,208,147,-1,226,190,207,-1,226,166,190,-1,237,146,145,-1,237,212,146,-1,238,55,54,-1,144,55,238,-1,239,232,240,-1,232,239,206,-1,195,186,187,-1,186,195,194,-1,241,242,194,-1,242,241,243,-1,243,103,242,-1,243,244,103,-1,245,139,138,-1,139,245,108,-1,43,174,110,-1,43,136,174,-1,125,126,129,-1,125,124,126,-1,138,246,245,-1,246,138,247,-1,197,230,202,-1,197,199,230,-1,129,133,125,-1,133,129,248,-1,249,133,250,-1,134,133,249,-1,170,130,201,-1,130,170,182,-1,250,218,249,-1,218,250,251,-1,171,128,236,-1,128,171,227,-1,124,115,200,-1,123,115,124,-1,202,229,247,-1,202,230,229,-1,122,118,117,-1,122,121,118,-1,247,198,202,-1,198,247,138,-1,114,200,115,-1,114,83,200,-1,117,85,122,-1,117,164,85,-1,108,223,203,-1,108,245,223,-1,106,225,107,-1,106,252,225,-1,252,205,225,-1,252,100,205,-1,244,56,44,-1,56,244,243,-1,240,233,241,-1,240,232,233,-1,102,214,187,-1,101,214,102,-1,187,95,143,-1,95,187,214,-1,96,145,97,-1,96,237,145,-1,253,207,190,-1,207,253,188,-1,167,142,93,-1,191,142,167,-1,171,88,87,-1,236,88,171,-1,127,236,128,-1,127,235,236,-1,81,26,80,-1,81,32,26,-1,20,73,78,-1,73,20,168,-1,72,185,45,-1,72,154,185,-1,62,156,65,-1,62,160,156,-1,158,177,162,-1,158,178,177,-1,231,254,229,-1,254,231,255,-1,253,146,228,-1,253,92,146,-1,227,132,248,-1,227,201,132,-1,90,207,91,-1,90,226,207,-1,225,256,204,-1,256,225,205,-1,4,163,177,-1,163,4,257,-1,258,223,259,-1,223,258,222,-1,251,221,218,-1,251,260,221,-1,252,261,100,-1,252,262,261,-1,215,96,95,-1,96,215,263,-1,213,18,211,-1,18,213,264,-1,16,209,208,-1,16,265,209,-1,266,212,237,-1,212,266,210,-1,267,214,101,-1,214,267,216,-1,130,268,131,-1,130,217,268,-1,269,220,219,-1,270,220,269,-1,224,106,203,-1,106,224,271,-1,9,184,10,-1,9,1,184,-1,108,105,139,-1,105,108,107,-1,153,19,21,-1,22,19,153,-1,192,77,76,-1,152,77,192,-1,48,158,49,-1,48,159,158,-1,141,143,97,-1,141,55,143,-1,154,157,155,-1,154,72,157,-1,233,57,56,-1,58,57,233,-1,64,232,206,-1,232,64,59,-1,13,66,172,-1,6,66,13,-1,6,3,66,-1,157,36,155,-1,157,140,36,-1,234,73,151,-1,234,74,73,-1,84,83,114,-1,84,82,83,-1,189,86,88,-1,189,89,86,-1,89,22,90,-1,23,22,89,-1,166,153,152,-1,153,166,226,-1,211,17,228,-1,211,18,17,-1,61,54,53,-1,54,61,63,-1,239,54,63,-1,238,54,239,-1,240,238,239,-1,240,196,238,-1,233,243,241,-1,233,56,243,-1,204,242,103,-1,204,256,242,-1,104,244,110,-1,244,104,103,-1,109,137,198,-1,109,174,137,-1,27,127,135,-1,235,127,27,-1,259,245,246,-1,259,223,245,-1,230,118,120,-1,199,118,230,-1,270,246,254,-1,259,246,270,-1,128,248,129,-1,128,227,248,-1,255,270,254,-1,270,255,220,-1,251,132,131,-1,251,250,132,-1,248,250,133,-1,248,132,250,-1,134,255,231,-1,134,249,255,-1,231,119,134,-1,120,119,231,-1,247,254,246,-1,247,229,254,-1,83,135,200,-1,83,79,135,-1,117,173,164,-1,116,173,117,-1,139,104,109,-1,105,104,139,-1,194,256,186,-1,194,242,256,-1,44,110,244,-1,43,110,44,-1,196,241,194,-1,196,240,241,-1,196,144,238,-1,144,196,195,-1,239,62,206,-1,63,62,239,-1,195,143,144,-1,143,195,187,-1,94,97,145,-1,97,94,141,-1,253,17,188,-1,253,228,17,-1,191,192,34,-1,191,167,192,-1,148,180,87,-1,180,148,208,-1,189,27,23,-1,189,235,27,-1,66,39,172,-1,41,39,66,-1,154,234,185,-1,154,74,234,-1,165,149,37,-1,175,149,165,-1,59,69,60,-1,59,70,69,-1,140,61,99,-1,140,160,61,-1,0,165,183,-1,165,0,176,-1,249,220,255,-1,249,218,220,-1,78,35,76,-1,78,75,35,-1,92,190,93,-1,253,190,92,-1,205,186,256,-1,186,205,102,-1,175,234,149,-1,185,234,175,-1,163,4,6,-1,163,257,4,-1,178,1,9,-1,178,2,1,-1,183,1,0,-1,183,184,1,-1,252,271,262,-1,252,106,271,-1,258,270,269,-1,259,270,258,-1,131,260,251,-1,131,268,260,-1,261,101,100,-1,101,261,267,-1,263,237,96,-1,237,263,266,-1,264,16,18,-1,16,264,265,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmolar1c_Coord',point=[(-.8138,55.086,2.22998),(-.81058,55.07977,2.23686),(-.82721,55.09391,2.24621),(-.75884,54.99927,2.2378),(-.76738,55.03623,2.25686),(-.7676,55.03726,2.24983),(-.75611,55.00999,2.28546),(-.83015,55.08009,2.27559),(-.83784,55.0951,2.24076),(-.8041,55.07204,2.25498),(-.78338,55.0301,2.23511),(-.8012,55.0728,2.26038),(-.71548,55.00389,2.27685),(-.74039,54.99928,2.28544),(-.70574,54.99063,2.22576),(-.70559,55.00501,2.25268),(-.94745,55.31396,2.10579),(-.97067,55.30222,2.11702),(-.96521,55.31694,2.12227),(-.93833,55.05977,2.0454),(-.95827,55.02278,2.09703),(-.96413,55.03657,2.06205),(-.94439,55.07973,2.03981),(-.89956,55.07922,2.01963),(-.89868,55.07778,2.02326),(-.93451,55.05973,2.05508),(-.84213,55.05778,1.99945),(-.83725,55.06768,1.98929),(-.84062,55.08099,2.11072),(-.7816,55.04454,2.06631),(-.80028,55.06419,2.10379),(-.85437,55.06072,2.04525),(-.84817,55.06054,2.04787),(-.87637,55.0893,2.08055),(-1.00127,55.03638,2.16264),(-.98041,55.00153,2.15056),(-.98455,55.04422,2.19709),(-.78836,55.01633,2.14561),(-.76958,55.01118,2.12797),(-.75556,54.98777,2.16275),(-.77437,55.00585,2.1718),(-.76981,54.99863,2.16977),(-.77848,55.04165,2.32989),(-.77366,55.0524,2.34252),(-.8028,55.05686,2.35846),(-.86635,55.09945,2.21653),(-.86582,55.09805,2.22383),(-.9063,55.06031,2.24786),(-.80597,55.0617,2.32902),(-.789,55.0549,2.31629),(-.83425,55.06099,2.32986),(-.84425,55.07457,2.30724),(-.91765,55.06933,2.22455),(-.99949,55.14811,2.23367),(-1.00483,55.13271,2.30199),(-.99982,55.19295,2.30234),(-.85972,55.06238,2.38623),(-.86509,55.04484,2.38032),(-.89377,55.02755,2.38096),(-.92101,55.0118,2.37386),(-.87504,55.05064,2.33895),(-.99301,55.08763,2.24908),(-.98374,55.0388,2.28541),(-.99606,55.07742,2.29629),(-.94881,55.00044,2.32853),(-.96357,55.00692,2.28005),(-.7602,54.99391,2.21401),(-.83296,55.09283,2.23476),(-.85618,55.07377,2.26359),(-.88182,55.03352,2.281),(-.91531,55.00569,2.30243),(-.94774,55.02162,2.26072),(-.91332,55.05808,2.20194),(-.91277,55.0367,2.11426),(-.90521,55.03018,2.13815),(-.96506,55.00371,2.14372),(-.99012,54.99884,2.11713),(-.98778,55.01168,2.08236),(-.97122,55.00085,2.11919),(-.79536,55.0335,1.99145),(-.81243,55.03093,2.01763),(-.83068,55.04633,2.06407),(-.78633,55.01451,2.02632),(-.74302,55.00629,2.02222),(-.77184,55.008,2.07475),(-.74673,55.01496,2.11705),(-.89882,55.17795,2.05974),(-.8478,55.22465,2.06359),(-.85557,55.16926,2.03409),(-.90592,55.11507,2.03014),(-.95401,55.12193,2.05076),(-.96204,55.19609,2.07758),(-1.01394,55.2172,2.16133),(-1.02017,55.15808,2.15034),(-1.01151,55.21689,2.19712),(-.97835,55.30071,2.31405),(-.98455,55.30557,2.24322),(-.99818,55.27698,2.24495),(-1.00092,55.09282,2.20718),(-.99263,55.0917,2.22937),(-.88937,55.28178,2.36622),(-.92235,55.2899,2.36529),(-.91817,55.26261,2.36946),(-.82419,55.16,2.37009),(-.7773,55.15451,2.34363),(-.79313,55.20859,2.33118),(-.80718,55.28039,2.33612),(-.80148,55.24482,2.32931),(-.73247,55.23881,2.30243),(-.7154,55.13479,2.32119),(-.77087,55.09726,2.35346),(-.69572,54.98754,2.22898),(-.67568,55.00606,2.23962),(-.69465,55.01893,2.27054),(-.73556,55.00543,2.06533),(-.7061,55.01462,2.064),(-.67655,55.00035,2.19231),(-.69937,55.00397,2.14965),(-.65808,55.04731,2.14499),(-.65729,55.11741,2.11097),(-.64309,55.11497,2.1449),(-.6816,55.06298,2.11468),(-.70664,55.03738,2.11614),(-.68,55.06052,2.0664),(-.69307,55.06059,2.02995),(-.6734,55.11715,2.05872),(-.72523,55.06515,1.98898),(-.77632,55.08607,1.97758),(-.75108,55.14326,1.99207),(-.71297,55.13385,2.00704),(-.75792,55.27004,2.04738),(-.72215,55.26568,2.0498),(-.71833,55.23716,2.04075),(-.67325,55.18515,2.07164),(-.65331,55.17918,2.11358),(-.79427,55.03873,1.97889),(-.72594,55.03632,2.31051),(-.68844,55.06254,2.291),(-.66202,55.19126,2.27247),(-.72242,55.20322,2.30302),(-.97067,55.05215,2.21537),(-1.00899,55.20917,2.24034),(-1.01163,55.1489,2.18431),(-.99268,55.25791,2.30658),(-.99374,55.18986,2.32507),(-.99639,55.28845,2.20567),(-.99087,55.29882,2.17074),(-.95258,55.29786,2.10279),(-.89679,55.26234,2.09642),(-.81457,55.03274,2.13667),(-.79591,55.0644,2.10891),(-.84388,55.08024,2.11859),(-1.00406,55.05277,2.07699),(-.9764,55.06511,2.0537),(-.90977,55.04719,2.17818),(-.95464,55.01856,2.18753),(-.9617,55.02773,2.23111),(-.95391,55.03181,2.20719),(-.82195,55.07938,2.27934),(-.82087,55.07616,2.29194),(-.97408,55.04923,2.23957),(-.81851,55.05893,2.34415),(-.79464,55.06112,2.29033),(-.77087,55.02944,2.284),(-.73647,54.98344,2.15732),(-.80207,55.05043,2.19387),(-1.02046,55.10866,2.09507),(-1.0193,55.10046,2.13671),(-.92911,55.05668,2.08695),(-.87017,55.08794,2.08428),(-.7906,55.25683,2.04414),(-.78678,55.20734,2.01959),(-.73391,54.97781,2.20866),(-.70333,54.98281,2.19693),(-.71567,55.07288,2.31528),(-.82149,55.05928,2.18576),(-.823,55.08445,2.22303),(-.79507,55.07076,2.26371),(-.82207,55.08434,2.27265),(-.79325,55.28547,2.05701),(-.84479,55.28212,2.06734),(-.84245,55.2938,2.07016),(-.79471,55.27448,2.05183),(-.79276,55.05029,2.20067),(-.79099,55.04606,2.2093),(-.86001,55.07683,2.1698),(-.91566,55.2379,2.37304),(-.96029,55.25545,2.35913),(-.98943,55.20783,2.09451),(-.87587,55.10673,2.01414),(-1.01571,55.16724,2.11125),(-1.01296,55.09321,2.17307),(-1.00903,55.04535,2.1201),(-.8827,55.09025,2.08515),(-.91602,55.18271,2.39149),(-.9553,55.2008,2.37263),(-.94941,55.15369,2.38077),(-.65016,55.05693,2.24605),(-.66837,55.13443,2.28623),(-.64139,55.04981,2.18926),(-.73217,55.01435,2.00348),(-.74691,55.24399,2.03609),(-.6383,55.12041,2.23867),(-.7426,55.27365,2.30564),(-.84116,55.216,2.3485),(-.88812,55.25962,2.36209),(-.96205,55.03522,2.33501),(-.99233,55.1823,2.08918),(-.89741,55.29812,2.10087),(-.89495,55.30992,2.10313),(-.9751,55.32959,2.17192),(-.97558,55.31873,2.14319),(-.98003,55.31863,2.17146),(-.97114,55.32968,2.14545),(-.95769,55.29863,2.35221),(-.97378,55.31183,2.31381),(-.95497,55.31001,2.34964),(-.75715,55.28097,2.0528),(-.66577,55.25932,2.12339),(-.66408,55.27077,2.15239),(-.66061,55.25925,2.15169),(-.66855,55.27105,2.12503),(-.68007,55.27355,2.26697),(-.6783,55.26193,2.26991),(-.74233,55.28523,2.30278),(-.84693,55.2524,2.34599),(-.99001,55.11583,2.06855),(-.7394,55.19713,2.0178),(-.98202,55.30453,2.13776),(-.6327,55.17264,2.18049),(-.63328,55.10686,2.18524),(-.64299,55.17591,2.147),(-.92903,55.04424,2.38066),(-.89897,55.05839,2.38985),(-.85788,55.05923,2.13711),(-.81574,55.0953,1.98353),(-.80042,55.15091,1.99661),(-.98704,55.31301,2.19923),(-.99196,55.13891,2.33291),(-.97646,55.08417,2.34022),(-.9406,55.10481,2.38456),(-.90926,55.11972,2.39921),(-.87857,55.17381,2.3854),(-.86135,55.11813,2.39473),(-.80755,55.1117,2.37054),(-.67188,55.24181,2.26547),(-.64243,55.23767,2.2234),(-.63284,55.18936,2.23239),(-.7065,55.18991,2.0257),(-.66035,55.22182,2.11955),(-.6837,55.23337,2.08322),(-.6834,55.26124,2.09382),(-.84993,55.2816,2.35276),(-1.00683,55.21673,2.12347),(-.63995,55.22118,2.18605),(-.64989,55.22153,2.15271),(-.88724,55.22567,2.36652),(-.76996,55.03243,2.27149),(-.65214,55.27001,2.22222),(-.64851,55.25862,2.22289),(-.6847,55.27279,2.0973),(-.88836,55.2936,2.36468),(-.84969,55.29349,2.35114),(-.97988,55.31661,2.24247),(-.96142,55.32809,2.1252),(-.94449,55.32547,2.10867),(-.98246,55.32406,2.20155),(-.92007,55.30154,2.36282),(-.72342,55.27685,2.05463),(-.65955,55.27051,2.18009),(-.65596,55.25905,2.17862),(-.80683,55.29215,2.3339)]))),
        Shape(DEF='rmolar2c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rmolar2c_Geo',coordIndex=[0,1,2,-1,0,3,4,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,25,21,29,-1,30,31,32,-1,30,33,34,-1,31,35,32,-1,11,36,12,-1,37,38,39,-1,28,40,41,-1,42,43,2,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,50,-1,54,55,56,-1,57,58,59,-1,55,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,25,74,75,-1,12,36,29,-1,47,76,77,-1,76,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,83,92,93,-1,94,95,96,-1,90,97,91,-1,97,98,99,-1,100,101,52,-1,101,100,102,-1,103,74,9,-1,96,55,104,-1,105,106,107,-1,71,108,109,-1,110,111,112,-1,113,114,115,-1,113,116,117,-1,42,2,1,-1,118,119,120,-1,121,122,123,-1,124,125,69,-1,96,126,97,-1,95,127,96,-1,128,77,86,-1,129,89,130,-1,105,107,131,-1,132,133,134,-1,8,135,136,-1,25,30,34,-1,137,138,139,-1,140,41,141,-1,53,134,142,-1,61,143,144,-1,145,146,103,-1,85,84,147,-1,128,148,149,-1,91,126,127,-1,150,151,152,-1,153,154,155,-1,156,122,121,-1,121,157,158,-1,159,160,161,-1,162,163,164,-1,113,165,166,-1,167,168,169,-1,58,57,148,-1,101,102,170,-1,90,171,172,-1,90,98,97,-1,94,173,95,-1,129,147,90,-1,174,100,51,-1,44,175,45,-1,85,81,80,-1,176,177,85,-1,129,81,147,-1,79,178,87,-1,36,179,10,-1,75,180,181,-1,182,183,160,-1,176,3,184,-1,140,185,151,-1,78,49,63,-1,61,60,143,-1,144,67,66,-1,96,56,55,-1,174,51,50,-1,47,149,65,-1,105,131,186,-1,187,186,131,-1,188,28,41,-1,185,140,175,-1,11,179,36,-1,28,189,26,-1,23,34,190,-1,26,190,27,-1,103,191,50,-1,33,32,190,-1,192,193,194,-1,12,29,13,-1,73,195,196,-1,197,8,10,-1,198,158,157,-1,199,196,195,-1,200,201,202,-1,0,4,1,-1,88,203,204,-1,205,117,116,-1,206,207,166,-1,34,33,190,-1,206,166,208,-1,209,205,116,-1,204,210,88,-1,201,211,202,-1,212,13,213,-1,199,214,196,-1,71,73,196,-1,11,212,215,-1,29,21,13,-1,216,18,17,-1,193,217,194,-1,32,27,190,-1,103,136,191,-1,26,23,190,-1,31,181,35,-1,181,180,218,-1,175,219,185,-1,188,41,220,-1,221,187,131,-1,221,45,187,-1,222,223,161,-1,65,48,47,-1,99,174,50,-1,104,58,96,-1,148,57,66,-1,78,47,49,-1,61,144,59,-1,28,188,224,-1,176,184,46,-1,182,160,159,-1,179,225,10,-1,148,94,96,-1,87,76,79,-1,128,94,148,-1,129,82,81,-1,85,226,176,-1,80,226,85,-1,175,227,45,-1,174,172,100,-1,127,126,96,-1,89,129,90,-1,172,98,90,-1,90,147,171,-1,148,96,58,-1,50,191,53,-1,108,71,196,-1,169,211,167,-1,113,166,116,-1,164,228,162,-1,161,229,159,-1,161,223,229,-1,121,230,156,-1,124,14,16,-1,231,50,232,-1,127,95,173,-1,149,77,128,-1,85,147,81,-1,233,145,103,-1,54,53,142,-1,134,53,191,-1,191,132,134,-1,137,139,197,-1,20,13,21,-1,23,25,34,-1,8,136,9,-1,153,155,19,-1,134,133,142,-1,129,130,82,-1,234,128,86,-1,235,91,127,-1,97,56,96,-1,101,93,92,-1,69,14,124,-1,123,157,121,-1,229,223,119,-1,1,236,42,-1,114,113,117,-1,115,237,113,-1,112,238,110,-1,173,235,127,-1,105,233,106,-1,103,9,136,-1,92,232,52,-1,52,101,92,-1,52,51,100,-1,99,56,97,-1,170,93,101,-1,126,91,97,-1,84,83,93,-1,88,239,86,-1,177,83,85,-1,82,240,80,-1,76,47,78,-1,80,240,241,-1,47,77,149,-1,75,30,25,-1,74,180,75,-1,71,109,72,-1,69,199,70,-1,65,67,242,-1,62,78,63,-1,61,104,55,-1,99,54,56,-1,99,50,54,-1,52,232,50,-1,149,148,66,-1,66,65,149,-1,198,119,223,-1,45,221,46,-1,43,184,2,-1,177,221,131,-1,188,220,243,-1,185,219,244,-1,11,121,179,-1,153,217,193,-1,231,106,50,-1,30,32,33,-1,25,24,192,-1,189,245,24,-1,193,245,153,-1,17,19,155,-1,11,13,212,-1,198,225,158,-1,119,198,157,-1,121,11,230,-1,5,246,6,-1,215,230,11,-1,3,247,4,-1,248,249,7,-1,250,249,248,-1,251,202,252,-1,202,251,253,-1,254,238,255,-1,238,254,256,-1,208,257,206,-1,208,258,257,-1,163,259,260,-1,163,162,259,-1,261,262,263,-1,262,261,264,-1,116,207,209,-1,207,116,166,-1,244,151,185,-1,244,152,151,-1,118,182,159,-1,182,118,265,-1,199,156,70,-1,199,195,156,-1,266,212,213,-1,215,212,266,-1,108,246,267,-1,108,214,246,-1,214,108,196,-1,157,120,119,-1,120,157,123,-1,268,269,270,-1,268,16,269,-1,28,32,40,-1,28,27,32,-1,163,271,164,-1,272,271,163,-1,177,107,83,-1,131,107,177,-1,146,186,187,-1,146,145,186,-1,142,55,54,-1,142,60,55,-1,273,274,112,-1,273,275,274,-1,153,276,154,-1,153,277,276,-1,151,41,140,-1,151,220,41,-1,277,269,276,-1,277,278,269,-1,64,160,183,-1,64,63,160,-1,226,241,247,-1,241,226,80,-1,203,87,178,-1,87,203,88,-1,82,210,240,-1,210,82,130,-1,83,232,92,-1,83,231,232,-1,125,279,6,-1,125,124,279,-1,167,280,168,-1,167,265,280,-1,183,281,282,-1,281,183,182,-1,282,64,183,-1,282,275,64,-1,111,283,165,-1,110,283,111,-1,207,284,285,-1,206,284,207,-1,1,285,286,-1,285,1,287,-1,278,270,269,-1,278,288,270,-1,289,228,164,-1,236,228,289,-1,290,37,39,-1,291,37,290,-1,178,115,114,-1,115,178,79,-1,266,292,68,-1,266,216,292,-1,293,150,152,-1,293,294,150,-1,295,247,241,-1,295,4,247,-1,61,58,104,-1,61,59,58,-1,158,179,121,-1,179,158,225,-1,21,217,22,-1,21,194,217,-1,193,24,245,-1,193,192,24,-1,213,216,266,-1,18,216,213,-1,239,89,296,-1,89,239,130,-1,241,205,295,-1,205,241,204,-1,79,62,115,-1,62,79,78,-1,263,288,290,-1,263,262,288,-1,294,271,297,-1,293,271,294,-1,236,244,42,-1,244,236,289,-1,279,16,268,-1,124,16,279,-1,4,287,1,-1,4,295,287,-1,237,165,113,-1,111,165,237,-1,275,298,274,-1,282,298,275,-1,252,267,299,-1,252,169,267,-1,248,6,279,-1,6,248,7,-1,146,218,180,-1,187,218,146,-1,174,98,172,-1,98,174,99,-1,171,100,172,-1,171,102,100,-1,87,77,76,-1,87,86,77,-1,240,204,241,-1,240,210,204,-1,222,137,223,-1,222,242,137,-1,123,73,72,-1,73,123,122,-1,150,220,151,-1,150,243,220,-1,48,242,222,-1,48,65,242,-1,255,112,274,-1,238,112,255,-1,133,60,142,-1,133,143,60,-1,139,143,133,-1,139,138,143,-1,105,145,233,-1,186,145,105,-1,106,83,107,-1,231,83,106,-1,243,37,188,-1,37,243,38,-1,218,35,181,-1,218,300,35,-1,23,189,24,-1,23,26,189,-1,19,217,153,-1,19,22,217,-1,29,10,9,-1,10,29,36,-1,17,154,301,-1,17,155,154,-1,302,270,303,-1,302,268,270,-1,292,15,14,-1,292,301,15,-1,108,168,109,-1,108,169,168,-1,267,169,108,-1,215,68,70,-1,215,266,68,-1,70,230,215,-1,70,156,230,-1,281,265,167,-1,281,182,265,-1,304,39,297,-1,305,39,304,-1,306,305,304,-1,305,306,307,-1,162,308,259,-1,308,162,309,-1,310,208,283,-1,208,310,258,-1,255,311,254,-1,255,312,311,-1,299,251,252,-1,299,313,251,-1,302,250,248,-1,314,250,302,-1,315,7,249,-1,5,7,315,-1,253,200,202,-1,200,253,316,-1,110,256,317,-1,110,238,256,-1,206,318,284,-1,206,257,318,-1,260,272,163,-1,272,260,319,-1,263,307,261,-1,307,263,305,-1,152,289,293,-1,244,289,152,-1,294,243,150,-1,38,243,294,-1,247,176,226,-1,3,176,247,-1,119,159,229,-1,159,119,118,-1,214,6,246,-1,214,125,6,-1,123,280,120,-1,280,123,72,-1,225,197,10,-1,198,197,225,-1,15,269,16,-1,15,276,269,-1,20,19,18,-1,20,22,19,-1,41,300,141,-1,300,41,40,-1,153,189,28,-1,153,245,189,-1,25,194,21,-1,25,192,194,-1,13,18,213,-1,18,13,20,-1,164,293,289,-1,271,293,164,-1,140,227,175,-1,140,141,227,-1,43,46,184,-1,43,44,46,-1,66,59,144,-1,66,57,59,-1,132,136,135,-1,136,132,191,-1,275,62,64,-1,273,62,275,-1,68,14,69,-1,14,68,292,-1,125,199,69,-1,125,214,199,-1,25,9,74,-1,25,29,9,-1,130,88,210,-1,88,130,239,-1,84,170,147,-1,84,93,170,-1,91,296,89,-1,296,91,235,-1,296,86,239,-1,234,86,296,-1,282,201,298,-1,201,282,281,-1,111,273,112,-1,111,237,273,-1,285,209,207,-1,285,287,209,-1,284,286,285,-1,284,309,286,-1,303,288,262,-1,270,288,303,-1,1,228,236,-1,1,286,228,-1,290,305,263,-1,290,39,305,-1,178,117,203,-1,178,114,117,-1,291,188,37,-1,291,224,188,-1,3,2,184,-1,3,0,2,-1,50,233,103,-1,50,106,233,-1,139,8,197,-1,139,135,8,-1,180,103,146,-1,74,103,180,-1,227,187,45,-1,187,227,218,-1,242,138,137,-1,138,242,67,-1,42,219,43,-1,42,244,219,-1,277,291,278,-1,291,277,224,-1,63,161,160,-1,63,49,161,-1,278,290,288,-1,278,291,290,-1,272,297,271,-1,272,304,297,-1,286,162,228,-1,286,309,162,-1,268,248,279,-1,268,302,248,-1,209,295,205,-1,209,287,295,-1,165,208,166,-1,165,283,208,-1,237,62,273,-1,62,237,115,-1,312,274,298,-1,312,255,274,-1,200,298,201,-1,200,312,298,-1,211,252,202,-1,169,252,211,-1,267,5,299,-1,5,267,246,-1,235,234,296,-1,234,235,173,-1,170,171,147,-1,171,170,102,-1,176,221,177,-1,176,46,221,-1,234,94,128,-1,234,173,94,-1,137,198,223,-1,198,137,197,-1,120,265,118,-1,280,265,120,-1,175,43,219,-1,44,43,175,-1,153,224,277,-1,153,28,224,-1,49,222,161,-1,48,222,49,-1,133,135,139,-1,135,133,132,-1,67,143,138,-1,67,144,143,-1,218,141,300,-1,141,218,227,-1,75,31,30,-1,31,75,181,-1,35,40,32,-1,35,300,40,-1,154,15,301,-1,15,154,276,-1,216,301,292,-1,216,17,301,-1,195,122,156,-1,73,122,195,-1,280,109,168,-1,280,72,109,-1,167,201,281,-1,201,167,211,-1,38,297,39,-1,38,294,297,-1,203,205,204,-1,205,203,117,-1,320,262,264,-1,320,303,262,-1,319,304,272,-1,304,319,306,-1,318,309,284,-1,309,318,308,-1,283,317,310,-1,283,110,317,-1,316,312,200,-1,312,316,311,-1,299,315,313,-1,299,5,315,-1,303,314,302,-1,303,320,314,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmolar2c_Coord',point=[(-1.06834,55.10192,1.88719),(-1.08451,55.14189,1.893),(-1.07489,55.0965,1.85667),(-1.0457,55.06455,1.87762),(-1.06968,55.09686,1.91245),(-.74323,55.23358,1.77082),(-.75927,55.17878,1.7336),(-.75612,55.2332,1.74131),(-.88156,55.06174,1.80232),(-.93165,55.09738,1.79085),(-.87011,55.05951,1.79202),(-.84464,55.05859,1.78149),(-.86035,55.0705,1.77963),(-.86792,55.07314,1.75654),(-.81294,55.07654,1.6983),(-.8419,55.08389,1.68512),(-.82108,55.13518,1.67726),(-.85461,55.06344,1.69735),(-.86085,55.059,1.71927),(-.8868,55.08387,1.69816),(-.8755,55.07579,1.73348),(-.91385,55.11176,1.7682),(-.89141,55.08866,1.71625),(-.92489,55.11702,1.76244),(-.92166,55.11631,1.76394),(-.91814,55.11578,1.7721),(-.96108,55.12361,1.71098),(-.96456,55.11661,1.71976),(-.96415,55.12416,1.70664),(-.91166,55.10933,1.77371),(-.9255,55.1133,1.77152),(-.97181,55.09616,1.74861),(-.9674,55.1046,1.73824),(-.95209,55.11674,1.75409),(-.92493,55.11468,1.76676),(-.99687,55.07845,1.75299),(-.86289,55.06733,1.7832),(-.99904,55.15881,1.7194),(-1.02281,55.15806,1.72839),(-1.01138,55.23114,1.75146),(-.98367,55.09983,1.729),(-1.00605,55.10018,1.72183),(-1.08146,55.09109,1.82618),(-1.05058,55.05112,1.80832),(-1.04396,55.04473,1.80546),(-1.02529,55.04549,1.79256),(-1.04056,55.04554,1.84079),(-.87581,55.07527,1.99998),(-.85777,55.0549,1.96881),(-.84299,55.05741,1.97063),(-.94782,55.1194,1.87068),(-.94569,55.11443,1.88441),(-.94838,55.11558,1.88245),(-.94347,55.12016,1.87036),(-.94326,55.1185,1.87363),(-.92399,55.10261,1.93423),(-.93276,55.10729,1.91775),(-.89337,55.06676,1.96005),(-.92086,55.09925,1.93886),(-.89508,55.0683,1.93159),(-.89601,55.07147,1.91198),(-.89456,55.07015,1.92143),(-.8685,55.11007,2.01009),(-.83735,55.06674,1.97464),(-.82591,55.09721,1.98384),(-.87284,55.0558,1.96508),(-.88811,55.06482,1.96196),(-.86825,55.05101,1.93826),(-.8059,55.06194,1.72852),(-.79518,55.07347,1.72626),(-.79831,55.0644,1.7585),(-.76018,55.12875,1.81579),(-.77795,55.08077,1.83439),(-.79274,55.08705,1.8081),(-.94167,55.10234,1.79262),(-.93178,55.10724,1.77613),(-.92892,55.07145,2.02475),(-.93122,55.06228,2.01721),(-.87391,55.07909,2.00316),(-.92905,55.07897,2.02907),(-1.04395,55.03402,1.91763),(-1.02438,55.03504,1.91396),(-1.03023,55.02177,1.94069),(-1.00179,55.08001,1.88222),(-1.01235,55.05796,1.90044),(-1.02037,55.05199,1.88973),(-.97854,55.05083,2.02911),(-.98336,55.05759,2.03832),(-1.00338,55.0355,2.0219),(-1.01139,55.02961,1.97668),(-.99303,55.04669,1.94246),(-.99282,55.05483,1.98121),(-1.002,55.07187,1.90185),(-1.0062,55.06809,1.90279),(-.94885,55.06501,1.99969),(-.9657,55.07754,1.99058),(-.92618,55.10199,1.9384),(-.9743,55.07059,1.95911),(-.98179,55.05955,1.9348),(-.9373,55.10672,1.90345),(-.99816,55.06843,1.9104),(-1.00144,55.06957,1.90666),(-1.00109,55.06529,1.91378),(-.9445,55.09975,1.79502),(-.92262,55.10222,1.93716),(-1.0056,55.0668,1.83124),(-.95153,55.11252,1.85901),(-1.00374,55.07004,1.84765),(-.74651,55.16599,1.81928),(-.75161,55.12906,1.84),(-.92045,55.27182,2.01358),(-.91998,55.22461,2.02471),(-.84983,55.2257,1.99979),(-.99593,55.1527,2.0539),(-.99638,55.10279,2.04901),(-.93179,55.11458,2.03613),(-1.02751,55.14141,2.03906),(-1.02288,55.09058,2.02966),(-.77831,55.05498,1.88064),(-.79405,55.03871,1.87177),(-.7799,55.05681,1.87177),(-.80909,55.06814,1.80271),(-.80092,55.0776,1.8054),(-.78919,55.06587,1.83267),(-.78694,55.12646,1.70053),(-.77611,55.125,1.7249),(-.97462,55.07838,1.98014),(-.97264,55.07657,1.98876),(-.93527,55.05899,2.008),(-1.01593,55.02497,1.94399),(-1.01919,55.02574,1.98365),(-1.01517,55.05958,1.83373),(-.90264,55.07566,1.84837),(-.89187,55.06765,1.85627),(-.90471,55.07846,1.85628),(-.88877,55.06479,1.80898),(-.9375,55.09681,1.79714),(-.83748,55.0315,1.90069),(-.84803,55.03958,1.90226),(-.84903,55.04117,1.85674),(-1.04642,55.07748,1.7427),(-1.02488,55.07451,1.74572),(-.90233,55.07711,1.87019),(-.88227,55.06224,1.91604),(-.8863,55.06416,1.92745),(-.95171,55.10871,1.84806),(-.95028,55.09696,1.79253),(-1.01257,55.04397,1.91952),(-.89318,55.06728,1.96994),(-.88445,55.06673,1.9855),(-1.0501,55.11952,1.735),(-1.0484,55.08974,1.73925),(-1.05886,55.11465,1.74158),(-.92161,55.11382,1.69585),(-.88053,55.08642,1.68787),(-.88423,55.08207,1.69116),(-.79957,55.07077,1.78111),(-.80132,55.05473,1.83135),(-.81588,55.05036,1.82423),(-.77858,55.05301,1.90622),(-.80218,55.05541,1.94409),(-.80854,55.04569,1.94018),(-1.07913,55.26732,1.86839),(-1.07011,55.26924,1.83674),(-1.08224,55.22,1.82516),(-.99175,55.21924,2.04631),(-1.0271,55.21663,2.04054),(-.74261,55.12806,1.88908),(-.74547,55.13031,1.86126),(-.72871,55.18621,1.85855),(-1.00735,55.05844,1.912),(-.99969,55.05805,1.92738),(-.98904,55.06437,1.92197),(-.9717,55.06462,2.00359),(-.94183,55.11224,1.89279),(-1.04907,55.05661,1.77187),(-1.03997,55.05509,1.87521),(-1.01991,55.06547,1.87817),(-.98459,55.06439,2.04103),(-.83909,55.05747,1.79111),(-.94591,55.10115,1.78858),(-.96982,55.0934,1.75718),(-.76549,55.07573,1.91473),(-.78731,55.08554,1.94957),(-1.05004,55.05656,1.8436),(-1.05234,55.08114,1.74744),(-1.00557,55.06245,1.81989),(-1.00724,55.05222,1.78596),(-.97194,55.1319,1.70948),(-.95301,55.12049,1.70997),(-.94781,55.12153,1.75016),(-.944,55.11705,1.86511),(-.91817,55.11613,1.76543),(-.92114,55.11409,1.70624),(-.91614,55.11369,1.76682),(-.79151,55.08174,1.78279),(-.76234,55.12641,1.78936),(-.83732,55.03636,1.85184),(-.82419,55.03535,1.84746),(-.79029,55.07646,1.75765),(-.73841,55.24299,1.9313),(-.73566,55.18602,1.92547),(-.72643,55.23889,1.89717),(-1.01001,55.04827,2.0217),(-1.03145,55.03366,1.99683),(-1.04384,55.08064,2.00316),(-1.04566,55.25795,2.029),(-1.05122,55.2139,2.02489),(-1.01576,55.26195,2.03677),(-1.05438,55.13093,2.01613),(-1.02644,55.02685,1.99445),(-.73106,55.18607,1.89218),(-.85058,55.05413,1.75669),(-.85578,55.05438,1.73768),(-.76714,55.12505,1.75874),(-.82012,55.0502,1.75749),(-.83605,55.05592,1.70661),(-.91264,55.10697,1.71129),(-1.00608,55.05893,1.77112),(-1.05508,55.0635,1.77671),(-1.01093,55.11017,1.72154),(-1.0212,55.05111,1.8358),(-.84293,55.0413,1.94272),(-.81923,55.02733,1.89838),(-.96405,55.13144,1.70559),(-.83163,55.04641,1.81927),(-1.04196,55.04456,1.89641),(-1.02525,55.05751,1.7675),(-1.08663,55.21296,1.86207),(-.79486,55.03799,1.89879),(-.81471,55.059,1.77964),(-.95132,55.11685,1.87142),(-.94848,55.11563,1.87799),(-.95161,55.1107,1.85376),(-.97654,55.05076,2.01864),(-.98654,55.05266,1.9953),(-1.0883,55.13549,1.83299),(-.92513,55.15992,2.03006),(-.84802,55.26932,1.99695),(-.99785,55.0331,2.01165),(-1.04442,55.02376,1.94324),(-1.0508,55.03187,1.94607),(-.85956,55.04393,1.94163),(-1.01328,55.12599,1.71797),(-1.07432,55.1016,1.77075),(-.92741,55.11439,1.70693),(-.74971,55.18631,1.76357),(-1.04733,55.0541,1.89948),(-.76883,55.23344,1.718),(-.75765,55.2475,1.74379),(-.76894,55.24737,1.72272),(-.723,55.2489,1.86513),(-.72192,55.23461,1.8639),(-.72778,55.25325,1.89773),(-.80688,55.27687,1.97678),(-.80703,55.26265,1.97901),(-.84759,55.28367,1.99503),(-1.0426,55.27205,2.02856),(-1.01703,55.27622,2.03426),(-1.07487,55.28108,1.87005),(-1.06534,55.28281,1.83948),(-.93965,55.27985,1.75046),(-.88074,55.26437,1.71587),(-.9421,55.26652,1.74453),(-.87878,55.27761,1.72248),(-.76462,55.07572,1.89088),(-.8274,55.04987,1.73353),(-.73967,55.18984,1.81894),(-.81476,55.18606,1.67675),(-.8623,55.14167,1.67432),(-.85468,55.19516,1.67753),(-1.07,55.22563,1.78943),(-1.06011,55.27104,1.80519),(-.85945,55.16078,2.00932),(-.80683,55.21408,1.98149),(-.81779,55.15063,1.98502),(-.87536,55.09881,1.68466),(-.91782,55.12136,1.69348),(-.90239,55.152,1.68385),(-.77632,55.17436,1.70426),(-.76841,55.07798,1.86784),(-.74388,55.12783,1.91765),(-.7776,55.14038,1.95778),(-.98566,55.26509,2.03495),(-1.08001,55.2615,1.98536),(-1.08509,55.20115,1.97681),(-1.08767,55.21452,1.91612),(-1.07997,55.12528,1.96948),(-.88848,55.20136,1.68679),(-1.08245,55.13838,1.7847),(-.95632,55.21118,1.71592),(-.96371,55.15725,1.70185),(-.82233,55.06494,1.7002),(-1.06638,55.15452,1.75771),(-1.04747,55.15699,1.74227),(-1.07194,55.08827,1.95535),(-.99494,55.03422,2.0024),(-1.04218,55.22919,1.76813),(-.76508,55.20228,1.96015),(-.73197,55.23913,1.82303),(-1.00316,55.07549,1.75144),(-.84621,55.07053,1.68994),(-.80997,55.24397,1.69818),(-.84647,55.25617,1.70172),(-1.03501,55.2688,1.78415),(-1.00697,55.26472,1.7676),(-1.03182,55.28238,1.78899),(-1.00497,55.27828,1.77322),(-1.07992,55.28226,1.9282),(-1.08395,55.26858,1.92642),(-.98747,55.27935,2.03301),(-.76667,55.26981,1.95472),(-.76684,55.25561,1.95718),(-.73301,55.25339,1.82459),(-.80822,55.25751,1.70463),(-.74436,55.24788,1.7727),(-.7386,55.2575,1.92947),(-.92177,55.28592,2.01176),(-1.07595,55.27523,1.98688),(-1.05589,55.28453,1.80913),(-.84274,55.26904,1.70781)]))),
        Shape(DEF='rmolar3c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rmolar3c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,16,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,29,33,-1,34,35,36,-1,35,37,38,-1,39,40,41,-1,42,40,43,-1,44,45,46,-1,47,48,49,-1,50,36,35,-1,51,52,53,-1,54,55,56,-1,57,54,58,-1,59,60,61,-1,62,45,63,-1,64,65,66,-1,67,68,69,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,84,85,82,-1,86,80,87,-1,88,89,43,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,101,-1,94,104,105,-1,106,107,108,-1,107,66,108,-1,97,96,109,-1,110,111,112,-1,110,113,114,-1,115,38,37,-1,116,117,118,-1,56,119,120,-1,121,61,60,-1,122,49,50,-1,123,124,32,-1,125,126,127,-1,128,129,108,-1,130,131,132,-1,112,133,69,-1,32,30,29,-1,134,135,136,-1,137,138,89,-1,86,139,140,-1,141,142,87,-1,141,87,143,-1,144,145,146,-1,21,147,148,-1,149,147,150,-1,147,114,113,-1,149,145,148,-1,151,145,152,-1,153,20,102,-1,105,104,98,-1,137,154,155,-1,156,157,158,-1,31,159,160,-1,116,118,161,-1,162,163,164,-1,165,166,25,-1,47,167,168,-1,48,169,170,-1,61,121,171,-1,172,173,55,-1,174,175,176,-1,177,5,178,-1,179,180,4,-1,181,11,182,-1,183,140,139,-1,139,155,90,-1,184,185,186,-1,112,68,113,-1,131,187,188,-1,64,52,65,-1,104,94,93,-1,109,96,132,-1,100,98,97,-1,99,101,103,-1,189,190,186,-1,191,192,81,-1,184,77,192,-1,77,76,100,-1,193,194,195,-1,117,91,155,-1,118,154,89,-1,79,81,196,-1,177,197,5,-1,72,187,131,-1,198,74,199,-1,114,70,110,-1,200,201,176,-1,129,202,67,-1,67,203,68,-1,204,198,199,-1,205,206,175,-1,207,208,194,-1,209,121,210,-1,62,128,66,-1,211,136,63,-1,45,212,213,-1,62,212,45,-1,56,55,173,-1,214,53,52,-1,215,34,170,-1,64,216,214,-1,48,50,49,-1,46,51,115,-1,217,218,159,-1,217,41,219,-1,34,220,123,-1,221,33,156,-1,26,222,31,-1,223,224,225,-1,21,20,153,-1,188,71,70,-1,152,144,219,-1,226,17,16,-1,137,226,18,-1,90,155,91,-1,227,125,228,-1,229,14,230,-1,231,232,233,-1,6,234,235,-1,10,9,236,-1,237,161,118,-1,238,239,240,-1,238,58,239,-1,10,241,182,-1,9,242,236,-1,233,12,231,-1,229,222,28,-1,88,237,118,-1,15,17,243,-1,137,18,138,-1,142,141,15,-1,42,152,219,-1,244,149,150,-1,217,219,144,-1,153,70,114,-1,153,188,70,-1,114,21,153,-1,71,187,72,-1,225,245,223,-1,246,24,126,-1,31,30,26,-1,33,29,156,-1,34,221,35,-1,221,34,33,-1,34,215,220,-1,217,230,41,-1,218,160,159,-1,115,44,46,-1,48,36,50,-1,34,36,170,-1,52,64,214,-1,173,119,56,-1,63,158,211,-1,212,62,66,-1,210,172,209,-1,194,181,207,-1,175,178,205,-1,247,248,199,-1,203,113,68,-1,202,203,67,-1,176,249,200,-1,71,188,187,-1,198,72,131,-1,76,78,105,-1,118,117,154,-1,193,195,250,-1,251,242,235,-1,100,192,77,-1,192,185,184,-1,81,140,191,-1,186,252,189,-1,97,101,100,-1,132,153,109,-1,93,75,104,-1,185,192,191,-1,6,8,133,-1,115,37,44,-1,253,139,90,-1,185,254,186,-1,139,253,183,-1,255,256,84,-1,182,207,181,-1,179,239,180,-1,5,257,178,-1,176,258,174,-1,172,55,209,-1,171,259,61,-1,170,36,48,-1,260,47,168,-1,261,165,25,-1,164,262,162,-1,65,52,213,-1,263,31,160,-1,156,158,221,-1,37,158,63,-1,155,243,137,-1,102,109,153,-1,114,147,21,-1,149,146,145,-1,113,150,147,-1,149,148,147,-1,148,22,21,-1,144,152,145,-1,143,103,141,-1,20,19,16,-1,140,81,86,-1,89,154,137,-1,134,136,211,-1,221,158,37,-1,112,69,68,-1,132,75,130,-1,128,108,66,-1,127,228,125,-1,125,264,126,-1,123,220,124,-1,122,265,49,-1,60,210,121,-1,241,173,172,-1,249,206,251,-1,5,4,257,-1,56,120,180,-1,266,138,18,-1,110,112,113,-1,97,109,102,-1,158,157,211,-1,6,133,234,-1,101,97,102,-1,99,192,100,-1,196,143,79,-1,96,98,104,-1,95,258,93,-1,92,253,90,-1,117,155,154,-1,88,118,89,-1,81,80,86,-1,267,254,268,-1,198,130,74,-1,74,130,75,-1,131,130,198,-1,204,111,110,-1,64,66,107,-1,63,136,62,-1,213,46,45,-1,64,107,250,-1,269,59,61,-1,238,57,58,-1,54,56,58,-1,35,38,50,-1,47,49,270,-1,217,159,230,-1,39,41,271,-1,34,123,33,-1,35,221,37,-1,33,123,32,-1,31,263,29,-1,28,222,26,-1,23,126,24,-1,70,72,110,-1,22,19,20,-1,138,266,151,-1,203,202,244,-1,19,266,18,-1,226,16,18,-1,139,243,155,-1,246,272,232,-1,229,12,14,-1,229,31,222,-1,10,236,241,-1,10,182,11,-1,171,273,274,-1,171,275,273,-1,276,0,2,-1,276,277,0,-1,278,279,280,-1,278,281,279,-1,282,283,284,-1,283,282,285,-1,286,287,165,-1,286,288,287,-1,225,289,245,-1,225,290,289,-1,291,292,293,-1,292,291,294,-1,6,242,9,-1,6,235,242,-1,28,12,229,-1,12,28,231,-1,125,233,264,-1,233,125,227,-1,237,39,295,-1,88,39,237,-1,243,226,137,-1,243,17,226,-1,150,203,244,-1,150,113,203,-1,218,149,244,-1,218,146,149,-1,152,138,151,-1,42,138,152,-1,127,223,296,-1,223,127,224,-1,215,124,220,-1,297,124,215,-1,134,218,244,-1,218,134,160,-1,298,2,299,-1,2,298,276,-1,297,170,300,-1,297,215,170,-1,301,195,302,-1,301,216,195,-1,65,212,66,-1,65,213,212,-1,135,62,136,-1,62,135,128,-1,208,172,210,-1,208,207,172,-1,235,303,251,-1,235,234,303,-1,257,205,178,-1,120,205,257,-1,303,247,200,-1,247,303,248,-1,249,175,206,-1,249,176,175,-1,247,74,73,-1,247,199,74,-1,304,305,306,-1,304,307,305,-1,308,268,82,-1,308,267,268,-1,308,85,309,-1,308,82,85,-1,303,249,251,-1,303,200,249,-1,254,191,268,-1,254,185,191,-1,78,184,310,-1,78,77,184,-1,132,104,75,-1,132,96,104,-1,307,311,305,-1,309,311,307,-1,92,84,83,-1,92,255,84,-1,255,312,256,-1,312,255,313,-1,117,164,314,-1,117,116,164,-1,95,189,315,-1,190,189,95,-1,250,106,193,-1,250,107,106,-1,177,175,174,-1,177,178,175,-1,207,241,172,-1,207,182,241,-1,209,54,275,-1,209,55,54,-1,316,59,269,-1,316,317,59,-1,317,318,319,-1,318,317,320,-1,321,322,270,-1,321,299,322,-1,48,260,169,-1,48,47,260,-1,260,261,323,-1,168,261,260,-1,300,246,324,-1,300,325,246,-1,116,262,164,-1,262,116,161,-1,326,262,161,-1,326,296,262,-1,225,23,327,-1,23,225,224,-1,43,39,88,-1,40,39,43,-1,22,145,151,-1,22,148,145,-1,134,263,160,-1,134,157,263,-1,211,157,134,-1,133,111,248,-1,133,112,111,-1,230,271,41,-1,230,14,271,-1,162,296,223,-1,262,296,162,-1,323,169,260,-1,169,323,325,-1,230,31,229,-1,31,230,159,-1,270,265,321,-1,265,270,49,-1,316,320,317,-1,320,316,298,-1,301,317,319,-1,59,317,301,-1,8,328,329,-1,8,7,328,-1,251,205,330,-1,206,205,251,-1,315,331,197,-1,331,315,189,-1,163,314,164,-1,314,163,332,-1,293,312,332,-1,293,292,312,-1,256,292,285,-1,292,256,312,-1,309,333,308,-1,309,307,333,-1,29,157,156,-1,263,157,29,-1,93,73,75,-1,93,201,73,-1,201,258,176,-1,93,258,201,-1,334,309,85,-1,311,309,334,-1,335,306,305,-1,280,306,335,-1,103,196,99,-1,103,143,196,-1,82,183,83,-1,82,268,183,-1,76,98,100,-1,105,98,76,-1,239,56,180,-1,58,56,239,-1,241,119,173,-1,241,330,119,-1,241,236,330,-1,59,302,60,-1,59,301,302,-1,4,279,179,-1,4,3,279,-1,298,321,320,-1,299,321,298,-1,244,135,134,-1,244,202,135,-1,295,271,336,-1,295,39,271,-1,30,124,26,-1,30,32,124,-1,27,231,28,-1,231,27,324,-1,264,246,126,-1,264,272,246,-1,228,296,326,-1,296,228,127,-1,151,19,22,-1,266,19,151,-1,144,218,217,-1,218,144,146,-1,139,15,243,-1,139,142,15,-1,6,11,7,-1,6,9,11,-1,285,294,283,-1,285,292,294,-1,289,337,245,-1,289,338,337,-1,339,165,287,-1,166,165,339,-1,1,340,2,-1,340,1,341,-1,335,278,280,-1,335,342,278,-1,343,276,344,-1,343,277,276,-1,345,171,274,-1,259,171,345,-1,346,275,54,-1,346,273,275,-1,347,344,348,-1,344,347,343,-1,179,281,349,-1,179,279,281,-1,284,350,282,-1,350,284,351,-1,352,288,286,-1,353,288,352,-1,327,290,225,-1,327,354,290,-1,355,293,356,-1,355,291,293,-1,248,234,133,-1,248,303,234,-1,12,227,13,-1,12,233,227,-1,25,327,23,-1,327,25,166,-1,41,42,219,-1,40,42,41,-1,270,167,47,-1,167,270,322,-1,318,122,53,-1,265,122,318,-1,297,324,27,-1,297,300,324,-1,348,61,259,-1,348,269,61,-1,250,216,64,-1,216,250,195,-1,63,44,37,-1,63,45,44,-1,329,193,106,-1,193,329,328,-1,180,257,4,-1,180,120,257,-1,69,106,108,-1,106,69,329,-1,110,198,204,-1,110,72,198,-1,99,81,192,-1,99,196,81,-1,85,256,334,-1,85,84,256,-1,86,142,139,-1,86,87,142,-1,252,331,189,-1,333,331,252,-1,307,331,333,-1,304,331,307,-1,92,183,253,-1,92,83,183,-1,94,190,95,-1,94,310,190,-1,87,79,143,-1,79,87,80,-1,131,153,132,-1,188,153,131,-1,350,305,311,-1,350,335,305,-1,313,92,91,-1,255,92,313,-1,314,91,117,-1,313,91,314,-1,5,306,3,-1,306,5,304,-1,330,120,119,-1,205,120,330,-1,208,60,302,-1,208,210,60,-1,269,344,316,-1,348,344,269,-1,319,53,214,-1,53,319,318,-1,299,340,322,-1,299,2,340,-1,27,124,297,-1,124,27,26,-1,168,165,261,-1,286,165,168,-1,24,325,323,-1,325,24,246,-1,295,161,237,-1,295,326,161,-1,126,224,127,-1,126,23,224,-1,138,43,89,-1,138,42,43,-1,16,141,20,-1,141,16,15,-1,141,102,20,-1,103,102,141,-1,223,337,162,-1,223,245,337,-1,13,228,336,-1,13,227,228,-1,356,162,337,-1,356,163,162,-1,323,25,24,-1,323,261,25,-1,167,286,168,-1,167,352,286,-1,300,169,325,-1,170,169,300,-1,316,276,298,-1,316,344,276,-1,319,216,301,-1,216,319,214,-1,302,194,208,-1,302,195,194,-1,304,197,331,-1,304,5,197,-1,356,332,163,-1,332,356,293,-1,313,332,312,-1,332,313,314,-1,334,285,282,-1,334,256,285,-1,254,252,186,-1,254,267,252,-1,3,280,279,-1,306,280,3,-1,202,128,135,-1,129,128,202,-1,105,310,94,-1,105,78,310,-1,258,315,174,-1,258,95,315,-1,310,186,190,-1,310,184,186,-1,11,328,7,-1,11,181,328,-1,311,282,350,-1,311,334,282,-1,252,308,333,-1,308,252,267,-1,140,268,191,-1,268,140,183,-1,197,174,315,-1,177,174,197,-1,200,73,201,-1,200,247,73,-1,67,108,129,-1,108,67,69,-1,330,242,251,-1,236,242,330,-1,181,193,328,-1,194,193,181,-1,275,121,209,-1,171,121,275,-1,50,115,122,-1,115,50,38,-1,336,14,13,-1,14,336,271,-1,320,265,318,-1,321,265,320,-1,322,352,167,-1,352,322,340,-1,122,51,53,-1,122,115,51,-1,326,336,228,-1,326,295,336,-1,232,324,246,-1,232,231,324,-1,51,213,52,-1,51,46,213,-1,232,264,233,-1,264,232,272,-1,69,8,329,-1,69,133,8,-1,204,248,111,-1,204,199,248,-1,54,357,346,-1,57,357,54,-1,337,355,356,-1,337,338,355,-1,354,166,339,-1,327,166,354,-1,340,353,352,-1,340,341,353,-1,351,335,350,-1,335,351,342,-1,349,239,179,-1,239,349,240,-1,259,347,348,-1,259,345,347,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmolar3c_Coord',point=[(-.97709,55.3635,1.50374),(-.97521,55.36339,1.50359),(-.9768,55.34945,1.49925),(-1.12375,55.29022,1.68162),(-1.14191,55.29329,1.6653),(-1.12339,55.22687,1.68837),(-1.08514,55.12952,1.57172),(-1.0863,55.12842,1.56574),(-1.08386,55.1252,1.56629),(-1.09136,55.1485,1.57354),(-1.11363,55.20249,1.57823),(-1.09433,55.14798,1.56504),(-.85225,55.11892,1.50795),(-.84951,55.11132,1.51692),(-.86918,55.0959,1.52164),(-.952,55.12494,1.63994),(-.94179,55.12275,1.62951),(-.93439,55.1154,1.64089),(-.911,55.09841,1.63209),(-.94229,55.12485,1.62005),(-.98108,55.15104,1.61146),(-.99991,55.17641,1.57557),(-.96412,55.13837,1.581),(-.79836,55.25368,1.49611),(-.81656,55.19229,1.47719),(-.80725,55.26366,1.48128),(-.87789,55.11289,1.48859),(-.8728,55.1122,1.4845),(-.87352,55.10461,1.50656),(-.91763,55.1525,1.49038),(-.89455,55.1186,1.49397),(-.89261,55.10617,1.51358),(-.89551,55.12971,1.47732),(-.91789,55.15641,1.47093),(-.93103,55.1526,1.4573),(-.93757,55.15577,1.45688),(-.93109,55.15984,1.45122),(-.95672,55.19322,1.49849),(-.96153,55.15649,1.45418),(-.86198,55.0782,1.54908),(-.87655,55.07453,1.55529),(-.87876,55.08058,1.5334),(-.88837,55.07236,1.56217),(-.87311,55.07364,1.57013),(-1.00117,55.16642,1.46357),(-1.01974,55.17175,1.48723),(-1.02176,55.15606,1.47191),(-.91279,55.23372,1.44494),(-.93055,55.17853,1.44694),(-.96153,55.18651,1.4507),(-.96079,55.16809,1.45148),(-1.01712,55.15648,1.4628),(-1.04264,55.13992,1.46672),(-1.02574,55.16414,1.46195),(-1.13056,55.35082,1.60649),(-1.13683,55.30955,1.60318),(-1.1436,55.29917,1.62038),(-1.13038,55.35765,1.61426),(-1.13458,55.34816,1.63359),(-1.08785,55.25412,1.49264),(-1.10321,55.25954,1.51472),(-1.10141,55.32647,1.53304),(-1.02268,55.15655,1.49106),(-.96572,55.19417,1.50574),(-1.06395,55.1309,1.4765),(-1.04726,55.13253,1.47664),(-1.05481,55.12022,1.49411),(-1.0446,55.13137,1.55086),(-1.05374,55.13829,1.56316),(-1.07059,55.11866,1.54894),(-1.00219,55.17233,1.5848),(-.99796,55.16681,1.59313),(-1.03093,55.15456,1.60535),(-1.0758,55.09084,1.62859),(-1.07034,55.09893,1.62565),(-1.07144,55.08256,1.65196),(-1.04925,55.11558,1.69775),(-1.05181,55.11563,1.71238),(-1.05784,55.10715,1.70228),(-.98374,55.12922,1.68648),(-.97289,55.12867,1.68254),(-.98521,55.12729,1.69512),(-1.01082,55.15785,1.71715),(-.98316,55.16326,1.70719),(-.98122,55.21896,1.71185),(-1.01103,55.22129,1.71803),(-.96351,55.12842,1.68329),(-.9716,55.13509,1.6653),(-.85616,55.07688,1.57807),(-.86529,55.08332,1.61957),(-.93956,55.1287,1.68511),(-.9057,55.14215,1.68108),(-.96241,55.16732,1.69976),(-1.08607,55.07858,1.65681),(-1.07576,55.0885,1.68589),(-1.09072,55.0932,1.69188),(-1.02958,55.11018,1.6605),(-1.02248,55.12811,1.67678),(-1.04522,55.11285,1.68801),(-1.00104,55.12943,1.68034),(-1.03772,55.12439,1.69756),(-1.0116,55.133,1.68064),(-.97959,55.14774,1.6312),(-.97783,55.14563,1.6369),(-1.05988,55.09632,1.67692),(-1.05524,55.10491,1.68921),(-1.07269,55.10609,1.5173),(-1.06659,55.116,1.49202),(-1.06198,55.10854,1.51809),(-.98113,55.14768,1.62391),(-1.0358,55.15588,1.5885),(-1.05833,55.1332,1.59042),(-1.05915,55.14029,1.57924),(-1.00662,55.17876,1.571),(-1.00642,55.17786,1.57647),(-.98998,55.16875,1.45507),(-.83931,55.10421,1.62091),(-.86929,55.11478,1.65546),(-.85109,55.08769,1.61656),(-1.13125,55.2388,1.61099),(-1.13921,55.22422,1.63648),(-1.1157,55.32568,1.55578),(-.99079,55.17644,1.45366),(-.91339,55.14732,1.46752),(-.87841,55.12515,1.46725),(-.82308,55.14482,1.51294),(-.81265,55.17885,1.50176),(-.80398,55.17435,1.52392),(-1.02671,55.14475,1.50435),(-1.03277,55.12698,1.52438),(-1.05825,55.09936,1.6303),(-1.04494,55.1094,1.62504),(-1.03667,55.09838,1.64052),(-1.07821,55.13075,1.57311),(-.97177,55.17576,1.51818),(-.98012,55.1747,1.51797),(-.96863,55.18725,1.50986),(-.90625,55.08999,1.64693),(-.88168,55.08386,1.61963),(-.95819,55.1247,1.68229),(-.98616,55.12604,1.70073),(-.97825,55.14721,1.62223),(-.96815,55.13348,1.66084),(-.97553,55.14286,1.64433),(-.92838,55.10201,1.55805),(-.93983,55.10905,1.56605),(-.94077,55.1103,1.55564),(-.99974,55.18007,1.57193),(-.96794,55.14015,1.57334),(-.97246,55.14305,1.5647),(-1.00076,55.1776,1.56935),(-.93735,55.10723,1.57295),(-.92925,55.09942,1.5652),(-.9865,55.15182,1.61577),(-.88687,55.09991,1.65328),(-.91846,55.11662,1.67534),(-.94553,55.18889,1.50214),(-.94494,55.18644,1.50786),(-.95326,55.19366,1.50479),(-.89346,55.09575,1.5191),(-.92858,55.13075,1.51605),(-.82827,55.09882,1.58861),(-.7804,55.23921,1.5778),(-.796,55.23562,1.61931),(-.81494,55.18171,1.62367),(-.82005,55.32721,1.48679),(-.81089,55.32197,1.49348),(-.90958,55.28798,1.46388),(-.8601,55.28165,1.45546),(-.86937,55.15812,1.44198),(-.8826,55.14046,1.44385),(-1.10916,55.36676,1.56273),(-1.11925,55.25889,1.56287),(-1.12549,55.25334,1.58467),(-1.11812,55.10657,1.67266),(-1.12119,55.11848,1.65038),(-1.10792,55.10109,1.64109),(-1.12249,55.16936,1.68193),(-1.12868,55.17155,1.65626),(-1.13457,55.34314,1.66011),(-1.14674,55.28997,1.64361),(-1.09691,55.14817,1.54937),(-1.11498,55.20159,1.56613),(-.98477,55.13584,1.70386),(-1.0538,55.11455,1.71782),(-1.03382,55.11857,1.71697),(-1.06432,55.1172,1.72383),(-1.02319,55.14192,1.60881),(-.99398,55.16161,1.60098),(-1.08259,55.11305,1.7155),(-1.07499,55.10597,1.71079),(-1.0173,55.12698,1.71457),(-1.02977,55.12415,1.70597),(-1.09021,55.13084,1.52286),(-1.09642,55.1499,1.52493),(-1.09006,55.15029,1.50005),(-.99166,55.12918,1.68107),(-1.11228,55.16569,1.69562),(-1.0514,55.12657,1.61616),(-1.07333,55.11081,1.6055),(-1.09024,55.09819,1.61093),(-1.08767,55.08631,1.63276),(-.99371,55.15985,1.5276),(-1.00576,55.17098,1.55273),(-1.05751,55.12611,1.6016),(-1.13082,55.17487,1.63511),(-1.11895,55.13519,1.63008),(-1.11472,55.20133,1.55423),(-1.10842,55.20117,1.53115),(-1.12628,55.31762,1.57947),(-1.11282,55.26396,1.54047),(-.95621,55.19307,1.5107),(-1.03681,55.14598,1.48757),(-1.03938,55.14387,1.47964),(-1.06061,55.15182,1.47099),(-.8895,55.13481,1.44825),(-1.07475,55.15356,1.47864),(-.89376,55.08512,1.52944),(-.93786,55.11831,1.52331),(-.89113,55.0773,1.54199),(-.89721,55.1368,1.45528),(-.94855,55.1888,1.49659),(-.87543,55.10576,1.50795),(-.78178,55.24901,1.54787),(-.79098,55.2523,1.51967),(-.79566,55.30639,1.51923),(-.92005,55.10126,1.64034),(-.83315,55.12771,1.51473),(-.82985,55.12008,1.52412),(-.87457,55.10328,1.5147),(-.88075,55.09403,1.51971),(-.85171,55.11887,1.4975),(-.83559,55.13854,1.49426),(-.83645,55.13534,1.50536),(-1.08565,55.12429,1.57695),(-1.08792,55.12898,1.57698),(-1.11779,55.19615,1.59156),(-.84482,55.08432,1.58207),(-1.13091,55.35563,1.62841),(-1.13483,55.34771,1.6364),(-1.12978,55.36209,1.63433),(-1.11688,55.22018,1.58077),(-1.09541,55.14321,1.58132),(-.93224,55.10734,1.66457),(-.9873,55.16017,1.52733),(-.78956,55.29784,1.55156),(-.83639,55.14652,1.47509),(-1.08114,55.10325,1.60743),(-1.07957,55.11643,1.59022),(-1.10509,55.11629,1.62035),(-1.08019,55.13054,1.49872),(-1.1029,55.13113,1.60041),(-1.0669,55.12868,1.72395),(-.95868,55.13534,1.68963),(-1.04264,55.13157,1.72658),(-.96855,55.21794,1.70706),(-.97735,55.27685,1.70466),(-1.13576,55.2253,1.66024),(-1.10291,55.0911,1.66515),(-1.09719,55.36121,1.54683),(-.86233,55.22655,1.44318),(-.81859,55.27351,1.46821),(-.798,55.17108,1.58554),(-.91737,55.14858,1.50985),(-.82394,55.15658,1.50313),(-.99233,55.19384,1.45566),(-.91994,55.10284,1.61533),(-1.04394,55.13715,1.72705),(-1.0124,55.13714,1.71651),(-1.08138,55.32626,1.51398),(-.95191,55.23833,1.45724),(-.86379,55.08853,1.52858),(-.82837,55.153,1.49315),(-1.11727,55.37265,1.58901),(-1.1056,55.3811,1.56587),(-1.11973,55.35954,1.58247),(-1.01133,55.35094,1.50311),(-1.01107,55.36509,1.50689),(-1.10468,55.34281,1.6859),(-1.12388,55.33539,1.67428),(-1.10961,55.32892,1.68606),(-1.11728,55.34851,1.67594),(-1.02322,55.31545,1.70372),(-.98144,55.32558,1.69222),(-1.02417,55.32955,1.70109),(-.981,55.3116,1.69513),(-.86055,55.33403,1.46947),(-.81975,55.34111,1.49242),(-.85959,55.34844,1.47415),(-.79216,55.31226,1.55308),(-.797,55.3203,1.5247),(-.83297,55.31336,1.65064),(-.90338,55.3062,1.68071),(-.83274,55.29901,1.65253),(-.90206,55.32023,1.67755),(-.84279,55.08934,1.54965),(-.79534,55.16985,1.54609),(-.86821,55.12378,1.45907),(-1.00936,55.3064,1.48585),(-.97584,55.30225,1.47874),(-.86077,55.13053,1.4552),(-1.08936,55.19202,1.48497),(-1.10201,55.19572,1.50675),(-1.08758,55.11328,1.59127),(-1.09856,55.22558,1.70889),(-1.08197,55.28125,1.7065),(-1.10833,55.2863,1.6923),(-1.07797,55.225,1.71841),(-1.04735,55.15126,1.7268),(-1.05464,55.22373,1.72289),(-1.06304,55.10356,1.7062),(-1.0526,55.27539,1.71671),(-.90999,55.26853,1.68983),(-.90936,55.21133,1.68903),(-.8524,55.19985,1.66424),(-1.10141,55.10214,1.69514),(-1.04286,55.31053,1.49306),(-1.04755,55.25056,1.47382),(-1.02201,55.18909,1.46134),(-1.05135,55.18438,1.46821),(-1.01883,55.24991,1.47023),(-.99025,55.24929,1.46675),(-.94272,55.29512,1.47126),(-.82471,55.20659,1.45563),(-.85479,55.12391,1.47935),(-.84469,55.15221,1.45374),(-.82631,55.10407,1.5518),(-.80418,55.31604,1.50406),(-1.09058,55.12855,1.54734),(-1.07912,55.11108,1.54256),(-1.12366,55.18827,1.60783),(-1.09576,55.16108,1.71096),(-.83538,55.25009,1.65626),(-1.07332,55.15665,1.72387),(-1.01708,55.27649,1.71059),(-1.08307,55.32408,1.70109),(-.84616,55.10297,1.52519),(-.78585,55.30069,1.58319),(-.78791,55.31516,1.58386),(-.80969,55.33515,1.50094),(-.94137,55.34844,1.48911),(-.94043,55.36245,1.49414),(-1.07938,55.33816,1.69984),(-1.0456,55.36628,1.51202),(-1.04716,55.35209,1.50934),(-1.09203,55.37483,1.54646),(-1.12517,55.36622,1.6066),(-1.0794,55.36919,1.52904),(-1.08293,55.35497,1.52737),(-1.12824,55.3569,1.66331),(-1.0537,55.31856,1.71246),(-1.05376,55.33279,1.70979),(-.906,55.34253,1.47895),(-.90515,55.35656,1.48396),(-.80371,55.32892,1.51177),(-.79658,55.31189,1.62192),(-.79498,55.29742,1.62217),(-1.12584,55.36507,1.60755)]))),
        Shape(DEF='rpreol1c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rpreol1c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,4,-1,11,12,13,-1,14,11,15,-1,16,17,18,-1,19,20,13,-1,21,22,23,-1,24,25,26,-1,27,21,23,-1,28,29,30,-1,31,22,26,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,5,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,9,52,10,-1,53,54,55,-1,56,40,39,-1,57,58,49,-1,59,60,61,-1,54,62,55,-1,63,64,65,-1,66,67,68,-1,11,5,4,-1,69,19,13,-1,70,71,72,-1,73,74,33,-1,75,21,76,-1,50,77,48,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,76,27,30,-1,22,31,87,-1,19,18,17,-1,87,88,89,-1,90,91,92,-1,93,94,25,-1,93,45,94,-1,95,96,97,-1,98,0,99,-1,100,101,102,-1,103,65,104,-1,105,36,35,-1,106,107,108,-1,109,110,111,-1,61,60,47,-1,31,25,112,-1,113,114,115,-1,91,40,56,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,127,-1,14,15,128,-1,89,129,130,-1,94,44,112,-1,131,132,133,-1,134,88,43,-1,41,14,128,-1,18,19,69,-1,10,11,4,-1,135,136,137,-1,105,138,139,-1,41,43,45,-1,137,140,135,-1,10,12,11,-1,15,20,134,-1,41,128,43,-1,128,134,43,-1,131,133,141,-1,112,25,94,-1,142,74,73,-1,119,72,143,-1,101,125,127,-1,144,121,120,-1,145,146,147,-1,70,119,121,-1,38,118,39,-1,118,115,116,-1,91,90,40,-1,114,148,115,-1,41,45,42,-1,46,149,150,-1,61,47,29,-1,109,111,151,-1,106,108,152,-1,143,73,153,-1,35,138,105,-1,103,63,65,-1,98,99,154,-1,70,124,37,-1,95,97,155,-1,156,3,42,-1,157,93,25,-1,90,92,158,-1,41,5,14,-1,87,23,22,-1,76,30,159,-1,33,74,160,-1,84,86,161,-1,83,162,81,-1,79,163,80,-1,77,149,48,-1,34,33,160,-1,21,27,76,-1,73,33,153,-1,134,17,89,-1,119,70,72,-1,89,88,134,-1,70,121,124,-1,164,165,166,-1,167,168,169,-1,168,137,169,-1,66,68,170,-1,123,122,171,-1,70,147,71,-1,147,70,37,-1,139,138,172,-1,63,173,64,-1,138,35,123,-1,143,125,73,-1,61,174,59,-1,49,51,57,-1,39,175,56,-1,53,55,176,-1,53,177,54,-1,52,178,10,-1,50,48,51,-1,46,48,149,-1,31,26,25,-1,44,94,45,-1,42,3,5,-1,179,72,71,-1,101,127,102,-1,142,73,100,-1,179,146,104,-1,180,176,55,-1,44,43,88,-1,28,30,129,-1,130,27,23,-1,44,88,112,-1,26,181,24,-1,134,128,15,-1,16,182,17,-1,14,5,11,-1,9,4,183,-1,6,8,184,-1,65,142,104,-1,0,98,1,-1,85,185,141,-1,85,186,185,-1,187,188,189,-1,188,187,190,-1,191,192,193,-1,191,194,192,-1,195,196,197,-1,195,198,196,-1,99,199,200,-1,99,0,199,-1,201,163,79,-1,163,201,202,-1,84,186,85,-1,84,203,186,-1,204,139,205,-1,204,105,139,-1,155,206,95,-1,207,206,155,-1,208,66,170,-1,208,193,66,-1,209,210,211,-1,210,209,212,-1,69,12,213,-1,13,12,69,-1,214,133,132,-1,214,215,133,-1,47,76,159,-1,46,76,47,-1,153,54,143,-1,153,62,54,-1,55,32,174,-1,55,62,32,-1,104,127,179,-1,104,102,127,-1,216,99,217,-1,216,154,99,-1,218,219,220,-1,218,103,219,-1,35,124,123,-1,35,37,124,-1,56,180,91,-1,180,56,176,-1,53,117,177,-1,117,53,175,-1,107,148,114,-1,107,221,148,-1,52,222,178,-1,223,222,52,-1,61,28,224,-1,61,29,28,-1,109,81,225,-1,109,151,81,-1,110,226,80,-1,110,109,226,-1,165,156,166,-1,165,3,156,-1,106,227,207,-1,106,152,227,-1,143,120,119,-1,143,228,120,-1,221,171,148,-1,229,171,221,-1,219,145,204,-1,219,146,145,-1,230,231,232,-1,230,233,231,-1,234,235,236,-1,235,234,216,-1,237,103,218,-1,237,63,103,-1,98,238,239,-1,98,154,238,-1,96,233,97,-1,96,231,233,-1,240,138,229,-1,240,172,138,-1,241,96,95,-1,241,242,96,-1,243,227,210,-1,243,244,227,-1,191,136,135,-1,136,191,245,-1,165,8,183,-1,8,165,164,-1,184,164,246,-1,184,8,164,-1,247,167,246,-1,248,167,247,-1,189,249,250,-1,189,251,249,-1,156,45,93,-1,156,42,45,-1,214,252,253,-1,252,214,254,-1,91,255,92,-1,255,91,180,-1,30,130,129,-1,30,27,130,-1,24,157,25,-1,256,157,24,-1,157,257,93,-1,257,157,258,-1,85,133,86,-1,141,133,85,-1,83,259,77,-1,260,259,83,-1,173,237,261,-1,63,237,173,-1,111,262,151,-1,161,262,111,-1,263,264,265,-1,263,261,264,-1,78,236,235,-1,266,236,78,-1,265,266,226,-1,264,266,265,-1,82,151,262,-1,82,81,151,-1,162,77,50,-1,83,77,162,-1,215,86,133,-1,215,267,86,-1,260,256,259,-1,268,256,260,-1,150,77,259,-1,77,150,149,-1,33,62,153,-1,33,32,62,-1,257,253,252,-1,257,258,253,-1,257,247,166,-1,252,247,257,-1,168,248,251,-1,168,167,248,-1,90,222,269,-1,90,158,222,-1,246,169,184,-1,246,167,169,-1,9,209,52,-1,9,7,209,-1,7,212,209,-1,212,7,6,-1,244,68,206,-1,170,68,244,-1,241,197,242,-1,195,197,241,-1,97,172,240,-1,97,233,172,-1,220,204,205,-1,220,219,204,-1,236,270,234,-1,236,271,270,-1,139,233,230,-1,139,172,233,-1,57,173,58,-1,173,57,64,-1,269,223,108,-1,223,269,222,-1,143,126,125,-1,143,72,126,-1,174,224,55,-1,61,224,174,-1,49,263,272,-1,49,58,263,-1,244,207,227,-1,206,207,244,-1,183,3,165,-1,183,4,3,-1,225,226,109,-1,225,265,226,-1,162,225,81,-1,272,225,162,-1,224,182,255,-1,224,28,182,-1,47,51,48,-1,47,60,51,-1,106,221,107,-1,106,273,221,-1,177,116,228,-1,116,177,117,-1,146,71,147,-1,146,179,71,-1,103,146,219,-1,103,104,146,-1,234,154,216,-1,234,238,154,-1,100,104,142,-1,104,100,102,-1,34,274,59,-1,274,34,160,-1,228,54,177,-1,228,143,54,-1,159,29,47,-1,29,159,30,-1,181,76,46,-1,76,181,75,-1,268,157,256,-1,258,157,268,-1,16,69,213,-1,16,18,69,-1,6,169,275,-1,6,184,169,-1,211,52,209,-1,211,223,52,-1,193,245,191,-1,193,208,245,-1,68,95,206,-1,68,241,95,-1,204,36,105,-1,204,145,36,-1,1,239,232,-1,98,239,1,-1,203,276,277,-1,84,276,203,-1,278,201,79,-1,278,279,201,-1,280,0,2,-1,0,280,199,-1,198,67,281,-1,195,67,198,-1,135,194,191,-1,135,282,194,-1,189,283,187,-1,189,250,283,-1,141,284,131,-1,141,185,284,-1,188,285,140,-1,188,190,285,-1,286,193,192,-1,66,193,286,-1,287,197,196,-1,288,197,287,-1,217,200,289,-1,217,99,200,-1,290,163,202,-1,291,163,290,-1,230,205,139,-1,292,205,230,-1,207,273,106,-1,207,155,273,-1,243,170,244,-1,243,208,170,-1,243,212,293,-1,243,210,212,-1,183,7,9,-1,7,183,8,-1,253,215,214,-1,253,294,215,-1,26,75,181,-1,26,21,75,-1,21,26,22,-1,130,87,89,-1,130,23,87,-1,259,24,150,-1,259,256,24,-1,87,112,88,-1,31,112,87,-1,174,34,59,-1,174,32,34,-1,127,72,179,-1,72,127,126,-1,295,218,220,-1,270,218,295,-1,122,116,115,-1,116,122,144,-1,158,178,222,-1,158,213,178,-1,92,213,158,-1,92,16,213,-1,291,80,163,-1,291,110,80,-1,166,93,257,-1,166,156,93,-1,175,176,56,-1,175,53,176,-1,269,113,90,-1,114,113,269,-1,60,57,51,-1,60,59,57,-1,255,55,224,-1,255,180,55,-1,123,229,138,-1,229,123,171,-1,296,232,231,-1,1,232,296,-1,216,278,235,-1,278,216,217,-1,218,271,237,-1,271,218,270,-1,220,292,295,-1,205,292,220,-1,197,296,242,-1,197,288,296,-1,273,229,221,-1,273,240,229,-1,152,210,227,-1,211,210,152,-1,293,136,245,-1,275,136,293,-1,140,168,188,-1,168,140,137,-1,213,10,178,-1,213,12,10,-1,246,166,247,-1,246,164,166,-1,248,249,251,-1,249,248,254,-1,132,254,214,-1,254,132,249,-1,144,228,116,-1,228,144,120,-1,73,101,100,-1,125,101,73,-1,59,64,57,-1,59,274,64,-1,297,268,260,-1,268,297,294,-1,262,297,82,-1,262,267,297,-1,261,271,264,-1,271,261,237,-1,276,161,111,-1,84,161,276,-1,236,264,271,-1,264,236,266,-1,235,79,78,-1,79,235,278,-1,80,266,78,-1,80,226,266,-1,82,260,83,-1,260,82,297,-1,58,261,263,-1,58,173,261,-1,86,262,161,-1,86,267,262,-1,267,294,297,-1,294,267,215,-1,274,65,64,-1,274,142,65,-1,249,131,250,-1,249,132,131,-1,248,252,254,-1,248,247,252,-1,251,188,168,-1,189,188,251,-1,122,148,171,-1,122,115,148,-1,293,6,275,-1,293,212,6,-1,211,108,223,-1,211,152,108,-1,155,240,273,-1,155,97,240,-1,231,242,296,-1,242,231,96,-1,295,239,238,-1,292,239,295,-1,288,1,296,-1,2,1,288,-1,28,17,182,-1,129,17,28,-1,129,89,17,-1,114,108,107,-1,114,269,108,-1,272,265,225,-1,272,263,265,-1,276,110,291,-1,110,276,111,-1,272,50,49,-1,272,162,50,-1,255,16,92,-1,255,182,16,-1,117,39,118,-1,117,175,39,-1,38,115,118,-1,113,115,38,-1,90,38,40,-1,113,38,90,-1,124,144,122,-1,144,124,121,-1,234,295,238,-1,234,270,295,-1,274,74,142,-1,274,160,74,-1,150,181,46,-1,150,24,181,-1,294,258,268,-1,253,258,294,-1,17,20,19,-1,17,134,20,-1,11,20,15,-1,13,20,11,-1,137,275,169,-1,136,275,137,-1,243,245,208,-1,243,293,245,-1,68,195,241,-1,68,67,195,-1,145,37,36,-1,145,147,37,-1,232,292,230,-1,239,292,232,-1,291,277,276,-1,291,290,277,-1,289,278,217,-1,278,289,279,-1,288,280,2,-1,288,287,280,-1,66,281,67,-1,66,286,281,-1,140,282,135,-1,140,285,282,-1,284,250,131,-1,250,284,283,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpreol1c_Coord',point=[(-.73252,55.24903,2.65224),(-.77485,55.22419,2.67612),(-.76919,55.24425,2.68682),(-.694,54.99978,2.87687),(-.70705,54.97148,2.86722),(-.69142,54.98777,2.86944),(-.76488,55.07336,2.86031),(-.75371,55.02818,2.85425),(-.73251,55.03567,2.87351),(-.73068,54.9732,2.85103),(-.7215,54.95811,2.83955),(-.69819,54.96458,2.84914),(-.7129,54.95548,2.82398),(-.6903,54.96859,2.79845),(-.66724,54.99754,2.8453),(-.66479,54.9948,2.82271),(-.69454,54.95887,2.75813),(-.64764,55.01034,2.75142),(-.68424,54.97214,2.77322),(-.67947,54.98194,2.78247),(-.67477,54.98376,2.79216),(-.6082,54.98434,2.75616),(-.59928,55.0031,2.78339),(-.63728,55.01021,2.75024),(-.57258,54.99098,2.77427),(-.58741,55.00758,2.79722),(-.59298,55.00463,2.78895),(-.60784,54.98263,2.74311),(-.65436,55.00091,2.73042),(-.60687,54.95936,2.72093),(-.6134,54.96985,2.73241),(-.59246,55.01189,2.79161),(-.63923,54.97514,2.66418),(-.64129,54.98279,2.65686),(-.62492,54.96608,2.65812),(-.80096,55.02083,2.64613),(-.77731,55.02569,2.63487),(-.77138,55.02609,2.64133),(-.7641,54.95533,2.71527),(-.75458,54.96526,2.71121),(-.75829,54.95515,2.71885),(-.65511,55.00529,2.84833),(-.65412,55.00932,2.85415),(-.64304,55.00535,2.84093),(-.61988,55.00578,2.82159),(-.64124,55.00577,2.84509),(-.57295,54.9515,2.73898),(-.58278,54.944,2.71536),(-.56389,54.95372,2.70901),(-.55586,54.96365,2.68071),(-.54986,54.96845,2.70349),(-.57325,54.95052,2.68412),(-.7547,54.95501,2.82052),(-.68696,55.02777,2.68462),(-.68668,55.03685,2.67256),(-.67508,55.01142,2.69447),(-.72218,54.98307,2.69602),(-.58763,54.95506,2.65473),(-.57231,54.97208,2.65008),(-.60393,54.94776,2.66567),(-.59244,54.94216,2.69074),(-.61853,54.95082,2.69853),(-.68273,55.03565,2.67112),(-.62965,55.01504,2.5905),(-.60316,54.967,2.62923),(-.64107,54.99988,2.60175),(-.79914,55.25655,2.83011),(-.80968,55.25609,2.81572),(-.8206,55.21284,2.80246),(-.69755,54.96378,2.7877),(-.74955,55.03207,2.64622),(-.73866,55.03045,2.6399),(-.69083,55.04583,2.6631),(-.68376,55.04224,2.66182),(-.64577,54.98258,2.64768),(-.59642,54.97619,2.7537),(-.59217,54.96486,2.74303),(-.54388,54.97325,2.7263),(-.54329,55.21285,2.62482),(-.54802,55.26417,2.63388),(-.5262,55.20965,2.64386),(-.50397,55.08645,2.69411),(-.50454,55.09079,2.72256),(-.52082,55.01745,2.71857),(-.5164,55.25383,2.72837),(-.52394,55.24543,2.767),(-.51896,55.2068,2.77173),(-.63771,55.01126,2.75367),(-.64128,55.01059,2.75648),(-.64317,55.01127,2.74835),(-.76843,54.93597,2.7429),(-.71888,54.96431,2.71006),(-.71068,54.94824,2.7319),(-.60795,55.0237,2.83997),(-.61835,55.00827,2.82679),(-.83308,55.13853,2.77114),(-.83717,55.14348,2.73954),(-.84107,55.08246,2.72737),(-.73286,55.22915,2.64441),(-.69259,55.25848,2.63087),(-.67132,55.0258,2.61196),(-.67646,55.03757,2.6099),(-.67847,55.03478,2.6007),(-.67916,55.03683,2.59339),(-.67897,55.0342,2.59761),(-.78358,55.03621,2.6334),(-.81566,55.00391,2.76751),(-.80186,54.96582,2.74902),(-.79317,54.95346,2.76915),(-.50392,55.14423,2.66391),(-.51144,55.21053,2.67229),(-.50164,55.2157,2.70019),(-.59927,55.01033,2.79926),(-.77842,54.94327,2.72382),(-.79275,54.94999,2.73494),(-.7866,54.96195,2.70851),(-.73099,55.00151,2.6773),(-.72561,54.99314,2.68702),(-.76109,54.96373,2.70787),(-.69584,55.04531,2.66565),(-.69412,55.04214,2.66881),(-.74448,55.02242,2.65305),(-.79579,54.97615,2.68929),(-.80631,55.00009,2.66681),(-.76693,55.01392,2.65745),(-.68583,55.04636,2.66056),(-.68833,55.0461,2.66183),(-.68443,55.03481,2.61374),(-.65409,55.00836,2.83424),(-.64699,55.00773,2.74222),(-.63929,55.00978,2.74671),(-.55812,55.24285,2.80167),(-.56097,55.21363,2.80297),(-.53998,55.21021,2.78733),(-.64425,55.01074,2.75736),(-.761,55.25771,2.87498),(-.77309,55.20358,2.87812),(-.74848,55.20194,2.88742),(-.81158,55.02963,2.64968),(-.79321,55.06708,2.63786),(-.7382,55.25836,2.87907),(-.54124,55.24251,2.78421),(-.65243,54.98972,2.61839),(-.68935,55.04271,2.66751),(-.73778,55.01204,2.66509),(-.75365,55.03055,2.62367),(-.71626,55.02843,2.60975),(-.75166,55.03007,2.63274),(-.80147,54.9666,2.71267),(-.55842,54.96237,2.73262),(-.55892,54.97119,2.75415),(-.49826,55.14829,2.69155),(-.80574,55.00487,2.78585),(-.68432,55.04065,2.6663),(-.69276,55.23072,2.62819),(-.83231,55.07751,2.75376),(-.65012,55.02816,2.86351),(-.56446,55.02087,2.80495),(-.75816,54.93131,2.7634),(-.5982,54.96267,2.73249),(-.62321,54.96556,2.64748),(-.50427,55.21952,2.72635),(-.52506,55.0159,2.69349),(-.53407,55.2654,2.65792),(-.7079,55.0439,2.88517),(-.69698,55.01219,2.88328),(-.64731,55.05318,2.8689),(-.71222,55.1444,2.89113),(-.72189,55.20018,2.88846),(-.7445,55.14636,2.88532),(-.81199,55.21357,2.82341),(-.8102,54.98321,2.69044),(-.82382,55.0516,2.664),(-.59152,54.98304,2.62256),(-.63324,54.96295,2.6771),(-.72368,54.99124,2.69293),(-.68485,55.02199,2.68629),(-.68833,55.02982,2.67969),(-.74603,54.944,2.80831),(-.70736,55.02949,2.62509),(-.67878,55.00829,2.69785),(-.58421,54.98134,2.76701),(-.65897,54.99975,2.73271),(-.71206,54.9847,2.87292),(-.7391,55.08004,2.87761),(-.54116,55.25703,2.78467),(-.52434,55.25989,2.76726),(-.66265,55.27134,2.86022),(-.71451,55.25887,2.88267),(-.66285,55.25679,2.85857),(-.7137,55.27324,2.8832),(-.77637,55.25731,2.85996),(-.78957,55.27124,2.84562),(-.79182,55.25692,2.84495),(-.77421,55.27165,2.86044),(-.81506,55.25608,2.79227),(-.82159,55.27034,2.77151),(-.82283,55.25552,2.77027),(-.81437,55.2705,2.79314),(-.73209,55.26342,2.65517),(-.69228,55.27449,2.63217),(-.54843,55.27866,2.63577),(-.5348,55.27978,2.66017),(-.51709,55.2681,2.7289),(-.75554,55.04279,2.61722),(-.75315,55.08447,2.61461),(-.82725,55.13402,2.79291),(-.82356,55.07256,2.78018),(-.80342,55.21429,2.84439),(-.77475,55.017,2.82919),(-.80375,55.06751,2.81934),(-.79584,55.00582,2.80421),(-.7843,55.07044,2.8398),(-.73477,54.93993,2.79462),(-.55478,55.1641,2.80607),(-.53114,55.16223,2.7891),(-.64628,55.23027,2.60977),(-.64501,55.26284,2.61517),(-.67432,55.07483,2.58712),(-.71805,55.03883,2.60313),(-.71498,55.07956,2.59687),(-.81059,54.98083,2.72292),(-.77047,54.93512,2.77489),(-.77799,54.94558,2.78647),(-.66368,54.99805,2.71393),(-.5065,55.08297,2.6668),(-.51674,55.14225,2.63821),(-.81461,55.06984,2.80032),(-.69239,55.03897,2.67198),(-.81935,54.99588,2.69691),(-.78626,55.10603,2.64539),(-.82704,55.14553,2.69494),(-.78192,55.16354,2.65994),(-.83134,55.09125,2.67996),(-.65534,55.16637,2.59593),(-.59355,55.22313,2.60623),(-.59225,55.14284,2.59355),(-.61604,55.04539,2.58775),(-.69557,55.17395,2.60968),(-.73897,55.17078,2.6308),(-.83402,55.02924,2.7076),(-.82607,55.21169,2.77797),(-.83157,55.21054,2.75351),(-.80634,55.14073,2.83977),(-.81851,55.13729,2.81734),(-.78825,55.20893,2.86124),(-.7099,55.08747,2.88736),(-.65292,55.10516,2.86709),(-.65564,55.15968,2.86551),(-.61122,55.21489,2.83448),(-.60675,55.25426,2.83325),(-.66327,55.21698,2.85607),(-.60329,55.1134,2.83949),(-.55227,55.10687,2.80685),(-.60458,55.17074,2.8353),(-.66842,54.99667,2.71543),(-.5547,55.00588,2.78714),(-.60057,55.06378,2.8431),(-.55893,55.05116,2.81169),(-.54492,54.99088,2.76939),(-.5261,55.03272,2.77256),(-.56429,55.028,2.61735),(-.49863,55.15209,2.72067),(-.54564,55.02045,2.6417),(-.53918,55.08816,2.61284),(-.52127,55.08514,2.63922),(-.5362,55.1402,2.61589),(-.51705,55.16114,2.77501),(-.54202,55.04185,2.7928),(-.78292,54.9407,2.75498),(-.6664,55.10635,2.58778),(-.60169,55.08807,2.58671),(-.52931,55.01435,2.66846),(-.82483,55.01658,2.73753),(-.61737,54.95873,2.64354),(-.77483,55.14821,2.87131),(-.51544,55.2624,2.70581),(-.51653,55.27654,2.70685),(-.59529,55.2641,2.61822),(-.59531,55.27848,2.62096),(-.76858,55.2585,2.68949),(-.80867,55.27069,2.81622),(-.75896,55.27206,2.87529),(-.606,55.26877,2.83382),(-.55751,55.25738,2.80241),(-.73665,55.27264,2.87903),(-.79802,55.27097,2.83039),(-.80534,55.26342,2.72798),(-.80638,55.24941,2.72472),(-.64443,55.27882,2.61704),(-.52317,55.27916,2.68431),(-.5229,55.26493,2.68282),(-.74843,55.11738,2.62006),(-.79057,55.14447,2.85551),(-.53344,55.10676,2.78987),(-.70397,55.11363,2.59779),(-.81588,55.21877,2.71015),(-.51459,55.10664,2.77293)]))),
        Shape(DEF='rpreol2c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rpreol2c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,9,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,31,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,36,35,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,64,66,-1,67,68,69,-1,58,70,53,-1,71,69,72,-1,22,62,73,-1,21,20,25,-1,74,75,76,-1,77,78,79,-1,77,80,78,-1,81,82,83,-1,84,85,2,-1,86,87,88,-1,89,90,91,-1,15,92,16,-1,50,8,93,-1,94,64,95,-1,10,9,96,-1,37,34,97,-1,59,98,60,-1,42,58,40,-1,99,36,43,-1,100,101,46,-1,96,55,54,-1,102,100,49,-1,97,34,103,-1,70,58,57,-1,42,104,56,-1,42,38,104,-1,43,67,105,-1,74,99,75,-1,94,66,64,-1,99,106,32,-1,107,108,109,-1,110,111,112,-1,113,71,114,-1,16,92,115,-1,91,116,117,-1,118,119,120,-1,121,122,14,-1,75,123,76,-1,124,13,12,-1,125,26,23,-1,126,127,27,-1,128,55,129,-1,69,71,120,-1,94,95,130,-1,131,132,97,-1,64,63,133,-1,134,109,57,-1,135,54,53,-1,51,136,52,-1,102,137,138,-1,44,46,101,-1,7,139,140,-1,132,131,57,-1,141,38,142,-1,37,39,35,-1,33,59,103,-1,77,25,143,-1,144,145,146,-1,147,148,17,-1,96,16,115,-1,149,106,74,-1,20,150,151,-1,152,112,153,-1,154,155,156,-1,147,157,15,-1,158,157,159,-1,10,107,11,-1,13,149,76,-1,149,29,106,-1,17,19,147,-1,18,144,146,-1,77,23,25,-1,29,160,30,-1,32,161,99,-1,132,56,37,-1,67,39,38,-1,57,56,132,-1,140,93,7,-1,101,72,44,-1,102,48,137,-1,58,128,47,-1,51,162,136,-1,58,53,128,-1,131,134,57,-1,133,95,64,-1,133,134,95,-1,97,163,131,-1,95,163,130,-1,120,105,69,-1,42,142,38,-1,108,107,135,-1,114,72,101,-1,164,155,151,-1,13,76,14,-1,154,143,20,-1,125,165,26,-1,14,166,121,-1,120,167,118,-1,91,90,116,-1,168,116,169,-1,168,170,116,-1,114,139,113,-1,110,6,111,-1,98,59,33,-1,73,65,171,-1,74,106,99,-1,105,172,43,-1,58,42,56,-1,130,97,61,-1,59,97,103,-1,69,44,72,-1,100,102,101,-1,99,161,36,-1,97,130,163,-1,37,97,132,-1,154,29,149,-1,62,65,73,-1,96,54,10,-1,30,160,33,-1,101,102,162,-1,50,173,8,-1,113,139,174,-1,115,92,175,-1,15,158,92,-1,91,176,89,-1,86,177,87,-1,2,82,84,-1,25,20,143,-1,124,143,154,-1,24,21,25,-1,22,144,62,-1,72,114,71,-1,129,178,128,-1,69,105,67,-1,65,62,64,-1,59,61,97,-1,133,11,134,-1,53,55,128,-1,50,52,179,-1,48,102,49,-1,142,42,41,-1,37,56,104,-1,45,40,58,-1,141,142,41,-1,37,104,38,-1,34,37,35,-1,30,33,31,-1,26,180,27,-1,22,150,20,-1,144,181,145,-1,18,146,19,-1,16,96,9,-1,149,74,76,-1,9,11,148,-1,158,15,157,-1,7,93,8,-1,68,44,69,-1,33,160,156,-1,5,182,3,-1,2,85,0,-1,183,184,185,-1,184,183,186,-1,187,89,176,-1,89,187,188,-1,153,189,190,-1,191,189,153,-1,192,193,194,-1,192,195,193,-1,196,5,4,-1,196,197,5,-1,198,199,83,-1,199,198,200,-1,20,155,154,-1,20,151,155,-1,201,85,84,-1,201,190,85,-1,202,203,204,-1,203,202,205,-1,118,206,207,-1,118,167,206,-1,29,32,106,-1,29,31,32,-1,60,171,65,-1,60,164,171,-1,164,60,98,-1,141,67,38,-1,68,67,141,-1,58,49,45,-1,58,47,49,-1,162,208,136,-1,162,102,208,-1,130,66,94,-1,130,61,66,-1,71,167,120,-1,167,71,113,-1,162,140,101,-1,51,140,162,-1,164,150,171,-1,151,150,164,-1,145,127,146,-1,127,145,27,-1,79,209,125,-1,210,209,79,-1,12,80,124,-1,211,80,12,-1,212,121,203,-1,122,121,212,-1,123,118,166,-1,118,123,119,-1,167,174,206,-1,113,174,167,-1,213,214,215,-1,216,214,213,-1,3,217,218,-1,217,3,182,-1,219,220,126,-1,219,215,220,-1,158,214,221,-1,214,158,159,-1,220,157,222,-1,220,159,157,-1,116,223,169,-1,116,90,223,-1,110,7,6,-1,224,7,110,-1,225,169,223,-1,169,225,179,-1,18,133,63,-1,17,133,18,-1,154,160,29,-1,154,156,160,-1,99,172,75,-1,99,43,172,-1,223,226,225,-1,223,227,226,-1,173,184,8,-1,173,185,184,-1,89,223,90,-1,223,89,227,-1,221,92,158,-1,221,170,92,-1,88,91,86,-1,88,176,91,-1,219,213,215,-1,217,213,219,-1,219,218,217,-1,219,180,218,-1,159,215,214,-1,215,159,220,-1,152,110,112,-1,110,152,228,-1,84,202,201,-1,84,205,202,-1,199,79,78,-1,79,199,210,-1,79,23,77,-1,79,125,23,-1,149,124,154,-1,124,149,13,-1,22,171,150,-1,22,73,171,-1,172,120,119,-1,120,172,105,-1,52,175,168,-1,52,136,175,-1,108,53,70,-1,108,135,53,-1,61,65,66,-1,60,65,61,-1,138,208,102,-1,138,178,208,-1,47,137,48,-1,47,128,137,-1,45,100,46,-1,100,45,49,-1,41,45,44,-1,45,41,40,-1,155,33,156,-1,98,155,164,-1,155,98,33,-1,145,28,27,-1,145,181,28,-1,24,26,28,-1,23,26,24,-1,107,134,11,-1,107,109,134,-1,147,9,148,-1,15,9,147,-1,8,111,6,-1,111,8,184,-1,201,228,152,-1,201,202,228,-1,152,190,201,-1,152,153,190,-1,198,82,2,-1,83,82,198,-1,3,192,4,-1,3,229,192,-1,230,2,1,-1,198,2,230,-1,192,196,4,-1,192,194,196,-1,200,230,231,-1,200,198,230,-1,197,87,5,-1,87,197,232,-1,233,89,188,-1,233,227,89,-1,183,226,234,-1,185,226,183,-1,184,235,111,-1,184,186,235,-1,236,176,88,-1,176,236,187,-1,190,0,85,-1,189,0,190,-1,237,195,238,-1,195,237,193,-1,234,227,233,-1,234,226,227,-1,209,238,195,-1,209,210,238,-1,200,210,199,-1,200,238,210,-1,212,205,81,-1,212,203,205,-1,207,239,204,-1,207,206,239,-1,181,22,21,-1,144,22,181,-1,165,3,218,-1,3,165,229,-1,34,161,103,-1,34,36,161,-1,141,44,68,-1,141,41,44,-1,173,179,225,-1,173,50,179,-1,54,107,10,-1,54,135,107,-1,63,144,18,-1,144,63,62,-1,77,124,80,-1,143,124,77,-1,80,240,78,-1,240,80,211,-1,211,212,240,-1,211,122,212,-1,84,81,205,-1,81,84,82,-1,166,207,121,-1,207,166,118,-1,206,224,239,-1,174,224,206,-1,216,177,86,-1,216,213,177,-1,177,5,87,-1,5,177,182,-1,127,220,222,-1,127,126,220,-1,216,221,214,-1,216,117,221,-1,147,222,157,-1,19,222,147,-1,139,224,174,-1,139,7,224,-1,51,93,140,-1,51,50,93,-1,179,168,169,-1,168,179,52,-1,11,17,148,-1,11,133,17,-1,115,55,96,-1,129,55,115,-1,129,208,178,-1,129,115,208,-1,35,67,43,-1,35,39,67,-1,136,115,175,-1,115,136,208,-1,170,117,116,-1,117,170,221,-1,86,117,216,-1,86,91,117,-1,217,177,213,-1,182,177,217,-1,219,27,180,-1,126,27,219,-1,222,146,127,-1,222,19,146,-1,228,224,110,-1,228,239,224,-1,121,204,203,-1,204,121,207,-1,14,123,166,-1,76,123,14,-1,122,12,14,-1,12,122,211,-1,83,78,240,-1,83,199,78,-1,125,229,165,-1,209,229,125,-1,28,21,24,-1,28,181,21,-1,75,119,123,-1,119,75,172,-1,170,175,92,-1,170,168,175,-1,108,57,109,-1,108,70,57,-1,131,95,134,-1,131,163,95,-1,138,128,178,-1,138,137,128,-1,225,185,173,-1,185,225,226,-1,139,101,140,-1,139,114,101,-1,103,32,33,-1,32,103,161,-1,218,26,165,-1,218,180,26,-1,228,204,239,-1,228,202,204,-1,240,81,83,-1,240,212,81,-1,195,229,209,-1,229,195,192,-1,241,153,112,-1,191,153,241,-1,231,238,200,-1,238,231,237,-1,88,232,236,-1,232,88,87,-1,111,241,112,-1,235,241,111,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpreol2c_Coord',point=[(-.59755,55.27356,2.46716),(-.60871,55.27519,2.50746),(-.6069,55.26072,2.50801),(-.85164,55.22728,2.59851),(-.8529,55.24907,2.59939),(-.88096,55.26576,2.57141),(-.6997,55.2056,2.36166),(-.69662,55.14984,2.35267),(-.71823,55.21392,2.371),(-.88559,55.00491,2.44282),(-.8653,55.00726,2.44906),(-.86023,54.98527,2.47341),(-.65153,55.05058,2.55116),(-.66105,55.02556,2.55369),(-.61457,55.03005,2.51774),(-.89585,55.00865,2.44476),(-.85075,55.05989,2.39758),(-.87769,54.96547,2.5119),(-.85603,54.97583,2.56393),(-.88424,54.97037,2.51288),(-.75209,55.05496,2.60792),(-.78827,55.0329,2.61955),(-.7888,55.0275,2.61685),(-.78111,55.10822,2.6217),(-.78584,55.05917,2.62169),(-.75699,55.06653,2.61536),(-.81412,55.10587,2.6184),(-.84576,55.0403,2.59873),(-.81774,55.04485,2.61534),(-.69925,55.01004,2.56044),(-.70355,55.0217,2.56013),(-.70218,55.01531,2.55107),(-.70683,55.02367,2.53621),(-.7242,55.05631,2.55846),(-.73388,55.04239,2.4896),(-.71241,55.0156,2.46681),(-.71437,55.01485,2.48066),(-.73442,55.03935,2.46383),(-.71161,55.04003,2.43662),(-.71418,55.02491,2.44609),(-.7339,55.06506,2.43018),(-.71699,55.04366,2.41316),(-.72914,55.06576,2.43741),(-.68705,54.99006,2.4674),(-.71503,55.03287,2.39166),(-.73703,55.0619,2.41962),(-.72749,55.04818,2.38057),(-.76122,55.08543,2.43738),(-.75632,55.0789,2.38695),(-.74721,55.06603,2.38558),(-.74028,55.16623,2.36214),(-.74491,55.12123,2.35596),(-.77902,55.12946,2.36598),(-.77421,55.08415,2.44098),(-.84118,55.05151,2.41352),(-.83541,55.06149,2.40883),(-.75881,55.08347,2.45213),(-.76446,55.0808,2.45197),(-.7618,55.08721,2.44649),(-.73419,55.07282,2.5373),(-.73829,55.06958,2.54079),(-.75352,55.07047,2.5067),(-.79914,55.01633,2.58844),(-.83441,54.98479,2.55405),(-.81806,55.0164,2.54138),(-.78413,55.03329,2.58008),(-.80067,55.03363,2.54974),(-.69283,55.00917,2.42623),(-.7034,55.02044,2.40735),(-.69631,55.01489,2.39026),(-.7675,55.08531,2.44767),(-.67625,55.02774,2.38432),(-.70266,55.0335,2.3731),(-.78591,55.03108,2.59409),(-.6762,54.98275,2.53117),(-.66976,54.97597,2.50106),(-.64152,54.99092,2.51508),(-.72778,55.10477,2.60278),(-.67617,55.168,2.56609),(-.73227,55.1822,2.5886),(-.67653,55.10216,2.57295),(-.6021,55.20068,2.50991),(-.6037,55.21871,2.50923),(-.63198,55.2129,2.53748),(-.58185,55.2202,2.47051),(-.59345,55.25937,2.46738),(-.90424,55.23708,2.4947),(-.89527,55.27628,2.53958),(-.90121,55.28633,2.51059),(-.84488,55.29672,2.44593),(-.84702,55.25497,2.42365),(-.89004,55.23791,2.44854),(-.86832,55.08604,2.39681),(-.71792,55.15706,2.35788),(-.81107,55.03595,2.53503),(-.81203,55.02747,2.5201),(-.84621,55.05548,2.40049),(-.75093,55.07018,2.49718),(-.73603,55.07099,2.54452),(-.68688,54.98582,2.51172),(-.74428,55.06199,2.37479),(-.72077,55.05958,2.36433),(-.757,55.07267,2.37219),(-.72886,55.05017,2.53114),(-.73165,55.05837,2.44571),(-.69007,54.99575,2.4141),(-.68854,54.99431,2.53454),(-.84326,55.02935,2.45245),(-.82995,55.04119,2.45321),(-.82586,55.0282,2.4633),(-.65306,55.19511,2.37131),(-.69663,55.26103,2.37925),(-.65495,55.25432,2.38031),(-.66601,55.05453,2.37268),(-.69088,55.05325,2.36545),(-.80919,55.08394,2.37805),(-.85728,55.20397,2.40949),(-.90038,55.17829,2.44449),(-.61938,55.03206,2.42189),(-.64584,54.98884,2.45003),(-.66896,55.00531,2.40385),(-.58521,55.08338,2.47167),(-.60185,55.08426,2.51229),(-.6356,54.98723,2.4814),(-.68907,55.05461,2.57532),(-.78003,55.17948,2.60951),(-.87796,55.03737,2.57088),(-.87246,55.01231,2.57076),(-.76832,55.08701,2.43738),(-.80444,55.08592,2.38717),(-.75699,55.07124,2.49934),(-.75552,55.06819,2.4729),(-.74794,55.06988,2.47267),(-.85528,54.97007,2.50109),(-.82043,55.00967,2.47989),(-.83352,55.04426,2.43884),(-.78447,55.08802,2.36972),(-.76675,55.07609,2.38661),(-.76648,55.07418,2.37771),(-.69518,55.09947,2.35367),(-.72033,55.1092,2.35187),(-.70721,55.03166,2.41629),(-.71474,55.04657,2.42532),(-.729,55.0647,2.60147),(-.81703,55.00936,2.6077),(-.82336,55.01546,2.60714),(-.86107,54.98241,2.56684),(-.89344,54.98614,2.47925),(-.88414,54.98119,2.47928),(-.68228,54.99951,2.55714),(-.75385,55.05377,2.60639),(-.75117,55.05589,2.60426),(-.62389,55.24417,2.39456),(-.62492,55.25729,2.39842),(-.72278,55.03867,2.5932),(-.73076,55.044,2.5952),(-.72298,55.04117,2.58826),(-.90687,55.01766,2.47257),(-.90187,55.04803,2.43792),(-.90941,55.0437,2.47163),(-.70428,55.01652,2.56827),(-.7102,55.02031,2.5197),(-.75503,55.08167,2.36591),(-.75655,55.07014,2.49376),(-.75011,55.05694,2.60009),(-.81344,55.17114,2.613),(-.60453,55.02997,2.47598),(-.64854,55.04168,2.38929),(-.81312,55.13769,2.37611),(-.80156,55.19462,2.39232),(-.85849,55.14199,2.39456),(-.76162,55.04851,2.59962),(-.67517,54.97867,2.45472),(-.73675,55.22224,2.38037),(-.65379,55.08509,2.3694),(-.81391,55.0945,2.37424),(-.88688,55.28689,2.46453),(-.90609,55.21942,2.54357),(-.78161,55.07522,2.38023),(-.77066,55.18002,2.37861),(-.84395,55.103,2.60713),(-.81811,55.01692,2.61061),(-.88136,55.21866,2.58138),(-.7358,55.2782,2.40339),(-.71736,55.26276,2.38871),(-.73992,55.26648,2.39948),(-.71668,55.27663,2.39454),(-.88553,55.30179,2.46944),(-.84439,55.31051,2.45185),(-.60625,55.27196,2.42866),(-.60227,55.25803,2.42527),(-.62704,55.27058,2.40381),(-.81625,55.24609,2.60681),(-.78094,55.25334,2.59818),(-.81703,55.26048,2.60499),(-.78164,55.23993,2.60139),(-.84865,55.26379,2.59941),(-.8764,55.27987,2.57204),(-.63842,55.24986,2.53821),(-.6758,55.22092,2.56269),(-.67938,55.24061,2.56052),(-.5958,55.23147,2.41899),(-.59465,55.18966,2.4127),(-.57691,55.14947,2.46897),(-.59637,55.14777,2.40881),(-.57908,55.19109,2.46995),(-.62911,55.08544,2.38724),(-.6051,55.08646,2.4139),(-.78397,55.07515,2.37696),(-.7779,55.22674,2.60151),(-.73215,55.23017,2.58482),(-.6437,55.09006,2.54935),(-.59913,55.14365,2.5098),(-.91115,55.16592,2.53785),(-.91268,55.10689,2.47943),(-.91269,55.09532,2.52655),(-.91413,55.16576,2.49172),(-.88282,55.16583,2.57991),(-.84628,55.16118,2.60575),(-.88451,55.10126,2.57675),(-.90675,55.04327,2.52052),(-.90039,55.12546,2.43465),(-.89597,54.99396,2.51747),(-.79763,55.25633,2.41475),(-.65257,55.14277,2.36569),(-.76721,55.23929,2.39751),(-.77178,55.27887,2.41595),(-.80118,55.29233,2.43171),(-.62591,55.18842,2.38707),(-.81522,55.22786,2.60683),(-.64128,55.26123,2.53691),(-.68247,55.25397,2.55737),(-.89056,55.28989,2.54318),(-.7994,55.30622,2.43702),(-.7682,55.29165,2.42038),(-.69604,55.27496,2.38491),(-.89837,55.30071,2.51462),(-.73564,55.25081,2.58119),(-.73345,55.23942,2.58396),(-.6263,55.1451,2.382),(-.63873,55.1509,2.54659),(-.65543,55.26875,2.38548)]))),
        Shape(DEF='llatincc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='llatincc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,9,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,12,47,48,-1,49,50,51,-1,52,53,54,-1,31,55,56,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,55,66,56,-1,55,67,37,-1,68,69,70,-1,71,72,73,-1,72,74,75,-1,76,8,7,-1,77,48,70,-1,78,79,80,-1,78,70,48,-1,78,81,82,-1,83,8,76,-1,19,84,85,-1,86,60,87,-1,88,89,90,-1,91,92,93,-1,94,75,95,-1,96,73,97,-1,98,49,99,-1,100,101,83,-1,101,102,103,-1,31,67,55,-1,104,105,106,-1,25,96,107,-1,108,109,110,-1,111,106,105,-1,27,112,113,-1,114,65,115,-1,23,116,90,-1,117,54,118,-1,84,119,59,-1,120,121,122,-1,123,124,11,-1,125,100,126,-1,125,127,100,-1,128,129,130,-1,131,132,133,-1,46,134,99,-1,91,69,68,-1,78,135,79,-1,136,12,77,-1,137,138,139,-1,140,98,141,-1,78,68,70,-1,83,76,142,-1,49,140,143,-1,60,144,145,-1,77,69,46,-1,40,39,43,-1,9,34,122,-1,146,32,147,-1,148,149,150,-1,25,24,151,-1,21,23,152,-1,18,136,153,-1,15,41,129,-1,84,154,85,-1,84,58,154,-1,145,144,147,-1,120,155,40,-1,8,83,156,-1,157,158,5,-1,159,7,6,-1,160,161,162,-1,163,164,7,-1,156,103,165,-1,166,167,168,-1,163,169,164,-1,160,162,170,-1,159,163,7,-1,40,121,120,-1,122,121,42,-1,14,171,47,-1,49,98,140,-1,172,105,104,-1,25,151,173,-1,24,26,108,-1,147,144,146,-1,122,10,9,-1,174,175,36,-1,176,77,46,-1,49,143,117,-1,177,57,59,-1,60,145,61,-1,178,66,155,-1,66,178,56,-1,179,180,181,-1,98,71,73,-1,73,72,97,-1,137,139,166,-1,10,17,11,-1,51,182,49,-1,182,99,49,-1,126,100,83,-1,92,91,68,-1,46,99,182,-1,142,126,83,-1,120,122,34,-1,59,58,84,-1,118,50,117,-1,107,75,94,-1,107,97,75,-1,101,156,83,-1,55,37,36,-1,27,113,35,-1,183,184,185,-1,110,186,108,-1,25,173,96,-1,174,35,187,-1,103,156,101,-1,100,188,101,-1,96,97,107,-1,94,95,139,-1,189,190,93,-1,191,192,193,-1,93,190,91,-1,88,90,53,-1,194,86,87,-1,195,130,126,-1,19,85,196,-1,78,48,81,-1,45,153,176,-1,7,164,76,-1,72,75,97,-1,71,190,72,-1,69,77,70,-1,135,78,82,-1,67,197,37,-1,50,49,117,-1,64,198,65,-1,33,120,34,-1,62,87,60,-1,32,31,56,-1,53,199,54,-1,12,48,77,-1,46,182,44,-1,45,176,46,-1,125,126,130,-1,35,174,36,-1,32,146,30,-1,29,112,27,-1,148,200,149,-1,172,111,105,-1,119,45,44,-1,201,202,203,-1,12,14,47,-1,9,11,145,-1,0,2,204,-1,191,205,206,-1,157,207,208,-1,209,205,210,-1,209,206,205,-1,211,164,169,-1,211,212,164,-1,167,213,214,-1,167,215,213,-1,216,217,218,-1,216,3,217,-1,219,6,165,-1,219,159,6,-1,184,218,217,-1,184,220,218,-1,221,57,118,-1,221,58,57,-1,58,221,154,-1,17,122,15,-1,10,122,17,-1,222,202,201,-1,202,222,128,-1,13,136,18,-1,136,13,12,-1,172,223,111,-1,224,223,172,-1,152,225,21,-1,152,226,225,-1,186,227,151,-1,186,228,227,-1,229,230,231,-1,229,232,230,-1,195,128,130,-1,202,128,195,-1,175,187,114,-1,175,174,187,-1,233,127,38,-1,233,234,127,-1,135,142,76,-1,135,82,142,-1,133,123,181,-1,235,123,133,-1,189,72,190,-1,189,74,72,-1,137,168,2,-1,137,166,168,-1,170,79,160,-1,170,193,79,-1,43,125,130,-1,43,39,125,-1,235,19,196,-1,235,20,19,-1,16,181,123,-1,16,179,181,-1,85,62,196,-1,154,62,85,-1,199,118,54,-1,199,221,118,-1,193,80,79,-1,192,80,193,-1,75,236,95,-1,75,74,236,-1,234,115,188,-1,114,115,234,-1,113,187,35,-1,187,113,63,-1,27,37,197,-1,37,27,35,-1,139,237,94,-1,237,139,138,-1,138,238,237,-1,238,138,239,-1,240,238,239,-1,241,238,240,-1,140,242,150,-1,242,140,141,-1,243,185,231,-1,243,183,185,-1,89,226,152,-1,226,89,244,-1,241,243,106,-1,241,240,243,-1,200,245,88,-1,200,228,245,-1,238,246,109,-1,246,238,241,-1,186,245,228,-1,186,110,245,-1,137,239,138,-1,239,137,247,-1,26,94,237,-1,26,107,94,-1,25,107,26,-1,29,248,104,-1,248,29,28,-1,158,232,229,-1,232,158,249,-1,64,113,249,-1,64,63,113,-1,233,114,234,-1,233,175,114,-1,134,98,99,-1,98,134,71,-1,134,190,71,-1,134,91,190,-1,95,215,167,-1,95,236,215,-1,205,193,170,-1,191,193,205,-1,52,88,53,-1,52,200,88,-1,200,52,149,-1,146,60,86,-1,146,144,60,-1,135,160,79,-1,135,212,160,-1,229,5,158,-1,5,229,250,-1,44,59,119,-1,44,177,59,-1,251,74,189,-1,251,236,74,-1,235,132,20,-1,132,235,133,-1,65,102,115,-1,102,65,198,-1,63,114,187,-1,63,65,114,-1,154,87,62,-1,221,87,154,-1,30,86,116,-1,30,146,86,-1,52,117,143,-1,52,54,117,-1,48,171,81,-1,48,47,171,-1,129,43,130,-1,43,129,41,-1,38,252,233,-1,38,40,252,-1,31,253,67,-1,31,30,253,-1,112,230,232,-1,112,29,230,-1,150,227,148,-1,242,227,150,-1,225,22,21,-1,22,225,254,-1,104,224,172,-1,248,224,104,-1,119,19,18,-1,119,84,19,-1,13,131,14,-1,13,132,131,-1,180,222,201,-1,180,179,222,-1,42,15,122,-1,42,41,15,-1,255,207,256,-1,255,208,207,-1,208,257,103,-1,255,257,208,-1,220,258,259,-1,220,184,258,-1,210,170,162,-1,205,170,210,-1,260,2,168,-1,2,260,204,-1,261,3,216,-1,261,4,3,-1,168,214,260,-1,168,167,214,-1,217,185,184,-1,217,250,185,-1,5,207,157,-1,5,4,207,-1,165,8,156,-1,165,6,8,-1,147,9,145,-1,147,33,9,-1,57,50,118,-1,177,50,57,-1,177,51,50,-1,129,222,15,-1,129,128,222,-1,14,180,201,-1,14,131,180,-1,20,13,18,-1,20,132,13,-1,225,248,254,-1,225,224,248,-1,151,242,173,-1,151,227,242,-1,231,250,229,-1,250,231,185,-1,197,28,27,-1,197,262,28,-1,42,40,43,-1,42,121,40,-1,142,195,126,-1,142,263,195,-1,263,202,195,-1,263,203,202,-1,90,199,53,-1,90,194,199,-1,36,66,55,-1,36,252,66,-1,127,188,100,-1,234,188,127,-1,76,212,135,-1,212,76,164,-1,191,251,192,-1,191,206,251,-1,264,243,240,-1,183,243,264,-1,263,82,81,-1,82,263,142,-1,124,235,196,-1,123,235,124,-1,17,123,11,-1,17,16,123,-1,61,196,62,-1,61,124,196,-1,221,194,87,-1,199,194,221,-1,90,152,23,-1,90,89,152,-1,192,92,80,-1,93,92,192,-1,139,167,166,-1,139,95,167,-1,189,192,251,-1,189,93,192,-1,102,188,115,-1,102,101,188,-1,249,157,64,-1,249,158,157,-1,231,106,243,-1,230,106,231,-1,254,253,22,-1,254,262,253,-1,141,173,242,-1,173,141,96,-1,109,237,238,-1,109,26,237,-1,109,108,26,-1,240,247,264,-1,240,239,247,-1,244,110,265,-1,244,245,110,-1,265,111,223,-1,111,265,246,-1,223,244,265,-1,223,226,244,-1,106,246,241,-1,111,246,106,-1,88,244,89,-1,88,245,244,-1,265,109,246,-1,265,110,109,-1,264,1,258,-1,264,247,1,-1,247,2,1,-1,137,2,247,-1,254,28,262,-1,254,248,28,-1,104,230,29,-1,106,230,104,-1,113,232,249,-1,112,232,113,-1,208,64,157,-1,198,64,208,-1,252,155,66,-1,155,252,40,-1,30,22,253,-1,116,22,30,-1,22,116,23,-1,147,56,178,-1,32,56,147,-1,145,124,61,-1,145,11,124,-1,39,127,125,-1,39,38,127,-1,181,131,133,-1,180,131,181,-1,91,46,69,-1,91,134,46,-1,80,68,78,-1,68,80,92,-1,143,149,52,-1,143,150,149,-1,140,150,143,-1,184,264,258,-1,184,183,264,-1,206,236,251,-1,206,215,236,-1,141,73,96,-1,98,73,141,-1,176,136,77,-1,176,153,136,-1,103,198,208,-1,103,102,198,-1,194,116,86,-1,90,116,194,-1,203,81,171,-1,203,263,81,-1,175,252,36,-1,175,233,252,-1,253,197,67,-1,197,253,262,-1,148,228,200,-1,227,228,148,-1,186,24,108,-1,24,186,151,-1,226,224,225,-1,226,223,224,-1,18,45,119,-1,45,18,153,-1,201,171,14,-1,171,201,203,-1,179,15,222,-1,16,15,179,-1,182,177,44,-1,177,182,51,-1,178,33,147,-1,178,120,33,-1,120,178,155,-1,3,250,217,-1,3,5,250,-1,165,257,219,-1,165,103,257,-1,206,213,215,-1,206,209,213,-1,4,256,207,-1,261,256,4,-1,258,0,259,-1,0,258,1,-1,161,212,211,-1,161,160,212,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='llatincc_Coord',point=[(.40394,55.271,3.2072),(.40482,55.25837,3.21391),(.42202,55.23282,3.19373),(.32524,55.21074,3.24337),(.31661,55.20031,3.24246),(.32535,55.19955,3.24715),(.24289,55.16129,3.09197),(.24315,55.16722,3.07251),(.23977,55.14611,3.07882),(.31677,54.91013,3.22435),(.30712,54.95562,3.20552),(.31755,54.95409,3.20145),(.36997,55.03383,3.11583),(.36815,55.03338,3.12048),(.34032,55.07379,3.11349),(.3065,54.99377,3.19202),(.31036,54.99319,3.18917),(.30933,54.9836,3.19441),(.38981,54.99534,3.12326),(.39191,54.98767,3.12843),(.38619,54.99519,3.12666),(.37534,54.89933,3.24532),(.36726,54.90135,3.24995),(.37397,54.89503,3.24313),(.45545,55.05587,3.19912),(.45942,55.05584,3.18993),(.45393,55.06524,3.19911),(.32416,55.00417,3.2805),(.34387,55.00226,3.28359),(.34664,55.05752,3.28731),(.33759,54.89538,3.25397),(.32153,54.89817,3.25689),(.31969,54.88944,3.24621),(.31427,54.90702,3.2272),(.31324,54.9108,3.22457),(.30444,55.00608,3.27743),(.28734,54.95534,3.25419),(.30257,54.95994,3.27214),(.27014,54.97798,3.20847),(.27646,54.98057,3.2009),(.28072,54.95196,3.21781),(.30314,54.99042,3.1946),(.29934,54.9656,3.20523),(.29643,54.98372,3.19975),(.42351,54.9539,3.12878),(.41333,54.96629,3.12546),(.42251,54.98224,3.09357),(.34279,55.07151,3.10881),(.35088,55.06405,3.09355),(.47322,54.92901,3.12813),(.46684,54.92125,3.12925),(.46231,54.92871,3.12662),(.45372,54.90238,3.17149),(.43334,54.8965,3.19919),(.45123,54.89639,3.1636),(.29635,54.90882,3.25615),(.2955,54.89633,3.24933),(.43989,54.91251,3.14997),(.43558,54.91373,3.1518),(.43872,54.91475,3.14881),(.36228,54.89296,3.21848),(.36028,54.90336,3.21188),(.3897,54.90357,3.19166),(.2806,55.05933,3.25264),(.28382,55.10691,3.24947),(.27226,55.05828,3.24116),(.29162,54.91266,3.24888),(.31914,54.90977,3.26452),(.37133,55.0548,3.07075),(.39772,55.01751,3.07832),(.35823,55.05732,3.07978),(.46671,54.9972,3.1151),(.4643,55.04906,3.11687),(.47427,54.99996,3.12898),(.44964,55.08403,3.11168),(.45947,55.09551,3.13069),(.26741,55.13723,3.04606),(.38039,55.02574,3.10888),(.33728,55.09258,3.05213),(.3218,55.13306,3.02683),(.3621,55.09489,3.04846),(.32606,55.08554,3.09171),(.30796,55.09789,3.06312),(.24484,55.10574,3.1122),(.41595,54.95434,3.13507),(.40052,54.95605,3.14981),(.36659,54.88367,3.22493),(.39606,54.89415,3.19885),(.43706,54.90878,3.20637),(.4075,54.90759,3.22979),(.40758,54.89305,3.22234),(.43196,55.02492,3.07901),(.39875,55.0592,3.0673),(.43127,55.06551,3.08674),(.46307,55.10075,3.16524),(.44329,55.14437,3.13704),(.47592,55.00884,3.15883),(.47128,55.05461,3.13376),(.47618,54.95583,3.13438),(.46848,54.9503,3.11588),(.24852,55.05315,3.17213),(.25165,55.09325,3.17996),(.26243,55.0951,3.20663),(.26321,55.13241,3.19133),(.3697,55.05854,3.27701),(.37654,55.06833,3.27246),(.37225,55.10801,3.27571),(.4698,55.05583,3.16184),(.45085,55.05674,3.20806),(.43942,55.05875,3.22756),(.44101,55.00672,3.22567),(.38632,55.05954,3.26934),(.32738,55.05834,3.28017),(.3081,55.05915,3.27306),(.27272,55.01152,3.2467),(.26736,55.05453,3.22711),(.37077,54.88831,3.23756),(.47254,54.91392,3.13273),(.44432,54.904,3.15439),(.4197,54.95393,3.1315),(.30911,54.91149,3.22493),(.2988,54.95533,3.20916),(.30283,54.95625,3.2072),(.33093,54.99011,3.17396),(.34185,54.95268,3.18932),(.27116,55.01608,3.18009),(.26625,55.0579,3.14576),(.25682,55.01067,3.19687),(.30109,55.03312,3.165),(.30183,55.00214,3.18682),(.28782,55.02725,3.17128),(.33907,55.06974,3.11734),(.36523,55.03195,3.12396),(.35125,55.03208,3.13564),(.44915,54.9924,3.09284),(.28922,55.1377,3.03367),(.38667,55.00548,3.11845),(.42946,55.20144,3.19643),(.43869,55.1611,3.19737),(.44937,55.15689,3.17061),(.47719,54.92557,3.14836),(.47766,54.96211,3.15142),(.28525,55.09577,3.08261),(.47736,54.91799,3.14193),(.33259,54.89803,3.23237),(.32998,54.90764,3.22356),(.33544,54.88874,3.23996),(.31727,54.89597,3.23492),(.45482,54.91572,3.1795),(.45475,54.91126,3.17707),(.46074,54.91817,3.17198),(.45422,55.00621,3.19064),(.3834,54.9015,3.24109),(.3934,54.9939,3.11999),(.41398,54.90668,3.17249),(.28921,54.91478,3.22672),(.2552,55.12833,3.15691),(.28635,55.15111,3.23997),(.31783,55.15179,3.26275),(.24582,55.16935,3.11146),(.30774,55.16954,3.02591),(.30665,55.18389,3.02482),(.34771,55.17693,3.04309),(.24239,55.1819,3.07223),(.26171,55.16755,3.04075),(.25308,55.14163,3.14972),(.43366,55.1957,3.17553),(.4334,55.17649,3.14694),(.42964,55.209,3.17795),(.25898,55.18225,3.03722),(.35315,55.16134,3.04344),(.33791,55.07577,3.10981),(.37806,55.05891,3.27329),(.45976,55.00663,3.18253),(.28199,54.99297,3.25699),(.27729,54.98977,3.25058),(.40058,54.99102,3.11345),(.44131,54.91629,3.14637),(.29296,54.90131,3.23772),(.30966,55.03117,3.16303),(.31436,55.06722,3.13008),(.32148,55.03251,3.15445),(.44461,54.95371,3.11377),(.37088,55.199,3.25529),(.35795,55.25534,3.24358),(.36044,55.1984,3.25935),(.4507,55.00572,3.20012),(.28019,55.00995,3.25722),(.2576,55.05385,3.20654),(.43822,55.07228,3.09514),(.45073,55.03522,3.09755),(.38941,55.14779,3.06866),(.40164,55.10667,3.06846),(.3617,55.13949,3.04485),(.40316,54.88651,3.20781),(.28839,55.06447,3.13757),(.37296,54.95432,3.16913),(.32479,54.95708,3.27534),(.27467,55.10053,3.23157),(.42581,54.88852,3.18838),(.44981,54.91363,3.1878),(.31056,55.07104,3.12941),(.30581,55.06963,3.13116),(.30849,55.07315,3.12561),(.41792,55.2474,3.18857),(.38611,55.15646,3.0675),(.41133,55.15253,3.09099),(.28792,55.1653,3.23672),(.27416,55.14147,3.21938),(.40724,55.16658,3.09169),(.38164,55.17177,3.06904),(.28188,55.18412,3.02388),(.28417,55.1691,3.02687),(.42102,55.17128,3.11691),(.42765,55.19192,3.14712),(.4264,55.15652,3.116),(.3245,55.22748,3.23616),(.34189,55.23609,3.24397),(.34174,55.25205,3.23862),(.25024,55.16132,3.13444),(.35539,55.26833,3.23948),(.41955,54.89671,3.17965),(.3056,55.0327,3.16479),(.38497,55.00182,3.2636),(.37677,55.00157,3.26773),(.37817,54.95536,3.25812),(.38612,54.95581,3.25355),(.45537,54.95965,3.18435),(.45132,54.95934,3.19357),(.33547,55.15517,3.26681),(.34799,55.10823,3.28348),(.35309,55.15854,3.27089),(.32771,55.10996,3.27557),(.27145,54.98795,3.23586),(.26538,55.01125,3.2304),(.36158,54.99418,3.14978),(.43633,55.12946,3.11453),(.4471,55.11178,3.19954),(.43249,55.11657,3.22758),(.42695,55.16386,3.22275),(.40259,55.15913,3.25227),(.40517,55.11517,3.25907),(.46127,54.95992,3.17658),(.37544,55.15995,3.26531),(.41419,54.96042,3.23915),(.44078,54.96045,3.21429),(.41302,55.0616,3.25665),(.42008,55.19984,3.21705),(.36847,55.00132,3.27158),(.31241,55.11235,3.26909),(.34266,55.1993,3.25409),(.42034,55.11832,3.09093),(.28154,54.95401,3.24343),(.33866,54.90893,3.26524),(.36993,54.95499,3.26197),(.27379,55.15431,3.21286),(.29022,55.1842,3.2304),(.26468,55.14651,3.18881),(.38975,55.26729,3.2295),(.38755,55.28037,3.22541),(.42513,55.22605,3.1773),(.30111,55.19813,3.23281),(.34169,54.9549,3.2778),(.29805,55.08387,3.10635),(.39787,55.20056,3.24483),(.41575,55.00854,3.25076)]))),
        Shape(DEF='lpreo1lc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lpreo1lc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,18,26,19,-1,27,28,29,-1,30,31,4,-1,3,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,26,-1,45,46,47,-1,27,48,49,-1,50,51,52,-1,53,54,38,-1,55,56,57,-1,27,58,48,-1,59,60,61,-1,62,63,64,-1,8,42,10,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,74,21,75,-1,47,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,30,72,71,-1,90,23,74,-1,20,91,92,-1,11,42,41,-1,93,94,95,-1,14,44,96,-1,40,97,98,-1,99,100,101,-1,102,103,104,-1,3,61,105,-1,36,35,106,-1,107,108,50,-1,109,110,111,-1,57,24,112,-1,17,14,92,-1,113,51,114,-1,37,95,115,-1,38,116,39,-1,117,70,69,-1,118,119,120,-1,121,122,123,-1,124,32,3,-1,125,126,70,-1,30,55,31,-1,12,9,11,-1,22,127,128,-1,17,19,44,-1,129,130,131,-1,26,18,13,-1,12,11,41,-1,132,133,134,-1,132,67,133,-1,67,66,133,-1,8,10,135,-1,136,137,138,-1,139,140,106,-1,43,26,41,-1,138,141,136,-1,10,142,135,-1,13,143,9,-1,26,12,41,-1,26,13,12,-1,129,131,144,-1,44,14,17,-1,55,145,56,-1,55,146,145,-1,73,72,4,-1,30,146,55,-1,124,3,105,-1,121,123,103,-1,147,117,148,-1,117,147,70,-1,113,149,150,-1,113,116,149,-1,115,53,37,-1,113,151,51,-1,40,43,41,-1,152,46,45,-1,112,153,57,-1,132,94,93,-1,132,134,94,-1,154,109,111,-1,50,52,107,-1,155,73,125,-1,106,140,36,-1,3,5,61,-1,99,101,2,-1,34,118,69,-1,44,43,156,-1,44,156,96,-1,94,115,95,-1,128,18,91,-1,157,133,66,-1,92,158,20,-1,23,159,74,-1,87,160,88,-1,84,86,161,-1,81,162,82,-1,78,163,79,-1,47,46,76,-1,30,71,146,-1,74,159,21,-1,155,71,73,-1,128,157,13,-1,126,68,70,-1,13,18,128,-1,118,117,69,-1,164,165,166,-1,62,64,167,-1,168,120,119,-1,68,169,69,-1,34,69,169,-1,170,140,139,-1,61,5,59,-1,119,36,140,-1,73,123,125,-1,55,57,153,-1,38,37,53,-1,50,171,51,-1,28,27,49,-1,48,172,49,-1,173,47,174,-1,47,77,174,-1,47,112,45,-1,14,175,92,-1,44,19,26,-1,42,97,40,-1,68,126,33,-1,102,121,103,-1,104,73,4,-1,72,30,4,-1,146,71,145,-1,175,158,92,-1,25,127,23,-1,21,159,22,-1,175,14,16,-1,20,158,21,-1,65,143,66,-1,10,42,11,-1,10,65,142,-1,8,135,6,-1,42,8,97,-1,0,2,101,-1,176,177,144,-1,178,177,176,-1,179,141,138,-1,179,180,141,-1,181,167,64,-1,181,182,167,-1,183,184,0,-1,183,185,184,-1,186,187,188,-1,189,187,186,-1,190,191,192,-1,190,193,191,-1,194,195,196,-1,195,194,197,-1,34,198,35,-1,34,169,198,-1,199,63,200,-1,199,64,63,-1,201,202,203,-1,201,204,202,-1,205,136,206,-1,136,205,137,-1,143,10,9,-1,10,143,65,-1,142,67,132,-1,67,142,65,-1,143,157,66,-1,143,13,157,-1,207,87,89,-1,87,207,208,-1,16,152,45,-1,16,15,152,-1,145,27,56,-1,145,58,27,-1,100,209,188,-1,100,99,209,-1,124,210,211,-1,124,105,210,-1,118,36,119,-1,118,34,36,-1,29,53,115,-1,28,53,29,-1,149,49,172,-1,54,49,149,-1,151,52,51,-1,151,212,52,-1,213,214,215,-1,214,213,216,-1,25,57,217,-1,25,24,57,-1,77,218,174,-1,77,83,218,-1,110,192,191,-1,109,192,110,-1,219,218,220,-1,219,221,218,-1,135,214,6,-1,135,215,214,-1,222,107,223,-1,222,108,107,-1,147,125,70,-1,147,224,125,-1,168,212,151,-1,212,168,225,-1,198,124,226,-1,198,32,124,-1,227,196,195,-1,227,228,196,-1,229,230,231,-1,209,230,229,-1,105,232,210,-1,105,61,232,-1,233,2,197,-1,233,99,2,-1,228,234,235,-1,228,227,234,-1,140,236,225,-1,140,170,236,-1,234,200,237,-1,234,238,200,-1,222,202,239,-1,222,240,202,-1,137,241,138,-1,201,241,137,-1,242,165,7,-1,166,165,242,-1,166,243,244,-1,166,242,243,-1,245,246,244,-1,246,245,247,-1,248,249,176,-1,248,250,249,-1,43,98,156,-1,43,40,98,-1,251,252,208,-1,253,252,251,-1,254,115,94,-1,29,115,254,-1,22,23,127,-1,22,159,23,-1,96,15,14,-1,15,96,255,-1,256,96,156,-1,207,96,256,-1,130,86,85,-1,86,130,129,-1,257,81,76,-1,81,257,88,-1,232,60,258,-1,60,232,61,-1,259,109,154,-1,109,259,84,-1,260,221,219,-1,260,258,221,-1,231,80,229,-1,80,231,261,-1,261,219,262,-1,219,261,260,-1,154,162,259,-1,154,82,162,-1,76,83,77,-1,83,76,81,-1,85,263,130,-1,85,264,263,-1,59,55,265,-1,59,31,55,-1,103,73,104,-1,73,103,123,-1,224,148,150,-1,147,148,224,-1,253,131,252,-1,248,131,253,-1,248,247,250,-1,253,247,248,-1,164,244,246,-1,164,166,244,-1,135,132,215,-1,135,142,132,-1,266,141,267,-1,136,141,266,-1,137,204,201,-1,204,137,205,-1,239,108,222,-1,108,239,268,-1,225,269,212,-1,225,236,269,-1,270,200,238,-1,200,270,199,-1,170,235,236,-1,170,228,235,-1,226,211,271,-1,226,124,211,-1,272,231,230,-1,272,273,231,-1,228,139,196,-1,228,170,139,-1,60,265,274,-1,59,265,60,-1,216,171,50,-1,213,171,216,-1,122,125,123,-1,122,126,125,-1,217,56,27,-1,56,217,57,-1,221,174,218,-1,221,274,174,-1,223,240,222,-1,240,223,275,-1,97,7,165,-1,97,8,7,-1,262,220,111,-1,262,219,220,-1,220,83,82,-1,83,220,218,-1,276,217,254,-1,276,25,217,-1,173,112,47,-1,173,153,112,-1,212,107,52,-1,212,269,107,-1,150,172,224,-1,149,172,150,-1,210,277,211,-1,277,210,272,-1,126,121,33,-1,122,121,126,-1,48,224,172,-1,48,125,224,-1,24,90,112,-1,23,90,24,-1,74,16,45,-1,75,16,74,-1,96,89,255,-1,89,96,207,-1,206,278,205,-1,206,243,278,-1,214,268,279,-1,214,216,268,-1,201,280,241,-1,201,203,280,-1,237,63,275,-1,237,200,63,-1,35,226,106,-1,35,198,226,-1,197,1,195,-1,1,197,2,-1,192,281,190,-1,281,192,161,-1,282,186,79,-1,282,189,186,-1,101,183,0,-1,283,183,101,-1,64,284,181,-1,284,64,199,-1,285,138,241,-1,285,179,138,-1,178,249,286,-1,178,176,249,-1,177,129,144,-1,177,287,129,-1,180,267,141,-1,180,288,267,-1,280,182,289,-1,182,280,167,-1,270,185,290,-1,185,270,184,-1,291,188,187,-1,291,100,188,-1,163,193,292,-1,193,163,191,-1,271,196,139,-1,196,271,194,-1,269,223,107,-1,269,293,223,-1,62,202,240,-1,62,203,202,-1,294,202,204,-1,294,239,202,-1,295,7,6,-1,242,7,295,-1,263,208,252,-1,263,87,208,-1,75,175,16,-1,21,175,75,-1,158,175,21,-1,91,22,128,-1,91,20,22,-1,15,257,152,-1,15,255,257,-1,17,91,18,-1,91,17,92,-1,3,104,4,-1,102,104,3,-1,99,230,209,-1,99,233,230,-1,32,68,33,-1,198,68,32,-1,169,68,198,-1,150,120,113,-1,148,120,150,-1,215,93,213,-1,215,132,93,-1,78,191,163,-1,78,110,191,-1,156,164,256,-1,156,98,164,-1,28,54,53,-1,28,49,54,-1,114,171,95,-1,171,114,51,-1,265,153,173,-1,265,55,153,-1,27,254,217,-1,27,29,254,-1,225,119,140,-1,168,119,225,-1,195,296,227,-1,296,195,1,-1,186,209,229,-1,188,209,186,-1,273,210,232,-1,272,210,273,-1,194,211,277,-1,211,194,271,-1,296,270,238,-1,296,184,270,-1,237,235,234,-1,293,235,237,-1,63,240,275,-1,240,63,62,-1,294,295,279,-1,278,295,294,-1,279,6,214,-1,279,295,6,-1,206,244,243,-1,206,245,244,-1,213,95,171,-1,213,93,95,-1,247,266,250,-1,247,245,266,-1,246,256,164,-1,256,246,251,-1,208,256,251,-1,208,207,256,-1,58,71,155,-1,58,145,71,-1,76,152,257,-1,46,152,76,-1,255,88,257,-1,88,255,89,-1,160,259,162,-1,160,264,259,-1,273,258,260,-1,232,258,273,-1,84,192,109,-1,192,84,161,-1,260,231,273,-1,261,231,260,-1,79,229,80,-1,186,229,79,-1,261,78,80,-1,261,262,78,-1,88,162,81,-1,160,162,88,-1,258,274,221,-1,258,60,274,-1,259,85,84,-1,259,264,85,-1,87,264,160,-1,263,264,87,-1,5,31,59,-1,5,4,31,-1,144,248,176,-1,144,131,248,-1,251,247,253,-1,251,246,247,-1,267,250,266,-1,250,267,249,-1,151,120,168,-1,151,113,120,-1,206,266,245,-1,206,136,266,-1,278,204,205,-1,278,294,204,-1,50,268,216,-1,50,108,268,-1,236,293,269,-1,236,235,293,-1,238,227,296,-1,234,227,238,-1,197,277,233,-1,277,197,194,-1,1,184,296,-1,184,1,0,-1,157,25,276,-1,157,127,25,-1,157,128,127,-1,274,173,174,-1,274,265,173,-1,98,165,164,-1,98,97,165,-1,262,110,78,-1,262,111,110,-1,82,111,220,-1,82,154,111,-1,134,254,94,-1,134,276,254,-1,38,149,116,-1,38,54,149,-1,113,39,116,-1,39,113,114,-1,39,95,37,-1,95,39,114,-1,148,118,120,-1,117,118,148,-1,277,230,233,-1,277,272,230,-1,121,3,33,-1,121,102,3,-1,48,155,125,-1,48,58,155,-1,74,112,90,-1,112,74,45,-1,130,252,131,-1,130,263,252,-1,276,133,157,-1,133,276,134,-1,242,278,243,-1,242,295,278,-1,239,279,268,-1,294,279,239,-1,167,203,62,-1,167,280,203,-1,275,293,237,-1,293,275,223,-1,139,226,271,-1,139,106,226,-1,297,161,86,-1,297,281,161,-1,163,282,79,-1,292,282,163,-1,283,100,291,-1,283,101,100,-1,290,199,270,-1,290,284,199,-1,289,241,280,-1,289,285,241,-1,267,286,249,-1,288,286,267,-1,287,86,129,-1,287,297,86,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lpreo1lc_Coord',point=[(.76919,55.24425,2.69355),(.77485,55.22419,2.68214),(.73286,55.22915,2.6505),(.67897,55.0342,2.59898),(.65243,54.98972,2.61931),(.64107,54.99988,2.60276),(.73068,54.9732,2.85255),(.71206,54.9847,2.87487),(.70705,54.97148,2.86891),(.66479,54.9948,2.82488),(.69819,54.96458,2.85066),(.66724,54.99754,2.84764),(.65409,55.00836,2.83684),(.64425,55.01074,2.75956),(.58741,55.00758,2.79991),(.57258,54.99098,2.7765),(.58421,54.98134,2.76894),(.59927,55.01033,2.80198),(.64128,55.01059,2.75869),(.61988,55.00578,2.82424),(.63728,55.01021,2.75242),(.6082,54.98434,2.75798),(.63929,55.00978,2.74884),(.6134,54.96985,2.7338),(.60687,54.95936,2.7221),(.65436,55.00091,2.7322),(.64304,55.00535,2.84357),(.67508,55.01142,2.69612),(.68485,55.02199,2.68803),(.67878,55.00829,2.69944),(.62321,54.96556,2.64831),(.61737,54.95873,2.64428),(.71626,55.02843,2.61094),(.70736,55.02949,2.62644),(.77138,55.02609,2.64242),(.77731,55.02569,2.63589),(.80096,55.02083,2.64703),(.75829,54.95515,2.71942),(.75458,54.96526,2.71188),(.7641,54.95533,2.71581),(.65412,55.00932,2.8569),(.65511,55.00529,2.85094),(.69142,54.98777,2.87156),(.64124,55.00577,2.84777),(.61835,55.00827,2.82955),(.57295,54.9515,2.74022),(.55842,54.96237,2.73407),(.56389,54.95372,2.71017),(.68668,55.03685,2.67448),(.68696,55.02777,2.68645),(.79317,54.95346,2.76976),(.79275,54.94999,2.73539),(.80186,54.96582,2.74966),(.72218,54.98307,2.69699),(.72368,54.99124,2.694),(.60393,54.94776,2.6664),(.63324,54.96295,2.67802),(.61853,54.95082,2.69942),(.68273,55.03565,2.67303),(.60316,54.967,2.63005),(.59152,54.98304,2.62361),(.62965,55.01504,2.59172),(.81199,55.21357,2.83032),(.8206,55.21284,2.80907),(.80968,55.25609,2.82382),(.6903,54.96859,2.79983),(.67947,54.98194,2.78407),(.69755,54.96378,2.78893),(.73866,55.03045,2.6412),(.74955,55.03207,2.64754),(.69584,55.04531,2.66764),(.64129,54.98279,2.65793),(.64577,54.98258,2.64868),(.68376,55.04224,2.66379),(.59217,54.96486,2.74447),(.59642,54.97619,2.75539),(.54388,54.97325,2.72796),(.54986,54.96845,2.7049),(.5262,55.20965,2.64971),(.54802,55.26417,2.6408),(.54329,55.21285,2.63062),(.52082,55.01745,2.72115),(.50397,55.08645,2.6979),(.52506,55.0159,2.69585),(.50427,55.21952,2.73295),(.51896,55.2068,2.77848),(.52394,55.24543,2.77451),(.53344,55.10676,2.79476),(.5261,55.03272,2.7758),(.54202,55.04185,2.79635),(.5982,54.96267,2.73381),(.63771,55.01126,2.7559),(.59246,55.01189,2.79434),(.75816,54.93131,2.76387),(.71068,54.94824,2.7326),(.76843,54.93597,2.74331),(.56446,55.02087,2.80807),(.694,54.99978,2.87929),(.65012,55.02816,2.86682),(.69276,55.23072,2.63433),(.69259,55.25848,2.63774),(.73252,55.24903,2.65893),(.67847,55.03478,2.6021),(.67646,55.03757,2.61143),(.67132,55.0258,2.61332),(.67916,55.03683,2.59477),(.78358,55.03621,2.63453),(.81566,55.00391,2.76869),(.80574,55.00487,2.78719),(.50164,55.2157,2.7065),(.51144,55.21053,2.67833),(.50392,55.14423,2.6686),(.58278,54.944,2.71634),(.7866,54.96195,2.70902),(.77842,54.94327,2.72422),(.71888,54.96431,2.71085),(.76109,54.96373,2.70848),(.74448,55.02242,2.65428),(.76693,55.01392,2.65847),(.80631,55.00009,2.66751),(.79579,54.97615,2.68985),(.68443,55.03481,2.61521),(.68833,55.0461,2.66385),(.68583,55.04636,2.66259),(.71805,55.03883,2.60444),(.68935,55.04271,2.6695),(.69083,55.04583,2.66511),(.64699,55.00773,2.74424),(.64317,55.01127,2.75051),(.54124,55.24251,2.79189),(.53998,55.21021,2.79436),(.56097,55.21363,2.81028),(.73477,54.93993,2.79537),(.68424,54.97214,2.77457),(.69454,54.95887,2.75915),(.7215,54.95811,2.8408),(.74848,55.20194,2.89499),(.77309,55.20358,2.88552),(.761,55.25771,2.88394),(.79321,55.06708,2.63947),(.81158,55.02963,2.65066),(.7382,55.25836,2.88816),(.7129,54.95548,2.82517),(.67477,54.98376,2.79387),(.55812,55.24285,2.80957),(.63923,54.97514,2.66518),(.62492,54.96608,2.65901),(.69412,55.04214,2.67077),(.73778,55.01204,2.66626),(.72561,54.99314,2.68808),(.73099,55.00151,2.67841),(.80147,54.9666,2.71319),(.55892,54.97119,2.75589),(.59244,54.94216,2.69155),(.49826,55.14829,2.6965),(.68432,55.04065,2.66827),(.60795,55.0237,2.84323),(.64764,55.01034,2.75356),(.59928,55.0031,2.78583),(.60784,54.98263,2.74481),(.51459,55.10664,2.77767),(.5164,55.25383,2.73571),(.50454,55.09079,2.72664),(.53407,55.2654,2.66502),(.64731,55.05318,2.87289),(.69698,55.01219,2.88601),(.7079,55.0439,2.88863),(.79914,55.25655,2.83843),(.8102,54.98321,2.69103),(.75166,55.03007,2.63393),(.82382,55.0516,2.66533),(.78292,54.9407,2.75543),(.68833,55.02982,2.68151),(.57325,54.95052,2.68507),(.55586,54.96365,2.68189),(.59298,55.00463,2.7915),(.60675,55.25426,2.84185),(.55751,55.25738,2.81063),(.606,55.26877,2.84274),(.75896,55.27206,2.88466),(.73665,55.27264,2.88851),(.80867,55.27069,2.82475),(.79802,55.27097,2.83913),(.76858,55.2585,2.69664),(.80638,55.24941,2.73173),(.80534,55.26342,2.73543),(.59529,55.2641,2.62514),(.64443,55.27882,2.62431),(.64501,55.26284,2.62205),(.59531,55.27848,2.62821),(.51653,55.27654,2.71447),(.5229,55.26493,2.69005),(.51544,55.2624,2.71314),(.52317,55.27916,2.69184),(.74843,55.11738,2.62287),(.78192,55.16354,2.66403),(.78626,55.10603,2.64788),(.73897,55.17078,2.63515),(.75365,55.03055,2.62481),(.81506,55.25608,2.80009),(.82607,55.21169,2.78425),(.78825,55.20893,2.86854),(.80634,55.14073,2.84474),(.80342,55.21429,2.85159),(.79057,55.14447,2.86087),(.77483,55.14821,2.87705),(.7445,55.14636,2.89135),(.55893,55.05116,2.81554),(.55227,55.10687,2.81187),(.64628,55.23027,2.61584),(.67432,55.07483,2.58918),(.71498,55.07956,2.59889),(.81059,54.98083,2.7236),(.77047,54.93512,2.77539),(.7547,54.95501,2.82149),(.74603,54.944,2.80911),(.77799,54.94558,2.7871),(.66368,54.99805,2.7155),(.52931,55.01435,2.67059),(.52127,55.08514,2.64257),(.5065,55.08297,2.67033),(.54564,55.02045,2.6437),(.81461,55.06984,2.803),(.82356,55.07256,2.7827),(.69239,55.03897,2.6739),(.81935,54.99588,2.69764),(.75554,55.04279,2.6185),(.82704,55.14553,2.69847),(.83134,55.09125,2.68207),(.59355,55.22313,2.61214),(.65534,55.16637,2.60032),(.59225,55.14284,2.5976),(.61604,55.04539,2.58953),(.69557,55.17395,2.6142),(.83717,55.14348,2.74333),(.84107,55.08246,2.72959),(.83402,55.02924,2.70878),(.83308,55.13853,2.77513),(.83157,55.21054,2.75944),(.80375,55.06751,2.82218),(.81851,55.13729,2.82187),(.77637,55.25731,2.86871),(.73251,55.03567,2.8765),(.7391,55.08004,2.88176),(.7099,55.08747,2.89202),(.71222,55.1444,2.89734),(.65292,55.10516,2.87236),(.65564,55.15968,2.87212),(.61122,55.21489,2.84219),(.66285,55.25679,2.86754),(.66327,55.21698,2.86403),(.60329,55.1134,2.84487),(.55478,55.1641,2.81232),(.60458,55.17074,2.84199),(.66842,54.99667,2.71697),(.5547,55.00588,2.78985),(.60057,55.06378,2.84735),(.54492,54.99088,2.77168),(.56429,55.028,2.61924),(.49863,55.15209,2.7259),(.53918,55.08816,2.61601),(.5362,55.1402,2.62015),(.51674,55.14225,2.64268),(.53114,55.16223,2.79512),(.51705,55.16114,2.78087),(.58763,54.95506,2.65556),(.72189,55.20018,2.89611),(.71451,55.25887,2.89187),(.79584,55.00582,2.80572),(.82483,55.01658,2.73871),(.82283,55.25552,2.77779),(.75315,55.08447,2.61663),(.6664,55.10635,2.59058),(.60169,55.08807,2.58945),(.57231,54.97208,2.65118),(.82725,55.13402,2.79704),(.65897,54.99975,2.73445),(.70397,55.11363,2.60061),(.76488,55.07336,2.86393),(.77475,55.017,2.83118),(.79182,55.25692,2.85346),(.51709,55.2681,2.73653),(.54843,55.27866,2.64301),(.73209,55.26342,2.66228),(.81437,55.2705,2.8014),(.77421,55.27165,2.8696),(.66265,55.27134,2.86956),(.54116,55.25703,2.79265),(.7137,55.27324,2.89277),(.78957,55.27124,2.85456),(.82159,55.27034,2.77947),(.69228,55.27449,2.63944),(.5348,55.27978,2.66757),(.83231,55.07751,2.75612),(.7843,55.07044,2.84302),(.75371,55.02818,2.85678),(.81588,55.21877,2.71602),(.52434,55.25989,2.77506)]))),
        Shape(DEF='lpreol2c',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='lpreol2c_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,16,20,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,8,38,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,47,51,11,-1,52,53,42,-1,54,50,10,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,48,64,65,-1,66,67,68,-1,9,11,51,-1,69,70,71,-1,72,73,74,-1,75,76,29,-1,32,30,33,-1,77,78,79,-1,78,31,32,-1,2,1,80,-1,81,82,83,-1,84,85,86,-1,15,87,88,-1,24,17,16,-1,14,89,90,-1,91,92,93,-1,20,19,62,-1,26,94,95,-1,96,97,75,-1,7,6,77,-1,98,52,99,-1,100,66,43,-1,101,102,66,-1,99,52,42,-1,62,61,103,-1,55,104,105,-1,106,44,66,-1,64,48,107,-1,65,108,109,-1,108,110,109,-1,51,52,98,-1,99,111,22,-1,92,112,93,-1,41,111,99,-1,113,114,115,-1,116,12,117,-1,118,119,73,-1,120,121,24,-1,122,86,85,-1,21,123,124,-1,125,126,79,-1,34,127,128,-1,129,130,131,-1,71,61,69,-1,132,72,9,-1,102,91,93,-1,91,133,95,-1,115,62,19,-1,64,133,134,-1,69,63,48,-1,135,70,105,-1,136,137,60,-1,138,139,105,-1,56,139,69,-1,139,56,105,-1,74,140,54,-1,141,14,142,-1,65,64,134,-1,110,143,51,-1,43,65,100,-1,99,144,41,-1,39,7,40,-1,32,34,145,-1,28,146,26,-1,120,24,103,-1,22,40,23,-1,19,18,133,-1,147,148,31,-1,149,116,150,-1,6,151,77,-1,16,15,152,-1,87,15,17,-1,21,23,126,-1,22,111,40,-1,146,76,26,-1,78,32,145,-1,106,153,8,-1,53,143,43,-1,46,110,47,-1,65,134,100,-1,142,119,141,-1,54,10,74,-1,56,69,57,-1,57,69,48,-1,60,59,136,-1,70,138,105,-1,63,62,154,-1,64,113,133,-1,115,154,62,-1,102,101,91,-1,9,155,132,-1,110,46,109,-1,154,115,114,-1,140,74,73,-1,147,151,156,-1,157,21,126,-1,31,78,77,-1,34,37,127,-1,85,158,122,-1,118,73,72,-1,116,159,12,-1,8,153,160,-1,161,97,96,-1,22,124,99,-1,98,155,51,-1,65,109,48,-1,67,66,102,-1,106,66,153,-1,74,10,9,-1,42,144,99,-1,49,48,109,-1,68,160,153,-1,66,44,43,-1,98,99,124,-1,40,7,77,-1,77,23,40,-1,26,95,27,-1,20,62,103,-1,8,7,39,-1,137,105,140,-1,14,13,89,-1,162,119,118,-1,163,121,120,-1,24,121,17,-1,87,164,88,-1,86,165,84,-1,83,166,81,-1,2,80,167,-1,168,167,169,-1,21,124,22,-1,32,31,30,-1,96,75,29,-1,74,9,72,-1,63,107,48,-1,9,51,155,-1,94,75,97,-1,66,68,153,-1,133,18,95,-1,69,61,63,-1,58,60,90,-1,55,105,56,-1,45,109,46,-1,108,65,43,-1,47,110,51,-1,109,45,49,-1,42,53,43,-1,38,8,39,-1,35,129,36,-1,31,148,29,-1,146,170,76,-1,24,20,103,-1,157,126,125,-1,20,171,18,-1,14,141,12,-1,5,172,3,-1,2,173,0,-1,174,159,116,-1,159,174,175,-1,176,83,177,-1,166,83,176,-1,178,179,180,-1,181,179,178,-1,149,174,116,-1,174,149,182,-1,183,184,185,-1,186,184,183,-1,169,187,168,-1,169,188,187,-1,189,190,191,-1,189,192,190,-1,161,68,97,-1,156,68,161,-1,160,68,156,-1,55,48,50,-1,55,57,48,-1,135,137,136,-1,135,105,137,-1,97,92,94,-1,97,112,92,-1,91,134,133,-1,91,101,134,-1,64,114,113,-1,64,107,114,-1,163,193,121,-1,163,194,193,-1,195,124,123,-1,98,124,195,-1,30,35,33,-1,30,170,35,-1,183,128,127,-1,128,183,185,-1,196,168,187,-1,196,197,168,-1,125,198,157,-1,199,198,125,-1,123,157,200,-1,157,123,21,-1,189,201,202,-1,203,201,189,-1,204,190,117,-1,204,191,190,-1,28,88,130,-1,28,25,88,-1,129,205,36,-1,205,129,131,-1,81,206,207,-1,206,81,3,-1,158,82,208,-1,158,85,82,-1,158,193,122,-1,209,193,158,-1,210,122,211,-1,210,86,122,-1,141,117,12,-1,117,141,204,-1,211,212,210,-1,58,212,211,-1,51,53,52,-1,51,143,53,-1,104,140,105,-1,54,140,104,-1,213,210,212,-1,213,214,210,-1,215,89,13,-1,215,216,89,-1,210,165,86,-1,214,165,210,-1,121,209,17,-1,121,193,209,-1,85,83,82,-1,85,84,83,-1,207,205,217,-1,205,207,206,-1,218,205,206,-1,218,36,205,-1,217,87,219,-1,164,87,217,-1,204,220,191,-1,220,204,162,-1,203,200,201,-1,221,200,203,-1,169,80,222,-1,167,80,169,-1,223,197,196,-1,224,197,223,-1,34,223,145,-1,34,128,223,-1,79,23,77,-1,126,23,79,-1,161,29,148,-1,161,96,29,-1,132,98,195,-1,155,98,132,-1,163,59,194,-1,163,136,59,-1,63,114,107,-1,63,154,114,-1,97,67,112,-1,67,97,68,-1,10,47,11,-1,10,45,47,-1,144,44,106,-1,144,42,44,-1,172,127,218,-1,183,127,172,-1,29,170,30,-1,170,29,76,-1,20,152,171,-1,152,20,16,-1,159,13,12,-1,215,13,159,-1,190,225,150,-1,190,192,225,-1,226,150,225,-1,226,149,150,-1,167,227,2,-1,227,167,168,-1,186,172,5,-1,186,183,172,-1,2,228,173,-1,228,2,227,-1,229,186,5,-1,229,230,186,-1,228,180,179,-1,228,227,180,-1,166,231,4,-1,176,231,166,-1,165,232,233,-1,165,214,232,-1,213,234,235,-1,234,213,216,-1,175,215,159,-1,175,236,215,-1,84,177,83,-1,237,177,84,-1,0,226,1,-1,226,0,238,-1,184,181,178,-1,239,181,184,-1,214,235,232,-1,214,213,235,-1,178,185,184,-1,178,224,185,-1,224,180,197,-1,224,178,180,-1,222,188,169,-1,222,202,188,-1,191,203,189,-1,191,220,203,-1,133,115,19,-1,133,113,115,-1,171,25,27,-1,171,152,25,-1,37,33,35,-1,33,37,34,-1,35,146,129,-1,35,170,146,-1,8,151,6,-1,151,160,156,-1,8,160,151,-1,50,45,10,-1,49,45,50,-1,104,50,54,-1,55,50,104,-1,58,89,212,-1,58,90,89,-1,95,92,91,-1,92,95,94,-1,134,66,100,-1,101,66,134,-1,76,94,26,-1,75,94,76,-1,79,145,240,-1,145,79,78,-1,187,240,196,-1,199,240,187,-1,188,199,187,-1,188,198,199,-1,200,198,201,-1,198,200,157,-1,192,80,225,-1,192,222,80,-1,117,150,116,-1,190,150,117,-1,241,195,221,-1,132,195,241,-1,81,208,82,-1,81,207,208,-1,4,81,166,-1,3,81,4,-1,164,130,88,-1,164,131,130,-1,209,208,219,-1,209,158,208,-1,88,152,15,-1,152,88,25,-1,193,211,122,-1,211,193,194,-1,204,119,162,-1,204,141,119,-1,14,60,142,-1,14,90,60,-1,194,58,211,-1,59,58,194,-1,27,18,171,-1,27,95,18,-1,61,120,103,-1,120,61,71,-1,135,71,70,-1,135,120,71,-1,120,136,163,-1,135,136,120,-1,219,17,209,-1,87,17,219,-1,164,205,131,-1,164,217,205,-1,206,172,218,-1,3,172,206,-1,219,207,217,-1,207,219,208,-1,162,241,220,-1,241,162,118,-1,221,123,200,-1,195,123,221,-1,201,188,202,-1,188,201,198,-1,240,125,79,-1,125,240,199,-1,196,145,223,-1,196,240,145,-1,185,223,128,-1,223,185,224,-1,130,146,28,-1,129,146,130,-1,148,156,161,-1,156,148,147,-1,142,137,140,-1,137,142,60,-1,241,72,132,-1,118,72,241,-1,112,102,93,-1,112,67,102,-1,69,138,70,-1,69,139,138,-1,216,212,89,-1,213,212,216,-1,140,119,142,-1,140,73,119,-1,43,110,108,-1,143,110,43,-1,41,106,8,-1,144,106,41,-1,37,218,127,-1,37,36,218,-1,41,40,111,-1,41,38,40,-1,220,221,203,-1,220,241,221,-1,202,192,189,-1,222,192,202,-1,1,225,80,-1,1,226,225,-1,151,31,77,-1,151,147,31,-1,197,227,168,-1,180,227,197,-1,4,229,5,-1,4,231,229,-1,239,186,230,-1,239,184,186,-1,238,149,226,-1,149,238,182,-1,165,237,84,-1,233,237,165,-1,215,234,216,-1,236,234,215,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lpreol2c_Coord',point=[(.59755,55.27356,2.47261),(.59345,55.25937,2.47254),(.6069,55.26072,2.51367),(.88136,55.21866,2.58495),(.88096,55.26576,2.57607),(.8529,55.24907,2.60432),(.72298,55.04117,2.58948),(.70428,55.01652,2.56909),(.7242,55.05631,2.55971),(.69631,55.01489,2.39035),(.71503,55.03287,2.39181),(.7034,55.02044,2.4075),(.6997,55.2056,2.36384),(.71823,55.21392,2.37333),(.71792,55.15706,2.35911),(.90687,55.01766,2.47258),(.89585,55.00865,2.44476),(.90187,55.04803,2.43797),(.86023,54.98527,2.47341),(.8653,55.00726,2.44906),(.88559,55.00491,2.44282),(.64152,54.99092,2.51552),(.6762,54.98275,2.53153),(.68228,54.99951,2.55776),(.85075,55.05989,2.39767),(.88424,54.97037,2.51288),(.85603,54.97583,2.56399),(.87769,54.96547,2.5119),(.86107,54.98241,2.56692),(.7888,55.0275,2.61774),(.78827,55.0329,2.62052),(.75209,55.05496,2.60935),(.75699,55.06653,2.61702),(.78584,55.05917,2.6231),(.78111,55.10822,2.62407),(.81774,55.04485,2.61631),(.84395,55.103,2.60882),(.81412,55.10587,2.62045),(.70218,55.01531,2.55179),(.70355,55.0217,2.56098),(.69925,55.01004,2.56116),(.70683,55.02367,2.53694),(.71437,55.01485,2.48101),(.73442,55.03935,2.46427),(.73388,55.04239,2.4902),(.71699,55.04366,2.41347),(.71474,55.04657,2.4257),(.70721,55.03166,2.41654),(.7618,55.08721,2.44725),(.7339,55.06506,2.4307),(.73703,55.0619,2.42005),(.69283,55.00917,2.42639),(.68705,54.99006,2.46758),(.71241,55.0156,2.46711),(.72749,55.04818,2.38076),(.74721,55.06603,2.38586),(.75632,55.0789,2.38733),(.76122,55.08543,2.43807),(.77066,55.18002,2.3801),(.77902,55.12946,2.36665),(.74491,55.12123,2.3566),(.83541,55.06149,2.40897),(.84118,55.05151,2.41362),(.77421,55.08415,2.44163),(.76446,55.0808,2.45268),(.75881,55.08347,2.45289),(.75093,55.07018,2.4981),(.75352,55.07047,2.50767),(.73829,55.06958,2.54206),(.76832,55.08701,2.43807),(.78161,55.07522,2.38048),(.80444,55.08592,2.38747),(.67625,55.02774,2.38448),(.69088,55.05325,2.36569),(.70266,55.0335,2.37323),(.79914,55.01633,2.58901),(.81703,55.00936,2.60821),(.72278,55.03867,2.59441),(.729,55.0647,2.60316),(.68907,55.05461,2.57683),(.58185,55.2202,2.47492),(.90609,55.21942,2.54646),(.90424,55.23708,2.49744),(.90121,55.28633,2.51469),(.88688,55.28689,2.46819),(.89004,55.23791,2.45091),(.84702,55.25497,2.42646),(.90941,55.0437,2.47171),(.89597,54.99396,2.51749),(.73675,55.22224,2.38286),(.74028,55.16623,2.36343),(.81203,55.02747,2.52045),(.81806,55.0164,2.54169),(.81107,55.03595,2.53551),(.83441,54.98479,2.55416),(.85528,54.97007,2.50109),(.78591,55.03108,2.59491),(.78413,55.03329,2.58087),(.67517,54.97867,2.45482),(.68688,54.98582,2.51201),(.74794,55.06988,2.47344),(.75655,55.07014,2.49464),(.75699,55.07124,2.50026),(.84621,55.05548,2.40057),(.74428,55.06199,2.37501),(.757,55.07267,2.37245),(.72886,55.05017,2.53209),(.7675,55.08531,2.4484),(.73165,55.05837,2.44626),(.72914,55.06576,2.43799),(.71161,55.04003,2.437),(.68854,54.99431,2.53499),(.80067,55.03363,2.55031),(.82586,55.0282,2.46343),(.82995,55.04119,2.45337),(.84326,55.02935,2.45254),(.65495,55.25432,2.38407),(.65306,55.19511,2.37367),(.66601,55.05453,2.37301),(.69518,55.09947,2.35424),(.80919,55.08394,2.37829),(.86832,55.08604,2.39698),(.85728,55.20397,2.41111),(.6356,54.98723,2.48169),(.66976,54.97597,2.50127),(.65153,55.05058,2.55259),(.66105,55.02556,2.55471),(.81344,55.17114,2.61646),(.78003,55.17948,2.61346),(.84576,55.0403,2.59943),(.87246,55.01231,2.57099),(.87796,55.03737,2.57129),(.66896,55.00531,2.40396),(.82043,55.00967,2.47998),(.75552,55.06819,2.47363),(.78397,55.07515,2.37719),(.78447,55.08802,2.37001),(.75503,55.08167,2.36622),(.76648,55.07418,2.37798),(.76675,55.07609,2.38693),(.72077,55.05958,2.36455),(.69662,55.14984,2.35384),(.72033,55.1092,2.35244),(.71418,55.02491,2.44638),(.7102,55.02031,2.52029),(.72778,55.10477,2.60528),(.82336,55.01546,2.60769),(.75117,55.05589,2.60568),(.75385,55.05377,2.60778),(.62492,55.25729,2.40262),(.62389,55.24417,2.39843),(.73076,55.044,2.59647),(.89344,54.98614,2.47925),(.73419,55.07282,2.53861),(.83352,55.04426,2.43898),(.69007,54.99575,2.41417),(.75011,55.05694,2.60151),(.61457,55.03005,2.51875),(.90038,55.17829,2.44572),(.69663,55.26103,2.38288),(.73603,55.07099,2.54585),(.76162,55.04851,2.60084),(.65379,55.08509,2.37003),(.81391,55.0945,2.37452),(.90675,55.04327,2.52072),(.84488,55.29672,2.45003),(.89527,55.27628,2.5439),(.6037,55.21871,2.51401),(.63198,55.2129,2.54239),(.6021,55.20068,2.51431),(.81811,55.01692,2.61121),(.88414,54.98119,2.47928),(.85164,55.22728,2.60284),(.60871,55.27519,2.51342),(.65543,55.26875,2.38963),(.69604,55.27496,2.38895),(.89056,55.28989,2.54797),(.89837,55.30071,2.51919),(.73345,55.23942,2.58959),(.68247,55.25397,2.5633),(.67938,55.24061,2.56618),(.73564,55.25081,2.58707),(.62704,55.27058,2.40835),(.81522,55.22786,2.61171),(.78164,55.23993,2.60688),(.7779,55.22674,2.60667),(.81625,55.24609,2.61219),(.63873,55.1509,2.55015),(.59913,55.14365,2.51298),(.59637,55.14777,2.41095),(.62591,55.18842,2.38963),(.6263,55.1451,2.38368),(.59465,55.18966,2.41576),(.85849,55.14199,2.39521),(.81312,55.13769,2.3768),(.64584,54.98884,2.45021),(.67617,55.168,2.57008),(.6758,55.22092,2.56792),(.60185,55.08426,2.51422),(.6437,55.09006,2.55155),(.60453,55.02997,2.47675),(.58521,55.08338,2.47329),(.57691,55.14947,2.47191),(.6051,55.08646,2.415),(.65257,55.14277,2.36705),(.88451,55.10126,2.57793),(.88282,55.16583,2.58226),(.91115,55.16592,2.53959),(.91413,55.16576,2.49306),(.90039,55.12546,2.43518),(.79763,55.25633,2.41793),(.80156,55.19462,2.39399),(.76721,55.23929,2.40035),(.77178,55.27887,2.41991),(.80118,55.29233,2.43596),(.71736,55.26276,2.39235),(.73992,55.26648,2.40318),(.91269,55.09532,2.52719),(.84628,55.16118,2.60859),(.91268,55.10689,2.47995),(.62911,55.08544,2.38806),(.61938,55.03206,2.42235),(.57908,55.19109,2.47375),(.73227,55.1822,2.59281),(.73215,55.23017,2.59023),(.5958,55.23147,2.42299),(.60227,55.25803,2.42989),(.63842,55.24986,2.54395),(.64128,55.26123,2.54288),(.84865,55.26379,2.60481),(.81703,55.26048,2.61074),(.8764,55.27987,2.57716),(.7994,55.30622,2.44174),(.84439,55.31051,2.4564),(.7358,55.2782,2.40748),(.7682,55.29165,2.42477),(.71668,55.27663,2.39861),(.88553,55.30179,2.47355),(.60625,55.27196,2.4336),(.78094,55.25334,2.60399),(.67653,55.10216,2.57545),(.64854,55.04168,2.38962)]))),
        Shape(DEF='rcenincc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rcenincc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,28,35,26,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,36,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,31,-1,61,62,63,-1,64,65,66,-1,67,56,58,-1,68,69,70,-1,71,72,73,-1,9,8,74,-1,75,76,77,-1,78,79,1,-1,80,62,81,-1,82,8,83,-1,79,84,1,-1,72,79,85,-1,86,81,87,-1,88,89,71,-1,34,90,91,-1,92,93,87,-1,94,75,95,-1,96,97,89,-1,9,98,46,-1,99,68,100,-1,68,70,100,-1,101,99,100,-1,102,103,104,-1,105,106,62,-1,107,20,54,-1,47,46,108,-1,109,11,110,-1,71,73,111,-1,92,112,93,-1,113,114,115,-1,116,117,60,-1,14,28,118,-1,29,31,60,-1,113,23,25,-1,119,120,121,-1,122,121,113,-1,18,111,19,-1,15,123,16,-1,12,41,13,-1,124,125,126,-1,127,61,63,-1,128,7,6,-1,129,130,2,-1,131,0,2,-1,131,2,130,-1,9,132,10,-1,128,133,7,-1,63,134,127,-1,124,44,125,-1,135,44,124,-1,136,52,137,-1,138,139,140,-1,122,113,25,-1,119,121,122,-1,24,104,25,-1,118,141,142,-1,15,118,143,-1,15,14,118,-1,116,60,59,-1,23,113,115,-1,112,144,93,-1,111,145,71,-1,146,6,3,-1,147,5,148,-1,43,149,125,-1,149,150,125,-1,109,53,11,-1,151,45,47,-1,151,152,45,-1,53,107,54,-1,102,55,103,-1,6,146,128,-1,105,62,61,-1,116,102,104,-1,101,95,77,-1,100,153,101,-1,72,71,89,-1,95,101,154,-1,89,88,96,-1,62,87,81,-1,91,155,34,-1,71,145,88,-1,87,85,86,-1,84,156,1,-1,82,74,8,-1,157,129,156,-1,158,159,160,-1,72,84,79,-1,144,161,93,-1,80,63,62,-1,75,77,95,-1,9,74,98,-1,162,26,35,-1,162,38,26,-1,152,132,45,-1,72,163,73,-1,69,164,70,-1,67,58,32,-1,64,66,165,-1,166,59,31,-1,167,36,52,-1,48,168,49,-1,169,108,46,-1,43,125,44,-1,102,39,41,-1,36,38,162,-1,34,67,32,-1,114,32,58,-1,29,170,30,-1,141,153,142,-1,20,22,54,-1,163,138,140,-1,171,136,137,-1,171,172,49,-1,171,137,172,-1,173,135,124,-1,174,8,10,-1,3,7,175,-1,61,176,105,-1,61,127,176,-1,8,177,83,-1,174,177,8,-1,175,4,3,-1,178,4,175,-1,4,179,5,-1,180,179,4,-1,181,126,182,-1,183,126,181,-1,41,184,13,-1,40,184,41,-1,185,49,172,-1,49,185,50,-1,186,14,16,-1,14,186,187,-1,73,19,111,-1,73,188,19,-1,55,122,103,-1,55,119,122,-1,189,20,143,-1,189,21,20,-1,154,118,28,-1,141,118,154,-1,115,24,23,-1,24,115,117,-1,155,112,190,-1,112,155,144,-1,191,146,147,-1,146,191,192,-1,193,181,194,-1,193,183,181,-1,195,5,179,-1,5,195,148,-1,53,196,107,-1,53,109,196,-1,42,108,169,-1,42,195,108,-1,136,169,46,-1,136,171,169,-1,187,162,35,-1,162,187,197,-1,30,198,199,-1,30,170,198,-1,33,200,201,-1,33,202,200,-1,101,66,99,-1,101,77,66,-1,202,120,200,-1,202,121,120,-1,84,203,156,-1,84,97,203,-1,98,167,46,-1,98,204,167,-1,26,205,27,-1,26,38,205,-1,205,158,94,-1,206,158,205,-1,76,88,165,-1,88,76,96,-1,112,207,190,-1,112,208,207,-1,90,17,91,-1,209,17,90,-1,17,209,18,-1,210,91,17,-1,161,91,210,-1,87,138,85,-1,93,138,87,-1,93,139,138,-1,85,78,86,-1,85,79,78,-1,211,82,159,-1,74,82,211,-1,157,83,129,-1,157,82,83,-1,0,78,1,-1,78,0,212,-1,206,159,158,-1,206,211,159,-1,139,161,210,-1,93,161,139,-1,145,209,64,-1,145,18,209,-1,111,18,145,-1,208,92,106,-1,92,208,112,-1,27,94,95,-1,94,27,205,-1,206,38,37,-1,205,38,206,-1,36,204,37,-1,167,204,36,-1,89,84,72,-1,97,84,89,-1,121,114,113,-1,202,114,121,-1,66,68,99,-1,66,65,68,-1,201,34,33,-1,34,201,90,-1,105,199,198,-1,105,213,199,-1,214,199,192,-1,199,214,30,-1,29,207,170,-1,207,29,56,-1,41,55,102,-1,41,12,55,-1,51,162,197,-1,36,162,51,-1,196,123,107,-1,196,215,123,-1,47,195,179,-1,108,195,47,-1,149,196,109,-1,196,149,48,-1,42,148,195,-1,42,135,148,-1,135,42,44,-1,183,191,173,-1,193,191,183,-1,166,39,59,-1,166,194,39,-1,3,147,146,-1,3,5,147,-1,187,28,14,-1,35,28,187,-1,101,141,154,-1,153,141,101,-1,142,143,118,-1,189,143,142,-1,70,22,21,-1,70,164,22,-1,188,17,19,-1,188,210,17,-1,215,16,123,-1,16,215,186,-1,197,172,51,-1,172,197,185,-1,13,110,11,-1,184,110,13,-1,182,125,150,-1,126,125,182,-1,177,129,83,-1,177,130,129,-1,134,80,216,-1,63,80,134,-1,217,180,218,-1,151,180,217,-1,129,1,156,-1,2,1,129,-1,219,128,213,-1,219,133,128,-1,212,220,221,-1,212,222,220,-1,178,180,4,-1,178,218,180,-1,150,184,182,-1,150,110,184,-1,52,172,137,-1,52,51,172,-1,185,187,186,-1,185,197,187,-1,140,210,188,-1,140,139,210,-1,164,119,22,-1,164,120,119,-1,100,21,189,-1,100,70,21,-1,58,115,114,-1,58,57,115,-1,33,114,202,-1,33,32,114,-1,192,193,214,-1,192,191,193,-1,40,194,181,-1,39,194,40,-1,169,43,42,-1,168,43,169,-1,169,49,168,-1,169,171,49,-1,167,136,46,-1,136,167,52,-1,170,208,198,-1,170,207,208,-1,30,166,31,-1,214,166,30,-1,64,223,65,-1,209,223,64,-1,69,201,200,-1,223,201,69,-1,200,164,69,-1,200,120,164,-1,203,158,160,-1,203,224,158,-1,45,9,46,-1,45,132,9,-1,74,204,98,-1,211,204,74,-1,75,96,76,-1,96,75,224,-1,165,77,76,-1,77,165,66,-1,56,190,207,-1,56,67,190,-1,91,144,155,-1,91,161,144,-1,221,78,212,-1,221,86,78,-1,138,72,85,-1,138,163,72,-1,157,159,82,-1,160,159,157,-1,81,221,80,-1,81,86,221,-1,88,64,165,-1,64,88,145,-1,190,34,155,-1,190,67,34,-1,106,87,62,-1,87,106,92,-1,224,94,158,-1,75,94,224,-1,224,97,96,-1,203,97,224,-1,37,211,206,-1,37,204,211,-1,160,156,203,-1,157,156,160,-1,68,223,69,-1,65,223,68,-1,223,90,201,-1,90,223,209,-1,107,143,20,-1,123,143,107,-1,123,15,143,-1,60,56,29,-1,57,56,60,-1,213,192,199,-1,213,146,192,-1,213,128,146,-1,198,106,105,-1,198,208,106,-1,55,11,53,-1,55,12,11,-1,215,48,50,-1,196,48,215,-1,179,151,47,-1,179,180,151,-1,48,43,168,-1,48,149,43,-1,150,109,110,-1,149,109,150,-1,147,173,191,-1,147,135,173,-1,147,148,135,-1,194,214,193,-1,214,194,166,-1,102,59,39,-1,59,102,116,-1,24,116,104,-1,116,24,117,-1,95,28,27,-1,95,154,28,-1,57,117,115,-1,57,60,117,-1,189,153,100,-1,189,142,153,-1,55,22,119,-1,54,22,55,-1,25,103,122,-1,103,25,104,-1,188,163,140,-1,163,188,73,-1,186,50,185,-1,50,186,215,-1,182,40,181,-1,182,184,40,-1,126,173,124,-1,173,126,183,-1,176,213,105,-1,219,213,176,-1,222,0,131,-1,212,0,222,-1,220,80,221,-1,80,220,216,-1,225,151,217,-1,152,151,225,-1,10,152,225,-1,152,10,132,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rcenincc_Coord',point=[(-.16893,55.21914,3.08085),(-.17296,55.14631,3.08215),(-.1991,55.17643,3.13492),(-.04501,55.21437,3.35319),(-.0764,55.24937,3.3541),(-.07417,55.21215,3.36761),(-.02973,55.18691,3.34759),(-.02977,55.19933,3.34004),(-.23629,55.16999,3.25589),(-.21838,55.21498,3.28786),(-.21511,55.23189,3.2837),(-.09561,54.86563,3.35093),(-.08263,54.85694,3.34542),(-.08123,54.86571,3.35357),(-.23838,54.88037,3.30988),(-.2215,54.86837,3.31141),(-.22208,54.87579,3.31801),(-.11848,54.98541,3.23594),(-.13168,54.97462,3.24164),(-.12968,54.98547,3.23527),(-.18502,54.85636,3.31732),(-.18384,54.84803,3.30496),(-.12829,54.84359,3.32082),(-.00967,54.8586,3.32121),(-.00892,54.86076,3.32977),(-.01439,54.85092,3.32908),(-.27091,54.9614,3.30094),(-.27162,54.95369,3.2857),(-.2684,54.89003,3.29286),(.00132,54.95978,3.2959),(.00458,55.02807,3.31753),(.00167,54.9688,3.32611),(-.01295,54.90277,3.27142),(-.04752,54.89986,3.2736),(-.05617,54.9438,3.25787),(-.26031,54.9509,3.32033),(-.23496,55.07345,3.33536),(-.26226,55.06163,3.29944),(-.26701,55.02128,3.31016),(-.03587,54.92033,3.36849),(-.06804,54.93325,3.3643),(-.06512,54.86705,3.35493),(-.12315,55.10929,3.37597),(-.12909,55.04902,3.37883),(-.0948,55.10783,3.37793),(-.1844,55.23193,3.33056),(-.19278,55.18351,3.33764),(-.15091,55.23054,3.34842),(-.17724,55.00047,3.35559),(-.19728,55.06392,3.34544),(-.20444,55.00437,3.34889),(-.21668,55.06727,3.33767),(-.20686,55.11799,3.33599),(-.13282,54.86673,3.34127),(-.129,54.85412,3.33178),(-.08337,54.85234,3.34022),(-.00543,54.94434,3.25445),(-.00248,54.90063,3.28228),(-.00527,54.901,3.27206),(-.0104,54.90698,3.35314),(.0003,54.905,3.32808),(-.02752,55.15416,3.16123),(-.05397,55.14066,3.10192),(-.05121,55.19897,3.10033),(-.17067,54.94642,3.24943),(-.17311,54.90265,3.25864),(-.20983,54.90488,3.24148),(-.02082,54.94824,3.24451),(-.17682,54.86037,3.27788),(-.13083,54.85303,3.29067),(-.1809,54.85308,3.28993),(-.15528,55.01713,3.17794),(-.14005,55.06744,3.12671),(-.13508,55.02156,3.18945),(-.23933,55.15913,3.25588),(-.26777,54.97458,3.21911),(-.24251,54.954,3.20864),(-.24982,54.91056,3.23137),(-.13399,55.1639,3.05612),(-.13736,55.11637,3.07707),(-.06204,55.20051,3.07754),(-.07539,55.15443,3.07555),(-.22959,55.14407,3.20253),(-.22875,55.15105,3.20071),(-.17942,55.07832,3.12182),(-.1069,55.11507,3.07547),(-.09851,55.16139,3.05549),(-.07914,55.10694,3.08949),(-.20113,54.98583,3.20164),(-.18989,55.01793,3.17019),(-.09048,54.94659,3.25825),(-.08408,54.98523,3.23819),(-.05435,55.05043,3.13781),(-.08621,55.06642,3.13141),(-.27364,54.98367,3.2342),(-.27223,54.93336,3.24568),(-.22941,54.99398,3.18983),(-.21556,55.03903,3.15998),(-.23343,55.17668,3.30071),(-.21449,54.86357,3.26536),(-.21626,54.85924,3.27595),(-.26276,54.87581,3.25482),(-.03734,54.87022,3.3554),(-.04262,54.85531,3.34246),(-.01232,54.86014,3.33839),(-.01727,55.09589,3.21531),(-.02629,55.06935,3.16224),(-.18335,54.86615,3.32994),(-.15519,55.18057,3.35617),(-.13406,54.94147,3.36459),(-.08987,54.93212,3.36208),(-.14074,54.98444,3.23316),(-.03554,55.02308,3.18364),(-.01135,54.84749,3.31334),(-.01316,54.85002,3.29789),(-.00647,54.86818,3.31548),(-.01014,54.87357,3.34457),(-.00564,54.87287,3.32918),(-.26691,54.87904,3.28908),(-.08276,54.8406,3.32848),(-.0812,54.84459,3.31141),(-.0453,54.84161,3.31342),(-.04643,54.84277,3.33089),(-.20776,54.87182,3.32309),(-.0839,55.1047,3.37954),(-.09362,55.04301,3.37247),(-.08271,55.043,3.37207),(-.02547,55.16174,3.17576),(-.01728,55.14194,3.33487),(-.20747,55.16582,3.15109),(-.20441,55.18127,3.15259),(-.16829,55.23434,3.08249),(-.20919,55.23015,3.29437),(-.0152,55.13846,3.31779),(-.04986,55.21381,3.10186),(-.08482,55.11751,3.37856),(-.19633,55.13028,3.33979),(-.19719,55.11739,3.34035),(-.10914,55.08205,3.11544),(-.10198,55.07107,3.12706),(-.10987,55.07339,3.12491),(-.26749,54.88019,3.27453),(-.26569,54.87149,3.27944),(-.22087,54.86396,3.3065),(-.06751,55.02233,3.18826),(-.16549,54.98214,3.22856),(-.01984,55.14247,3.35728),(-.05618,55.15885,3.37358),(-.08265,55.16765,3.37516),(-.13433,54.99602,3.37166),(-.09231,54.98776,3.3705),(-.15062,55.2767,3.33382),(-.18096,55.26746,3.31491),(-.26422,54.8734,3.26523),(-.2688,54.88651,3.27098),(-.05961,54.98708,3.22813),(-.20454,55.09856,3.13265),(-.21935,55.12759,3.17371),(-.26056,55.03596,3.21798),(-.2482,55.08451,3.21499),(-.2423,55.0795,3.19686),(-.08252,55.02198,3.19052),(-.24627,55.01375,3.33331),(-.11993,55.0714,3.12548),(-.12603,54.8481,3.30565),(-.20954,54.93951,3.22447),(-.00594,54.97408,3.36062),(-.22624,55.11919,3.32733),(-.17357,55.05399,3.35845),(-.16934,55.10896,3.35963),(-.002,55.01035,3.27436),(-.18788,55.11458,3.34675),(-.20753,55.06559,3.34051),(-.07293,55.10162,3.3791),(-.23102,55.18426,3.25057),(-.04483,55.22987,3.34814),(-.01745,55.11031,3.2236),(-.22366,55.16794,3.19811),(-.07406,55.2627,3.34842),(-.11953,55.23762,3.35977),(-.12113,55.27532,3.35014),(-.07048,54.989,3.37169),(-.08138,54.98838,3.37018),(-.0718,55.04301,3.37299),(-.07894,54.9327,3.36292),(-.21511,55.00579,3.34554),(-.22113,54.94675,3.33926),(-.23135,54.94804,3.33399),(-.1243,55.02215,3.19274),(-.21969,54.85551,3.293),(-.02538,54.98462,3.2211),(-.0462,55.0941,3.37814),(-.01285,55.0925,3.35685),(-.03677,55.04174,3.37674),(-.03612,54.97513,3.37555),(-.12004,55.17562,3.37119),(-.18089,54.94358,3.34917),(-.22407,55.00693,3.34216),(-.0036,55.05579,3.24792),(.00097,55.084,3.30509),(-.08502,54.84914,3.29672),(-.08676,54.90318,3.274),(-.04686,54.84569,3.29683),(-.23636,55.05118,3.1694),(-.25091,55.12006,3.29298),(-.27085,55.00866,3.27326),(-.26398,55.05246,3.26726),(-.00922,54.99339,3.235),(-.01532,55.0292,3.20144),(-.13324,54.94582,3.25863),(-.11297,55.02101,3.1946),(-.25559,55.09846,3.26152),(-.132,55.20668,3.0533),(-.00308,55.10297,3.30164),(-.00502,55.03346,3.3564),(-.21033,54.94566,3.34208),(-.06175,55.21527,3.0769),(-.1493,55.28986,3.32873),(-.11822,55.2885,3.34539),(-.00654,55.11315,3.29751),(-.09596,55.21538,3.0531),(-.0967,55.20079,3.05307),(-.13044,55.22117,3.05328),(-.1336,54.90358,3.26763),(-.25181,55.01137,3.19653),(-.18079,55.28048,3.30818)]))),
        Shape(DEF='rlatincc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.400,diffuseColor=(1,.9843,.9843),emissiveColor=(0,0,1),shininess=0.050)),
          geometry=IndexedFaceSet(DEF='rlatincc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,7,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,2,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,3,6,-1,38,39,40,-1,41,42,25,-1,43,44,45,-1,26,46,27,-1,47,48,49,-1,50,51,33,-1,41,52,53,-1,28,54,53,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,66,-1,55,67,37,-1,68,69,70,-1,70,71,72,-1,72,55,70,-1,73,74,75,-1,66,65,76,-1,75,77,13,-1,78,45,79,-1,14,80,15,-1,39,81,82,-1,59,83,84,-1,85,86,87,-1,83,59,88,-1,89,90,91,-1,92,93,94,-1,95,76,96,-1,96,97,98,-1,99,30,29,-1,94,100,18,-1,101,102,103,-1,102,104,103,-1,105,106,107,-1,108,22,109,-1,110,47,111,-1,60,112,113,-1,91,90,114,-1,81,115,14,-1,116,117,118,-1,119,77,120,-1,26,121,122,-1,123,95,50,-1,76,123,124,-1,57,56,84,-1,56,125,84,-1,76,95,123,-1,69,126,127,-1,89,128,129,-1,130,131,132,-1,55,57,70,-1,124,66,76,-1,133,132,134,-1,45,44,0,-1,117,40,133,-1,118,133,134,-1,135,37,136,-1,122,35,34,-1,26,2,1,-1,25,24,137,-1,138,139,140,-1,100,141,19,-1,142,14,16,-1,143,8,7,-1,144,36,11,-1,75,120,77,-1,75,145,120,-1,31,146,46,-1,147,148,149,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,159,160,126,-1,154,153,64,-1,158,157,161,-1,149,97,147,-1,64,162,154,-1,160,163,126,-1,158,164,156,-1,155,148,153,-1,46,122,31,-1,165,137,0,-1,35,122,121,-1,3,166,4,-1,132,131,134,-1,167,105,168,-1,100,19,18,-1,104,17,19,-1,137,165,25,-1,1,121,26,-1,169,170,29,-1,122,34,32,-1,32,31,122,-1,135,56,37,-1,118,117,133,-1,171,172,173,-1,0,137,45,-1,146,52,174,-1,41,174,52,-1,175,176,177,-1,93,60,131,-1,114,58,93,-1,161,89,129,-1,178,9,1,-1,126,179,127,-1,37,6,8,-1,69,127,70,-1,180,112,135,-1,180,113,112,-1,181,182,183,-1,184,144,185,-1,123,50,186,-1,9,178,187,-1,26,122,46,-1,120,171,119,-1,118,188,116,-1,91,114,92,-1,60,113,131,-1,76,147,96,-1,169,28,53,-1,30,108,109,-1,189,190,191,-1,92,94,18,-1,192,105,167,-1,53,54,42,-1,96,147,97,-1,96,193,95,-1,113,134,131,-1,92,114,93,-1,89,194,90,-1,84,125,59,-1,81,195,82,-1,78,79,196,-1,123,184,197,-1,72,67,55,-1,136,143,198,-1,64,153,65,-1,61,199,62,-1,60,93,58,-1,55,37,56,-1,71,70,127,-1,28,200,54,-1,118,134,188,-1,50,201,51,-1,47,49,202,-1,43,45,78,-1,171,120,172,-1,41,53,42,-1,117,38,40,-1,203,188,134,-1,37,67,3,-1,204,180,135,-1,184,123,186,-1,28,169,29,-1,23,25,42,-1,21,109,22,-1,139,205,140,-1,105,107,168,-1,204,198,119,-1,206,207,208,-1,6,5,7,-1,5,6,3,-1,0,178,1,-1,65,153,148,-1,209,210,211,-1,62,212,87,-1,213,152,151,-1,212,214,215,-1,212,62,214,-1,64,216,162,-1,64,179,216,-1,217,157,156,-1,217,199,157,-1,218,219,220,-1,218,211,219,-1,148,221,149,-1,148,155,221,-1,222,223,224,-1,223,222,225,-1,226,149,221,-1,226,97,149,-1,227,211,218,-1,227,209,211,-1,27,174,165,-1,46,174,27,-1,146,174,46,-1,173,180,204,-1,203,180,173,-1,11,177,228,-1,177,11,10,-1,166,208,4,-1,206,208,166,-1,229,168,107,-1,168,229,230,-1,231,142,16,-1,231,232,142,-1,233,103,141,-1,233,234,103,-1,235,236,237,-1,235,238,236,-1,135,198,204,-1,135,136,198,-1,72,206,166,-1,72,239,206,-1,115,196,79,-1,196,115,81,-1,48,97,213,-1,48,98,97,-1,124,127,66,-1,124,71,127,-1,240,181,175,-1,181,240,73,-1,58,88,59,-1,58,241,88,-1,158,129,224,-1,158,161,129,-1,69,159,126,-1,69,85,159,-1,186,34,184,-1,186,32,34,-1,175,10,240,-1,175,177,10,-1,43,75,74,-1,75,43,145,-1,116,38,117,-1,116,242,38,-1,146,243,52,-1,31,243,146,-1,49,213,151,-1,213,49,48,-1,238,108,244,-1,108,238,22,-1,235,167,20,-1,167,235,192,-1,21,245,246,-1,21,247,245,-1,224,248,222,-1,248,224,129,-1,249,250,251,-1,250,249,252,-1,253,132,138,-1,130,132,253,-1,189,254,237,-1,189,191,254,-1,232,195,142,-1,255,195,232,-1,254,252,192,-1,254,250,252,-1,256,205,82,-1,256,234,205,-1,106,249,102,-1,252,249,106,-1,256,103,234,-1,256,101,103,-1,251,129,128,-1,248,129,251,-1,91,17,257,-1,92,17,91,-1,17,92,18,-1,247,20,167,-1,21,20,247,-1,238,150,236,-1,244,150,238,-1,108,49,244,-1,108,202,49,-1,111,51,201,-1,111,170,51,-1,59,112,60,-1,59,125,112,-1,199,194,157,-1,199,61,194,-1,85,212,159,-1,212,85,87,-1,82,40,39,-1,205,40,82,-1,139,40,205,-1,45,24,79,-1,45,137,24,-1,240,9,187,-1,240,10,9,-1,73,187,74,-1,187,73,240,-1,71,239,72,-1,124,239,71,-1,203,113,180,-1,134,113,203,-1,209,236,150,-1,227,236,209,-1,171,204,119,-1,171,173,204,-1,241,63,88,-1,241,61,63,-1,182,73,12,-1,181,73,182,-1,98,47,110,-1,48,47,98,-1,111,202,99,-1,111,47,202,-1,78,145,43,-1,145,78,242,-1,79,23,115,-1,79,24,23,-1,207,239,197,-1,207,206,239,-1,197,124,123,-1,197,239,124,-1,243,33,51,-1,243,31,33,-1,80,42,54,-1,80,23,42,-1,235,22,238,-1,235,20,22,-1,233,138,140,-1,138,233,253,-1,15,231,16,-1,245,231,15,-1,230,167,168,-1,167,230,247,-1,13,119,7,-1,13,77,119,-1,183,5,4,-1,183,182,5,-1,228,176,208,-1,228,177,176,-1,11,35,121,-1,11,36,35,-1,2,165,0,-1,165,2,27,-1,152,258,259,-1,152,213,258,-1,211,260,219,-1,211,210,260,-1,224,164,158,-1,223,164,224,-1,159,215,160,-1,215,159,212,-1,261,262,263,-1,261,190,262,-1,226,213,97,-1,213,226,258,-1,189,218,190,-1,189,227,218,-1,152,209,150,-1,152,210,209,-1,65,147,76,-1,147,65,148,-1,188,172,116,-1,188,173,172,-1,188,203,173,-1,228,144,11,-1,228,185,144,-1,176,4,208,-1,176,183,4,-1,5,12,7,-1,5,182,12,-1,247,231,245,-1,247,230,231,-1,253,141,100,-1,253,233,141,-1,227,237,236,-1,189,237,227,-1,21,200,109,-1,21,246,200,-1,34,144,184,-1,36,144,34,-1,166,67,72,-1,166,3,67,-1,38,81,39,-1,38,196,81,-1,52,169,53,-1,52,243,169,-1,193,50,95,-1,50,193,201,-1,179,66,127,-1,64,66,179,-1,63,87,86,-1,63,62,87,-1,254,264,250,-1,264,254,191,-1,74,44,43,-1,74,187,44,-1,196,242,78,-1,242,196,38,-1,142,81,14,-1,142,195,81,-1,84,86,68,-1,86,84,83,-1,157,89,161,-1,157,194,89,-1,86,88,63,-1,86,83,88,-1,193,98,110,-1,193,96,98,-1,151,244,49,-1,151,150,244,-1,192,237,254,-1,237,192,235,-1,80,245,15,-1,80,246,245,-1,100,130,253,-1,94,130,100,-1,257,102,249,-1,17,102,257,-1,17,104,102,-1,248,250,264,-1,248,251,250,-1,101,255,265,-1,101,256,255,-1,107,265,229,-1,106,265,107,-1,255,229,265,-1,255,232,229,-1,105,252,106,-1,105,192,252,-1,255,82,195,-1,255,256,82,-1,102,265,106,-1,102,101,265,-1,222,264,261,-1,222,248,264,-1,249,128,257,-1,251,128,249,-1,257,89,91,-1,128,89,257,-1,28,109,200,-1,30,109,28,-1,99,108,30,-1,202,108,99,-1,110,201,193,-1,201,110,111,-1,61,90,194,-1,61,241,90,-1,68,85,69,-1,85,68,86,-1,14,23,80,-1,14,115,23,-1,41,165,174,-1,165,41,25,-1,187,0,44,-1,187,178,0,-1,50,32,186,-1,50,33,32,-1,13,73,75,-1,13,12,73,-1,183,175,181,-1,175,183,176,-1,135,125,56,-1,135,112,125,-1,57,68,70,-1,84,68,57,-1,139,133,40,-1,138,133,139,-1,133,138,132,-1,264,190,261,-1,264,191,190,-1,241,114,90,-1,114,241,58,-1,93,130,94,-1,130,93,131,-1,8,136,37,-1,8,143,136,-1,99,170,111,-1,99,29,170,-1,185,197,184,-1,197,185,207,-1,243,170,169,-1,243,51,170,-1,200,80,54,-1,246,80,200,-1,234,140,205,-1,140,234,233,-1,19,103,104,-1,141,103,19,-1,230,232,231,-1,230,229,232,-1,198,7,119,-1,143,7,198,-1,207,228,208,-1,185,228,207,-1,121,9,11,-1,9,121,1,-1,172,242,116,-1,120,242,172,-1,145,242,120,-1,220,190,218,-1,220,262,190,-1,217,62,199,-1,217,214,62,-1,259,210,152,-1,210,259,260,-1,225,261,263,-1,222,261,225,-1,179,163,216,-1,179,126,163,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rlatincc_Coord',point=[(-.32998,54.90764,3.22147),(-.30712,54.95562,3.2029),(-.31677,54.91013,3.22228),(-.34279,55.07151,3.10445),(-.34032,55.07379,3.10911),(-.36815,55.03338,3.11645),(-.36997,55.03383,3.11179),(-.38981,54.99534,3.11969),(-.38667,55.00548,3.11475),(-.30933,54.9836,3.19142),(-.31036,54.99319,3.18605),(-.3065,54.99377,3.18892),(-.38619,54.99519,3.1231),(-.39191,54.98767,3.12496),(-.37397,54.89503,3.2411),(-.36726,54.90135,3.24784),(-.37534,54.89933,3.24322),(-.45393,55.06524,3.19386),(-.45942,55.05584,3.18484),(-.45545,55.05587,3.19404),(-.34664,55.05752,3.28295),(-.34387,55.00226,3.28007),(-.32738,55.05834,3.27598),(-.33759,54.89538,3.25202),(-.33544,54.88874,3.23812),(-.31969,54.88944,3.2444),(-.31324,54.9108,3.2225),(-.31427,54.90702,3.22518),(-.30257,54.95994,3.26947),(-.28199,54.99297,3.25407),(-.30444,55.00608,3.27415),(-.28072,54.95196,3.2154),(-.27646,54.98057,3.19819),(-.27014,54.97798,3.20583),(-.29643,54.98372,3.19685),(-.29934,54.9656,3.20254),(-.30314,54.99042,3.19157),(-.38039,55.02574,3.10491),(-.42581,54.88852,3.18646),(-.43334,54.8965,3.19712),(-.45372,54.90238,3.16935),(-.2955,54.89633,3.24751),(-.32153,54.89817,3.25495),(-.3897,54.90357,3.1895),(-.36028,54.90336,3.20977),(-.36228,54.89296,3.21652),(-.30911,54.91149,3.22287),(-.27226,55.05828,3.23756),(-.27467,55.10053,3.22746),(-.28382,55.10691,3.24516),(-.25682,55.01067,3.19399),(-.27145,54.98795,3.23309),(-.29162,54.91266,3.24687),(-.29635,54.90882,3.25416),(-.31914,54.90977,3.26243),(-.35823,55.05732,3.07553),(-.39772,55.01751,3.07443),(-.37133,55.0548,3.06645),(-.4643,55.04906,3.11201),(-.45073,55.03522,3.09304),(-.46671,54.9972,3.11122),(-.43633,55.12946,3.10837),(-.41133,55.15253,3.08471),(-.42034,55.11832,3.08515),(-.26171,55.16755,3.03629),(-.23977,55.14611,3.07484),(-.26741,55.13723,3.04184),(-.35088,55.06405,3.08924),(-.3621,55.09489,3.04369),(-.3218,55.13306,3.022),(-.33728,55.09258,3.04762),(-.30796,55.09789,3.05883),(-.32606,55.08554,3.08734),(-.36158,54.99418,3.14635),(-.37296,54.95432,3.16623),(-.40052,54.95605,3.1468),(-.24484,55.10574,3.10853),(-.41595,54.95434,3.13207),(-.39606,54.89415,3.19684),(-.36659,54.88367,3.22311),(-.33866,54.90893,3.26309),(-.40758,54.89305,3.22032),(-.43706,54.90878,3.20406),(-.43127,55.06551,3.08181),(-.39875,55.0592,3.06275),(-.3617,55.13949,3.03942),(-.40164,55.10667,3.0631),(-.38941,55.14779,3.06274),(-.43822,55.07228,3.09003),(-.44937,55.15689,3.16373),(-.45947,55.09551,3.12495),(-.46307,55.10075,3.15931),(-.4698,55.05583,3.15673),(-.47427,54.99996,3.125),(-.47592,55.00884,3.15462),(-.24852,55.05315,3.16889),(-.25165,55.09325,3.17626),(-.26321,55.13241,3.18703),(-.26243,55.0951,3.20275),(-.28019,55.00995,3.25411),(-.45976,55.00663,3.17838),(-.44101,55.00672,3.22155),(-.43942,55.05875,3.22249),(-.4507,55.00572,3.196),(-.45085,55.05674,3.20298),(-.37654,55.06833,3.26767),(-.41302,55.0616,3.25169),(-.38632,55.05954,3.26462),(-.3081,55.05915,3.26906),(-.32416,55.00417,3.27709),(-.26736,55.05453,3.22361),(-.27272,55.01152,3.24364),(-.44915,54.9924,3.08915),(-.46848,54.9503,3.1129),(-.47128,55.05461,3.12873),(-.37077,54.88831,3.23564),(-.44432,54.904,3.15223),(-.45123,54.89639,3.16158),(-.47254,54.91392,3.13044),(-.4197,54.95393,3.12851),(-.43558,54.91373,3.14947),(-.30283,54.95625,3.2046),(-.2988,54.95533,3.2066),(-.26625,55.0579,3.1423),(-.28525,55.09577,3.07857),(-.43196,55.02492,3.07482),(-.30774,55.16954,3.02079),(-.28922,55.1377,3.02918),(-.43869,55.1611,3.19048),(-.42946,55.20144,3.18892),(-.47766,54.96211,3.14814),(-.47618,54.95583,3.13125),(-.47719,54.92557,3.14581),(-.47736,54.91799,3.13954),(-.47322,54.92901,3.12554),(-.42251,54.98224,3.09014),(-.40058,54.99102,3.10992),(-.33259,54.89803,3.23041),(-.46074,54.91817,3.16953),(-.45475,54.91126,3.17475),(-.45482,54.91572,3.17709),(-.45422,55.00621,3.18651),(-.3834,54.9015,3.23894),(-.3934,54.9939,3.11643),(-.30183,55.00214,3.18365),(-.41398,54.90668,3.17027),(-.28921,54.91478,3.22471),(-.2552,55.12833,3.1528),(-.24289,55.16129,3.08778),(-.25308,55.14163,3.1455),(-.31783,55.15179,3.25741),(-.28635,55.15111,3.23509),(-.28792,55.1653,3.23165),(-.24315,55.16722,3.06828),(-.24239,55.1819,3.06786),(-.24582,55.16935,3.10712),(-.42765,55.19192,3.13988),(-.4334,55.17649,3.13991),(-.42964,55.209,3.17033),(-.35315,55.16134,3.0378),(-.34771,55.17693,3.03729),(-.43366,55.1957,3.16811),(-.25898,55.18225,3.03265),(-.30665,55.18389,3.01954),(-.42513,55.22605,3.16944),(-.31727,54.89597,3.23303),(-.33791,55.07577,3.10543),(-.3697,55.05854,3.27243),(-.37806,55.05891,3.26864),(-.28734,54.95534,3.25168),(-.27729,54.98977,3.24773),(-.43872,54.91475,3.14646),(-.43989,54.91251,3.14766),(-.44131,54.91629,3.14399),(-.29296,54.90131,3.23585),(-.32148,55.03251,3.15075),(-.31436,55.06722,3.12601),(-.30966,55.03117,3.15945),(-.31755,54.95409,3.19879),(-.28417,55.1691,3.02209),(-.44461,54.95371,3.11076),(-.35125,55.03208,3.13173),(-.36523,55.03195,3.11997),(-.33907,55.06974,3.11301),(-.28782,55.02725,3.16794),(-.30109,55.03312,3.16147),(-.27116,55.01608,3.17703),(-.34185,54.95268,3.18656),(-.46684,54.92125,3.12681),(-.36044,55.1984,3.25275),(-.35795,55.25534,3.23618),(-.37088,55.199,3.24854),(-.37225,55.10801,3.27035),(-.2576,55.05385,3.20317),(-.44329,55.14437,3.1305),(-.4075,54.90759,3.22752),(-.40316,54.88651,3.20591),(-.28839,55.06447,3.1338),(-.41333,54.96629,3.12228),(-.4264,55.15652,3.10945),(-.32479,54.95708,3.27257),(-.26538,55.01125,3.22741),(-.2806,55.05933,3.24893),(-.46231,54.92871,3.12404),(-.42351,54.9539,3.12578),(-.44981,54.91363,3.18542),(-.30849,55.07315,3.12154),(-.30581,55.06963,3.12715),(-.31056,55.07104,3.12534),(-.32535,55.19955,3.24106),(-.31661,55.20031,3.2365),(-.32524,55.21074,3.23713),(-.38611,55.15646,3.06149),(-.27416,55.14147,3.21481),(-.40724,55.16658,3.08522),(-.38164,55.17177,3.06284),(-.28188,55.18412,3.01896),(-.42102,55.17128,3.11016),(-.34189,55.23609,3.23711),(-.3245,55.22748,3.22972),(-.34174,55.25205,3.23154),(-.25024,55.16132,3.13008),(-.40482,55.25837,3.20574),(-.41792,55.2474,3.18043),(-.42202,55.23282,3.18577),(-.40394,55.271,3.19884),(-.26468,55.14651,3.18433),(-.34266,55.1993,3.24774),(-.3056,55.0327,3.16122),(-.38497,55.00182,3.25981),(-.37677,55.00157,3.264),(-.37817,54.95536,3.25512),(-.38612,54.95581,3.25051),(-.45537,54.95965,3.1811),(-.45132,54.95934,3.19032),(-.34799,55.10823,3.27838),(-.33547,55.15517,3.26119),(-.35309,55.15854,3.26498),(-.32771,55.10996,3.27067),(-.29805,55.08387,3.10228),(-.33093,54.99011,3.17076),(-.44964,55.08403,3.10625),(-.41955,54.89671,3.1776),(-.28154,54.95401,3.24098),(-.31241,55.11235,3.26434),(-.36993,54.95499,3.25901),(-.34169,54.9549,3.27497),(-.36847,55.00132,3.26791),(-.42008,55.19984,3.20966),(-.43249,55.11657,3.22152),(-.40259,55.15913,3.24576),(-.42695,55.16386,3.21591),(-.40517,55.11517,3.25326),(-.46127,54.95992,3.17332),(-.37544,55.15995,3.25909),(-.41419,54.96042,3.23595),(-.44078,54.96045,3.21103),(-.4471,55.11178,3.19348),(-.27379,55.15431,3.20815),(-.29022,55.1842,3.22507),(-.30111,55.19813,3.22713),(-.38975,55.26729,3.2214),(-.35539,55.26833,3.23193),(-.38755,55.28037,3.21714),(-.39787,55.20056,3.23769),(-.41575,55.00854,3.24671)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesTeethcTop.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesTeethcTop.py load and self-test diagnostics complete.")
