####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesSpine.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesSpine.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Spine',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesSpine.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesSpine.x3d'),
    Transform(DEF='SpineSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Viewpoint(DEF='SpineFront',description='Spine',fieldOfView=0.785,position=(-.19509,43.5537,19.0408)),
      Group(DEF='spine',
        #  c4disc c5 c5disc c6 c6disc c7 c7disc t t1disc t2 t2disc t3 t3disc t4 t4disc t5 t5disc t6 t6disc t7 t7disc t8 t8disc t9 t9disc t10 t10disc t11 t11disc t12 t12disc lum l1disk l2 l2disk l3 l3disk l4 l4disk l5 l5disc 
        children=[
        Shape(DEF='c4disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='c4disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,5,6,-1,7,8,9,-1,10,11,12,-1,13,11,10,-1,14,15,16,-1,17,18,19,-1,12,11,20,-1,21,22,23,-1,10,24,25,-1,16,26,27,-1,28,29,30,-1,31,30,29,-1,32,33,34,-1,35,36,9,-1,23,8,37,-1,38,31,39,-1,40,41,42,-1,43,44,45,-1,46,47,0,-1,48,49,50,-1,51,45,4,-1,1,4,3,-1,52,53,54,-1,54,55,52,-1,53,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,35,-1,66,67,33,-1,57,56,18,-1,14,59,68,-1,69,14,70,-1,70,14,71,-1,72,1,0,-1,46,0,73,-1,49,40,34,-1,56,13,19,-1,20,74,75,-1,65,76,36,-1,77,22,78,-1,60,79,58,-1,53,57,80,-1,81,52,55,-1,82,83,84,-1,62,85,84,-1,54,86,87,-1,88,62,87,-1,68,58,79,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,45,51,98,-1,50,99,100,-1,43,101,102,-1,103,104,105,-1,106,107,101,-1,47,95,97,-1,28,41,40,-1,7,108,109,-1,32,110,33,-1,110,32,111,-1,111,112,110,-1,113,31,73,-1,40,114,34,-1,115,16,116,-1,117,118,119,-1,14,16,115,-1,21,119,120,-1,117,37,8,-1,121,9,112,-1,122,123,69,-1,26,16,15,-1,93,2,3,-1,2,1,3,-1,34,33,67,-1,3,94,93,-1,91,122,69,-1,124,121,112,-1,7,117,8,-1,120,12,21,-1,111,124,112,-1,18,17,125,-1,115,71,14,-1,20,11,13,-1,19,13,25,-1,117,109,118,-1,125,126,127,-1,113,73,128,-1,112,36,110,-1,7,109,117,-1,39,31,113,-1,101,99,106,-1,103,105,129,-1,101,105,102,-1,99,98,100,-1,45,98,43,-1,95,46,96,-1,92,130,93,-1,89,91,70,-1,68,79,131,-1,88,63,62,-1,55,54,87,-1,81,62,84,-1,84,132,82,-1,81,133,52,-1,80,54,53,-1,78,75,77,-1,65,36,35,-1,75,78,20,-1,66,33,110,-1,67,49,34,-1,47,72,0,-1,71,89,70,-1,14,69,59,-1,46,73,29,-1,29,96,46,-1,57,18,80,-1,56,19,18,-1,64,35,134,-1,58,68,59,-1,53,52,56,-1,70,91,69,-1,1,72,4,-1,51,4,72,-1,50,100,48,-1,46,95,47,-1,40,42,114,-1,38,30,31,-1,23,134,8,-1,36,112,9,-1,34,114,32,-1,31,29,73,-1,28,30,41,-1,116,16,27,-1,37,21,23,-1,12,20,78,-1,19,25,17,-1,10,25,13,-1,12,120,10,-1,121,7,9,-1,94,3,6,-1,122,91,135,-1,125,80,18,-1,2,73,0,-1,136,137,138,-1,136,90,137,-1,21,117,119,-1,117,21,37,-1,139,140,24,-1,139,141,140,-1,142,143,144,-1,143,142,145,-1,146,147,148,-1,147,146,149,-1,126,141,150,-1,126,140,141,-1,151,128,152,-1,151,113,128,-1,108,121,153,-1,121,108,7,-1,154,108,153,-1,154,155,108,-1,38,156,157,-1,38,158,156,-1,159,113,151,-1,39,113,159,-1,107,65,129,-1,107,76,65,-1,50,106,99,-1,106,50,160,-1,104,161,162,-1,104,103,161,-1,101,98,99,-1,98,101,43,-1,163,164,165,-1,164,163,166,-1,100,96,48,-1,97,96,100,-1,90,167,137,-1,167,90,89,-1,131,86,168,-1,131,79,86,-1,135,169,61,-1,136,169,135,-1,169,170,85,-1,171,170,169,-1,87,81,55,-1,87,62,81,-1,161,132,162,-1,132,161,82,-1,172,82,161,-1,77,82,172,-1,66,36,76,-1,66,110,36,-1,125,168,80,-1,168,125,127,-1,93,152,128,-1,93,130,152,-1,130,173,152,-1,130,174,173,-1,48,29,28,-1,48,96,29,-1,23,64,134,-1,172,64,23,-1,69,60,59,-1,60,69,123,-1,52,74,56,-1,52,133,74,-1,85,61,169,-1,85,62,61,-1,171,136,138,-1,171,169,136,-1,174,137,167,-1,174,175,137,-1,6,165,164,-1,176,165,6,-1,44,102,176,-1,102,44,43,-1,49,160,50,-1,160,49,67,-1,64,129,65,-1,129,64,103,-1,157,30,38,-1,157,41,30,-1,151,149,159,-1,151,177,149,-1,146,156,158,-1,156,146,145,-1,155,109,108,-1,155,142,109,-1,17,24,140,-1,25,24,17,-1,116,148,147,-1,116,27,148,-1,144,150,141,-1,150,144,143,-1,120,24,10,-1,120,139,24,-1,78,21,12,-1,21,78,22,-1,177,178,179,-1,173,178,177,-1,173,167,178,-1,173,174,167,-1,92,6,164,-1,92,94,6,-1,175,138,137,-1,166,138,175,-1,109,144,118,-1,109,142,144,-1,143,146,148,-1,145,146,143,-1,149,179,147,-1,149,177,179,-1,26,150,27,-1,26,126,150,-1,152,177,151,-1,177,152,173,-1,8,35,9,-1,134,35,8,-1,180,121,124,-1,180,153,121,-1,157,155,154,-1,156,155,157,-1,158,39,159,-1,158,38,39,-1,180,114,42,-1,114,180,32,-1,44,4,45,-1,44,5,4,-1,51,47,97,-1,51,72,47,-1,76,106,66,-1,106,76,107,-1,181,162,182,-1,181,104,162,-1,182,165,181,-1,163,165,182,-1,98,97,100,-1,98,51,97,-1,79,87,86,-1,87,79,88,-1,171,182,170,-1,171,163,182,-1,162,170,182,-1,132,170,162,-1,83,77,75,-1,83,82,77,-1,60,88,79,-1,60,123,88,-1,61,122,135,-1,61,63,122,-1,48,40,49,-1,48,28,40,-1,68,15,14,-1,15,68,131,-1,178,89,71,-1,178,167,89,-1,15,168,127,-1,15,131,168,-1,2,128,73,-1,2,93,128,-1,20,56,74,-1,56,20,13,-1,77,23,22,-1,77,172,23,-1,135,90,136,-1,90,135,91,-1,75,133,83,-1,74,133,75,-1,83,81,84,-1,83,133,81,-1,132,85,170,-1,84,85,132,-1,168,54,80,-1,168,86,54,-1,138,163,171,-1,138,166,163,-1,63,123,122,-1,63,88,123,-1,92,174,130,-1,175,174,92,-1,176,5,44,-1,176,6,5,-1,181,176,102,-1,181,165,176,-1,102,104,181,-1,102,105,104,-1,101,129,105,-1,129,101,107,-1,66,160,67,-1,106,160,66,-1,103,172,161,-1,103,64,172,-1,154,41,157,-1,154,42,41,-1,159,146,158,-1,149,146,159,-1,156,142,155,-1,145,142,156,-1,42,153,180,-1,42,154,153,-1,180,111,32,-1,111,180,124,-1,17,126,125,-1,17,140,126,-1,115,147,179,-1,147,115,116,-1,143,27,150,-1,143,148,27,-1,118,141,139,-1,118,144,141,-1,120,118,139,-1,119,118,120,-1,71,179,178,-1,71,115,179,-1,126,15,127,-1,126,26,15,-1,164,175,92,-1,175,164,166,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c4disc_Coord',point=[(-.27309,53.79235,-.73396),(-.24914,53.75068,-.74387),(-.22763,53.74748,-.74604),(-.223,53.70555,-.75947),(-.23941,53.70579,-.76522),(-.22677,53.70134,-.77423),(-.16324,53.69224,-.76181),(-.117,53.92347,-1.20341),(-.10808,53.89732,-1.19871),(-.20861,53.90666,-1.18822),(.29028,53.93079,-1.16121),(.28178,53.92147,-1.17246),(.20922,53.90674,-1.18689),(.31234,53.92787,-1.15583),(.268,53.84321,-.75936),(.32432,53.9249,-.82918),(.24985,53.88776,-.77883),(.31071,53.94223,-1.05534),(.33878,53.94566,-1.05549),(.32972,53.93746,-1.13085),(.2621,53.90567,-1.17308),(.1091,53.89924,-1.19965),(.08822,53.85775,-1.17156),(0,53.8586,-1.17077),(.2876,53.93365,-1.13933),(.31878,53.93787,-1.14056),(.27706,53.91871,-.86378),(.19544,53.91123,-.85463),(-.32286,53.95091,-.90482),(-.316,53.9092,-.82904),(-.27706,53.91871,-.86378),(-.22753,53.87439,-.77621),(-.31917,53.93793,-1.14057),(-.32984,53.93803,-1.13375),(-.34594,53.95355,-1.05799),(-.19074,53.88837,-1.17978),(-.26203,53.90664,-1.17595),(0,53.9016,-1.19138),(-.19544,53.91123,-.85463),(-.18575,53.86215,-.77509),(-.32956,53.95655,-.96166),(-.2702,53.93845,-.95659),(-.27165,53.93655,-1.04951),(-.22115,53.77498,-.92511),(-.22525,53.73963,-.84191),(-.234,53.7452,-.84071),(-.29338,53.8369,-.74314),(-.28801,53.79082,-.73871),(-.35009,53.93251,-.88912),(-.36394,53.93519,-.97461),(-.32994,53.90744,-.97837),(-.26589,53.78492,-.82213),(.28712,53.89407,-1.07416),(.32317,53.90751,-1.04193),(.32994,53.90744,-.97837),(.276,53.86743,-.98934),(.29868,53.91149,-1.11095),(.32471,53.93017,-1.05058),(.29897,53.82527,-.75565),(.29032,53.81412,-.72664),(.28801,53.79082,-.73871),(.22525,53.73963,-.84191),(.22115,53.77498,-.92511),(.234,53.7452,-.84071),(-.07454,53.81864,-1.13736),(-.16815,53.85112,-1.1351),(-.30251,53.91307,-1.10794),(-.35335,53.94523,-1.07256),(.30676,53.84272,-.73788),(.2479,53.74959,-.72815),(.2171,53.73515,-.72361),(.17477,53.79434,-.71052),(-.26723,53.75338,-.74205),(-.24798,53.83816,-.76424),(.22468,53.8756,-1.12783),(.16867,53.85193,-1.13588),(-.22464,53.87552,-1.12765),(.07463,53.81873,-1.13718),(.18616,53.88085,-1.17093),(.31619,53.86719,-.80757),(.36553,53.93649,-.97443),(.2172,53.81059,-1.0006),(.07203,53.79952,-1.10239),(.15667,53.82957,-1.09663),(.15854,53.78328,-.99507),(.16197,53.75755,-.91546),(.32752,53.89497,-.88803),(.27512,53.82644,-.9131),(.26589,53.78492,-.82213),(.16547,53.71784,-.70499),(.16561,53.6941,-.74217),(.21681,53.70268,-.75453),(-.07234,53.67906,-.72613),(-.16646,53.72603,-.70558),(-.16632,53.69502,-.74284),(-.29897,53.82527,-.75565),(-.33055,53.89402,-.80768),(-.31619,53.86719,-.80757),(-.27512,53.82644,-.9131),(-.276,53.86743,-.98934),(-.32752,53.89497,-.88803),(-.2172,53.81059,-1.0006),(-.16197,53.75755,-.91546),(-.07203,53.79952,-1.10239),(-.07547,53.76764,-.99375),(-.15854,53.78328,-.99507),(-.28712,53.89407,-1.07416),(-.21509,53.85649,-1.08336),(-.12026,53.93562,-1.12943),(0,53.94686,-1.1319),(-.31884,53.93122,-1.15496),(-.29893,53.93189,-1.16202),(-.28159,53.92197,-1.17201),(-.17928,53.84458,-.72385),(-.31798,53.94329,-1.05642),(.17928,53.84458,-.72385),(.18575,53.86215,-.77509),(0,53.92568,-1.1848),(.12026,53.93562,-1.12943),(.117,53.92347,-1.20341),(.20983,53.92085,-1.18393),(-.2097,53.92091,-1.18371),(.23632,53.70518,-.75895),(.26723,53.75338,-.74205),(-.29011,53.93098,-1.1598),(.32963,53.95251,-.96292),(.2702,53.93845,-.95659),(.32712,53.94886,-.90259),(-.17517,53.79761,-.71076),(-.15667,53.82957,-1.09663),(-.07783,53.70566,-.68179),(.34349,53.90407,-.80063),(.07547,53.76764,-.99375),(.21509,53.85649,-1.08336),(-.08907,53.86017,-1.17369),(.21441,53.69957,-.77181),(.16324,53.69224,-.76181),(.07249,53.6801,-.7266),(.06947,53.67873,-.74708),(.21443,53.93334,-1.13282),(.27165,53.93655,-1.04951),(.21173,53.93864,-1.03879),(0,53.95546,-1.03358),(.1163,53.94391,-.93786),(.11861,53.94649,-1.03767),(0,53.94755,-.93082),(0,53.91934,-.8447),(.1147,53.85182,-.7645),(.11854,53.91612,-.85179),(0,53.85083,-.75168),(.20611,53.93662,-.9548),(-.09689,53.82525,-.70008),(-.08842,53.77271,-.68634),(-.21443,53.93334,-1.13282),(-.21173,53.93864,-1.03879),(-.11861,53.94649,-1.03767),(-.1163,53.94391,-.93786),(-.20611,53.93662,-.9548),(-.11854,53.91612,-.85179),(-.1147,53.85182,-.7645),(-.32689,53.91935,-1.04721),(0,53.78316,-1.09408),(0,53.75294,-.99226),(0,53.69201,-.8036),(-.06947,53.67873,-.74708),(-.07885,53.70341,-.81955),(0,53.66764,-.73952),(.07735,53.70265,-.68159),(.35971,53.92825,-.88417),(.16444,53.72344,-.83381),(.07771,53.7335,-.9058),(.07885,53.70341,-.81955),(0,53.81252,-1.13694),(0,53.76856,-.6685),(0,53.69521,-.66879),(0,53.66886,-.71904),(-.16444,53.72344,-.83381),(0,53.81823,-.67822),(.08887,53.77551,-.68653),(.09689,53.82525,-.70008),(-.2876,53.93365,-1.13933),(-.07771,53.7335,-.9058),(0,53.71684,-.88501)]))),
        Shape(DEF='c5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='c5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,11,10,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,32,31,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,63,62,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,109,118,-1,100,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,126,125,61,-1,130,131,132,-1,133,134,135,-1,136,132,137,-1,113,138,139,-1,140,141,142,-1,143,144,145,-1,146,147,121,-1,148,149,130,-1,150,151,152,-1,151,146,152,-1,153,146,151,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,98,97,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,176,177,178,-1,179,180,181,-1,181,101,182,-1,101,183,184,-1,185,186,187,-1,73,79,78,-1,188,189,190,-1,170,191,192,-1,183,193,155,-1,187,194,195,-1,196,197,198,-1,199,200,201,-1,161,202,203,-1,204,198,158,-1,205,206,207,-1,208,209,210,-1,165,211,208,-1,212,213,214,-1,165,215,163,-1,216,217,218,-1,20,24,219,-1,220,221,222,-1,223,9,11,-1,224,225,226,-1,227,27,26,-1,228,229,230,-1,231,232,233,-1,234,235,236,-1,237,30,238,-1,239,240,238,-1,241,22,242,-1,243,225,224,-1,244,245,246,-1,247,248,249,-1,250,251,252,-1,244,253,1,-1,254,255,256,-1,257,241,258,-1,259,260,261,-1,262,244,263,-1,264,2,1,-1,265,42,41,-1,266,39,267,-1,268,41,269,-1,270,271,272,-1,273,274,271,-1,37,275,276,-1,277,278,276,-1,279,280,48,-1,281,282,57,-1,51,283,49,-1,284,285,286,-1,287,65,70,-1,69,62,288,-1,289,64,290,-1,291,292,149,-1,149,292,293,-1,294,66,65,-1,44,46,295,-1,296,297,298,-1,299,72,300,-1,80,301,302,-1,303,304,300,-1,304,305,299,-1,102,111,119,-1,183,101,120,-1,306,90,85,-1,84,307,308,-1,309,310,311,-1,312,313,314,-1,315,316,317,-1,315,318,319,-1,320,321,312,-1,322,323,308,-1,324,325,326,-1,327,328,329,-1,329,330,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,343,-1,344,345,346,-1,347,348,340,-1,349,350,351,-1,352,353,354,-1,352,355,356,-1,352,357,358,-1,351,359,360,-1,361,362,348,-1,363,344,364,-1,365,366,367,-1,368,369,370,-1,371,360,359,-1,372,373,374,-1,375,361,376,-1,377,375,378,-1,379,380,381,-1,382,383,384,-1,385,386,387,-1,388,389,390,-1,391,392,393,-1,394,395,396,-1,397,398,399,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,401,403,408,-1,409,410,411,-1,412,413,414,-1,415,416,412,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,420,-1,428,429,424,-1,430,431,432,-1,433,0,434,-1,435,436,437,-1,434,431,438,-1,439,440,441,-1,442,443,444,-1,445,446,447,-1,448,449,450,-1,451,452,453,-1,454,455,456,-1,457,458,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,484,488,-1,489,490,491,-1,492,493,394,-1,494,495,496,-1,480,497,498,-1,499,500,501,-1,502,503,504,-1,483,505,506,-1,507,508,509,-1,510,511,512,-1,513,514,515,-1,449,448,516,-1,517,518,519,-1,520,486,485,-1,520,333,486,-1,521,522,523,-1,524,469,525,-1,469,526,525,-1,527,498,528,-1,488,529,475,-1,499,504,503,-1,530,375,531,-1,532,533,534,-1,363,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,508,507,-1,547,548,549,-1,550,410,551,-1,548,547,507,-1,549,548,552,-1,553,554,544,-1,555,506,556,-1,557,558,556,-1,559,560,561,-1,562,563,564,-1,517,564,563,-1,565,508,546,-1,566,567,568,-1,569,570,571,-1,572,449,332,-1,573,574,575,-1,365,367,576,-1,577,578,579,-1,345,344,580,-1,581,582,583,-1,381,380,384,-1,584,585,586,-1,587,588,589,-1,590,591,348,-1,396,404,400,-1,592,593,594,-1,595,596,597,-1,598,599,600,-1,601,584,602,-1,603,601,604,-1,602,605,606,-1,607,608,411,-1,609,610,611,-1,407,422,612,-1,423,573,613,-1,614,615,616,-1,415,617,618,-1,619,620,621,-1,622,623,624,-1,416,415,618,-1,625,626,627,-1,628,626,629,-1,630,631,632,-1,633,634,635,-1,623,636,624,-1,637,638,639,-1,640,641,642,-1,639,643,644,-1,645,646,647,-1,458,648,649,-1,650,651,652,-1,464,463,653,-1,654,655,656,-1,0,657,434,-1,658,659,660,-1,661,662,459,-1,644,467,663,-1,664,665,573,-1,652,651,638,-1,467,637,663,-1,650,466,666,-1,667,653,463,-1,668,669,635,-1,444,445,670,-1,671,672,673,-1,674,675,676,-1,673,416,671,-1,677,678,615,-1,424,429,679,-1,680,679,426,-1,420,616,615,-1,598,681,599,-1,409,682,683,-1,684,600,511,-1,518,685,560,-1,588,587,686,-1,390,687,404,-1,688,689,382,-1,690,686,389,-1,691,585,584,-1,592,692,491,-1,693,694,695,-1,582,696,393,-1,697,580,581,-1,577,698,699,-1,367,697,700,-1,520,365,334,-1,701,613,702,-1,555,703,704,-1,705,706,519,-1,377,532,567,-1,508,565,707,-1,558,708,709,-1,557,710,711,-1,554,712,713,-1,549,552,714,-1,714,715,685,-1,716,541,540,-1,542,538,537,-1,540,551,717,-1,718,719,708,-1,720,721,569,-1,493,722,723,-1,724,396,395,-1,725,712,554,-1,712,378,726,-1,532,377,712,-1,727,728,703,-1,725,535,533,-1,476,482,481,-1,729,730,501,-1,731,355,354,-1,471,732,473,-1,733,734,576,-1,521,735,630,-1,516,448,514,-1,410,550,607,-1,488,484,505,-1,736,737,730,-1,736,729,728,-1,728,481,704,-1,499,528,498,-1,661,650,662,-1,738,342,366,-1,739,597,740,-1,506,505,486,-1,741,636,742,-1,506,555,704,-1,498,743,480,-1,744,500,479,-1,745,746,747,-1,745,477,746,-1,477,476,748,-1,737,504,730,-1,749,750,751,-1,752,753,754,-1,755,756,757,-1,755,758,732,-1,759,760,761,-1,759,471,470,-1,666,468,653,-1,762,763,462,-1,467,655,468,-1,464,764,465,-1,632,631,634,-1,765,766,435,-1,441,442,435,-1,767,667,439,-1,647,640,656,-1,642,768,764,-1,769,770,771,-1,772,773,774,-1,775,776,777,-1,439,257,767,-1,260,259,647,-1,768,263,769,-1,432,434,657,-1,430,778,779,-1,425,424,780,-1,781,428,423,-1,782,783,784,-1,416,673,785,-1,412,416,413,-1,413,786,787,-1,515,788,608,-1,414,789,408,-1,614,407,406,-1,404,401,400,-1,405,790,791,-1,792,724,793,-1,794,713,795,-1,598,796,681,-1,586,797,692,-1,689,383,382,-1,693,798,372,-1,376,381,384,-1,799,375,383,-1,376,591,379,-1,570,706,705,-1,704,703,728,-1,367,366,345,-1,536,344,363,-1,800,364,362,-1,590,801,373,-1,352,356,802,-1,352,354,355,-1,337,801,335,-1,340,344,803,-1,350,804,805,-1,191,806,807,-1,808,322,809,-1,308,323,810,-1,811,812,322,-1,325,320,314,-1,813,328,814,-1,315,815,316,-1,816,813,817,-1,314,313,814,-1,818,819,811,-1,150,310,309,-1,306,820,821,-1,822,823,824,-1,181,99,101,-1,825,301,313,-1,304,826,818,-1,105,305,304,-1,827,826,828,-1,103,829,104,-1,71,830,303,-1,831,67,832,-1,833,834,835,-1,292,291,834,-1,144,836,74,-1,64,837,838,-1,288,62,64,-1,69,839,840,-1,841,289,842,-1,843,283,51,-1,52,51,49,-1,286,276,284,-1,844,845,846,-1,265,847,42,-1,848,849,850,-1,851,852,850,-1,853,854,855,-1,264,856,857,-1,263,244,433,-1,238,240,436,-1,248,858,859,-1,248,247,858,-1,1,253,860,-1,225,861,862,-1,261,863,3,-1,22,241,240,-1,864,865,238,-1,866,867,29,-1,868,869,870,-1,871,222,872,-1,23,221,220,-1,873,163,215,-1,164,874,875,-1,876,212,205,-1,877,878,879,-1,203,202,204,-1,196,880,881,-1,183,882,184,-1,177,176,883,-1,74,836,142,-1,884,885,852,-1,232,886,887,-1,888,889,890,-1,882,155,176,-1,127,108,891,-1,57,892,55,-1,175,280,171,-1,191,170,172,-1,893,894,104,-1,895,883,896,-1,896,883,192,-1,873,215,216,-1,897,898,873,-1,328,326,814,-1,813,816,329,-1,317,899,900,-1,901,902,187,-1,178,203,903,-1,185,902,889,-1,904,905,906,-1,121,907,146,-1,150,307,151,-1,133,908,909,-1,135,148,132,-1,122,910,131,-1,911,912,913,-1,914,891,915,-1,127,916,128,-1,917,173,136,-1,918,916,919,-1,920,914,921,-1,920,922,923,-1,147,924,910,-1,121,123,293,-1,925,60,59,-1,894,926,112,-1,926,894,893,-1,891,110,107,-1,106,927,107,-1,113,928,119,-1,191,870,929,-1,13,93,930,-1,91,90,821,-1,87,931,88,-1,85,84,308,-1,82,932,933,-1,934,829,935,-1,303,830,936,-1,937,938,72,-1,939,940,297,-1,68,145,69,-1,312,811,819,-1,298,297,941,-1,812,321,942,-1,54,925,76,-1,943,934,935,-1,44,58,45,-1,944,945,946,-1,947,282,281,-1,54,53,925,-1,174,917,49,-1,148,144,143,-1,948,949,950,-1,846,951,842,-1,268,952,13,-1,953,845,39,-1,954,887,955,-1,956,957,958,-1,229,959,230,-1,887,954,37,-1,960,961,962,-1,254,962,963,-1,963,237,255,-1,964,236,235,-1,965,966,25,-1,10,967,15,-1,968,969,9,-1,861,225,243,-1,9,969,967,-1,970,261,971,-1,972,973,8,-1,7,6,3,-1,24,23,226,-1,223,862,968,-1,862,861,968,-1,226,219,24,-1,7,3,5,-1,8,974,972,-1,19,5,4,-1,9,967,10,-1,975,960,962,-1,976,861,243,-1,968,9,223,-1,18,10,15,-1,230,959,977,-1,235,25,964,-1,167,234,978,-1,963,28,237,-1,254,963,255,-1,37,31,887,-1,869,979,980,-1,229,981,959,-1,956,982,957,-1,39,38,953,-1,952,93,13,-1,842,983,846,-1,858,984,985,-1,986,987,988,-1,266,267,989,-1,148,135,144,-1,48,174,49,-1,990,947,281,-1,946,991,944,-1,945,947,940,-1,44,992,58,-1,937,943,935,-1,76,75,54,-1,298,941,75,-1,819,825,312,-1,66,993,832,-1,940,941,297,-1,936,828,303,-1,932,994,933,-1,821,166,91,-1,896,192,807,-1,13,930,995,-1,929,806,191,-1,97,96,996,-1,113,115,928,-1,104,894,111,-1,107,915,891,-1,893,927,926,-1,111,894,112,-1,120,119,928,-1,997,927,893,-1,925,53,60,-1,193,156,155,-1,293,998,121,-1,910,122,147,-1,920,124,922,-1,920,999,914,-1,918,128,916,-1,173,909,136,-1,921,124,920,-1,915,921,914,-1,153,911,913,-1,131,130,122,-1,135,132,908,-1,919,133,909,-1,907,1000,146,-1,904,906,304,-1,1001,61,125,-1,921,915,997,-1,902,890,889,-1,901,1002,1003,-1,900,318,317,-1,873,216,897,-1,896,1004,895,-1,104,1001,893,-1,191,172,870,-1,1005,1006,167,-1,55,281,57,-1,127,891,914,-1,175,174,280,-1,170,1007,175,-1,888,180,889,-1,194,187,186,-1,852,1008,884,-1,63,74,142,-1,1009,77,1010,-1,162,178,177,-1,883,895,177,-1,882,159,184,-1,881,194,196,-1,203,204,157,-1,876,205,1011,-1,874,1012,875,-1,873,1013,163,-1,220,226,23,-1,222,1014,872,-1,1015,6,973,-1,1016,1017,1018,-1,172,868,870,-1,980,34,1005,-1,866,29,28,-1,864,238,30,-1,22,240,239,-1,3,971,261,-1,1,860,1019,-1,1020,238,436,-1,433,1,0,-1,264,1019,856,-1,853,1021,854,-1,851,1008,852,-1,269,41,43,-1,267,844,848,-1,268,984,41,-1,844,846,1022,-1,33,270,958,-1,954,275,37,-1,276,275,284,-1,52,49,917,-1,841,842,951,-1,840,70,69,-1,288,64,289,-1,290,64,838,-1,144,74,145,-1,835,1023,833,-1,294,287,843,-1,303,300,71,-1,103,935,829,-1,936,827,828,-1,304,906,105,-1,818,904,304,-1,301,1024,313,-1,822,824,1025,-1,821,90,306,-1,309,308,150,-1,811,311,818,-1,816,817,1026,-1,315,1027,1028,-1,315,317,318,-1,315,319,1029,-1,813,329,328,-1,811,322,309,-1,308,810,85,-1,808,323,322,-1,807,192,191,-1,350,805,1030,-1,350,349,804,-1,340,364,344,-1,337,1031,801,-1,352,358,353,-1,352,1032,357,-1,801,1031,373,-1,364,348,362,-1,536,580,344,-1,345,697,367,-1,705,1033,570,-1,376,361,591,-1,799,378,375,-1,376,384,383,-1,383,375,376,-1,372,374,693,-1,689,799,383,-1,797,1034,692,-1,794,793,713,-1,793,794,792,-1,791,399,405,-1,404,403,401,-1,787,614,406,-1,408,1035,414,-1,1036,411,1037,-1,606,512,600,-1,512,511,600,-1,608,607,515,-1,787,414,413,-1,416,785,413,-1,782,784,1038,-1,419,1039,1038,-1,428,424,423,-1,1040,426,615,-1,424,679,780,-1,430,1041,778,-1,769,433,434,-1,647,658,260,-1,257,258,767,-1,769,434,770,-1,777,1042,775,-1,774,1043,772,-1,771,1044,769,-1,642,641,768,-1,667,440,439,-1,435,437,441,-1,435,444,765,-1,633,632,634,-1,1045,1046,1047,-1,464,642,764,-1,467,644,655,-1,762,465,763,-1,468,1048,653,-1,759,732,471,-1,759,761,752,-1,755,732,754,-1,755,1049,756,-1,752,1050,753,-1,1051,749,751,-1,477,748,744,-1,1052,475,745,-1,744,479,1053,-1,506,704,483,-1,742,1054,741,-1,1055,695,694,-1,661,651,650,-1,499,498,497,-1,728,729,481,-1,736,730,729,-1,488,505,529,-1,1056,516,556,-1,1057,1058,619,-1,550,513,607,-1,516,514,513,-1,521,630,1059,-1,1060,733,576,-1,766,765,1061,-1,354,1030,731,-1,1062,487,1052,-1,748,476,481,-1,1056,556,506,-1,725,1063,535,-1,535,1064,533,-1,377,378,712,-1,724,541,793,-1,541,716,793,-1,725,533,712,-1,394,493,723,-1,569,709,720,-1,531,1065,1066,-1,708,711,718,-1,540,717,543,-1,542,1067,538,-1,540,543,716,-1,714,685,1068,-1,710,1069,1070,-1,507,1071,1072,-1,1072,1073,507,-1,714,1068,549,-1,554,713,545,-1,727,703,570,-1,709,571,558,-1,509,508,707,-1,567,566,377,-1,519,739,705,-1,1074,728,727,-1,613,575,702,-1,365,734,334,-1,700,576,367,-1,699,578,577,-1,697,345,580,-1,582,393,392,-1,695,798,693,-1,491,593,592,-1,1075,492,400,-1,382,1055,688,-1,1076,390,404,-1,686,690,588,-1,400,399,1075,-1,685,561,560,-1,684,1077,600,-1,1078,1079,594,-1,409,1036,682,-1,420,615,426,-1,680,426,1080,-1,495,1081,496,-1,664,573,423,-1,1082,1057,1083,-1,672,417,673,-1,670,765,444,-1,635,1084,668,-1,440,667,463,-1,1085,650,666,-1,638,637,652,-1,665,1086,573,-1,431,434,432,-1,459,458,661,-1,638,651,649,-1,659,1087,660,-1,649,651,661,-1,655,1088,656,-1,464,653,1048,-1,652,466,650,-1,661,458,649,-1,1085,660,1087,-1,644,663,639,-1,1089,626,625,-1,656,640,642,-1,639,663,637,-1,1090,635,1091,-1,634,1084,635,-1,629,1061,628,-1,416,618,671,-1,450,1092,452,-1,622,1093,623,-1,620,418,621,-1,614,677,615,-1,613,781,423,-1,790,407,612,-1,1094,1095,425,-1,1096,1097,1098,-1,1040,1080,426,-1,411,410,607,-1,594,559,1078,-1,605,512,606,-1,604,1099,603,-1,1077,598,600,-1,597,1100,595,-1,593,559,594,-1,347,1101,335,-1,492,396,400,-1,801,590,348,-1,1076,404,396,-1,584,586,1102,-1,596,689,688,-1,380,1103,384,-1,1100,597,1104,-1,1067,542,395,-1,582,392,583,-1,365,576,734,-1,520,334,333,-1,613,573,575,-1,572,332,1105,-1,1060,698,1106,-1,571,709,569,-1,519,706,564,-1,567,565,546,-1,517,563,568,-1,564,706,562,-1,703,571,570,-1,1107,517,568,-1,561,1078,559,-1,558,555,556,-1,554,545,544,-1,548,1108,552,-1,507,1073,548,-1,550,551,1109,-1,1071,1070,1072,-1,507,547,546,-1,716,543,545,-1,542,537,540,-1,539,1109,537,-1,532,712,533,-1,1066,530,531,-1,517,1107,1068,-1,547,1107,546,-1,503,528,499,-1,527,1110,1111,-1,351,350,1112,-1,349,1113,1114,-1,469,1115,526,-1,521,572,522,-1,1116,520,485,-1,519,564,517,-1,516,332,449,-1,1059,630,1117,-1,1079,510,512,-1,509,1071,507,-1,513,515,607,-1,516,513,1118,-1,504,737,502,-1,499,497,500,-1,1047,618,1119,-1,494,1120,495,-1,492,1075,493,-1,505,484,486,-1,483,704,481,-1,478,1121,479,-1,477,745,475,-1,1122,1123,1124,-1,473,1125,474,-1,471,1126,469,-1,466,468,666,-1,463,465,762,-1,462,763,460,-1,451,1127,452,-1,1128,448,450,-1,1092,1059,674,-1,447,670,445,-1,442,444,435,-1,439,441,437,-1,642,654,656,-1,438,770,434,-1,435,1020,436,-1,263,433,769,-1,432,1041,430,-1,779,665,1129,-1,779,778,665,-1,427,1130,1131,-1,780,679,680,-1,422,616,420,-1,414,1035,412,-1,411,1036,409,-1,386,1036,1037,-1,408,789,401,-1,405,407,790,-1,687,402,404,-1,401,405,399,-1,399,791,397,-1,394,396,492,-1,723,391,393,-1,794,1132,792,-1,1132,388,390,-1,691,588,690,-1,382,384,1103,-1,379,381,376,-1,377,531,375,-1,375,530,361,-1,372,590,373,-1,359,1133,371,-1,736,728,1074,-1,368,1134,369,-1,365,738,366,-1,363,364,800,-1,361,348,591,-1,1031,1113,373,-1,351,1112,359,-1,352,802,1032,-1,351,1113,349,-1,1135,1031,337,-1,348,364,340,-1,346,803,344,-1,341,366,342,-1,340,803,338,-1,335,1101,336,-1,1105,332,334,-1,331,327,329,-1,324,326,1136,-1,308,309,322,-1,312,314,320,-1,315,1029,1027,-1,315,1028,815,-1,312,825,313,-1,311,811,309,-1,307,150,308,-1,90,86,85,-1,102,119,1137,-1,299,300,304,-1,80,1024,301,-1,72,71,300,-1,298,1138,296,-1,294,65,287,-1,149,293,123,-1,291,149,143,-1,289,290,842,-1,839,69,288,-1,287,70,840,-1,284,47,285,-1,282,58,57,-1,280,174,48,-1,277,276,286,-1,271,1139,273,-1,269,952,268,-1,41,984,265,-1,244,1,433,-1,260,863,261,-1,241,1140,258,-1,1141,254,256,-1,250,252,1142,-1,247,249,1143,-1,244,246,253,-1,243,224,262,-1,261,861,976,-1,242,1140,241,-1,239,238,865,-1,237,238,1144,-1,236,978,234,-1,228,230,1016,-1,227,26,1145,-1,226,220,224,-1,11,1146,223,-1,220,222,871,-1,1146,20,219,-1,216,218,897,-1,165,214,215,-1,214,205,212,-1,208,206,165,-1,210,1147,208,-1,207,1011,205,-1,180,179,889,-1,158,157,204,-1,199,201,1148,-1,198,1149,196,-1,155,882,183,-1,170,192,154,-1,977,188,190,-1,155,883,176,-1,103,1150,935,-1,820,306,1151,-1,902,185,187,-1,184,182,101,-1,182,179,181,-1,178,903,176,-1,154,156,170,-1,1152,982,1153,-1,173,917,174,-1,170,175,171,-1,169,1005,167,-1,97,91,166,-1,1144,255,237,-1,182,1154,179,-1,158,184,159,-1,911,153,151,-1,100,120,101,-1,152,1155,150,-1,121,998,305,-1,148,143,149,-1,146,153,147,-1,142,836,140,-1,113,139,115,-1,906,905,1156,-1,132,131,137,-1,135,908,133,-1,148,130,132,-1,61,1157,126,-1,129,108,127,-1,129,118,108,-1,124,126,922,-1,121,147,122,-1,1158,117,118,-1,109,108,118,-1,114,928,115,-1,113,119,111,-1,110,891,108,-1,907,105,107,-1,102,104,111,-1,193,183,120,-1,98,1159,96,-1,95,930,93,-1,86,90,92,-1,996,87,89,-1,86,932,84,-1,82,933,83,-1,80,302,78,-1,298,75,77,-1,831,940,939,-1,67,1023,65,-1,72,938,73,-1,70,835,68,-1,66,832,67,-1,61,1001,59,-1,992,56,58,-1,52,1160,50,-1,49,283,47,-1,884,1008,1161,-1,12,268,13,-1,1162,1163,1152,-1,33,1164,31,-1,28,30,237,-1,25,27,964,-1,242,22,24,-1,1165,19,21,-1,18,15,17,-1,14,855,12,-1,1019,264,1,-1,973,6,8,-1,15,974,16,-1,3,863,4,-1,974,8,16,-1,3,1015,971,-1,6,1015,3,-1,863,1166,4,-1,863,260,1166,-1,1167,857,853,-1,857,1167,960,-1,226,862,219,-1,226,225,862,-1,221,865,222,-1,239,865,221,-1,236,1168,1169,-1,236,964,1168,-1,254,975,962,-1,1170,975,254,-1,1171,1172,1173,-1,1172,1171,1174,-1,1175,1176,1177,-1,1175,886,1176,-1,35,190,36,-1,35,1178,190,-1,957,1152,1163,-1,957,982,1152,-1,1179,272,1180,-1,272,1179,1153,-1,951,845,953,-1,951,846,845,-1,989,1143,250,-1,989,847,1143,-1,952,94,93,-1,952,1181,94,-1,838,1182,1183,-1,838,1184,1182,-1,847,267,42,-1,847,989,267,-1,54,281,55,-1,54,990,281,-1,60,1157,61,-1,1157,60,892,-1,943,77,76,-1,1010,77,943,-1,819,301,825,-1,301,819,827,-1,77,1138,298,-1,77,1009,1138,-1,948,1185,931,-1,950,1185,948,-1,821,807,166,-1,821,896,807,-1,166,806,98,-1,806,166,807,-1,1159,995,930,-1,995,1159,1186,-1,14,995,1173,-1,14,13,995,-1,927,915,107,-1,997,915,927,-1,1158,129,156,-1,1158,118,129,-1,916,914,999,-1,127,914,916,-1,52,923,922,-1,137,923,52,-1,112,1156,905,-1,112,926,1156,-1,133,911,134,-1,911,133,912,-1,152,1187,1155,-1,1188,1187,152,-1,919,912,133,-1,916,912,919,-1,1000,110,109,-1,907,110,1000,-1,110,907,107,-1,105,121,305,-1,105,907,121,-1,128,1007,129,-1,918,1007,128,-1,1189,162,177,-1,160,162,1189,-1,203,162,161,-1,203,178,162,-1,902,1003,890,-1,902,901,1003,-1,1190,879,878,-1,1190,1191,879,-1,815,99,181,-1,99,815,1028,-1,319,900,330,-1,900,319,318,-1,1192,1193,1194,-1,1192,1195,1193,-1,324,218,1196,-1,324,1197,218,-1,1198,1199,808,-1,1199,1198,1200,-1,1201,1202,1203,-1,1202,1201,1204,-1,320,324,1196,-1,320,325,324,-1,89,933,994,-1,89,1205,933,-1,1174,866,1206,-1,1207,866,1174,-1,1208,965,959,-1,965,1208,966,-1,82,151,307,-1,151,82,81,-1,934,59,829,-1,59,934,925,-1,235,189,188,-1,235,234,189,-1,877,195,878,-1,877,1002,195,-1,18,21,11,-1,17,21,18,-1,45,991,46,-1,45,944,991,-1,141,1205,1209,-1,1205,141,140,-1,822,177,895,-1,177,822,1189,-1,1210,880,1211,-1,1212,880,1210,-1,1213,202,201,-1,204,202,1213,-1,1214,1215,1216,-1,1214,1003,1215,-1,1147,1204,1201,-1,210,1204,1147,-1,212,1200,1198,-1,1200,212,876,-1,211,164,875,-1,165,164,211,-1,1217,1012,1218,-1,1012,1217,875,-1,1012,1219,1193,-1,874,1219,1012,-1,1220,872,1014,-1,872,1220,1221,-1,1222,1208,1223,-1,1224,1208,1222,-1,872,245,871,-1,245,872,246,-1,1225,1226,1224,-1,1227,1226,1225,-1,228,1228,1229,-1,1228,228,1230,-1,1231,1230,1018,-1,1231,1232,1230,-1,979,1018,35,-1,979,1231,1018,-1,870,980,1005,-1,980,870,869,-1,1207,867,866,-1,1207,978,867,-1,19,7,5,-1,19,1165,7,-1,1233,860,1234,-1,860,1233,1235,-1,1227,249,248,-1,1227,1225,249,-1,854,1236,859,-1,854,1021,1236,-1,238,1237,1144,-1,1237,238,1020,-1,12,854,985,-1,855,854,12,-1,988,850,849,-1,988,851,850,-1,849,844,1022,-1,848,844,849,-1,1182,987,1183,-1,987,1182,1238,-1,957,1239,1164,-1,1240,1239,957,-1,233,887,31,-1,233,232,887,-1,275,279,284,-1,954,279,275,-1,955,279,954,-1,47,840,839,-1,283,840,47,-1,837,1184,838,-1,837,1241,1184,-1,88,1185,1209,-1,88,931,1185,-1,835,291,68,-1,835,834,291,-1,833,292,834,-1,296,292,833,-1,947,941,940,-1,947,990,941,-1,1242,79,1150,-1,1242,1243,79,-1,827,818,826,-1,818,827,819,-1,1244,1245,1216,-1,1245,1244,1246,-1,1247,1025,824,-1,1025,1247,1248,-1,1249,823,1151,-1,1249,824,823,-1,816,1137,99,-1,1026,1137,816,-1,1250,1246,1251,-1,1252,1246,1250,-1,326,314,814,-1,325,314,326,-1,1151,1253,1249,-1,1151,1254,1253,-1,1202,1253,1203,-1,1202,1255,1253,-1,323,1199,810,-1,1199,323,808,-1,25,1226,26,-1,1226,25,966,-1,1256,1257,1258,-1,1256,1259,1257,-1,349,1260,804,-1,1114,1260,349,-1,343,1261,1262,-1,1263,1261,343,-1,1264,1265,1263,-1,1264,1266,1265,-1,1258,1267,1256,-1,1258,1250,1267,-1,536,581,580,-1,582,581,536,-1,1268,1269,1270,-1,1269,1268,1271,-1,1272,1273,1274,-1,1273,1272,1275,-1,555,571,703,-1,558,571,555,-1,693,371,694,-1,371,693,374,-1,489,689,490,-1,489,799,689,-1,1102,594,605,-1,592,594,1102,-1,794,1034,797,-1,795,1034,794,-1,398,1075,399,-1,398,493,1075,-1,699,1276,578,-1,699,391,1276,-1,1037,387,386,-1,387,1037,402,-1,608,1035,408,-1,608,788,1035,-1,1077,683,682,-1,684,683,1077,-1,787,677,614,-1,677,787,786,-1,1038,785,419,-1,1038,784,785,-1,1277,428,781,-1,1277,1120,428,-1,1278,1279,612,-1,1278,1096,1279,-1,496,1130,494,-1,496,1280,1130,-1,768,1281,263,-1,641,1281,768,-1,767,1166,660,-1,767,258,1166,-1,437,257,439,-1,257,437,436,-1,1282,430,779,-1,1283,430,1282,-1,774,775,1042,-1,774,773,775,-1,1284,1042,1285,-1,1284,774,1042,-1,1286,1282,1287,-1,1286,1283,1282,-1,1044,768,769,-1,764,768,1044,-1,646,658,647,-1,658,646,659,-1,443,445,444,-1,443,1288,445,-1,735,631,630,-1,735,1289,631,-1,515,1290,1291,-1,515,514,1290,-1,1292,1293,1294,-1,451,1293,1292,-1,1295,1093,1296,-1,1295,1297,1093,-1,1298,1285,1299,-1,1298,1284,1285,-1,1300,1287,668,-1,1300,1286,1287,-1,764,763,465,-1,764,1044,763,-1,1298,1091,1301,-1,1091,1298,1302,-1,1303,1304,474,-1,1304,1303,1305,-1,760,1306,1307,-1,760,1308,1306,-1,1309,1125,758,-1,1125,1309,1310,-1,754,759,752,-1,754,732,759,-1,757,1311,1312,-1,756,1311,757,-1,761,1050,752,-1,761,1313,1050,-1,1314,753,1315,-1,1314,1049,753,-1,749,1275,750,-1,1275,749,1316,-1,501,744,748,-1,744,501,500,-1,1317,1318,1319,-1,1317,1320,1318,-1,744,746,477,-1,1053,746,744,-1,1321,479,1121,-1,1053,479,1321,-1,482,505,483,-1,505,482,529,-1,1322,1269,1323,-1,1270,1269,1322,-1,639,649,648,-1,639,638,649,-1,1124,1324,478,-1,1124,1190,1324,-1,1057,1325,1058,-1,1057,1082,1325,-1,1326,1325,1082,-1,1326,1327,1325,-1,1328,735,1329,-1,1289,735,1328,-1,1330,1331,1332,-1,1331,1330,1333,-1,1334,1335,1336,-1,1334,1337,1335,-1,1306,336,1101,-1,336,1306,1338,-1,1339,1340,805,-1,1340,1339,1304,-1,473,1126,471,-1,1126,473,472,-1,1030,353,350,-1,1030,354,353,-1,1032,1341,736,-1,1341,1032,802,-1,1316,1111,1110,-1,1316,1122,1111,-1,529,476,475,-1,476,529,482,-1,1320,1342,1318,-1,1320,1343,1342,-1,1343,1323,1342,-1,1343,1322,1323,-1,362,1344,800,-1,362,1345,1344,-1,549,1107,547,-1,549,1068,1107,-1,518,1068,685,-1,1068,518,517,-1,719,1344,720,-1,719,1346,1344,-1,1063,696,535,-1,1067,696,1063,-1,720,708,719,-1,720,709,708,-1,377,1065,531,-1,377,566,1065,-1,1347,1072,1348,-1,1347,1073,1072,-1,1109,540,537,-1,1109,551,540,-1,725,1348,1063,-1,725,1347,1348,-1,683,552,409,-1,683,714,552,-1,1349,1072,1070,-1,1349,539,1072,-1,557,708,558,-1,557,711,708,-1,727,1033,1074,-1,1033,727,570,-1,1350,579,609,-1,579,1350,577,-1,523,1351,1329,-1,574,1351,523,-1,365,1116,738,-1,520,1116,365,-1,393,1067,395,-1,696,1067,393,-1,795,489,1034,-1,726,489,795,-1,798,379,372,-1,380,379,798,-1,596,490,689,-1,596,595,490,-1,389,687,390,-1,389,686,687,-1,347,801,348,-1,335,801,347,-1,796,1036,386,-1,1036,796,682,-1,542,724,395,-1,542,541,724,-1,1352,496,1081,-1,1352,1280,496,-1,1279,397,791,-1,397,1279,1353,-1,1350,1277,701,-1,1350,1354,1277,-1,775,1040,776,-1,1080,1040,775,-1,1117,632,1054,-1,1117,630,632,-1,418,672,621,-1,418,417,672,-1,1355,636,623,-1,1355,742,636,-1,1127,1290,1128,-1,1290,1127,1356,-1,629,1357,1141,-1,1358,1357,629,-1,462,443,442,-1,443,462,461,-1,1085,653,667,-1,1085,666,653,-1,432,625,1041,-1,432,1089,625,-1,1086,778,1359,-1,665,778,1086,-1,457,645,1360,-1,457,646,645,-1,425,664,423,-1,425,1095,664,-1,457,659,646,-1,457,459,659,-1,1166,658,660,-1,260,658,1166,-1,1041,1359,778,-1,1041,625,1359,-1,654,464,1048,-1,464,654,642,-1,442,762,462,-1,442,441,762,-1,1361,634,1362,-1,634,1361,1084,-1,1089,629,626,-1,1089,1358,629,-1,1363,1329,1351,-1,1363,1328,1329,-1,1356,1291,1290,-1,1291,1356,1119,-1,742,676,675,-1,1355,676,742,-1,1057,621,1083,-1,621,1057,619,-1,1039,1325,1364,-1,1039,1058,1325,-1,616,407,614,-1,407,616,422,-1,773,1080,775,-1,680,1080,773,-1,701,781,613,-1,1277,781,701,-1,1365,397,1353,-1,1366,397,1365,-1,796,385,681,-1,386,385,796,-1,604,602,606,-1,601,602,604,-1,604,600,599,-1,604,606,600,-1,559,595,1100,-1,593,595,559,-1,589,691,584,-1,589,588,691,-1,1103,798,695,-1,1103,380,798,-1,596,740,597,-1,596,688,740,-1,581,700,697,-1,581,583,700,-1,1105,734,733,-1,1105,334,734,-1,574,522,575,-1,574,523,522,-1,574,1086,1351,-1,573,1086,574,-1,700,1060,576,-1,700,698,1060,-1,569,706,570,-1,706,569,562,-1,1069,516,1118,-1,1069,556,516,-1,553,1108,548,-1,553,544,1108,-1,550,539,1349,-1,550,1109,539,-1,717,410,409,-1,717,551,410,-1,1070,509,710,-1,1070,1071,509,-1,359,705,1133,-1,359,1033,705,-1,1347,554,553,-1,725,554,1347,-1,553,1073,1347,-1,553,548,1073,-1,565,534,707,-1,565,532,534,-1,565,567,532,-1,363,1344,1346,-1,363,800,1344,-1,510,1078,561,-1,1078,510,1079,-1,1367,1323,1368,-1,1367,1342,1323,-1,1369,1342,1367,-1,1369,1318,1342,-1,501,504,499,-1,501,730,504,-1,749,1122,1316,-1,749,1123,1122,-1,503,1273,1110,-1,1273,503,502,-1,1341,356,1274,-1,1341,802,356,-1,1304,1259,1340,-1,1259,1304,1305,-1,1338,1370,336,-1,1370,1338,526,-1,1336,1371,338,-1,1336,1335,1371,-1,1331,1314,1261,-1,1331,1333,1314,-1,1370,337,336,-1,337,1370,1135,-1,392,699,583,-1,391,699,392,-1,447,1328,1372,-1,447,1289,1328,-1,1090,1302,624,-1,1090,1091,1302,-1,535,582,536,-1,535,696,582,-1,560,1100,1104,-1,560,559,1100,-1,1054,633,741,-1,633,1054,632,-1,743,1122,1124,-1,1111,1122,743,-1,1096,1353,1279,-1,1096,1098,1353,-1,1368,1269,369,-1,1368,1323,1269,-1,1121,1210,1321,-1,1121,1212,1210,-1,1319,1369,747,-1,1319,1318,1369,-1,1333,1049,1314,-1,1333,756,1049,-1,1335,761,1371,-1,1335,1313,761,-1,473,758,1125,-1,473,732,758,-1,474,1310,1303,-1,474,1125,1310,-1,1308,1338,1306,-1,1308,524,1338,-1,1373,1305,1303,-1,1305,1373,1374,-1,1084,1300,668,-1,1361,1300,1084,-1,1364,1327,1375,-1,1327,1364,1325,-1,1300,1376,1286,-1,1377,1376,1300,-1,1301,1284,1298,-1,1301,1378,1284,-1,1294,1297,1295,-1,1294,1293,1297,-1,1093,455,623,-1,1093,1297,455,-1,1047,1294,1045,-1,1047,1292,1294,-1,451,1356,1127,-1,1292,1356,451,-1,514,1128,1290,-1,514,448,1128,-1,449,521,1059,-1,572,521,449,-1,446,1288,1362,-1,446,445,1288,-1,1379,1287,1282,-1,1287,1379,1380,-1,777,1285,1042,-1,1285,777,1381,-1,438,430,1283,-1,438,431,430,-1,1129,1094,1379,-1,1129,1095,1094,-1,1237,435,766,-1,1237,1020,435,-1,429,1130,427,-1,429,494,1130,-1,429,426,679,-1,429,427,426,-1,1097,1352,1098,-1,1097,1280,1352,-1,1278,422,421,-1,422,1278,612,-1,1354,1120,1277,-1,1354,495,1120,-1,418,1039,419,-1,418,620,1039,-1,673,419,785,-1,419,673,417,-1,788,412,1035,-1,788,415,412,-1,788,617,415,-1,598,682,796,-1,598,1077,682,-1,402,408,403,-1,402,1037,408,-1,686,402,687,-1,686,387,402,-1,701,577,1350,-1,701,702,577,-1,493,1382,722,-1,1382,493,398,-1,724,1076,396,-1,1076,724,792,-1,388,690,389,-1,388,691,690,-1,585,691,388,-1,1102,602,584,-1,605,602,1102,-1,694,1133,740,-1,1133,694,371,-1,530,721,1345,-1,721,530,1066,-1,1272,750,1275,-1,1272,1383,750,-1,369,1271,370,-1,369,1269,1271,-1,368,1264,342,-1,370,1264,368,-1,1033,1112,1074,-1,1033,359,1112,-1,1383,1250,1251,-1,1383,1267,1250,-1,1031,1114,1113,-1,1031,1135,1114,-1,1263,342,1264,-1,343,342,1263,-1,1263,1331,1261,-1,1265,1331,1263,-1,1336,803,346,-1,1336,338,803,-1,1114,1370,1260,-1,1135,1370,1114,-1,1259,1384,1340,-1,1384,1259,1256,-1,1345,361,530,-1,361,1345,362,-1,330,1194,331,-1,330,1385,1194,-1,321,1196,942,-1,321,320,1196,-1,1203,1254,1386,-1,1203,1253,1254,-1,1255,1249,1253,-1,1249,1255,1387,-1,1385,900,1388,-1,1385,330,900,-1,1246,1388,1245,-1,1388,1246,1252,-1,1387,824,1249,-1,1387,1247,824,-1,751,1246,1244,-1,751,1251,1246,-1,1242,817,1243,-1,817,1242,1026,-1,1243,80,79,-1,1243,1024,80,-1,296,939,297,-1,296,833,939,-1,66,46,991,-1,294,46,66,-1,63,837,64,-1,142,837,63,-1,1209,89,88,-1,89,1209,1205,-1,839,285,47,-1,839,288,285,-1,277,285,841,-1,286,285,277,-1,279,1175,280,-1,955,1175,279,-1,1139,276,278,-1,1389,276,1139,-1,1164,233,31,-1,1164,1239,233,-1,271,1180,272,-1,271,274,1180,-1,1163,1240,957,-1,1163,1390,1240,-1,1161,1182,949,-1,1238,1182,1161,-1,849,986,988,-1,1022,986,849,-1,1022,1391,986,-1,43,885,269,-1,43,852,885,-1,259,976,1392,-1,259,261,976,-1,256,1144,1237,-1,256,255,1144,-1,252,40,1142,-1,252,273,40,-1,273,1393,274,-1,252,1393,273,-1,248,1145,1227,-1,859,1145,248,-1,246,860,253,-1,246,1234,860,-1,29,864,30,-1,1394,864,29,-1,978,168,167,-1,168,978,1207,-1,1177,280,1175,-1,280,1177,171,-1,231,886,232,-1,886,231,1176,-1,1017,230,1178,-1,1016,230,1017,-1,1230,1016,1018,-1,1230,228,1016,-1,274,1395,1180,-1,1393,1395,274,-1,1145,1226,1227,-1,1145,26,1226,-1,872,1234,246,-1,872,1221,1234,-1,223,219,862,-1,223,1146,219,-1,1395,1223,1396,-1,1222,1223,1395,-1,1221,1168,1397,-1,1221,1220,1168,-1,1193,1218,1012,-1,1193,1195,1218,-1,217,213,1398,-1,213,217,216,-1,875,1399,211,-1,875,1217,1399,-1,214,206,205,-1,165,206,214,-1,1311,209,1312,-1,1311,210,209,-1,876,1400,1200,-1,1400,876,1011,-1,1330,210,1311,-1,1330,1204,210,-1,1148,202,161,-1,1148,201,202,-1,201,1401,1213,-1,201,200,1401,-1,1402,1211,1401,-1,1402,1210,1211,-1,881,195,194,-1,195,881,878,-1,1239,1229,1228,-1,1239,1390,1229,-1,1239,1240,1390,-1,1189,1025,1403,-1,822,1025,1189,-1,1150,73,938,-1,79,73,1150,-1,969,972,967,-1,969,1404,972,-1,1002,187,195,-1,1002,901,187,-1,197,185,1154,-1,186,185,197,-1,1179,1152,1153,-1,1162,1152,1179,-1,1179,1405,1162,-1,1405,1179,1396,-1,168,1174,1171,-1,168,1207,1174,-1,1406,1203,1386,-1,1203,1406,1201,-1,1198,809,1398,-1,808,809,1198,-1,1407,324,1136,-1,324,1407,1197,-1,1374,1192,1257,-1,1192,1374,1195,-1,1408,815,181,-1,1408,316,815,-1,1002,1215,1003,-1,1215,1002,877,-1,157,903,203,-1,157,159,903,-1,1409,1320,199,-1,1320,1409,1343,-1,1410,1343,1409,-1,1343,1410,1322,-1,1411,311,310,-1,1412,311,1411,-1,997,124,921,-1,997,125,124,-1,125,893,1001,-1,125,997,893,-1,1411,1187,139,-1,1187,1411,1155,-1,81,911,151,-1,81,134,911,-1,116,139,1187,-1,139,116,115,-1,1156,105,906,-1,106,105,1156,-1,916,913,912,-1,999,913,916,-1,132,909,908,-1,909,132,136,-1,103,1242,1150,-1,1242,103,102,-1,927,1156,926,-1,927,106,1156,-1,156,114,1158,-1,114,156,193,-1,116,1158,114,-1,1158,116,117,-1,1137,100,99,-1,1137,119,100,-1,931,1413,948,-1,931,87,1413,-1,1173,1186,1171,-1,1173,995,1186,-1,1004,821,820,-1,1004,896,821,-1,71,78,830,-1,71,73,78,-1,145,62,69,-1,145,74,62,-1,56,892,57,-1,56,1157,892,-1,946,66,991,-1,946,993,66,-1,1008,1238,1161,-1,851,1238,1008,-1,838,1414,290,-1,838,1183,1414,-1,1181,1413,94,-1,1413,1181,1415,-1,266,250,1142,-1,266,989,250,-1,234,1006,189,-1,167,1006,234,-1,1164,958,957,-1,33,958,1164,-1,977,1178,230,-1,1178,977,190,-1,1177,1416,868,-1,1177,1176,1416,-1,1357,254,1141,-1,1357,1170,254,-1,1220,1169,1168,-1,1394,1169,1220,-1,23,239,221,-1,22,239,23,-1,960,264,857,-1,975,264,960,-1,853,14,1167,-1,853,855,14,-1,16,21,17,-1,21,16,1165,-1,12,984,268,-1,985,984,12,-1,970,1015,1404,-1,1015,970,971,-1,1170,0,2,-1,1170,1357,0,-1,24,19,242,-1,19,24,20,-1,864,222,865,-1,864,1014,222,-1,1206,1172,1174,-1,961,1172,1206,-1,1167,1173,1172,-1,1167,14,1173,-1,34,979,35,-1,34,980,979,-1,1163,1405,1417,-1,1163,1162,1405,-1,1153,956,272,-1,956,1153,982,-1,1018,1178,35,-1,1018,1017,1178,-1,1143,265,247,-1,847,265,1143,-1,949,1184,950,-1,1184,949,1182,-1,51,295,843,-1,51,50,295,-1,312,812,811,-1,312,321,812,-1,70,1023,835,-1,1023,70,65,-1,1010,937,72,-1,943,937,1010,-1,827,302,301,-1,827,936,302,-1,1009,293,1138,-1,1009,998,293,-1,135,83,144,-1,134,83,135,-1,134,81,83,-1,994,996,89,-1,996,994,92,-1,98,929,1159,-1,806,929,98,-1,930,96,1159,-1,930,95,96,-1,922,1160,52,-1,1160,922,126,-1,146,1188,152,-1,1000,1188,146,-1,137,910,923,-1,137,131,910,-1,109,1188,1000,-1,117,1188,109,-1,905,113,112,-1,905,138,113,-1,140,144,83,-1,140,836,144,-1,123,130,149,-1,123,122,130,-1,998,299,305,-1,1009,299,998,-1,918,175,1007,-1,918,173,175,-1,155,192,883,-1,155,154,192,-1,160,1403,1418,-1,160,1189,1403,-1,1418,161,160,-1,1148,161,1418,-1,182,158,1154,-1,158,182,184,-1,879,1051,1419,-1,1051,879,1191,-1,99,1027,816,-1,99,1028,1027,-1,1029,330,329,-1,330,1029,319,-1,1013,164,163,-1,1013,874,164,-1,1194,1219,331,-1,1194,1193,1219,-1,1196,217,942,-1,1196,218,217,-1,1200,1420,1199,-1,1420,1200,1400,-1,1202,1330,1332,-1,1202,1204,1330,-1,1407,898,1197,-1,1407,873,898,-1,929,1186,1159,-1,929,169,1186,-1,28,1206,866,-1,28,963,1206,-1,981,1208,959,-1,981,1223,1208,-1,1408,180,888,-1,180,1408,181,-1,1324,878,881,-1,1190,878,1324,-1,974,967,972,-1,15,967,974,-1,1248,1322,1410,-1,1248,1270,1322,-1,176,159,882,-1,176,903,159,-1,196,1211,880,-1,196,1149,1211,-1,1213,198,204,-1,1213,1149,198,-1,199,1317,200,-1,1320,1317,199,-1,198,1154,158,-1,198,197,1154,-1,1216,1419,1244,-1,1216,1215,1419,-1,207,1201,1406,-1,1147,1201,207,-1,1147,206,208,-1,207,206,1147,-1,209,211,1399,-1,209,208,211,-1,1398,212,1198,-1,212,1398,213,-1,1218,1421,1217,-1,1373,1421,1218,-1,1013,1407,1422,-1,873,1407,1013,-1,11,20,1146,-1,11,21,20,-1,966,1224,1226,-1,966,1208,1224,-1,871,224,220,-1,224,871,245,-1,227,1397,27,-1,1233,1397,227,-1,1423,1224,1222,-1,1225,1224,1423,-1,229,1229,1417,-1,1229,229,228,-1,1230,231,1228,-1,1230,1232,231,-1,1416,1231,979,-1,1416,1232,1231,-1,978,1169,867,-1,978,236,1169,-1,242,4,1140,-1,242,19,4,-1,262,245,244,-1,262,224,245,-1,1236,1233,227,-1,1235,1233,1236,-1,251,1225,1423,-1,249,1225,251,-1,250,249,251,-1,1143,249,250,-1,856,1236,1021,-1,856,1235,1236,-1,257,240,241,-1,257,436,240,-1,1166,1140,4,-1,258,1140,1166,-1,1281,262,263,-1,1281,243,262,-1,1414,1391,983,-1,1391,1414,986,-1,269,1181,952,-1,885,1181,269,-1,1389,271,270,-1,1139,271,1389,-1,38,277,953,-1,38,278,277,-1,1160,992,50,-1,1160,56,992,-1,284,48,47,-1,279,48,284,-1,287,283,843,-1,287,840,283,-1,1185,1184,1241,-1,1184,1185,950,-1,141,1185,1241,-1,1209,1185,141,-1,1205,83,933,-1,1205,140,83,-1,1138,292,296,-1,1138,293,292,-1,54,941,990,-1,54,75,941,-1,72,1009,1010,-1,1009,72,299,-1,1412,139,138,-1,1411,139,1412,-1,928,193,120,-1,928,114,193,-1,1214,1245,899,-1,1214,1216,1245,-1,1248,1268,1270,-1,1248,1247,1268,-1,932,307,84,-1,932,82,307,-1,1252,1258,1424,-1,1250,1258,1252,-1,306,1254,1151,-1,306,1425,1254,-1,1255,1332,1426,-1,1332,1255,1202,-1,810,1420,1425,-1,1420,810,1199,-1,1136,328,327,-1,1136,326,328,-1,1257,1424,1258,-1,1192,1424,1257,-1,1301,635,669,-1,1301,1091,635,-1,1101,340,339,-1,340,1101,347,-1,1262,341,343,-1,1262,1334,341,-1,1426,1266,1427,-1,1265,1266,1426,-1,345,341,346,-1,345,366,341,-1,1256,1428,1384,-1,1267,1428,1256,-1,1428,1274,731,-1,1274,1428,1272,-1,360,1113,351,-1,373,1113,360,-1,1427,1271,1268,-1,1427,1266,1271,-1,368,485,1134,-1,1116,485,368,-1,1274,502,1341,-1,502,1274,1273,-1,371,373,360,-1,374,373,371,-1,518,1104,519,-1,518,560,1104,-1,584,603,589,-1,603,584,601,-1,587,387,686,-1,587,385,387,-1,794,388,1132,-1,794,797,388,-1,792,390,1076,-1,1132,390,792,-1,1429,578,1276,-1,579,578,1429,-1,1366,398,397,-1,398,1366,1382,-1,401,406,405,-1,401,789,406,-1,783,786,784,-1,678,786,783,-1,678,677,786,-1,618,1046,671,-1,1046,618,1047,-1,1045,621,672,-1,1045,1430,621,-1,1098,1365,1353,-1,1098,1352,1365,-1,420,1131,421,-1,420,427,1131,-1,1130,1097,1131,-1,1097,1130,1280,-1,1129,664,1095,-1,1129,665,664,-1,641,1392,1281,-1,640,1392,641,-1,1061,1141,256,-1,629,1141,1061,-1,1282,1129,1379,-1,779,1129,1282,-1,774,1378,1043,-1,1378,774,1284,-1,438,1286,1376,-1,438,1283,1286,-1,662,1085,1087,-1,650,1085,662,-1,446,1289,447,-1,631,1289,446,-1,1092,449,1059,-1,1092,450,449,-1,456,452,676,-1,453,452,456,-1,1293,453,456,-1,453,1293,451,-1,1431,1296,1083,-1,1431,1295,1296,-1,1299,1381,1375,-1,1299,1285,1381,-1,669,1287,1380,-1,668,1287,669,-1,1044,460,763,-1,1044,771,460,-1,1302,1299,1432,-1,1302,1298,1299,-1,460,1433,461,-1,460,1377,1433,-1,1339,474,1304,-1,1339,472,474,-1,759,1308,760,-1,470,1308,759,-1,1434,1310,1309,-1,1434,1421,1310,-1,1309,1312,1434,-1,1312,1309,757,-1,1315,1050,1337,-1,1315,753,1050,-1,1316,1273,1275,-1,1110,1273,1316,-1,1402,1319,1435,-1,1402,1317,1319,-1,1053,1435,746,-1,1321,1435,1053,-1,478,1212,1121,-1,1324,1212,478,-1,332,1056,333,-1,332,516,1056,-1,484,1134,485,-1,484,1436,1134,-1,391,722,1276,-1,391,723,722,-1,1099,599,681,-1,599,1099,604,-1,466,637,467,-1,466,652,637,-1,500,480,479,-1,497,480,500,-1,683,715,714,-1,715,683,684,-1,1432,1326,622,-1,1326,1432,1327,-1,521,1329,735,-1,521,523,1329,-1,524,526,1338,-1,525,526,524,-1,1339,804,1437,-1,805,804,1339,-1,1262,1337,1334,-1,1262,1315,1337,-1,1101,1307,1306,-1,1101,339,1307,-1,1260,1437,804,-1,1260,1115,1437,-1,1437,472,1339,-1,472,1437,1126,-1,353,1112,350,-1,1112,353,358,-1,1074,1032,736,-1,1074,357,1032,-1,1123,1190,1124,-1,1191,1190,1123,-1,1110,528,503,-1,527,528,1110,-1,487,475,1052,-1,475,487,488,-1,487,1436,484,-1,487,1062,1436,-1,1118,1070,1069,-1,1118,1349,1070,-1,1346,535,363,-1,1346,1064,535,-1,1348,539,538,-1,1348,1072,539,-1,719,1064,1346,-1,719,718,1064,-1,1063,538,1067,-1,1063,1348,538,-1,1065,562,1066,-1,563,562,1065,-1,1108,409,552,-1,1108,717,409,-1,1069,557,556,-1,710,557,1069,-1,710,707,711,-1,707,710,509,-1,546,568,567,-1,546,1107,568,-1,522,1060,1106,-1,1060,522,733,-1,611,495,1354,-1,611,1081,495,-1,577,1106,698,-1,577,702,1106,-1,738,368,342,-1,1116,368,738,-1,1429,609,579,-1,1429,610,609,-1,1034,491,692,-1,489,491,1034,-1,372,591,590,-1,372,379,591,-1,491,595,593,-1,491,490,595,-1,715,561,685,-1,715,510,561,-1,512,594,1079,-1,605,594,512,-1,1037,608,408,-1,608,1037,411,-1,612,791,790,-1,791,612,1279,-1,609,1354,1350,-1,609,611,1354,-1,1094,780,772,-1,425,780,1094,-1,776,615,678,-1,1040,615,776,-1,675,1054,742,-1,675,1117,1054,-1,1117,674,1059,-1,675,674,1117,-1,1119,617,1291,-1,617,1119,618,-1,1296,622,1326,-1,1296,1093,622,-1,452,1128,450,-1,1128,452,1127,-1,625,1363,1359,-1,625,627,1363,-1,626,1372,627,-1,626,628,1372,-1,741,635,1090,-1,635,741,633,-1,461,1288,443,-1,1288,461,1433,-1,636,1090,624,-1,636,741,1090,-1,656,645,647,-1,645,656,1088,-1,657,1089,432,-1,657,1358,1089,-1,648,457,1360,-1,458,457,648,-1,1360,1088,643,-1,1088,1360,645,-1,1087,459,662,-1,459,1087,659,-1,0,1358,657,-1,1357,1358,0,-1,655,643,1088,-1,643,655,644,-1,441,463,762,-1,441,440,463,-1,1362,1433,1361,-1,1362,1288,1433,-1,1061,670,628,-1,670,1061,765,-1,1363,1372,1328,-1,1363,627,1372,-1,1351,1359,1363,-1,1086,1359,1351,-1,452,674,676,-1,1092,674,452,-1,1326,1083,1296,-1,1083,1326,1082,-1,620,1058,1039,-1,620,619,1058,-1,1355,456,676,-1,456,1355,454,-1,780,773,772,-1,780,680,773,-1,1366,611,610,-1,1366,1365,611,-1,587,603,1099,-1,589,603,587,-1,510,684,511,-1,715,684,510,-1,586,592,1102,-1,586,692,592,-1,695,382,1103,-1,382,695,1055,-1,698,583,699,-1,698,700,583,-1,572,733,522,-1,572,1105,733,-1,1106,575,522,-1,702,575,1106,-1,726,713,712,-1,726,795,713,-1,1065,568,563,-1,568,1065,566,-1,1133,739,740,-1,1133,705,739,-1,718,533,1064,-1,718,534,533,-1,544,717,1108,-1,543,717,544,-1,718,707,534,-1,718,711,707,-1,569,1066,562,-1,1066,569,721,-1,395,723,393,-1,394,723,395,-1,716,713,793,-1,545,713,716,-1,799,726,378,-1,799,489,726,-1,513,1349,1118,-1,1349,513,550,-1,333,506,486,-1,506,333,1056,-1,1368,1062,1367,-1,1062,1368,1436,-1,1052,1367,1062,-1,1052,1369,1367,-1,748,729,501,-1,748,481,729,-1,1051,1123,749,-1,1051,1191,1123,-1,358,1074,1112,-1,1074,358,357,-1,356,731,1274,-1,731,356,355,-1,1259,1374,1257,-1,1259,1305,1374,-1,1370,1115,1260,-1,1370,526,1115,-1,339,1371,1307,-1,339,338,1371,-1,1261,1315,1262,-1,1261,1314,1315,-1,470,524,1308,-1,524,470,469,-1,1372,670,447,-1,670,1372,628,-1,1302,622,624,-1,622,1302,1432,-1,737,1341,502,-1,737,736,1341,-1,498,1111,743,-1,1111,498,527,-1,648,643,639,-1,643,648,1360,-1,1055,740,688,-1,1055,694,740,-1,369,1436,1368,-1,369,1134,1436,-1,1295,1045,1294,-1,1431,1045,1295,-1,1431,1430,1045,-1,743,478,480,-1,743,1124,478,-1,1321,1402,1435,-1,1210,1402,1321,-1,1435,747,746,-1,747,1435,1319,-1,745,1369,1052,-1,747,1369,745,-1,756,1330,1311,-1,1330,756,1333,-1,1337,1313,1335,-1,1337,1050,1313,-1,754,1049,755,-1,754,753,1049,-1,758,757,1309,-1,757,758,755,-1,761,1307,1371,-1,761,760,1307,-1,1421,1303,1310,-1,1421,1373,1303,-1,1115,1126,1437,-1,1115,469,1126,-1,1361,1377,1300,-1,1433,1377,1361,-1,1432,1375,1327,-1,1432,1299,1375,-1,1048,655,654,-1,468,655,1048,-1,1376,460,771,-1,460,1376,1377,-1,1301,1380,1378,-1,669,1380,1301,-1,1375,782,1364,-1,1375,1381,782,-1,455,1293,456,-1,455,1297,1293,-1,623,454,1355,-1,623,455,454,-1,1119,1292,1047,-1,1119,1356,1292,-1,1362,631,446,-1,634,631,1362,-1,660,667,767,-1,667,660,1085,-1,438,771,770,-1,771,438,1376,-1,1380,1043,1378,-1,1380,1379,1043,-1,1381,783,782,-1,1381,777,783,-1,678,777,776,-1,777,678,783,-1,772,1379,1094,-1,772,1043,1379,-1,766,256,1237,-1,1061,256,766,-1,640,259,1392,-1,647,259,640,-1,1120,429,428,-1,1120,494,429,-1,1096,1131,1097,-1,1096,421,1131,-1,1278,421,1096,-1,1365,1081,611,-1,1365,1352,1081,-1,1430,1083,621,-1,1083,1430,1431,-1,1364,1038,1039,-1,1038,1364,782,-1,1046,672,671,-1,672,1046,1045,-1,413,784,786,-1,413,785,784,-1,1291,788,515,-1,1291,617,788,-1,789,787,406,-1,789,414,787,-1,1366,1429,1382,-1,1366,610,1429,-1,1429,722,1382,-1,1429,1276,722,-1,681,587,1099,-1,681,385,587,-1,585,797,586,-1,797,585,388,-1,597,519,1104,-1,597,739,519,-1,720,1345,721,-1,720,1344,1345,-1,1383,751,750,-1,751,1383,1251,-1,370,1266,1264,-1,1271,1266,370,-1,1428,1383,1272,-1,1428,1267,1383,-1,731,1384,1428,-1,1384,731,1030,-1,1332,1265,1426,-1,1332,1331,1265,-1,1334,346,341,-1,1334,1336,346,-1,1340,1030,805,-1,1030,1340,1384,-1,818,1412,904,-1,818,311,1412,-1,1385,1192,1194,-1,1385,1424,1192,-1,322,942,809,-1,322,812,942,-1,1425,1386,1254,-1,1386,1425,1420,-1,1387,1426,1427,-1,1387,1255,1426,-1,1425,85,810,-1,85,1425,306,-1,1388,1424,1385,-1,1388,1252,1424,-1,899,1388,900,-1,899,1245,1388,-1,814,817,813,-1,814,313,817,-1,1247,1427,1268,-1,1427,1247,1387,-1,895,823,822,-1,895,1004,823,-1,888,899,1408,-1,888,1214,899,-1,313,1243,817,-1,313,1024,1243,-1,138,904,1412,-1,138,905,904,-1,828,304,303,-1,828,826,304,-1,829,1001,104,-1,59,1001,829,-1,946,940,993,-1,946,945,940,-1,67,833,1023,-1,831,833,67,-1,831,939,833,-1,68,143,145,-1,68,291,143,-1,1241,142,141,-1,1241,837,142,-1,87,94,1413,-1,95,94,87,-1,841,288,289,-1,285,288,841,-1,953,841,951,-1,953,277,841,-1,50,44,295,-1,44,50,992,-1,278,273,1139,-1,278,40,273,-1,40,278,38,-1,1389,37,276,-1,1389,32,37,-1,270,32,1389,-1,270,33,32,-1,272,958,270,-1,272,956,958,-1,885,1415,1181,-1,884,1415,885,-1,846,1391,1022,-1,846,983,1391,-1,1238,988,987,-1,988,1238,851,-1,267,43,42,-1,43,267,848,-1,850,43,848,-1,852,43,850,-1,856,853,857,-1,856,1021,853,-1,1392,243,1281,-1,1392,976,243,-1,858,854,859,-1,985,854,858,-1,856,860,1235,-1,1019,860,856,-1,1423,252,251,-1,1423,1393,252,-1,227,859,1236,-1,227,1145,859,-1,1394,867,1169,-1,867,1394,29,-1,169,870,1005,-1,169,929,870,-1,868,171,1177,-1,171,868,172,-1,1176,1232,1416,-1,1176,231,1232,-1,233,1228,231,-1,233,1239,1228,-1,1417,1390,1163,-1,1390,1417,1229,-1,1393,1222,1395,-1,1423,1222,1393,-1,1234,1397,1233,-1,1234,1221,1397,-1,1396,1180,1395,-1,1396,1179,1180,-1,1397,964,27,-1,1397,1168,964,-1,1195,1373,1218,-1,1195,1374,1373,-1,216,214,213,-1,216,215,214,-1,1217,1434,1399,-1,1434,1217,1421,-1,1312,1399,1434,-1,1312,209,1399,-1,1011,1406,1400,-1,207,1406,1011,-1,1051,1244,1419,-1,1051,751,1244,-1,200,1402,1401,-1,1402,200,1317,-1,1401,1149,1213,-1,1401,1211,1149,-1,1212,881,880,-1,1212,1324,881,-1,1248,1403,1025,-1,1403,1248,1410,-1,1183,986,1414,-1,987,986,1183,-1,8,1165,16,-1,8,7,1165,-1,194,197,196,-1,194,186,197,-1,1157,1160,126,-1,1157,56,1160,-1,1405,1223,981,-1,1405,1396,1223,-1,1171,169,168,-1,169,1171,1186,-1,1197,897,218,-1,1197,898,897,-1,327,1219,1422,-1,327,331,1219,-1,1400,1386,1420,-1,1386,1400,1406,-1,1398,942,217,-1,809,942,1398,-1,1422,1136,327,-1,1136,1422,1407,-1,874,1422,1219,-1,874,1013,1422,-1,816,1029,329,-1,816,1027,1029,-1,317,1408,899,-1,1408,317,316,-1,1214,890,1003,-1,1214,888,890,-1,877,1419,1215,-1,1419,877,879,-1,889,1154,185,-1,1154,889,179,-1,1409,1148,1418,-1,199,1148,1409,-1,1410,1418,1403,-1,1409,1418,1410,-1,53,892,60,-1,53,55,892,-1,1411,150,1155,-1,310,150,1411,-1,1187,117,116,-1,1187,1188,117,-1,999,924,913,-1,920,924,999,-1,147,913,924,-1,147,153,913,-1,102,1026,1242,-1,1026,102,1137,-1,917,137,52,-1,137,917,136,-1,919,173,918,-1,173,919,909,-1,923,924,920,-1,924,923,910,-1,170,129,1007,-1,129,170,156,-1,97,92,91,-1,996,92,97,-1,884,949,1415,-1,1161,949,884,-1,96,87,996,-1,95,87,96,-1,823,820,1151,-1,823,1004,820,-1,92,932,86,-1,932,92,994,-1,1150,937,935,-1,938,937,1150,-1,302,830,78,-1,936,830,302,-1,831,993,940,-1,993,831,832,-1,943,925,934,-1,943,76,925,-1,58,944,45,-1,944,58,282,-1,947,944,282,-1,947,945,944,-1,294,295,46,-1,294,843,295,-1,39,844,267,-1,845,844,39,-1,290,983,842,-1,290,1414,983,-1,1415,948,1413,-1,948,1415,949,-1,265,858,247,-1,265,984,858,-1,39,1142,40,-1,39,266,1142,-1,189,36,190,-1,1006,36,189,-1,34,1006,1005,-1,34,36,1006,-1,955,886,1175,-1,955,887,886,-1,981,1417,1405,-1,229,1417,981,-1,868,979,869,-1,868,1416,979,-1,1172,960,1167,-1,960,1172,961,-1,1206,962,961,-1,962,1206,963,-1,25,188,965,-1,25,235,188,-1,1394,1014,864,-1,1394,1220,1014,-1,965,977,959,-1,188,977,965,-1,970,861,261,-1,970,968,861,-1,975,2,264,-1,1170,2,975,-1,1015,972,1404,-1,1015,973,972,-1,968,1404,969,-1,968,970,1404,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c5_Coord',point=[(0,53.82202,-1.76814),(-.12786,53.76951,-1.82154),(-.06137,53.82115,-1.75411),(-.08286,53.41889,-2.27255),(-.04873,53.41271,-2.19331),(-.07927,53.39055,-2.24244),(-.11143,53.39068,-2.31553),(-.1141,53.3685,-2.28827),(-.14578,53.31215,-2.35443),(-.19636,53.42911,-2.29284),(-.20165,53.35865,-2.31984),(-.1703,53.36728,-2.27368),(-.39331,53.86847,-1.41602),(-.38895,53.86957,-1.40898),(-.33645,53.85249,-1.49252),(-.18802,53.29708,-2.33971),(-.16601,53.28234,-2.31909),(-.16967,53.28137,-2.31577),(-.19295,53.29934,-2.33048),(-.11456,53.33898,-2.18953),(-.11727,53.3396,-2.18899),(-.13675,53.32764,-2.24788),(-.13166,53.3707,-2.03615),(-.13447,53.372,-2.03761),(-.1115,53.33491,-2.12926),(-.39925,53.43061,-1.59222),(-.40039,53.54354,-1.58035),(-.35008,53.54131,-1.64526),(-.15501,53.60473,-1.72153),(-.18938,53.51729,-1.74443),(-.11624,53.5213,-1.81352),(-.8711,53.5544,-1.2363),(-.87101,53.55887,-1.23886),(-.91568,53.50623,-1.29032),(-.44296,53.44075,-1.44379),(-.44746,53.43586,-1.44524),(-.4411,53.43844,-1.44744),(-.87021,53.56177,-1.23459),(-.76994,53.76449,-1.40872),(-.76463,53.77596,-1.41509),(-.76791,53.76269,-1.41461),(-.46941,53.84153,-1.38102),(-.54377,53.82169,-1.39125),(-.56967,53.87369,-1.32172),(-.91011,53.46552,-1.0376),(-.91371,53.45016,-1.00778),(-.98407,53.49584,-1.0115),(-.83985,53.69188,-1.17363),(-.76688,53.63233,-1.16361),(-.78839,53.60219,-1.11407),(-.84563,53.50541,-1.06692),(-.84143,53.54998,-1.08749),(-.69549,53.55652,-1.06593),(-.76556,53.41705,-.93737),(-.77379,53.4271,-.93291),(-.76832,53.41696,-.94048),(-.74822,53.41197,-1.04821),(-.77785,53.40243,-.99959),(-.86081,53.42675,-1.01835),(-.70473,53.39801,-.92386),(-.72077,53.39575,-.95967),(-.69299,53.40241,-.96685),(-.78263,53.85071,-1.07101),(-.77722,53.86683,-1.06404),(-.82341,53.94666,-1.06099),(-.91961,53.65889,-.98848),(-.97315,53.57491,-.9677),(-.91406,53.65139,-.97874),(-.80532,53.76443,-1.06361),(-.81271,53.77835,-1.07104),(-.83815,53.71308,-1.04501),(-.75128,53.63351,-.77925),(-.74635,53.53984,-.82364),(-.75007,53.62903,-.76958),(-.76951,53.84924,-1.06622),(-.78297,53.4591,-.92671),(-.77085,53.46268,-.90582),(-.77331,53.47409,-.90549),(-.71902,53.68152,-.74735),(-.68119,53.63396,-.7144),(-.65973,53.71424,-.72283),(-.56627,53.69607,-1.10756),(-.50634,53.73443,-1.1248),(-.58099,53.73474,-1.11063),(-.43788,53.77051,-1.11354),(-.39256,53.80573,-1.14105),(-.42144,53.78056,-1.17648),(-.4619,53.90598,-1.1916),(-.50687,53.87216,-1.15403),(-.51256,53.79211,-1.1646),(-.37329,53.74569,-1.22187),(-.41256,53.74584,-1.22692),(-.45171,53.7863,-1.18542),(-.40945,53.90757,-1.31026),(-.43256,53.94493,-1.25071),(-.42736,53.90136,-1.24839),(-.43337,53.82995,-1.24253),(-.43792,53.7759,-1.23809),(-.42757,53.72432,-1.27449),(-.38227,53.47528,-.894),(-.41278,53.47489,-.92652),(-.37273,53.43765,-.94311),(-.57357,53.5035,-.85942),(-.65335,53.47577,-.83905),(-.63646,53.43353,-.88542),(-.65586,53.58668,-.92095),(-.65631,53.53939,-.92789),(-.64285,53.5367,-.99842),(-.58098,53.56186,-1.03428),(-.581,53.56654,-1.03062),(-.61258,53.55131,-1.01432),(-.56665,53.48412,-.88781),(-.56665,53.48655,-.89199),(-.50411,53.50115,-.9201),(-.49167,53.5352,-1.03039),(-.48045,53.52986,-.96954),(-.49315,53.54432,-1.02407),(-.53475,53.56719,-1.04291),(-.5397,53.56123,-1.04771),(-.49979,53.4972,-.91831),(-.43886,53.48472,-.96239),(-.66325,53.57934,-1.00412),(-.68888,53.5851,-1.02685),(-.69582,53.57888,-1.01875),(-.64801,53.527,-1.01454),(-.67544,53.46827,-.9884),(-.69608,53.46056,-1.03478),(-.58341,53.56376,-1.0414),(-.58044,53.56521,-1.05143),(-.55844,53.56101,-1.07391),(-.70127,53.59869,-1.05577),(-.69527,53.5957,-1.06142),(-.67953,53.63669,-1.08001),(-.59623,53.66915,-1.0967),(-.59007,53.67944,-1.0987),(-.63221,53.6857,-1.09841),(-.67973,53.58969,-1.08566),(-.69251,53.56706,-1.06262),(-.49982,53.57825,-.92031),(-.48624,53.58779,-.97595),(-.59571,53.7734,-1.1137),(-.6057,53.84227,-1.09404),(-.68146,53.83675,-1.06852),(-.71129,53.66971,-1.08182),(-.63907,53.73196,-1.10128),(-.80357,53.77944,-1.06419),(-.61416,53.62355,-1.02238),(-.65635,53.59337,-1.01451),(-.68509,53.64733,-1.08004),(-.71575,53.58485,-1.04447),(-.48229,53.74154,-1.01967),(-.56096,53.68843,-1.04382),(-.55356,53.65473,-1.03936),(-.62528,53.62534,-1.02397),(-.49373,53.5419,-1.16718),(-.47965,53.52643,-1.14995),(-.52076,53.54171,-1.10475),(-.37498,53.39404,-1.15261),(-.3756,53.39349,-1.03515),(-.38456,53.39896,-1.15212),(-.29718,53.37563,-1.28089),(-.29666,53.36994,-1.27553),(-.30674,53.37789,-1.27716),(-.234,53.74684,-.84071),(-.22525,53.74127,-.84191),(-.22115,53.77663,-.92511),(-.40718,53.70589,-1.24602),(-.35806,53.5096,-1.49957),(-.33963,53.58503,-1.50039),(-.39038,53.66177,-1.38836),(-.53754,53.56,-1.21874),(-.63878,53.58674,-1.21681),(-.54287,53.56463,-1.25822),(-.62901,53.58155,-1.10999),(-.69914,53.60147,-1.15355),(-.62958,53.57888,-1.15109),(-.41528,53.44554,-1.20215),(-.37231,53.44782,-1.23569),(-.37035,53.40207,-1.22319),(-.35237,53.34352,-.92879),(-.34674,53.32371,-.88504),(-.35552,53.40125,-.89784),(-.35587,53.35679,-.94409),(-.41056,53.464,-1.02947),(-.38284,53.40067,-1.03331),(-.33728,53.2835,-.88119),(-.26309,53.27578,-.92061),(-.25313,53.24362,-.88283),(-.46102,53.38649,-1.57165),(-.42031,53.43039,-1.53094),(-.48657,53.37804,-1.525),(-.49052,53.57951,-1.25985),(-.45087,53.58072,-1.23716),(-.47868,53.51751,-1.04378),(-.19005,53.27108,-.89973),(-.17517,53.23647,-.84531),(-.19044,53.32223,-.97368),(-.25761,53.30521,-.96929),(-.26688,53.35101,-1.05499),(-.11181,53.34152,-1.27828),(-.11496,53.35716,-1.21968),(-.20144,53.35985,-1.21925),(-.27646,53.36751,-1.22065),(-.36427,53.39576,-1.21776),(-.27363,53.37478,-1.15211),(-.276,53.86907,-.98934),(-.2172,53.81223,-1.0006),(-.21509,53.85813,-1.08336),(-.15854,53.78492,-.99507),(-.07547,53.76929,-.99375),(-.07203,53.80117,-1.10239),(-.16197,53.75919,-.91546),(-.32994,53.90908,-.97837),(-.32752,53.89662,-.88803),(-.27512,53.82808,-.9131),(-.26589,53.78657,-.82213),(-.31619,53.86883,-.80757),(-.37028,53.9292,-.78738),(-.33122,53.86734,-.7065),(-.12546,53.44961,-2.14259),(-.15084,53.5023,-2.00856),(-.14081,53.41841,-1.96784),(-.14239,53.43447,-1.92091),(-.15642,53.4766,-2.22155),(-.13935,53.58472,-2.0226),(-.13287,53.56954,-2.08568),(-.13,53.47398,-2.06982),(-.33893,53.6206,-1.62835),(-.65512,53.38889,-1.46799),(-.65615,53.3323,-1.5324),(-.56067,53.33827,-1.55355),(-.69252,53.50485,-1.32129),(-.76673,53.50864,-1.30146),(-.82721,53.4935,-1.31928),(-.37617,53.4667,-1.54379),(-.39784,53.42924,-1.58978),(-.33583,53.42871,-1.63333),(-.08481,53.59214,-1.77353),(-.05754,53.5112,-1.87389),(-.137,53.4166,-1.96683),(-.04003,53.46401,-1.95477),(-.0421,53.42813,-2.04108),(-.10859,53.3342,-2.12835),(-.07812,53.614,-2.09559),(-.10474,53.70433,-1.92573),(-.16035,53.5956,-1.94031),(-.18228,53.60721,-1.86916),(-.5064,53.75375,-1.46156),(-.49467,53.71418,-1.51059),(-.59221,53.69659,-1.49759),(-.64507,53.75252,-1.45031),(-.6514,53.68857,-1.48625),(-.72539,53.67853,-1.47124),(-.15641,53.69819,-1.85662),(-.06238,53.74344,-1.73724),(-.0681,53.66574,-1.75338),(0,53.65995,-1.78296),(0,53.44627,-2.03341),(0,53.4455,-2.10664),(0,53.54024,-2.1998),(0,53.4773,-2.20334),(-.0577,53.50646,-2.22004),(-.09451,53.65486,-2.01848),(0,53.71472,-1.96947),(-.14035,53.82291,-1.72363),(-.50913,53.76588,-1.45779),(-.68726,53.76927,-1.44781),(-.66288,53.83682,-1.38115),(-.39908,53.87774,-1.40965),(-.46615,53.90741,-1.32217),(-.91784,53.53939,-1.36675),(-.87908,53.5723,-1.43083),(-.90924,53.44833,-1.44543),(-.78792,53.67218,-1.45545),(-.8209,53.59329,-1.48201),(-.85402,53.61476,-1.24939),(-.85316,53.66637,-1.3107),(-.84591,53.77846,-1.30062),(-.81121,53.72191,-1.361),(-.77155,53.61118,-1.18919),(-.69118,53.60049,-1.20069),(-.80696,53.41009,-.97112),(-.86203,53.42016,-.97975),(-.84465,53.62157,-1.10688),(-.83535,53.66255,-1.20367),(-.86944,53.77221,-1.21368),(-.84913,53.73767,-1.25932),(-.92378,53.6456,-1.02047),(-.86506,53.82487,-1.15211),(-.85826,53.90294,-1.17802),(-.82042,54.02045,-1.11883),(-.74465,53.64612,-1.07907),(-.74543,53.56595,-1.03101),(-.72466,53.56419,-.99343),(-.98692,53.56986,-1.01861),(-.91236,53.51981,-1.05128),(-.78016,53.53779,-.98395),(-.80849,53.46954,-.94948),(-.78323,53.47175,-.92556),(-.71415,53.58752,-.88295),(-.70194,53.64691,-.84381),(-.59147,53.74413,-.77965),(-.67012,53.7405,-.74436),(-.69584,53.70126,-.81799),(-.63614,53.66351,-.86789),(-.66496,53.62691,-.9085),(-.31696,53.78423,-1.21857),(-.48319,53.7353,-1.08603),(-.46231,53.82011,-1.00828),(-.45875,53.81613,-.92562),(-.46385,53.73399,-.95244),(-.49267,53.71712,-.88517),(-.45308,53.82309,-.81003),(-.51155,53.70916,-.78931),(-.42417,53.78113,-.77478),(-.27549,53.48448,-.84121),(-.28668,53.43685,-.83538),(-.25709,53.42728,-.80399),(-.24055,53.4683,-.80533),(-.25268,53.52178,-.79458),(-.39371,53.82705,-.72637),(-.42508,53.86657,-.80097),(-.4362,53.88727,-.91103),(-.42188,53.89269,-.99951),(-.31856,53.79936,-.68836),(-.37215,53.78889,-.71916),(-.36536,53.73406,-.72901),(-.24778,53.6643,-.73483),(-.35418,53.67233,-.76237),(-.32346,53.60667,-.79401),(-.22987,53.55908,-.74808),(-.24116,53.6578,-.73415),(.49052,53.57951,-1.25985),(.45087,53.58072,-1.23716),(.41003,53.66698,-1.25762),(.42508,53.86657,-.80097),(.33811,53.86635,-.70335),(.39371,53.82705,-.72637),(.39664,53.95627,-.97139),(.38958,53.95284,-.88133),(.4362,53.88727,-.91103),(.30534,53.84864,-1.20658),(.24279,53.72722,-1.24578),(.23137,53.80291,-1.22002),(.46231,53.82011,-1.00828),(.39256,53.80573,-1.14105),(.39004,53.87934,-1.12314),(.4283,53.8711,-.81457),(.45898,53.8208,-.819),(.35418,53.67233,-.76237),(.32346,53.60667,-.79401),(.40377,53.63624,-.7932),(.27549,53.48448,-.84121),(.29947,53.54558,-.81754),(.25268,53.52178,-.79458),(.24055,53.4683,-.80533),(.25709,53.42728,-.80399),(.32888,53.47988,-.8676),(.32968,53.50737,-.84796),(.49382,53.57386,-.83252),(.49447,53.64451,-.80295),(.53896,53.72793,-.84709),(.49267,53.71712,-.88517),(.48229,53.74154,-1.01967),(.45875,53.81613,-.92562),(.37719,53.70105,-1.23577),(.31696,53.78423,-1.21857),(.37329,53.74569,-1.22187),(.26609,53.61057,-1.26564),(.18253,53.49668,-1.28441),(.17337,53.58838,-1.25814),(.60882,53.64701,-.7545),(.59147,53.74413,-.77965),(.51155,53.70916,-.78931),(.60456,53.70275,-.7514),(.63614,53.66351,-.86789),(.61474,53.71663,-.82401),(.65586,53.58668,-.92095),(.66496,53.62691,-.9085),(.59355,53.74593,-.78557),(.6729,53.74405,-.75496),(.66326,53.72881,-.80055),(.75128,53.63351,-.77925),(.70194,53.64691,-.84381),(.69584,53.70126,-.81799),(.98692,53.56986,-1.01861),(.9146,53.5741,-1.06505),(.92378,53.6456,-1.02047),(.82217,53.57649,-.98418),(.91187,53.65522,-.98155),(.82991,53.71144,-1.04013),(.55153,53.77263,-1.13971),(.53115,53.75263,-1.13701),(.58099,53.73474,-1.11063),(.64592,53.77821,-1.10416),(.63907,53.73196,-1.10128),(.80357,53.77944,-1.06419),(.72728,54.03577,-1.09942),(.70583,53.92016,-1.05579),(.82341,53.94666,-1.06099),(.78263,53.85071,-1.07101),(.86506,53.82487,-1.15211),(.85399,53.67522,-1.07104),(.84064,53.7525,-1.1425),(.81271,53.77835,-1.07104),(.85826,53.90294,-1.17802),(.8755,53.83091,-1.26626),(.85319,53.91442,-1.28002),(.83985,53.69188,-1.17363),(.69549,53.55652,-1.06593),(.67922,53.58514,-1.09291),(.78839,53.60219,-1.11407),(.85402,53.61476,-1.24939),(.85316,53.66637,-1.3107),(.84913,53.73767,-1.25932),(.79129,53.57018,-1.23461),(.87021,53.56177,-1.23459),(.91568,53.50623,-1.29032),(.92947,53.42214,-1.37768),(.91784,53.53939,-1.36675),(.72166,53.88106,-1.34364),(.75877,53.9401,-1.27024),(.84612,53.91985,-1.28278),(.39908,53.87774,-1.40965),(.46941,53.84153,-1.38102),(.4304,53.80317,-1.4558),(.66288,53.83682,-1.38115),(.65004,53.88438,-1.31034),(.46615,53.90741,-1.32217),(.56967,53.87369,-1.32172),(.26104,53.76883,-1.67585),(.20419,53.76112,-1.76449),(.14035,53.82291,-1.72363),(0,53.76693,-1.87148),(.12786,53.76951,-1.82154),(.05754,53.5112,-1.87389),(0,53.48298,-1.94557),(.04003,53.46401,-1.95477),(.21821,53.69458,-1.77329),(.0421,53.42813,-2.04108),(.13166,53.3707,-2.03615),(.137,53.4166,-1.96683),(.13515,53.4319,-1.9182),(.17492,53.43321,-1.8607),(.11624,53.5213,-1.81352),(.18938,53.51729,-1.74443),(.24103,53.51804,-1.67666),(.23703,53.59586,-1.65115),(.54287,53.56463,-1.25822),(.46216,53.58164,-1.34391),(.48867,53.49802,-1.36504),(.60932,53.49085,-1.35429),(.49297,53.49265,-1.36732),(.55139,53.45994,-1.39302),(.54139,53.40152,-1.46981),(.59001,53.38495,-1.47767),(.52421,53.43001,-1.4331),(.13056,53.42983,-2.31765),(.13679,53.36828,-2.34892),(.11143,53.39068,-2.31553),(.19349,53.53464,-1.87814),(.18036,53.43504,-1.86506),(.14239,53.43447,-1.92091),(.13447,53.372,-2.03761),(.13,53.47398,-2.06982),(.15084,53.5023,-2.00856),(.13675,53.32764,-2.24788),(.1703,53.36728,-2.27368),(.14885,53.41816,-2.20421),(.26723,53.75503,-.74205),(.26589,53.78657,-.82213),(.234,53.74684,-.84071),(.23398,53.69832,-.76557),(.22525,53.74127,-.84191),(.16564,53.68969,-.75165),(.36427,53.39576,-1.21776),(.37498,53.39404,-1.15261),(.27363,53.37478,-1.15211),(.09677,53.28842,-.88253),(.19044,53.32223,-.97368),(.19005,53.27108,-.89973),(.38284,53.40067,-1.03331),(.38456,53.39896,-1.15212),(.44373,53.45777,-1.13721),(.37231,53.44782,-1.23569),(.35096,53.5585,-1.243),(.40753,53.55834,-1.22754),(.30674,53.37789,-1.27716),(.37035,53.40207,-1.22319),(.74211,53.53759,-.92144),(.76852,53.47895,-.87151),(.77331,53.47409,-.90549),(.76951,53.84924,-1.06622),(.68146,53.83675,-1.06852),(.56893,53.92049,-1.2592),(.52444,53.96413,-1.23503),(.58739,53.94216,-1.23713),(.26309,53.27578,-.92061),(.25313,53.24362,-.88283),(.33728,53.2835,-.88119),(.25761,53.30521,-.96929),(.34918,53.34852,-.94534),(.3026,53.28913,-.81751),(.29556,53.24528,-.81665),(.3414,53.2885,-.87495),(.41528,53.44554,-1.20215),(.47965,53.52643,-1.14995),(.61218,53.55206,-1.02033),(.61178,53.54689,-1.0169),(.58098,53.56186,-1.03428),(.7475,53.39853,-.97803),(.77785,53.40243,-.99959),(.80696,53.41009,-.97112),(.62958,53.57888,-1.15109),(.63878,53.58674,-1.21681),(.69118,53.60049,-1.20069),(.53754,53.56,-1.21874),(.65795,53.47301,-.93594),(.66757,53.42136,-.92688),(.63646,53.43353,-.88542),(.38277,53.6616,-1.244),(.39038,53.66177,-1.38836),(.41659,53.76718,-1.33069),(.38714,53.74161,-1.39267),(.29897,53.82691,-.75565),(.28801,53.79246,-.73871),(.31174,53.80094,-.69095),(.2423,53.20698,-.78127),(.29379,53.24058,-.82374),(.37408,53.40087,-1.21658),(.54313,53.65055,-.87201),(.63663,53.59389,-.89304),(.65073,53.55884,-.99617),(.61416,53.62355,-1.02238),(.60229,53.59215,-1.02414),(.56096,53.68843,-1.04382),(.48319,53.7353,-1.08603),(.63096,53.67092,-1.09929),(.59623,53.66915,-1.0967),(.59362,53.57926,-1.09052),(.67953,53.63669,-1.08001),(.68509,53.64733,-1.08004),(.63221,53.6857,-1.09841),(.69527,53.5957,-1.06142),(.68127,53.58796,-1.03515),(.68888,53.5851,-1.02685),(.64475,53.53012,-1.00337),(.64429,53.53169,-1.01125),(.6467,53.53736,-1.01688),(.64801,53.527,-1.01454),(.62901,53.58155,-1.10999),(.67973,53.58969,-1.08566),(.67701,53.53263,-1.03559),(.65567,53.58984,-1.01872),(.65635,53.59337,-1.01451),(.47868,53.51751,-1.04378),(.52076,53.54171,-1.10475),(.53491,53.55962,-1.04806),(.49167,53.5352,-1.03039),(.74126,53.42648,-.91847),(.70473,53.39801,-.92386),(.72077,53.39575,-.95967),(.56665,53.48655,-.89199),(.63259,53.47305,-.91172),(.63443,53.46262,-.90979),(.61258,53.55131,-1.01432),(.65631,53.53939,-.92789),(.64285,53.5367,-.99842),(.65625,53.48407,-.93356),(.50411,53.50115,-.9201),(.49979,53.4972,-.91831),(.47515,53.52101,-.97284),(.4218,53.67298,-1.3442),(.38895,53.86957,-1.40898),(.38925,53.82223,-1.40129),(.41987,53.86177,-1.32049),(.41256,53.74584,-1.22692),(.4619,53.90598,-1.1916),(.50687,53.87216,-1.15403),(.50135,53.91607,-1.15421),(.43788,53.77051,-1.11354),(.46382,53.76222,-1.1474),(.50634,53.73443,-1.1248),(.49026,53.77355,-1.16113),(.86727,53.52043,-.9442),(.85964,53.53143,-.94593),(.80849,53.46954,-.94948),(.97315,53.57491,-.9677),(.9551,53.57843,-.94374),(.96606,53.56806,-.94294),(.53002,53.76455,-.79124),(.53285,53.7661,-.79664),(.78297,53.4591,-.92671),(.77085,53.46268,-.90582),(.77379,53.4271,-.93291),(.76462,53.46873,-.86578),(.74384,53.52993,-.8174),(.70698,53.49207,-.81158),(.91011,53.46552,-1.0376),(.91371,53.45016,-1.00778),(.86081,53.42675,-1.01835),(.9086,53.44972,-.97205),(.8614,53.42542,-.96998),(.97425,53.49029,-.96513),(.91252,53.44504,-.98184),(.81058,53.41854,-.96177),(.86203,53.42016,-.97975),(.69914,53.60147,-1.15355),(.76688,53.63233,-1.16361),(.51196,53.99716,-1.15276),(.5146,53.99844,-1.15033),(.51558,54.00144,-1.1571),(.85531,53.97947,-1.20671),(.40945,53.90757,-1.31026),(.81652,53.8364,-1.3438),(.76463,53.77596,-1.41509),(.80924,53.84283,-1.34673),(.78596,53.5702,-1.23043),(.7867,53.56357,-1.23434),(.92711,53.41376,-1.38575),(.92883,53.41682,-1.38272),(.92678,53.41537,-1.3783),(.65688,53.33286,-1.53711),(.56067,53.33827,-1.55355),(.56015,53.33965,-1.55802),(.22325,53.83898,-1.643),(.14159,53.7431,-1.70988),(.2258,53.76277,-1.6421),(.14338,53.6825,-1.70963),(.06238,53.74344,-1.73724),(.35806,53.5096,-1.49957),(.29711,53.50795,-1.59765),(.37617,53.4667,-1.54379),(.39784,53.42924,-1.58978),(.33583,53.42871,-1.63333),(.39925,53.43061,-1.59222),(.54803,53.34243,-1.55585),(.19295,53.29934,-2.33048),(.18802,53.29708,-2.33971),(.19462,53.36087,-2.32772),(.07299,53.56251,-2.15704),(.07812,53.614,-2.09559),(.13287,53.56954,-2.08568),(.1852,53.43551,-2.2982),(.19636,53.42911,-2.29284),(.10034,53.4708,-2.27171),(.09459,53.46458,-2.27211),(.0577,53.50646,-2.22004),(.14424,53.36389,-2.35642),(.15321,53.30447,-2.35934),(.13295,53.3274,-2.24918),(.16601,53.28234,-2.31909),(.16967,53.28137,-2.31577),(.1115,53.33491,-2.12926),(.13612,53.53585,-2.15199),(.15642,53.4766,-2.22155),(.12553,53.54236,-2.15303),(.06137,53.82115,-1.75411),(.04879,53.43952,-2.23936),(.08286,53.41889,-2.27255),(.04873,53.41271,-2.19331),(.14578,53.31215,-2.35443),(.1141,53.3685,-2.28827),(.20165,53.35865,-2.31984),(.39331,53.86847,-1.41602),(.34203,53.85411,-1.49493),(.11727,53.3396,-2.18899),(.10859,53.3342,-2.12835),(.35008,53.54131,-1.64526),(.40039,53.54354,-1.58035),(.15501,53.60473,-1.72153),(.8711,53.5544,-1.2363),(.91194,53.50289,-1.28758),(.87101,53.55887,-1.23886),(.44296,53.44075,-1.44379),(.4411,53.43844,-1.44744),(.44746,53.43586,-1.44524),(.76994,53.76449,-1.40872),(.76791,53.76269,-1.41461),(.54377,53.82169,-1.39125),(.59539,53.76778,-1.45393),(.98407,53.49584,-1.0115),(.84563,53.50541,-1.06692),(.71945,53.45757,-1.07119),(.74822,53.41197,-1.04821),(.69299,53.40241,-.96685),(.91961,53.65889,-.98848),(.83815,53.71308,-1.04501),(.7434,53.5376,-.81254),(.74635,53.53984,-.82364),(.91406,53.65139,-.97874),(.86753,53.53611,-.94461),(.78323,53.47175,-.92556),(.65973,53.71424,-.72283),(.68119,53.63396,-.7144),(.71902,53.68152,-.74735),(.56627,53.69607,-1.10756),(.42144,53.78056,-1.17648),(.47359,53.81159,-1.18948),(.51256,53.79211,-1.1646),(.45171,53.7863,-1.18542),(.43256,53.94493,-1.25071),(.42736,53.90136,-1.24839),(.43886,53.48472,-.96239),(.41056,53.464,-1.02947),(.57357,53.5035,-.85942),(.56665,53.48412,-.88781),(.581,53.56654,-1.03062),(.49315,53.54432,-1.02407),(.48045,53.52986,-.96954),(.5397,53.56123,-1.04771),(.53475,53.56719,-1.04291),(.66325,53.57934,-1.00412),(.69582,53.57888,-1.01875),(.69608,53.46056,-1.03478),(.7206,53.40719,-1.00753),(.70127,53.59869,-1.05577),(.69251,53.56706,-1.06262),(.54591,53.60799,-1.04218),(.50411,53.61345,-1.02949),(.48624,53.58779,-.97595),(.49982,53.57825,-.92031),(.6057,53.84227,-1.09404),(.59571,53.7734,-1.1137),(.71129,53.66971,-1.08182),(.62528,53.62534,-1.02397),(.70388,53.56242,-.95586),(.41278,53.47489,-.92652),(.37273,53.43765,-.94311),(.35587,53.35679,-.94409),(.35237,53.34352,-.92879),(.22178,53.45725,-.77524),(.22115,53.77663,-.92511),(.42757,53.72432,-1.27449),(.40718,53.70589,-1.24602),(.33963,53.58503,-1.50039),(.35552,53.40125,-.89784),(.34674,53.32371,-.88504),(.32863,53.71393,-1.22802),(.65335,53.47577,-.83905),(.69242,53.55568,-.76291),(.46102,53.38649,-1.57165),(.48657,53.37804,-1.525),(.17517,53.23647,-.84531),(.26688,53.35101,-1.05499),(.27646,53.36751,-1.22065),(.20492,53.36052,-1.15258),(.20144,53.35985,-1.21925),(.3756,53.39349,-1.03515),(.07505,53.20563,-.70068),(.05998,53.28462,-.69011),(0,53.28306,-.68145),(.276,53.86907,-.98934),(.21509,53.85813,-1.08336),(.2172,53.81223,-1.0006),(.15854,53.78492,-.99507),(.07203,53.80117,-1.10239),(.07547,53.76929,-.99375),(.16197,53.75919,-.91546),(.27512,53.82808,-.9131),(.32752,53.89662,-.88803),(.32994,53.90908,-.97837),(.14081,53.41841,-1.96784),(.16865,53.52138,-1.94057),(.13935,53.58472,-2.0226),(.08481,53.59214,-1.77353),(.06106,53.58788,-1.79113),(.03586,53.41741,-2.11679),(.09451,53.65486,-2.01848),(.10474,53.70433,-1.92573),(.15641,53.69819,-1.85662),(.18228,53.60721,-1.86916),(.5064,53.75375,-1.46156),(.59515,53.75459,-1.4561),(.59221,53.69659,-1.49759),(.64507,53.75252,-1.45031),(.68925,53.75589,-1.44789),(.72539,53.67853,-1.47124),(.30024,53.85092,-1.5637),(.31279,53.78553,-1.59338),(.50913,53.76588,-1.45779),(.41384,53.91215,-1.31341),(.8209,53.59329,-1.48201),(.78792,53.67218,-1.45545),(.83563,53.63784,-1.40079),(.87355,53.60674,-1.33257),(.81121,53.72191,-1.361),(.84591,53.77846,-1.30062),(.77155,53.61118,-1.18919),(.86944,53.77221,-1.21368),(.861,53.97512,-1.20192),(.82042,54.02045,-1.11883),(.74465,53.64612,-1.07907),(.71575,53.58485,-1.04447),(.74543,53.56595,-1.03101),(.72466,53.56419,-.99343),(.91236,53.51981,-1.05128),(.78016,53.53779,-.98395),(.67012,53.7405,-.74436),(.71415,53.58752,-.88295),(.46385,53.73399,-.95244),(.45308,53.82309,-.81003),(.28668,53.43685,-.83538),(.42188,53.89269,-.99951),(.24778,53.6643,-.73483),(.24116,53.6578,-.73415),(-.42731,53.67197,-1.29071),(-.41003,53.66698,-1.25762),(-.39664,53.95627,-.97139),(-.38958,53.95284,-.88133),(-.39004,53.87934,-1.12314),(-.45898,53.8208,-.819),(-.4283,53.8711,-.81457),(-.40377,53.63624,-.7932),(-.4142,53.71475,-.77342),(-.31551,53.44287,-.86946),(-.38386,53.53026,-.85472),(-.49447,53.64451,-.80295),(-.53896,53.72793,-.84709),(-.53285,53.7661,-.79664),(-.32863,53.71393,-1.22802),(-.37719,53.70105,-1.23577),(-.27219,53.51967,-1.27759),(-.26609,53.61057,-1.26564),(-.17337,53.58838,-1.25814),(-.53002,53.76455,-.79124),(-.61474,53.71663,-.82401),(-.59355,53.74593,-.78557),(-.66326,53.72881,-.80055),(-.69575,53.39564,-.88943),(-.72032,53.68636,-.75799),(-.86753,53.53611,-.94461),(-.9551,53.57843,-.94374),(-.82217,53.57649,-.98418),(-.78701,53.62871,-1.04916),(-.82991,53.71144,-1.04013),(-.64592,53.77821,-1.10416),(-.70583,53.92016,-1.05579),(-.72728,54.03577,-1.09942),(-.84064,53.7525,-1.1425),(-.85399,53.67522,-1.07104),(-.8755,53.83091,-1.26626),(-.861,53.97512,-1.20192),(-.9146,53.5741,-1.06505),(-.72166,53.88106,-1.34364),(-.80924,53.84283,-1.34673),(-.84612,53.91985,-1.28278),(-.59539,53.76778,-1.45393),(-.65004,53.88438,-1.31034),(-.6907,53.92775,-1.26624),(-.63581,53.91428,-1.27207),(-.62158,53.94936,-1.22596),(-.56893,53.92049,-1.2592),(-.30024,53.85092,-1.5637),(-.36546,53.78859,-1.53019),(-.34203,53.85411,-1.49493),(-.26104,53.76883,-1.67585),(-.22737,53.84065,-1.64699),(-.42285,53.79226,-1.45924),(-.40554,53.71717,-1.52247),(-.21821,53.69458,-1.77329),(-.12553,53.54236,-2.15303),(-.13612,53.53585,-2.15199),(-.04879,53.43952,-2.23936),(-.17492,53.43321,-1.8607),(-.13515,53.4319,-1.9182),(-.23703,53.59586,-1.65115),(-.24103,53.51804,-1.67666),(-.56032,53.53357,-1.29969),(-.48867,53.49802,-1.36504),(-.46216,53.58164,-1.34391),(-.16865,53.52138,-1.94057),(-.19349,53.53464,-1.87814),(-.26723,53.75503,-.74205),(-.23398,53.69832,-.76557),(-.16444,53.72508,-.83381),(-.32317,53.90915,-1.04193),(-.15636,53.19932,-.73402),(-.08824,53.23472,-.80468),(-.07381,53.20176,-.70669),(-.10451,53.32227,-.96478),(-.09677,53.28842,-.88253),(-.44373,53.45777,-1.13721),(-.40753,53.55834,-1.22754),(-.52444,53.96413,-1.23503),(-.4901,53.93851,-1.27737),(-.72315,53.56365,-1.23162),(-.7867,53.56357,-1.23434),(-.3026,53.28913,-.81751),(-.3414,53.2885,-.87495),(-.29556,53.24528,-.81665),(-.61178,53.54689,-1.0169),(-.7475,53.39853,-.97803),(-.65795,53.47301,-.93594),(-.63443,53.46262,-.90979),(-.35096,53.5585,-1.243),(-.38277,53.6616,-1.244),(-.29897,53.82691,-.75565),(-.28801,53.79246,-.73871),(-.23869,53.37009,-.76683),(-.22178,53.45725,-.77524),(-.2423,53.20698,-.78127),(-.29379,53.24058,-.82374),(-.37408,53.40087,-1.21658),(-.54313,53.65055,-.87201),(-.55571,53.56689,-.88517),(-.63663,53.59389,-.89304),(-.65073,53.55884,-.99617),(-.63096,53.67092,-1.09929),(-.62906,53.58753,-1.10404),(-.68127,53.58796,-1.03515),(-.58672,53.67474,-1.05162),(-.59283,53.66509,-1.05991),(-.62381,53.62208,-1.02974),(-.61218,53.55206,-1.02033),(-.64475,53.53012,-1.00337),(-.58565,53.57074,-1.04746),(-.67922,53.58514,-1.09291),(-.58956,53.57256,-1.09407),(-.59362,53.57926,-1.09052),(-.6467,53.53736,-1.01688),(-.64429,53.53169,-1.01125),(-.67701,53.53263,-1.03559),(-.67558,53.54461,-1.03399),(-.65567,53.58984,-1.01872),(-.74126,53.42648,-.91847),(-.63259,53.47305,-.91172),(-.65625,53.48407,-.93356),(-.47515,53.52101,-.97284),(-.4218,53.67298,-1.3442),(-.41987,53.86177,-1.32049),(-.50135,53.91607,-1.15421),(-.46382,53.76222,-1.1474),(-.53115,53.75263,-1.13701),(-.73264,53.42916,-.87532),(-.70698,53.49207,-.81158),(-.6729,53.74405,-.75496),(-.74384,53.52993,-.8174),(-.7434,53.5376,-.81254),(-.85964,53.53143,-.94593),(-.86727,53.52043,-.9442),(-.81333,53.4555,-.95031),(-.3776,53.92903,-.78594),(-.76462,53.46873,-.86578),(-.91252,53.44504,-.98184),(-.9086,53.44972,-.97205),(-.97425,53.49029,-.96513),(-.8614,53.42542,-.96998),(-.51196,53.99716,-1.15276),(-.51558,54.00144,-1.1571),(-.5146,53.99844,-1.15033),(-.85319,53.91442,-1.28002),(-.41384,53.91215,-1.31341),(-.81652,53.8364,-1.3438),(-.79129,53.57018,-1.23461),(-.78596,53.5702,-1.23043),(-.92883,53.41682,-1.38272),(-.92678,53.41537,-1.3783),(-.92947,53.42214,-1.37768),(-.56015,53.33965,-1.55802),(-.22325,53.83898,-1.643),(-.2258,53.76277,-1.6421),(-.14159,53.7431,-1.70988),(-.14338,53.6825,-1.70963),(-.34011,53.43048,-1.63705),(-.4637,53.38802,-1.5762),(-.46662,53.42726,-1.59118),(-.19462,53.36087,-2.32772),(-.14804,53.48529,-2.22816),(-.1852,53.43551,-2.2982),(-.10034,53.4708,-2.27171),(-.09459,53.46458,-2.27211),(-.14424,53.36389,-2.35642),(-.13679,53.36828,-2.34892),(-.15321,53.30447,-2.35934),(-.13395,53.81897,-1.71782),(-.07299,53.56251,-2.15704),(-.54803,53.34243,-1.55585),(-.29711,53.50795,-1.59765),(-.49297,53.49265,-1.36732),(-.48727,53.49686,-1.36745),(-.65688,53.33286,-1.53711),(-.92711,53.41376,-1.38575),(-.85531,53.97947,-1.20671),(-.4304,53.80317,-1.4558),(-.42065,53.79632,-1.46049),(-.75711,54.00213,-1.18565),(-.68591,54.01129,-1.16485),(-.66836,53.94512,-1.2338),(-.64436,53.76582,-1.44916),(-.81058,53.41854,-.96177),(-.97747,53.48589,-.98083),(-.85119,53.45761,-1.0522),(-.96606,53.56806,-.94294),(-.49026,53.77355,-1.16113),(-.38925,53.82223,-1.40129),(-.47359,53.81159,-1.18948),(-.65907,53.47748,-.94299),(-.70388,53.56242,-.95586),(-.61677,53.55804,-1.02291),(-.60229,53.59215,-1.02414),(-.66757,53.42136,-.92688),(-.23773,53.20589,-.77727),(-.2414,53.20962,-.77218),(-.34031,53.64363,-1.23771),(-.42146,53.55988,-1.40318),(-.3835,53.48751,-1.48067),(-.57835,53.56943,-1.10538),(-.58739,53.94216,-1.23713),(-.74211,53.53759,-.92144),(-.76852,53.47895,-.87151),(-.28712,53.89571,-1.07416),(-.16564,53.68969,-.75165),(-.2422,53.70304,-.76377),(-.18036,53.43504,-1.86506),(-.13056,53.42983,-2.31765),(-.59001,53.38495,-1.47767),(-.54139,53.40152,-1.46981),(-.52421,53.43001,-1.4331),(-.20419,53.76112,-1.76449),(0,53.50903,-1.88269),(-.31279,53.78553,-1.59338),(-.75877,53.9401,-1.27024),(-.91187,53.65522,-.98155),(-.60456,53.70275,-.7514),(-.18253,53.49668,-1.28441),(-.49382,53.57386,-.83252),(-.32968,53.50737,-.84796),(-.32888,53.47988,-.8676),(-.29947,53.54558,-.81754),(.22987,53.55908,-.74808),(.42417,53.78113,-.77478),(.31551,53.44287,-.86946),(.5027,53.51215,-.87434),(.76114,53.53769,-.95269),(.83535,53.66255,-1.20367),(.84143,53.54998,-1.08749),(.84465,53.62157,-1.10688),(.87908,53.5723,-1.43083),(.90924,53.44833,-1.44543),(.68726,53.76927,-1.44781),(.22737,53.84065,-1.64699),(.6514,53.68857,-1.48625),(.49467,53.71418,-1.51059),(.16035,53.5956,-1.94031),(.85342,53.46401,-1.35263),(.82721,53.4935,-1.31928),(.76673,53.50864,-1.30146),(.12546,53.44961,-2.14259),(.15667,53.83121,-1.09663),(.28712,53.89571,-1.07416),(0,53.20964,-.69727),(.29666,53.36994,-1.27553),(.1992,53.34589,-1.06445),(.42031,53.43039,-1.53094),(.75007,53.62903,-.76958),(.49373,53.5419,-1.16718),(.87235,53.35308,-1.47183),(.89849,53.40608,-1.46269),(.42146,53.55988,-1.40318),(.43792,53.7759,-1.23809),(.0681,53.66574,-1.75338),(.29718,53.37563,-1.28089),(.58672,53.67474,-1.05162),(.55356,53.65473,-1.03936),(.6348,53.53905,-.90144),(.55571,53.56689,-.88517),(.59007,53.67944,-1.0987),(.67544,53.46827,-.9884),(.55844,53.56101,-1.07391),(.58044,53.56521,-1.05143),(.58341,53.56376,-1.0414),(.58565,53.57074,-1.04746),(.61677,53.55804,-1.02291),(.38227,53.47528,-.894),(.77722,53.86683,-1.06404),(.80532,53.76443,-1.06361),(.85119,53.45761,-1.0522),(.76556,53.41705,-.93737),(.76832,53.41696,-.94048),(.64436,53.76582,-1.44916),(.54919,53.97729,-1.21063),(.86817,53.34997,-1.47448),(.86717,53.34965,-1.46977),(.34011,53.43048,-1.63705),(.11456,53.33898,-2.18953),(.33645,53.85249,-1.49252),(.07927,53.39055,-2.24244),(.14804,53.48529,-2.22816),(.13395,53.81897,-1.71782),(.4637,53.38802,-1.5762),(.46662,53.42726,-1.59118),(.48727,53.49686,-1.36745),(.65615,53.3323,-1.5324),(.42285,53.79226,-1.45924),(.42065,53.79632,-1.46049),(.75711,54.00213,-1.18565),(.66836,53.94512,-1.2338),(.68591,54.01129,-1.16485),(.97747,53.48589,-.98083),(.73264,53.42916,-.87532),(.3776,53.92903,-.78594),(.81333,53.4555,-.95031),(.72032,53.68636,-.75799),(.69575,53.39564,-.88943),(.42731,53.67197,-1.29071),(.43337,53.82995,-1.24253),(.65907,53.47748,-.94299),(.67558,53.54461,-1.03399),(.62906,53.58753,-1.10404),(.2414,53.20962,-.77218),(.23773,53.20589,-.77727),(.38386,53.53026,-.85472),(.4142,53.71475,-.77342),(.36536,53.73406,-.72901),(.27775,53.72975,-.70455),(.34031,53.64363,-1.23771),(.3835,53.48751,-1.48067),(.57835,53.56943,-1.10538),(.72315,53.56365,-1.23162),(.4901,53.93851,-1.27737),(.10451,53.32227,-.96478),(.15636,53.19932,-.73402),(.07381,53.20176,-.70669),(.08824,53.23472,-.80468),(.16444,53.72508,-.83381),(.2422,53.70304,-.76377),(.56444,53.5272,-1.30286),(.56032,53.53357,-1.29969),(.36546,53.78859,-1.53019),(.63581,53.91428,-1.27207),(.6907,53.92775,-1.26624),(.78701,53.62871,-1.04916),(.5965,53.56211,-.80941),(.27219,53.51967,-1.27759),(.37215,53.78889,-.71916),(-.2838,53.72509,-.70263),(-.5027,53.51215,-.87434),(-.76114,53.53769,-.95269),(-.83563,53.63784,-1.40079),(-.03586,53.41741,-2.11679),(0,53.74001,-1.75504),(-.68925,53.75589,-1.44789),(-.59515,53.75459,-1.4561),(-.06106,53.58788,-1.79113),(-.41076,53.62175,-1.55702),(-.14885,53.41816,-2.20421),(-.15667,53.83121,-1.09663),(-.18747,53.35058,-1.28498),(-.1992,53.34589,-1.06445),(-.69242,53.55568,-.76291),(-.24279,53.72722,-1.24578),(-.87235,53.35308,-1.47183),(-.89849,53.40608,-1.46269),(-.34918,53.34852,-.94534),(-.49385,53.67843,-1.02653),(-.6348,53.53905,-.90144),(-.7206,53.40719,-1.00753),(-.53491,53.55962,-1.04806),(-.41659,53.76718,-1.33069),(-.71945,53.45757,-1.07119),(-.54919,53.97729,-1.21063),(-.86817,53.34997,-1.47448),(-.86717,53.34965,-1.46977),(-.91194,53.50289,-1.28758),(-.13295,53.3274,-2.24918),(0,53.45373,-2.17146),(-.29529,53.84964,-1.56131),(-.28406,53.43966,-1.71382),(-.27919,53.43799,-1.71065),(-.05973,53.81608,-1.7438),(-.33282,53.6912,-1.49314),(-.29326,53.7724,-1.56307),(-.33525,53.79921,-1.49259),(-.29053,53.66856,-1.56587),(-.72166,53.57044,-1.22765),(-.65962,53.54887,-1.25931),(-.65696,53.55507,-1.25526),(-.49105,53.37856,-1.5192),(-.8432,53.39921,-1.5254),(-.84291,53.46892,-1.51672),(-.43679,53.94897,-1.25527),(-.61628,54.02291,-1.12347),(-.72801,54.03864,-1.10668),(-.61567,54.01996,-1.11619),(-.54079,53.92616,-1.11681),(-.38714,53.74161,-1.39267),(-.50411,53.61345,-1.02949),(-.54591,53.60799,-1.04218),(-.27889,53.44479,-1.2817),(0,53.23075,-.81171),(0,53.20542,-.70397),(-.06436,53.60727,-.67249),(-.15471,53.63105,-.69859),(-.15815,53.62164,-.69638),(-.06356,53.61698,-.67567),(-.33811,53.86635,-.70335),(-.31174,53.80094,-.69095),(-.38954,53.95774,-.97178),(-.36812,53.9451,-1.08253),(-.36148,53.94662,-1.07865),(-.16832,53.85656,-1.1567),(-.06642,53.81564,-1.18172),(-.17036,53.85411,-1.16532),(-.06553,53.81882,-1.17317),(-.55153,53.77263,-1.13971),(-.22822,53.69047,-1.64149),(-.29329,53.57368,-1.57288),(-.5763,53.41506,-1.58513),(-.55026,53.85087,-1.11651),(0,53.35407,-1.07687),(-.11465,53.34413,-1.069),(0,53.33167,-.97957),(-.20492,53.36052,-1.15258),(-.24081,53.28075,-.75878),(-.15811,53.20288,-.72848),(-.1531,53.2822,-.71884),(-.07885,53.70506,-.81955),(-.07141,53.67673,-.73661),(-.23608,53.66629,-.73512),(-.23445,53.44726,-1.77825),(-.24499,53.53925,-1.79838),(-.67508,53.49369,-1.5552),(-.67201,53.40223,-1.57372),(-.58464,53.50203,-1.57112),(-.58547,53.60008,-1.54626),(-.48039,53.5284,-1.57691),(-.49747,53.61628,-1.55883),(-.72742,53.45275,-1.39141),(-.74001,53.39578,-1.44387),(-.64226,53.43836,-1.4215),(-.55139,53.45994,-1.39302),(-.60932,53.49085,-1.35429),(-.30068,53.62008,-1.69867),(-.23114,53.60731,-1.78982),(-.2818,53.70717,-1.68807),(-.3239,53.71125,-1.61377),(0,53.57331,-1.819),(-.60638,53.9979,-1.17885),(-.85342,53.46401,-1.35263),(-.85628,53.43129,-1.38772),(-.63321,53.92819,-1.07479),(-.5965,53.56211,-.80941),(-.60882,53.64701,-.7545),(-.05998,53.28462,-.69011),(-.14668,53.34854,-.72559),(-.0547,53.34596,-.69432),(-.08787,53.57795,-1.26078),(-.10116,53.48477,-1.28151),(-.17158,53.68217,-1.24834),(0,53.41348,-.68582),(0,53.34179,-.68629),(-.05457,53.41259,-.69759),(-.16142,53.78213,-1.22112),(-.23137,53.80291,-1.22002),(-.07093,53.74801,-1.23249),(.05966,53.51239,-.67913),(0,53.60304,-.66533),(0,53.50524,-.6686),(.06436,53.60727,-.67249),(.2838,53.72509,-.70263),(.17036,53.85411,-1.16532),(.23239,53.88562,-1.16165),(.16142,53.78213,-1.22112),(.17158,53.68217,-1.24834),(.07093,53.74801,-1.23249),(.07864,53.6635,-1.24532),(.05457,53.41259,-.69759),(0,53.5642,-1.25963),(.10116,53.48477,-1.28151),(0,53.4752,-1.28314),(.08787,53.57795,-1.26078),(.14668,53.34854,-.72559),(.24081,53.28075,-.75878),(.23869,53.37009,-.76683),(.1531,53.2822,-.71884),(.55026,53.85087,-1.11651),(.43679,53.94897,-1.25527),(.78869,53.97355,-1.2259),(.81639,54.02348,-1.12616),(.62158,53.94936,-1.22596),(0,53.647,-2.07887),(.3239,53.71125,-1.61377),(.2818,53.70717,-1.68807),(.58547,53.60008,-1.54626),(.66857,53.60088,-1.52259),(.30068,53.62008,-1.69867),(.33893,53.6206,-1.62835),(.22929,53.44532,-1.7744),(.29329,53.57368,-1.57288),(.65696,53.55507,-1.25526),(.72166,53.57044,-1.22765),(.69252,53.50485,-1.32129),(.64226,53.43836,-1.4215),(.72742,53.45275,-1.39141),(.74001,53.39578,-1.44387),(.76321,53.33291,-1.50818),(.65512,53.38889,-1.46799),(.58464,53.50203,-1.57112),(.67508,53.49369,-1.5552),(.30317,53.5416,-1.71586),(.48039,53.5284,-1.57691),(.5763,53.41506,-1.58513),(.07141,53.67673,-.73661),(.15471,53.63105,-.69859),(.06356,53.61698,-.67567),(.37028,53.9292,-.78738),(.38257,53.95352,-.88144),(.31619,53.86883,-.80757),(.07771,53.73515,-.9058),(.07885,53.70506,-.81955),(0,53.7848,-1.09408),(0,53.75458,-.99226),(.32317,53.90915,-1.04193),(.16832,53.85656,-1.1567),(.23005,53.88796,-1.15276),(.15811,53.20288,-.72848),(0,53.35346,-1.23146),(.11181,53.34152,-1.27828),(.11496,53.35716,-1.21968),(0,53.34334,-1.29195),(.11465,53.34413,-1.069),(0,53.4116,-1.28998),(.10614,53.41522,-1.2825),(0,53.28611,-.87877),(.8432,53.39921,-1.5254),(.7642,53.3332,-1.5129),(.76402,53.38827,-1.55017),(.29053,53.66856,-1.56587),(.33282,53.6912,-1.49314),(0,53.80935,-1.17292),(.06642,53.81564,-1.18172),(0,53.80628,-1.1821),(.06553,53.81882,-1.17317),(.30692,53.91808,-1.14514),(.36148,53.94662,-1.07865),(.36812,53.9451,-1.08253),(.30218,53.92057,-1.13726),(.33122,53.86734,-.7065),(.23608,53.66629,-.73512),(.15815,53.62164,-.69638),(.29788,53.38921,-.82962),(.11111,53.34567,-1.28367),(0,53.348,-1.29698),(.47589,53.68264,-.96672),(.49662,53.67981,-.90062),(.49385,53.67843,-1.02653),(.62381,53.62208,-1.02974),(.59283,53.66509,-1.05991),(.58956,53.57256,-1.09407),(.46877,53.97149,-1.20037),(.33525,53.79921,-1.49259),(.60638,53.9979,-1.17885),(.72801,54.03864,-1.10668),(.47282,53.97559,-1.20527),(.49105,53.37856,-1.5192),(.65962,53.54887,-1.25931),(0,53.81611,-1.75774),(.05973,53.81608,-1.7438),(.29529,53.84964,-1.56131),(.13999,53.43832,-2.31993),(.28406,53.43966,-1.71382),(.27919,53.43799,-1.71065),(.29326,53.7724,-1.56307),(.84291,53.46892,-1.51672),(.61628,54.02291,-1.12347),(.61567,54.01996,-1.11619),(.18736,53.35549,-1.29039),(.18495,53.42608,-1.2873),(.18747,53.35058,-1.28498),(.31856,53.79936,-.68836),(.38954,53.95774,-.97178),(.22822,53.69047,-1.64149),(0,53.66528,-.72901),(0,53.61271,-.66912),(.76035,53.48139,-1.53823),(.23114,53.60731,-1.78982),(.24499,53.53925,-1.79838),(.49747,53.61628,-1.55883),(.40554,53.71717,-1.52247),(.41076,53.62175,-1.55702),(.74115,53.5982,-1.50243),(.63321,53.92819,-1.07479),(.0547,53.34596,-.69432),(.14822,53.53124,-.70084),(-.14822,53.53124,-.70084),(-.23239,53.88562,-1.16165),(-.07864,53.6635,-1.24532),(-.13389,53.42428,-.72862),(-.87355,53.60674,-1.33257),(-.81281,53.4037,-1.42386),(-.78869,53.97355,-1.2259),(0,53.59386,-2.15187),(-.74115,53.5982,-1.50243),(-.22929,53.44532,-1.7744),(-.76035,53.48139,-1.53823),(-.76402,53.38827,-1.55017),(-.30317,53.5416,-1.71586),(-.38257,53.95352,-.88144),(-.07771,53.73515,-.9058),(-.30218,53.92057,-1.13726),(-.11808,53.35482,-1.15722),(0,53.35888,-1.15748),(-.18495,53.42608,-1.2873),(-.13999,53.43832,-2.31993),(-.7642,53.3332,-1.5129),(-.23005,53.88796,-1.15276),(-.27775,53.72975,-.70455),(-.29788,53.38921,-.82962),(-.11111,53.34567,-1.28367),(-.10614,53.41522,-1.2825),(-.47589,53.68264,-.96672),(-.49662,53.67981,-.90062),(-.46877,53.97149,-1.20037),(-.81639,54.02348,-1.12616),(-.47282,53.97559,-1.20527),(-.56444,53.5272,-1.30286),(-.76321,53.33291,-1.50818),(-.18736,53.35549,-1.29039),(-.07505,53.20563,-.70068),(-.30692,53.91808,-1.14514),(0,53.69365,-.8036),(-.24402,53.67271,-.73478),(-.66857,53.60088,-1.52259),(-.05966,53.51239,-.67913),(-.30534,53.84864,-1.20658),(0,53.73691,-1.23102),(0,53.65028,-1.24416),(.13389,53.42428,-.72862),(.54079,53.92616,-1.11681),(.85628,53.43129,-1.38772),(.81281,53.4037,-1.42386),(.67201,53.40223,-1.57372),(.23445,53.44726,-1.77825),(0,53.71849,-.88501),(.11808,53.35482,-1.15722),(.27889,53.44479,-1.2817),(.24402,53.67271,-.73478)]))),
        Shape(DEF='c5disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='c5disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,0,2,12,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,23,14,24,-1,5,25,13,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,46,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,57,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,64,69,70,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,75,-1,82,83,84,-1,85,83,86,-1,87,88,89,-1,90,91,76,-1,92,93,94,-1,95,61,60,-1,96,97,8,-1,53,65,6,-1,98,99,100,-1,101,63,52,-1,102,89,103,-1,102,32,34,-1,102,103,32,-1,104,105,101,-1,53,52,63,-1,106,6,97,-1,107,108,96,-1,22,93,92,-1,19,109,110,-1,110,12,76,-1,89,102,86,-1,111,82,84,-1,112,113,114,-1,115,66,116,-1,7,117,118,-1,119,120,121,-1,122,71,123,-1,123,70,69,-1,124,125,126,-1,101,105,127,-1,128,11,10,-1,129,57,56,-1,56,41,129,-1,49,96,108,-1,130,95,131,-1,132,42,41,-1,48,133,44,-1,46,45,134,-1,50,135,51,-1,57,59,104,-1,136,137,138,-1,104,52,55,-1,139,39,38,-1,4,25,5,-1,140,36,35,-1,25,24,14,-1,44,28,27,-1,18,30,20,-1,141,142,143,-1,144,100,99,-1,20,19,18,-1,145,13,15,-1,146,147,29,-1,148,10,9,-1,149,79,78,-1,103,145,32,-1,8,97,6,-1,30,18,31,-1,91,90,150,-1,78,151,149,-1,15,32,145,-1,16,33,15,-1,99,33,144,-1,152,31,18,-1,27,153,44,-1,14,13,25,-1,140,154,36,-1,4,37,25,-1,139,155,39,-1,136,138,156,-1,104,55,57,-1,46,134,47,-1,48,44,46,-1,132,157,42,-1,131,50,130,-1,56,158,41,-1,128,107,11,-1,101,127,69,-1,8,11,107,-1,123,127,126,-1,123,69,127,-1,121,159,119,-1,160,161,9,-1,7,121,117,-1,74,12,2,-1,112,80,113,-1,83,82,112,-1,111,81,82,-1,111,98,90,-1,102,85,86,-1,91,110,76,-1,162,149,151,-1,151,163,162,-1,17,19,110,-1,22,164,93,-1,107,96,8,-1,165,17,110,-1,100,150,90,-1,63,65,53,-1,104,59,105,-1,59,166,105,-1,34,167,102,-1,89,168,103,-1,52,104,101,-1,100,90,98,-1,106,53,6,-1,150,165,91,-1,60,169,95,-1,19,163,109,-1,92,94,170,-1,76,111,90,-1,171,87,89,-1,171,89,86,-1,83,85,84,-1,112,172,83,-1,173,80,75,-1,76,12,74,-1,174,175,87,-1,73,119,71,-1,70,123,71,-1,70,159,64,-1,66,115,67,-1,8,7,118,-1,61,148,62,-1,176,177,135,-1,58,57,129,-1,108,130,49,-1,54,55,52,-1,178,179,158,-1,50,49,130,-1,47,169,48,-1,44,153,45,-1,41,43,129,-1,38,40,43,-1,35,37,4,-1,99,34,33,-1,32,15,33,-1,28,180,26,-1,13,145,5,-1,24,181,23,-1,20,30,21,-1,143,16,14,-1,12,110,0,-1,149,170,79,-1,11,160,9,-1,110,91,165,-1,182,49,51,-1,168,3,5,-1,58,166,59,-1,183,35,184,-1,140,35,183,-1,185,58,40,-1,185,166,58,-1,170,186,79,-1,170,94,186,-1,62,187,188,-1,189,187,62,-1,21,29,190,-1,21,30,29,-1,23,191,147,-1,23,181,191,-1,33,142,144,-1,16,142,33,-1,143,142,16,-1,21,164,22,-1,21,180,164,-1,190,192,26,-1,190,191,192,-1,193,194,195,-1,193,196,194,-1,24,37,195,-1,24,25,37,-1,139,140,155,-1,154,140,139,-1,138,157,156,-1,138,42,157,-1,134,197,198,-1,134,45,197,-1,106,182,199,-1,97,182,106,-1,47,200,131,-1,47,134,200,-1,136,201,202,-1,136,197,201,-1,177,178,203,-1,179,178,177,-1,158,132,41,-1,158,179,132,-1,204,205,188,-1,206,205,204,-1,63,69,64,-1,63,101,69,-1,207,116,208,-1,115,116,207,-1,123,125,122,-1,123,126,125,-1,122,72,71,-1,66,72,122,-1,209,210,211,-1,209,212,210,-1,211,213,214,-1,211,215,213,-1,161,189,9,-1,161,213,189,-1,64,121,7,-1,64,159,121,-1,216,210,217,-1,216,218,210,-1,217,173,219,-1,173,217,220,-1,221,114,113,-1,114,221,222,-1,87,172,174,-1,172,87,171,-1,109,151,1,-1,151,109,163,-1,84,102,167,-1,102,84,85,-1,223,204,224,-1,223,206,204,-1,92,20,22,-1,20,92,162,-1,206,48,205,-1,133,48,206,-1,167,99,98,-1,34,99,167,-1,3,89,88,-1,89,3,168,-1,183,207,225,-1,183,226,207,-1,124,227,208,-1,185,227,124,-1,130,61,95,-1,130,128,61,-1,228,206,223,-1,228,133,206,-1,93,224,94,-1,93,223,224,-1,84,98,111,-1,167,98,84,-1,170,162,92,-1,170,149,162,-1,68,175,174,-1,175,68,67,-1,171,83,172,-1,86,83,171,-1,114,172,112,-1,114,174,172,-1,210,220,217,-1,220,210,212,-1,229,217,219,-1,216,217,229,-1,186,77,79,-1,77,186,229,-1,78,74,2,-1,74,78,77,-1,215,189,213,-1,189,215,187,-1,161,214,213,-1,214,161,117,-1,73,212,209,-1,212,73,221,-1,159,71,119,-1,159,70,71,-1,226,115,207,-1,67,115,226,-1,6,64,7,-1,6,65,64,-1,135,131,200,-1,131,135,50,-1,230,132,176,-1,157,132,230,-1,178,55,54,-1,178,56,55,-1,178,158,56,-1,40,129,43,-1,58,129,40,-1,198,200,134,-1,200,198,230,-1,137,154,139,-1,137,231,154,-1,181,195,194,-1,195,181,24,-1,232,26,192,-1,27,26,232,-1,152,150,233,-1,152,165,150,-1,190,180,21,-1,26,180,190,-1,191,194,192,-1,181,194,191,-1,100,233,150,-1,100,144,233,-1,189,148,9,-1,189,62,148,-1,234,94,224,-1,94,234,186,-1,118,11,8,-1,118,160,11,-1,227,40,39,-1,227,185,40,-1,184,4,3,-1,184,35,4,-1,145,168,5,-1,103,168,145,-1,155,183,225,-1,183,155,140,-1,235,188,187,-1,235,204,188,-1,151,2,1,-1,2,151,78,-1,236,183,184,-1,236,226,183,-1,23,143,14,-1,141,143,23,-1,142,146,237,-1,142,141,146,-1,201,196,202,-1,196,201,232,-1,180,228,164,-1,180,28,228,-1,17,152,18,-1,17,165,152,-1,147,190,29,-1,190,147,191,-1,231,196,193,-1,231,202,196,-1,36,195,37,-1,195,36,193,-1,38,42,138,-1,43,42,38,-1,45,201,197,-1,45,153,201,-1,51,199,182,-1,199,51,203,-1,169,131,95,-1,131,169,47,-1,203,135,177,-1,135,203,51,-1,198,136,156,-1,136,198,197,-1,54,203,178,-1,54,199,203,-1,179,176,132,-1,176,179,177,-1,188,60,62,-1,205,60,188,-1,208,125,124,-1,116,125,208,-1,122,116,66,-1,122,125,116,-1,72,221,73,-1,72,222,221,-1,120,211,214,-1,120,209,211,-1,210,215,211,-1,218,215,210,-1,75,111,76,-1,81,111,75,-1,234,218,216,-1,234,235,218,-1,219,75,74,-1,75,219,173,-1,80,220,113,-1,220,80,173,-1,222,174,114,-1,222,68,174,-1,87,236,88,-1,87,175,236,-1,19,162,163,-1,19,20,162,-1,205,169,60,-1,48,169,205,-1,225,208,227,-1,225,207,208,-1,88,184,3,-1,88,236,184,-1,166,124,105,-1,166,185,124,-1,128,108,107,-1,130,108,128,-1,164,223,93,-1,164,228,223,-1,109,0,110,-1,109,1,0,-1,175,226,236,-1,175,67,226,-1,112,81,80,-1,81,112,82,-1,212,113,220,-1,212,221,113,-1,219,77,229,-1,219,74,77,-1,186,216,229,-1,186,234,216,-1,117,160,118,-1,117,161,160,-1,218,187,215,-1,187,218,235,-1,121,214,117,-1,121,120,214,-1,209,119,73,-1,209,120,119,-1,66,222,72,-1,222,66,68,-1,128,148,61,-1,128,10,148,-1,124,127,105,-1,124,126,127,-1,53,199,54,-1,53,106,199,-1,156,230,198,-1,156,157,230,-1,182,96,49,-1,96,182,97,-1,200,176,135,-1,200,230,176,-1,136,231,137,-1,202,231,136,-1,138,139,38,-1,138,137,139,-1,154,193,36,-1,231,193,154,-1,201,27,232,-1,153,27,201,-1,233,31,152,-1,233,237,31,-1,133,28,44,-1,133,228,28,-1,29,237,146,-1,29,31,237,-1,196,192,194,-1,196,232,192,-1,237,144,142,-1,144,237,233,-1,147,141,23,-1,147,146,141,-1,224,235,234,-1,224,204,235,-1,39,225,227,-1,225,39,155,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c5disc_Coord',point=[(.36761,53.39464,-1.20697),(.36172,53.39094,-1.20919),(.35549,53.3918,-1.20656),(.21867,53.11637,-.77273),(.21548,53.10974,-.78514),(.27812,53.13169,-.81766),(-.38467,53.3772,-1.005),(-.3756,53.39185,-1.03517),(-.38196,53.39062,-1.13309),(-.29275,53.36783,-1.26494),(-.29441,53.36302,-1.26538),(-.35363,53.38834,-1.21808),(.36612,53.39071,-1.15259),(.33064,53.16346,-.87776),(.3128,53.19157,-.91986),(.34045,53.17208,-.88105),(.32465,53.19867,-.91701),(.38522,53.38868,-1.10599),(.33954,53.34176,-1.12005),(.3377,53.36867,-1.16526),(.28214,53.34041,-1.22714),(.21705,53.25802,-1.14806),(.2107,53.32167,-1.22544),(.29111,53.21212,-.95727),(.25736,53.15516,-.87728),(.26815,53.13768,-.83376),(.15178,53.20794,-1.06964),(.08072,53.19635,-1.07228),(.07405,53.2385,-1.1493),(.2935,53.26666,-1.06172),(.27922,53.29603,-1.13256),(.32668,53.30337,-1.04082),(.34703,53.17149,-.8433),(.35785,53.24323,-.89434),(.37086,53.24444,-.86221),(.11547,53.08989,-.75634),(.10699,53.10384,-.80274),(.21318,53.12383,-.80371),(-.21318,53.12383,-.80371),(-.21548,53.10974,-.78514),(-.27812,53.13169,-.81766),(-.3128,53.19157,-.91986),(-.25736,53.15516,-.87728),(-.26815,53.13768,-.83376),(0,53.22053,-1.14741),(-.08072,53.19635,-1.07228),(-.07405,53.2385,-1.1493),(-.14389,53.24003,-1.15015),(-.06749,53.27947,-1.22579),(-.33954,53.34176,-1.12005),(-.27922,53.29603,-1.13256),(-.32668,53.30337,-1.04082),(-.38299,53.29899,-.88368),(-.38336,53.32798,-.9204),(-.36218,53.29839,-.92219),(-.35785,53.24323,-.89434),(-.32465,53.19867,-.91701),(-.34045,53.17208,-.88105),(-.33827,53.15679,-.85154),(-.34781,53.17045,-.8437),(-.15234,53.30584,-1.24117),(-.23442,53.33602,-1.24066),(-.18852,53.34215,-1.27608),(-.37472,53.31915,-.89757),(-.34918,53.34687,-.94536),(-.37053,53.34225,-.93199),(-.08824,53.23308,-.80471),(0,53.20377,-.70399),(0,53.2291,-.81173),(-.33728,53.28186,-.88121),(-.26309,53.27414,-.92063),(-.19005,53.26943,-.89975),(-.09677,53.28678,-.88255),(-.10451,53.32063,-.9648),(.27363,53.37313,-1.15213),(.26688,53.34937,-1.05501),(.3756,53.39185,-1.03517),(.27646,53.36587,-1.22068),(.3387,53.38589,-1.21863),(.29275,53.36783,-1.26494),(.19044,53.32058,-.9737),(.25761,53.30357,-.96931),(.26309,53.27414,-.92063),(.25313,53.24198,-.88285),(.33728,53.28186,-.88121),(.29379,53.23894,-.82376),(.2423,53.20534,-.78129),(.15636,53.19768,-.73404),(.17106,53.18136,-.73829),(.24852,53.19445,-.77856),(.36727,53.35211,-.93697),(.38185,53.39195,-1.03429),(.23156,53.33429,-1.23882),(.15391,53.30799,-1.24337),(.18852,53.34216,-1.27607),(-.2107,53.32167,-1.22544),(-.37149,53.37457,-1.11021),(-.38717,53.3714,-1.02809),(.36307,53.32265,-.91144),(.37637,53.27698,-.88358),(.38658,53.33248,-.92013),(-.35024,53.27667,-.87065),(.30145,53.23214,-.81972),(.33639,53.16389,-.83793),(-.37242,53.24481,-.86127),(-.30161,53.23182,-.8198),(-.38674,53.35245,-.97287),(-.35011,53.38361,-1.20331),(-.3377,53.36867,-1.16526),(.35664,53.38458,-1.19199),(.38434,53.39754,-1.13647),(.34918,53.34687,-.94536),(.19005,53.26943,-.89975),(.10451,53.32063,-.9648),(.09677,53.28678,-.88255),(-.07381,53.20011,-.70671),(-.15636,53.19768,-.73404),(-.27363,53.37313,-1.15213),(-.36459,53.39042,-1.15258),(-.19044,53.32058,-.9737),(-.1992,53.34425,-1.06448),(-.26688,53.34937,-1.05501),(-.17517,53.23483,-.84533),(-.25313,53.24198,-.88285),(-.2469,53.19752,-.77711),(-.23773,53.20425,-.77729),(-.2423,53.20534,-.78129),(-.29379,53.23894,-.82376),(-.28909,53.35053,-1.24127),(-.33064,53.16346,-.87776),(-.28214,53.34041,-1.22714),(-.21705,53.25802,-1.14806),(-.29111,53.21212,-.95727),(0,53.27448,-1.22045),(-.15178,53.20794,-1.06964),(-.2935,53.26666,-1.06172),(-.08594,53.16508,-.94824),(-.09492,53.13594,-.87845),(-.18906,53.14679,-.87666),(-.10699,53.10384,-.80274),(0,53.07409,-.76564),(.30215,53.22169,-.95506),(.32718,53.25233,-.94051),(.31974,53.20493,-.9265),(.36218,53.29839,-.92219),(.33827,53.15679,-.85154),(.29862,53.24593,-1.00619),(.28831,53.23726,-1.00857),(-.28129,53.36033,-1.26694),(.29459,53.3631,-1.26523),(.39546,53.36417,-.97208),(.34574,53.38414,-1.22108),(.37127,53.35276,-1.02723),(0,53.19506,-1.06837),(0,53.09517,-.8043),(-.11547,53.08989,-.75634),(-.16789,53.16526,-.95161),(-.23666,53.17961,-.95253),(-.31974,53.20493,-.9265),(-.25761,53.30357,-.96931),(-.34639,53.38837,-1.21837),(-.27646,53.36587,-1.22068),(.29028,53.35226,-1.2437),(.34572,53.37944,-1.19574),(.14317,53.29326,-1.22826),(.39317,53.37843,-1.02842),(-.33639,53.16389,-.83793),(.35081,53.276,-.87037),(.2802,53.13928,-.80693),(-.14317,53.29326,-1.22826),(.2814,53.36032,-1.26694),(.23773,53.20425,-.77729),(.17517,53.23483,-.84533),(.1992,53.34425,-1.06448),(.08824,53.23308,-.80471),(.07381,53.20011,-.70671),(-.28831,53.23726,-1.00857),(-.29862,53.24593,-1.00619),(-.32718,53.25233,-.94051),(-.30215,53.22169,-.95506),(.14389,53.24003,-1.15015),(.23666,53.17961,-.95253),(-.37127,53.35276,-1.02723),(0,53.08494,-.74888),(.11599,53.09742,-.7418),(-.28021,53.13928,-.80692),(.18731,53.35035,-1.27367),(-.1124,53.34282,-1.26731),(-.11209,53.3319,-1.27033),(-.18731,53.35035,-1.27367),(.22179,53.22626,-1.07451),(.22968,53.19991,-1.0065),(.15983,53.1866,-1.01063),(.09492,53.13594,-.87845),(.16789,53.16526,-.95161),(.18906,53.14679,-.87666),(.08594,53.16508,-.94824),(-.08364,53.17879,-1.00675),(-.15983,53.1866,-1.01063),(-.36673,53.32557,-.97471),(-.22179,53.22626,-1.07451),(0,53.17494,-1.00723),(0,53.15747,-.94927),(-.3327,53.28351,-.98669),(0,53.33403,-1.28382),(-.07681,53.29327,-1.23817),(0,53.28577,-1.23248),(-.08243,53.18356,-.70848),(-.17044,53.18231,-.73782),(-.11465,53.34249,-1.06903),(0,53.35724,-1.15751),(-.11808,53.35318,-1.15724),(0,53.35242,-1.07689),(-.20144,53.3582,-1.21928),(-.20492,53.35887,-1.15261),(-.11496,53.35551,-1.21971),(.11496,53.35551,-1.21971),(.11808,53.35318,-1.15724),(0,53.35182,-1.23148),(.20492,53.35887,-1.15261),(.11465,53.34249,-1.06903),(0,53.33002,-.97959),(0,53.28446,-.87879),(.07818,53.2953,-1.23999),(.11209,53.3319,-1.27033),(-.11599,53.09742,-.7418),(0,53.18185,-.70818),(-.21868,53.11637,-.77273),(.06749,53.27947,-1.22579),(.20144,53.3582,-1.21928),(-.22968,53.19991,-1.0065),(0,53.12977,-.87191),(.08364,53.17879,-1.00675),(.36673,53.32557,-.97471),(.1124,53.34282,-1.26731),(0,53.34358,-1.28075),(.08385,53.17961,-.70998),(.3327,53.28351,-.98669)]))),
        Shape(DEF='c6',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='c6_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,11,30,31,-1,11,32,30,-1,33,34,35,-1,36,37,38,-1,37,36,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,57,59,-1,14,60,61,-1,62,63,64,-1,65,66,67,-1,68,66,65,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,83,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,36,-1,103,104,61,-1,105,106,107,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,108,115,109,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,96,-1,127,128,129,-1,130,14,13,-1,106,131,132,-1,133,134,135,-1,54,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,150,148,27,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,109,169,110,-1,170,142,171,-1,143,142,170,-1,172,173,9,-1,174,175,63,-1,176,177,178,-1,179,180,181,-1,182,183,184,-1,15,185,186,-1,187,188,189,-1,190,191,192,-1,193,183,182,-1,194,195,196,-1,197,191,190,-1,198,199,200,-1,46,201,62,-1,180,202,203,-1,180,204,205,-1,206,207,208,-1,209,210,160,-1,26,25,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,158,-1,226,227,228,-1,229,102,55,-1,39,230,231,-1,232,233,52,-1,234,235,236,-1,237,238,239,-1,240,241,242,-1,243,244,245,-1,246,247,248,-1,249,250,251,-1,252,253,254,-1,255,256,129,-1,257,128,12,-1,258,259,260,-1,261,262,263,-1,92,264,265,-1,81,83,86,-1,266,267,268,-1,198,200,11,-1,269,270,271,-1,272,270,269,-1,273,274,275,-1,276,277,38,-1,278,279,280,-1,281,282,283,-1,284,122,285,-1,286,287,288,-1,122,78,285,-1,289,124,290,-1,291,292,293,-1,294,127,295,-1,296,130,297,-1,298,299,300,-1,301,302,284,-1,303,304,305,-1,306,307,308,-1,309,310,311,-1,312,313,314,-1,315,217,216,-1,218,316,26,-1,317,318,216,-1,319,220,320,-1,320,321,322,-1,223,323,324,-1,216,8,317,-1,325,326,152,-1,327,236,328,-1,329,330,331,-1,332,333,334,-1,335,336,332,-1,337,338,339,-1,338,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,42,355,-1,356,357,358,-1,257,359,360,-1,58,361,362,-1,363,364,365,-1,366,361,364,-1,367,368,369,-1,370,371,372,-1,227,226,373,-1,374,375,68,-1,95,376,377,-1,378,379,76,-1,197,380,381,-1,382,383,94,-1,384,385,386,-1,387,388,389,-1,390,391,387,-1,345,392,393,-1,45,394,395,-1,243,396,397,-1,398,384,246,-1,399,400,401,-1,402,403,404,-1,405,406,64,-1,19,240,407,-1,408,409,410,-1,47,411,48,-1,234,20,407,-1,412,413,235,-1,414,415,416,-1,105,417,418,-1,419,240,245,-1,420,421,422,-1,120,423,144,-1,424,425,426,-1,427,7,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,454,456,455,-1,457,458,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,460,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,484,489,490,-1,491,492,493,-1,494,492,491,-1,491,495,496,-1,497,498,499,-1,500,501,502,-1,503,504,505,-1,506,507,508,-1,509,510,511,-1,512,503,513,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,458,523,524,-1,525,526,527,-1,528,529,530,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,533,544,-1,545,546,1,-1,547,548,549,-1,550,551,552,-1,553,554,555,-1,556,557,558,-1,559,560,561,-1,562,563,564,-1,565,566,567,-1,566,568,569,-1,570,566,571,-1,572,6,559,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,582,584,588,-1,589,590,591,-1,592,593,594,-1,595,596,588,-1,597,598,599,-1,600,601,602,-1,603,604,605,-1,606,607,3,-1,608,609,610,-1,611,612,613,-1,614,615,616,-1,617,618,619,-1,620,621,622,-1,602,601,619,-1,623,624,625,-1,626,627,280,-1,628,629,630,-1,631,632,275,-1,633,513,503,-1,634,635,636,-1,637,638,639,-1,634,640,641,-1,642,643,644,-1,645,646,647,-1,648,649,650,-1,651,652,653,-1,518,654,655,-1,656,657,519,-1,658,659,660,-1,661,662,663,-1,664,461,665,-1,666,667,668,-1,669,450,670,-1,671,430,429,-1,672,673,432,-1,624,628,674,-1,675,676,677,-1,678,679,680,-1,516,498,500,-1,681,682,683,-1,684,685,686,-1,562,687,685,-1,571,688,575,-1,565,689,690,-1,691,692,559,-1,557,693,694,-1,573,695,696,-1,568,697,698,-1,699,436,700,-1,446,701,702,-1,703,701,445,-1,704,705,706,-1,707,435,708,-1,635,709,710,-1,711,706,712,-1,713,714,715,-1,716,717,718,-1,640,719,720,-1,448,467,721,-1,713,722,723,-1,724,722,702,-1,725,726,727,-1,728,729,730,-1,662,441,725,-1,731,732,733,-1,734,704,731,-1,735,443,442,-1,736,737,738,-1,595,739,740,-1,741,742,743,-1,744,562,685,-1,745,746,747,-1,557,748,749,-1,750,751,752,-1,753,754,752,-1,755,593,756,-1,732,757,758,-1,759,760,761,-1,762,763,675,-1,469,471,764,-1,765,766,767,-1,768,608,610,-1,769,770,771,-1,553,772,773,-1,553,774,772,-1,539,775,536,-1,776,777,778,-1,779,780,781,-1,782,783,679,-1,784,785,786,-1,645,487,787,-1,788,789,790,-1,643,791,792,-1,426,793,644,-1,495,794,496,-1,795,791,796,-1,539,536,535,-1,502,797,798,-1,799,800,801,-1,785,802,786,-1,803,728,730,-1,804,672,805,-1,806,5,807,-1,808,809,810,-1,811,810,678,-1,812,813,676,-1,669,805,814,-1,815,816,504,-1,817,818,440,-1,819,664,820,-1,821,822,527,-1,782,628,630,-1,630,783,782,-1,823,824,825,-1,28,826,751,-1,573,579,827,-1,828,2,553,-1,804,438,829,-1,448,830,449,-1,704,734,831,-1,584,590,595,-1,497,501,500,-1,832,833,834,-1,832,777,776,-1,835,836,837,-1,838,826,28,-1,839,840,841,-1,808,674,809,-1,453,842,454,-1,482,843,819,-1,844,456,454,-1,845,846,847,-1,543,818,848,-1,815,504,512,-1,849,850,801,-1,851,852,786,-1,853,763,637,-1,854,714,648,-1,855,624,674,-1,856,587,857,-1,857,587,858,-1,669,438,804,-1,859,860,786,-1,861,862,863,-1,864,797,501,-1,849,800,865,-1,866,867,868,-1,869,870,871,-1,872,796,873,-1,495,874,861,-1,494,875,876,-1,642,796,791,-1,873,796,877,-1,644,643,426,-1,463,646,645,-1,784,860,770,-1,786,802,878,-1,879,789,792,-1,880,596,740,-1,881,882,835,-1,551,550,539,-1,883,884,885,-1,536,531,886,-1,549,2,1,-1,587,586,858,-1,769,615,887,-1,653,888,889,-1,608,768,4,-1,610,656,890,-1,891,892,893,-1,704,757,731,-1,894,895,896,-1,647,897,898,-1,899,900,485,-1,901,636,635,-1,902,455,456,-1,555,554,903,-1,752,754,556,-1,750,691,904,-1,556,754,748,-1,905,567,906,-1,907,742,698,-1,737,908,738,-1,607,909,910,-1,613,911,912,-1,613,612,911,-1,735,442,913,-1,894,914,915,-1,661,915,914,-1,700,704,845,-1,733,916,917,-1,436,699,803,-1,661,464,788,-1,790,789,913,-1,918,919,920,-1,921,662,725,-1,708,730,919,-1,850,500,799,-1,445,444,922,-1,854,715,714,-1,717,716,720,-1,641,923,711,-1,924,919,729,-1,925,921,874,-1,636,926,719,-1,490,927,928,-1,929,930,854,-1,854,650,929,-1,441,707,708,-1,730,435,437,-1,705,449,712,-1,931,703,896,-1,847,846,720,-1,435,707,848,-1,932,933,697,-1,690,689,428,-1,575,688,934,-1,935,742,936,-1,937,689,687,-1,685,684,744,-1,938,514,939,-1,816,476,475,-1,630,629,940,-1,941,432,942,-1,943,944,945,-1,429,946,947,-1,669,668,450,-1,451,842,453,-1,948,949,950,-1,475,764,471,-1,951,952,470,-1,953,954,955,-1,791,956,879,-1,907,933,957,-1,519,518,890,-1,869,958,870,-1,649,520,650,-1,900,899,487,-1,853,959,866,-1,960,488,901,-1,961,828,745,-1,811,503,808,-1,868,962,963,-1,964,631,274,-1,965,966,632,-1,967,823,675,-1,968,969,970,-1,971,625,627,-1,972,973,555,-1,974,956,785,-1,975,976,977,-1,908,737,978,-1,979,883,980,-1,981,982,614,-1,983,616,615,-1,611,610,609,-1,606,856,857,-1,593,903,756,-1,586,588,596,-1,984,985,986,-1,586,585,987,-1,806,856,5,-1,988,827,579,-1,583,989,591,-1,692,558,990,-1,690,7,6,-1,991,568,570,-1,906,686,905,-1,742,935,992,-1,686,906,993,-1,687,686,685,-1,560,6,8,-1,749,994,995,-1,996,673,0,-1,997,548,547,-1,829,545,0,-1,998,546,545,-1,541,533,532,-1,534,999,1000,-1,1001,1002,1003,-1,1001,1004,1002,-1,527,822,524,-1,681,472,521,-1,808,505,1005,-1,1006,1007,511,-1,955,509,1008,-1,1009,1010,509,-1,498,497,500,-1,876,875,798,-1,1011,859,852,-1,1012,495,491,-1,484,490,926,-1,487,486,1013,-1,1014,481,480,-1,1015,1016,478,-1,1017,473,472,-1,683,1018,927,-1,952,479,478,-1,913,1000,999,-1,459,1019,821,-1,1020,454,842,-1,667,1021,1022,-1,479,917,665,-1,470,705,831,-1,914,894,1023,-1,915,803,895,-1,804,805,669,-1,758,438,732,-1,1024,848,818,-1,432,805,672,-1,1025,433,1026,-1,961,947,1027,-1,814,1028,666,-1,773,756,903,-1,84,421,93,-1,7,427,1029,-1,1030,1031,239,-1,1032,1033,235,-1,46,1034,1035,-1,408,410,18,-1,1036,1037,143,-1,206,64,406,-1,1038,201,110,-1,1039,1040,205,-1,15,1041,399,-1,1042,242,1037,-1,394,243,1043,-1,1044,1045,248,-1,385,1046,386,-1,1047,91,90,-1,1048,1049,186,-1,133,1050,399,-1,1051,1052,358,-1,1053,1054,1055,-1,387,385,384,-1,385,1056,372,-1,1057,1058,1046,-1,1059,352,1060,-1,1061,381,1062,-1,383,1063,94,-1,1064,381,1065,-1,378,1066,1067,-1,379,1067,1068,-1,1069,76,379,-1,373,1070,227,-1,226,1071,67,-1,271,1072,50,-1,1056,366,1073,-1,371,370,369,-1,1074,367,1075,-1,1076,369,1077,-1,1078,1079,257,-1,357,356,1080,-1,1044,42,354,-1,354,350,1044,-1,353,348,354,-1,111,1081,108,-1,1082,117,346,-1,331,330,343,-1,111,341,340,-1,338,1083,1084,-1,339,1084,1085,-1,1086,331,334,-1,329,112,116,-1,22,1087,1088,-1,1089,1090,213,-1,1091,561,560,-1,317,8,7,-1,225,324,323,-1,1092,225,224,-1,162,1093,1094,-1,1095,324,225,-1,1029,317,7,-1,217,1096,1090,-1,1097,1098,1099,-1,1100,988,1101,-1,1102,313,312,-1,1103,1104,1105,-1,1106,1107,313,-1,299,130,296,-1,1108,295,291,-1,1109,1110,289,-1,1111,290,123,-1,1112,1113,1114,-1,1115,166,1116,-1,347,1117,80,-1,98,1118,1119,-1,283,1120,278,-1,283,282,1120,-1,1121,1122,1123,-1,274,273,1124,-1,1125,1123,137,-1,271,57,58,-1,415,1126,21,-1,1127,268,267,-1,264,94,1128,-1,356,263,1080,-1,1129,957,933,-1,1118,87,392,-1,1074,1130,1131,-1,1132,400,399,-1,1055,391,1050,-1,1133,1134,1135,-1,1136,1042,1137,-1,1043,245,240,-1,239,1138,416,-1,1139,1140,1141,-1,234,1142,1032,-1,37,1143,1144,-1,51,1145,1055,-1,356,1146,1147,-1,157,1148,224,-1,222,1149,323,-1,1094,936,162,-1,1150,218,1151,-1,1029,221,223,-1,933,1152,1153,-1,48,110,201,-1,1154,189,188,-1,1155,202,192,-1,16,401,194,-1,62,1034,46,-1,1038,176,1156,-1,1157,184,183,-1,1065,380,190,-1,197,200,191,-1,172,1158,77,-1,1159,1160,174,-1,1161,1162,194,-1,191,189,192,-1,262,1163,193,-1,1164,1039,204,-1,1165,226,1166,-1,174,62,1156,-1,172,177,176,-1,1159,174,1167,-1,393,1168,250,-1,89,91,251,-1,64,206,1035,-1,1036,1169,1132,-1,1170,1171,408,-1,251,404,405,-1,1172,1039,1164,-1,115,1082,109,-1,293,1173,1174,-1,293,1175,1176,-1,1177,1178,1179,-1,166,1180,1116,-1,1129,209,162,-1,324,1095,321,-1,1091,215,150,-1,1089,149,148,-1,423,1088,1087,-1,1181,1104,1182,-1,143,241,410,-1,32,11,200,-1,264,1128,1061,-1,265,1183,1184,-1,406,403,1155,-1,1185,1186,1187,-1,12,128,13,-1,97,126,292,-1,125,96,79,-1,1188,1189,313,-1,1084,327,23,-1,118,117,115,-1,1113,113,1190,-1,112,114,1191,-1,1192,1193,1194,-1,1106,302,301,-1,87,1168,393,-1,100,1195,1196,-1,1197,79,96,-1,90,93,92,-1,83,84,1198,-1,74,1199,1200,-1,74,69,81,-1,1068,252,375,-1,76,1201,1202,-1,74,73,1199,-1,1200,1203,383,-1,117,1082,115,-1,1204,71,70,-1,1205,1127,1206,-1,1207,1208,1209,-1,66,1210,67,-1,1202,1201,1211,-1,257,360,1078,-1,1189,1188,299,-1,60,1188,1102,-1,60,130,299,-1,1212,365,58,-1,262,261,1163,-1,1213,1214,1142,-1,267,266,1215,-1,1216,1217,1166,-1,50,49,139,-1,1218,175,10,-1,48,411,111,-1,1219,45,395,-1,1044,40,42,-1,1046,385,372,-1,1209,198,1165,-1,841,417,1220,-1,28,1221,1222,-1,837,836,1194,-1,1223,1224,1225,-1,1226,1192,107,-1,1226,1227,1098,-1,373,226,67,-1,314,1107,163,-1,171,401,400,-1,297,13,128,-1,393,169,109,-1,1228,1229,1215,-1,1,0,545,-1,853,639,638,-1,655,4,768,-1,886,735,999,-1,638,959,853,-1,1215,266,1228,-1,393,109,1082,-1,127,297,128,-1,171,400,170,-1,314,163,311,-1,22,1088,120,-1,1098,1230,1226,-1,1192,1231,107,-1,1225,1232,1223,-1,1194,1233,837,-1,1222,1234,28,-1,1220,1235,841,-1,58,59,1212,-1,1137,395,394,-1,395,1236,1219,-1,1154,188,207,-1,110,48,111,-1,411,341,111,-1,1218,63,175,-1,139,1237,50,-1,1216,1207,1217,-1,1195,100,377,-1,1215,1238,267,-1,1213,1239,1214,-1,1212,281,365,-1,60,299,1188,-1,60,1102,61,-1,1189,299,298,-1,240,19,410,-1,95,100,99,-1,1202,1211,1240,-1,1210,373,67,-1,1209,1217,1207,-1,1206,373,1205,-1,70,422,1204,-1,1200,383,382,-1,1118,72,88,-1,73,1241,1199,-1,1202,77,76,-1,375,374,1068,-1,81,88,74,-1,74,1200,69,-1,86,83,1198,-1,90,92,1242,-1,96,99,1197,-1,1196,1243,100,-1,393,392,87,-1,71,1244,69,-1,301,164,1106,-1,1192,1194,1232,-1,1191,116,112,-1,1190,1114,1113,-1,118,115,108,-1,121,120,144,-1,1110,125,79,-1,259,97,292,-1,295,129,256,-1,1185,1187,1245,-1,171,142,141,-1,1155,1154,406,-1,1184,402,265,-1,1061,1183,264,-1,200,197,32,-1,1246,1236,1247,-1,1087,1248,423,-1,148,150,1089,-1,150,27,1091,-1,212,153,149,-1,149,1089,212,-1,1249,1148,157,-1,160,1250,161,-1,1179,294,1177,-1,1176,1173,293,-1,289,1251,1109,-1,406,405,403,-1,405,404,403,-1,1036,1132,398,-1,1035,1034,64,-1,251,250,89,-1,250,1038,393,-1,1159,1167,1240,-1,249,172,176,-1,1156,1167,174,-1,1166,1217,1165,-1,204,203,1164,-1,193,1252,262,-1,191,199,189,-1,1162,195,194,-1,1160,175,174,-1,77,177,172,-1,200,199,191,-1,190,1253,1065,-1,1157,1254,184,-1,1156,201,1038,-1,194,196,16,-1,1155,203,202,-1,201,46,48,-1,1153,1255,933,-1,1150,219,218,-1,222,323,223,-1,224,158,157,-1,1256,1094,1093,-1,1146,1257,1147,-1,51,1055,1054,-1,1144,276,37,-1,138,1237,139,-1,234,1213,1142,-1,1139,238,1140,-1,239,416,1258,-1,240,242,1043,-1,1136,1137,394,-1,1172,1133,1135,-1,1050,135,1055,-1,399,390,1132,-1,1074,1259,1130,-1,1118,88,87,-1,210,1250,160,-1,257,129,128,-1,257,1079,129,-1,71,1204,1244,-1,356,1147,263,-1,264,92,94,-1,267,1238,1127,-1,30,32,1063,-1,415,414,1126,-1,58,1072,271,-1,1125,137,136,-1,274,1124,1260,-1,1123,273,1121,-1,1261,232,33,-1,102,56,55,-1,1248,1087,1182,-1,98,1119,1197,-1,1262,347,80,-1,1116,1263,1115,-1,1102,103,61,-1,1102,1264,103,-1,1112,1265,1113,-1,290,124,123,-1,1109,125,1110,-1,1108,291,1174,-1,296,300,299,-1,306,144,423,-1,1106,313,1189,-1,1103,309,1104,-1,1102,312,1264,-1,60,14,130,-1,1100,1101,24,-1,1266,310,1099,-1,217,1267,1096,-1,1029,318,317,-1,321,1250,322,-1,324,320,223,-1,1268,1256,1093,-1,1092,1095,225,-1,323,158,225,-1,222,1269,1149,-1,216,1091,560,-1,1089,150,1090,-1,213,212,1089,-1,1181,214,213,-1,22,155,1087,-1,329,116,330,-1,1086,334,333,-1,339,1085,1270,-1,338,1084,339,-1,111,340,1081,-1,331,343,342,-1,1271,1191,114,-1,117,1272,346,-1,1081,344,108,-1,353,354,351,-1,351,355,1060,-1,1246,1219,1236,-1,357,1080,1187,-1,1078,254,1079,-1,1076,1273,369,-1,1074,1075,1274,-1,371,369,368,-1,1056,1073,370,-1,50,1237,271,-1,1071,65,67,-1,373,1206,1070,-1,379,374,1069,-1,1068,374,379,-1,379,378,1067,-1,381,380,1065,-1,1062,1183,1061,-1,1059,1060,1275,-1,1057,1276,1058,-1,385,389,1056,-1,1055,135,1053,-1,358,357,1051,-1,1277,1278,1279,-1,399,1041,133,-1,1242,1047,90,-1,355,41,1280,-1,248,40,1044,-1,394,1281,243,-1,1042,1136,242,-1,399,16,15,-1,205,204,1039,-1,110,169,1038,-1,1036,143,1169,-1,1170,408,18,-1,1035,47,46,-1,1032,235,234,-1,1030,239,1258,-1,427,221,1029,-1,85,83,82,-1,93,90,84,-1,666,669,814,-1,961,1282,947,-1,1025,434,433,-1,432,941,805,-1,758,439,438,-1,670,450,732,-1,450,1283,732,-1,465,914,1023,-1,470,449,705,-1,665,461,479,-1,451,450,668,-1,1022,1284,667,-1,842,1284,1020,-1,459,821,664,-1,913,879,1000,-1,1285,952,478,-1,478,1286,1015,-1,479,461,460,-1,1014,1287,481,-1,1013,787,487,-1,484,926,485,-1,1012,1288,495,-1,786,852,859,-1,852,1289,1011,-1,875,496,798,-1,497,867,864,-1,1290,759,761,-1,1009,508,1010,-1,955,510,509,-1,511,510,1006,-1,1005,1291,808,-1,518,1292,654,-1,472,522,521,-1,524,525,527,-1,1000,975,534,-1,532,542,541,-1,998,544,546,-1,997,547,546,-1,996,0,1293,-1,555,973,1294,-1,995,1295,749,-1,560,559,6,-1,937,564,563,-1,687,905,686,-1,993,684,686,-1,1296,992,1297,-1,905,689,565,-1,567,566,569,-1,568,566,570,-1,6,572,690,-1,990,1298,692,-1,1299,989,834,-1,988,579,1101,-1,586,987,582,-1,986,589,984,-1,596,858,586,-1,606,857,603,-1,609,612,611,-1,615,769,983,-1,982,1300,614,-1,980,1301,979,-1,908,978,1302,-1,975,977,621,-1,785,784,974,-1,971,627,626,-1,679,678,810,-1,968,1303,969,-1,965,632,631,-1,274,1260,964,-1,963,866,868,-1,503,505,808,-1,961,1027,828,-1,853,866,963,-1,487,645,900,-1,649,521,520,-1,518,768,890,-1,568,741,569,-1,791,879,792,-1,953,955,1304,-1,951,470,831,-1,1285,475,471,-1,1305,949,948,-1,453,452,451,-1,669,666,668,-1,947,1282,429,-1,943,945,1306,-1,941,942,1307,-1,760,1308,512,-1,630,940,1309,-1,475,1016,816,-1,938,515,514,-1,1297,992,935,-1,684,1310,744,-1,687,564,937,-1,934,577,575,-1,932,1152,933,-1,707,443,848,-1,896,716,931,-1,705,712,706,-1,441,708,725,-1,928,718,490,-1,926,717,719,-1,921,727,874,-1,924,920,919,-1,923,706,711,-1,720,719,717,-1,854,1311,715,-1,703,445,922,-1,850,799,801,-1,918,708,919,-1,921,725,727,-1,920,862,918,-1,790,913,441,-1,661,788,790,-1,437,436,803,-1,733,917,951,-1,440,439,817,-1,700,757,704,-1,915,895,894,-1,1305,922,444,-1,735,913,999,-1,616,983,1312,-1,613,912,1313,-1,607,1314,909,-1,741,743,569,-1,1315,744,1310,-1,557,556,748,-1,750,904,751,-1,750,752,556,-1,555,903,972,-1,1316,973,986,-1,732,438,670,-1,901,926,636,-1,900,898,485,-1,647,1023,897,-1,895,847,896,-1,893,1317,891,-1,608,4,3,-1,889,771,653,-1,887,770,769,-1,772,756,773,-1,536,775,531,-1,980,883,885,-1,551,539,538,-1,835,1318,881,-1,880,600,596,-1,869,877,958,-1,879,913,789,-1,786,878,851,-1,784,770,887,-1,645,424,463,-1,643,1319,426,-1,877,1320,873,-1,642,877,796,-1,494,876,658,-1,495,861,794,-1,872,873,1321,-1,956,791,795,-1,536,886,999,-1,871,1322,869,-1,867,497,868,-1,849,801,800,-1,501,497,864,-1,794,861,863,-1,518,517,1292,-1,858,604,857,-1,856,806,587,-1,674,808,855,-1,639,853,637,-1,849,1290,850,-1,512,1308,815,-1,848,443,543,-1,543,998,818,-1,844,454,1020,-1,819,820,482,-1,458,822,1019,-1,462,1010,460,-1,800,799,634,-1,839,841,1235,-1,838,28,1234,-1,835,837,581,-1,881,832,776,-1,832,834,1323,-1,553,773,554,-1,595,588,584,-1,831,705,704,-1,829,672,804,-1,2,1293,0,-1,500,1324,799,-1,596,600,858,-1,573,696,579,-1,751,29,28,-1,489,1325,927,-1,460,1286,478,-1,630,1326,783,-1,821,1019,822,-1,664,821,820,-1,435,848,1024,-1,815,476,816,-1,676,763,812,-1,633,811,678,-1,810,811,808,-1,806,807,781,-1,730,437,803,-1,502,501,797,-1,502,798,863,-1,877,869,1322,-1,872,795,796,-1,642,644,1327,-1,426,425,793,-1,643,642,791,-1,788,464,463,-1,787,424,645,-1,784,786,860,-1,872,1321,802,-1,779,781,807,-1,777,765,778,-1,531,735,886,-1,539,550,775,-1,545,829,440,-1,771,889,769,-1,890,768,610,-1,4,655,5,-1,764,1328,469,-1,762,1329,763,-1,759,1308,760,-1,732,731,757,-1,647,898,900,-1,756,1330,755,-1,670,438,669,-1,554,773,903,-1,559,904,691,-1,693,557,749,-1,747,1295,745,-1,992,743,742,-1,741,698,742,-1,684,993,1310,-1,736,605,737,-1,983,1313,912,-1,441,913,442,-1,731,733,734,-1,788,1319,789,-1,662,790,441,-1,729,919,730,-1,931,724,701,-1,702,701,724,-1,713,1331,722,-1,448,447,467,-1,640,720,846,-1,718,931,716,-1,715,1331,713,-1,711,712,930,-1,1332,635,710,-1,435,730,708,-1,704,706,923,-1,703,931,701,-1,446,445,701,-1,845,699,700,-1,698,741,568,-1,557,694,1333,-1,1334,935,936,-1,690,571,565,-1,571,575,570,-1,428,689,937,-1,562,564,687,-1,683,1335,681,-1,500,850,516,-1,678,680,1336,-1,1326,1337,1338,-1,677,967,675,-1,624,623,628,-1,673,433,432,-1,671,429,943,-1,805,941,1339,-1,666,1340,667,-1,668,842,451,-1,665,459,664,-1,950,949,1341,-1,661,790,662,-1,956,795,785,-1,494,658,660,-1,656,519,890,-1,518,655,768,-1,1011,651,653,-1,648,650,854,-1,647,900,645,-1,800,634,641,-1,637,1342,638,-1,634,924,635,-1,503,811,633,-1,763,676,675,-1,631,275,274,-1,628,623,629,-1,626,280,279,-1,623,625,971,-1,603,1343,606,-1,602,619,618,-1,622,1344,620,-1,617,619,977,-1,616,981,614,-1,613,888,611,-1,608,910,609,-1,3,856,606,-1,603,857,604,-1,600,880,601,-1,595,740,596,-1,593,1345,594,-1,591,984,589,-1,588,586,582,-1,1346,559,692,-1,575,577,573,-1,559,1346,572,-1,566,565,571,-1,567,905,565,-1,689,905,687,-1,904,559,561,-1,556,558,750,-1,557,1333,558,-1,1316,1333,694,-1,555,746,553,-1,552,1347,550,-1,549,1,547,-1,546,547,1,-1,544,998,543,-1,542,1347,540,-1,536,999,534,-1,533,543,531,-1,528,530,1348,-1,458,524,822,-1,902,456,844,-1,522,891,520,-1,519,659,517,-1,761,514,516,-1,512,513,760,-1,1009,509,511,-1,508,1009,506,-1,503,512,504,-1,502,1324,500,-1,499,868,497,-1,875,491,496,-1,494,491,875,-1,1012,491,493,-1,489,927,490,-1,483,485,898,-1,480,482,526,-1,475,477,764,-1,522,472,474,-1,1349,1017,1350,-1,469,447,470,-1,465,646,463,-1,527,820,821,-1,458,1019,459,-1,452,1283,450,-1,447,449,470,-1,444,446,1351,-1,441,443,707,-1,699,895,803,-1,440,829,438,-1,435,1024,436,-1,434,942,432,-1,431,946,429,-1,7,690,428,-1,793,1327,644,-1,463,424,426,-1,420,93,421,-1,419,245,1352,-1,105,1220,417,-1,416,1138,414,-1,235,1033,412,-1,407,1213,234,-1,409,143,410,-1,404,1047,402,-1,401,16,399,-1,384,386,246,-1,1136,1043,242,-1,243,1281,396,-1,45,1281,394,-1,393,1082,345,-1,387,384,390,-1,1353,1065,1254,-1,1279,358,1052,-1,387,1145,388,-1,382,94,420,-1,381,1061,197,-1,76,1354,378,-1,100,95,377,-1,376,1355,377,-1,68,1069,374,-1,373,1210,1205,-1,1216,1356,140,-1,372,1056,370,-1,367,369,1273,-1,366,364,1073,-1,1357,363,365,-1,58,362,1072,-1,358,1146,356,-1,355,351,354,-1,351,1060,352,-1,350,354,348,-1,345,1082,346,-1,342,344,1081,-1,341,1083,338,-1,327,1084,1083,-1,339,1270,337,-1,335,332,1358,-1,332,334,1358,-1,331,1086,329,-1,328,1359,327,-1,1087,1360,1182,-1,325,152,156,-1,216,560,8,-1,159,1149,1269,-1,320,324,321,-1,322,1250,210,-1,320,322,319,-1,318,315,216,-1,218,26,1151,-1,1361,1362,1151,-1,24,1233,1363,-1,312,314,1266,-1,1102,1188,313,-1,313,1107,314,-1,309,1103,310,-1,308,1364,306,-1,301,284,1365,-1,300,167,298,-1,296,297,1179,-1,294,295,1108,-1,1174,291,293,-1,289,1110,124,-1,78,80,285,-1,286,1117,287,-1,285,1365,284,-1,300,296,1366,-1,281,277,282,-1,278,1120,279,-1,38,37,276,-1,275,1121,273,-1,54,232,52,-1,272,1367,270,-1,270,57,271,-1,11,1160,198,-1,268,1228,266,-1,1242,92,265,-1,263,1147,261,-1,258,376,259,-1,12,359,257,-1,129,1079,255,-1,252,1068,253,-1,1118,98,72,-1,251,173,249,-1,1134,1368,1135,-1,246,386,247,-1,1043,1136,394,-1,245,1043,243,-1,407,1239,1213,-1,239,1031,237,-1,236,20,234,-1,232,1261,233,-1,55,1369,229,-1,226,228,1166,-1,220,319,218,-1,1370,936,1094,-1,214,151,212,-1,209,1255,210,-1,208,1035,206,-1,205,181,180,-1,203,204,180,-1,201,1156,62,-1,198,187,199,-1,380,197,190,-1,30,9,31,-1,195,1371,196,-1,193,1163,183,-1,192,202,190,-1,189,199,187,-1,1041,15,186,-1,182,184,1372,-1,179,181,1372,-1,202,180,179,-1,63,62,174,-1,172,249,173,-1,89,1168,1198,-1,170,1169,143,-1,1038,169,393,-1,1109,1176,1175,-1,168,1180,166,-1,224,1148,1092,-1,209,160,162,-1,1093,162,161,-1,155,1126,156,-1,153,212,151,-1,216,215,1091,-1,1088,423,120,-1,241,240,410,-1,144,306,145,-1,265,264,1183,-1,143,409,141,-1,140,1356,138,-1,137,232,54,-1,133,135,1050,-1,297,130,13,-1,129,295,127,-1,126,97,96,-1,124,78,122,-1,1083,1170,18,-1,119,22,120,-1,116,1191,117,-1,113,1113,114,-1,107,1231,105,-1,103,1373,104,-1,73,1243,1241,-1,98,1197,99,-1,95,99,96,-1,93,420,94,-1,89,250,1168,-1,88,81,86,-1,85,421,84,-1,76,1069,1201,-1,79,1262,80,-1,75,1354,76,-1,72,74,88,-1,1191,1272,117,-1,65,1211,68,-1,1165,1217,1209,-1,98,100,1243,-1,1034,62,64,-1,19,407,20,-1,14,61,104,-1,57,56,59,-1,57,270,55,-1,53,52,1374,-1,240,419,407,-1,51,1054,49,-1,1171,1170,411,-1,1219,43,45,-1,41,355,42,-1,101,36,38,-1,385,387,389,-1,1064,1065,1375,-1,27,1221,28,-1,26,1100,24,-1,1106,1189,302,-1,226,1165,1071,-1,23,327,1359,-1,18,410,19,-1,1085,1084,23,-1,11,31,9,-1,18,327,1083,-1,960,1332,710,-1,5,856,3,-1,1363,25,24,-1,1363,1376,25,-1,1231,1232,1225,-1,1192,1232,1231,-1,836,1232,1194,-1,1232,836,1223,-1,1235,1225,1224,-1,1220,1225,1235,-1,33,137,1377,-1,33,232,137,-1,1275,1130,1059,-1,1275,1276,1130,-1,1378,1379,1380,-1,1378,1381,1379,-1,139,1382,140,-1,1382,139,1245,-1,1383,1277,1384,-1,1385,1277,1383,-1,1214,1228,268,-1,1228,1214,1239,-1,278,1386,1387,-1,278,280,1386,-1,1388,1367,1389,-1,1388,1369,1367,-1,1390,1125,1391,-1,1390,1124,1125,-1,14,359,12,-1,1392,359,14,-1,1033,360,412,-1,360,1033,1078,-1,1167,1202,1240,-1,178,1202,1167,-1,1071,198,1160,-1,1165,198,1071,-1,1393,1199,1241,-1,1393,1394,1199,-1,1395,1394,75,-1,1395,1203,1394,-1,1226,1373,103,-1,1226,107,1373,-1,298,302,1189,-1,298,1115,302,-1,414,1139,325,-1,414,1138,1139,-1,1185,1396,1186,-1,1396,1185,1053,-1,229,1397,230,-1,1398,1397,229,-1,1399,1400,1401,-1,1399,1402,1400,-1,1184,403,402,-1,403,1184,1155,-1,197,1128,32,-1,1128,197,1061,-1,1181,1360,214,-1,1181,1182,1360,-1,1116,1403,1111,-1,1180,1403,1116,-1,1177,1404,1178,-1,1404,1177,1405,-1,1173,1406,1407,-1,1173,1176,1406,-1,1174,1407,1108,-1,1173,1407,1174,-1,1408,288,287,-1,288,1408,1409,-1,1049,1040,1135,-1,1049,1048,1040,-1,1169,400,1132,-1,1169,170,400,-1,249,1038,250,-1,249,176,1038,-1,405,173,251,-1,405,1218,173,-1,188,1162,1161,-1,188,187,1162,-1,193,17,1252,-1,17,193,1410,-1,1202,177,77,-1,1202,178,177,-1,1253,1254,1065,-1,1254,1253,184,-1,1411,195,1208,-1,1411,1371,195,-1,194,171,1161,-1,401,171,194,-1,192,1154,1155,-1,1154,192,189,-1,1382,1208,1207,-1,1208,1382,1411,-1,1206,1412,1070,-1,1206,1413,1412,-1,1414,1415,1416,-1,1414,418,1415,-1,238,131,1140,-1,237,131,238,-1,244,1352,245,-1,1417,1352,244,-1,1418,1417,1419,-1,1417,1418,1420,-1,1421,1137,1042,-1,1421,1045,1137,-1,391,399,1050,-1,391,390,399,-1,1158,75,77,-1,1158,1395,75,-1,1255,1129,933,-1,1255,209,1129,-1,1127,1214,268,-1,1205,1214,1127,-1,1422,1423,1424,-1,1422,1390,1423,-1,1124,1123,1125,-1,1124,273,1123,-1,233,1374,52,-1,233,1425,1374,-1,1377,34,33,-1,1426,34,1377,-1,1400,1427,1428,-1,1400,1429,1427,-1,1430,1120,282,-1,1428,1120,1430,-1,1119,347,1262,-1,1119,345,347,-1,1251,1176,1109,-1,1251,1406,1176,-1,1406,1431,1405,-1,1406,1251,1431,-1,1117,346,287,-1,1117,347,346,-1,1365,286,305,-1,1365,285,286,-1,1364,145,306,-1,1364,1432,145,-1,1107,164,163,-1,164,1107,1106,-1,1181,1105,1104,-1,1105,1181,213,-1,103,1227,1226,-1,1264,1227,103,-1,1193,1376,1363,-1,1193,1230,1376,-1,1433,1100,1434,-1,1433,988,1100,-1,310,1435,1099,-1,310,1103,1435,-1,1361,1097,1099,-1,1361,211,1097,-1,220,318,1029,-1,219,318,220,-1,321,1268,1250,-1,1095,1268,321,-1,1093,1250,1268,-1,1250,1093,161,-1,1092,1249,1370,-1,1249,1092,1148,-1,561,27,29,-1,561,1091,27,-1,149,1436,147,-1,1436,149,153,-1,1415,1436,1416,-1,1415,147,1436,-1,1360,155,154,-1,1360,1087,155,-1,329,113,112,-1,1086,113,329,-1,335,1085,119,-1,335,1270,1085,-1,1437,1081,340,-1,1437,342,1081,-1,1265,114,1113,-1,1271,114,1265,-1,108,343,118,-1,108,344,343,-1,528,1438,1439,-1,1438,528,1440,-1,1441,529,1442,-1,1441,1443,529,-1,1444,1219,1246,-1,1444,43,1219,-1,1205,1142,1214,-1,1205,1210,1142,-1,1386,1445,1387,-1,1446,1445,1386,-1,1077,370,1073,-1,1077,369,370,-1,1057,368,1131,-1,368,1057,371,-1,51,1072,362,-1,50,1072,51,-1,65,1160,1159,-1,1160,65,1071,-1,258,253,1447,-1,258,255,253,-1,378,1195,1066,-1,378,1196,1195,-1,1060,1280,1275,-1,1060,355,1280,-1,1276,1131,1130,-1,1276,1057,1131,-1,1382,1187,1080,-1,1245,1187,1382,-1,1385,1448,1368,-1,1385,1383,1448,-1,1146,1279,1449,-1,1146,358,1279,-1,1133,1450,1134,-1,1133,1064,1450,-1,265,1047,1242,-1,265,402,1047,-1,1046,247,386,-1,1058,247,1046,-1,1137,1044,1247,-1,1137,1045,1044,-1,1451,1452,1453,-1,1452,1451,1454,-1,1036,1042,1037,-1,1421,1042,1036,-1,382,69,1200,-1,382,70,69,-1,871,1013,1322,-1,787,1013,871,-1,953,1274,954,-1,1455,1274,953,-1,1456,818,817,-1,818,1456,1024,-1,1283,733,732,-1,1283,916,733,-1,951,479,952,-1,951,917,479,-1,1284,668,667,-1,1284,842,668,-1,1457,1451,1379,-1,1458,1451,1457,-1,1350,489,1459,-1,489,1350,1325,-1,1017,1460,473,-1,1017,1349,1460,-1,474,891,522,-1,474,892,891,-1,1008,819,843,-1,1008,462,819,-1,795,802,785,-1,802,795,872,-1,1011,1461,651,-1,1289,1461,1011,-1,797,876,798,-1,797,864,876,-1,1006,1274,1075,-1,1006,954,1274,-1,511,1462,1463,-1,1007,1462,511,-1,1464,506,1463,-1,1465,506,1464,-1,1466,1464,1467,-1,1466,1468,1464,-1,864,942,876,-1,1307,942,864,-1,1003,1469,1001,-1,1469,1003,1470,-1,1471,525,524,-1,1471,1472,525,-1,1001,1440,1004,-1,1473,1440,1001,-1,1474,541,540,-1,1475,541,1474,-1,1476,772,774,-1,772,1476,1477,-1,1478,884,1479,-1,1478,1480,884,-1,1347,775,550,-1,1347,542,775,-1,1295,961,745,-1,1295,995,961,-1,994,1481,945,-1,994,1482,1481,-1,826,752,751,-1,826,753,752,-1,1483,428,937,-1,427,428,1483,-1,906,1297,993,-1,906,1296,1297,-1,1334,1484,1315,-1,1484,1334,936,-1,1298,1485,578,-1,1298,990,1485,-1,834,583,1323,-1,834,989,583,-1,1333,990,558,-1,985,990,1333,-1,986,972,592,-1,986,973,972,-1,755,1345,593,-1,1486,1345,755,-1,622,601,598,-1,619,601,622,-1,534,621,620,-1,621,534,975,-1,1487,1488,1489,-1,1488,1487,1312,-1,912,1312,983,-1,1312,912,1488,-1,975,974,976,-1,1000,974,975,-1,626,1303,971,-1,626,969,1303,-1,1427,970,969,-1,970,1427,1429,-1,825,1490,823,-1,825,1491,1490,-1,813,677,676,-1,1492,677,813,-1,965,964,1493,-1,631,964,965,-1,513,939,514,-1,939,513,633,-1,1494,1495,1496,-1,1494,1497,1495,-1,907,697,933,-1,698,697,907,-1,1498,925,874,-1,1499,925,1498,-1,470,1285,471,-1,952,1285,470,-1,453,1500,452,-1,1500,453,457,-1,1501,1497,1502,-1,1501,1495,1497,-1,1028,1340,666,-1,1028,1501,1340,-1,767,943,1306,-1,767,671,943,-1,1503,1504,1481,-1,1504,1503,1505,-1,1016,1285,478,-1,1016,475,1285,-1,865,1506,849,-1,865,929,1506,-1,847,716,896,-1,847,720,716,-1,803,1507,728,-1,803,915,1507,-1,711,929,865,-1,929,711,930,-1,1018,928,927,-1,1018,723,928,-1,727,861,874,-1,861,727,726,-1,830,715,1311,-1,830,1508,715,-1,641,846,923,-1,640,846,641,-1,710,662,921,-1,662,710,663,-1,863,920,502,-1,920,863,862,-1,831,733,951,-1,734,733,831,-1,1351,468,949,-1,466,468,1351,-1,1344,1509,620,-1,1344,1510,1509,-1,1511,612,609,-1,1511,911,612,-1,1488,911,1511,-1,911,1488,912,-1,1512,909,1314,-1,1512,1489,909,-1,1513,908,982,-1,1513,738,908,-1,1294,1316,694,-1,1316,1294,973,-1,899,926,901,-1,899,485,926,-1,894,897,1023,-1,894,896,897,-1,970,1514,968,-1,1515,1514,970,-1,1516,680,1338,-1,1516,1517,680,-1,1518,893,892,-1,1518,477,893,-1,944,961,995,-1,1282,961,944,-1,611,653,652,-1,653,611,888,-1,600,604,858,-1,978,604,600,-1,883,1479,884,-1,883,1330,1479,-1,543,735,531,-1,543,443,735,-1,779,832,780,-1,832,779,777,-1,1519,1499,1498,-1,1520,1499,1519,-1,770,859,771,-1,860,859,770,-1,1498,495,1288,-1,1498,874,495,-1,486,1499,1520,-1,1499,486,488,-1,496,863,798,-1,496,794,863,-1,763,1496,637,-1,1329,1496,763,-1,962,1492,813,-1,962,1521,1492,-1,1468,624,855,-1,625,624,1468,-1,947,1026,996,-1,1026,947,946,-1,1459,1349,1350,-1,1349,1459,1522,-1,850,761,516,-1,1290,761,850,-1,1523,844,1020,-1,1470,844,1523,-1,482,1304,843,-1,482,481,1304,-1,762,823,1490,-1,675,823,762,-1,1332,901,635,-1,901,1332,960,-1,1524,1235,1224,-1,1524,839,1235,-1,882,836,835,-1,882,1223,836,-1,882,776,1524,-1,882,881,776,-1,696,580,579,-1,580,696,1525,-1,774,2,549,-1,774,553,2,-1,835,580,1318,-1,580,835,581,-1,563,1483,937,-1,1483,563,1526,-1,1325,683,927,-1,683,1325,1335,-1,467,1527,468,-1,1527,467,1528,-1,674,782,809,-1,628,782,674,-1,1470,1457,1469,-1,1470,1523,1457,-1,728,709,729,-1,728,1507,709,-1,946,1025,1026,-1,1025,946,431,-1,1339,814,805,-1,638,814,1339,-1,633,1336,939,-1,678,1336,633,-1,1494,1329,1493,-1,1494,1496,1329,-1,963,813,812,-1,963,962,813,-1,1017,1325,1350,-1,1017,1335,1325,-1,486,1320,1013,-1,1520,1320,486,-1,1519,1288,1529,-1,1288,1519,1498,-1,1327,877,642,-1,1327,958,877,-1,1519,1320,1520,-1,1320,1519,873,-1,618,1302,602,-1,618,1300,1302,-1,777,766,765,-1,777,779,766,-1,772,1330,756,-1,1330,772,1479,-1,431,1530,654,-1,431,430,1530,-1,1293,828,1027,-1,1293,2,828,-1,1317,815,1308,-1,1317,893,815,-1,1338,824,1516,-1,824,1338,1337,-1,1531,970,1429,-1,1531,1515,970,-1,1295,693,749,-1,747,693,1295,-1,584,591,590,-1,584,583,591,-1,1489,1513,1487,-1,1512,1513,1489,-1,1344,1532,1510,-1,1344,597,1532,-1,922,948,483,-1,922,1305,948,-1,709,663,710,-1,709,1507,663,-1,722,928,723,-1,724,928,722,-1,1331,702,722,-1,1331,1533,702,-1,1508,448,721,-1,830,448,1508,-1,854,712,1311,-1,930,712,854,-1,1533,715,1508,-1,1533,1331,715,-1,1534,573,827,-1,1534,574,573,-1,681,649,682,-1,681,521,649,-1,682,1018,683,-1,1018,682,1535,-1,823,1516,824,-1,967,1516,823,-1,638,1028,814,-1,638,1342,1028,-1,767,1504,765,-1,1504,767,1306,-1,1502,1340,1501,-1,1502,1536,1340,-1,1536,667,1340,-1,1536,1021,667,-1,1537,1538,1539,-1,1538,1537,1424,-1,660,519,657,-1,660,659,519,-1,1327,870,958,-1,1327,793,870,-1,637,1495,1342,-1,1496,1495,637,-1,1517,967,677,-1,1516,967,1517,-1,1531,632,1515,-1,1531,275,632,-1,629,971,1303,-1,971,629,623,-1,981,1312,1487,-1,1312,981,616,-1,781,987,585,-1,987,781,780,-1,982,1302,1300,-1,982,908,1302,-1,621,619,622,-1,977,619,621,-1,607,608,3,-1,607,910,608,-1,880,598,601,-1,599,598,880,-1,1345,595,594,-1,1345,739,595,-1,986,594,589,-1,594,986,592,-1,881,833,832,-1,881,1318,833,-1,1534,1152,932,-1,1433,1152,1534,-1,989,578,1485,-1,578,989,576,-1,576,573,577,-1,573,576,695,-1,688,1346,934,-1,688,572,1346,-1,1526,1315,1484,-1,1526,563,1315,-1,751,561,29,-1,904,561,751,-1,1482,754,753,-1,1482,748,754,-1,1482,1503,1481,-1,1503,1482,753,-1,746,1294,747,-1,555,1294,746,-1,540,552,1540,-1,540,1347,552,-1,884,1540,885,-1,884,1480,1540,-1,1541,1477,1476,-1,1477,1541,1478,-1,1475,1541,997,-1,1475,1474,1541,-1,539,1509,537,-1,539,535,1509,-1,1002,524,523,-1,1471,524,1002,-1,529,1014,530,-1,1014,529,1443,-1,523,455,902,-1,458,455,523,-1,1381,1001,1469,-1,1381,1473,1001,-1,517,658,434,-1,658,517,659,-1,761,513,514,-1,760,513,761,-1,1467,1386,1466,-1,1467,1446,1386,-1,507,1465,1291,-1,507,506,1465,-1,1542,1462,1007,-1,1542,1543,1462,-1,505,816,1005,-1,505,504,816,-1,924,502,920,-1,924,1324,502,-1,660,651,1461,-1,657,651,660,-1,851,1012,493,-1,1012,851,878,-1,820,526,482,-1,526,820,527,-1,462,509,1010,-1,462,1008,509,-1,815,477,476,-1,815,893,477,-1,1544,1328,1518,-1,1545,1328,1544,-1,468,1341,949,-1,468,1527,1341,-1,483,897,922,-1,897,483,898,-1,458,453,455,-1,453,458,457,-1,1546,1451,1458,-1,1546,1454,1451,-1,452,916,1283,-1,452,1500,916,-1,1537,1502,1497,-1,1539,1502,1537,-1,787,425,424,-1,787,871,425,-1,382,422,70,-1,382,420,422,-1,1274,1259,1074,-1,1274,1455,1259,-1,411,1547,1171,-1,411,47,1547,-1,1421,398,246,-1,1421,1036,398,-1,1451,1380,1379,-1,1451,1453,1380,-1,1247,395,1137,-1,395,1247,1236,-1,1064,1278,1450,-1,1064,1375,1278,-1,1384,1279,1052,-1,1277,1279,1384,-1,1187,1051,357,-1,1186,1051,1187,-1,1243,72,98,-1,1243,73,72,-1,1447,376,258,-1,1447,1355,376,-1,375,66,68,-1,1210,66,375,-1,1542,367,1273,-1,1542,1075,367,-1,363,1073,364,-1,1073,363,1077,-1,1387,363,1357,-1,1387,1445,363,-1,271,138,269,-1,271,1237,138,-1,1032,1210,375,-1,1032,1142,1210,-1,1378,1444,1548,-1,1378,43,1444,-1,1442,352,1441,-1,353,352,1442,-1,1439,349,348,-1,349,1439,1438,-1,349,1246,350,-1,349,1444,1246,-1,340,337,1437,-1,338,337,340,-1,337,335,1358,-1,337,1270,335,-1,1549,336,121,-1,332,336,1549,-1,118,330,116,-1,343,330,118,-1,414,156,1126,-1,156,414,325,-1,1416,326,1141,-1,1436,326,1416,-1,148,1221,27,-1,1221,148,147,-1,1249,1526,1484,-1,1526,1249,1269,-1,210,319,322,-1,210,1550,319,-1,218,1550,316,-1,319,1550,218,-1,1150,1362,1267,-1,1151,1362,1150,-1,1096,1103,1105,-1,1435,1103,1096,-1,1101,1233,24,-1,1101,837,1233,-1,1227,312,1266,-1,1227,1264,312,-1,163,309,311,-1,163,308,309,-1,1248,306,423,-1,1248,307,306,-1,304,1364,165,-1,304,1432,1364,-1,145,1551,1112,-1,145,1432,1551,-1,167,1115,298,-1,167,166,1115,-1,1175,292,126,-1,293,292,1175,-1,1409,1271,1265,-1,1409,1408,1271,-1,288,305,286,-1,305,288,303,-1,168,1178,1404,-1,168,1366,1178,-1,345,1118,392,-1,1119,1118,345,-1,282,276,1430,-1,282,277,276,-1,1401,1428,1430,-1,1401,1400,1428,-1,1399,1377,1122,-1,1399,1426,1377,-1,102,59,56,-1,102,101,59,-1,1413,1127,1238,-1,1413,1206,1127,-1,1390,1418,1423,-1,1390,1391,1418,-1,1128,1063,32,-1,1128,94,1063,-1,1184,203,1155,-1,1184,1164,203,-1,255,260,256,-1,255,258,260,-1,1079,253,255,-1,254,253,1079,-1,1538,1423,1552,-1,1538,1424,1423,-1,243,1553,244,-1,1553,243,397,-1,244,1419,1417,-1,1419,244,1553,-1,1414,131,106,-1,1414,1140,131,-1,1352,1228,419,-1,1228,1352,1229,-1,1397,33,35,-1,1397,1261,33,-1,1554,1367,272,-1,1554,1389,1367,-1,1080,1411,1382,-1,1411,1080,263,-1,26,1434,1100,-1,1434,26,316,-1,193,1555,1410,-1,182,1555,193,-1,1371,263,262,-1,1411,263,1371,-1,190,179,1253,-1,179,190,202,-1,1556,1041,186,-1,133,1041,1556,-1,1048,205,1040,-1,1048,1557,205,-1,172,30,1158,-1,172,9,30,-1,1551,288,1409,-1,303,288,1551,-1,1403,1405,1431,-1,1403,1404,1405,-1,310,314,311,-1,1266,314,310,-1,151,156,152,-1,151,154,156,-1,1554,227,1070,-1,1554,228,227,-1,1401,1426,1399,-1,1426,1401,1144,-1,1369,1398,229,-1,1388,1398,1369,-1,135,1396,1053,-1,134,1396,135,-1,238,1138,239,-1,1138,238,1139,-1,237,132,131,-1,237,1558,132,-1,146,121,144,-1,146,1549,121,-1,132,107,106,-1,1373,107,132,-1,1263,122,284,-1,122,1263,123,-1,1200,1394,1203,-1,1200,1199,1394,-1,69,82,81,-1,82,69,1244,-1,1354,1394,1393,-1,1354,75,1394,-1,178,1156,176,-1,178,1167,1156,-1,1374,1238,53,-1,1238,1374,1413,-1,136,1391,1125,-1,1559,1391,136,-1,1369,270,1367,-1,1369,55,270,-1,1215,53,1238,-1,1215,54,53,-1,415,328,416,-1,1359,328,415,-1,1051,1384,1052,-1,1051,1560,1384,-1,206,1154,207,-1,206,406,1154,-1,1380,43,1378,-1,43,1380,44,-1,1280,1276,1275,-1,1280,1058,1276,-1,39,1143,37,-1,1143,39,231,-1,1384,1561,1383,-1,1384,1560,1561,-1,1363,1194,1193,-1,1363,1233,1194,-1,23,119,1085,-1,22,119,23,-1,327,20,236,-1,327,18,20,-1,211,1376,1097,-1,25,1376,211,-1,1483,1269,222,-1,1483,1526,1269,-1,1353,1375,1065,-1,1353,1449,1375,-1,1448,186,1049,-1,1448,1556,186,-1,101,1212,59,-1,101,38,1212,-1,1259,1059,1130,-1,1259,1562,1059,-1,412,1258,413,-1,412,1030,1258,-1,419,1239,407,-1,419,1228,1239,-1,283,1387,1357,-1,283,278,1387,-1,1388,1412,1425,-1,1389,1412,1388,-1,1124,1422,1260,-1,1390,1422,1124,-1,1375,1279,1278,-1,1449,1279,1375,-1,1033,375,252,-1,1032,375,1033,-1,376,97,259,-1,376,95,97,-1,1392,104,1558,-1,104,1392,14,-1,1231,1220,105,-1,1231,1225,1220,-1,411,1083,341,-1,411,1170,1083,-1,260,295,256,-1,260,291,295,-1,1392,1030,359,-1,1031,1030,1392,-1,21,1359,415,-1,23,1359,21,-1,49,1245,139,-1,1185,1245,49,-1,35,230,1397,-1,35,231,230,-1,1400,1531,1429,-1,1402,1531,1400,-1,21,155,22,-1,155,21,1126,-1,167,1366,168,-1,167,300,1366,-1,1180,1404,1403,-1,1180,168,1404,-1,1407,1405,1177,-1,1407,1406,1405,-1,1272,287,346,-1,287,1272,1408,-1,1133,1164,1062,-1,1164,1133,1172,-1,171,208,207,-1,141,208,171,-1,173,10,9,-1,1218,10,173,-1,1253,1372,184,-1,1253,179,1372,-1,181,182,1372,-1,1555,182,181,-1,15,1410,185,-1,15,17,1410,-1,196,262,1252,-1,196,1371,262,-1,1208,1162,1209,-1,1208,195,1162,-1,207,1161,171,-1,207,188,1161,-1,1410,1557,185,-1,1557,1410,1555,-1,1153,210,1255,-1,1153,1550,210,-1,1370,1256,1092,-1,1370,1094,1256,-1,217,1150,1267,-1,217,315,1150,-1,1254,1257,1353,-1,1254,1157,1257,-1,230,102,229,-1,230,36,102,-1,36,230,39,-1,418,106,105,-1,1414,106,418,-1,1563,1552,1564,-1,1538,1552,1563,-1,1454,1564,1452,-1,1563,1564,1454,-1,1229,1417,1420,-1,1352,1417,1229,-1,1045,246,248,-1,1421,246,1045,-1,1204,82,1244,-1,82,1204,85,-1,1420,1215,1229,-1,1420,1559,1215,-1,1261,1398,233,-1,1261,1397,1398,-1,1121,1531,1402,-1,1531,1121,275,-1,1428,279,1120,-1,279,1428,1427,-1,1251,290,1431,-1,1251,289,290,-1,1263,1111,123,-1,1116,1111,1263,-1,285,1117,286,-1,285,80,1117,-1,127,1179,297,-1,1179,127,294,-1,305,301,1365,-1,305,304,301,-1,163,1364,308,-1,1364,163,165,-1,308,1104,309,-1,308,307,1104,-1,1230,1192,1226,-1,1193,1192,1230,-1,1152,1434,1153,-1,1152,1433,1434,-1,1362,1099,1435,-1,1362,1361,1099,-1,26,1361,1151,-1,26,211,1361,-1,315,219,1150,-1,318,219,315,-1,1415,1221,147,-1,1415,1222,1221,-1,214,154,151,-1,154,214,1360,-1,1190,332,1549,-1,332,1190,333,-1,121,335,119,-1,121,336,335,-1,342,334,331,-1,342,1437,334,-1,1440,1548,1438,-1,1440,1473,1548,-1,529,1439,1442,-1,529,528,1439,-1,359,412,360,-1,359,1030,412,-1,228,272,1356,-1,272,228,1554,-1,361,365,364,-1,365,361,58,-1,1446,1076,1445,-1,1076,1446,1543,-1,361,388,362,-1,388,361,366,-1,1145,362,388,-1,51,362,1145,-1,1447,1068,1067,-1,1447,253,1068,-1,377,1066,1195,-1,377,1355,1066,-1,378,1393,1196,-1,1393,378,1354,-1,1562,1443,1441,-1,1565,1443,1562,-1,1207,140,1382,-1,140,1207,1216,-1,1561,133,1556,-1,1561,134,133,-1,1368,1450,1385,-1,1368,1134,1450,-1,1135,1039,1172,-1,1039,1135,1040,-1,45,396,1281,-1,44,396,45,-1,1452,396,1453,-1,397,396,1452,-1,384,1132,390,-1,1132,384,398,-1,208,409,1547,-1,141,409,208,-1,1416,1140,1414,-1,1416,1141,1140,-1,87,1198,1168,-1,87,86,1198,-1,1319,463,426,-1,788,463,1319,-1,877,1013,1320,-1,1013,877,1322,-1,840,778,1505,-1,839,778,840,-1,1456,436,1024,-1,1456,700,436,-1,1566,467,466,-1,1566,721,467,-1,1458,1523,1022,-1,1458,1457,1523,-1,664,462,461,-1,664,819,462,-1,465,647,646,-1,1023,647,465,-1,1459,948,950,-1,948,1459,489,-1,1017,681,1335,-1,681,1017,472,-1,1527,1522,1341,-1,1522,1527,1567,-1,891,1506,520,-1,891,1317,1506,-1,955,843,1304,-1,1008,843,955,-1,878,1321,1529,-1,1321,878,802,-1,492,1289,493,-1,492,1461,1289,-1,507,1286,508,-1,1015,1286,507,-1,1009,1463,506,-1,511,1463,1009,-1,1463,1467,1464,-1,1463,1462,1467,-1,1468,1465,1464,-1,1468,855,1465,-1,1307,867,1568,-1,864,867,1307,-1,844,1003,902,-1,1470,1003,844,-1,526,1472,480,-1,526,525,1472,-1,1471,530,1472,-1,1348,530,1471,-1,1004,528,1348,-1,1004,1440,528,-1,542,531,775,-1,532,531,542,-1,538,1301,980,-1,538,537,1301,-1,533,1475,544,-1,1475,533,541,-1,549,1476,774,-1,548,1476,549,-1,1474,1478,1541,-1,1480,1478,1474,-1,885,552,551,-1,885,1540,552,-1,748,994,749,-1,748,1482,994,-1,840,1503,838,-1,1503,840,1505,-1,692,750,558,-1,750,692,691,-1,991,575,574,-1,991,570,575,-1,578,934,1298,-1,578,577,934,-1,984,990,985,-1,984,1485,990,-1,581,1101,579,-1,1101,581,837,-1,582,1323,583,-1,1323,582,987,-1,589,595,590,-1,595,589,594,-1,593,972,903,-1,592,972,593,-1,1345,599,739,-1,599,1345,1486,-1,1532,755,979,-1,755,1532,1486,-1,978,605,604,-1,605,978,737,-1,888,1313,889,-1,888,613,1313,-1,537,1510,1301,-1,1509,1510,537,-1,598,1344,622,-1,598,597,1344,-1,1314,736,1512,-1,1343,736,1314,-1,956,1000,879,-1,956,974,1000,-1,279,969,626,-1,279,1427,969,-1,1490,1514,966,-1,1491,1514,1490,-1,809,679,810,-1,679,809,782,-1,762,1493,1329,-1,965,1493,762,-1,1497,1569,1537,-1,1569,1497,1494,-1,488,899,901,-1,899,488,487,-1,703,897,896,-1,897,703,922,-1,652,657,656,-1,651,657,652,-1,665,457,459,-1,665,1500,457,-1,1501,1342,1495,-1,1501,1028,1342,-1,1570,1454,1546,-1,1570,1563,1454,-1,1539,1563,1570,-1,1539,1538,1563,-1,765,1505,778,-1,765,1504,1505,-1,679,1338,680,-1,783,1338,679,-1,783,1326,1338,-1,929,520,1506,-1,929,650,520,-1,934,692,1298,-1,1346,692,934,-1,1297,1334,993,-1,1334,1297,935,-1,568,932,697,-1,932,568,991,-1,1566,1508,721,-1,1566,1533,1508,-1,923,845,704,-1,845,923,846,-1,641,865,800,-1,865,641,711,-1,723,1535,713,-1,1018,1535,723,-1,724,718,928,-1,724,931,718,-1,447,1528,467,-1,447,469,1528,-1,446,466,1351,-1,1566,466,446,-1,960,921,925,-1,921,960,710,-1,620,535,534,-1,620,1509,535,-1,1489,1511,909,-1,1511,1489,1488,-1,1512,738,1513,-1,738,1512,736,-1,1343,605,736,-1,603,605,1343,-1,746,828,553,-1,746,745,828,-1,498,515,499,-1,516,515,498,-1,1491,968,1514,-1,1491,940,968,-1,1517,1336,680,-1,1517,1571,1336,-1,1518,764,477,-1,1518,1328,764,-1,1282,943,429,-1,1282,944,943,-1,766,671,767,-1,671,766,1572,-1,610,652,656,-1,652,610,611,-1,545,818,998,-1,818,545,440,-1,839,776,778,-1,1524,776,839,-1,807,1530,1572,-1,807,5,1530,-1,771,1011,653,-1,859,1011,771,-1,876,434,658,-1,876,942,434,-1,708,726,725,-1,726,708,918,-1,585,806,781,-1,587,806,585,-1,1422,964,1260,-1,1422,1569,964,-1,1521,1571,1492,-1,1521,938,1571,-1,1466,625,1468,-1,627,625,1466,-1,1339,1307,1568,-1,1339,941,1307,-1,853,812,763,-1,853,963,812,-1,996,1027,947,-1,996,1293,1027,-1,1460,474,473,-1,474,1460,1544,-1,847,699,845,-1,847,895,699,-1,481,953,1304,-1,953,481,1287,-1,1309,1326,630,-1,1309,1337,1326,-1,1545,1460,1567,-1,1460,1545,1544,-1,1524,1223,882,-1,1524,1224,1223,-1,1525,695,1299,-1,1525,696,695,-1,672,0,673,-1,0,672,829,-1,1525,834,833,-1,1525,1299,834,-1,838,841,840,-1,838,1234,841,-1,1528,1567,1527,-1,1567,1528,1545,-1,825,1337,1309,-1,824,1337,825,-1,1287,1455,953,-1,1287,1565,1455,-1,1379,1469,1457,-1,1381,1469,1379,-1,1506,1308,759,-1,1506,1317,1308,-1,1349,1567,1460,-1,1349,1522,1567,-1,638,1568,959,-1,638,1339,1568,-1,1386,627,1466,-1,280,627,1386,-1,939,1571,938,-1,1336,1571,939,-1,1493,1569,1494,-1,1569,1493,964,-1,654,5,655,-1,654,1530,5,-1,1292,434,1025,-1,1292,517,434,-1,861,918,862,-1,861,726,918,-1,634,1324,924,-1,634,799,1324,-1,873,1529,1321,-1,1529,873,1519,-1,617,976,887,-1,617,977,976,-1,976,784,887,-1,976,974,784,-1,1302,600,602,-1,600,1302,978,-1,1572,779,807,-1,779,1572,766,-1,551,980,885,-1,551,538,980,-1,1300,617,614,-1,618,617,1300,-1,430,1572,1530,-1,430,671,1572,-1,433,996,1026,-1,433,673,996,-1,1518,474,1544,-1,892,474,1518,-1,1309,1491,825,-1,1491,1309,940,-1,938,499,515,-1,938,1521,499,-1,907,936,742,-1,907,957,936,-1,1487,982,981,-1,1513,982,1487,-1,607,1343,1314,-1,606,1343,607,-1,1486,597,599,-1,597,1486,1532,-1,489,483,948,-1,484,483,489,-1,661,465,464,-1,914,465,661,-1,1456,439,758,-1,1456,817,439,-1,663,915,661,-1,1507,915,663,-1,960,1499,488,-1,960,925,1499,-1,1533,446,702,-1,1533,1566,446,-1,729,635,924,-1,635,729,709,-1,717,490,718,-1,926,490,717,-1,648,713,1535,-1,648,714,713,-1,719,634,636,-1,640,634,719,-1,449,1311,712,-1,830,1311,449,-1,574,932,991,-1,1534,932,574,-1,649,1535,682,-1,649,648,1535,-1,1521,868,499,-1,868,1521,962,-1,995,945,944,-1,995,994,945,-1,1539,1536,1502,-1,1539,1570,1536,-1,1570,1021,1536,-1,1570,1546,1021,-1,955,1006,510,-1,954,1006,955,-1,793,871,870,-1,425,871,793,-1,1568,866,959,-1,1568,867,866,-1,1537,1422,1424,-1,1569,1422,1537,-1,1490,965,762,-1,1490,966,965,-1,677,1571,1517,-1,1571,677,1492,-1,1515,966,1514,-1,1515,632,966,-1,940,1303,968,-1,940,629,1303,-1,563,744,1315,-1,563,562,744,-1,887,614,617,-1,614,887,615,-1,909,609,910,-1,909,1511,609,-1,1510,979,1301,-1,1510,1532,979,-1,889,983,769,-1,889,1313,983,-1,1330,979,755,-1,1330,883,979,-1,740,599,880,-1,740,739,599,-1,985,1316,986,-1,985,1333,1316,-1,1323,780,832,-1,1323,987,780,-1,1525,1318,580,-1,1318,1525,833,-1,827,1433,1534,-1,1433,827,988,-1,1485,591,989,-1,591,1485,984,-1,1299,576,989,-1,576,1299,695,-1,572,571,690,-1,572,688,571,-1,1296,567,569,-1,1296,906,567,-1,569,992,1296,-1,569,743,992,-1,1315,993,1334,-1,1315,1310,993,-1,826,1503,753,-1,1503,826,838,-1,747,694,693,-1,747,1294,694,-1,1474,1540,1480,-1,540,1540,1474,-1,1477,1479,772,-1,1477,1478,1479,-1,1476,997,1541,-1,997,1476,548,-1,997,544,1475,-1,997,546,544,-1,902,1002,523,-1,1002,902,1003,-1,1002,1348,1471,-1,1002,1004,1348,-1,480,530,1014,-1,480,1472,530,-1,1025,654,1292,-1,654,1025,431,-1,855,1291,1465,-1,855,808,1291,-1,1462,1446,1467,-1,1462,1543,1446,-1,1015,1291,1005,-1,1015,507,1291,-1,1075,1007,1006,-1,1542,1007,1075,-1,1005,1016,1015,-1,1005,816,1016,-1,494,1461,492,-1,660,1461,494,-1,493,852,851,-1,852,493,1289,-1,1529,1012,878,-1,1529,1288,1012,-1,1443,1287,1014,-1,1443,1565,1287,-1,460,508,1286,-1,460,1010,508,-1,759,849,1506,-1,759,1290,849,-1,469,1545,1528,-1,1545,469,1328,-1,1459,1341,1522,-1,950,1341,1459,-1,444,949,1305,-1,444,1351,949,-1,1022,1020,1284,-1,1022,1523,1020,-1,1022,1546,1458,-1,1022,1021,1546,-1,917,1500,665,-1,1500,917,916,-1,758,700,1456,-1,758,757,700,-1,1306,1481,1504,-1,1481,1306,945,-1,1319,792,789,-1,643,792,1319,-1,90,1198,84,-1,90,89,1198,-1,1419,1423,1418,-1,1419,1552,1423,-1,1035,1547,47,-1,208,1547,1035,-1,242,143,1037,-1,242,241,143,-1,186,1557,1048,-1,1557,186,185,-1,44,1453,396,-1,1380,1453,44,-1,248,41,40,-1,248,247,41,-1,1184,1062,1164,-1,1184,1183,1062,-1,1368,1049,1135,-1,1049,1368,1448,-1,134,1560,1396,-1,134,1561,1560,-1,1053,49,1054,-1,1185,49,1053,-1,371,1046,372,-1,1046,371,1057,-1,1441,1059,1562,-1,1441,352,1059,-1,1241,1196,1393,-1,1241,1243,1196,-1,1355,1067,1066,-1,1067,1355,1447,-1,389,366,1056,-1,389,388,366,-1,1273,1543,1542,-1,1273,1076,1543,-1,1445,1077,363,-1,1077,1445,1076,-1,269,1356,272,-1,269,138,1356,-1,252,1078,1033,-1,252,254,1078,-1,1548,1381,1378,-1,1381,1548,1473,-1,1247,350,1246,-1,1247,1044,350,-1,348,1442,1439,-1,1442,348,353,-1,1438,1444,349,-1,1438,1548,1444,-1,1408,1191,1271,-1,1272,1191,1408,-1,1358,1437,337,-1,334,1437,1358,-1,1086,1190,113,-1,333,1190,1086,-1,326,153,152,-1,153,326,1436,-1,1415,417,1222,-1,1415,418,417,-1,150,217,1090,-1,150,215,217,-1,222,427,1483,-1,221,427,222,-1,1256,1095,1092,-1,1095,1256,1268,-1,1484,1370,1249,-1,1484,936,1370,-1,1435,1267,1362,-1,1096,1267,1435,-1,1266,1098,1227,-1,1099,1098,1266,-1,1096,213,1090,-1,1096,1105,213,-1,1248,1104,307,-1,1104,1248,1182,-1,304,164,301,-1,164,304,165,-1,1112,146,145,-1,146,1112,1114,-1,1109,126,125,-1,1175,126,1109,-1,1112,1409,1265,-1,1551,1409,1112,-1,1108,1177,294,-1,1407,1177,1108,-1,124,79,78,-1,124,1110,79,-1,157,1269,1249,-1,159,1269,157,-1,1430,1144,1401,-1,276,1144,1430,-1,1122,1402,1399,-1,1402,1122,1121,-1,1388,233,1398,-1,1388,1425,233,-1,1123,1377,137,-1,1377,1123,1122,-1,1420,1391,1559,-1,1418,1391,1420,-1,1162,198,1209,-1,198,1162,187,-1,422,85,1204,-1,422,421,85,-1,367,1131,368,-1,367,1074,1131,-1,397,1564,1553,-1,1564,397,1452,-1,1553,1552,1419,-1,1552,1553,1564,-1,1141,325,1139,-1,325,1141,326,-1,281,38,277,-1,281,1212,38,-1,391,1145,387,-1,1145,391,1055,-1,1257,1449,1353,-1,1449,1257,1146,-1,1157,1147,1257,-1,261,1147,1157,-1,159,323,1149,-1,159,158,323,-1,223,220,1029,-1,223,320,220,-1,1153,316,1550,-1,1153,1434,316,-1,1252,16,196,-1,1252,17,16,-1,1218,64,63,-1,405,64,1218,-1,183,261,1157,-1,261,183,1163,-1,11,175,1160,-1,11,10,175,-1,205,1555,181,-1,1557,1555,205,-1,1395,30,1063,-1,1158,30,1395,-1,1159,1211,65,-1,1159,1240,1211,-1,408,1547,409,-1,1171,1547,408,-1,1047,251,91,-1,1047,404,251,-1,1062,1064,1133,-1,1062,381,1064,-1,303,1432,304,-1,303,1551,1432,-1,1366,1179,1178,-1,1366,296,1179,-1,1111,1431,290,-1,1111,1403,1431,-1,936,1129,162,-1,957,1129,936,-1,1070,1389,1554,-1,1389,1070,1412,-1,1426,1143,34,-1,1426,1144,1143,-1,1051,1396,1560,-1,1051,1186,1396,-1,328,235,413,-1,236,235,328,-1,1558,1031,1392,-1,237,1031,1558,-1,259,291,260,-1,259,292,291,-1,1549,1114,1190,-1,146,1114,1549,-1,1373,1558,104,-1,1373,132,1558,-1,302,1263,284,-1,302,1115,1263,-1,1197,1262,79,-1,1119,1262,1197,-1,1395,383,1203,-1,1395,1063,383,-1,1211,1069,68,-1,1201,1069,1211,-1,1559,54,1215,-1,1559,136,54,-1,1425,1413,1374,-1,1412,1413,1425,-1,281,1357,365,-1,281,283,1357,-1,413,416,328,-1,413,1258,416,-1,1277,1450,1278,-1,1277,1385,1450,-1,1356,1166,228,-1,1356,1216,1166,-1,1455,1562,1259,-1,1565,1562,1455,-1,1058,41,247,-1,1058,1280,41,-1,231,34,1143,-1,231,35,34,-1,1383,1556,1448,-1,1383,1561,1556,-1,841,1222,417,-1,1222,841,1234,-1,1098,1376,1230,-1,1376,1098,1097,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c6_Coord',point=[(-.50283,53.06068,-1.44633),(-.49849,53.0575,-1.4496),(-.44375,52.98255,-1.55065),(-.4424,53.45789,-1.42165),(-.43874,53.45551,-1.41829),(-.41996,53.42117,-1.49292),(-.01728,52.967,-2.24353),(0,52.97641,-2.33182),(0,52.98638,-2.23863),(.74475,53.1478,-1.15171),(.70296,53.12849,-1.14318),(.696,53.15044,-1.12451),(.43773,53.45548,-1.41775),(.43874,53.45551,-1.41829),(.41996,53.42117,-1.49292),(.56177,52.98213,-1.01962),(.53831,52.99806,-1.03641),(.5654,52.99894,-1.0145),(.53465,53.07633,-1.36371),(.45732,53.09985,-1.32307),(.51375,53.13973,-1.34694),(.41254,52.98489,-1.60272),(.4304,52.92897,-1.62361),(.44375,52.98255,-1.55001),(.06238,53.26434,-2.05039),(.13422,53.23251,-2.0418),(.12434,53.18552,-2.14522),(.01551,53.03897,-1.98106),(0,53.10747,-1.94721),(0,53.06159,-1.98862),(.76531,53.14226,-1.1245),(.73066,53.14635,-1.12451),(.78067,53.13188,-1.09989),(.2935,53.2683,-1.06214),(.28831,53.2389,-1.00916),(.29862,53.24757,-1.0067),(.32465,53.20032,-.91774),(.3128,53.19322,-.92067),(.33064,53.16511,-.87872),(.31974,53.20658,-.9272),(.33666,52.82638,-1.10073),(.36529,52.77494,-1.0279),(.31179,52.82535,-1.09868),(.17002,52.86192,-1.37376),(.171,52.88125,-1.38913),(.24581,52.89329,-1.38495),(.69308,53.10036,-1.2529),(.61898,53.0732,-1.27288),(.66656,53.09241,-1.28122),(.50796,53.17181,-.89299),(.46592,53.17157,-.87469),(.46401,53.10572,-.90634),(.33954,53.34341,-1.12011),(.3377,53.37032,-1.16527),(.28214,53.34205,-1.22725),(.40147,53.32437,-.86911),(.37822,53.24605,-.85726),(.38299,53.2436,-.84827),(.35412,53.15212,-.83815),(.35161,53.16705,-.84653),(.41005,53.42708,-1.51058),(.36289,53.41366,-1.59287),(.68507,53.13626,-1.20419),(.67687,53.13704,-1.16034),(.6728,53.09681,-1.18136),(.61279,53.25845,-1.15588),(.57449,53.30582,-1.16502),(.55933,53.3061,-1.12016),(.59104,53.2982,-1.22169),(.97922,53.20918,-1.12249),(.98447,53.17203,-1.10323),(1.05288,53.17865,-1.09723),(.91633,53.28399,-1.15792),(.91355,53.27949,-1.13655),(.91766,53.23962,-1.1354),(.79997,53.21933,-1.16307),(.74464,53.25649,-1.19279),(.75288,53.21705,-1.1748),(.85596,53.35705,-1.38828),(.91857,53.41917,-1.27617),(.85416,53.28355,-1.43354),(.96349,53.19238,-1.14703),(1.05113,53.14938,-1.12468),(.97514,53.148,-1.16236),(.93149,53.12591,-1.16015),(1.03574,53.11094,-1.12975),(.94315,53.16067,-1.17528),(.91294,53.1826,-1.20704),(.91768,53.23976,-1.15077),(.86236,53.12215,-1.19242),(.88587,53.10076,-1.1608),(.8373,53.0825,-1.18105),(.86839,53.07427,-1.11723),(.91673,53.08866,-1.12114),(.85051,53.10465,-1.08869),(.82231,53.51072,-1.14573),(.89474,53.48604,-1.21769),(.82032,53.54276,-1.17104),(.90778,53.36524,-1.17478),(.87982,53.45362,-1.1823),(.86756,53.42696,-1.1532),(.34045,53.17372,-.88192),(.35785,53.24487,-.89468),(.31463,53.40097,-1.66962),(.37134,53.41498,-1.57228),(.13599,53.32782,-1.81936),(.21855,53.3154,-1.77419),(.24108,53.38118,-1.7537),(.80824,53.11931,-1.33987),(.79352,53.13002,-1.33279),(.70469,53.11668,-1.29067),(.70278,53.10414,-1.29206),(.90314,52.9184,-1.52284),(.83438,52.87013,-1.58692),(.90661,52.91855,-1.53),(.79811,53.12827,-1.34336),(.9144,52.99317,-1.45669),(.88073,53.06616,-1.39019),(.87628,53.06196,-1.38135),(.44316,52.92928,-1.61902),(.51057,52.8649,-1.65723),(.53126,52.85532,-1.65354),(.79052,53.30586,-1.46473),(.78703,53.32185,-1.46668),(.85394,53.3719,-1.39416),(.89342,53.48965,-1.22421),(.81895,53.54362,-1.1765),(.50153,53.50745,-1.34444),(.4966,53.50615,-1.33956),(.55468,53.54744,-1.26606),(.41962,53.43229,-1.49293),(.29005,53.30524,-1.68705),(.29864,53.34305,-1.66986),(.55678,52.98974,-.95113),(.56473,53.0427,-.90921),(.53741,53.04326,-.92572),(.2107,53.32332,-1.22568),(.21705,53.25967,-1.14867),(.48586,53.27118,-.91708),(.5171,53.23524,-.91711),(.52201,53.24835,-.9462),(.51782,53.03646,-1.19649),(.49677,53.01991,-1.17304),(.45716,53.01064,-1.23548),(.52363,52.86527,-1.66542),(.63701,52.96741,-1.70154),(.65615,52.86245,-1.66691),(.13292,53.07624,-1.88169),(.10046,53.02281,-1.92725),(.1509,53.01784,-1.89394),(.08187,52.98906,-1.96008),(.26906,52.97311,-1.79164),(.26219,53.0097,-1.77861),(.20633,53.01478,-1.84919),(.34152,52.96054,-1.71783),(.39472,52.96087,-1.67546),(.33831,52.99616,-1.70744),(.13189,52.93144,-2.60105),(.18508,52.92704,-2.5806),(.115,52.92333,-2.56301),(.14602,53.1553,-2.4767),(.17055,53.15145,-2.53923),(.11763,53.15043,-2.53891),(.48614,53.16161,-1.65674),(.54382,53.19632,-1.62895),(.5439,53.15996,-1.65124),(.6154,53.33031,-1.49073),(.56592,53.34492,-1.48465),(.60053,53.37368,-1.4245),(.75456,53.14113,-1.28031),(.47573,53.00336,-1.14959),(.51148,53.03848,-1.14425),(.75144,53.17274,-1.16872),(.74757,53.12926,-1.16854),(.67209,53.1696,-1.18088),(.66285,53.15946,-1.14444),(.73562,53.16655,-1.20391),(.74692,53.19054,-1.18811),(.72151,53.18435,-1.19859),(.70209,53.04679,-.9922),(.69244,53.00498,-1.01838),(.66992,53.01567,-.99149),(.64592,53.0536,-.97445),(.66418,53.10986,-.94633),(.69948,53.0989,-.94956),(.59979,52.9563,-.9924),(.59197,52.90813,-.99839),(.60588,53.1532,-1.09657),(.5821,53.11252,-1.12214),(.66601,53.10229,-1.11319),(.74206,53.05901,-1.00649),(.74556,53.09858,-1.06355),(.73136,53.08148,-1.07552),(.61445,53.04591,-.96909),(.52622,53.10677,-1.04143),(.54746,53.16996,-1.01678),(.55297,53.08767,-1.01317),(.76003,53.10229,-1.05988),(.61729,53.17815,-1.09918),(.6806,53.12364,-1.10756),(.69407,53.14311,-1.10045),(.71413,53.11497,-1.24835),(.73015,53.03866,-1.02233),(.71929,52.99157,-1.05327),(.69461,52.98116,-1.02051),(.66273,52.97168,-1.00293),(.63504,53.12728,-1.16269),(.577,53.07954,-1.14945),(.56936,53.05788,-1.21224),(.08919,53.16544,-2.46645),(.12876,53.14354,-2.41208),(.16571,53.21856,-2.03803),(.21406,52.98025,-1.87114),(.23926,52.94539,-1.90352),(.29563,52.92949,-1.80524),(.06728,52.97145,-2.03127),(.01273,52.97146,-2.11885),(.13456,52.94679,-2.03686),(.13804,53.10409,-2.23444),(.10244,53.0481,-2.23088),(.1103,53.03669,-2.33092),(.06649,52.94326,-2.40364),(.06649,52.93831,-2.45962),(.12366,52.96444,-2.4257),(.17735,52.96452,-2.61849),(.20241,52.97146,-2.58109),(.53432,53.29023,-1.08484),(.49736,53.34786,-1.05102),(.50325,53.33799,-.99533),(.36218,53.30003,-.9223),(.32718,53.25397,-.94088),(.30215,53.22333,-.95569),(.27922,53.29767,-1.13286),(.37127,53.3544,-1.02723),(.4662,53.23132,-1.32856),(.46987,53.24347,-1.3647),(.49568,53.14987,-1.38462),(.35708,53.31384,-1.59841),(.35987,53.25544,-1.62079),(.39747,53.26467,-1.53228),(.39601,53.07886,-1.31335),(.42816,53.04993,-1.30553),(.38663,53.01709,-1.30423),(.23851,53.03241,-1.32891),(.23776,53.10403,-1.30384),(.30922,53.09897,-1.31992),(.38887,52.86705,-1.0907),(.39457,52.78069,-1.0309),(.36293,52.82806,-1.1027),(.75045,53.1591,-1.18293),(.76965,53.10824,-1.21873),(.76901,53.09855,-1.18842),(.55001,53.34951,-1.27622),(.6008,53.43555,-1.2282),(.5405,53.42829,-1.27332),(.58283,53.52316,-1.22722),(.55902,53.54778,-1.26327),(.49175,53.47913,-1.31732),(.65037,53.54304,-1.1792),(.72335,53.56813,-1.14916),(.63432,53.56711,-1.20226),(.64668,53.16242,-.92932),(.59851,53.13726,-.9532),(.60186,53.19437,-.92827),(.8229,53.06894,-1.08551),(.82649,53.04033,-1.0965),(.28323,53.34256,-1.23828),(.28416,53.34333,-1.23766),(.33621,53.33319,-1.24709),(.45215,53.31736,-.87675),(.40999,53.32432,-.86735),(.43354,53.2518,-.84996),(.47007,53.37394,-.91906),(.07405,53.24014,-1.1502),(0,53.22217,-1.14852),(0,53.1967,-1.06967),(.25736,53.1568,-.87843),(.26815,53.13933,-.83499),(.11742,53.08835,-.7475),(0,53.09681,-.80625),(0,53.07052,-.75804),(.2831,53.13034,-.81086),(.21318,53.12547,-.8051),(.22042,53.10719,-.77732),(.71542,53.28666,-1.50456),(.80488,53.26598,-1.49865),(.80599,53.20126,-1.54353),(.87481,53.15064,-1.51595),(.80605,53.1341,-1.57489),(.78932,53.42979,-1.35186),(.77963,53.40242,-1.38056),(.63685,53.56841,-1.20616),(.7244,53.56922,-1.15479),(.6939,53.52298,-1.256),(.54015,53.47898,-1.35475),(.55995,53.54803,-1.26906),(.49257,53.41489,-1.43541),(.4424,53.45789,-1.42165),(.52015,53.33341,-1.54036),(.46231,53.38602,-1.53318),(.51238,53.37448,-1.4706),(.64846,53.22308,-1.61559),(.62191,53.30132,-1.53213),(.70945,53.14099,-1.63126),(.64421,53.15389,-1.65442),(.71317,53.17878,-1.61576),(.51516,52.96693,-1.71826),(.47598,52.97892,-1.73885),(.47676,53.06705,-1.69348),(.40391,53.07704,-1.76188),(.32854,53.16528,-1.83836),(.40849,53.17219,-1.73484),(.38718,53.2643,-1.70997),(.47008,53.31047,-1.60623),(.39032,53.22444,-1.7146),(.08869,52.97864,-2.133),(.11546,53.16895,-2.24933),(.01728,52.967,-2.24351),(.05113,52.99709,-2.23435),(.13122,53.0972,-2.33188),(.14901,53.02777,-2.39926),(.18846,53.05486,-2.49009),(.15758,53.08155,-2.40392),(.19127,52.90794,-2.53183),(.2074,52.99038,-2.49092),(.32841,53.06472,-1.67911),(.26101,53.07084,-1.76547),(.50283,53.06068,-1.44576),(.46481,53.15951,-1.4378),(.83282,52.98116,-1.50717),(.83354,53.00328,-1.4747),(.7916,52.98917,-1.49908),(.66852,52.91468,-1.60226),(.72848,52.91244,-1.57933),(.71559,52.97801,-1.52356),(.53283,52.9584,-1.58082),(.57513,52.92911,-1.59799),(.58609,53.02289,-1.49728),(.57706,53.04761,-1.44978),(.52156,53.03551,-1.49141),(.6456,53.06607,-1.40518),(.62222,53.07615,-1.32648),(.77121,53.04728,-1.44866),(.81481,53.03582,-1.43353),(.79254,53.07395,-1.39844),(.89243,53.22555,-1.32517),(.90255,53.16286,-1.40897),(.88878,53.22518,-1.38229),(.17619,52.84187,-1.08678),(.1696,52.85451,-1.16793),(.26615,52.86812,-1.17284),(.2577,52.79449,-1.01156),(.17122,52.75232,-.94317),(.18186,52.80303,-1.0008),(.2647,52.84069,-1.08832),(.31659,52.79263,-1.009),(.64122,53.2048,-.86601),(.61589,53.19194,-.83206),(.67122,53.19628,-.80677),(.43272,53.40633,-1.40947),(.45769,53.4127,-1.35648),(.35006,53.06339,-.86869),(.40471,53.08976,-.89523),(.21474,53.0117,-.80576),(.28769,53.03116,-.84033),(.28591,53.12597,-.80247),(.33908,52.9942,-.88843),(.10679,52.81972,-.83374),(.2149,52.82481,-.83584),(.21776,52.89759,-.83683),(.2874,52.91037,-.86029),(.2908,52.83787,-.84506),(.35538,52.85315,-.89057),(.50716,53.34267,-1.11417),(.63675,53.3212,-1.24006),(.55124,53.31431,-1.25881),(.73285,53.54239,-1.13627),(.82826,53.47134,-1.1278),(.80726,53.32232,-1.17589),(.72684,53.31766,-1.22113),(.76906,53.09076,-.98998),(.78035,53.05359,-.9833),(.91607,53.16541,-1.10929),(.85664,53.15914,-1.11826),(.42682,52.87651,-.9894),(.41228,52.86746,-.94117),(.40442,52.80787,-1.01708),(.46077,52.97039,-.95184),(.39878,53.0114,-.92223),(.40212,52.94181,-.92341),(.47953,52.94532,-1.0142),(.50259,52.98367,-.95949),(.90117,53.20905,-1.25761),(.81398,53.1693,-1.26233),(.32451,52.92932,-1.35046),(.30414,52.89463,-1.34465),(.17051,52.92878,-1.36563),(.16726,53.02348,-1.31366),(.41667,52.90888,-1.08525),(.51947,52.94742,-1.0273),(.47748,52.96934,-1.07007),(.49441,53.02605,-1.06603),(.80141,53.01801,-1.12256),(.73998,53.04893,-1.12998),(.74858,53.05835,-1.15663),(.71478,53.08463,-1.16447),(.66486,53.1181,-1.14653),(.42104,53.14266,-1.32616),(.53131,53.05217,-1.30979),(.51923,53.03536,-1.24721),(.47422,53.07202,-1.31929),(.61831,53.07683,-1.31594),(.44358,53.33025,-1.38078),(.45028,53.25243,-1.41004),(.36988,53.07337,-1.61828),(.41349,53.06554,-1.56702),(.42866,53.16863,-1.49909),(.06395,53.26445,-1.85641),(.14018,53.25866,-1.83065),(.36161,53.15791,-1.31379),(.92363,53.11398,-1.09369),(.97811,53.10265,-1.12172),(.97614,53.12144,-1.09186),(.49403,52.89104,-1.68758),(-.91673,53.08866,-1.12168),(-.97811,53.10265,-1.12217),(-.93149,53.12591,-1.16058),(0,52.98755,-2.38432),(-.06649,52.94326,-2.4037),(-.39747,53.26467,-1.53248),(-.40532,53.31645,-1.51942),(-.42868,53.32603,-1.42128),(-.4662,53.23132,-1.32884),(-.46987,53.24347,-1.36496),(-.47943,53.33214,-1.3257),(-.69308,53.10036,-1.25348),(-.60801,53.07387,-1.22667),(-.67383,53.11061,-1.21248),(-.47422,53.07202,-1.31983),(-.53131,53.05217,-1.31041),(-.54694,53.07186,-1.35426),(-.75615,53.11932,-1.2501),(-.75456,53.14113,-1.2808),(-.70469,53.11668,-1.29122),(-.72004,52.91766,-1.02617),(-.69461,52.98116,-1.02131),(-.66273,52.97168,-1.00374),(-.53958,52.93517,-1.02385),(-.56177,52.98213,-1.02035),(-.53831,52.99806,-1.03708),(-.38663,53.01709,-1.30476),(-.35317,52.97391,-1.32475),(-.37237,52.92483,-1.24882),(-.34578,52.89673,-1.26788),(-.30414,52.89463,-1.34521),(-.30503,52.88555,-1.27468),(-.28024,52.87944,-1.32329),(-.34956,52.87774,-1.18674),(-.31409,52.86875,-1.18625),(-.36293,52.82806,-1.10342),(-.41228,52.86711,-.94305),(-.40442,52.80756,-1.01857),(-.35959,52.75839,-.92409),(-.88587,53.10076,-1.16133),(-.8373,53.0825,-1.18166),(-.8178,53.03413,-1.14949),(-.63726,52.89628,-1.00764),(-.59197,52.90813,-.99928),(-.64399,52.89605,-.98419),(-.55678,52.98974,-.95181),(-.51947,52.94742,-1.02805),(-.53628,52.99284,-.95713),(-.67122,53.19628,-.807),(-.66896,53.16652,-.81341),(-.61375,53.16949,-.83082),(-.50586,53.03606,-.94243),(-.50553,53.11281,-.90157),(-.53632,53.11702,-.89437),(-.46077,52.97039,-.95247),(-.42682,52.87651,-.99014),(-.17122,52.72393,-.95945),(-.16664,52.69371,-.92647),(-.26755,52.70215,-.9573),(-.77384,53.01145,-1.01271),(-.78035,53.05359,-.98393),(-.7876,53.07337,-1.03529),(-.85664,53.15914,-1.11863),(-.85051,53.10465,-1.08921),(-.81519,53.14421,-1.12507),(-.77233,53.06229,-.91552),(-.76906,53.09076,-.99052),(-.72684,53.31766,-1.22118),(-.70594,53.37513,-1.20423),(-.79573,53.39017,-1.16196),(-.62481,53.36,-1.24724),(-.74464,53.25649,-1.19298),(-.65989,53.2882,-1.23356),(-.50716,53.34267,-1.11424),(-.49736,53.34786,-1.05108),(-.46138,53.40024,-1.03629),(-.53432,53.29023,-1.08499),(-.55933,53.3061,-1.12029),(-.61279,53.25845,-1.1561),(-.43354,53.2518,-.85012),(-.46592,53.17157,-.87499),(-.4208,53.16356,-.8631),(-.28909,52.97183,-.8545),(-.33908,52.99408,-.88889),(-.34058,52.92174,-.88708),(-.2908,52.8188,-.86011),(-.2149,52.79511,-.85531),(-.21776,52.8762,-.84615),(-.47119,53.24398,-.88915),(-.45215,53.31736,-.87682),(-.47007,53.37394,-.91906),(-.46906,53.38926,-.97733),(-.50325,53.33799,-.99539),(-.48937,53.4153,-1.31195),(-.49175,53.47913,-1.31732),(-.53718,53.50012,-1.26729),(-.60017,53.20665,-.90124),(-.64122,53.2048,-.86626),(-.61589,53.19194,-.83232),(-.26615,52.86812,-1.17336),(-.2647,52.83752,-1.09001),(-.2577,52.77986,-1.0207),(-.27045,52.74344,-.97956),(-.31659,52.78469,-1.01645),(0,52.82316,-1.08817),(0,52.79843,-1.0089),(-.11051,52.78781,-1.01229),(-.80824,53.11931,-1.3404),(-.79254,53.07395,-1.3991),(-.75077,53.07369,-1.39598),(-.90255,53.16286,-1.40933),(-.91417,53.08273,-1.44321),(-.88073,53.06616,-1.39085),(-.90042,52.97886,-1.53723),(-.90661,52.91855,-1.53106),(-.92588,52.99055,-1.45976),(-.7916,52.98917,-1.49994),(-.77121,53.04728,-1.44938),(-.81481,53.03582,-1.43428),(-.70278,53.10414,-1.29264),(-.6456,53.06607,-1.40583),(-.54628,53.07211,-1.36743),(-.57706,53.04761,-1.45043),(-.52156,53.03551,-1.49204),(-.51136,53.00319,-1.52516),(-.45918,52.98332,-1.54578),(-.9144,52.99317,-1.45754),(-.90314,52.9184,-1.5239),(-.83282,52.98116,-1.50806),(-.4304,52.92897,-1.6243),(-.46048,52.90837,-1.65549),(-.40497,52.92388,-1.69372),(-.17189,52.97504,-1.93006),(-.21406,52.98025,-1.87144),(-.18408,52.96044,-1.96806),(-.01273,52.97146,-2.11887),(0,52.99791,-2.12516),(0,53.02356,-2.04228),(-.115,52.92333,-2.5631),(-.06678,52.94883,-2.51002),(-.10071,52.91497,-2.52591),(-.14901,53.02777,-2.39936),(-.15758,53.08155,-2.404),(-.18846,53.05486,-2.49017),(-.12876,53.14354,-2.41212),(-.17827,53.12853,-2.49164),(-.13122,53.0972,-2.33194),(-.1103,53.03669,-2.331),(-.05113,52.99709,-2.2344),(-.12434,53.18552,-2.14528),(-.11546,53.16895,-2.24937),(-.13804,53.10409,-2.23452),(-.21596,53.15803,-2.02983),(-.16086,53.12019,-2.14684),(-.23041,53.11522,-2.02943),(-.06238,53.26434,-2.05041),(-.10151,53.30064,-1.95936),(-.06359,53.31514,-1.95633),(-.38718,53.2643,-1.71014),(-.31336,53.20437,-1.83468),(-.39032,53.22444,-1.71482),(-.4155,53.35963,-1.60671),(-.47008,53.31047,-1.60636),(-.44523,53.37604,-1.55407),(-.48335,53.25096,-1.62118),(-.40391,53.07704,-1.7623),(-.40849,53.17219,-1.73514),(-.32854,53.16528,-1.8386),(-.47598,52.97892,-1.73949),(-.51516,52.96693,-1.71896),(-.47676,53.06705,-1.69398),(-.48614,53.16161,-1.6571),(-.54145,53.27766,-1.58449),(-.70945,53.14099,-1.63172),(-.71317,53.17878,-1.61613),(-.64421,53.15389,-1.65483),(-.62191,53.30132,-1.53227),(-.72615,53.25046,-1.56337),(-.71542,53.28666,-1.50469),(-.51238,53.37448,-1.47063),(-.52015,53.33341,-1.54045),(-.56592,53.34492,-1.48472),(-.49257,53.41489,-1.43541),(-.49935,53.44898,-1.41087),(-.50153,53.50745,-1.34444),(-.58671,53.50848,-1.30988),(-.55995,53.54803,-1.26906),(-.63685,53.56841,-1.20616),(-.65296,53.53466,-1.27201),(-.6939,53.52298,-1.256),(-.85394,53.3719,-1.39416),(-.91456,53.42468,-1.28567),(-.78932,53.42979,-1.35186),(-.85596,53.35705,-1.38828),(-.79052,53.30586,-1.46477),(-.80488,53.26598,-1.49878),(-.87481,53.15064,-1.51635),(-.87056,53.21465,-1.47282),(-.80599,53.20126,-1.54382),(-.26815,53.13933,-.83521),(-.2831,53.13034,-.81109),(-.22042,53.10719,-.77752),(-.10699,53.10548,-.80459),(-.11742,53.08832,-.74756),(-.33064,53.16511,-.87897),(-.25736,53.1568,-.87864),(-.3128,53.19322,-.92088),(-.07405,53.24014,-1.15025),(-.08072,53.198,-1.07359),(-.40999,53.32432,-.86741),(-.61729,53.17815,-1.09955),(-.696,53.15044,-1.12496),(-.69407,53.14311,-1.10091),(-.28231,53.34234,-1.23852),(-.33707,53.24211,-1.28651),(-.28323,53.34256,-1.23836),(-.60588,53.1532,-1.097),(-.56094,53.16901,-1.06294),(-.96349,53.19238,-1.14722),(-.94315,53.16067,-1.1756),(-.97514,53.148,-1.16268),(-.86839,53.07427,-1.11783),(-.85052,53.06063,-1.13658),(-.82649,53.04033,-1.0972),(-.64668,53.16242,-.92968),(-.65701,53.19298,-.90375),(-.60186,53.19437,-.92857),(-.65037,53.54304,-1.1792),(-.63432,53.56711,-1.20226),(-.72335,53.56813,-1.14916),(-.43272,53.40633,-1.40948),(-.43773,53.45548,-1.41775),(-.55902,53.54778,-1.26327),(-.58283,53.52316,-1.22722),(-.55001,53.34951,-1.27628),(-.5405,53.42829,-1.27332),(-.6008,53.43555,-1.2282),(-.76901,53.09855,-1.189),(-.75045,53.1591,-1.18336),(-.74757,53.12926,-1.16903),(-.39457,52.78004,-1.03293),(-.38887,52.86705,-1.09141),(-.30922,53.09897,-1.32027),(-.23851,53.03241,-1.32924),(-.31827,53.02339,-1.32703),(-.39601,53.07886,-1.31381),(-.42816,53.04993,-1.30606),(-.35708,53.31384,-1.59853),(-.51375,53.13973,-1.34739),(-.49568,53.14987,-1.38505),(-.34146,53.15564,-.8418),(-.27922,53.29767,-1.13298),(-.33954,53.34341,-1.12019),(-.37127,53.3544,-1.02729),(-.40147,53.32437,-.86917),(-.35785,53.24487,-.89485),(-.36218,53.30003,-.9224),(-.68194,53.20139,-.84844),(-.70086,53.18497,-.88089),(-.75295,53.16124,-.87655),(-.17735,52.96452,-2.61858),(-.18508,52.92704,-2.58072),(-.20241,52.97146,-2.5812),(-.19127,52.90794,-2.53198),(-.10244,53.0481,-2.23097),(-.12366,52.96444,-2.4258),(-.06109,52.98255,-2.33373),(-.06728,52.97145,-2.03136),(-.13456,52.94679,-2.03704),(-.26906,52.97311,-1.79203),(-.29563,52.92949,-1.80571),(-.16571,53.21856,-2.03811),(-.13422,53.23251,-2.04185),(-.06075,53.18044,-2.39401),(-.08919,53.16544,-2.46646),(-.63504,53.12728,-1.16318),(-.56936,53.05788,-1.21286),(-.69244,53.00498,-1.01913),(-.66992,53.01567,-.9922),(-.71929,52.99157,-1.05408),(-.51148,53.03848,-1.14486),(-.49441,53.02605,-1.06663),(-.52622,53.10677,-1.0419),(-.71413,53.11497,-1.2489),(-.7063,53.16233,-1.21324),(-.70296,53.12849,-1.14368),(-.74475,53.1478,-1.15216),(-.54746,53.16996,-1.01714),(-.55297,53.08767,-1.01369),(-.66418,53.10986,-.94681),(-.63038,53.127,-.94987),(-.61445,53.04591,-.96971),(-.73136,53.08148,-1.07611),(-.74556,53.09858,-1.0641),(-.74206,53.05901,-1.00712),(-.6806,53.12364,-1.10806),(-.66601,53.10229,-1.11374),(-.59979,52.9563,-.9932),(-.67786,53.06242,-.97783),(-.69948,53.0989,-.95007),(-.70209,53.04679,-.99284),(-.73562,53.16655,-1.20433),(-.72151,53.18435,-1.19897),(-.74692,53.19054,-1.18846),(-.67687,53.13704,-1.16083),(-.66285,53.15946,-1.14486),(-.68507,53.13626,-1.20468),(-.49677,53.01991,-1.17367),(-.45716,53.01064,-1.23609),(-.45212,52.97487,-1.15724),(-.47573,53.00336,-1.15023),(-.79352,53.13002,-1.3333),(-.60053,53.37368,-1.42451),(-.6154,53.33031,-1.49081),(-.6426,53.36135,-1.44157),(-.5439,53.15996,-1.65163),(-.54382,53.19632,-1.62927),(-.14602,53.1553,-2.47672),(-.11763,53.15043,-2.53892),(-.17055,53.15145,-2.53923),(-.13189,52.93144,-2.60114),(-.3821,52.99206,-1.6572),(-.39472,52.96087,-1.67605),(-.34152,52.96054,-1.71834),(-.20633,53.01478,-1.84946),(-.26219,53.0097,-1.77896),(-.08187,52.98906,-1.96019),(-.01551,53.03897,-1.98107),(-.10046,53.02281,-1.92737),(-.13292,53.07624,-1.88183),(-.1509,53.01784,-1.89413),(-.63701,52.96741,-1.70234),(-.52363,52.86527,-1.66633),(-.51782,53.03646,-1.19711),(-.51923,53.03536,-1.24784),(-.52201,53.24835,-.9464),(-.48586,53.27118,-.91723),(-.503,53.31098,-.95233),(-.21705,53.25967,-1.1488),(-.28214,53.34205,-1.22734),(-.53741,53.04326,-.92628),(-.21855,53.3154,-1.77425),(-.29864,53.34305,-1.66992),(-.29005,53.30524,-1.68716),(-.4966,53.50615,-1.33956),(-.89342,53.48965,-1.22421),(-.89474,53.48604,-1.21769),(-.82032,53.54276,-1.17104),(-.53126,52.85532,-1.65447),(-.51057,52.8649,-1.65812),(-.44316,52.92928,-1.61973),(-.87628,53.06196,-1.38202),(-.13142,53.38115,-1.80373),(-.24108,53.38118,-1.75372),(-.13599,53.32782,-1.8194),(-.3122,53.40022,-1.66782),(-.31463,53.40097,-1.66963),(-.36289,53.41366,-1.59287),(-.34045,53.17372,-.88216),(-.32465,53.20032,-.91795),(-.91985,53.39573,-1.22607),(-.90778,53.36524,-1.17478),(-.86756,53.42696,-1.1532),(-.92363,53.11398,-1.09414),(-.86236,53.12215,-1.19291),(-.84948,53.14158,-1.21611),(-.76965,53.10824,-1.21928),(-.91768,53.23976,-1.15086),(-.91294,53.1826,-1.20732),(-1.03574,53.11094,-1.13012),(-.68751,53.25492,-1.19797),(-.91633,53.28399,-1.15793),(-.91766,53.23962,-1.13549),(-.57449,53.30582,-1.16516),(-.59104,53.2982,-1.22184),(-.56587,53.22711,-1.08748),(-.57017,53.21623,-1.03984),(-.55209,53.24422,-1.03254),(-.90363,53.34022,-1.12956),(-.6728,53.09681,-1.18194),(-.45732,53.09985,-1.32355),(-.42104,53.14266,-1.32655),(-.41005,53.42708,-1.51058),(-.37134,53.41498,-1.57228),(-.35412,53.15212,-.83841),(-.35161,53.16705,-.84677),(-.37822,53.24605,-.85742),(-.38299,53.2436,-.84844),(-.3377,53.37032,-1.16532),(-.39327,53.39858,-1.10352),(-.36161,53.15791,-1.31412),(-.50796,53.17181,-.8933),(-.46401,53.10572,-.90675),(-.57181,53.06438,-1.31644),(-.61831,53.07683,-1.31656),(-.35818,52.73503,-.97271),(-.33492,52.73679,-.99392),(-.36529,52.77242,-1.03181),(-.31179,52.82444,-1.0999),(-.2935,53.2683,-1.06229),(-.29862,53.24757,-1.00686),(-.28831,53.2389,-1.00933),(-.05251,53.09216,-1.92385),(-.06186,53.2361,-2.14764),(-.41254,52.98489,-1.60331),(-.53465,53.07633,-1.36429),(-.5654,52.99894,-1.01519),(-.47748,52.96934,-1.07075),(-.24416,53.38239,-1.75873),(-.19275,53.3042,-1.88849),(-.237,53.2643,-1.90743),(-.08177,53.35805,-1.88657),(0,53.36783,-1.90074),(0,53.33806,-1.96691),(-.05755,53.16497,-1.89428),(-.06284,53.33016,-1.83426),(-.06395,53.26445,-1.85644),(0,53.26641,-1.86391),(-.32451,52.92932,-1.35102),(-.2838,52.7019,-.9288),(-.23878,52.87319,-1.36515),(-.577,53.07954,-1.15003),(-.5821,53.11252,-1.12264),(-.65832,53.08944,-1.12611),(-.66656,53.09241,-1.28181),(-.54377,53.24143,-.97855),(-.52925,53.27139,-1.02676),(-.8545,53.39179,-1.13913),(-.82826,53.47134,-1.1278),(-.28416,53.34333,-1.23774),(-.59851,53.13726,-.95362),(-.28591,53.12597,-.80271),(-.41962,53.43229,-1.49293),(-.46231,53.38602,-1.53319),(-.5147,53.32443,-1.54141),(-.82231,53.51072,-1.14573),(-.87982,53.45362,-1.1823),(-.71444,53.21292,-1.18616),(-.68523,53.20923,-1.19494),(-.64782,53.25641,-1.18884),(-.50562,53.32277,-1.2087),(-.55614,53.21076,-.99278),(-.39651,53.36712,-1.19089),(-.44674,53.35609,-1.19918),(-.43319,53.39599,-1.11529),(-1.05288,53.17865,-1.09735),(-1.03746,53.13455,-1.09671),(-.97614,53.12144,-1.09224),(-.91355,53.27949,-1.13657),(-.89265,53.22965,-1.13694),(-.75288,53.21705,-1.17508),(-.63675,53.3212,-1.24015),(-.55124,53.31431,-1.25895),(-.97922,53.20918,-1.1226),(-.86646,53.33138,-1.14868),(-.90117,53.20905,-1.25784),(-.64846,53.22308,-1.61587),(-.14127,53.38409,-1.80745),(-.07508,53.38759,-1.8181),(-.71413,52.86357,-1.64372),(-.72036,52.85123,-1.62623),(-.83438,52.87013,-1.58809),(-.79811,53.12827,-1.34387),(-.91857,53.41917,-1.27617),(-.7244,53.56922,-1.15479),(-.81895,53.54362,-1.1765),(-.55468,53.54744,-1.26606),(-.57315,53.183,-.86547),(-.5713,53.17048,-.86404),(-.53912,53.17193,-.88739),(-.73998,53.04893,-1.13067),(-.66486,53.1181,-1.14705),(-.73139,53.03951,-1.10403),(-.78228,53.00895,-1.09312),(-.8002,53.03649,-1.05824),(-.81547,53.08832,-1.06187),(-.8229,53.06894,-1.08613),(-.78067,53.13188,-1.10036),(-.24698,52.88533,-1.27766),(-.49403,52.89104,-1.6884),(-.01523,53.0057,-2.02959),(-.2074,52.99038,-2.49105),(-.22606,53.05614,-2.56871),(-.05881,53.17609,-2.45636),(-.70381,53.34566,-1.47171),(-.58424,53.44687,-1.36616),(-.54015,53.47898,-1.35475),(-.66658,53.51186,-1.28326),(-.7154,53.48468,-1.28655),(-.81398,53.1693,-1.26272),(-.74858,53.05835,-1.1573),(-.71478,53.08463,-1.16507),(-.40215,52.93968,-1.1666),(-.41667,52.90888,-1.08595),(-.69611,53.17816,-1.20948),(-.67209,53.1696,-1.18129),(-.66508,53.20063,-1.16229),(-.75144,53.17274,-1.16911),(-.74625,52.96108,-1.03981),(-.52877,53.10973,-1.10236),(-.63986,53.20108,-1.12654),(-.76999,53.18246,-1.15235),(-.76003,53.10229,-1.06042),(-.7647,53.121,-.92656),(-.72211,53.08235,-.96144),(-.57008,53.19479,-.95007),(-.56516,53.15399,-.97671),(-.73015,53.03866,-1.02301),(-.06308,53.17965,-2.33361),(0,53.20174,-2.3738),(-.16416,53.04447,-2.13541),(-.10681,53.11709,-2.56912),(0,53.08985,-2.52503),(-.06649,52.93831,-2.45968),(-.42529,53.39567,-.97038),(-.42396,53.3755,-.91679),(-.23666,53.18125,-.95379),(-.42217,53.2331,-1.30155),(-.48646,53.29737,-1.29766),(-.35987,53.25544,-1.62098),(-.34816,53.16557,-1.64104),(-.28006,53.16685,-1.74633),(-.42621,53.25937,-1.45282),(-.42866,53.16863,-1.49944),(-.76692,52.99911,-.96726),(-.69602,52.88397,-.96906),(-.73164,52.93555,-.89782),(-.44707,52.93911,-1.07831),(-.47953,52.94532,-1.0149),(-.08011,52.70503,-.87292),(-.0948,52.73676,-.85164),(-.20249,52.72353,-.85907),(-.91352,53.27553,-1.2192),(0,53.1458,-2.44933),(-1.05698,53.16505,-1.10578),(-.33621,53.33319,-1.24719),(-.76531,53.14226,-1.12495),(-.36988,53.07337,-1.6187),(-.4019,53.40007,-1.11248),(-.34303,53.3717,-1.17501),(-.06749,53.28112,-1.22642),(-.14389,53.24168,-1.15108),(-.15178,53.20958,-1.07081),(-.32668,53.30502,-1.04111),(-.16789,53.16691,-.95307),(-.09492,53.13758,-.88011),(-.08594,53.16672,-.94971),(-.21318,53.12547,-.80529),(-.43882,52.92005,-1.71587),(-.38079,52.92956,-1.76411),(-.90799,53.28762,-1.29095),(-.88878,53.22518,-1.38248),(-.90422,53.29028,-1.34724),(-.85416,53.28355,-1.4336),(-.6227,53.31407,-1.5326),(-.71012,52.96096,-1.66833),(-.83971,52.8756,-1.59732),(-.77963,53.40242,-1.38056),(-.74564,53.37391,-1.43111),(-.77366,53.46567,-1.29787),(-.33987,53.08619,-1.86375),(-.31762,52.9909,-1.89634),(-.40826,52.98604,-1.79757),(-.359,53.33314,-1.69056),(0,53.25369,-2.14894),(-.26685,53.17807,-1.94395),(-.26539,53.01904,-1.98261),(-.11584,53.14719,-2.33036),(-.18147,53.14941,-2.57318),(-.15907,53.01884,-2.62586),(-.26101,53.07084,-1.76577),(-.32841,53.06472,-1.6795),(-.46481,53.15951,-1.43819),(-.58609,53.02289,-1.49798),(-.62222,53.07615,-1.3271),(-.83647,53.16313,-1.34902),(-.89243,53.22555,-1.32535),(-.09277,52.86324,-1.26288),(-.1696,52.85405,-1.16916),(-.16547,52.87833,-1.27333),(-.09585,52.85037,-1.16501),(-.40471,53.08976,-.89562),(-.10679,52.79565,-.84991),(-.11453,52.87009,-.83069),(-.29459,52.7396,-.88307),(-.2874,52.89949,-.8664),(-.35538,52.84646,-.89803),(-.73285,53.54239,-1.13627),(-.80726,53.32232,-1.1759),(-.91607,53.16541,-1.1096),(-.09362,52.73296,-.95158),(-.39878,53.0114,-.92272),(-.46121,53.03202,-.93198),(-.72688,53.15349,-.78788),(-.71779,53.13775,-.91751),(-.33666,52.8262,-1.10161),(-.24581,52.89329,-1.38542),(-.16726,53.02348,-1.3139),(-.17051,52.92878,-1.36594),(-.80141,53.01801,-1.12332),(-.61898,53.0732,-1.27351),(-.44358,53.33025,-1.3809),(-.45028,53.25243,-1.41027),(-.41349,53.06554,-1.5675),(-.29067,53.16892,-1.29628),(.06109,52.98255,-2.33368),(.42868,53.32603,-1.42115),(.40532,53.31645,-1.51929),(.48646,53.29737,-1.29749),(.47943,53.33214,-1.32558),(.67383,53.11061,-1.21193),(.60801,53.07387,-1.22606),(.40215,52.93968,-1.16595),(.40729,52.96404,-1.24056),(.75615,53.11932,-1.24956),(.72004,52.91766,-1.0252),(.68255,52.88443,-1.01497),(.53958,52.93517,-1.02306),(.37237,52.92483,-1.24818),(.31827,53.02339,-1.32659),(.31409,52.86875,-1.18565),(.34956,52.87774,-1.18609),(.35959,52.76794,-.91166),(.8178,53.03413,-1.14875),(.63726,52.89628,-1.00669),(.64399,52.89605,-.98324),(.53628,52.99284,-.95647),(.61375,53.16949,-.83051),(.66896,53.16652,-.81312),(.53632,53.11702,-.89395),(.50553,53.11281,-.90115),(.50586,53.03606,-.94187),(.34058,52.92503,-.88413),(.29459,52.76246,-.86214),(.35818,52.7427,-.96226),(.16664,52.72414,-.90696),(.27045,52.76335,-.96452),(.7876,53.07337,-1.03469),(.77384,53.01145,-1.01197),(.81519,53.14421,-1.12464),(.77233,53.06229,-.91494),(.7647,53.121,-.92612),(.79573,53.39017,-1.16196),(.70594,53.37513,-1.20423),(.62481,53.36,-1.24722),(.65989,53.2882,-1.2334),(.46138,53.40024,-1.03629),(.58626,53.24777,-1.10976),(.4208,53.16356,-.86281),(.28909,52.97535,-.85339),(.0948,52.76029,-.83476),(0,52.82119,-.84119),(.10877,52.94401,-.80124),(.21247,52.96103,-.82232),(.48937,53.4153,-1.31195),(.53718,53.50012,-1.26729),(.60017,53.20665,-.90098),(.75077,53.07369,-1.39532),(.83647,53.16313,-1.34862),(.54628,53.07211,-1.36684),(.49849,53.0575,-1.44902),(.45918,52.98332,-1.54513),(.78975,52.94634,-1.5483),(.40497,52.92388,-1.69307),(.46048,52.90837,-1.65474),(.17189,52.97504,-1.92983),(.18408,52.96044,-1.96781),(.01523,53.0057,-2.02957),(.15907,53.01884,-2.62581),(.18147,53.14941,-2.57318),(.10681,53.11709,-2.56911),(.22606,53.05614,-2.56865),(.26539,53.01904,-1.98231),(.21128,53.24302,-1.95832),(.237,53.2643,-1.90734),(.26685,53.17807,-1.94379),(.06186,53.2361,-2.14762),(0,53.29584,-2.0512),(.4155,53.35963,-1.60665),(.33987,53.08619,-1.86342),(.40826,52.98604,-1.79703),(.31762,52.9909,-1.89593),(.54145,53.27766,-1.58431),(.48335,53.25096,-1.62096),(.58671,53.50848,-1.30988),(.77366,53.46567,-1.29787),(.91456,53.42468,-1.28567),(.74564,53.37391,-1.43111),(.71012,52.96096,-1.66746),(.83971,52.8756,-1.59616),(.71413,52.86357,-1.64261),(.6227,53.31407,-1.53249),(.70381,53.34566,-1.47169),(.87056,53.21465,-1.4726),(.91352,53.27553,-1.21917),(.90799,53.28762,-1.29093),(.10699,53.10548,-.80449),(.08072,53.198,-1.07353),(.15178,53.20958,-1.0707),(.14389,53.24168,-1.15098),(.06749,53.28112,-1.22639),(.14317,53.29491,-1.22871),(.3821,52.99206,-1.65666),(.39651,53.36712,-1.19083),(.81547,53.08832,-1.06131),(.05881,53.17609,-2.45635),(.18429,52.72411,-.87202),(.20249,52.75643,-.83485),(.44707,52.93911,-1.07762),(.76692,52.99911,-.9665),(.73164,52.93555,-.89694),(.69602,52.88397,-.96806),(.35317,52.97391,-1.32421),(.34578,52.89673,-1.26725),(.38915,53.16917,-1.56631),(.34816,53.16557,-1.64075),(.28193,53.24455,-1.71567),(.28006,53.16685,-1.74611),(.44747,53.30042,-1.25854),(.29111,53.21377,-.95799),(.23666,53.18125,-.95361),(.46121,53.03202,-.93145),(.68194,53.20139,-.8482),(.65701,53.19298,-.90347),(.14548,52.97514,-2.61336),(.10071,52.91497,-2.52583),(.16416,53.04447,-2.13526),(.16086,53.12019,-2.14674),(0,53.20965,-2.31864),(.06308,53.17965,-2.33359),(.65832,53.08944,-1.12553),(.73139,53.03951,-1.10333),(.7063,53.16233,-1.21281),(.68208,53.15001,-.92045),(.76999,53.18246,-1.152),(.66508,53.20063,-1.16195),(.63986,53.20108,-1.12621),(.52877,53.10973,-1.10187),(.56094,53.16901,-1.06256),(.63038,53.127,-.94942),(.74625,52.96108,-1.03893),(.56587,53.22711,-1.08721),(.52925,53.27139,-1.02658),(.69611,53.17816,-1.20909),(.84948,53.14158,-1.21567),(.45212,52.97487,-1.15658),(.54694,53.07186,-1.35367),(.57181,53.06438,-1.31582),(.72849,52.9242,-1.01298),(.66658,53.51186,-1.28326),(.65296,53.53466,-1.27201),(.74657,53.50617,-1.26222),(.7154,53.48468,-1.28655),(.58424,53.44687,-1.36616),(.5607,53.42009,-1.39656),(.49935,53.44898,-1.41087),(.6426,53.36135,-1.44155),(.32605,52.934,-1.81694),(.38079,52.92956,-1.76352),(.8002,53.03649,-1.05754),(.78228,53.00895,-1.09234),(.53912,53.17193,-.88707),(.5713,53.17048,-.86373),(.57315,53.183,-.86518),(.44523,53.37604,-1.55403),(.5147,53.32443,-1.5413),(.72036,52.85123,-1.62508),(.92588,52.99055,-1.45891),(.14127,53.38409,-1.80744),(.12807,53.34184,-1.88115),(.08177,53.35805,-1.88657),(.8545,53.39179,-1.13913),(.86646,53.33138,-1.14868),(.91985,53.39573,-1.22607),(.90276,53.14141,-1.18381),(.89265,53.22965,-1.13679),(.90309,53.20035,-1.12389),(.68751,53.25492,-1.19775),(.71444,53.21292,-1.18585),(.85468,53.18955,-1.13414),(1.03746,53.13455,-1.09643),(.44674,53.35609,-1.19911),(.43319,53.39599,-1.11529),(.54377,53.24143,-.97833),(.55614,53.21076,-.9925),(.57017,53.21623,-1.03956),(.50562,53.32277,-1.20858),(.64782,53.25641,-1.18862),(.34146,53.15564,-.84155),(.42217,53.2331,-1.30129),(.38827,53.32306,-1.25651),(.28231,53.34234,-1.23843),(.52456,53.25647,-.97453),(.55209,53.24422,-1.03231),(.71205,53.1162,-1.1551),(.23878,52.87319,-1.36468),(.06284,53.33016,-1.83424),(.05251,53.09216,-1.9238),(.05755,53.16497,-1.89423),(0,53.39351,-1.81875),(0,53.38998,-1.81507),(.05933,53.38487,-1.81611),(.24416,53.38239,-1.75871),(.28064,53.2945,-1.81094),(.33707,53.24211,-1.2863),(.29123,53.23612,-1.27193),(.19275,53.3042,-1.88844),(.13142,53.38115,-1.80372),(.07508,53.38759,-1.8181),(.06359,53.31514,-1.95632),(0,53.16345,-1.90923),(0,53.32994,-1.83225),(.28024,52.87944,-1.32275),(.47119,53.24398,-.88897),(.34303,53.3717,-1.17495),(.38043,53.24355,-1.2934),(.68523,53.20923,-1.19462),(.90226,53.27955,-1.13258),(.85052,53.06063,-1.13593),(.90363,53.34022,-1.12956),(1.05698,53.16505,-1.10562),(.54932,53.19252,-.89272),(.24698,52.88533,-1.27719),(.30503,52.88555,-1.27411),(.43882,52.92005,-1.71517),(.07587,52.98992,-2.55884),(.17827,53.12853,-2.49161),(.73145,53.43521,-1.34109),(.58371,53.06679,-.99114),(.72211,53.08235,-.96089),(.71779,53.13775,-.91711),(.06075,53.18044,-2.394),(.1857,53.10097,-2.61242),(.70086,53.18497,-.88061),(.42621,53.25937,-1.4526),(.08011,52.7253,-.85848),(0,53.27612,-1.22111),(.32668,53.30502,-1.04099),(.90422,53.29028,-1.34722),(.71399,53.30824,-1.50863),(.359,53.33314,-1.69048),(.8304,52.9607,-1.60385),(.31336,53.20437,-1.83449),(.22405,53.02215,-2.03833),(.22662,53.11179,-2.58002),(.06678,52.94883,-2.50997),(.51136,53.00319,-1.52448),(.90042,52.97886,-1.53635),(.91417,53.08273,-1.44262),(.11453,52.88989,-.82164),(0,52.74661,-.85321),(.26755,52.7256,-.93886),(.2838,52.72505,-.90842),(.71038,53.0788,-.81431),(.75263,53.08826,-.81072),(.72688,53.15349,-.78758),(.33492,52.74602,-.98313),(.24955,52.93801,-1.36169),(-.38915,53.16917,-1.56663),(-.40729,52.96404,-1.24119),(-.24955,52.93801,-1.36212),(-.50259,52.98367,-.96014),(-.40212,52.94181,-.92401),(-.07606,52.70527,-.90499),(-.80402,53.26336,-1.17146),(-.76994,53.46532,-1.14357),(-.52456,53.25647,-.97472),(-.35006,53.06339,-.86906),(-.45769,53.4127,-1.35648),(-.44502,53.05873,-1.51106),(-.36651,52.91916,-1.72864),(-.33831,52.99616,-1.70791),(-.22662,53.11179,-2.58004),(-.1857,53.10097,-2.61243),(-.22405,53.02215,-2.03857),(-.21128,53.24302,-1.95841),(-.78703,53.32185,-1.46669),(-.8304,52.9607,-1.60477),(-.71399,53.30824,-1.50871),(-.18906,53.14843,-.87816),(-.18429,52.69182,-.8946),(-.72849,52.9242,-1.01393),(-.28193,53.24455,-1.71583),(-.44747,53.30042,-1.25871),(-.5171,53.23524,-.91732),(-.29111,53.21377,-.95817),(-.14548,52.97514,-2.61343),(-.58371,53.06679,-.9917),(-.73145,53.43521,-1.34109),(-.74657,53.50617,-1.26222),(-.5607,53.42009,-1.39656),(-.07587,52.98992,-2.55888),(-.32605,52.934,-1.81744),(-.54932,53.19252,-.89301),(-.12807,53.34184,-1.88117),(-.90276,53.14141,-1.18422),(-.90309,53.20035,-1.12411),(-.90226,53.27955,-1.1326),(-.98447,53.17203,-1.10345),(-.28064,53.2945,-1.81103),(-.58626,53.24777,-1.11),(-.76646,53.12443,-.8667),(-.31974,53.20658,-.9274),(-1.05113,53.14938,-1.1249),(-.56473,53.0427,-.90978),(-.2107,53.32332,-1.22576),(-.65615,52.86245,-1.66797),(-.64592,53.0536,-.97506),(-.73066,53.14635,-1.12496),(-.23926,52.94539,-1.90387),(-.08913,53.05148,-2.57507),(-.75166,53.16155,-.84066),(-.41529,53.37423,-.91777),(-.30215,53.22333,-.95587),(-.32718,53.25397,-.94104),(-.38043,53.24355,-1.29363),(-.23776,53.10403,-1.30412),(-.69285,52.94439,-.89527),(-.29123,53.23612,-1.27213),(-.53926,53.39733,-1.42226),(-.80605,53.1341,-1.57536),(-.54522,53.06658,-1.68823),(-.08869,52.97864,-2.13311),(-.83354,53.00328,-1.47554),(-.10115,52.82594,-1.08732),(-.71038,53.0788,-.8148),(-.75263,53.08826,-.81119),(-.68255,52.88443,-1.01598),(.29067,53.16892,-1.29602),(.75295,53.16124,-.87623),(.80402,53.26336,-1.17133),(.76994,53.46532,-1.14357),(.503,53.31098,-.95223),(.22393,53.10012,-.76177),(.64627,52.96665,-1.55086),(.44502,53.05873,-1.51053),(.36651,52.91916,-1.72804),(.21596,53.15803,-2.02969),(.23041,53.11522,-2.02925),(.10151,53.30064,-1.95934),(.54522,53.06658,-1.68768),(.72615,53.25046,-1.56316),(.53926,53.39733,-1.42225),(.42396,53.3755,-.91679),(.69285,52.94439,-.89444),(.41529,53.37423,-.91777),(.08913,53.05148,-2.57504),(.56516,53.15399,-.97633),(.67786,53.06242,-.97723),(.3122,53.40022,-1.66781),(.39327,53.39858,-1.10351),(.76646,53.12443,-.8663),(.17123,53.26616,-1.96),(.22179,53.22791,-1.07532),(.0981,52.85321,-1.36622),(0,52.87177,-1.38207),(.0996,52.87315,-1.38236),(0,52.85109,-1.36323),(.56398,53.20806,-.92725),(.64874,53.02286,-.86081),(.65953,53.0948,-.82847),(.69449,53.01108,-.84564),(0,53.06325,-.74243),(.12028,53.08142,-.73181),(.41669,53.39432,-.97016),(.42529,53.39567,-.97038),(.06745,53.28141,-1.23741),(.14338,53.29543,-1.23966),(.41793,53.38116,-1.49732),(.86105,53.26827,-1.15048),(.85271,53.21996,-1.15006),(.80544,53.17753,-1.14404),(.56617,53.11416,-.87654),(.3327,53.28516,-.98693),(.36673,53.32722,-.97476),(.15983,53.18824,-1.01183),(.08594,53.16672,-.94964),(.16789,53.16691,-.95293),(.08364,53.18044,-1.00809),(.66924,53.38222,-1.41313),(.62159,53.39428,-1.39947),(.64361,53.42081,-1.36795),(.67596,53.45334,-1.32601),(.62184,53.482,-1.31728),(.89004,53.07824,-1.53537),(.8193,53.0632,-1.60027),(.60698,53.00029,-.98087),(.57008,53.19479,-.94976),(.42261,53.4056,-1.02996),(.4019,53.40007,-1.11247),(.21102,53.25248,-1.78995),(.13727,53.1636,-1.85665),(.21572,53.16252,-1.81605),(.23683,53.17468,-1.27945),(.15318,53.22577,-1.25522),(.15796,53.1587,-1.27599),(.22903,53.2428,-1.25771),(.37534,52.90626,-1.16848),(0,53.27681,-1.23215),(.07242,53.20746,-1.25389),(0,53.20323,-1.2561),(.41388,53.40434,-1.02955),(.22968,53.20155,-1.00747),(0,53.13141,-.87361),(.09492,53.13758,-.88002),(0,53.15911,-.95081),(.18906,53.14843,-.878),(.70212,53.40834,-1.37517),(.64598,53.06455,-1.68217),(0,53.22639,-2.24206),(.06388,53.2041,-2.2468),(.28145,53.09818,-1.96499),(.20575,53.07468,-1.83292),(.69416,53.03307,-1.46775),(.09585,52.8515,-1.1638),(.10115,52.83373,-1.08766),(0,52.84785,-1.16286),(.09362,52.7537,-.93944),(.11051,52.80448,-1.00732),(0,52.74906,-.95438),(.16547,52.87833,-1.27301),(.11104,52.99355,-.78467),(0,52.98449,-.78608),(.68156,53.4527,-1.18625),(.6451,52.95844,-.90668),(.75166,53.16155,-.84036),(.74415,53.00135,-.84626),(0,52.91823,-1.36509),(.09575,53.01378,-1.31478),(.09979,52.91831,-1.36011),(0,53.01461,-1.32559),(0,52.71713,-.87425),(-.57483,53.05676,-1.26111),(-.0996,52.87315,-1.38256),(-.09979,52.91831,-1.36029),(-.74415,53.00135,-.84695),(-.65953,53.0948,-.82894),(-.68156,53.4527,-1.18625),(-.10877,52.93037,-.80278),(-.21247,52.94922,-.82347),(-.21474,53.00751,-.80484),(-.28769,53.0309,-.84057),(-.12028,53.08135,-.73182),(-.11104,52.98522,-.78192),(-.22393,53.10012,-.76198),(-.0981,52.85321,-1.36643),(-.17002,52.86192,-1.37411),(-.17619,52.83396,-1.08813),(-.18186,52.78206,-1.00905),(0,52.86097,-1.25713),(-.71559,52.97801,-1.52443),(-.69416,53.03307,-1.46849),(-.53283,52.9584,-1.58159),(-.57513,52.92911,-1.59885),(-.66852,52.91468,-1.60323),(-.65847,52.84681,-1.65165),(-.72848,52.91244,-1.58035),(-.21572,53.16252,-1.81622),(-.20575,53.07468,-1.83314),(0,52.99081,-2.43204),(0,53.04592,-2.52094),(-.28145,53.09818,-1.96524),(-.64598,53.06455,-1.68278),(-.70212,53.40834,-1.37517),(-.67596,53.45334,-1.32601),(-.64361,53.42081,-1.36795),(-.22179,53.22791,-1.07547),(-.22968,53.20155,-1.00764),(-.41388,53.40434,-1.02955),(-.14317,53.29491,-1.22878),(-.14338,53.29543,-1.23973),(-.22903,53.2428,-1.25786),(-.2109,53.32411,-1.2367),(-.15318,53.22577,-1.25533),(-.79997,53.21933,-1.16332),(-.80544,53.17753,-1.1444),(-.37534,52.90626,-1.16914),(-.23683,53.17468,-1.27967),(-.15796,53.1587,-1.27615),(-.13727,53.1636,-1.85676),(-.21102,53.25248,-1.79006),(-.14018,53.25866,-1.83072),(-.56398,53.20806,-.92752),(-.71205,53.1162,-1.15563),(-.60698,53.00029,-.98158),(-.89004,53.07824,-1.53597),(-.8193,53.0632,-1.60091),(-.62184,53.482,-1.31728),(-.62159,53.39428,-1.39947),(-.66924,53.38222,-1.41313),(-.15983,53.18824,-1.01195),(-.08364,53.18044,-1.00816),(-.3327,53.28516,-.98706),(-.36673,53.32722,-.97484),(-.56617,53.11416,-.87697),(-.85271,53.21996,-1.15027),(-.85468,53.18955,-1.13443),(-.42261,53.4056,-1.02996),(-.69449,53.01108,-.8463),(-.171,52.88125,-1.38947),(-.05933,53.38487,-1.81612),(-.17123,53.26616,-1.96006),(0,52.99408,-2.47977),(-.6451,52.95844,-.90746),(-.59931,52.97316,-.92516),(-.86105,53.26827,-1.15055),(-.41793,53.38116,-1.49735),(0,53.17658,-1.00867),(-.71065,53.06005,-1.65849),(-.63845,53.00798,-.98689),(-.06388,53.2041,-2.24682),(-.68208,53.15001,-.92083),(-.16265,53.09129,-1.29478),(-.07242,53.20746,-1.25395),(0,53.14243,-1.27604),(-.08016,53.1432,-1.27561),(-.78975,52.94634,-1.54926),(-.64627,52.96665,-1.55171),(0,52.87822,-.83047),(0,52.93485,-.80802),(-.60909,53.10442,-.84489),(-.60268,53.03514,-.88289),(-.09575,53.01378,-1.31492),(.57483,53.05676,-1.26048),(.09277,52.86324,-1.26269),(.65847,52.84681,-1.65055),(.11584,53.14719,-2.33032),(.71065,53.06005,-1.65786),(.08016,53.1432,-1.27552),(.16265,53.09129,-1.29459),(.46906,53.38926,-.97733),(.63845,53.00798,-.98618),(.59931,52.97316,-.92442),(.63126,52.96399,-.99767),(.3584,53.35617,-1.58403),(.2109,53.32411,-1.23663),(.60909,53.10442,-.84445),(.60268,53.03514,-.8823),(.07606,52.72429,-.89209),(0,53.07818,-1.29807),(.08784,53.07861,-1.29494),(0,52.71606,-.90518),(-.63126,52.96399,-.99847),(-.64874,53.02286,-.86143),(-.38827,53.32306,-1.25663),(-.06745,53.28141,-1.23745),(-.08784,53.07861,-1.29505),(-.41669,53.39432,-.97016),(-.3584,53.35617,-1.58409)]))),
        Shape(DEF='c6disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='c6disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,4,10,-1,11,12,13,-1,14,15,16,-1,0,2,17,-1,18,19,20,-1,21,18,20,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,6,35,-1,36,37,33,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,45,-1,47,49,48,-1,50,51,52,-1,53,54,55,-1,56,47,45,-1,57,58,59,-1,60,61,58,-1,62,63,64,-1,65,66,67,-1,65,68,69,-1,70,71,72,-1,72,73,74,-1,73,75,76,-1,77,78,79,-1,80,81,82,-1,83,14,84,-1,85,86,82,-1,81,80,87,-1,88,89,90,-1,20,91,21,-1,92,93,94,-1,40,19,95,-1,96,97,98,-1,61,99,43,-1,59,61,100,-1,101,102,22,-1,103,104,23,-1,105,106,104,-1,55,107,0,-1,85,108,40,-1,54,109,110,-1,54,111,107,-1,100,55,0,-1,102,103,23,-1,43,99,112,-1,96,44,64,-1,98,113,114,-1,20,19,40,-1,92,115,93,-1,116,117,118,-1,90,89,91,-1,90,119,120,-1,86,121,80,-1,85,82,81,-1,16,122,87,-1,86,95,19,-1,14,123,124,-1,125,102,126,-1,127,93,128,-1,76,75,129,-1,68,127,69,-1,60,130,62,-1,63,131,64,-1,98,97,131,-1,66,57,59,-1,132,130,69,-1,56,133,134,-1,100,42,135,-1,134,136,49,-1,96,133,44,-1,38,137,138,-1,33,37,138,-1,6,36,35,-1,104,27,24,-1,36,39,38,-1,139,140,20,-1,17,59,141,-1,89,21,91,-1,142,128,93,-1,11,13,4,-1,6,143,144,-1,12,145,92,-1,5,4,13,-1,125,103,102,-1,40,39,139,-1,13,92,5,-1,146,143,116,-1,92,13,12,-1,144,36,6,-1,4,9,11,-1,96,98,114,-1,139,20,40,-1,37,36,38,-1,23,104,24,-1,35,32,34,-1,35,33,32,-1,33,138,31,-1,29,24,30,-1,38,108,137,-1,133,56,44,-1,134,49,47,-1,9,136,11,-1,9,147,136,-1,42,41,148,-1,55,100,135,-1,134,47,56,-1,58,61,59,-1,149,67,2,-1,131,63,130,-1,127,128,69,-1,150,2,1,-1,131,97,64,-1,60,151,130,-1,74,127,70,-1,76,129,152,-1,153,80,121,-1,14,16,154,-1,126,155,156,-1,80,82,86,-1,153,21,89,-1,126,157,125,-1,87,154,16,-1,81,158,85,-1,155,124,159,-1,153,160,159,-1,90,120,88,-1,90,161,119,-1,91,118,90,-1,117,162,118,-1,115,142,93,-1,96,64,97,-1,46,43,112,-1,15,101,22,-1,163,105,104,-1,100,0,141,-1,107,55,54,-1,54,110,164,-1,95,85,40,-1,54,164,111,-1,100,141,59,-1,106,25,104,-1,103,163,104,-1,102,23,22,-1,122,16,165,-1,94,5,92,-1,153,89,160,-1,80,166,87,-1,85,95,86,-1,14,154,123,-1,126,84,155,-1,73,76,167,-1,70,72,74,-1,130,132,131,-1,64,112,62,-1,60,99,61,-1,63,62,130,-1,79,168,169,-1,67,17,2,-1,133,96,115,-1,55,135,53,-1,50,170,51,-1,134,11,136,-1,135,42,148,-1,44,56,45,-1,42,100,43,-1,40,108,38,-1,33,35,36,-1,34,7,6,-1,31,171,32,-1,104,25,27,-1,22,24,29,-1,37,38,138,-1,17,141,0,-1,101,83,102,-1,43,100,61,-1,11,134,12,-1,10,172,9,-1,6,8,143,-1,173,145,12,-1,139,144,140,-1,115,92,145,-1,107,1,0,-1,111,1,107,-1,111,150,1,-1,174,175,176,-1,174,106,175,-1,8,116,143,-1,8,117,116,-1,3,10,4,-1,10,3,177,-1,178,179,180,-1,178,181,179,-1,182,52,183,-1,184,52,182,-1,51,180,185,-1,51,178,180,-1,24,186,30,-1,24,27,186,-1,165,138,137,-1,138,165,28,-1,187,188,189,-1,53,188,187,-1,170,9,172,-1,170,147,9,-1,50,190,191,-1,50,192,190,-1,190,148,48,-1,188,148,190,-1,115,173,133,-1,115,145,173,-1,193,127,68,-1,127,193,70,-1,112,60,62,-1,99,60,112,-1,149,194,195,-1,149,2,194,-1,131,113,98,-1,113,131,132,-1,194,196,169,-1,194,197,196,-1,168,198,199,-1,198,168,79,-1,200,70,193,-1,200,71,70,-1,127,94,93,-1,127,74,94,-1,89,201,160,-1,88,201,89,-1,202,157,126,-1,202,203,157,-1,84,124,155,-1,84,14,124,-1,204,120,205,-1,120,204,206,-1,156,159,207,-1,155,159,156,-1,198,204,208,-1,198,209,204,-1,166,153,159,-1,166,80,153,-1,205,208,204,-1,208,205,210,-1,152,211,212,-1,152,129,211,-1,177,152,213,-1,177,76,152,-1,106,214,25,-1,106,174,214,-1,165,15,22,-1,16,15,165,-1,213,212,215,-1,213,152,212,-1,211,216,217,-1,211,129,216,-1,216,205,217,-1,216,210,205,-1,206,209,218,-1,204,209,206,-1,207,219,156,-1,207,218,219,-1,166,154,87,-1,154,166,123,-1,77,176,175,-1,79,176,77,-1,77,219,78,-1,77,202,219,-1,207,160,201,-1,207,159,160,-1,73,220,75,-1,220,73,72,-1,221,72,71,-1,72,221,220,-1,222,193,223,-1,193,222,200,-1,168,222,195,-1,168,199,222,-1,151,66,65,-1,66,151,57,-1,176,169,196,-1,169,176,79,-1,195,169,168,-1,195,194,169,-1,150,194,2,-1,150,197,194,-1,54,187,109,-1,54,53,187,-1,192,188,190,-1,188,192,189,-1,49,190,48,-1,190,49,191,-1,172,51,170,-1,178,51,172,-1,41,48,148,-1,48,41,45,-1,189,224,187,-1,189,225,224,-1,22,28,165,-1,29,28,22,-1,186,26,226,-1,186,27,26,-1,183,51,185,-1,183,52,51,-1,171,183,32,-1,182,183,171,-1,30,171,31,-1,30,186,171,-1,214,110,109,-1,214,174,110,-1,8,180,179,-1,7,180,8,-1,213,10,177,-1,181,10,213,-1,146,144,143,-1,144,146,140,-1,103,157,163,-1,103,125,157,-1,196,174,176,-1,196,110,174,-1,150,164,197,-1,111,164,150,-1,106,203,175,-1,106,105,203,-1,8,215,117,-1,8,179,215,-1,10,178,172,-1,178,10,181,-1,14,101,15,-1,101,14,83,-1,167,5,94,-1,3,5,167,-1,224,25,214,-1,25,224,26,-1,226,184,182,-1,226,225,184,-1,7,185,180,-1,185,7,34,-1,144,39,36,-1,144,139,39,-1,45,43,46,-1,45,41,43,-1,188,135,148,-1,135,188,53,-1,170,191,147,-1,191,170,50,-1,52,192,50,-1,52,184,192,-1,142,113,128,-1,114,113,142,-1,68,223,193,-1,68,65,223,-1,65,149,223,-1,149,65,67,-1,227,198,208,-1,227,199,198,-1,69,151,65,-1,69,130,151,-1,208,221,227,-1,210,221,208,-1,167,74,73,-1,94,74,167,-1,102,84,126,-1,84,102,83,-1,198,78,209,-1,79,78,198,-1,88,206,201,-1,88,120,206,-1,212,161,162,-1,212,211,161,-1,167,177,3,-1,177,167,76,-1,108,158,137,-1,85,158,108,-1,137,122,165,-1,158,122,137,-1,112,44,46,-1,112,64,44,-1,114,115,96,-1,115,114,142,-1,140,91,20,-1,140,146,91,-1,215,162,117,-1,215,212,162,-1,90,162,161,-1,162,90,118,-1,217,161,211,-1,119,161,217,-1,119,205,120,-1,217,205,119,-1,201,218,207,-1,206,218,201,-1,218,78,219,-1,218,209,78,-1,124,166,159,-1,123,166,124,-1,175,202,77,-1,175,203,202,-1,18,86,19,-1,121,86,18,-1,202,156,219,-1,202,126,156,-1,87,158,81,-1,158,87,122,-1,121,21,153,-1,21,121,18,-1,216,75,220,-1,216,129,75,-1,221,216,220,-1,221,210,216,-1,199,200,222,-1,200,199,227,-1,195,223,149,-1,195,222,223,-1,58,151,60,-1,57,151,58,-1,71,227,221,-1,200,227,71,-1,66,17,67,-1,66,59,17,-1,128,132,69,-1,113,132,128,-1,109,224,214,-1,109,187,224,-1,184,189,192,-1,189,184,225,-1,136,191,49,-1,136,147,191,-1,133,12,134,-1,133,173,12,-1,224,226,26,-1,225,226,224,-1,31,28,30,-1,31,138,28,-1,185,32,183,-1,34,32,185,-1,186,182,171,-1,186,226,182,-1,146,118,91,-1,116,118,146,-1,181,215,179,-1,181,213,215,-1,105,157,203,-1,105,163,157,-1,197,110,196,-1,164,110,197,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c6disc_Coord',point=[(-.27147,52.80947,-1.40805),(-.24473,52.79464,-1.41642),(-.25321,52.76124,-1.36298),(-.16048,52.67988,-.93298),(-.1654,52.69153,-.93699),(-.17855,52.67758,-.94078),(.27045,52.76175,-.96456),(.17122,52.7507,-.94317),(.16214,52.72752,-.91763),(-.17122,52.72229,-.95949),(-.07389,52.70771,-.91907),(-.27045,52.74179,-.97967),(-.33291,52.74515,-1.00047),(-.2699,52.7048,-.9684),(.31128,52.807,-1.33049),(.32661,52.84766,-1.37257),(.36135,52.849,-1.30352),(-.28224,52.78412,-1.34706),(.39066,52.72523,-1.15698),(.41458,52.74423,-1.15603),(.36461,52.67932,-1.08374),(.33947,52.68457,-1.15789),(.30729,52.8757,-1.35656),(.2447,52.85262,-1.40224),(.23878,52.87155,-1.36478),(.0969,52.83368,-1.39738),(.0981,52.85157,-1.36632),(.17002,52.86027,-1.37386),(.30503,52.8839,-1.2742),(.28024,52.8778,-1.32285),(.24698,52.88368,-1.27728),(.26615,52.86648,-1.17293),(.17619,52.84033,-1.08684),(.2647,52.83911,-1.08838),(.18186,52.80149,-1.00087),(.2577,52.79293,-1.01162),(.31659,52.79104,-1.00906),(.31179,52.82374,-1.09874),(.33666,52.82475,-1.1008),(.36529,52.77332,-1.02797),(.40323,52.77201,-1.08038),(-.30503,52.8839,-1.27478),(-.28024,52.8778,-1.32339),(-.35234,52.88579,-1.27017),(-.37595,52.82536,-1.12085),(-.31409,52.86711,-1.18634),(-.36461,52.87123,-1.19426),(-.31179,52.8228,-1.1),(-.26615,52.86648,-1.17345),(-.2647,52.83587,-1.09013),(-.10115,52.82434,-1.0874),(0,52.79688,-1.00902),(0,52.8216,-1.08824),(-.17002,52.86027,-1.37421),(-.17296,52.8456,-1.3975),(-.25143,52.86006,-1.39622),(-.33666,52.82456,-1.1017),(-.32483,52.79445,-1.29601),(-.3438,52.8199,-1.29856),(-.31128,52.807,-1.33116),(-.37622,52.82614,-1.25821),(-.36135,52.849,-1.30424),(-.38594,52.81652,-1.21456),(-.37788,52.79504,-1.18573),(-.4077,52.8228,-1.16312),(-.28823,52.71709,-1.25174),(-.29695,52.76561,-1.29689),(-.2676,52.73756,-1.30817),(-.28161,52.69451,-1.1853),(-.3193,52.69794,-1.18591),(-.20491,52.67099,-1.1013),(-.13192,52.66371,-1.10428),(-.12692,52.65989,-1.04131),(-.12785,52.65449,-1.00485),(-.21469,52.65822,-1.06142),(-.06038,52.65337,-.99223),(-.06888,52.64606,-.92627),(.06835,52.72473,-1.34997),(.06265,52.72182,-1.34509),(0,52.71562,-1.35581),(.35917,52.76121,-1.21226),(.38594,52.81652,-1.21377),(.37788,52.79504,-1.18493),(.29039,52.80847,-1.36807),(.28224,52.78412,-1.34642),(.4077,52.8228,-1.1623),(.3837,52.75529,-1.19102),(.37622,52.82614,-1.25744),(.20491,52.68096,-1.09624),(.26683,52.6794,-1.0893),(.21469,52.67308,-1.05382),(.29022,52.65895,-1.02315),(-.27252,52.69199,-.97483),(-.286,52.65798,-1.01913),(-.21552,52.63621,-.97288),(.41681,52.77488,-1.15011),(-.39879,52.76581,-1.06682),(-.41681,52.77488,-1.15101),(-.41397,52.74506,-1.1535),(-.38685,52.85808,-1.25449),(-.29777,52.86134,-1.34574),(.29854,52.83283,-1.38974),(.27147,52.80947,-1.40746),(.24353,52.81118,-1.42062),(.17472,52.84111,-1.39853),(.15513,52.79014,-1.40567),(.08946,52.77429,-1.42167),(-.24468,52.81109,-1.42062),(.37806,52.82519,-1.1229),(-.09676,52.83165,-1.39839),(-.08946,52.77429,-1.42188),(-.18613,52.79913,-1.41083),(-.40131,52.85935,-1.21238),(-.39066,52.72523,-1.15793),(-.39067,52.71082,-1.12273),(-.36146,52.71789,-1.00283),(.25927,52.71003,-.94796),(.16451,52.71117,-.91545),(.24224,52.66225,-.96696),(.12692,52.67635,-1.03649),(.13192,52.67414,-1.10227),(.37296,52.74573,-1.19002),(.38685,52.85808,-1.25375),(.32483,52.79445,-1.2953),(.29695,52.76561,-1.2962),(.24473,52.79464,-1.41588),(.25321,52.76124,-1.36239),(-.26683,52.67295,-1.09557),(-.33947,52.68457,-1.16003),(0,52.65534,-.99386),(-.35917,52.76121,-1.21307),(-.3837,52.75529,-1.19189),(-.36856,52.74181,-1.19047),(-.36529,52.77078,-1.03193),(-.31659,52.78304,-1.0166),(-.23878,52.87155,-1.36525),(-.2577,52.77822,-1.02084),(.37115,52.86911,-1.19679),(.31409,52.86711,-1.18574),(.35572,52.75203,-1.01231),(.33969,52.73434,-1.0082),(-.2878,52.81178,-1.34655),(-.3699,52.67798,-1.08274),(.26379,52.72272,-.9514),(.33393,52.74802,-.9995),(-.33966,52.73535,-.99832),(.27112,52.70966,-.96095),(-.18186,52.78044,-1.00921),(-.24698,52.88368,-1.27775),(-.25171,52.73465,-1.31255),(-.19246,52.78303,-1.40481),(-.33828,52.77525,-1.25309),(0,52.66082,-.92412),(.3193,52.69794,-1.18406),(.3438,52.8199,-1.29784),(.2676,52.73756,-1.30753),(.25171,52.73465,-1.31194),(.19231,52.78375,-1.40418),(.39921,52.85349,-1.21191),(.28823,52.71709,-1.25086),(.28161,52.69453,-1.18241),(.12785,52.6744,-.9967),(.15082,52.66938,-.92238),(.18603,52.79993,-1.41021),(-.15526,52.79018,-1.40603),(.34817,52.888,-1.27289),(.33828,52.77525,-1.25233),(-.14739,52.63195,-.94005),(-.06265,52.72182,-1.34526),(-.06835,52.72473,-1.35014),(-.11051,52.78622,-1.01243),(.1696,52.85289,-1.16799),(-.09362,52.73132,-.95159),(-.34504,52.74702,-1.00638),(0,52.76106,-1.42949),(.09129,52.75868,-1.41528),(0,52.74594,-1.42393),(-.07374,52.69276,-.91492),(0,52.74744,-.95439),(.0739,52.72581,-.90697),(.09362,52.75207,-.93943),(0,52.71802,-.91953),(.09585,52.8499,-1.16385),(.10115,52.83219,-1.08773),(0,52.84624,-1.1629),(.11051,52.80295,-1.00741),(.16547,52.87669,-1.2731),(-.0981,52.85157,-1.36653),(-.16547,52.87669,-1.27343),(-.09277,52.86159,-1.26298),(-.1696,52.85241,-1.16925),(-.17619,52.83231,-1.08822),(-.09585,52.84872,-1.16508),(-.21205,52.68817,-1.18302),(-.15704,52.74171,-1.34853),(-.15415,52.73052,-1.32584),(-.09129,52.75868,-1.41549),(-.15804,52.77347,-1.39959),(0,52.69713,-1.29402),(-.06537,52.7011,-1.28807),(-.13209,52.67942,-1.19483),(.21205,52.68942,-1.1789),(.15704,52.74171,-1.34815),(.15804,52.77347,-1.39922),(.06595,52.67792,-1.20079),(.06485,52.66979,-1.1148),(.13209,52.68109,-1.19145),(.23549,52.71056,-1.26502),(0,52.67337,-1.20996),(.06537,52.7011,-1.28722),(0,52.66415,-1.12529),(.06038,52.6648,-.98719),(.06902,52.66256,-.91622),(0,52.70479,-.91477),(0,52.82301,-1.40251),(.07378,52.71129,-.90287),(0,52.66252,-1.05684),(.06515,52.67278,-1.04888),(.14827,52.70775,-1.27805),(.15415,52.73052,-1.32543),(-.06515,52.66358,-1.05035),(-.06485,52.66405,-1.1153),(-.14827,52.70775,-1.2795),(-.23549,52.71056,-1.26616),(0,52.84945,-1.36333),(0,52.85933,-1.25723),(.09277,52.86159,-1.26279),(-.06595,52.67679,-1.2027)]))),
        Shape(DEF='c7',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='c7_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,22,21,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,0,43,44,-1,1,0,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,53,25,-1,76,43,0,-1,77,78,70,-1,79,80,81,-1,82,78,77,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,105,108,-1,86,96,101,-1,109,110,111,-1,88,87,112,-1,113,114,115,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,127,-1,128,129,130,-1,130,131,132,-1,124,133,114,-1,134,135,121,-1,92,136,93,-1,137,138,139,-1,140,119,141,-1,142,143,144,-1,145,146,9,-1,147,148,149,-1,14,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,146,162,-1,163,156,164,-1,165,145,9,-1,166,167,168,-1,169,170,171,-1,172,173,174,-1,175,176,22,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,183,-1,154,188,189,-1,154,190,191,-1,192,114,113,-1,115,193,113,-1,194,195,196,-1,187,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,102,209,-1,210,95,211,-1,66,212,67,-1,213,214,215,-1,216,106,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,227,228,229,-1,230,231,232,-1,233,234,235,-1,236,237,238,-1,239,240,241,-1,242,243,8,-1,244,245,246,-1,247,248,249,-1,250,251,252,-1,253,254,211,-1,255,256,257,-1,258,259,260,-1,261,262,263,-1,8,7,261,-1,264,265,266,-1,267,268,269,-1,97,270,271,-1,210,96,95,-1,272,273,274,-1,275,276,277,-1,236,238,278,-1,238,279,278,-1,6,280,281,-1,265,282,283,-1,284,263,285,-1,267,286,285,-1,287,288,289,-1,287,290,288,-1,291,292,293,-1,294,295,42,-1,296,297,298,-1,299,300,301,-1,302,303,304,-1,305,306,307,-1,276,308,309,-1,180,310,186,-1,186,183,311,-1,188,312,126,-1,193,313,202,-1,192,314,315,-1,125,127,313,-1,170,316,300,-1,74,118,72,-1,221,182,317,-1,318,319,320,-1,321,131,130,-1,322,323,324,-1,325,323,322,-1,326,327,328,-1,329,326,330,-1,331,332,59,-1,333,334,332,-1,335,336,337,-1,338,339,340,-1,339,341,342,-1,343,344,345,-1,346,347,348,-1,349,350,351,-1,348,352,353,-1,354,353,355,-1,356,357,358,-1,359,360,361,-1,362,176,363,-1,22,364,23,-1,365,366,367,-1,159,368,160,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,380,388,-1,389,390,391,-1,392,393,5,-1,394,47,395,-1,396,397,398,-1,399,210,400,-1,249,401,254,-1,402,249,403,-1,404,403,405,-1,406,55,407,-1,407,55,54,-1,408,409,410,-1,411,409,62,-1,409,412,413,-1,414,415,416,-1,417,418,416,-1,417,419,420,-1,420,421,417,-1,422,423,424,-1,425,426,427,-1,166,428,424,-1,429,430,156,-1,431,432,433,-1,1,434,2,-1,435,436,437,-1,438,212,66,-1,439,440,441,-1,442,443,78,-1,444,32,445,-1,446,447,448,-1,449,20,19,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,467,85,468,-1,469,470,471,-1,472,473,373,-1,474,475,476,-1,476,477,478,-1,479,480,477,-1,245,218,481,-1,229,228,482,-1,483,484,485,-1,486,487,488,-1,489,392,490,-1,491,492,493,-1,494,495,496,-1,497,498,499,-1,500,501,502,-1,503,504,505,-1,506,507,508,-1,507,506,509,-1,510,511,512,-1,513,514,515,-1,516,517,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,528,529,530,-1,528,530,487,-1,531,532,533,-1,534,535,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,547,548,-1,549,550,547,-1,551,552,553,-1,554,555,556,-1,557,558,559,-1,486,488,560,-1,561,562,563,-1,512,537,564,-1,565,566,567,-1,568,560,488,-1,569,570,558,-1,571,572,573,-1,570,569,574,-1,572,571,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,588,589,590,-1,591,592,593,-1,594,595,596,-1,597,593,587,-1,598,599,600,-1,601,602,603,-1,604,605,606,-1,607,563,608,-1,609,610,611,-1,612,613,614,-1,615,616,617,-1,618,619,620,-1,621,622,623,-1,612,614,599,-1,624,611,625,-1,626,627,628,-1,593,629,591,-1,609,615,630,-1,631,632,633,-1,634,635,636,-1,637,638,639,-1,640,641,497,-1,574,642,568,-1,643,644,645,-1,646,647,631,-1,648,649,650,-1,651,496,652,-1,653,654,655,-1,656,657,658,-1,659,509,506,-1,660,661,662,-1,663,662,664,-1,665,666,667,-1,668,667,666,-1,666,669,668,-1,670,671,672,-1,673,671,670,-1,674,599,614,-1,674,675,676,-1,677,678,679,-1,680,681,669,-1,682,683,684,-1,685,686,687,-1,688,565,689,-1,690,691,692,-1,691,685,693,-1,694,695,592,-1,696,697,698,-1,553,699,700,-1,518,701,516,-1,702,703,704,-1,705,219,706,-1,707,708,709,-1,710,711,709,-1,595,710,708,-1,712,713,714,-1,715,716,595,-1,617,717,718,-1,719,720,721,-1,722,723,724,-1,725,726,727,-1,491,493,728,-1,729,730,244,-1,731,732,733,-1,734,697,735,-1,736,737,722,-1,738,739,740,-1,741,742,738,-1,734,743,585,-1,744,745,746,-1,575,747,748,-1,749,688,689,-1,750,492,751,-1,752,739,753,-1,754,755,737,-1,754,756,757,-1,758,759,760,-1,761,762,758,-1,763,764,765,-1,527,766,767,-1,765,768,769,-1,770,683,771,-1,566,772,773,-1,774,775,688,-1,668,776,663,-1,667,668,663,-1,686,685,777,-1,614,613,778,-1,676,675,779,-1,780,561,563,-1,781,782,711,-1,623,622,783,-1,784,785,637,-1,786,787,788,-1,789,786,790,-1,548,791,792,-1,793,794,791,-1,795,796,797,-1,338,340,798,-1,799,798,800,-1,801,800,344,-1,802,803,804,-1,805,802,806,-1,807,806,808,-1,809,810,808,-1,640,811,812,-1,813,814,809,-1,815,816,813,-1,817,818,819,-1,820,818,506,-1,508,821,822,-1,643,823,824,-1,825,826,827,-1,828,829,830,-1,831,832,833,-1,834,835,836,-1,837,838,839,-1,840,841,842,-1,843,834,844,-1,845,846,847,-1,489,393,392,-1,848,849,850,-1,851,852,847,-1,535,853,854,-1,855,856,857,-1,523,856,858,-1,859,696,860,-1,524,523,861,-1,862,731,733,-1,863,862,864,-1,865,866,867,-1,743,868,869,-1,870,528,486,-1,410,871,408,-1,872,871,873,-1,874,416,415,-1,416,874,875,-1,876,420,419,-1,877,423,420,-1,878,879,880,-1,878,504,881,-1,882,883,432,-1,884,881,504,-1,870,885,699,-1,560,886,887,-1,569,642,574,-1,517,888,889,-1,890,891,892,-1,504,503,893,-1,894,895,896,-1,897,898,899,-1,556,900,901,-1,902,903,904,-1,905,906,907,-1,908,909,589,-1,910,576,909,-1,911,912,913,-1,829,914,915,-1,916,917,918,-1,919,920,916,-1,920,921,922,-1,923,924,706,-1,925,923,706,-1,634,484,926,-1,927,651,928,-1,708,596,595,-1,929,921,567,-1,922,930,931,-1,918,932,916,-1,915,914,933,-1,934,931,930,-1,935,641,640,-1,936,501,500,-1,937,590,909,-1,904,938,555,-1,939,940,941,-1,942,943,892,-1,944,892,945,-1,573,572,946,-1,945,947,516,-1,948,571,701,-1,642,886,560,-1,744,743,869,-1,699,553,949,-1,950,951,952,-1,504,878,880,-1,881,654,878,-1,953,954,653,-1,875,874,788,-1,546,871,872,-1,955,549,873,-1,585,743,744,-1,956,660,957,-1,594,702,595,-1,865,863,866,-1,866,958,867,-1,864,959,866,-1,731,861,523,-1,960,695,694,-1,961,962,963,-1,964,535,534,-1,965,847,849,-1,966,967,844,-1,846,850,849,-1,846,968,850,-1,845,843,969,-1,845,852,970,-1,971,972,841,-1,837,971,840,-1,834,836,966,-1,834,843,838,-1,839,838,843,-1,973,974,975,-1,973,704,976,-1,565,977,689,-1,829,828,978,-1,539,564,537,-1,643,645,826,-1,645,644,680,-1,822,821,979,-1,632,817,980,-1,656,981,819,-1,982,814,981,-1,983,812,811,-1,809,814,982,-1,807,896,984,-1,985,986,815,-1,987,988,989,-1,990,991,992,-1,990,992,804,-1,993,804,803,-1,994,995,796,-1,797,637,542,-1,792,791,785,-1,720,764,763,-1,783,671,673,-1,996,997,998,-1,672,783,999,-1,1000,999,1001,-1,1002,779,675,-1,1003,667,997,-1,668,669,681,-1,690,692,1004,-1,561,684,1005,-1,683,682,930,-1,1006,1007,859,-1,768,519,526,-1,526,1006,1008,-1,1007,1006,525,-1,1009,1010,527,-1,1009,1011,1012,-1,765,769,1013,-1,741,1014,521,-1,756,1015,757,-1,750,740,752,-1,739,742,753,-1,1016,1017,794,-1,424,655,431,-1,837,1018,1019,-1,697,734,698,-1,621,1020,1021,-1,1022,1023,1024,-1,1025,751,1026,-1,1019,1027,837,-1,696,859,1007,-1,1028,697,696,-1,1029,858,856,-1,730,729,925,-1,1030,1031,1032,-1,521,766,519,-1,1033,720,1034,-1,664,1035,1036,-1,716,1037,714,-1,1038,711,714,-1,708,710,709,-1,1039,596,1040,-1,517,516,888,-1,1041,1042,719,-1,693,1043,774,-1,774,688,749,-1,773,772,775,-1,770,1044,1045,-1,677,1046,678,-1,1047,1048,1049,-1,1002,1000,779,-1,1050,1051,1000,-1,928,662,663,-1,662,928,951,-1,707,660,956,-1,656,819,657,-1,935,658,905,-1,718,717,1052,-1,1053,1006,1054,-1,1055,1056,926,-1,953,653,655,-1,1057,952,651,-1,1058,1059,833,-1,654,881,1060,-1,1061,646,1062,-1,1063,1064,1065,-1,927,776,681,-1,649,1066,1058,-1,485,634,1047,-1,1062,633,1067,-1,1068,1069,987,-1,495,659,632,-1,627,1070,1071,-1,1072,597,1073,-1,582,1071,576,-1,1074,1075,1076,-1,599,1077,600,-1,659,817,632,-1,999,783,622,-1,616,1013,617,-1,610,609,1078,-1,1074,611,610,-1,563,1079,610,-1,578,629,624,-1,912,1080,913,-1,589,588,1081,-1,909,1071,937,-1,627,1071,582,-1,606,1082,604,-1,606,586,1082,-1,860,587,695,-1,562,1083,563,-1,1084,559,1085,-1,936,1086,555,-1,811,640,1087,-1,1088,503,505,-1,1089,639,1017,-1,1090,594,1091,-1,540,1092,1093,-1,933,914,932,-1,865,545,869,-1,863,868,735,-1,1094,1018,853,-1,985,813,1095,-1,1014,1096,1097,-1,768,526,1008,-1,1098,948,518,-1,513,515,512,-1,657,820,508,-1,1099,509,644,-1,657,822,514,-1,564,978,1100,-1,905,658,906,-1,498,1081,502,-1,1087,640,497,-1,1023,1022,753,-1,965,849,848,-1,1101,9,11,-1,227,107,1102,-1,475,303,479,-1,373,473,1103,-1,1104,465,1105,-1,272,303,273,-1,1106,103,469,-1,1107,461,17,-1,1107,1108,461,-1,1108,1109,459,-1,1110,1111,447,-1,447,1111,79,-1,1112,81,80,-1,213,1113,17,-1,1114,1115,1116,-1,1117,443,76,-1,1118,270,1119,-1,1120,67,437,-1,449,164,430,-1,157,1121,155,-1,157,163,1122,-1,1123,427,19,-1,427,167,1124,-1,168,426,1125,-1,417,1126,327,-1,418,327,329,-1,1127,62,409,-1,62,61,1128,-1,1129,1130,443,-1,97,1131,1119,-1,1132,1133,1134,-1,404,407,1135,-1,1136,1137,402,-1,249,248,38,-1,1138,209,210,-1,38,250,1139,-1,1140,1141,1142,-1,1143,49,252,-1,398,397,1144,-1,46,1145,395,-1,387,1146,1147,-1,258,391,1148,-1,259,258,395,-1,260,388,389,-1,381,390,389,-1,386,1149,1150,-1,387,1147,378,-1,379,388,380,-1,389,388,382,-1,975,974,1151,-1,1152,216,1153,-1,373,275,1154,-1,1155,52,51,-1,53,75,51,-1,1156,158,370,-1,197,1157,158,-1,365,29,28,-1,363,176,144,-1,362,357,173,-1,361,1158,358,-1,1159,356,358,-1,1158,360,1160,-1,1161,355,353,-1,349,1162,1163,-1,989,1164,1165,-1,346,1162,1166,-1,347,346,1166,-1,1167,347,1168,-1,337,1169,1170,-1,64,323,336,-1,322,331,330,-1,1171,191,1172,-1,129,191,190,-1,181,180,311,-1,1173,321,190,-1,140,232,231,-1,125,1173,189,-1,313,127,1174,-1,188,311,183,-1,310,1157,187,-1,1175,1154,205,-1,74,307,306,-1,199,305,307,-1,399,1176,1177,-1,299,36,35,-1,1178,36,299,-1,1177,40,1178,-1,40,1176,1179,-1,1180,1181,1182,-1,41,1183,294,-1,1184,294,1180,-1,293,1185,291,-1,1186,1187,292,-1,1188,1189,290,-1,1190,1191,34,-1,267,269,286,-1,283,1192,281,-1,265,1193,282,-1,333,1194,334,-1,431,166,424,-1,1195,1196,383,-1,95,271,211,-1,1197,1198,131,-1,1199,1200,264,-1,1201,1202,6,-1,261,1203,262,-1,383,1204,1195,-1,399,400,1205,-1,400,211,254,-1,1206,1207,1202,-1,1202,1201,1206,-1,36,295,34,-1,234,233,1172,-1,181,1208,317,-1,1209,1210,223,-1,223,222,318,-1,221,1210,1102,-1,1146,1145,5,-1,203,202,1211,-1,277,276,309,-1,199,308,1212,-1,305,199,201,-1,1156,1213,197,-1,194,145,165,-1,1049,1214,147,-1,113,193,204,-1,127,1215,1174,-1,126,312,1215,-1,180,178,1216,-1,1217,1216,178,-1,177,179,1218,-1,172,362,173,-1,1219,174,1220,-1,170,1221,230,-1,316,301,300,-1,483,1222,1223,-1,166,433,167,-1,166,168,1125,-1,165,1101,1224,-1,163,164,1225,-1,1226,1227,1228,-1,1229,1230,142,-1,1228,1064,1226,-1,10,1157,310,-1,163,157,156,-1,412,409,408,-1,433,166,431,-1,350,143,1230,-1,1165,351,1226,-1,161,144,175,-1,87,86,1231,-1,1232,85,94,-1,134,1233,135,-1,114,1234,125,-1,131,321,1173,-1,231,1185,1235,-1,1236,117,141,-1,1236,121,135,-1,1236,1237,72,-1,1238,1239,83,-1,469,103,470,-1,1240,1241,466,-1,100,85,467,-1,137,94,99,-1,209,96,210,-1,72,1242,73,-1,430,1243,449,-1,33,444,1130,-1,1109,1108,1107,-1,458,1244,1245,-1,1159,1246,1247,-1,66,68,1119,-1,106,105,217,-1,1093,1248,1249,-1,1118,56,55,-1,55,406,1118,-1,253,405,403,-1,397,1250,1251,-1,359,1252,1163,-1,1253,268,1254,-1,301,1178,299,-1,31,445,32,-1,25,30,26,-1,367,23,172,-1,1255,1256,24,-1,365,172,1219,-1,1257,1154,75,-1,463,1219,464,-1,16,15,1240,-1,14,151,1247,-1,1200,1258,265,-1,394,1148,1259,-1,265,264,1200,-1,61,60,332,-1,16,1240,13,-1,1161,1260,355,-1,1257,374,1154,-1,362,172,364,-1,29,365,1219,-1,367,172,365,-1,25,1261,30,-1,31,1116,445,-1,1253,1254,34,-1,267,1192,1262,-1,56,1263,104,-1,1264,1265,481,-1,1250,1196,1251,-1,253,1266,405,-1,1104,473,465,-1,1249,1267,1093,-1,1263,105,104,-1,1194,1268,1269,-1,18,20,1270,-1,1247,151,1159,-1,1107,1271,1109,-1,33,1130,1129,-1,164,156,430,-1,430,69,1243,-1,1237,135,1272,-1,43,76,1273,-1,89,91,474,-1,137,99,1274,-1,100,99,85,-1,466,150,1240,-1,83,134,1238,-1,133,124,93,-1,1272,122,1242,-1,72,117,1236,-1,135,1237,1236,-1,1236,141,119,-1,116,169,171,-1,1173,1197,131,-1,125,115,114,-1,144,176,175,-1,1275,1234,114,-1,1233,123,135,-1,85,99,94,-1,86,1276,1231,-1,99,98,1274,-1,175,1277,161,-1,351,1227,1226,-1,143,142,1230,-1,147,149,485,-1,155,429,156,-1,310,11,10,-1,1064,1063,1226,-1,142,162,1229,-1,1278,1124,167,-1,1121,1279,155,-1,1224,1280,165,-1,1125,428,166,-1,433,1278,167,-1,1281,483,1223,-1,377,1282,1121,-1,316,1177,301,-1,170,300,1221,-1,1220,464,1219,-1,1218,1132,177,-1,188,126,189,-1,127,126,1215,-1,204,314,113,-1,1049,147,485,-1,194,165,195,-1,1156,197,158,-1,305,201,304,-1,199,1212,200,-1,1211,277,309,-1,1211,309,203,-1,235,1207,1206,-1,444,33,32,-1,318,224,223,-1,223,226,1209,-1,229,217,227,-1,238,1283,284,-1,181,317,182,-1,128,191,129,-1,1172,1284,234,-1,295,1253,34,-1,243,1206,1201,-1,1285,246,245,-1,254,1205,400,-1,1205,1176,399,-1,1192,283,282,-1,1198,132,131,-1,1235,1286,140,-1,327,326,329,-1,265,1258,1193,-1,1192,1287,281,-1,1288,269,287,-1,1190,34,1254,-1,239,1188,290,-1,1185,1289,291,-1,1180,1290,1184,-1,42,41,294,-1,1180,1182,1291,-1,40,1177,1176,-1,1178,301,1177,-1,291,299,35,-1,399,1177,316,-1,303,272,304,-1,306,1292,74,-1,1175,205,1293,-1,187,186,310,-1,183,1294,188,-1,313,1174,1295,-1,125,189,126,-1,1173,190,189,-1,181,311,153,-1,190,321,129,-1,65,1249,1248,-1,335,64,336,-1,337,1296,1169,-1,1166,1297,347,-1,353,352,18,-1,346,1298,1162,-1,989,1299,1164,-1,354,360,1300,-1,1158,361,360,-1,454,1159,358,-1,358,357,361,-1,361,357,1252,-1,1301,1252,362,-1,28,1302,365,-1,367,366,21,-1,1157,1255,158,-1,158,160,370,-1,53,1261,25,-1,1155,51,1175,-1,1154,374,373,-1,275,1303,1304,-1,1152,1153,1305,-1,975,1151,1305,-1,382,381,389,-1,379,382,388,-1,378,380,387,-1,386,1150,383,-1,386,385,1149,-1,381,1306,390,-1,389,258,260,-1,258,1148,395,-1,387,1307,1146,-1,46,395,47,-1,1148,391,1259,-1,50,398,1144,-1,1140,1142,1308,-1,1138,210,1309,-1,38,401,249,-1,404,1136,402,-1,1135,1136,404,-1,404,405,406,-1,227,217,105,-1,1134,177,1132,-1,1119,270,97,-1,411,62,1128,-1,409,57,1127,-1,418,329,414,-1,417,327,418,-1,18,1123,19,-1,157,1122,1310,-1,436,1120,437,-1,1118,1119,68,-1,76,439,1117,-1,1116,31,1114,-1,214,213,17,-1,475,474,1311,-1,1312,447,79,-1,1260,1112,355,-1,447,446,1110,-1,1109,1313,459,-1,467,1314,100,-1,17,16,1107,-1,151,150,1220,-1,303,1311,273,-1,465,473,472,-1,476,1104,474,-1,475,1311,303,-1,179,178,182,-1,11,1216,1101,-1,1023,753,742,-1,793,550,549,-1,498,502,501,-1,896,1315,984,-1,978,828,1100,-1,818,657,819,-1,658,657,514,-1,822,657,508,-1,512,511,513,-1,518,517,1098,-1,521,1014,1097,-1,1316,740,757,-1,1090,1091,544,-1,924,923,1317,-1,1018,854,853,-1,735,862,863,-1,545,544,869,-1,540,1093,1267,-1,702,594,703,-1,744,551,700,-1,1087,1318,811,-1,941,1319,556,-1,936,555,554,-1,1085,649,648,-1,1085,893,1084,-1,1320,1074,1079,-1,1321,568,530,-1,918,580,579,-1,627,582,628,-1,909,576,1071,-1,1081,641,589,-1,624,625,578,-1,583,612,598,-1,1083,613,1320,-1,610,608,563,-1,610,1079,1074,-1,1078,608,610,-1,1322,1323,1324,-1,622,1021,999,-1,1074,1076,625,-1,582,576,1325,-1,1072,1073,605,-1,495,632,631,-1,1326,1068,987,-1,1327,1062,1067,-1,431,655,882,-1,408,871,1328,-1,649,1329,650,-1,927,681,494,-1,1326,1063,1065,-1,1062,1327,1061,-1,1065,1068,1326,-1,884,648,650,-1,651,1046,1057,-1,953,655,1330,-1,1055,926,1331,-1,833,950,831,-1,1053,1008,1006,-1,717,1053,1052,-1,935,1332,658,-1,707,661,660,-1,672,1000,1003,-1,1002,1050,1000,-1,1049,485,1047,-1,1046,652,678,-1,683,770,1045,-1,773,775,1044,-1,774,749,693,-1,693,685,1043,-1,1031,1041,719,-1,1031,1333,1041,-1,489,1334,967,-1,596,956,1040,-1,714,713,1038,-1,716,714,710,-1,595,702,715,-1,737,1335,722,-1,664,1036,998,-1,619,673,620,-1,1033,721,720,-1,521,1097,766,-1,493,1030,1032,-1,1030,1333,1031,-1,1029,1336,858,-1,696,1337,1028,-1,1007,1337,696,-1,739,752,740,-1,493,492,1338,-1,1021,622,621,-1,615,618,616,-1,790,786,788,-1,739,738,742,-1,750,1339,740,-1,758,1015,759,-1,521,1340,741,-1,764,1341,1342,-1,765,1013,763,-1,1009,767,1011,-1,1009,1343,1010,-1,525,1344,1007,-1,526,525,1006,-1,859,1054,1006,-1,1005,1045,1044,-1,561,780,684,-1,692,978,1004,-1,681,776,668,-1,1003,1345,667,-1,675,777,1002,-1,1000,672,999,-1,617,630,615,-1,672,671,783,-1,997,663,998,-1,673,619,783,-1,1033,673,1346,-1,720,763,1034,-1,1092,540,1347,-1,797,542,541,-1,796,795,994,-1,804,1348,990,-1,505,805,807,-1,990,986,991,-1,988,1299,989,-1,806,809,808,-1,982,810,809,-1,983,811,898,-1,981,983,982,-1,813,981,814,-1,819,813,816,-1,822,979,514,-1,507,1349,508,-1,644,681,680,-1,826,1350,643,-1,512,515,537,-1,978,689,829,-1,973,1351,704,-1,973,1352,974,-1,843,845,839,-1,834,838,1353,-1,966,844,834,-1,971,841,840,-1,845,970,839,-1,845,969,846,-1,849,847,846,-1,967,1354,844,-1,964,853,535,-1,855,1355,1356,-1,961,1357,962,-1,1358,856,523,-1,960,860,695,-1,523,858,731,-1,864,1359,959,-1,866,959,958,-1,957,1040,956,-1,744,746,585,-1,642,1360,1361,-1,549,872,873,-1,546,872,547,-1,788,1362,875,-1,504,880,505,-1,1058,833,1329,-1,1085,648,893,-1,950,1363,951,-1,699,949,1364,-1,551,744,869,-1,560,568,642,-1,701,518,948,-1,945,516,701,-1,931,918,917,-1,1365,944,945,-1,896,946,1315,-1,942,892,944,-1,556,939,941,-1,904,555,1086,-1,902,1086,936,-1,500,902,936,-1,913,1080,591,-1,934,930,682,-1,908,933,932,-1,1366,914,829,-1,922,931,917,-1,566,929,567,-1,664,662,661,-1,927,496,651,-1,634,485,484,-1,1367,1368,715,-1,706,730,925,-1,922,917,920,-1,916,1366,919,-1,916,920,917,-1,911,913,1369,-1,908,589,933,-1,915,905,907,-1,1318,1087,499,-1,590,589,909,-1,1086,902,904,-1,556,901,939,-1,898,1370,899,-1,894,1371,895,-1,890,892,943,-1,889,1098,517,-1,560,887,1372,-1,699,1364,870,-1,486,528,487,-1,882,432,431,-1,649,1085,1066,-1,424,1330,655,-1,878,954,879,-1,877,420,876,-1,876,419,875,-1,875,419,416,-1,874,415,1373,-1,1374,789,1328,-1,870,1375,528,-1,543,545,867,-1,867,545,865,-1,863,864,866,-1,862,733,864,-1,1028,861,731,-1,860,960,859,-1,535,854,1376,-1,851,847,965,-1,848,850,1377,-1,1334,1354,967,-1,847,852,845,-1,969,843,844,-1,1018,1094,1019,-1,837,839,971,-1,834,1353,835,-1,840,1018,837,-1,831,1378,832,-1,977,829,689,-1,825,1350,826,-1,824,507,1099,-1,508,1349,821,-1,818,817,506,-1,819,980,817,-1,819,981,813,-1,815,813,985,-1,809,1095,813,-1,983,981,812,-1,896,807,808,-1,807,805,806,-1,988,986,990,-1,802,804,992,-1,344,343,801,-1,1379,799,800,-1,798,1380,338,-1,797,541,795,-1,793,1016,794,-1,548,793,791,-1,789,792,786,-1,786,784,787,-1,637,797,784,-1,638,637,785,-1,783,619,623,-1,781,711,1038,-1,1035,664,709,-1,563,607,780,-1,1053,1054,1052,-1,779,1001,676,-1,778,1381,614,-1,777,675,686,-1,663,997,667,-1,1382,666,665,-1,775,772,688,-1,773,929,566,-1,1005,684,1045,-1,683,930,771,-1,1008,1053,768,-1,767,1009,527,-1,1383,520,765,-1,760,761,758,-1,740,1316,738,-1,753,1384,752,-1,750,1338,492,-1,698,587,860,-1,734,585,698,-1,1015,1096,757,-1,1022,1024,1041,-1,1026,1385,491,-1,755,1025,1026,-1,969,968,846,-1,257,1386,1387,-1,697,1028,735,-1,855,1029,856,-1,1388,729,244,-1,493,1032,728,-1,725,1389,726,-1,721,1031,719,-1,719,1042,720,-1,602,618,615,-1,718,630,617,-1,715,1368,716,-1,714,1037,712,-1,595,716,710,-1,710,714,711,-1,705,220,219,-1,704,1390,702,-1,699,1391,700,-1,860,696,698,-1,694,592,1392,-1,691,777,685,-1,690,1393,691,-1,687,1043,685,-1,770,773,1044,-1,683,1045,684,-1,669,1394,680,-1,679,636,677,-1,674,686,675,-1,674,614,1381,-1,673,670,1346,-1,672,1003,670,-1,666,1394,669,-1,665,667,1345,-1,664,998,663,-1,662,1395,660,-1,506,817,659,-1,658,1332,656,-1,1322,718,1323,-1,718,1052,1323,-1,1329,833,832,-1,651,652,1046,-1,1059,1396,833,-1,881,884,650,-1,631,1062,646,-1,1329,649,1058,-1,819,816,980,-1,637,639,542,-1,634,636,1047,-1,496,647,652,-1,633,1062,631,-1,630,1078,609,-1,593,597,629,-1,626,1397,627,-1,1398,910,581,-1,611,1074,625,-1,599,598,612,-1,621,623,1399,-1,618,623,619,-1,779,1000,1001,-1,612,1075,613,-1,611,1400,609,-1,607,608,1324,-1,676,599,674,-1,604,1401,605,-1,601,1399,602,-1,597,587,1073,-1,1039,594,596,-1,703,594,1090,-1,591,1080,592,-1,937,1071,1070,-1,585,587,698,-1,584,628,582,-1,581,910,579,-1,606,605,1073,-1,578,1325,576,-1,570,574,1402,-1,573,1365,571,-1,557,569,558,-1,488,530,568,-1,567,977,565,-1,486,560,1372,-1,889,557,559,-1,551,553,700,-1,1347,542,1403,-1,547,872,549,-1,548,1374,546,-1,543,1090,544,-1,542,1347,540,-1,930,922,771,-1,1404,1405,1406,-1,535,1355,536,-1,533,1377,531,-1,530,488,487,-1,525,527,1010,-1,524,1344,522,-1,514,979,515,-1,509,1099,507,-1,508,820,506,-1,657,818,820,-1,1315,1088,984,-1,748,747,1084,-1,499,1087,497,-1,556,1319,554,-1,496,927,494,-1,491,1385,492,-1,392,4,490,-1,483,485,149,-1,477,475,479,-1,478,1103,476,-1,475,477,476,-1,274,469,471,-1,465,467,1105,-1,462,464,472,-1,12,1247,1246,-1,467,466,1314,-1,459,461,1108,-1,1407,456,458,-1,453,1408,454,-1,452,355,450,-1,446,448,1409,-1,445,71,444,-1,441,1117,439,-1,66,1119,438,-1,437,215,435,-1,19,1124,1225,-1,432,1410,433,-1,1124,19,427,-1,1123,425,427,-1,422,424,428,-1,416,419,417,-1,414,416,418,-1,1118,1266,270,-1,407,404,406,-1,404,402,403,-1,402,1411,249,-1,401,38,37,-1,399,1309,210,-1,248,250,38,-1,1412,250,252,-1,396,1250,397,-1,395,1148,394,-1,1146,1307,1145,-1,389,391,258,-1,387,388,260,-1,1195,1251,1196,-1,1150,381,383,-1,378,1413,379,-1,383,1196,386,-1,377,1121,375,-1,275,373,1303,-1,369,1156,370,-1,24,21,159,-1,365,1302,366,-1,22,176,364,-1,362,364,176,-1,1252,357,362,-1,361,1252,359,-1,356,1159,151,-1,354,1160,360,-1,354,1300,353,-1,353,1300,348,-1,349,351,1162,-1,347,1167,348,-1,345,1414,343,-1,342,345,339,-1,338,1415,339,-1,1416,1417,1418,-1,1416,1296,1417,-1,337,1170,335,-1,331,333,332,-1,330,331,59,-1,329,330,413,-1,328,325,326,-1,325,336,323,-1,321,130,129,-1,318,222,319,-1,74,1292,118,-1,313,115,125,-1,315,122,192,-1,73,1419,74,-1,73,315,1419,-1,313,1295,202,-1,188,1294,312,-1,311,180,186,-1,185,184,1213,-1,276,1212,308,-1,302,304,201,-1,1289,299,291,-1,296,1420,297,-1,294,1184,295,-1,291,35,1421,-1,287,289,1288,-1,1193,1262,1192,-1,283,266,265,-1,281,1203,6,-1,274,471,272,-1,1422,1423,1424,-1,1131,438,1119,-1,271,95,97,-1,1193,1258,1190,-1,1192,282,1193,-1,238,284,1425,-1,253,211,271,-1,1411,1426,249,-1,247,249,1426,-1,244,246,1388,-1,243,1201,8,-1,241,1188,239,-1,235,1206,233,-1,234,1427,235,-1,140,1286,111,-1,230,1221,231,-1,227,1209,228,-1,226,223,224,-1,221,223,1210,-1,221,1102,1218,-1,218,220,1428,-1,216,217,1429,-1,33,1114,31,-1,214,1430,215,-1,212,437,67,-1,211,400,210,-1,208,209,1138,-1,205,207,1293,-1,275,1304,276,-1,204,193,202,-1,187,1157,197,-1,196,1431,194,-1,115,313,193,-1,314,192,113,-1,1171,154,191,-1,154,189,190,-1,185,1294,183,-1,182,178,180,-1,177,1432,178,-1,22,1256,175,-1,1219,172,174,-1,170,230,171,-1,375,1121,157,-1,165,9,1101,-1,1121,1433,1279,-1,163,1225,1124,-1,162,142,161,-1,76,443,442,-1,154,1171,152,-1,363,1301,362,-1,147,196,148,-1,144,161,142,-1,232,140,141,-1,137,1274,138,-1,90,468,1434,-1,136,133,93,-1,134,121,1238,-1,114,192,124,-1,132,1435,130,-1,128,130,1286,-1,231,1235,140,-1,192,122,124,-1,121,1236,119,-1,117,72,118,-1,88,112,1436,-1,111,1435,109,-1,1275,114,133,-1,101,1276,86,-1,107,227,105,-1,101,103,1106,-1,1314,466,1241,-1,96,1437,97,-1,92,94,137,-1,89,468,90,-1,1232,83,85,-1,1424,1115,81,-1,82,442,78,-1,81,1115,79,-1,70,1438,77,-1,0,439,76,-1,69,1438,70,-1,458,1109,1271,-1,67,1439,68,-1,1127,60,62,-1,59,1127,57,-1,56,104,54,-1,302,479,303,-1,1440,1441,1442,-1,49,398,50,-1,47,1443,45,-1,44,434,1,-1,42,1178,40,-1,39,1179,37,-1,30,1261,28,-1,24,1256,22,-1,23,367,21,-1,23,364,172,-1,1161,1270,1260,-1,1243,1423,1422,-1,14,1247,12,-1,1271,1244,458,-1,9,1277,10,-1,8,1201,6,-1,4,392,5,-1,277,1154,275,-1,277,205,1154,-1,368,21,366,-1,368,159,21,-1,27,374,1257,-1,27,372,374,-1,1444,56,1439,-1,56,1444,1263,-1,1298,1163,1162,-1,1298,359,1163,-1,1445,1259,1135,-1,1445,394,1259,-1,1440,1446,1441,-1,1440,1447,1446,-1,396,49,1143,-1,396,398,49,-1,406,1266,1118,-1,1266,406,405,-1,1448,1296,1416,-1,1296,1448,1169,-1,1449,1194,1269,-1,1449,334,1194,-1,1244,1246,1245,-1,1246,1244,12,-1,1409,1313,457,-1,1409,1450,1313,-1,1451,1129,1452,-1,1451,33,1129,-1,69,429,1438,-1,69,430,429,-1,214,1453,1430,-1,460,1453,214,-1,1408,1245,1246,-1,1408,1454,1245,-1,84,1239,1106,-1,1239,84,83,-1,138,1455,1113,-1,138,1274,1455,-1,117,171,141,-1,117,116,171,-1,125,1197,1173,-1,125,1234,1197,-1,1456,109,1457,-1,109,1456,1458,-1,110,1458,112,-1,110,109,1458,-1,133,1198,1275,-1,136,1198,133,-1,112,1459,1436,-1,1458,1459,112,-1,1165,1063,989,-1,1165,1226,1063,-1,1460,1461,1462,-1,1463,1461,1460,-1,1228,1431,1214,-1,1228,1229,1431,-1,1255,159,158,-1,1255,24,159,-1,9,161,1277,-1,9,146,161,-1,1310,1281,1223,-1,1464,1281,1310,-1,377,1224,1282,-1,1280,1224,377,-1,1465,436,435,-1,1465,1134,436,-1,1218,107,1132,-1,107,1218,1102,-1,1432,1217,178,-1,1432,1466,1217,-1,1435,1286,130,-1,1435,111,1286,-1,307,308,199,-1,307,1467,308,-1,202,206,1211,-1,202,1295,206,-1,441,1452,1117,-1,441,1468,1452,-1,77,429,155,-1,77,1438,429,-1,106,54,104,-1,106,1469,54,-1,1429,1428,1470,-1,1429,482,1428,-1,1102,1209,227,-1,1102,1210,1209,-1,1283,237,1471,-1,238,237,1283,-1,319,1208,1472,-1,1208,319,317,-1,1284,191,128,-1,1284,1172,191,-1,1191,35,34,-1,1421,35,1191,-1,1199,1427,1187,-1,1427,1199,1473,-1,279,224,278,-1,279,225,224,-1,266,1207,1473,-1,266,280,1207,-1,1474,1156,369,-1,1213,1156,1474,-1,324,331,322,-1,324,333,331,-1,1475,256,1476,-1,257,256,1475,-1,1288,1477,1478,-1,1288,289,1477,-1,1479,1189,1188,-1,1479,1480,1189,-1,1481,268,1253,-1,1481,269,268,-1,1180,240,1290,-1,1291,240,1180,-1,1291,297,1482,-1,1291,1182,297,-1,39,1183,41,-1,1483,1183,39,-1,1178,295,36,-1,42,295,1178,-1,208,118,470,-1,208,116,118,-1,1484,200,1212,-1,200,1484,1485,-1,1474,1486,1487,-1,1488,1486,1474,-1,1489,243,242,-1,1489,1490,243,-1,293,128,1185,-1,128,293,1284,-1,63,1460,1269,-1,63,1491,1460,-1,1492,1493,1494,-1,1495,1493,1492,-1,1416,341,1448,-1,1416,1496,341,-1,1167,1497,1498,-1,1168,1497,1167,-1,1164,1297,1166,-1,1297,1164,1414,-1,1298,348,1300,-1,348,1298,346,-1,360,1298,1300,-1,359,1298,360,-1,1158,452,455,-1,1160,452,1158,-1,144,1301,363,-1,144,143,1301,-1,174,357,356,-1,174,173,357,-1,1302,1499,1500,-1,1302,28,1499,-1,51,1154,1175,-1,51,75,1154,-1,483,1501,484,-1,1281,1501,483,-1,1151,1152,1305,-1,1151,45,1152,-1,1204,382,379,-1,1204,383,382,-1,1195,1502,1503,-1,1204,1502,1195,-1,1504,1503,1505,-1,1504,1506,1503,-1,1145,259,395,-1,1145,1307,259,-1,1507,391,390,-1,1259,391,1507,-1,385,1508,1441,-1,385,384,1508,-1,1509,1510,1511,-1,1509,1512,1510,-1,49,1509,1513,-1,49,48,1509,-1,1139,1308,1483,-1,1308,1139,1140,-1,1426,1447,1440,-1,1426,1411,1447,-1,1483,38,1139,-1,1483,39,38,-1,434,435,2,-1,434,1465,435,-1,1310,375,157,-1,1310,1223,375,-1,1279,77,155,-1,82,77,1279,-1,441,1453,1514,-1,441,440,1453,-1,1112,450,355,-1,80,450,1112,-1,1241,15,1455,-1,15,1241,1240,-1,1240,14,13,-1,1240,150,14,-1,91,1311,474,-1,273,1311,91,-1,1104,1103,473,-1,1103,1104,476,-1,11,180,1216,-1,11,310,180,-1,978,749,689,-1,978,692,749,-1,507,823,1349,-1,507,824,823,-1,828,510,1100,-1,828,830,510,-1,544,1515,552,-1,1091,1515,544,-1,985,991,986,-1,985,1095,991,-1,965,1516,958,-1,965,848,1516,-1,1517,1406,1405,-1,1517,1518,1406,-1,1355,1376,1356,-1,1355,535,1376,-1,868,865,869,-1,863,865,868,-1,541,1519,795,-1,540,1519,541,-1,548,550,793,-1,550,548,547,-1,1315,575,748,-1,946,575,1315,-1,946,572,575,-1,891,1520,1521,-1,1520,891,890,-1,747,1098,1084,-1,1098,747,948,-1,942,895,1371,-1,895,942,944,-1,577,913,591,-1,1398,913,577,-1,746,586,585,-1,746,1082,586,-1,937,588,590,-1,937,1070,588,-1,613,562,778,-1,562,613,1083,-1,1072,611,624,-1,1072,1400,611,-1,718,1078,630,-1,1322,1078,718,-1,582,1076,583,-1,582,1325,1076,-1,583,1522,584,-1,583,598,1522,-1,1020,598,600,-1,598,1020,1522,-1,1523,1401,604,-1,1401,1523,1524,-1,1069,1327,1067,-1,1068,1327,1069,-1,1092,1525,1093,-1,1092,1526,1525,-1,996,1346,670,-1,996,1527,1346,-1,652,646,678,-1,652,647,646,-1,631,496,495,-1,631,647,496,-1,1331,1528,1055,-1,1528,1331,1529,-1,952,831,950,-1,831,952,1057,-1,1364,1375,870,-1,1364,957,1375,-1,768,717,769,-1,717,768,1053,-1,928,952,951,-1,651,952,928,-1,618,1399,623,-1,618,602,1399,-1,1530,690,1531,-1,1393,690,1530,-1,1532,887,886,-1,1532,1521,887,-1,904,1520,938,-1,904,1533,1520,-1,1351,1534,1535,-1,1534,1351,1536,-1,723,1335,1537,-1,1335,723,722,-1,1036,782,1538,-1,1035,782,1036,-1,673,1034,620,-1,673,1033,1034,-1,520,1340,521,-1,1340,520,1383,-1,1042,1024,1341,-1,1041,1024,1042,-1,713,1539,1540,-1,713,712,1539,-1,1333,1384,1041,-1,1333,1338,1384,-1,732,858,1336,-1,732,731,858,-1,736,1541,1542,-1,736,722,1541,-1,1384,1022,1041,-1,1384,753,1022,-1,760,1543,1544,-1,1545,1543,760,-1,791,638,785,-1,791,794,638,-1,722,1540,1539,-1,1540,722,724,-1,1386,1475,1546,-1,1475,1386,257,-1,1545,759,1547,-1,1545,760,759,-1,1548,1479,725,-1,1548,1480,1479,-1,1096,1549,1097,-1,1096,1015,1549,-1,726,1012,1011,-1,1012,726,1550,-1,1551,1552,1550,-1,1551,1553,1552,-1,1552,961,1554,-1,961,1552,1357,-1,1344,1010,522,-1,525,1010,1344,-1,1054,960,1052,-1,859,960,1054,-1,682,780,911,-1,684,780,682,-1,1555,1005,1556,-1,1005,1555,561,-1,1530,1557,1558,-1,1557,1530,1531,-1,561,778,562,-1,561,1555,778,-1,924,1368,1367,-1,1317,1368,924,-1,998,1527,996,-1,1527,998,1036,-1,1346,721,1033,-1,721,1346,1559,-1,720,1341,764,-1,1042,1341,720,-1,1362,1560,1561,-1,1362,1562,1560,-1,787,995,1562,-1,796,995,787,-1,1562,1563,1560,-1,1562,995,1563,-1,1564,993,1565,-1,1564,1566,993,-1,993,1348,804,-1,1379,1348,993,-1,1567,505,880,-1,805,505,1567,-1,988,1069,986,-1,988,987,1069,-1,1067,986,1069,-1,986,1067,815,-1,816,632,980,-1,816,633,632,-1,981,1332,812,-1,981,656,1332,-1,1568,821,1569,-1,1568,979,821,-1,978,539,1004,-1,978,564,539,-1,1501,926,484,-1,926,1501,1331,-1,976,1352,973,-1,976,532,1352,-1,838,1027,1353,-1,838,837,1027,-1,1570,1019,1571,-1,1019,1570,1027,-1,1571,1504,1505,-1,1571,1572,1504,-1,968,1334,850,-1,968,1354,1334,-1,972,1573,1517,-1,972,970,1573,-1,534,1574,964,-1,534,1575,1574,-1,1576,962,1357,-1,1576,1577,962,-1,857,962,1578,-1,963,962,857,-1,1091,1039,1515,-1,594,1039,1091,-1,871,1374,1328,-1,871,546,1374,-1,424,877,1330,-1,424,423,877,-1,432,1529,1579,-1,432,883,1529,-1,1396,950,833,-1,1396,529,950,-1,552,869,544,-1,869,552,551,-1,1580,887,1533,-1,1580,1372,887,-1,895,946,896,-1,946,895,573,-1,502,588,1581,-1,1081,588,502,-1,497,1081,498,-1,497,641,1081,-1,931,580,918,-1,580,931,934,-1,1366,932,914,-1,916,932,1366,-1,709,661,707,-1,709,664,661,-1,1582,831,1057,-1,1582,1378,831,-1,1582,636,635,-1,636,1582,677,-1,919,921,920,-1,567,921,919,-1,913,581,1369,-1,913,1398,581,-1,910,908,579,-1,910,909,908,-1,894,899,1371,-1,899,894,897,-1,1583,1584,500,-1,1583,1585,1584,-1,888,557,889,-1,557,888,1360,-1,885,486,1586,-1,885,870,486,-1,648,504,893,-1,648,884,504,-1,1587,881,650,-1,881,1587,1060,-1,1579,1331,1501,-1,1529,1331,1579,-1,877,1561,1588,-1,876,1561,877,-1,874,790,788,-1,1373,790,874,-1,873,410,1589,-1,871,410,873,-1,524,1028,1337,-1,861,1028,524,-1,1029,1404,1336,-1,1029,1590,1404,-1,856,963,857,-1,856,1358,963,-1,1577,1578,962,-1,1577,1591,1578,-1,1591,1592,536,-1,1591,1512,1592,-1,841,1517,1405,-1,841,972,1517,-1,490,1334,489,-1,531,1334,490,-1,854,840,842,-1,840,854,1018,-1,1570,1353,1027,-1,1570,835,1353,-1,1516,1593,543,-1,1593,1516,533,-1,1569,825,1568,-1,1569,1350,825,-1,1569,1349,823,-1,821,1349,1569,-1,633,815,1067,-1,633,816,815,-1,983,897,982,-1,983,898,897,-1,807,1088,505,-1,807,984,1088,-1,801,1299,988,-1,801,343,1299,-1,1566,1379,993,-1,1566,799,1379,-1,1594,798,799,-1,1380,798,1594,-1,1380,1492,338,-1,1380,1595,1492,-1,540,1495,1519,-1,540,1267,1495,-1,1562,788,787,-1,788,1562,1362,-1,1526,1347,1403,-1,1526,1092,1347,-1,1013,618,620,-1,1013,616,618,-1,721,1032,1031,-1,721,1559,1032,-1,782,709,711,-1,782,1035,709,-1,617,769,717,-1,617,1013,769,-1,1043,1555,1556,-1,687,1555,1043,-1,1531,827,1557,-1,1531,1596,827,-1,929,770,771,-1,773,770,929,-1,694,1052,960,-1,1323,1052,694,-1,1357,1553,1576,-1,1552,1553,1357,-1,1554,1550,1552,-1,1550,1554,1012,-1,764,1383,765,-1,764,1342,1383,-1,1015,1597,1549,-1,1015,758,1597,-1,762,1598,1548,-1,1598,762,761,-1,1544,761,760,-1,761,1544,1598,-1,1599,1547,1600,-1,1547,1599,1545,-1,1386,1599,1542,-1,1386,1546,1599,-1,1339,755,754,-1,755,1339,1025,-1,1541,729,1387,-1,1541,1601,729,-1,745,1082,746,-1,1082,745,1602,-1,1333,493,1338,-1,1333,1030,493,-1,1542,1387,1386,-1,1542,1541,1387,-1,1336,1406,732,-1,1406,1336,1404,-1,1540,1038,713,-1,1038,1540,724,-1,1603,491,728,-1,1537,491,1603,-1,1341,1023,1342,-1,1024,1023,1341,-1,1597,726,1011,-1,1597,727,726,-1,1539,1541,722,-1,1539,1601,1541,-1,1392,1080,912,-1,1080,1392,592,-1,1538,1527,1036,-1,1538,1604,1527,-1,1317,716,1368,-1,1317,1037,716,-1,1367,706,924,-1,1367,705,706,-1,704,1593,976,-1,1593,704,703,-1,903,1533,904,-1,1580,1533,903,-1,892,947,945,-1,947,892,891,-1,1583,1602,745,-1,1602,1583,1397,-1,1574,1572,964,-1,1504,1572,1574,-1,774,1556,775,-1,774,1043,1556,-1,1382,645,680,-1,645,1382,826,-1,686,1381,687,-1,1381,686,674,-1,1558,1050,1530,-1,1558,1051,1050,-1,635,1378,1582,-1,635,1056,1378,-1,1529,1587,1528,-1,1587,1529,883,-1,678,1061,679,-1,678,646,1061,-1,997,670,1003,-1,997,996,670,-1,1017,638,794,-1,638,1017,639,-1,1463,1526,1605,-1,1526,1463,1525,-1,1606,1523,626,-1,1523,1606,1524,-1,1522,621,1607,-1,621,1522,1020,-1,1606,1522,1607,-1,584,1522,1606,-1,597,624,629,-1,597,1072,624,-1,626,584,1606,-1,626,628,584,-1,1608,1401,603,-1,1401,1608,605,-1,606,587,586,-1,606,1073,587,-1,1040,1515,1039,-1,1040,949,1515,-1,1397,1523,1602,-1,1397,626,1523,-1,625,1325,578,-1,1325,625,1076,-1,503,1084,893,-1,503,748,1084,-1,1371,1609,942,-1,1609,1371,899,-1,948,575,571,-1,747,575,948,-1,1584,902,500,-1,1584,903,902,-1,977,1610,829,-1,919,977,567,-1,977,919,1610,-1,1084,889,559,-1,889,1084,1098,-1,516,1360,888,-1,1361,1360,516,-1,900,555,938,-1,555,900,556,-1,1016,549,1611,-1,549,1016,793,-1,994,1380,1594,-1,994,1595,1380,-1,536,1575,534,-1,1575,536,1592,-1,1518,1573,1359,-1,1517,1573,1518,-1,848,533,1516,-1,533,848,1377,-1,1547,1015,756,-1,1015,1547,759,-1,949,552,1515,-1,949,553,552,-1,1337,1344,524,-1,1337,1007,1344,-1,1363,529,528,-1,529,1363,950,-1,748,1088,1315,-1,503,1088,748,-1,494,659,495,-1,494,509,659,-1,196,1612,148,-1,195,1612,196,-1,1613,1485,1484,-1,1613,480,1485,-1,1103,1614,373,-1,478,1614,1103,-1,465,464,466,-1,472,464,465,-1,454,1246,1159,-1,454,1408,1246,-1,453,452,451,-1,455,452,453,-1,1514,1468,441,-1,1450,1468,1514,-1,70,444,71,-1,1130,444,70,-1,2,215,1430,-1,2,435,215,-1,82,1433,1273,-1,82,1279,1433,-1,1615,422,1616,-1,422,1615,421,-1,412,329,413,-1,414,329,412,-1,1445,407,54,-1,1445,1135,407,-1,1137,1411,402,-1,1137,1447,1411,-1,1617,252,251,-1,1143,252,1617,-1,296,1511,1510,-1,1511,296,298,-1,384,396,1508,-1,384,1250,396,-1,1507,1306,1618,-1,1507,390,1306,-1,1145,3,5,-1,3,1145,46,-1,1195,1506,1251,-1,1503,1506,1195,-1,1502,1505,1503,-1,1619,1505,1502,-1,378,1620,1413,-1,1621,1620,378,-1,1223,376,375,-1,376,1223,1222,-1,371,1500,1499,-1,371,370,1500,-1,366,1500,368,-1,1500,366,1302,-1,349,143,350,-1,349,1301,143,-1,455,358,1158,-1,455,454,358,-1,1270,353,18,-1,1270,1161,353,-1,1299,1414,1164,-1,1299,343,1414,-1,342,1496,1168,-1,342,341,1496,-1,339,1448,341,-1,1448,339,1415,-1,1492,1415,338,-1,1492,1494,1415,-1,1495,1249,1493,-1,1495,1267,1249,-1,327,1417,328,-1,1126,1417,327,-1,65,1491,63,-1,65,1248,1491,-1,1284,292,234,-1,1284,293,292,-1,1490,152,1171,-1,1490,1489,152,-1,315,204,1419,-1,204,315,314,-1,1487,1213,1474,-1,1487,185,1213,-1,1304,1212,276,-1,1304,1484,1212,-1,1292,470,118,-1,470,1292,471,-1,297,1142,298,-1,1142,297,1182,-1,1291,241,240,-1,1291,1482,241,-1,1622,290,1189,-1,288,290,1622,-1,288,1623,289,-1,1622,1623,288,-1,1478,1624,1625,-1,1477,1624,1478,-1,1624,256,1626,-1,1624,1476,256,-1,263,1287,285,-1,262,1287,263,-1,246,1627,255,-1,246,1628,1627,-1,1629,438,1131,-1,1630,438,1629,-1,255,1626,256,-1,255,1627,1626,-1,7,1203,261,-1,7,6,1203,-1,281,266,283,-1,266,281,280,-1,1285,1628,246,-1,1628,1285,1265,-1,237,318,320,-1,318,237,236,-1,1200,1187,1186,-1,1187,1200,1199,-1,240,1631,1290,-1,240,239,1631,-1,1627,279,238,-1,1627,1628,279,-1,103,208,470,-1,102,208,103,-1,152,1472,1208,-1,152,1489,1472,-1,1209,1264,228,-1,1209,226,1264,-1,1470,220,1534,-1,1470,1428,220,-1,1470,216,1429,-1,1153,216,1470,-1,446,457,456,-1,457,446,1409,-1,215,212,213,-1,212,215,437,-1,1473,235,1427,-1,235,1473,1207,-1,1630,1113,438,-1,138,1113,1630,-1,1506,1574,1144,-1,1574,1506,1504,-1,1467,309,308,-1,1467,203,309,-1,1234,1198,1197,-1,1275,1198,1234,-1,1215,1487,1486,-1,1215,312,1487,-1,376,148,1612,-1,376,1222,148,-1,1122,1464,1310,-1,1410,1464,1122,-1,1214,1064,1228,-1,1064,1214,1049,-1,1220,466,464,-1,466,1220,150,-1,1462,1632,1128,-1,1461,1632,1462,-1,1436,1630,1629,-1,1436,1459,1630,-1,123,93,124,-1,1233,93,123,-1,1633,119,140,-1,1633,120,119,-1,87,120,1633,-1,1231,120,87,-1,1457,1435,132,-1,109,1435,1457,-1,1238,1276,1239,-1,1238,1231,1276,-1,92,139,1456,-1,92,137,139,-1,112,1633,110,-1,87,1633,112,-1,96,88,1437,-1,96,86,88,-1,1444,1133,108,-1,1444,1120,1133,-1,1459,138,1630,-1,1459,139,138,-1,1437,1436,1629,-1,1436,1437,88,-1,1232,134,83,-1,1233,134,1232,-1,1243,20,449,-1,1243,1422,20,-1,1634,451,1110,-1,453,451,1634,-1,1424,1116,1115,-1,1116,1424,1423,-1,461,214,17,-1,461,460,214,-1,1614,1303,373,-1,1303,478,1613,-1,1614,478,1303,-1,71,1243,69,-1,445,1243,71,-1,1468,1451,1452,-1,448,1451,1468,-1,1269,64,63,-1,1269,1268,64,-1,1494,1170,1169,-1,1494,1493,1170,-1,330,58,413,-1,330,59,58,-1,1575,48,50,-1,1592,48,1575,-1,1618,1447,1137,-1,1447,1618,1446,-1,1443,394,1445,-1,47,394,1443,-1,269,1478,286,-1,1288,1478,269,-1,1439,1120,1444,-1,1439,67,1120,-1,1179,1205,37,-1,1179,1176,1205,-1,44,1466,434,-1,1282,1466,44,-1,1270,1422,1260,-1,1422,1270,20,-1,175,10,1277,-1,175,1256,10,-1,1244,13,12,-1,1271,13,1244,-1,27,462,372,-1,27,26,462,-1,25,1257,75,-1,25,27,1257,-1,1130,78,443,-1,1130,70,78,-1,1465,1466,1432,-1,1465,434,1466,-1,46,1151,3,-1,46,45,1151,-1,1259,1136,1135,-1,1136,1259,1507,-1,1441,1617,1442,-1,1617,1441,1508,-1,1508,1143,1617,-1,396,1143,1508,-1,1415,1169,1448,-1,1415,1494,1169,-1,61,334,1449,-1,332,334,61,-1,1109,457,1313,-1,458,457,1109,-1,1271,16,13,-1,1107,16,1271,-1,440,1430,1453,-1,440,2,1430,-1,442,1273,76,-1,82,1273,442,-1,80,1111,450,-1,80,79,1111,-1,453,1454,1408,-1,453,1634,1454,-1,85,1434,468,-1,85,84,1434,-1,1455,17,1113,-1,17,1455,15,-1,1455,98,1241,-1,98,1455,1274,-1,209,101,96,-1,101,209,102,-1,1134,1120,436,-1,1120,1134,1133,-1,123,1272,135,-1,122,1272,123,-1,136,1456,1457,-1,1456,136,92,-1,132,136,1457,-1,1198,136,132,-1,1459,1456,139,-1,1458,1456,1459,-1,1491,1463,1460,-1,1525,1463,1491,-1,324,1194,333,-1,1268,1194,324,-1,154,311,188,-1,154,153,311,-1,1229,194,1431,-1,1229,162,194,-1,1214,196,147,-1,1214,1431,196,-1,1157,1256,1255,-1,1157,10,1256,-1,1280,195,165,-1,195,1280,1612,-1,1294,1487,312,-1,1294,185,1487,-1,1174,1486,207,-1,1486,1174,1215,-1,184,197,1213,-1,184,198,197,-1,1211,205,277,-1,1211,206,205,-1,208,169,116,-1,208,1138,169,-1,1451,447,1312,-1,448,447,1451,-1,1514,460,459,-1,460,1514,1453,-1,1469,216,1152,-1,106,216,1469,-1,218,482,481,-1,218,1428,482,-1,108,1132,107,-1,1133,1132,108,-1,319,1635,320,-1,1472,1635,319,-1,1188,1636,1479,-1,241,1636,1188,-1,1253,1184,1481,-1,295,1184,1253,-1,8,1635,242,-1,1635,8,1471,-1,318,278,224,-1,236,278,318,-1,1440,247,1426,-1,1442,247,1440,-1,247,250,248,-1,250,247,251,-1,1637,1147,1146,-1,1638,1147,1637,-1,1283,263,284,-1,1283,261,263,-1,1202,280,6,-1,1202,1207,280,-1,1254,1193,1190,-1,1262,1193,1254,-1,1191,1258,1200,-1,1190,1258,1191,-1,1497,1616,425,-1,1497,1639,1616,-1,1125,425,1616,-1,1125,426,425,-1,1471,261,1283,-1,1471,8,261,-1,1425,285,1625,-1,284,285,1425,-1,1475,1640,1641,-1,1475,1476,1640,-1,1287,267,285,-1,1287,1192,267,-1,1623,1641,1640,-1,1641,1623,1642,-1,1631,269,1481,-1,1631,287,269,-1,1421,292,291,-1,1421,1186,292,-1,1420,1482,297,-1,1643,1482,1420,-1,1181,1483,1308,-1,1181,1183,1483,-1,170,1138,1309,-1,1138,170,169,-1,201,1485,302,-1,1485,201,200,-1,369,1488,1474,-1,369,1155,1488,-1,1419,203,1467,-1,203,1419,204,-1,1289,231,1221,-1,1289,1185,231,-1,221,319,222,-1,221,317,319,-1,243,233,1206,-1,243,1490,233,-1,1286,1185,128,-1,1286,1235,1185,-1,1639,1615,1616,-1,1639,1418,1615,-1,330,325,322,-1,325,330,326,-1,1269,1462,1449,-1,1462,1269,1460,-1,337,325,328,-1,337,336,325,-1,1496,1418,1639,-1,1418,1496,1416,-1,340,345,344,-1,340,339,345,-1,425,1498,1497,-1,425,1123,1498,-1,1414,342,1297,-1,342,1414,345,-1,1498,348,1167,-1,352,348,1498,-1,1160,355,452,-1,355,1160,354,-1,1220,356,151,-1,356,1220,174,-1,371,1155,369,-1,371,52,1155,-1,1469,1445,54,-1,1443,1445,1469,-1,379,1502,1204,-1,379,1413,1502,-1,386,1250,384,-1,1196,1250,386,-1,260,1307,387,-1,260,259,1307,-1,1446,385,1441,-1,1446,1149,385,-1,1592,1509,48,-1,1592,1512,1509,-1,1513,1511,1141,-1,1513,1509,1511,-1,1140,250,1412,-1,1140,1139,250,-1,1442,251,247,-1,1442,1617,251,-1,254,37,1205,-1,37,254,401,-1,410,411,1589,-1,411,410,409,-1,1126,421,1615,-1,421,1126,417,-1,428,1616,422,-1,1125,1616,428,-1,426,167,427,-1,426,168,167,-1,1281,1579,1501,-1,1579,1281,1464,-1,1124,1122,163,-1,1278,1122,1124,-1,19,164,449,-1,19,1225,164,-1,1224,1466,1282,-1,1224,1217,1466,-1,213,438,1113,-1,212,438,213,-1,1312,33,1451,-1,1114,33,1312,-1,1454,458,1245,-1,1454,1407,458,-1,1105,468,89,-1,1105,467,468,-1,90,469,274,-1,90,1434,469,-1,480,478,477,-1,478,480,1613,-1,217,482,1429,-1,229,482,217,-1,244,218,245,-1,244,219,218,-1,498,1319,499,-1,1319,498,554,-1,907,510,830,-1,907,511,510,-1,1100,512,564,-1,1100,510,512,-1,569,1360,642,-1,569,557,1360,-1,1363,1375,1395,-1,1363,528,1375,-1,1352,531,490,-1,1352,532,531,-1,959,965,958,-1,851,965,959,-1,1590,1405,1404,-1,1644,1405,1590,-1,1356,1644,1590,-1,1644,1356,1376,-1,1374,792,789,-1,1374,548,792,-1,795,1595,994,-1,795,1519,1595,-1,542,1089,1403,-1,542,639,1089,-1,947,1521,1532,-1,1521,947,891,-1,501,554,498,-1,554,501,936,-1,1586,1372,1580,-1,1586,486,1372,-1,1321,574,568,-1,574,1321,1402,-1,944,573,895,-1,944,1365,573,-1,940,899,1370,-1,940,1609,899,-1,1398,576,910,-1,1398,577,576,-1,500,1581,1583,-1,502,1581,500,-1,1070,1581,588,-1,627,1581,1070,-1,593,695,587,-1,592,695,593,-1,949,957,1364,-1,1040,957,949,-1,1320,1075,1074,-1,1075,1320,613,-1,1077,676,1001,-1,1077,599,676,-1,1399,1607,621,-1,1607,1399,601,-1,1400,605,1608,-1,605,1400,1072,-1,609,1608,615,-1,609,1400,1608,-1,583,1075,612,-1,1075,583,1076,-1,1602,604,1082,-1,1602,1523,604,-1,1632,1645,955,-1,1645,1632,1461,-1,589,935,905,-1,641,935,589,-1,1064,1048,1065,-1,1049,1048,1064,-1,1060,655,654,-1,1060,882,655,-1,636,1048,1047,-1,636,679,1048,-1,509,681,644,-1,509,494,681,-1,677,1057,1046,-1,1582,1057,677,-1,1558,1345,1051,-1,1558,665,1345,-1,1530,1002,1393,-1,1050,1002,1530,-1,1020,1077,1021,-1,1077,1020,600,-1,680,666,1382,-1,680,1394,666,-1,692,693,749,-1,692,691,693,-1,1323,1392,1324,-1,1323,694,1392,-1,1391,885,1585,-1,699,885,1391,-1,900,943,901,-1,890,943,900,-1,704,1535,1390,-1,1535,704,1351,-1,220,1535,1534,-1,220,705,1535,-1,1603,782,781,-1,782,1603,1538,-1,1479,1389,725,-1,1479,1636,1389,-1,767,1097,1549,-1,1097,767,766,-1,1038,723,781,-1,724,723,1038,-1,1601,925,729,-1,923,925,1601,-1,1384,750,752,-1,1338,750,1384,-1,751,1385,1026,-1,751,492,1385,-1,966,1637,967,-1,1637,966,1638,-1,755,1335,737,-1,755,1026,1335,-1,738,1014,741,-1,1014,738,1316,-1,742,1340,1023,-1,1340,742,741,-1,1588,1565,879,-1,1588,1564,1565,-1,879,953,1588,-1,879,954,953,-1,1026,1537,1335,-1,1026,491,1537,-1,754,736,1600,-1,736,754,737,-1,1543,1475,1641,-1,1543,1546,1475,-1,757,1339,754,-1,757,740,1339,-1,1641,1544,1543,-1,1642,1544,1641,-1,762,725,727,-1,762,1548,725,-1,1389,1550,726,-1,1389,1551,1550,-1,1553,1643,1420,-1,1553,1551,1643,-1,1646,1554,961,-1,1646,1343,1554,-1,765,519,768,-1,520,519,765,-1,912,780,607,-1,911,780,912,-1,772,565,688,-1,772,566,565,-1,1382,1558,1557,-1,1382,665,1558,-1,687,778,1555,-1,1381,778,687,-1,1527,1559,1346,-1,1527,1604,1559,-1,1561,1564,1588,-1,1561,1560,1564,-1,784,792,785,-1,786,792,784,-1,1645,1089,1611,-1,1605,1089,1645,-1,784,796,787,-1,784,797,796,-1,1560,1566,1564,-1,1563,1566,1560,-1,800,340,344,-1,800,798,340,-1,1567,879,1565,-1,1567,880,879,-1,1379,801,1348,-1,800,801,1379,-1,802,1567,803,-1,1567,802,805,-1,896,810,894,-1,808,810,896,-1,812,935,640,-1,1332,935,812,-1,1596,825,827,-1,1596,538,825,-1,1004,538,1596,-1,1004,539,538,-1,1378,1055,832,-1,1056,1055,1378,-1,1620,836,835,-1,836,1620,1621,-1,1505,1570,1571,-1,1570,1505,1619,-1,1572,1019,1094,-1,1019,1572,1571,-1,1354,969,844,-1,1354,968,969,-1,850,531,1377,-1,850,1334,531,-1,970,851,1573,-1,970,852,851,-1,1376,842,1644,-1,1376,854,842,-1,1577,296,1510,-1,1576,296,1577,-1,855,1590,1029,-1,1590,855,1356,-1,733,1359,864,-1,733,1518,1359,-1,867,1516,543,-1,867,958,1516,-1,790,1328,789,-1,1328,790,1373,-1,876,1362,1561,-1,875,1362,876,-1,1588,1330,877,-1,1330,1588,953,-1,654,954,878,-1,654,653,954,-1,1528,650,1329,-1,1528,1587,650,-1,1396,1402,1321,-1,1396,1059,1402,-1,745,1585,1583,-1,1585,745,1391,-1,1521,1533,887,-1,1533,1521,1520,-1,1318,898,811,-1,1318,1370,898,-1,905,933,589,-1,933,905,915,-1,1610,1366,829,-1,1366,1610,919,-1,1367,702,1390,-1,702,1367,715,-1,706,244,730,-1,706,219,244,-1,663,927,928,-1,663,776,927,-1,771,921,929,-1,921,771,922,-1,907,829,915,-1,907,830,829,-1,579,932,918,-1,932,579,908,-1,1369,580,934,-1,581,580,1369,-1,939,1609,940,-1,939,901,1609,-1,1365,701,571,-1,945,701,1365,-1,901,942,1609,-1,901,943,942,-1,642,1532,886,-1,1361,1532,642,-1,744,1391,745,-1,1391,744,700,-1,570,1059,1058,-1,1059,570,1402,-1,832,1528,1329,-1,832,1055,1528,-1,1328,415,408,-1,1328,1373,415,-1,955,1589,1632,-1,873,1589,955,-1,743,735,868,-1,734,735,743,-1,523,1646,1358,-1,523,522,1646,-1,1518,732,1406,-1,1518,733,732,-1,961,1358,1646,-1,963,1358,961,-1,1591,1355,1578,-1,1591,536,1355,-1,1510,1591,1577,-1,1510,1512,1591,-1,1644,841,1405,-1,1644,842,841,-1,533,976,1593,-1,532,976,533,-1,971,970,972,-1,839,970,971,-1,1619,835,1570,-1,1619,1620,835,-1,836,1638,966,-1,1621,1638,836,-1,973,1536,1351,-1,975,1536,973,-1,1568,538,537,-1,538,1568,825,-1,979,537,515,-1,537,979,1568,-1,823,1350,1569,-1,823,643,1350,-1,894,982,897,-1,982,894,810,-1,991,809,806,-1,809,991,1095,-1,802,991,806,-1,992,991,802,-1,1348,988,990,-1,801,988,1348,-1,1565,803,1567,-1,803,1565,993,-1,799,1563,1594,-1,799,1566,1563,-1,1519,1492,1595,-1,1492,1519,1495,-1,1605,1403,1089,-1,1605,1526,1403,-1,620,763,1013,-1,1034,763,620,-1,1032,1604,728,-1,1032,1559,1604,-1,1051,1003,1000,-1,1051,1345,1003,-1,1596,690,1004,-1,1596,1531,690,-1,607,1392,912,-1,607,1324,1392,-1,766,526,519,-1,526,766,527,-1,1343,522,1010,-1,522,1343,1646,-1,1420,1576,1553,-1,1576,1420,296,-1,1012,1343,1009,-1,1012,1554,1343,-1,1636,1551,1389,-1,1551,1636,1643,-1,758,727,1597,-1,758,762,727,-1,1647,1548,1598,-1,1647,1480,1548,-1,1544,1647,1598,-1,1544,1642,1647,-1,1546,1545,1599,-1,1545,1546,1543,-1,1542,1600,736,-1,1542,1599,1600,-1,751,1339,750,-1,1025,1339,751,-1,1388,1387,729,-1,1387,1388,257,-1,955,1611,549,-1,1645,1611,955,-1,911,934,682,-1,911,1369,934,-1,826,1557,827,-1,1557,826,1382,-1,967,393,489,-1,393,967,1637,-1,712,1601,1539,-1,712,923,1601,-1,1537,781,723,-1,1537,1603,781,-1,1023,1383,1342,-1,1023,1340,1383,-1,1549,1011,767,-1,1549,1597,1011,-1,728,1538,1603,-1,1538,728,1604,-1,1317,712,1037,-1,1317,923,712,-1,705,1390,1535,-1,705,1367,1390,-1,543,703,1090,-1,543,1593,703,-1,1066,570,1058,-1,1066,558,570,-1,1585,1586,1584,-1,885,1586,1585,-1,964,1094,853,-1,1572,1094,964,-1,775,1005,1044,-1,775,1556,1005,-1,777,1393,1002,-1,777,691,1393,-1,951,1395,662,-1,951,1363,1395,-1,596,707,956,-1,708,707,596,-1,1056,634,926,-1,635,634,1056,-1,882,1587,883,-1,1060,1587,882,-1,1061,1068,1065,-1,1327,1068,1061,-1,824,644,643,-1,824,1099,644,-1,679,1065,1048,-1,679,1061,1065,-1,1461,1605,1645,-1,1605,1461,1463,-1,1063,987,989,-1,1063,1326,987,-1,615,603,602,-1,615,1608,603,-1,1524,603,1401,-1,1524,601,603,-1,601,1606,1607,-1,1524,1606,601,-1,1021,1001,999,-1,1021,1077,1001,-1,1322,608,1078,-1,1322,1324,608,-1,1581,1397,1583,-1,1581,627,1397,-1,629,577,591,-1,578,577,629,-1,941,1370,1318,-1,941,940,1370,-1,1580,1584,1586,-1,1584,1580,903,-1,1320,563,1083,-1,1320,1079,563,-1,1066,559,558,-1,1066,1085,559,-1,1361,947,1532,-1,1361,516,947,-1,938,890,900,-1,938,1520,890,-1,1318,1319,941,-1,499,1319,1318,-1,1017,1611,1089,-1,1017,1016,1611,-1,995,1594,1563,-1,994,1594,995,-1,862,1028,731,-1,862,735,1028,-1,1359,851,959,-1,1573,851,1359,-1,4,1352,490,-1,974,1352,4,-1,756,1600,1547,-1,756,754,1600,-1,957,1395,1375,-1,660,1395,957,-1,1096,1316,757,-1,1014,1316,1096,-1,855,1578,1355,-1,855,857,1578,-1,1321,529,1396,-1,529,1321,530,-1,658,513,906,-1,658,514,513,-1,906,511,907,-1,906,513,511,-1,377,1612,1280,-1,377,376,1612,-1,179,221,1218,-1,179,182,221,-1,1285,481,1265,-1,245,481,1285,-1,480,302,1485,-1,479,302,480,-1,373,462,472,-1,373,372,462,-1,1104,89,474,-1,1105,89,1104,-1,91,274,273,-1,274,91,90,-1,1634,1407,1454,-1,1634,456,1407,-1,1114,79,1115,-1,79,1114,1312,-1,1110,456,1634,-1,1110,446,456,-1,1452,443,1117,-1,443,1452,1129,-1,1118,1439,56,-1,68,1439,1118,-1,1282,1433,1121,-1,1282,44,1433,-1,1464,432,1579,-1,1464,1410,432,-1,421,423,422,-1,421,420,423,-1,415,412,408,-1,415,414,412,-1,413,57,409,-1,413,58,57,-1,1589,1128,1632,-1,1128,1589,411,-1,253,270,1266,-1,270,253,271,-1,108,1263,1444,-1,1263,108,105,-1,1141,1412,1513,-1,1412,1141,1140,-1,1141,298,1142,-1,1141,1511,298,-1,1574,50,1144,-1,1574,1575,50,-1,1618,1149,1446,-1,1618,1306,1149,-1,1152,1443,1469,-1,1443,1152,45,-1,1306,1150,1149,-1,1150,1306,381,-1,1413,1619,1502,-1,1413,1620,1619,-1,1638,378,1147,-1,378,1638,1621,-1,1536,1305,1153,-1,1305,1536,975,-1,52,1499,53,-1,371,1499,52,-1,53,28,1261,-1,1499,28,53,-1,370,368,1500,-1,370,160,368,-1,1301,1163,1252,-1,1163,1301,349,-1,351,1166,1162,-1,351,1164,1166,-1,351,1165,1164,-1,18,1498,1123,-1,1498,18,352,-1,1297,1168,347,-1,1168,1297,342,-1,1168,1639,1497,-1,1168,1496,1639,-1,1296,328,1417,-1,328,1296,337,-1,1418,1126,1615,-1,1418,1417,1126,-1,1187,234,292,-1,234,1187,1427,-1,233,1171,1172,-1,1490,1171,233,-1,152,181,153,-1,1208,181,152,-1,228,481,482,-1,481,228,1264,-1,1293,1155,1175,-1,1293,1488,1155,-1,307,1419,1467,-1,74,1419,307,-1,1292,272,471,-1,272,1292,306,-1,1309,316,170,-1,316,1309,399,-1,41,1179,39,-1,1179,41,40,-1,1308,1182,1181,-1,1142,1182,1308,-1,1183,1180,294,-1,1183,1181,1180,-1,1643,241,1482,-1,1643,1636,241,-1,239,287,1631,-1,239,290,287,-1,1189,1647,1622,-1,1189,1480,1647,-1,1647,1623,1622,-1,1647,1642,1623,-1,1477,1476,1624,-1,1640,1476,1477,-1,1625,1626,1425,-1,1625,1624,1626,-1,1287,1203,281,-1,1203,1287,262,-1,255,1388,246,-1,257,1388,255,-1,1449,1128,61,-1,1128,1449,1462,-1,1640,289,1623,-1,289,1640,1477,-1,1199,266,1473,-1,266,1199,264,-1,1627,1425,1626,-1,1627,238,1425,-1,393,1146,5,-1,1637,1146,393,-1,1628,225,279,-1,1628,1265,225,-1,320,1471,237,-1,320,1635,1471,-1,1421,1200,1186,-1,1421,1191,1200,-1,1290,1481,1184,-1,1290,1631,1481,-1,1472,242,1635,-1,1489,242,1472,-1,225,1264,226,-1,225,1265,1264,-1,1534,1153,1470,-1,1536,1153,1534,-1,1450,459,1313,-1,1450,1514,459,-1,1251,1144,397,-1,1144,1251,1506,-1,1293,1486,1488,-1,1486,1293,207,-1,306,304,272,-1,306,305,304,-1,207,1295,1174,-1,207,206,1295,-1,183,198,184,-1,187,198,183,-1,1224,1216,1217,-1,1216,1224,1101,-1,1221,299,1289,-1,300,299,1221,-1,149,1222,483,-1,1222,149,148,-1,1122,433,1410,-1,433,1122,1278,-1,1227,1229,1228,-1,1229,1227,1230,-1,162,145,194,-1,162,146,145,-1,324,64,1268,-1,64,324,323,-1,1525,1248,1093,-1,1525,1491,1248,-1,1230,351,350,-1,351,1230,1227,-1,1239,101,1106,-1,1239,1276,101,-1,110,140,111,-1,110,1633,140,-1,1233,94,93,-1,1233,1232,94,-1,141,230,232,-1,230,141,171,-1,121,1231,1238,-1,121,120,1231,-1,73,122,315,-1,1242,122,73,-1,1241,100,1314,-1,1241,98,100,-1,1437,1131,97,-1,1437,1629,1131,-1,469,84,1106,-1,84,469,1434,-1,450,1110,451,-1,1111,1110,450,-1,1613,1304,1303,-1,1613,1484,1304,-1,72,1272,1242,-1,72,1237,1272,-1,2,439,0,-1,440,439,2,-1,445,1423,1243,-1,1116,1423,445,-1,1450,448,1468,-1,1409,448,1450,-1,1424,1260,1422,-1,1424,1112,1260,-1,1424,81,1112,-1,60,59,332,-1,1127,59,60,-1,1493,335,1170,-1,335,1493,1249,-1,335,65,64,-1,335,1249,65,-1,254,403,249,-1,254,253,403,-1,1507,1137,1136,-1,1137,1507,1618,-1,1151,4,3,-1,4,1151,974,-1,1625,286,1478,-1,1625,285,286,-1,1432,1134,1465,-1,1134,1432,177,-1,1262,268,267,-1,268,1262,1254,-1,1513,252,49,-1,1513,1412,252,-1,44,1273,1433,-1,43,1273,44,-1,30,1219,463,-1,30,29,1219,-1,26,463,462,-1,26,30,463,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c7_Coord',point=[(-.39589,52.56039,-1.74983),(-.40569,52.58166,-1.71808),(-.46109,52.56315,-1.69313),(-.07777,52.34705,-1.59057),(0,52.35076,-1.58532),(-.07216,52.34378,-1.54112),(-.36135,52.85065,-1.30414),(-.34188,52.83687,-1.31763),(-.32661,52.8493,-1.37313),(-.31494,52.81045,-1.69123),(-.33221,52.89247,-1.62181),(-.34903,52.82706,-1.63149),(-.7671,52.47864,-1.72377),(-.72905,52.49666,-1.68465),(-.76538,52.53043,-1.67188),(-.68262,52.54324,-1.6586),(-.6969,52.51408,-1.67105),(-.64794,52.53855,-1.66012),(-.33729,52.39066,-2.07589),(-.19017,52.37194,-2.08453),(-.32809,52.38999,-2.03098),(-.43104,52.82615,-1.64942),(-.42143,52.81362,-1.65626),(-.49917,52.76848,-1.68801),(-.36588,52.89706,-1.63051),(-.87028,52.79256,-1.59066),(-.85175,52.75458,-1.61007),(-.89419,52.79228,-1.57143),(-.68722,52.80974,-1.63175),(-.71025,52.7599,-1.67294),(-.78516,52.75517,-1.63958),(-.34194,52.37285,-1.95586),(-.3307,52.38407,-1.94722),(-.37849,52.40342,-1.92884),(-.43215,52.6971,-1.14178),(-.45342,52.70889,-1.13979),(-.45385,52.67424,-1.14471),(-.43425,52.43386,-1.23211),(-.3972,52.38306,-1.18601),(-.38445,52.45176,-1.16891),(-.44771,52.52421,-1.18751),(-.38701,52.51854,-1.14218),(-.38563,52.59688,-1.1223),(-.34175,52.54909,-1.78527),(-.33408,52.5811,-1.76591),(-.13766,52.36625,-1.59836),(-.13868,52.35687,-1.59018),(-.22517,52.37625,-1.58867),(-.06606,52.15704,-1.10078),(-.15064,52.16456,-1.1018),(-.06753,52.15528,-1.1126),(-.79939,52.91105,-1.53911),(-.7293,52.95472,-1.51207),(-.79297,52.86941,-1.57117),(-.28363,52.45291,-1.5658),(-.34268,52.4798,-1.51403),(-.3449,52.51172,-1.52269),(-.08153,52.56846,-2.7708),(-.08472,52.56486,-2.75059),(-.14969,52.59372,-2.83537),(-.15044,52.65883,-2.84167),(-.15237,52.67657,-2.84342),(-.1137,52.6021,-2.83887),(-.08089,52.7907,-2.65911),(-.09165,52.78395,-2.65809),(-.07736,52.78915,-2.65475),(-.4467,52.53829,-1.5199),(-.41159,52.54654,-1.54749),(-.42723,52.52638,-1.49839),(-.2528,52.39651,-1.97189),(-.28598,52.44524,-1.90822),(-.26776,52.39534,-1.96297),(-.73879,52.61381,-1.34275),(-.75316,52.63718,-1.35704),(-.84818,52.64194,-1.35234),(-.86234,52.87148,-1.54932),(-.34564,52.53856,-1.78858),(-.29474,52.48633,-1.87384),(-.30008,52.47686,-1.86834),(-.44566,52.31725,-2.00333),(-.44557,52.31863,-2.01094),(-.38089,52.31535,-2.01536),(-.30687,52.50424,-1.84582),(-.71864,52.53262,-1.45209),(-.73091,52.52233,-1.45987),(-.73927,52.54787,-1.49741),(-.60574,52.53019,-1.4047),(-.60346,52.54895,-1.40286),(-.59837,52.53401,-1.42169),(-.88803,52.55665,-1.52108),(-.80927,52.51722,-1.47569),(-.89435,52.53883,-1.49083),(-.64841,52.59526,-1.50275),(-.69789,52.61314,-1.48403),(-.70352,52.5809,-1.50219),(-.55727,52.49269,-1.38028),(-.59824,52.51278,-1.391),(-.54144,52.49772,-1.42821),(-.70735,52.56677,-1.54475),(-.71285,52.55683,-1.51692),(-.73745,52.56719,-1.54905),(-.65783,52.50358,-1.39661),(-.67088,52.50526,-1.3744),(-.73043,52.501,-1.3969),(-.28718,52.50329,-1.55547),(-.29748,52.57133,-1.54322),(-.21549,52.48932,-1.5887),(-.2988,52.62611,-1.53754),(-.33131,52.58084,-1.54336),(-.58149,52.62926,-1.43488),(-.57667,52.61592,-1.41109),(-.5654,52.6493,-1.39292),(-.59067,52.56654,-1.43422),(-.74053,52.7573,-1.41088),(-.7054,52.72315,-1.44261),(-.72054,52.77409,-1.43617),(-.68438,52.58629,-1.30855),(-.68488,52.59416,-1.33483),(-.73636,52.58307,-1.32403),(-.63877,52.58771,-1.3502),(-.64324,52.56428,-1.3731),(-.69004,52.55219,-1.39463),(-.74854,52.67998,-1.39612),(-.73591,52.63464,-1.43263),(-.7131,52.66122,-1.44825),(-.65838,52.79355,-1.4395),(-.64435,52.84125,-1.43162),(-.68876,52.83472,-1.42265),(-.50863,52.70586,-1.34147),(-.51925,52.71733,-1.39512),(-.55,52.69397,-1.40508),(-.57782,52.71688,-1.4215),(-.59348,52.68612,-1.43418),(-.68408,52.66324,-1.46193),(-.71288,52.55855,-1.43248),(-.7155,52.58384,-1.40339),(-.63955,52.64969,-1.46834),(-.65466,52.57637,-1.51962),(-.63232,52.5632,-1.53505),(-.62573,52.56687,-1.50293),(-.58899,52.61516,-1.34016),(-.64167,52.59584,-1.32405),(-.23366,52.79618,-1.84914),(-.23687,52.79899,-1.85053),(-.27589,52.80825,-1.78168),(-.27047,52.76354,-1.78552),(-.27316,52.7856,-1.784),(-.10541,52.71178,-1.94902),(-.162,52.68042,-1.92342),(-.1015,52.6876,-1.96704),(-.77058,52.56612,-1.65445),(-.77573,52.60139,-1.73762),(-.39447,52.77428,-1.45009),(-.41843,52.78397,-1.48346),(-.46626,52.79738,-1.45959),(-.25346,52.49979,-1.90383),(-.21072,52.45537,-1.97758),(-.20017,52.52751,-1.94611),(-.4509,53.00251,-1.53168),(-.45848,52.89134,-1.60619),(-.49766,52.93597,-1.55526),(-.27259,52.80594,-1.7791),(-.23746,52.77447,-1.85692),(-.15987,52.46783,-2.02993),(-.19144,52.43261,-2.01109),(-.2671,52.73187,-1.7903),(-.05478,52.44541,-2.21273),(-.09073,52.40789,-2.19214),(-.09409,52.40682,-2.22829),(-.63407,52.56186,-1.29202),(-.60457,52.55776,-1.27678),(-.64324,52.58515,-1.29301),(-.60144,52.7644,-1.69034),(-.59424,52.72484,-1.7494),(-.70585,52.69337,-1.72528),(-.3183,52.87665,-1.67661),(-.40248,52.81349,-1.69524),(-.38764,52.64216,-1.57362),(-.37386,52.69758,-1.60622),(-.3781,52.68638,-1.54921),(-.36343,52.78853,-1.5786),(-.38899,52.76017,-1.50759),(-.3769,52.72898,-1.52052),(-.43875,52.88896,-1.50938),(-.45409,52.91216,-1.49977),(-.53528,52.91803,-1.43615),(-.43278,52.89318,-1.51201),(-.43275,52.89967,-1.51495),(-.522,52.85644,-1.45609),(-.5597,52.81457,-1.45145),(-.50064,52.76464,-1.44162),(-.47547,52.75505,-1.37379),(-.73731,52.69999,-1.41616),(-.77999,52.78121,-1.4001),(-.23176,52.74667,-1.87107),(-.21656,52.71518,-1.87156),(-.16867,52.71492,-1.91818),(-.44118,52.99563,-1.51275),(-.44112,52.91081,-1.50952),(-1.02884,52.66727,-1.37967),(-1.09401,52.67372,-1.39962),(-1.06351,52.61515,-1.38698),(-.83826,52.80153,-1.40446),(-.88358,52.75708,-1.42106),(-.8131,52.74141,-1.39834),(-.8404,52.9144,-1.43766),(-.81711,52.883,-1.39837),(-.76635,52.91355,-1.39814),(-.68499,52.51241,-1.34742),(-.61571,52.5118,-1.35979),(-.5632,52.50288,-1.33479),(-.51027,52.44635,-1.33943),(-.49435,52.54183,-1.56129),(-.5419,52.54586,-1.6106),(-.57643,52.5241,-1.67046),(-.50165,52.56122,-1.63293),(-.12908,52.45507,-1.59207),(-.21838,52.5578,-1.57172),(-.08436,52.7042,-1.46465),(0,52.69315,-1.47287),(0,52.59834,-1.50194),(-.32716,52.7174,-1.5151),(-.29769,52.75477,-1.47254),(-.25657,52.75334,-1.4792),(-.21393,52.7954,-1.43931),(-.18665,52.78467,-1.43367),(-.22468,52.74629,-1.47533),(-.26215,52.62705,-1.54257),(-.19981,52.65683,-1.51733),(-.20518,52.62826,-1.53978),(-.61042,52.58683,-1.28037),(-.56978,52.63915,-1.30142),(-.60221,52.59826,-1.32347),(-.42562,52.84776,-1.30583),(-.45001,52.8589,-1.23966),(-.40334,52.89583,-1.26496),(-.24323,52.8022,-1.42579),(-.27147,52.81111,-1.40795),(-.25321,52.76288,-1.36288),(-.14227,52.61736,-.94318),(-.14451,52.59975,-.93502),(-.05663,52.58964,-.92905),(-.33704,52.85142,-1.38826),(-.38239,52.87191,-1.3453),(0,52.75606,-1.43723),(-.09022,52.75872,-1.44076),(-.0919,52.76529,-1.42538),(-.39673,52.25611,-1.2271),(-.40029,52.32152,-1.20519),(-.41583,52.36391,-1.28457),(-.33555,52.28493,-1.13303),(-.34244,52.22831,-1.15281),(-.25488,52.1945,-1.12288),(-.44822,52.42299,-1.37409),(-.46916,52.40466,-1.30749),(-.06835,52.72637,-1.35003),(-.06265,52.72347,-1.34515),(0,52.71726,-1.3557),(-.17721,52.35239,-1.4309),(-.15928,52.35065,-1.44553),(-.15657,52.37479,-1.41247),(-.31128,52.80865,-1.33106),(-.32483,52.7961,-1.29591),(-.29695,52.76725,-1.29679),(-.41596,52.8428,-1.14585),(-.4077,52.82444,-1.16302),(-.40131,52.861,-1.21229),(-.3193,52.69959,-1.1858),(-.33947,52.68621,-1.15993),(-.26683,52.67459,-1.09551),(-.49646,52.48347,-1.43009),(-.5065,52.4433,-1.3792),(-.93732,52.50741,-1.3798),(-.91134,52.50921,-1.43149),(-.82442,52.49424,-1.42381),(-.95694,52.85158,-1.47398),(-1.01305,52.80461,-1.43357),(-.93399,52.84708,-1.45253),(-.21739,52.79746,-1.42043),(-.19011,52.78673,-1.41477),(-.38685,52.85973,-1.2544),(-.37622,52.82779,-1.25811),(-.37788,52.79668,-1.18564),(-.38594,52.81816,-1.21447),(-.2676,52.73921,-1.30807),(-.28823,52.71873,-1.25163),(-.28161,52.69615,-1.18519),(-.21469,52.65987,-1.06141),(-.12692,52.66156,-1.04135),(-.13192,52.66537,-1.10425),(-.12785,52.65618,-1.00494),(-.48438,52.72298,-1.17744),(-.4824,52.79554,-1.17391),(-.50549,52.7587,-1.22623),(-.31533,52.56626,-1.04174),(-.38088,52.64807,-1.11067),(0,52.35106,-.99475),(-.06251,52.43493,-.96797),(-.05977,52.35507,-1.00359),(-.50517,52.62505,-1.19522),(-.55102,52.578,-1.22912),(-.50314,52.59279,-1.20077),(-1.06894,52.60992,-1.42308),(-.9963,52.54153,-1.40164),(-1.00735,52.55101,-1.37926),(-.9836,52.59882,-1.35519),(-.93387,52.58452,-1.33863),(-.92906,52.65858,-1.37821),(-1.01816,52.73796,-1.41896),(-.96623,52.7821,-1.41727),(-.35251,52.83925,-1.59378),(-.42247,52.84444,-1.50756),(-.61742,52.90035,-1.40596),(-.74487,52.81645,-1.41027),(-.77154,52.7263,-1.40253),(-.79033,52.68968,-1.39328),(-.54288,52.54351,-1.24432),(-.34959,52.73636,-1.49341),(-.245,52.80053,-1.44512),(-.32904,52.77394,-1.45589),(-.28004,52.81236,-1.42434),(-.54487,52.7369,-1.42887),(-.12326,52.65254,-2.70263),(-.11019,52.72985,-2.67507),(-.12282,52.72972,-2.70947),(-.09921,52.62492,-2.63045),(-.10332,52.55143,-2.64407),(-.07159,52.52568,-2.55864),(-.10971,52.59058,-2.54641),(-.05042,52.54417,-2.63131),(-.12762,52.57356,-2.72082),(-.16093,52.66484,-2.75211),(-.16123,52.67459,-2.83474),(-.15889,52.73841,-2.74679),(-.14461,52.75705,-2.81252),(-.05693,52.74614,-2.6133),(-.07642,52.70852,-2.6199),(-.08733,52.69,-2.5419),(0,52.76063,-2.39016),(-.06022,52.73608,-2.32449),(0,52.77444,-2.32876),(-.09713,52.69898,-2.32265),(-.1464,52.7077,-2.20562),(0,52.80353,-2.12909),(0,52.79282,-2.22921),(-.06997,52.75251,-2.21759),(-.29226,52.63569,-2.07559),(-.22676,52.62711,-2.15043),(-.3189,52.57532,-2.08691),(-.27758,52.76504,-1.90344),(-.18995,52.80228,-1.89692),(-.13803,52.81363,-1.91429),(-.34865,52.45363,-2.09262),(-.43033,52.46362,-2.04185),(-.4728,52.54324,-1.9644),(-.52685,52.44075,-2.00009),(-.69534,52.63774,-1.7799),(-.5726,52.68285,-1.8061),(-.64681,52.61144,-1.85737),(-.40459,52.6751,-1.93958),(-.45098,52.61261,-1.94214),(-.5063,52.64118,-1.8931),(-.45903,52.74685,-1.77678),(-.35479,52.78383,-1.76942),(-.48553,52.7588,-1.69954),(-.60226,52.77555,-1.68687),(-.49613,52.81324,-1.64691),(-.50458,52.78044,-1.67815),(-.49251,52.88921,-1.59799),(-.65357,53.02597,-1.4422),(-.57923,52.95508,-1.51769),(-.6676,52.96625,-1.50822),(-.90746,52.79058,-1.56186),(-.93342,52.79964,-1.54134),(-.90545,52.82915,-1.54303),(-.20354,52.58765,-1.90546),(-.2082,52.6338,-1.88921),(-.25805,52.62549,-1.81315),(-.06259,52.34204,-1.35824),(-.12497,52.32001,-1.30005),(-.1131,52.35044,-1.3623),(-.20576,52.31781,-1.33697),(-.17868,52.32116,-1.31081),(-.17611,52.29222,-1.24432),(-.3106,52.18568,-1.23251),(-.32169,52.2198,-1.2915),(-.18998,52.25017,-1.25681),(-.11145,52.38793,-1.42915),(-.16935,52.3662,-1.38284),(-.1956,52.34941,-1.39526),(-.29189,52.33501,-1.43569),(-.29204,52.35541,-1.46623),(0,52.34139,-1.54476),(0,52.34201,-1.54245),(-.27472,52.38844,-1.56147),(-.21875,52.38034,-1.55108),(-.24457,52.16897,-1.15145),(-.14284,52.18382,-1.16555),(-.14904,52.16043,-1.11457),(-.53308,52.49642,-1.26629),(-.52197,52.47918,-1.29731),(-.42847,52.40734,-1.25627),(-.37008,52.37905,-1.38179),(-.41064,52.39624,-1.36751),(-.3667,52.39682,-1.43441),(-.39941,52.42746,-1.42601),(-.39124,52.4523,-1.45473),(-.34208,52.4385,-1.50563),(0,52.5745,-2.70907),(-.04247,52.57095,-2.78111),(0,52.58044,-2.77146),(-.06595,52.62173,-2.83323),(-.02484,52.54959,-2.72185),(-.07346,52.55794,-2.71063),(-.0201,52.53955,-2.63356),(0,52.55742,-2.62846),(0,52.54837,-2.5408),(-.01313,52.52417,-2.47995),(-.01127,52.53169,-2.55281),(0,52.52332,-2.47166),(0,52.50772,-2.4063),(-.01481,52.49981,-2.41666),(-.02509,52.45863,-2.36196),(0,52.48485,-2.35541),(0,52.46711,-2.25898),(-.15097,52.37492,-2.25591),(-.11771,52.38362,-2.23764),(-.13536,52.36183,-2.17499),(-.04121,52.44008,-2.28648),(-.25015,52.45342,-1.941),(-.24132,52.40502,-1.98149),(0,52.47461,-2.18452),(0,52.5012,-2.13627),(-.06483,52.46274,-2.15228),(-.41549,52.60293,-1.68633),(-.45566,52.5801,-1.63659),(-.43335,52.58942,-1.58142),(-.45773,52.55586,-1.58469),(-.54339,52.55743,-1.53427),(-.4024,52.55415,-1.75347),(-.4627,52.5586,-1.70025),(-.46728,52.51958,-1.78009),(-.31513,52.49763,-1.84125),(-.35354,52.48523,-1.84242),(-.31947,52.3953,-1.93859),(-.27273,52.38175,-1.97244),(-.5734,52.41982,-1.8625),(-.51005,52.39188,-1.90253),(-.4899,52.44401,-1.85501),(-.25248,52.39686,-1.99192),(-.52483,52.35875,-1.97971),(-.58967,52.40794,-1.93679),(-.59967,52.46529,-1.96268),(-.67752,52.42236,-1.85588),(-.71335,52.51179,-1.86801),(-.65803,52.49054,-1.91587),(-.64258,52.42866,-1.81368),(-.62794,52.45894,-1.76688),(-.68093,52.46229,-1.7473),(-.60196,52.49122,-1.72635),(-.57759,52.51966,-1.67916),(-.64673,52.5345,-1.66591),(-.85587,52.74379,-1.6099),(-.78716,52.74652,-1.63884),(-.78268,52.69966,-1.66836),(-.84563,52.62805,-1.58605),(-.77981,52.60857,-1.61745),(-.79262,52.57173,-1.53251),(-.80162,52.54934,-1.50424),(-.77071,52.50653,-1.42657),(-.75107,52.50432,-1.36862),(-.84469,52.50196,-1.37797),(-.84074,52.69957,-1.63111),(-.85752,52.66468,-1.58573),(-.97303,52.60623,-1.51892),(-1.00764,52.61444,-1.48595),(-.98189,52.64709,-1.53402),(-1.04792,52.66023,-1.5046),(-1.0415,52.74223,-1.52328),(-1.06419,52.61521,-1.46082),(-1.08778,52.67081,-1.46913),(-.13484,52.72642,-1.46433),(-.1331,52.61902,-1.51978),(-.08138,52.64649,-1.9921),(0,52.66078,-2.01061),(0,52.70367,-1.9743),(.46109,52.56315,-1.69183),(.40569,52.58166,-1.71695),(.39589,52.56039,-1.74871),(.07216,52.34378,-1.54084),(.07777,52.34705,-1.59027),(.32661,52.8493,-1.37247),(.36135,52.85065,-1.30343),(.3669,52.88036,-1.32718),(.33221,52.89247,-1.62121),(.31218,52.87371,-1.67826),(.31494,52.81045,-1.69059),(.76538,52.53043,-1.6699),(.72905,52.49666,-1.68266),(.7671,52.47864,-1.72168),(.64794,52.53855,-1.65836),(.6969,52.51408,-1.66915),(.68262,52.54324,-1.65679),(.32809,52.38999,-2.02993),(.19017,52.37194,-2.0839),(.33729,52.39066,-2.07484),(.42143,52.81362,-1.65541),(.43104,52.82615,-1.64857),(.50458,52.78044,-1.67713),(.35178,52.89586,-1.63655),(.89419,52.79228,-1.57001),(.85175,52.75458,-1.60857),(.87028,52.79256,-1.58926),(.78516,52.75517,-1.63814),(.71025,52.7599,-1.67159),(.78792,52.79148,-1.61261),(.37849,52.40342,-1.92761),(.3307,52.38407,-1.94612),(.34194,52.37285,-1.95472),(.45385,52.67424,-1.14358),(.45342,52.70889,-1.13872),(.43215,52.6971,-1.14074),(.38445,52.45176,-1.16732),(.3972,52.38306,-1.1846),(.43425,52.43386,-1.23066),(.44771,52.52421,-1.18616),(.4568,52.60957,-1.15451),(.38563,52.59688,-1.11986),(.41549,52.60293,-1.68521),(.33408,52.5811,-1.76497),(.34175,52.54909,-1.78428),(.13868,52.35687,-1.58966),(.13766,52.36625,-1.59784),(.2248,52.38396,-1.59687),(.06753,52.15528,-1.11229),(.14904,52.16043,-1.1139),(.06606,52.15704,-1.10046),(.79297,52.86941,-1.57),(.7293,52.95472,-1.51114),(.79939,52.91105,-1.53805),(.04447,52.75437,-2.60874),(.05693,52.74614,-2.61325),(.09165,52.78395,-2.65802),(.28363,52.45291,-1.56483),(.3449,52.51172,-1.5216),(.34268,52.4798,-1.5129),(.08153,52.56846,-2.77071),(.14272,52.59674,-2.84261),(.14969,52.59372,-2.83522),(.15237,52.67657,-2.8433),(.15044,52.65883,-2.84155),(.42723,52.52638,-1.49709),(.38303,52.52994,-1.53025),(.41159,52.54654,-1.54626),(.72371,52.4912,-1.68257),(.67165,52.47581,-1.72545),(.68093,52.46229,-1.74534),(.28598,52.44524,-1.90731),(.27751,52.45114,-1.91345),(.2528,52.39651,-1.97105),(.4024,52.55415,-1.75231),(.84818,52.64194,-1.3505),(.75316,52.63718,-1.35529),(.73879,52.61381,-1.34097),(.86234,52.87148,-1.54813),(1.03935,52.79306,-1.45136),(1.0966,52.74845,-1.44361),(1.09221,52.74035,-1.48287),(.34564,52.53856,-1.78756),(.30008,52.47686,-1.86741),(.29474,52.48633,-1.87293),(.37744,52.31831,-2.00334),(.38089,52.31535,-2.01405),(.44557,52.31863,-2.00944),(.31513,52.49763,-1.84028),(.3678,52.31678,-2.01198),(.73927,52.54787,-1.49547),(.73091,52.52233,-1.45788),(.71864,52.53262,-1.45015),(.88803,52.55665,-1.51898),(.89435,52.53883,-1.48866),(.80927,52.51722,-1.47357),(.70352,52.5809,-1.50039),(.69789,52.61314,-1.48231),(.64841,52.59526,-1.50107),(.54144,52.49772,-1.42656),(.58324,52.52489,-1.42284),(.59824,52.51278,-1.38924),(.71173,52.56264,-1.61588),(.77981,52.60857,-1.61563),(.75514,52.56514,-1.58628),(.71497,52.50341,-1.42275),(.67088,52.50526,-1.37248),(.65783,52.50358,-1.39471),(.29748,52.57133,-1.54233),(.26215,52.62705,-1.54184),(.2988,52.62611,-1.53671),(.65039,52.51837,-1.40007),(.68408,52.66324,-1.46034),(.7054,52.72315,-1.44114),(.67548,52.71472,-1.43933),(.58149,52.62926,-1.4334),(.5654,52.6493,-1.3915),(.57667,52.61592,-1.40958),(.59331,52.54542,-1.44681),(.60346,52.54895,-1.40117),(.59837,52.53401,-1.41997),(.73636,52.58307,-1.32218),(.68488,52.59416,-1.33308),(.63877,52.58771,-1.34852),(.6854,52.57874,-1.35798),(.69004,52.55219,-1.39278),(.7131,52.66122,-1.44661),(.74854,52.67998,-1.39448),(.73731,52.69999,-1.41458),(.58899,52.61516,-1.33864),(.56239,52.64631,-1.32078),(.56978,52.63915,-1.29998),(.54047,52.66105,-1.37156),(.51925,52.71733,-1.39392),(.50863,52.70586,-1.34027),(.59348,52.68612,-1.43279),(.57782,52.71688,-1.42019),(.55,52.69397,-1.40378),(.69751,52.52807,-1.41556),(.71288,52.55855,-1.43061),(.62573,52.56687,-1.50124),(.65839,52.56482,-1.53718),(.65466,52.57637,-1.51789),(.70608,52.51505,-1.42293),(.60221,52.59826,-1.32188),(.27259,52.80594,-1.77854),(.27589,52.80825,-1.78112),(.23687,52.79899,-1.85004),(.1015,52.6876,-1.9668),(.162,52.68042,-1.92303),(.16867,52.71492,-1.91779),(.11019,52.72985,-2.67498),(.12282,52.72972,-2.70937),(.12244,52.79782,-2.71924),(.77573,52.60139,-1.73584),(.77058,52.56612,-1.65255),(.35354,52.48523,-1.84134),(.49766,52.93597,-1.55448),(.35992,52.90308,-1.62751),(.4509,53.00251,-1.53107),(.23746,52.77447,-1.85642),(.27316,52.7856,-1.78342),(.19144,52.43261,-2.01048),(.21072,52.45537,-1.97692),(.15987,52.46783,-2.02944),(.31728,52.75696,-1.70119),(.27047,52.76354,-1.78493),(.09409,52.40682,-2.22802),(.09073,52.40789,-2.19187),(.05478,52.44541,-2.21258),(.59424,52.72484,-1.74815),(.60144,52.7644,-1.68914),(.70922,52.74761,-1.67335),(.3183,52.87665,-1.67603),(.38764,52.64216,-1.57259),(.3781,52.68638,-1.54826),(.37386,52.69758,-1.6053),(.36343,52.78853,-1.57781),(.3769,52.72898,-1.51962),(.53528,52.91803,-1.43529),(.45409,52.91216,-1.499),(.43875,52.88896,-1.5086),(.43278,52.89318,-1.51124),(.43275,52.89967,-1.5142),(.46626,52.79738,-1.45862),(.50064,52.76464,-1.44054),(.5597,52.81457,-1.45036),(.47547,52.75505,-1.37273),(.74053,52.7573,-1.40945),(.74487,52.81645,-1.40898),(.72054,52.77409,-1.4348),(.21656,52.71518,-1.87106),(.23176,52.74667,-1.87056),(.17358,52.7441,-1.91182),(.44118,52.99563,-1.51214),(.3396,52.89944,-1.60914),(.93732,52.50741,-1.3775),(1.00735,52.55101,-1.37705),(.93387,52.58452,-1.33656),(.83826,52.80153,-1.40306),(.77999,52.78121,-1.39869),(.8131,52.74141,-1.3968),(1.01305,52.80461,-1.43216),(.95694,52.85158,-1.47271),(.79027,52.95683,-1.41241),(.81711,52.883,-1.3972),(.8404,52.9144,-1.43658),(.90959,52.81614,-1.41167),(.63215,52.51125,-1.32152),(.61571,52.5118,-1.35799),(.52197,52.47918,-1.29568),(.51027,52.44635,-1.33777),(.55727,52.49269,-1.37858),(.45773,52.55586,-1.58336),(.4467,52.53829,-1.51857),(.38691,52.361,-1.95304),(.21838,52.5578,-1.57105),(.21549,52.48932,-1.58799),(.12908,52.45507,-1.59162),(.07412,52.60889,-1.50663),(.08436,52.7042,-1.46443),(.32803,52.66806,-1.53833),(.30154,52.66684,-1.52963),(.32716,52.7174,-1.5143),(.29871,52.69987,-1.50905),(.29769,52.75477,-1.47184),(.18665,52.78467,-1.43324),(.21393,52.7954,-1.43883),(.25657,52.75334,-1.47859),(.20518,52.62826,-1.5392),(.25714,52.6841,-1.51567),(.56203,52.6094,-1.25952),(.61042,52.58683,-1.27874),(.40334,52.89583,-1.26424),(.45001,52.8589,-1.23881),(.42562,52.84776,-1.30501),(.25321,52.76288,-1.36228),(.27147,52.81111,-1.40736),(.24323,52.8022,-1.42525),(.0668,52.6448,-.92364),(.14451,52.62301,-.92244),(.14227,52.6413,-.93011),(.33704,52.85142,-1.38759),(.0919,52.76529,-1.42516),(.09022,52.75872,-1.44054),(.41583,52.36391,-1.28306),(.40107,52.29433,-1.28284),(.40324,52.31345,-1.31146),(.5065,52.4433,-1.37754),(.44822,52.42299,-1.37256),(.25171,52.7363,-1.31183),(.2676,52.73921,-1.30742),(.3837,52.75694,-1.19092),(.37788,52.79668,-1.18483),(.35917,52.76285,-1.21216),(.41458,52.74587,-1.15593),(.41681,52.77652,-1.15002),(.49646,52.48347,-1.42853),(.49795,52.54518,-1.48133),(.54339,52.55743,-1.53273),(.53784,52.52611,-1.47066),(.29265,52.33383,-1.99443),(.33208,52.37811,-2.01555),(.93399,52.84708,-1.45125),(.37622,52.82779,-1.25735),(.3438,52.82154,-1.29774),(.38594,52.81816,-1.21367),(.4077,52.82444,-1.16221),(.28823,52.71873,-1.25076),(.29695,52.76725,-1.2961),(.28161,52.69618,-1.18234),(.3193,52.69959,-1.18398),(.21469,52.67478,-1.0538),(.20491,52.68263,-1.0962),(.13192,52.67582,-1.10225),(.12692,52.67806,-1.03652),(.12785,52.67614,-.99676),(.50549,52.7587,-1.22513),(.4824,52.79554,-1.17292),(.48438,52.72298,-1.17632),(.38088,52.64807,-1.10827),(.30411,52.63341,-1.03089),(.50517,52.62505,-1.1939),(.5149,52.66315,-1.23245),(1.06351,52.61515,-1.38497),(1.06894,52.60992,-1.42104),(1.07998,52.75509,-1.41511),(1.09401,52.67372,-1.3978),(.96623,52.7821,-1.41578),(1.01816,52.73796,-1.41734),(.35251,52.83925,-1.59308),(.78633,52.84801,-1.40302),(.79033,52.68968,-1.39162),(.68876,52.83472,-1.42145),(.85232,52.57613,-1.33715),(.28004,52.81236,-1.42373),(.32904,52.77394,-1.45515),(.54487,52.7369,-1.42765),(.09921,52.62492,-2.63033),(.12326,52.65254,-2.7025),(.10332,52.55143,-2.64393),(.10971,52.59058,-2.54626),(.07159,52.52568,-2.55853),(.07346,52.55794,-2.71054),(.05042,52.54417,-2.63124),(.16093,52.66484,-2.75196),(.12762,52.57356,-2.72067),(.16123,52.67459,-2.83462),(.15889,52.73841,-2.74667),(.05912,52.72872,-2.54319),(.08733,52.69,-2.5418),(.07642,52.70852,-2.61982),(.06022,52.73608,-2.3244),(.09713,52.69898,-2.32249),(.06997,52.75251,-2.21746),(.08846,52.76959,-2.129),(.3189,52.57532,-2.08611),(.23048,52.59353,-2.15554),(.22676,52.62711,-2.1499),(.34865,52.45363,-2.09161),(.39448,52.55745,-2.02103),(.43033,52.46362,-2.04062),(.4728,52.54324,-1.96315),(.45098,52.61261,-1.94103),(.52074,52.55175,-1.94132),(.78682,52.55572,-1.78078),(.69534,52.63774,-1.77834),(.44038,52.71341,-1.86924),(.5063,52.64118,-1.8919),(.27758,52.76504,-1.90286),(.31273,52.77817,-1.83835),(.40248,52.81349,-1.69443),(.48553,52.7588,-1.69851),(.45903,52.74685,-1.7758),(.49917,52.76848,-1.68697),(.59915,52.80764,-1.64108),(.60226,52.77555,-1.68569),(.49251,52.88921,-1.59715),(.45848,52.89134,-1.6054),(.6676,52.96625,-1.50735),(.54207,53.01744,-1.47615),(.65357,53.02597,-1.44146),(.90545,52.82915,-1.54171),(.93342,52.79964,-1.53993),(.90746,52.79058,-1.56044),(.25805,52.62549,-1.81246),(.20354,52.58765,-1.90491),(.25405,52.56383,-1.85767),(.1131,52.35044,-1.36187),(.06628,52.3176,-1.28738),(.06259,52.34204,-1.35799),(.17611,52.29222,-1.2433),(.17868,52.32116,-1.3101),(.20576,52.31781,-1.33615),(.18998,52.25017,-1.25602),(.32169,52.2198,-1.29015),(.3106,52.18568,-1.23116),(.16935,52.3662,-1.3822),(.11145,52.38793,-1.42873),(.1956,52.34941,-1.39451),(.17721,52.35239,-1.43022),(.29204,52.35541,-1.46513),(.27472,52.38844,-1.56047),(.28102,52.37832,-1.5256),(.21875,52.38034,-1.55027),(.33661,52.35135,-1.44773),(.29189,52.33501,-1.43457),(.14284,52.18382,-1.16492),(.23193,52.18012,-1.19351),(.25488,52.1945,-1.1218),(.33555,52.28493,-1.1317),(.25251,52.23847,-1.09033),(.40029,52.32152,-1.20368),(.53308,52.49642,-1.26467),(.5632,52.50288,-1.3331),(.42847,52.40734,-1.25479),(.41064,52.39624,-1.36606),(.39941,52.42746,-1.42464),(.37008,52.37905,-1.38045),(.39124,52.4523,-1.45342),(.3667,52.39682,-1.4331),(.34208,52.4385,-1.50446),(.43063,52.46262,-1.42146),(.41577,52.50777,-1.4738),(.45566,52.5801,-1.63532),(.04247,52.57095,-2.78106),(.1137,52.6021,-2.83875),(.06595,52.62173,-2.83317),(.01127,52.53169,-2.55279),(.01313,52.52417,-2.47993),(.01481,52.49981,-2.41663),(.02509,52.45863,-2.3619),(.13536,52.36183,-2.17455),(.15097,52.37492,-2.25545),(.21192,52.35853,-2.17029),(.11846,52.42026,-2.12823),(.06483,52.46274,-2.15209),(.06481,52.4997,-2.11496),(.16398,52.41911,-2.06182),(.50165,52.56122,-1.63152),(.40553,52.50947,-1.81069),(.46728,52.51958,-1.77874),(.31947,52.3953,-1.93753),(.26776,52.39534,-1.96209),(.55892,52.45147,-1.80947),(.4899,52.44401,-1.85351),(.51005,52.39188,-1.90091),(.25248,52.39686,-1.99109),(.59967,52.46529,-1.96102),(.52483,52.35875,-1.97804),(.52685,52.44075,-1.99856),(.65803,52.49054,-1.91411),(.71335,52.51179,-1.86617),(.67752,52.42236,-1.8539),(.62794,52.45894,-1.76503),(.64258,52.42866,-1.81176),(.64673,52.5345,-1.66415),(.57759,52.51966,-1.67751),(.60196,52.49122,-1.72461),(.78268,52.69966,-1.66679),(.78716,52.74652,-1.63738),(.85587,52.74379,-1.60838),(.86269,52.59072,-1.5576),(.79262,52.57173,-1.53056),(.80162,52.54934,-1.50221),(.84469,52.50196,-1.37575),(.75107,52.50432,-1.36654),(.77071,52.50653,-1.42447),(.85752,52.66468,-1.58397),(.84074,52.69957,-1.62949),(.98189,52.64709,-1.53214),(1.00764,52.61444,-1.48395),(.97303,52.60623,-1.51691),(1.0415,52.74223,-1.5217),(1.04792,52.66023,-1.50274),(1.08778,52.67081,-1.46731),(1.06419,52.61521,-1.45881),(.16014,52.77955,-1.42793),(.13484,52.72642,-1.46399),(.09513,52.76478,-1.43645),(.08138,52.64649,-1.9919),(.34903,52.82706,-1.63079),(.36321,52.75917,-1.64813),(1.09875,52.67257,-1.42932),(.9963,52.54153,-1.39941),(.96401,52.56312,-1.46168),(.93255,52.6317,-1.5551),(.84563,52.62805,-1.58421),(.91134,52.50921,-1.42922),(.77434,52.65337,-1.70144),(.69281,52.50691,-1.6694),(.73745,52.56719,-1.54717),(.61495,52.47508,-1.74646),(.67244,52.44425,-1.77445),(.70562,52.43488,-1.8066),(.76241,52.46518,-1.74532),(.58475,52.40385,-1.92827),(.5734,52.41982,-1.86075),(.52274,52.35566,-1.97071),(.43853,52.36034,-1.94451),(.42895,52.34064,-2.02753),(.4342,52.42371,-1.88828),(.29841,52.33644,-1.98701),(.38669,52.56698,-1.55267),(.32642,52.61311,-1.74571),(.37739,52.69129,-1.66571),(.32075,52.69477,-1.72044),(.09717,52.4088,-2.30647),(.11771,52.38362,-2.23729),(.07419,52.68553,-2.8475),(.33745,52.62331,-1.55022),(.40349,52.61042,-1.58537),(.33733,52.38469,-1.49851),(.34708,52.36171,-1.44563),(.58746,52.51034,-1.29896),(.23214,52.39749,-1.03993),(.15732,52.30003,-1.03017),(.24659,52.32165,-1.05749),(.0738,52.18934,-1.15124),(.32641,52.37377,-1.49788),(.06526,52.36301,-1.43846),(.0698,52.34126,-1.51083),(.15928,52.35065,-1.44492),(.15657,52.37479,-1.41188),(.31078,52.28583,-1.37931),(.20688,52.27812,-1.28811),(.32038,52.25793,-1.34761),(.06473,52.40066,-1.59451),(0,52.35863,-1.59377),(0,52.40064,-1.58312),(.13379,52.40634,-1.595),(1.02522,52.78647,-1.47692),(.86947,52.92731,-1.46385),(.68722,52.80974,-1.63053),(.35479,52.78383,-1.76868),(.5726,52.68285,-1.80482),(.57384,52.58578,-1.90384),(.64681,52.61144,-1.85586),(.43302,52.4072,-2.0438),(.34009,52.71901,-1.9227),(.24663,52.72224,-1.9712),(.11856,52.81924,-1.92198),(.10145,52.78376,-2.03627),(0,52.83885,-1.91238),(.21031,52.71803,-2.03933),(.34586,52.6532,-2.00499),(.29226,52.63569,-2.07491),(.18739,52.62201,-2.22146),(.06471,52.71748,-2.46961),(.08774,52.65778,-2.462),(.41843,52.78397,-1.48256),(.42247,52.84444,-1.50674),(.38899,52.76017,-1.50671),(.59288,52.76963,-1.44406),(.64435,52.84125,-1.43048),(.65838,52.79355,-1.43824),(.72855,52.88404,-1.4032),(.522,52.85644,-1.45513),(.8062,52.97073,-1.44698),(.92906,52.65858,-1.37636),(.49427,52.53024,-1.20998),(.47624,52.48356,-1.24295),(.50314,52.59279,-1.19939),(.31533,52.57024,-1.0338),(.38701,52.51854,-1.14004),(.24165,52.62201,-.9705),(.23639,52.54626,-.9749),(.52613,52.68748,-1.27981),(.39066,52.72687,-1.15689),(.26683,52.68106,-1.08925),(.14461,52.75705,-2.81244),(.12765,52.79703,-2.72425),(.17458,52.23266,-1.23443),(.1332,52.26465,-1.20052),(.63109,52.69554,-1.44427),(.61569,52.73573,-1.44115),(.41596,52.8428,-1.14505),(.44245,52.79491,-1.11875),(.42367,52.85992,-1.12909),(.32483,52.7961,-1.2952),(.31128,52.80865,-1.33039),(.13327,52.29185,-1.23303),(.46916,52.40466,-1.30588),(.34244,52.22831,-1.1514),(.38179,52.88886,-1.28898),(.40067,52.89212,-1.27166),(.38239,52.87191,-1.34458),(.46833,52.77617,-1.35946),(.4872,52.76922,-1.30043),(.34959,52.73636,-1.49258),(.37203,52.75532,-1.47088),(.22468,52.74629,-1.47479),(.245,52.80053,-1.44457),(.33131,52.58084,-1.54239),(.36178,52.58741,-1.55906),(.41278,52.89294,-1.21001),(.42291,52.89544,-1.21497),(.88358,52.75708,-1.41952),(1.02884,52.66727,-1.37782),(.9836,52.59882,-1.35314),(.2671,52.73187,-1.78969),(.10541,52.71178,-1.94878),(.11275,52.74163,-1.94464),(0,52.73138,-1.94755),(.68459,52.90107,-1.40087),(.61742,52.90035,-1.40497),(.60457,52.55776,-1.27511),(.55102,52.578,-1.22761),(.54288,52.54351,-1.24276),(.146,52.59699,-1.95325),(.15495,52.64043,-1.93365),(.25977,52.6865,-1.79352),(.25346,52.49979,-1.90307),(.27984,52.52793,-1.85242),(.09164,52.4393,-2.14238),(.18272,52.781,-1.89618),(.23366,52.79618,-1.84866),(0,52.83417,-1.90837),(0,52.77869,-1.92673),(.12334,52.78277,-1.92368),(.25015,52.45342,-1.94022),(.18995,52.80228,-1.89654),(.13647,52.81162,-1.91106),(.13803,52.81363,-1.91402),(.70735,52.56677,-1.54291),(.71285,52.55683,-1.51505),(.65011,52.54381,-1.39049),(.60574,52.53019,-1.40296),(.7155,52.58384,-1.40156),(.73591,52.63464,-1.4309),(.71868,52.5906,-1.46602),(.66701,52.74773,-1.43797),(.64167,52.59584,-1.32238),(.72496,52.61259,-1.36393),(.73043,52.501,-1.39485),(.71789,52.54768,-1.65383),(.57291,52.54153,-1.45882),(.74261,52.63819,-1.35779),(.26127,52.38379,-1.97761),(.24132,52.40502,-1.9807),(.66334,52.49537,-1.70724),(.77198,52.49078,-1.72259),(.4141,52.39864,-2.051),(.11381,52.80526,-2.72255),(.28718,52.50329,-1.55454),(.32119,52.54153,-1.53197),(.04429,52.78062,-2.65073),(0,52.7692,-2.64663),(.13728,52.20824,-1.18114),(.40459,52.6751,-1.93866),(.33947,52.68621,-1.15781),(.37324,52.66382,-1.11421),(.27273,52.38175,-1.97153),(.36588,52.89706,-1.62986),(.89942,52.83539,-1.54333),(-.31728,52.75696,-1.7019),(-.30154,52.66684,-1.53043),(-.95646,52.69675,-1.53721),(-.93255,52.6317,-1.557),(-.86269,52.59072,-1.55957),(-.71497,52.50341,-1.42476),(-.69281,52.50691,-1.67132),(-.66334,52.49537,-1.70911),(-.67165,52.47581,-1.72737),(-.58475,52.40385,-1.93004),(-.52274,52.35566,-1.97239),(-.42895,52.34064,-2.02894),(-.60392,52.55665,-1.58246),(-.38691,52.361,-1.95434),(-.37744,52.31831,-2.00464),(-.29841,52.33644,-1.98805),(-.40553,52.50947,-1.81189),(-.41577,52.50777,-1.47511),(-.49795,52.54518,-1.48278),(-.38669,52.56698,-1.5538),(-.25405,52.56383,-1.8584),(-.11575,52.48008,-2.06861),(-.21192,52.35853,-2.17096),(-.11846,52.42026,-2.12859),(-.09717,52.4088,-2.30674),(-.07381,52.50042,-2.47914),(-.14272,52.59674,-2.84275),(-.07419,52.68553,-2.84755),(-.36601,52.44432,-1.88561),(-.33496,52.44502,-1.89412),(-.53784,52.52611,-1.47225),(-.33745,52.62331,-1.55115),(-.36178,52.58741,-1.56009),(-.40349,52.61042,-1.58648),(-.33733,52.38469,-1.49974),(-.34708,52.36171,-1.44692),(-.37476,52.30888,-1.38079),(-.63215,52.51125,-1.32335),(-.32485,52.3439,-1.11485),(-.24659,52.32165,-1.06184),(-.15732,52.30003,-1.03423),(-.15902,52.373,-1.00691),(-.24903,52.17398,-1.13797),(-.0738,52.18934,-1.1517),(-.1398,52.35234,-1.53635),(-.0698,52.34126,-1.5111),(-.06526,52.36301,-1.4387),(-.28102,52.37832,-1.52664),(-.32038,52.25793,-1.34892),(-.20688,52.27812,-1.28896),(-.07696,52.35753,-1.59909),(-.13379,52.40634,-1.59549),(-.06627,52.44678,-1.58414),(-.86947,52.92731,-1.4649),(-.72232,53.01745,-1.44036),(-.54207,53.01744,-1.47683),(-.3396,52.89944,-1.60975),(-.57384,52.58578,-1.90525),(-.78682,52.55572,-1.78267),(-.52074,52.55175,-1.94268),(-.43302,52.4072,-2.04512),(-.24663,52.72224,-1.97174),(-.34009,52.71901,-1.92345),(-.10145,52.78376,-2.03647),(-.11856,52.81924,-1.92221),(-.21031,52.71803,-2.03978),(-.23048,52.59353,-2.1561),(-.18739,52.62201,-2.22188),(-.06471,52.71748,-2.46969),(-.05912,52.72872,-2.54325),(-.43491,52.77764,-1.41235),(-.46833,52.77617,-1.36047),(-.59288,52.76963,-1.44528),(-.72855,52.88404,-1.40431),(-.8062,52.97073,-1.4479),(-.47624,52.48356,-1.24445),(-.49427,52.53024,-1.21144),(-.4568,52.60957,-1.15574),(-.43969,52.46896,-1.2115),(-.23639,52.53345,-.9848),(-.23085,52.46501,-1.01432),(-.15374,52.44126,-.97631),(-.309,52.486,-1.07409),(-.30411,52.62571,-1.04041),(-.52613,52.68748,-1.28107),(-.45524,52.79601,-1.12056),(-.43389,52.86205,-1.13214),(-.0668,52.63065,-.93213),(-.06038,52.65509,-.99236),(-.41458,52.74587,-1.15688),(-.43796,52.7375,-1.13041),(-.35917,52.76285,-1.21297),(-.3837,52.75694,-1.19179),(-.12765,52.79703,-2.72432),(-.1332,52.26465,-1.20182),(-.17458,52.23266,-1.23517),(-.61569,52.73573,-1.44248),(-.63109,52.69554,-1.44571),(-.42367,52.85992,-1.12987),(-.44245,52.79491,-1.11966),(-.3669,52.88036,-1.32787),(-.38179,52.88886,-1.28968),(-.3438,52.82154,-1.29846),(-.13327,52.29185,-1.23428),(-.47398,52.45828,-1.26461),(-.40067,52.89212,-1.27238),(-.39388,52.89366,-1.26036),(-.37203,52.75532,-1.47174),(-.25714,52.6841,-1.51634),(-.29871,52.69987,-1.50981),(-.90959,52.81614,-1.41305),(-1.07998,52.75509,-1.41666),(-.54426,52.99952,-1.44145),(-.11275,52.74163,-1.94488),(-.68459,52.90107,-1.40192),(-.36321,52.75917,-1.64894),(-.37739,52.69129,-1.66664),(-.32803,52.66806,-1.53919),(-.70922,52.74761,-1.67473),(-.77434,52.65337,-1.7031),(-.56203,52.6094,-1.261),(-.15495,52.64043,-1.93404),(-.146,52.59699,-1.95364),(-.32075,52.69477,-1.72122),(-.16398,52.41911,-2.06234),(-.11751,52.81558,-1.91824),(-.13647,52.81162,-1.91133),(-.12334,52.78277,-1.92393),(-.18272,52.781,-1.89656),(-.1866,52.79999,-1.89324),(-.65011,52.54381,-1.39229),(-.72551,52.56528,-1.484),(-.71868,52.5906,-1.46782),(-.66701,52.74773,-1.43934),(-.56239,52.64631,-1.32219),(-.6854,52.57874,-1.35977),(-.72496,52.61259,-1.3657),(-.69751,52.52807,-1.41748),(-.70608,52.51505,-1.4249),(-.71789,52.54768,-1.6557),(-.71173,52.56264,-1.61771),(-.74261,52.63819,-1.35952),(-.26127,52.38379,-1.97848),(-.76054,52.47324,-1.72196),(-.76241,52.46518,-1.74741),(-.77018,52.47052,-1.7498),(-.77198,52.49078,-1.72465),(-.04429,52.78062,-2.65077),(-.04447,52.75437,-2.60879),(-.23193,52.18012,-1.19452),(-.13728,52.20824,-1.18181),(-.44038,52.71341,-1.87021),(-.37324,52.66382,-1.11656),(-.39066,52.72687,-1.15783),(-.35992,52.90308,-1.62813),(-.35178,52.89586,-1.63717),(-.89942,52.83539,-1.54463),(-.41681,52.77652,-1.15091),(-.32641,52.37377,-1.49908),(-.43594,52.38872,-2.04168),(-.78792,52.79148,-1.61397),(-.36856,52.74345,-1.19037),(-.32119,52.54153,-1.53296),(-.18312,52.7371,-1.47026),(-.16014,52.77955,-1.4283),(-.43063,52.46262,-1.42288),(0,52.76419,-2.60211),(-.12244,52.79782,-2.71932),(-.11381,52.80526,-2.72261),(-.4141,52.39864,-2.05227),(-.72371,52.4912,-1.68457),(-.73326,52.63233,-1.37199),(-.33703,52.54451,-1.79377),(-.65839,52.56482,-1.53893),(-.67548,52.71472,-1.44078),(-.65039,52.51837,-1.40192),(-.31218,52.87371,-1.67883),(-.09164,52.4393,-2.14265),(-.27984,52.52793,-1.85324),(-.25977,52.6865,-1.79416),(-.07274,52.60031,-2.02795),(-.32642,52.61311,-1.74659),(-.28224,52.78577,-1.34695),(-.4872,52.76922,-1.30148),(-.09513,52.76478,-1.43667),(-.54047,52.66105,-1.3729),(-.33828,52.7769,-1.25299),(-.20491,52.67264,-1.10124),(-.5149,52.66315,-1.23373),(-.24165,52.60261,-.98401),(-.1457,52.52638,-.9458),(-.85232,52.57613,-1.33917),(-.79027,52.95683,-1.41337),(-.53576,52.89553,-1.43902),(-.78633,52.84801,-1.40427),(-.08774,52.65778,-2.46213),(-.17808,52.71451,-2.12734),(-.34586,52.6532,-2.0058),(0,52.81892,-2.0281),(-.39448,52.55745,-2.02206),(-.31273,52.77817,-1.839),(-.59915,52.80764,-1.6422),(-1.02522,52.78647,-1.47837),(-1.03935,52.79306,-1.4528),(-.06473,52.40066,-1.59475),(-.31078,52.28583,-1.38056),(-.12343,52.34716,-1.47476),(-.23214,52.39747,-1.04657),(-.58746,52.51034,-1.30069),(-.13647,52.53791,-1.99448),(-.96401,52.56312,-1.46383),(-.43853,52.36034,-1.94597),(-.61495,52.47508,-1.74825),(-.75514,52.56514,-1.58818),(.43594,52.38872,-2.04032),(.36856,52.74345,-1.18952),(.18312,52.7371,-1.46981),(.77018,52.47052,-1.74771),(.76054,52.47324,-1.71988),(.73326,52.63233,-1.37026),(.33703,52.54451,-1.79279),(.64324,52.58515,-1.29132),(.63407,52.56186,-1.2903),(.68438,52.58629,-1.30679),(.72551,52.56528,-1.48213),(.11751,52.81558,-1.91801),(.1866,52.79999,-1.89286),(.02484,52.54959,-2.72182),(.20017,52.52751,-1.94553),(.04121,52.44008,-2.28637),(.07274,52.60031,-2.02776),(.70585,52.69337,-1.72381),(.39388,52.89366,-1.25966),(.1398,52.35234,-1.53582),(.28224,52.78577,-1.34632),(.39673,52.25611,-1.22551),(.47398,52.45828,-1.26307),(.38685,52.85973,-1.25366),(.33828,52.7769,-1.25223),(.43796,52.7375,-1.12942),(.43389,52.86205,-1.13134),(.45524,52.79601,-1.11962),(.309,52.4862,-1.06764),(.43969,52.46896,-1.21008),(.53576,52.89553,-1.43812),(.43491,52.77764,-1.4114),(.07736,52.78915,-2.65469),(.17808,52.71451,-2.12697),(.49613,52.81324,-1.64594),(.57923,52.95508,-1.51687),(.06627,52.44678,-1.5839),(.07696,52.35753,-1.59879),(.12497,52.32001,-1.29945),(.12343,52.34716,-1.47428),(.15064,52.16456,-1.10113),(.24903,52.17398,-1.13689),(.15902,52.37335,-1.00102),(.32485,52.3439,-1.11255),(.37476,52.30888,-1.37934),(.33496,52.44502,-1.89306),(.36601,52.44432,-1.88446),(.07381,52.50042,-2.47901),(.39267,52.65033,-1.67516),(.43335,52.58942,-1.58021),(.44566,52.31725,-2.00182),(.95646,52.69675,-1.53549),(.1331,52.61902,-1.5194),(.19981,52.65683,-1.51678),(.82442,52.49424,-1.42159),(.70825,52.43761,-1.81547),(.58967,52.40794,-1.93502),(.4627,52.5586,-1.69894),(.0201,52.53955,-2.63353),(.08472,52.56486,-2.75048),(.41665,52.60653,-1.63413),(.24457,52.16897,-1.15038),(.22517,52.37625,-1.58784),(.2082,52.6338,-1.88867),(.1464,52.7077,-2.20533),(.05394,52.73837,-2.38473),(.77154,52.7263,-1.40099),(.54426,52.99952,-1.44073),(.45341,52.73571,-1.12935),(.40131,52.861,-1.21153),(.34188,52.83687,-1.31693),(.06265,52.72347,-1.34498),(.06835,52.72637,-1.34986),(0,52.75213,-1.43401),(.05663,52.60035,-.92329),(.13782,52.54329,-1.55451),(.49435,52.54183,-1.55985),(.68499,52.51241,-1.34549),(.76635,52.91355,-1.39707),(.44112,52.91081,-1.50877),(.39253,52.65317,-1.62003),(.30228,52.5474,-1.82083),(.63232,52.5632,-1.53334),(.77877,52.52266,-1.46403),(.57399,52.66704,-1.41259),(.64324,52.56428,-1.37135),(.59067,52.56654,-1.43259),(.30687,52.50424,-1.84489),(.08089,52.7907,-2.65905),(.38741,52.21416,-1.24101),(.37706,52.20638,-1.24749),(.38786,52.21901,-1.2499),(-.67244,52.44425,-1.77642),(-.70825,52.43761,-1.8175),(-.55892,52.45147,-1.81116),(-.06481,52.4997,-2.11514),(-.40324,52.31345,-1.313),(-.25251,52.23847,-1.09183),(-.06628,52.3176,-1.28792),(-.08846,52.76959,-2.12917),(-.05394,52.73837,-2.3848),(-.11011,52.63998,-2.37922),(-.11192,52.56259,-2.46371),(-.12258,52.54337,-2.39126),(-.83618,52.70183,-1.39204),(0,52.43518,-.96528),(-.45341,52.73571,-1.13037),(-.33208,52.37811,-2.01663),(-.29265,52.33383,-1.99545),(-.3678,52.31678,-2.01325),(-.25171,52.7363,-1.31245),(-.40107,52.29433,-1.2844),(-.42291,52.89544,-1.21571),(-.07412,52.60889,-1.50685),(-.13782,52.54329,-1.55494),(-.51763,52.54355,-1.67756),(-.17358,52.7441,-1.9122),(-.39253,52.65317,-1.62105),(-.30228,52.5474,-1.82171),(-.77877,52.52266,-1.4661),(-.57399,52.66704,-1.41398),(-.59331,52.54542,-1.44849),(-.58324,52.52489,-1.42454),(-.27751,52.45114,-1.91432),(-.38303,52.52994,-1.53142),(-.38786,52.21901,-1.25151),(-.37706,52.20638,-1.24907),(-.38741,52.21416,-1.24262),(-.2248,52.38396,-1.59769),(-.35717,52.55539,-1.5374),(-.28061,52.39938,-1.56797),(-.38232,52.25606,-1.34058),(-.39286,52.26449,-1.33505),(-.0817,52.70845,-2.38202),(-.13373,52.76208,-2.81961),(-.54691,52.47756,-1.78067),(-.4342,52.42371,-1.88965),(-.41986,52.46659,-1.85088),(-.51971,52.53964,-1.68525),(-.70562,52.43488,-1.80863),(-.66118,52.55983,-1.60595),(-.61954,52.59048,-1.48664),(-.59881,52.64171,-1.45245),(-.59389,52.58578,-1.46111),(-.59746,52.56594,-1.47598),(-.06119,52.7915,-2.74912),(0,52.75353,-2.82568),(-.07118,52.75808,-2.82072),(0,52.77611,-2.78074),(-.06814,52.54178,-2.07901),(-.41665,52.60653,-1.63527),(-.39267,52.65033,-1.67617),(-.91817,52.71938,-1.4185),(-.47859,52.48179,-1.8188),(-.22869,52.43538,-1.59618),(-.07627,52.53264,-1.54372),(-.29854,52.83447,-1.39026),(-.35358,52.79295,-1.4372),(-.41278,52.89294,-1.21074),(-.64333,53.01026,-1.40985),(0,52.69877,-1.29393),(-.06537,52.70275,-1.28798),(-.13209,52.68106,-1.19475),(-.21205,52.68981,-1.18293),(0,52.63928,-.93183),(0,52.65707,-.99398),(-.29381,52.64164,-1.04664),(-.05541,52.52408,-.94122),(-.31338,52.42131,-1.10059),(-1.0966,52.74845,-1.44517),(-1.09875,52.67257,-1.43114),(-.69955,52.93172,-1.39269),(-.61511,52.9227,-1.40277),(-.71235,52.99997,-1.40529),(-.37451,52.8109,-1.421),(-.40023,52.83618,-1.3747),(-.04429,52.78433,-2.67318),(0,52.75811,-2.48499),(-.04664,52.739,-2.54058),(-.05146,52.73116,-2.47306),(0,52.75917,-2.55836),(-.12788,52.63416,-2.32379),(-.20566,52.49636,-2.23637),(-.24989,52.45029,-2.16591),(-.68677,52.8766,-1.58713),(-.59346,52.87415,-1.58573),(0,52.60986,-2.05156),(-.06699,52.29487,-1.22894),(-.06833,52.25445,-1.18354),(0,52.20559,-1.16418),(0,52.26073,-1.18618),(-.06852,52.20936,-1.16655),(-.33661,52.35135,-1.44899),(-.33612,52.17506,-1.20412),(-.06254,52.21451,-1.05727),(0,52.27496,-1.03178),(-.06532,52.28576,-1.03267),(0,52.21421,-1.05484),(-.15528,52.22039,-1.0665),(-.53489,52.50366,-1.74988),(.35717,52.55539,-1.53632),(.28061,52.39938,-1.56696),(.38232,52.25606,-1.33903),(.39286,52.26449,-1.33347),(.04664,52.739,-2.54053),(.54691,52.47756,-1.77905),(.47859,52.48179,-1.81737),(.63955,52.64969,-1.46679),(.59746,52.56594,-1.47434),(.59389,52.58578,-1.45951),(0,52.7766,-2.69153),(.04429,52.78433,-2.67314),(.39447,52.77428,-1.44921),(.13647,52.53791,-1.99409),(.06814,52.54178,-2.07882),(.69955,52.93172,-1.3917),(.71235,52.99997,-1.40446),(.41986,52.46659,-1.84959),(.53489,52.50366,-1.74832),(0,52.52138,-1.5364),(.07627,52.53264,-1.54347),(0,52.44441,-1.57115),(.29854,52.83447,-1.38964),(.35358,52.79295,-1.43643),(.19011,52.78673,-1.41434),(.21739,52.79746,-1.41994),(.15704,52.74335,-1.34804),(.15415,52.73216,-1.32533),(.06595,52.67957,-1.20072),(.06485,52.67147,-1.11477),(.13209,52.68274,-1.19139),(.06537,52.70275,-1.28713),(.21205,52.69107,-1.17883),(.06038,52.66655,-.98729),(.29381,52.65035,-1.03714),(.1457,52.54291,-.93895),(.05541,52.53176,-.93923),(.15374,52.44797,-.97163),(.06251,52.43909,-.96631),(.23085,52.46926,-1.00717),(.83618,52.70183,-1.39037),(.91817,52.71938,-1.41683),(.64333,53.01026,-1.40908),(.61511,52.9227,-1.40183),(.40023,52.83618,-1.3739),(.12258,52.54337,-2.39103),(.07529,52.47544,-2.41286),(.11192,52.56259,-2.46352),(.11011,52.63998,-2.37904),(.15051,52.52714,-2.331),(.20566,52.49636,-2.23583),(.12788,52.63416,-2.32356),(.24989,52.45029,-2.16519),(.68677,52.8766,-1.58605),(.59346,52.87415,-1.58474),(.06699,52.29487,-1.22804),(.06833,52.25445,-1.18263),(.06852,52.20936,-1.16598),(.36433,52.29988,-1.38429),(0,52.18919,-1.15045),(0,52.15262,-1.11479),(.05977,52.35511,-1.00104),(.06532,52.28576,-1.03073),(.15528,52.22039,-1.06459),(0,52.54707,-2.09845),(.51971,52.53964,-1.68377),(.66118,52.55983,-1.60419),(.21156,52.68123,-1.87449),(.60392,52.55665,-1.58081),(.57643,52.5241,-1.66882),(.5419,52.54586,-1.60906),(.51763,52.54355,-1.67609),(.11575,52.48008,-2.06827),(.08422,52.42368,-2.3553),(0,52.63789,-2.82916),(.34082,52.17958,-1.19029),(.06254,52.21451,-1.05623),(0,52.15607,-1.10164),(.22869,52.43538,-1.59539),(.0817,52.70845,-2.3819),(.05146,52.73116,-2.473),(.72232,53.01745,-1.43957),(.23289,52.64022,-.97697),(.06515,52.67448,-1.0489),(.14827,52.70939,-1.27797),(.23549,52.7122,-1.26493),(.15822,52.78097,-1.40853),(.58104,52.56335,-1.49207),(.30694,52.83566,-1.40588),(.37451,52.8109,-1.42021),(.06119,52.7915,-2.74908),(.61954,52.59048,-1.48501),(.59881,52.64171,-1.45096),(.59522,52.58689,-1.36889),(.67492,52.4183,-1.84508),(.98732,52.77171,-1.53216),(.13373,52.76208,-2.81953),(-.21156,52.68123,-1.87501),(-1.09221,52.74035,-1.48446),(-.98732,52.77171,-1.53366),(-.07529,52.47544,-2.41302),(-.08422,52.42368,-2.35551),(-.34082,52.17958,-1.19175),(-.36433,52.29988,-1.38572),(0,52.30038,-1.23467),(0,52.31711,-1.29159),(0,52.34077,-1.3639),(-.06515,52.66527,-1.05039),(-.06485,52.66572,-1.11526),(-.14827,52.70939,-1.2794),(-.23549,52.7122,-1.26605),(-.15415,52.73216,-1.32573),(-.15704,52.74335,-1.34842),(-.15822,52.78097,-1.4089),(-.57291,52.54153,-1.46046),(-.58104,52.56335,-1.49368),(-.23289,52.61942,-.99041),(0,52.70376,-2.84966),(-.59522,52.58689,-1.37049),(-.67492,52.4183,-1.84707),(-.30694,52.83566,-1.40651),(0,52.58962,-.93093),(0,52.34044,-1.51619),(0,52.35849,-1.43803),(-.15051,52.52714,-2.33133),(-.06595,52.67844,-1.20263),(0,52.67502,-1.20989),(0,52.66582,-1.12526),(0,52.5271,-.93942),(.33612,52.17506,-1.20266),(.07118,52.75808,-2.82068),(.31338,52.42131,-1.09592),(0,52.66423,-1.05686)]))),
        Shape(DEF='c7disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='c7disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,36,40,-1,41,42,43,-1,33,44,31,-1,34,45,46,-1,28,27,47,-1,48,6,49,-1,50,51,52,-1,53,5,4,-1,54,55,56,-1,57,58,59,-1,10,9,60,-1,61,62,63,-1,64,65,66,-1,67,68,69,-1,70,71,15,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,79,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,77,76,104,-1,78,105,93,-1,106,107,108,-1,109,110,111,-1,112,113,114,-1,115,114,113,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,121,114,109,-1,124,125,126,-1,124,111,110,-1,127,128,129,-1,130,124,131,-1,132,126,84,-1,133,107,134,-1,135,136,83,-1,93,137,138,-1,139,137,96,-1,140,141,88,-1,142,2,143,-1,144,145,146,-1,91,147,89,-1,148,149,150,-1,151,152,153,-1,72,17,154,-1,155,133,156,-1,157,29,28,-1,126,122,121,-1,109,114,129,-1,158,120,159,-1,160,112,118,-1,115,161,162,-1,163,164,160,-1,157,165,127,-1,28,47,166,-1,145,100,99,-1,167,168,102,-1,135,169,104,-1,137,93,105,-1,170,138,137,-1,141,92,91,-1,171,172,173,-1,82,81,174,-1,79,175,176,-1,177,76,153,-1,144,130,131,-1,131,178,144,-1,179,73,180,-1,72,74,181,-1,182,68,18,-1,65,64,183,-1,184,3,185,-1,186,62,61,-1,181,60,9,-1,187,188,64,-1,55,0,56,-1,50,5,53,-1,189,190,191,-1,192,193,51,-1,68,182,194,-1,183,64,188,-1,195,196,197,-1,198,199,200,-1,36,39,198,-1,201,202,43,-1,39,40,203,-1,40,36,38,-1,31,203,204,-1,31,45,34,-1,30,24,46,-1,205,41,35,-1,24,197,196,-1,30,32,206,-1,207,23,208,-1,209,19,210,-1,13,12,66,-1,184,211,4,-1,59,54,188,-1,55,54,58,-1,212,10,213,-1,214,212,213,-1,58,215,55,-1,59,188,187,-1,4,3,184,-1,13,66,216,-1,217,20,19,-1,19,209,217,-1,207,208,200,-1,206,218,30,-1,196,25,24,-1,35,219,205,-1,30,46,45,-1,30,197,24,-1,34,33,31,-1,204,32,31,-1,38,220,40,-1,203,44,39,-1,43,42,201,-1,221,39,222,-1,27,205,223,-1,199,207,200,-1,188,56,183,-1,182,53,194,-1,193,52,51,-1,191,49,189,-1,50,53,51,-1,0,224,56,-1,64,225,187,-1,70,181,9,-1,212,226,10,-1,226,11,10,-1,218,8,195,-1,3,63,185,-1,183,227,65,-1,68,67,18,-1,15,72,181,-1,90,179,180,-1,76,75,153,-1,175,228,176,-1,229,82,174,-1,88,141,91,-1,139,170,137,-1,105,96,137,-1,135,230,169,-1,168,103,102,-1,99,146,145,-1,157,28,166,-1,158,106,160,-1,115,162,116,-1,160,113,112,-1,106,231,163,-1,114,115,129,-1,121,111,126,-1,165,128,127,-1,155,108,133,-1,73,72,154,-1,153,75,151,-1,88,91,89,-1,146,86,144,-1,95,142,143,-1,87,140,88,-1,232,139,96,-1,138,94,93,-1,135,83,82,-1,233,234,235,-1,133,108,107,-1,132,122,126,-1,130,125,124,-1,117,127,129,-1,124,126,111,-1,121,109,111,-1,121,123,112,-1,118,120,158,-1,160,118,158,-1,117,129,115,-1,115,113,161,-1,114,121,112,-1,160,106,163,-1,231,106,108,-1,85,125,130,-1,79,78,93,-1,77,104,169,-1,236,101,103,-1,173,98,100,-1,96,105,97,-1,175,79,94,-1,179,90,92,-1,178,87,89,-1,237,229,174,-1,83,238,81,-1,79,176,80,-1,77,239,75,-1,73,179,74,-1,15,181,70,-1,69,12,67,-1,225,64,66,-1,63,3,61,-1,240,190,241,-1,60,213,10,-1,58,54,59,-1,54,56,188,-1,4,194,53,-1,242,50,52,-1,48,49,191,-1,27,243,47,-1,39,221,198,-1,44,203,31,-1,41,43,35,-1,198,221,199,-1,35,43,33,-1,30,45,31,-1,223,205,219,-1,24,26,223,-1,38,63,220,-1,38,185,63,-1,207,21,23,-1,72,15,17,-1,12,14,67,-1,71,241,209,-1,241,217,209,-1,14,18,67,-1,14,19,18,-1,11,244,9,-1,6,48,7,-1,5,61,3,-1,142,0,2,-1,215,0,55,-1,0,215,1,-1,186,242,245,-1,50,242,186,-1,216,246,13,-1,247,246,216,-1,248,246,247,-1,248,249,246,-1,248,250,249,-1,251,252,210,-1,253,252,251,-1,210,16,209,-1,210,252,16,-1,37,208,254,-1,200,208,37,-1,206,204,62,-1,204,206,32,-1,223,46,24,-1,219,46,223,-1,202,255,222,-1,201,255,202,-1,33,202,44,-1,33,43,202,-1,199,21,207,-1,199,256,21,-1,56,257,183,-1,257,56,224,-1,53,192,51,-1,182,192,53,-1,0,258,224,-1,0,142,258,-1,259,181,74,-1,181,259,60,-1,7,11,226,-1,7,48,11,-1,1,260,2,-1,1,22,260,-1,184,254,57,-1,184,185,254,-1,261,182,18,-1,192,182,261,-1,212,25,226,-1,212,26,25,-1,62,245,206,-1,186,245,62,-1,262,236,98,-1,236,262,263,-1,86,132,84,-1,86,264,132,-1,144,85,130,-1,144,86,85,-1,153,175,177,-1,175,153,228,-1,139,265,170,-1,139,134,265,-1,147,145,89,-1,145,147,100,-1,170,136,138,-1,170,83,136,-1,230,102,169,-1,230,167,102,-1,258,266,267,-1,266,258,97,-1,155,231,108,-1,268,231,155,-1,269,116,162,-1,116,269,270,-1,271,272,273,-1,272,271,274,-1,268,163,231,-1,163,268,273,-1,166,165,157,-1,275,165,166,-1,265,120,238,-1,265,159,120,-1,150,176,228,-1,149,176,150,-1,276,73,154,-1,180,73,276,-1,233,276,234,-1,233,277,276,-1,234,151,235,-1,234,278,151,-1,279,280,281,-1,280,279,282,-1,283,284,278,-1,284,283,281,-1,282,285,280,-1,286,285,282,-1,264,146,168,-1,146,264,86,-1,95,232,96,-1,95,143,232,-1,82,230,135,-1,230,82,229,-1,176,148,80,-1,148,176,149,-1,281,148,284,-1,280,148,281,-1,287,278,234,-1,287,283,278,-1,154,234,276,-1,234,154,287,-1,233,288,263,-1,235,288,233,-1,235,239,288,-1,238,119,81,-1,238,120,119,-1,126,85,84,-1,85,126,125,-1,110,165,124,-1,110,128,165,-1,289,290,271,-1,256,290,289,-1,272,163,273,-1,163,272,164,-1,113,164,161,-1,113,160,164,-1,141,291,292,-1,140,291,141,-1,76,293,104,-1,76,177,293,-1,98,103,99,-1,98,236,103,-1,94,177,175,-1,177,94,293,-1,147,90,171,-1,90,147,91,-1,232,134,139,-1,232,133,134,-1,80,266,78,-1,266,80,285,-1,47,140,166,-1,47,291,140,-1,101,263,288,-1,101,236,263,-1,71,240,241,-1,70,240,71,-1,243,212,214,-1,212,243,26,-1,294,190,189,-1,190,294,241,-1,267,295,257,-1,267,286,295,-1,23,1,215,-1,1,23,22,-1,48,244,11,-1,48,191,244,-1,211,57,59,-1,184,57,211,-1,242,49,6,-1,242,52,49,-1,296,41,205,-1,296,297,41,-1,297,42,41,-1,297,270,42,-1,201,274,255,-1,269,274,201,-1,36,200,37,-1,36,198,200,-1,34,219,35,-1,219,34,46,-1,62,220,63,-1,220,62,204,-1,298,22,21,-1,260,22,298,-1,13,251,14,-1,13,246,251,-1,20,294,299,-1,20,241,294,-1,241,20,217,-1,17,252,300,-1,252,17,16,-1,227,250,248,-1,227,295,250,-1,295,282,250,-1,295,286,282,-1,6,245,242,-1,6,8,245,-1,273,289,271,-1,273,268,289,-1,50,61,5,-1,186,61,50,-1,191,240,244,-1,190,240,191,-1,246,253,251,-1,246,249,253,-1,250,279,249,-1,250,282,279,-1,14,210,19,-1,251,210,14,-1,15,209,16,-1,15,71,209,-1,65,216,66,-1,65,247,216,-1,38,254,185,-1,37,254,38,-1,223,243,27,-1,223,26,243,-1,221,256,199,-1,221,290,256,-1,221,255,290,-1,221,222,255,-1,222,44,202,-1,44,222,39,-1,257,258,267,-1,257,224,258,-1,194,211,301,-1,4,211,194,-1,292,60,259,-1,292,213,60,-1,254,58,57,-1,58,254,208,-1,225,12,69,-1,225,66,12,-1,195,7,196,-1,8,7,195,-1,206,8,218,-1,245,8,206,-1,193,294,189,-1,193,299,294,-1,264,174,132,-1,264,237,174,-1,131,87,178,-1,87,131,275,-1,77,288,239,-1,77,101,288,-1,265,83,170,-1,83,265,238,-1,260,143,2,-1,143,260,156,-1,89,144,178,-1,144,89,145,-1,179,259,74,-1,179,92,259,-1,258,95,97,-1,142,95,258,-1,101,169,102,-1,101,77,169,-1,266,105,78,-1,266,97,105,-1,256,298,21,-1,256,289,298,-1,117,296,127,-1,296,117,297,-1,116,297,117,-1,270,297,116,-1,274,162,272,-1,274,269,162,-1,118,123,119,-1,112,123,118,-1,124,275,131,-1,124,165,275,-1,123,132,174,-1,123,122,132,-1,134,159,265,-1,134,107,159,-1,180,277,172,-1,180,276,277,-1,75,235,151,-1,235,75,239,-1,283,300,302,-1,283,287,300,-1,281,302,279,-1,281,283,302,-1,284,150,152,-1,150,284,148,-1,168,237,264,-1,168,167,237,-1,138,293,94,-1,136,293,138,-1,229,167,230,-1,229,237,167,-1,171,100,147,-1,171,173,100,-1,152,228,153,-1,152,150,228,-1,280,80,148,-1,80,280,285,-1,287,17,300,-1,287,154,17,-1,262,233,263,-1,172,233,262,-1,172,277,233,-1,278,152,151,-1,284,152,278,-1,156,298,155,-1,156,260,298,-1,119,174,81,-1,119,123,174,-1,128,109,129,-1,128,110,109,-1,107,158,159,-1,158,107,106,-1,272,161,164,-1,272,162,161,-1,127,29,157,-1,29,127,296,-1,99,168,146,-1,168,99,103,-1,136,104,293,-1,136,135,104,-1,92,292,259,-1,141,292,92,-1,143,133,232,-1,143,156,133,-1,285,267,266,-1,267,285,286,-1,173,262,98,-1,173,172,262,-1,87,166,140,-1,87,275,166,-1,171,180,172,-1,171,90,180,-1,299,192,261,-1,193,192,299,-1,214,47,243,-1,47,214,291,-1,226,196,7,-1,226,25,196,-1,257,227,183,-1,257,295,227,-1,208,215,58,-1,215,208,23,-1,70,244,240,-1,70,9,244,-1,69,187,225,-1,69,301,187,-1,52,189,49,-1,193,189,52,-1,301,68,194,-1,69,68,301,-1,291,213,292,-1,291,214,213,-1,29,205,27,-1,29,296,205,-1,42,269,201,-1,42,270,269,-1,255,271,290,-1,255,274,271,-1,204,40,220,-1,204,203,40,-1,195,30,218,-1,195,197,30,-1,299,18,20,-1,299,261,18,-1,300,253,302,-1,253,300,252,-1,302,249,279,-1,253,249,302,-1,248,65,227,-1,248,247,65,-1,301,59,187,-1,301,211,59,-1,298,268,155,-1,268,298,289,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='c7disc_Coord',point=[(.07392,52.11133,-1.11317),(.06861,52.14787,-1.11244),(0,52.14527,-1.11372),(.38541,52.25048,-1.3439),(.39794,52.23356,-1.37168),(.38895,52.28411,-1.42072),(.3528,52.359,-1.53088),(.27782,52.38471,-1.56661),(.332,52.37017,-1.50223),(.16988,52.3294,-1.63175),(.15673,52.33658,-1.6239),(.25481,52.35791,-1.61572),(.35833,52.15322,-1.34968),(.27875,52.14031,-1.31601),(.31195,52.1808,-1.42069),(.08717,52.24849,-1.61279),(.07944,52.22656,-1.58798),(0,52.22124,-1.57255),(.39123,52.24098,-1.47551),(.32033,52.22274,-1.4969),(.31118,52.26331,-1.55409),(.0738,52.18934,-1.15124),(.06842,52.16009,-1.1178),(.14822,52.16355,-1.1207),(.21875,52.38034,-1.55027),(.22388,52.37707,-1.58026),(.13884,52.35623,-1.58205),(.07216,52.34378,-1.54084),(0,52.34139,-1.54476),(0,52.34201,-1.54245),(.29204,52.35541,-1.46513),(.1956,52.34941,-1.39451),(.29189,52.33501,-1.43457),(.16935,52.3662,-1.3822),(.15657,52.37479,-1.41188),(.11145,52.38793,-1.42873),(.18998,52.25017,-1.25602),(.3106,52.18568,-1.23116),(.32169,52.2198,-1.29015),(.17611,52.29222,-1.2433),(.20688,52.27812,-1.28811),(.06526,52.36301,-1.43846),(.06259,52.34204,-1.35799),(.1131,52.35044,-1.36187),(.17868,52.32116,-1.3101),(.17721,52.35239,-1.43022),(.15928,52.35065,-1.44492),(0,52.34759,-1.56923),(.29233,52.3673,-1.5953),(.35881,52.34961,-1.54893),(.38983,52.29134,-1.42429),(.39415,52.27669,-1.4403),(.37772,52.32394,-1.50235),(.39564,52.27111,-1.43572),(.24987,52.12846,-1.16428),(.16195,52.11778,-1.12001),(.17146,52.10077,-1.12962),(.33178,52.16973,-1.21044),(.24552,52.16175,-1.15285),(.32942,52.14134,-1.22513),(.07769,52.29495,-1.61846),(.36847,52.29723,-1.39042),(.35713,52.29799,-1.38363),(.37468,52.25514,-1.33912),(.2471,52.09153,-1.20193),(.24074,52.08941,-1.21227),(.29973,52.1144,-1.26472),(.38341,52.20252,-1.42496),(.39238,52.20876,-1.41757),(.36879,52.15693,-1.34162),(.19038,52.30366,-1.64344),(.19341,52.29136,-1.64016),(0,52.23268,-1.59794),(-.08717,52.24849,-1.61316),(0,52.24321,-1.60557),(-.38341,52.20252,-1.42658),(-.39238,52.20876,-1.41922),(-.39821,52.24883,-1.46977),(-.17634,52.07075,-1.15442),(-.2471,52.09153,-1.20309),(-.17413,52.06825,-1.1653),(-.37468,52.25514,-1.34064),(-.38541,52.25048,-1.34546),(-.37199,52.20107,-1.25801),(-.3201,52.3704,-1.49305),(-.31128,52.37529,-1.50827),(-.332,52.37017,-1.50345),(-.13963,52.3517,-1.59612),(-.15673,52.33658,-1.62451),(-.25481,52.35791,-1.61667),(-.19038,52.30366,-1.64419),(-.16988,52.3294,-1.63241),(-.07769,52.29495,-1.61878),(-.25358,52.11605,-1.17691),(-.32604,52.13266,-1.23352),(-.07392,52.11133,-1.11352),(-.16195,52.11778,-1.12075),(-.07806,52.09247,-1.1196),(-.3673,52.32282,-1.57589),(-.35881,52.34961,-1.55026),(-.29442,52.35475,-1.61049),(-.39544,52.25446,-1.47723),(-.39415,52.27669,-1.44186),(-.37772,52.32394,-1.50379),(-.39983,52.22703,-1.38829),(-.17146,52.10077,-1.13041),(-.17458,52.23266,-1.23517),(-.23193,52.18012,-1.19452),(-.14284,52.18382,-1.16555),(-.15657,52.37479,-1.41247),(-.15928,52.35065,-1.44553),(-.17721,52.35239,-1.4309),(-.20576,52.31781,-1.33697),(-.17868,52.32116,-1.31081),(-.16935,52.3662,-1.38284),(-.1131,52.35044,-1.3623),(-.06259,52.34204,-1.35824),(-.06526,52.36301,-1.4387),(-.20688,52.27812,-1.28896),(-.32038,52.25793,-1.34892),(-.32169,52.2198,-1.2915),(-.1956,52.34941,-1.39526),(-.29189,52.33501,-1.43569),(-.31078,52.28583,-1.38056),(-.21875,52.38034,-1.55108),(-.28102,52.37832,-1.52664),(-.29204,52.35541,-1.46623),(-.0698,52.34126,-1.5111),(-.12343,52.34716,-1.47476),(-.11145,52.38793,-1.42915),(-.26999,52.38679,-1.5555),(-.22388,52.37707,-1.58109),(-.32987,52.34889,-1.44699),(-.14822,52.16355,-1.12136),(-.24118,52.17121,-1.15788),(-.39794,52.23356,-1.37332),(-.37879,52.17861,-1.28881),(-.24987,52.12846,-1.16541),(-.32942,52.14134,-1.2266),(-.24552,52.16175,-1.15393),(-.07811,52.34047,-1.59482),(-.07964,52.31076,-1.61408),(0,52.10833,-1.10837),(-.06861,52.14787,-1.11275),(-.27782,52.38471,-1.56762),(-.29233,52.3673,-1.59638),(-.3528,52.359,-1.53219),(-.27507,52.35076,-1.62136),(-.18444,52.09206,-1.2115),(-.22782,52.10538,-1.23717),(-.26897,52.12522,-1.27515),(-.31195,52.1808,-1.42206),(-.27875,52.14031,-1.31727),(-.35833,52.15322,-1.35126),(-.07944,52.22656,-1.58832),(-.0738,52.18934,-1.1517),(-.06842,52.16009,-1.11812),(-.07216,52.34378,-1.54112),(-.18998,52.25017,-1.25681),(-.3106,52.18568,-1.23251),(-.17611,52.29222,-1.24432),(-.12497,52.32001,-1.30005),(-.06628,52.3176,-1.28792),(-.1332,52.26465,-1.20182),(-.13327,52.29185,-1.23428),(-.1398,52.35234,-1.53635),(-.07849,52.3463,-1.58296),(-.38983,52.29134,-1.42582),(-.36837,52.33391,-1.48241),(-.39564,52.27111,-1.4373),(-.33178,52.16973,-1.21188),(-.29786,52.32315,-1.62939),(-.30261,52.31205,-1.62568),(-.30163,52.32342,-1.62759),(-.35713,52.29799,-1.38503),(-.30953,52.1157,-1.25673),(-.24074,52.08941,-1.2134),(-.36879,52.15693,-1.34325),(-.22758,52.37206,-1.59517),(-.08341,52.25999,-1.61872),(-.19341,52.29136,-1.64093),(.08341,52.25999,-1.61837),(.39821,52.24883,-1.46815),(.17634,52.07075,-1.15358),(.37199,52.20107,-1.25644),(.36386,52.20841,-1.25507),(.36865,52.29843,-1.39107),(.32604,52.13266,-1.23206),(.25358,52.11605,-1.17575),(.3673,52.32282,-1.5745),(.30163,52.32342,-1.62644),(.29442,52.35475,-1.60939),(.39544,52.25446,-1.47564),(.38717,52.29852,-1.53414),(.39983,52.22703,-1.38664),(.31128,52.37529,-1.50713),(.26999,52.38679,-1.55452),(.28102,52.37832,-1.5256),(.17458,52.23266,-1.23443),(.13728,52.20824,-1.18114),(.23193,52.18012,-1.19351),(.06628,52.3176,-1.28738),(.12497,52.32001,-1.29945),(.20576,52.31781,-1.33615),(.31078,52.28583,-1.37931),(.0698,52.34126,-1.51083),(.32987,52.34889,-1.44575),(.14284,52.18382,-1.16492),(.24118,52.17121,-1.15682),(.20149,52.25147,-1.5988),(.19422,52.19945,-1.50504),(.37879,52.17861,-1.28718),(.13963,52.3517,-1.59559),(.07964,52.31076,-1.61377),(.07811,52.34047,-1.59452),(.14956,52.15285,-1.11481),(.26897,52.12522,-1.27392),(.29753,52.27038,-1.57457),(.3201,52.3704,-1.49187),(.12343,52.34716,-1.47428),(.32038,52.25793,-1.34761),(.1332,52.26465,-1.20052),(.13327,52.29185,-1.23303),(.1398,52.35234,-1.53582),(.07806,52.09247,-1.11924),(.30953,52.1157,-1.25531),(.22758,52.37206,-1.59432),(.17413,52.06825,-1.16447),(-.29973,52.1144,-1.2661),(-.36847,52.29723,-1.39186),(-.38895,52.28411,-1.42225),(-.13728,52.20824,-1.18181),(-.14956,52.15285,-1.11548),(-.31118,52.26331,-1.55535),(-.19422,52.19945,-1.50588),(-.32033,52.22274,-1.49825),(-.38717,52.29852,-1.53564),(-.36865,52.29843,-1.39251),(-.36386,52.20841,-1.2566),(-.39123,52.24098,-1.47711),(.29786,52.32315,-1.62825),(.30261,52.31205,-1.62451),(.36837,52.33391,-1.48102),(.07849,52.3463,-1.58265),(.27507,52.35076,-1.62033),(.34158,52.34862,-1.45294),(.18949,52.12123,-1.29422),(.22782,52.10538,-1.23611),(.18444,52.09206,-1.21063),(.08567,52.1091,-1.28312),(.0847,52.08246,-1.1868),(.18968,52.16159,-1.4132),(.08243,52.18404,-1.49541),(.08509,52.14858,-1.40132),(.32749,52.17865,-1.21231),(.06699,52.29487,-1.22804),(.06852,52.20936,-1.16598),(.08027,52.05993,-1.14029),(0,52.08484,-1.11431),(0,52.28238,-1.60919),(0,52.15787,-1.11993),(.38956,52.24589,-1.48197),(-.36373,52.31217,-1.57869),(-.38202,52.29101,-1.54288),(-.34158,52.34862,-1.45422),(-.32749,52.17865,-1.21373),(-.08027,52.05993,-1.14068),(0,52.05086,-1.13484),(-.06852,52.20936,-1.16655),(0,52.31711,-1.29159),(0,52.34077,-1.3639),(0,52.26073,-1.18618),(-.06699,52.29487,-1.22894),(-.06833,52.25445,-1.18354),(0,52.30038,-1.23467),(-.13884,52.35623,-1.58258),(-.20149,52.25147,-1.59964),(-.29753,52.27038,-1.57577),(-.18968,52.16159,-1.41406),(0,52.09261,-1.27204),(-.0847,52.08246,-1.1872),(-.08567,52.1091,-1.28352),(0,52.06912,-1.17724),(-.08509,52.14858,-1.40172),(-.18949,52.12123,-1.2951),(-.07953,52.05725,-1.15118),(0,52.04826,-1.14517),(-.08243,52.18404,-1.49578),(-.38956,52.24589,-1.48356),(0,52.20936,-1.16628),(.06833,52.25445,-1.18263),(0,52.34287,-1.58077),(0,52.308,-1.60279),(-.37981,52.17165,-1.30886),(.36373,52.31217,-1.5773),(.07953,52.05725,-1.15079),(0,52.34044,-1.51619),(0,52.35849,-1.43803),(0,52.18919,-1.15045),(.38202,52.29101,-1.54139),(0,52.17247,-1.48976),(.37981,52.17165,-1.30722),(0,52.13495,-1.39041)]))),
        Shape(DEF='t',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,23,-1,24,32,33,-1,34,35,36,-1,37,35,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,41,50,39,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,67,66,75,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,94,89,88,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,110,111,112,-1,109,113,99,-1,114,115,116,-1,117,118,119,-1,120,121,122,-1,116,123,124,-1,125,126,115,-1,127,128,129,-1,130,131,132,-1,133,134,135,-1,136,137,17,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,2,5,150,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,151,163,164,-1,165,160,166,-1,164,167,168,-1,169,170,171,-1,60,172,61,-1,173,153,152,-1,168,174,175,-1,176,177,178,-1,179,180,181,-1,182,183,184,-1,185,186,187,-1,188,101,103,-1,189,190,191,-1,192,193,194,-1,195,196,197,-1,198,199,100,-1,200,201,202,-1,203,204,205,-1,206,207,208,-1,208,207,209,-1,210,211,212,-1,213,214,215,-1,216,217,218,-1,193,192,219,-1,220,216,221,-1,222,223,178,-1,224,169,225,-1,226,227,228,-1,229,172,230,-1,226,231,65,-1,232,233,234,-1,235,236,156,-1,237,185,238,-1,56,239,240,-1,234,233,241,-1,155,242,1,-1,243,4,244,-1,245,209,207,-1,246,247,248,-1,249,250,251,-1,252,253,254,-1,255,256,257,-1,258,259,260,-1,261,262,263,-1,264,265,266,-1,139,267,140,-1,268,130,269,-1,264,270,265,-1,271,272,273,-1,274,275,46,-1,276,277,278,-1,269,279,280,-1,281,282,283,-1,280,284,285,-1,246,286,7,-1,287,142,288,-1,118,117,133,-1,276,289,20,-1,133,117,134,-1,15,137,290,-1,17,16,291,-1,292,293,12,-1,9,294,10,-1,295,296,297,-1,18,298,299,-1,300,301,302,-1,27,303,304,-1,305,306,307,-1,308,309,310,-1,189,188,311,-1,312,313,50,-1,314,84,315,-1,316,317,318,-1,319,320,193,-1,311,316,321,-1,322,323,324,-1,325,238,185,-1,107,99,326,-1,100,327,198,-1,198,327,328,-1,329,330,191,-1,238,331,321,-1,332,74,333,-1,34,334,335,-1,37,336,337,-1,24,38,32,-1,338,82,339,-1,314,284,82,-1,340,341,342,-1,343,344,345,-1,346,85,76,-1,347,348,86,-1,349,350,86,-1,351,352,353,-1,354,355,356,-1,357,358,359,-1,360,361,362,-1,363,364,360,-1,365,366,22,-1,367,368,369,-1,370,367,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,379,378,381,-1,382,383,384,-1,385,386,387,-1,388,389,390,-1,391,392,393,-1,394,395,396,-1,397,398,399,-1,400,401,402,-1,403,404,405,-1,406,407,408,-1,409,410,411,-1,412,413,414,-1,415,416,417,-1,418,419,420,-1,421,422,423,-1,424,425,426,-1,427,420,419,-1,428,429,430,-1,431,432,417,-1,433,434,435,-1,417,432,418,-1,431,436,437,-1,438,439,440,-1,439,438,441,-1,442,443,444,-1,445,446,447,-1,448,392,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,463,465,464,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,401,-1,480,481,482,-1,483,484,485,-1,484,486,487,-1,488,489,490,-1,491,492,493,-1,490,494,495,-1,496,401,400,-1,497,498,499,-1,500,491,501,-1,502,503,504,-1,505,506,507,-1,508,509,510,-1,511,446,445,-1,512,513,474,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,520,523,521,-1,524,525,526,-1,527,528,529,-1,530,531,532,-1,533,534,535,-1,534,536,537,-1,534,533,536,-1,538,539,485,-1,502,540,541,-1,401,542,478,-1,543,544,545,-1,546,481,480,-1,547,548,549,-1,550,551,552,-1,553,554,555,-1,450,553,555,-1,454,556,452,-1,352,557,453,-1,356,547,558,-1,559,514,482,-1,560,561,562,-1,563,564,565,-1,566,563,565,-1,567,568,353,-1,569,570,571,-1,572,470,573,-1,574,471,470,-1,575,576,577,-1,578,579,580,-1,581,385,582,-1,583,384,383,-1,584,585,586,-1,386,383,382,-1,587,588,589,-1,582,387,590,-1,591,584,592,-1,590,593,594,-1,595,596,588,-1,597,598,599,-1,600,601,602,-1,466,603,604,-1,458,605,606,-1,362,361,607,-1,358,608,293,-1,579,609,610,-1,611,612,613,-1,614,615,616,-1,617,370,618,-1,378,617,619,-1,375,620,381,-1,394,550,621,-1,622,623,553,-1,395,624,625,-1,398,397,396,-1,626,627,628,-1,629,630,631,-1,548,531,631,-1,596,595,530,-1,484,483,545,-1,632,633,634,-1,539,508,485,-1,633,632,477,-1,476,635,636,-1,637,638,639,-1,640,641,642,-1,643,644,645,-1,646,647,648,-1,649,650,651,-1,652,653,654,-1,655,653,656,-1,657,649,658,-1,659,660,661,-1,662,663,664,-1,602,422,435,-1,665,407,406,-1,373,372,666,-1,667,668,365,-1,669,377,670,-1,671,410,672,-1,673,437,589,-1,674,675,676,-1,677,678,679,-1,680,681,682,-1,428,683,684,-1,685,681,686,-1,684,687,686,-1,421,688,689,-1,690,691,692,-1,693,688,694,-1,688,678,677,-1,686,687,695,-1,686,681,416,-1,415,430,429,-1,425,685,426,-1,427,674,676,-1,419,588,596,-1,668,667,696,-1,373,665,374,-1,697,663,662,-1,640,698,475,-1,660,659,699,-1,440,700,649,-1,647,446,701,-1,702,703,704,-1,324,705,706,-1,638,512,474,-1,704,638,637,-1,477,636,633,-1,707,708,441,-1,596,532,633,-1,709,630,393,-1,586,710,711,-1,397,551,396,-1,625,624,712,-1,711,629,586,-1,713,714,715,-1,716,717,718,-1,719,376,720,-1,721,303,722,-1,723,301,300,-1,724,725,726,-1,727,728,363,-1,729,294,608,-1,359,293,607,-1,727,730,731,-1,290,137,362,-1,605,458,457,-1,732,461,457,-1,461,460,457,-1,733,691,456,-1,597,600,734,-1,587,590,595,-1,594,593,591,-1,591,593,735,-1,582,587,736,-1,382,384,737,-1,586,585,389,-1,383,386,738,-1,739,582,562,-1,575,740,574,-1,572,383,738,-1,573,741,742,-1,743,744,569,-1,745,353,746,-1,469,747,570,-1,748,749,568,-1,750,462,464,-1,637,598,597,-1,751,752,514,-1,753,754,750,-1,755,356,756,-1,453,557,757,-1,551,397,758,-1,640,704,759,-1,755,760,548,-1,761,557,762,-1,763,494,500,-1,764,504,503,-1,478,543,765,-1,766,767,506,-1,707,438,510,-1,768,528,767,-1,769,770,771,-1,772,773,774,-1,775,515,514,-1,775,752,776,-1,499,521,523,-1,777,202,778,-1,779,780,781,-1,535,767,782,-1,707,509,536,-1,715,660,783,-1,438,661,714,-1,704,703,512,-1,538,784,539,-1,540,502,478,-1,502,504,479,-1,479,478,502,-1,785,786,787,-1,489,494,490,-1,785,788,496,-1,789,498,497,-1,402,479,790,-1,791,792,402,-1,487,486,793,-1,794,795,490,-1,486,545,544,-1,768,488,795,-1,542,496,788,-1,481,796,482,-1,519,797,517,-1,513,777,472,-1,640,798,641,-1,575,574,581,-1,137,136,606,-1,799,605,460,-1,576,800,580,-1,453,801,352,-1,567,745,571,-1,743,454,452,-1,604,732,457,-1,572,802,803,-1,581,738,386,-1,571,455,569,-1,392,804,449,-1,805,650,700,-1,806,444,443,-1,807,779,652,-1,780,779,646,-1,645,808,643,-1,435,434,635,-1,809,676,683,-1,810,677,811,-1,636,676,675,-1,415,418,420,-1,812,813,814,-1,663,678,693,-1,406,815,816,-1,414,812,672,-1,404,817,495,-1,818,789,497,-1,819,624,621,-1,820,393,711,-1,551,394,396,-1,627,821,628,-1,393,820,822,-1,735,386,382,-1,582,385,387,-1,711,710,820,-1,374,696,667,-1,665,823,696,-1,722,617,824,-1,21,825,826,-1,362,731,730,-1,362,137,731,-1,359,360,364,-1,358,357,611,-1,468,600,599,-1,355,754,796,-1,354,356,558,-1,827,828,73,-1,829,288,830,-1,831,828,830,-1,86,350,832,-1,86,348,344,-1,87,832,88,-1,833,348,834,-1,835,836,92,-1,89,84,83,-1,339,95,338,-1,837,32,838,-1,337,336,26,-1,839,38,335,-1,332,334,34,-1,74,840,333,-1,80,79,841,-1,842,843,664,-1,311,321,331,-1,101,191,330,-1,844,845,846,-1,327,847,848,-1,98,326,99,-1,645,849,850,-1,851,852,853,-1,854,238,325,-1,149,855,247,-1,149,247,147,-1,94,856,857,-1,317,316,311,-1,318,317,858,-1,318,315,316,-1,859,315,860,-1,861,862,863,-1,864,865,863,-1,40,271,273,-1,51,866,867,-1,868,56,55,-1,869,870,871,-1,49,867,872,-1,308,873,874,-1,302,301,875,-1,876,877,29,-1,878,879,880,-1,881,11,882,-1,20,19,276,-1,12,293,608,-1,291,16,14,-1,607,292,15,-1,119,883,884,-1,7,286,841,-1,6,246,7,-1,284,314,285,-1,281,885,285,-1,282,45,283,-1,44,885,42,-1,280,279,284,-1,46,265,270,-1,45,273,272,-1,265,275,886,-1,268,44,138,-1,887,278,130,-1,140,888,131,-1,139,889,890,-1,263,889,891,-1,262,892,889,-1,265,886,266,-1,116,892,114,-1,126,116,115,-1,893,124,123,-1,894,895,252,-1,896,897,128,-1,2,150,125,-1,898,899,8,-1,3,900,901,-1,235,156,1,-1,241,233,0,-1,902,903,234,-1,904,869,905,-1,904,906,869,-1,907,239,868,-1,232,861,235,-1,908,234,903,-1,909,910,911,-1,912,228,227,-1,163,913,223,-1,178,223,914,-1,108,195,915,-1,859,916,314,-1,917,918,919,-1,920,921,922,-1,204,203,213,-1,179,923,209,-1,146,145,186,-1,194,193,320,-1,219,192,317,-1,184,220,221,-1,924,157,177,-1,164,175,151,-1,175,152,151,-1,912,925,228,-1,926,914,153,-1,63,927,165,-1,170,928,929,-1,925,930,931,-1,932,933,934,-1,164,935,182,-1,934,933,216,-1,318,858,935,-1,223,222,911,-1,153,914,913,-1,900,910,909,-1,936,911,910,-1,914,176,178,-1,937,857,321,-1,146,148,938,-1,854,311,331,-1,117,884,143,-1,143,884,939,-1,249,898,250,-1,887,132,133,-1,117,143,142,-1,121,120,241,-1,902,122,905,-1,940,941,942,-1,111,109,112,-1,104,943,105,-1,319,103,851,-1,102,851,103,-1,339,279,944,-1,945,95,341,-1,346,78,946,-1,81,947,948,-1,834,946,340,-1,90,76,85,-1,343,345,93,-1,856,80,286,-1,77,82,78,-1,839,949,950,-1,951,840,952,-1,68,836,835,-1,951,953,954,-1,955,334,71,-1,97,341,95,-1,956,65,64,-1,957,958,903,-1,50,941,48,-1,940,959,960,-1,271,961,962,-1,42,47,270,-1,275,265,46,-1,963,964,965,-1,966,964,28,-1,32,306,33,-1,35,335,38,-1,964,29,28,-1,28,304,966,-1,366,30,23,-1,967,968,969,-1,16,15,292,-1,9,970,13,-1,882,11,971,-1,11,10,971,-1,893,972,150,-1,972,125,150,-1,2,1,242,-1,13,12,9,-1,14,16,292,-1,14,13,295,-1,23,22,366,-1,882,971,973,-1,31,26,974,-1,882,975,880,-1,966,965,964,-1,47,283,45,-1,976,962,977,-1,42,270,43,-1,957,903,902,-1,962,978,271,-1,940,958,959,-1,50,313,941,-1,54,979,55,-1,961,980,977,-1,171,981,225,-1,70,955,71,-1,342,982,983,-1,984,951,952,-1,946,347,346,-1,82,338,78,-1,830,79,81,-1,93,92,343,-1,85,87,90,-1,946,945,340,-1,81,80,947,-1,78,945,946,-1,983,985,91,-1,341,340,945,-1,102,852,851,-1,986,987,100,-1,113,109,111,-1,988,853,989,-1,99,113,100,-1,940,942,958,-1,890,127,139,-1,129,888,267,-1,115,121,241,-1,125,972,126,-1,990,117,142,-1,133,289,887,-1,898,258,250,-1,939,8,143,-1,890,889,257,-1,146,149,148,-1,321,316,937,-1,914,171,176,-1,909,179,900,-1,318,935,991,-1,934,216,161,-1,182,167,164,-1,165,932,934,-1,931,992,925,-1,993,170,929,-1,165,166,63,-1,153,173,926,-1,205,172,60,-1,925,992,228,-1,157,159,177,-1,184,221,994,-1,192,183,317,-1,112,109,995,-1,145,323,186,-1,209,900,179,-1,996,181,180,-1,997,204,213,-1,62,918,998,-1,62,919,918,-1,919,218,917,-1,859,999,916,-1,108,107,195,-1,159,1000,177,-1,223,913,914,-1,163,151,913,-1,222,909,911,-1,903,1001,908,-1,232,862,861,-1,240,976,977,-1,239,56,868,-1,1002,1003,1004,-1,905,869,1005,-1,902,234,120,-1,241,0,125,-1,0,235,1,-1,900,209,901,-1,128,894,896,-1,894,128,895,-1,893,253,124,-1,116,255,892,-1,263,262,889,-1,263,891,266,-1,266,1006,264,-1,139,891,889,-1,140,267,888,-1,887,276,278,-1,44,43,138,-1,275,274,1007,-1,45,1008,273,-1,269,278,277,-1,279,339,284,-1,44,280,885,-1,1008,282,281,-1,281,1009,885,-1,874,1010,96,-1,6,1011,246,-1,841,141,7,-1,143,8,7,-1,290,607,15,-1,291,14,295,-1,12,608,9,-1,11,1012,970,-1,882,1013,881,-1,876,29,1014,-1,302,875,1015,-1,1014,29,964,-1,963,25,33,-1,57,868,55,-1,869,1004,870,-1,1016,58,979,-1,54,977,980,-1,864,863,1017,-1,863,999,861,-1,916,285,314,-1,163,991,935,-1,318,860,315,-1,858,317,183,-1,937,316,315,-1,857,937,94,-1,247,206,147,-1,325,1018,854,-1,645,644,849,-1,98,1019,326,-1,847,988,989,-1,1020,328,327,-1,656,328,655,-1,846,989,844,-1,330,102,101,-1,664,74,842,-1,841,286,80,-1,332,71,334,-1,839,950,38,-1,26,30,337,-1,32,950,838,-1,339,82,284,-1,836,73,92,-1,88,90,87,-1,86,85,347,-1,86,1021,349,-1,831,830,81,-1,829,830,1022,-1,827,73,72,-1,1023,1024,72,-1,481,756,796,-1,558,352,354,-1,599,1025,468,-1,611,729,358,-1,359,361,360,-1,610,609,724,-1,826,22,21,-1,824,721,722,-1,368,300,1026,-1,696,374,665,-1,667,372,374,-1,592,584,1027,-1,390,389,1028,-1,389,1029,1028,-1,735,382,584,-1,393,822,391,-1,1030,1031,1032,-1,627,1033,821,-1,399,1033,388,-1,789,817,1034,-1,404,495,1035,-1,811,1036,1037,-1,1036,414,672,-1,1036,672,1037,-1,810,811,1037,-1,814,672,812,-1,415,420,430,-1,675,633,636,-1,421,435,422,-1,675,674,419,-1,428,686,429,-1,809,427,676,-1,424,677,810,-1,683,676,636,-1,1038,1039,437,-1,780,646,1040,-1,438,1041,661,-1,805,442,444,-1,646,1042,446,-1,392,391,804,-1,800,562,578,-1,386,385,581,-1,466,604,457,-1,452,451,743,-1,567,571,570,-1,453,455,801,-1,1043,563,1044,-1,461,576,580,-1,459,799,460,-1,606,731,137,-1,575,581,739,-1,467,456,601,-1,474,513,472,-1,639,473,1045,-1,351,355,354,-1,544,542,788,-1,755,1046,1047,-1,541,1048,503,-1,795,1049,768,-1,486,484,545,-1,795,488,490,-1,487,793,1050,-1,402,790,791,-1,789,1034,498,-1,1051,785,496,-1,793,787,1050,-1,540,478,765,-1,1052,1053,1054,-1,784,507,539,-1,512,638,704,-1,438,714,510,-1,783,1055,715,-1,509,537,536,-1,782,1056,535,-1,202,201,778,-1,523,1057,499,-1,514,752,775,-1,1058,1059,520,-1,771,1060,769,-1,767,766,768,-1,510,509,707,-1,505,766,506,-1,763,500,1061,-1,1062,498,1034,-1,761,757,557,-1,755,548,547,-1,640,759,698,-1,397,399,390,-1,758,552,551,-1,553,623,554,-1,453,757,454,-1,756,1046,755,-1,514,559,751,-1,759,637,597,-1,750,1063,462,-1,748,568,566,-1,743,569,455,-1,573,742,1064,-1,581,802,738,-1,562,800,739,-1,586,389,388,-1,582,736,562,-1,594,591,592,-1,588,587,595,-1,734,1065,597,-1,600,467,601,-1,733,692,691,-1,605,457,460,-1,727,731,726,-1,359,607,361,-1,729,608,358,-1,727,1066,728,-1,724,609,725,-1,371,367,369,-1,716,1067,717,-1,1068,1069,1070,-1,629,1027,586,-1,393,1071,709,-1,633,675,596,-1,634,508,632,-1,441,438,707,-1,475,632,713,-1,637,759,704,-1,638,474,639,-1,706,1072,324,-1,702,704,640,-1,647,646,446,-1,781,652,779,-1,653,652,781,-1,440,649,657,-1,783,660,699,-1,713,715,641,-1,475,798,640,-1,1073,679,678,-1,697,662,1074,-1,816,1075,697,-1,373,407,665,-1,589,419,673,-1,596,675,419,-1,429,416,415,-1,686,428,684,-1,686,1076,685,-1,689,688,677,-1,693,1024,1023,-1,693,678,688,-1,690,423,691,-1,421,423,688,-1,695,1076,686,-1,416,429,686,-1,428,809,683,-1,677,679,811,-1,588,419,589,-1,671,672,814,-1,669,1077,377,-1,365,1078,667,-1,372,1077,666,-1,406,1074,665,-1,697,412,663,-1,435,734,602,-1,662,664,843,-1,798,475,713,-1,661,1041,659,-1,657,658,1079,-1,1080,651,652,-1,648,1040,646,-1,643,1081,644,-1,700,440,439,-1,642,702,640,-1,1045,637,639,-1,1045,776,637,-1,636,477,476,-1,713,632,508,-1,485,508,634,-1,633,1082,634,-1,1082,633,532,-1,548,631,549,-1,631,1083,629,-1,586,388,710,-1,394,551,550,-1,622,1084,623,-1,1085,626,822,-1,1086,1067,716,-1,618,619,617,-1,369,611,613,-1,357,1087,611,-1,293,359,358,-1,362,607,290,-1,606,1088,458,-1,600,468,467,-1,602,734,600,-1,600,597,599,-1,1039,671,1086,-1,595,590,594,-1,594,592,1027,-1,590,587,582,-1,589,736,587,-1,561,578,562,-1,586,1027,584,-1,1029,737,384,-1,581,582,739,-1,800,578,580,-1,577,740,575,-1,470,803,574,-1,738,802,572,-1,572,803,470,-1,572,583,383,-1,569,1089,570,-1,455,571,801,-1,353,745,567,-1,566,1090,563,-1,563,1091,564,-1,352,351,354,-1,468,1025,465,-1,562,736,560,-1,559,482,796,-1,356,755,547,-1,352,558,557,-1,454,757,556,-1,1070,553,450,-1,623,1092,1093,-1,550,552,1094,-1,397,1028,758,-1,547,549,762,-1,546,480,765,-1,1061,500,501,-1,543,542,544,-1,542,543,478,-1,484,538,485,-1,535,701,533,-1,596,530,532,-1,529,769,527,-1,769,529,818,-1,818,770,769,-1,516,482,514,-1,512,705,513,-1,708,707,536,-1,508,539,509,-1,784,505,507,-1,502,541,503,-1,500,492,491,-1,400,1051,496,-1,495,794,490,-1,1095,1096,764,-1,1096,790,764,-1,493,1097,491,-1,488,1098,489,-1,538,484,487,-1,483,485,634,-1,546,765,543,-1,542,401,496,-1,482,516,480,-1,481,546,1099,-1,479,402,401,-1,477,632,475,-1,473,639,474,-1,798,713,641,-1,467,466,457,-1,468,1100,466,-1,461,580,459,-1,456,467,457,-1,801,746,352,-1,454,743,455,-1,740,577,1043,-1,574,1044,471,-1,1101,448,449,-1,779,1042,646,-1,649,700,650,-1,447,446,1042,-1,779,807,1102,-1,438,440,1041,-1,431,437,432,-1,810,1037,409,-1,417,418,415,-1,433,435,421,-1,431,417,680,-1,430,809,428,-1,419,674,427,-1,426,677,424,-1,734,435,635,-1,418,673,419,-1,1077,1103,666,-1,1073,412,414,-1,811,679,1036,-1,1075,1104,413,-1,406,408,815,-1,437,436,1038,-1,1105,403,405,-1,792,1106,402,-1,402,1106,400,-1,817,404,403,-1,556,1101,1068,-1,392,1071,393,-1,390,399,388,-1,452,556,1068,-1,386,735,387,-1,397,390,1028,-1,584,591,735,-1,824,378,380,-1,614,371,369,-1,1107,1078,1108,-1,371,618,370,-1,824,617,378,-1,380,721,824,-1,22,826,365,-1,969,1109,967,-1,362,730,360,-1,359,364,357,-1,352,746,353,-1,344,1021,86,-1,832,87,86,-1,346,347,85,-1,340,342,1110,-1,89,83,1111,-1,82,84,314,-1,38,950,32,-1,35,34,335,-1,333,954,69,-1,332,842,74,-1,73,836,952,-1,321,237,238,-1,854,189,311,-1,191,190,329,-1,107,109,99,-1,185,187,325,-1,324,1072,322,-1,315,94,937,-1,193,103,319,-1,314,315,859,-1,312,50,1017,-1,41,40,273,-1,54,56,977,-1,1112,58,1016,-1,1005,1113,957,-1,310,873,308,-1,882,973,975,-1,299,19,18,-1,295,297,291,-1,9,608,294,-1,292,607,293,-1,291,298,17,-1,117,990,134,-1,276,887,289,-1,133,132,118,-1,288,829,287,-1,141,143,7,-1,246,1114,286,-1,96,339,944,-1,96,95,339,-1,285,885,280,-1,283,1009,281,-1,47,1009,283,-1,269,280,44,-1,276,309,277,-1,271,978,272,-1,269,44,268,-1,264,1006,138,-1,263,1115,261,-1,972,893,123,-1,258,260,250,-1,253,1116,254,-1,249,251,243,-1,246,1011,247,-1,245,901,209,-1,1,156,155,-1,241,120,234,-1,906,1004,869,-1,240,977,56,-1,962,961,977,-1,237,248,185,-1,235,861,236,-1,232,234,908,-1,228,927,226,-1,157,924,993,-1,224,1117,169,-1,220,217,216,-1,219,103,193,-1,218,161,216,-1,213,215,1118,-1,213,1119,214,-1,209,923,208,-1,203,205,1120,-1,200,202,144,-1,197,217,195,-1,194,1121,192,-1,189,1122,190,-1,103,219,188,-1,185,855,186,-1,184,994,182,-1,1123,1124,1125,-1,176,924,177,-1,174,1126,1127,-1,165,927,932,-1,152,1127,173,-1,172,229,61,-1,171,225,169,-1,170,176,171,-1,168,175,164,-1,165,934,160,-1,163,935,164,-1,160,934,161,-1,153,913,151,-1,900,3,910,-1,180,1128,996,-1,938,144,146,-1,854,331,238,-1,268,138,140,-1,17,1129,136,-1,133,135,289,-1,887,130,132,-1,115,241,125,-1,255,116,124,-1,122,902,120,-1,117,119,884,-1,891,1006,266,-1,278,269,130,-1,853,988,106,-1,110,986,111,-1,108,995,109,-1,943,104,110,-1,327,100,987,-1,98,100,199,-1,850,1130,645,-1,856,947,80,-1,89,1111,90,-1,835,92,91,-1,94,315,84,-1,84,89,94,-1,78,346,76,-1,75,1131,67,-1,985,835,91,-1,985,66,68,-1,67,984,68,-1,985,68,835,-1,65,231,63,-1,229,64,61,-1,271,53,961,-1,51,53,866,-1,1132,960,959,-1,49,39,50,-1,46,270,47,-1,1008,45,282,-1,336,37,38,-1,35,37,36,-1,33,25,24,-1,30,26,31,-1,1026,300,971,-1,27,304,28,-1,25,974,26,-1,21,23,1133,-1,17,137,15,-1,14,292,12,-1,11,970,9,-1,6,8,899,-1,0,2,125,-1,3,242,910,-1,366,337,30,-1,366,1134,337,-1,877,27,29,-1,1015,27,877,-1,876,880,975,-1,876,878,880,-1,880,1013,882,-1,1013,880,879,-1,878,1014,305,-1,878,876,1014,-1,272,46,45,-1,274,46,272,-1,979,980,52,-1,979,54,980,-1,1132,1113,871,-1,1132,959,1113,-1,229,956,64,-1,956,229,230,-1,1135,1136,981,-1,1135,1137,1136,-1,982,341,97,-1,342,341,982,-1,955,335,334,-1,955,839,335,-1,984,836,68,-1,984,952,836,-1,1138,70,953,-1,70,1138,1139,-1,342,93,1110,-1,983,93,342,-1,983,91,93,-1,1140,329,1141,-1,329,1140,845,-1,105,995,320,-1,995,105,943,-1,851,106,319,-1,106,851,853,-1,43,264,138,-1,270,264,43,-1,128,888,129,-1,888,128,897,-1,890,256,127,-1,890,257,256,-1,212,1142,181,-1,212,1124,1142,-1,248,1114,246,-1,248,237,1114,-1,925,167,930,-1,168,167,925,-1,182,930,167,-1,930,182,994,-1,1143,1144,1145,-1,1143,1146,1144,-1,998,1147,62,-1,998,1148,1147,-1,169,204,997,-1,169,1117,204,-1,169,928,170,-1,997,928,169,-1,158,996,159,-1,996,158,210,-1,1125,929,928,-1,1125,211,929,-1,158,211,210,-1,158,929,211,-1,1125,148,1123,-1,1118,148,1125,-1,1118,215,148,-1,203,1119,213,-1,203,1149,1119,-1,1150,1151,1152,-1,1153,1151,1150,-1,1154,1155,1149,-1,1152,1155,1154,-1,1144,1153,1150,-1,1153,1144,1146,-1,1156,998,918,-1,998,1156,1157,-1,1156,917,1158,-1,1156,918,917,-1,1159,1160,1161,-1,1159,1162,1160,-1,196,107,326,-1,195,107,196,-1,1161,1163,1164,-1,1161,1160,1163,-1,192,184,183,-1,192,1121,184,-1,1137,1165,227,-1,1137,1135,1165,-1,862,908,312,-1,908,862,232,-1,886,907,1115,-1,886,239,907,-1,906,1002,1004,-1,1002,906,904,-1,902,1005,957,-1,902,905,1005,-1,243,1166,249,-1,243,244,1166,-1,1167,260,259,-1,260,1167,1168,-1,1116,893,251,-1,1116,253,893,-1,115,1169,121,-1,115,114,1169,-1,262,114,892,-1,114,262,1169,-1,266,1115,263,-1,1115,266,886,-1,885,47,42,-1,885,1009,47,-1,1170,874,96,-1,1170,308,874,-1,883,939,884,-1,883,1171,939,-1,19,309,276,-1,309,19,310,-1,296,1172,1173,-1,296,1174,1172,-1,294,971,10,-1,971,294,1026,-1,1173,1175,1176,-1,1172,1175,1173,-1,1008,41,273,-1,1008,864,41,-1,871,1005,869,-1,1005,871,1113,-1,868,59,1003,-1,57,59,868,-1,1177,49,48,-1,49,1177,867,-1,281,864,1008,-1,864,281,865,-1,863,312,1017,-1,312,863,862,-1,1178,859,860,-1,236,859,1178,-1,855,248,247,-1,185,248,855,-1,1018,189,854,-1,1122,189,1018,-1,987,847,327,-1,987,988,847,-1,1020,1179,1180,-1,1020,1181,1179,-1,1180,328,1020,-1,655,328,1180,-1,989,852,844,-1,989,853,852,-1,1182,1183,1184,-1,1185,1183,1182,-1,857,286,1114,-1,857,856,286,-1,840,954,333,-1,840,951,954,-1,1186,1176,1175,-1,1176,1186,1139,-1,75,874,873,-1,1010,874,75,-1,948,1021,1187,-1,948,349,1021,-1,830,841,79,-1,841,830,288,-1,664,72,74,-1,72,664,1023,-1,1188,1022,1189,-1,1188,829,1022,-1,1025,751,1190,-1,1025,599,751,-1,21,1109,825,-1,1109,21,967,-1,1191,367,370,-1,367,1191,723,-1,615,720,616,-1,720,615,719,-1,720,378,619,-1,378,720,381,-1,737,389,585,-1,389,737,1029,-1,1101,1031,1030,-1,1031,1101,449,-1,448,556,1192,-1,448,1101,556,-1,399,821,1033,-1,399,398,821,-1,622,712,1084,-1,622,1032,712,-1,1062,1105,1193,-1,1062,403,1105,-1,794,817,789,-1,817,794,495,-1,409,672,410,-1,409,1037,672,-1,662,665,1074,-1,665,662,823,-1,843,823,662,-1,823,843,1194,-1,408,1195,815,-1,1196,1195,408,-1,682,424,1197,-1,424,682,425,-1,682,685,425,-1,685,682,681,-1,560,1198,1039,-1,736,1198,560,-1,1198,736,589,-1,1199,1200,1201,-1,1199,1202,1200,-1,1102,1042,779,-1,1042,1102,447,-1,805,807,650,-1,807,805,444,-1,575,800,576,-1,739,800,575,-1,740,1044,574,-1,740,1043,1044,-1,732,1091,577,-1,604,1091,732,-1,567,747,1090,-1,567,570,747,-1,605,731,606,-1,605,799,731,-1,1045,1054,1203,-1,1045,473,1054,-1,754,351,750,-1,355,351,754,-1,501,1050,787,-1,501,491,1050,-1,797,516,517,-1,516,797,480,-1,1047,1099,1204,-1,1046,1099,1047,-1,1098,768,766,-1,768,1098,488,-1,529,795,794,-1,529,1049,795,-1,1205,1206,771,-1,1205,1207,1206,-1,818,499,1208,-1,499,818,497,-1,498,521,499,-1,521,498,1209,-1,518,774,519,-1,518,772,774,-1,479,764,790,-1,504,764,479,-1,598,776,752,-1,776,598,637,-1,1058,1096,1052,-1,1058,522,1096,-1,1058,520,522,-1,783,1210,1055,-1,783,1211,1210,-1,1212,1213,1214,-1,1213,1212,1179,-1,1215,1057,523,-1,1216,1057,1215,-1,472,1217,473,-1,472,1218,1217,-1,1219,1220,1221,-1,1219,1222,1220,-1,1223,1221,1151,-1,1223,1219,1221,-1,768,529,528,-1,1049,529,768,-1,771,1224,1060,-1,1206,1224,771,-1,782,1225,1226,-1,1225,782,527,-1,1227,647,1056,-1,1227,648,647,-1,535,506,767,-1,534,506,535,-1,763,495,494,-1,1035,495,763,-1,1228,1204,483,-1,1228,1047,1204,-1,1047,760,755,-1,1047,1228,760,-1,552,384,583,-1,552,758,384,-1,599,752,751,-1,598,752,599,-1,465,1190,464,-1,1190,465,1025,-1,565,748,566,-1,1229,748,565,-1,1230,565,564,-1,565,1230,1229,-1,1063,1231,462,-1,1063,749,1231,-1,743,1232,744,-1,451,1232,743,-1,1064,1093,1094,-1,1064,742,1093,-1,1089,573,470,-1,1089,741,573,-1,456,602,601,-1,456,691,602,-1,459,724,799,-1,459,610,724,-1,727,360,730,-1,363,360,727,-1,363,1233,364,-1,363,728,1233,-1,1234,1066,1235,-1,1234,728,1066,-1,1236,1237,1238,-1,1236,1239,1237,-1,1240,717,1067,-1,717,1240,1241,-1,761,1071,1192,-1,1071,761,709,-1,393,629,711,-1,393,630,629,-1,703,705,512,-1,705,703,706,-1,706,702,1242,-1,702,706,703,-1,445,443,511,-1,445,806,443,-1,783,1200,1211,-1,783,699,1200,-1,1242,642,1243,-1,702,642,1242,-1,412,678,663,-1,412,1073,678,-1,406,697,1074,-1,697,406,816,-1,1244,1245,1195,-1,1245,1244,1246,-1,685,1247,426,-1,685,1076,1247,-1,694,1189,1248,-1,1189,694,690,-1,694,1024,693,-1,694,1248,1024,-1,423,694,688,-1,694,423,690,-1,1076,433,1247,-1,1076,695,433,-1,671,1038,410,-1,1038,671,1039,-1,1245,1240,813,-1,1245,1246,1240,-1,1237,1077,669,-1,1103,1077,1237,-1,1075,412,697,-1,1075,413,412,-1,734,476,1065,-1,734,635,476,-1,1183,1242,1243,-1,1242,1183,1185,-1,1214,1079,658,-1,1079,1214,1201,-1,808,656,653,-1,656,808,645,-1,654,1080,652,-1,654,1212,1080,-1,649,1080,658,-1,649,651,1080,-1,643,648,1081,-1,1040,648,643,-1,1243,1055,1210,-1,642,1055,1243,-1,508,714,713,-1,508,510,714,-1,1082,483,634,-1,1082,1228,483,-1,531,760,532,-1,531,548,760,-1,1083,531,530,-1,1083,631,531,-1,1084,1092,623,-1,1084,819,1092,-1,1239,1234,1244,-1,1234,1239,1236,-1,368,294,729,-1,1026,294,368,-1,1236,728,1234,-1,1236,1233,728,-1,718,609,579,-1,717,609,718,-1,580,610,459,-1,610,580,579,-1,437,1198,589,-1,437,1039,1198,-1,560,718,561,-1,560,716,718,-1,1064,572,573,-1,583,572,1064,-1,569,741,1089,-1,744,741,569,-1,462,1249,463,-1,462,1231,1249,-1,1231,1230,1249,-1,1229,1230,1231,-1,1190,750,464,-1,1190,753,750,-1,1070,452,1068,-1,1070,450,452,-1,1093,554,623,-1,555,554,1093,-1,1094,583,1064,-1,1094,552,583,-1,761,549,709,-1,762,549,761,-1,1250,405,1251,-1,1250,1252,405,-1,1035,786,1251,-1,763,786,1035,-1,763,1061,786,-1,507,509,539,-1,507,537,509,-1,1253,1161,1164,-1,1253,1254,1161,-1,701,1056,647,-1,1056,701,535,-1,1254,1159,1161,-1,1254,1255,1159,-1,527,1060,1225,-1,527,769,1060,-1,529,789,818,-1,529,794,789,-1,1057,1208,499,-1,1057,526,1208,-1,1256,1205,524,-1,1205,1256,1207,-1,1222,201,1220,-1,1222,778,201,-1,1058,1218,1059,-1,1058,1217,1218,-1,473,1052,1054,-1,473,1058,1052,-1,473,1217,1058,-1,773,1048,774,-1,773,1095,1048,-1,518,515,1257,-1,517,515,518,-1,517,516,515,-1,489,500,494,-1,489,492,500,-1,1095,503,1048,-1,1095,764,503,-1,1098,492,489,-1,1098,493,492,-1,493,766,505,-1,766,493,1098,-1,1204,546,543,-1,1099,546,1204,-1,787,1061,501,-1,1061,787,786,-1,353,750,351,-1,750,353,1063,-1,1203,1053,1257,-1,1054,1053,1203,-1,465,1100,468,-1,465,463,1100,-1,456,1088,733,-1,458,1088,456,-1,746,571,745,-1,571,746,801,-1,444,1102,807,-1,806,1102,444,-1,701,511,533,-1,446,511,701,-1,440,659,1041,-1,440,657,659,-1,416,680,417,-1,681,680,416,-1,689,433,421,-1,1247,433,689,-1,680,1197,431,-1,1197,680,682,-1,430,427,809,-1,427,430,420,-1,815,1245,1104,-1,1195,1245,815,-1,679,414,1036,-1,679,1073,414,-1,373,408,407,-1,373,666,408,-1,436,410,1038,-1,410,436,411,-1,1105,1252,1106,-1,1105,405,1252,-1,403,1034,817,-1,1062,1034,403,-1,1069,1032,622,-1,1069,1030,1032,-1,398,395,821,-1,398,396,395,-1,382,585,584,-1,585,382,737,-1,619,616,720,-1,619,618,616,-1,613,614,369,-1,615,614,613,-1,620,377,1258,-1,620,375,377,-1,614,618,371,-1,614,616,618,-1,722,370,617,-1,370,722,1191,-1,1107,1258,1078,-1,1107,620,1258,-1,721,969,303,-1,721,1109,969,-1,1189,827,1248,-1,1022,827,1189,-1,1187,344,343,-1,1187,1021,344,-1,873,1131,75,-1,1259,1131,873,-1,1175,949,1186,-1,1175,1260,949,-1,1261,1183,1262,-1,1261,1184,1183,-1,1140,1213,1263,-1,1199,1213,1140,-1,199,328,1130,-1,199,198,328,-1,848,1263,1181,-1,846,1263,848,-1,1182,1072,1185,-1,322,1072,1182,-1,281,916,865,-1,281,285,916,-1,1016,1132,1112,-1,1016,960,1132,-1,1264,1176,1265,-1,1173,1176,1264,-1,963,306,305,-1,963,33,306,-1,966,23,31,-1,966,1133,23,-1,297,1173,1264,-1,297,296,1173,-1,1174,295,13,-1,1174,296,295,-1,298,135,17,-1,298,18,135,-1,18,289,135,-1,18,20,289,-1,841,142,141,-1,841,288,142,-1,1169,261,1266,-1,1169,262,261,-1,1171,258,939,-1,1171,259,258,-1,896,1171,883,-1,1167,1171,896,-1,1171,1167,259,-1,207,6,245,-1,6,207,1011,-1,275,239,886,-1,275,240,239,-1,236,154,156,-1,236,1178,154,-1,224,172,1117,-1,172,224,230,-1,858,182,935,-1,858,183,182,-1,220,195,217,-1,195,220,915,-1,915,194,108,-1,1121,194,915,-1,326,1267,196,-1,326,1019,1267,-1,1158,197,1268,-1,917,197,1158,-1,1269,1157,1156,-1,1157,1269,1145,-1,919,161,218,-1,161,919,162,-1,1221,1152,1151,-1,1221,1155,1152,-1,1220,1155,1221,-1,1220,1270,1155,-1,1119,200,214,-1,1270,200,1119,-1,1271,323,145,-1,324,323,1271,-1,206,1272,147,-1,1272,206,208,-1,173,1165,926,-1,1165,173,1273,-1,917,217,197,-1,917,218,217,-1,191,188,189,-1,188,191,101,-1,1126,173,1127,-1,173,1126,1273,-1,1124,211,1125,-1,1124,212,211,-1,1000,909,222,-1,909,1000,1128,-1,152,174,1127,-1,152,175,174,-1,205,62,1147,-1,60,62,205,-1,1145,1274,1157,-1,1145,1144,1274,-1,160,919,166,-1,160,162,919,-1,1114,321,857,-1,1114,237,321,-1,202,145,144,-1,1271,145,202,-1,17,134,1129,-1,17,135,134,-1,256,124,895,-1,256,255,124,-1,897,118,888,-1,118,897,119,-1,127,267,139,-1,127,129,267,-1,130,140,131,-1,140,130,268,-1,987,106,988,-1,104,106,987,-1,113,986,100,-1,111,986,113,-1,1141,1199,1140,-1,1141,1202,1199,-1,1170,944,279,-1,1170,96,944,-1,344,833,345,-1,348,833,344,-1,93,833,1110,-1,345,833,93,-1,77,83,82,-1,77,1111,83,-1,1131,953,67,-1,953,1131,1138,-1,953,984,67,-1,953,951,984,-1,1137,956,1136,-1,1137,65,956,-1,1136,230,224,-1,1136,956,230,-1,957,959,958,-1,957,1113,959,-1,55,58,57,-1,979,58,55,-1,49,40,39,-1,40,49,872,-1,52,1016,979,-1,1016,52,51,-1,978,274,272,-1,1007,274,978,-1,964,305,1014,-1,963,305,964,-1,305,879,878,-1,307,879,305,-1,1134,37,337,-1,1134,1275,37,-1,901,4,3,-1,901,244,4,-1,3,2,242,-1,3,5,2,-1,245,899,1166,-1,245,6,899,-1,968,21,1133,-1,967,21,968,-1,973,1015,877,-1,302,1015,973,-1,975,877,876,-1,877,975,973,-1,307,1013,879,-1,837,1013,307,-1,38,26,336,-1,38,24,26,-1,903,942,1001,-1,903,958,942,-1,52,961,53,-1,52,980,961,-1,1112,871,870,-1,1112,1132,871,-1,914,981,171,-1,926,981,914,-1,64,166,61,-1,63,166,64,-1,66,983,982,-1,66,985,983,-1,34,842,332,-1,36,842,34,-1,36,843,842,-1,1194,843,36,-1,1139,955,70,-1,955,1139,1186,-1,94,947,856,-1,88,947,94,-1,1187,92,831,-1,92,1187,343,-1,98,1130,850,-1,98,199,1130,-1,329,844,330,-1,329,845,844,-1,105,319,106,-1,105,320,319,-1,127,895,128,-1,895,127,256,-1,138,891,139,-1,891,138,1006,-1,1276,1277,287,-1,1278,1277,1276,-1,1123,147,1272,-1,1123,148,147,-1,150,4,243,-1,4,150,5,-1,168,912,174,-1,168,925,912,-1,179,1128,180,-1,909,1128,179,-1,936,154,1279,-1,154,936,155,-1,931,994,221,-1,931,930,994,-1,926,1135,981,-1,1165,1135,926,-1,1157,1148,998,-1,1157,1274,1148,-1,204,172,205,-1,1117,172,204,-1,210,181,996,-1,210,212,181,-1,993,176,170,-1,176,993,924,-1,206,1011,207,-1,247,1011,206,-1,928,1118,1125,-1,997,1118,928,-1,997,213,1118,-1,1261,190,1122,-1,1261,1280,190,-1,1213,1181,1263,-1,1179,1181,1213,-1,1120,1149,203,-1,1149,1120,1154,-1,215,938,148,-1,215,214,938,-1,1149,1270,1119,-1,1149,1155,1270,-1,922,1152,1154,-1,1152,922,1150,-1,920,1154,1120,-1,920,922,1154,-1,922,1148,1274,-1,921,1148,922,-1,1269,1158,1162,-1,1269,1156,1158,-1,1281,1162,1159,-1,1281,1269,1162,-1,644,1163,849,-1,1164,1163,644,-1,1160,1267,1163,-1,1160,1268,1267,-1,220,1121,915,-1,184,1121,220,-1,63,226,927,-1,226,63,231,-1,1279,1178,991,-1,1279,154,1178,-1,155,910,242,-1,155,936,910,-1,277,279,269,-1,277,1170,279,-1,1166,898,249,-1,899,898,1166,-1,254,894,252,-1,894,254,1168,-1,894,1167,896,-1,1168,1167,894,-1,260,251,250,-1,260,1116,251,-1,1266,121,1169,-1,121,1266,122,-1,1002,1115,907,-1,1002,261,1115,-1,287,1188,1276,-1,829,1188,287,-1,1129,990,1277,-1,1129,134,990,-1,298,297,299,-1,291,297,298,-1,299,310,19,-1,310,299,1282,-1,1283,1174,1012,-1,1172,1174,1283,-1,1260,1172,1283,-1,1260,1175,1172,-1,310,1259,873,-1,1282,1259,310,-1,313,908,1001,-1,312,908,313,-1,51,960,1016,-1,51,940,960,-1,867,940,51,-1,867,1177,940,-1,864,50,41,-1,864,1017,50,-1,323,187,186,-1,322,187,323,-1,325,322,1182,-1,187,322,325,-1,943,112,995,-1,943,110,112,-1,1141,190,1280,-1,1141,329,190,-1,1018,1182,1184,-1,1182,1018,325,-1,73,840,74,-1,73,952,840,-1,333,71,332,-1,69,71,333,-1,1138,1176,1139,-1,1265,1176,1138,-1,982,75,66,-1,75,982,1010,-1,95,78,338,-1,78,95,945,-1,350,948,947,-1,350,349,948,-1,751,753,1190,-1,753,751,559,-1,668,366,365,-1,668,1134,366,-1,723,368,367,-1,368,723,300,-1,1108,365,826,-1,1108,1078,365,-1,376,670,377,-1,376,719,670,-1,825,721,380,-1,1109,721,825,-1,620,379,381,-1,1107,379,620,-1,1071,448,1192,-1,392,448,1071,-1,1085,388,1033,-1,1085,710,388,-1,712,819,1084,-1,819,712,624,-1,1033,626,1085,-1,626,1033,627,-1,792,1105,1106,-1,792,1193,1105,-1,1075,815,1104,-1,1075,816,815,-1,1194,696,823,-1,696,1194,1275,-1,666,1196,408,-1,1103,1196,666,-1,424,411,1197,-1,424,409,411,-1,424,810,409,-1,699,1201,1200,-1,1079,1201,699,-1,511,442,708,-1,443,442,511,-1,447,806,445,-1,447,1102,806,-1,805,439,441,-1,700,439,805,-1,577,563,1043,-1,1091,563,577,-1,747,471,1044,-1,747,469,471,-1,1257,772,518,-1,1257,1053,772,-1,1065,759,597,-1,1065,698,759,-1,487,491,1097,-1,491,487,1050,-1,1097,538,487,-1,784,538,1097,-1,1207,1143,1206,-1,1207,1146,1143,-1,1208,770,818,-1,1208,1284,770,-1,521,791,522,-1,521,1209,791,-1,1096,791,790,-1,791,1096,522,-1,519,1048,541,-1,774,1048,519,-1,1095,1052,1096,-1,1095,773,1052,-1,1262,1211,1285,-1,1211,1262,1210,-1,526,1284,1208,-1,525,1284,526,-1,775,1257,515,-1,775,1203,1257,-1,1218,777,778,-1,472,777,1218,-1,1059,523,520,-1,1059,1215,523,-1,1151,1256,1223,-1,1256,1151,1153,-1,1219,1216,1215,-1,1216,1219,1223,-1,1153,1207,1256,-1,1146,1207,1153,-1,1224,1143,1281,-1,1224,1206,1143,-1,1226,1255,1254,-1,1255,1226,1225,-1,708,533,511,-1,533,708,536,-1,1227,1081,648,-1,1253,1081,1227,-1,1226,1056,782,-1,1056,1226,1227,-1,797,541,540,-1,797,519,541,-1,1209,792,791,-1,792,1209,1193,-1,404,1251,405,-1,1251,404,1035,-1,543,483,1204,-1,543,545,483,-1,1092,1094,1093,-1,1092,550,1094,-1,762,558,547,-1,558,762,557,-1,670,612,669,-1,670,613,612,-1,749,1229,1231,-1,749,748,1229,-1,564,604,603,-1,564,1091,604,-1,1090,568,567,-1,568,1090,566,-1,353,749,1063,-1,353,568,749,-1,1232,450,555,-1,451,450,1232,-1,742,555,1093,-1,742,1232,555,-1,570,470,469,-1,470,570,1089,-1,461,577,576,-1,461,732,577,-1,758,1029,384,-1,758,1028,1029,-1,579,561,718,-1,578,561,579,-1,735,590,387,-1,735,593,590,-1,1086,560,1039,-1,1086,716,560,-1,1100,603,466,-1,1100,1286,603,-1,606,1278,1088,-1,606,136,1278,-1,1233,357,364,-1,1233,1087,357,-1,725,1235,1066,-1,1235,725,1241,-1,1087,612,611,-1,612,1087,1238,-1,722,875,1191,-1,722,303,875,-1,1107,380,379,-1,1107,1108,380,-1,1238,669,612,-1,1238,1237,669,-1,1246,1241,1240,-1,1241,1246,1235,-1,1070,622,553,-1,1069,622,1070,-1,819,550,1092,-1,550,819,621,-1,822,804,391,-1,626,804,822,-1,629,594,1027,-1,1083,594,629,-1,709,631,630,-1,549,631,709,-1,532,1228,1082,-1,1228,532,760,-1,715,642,641,-1,642,715,1055,-1,651,807,652,-1,651,650,807,-1,1179,654,1180,-1,1179,1212,654,-1,653,1180,654,-1,1180,653,655,-1,1202,1211,1200,-1,1285,1211,1202,-1,1077,1258,377,-1,1077,372,1258,-1,1244,1196,1239,-1,1195,1196,1244,-1,1086,814,1067,-1,814,1086,671,-1,431,411,436,-1,1197,411,431,-1,687,683,434,-1,687,684,683,-1,602,423,422,-1,691,423,602,-1,693,664,663,-1,1023,664,693,-1,690,1188,1189,-1,690,692,1188,-1,433,687,434,-1,433,695,687,-1,418,437,673,-1,432,437,418,-1,813,1067,814,-1,1067,813,1240,-1,1103,1239,1196,-1,1103,1237,1239,-1,1183,1210,1262,-1,1183,1243,1210,-1,1213,1201,1214,-1,1201,1213,1199,-1,653,780,808,-1,653,781,780,-1,1214,1080,1212,-1,1080,1214,658,-1,1072,1242,1185,-1,1242,1072,706,-1,530,594,1083,-1,530,595,594,-1,1031,628,625,-1,449,628,1031,-1,449,626,628,-1,449,804,626,-1,1032,625,712,-1,1032,1031,625,-1,1244,1235,1246,-1,1235,1244,1234,-1,376,381,720,-1,376,375,381,-1,826,380,1108,-1,826,825,380,-1,875,723,1191,-1,875,301,723,-1,1233,1238,1087,-1,1238,1233,1236,-1,717,725,609,-1,1241,725,717,-1,1066,726,725,-1,726,1066,727,-1,799,726,731,-1,799,724,726,-1,1188,733,1276,-1,733,1188,692,-1,742,744,1232,-1,742,741,744,-1,463,1286,1100,-1,463,1249,1286,-1,1286,564,603,-1,1286,1230,564,-1,1249,1230,1286,-1,481,1046,756,-1,481,1099,1046,-1,757,1192,556,-1,1192,757,761,-1,498,1193,1209,-1,1062,1193,498,-1,537,506,534,-1,506,537,507,-1,1227,1254,1253,-1,1227,1226,1254,-1,1253,644,1081,-1,644,1253,1164,-1,1255,1281,1159,-1,1255,1224,1281,-1,1225,1224,1255,-1,1225,1060,1224,-1,1284,524,1205,-1,524,1284,525,-1,1216,526,1057,-1,526,1216,524,-1,1223,524,1216,-1,1256,524,1223,-1,1222,1215,1059,-1,1222,1219,1215,-1,778,1059,1218,-1,1059,778,1222,-1,705,1271,513,-1,1271,705,324,-1,1203,776,1045,-1,775,776,1203,-1,1250,1051,400,-1,1251,1051,1250,-1,767,527,782,-1,767,528,527,-1,714,660,715,-1,661,660,714,-1,1051,786,785,-1,1251,786,1051,-1,773,1053,1052,-1,773,772,1053,-1,480,540,765,-1,797,540,480,-1,486,788,793,-1,544,788,486,-1,787,788,785,-1,787,793,788,-1,1284,771,770,-1,1284,1205,771,-1,1252,400,1106,-1,400,1252,1250,-1,784,493,505,-1,784,1097,493,-1,475,1065,476,-1,475,698,1065,-1,513,202,777,-1,202,513,1271,-1,1088,1276,733,-1,1276,1088,1278,-1,803,581,574,-1,802,581,803,-1,1090,1044,563,-1,747,1044,1090,-1,441,442,805,-1,441,708,442,-1,657,699,659,-1,657,1079,699,-1,808,1040,643,-1,808,780,1040,-1,677,1247,689,-1,426,1247,677,-1,434,636,635,-1,636,434,683,-1,1104,813,812,-1,1245,813,1104,-1,414,1104,812,-1,414,413,1104,-1,1030,1068,1101,-1,1030,1069,1068,-1,624,394,621,-1,394,624,395,-1,710,822,820,-1,1085,822,710,-1,625,821,395,-1,628,821,625,-1,1078,372,667,-1,1078,1258,372,-1,613,719,615,-1,719,613,670,-1,696,1134,668,-1,696,1275,1134,-1,368,611,369,-1,368,729,611,-1,754,559,796,-1,754,753,559,-1,355,756,356,-1,355,796,756,-1,1024,827,72,-1,1024,1248,827,-1,827,830,828,-1,1022,830,827,-1,831,73,828,-1,92,73,831,-1,88,350,947,-1,88,832,350,-1,97,1010,982,-1,96,1010,97,-1,1259,1138,1131,-1,1259,1265,1138,-1,950,1260,838,-1,1260,950,949,-1,1280,1202,1141,-1,1202,1280,1285,-1,845,1263,846,-1,1140,1263,845,-1,656,1130,328,-1,645,1130,656,-1,848,1020,327,-1,848,1181,1020,-1,848,989,846,-1,848,847,989,-1,1019,850,849,-1,850,1019,98,-1,1122,1184,1261,-1,1184,1122,1018,-1,146,855,149,-1,146,186,855,-1,188,317,311,-1,188,219,317,-1,991,860,318,-1,991,1178,860,-1,236,999,859,-1,236,861,999,-1,999,865,916,-1,999,863,865,-1,1003,870,1004,-1,1003,59,870,-1,1282,1265,1259,-1,1264,1265,1282,-1,838,1283,881,-1,838,1260,1283,-1,966,974,965,-1,966,31,974,-1,875,27,1015,-1,875,303,27,-1,881,1012,11,-1,1283,1012,881,-1,1264,299,297,-1,1282,299,1264,-1,970,1174,13,-1,970,1012,1174,-1,1278,1129,1277,-1,1278,136,1129,-1,309,1170,277,-1,309,308,1170,-1,1007,240,275,-1,1007,976,240,-1,888,132,131,-1,888,118,132,-1,889,255,257,-1,892,255,889,-1,904,261,1002,-1,904,1266,261,-1,905,1266,904,-1,1266,905,122,-1,253,895,124,-1,252,895,253,-1,119,896,883,-1,119,897,896,-1,1168,1116,260,-1,1168,254,1116,-1,881,837,838,-1,881,1013,837,-1,0,232,235,-1,233,232,0,-1,907,1003,1002,-1,907,868,1003,-1,991,223,1279,-1,991,163,223,-1,226,1137,227,-1,65,1137,226,-1,1273,227,1165,-1,1273,1126,227,-1,159,1128,1000,-1,159,996,1128,-1,196,1268,197,-1,1267,1268,196,-1,849,1267,1019,-1,1267,849,1163,-1,108,320,995,-1,194,320,108,-1,1162,1268,1160,-1,1158,1268,1162,-1,1143,1269,1281,-1,1143,1145,1269,-1,61,919,62,-1,61,166,919,-1,1147,1120,205,-1,1147,920,1120,-1,1274,1150,922,-1,1144,1150,1274,-1,201,1270,1220,-1,201,200,1270,-1,144,214,200,-1,214,144,938,-1,1142,208,923,-1,1142,1272,208,-1,1148,920,1147,-1,920,1148,921,-1,1280,1262,1285,-1,1261,1262,1280,-1,923,181,1142,-1,181,923,179,-1,177,222,178,-1,222,177,1000,-1,228,932,927,-1,228,992,932,-1,157,929,158,-1,157,993,929,-1,992,933,932,-1,992,931,933,-1,216,931,221,-1,933,931,216,-1,911,1279,223,-1,1279,911,936,-1,227,174,912,-1,1126,174,227,-1,243,893,150,-1,251,893,243,-1,1124,1272,1142,-1,1272,1124,1123,-1,939,898,8,-1,939,258,898,-1,1277,142,287,-1,142,1277,990,-1,116,972,123,-1,126,972,116,-1,1177,941,940,-1,1177,48,941,-1,986,104,987,-1,104,986,110,-1,330,852,102,-1,330,844,852,-1,834,347,946,-1,347,834,348,-1,948,831,81,-1,831,948,1187,-1,1110,834,340,-1,833,834,1110,-1,1111,76,90,-1,77,76,1111,-1,1186,839,955,-1,839,1186,949,-1,37,1194,36,-1,1275,1194,37,-1,70,954,953,-1,70,69,954,-1,1136,225,981,-1,1136,224,225,-1,867,53,872,-1,866,53,867,-1,59,1112,870,-1,58,1112,59,-1,271,872,53,-1,271,40,872,-1,942,313,1001,-1,313,942,941,-1,1007,962,976,-1,1007,978,962,-1,965,25,963,-1,25,965,974,-1,304,1133,966,-1,1133,304,968,-1,837,306,32,-1,837,307,306,-1,971,302,973,-1,300,302,971,-1,969,304,303,-1,969,968,304,-1,244,245,1166,-1,901,245,244,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t_Coord',point=[(-.83703,52.30684,-1.72712),(-.75025,52.30158,-1.69569),(-.74496,52.41626,-1.66625),(-.63276,52.36814,-1.66292),(-.60234,52.45022,-1.64524),(-.68751,52.4252,-1.64576),(-.39006,52.36903,-1.80201),(-.30916,52.2803,-1.91487),(-.29828,52.33256,-1.92942),(-.01003,52.06262,-2.89639),(-.01574,52.07018,-3.0535),(-.05646,52.05361,-3.05088),(-.00782,52.08194,-2.76134),(-.01742,52.05507,-2.74567),(-.03631,52.11537,-2.59996),(-.01553,52.17577,-2.47011),(-.0428,52.16388,-2.47784),(-.08798,52.18065,-2.30839),(-.22156,52.13325,-2.26621),(-.28947,52.03632,-2.32675),(-.28861,52.13412,-2.20643),(0,51.81233,-3.31581),(0,51.76386,-3.27936),(-.04772,51.76448,-3.2844),(-.10287,51.72685,-3.22332),(-.13347,51.75871,-3.27805),(-.09278,51.72023,-3.22869),(-.12303,51.92311,-3.31083),(-.09338,51.80559,-3.35149),(-.13675,51.9187,-3.30791),(-.05909,51.72619,-3.22223),(-.09194,51.75174,-3.29904),(-.0985,51.77858,-3.20527),(-.13131,51.78908,-3.2578),(-.0926,51.657,-2.8523),(-.06175,51.67555,-2.97709),(-.06945,51.66153,-2.85383),(-.04932,51.67099,-2.98054),(-.0902,51.68334,-3.13171),(-1.21066,52.2355,-1.93622),(-1.27105,52.25514,-2.00259),(-1.18916,52.21777,-1.94871),(-.78813,52.23318,-2.12654),(-.78135,52.24557,-2.12076),(-.66448,52.17511,-2.09088),(-1.07911,52.20148,-2.18519),(-1.0815,52.21256,-2.1927),(-.9083,52.26406,-2.1559),(-1.16243,52.24893,-1.84907),(-1.21984,52.24411,-1.92854),(-1.1475,52.24387,-1.85295),(-1.26483,52.37586,-1.91986),(-1.31692,52.39226,-2.03096),(-1.31156,52.31449,-2.03527),(-1.30599,52.45723,-2.0153),(-1.30428,52.46781,-2.00766),(-1.2751,52.51461,-2.07447),(-1.29355,52.50406,-1.95499),(-1.29894,52.49247,-1.94559),(-1.29176,52.50655,-1.94979),(-.37161,52.14122,-1.34031),(-.39519,52.08908,-1.34435),(-.31493,52.10242,-1.25899),(-.42809,52.05789,-1.35224),(-.40768,52.09295,-1.35186),(-.42816,52.09125,-1.42336),(-.36817,51.64092,-2.37132),(-.28044,51.64297,-2.48841),(-.35736,51.63176,-2.37195),(-.14655,51.65278,-2.71041),(-.14658,51.66619,-2.7217),(-.13878,51.6555,-2.72452),(-.09293,51.67848,-2.43737),(-.1902,51.63988,-2.3897),(-.09451,51.63364,-2.57141),(-.374,51.71958,-2.36917),(-.63658,51.80639,-2.0117),(-.64402,51.80906,-2.01404),(-.63713,51.76275,-2.077),(-.33139,51.96791,-2.11255),(-.44902,51.98993,-2.01303),(-.33688,51.89441,-2.14299),(-.70065,51.83315,-2.05244),(-.63333,51.88849,-2.00465),(-.6865,51.9302,-1.97502),(-.56304,51.81165,-2.08293),(-.46893,51.80787,-2.13271),(-.53493,51.84322,-2.07291),(-.54754,51.95077,-1.98824),(-.55642,51.94747,-1.98892),(-.59808,51.88287,-1.98997),(-.38785,51.62329,-2.30074),(-.30324,51.62752,-2.29804),(-.39719,51.62105,-2.28129),(-.55012,51.95831,-1.98661),(-.61909,51.72674,-2.19235),(-.53634,51.78475,-2.26855),(-.54634,51.69791,-2.24135),(-.25968,51.49566,-1.34499),(-.3761,51.51049,-1.37639),(-.37468,51.54278,-1.48414),(-.43839,51.7456,-1.83781),(-.45356,51.70116,-1.84357),(-.53321,51.69997,-1.76146),(-.47315,51.60355,-1.60986),(-.53273,51.63594,-1.60535),(-.45619,51.64039,-1.72051),(-.49996,51.57349,-1.42513),(-.55918,51.62765,-1.47),(-.50084,51.56039,-1.4394),(-.46171,51.57131,-1.51465),(-.46442,51.55924,-1.46943),(-.47891,51.56061,-1.47632),(-.41782,51.53922,-1.44169),(-.89285,52.47522,-1.74803),(-.90636,52.46265,-1.68295),(-.83867,52.4583,-1.72871),(-.29123,52.23176,-2.03936),(-.4372,52.19342,-2.03799),(-.43364,52.19857,-2.02544),(-1.01348,52.48772,-1.71546),(-1.00886,52.49706,-1.71912),(-1.11758,52.5407,-1.77955),(-.82313,52.45847,-1.72016),(-.76775,52.41283,-1.773),(-.85923,52.44204,-1.66962),(-.86511,52.45262,-1.67439),(-.62322,52.30136,-1.9281),(-.60064,52.29513,-1.92788),(-.60685,52.28986,-1.94186),(-.5537,52.23987,-2.07961),(-.54705,52.24482,-2.07074),(-.43406,52.20075,-2.09807),(-.29573,52.21957,-2.10505),(-.13816,52.1937,-2.22851),(-.14379,52.1929,-2.2385),(0,52.18398,-2.31483),(0,52.1885,-2.32766),(-.73126,52.33402,-2.04113),(-.7225,52.33789,-2.02411),(-.61731,52.27056,-2.04485),(-.27668,52.2145,-1.99658),(-.15056,52.15166,-2.1437),(-.29082,52.2359,-2.02378),(-.08461,52.25262,-1.61871),(-.08013,52.25379,-1.63127),(-.18954,52.30809,-1.66982),(-.31411,52.32756,-1.65117),(-.30423,52.32528,-1.64151),(-.30206,52.31699,-1.65803),(-.73688,52.48455,-1.62838),(-.50964,52.03267,-1.63382),(-.5163,52.0223,-1.5759),(-.5016,52.09039,-1.56654),(-.63993,52.17524,-1.73253),(-.64326,52.21058,-1.72102),(-.72394,52.21114,-1.74202),(-.49965,52.27259,-1.43317),(-.50728,52.28921,-1.42349),(-.52076,52.2809,-1.43415),(-.40813,52.0218,-1.33462),(-.38885,51.9484,-1.3449),(-.39261,52.00662,-1.31828),(-.51994,52.02873,-1.65308),(-.51507,51.98962,-1.62602),(-.44622,51.98072,-1.37429),(-.41773,52.05223,-1.34481),(-.49929,51.92584,-1.57537),(-.51142,51.9565,-1.55057),(-.41592,52.23751,-1.46944),(-.42524,52.24384,-1.47185),(-.44372,52.19547,-1.5112),(-.37614,52.1471,-1.35152),(-.50422,52.08944,-1.55155),(-.52124,51.96714,-1.54978),(-.51679,51.96639,-1.56306),(-.45144,52.21168,-1.50419),(-.49503,52.23721,-1.48521),(-.46664,52.1935,-1.53223),(-.52995,52.28756,-1.60586),(-.52519,52.30478,-1.52797),(-.49857,52.33036,-1.51156),(-.48887,51.90365,-1.59252),(-.50214,51.8798,-1.60116),(-.49011,51.84727,-1.5111),(-.24898,52.18207,-1.80339),(-.1685,52.24951,-1.7344),(-.17622,52.16371,-1.77736),(-.42099,51.80959,-1.83239),(-.29704,51.82738,-1.90172),(-.2232,51.72861,-1.91684),(-.32048,51.74556,-1.90459),(-.55169,51.77895,-1.61125),(-.59814,51.68557,-1.59578),(-.59946,51.68274,-1.5496),(-.45587,51.67721,-1.37652),(-.35617,51.62784,-1.31643),(-.33134,51.76514,-1.27293),(-.26268,51.55212,-1.45842),(-.26083,51.51346,-1.3637),(-.07944,52.22656,-1.58832),(0,52.22124,-1.57255),(0,52.23582,-1.60489),(-.31195,52.1808,-1.42206),(-.39064,52.20297,-1.42437),(-.36528,52.15195,-1.34842),(-.41762,52.29896,-1.69445),(-.46442,52.32324,-1.72249),(-.45001,52.31628,-1.66119),(-.53166,52.31333,-1.67074),(-.51557,52.32918,-1.44854),(-.4671,52.31088,-1.49695),(-.48192,52.33057,-1.50254),(-.32033,52.22274,-1.49825),(-.20149,52.25147,-1.59964),(-.29753,52.27038,-1.57577),(-.4021,51.89376,-1.38459),(-.38499,51.81508,-1.34354),(-.36477,51.92452,-1.31336),(-.5135,51.79829,-1.76523),(-.45949,51.81615,-1.42644),(-.43868,51.86601,-1.43592),(-.52555,52.19569,-1.58836),(-.5083,52.10173,-1.61671),(-.40344,52.18519,-1.44262),(-.4363,52.19725,-1.50352),(-.44608,52.03442,-1.43128),(-.46143,52.01724,-1.45898),(-.48329,51.93005,-1.43816),(-.39096,52.10865,-1.35523),(-.38441,52.13906,-1.38164),(-.43628,52.06496,-1.41751),(-.94025,52.27271,-1.73526),(-.93554,52.32704,-1.72359),(-1.01415,52.36975,-1.70278),(-.82907,52.23624,-1.73503),(-.73194,52.1613,-1.7761),(-.30319,52.11346,-1.8847),(-.25106,52.08336,-1.8517),(-1.25153,52.49623,-2.11036),(-1.28764,52.4388,-2.15042),(-.90909,52.45461,-1.67775),(-.63653,52.28995,-1.69187),(-.56653,52.51593,-1.63246),(-.56549,52.4597,-1.65473),(-.47995,52.41305,-1.71922),(-.32289,52.21439,-1.85241),(-.34846,52.26077,-1.76752),(-.29925,52.19171,-1.82443),(-.45631,52.50932,-1.69905),(-.45789,52.51276,-1.7036),(-.56817,52.51873,-1.63938),(-.64756,52.40062,-1.78465),(-.7024,52.44138,-1.72274),(-.57839,52.42951,-1.78118),(-.78222,52.41505,-1.78154),(-.7144,52.36999,-1.83803),(-.76595,52.39536,-1.85019),(-.35194,52.45336,-1.81057),(-.40881,52.4104,-1.84439),(-.48078,52.4645,-1.77165),(-1.08247,52.57283,-1.92916),(-.96519,52.52946,-1.86803),(-.96217,52.50189,-1.98278),(-.8649,52.33404,-2.13587),(-1.01365,52.36536,-2.21583),(-.99657,52.44031,-2.10879),(-.61231,52.2827,-1.99342),(-.6229,52.26256,-2.05561),(-.58779,52.12929,-2.10825),(-.89823,52.28854,-2.16093),(-1.30272,52.30615,-2.04718),(-1.19212,52.2558,-2.1654),(-1.23145,52.23512,-2.10455),(-1.1866,52.26501,-2.17365),(-1.16088,52.37858,-2.18931),(-.4235,52.11367,-2.17572),(-.50947,52.05522,-2.16673),(-.5157,52.1382,-2.12856),(-.62853,51.95291,-2.15607),(-.71632,52.05027,-2.10225),(-.98107,52.13201,-2.0328),(-1.05282,52.17101,-2.10919),(-1.0076,52.20278,-2.14122),(-.74446,51.941,-2.03247),(-.85572,52.0578,-2.00604),(-.34399,52.11342,-1.95784),(-.08792,52.10995,-2.22452),(-.17788,52.06238,-2.16798),(-.29929,52.21464,-2.11872),(0,52.18086,-2.46657),(-.10527,52.08279,-2.48499),(-.01333,52.13248,-2.60712),(0,52.09415,-2.76846),(0,52.0755,-3.05433),(-.05827,52.05654,-2.61037),(-.10037,51.99039,-2.63954),(-.14461,51.99204,-2.52211),(-.15831,52.09484,-2.38766),(-.19603,51.99817,-2.43761),(0,52.06557,-3.16293),(0,52.00619,-3.23326),(-.06772,52.04697,-3.21027),(0,51.91775,-3.3043),(-.07788,51.80658,-3.35235),(-.19215,51.87198,-3.27407),(-.14752,51.82392,-3.23317),(-.15217,51.86337,-3.21648),(-.43631,51.86584,-2.31697),(-.42666,51.99965,-2.24524),(-.31854,51.94217,-2.35969),(-.39876,51.92379,-1.84911),(-1.06959,52.26321,-1.7509),(-1.12173,52.28701,-1.76438),(-.74917,51.97631,-1.98496),(-.64585,52.06723,-1.86447),(-.52851,51.96999,-1.85943),(-.49882,51.89679,-1.77107),(-.5788,52.02755,-1.75656),(-.53441,51.67767,-1.76295),(-.59576,51.65859,-1.57297),(-.41246,51.99086,-1.90565),(-.0759,52.14707,-1.73504),(-.06861,52.2265,-1.69595),(0,52.20916,-1.67681),(-.18692,52.05388,-1.81558),(-.37389,51.51702,-1.3592),(-.2691,51.6251,-1.57321),(-.12769,51.57054,-1.45164),(-.23014,51.6671,-1.92866),(-.33803,51.69955,-1.90057),(-.32635,51.96188,-1.87758),(-.11374,51.64424,-2.72966),(-.14933,51.62378,-2.64882),(-.10135,51.67577,-2.83961),(-.07934,51.69333,-2.97214),(-.08168,51.67712,-3.13462),(-.05802,51.68769,-3.13181),(-.67565,51.78693,-2.12296),(-.67567,51.8464,-2.14829),(-.5403,51.67738,-2.20564),(-.54574,51.68812,-2.23238),(-.47922,51.65404,-2.276),(-.30556,51.6272,-2.28988),(-.40328,51.71075,-2.2128),(-.39558,51.62343,-2.27559),(-.63128,51.76031,-2.07301),(-.54238,51.76615,-2.12568),(-.47903,51.71846,-2.18734),(-.37791,51.86065,-2.13686),(-.45414,51.88221,-2.08254),(.73688,52.48455,-1.62632),(.85923,52.44204,-1.66728),(.73597,52.48756,-1.63291),(.74496,52.41626,-1.66402),(.68751,52.4252,-1.64367),(.75025,52.30158,-1.69318),(.02347,52.04756,-2.89394),(.01003,52.06262,-2.89636),(.00782,52.08194,-2.76131),(.03631,52.11537,-2.59984),(.01333,52.13248,-2.60708),(.01553,52.17577,-2.47006),(.05827,52.05654,-2.61018),(.01742,52.05507,-2.74562),(.05909,51.72619,-3.2221),(0,51.71662,-3.22245),(.07989,52.04999,-3.20297),(.00821,52.06959,-3.15249),(.10481,52.04551,-3.11405),(.13208,52.00169,-3.25678),(.14161,52.04121,-3.1716),(.0902,51.68334,-3.13147),(.07934,51.69333,-2.97188),(.06175,51.67555,-2.9769),(.13131,51.78908,-3.25753),(.14752,51.82392,-3.23287),(.0985,51.77858,-3.20505),(.16099,51.81062,-3.33448),(.15352,51.80108,-3.33085),(.08511,51.79305,-3.34925),(.16407,51.80582,-3.32566),(1.0815,52.21256,-2.19003),(1.01365,52.36536,-2.21366),(1.16088,52.37858,-2.18715),(.78135,52.24557,-2.1184),(.89823,52.28854,-2.15855),(.78813,52.23318,-2.12414),(1.30272,52.30615,-2.04468),(1.22969,52.2934,-2.15172),(1.30489,52.35785,-2.1244),(1.16243,52.24893,-1.84606),(1.13643,52.29218,-1.76386),(1.1475,52.24387,-1.84994),(1.30428,52.46781,-2.00567),(1.3102,52.45597,-1.99655),(1.30599,52.45723,-2.01328),(1.29712,52.42848,-2.09126),(1.31188,52.39542,-2.04459),(1.30649,52.32689,-2.04708),(.46943,52.16,-1.52614),(.47024,52.16126,-1.54235),(.44372,52.19547,-1.50934),(.3984,52.1316,-1.38595),(.42816,52.09125,-1.4214),(.43128,52.11285,-1.45384),(.13878,51.6555,-2.72397),(.10135,51.67577,-2.83925),(.10679,51.68855,-2.83785),(.46151,51.65008,-2.28478),(.4744,51.66202,-2.28542),(.47922,51.65404,-2.27351),(.18509,51.61696,-2.55303),(.21094,51.6402,-2.59131),(.27482,51.63319,-2.48454),(.63128,51.76031,-2.06999),(.54238,51.76615,-2.12306),(.60092,51.71587,-2.14557),(.63713,51.76275,-2.07396),(.70065,51.83315,-2.0493),(.64402,51.80906,-2.01101),(.33688,51.89441,-2.14142),(.33139,51.96791,-2.11106),(.20412,51.95097,-2.21574),(.39719,51.62105,-2.27873),(.39558,51.62343,-2.27304),(.30556,51.6272,-2.28784),(.6068,51.88242,-1.99064),(.53493,51.84322,-2.0704),(.56304,51.81165,-2.08027),(.63658,51.80639,-2.00869),(.5403,51.67738,-2.20295),(.6052,51.71809,-2.15104),(.34044,51.88933,-2.1354),(.45764,51.9875,-2.0067),(.44902,51.98993,-2.01103),(.54574,51.68812,-2.22975),(.61909,51.72674,-2.18945),(.53321,51.69997,-1.75821),(.52004,51.68286,-1.76804),(.44915,51.69114,-1.83702),(.53441,51.67767,-1.75938),(.53273,51.63594,-1.60109),(.51743,51.60237,-1.54216),(.47315,51.60355,-1.60542),(.47891,51.56061,-1.47134),(.50084,51.56039,-1.43433),(.46442,51.55924,-1.46454),(1.12803,52.33014,-1.74248),(1.20207,52.36284,-1.82911),(1.15466,52.55139,-1.78008),(1.11758,52.5407,-1.77744),(1.12131,52.53039,-1.7694),(.90909,52.45461,-1.6754),(1.01348,52.48772,-1.71315),(.90636,52.46265,-1.68063),(.15056,52.15166,-2.14311),(.29123,52.23176,-2.03827),(.14718,52.1615,-2.14869),(.29929,52.21464,-2.11761),(.29573,52.21957,-2.10395),(.43406,52.20075,-2.09648),(.45789,52.51276,-1.70223),(.35194,52.45336,-1.80944),(.45631,52.50932,-1.69768),(.34871,52.45101,-1.80429),(.29822,52.23733,-2.02664),(.29082,52.2359,-2.02268),(.29828,52.33256,-1.92836),(.76595,52.39536,-1.84798),(.85414,52.44987,-1.91654),(.76175,52.38778,-1.88902),(.19016,52.3074,-1.65677),(.30423,52.32528,-1.64036),(.18954,52.30809,-1.66908),(.41246,51.99086,-1.90373),(.43161,51.99702,-1.93804),(.5472,51.99978,-1.90917),(.46664,52.1935,-1.53029),(.45144,52.21168,-1.50233),(.53564,52.27705,-1.60006),(.57251,52.27677,-1.65206),(.5664,52.28915,-1.65167),(.59667,52.05385,-1.72321),(.51784,51.98846,-1.66277),(.53126,51.95401,-1.69171),(.51507,51.98962,-1.62357),(.49929,51.92584,-1.57287),(.40977,51.96179,-1.35631),(.44862,51.9742,-1.37977),(.44622,51.98072,-1.37209),(.49587,51.92971,-1.49363),(.47431,51.91932,-1.43712),(.44953,51.89164,-1.42725),(.45668,51.98721,-1.37702),(.42809,52.05789,-1.35023),(.5016,52.09039,-1.5643),(.37161,52.14122,-1.33866),(.37614,52.1471,-1.34986),(.36528,52.15195,-1.3468),(.48329,51.93005,-1.43572),(.50379,51.93762,-1.48582),(.49503,52.23721,-1.48323),(.49965,52.27259,-1.43124),(.47935,52.24351,-1.47593),(.43868,51.86601,-1.43359),(.45949,51.81615,-1.42392),(.49011,51.84727,-1.50849),(.49882,51.89679,-1.76858),(.55169,51.77895,-1.60827),(.5135,51.79829,-1.76252),(.55096,51.60183,-1.49074),(.1685,52.24951,-1.73371),(.08013,52.25379,-1.63093),(.53166,52.31333,-1.66882),(.5019,52.29986,-1.62589),(.52995,52.28756,-1.60388),(.52519,52.30478,-1.52603),(.49857,52.33036,-1.50973),(.52807,52.32886,-1.46164),(.32033,52.22274,-1.4969),(.39064,52.20297,-1.42272),(.40732,52.24512,-1.47064),(.31195,52.1808,-1.42069),(.18444,52.09206,-1.21063),(.22782,52.10538,-1.23611),(.26897,52.12522,-1.27392),(.31472,51.8807,-1.23316),(.36477,51.92452,-1.31146),(.36463,52.00942,-1.26892),(.85118,52.06576,-1.96685),(.84335,52.15006,-1.85551),(.72893,52.1021,-1.87019),(.55918,51.62765,-1.46562),(.50482,51.72077,-1.44066),(.45587,51.67721,-1.37336),(.59946,51.68274,-1.54592),(.54236,51.75612,-1.52451),(.48887,51.90365,-1.59003),(.50214,51.8798,-1.59857),(.52094,52.23404,-1.50411),(.52076,52.2809,-1.43217),(.50475,52.09966,-1.60532),(.5083,52.10173,-1.61448),(.50964,52.03267,-1.63146),(.51994,52.02873,-1.65068),(.54278,52.19166,-1.63306),(.82907,52.23624,-1.73222),(.82465,52.19226,-1.77205),(.95911,52.22897,-1.75521),(1.26901,52.55252,-2.03527),(1.2751,52.51461,-2.0727),(1.25153,52.49623,-2.10854),(1.21578,52.55581,-1.81818),(1.20946,52.58657,-1.84624),(1.15009,52.58976,-1.85717),(1.14872,52.42333,-1.74806),(.93554,52.32704,-1.72087),(.83703,52.30684,-1.72448),(.55883,52.39456,-1.67398),(.51471,51.89364,-2.24743),(.50947,52.05522,-2.16473),(.58779,52.12929,-2.10609),(.60064,52.29513,-1.92585),(.49092,52.31678,-1.92128),(.56087,52.35208,-1.86778),(.64756,52.40062,-1.78264),(.76775,52.41283,-1.77078),(.7024,52.44138,-1.72068),(.89285,52.47522,-1.74579),(.78222,52.41505,-1.77931),(.83867,52.4583,-1.72647),(.99657,52.44031,-2.1067),(.96217,52.50189,-1.98074),(.7225,52.33789,-2.02197),(.61731,52.27056,-2.04282),(.54705,52.24482,-2.06887),(.54724,52.22402,-1.99482),(.5157,52.1382,-2.12664),(.4235,52.11367,-2.1741),(.43483,52.19483,-2.10844),(.73126,52.33402,-2.03898),(.66448,52.17511,-2.08858),(1.12632,52.46852,-2.12341),(1.07911,52.20148,-2.18247),(1.19212,52.2558,-2.16282),(1.23145,52.23512,-2.10183),(.71632,52.05027,-2.09957),(.74446,51.941,-2.02941),(.67567,51.8464,-2.14537),(.83683,52.14077,-2.08974),(1.0076,52.20278,-2.13849),(1.05282,52.17101,-2.10629),(.93685,52.17099,-2.111),(.98107,52.13201,-2.02975),(.85572,52.0578,-2.00296),(.74917,51.97631,-1.98192),(.32289,52.21439,-1.85112),(.39842,52.28541,-1.78264),(.39006,52.36903,-1.80065),(.30916,52.2803,-1.91372),(.27668,52.2145,-1.9955),(.30858,52.08512,-2.046),(.37949,52.28198,-1.97672),(.43364,52.19857,-2.02381),(.13816,52.1937,-2.22801),(.08254,52.18024,-2.29926),(0,52.14034,-2.61027),(0,52.06947,-2.89746),(.28947,52.03632,-2.32563),(.28861,52.13412,-2.20533),(.05646,52.05361,-3.05076),(.08914,51.93506,-3.05339),(.10876,51.94424,-3.14716),(.16026,52.01638,-3.16296),(.16005,51.95414,-3.18704),(.19177,51.9658,-3.22891),(.13675,51.9187,-3.30768),(.18846,51.97272,-3.2472),(.18892,51.88246,-3.28866),(.13347,51.75871,-3.27777),(1.29355,52.50406,-1.95305),(1.25636,52.48933,-1.84513),(1.24087,52.58347,-1.89396),(1.29894,52.49247,-1.9436),(1.25588,52.40883,-1.88453),(1.24403,52.3241,-1.90885),(1.26015,52.3462,-1.92646),(1.26483,52.37586,-1.9174),(1.08449,52.19865,-1.9516),(1.08697,52.23208,-1.86053),(.97303,52.20557,-1.86096),(.52851,51.96999,-1.85699),(.64585,52.06723,-1.86182),(.5788,52.02755,-1.75399),(.45781,51.99475,-2.00534),(.55012,51.95831,-1.98416),(.34846,52.26077,-1.76616),(.26537,52.25272,-1.74871),(.30206,52.31699,-1.65688),(.25106,52.08336,-1.85056),(.27809,51.94211,-1.87126),(.20817,51.90747,-1.86069),(.12237,51.48645,-1.31573),(0,51.48806,-1.28815),(0,51.49091,-1.30418),(.3761,51.51049,-1.3718),(.37389,51.51702,-1.35473),(.25931,51.49822,-1.32576),(.3422,51.67491,-1.82344),(.43923,51.6485,-1.72498),(.35089,51.66682,-1.71302),(.2691,51.6251,-1.57054),(.12769,51.57054,-1.45014),(.12496,51.61949,-1.56156),(0,51.56758,-1.44763),(0,51.53448,-1.38087),(.33716,51.69024,-1.89197),(.25472,51.66769,-1.83388),(.33803,51.69955,-1.89822),(.32048,51.74556,-1.90275),(.43839,51.7456,-1.83537),(.07854,51.64944,-2.72567),(.09451,51.63364,-2.57099),(0,51.65907,-2.58321),(.0926,51.657,-2.85197),(.0849,51.70611,-2.96873),(.08168,51.67712,-3.13441),(.05802,51.68769,-3.13166),(.09294,51.84076,-3.08069),(.11049,51.85673,-3.17403),(.46419,51.74897,-2.31283),(.36817,51.64092,-2.36938),(.67565,51.78693,-2.11989),(.63333,51.88849,-2.00179),(.6865,51.9302,-1.97204),(.55642,51.94747,-1.98643),(.30324,51.62752,-2.29603),(.1902,51.63988,-2.3886),(.27796,51.61695,-2.38097),(.53719,51.6786,-2.19821),(.47903,51.71846,-2.18497),(.49037,51.65176,-2.23402),(.54754,51.95077,-1.98578),(.50682,51.8748,-2.06046),(.40328,51.71075,-2.21078),(.46893,51.80787,-2.13046),(.45414,51.88221,-2.08041),(.21475,51.80809,-2.27713),(.27458,51.77886,-2.22431),(.08466,51.96505,-2.25184),(.17788,52.06238,-2.16723),(.08439,52.0435,-2.22311),(.09293,51.67848,-2.43693),(.09,51.82647,-2.32943),(.37791,51.86065,-2.13507),(.04932,51.67099,-2.98038),(.14933,51.62378,-2.64818),(.30319,52.11346,-1.88339),(.23014,51.6671,-1.92677),(.44683,51.6501,-1.73408),(.49996,51.57349,-1.42026),(.18692,52.05388,-1.8147),(.17622,52.16371,-1.7766),(.24898,52.18207,-1.80234),(.06861,52.2265,-1.69566),(.0759,52.14707,-1.7347),(.59814,51.68557,-1.59213),(.59576,51.65859,-1.56892),(1.06959,52.26321,-1.74788),(1.27105,52.25514,-1.99982),(1.18916,52.21777,-1.94572),(1.29212,52.49184,-1.88714),(.39876,51.92379,-1.84714),(.42099,51.80959,-1.83015),(.29704,51.82738,-1.90015),(.43631,51.86584,-2.3151),(.31854,51.94217,-2.35839),(.42666,51.99965,-2.24351),(.15217,51.86337,-3.21617),(.19215,51.87198,-3.27372),(.07788,51.80658,-3.35222),(.12303,51.92311,-3.31063),(.06772,52.04697,-3.21016),(.22156,52.13325,-2.26538),(.19603,51.99817,-2.43686),(.15831,52.09484,-2.38708),(.10527,52.08279,-2.48462),(.10037,51.99039,-2.6392),(.01574,52.07018,-3.05347),(.0428,52.16388,-2.4777),(.08798,52.18065,-2.30808),(.4372,52.19342,-2.03635),(.08792,52.10995,-2.22417),(.34399,52.11342,-1.95638),(.9083,52.26406,-2.15344),(.62853,51.95291,-2.15351),(1.1866,52.26501,-2.17112),(.8649,52.33404,-2.13362),(.6229,52.26256,-2.05356),(.61231,52.2827,-1.99139),(.96519,52.52946,-1.86597),(1.08247,52.57283,-1.92728),(1.00886,52.49706,-1.71684),(.98423,52.52899,-1.80028),(.82313,52.45847,-1.71794),(.85956,52.45256,-1.66843),(.7144,52.36999,-1.83584),(.57839,52.42951,-1.77939),(.58223,52.47055,-1.72243),(.56653,52.51593,-1.63082),(.47995,52.41305,-1.71764),(.46442,52.32324,-1.72081),(.56549,52.4597,-1.65299),(.60234,52.45022,-1.64338),(.72394,52.21114,-1.73939),(.63653,52.28995,-1.68961),(1.01415,52.36975,-1.7001),(1.28764,52.4388,-2.14851),(.29925,52.19171,-1.82319),(.73194,52.1613,-1.77335),(1.04535,52.30263,-1.72546),(.94025,52.27271,-1.73239),(.44608,52.03442,-1.42916),(.46842,52.26404,-1.45964),(.52555,52.19569,-1.58623),(.4021,51.89376,-1.38246),(.38499,51.81508,-1.34139),(.38885,51.9484,-1.34291),(.29979,51.98856,-1.19327),(.25406,52.07674,-1.20214),(.18321,52.05417,-1.15203),(.48192,52.33057,-1.50077),(.4671,52.31088,-1.4952),(.51557,52.32918,-1.44665),(.45001,52.31628,-1.65952),(.41762,52.29896,-1.69287),(.08461,52.25262,-1.61836),(.07944,52.22656,-1.58798),(.37468,51.54278,-1.47978),(.26083,51.51346,-1.36039),(.26268,51.55212,-1.45529),(.33134,51.76514,-1.27102),(.2232,51.72861,-1.91539),(.47457,51.8694,-1.51238),(.5202,52.02595,-1.55886),(.47515,52.03283,-1.48996),(.52124,51.96714,-1.54725),(.5163,52.0223,-1.57349),(.39519,52.08908,-1.34253),(.42524,52.24384,-1.47013),(.41592,52.23751,-1.46774),(.4363,52.19725,-1.50169),(.51679,51.96639,-1.56055),(.41773,52.05223,-1.34284),(.40813,52.0218,-1.33265),(.63276,52.36814,-1.66083),(.53079,52.29332,-1.52666),(.32635,51.96188,-1.876),(.14379,52.1929,-2.23798),(.5537,52.23987,-2.07771),(.86511,52.45262,-1.67207),(.87071,52.40467,-2.04957),(.86992,52.41389,-2.03003),(1.20634,52.32963,-1.85061),(.45619,51.64039,-1.71668),(.46171,51.57131,-1.5099),(.46013,51.60993,-1.60584),(.12382,51.50718,-1.33441),(.59808,51.88287,-1.98722),(.38785,51.62329,-2.29831),(.33487,51.6234,-2.33382),(.28044,51.64297,-2.48711),(.2761,51.73004,-2.47591),(.374,51.71958,-2.36743),(.14658,51.66619,-2.72111),(.14655,51.65278,-2.70982),(.40768,52.09295,-1.34999),(.31493,52.10242,-1.25754),(1.29176,52.50655,-1.94785),(1.21066,52.2355,-1.93327),(1.31692,52.39226,-2.02874),(1.21984,52.24411,-1.92562),(.06945,51.66153,-2.85358),(.09338,51.80559,-3.35132),(.04442,51.80689,-3.33617),(.04772,51.76448,-3.2843),(-.09,51.82647,-2.32985),(-.21475,51.80809,-2.27815),(-.08439,52.0435,-2.22346),(-.20412,51.95097,-2.21665),(-.27458,51.77886,-2.22565),(-.50682,51.8748,-2.06282),(-.49037,51.65176,-2.23669),(-.53719,51.6786,-2.2009),(-.33487,51.6234,-2.33591),(-.27796,51.61695,-2.3827),(-.11049,51.85673,-3.17427),(-.09294,51.84076,-3.08092),(-.0849,51.70611,-2.96899),(-.18509,51.61696,-2.5539),(-.30858,52.08512,-2.0473),(-.07854,51.64944,-2.72599),(0,51.65156,-2.73167),(-.33716,51.69024,-1.89441),(-.23287,51.66031,-1.92266),(-.25472,51.66769,-1.83604),(-.35089,51.66682,-1.71593),(-.26054,51.66435,-1.71046),(-.12106,51.48836,-1.29722),(-.12237,51.48645,-1.3174),(-.52004,51.68286,-1.77149),(-.44915,51.69114,-1.84004),(-.44683,51.6501,-1.73772),(-.27809,51.94211,-1.87264),(-.26537,52.25272,-1.74978),(-.45781,51.99475,-2.00736),(-.43161,51.99702,-1.94),(-.53126,51.95401,-1.69427),(-.72893,52.1021,-1.873),(-.65055,52.08454,-1.82651),(-.82465,52.19226,-1.77493),(-.95911,52.22897,-1.75822),(-.97303,52.20557,-1.86397),(-1.08449,52.19865,-1.95463),(-.98248,52.14484,-1.95376),(-1.26015,52.3462,-1.92902),(-1.24403,52.3241,-1.91151),(-1.26901,52.55252,-2.03696),(-1.21578,52.55581,-1.82016),(-1.2848,52.50632,-1.88937),(-1.25636,52.48933,-1.84728),(-1.27954,52.26305,-1.99003),(-.35296,51.82337,-2.3771),(-.44948,51.81443,-2.32709),(0,51.97732,-3.26744),(-.18846,51.97272,-3.24752),(-.13208,52.00169,-3.25699),(-.19177,51.9658,-3.22925),(-.16005,51.95414,-3.18735),(-.16026,52.01638,-3.16325),(-.08914,51.93506,-3.0536),(-.10481,52.04551,-3.11426),(-.37949,52.28198,-1.97808),(-.29822,52.23733,-2.02775),(-.83683,52.14077,-2.09249),(-1.12632,52.46852,-2.12539),(-.43483,52.19483,-2.11003),(-.54724,52.22402,-1.99679),(-.85414,52.44987,-1.91869),(-.76175,52.38778,-1.89122),(-.86992,52.41389,-2.03219),(-.8651,52.46372,-1.82633),(-.73597,52.48756,-1.63495),(-.56087,52.35208,-1.86963),(-.69575,52.36726,-1.83173),(-.49092,52.31678,-1.92297),(-.54216,52.22859,-1.98317),(-.34871,52.45101,-1.80541),(-.37321,52.41037,-1.80448),(-.5664,52.28915,-1.65374),(-.55883,52.39456,-1.67583),(-1.12131,52.53039,-1.77154),(-1.14872,52.42333,-1.75058),(-1.15009,52.58976,-1.85904),(-1.15466,52.55139,-1.78214),(-1.20946,52.58657,-1.84809),(-1.23283,52.56526,-2.01623),(-1.04535,52.30263,-1.72835),(-.53564,52.27705,-1.60207),(-.57251,52.27677,-1.65418),(-.54278,52.19166,-1.63525),(-.50379,51.93762,-1.48834),(-.50475,52.09966,-1.60755),(-.47024,52.16126,-1.54435),(-.50482,51.72077,-1.44361),(-.85118,52.06576,-1.96994),(-.31472,51.8807,-1.23485),(-.29979,51.98856,-1.19476),(-.36463,52.00942,-1.2707),(-.26897,52.12522,-1.27515),(-.22782,52.10538,-1.23717),(-.18444,52.09206,-1.2115),(-.5019,52.29986,-1.62775),(-.47935,52.24351,-1.47784),(-.49587,51.92971,-1.49613),(-.46943,52.16,-1.52815),(-.45668,51.98721,-1.37925),(-.41386,52.25202,-1.47567),(-.46591,52.27441,-1.4612),(-.48352,51.8935,-1.50242),(-.44953,51.89164,-1.42961),(-.44862,51.9742,-1.38199),(-.42264,51.9167,-1.38768),(-.40977,51.96179,-1.35837),(-.51784,51.98846,-1.66523),(-.57901,52.20343,-1.67716),(-.5472,51.99978,-1.91159),(-.19016,52.3074,-1.65751),(-.30434,52.33739,-1.93333),(-1.20207,52.36284,-1.83174),(-1.13643,52.29218,-1.76679),(-1.12803,52.33014,-1.74531),(-.51743,51.60237,-1.54683),(-.61196,51.81923,-2.20032),(-.6052,51.71809,-2.15394),(-.60092,51.71587,-2.14847),(-.45764,51.9875,-2.00874),(-.34044,51.88933,-2.13699),(-.08603,51.73737,-2.96207),(-.09336,51.74,-3.10793),(-.21094,51.6402,-2.59223),(-.23528,51.61792,-2.44104),(-.21454,51.65129,-2.59737),(-.20377,51.64039,-2.60682),(-.10679,51.68855,-2.83823),(-.3984,52.1316,-1.38773),(-1.16819,52.43944,-1.75752),(-1.16427,52.42072,-1.75431),(-1.24005,52.46036,-1.81586),(-1.22798,52.40133,-1.84733),(-1.30649,52.32689,-2.0495),(-1.30489,52.35785,-2.12661),(-.16407,51.80582,-3.32595),(-.16099,51.81062,-3.33477),(-.15352,51.80108,-3.33113),(-.08511,51.79305,-3.3494),(0,51.8249,-3.31943),(-.0403,51.81628,-3.33822),(0,51.87132,-3.31186),(-.02347,52.04756,-2.894),(-.00821,52.06959,-3.1525),(-.85956,52.45256,-1.67074),(-.07989,52.04999,-3.20311),(-.12615,51.7583,-3.28877),(-.14161,52.04121,-3.17185),(-1.30306,52.36835,-2.13525),(-1.29712,52.42848,-2.09329),(-1.22969,52.2934,-2.15417),(-1.3102,52.45597,-1.99859),(-1.31188,52.39542,-2.04678),(-.44792,52.18413,-1.50467),(-.4744,51.66202,-2.2878),(-.46151,51.65008,-2.28721),(-.27482,51.63319,-2.48585),(-.37034,51.63196,-2.35966),(-.45039,51.57193,-1.5045),(-.46013,51.60993,-1.61012),(-.43923,51.6485,-1.72861),(-.3422,51.67491,-1.82614),(-.14718,52.1615,-2.14926),(-.59667,52.05385,-1.72581),(-.47431,51.91932,-1.43954),(-.46842,52.26404,-1.46148),(-.47457,51.8694,-1.51488),(-.55096,51.60183,-1.49553),(-.52807,52.32886,-1.46357),(-.40732,52.24512,-1.47229),(-.25406,52.07674,-1.20334),(-.84335,52.15006,-1.85847),(-.52094,52.23404,-1.50617),(-1.11187,52.32991,-1.74145),(-1.16717,52.59563,-1.93168),(-1.25032,52.57673,-1.96189),(-1.24087,52.58347,-1.89574),(-1.20788,52.48778,-1.7757),(-.87071,52.40467,-2.05174),(-1.22355,52.30225,-2.1627),(-1.11095,52.1979,-2.09421),(-.93685,52.17099,-2.11379),(-.46419,51.74897,-2.31496),(-.39842,52.28541,-1.78414),(-.05319,52.00108,-2.90982),(-.10876,51.94424,-3.14738),(-.18892,51.88246,-3.289),(-.11828,52.00062,-3.26191),(-1.25588,52.40883,-1.88693),(-1.08697,52.23208,-1.86356),(-.20817,51.90747,-1.86176),(-.25931,51.49822,-1.32913),(-.12496,51.61949,-1.56287),(-.36401,51.78022,-2.18974),(-.08466,51.96505,-2.25221),(0,51.69315,-2.50482),(0,51.72208,-2.4414),(.37321,52.41037,-1.80323),(0,52.07192,-3.14824),(1.11095,52.1979,-2.09134),(1.30306,52.36835,-2.13309),(1.22355,52.30225,-2.16029),(1.24005,52.46036,-1.81356),(1.22798,52.40133,-1.84485),(1.26381,52.47496,-1.84657),(1.31156,52.31449,-2.03279),(.39096,52.10865,-1.35345),(.43628,52.06496,-1.41548),(.35736,51.63176,-2.36997),(.37034,51.63196,-2.35759),(.54634,51.69791,-2.23874),(.53634,51.78475,-2.26614),(.25968,51.49566,-1.34158),(.45356,51.70116,-1.84067),(.41782,51.53922,-1.43696),(.60685,52.28986,-1.93981),(.62322,52.30136,-1.92603),(.31411,52.32756,-1.64998),(.64326,52.21058,-1.71859),(.63993,52.17524,-1.73005),(.50728,52.28921,-1.42156),(.39261,52.00662,-1.31636),(.51142,51.9565,-1.54807),(.50422,52.08944,-1.54929),(.40903,52.30157,-1.53652),(.4463,52.34463,-1.55383),(.40371,52.34958,-1.59517),(.21798,51.81016,-1.89029),(.35617,51.62784,-1.31333),(.27875,52.14031,-1.31601),(.31118,52.26331,-1.55409),(.19422,52.19945,-1.50504),(.2128,51.97075,-1.14792),(.46143,52.01724,-1.45677),(.38441,52.13906,-1.37992),(.56817,52.51873,-1.63774),(1.10154,52.53064,-2.01035),(.32258,52.12086,-1.91233),(.14461,51.99204,-2.52158),(.35296,51.82337,-2.37556),(1.16819,52.43944,-1.75507),(1.23067,52.47324,-1.80556),(1.20788,52.48778,-1.77345),(1.12173,52.28701,-1.76143),(0,52.14083,-1.72107),(.23528,51.61792,-2.4397),(.11374,51.64424,-2.72921),(.20377,51.64039,-2.60593),(.36401,51.78022,-2.18796),(.09336,51.74,-3.10769),(.09278,51.72023,-3.22847),(.23287,51.66031,-1.92069),(.26054,51.66435,-1.70817),(.12106,51.48836,-1.29558),(.65055,52.08454,-1.82385),(.98248,52.14484,-1.95065),(1.2848,52.50632,-1.88735),(1.27954,52.26305,-1.98728),(.44948,51.81443,-2.32511),(.05319,52.00108,-2.90968),(.08622,52.12246,-2.22998),(.8651,52.46372,-1.82413),(.69575,52.36726,-1.82958),(.54216,52.22859,-1.98122),(1.25032,52.57673,-1.96016),(1.16717,52.59563,-1.92991),(1.23283,52.56526,-2.01451),(.46591,52.27441,-1.45938),(.41386,52.25202,-1.474),(.48352,51.8935,-1.49992),(.42264,51.9167,-1.38549),(.57901,52.20343,-1.67489),(.30434,52.33739,-1.93226),(1.16427,52.42072,-1.75179),(.45039,51.57193,-1.49984),(.08603,51.73737,-2.9618),(.21454,51.65129,-2.59644),(.4145,52.17273,-1.44117),(.44792,52.18413,-1.50278),(.12615,51.7583,-3.28851),(.09194,51.75174,-3.29886),(.0403,51.81628,-3.33815),(-.49331,51.65044,-2.24159),(-.6068,51.88242,-1.99343),(-1.29212,52.49184,-1.8892),(-1.23067,52.47324,-1.80783),(-.32258,52.12086,-1.91371),(-1.10154,52.53064,-2.01228),(-.58223,52.47055,-1.72418),(-.40094,52.19744,-1.42583),(-.31118,52.26331,-1.55535),(-.19422,52.19945,-1.50588),(-.27875,52.14031,-1.31727),(-.54236,51.75612,-1.5275),(-.21798,51.81016,-1.89148),(-.40371,52.34958,-1.59665),(-.4463,52.34463,-1.55546),(-.40903,52.30157,-1.53809),(-.47515,52.03283,-1.4922),(-.5202,52.02595,-1.56128),(-.53079,52.29332,-1.52865),(-.08254,52.18024,-2.29955),(-.12382,51.50718,-1.33605),(-.2761,51.73004,-2.47713),(-1.26381,52.47496,-1.84876),(-.04442,51.80689,-3.33625),(0,51.68617,-3.13358),(-.44495,52.11534,-1.4808),(-.4145,52.17273,-1.44295),(-.43128,52.11285,-1.45578),(-.21049,51.72503,-2.58944),(-.15108,51.72268,-2.7115),(-.12535,51.64458,-1.88015),(-.1219,51.65114,-1.88604),(-.45556,52.34589,-1.56377),(0,52.03255,-1.13271),(-.08072,52.05335,-1.14494),(-.08344,52.04218,-1.13819),(0,52.04417,-1.13888),(-.30561,52.11166,-1.26225),(-.24568,52.08618,-1.20881),(-.18968,52.16159,-1.41406),(-.0847,52.08246,-1.1872),(0,52.09261,-1.27204),(-.08567,52.1091,-1.28352),(0,52.06912,-1.17724),(-.18949,52.12123,-1.2951),(-.08509,52.14858,-1.40172),(-.2128,51.97075,-1.149),(-.18321,52.05417,-1.15292),(-.2222,51.85771,-1.19764),(0,51.82676,-1.1733),(-.10745,51.7195,-1.21794),(0,51.70707,-1.21468),(-.10354,51.83964,-1.17034),(-.11299,51.58334,-1.25642),(0,51.57481,-1.25667),(-.45747,52.10036,-1.4947),(-.47204,52.46964,-1.71023),(-.47709,52.38367,-1.85829),(-.51418,52.41812,-1.81344),(-.98423,52.52899,-1.8024),(-.51471,51.89364,-2.24962),(-.38265,52.33842,-1.92392),(-.10837,51.89478,-2.79385),(-.14357,51.89593,-2.67492),(-.06755,51.98853,-2.76421),(-.10998,51.82871,-2.8137),(-.15853,51.81619,-2.6946),(-1.20634,52.32963,-1.85334),(-.66649,52.12597,-1.7689),(0,51.63407,-1.71496),(0,51.60837,-1.55673),(-.12087,51.64953,-1.70681),(-.08682,52.02199,-1.77319),(0,51.87647,-1.80069),(-.09807,51.87794,-1.816),(0,52.01388,-1.75439),(-.1077,51.72858,-2.83123),(-.27831,51.77496,-2.21885),(0,52.0455,-2.24321),(0,51.9625,-2.27374),(.47204,52.46964,-1.70876),(.11828,52.00062,-3.26171),(1.11187,52.32991,-1.73862),(.40344,52.18519,-1.4409),(0,51.66157,-2.87136),(.15108,51.72268,-2.71091),(.1077,51.72858,-2.83085),(.49331,51.65044,-2.23892),(.61196,51.81923,-2.19761),(0,51.63488,-1.85499),(.1219,51.65114,-1.88493),(.12535,51.64458,-1.87898),(0,51.64224,-1.86145),(.411,52.35143,-1.60572),(.58042,52.14075,-1.69346),(.17733,52.06463,-1.15847),(.08344,52.04218,-1.13778),(.08072,52.05335,-1.14455),(.30561,52.11166,-1.26085),(.40094,52.19744,-1.42413),(.10157,51.77964,-1.85096),(.11066,51.71246,-1.87244),(.12087,51.64953,-1.70564),(0,51.63541,-1.82461),(.12737,51.65073,-1.82272),(.18968,52.16159,-1.4132),(.18949,52.12123,-1.29422),(.29753,52.27038,-1.57457),(.20149,52.25147,-1.5988),(.08509,52.14858,-1.40132),(0,52.17247,-1.48976),(0,52.13495,-1.39041),(.08243,52.18404,-1.49541),(.08567,52.1091,-1.28312),(.10077,51.95959,-1.13194),(.2222,51.85771,-1.19642),(.22552,51.73857,-1.24183),(.24698,51.6045,-1.28251),(.66649,52.12597,-1.76625),(.51418,52.41812,-1.8118),(.47709,52.38367,-1.85672),(.48078,52.4645,-1.77017),(1.10473,52.57467,-1.8463),(.06755,51.98853,-2.764),(.14357,51.89593,-2.67442),(.18632,51.89605,-2.55457),(.10837,51.89478,-2.7935),(.08954,51.83436,-2.94032),(.0895,51.90875,-2.92167),(.10998,51.82871,-2.81333),(.26564,51.82378,-2.47431),(.23697,51.9074,-2.463),(.08682,52.02199,-1.77277),(.09807,51.87794,-1.81547),(.15853,51.81619,-2.69402),(.21049,51.72503,-2.58856),(.20553,51.81527,-2.58007),(.27831,51.77496,-2.21747),(0,51.81696,-2.36045),(.40881,52.4104,-1.84305),(.45747,52.10036,-1.49264),(.47063,52.07696,-1.50132),(.44495,52.11534,-1.47881),(.11299,51.58334,-1.25522),(.10745,51.7195,-1.21725),(.10354,51.83964,-1.16976),(.0847,52.08246,-1.1868),(.45556,52.34589,-1.56212),(.10287,51.72685,-3.22308),(-.26564,51.82378,-2.47542),(-.08954,51.83436,-2.94058),(-.10157,51.77964,-1.85154),(0,51.77078,-1.83916),(-.12737,51.65073,-1.82392),(-.18632,51.89605,-2.55528),(-.20553,51.81527,-2.58089),(-1.10473,52.57467,-1.84824),(-.24698,51.6045,-1.28492),(-.22552,51.73857,-1.24317),(-.10077,51.95959,-1.13246),(-.08243,52.18404,-1.49578),(0,52.23633,-1.61881),(-.411,52.35143,-1.60722),(-.47063,52.07696,-1.50347),(-.17733,52.06463,-1.15932),(0,51.67604,-2.994),(0,52.11293,-2.2471),(-.08622,52.12246,-2.23031),(0,52.12557,-2.25297),(-.58042,52.14075,-1.69585),(-.11066,51.71246,-1.87326),(0,51.94738,-1.13417),(-.23697,51.9074,-2.46394),(-.0895,51.90875,-2.92192),(.24568,52.08618,-1.20765),(0,51.70276,-1.85057),(.38265,52.33842,-1.9226)]))),
        Shape(DEF='t1disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t1disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,8,7,9,-1,10,11,12,-1,13,14,15,-1,16,17,15,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,24,-1,32,3,33,-1,34,35,11,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,53,55,-1,51,56,57,-1,58,59,51,-1,60,59,58,-1,61,62,63,-1,64,65,66,-1,67,68,69,-1,68,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,82,70,-1,83,81,67,-1,84,85,86,-1,13,60,14,-1,59,60,87,-1,63,62,88,-1,49,36,89,-1,90,91,92,-1,27,45,28,-1,45,47,28,-1,93,47,92,-1,94,88,95,-1,96,97,98,-1,74,73,99,-1,100,101,102,-1,103,104,105,-1,106,107,24,-1,108,22,21,-1,109,110,111,-1,112,110,113,-1,109,114,115,-1,116,109,16,-1,15,116,16,-1,117,6,118,-1,117,119,71,-1,120,121,122,-1,117,71,123,-1,118,124,117,-1,125,122,126,-1,113,127,112,-1,128,129,130,-1,108,131,22,-1,107,29,24,-1,27,107,71,-1,107,123,71,-1,73,86,99,-1,132,133,78,-1,92,72,93,-1,46,90,92,-1,89,50,49,-1,51,53,54,-1,134,40,52,-1,51,54,58,-1,135,136,59,-1,84,63,85,-1,83,137,81,-1,70,68,81,-1,80,138,78,-1,75,77,2,-1,74,93,72,-1,66,139,140,-1,71,119,68,-1,141,37,142,-1,141,38,37,-1,67,81,68,-1,61,63,84,-1,54,55,143,-1,97,144,145,-1,50,146,48,-1,46,92,47,-1,45,27,70,-1,27,71,70,-1,89,36,38,-1,147,34,11,-1,96,98,128,-1,148,149,19,-1,30,24,29,-1,107,27,29,-1,26,106,24,-1,23,150,21,-1,109,113,110,-1,151,111,102,-1,109,116,113,-1,152,16,153,-1,12,18,10,-1,9,154,8,-1,8,118,6,-1,6,123,155,-1,6,117,123,-1,3,156,4,-1,0,2,77,-1,157,158,159,-1,160,158,157,-1,161,162,163,-1,161,164,162,-1,165,166,108,-1,165,167,166,-1,168,169,170,-1,168,171,169,-1,172,122,173,-1,172,126,122,-1,124,119,117,-1,124,174,119,-1,154,4,8,-1,4,154,175,-1,156,176,120,-1,176,156,3,-1,104,154,177,-1,104,175,154,-1,153,19,18,-1,19,153,148,-1,178,153,16,-1,148,153,178,-1,109,178,16,-1,115,178,109,-1,98,179,180,-1,98,181,179,-1,182,183,149,-1,182,184,183,-1,185,186,187,-1,188,186,185,-1,189,190,33,-1,189,191,190,-1,22,183,192,-1,131,183,22,-1,193,190,163,-1,193,194,190,-1,160,185,158,-1,160,195,185,-1,165,21,25,-1,165,108,21,-1,167,196,166,-1,167,10,196,-1,197,26,150,-1,26,197,198,-1,199,19,149,-1,199,20,19,-1,33,5,189,-1,33,3,5,-1,186,176,200,-1,186,201,176,-1,112,157,159,-1,157,112,127,-1,202,1,203,-1,2,1,202,-1,145,204,205,-1,204,145,143,-1,40,206,55,-1,39,206,40,-1,207,78,208,-1,207,132,78,-1,95,209,94,-1,95,210,209,-1,46,211,90,-1,46,82,211,-1,84,73,212,-1,73,84,86,-1,47,213,28,-1,93,213,47,-1,214,215,216,-1,215,214,217,-1,218,219,220,-1,218,221,219,-1,222,223,224,-1,223,222,225,-1,226,42,227,-1,42,226,225,-1,228,207,229,-1,207,228,220,-1,230,231,217,-1,230,202,231,-1,55,52,40,-1,55,53,52,-1,232,87,233,-1,232,234,87,-1,60,233,87,-1,233,60,13,-1,211,142,37,-1,142,211,137,-1,79,235,80,-1,44,235,79,-1,83,138,80,-1,236,138,83,-1,139,237,238,-1,66,237,139,-1,236,140,138,-1,66,140,236,-1,77,239,171,-1,77,76,239,-1,240,48,146,-1,48,240,241,-1,41,221,218,-1,41,242,221,-1,216,205,204,-1,216,215,205,-1,243,204,206,-1,243,216,204,-1,244,245,246,-1,245,244,247,-1,241,248,48,-1,248,241,212,-1,169,239,249,-1,171,239,169,-1,66,250,237,-1,250,66,65,-1,119,69,68,-1,174,69,119,-1,80,141,83,-1,80,235,141,-1,251,66,236,-1,251,64,66,-1,141,137,83,-1,141,142,137,-1,88,136,63,-1,88,94,136,-1,136,209,59,-1,136,94,209,-1,209,51,59,-1,209,56,51,-1,215,98,205,-1,98,215,181,-1,224,210,95,-1,210,224,223,-1,229,252,228,-1,229,253,252,-1,254,227,133,-1,227,254,226,-1,224,50,222,-1,224,146,50,-1,254,221,246,-1,221,254,219,-1,252,216,243,-1,216,252,214,-1,45,82,46,-1,45,70,82,-1,43,38,44,-1,43,89,38,-1,57,247,244,-1,247,57,56,-1,134,244,242,-1,244,134,57,-1,238,253,229,-1,253,238,237,-1,97,205,98,-1,97,145,205,-1,203,172,255,-1,203,1,172,-1,255,173,188,-1,255,172,173,-1,151,101,256,-1,101,151,102,-1,104,189,5,-1,103,189,104,-1,166,20,199,-1,166,196,20,-1,198,106,26,-1,106,198,155,-1,147,10,167,-1,147,11,10,-1,213,29,28,-1,213,30,29,-1,179,195,160,-1,179,257,195,-1,194,258,259,-1,193,258,194,-1,184,192,183,-1,184,260,192,-1,103,191,189,-1,103,260,191,-1,200,187,186,-1,200,259,187,-1,231,203,257,-1,202,203,231,-1,111,112,102,-1,110,112,111,-1,17,232,233,-1,261,232,17,-1,233,15,17,-1,233,13,15,-1,196,18,20,-1,196,10,18,-1,118,262,263,-1,118,8,262,-1,7,155,198,-1,155,7,6,-1,197,154,9,-1,177,154,197,-1,170,174,124,-1,170,169,174,-1,170,125,168,-1,263,125,170,-1,1,126,172,-1,126,1,0,-1,108,199,131,-1,108,166,199,-1,193,101,258,-1,256,101,193,-1,180,160,157,-1,179,160,180,-1,264,159,158,-1,264,100,159,-1,184,164,161,-1,182,164,184,-1,31,34,147,-1,34,31,30,-1,168,77,171,-1,0,77,168,-1,120,262,156,-1,120,122,262,-1,173,121,201,-1,173,122,121,-1,156,8,4,-1,156,262,8,-1,175,5,4,-1,175,104,5,-1,9,198,197,-1,9,7,198,-1,11,265,12,-1,11,35,265,-1,14,130,15,-1,14,128,130,-1,14,96,128,-1,152,17,16,-1,261,17,152,-1,152,18,12,-1,18,152,153,-1,266,261,265,-1,266,232,261,-1,111,114,109,-1,111,151,114,-1,256,163,162,-1,256,193,163,-1,195,188,185,-1,255,188,195,-1,194,33,190,-1,32,33,194,-1,23,192,105,-1,23,22,192,-1,191,163,190,-1,161,163,191,-1,158,187,264,-1,158,185,187,-1,25,150,26,-1,150,25,21,-1,25,31,165,-1,31,25,24,-1,115,182,178,-1,115,164,182,-1,34,267,35,-1,34,268,267,-1,23,197,150,-1,23,177,197,-1,178,149,148,-1,182,149,178,-1,3,200,176,-1,32,200,3,-1,159,102,112,-1,159,100,102,-1,157,129,180,-1,157,127,129,-1,75,202,230,-1,75,2,202,-1,204,55,206,-1,204,143,55,-1,208,229,207,-1,229,208,238,-1,79,133,227,-1,133,79,78,-1,88,240,95,-1,240,88,62,-1,90,37,36,-1,90,211,37,-1,61,212,241,-1,212,61,84,-1,49,248,91,-1,48,248,49,-1,217,181,215,-1,181,217,231,-1,269,220,228,-1,269,218,220,-1,245,225,226,-1,245,223,225,-1,225,43,42,-1,43,225,222,-1,220,132,207,-1,132,220,219,-1,270,217,214,-1,270,230,217,-1,143,144,54,-1,144,143,145,-1,271,135,234,-1,135,271,85,-1,60,54,144,-1,60,58,54,-1,266,99,271,-1,99,266,267,-1,141,44,38,-1,235,44,141,-1,208,138,140,-1,208,78,138,-1,69,251,67,-1,251,69,249,-1,140,238,208,-1,238,140,139,-1,239,65,64,-1,239,76,65,-1,268,93,74,-1,268,213,93,-1,95,146,224,-1,146,95,240,-1,218,39,41,-1,39,218,269,-1,73,248,212,-1,73,72,248,-1,206,269,243,-1,269,206,39,-1,247,223,245,-1,247,210,223,-1,65,75,250,-1,65,76,75,-1,64,249,239,-1,64,251,249,-1,174,249,69,-1,169,249,174,-1,82,137,211,-1,82,81,137,-1,236,67,251,-1,67,236,83,-1,271,86,85,-1,86,271,99,-1,144,14,60,-1,97,14,144,-1,96,14,97,-1,87,135,59,-1,87,234,135,-1,63,135,85,-1,63,136,135,-1,234,266,271,-1,266,234,232,-1,57,52,51,-1,52,57,134,-1,246,242,244,-1,242,246,221,-1,253,214,252,-1,253,270,214,-1,133,219,254,-1,133,132,219,-1,222,89,43,-1,89,222,50,-1,246,226,254,-1,246,245,226,-1,228,243,269,-1,243,228,252,-1,36,91,90,-1,36,49,91,-1,72,91,248,-1,72,92,91,-1,210,56,209,-1,247,56,210,-1,267,74,99,-1,268,74,267,-1,62,241,240,-1,241,62,61,-1,227,44,79,-1,227,42,44,-1,41,134,242,-1,41,40,134,-1,237,270,253,-1,270,237,250,-1,250,230,270,-1,230,250,75,-1,180,128,98,-1,129,128,180,-1,188,201,186,-1,188,173,201,-1,162,151,256,-1,162,114,151,-1,164,114,162,-1,164,115,114,-1,177,105,104,-1,23,105,177,-1,155,107,106,-1,107,155,123,-1,181,257,179,-1,181,231,257,-1,259,264,187,-1,258,264,259,-1,260,161,191,-1,184,161,260,-1,105,260,103,-1,105,192,260,-1,32,259,200,-1,32,194,259,-1,257,255,195,-1,203,255,257,-1,130,127,113,-1,130,129,127,-1,152,265,261,-1,152,12,265,-1,113,15,130,-1,15,113,116,-1,35,266,265,-1,35,267,266,-1,122,263,262,-1,125,263,122,-1,263,124,118,-1,263,170,124,-1,201,120,176,-1,201,121,120,-1,126,168,125,-1,168,126,0,-1,30,268,34,-1,268,30,213,-1,131,149,183,-1,131,199,149,-1,100,258,101,-1,100,264,258,-1,165,147,167,-1,147,165,31,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t1disc_Coord',point=[(.10306,51.36578,-1.42863),(.10039,51.34389,-1.36726),(0,51.34091,-1.35791),(.44796,51.38153,-1.62203),(.4053,51.44513,-1.72516),(.47102,51.44536,-1.71653),(.2222,51.54293,-1.87807),(.3008,51.56499,-1.8866),(.29017,51.45107,-1.73342),(.36814,51.56562,-1.85641),(.33629,51.68939,-1.88835),(.23701,51.66171,-1.90427),(.25472,51.66769,-1.83388),(0,51.56758,-1.44763),(0,51.53448,-1.38087),(.12769,51.57054,-1.45014),(.2691,51.6251,-1.57054),(.12496,51.61949,-1.56156),(.3422,51.67491,-1.82344),(.43554,51.6495,-1.72874),(.43619,51.66309,-1.76941),(.44195,51.64018,-1.88413),(.48038,51.59197,-1.80654),(.49041,51.55478,-1.82353),(.23132,51.62099,-1.93829),(.32749,51.63704,-1.93631),(.32111,51.60922,-1.94843),(0,51.53056,-1.8868),(0,51.56354,-1.88097),(.12269,51.58382,-1.90228),(.12311,51.61469,-1.89404),(.2331,51.64264,-1.9263),(.45197,51.38389,-1.61802),(.45197,51.38407,-1.61891),(.12509,51.64108,-1.88074),(.12549,51.64501,-1.87511),(-.44182,51.61336,-1.89279),(-.43886,51.60751,-1.89263),(-.487,51.5516,-1.83136),(-.43379,51.53547,-1.42755),(-.43168,51.53954,-1.42927),(-.43458,51.53603,-1.4286),(-.48897,51.49515,-1.7679),(-.48834,51.49702,-1.76998),(-.48539,51.49289,-1.77161),(-.12353,51.55562,-1.90459),(-.23175,51.60023,-1.94571),(-.12269,51.58382,-1.90363),(-.43521,51.66868,-1.87283),(-.44195,51.64018,-1.88771),(-.48038,51.59197,-1.81108),(-.37468,51.54278,-1.48414),(-.40829,51.54001,-1.45109),(-.37533,51.5281,-1.43527),(-.26083,51.51346,-1.3637),(-.3741,51.51153,-1.37961),(-.45586,51.60657,-1.60385),(-.44675,51.57118,-1.50521),(-.26268,51.55212,-1.45842),(-.2691,51.6251,-1.57321),(-.12769,51.57054,-1.45164),(-.41762,51.68988,-1.85147),(-.43619,51.66309,-1.77281),(-.3422,51.67491,-1.82614),(-.19662,51.37507,-1.48916),(-.19447,51.36645,-1.46649),(-.26543,51.36819,-1.49629),(-.20893,51.46104,-1.73562),(-.11765,51.52066,-1.85224),(-.11269,51.47018,-1.72592),(-.12596,51.55042,-1.90231),(0,51.52592,-1.88378),(-.2331,51.64264,-1.92838),(-.2365,51.6584,-1.91276),(-.12509,51.64108,-1.88192),(-.10039,51.34389,-1.36907),(-.10306,51.36578,-1.43045),(0,51.37287,-1.40651),(-.44796,51.38153,-1.62912),(-.47102,51.44536,-1.72304),(-.4053,51.44513,-1.73095),(-.2222,51.54293,-1.88075),(-.23307,51.5946,-1.94375),(-.29017,51.45107,-1.73771),(-.33629,51.68939,-1.8908),(-.25472,51.66769,-1.83604),(-.23701,51.66171,-1.90627),(-.12496,51.61949,-1.56287),(-.43554,51.6495,-1.73234),(-.49041,51.55478,-1.82862),(-.32111,51.60922,-1.95146),(-.32749,51.63704,-1.93914),(-.23132,51.62099,-1.94049),(-.12311,51.61469,-1.89529),(-.43557,51.64925,-1.7281),(-.44082,51.64514,-1.72948),(0,51.49274,-1.30741),(-.01609,51.49303,-1.3084),(0,51.48717,-1.30497),(-.12549,51.64501,-1.87629),(.43379,51.53547,-1.42265),(.43458,51.53603,-1.4237),(.43168,51.53954,-1.42443),(.48897,51.49515,-1.76193),(.48539,51.49289,-1.76564),(.48834,51.49702,-1.76404),(.23175,51.60023,-1.94337),(.12353,51.55562,-1.90313),(.43521,51.66868,-1.86962),(.37468,51.54278,-1.47978),(.37533,51.5281,-1.43079),(.40829,51.54001,-1.44643),(.3741,51.51153,-1.37505),(.26083,51.51346,-1.36039),(.44675,51.57118,-1.50057),(.45586,51.60657,-1.59955),(.26268,51.55212,-1.45529),(.11765,51.52066,-1.8507),(.20893,51.46104,-1.73251),(0,51.51705,-1.84369),(.34243,51.38352,-1.56875),(.31499,51.376,-1.53056),(.26543,51.36819,-1.49172),(.12596,51.55042,-1.9008),(.11269,51.47018,-1.72424),(.19662,51.37507,-1.48576),(.19447,51.36645,-1.46309),(.25875,51.49777,-1.34447),(.01609,51.49303,-1.30818),(.12256,51.48913,-1.31815),(.12382,51.50718,-1.33441),(.46346,51.62914,-1.78757),(-.45197,51.38389,-1.62513),(-.45197,51.38407,-1.62602),(-.44591,51.55362,-1.46575),(-.26054,51.66435,-1.71046),(-.35089,51.66682,-1.71593),(-.3008,51.56499,-1.88993),(-.37187,51.3941,-1.61946),(-.31499,51.376,-1.53585),(-.34243,51.38352,-1.57439),(-.41588,51.54543,-1.82564),(-.36814,51.56562,-1.86039),(-.25875,51.49777,-1.34785),(-.12382,51.50718,-1.33605),(-.12256,51.48913,-1.31982),(-.46346,51.62914,-1.79153),(.2365,51.6584,-1.91074),(.43557,51.64925,-1.72449),(.44082,51.64514,-1.7258),(.44182,51.61336,-1.88888),(.44591,51.55362,-1.46093),(.26054,51.66435,-1.70817),(.35089,51.66682,-1.71302),(.41588,51.54543,-1.82099),(.23307,51.5946,-1.94135),(.37187,51.3941,-1.6135),(.25995,51.49193,-1.34242),(.35915,51.45642,-1.38041),(.37661,51.50679,-1.37327),(.24615,51.44383,-1.34842),(.47208,51.555,-1.64054),(.45079,51.56857,-1.50188),(.45798,51.508,-1.53893),(.46085,51.60662,-1.60792),(.33281,51.6653,-1.91713),(.42259,51.68824,-1.8532),(.33824,51.68743,-1.89467),(.10271,51.37956,-1.4805),(0,51.42528,-1.60046),(.10703,51.42044,-1.6044),(0,51.39071,-1.47366),(.21266,51.34555,-1.38807),(.31207,51.35561,-1.41997),(0,51.47062,-1.72213),(.42145,51.49592,-1.77248),(.41527,51.36507,-1.5362),(.487,51.5516,-1.82626),(.45646,51.61022,-1.60518),(.11606,51.43708,-1.32415),(.12189,51.48273,-1.31635),(0,51.43929,-1.31527),(.46127,51.60735,-1.60938),(.46273,51.59871,-1.73722),(.4769,51.57189,-1.65787),(.33843,51.40463,-1.39534),(.38611,51.36467,-1.47637),(.40675,51.41845,-1.45416),(.31471,51.35852,-1.41462),(.47488,51.44864,-1.7137),(.45838,51.4442,-1.57926),(.47693,51.50007,-1.67714),(.47935,51.54676,-1.75044),(.4573,51.49552,-1.51168),(.45798,51.43768,-1.56547),(.2308,51.39345,-1.36274),(.41762,51.68988,-1.84858),(.43886,51.60751,-1.88866),(.32052,51.60354,-1.94663),(.44193,51.66054,-1.77109),(.41975,51.36769,-1.53312),(.38178,51.36189,-1.48008),(0,51.34248,-1.35317),(.10087,51.34612,-1.36191),(-.25995,51.49193,-1.34586),(-.12189,51.48273,-1.31803),(-.37661,51.50679,-1.37791),(-.41975,51.36769,-1.53998),(-.41527,51.36507,-1.54303),(-.45646,51.61022,-1.60944),(-.46127,51.60735,-1.6137),(-.32052,51.60354,-1.94971),(-.33824,51.68743,-1.89714),(0,51.59958,-1.87012),(-.2308,51.39345,-1.36648),(-.11606,51.43708,-1.32591),(-.24615,51.44383,-1.35203),(-.10869,51.38914,-1.34195),(-.43556,51.47911,-1.46155),(-.45798,51.43768,-1.57196),(-.43025,51.42068,-1.49987),(-.4573,51.49552,-1.51739),(-.47935,51.54676,-1.75564),(-.4769,51.57189,-1.66277),(-.46273,51.59871,-1.74163),(-.48656,51.53282,-1.71646),(-.47693,51.50007,-1.683),(-.47488,51.44864,-1.72021),(-.40675,51.41845,-1.4602),(-.38611,51.36467,-1.48276),(-.10087,51.34612,-1.36371),(0,51.38861,-1.33214),(0,51.63407,-1.71496),(0,51.60837,-1.55673),(-.12087,51.64953,-1.70681),(-.42145,51.49592,-1.77782),(-.28319,51.40304,-1.61372),(-.31207,51.35561,-1.4253),(-.38178,51.36189,-1.48644),(-.10271,51.37956,-1.48229),(-.44193,51.66054,-1.77455),(-.42259,51.68824,-1.85613),(-.44977,51.55062,-1.4665),(-.35915,51.45642,-1.38539),(-.45079,51.56857,-1.50659),(-.47208,51.555,-1.64563),(-.45798,51.508,-1.5445),(-.46085,51.60662,-1.61225),(-.33281,51.6653,-1.91975),(-.10703,51.42044,-1.60615),(-.21266,51.34555,-1.39183),(-.20126,51.41184,-1.61026),(-.33843,51.40463,-1.40058),(-.31471,51.35852,-1.41996),(-.45838,51.4442,-1.58567),(.21368,51.34806,-1.38252),(.44977,51.55062,-1.46161),(.10869,51.38914,-1.34014),(.43556,51.47911,-1.4559),(.43025,51.42068,-1.49353),(.48656,51.53282,-1.71099),(.12087,51.64953,-1.70564),(.28319,51.40304,-1.60911),(.20126,51.41184,-1.60696),(.42341,51.47786,-1.43557),(.12737,51.65073,-1.82272),(0,51.63541,-1.82461),(0,51.63495,-1.85106),(0,51.63129,-1.85652),(-.42341,51.47786,-1.44109),(-.21368,51.34806,-1.38629),(-.12737,51.65073,-1.82392)]))),
        Shape(DEF='t2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t2_Geo',coordIndex=[0,1,2,-1,1,3,4,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,14,18,-1,19,20,21,-1,22,23,24,-1,25,26,13,-1,27,8,28,-1,29,30,31,-1,32,33,34,-1,35,36,23,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,45,-1,48,49,50,-1,51,52,53,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,77,90,-1,91,92,93,-1,94,95,96,-1,97,98,99,-1,98,97,100,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,110,111,0,-1,1,4,112,-1,113,114,115,-1,116,117,118,-1,45,119,43,-1,120,121,122,-1,123,124,91,-1,125,126,127,-1,128,129,130,-1,131,132,133,-1,134,135,136,-1,137,138,139,-1,140,141,142,-1,143,144,145,-1,144,146,145,-1,147,148,149,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,162,163,164,-1,162,45,47,-1,165,166,167,-1,168,169,170,-1,113,171,172,-1,171,17,18,-1,173,174,175,-1,175,176,177,-1,178,179,180,-1,181,182,183,-1,184,185,40,-1,186,72,187,-1,79,188,174,-1,76,42,41,-1,91,46,44,-1,189,175,174,-1,190,168,191,-1,192,193,194,-1,195,196,197,-1,198,199,200,-1,201,202,203,-1,204,205,206,-1,207,141,208,-1,209,210,144,-1,211,212,213,-1,159,138,214,-1,212,215,213,-1,186,216,217,-1,82,218,219,-1,218,220,221,-1,81,222,223,-1,204,73,70,-1,85,224,154,-1,142,179,178,-1,225,184,226,-1,227,180,179,-1,88,228,229,-1,230,231,232,-1,233,234,235,-1,236,237,238,-1,239,240,241,-1,176,175,126,-1,92,94,239,-1,242,126,125,-1,177,243,244,-1,36,245,246,-1,247,90,248,-1,197,246,245,-1,249,250,251,-1,252,253,254,-1,255,253,252,-1,172,118,256,-1,257,258,259,-1,150,260,261,-1,262,115,114,-1,263,264,265,-1,156,266,267,-1,268,28,269,-1,270,271,272,-1,273,274,275,-1,276,277,275,-1,278,279,280,-1,281,282,283,-1,284,285,286,-1,287,288,289,-1,290,291,292,-1,293,294,295,-1,296,297,298,-1,299,300,301,-1,302,303,304,-1,305,306,307,-1,308,309,310,-1,311,312,313,-1,314,315,316,-1,317,318,319,-1,320,321,322,-1,323,324,325,-1,326,327,318,-1,328,329,330,-1,331,332,333,-1,334,335,336,-1,337,338,278,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,350,-1,353,354,355,-1,349,356,351,-1,357,358,359,-1,360,355,361,-1,362,363,364,-1,365,364,366,-1,367,368,369,-1,370,371,372,-1,373,374,375,-1,376,377,301,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,383,387,388,-1,389,390,391,-1,392,372,393,-1,394,395,396,-1,328,397,398,-1,399,400,401,-1,402,336,403,-1,403,404,402,-1,405,406,407,-1,408,409,410,-1,411,412,413,-1,414,415,416,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,292,275,274,-1,406,426,337,-1,426,427,428,-1,429,394,430,-1,422,431,432,-1,433,434,435,-1,401,341,436,-1,352,353,437,-1,438,439,357,-1,210,440,441,-1,442,443,444,-1,445,297,446,-1,447,384,448,-1,285,416,415,-1,449,450,451,-1,452,453,454,-1,455,456,457,-1,296,298,458,-1,459,460,452,-1,461,462,463,-1,464,465,466,-1,467,468,469,-1,300,299,470,-1,310,300,470,-1,471,308,470,-1,472,473,474,-1,475,476,477,-1,380,379,478,-1,479,480,276,-1,406,277,407,-1,347,481,482,-1,483,484,485,-1,486,354,481,-1,379,487,480,-1,303,488,489,-1,490,332,331,-1,491,492,493,-1,363,494,495,-1,496,495,497,-1,391,390,498,-1,366,499,500,-1,362,501,502,-1,503,504,505,-1,506,371,507,-1,508,509,510,-1,511,512,513,-1,514,515,413,-1,516,517,419,-1,470,518,519,-1,520,521,522,-1,523,524,525,-1,526,527,528,-1,529,530,314,-1,531,529,532,-1,533,519,534,-1,535,526,536,-1,537,538,539,-1,540,525,541,-1,542,543,523,-1,544,545,546,-1,547,548,384,-1,549,550,390,-1,545,544,551,-1,552,403,397,-1,434,396,395,-1,335,553,434,-1,367,554,555,-1,556,512,511,-1,63,62,374,-1,499,557,498,-1,498,558,391,-1,559,560,561,-1,494,497,495,-1,498,363,558,-1,562,563,490,-1,445,446,564,-1,401,400,565,-1,277,276,480,-1,315,566,567,-1,325,319,568,-1,297,410,298,-1,546,569,570,-1,571,572,573,-1,288,574,575,-1,576,468,577,-1,461,520,462,-1,578,454,579,-1,580,581,582,-1,583,584,580,-1,515,416,285,-1,416,515,514,-1,120,585,586,-1,586,587,120,-1,305,307,588,-1,550,549,448,-1,589,590,591,-1,592,437,593,-1,352,348,350,-1,359,334,594,-1,440,595,421,-1,596,597,279,-1,292,598,275,-1,599,600,601,-1,602,603,280,-1,354,486,355,-1,429,604,605,-1,412,329,413,-1,606,607,608,-1,584,583,609,-1,610,284,611,-1,402,404,428,-1,612,613,614,-1,394,396,433,-1,615,616,617,-1,389,333,390,-1,346,391,558,-1,618,564,619,-1,620,549,332,-1,545,621,588,-1,545,588,546,-1,619,304,303,-1,408,622,378,-1,321,623,624,-1,625,377,626,-1,572,300,310,-1,370,615,371,-1,627,362,364,-1,628,629,436,-1,209,630,210,-1,349,339,356,-1,354,353,352,-1,356,339,345,-1,346,492,491,-1,631,343,342,-1,343,632,633,-1,344,634,635,-1,362,494,363,-1,601,636,277,-1,399,594,334,-1,331,333,565,-1,399,428,427,-1,567,637,638,-1,475,319,325,-1,639,315,314,-1,313,306,640,-1,641,642,643,-1,644,645,643,-1,646,647,648,-1,301,518,299,-1,296,648,297,-1,273,649,650,-1,651,295,424,-1,424,451,425,-1,652,285,613,-1,653,598,292,-1,654,289,637,-1,283,282,655,-1,521,525,540,-1,656,107,30,-1,151,250,249,-1,657,153,155,-1,151,85,84,-1,658,157,659,-1,660,661,662,-1,663,18,16,-1,101,664,665,-1,666,663,259,-1,667,668,36,-1,175,127,126,-1,669,670,671,-1,672,673,674,-1,675,240,239,-1,676,677,231,-1,678,679,192,-1,234,233,680,-1,681,682,676,-1,683,163,162,-1,226,184,42,-1,659,684,685,-1,686,687,688,-1,217,215,689,-1,207,690,691,-1,692,139,138,-1,214,693,160,-1,139,692,212,-1,54,694,695,-1,54,53,694,-1,696,697,61,-1,698,699,202,-1,197,196,700,-1,701,99,702,-1,703,704,191,-1,705,706,707,-1,708,709,39,-1,130,129,710,-1,705,226,75,-1,185,216,187,-1,711,712,713,-1,163,683,714,-1,715,267,716,-1,179,142,717,-1,718,178,48,-1,178,719,48,-1,720,721,722,-1,190,89,723,-1,164,724,265,-1,43,119,725,-1,725,726,43,-1,727,728,419,-1,690,211,691,-1,729,730,731,-1,732,733,145,-1,734,735,265,-1,251,662,661,-1,153,657,158,-1,736,737,156,-1,250,151,150,-1,722,684,738,-1,180,227,738,-1,739,182,181,-1,145,740,741,-1,52,742,53,-1,717,142,141,-1,138,137,214,-1,695,743,744,-1,144,210,146,-1,745,729,746,-1,90,77,248,-1,709,747,39,-1,748,749,750,-1,119,663,16,-1,255,117,116,-1,2,751,0,-1,29,7,656,-1,752,753,754,-1,103,102,755,-1,756,757,758,-1,756,247,757,-1,664,759,760,-1,760,761,762,-1,763,764,765,-1,110,766,767,-1,768,769,770,-1,771,772,773,-1,199,671,668,-1,667,199,668,-1,96,668,671,-1,774,232,775,-1,776,231,170,-1,704,777,778,-1,779,84,83,-1,85,722,721,-1,704,83,780,-1,189,781,674,-1,76,75,42,-1,782,217,216,-1,72,783,70,-1,784,72,186,-1,40,187,71,-1,204,70,69,-1,785,786,787,-1,788,789,203,-1,790,697,696,-1,162,735,734,-1,269,791,792,-1,793,794,517,-1,795,35,23,-1,23,668,24,-1,796,109,791,-1,107,109,796,-1,19,797,237,-1,798,799,611,-1,14,611,286,-1,12,539,800,-1,801,524,523,-1,5,543,6,-1,802,582,581,-1,582,454,453,-1,802,581,3,-1,543,803,6,-1,801,523,9,-1,12,528,539,-1,14,286,15,-1,798,611,14,-1,804,7,6,-1,236,19,237,-1,805,25,806,-1,25,13,806,-1,796,791,269,-1,23,36,668,-1,794,419,517,-1,807,269,792,-1,734,45,162,-1,790,696,56,-1,788,203,699,-1,785,808,786,-1,204,69,809,-1,810,811,812,-1,812,813,810,-1,71,128,40,-1,784,783,72,-1,73,72,70,-1,782,216,185,-1,75,226,42,-1,704,778,83,-1,687,814,688,-1,721,815,85,-1,83,778,779,-1,704,703,777,-1,231,677,170,-1,96,95,668,-1,667,200,199,-1,106,771,773,-1,768,770,816,-1,108,110,767,-1,763,765,751,-1,760,759,761,-1,664,103,759,-1,103,755,758,-1,817,102,101,-1,818,819,169,-1,656,30,29,-1,2,763,751,-1,255,820,117,-1,119,16,725,-1,748,61,749,-1,747,130,39,-1,77,173,248,-1,210,441,146,-1,695,744,208,-1,717,141,821,-1,52,183,742,-1,145,733,740,-1,739,822,182,-1,180,738,823,-1,150,824,250,-1,736,825,737,-1,251,661,252,-1,145,146,732,-1,727,419,794,-1,164,265,735,-1,168,190,723,-1,722,738,720,-1,717,826,179,-1,715,716,263,-1,163,714,827,-1,181,52,51,-1,711,698,712,-1,185,187,40,-1,75,706,705,-1,39,130,710,-1,38,708,39,-1,46,91,124,-1,707,828,705,-1,174,74,781,-1,174,188,74,-1,703,191,678,-1,195,197,245,-1,702,829,701,-1,700,246,197,-1,698,202,830,-1,61,60,696,-1,204,831,73,-1,693,832,160,-1,695,140,54,-1,211,139,212,-1,214,160,159,-1,833,692,138,-1,134,139,211,-1,217,689,186,-1,82,223,218,-1,213,821,691,-1,659,823,684,-1,55,834,718,-1,834,178,718,-1,229,817,101,-1,682,192,676,-1,835,234,680,-1,231,230,676,-1,233,235,87,-1,87,237,233,-1,239,836,675,-1,671,199,669,-1,837,93,838,-1,175,189,127,-1,667,246,200,-1,247,756,90,-1,254,253,839,-1,824,150,261,-1,664,840,665,-1,663,666,18,-1,841,264,842,-1,157,148,659,-1,84,152,151,-1,657,155,843,-1,249,224,151,-1,228,88,235,-1,844,461,845,-1,540,846,521,-1,540,537,846,-1,277,636,275,-1,655,847,283,-1,848,583,849,-1,292,291,653,-1,285,614,613,-1,609,850,851,-1,424,294,451,-1,295,294,424,-1,650,274,273,-1,377,852,301,-1,648,647,297,-1,301,852,518,-1,648,853,646,-1,643,642,644,-1,854,313,569,-1,643,304,641,-1,640,855,313,-1,314,530,639,-1,324,316,474,-1,474,325,324,-1,325,474,475,-1,427,400,399,-1,856,331,565,-1,334,402,399,-1,277,857,601,-1,338,337,426,-1,344,635,342,-1,858,859,483,-1,342,860,631,-1,631,632,343,-1,344,496,634,-1,352,482,354,-1,349,340,339,-1,630,440,210,-1,500,499,861,-1,365,627,364,-1,615,507,371,-1,572,571,300,-1,626,862,625,-1,624,326,321,-1,622,863,378,-1,619,303,489,-1,490,620,332,-1,564,446,619,-1,346,491,391,-1,333,332,390,-1,864,615,617,-1,433,430,394,-1,428,399,402,-1,646,641,304,-1,304,619,446,-1,610,611,799,-1,584,609,610,-1,865,866,606,-1,329,867,514,-1,412,330,329,-1,604,386,605,-1,861,499,868,-1,602,869,603,-1,599,870,600,-1,596,552,597,-1,431,595,358,-1,431,422,595,-1,595,422,421,-1,594,436,359,-1,352,437,348,-1,592,348,437,-1,589,871,590,-1,872,550,448,-1,645,302,643,-1,305,588,873,-1,873,874,305,-1,514,551,416,-1,583,580,849,-1,453,580,582,-1,845,578,579,-1,461,272,520,-1,468,467,577,-1,289,288,575,-1,463,875,459,-1,876,571,573,-1,546,570,471,-1,588,307,854,-1,297,445,410,-1,568,877,325,-1,567,316,315,-1,878,409,879,-1,277,480,880,-1,493,401,565,-1,860,342,635,-1,564,881,445,-1,490,387,562,-1,498,557,363,-1,494,502,497,-1,559,561,882,-1,498,550,499,-1,63,374,883,-1,556,884,512,-1,367,513,554,-1,434,395,335,-1,552,397,885,-1,551,514,545,-1,390,332,549,-1,547,384,604,-1,886,519,518,-1,546,887,544,-1,542,271,543,-1,525,524,541,-1,539,527,537,-1,526,528,536,-1,533,534,888,-1,529,889,532,-1,314,889,529,-1,624,532,326,-1,624,531,532,-1,527,539,528,-1,525,542,523,-1,272,890,520,-1,520,890,521,-1,519,533,470,-1,891,519,886,-1,418,516,419,-1,514,413,329,-1,511,513,367,-1,507,892,506,-1,505,893,503,-1,502,494,362,-1,366,557,499,-1,390,550,498,-1,496,497,634,-1,558,363,495,-1,493,389,491,-1,331,387,490,-1,480,478,379,-1,354,482,481,-1,351,347,482,-1,277,880,407,-1,479,478,480,-1,478,894,380,-1,477,317,475,-1,471,570,308,-1,470,308,310,-1,895,467,469,-1,466,896,464,-1,845,461,463,-1,452,578,459,-1,298,897,458,-1,898,289,575,-1,878,879,899,-1,452,454,578,-1,451,900,449,-1,415,286,285,-1,447,385,384,-1,297,647,446,-1,440,421,441,-1,357,629,438,-1,594,401,436,-1,433,396,434,-1,432,901,422,-1,430,902,429,-1,428,338,426,-1,292,274,290,-1,870,603,903,-1,423,650,424,-1,847,413,515,-1,420,422,901,-1,444,904,905,-1,906,340,349,-1,419,728,417,-1,416,551,414,-1,411,413,847,-1,622,408,410,-1,405,426,406,-1,401,594,399,-1,328,330,397,-1,393,907,392,-1,391,491,389,-1,387,331,388,-1,386,604,384,-1,621,873,588,-1,381,383,388,-1,380,320,378,-1,625,852,377,-1,908,909,910,-1,910,644,908,-1,376,626,377,-1,373,375,911,-1,372,912,370,-1,369,511,367,-1,913,365,366,-1,553,358,434,-1,358,553,359,-1,351,350,349,-1,355,360,353,-1,351,482,352,-1,628,340,906,-1,345,492,346,-1,859,484,483,-1,278,857,337,-1,336,402,334,-1,637,289,898,-1,318,321,326,-1,325,877,323,-1,475,317,319,-1,324,314,316,-1,311,313,855,-1,914,488,915,-1,308,916,309,-1,304,643,302,-1,299,518,470,-1,284,614,285,-1,289,654,287,-1,284,286,611,-1,917,423,425,-1,280,599,278,-1,275,598,276,-1,273,275,636,-1,638,316,567,-1,918,110,108,-1,268,269,807,-1,268,807,919,-1,85,151,224,-1,156,267,736,-1,263,842,264,-1,665,229,101,-1,150,152,260,-1,663,257,259,-1,252,661,255,-1,254,920,252,-1,921,249,251,-1,244,247,248,-1,246,667,36,-1,177,244,248,-1,829,242,125,-1,176,126,242,-1,239,241,838,-1,237,87,238,-1,234,232,235,-1,232,234,230,-1,227,179,826,-1,226,922,225,-1,834,142,178,-1,685,85,154,-1,823,738,684,-1,223,82,81,-1,923,687,686,-1,82,219,80,-1,218,221,219,-1,223,222,784,-1,159,833,138,-1,213,691,211,-1,144,924,209,-1,812,925,813,-1,206,831,204,-1,202,699,203,-1,198,100,199,-1,195,926,196,-1,192,682,193,-1,191,927,190,-1,174,781,189,-1,44,32,91,-1,928,76,41,-1,174,173,79,-1,187,216,186,-1,40,42,184,-1,181,183,52,-1,929,259,258,-1,178,180,719,-1,18,666,171,-1,172,114,113,-1,168,723,169,-1,164,735,162,-1,925,930,813,-1,156,737,157,-1,153,658,154,-1,149,49,147,-1,140,142,834,-1,137,139,134,-1,134,136,137,-1,133,931,131,-1,130,41,128,-1,120,587,121,-1,45,734,119,-1,663,119,734,-1,116,118,929,-1,113,115,112,-1,112,2,1,-1,751,110,0,-1,108,767,109,-1,106,773,104,-1,664,101,103,-1,766,765,932,-1,198,98,100,-1,97,99,701,-1,94,32,95,-1,90,756,89,-1,234,835,230,-1,835,933,230,-1,87,235,88,-1,818,169,723,-1,85,815,83,-1,77,79,173,-1,74,76,934,-1,810,71,73,-1,70,783,68,-1,65,935,66,-1,71,187,72,-1,62,64,936,-1,59,61,748,-1,56,696,57,-1,55,51,53,-1,48,50,827,-1,45,44,46,-1,43,33,44,-1,40,128,41,-1,39,710,37,-1,32,44,33,-1,31,10,29,-1,28,268,27,-1,26,11,13,-1,24,937,22,-1,21,797,19,-1,803,938,6,-1,17,798,14,-1,16,18,14,-1,11,939,12,-1,8,801,9,-1,29,5,7,-1,1,802,3,-1,0,940,941,-1,111,940,0,-1,10,5,29,-1,10,9,5,-1,942,943,944,-1,943,942,27,-1,806,12,800,-1,13,12,806,-1,945,946,947,-1,946,945,948,-1,937,949,22,-1,937,950,949,-1,951,952,953,-1,952,951,954,-1,726,955,956,-1,726,957,955,-1,725,15,958,-1,16,15,725,-1,941,1,0,-1,802,1,941,-1,133,744,740,-1,133,959,744,-1,168,678,191,-1,168,679,678,-1,946,960,795,-1,960,946,948,-1,961,109,767,-1,961,791,109,-1,930,128,813,-1,128,930,129,-1,822,793,182,-1,822,794,793,-1,962,963,964,-1,965,963,962,-1,205,966,206,-1,967,966,205,-1,968,964,963,-1,969,964,968,-1,201,968,202,-1,201,970,968,-1,971,808,972,-1,808,971,786,-1,973,974,975,-1,973,976,974,-1,977,809,69,-1,809,977,978,-1,813,71,810,-1,128,71,813,-1,975,979,973,-1,980,979,975,-1,981,935,982,-1,980,935,981,-1,977,65,67,-1,977,983,65,-1,184,782,185,-1,184,225,782,-1,704,927,191,-1,704,780,927,-1,687,984,814,-1,687,985,984,-1,215,692,689,-1,212,692,215,-1,779,777,238,-1,777,779,778,-1,231,775,232,-1,775,231,776,-1,757,244,754,-1,757,247,244,-1,673,167,127,-1,673,986,167,-1,987,988,989,-1,987,990,988,-1,988,767,766,-1,988,961,767,-1,991,195,992,-1,993,195,991,-1,816,994,753,-1,770,994,816,-1,991,764,995,-1,996,764,991,-1,765,110,751,-1,765,766,110,-1,262,769,997,-1,256,769,262,-1,753,761,754,-1,753,994,761,-1,757,103,758,-1,757,759,103,-1,998,102,817,-1,998,755,102,-1,774,998,817,-1,774,775,998,-1,666,929,171,-1,259,929,666,-1,734,257,663,-1,734,999,257,-1,1000,731,730,-1,122,731,1000,-1,745,220,832,-1,745,746,220,-1,732,1001,733,-1,732,1002,1001,-1,140,55,54,-1,834,55,140,-1,147,180,823,-1,147,719,180,-1,254,1003,920,-1,1003,254,716,-1,661,820,255,-1,661,1004,820,-1,1005,661,660,-1,1005,1004,661,-1,148,823,659,-1,148,147,823,-1,832,931,745,-1,131,931,832,-1,1006,1007,1008,-1,1006,1009,1007,-1,46,1010,47,-1,46,708,1010,-1,258,116,929,-1,258,839,116,-1,827,164,163,-1,164,827,50,-1,793,1011,1012,-1,793,517,1011,-1,712,1013,713,-1,712,1014,1013,-1,785,1015,1016,-1,785,787,1015,-1,123,709,124,-1,123,747,709,-1,32,92,91,-1,32,94,92,-1,78,707,79,-1,78,1017,707,-1,710,930,1008,-1,710,129,930,-1,104,752,243,-1,752,104,773,-1,1018,59,748,-1,59,1018,965,-1,698,1019,712,-1,830,1019,698,-1,786,1020,1021,-1,1020,786,971,-1,749,697,1022,-1,697,749,61,-1,711,1023,788,-1,967,1023,711,-1,785,1024,808,-1,785,1025,1024,-1,790,1006,925,-1,790,56,1006,-1,1026,978,1027,-1,1026,809,978,-1,976,1028,974,-1,1029,1028,976,-1,208,140,695,-1,141,140,208,-1,693,131,832,-1,693,136,131,-1,121,1030,985,-1,1030,121,587,-1,186,1031,784,-1,186,689,1031,-1,230,681,676,-1,681,230,933,-1,235,774,228,-1,232,774,235,-1,703,1032,777,-1,194,1032,703,-1,166,1033,125,-1,165,1033,166,-1,97,1033,1034,-1,97,701,1033,-1,96,239,94,-1,836,239,96,-1,105,1035,702,-1,105,104,1035,-1,246,198,200,-1,246,700,198,-1,664,1005,840,-1,664,760,1005,-1,256,117,1036,-1,256,118,117,-1,148,737,149,-1,148,157,737,-1,1003,657,843,-1,266,657,1003,-1,154,249,155,-1,249,154,224,-1,960,990,987,-1,960,26,990,-1,107,31,30,-1,31,107,796,-1,461,270,272,-1,461,844,270,-1,527,846,537,-1,527,1037,846,-1,870,1038,600,-1,870,903,1038,-1,597,1039,602,-1,597,1040,1039,-1,567,598,653,-1,567,566,598,-1,1041,450,449,-1,1041,1042,450,-1,649,424,650,-1,649,651,424,-1,1043,613,293,-1,1043,652,613,-1,876,376,571,-1,895,376,876,-1,576,646,853,-1,1044,646,576,-1,313,307,306,-1,313,854,307,-1,572,1045,573,-1,1046,1045,572,-1,915,1047,1048,-1,915,866,1047,-1,639,1049,894,-1,530,1049,639,-1,322,477,408,-1,317,477,322,-1,343,486,344,-1,355,486,343,-1,492,339,341,-1,492,345,339,-1,361,343,633,-1,361,355,343,-1,628,1050,629,-1,1050,628,906,-1,1051,1052,1053,-1,1051,1054,1052,-1,861,884,500,-1,512,884,861,-1,504,1055,1056,-1,504,972,1055,-1,506,1057,1058,-1,1057,506,892,-1,556,1059,1060,-1,556,1061,1059,-1,893,1062,503,-1,893,617,1062,-1,509,392,1063,-1,509,508,392,-1,1064,1065,1066,-1,1064,1067,1065,-1,626,1068,862,-1,1068,626,469,-1,439,358,357,-1,431,358,439,-1,1069,622,881,-1,622,1069,863,-1,427,405,856,-1,426,405,427,-1,872,384,548,-1,448,384,872,-1,488,562,489,-1,488,563,562,-1,914,563,488,-1,1070,1071,1054,-1,1070,1072,1071,-1,1058,1051,1073,-1,1051,1058,1057,-1,618,387,383,-1,562,387,618,-1,899,477,476,-1,477,899,879,-1,549,447,448,-1,620,447,549,-1,861,1074,1075,-1,861,868,1074,-1,901,1076,1077,-1,432,1076,901,-1,605,329,328,-1,867,329,605,-1,515,283,847,-1,515,1043,283,-1,291,654,653,-1,654,291,287,-1,1038,651,649,-1,651,1038,1066,-1,1078,602,1039,-1,1078,869,602,-1,404,552,596,-1,552,404,403,-1,591,432,589,-1,432,591,1076,-1,1079,443,633,-1,443,1079,444,-1,1080,120,1081,-1,1080,585,120,-1,586,904,1082,-1,586,585,904,-1,1083,580,584,-1,580,1083,581,-1,845,938,844,-1,845,579,938,-1,642,908,644,-1,1044,908,642,-1,1084,878,899,-1,878,1084,1085,-1,574,1085,575,-1,574,897,1085,-1,1086,1087,1088,-1,1087,1086,1089,-1,465,1041,850,-1,464,1041,465,-1,459,1090,460,-1,459,875,1090,-1,1068,455,896,-1,456,455,1068,-1,1090,1091,1092,-1,1091,1090,1093,-1,852,1091,1094,-1,852,625,1091,-1,1095,1096,1097,-1,1095,1098,1096,-1,865,1099,311,-1,1099,865,1100,-1,1046,1101,1045,-1,1046,1102,1101,-1,410,878,298,-1,878,410,409,-1,635,484,860,-1,1103,484,635,-1,1104,502,1105,-1,1104,497,502,-1,560,1106,1103,-1,1106,560,559,-1,1106,1107,485,-1,1106,1108,1107,-1,558,496,346,-1,495,496,558,-1,1109,1110,882,-1,1109,1111,1110,-1,1020,1112,1113,-1,1020,1062,1112,-1,1114,1115,1116,-1,1114,1117,1115,-1,1118,1073,627,-1,1058,1073,1118,-1,1119,1120,510,-1,1119,911,1120,-1,883,373,368,-1,883,374,373,-1,1121,555,554,-1,1122,555,1121,-1,521,1037,522,-1,521,846,1037,-1,604,902,547,-1,429,902,604,-1,1123,563,914,-1,1123,1124,563,-1,547,1125,548,-1,417,1125,547,-1,471,887,546,-1,471,1126,887,-1,537,541,538,-1,537,540,541,-1,1127,519,891,-1,519,1127,534,-1,887,1128,544,-1,887,1129,1128,-1,1049,624,623,-1,624,1049,531,-1,320,408,378,-1,322,408,320,-1,1130,1127,891,-1,1130,1131,1127,-1,533,471,470,-1,533,1126,471,-1,1125,728,1132,-1,728,1125,417,-1,1124,490,563,-1,620,490,1124,-1,522,1096,1098,-1,1037,1096,522,-1,1120,375,1116,-1,1120,911,375,-1,1133,627,365,-1,1133,1118,627,-1,1116,1134,1120,-1,1116,1115,1134,-1,1134,615,370,-1,615,1134,616,-1,504,971,972,-1,504,503,971,-1,1111,973,1110,-1,973,1111,976,-1,501,1105,502,-1,501,1053,1105,-1,1108,1135,1107,-1,1135,1108,1136,-1,485,1103,1106,-1,485,484,1103,-1,635,497,1104,-1,635,634,497,-1,381,1069,382,-1,1137,1069,381,-1,1137,480,487,-1,1137,880,480,-1,632,859,858,-1,632,631,859,-1,593,353,360,-1,593,437,353,-1,894,479,639,-1,894,478,479,-1,473,475,474,-1,473,476,475,-1,1100,1046,309,-1,1100,1102,1046,-1,312,1099,916,-1,312,311,1099,-1,376,469,626,-1,376,895,469,-1,1095,1138,1139,-1,1138,1095,1097,-1,462,1095,463,-1,1098,1095,462,-1,625,1092,1091,-1,625,1140,1092,-1,1141,896,455,-1,1141,464,896,-1,460,1092,1142,-1,460,1090,1092,-1,845,459,578,-1,463,459,845,-1,465,848,1143,-1,465,850,848,-1,1089,455,457,-1,1141,455,1089,-1,574,458,897,-1,458,574,1087,-1,575,1084,898,-1,1085,1084,575,-1,1084,472,898,-1,473,472,1084,-1,851,900,612,-1,449,900,851,-1,607,302,645,-1,607,606,302,-1,1080,1144,1145,-1,1144,1080,1081,-1,1082,444,1079,-1,904,444,1082,-1,420,441,421,-1,441,420,1146,-1,438,589,432,-1,438,1147,589,-1,335,359,553,-1,335,334,359,-1,428,596,338,-1,596,428,404,-1,1066,295,651,-1,1066,1065,295,-1,450,425,451,-1,1148,425,450,-1,425,1149,917,-1,1148,1149,425,-1,338,279,278,-1,596,279,338,-1,591,361,442,-1,591,590,361,-1,1150,1075,1074,-1,1151,1075,1150,-1,605,621,867,-1,621,605,386,-1,608,865,606,-1,608,1101,865,-1,856,388,331,-1,405,388,856,-1,446,646,304,-1,446,647,646,-1,336,397,403,-1,336,398,397,-1,328,395,394,-1,328,398,395,-1,1057,1054,1051,-1,1054,1057,1070,-1,1152,505,1153,-1,893,505,1152,-1,385,874,873,-1,874,385,447,-1,382,881,564,-1,881,382,1069,-1,868,548,1074,-1,548,868,872,-1,456,576,853,-1,456,468,576,-1,373,1119,1154,-1,373,911,1119,-1,508,372,392,-1,508,912,372,-1,1020,503,1062,-1,1020,971,503,-1,511,1061,556,-1,511,369,1061,-1,1058,393,506,-1,1058,1118,393,-1,1056,505,504,-1,505,1056,1072,-1,1075,512,861,-1,513,512,1075,-1,1053,1073,1051,-1,1073,1053,501,-1,1155,976,1111,-1,1155,1029,976,-1,359,629,357,-1,359,436,629,-1,590,360,361,-1,593,360,590,-1,1030,586,1156,-1,1030,587,586,-1,481,346,496,-1,346,481,347,-1,327,319,318,-1,327,568,319,-1,472,316,638,-1,472,474,316,-1,321,317,322,-1,321,318,317,-1,532,327,326,-1,877,327,532,-1,877,568,327,-1,1048,640,306,-1,1048,1047,640,-1,488,302,915,-1,488,303,302,-1,310,1046,572,-1,309,1046,310,-1,306,1123,1048,-1,306,305,1123,-1,895,909,467,-1,895,876,909,-1,1157,886,1094,-1,891,886,1157,-1,900,294,293,-1,900,451,294,-1,290,917,291,-1,290,423,917,-1,1042,1148,450,-1,1042,1086,1148,-1,1158,1040,411,-1,1040,1158,1039,-1,278,601,857,-1,599,601,278,-1,903,1066,1038,-1,903,1064,1066,-1,273,601,600,-1,273,636,601,-1,1097,1130,1138,-1,535,1130,1097,-1,542,272,271,-1,542,890,272,-1,656,108,107,-1,108,656,918,-1,807,805,919,-1,805,807,792,-1,158,266,156,-1,158,657,266,-1,263,724,715,-1,265,724,263,-1,262,172,256,-1,262,114,172,-1,760,1004,1005,-1,760,762,1004,-1,839,842,254,-1,841,842,839,-1,264,839,999,-1,264,841,839,-1,36,1159,245,-1,36,35,1159,-1,106,702,99,-1,106,105,702,-1,987,795,960,-1,987,1160,795,-1,1161,672,1162,-1,672,1161,673,-1,671,836,96,-1,670,836,671,-1,125,701,829,-1,701,125,1033,-1,176,1035,177,-1,176,242,1035,-1,1032,238,777,-1,1032,236,238,-1,170,679,168,-1,170,677,679,-1,662,250,824,-1,250,662,251,-1,80,686,688,-1,80,219,686,-1,923,220,1163,-1,923,221,220,-1,1164,985,687,-1,985,1164,121,-1,131,135,132,-1,131,136,135,-1,742,144,143,-1,742,924,144,-1,974,1165,1166,-1,1028,1165,974,-1,809,205,204,-1,1026,205,809,-1,1167,925,812,-1,1167,790,925,-1,1055,808,1024,-1,972,808,1055,-1,1168,788,1023,-1,1168,789,788,-1,1013,1022,1169,-1,1022,1013,749,-1,1021,787,786,-1,787,1021,1170,-1,712,1171,1014,-1,1019,1171,712,-1,965,936,59,-1,936,965,962,-1,1172,196,926,-1,1172,772,196,-1,694,743,695,-1,694,741,743,-1,190,1017,78,-1,190,927,1017,-1,720,227,922,-1,720,738,227,-1,1162,123,837,-1,123,1162,1173,-1,828,720,705,-1,828,721,720,-1,1016,203,789,-1,203,1016,1015,-1,182,1012,183,-1,182,793,1012,-1,75,188,706,-1,75,74,188,-1,170,819,776,-1,170,169,819,-1,1009,1174,1007,-1,1009,1175,1174,-1,152,779,86,-1,152,84,779,-1,842,716,254,-1,842,263,716,-1,49,719,147,-1,49,48,719,-1,740,931,133,-1,740,1176,931,-1,746,1163,220,-1,746,729,1163,-1,120,1000,1081,-1,1000,120,122,-1,929,172,171,-1,929,118,172,-1,115,2,112,-1,115,763,2,-1,702,242,829,-1,702,1035,242,-1,818,998,819,-1,818,755,998,-1,1036,769,256,-1,1036,770,769,-1,996,765,764,-1,932,765,996,-1,753,1172,816,-1,753,752,1172,-1,992,996,991,-1,992,1177,996,-1,992,245,1159,-1,195,245,992,-1,1178,988,990,-1,988,1178,961,-1,1179,1180,675,-1,1179,1181,1180,-1,1182,1183,1034,-1,1184,1183,1182,-1,818,89,756,-1,818,723,89,-1,689,833,1031,-1,689,692,833,-1,1030,984,985,-1,1030,1135,984,-1,833,161,1031,-1,159,161,833,-1,783,222,68,-1,783,784,222,-1,983,1185,65,-1,983,81,1185,-1,66,980,975,-1,66,935,980,-1,979,981,1136,-1,981,979,980,-1,67,978,977,-1,67,1186,978,-1,1029,1024,1028,-1,1029,1055,1024,-1,970,969,968,-1,970,1187,969,-1,202,963,830,-1,968,963,202,-1,1169,206,966,-1,1188,206,1169,-1,1189,1019,1018,-1,1189,1171,1019,-1,59,64,60,-1,936,64,59,-1,57,1121,58,-1,57,1122,1121,-1,726,33,43,-1,33,726,956,-1,1012,209,924,-1,209,1012,1011,-1,1007,1132,1190,-1,1174,1132,1007,-1,27,919,943,-1,268,919,27,-1,948,26,960,-1,26,948,11,-1,954,24,1191,-1,24,954,937,-1,21,193,682,-1,20,193,21,-1,431,438,432,-1,431,439,438,-1,582,941,454,-1,582,802,941,-1,15,415,958,-1,15,286,415,-1,955,414,1128,-1,957,414,955,-1,1129,951,953,-1,1129,1192,951,-1,949,888,534,-1,950,888,949,-1,1127,945,947,-1,1127,1131,945,-1,528,939,536,-1,939,528,12,-1,538,942,944,-1,538,541,942,-1,5,523,543,-1,9,523,5,-1,940,454,941,-1,940,579,454,-1,579,6,938,-1,6,579,940,-1,1193,581,1083,-1,3,581,1193,-1,541,801,942,-1,541,524,801,-1,538,800,539,-1,800,538,944,-1,1131,939,945,-1,1131,536,939,-1,947,534,1127,-1,949,534,947,-1,950,1192,888,-1,951,1192,950,-1,953,1128,1129,-1,955,1128,953,-1,414,958,415,-1,958,414,957,-1,798,1083,799,-1,1193,1083,798,-1,193,1032,194,-1,193,20,1032,-1,956,34,33,-1,34,956,952,-1,23,946,795,-1,23,22,946,-1,10,28,8,-1,31,28,10,-1,34,95,32,-1,1191,95,34,-1,1190,37,710,-1,1190,727,37,-1,934,1162,672,-1,1173,1162,934,-1,822,38,37,-1,822,739,38,-1,714,55,718,-1,55,714,51,-1,1169,1167,1188,-1,1169,1022,1167,-1,964,1194,962,-1,964,1114,1194,-1,965,830,963,-1,1018,830,965,-1,1019,830,1018,-1,1026,967,205,-1,1026,1023,967,-1,969,1114,964,-1,1117,1114,969,-1,1187,1020,1113,-1,1020,1187,1021,-1,975,1166,66,-1,1166,975,974,-1,984,982,814,-1,982,984,981,-1,982,65,1185,-1,982,935,65,-1,69,983,977,-1,68,983,69,-1,1195,721,828,-1,1195,815,721,-1,927,1195,1017,-1,927,780,1195,-1,688,81,80,-1,688,1185,81,-1,782,821,217,-1,782,717,821,-1,86,238,87,-1,86,779,238,-1,89,78,77,-1,78,89,190,-1,1196,1180,986,-1,1196,675,1180,-1,241,675,1196,-1,241,240,675,-1,1181,670,669,-1,670,1181,1179,-1,165,1034,1033,-1,1182,1034,165,-1,1160,989,1177,-1,1160,987,989,-1,989,766,932,-1,989,988,766,-1,195,768,926,-1,768,195,993,-1,993,995,997,-1,991,995,993,-1,115,997,995,-1,262,997,115,-1,1197,761,994,-1,762,761,1197,-1,244,752,754,-1,244,243,752,-1,804,110,918,-1,110,804,111,-1,112,1198,113,-1,112,4,1198,-1,731,121,1164,-1,122,121,731,-1,730,1002,1000,-1,1002,730,1001,-1,1176,745,931,-1,745,1176,729,-1,1146,1002,732,-1,1146,1144,1002,-1,132,959,133,-1,132,1199,959,-1,183,924,742,-1,183,1012,924,-1,49,1200,50,-1,1200,49,149,-1,658,158,157,-1,158,658,153,-1,920,843,921,-1,920,1003,843,-1,665,261,260,-1,665,840,261,-1,264,734,265,-1,264,999,734,-1,162,1010,683,-1,162,47,1010,-1,1176,733,1001,-1,1176,740,733,-1,1008,925,1006,-1,925,1008,930,-1,747,41,130,-1,747,928,41,-1,1184,1180,1181,-1,1184,1182,1180,-1,113,17,171,-1,113,1198,17,-1,685,722,85,-1,722,685,684,-1,1027,1023,1026,-1,1027,1168,1023,-1,1165,1201,1202,-1,1201,1165,1025,-1,74,674,781,-1,934,674,74,-1,934,672,674,-1,135,211,690,-1,211,135,134,-1,716,266,1003,-1,267,266,716,-1,1189,748,750,-1,748,1189,1018,-1,1015,201,203,-1,1015,1203,201,-1,63,57,64,-1,1122,57,63,-1,967,713,966,-1,711,713,967,-1,1025,1016,1201,-1,785,1016,1025,-1,58,1006,56,-1,58,1009,1006,-1,1188,831,206,-1,1188,811,831,-1,1186,1027,978,-1,1202,1027,1186,-1,1199,207,208,-1,1199,690,207,-1,218,832,220,-1,160,832,218,-1,213,217,821,-1,217,213,215,-1,161,218,223,-1,161,160,218,-1,922,826,225,-1,922,227,826,-1,817,228,774,-1,817,229,228,-1,678,194,703,-1,678,192,194,-1,1196,673,1161,-1,986,673,1196,-1,1034,100,97,-1,1034,1183,100,-1,93,239,838,-1,239,93,92,-1,177,104,243,-1,177,1035,104,-1,700,98,198,-1,700,771,98,-1,258,999,839,-1,258,257,999,-1,252,921,251,-1,920,921,252,-1,820,1036,117,-1,1197,1036,820,-1,152,88,260,-1,88,152,86,-1,825,149,737,-1,1200,149,825,-1,990,25,1178,-1,26,25,990,-1,796,28,31,-1,28,796,269,-1,527,1096,1037,-1,527,526,1096,-1,1078,1064,869,-1,1064,1078,1067,-1,602,279,597,-1,279,602,280,-1,449,850,1041,-1,850,449,851,-1,1149,288,287,-1,1088,288,1149,-1,571,301,300,-1,376,301,571,-1,1044,577,908,-1,576,577,1044,-1,313,570,569,-1,313,312,570,-1,1204,573,1045,-1,910,573,1204,-1,1204,607,645,-1,1204,608,607,-1,1049,380,894,-1,1049,623,380,-1,323,314,324,-1,323,889,314,-1,889,877,532,-1,323,877,889,-1,344,481,496,-1,486,481,344,-1,341,628,436,-1,341,340,628,-1,483,1079,858,-1,483,1082,1079,-1,871,906,592,-1,871,1050,906,-1,434,595,435,-1,434,358,595,-1,1054,1109,1052,-1,1054,1071,1109,-1,500,913,366,-1,884,913,500,-1,1151,1121,554,-1,1121,1151,1175,-1,892,1070,1057,-1,1070,892,1153,-1,1059,1133,1060,-1,1133,1059,907,-1,367,883,368,-1,367,555,883,-1,864,893,1152,-1,893,864,617,-1,1205,509,1063,-1,510,509,1205,-1,62,375,374,-1,62,1194,375,-1,469,456,1068,-1,456,469,468,-1,1050,438,629,-1,438,1050,1147,-1,564,383,382,-1,564,618,383,-1,854,546,588,-1,854,569,546,-1,386,873,621,-1,386,385,873,-1,620,874,447,-1,620,1124,874,-1,1059,392,907,-1,392,1059,1063,-1,1011,516,1206,-1,517,516,1011,-1,412,397,330,-1,412,885,397,-1,900,613,612,-1,900,293,613,-1,879,408,477,-1,409,408,879,-1,547,418,417,-1,547,902,418,-1,444,1077,1076,-1,444,905,1077,-1,1125,1074,548,-1,1074,1125,1150,-1,917,287,291,-1,1149,287,917,-1,637,653,654,-1,637,567,653,-1,600,649,273,-1,600,1038,649,-1,1067,1039,1158,-1,1067,1078,1039,-1,885,411,1040,-1,885,412,411,-1,394,605,328,-1,429,605,394,-1,1077,420,901,-1,1145,420,1077,-1,633,442,361,-1,443,442,633,-1,904,1080,905,-1,904,585,1080,-1,652,515,285,-1,1043,515,652,-1,612,284,610,-1,612,614,284,-1,844,803,270,-1,803,844,938,-1,899,473,1084,-1,899,476,473,-1,1085,298,878,-1,1085,897,298,-1,457,1087,1089,-1,457,458,1087,-1,1141,1041,464,-1,1141,1042,1041,-1,452,1142,849,-1,1142,452,460,-1,1143,466,465,-1,1143,1140,466,-1,896,862,1068,-1,896,466,862,-1,875,1093,1090,-1,1093,875,1139,-1,1094,1093,1157,-1,1094,1091,1093,-1,876,910,909,-1,876,573,910,-1,606,915,302,-1,915,606,866,-1,648,458,457,-1,458,648,296,-1,351,345,347,-1,351,356,345,-1,1107,483,485,-1,1156,483,1107,-1,863,379,378,-1,487,379,863,-1,493,333,389,-1,565,333,493,-1,560,1105,561,-1,1105,560,1104,-1,559,1108,1106,-1,559,1207,1108,-1,979,1110,973,-1,979,1207,1110,-1,366,363,557,-1,364,363,366,-1,1052,882,561,-1,1052,1109,882,-1,1056,1071,1072,-1,1056,1155,1071,-1,1112,617,616,-1,617,1112,1062,-1,1117,1112,1115,-1,1113,1112,1117,-1,372,506,393,-1,372,371,506,-1,1061,1063,1059,-1,1061,1205,1063,-1,368,1154,369,-1,368,373,1154,-1,867,545,514,-1,867,621,545,-1,516,902,430,-1,902,516,418,-1,550,868,499,-1,550,872,868,-1,520,1098,462,-1,522,1098,520,-1,1129,1126,1192,-1,887,1126,1129,-1,529,1049,530,-1,531,1049,529,-1,533,1192,1126,-1,533,888,1192,-1,535,1131,1130,-1,535,536,1131,-1,1132,1150,1125,-1,1132,1174,1150,-1,209,1206,630,-1,209,1011,1206,-1,544,414,551,-1,544,1128,414,-1,335,398,336,-1,335,395,398,-1,884,1060,913,-1,1060,884,556,-1,1194,1116,375,-1,1114,1116,1194,-1,912,510,1120,-1,510,912,508,-1,365,1060,1133,-1,365,913,1060,-1,1120,370,912,-1,1120,1134,370,-1,1115,616,1134,-1,616,1115,1112,-1,1056,1029,1155,-1,1055,1029,1056,-1,1053,561,1105,-1,561,1053,1052,-1,1108,979,1136,-1,1108,1207,979,-1,1207,882,1110,-1,882,1207,559,-1,1103,1104,560,-1,635,1104,1103,-1,407,1137,381,-1,880,1137,407,-1,1137,863,1069,-1,863,1137,487,-1,1107,1030,1156,-1,1030,1107,1135,-1,341,493,492,-1,401,493,341,-1,639,566,315,-1,479,566,639,-1,881,410,445,-1,881,622,410,-1,865,1047,866,-1,311,1047,865,-1,311,640,1047,-1,855,640,311,-1,916,1100,309,-1,916,1099,1100,-1,1045,608,1204,-1,1045,1101,608,-1,1139,1157,1093,-1,1157,1139,1138,-1,463,1139,875,-1,1139,463,1095,-1,466,625,862,-1,466,1140,625,-1,1142,1140,1143,-1,1142,1092,1140,-1,1143,849,1142,-1,1143,848,849,-1,1089,1042,1141,-1,1089,1086,1042,-1,1088,574,288,-1,574,1088,1087,-1,456,648,457,-1,456,853,648,-1,543,270,803,-1,271,270,543,-1,453,849,580,-1,452,849,453,-1,609,612,610,-1,851,612,609,-1,1205,369,1154,-1,369,1205,1061,-1,1145,905,1080,-1,1145,1077,905,-1,442,1076,591,-1,444,1076,442,-1,1145,1146,420,-1,1146,1145,1144,-1,1147,871,589,-1,871,1147,1050,-1,630,433,435,-1,1206,433,630,-1,1040,552,885,-1,1040,597,552,-1,603,599,280,-1,603,870,599,-1,1065,282,295,-1,282,1065,655,-1,479,598,566,-1,598,479,276,-1,1174,1151,1150,-1,1175,1151,1174,-1,865,1102,1100,-1,1101,1102,865,-1,799,584,610,-1,584,799,1083,-1,406,857,277,-1,406,337,857,-1,1065,1158,655,-1,1067,1158,1065,-1,1206,430,433,-1,516,430,1206,-1,507,1153,892,-1,507,1152,1153,-1,405,381,388,-1,381,405,407,-1,874,1123,305,-1,874,1124,1123,-1,619,562,618,-1,619,489,562,-1,349,592,906,-1,349,348,592,-1,1154,510,1205,-1,1154,1119,510,-1,615,1152,507,-1,1152,615,864,-1,555,63,883,-1,555,1122,63,-1,907,1118,1133,-1,907,393,1118,-1,1153,1072,1070,-1,1153,505,1072,-1,1075,554,513,-1,554,1075,1151,-1,627,501,362,-1,627,1073,501,-1,1071,1111,1109,-1,1071,1155,1111,-1,440,435,595,-1,630,435,440,-1,592,590,871,-1,590,592,593,-1,1156,1082,483,-1,1156,586,1082,-1,633,858,1079,-1,858,633,632,-1,859,860,484,-1,860,859,631,-1,274,423,290,-1,274,650,423,-1,400,856,565,-1,427,856,400,-1,638,898,472,-1,898,638,637,-1,623,320,380,-1,320,623,321,-1,1044,641,646,-1,641,1044,642,-1,910,645,644,-1,910,1204,645,-1,312,308,570,-1,312,916,308,-1,914,1048,1123,-1,914,915,1048,-1,891,1138,1130,-1,1138,891,1157,-1,908,467,909,-1,577,467,908,-1,1094,518,852,-1,886,518,1094,-1,293,283,1043,-1,293,281,283,-1,282,293,295,-1,282,281,293,-1,1148,1088,1149,-1,1086,1088,1148,-1,609,848,850,-1,848,609,583,-1,411,655,1158,-1,411,847,655,-1,1064,603,869,-1,603,1064,903,-1,526,1097,1096,-1,526,535,1097,-1,525,890,542,-1,525,521,890,-1,1178,805,792,-1,25,805,1178,-1,154,659,685,-1,154,658,659,-1,1200,715,724,-1,1200,825,715,-1,1004,1197,820,-1,762,1197,1004,-1,660,824,261,-1,824,660,662,-1,253,116,839,-1,116,253,255,-1,35,1160,1159,-1,35,795,1160,-1,99,771,106,-1,771,99,98,-1,1162,838,1161,-1,838,1162,837,-1,1183,199,100,-1,1183,669,199,-1,127,674,673,-1,189,674,127,-1,241,1161,838,-1,1196,1161,241,-1,681,21,682,-1,681,835,21,-1,681,933,835,-1,677,192,679,-1,676,192,677,-1,237,680,233,-1,680,237,797,-1,835,797,21,-1,835,680,797,-1,1031,223,784,-1,1031,161,223,-1,207,821,141,-1,821,207,691,-1,1163,687,923,-1,687,1163,1164,-1,690,132,135,-1,1199,132,690,-1,143,53,742,-1,53,143,694,-1,1166,1202,1186,-1,1165,1202,1166,-1,1188,812,811,-1,1188,1167,812,-1,1121,1009,58,-1,1121,1175,1009,-1,1201,789,1168,-1,1201,1016,789,-1,966,1013,1169,-1,966,713,1013,-1,64,696,60,-1,57,696,64,-1,787,1203,1015,-1,787,1170,1203,-1,1171,750,1014,-1,1171,1189,750,-1,962,62,936,-1,62,962,1194,-1,752,772,1172,-1,752,773,772,-1,744,1199,208,-1,744,959,1199,-1,706,79,707,-1,79,706,188,-1,124,708,46,-1,708,124,709,-1,123,928,747,-1,1173,928,123,-1,1203,970,201,-1,1203,1170,970,-1,1202,1168,1027,-1,1202,1201,1168,-1,51,683,181,-1,683,51,714,-1,827,718,48,-1,714,718,827,-1,177,173,175,-1,177,248,173,-1,705,922,226,-1,705,720,922,-1,1180,167,986,-1,1180,165,167,-1,1180,1182,165,-1,739,708,38,-1,739,1010,708,-1,794,37,727,-1,37,794,822,-1,1001,729,1176,-1,729,1001,730,-1,1008,1190,710,-1,1008,1007,1190,-1,840,660,261,-1,840,1005,660,-1,260,229,665,-1,88,229,260,-1,921,155,249,-1,843,155,921,-1,825,267,715,-1,267,825,736,-1,724,50,1200,-1,164,50,724,-1,1010,181,683,-1,1010,739,181,-1,143,741,694,-1,145,741,143,-1,744,741,740,-1,743,741,744,-1,441,732,146,-1,441,1146,732,-1,729,1164,1163,-1,729,731,1164,-1,1144,1000,1002,-1,1144,1081,1000,-1,127,166,125,-1,127,167,166,-1,93,123,91,-1,93,837,123,-1,7,918,656,-1,7,804,918,-1,775,819,998,-1,776,819,775,-1,756,755,818,-1,755,756,758,-1,759,754,761,-1,754,759,757,-1,1036,994,770,-1,1197,994,1036,-1,995,763,115,-1,995,764,763,-1,768,997,769,-1,993,997,768,-1,926,816,1172,-1,816,926,768,-1,1177,932,996,-1,1177,989,932,-1,1177,1159,1160,-1,992,1159,1177,-1,772,700,196,-1,771,700,772,-1,1179,836,670,-1,836,1179,675,-1,1183,1181,669,-1,1181,1183,1184,-1,225,717,782,-1,717,225,826,-1,214,136,693,-1,137,136,214,-1,686,221,923,-1,221,686,219,-1,83,1195,780,-1,815,1195,83,-1,1017,828,707,-1,1017,1195,828,-1,68,81,983,-1,222,81,68,-1,1185,814,982,-1,688,814,1185,-1,1135,981,984,-1,1135,1136,981,-1,73,811,810,-1,73,831,811,-1,66,1186,67,-1,1186,66,1166,-1,1165,1024,1025,-1,1028,1024,1165,-1,1170,1187,970,-1,1170,1021,1187,-1,1187,1117,969,-1,1187,1113,1117,-1,788,698,711,-1,699,698,788,-1,1014,749,1013,-1,750,749,1014,-1,1022,790,1167,-1,1022,697,790,-1,1178,791,961,-1,1178,792,791,-1,76,1173,934,-1,76,928,1173,-1,728,1190,1132,-1,728,727,1190,-1,95,24,668,-1,24,95,1191,-1,806,919,805,-1,919,806,943,-1,1191,952,954,-1,1191,34,952,-1,1032,19,236,-1,1032,20,19,-1,1198,798,17,-1,1198,1193,798,-1,958,726,725,-1,958,957,726,-1,956,953,952,-1,956,955,953,-1,954,950,937,-1,954,951,950,-1,22,947,946,-1,22,949,947,-1,939,948,945,-1,948,939,11,-1,800,943,806,-1,800,944,943,-1,801,27,942,-1,27,801,8,-1,4,1193,1198,-1,4,3,1193,-1,6,111,804,-1,6,940,111,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t2_Coord',point=[(.02087,51.3438,-3.07135),(.01054,51.4066,-2.94757),(.02953,51.3939,-2.95034),(0,51.46534,-2.80573),(.02022,51.46206,-2.80469),(0,51.22009,-3.43333),(0,51.2938,-3.29482),(.01763,51.27178,-3.33299),(.03262,50.90863,-3.57771),(0,51.04902,-3.52861),(.02046,51.049,-3.52855),(.0326,50.86035,-3.23701),(0,50.8641,-3.3415),(.0292,50.86772,-3.34119),(0,51.51093,-2.52756),(0,51.50398,-2.5124),(.03648,51.51206,-2.50703),(.03846,51.52765,-2.58764),(.03731,51.51516,-2.52537),(1.05354,51.6165,-2.35613),(1.04651,51.58823,-2.3449),(1.08331,51.59898,-2.40034),(.03816,50.93109,-2.83794),(.13779,50.93023,-2.80966),(.13803,51.02665,-2.71337),(.08741,50.87646,-3.3403),(.09749,50.85491,-3.24294),(.03034,50.85091,-3.59374),(.09727,50.92139,-3.56496),(.01514,51.22109,-3.43495),(.05056,51.21983,-3.4205),(.0604,51.05981,-3.52581),(.27934,51.24812,-2.46593),(.15023,51.36953,-2.45814),(.14855,51.24918,-2.53456),(.22886,50.89642,-2.85004),(.30101,50.95844,-2.72881),(.24328,51.24513,-2.09887),(.29153,51.28352,-2.1587),(.33719,51.23923,-2.17101),(.50793,51.20049,-2.07236),(.45892,51.22574,-2.17116),(.50702,51.256,-2.14533),(.15202,51.46168,-2.42162),(.26593,51.37446,-2.36287),(.2371,51.45973,-2.29945),(.30766,51.3648,-2.28285),(.27116,51.43027,-2.24449),(.3929,51.64947,-2.01688),(.39665,51.72498,-2.03314),(.32856,51.66008,-2.11169),(.33563,51.53542,-2.03926),(.30876,51.52987,-2.02215),(.32301,51.60807,-1.96845),(.33249,51.60926,-1.96751),(.38511,51.60038,-2.00211),(.24838,50.97792,-2.23729),(.10791,50.96174,-2.1318),(.10949,50.96627,-2.18322),(.24204,50.98052,-2.09293),(.2494,50.96315,-2.16292),(.38998,50.96924,-2.15844),(0,50.96813,-2.07845),(0,50.9663,-2.11945),(.1092,50.96383,-2.1169),(.31329,51.00619,-1.53482),(.20397,50.88563,-1.53865),(.29639,50.89513,-1.58341),(.46196,51.03814,-1.68012),(.45859,50.93079,-1.73653),(.52756,50.95818,-1.84366),(.51821,51.11727,-1.99673),(.53446,51.09159,-1.89482),(.56357,50.98448,-1.93264),(.60505,51.28684,-2.28001),(.59979,51.31355,-2.1903),(.51346,51.27972,-2.21131),(.82386,51.34853,-2.36861),(.85422,51.35901,-2.29725),(.75975,51.32596,-2.29059),(.40549,51.26703,-1.46229),(.40252,51.14055,-1.52362),(.4113,51.26952,-1.47157),(.92927,51.56569,-2.18165),(.89678,51.67015,-2.21595),(.76349,51.63018,-2.109),(1.01243,51.79516,-2.32184),(1.10079,51.77749,-2.35191),(1.01368,51.80067,-2.33521),(.95244,51.37982,-2.39968),(.79097,51.34137,-2.42607),(.3512,51.32565,-2.33256),(.32137,51.25206,-2.43912),(.37816,51.25004,-2.39641),(.31458,51.24795,-2.44775),(.27494,51.13337,-2.55977),(.2993,51.12029,-2.53173),(.61209,50.99682,-2.52242),(.60178,51.00908,-2.57145),(.67978,51.07383,-2.50117),(.52201,50.94757,-2.59054),(.84388,51.75057,-2.4642),(.88398,51.64781,-2.52756),(.76273,51.57564,-2.46874),(.73388,51.18355,-2.43459),(.72851,51.12472,-2.45174),(.67848,51.08022,-2.50502),(.05971,51.21492,-3.41608),(.07256,51.23898,-3.31045),(.08342,51.0719,-3.45003),(.05476,51.27732,-3.18712),(.0189,51.30239,-3.18934),(.06081,51.45568,-2.80746),(.09119,51.50232,-2.69529),(.16695,51.45311,-2.70814),(.11156,51.39727,-2.82884),(.29292,51.511,-2.41329),(.32861,51.49204,-2.48358),(.24176,51.47875,-2.58641),(.14373,51.48556,-2.42117),(0,51.37287,-1.40651),(.10024,51.34262,-1.36369),(.10306,51.36578,-1.42863),(.42504,51.29949,-2.29455),(.36169,51.33059,-2.29423),(.69934,51.10456,-2.3913),(.69623,51.16647,-2.36999),(.62503,51.18631,-2.33195),(.47522,51.14505,-2.10872),(.37837,51.15745,-2.14652),(.3904,51.22882,-2.17351),(.45161,51.3807,-1.62115),(.47475,51.44537,-1.71604),(.4053,51.44513,-1.72516),(.53264,51.36471,-1.75515),(.48948,51.43421,-1.72052),(.46663,51.36953,-1.62839),(.5013,51.33032,-1.64412),(.54076,51.27731,-1.66756),(.56283,51.30348,-1.79061),(.456,51.61406,-1.9044),(.50747,51.55383,-1.83639),(.51667,51.57882,-1.93481),(.23182,51.59651,-1.94429),(.12456,51.55198,-1.90384),(.2222,51.54293,-1.87807),(.11765,51.52066,-1.8507),(.49714,51.7462,-1.97185),(.50901,51.77831,-1.9861),(.39823,51.78141,-2.04635),(.76185,51.70024,-2.24706),(.76852,51.64726,-2.11654),(.87203,51.76604,-2.28607),(.61058,51.73245,-2.0299),(.74335,51.66575,-2.07814),(.68498,51.65183,-2.10429),(.44062,51.74337,-2.08455),(.51281,51.78262,-1.99371),(.53126,51.75844,-2.02714),(.47954,51.31083,-1.58849),(.42572,51.35575,-1.53184),(.44493,51.29013,-1.57459),(.26979,51.4778,-2.23696),(.31401,51.53401,-2.15234),(.30561,51.6041,-2.16767),(.55754,51.09129,-2.45014),(.56647,51.12279,-2.42074),(.55816,51.14178,-2.40159),(1.11002,51.40578,-2.37611),(1.14033,51.44813,-2.52826),(1.19779,51.47633,-2.50324),(.12415,51.51904,-2.59219),(.23859,51.47889,-2.59208),(.75706,51.29077,-2.35134),(.6818,51.25235,-2.33124),(.70027,51.17554,-2.36475),(.7031,51.17384,-2.36967),(.72831,51.2543,-2.4121),(.46397,51.6153,-1.95462),(.52636,51.59421,-1.93897),(.55911,51.63767,-1.95302),(.28696,51.44686,-2.07236),(.20966,51.42767,-2.03028),(.21732,51.51356,-1.99121),(.57797,51.30401,-2.05281),(.55995,51.28787,-2.01678),(.5244,51.20939,-1.84807),(.51399,51.15393,-1.98718),(.6773,51.29853,-2.28094),(.62882,51.19628,-2.32842),(.97998,51.39124,-2.32491),(1.08519,51.43183,-2.29366),(1.13111,51.45179,-2.32722),(1.06141,51.55969,-2.35582),(1.08392,51.49168,-2.27858),(.31071,51.08091,-2.7672),(.46621,51.02934,-2.65399),(.35655,50.98096,-2.70864),(.5156,50.96663,-2.62702),(.39064,50.91879,-2.64398),(.39346,50.92847,-2.6666),(.24596,50.87611,-1.72826),(.30357,50.90727,-1.82499),(.26179,50.86381,-1.7227),(.53024,50.85537,-1.89713),(.51561,50.84826,-1.90964),(.57902,50.88236,-1.97574),(.50746,51.54459,-1.82671),(.49822,51.55257,-1.82707),(0,51.52052,-1.89767),(0,51.52674,-1.88749),(.56276,51.39251,-1.82504),(.56057,51.39128,-1.83973),(.53717,51.49524,-1.86829),(.48833,51.31609,-1.59721),(.53307,51.38259,-1.88993),(.52438,51.25316,-1.94074),(.53139,51.38528,-1.89968),(.40294,51.3531,-1.4915),(.40494,51.28025,-1.45458),(.3848,51.36126,-1.47779),(.38966,51.35165,-1.46999),(.44778,51.16214,-1.62487),(.43619,51.28019,-1.56447),(.74966,51.63049,-2.11226),(.5546,51.42014,-1.99777),(.60015,51.32231,-2.09452),(.59694,51.55766,-1.97913),(1.07174,51.77363,-2.50854),(.9968,51.78696,-2.49824),(1.22354,51.58995,-2.52765),(1.22521,51.58768,-2.5368),(1.20009,51.69553,-2.53699),(1.18557,51.73712,-2.4422),(1.20386,51.6875,-2.52189),(1.18467,51.75378,-2.45093),(1.06313,51.67623,-2.28648),(1.11714,51.74891,-2.34849),(1.04923,51.68705,-2.26932),(.32308,51.24377,-2.44645),(.38072,51.16024,-2.47959),(.42109,51.17114,-2.44991),(.70427,51.17042,-2.37182),(.72542,51.25843,-2.41814),(.72654,51.26466,-2.41567),(.30952,50.96475,-2.72622),(.39463,50.93595,-2.6718),(.78438,51.34482,-2.43112),(.73242,51.26296,-2.41029),(.70302,51.63157,-2.12317),(.71426,51.63946,-2.13714),(.62398,51.59103,-2.18757),(.5202,51.53712,-2.25164),(.40677,51.51889,-2.31183),(.4034,51.52114,-2.2997),(.41158,51.51567,-2.32917),(.24856,51.46828,-2.59346),(.26959,51.51475,-2.35284),(.27173,51.51578,-2.35672),(.1512,51.5207,-2.46287),(.8673,51.76971,-2.29855),(.75932,51.703,-2.26188),(.17544,51.44136,-2.71025),(.28774,51.56944,-2.29908),(.27387,51.51855,-2.346),(.27984,51.56695,-2.2946),(.46659,51.67595,-2.14136),(.38745,51.66353,-2.18538),(.08836,50.85507,-3.56691),(.10523,50.92189,-3.556),(-.05291,51.22772,-3.4094),(-.05056,51.21983,-3.42062),(-.05971,51.21492,-3.41622),(-.70302,51.63157,-2.12682),(-.71426,51.63946,-2.14069),(-.76852,51.64726,-2.12019),(-.89678,51.67015,-2.21971),(-.76349,51.63018,-2.11278),(-.64866,51.75247,-1.97682),(-.50901,51.77831,-1.98868),(-.51281,51.78262,-1.9963),(-.27601,51.51958,-2.35243),(-.28293,51.52164,-2.34596),(-.27387,51.51855,-2.34855),(-.14577,51.5209,-2.46649),(-.14422,51.51537,-2.4534),(-.03648,51.51206,-2.50733),(-.71632,51.68037,-2.41676),(-.71724,51.67285,-2.42707),(-.84388,51.75057,-2.46725),(-.75781,51.70082,-2.24964),(-.75932,51.703,-2.26517),(-.76185,51.70024,-2.25039),(-.27701,51.51527,-2.36088),(-.40677,51.51889,-2.31546),(-.4034,51.52114,-2.30333),(-.78438,51.34482,-2.43808),(-.79097,51.34137,-2.43314),(-.90615,51.38643,-2.47604),(-.38675,50.93213,-2.67705),(-.39346,50.92847,-2.67419),(-.39463,50.93595,-2.67931),(-.62503,51.18631,-2.34168),(-.62882,51.19628,-2.33806),(-.70027,51.17554,-2.37502),(-.38231,51.2489,-2.39978),(-.38104,51.24125,-2.40926),(-.37816,51.25004,-2.40221),(-.31745,50.99862,-2.60587),(-.39241,50.9217,-2.64328),(-.39064,50.91879,-2.65174),(-.37005,51.11934,-2.52522),(-.30798,51.1186,-2.53262),(-.32308,51.24377,-2.45137),(-1.11714,51.74891,-2.35213),(-1.10079,51.77749,-2.35546),(-1.18467,51.75378,-2.45435),(-1.20028,51.48982,-2.47096),(-1.19841,51.49721,-2.46503),(-1.22354,51.58995,-2.53124),(-1.12756,51.44499,-2.32561),(-1.13111,51.45179,-2.3316),(-1.13149,51.44331,-2.33383),(-1.11055,51.63029,-2.42491),(-1.18557,51.73712,-2.44568),(-1.20386,51.6875,-2.52529),(-1.09725,51.55243,-2.39966),(-1.12476,51.56384,-2.42913),(-.32481,51.49568,-2.15066),(-.26979,51.4778,-2.24004),(-.31401,51.53401,-2.1556),(-.60015,51.32231,-2.10318),(-.50702,51.256,-2.15376),(-.57797,51.30401,-2.06171),(-.45868,51.60453,-1.95145),(-.38511,51.60038,-2.0056),(-.3908,51.60832,-2.01819),(-.70491,51.63545,-2.03915),(-.61159,51.71532,-1.96507),(-.53717,51.49524,-1.87447),(-.52915,51.50659,-1.8641),(-.53497,51.50995,-1.88152),(-.4113,51.26952,-1.47936),(-.40294,51.3531,-1.49826),(-.43619,51.28019,-1.5726),(-.53307,51.38259,-1.89769),(-.5244,51.20939,-1.85823),(-.52516,51.2229,-1.85161),(-.53264,51.36471,-1.76337),(-.56276,51.39251,-1.83305),(-.56283,51.30348,-1.80001),(-.56354,51.28955,-1.80668),(-.54076,51.27731,-1.67719),(-.48833,51.31609,-1.60564),(-.47954,51.31083,-1.59686),(-.42572,51.35575,-1.53892),(-.56057,51.39128,-1.84772),(-.44816,51.61358,-1.89787),(-.32414,51.6106,-1.96067),(-.456,51.61406,-1.90836),(-.43218,51.35672,-1.55161),(-.41864,51.36422,-1.54157),(-.53024,50.85537,-1.91179),(-.56357,50.98448,-1.94627),(-.59809,50.90534,-1.97883),(-.57902,50.88236,-1.99086),(-.60704,50.94508,-2.07512),(-.24792,50.96288,-2.18384),(-.2494,50.96315,-2.16931),(-.38998,50.96924,-2.16804),(-.30357,50.90727,-1.83373),(-.31885,50.8933,-1.83544),(-.35995,50.92256,-1.95247),(-.24204,50.98052,-2.09918),(-.10655,50.97503,-2.08447),(-.10529,50.979,-2.06099),(-.51477,50.97437,-2.64107),(-.35655,50.98096,-2.71495),(-1.08519,51.43183,-2.29853),(-1.0522,51.46697,-2.23689),(-1.07623,51.48535,-2.27347),(-.76417,51.39886,-2.17876),(-.76537,51.36353,-2.22329),(-.67149,51.33325,-2.2065),(-.33719,51.23923,-2.17711),(-.37756,51.3218,-2.23336),(-.33946,51.34525,-2.23029),(-.59979,51.31355,-2.19866),(-.6711,51.35923,-2.1378),(-.55995,51.28787,-2.02586),(-.50793,51.20049,-2.0818),(-.51399,51.15393,-1.99759),(-.38018,50.93682,-1.99981),(-.43406,50.86941,-1.96337),(-.28696,51.44686,-2.07624),(-.33563,51.53542,-2.04295),(-.30876,51.52987,-2.02566),(-.34661,51.59472,-2.09187),(-.35089,51.55783,-2.08064),(-.52636,51.59421,-1.94348),(-.56698,51.54241,-1.9554),(-.55166,51.53462,-1.9406),(-.46397,51.6153,-1.9585),(-.3929,51.64947,-2.01985),(-.47781,51.67478,-1.96322),(-.65367,51.46677,-2.08812),(-.72107,51.61181,-2.06689),(-.74116,51.50067,-2.1266),(-1.11002,51.40578,-2.38074),(-1.08143,51.4139,-2.45917),(-.95244,51.37982,-2.4056),(-.29285,51.66192,-2.23023),(-.30561,51.6041,-2.17021),(-.28093,51.54676,-2.24856),(-.03552,51.44909,-2.47402),(-.0438,51.4845,-2.45894),(-.14373,51.48556,-2.42259),(-.12242,51.21709,-2.05326),(-.11722,51.31532,-2.01396),(0,51.29905,-1.9939),(-.11269,51.47018,-1.72592),(-.11765,51.52066,-1.85224),(-.2222,51.54293,-1.88075),(-.63206,51.60621,-2.23738),(-.5202,51.53712,-2.25589),(-.53022,51.54053,-2.27747),(-.6507,51.58293,-2.01785),(-.59694,51.55766,-1.98438),(-.55911,51.63767,-1.95694),(-.26862,51.36211,-2.12398),(-.20966,51.42767,-2.03334),(-.3008,51.56499,-1.88993),(-.29017,51.45107,-1.73771),(-.21732,51.51356,-1.99391),(-.32301,51.60807,-1.97148),(-.22982,51.59346,-1.95673),(-.50747,51.55383,-1.84158),(-.5013,51.33032,-1.65252),(-.41588,51.54543,-1.82564),(-.36814,51.56562,-1.86039),(-.12456,51.55198,-1.90534),(0,51.51705,-1.84369),(-.34243,51.38352,-1.57439),(-.31499,51.376,-1.53585),(-.26543,51.36819,-1.49629),(-.82386,51.34853,-2.37599),(-.75706,51.29077,-2.35993),(-.41567,51.29834,-2.23631),(-.3904,51.22882,-2.18055),(-.32861,51.49204,-2.4863),(-.43578,51.51785,-2.41813),(-.41158,51.51567,-2.3328),(-.07383,51.35813,-2.94965),(-.02953,51.3939,-2.95049),(-.02087,51.3438,-3.07143),(-.52533,51.31165,-2.46465),(-.60527,51.20632,-2.49331),(-.6332,51.36834,-2.42767),(-.72393,51.40995,-2.43892),(-.09848,51.15387,-3.08205),(-.12617,51.20696,-2.95664),(-.07256,51.23898,-3.31065),(-.08149,51.08714,-3.33192),(-.0847,51.10876,-3.20823),(-.36755,51.37823,-2.52126),(-.29402,51.33926,-2.62384),(-.32859,51.23753,-2.64472),(-.67848,51.08022,-2.51557),(-.64324,51.14092,-2.50489),(-.55752,51.08246,-2.59182),(-.29387,51.02365,-2.64189),(-.27494,51.13337,-2.56438),(-1.10754,51.70279,-2.59825),(-1.1397,51.63401,-2.62485),(-1.20009,51.69553,-2.54034),(-1.22521,51.58768,-2.54037),(-1.2041,51.54883,-2.58085),(-1.19779,51.47633,-2.50713),(-.98507,51.57191,-2.20551),(-.97884,51.69368,-2.23269),(-.92927,51.56569,-2.18585),(-.51079,51.20025,-1.74071),(-.53745,51.26741,-1.68468),(-.216,51.33509,-1.38172),(-.3346,51.25468,-1.42533),(-.23242,51.24615,-1.39306),(-.44493,51.29013,-1.58273),(-.97244,51.45283,-2.22607),(-.53587,51.2345,-2.35922),(-.61003,51.24357,-2.3498),(-.51346,51.27972,-2.21922),(-.52438,51.25316,-1.9501),(-.53139,51.38528,-1.90737),(-.5413,51.41102,-1.98303),(-.52756,50.95818,-1.85714),(-.50923,51.06505,-1.80925),(-.50965,51.18558,-1.74744),(-.46196,51.03814,-1.69151),(-.51821,51.11727,-2.00766),(-.49431,51.06244,-2.15959),(-.50491,51.00144,-2.20078),(-.44231,50.83968,-1.80387),(-.45859,50.93079,-1.74899),(-.07591,50.84631,-1.62569),(-.07874,50.83204,-1.59402),(-.19206,50.83181,-1.64814),(-.36738,50.85279,-1.84004),(-.26179,50.86381,-1.73066),(-.34126,50.95067,-1.994),(-.34866,50.96546,-2.03312),(-.34001,50.97495,-2.05375),(-.39388,50.9714,-2.18218),(-.38794,50.99244,-2.22357),(-.24838,50.97792,-2.24339),(-.2371,51.45973,-2.30218),(-.24915,51.49417,-2.32764),(-.11562,51.39945,-1.98457),(0,51.37531,-1.95446),(-.30101,50.95844,-2.73428),(-.13779,50.93023,-2.81215),(-.08342,51.0719,-3.45023),(-.10523,50.92189,-3.5563),(-.10436,50.96093,-3.45101),(-.02046,51.049,-3.52859),(-.03262,50.90863,-3.5778),(-.09727,50.92139,-3.56522),(-.08741,50.87646,-3.34106),(-.09544,50.87604,-3.44329),(-.0292,50.86772,-3.34145),(-1.05354,51.6165,-2.36),(-1.06313,51.67623,-2.29037),(-1.04651,51.58823,-2.34884),(-1.08331,51.59898,-2.40417),(-.13803,51.02665,-2.71578),(-.03816,50.93109,-2.83861),(-.09749,50.85491,-3.24403),(-.0326,50.86035,-3.23737),(-.08854,50.85325,-3.56281),(-.03099,50.83043,-3.54065),(-.03195,50.85705,-3.43904),(-.08836,50.85507,-3.56724),(-.03034,50.85091,-3.59384),(-.0604,51.05981,-3.52594),(-.01514,51.22109,-3.43498),(-.15023,51.36953,-2.46002),(-.26593,51.37446,-2.36634),(-.27934,51.24812,-2.47015),(-.24328,51.24513,-2.10349),(-.28326,51.16342,-2.15997),(-.45892,51.22574,-2.17924),(-.47522,51.14505,-2.11823),(-.15202,51.46168,-2.4232),(-.39665,51.72498,-2.0353),(-.33249,51.60926,-1.97059),(-.10949,50.96627,-2.18605),(-.10791,50.96174,-2.13466),(-.4558,50.94733,-2.14791),(-.56343,51.02165,-2.0448),(-.53446,51.09159,-1.90662),(-.2058,51.0001,-1.50745),(-.31329,51.00619,-1.54316),(-.29639,50.89513,-1.59214),(-.60505,51.28684,-2.28834),(-.5225,51.27799,-2.28912),(-.75975,51.32596,-2.29897),(-.5546,51.42014,-2.00489),(-1.01243,51.79516,-2.32533),(-1.01368,51.80067,-2.33866),(-1.13559,51.59012,-2.44725),(-.31458,51.24795,-2.45252),(-.2993,51.12029,-2.53692),(-.5156,50.96663,-2.63634),(-.52201,50.94757,-2.60045),(-.61209,50.99682,-2.53339),(-.76273,51.57564,-2.47191),(-.88398,51.64781,-2.53075),(-.73388,51.18355,-2.44437),(-.72851,51.12472,-2.46237),(-.0626,51.32223,-3.0787),(-.0189,51.30239,-3.1894),(-.06081,51.45568,-2.8078),(-.02022,51.46206,-2.8048),(-.01054,51.4066,-2.94762),(-.16695,51.45311,-2.70931),(-.09119,51.50232,-2.69584),(-.10306,51.36578,-1.43045),(-.10024,51.34262,-1.3655),(0,51.33888,-1.35482),(-.3512,51.32565,-2.33756),(-.4053,51.44513,-1.73095),(-.45161,51.3807,-1.62829),(-.37187,51.3941,-1.61946),(-.48948,51.43421,-1.72736),(-.46663,51.36953,-1.63585),(-.51667,51.57882,-1.9395),(-.23182,51.59651,-1.94666),(-.49714,51.7462,-1.97445),(-.39823,51.78141,-2.04839),(-.87203,51.76604,-2.28946),(-.64838,51.75511,-1.98397),(-.68498,51.65183,-2.10777),(-.74335,51.66575,-2.08172),(-.40288,51.78387,-2.05395),(-.53126,51.75844,-2.02981),(-.29153,51.28352,-2.16374),(-.30523,51.40082,-2.19361),(-.55816,51.14178,-2.41083),(-.56647,51.12279,-2.43021),(-.55754,51.09129,-2.45973),(-.23859,51.47889,-2.59391),(-.12415,51.51904,-2.59305),(-.03731,51.51516,-2.52566),(-.18344,51.525,-2.51203),(-.27173,51.51578,-2.35924),(-.1512,51.5207,-2.46414),(-.24596,50.87611,-1.73569),(-.20709,50.88155,-1.73257),(-.19557,50.86303,-1.69115),(-.6773,51.29853,-2.28956),(-.6818,51.25235,-2.34034),(-.46226,51.28534,-2.22995),(-.30766,51.3648,-2.28714),(-.97998,51.39124,-2.33105),(-1.08392,51.49168,-2.28293),(-1.06141,51.55969,-2.35981),(-.31071,51.08091,-2.77177),(-.46621,51.02934,-2.66176),(-.51561,50.84826,-1.92403),(-.50746,51.54459,-1.83204),(-.49822,51.55257,-1.83224),(-.12309,51.54816,-1.91532),(-.40494,51.28025,-1.46212),(-.38966,51.35165,-1.47656),(-.3848,51.36126,-1.4842),(-.44778,51.16214,-1.63457),(-.40252,51.14055,-1.53268),(-.74966,51.63049,-2.11601),(-.9968,51.78696,-2.50137),(-1.07174,51.77363,-2.51174),(-1.04923,51.68705,-2.2732),(-.42109,51.17114,-2.45682),(-.7031,51.17384,-2.37996),(-.70427,51.17042,-2.38216),(-.69623,51.16647,-2.38035),(-.70718,51.10458,-2.40739),(-.69934,51.10456,-2.40255),(-.72831,51.2543,-2.4208),(-.73242,51.26296,-2.41886),(-.72654,51.26466,-2.42415),(-.61579,51.59315,-2.18303),(-.62398,51.59103,-2.19153),(-.51293,51.54159,-2.24587),(-.26959,51.51475,-2.35536),(-.8673,51.76971,-2.3019),(-.8436,51.75501,-2.45732),(-.28774,51.56944,-2.30146),(.05291,51.22772,-3.40927),(.55892,51.69976,-2.08966),(.64838,51.75511,-1.98079),(.64866,51.75247,-1.97363),(.63244,51.60906,-2.24832),(.53022,51.54053,-2.27333),(.63206,51.60621,-2.23388),(.14422,51.51537,-2.45215),(.71724,51.67285,-2.42412),(.8436,51.75501,-2.45426),(.14577,51.5209,-2.46527),(.38675,50.93213,-2.66962),(.29387,51.02365,-2.63655),(.39241,50.9217,-2.63546),(.32509,50.99929,-2.59378),(.31745,50.99862,-2.59978),(.52507,51.23628,-2.3477),(.52478,51.22861,-2.35611),(.53587,51.2345,-2.35117),(.37005,51.11934,-2.51888),(1.19841,51.49721,-2.46107),(1.20028,51.48982,-2.46701),(1.12756,51.44499,-2.32116),(1.13149,51.44331,-2.3294),(1.11055,51.63029,-2.42116),(1.12476,51.56384,-2.42525),(1.09725,51.55243,-2.3957),(.32481,51.49568,-2.14695),(.70491,51.63545,-2.03528),(.7459,51.66143,-2.07189),(.33779,51.27949,-1.40405),(.216,51.33509,-1.37784),(.3346,51.25468,-1.41874),(.52516,51.2229,-1.84161),(.50342,51.48241,-1.77003),(.52915,51.50659,-1.85812),(.56354,51.28955,-1.79706),(.43218,51.35672,-1.54445),(.32414,51.6106,-1.95764),(.44816,51.61358,-1.89394),(.24792,50.96288,-2.17752),(.39388,50.9714,-2.17257),(.35995,50.92256,-1.94257),(.31885,50.8933,-1.82619),(.51477,50.97437,-2.63189),(.66488,51.056,-2.45306),(.73114,51.12028,-2.44563),(1.07623,51.48535,-2.26904),(1.0522,51.46697,-2.23204),(.6711,51.35923,-2.12942),(.67149,51.33325,-2.19802),(.76537,51.36353,-2.21513),(.33946,51.34525,-2.22526),(.37756,51.3218,-2.22763),(.28326,51.16342,-2.15415),(.43406,50.86941,-1.9512),(.38018,50.93682,-1.98966),(.46441,50.89801,-2.00837),(.35089,51.55783,-2.07712),(.29864,51.66452,-2.23171),(.39265,51.57928,-2.25649),(.55166,51.53462,-1.93506),(.3908,51.60832,-2.01477),(.47781,51.67478,-1.96009),(.65367,51.46677,-2.08148),(.74116,51.50067,-2.12062),(.72107,51.61181,-2.06276),(1.08143,51.4139,-2.45495),(.29285,51.66192,-2.22839),(.0438,51.4845,-2.45852),(.03552,51.44909,-2.47365),(.12242,51.21709,-2.05075),(0,51.21428,-2.04458),(.26543,51.36819,-1.49172),(.19662,51.37507,-1.48576),(.19447,51.36645,-1.46309),(.11269,51.47018,-1.72424),(.20893,51.46104,-1.73251),(.24915,51.49417,-2.32508),(.28093,51.54676,-2.24592),(.39575,51.69607,-2.15597),(.40288,51.78387,-2.05189),(.6507,51.58293,-2.01302),(.26862,51.36211,-2.11979),(.29017,51.45107,-1.73342),(.3008,51.56499,-1.8866),(.22982,51.59346,-1.95438),(.36814,51.56562,-1.85641),(.41588,51.54543,-1.82099),(.34243,51.38352,-1.56875),(.31499,51.376,-1.53056),(.41567,51.29834,-2.22986),(.32762,50.97827,-2.08812),(.44494,50.94642,-2.12705),(.37471,50.96943,-2.07533),(.0626,51.32223,-3.07843),(.60527,51.20632,-2.4851),(.52533,51.31165,-2.45836),(.6332,51.36834,-2.42135),(.95327,51.52206,-2.57825),(.90615,51.38643,-2.47067),(.72393,51.40995,-2.43321),(.83269,51.45997,-2.4964),(.66048,51.52019,-2.42063),(.61809,51.6125,-2.3959),(.56321,51.46629,-2.40592),(.52853,51.5386,-2.39857),(.07383,51.35813,-2.94923),(.12617,51.20696,-2.95548),(.09848,51.15387,-3.08124),(.0847,51.10876,-3.20766),(.08149,51.08714,-3.33154),(.32859,51.23753,-2.64051),(.29402,51.33926,-2.6207),(.36755,51.37823,-2.51734),(.59998,51.01633,-2.576),(.55752,51.08246,-2.58307),(.64324,51.14092,-2.49549),(1.10754,51.70279,-2.59508),(1.1397,51.63401,-2.62159),(1.2041,51.54883,-2.5773),(1.02127,51.57442,-2.22983),(.98507,51.57191,-2.20135),(.97884,51.69368,-2.22884),(.97244,51.45283,-2.22049),(.61003,51.24357,-2.34113),(.5413,51.41102,-1.97582),(.50923,51.06505,-1.79737),(.50965,51.18558,-1.73704),(.19206,50.83181,-1.64207),(.07591,50.84631,-1.62327),(.19361,50.85063,-1.66517),(.36738,50.85279,-1.82919),(.29428,50.8424,-1.71268),(.38794,50.99244,-2.21443),(.10436,50.96093,-3.45054),(.10276,50.88552,-3.44367),(.11562,51.39945,-1.98272),(.11722,51.31532,-2.01183),(.17605,50.87855,-2.94481),(.06964,51.05881,-3.51868),(1.08952,51.64076,-2.39327),(0,51.52878,-2.58763),(-.03846,51.52765,-2.5879),(0,50.84794,-3.43804),(0,50.91011,-3.58318),(0,51.41019,-2.94881),(-.01763,51.27178,-3.33304),(.02194,51.27948,-3.29927),(.09544,50.87604,-3.44269),(.03195,50.85705,-3.43882),(.09616,50.86466,-3.55656),(.07874,50.83204,-1.59148),(.44231,50.83968,-1.79093),(.56343,51.02165,-2.03199),(.60704,50.94508,-2.06065),(.50491,51.00144,-2.18937),(.49431,51.06244,-2.14892),(.23242,51.24615,-1.38833),(.82205,51.53024,-2.15264),(.42348,51.27189,-2.55233),(.99177,51.71377,-2.59762),(1.05283,51.42202,-2.53357),(1.13764,51.49185,-2.59008),(.43578,51.51785,-2.41476),(.53497,51.50995,-1.87559),(.21623,51.3359,-2.06265),(.61159,51.71532,-1.96193),(.75781,51.70082,-2.24633),(.33985,51.74121,-2.14073),(.56698,51.54241,-1.94995),(.34661,51.59472,-2.08877),(.76417,51.39886,-2.17103),(.70718,51.10458,-2.39612),(.33333,50.93528,-1.9421),(.59809,50.90534,-1.96361),(.41864,51.36422,-1.53468),(.53745,51.26741,-1.67496),(.45868,51.60453,-1.94744),(1.12439,51.61663,-2.44204),(.30798,51.1186,-2.52726),(.38231,51.2489,-2.39391),(.38104,51.24125,-2.40337),(.27701,51.51527,-2.35832),(.71632,51.68037,-2.4138),(.27601,51.51958,-2.34989),(.28293,51.52164,-2.34336),(.5966,51.62052,-2.1555),(-.06582,51.25083,-3.3083),(-.05476,51.27732,-3.1873),(-.09616,50.86466,-3.55693),(-.27984,51.56695,-2.29696),(-.17544,51.44136,-2.71152),(-.11156,51.39727,-2.82958),(-.24856,51.46828,-2.59542),(-.24176,51.47875,-2.58828),(-.30952,50.96475,-2.7318),(-.72542,51.25843,-2.4267),(-.32137,51.25206,-2.44398),(-.38072,51.16024,-2.4859),(-.58902,51.43829,-2.04432),(-.7459,51.66143,-2.07551),(-.31875,51.34634,-1.41721),(-.33779,51.27949,-1.41045),(-.40549,51.26703,-1.47),(-.38887,51.00273,-2.22681),(-.40216,51.12087,-2.66818),(-.98006,51.42359,-2.27687),(-.22426,50.8683,-1.70884),(-.47746,51.07601,-2.50803),(-.51788,51.16348,-2.41456),(-.27116,51.43027,-2.24793),(-.38098,51.06273,-2.1951),(-.44062,51.74337,-2.0868),(-.61058,51.73245,-2.03294),(-.47475,51.44537,-1.72258),(-.37837,51.15745,-2.15415),(-.36169,51.33059,-2.29944),(-.42504,51.29949,-2.30085),(-.10363,51.12971,-3.0833),(-.60178,51.00908,-2.58174),(-1.12439,51.61663,-2.44577),(-1.05283,51.42202,-2.53742),(-1.14033,51.44813,-2.53212),(-.82205,51.53024,-2.15769),(-.85422,51.35901,-2.30493),(-.20397,50.88563,-1.54482),(-.1092,50.96383,-2.1198),(-.49601,50.98288,-2.19452),(-.32856,51.66008,-2.11399),(-.22886,50.89642,-2.85411),(-.14855,51.24918,-2.53674),(-.03769,51.01098,-2.73636),(-1.08952,51.64076,-2.39704),(-.06964,51.05881,-3.51883),(-.17605,50.87855,-2.94774),(-.29428,50.8424,-1.72171),(-.19361,50.85063,-1.67121),(-1.02127,51.57442,-2.23399),(-.59998,51.01633,-2.58614),(-.42348,51.27189,-2.55766),(-.83269,51.45997,-2.50043),(-.99177,51.71377,-2.60068),(-1.13764,51.49185,-2.59369),(-.29292,51.511,-2.41584),(-.20893,51.46104,-1.73562),(-.21623,51.3359,-2.06632),(-.55892,51.69976,-2.09251),(-.19447,51.36645,-1.46649),(-.19662,51.37507,-1.48916),(-.50342,51.48241,-1.77629),(-.46441,50.89801,-2.0208),(-.73114,51.12028,-2.45639),(-.67978,51.07383,-2.51185),(-.66488,51.056,-2.46429),(-.23968,50.98156,-2.0726),(-.33333,50.93528,-1.95123),(-.58403,50.92609,-2.08132),(-.52507,51.23628,-2.35564),(-.52478,51.22861,-2.36409),(-.32509,50.99929,-2.60003),(-.63244,51.60906,-2.25172),(.06582,51.25083,-3.30812),(.08854,50.85325,-3.56246),(.51293,51.54159,-2.24167),(.61579,51.59315,-2.17908),(.58902,51.43829,-2.03736),(.31875,51.34634,-1.41171),(.12309,51.54816,-1.91384),(.38887,51.00273,-2.21776),(.40216,51.12087,-2.6622),(.98006,51.42359,-2.27104),(.46226,51.28534,-2.22275),(.18344,51.525,-2.51063),(.38098,51.06273,-2.18665),(.37187,51.3941,-1.6135),(.10363,51.12971,-3.0824),(1.13559,51.59012,-2.44346),(.5225,51.27799,-2.28141),(.2058,51.0001,-1.50182),(.10655,50.97503,-2.08164),(.03769,51.01098,-2.73569),(-.02194,51.27948,-3.29934),(0,50.86197,-3.23713),(0,51.31319,-3.19123),(0,51.35458,-3.06778),(0,50.84639,-3.60258),(.03099,50.83043,-3.5405),(0,50.82081,-3.54211),(0,50.88506,-3.07917),(.03708,50.89825,-2.96739),(0,50.90391,-2.96806),(.03711,50.87973,-3.07877),(0,50.93555,-2.83983),(0,51.01344,-2.7383),(0,51.11435,-2.65615),(.03708,51.24278,-2.55936),(0,51.24544,-2.5649),(.03733,51.11225,-2.65283),(0,51.36193,-2.50529),(.0365,51.35972,-2.49566),(0,51.45131,-2.48584),(0,51.4785,-2.47488),(.42145,51.49592,-1.77248),(.12307,50.86468,-3.07531),(.09106,50.98309,-3.34082),(.10529,50.979,-2.05819),(.22939,50.94905,-1.95332),(.09477,50.95586,-1.96556),(.23968,50.98156,-2.06636),(.47807,50.89318,-2.00617),(.44613,50.86291,-1.94667),(.21586,50.91457,-1.83375),(.08679,50.92357,-1.84887),(.20709,50.88155,-1.7263),(0,50.84721,-1.62015),(0,50.82414,-1.58133),(0,50.87399,-1.48155),(.08731,50.82177,-1.52923),(.09444,50.87593,-1.5001),(0,50.81383,-1.5239),(.38638,50.90794,-1.63521),(.36082,50.82668,-1.68256),(0,50.99825,-1.45194),(.09312,50.9981,-1.47026),(.09116,51.11845,-1.42518),(.20871,51.12573,-1.45228),(.4023,51.0123,-1.58404),(.10266,51.23718,-1.36881),(.1019,51.33236,-1.35767),(.51788,51.16348,-2.4061),(.13037,50.87075,-3.07734),(.1035,50.99404,-3.22476),(.13188,51.00693,-3.08394),(.10488,50.86187,-3.24234),(.18577,51.18038,-2.85012),(.24012,51.04132,-2.86731),(.24846,51.20677,-2.74877),(.46547,51.41751,-2.43463),(.16618,51.24337,-2.84804),(.14123,51.15637,-2.95842),(.22378,51.29035,-2.7356),(1.03521,51.58925,-2.64227),(.27057,51.51219,-2.34669),(.10271,51.37956,-1.4805),(.20126,51.41184,-1.60696),(.10703,51.42044,-1.6044),(.49615,51.59231,-2.20572),(.52559,51.54507,-2.39038),(.6159,51.6187,-2.38661),(.24617,50.9869,-2.24037),(.119,51.04907,-2.1534),(.26111,51.05772,-2.20247),(.10855,50.97441,-2.18713),(.30523,51.40082,-2.1894),(0,51.4626,-1.91847),(.11743,51.48832,-1.94247),(.47486,50.92486,-2.07613),(.38912,50.95497,-2.03768),(.23637,50.85622,-1.68945),(.25079,50.838,-1.6711),(.85746,51.39501,-2.24184),(.3036,50.97877,-2.05986),(.34126,50.95067,-1.98488),(0,50.85836,-1.63887),(.07814,50.8574,-1.64218),(.4558,50.94733,-2.13663),(.3811,50.84577,-1.82767),(.08114,50.8259,-1.57827),(.19458,50.82512,-1.62939),(.43447,50.83425,-1.79865),(.35341,50.82194,-1.69182),(.08551,50.81657,-1.54051),(0,50.8091,-1.53614),(0,51.32765,-1.3482),(.51079,51.20025,-1.73048),(1.03126,51.57661,-2.24174),(.6583,51.05614,-2.44788),(.60627,50.99678,-2.51724),(.73632,51.18237,-2.42765),(.33572,51.4833,-2.49093),(-.10276,50.88552,-3.44429),(-.5966,51.62052,-2.15908),(-.33985,51.74121,-2.14247),(-.33463,51.73948,-2.13727),(-.33572,51.4833,-2.49375),(-.4398,51.5108,-2.42625),(-.27057,51.51219,-2.34925),(-.73632,51.18237,-2.43752),(-.60627,50.99678,-2.52819),(-.51817,50.94917,-2.59355),(-.46466,51.17084,-2.43529),(-.4639,51.2407,-2.37883),(-1.03126,51.57661,-2.24589),(-.48912,51.49272,-1.77123),(-.35341,50.82194,-1.70265),(-.28214,50.82685,-1.63112),(-.36082,50.82668,-1.69357),(-.27663,50.82188,-1.64122),(0,50.81764,-1.56806),(-.08114,50.8259,-1.58089),(-.30533,50.83486,-1.71668),(-.3811,50.84577,-1.83894),(-.47486,50.92486,-2.08828),(-.48887,50.9225,-2.09105),(-.44494,50.94642,-2.13816),(-.07814,50.8574,-1.64464),(-.38912,50.95497,-2.04776),(-.46659,51.67595,-2.14397),(-.39265,51.57928,-2.25957),(-.49615,51.59231,-2.2093),(-.38745,51.66353,-2.18774),(-.50557,51.16395,-2.58582),(-.85746,51.39501,-2.24915),(-.25807,50.83071,-1.66924),(-.18922,50.81665,-1.59517),(-.19458,50.82512,-1.63558),(-.43447,50.83425,-1.81144),(-.26111,51.05772,-2.20845),(-.24617,50.9869,-2.24635),(-.28319,51.40304,-1.61372),(-.20126,51.41184,-1.61026),(-.39575,51.69607,-2.15811),(-.31417,51.35505,-1.4221),(-.10271,51.37956,-1.48229),(0,51.39071,-1.47366),(-.21353,51.34455,-1.38824),(-.03049,51.50869,-2.68874),(-1.03521,51.58925,-2.6455),(-.95327,51.52206,-2.58166),(-.52853,51.5386,-2.4021),(-.66048,51.52019,-2.42447),(-.61809,51.6125,-2.39873),(-.56321,51.46629,-2.41057),(-.14123,51.15637,-2.95987),(-.24012,51.04132,-2.87073),(-.18577,51.18038,-2.85226),(-.18669,51.02493,-2.9707),(-.23381,50.89993,-2.85676),(-.1035,50.99404,-3.22566),(-.09468,50.88503,-3.33934),(-.10488,50.86187,-3.24349),(-.09106,50.98309,-3.34141),(-.37874,51.02843,-2.57557),(-.4341,50.99159,-2.58169),(-.52733,51.05327,-2.50734),(-.4977,51.01386,-2.54365),(-.32119,51.13463,-1.48217),(-.4023,51.0123,-1.59442),(-.38638,50.90794,-1.6462),(-.20871,51.12573,-1.45728),(-.10266,51.23718,-1.37097),(-.09116,51.11845,-1.42741),(-.19359,50.82164,-1.58427),(-.09444,50.87593,-1.50302),(-.08731,50.82177,-1.53205),(-.08089,50.89725,-1.73603),(0,50.90299,-1.73978),(0,50.95996,-1.96905),(-.08679,50.92357,-1.85142),(-.09477,50.95586,-1.9682),(0,50.92955,-1.85254),(-.44613,50.86291,-1.95921),(-.3036,50.97877,-2.06769),(-.22939,50.94905,-1.95966),(0,50.9675,-2.17457),(0,50.96428,-2.13435),(-.46257,51.24838,-2.37041),(-.46725,51.29034,-2.29543),(-.12377,51.13654,-2.09713),(-.14487,51.13632,-2.62267),(-.03708,50.89825,-2.96799),(-.0365,51.35972,-2.49611),(-.03708,51.24278,-2.55991),(-.12307,50.86468,-3.07709),(-.03711,50.87973,-3.0793),(0,51.13236,-2.08878),(-.47807,50.89318,-2.01896),(-.21586,50.91457,-1.84005),(0,51.2357,-1.35873),(0,51.12033,-1.40223),(-.85572,51.42533,-2.20063),(-.13037,50.87075,-3.0792),(-.13188,51.00693,-3.08543),(-.24846,51.20677,-2.75182),(-.46547,51.41751,-2.43928),(-.16618,51.24337,-2.84972),(-.22378,51.29035,-2.73796),(0,51.42528,-1.60046),(-.10703,51.42044,-1.60615),(0,51.47062,-1.72213),(-.42145,51.49592,-1.77782),(-.52559,51.54507,-2.39386),(-.6159,51.6187,-2.38942),(-.119,51.04907,-2.15627),(-.10855,50.97441,-2.18992),(-.23637,50.85622,-1.69673),(-.25079,50.838,-1.67891),(-.32762,50.97827,-2.09645),(-.08551,50.81657,-1.54328),(-.1019,51.33236,-1.35953),(-.17834,50.88113,-2.95527),(-.29864,51.66452,-2.23355),(.23381,50.89993,-2.85263),(.17834,50.88113,-2.95235),(.4639,51.2407,-2.37175),(.46257,51.24838,-2.36341),(.31417,51.35505,-1.41673),(.21353,51.34455,-1.38446),(.18922,50.81665,-1.58912),(.19359,50.82164,-1.57811),(.49601,50.98288,-2.18303),(.30533,50.83486,-1.70729),(.48887,50.9225,-2.07859),(.19557,50.86303,-1.68511),(.34866,50.96546,-2.02404),(.50557,51.16395,-2.57861),(.46725,51.29034,-2.28851),(0,51.05081,-2.13839),(0,50.97517,-2.17824),(.28319,51.40304,-1.60911),(.18669,51.02493,-2.96828),(.09468,50.88503,-3.33853),(.37874,51.02843,-2.56854),(.47746,51.07601,-2.4996),(.4341,50.99159,-2.57347),(.52733,51.05327,-2.49797),(.51817,50.94917,-2.58367),(.4977,51.01386,-2.53446),(.32119,51.13463,-1.47473),(.28214,50.82685,-1.62234),(.08089,50.89725,-1.73357),(.58403,50.92609,-2.06701),(.34001,50.97495,-2.045),(.12377,51.13654,-2.09436),(.14487,51.13632,-2.62031),(-.03733,51.11225,-2.65345),(0,51.51121,-2.68913),(0,50.97477,-2.0545),(.85572,51.42533,-2.19365),(.46466,51.17084,-2.42769),(.4398,51.5108,-2.42281),(.03049,51.50869,-2.68856),(.48912,51.49272,-1.76523),(.33463,51.73948,-2.13554),(.25807,50.83071,-1.66118),(.27663,50.82188,-1.63256),(.22426,50.8683,-1.70199),(-.6583,51.05614,-2.45909),(-.37471,50.96943,-2.08485),(-.11743,51.48832,-1.94407),(-.09312,50.9981,-1.47285)]))),
        Shape(DEF='t2disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t2disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,10,15,4,-1,16,17,18,-1,16,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,2,33,-1,34,31,35,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,41,-1,53,54,52,-1,55,56,57,-1,44,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,60,69,70,-1,71,72,73,-1,74,75,76,-1,74,0,75,-1,77,72,71,-1,78,79,80,-1,81,82,8,-1,83,84,85,-1,86,87,61,-1,88,65,69,-1,83,71,78,-1,89,59,90,-1,91,51,92,-1,58,93,90,-1,20,22,55,-1,52,94,53,-1,95,48,96,-1,97,98,76,-1,99,47,46,-1,100,95,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,19,17,114,-1,114,17,28,-1,115,116,117,-1,118,119,16,-1,17,120,28,-1,17,121,120,-1,122,13,12,-1,123,124,14,-1,125,126,127,-1,122,128,129,-1,5,15,130,-1,1,29,31,-1,31,2,1,-1,5,4,15,-1,129,13,122,-1,127,131,125,-1,123,14,132,-1,122,12,133,-1,118,134,119,-1,21,115,135,-1,24,23,117,-1,28,27,114,-1,19,18,17,-1,113,34,111,-1,136,134,137,-1,138,139,140,-1,141,142,143,-1,99,76,47,-1,76,99,97,-1,20,57,144,-1,52,51,94,-1,145,146,54,-1,55,57,20,-1,90,59,58,-1,92,147,91,-1,83,148,71,-1,62,88,69,-1,86,61,149,-1,85,150,83,-1,81,8,7,-1,83,151,148,-1,83,150,151,-1,78,73,79,-1,77,152,72,-1,0,32,75,-1,98,74,76,-1,71,73,78,-1,60,70,153,-1,66,154,67,-1,65,155,63,-1,62,69,60,-1,156,48,157,-1,156,49,48,-1,44,59,89,-1,57,54,158,-1,41,92,51,-1,96,48,50,-1,45,159,46,-1,160,79,161,-1,162,163,92,-1,164,165,166,-1,100,101,26,-1,35,111,34,-1,32,33,167,-1,30,35,31,-1,20,144,115,-1,25,168,23,-1,169,117,170,-1,20,115,21,-1,16,19,118,-1,4,171,10,-1,172,12,14,-1,9,173,10,-1,6,174,7,-1,3,175,4,-1,2,32,0,-1,176,177,178,-1,176,179,177,-1,180,108,181,-1,109,108,180,-1,171,11,10,-1,11,171,182,-1,173,183,184,-1,183,173,9,-1,14,129,132,-1,129,14,13,-1,185,186,187,-1,185,188,186,-1,186,189,190,-1,186,191,189,-1,192,193,194,-1,193,192,195,-1,184,124,123,-1,184,183,124,-1,196,125,197,-1,196,126,125,-1,11,198,9,-1,199,198,11,-1,133,196,122,-1,133,200,196,-1,175,7,174,-1,7,175,201,-1,123,202,203,-1,202,123,132,-1,197,194,204,-1,194,197,125,-1,205,121,25,-1,205,120,121,-1,16,121,17,-1,16,206,121,-1,16,119,206,-1,116,207,208,-1,207,116,209,-1,116,24,117,-1,116,208,24,-1,210,28,120,-1,210,26,28,-1,210,100,26,-1,211,36,212,-1,37,36,211,-1,213,214,215,-1,213,216,214,-1,217,107,218,-1,105,107,217,-1,219,220,181,-1,219,221,220,-1,217,222,223,-1,224,222,217,-1,225,226,227,-1,226,225,214,-1,228,112,111,-1,229,112,228,-1,228,181,220,-1,180,181,228,-1,1,230,3,-1,1,0,230,-1,231,26,101,-1,231,27,26,-1,118,137,134,-1,229,137,118,-1,232,107,106,-1,233,107,232,-1,234,178,177,-1,178,234,235,-1,236,237,238,-1,237,236,193,-1,239,240,241,-1,195,240,239,-1,242,243,244,-1,242,245,243,-1,246,247,248,-1,249,247,246,-1,103,250,251,-1,102,250,103,-1,44,252,42,-1,252,44,147,-1,159,58,253,-1,93,58,159,-1,79,97,161,-1,79,73,97,-1,46,254,99,-1,254,46,255,-1,256,167,101,-1,256,257,167,-1,258,259,260,-1,261,259,258,-1,262,263,264,-1,263,262,265,-1,266,267,268,-1,266,269,267,-1,270,252,163,-1,252,270,268,-1,39,271,265,-1,39,272,271,-1,273,274,275,-1,274,273,258,-1,97,254,161,-1,97,99,254,-1,50,90,93,-1,90,50,49,-1,91,44,89,-1,91,147,44,-1,94,276,53,-1,276,94,277,-1,278,157,210,-1,278,277,157,-1,279,153,280,-1,281,153,279,-1,282,283,284,-1,63,283,282,-1,81,71,148,-1,81,77,71,-1,154,149,285,-1,86,149,154,-1,286,85,287,-1,85,286,288,-1,289,8,82,-1,289,290,8,-1,281,60,153,-1,281,285,60,-1,240,291,245,-1,291,240,292,-1,87,293,294,-1,295,293,87,-1,62,296,88,-1,62,294,296,-1,142,284,297,-1,282,284,142,-1,288,298,299,-1,288,286,298,-1,151,81,148,-1,151,82,81,-1,77,230,152,-1,230,77,201,-1,264,250,102,-1,264,263,250,-1,261,244,259,-1,261,242,244,-1,250,300,249,-1,263,300,250,-1,160,254,301,-1,160,161,254,-1,289,296,302,-1,289,303,296,-1,103,282,142,-1,103,304,282,-1,294,302,296,-1,294,293,302,-1,61,294,62,-1,87,294,61,-1,305,68,306,-1,305,66,68,-1,248,280,246,-1,279,280,248,-1,67,285,281,-1,285,67,154,-1,288,150,85,-1,288,299,150,-1,285,61,60,-1,149,61,285,-1,7,77,81,-1,7,201,77,-1,304,63,282,-1,304,64,63,-1,307,281,279,-1,307,67,281,-1,156,277,94,-1,277,156,157,-1,207,158,276,-1,207,209,158,-1,53,158,54,-1,158,53,276,-1,48,210,157,-1,95,210,48,-1,100,210,95,-1,141,266,308,-1,141,143,266,-1,309,272,310,-1,272,309,271,-1,163,311,270,-1,163,162,311,-1,312,269,301,-1,269,312,267,-1,264,311,262,-1,264,313,311,-1,314,260,259,-1,314,309,260,-1,159,255,46,-1,159,253,255,-1,257,32,167,-1,75,32,257,-1,73,98,97,-1,73,72,98,-1,45,93,159,-1,50,93,45,-1,142,315,143,-1,315,142,297,-1,40,92,41,-1,40,162,92,-1,146,310,272,-1,310,146,145,-1,56,274,316,-1,274,56,55,-1,275,21,317,-1,22,21,275,-1,318,169,215,-1,318,135,169,-1,213,139,138,-1,213,170,139,-1,166,36,38,-1,165,36,166,-1,319,108,110,-1,319,320,108,-1,114,231,113,-1,231,114,27,-1,3,29,1,-1,29,3,5,-1,31,33,2,-1,31,34,33,-1,229,220,137,-1,229,228,220,-1,176,214,216,-1,176,226,214,-1,224,218,212,-1,224,217,218,-1,137,221,136,-1,137,220,221,-1,105,223,140,-1,105,217,223,-1,318,214,225,-1,318,215,214,-1,164,224,165,-1,164,222,224,-1,239,321,322,-1,239,241,321,-1,139,168,106,-1,139,23,168,-1,115,209,116,-1,209,115,144,-1,206,25,121,-1,25,206,168,-1,192,125,131,-1,192,194,125,-1,323,132,129,-1,132,323,202,-1,15,173,324,-1,10,173,15,-1,325,127,191,-1,305,127,325,-1,326,14,124,-1,14,326,172,-1,182,199,11,-1,327,199,182,-1,204,193,236,-1,194,193,204,-1,323,235,234,-1,323,328,235,-1,325,186,188,-1,191,186,325,-1,329,187,330,-1,187,329,185,-1,202,234,166,-1,202,323,234,-1,172,327,331,-1,172,199,327,-1,199,172,326,-1,290,330,332,-1,290,329,330,-1,110,333,319,-1,110,324,333,-1,219,37,211,-1,320,37,219,-1,178,226,176,-1,226,178,238,-1,237,322,227,-1,322,237,239,-1,177,222,164,-1,179,222,177,-1,230,175,3,-1,230,201,175,-1,174,182,171,-1,182,174,6,-1,326,198,199,-1,334,198,326,-1,333,38,319,-1,333,203,38,-1,331,12,172,-1,12,331,335,-1,187,190,335,-1,187,186,190,-1,192,240,195,-1,192,292,240,-1,122,197,128,-1,196,197,122,-1,8,332,6,-1,290,332,8,-1,9,334,183,-1,9,198,334,-1,200,126,196,-1,200,189,126,-1,4,174,171,-1,174,4,175,-1,184,203,333,-1,184,123,203,-1,128,204,328,-1,128,197,204,-1,120,278,210,-1,278,120,205,-1,208,25,24,-1,208,205,25,-1,134,206,119,-1,232,206,134,-1,117,135,115,-1,117,169,135,-1,180,30,109,-1,30,180,35,-1,317,273,275,-1,317,336,273,-1,216,138,337,-1,213,138,216,-1,233,218,107,-1,233,338,218,-1,221,211,338,-1,219,211,221,-1,179,223,222,-1,179,337,223,-1,227,336,225,-1,227,322,336,-1,167,231,101,-1,231,167,33,-1,180,111,35,-1,180,228,111,-1,30,110,109,-1,130,110,30,-1,118,112,229,-1,118,19,112,-1,233,134,136,-1,233,232,134,-1,177,166,234,-1,177,164,166,-1,238,235,236,-1,238,178,235,-1,193,239,237,-1,239,193,195,-1,240,242,241,-1,240,245,242,-1,244,248,247,-1,244,243,248,-1,249,251,250,-1,249,246,251,-1,163,147,92,-1,163,252,147,-1,43,58,44,-1,43,253,58,-1,95,256,101,-1,256,95,96,-1,230,74,152,-1,0,74,230,-1,301,255,312,-1,301,254,255,-1,256,47,257,-1,256,45,47,-1,321,258,273,-1,321,261,258,-1,265,300,263,-1,300,265,271,-1,308,268,270,-1,308,266,268,-1,268,42,252,-1,42,268,267,-1,40,265,262,-1,40,39,265,-1,274,260,316,-1,274,258,260,-1,301,315,160,-1,315,301,269,-1,52,146,41,-1,52,54,146,-1,89,156,91,-1,90,156,89,-1,156,90,49,-1,277,207,276,-1,278,207,277,-1,292,68,291,-1,292,306,68,-1,280,70,339,-1,153,70,280,-1,283,80,284,-1,283,84,80,-1,340,154,66,-1,340,86,154,-1,155,286,287,-1,155,298,286,-1,303,82,151,-1,303,289,82,-1,155,283,63,-1,287,283,155,-1,243,291,307,-1,243,245,291,-1,86,295,87,-1,340,295,86,-1,295,185,293,-1,185,295,188,-1,70,65,64,-1,70,69,65,-1,287,84,283,-1,287,85,84,-1,308,104,141,-1,104,308,313,-1,247,259,244,-1,314,259,247,-1,314,249,300,-1,314,247,249,-1,143,269,266,-1,143,315,269,-1,284,79,297,-1,80,79,284,-1,302,290,289,-1,290,302,329,-1,303,88,296,-1,299,88,303,-1,298,88,299,-1,251,304,103,-1,304,251,339,-1,293,329,302,-1,293,185,329,-1,295,325,188,-1,295,340,325,-1,246,339,251,-1,280,339,246,-1,243,279,248,-1,243,307,279,-1,299,151,150,-1,299,303,151,-1,65,298,155,-1,65,88,298,-1,66,325,340,-1,66,305,325,-1,84,78,80,-1,84,83,78,-1,64,339,70,-1,64,304,339,-1,67,291,68,-1,307,291,67,-1,94,91,156,-1,94,51,91,-1,209,57,158,-1,209,144,57,-1,56,54,57,-1,145,54,56,-1,321,242,261,-1,241,242,321,-1,313,102,104,-1,102,313,264,-1,309,316,260,-1,310,316,309,-1,262,162,40,-1,162,262,311,-1,267,43,42,-1,43,267,312,-1,270,313,308,-1,313,270,311,-1,309,300,271,-1,314,300,309,-1,312,253,43,-1,253,312,255,-1,257,76,75,-1,76,257,47,-1,98,152,74,-1,98,72,152,-1,256,50,45,-1,256,96,50,-1,160,297,79,-1,297,160,315,-1,141,103,142,-1,141,104,103,-1,41,272,39,-1,272,41,146,-1,145,316,310,-1,316,145,56,-1,55,275,274,-1,55,22,275,-1,317,135,318,-1,317,21,135,-1,215,170,213,-1,215,169,170,-1,106,140,139,-1,105,140,106,-1,320,38,37,-1,320,319,38,-1,19,113,112,-1,19,114,113,-1,29,130,30,-1,5,130,29,-1,34,231,33,-1,113,231,34,-1,336,321,273,-1,322,321,336,-1,176,337,179,-1,176,216,337,-1,338,212,218,-1,211,212,338,-1,136,338,233,-1,136,221,338,-1,337,140,223,-1,138,140,337,-1,225,317,318,-1,317,225,336,-1,320,181,108,-1,320,219,181,-1,170,23,139,-1,117,23,170,-1,232,168,206,-1,106,168,232,-1,207,205,208,-1,207,278,205,-1,131,292,192,-1,292,131,306,-1,129,328,323,-1,129,128,328,-1,324,184,333,-1,173,184,324,-1,126,191,127,-1,189,191,126,-1,334,124,183,-1,124,334,326,-1,6,327,182,-1,332,327,6,-1,190,200,133,-1,190,189,200,-1,328,236,235,-1,328,204,236,-1,131,305,306,-1,127,305,131,-1,335,133,12,-1,335,190,133,-1,330,335,331,-1,335,330,187,-1,203,166,38,-1,166,203,202,-1,331,332,330,-1,332,331,327,-1,130,324,110,-1,130,15,324,-1,165,212,36,-1,165,224,212,-1,227,238,237,-1,227,226,238,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t2disc_Coord',point=[(0,50.96381,-2.17591),(.10926,50.96273,-2.18519),(.12006,50.93409,-2.20623),(.11041,50.96579,-2.17964),(.24792,50.96288,-2.17752),(.24833,50.97619,-2.23044),(.10655,50.97503,-2.08164),(0,50.9663,-2.11945),(0,50.96813,-2.07845),(.37471,50.96943,-2.07533),(.38998,50.96924,-2.15844),(.32762,50.97827,-2.08812),(.30357,50.90727,-1.82499),(.31885,50.8933,-1.82619),(.35995,50.92256,-1.94257),(.39388,50.9714,-2.17257),(.36282,50.82564,-2.20616),(.278,50.82627,-2.22084),(.34004,50.82947,-2.21295),(.37562,50.91074,-2.23784),(0,50.6378,-1.65003),(.11703,50.63773,-1.63325),(0,50.61816,-1.6141),(.36035,50.68082,-1.94068),(.29114,50.67961,-1.95025),(.28559,50.71849,-2.06034),(.01268,50.82253,-2.21371),(.1489,50.86231,-2.23146),(.1472,50.82276,-2.22227),(.24838,50.97369,-2.23633),(.38766,50.98899,-2.21644),(.2542,50.95735,-2.25284),(0,50.91958,-2.19193),(.13246,50.90037,-2.22261),(.26142,50.93527,-2.26546),(.38584,50.967,-2.2293),(.55676,50.8808,-1.98345),(.55693,50.88189,-1.98534),(.55442,50.885,-1.98326),(-.4466,50.6755,-1.93795),(-.44815,50.67561,-1.94053),(-.44279,50.67283,-1.94226),(-.48207,50.80217,-2.22998),(-.48089,50.80597,-2.23179),(-.47606,50.79981,-2.23146),(-.26843,50.91424,-2.27776),(-.3824,50.94077,-2.24676),(-.26142,50.93527,-2.27205),(-.1472,50.82276,-2.2265),(-.278,50.82627,-2.22865),(-.2699,50.90774,-2.27697),(-.371,50.70751,-2.06838),(-.36035,50.68082,-1.95249),(-.29114,50.67961,-1.95994),(-.29557,50.66448,-1.8345),(-.11703,50.63773,-1.63745),(-.24836,50.6517,-1.72055),(-.13441,50.65557,-1.70945),(-.43999,50.86615,-2.23461),(-.36282,50.82564,-2.21621),(-.26179,50.86381,-1.73066),(-.24596,50.87611,-1.73569),(-.30357,50.90727,-1.83373),(-.46441,50.89801,-2.0208),(-.43406,50.86941,-1.96337),(-.35995,50.92256,-1.95247),(-.07591,50.84631,-1.62569),(-.19206,50.83181,-1.64814),(-.07874,50.83204,-1.59402),(-.31885,50.8933,-1.83544),(-.36738,50.85279,-1.84004),(-.24792,50.96288,-2.18384),(-.24833,50.97619,-2.23657),(-.38727,50.99088,-2.22048),(-.10926,50.96273,-2.18802),(-.12006,50.93409,-2.2094),(-.2542,50.95735,-2.25916),(-.10791,50.96174,-2.13466),(-.39388,50.9714,-2.18218),(-.48903,50.97671,-2.18645),(-.4558,50.94733,-2.14791),(-.1092,50.96383,-2.1198),(-.10655,50.97503,-2.08447),(-.38998,50.96924,-2.16804),(-.44494,50.94642,-2.13816),(-.37471,50.96943,-2.08485),(-.19557,50.86303,-1.69115),(-.20709,50.88155,-1.73257),(-.33333,50.93528,-1.95123),(-.37327,50.8206,-2.20946),(-.34004,50.82947,-2.22236),(-.37258,50.76823,-2.16323),(-.45944,50.68808,-2.07007),(-.37562,50.91074,-2.24736),(-.28559,50.71849,-2.06942),(-.01268,50.82253,-2.21408),(-.1489,50.86231,-2.23559),(-.38766,50.98899,-2.2256),(-.24838,50.97369,-2.24245),(-.38584,50.967,-2.23857),(0,50.82037,-2.21009),(0,50.82641,-2.21212),(-.50899,50.84563,-1.92713),(-.50648,50.85019,-1.9287),(-.50939,50.8463,-1.92957),(.46455,50.69037,-2.05273),(.45944,50.68808,-2.05581),(.46514,50.69045,-2.05445),(.49112,50.97466,-2.17857),(.48962,50.97503,-2.17937),(.48903,50.97671,-2.17498),(.3824,50.94077,-2.23736),(.37772,50.91751,-2.2386),(.26843,50.91424,-2.27088),(.2699,50.90774,-2.27002),(.13441,50.65557,-1.70469),(.1433,50.66953,-1.83038),(.29557,50.66448,-1.82442),(.43999,50.86615,-2.22318),(.37327,50.8206,-2.19909),(.14724,50.78181,-2.16595),(.28034,50.76888,-2.16234),(.26179,50.86381,-1.7227),(.46441,50.89801,-2.00837),(.38018,50.93682,-1.98966),(.19206,50.83181,-1.64207),(.19361,50.85063,-1.66517),(.07591,50.84631,-1.62327),(.29428,50.8424,-1.71268),(.36738,50.85279,-1.82919),(.38727,50.99088,-2.21132),(.07874,50.83204,-1.59148),(.43406,50.86941,-1.9512),(.24596,50.87611,-1.72826),(.47606,50.79981,-2.21853),(.24836,50.6517,-1.71187),(.48207,50.80217,-2.21693),(.48089,50.80597,-2.21881),(.4466,50.6755,-1.92357),(.44279,50.67283,-1.92797),(.44815,50.67561,-1.92612),(-.55676,50.8808,-1.99812),(-.55442,50.885,-1.99784),(-.55693,50.88189,-2),(0,50.64769,-1.71227),(-.27788,50.65278,-1.7406),(-.37813,50.65927,-1.83527),(-.46448,50.73686,-2.17789),(-.2494,50.96315,-2.16931),(-.22426,50.8683,-1.70884),(-.32762,50.97827,-2.09645),(-.24204,50.98052,-2.09918),(-.11041,50.96579,-2.1825),(-.29428,50.8424,-1.72171),(-.19361,50.85063,-1.67121),(-.38018,50.93682,-1.99981),(-.28034,50.76888,-2.17072),(-.14724,50.78181,-2.1704),(-.1433,50.66953,-1.83538),(-.37772,50.91751,-2.24811),(-.49112,50.97466,-2.19009),(-.48962,50.97503,-2.19085),(-.46455,50.69037,-2.06711),(-.46514,50.69045,-2.06884),(.50899,50.84563,-1.91287),(.50939,50.8463,-1.91531),(.50648,50.85019,-1.91455),(0,50.87125,-2.20455),(.371,50.70751,-2.05672),(.27788,50.65278,-1.73096),(.37813,50.65927,-1.82259),(.2494,50.96315,-2.16292),(.33333,50.93528,-1.9421),(.44494,50.94642,-2.12705),(.1092,50.96383,-2.1169),(.10791,50.96174,-2.1318),(.36916,50.76528,-1.72864),(.43439,50.83053,-1.79979),(.35319,50.81819,-1.69293),(.44583,50.77806,-1.83645),(.4765,50.94256,-2.1995),(.49288,50.91917,-2.19798),(.24204,50.98052,-2.09293),(.38912,50.95497,-2.03768),(.47486,50.92486,-2.07613),(0,50.92955,-1.85254),(.08089,50.89725,-1.73357),(.08679,50.92357,-1.84887),(0,50.90299,-1.73978),(.19557,50.86303,-1.68511),(.20709,50.88155,-1.7263),(.07814,50.8574,-1.64218),(.08114,50.8259,-1.57827),(.18758,50.81758,-1.59251),(.19458,50.82512,-1.62939),(.08508,50.81749,-1.54425),(.23637,50.85622,-1.68945),(.25079,50.838,-1.6711),(.34001,50.97495,-2.045),(.3036,50.97877,-2.05986),(.22426,50.8683,-1.70199),(0,50.96428,-2.13435),(.44613,50.86291,-1.94667),(.47807,50.89318,-2.00617),(.25807,50.83071,-1.66118),(.143,50.7288,-2.06989),(.37258,50.76823,-2.15229),(0,50.68975,-1.9696),(.14406,50.68933,-1.96222),(0,50.66913,-1.83747),(0,50.78898,-2.17063),(.53617,50.83131,-2.04445),(.53445,50.81491,-2.00575),(.38205,50.66217,-1.81824),(.28419,50.7062,-1.68902),(.28109,50.65566,-1.72584),(.37857,50.7108,-1.77164),(.4867,50.73769,-2.00642),(.50274,50.74898,-2.03043),(.54656,50.88151,-2.12258),(.48916,50.85955,-2.21212),(.51718,50.83964,-2.173),(.49686,50.78786,-1.91435),(.47567,50.72857,-1.91904),(.50233,50.79194,-1.95864),(.23446,50.70374,-1.66135),(.2828,50.7629,-1.65703),(.21379,50.759,-1.62133),(.46107,50.90543,-2.21493),(.44596,50.87041,-2.22288),(0,50.9672,-2.17088),(.14593,50.86884,-2.23151),(.46448,50.73686,-2.16437),(.46986,50.7379,-2.16193),(.43116,50.83496,-1.80046),(.35076,50.82295,-1.69448),(.2746,50.82285,-1.6357),(.1891,50.81293,-1.59024),(.27701,50.81825,-1.63407),(.08557,50.81278,-1.54164),(0,50.8101,-1.53989),(0,50.80536,-1.53717),(-.08557,50.81278,-1.54442),(-.18758,50.81758,-1.59851),(-.1891,50.81293,-1.5963),(-.08508,50.81749,-1.54701),(-.35076,50.82295,-1.70523),(-.27701,50.81825,-1.64276),(-.2746,50.82285,-1.6443),(-.35319,50.81819,-1.70378),(-.43439,50.83053,-1.81262),(-.43116,50.83496,-1.81316),(-.46986,50.7379,-2.17559),(-.44596,50.87041,-2.2344),(-.4765,50.94256,-2.211),(-.46107,50.90543,-2.22645),(-.14593,50.86884,-2.23554),(-.13246,50.90037,-2.22619),(-.1107,50.69457,-1.59552),(-.21379,50.759,-1.6284),(-.23446,50.70374,-1.66933),(-.09933,50.75463,-1.56508),(-.47567,50.72857,-1.93371),(-.44583,50.77806,-1.85003),(-.49686,50.78786,-1.92896),(-.44986,50.72391,-1.8934),(-.53617,50.83131,-2.05908),(-.51718,50.83964,-2.18661),(-.50611,50.78163,-2.11987),(-.54656,50.88151,-2.13652),(-.50274,50.74898,-2.04526),(-.37857,50.7108,-1.784),(-.38205,50.66217,-1.83102),(0,50.67914,-1.57896),(-.11805,50.64005,-1.63179),(0,50.61992,-1.60891),(-.14406,50.68933,-1.96709),(-.143,50.7288,-2.0745),(0,50.73295,-2.07698),(-.25807,50.83071,-1.66924),(-.30533,50.83486,-1.71668),(-.25079,50.838,-1.67891),(-.47807,50.89318,-2.01896),(-.47486,50.92486,-2.08828),(-.48887,50.9225,-2.09105),(-.23637,50.85622,-1.69673),(-.34866,50.96546,-2.03312),(-.38912,50.95497,-2.04776),(-.34001,50.97495,-2.05375),(-.10529,50.979,-2.06099),(0,50.97477,-2.0545),(-.08114,50.8259,-1.58089),(0,50.81764,-1.56806),(-.08679,50.92357,-1.85142),(-.21586,50.91457,-1.84005),(-.08089,50.89725,-1.73603),(-.22939,50.94905,-1.95966),(-.56394,50.92491,-2.08263),(-.34126,50.95067,-1.994),(-.3036,50.97877,-2.06769),(-.36916,50.76528,-1.74034),(-.49288,50.91917,-2.21007),(-.09477,50.95586,-1.9682),(-.23968,50.98156,-2.0726),(-.44613,50.86291,-1.95921),(0,50.84721,-1.62015),(0,50.82414,-1.58133),(-.19458,50.82512,-1.63558),(-.53445,50.81491,-2.02068),(-.28419,50.7062,-1.69858),(-.28109,50.65566,-1.73556),(-.4867,50.73769,-2.02105),(-.48916,50.85955,-2.22473),(-.50233,50.79194,-1.97322),(-.2828,50.7629,-1.66622),(-.56687,50.92189,-2.08514),(-.25098,50.65443,-1.71537),(.11805,50.64005,-1.62756),(.25098,50.65443,-1.70662),(.56394,50.92491,-2.06868),(.56687,50.92189,-2.07111),(0,50.74352,-1.55418),(.09933,50.75463,-1.56173),(.3811,50.84577,-1.82767),(.4558,50.94733,-2.13663),(0,50.85836,-1.63887),(.34126,50.95067,-1.98488),(.23968,50.98156,-2.06636),(.30533,50.83486,-1.70729),(0,50.95996,-1.96905),(.09477,50.95586,-1.96556),(.22939,50.94905,-1.95332),(.10529,50.979,-2.05819),(.48887,50.9225,-2.07859),(.34866,50.96546,-2.02404),(.21586,50.91457,-1.83375),(.1107,50.69457,-1.59167),(.44986,50.72391,-1.87929),(.50611,50.78163,-2.10558),(-.3811,50.84577,-1.83894),(-.07814,50.8574,-1.64464)]))),
        Shape(DEF='t3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,9,-1,29,21,23,-1,30,31,32,-1,33,34,35,-1,36,37,35,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,44,-1,49,50,51,-1,52,53,54,-1,55,56,52,-1,57,58,59,-1,60,61,59,-1,62,19,63,-1,64,65,66,-1,67,68,64,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,77,78,79,-1,80,81,82,-1,83,81,84,-1,85,86,87,-1,88,89,90,-1,91,35,34,-1,92,93,94,-1,95,20,19,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,104,106,-1,107,108,109,-1,110,111,112,-1,113,80,114,-1,115,116,117,-1,118,82,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,85,139,-1,140,141,142,-1,143,144,12,-1,145,146,147,-1,148,149,150,-1,151,152,149,-1,151,153,152,-1,154,155,153,-1,156,157,158,-1,159,160,2,-1,161,159,162,-1,163,1,164,-1,165,166,167,-1,168,169,170,-1,171,156,172,-1,117,165,173,-1,157,160,174,-1,175,176,177,-1,161,162,178,-1,61,18,179,-1,180,181,182,-1,183,184,185,-1,186,187,188,-1,189,190,191,-1,192,193,194,-1,103,195,196,-1,197,198,199,-1,200,201,65,-1,201,202,65,-1,182,203,204,-1,106,205,206,-1,207,208,209,-1,68,185,76,-1,210,211,206,-1,212,213,214,-1,215,216,217,-1,195,218,219,-1,220,221,36,-1,222,223,224,-1,204,225,226,-1,227,228,229,-1,230,231,232,-1,81,190,115,-1,233,234,191,-1,185,235,76,-1,236,237,238,-1,239,240,241,-1,242,243,244,-1,245,244,246,-1,247,248,183,-1,249,168,250,-1,251,252,253,-1,254,186,188,-1,255,256,257,-1,132,134,258,-1,259,260,261,-1,262,263,174,-1,175,177,264,-1,265,266,267,-1,268,240,269,-1,270,271,272,-1,273,274,275,-1,276,277,278,-1,279,122,121,-1,114,124,123,-1,275,280,281,-1,275,282,283,-1,284,250,285,-1,283,282,286,-1,198,197,201,-1,287,288,289,-1,288,290,291,-1,292,293,236,-1,294,295,296,-1,297,298,299,-1,300,297,301,-1,302,303,304,-1,305,306,307,-1,308,309,310,-1,311,312,313,-1,314,315,316,-1,317,314,318,-1,319,320,321,-1,322,323,324,-1,325,326,327,-1,328,329,330,-1,329,328,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,38,-1,343,344,318,-1,345,346,347,-1,348,346,349,-1,328,350,351,-1,352,353,354,-1,355,356,357,-1,358,359,360,-1,361,362,363,-1,364,365,366,-1,367,368,369,-1,370,371,372,-1,373,374,375,-1,376,377,378,-1,379,380,381,-1,379,382,383,-1,384,385,386,-1,387,388,384,-1,389,390,391,-1,392,393,109,-1,394,370,395,-1,396,307,397,-1,306,398,399,-1,400,401,402,-1,403,404,405,-1,406,407,408,-1,409,410,411,-1,412,413,414,-1,415,416,417,-1,25,418,419,-1,420,421,422,-1,331,423,424,-1,425,330,329,-1,426,311,427,-1,428,429,430,-1,431,432,433,-1,434,420,435,-1,435,436,427,-1,4,3,437,-1,438,439,4,-1,440,5,441,-1,442,443,438,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,451,-1,457,456,461,-1,304,462,463,-1,464,295,301,-1,296,465,466,-1,297,300,467,-1,468,48,469,-1,470,471,472,-1,473,474,475,-1,476,477,478,-1,479,480,481,-1,482,483,54,-1,484,485,486,-1,393,391,390,-1,376,487,488,-1,377,488,489,-1,490,491,492,-1,493,494,495,-1,382,379,496,-1,497,385,498,-1,383,499,500,-1,394,413,501,-1,412,414,502,-1,503,383,366,-1,504,405,505,-1,506,507,508,-1,373,509,510,-1,511,512,513,-1,388,514,358,-1,515,516,517,-1,518,359,519,-1,332,511,306,-1,520,521,522,-1,305,402,332,-1,32,523,524,-1,31,525,526,-1,527,27,528,-1,529,530,531,-1,529,528,530,-1,532,304,303,-1,533,534,335,-1,535,536,537,-1,535,335,538,-1,54,337,336,-1,532,55,539,-1,531,26,419,-1,529,540,527,-1,541,542,543,-1,24,533,537,-1,544,545,546,-1,547,522,548,-1,549,550,522,-1,538,551,333,-1,552,553,517,-1,552,410,553,-1,553,554,555,-1,556,557,515,-1,555,554,558,-1,555,559,387,-1,560,360,561,-1,16,15,562,-1,90,563,564,-1,565,566,567,-1,507,568,548,-1,569,570,24,-1,571,572,504,-1,101,394,501,-1,573,574,575,-1,403,576,382,-1,381,577,497,-1,487,404,488,-1,486,557,484,-1,578,579,512,-1,426,378,580,-1,581,582,580,-1,582,583,584,-1,585,586,587,-1,588,589,590,-1,591,592,338,-1,593,42,594,-1,595,475,356,-1,17,16,470,-1,141,299,469,-1,463,462,596,-1,597,459,449,-1,598,448,447,-1,442,446,598,-1,314,444,442,-1,5,4,439,-1,430,347,599,-1,5,440,329,-1,433,432,600,-1,601,602,603,-1,604,605,606,-1,599,607,608,-1,609,610,320,-1,611,612,322,-1,613,614,10,-1,615,327,616,-1,617,618,619,-1,416,620,621,-1,364,622,623,-1,624,625,626,-1,627,628,629,-1,630,631,358,-1,632,633,508,-1,576,403,405,-1,31,543,542,-1,396,523,402,-1,577,408,386,-1,544,519,558,-1,389,634,390,-1,634,107,390,-1,497,386,385,-1,576,499,383,-1,622,635,623,-1,380,379,503,-1,377,631,378,-1,367,636,637,-1,638,639,640,-1,641,642,643,-1,644,230,564,-1,560,581,630,-1,519,359,514,-1,409,558,554,-1,353,319,645,-1,616,327,326,-1,646,647,611,-1,608,330,425,-1,648,457,349,-1,460,458,648,-1,411,410,248,-1,342,341,42,-1,649,650,433,-1,417,614,628,-1,610,651,652,-1,653,462,304,-1,471,470,654,-1,655,538,333,-1,322,423,323,-1,350,330,608,-1,607,453,327,-1,609,319,353,-1,320,656,611,-1,434,427,316,-1,600,317,657,-1,584,658,312,-1,578,659,588,-1,660,310,661,-1,662,661,663,-1,664,433,665,-1,666,605,667,-1,668,669,480,-1,309,308,480,-1,305,307,396,-1,301,299,464,-1,616,670,351,-1,587,671,343,-1,587,590,671,-1,273,281,261,-1,672,48,47,-1,673,140,672,-1,287,289,140,-1,674,13,144,-1,302,143,255,-1,250,675,126,-1,676,677,170,-1,274,678,286,-1,173,679,122,-1,154,680,272,-1,681,482,682,-1,278,277,680,-1,683,268,267,-1,683,684,268,-1,685,175,264,-1,174,686,262,-1,260,687,273,-1,688,689,84,-1,53,50,49,-1,690,691,692,-1,693,272,680,-1,694,172,695,-1,696,697,698,-1,187,699,696,-1,700,241,701,-1,702,703,704,-1,83,191,190,-1,705,706,707,-1,705,707,708,-1,227,709,228,-1,710,204,226,-1,711,96,219,-1,712,713,714,-1,105,222,224,-1,218,102,224,-1,212,205,213,-1,72,715,716,-1,717,718,719,-1,392,109,720,-1,100,204,710,-1,201,721,202,-1,689,200,65,-1,199,722,723,-1,103,196,724,-1,718,206,211,-1,182,204,100,-1,725,625,624,-1,726,727,728,-1,729,730,731,-1,264,732,292,-1,8,22,21,-1,241,268,733,-1,269,697,696,-1,177,176,158,-1,676,734,735,-1,736,737,738,-1,168,249,278,-1,701,739,700,-1,155,0,152,-1,153,151,740,-1,741,742,695,-1,743,744,145,-1,745,746,175,-1,243,747,246,-1,145,748,245,-1,243,749,747,-1,743,750,751,-1,743,147,750,-1,675,250,677,-1,291,14,13,-1,142,48,672,-1,752,288,753,-1,754,673,755,-1,756,757,47,-1,756,47,44,-1,129,691,252,-1,758,759,285,-1,760,123,761,-1,690,762,682,-1,54,53,763,-1,112,111,764,-1,111,110,765,-1,720,108,208,-1,766,216,215,-1,767,766,768,-1,205,715,210,-1,209,769,770,-1,770,771,717,-1,718,717,772,-1,102,104,224,-1,106,103,214,-1,218,773,774,-1,180,775,776,-1,777,778,573,-1,773,218,223,-1,97,779,196,-1,193,94,217,-1,780,781,714,-1,139,87,95,-1,273,687,688,-1,64,68,782,-1,260,198,200,-1,69,783,784,-1,260,259,199,-1,785,723,786,-1,787,788,789,-1,790,791,792,-1,60,793,18,-1,303,255,56,-1,794,51,795,-1,51,50,795,-1,63,51,794,-1,796,797,798,-1,475,799,45,-1,800,801,802,-1,803,41,43,-1,635,804,566,-1,566,565,805,-1,536,401,541,-1,806,786,788,-1,530,15,569,-1,25,24,537,-1,19,18,793,-1,86,29,23,-1,20,87,57,-1,20,95,87,-1,464,596,462,-1,419,418,807,-1,9,11,621,-1,6,808,809,-1,0,155,1,-1,155,164,1,-1,809,254,6,-1,621,810,9,-1,526,525,527,-1,462,811,464,-1,20,57,179,-1,86,23,792,-1,63,19,793,-1,812,25,537,-1,26,530,569,-1,810,27,9,-1,566,805,813,-1,635,566,813,-1,43,131,803,-1,800,474,801,-1,45,356,475,-1,796,798,802,-1,63,814,51,-1,56,55,303,-1,61,60,18,-1,792,23,790,-1,787,789,815,-1,786,816,785,-1,199,198,260,-1,69,817,783,-1,200,687,260,-1,782,233,64,-1,273,688,113,-1,139,85,87,-1,714,818,780,-1,779,193,217,-1,196,779,217,-1,196,98,97,-1,707,773,223,-1,573,819,777,-1,180,776,181,-1,100,99,182,-1,218,774,219,-1,213,106,214,-1,106,104,103,-1,770,717,719,-1,770,820,209,-1,205,210,206,-1,189,767,768,-1,766,215,768,-1,821,720,765,-1,112,764,74,-1,763,482,54,-1,822,690,682,-1,274,282,275,-1,285,126,758,-1,760,823,123,-1,758,283,759,-1,135,137,798,-1,138,824,258,-1,757,825,47,-1,754,287,673,-1,752,290,288,-1,13,289,291,-1,255,143,12,-1,676,675,677,-1,243,242,749,-1,245,146,145,-1,747,826,246,-1,745,175,685,-1,743,148,744,-1,827,153,740,-1,152,153,155,-1,160,828,2,-1,701,163,739,-1,278,169,168,-1,738,751,736,-1,704,829,830,-1,158,831,177,-1,696,265,269,-1,241,240,268,-1,8,21,808,-1,292,238,264,-1,832,729,731,-1,728,809,726,-1,705,221,220,-1,725,624,833,-1,719,718,211,-1,199,723,785,-1,65,64,689,-1,201,197,721,-1,68,67,185,-1,718,834,206,-1,716,715,205,-1,79,716,212,-1,716,79,72,-1,212,716,205,-1,835,836,837,-1,218,224,223,-1,105,224,104,-1,167,739,164,-1,714,781,712,-1,219,774,711,-1,710,226,838,-1,709,708,228,-1,706,773,707,-1,839,840,841,-1,83,233,191,-1,756,44,46,-1,702,266,703,-1,700,842,241,-1,696,698,187,-1,701,178,162,-1,172,156,695,-1,694,695,742,-1,693,680,843,-1,693,679,272,-1,690,692,762,-1,53,52,50,-1,260,273,261,-1,159,161,686,-1,174,159,686,-1,685,264,237,-1,684,733,268,-1,268,269,267,-1,278,680,154,-1,271,154,272,-1,279,173,122,-1,286,282,274,-1,676,170,734,-1,758,822,283,-1,250,126,285,-1,198,201,200,-1,255,303,302,-1,673,287,140,-1,825,673,672,-1,672,47,825,-1,587,586,590,-1,616,844,670,-1,294,300,295,-1,300,301,295,-1,309,480,479,-1,480,308,668,-1,668,551,483,-1,483,669,668,-1,659,660,588,-1,658,585,312,-1,657,649,600,-1,316,315,434,-1,611,321,320,-1,609,320,319,-1,607,327,845,-1,846,350,608,-1,332,655,333,-1,654,478,471,-1,304,847,653,-1,627,417,628,-1,340,339,848,-1,650,665,433,-1,42,593,342,-1,452,648,349,-1,425,599,608,-1,647,612,611,-1,326,844,616,-1,645,354,353,-1,554,553,409,-1,359,358,514,-1,630,360,560,-1,230,232,564,-1,849,641,643,-1,367,637,368,-1,395,372,850,-1,631,580,378,-1,503,851,380,-1,383,382,576,-1,388,498,385,-1,852,408,407,-1,544,558,409,-1,853,854,391,-1,386,497,577,-1,413,395,636,-1,402,305,396,-1,31,526,543,-1,405,572,576,-1,508,548,632,-1,631,489,358,-1,629,855,627,-1,413,394,395,-1,626,856,624,-1,416,857,620,-1,619,415,617,-1,615,845,327,-1,614,11,10,-1,611,322,321,-1,610,656,320,-1,599,858,607,-1,859,860,861,-1,666,601,603,-1,433,600,649,-1,425,430,599,-1,441,5,439,-1,314,442,438,-1,442,598,443,-1,862,598,447,-1,457,648,458,-1,597,449,863,-1,141,469,142,-1,17,470,472,-1,355,595,356,-1,864,593,594,-1,591,865,592,-1,588,660,589,-1,587,312,585,-1,583,658,584,-1,582,426,580,-1,426,436,378,-1,512,659,578,-1,486,516,557,-1,485,866,853,-1,497,496,381,-1,382,496,403,-1,574,493,575,-1,101,501,867,-1,571,868,572,-1,570,869,24,-1,548,508,507,-1,567,870,565,-1,90,564,232,-1,620,470,16,-1,562,620,16,-1,360,398,561,-1,871,555,387,-1,558,559,555,-1,515,872,556,-1,522,547,549,-1,546,518,544,-1,546,399,518,-1,24,869,533,-1,541,543,873,-1,529,531,540,-1,531,530,26,-1,532,539,336,-1,336,539,54,-1,535,538,655,-1,537,533,535,-1,535,533,335,-1,532,303,55,-1,527,528,529,-1,31,874,525,-1,32,400,523,-1,402,655,332,-1,522,550,520,-1,332,306,305,-1,518,519,544,-1,515,557,516,-1,388,358,489,-1,511,334,512,-1,570,569,15,-1,373,510,875,-1,508,505,506,-1,505,405,506,-1,504,572,405,-1,366,365,503,-1,502,876,412,-1,500,366,383,-1,494,877,495,-1,489,631,377,-1,488,377,376,-1,878,485,393,-1,483,337,54,-1,879,668,308,-1,880,481,592,-1,481,880,479,-1,593,848,342,-1,881,882,473,-1,478,654,476,-1,595,473,475,-1,355,357,468,-1,468,469,298,-1,467,883,297,-1,296,466,294,-1,142,469,48,-1,464,811,295,-1,884,885,618,-1,884,863,885,-1,461,349,457,-1,459,597,460,-1,458,886,456,-1,455,325,453,-1,345,450,452,-1,449,459,447,-1,348,347,346,-1,446,442,444,-1,443,439,438,-1,4,437,438,-1,3,887,437,-1,427,434,435,-1,433,664,431,-1,430,888,428,-1,427,436,426,-1,329,440,425,-1,420,887,421,-1,25,419,26,-1,416,621,417,-1,409,553,410,-1,490,406,408,-1,402,523,400,-1,398,518,399,-1,307,889,397,-1,544,409,545,-1,490,408,577,-1,384,386,890,-1,391,854,389,-1,492,406,490,-1,384,388,385,-1,643,642,891,-1,383,503,379,-1,381,496,379,-1,378,892,376,-1,375,509,373,-1,372,395,370,-1,893,367,369,-1,364,369,365,-1,639,364,366,-1,360,630,358,-1,354,861,352,-1,328,351,670,-1,610,652,855,-1,894,424,423,-1,429,347,430,-1,348,349,461,-1,347,429,345,-1,38,40,341,-1,340,591,338,-1,337,538,335,-1,513,561,398,-1,334,511,332,-1,330,350,328,-1,327,453,325,-1,324,321,322,-1,321,324,319,-1,317,600,314,-1,681,895,482,-1,316,318,314,-1,311,584,312,-1,879,308,310,-1,481,480,39,-1,302,304,463,-1,674,596,464,-1,297,299,301,-1,298,469,299,-1,334,333,551,-1,238,292,236,-1,289,13,140,-1,288,291,289,-1,286,759,283,-1,284,285,759,-1,275,283,280,-1,736,896,735,-1,677,250,168,-1,823,760,897,-1,123,823,678,-1,280,763,281,-1,123,898,114,-1,121,118,279,-1,276,278,249,-1,273,275,281,-1,270,272,165,-1,240,697,269,-1,269,265,267,-1,177,732,264,-1,263,831,174,-1,733,684,178,-1,261,49,259,-1,134,138,258,-1,255,12,256,-1,696,699,899,-1,188,6,254,-1,284,249,250,-1,244,900,242,-1,842,239,241,-1,237,264,238,-1,185,184,235,-1,233,782,234,-1,81,83,190,-1,231,88,232,-1,901,835,837,-1,901,711,835,-1,902,903,706,-1,229,203,227,-1,222,904,223,-1,195,102,218,-1,215,217,712,-1,106,213,205,-1,634,905,107,-1,905,108,107,-1,76,782,68,-1,206,834,106,-1,197,199,785,-1,195,98,196,-1,192,92,193,-1,191,767,189,-1,187,698,188,-1,185,247,183,-1,730,254,809,-1,809,728,730,-1,61,179,59,-1,175,746,176,-1,160,159,174,-1,117,166,165,-1,171,906,156,-1,677,168,170,-1,165,167,270,-1,166,907,167,-1,164,739,163,-1,159,2,162,-1,156,158,695,-1,163,2,1,-1,153,827,154,-1,150,744,148,-1,243,246,244,-1,145,147,743,-1,140,142,672,-1,139,824,138,-1,136,908,137,-1,132,909,133,-1,910,135,911,-1,130,803,131,-1,128,912,126,-1,123,125,761,-1,120,122,913,-1,119,279,118,-1,119,115,117,-1,113,114,898,-1,112,914,110,-1,765,207,915,-1,108,720,109,-1,216,766,724,-1,834,105,106,-1,102,195,103,-1,101,867,99,-1,96,916,97,-1,19,62,95,-1,193,92,94,-1,91,34,917,-1,90,232,88,-1,726,85,138,-1,85,726,86,-1,84,689,83,-1,80,84,81,-1,79,75,77,-1,76,235,77,-1,73,112,74,-1,183,918,184,-1,183,919,918,-1,49,261,281,-1,69,784,70,-1,71,92,69,-1,64,66,67,-1,62,63,794,-1,59,179,57,-1,55,52,539,-1,539,52,54,-1,51,259,49,-1,48,920,44,-1,44,920,45,-1,41,594,42,-1,473,801,474,-1,39,895,40,-1,35,921,36,-1,35,37,33,-1,722,814,922,-1,27,874,28,-1,569,24,26,-1,22,787,23,-1,179,18,20,-1,17,570,15,-1,12,144,13,-1,923,924,790,-1,9,28,10,-1,8,808,6,-1,828,0,2,-1,540,873,543,-1,873,540,807,-1,95,925,139,-1,95,256,925,-1,792,87,86,-1,87,792,57,-1,793,814,63,-1,793,922,814,-1,15,528,562,-1,530,528,15,-1,926,565,563,-1,565,926,805,-1,803,796,41,-1,796,803,797,-1,341,43,42,-1,43,341,927,-1,802,137,800,-1,137,802,798,-1,799,46,45,-1,46,799,908,-1,793,928,922,-1,60,928,793,-1,928,929,922,-1,929,928,923,-1,930,931,932,-1,931,930,933,-1,784,934,70,-1,784,935,934,-1,763,49,281,-1,763,53,49,-1,936,919,937,-1,938,919,936,-1,938,939,940,-1,938,936,939,-1,918,78,184,-1,78,918,73,-1,941,780,907,-1,781,780,941,-1,942,97,916,-1,194,97,942,-1,943,624,944,-1,833,624,943,-1,777,945,778,-1,777,946,945,-1,227,776,709,-1,181,776,227,-1,947,948,949,-1,947,950,948,-1,951,947,952,-1,951,945,947,-1,724,214,103,-1,766,214,724,-1,952,953,951,-1,953,952,954,-1,955,953,956,-1,953,955,957,-1,769,771,770,-1,769,956,771,-1,958,209,905,-1,769,209,958,-1,766,212,214,-1,767,212,766,-1,939,821,940,-1,959,821,939,-1,110,821,765,-1,110,940,821,-1,280,822,682,-1,283,822,280,-1,113,84,80,-1,688,84,113,-1,276,284,897,-1,249,284,276,-1,253,691,690,-1,691,253,252,-1,960,130,129,-1,960,961,130,-1,133,962,963,-1,133,127,962,-1,964,727,963,-1,727,964,728,-1,965,910,961,-1,966,910,965,-1,136,757,756,-1,136,966,757,-1,967,752,753,-1,968,752,967,-1,673,757,755,-1,673,825,757,-1,962,676,969,-1,676,962,675,-1,731,728,964,-1,731,730,728,-1,970,147,146,-1,970,971,147,-1,244,748,900,-1,245,748,244,-1,899,265,696,-1,972,265,899,-1,735,969,676,-1,735,896,969,-1,743,738,148,-1,751,738,743,-1,750,736,751,-1,896,736,750,-1,167,700,739,-1,167,973,700,-1,827,278,154,-1,278,827,169,-1,776,221,709,-1,776,974,221,-1,816,806,975,-1,786,806,816,-1,976,71,70,-1,976,977,71,-1,932,248,247,-1,932,931,248,-1,915,209,820,-1,209,915,207,-1,706,220,902,-1,705,220,706,-1,215,781,941,-1,215,712,781,-1,973,842,700,-1,978,842,973,-1,231,979,783,-1,979,231,230,-1,901,96,711,-1,916,96,901,-1,840,917,841,-1,840,91,917,-1,229,950,225,-1,229,948,950,-1,773,903,774,-1,706,903,773,-1,91,980,981,-1,840,980,91,-1,262,293,263,-1,262,982,293,-1,163,162,2,-1,163,701,162,-1,176,749,741,-1,176,746,749,-1,158,741,695,-1,176,741,158,-1,909,968,983,-1,909,132,968,-1,795,52,56,-1,52,795,50,-1,686,178,684,-1,686,161,178,-1,830,267,984,-1,830,683,267,-1,272,173,165,-1,173,272,679,-1,760,276,897,-1,760,985,276,-1,738,740,151,-1,740,738,737,-1,737,170,740,-1,737,734,170,-1,674,140,13,-1,674,141,140,-1,693,986,987,-1,693,843,986,-1,590,662,671,-1,590,589,662,-1,650,309,479,-1,650,663,309,-1,606,666,603,-1,666,606,605,-1,604,431,664,-1,604,606,431,-1,661,309,663,-1,661,310,309,-1,588,658,578,-1,658,588,585,-1,310,659,879,-1,310,660,659,-1,988,353,352,-1,988,609,353,-1,471,989,465,-1,478,989,471,-1,472,465,296,-1,472,471,465,-1,990,613,875,-1,990,991,613,-1,338,481,39,-1,481,338,592,-1,888,441,992,-1,888,440,441,-1,861,326,352,-1,844,326,861,-1,423,612,894,-1,423,322,612,-1,855,656,610,-1,855,629,656,-1,612,421,894,-1,647,421,612,-1,642,993,994,-1,641,993,642,-1,995,368,637,-1,368,995,996,-1,371,819,997,-1,371,998,819,-1,850,636,395,-1,636,850,637,-1,571,993,641,-1,571,999,993,-1,633,361,999,-1,633,632,361,-1,510,990,875,-1,990,510,422,-1,576,868,499,-1,576,572,868,-1,374,506,375,-1,374,507,506,-1,1000,1001,407,-1,1000,866,1001,-1,411,545,409,-1,1002,545,411,-1,556,890,852,-1,556,872,890,-1,549,1003,934,-1,1004,1003,549,-1,30,524,1005,-1,30,32,524,-1,623,502,893,-1,502,623,1006,-1,875,10,1005,-1,10,875,613,-1,454,607,858,-1,454,453,607,-1,450,862,447,-1,450,428,862,-1,455,886,651,-1,455,456,886,-1,863,601,885,-1,863,449,601,-1,1007,884,1008,-1,1007,1009,884,-1,1010,664,665,-1,1010,604,664,-1,1011,883,1012,-1,1013,883,1011,-1,881,1012,1014,-1,881,1011,1012,-1,857,1015,1016,-1,857,416,1015,-1,1017,476,1016,-1,476,1017,865,-1,864,1018,593,-1,1018,864,1014,-1,1019,864,594,-1,1019,882,864,-1,339,39,38,-1,339,338,39,-1,661,589,660,-1,661,662,589,-1,344,317,318,-1,344,1020,317,-1,378,435,892,-1,436,435,378,-1,578,583,579,-1,658,583,578,-1,895,1021,40,-1,895,681,1021,-1,852,386,408,-1,890,386,852,-1,634,1022,1023,-1,634,389,1022,-1,1024,492,1025,-1,1024,406,492,-1,1026,494,1027,-1,1026,1028,494,-1,1029,1030,1031,-1,1032,1030,1029,-1,1033,1034,1032,-1,1034,1033,1035,-1,626,1036,1037,-1,1036,626,625,-1,805,856,1038,-1,856,805,926,-1,404,506,405,-1,404,487,506,-1,994,804,1039,-1,567,804,994,-1,804,567,566,-1,435,422,510,-1,435,420,422,-1,620,810,621,-1,620,562,810,-1,387,515,871,-1,387,872,515,-1,1040,517,516,-1,552,517,1040,-1,520,935,979,-1,520,550,935,-1,1002,546,545,-1,1002,1041,546,-1,1004,933,1003,-1,1041,933,1004,-1,402,535,655,-1,402,536,535,-1,402,401,536,-1,873,812,541,-1,873,807,812,-1,533,847,534,-1,847,533,869,-1,522,632,548,-1,522,521,632,-1,889,546,1042,-1,399,546,889,-1,560,579,583,-1,561,579,560,-1,510,892,435,-1,510,509,892,-1,504,999,571,-1,504,633,999,-1,624,926,944,-1,624,856,926,-1,1034,997,575,-1,997,1034,1035,-1,502,367,893,-1,502,414,367,-1,995,1032,1029,-1,1033,1032,995,-1,1034,1030,1032,-1,1034,495,1030,-1,491,380,1031,-1,380,491,381,-1,574,494,493,-1,574,1027,494,-1,491,1025,492,-1,491,1043,1025,-1,1028,1023,1022,-1,1026,1023,1028,-1,1024,407,406,-1,407,1024,1000,-1,390,109,393,-1,390,107,109,-1,878,486,485,-1,1044,486,878,-1,39,669,895,-1,39,480,669,-1,561,512,579,-1,561,513,512,-1,1045,671,662,-1,1045,1020,671,-1,882,801,473,-1,882,1019,801,-1,1046,593,1018,-1,1046,848,593,-1,1010,865,1017,-1,1010,592,865,-1,1016,654,857,-1,476,654,1016,-1,1014,1047,1018,-1,1014,1012,1047,-1,1013,595,355,-1,1011,595,1013,-1,465,1048,466,-1,465,989,1048,-1,1013,297,883,-1,298,297,1013,-1,604,1017,1049,-1,604,1010,1017,-1,416,619,1015,-1,619,416,415,-1,863,1009,597,-1,1009,863,884,-1,451,648,452,-1,451,460,648,-1,609,651,610,-1,609,988,651,-1,1049,605,604,-1,605,1049,667,-1,602,449,448,-1,602,601,449,-1,438,315,314,-1,437,315,438,-1,844,860,670,-1,860,844,861,-1,354,859,861,-1,354,645,859,-1,646,990,647,-1,991,990,646,-1,501,412,1037,-1,501,413,412,-1,937,410,552,-1,248,410,937,-1,568,396,397,-1,1050,396,568,-1,1051,394,101,-1,394,1051,370,-1,580,630,581,-1,580,631,630,-1,387,514,388,-1,559,514,387,-1,407,556,852,-1,407,1001,556,-1,507,1050,568,-1,374,1050,507,-1,622,639,638,-1,622,364,639,-1,524,374,373,-1,1050,374,524,-1,361,521,362,-1,632,521,361,-1,999,363,993,-1,999,361,363,-1,1051,371,370,-1,1051,998,371,-1,372,997,1035,-1,372,371,997,-1,996,369,368,-1,369,996,365,-1,993,567,994,-1,993,363,567,-1,652,886,1007,-1,651,886,652,-1,456,454,461,-1,454,456,455,-1,348,599,347,-1,348,858,599,-1,296,17,472,-1,17,296,1052,-1,352,325,988,-1,325,352,326,-1,629,991,646,-1,991,629,628,-1,311,316,427,-1,311,313,316,-1,299,674,464,-1,141,674,299,-1,1020,343,671,-1,344,343,1020,-1,286,284,759,-1,897,284,286,-1,736,734,737,-1,736,735,734,-1,151,148,738,-1,148,151,149,-1,682,763,280,-1,482,763,682,-1,240,698,697,-1,240,239,698,-1,263,177,831,-1,177,263,732,-1,795,255,257,-1,56,255,795,-1,983,128,909,-1,251,128,983,-1,809,21,29,-1,21,809,808,-1,758,912,822,-1,758,126,912,-1,694,242,900,-1,694,742,242,-1,828,906,1053,-1,906,828,160,-1,237,704,703,-1,237,236,704,-1,241,178,701,-1,241,733,178,-1,686,982,262,-1,686,1054,982,-1,782,75,234,-1,782,76,75,-1,841,88,231,-1,841,917,88,-1,774,835,711,-1,774,903,835,-1,946,225,950,-1,226,225,946,-1,980,916,901,-1,942,916,980,-1,839,194,942,-1,192,194,839,-1,978,780,818,-1,978,973,780,-1,164,270,167,-1,164,271,270,-1,96,195,219,-1,98,195,96,-1,217,713,712,-1,713,217,94,-1,208,905,209,-1,905,208,108,-1,67,247,185,-1,67,932,247,-1,715,74,210,-1,74,715,72,-1,1003,70,934,-1,1003,976,70,-1,22,975,806,-1,22,8,975,-1,776,1055,974,-1,776,775,1055,-1,978,239,842,-1,978,1056,239,-1,829,236,1054,-1,704,236,829,-1,830,702,704,-1,830,984,702,-1,160,156,906,-1,160,157,156,-1,152,150,149,-1,152,1053,150,-1,826,745,899,-1,745,826,747,-1,971,1057,1058,-1,1057,971,970,-1,256,62,257,-1,256,95,62,-1,1059,753,754,-1,967,753,1059,-1,966,135,910,-1,136,135,966,-1,983,967,1060,-1,967,983,968,-1,731,969,896,-1,731,964,969,-1,909,127,133,-1,127,909,128,-1,961,911,130,-1,961,910,911,-1,985,277,276,-1,986,277,985,-1,277,843,680,-1,986,843,277,-1,907,1061,941,-1,907,166,1061,-1,82,114,80,-1,82,118,114,-1,958,634,1023,-1,905,634,958,-1,954,956,953,-1,954,771,956,-1,957,951,953,-1,957,1062,951,-1,951,778,945,-1,1062,778,951,-1,949,1063,904,-1,1063,949,948,-1,904,707,223,-1,904,1063,707,-1,1036,725,1064,-1,1036,625,725,-1,833,33,1055,-1,833,943,33,-1,217,724,196,-1,217,216,724,-1,921,981,1065,-1,921,91,981,-1,921,35,91,-1,973,907,780,-1,167,907,973,-1,81,119,82,-1,119,81,115,-1,73,79,78,-1,79,73,72,-1,914,940,110,-1,914,938,940,-1,687,689,688,-1,687,200,689,-1,193,97,194,-1,779,97,193,-1,930,977,976,-1,66,977,930,-1,714,975,818,-1,714,816,975,-1,357,48,468,-1,48,357,920,-1,800,475,474,-1,799,475,800,-1,927,762,692,-1,927,1021,762,-1,796,594,41,-1,796,1019,594,-1,563,944,926,-1,563,90,944,-1,30,874,31,-1,874,30,28,-1,922,723,722,-1,723,922,929,-1,256,14,925,-1,256,12,14,-1,540,526,527,-1,543,526,540,-1,1005,28,30,-1,28,1005,10,-1,928,924,923,-1,928,60,924,-1,540,419,807,-1,540,531,419,-1,1052,570,17,-1,653,570,1052,-1,787,806,788,-1,22,806,787,-1,562,27,810,-1,528,27,562,-1,400,541,401,-1,542,541,400,-1,34,943,89,-1,33,943,34,-1,355,298,1013,-1,355,468,298,-1,1021,682,762,-1,1021,681,682,-1,43,692,131,-1,43,927,692,-1,357,45,920,-1,357,356,45,-1,51,199,259,-1,814,199,51,-1,814,722,199,-1,791,57,792,-1,791,58,57,-1,933,976,1003,-1,933,930,976,-1,66,932,67,-1,930,932,66,-1,935,783,979,-1,783,935,784,-1,918,938,914,-1,918,919,938,-1,914,73,918,-1,112,73,914,-1,767,234,212,-1,234,767,191,-1,29,726,809,-1,726,29,86,-1,89,917,34,-1,89,88,917,-1,835,902,836,-1,903,902,835,-1,974,36,221,-1,974,37,36,-1,945,950,947,-1,945,946,950,-1,952,949,1066,-1,952,947,949,-1,954,1066,772,-1,954,952,1066,-1,957,1026,1027,-1,955,1026,957,-1,105,718,772,-1,105,834,718,-1,958,956,769,-1,958,955,956,-1,959,720,821,-1,392,720,959,-1,173,119,117,-1,173,279,119,-1,121,125,124,-1,121,120,125,-1,822,253,690,-1,912,253,822,-1,130,797,803,-1,911,797,130,-1,129,1060,960,-1,1060,129,252,-1,127,675,962,-1,126,675,127,-1,134,963,727,-1,134,133,963,-1,1059,961,960,-1,965,961,1059,-1,755,966,965,-1,755,757,966,-1,1058,832,971,-1,1058,729,832,-1,750,971,832,-1,147,971,750,-1,146,246,970,-1,245,246,146,-1,900,1067,694,-1,1067,900,748,-1,150,1067,744,-1,171,1067,150,-1,271,155,154,-1,271,164,155,-1,1053,171,150,-1,1053,906,171,-1,829,686,684,-1,686,829,1054,-1,708,221,705,-1,708,709,221,-1,180,99,1064,-1,182,99,180,-1,183,937,919,-1,183,248,937,-1,233,689,64,-1,83,689,233,-1,785,1068,197,-1,1068,785,816,-1,977,721,71,-1,977,202,721,-1,208,765,720,-1,208,207,765,-1,764,820,211,-1,820,764,915,-1,941,768,215,-1,768,941,1061,-1,721,92,71,-1,721,93,92,-1,841,783,817,-1,783,841,231,-1,203,225,204,-1,203,229,225,-1,819,838,777,-1,998,838,819,-1,228,948,229,-1,228,1063,948,-1,980,837,981,-1,980,901,837,-1,1058,186,729,-1,186,1058,187,-1,732,293,292,-1,263,293,732,-1,242,741,749,-1,742,741,242,-1,251,912,128,-1,251,253,912,-1,7,978,818,-1,1056,978,7,-1,752,824,290,-1,824,752,258,-1,968,258,752,-1,968,132,258,-1,266,972,703,-1,265,972,266,-1,898,678,274,-1,678,898,123,-1,118,124,114,-1,118,121,124,-1,286,823,897,-1,678,823,286,-1,740,169,827,-1,169,740,170,-1,798,911,135,-1,798,797,911,-1,760,125,987,-1,761,125,760,-1,351,615,616,-1,351,1069,615,-1,302,596,674,-1,302,463,596,-1,665,479,880,-1,665,650,479,-1,431,603,445,-1,603,431,606,-1,445,602,446,-1,445,603,602,-1,657,662,663,-1,657,1045,662,-1,668,334,551,-1,879,334,668,-1,319,859,645,-1,324,859,319,-1,423,328,323,-1,328,423,331,-1,336,534,532,-1,336,335,534,-1,989,477,1070,-1,478,477,989,-1,312,343,313,-1,312,587,343,-1,992,439,443,-1,992,441,439,-1,461,858,348,-1,454,858,461,-1,424,3,5,-1,894,3,424,-1,1069,350,846,-1,350,1069,351,-1,640,366,500,-1,640,639,366,-1,1033,637,850,-1,637,1033,995,-1,870,363,362,-1,567,363,870,-1,868,641,849,-1,868,571,641,-1,979,644,520,-1,979,230,644,-1,990,421,647,-1,990,422,421,-1,376,509,375,-1,376,892,509,-1,1039,635,622,-1,1039,804,635,-1,487,375,506,-1,487,376,375,-1,854,866,1000,-1,854,853,866,-1,248,1002,411,-1,931,1002,248,-1,547,1004,549,-1,1042,1004,547,-1,307,399,889,-1,307,306,399,-1,1038,502,1006,-1,876,502,1038,-1,623,369,364,-1,623,893,369,-1,328,860,323,-1,328,670,860,-1,428,992,862,-1,992,428,888,-1,894,887,3,-1,894,421,887,-1,329,424,5,-1,329,331,424,-1,345,428,450,-1,428,345,429,-1,447,451,450,-1,447,459,451,-1,651,325,455,-1,988,325,651,-1,1007,458,1009,-1,1007,886,458,-1,1007,855,652,-1,855,1007,1008,-1,667,618,885,-1,618,667,619,-1,295,1052,296,-1,295,811,1052,-1,294,467,300,-1,294,466,467,-1,857,470,620,-1,857,654,470,-1,467,1012,883,-1,467,1047,1012,-1,473,1011,881,-1,473,595,1011,-1,1048,1070,1046,-1,1070,1048,989,-1,1049,619,667,-1,1015,619,1049,-1,865,477,476,-1,865,591,477,-1,882,1014,864,-1,1014,882,881,-1,342,339,38,-1,342,848,339,-1,650,657,663,-1,650,649,657,-1,512,879,659,-1,512,334,879,-1,866,484,1001,-1,866,485,484,-1,878,939,1044,-1,878,959,939,-1,388,488,498,-1,388,489,488,-1,854,1022,389,-1,854,1071,1022,-1,1025,1071,1024,-1,1072,1071,1025,-1,877,1028,1072,-1,877,494,1028,-1,1030,877,1043,-1,495,877,1030,-1,498,404,403,-1,498,488,404,-1,851,1031,380,-1,851,1029,1031,-1,876,1037,412,-1,876,626,1037,-1,414,636,367,-1,414,413,636,-1,891,622,638,-1,622,891,1039,-1,813,1038,1006,-1,813,805,1038,-1,1039,642,994,-1,1039,891,642,-1,555,517,553,-1,555,515,517,-1,555,871,515,-1,939,1040,1044,-1,1040,939,936,-1,552,936,937,-1,552,1040,936,-1,538,483,551,-1,538,337,483,-1,934,550,549,-1,935,550,934,-1,931,1041,1002,-1,931,933,1041,-1,527,874,27,-1,525,874,527,-1,417,617,415,-1,617,417,627,-1,812,418,25,-1,807,418,812,-1,373,1005,524,-1,373,875,1005,-1,1042,1041,1004,-1,1042,546,1041,-1,504,508,633,-1,504,505,508,-1,398,511,513,-1,511,398,306,-1,1044,516,486,-1,1040,516,1044,-1,582,560,583,-1,582,581,560,-1,870,563,565,-1,563,870,564,-1,638,643,891,-1,638,640,643,-1,635,1006,623,-1,813,1006,635,-1,819,575,997,-1,573,575,819,-1,365,851,503,-1,851,365,996,-1,996,1029,851,-1,996,995,1029,-1,575,495,1034,-1,575,493,495,-1,403,497,498,-1,403,496,497,-1,1031,1043,491,-1,1030,1043,1031,-1,1072,1043,877,-1,1025,1043,1072,-1,490,381,491,-1,490,577,381,-1,1072,1022,1071,-1,1028,1022,1072,-1,1071,1000,1024,-1,1000,1071,854,-1,393,959,878,-1,393,392,959,-1,1001,557,556,-1,484,557,1001,-1,582,311,426,-1,584,311,582,-1,590,585,588,-1,585,590,586,-1,1020,657,317,-1,1020,1045,657,-1,1046,340,848,-1,1070,340,1046,-1,1016,1049,1017,-1,1016,1015,1049,-1,1018,1048,1046,-1,1048,1018,1047,-1,466,1047,467,-1,466,1048,1047,-1,869,653,847,-1,653,869,570,-1,618,1008,884,-1,617,1008,618,-1,458,597,1009,-1,458,460,597,-1,862,443,598,-1,992,443,862,-1,430,440,888,-1,440,430,425,-1,666,885,601,-1,666,667,885,-1,323,859,324,-1,323,860,859,-1,991,614,613,-1,991,628,614,-1,600,444,314,-1,600,432,444,-1,626,1038,856,-1,626,876,1038,-1,1037,867,501,-1,867,1037,1036,-1,398,359,518,-1,398,360,359,-1,1050,523,396,-1,1050,524,523,-1,397,1042,547,-1,889,1042,397,-1,485,391,393,-1,391,485,853,-1,384,872,387,-1,890,872,384,-1,434,887,420,-1,434,437,887,-1,434,315,437,-1,548,397,547,-1,568,397,548,-1,520,362,521,-1,520,644,362,-1,499,849,500,-1,499,868,849,-1,850,1035,1033,-1,850,372,1035,-1,643,500,849,-1,500,643,640,-1,564,362,644,-1,362,564,870,-1,559,519,514,-1,558,519,559,-1,627,1008,617,-1,627,855,1008,-1,1069,845,615,-1,1069,846,845,-1,349,345,452,-1,345,349,346,-1,318,313,343,-1,318,316,313,-1,11,417,621,-1,11,614,417,-1,1070,591,340,-1,591,1070,477,-1,304,534,847,-1,304,532,534,-1,607,846,608,-1,607,845,846,-1,629,611,656,-1,646,611,629,-1,483,895,669,-1,483,482,895,-1,448,446,602,-1,448,598,446,-1,432,445,444,-1,432,431,445,-1,665,592,1010,-1,665,880,592,-1,987,913,693,-1,125,913,987,-1,125,120,913,-1,982,236,293,-1,982,1054,236,-1,144,302,674,-1,302,144,143,-1,1056,698,239,-1,1056,188,698,-1,685,703,972,-1,685,237,703,-1,139,290,824,-1,139,925,290,-1,131,691,129,-1,691,131,692,-1,693,122,679,-1,913,122,693,-1,0,1053,152,-1,1053,0,828,-1,174,158,157,-1,174,831,158,-1,746,747,749,-1,746,745,747,-1,826,699,1057,-1,826,899,699,-1,266,984,267,-1,266,702,984,-1,708,1063,228,-1,708,707,1063,-1,777,226,946,-1,838,226,777,-1,838,1051,710,-1,1051,838,998,-1,840,942,980,-1,839,942,840,-1,817,839,841,-1,817,192,839,-1,713,816,714,-1,713,1068,816,-1,189,1061,116,-1,189,768,1061,-1,36,1065,220,-1,36,921,1065,-1,1068,94,93,-1,1068,713,94,-1,74,211,210,-1,211,74,764,-1,234,79,212,-1,234,75,79,-1,190,116,115,-1,189,116,190,-1,100,1051,101,-1,100,710,1051,-1,197,93,721,-1,197,1068,93,-1,923,788,929,-1,789,788,923,-1,867,1064,99,-1,867,1036,1064,-1,1055,725,833,-1,775,725,1055,-1,8,818,975,-1,8,7,818,-1,6,1056,7,-1,1056,6,188,-1,830,684,683,-1,829,684,830,-1,171,694,1067,-1,171,172,694,-1,748,744,1067,-1,145,744,748,-1,685,899,745,-1,685,972,899,-1,246,1057,970,-1,826,1057,246,-1,187,1057,699,-1,187,1058,1057,-1,832,896,750,-1,832,731,896,-1,925,291,290,-1,14,291,925,-1,754,288,287,-1,753,288,754,-1,138,727,726,-1,727,138,134,-1,965,754,755,-1,1059,754,965,-1,908,756,46,-1,136,756,908,-1,967,960,1060,-1,1059,960,967,-1,969,963,962,-1,964,963,969,-1,251,1060,252,-1,251,983,1060,-1,987,985,760,-1,985,987,986,-1,116,166,117,-1,166,116,1061,-1,274,113,898,-1,113,274,273,-1,111,915,764,-1,915,111,765,-1,211,770,719,-1,211,820,770,-1,1023,955,958,-1,1023,1026,955,-1,771,772,717,-1,772,771,954,-1,1062,1027,574,-1,1027,1062,957,-1,772,222,105,-1,1066,222,772,-1,1062,573,778,-1,574,573,1062,-1,1066,904,222,-1,949,904,1066,-1,1064,775,180,-1,725,775,1064,-1,203,181,227,-1,182,181,203,-1,220,836,902,-1,220,1065,836,-1,1055,37,974,-1,37,1055,33,-1,837,1065,981,-1,836,1065,837,-1,78,235,184,-1,78,77,235,-1,66,202,977,-1,66,65,202,-1,192,69,92,-1,69,192,817,-1,257,794,795,-1,257,62,794,-1,787,790,23,-1,787,815,790,-1,59,924,60,-1,59,58,924,-1,729,254,730,-1,729,186,254,-1,908,800,137,-1,908,799,800,-1,1019,802,801,-1,802,1019,796,-1,40,927,341,-1,927,40,1021,-1,944,89,943,-1,944,90,89,-1,32,542,400,-1,32,31,542,-1,536,812,537,-1,536,541,812,-1,929,786,723,-1,929,788,786,-1,811,653,1052,-1,462,653,811,-1,58,790,924,-1,791,790,58,-1,815,923,790,-1,815,789,923,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t3_Coord',point=[(.8557,50.92183,-2.61171),(.87687,50.8961,-2.58985),(.99287,50.92094,-2.63122),(-.89805,50.87037,-2.58267),(-.87687,50.8961,-2.60381),(-.99287,50.92094,-2.64425),(.6869,50.5255,-2.74751),(.66844,50.53115,-2.70079),(.61504,50.5269,-2.71231),(-.69519,50.31261,-2.83656),(-.61504,50.5269,-2.72736),(-.66661,50.45608,-2.79137),(.13573,50.24449,-3.1273),(.05604,50.15377,-3.35477),(.15242,50.24131,-3.15369),(-.37324,50.25303,-3.02583),(-.39489,50.29545,-3.0329),(-.26852,50.31874,-3.04833),(.25823,50.38186,-2.94168),(.24686,50.38634,-2.94657),(.26602,50.27966,-3.0031),(.66434,50.29265,-2.8276),(.56164,50.52264,-2.72357),(.65454,50.32675,-2.82169),(-.24686,50.38634,-2.95286),(-.25823,50.38186,-2.94828),(-.27433,50.27867,-3.00274),(-.68539,50.30526,-2.84199),(-.56164,50.52264,-2.73759),(.66011,50.28909,-2.8347),(-.47318,50.58555,-2.69488),(-.4624,50.58032,-2.70408),(-.4635,50.58485,-2.69068),(.30733,50.27017,-2.46724),(.30607,50.27231,-2.48127),(.43995,50.24582,-2.46),(.44639,50.23982,-2.44859),(.44181,50.24064,-2.44625),(-.06532,50.77783,-3.00942),(-.10562,50.80307,-2.91638),(-.0144,50.77954,-2.99806),(0,50.67947,-3.43205),(-.01253,50.71354,-3.2877),(0,50.71805,-3.28655),(.01958,50.10268,-3.82773),(0,50.14492,-3.84898),(.02045,50.14759,-3.84043),(.02264,50.10377,-3.76331),(0,50.09289,-3.75775),(.15674,50.71736,-2.73026),(.15274,50.63922,-2.80843),(.23802,50.63932,-2.77399),(.08261,50.63717,-2.83098),(.09462,50.72725,-2.75936),(0,50.72454,-2.80234),(0,50.5065,-2.93731),(.07216,50.49572,-2.92519),(.37362,50.25184,-3.01005),(.39482,50.3935,-2.90365),(.36702,50.40279,-2.91257),(.35409,50.46503,-2.87057),(.35506,50.42123,-2.89808),(.22557,50.41045,-2.96976),(.26049,50.48586,-2.86502),(.31801,50.91166,-2.33123),(.28142,50.80626,-2.42034),(.2364,50.78452,-2.37618),(.26534,50.91589,-2.28795),(.27879,50.92277,-2.28909),(.2803,50.47476,-2.5048),(.14647,50.54222,-2.41758),(.2601,50.57301,-2.47337),(.468,50.73566,-2.16481),(.37258,50.76823,-2.15229),(.46311,50.68728,-2.05575),(.43522,50.86364,-2.22213),(.37699,50.91386,-2.2388),(.36282,50.82564,-2.20616),(.37327,50.8206,-2.19909),(.47995,50.7999,-2.21957),(.36757,51.11638,-2.37191),(.44529,51.02414,-2.35537),(.45306,51.12172,-2.35025),(.42374,50.94349,-2.33502),(.37356,51.02363,-2.38356),(.39489,50.29545,-3.02331),(.53237,50.26171,-2.95495),(.37323,50.25306,-3.01638),(.15175,50.27564,-2.53285),(.15099,50.27527,-2.44779),(0,50.28226,-2.40884),(.42238,50.27774,-2.54188),(.38173,50.48829,-2.51242),(.41224,50.54447,-2.54617),(.47452,50.55538,-2.52794),(.25611,50.31582,-3.02565),(.58434,50.37393,-2.44257),(.48994,50.42554,-2.49398),(.51877,50.44187,-2.42302),(.16363,50.1588,-2.02957),(.17065,50.11291,-1.93003),(0,50.12285,-1.90728),(.53967,50.41015,-2.28216),(.49179,50.5457,-2.31618),(.49852,50.51854,-2.24478),(.48566,50.46919,-2.11815),(.4897,50.63313,-2.19736),(0,50.61633,-1.61072),(.11851,50.63667,-1.62977),(0,50.6378,-1.65003),(.29099,50.67943,-1.95594),(.36008,50.68014,-1.93772),(.371,50.70751,-2.05672),(.28575,51.07307,-2.42792),(.36874,51.18304,-2.3649),(.51437,50.98974,-2.34641),(.55996,50.91827,-2.37538),(.60874,50.95305,-2.40062),(.4509,51.18362,-2.34367),(.55125,51.07278,-2.33001),(.47158,51.06442,-2.43835),(.45218,51.18436,-2.35005),(.56774,51.115,-2.34088),(.28547,51.11352,-2.44901),(.37131,51.18396,-2.37207),(.44851,51.06206,-2.44818),(.23903,50.781,-2.87637),(.27418,50.70535,-2.91739),(.20016,50.69909,-2.99881),(.03744,50.67909,-3.29274),(.01883,50.6495,-3.43453),(.01253,50.71354,-3.28754),(.26854,50.44531,-3.06581),(.31162,50.59623,-2.95613),(.35816,50.46312,-2.99476),(.03333,50.49109,-3.68356),(.05428,50.32708,-3.74285),(.01365,50.48241,-3.72672),(.3955,50.33898,-3.01818),(.26852,50.31874,-3.04179),(.03503,50.1382,-3.48851),(0,50.13624,-3.49139),(0,50.10922,-3.63213),(.06786,50.24302,-3.15082),(.06786,50.19679,-3.25083),(.87321,51.00752,-2.8523),(.87418,50.91103,-2.90003),(.7661,50.86636,-2.84946),(.77586,50.99845,-2.73511),(.78481,51.00522,-2.69744),(.92364,51.06573,-2.73153),(.6889,50.96203,-2.68134),(.81026,50.98388,-2.64437),(.72101,50.93338,-2.63089),(.68168,50.89509,-2.53914),(.75602,50.89926,-2.58363),(1.15876,51.05007,-2.74379),(1.18063,50.98333,-2.70921),(1.24099,50.9637,-2.8062),(1.06651,50.86001,-2.67445),(1.08566,50.96472,-2.65767),(1.05727,50.84665,-2.671),(1.00707,50.8142,-2.63995),(.89878,50.86988,-2.57345),(.79084,50.89117,-2.53357),(.69785,50.88866,-2.51377),(.61657,50.85989,-2.48695),(.72737,50.79373,-2.54172),(.42698,50.85942,-2.684),(.55391,50.87873,-2.63465),(.55021,50.89051,-2.67579),(1.04255,51.07826,-2.7556),(1.14388,51.05988,-2.78333),(.62808,50.9987,-2.40827),(1.17437,50.90408,-2.7131),(1.23045,50.81946,-2.95681),(1.23199,50.92039,-2.89664),(1.24529,50.86655,-2.88056),(1.01201,50.70191,-2.6636),(.27433,50.27867,-2.99563),(.31723,50.17654,-2.15857),(.37481,50.15634,-2.17728),(.31261,50.13699,-2.06678),(.1472,50.82276,-2.22227),(.278,50.82627,-2.22084),(.26892,50.91764,-2.27598),(.77404,50.5561,-2.78041),(.86674,50.58864,-2.81188),(.78402,50.54486,-2.74208),(.51582,50.88425,-2.34134),(.4748,50.92718,-2.32216),(.45441,50.8969,-2.28728),(.3872,50.39072,-2.53144),(.45149,50.5008,-2.50658),(.44827,50.40887,-2.51295),(.55083,50.43973,-2.34607),(.4922,50.53123,-2.39566),(.37338,50.64337,-2.57406),(.31522,50.7328,-2.56528),(.32564,50.6779,-2.64503),(.30987,50.83409,-2.46369),(.31965,50.72208,-2.53855),(.29618,50.68817,-2.48794),(.38516,50.11649,-2.09232),(.30773,50.0973,-1.99508),(.4952,50.65304,-2.19537),(.51296,50.59696,-2.07645),(.28022,50.65224,-1.72784),(.25039,50.65097,-1.70862),(.27878,50.63875,-1.71084),(.47861,50.67464,-2.05803),(.46008,50.65949,-1.92446),(.48596,50.79633,-2.22995),(.49148,50.64962,-2.20755),(.49369,50.70269,-2.25956),(.54263,50.69035,-2.46666),(.51865,50.65012,-2.41828),(.52326,50.57607,-2.48894),(.59536,50.31923,-2.30889),(.61742,50.36093,-2.36676),(.55417,50.19527,-2.37767),(.52052,50.19056,-2.38113),(.4934,50.34591,-2.15438),(.56192,50.27547,-2.25574),(.52209,50.38574,-2.23391),(.3834,50.08328,-2.03408),(.29591,50.06441,-1.92815),(.45302,50.129,-2.20092),(.50307,50.12846,-2.21679),(.4488,50.10148,-2.12141),(0,50.27122,-2.4915),(.14881,50.28606,-2.53929),(0,50.26725,-2.48095),(.39856,50.92034,-2.28913),(.44196,50.86381,-2.23586),(.34004,50.82947,-2.21295),(1.12429,50.76918,-2.84276),(1.15567,50.74733,-2.93873),(1.13512,50.7902,-2.84112),(.88062,50.56516,-2.7057),(.96553,50.5614,-2.70065),(.94962,50.66224,-2.65141),(1.1268,50.96913,-2.97226),(1.05882,50.89277,-3.01095),(1.02991,50.93343,-2.98835),(.96361,50.9378,-2.95525),(.97601,50.83089,-2.98235),(.1474,50.86542,-2.23247),(0,50.82251,-2.21278),(.41323,50.8559,-2.66347),(.31681,50.84627,-2.74231),(.15424,50.69234,-3.07326),(.09712,50.69295,-3.16872),(.12312,50.72829,-3.04697),(.70536,50.51984,-2.79415),(.07559,50.40536,-2.99923),(.20202,50.28332,-3.06566),(.15695,50.40875,-2.98459),(.2762,50.33897,-3.06011),(.23532,50.69972,-2.69066),(.24534,50.77688,-2.61809),(.19344,50.81473,-2.66113),(1.17251,50.89121,-2.71988),(1.2329,50.89169,-2.79573),(1.22985,50.81235,-2.94616),(1.07048,50.6095,-2.83134),(1.07756,50.61517,-2.82238),(1.03965,50.54662,-2.75641),(1.02592,50.57275,-2.69724),(1.03072,50.5413,-2.75681),(.70659,50.88392,-2.51802),(.71483,50.89116,-2.51814),(.69487,50.8966,-2.51513),(.24735,50.95415,-2.55545),(.23185,50.96951,-2.58927),(.17284,50.85715,-2.70004),(.41362,50.87504,-2.63476),(.54382,50.88641,-2.5684),(.55222,50.86628,-2.58622),(.56565,51.1125,-2.33438),(.13294,50.8357,-2.73509),(.17022,50.83304,-2.681),(.20666,50.8743,-2.73436),(.17552,50.83494,-2.79145),(.31064,50.85623,-2.72541),(.21294,50.84136,-2.80777),(.23758,50.87264,-2.7474),(.11192,50.16587,-3.33617),(.17337,50.24446,-3.18864),(.10507,50.15866,-3.3334),(.23733,50.28462,-3.10813),(.16911,50.23812,-3.18005),(1.14601,50.81358,-2.82668),(1.15012,50.82378,-2.81324),(-.17337,50.24446,-3.19253),(-.16911,50.23812,-3.1839),(-.23733,50.28462,-3.1137),(-.04512,50.14178,-3.48543),(-.02193,50.12336,-3.63171),(-.03503,50.1382,-3.48908),(-.11192,50.16587,-3.3384),(-.10507,50.15866,-3.33551),(0,50.24557,-3.16964),(0,50.40457,-3.00574),(-.07559,50.40536,-3.00109),(-.31522,50.7328,-2.57334),(-.30987,50.83409,-2.47139),(-.31965,50.72208,-2.54691),(-.20666,50.8743,-2.73858),(-.23758,50.87264,-2.75217),(-.23981,50.97173,-2.60185),(-.62808,50.9987,-2.42029),(-.57089,51.11816,-2.34593),(-.62659,51.00411,-2.42512),(-.68168,50.89509,-2.55221),(-.71483,50.89116,-2.53182),(-.69487,50.8966,-2.52854),(-.54382,50.88641,-2.57951),(-.66666,50.90513,-2.54045),(-1.03965,50.54662,-2.77436),(-1.03072,50.5413,-2.77484),(-1.02592,50.57275,-2.71571),(-1.00568,50.68267,-2.68374),(-1.02195,50.68398,-2.68575),(-1.03509,50.58,-2.7188),(-1.15091,50.7457,-2.96073),(-1.15567,50.74733,-2.94912),(-1.22985,50.81235,-2.95415),(-1.07236,50.84565,-2.69121),(-1.06651,50.86001,-2.68783),(-1.17437,50.90408,-2.72408),(-1.05727,50.84665,-2.68475),(-.24534,50.77688,-2.62403),(-.19313,50.81393,-2.66613),(-.24735,50.95415,-2.5607),(-.15274,50.63922,-2.81211),(-.08261,50.63717,-2.83296),(-.09462,50.72725,-2.76157),(-.16093,50.75586,-2.96289),(-.12312,50.72829,-3.04916),(-.15424,50.69234,-3.076),(-.01579,50.74341,-3.15082),(-.04822,50.72498,-3.15592),(-.52054,51.01408,-2.47256),(-.52239,50.99704,-2.485),(-1.11465,51.0456,-2.86488),(-1.16274,51.00751,-2.89937),(-1.20107,51.0242,-2.84364),(-1.1945,50.98235,-2.92208),(-1.1268,50.96913,-2.9778),(-1.17251,50.89121,-2.73105),(-1.13149,50.8199,-2.80459),(-1.0984,50.67133,-2.90185),(-1.07756,50.61517,-2.83795),(-1.10218,50.73362,-2.83467),(-.05493,50.16703,-3.76523),(-.01838,50.14643,-3.8451),(-.01754,50.10475,-3.82993),(-.45441,50.8969,-2.29842),(-.39856,50.92034,-2.29886),(-.42374,50.94349,-2.34484),(-.40886,50.32376,-2.55746),(-.2941,50.28816,-2.56045),(-.42335,50.29204,-2.56336),(-.56674,50.17062,-2.34772),(-.56842,50.17477,-2.32986),(-.62467,50.22878,-2.3674),(-.45302,50.129,-2.21868),(-.50307,50.12846,-2.23616),(-.55496,50.16284,-2.33257),(-.16947,50.0827,-1.88068),(-.16425,50.04891,-1.8347),(-.29591,50.06441,-1.94088),(-.55696,50.59755,-2.60539),(-.49692,50.59196,-2.56405),(-.54609,50.62032,-2.52505),(-.54263,50.69035,-2.48073),(-.51247,50.81043,-2.4085),(-.55268,50.83738,-2.45816),(-.52209,50.38574,-2.25188),(-.4934,50.34591,-2.17219),(-.48603,50.46319,-2.13672),(-.53967,50.41015,-2.30015),(-.59536,50.31923,-2.32902),(-.48483,50.78083,-2.23131),(-.49148,50.64962,-2.22241),(-.4952,50.65304,-2.21034),(-.47995,50.7999,-2.23259),(-.48596,50.79633,-2.24309),(-.12371,50.61758,-1.63066),(-.11851,50.63667,-1.63402),(-.25039,50.65097,-1.71736),(0,50.64769,-1.71227),(-.13441,50.65557,-1.70945),(-.17065,50.11291,-1.9374),(-.30773,50.0973,-2.0081),(-.37338,50.64337,-2.58408),(-.31853,50.60918,-2.53456),(-.35181,50.92985,-2.38381),(-.28142,50.80626,-2.42772),(-.3996,50.61936,-2.69331),(-.33467,50.62991,-2.72622),(-.32564,50.6779,-2.65329),(-.49179,50.5457,-2.33147),(-.4984,50.61138,-2.38706),(-.4922,50.53123,-2.41063),(-.47004,50.62247,-1.94697),(-.46008,50.65949,-1.93935),(-.51296,50.59696,-2.09292),(-.26892,50.91764,-2.28283),(-.1472,50.82276,-2.2265),(-.1474,50.86542,-2.23655),(-.31723,50.17654,-2.17132),(-.31261,50.13699,-2.07972),(-.37481,50.15634,-2.19221),(-.66204,50.58264,-2.84268),(-.59018,50.53498,-2.87362),(-.70536,50.51984,-2.80974),(-.35506,50.42123,-2.90705),(-.36702,50.40279,-2.92181),(-.72737,50.79373,-2.55676),(-.85075,50.72712,-2.60443),(-.74933,50.70619,-2.61059),(-1.01201,50.70191,-2.68032),(-1.00707,50.8142,-2.65492),(-1.18063,50.98333,-2.71838),(-.60874,50.95305,-2.41308),(-.69785,50.88866,-2.52735),(-1.04255,51.07826,-2.76331),(-1.14388,51.05988,-2.78997),(-1.15876,51.05007,-2.75112),(-.55021,50.89051,-2.68607),(-.55391,50.87873,-2.64546),(-.42698,50.85942,-2.69266),(-.70659,50.88392,-2.53172),(-.64245,50.75599,-2.5488),(-.61657,50.85989,-2.50012),(-.79084,50.89117,-2.54777),(-.75602,50.89926,-2.59691),(-.8557,50.92183,-2.62487),(-1.08566,50.96472,-2.66898),(-.9841,50.9468,-2.65028),(-.72101,50.93338,-2.64287),(-.81026,50.98388,-2.6559),(-.62789,50.89712,-2.63693),(-.59952,50.90408,-2.68367),(-.6889,50.96203,-2.69211),(-.90354,51.06161,-2.77661),(-.77586,50.99845,-2.7452),(-.76959,50.94537,-2.80246),(-1.02383,51.07137,-2.81831),(-.98814,51.02203,-2.90221),(-1.07775,51.0129,-2.9408),(-1.23045,50.81946,-2.96441),(-1.2062,50.86675,-2.98172),(-1.13712,50.77075,-2.99959),(-1.10499,50.82054,-3.03247),(-1.05882,50.89277,-3.01807),(-.97601,50.83089,-2.9917),(-.87321,51.00752,-2.86081),(-.96361,50.9378,-2.96317),(-1.17765,50.92033,-3.00429),(-.13573,50.24449,-3.13056),(-.06786,50.24302,-3.15242),(-.05604,50.15377,-3.35587),(-.22722,50.31745,-3.11768),(-.17124,50.28702,-3.19988),(-.10999,50.25358,-3.34083),(-.02264,50.10377,-3.76352),(-.01256,50.11393,-3.6311),(-.3955,50.33898,-3.02757),(-.2762,50.33897,-3.06663),(-.28093,50.32167,-3.06465),(-.03333,50.49109,-3.68379),(-.01365,50.48241,-3.7268),(-.02004,50.32408,-3.78977),(-.31162,50.59623,-2.96278),(-.23419,50.58859,-3.0377),(-.26854,50.44531,-3.07168),(-.2238,50.86014,-2.77712),(-.17552,50.83494,-2.79502),(-.19602,50.83846,-2.82512),(0,50.78052,-2.808),(-.12368,50.81186,-2.71872),(-.36035,50.68082,-1.95249),(-.29557,50.66448,-1.8345),(-.29114,50.67961,-1.95994),(-.51865,50.65012,-2.4326),(-.50621,50.77272,-2.3491),(-.5016,50.85423,-2.309),(-.49107,50.57533,-2.08823),(-.43693,50.42335,-2.03539),(-.46113,50.52586,-1.99035),(-.14247,50.22651,-1.78128),(-.1275,50.33297,-1.75173),(-.27248,50.2448,-1.88542),(-.49852,50.51854,-2.26087),(-.4897,50.63313,-2.21238),(-.49369,50.70269,-2.27369),(-.61742,50.36093,-2.38665),(-.66919,50.28257,-2.40036),(-.16363,50.1588,-2.03648),(-.425,50.18883,-2.2845),(-.56192,50.27547,-2.27565),(-.48994,50.42554,-2.50917),(-.49129,50.51065,-2.49711),(-.52326,50.57607,-2.5036),(-.47452,50.55538,-2.5414),(-.45149,50.5008,-2.52007),(-.59435,50.64648,-2.56047),(-.64685,50.67888,-2.59601),(-.28179,50.89991,-2.51792),(-.28575,51.07307,-2.43361),(-.3265,50.99663,-2.42388),(-.44196,50.86381,-2.24731),(-.37258,50.76823,-2.16323),(-.28559,50.71849,-2.06942),(-.28034,50.76888,-2.17072),(-.31801,50.91166,-2.33909),(-.38377,50.915,-2.26705),(-.14766,50.36282,-2.51384),(-.28957,50.38192,-2.53662),(-.2803,50.47476,-2.51368),(-.38893,50.63815,-2.63728),(-.4582,50.58711,-2.64859),(-.44551,50.47263,-2.83894),(-.42311,50.4987,-2.82736),(-.46518,50.43611,-2.86126),(-.61191,50.25283,-2.96003),(-.4501,50.40186,-2.88503),(-.37362,50.25184,-3.01952),(-.39482,50.3935,-2.91364),(-.07216,50.49572,-2.92698),(-.22608,50.50138,-2.89731),(-.14682,50.49721,-2.91421),(-.23802,50.63932,-2.77981),(-.32789,50.62665,-2.7365),(-.26049,50.48586,-2.87164),(-.15674,50.71736,-2.73402),(0,50.63766,-2.83651),(-.39537,50.45456,-2.86916),(-.34119,50.62006,-2.73675),(-.4007,50.61194,-2.70625),(-.39581,50.50311,-2.83346),(-.27879,50.92277,-2.2961),(-.26534,50.91589,-2.29469),(-.2364,50.78452,-2.38268),(-.2601,50.57301,-2.48129),(-.38173,50.48829,-2.52411),(-.14647,50.54222,-2.42231),(-.14726,50.44866,-2.46792),(-.17022,50.83304,-2.68479),(-.14724,50.78181,-2.1704),(-.278,50.82627,-2.22865),(-.34004,50.82947,-2.22236),(-.36282,50.82564,-2.21621),(-.46311,50.68728,-2.07011),(-.371,50.70751,-2.06838),(-.37699,50.91386,-2.24832),(-.43522,50.86364,-2.23349),(-.44529,51.02414,-2.36468),(-.37356,51.02363,-2.39145),(-.61434,50.25428,-2.96533),(-.15099,50.27527,-2.4533),(-.15175,50.27564,-2.5382),(-.30607,50.27231,-2.49206),(-.43995,50.24582,-2.47531),(-.42238,50.27774,-2.55595),(-.41224,50.54447,-2.55807),(-.26602,50.27966,-3.00996),(-.25611,50.31582,-3.032),(-.52077,50.35785,-2.52719),(-.51877,50.44187,-2.43929),(-.00015,50.14051,-1.75147),(0,50.21665,-1.75652),(-.15277,50.14012,-1.79245),(-.55083,50.43973,-2.36369),(-.49566,50.57316,-2.10393),(-.36874,51.18304,-2.37133),(-.36757,51.11638,-2.3789),(-.56453,50.91109,-2.39076),(-.51437,50.98974,-2.35732),(-.55125,51.07278,-2.34053),(-.45306,51.12172,-2.35865),(-.56881,51.11565,-2.33948),(-.45218,51.18436,-2.35773),(-.47158,51.06442,-2.44719),(-.50232,51.04952,-2.45505),(-.37131,51.18396,-2.3785),(-.41695,51.03963,-2.49211),(-.44282,51.06147,-2.45897),(-.20127,50.69548,-3.00379),(-.23903,50.781,-2.88108),(-.03744,50.67909,-3.29324),(-.00554,50.67588,-3.43107),(-.05428,50.32708,-3.74325),(-.06786,50.19679,-3.2523),(-.87418,50.91103,-2.90956),(-.78481,51.00522,-2.7079),(-1.24099,50.9637,-2.81332),(-.55222,50.86628,-2.59755),(-.67431,50.91041,-2.77255),(-.67487,50.95364,-2.7325),(-.58153,50.88551,-2.73115),(-.44528,50.82886,-2.77394),(-.55632,50.86364,-2.75487),(-.55342,50.87378,-2.74079),(-1.24529,50.86655,-2.88843),(-1.23725,50.90348,-2.80499),(-1.07048,50.6095,-2.84688),(-1.0296,50.61158,-2.87046),(-.96553,50.5614,-2.71913),(-.94962,50.66224,-2.6689),(-.66844,50.53115,-2.71681),(-.6869,50.5255,-2.76334),(-1.14601,50.81358,-2.83794),(-1.13512,50.7902,-2.85269),(-.74076,50.62047,-2.83329),(-.69905,50.71388,-2.84822),(-.61408,50.67577,-2.84378),(-.61659,50.32745,-2.94339),(-.67213,50.41696,-2.85465),(-.55417,50.19527,-2.39723),(-.52052,50.19056,-2.39973),(0,50.26393,-2.31978),(0,50.22505,-2.214),(-.15718,50.22896,-2.22364),(-.77404,50.5561,-2.79653),(-.78402,50.54486,-2.75895),(-.87889,50.55608,-2.76209),(-.4748,50.92718,-2.33321),(-.51582,50.88425,-2.35354),(-.3872,50.39072,-2.54383),(-.44827,50.40887,-2.52703),(0,50.60124,-1.60497),(-.44639,50.23982,-2.4642),(-.38516,50.11649,-2.10806),(-.4488,50.10148,-2.13946),(-.61964,50.23173,-2.403),(-.62153,50.22035,-2.38157),(-.66429,50.26863,-2.41245),(-.54699,50.3003,-2.54202),(-.5498,50.28338,-2.53673),(-.63477,50.29344,-2.47565),(-.14881,50.28606,-2.5445),(-1.09711,50.72535,-2.81886),(-.88062,50.56516,-2.72362),(-.87162,50.63627,-2.66231),(-1.03007,50.93308,-2.99456),(-.41323,50.8559,-2.67205),(-.31064,50.85623,-2.73176),(-1.06453,50.68472,-2.94436),(-.99583,50.64301,-2.88843),(-.20202,50.28332,-3.07064),(-.35816,50.46312,-3.00284),(-.23532,50.69972,-2.69646),(-.97259,50.54897,-2.7707),(-.41362,50.87504,-2.64337),(-.4509,51.18362,-2.35137),(-.27748,51.11227,-2.44726),(-.28547,51.11352,-2.45434),(-.2856,50.97689,-2.57979),(-.42542,51.00164,-2.51654),(-.3085,50.87539,-2.7107),(-.42504,50.85869,-2.7143),(-.31681,50.84627,-2.74875),(-.57499,50.87146,-2.75115),(-.58609,50.78165,-2.80651),(-.17284,50.85715,-2.70375),(-.13294,50.8357,-2.73794),(-1.09989,50.79502,-2.78802),(-.4694,51.00976,-2.49547),(.01256,50.11393,-3.63093),(.04512,50.14178,-3.48469),(0,50.14908,-3.37324),(.35063,50.80309,-2.80358),(.44528,50.82886,-2.76528),(.42504,50.85869,-2.70581),(.23981,50.97173,-2.59699),(.62659,51.00411,-2.41323),(.66666,50.90513,-2.52759),(0,50.80366,-2.82931),(.00543,50.8032,-2.82955),(1.03509,50.58,-2.70051),(1.02195,50.68398,-2.66879),(1.15091,50.7457,-2.95048),(1.07236,50.84565,-2.67761),(.28179,50.89991,-2.51146),(.3265,50.99663,-2.41681),(.35181,50.92985,-2.37552),(.06532,50.77783,-3.00827),(.04822,50.72498,-3.15516),(.01579,50.74341,-3.15058),(.52054,51.01408,-2.46256),(1.11465,51.0456,-2.85884),(1.20107,51.0242,-2.8379),(1.0296,50.61158,-2.85525),(.97259,50.54897,-2.75279),(.87889,50.55608,-2.7446),(.99583,50.64301,-2.87402),(.84905,50.73474,-2.58419),(.93124,50.76897,-2.60163),(1.10218,50.73362,-2.82138),(1.0984,50.67133,-2.88858),(1.11324,50.7514,-2.83203),(.56674,50.17062,-2.32728),(.62153,50.22035,-2.36025),(.56842,50.17477,-2.3093),(.55496,50.16284,-2.31233),(.52561,50.1586,-2.3056),(.16947,50.0827,-1.87328),(.63801,50.31111,-2.45285),(.54609,50.62032,-2.51049),(.49692,50.59196,-2.55057),(.55696,50.59755,-2.59102),(.48084,50.72481,-2.16995),(.48483,50.78083,-2.21799),(.45826,50.52112,-1.96493),(.49107,50.57533,-2.07212),(.47004,50.62247,-1.93148),(.13441,50.65557,-1.70469),(.31853,50.60918,-2.52544),(.33467,50.62991,-2.71783),(.3996,50.61936,-2.68317),(.4984,50.61138,-2.37255),(.15718,50.22896,-2.21737),(.53312,50.34169,-2.95011),(.48321,50.49353,-2.92767),(.59018,50.53498,-2.86064),(.74076,50.62047,-2.81886),(.66204,50.58264,-2.82882),(.61408,50.67577,-2.83166),(1.24087,50.85586,-2.87686),(1.00568,50.68267,-2.66672),(.55342,50.87378,-2.73075),(.55632,50.86364,-2.7448),(.57499,50.87146,-2.74091),(.58153,50.88551,-2.72081),(.67487,50.95364,-2.72215),(.81998,50.82993,-2.53885),(.59952,50.90408,-2.67291),(1.1945,50.98235,-2.91672),(1.16274,51.00751,-2.8937),(.76959,50.94537,-2.79222),(.90354,51.06161,-2.768),(1.13712,50.77075,-2.99047),(1.2062,50.86675,-2.97513),(1.10499,50.82054,-3.02465),(.98814,51.02203,-2.89509),(1.17765,50.92033,-2.9989),(.67607,50.82439,-2.80976),(.67431,50.91041,-2.76201),(.22722,50.31745,-3.11246),(.17124,50.28702,-3.19617),(.10999,50.25358,-3.33876),(.07181,50.224,-3.48529),(.05493,50.16703,-3.76476),(.05131,50.20591,-3.61949),(.19602,50.83846,-2.82126),(.22242,50.85889,-2.77518),(.42542,51.00164,-2.50817),(.41695,51.03963,-2.48411),(.0144,50.77954,-2.9978),(.12368,50.81186,-2.71596),(.44638,50.67221,-1.92657),(.29557,50.66448,-1.82442),(.50621,50.77272,-2.33582),(.5016,50.85423,-2.29649),(.51247,50.81043,-2.39586),(.28458,50.59523,-1.717),(.40034,50.61132,-1.81215),(.37598,50.48913,-1.86987),(.43379,50.4204,-2.01307),(.62467,50.22878,-2.34597),(.66919,50.28257,-2.37857),(.31117,50.21014,-2.2435),(.425,50.18883,-2.26832),(.16729,50.05287,-1.81558),(.14831,50.13956,-1.79666),(.49129,50.51065,-2.48255),(.64685,50.67888,-2.58088),(.59435,50.64648,-2.54553),(.38377,50.915,-2.25746),(.14766,50.36282,-2.50879),(.14726,50.44866,-2.463),(.38893,50.63815,-2.62717),(.4635,50.58485,-2.67883),(.55024,50.51618,-2.73202),(.4624,50.58032,-2.69232),(.42311,50.4987,-2.81678),(.46518,50.43611,-2.84959),(.4501,50.40186,-2.87363),(.53,50.26024,-2.9497),(.27341,50.48128,-2.86247),(.22608,50.50138,-2.89171),(.14682,50.49721,-2.91058),(0,50.64502,-3.56434),(.00486,50.64173,-3.56431),(.00782,50.57783,-3.66561),(0,50.3261,-3.79655),(.00012,50.47753,-3.7352),(-.00716,50.57224,-3.67032),(.00015,50.57852,-3.66751),(.00576,50.67544,-3.43107),(-.44876,50.24241,-2.46952),(-.30733,50.27017,-2.47814),(.47318,50.58555,-2.68286),(-.354,50.46923,-2.8768),(.66661,50.45608,-2.77539),(.62701,50.44857,-2.84541),(-.69096,50.30906,-2.84356),(-.15242,50.24131,-3.15725),(-.27341,50.48128,-2.86943),(-.44181,50.24064,-2.46173),(.32789,50.62665,-2.72831),(.44551,50.47263,-2.82776),(.4582,50.58711,-2.63655),(.28957,50.38192,-2.52709),(.63533,50.60451,-2.63344),(0,50.05788,-1.78183),(.39239,50.6461,-1.81236),(.1433,50.66953,-1.83038),(.10562,50.80307,-2.91438),(.2856,50.97689,-2.57401),(.28093,50.32167,-3.05794),(.02193,50.12339,-3.6309),(1.01801,50.7507,-2.97266),(.62789,50.89712,-2.62531),(.9841,50.9468,-2.63783),(1.0843,50.75941,-2.7685),(1.09204,50.71708,-2.78885),(1.23725,50.90348,-2.79624),(.69905,50.71388,-2.83564),(.15297,50.25346,-2.33221),(.49566,50.57316,-2.08774),(.63477,50.29344,-2.4554),(.58096,50.26329,-2.4659),(.5498,50.28338,-2.51901),(.16425,50.04891,-1.82746),(.40886,50.32376,-2.5441),(.42335,50.29204,-2.5494),(.2941,50.28816,-2.55043),(.87162,50.63627,-2.64471),(.52239,50.99704,-2.47485),(-1.12429,50.76918,-2.85481),(-1.24087,50.85586,-2.8851),(-1.2329,50.89169,-2.80482),(-.15695,50.40875,-2.98846),(-.09712,50.69295,-3.17026),(-.63801,50.31111,-2.47303),(-.3834,50.08328,-2.05004),(-.51653,50.22762,-2.20262),(-.47861,50.67464,-2.07291),(-.28022,50.65224,-1.73755),(-.27878,50.63875,-1.72059),(-.86674,50.58864,-2.82784),(-.15297,50.25346,-2.33807),(-.48321,50.49353,-2.93852),(-1.23199,50.92039,-2.9032),(-1.09204,50.71708,-2.80307),(-1.0843,50.75941,-2.7823),(-1.11324,50.7514,-2.84471),(-.92364,51.06573,-2.74051),(-.7661,50.86636,-2.86019),(-.01883,50.6495,-3.43473),(-.27418,50.70535,-2.92295),(-.38107,50.65869,-1.83282),(0,50.15808,-2.02893),(-.58434,50.37393,-2.46096),(-.22557,50.41045,-2.97534),(-.29634,50.27629,-2.55267),(-.37327,50.8206,-2.20946),(-.468,50.73566,-2.17843),(-.37401,50.49451,-2.85017),(-.55024,50.51618,-2.7458),(-.63533,50.60451,-2.64877),(-.31117,50.21014,-2.25564),(-.2718,50.35696,-1.84362),(-.1433,50.66953,-1.83538),(-.23185,50.96951,-2.594),(-.21294,50.84136,-2.81199),(-.03276,50.51254,-3.58142),(-.01566,50.61617,-3.56938),(-.07181,50.224,-3.4864),(-.80179,50.75803,-2.87586),(-.67607,50.82439,-2.82097),(-1.01801,50.7507,-2.98342),(-.81995,50.82778,-2.56728),(-1.06376,51.04555,-2.70911),(-.29618,50.68817,-2.49615),(-.48084,50.72481,-2.18397),(-.58096,50.26329,-2.48501),(-.59191,50.71563,-2.5167),(-.52561,50.1586,-2.32503),(-.93124,50.76897,-2.61789),(-.00543,50.8032,-2.82966),(.58609,50.78165,-2.7956),(.3085,50.87539,-2.70441),(.27748,51.11227,-2.44204),(1.06453,50.68472,-2.93194),(1.07775,51.0129,-2.93494),(.54699,50.3003,-2.52456),(.61964,50.23173,-2.38199),(.66429,50.26863,-2.39074),(.51653,50.22762,-2.18333),(.12371,50.61758,-1.62618),(1.06376,51.04555,-2.70003),(.64245,50.75599,-2.53429),(.02004,50.32408,-3.78964),(.23419,50.58859,-3.03295),(.03276,50.51254,-3.58112),(.01566,50.61617,-3.56926),(.16093,50.75586,-2.95985),(.50232,51.04952,-2.44564),(.28559,50.71849,-2.06034),(.38107,50.65869,-1.82004),(.52077,50.35785,-2.51077),(.29634,50.27629,-2.5425),(.28034,50.76888,-2.16234),(.14724,50.78181,-2.16595),(0,50.09919,-3.83153),(.44876,50.24241,-2.45388),(.34119,50.62006,-2.72822),(.39581,50.50311,-2.82355),(.39535,50.45232,-2.86084),(.21968,50.28397,-3.0869),(-.15496,50.27399,-2.43965),(0,50.74679,-3.15201),(.37401,50.49451,-2.84081),(.4007,50.61194,-2.69612),(.13505,50.75995,-2.31994),(0,50.82452,-2.22899),(.14468,50.86502,-2.24366),(0,50.73191,-2.28539),(0,50.51901,-2.38504),(0,50.42931,-2.42999),(0,50.73295,-2.07698),(0,50.78898,-2.17063),(.14297,50.7298,-2.07265),(0,50.68975,-1.9696),(.14408,50.68983,-1.96552),(.59001,50.72156,-2.49951),(.46901,50.34015,-2.52699),(.15496,50.27399,-2.43396),(0,50.28256,-2.39465),(.29686,50.151,-1.88238),(.30345,50.06859,-1.91848),(.39274,50.16855,-1.97913),(.45802,50.10698,-2.11317),(.46034,50.19132,-2.08435),(.39258,50.08742,-2.02474),(.27248,50.2448,-1.87422),(.37075,50.27042,-1.96462),(.2718,50.35696,-1.83285),(.3625,50.3859,-1.9191),(.1319,50.43773,-1.7057),(.28094,50.4649,-1.78411),(.13455,50.32932,-1.75277),(.13192,50.5713,-1.63709),(0,50.66913,-1.83747),(.05742,50.54839,-3.30227),(.03583,50.53112,-3.44004),(.38988,50.7274,-2.85625),(.43258,50.62456,-2.89616),(.5329,50.64857,-2.85504),(.06191,50.38011,-3.46492),(.04489,50.35547,-3.60232),(.16045,50.4171,-3.19956),(.22039,50.43288,-3.12141),(.49263,50.74905,-2.80828),(.89562,50.79929,-2.92227),(.80179,50.75803,-2.86351),(1.0916,50.66544,-2.89878),(.74933,50.70619,-2.59457),(.44591,50.21386,-2.37237),(.53603,50.59324,-2.66058),(.14361,50.63783,-2.37876),(.23962,50.66587,-2.43705),(.76984,50.6162,-2.64829),(0,50.34259,-2.47342),(.48871,50.2828,-2.53767),(.4891,50.26651,-2.53118),(1.13149,50.8199,-2.79274),(.18491,50.58061,-3.09848),(1.09711,50.72535,-2.8051),(.45441,50.97937,-2.51515),(.48948,50.9795,-2.50294),(.47361,51.01054,-2.48424),(-1.0916,50.66544,-2.912),(-.22039,50.43288,-3.12606),(-.76984,50.6162,-2.6652),(-.78212,50.55098,-2.7223),(-.94939,51.03207,-2.6795),(-.48871,50.2828,-2.55362),(-.4891,50.26651,-2.5473),(-.45802,50.10698,-2.13154),(-.51364,50.13617,-2.22865),(-.16729,50.05287,-1.82295),(0,50.05448,-1.79922),(-.46901,50.34015,-2.54206),(-.39239,50.6461,-1.82559),(-.44638,50.67221,-1.94097),(-.14468,50.86502,-2.24764),(0,50.6182,-2.34353),(-.14361,50.63783,-2.3832),(-.54262,50.59404,-2.67176),(-.44591,50.21386,-2.38857),(-.93782,50.7082,-2.92097),(-.83828,50.66166,-2.86545),(-.89562,50.79929,-2.93334),(-.35063,50.80309,-2.81059),(-.04489,50.35547,-3.60281),(-.06191,50.38011,-3.46579),(-.05131,50.20591,-3.62012),(-.03583,50.53112,-3.44048),(-.5329,50.64857,-2.86605),(-.43258,50.62456,-2.90532),(-.3897,50.72783,-2.86399),(-.05742,50.54839,-3.30316),(-.00486,50.64173,-3.56434),(-.48473,50.97948,-2.51419),(0,50.781,-2.99736),(-.13192,50.5713,-1.64197),(0,50.55211,-1.61091),(-.40034,50.61132,-1.82587),(-.37598,50.48913,-1.88361),(0,50.43645,-1.68383),(0,50.31985,-1.72504),(-.13182,50.4414,-1.70925),(-.46034,50.19132,-2.1024),(-.36558,50.26908,-1.97447),(-.44327,50.30371,-2.0763),(-.39274,50.16855,-1.99514),(-.39258,50.08742,-2.04105),(-.29686,50.151,-1.89488),(-.30345,50.06859,-1.93151),(0,50.19203,-2.12349),(-.16005,50.19553,-2.13515),(-.30932,50.24332,-2.36814),(-.52558,50.23499,-2.4802),(-.143,50.7288,-2.0745),(-.13505,50.75995,-2.32387),(-.23962,50.66587,-2.44405),(-.3625,50.3859,-1.93294),(-.14406,50.68933,-1.96709),(-.45441,50.97937,-2.52419),(-.12637,50.57401,-3.18274),(-.09651,50.40155,-3.32712),(-.16045,50.4171,-3.20272),(-.49246,50.74946,-2.81789),(-.43758,50.59057,-2.59068),(0,50.09059,-1.84746),(-.21968,50.28397,-3.09219),(.94939,51.03207,-2.6691),(1.09989,50.79502,-2.77513),(.30932,50.24332,-2.3566),(.78212,50.55098,-2.70505),(.93782,50.7082,-2.90817),(.83828,50.66166,-2.8513),(.09651,50.40155,-3.32546),(.12637,50.57401,-3.1805),(.55268,50.83738,-2.44542),(.13506,50.22627,-1.79319),(.51364,50.13617,-2.20896),(.16005,50.19553,-2.12857),(.52558,50.23499,-2.46233),(.43959,50.30062,-2.05244),(1.02383,51.07137,-2.81115),(.43758,50.59057,-2.57874),(-1.15012,50.82378,-2.82448),(-.18491,50.58061,-3.10204),(-.28458,50.59523,-1.72716),(-.28094,50.4649,-1.79476)]))),
        Shape(DEF='t3disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t3disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,5,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,27,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,33,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,63,57,56,-1,78,55,57,-1,79,49,55,-1,46,80,47,-1,44,81,82,-1,83,84,85,-1,30,86,69,-1,87,88,89,-1,90,91,92,-1,20,31,21,-1,18,93,94,-1,95,35,96,-1,97,98,92,-1,99,100,101,-1,102,13,12,-1,103,104,105,-1,104,106,105,-1,58,107,108,-1,109,110,111,-1,109,112,110,-1,113,61,106,-1,31,71,114,-1,21,31,114,-1,113,62,61,-1,108,115,58,-1,104,7,106,-1,112,109,116,-1,117,103,105,-1,102,12,118,-1,119,120,121,-1,99,122,100,-1,100,123,101,-1,35,124,96,-1,94,19,18,-1,125,126,127,-1,20,29,31,-1,128,129,50,-1,130,83,85,-1,44,43,81,-1,80,78,47,-1,76,57,77,-1,75,77,131,-1,72,74,43,-1,31,69,71,-1,67,132,68,-1,33,32,64,-1,63,56,61,-1,58,60,107,-1,55,51,56,-1,51,55,49,-1,133,46,48,-1,45,72,43,-1,134,135,136,-1,42,137,40,-1,42,41,138,-1,37,124,35,-1,32,34,139,-1,140,141,142,-1,30,69,31,-1,143,117,144,-1,145,17,19,-1,16,146,14,-1,13,147,11,-1,8,10,148,-1,149,104,103,-1,148,7,104,-1,113,106,7,-1,5,6,3,-1,150,0,2,-1,108,151,152,-1,108,107,151,-1,153,154,155,-1,153,156,154,-1,94,157,158,-1,94,93,157,-1,118,21,114,-1,159,21,118,-1,13,160,161,-1,102,160,13,-1,6,148,10,-1,148,6,7,-1,112,3,110,-1,112,161,3,-1,162,106,61,-1,162,105,106,-1,162,117,105,-1,163,117,162,-1,164,118,114,-1,164,102,118,-1,165,100,166,-1,165,167,100,-1,168,99,101,-1,99,168,169,-1,92,16,15,-1,92,98,16,-1,122,166,100,-1,122,170,166,-1,170,171,121,-1,98,171,170,-1,98,97,171,-1,172,167,165,-1,167,172,173,-1,174,175,144,-1,174,176,175,-1,177,178,179,-1,180,178,177,-1,91,181,182,-1,91,183,181,-1,156,184,154,-1,156,185,184,-1,186,181,1,-1,186,187,181,-1,23,184,188,-1,23,189,184,-1,96,190,95,-1,190,96,191,-1,18,192,93,-1,192,18,191,-1,193,194,195,-1,193,189,194,-1,8,0,150,-1,0,8,149,-1,109,196,116,-1,155,196,109,-1,21,157,22,-1,157,21,159,-1,182,92,91,-1,182,97,92,-1,24,197,25,-1,197,24,198,-1,190,199,95,-1,190,200,199,-1,201,202,203,-1,201,204,202,-1,89,205,87,-1,205,89,83,-1,206,207,208,-1,207,206,209,-1,53,141,210,-1,141,53,142,-1,67,46,211,-1,67,80,46,-1,50,174,163,-1,50,129,174,-1,212,213,214,-1,212,215,213,-1,216,217,37,-1,218,217,216,-1,139,219,220,-1,221,219,139,-1,222,176,223,-1,176,222,177,-1,68,224,225,-1,68,132,224,-1,205,226,214,-1,205,227,226,-1,228,229,225,-1,228,208,229,-1,230,211,231,-1,211,230,232,-1,233,234,235,-1,233,236,234,-1,237,173,238,-1,237,239,173,-1,240,135,241,-1,135,240,136,-1,135,209,206,-1,209,135,134,-1,85,40,137,-1,85,84,40,-1,138,238,42,-1,237,238,138,-1,78,79,55,-1,80,79,78,-1,75,242,243,-1,242,75,131,-1,244,131,77,-1,244,60,131,-1,243,82,52,-1,82,243,44,-1,81,142,53,-1,81,74,142,-1,43,74,81,-1,218,30,217,-1,86,30,218,-1,212,231,245,-1,231,212,230,-1,29,217,30,-1,29,246,217,-1,232,67,211,-1,232,132,67,-1,247,64,32,-1,247,140,64,-1,59,45,242,-1,248,45,59,-1,151,60,244,-1,107,60,151,-1,242,60,59,-1,242,131,60,-1,62,244,63,-1,151,244,62,-1,249,138,204,-1,249,237,138,-1,39,137,241,-1,39,85,137,-1,209,236,233,-1,236,209,134,-1,250,40,84,-1,250,251,40,-1,204,41,202,-1,41,204,138,-1,252,237,249,-1,237,252,239,-1,253,236,254,-1,236,253,234,-1,255,210,141,-1,210,255,215,-1,256,208,207,-1,208,256,229,-1,227,257,226,-1,227,26,257,-1,257,132,232,-1,132,257,224,-1,223,256,222,-1,223,258,256,-1,88,220,219,-1,88,259,220,-1,201,37,36,-1,201,216,37,-1,218,34,33,-1,218,216,34,-1,259,215,255,-1,215,259,213,-1,66,80,67,-1,66,79,80,-1,210,54,53,-1,210,245,54,-1,65,69,86,-1,65,73,69,-1,27,228,28,-1,228,27,38,-1,219,89,88,-1,219,250,89,-1,249,201,36,-1,201,249,204,-1,168,190,17,-1,190,168,200,-1,188,24,23,-1,188,14,24,-1,260,171,261,-1,260,262,171,-1,127,116,196,-1,127,126,116,-1,9,150,263,-1,150,9,8,-1,174,117,163,-1,117,174,144,-1,189,154,184,-1,193,154,189,-1,264,191,96,-1,264,192,191,-1,197,19,265,-1,197,145,19,-1,176,179,175,-1,176,177,179,-1,183,1,181,-1,2,1,183,-1,185,188,184,-1,266,188,185,-1,187,182,181,-1,261,182,187,-1,263,156,153,-1,263,267,156,-1,234,268,235,-1,269,268,234,-1,173,270,167,-1,270,173,239,-1,121,166,170,-1,121,120,166,-1,262,121,171,-1,262,119,121,-1,99,16,122,-1,16,99,146,-1,167,123,100,-1,167,270,123,-1,9,110,10,-1,9,111,110,-1,116,147,112,-1,116,11,147,-1,113,5,152,-1,5,113,7,-1,3,10,110,-1,10,3,6,-1,102,115,160,-1,102,164,115,-1,93,22,157,-1,93,192,22,-1,193,155,154,-1,193,196,155,-1,271,272,186,-1,272,271,143,-1,264,29,20,-1,29,264,246,-1,150,267,263,-1,2,267,150,-1,158,273,94,-1,273,158,125,-1,118,274,159,-1,118,12,274,-1,58,164,275,-1,164,58,115,-1,4,152,5,-1,152,4,108,-1,160,3,161,-1,160,4,3,-1,149,148,104,-1,149,8,148,-1,114,275,164,-1,275,114,71,-1,120,165,166,-1,276,165,120,-1,119,276,120,-1,269,276,119,-1,24,146,198,-1,24,14,146,-1,276,172,165,-1,276,253,172,-1,271,1,0,-1,271,186,1,-1,260,179,178,-1,260,277,179,-1,183,90,278,-1,91,90,183,-1,267,185,156,-1,267,278,185,-1,187,272,277,-1,186,272,187,-1,189,25,194,-1,23,25,189,-1,17,191,18,-1,17,190,191,-1,273,194,265,-1,273,195,194,-1,149,271,0,-1,271,149,103,-1,155,111,153,-1,155,109,111,-1,159,158,157,-1,158,159,274,-1,180,268,178,-1,235,268,180,-1,15,90,92,-1,266,90,15,-1,198,145,197,-1,145,198,169,-1,35,199,252,-1,35,95,199,-1,203,251,221,-1,203,202,251,-1,227,83,130,-1,227,205,83,-1,209,279,207,-1,279,209,233,-1,208,38,206,-1,228,38,208,-1,64,142,74,-1,64,140,142,-1,211,133,231,-1,211,46,133,-1,128,49,280,-1,128,50,49,-1,32,220,247,-1,32,139,220,-1,246,37,217,-1,246,124,37,-1,34,221,139,-1,203,221,34,-1,214,87,205,-1,87,214,213,-1,225,281,68,-1,281,225,229,-1,214,230,212,-1,230,214,226,-1,225,28,228,-1,28,225,224,-1,279,177,222,-1,279,180,177,-1,223,174,129,-1,174,223,176,-1,238,172,282,-1,238,173,172,-1,206,241,135,-1,206,39,241,-1,206,38,39,-1,240,137,42,-1,241,137,240,-1,85,27,130,-1,27,85,39,-1,40,202,41,-1,40,251,202,-1,42,282,240,-1,238,282,42,-1,72,248,70,-1,45,248,72,-1,50,162,51,-1,50,163,162,-1,56,162,61,-1,51,162,56,-1,75,52,48,-1,243,52,75,-1,78,76,47,-1,78,57,76,-1,248,58,275,-1,248,59,58,-1,86,33,65,-1,218,33,86,-1,245,215,212,-1,215,245,210,-1,258,280,281,-1,258,128,280,-1,129,258,223,-1,129,128,258,-1,255,140,247,-1,141,140,255,-1,69,72,70,-1,69,73,72,-1,242,44,243,-1,242,45,44,-1,47,75,48,-1,47,76,75,-1,133,52,54,-1,52,133,48,-1,77,63,244,-1,77,57,63,-1,82,53,52,-1,82,81,53,-1,275,70,248,-1,275,71,70,-1,282,136,240,-1,282,254,136,-1,254,134,136,-1,254,236,134,-1,84,89,250,-1,83,89,84,-1,172,254,282,-1,254,172,253,-1,68,280,66,-1,280,68,281,-1,222,207,279,-1,207,222,256,-1,26,224,257,-1,26,28,224,-1,226,232,230,-1,232,226,257,-1,258,229,256,-1,258,281,229,-1,88,213,259,-1,88,87,213,-1,216,203,34,-1,201,203,216,-1,259,247,220,-1,255,247,259,-1,280,79,66,-1,280,49,79,-1,133,245,231,-1,245,133,54,-1,64,73,65,-1,64,74,73,-1,233,180,279,-1,233,235,180,-1,26,130,27,-1,26,227,130,-1,221,250,219,-1,221,251,250,-1,249,35,252,-1,36,35,249,-1,169,17,145,-1,17,169,168,-1,14,266,15,-1,188,266,14,-1,178,262,260,-1,178,268,262,-1,97,261,171,-1,97,182,261,-1,126,158,274,-1,125,158,126,-1,111,263,153,-1,263,111,9,-1,103,143,271,-1,143,103,117,-1,265,94,273,-1,94,265,19,-1,96,246,264,-1,246,96,124,-1,265,25,197,-1,25,265,194,-1,277,175,179,-1,272,175,277,-1,2,278,267,-1,2,183,278,-1,278,266,185,-1,90,266,278,-1,261,277,260,-1,261,187,277,-1,196,195,127,-1,196,193,195,-1,269,253,276,-1,269,234,253,-1,270,252,199,-1,270,239,252,-1,101,200,168,-1,101,123,200,-1,99,198,146,-1,198,99,169,-1,269,262,268,-1,269,119,262,-1,122,98,170,-1,98,122,16,-1,123,199,200,-1,270,199,123,-1,152,62,113,-1,152,151,62,-1,108,160,115,-1,160,108,4,-1,147,161,112,-1,147,13,161,-1,126,11,116,-1,274,11,126,-1,274,12,11,-1,20,192,264,-1,20,22,192,-1,125,195,273,-1,125,127,195,-1,272,144,175,-1,143,144,272,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t3disc_Coord',point=[(.38345,50.07958,-2.03514),(.3742,50.03118,-2.03112),(.4492,50.05009,-2.14959),(.425,50.18883,-2.26832),(.31117,50.21014,-2.2435),(.31723,50.17654,-2.15857),(.37481,50.15634,-2.17728),(.31261,50.13699,-2.06678),(.44583,50.1033,-2.12293),(.49976,50.12957,-2.21838),(.45302,50.129,-2.20092),(.44876,50.24241,-2.45388),(.43995,50.24582,-2.46),(.44181,50.24064,-2.44625),(.43336,50.02105,-2.44603),(.44839,49.98353,-2.34058),(.35581,49.98761,-2.37147),(.2507,50.13759,-2.60448),(.26654,50.18377,-2.59241),(.35351,50.17697,-2.57626),(.14971,50.27255,-2.53487),(.15268,50.27576,-2.52928),(.15167,50.27253,-2.53529),(.43776,50.09485,-2.54104),(.43168,50.09078,-2.54066),(.43675,50.09544,-2.54233),(-.41722,49.96913,-2.23949),(-.41112,49.96637,-2.24135),(-.41622,49.96883,-2.23715),(0,50.26403,-2.48331),(-.14971,50.27255,-2.54015),(0,50.26807,-2.47706),(-.38915,50.22641,-2.57349),(-.28105,50.23148,-2.58126),(-.26654,50.18377,-2.60176),(0,50.11879,-2.57134),(-.07785,50.12582,-2.58908),(-.09724,50.17809,-2.58457),(-.32322,49.94295,-2.07424),(-.34958,49.96566,-2.23542),(-.30832,50.05835,-2.50674),(-.21537,50.05827,-2.5242),(-.15796,50.00794,-2.38804),(-.43995,50.24582,-2.47531),(-.44181,50.24064,-2.46173),(-.30733,50.27017,-2.47814),(-.49976,50.12957,-2.23763),(-.45302,50.129,-2.21868),(-.52561,50.1586,-2.32503),(-.2936,50.06668,-1.94275),(-.1629,50.05125,-1.83743),(-.16947,50.0827,-1.88068),(-.52052,50.19056,-2.39973),(-.52217,50.23473,-2.47889),(-.55046,50.19475,-2.39752),(-.30773,50.0973,-2.0081),(-.17065,50.11291,-1.9374),(-.31261,50.13699,-2.07972),(0,50.26393,-2.31978),(-.15297,50.25346,-2.33807),(-.15718,50.22896,-2.22364),(0,50.12285,-1.90728),(0,50.15808,-2.02893),(-.16363,50.1588,-2.03648),(-.42349,50.27154,-2.55106),(-.29622,50.27295,-2.55476),(-.38345,50.07958,-2.05111),(-.44883,50.09804,-2.14137),(-.3742,50.03118,-2.04694),(-.15268,50.27576,-2.53467),(-.15099,50.27527,-2.4533),(0,50.28226,-2.40884),(-.30607,50.27231,-2.49206),(-.29691,50.27606,-2.54915),(-.4232,50.27424,-2.54622),(-.425,50.18883,-2.2845),(-.37481,50.15634,-2.19221),(-.31723,50.17654,-2.17132),(-.38516,50.11649,-2.10806),(-.38078,50.08548,-2.05152),(-.44583,50.1033,-2.14086),(-.44876,50.24241,-2.46952),(-.44639,50.23982,-2.4642),(-.43336,50.02105,-2.46246),(-.37272,50.03966,-2.48509),(-.35581,49.98761,-2.38568),(-.15167,50.27253,-2.54064),(-.43776,50.09485,-2.55665),(-.43675,50.09544,-2.55789),(-.43168,50.09078,-2.5561),(.41722,49.96913,-2.22233),(.41622,49.96883,-2.22001),(.41112,49.96637,-2.2244),(.28105,50.23148,-2.57153),(.38915,50.22641,-2.56023),(.07785,50.12582,-2.58621),(.09724,50.17809,-2.58106),(.32322,49.94295,-2.06022),(.34958,49.96566,-2.22079),(.30832,50.05835,-2.49505),(.15796,50.00794,-2.38158),(.21537,50.05827,-2.51598),(.30733,50.27017,-2.46724),(.2936,50.06668,-1.93013),(.30773,50.0973,-1.99508),(.16947,50.0827,-1.87328),(.17065,50.11291,-1.93003),(0,50.22505,-2.214),(.15718,50.22896,-2.21737),(.55046,50.19475,-2.37806),(.52561,50.1586,-2.3056),(.55119,50.16317,-2.31343),(.52052,50.19056,-2.38113),(.16363,50.1588,-2.02957),(.15099,50.27527,-2.44779),(.15297,50.25346,-2.33221),(.52217,50.23473,-2.46111),(.1629,50.05125,-1.83025),(.30607,50.27231,-2.48127),(.14907,49.94703,-1.98417),(.1707,49.96346,-2.07359),(.23596,49.95662,-2.06237),(.28604,49.99391,-2.37839),(.15081,50.05822,-2.52965),(0,50.16833,-2.54702),(.4841,50.25732,-2.51661),(.48395,50.25986,-2.51219),(.48554,50.25691,-2.51593),(-.1647,50.04522,-1.83575),(-.16271,50.04523,-1.83438),(-.44839,49.98353,-2.35827),(-.31117,50.21014,-2.25564),(-.4492,50.05009,-2.16782),(-.55119,50.16317,-2.33356),(-.14907,49.94703,-1.99084),(-.23596,49.95662,-2.07272),(-.1707,49.96346,-2.08111),(-.28604,49.99391,-2.38994),(-.15081,50.05822,-2.53542),(-.35351,50.17697,-2.58857),(-.4841,50.25732,-2.53277),(-.48554,50.25691,-2.53213),(-.48395,50.25986,-2.52835),(.1647,50.04522,-1.82848),(.16271,50.04523,-1.8272),(.31606,50.13172,-2.5837),(.37272,50.03966,-2.47095),(.44639,50.23982,-2.44859),(.38516,50.11649,-2.09232),(.38078,50.08548,-2.03567),(.44883,50.09804,-2.12331),(0,50.19203,-2.12349),(.16005,50.19553,-2.12857),(.55404,50.15944,-2.31437),(.52708,50.13048,-2.40496),(.55277,50.19191,-2.3791),(.53314,50.09586,-2.32142),(.29622,50.27295,-2.54459),(.42349,50.27154,-2.53689),(.29691,50.27606,-2.53894),(.30932,50.24332,-2.3566),(.44591,50.21386,-2.37237),(0,50.09059,-1.84746),(0,50.05673,-1.80225),(.15496,50.27399,-2.43396),(.08453,49.98446,-2.24238),(.17477,49.97937,-2.23721),(.07898,50.01841,-2.3849),(.24979,50.13168,-2.6026),(.31398,50.126,-2.58135),(.27198,49.97059,-2.22603),(.3166,49.94211,-2.04897),(0,49.98792,-2.24429),(0,50.02889,-2.38708),(0,50.05075,-1.7992),(.14067,49.99262,-1.82318),(0,49.99551,-1.79864),(0,49.93749,-1.8093),(.07683,49.89441,-1.85136),(.11171,49.9399,-1.83208),(0,49.88786,-1.83659),(.35361,49.98378,-2.03605),(.32362,49.94437,-2.04729),(.43793,50.00506,-2.18353),(.48805,50.07241,-2.42783),(.49882,50.03603,-2.33068),(.3144,50.01793,-1.95914),(.32302,49.97701,-1.99924),(.43976,50.02363,-2.4451),(.47257,50.1371,-2.52047),(.15468,50.12665,-2.61299),(.15197,50.17996,-2.59761),(.15063,50.22962,-2.56897),(.50254,50.18491,-2.49395),(.45691,50.14694,-2.54069),(.47389,50.20314,-2.5315),(.52415,50.23187,-2.46431),(.37539,50.11676,-2.55932),(.37266,50.11134,-2.55678),(.07884,50.1199,-2.5848),(.15557,50.12079,-2.61133),(-.15468,50.12665,-2.61856),(-.24979,50.13168,-2.61152),(-.2507,50.13759,-2.6134),(-.15557,50.12079,-2.61696),(-.43976,50.02363,-2.46173),(-.3166,49.94211,-2.06275),(-.15758,49.91443,-1.906),(-.32139,49.94388,-2.05858),(-.15446,49.91294,-1.91115),(-.52415,50.23187,-2.48215),(-.50275,50.12493,-2.23781),(-.52708,50.13048,-2.424),(-.47257,50.1371,-2.53704),(-.48805,50.07241,-2.44589),(-.50254,50.18491,-2.5113),(-.15197,50.17996,-2.60303),(-.12173,50.23018,-2.56669),(-.15063,50.22962,-2.5743),(-.37539,50.11676,-2.57272),(-.41476,50.16106,-2.57074),(-.31606,50.13172,-2.59495),(-.11171,49.9399,-1.83713),(-.14067,49.99262,-1.82947),(-.43793,50.00506,-2.20144),(-.35361,49.98378,-2.05123),(-.49882,50.03603,-2.34987),(-.45458,49.98612,-2.35586),(-.32362,49.94437,-2.06135),(-.32302,49.97701,-2.01325),(-.53314,50.09586,-2.34139),(-.55404,50.15944,-2.33459),(-.48588,50.06817,-2.23349),(-.07494,49.8929,-1.8601),(0,49.94902,-1.94358),(0,49.88634,-1.84144),(-.07453,49.95155,-1.96673),(-.07541,50.0694,-2.52957),(-.07898,50.01841,-2.38814),(0,50.08058,-2.5227),(-.17477,49.97937,-2.24467),(-.27198,49.97059,-2.23754),(-.30932,50.24332,-2.36814),(-.44591,50.21386,-2.38857),(-.16005,50.19553,-2.13515),(-.55277,50.19191,-2.39864),(0,50.21892,-2.51622),(-.45217,50.21082,-2.55687),(-.15496,50.27399,-2.43965),(-.07884,50.1199,-2.5877),(-.37266,50.11134,-2.57013),(-.31398,50.126,-2.59256),(0,50.11328,-2.57014),(0,49.97465,-2.09142),(-.08194,49.96981,-2.08779),(-.47389,50.20314,-2.54762),(-.16804,49.95251,-1.87357),(-.45643,50.01402,-2.2349),(-.17037,49.99829,-1.84884),(-.45691,50.14694,-2.55659),(.15758,49.91443,-1.89888),(.32139,49.94388,-2.0446),(.15446,49.91294,-1.90417),(.50275,50.12493,-2.21844),(.12173,50.23018,-2.56236),(.41476,50.16106,-2.55631),(.45458,49.98612,-2.33795),(.48588,50.06817,-2.21433),(.07494,49.8929,-1.85669),(.07453,49.95155,-1.96337),(.07541,50.0694,-2.52667),(.29601,50.06067,-1.92907),(.17037,49.99829,-1.84125),(.45217,50.21082,-2.5415),(.4232,50.27424,-2.53204),(0,50.28256,-2.39465),(.08194,49.96981,-2.08416),(.16804,49.95251,-1.86602),(.45643,50.01402,-2.2165),(-.07683,49.89441,-1.85486),(-.29601,50.06067,-1.94181),(-.3144,50.01793,-1.97274),(-.08453,49.98446,-2.246)]))),
        Shape(
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,15,-1,20,21,22,-1,21,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,31,34,35,-1,36,37,1,-1,38,36,20,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,47,49,-1,39,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,66,-1,67,34,68,-1,36,69,37,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,94,95,96,-1,97,98,99,-1,100,101,102,-1,102,103,104,-1,105,106,107,-1,93,108,109,-1,110,111,107,-1,112,113,16,-1,114,113,112,-1,115,116,117,-1,118,119,117,-1,120,121,122,-1,122,123,124,-1,125,126,127,-1,128,129,130,-1,131,132,133,-1,134,135,136,-1,137,138,139,-1,140,141,142,-1,140,142,143,-1,144,145,146,-1,147,148,149,-1,132,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,164,165,166,-1,167,168,140,-1,169,170,171,-1,172,173,174,-1,175,176,177,-1,178,179,180,-1,181,182,183,-1,3,184,4,-1,73,55,185,-1,186,187,29,-1,29,187,188,-1,189,95,190,-1,191,192,193,-1,194,89,195,-1,196,197,198,-1,199,194,200,-1,201,202,199,-1,203,204,205,-1,11,8,206,-1,207,208,209,-1,210,211,209,-1,99,212,94,-1,213,98,97,-1,62,214,213,-1,215,216,217,-1,218,91,219,-1,220,75,78,-1,78,75,74,-1,5,4,221,-1,222,5,223,-1,102,224,225,-1,226,227,228,-1,218,224,92,-1,229,230,231,-1,46,232,233,-1,234,235,236,-1,237,238,239,-1,240,241,242,-1,243,233,244,-1,245,246,21,-1,247,22,248,-1,249,250,251,-1,252,253,144,-1,254,255,154,-1,256,257,258,-1,81,259,79,-1,260,257,256,-1,261,262,263,-1,145,253,264,-1,265,266,267,-1,268,269,270,-1,271,272,273,-1,274,170,275,-1,276,277,278,-1,258,257,279,-1,80,280,281,-1,137,139,282,-1,157,283,163,-1,284,285,286,-1,287,288,109,-1,108,102,101,-1,289,108,101,-1,290,291,109,-1,292,293,294,-1,295,296,297,-1,298,299,300,-1,301,302,303,-1,304,305,306,-1,307,18,17,-1,72,38,70,-1,308,309,310,-1,302,311,312,-1,311,313,314,-1,311,315,313,-1,308,310,316,-1,308,114,309,-1,317,318,172,-1,319,320,125,-1,125,320,120,-1,124,321,322,-1,323,324,119,-1,325,326,327,-1,123,122,121,-1,328,329,330,-1,331,332,328,-1,333,334,335,-1,336,337,338,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,355,353,-1,356,357,358,-1,359,360,361,-1,362,363,364,-1,365,366,367,-1,368,369,370,-1,371,372,373,-1,374,375,376,-1,377,378,379,-1,380,381,382,-1,383,384,385,-1,386,387,380,-1,388,387,386,-1,389,390,391,-1,383,392,393,-1,394,393,350,-1,395,396,397,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,411,412,-1,413,414,415,-1,414,416,417,-1,418,419,420,-1,421,422,423,-1,424,425,426,-1,427,428,429,-1,430,431,432,-1,433,434,419,-1,435,436,431,-1,437,435,430,-1,438,439,440,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,447,459,460,-1,461,462,463,-1,464,465,466,-1,467,465,464,-1,468,469,470,-1,468,471,472,-1,473,474,475,-1,476,477,475,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,488,489,-1,207,490,491,-1,492,493,494,-1,495,492,496,-1,497,498,499,-1,500,501,502,-1,503,491,504,-1,505,506,507,-1,505,508,506,-1,498,497,509,-1,510,511,512,-1,513,514,515,-1,516,517,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,528,529,530,-1,530,529,531,-1,518,532,526,-1,533,522,534,-1,535,536,537,-1,538,329,539,-1,332,539,329,-1,538,540,541,-1,542,543,342,-1,399,544,545,-1,409,429,407,-1,409,546,547,-1,381,383,393,-1,548,391,549,-1,550,551,552,-1,544,553,349,-1,554,555,556,-1,557,558,556,-1,559,557,560,-1,561,562,563,-1,440,564,438,-1,553,399,565,-1,566,567,568,-1,569,570,571,-1,569,572,573,-1,574,338,337,-1,334,333,575,-1,576,334,575,-1,577,578,579,-1,577,580,581,-1,582,351,353,-1,341,583,584,-1,585,586,376,-1,586,585,364,-1,473,587,588,-1,589,478,590,-1,587,548,388,-1,505,483,482,-1,591,592,593,-1,594,595,485,-1,595,486,485,-1,596,597,591,-1,492,494,496,-1,406,405,440,-1,403,402,598,-1,599,552,551,-1,600,390,389,-1,401,601,602,-1,603,396,604,-1,605,606,607,-1,608,480,609,-1,610,611,612,-1,613,514,614,-1,615,518,525,-1,518,616,516,-1,617,598,618,-1,619,620,621,-1,622,623,0,-1,624,625,626,-1,627,628,527,-1,629,630,386,-1,631,632,484,-1,633,632,466,-1,634,467,635,-1,533,636,637,-1,633,465,467,-1,632,504,484,-1,638,639,586,-1,469,468,640,-1,468,472,640,-1,641,642,643,-1,644,624,645,-1,646,647,648,-1,649,526,532,-1,619,650,651,-1,651,652,653,-1,361,622,654,-1,361,360,623,-1,655,656,657,-1,617,658,659,-1,618,457,456,-1,660,661,658,-1,657,662,663,-1,510,512,664,-1,520,525,521,-1,463,514,613,-1,611,512,511,-1,513,665,605,-1,605,666,513,-1,667,564,604,-1,668,669,519,-1,447,402,401,-1,401,670,601,-1,499,671,672,-1,673,674,675,-1,492,495,676,-1,677,678,679,-1,680,87,681,-1,508,592,682,-1,388,386,630,-1,590,483,589,-1,588,481,480,-1,374,683,684,-1,685,683,374,-1,386,686,371,-1,584,687,688,-1,575,116,115,-1,333,118,116,-1,689,690,335,-1,690,691,692,-1,573,572,693,-1,347,568,694,-1,544,399,553,-1,395,400,695,-1,695,696,697,-1,417,416,698,-1,561,441,443,-1,699,700,701,-1,702,555,427,-1,556,424,554,-1,553,703,349,-1,551,550,704,-1,393,394,382,-1,383,547,392,-1,412,546,409,-1,697,545,421,-1,705,546,706,-1,433,418,707,-1,344,343,708,-1,540,538,539,-1,709,538,541,-1,710,711,712,-1,713,628,714,-1,615,669,715,-1,716,717,532,-1,517,718,532,-1,673,719,589,-1,595,720,508,-1,721,495,722,-1,723,724,506,-1,486,595,482,-1,498,725,726,-1,727,728,729,-1,674,730,731,-1,484,486,482,-1,474,588,608,-1,391,548,473,-1,459,600,732,-1,636,470,733,-1,471,468,636,-1,683,734,629,-1,629,735,736,-1,464,734,737,-1,738,739,455,-1,740,741,454,-1,451,450,647,-1,742,743,744,-1,598,449,448,-1,446,745,625,-1,746,626,625,-1,747,748,415,-1,702,435,437,-1,436,749,750,-1,438,751,439,-1,752,432,753,-1,414,751,416,-1,754,430,755,-1,756,757,429,-1,758,759,701,-1,699,560,760,-1,428,761,408,-1,762,403,617,-1,563,604,396,-1,395,397,359,-1,392,546,705,-1,549,383,763,-1,389,764,475,-1,763,385,548,-1,686,382,765,-1,381,380,384,-1,386,766,684,-1,767,684,766,-1,372,371,765,-1,369,768,378,-1,768,379,378,-1,362,585,376,-1,769,358,770,-1,687,584,771,-1,772,773,774,-1,623,643,642,-1,775,776,777,-1,778,777,779,-1,356,358,382,-1,780,345,339,-1,781,344,782,-1,569,573,783,-1,690,784,337,-1,334,785,335,-1,323,118,786,-1,692,335,690,-1,787,788,789,-1,326,788,327,-1,790,119,121,-1,791,792,321,-1,114,793,135,-1,794,172,174,-1,795,309,128,-1,303,150,796,-1,797,798,316,-1,113,798,799,-1,315,300,313,-1,72,36,38,-1,298,300,155,-1,295,297,800,-1,801,802,110,-1,111,803,804,-1,289,290,108,-1,294,804,805,-1,806,158,807,-1,155,808,288,-1,158,809,810,-1,288,811,93,-1,284,217,812,-1,156,303,283,-1,813,814,815,-1,816,817,259,-1,277,162,818,-1,819,161,275,-1,271,260,820,-1,821,257,260,-1,822,823,170,-1,274,249,824,-1,148,166,165,-1,276,146,145,-1,825,263,262,-1,171,823,826,-1,252,825,254,-1,263,252,827,-1,258,79,828,-1,250,143,829,-1,830,71,70,-1,831,832,833,-1,20,22,247,-1,243,244,815,-1,834,242,27,-1,835,239,222,-1,238,836,231,-1,46,837,232,-1,832,838,839,-1,840,54,227,-1,839,841,13,-1,839,842,9,-1,222,843,844,-1,220,845,183,-1,14,218,219,-1,215,286,846,-1,846,286,847,-1,848,98,849,-1,99,94,850,-1,851,852,211,-1,83,853,854,-1,200,194,855,-1,189,200,855,-1,856,857,858,-1,202,90,89,-1,859,193,90,-1,88,96,195,-1,860,861,862,-1,53,52,63,-1,60,64,863,-1,864,188,226,-1,56,55,865,-1,180,206,178,-1,866,30,57,-1,867,868,869,-1,870,869,868,-1,188,30,29,-1,3,871,872,-1,184,873,874,-1,875,876,787,-1,327,787,876,-1,875,176,877,-1,794,878,879,-1,249,251,880,-1,167,133,168,-1,278,169,881,-1,162,153,160,-1,163,160,159,-1,216,809,882,-1,882,158,160,-1,883,152,154,-1,268,884,820,-1,279,821,273,-1,141,137,273,-1,885,128,130,-1,886,125,127,-1,175,321,792,-1,790,117,119,-1,305,117,790,-1,887,301,888,-1,802,801,798,-1,793,112,306,-1,115,889,890,-1,104,103,17,-1,97,219,215,-1,95,212,848,-1,215,219,91,-1,96,850,94,-1,891,859,90,-1,211,852,191,-1,892,893,894,-1,83,854,861,-1,895,853,896,-1,82,897,83,-1,898,858,899,-1,817,79,259,-1,243,814,900,-1,152,901,882,-1,813,77,76,-1,902,220,78,-1,814,281,280,-1,66,903,904,-1,213,214,98,-1,905,62,61,-1,75,182,865,-1,906,57,188,-1,188,864,907,-1,44,47,243,-1,845,837,908,-1,909,36,1,-1,910,2,911,-1,912,913,914,-1,50,248,22,-1,866,915,916,-1,93,92,224,-1,14,851,12,-1,13,12,10,-1,11,917,9,-1,0,2,918,-1,0,918,622,-1,919,325,323,-1,872,871,206,-1,11,871,917,-1,10,842,13,-1,102,93,224,-1,920,866,916,-1,912,921,913,-1,1,0,909,-1,910,33,2,-1,845,232,837,-1,44,243,900,-1,922,51,50,-1,57,30,188,-1,906,185,57,-1,75,183,182,-1,905,214,62,-1,923,847,73,-1,66,65,903,-1,814,280,830,-1,830,280,282,-1,813,76,924,-1,925,284,926,-1,152,883,901,-1,243,815,814,-1,817,828,79,-1,897,927,494,-1,894,891,892,-1,191,196,211,-1,193,88,90,-1,851,14,99,-1,96,192,850,-1,91,216,215,-1,215,846,97,-1,17,297,104,-1,115,890,928,-1,929,793,306,-1,802,798,797,-1,155,315,156,-1,305,889,117,-1,791,124,123,-1,175,930,321,-1,120,320,121,-1,885,130,931,-1,132,932,133,-1,79,258,80,-1,273,142,141,-1,933,270,934,-1,145,144,253,-1,154,255,883,-1,882,160,152,-1,216,882,812,-1,806,157,158,-1,163,162,160,-1,162,277,264,-1,167,131,133,-1,249,880,822,-1,794,879,177,-1,327,788,787,-1,184,874,935,-1,54,228,227,-1,868,936,870,-1,866,57,56,-1,865,55,73,-1,180,872,206,-1,228,864,226,-1,56,865,182,-1,937,938,939,-1,58,60,863,-1,63,940,53,-1,88,192,96,-1,941,210,209,-1,856,858,898,-1,862,942,860,-1,943,927,897,-1,897,494,896,-1,207,209,198,-1,211,210,851,-1,846,847,213,-1,847,286,285,-1,215,217,286,-1,219,97,14,-1,183,75,220,-1,222,844,835,-1,229,839,9,-1,842,839,13,-1,840,227,944,-1,218,92,91,-1,839,229,832,-1,77,902,78,-1,46,45,837,-1,238,231,239,-1,27,26,834,-1,77,244,233,-1,831,245,945,-1,830,282,71,-1,946,262,947,-1,827,261,263,-1,252,263,825,-1,825,262,948,-1,145,264,276,-1,149,148,165,-1,822,824,249,-1,170,824,822,-1,260,271,821,-1,820,949,271,-1,137,280,950,-1,281,814,813,-1,139,71,282,-1,157,156,283,-1,158,157,159,-1,812,926,284,-1,91,93,811,-1,288,808,811,-1,810,807,158,-1,155,806,808,-1,804,951,805,-1,100,104,296,-1,290,109,108,-1,293,111,804,-1,110,952,801,-1,953,295,800,-1,155,287,298,-1,790,954,305,-1,772,15,19,-1,312,314,955,-1,955,956,312,-1,299,313,300,-1,799,16,113,-1,283,303,796,-1,128,957,795,-1,794,958,172,-1,791,321,124,-1,306,305,954,-1,119,123,121,-1,954,121,320,-1,326,959,788,-1,958,317,172,-1,789,960,787,-1,329,538,709,-1,118,333,786,-1,337,691,690,-1,961,570,569,-1,782,962,781,-1,350,349,776,-1,780,354,353,-1,778,357,356,-1,778,779,357,-1,777,778,775,-1,780,963,345,-1,359,964,360,-1,965,586,639,-1,771,966,687,-1,578,350,775,-1,578,577,350,-1,776,775,350,-1,376,375,362,-1,967,372,765,-1,373,767,766,-1,386,684,683,-1,765,371,686,-1,475,477,389,-1,393,392,705,-1,395,563,396,-1,564,968,604,-1,438,698,416,-1,407,428,408,-1,421,411,418,-1,418,422,421,-1,419,418,433,-1,431,404,432,-1,758,701,700,-1,404,431,436,-1,429,749,756,-1,755,969,754,-1,970,752,753,-1,670,440,405,-1,438,416,751,-1,749,550,750,-1,702,756,435,-1,625,971,446,-1,447,449,402,-1,744,972,742,-1,973,451,647,-1,740,454,974,-1,469,975,976,-1,457,448,458,-1,739,977,455,-1,736,630,629,-1,517,664,461,-1,683,685,734,-1,468,470,636,-1,733,637,636,-1,732,668,459,-1,978,459,668,-1,736,587,388,-1,473,764,391,-1,612,608,609,-1,588,480,608,-1,481,483,590,-1,504,491,485,-1,207,491,208,-1,979,496,494,-1,495,496,722,-1,506,724,507,-1,497,980,981,-1,726,499,498,-1,728,982,723,-1,682,723,506,-1,501,726,725,-1,983,721,722,-1,505,595,508,-1,589,984,673,-1,532,518,517,-1,716,532,718,-1,615,520,669,-1,533,637,537,-1,714,985,713,-1,523,986,987,-1,988,989,342,-1,708,782,344,-1,433,707,990,-1,706,348,705,-1,697,696,545,-1,429,428,407,-1,704,429,409,-1,393,382,381,-1,704,547,551,-1,702,427,757,-1,699,991,700,-1,561,697,441,-1,697,561,695,-1,695,563,395,-1,694,992,347,-1,333,116,575,-1,575,115,576,-1,566,347,993,-1,780,584,354,-1,584,688,354,-1,366,994,368,-1,766,386,371,-1,995,994,996,-1,586,355,688,-1,588,631,481,-1,483,507,589,-1,482,481,484,-1,682,506,508,-1,505,482,595,-1,597,727,591,-1,680,997,87,-1,677,679,681,-1,676,998,999,-1,673,730,674,-1,499,726,671,-1,440,670,564,-1,602,459,447,-1,668,732,669,-1,964,359,397,-1,361,654,1000,-1,1001,1002,653,-1,611,511,612,-1,463,515,514,-1,525,520,615,-1,518,1003,616,-1,512,462,664,-1,658,618,660,-1,456,660,618,-1,617,659,762,-1,655,657,1004,-1,360,643,623,-1,653,1002,651,-1,651,620,619,-1,918,621,622,-1,646,972,647,-1,644,645,452,-1,643,745,641,-1,643,625,745,-1,639,638,774,-1,586,688,638,-1,632,631,466,-1,467,634,633,-1,522,524,534,-1,635,534,634,-1,633,466,465,-1,386,683,629,-1,527,1005,627,-1,619,621,918,-1,623,622,361,-1,1006,1007,1008,-1,1008,458,1006,-1,618,658,617,-1,1009,663,662,-1,525,518,526,-1,615,1003,518,-1,613,614,1010,-1,612,609,610,-1,715,669,476,-1,607,666,605,-1,460,459,978,-1,602,447,401,-1,551,549,599,-1,598,617,403,-1,439,406,440,-1,501,725,502,-1,676,999,492,-1,677,493,678,-1,999,509,679,-1,596,981,597,-1,720,592,508,-1,484,481,631,-1,505,507,483,-1,587,473,548,-1,474,473,588,-1,586,364,355,-1,586,1011,376,-1,1012,994,1013,-1,583,771,584,-1,353,367,582,-1,577,579,580,-1,382,394,356,-1,576,966,334,-1,692,691,333,-1,337,1014,574,-1,689,335,783,-1,569,571,572,-1,568,347,566,-1,563,695,561,-1,698,562,417,-1,406,439,753,-1,439,751,753,-1,413,991,699,-1,557,556,1015,-1,757,756,702,-1,554,427,555,-1,544,349,348,-1,550,552,750,-1,549,763,548,-1,546,392,547,-1,547,704,409,-1,761,990,707,-1,545,696,399,-1,342,1016,542,-1,329,328,332,-1,537,1017,535,-1,462,461,664,-1,530,531,1018,-1,527,521,525,-1,519,669,520,-1,522,986,523,-1,664,517,516,-1,521,713,519,-1,1019,1020,1021,-1,515,1022,513,-1,510,1023,511,-1,593,592,720,-1,729,682,592,-1,502,1024,500,-1,984,724,982,-1,982,724,723,-1,999,679,678,-1,487,489,1025,-1,484,504,485,-1,764,473,475,-1,471,741,472,-1,469,976,470,-1,464,739,467,-1,464,466,735,-1,463,1026,461,-1,736,388,630,-1,456,458,1008,-1,453,974,454,-1,741,471,454,-1,452,645,450,-1,598,402,449,-1,643,746,625,-1,444,1027,977,-1,1028,969,755,-1,754,437,430,-1,431,430,435,-1,430,432,755,-1,429,757,427,-1,554,424,426,-1,420,423,422,-1,418,420,422,-1,415,414,417,-1,413,415,748,-1,563,667,604,-1,968,401,403,-1,398,565,399,-1,706,421,545,-1,706,411,421,-1,393,705,350,-1,389,391,764,-1,380,686,386,-1,383,385,763,-1,382,686,380,-1,381,384,383,-1,379,1029,377,-1,373,766,371,-1,369,378,370,-1,366,582,367,-1,364,585,362,-1,334,966,785,-1,772,774,638,-1,777,1030,779,-1,1030,1031,779,-1,770,358,357,-1,354,688,355,-1,350,705,348,-1,346,993,347,-1,344,988,342,-1,336,691,337,-1,771,785,966,-1,335,692,333,-1,785,783,335,-1,328,1032,331,-1,988,344,781,-1,329,709,330,-1,787,960,875,-1,325,327,1033,-1,118,323,119,-1,790,121,954,-1,122,124,322,-1,126,125,120,-1,136,319,134,-1,317,1034,318,-1,303,1035,150,-1,308,316,798,-1,798,113,308,-1,315,155,300,-1,314,312,311,-1,1035,302,312,-1,909,23,20,-1,772,19,1036,-1,304,306,112,-1,303,888,301,-1,1035,303,302,-1,296,104,297,-1,293,804,294,-1,291,287,109,-1,101,1037,289,-1,108,93,102,-1,806,807,808,-1,287,155,288,-1,809,216,810,-1,284,286,217,-1,882,809,158,-1,163,159,157,-1,139,72,71,-1,282,280,137,-1,42,900,814,-1,277,818,278,-1,271,273,821,-1,170,274,824,-1,823,171,170,-1,825,948,816,-1,267,1038,265,-1,816,254,825,-1,253,1039,264,-1,261,947,262,-1,258,828,256,-1,1039,254,154,-1,144,827,252,-1,272,271,949,-1,250,829,251,-1,246,22,21,-1,77,815,244,-1,1040,1041,1042,-1,1041,1043,1042,-1,242,834,240,-1,239,835,237,-1,229,231,832,-1,839,838,225,-1,218,841,224,-1,1044,102,225,-1,843,222,223,-1,5,221,223,-1,925,78,74,-1,216,812,217,-1,97,846,213,-1,851,850,852,-1,11,206,871,-1,979,494,927,-1,943,1045,927,-1,195,96,855,-1,862,893,1046,-1,852,850,191,-1,194,195,855,-1,898,899,1047,-1,192,88,193,-1,95,1048,190,-1,187,226,188,-1,29,1049,186,-1,185,923,73,-1,181,915,182,-1,1050,921,1051,-1,960,176,875,-1,877,876,875,-1,175,877,176,-1,958,794,1052,-1,172,318,173,-1,171,881,169,-1,140,274,167,-1,164,166,881,-1,264,277,276,-1,153,162,264,-1,157,806,155,-1,152,160,153,-1,1053,144,146,-1,140,143,250,-1,821,279,257,-1,140,168,141,-1,258,950,80,-1,258,279,950,-1,137,141,138,-1,134,1054,135,-1,128,1054,129,-1,118,117,116,-1,117,889,115,-1,885,957,128,-1,793,114,112,-1,114,308,113,-1,16,304,112,-1,109,288,93,-1,100,102,104,-1,102,1044,103,-1,17,16,799,-1,99,14,97,-1,94,212,95,-1,850,851,99,-1,88,195,89,-1,192,191,850,-1,892,891,201,-1,87,997,85,-1,897,82,943,-1,813,924,81,-1,77,813,815,-1,75,865,73,-1,950,280,80,-1,64,66,1055,-1,52,61,63,-1,58,840,59,-1,57,185,55,-1,188,907,906,-1,53,228,54,-1,47,44,49,-1,48,45,47,-1,44,900,42,-1,41,1056,39,-1,36,909,20,-1,31,68,34,-1,31,33,910,-1,911,2,1,-1,25,1057,26,-1,21,20,23,-1,15,17,18,-1,12,851,210,-1,9,842,10,-1,6,1058,7,-1,959,1059,1060,-1,959,1032,1059,-1,962,318,1034,-1,318,962,782,-1,32,619,33,-1,32,650,619,-1,1061,8,7,-1,8,1061,206,-1,1062,832,831,-1,1062,838,832,-1,1063,1064,1065,-1,1066,1064,1063,-1,240,1067,1040,-1,240,1068,1067,-1,1042,1069,241,-1,1042,1070,1069,-1,1071,48,1041,-1,48,1071,45,-1,1072,1050,1073,-1,1050,1072,1074,-1,1074,921,1050,-1,921,1074,913,-1,1075,35,1076,-1,1075,1077,35,-1,46,243,47,-1,46,233,243,-1,1078,1079,43,-1,1079,1078,1080,-1,1081,944,1082,-1,1083,944,1081,-1,1084,1085,1086,-1,1084,1087,1085,-1,63,213,847,-1,63,62,213,-1,863,858,1088,-1,858,863,1089,-1,882,926,812,-1,882,901,926,-1,66,1090,1055,-1,1091,1090,66,-1,1047,1092,1093,-1,1047,942,1092,-1,979,1045,1094,-1,979,927,1045,-1,1095,896,494,-1,1095,895,896,-1,891,1096,859,-1,891,894,1096,-1,894,862,861,-1,894,893,862,-1,204,1092,1046,-1,203,1092,204,-1,193,1097,197,-1,193,859,1097,-1,1098,296,295,-1,1098,1099,296,-1,305,890,889,-1,304,890,305,-1,1100,802,797,-1,803,802,1100,-1,1101,127,1102,-1,1101,886,127,-1,134,67,1103,-1,134,886,67,-1,950,273,137,-1,950,279,273,-1,1104,1105,269,-1,1104,1106,1105,-1,268,1038,884,-1,268,265,1038,-1,283,1107,163,-1,283,796,1107,-1,878,174,1076,-1,174,878,794,-1,1052,177,176,-1,1052,794,177,-1,960,1108,176,-1,960,789,1108,-1,235,221,916,-1,235,223,221,-1,874,870,1049,-1,873,870,874,-1,178,869,179,-1,178,867,869,-1,1082,187,939,-1,187,1082,226,-1,866,182,915,-1,866,56,182,-1,938,1109,1051,-1,1109,938,937,-1,904,1110,1111,-1,1110,904,903,-1,1084,64,60,-1,1084,65,64,-1,847,940,63,-1,923,940,847,-1,905,1112,214,-1,857,1112,905,-1,1090,84,1113,-1,84,1090,82,-1,209,196,198,-1,211,196,209,-1,899,942,1047,-1,860,942,899,-1,1046,892,204,-1,893,892,1046,-1,897,853,83,-1,897,896,853,-1,874,920,935,-1,874,28,920,-1,1114,1058,1115,-1,1114,7,1058,-1,1116,1074,1072,-1,1116,1117,1074,-1,229,917,230,-1,229,9,917,-1,1118,1087,1119,-1,1085,1087,1118,-1,237,844,1068,-1,237,835,844,-1,77,232,902,-1,77,233,232,-1,1120,1121,24,-1,1122,1121,1120,-1,245,833,246,-1,245,831,833,-1,1123,149,1124,-1,1123,147,149,-1,270,265,268,-1,270,933,265,-1,166,146,276,-1,148,146,166,-1,881,826,164,-1,881,171,826,-1,880,823,822,-1,826,823,880,-1,273,143,142,-1,273,272,143,-1,42,830,41,-1,42,814,830,-1,167,796,131,-1,1107,796,167,-1,289,1125,290,-1,1126,1125,289,-1,808,810,811,-1,808,807,810,-1,290,1127,291,-1,1127,290,1125,-1,1128,293,292,-1,1129,293,1128,-1,1130,294,298,-1,292,294,1130,-1,801,953,800,-1,952,953,801,-1,302,887,311,-1,887,302,301,-1,955,1131,956,-1,1131,955,1132,-1,1132,951,1100,-1,1132,955,951,-1,1133,957,151,-1,1133,795,957,-1,306,320,929,-1,306,954,320,-1,1034,1134,1135,-1,1034,317,1134,-1,788,1060,789,-1,788,959,1060,-1,1136,1137,1138,-1,1136,1139,1137,-1,1140,323,786,-1,919,323,1140,-1,583,569,783,-1,583,961,569,-1,352,1141,1142,-1,352,351,1141,-1,352,1143,963,-1,1143,352,1142,-1,346,1030,1144,-1,1143,1030,346,-1,639,773,965,-1,639,774,773,-1,773,1145,965,-1,1145,773,772,-1,356,579,778,-1,580,579,356,-1,769,1029,379,-1,769,770,1029,-1,374,767,375,-1,767,374,684,-1,363,996,365,-1,996,363,995,-1,373,1146,767,-1,373,1147,1146,-1,1148,1149,758,-1,1149,1148,434,-1,759,559,701,-1,1150,559,759,-1,1150,557,559,-1,1150,558,557,-1,753,414,970,-1,414,753,751,-1,704,749,429,-1,749,704,550,-1,603,1004,964,-1,655,1004,603,-1,641,446,1151,-1,446,641,745,-1,1152,657,656,-1,662,657,1152,-1,740,452,451,-1,740,974,452,-1,975,640,1153,-1,469,640,975,-1,735,734,464,-1,735,629,734,-1,613,1154,1155,-1,613,1010,1154,-1,636,738,471,-1,738,636,635,-1,985,978,668,-1,1006,978,985,-1,600,602,390,-1,600,459,602,-1,1156,1117,1157,-1,1158,1117,1156,-1,1115,503,1159,-1,1115,1160,503,-1,649,717,535,-1,717,649,532,-1,507,984,589,-1,984,507,724,-1,728,597,731,-1,727,597,728,-1,719,675,1161,-1,719,673,675,-1,675,500,1161,-1,500,675,671,-1,676,721,1162,-1,676,495,721,-1,1163,666,607,-1,1163,614,666,-1,1164,1163,1165,-1,1164,1166,1163,-1,1167,1168,1169,-1,1167,1170,1168,-1,616,1023,510,-1,1023,616,1003,-1,1171,1020,1172,-1,1021,1020,1171,-1,989,781,1138,-1,989,988,781,-1,423,1148,1173,-1,423,420,1148,-1,423,697,421,-1,423,441,697,-1,437,1015,702,-1,437,754,1015,-1,699,1174,413,-1,699,760,1174,-1,413,442,991,-1,442,413,748,-1,992,345,347,-1,340,345,992,-1,340,339,345,-1,571,653,1175,-1,1001,653,571,-1,1176,693,572,-1,693,1176,784,-1,691,786,333,-1,691,336,786,-1,1177,688,687,-1,1177,638,688,-1,1178,1012,1013,-1,1178,1179,1012,-1,1178,967,1180,-1,1178,1181,967,-1,996,366,365,-1,994,366,996,-1,998,509,999,-1,498,509,998,-1,593,680,1182,-1,680,593,1183,-1,1095,681,87,-1,681,1095,677,-1,680,679,1182,-1,679,680,681,-1,671,674,672,-1,675,674,671,-1,1184,665,1185,-1,665,1184,1162,-1,359,400,395,-1,400,359,398,-1,1186,568,654,-1,568,1186,694,-1,719,1187,479,-1,719,1161,1187,-1,665,1022,1185,-1,1022,665,513,-1,713,668,519,-1,985,668,713,-1,1155,1167,1171,-1,1167,1155,1154,-1,1188,648,1189,-1,1188,646,648,-1,1188,1190,646,-1,742,1191,661,-1,742,1190,1191,-1,460,1006,458,-1,460,978,1006,-1,659,655,762,-1,659,656,655,-1,746,360,964,-1,360,746,643,-1,621,654,622,-1,654,621,1186,-1,1192,653,652,-1,653,1192,543,-1,1156,1169,1168,-1,712,1169,1156,-1,1018,1019,1193,-1,1018,716,1019,-1,528,489,523,-1,528,1025,489,-1,972,1190,742,-1,1190,972,646,-1,624,1194,645,-1,1194,624,1009,-1,644,625,624,-1,971,625,644,-1,455,471,738,-1,455,454,471,-1,445,1151,446,-1,445,1195,1151,-1,737,685,1196,-1,737,734,685,-1,633,1197,1198,-1,633,634,1197,-1,1197,1199,1200,-1,1197,524,1199,-1,632,1198,504,-1,1198,632,633,-1,1201,1195,445,-1,1202,1195,1201,-1,971,453,1027,-1,644,453,971,-1,451,1203,740,-1,451,973,1203,-1,1194,450,645,-1,1189,450,1194,-1,660,1204,743,-1,660,456,1204,-1,710,1205,1206,-1,710,1157,1205,-1,712,1157,710,-1,712,1156,1157,-1,652,1207,1192,-1,1207,652,1208,-1,598,457,618,-1,457,598,448,-1,1191,1188,659,-1,1191,1190,1188,-1,1026,1171,1172,-1,1026,1155,1171,-1,1166,614,1163,-1,1010,614,1166,-1,608,511,476,-1,612,511,608,-1,1161,1024,1187,-1,1024,1161,500,-1,1209,694,1186,-1,694,1209,1210,-1,567,398,1000,-1,565,398,567,-1,552,405,750,-1,552,670,405,-1,1185,725,1184,-1,725,1185,502,-1,493,1095,494,-1,677,1095,493,-1,1182,591,593,-1,596,591,1182,-1,497,596,509,-1,981,596,497,-1,672,731,980,-1,672,674,731,-1,1183,720,1211,-1,720,1183,593,-1,995,1013,994,-1,995,1212,1013,-1,768,1178,1180,-1,768,1179,1178,-1,1177,772,638,-1,772,1177,928,-1,780,341,584,-1,780,339,341,-1,582,1141,351,-1,582,370,1141,-1,572,1175,1176,-1,1175,572,571,-1,1001,570,1210,-1,571,570,1001,-1,698,564,667,-1,698,438,564,-1,557,1028,560,-1,1028,557,969,-1,426,1149,990,-1,425,1149,426,-1,343,543,1192,-1,343,342,543,-1,1016,989,541,-1,989,1016,342,-1,536,986,537,-1,536,987,986,-1,1018,1206,530,-1,1206,1018,1193,-1,1003,715,1023,-1,615,715,1003,-1,1167,1021,1171,-1,1169,1021,1167,-1,664,616,510,-1,664,516,616,-1,489,524,523,-1,524,489,1199,-1,1213,1214,1170,-1,1214,1213,1215,-1,1165,607,1110,-1,1165,1163,607,-1,515,1216,1022,-1,515,1217,1216,-1,730,984,982,-1,673,984,730,-1,998,1162,1184,-1,998,676,1162,-1,594,491,490,-1,594,485,491,-1,671,501,500,-1,671,726,501,-1,597,980,731,-1,597,981,980,-1,678,492,999,-1,492,678,493,-1,1005,535,1017,-1,535,1005,649,-1,634,524,1197,-1,634,534,524,-1,488,1199,489,-1,488,1218,1199,-1,1219,1025,1220,-1,1219,487,1025,-1,1158,1168,1221,-1,1158,1156,1168,-1,478,719,479,-1,478,589,719,-1,732,389,477,-1,600,389,732,-1,601,390,602,-1,599,390,601,-1,714,1006,985,-1,1007,1006,714,-1,735,631,736,-1,631,735,466,-1,463,1155,1026,-1,463,613,1155,-1,456,1153,1204,-1,456,1008,1153,-1,1153,1222,1204,-1,640,1222,1153,-1,458,447,460,-1,447,458,448,-1,1151,1120,641,-1,1151,1122,1120,-1,1027,446,971,-1,444,446,1027,-1,424,558,1150,-1,558,424,556,-1,701,560,699,-1,559,560,701,-1,427,426,428,-1,427,554,426,-1,434,990,1149,-1,990,434,433,-1,419,1148,420,-1,419,434,1148,-1,747,417,562,-1,747,415,417,-1,410,418,411,-1,410,707,418,-1,409,410,412,-1,409,408,410,-1,432,406,753,-1,432,404,406,-1,364,353,355,-1,364,367,353,-1,1141,378,377,-1,378,1141,370,-1,363,367,364,-1,363,365,367,-1,581,356,394,-1,581,580,356,-1,1066,1223,1224,-1,1066,1202,1223,-1,1144,777,776,-1,1144,1030,777,-1,770,779,1029,-1,357,779,770,-1,352,780,353,-1,352,963,780,-1,993,1144,703,-1,346,1144,993,-1,783,693,689,-1,573,693,783,-1,1138,962,1136,-1,962,1138,781,-1,1059,328,330,-1,1032,328,1059,-1,1108,1135,1134,-1,1225,1135,1108,-1,323,1033,324,-1,323,325,1033,-1,319,929,320,-1,929,319,136,-1,1100,316,1132,-1,316,1100,797,-1,1131,316,310,-1,1131,1132,316,-1,956,795,1133,-1,956,1131,795,-1,1036,18,307,-1,18,1036,19,-1,1145,1036,307,-1,1145,772,1036,-1,887,315,311,-1,887,1226,315,-1,805,298,294,-1,298,805,299,-1,291,298,287,-1,291,1130,298,-1,111,1129,107,-1,293,1129,111,-1,953,1098,295,-1,1098,953,105,-1,1099,1037,296,-1,1099,1227,1037,-1,1107,274,275,-1,1107,167,274,-1,1228,133,932,-1,1228,138,133,-1,164,880,267,-1,164,826,880,-1,933,266,265,-1,933,1124,266,-1,934,1124,933,-1,1123,1124,934,-1,260,1229,1106,-1,260,256,1229,-1,1039,153,264,-1,1039,154,153,-1,103,1062,1230,-1,1044,1062,103,-1,1040,241,240,-1,1040,1042,241,-1,1068,1231,1067,-1,1068,844,1231,-1,225,841,839,-1,841,225,224,-1,1119,59,1083,-1,1087,59,1119,-1,230,5,222,-1,230,917,5,-1,181,236,235,-1,908,236,181,-1,76,925,926,-1,925,76,78,-1,1117,913,1074,-1,1117,1158,913,-1,488,1232,1233,-1,488,487,1232,-1,1218,7,1114,-1,1218,1061,7,-1,935,4,184,-1,935,221,4,-1,920,221,935,-1,221,920,916,-1,202,194,199,-1,202,89,194,-1,191,197,196,-1,191,193,197,-1,1113,860,899,-1,1113,84,860,-1,1234,1045,1235,-1,1234,1094,1045,-1,65,1086,903,-1,1084,1086,65,-1,1086,1164,1165,-1,1164,1086,1085,-1,914,1236,912,-1,1237,1236,914,-1,940,907,53,-1,940,906,907,-1,939,1081,1082,-1,939,938,1081,-1,317,1052,1134,-1,958,1052,317,-1,275,163,1107,-1,275,161,163,-1,131,150,132,-1,131,796,150,-1,1053,148,147,-1,146,148,1053,-1,1238,1123,934,-1,1123,1238,147,-1,817,256,828,-1,817,1229,256,-1,138,168,133,-1,138,141,168,-1,132,957,885,-1,151,957,132,-1,1054,1103,129,-1,1054,134,1103,-1,1102,879,1101,-1,930,879,1102,-1,126,1102,127,-1,126,322,1102,-1,791,119,324,-1,123,119,791,-1,16,890,304,-1,890,16,15,-1,1129,1239,107,-1,1129,1240,1239,-1,1129,1128,1240,-1,1227,1239,1126,-1,1227,1098,1239,-1,1227,1099,1098,-1,1241,17,103,-1,307,17,1241,-1,202,891,90,-1,202,201,891,-1,997,1097,85,-1,1242,1097,997,-1,204,200,205,-1,204,199,200,-1,904,1091,66,-1,1091,904,1235,-1,138,72,139,-1,138,1228,72,-1,130,1243,37,-1,130,129,1243,-1,1112,1048,849,-1,1048,1112,1244,-1,863,1055,1089,-1,863,64,1055,-1,1087,60,59,-1,60,1087,1084,-1,1236,1083,1081,-1,1236,1119,1083,-1,1069,1078,1245,-1,1070,1078,1069,-1,1070,1080,1078,-1,1079,1043,49,-1,1080,1043,1079,-1,845,902,232,-1,220,902,845,-1,50,1056,248,-1,50,39,1056,-1,31,1246,68,-1,910,1246,31,-1,31,1077,32,-1,35,1077,31,-1,186,939,187,-1,186,937,939,-1,937,936,1109,-1,186,936,937,-1,1233,867,178,-1,867,1233,1232,-1,1080,1042,1043,-1,1080,1070,1042,-1,1247,25,27,-1,1247,922,25,-1,22,1057,25,-1,22,246,1057,-1,222,231,230,-1,239,231,222,-1,1121,945,245,-1,945,1121,1065,-1,1044,838,1062,-1,225,838,1044,-1,8,10,6,-1,11,10,8,-1,1208,32,1077,-1,32,1208,650,-1,1136,1034,1135,-1,1034,1136,962,-1,331,959,326,-1,959,331,1032,-1,1060,1139,1225,-1,1060,1059,1139,-1,1075,708,1207,-1,1075,173,708,-1,2,619,918,-1,2,33,619,-1,210,1058,6,-1,941,1058,210,-1,231,833,832,-1,231,836,833,-1,1122,1065,1121,-1,1065,1122,1063,-1,1224,307,1241,-1,1145,307,1224,-1,1057,238,26,-1,1057,836,238,-1,1248,24,23,-1,1248,1120,24,-1,25,50,22,-1,25,922,50,-1,241,1245,242,-1,241,1069,1245,-1,1249,908,837,-1,908,1249,236,-1,868,1072,1073,-1,868,1250,1072,-1,870,179,869,-1,873,179,870,-1,34,1076,35,-1,34,878,1076,-1,37,911,1,-1,37,1243,911,-1,38,247,70,-1,38,20,247,-1,41,43,42,-1,43,41,40,-1,49,1041,48,-1,49,1043,1041,-1,40,1078,43,-1,1251,1078,40,-1,1082,227,226,-1,1082,944,227,-1,61,54,1252,-1,61,52,54,-1,857,1088,858,-1,857,905,1088,-1,1103,68,1246,-1,1103,67,68,-1,37,931,130,-1,37,69,931,-1,1055,1113,1089,-1,1055,1090,1113,-1,203,1093,1092,-1,203,1253,1093,-1,854,85,1096,-1,854,86,85,-1,86,1095,87,-1,86,895,1095,-1,85,859,1096,-1,85,1097,859,-1,861,84,83,-1,861,860,84,-1,799,297,17,-1,297,799,800,-1,110,106,952,-1,110,107,106,-1,291,1240,1130,-1,1240,291,1127,-1,1239,1125,1126,-1,1240,1125,1239,-1,1125,1240,1127,-1,888,1226,887,-1,888,1254,1226,-1,876,1033,327,-1,876,792,1033,-1,319,886,134,-1,886,319,125,-1,34,886,1101,-1,34,67,886,-1,309,1054,128,-1,309,135,1054,-1,135,309,114,-1,829,820,884,-1,829,949,820,-1,1104,268,820,-1,268,1104,269,-1,1238,827,144,-1,261,827,1238,-1,140,249,274,-1,249,140,250,-1,1076,173,1075,-1,173,1076,174,-1,176,1134,1052,-1,1108,1134,176,-1,877,792,876,-1,792,877,175,-1,866,28,30,-1,866,920,28,-1,1073,1051,1109,-1,1073,1050,1051,-1,3,180,184,-1,3,872,180,-1,1237,1221,1214,-1,1221,1237,914,-1,1111,1235,904,-1,1111,1234,1235,-1,905,1252,1088,-1,61,1252,905,-1,214,849,98,-1,1112,849,214,-1,1091,82,1090,-1,82,1091,943,-1,856,1253,1244,-1,856,1093,1253,-1,1253,1048,1244,-1,1048,1253,190,-1,892,199,204,-1,892,201,199,-1,189,96,95,-1,189,855,96,-1,1049,28,874,-1,1049,29,28,-1,941,1115,1058,-1,1160,1115,941,-1,1250,1116,1072,-1,1219,1116,1250,-1,1160,209,208,-1,1160,941,209,-1,98,212,99,-1,98,848,212,-1,924,883,81,-1,901,883,924,-1,234,223,235,-1,234,843,223,-1,1215,1085,1118,-1,1164,1085,1215,-1,1231,236,1249,-1,1231,234,236,-1,26,237,834,-1,237,26,238,-1,39,1251,40,-1,39,51,1251,-1,245,24,1121,-1,245,21,24,-1,1056,830,70,-1,1056,41,830,-1,1106,820,260,-1,1106,1104,820,-1,259,254,816,-1,254,259,255,-1,1039,252,254,-1,252,1039,253,-1,266,164,267,-1,266,165,164,-1,946,269,1105,-1,269,946,270,-1,169,818,819,-1,169,278,818,-1,143,949,829,-1,272,949,143,-1,881,276,278,-1,166,276,881,-1,80,813,81,-1,80,281,813,-1,1227,289,1037,-1,1126,289,1227,-1,106,953,952,-1,106,105,953,-1,1037,100,296,-1,1037,101,100,-1,1254,303,156,-1,1254,888,303,-1,1230,1241,103,-1,1230,1064,1241,-1,1248,909,0,-1,909,1248,23,-1,795,310,309,-1,1131,310,795,-1,955,805,951,-1,955,314,805,-1,151,1035,1133,-1,1035,151,150,-1,120,322,126,-1,120,122,322,-1,1139,330,1137,-1,1139,1059,330,-1,332,919,1140,-1,331,919,332,-1,783,771,583,-1,771,783,785,-1,961,341,340,-1,583,341,961,-1,377,1142,1141,-1,1031,1142,377,-1,1143,1031,1030,-1,1143,1142,1031,-1,579,775,778,-1,579,578,775,-1,582,368,370,-1,366,368,582,-1,379,1180,769,-1,379,768,1180,-1,369,1179,768,-1,369,1012,1179,-1,1181,372,967,-1,1181,1255,372,-1,385,380,387,-1,384,380,385,-1,1255,373,372,-1,1255,1147,373,-1,348,545,544,-1,348,706,545,-1,603,762,655,-1,762,603,403,-1,443,562,561,-1,747,562,443,-1,425,1150,759,-1,424,1150,425,-1,752,755,432,-1,752,1028,755,-1,1148,700,1173,-1,1148,758,700,-1,441,1173,442,-1,441,423,1173,-1,964,626,746,-1,626,964,1004,-1,1196,445,444,-1,1196,1201,445,-1,1009,1152,1194,-1,1009,662,1152,-1,472,740,1203,-1,740,472,741,-1,1010,1213,1154,-1,1010,1166,1213,-1,635,739,738,-1,739,635,467,-1,1157,1116,1205,-1,1117,1116,1157,-1,1159,1114,1115,-1,1114,1159,1200,-1,714,627,976,-1,714,628,627,-1,980,499,672,-1,980,497,499,-1,594,1256,1211,-1,490,1256,594,-1,1256,490,207,-1,1187,610,609,-1,1187,1024,610,-1,1023,476,511,-1,1023,715,476,-1,513,614,514,-1,614,513,666,-1,1110,606,1111,-1,1110,607,606,-1,1193,1021,711,-1,1193,1019,1021,-1,713,527,628,-1,521,527,713,-1,718,1172,1020,-1,718,517,1172,-1,529,523,987,-1,528,523,529,-1,531,535,717,-1,531,536,535,-1,733,976,627,-1,976,733,470,-1,1137,709,541,-1,709,1137,330,-1,541,574,1016,-1,540,574,541,-1,991,1173,700,-1,991,442,1173,-1,548,387,388,-1,387,548,385,-1,556,702,1015,-1,556,555,702,-1,754,557,1015,-1,754,969,557,-1,752,1174,760,-1,1174,752,970,-1,562,667,563,-1,667,562,698,-1,570,340,992,-1,570,961,340,-1,565,566,553,-1,566,565,567,-1,1175,543,542,-1,1175,653,543,-1,1014,1016,574,-1,542,1016,1014,-1,784,1014,337,-1,784,1176,1014,-1,338,786,336,-1,338,1140,786,-1,1177,966,576,-1,1177,687,966,-1,375,1212,362,-1,1212,375,1257,-1,374,1011,685,-1,374,376,1011,-1,1182,509,596,-1,1182,679,509,-1,1211,1242,1183,-1,1211,1256,1242,-1,722,979,1094,-1,496,979,722,-1,1162,605,665,-1,1162,721,605,-1,390,549,391,-1,599,549,390,-1,502,1022,1216,-1,502,1185,1022,-1,669,477,476,-1,669,732,477,-1,463,1217,515,-1,463,462,1217,-1,1154,1170,1167,-1,1170,1154,1213,-1,1189,1152,1188,-1,1189,1194,1152,-1,661,659,658,-1,661,1191,659,-1,1000,359,361,-1,1000,398,359,-1,1186,620,1209,-1,1186,621,620,-1,1169,711,1021,-1,712,711,1169,-1,531,716,1018,-1,531,717,716,-1,1220,528,530,-1,528,1220,1025,-1,743,1222,744,-1,743,1204,1222,-1,1222,973,744,-1,973,1222,1203,-1,1202,1063,1195,-1,1202,1066,1063,-1,977,1196,444,-1,1196,977,737,-1,1198,1200,1159,-1,1198,1197,1200,-1,533,635,636,-1,533,534,635,-1,1159,504,1198,-1,1159,503,504,-1,1027,455,977,-1,455,1027,453,-1,1195,1122,1151,-1,1195,1063,1122,-1,965,1224,1223,-1,965,1145,1224,-1,974,644,452,-1,453,644,974,-1,641,1248,642,-1,1120,1248,641,-1,663,624,626,-1,663,1009,624,-1,1189,647,450,-1,648,647,1189,-1,1007,1153,1008,-1,1007,975,1153,-1,1205,530,1206,-1,530,1205,1220,-1,987,531,529,-1,987,536,531,-1,1020,716,718,-1,1019,716,1020,-1,1208,651,650,-1,1208,652,651,-1,1209,651,1002,-1,1209,620,651,-1,1004,663,626,-1,657,663,1004,-1,743,661,660,-1,742,661,743,-1,1188,656,659,-1,1188,1152,656,-1,461,1172,517,-1,1172,461,1026,-1,462,611,1217,-1,512,611,462,-1,1216,1024,502,-1,610,1024,1216,-1,1002,1210,1209,-1,1210,1002,1001,-1,567,654,568,-1,654,567,1000,-1,604,403,603,-1,968,403,604,-1,721,606,605,-1,721,983,606,-1,982,731,730,-1,731,982,728,-1,1183,997,680,-1,1183,1242,997,-1,591,729,592,-1,729,591,727,-1,586,1223,1011,-1,586,965,1223,-1,1013,1146,1147,-1,1212,1146,1013,-1,1257,1146,1212,-1,1255,1013,1147,-1,1255,1178,1013,-1,1255,1181,1178,-1,576,928,1177,-1,576,115,928,-1,1140,539,332,-1,338,539,1140,-1,542,1176,1175,-1,542,1014,1176,-1,1210,992,694,-1,570,992,1210,-1,993,553,566,-1,993,703,553,-1,696,400,399,-1,400,696,695,-1,549,547,383,-1,549,551,547,-1,546,411,706,-1,412,411,546,-1,708,1192,1207,-1,708,343,1192,-1,1138,541,989,-1,1138,1137,541,-1,338,540,539,-1,338,574,540,-1,649,527,526,-1,527,649,1005,-1,711,1206,1193,-1,710,1206,711,-1,986,533,537,-1,522,533,986,-1,1221,1170,1214,-1,1221,1168,1170,-1,983,1111,606,-1,1234,1111,983,-1,1217,610,1216,-1,1217,611,610,-1,479,609,480,-1,479,1187,609,-1,722,1234,983,-1,1234,722,1094,-1,498,1184,725,-1,1184,498,998,-1,1211,595,594,-1,595,1211,720,-1,723,729,728,-1,682,729,723,-1,733,1005,1017,-1,733,627,1005,-1,637,1017,537,-1,1017,637,733,-1,1200,1218,1114,-1,1218,1200,1199,-1,1116,1220,1205,-1,1116,1219,1220,-1,491,1160,208,-1,503,1160,491,-1,590,480,481,-1,480,590,478,-1,476,474,608,-1,475,474,476,-1,588,736,631,-1,736,588,587,-1,552,601,670,-1,552,599,601,-1,975,714,976,-1,975,1007,714,-1,1166,1215,1213,-1,1166,1164,1215,-1,737,739,464,-1,739,737,977,-1,640,1203,1222,-1,1203,640,472,-1,647,744,973,-1,744,647,972,-1,1196,1011,1201,-1,1196,685,1011,-1,964,396,603,-1,396,964,397,-1,413,970,414,-1,970,413,1174,-1,436,405,404,-1,436,750,405,-1,435,749,436,-1,435,756,749,-1,1149,759,758,-1,759,1149,425,-1,760,1028,752,-1,760,560,1028,-1,408,707,410,-1,707,408,761,-1,748,443,442,-1,748,747,443,-1,428,990,761,-1,428,426,990,-1,401,564,670,-1,564,401,968,-1,767,1257,375,-1,1257,767,1146,-1,1212,363,362,-1,1212,995,363,-1,1012,368,994,-1,1012,369,368,-1,769,967,765,-1,1180,967,769,-1,765,358,769,-1,765,382,358,-1,350,581,394,-1,577,581,350,-1,1223,1201,1011,-1,1202,1201,1223,-1,623,1248,0,-1,623,642,1248,-1,963,346,345,-1,963,1143,346,-1,1029,1031,377,-1,779,1031,1029,-1,776,703,1144,-1,776,349,703,-1,784,689,693,-1,690,689,784,-1,789,1225,1108,-1,1060,1225,789,-1,793,136,135,-1,793,929,136,-1,314,299,805,-1,314,313,299,-1,312,1133,1035,-1,1133,312,956,-1,1241,1066,1224,-1,1064,1066,1241,-1,315,1254,156,-1,1226,1254,315,-1,111,802,803,-1,111,110,802,-1,804,1100,951,-1,804,803,1100,-1,798,800,799,-1,801,800,798,-1,817,948,1229,-1,816,948,817,-1,819,162,161,-1,162,819,818,-1,170,819,275,-1,169,819,170,-1,1124,165,266,-1,1124,149,165,-1,262,1105,948,-1,1105,262,946,-1,1038,880,251,-1,267,880,1038,-1,1106,948,1105,-1,1106,1229,948,-1,248,70,247,-1,248,1056,70,-1,945,1062,831,-1,1062,945,1230,-1,1251,922,1247,-1,51,922,1251,-1,1067,1249,1071,-1,1067,1231,1249,-1,1249,45,1071,-1,837,45,1249,-1,1083,840,944,-1,59,840,1083,-1,14,841,218,-1,14,13,841,-1,845,181,183,-1,845,908,181,-1,926,924,76,-1,926,901,924,-1,284,74,285,-1,284,925,74,-1,1048,848,849,-1,95,848,1048,-1,914,1158,1221,-1,1158,914,913,-1,1232,1219,1250,-1,487,1219,1232,-1,1061,488,1233,-1,1218,488,1061,-1,916,181,235,-1,181,916,915,-1,942,1046,1092,-1,862,1046,942,-1,898,1093,856,-1,1093,898,1047,-1,1256,198,197,-1,1256,207,198,-1,1235,943,1091,-1,1235,1045,943,-1,189,205,200,-1,189,190,205,-1,1088,58,863,-1,1252,58,1088,-1,903,1165,1110,-1,1086,1165,903,-1,1214,1118,1237,-1,1214,1215,1118,-1,206,1233,178,-1,206,1061,1233,-1,907,228,53,-1,228,907,864,-1,938,1236,1081,-1,938,912,1236,-1,923,906,940,-1,923,185,906,-1,1073,936,868,-1,1073,1109,936,-1,180,873,184,-1,873,180,179,-1,251,884,1038,-1,884,251,829,-1,811,216,91,-1,811,810,216,-1,144,147,1238,-1,1053,147,144,-1,934,261,1238,-1,947,261,934,-1,946,934,270,-1,946,947,934,-1,885,932,132,-1,885,931,932,-1,878,1101,879,-1,34,1101,878,-1,177,930,175,-1,177,879,930,-1,930,322,321,-1,1102,322,930,-1,324,792,791,-1,792,324,1033,-1,772,890,15,-1,772,928,890,-1,1240,292,1130,-1,1128,292,1240,-1,1239,105,107,-1,1239,1098,105,-1,861,1096,894,-1,1096,861,854,-1,1242,197,1097,-1,1256,197,1242,-1,853,86,854,-1,853,895,86,-1,203,190,1253,-1,205,190,203,-1,899,1089,1113,-1,899,858,1089,-1,259,883,255,-1,883,259,81,-1,1228,931,69,-1,1228,932,931,-1,129,1246,1243,-1,129,1103,1246,-1,857,1244,1112,-1,857,856,1244,-1,285,73,847,-1,73,285,74,-1,1252,840,58,-1,54,840,1252,-1,1237,1119,1236,-1,1237,1118,1119,-1,1251,1245,1078,-1,1245,1251,1247,-1,43,49,44,-1,1079,49,43,-1,72,69,36,-1,1228,69,72,-1,910,1243,1246,-1,911,1243,910,-1,1051,912,938,-1,1051,921,912,-1,186,870,936,-1,1049,870,186,-1,867,1250,868,-1,867,1232,1250,-1,1067,1041,1040,-1,1071,1041,1067,-1,242,1247,27,-1,242,1245,1247,-1,1068,834,237,-1,240,834,1068,-1,844,234,1231,-1,843,234,844,-1,836,246,833,-1,836,1057,246,-1,1065,1230,945,-1,1065,1064,1230,-1,6,12,210,-1,6,10,12,-1,917,3,5,-1,917,871,3,-1,318,708,173,-1,318,782,708,-1,1075,1208,1077,-1,1075,1207,1208,-1,1225,1136,1135,-1,1225,1139,1136,-1,325,331,326,-1,325,919,331,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t4_Coord',point=[(0,50.05005,-3.27525),(.12073,50.00417,-3.29784),(.00699,49.98511,-3.39075),(.31236,50.17682,-2.65616),(.32745,50.18502,-2.65984),(.35254,50.18181,-2.68401),(.14773,49.87064,-2.72003),(.07256,49.9942,-2.63972),(.14513,50.01016,-2.67652),(.25542,50.04206,-2.76279),(.2416,49.89926,-2.77727),(.23136,50.03442,-2.72377),(.24932,49.83607,-2.80588),(.30157,49.87358,-2.8189),(.39436,49.81101,-2.82626),(.10117,49.67617,-3.23711),(.16539,49.67284,-3.23586),(.19381,49.7743,-3.14042),(.10942,49.74596,-3.19148),(.06499,49.69848,-3.22503),(.23747,50.15315,-3.06408),(.19808,50.15718,-3.03702),(.25214,50.23885,-2.97125),(.13293,50.11177,-3.13291),(.12464,50.11444,-3.0754),(.27314,50.32683,-2.91036),(.27911,50.4033,-2.84806),(.27968,50.40696,-2.85709),(.4521,50.08616,-2.53774),(.43713,50.02098,-2.44602),(.47848,50.06689,-2.53532),(.02407,49.81631,-3.56274),(.00546,49.87861,-3.58399),(.00643,49.92213,-3.49214),(.06009,49.58978,-3.64802),(.01962,49.73176,-3.65899),(.21008,50.01804,-3.2108),(.1886,49.92086,-3.29013),(.26126,50.1275,-3.08245),(.43459,50.24666,-2.89282),(.51901,50.25198,-2.85919),(.50678,50.18803,-2.93828),(.62448,50.18862,-2.87481),(.58358,50.28292,-2.80133),(.68294,50.24281,-2.75455),(.60632,50.2499,-2.71643),(.58547,50.1867,-2.76307),(.67812,50.22434,-2.74373),(.68644,50.33642,-2.67994),(.68111,50.34832,-2.69183),(.36542,50.2568,-2.91389),(.41485,50.29037,-2.86966),(.48663,49.80566,-2.49667),(.47936,49.84105,-2.48488),(.43329,49.79693,-2.36325),(.50352,50.02433,-2.64786),(.5076,50.07447,-2.62395),(.50574,50.01451,-2.55037),(.35899,49.69603,-2.28166),(.29023,49.77658,-2.08748),(.25833,49.67324,-2.1161),(.48459,49.7427,-2.51553),(.47573,49.78034,-2.6255),(.4646,49.83662,-2.60183),(.25912,49.55283,-2.12761),(.13577,49.52025,-2.00942),(.14849,49.424,-2.01244),(.09151,49.62632,-3.56724),(.07895,49.67547,-3.56112),(.26099,49.94696,-3.20939),(.38882,50.15767,-2.98257),(.43365,50.11417,-3.0766),(.32206,50.06199,-3.12877),(.49974,50.00684,-2.65191),(.52127,50.00217,-2.70137),(.48902,50.07668,-2.70243),(.61117,50.04888,-2.81642),(.56967,50.11217,-2.83257),(.55846,50.0341,-2.78949),(.79154,50.14412,-3.00204),(.68011,50.14508,-2.99579),(.80001,50.09783,-2.89709),(.2971,49.32581,-2.14985),(.29478,49.39716,-2.29185),(.44211,49.34719,-2.30947),(.16243,49.51425,-2.55),(.15495,49.48019,-2.45344),(0,49.49519,-2.4409),(.41661,49.52334,-2.83064),(.44786,49.49237,-2.76256),(.41954,49.5056,-2.75692),(.51267,49.86102,-2.88106),(.4506,49.85975,-2.90721),(.46085,49.8528,-2.96963),(.43764,49.6289,-2.81746),(.56299,49.57835,-2.79982),(.48218,49.53009,-2.8227),(.48289,49.82345,-2.77717),(.46311,49.76499,-2.74661),(.3931,49.72771,-2.81072),(.28229,49.8612,-3.03737),(.36268,49.86112,-3.0035),(.32612,49.88968,-2.98848),(.24322,49.87656,-3.05694),(.27616,49.85878,-3.04348),(.34831,49.69228,-3.12777),(.36356,49.66621,-3.14113),(.39693,49.6317,-3.15027),(.4547,49.84229,-2.98001),(.51775,49.79601,-2.99158),(.37057,49.52941,-3.21241),(.43557,49.54539,-3.19067),(.22345,49.55127,-3.31759),(.22961,49.58929,-3.25968),(.29148,49.54243,-3.33898),(0,49.52147,-3.38474),(0,49.37082,-3.52012),(.03903,49.41337,-3.53003),(0,49.31198,-3.65332),(.03673,49.34305,-3.65032),(.13517,49.3667,-3.57042),(.10229,49.39278,-3.55237),(.09368,49.34138,-3.69445),(.06655,49.35265,-3.67404),(.0727,49.30465,-3.7634),(.15956,49.46165,-3.51848),(.13865,49.37074,-3.57366),(.13084,49.44842,-3.58733),(.30415,49.69514,-3.30965),(.18864,49.72877,-3.39221),(.24924,49.78549,-3.31183),(.55031,49.83828,-3.12856),(.48756,49.78123,-3.17769),(.48342,49.93524,-3.12786),(.17671,49.60668,-3.45436),(.28705,49.54449,-3.34272),(.21089,49.50688,-3.42232),(.60451,50.18381,-3.10209),(.45705,50.02509,-3.11494),(.44579,50.10106,-3.09991),(.76533,50.11492,-3.23324),(.60457,50.12221,-3.131),(.74125,50.19576,-3.20213),(.87816,50.23234,-3.26569),(.99574,49.98323,-3.11036),(1.00939,49.88494,-3.0613),(1.03658,49.88486,-3.18042),(1.04023,50.00302,-3.18364),(1.06583,49.92124,-3.25172),(1.10678,49.99637,-3.25535),(.56598,49.72283,-3.15207),(.50762,49.70095,-3.1951),(.82827,49.89737,-2.93888),(.92,49.85188,-3.02612),(.91018,49.91355,-2.968),(.58119,49.75516,-3.03688),(.6323,49.69365,-3.09834),(.65214,49.74807,-3.11187),(.69494,49.85502,-2.99187),(.74992,49.80861,-3.07099),(.82222,49.84185,-3.01738),(.86748,49.86771,-3.18802),(.92472,49.8158,-3.12508),(.79573,49.82742,-3.13571),(1.0868,50.00313,-3.31142),(1.10774,49.99658,-3.26137),(1.06326,49.91869,-3.25659),(.67745,49.9624,-3.17242),(.63993,50.0254,-3.14971),(.95795,49.90173,-3.25852),(.91995,49.98377,-3.30365),(.98293,49.97429,-3.34552),(.02648,49.59015,-3.8995),(.00595,49.63239,-3.87469),(.01251,49.60145,-3.86767),(.05852,49.32889,-3.86187),(.05175,49.3511,-3.96397),(.03795,49.44069,-3.85176),(.15565,50.13532,-2.62998),(.25078,50.1338,-2.60508),(.26829,50.17093,-2.64223),(.47767,50.14974,-2.66162),(.50223,50.08067,-2.63714),(.49569,50.11279,-2.6805),(.32005,50.18749,-2.64766),(.49662,49.94081,-2.59521),(.35581,49.98761,-2.37147),(.45202,49.98337,-2.33934),(.46096,49.97764,-2.44589),(.56323,49.56696,-2.7945),(.58832,49.57456,-2.73786),(.3119,49.54457,-2.85659),(.41311,49.53267,-2.83614),(.31273,49.53682,-2.84978),(.46255,49.49225,-2.76274),(.46962,49.51651,-2.82029),(.14212,49.54703,-2.82894),(.14477,49.53947,-2.82352),(.07106,49.54352,-2.79894),(.49195,49.48573,-2.72964),(.51908,49.50926,-2.7558),(.48117,49.48442,-2.71679),(.46902,49.48815,-2.73492),(.57111,49.5328,-2.64042),(.51745,49.492,-2.64241),(.56086,49.53399,-2.7113),(.15445,50.13241,-2.63778),(0,49.54002,-2.76804),(0,49.63354,-2.74737),(.07427,49.64529,-2.77066),(.14656,49.75095,-2.7777),(.14434,49.64899,-2.80402),(.47426,49.64893,-2.80004),(.4938,49.81821,-2.69455),(.48881,49.75075,-2.63432),(.5449,49.87231,-2.79855),(.59434,49.87144,-2.87557),(.55197,49.8873,-2.79151),(.43791,49.8453,-2.84803),(.49392,49.85252,-2.82612),(.48819,50.12028,-2.74126),(.37845,50.16823,-2.64538),(.37111,50.19214,-2.71746),(.39021,50.17951,-2.67591),(.33891,49.90515,-2.91651),(.31075,49.92507,-2.91186),(.45906,49.97581,-2.33965),(.44617,49.88637,-2.35199),(.46024,49.88374,-2.39815),(.27948,50.0497,-2.80163),(.3196,50.14249,-2.75296),(.30861,50.19265,-2.81488),(.54091,50.17225,-2.74048),(.58151,50.168,-2.78059),(.42978,50.20206,-2.69816),(.43924,50.16923,-2.66228),(.46107,50.19543,-2.6968),(.35529,50.32893,-2.78469),(.33722,50.3052,-2.81005),(.35611,50.23838,-2.77295),(.40163,50.47923,-2.72096),(.4048,50.48096,-2.72399),(.34311,50.4554,-2.78105),(.65574,50.16348,-2.79997),(.59101,50.13513,-2.8243),(.19713,50.15401,-3.02606),(.23723,50.23031,-2.95488),(.29918,50.20103,-2.9863),(.30345,50.20568,-2.98412),(.92139,50.10839,-3.32646),(.88528,50.18184,-3.2984),(.99642,50.15307,-3.32997),(.95093,50.00975,-3.01732),(.98352,49.92962,-3.01232),(.94383,50.00853,-3.01487),(.89207,50.00311,-2.9623),(.88904,50.25032,-3.05035),(.85719,50.26478,-3.07495),(.79744,50.21631,-3.07011),(.86785,50.11517,-2.94961),(.93278,50.29642,-3.10324),(.99587,50.08126,-3.07421),(.99324,50.1708,-3.02193),(.95024,50.11193,-3.03146),(1.00367,49.88158,-3.06062),(1.13108,50.13812,-3.19917),(1.1212,50.06815,-3.23918),(1.09866,50.08624,-3.301),(1.12316,50.19999,-3.15508),(1.12132,50.20395,-3.1488),(1.12246,50.19728,-3.14958),(.89167,50.30188,-3.15661),(.87398,50.2794,-3.22757),(.73563,50.25069,-3.15889),(.79362,50.03494,-3.26891),(.83876,49.94836,-3.23815),(1.03372,49.88159,-3.18249),(.99788,49.83218,-3.14601),(.99315,49.8765,-3.22171),(.76289,50.24173,-3.10844),(.57025,50.16509,-3.0337),(.63862,50.16208,-2.91765),(.45819,50.12248,-3.06872),(.64904,49.75107,-3.11811),(.5516,49.9575,-2.78402),(.5139,49.92375,-2.71152),(.50892,49.88148,-2.71955),(.56259,49.7444,-3.01104),(.53499,49.80535,-2.99472),(.45212,49.836,-2.98152),(.5134,49.79054,-2.99028),(.55775,49.74108,-3.01127),(.5476,49.60031,-3.11308),(.49201,49.57067,-3.16163),(.55176,49.59987,-3.11589),(.21016,49.75089,-3.1253),(.2794,49.85339,-3.04075),(.20652,49.75474,-3.1302),(.59928,49.64773,-3.06035),(.59978,49.65575,-3.07965),(.60169,49.66585,-3.07293),(.62005,49.66951,-3.10663),(.61282,49.66855,-3.11189),(.62368,49.6811,-3.11693),(.14672,49.57617,-3.3257),(.12204,49.51291,-3.39548),(.16783,49.50058,-3.40455),(.10991,49.7528,-3.18264),(.3478,49.56482,-3.27956),(.35013,49.56756,-3.28096),(.35235,49.56223,-3.27698),(.60692,49.65777,-3.09871),(.58034,49.64014,-3.15676),(.60533,49.65568,-3.09074),(.57139,49.61743,-3.14044),(.61988,49.67645,-3.08056),(.36252,49.54155,-3.25352),(.0253,49.53463,-3.9441),(.003,49.61065,-3.90746),(.16147,49.46713,-3.51205),(.15786,49.46171,-3.51196),(.07376,49.30708,-3.76897),(.09673,49.34539,-3.69633),(0,49.27407,-3.74173),(.03544,49.28799,-3.75471),(.00343,49.23665,-3.83275),(.00379,49.19294,-3.92476),(.0292,49.18908,-3.93216),(-.02794,49.18347,-4.00002),(-.05642,49.19156,-3.98171),(-.02957,49.25526,-4.00277),(-.00379,49.19294,-3.92479),(-.0292,49.18908,-3.93239),(-.03673,49.34305,-3.65089),(-.0764,49.41527,-3.54302),(-.10229,49.39278,-3.55426),(-.07088,49.30191,-3.76848),(-.07376,49.30708,-3.76987),(-.05189,49.25079,-3.86557),(-.29141,49.54233,-3.34572),(-.28705,49.54449,-3.34942),(-.28541,49.54188,-3.34688),(-.03423,49.51824,-3.8535),(-.01251,49.60145,-3.86779),(-.02648,49.59015,-3.89972),(-.35013,49.56756,-3.28954),(-.43873,49.58474,-3.25894),(-.30415,49.69514,-3.31684),(-.60444,49.79603,-3.13752),(-.56598,49.72283,-3.16632),(-.62368,49.6811,-3.13283),(-.36379,49.54152,-3.24538),(-.36252,49.54155,-3.26264),(-.23512,49.59268,-3.25441),(-.22961,49.58929,-3.26559),(-.20146,49.68009,-3.20915),(-.61988,49.67645,-3.09692),(-.60533,49.65568,-3.10674),(-.60169,49.66585,-3.08908),(-.32206,50.06199,-3.13692),(-.26126,50.1275,-3.08925),(-.21008,50.01804,-3.21592),(-.21016,49.75089,-3.1313),(-.21792,49.67056,-3.17644),(-.21312,49.67094,-3.18051),(-.24563,49.59345,-3.21523),(-.37057,49.52941,-3.2221),(-.24185,49.5923,-3.22033),(-.43557,49.54539,-3.20205),(-.49201,49.57067,-3.17454),(-.43713,49.54422,-3.20632),(-.51775,49.79601,-3.00659),(-.5134,49.79054,-3.00522),(-.45212,49.836,-2.99492),(-.28229,49.8612,-3.04571),(-.2794,49.85339,-3.04901),(-.27616,49.85878,-3.05162),(-.50154,49.58462,-3.18252),(-.49698,49.57212,-3.17625),(-.55176,49.59987,-3.13059),(-.58155,49.82227,-3.01568),(-.61448,49.78746,-3.06002),(-.58119,49.75516,-3.05287),(-.69494,49.85502,-3.01023),(-.60667,49.82914,-3.01489),(-.60027,49.86541,-2.96563),(-.46085,49.8528,-2.98332),(-.54862,49.85708,-2.97105),(-.51267,49.86102,-2.89694),(-.5516,49.9575,-2.80149),(-.63956,49.97771,-2.84098),(-.63081,49.89059,-2.87739),(-.74992,49.80861,-3.08915),(-.65214,49.74807,-3.12815),(-.6323,49.69365,-3.11463),(-.44579,50.10106,-3.11088),(-.45819,50.12248,-3.08015),(-.43365,50.11417,-3.08748),(-.3505,49.97971,-3.16128),(-.48342,49.93524,-3.14006),(-.45705,50.02509,-3.12635),(-.67794,50.14106,-2.88003),(-.60282,50.1495,-2.86771),(-.62486,50.18266,-2.89353),(-.92951,50.12586,-3.03071),(-.86785,50.11517,-2.96907),(-.90033,50.15307,-3.03255),(-.99788,49.83218,-3.16449),(-.96688,49.85491,-3.20049),(-.92472,49.8158,-3.14384),(-.91071,49.88432,-3.23895),(-.83876,49.94836,-3.25343),(-.86748,49.86771,-3.20493),(-1.03536,50.28948,-3.20961),(-.93278,50.29642,-3.11837),(-.89167,50.30188,-3.17056),(-.85719,50.26478,-3.09066),(-.79555,50.27331,-3.13037),(-.91995,49.98377,-3.31766),(-.9671,50.01207,-3.36373),(-.94351,50.06147,-3.36193),(-.79362,50.03494,-3.28273),(-.91014,50.05573,-3.35303),(-.92139,50.10839,-3.33899),(-1.10678,49.99637,-3.26991),(-1.10774,49.99658,-3.27578),(-1.06326,49.91869,-3.27195),(-1.03658,49.88486,-3.19782),(-1.03372,49.88159,-3.19987),(-1.00367,49.88158,-3.0806),(-.95024,50.11193,-3.04998),(-.94532,50.11524,-3.04541),(-.98842,50.17585,-3.03737),(-.98293,49.97429,-3.35866),(-1.01374,50.01636,-3.36209),(-.95093,50.00975,-3.03703),(-.94383,50.00853,-3.0346),(-.98423,50.02783,-3.09385),(-.79744,50.21631,-3.08596),(-.84274,50.1893,-3.05969),(-.79154,50.14412,-3.01962),(-.88528,50.18184,-3.31081),(-.97647,50.22588,-3.30323),(-.87816,50.23234,-3.27825),(-.26089,50.10637,-2.94761),(-.19115,50.07044,-3.02212),(-.19713,50.15401,-3.03144),(-.56967,50.11217,-2.84903),(-.58151,50.168,-2.7975),(-.59101,50.13513,-2.84117),(-.34311,50.4554,-2.79033),(-.33437,50.45226,-2.79108),(-.27911,50.4033,-2.85561),(-.29136,50.24497,-2.88215),(-.35611,50.23838,-2.7838),(-.30861,50.19265,-2.82434),(-.60632,50.2499,-2.73392),(-.58547,50.1867,-2.78011),(-.54091,50.17225,-2.75683),(-.55846,50.0341,-2.80665),(-.52893,50.11623,-2.80299),(-.44617,49.88637,-2.36994),(-.43329,49.79693,-2.38097),(-.3692,49.78945,-2.27344),(-.30218,49.92488,-2.85206),(-.27189,49.91207,-2.81904),(-.30157,49.87358,-2.82918),(-.25542,50.04206,-2.77145),(-.40211,50.2018,-2.71688),(-.42978,50.20206,-2.71181),(-.39021,50.17951,-2.68871),(-.37111,50.19214,-2.72935),(-.40348,50.27288,-2.74739),(-.5449,49.87231,-2.81609),(-.51298,49.84833,-2.76562),(-.50892,49.88148,-2.73686),(-.4762,49.89,-2.65542),(-.5139,49.92375,-2.72887),(-.50927,49.66757,-2.78532),(-.51782,49.68229,-2.74517),(-.46311,49.76499,-2.76274),(-.3931,49.72771,-2.82428),(-.36102,49.63129,-2.83177),(-.43764,49.6289,-2.83249),(-.26861,49.73193,-2.8511),(-.14434,49.64899,-2.8093),(-.29026,49.63825,-2.8599),(0,50.08058,-2.5227),(0,50.1153,-2.57304),(-.07782,50.12211,-2.59017),(-.07106,49.54352,-2.80158),(-.07427,49.64529,-2.77344),(-.15481,49.36354,-2.15324),(-.15542,49.4125,-2.21961),(0,49.37885,-2.14591),(-.14952,49.32372,-2.04438),(-.07444,49.32471,-2.09718),(-.48916,49.41702,-2.5113),(-.49576,49.39407,-2.45188),(-.51695,49.44086,-2.51276),(-.58649,49.55498,-2.5628),(-.53169,49.47957,-2.48731),(-.49374,49.51884,-2.43001),(-.06953,49.73786,-2.74542),(-.14656,49.75095,-2.78307),(-.41311,49.53267,-2.85034),(-.46962,49.51651,-2.83633),(-.48218,49.53009,-2.83907),(-.41661,49.52334,-2.845),(-.40053,49.43778,-2.46014),(-.47936,49.84105,-2.50333),(-.4646,49.83662,-2.61898),(-.48663,49.80566,-2.5154),(-.25912,49.55283,-2.1326),(-.25833,49.67324,-2.1238),(-.35899,49.69603,-2.29707),(-.4678,49.89541,-2.42412),(-.45906,49.97581,-2.35775),(-.46096,49.97764,-2.46344),(-.50184,50.0305,-2.67659),(-.50352,50.02433,-2.66499),(-.5076,50.07447,-2.64112),(-.26892,50.16337,-2.66048),(-.15565,50.13532,-2.63554),(-.15445,50.13241,-2.64328),(-.50574,50.01451,-2.56842),(-.47848,50.06689,-2.55238),(-.49051,50.12614,-2.61162),(-.15081,50.05822,-2.53542),(-.21537,50.05827,-2.5242),(-.15796,50.00794,-2.38804),(-.30832,50.05835,-2.50674),(-.43713,50.02098,-2.46258),(-.31236,50.17682,-2.66672),(-.25132,50.13689,-2.68974),(-.37414,50.11327,-2.57257),(-.3153,50.12806,-2.59498),(-.32005,50.18749,-2.65846),(-.06765,49.2448,-3.95937),(-.04768,49.20007,-3.94352),(-.05592,49.29344,-3.89955),(-.05175,49.3511,-3.96434),(-.05117,49.47148,-3.76824),(-.03608,49.54467,-3.75602),(-.55031,49.83828,-3.14246),(-.67745,49.9624,-3.1872),(-.79573,49.82742,-3.15322),(-.82222,49.84185,-3.03718),(-.59434,49.87144,-2.89344),(-.71679,49.90188,-2.92381),(-.91018,49.91355,-2.9891),(-.82827,49.89737,-2.95978),(-.82011,49.99536,-2.92767),(-.48756,49.78123,-3.18992),(-1.06583,49.92124,-3.26716),(-1.01983,49.9685,-3.17915),(-1.04023,50.00302,-3.20007),(-1.04624,50.10268,-3.14909),(-1.05906,50.0454,-3.19277),(-1.13024,50.13587,-3.20865),(-1.12246,50.19728,-3.16447),(-.74125,50.19576,-3.21547),(-.73563,50.25069,-3.1724),(-.60451,50.18381,-3.1154),(-.68011,50.14508,-3.01201),(-.3957,49.88122,-3.18622),(-.37867,49.74784,-3.26086),(-.32779,49.82915,-3.24375),(-.24924,49.78549,-3.31767),(-.16147,49.46713,-3.51519),(-.17671,49.60668,-3.45802),(-.10977,49.55493,-3.57194),(-.13084,49.44842,-3.58961),(-.15956,49.46165,-3.52155),(-.05852,49.32889,-3.86245),(-.03903,49.41337,-3.53078),(-.06004,49.52773,-3.39225),(-.62813,49.67824,-3.12256),(-.62005,49.66951,-3.12265),(-.61692,49.66255,-3.1148),(-.62398,49.67272,-3.10515),(-.63128,49.68283,-3.11573),(-.37036,49.52767,-3.22729),(-.20897,49.50351,-3.42386),(-.22345,49.55127,-3.32303),(-.20652,49.75474,-3.13607),(-.19381,49.7743,-3.14587),(-.49392,49.85252,-2.84211),(-.48289,49.82345,-2.79343),(-.56299,49.57835,-2.8186),(-.47426,49.64893,-2.81627),(-.45,49.49946,-2.65614),(-.41954,49.5056,-2.77198),(-.28709,49.53067,-2.65185),(-.14212,49.54703,-2.8341),(-.3119,49.54457,-2.86746),(-.4269,49.47964,-2.56131),(-.50305,49.48949,-2.6608),(-.65574,50.16348,-2.81822),(-.73057,49.98231,-2.88472),(-.55455,49.99496,-2.7948),(-.70818,50.06247,-2.87587),(-.61117,50.04888,-2.83439),(-.5081,50.18018,-2.9545),(-.57025,50.16509,-3.04745),(-.14849,49.424,-2.01004),(-.07424,49.40692,-1.98329),(-.06778,49.50951,-1.96355),(-.4938,49.81821,-2.71188),(-.48881,49.75075,-2.65223),(-.50116,49.68235,-2.54785),(-.48459,49.7427,-2.53423),(-.47573,49.78034,-2.643),(-.29023,49.77658,-2.09951),(-.13307,49.64171,-1.97686),(-.49662,49.94081,-2.61299),(-.48451,49.85782,-2.50123),(-.65179,50.19568,-2.83625),(-.67811,50.22434,-2.76258),(-.00638,49.92213,-3.49226),(-.05982,49.87222,-3.46974),(-.07752,49.93408,-3.39327),(-.12073,50.00417,-3.30057),(-.14121,50.08792,-3.1999),(-.27314,50.32683,-2.91774),(-.25214,50.23885,-2.97809),(-.30345,50.20568,-2.99231),(-.45291,50.14863,-2.63354),(-.48576,50.13203,-2.62454),(-.33891,49.90515,-2.92719),(-.4506,49.85975,-2.92123),(-.39436,49.81101,-2.83954),(-.24932,49.83607,-2.8146),(-.2416,49.89926,-2.78576),(-.23136,50.03442,-2.73183),(-.29224,50.13253,-2.72321),(-.35254,50.18181,-2.69562),(-.32745,50.18502,-2.67081),(-.10117,49.67617,-3.23978),(-.10942,49.74596,-3.19447),(-.45034,50.27388,-2.73214),(-.12464,50.11444,-3.07875),(-.13293,50.11177,-3.1363),(-.23747,50.15315,-3.07031),(-.26255,50.31771,-2.90565),(-.27968,50.40696,-2.86458),(-.49223,50.43797,-2.73486),(-.4048,50.48096,-2.73499),(-.42569,50.44419,-2.76042),(-.4521,50.08616,-2.55386),(-.00542,49.87861,-3.58407),(-.02407,49.81631,-3.56315),(-.01962,49.73176,-3.65929),(-.06009,49.58978,-3.64896),(-.1886,49.92086,-3.29453),(-.50678,50.18803,-2.95173),(-.51901,50.25198,-2.87329),(-.43459,50.24666,-2.90472),(-.68292,50.24281,-2.77318),(-.58358,50.28292,-2.81716),(-.68644,50.33642,-2.69861),(-.68111,50.34832,-2.71015),(-.41485,50.29037,-2.88103),(-.36542,50.2568,-2.92389),(-.46024,49.88374,-2.41635),(-.29229,49.44881,-2.12877),(-.13577,49.52025,-2.00918),(-.62217,50.18027,-3.08856),(-.48902,50.07668,-2.7184),(-.49974,50.00684,-2.66899),(-.80001,50.09783,-2.91684),(-.58973,49.54206,-2.56914),(-.55712,49.48578,-2.57388),(-.58832,49.57456,-2.75798),(-.57111,49.5328,-2.66109),(-.59964,49.58374,-2.66675),(-.2971,49.32581,-2.15537),(-.15127,49.44945,-2.29526),(-.22541,49.42931,-2.29463),(-.3043,49.4591,-2.4523),(-.16243,49.51425,-2.55672),(-.15495,49.48019,-2.45942),(-.44786,49.49237,-2.77847),(-.32612,49.88968,-2.99832),(-.36268,49.86112,-3.01429),(-.30219,49.91756,-2.99074),(-.53499,49.80535,-3.01007),(-.14672,49.57617,-3.32928),(-.16539,49.67284,-3.24022),(-.13517,49.3667,-3.57283),(-.09368,49.34138,-3.6958),(-.0727,49.30465,-3.7643),(-.06655,49.35265,-3.67504),(-.13865,49.37074,-3.57612),(-.18864,49.72877,-3.39635),(-.60457,50.12221,-3.14434),(-.63993,50.0254,-3.16393),(-.76533,50.11492,-3.24691),(-.76289,50.24173,-3.12311),(-1.12316,50.19999,-3.16981),(-1.08884,50.1654,-3.28115),(-1.13108,50.13812,-3.21353),(-.99574,49.98323,-3.12855),(-.50762,49.70095,-3.20773),(-.92,49.85188,-3.04659),(-.64904,49.75107,-3.13424),(-.72351,49.90505,-3.18615),(-.95795,49.90173,-3.2741),(-.00566,49.63239,-3.87474),(-.05376,49.27041,-3.97733),(-.1707,49.96346,-2.08111),(-.23596,49.95662,-2.07272),(-.14907,49.94703,-1.99084),(-.50223,50.08067,-2.65401),(-.47767,50.14974,-2.6772),(-.4884,49.9307,-2.62457),(-.35581,49.98761,-2.38568),(-.37272,50.03966,-2.48509),(-.45202,49.98337,-2.35716),(-.58413,49.58828,-2.75705),(-.31273,49.53682,-2.86072),(-.15561,49.33113,-2.03553),(-.07528,49.3128,-2.0095),(-.46255,49.49225,-2.77909),(-.48349,49.51934,-2.83351),(-.50009,49.39741,-2.44807),(-.53536,49.46931,-2.4961),(-.48117,49.48442,-2.73411),(-.49195,49.48573,-2.74717),(-.46902,49.48815,-2.75171),(-.56086,49.53399,-2.73099),(-.51745,49.492,-2.66148),(-.52127,50.00217,-2.71863),(-.37845,50.16823,-2.65809),(-.31075,49.92507,-2.9217),(-.33967,49.9029,-2.85526),(-.43791,49.8453,-2.8623),(-.29658,49.95486,-2.91445),(-.3196,50.14249,-2.76332),(-.27948,50.0497,-2.81082),(-.35529,50.32893,-2.79497),(-.37022,50.25083,-2.77276),(-.61099,50.42397,-2.6808),(-.61442,50.41591,-2.67261),(-.51975,50.46491,-2.67148),(-.19808,50.15718,-3.04237),(-.29918,50.20103,-2.99439),(-.87398,50.2794,-3.24037),(-.96371,50.28585,-3.25399),(-.97756,49.92568,-3.03086),(-.89207,50.00311,-2.9827),(-.88904,50.25032,-3.06683),(-1.0463,50.19429,-3.06456),(-.93832,50.2194,-3.03332),(-.99587,50.08126,-3.09229),(-.99324,50.1708,-3.04015),(-.98352,49.92962,-3.03288),(-1.00939,49.88494,-3.08125),(-1.09866,50.08624,-3.3137),(-1.1212,50.06815,-3.25338),(-1.12132,50.20395,-3.16364),(-.99315,49.8765,-3.23827),(-.62448,50.18862,-2.89135),(-.64344,49.87423,-2.95924),(-.55197,49.8873,-2.80924),(-.56259,49.7444,-3.027),(-.4547,49.84229,-2.99347),(-.36312,49.85291,-3.01651),(-.5476,49.60031,-3.12772),(-.59928,49.64773,-3.07666),(-.59978,49.65575,-3.09569),(-.16783,49.50058,-3.40829),(0,49.66369,-3.25102),(-.06524,49.7019,-3.22238),(-.06499,49.69848,-3.22677),(-.61282,49.66855,-3.12769),(-.58056,49.64547,-3.17195),(-.58034,49.64014,-3.1714),(-.60692,49.65777,-3.11462),(-.57139,49.61743,-3.15517),(-.3478,49.56482,-3.2881),(-.0253,49.53463,-3.94429),(-.003,49.61065,-3.90748),(-.15786,49.46171,-3.51503),(-.09673,49.34539,-3.69772),(-.1261,49.46384,-3.47687),(-.03544,49.28799,-3.75516),(.05642,49.19156,-3.98134),(.02794,49.18347,-3.99985),(.02957,49.25526,-4.00259),(.0764,49.41527,-3.54158),(.07088,49.30191,-3.76761),(.05189,49.25079,-3.86506),(.28541,49.54188,-3.3402),(.03423,49.51824,-3.85316),(.43873,49.58474,-3.24815),(.60444,49.79603,-3.12238),(.36379,49.54152,-3.23607),(.23512,49.59268,-3.2483),(.20146,49.68009,-3.20371),(.21312,49.67094,-3.1746),(.24185,49.5923,-3.21384),(.37036,49.52767,-3.21765),(.43713,49.54422,-3.19495),(.49698,49.57212,-3.16325),(.55739,49.61289,-3.12676),(.61448,49.78746,-3.04357),(.60667,49.82914,-2.99813),(.58155,49.82227,-2.99944),(.64344,49.87423,-2.94119),(.60027,49.86541,-2.94852),(.54862,49.85708,-2.95512),(.63081,49.89059,-2.85861),(.67794,50.14106,-2.86198),(.62486,50.18266,-2.87696),(.60282,50.1495,-2.85101),(.92951,50.12586,-3.01205),(.90033,50.15307,-3.01435),(.96688,49.85491,-3.18299),(.91071,49.88432,-3.22261),(1.03536,50.28948,-3.19641),(.79555,50.27331,-3.11586),(.94351,50.06147,-3.34951),(.9671,50.01207,-3.35097),(.91014,50.05573,-3.34036),(.94532,50.11524,-3.02685),(1.01374,50.01636,-3.34945),(.98423,50.02783,-3.07532),(.84274,50.1893,-3.04274),(.97647,50.22588,-3.29116),(.5081,50.18018,-2.941),(.26089,50.10637,-2.93993),(.28445,50.07798,-2.87201),(.2667,50.14791,-2.91919),(.33437,50.45226,-2.78201),(.37022,50.25083,-2.76149),(.29136,50.24497,-2.87374),(.54501,50.21805,-2.71896),(.29658,49.95486,-2.90507),(.30218,49.92488,-2.84204),(.3692,49.78945,-2.25769),(.33967,49.9029,-2.84403),(.27189,49.91207,-2.80975),(.40211,50.2018,-2.70405),(.40348,50.27288,-2.73516),(.50233,50.15372,-2.71813),(.51298,49.84833,-2.74833),(.4762,49.89,-2.63839),(.50927,49.66757,-2.76781),(.51782,49.68229,-2.72706),(.36102,49.63129,-2.81914),(.26861,49.73193,-2.84175),(.29026,49.63825,-2.84977),(.22541,49.42931,-2.28952),(.3043,49.4591,-2.43957),(.48349,49.51934,-2.81705),(.58649,49.55498,-2.54079),(.54025,49.61727,-2.5367),(.49374,49.51884,-2.41),(.28709,49.53067,-2.64061),(.49576,49.39407,-2.43201),(.40053,49.43778,-2.44369),(.48916,49.41702,-2.49202),(.38229,49.57624,-2.29113),(.4678,49.89541,-2.40575),(.50184,50.0305,-2.65964),(.49051,50.12614,-2.595),(.15081,50.05822,-2.52965),(.15796,50.00794,-2.38158),(.21537,50.05827,-2.51598),(.30832,50.05835,-2.49505),(.25132,50.13689,-2.68113),(.26892,50.16337,-2.65125),(.3153,50.12806,-2.58375),(.37414,50.11327,-2.5592),(.06765,49.2448,-3.95888),(.04768,49.20007,-3.94316),(.05592,49.29344,-3.89906),(.03608,49.54467,-3.75556),(.05117,49.47148,-3.76761),(1.0147,50.07454,-3.35241),(1.02495,49.92397,-3.3027),(.71679,49.90188,-2.90404),(.82011,49.99536,-2.90701),(1.06033,50.23795,-3.22933),(.37867,49.74784,-3.25163),(.10977,49.55493,-3.56998),(.61692,49.66255,-3.09872),(.62813,49.67824,-3.10642),(.06004,49.52773,-3.39088),(.08942,49.60582,-3.30868),(.45,49.49946,-2.63917),(.50305,49.48949,-2.64217),(.49056,49.44001,-2.54212),(.4269,49.47964,-2.54447),(.15127,49.44945,-2.29267),(.15542,49.4125,-2.2185),(.15481,49.36354,-2.15315),(.53169,49.47957,-2.46639),(.50009,49.39741,-2.42802),(.65181,50.19568,-2.81856),(.73057,49.98231,-2.86463),(.52893,50.11623,-2.78702),(.06778,49.50951,-1.96409),(.07424,49.40692,-1.98443),(.50116,49.68235,-2.52855),(.48761,49.89524,-2.56257),(.48451,49.85782,-2.48265),(.49063,50.18485,-2.70138),(.14121,50.08792,-3.19648),(.05982,49.87222,-3.46859),(.07752,49.93408,-3.39165),(.15676,49.91145,-1.90144),(.07453,49.95155,-1.96337),(.0766,49.89114,-1.85366),(.48576,50.13203,-2.60821),(.45291,50.14863,-2.61833),(.29224,50.13253,-2.71342),(-.00695,49.98511,-3.39089),(-.00343,49.23665,-3.83278),(.45759,50.14506,-2.60107),(.14907,49.94703,-1.98417),(.35552,50.32822,-2.8735),(.4884,49.9307,-2.60709),(.70818,50.06247,-2.85661),(.55455,49.99496,-2.77739),(.63956,49.97771,-2.82203),(.07444,49.32471,-2.09778),(0,49.59902,-3.31484),(.20897,49.50351,-3.41932),(.06758,49.3728,-3.77189),(.32779,49.82915,-3.23567),(.3957,49.88122,-3.17622),(1.13024,50.13587,-3.19415),(1.04624,50.10268,-3.13246),(.37163,50.16873,-2.63184),(.28604,49.99391,-2.37839),(.34958,49.96566,-2.22079),(.32127,49.94127,-2.04816),(.41461,49.96614,-2.2227),(.48127,49.88417,-2.57433),(.06953,49.73786,-2.7428),(.51695,49.44086,-2.49254),(.14952,49.32372,-2.04484),(.40839,49.89723,-2.23589),(.19115,50.07044,-3.01667),(1.04758,50.18861,-3.04739),(1.0243,50.11787,-3.08804),(.98842,50.17585,-3.01916),(.96371,50.28585,-3.24151),(.62217,50.18027,-3.07459),(.50154,49.58462,-3.16951),(.24563,49.59345,-3.20861),(.21792,49.67056,-3.17038),(.1261,49.46384,-3.47427),(.51208,49.58861,-3.18526),(.52057,49.61231,-3.1956),(.41065,49.66638,-3.25397),(.03977,49.54382,-3.91832),(.00342,49.18003,-4.00672),(.05376,49.27041,-3.97697),(-.21089,49.50688,-3.42689),(-.00347,49.52138,-3.95551),(-.35235,49.56223,-3.28564),(-.38882,50.15767,-2.99308),(-.10991,49.7528,-3.18566),(-.12204,49.51291,-3.39825),(-.55775,49.74108,-3.02713),(-.63862,50.16208,-2.93412),(-1.0243,50.11787,-3.10549),(-.99372,50.27105,-3.09412),(-.23723,50.23031,-2.96144),(-.5191,50.46839,-2.67755),(-.40163,50.47923,-2.73191),(-.33722,50.3052,-2.81981),(-.46107,50.19543,-2.71135),(-.43924,50.16923,-2.67665),(-.28445,50.07798,-2.88085),(-.48819,50.12028,-2.75661),(0,49.32214,-2.08636),(-.50376,49.44166,-2.56256),(-.49056,49.44001,-2.56113),(-.51908,49.50926,-2.77387),(-.07761,49.32381,-1.99997),(-.56323,49.56696,-2.81335),(-.49569,50.11279,-2.69663),(-.26829,50.17093,-2.65147),(-.25078,50.1338,-2.61402),(-.03977,49.54382,-3.91864),(-.04912,49.46959,-3.93621),(-1.02495,49.92397,-3.31708),(-1.06033,50.23795,-3.24231),(-.22473,49.64816,-3.38758),(-.41065,49.66638,-3.264),(-.39693,49.6317,-3.16108),(-.34831,49.69228,-3.1375),(-.36356,49.66621,-3.15118),(0,49.51294,-2.55496),(-.44211,49.34719,-2.32791),(-.29478,49.39716,-2.3007),(-.26099,49.94696,-3.21587),(-.09151,49.62632,-3.56886),(-.07895,49.67547,-3.56252),(-.48761,49.89524,-2.58052),(-.39101,50.16264,-2.99042),(-.45759,50.14506,-2.61657),(-.50233,50.15372,-2.73385),(-.49063,50.18485,-2.71674),(-.54501,50.21805,-2.73529),(-.35552,50.32822,-2.88318),(-.13428,49.75844,-1.94241),(-.24322,49.87656,-3.06404),(-.44476,49.63773,-3.14507),(-.4071,49.70551,-3.11874),(-.06758,49.3728,-3.77272),(-1.01866,50.04436,-3.14543),(-.03795,49.44069,-3.85215),(-.37163,50.16873,-2.64442),(-.28604,49.99391,-2.38994),(-.34958,49.96566,-2.23542),(-.41461,49.96614,-2.23978),(-.32127,49.94127,-2.06213),(-.38229,49.57624,-2.30709),(-.48127,49.88417,-2.59204),(-.54025,49.61727,-2.55728),(-.07541,50.0694,-2.52957),(-.40839,49.89723,-2.25293),(-.2667,50.14791,-2.92703),(-1.04758,50.18861,-3.06491),(-.55739,49.61289,-3.14142),(-.52057,49.61231,-3.20863),(-.51208,49.58861,-3.19828),(-.00342,49.18003,-4.00674),(.03235,49.24332,-3.84796),(.00347,49.52138,-3.95548),(.58056,49.64547,-3.15732),(.06524,49.7019,-3.22063),(.36312,49.85291,-3.0057),(1.08884,50.1654,-3.26843),(.97756,49.92568,-3.01025),(.51975,50.46491,-2.65718),(.61442,50.41591,-2.65584),(.5191,50.46839,-2.66335),(.61099,50.42397,-2.66427),(.30219,49.91756,-2.9816),(.07528,49.3128,-2.00998),(.50376,49.44166,-2.54313),(.53536,49.46931,-2.47513),(.58413,49.58828,-2.73704),(.37272,50.03966,-2.47095),(.1707,49.96346,-2.07359),(.23596,49.95662,-2.06237),(.04912,49.46959,-3.93584),(1.01983,49.9685,-3.16193),(.22473,49.64816,-3.38256),(.29229,49.44881,-2.12376),(.39101,50.16264,-2.97985),(.26255,50.31771,-2.89844),(.07587,49.85216,-2.69758),(-.00343,49.25057,-4.01312),(.00343,49.25057,-4.0131),(.07723,50.11919,-2.5957),(.2717,49.96892,-2.97477),(0,50.00055,-3.10187),(.11349,49.93969,-3.07612),(.1097,50.0358,-3.0613),(0,49.91864,-3.10942),(.47286,50.351,-2.70224),(.40296,50.35854,-2.73501),(.42569,50.44419,-2.74885),(.49223,50.43797,-2.72149),(.55804,50.32084,-2.69613),(.08453,49.98446,-2.24238),(.17477,49.97937,-2.23721),(.08194,49.96981,-2.08416),(.00586,49.70068,-3.77609),(.01097,49.65454,-3.75799),(.0061,49.77446,-3.68843),(.5023,50.35956,-2.7811),(.58193,50.33497,-2.764),(.54662,50.39738,-2.72967),(.32991,49.93216,-2.04925),(.42259,49.95923,-2.22654),(.3249,49.88594,-2.05377),(.13307,49.64171,-1.97516),(.07151,49.75191,-1.89074),(.06655,49.6322,-1.92761),(.13428,49.75844,-1.93854),(.44837,49.62264,-2.4057),(.42777,49.4777,-2.28348),(.30217,49.33096,-2.14231),(.15561,49.33113,-2.03604),(.55712,49.48578,-2.55284),(.58973,49.54206,-2.54708),(0,49.30666,-1.99539),(0,49.44985,-2.2824),(.31887,49.49493,-2.54208),(.16022,49.53856,-2.65844),(.34372,49.72163,-3.11368),(.3613,49.75977,-3.08145),(.43715,49.55682,-3.20821),(.07449,49.51637,-3.65631),(.09371,49.40348,-3.68934),(.14066,49.68592,-3.46771),(1.05572,50.27242,-3.17029),(1.0463,50.19429,-3.0471),(.99372,50.27105,-3.07815),(.72351,49.90505,-3.17044),(.0312,49.33491,-3.99246),(.27198,49.97059,-2.22603),(0,49.50379,-1.9395),(0,49.39267,-1.96502),(.53932,49.6801,-2.64864),(.44703,49.35068,-2.30495),(0,49.98463,-2.6314),(0,49.8375,-2.68651),(0,49.98792,-2.24429),(0,49.97465,-2.09142),(.07512,49.84083,-1.85114),(.15634,49.85258,-1.90243),(0,50.08867,-3.12008),(.11848,50.10926,-3.06778),(0,50.08544,-3.11001),(1.05906,50.0454,-3.1766),(1.11995,50.06632,-3.23351),(.45957,49.75352,-3.04831),(.42426,49.78314,-3.04459),(.48411,49.71649,-3.06334),(.46666,49.6553,-3.11198),(.44476,49.63773,-3.13296),(.59407,49.6464,-3.05937),(.43996,49.57929,-3.24536),(.44147,49.55875,-3.2258),(.51976,49.61786,-3.19792),(.02993,49.45104,-3.96604),(.00352,49.42912,-3.9817),(-.00352,49.42912,-3.98173),(-.0312,49.33491,-3.99266),(-.02993,49.45104,-3.96625),(-.0035,49.31587,-4.00609),(-.03235,49.24332,-3.84829),(-.43715,49.55682,-3.21943),(-.44147,49.55875,-3.23691),(-.43996,49.57929,-3.25622),(-.51976,49.61786,-3.2109),(0,49.75297,-3.19828),(-.39068,49.77721,-3.07033),(-.42426,49.78314,-3.05682),(-1.0147,50.07454,-3.36448),(-1.0868,50.00313,-3.3247),(-1.11995,50.06632,-3.24787),(-.11848,50.10926,-3.071),(-.4552,50.32209,-2.84192),(-.50297,50.25557,-2.7237),(-.15634,49.85258,-1.90914),(-.3249,49.88594,-2.06802),(-.07453,49.95155,-1.96673),(-.08194,49.96981,-2.08779),(0,49.94902,-1.94358),(-.07587,49.85216,-2.70044),(0,49.72707,-2.72547),(-.59575,49.59829,-2.66718),(-.30217,49.33096,-2.14798),(-.06655,49.6322,-1.92822),(0,49.75221,-1.87257),(0,49.62749,-1.90378),(-.07151,49.75191,-1.89266),(-.15669,49.8997,-1.90148),(-.0766,49.89114,-1.85715),(-.15676,49.91145,-1.90852),(-.07657,49.87915,-1.85125),(-.32991,49.93216,-2.0636),(-.42259,49.95923,-2.24393),(-.99642,50.15307,-3.34188),(-1.05572,50.27242,-3.18418),(-.07449,49.51637,-3.65746),(-.09371,49.40348,-3.69071),(-.08942,49.60582,-3.31091),(-.4778,49.68029,-3.10386),(-.46666,49.6553,-3.1248),(-.59407,49.6464,-3.07559),(-.48411,49.71649,-3.07698),(-.31887,49.49493,-2.55499),(-.16022,49.53856,-2.66478),(-.44703,49.35068,-2.32361),(-.42777,49.4777,-2.30129),(-.12928,49.85222,-3.38973),(-.53932,49.6801,-2.66811),(-.5023,50.35956,-2.79479),(-.39597,50.41954,-2.79262),(-.54662,50.39738,-2.74449),(-.58193,50.33497,-2.77975),(-.01097,49.65454,-3.75812),(-.27198,49.97059,-2.23754),(-.36951,50.38817,-2.83255),(-.1097,50.0358,-3.06438),(-.2717,49.96892,-2.98295),(-.14513,50.01016,-2.6818),(-.14773,49.87064,-2.72548),(-.07723,50.11919,-2.59854),(-.07256,49.9942,-2.64244),(-.20626,49.95478,-3.03773),(-.11349,49.93969,-3.07938),(-.40296,50.35854,-2.7467),(-.55804,50.32084,-2.71218),(-.08453,49.98446,-2.246),(-.17477,49.97937,-2.24467),(-.00581,49.70068,-3.77616),(-.00606,49.77446,-3.68851),(-.10394,49.77598,-3.46475),(-.14066,49.68592,-3.47056),(-.14477,49.53947,-2.8288),(-.34372,49.72163,-3.12337),(-.07512,49.84083,-1.85419),(0,49.86823,-1.82708),(0,49.83773,-1.82977),(-.44837,49.62264,-2.42407),(-.42905,49.72315,-2.40482),(0,50.11235,-2.58204),(0,50.02889,-2.38708),(-.07898,50.01841,-2.38814),(0,49.88046,-1.83173),(-.47286,50.351,-2.716),(-.12029,49.85081,-3.13339),(0,49.83492,-3.1503),(.0035,49.31587,-4.00607),(.62398,49.67272,-3.08882),(.39068,49.77721,-3.05907),(.3505,49.97971,-3.15239),(.93832,50.2194,-3.01565),(.20626,49.95478,-3.03169),(.45034,50.27388,-2.71855),(.07541,50.0694,-2.52667),(.07782,50.12211,-2.58731),(0,49.32194,-1.98357),(.07761,49.32381,-2.0007),(.15669,49.8997,-1.89439),(.07657,49.87915,-1.84778),(1.01866,50.04436,-3.12812),(.4071,49.70551,-3.10737),(.4778,49.68029,-3.0906),(.12029,49.85081,-3.13),(0,49.52527,-2.62446),(.12928,49.85222,-3.38695),(.59575,49.59829,-2.64594),(.39597,50.41954,-2.78184),(.10394,49.77598,-3.46267),(.36951,50.38817,-2.82251),(0,50.07995,-3.19469),(.50297,50.25557,-2.70857),(.07898,50.01841,-2.3849),(.4552,50.32209,-2.82947),(.42905,49.72315,-2.38721),(.59964,49.58374,-2.64537),(.63128,49.68283,-3.09944),(-.45957,49.75352,-3.06144),(0,49.53212,-2.7606),(-.3613,49.75977,-3.09179)]))),
        Shape(DEF='t4disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t4disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,6,16,-1,17,18,19,-1,20,21,1,-1,22,23,24,-1,25,26,27,-1,28,17,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,41,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,56,-1,73,74,11,-1,75,76,77,-1,78,79,80,-1,54,56,72,-1,55,81,56,-1,50,82,83,-1,82,84,83,-1,43,85,86,-1,87,42,88,-1,89,90,63,-1,91,52,92,-1,93,94,72,-1,95,96,97,-1,98,99,61,-1,100,101,102,-1,103,104,105,-1,106,0,26,-1,21,22,24,-1,107,108,109,-1,105,110,29,-1,12,111,55,-1,112,113,114,-1,115,112,116,-1,117,118,119,-1,117,119,120,-1,115,113,112,-1,121,116,112,-1,112,114,122,-1,3,102,123,-1,15,124,125,-1,16,6,126,-1,127,128,28,-1,129,13,12,-1,55,130,12,-1,131,107,109,-1,21,24,2,-1,23,132,133,-1,132,134,133,-1,25,106,26,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,93,72,87,-1,85,144,145,-1,146,147,148,-1,40,89,63,-1,42,44,88,-1,85,64,86,-1,92,149,84,-1,84,82,92,-1,150,151,152,-1,72,94,54,-1,73,11,153,-1,152,144,154,-1,69,66,155,-1,63,86,64,-1,60,156,61,-1,157,58,158,-1,57,59,159,-1,69,96,160,-1,150,81,161,-1,151,78,152,-1,75,91,76,-1,162,54,94,-1,55,54,130,-1,48,50,83,-1,45,47,163,-1,43,86,44,-1,40,63,41,-1,149,51,164,-1,89,160,165,-1,166,120,115,-1,167,168,123,-1,20,169,8,-1,146,148,170,-1,100,25,27,-1,23,133,24,-1,21,2,1,-1,103,17,19,-1,18,108,19,-1,18,109,108,-1,55,111,125,-1,12,14,111,-1,126,171,172,-1,127,173,128,-1,11,74,9,-1,16,124,15,-1,16,9,124,-1,174,111,14,-1,68,70,3,-1,175,176,5,-1,26,0,2,-1,177,178,179,-1,178,177,180,-1,181,182,183,-1,182,181,184,-1,5,102,3,-1,5,185,102,-1,186,187,188,-1,186,189,187,-1,187,190,191,-1,192,190,187,-1,190,193,194,-1,190,195,193,-1,194,196,140,-1,194,193,196,-1,193,115,196,-1,113,115,193,-1,122,121,112,-1,121,122,197,-1,130,129,12,-1,198,129,130,-1,125,199,55,-1,125,124,199,-1,200,127,110,-1,200,201,127,-1,172,201,126,-1,172,137,201,-1,202,105,203,-1,202,110,105,-1,204,205,206,-1,207,205,204,-1,179,208,209,-1,179,178,208,-1,146,210,211,-1,146,170,210,-1,212,213,214,-1,212,215,213,-1,179,216,177,-1,217,216,179,-1,166,109,218,-1,166,131,109,-1,219,220,184,-1,219,221,220,-1,169,177,216,-1,169,222,177,-1,168,206,223,-1,168,204,206,-1,31,0,106,-1,31,224,0,-1,132,14,13,-1,132,23,14,-1,28,214,17,-1,214,28,128,-1,171,217,172,-1,216,217,171,-1,13,225,132,-1,225,13,129,-1,102,167,123,-1,101,167,102,-1,30,140,139,-1,30,32,140,-1,116,107,131,-1,107,116,121,-1,226,221,227,-1,228,221,226,-1,46,157,48,-1,46,229,157,-1,62,34,33,-1,62,230,34,-1,89,231,160,-1,89,40,231,-1,232,162,233,-1,198,162,232,-1,234,144,80,-1,234,145,144,-1,77,235,236,-1,235,77,76,-1,147,237,148,-1,147,238,237,-1,141,239,240,-1,141,143,239,-1,95,241,242,-1,95,97,241,-1,93,88,243,-1,93,87,88,-1,244,245,60,-1,246,245,244,-1,61,247,98,-1,61,156,247,-1,248,246,249,-1,248,36,246,-1,250,92,82,-1,235,92,250,-1,147,251,238,-1,147,252,251,-1,252,163,251,-1,163,252,253,-1,44,254,88,-1,254,44,90,-1,56,150,152,-1,81,150,56,-1,255,77,37,-1,75,77,255,-1,78,144,152,-1,144,78,80,-1,153,53,256,-1,257,53,153,-1,73,199,74,-1,161,199,73,-1,151,153,256,-1,73,153,151,-1,258,259,260,-1,258,261,259,-1,262,263,264,-1,263,262,226,-1,265,142,34,-1,265,266,142,-1,264,261,258,-1,264,263,261,-1,267,268,269,-1,260,268,267,-1,269,266,265,-1,266,269,270,-1,155,186,271,-1,155,272,186,-1,69,271,70,-1,69,155,271,-1,83,273,47,-1,273,83,84,-1,44,63,90,-1,86,63,44,-1,243,254,242,-1,88,254,243,-1,82,247,250,-1,82,50,247,-1,68,96,69,-1,274,96,68,-1,270,67,266,-1,270,65,67,-1,268,259,275,-1,268,260,259,-1,59,258,159,-1,59,264,258,-1,266,276,142,-1,266,67,276,-1,277,59,229,-1,277,264,59,-1,264,277,262,-1,260,159,258,-1,159,260,267,-1,150,73,151,-1,73,150,161,-1,278,237,257,-1,278,148,237,-1,78,256,255,-1,78,151,256,-1,242,279,243,-1,241,279,242,-1,238,273,164,-1,238,251,273,-1,250,236,235,-1,236,250,280,-1,234,249,281,-1,234,248,249,-1,50,98,247,-1,49,98,50,-1,253,45,163,-1,282,45,253,-1,281,145,234,-1,145,281,283,-1,206,97,223,-1,97,206,241,-1,41,143,39,-1,143,41,239,-1,237,164,51,-1,238,164,237,-1,236,37,77,-1,236,38,37,-1,43,144,85,-1,43,154,144,-1,40,276,231,-1,40,39,276,-1,230,61,99,-1,62,61,230,-1,277,46,45,-1,46,277,229,-1,284,221,219,-1,221,284,227,-1,131,115,116,-1,131,166,115,-1,32,106,285,-1,31,106,32,-1,223,123,168,-1,274,123,223,-1,174,23,22,-1,23,174,14,-1,172,135,137,-1,217,135,172,-1,103,29,17,-1,103,105,29,-1,22,7,174,-1,22,21,7,-1,286,100,27,-1,101,100,286,-1,225,205,207,-1,225,232,205,-1,222,20,1,-1,169,20,222,-1,228,220,221,-1,228,287,220,-1,218,120,166,-1,120,218,117,-1,209,217,179,-1,135,217,209,-1,17,213,18,-1,17,214,213,-1,182,170,288,-1,170,182,210,-1,184,210,182,-1,184,220,210,-1,286,24,133,-1,286,27,24,-1,15,111,6,-1,15,125,111,-1,173,201,137,-1,173,127,201,-1,8,126,6,-1,8,171,126,-1,110,10,200,-1,110,202,10,-1,199,9,74,-1,199,124,9,-1,10,16,200,-1,10,9,16,-1,259,289,290,-1,261,289,259,-1,263,227,291,-1,263,226,227,-1,32,194,140,-1,292,194,32,-1,261,291,289,-1,263,291,261,-1,275,187,189,-1,192,187,275,-1,191,188,187,-1,188,191,175,-1,4,175,5,-1,4,188,175,-1,287,210,220,-1,287,211,210,-1,224,1,0,-1,224,222,1,-1,118,138,119,-1,138,118,208,-1,26,24,27,-1,26,2,24,-1,183,108,181,-1,183,19,108,-1,271,3,70,-1,3,271,4,-1,186,4,271,-1,188,4,186,-1,292,190,194,-1,292,191,190,-1,192,195,190,-1,192,290,195,-1,176,185,5,-1,176,285,185,-1,195,113,193,-1,114,113,195,-1,174,6,111,-1,174,7,6,-1,202,11,10,-1,11,202,278,-1,127,29,110,-1,29,127,28,-1,222,180,177,-1,222,224,180,-1,215,218,213,-1,215,117,218,-1,104,19,183,-1,104,103,19,-1,136,215,212,-1,136,293,215,-1,139,180,30,-1,139,178,180,-1,294,184,181,-1,294,219,184,-1,293,208,118,-1,293,209,208,-1,204,167,295,-1,168,167,204,-1,224,30,180,-1,31,30,224,-1,203,170,148,-1,288,170,203,-1,214,173,212,-1,214,128,173,-1,8,216,171,-1,169,216,8,-1,129,232,225,-1,129,198,232,-1,185,100,102,-1,25,100,185,-1,140,119,138,-1,119,140,196,-1,121,294,107,-1,294,121,197,-1,282,226,262,-1,282,228,226,-1,48,158,49,-1,48,157,158,-1,34,141,35,-1,141,34,142,-1,95,160,96,-1,95,165,160,-1,233,94,93,-1,233,162,94,-1,248,80,79,-1,248,234,80,-1,235,91,92,-1,235,76,91,-1,242,165,95,-1,165,242,254,-1,93,279,233,-1,93,243,279,-1,156,245,280,-1,245,156,60,-1,48,47,46,-1,48,83,47,-1,33,296,244,-1,33,35,296,-1,245,36,38,-1,36,245,246,-1,252,146,211,-1,147,146,252,-1,244,249,246,-1,296,249,244,-1,205,241,206,-1,205,279,241,-1,51,257,237,-1,53,257,51,-1,255,79,78,-1,79,255,37,-1,75,256,53,-1,256,75,255,-1,199,81,55,-1,81,199,161,-1,162,130,54,-1,162,198,130,-1,157,59,58,-1,157,229,59,-1,99,297,230,-1,99,57,297,-1,230,265,34,-1,297,265,230,-1,297,269,265,-1,267,269,297,-1,269,298,270,-1,269,268,298,-1,298,186,272,-1,186,298,189,-1,160,66,69,-1,66,160,231,-1,251,47,273,-1,251,163,47,-1,296,281,249,-1,296,240,281,-1,33,60,62,-1,33,244,60,-1,64,239,41,-1,283,239,64,-1,252,287,253,-1,211,287,252,-1,65,155,66,-1,155,65,272,-1,272,270,298,-1,272,65,270,-1,298,275,189,-1,298,268,275,-1,158,57,99,-1,57,158,58,-1,231,67,66,-1,67,231,276,-1,57,267,297,-1,57,159,267,-1,152,71,56,-1,71,152,154,-1,11,257,153,-1,11,278,257,-1,52,75,53,-1,52,91,75,-1,240,283,281,-1,239,283,240,-1,247,280,250,-1,156,280,247,-1,84,164,273,-1,149,164,84,-1,280,38,236,-1,38,280,245,-1,240,35,141,-1,35,240,296,-1,253,228,282,-1,228,253,287,-1,85,283,64,-1,85,145,283,-1,205,233,279,-1,232,233,205,-1,89,254,90,-1,89,165,254,-1,154,42,71,-1,42,154,43,-1,52,149,92,-1,149,52,51,-1,36,79,37,-1,36,248,79,-1,87,71,42,-1,87,72,71,-1,96,223,97,-1,96,274,223,-1,39,142,276,-1,39,143,142,-1,99,49,158,-1,98,49,99,-1,282,277,45,-1,282,262,277,-1,294,284,219,-1,294,197,284,-1,120,196,115,-1,120,119,196,-1,285,25,185,-1,106,25,285,-1,8,21,20,-1,21,8,7,-1,137,212,173,-1,136,212,137,-1,104,203,105,-1,104,288,203,-1,101,295,167,-1,101,286,295,-1,207,132,225,-1,132,207,134,-1,293,117,215,-1,293,118,117,-1,181,107,294,-1,107,181,108,-1,178,138,208,-1,139,138,178,-1,135,293,136,-1,135,209,293,-1,183,288,104,-1,288,183,182,-1,207,295,134,-1,207,204,295,-1,200,126,201,-1,16,126,200,-1,203,278,202,-1,278,203,148,-1,114,290,289,-1,114,195,290,-1,122,284,197,-1,291,284,122,-1,291,227,284,-1,285,292,32,-1,176,292,285,-1,289,122,114,-1,291,122,289,-1,259,192,275,-1,290,192,259,-1,176,191,292,-1,175,191,176,-1,123,68,3,-1,123,274,68,-1,218,18,213,-1,18,218,109,-1,286,134,295,-1,286,133,134,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t4disc_Coord',point=[(.38554,49.26198,-2.32904),(.40717,49.30516,-2.31481),(.31445,49.27774,-2.17199),(.12961,49.14422,-2.13757),(.11978,49.18081,-2.23936),(.22736,49.19072,-2.24087),(.29478,49.39716,-2.29185),(.29702,49.32843,-2.15505),(.41444,49.35748,-2.30815),(.15495,49.48019,-2.45344),(.16243,49.51425,-2.55),(0,49.51294,-2.55496),(.07444,49.32471,-2.09778),(.14588,49.32377,-2.04758),(.15897,49.32547,-2.05658),(.22541,49.42931,-2.28952),(.3043,49.4591,-2.43957),(.40509,49.5046,-2.74551),(.38055,49.44224,-2.74397),(.29875,49.4722,-2.78794),(.41672,49.35187,-2.30729),(.29835,49.32233,-2.15151),(.28442,49.32188,-2.1411),(.1613,49.32019,-2.05321),(.28472,49.26452,-2.1412),(.3047,49.20044,-2.24045),(.31969,49.23375,-2.20129),(.26381,49.20563,-2.13747),(.41033,49.50731,-2.7362),(.40352,49.50863,-2.74302),(.40086,49.25778,-2.44574),(.39957,49.25684,-2.44226),(.39464,49.25491,-2.44748),(-.41402,49.28444,-2.57174),(-.40793,49.28109,-2.57154),(-.41409,49.28411,-2.57034),(-.48966,49.43621,-2.56163),(-.48738,49.44199,-2.56116),(-.48925,49.4369,-2.56295),(-.35435,49.22848,-2.36095),(-.3047,49.20044,-2.25105),(-.38554,49.26198,-2.34497),(-.28442,49.32188,-2.14579),(-.29835,49.32233,-2.15715),(-.28472,49.26452,-2.14688),(-.0925,49.34909,-2.78107),(-.19379,49.37665,-2.7755),(-.23188,49.42357,-2.79551),(-.27934,49.36138,-2.76337),(-.31243,49.3332,-2.72028),(-.349,49.38287,-2.7438),(-.30445,49.53484,-2.79378),(-.40352,49.50863,-2.75768),(-.28709,49.53067,-2.65185),(-.07444,49.32471,-2.09718),(0,49.37885,-2.14591),(-.15481,49.36354,-2.15324),(-.29453,49.30272,-2.6586),(-.28184,49.33094,-2.71906),(-.19396,49.33206,-2.71628),(-.42995,49.33809,-2.6179),(-.36799,49.31016,-2.65333),(-.38088,49.30095,-2.63476),(-.31969,49.23375,-2.21064),(-.40717,49.30516,-2.33164),(-.22426,49.21099,-2.36465),(-.22736,49.19072,-2.24946),(-.30184,49.22005,-2.36368),(0,49.10007,-2.09566),(-.12961,49.14422,-2.14643),(0,49.12208,-2.12759),(-.27937,49.32718,-2.14624),(-.15897,49.32547,-2.05624),(-.15495,49.48019,-2.45942),(0,49.49519,-2.4409),(-.45,49.49946,-2.65614),(-.46294,49.49314,-2.69443),(-.47341,49.48617,-2.65858),(-.40053,49.43778,-2.46014),(-.48149,49.41972,-2.50891),(-.4732,49.40442,-2.45401),(-.15542,49.4125,-2.21961),(-.38055,49.44224,-2.75787),(-.29056,49.41321,-2.78678),(-.29875,49.4722,-2.7988),(-.41672,49.35187,-2.32451),(-.31445,49.27774,-2.17943),(-.1613,49.32019,-2.053),(-.19247,49.26214,-2.06614),(-.23639,49.153,-2.15172),(-.26381,49.20563,-2.14603),(-.41033,49.50731,-2.75114),(-.40509,49.5046,-2.7602),(-.14978,49.31997,-2.04447),(-.14588,49.32377,-2.04708),(-.13321,49.11548,-2.0822),(-.13021,49.11333,-2.08647),(-.1318,49.1151,-2.08163),(-.36756,49.31032,-2.65398),(-.36228,49.3064,-2.65124),(.23639,49.153,-2.13892),(.23367,49.15196,-2.13674),(.23136,49.15014,-2.14161),(.30451,49.53116,-2.7863),(.30255,49.53126,-2.78667),(.30445,49.53484,-2.7827),(.35435,49.22848,-2.34623),(.27934,49.36138,-2.75303),(.29056,49.41321,-2.77615),(.349,49.38287,-2.73091),(.28709,49.53067,-2.64061),(.15481,49.36354,-2.15315),(.28184,49.33094,-2.70843),(.29453,49.30272,-2.64723),(.20306,49.29791,-2.65828),(.36228,49.3064,-2.6374),(.30674,49.3296,-2.70642),(.41627,49.35726,-2.6459),(.42995,49.33809,-2.60145),(.38088,49.30095,-2.62017),(.36799,49.31016,-2.63929),(.27489,49.35657,-2.74924),(.19396,49.33206,-2.70886),(.13021,49.11333,-2.07566),(.15127,49.44945,-2.29267),(.15542,49.4125,-2.2185),(.40053,49.43778,-2.44369),(.45,49.49946,-2.63917),(.46294,49.49314,-2.67734),(.07384,49.31323,-2.0137),(0,49.32214,-2.08636),(.31243,49.3332,-2.70857),(.14978,49.31997,-2.04485),(.19247,49.26214,-2.06321),(.15463,49.25032,-2.04198),(.48966,49.43621,-2.54267),(.48925,49.4369,-2.544),(.48738,49.44199,-2.54226),(.41402,49.28444,-2.55563),(.41409,49.28411,-2.55422),(.40793,49.28109,-2.55565),(-.40086,49.25778,-2.46194),(-.39464,49.25491,-2.46343),(-.39957,49.25684,-2.45842),(-.41444,49.35748,-2.32526),(-.41783,49.35263,-2.32694),(0,49.52837,-2.76089),(-.00123,49.52846,-2.76157),(0,49.53193,-2.75693),(-.30451,49.53116,-2.79736),(-.22541,49.42931,-2.29463),(-.3043,49.4591,-2.4523),(-.29478,49.39716,-2.3007),(-.16243,49.51425,-2.55672),(-.29702,49.32843,-2.16063),(-.11978,49.18081,-2.24519),(-.41627,49.35726,-2.66161),(-.27489,49.35657,-2.75944),(-.30674,49.3296,-2.71794),(-.20306,49.29791,-2.66619),(-.23136,49.15014,-2.1545),(-.15127,49.44945,-2.29526),(-.07384,49.31323,-2.01323),(-.11007,49.4087,-2.80124),(-.30255,49.53126,-2.79766),(-.23367,49.15196,-2.14956),(.36756,49.31032,-2.63996),(.13321,49.11548,-2.07131),(.1318,49.1151,-2.07082),(.41783,49.35263,-2.30965),(.00123,49.52846,-2.76152),(.4732,49.40442,-2.43492),(.48149,49.41972,-2.48986),(.47341,49.48617,-2.64087),(.27937,49.32718,-2.14184),(.22426,49.21099,-2.35676),(.30184,49.22005,-2.35155),(.46314,49.34683,-2.4361),(.44883,49.32046,-2.53356),(.47323,49.36595,-2.51154),(.43703,49.29753,-2.44001),(.23188,49.42357,-2.78698),(.12775,49.47321,-2.80369),(.26864,49.47765,-2.79354),(.11007,49.4087,-2.79716),(.29964,49.19792,-2.24422),(0,49.18982,-2.3395),(.10913,49.22305,-2.45833),(.1177,49.2028,-2.35091),(0,49.20514,-2.45427),(.21069,49.25813,-2.55911),(.21685,49.23577,-2.46069),(.10363,49.24426,-2.56104),(.30379,49.2907,-2.62771),(.32662,49.27108,-2.55477),(.20543,49.28388,-2.6408),(.37513,49.29711,-2.61869),(.19379,49.37114,-2.76379),(0,49.3073,-1.99939),(0,49.44985,-2.2824),(.31887,49.49493,-2.54208),(.4269,49.47964,-2.54447),(.16022,49.53856,-2.65844),(.14768,49.5393,-2.79262),(.12121,49.17543,-2.03945),(0,49.22588,-2.00892),(0,49.1461,-2.02251),(.10181,49.24221,-2.01888),(.45027,49.32834,-2.55481),(.47658,49.38116,-2.55028),(.02237,49.4653,-2.77718),(0,49.4614,-2.76587),(.47523,49.48092,-2.64208),(.44241,49.4228,-2.67245),(.46476,49.48825,-2.67868),(.45357,49.4161,-2.64609),(.47602,49.39934,-2.43584),(.48409,49.41461,-2.49114),(.40888,49.3614,-2.65908),(.0925,49.34909,-2.77761),(.04854,49.39962,-2.77993),(.0774,49.33862,-2.76949),(.42258,49.31433,-2.34848),(0,49.0783,-2.05088),(.4154,49.28002,-2.39437),(.07569,49.30903,-2.01025),(0,49.32031,-2.74627),(.08081,49.33383,-2.76597),(0,49.32589,-2.75028),(-.19379,49.37114,-2.77103),(-.37513,49.29711,-2.63308),(-.29964,49.19792,-2.25475),(0,49.3029,-1.99578),(-.07569,49.30903,-2.00989),(-.47602,49.39934,-2.45501),(-.46476,49.48825,-2.69581),(-.47523,49.48092,-2.65984),(-.14768,49.5393,-2.7981),(-.14734,49.53554,-2.8021),(-.4154,49.28002,-2.41139),(-.43703,49.29753,-2.45762),(-.12121,49.17543,-2.04618),(-.1489,49.17974,-2.0586),(-.15463,49.25032,-2.04521),(-.45027,49.32834,-2.57224),(-.46745,49.38506,-2.59297),(-.47658,49.38116,-2.56871),(-.40888,49.3614,-2.67446),(-.48409,49.41461,-2.51026),(-.47323,49.36595,-2.5301),(-.44241,49.4228,-2.6889),(-.12775,49.47321,-2.80842),(-.02237,49.4653,-2.77803),(-.04854,49.39962,-2.78175),(-.22076,49.20394,-2.10191),(-.4269,49.47964,-2.56131),(-.31887,49.49493,-2.55499),(-.16022,49.53856,-2.66478),(-.0972,49.27974,-2.66771),(0,49.26107,-2.64476),(-.10056,49.26679,-2.64982),(0,49.27482,-2.66262),(-.08081,49.33383,-2.769),(0,49.29694,-2.70379),(-.08891,49.305,-2.71536),(-.32662,49.27108,-2.56772),(-.32378,49.25189,-2.46804),(-.20543,49.28388,-2.64885),(-.10363,49.24426,-2.56525),(-.21069,49.25813,-2.5676),(-.21685,49.23577,-2.46979),(0,49.16175,-2.23586),(-.1177,49.2028,-2.35499),(-.26864,49.47765,-2.80333),(0,49.07683,-2.05573),(0,49.22801,-2.55715),(-.34849,49.22595,-2.3638),(-.0957,49.3442,-2.77696),(0,49.52527,-2.62446),(-.10181,49.24221,-2.0215),(-.45357,49.4161,-2.6631),(-.46314,49.34683,-2.45475),(-.0774,49.33862,-2.77239),(-.42258,49.31433,-2.36604),(.0957,49.3442,-2.77337),(.34849,49.22595,-2.34932),(.22076,49.20394,-2.09387),(0,49.39141,-2.7622),(.14734,49.53554,-2.79664),(.0972,49.27974,-2.6639),(.10056,49.26679,-2.64586),(.08891,49.305,-2.71194),(.32378,49.25189,-2.45479),(.46745,49.38506,-2.57502),(.19379,49.37665,-2.76828),(.1489,49.17974,-2.05086),(-.44883,49.32046,-2.55108),(-.30379,49.2907,-2.63949),(-.10913,49.22305,-2.46279)]))),
        Shape(DEF='t5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,3,-1,8,7,6,-1,9,10,11,-1,12,13,10,-1,14,15,13,-1,16,17,18,-1,19,20,16,-1,21,22,23,-1,24,25,21,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,43,36,39,-1,43,44,36,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,81,75,78,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,94,95,54,-1,96,97,98,-1,99,100,101,-1,101,93,102,-1,55,54,95,-1,103,104,105,-1,106,107,103,-1,108,76,75,-1,75,109,108,-1,27,110,111,-1,110,112,113,-1,114,115,116,-1,117,118,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,89,159,160,-1,90,89,161,-1,162,163,164,-1,165,166,167,-1,168,169,170,-1,171,172,173,-1,174,175,105,-1,168,176,169,-1,177,178,179,-1,156,180,181,-1,182,183,184,-1,185,186,187,-1,188,189,190,-1,191,192,193,-1,194,195,196,-1,197,198,199,-1,200,201,202,-1,203,204,205,-1,206,207,208,-1,209,210,211,-1,125,124,199,-1,65,212,213,-1,214,215,216,-1,129,217,218,-1,215,219,216,-1,220,221,214,-1,222,219,215,-1,223,224,225,-1,226,227,228,-1,229,230,190,-1,231,232,233,-1,234,224,235,-1,236,237,238,-1,239,132,240,-1,139,241,242,-1,125,243,212,-1,243,125,198,-1,244,245,140,-1,136,246,67,-1,170,169,247,-1,248,249,250,-1,251,252,253,-1,254,251,255,-1,256,159,89,-1,29,173,257,-1,258,259,260,-1,154,153,196,-1,261,262,167,-1,263,264,265,-1,112,87,266,-1,267,248,268,-1,268,248,269,-1,270,271,59,-1,272,273,60,-1,251,254,168,-1,274,275,276,-1,277,264,263,-1,278,158,157,-1,279,280,281,-1,236,242,241,-1,282,283,284,-1,285,286,226,-1,287,288,289,-1,290,291,292,-1,293,62,294,-1,295,58,57,-1,296,59,58,-1,297,298,299,-1,300,47,46,-1,301,302,45,-1,303,302,301,-1,304,303,301,-1,305,306,307,-1,92,308,294,-1,309,49,269,-1,310,311,312,-1,313,314,315,-1,316,317,318,-1,301,319,320,-1,301,318,317,-1,321,322,323,-1,324,325,326,-1,327,328,323,-1,329,330,324,-1,331,332,333,-1,334,335,336,-1,337,338,339,-1,340,341,342,-1,343,344,345,-1,346,347,348,-1,349,350,351,-1,352,353,337,-1,354,355,356,-1,357,358,359,-1,360,361,362,-1,363,364,365,-1,366,367,368,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,382,-1,386,387,388,-1,389,390,332,-1,391,392,393,-1,394,395,331,-1,396,397,398,-1,399,400,401,-1,402,403,404,-1,368,402,405,-1,406,407,408,-1,409,410,411,-1,412,189,397,-1,413,414,415,-1,416,413,415,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,425,426,427,-1,428,429,424,-1,430,431,432,-1,433,434,435,-1,436,437,438,-1,437,439,438,-1,440,441,357,-1,442,376,443,-1,444,445,446,-1,447,435,448,-1,449,439,450,-1,448,451,447,-1,452,453,454,-1,455,456,457,-1,402,368,458,-1,417,459,380,-1,460,461,462,-1,463,464,465,-1,463,466,464,-1,467,468,412,-1,469,470,466,-1,458,368,367,-1,442,359,471,-1,472,473,474,-1,475,476,477,-1,473,335,478,-1,479,478,480,-1,471,481,482,-1,483,484,476,-1,471,482,485,-1,486,338,337,-1,487,488,489,-1,490,369,491,-1,492,493,494,-1,492,361,495,-1,496,497,434,-1,485,498,499,-1,500,501,469,-1,502,503,504,-1,505,506,387,-1,507,508,509,-1,510,511,385,-1,512,388,513,-1,514,515,516,-1,517,518,519,-1,514,516,517,-1,520,521,522,-1,523,524,525,-1,526,527,7,-1,528,4,529,-1,530,531,532,-1,530,533,534,-1,535,536,537,-1,534,538,539,-1,540,541,539,-1,542,543,1,-1,543,541,544,-1,545,546,547,-1,524,523,548,-1,25,549,550,-1,551,552,553,-1,554,555,556,-1,314,313,557,-1,365,558,559,-1,365,560,558,-1,561,555,554,-1,355,561,562,-1,563,564,35,-1,565,315,314,-1,311,363,566,-1,554,560,364,-1,567,311,568,-1,569,310,570,-1,526,571,11,-1,572,573,574,-1,524,575,576,-1,577,578,579,-1,432,580,581,-1,582,423,583,-1,584,585,565,-1,586,587,326,-1,520,588,589,-1,590,591,592,-1,593,328,594,-1,327,323,595,-1,596,444,597,-1,598,491,371,-1,599,600,601,-1,340,602,341,-1,603,604,605,-1,606,553,589,-1,607,586,325,-1,447,581,580,-1,608,389,583,-1,609,610,424,-1,611,582,332,-1,485,577,579,-1,602,525,576,-1,612,13,613,-1,612,572,574,-1,11,10,574,-1,527,536,7,-1,614,568,569,-1,615,616,40,-1,566,312,311,-1,551,584,314,-1,354,617,618,-1,619,617,354,-1,566,559,557,-1,620,621,622,-1,623,585,584,-1,550,624,472,-1,625,626,624,-1,627,625,548,-1,524,545,628,-1,572,629,628,-1,530,534,630,-1,532,528,533,-1,527,526,540,-1,591,631,632,-1,455,457,633,-1,519,634,635,-1,636,637,638,-1,639,640,641,-1,642,513,643,-1,381,644,645,-1,503,502,505,-1,496,646,647,-1,648,649,650,-1,492,349,353,-1,651,652,653,-1,654,655,486,-1,614,338,486,-1,656,657,658,-1,659,336,374,-1,660,661,662,-1,22,25,550,-1,659,374,663,-1,664,665,666,-1,351,350,653,-1,458,667,407,-1,668,669,404,-1,188,397,189,-1,670,671,672,-1,513,388,673,-1,674,462,461,-1,675,197,676,-1,677,671,678,-1,450,679,378,-1,421,420,448,-1,680,454,453,-1,442,357,359,-1,681,682,658,-1,455,683,684,-1,643,638,641,-1,608,685,427,-1,686,453,416,-1,379,680,687,-1,452,454,375,-1,463,688,689,-1,403,690,406,-1,409,377,408,-1,634,691,692,-1,512,693,386,-1,694,695,633,-1,695,696,683,-1,395,697,611,-1,697,645,430,-1,698,336,335,-1,621,663,699,-1,480,598,700,-1,701,702,703,-1,366,689,704,-1,655,654,615,-1,705,483,661,-1,706,337,707,-1,361,492,352,-1,708,709,707,-1,622,621,710,-1,535,529,536,-1,351,337,353,-1,598,711,491,-1,712,587,713,-1,607,585,714,-1,715,397,678,-1,702,701,336,-1,716,714,590,-1,710,552,551,-1,651,717,652,-1,718,692,719,-1,331,333,720,-1,366,405,466,-1,324,721,447,-1,445,596,601,-1,330,570,325,-1,324,326,722,-1,599,722,712,-1,316,593,594,-1,47,300,321,-1,723,724,317,-1,725,317,316,-1,726,727,728,-1,729,730,484,-1,598,17,16,-1,308,92,91,-1,93,731,94,-1,297,302,303,-1,303,724,723,-1,302,297,45,-1,732,46,297,-1,293,295,57,-1,733,734,299,-1,293,735,287,-1,736,284,70,-1,252,251,170,-1,737,161,258,-1,738,739,740,-1,741,253,248,-1,742,743,744,-1,155,181,180,-1,154,259,258,-1,597,148,50,-1,112,266,113,-1,165,745,206,-1,111,746,27,-1,100,99,747,-1,748,226,286,-1,749,750,751,-1,48,752,753,-1,169,754,755,-1,225,224,756,-1,202,757,220,-1,758,759,245,-1,760,758,245,-1,761,762,763,-1,135,764,765,-1,766,64,70,-1,241,139,767,-1,768,282,765,-1,282,736,765,-1,769,770,190,-1,771,772,773,-1,774,187,775,-1,774,748,187,-1,232,234,183,-1,235,776,777,-1,769,190,189,-1,778,228,779,-1,780,781,227,-1,782,222,783,-1,783,414,782,-1,219,222,782,-1,784,785,786,-1,787,788,203,-1,66,789,790,-1,131,791,792,-1,789,793,213,-1,794,795,796,-1,794,790,795,-1,794,797,66,-1,136,67,798,-1,799,800,211,-1,801,802,803,-1,208,207,756,-1,804,292,444,-1,800,288,205,-1,805,204,200,-1,223,806,216,-1,807,808,809,-1,774,182,748,-1,784,221,757,-1,810,811,812,-1,763,218,217,-1,813,814,112,-1,237,126,128,-1,285,815,286,-1,816,182,184,-1,817,233,232,-1,208,818,819,-1,176,754,169,-1,820,105,175,-1,821,247,822,-1,823,819,166,-1,824,305,257,-1,819,74,825,-1,258,161,160,-1,826,827,156,-1,828,753,829,-1,267,830,153,-1,194,196,153,-1,209,149,831,-1,832,74,833,-1,834,815,835,-1,144,836,837,-1,761,838,146,-1,839,508,507,-1,764,760,244,-1,127,809,840,-1,127,841,842,-1,843,766,238,-1,119,844,117,-1,115,845,85,-1,266,87,86,-1,846,847,113,-1,814,116,87,-1,110,848,849,-1,114,849,850,-1,848,26,851,-1,852,853,854,-1,855,856,108,-1,857,76,858,-1,106,858,859,-1,860,861,104,-1,862,277,54,-1,863,864,865,-1,102,93,94,-1,866,864,863,-1,867,868,866,-1,61,95,94,-1,101,100,869,-1,870,871,872,-1,88,869,256,-1,294,873,874,-1,845,115,83,-1,76,118,77,-1,875,73,72,-1,876,877,287,-1,273,95,61,-1,271,62,57,-1,878,59,296,-1,879,56,844,-1,880,881,270,-1,120,275,882,-1,121,279,883,-1,733,299,298,-1,734,884,885,-1,291,597,444,-1,47,321,320,-1,43,39,38,-1,681,41,886,-1,886,41,38,-1,35,40,39,-1,682,726,730,-1,729,705,887,-1,32,34,888,-1,889,890,164,-1,34,33,891,-1,163,306,889,-1,892,893,894,-1,860,21,861,-1,861,23,174,-1,895,19,896,-1,309,896,18,-1,14,12,897,-1,898,899,82,-1,845,8,6,-1,3,86,85,-1,5,900,86,-1,901,902,851,-1,903,904,905,-1,851,0,901,-1,86,3,5,-1,85,6,3,-1,845,6,85,-1,898,9,899,-1,80,14,897,-1,309,18,49,-1,895,896,309,-1,861,21,23,-1,860,24,21,-1,906,907,28,-1,889,164,163,-1,34,891,908,-1,909,910,911,-1,887,912,729,-1,656,682,730,-1,39,36,35,-1,38,616,886,-1,886,913,681,-1,726,682,727,-1,44,37,36,-1,47,320,319,-1,444,292,291,-1,734,59,884,-1,298,738,733,-1,914,121,883,-1,121,915,279,-1,120,276,275,-1,880,916,881,-1,56,917,844,-1,878,884,59,-1,271,918,62,-1,61,60,273,-1,735,876,287,-1,875,72,874,-1,118,919,77,-1,81,84,83,-1,83,82,845,-1,294,308,873,-1,88,91,869,-1,871,751,872,-1,869,91,101,-1,61,94,731,-1,866,98,867,-1,863,179,866,-1,94,263,102,-1,863,865,920,-1,862,54,879,-1,861,105,104,-1,106,859,107,-1,76,856,858,-1,855,921,856,-1,852,854,850,-1,848,851,852,-1,922,114,850,-1,110,849,813,-1,87,112,814,-1,847,110,113,-1,846,923,847,-1,86,900,266,-1,116,115,85,-1,857,118,76,-1,119,924,844,-1,843,925,766,-1,127,842,926,-1,128,127,840,-1,244,768,764,-1,927,140,245,-1,839,507,141,-1,146,145,761,-1,144,928,836,-1,834,185,815,-1,833,798,832,-1,209,831,210,-1,153,830,194,-1,929,267,153,-1,829,268,828,-1,826,156,930,-1,258,160,931,-1,819,833,74,-1,932,824,257,-1,819,825,166,-1,822,933,821,-1,932,934,824,-1,175,822,820,-1,819,823,208,-1,816,748,182,-1,285,928,815,-1,237,935,126,-1,763,217,936,-1,810,812,937,-1,938,784,757,-1,807,124,808,-1,939,805,200,-1,800,205,211,-1,444,446,804,-1,940,208,756,-1,803,206,801,-1,799,211,210,-1,67,876,798,-1,66,790,794,-1,789,213,941,-1,131,130,791,-1,66,942,789,-1,786,221,784,-1,218,943,944,-1,225,220,806,-1,779,945,778,-1,412,769,189,-1,777,184,235,-1,232,231,234,-1,748,286,187,-1,775,233,774,-1,771,946,772,-1,765,764,768,-1,241,767,935,-1,766,70,284,-1,135,765,246,-1,762,240,763,-1,244,760,245,-1,220,947,202,-1,169,755,247,-1,753,828,48,-1,180,156,255,-1,750,872,751,-1,748,816,226,-1,870,100,747,-1,948,949,196,-1,206,823,165,-1,97,950,867,-1,893,597,50,-1,597,291,148,-1,154,258,155,-1,929,155,180,-1,744,951,742,-1,60,918,881,-1,740,281,738,-1,260,737,258,-1,170,821,252,-1,263,94,277,-1,241,935,237,-1,70,69,736,-1,232,183,817,-1,287,295,293,-1,288,800,289,-1,734,885,299,-1,57,62,293,-1,777,781,184,-1,299,732,297,-1,299,885,732,-1,303,723,952,-1,952,297,303,-1,93,92,731,-1,16,700,598,-1,484,483,729,-1,723,317,725,-1,318,320,316,-1,300,322,321,-1,687,380,379,-1,722,721,324,-1,601,600,445,-1,447,580,324,-1,463,366,466,-1,394,331,720,-1,692,691,719,-1,651,953,717,-1,551,622,710,-1,716,590,592,-1,336,659,702,-1,714,954,607,-1,587,955,713,-1,598,344,711,-1,354,356,563,-1,707,956,708,-1,362,361,352,-1,957,649,357,-1,337,956,707,-1,705,729,483,-1,655,615,568,-1,704,367,366,-1,701,703,345,-1,701,345,334,-1,480,344,598,-1,698,374,336,-1,430,610,697,-1,331,395,611,-1,696,684,683,-1,695,683,633,-1,386,388,512,-1,634,692,720,-1,958,678,188,-1,407,409,408,-1,959,403,406,-1,409,407,667,-1,411,400,452,-1,689,366,463,-1,375,377,452,-1,379,454,680,-1,680,453,686,-1,608,427,694,-1,643,641,640,-1,455,684,676,-1,442,443,357,-1,448,960,421,-1,378,961,450,-1,675,676,684,-1,495,361,962,-1,673,963,513,-1,481,359,358,-1,188,678,397,-1,404,959,668,-1,407,964,458,-1,351,653,652,-1,664,666,555,-1,663,965,659,-1,550,474,22,-1,662,966,660,-1,658,682,656,-1,655,614,486,-1,654,486,967,-1,653,489,651,-1,353,352,492,-1,968,969,970,-1,647,971,496,-1,503,505,972,-1,644,430,645,-1,512,642,973,-1,639,974,640,-1,636,515,637,-1,633,683,455,-1,591,632,975,-1,602,522,523,-1,523,525,602,-1,540,537,527,-1,528,529,533,-1,572,628,976,-1,628,629,524,-1,625,624,977,-1,550,978,624,-1,623,584,606,-1,620,622,557,-1,313,566,557,-1,354,618,355,-1,551,606,584,-1,566,313,312,-1,614,655,568,-1,536,4,7,-1,574,573,11,-1,612,629,572,-1,13,15,613,-1,629,575,524,-1,576,594,602,-1,485,579,498,-1,610,609,697,-1,609,424,423,-1,583,685,608,-1,447,451,581,-1,325,565,607,-1,623,606,589,-1,603,713,604,-1,602,594,341,-1,599,601,433,-1,371,647,598,-1,596,445,444,-1,595,712,327,-1,328,341,594,-1,590,631,591,-1,589,553,520,-1,326,325,586,-1,585,607,565,-1,426,979,427,-1,426,980,979,-1,582,609,423,-1,432,329,580,-1,578,981,579,-1,525,524,576,-1,526,11,573,-1,570,981,569,-1,568,615,567,-1,560,365,364,-1,311,567,363,-1,314,584,565,-1,35,982,563,-1,355,618,561,-1,561,664,555,-1,314,557,622,-1,554,556,560,-1,551,553,606,-1,549,978,550,-1,524,548,545,-1,547,628,545,-1,544,983,543,-1,1,907,542,-1,540,984,541,-1,539,542,534,-1,536,527,537,-1,532,533,530,-1,4,536,529,-1,7,571,526,-1,522,602,520,-1,517,985,514,-1,517,519,456,-1,514,637,515,-1,513,642,512,-1,385,384,510,-1,986,382,987,-1,509,988,507,-1,505,387,972,-1,504,470,502,-1,469,669,500,-1,498,431,499,-1,496,434,646,-1,492,495,493,-1,494,349,492,-1,490,491,711,-1,487,489,653,-1,337,717,486,-1,485,499,471,-1,476,475,483,-1,471,359,481,-1,479,480,700,-1,473,698,335,-1,472,474,550,-1,663,374,373,-1,442,471,989,-1,964,690,403,-1,367,667,458,-1,466,405,469,-1,412,396,467,-1,538,535,537,-1,462,990,460,-1,417,380,687,-1,455,991,456,-1,448,420,451,-1,450,960,449,-1,447,992,435,-1,445,993,446,-1,442,994,376,-1,441,957,357,-1,435,992,433,-1,610,430,432,-1,428,424,995,-1,427,685,425,-1,424,429,425,-1,417,687,418,-1,963,636,513,-1,375,454,379,-1,414,783,415,-1,704,689,996,-1,463,465,688,-1,465,997,688,-1,396,412,397,-1,409,667,410,-1,406,690,407,-1,402,404,405,-1,403,959,404,-1,399,998,400,-1,391,719,392,-1,390,333,332,-1,387,673,388,-1,384,382,381,-1,378,999,379,-1,374,698,372,-1,369,371,491,-1,350,703,653,-1,368,405,366,-1,363,1000,364,-1,630,906,1001,-1,357,649,358,-1,535,533,529,-1,647,596,597,-1,706,352,337,-1,353,349,351,-1,347,674,348,-1,607,954,586,-1,341,1002,342,-1,339,956,337,-1,336,701,334,-1,622,551,314,-1,719,691,392,-1,331,611,332,-1,690,964,407,-1,580,329,324,-1,447,721,992,-1,328,593,323,-1,324,330,325,-1,410,667,996,-1,318,301,320,-1,316,320,321,-1,315,312,313,-1,250,309,269,-1,92,294,731,-1,307,257,305,-1,304,724,303,-1,297,46,45,-1,45,319,301,-1,46,732,300,-1,221,220,757,-1,295,289,58,-1,878,290,292,-1,287,289,295,-1,226,778,285,-1,736,282,284,-1,241,237,236,-1,279,281,883,-1,278,157,931,-1,277,862,264,-1,276,272,274,-1,251,168,170,-1,230,1003,190,-1,60,881,272,-1,59,51,270,-1,269,828,268,-1,181,155,258,-1,267,741,248,-1,97,1004,950,-1,261,167,260,-1,196,949,154,-1,801,206,745,-1,259,261,260,-1,257,307,29,-1,89,88,256,-1,251,253,255,-1,248,250,269,-1,265,1005,176,-1,247,821,170,-1,136,135,246,-1,242,244,140,-1,1006,243,198,-1,212,123,125,-1,242,140,139,-1,240,762,239,-1,238,283,236,-1,958,188,1003,-1,235,183,234,-1,233,775,231,-1,235,184,183,-1,776,223,773,-1,190,770,229,-1,778,226,228,-1,806,223,225,-1,786,222,215,-1,214,806,220,-1,218,944,129,-1,213,793,65,-1,125,199,198,-1,209,211,805,-1,208,823,206,-1,214,216,806,-1,203,205,787,-1,200,202,1007,-1,1008,1003,193,-1,197,675,198,-1,1009,811,810,-1,166,165,823,-1,190,1003,188,-1,186,775,187,-1,182,817,183,-1,181,157,156,-1,179,863,177,-1,168,1010,176,-1,105,861,174,-1,171,1011,172,-1,165,167,262,-1,162,1012,163,-1,89,160,161,-1,159,1013,160,-1,158,930,156,-1,929,153,155,-1,1014,1015,745,-1,148,831,149,-1,144,837,145,-1,141,143,839,-1,927,138,140,-1,137,758,135,-1,134,1016,943,-1,129,944,130,-1,126,841,127,-1,840,843,238,-1,123,808,124,-1,120,882,121,-1,118,857,119,-1,814,114,116,-1,847,111,110,-1,110,813,112,-1,75,81,109,-1,108,856,76,-1,1017,858,106,-1,103,1018,106,-1,105,820,103,-1,95,273,55,-1,101,102,1019,-1,101,1019,99,-1,1020,1004,97,-1,97,867,98,-1,54,277,94,-1,93,101,91,-1,256,869,872,-1,90,873,88,-1,87,116,85,-1,82,84,898,-1,78,84,81,-1,897,78,80,-1,74,832,72,-1,67,246,68,-1,68,942,66,-1,63,65,793,-1,60,62,918,-1,59,271,57,-1,54,56,879,-1,52,1021,53,-1,50,148,48,-1,47,319,45,-1,43,38,41,-1,619,982,37,-1,38,40,616,-1,37,982,35,-1,162,164,1022,-1,32,1023,33,-1,1020,1024,911,-1,29,307,30,-1,893,50,894,-1,24,549,25,-1,21,25,22,-1,19,16,896,-1,896,16,18,-1,14,13,12,-1,12,10,9,-1,9,11,899,-1,8,571,7,-1,7,4,3,-1,4,528,5,-1,2,901,0,-1,1025,904,903,-1,1,28,907,-1,28,1,0,-1,1026,1027,1028,-1,1027,1026,1029,-1,1030,1031,1032,-1,1030,1033,1031,-1,1001,1034,531,-1,1034,1001,1035,-1,528,1036,5,-1,528,532,1036,-1,1025,14,904,-1,1025,15,14,-1,20,23,22,-1,23,20,19,-1,163,307,306,-1,307,163,30,-1,750,34,908,-1,888,34,750,-1,1037,1024,1038,-1,1037,911,1024,-1,32,910,909,-1,32,888,910,-1,1039,887,705,-1,1040,887,1039,-1,681,727,682,-1,913,727,681,-1,725,1041,723,-1,903,725,1042,-1,903,1041,725,-1,150,744,743,-1,150,1043,744,-1,799,878,296,-1,878,799,290,-1,117,738,298,-1,117,739,738,-1,882,915,121,-1,882,274,915,-1,882,275,274,-1,915,916,880,-1,274,916,915,-1,287,1044,288,-1,1044,287,877,-1,1045,1046,1047,-1,1046,1045,1048,-1,905,1049,903,-1,905,1050,1049,-1,872,908,256,-1,872,750,908,-1,869,870,872,-1,870,869,100,-1,751,950,1004,-1,751,871,950,-1,96,1020,97,-1,96,1024,1020,-1,265,102,263,-1,265,1051,102,-1,1052,920,865,-1,920,1052,1053,-1,104,1054,860,-1,1054,104,1055,-1,1056,107,859,-1,107,1056,1055,-1,1017,924,119,-1,1057,924,1017,-1,858,921,859,-1,858,856,921,-1,1058,902,1059,-1,902,1058,853,-1,851,853,852,-1,851,902,853,-1,114,813,849,-1,114,814,813,-1,266,846,113,-1,900,846,266,-1,114,83,115,-1,114,922,83,-1,242,768,244,-1,242,236,768,-1,926,809,127,-1,807,809,926,-1,792,1060,1061,-1,792,1062,1060,-1,146,767,1063,-1,146,838,767,-1,142,239,1064,-1,239,142,1065,-1,145,1066,1067,-1,145,837,1066,-1,186,759,1068,-1,186,1069,759,-1,928,835,815,-1,835,928,144,-1,879,924,862,-1,879,844,924,-1,939,1007,1070,-1,200,1007,939,-1,1071,1072,951,-1,1071,1073,1072,-1,1074,811,1075,-1,1074,1015,811,-1,829,267,268,-1,267,829,830,-1,1076,260,167,-1,1076,737,260,-1,1077,162,1023,-1,1077,1012,162,-1,833,818,137,-1,833,819,818,-1,1078,309,250,-1,309,1078,895,-1,1079,178,177,-1,934,178,1079,-1,755,822,247,-1,755,820,822,-1,231,1068,1080,-1,775,1068,231,-1,1068,775,186,-1,928,1081,836,-1,1081,928,285,-1,1082,468,1083,-1,468,1082,1084,-1,1085,1081,945,-1,1081,1085,1086,-1,1087,191,1088,-1,191,1087,192,-1,1089,1090,1091,-1,1090,1089,1092,-1,771,1093,946,-1,1093,771,1094,-1,936,126,935,-1,936,217,126,-1,785,222,786,-1,1095,222,785,-1,1096,1097,1098,-1,1096,1099,1097,-1,1100,1101,1102,-1,1101,1100,1095,-1,1098,785,784,-1,1098,1097,785,-1,296,800,799,-1,296,289,800,-1,296,58,289,-1,804,878,292,-1,878,804,884,-1,1103,801,1074,-1,1103,802,801,-1,832,293,72,-1,735,293,832,-1,877,67,66,-1,67,877,876,-1,278,1104,890,-1,278,1013,1104,-1,941,790,789,-1,790,941,795,-1,1105,807,926,-1,1105,1106,807,-1,1107,130,1016,-1,130,1107,791,-1,793,942,63,-1,793,789,942,-1,1108,228,227,-1,228,1108,1088,-1,779,1085,945,-1,1085,779,1109,-1,782,1110,1094,-1,782,414,1110,-1,1093,1090,1092,-1,1090,1093,1111,-1,771,223,216,-1,771,773,223,-1,1112,1113,1114,-1,1112,1115,1113,-1,1116,769,1084,-1,769,1116,770,-1,1117,1112,1114,-1,1112,1117,1118,-1,761,936,838,-1,761,763,936,-1,765,69,246,-1,765,736,69,-1,940,818,208,-1,940,1080,818,-1,1007,947,803,-1,1007,202,947,-1,1119,755,754,-1,1119,1018,755,-1,257,172,932,-1,257,173,172,-1,868,870,747,-1,871,870,868,-1,195,948,196,-1,1120,948,195,-1,949,259,154,-1,937,259,949,-1,1121,742,1122,-1,1121,743,742,-1,48,147,752,-1,148,147,48,-1,738,280,733,-1,738,281,280,-1,122,739,917,-1,122,740,739,-1,252,248,253,-1,249,248,252,-1,1048,1123,1124,-1,1048,1125,1123,-1,71,64,63,-1,71,70,64,-1,595,322,993,-1,322,595,323,-1,570,565,325,-1,570,315,565,-1,634,333,390,-1,720,333,634,-1,692,394,720,-1,511,394,692,-1,1126,1127,1045,-1,1126,1128,1127,-1,975,342,1129,-1,975,632,342,-1,578,569,981,-1,614,569,578,-1,623,714,585,-1,714,623,590,-1,588,631,589,-1,588,632,631,-1,603,328,327,-1,1130,328,603,-1,1131,1132,1133,-1,1131,1134,1132,-1,349,343,350,-1,494,343,349,-1,597,892,647,-1,597,893,892,-1,649,1135,650,-1,1135,649,957,-1,660,705,661,-1,1039,705,660,-1,654,616,615,-1,654,886,616,-1,564,40,35,-1,40,564,1136,-1,912,657,656,-1,887,657,912,-1,648,707,709,-1,648,460,707,-1,684,1137,675,-1,696,1137,684,-1,392,506,393,-1,506,392,1138,-1,697,510,645,-1,510,697,395,-1,1118,988,1139,-1,1118,507,988,-1,1140,410,996,-1,1140,401,410,-1,1141,1142,715,-1,1143,1142,1141,-1,704,667,367,-1,996,667,704,-1,687,686,418,-1,680,686,687,-1,640,1115,1144,-1,1115,640,974,-1,997,1145,688,-1,997,670,1145,-1,643,1144,642,-1,643,640,1144,-1,985,1146,514,-1,985,1147,1146,-1,979,696,695,-1,979,1148,696,-1,1149,1150,1151,-1,1149,1152,1150,-1,579,570,330,-1,570,579,981,-1,1153,1154,1155,-1,1153,1151,1154,-1,1156,1154,1157,-1,1158,1154,1156,-1,1159,673,1138,-1,963,673,1159,-1,1160,691,518,-1,392,691,1160,-1,401,411,410,-1,400,411,401,-1,1091,1161,1162,-1,1091,1163,1161,-1,1164,1165,1161,-1,1164,672,1165,-1,677,672,671,-1,1165,672,677,-1,1166,1167,1168,-1,1169,1167,1166,-1,458,403,402,-1,403,458,964,-1,664,662,665,-1,966,662,664,-1,965,1170,659,-1,1171,1170,965,-1,475,665,662,-1,475,477,665,-1,1170,702,659,-1,1170,487,702,-1,487,703,702,-1,487,653,703,-1,657,1040,1172,-1,1040,657,887,-1,681,42,41,-1,658,42,681,-1,968,490,969,-1,968,369,490,-1,440,437,441,-1,440,679,437,-1,1173,1174,1175,-1,1173,1135,1174,-1,1176,436,438,-1,1176,1177,436,-1,596,646,601,-1,596,647,646,-1,986,500,1178,-1,986,1179,500,-1,1180,1181,1182,-1,1183,1181,1180,-1,1184,988,1185,-1,1184,1139,988,-1,1186,391,393,-1,391,1186,1179,-1,1144,973,642,-1,1187,973,1144,-1,641,1062,639,-1,1062,641,1188,-1,1189,1190,1147,-1,1191,1190,1189,-1,1192,457,635,-1,633,457,1192,-1,628,544,976,-1,628,547,544,-1,1193,1194,1195,-1,1193,546,1194,-1,548,522,627,-1,522,548,523,-1,1033,1196,1031,-1,1033,1195,1196,-1,624,1196,977,-1,624,978,1196,-1,620,1171,965,-1,558,1171,620,-1,618,660,966,-1,617,660,618,-1,15,1197,613,-1,15,1025,1197,-1,594,1197,1042,-1,594,576,1197,-1,609,611,697,-1,609,582,611,-1,696,1047,1137,-1,696,1148,1047,-1,1198,1155,1199,-1,1155,1198,1153,-1,1200,713,955,-1,1200,604,713,-1,1201,955,954,-1,1201,1200,955,-1,605,1130,603,-1,605,1202,1130,-1,443,440,357,-1,999,440,443,-1,1131,968,1134,-1,968,1131,1203,-1,300,993,322,-1,300,446,993,-1,1204,591,975,-1,716,591,1204,-1,716,592,591,-1,1201,1204,1200,-1,1201,716,1204,-1,587,722,326,-1,587,712,722,-1,1148,1045,1047,-1,1148,1126,1045,-1,1042,1025,903,-1,1197,1025,1042,-1,576,613,1197,-1,576,575,613,-1,561,364,562,-1,561,554,364,-1,561,966,664,-1,618,966,561,-1,621,965,663,-1,620,965,621,-1,699,373,1205,-1,373,699,663,-1,710,699,1206,-1,710,621,699,-1,1026,1195,1033,-1,1026,1193,1195,-1,546,1207,547,-1,1193,1207,546,-1,976,541,984,-1,544,541,976,-1,541,542,539,-1,541,543,542,-1,542,630,534,-1,906,542,907,-1,542,906,630,-1,573,540,526,-1,984,540,573,-1,1146,1190,1060,-1,1146,1147,1190,-1,518,516,1160,-1,516,518,517,-1,1188,1060,1062,-1,1188,1146,1060,-1,393,505,1186,-1,506,505,393,-1,693,1185,1182,-1,693,1184,1185,-1,1185,509,1208,-1,1185,988,509,-1,1179,501,500,-1,1179,1186,501,-1,1209,503,1183,-1,504,503,1209,-1,1178,669,668,-1,1178,500,669,-1,1176,971,1210,-1,971,1176,496,-1,1174,1177,1175,-1,1174,436,1177,-1,348,1175,1132,-1,348,1173,1175,-1,493,969,490,-1,493,495,969,-1,953,486,717,-1,967,486,953,-1,482,577,485,-1,482,1211,577,-1,728,476,484,-1,728,1212,476,-1,989,499,644,-1,499,989,471,-1,16,479,700,-1,16,20,479,-1,665,1213,666,-1,665,477,1213,-1,473,372,698,-1,372,473,472,-1,1214,406,1215,-1,1214,959,406,-1,1214,668,959,-1,464,470,504,-1,464,466,470,-1,468,1216,1083,-1,468,467,1216,-1,464,1143,465,-1,464,1217,1143,-1,670,1164,1145,-1,670,672,1164,-1,1090,1163,1091,-1,1090,1218,1163,-1,1219,998,399,-1,1219,1220,998,-1,1160,1138,392,-1,1159,1138,1160,-1,1158,1102,1221,-1,1158,1156,1102,-1,1158,1155,1154,-1,1222,1155,1158,-1,421,459,1152,-1,961,459,421,-1,960,435,449,-1,435,960,448,-1,441,436,1174,-1,436,441,437,-1,330,498,579,-1,330,329,498,-1,610,581,424,-1,610,432,581,-1,429,426,425,-1,429,1198,426,-1,991,1147,985,-1,1147,991,1189,-1,961,380,459,-1,380,961,378,-1,451,422,995,-1,451,420,422,-1,670,1141,671,-1,997,1141,670,-1,377,994,408,-1,994,377,376,-1,418,416,415,-1,418,686,416,-1,715,398,397,-1,1142,398,715,-1,1110,413,1220,-1,414,413,1110,-1,1090,1219,1218,-1,1090,1111,1219,-1,452,998,453,-1,998,452,400,-1,1144,1112,1187,-1,1115,1112,1144,-1,396,1167,467,-1,396,398,1167,-1,391,718,719,-1,987,718,391,-1,512,1184,693,-1,512,973,1184,-1,389,1192,390,-1,389,608,1192,-1,381,510,384,-1,645,510,381,-1,376,999,443,-1,376,379,999,-1,375,379,376,-1,460,650,461,-1,648,650,460,-1,662,483,475,-1,483,662,661,-1,1000,562,364,-1,1000,1223,562,-1,360,962,361,-1,360,347,962,-1,674,360,462,-1,347,360,674,-1,1203,1133,1210,-1,1203,1131,1133,-1,955,586,954,-1,587,586,955,-1,713,327,712,-1,713,603,327,-1,614,339,338,-1,614,578,339,-1,1199,1126,980,-1,1126,1199,1128,-1,389,582,583,-1,332,582,389,-1,732,884,804,-1,732,885,884,-1,61,294,62,-1,294,61,731,-1,284,238,766,-1,284,283,238,-1,282,236,283,-1,282,768,236,-1,1127,1048,1045,-1,1048,1127,1125,-1,740,121,914,-1,122,121,740,-1,873,875,874,-1,873,90,875,-1,272,55,273,-1,272,276,55,-1,120,917,56,-1,917,120,122,-1,733,52,734,-1,733,280,52,-1,1122,1120,1121,-1,1120,1122,1009,-1,741,929,180,-1,741,267,929,-1,151,1120,195,-1,1121,1120,151,-1,937,261,259,-1,937,812,261,-1,867,871,868,-1,871,867,950,-1,911,1077,909,-1,1037,1077,911,-1,1012,30,163,-1,1012,31,30,-1,261,1014,262,-1,812,1014,261,-1,1137,198,675,-1,1137,1006,198,-1,838,935,767,-1,838,936,935,-1,141,1118,1117,-1,1118,141,507,-1,777,1224,781,-1,1224,777,772,-1,229,1109,230,-1,229,1085,1109,-1,1115,1107,1113,-1,1115,974,1107,-1,1088,779,228,-1,779,1088,191,-1,1113,1016,134,-1,1016,1113,1107,-1,1106,124,807,-1,124,1106,199,-1,798,137,136,-1,137,798,833,-1,209,939,1225,-1,209,805,939,-1,288,787,205,-1,787,288,1044,-1,1099,796,1226,-1,796,1099,1096,-1,1099,1101,1097,-1,1099,1227,1101,-1,776,772,777,-1,776,773,772,-1,1228,1091,1162,-1,1091,1228,1089,-1,1229,1087,1228,-1,192,1087,1229,-1,192,1008,193,-1,192,1229,1008,-1,285,945,1081,-1,285,778,945,-1,1084,412,468,-1,769,412,1084,-1,836,1086,1230,-1,1086,836,1081,-1,177,920,1231,-1,177,863,920,-1,1079,930,1232,-1,1079,826,930,-1,826,177,1231,-1,1079,177,826,-1,175,895,1078,-1,174,895,175,-1,255,827,254,-1,827,255,156,-1,1037,1012,1077,-1,1037,31,1012,-1,1013,891,1104,-1,1013,159,891,-1,829,150,152,-1,753,150,829,-1,1070,803,802,-1,1007,803,1070,-1,1103,1075,1233,-1,1075,1103,1074,-1,1234,1073,1225,-1,1072,1073,1234,-1,831,291,290,-1,148,291,831,-1,834,927,1069,-1,927,834,138,-1,1235,1067,1066,-1,1067,1235,1064,-1,141,1065,142,-1,1117,1065,141,-1,139,1063,767,-1,139,138,1063,-1,132,943,240,-1,943,132,134,-1,1016,944,943,-1,1016,130,944,-1,131,841,129,-1,131,842,841,-1,1190,1106,1105,-1,1190,1191,1106,-1,1106,197,199,-1,1106,1191,197,-1,746,847,923,-1,746,111,847,-1,81,922,109,-1,922,81,83,-1,1059,1236,1058,-1,1059,1237,1236,-1,862,1057,264,-1,862,924,1057,-1,1055,1238,1054,-1,1056,1238,1055,-1,1055,103,107,-1,103,1055,104,-1,1053,1051,1010,-1,1053,1052,1051,-1,1019,865,99,-1,865,1019,1052,-1,171,98,1011,-1,171,96,98,-1,864,99,865,-1,864,747,99,-1,78,898,84,-1,898,78,897,-1,78,77,79,-1,78,75,77,-1,798,735,832,-1,798,876,735,-1,63,68,71,-1,68,63,942,-1,1047,1006,1137,-1,1006,1047,1046,-1,1226,795,1123,-1,1226,796,795,-1,880,279,915,-1,53,279,880,-1,53,1021,279,-1,280,1021,52,-1,279,1021,280,-1,803,207,206,-1,803,947,207,-1,913,953,727,-1,953,913,967,-1,619,1040,1039,-1,619,37,1040,-1,890,1022,164,-1,1022,890,1104,-1,860,1032,24,-1,1054,1032,860,-1,18,50,49,-1,18,894,50,-1,898,12,9,-1,897,12,898,-1,1036,900,5,-1,900,1036,846,-1,1034,746,923,-1,1034,1035,746,-1,1054,1030,1032,-1,1238,1030,1054,-1,1027,1237,1059,-1,1027,1029,1237,-1,28,851,26,-1,28,0,851,-1,901,1059,902,-1,901,1027,1059,-1,1029,1238,1237,-1,1029,1030,1238,-1,27,1035,28,-1,746,1035,27,-1,923,1036,1034,-1,846,1036,923,-1,82,8,845,-1,82,899,8,-1,14,905,904,-1,905,14,80,-1,23,895,174,-1,23,19,895,-1,749,888,750,-1,910,888,749,-1,31,1038,29,-1,1038,31,1037,-1,1023,1022,33,-1,1023,162,1022,-1,1041,952,723,-1,952,903,1049,-1,1041,903,952,-1,753,1043,150,-1,753,752,1043,-1,51,880,270,-1,880,51,53,-1,1239,1125,1127,-1,1239,1240,1125,-1,1241,941,213,-1,1124,941,1241,-1,69,68,246,-1,68,69,71,-1,1050,298,1049,-1,919,298,1050,-1,1050,80,79,-1,80,1050,905,-1,749,1004,1020,-1,751,1004,749,-1,96,1038,1024,-1,171,1038,96,-1,1052,102,1051,-1,102,1052,1019,-1,1018,820,755,-1,103,820,1018,-1,1119,1057,1017,-1,1005,1057,1119,-1,119,858,1017,-1,119,857,858,-1,859,1236,1056,-1,921,1236,859,-1,854,108,109,-1,108,854,855,-1,808,925,843,-1,808,123,925,-1,238,128,840,-1,128,238,237,-1,1062,791,639,-1,1062,792,791,-1,133,1113,134,-1,133,1114,1113,-1,1067,761,145,-1,1067,762,761,-1,1082,143,1242,-1,143,1082,839,-1,144,1063,835,-1,1063,144,146,-1,1066,1243,1235,-1,1066,1230,1243,-1,149,1225,1073,-1,209,1225,149,-1,1072,742,951,-1,1072,1233,742,-1,1009,1075,811,-1,1009,1122,1075,-1,151,194,152,-1,194,151,195,-1,167,825,1076,-1,167,166,825,-1,1076,875,737,-1,1076,73,875,-1,158,1232,930,-1,158,1244,1232,-1,933,250,249,-1,933,1078,250,-1,254,1245,168,-1,827,1245,254,-1,178,932,172,-1,932,178,934,-1,1245,1010,168,-1,1245,1053,1010,-1,172,179,178,-1,172,1011,179,-1,233,182,774,-1,233,817,182,-1,1116,1243,1246,-1,1116,1242,1243,-1,229,1086,1085,-1,1086,229,1246,-1,1003,1247,958,-1,1008,1247,1003,-1,1008,1248,1247,-1,1248,1008,1229,-1,1249,1088,1108,-1,1249,1087,1088,-1,1250,1089,1249,-1,1250,1092,1089,-1,1094,1111,1093,-1,1111,1094,1110,-1,1095,783,222,-1,1100,783,1095,-1,1251,788,1252,-1,788,1251,203,-1,1097,1095,785,-1,1097,1101,1095,-1,1221,1240,1239,-1,1240,1221,1227,-1,201,204,203,-1,201,200,204,-1,1225,1070,1234,-1,1070,1225,939,-1,294,72,293,-1,294,874,72,-1,1098,1252,1096,-1,1251,1252,1098,-1,1006,1241,243,-1,1241,1006,1046,-1,1061,926,842,-1,926,1061,1105,-1,243,213,212,-1,243,1241,213,-1,797,877,66,-1,1044,877,797,-1,781,1108,227,-1,781,1224,1108,-1,215,221,786,-1,215,214,221,-1,184,780,816,-1,780,184,781,-1,219,771,216,-1,219,1094,771,-1,219,782,1094,-1,1092,946,1093,-1,1092,1250,946,-1,143,1064,1235,-1,1064,143,142,-1,1242,1084,1082,-1,1084,1242,1116,-1,1114,1065,1117,-1,1114,133,1065,-1,925,212,65,-1,925,123,212,-1,759,927,245,-1,927,759,1069,-1,1080,137,818,-1,1080,1068,137,-1,745,262,1014,-1,745,165,262,-1,106,1119,1017,-1,106,1018,1119,-1,908,159,256,-1,159,908,891,-1,29,171,173,-1,29,1038,171,-1,1074,745,1015,-1,1074,801,745,-1,810,949,948,-1,949,810,937,-1,1071,752,147,-1,1043,752,1071,-1,276,56,55,-1,120,56,276,-1,821,249,252,-1,933,249,821,-1,157,258,931,-1,258,157,181,-1,1124,795,941,-1,1124,1123,795,-1,889,305,1244,-1,889,306,305,-1,310,315,570,-1,310,312,315,-1,728,953,651,-1,727,953,728,-1,1042,316,594,-1,1042,725,316,-1,601,434,433,-1,434,601,646,-1,381,1214,644,-1,383,1214,381,-1,1130,1253,1002,-1,1130,1202,1253,-1,344,334,345,-1,344,480,334,-1,340,632,588,-1,342,632,340,-1,1130,341,328,-1,1002,341,1130,-1,971,371,370,-1,971,647,371,-1,1132,346,348,-1,1134,346,1132,-1,706,362,352,-1,706,990,362,-1,494,344,343,-1,494,711,344,-1,970,1134,968,-1,346,1134,970,-1,42,44,43,-1,42,1172,44,-1,372,1205,373,-1,1205,372,626,-1,999,679,440,-1,378,679,999,-1,989,994,442,-1,1215,994,989,-1,987,385,718,-1,385,987,382,-1,1138,387,506,-1,387,1138,673,-1,1112,1139,1187,-1,1112,1118,1139,-1,408,1215,406,-1,994,1215,408,-1,1169,1180,1208,-1,1166,1180,1169,-1,1254,401,1140,-1,1254,399,401,-1,1143,997,465,-1,1143,1141,997,-1,377,411,452,-1,409,411,377,-1,515,963,1159,-1,963,515,636,-1,688,1255,689,-1,688,1145,1255,-1,423,685,583,-1,685,423,425,-1,1146,637,514,-1,637,1146,1188,-1,1152,417,1150,-1,1152,459,417,-1,1151,428,1149,-1,428,1151,1153,-1,1149,995,422,-1,1149,428,995,-1,311,569,568,-1,310,569,311,-1,449,434,497,-1,434,449,435,-1,957,1174,1135,-1,441,1174,957,-1,600,993,445,-1,600,595,993,-1,992,599,433,-1,721,599,992,-1,722,599,721,-1,419,1150,417,-1,1157,1150,419,-1,1156,1100,1102,-1,1156,1256,1100,-1,1157,1151,1150,-1,1154,1151,1157,-1,415,419,418,-1,415,1256,419,-1,1257,1140,1255,-1,1140,1257,1254,-1,1161,1257,1164,-1,1161,1163,1257,-1,1248,1161,1165,-1,1162,1161,1248,-1,671,715,678,-1,1141,715,671,-1,398,1168,1167,-1,1142,1168,398,-1,1168,1209,1166,-1,1168,1217,1209,-1,404,469,405,-1,669,469,404,-1,1171,1258,1170,-1,556,1258,1171,-1,477,1212,1213,-1,477,476,1212,-1,487,1258,488,-1,1258,487,1170,-1,473,479,474,-1,473,478,479,-1,343,703,350,-1,343,345,703,-1,708,358,709,-1,481,358,708,-1,658,1172,42,-1,657,1172,658,-1,956,1211,708,-1,1211,956,339,-1,494,490,711,-1,494,493,490,-1,461,1135,1173,-1,650,1135,461,-1,1177,1210,1133,-1,1210,1177,1176,-1,679,439,437,-1,679,450,439,-1,521,553,552,-1,553,521,520,-1,501,470,469,-1,501,502,470,-1,383,668,1214,-1,668,383,1178,-1,1183,972,1181,-1,503,972,1183,-1,1083,509,508,-1,1216,509,1083,-1,386,1182,1181,-1,693,1182,386,-1,1179,987,391,-1,1179,986,987,-1,516,1159,1160,-1,516,515,1159,-1,456,985,517,-1,456,991,985,-1,511,718,385,-1,718,511,692,-1,983,547,1207,-1,544,547,983,-1,533,538,534,-1,538,533,535,-1,538,540,539,-1,540,538,537,-1,983,1,543,-1,2,1,983,-1,2,1207,1028,-1,2,983,1207,-1,546,548,1194,-1,545,548,546,-1,521,627,522,-1,521,1206,627,-1,977,1195,1194,-1,977,1196,1195,-1,1031,978,549,-1,1031,1196,978,-1,556,558,560,-1,556,1171,558,-1,365,566,363,-1,559,566,365,-1,354,982,619,-1,354,563,982,-1,356,564,563,-1,1223,564,356,-1,1000,567,1136,-1,1000,363,567,-1,615,1136,567,-1,40,1136,615,-1,980,1148,979,-1,980,1126,1148,-1,1199,1222,1128,-1,1155,1222,1199,-1,340,520,602,-1,588,520,340,-1,716,954,714,-1,1201,954,716,-1,1002,1129,342,-1,1253,1129,1002,-1,647,17,598,-1,647,892,17,-1,635,456,519,-1,635,457,456,-1,1203,369,968,-1,369,1203,370,-1,1204,1253,1202,-1,1204,1129,1253,-1,1204,975,1129,-1,1202,1200,1204,-1,1202,604,1200,-1,1202,605,604,-1,595,599,712,-1,595,600,599,-1,1128,1239,1127,-1,1222,1239,1128,-1,329,431,498,-1,431,329,432,-1,575,612,613,-1,612,575,629,-1,10,612,574,-1,10,13,612,-1,1223,1136,564,-1,1223,1000,1136,-1,1039,617,619,-1,1039,660,617,-1,557,558,620,-1,557,559,558,-1,472,626,372,-1,472,624,626,-1,1206,1205,627,-1,1206,699,1205,-1,625,1194,548,-1,625,977,1194,-1,1206,552,710,-1,552,1206,521,-1,1193,1028,1207,-1,1026,1028,1193,-1,984,572,976,-1,984,573,572,-1,530,1001,531,-1,630,1001,530,-1,197,1189,676,-1,1191,1189,197,-1,390,635,634,-1,1192,635,390,-1,634,518,691,-1,519,518,634,-1,636,643,513,-1,638,643,636,-1,387,1181,972,-1,386,1181,387,-1,1208,1216,1169,-1,1208,509,1216,-1,1186,502,501,-1,1186,505,502,-1,1166,1183,1180,-1,1209,1183,1166,-1,438,496,1176,-1,438,497,496,-1,1132,1177,1133,-1,1177,1132,1175,-1,1173,674,461,-1,674,1173,348,-1,495,970,969,-1,495,962,970,-1,482,708,1211,-1,708,482,481,-1,578,1211,339,-1,577,1211,578,-1,1212,651,489,-1,651,1212,728,-1,20,474,479,-1,20,22,474,-1,666,488,1258,-1,666,1213,488,-1,489,1213,1212,-1,1213,489,488,-1,556,666,1258,-1,555,666,556,-1,1217,504,1209,-1,1217,464,504,-1,1217,1142,1143,-1,1217,1168,1142,-1,1247,678,958,-1,1247,677,678,-1,1248,677,1247,-1,1248,1165,677,-1,1145,1257,1255,-1,1164,1257,1145,-1,1163,1254,1257,-1,1254,1163,1218,-1,1111,1220,1219,-1,1111,1110,1220,-1,783,1256,415,-1,783,1100,1256,-1,422,1152,1149,-1,422,421,1152,-1,1256,1157,419,-1,1156,1157,1256,-1,1222,1221,1239,-1,1222,1158,1221,-1,960,961,421,-1,450,961,960,-1,439,497,438,-1,497,439,449,-1,644,431,430,-1,644,499,431,-1,428,1198,429,-1,428,1153,1198,-1,455,1189,991,-1,455,676,1189,-1,1188,638,637,-1,638,1188,641,-1,427,695,694,-1,979,695,427,-1,581,995,424,-1,581,451,995,-1,1255,996,689,-1,996,1255,1140,-1,998,416,453,-1,1220,416,998,-1,413,416,1220,-1,399,1218,1219,-1,1254,1218,399,-1,1182,1208,1180,-1,1182,1185,1208,-1,467,1169,1216,-1,467,1167,1169,-1,395,511,510,-1,395,394,511,-1,1184,1187,1139,-1,973,1187,1184,-1,694,1192,608,-1,633,1192,694,-1,986,383,382,-1,986,1178,383,-1,644,1215,989,-1,1214,1215,644,-1,709,649,648,-1,358,649,709,-1,1205,625,627,-1,625,1205,626,-1,1172,37,44,-1,1172,1040,37,-1,1223,355,562,-1,1223,356,355,-1,707,990,706,-1,460,990,707,-1,347,970,962,-1,347,346,970,-1,362,462,360,-1,362,990,462,-1,370,1210,971,-1,370,1203,1210,-1,589,590,623,-1,589,631,590,-1,480,335,334,-1,480,478,335,-1,337,652,717,-1,337,351,652,-1,1198,980,426,-1,980,1198,1199,-1,323,316,321,-1,323,593,316,-1,724,301,317,-1,724,304,301,-1,484,726,728,-1,730,726,484,-1,278,1244,158,-1,890,1244,278,-1,890,889,1244,-1,297,1049,298,-1,297,952,1049,-1,210,290,799,-1,210,831,290,-1,1068,758,137,-1,1068,759,758,-1,737,90,161,-1,90,737,875,-1,734,51,59,-1,52,51,734,-1,918,270,881,-1,918,271,270,-1,951,1043,1071,-1,744,1043,951,-1,948,1009,810,-1,948,1120,1009,-1,743,151,150,-1,743,1121,151,-1,909,1023,32,-1,1077,1023,909,-1,226,780,227,-1,780,226,816,-1,1015,812,811,-1,1015,1014,812,-1,947,756,207,-1,220,756,947,-1,220,225,756,-1,764,758,760,-1,764,135,758,-1,925,64,766,-1,65,64,925,-1,1065,132,239,-1,133,132,1065,-1,1080,234,231,-1,1080,940,234,-1,1235,1242,143,-1,1235,1243,1242,-1,772,1250,1224,-1,1250,772,946,-1,776,224,223,-1,776,235,224,-1,940,224,234,-1,940,756,224,-1,1109,191,193,-1,1109,779,191,-1,788,1044,797,-1,787,1044,788,-1,757,201,938,-1,757,202,201,-1,1061,131,792,-1,842,131,1061,-1,784,1251,1098,-1,938,1251,784,-1,794,1096,1252,-1,794,796,1096,-1,797,1252,788,-1,794,1252,797,-1,873,91,88,-1,873,308,91,-1,1234,802,1103,-1,1234,1070,802,-1,211,204,805,-1,211,205,204,-1,938,203,1251,-1,938,201,203,-1,1226,1227,1099,-1,1226,1240,1227,-1,1102,1227,1221,-1,1227,1102,1101,-1,240,218,763,-1,240,943,218,-1,1224,1249,1108,-1,1224,1250,1249,-1,1249,1228,1087,-1,1228,1249,1089,-1,1228,1248,1229,-1,1228,1162,1248,-1,230,193,1003,-1,230,1109,193,-1,1246,770,1116,-1,1246,229,770,-1,1230,1246,1243,-1,1246,1230,1086,-1,815,187,286,-1,815,185,187,-1,1231,1053,1245,-1,1231,920,1053,-1,1232,934,1079,-1,824,934,1232,-1,1231,827,826,-1,1231,1245,827,-1,1078,822,175,-1,933,822,1078,-1,255,741,180,-1,741,255,253,-1,824,1244,305,-1,1232,1244,824,-1,73,825,74,-1,825,73,1076,-1,160,278,931,-1,160,1013,278,-1,152,830,829,-1,194,830,152,-1,1233,1122,742,-1,1122,1233,1075,-1,1072,1103,1233,-1,1103,1072,1234,-1,147,1073,1071,-1,147,149,1073,-1,185,1069,186,-1,1069,185,834,-1,837,1230,1066,-1,837,836,1230,-1,835,138,834,-1,138,835,1063,-1,839,1083,508,-1,839,1082,1083,-1,762,1064,239,-1,1064,762,1067,-1,639,1107,974,-1,639,791,1107,-1,126,129,841,-1,129,126,217,-1,1190,1061,1060,-1,1061,1190,1105,-1,855,853,1058,-1,855,854,853,-1,27,848,110,-1,27,26,848,-1,848,850,849,-1,850,848,852,-1,850,109,922,-1,850,854,109,-1,1058,921,855,-1,1058,1236,921,-1,1056,1237,1238,-1,1237,1056,1236,-1,1005,264,1057,-1,265,264,1005,-1,754,1005,1119,-1,754,176,1005,-1,1010,265,176,-1,1010,1051,265,-1,1011,866,179,-1,1011,98,866,-1,747,866,868,-1,866,747,864,-1,79,919,1050,-1,919,79,77,-1,298,118,117,-1,118,298,919,-1,1046,1124,1241,-1,1124,1046,1048,-1,1240,1123,1125,-1,1240,1226,1123,-1,844,739,117,-1,844,917,739,-1,881,274,272,-1,881,916,274,-1,914,281,740,-1,914,883,281,-1,804,300,732,-1,300,804,446,-1,48,269,49,-1,48,828,269,-1,809,843,840,-1,808,843,809,-1,886,967,913,-1,654,967,886,-1,729,656,730,-1,912,656,729,-1,891,1022,1104,-1,33,1022,891,-1,910,1020,911,-1,910,749,1020,-1,1032,549,24,-1,1032,1031,549,-1,892,18,17,-1,18,892,894,-1,8,11,571,-1,899,11,8,-1,1036,531,1034,-1,1036,532,531,-1,1035,906,28,-1,1035,1001,906,-1,1033,1029,1026,-1,1029,1033,1030,-1,1028,901,2,-1,901,1028,1027,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t5_Coord',point=[(0,48.64957,-4.15285),(-.00761,48.64545,-4.15283),(-.00866,48.72841,-4.09267),(0,48.15086,-4.21608),(-.01323,48.15361,-4.21498),(0,48.20235,-4.32222),(0,48.20903,-4.11176),(-.01279,48.21251,-4.11445),(0,48.30799,-4.00939),(0,48.52267,-3.8418),(-.01475,48.52378,-3.8443),(-.01498,48.40075,-3.89696),(0,48.61028,-3.80231),(-.01508,48.61044,-3.80261),(0,48.73028,-3.71492),(-.01503,48.72867,-3.71351),(-.01556,49.38382,-3.44868),(-.01461,49.38341,-3.31503),(0,49.37983,-3.31533),(0,49.32753,-3.54041),(-.01493,49.32603,-3.53968),(0,49.18375,-3.73244),(-.01455,49.24694,-3.63439),(0,49.24994,-3.63616),(0,49.13069,-3.80706),(-.01362,49.18079,-3.73576),(.00898,48.59081,-4.21584),(.00911,48.56556,-4.24051),(0,48.59896,-4.21336),(1.10066,49.5615,-3.47236),(1.05219,49.6219,-3.42737),(1.10789,49.56334,-3.46023),(1.05259,49.29587,-3.26942),(.95564,49.35295,-3.21246),(.99436,49.27287,-3.23806),(-1.14803,49.28944,-3.3924),(-1.14451,49.30501,-3.38483),(-1.20459,49.41612,-3.49231),(-.9755,49.2606,-3.23858),(-1.06024,49.25349,-3.29498),(-1.05929,49.23883,-3.30154),(-.95234,49.35184,-3.23457),(-1.01393,49.39295,-3.29202),(-1.05203,49.29158,-3.28798),(-1.13306,49.34827,-3.38405),(.08335,48.91555,-3.44336),(.08551,48.97002,-3.41452),(0,48.98669,-3.43353),(.06302,49.39725,-3.21794),(.01461,49.38341,-3.31467),(.01392,49.37454,-3.25998),(.32259,49.09038,-3.28602),(.22615,49.03753,-3.35952),(.33837,49.0343,-3.33874),(.58639,48.86883,-3.40236),(.57627,48.84154,-3.37819),(.54101,48.7596,-3.43914),(.41648,49.10981,-3.23187),(.32762,49.12625,-3.2441),(.31559,49.11651,-3.28248),(.52401,49.04588,-3.28014),(.57096,49.05417,-3.29438),(.50136,49.09553,-3.22154),(.45755,48.80009,-3.03944),(.49041,48.72308,-3.01708),(.43182,48.71886,-3.02586),(.4077,49.01322,-3.06028),(.47116,49.01711,-3.02652),(.50675,48.90746,-3.029),(.57703,48.78901,-3.01703),(.54899,48.72729,-3.00793),(.54008,48.79238,-3.02853),(.54303,49.16329,-3.1304),(.58805,49.2163,-3.07173),(.52425,49.19424,-3.03916),(.15709,48.60026,-3.81317),(.2272,48.67445,-3.72972),(.17936,48.68059,-3.70671),(.07709,48.61154,-3.81173),(.08387,48.70976,-3.70667),(.01503,48.72867,-3.71334),(.12755,48.53138,-3.86781),(.01498,48.40075,-3.89691),(.08021,48.40544,-3.93021),(.07812,48.52063,-3.84981),(.01279,48.21251,-4.11445),(.01323,48.15361,-4.21498),(.03652,48.17032,-4.19501),(.80999,49.20562,-3.19397),(.81042,49.28549,-3.15513),(.7161,49.25655,-3.12693),(.7934,49.15794,-3.27174),(.69789,49.13402,-3.27633),(.71317,49.07826,-3.36305),(.67133,49.00605,-3.35388),(.62923,48.93772,-3.33102),(1.15457,49.41741,-3.54692),(1.15727,49.32081,-3.52932),(1.0845,49.38922,-3.57737),(.86748,49.2132,-3.42591),(.90039,49.18509,-3.3527),(.78678,49.15006,-3.35057),(.68085,49.10337,-3.41438),(.19063,49.05858,-3.6803),(.10014,49.09241,-3.75099),(.10839,49.16277,-3.67758),(.26632,48.92364,-3.67363),(.17299,48.96928,-3.74751),(.14811,48.65545,-3.8577),(.13677,48.56628,-3.91334),(.06813,48.37667,-4.23364),(.02733,48.49615,-4.29212),(.06447,48.22312,-4.25698),(.04478,48.27092,-4.31101),(.06736,48.34029,-4.06918),(.0517,48.29716,-4.01363),(.03338,48.22347,-4.12978),(.35663,48.75986,-3.57912),(.29071,48.7287,-3.64489),(.36067,48.79706,-3.60225),(.53199,48.75974,-3.42952),(.4138,48.85305,-3.40963),(.45213,48.74553,-3.46785),(.33883,48.70219,-3.03943),(.22262,48.68036,-2.94988),(.21871,48.71364,-3.00589),(.44111,48.64386,-2.68401),(.35122,48.70782,-2.7572),(.46284,48.69403,-2.77726),(.34748,48.62574,-2.52573),(.23688,48.59226,-2.40963),(.24612,48.63145,-2.48331),(.29939,48.52091,-2.25297),(.22097,48.50108,-2.19272),(.25387,48.5344,-2.25837),(.58081,48.95978,-2.95265),(.4946,49.05847,-2.98185),(.46666,49.12759,-2.93863),(.61332,48.79032,-2.72861),(.61053,48.67202,-2.76329),(.65148,48.74894,-2.83372),(.11257,48.60323,-2.14357),(.20854,48.62367,-2.16723),(.20236,48.73302,-2.14388),(.46454,48.87308,-2.51367),(.47174,48.71703,-2.45547),(.52605,48.74417,-2.52441),(.0968,49.49012,-3.14568),(.06004,49.38251,-3.20417),(.14148,49.45273,-3.11297),(.1884,49.60866,-3.09748),(.31374,49.68785,-3.04358),(.29197,49.60599,-3.09217),(.50487,49.49711,-3.14505),(.58011,49.51981,-3.09226),(.57646,49.46527,-3.17101),(.5907,49.49853,-3.30071),(.63997,49.48709,-3.24396),(.74015,49.55533,-3.29708),(.9297,49.33733,-3.20023),(.7841,49.38094,-3.13399),(.69778,49.35092,-3.09614),(.96762,49.48798,-3.28404),(.99197,49.62069,-3.37218),(.89873,49.59185,-3.314),(.437,49.44624,-2.97615),(.44467,49.40255,-2.99464),(.49403,49.41549,-3.03675),(.51433,49.32356,-3.44433),(.44449,49.3012,-3.46033),(.43875,49.32416,-3.44956),(1.1222,49.48177,-3.53617),(1.0337,49.55884,-3.5396),(1.07525,49.56307,-3.5036),(.01455,49.24694,-3.63416),(.12295,49.25001,-3.59777),(.48253,49.18836,-3.4566),(.80851,49.47483,-3.52285),(.90861,49.52346,-3.54329),(.95073,49.42611,-3.55828),(.52308,49.47419,-3.25746),(.58664,49.47571,-3.19146),(.45326,49.18065,-2.65998),(.3851,49.31104,-2.69468),(.38339,49.30071,-2.64252),(.44481,49.04657,-2.67772),(.45039,49.07473,-2.76218),(.44527,49.08333,-2.66904),(0,49.09348,-2.0857),(0,49.08528,-2.04027),(.13235,49.11196,-2.07234),(.30184,49.22005,-2.35155),(.22426,49.21099,-2.35676),(.22736,49.19072,-2.24087),(.43171,49.5975,-3.08235),(.43485,49.66508,-3.03312),(.51804,49.57318,-3.05597),(0,48.67486,-2.89077),(.10425,48.69878,-2.97422),(.11379,48.67888,-2.91725),(.26453,49.40948,-2.95734),(.26174,49.36228,-2.91742),(.2727,49.4126,-2.87799),(.28417,49.28039,-2.9691),(.28287,49.32436,-3.01748),(.29913,49.24292,-3.07821),(.35741,49.44519,-2.90866),(.33547,49.40542,-2.84479),(.37083,49.35615,-2.85407),(.19932,49.40281,-3.07746),(.20681,49.30839,-3.14424),(.25245,49.27622,-3.11345),(.33847,48.71368,-3.04976),(.29966,48.79768,-3.02337),(.17728,49.39946,-2.80483),(.1322,49.37796,-2.79576),(.19378,49.37322,-2.7667),(.42939,48.61188,-2.53938),(.39412,48.59421,-2.43032),(.09426,49.3458,-2.77648),(.27003,49.38927,-2.79679),(.17575,49.39555,-2.81901),(.0793,49.32927,-2.78392),(.27721,49.35822,-2.75183),(.30176,49.35712,-2.75392),(.28417,49.37538,-2.7799),(.41997,49.26763,-2.54791),(.41163,49.28154,-2.55567),(.39829,49.25495,-2.44614),(.25345,49.13873,-2.1429),(.23437,49.14913,-2.13901),(.3854,49.20785,-2.78839),(.395,49.20823,-2.77828),(.43149,49.15275,-2.75132),(.37414,49.3057,-2.71759),(.33031,49.33098,-2.71295),(.62964,48.73341,-2.88386),(.5627,48.67367,-2.81999),(.53628,48.70051,-2.90298),(.30978,48.52855,-2.24909),(.41028,48.55624,-2.36361),(.60055,48.66027,-2.77278),(.64836,48.73586,-2.84293),(.21714,48.73264,-3.01364),(.67332,48.8128,-2.89838),(.66819,48.8201,-2.88035),(.57674,48.92489,-2.999),(.3448,49.27161,-3.5016),(.26393,49.42488,-3.32427),(.26125,49.38673,-3.40787),(.14146,49.38687,-3.42575),(.41807,49.39793,-3.39433),(.37891,49.39116,-3.39731),(.40874,49.42677,-3.32229),(.4899,49.42435,-3.40194),(.49581,49.44727,-3.31478),(.94199,49.24671,-3.21312),(1.03109,49.63428,-3.46821),(.60605,49.46352,-3.13175),(.57779,49.52561,-3.06599),(.57478,49.43434,-3.05914),(.53645,49.51178,-3.0355),(.48808,49.48356,-2.99793),(.65369,49.02638,-3.41408),(.56637,48.95845,-3.4697),(.56282,49.09238,-3.44664),(.03465,48.21097,-4.2917),(.4072,49.43691,-3.25221),(.26236,49.43378,-3.28006),(.13192,49.41679,-3.32262),(.40996,49.09713,-3.26194),(.41453,49.11197,-3.25501),(.58973,48.9164,-3.30596),(.61153,48.92347,-3.3168),(.48844,48.94679,-3.34778),(.47979,48.91398,-3.36388),(.56086,48.83807,-3.3679),(.61603,48.94059,-3.40439),(.78628,49.53625,-3.26094),(.28852,48.95273,-3.39163),(.21958,48.95543,-3.40065),(.22503,48.84038,-3.4754),(.62582,48.79398,-2.97507),(.5895,48.71541,-2.93842),(.56148,48.72324,-2.99273),(.40074,49.12401,-2.47236),(.45069,49.15444,-2.57829),(.42428,49.10118,-3.1393),(.36335,49.15678,-3.13767),(.3442,49.13722,-3.19874),(.14533,49.26388,-3.23281),(.06837,49.30029,-3.25731),(.08099,49.22229,-3.29911),(.49873,49.13182,-3.17656),(.56564,49.14169,-3.21084),(.41903,49.10699,-3.20167),(.29159,49.14844,-3.26186),(.1664,48.96694,-3.41259),(.19825,48.84899,-3.50582),(.19214,48.96766,-3.41501),(0,49.08024,-3.37791),(0,48.94827,-3.46567),(.08527,48.91443,-3.44955),(.08709,48.91812,-3.46807),(0,48.94029,-3.47271),(.94578,49.64985,-3.40635),(.98109,49.62594,-3.38023),(1.04444,49.62837,-3.44299),(.69425,49.14732,-3.25573),(.01556,49.38382,-3.44835),(-.69425,49.14732,-3.27022),(-.7934,49.15794,-3.28697),(-.69789,49.13402,-3.29047),(-.71317,49.07826,-3.37565),(-.67133,49.00605,-3.3659),(-.61484,49.0794,-3.30286),(-.1664,48.96694,-3.41593),(-.08709,48.91812,-3.46967),(-.08527,48.91443,-3.45115),(0,48.95699,-3.45797),(-.08335,48.91555,-3.44494),(-.08551,48.97002,-3.41626),(-.09048,49.06869,-3.37725),(-.19639,49.06158,-3.3686),(-.41903,49.10699,-3.21209),(-.50136,49.09553,-3.23336),(-.41648,49.10981,-3.24195),(-.21588,49.06027,-3.36685),(-.20232,48.96568,-3.41633),(-.48268,49.09365,-3.12579),(-.49873,49.13182,-3.18898),(-.60616,48.78465,-3.02704),(-.54899,48.72729,-3.02108),(-.56148,48.72324,-3.00624),(-.37891,49.39116,-3.4054),(-.35756,49.32738,-3.46734),(-.43875,49.32416,-3.45807),(-.60605,49.46352,-3.14738),(-.69778,49.35092,-3.11377),(-.62662,49.33177,-3.08903),(-.36587,48.73395,-3.52614),(-.21054,48.84184,-3.49),(-.36996,48.73629,-3.51295),(-.41833,49.44173,-3.30027),(-.26393,49.42488,-3.33061),(-.40874,49.42677,-3.33173),(-.32863,49.74725,-3.01356),(-.43027,49.71937,-3.00835),(-.33802,49.74817,-2.9945),(-.50813,49.46887,-3.23874),(-.52308,49.47419,-3.26986),(-.58664,49.47571,-3.2059),(-.58011,49.51981,-3.10792),(-.57646,49.46527,-3.18554),(-1.15727,49.32081,-3.53881),(-1.10948,49.29989,-3.54262),(-1.13422,49.26528,-3.50036),(-.35741,49.44519,-2.92059),(-.437,49.44624,-2.98979),(-.38628,49.38363,-2.93906),(-.5062,49.66104,-3.02095),(-.51804,49.57318,-3.07071),(-.55017,49.58689,-3.0534),(-.90039,49.18509,-3.36699),(-.96658,49.24931,-3.4615),(-.86748,49.2132,-3.4387),(-.41997,49.26763,-2.56423),(-.42103,49.27571,-2.58385),(-.46356,49.15311,-2.60766),(-.16787,49.50238,-3.1835),(-.10039,49.50319,-3.16329),(-.06302,49.39725,-3.21968),(-.31605,49.15885,-3.56379),(-.40503,49.16953,-3.51095),(-.44449,49.3012,-3.46878),(-.28417,49.37538,-2.79027),(-.30591,49.36708,-2.78775),(-.30176,49.35712,-2.76503),(-.2727,49.4126,-2.88744),(-.27003,49.38927,-2.8066),(-.23881,49.40311,-2.84543),(-.58621,48.96798,-2.92484),(-.66819,48.8201,-2.89783),(-.56987,48.96061,-2.87479),(-.63297,48.93023,-2.93466),(-.67332,48.8128,-2.91567),(-.40985,48.56099,-2.37352),(-.47751,48.58581,-2.45401),(-.41028,48.55624,-2.37847),(-.49041,48.72308,-3.029),(-.50314,48.71137,-3.01173),(-.61053,48.67202,-2.77967),(-.56016,48.62009,-2.68685),(-.57176,48.62809,-2.68635),(-.62582,48.79398,-2.99046),(-.60094,48.91106,-3.00826),(-.09995,49.07858,-2.04937),(-.13235,49.11196,-2.08338),(-.18255,49.11019,-2.10448),(-.20306,49.29791,-2.66619),(-.28184,49.33094,-2.71906),(-.29453,49.30272,-2.6586),(-.45871,49.1039,-2.67879),(-.43149,49.15275,-2.76628),(-.44527,49.08333,-2.6848),(-.45069,49.15444,-2.59513),(-.3854,49.20785,-2.8018),(-.3851,49.31104,-2.70895),(-.37414,49.3057,-2.73133),(-.33031,49.33098,-2.72527),(-.36534,49.30758,-2.65285),(-.30983,49.33058,-2.71966),(0,49.06087,-2.03308),(-.07898,49.33528,-2.77186),(0,49.32213,-2.74957),(-.0793,49.32927,-2.78687),(-.09426,49.3458,-2.78001),(-.18051,49.30704,-2.87282),(-.12296,49.37122,-2.81241),(-.12428,49.27606,-2.84275),(-.32305,49.20541,-3.04884),(-.28417,49.28039,-2.97825),(-.30414,49.18499,-3.02704),(-.42975,48.8975,-3.06042),(-.4077,49.01322,-3.0715),(-.3541,48.8871,-3.04891),(-.26673,48.87613,-3.01633),(-.29966,48.79768,-3.03139),(-.28823,49.06268,-3.01774),(-.31958,48.9801,-3.03196),(-.4946,49.05847,-2.99607),(-.50457,49.09421,-3.03958),(-.47148,49.06774,-3.07256),(-.22997,49.22492,-3.20595),(-.20681,49.30839,-3.15017),(-.25245,49.27622,-3.12079),(-.21928,49.54887,-2.98855),(-.25829,49.49584,-2.97075),(-.20551,49.49094,-3.02402),(-.23934,49.45011,-2.99759),(-.32538,49.45592,-2.92153),(-.2975,49.52026,-2.9529),(-.37083,49.35615,-2.86679),(-.33547,49.40542,-2.85649),(0,49.26528,-3.3027),(-.08099,49.22229,-3.30112),(0,49.16628,-3.33661),(-.36335,49.15678,-3.14755),(-.29913,49.24292,-3.08703),(-.23906,49.36271,-3.05601),(-.26453,49.40948,-2.96606),(-.36766,49.11863,-3.09282),(-.27721,49.35822,-2.7621),(-.19378,49.37322,-2.77393),(-.26115,49.38524,-2.78684),(-.22262,48.68036,-2.95589),(-.34635,48.70729,-2.90165),(-.34661,48.69746,-2.98013),(-.45326,49.18065,-2.6764),(-.2295,49.33377,-2.89938),(-.5189,49.58491,-3.00786),(-.46641,49.64499,-2.98062),(-.51014,49.65717,-3.00269),(-.40988,49.2515,-2.4591),(-.36901,49.09223,-2.38586),(-.36262,49.21508,-2.35913),(-.40074,49.12401,-2.48803),(-.09381,48.9611,-2.0819),(0,48.93522,-2.05226),(-.43574,49.02428,-2.61563),(-.41105,48.99308,-2.51464),(-.42763,49.27582,-2.97708),(-.21586,49.15361,-3.61659),(-.23972,49.25469,-3.55395),(-.12295,49.25001,-3.59984),(-.99347,49.63777,-3.51066),(-.90768,49.66485,-3.44794),(-.89352,49.61035,-3.52138),(-.25376,49.32436,-3.48739),(-.13516,49.32602,-3.51896),(-.26125,49.38673,-3.41356),(-.44467,49.40255,-3.00828),(-.49732,49.29475,-3.02247),(-1.03109,49.63428,-3.48002),(-.94578,49.64985,-3.41981),(-.52425,49.19424,-3.0539),(-.7841,49.38094,-3.15221),(-.58738,49.46683,-3.42858),(-.6845,49.51114,-3.4533),(-.69,49.57138,-3.35325),(-.26999,49.49848,-3.18326),(-.14575,49.41978,-3.26492),(-.50487,49.49711,-3.15848),(-.41465,49.49578,-3.17051),(-.4072,49.43691,-3.26235),(-.43171,49.5975,-3.09473),(-.14148,49.45273,-3.1172),(-.19932,49.40281,-3.08354),(-.52023,49.12926,-3.08483),(-.48706,49.16755,-3.00579),(-.53581,48.92137,-2.71983),(-.50499,48.89966,-2.62959),(-.46454,48.87308,-2.52998),(-.41758,48.84514,-2.43112),(-.38414,48.96373,-2.41293),(-.52605,48.74417,-2.54147),(-.52837,48.61149,-2.58449),(0,48.58452,-2.10885),(0,48.68643,-2.09813),(-.1067,48.70734,-2.12127),(-.61809,48.93322,-2.96837),(-.65558,48.80302,-2.94596),(-.29939,48.52091,-2.2669),(-.37172,48.57281,-2.35279),(-.24316,48.67357,-2.61923),(-.34748,48.62574,-2.53767),(-.34147,48.66734,-2.67287),(-.35122,48.70782,-2.76777),(-.45199,48.69403,-2.79042),(-.44976,48.71034,-2.89727),(-.46006,48.76586,-3.53017),(-.4702,48.83127,-3.53701),(-.36067,48.79706,-3.60703),(-.29225,48.74524,-3.66583),(-.2272,48.67445,-3.73193),(-.29071,48.7287,-3.64838),(-.0517,48.29716,-4.01363),(-.03338,48.22347,-4.12978),(-.01198,48.20607,-4.31792),(-.03465,48.21097,-4.2917),(-.05111,48.37356,-4.31508),(-.01346,48.36465,-4.3333),(-.01206,48.26126,-4.33603),(-.04478,48.27092,-4.31101),(-.06813,48.37667,-4.23364),(-.06447,48.22312,-4.25698),(-.03652,48.17032,-4.19501),(-.06253,48.25264,-4.15834),(-.068,48.31189,-4.19166),(-.0644,48.41803,-4.11824),(-.06736,48.34029,-4.06918),(-.06892,48.5223,-4.05175),(-.04564,48.49678,-4.16336),(-.04909,48.58631,-4.10841),(-.0925,48.63552,-3.98059),(-.19464,48.73307,-3.78498),(-.12569,48.80415,-3.85842),(-.10766,48.717,-3.92226),(-.23746,48.81014,-3.71925),(-.01251,49.12648,-3.80868),(-.10839,49.16277,-3.67913),(-.61603,48.94059,-3.41478),(-.55234,48.86864,-3.48434),(-.54325,48.79608,-3.47796),(-.92163,49.30608,-3.52472),(-.86493,49.38333,-3.53247),(-.7579,49.32309,-3.49487),(-.68085,49.10337,-3.42593),(-.72345,49.21093,-3.45586),(-.76573,49.16608,-3.43309),(-.81581,49.25971,-3.47495),(-1.00469,49.34587,-3.58104),(-1.06269,49.27674,-3.51752),(-1.18558,49.29143,-3.479),(-1.14197,49.25078,-3.40398),(-.57096,49.05417,-3.30627),(-.78678,49.15006,-3.36426),(-.92613,49.17739,-3.2794),(-.80999,49.20562,-3.21095),(-.70096,49.19541,-3.20335),(-.56564,49.14169,-3.22409),(-.01463,48.3078,-4.00922),(-.12755,48.53138,-3.86849),(-.08021,48.40544,-3.93042),(-.07812,48.52063,-3.85025),(-.17936,48.68059,-3.70859),(-.19054,48.76821,-3.60492),(-.58805,49.2163,-3.08747),(-.64734,49.23835,-3.11625),(-.54303,49.16329,-3.14435),(-.42428,49.10118,-3.15044),(-.42183,49.05998,-3.10226),(-.54008,48.79238,-3.04176),(-.45755,48.80009,-3.05097),(-.62923,48.93772,-3.34259),(-.61153,48.92347,-3.32829),(-.49684,49.06344,-3.27678),(-.41453,49.11197,-3.26482),(-.45776,48.74484,-3.48422),(-.54101,48.7596,-3.44747),(-.56086,48.83807,-3.37769),(-.44876,48.87581,-3.39927),(-.47979,48.91398,-3.37295),(-.19214,48.96766,-3.41883),(-.19825,48.84899,-3.50913),(-.1986,49.14461,-3.32305),(-.06837,49.30029,-3.2591),(0,49.33485,-3.28614),(-.13192,49.41679,-3.32586),(-.29159,49.14844,-3.26904),(-.1857,49.18965,-3.29438),(-.14533,49.26388,-3.23667),(-.35663,48.75986,-3.58394),(-.22615,49.03753,-3.36443),(-.33837,49.0343,-3.34606),(-.28709,48.98539,-3.38197),(-.58639,48.86883,-3.41215),(-.52401,49.04588,-3.29146),(-.43182,48.71886,-3.03649),(-.50675,48.90746,-3.04227),(-.47116,49.01711,-3.03957),(-.57703,48.78901,-3.03105),(-.07709,48.61154,-3.81231),(-.08387,48.70976,-3.70759),(-.7161,49.25655,-3.14414),(-.94563,49.24086,-3.22392),(-.964,49.25429,-3.23828),(-1.15457,49.41741,-3.55597),(-1.0845,49.38922,-3.58634),(-1.19735,49.41425,-3.51204),(-.636,49.15136,-3.45062),(-.56282,49.09238,-3.45643),(-.65369,49.02638,-3.42506),(-.57627,48.84154,-3.38805),(-.19063,49.05858,-3.68291),(-.26632,48.92364,-3.67706),(-.29017,49.03878,-3.62833),(-.36719,48.89685,-3.60187),(-.14811,48.65545,-3.85869),(-.15709,48.60026,-3.81431),(-.02733,48.49615,-4.29212),(-.53199,48.75974,-3.43786),(-.45213,48.74553,-3.47478),(-.33883,48.70219,-3.04785),(-.53628,48.70051,-2.91677),(-.43515,48.70889,-2.97863),(-.3603,48.59521,-2.40886),(-.23726,48.63145,-2.52107),(-.23688,48.59226,-2.42174),(0,48.57147,-2.35297),(-.1261,48.55604,-2.32317),(-.1262,48.58712,-2.37803),(-.25387,48.5344,-2.27366),(-.24378,48.56745,-2.34926),(-.46666,49.12759,-2.95285),(-.58081,48.95978,-2.9686),(-.13205,49.3468,-3.18508),(-.06004,49.38251,-3.20584),(-.47646,49.55933,-2.96964),(-.41843,49.51749,-2.94782),(-.44728,49.5889,-2.95671),(-.74015,49.55533,-3.31192),(-.63997,49.48709,-3.25849),(-.5907,49.49853,-3.31363),(-.92251,49.33415,-3.21315),(-.81594,49.28304,-3.16429),(-.99129,49.6223,-3.3867),(-1.04377,49.53064,-3.37995),(-.96929,49.48872,-3.29956),(-.51433,49.32356,-3.45404),(-1.1222,49.48177,-3.54577),(-1.07525,49.56307,-3.51438),(-1.0337,49.55884,-3.54978),(-.48253,49.18836,-3.46548),(-.95073,49.42611,-3.56848),(-.90861,49.52346,-3.55391),(-.80851,49.47483,-3.53386),(-.38339,49.30071,-2.65706),(-.45039,49.07473,-2.77734),(-.44481,49.04657,-2.69325),(-.30184,49.22005,-2.36368),(-.22736,49.19072,-2.24946),(-.22426,49.21099,-2.36465),(-.4703,48.57878,-2.45807),(-.43074,49.71738,-2.98989),(0,48.68179,-2.96709),(-.11379,48.67888,-2.92043),(-.11978,49.18081,-2.24519),(-.12961,49.14422,-2.14643),(-.28883,49.4404,-2.94098),(-.17728,49.39946,-2.81133),(-.91339,49.45531,-3.23243),(-.90158,49.59105,-3.3262),(-.21871,48.71364,-3.01166),(-.10425,48.69878,-2.97705),(-.39053,48.80072,-3.04754),(-.1322,49.37796,-2.80066),(-.17575,49.39555,-2.82541),(-.39829,49.25495,-2.46222),(-.41163,49.28154,-2.57168),(-.395,49.20823,-2.79206),(-.5627,48.67367,-2.83489),(-.62964,48.73341,-2.89989),(-.30978,48.52855,-2.26339),(-.33847,48.71368,-3.05815),(-.21714,48.73264,-3.0194),(-.0998,48.71339,-2.98607),(-.57674,48.92489,-3.01412),(-.3448,49.27161,-3.50801),(-.47649,49.04896,-3.50257),(-.14146,49.38687,-3.42884),(-.41807,49.39793,-3.40317),(-.4899,49.42435,-3.4119),(-.49581,49.44727,-3.32595),(-.41942,49.27596,-2.58246),(-1.10583,49.56628,-3.4884),(-.57779,49.52561,-3.08195),(-.53645,49.51178,-3.05095),(-.49403,49.41549,-3.05119),(-.48808,49.48356,-3.01267),(-.56637,48.95845,-3.47874),(-.26236,49.43378,-3.28667),(-.31559,49.11651,-3.28997),(-.32259,49.09038,-3.29358),(-.58973,48.9164,-3.31729),(-.23437,49.14913,-2.1521),(-.48844,48.94679,-3.3573),(-.68487,49.47667,-3.20778),(-.64836,48.73586,-2.86006),(-.60055,48.66027,-2.78877),(-.5895,48.71541,-2.95297),(-.3442,49.13722,-3.2076),(-.32762,49.12625,-3.25218),(0,48.92945,-3.4823),(0,48.9363,-3.47623),(-.08453,48.9141,-3.47765),(-.88783,49.59899,-3.33418),(-.88663,49.58449,-3.32783),(-.85064,49.61586,-3.36687),(-1.04444,49.62837,-3.45536),(-.98134,49.63072,-3.39167),(.61484,49.0794,-3.29019),(.09048,49.06869,-3.37526),(.20232,48.96568,-3.4123),(.21588,49.06027,-3.36213),(.48268,49.09365,-3.11311),(.60616,48.78465,-3.0125),(.62662,49.33177,-3.07229),(.21054,48.84184,-3.48641),(.36587,48.73395,-3.52081),(.36996,48.73629,-3.50745),(.41833,49.44173,-3.29029),(.20255,49.70366,-3.00517),(.20253,49.70863,-3.02488),(.13588,49.67398,-3.03778),(.41843,49.51749,-2.93431),(.00911,48.49494,-4.29871),(.96658,49.24931,-3.4491),(.46356,49.15311,-2.59049),(1.13592,49.29467,-3.38514),(1.0494,49.24444,-3.29229),(1.14197,49.25078,-3.39112),(.10039,49.50319,-3.16039),(.16787,49.50238,-3.17876),(.40503,49.16953,-3.50378),(.31605,49.15885,-3.55849),(.30591,49.36708,-2.77662),(.23881,49.40311,-2.8369),(.58621,48.96798,-2.90821),(.56987,48.96061,-2.85801),(.63297,48.93023,-2.91744),(.47407,48.58581,-2.46591),(.40985,48.56099,-2.35812),(.46691,48.57878,-2.47035),(.61809,48.93322,-2.95183),(.61232,48.91106,-2.99218),(.50314,48.71137,-2.99946),(.57176,48.62809,-2.67034),(.65558,48.80302,-2.92943),(.09995,49.07858,-2.03932),(.18255,49.11019,-2.09017),(.19396,49.33206,-2.70886),(.29453,49.30272,-2.64723),(.28184,49.33094,-2.70843),(.45871,49.1039,-2.66248),(.42378,49.12601,-2.75093),(.30983,49.33058,-2.70804),(.36534,49.30758,-2.63891),(.40988,49.2515,-2.44258),(.35192,49.22587,-2.34754),(.41942,49.27596,-2.56625),(.37839,49.29816,-2.61994),(.07898,49.33528,-2.76889),(0,49.31828,-2.77985),(.18051,49.30704,-2.86647),(.12428,49.27606,-2.8383),(.12296,49.37122,-2.80789),(.32305,49.20541,-3.03913),(.30414,49.18499,-3.01776),(.3541,48.8871,-3.03931),(.31958,48.9801,-3.02278),(.12166,48.58712,-2.3952),(.12159,48.623,-2.49587),(.39053,48.80072,-3.03745),(.28823,49.06268,-3.0091),(.2378,48.95762,-2.9864),(.21853,49.03431,-2.96594),(.33526,49.09146,-3.05176),(.50457,49.09421,-3.02545),(.22997,49.22492,-3.19977),(.30153,49.1918,-3.16726),(.35269,49.53766,-2.92903),(.2975,49.52026,-2.94306),(.32538,49.45592,-2.91059),(.09125,49.15884,-3.33327),(.23906,49.36271,-3.04862),(.26115,49.38524,-2.77725),(.23158,48.70601,-2.87715),(.34661,48.69746,-2.97109),(.34635,48.70729,-2.89204),(.51014,49.65717,-2.98746),(.46641,49.64499,-2.96624),(.5189,49.58491,-2.99237),(.068,48.31189,-4.19166),(.06253,48.25264,-4.15834),(.43574,49.02428,-2.59994),(.42103,49.27571,-2.56759),(.43195,49.20494,-2.73138),(.388,49.25211,-2.90083),(.42763,49.27582,-2.96375),(.21586,49.15361,-3.61318),(.35756,49.32738,-3.46029),(.23972,49.25469,-3.54968),(.38628,49.38363,-2.92644),(.90768,49.66485,-3.43518),(.49732,49.29475,-3.00777),(.6845,49.51114,-3.44151),(.58738,49.46683,-3.41744),(.14575,49.41978,-3.26111),(.26999,49.49848,-3.17576),(.41465,49.49578,-3.15926),(.13205,49.3468,-3.18137),(.52023,49.12926,-3.07075),(.48706,49.16755,-2.99146),(.53581,48.92137,-2.7026),(.50499,48.89966,-2.6126),(.38414,48.96373,-2.39683),(.41758,48.84514,-2.41527),(.52837,48.61149,-2.56778),(.1067,48.70734,-2.10521),(.43921,48.71034,-2.88554),(.34147,48.66734,-2.66149),(.24316,48.67357,-2.61133),(.43515,48.70889,-2.96749),(.46006,48.76586,-3.52365),(.01463,48.3078,-4.00922),(.01206,48.26126,-4.33603),(.05111,48.37356,-4.31508),(.04564,48.49678,-4.16336),(.0644,48.41803,-4.11824),(.06892,48.5223,-4.05168),(.00761,48.64545,-4.15283),(.04909,48.58631,-4.1084),(.05333,48.69141,-4.03031),(.0925,48.63552,-3.98025),(.10766,48.717,-3.92165),(.19464,48.73307,-3.78321),(.29225,48.74524,-3.6624),(.23746,48.81014,-3.71659),(.14736,48.88053,-3.80621),(.01251,49.12648,-3.80855),(.01362,49.18079,-3.73559),(.55234,48.86864,-3.47587),(.86493,49.38333,-3.52135),(.92163,49.30608,-3.51357),(.81581,49.25971,-3.46293),(1.00469,49.34587,-3.57142),(1.10948,49.29989,-3.5328),(1.06269,49.27674,-3.50678),(.92613,49.17739,-3.26322),(1.01924,49.20262,-3.38138),(1.10244,49.2311,-3.43633),(1.05392,49.2048,-3.30534),(.70096,49.19541,-3.1875),(.60667,49.17436,-3.1589),(.64734,49.23835,-3.09974),(.47148,49.06774,-3.05965),(.42183,49.05998,-3.09083),(.1857,49.18965,-3.2898),(.54325,48.79608,-3.46981),(.3989,49.04333,-3.32423),(.50244,49.03293,-3.27518),(.44876,48.87581,-3.39111),(.31096,48.89993,-3.41357),(.1986,49.14461,-3.31836),(.19639,49.06158,-3.36429),(-.94477,49.34699,-3.22912),(-1.1137,49.56757,-3.47029),(1.05423,49.25511,-3.28608),(.88758,49.5942,-3.32146),(.8865,49.58921,-3.31536),(.94491,49.34708,-3.21136),(-.01392,49.37454,-3.26034),(0,49.35971,-3.27989),(0,49.37213,-3.27675),(.01493,49.32603,-3.5394),(0,49.38332,-3.44844),(.01508,48.61044,-3.80249),(.01475,48.52378,-3.84421),(0,48.40069,-3.89686),(.01198,48.20607,-4.31792),(0,48.73315,-4.09574),(.00866,48.72841,-4.09265),(0,48.88804,-3.51893),(0,48.81363,-3.60035),(.0147,48.81086,-3.59907),(-.00911,48.56556,-4.24051),(-.00898,48.59081,-4.21584),(.98475,49.26344,-3.24026),(1.13531,49.35005,-3.36746),(1.1371,49.30475,-3.37701),(1.19805,49.41396,-3.48488),(-1.04798,49.62259,-3.44697),(-.89762,49.4513,-3.23488),(.3539,48.87131,-3.41906),(.40654,48.95099,-3.374),(.45132,49.00396,-3.32578),(.45776,48.74484,-3.47733),(.49684,49.06344,-3.26569),(.19054,48.76821,-3.6023),(.7579,49.32309,-3.48339),(.12569,48.80415,-3.85742),(.09741,48.44362,-3.98929),(.01346,48.36465,-4.3333),(.4702,48.83127,-3.5302),(.43049,48.70671,-3.01245),(.23767,48.70483,-2.74024),(.64207,48.80906,-2.81607),(.41105,48.99308,-2.49929),(.50813,49.46887,-3.22623),(.69,49.57138,-3.3397),(.68487,49.47667,-3.19177),(.99347,49.63777,-3.49945),(.25376,49.32436,-3.48238),(.89352,49.61035,-3.51013),(.56016,48.62009,-2.67117),(.52026,48.6041,-2.57304),(.54947,49.5898,-3.01833),(.2295,49.33377,-2.89148),(.23934,49.45011,-2.98983),(.37481,49.3267,-2.76518),(.26673,48.87613,-3.00881),(.42975,48.8975,-3.04908),(.35832,48.57281,-2.36514),(.34732,48.59521,-2.42336),(.36262,49.21508,-2.34401),(.20306,49.29791,-2.65828),(.30697,49.41921,-2.853),(.5062,49.66104,-3.00603),(.55017,49.58689,-3.03772),(1.13422,49.26528,-3.48975),(.13216,49.66402,-3.02149),(.08453,48.9141,-3.47611),(-.78628,49.53625,-3.2769),(-.50244,49.03293,-3.28615),(-.40996,49.09713,-3.27155),(-.57478,49.43434,-3.07514),(-.35269,49.53766,-2.94066),(0,49.12208,-2.12759),(-.42378,49.12601,-2.76557),(-.28287,49.32436,-3.02633),(-.26174,49.36228,-2.92626),(-.43485,49.66508,-3.04598),(-.39412,48.59421,-2.44388),(-.43195,49.20494,-2.74666),(-.57514,49.2297,-3.46044),(-1.05943,49.46981,-3.5744),(-.88503,49.44122,-3.22601),(-.1884,49.60866,-3.10312),(-.29197,49.60599,-3.10079),(-.31374,49.68785,-3.05306),(-.0968,49.49012,-3.14851),(-.47174,48.71703,-2.47187),(-.22097,48.50108,-2.20777),(0,48.54556,-2.27399),(-.4138,48.85305,-3.41701),(-.13677,48.56628,-3.91396),(-.17299,48.96928,-3.74952),(-.10014,49.09241,-3.75222),(-.19213,48.78988,-3.00592),(-.17133,48.86717,-2.98287),(-.60667,49.17436,-3.17367),(-1.19934,49.39953,-3.49907),(-.05333,48.69141,-4.03047),(-.09741,48.44362,-3.98945),(-.23767,48.70483,-2.74763),(-.64207,48.80906,-2.83374),(-.65148,48.74894,-2.85114),(-.11257,48.60323,-2.15757),(-.388,49.25211,-2.91354),(-.54947,49.5898,-3.03422),(-.23158,48.70601,-2.8838),(-.30153,49.1918,-3.17544),(-.09125,49.15884,-3.33542),(-.37481,49.3267,-2.77864),(-.33526,49.09146,-3.06146),(-.37839,49.29816,-2.63444),(-.35192,49.22587,-2.36217),(-.19396,49.33206,-2.71628),(-.30697,49.41921,-2.86373),(-1.01924,49.20262,-3.39503),(-.00911,48.49494,-4.29871),(-.22503,48.84038,-3.47928),(.12961,49.14422,-2.13757),(1.18558,49.29143,-3.46833),(.47649,49.04896,-3.49461),(.0998,48.71339,-2.98336),(.28883,49.4404,-2.93132),(.11978,49.18081,-2.23936),(.43074,49.71738,-2.97668),(.57514,49.2297,-3.45018),(1.05943,49.46981,-3.56497),(1.04156,49.53016,-3.36597),(.8839,49.43963,-3.2113),(.47646,49.55933,-2.95478),(.44728,49.5889,-2.94252),(.24378,48.56745,-2.33484),(.36719,48.89685,-3.5967),(.29017,49.03878,-3.62409),(.76573,49.16608,-3.42079),(1.19423,49.40065,-3.49071),(.28709,48.98539,-3.37605),(.91668,49.45695,-3.2286),(1.01598,49.39345,-3.27231),(1.1914,49.41054,-3.49737),(-.0147,48.81086,-3.59928),(-.00985,48.89492,-3.9846),(0,48.82285,-4.03332),(-.00935,48.81878,-4.03044),(0,48.89858,-3.9872),(0,48.97872,-3.93609),(-.01153,49.05107,-3.88213),(0,49.05508,-3.8825),(-.01058,48.97508,-3.93428),(0,48.36514,-4.3365),(0,48.49553,-4.29985),(0,48.26171,-4.34009),(1.15947,49.49078,-3.47423),(1.15244,49.4883,-3.48626),(-1.15802,49.49256,-3.5016),(-1.16565,49.49429,-3.4832),(0,48.9185,-3.49198),(-.08322,48.87208,-3.51233),(.10485,49.60994,-3.08731),(.36766,49.11863,-3.08246),(0,48.84386,-2.93592),(.09048,48.78505,-2.97729),(0,48.77016,-2.96621),(.0836,48.85601,-2.95251),(.08322,48.87208,-3.51091),(.08152,48.79829,-3.59299),(.636,49.15136,-3.43973),(.72345,49.21093,-3.44412),(.66831,49.27742,-3.46315),(.01153,49.05107,-3.88203),(.09309,49.01632,-3.81707),(.07537,48.93596,-3.87681),(.47428,48.91247,-3.52494),(.06214,48.77447,-3.9789),(.00935,48.81878,-4.0304),(0,48.65099,-2.57015),(.12482,48.66301,-2.59437),(0,48.6137,-2.4509),(.57497,48.76981,-2.63307),(.30572,48.65098,-2.24157),(.22265,48.50692,-2.1832),(.35552,48.81573,-2.31076),(.39007,48.68865,-2.34716),(.45248,49.09727,-2.83429),(.55141,48.94493,-2.78653),(.25829,49.49584,-2.96224),(.09885,49.59478,-3.07272),(.17403,49.61358,-3.00473),(.14104,49.55085,-3.0466),(.34953,49.60022,-2.94192),(.34912,49.67265,-2.96047),(.55918,49.30993,-3.04793),(1.08941,49.44311,-3.36166),(.13516,49.32602,-3.51636),(.78974,49.5659,-3.47889),(.38427,49.21542,-2.80897),(.36901,49.09223,-2.37053),(.0967,48.83462,-2.08631),(0,48.80977,-2.07244),(.09381,48.9611,-2.06766),(.31374,49.18589,-2.23846),(.31865,49.06309,-2.26305),(.21685,49.23577,-2.46069),(.32378,49.25189,-2.45479),(.10363,49.24426,-2.56104),(0,49.26107,-2.64476),(0,49.22801,-2.55715),(.10056,49.26679,-2.64586),(.0972,49.27974,-2.6639),(.08891,49.305,-2.71194),(.06983,49.24463,-2.80559),(.20196,49.11849,-2.93723),(.13155,49.19216,-2.86313),(.19199,49.21826,-2.89998),(.1387,49.09337,-2.89872),(0,49.23358,-2.79685),(.067,49.16479,-2.82962),(0,49.15089,-2.81407),(.27406,49.58012,-2.96175),(.90408,49.45434,-3.22867),(.12203,48.69665,-2.72178),(.11135,48.70209,-2.85538),(.1261,48.55604,-2.31272),(.32662,49.27108,-2.55477),(.30303,49.19757,-2.24223),(0,49.29694,-2.70379),(0,49.27482,-2.66262),(0,48.48636,-2.13057),(.13038,48.52722,-2.23754),(.13483,48.48801,-2.16455),(0,48.51965,-2.1925),(.17526,48.99704,-2.11535),(.12704,48.4921,-2.15172),(0,48.48998,-2.11908),(.38157,49.02789,-3.56492),(.43027,49.71937,-2.99534),(.32863,49.74725,-3.00345),(.33802,49.74817,-2.98398),(.15451,48.94076,-2.95615),(.17133,48.86717,-2.97786),(.07634,48.9275,-2.92638),(-.0836,48.85601,-2.95501),(0,48.91247,-2.90515),(-.07634,48.9275,-2.92877),(-.3539,48.87131,-3.42549),(-.21958,48.95543,-3.40505),(-.13588,49.67398,-3.04204),(-.20255,49.70366,-3.01159),(-.13216,49.66402,-3.02569),(-.20253,49.70863,-3.03121),(-.34953,49.60022,-2.95331),(-1.05392,49.2048,-3.32064),(0,48.69347,-2.97662),(-.52026,48.6041,-2.58944),(-.12704,48.4921,-2.16211),(-.30379,49.2907,-2.63949),(-.30303,49.19757,-2.25292),(-.25345,49.13873,-2.15743),(-.31374,49.18589,-2.25028),(-.13038,48.52722,-2.2487),(-.32378,49.25189,-2.46804),(-.12482,48.66301,-2.5985),(-.12203,48.69665,-2.72565),(-.09048,48.78505,-2.97987),(-.26666,49.14936,-2.98427),(-.19199,49.21826,-2.9065),(-.20196,49.11849,-2.94379),(-.2452,49.24872,-2.93977),(-.21853,49.03431,-2.97273),(-.1387,49.09337,-2.90335),(-.14346,49.01497,-2.93569),(-.067,49.16479,-2.832),(-.13155,49.19216,-2.86772),(-.06659,49.0751,-2.86891),(-.42939,48.61188,-2.55361),(-.45759,48.64386,-2.6648),(-.10913,49.22305,-2.46279),(0,49.20514,-2.45427),(-.10363,49.24426,-2.56525),(-.21685,49.23577,-2.46979),(-.1177,49.2028,-2.35499),(-.26559,48.9022,-2.22116),(-.17526,48.99704,-2.137),(-.25047,49.03191,-2.19783),(-.19062,48.86916,-2.15823),(-.61034,49.37246,-3.47118),(-.66831,49.27742,-3.47427),(-1.08744,49.44167,-3.37894),(-.34912,49.67265,-2.97162),(-.27406,49.58012,-2.97072),(-.23586,49.65284,-2.99126),(-.14104,49.55085,-3.05104),(-.17403,49.61358,-3.01033),(-.55141,48.94493,-2.80352),(-.61332,48.79032,-2.74646),(-.28674,48.77492,-2.23726),(-.39007,48.68865,-2.36419),(-.29541,48.65098,-2.26397),(-.35552,48.81573,-2.33206),(-.22265,48.50692,-2.19888),(-.20854,48.62367,-2.19062),(-.57497,48.76981,-2.65075),(-.13483,48.48801,-2.17513),(-.12614,48.623,-2.47407),(-.11135,48.70209,-2.85866),(0,48.68479,-2.69247),(0,48.6982,-2.82334),(-.43049,48.70671,-3.0231),(-.06532,48.85605,-3.92318),(-.14736,48.88053,-3.80764),(-.07537,48.93596,-3.87744),(-.09309,49.01632,-3.81803),(-.08152,48.79829,-3.59417),(-.2378,48.95762,-2.99348),(-.15451,48.94076,-2.96088),(-.3989,49.04333,-3.33285),(-.45132,49.00396,-3.33518),(-.28852,48.95273,-3.39738),(-.10485,49.60994,-3.0905),(-.40654,48.95099,-3.38195),(-.38157,49.02789,-3.57084),(-.47428,48.91247,-3.53213),(-.06214,48.77447,-3.9792),(-.20236,48.73302,-2.17073),(-.33384,48.93458,-2.31838),(-.09885,49.59478,-3.07577),(-.55918,49.30993,-3.0636),(-.81227,49.63316,-3.40082),(-.78974,49.5659,-3.49064),(-.45248,49.09727,-2.84899),(-.38427,49.21542,-2.82221),(-.0967,48.83462,-2.10328),(-.31865,49.06309,-2.28282),(-.10056,49.26679,-2.64982),(-.0972,49.27974,-2.66771),(-.08891,49.305,-2.71536),(0,49.0609,-2.84461),(-.07042,48.99818,-2.90132),(-1.10244,49.2311,-3.44837),(.30379,49.2907,-2.62771),(.20551,49.49094,-3.01745),(.14346,49.01497,-2.93111),(.06659,49.0751,-2.86664),(.10913,49.22305,-2.45833),(.1177,49.2028,-2.35091),(.33384,48.93458,-2.29505),(.70016,49.41808,-3.49104),(.81227,49.63316,-3.38726),(.23586,49.65284,-2.98365),(.21928,49.54887,-2.98138),(.28674,48.77492,-2.20866),(.06532,48.85605,-3.92274),(.00985,48.89492,-3.98454),(.01058,48.97508,-3.93421),(0,48.98325,-2.87485),(.07042,48.99818,-2.89902),(.19213,48.78988,-3.0006),(.19062,48.86916,-2.13083),(.26559,48.9022,-2.19186),(.85064,49.61586,-3.35237),(.61034,49.37246,-3.46046),(.25047,49.03191,-2.17441),(0,49.16175,-2.23586),(0,49.18982,-2.3395),(.21069,49.25813,-2.55911),(.20543,49.28388,-2.6408),(.2452,49.24872,-2.93164),(.26666,49.14936,-2.97588),(-.31096,48.89993,-3.4194),(-.20543,49.28388,-2.64885),(-.32662,49.27108,-2.56772),(-.06983,49.24463,-2.80814),(-.21069,49.25813,-2.5676),(-.70016,49.41808,-3.5021)]))),
        Shape(DEF='t5disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t5disc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,4,6,7,-1,8,9,10,-1,11,12,13,-1,14,13,15,-1,16,17,15,-1,15,18,19,-1,20,21,8,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,27,-1,33,34,35,-1,36,37,38,-1,39,20,40,-1,41,10,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,61,56,62,-1,63,64,65,-1,66,67,68,-1,54,53,69,-1,53,70,69,-1,71,72,73,-1,74,75,76,-1,77,52,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,50,91,92,-1,65,91,93,-1,94,95,96,-1,97,98,99,-1,100,101,102,-1,103,100,104,-1,105,106,74,-1,107,108,109,-1,110,111,108,-1,109,86,112,-1,81,113,114,-1,115,78,114,-1,116,117,118,-1,117,116,119,-1,120,82,85,-1,54,69,72,-1,70,53,121,-1,40,30,122,-1,70,123,124,-1,125,73,72,-1,126,90,89,-1,39,40,127,-1,119,128,129,-1,78,54,130,-1,131,61,47,-1,44,132,133,-1,134,135,136,-1,55,57,137,-1,31,138,139,-1,140,141,142,-1,45,133,137,-1,143,144,145,-1,26,138,27,-1,146,147,139,-1,148,149,150,-1,151,24,23,-1,152,9,8,-1,153,154,23,-1,155,156,157,-1,158,159,24,-1,160,136,135,-1,161,162,163,-1,5,164,165,-1,97,166,167,-1,166,168,167,-1,135,169,160,-1,170,38,37,-1,158,24,151,-1,171,157,22,-1,153,23,172,-1,152,8,173,-1,151,23,154,-1,149,174,150,-1,147,175,139,-1,26,176,138,-1,145,177,143,-1,1,178,179,-1,133,180,137,-1,142,181,140,-1,139,182,31,-1,137,174,55,-1,17,177,170,-1,136,183,134,-1,132,184,133,-1,46,131,47,-1,114,78,130,-1,129,106,119,-1,127,116,39,-1,72,185,125,-1,69,70,124,-1,186,57,56,-1,56,61,186,-1,127,40,122,-1,121,187,70,-1,130,54,72,-1,113,87,115,-1,120,85,188,-1,117,119,105,-1,116,118,39,-1,115,114,113,-1,81,80,113,-1,109,112,107,-1,108,75,110,-1,107,189,108,-1,105,119,106,-1,65,64,190,-1,103,104,191,-1,192,193,194,-1,100,102,104,-1,97,167,98,-1,95,195,96,-1,65,196,91,-1,104,102,194,-1,197,198,193,-1,50,49,91,-1,85,112,86,-1,82,120,83,-1,188,113,80,-1,77,78,115,-1,74,76,105,-1,71,130,72,-1,67,199,68,-1,47,61,62,-1,59,200,60,-1,73,125,62,-1,62,201,73,-1,55,202,56,-1,203,88,66,-1,54,78,52,-1,50,204,51,-1,205,46,48,-1,44,133,45,-1,10,206,42,-1,20,28,40,-1,34,207,35,-1,27,138,31,-1,40,28,30,-1,25,27,208,-1,20,8,41,-1,15,19,16,-1,17,14,15,-1,14,152,13,-1,13,209,11,-1,10,41,8,-1,178,210,179,-1,4,7,5,-1,211,164,162,-1,3,5,165,-1,0,178,1,-1,212,166,213,-1,212,168,166,-1,214,167,168,-1,214,215,167,-1,216,217,218,-1,216,219,217,-1,164,220,165,-1,164,211,220,-1,161,221,222,-1,161,223,221,-1,163,44,43,-1,163,162,44,-1,6,169,135,-1,4,169,6,-1,162,222,211,-1,162,161,222,-1,37,152,14,-1,152,37,9,-1,224,225,226,-1,224,227,225,-1,228,229,84,-1,228,230,229,-1,231,155,157,-1,231,232,155,-1,23,233,172,-1,23,22,233,-1,173,226,209,-1,173,224,226,-1,159,234,171,-1,228,234,159,-1,175,148,150,-1,147,148,175,-1,143,235,236,-1,177,235,143,-1,237,206,238,-1,206,237,239,-1,184,180,133,-1,184,240,180,-1,32,183,241,-1,134,183,32,-1,140,143,141,-1,144,143,140,-1,182,175,240,-1,139,175,182,-1,181,242,140,-1,181,243,242,-1,244,245,29,-1,244,207,245,-1,16,177,17,-1,16,235,177,-1,172,146,176,-1,172,233,146,-1,149,246,247,-1,232,246,149,-1,210,33,243,-1,210,213,33,-1,183,2,248,-1,136,2,183,-1,7,184,132,-1,7,249,184,-1,103,250,251,-1,103,191,250,-1,252,64,58,-1,190,64,252,-1,95,253,99,-1,95,254,253,-1,71,114,130,-1,81,114,71,-1,88,67,66,-1,88,90,67,-1,116,128,119,-1,116,127,128,-1,60,255,256,-1,199,255,60,-1,257,30,258,-1,122,30,257,-1,259,252,256,-1,260,252,259,-1,124,72,69,-1,72,124,185,-1,261,200,262,-1,261,68,200,-1,204,124,123,-1,204,251,124,-1,263,199,67,-1,263,255,199,-1,264,265,246,-1,266,265,264,-1,266,188,80,-1,266,120,188,-1,267,189,107,-1,267,268,189,-1,52,269,270,-1,269,52,77,-1,77,109,269,-1,77,86,109,-1,189,75,108,-1,189,76,75,-1,271,118,117,-1,118,271,227,-1,272,65,190,-1,272,273,65,-1,273,196,65,-1,273,274,196,-1,273,96,274,-1,194,46,205,-1,46,194,193,-1,275,276,277,-1,221,276,275,-1,278,102,101,-1,279,102,278,-1,280,100,92,-1,280,101,100,-1,196,92,91,-1,280,92,196,-1,98,281,195,-1,98,282,281,-1,93,63,65,-1,93,283,63,-1,195,274,96,-1,274,195,281,-1,217,284,285,-1,284,217,219,-1,279,194,102,-1,194,279,192,-1,221,197,276,-1,223,197,221,-1,46,198,131,-1,193,198,46,-1,92,103,50,-1,92,100,103,-1,276,193,192,-1,193,276,197,-1,75,89,110,-1,75,74,89,-1,225,271,268,-1,271,225,227,-1,229,82,84,-1,286,82,229,-1,79,266,80,-1,266,79,265,-1,268,76,189,-1,271,76,268,-1,264,120,266,-1,83,120,264,-1,202,247,287,-1,247,202,55,-1,288,68,261,-1,288,66,68,-1,129,255,263,-1,129,289,255,-1,62,48,47,-1,48,62,125,-1,51,123,290,-1,51,204,123,-1,68,60,200,-1,68,199,60,-1,202,62,56,-1,202,201,62,-1,291,260,259,-1,292,260,291,-1,257,293,122,-1,293,257,291,-1,66,294,203,-1,294,66,288,-1,81,295,79,-1,81,71,295,-1,95,292,254,-1,95,94,292,-1,58,63,59,-1,64,63,58,-1,50,251,204,-1,50,103,251,-1,186,43,45,-1,296,43,186,-1,248,1,142,-1,2,1,248,-1,213,34,33,-1,213,166,34,-1,148,232,149,-1,155,232,148,-1,153,176,26,-1,153,172,176,-1,145,170,177,-1,38,170,145,-1,42,20,41,-1,20,42,28,-1,237,140,242,-1,237,144,140,-1,30,245,258,-1,30,29,245,-1,243,35,242,-1,243,33,35,-1,241,27,32,-1,208,27,241,-1,241,248,297,-1,183,248,241,-1,240,249,182,-1,184,249,240,-1,244,28,42,-1,28,244,29,-1,236,25,208,-1,235,25,236,-1,171,231,157,-1,234,231,171,-1,209,298,11,-1,226,298,209,-1,18,153,19,-1,18,154,153,-1,299,230,298,-1,299,229,230,-1,13,18,15,-1,13,12,18,-1,298,225,299,-1,226,225,298,-1,36,9,37,-1,36,10,9,-1,2,160,0,-1,2,136,160,-1,211,300,220,-1,300,211,222,-1,5,132,164,-1,7,132,5,-1,163,223,161,-1,163,301,223,-1,302,218,303,-1,302,216,218,-1,304,0,160,-1,304,178,0,-1,215,98,167,-1,98,215,282,-1,99,195,95,-1,195,99,98,-1,303,215,214,-1,303,218,215,-1,169,304,160,-1,169,305,304,-1,4,305,169,-1,3,305,4,-1,165,302,3,-1,165,220,302,-1,222,275,300,-1,222,221,275,-1,44,164,132,-1,44,162,164,-1,304,212,178,-1,214,212,304,-1,214,168,212,-1,178,213,210,-1,212,213,178,-1,118,224,21,-1,118,227,224,-1,152,209,13,-1,209,152,173,-1,151,18,12,-1,154,18,151,-1,234,84,83,-1,234,228,84,-1,8,224,173,-1,21,224,8,-1,230,159,158,-1,230,228,159,-1,232,264,246,-1,232,231,264,-1,144,238,145,-1,238,144,237,-1,31,134,32,-1,306,134,31,-1,141,236,297,-1,143,236,141,-1,240,150,180,-1,175,150,240,-1,207,307,245,-1,34,307,207,-1,35,244,239,-1,244,35,207,-1,206,36,238,-1,10,36,206,-1,235,19,25,-1,16,19,235,-1,233,147,146,-1,233,156,147,-1,253,97,99,-1,97,253,307,-1,179,243,181,-1,179,210,243,-1,249,6,306,-1,7,6,249,-1,48,191,205,-1,191,48,250,-1,283,51,308,-1,283,49,51,-1,260,190,252,-1,272,190,260,-1,246,287,247,-1,246,265,287,-1,53,270,121,-1,52,270,53,-1,90,263,67,-1,90,126,263,-1,289,256,255,-1,289,259,256,-1,254,258,253,-1,254,257,258,-1,256,58,60,-1,252,58,256,-1,262,187,261,-1,187,262,290,-1,262,59,308,-1,59,262,200,-1,251,185,124,-1,251,250,185,-1,128,289,129,-1,128,293,289,-1,295,73,201,-1,295,71,73,-1,112,267,107,-1,286,267,112,-1,294,269,111,-1,269,294,270,-1,188,87,113,-1,87,188,85,-1,111,203,294,-1,203,111,110,-1,110,88,203,-1,89,88,110,-1,279,284,277,-1,279,278,284,-1,219,277,284,-1,275,277,219,-1,301,131,198,-1,296,131,301,-1,309,101,280,-1,309,278,101,-1,274,280,196,-1,309,280,274,-1,282,285,281,-1,282,217,285,-1,94,273,272,-1,273,94,96,-1,281,309,274,-1,285,309,281,-1,285,278,309,-1,284,278,285,-1,223,198,197,-1,301,198,223,-1,205,104,194,-1,205,191,104,-1,277,192,279,-1,277,276,192,-1,91,283,93,-1,283,91,49,-1,74,126,89,-1,126,74,106,-1,225,267,299,-1,225,268,267,-1,109,111,269,-1,108,111,109,-1,299,286,229,-1,299,267,286,-1,271,105,76,-1,271,117,105,-1,85,286,112,-1,82,286,85,-1,115,86,77,-1,87,86,115,-1,287,201,202,-1,287,295,201,-1,121,261,187,-1,121,288,261,-1,127,293,128,-1,127,122,293,-1,250,125,185,-1,250,48,125,-1,308,290,262,-1,308,51,290,-1,70,290,123,-1,70,187,290,-1,254,291,257,-1,254,292,291,-1,293,259,289,-1,293,291,259,-1,126,129,263,-1,126,106,129,-1,270,288,121,-1,270,294,288,-1,265,295,287,-1,265,79,295,-1,292,272,260,-1,94,272,292,-1,63,308,59,-1,63,283,308,-1,131,186,61,-1,131,296,186,-1,306,135,134,-1,6,135,306,-1,1,181,142,-1,1,179,181,-1,34,97,307,-1,166,97,34,-1,148,156,155,-1,156,148,147,-1,19,26,25,-1,19,153,26,-1,238,38,145,-1,36,38,238,-1,242,239,237,-1,239,242,35,-1,258,307,253,-1,307,258,245,-1,180,174,137,-1,150,174,180,-1,208,297,236,-1,208,241,297,-1,142,297,248,-1,142,141,297,-1,182,306,31,-1,249,306,182,-1,57,45,137,-1,186,45,57,-1,239,42,206,-1,42,239,244,-1,138,146,139,-1,176,146,138,-1,247,174,149,-1,247,55,174,-1,234,264,231,-1,234,83,264,-1,158,298,230,-1,298,158,11,-1,20,118,21,-1,20,39,118,-1,22,156,233,-1,157,156,22,-1,24,171,22,-1,24,159,171,-1,12,158,151,-1,12,11,158,-1,170,14,17,-1,170,37,14,-1,216,220,300,-1,302,220,216,-1,300,219,216,-1,300,275,219,-1,43,301,163,-1,43,296,301,-1,3,303,305,-1,302,303,3,-1,305,214,304,-1,305,303,214,-1,218,282,215,-1,282,218,217,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t5disc_Coord',point=[(.40313,48.4809,-2.86293),(.48601,48.5171,-2.93993),(.5017,48.48128,-2.87432),(.30476,48.41099,-2.57578),(.3943,48.43267,-2.55429),(.33784,48.42172,-2.45161),(.42716,48.42233,-2.55812),(.37533,48.41593,-2.44883),(.22262,48.68036,-2.94988),(.34661,48.69746,-2.97109),(.34061,48.70111,-3.02381),(.24316,48.67357,-2.61133),(.34147,48.66734,-2.66149),(.35122,48.70782,-2.7572),(.43921,48.71034,-2.88554),(.46284,48.69403,-2.77726),(.55727,48.67486,-2.8193),(.53085,48.70106,-2.90203),(.44111,48.64386,-2.68401),(.55472,48.62171,-2.67182),(.10512,48.69697,-2.96907),(.11379,48.67888,-2.91725),(.35832,48.57281,-2.36514),(.39412,48.59421,-2.43032),(.34732,48.59521,-2.42336),(.55967,48.61461,-2.67225),(.51926,48.59869,-2.57407),(.5325,48.53932,-2.57957),(.1049,48.69422,-2.97709),(.10997,48.65851,-2.99966),(0,48.63571,-2.98559),(.46785,48.46423,-2.51207),(.51098,48.4817,-2.62048),(.29711,48.58628,-3.03957),(.22203,48.57002,-3.03469),(.31153,48.62242,-3.04767),(.42897,48.70669,-3.00727),(.43515,48.70889,-2.96749),(.47943,48.70766,-2.98793),(0,48.68129,-2.96167),(0,48.67667,-2.96915),(.22019,48.7116,-3.00088),(.21851,48.70864,-3.00815),(.07248,48.32111,-2.16647),(.17775,48.34737,-2.22701),(.07492,48.32411,-2.15793),(-.17775,48.34737,-2.23237),(-.18221,48.34956,-2.22359),(-.28066,48.38683,-2.32546),(-.50043,48.44981,-2.79588),(-.47057,48.43388,-2.6801),(-.50895,48.45368,-2.79353),(-.51514,48.60572,-2.59103),(-.51926,48.59869,-2.59039),(-.46908,48.57358,-2.45947),(0,48.41273,-2.11717),(-.10206,48.37073,-2.14265),(0,48.36184,-2.12111),(-.43273,48.57923,-3.02325),(-.49459,48.52249,-2.95091),(-.45264,48.6181,-3.02923),(-.07492,48.32411,-2.1602),(-.22001,48.39073,-2.20046),(-.48601,48.5171,-2.95101),(-.42731,48.57136,-3.0187),(-.35343,48.49688,-2.92062),(-.5362,48.69522,-2.91837),(-.48404,48.7019,-3.00475),(-.53535,48.6381,-2.93559),(-.47485,48.51727,-2.48928),(-.5325,48.53932,-2.59455),(-.29445,48.51814,-2.26958),(-.42706,48.49874,-2.38063),(-.31423,48.4663,-2.28638),(-.34661,48.69746,-2.98013),(-.34635,48.70729,-2.90165),(-.23158,48.70601,-2.8838),(-.42939,48.61188,-2.55361),(-.46223,48.58077,-2.48825),(-.22673,48.50954,-2.21305),(-.25387,48.5344,-2.27366),(-.29239,48.52546,-2.27221),(-.1262,48.58712,-2.37803),(0,48.54556,-2.27399),(0,48.57147,-2.35297),(-.23688,48.59226,-2.42174),(-.34748,48.62574,-2.53767),(-.3603,48.59521,-2.40886),(-.52401,48.70153,-2.92437),(-.43515,48.70889,-2.97863),(-.47943,48.70766,-2.99959),(-.43619,48.45817,-2.80712),(-.42784,48.45441,-2.68007),(-.40313,48.4809,-2.87267),(-.22283,48.56109,-3.03514),(-.13121,48.56239,-3.01529),(-.23087,48.48949,-2.93684),(.13121,48.56239,-3.01211),(0,48.47024,-2.92036),(0,48.53303,-2.99479),(-.3943,48.43267,-2.5652),(-.30476,48.41099,-2.58418),(-.27675,48.39246,-2.47287),(-.42716,48.42233,-2.56971),(-.33784,48.42172,-2.46141),(-.22262,48.68036,-2.95589),(-.34061,48.70111,-3.03237),(-.24316,48.67357,-2.61923),(-.35122,48.70782,-2.76777),(-.34147,48.66734,-2.67287),(-.44976,48.71034,-2.89727),(-.45199,48.69403,-2.79042),(-.23726,48.63145,-2.52107),(-.37172,48.57281,-2.35279),(-.40613,48.55851,-2.3815),(-.39412,48.59421,-2.44388),(-.10512,48.69697,-2.97194),(-.11379,48.67888,-2.92043),(0,48.67486,-2.89077),(-.22019,48.7116,-3.00671),(-.1261,48.55604,-2.32317),(-.55967,48.61461,-2.68786),(-.10997,48.65851,-3.00252),(-.51098,48.4817,-2.63414),(-.46785,48.46423,-2.52525),(-.31273,48.41987,-2.29164),(-.42897,48.70669,-3.01793),(-.1049,48.69422,-2.97993),(-.21851,48.70864,-3.01389),(-.33975,48.69626,-3.03979),(-.40925,48.55142,-2.38089),(-.07248,48.32111,-2.16865),(.2733,48.38507,-2.32434),(.18221,48.34956,-2.21808),(.47905,48.43603,-2.66459),(.47057,48.43388,-2.66804),(.50043,48.44981,-2.78385),(.10206,48.37073,-2.1389),(.4756,48.51727,-2.50322),(.41167,48.49874,-2.39322),(.45264,48.6181,-3.01877),(.52028,48.57731,-2.93549),(.49459,48.52249,-2.93963),(.53535,48.6381,-2.92252),(.46685,48.66237,-3.01168),(.48404,48.7019,-2.9931),(.40925,48.55142,-2.36612),(.29445,48.51814,-2.25581),(.22895,48.50166,-2.1941),(.13537,48.48242,-2.16418),(.22424,48.44468,-2.19698),(.34748,48.62574,-2.52573),(.34635,48.70729,-2.89204),(.51514,48.60572,-2.57476),(.42939,48.61188,-2.53938),(.22673,48.50954,-2.19793),(.29239,48.52546,-2.25812),(.25387,48.5344,-2.25837),(.24612,48.63145,-2.48331),(.23688,48.59226,-2.40963),(.43619,48.45817,-2.79641),(.08945,48.34993,-2.27774),(.15935,48.35775,-2.26217),(.08739,48.34441,-2.23471),(.2358,48.38615,-2.32454),(.27675,48.39246,-2.46494),(.22283,48.56109,-3.02989),(.1306,48.47709,-2.93494),(.23087,48.48949,-2.93126),(.42784,48.45441,-2.66881),(.52401,48.70153,-2.9109),(.24378,48.56745,-2.33484),(.46223,48.58077,-2.47257),(.23158,48.70601,-2.87715),(.11823,48.42719,-2.15279),(.31423,48.4663,-2.27503),(.46569,48.57358,-2.47187),(.5362,48.69522,-2.90464),(.35343,48.49688,-2.91215),(.42731,48.57136,-3.00893),(.22001,48.39073,-2.19326),(.43273,48.57923,-3.01336),(.41645,48.45139,-2.40274),(.50895,48.45368,-2.78128),(.28066,48.38683,-2.31708),(-.41645,48.45139,-2.41504),(0,48.31341,-2.14059),(-.55745,48.55795,-2.72133),(-.24378,48.56745,-2.34926),(-.23767,48.70483,-2.74763),(-.37374,48.58298,-3.03159),(-.37533,48.41593,-2.45959),(-.17171,48.36977,-2.33896),(-.15935,48.35775,-2.26698),(-.2358,48.38615,-2.33162),(-.1306,48.47709,-2.93811),(-.34338,48.44624,-2.82338),(-.08945,48.34993,-2.28043),(-.08739,48.34441,-2.23736),(-.46685,48.66237,-3.02278),(-.52028,48.57731,-2.94767),(-.22424,48.44468,-2.20749),(-.11823,48.42719,-2.15974),(-.53085,48.70106,-2.91572),(-.47905,48.43603,-2.67686),(-.2733,48.38507,-2.33249),(.33975,48.69626,-3.03132),(.21846,48.61703,-3.03675),(.55745,48.55795,-2.7066),(.23767,48.70483,-2.74024),(.37374,48.58298,-3.02293),(.17171,48.36977,-2.33383),(.29333,48.49722,-2.92835),(.29771,48.57732,-3.03401),(.22685,48.44221,-2.82682),(.12696,48.44279,-2.8373),(.11415,48.38335,-2.60633),(0,48.39843,-2.7325),(.12137,48.40785,-2.71894),(0,48.3777,-2.61983),(.19494,48.38043,-2.47871),(0,48.35368,-2.3588),(.09288,48.36127,-2.34389),(0,48.33509,-2.28905),(.11135,48.70209,-2.85538),(0,48.68479,-2.69247),(.12203,48.69665,-2.72178),(0,48.6982,-2.82334),(.12166,48.58712,-2.3952),(0,48.6137,-2.4509),(.12159,48.623,-2.49587),(.13038,48.52722,-2.23754),(.1345,48.49097,-2.17011),(.40613,48.55851,-2.36677),(.1261,48.55604,-2.31272),(.56246,48.66837,-2.82161),(.55968,48.60617,-2.84053),(.41207,48.66786,-3.02961),(.43123,48.7014,-3.01404),(.32542,48.66272,-3.04455),(.31273,48.41987,-2.28204),(.53934,48.50083,-2.74369),(.39395,48.62789,-3.03461),(.37511,48.59193,-3.02866),(.21684,48.66674,-3.02712),(.11865,48.61436,-3.0137),(0,48.47873,-2.1337),(0,48.46945,-2.12733),(.5099,48.48607,-2.87369),(.3831,48.41745,-2.44203),(-.3831,48.41745,-2.45303),(-.43572,48.424,-2.56567),(-.37511,48.59193,-3.03735),(0,48.54252,-2.99892),(-.12875,48.57167,-3.01906),(-.41289,48.66786,-3.03949),(-.39395,48.62789,-3.04384),(-.11865,48.61436,-3.01667),(0,48.58736,-2.99623),(-.31153,48.62242,-3.05504),(-.29711,48.58628,-3.04652),(-.55968,48.60617,-2.85458),(-.54121,48.54202,-2.87184),(-.43123,48.7014,-3.02466),(0,48.51965,-2.1925),(-.1345,48.49097,-2.18076),(-.13038,48.52722,-2.2487),(-.12482,48.66301,-2.5985),(-.12203,48.69665,-2.72565),(-.45759,48.64386,-2.6648),(-.55472,48.62171,-2.6874),(-.11135,48.70209,-2.85866),(-.29771,48.57732,-3.04096),(-.29333,48.49722,-2.9354),(-.22685,48.44221,-2.83252),(0,48.36826,-2.50187),(-.09288,48.36127,-2.34666),(-.10586,48.37787,-2.49419),(-.20969,48.39735,-2.5979),(-.19494,48.38043,-2.48429),(-.32715,48.42789,-2.69432),(-.12696,48.44279,-2.84051),(0,48.43938,-2.84493),(-.5017,48.48128,-2.88595),(-.11415,48.38335,-2.60946),(-.12137,48.40785,-2.72215),(-.12614,48.623,-2.47407),(-.13537,48.48242,-2.17451),(-.56246,48.66837,-2.83644),(-.32542,48.66272,-3.05244),(-.53934,48.50083,-2.75721),(-.21846,48.61703,-3.04205),(-.22203,48.57002,-3.03993),(-.21684,48.66674,-3.0326),(-.55727,48.67486,-2.83411),(-.22895,48.50166,-2.20866),(0,48.31043,-2.1484),(.54121,48.54202,-2.85887),(.12482,48.66301,-2.59437),(0,48.65099,-2.57015),(.10586,48.37787,-2.49115),(0,48.32474,-2.21765),(.20969,48.39735,-2.59212),(.2199,48.41861,-2.70434),(.34338,48.44624,-2.81488),(.32715,48.42789,-2.6857),(.43572,48.424,-2.55384),(.12875,48.57167,-3.01593),(-.5099,48.48607,-2.88551),(-.2199,48.41861,-2.71016)]))),
        Shape(DEF='t6',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t6_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,31,33,34,-1,35,36,15,-1,37,38,15,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,59,60,57,-1,61,27,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,65,70,75,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,86,89,-1,90,91,92,-1,93,94,89,-1,85,87,95,-1,94,96,97,-1,94,98,96,-1,41,99,100,-1,101,102,103,-1,104,105,106,-1,42,105,107,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,116,45,117,-1,118,119,120,-1,117,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,135,-1,140,133,141,-1,142,143,144,-1,145,146,147,-1,148,149,147,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,162,163,164,-1,165,166,167,-1,168,169,165,-1,132,170,171,-1,172,173,174,-1,175,176,177,-1,178,179,180,-1,181,178,182,-1,183,184,185,-1,183,186,187,-1,188,189,190,-1,191,192,193,-1,194,192,190,-1,195,196,197,-1,198,199,200,-1,201,202,203,-1,204,197,205,-1,185,206,207,-1,208,13,209,-1,210,39,211,-1,121,5,119,-1,212,11,213,-1,111,214,43,-1,215,216,217,-1,215,218,106,-1,219,34,220,-1,87,221,222,-1,223,79,224,-1,225,214,226,-1,227,228,229,-1,230,231,232,-1,19,233,234,-1,208,209,235,-1,236,237,238,-1,121,118,122,-1,239,240,241,-1,242,243,240,-1,241,240,244,-1,245,136,131,-1,246,78,247,-1,248,249,128,-1,183,250,251,-1,252,253,254,-1,116,255,256,-1,46,45,257,-1,258,259,127,-1,260,261,262,-1,263,264,265,-1,266,245,267,-1,268,139,138,-1,269,270,271,-1,272,243,242,-1,273,28,274,-1,275,276,277,-1,278,279,255,-1,280,281,282,-1,283,284,281,-1,285,156,286,-1,287,288,289,-1,290,291,292,-1,293,44,43,-1,294,295,296,-1,297,298,299,-1,300,301,298,-1,302,303,304,-1,305,306,307,-1,308,309,310,-1,310,311,312,-1,280,313,306,-1,314,315,316,-1,317,318,319,-1,320,319,321,-1,322,323,324,-1,325,326,327,-1,328,329,330,-1,331,332,314,-1,333,334,335,-1,336,337,338,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,348,349,350,-1,351,352,353,-1,354,355,356,-1,357,358,359,-1,360,361,362,-1,363,364,365,-1,366,367,368,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,143,381,316,-1,382,383,384,-1,385,386,387,-1,388,0,389,-1,330,390,391,-1,392,393,394,-1,392,395,396,-1,397,398,399,-1,400,401,402,-1,403,404,405,-1,403,406,404,-1,407,408,409,-1,410,411,412,-1,409,413,296,-1,414,415,416,-1,417,418,394,-1,419,420,400,-1,421,422,423,-1,338,424,425,-1,351,359,358,-1,357,426,348,-1,427,428,429,-1,430,431,432,-1,431,433,432,-1,434,435,436,-1,435,434,437,-1,438,439,435,-1,440,441,442,-1,443,379,378,-1,379,444,445,-1,446,380,447,-1,351,358,448,-1,449,450,451,-1,452,453,454,-1,356,455,456,-1,321,319,318,-1,457,396,395,-1,458,433,459,-1,460,461,299,-1,462,463,387,-1,464,465,466,-1,467,468,469,-1,470,471,472,-1,470,473,471,-1,333,474,475,-1,475,476,477,-1,478,479,480,-1,346,481,336,-1,482,483,344,-1,341,484,485,-1,486,487,488,-1,488,489,490,-1,491,492,493,-1,342,494,495,-1,496,497,498,-1,499,500,501,-1,347,425,502,-1,345,347,502,-1,503,504,498,-1,505,506,507,-1,508,505,489,-1,508,509,510,-1,511,512,513,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,523,524,525,-1,526,527,399,-1,528,529,530,-1,531,532,402,-1,420,533,534,-1,535,403,536,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,543,546,544,-1,547,548,549,-1,550,551,552,-1,388,458,459,-1,2,553,554,-1,555,556,557,-1,553,2,1,-1,558,559,560,-1,325,561,554,-1,554,562,325,-1,563,374,564,-1,565,300,566,-1,300,567,566,-1,310,568,60,-1,569,570,571,-1,52,51,572,-1,573,574,575,-1,407,576,577,-1,520,578,579,-1,560,559,580,-1,581,560,580,-1,582,583,584,-1,535,520,584,-1,406,585,586,-1,585,587,588,-1,563,564,589,-1,590,591,592,-1,593,594,384,-1,595,596,597,-1,421,598,584,-1,599,600,601,-1,602,603,604,-1,605,595,606,-1,607,608,600,-1,609,610,595,-1,383,582,377,-1,589,564,611,-1,612,613,589,-1,612,593,376,-1,487,377,614,-1,615,616,617,-1,499,618,619,-1,620,621,51,-1,569,548,622,-1,373,309,308,-1,566,60,568,-1,623,305,307,-1,309,373,624,-1,558,625,580,-1,626,627,628,-1,561,323,629,-1,630,557,631,-1,632,633,634,-1,635,1,636,-1,459,636,1,-1,637,622,548,-1,546,638,544,-1,639,640,641,-1,637,642,532,-1,398,643,644,-1,528,645,646,-1,647,399,398,-1,397,419,400,-1,648,91,649,-1,526,647,645,-1,523,650,651,-1,523,652,650,-1,578,522,509,-1,653,654,101,-1,655,656,657,-1,658,512,659,-1,658,659,660,-1,500,499,498,-1,574,342,495,-1,417,661,492,-1,418,497,495,-1,485,343,339,-1,144,315,662,-1,480,456,455,-1,477,476,663,-1,664,475,477,-1,665,476,666,-1,143,316,315,-1,667,668,669,-1,471,473,469,-1,462,387,386,-1,670,460,298,-1,461,472,671,-1,303,302,672,-1,673,674,463,-1,675,354,442,-1,676,677,457,-1,356,456,370,-1,678,679,454,-1,450,449,452,-1,450,441,438,-1,451,438,680,-1,443,366,444,-1,443,437,434,-1,433,681,440,-1,486,682,458,-1,432,433,458,-1,683,681,431,-1,684,431,430,-1,685,357,430,-1,686,687,353,-1,688,365,364,-1,689,352,445,-1,540,639,690,-1,691,692,382,-1,534,521,520,-1,498,497,417,-1,414,416,604,-1,693,407,694,-1,695,696,697,-1,698,699,697,-1,637,538,700,-1,701,702,400,-1,541,703,704,-1,410,412,500,-1,409,705,412,-1,323,330,629,-1,706,466,465,-1,674,707,463,-1,707,387,463,-1,708,382,502,-1,496,619,573,-1,497,418,417,-1,709,390,710,-1,390,329,375,-1,711,391,390,-1,712,713,714,-1,715,369,636,-1,716,717,474,-1,366,368,689,-1,689,444,366,-1,360,443,361,-1,678,448,358,-1,348,350,428,-1,494,342,483,-1,718,339,343,-1,719,424,720,-1,333,664,314,-1,347,338,425,-1,346,712,721,-1,331,664,722,-1,376,723,724,-1,626,375,329,-1,725,613,612,-1,634,633,630,-1,320,494,726,-1,662,315,314,-1,280,306,311,-1,312,311,305,-1,727,631,728,-1,729,464,671,-1,730,731,295,-1,617,732,296,-1,408,407,577,-1,733,734,735,-1,736,290,288,-1,737,259,738,-1,739,286,153,-1,740,153,741,-1,161,160,742,-1,59,743,283,-1,149,159,744,-1,262,261,745,-1,746,279,278,-1,747,67,748,-1,64,749,750,-1,272,747,229,-1,751,261,260,-1,734,738,46,-1,116,256,125,-1,267,245,752,-1,753,754,252,-1,168,755,756,-1,757,174,198,-1,251,758,186,-1,759,204,760,-1,250,761,762,-1,763,171,764,-1,765,766,767,-1,242,239,768,-1,184,769,770,-1,143,142,381,-1,235,23,22,-1,771,152,151,-1,76,772,77,-1,229,228,240,-1,773,774,775,-1,775,776,777,-1,778,93,86,-1,95,779,780,-1,781,782,783,-1,781,783,33,-1,225,293,43,-1,784,226,110,-1,293,225,292,-1,212,213,785,-1,786,787,788,-1,789,95,790,-1,225,791,288,-1,792,17,16,-1,793,794,795,-1,252,198,796,-1,197,196,253,-1,796,200,194,-1,187,797,798,-1,799,187,798,-1,798,800,178,-1,801,179,188,-1,769,184,183,-1,206,185,184,-1,802,182,803,-1,804,206,805,-1,182,180,177,-1,177,172,806,-1,170,132,169,-1,278,166,165,-1,167,777,776,-1,190,78,807,-1,286,158,154,-1,742,152,163,-1,157,148,808,-1,146,148,147,-1,809,260,138,-1,810,135,140,-1,811,134,812,-1,813,268,814,-1,257,815,735,-1,191,816,817,-1,40,816,818,-1,255,116,819,-1,5,121,237,-1,820,821,114,-1,822,264,263,-1,263,752,822,-1,114,791,226,-1,823,3,5,-1,818,824,825,-1,826,110,112,-1,827,825,828,-1,42,107,112,-1,105,104,108,-1,105,216,106,-1,829,830,831,-1,832,833,49,-1,832,834,833,-1,835,836,837,-1,835,838,839,-1,100,39,41,-1,840,841,842,-1,96,843,844,-1,93,845,98,-1,846,847,90,-1,848,846,849,-1,779,850,780,-1,790,851,210,-1,210,851,35,-1,852,853,220,-1,223,793,854,-1,855,856,857,-1,858,859,860,-1,247,77,69,-1,71,763,247,-1,861,862,275,-1,74,73,276,-1,227,748,63,-1,863,270,864,-1,749,865,66,-1,866,750,749,-1,765,767,58,-1,60,867,868,-1,767,743,58,-1,869,859,54,-1,620,51,870,-1,829,44,871,-1,872,873,874,-1,113,237,236,-1,875,287,876,-1,877,291,878,-1,817,816,40,-1,21,273,271,-1,781,33,30,-1,29,26,25,-1,768,37,22,-1,609,605,879,-1,880,881,12,-1,882,19,605,-1,883,212,884,-1,713,610,609,-1,120,4,885,-1,886,252,796,-1,885,3,774,-1,77,772,75,-1,210,35,39,-1,885,4,3,-1,796,887,886,-1,228,244,240,-1,609,129,713,-1,706,230,888,-1,883,884,14,-1,19,879,605,-1,12,889,880,-1,879,890,609,-1,21,768,22,-1,768,38,37,-1,25,27,29,-1,273,29,28,-1,271,768,21,-1,40,891,817,-1,877,892,291,-1,287,289,876,-1,113,236,820,-1,872,893,873,-1,829,894,44,-1,895,832,48,-1,896,620,870,-1,869,860,859,-1,868,57,60,-1,66,866,749,-1,864,897,863,-1,63,65,227,-1,276,898,74,-1,861,275,277,-1,247,69,71,-1,247,78,77,-1,899,900,901,-1,860,902,858,-1,855,857,903,-1,223,854,79,-1,220,783,852,-1,222,904,905,-1,851,781,35,-1,210,906,790,-1,779,907,850,-1,848,849,908,-1,847,909,90,-1,93,98,94,-1,96,844,910,-1,840,911,841,-1,100,211,39,-1,895,835,837,-1,831,912,829,-1,107,105,108,-1,828,99,827,-1,825,827,818,-1,818,913,824,-1,5,115,823,-1,114,821,791,-1,752,18,822,-1,113,820,114,-1,237,113,5,-1,116,117,819,-1,816,914,818,-1,734,257,735,-1,267,126,128,-1,268,915,814,-1,811,169,134,-1,140,916,810,-1,809,138,810,-1,146,808,148,-1,157,808,158,-1,286,154,153,-1,190,192,78,-1,167,166,777,-1,165,917,278,-1,169,168,170,-1,177,176,172,-1,177,803,182,-1,802,803,770,-1,206,184,770,-1,183,799,769,-1,188,807,801,-1,181,798,178,-1,799,798,181,-1,192,191,76,-1,194,887,796,-1,205,197,253,-1,252,754,198,-1,918,757,919,-1,920,899,921,-1,793,223,794,-1,16,922,792,-1,288,292,225,-1,790,906,789,-1,786,914,787,-1,292,923,293,-1,218,924,106,-1,43,214,225,-1,925,221,87,-1,781,851,782,-1,780,790,95,-1,86,85,778,-1,926,927,928,-1,926,929,927,-1,775,777,773,-1,784,823,115,-1,240,243,229,-1,76,241,772,-1,930,771,151,-1,22,208,235,-1,769,802,770,-1,271,242,768,-1,766,62,767,-1,764,247,763,-1,762,251,250,-1,759,195,204,-1,756,170,168,-1,918,203,804,-1,252,254,753,-1,752,263,267,-1,45,116,125,-1,46,257,734,-1,751,260,931,-1,811,746,917,-1,129,268,813,-1,138,262,915,-1,915,268,138,-1,229,243,272,-1,750,932,64,-1,229,747,748,-1,933,166,278,-1,278,917,746,-1,261,142,745,-1,313,280,282,-1,59,283,281,-1,59,58,743,-1,160,150,742,-1,934,740,741,-1,740,739,153,-1,737,738,734,-1,290,292,288,-1,733,737,734,-1,296,413,617,-1,295,294,730,-1,464,299,671,-1,727,935,631,-1,936,312,305,-1,726,319,320,-1,494,483,726,-1,328,322,324,-1,724,725,612,-1,328,626,329,-1,612,376,724,-1,721,937,346,-1,334,333,314,-1,424,337,720,-1,343,574,718,-1,342,344,483,-1,428,684,348,-1,426,359,349,-1,678,453,448,-1,360,366,443,-1,938,939,481,-1,715,636,459,-1,714,940,712,-1,375,710,390,-1,709,710,487,-1,666,476,941,-1,496,573,575,-1,590,942,943,-1,590,592,942,-1,382,944,502,-1,465,945,706,-1,330,391,629,-1,412,694,409,-1,500,504,410,-1,704,542,541,-1,946,701,400,-1,946,400,402,-1,700,622,637,-1,697,696,698,-1,515,695,697,-1,505,658,506,-1,732,617,602,-1,604,947,414,-1,498,417,948,-1,520,535,534,-1,382,708,691,-1,639,550,690,-1,445,444,689,-1,688,427,365,-1,353,949,686,-1,430,950,685,-1,348,684,430,-1,683,951,681,-1,458,682,432,-1,486,952,682,-1,440,953,433,-1,434,361,443,-1,379,443,444,-1,451,680,446,-1,438,451,450,-1,675,450,452,-1,454,453,678,-1,370,369,356,-1,676,457,321,-1,354,715,442,-1,672,468,303,-1,671,299,461,-1,670,298,301,-1,304,462,386,-1,669,473,667,-1,954,955,956,-1,315,144,143,-1,666,957,665,-1,477,722,664,-1,663,940,477,-1,480,665,456,-1,129,714,713,-1,485,958,343,-1,320,959,494,-1,418,495,959,-1,491,948,417,-1,417,492,491,-1,574,495,575,-1,500,498,504,-1,411,659,693,-1,658,960,512,-1,576,512,511,-1,513,698,511,-1,101,103,653,-1,508,578,509,-1,526,645,961,-1,648,962,91,-1,397,400,702,-1,398,644,647,-1,528,646,529,-1,398,963,643,-1,964,701,946,-1,965,966,967,-1,639,542,640,-1,546,968,638,-1,548,642,637,-1,459,1,0,-1,635,636,371,-1,634,969,632,-1,630,970,557,-1,629,554,561,-1,626,628,723,-1,580,559,558,-1,580,625,327,-1,623,936,305,-1,566,867,60,-1,622,971,569,-1,621,572,51,-1,655,972,973,-1,619,496,499,-1,615,974,616,-1,377,975,614,-1,593,377,376,-1,406,403,585,-1,593,612,589,-1,589,594,593,-1,589,611,590,-1,377,593,383,-1,582,975,377,-1,609,595,605,-1,607,600,976,-1,606,882,605,-1,602,604,416,-1,599,691,600,-1,584,583,421,-1,595,597,606,-1,593,384,383,-1,598,421,977,-1,421,978,977,-1,590,611,591,-1,563,589,613,-1,586,585,588,-1,586,700,406,-1,979,535,584,-1,975,582,584,-1,581,980,560,-1,980,981,560,-1,614,520,579,-1,576,982,577,-1,573,718,574,-1,572,983,52,-1,569,971,570,-1,568,310,309,-1,60,984,310,-1,563,326,374,-1,325,562,372,-1,710,377,487,-1,558,560,324,-1,1,635,553,-1,555,557,970,-1,554,629,2,-1,0,2,389,-1,388,459,0,-1,548,569,549,-1,540,542,639,-1,537,404,538,-1,92,985,986,-1,92,987,985,-1,536,534,535,-1,420,534,536,-1,402,401,531,-1,530,988,528,-1,399,647,526,-1,525,652,523,-1,101,989,990,-1,101,654,989,-1,522,578,520,-1,656,991,992,-1,517,973,518,-1,993,514,516,-1,511,698,696,-1,512,960,513,-1,576,659,512,-1,508,510,505,-1,660,659,411,-1,505,507,489,-1,503,498,994,-1,502,596,345,-1,618,499,501,-1,496,498,499,-1,494,959,495,-1,488,579,489,-1,339,341,485,-1,482,344,995,-1,480,455,478,-1,475,941,476,-1,333,475,664,-1,470,667,473,-1,472,461,470,-1,467,469,996,-1,297,464,466,-1,299,298,460,-1,433,953,459,-1,395,321,457,-1,318,676,321,-1,356,355,455,-1,452,449,453,-1,447,449,451,-1,451,446,447,-1,445,380,379,-1,437,443,378,-1,440,442,953,-1,435,680,438,-1,437,680,435,-1,458,388,486,-1,431,681,433,-1,430,432,950,-1,427,688,428,-1,348,430,357,-1,424,997,425,-1,998,999,550,-1,421,583,422,-1,705,296,295,-1,705,409,296,-1,419,533,420,-1,394,661,417,-1,994,498,493,-1,409,408,413,-1,699,698,1000,-1,407,409,694,-1,638,702,701,-1,405,536,403,-1,400,420,401,-1,399,1001,397,-1,1002,598,977,-1,977,1003,1002,-1,395,392,394,-1,410,504,503,-1,330,329,390,-1,389,709,388,-1,707,385,387,-1,382,384,944,-1,380,446,378,-1,375,377,710,-1,372,624,373,-1,369,371,636,-1,366,360,367,-1,365,1004,363,-1,426,357,359,-1,357,678,358,-1,354,1005,355,-1,348,426,349,-1,345,712,346,-1,342,574,343,-1,339,718,340,-1,337,424,338,-1,335,1006,333,-1,478,318,317,-1,129,813,331,-1,314,664,331,-1,322,328,330,-1,325,327,625,-1,322,330,323,-1,726,317,319,-1,334,314,316,-1,469,468,672,-1,312,308,310,-1,305,311,306,-1,303,462,304,-1,297,300,298,-1,464,297,299,-1,732,294,296,-1,291,923,292,-1,287,736,288,-1,286,739,285,-1,284,1007,281,-1,662,814,915,-1,255,933,278,-1,279,1008,255,-1,747,272,67,-1,274,269,273,-1,863,272,242,-1,271,273,269,-1,266,267,1009,-1,260,262,138,-1,259,737,127,-1,45,125,257,-1,255,1008,256,-1,252,886,253,-1,754,753,919,-1,251,186,183,-1,250,207,761,-1,250,185,207,-1,1010,809,1011,-1,247,764,246,-1,245,131,130,-1,772,241,244,-1,242,240,239,-1,241,817,239,-1,1012,916,140,-1,236,238,47,-1,209,822,235,-1,20,19,234,-1,771,164,152,-1,164,163,152,-1,230,232,1013,-1,229,748,227,-1,225,226,791,-1,79,1014,224,-1,222,95,87,-1,222,779,95,-1,219,869,34,-1,215,106,216,-1,217,912,215,-1,825,824,109,-1,290,10,291,-1,212,1015,11,-1,121,119,118,-1,208,1016,13,-1,290,213,10,-1,206,804,207,-1,205,760,204,-1,201,203,1017,-1,200,796,198,-1,197,204,195,-1,1018,886,887,-1,194,193,192,-1,193,787,191,-1,188,190,807,-1,187,799,183,-1,183,185,250,-1,182,802,181,-1,182,178,180,-1,180,175,177,-1,806,172,174,-1,170,764,171,-1,167,1019,165,-1,744,159,161,-1,156,158,286,-1,155,741,153,-1,742,150,152,-1,147,1020,145,-1,144,745,142,-1,140,141,1012,-1,138,135,810,-1,135,137,140,-1,134,169,132,-1,144,662,745,-1,127,1021,128,-1,123,125,256,-1,933,255,819,-1,122,819,117,-1,120,885,118,-1,885,1022,118,-1,45,238,117,-1,115,5,113,-1,109,826,112,-1,109,112,107,-1,895,1023,835,-1,1024,1025,1026,-1,1025,1027,1026,-1,101,1028,102,-1,41,827,99,-1,95,789,85,-1,89,86,93,-1,90,92,1029,-1,88,89,1030,-1,86,88,87,-1,904,222,221,-1,79,854,80,-1,869,219,905,-1,905,860,869,-1,78,192,76,-1,69,77,75,-1,75,227,65,-1,72,1031,73,-1,69,75,70,-1,66,865,67,-1,239,817,768,-1,64,1032,65,-1,766,1032,64,-1,62,932,61,-1,934,868,1033,-1,934,1034,868,-1,59,984,60,-1,54,859,55,-1,870,51,53,-1,48,832,49,-1,47,238,45,-1,42,44,894,-1,1035,1036,1037,-1,15,17,37,-1,15,39,35,-1,31,30,33,-1,32,1038,30,-1,27,61,28,-1,26,1039,24,-1,23,1040,21,-1,18,879,19,-1,15,928,16,-1,14,884,12,-1,10,213,11,-1,684,683,431,-1,39,891,40,-1,994,492,393,-1,994,493,492,-1,492,394,393,-1,661,394,492,-1,1041,901,1042,-1,1043,901,1041,-1,385,1044,1045,-1,385,930,1044,-1,467,162,673,-1,467,1046,162,-1,1047,145,668,-1,1047,1048,145,-1,1049,1050,1051,-1,1050,1049,1052,-1,1053,922,1054,-1,1053,883,922,-1,792,37,17,-1,37,792,1016,-1,752,879,18,-1,890,879,752,-1,1055,23,234,-1,1055,1040,23,-1,274,1035,269,-1,274,1036,1035,-1,1056,1038,32,-1,1057,1038,1056,-1,68,897,864,-1,68,1058,897,-1,864,1037,866,-1,1037,864,1035,-1,791,289,288,-1,791,821,289,-1,1059,873,893,-1,1060,873,1059,-1,872,1061,871,-1,872,874,1061,-1,874,50,1061,-1,50,874,1062,-1,55,53,56,-1,55,870,53,-1,1063,58,57,-1,58,1063,1064,-1,932,766,64,-1,932,62,766,-1,863,1058,272,-1,1058,863,897,-1,277,1065,1010,-1,277,276,1065,-1,276,1066,1065,-1,276,73,1066,-1,1031,1067,1068,-1,1031,155,1067,-1,1041,1069,1043,-1,1041,1070,1069,-1,921,901,1043,-1,921,899,901,-1,902,857,858,-1,903,857,902,-1,1071,903,925,-1,1071,855,903,-1,905,853,907,-1,905,220,853,-1,219,220,905,-1,849,224,908,-1,849,1072,224,-1,780,1073,782,-1,780,850,1073,-1,97,908,1074,-1,97,848,908,-1,649,90,909,-1,90,649,91,-1,909,990,649,-1,990,909,1075,-1,843,98,1076,-1,98,843,96,-1,100,911,840,-1,100,99,911,-1,1026,843,1077,-1,843,1026,844,-1,911,924,841,-1,911,1078,924,-1,1079,1080,1081,-1,1079,1082,1080,-1,835,1083,836,-1,1083,835,839,-1,837,832,895,-1,832,837,834,-1,1084,218,215,-1,1084,1085,218,-1,40,827,41,-1,40,818,827,-1,258,1086,259,-1,258,1087,1086,-1,166,819,777,-1,819,166,933,-1,914,913,818,-1,914,786,913,-1,914,191,787,-1,816,191,914,-1,248,746,1088,-1,248,1089,746,-1,1010,1090,809,-1,1090,1010,1065,-1,1091,1066,1068,-1,1091,1092,1066,-1,1091,1093,1094,-1,1091,1095,1093,-1,154,808,1096,-1,808,154,158,-1,1033,740,934,-1,1033,1013,740,-1,775,1097,776,-1,775,788,1097,-1,806,803,177,-1,806,805,803,-1,188,178,800,-1,178,188,179,-1,1098,798,797,-1,798,1098,800,-1,1097,194,200,-1,194,1097,193,-1,201,1099,195,-1,201,1017,1099,-1,758,886,1018,-1,758,1100,886,-1,199,174,173,-1,198,174,199,-1,1101,871,44,-1,1101,872,871,-1,872,1101,892,-1,1102,1043,1069,-1,1102,921,1043,-1,793,899,854,-1,793,795,899,-1,736,1103,785,-1,287,1103,736,-1,785,290,736,-1,290,785,213,-1,1081,1023,1104,-1,1080,1023,1081,-1,82,1073,850,-1,1073,82,1105,-1,884,785,1103,-1,884,212,785,-1,878,10,9,-1,10,878,291,-1,826,824,823,-1,826,109,824,-1,1106,831,833,-1,1106,1084,831,-1,102,836,1083,-1,102,1025,836,-1,1107,53,52,-1,1107,1056,53,-1,220,33,783,-1,34,33,220,-1,1071,1030,81,-1,1071,88,1030,-1,1108,1085,1109,-1,1085,1108,218,-1,36,928,15,-1,36,926,928,-1,774,788,775,-1,788,774,786,-1,763,1110,1111,-1,71,1110,763,-1,1044,151,1112,-1,1044,930,151,-1,1016,22,37,-1,1016,208,22,-1,1113,236,47,-1,236,1113,1114,-1,249,1088,1009,-1,249,248,1088,-1,1111,171,763,-1,141,171,1111,-1,124,1115,815,-1,1115,124,1116,-1,174,805,806,-1,174,757,805,-1,764,756,246,-1,756,764,170,-1,1117,124,123,-1,1117,1116,124,-1,762,205,1100,-1,760,205,762,-1,203,919,753,-1,203,918,919,-1,865,64,63,-1,64,865,749,-1,272,68,67,-1,272,1058,68,-1,861,1118,862,-1,1110,1118,861,-1,745,915,262,-1,915,745,662,-1,142,751,381,-1,261,751,142,-1,984,281,280,-1,984,59,281,-1,898,1119,1064,-1,1120,1119,898,-1,741,1034,934,-1,1034,741,72,-1,259,1113,738,-1,259,1086,1113,-1,618,1121,619,-1,618,1122,1121,-1,1123,1121,1124,-1,1123,1125,1121,-1,1126,556,565,-1,1126,557,556,-1,632,1127,1128,-1,1129,1127,632,-1,626,376,375,-1,626,723,376,-1,331,714,129,-1,331,722,714,-1,1130,721,479,-1,721,1130,937,-1,712,610,713,-1,345,610,712,-1,364,368,367,-1,368,364,363,-1,955,484,1131,-1,954,484,955,-1,954,485,484,-1,1132,955,1131,-1,1132,956,955,-1,459,442,715,-1,953,442,459,-1,666,717,1128,-1,666,941,717,-1,589,943,594,-1,589,590,943,-1,1124,997,1123,-1,1124,607,997,-1,1133,606,1134,-1,882,606,1133,-1,1135,945,465,-1,1045,945,1135,-1,957,456,665,-1,957,370,456,-1,1136,650,527,-1,1136,651,650,-1,541,1137,703,-1,1137,541,1138,-1,963,638,968,-1,638,963,702,-1,983,588,1139,-1,588,983,570,-1,1140,1141,1142,-1,1140,1143,1141,-1,515,1144,516,-1,697,1144,515,-1,960,505,510,-1,960,658,505,-1,1145,603,616,-1,1146,603,1145,-1,967,532,531,-1,532,967,966,-1,952,1147,1148,-1,490,1147,952,-1,642,547,964,-1,547,642,548,-1,978,1149,1150,-1,978,1151,1149,-1,540,1138,541,-1,540,690,1138,-1,641,543,998,-1,641,546,543,-1,994,506,503,-1,994,507,506,-1,363,686,949,-1,686,363,1004,-1,396,950,1152,-1,685,950,396,-1,683,436,951,-1,362,436,683,-1,675,441,450,-1,441,675,442,-1,675,1005,354,-1,452,1005,675,-1,462,468,463,-1,462,303,468,-1,1153,670,1154,-1,460,670,1153,-1,1155,668,667,-1,1155,1047,668,-1,1047,1156,1157,-1,1156,1047,1155,-1,381,6,335,-1,381,7,6,-1,941,474,717,-1,475,474,941,-1,480,476,665,-1,663,476,480,-1,712,663,721,-1,712,940,663,-1,576,693,659,-1,576,407,693,-1,576,514,982,-1,576,515,514,-1,515,576,695,-1,1158,1144,1159,-1,1158,1160,1144,-1,1143,655,1141,-1,656,655,1143,-1,1161,653,1140,-1,1161,654,653,-1,992,1082,1162,-1,1082,992,1163,-1,699,523,651,-1,1000,523,699,-1,1164,1161,1165,-1,1164,1166,1161,-1,1167,527,526,-1,1136,527,1167,-1,1168,989,1166,-1,1168,648,989,-1,645,1169,961,-1,645,528,1169,-1,525,521,1170,-1,525,522,521,-1,1001,419,397,-1,419,1001,1171,-1,988,987,962,-1,530,987,988,-1,643,646,644,-1,646,643,704,-1,964,532,642,-1,946,532,964,-1,946,402,532,-1,546,640,968,-1,641,640,546,-1,1172,1041,1173,-1,1070,1041,1172,-1,1154,555,1174,-1,555,1154,670,-1,1175,630,1176,-1,630,1175,970,-1,1176,633,716,-1,633,1176,630,-1,981,626,328,-1,981,627,626,-1,372,326,325,-1,326,372,374,-1,308,611,373,-1,308,591,611,-1,655,1177,972,-1,657,1177,655,-1,1178,1179,1180,-1,1178,1181,1179,-1,1180,1182,1183,-1,1182,1180,1179,-1,1184,1059,1185,-1,1184,1060,1059,-1,731,705,295,-1,501,705,731,-1,980,627,981,-1,980,628,627,-1,980,1186,628,-1,587,1139,588,-1,587,1187,1139,-1,1186,725,724,-1,980,725,1186,-1,384,943,1188,-1,594,943,384,-1,595,345,596,-1,595,610,345,-1,582,422,583,-1,582,692,422,-1,423,1189,1151,-1,1190,1189,423,-1,1146,604,603,-1,1146,1191,604,-1,947,1190,414,-1,947,1189,1190,-1,414,599,601,-1,414,1190,599,-1,422,1190,423,-1,422,599,1190,-1,1188,942,1134,-1,1188,943,942,-1,977,1150,1192,-1,977,978,1150,-1,725,581,1193,-1,725,980,581,-1,1139,1194,1107,-1,1139,1187,1194,-1,585,1002,587,-1,585,979,1002,-1,520,975,584,-1,614,975,520,-1,974,1145,616,-1,974,1195,1145,-1,573,340,718,-1,573,1125,340,-1,1179,1185,1182,-1,1185,1179,1184,-1,993,1183,514,-1,1183,993,1180,-1,518,1180,993,-1,518,1178,1180,-1,972,1181,1178,-1,1181,972,1177,-1,624,728,309,-1,624,727,728,-1,1193,580,327,-1,1193,581,580,-1,634,372,969,-1,634,624,372,-1,670,556,555,-1,670,301,556,-1,1174,970,1175,-1,970,1174,555,-1,549,571,1196,-1,549,569,571,-1,551,1041,1042,-1,1041,551,1173,-1,551,999,1173,-1,999,551,550,-1,545,547,549,-1,545,544,547,-1,539,637,532,-1,539,538,637,-1,967,1197,965,-1,967,1198,1197,-1,703,530,529,-1,530,703,1137,-1,537,405,404,-1,537,1199,405,-1,1137,987,530,-1,1137,985,987,-1,1170,534,533,-1,1170,521,534,-1,650,1171,1001,-1,652,1171,650,-1,1169,1166,1164,-1,1169,1168,1166,-1,1166,654,1161,-1,1166,989,654,-1,1158,1136,1167,-1,1159,1136,1158,-1,991,1163,992,-1,1163,991,1200,-1,1140,1165,1161,-1,1140,1142,1165,-1,1201,1158,1202,-1,1160,1158,1201,-1,519,993,516,-1,519,518,993,-1,696,576,511,-1,696,695,576,-1,1203,509,524,-1,510,509,1203,-1,502,597,596,-1,944,597,502,-1,959,321,395,-1,320,321,959,-1,490,507,1147,-1,490,489,507,-1,486,490,952,-1,486,488,490,-1,317,1204,1130,-1,1204,317,1205,-1,480,721,663,-1,721,480,479,-1,1206,1049,1207,-1,1006,1049,1206,-1,1006,1052,1049,-1,1155,1154,1156,-1,1155,1153,1154,-1,956,1208,954,-1,939,1208,956,-1,1209,1208,939,-1,1209,1210,1208,-1,1209,1211,1210,-1,470,460,1153,-1,470,461,460,-1,297,567,300,-1,466,567,297,-1,318,355,676,-1,355,478,455,-1,478,355,318,-1,447,453,449,-1,448,453,447,-1,438,440,439,-1,438,441,440,-1,435,951,436,-1,435,439,951,-1,1212,686,1004,-1,1212,687,686,-1,365,429,1004,-1,365,427,429,-1,1212,350,349,-1,1212,1213,350,-1,1214,360,362,-1,1214,367,360,-1,1196,1215,1216,-1,1196,621,1215,-1,639,998,550,-1,641,998,639,-1,1217,294,415,-1,1217,730,294,-1,732,415,294,-1,602,415,732,-1,415,602,416,-1,656,1162,657,-1,992,1162,656,-1,1199,967,531,-1,1199,1198,967,-1,415,601,1217,-1,414,601,415,-1,602,616,603,-1,602,617,616,-1,506,660,503,-1,658,660,506,-1,516,1160,519,-1,1144,1160,516,-1,1143,653,1218,-1,1140,653,1143,-1,983,1107,52,-1,1139,1107,983,-1,406,538,404,-1,406,700,538,-1,643,968,640,-1,968,643,963,-1,1159,651,1136,-1,1159,699,651,-1,598,979,584,-1,1002,979,598,-1,1148,393,392,-1,1148,1147,393,-1,567,867,566,-1,888,867,567,-1,383,692,582,-1,382,692,383,-1,619,1125,573,-1,619,1121,1125,-1,1130,938,937,-1,938,1130,1204,-1,1204,939,938,-1,1204,1209,939,-1,354,369,715,-1,354,356,369,-1,958,1210,995,-1,1210,958,1208,-1,688,367,1214,-1,688,364,367,-1,359,353,349,-1,353,359,351,-1,325,558,561,-1,325,625,558,-1,560,328,324,-1,560,981,328,-1,1219,632,969,-1,1219,1129,632,-1,335,316,381,-1,335,334,316,-1,1220,307,306,-1,307,1220,623,-1,565,301,300,-1,565,556,301,-1,1125,719,340,-1,1123,719,1125,-1,923,44,293,-1,44,923,1101,-1,72,1063,1034,-1,1063,72,74,-1,1221,283,1222,-1,1221,284,283,-1,282,24,313,-1,282,1222,24,-1,1032,862,1118,-1,1032,766,862,-1,61,274,28,-1,1223,274,61,-1,67,63,748,-1,67,865,63,-1,131,268,129,-1,131,139,268,-1,266,1088,812,-1,266,1009,1088,-1,890,245,130,-1,890,752,245,-1,203,207,804,-1,203,202,207,-1,1100,253,886,-1,205,253,1100,-1,248,1224,1089,-1,248,1225,1224,-1,1226,1021,733,-1,1227,1021,1226,-1,801,78,246,-1,801,807,78,-1,1011,1012,1228,-1,1012,1011,916,-1,1055,29,1040,-1,26,29,1055,-1,1087,1229,1086,-1,880,1229,1087,-1,19,1133,233,-1,19,882,1133,-1,231,1112,232,-1,231,1044,1112,-1,132,141,133,-1,141,132,171,-1,1230,1109,845,-1,1109,1230,1108,-1,1072,223,224,-1,1072,794,223,-1,925,88,1071,-1,925,87,88,-1,32,53,1056,-1,32,56,53,-1,837,1025,1024,-1,1025,837,836,-1,1084,912,831,-1,1084,215,912,-1,825,108,828,-1,109,108,825,-1,9,1145,878,-1,9,1146,1145,-1,122,1022,773,-1,122,118,1022,-1,1073,1231,852,-1,1073,1105,1231,-1,1104,1232,1081,-1,1232,1104,1062,-1,1233,1234,900,-1,1233,1235,1234,-1,856,80,920,-1,855,80,856,-1,824,3,823,-1,3,824,913,-1,758,187,186,-1,797,187,758,-1,776,173,167,-1,199,173,776,-1,753,1017,203,-1,1017,753,1099,-1,196,254,253,-1,196,1236,254,-1,194,189,887,-1,189,194,190,-1,179,175,180,-1,179,801,175,-1,755,175,756,-1,755,176,175,-1,744,742,163,-1,742,744,161,-1,1013,739,740,-1,739,1013,232,-1,155,1096,1067,-1,155,154,1096,-1,145,1237,146,-1,1237,145,1048,-1,1095,1048,1093,-1,1095,1237,1048,-1,8,381,751,-1,7,381,8,-1,809,916,1011,-1,809,810,916,-1,140,134,133,-1,140,137,134,-1,128,1009,267,-1,128,249,1009,-1,737,1021,127,-1,733,1021,737,-1,773,885,774,-1,1022,885,773,-1,1238,1081,1232,-1,1238,1079,1081,-1,1200,1083,839,-1,1200,1239,1083,-1,1076,1077,843,-1,1076,1240,1077,-1,101,1075,1028,-1,101,990,1075,-1,1075,847,1241,-1,847,1075,909,-1,910,97,96,-1,97,910,848,-1,906,1242,789,-1,1242,906,1243,-1,94,1074,89,-1,94,97,1074,-1,908,1014,1074,-1,1014,908,224,-1,1244,92,986,-1,1029,92,1244,-1,907,222,905,-1,222,907,779,-1,81,855,1071,-1,81,80,855,-1,920,1102,856,-1,920,921,1102,-1,620,1245,1246,-1,1245,620,896,-1,55,858,1247,-1,858,55,859,-1,73,1068,1066,-1,73,1031,1068,-1,72,155,1031,-1,741,155,72,-1,766,275,862,-1,765,275,766,-1,57,1034,1063,-1,57,868,1034,-1,1062,48,50,-1,1062,1104,48,-1,1061,49,830,-1,49,1061,50,-1,871,830,829,-1,871,1061,830,-1,738,47,46,-1,47,738,1113,-1,768,891,38,-1,768,817,891,-1,36,781,30,-1,36,35,781,-1,929,1038,1057,-1,929,926,1038,-1,273,1040,29,-1,273,21,1040,-1,1037,274,1223,-1,1036,274,1037,-1,1150,927,1192,-1,1248,927,1150,-1,1249,234,233,-1,234,1249,1055,-1,883,792,922,-1,14,792,883,-1,889,287,875,-1,287,889,1103,-1,1250,1054,1149,-1,1054,1250,1053,-1,1051,1251,1049,-1,1251,1051,1094,-1,668,1020,669,-1,668,145,1020,-1,673,164,674,-1,673,162,164,-1,1044,945,1045,-1,945,1044,231,-1,498,491,493,-1,948,491,498,-1,707,930,385,-1,707,771,930,-1,1252,467,996,-1,467,1252,1046,-1,1157,1048,1047,-1,1157,1093,1048,-1,11,1146,9,-1,1146,11,1191,-1,883,1015,212,-1,1015,883,1053,-1,1016,14,13,-1,1016,792,14,-1,209,12,881,-1,209,13,12,-1,1039,313,24,-1,313,1039,1253,-1,1194,1056,1107,-1,1056,1194,1057,-1,926,30,1038,-1,36,30,926,-1,38,39,15,-1,38,891,39,-1,1145,877,878,-1,1195,877,1145,-1,1195,893,877,-1,1059,893,1195,-1,873,1062,874,-1,873,1232,1062,-1,1247,870,55,-1,896,870,1247,-1,1007,1221,1254,-1,284,1221,1007,-1,1064,765,58,-1,1064,1119,765,-1,27,767,62,-1,767,27,25,-1,866,1223,750,-1,866,1037,1223,-1,1118,65,1032,-1,1118,70,65,-1,817,76,191,-1,817,241,76,-1,1228,1010,1011,-1,1228,277,1010,-1,1228,861,277,-1,1070,1245,1069,-1,1070,1246,1245,-1,925,904,221,-1,903,904,925,-1,903,902,904,-1,1255,1235,1233,-1,1235,1255,1256,-1,1074,1030,89,-1,1074,1014,1030,-1,1029,846,90,-1,1029,849,846,-1,789,778,85,-1,789,1242,778,-1,211,840,1243,-1,100,840,211,-1,1243,842,1242,-1,1243,840,842,-1,845,1076,98,-1,845,1109,1076,-1,1027,844,1026,-1,844,1027,1241,-1,841,218,1108,-1,841,924,218,-1,1082,838,1080,-1,1082,1163,838,-1,102,1027,1025,-1,1028,1027,102,-1,1024,1077,1257,-1,1024,1026,1077,-1,1084,1240,1085,-1,1240,1084,1106,-1,829,42,894,-1,912,42,829,-1,912,217,42,-1,111,42,112,-1,111,43,42,-1,819,773,777,-1,819,122,773,-1,3,786,774,-1,786,3,913,-1,1258,256,1008,-1,1258,123,256,-1,137,245,266,-1,136,245,137,-1,136,139,131,-1,136,135,139,-1,1092,1065,1066,-1,1092,1090,1065,-1,1068,1095,1091,-1,1067,1095,1068,-1,1092,1094,1051,-1,1092,1091,1094,-1,1020,149,1252,-1,149,1020,147,-1,744,1252,149,-1,744,1046,1252,-1,1112,150,285,-1,150,1112,151,-1,156,159,157,-1,160,159,156,-1,1046,163,162,-1,163,1046,744,-1,167,172,1019,-1,167,173,172,-1,757,804,805,-1,918,804,757,-1,800,189,188,-1,800,1098,189,-1,797,1018,1098,-1,797,758,1018,-1,200,776,1097,-1,200,199,776,-1,201,759,202,-1,201,195,759,-1,1087,265,264,-1,258,265,1087,-1,1259,1069,1245,-1,1259,1102,1069,-1,1149,1248,1150,-1,1248,1149,1054,-1,902,905,904,-1,902,860,905,-1,907,82,850,-1,907,83,82,-1,120,5,4,-1,5,120,119,-1,1015,1191,11,-1,1015,1260,1191,-1,110,823,784,-1,110,826,823,-1,106,1078,104,-1,924,1078,106,-1,1024,834,837,-1,1024,1257,834,-1,1083,103,102,-1,1083,1239,103,-1,54,34,869,-1,31,34,54,-1,1014,81,1030,-1,79,81,1014,-1,986,1255,1244,-1,1256,1255,986,-1,888,1013,1033,-1,888,230,1013,-1,234,235,20,-1,235,234,23,-1,822,881,264,-1,209,881,822,-1,1249,1253,1039,-1,1253,1249,1261,-1,117,237,121,-1,237,117,238,-1,1089,279,746,-1,1258,279,1089,-1,279,1258,1008,-1,75,228,227,-1,244,75,772,-1,75,244,228,-1,1110,70,1118,-1,71,70,1110,-1,1224,1258,1089,-1,1224,123,1258,-1,1117,123,1224,-1,198,919,757,-1,198,754,919,-1,735,1226,733,-1,735,1115,1226,-1,1115,735,815,-1,761,760,762,-1,761,759,760,-1,126,258,127,-1,126,265,258,-1,271,863,242,-1,270,863,271,-1,1111,861,1228,-1,1111,1110,861,-1,281,1254,282,-1,281,1007,1254,-1,1114,1086,1229,-1,1086,1114,1113,-1,1114,820,236,-1,820,1114,876,-1,1122,501,731,-1,618,501,1122,-1,302,729,671,-1,304,729,302,-1,557,728,631,-1,1126,728,557,-1,311,984,280,-1,310,984,311,-1,308,1220,591,-1,308,312,1220,-1,332,662,314,-1,662,332,814,-1,631,634,630,-1,631,935,634,-1,326,1193,327,-1,326,563,1193,-1,1006,6,1052,-1,1006,335,6,-1,479,317,1130,-1,317,479,478,-1,338,346,336,-1,346,338,347,-1,368,949,689,-1,368,363,949,-1,481,956,1132,-1,956,481,939,-1,676,1005,677,-1,1005,676,355,-1,954,958,485,-1,954,1208,958,-1,370,1127,371,-1,370,957,1127,-1,474,1006,1206,-1,474,333,1006,-1,607,425,997,-1,607,976,425,-1,597,1134,606,-1,597,1188,1134,-1,386,1045,1135,-1,385,1045,386,-1,1129,371,1127,-1,1129,635,371,-1,1192,1003,977,-1,1262,1003,1192,-1,527,1001,399,-1,527,650,1001,-1,985,1138,1263,-1,1138,985,1137,-1,420,405,401,-1,405,420,536,-1,588,971,586,-1,588,570,971,-1,1201,519,1160,-1,517,519,1201,-1,513,510,1203,-1,513,960,510,-1,694,411,693,-1,411,694,412,-1,532,965,539,-1,532,966,965,-1,965,537,539,-1,537,965,1197,-1,657,1264,1177,-1,657,1162,1264,-1,421,1151,978,-1,421,423,1151,-1,552,690,550,-1,1265,690,552,-1,1173,1266,1172,-1,999,1266,1173,-1,1183,1267,577,-1,1182,1267,1183,-1,1182,615,1267,-1,678,685,679,-1,678,357,685,-1,684,362,683,-1,362,684,1214,-1,1213,1004,429,-1,1213,1212,1004,-1,432,1152,950,-1,432,682,1152,-1,437,446,680,-1,446,437,378,-1,380,448,447,-1,380,445,448,-1,677,452,454,-1,677,1005,452,-1,1152,392,396,-1,1148,392,1152,-1,729,465,464,-1,729,1135,465,-1,469,472,471,-1,469,672,472,-1,667,1153,1155,-1,470,1153,667,-1,1157,1268,1251,-1,1268,1157,1156,-1,1175,1268,1174,-1,1207,1268,1175,-1,1206,716,474,-1,1206,1176,716,-1,481,337,336,-1,337,481,1132,-1,343,995,344,-1,958,995,343,-1,682,1148,1152,-1,682,952,1148,-1,1123,424,719,-1,997,424,1123,-1,508,579,578,-1,579,508,489,-1,699,1144,697,-1,1144,699,1159,-1,973,1141,655,-1,973,517,1141,-1,1218,656,1143,-1,1218,991,656,-1,1162,1079,1264,-1,1079,1162,1082,-1,1000,524,523,-1,1203,524,1000,-1,1269,1165,1202,-1,1269,1164,1165,-1,524,522,525,-1,509,522,524,-1,526,1269,1167,-1,526,961,1269,-1,990,648,649,-1,990,989,648,-1,528,1168,1169,-1,528,988,1168,-1,91,987,92,-1,91,962,987,-1,1199,401,405,-1,531,401,1199,-1,702,398,397,-1,398,702,963,-1,1138,1265,1263,-1,1265,1138,690,-1,545,1266,543,-1,545,1216,1266,-1,1042,552,551,-1,1234,552,1042,-1,1215,1070,1172,-1,1070,1215,1246,-1,716,1128,717,-1,633,1128,716,-1,632,1128,633,-1,388,487,486,-1,487,388,709,-1,554,1219,562,-1,1219,554,553,-1,373,564,374,-1,373,611,564,-1,565,568,1126,-1,568,565,566,-1,572,1196,571,-1,572,621,1196,-1,1181,1184,1179,-1,1184,1181,1270,-1,1183,982,514,-1,982,1183,577,-1,1185,1195,974,-1,1185,1059,1195,-1,1271,731,730,-1,1271,1122,731,-1,487,579,488,-1,579,487,614,-1,403,979,585,-1,403,535,979,-1,587,1003,1187,-1,1002,1003,587,-1,313,592,591,-1,313,1253,592,-1,600,708,976,-1,708,600,691,-1,599,692,691,-1,422,692,599,-1,730,608,1271,-1,730,1217,608,-1,1151,1250,1149,-1,1151,1189,1250,-1,1189,1260,1250,-1,1189,947,1260,-1,1217,600,608,-1,1217,601,600,-1,1271,607,1124,-1,607,1271,608,-1,1261,1134,942,-1,1261,1133,1134,-1,1003,1194,1187,-1,1194,1003,1262,-1,723,1186,724,-1,628,1186,723,-1,1267,617,413,-1,615,617,1267,-1,1122,1124,1121,-1,1271,1124,1122,-1,1182,974,615,-1,1185,974,1182,-1,1270,1060,1184,-1,1238,1060,1270,-1,973,1178,518,-1,973,972,1178,-1,983,571,570,-1,571,983,572,-1,309,1126,568,-1,309,728,1126,-1,935,624,634,-1,935,727,624,-1,1128,957,666,-1,1127,957,1128,-1,549,1216,545,-1,1216,549,1196,-1,1215,620,1246,-1,1215,621,620,-1,1266,998,543,-1,998,1266,999,-1,964,638,701,-1,964,544,638,-1,544,964,547,-1,1235,1263,1265,-1,1235,1256,1263,-1,704,529,646,-1,704,703,529,-1,646,647,644,-1,645,647,646,-1,1171,533,419,-1,1171,1170,533,-1,648,988,962,-1,1168,988,648,-1,652,1170,1171,-1,525,1170,652,-1,1164,961,1169,-1,1269,961,1164,-1,1202,1167,1269,-1,1158,1167,1202,-1,1218,1200,991,-1,1200,1218,1239,-1,1264,1238,1270,-1,1238,1264,1079,-1,1202,1142,1201,-1,1142,1202,1165,-1,705,500,412,-1,501,500,705,-1,394,959,395,-1,418,959,394,-1,1147,994,393,-1,1147,507,994,-1,1132,720,337,-1,1132,1131,720,-1,937,481,346,-1,937,938,481,-1,813,332,331,-1,813,814,332,-1,722,940,714,-1,477,940,722,-1,1176,1207,1175,-1,1207,1176,1206,-1,1156,1174,1268,-1,1156,1154,1174,-1,1251,1207,1049,-1,1207,1251,1268,-1,469,669,996,-1,469,473,669,-1,304,1135,729,-1,304,386,1135,-1,672,671,472,-1,672,302,671,-1,463,467,673,-1,463,468,467,-1,454,457,677,-1,679,457,454,-1,445,351,448,-1,445,352,351,-1,681,439,440,-1,951,439,681,-1,350,429,428,-1,1213,429,350,-1,687,349,353,-1,687,1212,349,-1,679,396,457,-1,679,685,396,-1,434,362,361,-1,434,436,362,-1,1172,1216,1215,-1,1266,1216,1172,-1,1234,1265,552,-1,1235,1265,1234,-1,1270,1177,1264,-1,1270,1181,1177,-1,1197,1199,537,-1,1199,1197,1198,-1,1191,947,604,-1,1260,947,1191,-1,503,411,410,-1,660,411,503,-1,1203,698,513,-1,1203,1000,698,-1,517,1142,1141,-1,1201,1142,517,-1,103,1218,653,-1,1239,1218,103,-1,700,971,622,-1,700,586,971,-1,640,704,643,-1,640,542,704,-1,1263,986,985,-1,1263,1256,986,-1,466,888,567,-1,706,888,466,-1,944,1188,597,-1,944,384,1188,-1,976,502,425,-1,976,708,502,-1,1253,942,592,-1,1253,1261,942,-1,496,495,497,-1,496,575,495,-1,726,1205,317,-1,726,482,1205,-1,726,483,482,-1,391,2,629,-1,2,711,389,-1,711,2,391,-1,553,1129,1219,-1,553,635,1129,-1,482,1211,1205,-1,995,1211,482,-1,995,1210,1211,-1,1211,1204,1205,-1,1209,1204,1211,-1,428,1214,684,-1,428,688,1214,-1,689,353,352,-1,949,353,689,-1,561,324,323,-1,324,561,558,-1,725,563,613,-1,725,1193,563,-1,969,562,1219,-1,562,969,372,-1,591,306,313,-1,591,1220,306,-1,312,623,1220,-1,623,312,936,-1,720,340,719,-1,720,341,340,-1,577,413,408,-1,577,1267,413,-1,720,484,341,-1,720,1131,484,-1,821,876,289,-1,821,820,876,-1,285,160,156,-1,285,150,160,-1,1064,74,898,-1,1064,1063,74,-1,1254,1222,282,-1,1254,1221,1222,-1,1222,743,24,-1,743,1222,283,-1,275,898,276,-1,275,1120,898,-1,1223,932,750,-1,61,932,1223,-1,8,931,1050,-1,931,8,751,-1,746,812,1088,-1,746,811,812,-1,267,265,126,-1,267,263,265,-1,202,761,207,-1,761,202,759,-1,1227,128,1021,-1,1227,1272,128,-1,755,165,1019,-1,755,168,165,-1,1272,248,128,-1,1272,1225,248,-1,931,809,1090,-1,260,809,931,-1,1055,1039,26,-1,1039,1055,1249,-1,264,880,1087,-1,881,880,264,-1,867,1033,868,-1,867,888,1033,-1,226,115,114,-1,226,784,115,-1,929,1192,927,-1,929,1262,1192,-1,778,845,93,-1,845,778,1230,-1,794,1244,1255,-1,794,1072,1244,-1,782,790,780,-1,782,851,790,-1,54,32,31,-1,32,54,56,-1,833,1257,1106,-1,833,834,1257,-1,828,104,1078,-1,108,104,828,-1,110,214,111,-1,110,226,214,-1,84,907,853,-1,907,84,83,-1,852,84,853,-1,852,1231,84,-1,1080,835,1023,-1,1080,838,835,-1,1054,16,1248,-1,16,1054,922,-1,795,900,899,-1,795,1233,900,-1,920,854,899,-1,920,80,854,-1,1245,1247,1259,-1,1247,1245,896,-1,251,1100,758,-1,1100,251,762,-1,254,1099,753,-1,1236,1099,254,-1,195,1236,196,-1,195,1099,1236,-1,887,1098,1018,-1,1098,887,189,-1,802,799,181,-1,802,769,799,-1,805,770,803,-1,770,805,206,-1,176,1019,172,-1,1019,176,755,-1,169,917,165,-1,169,811,917,-1,246,175,801,-1,756,175,246,-1,232,285,739,-1,285,232,1112,-1,157,149,148,-1,159,149,157,-1,1096,146,1237,-1,1096,808,146,-1,1226,1272,1227,-1,1115,1272,1226,-1,1116,1272,1115,-1,1116,1225,1272,-1,1117,1225,1116,-1,1117,1224,1225,-1,1067,1237,1095,-1,1096,1237,1067,-1,1051,1090,1092,-1,1051,931,1090,-1,1051,1050,931,-1,266,134,137,-1,266,812,134,-1,125,815,257,-1,124,815,125,-1,788,193,1097,-1,193,788,787,-1,20,822,18,-1,20,235,822,-1,99,1078,911,-1,99,828,1078,-1,42,216,105,-1,42,217,216,-1,830,833,831,-1,833,830,49,-1,1240,1257,1077,-1,1240,1106,1257,-1,1163,839,838,-1,1163,1200,839,-1,1109,1240,1076,-1,1109,1085,1240,-1,1028,1241,1027,-1,1241,1028,1075,-1,842,1108,1230,-1,842,841,1108,-1,1241,910,844,-1,910,1241,847,-1,1242,1230,778,-1,1242,842,1230,-1,847,848,910,-1,848,847,846,-1,210,1243,906,-1,211,1243,210,-1,1029,1072,849,-1,1072,1029,1244,-1,782,852,783,-1,852,782,1073,-1,1231,82,84,-1,1231,1105,82,-1,1233,794,1255,-1,1233,795,794,-1,1102,857,856,-1,1259,857,1102,-1,900,1042,901,-1,900,1234,1042,-1,1259,858,857,-1,1259,1247,858,-1,141,1228,1012,-1,141,1111,1228,-1,765,1120,275,-1,1119,1120,765,-1,25,743,767,-1,24,743,25,-1,1104,895,48,-1,1104,1023,895,-1,1060,1232,873,-1,1060,1238,1232,-1,877,872,892,-1,877,893,872,-1,1229,876,1114,-1,1229,875,876,-1,291,1101,923,-1,291,892,1101,-1,866,68,864,-1,866,66,68,-1,1035,270,269,-1,1035,864,270,-1,1194,929,1057,-1,1194,1262,929,-1,927,16,928,-1,16,927,1248,-1,233,1261,1249,-1,1261,233,1133,-1,880,875,1229,-1,880,889,875,-1,12,1103,889,-1,884,1103,12,-1,1260,1053,1250,-1,1053,1260,1015,-1,1052,8,1050,-1,8,1052,6,-1,1094,1157,1251,-1,1157,1094,1093,-1,1020,996,669,-1,996,1020,1252,-1,674,771,707,-1,674,164,771,-1,231,706,945,-1,706,231,230,-1,609,130,129,-1,609,890,130,-1,389,390,709,-1,389,711,390,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t6_Coord',point=[(-.63011,48.17534,-3.54089),(-.5973,48.14931,-3.57092),(-.61145,48.08078,-3.53773),(.49605,48.4837,-3.21303),(.48683,48.50864,-3.22685),(.46317,48.60176,-3.1934),(-.00419,48.12304,-4.12773),(0,48.12451,-4.12818),(.00419,48.12304,-4.12773),(.12731,48.56337,-3.02807),(.21893,48.57211,-3.06347),(.13164,48.48846,-3.0553),(.27248,48.48476,-3.27022),(.28007,48.3856,-3.28936),(.26322,48.36434,-3.21442),(.3501,48.12597,-3.17267),(.2316,48.19462,-3.1594),(.30351,48.2123,-3.2146),(.16074,48.47614,-3.48845),(.08102,48.34519,-3.51341),(.152,48.34268,-3.48554),(.30973,48.20821,-3.44993),(.28445,48.25274,-3.41202),(.22192,48.25142,-3.46892),(.1095,48.0051,-3.68574),(.19653,47.97808,-3.64266),(.17592,48.08974,-3.58159),(.23683,47.95705,-3.59989),(.23495,48.08675,-3.51741),(.21715,48.09089,-3.54712),(.36414,47.92203,-3.14431),(.35631,47.81486,-3.10927),(.25863,47.78898,-3.12071),(.47543,47.93617,-3.1448),(.44686,47.82731,-3.06583),(.46733,48.04397,-3.14227),(.36125,48.02676,-3.15187),(.33452,48.23009,-3.30962),(.38923,48.2135,-3.29876),(.44297,48.15376,-3.13418),(.50233,48.25944,-3.22859),(.46336,48.22783,-3.11897),(.50723,48.4813,-2.87493),(.49139,48.51792,-2.94102),(.35343,48.49688,-2.91215),(.50749,48.88394,-3.22777),(.40246,48.96954,-3.26427),(.40366,48.86729,-3.23245),(.27675,48.39246,-2.46492),(.3943,48.43267,-2.55428),(.30476,48.41099,-2.57577),(0,47.81506,-2.99236),(0,47.78592,-3.06059),(.13654,47.79261,-3.07933),(.35446,47.8033,-3.09391),(.243,47.79025,-3.00296),(.25806,47.77887,-3.10853),(.11368,47.78965,-3.85208),(.19295,47.84468,-3.76117),(.11206,47.86405,-3.77911),(0,47.79627,-3.8409),(.26644,47.94423,-3.57588),(.28853,47.82995,-3.63948),(.55846,47.91977,-3.47807),(.42113,47.8203,-3.54087),(.56506,47.93806,-3.53344),(.42488,47.99716,-3.49879),(.55886,47.97863,-3.4596),(.44215,48.01975,-3.4783),(.5973,48.14931,-3.56818),(.5509,48.01508,-3.59452),(.51989,48.10418,-3.62127),(.19268,47.72937,-3.96409),(.19502,47.88372,-3.92448),(.22284,47.80756,-3.88766),(.61145,48.08078,-3.53526),(.63978,48.23982,-3.45113),(.63011,48.17534,-3.53754),(.69979,48.24213,-3.56399),(.39932,47.72856,-2.41354),(.39629,47.73703,-2.53282),(.47022,47.73508,-2.55365),(.64528,47.89204,-2.99516),(.61875,47.87515,-2.98296),(.59925,47.88229,-3.01558),(.59276,47.86086,-2.74073),(.54442,47.83254,-2.66657),(.58213,47.78668,-2.74778),(.54119,47.76788,-2.66506),(.50463,47.81684,-2.55382),(.0791,47.89406,-2.20228),(0,47.88825,-2.18526),(0,47.74878,-2.18438),(.50298,47.95823,-2.6739),(.44788,47.9443,-2.58459),(.64777,47.82071,-2.82218),(.37321,48.05495,-2.458),(.3775,47.93503,-2.45971),(.42076,48.0665,-2.57924),(.49909,48.27583,-3.01071),(.52017,48.19523,-3.03139),(0,48.21107,-2.15198),(.08044,48.3055,-2.1511),(0,48.29193,-2.13298),(.53973,48.33454,-2.88452),(.53809,48.36734,-2.85268),(.54736,48.3263,-2.7964),(.5359,48.41228,-2.92411),(.52577,48.35519,-2.9958),(.53267,48.40753,-3.07336),(.49359,48.55791,-3.04479),(.49318,48.51718,-2.95854),(.53069,48.46086,-3.00926),(.43254,48.66398,-3.19234),(.4466,48.61437,-3.12996),(.47472,48.58743,-3.12724),(.55335,48.78238,-3.27948),(.52522,48.72682,-3.25396),(.47312,48.58452,-3.25174),(.46666,48.57293,-3.23395),(.47762,48.53358,-3.24059),(.46658,48.62598,-3.23969),(.5174,48.60923,-3.26475),(.45922,48.78684,-3.3161),(.43283,48.83864,-3.29965),(.50847,48.88699,-3.23613),(.19094,48.71934,-3.47391),(.20367,48.80838,-3.41049),(.29175,48.7529,-3.39794),(0,48.59824,-3.61852),(.09698,48.65944,-3.55033),(.08193,48.59191,-3.6148),(.42565,48.43547,-3.62216),(.35785,48.44683,-3.64632),(.33667,48.56852,-3.54991),(.16783,48.48341,-3.72526),(.16083,48.58963,-3.59897),(.2413,48.58324,-3.57307),(.14262,48.37911,-3.83971),(.11112,48.49091,-3.73679),(.24237,48.46791,-3.6918),(.37721,48.3119,-3.66648),(.04741,48.28282,-3.95931),(0,48.28321,-3.97409),(0,48.38563,-3.8507),(.00727,47.65925,-4.33524),(.04071,47.628,-4.29972),(.07172,47.46322,-4.36947),(.07856,47.44025,-4.30602),(.06949,47.32367,-4.37512),(.11183,47.29577,-4.21511),(.06131,47.30621,-4.19302),(.04401,47.21003,-4.2545),(.14487,47.57291,-4.07152),(.12681,47.59756,-4.10633),(.12696,47.69511,-4.05369),(.13405,47.38312,-4.15165),(.09268,47.41213,-4.21735),(.12094,47.51733,-4.14572),(.075,47.3126,-4.28542),(.11703,47.30121,-4.22675),(.07945,47.21255,-4.29054),(.00959,47.11933,-4.38098),(.06301,47.14206,-4.29315),(.01007,47.12076,-4.27675),(.51738,48.62405,-3.48706),(.61917,48.67781,-3.37445),(.71784,48.63667,-3.41287),(.48112,48.58311,-3.58194),(.41149,48.5705,-3.55722),(.50061,48.4341,-3.63365),(.45586,48.30897,-3.64145),(.73079,48.66877,-3.58342),(.82618,48.65161,-3.46434),(.90798,48.67294,-3.52615),(.687,48.48038,-3.70483),(.66217,48.6334,-3.67484),(.76959,48.66372,-3.74324),(.89024,48.43585,-3.84399),(.82078,48.4036,-3.76282),(.76996,48.52241,-3.79219),(.96456,48.47532,-3.88098),(.85302,48.55182,-3.84819),(1.11398,48.57229,-3.8233),(1.06657,48.62893,-3.81127),(1.0834,48.65628,-3.75526),(1.11998,48.50526,-3.77269),(1.08705,48.46361,-3.82552),(.88685,48.34213,-3.69398),(.95505,48.33161,-3.60171),(.85953,48.31759,-3.5372),(.64104,48.28847,-3.41465),(.75564,48.2945,-3.46489),(.76107,48.36165,-3.43594),(.88206,48.36816,-3.48151),(1.06675,48.57801,-3.65419),(1.05145,48.51761,-3.59389),(1.07057,48.53004,-3.64021),(.92336,48.63645,-3.48834),(.85743,48.61792,-3.42487),(.87291,48.50104,-3.43687),(1.05273,48.59699,-3.64651),(1.08728,48.66074,-3.69276),(1.01843,48.68319,-3.63902),(1.07719,48.5517,-3.66006),(1.13024,48.47503,-3.67489),(.99664,48.71724,-3.72311),(1.08715,48.66849,-3.7041),(.26172,48.32458,-3.38346),(.26256,48.41922,-3.3648),(.60262,48.06896,-3.08763),(.55588,48.13167,-3.05567),(.21016,48.43874,-3.13683),(.21358,48.49884,-3.10532),(.4769,48.53945,-2.9776),(.5163,48.43506,-2.77208),(.52139,48.43127,-2.79523),(.51599,48.45145,-2.79128),(.53599,48.32938,-2.77178),(.46072,47.81583,-3.04701),(.46581,47.822,-3.05286),(.57928,47.77659,-2.76338),(.64015,47.80719,-2.82614),(.32285,47.72324,-2.29994),(.32875,47.73731,-2.29173),(.37783,48.59934,-3.04801),(.47744,48.57696,-3.05715),(.59623,47.99764,-3.48945),(.58166,48.06073,-3.46496),(.57633,48.03773,-3.45349),(.01063,47.54514,-4.02113),(.01094,47.45786,-4.06633),(.06588,47.46963,-4.07267),(.08263,48.243,-3.53131),(.15834,48.24633,-3.51297),(.21092,48.33613,-3.43908),(.40068,48.77938,-3.21627),(.44606,48.7272,-3.22345),(.47169,48.80778,-3.23136),(.48509,48.18957,-3.39651),(.54404,48.12917,-3.4314),(.56488,48.1878,-3.44224),(.46345,48.1544,-3.42408),(.52839,48.08189,-3.42811),(.58815,48.08818,-3.4844),(.17309,48.65784,-3.49962),(.62866,48.32681,-3.63941),(.57693,48.19859,-3.58702),(.36196,48.70542,-3.39309),(.30769,48.72606,-3.41434),(1.12588,48.59267,-3.7652),(1.13992,48.53047,-3.74061),(.98405,48.53514,-3.51884),(1.07277,48.44363,-3.57789),(.99317,48.53873,-3.52946),(.58398,48.69438,-3.35277),(.5489,48.78816,-3.28873),(.40806,48.96978,-3.26932),(.19554,48.80279,-3.40438),(.24974,48.90366,-3.33338),(.10278,48.27482,-3.94022),(.08835,48.28099,-3.94699),(.12228,48.39319,-3.85617),(.17127,48.65986,-3.48522),(.22032,48.59345,-3.40215),(.18113,48.71541,-3.46919),(.2644,48.6379,-3.49939),(.18202,48.66111,-3.49226),(.0812,48.49075,-3.74412),(.31187,48.18305,-3.45109),(.38132,48.16615,-3.43533),(.38536,48.18119,-3.43145),(.51916,48.07214,-3.42497),(.3096,48.19667,-3.45411),(.23921,48.08111,-3.50781),(.31834,47.89799,-3.74538),(.24635,47.96057,-3.8526),(.29328,48.01405,-3.79226),(.58034,48.68943,-3.3636),(.57849,48.69659,-3.36148),(0,47.95025,-3.7685),(.11385,47.88189,-3.77132),(.04887,47.93599,-3.7607),(.13608,47.90499,-3.73993),(.12683,47.90789,-3.75153),(.12795,47.37582,-4.14137),(.1301,47.4889,-4.09016),(.32248,48.5863,-3.16687),(.33037,48.59635,-3.10092),(.34432,48.63349,-3.15188),(.23107,48.5797,-3.06698),(.22126,48.57508,-3.04897),(.30445,48.58952,-3.05781),(.37455,48.5864,-3.02729),(-.27539,48.57495,-3.1203),(-.33037,48.59635,-3.10825),(-.30445,48.58952,-3.06483),(-.13869,47.5677,-4.05901),(-.14487,47.57291,-4.07152),(-.1301,47.4889,-4.09016),(-.16087,47.6516,-4.00952),(-.1645,47.65794,-4.01987),(-.11703,47.30121,-4.22675),(-.07945,47.21255,-4.29054),(-.11183,47.29577,-4.21511),(-.11354,47.89532,-3.76756),(-.04887,47.93599,-3.7607),(-.0766,47.93099,-3.76208),(-.15099,47.89944,-3.73083),(-.19295,47.84468,-3.76117),(-.11206,47.86405,-3.77911),(-.11385,47.88189,-3.77132),(-.13608,47.90499,-3.73993),(0,48.03015,-3.72625),(-.12228,48.39319,-3.85666),(-.06313,48.3903,-3.8567),(-.04741,48.28282,-3.95933),(-.4365,48.63715,-3.43742),(-.44586,48.63083,-3.44578),(-.58034,48.68943,-3.37288),(-.58889,48.69124,-3.36775),(-.61917,48.67781,-3.3839),(-.5672,48.0314,-3.45108),(-.56966,47.98084,-3.46612),(-.55886,47.97863,-3.46191),(-.42113,47.8203,-3.54115),(-.31798,47.82035,-3.59592),(-.32344,47.81718,-3.58518),(-.51916,48.07214,-3.42843),(-.52839,48.08189,-3.43165),(-.57633,48.03773,-3.45645),(-.0812,48.49075,-3.74476),(-.05912,48.49302,-3.76448),(-.10278,48.27482,-3.94029),(-.08835,48.28099,-3.94705),(-.04808,48.20082,-4.0504),(-.19094,48.71934,-3.47703),(-.20367,48.80838,-3.41427),(-.18113,48.71541,-3.47216),(-.40806,48.96978,-3.27826),(-.33598,48.96195,-3.28838),(-.34394,48.96054,-3.29651),(-.55335,48.78238,-3.28996),(-.50847,48.88699,-3.2469),(-.5489,48.78816,-3.29907),(-.17413,48.65525,-3.4947),(-.18202,48.66111,-3.49505),(-.17127,48.65986,-3.48787),(-.98405,48.53514,-3.5253),(-.96732,48.62973,-3.55986),(-.99317,48.53873,-3.53568),(-1.0051,48.68843,-3.63334),(-1.01553,48.69279,-3.65323),(-1.01843,48.68319,-3.64419),(-.58156,48.44802,-3.6542),(-.48112,48.58311,-3.58719),(-.50061,48.4341,-3.6376),(-.92336,48.63645,-3.49665),(-.96275,48.68168,-3.58993),(-.96275,48.64494,-3.564),(-1.13992,48.53047,-3.74114),(-1.11998,48.50526,-3.77291),(-1.12962,48.42973,-3.7021),(-1.11816,48.60142,-3.71231),(-1.13661,48.54495,-3.70104),(-1.07719,48.5517,-3.66293),(-1.12588,48.59267,-3.76587),(-1.14218,48.54156,-3.71204),(-1.12205,48.60354,-3.72511),(-.53793,48.30844,-3.62954),(-.45586,48.30897,-3.64437),(-.49135,48.18441,-3.63566),(-.35169,47.87651,-3.70063),(-.24088,47.85766,-3.69691),(-.28853,47.82995,-3.63948),(-.46345,48.1544,-3.42799),(-.38536,48.18119,-3.43499),(-.41352,48.21948,-3.39017),(-1.04494,48.59695,-3.85085),(-1.06657,48.62893,-3.81197),(-.97121,48.65925,-3.8071),(0,48.19746,-4.07138),(-.26172,48.32458,-3.38686),(-.28445,48.25274,-3.41521),(-.22192,48.25142,-3.4712),(-.01094,47.31667,-4.17136),(-.06131,47.30621,-4.19302),(-.04401,47.21003,-4.2545),(-.63978,48.23982,-3.45618),(-.59464,48.11564,-3.50693),(-.54404,48.12917,-3.43539),(-.58166,48.06073,-3.46802),(-.66211,48.56581,-3.33292),(-.56856,48.51844,-3.28364),(-.5509,48.56588,-3.28804),(-.6353,48.60424,-3.3528),(-.75355,48.60401,-3.39128),(-.59276,47.86086,-2.74812),(-.54442,47.83254,-2.67398),(-.50298,47.95823,-2.68197),(-.64777,47.82071,-2.82875),(-.69626,47.90382,-2.96002),(-.64667,47.81452,-2.84242),(-.49526,47.96575,-3.14884),(-.50127,47.94291,-3.14208),(-.62338,48.00551,-3.12214),(-.47543,47.93617,-3.14924),(-.49139,48.51792,-2.9522),(-.37455,48.5864,-3.03596),(-.37783,48.59934,-3.05666),(-.48627,48.5731,-3.07123),(-.49359,48.55791,-3.0554),(-.47744,48.57696,-3.06749),(-.2979,48.58074,-3.04542),(-.21016,48.43874,-3.14099),(-.23874,48.49979,-3.13304),(-.21358,48.49884,-3.10987),(-.47312,48.58452,-3.26028),(-.5174,48.60923,-3.27391),(-.61711,47.90182,-2.83281),(-.69337,47.9225,-2.95755),(-.2316,48.19462,-3.16293),(-.27787,48.29293,-3.22513),(-.22028,48.28231,-3.16396),(-.19554,48.80279,-3.40803),(-.22032,48.59345,-3.40578),(-.95882,48.6345,-3.55047),(-1.07057,48.53004,-3.64335),(-1.07277,48.44363,-3.58135),(-1.05145,48.51761,-3.59808),(-.94614,48.5264,-3.49375),(-.97972,48.37482,-3.53332),(-.88206,48.36816,-3.48733),(-.85953,48.31759,-3.54159),(-1.08705,48.46361,-3.82552),(-1.01847,48.40577,-3.83792),(-1.0955,48.39097,-3.75107),(-1.06503,48.52186,-3.87051),(-.89024,48.43585,-3.84428),(-.96376,48.37191,-3.77305),(-.88685,48.34213,-3.69575),(-.82078,48.4036,-3.76447),(-.74558,48.36366,-3.68797),(-1.11398,48.57229,-3.82341),(-1.0834,48.65628,-3.75696),(-.99664,48.71724,-3.72695),(-.94633,48.57225,-3.86289),(-.86636,48.67636,-3.78929),(-.92356,48.7376,-3.69234),(-.76959,48.66372,-3.74753),(-.76996,48.52241,-3.79462),(-.85302,48.55182,-3.84938),(-.66217,48.6334,-3.68005),(-.83724,48.72775,-3.64899),(-.73079,48.66877,-3.59039),(-.41149,48.5705,-3.56207),(-.42565,48.43547,-3.62584),(-.71784,48.63667,-3.4222),(-.75564,48.2945,-3.47042),(-.69979,48.24213,-3.56761),(-.12681,47.59756,-4.10633),(-.12094,47.51733,-4.14572),(-.0808,47.20372,-4.27761),(-.06301,47.14206,-4.29315),(-.12058,47.48353,-4.07743),(-.06588,47.46963,-4.07267),(-.0729,47.54863,-4.04417),(-.00617,47.20132,-4.43339),(-.05893,47.21043,-4.35451),(-.06949,47.32367,-4.37512),(-.08161,47.57279,-4.23114),(-.07856,47.44025,-4.30602),(-.09268,47.41213,-4.21735),(-.07172,47.46322,-4.36947),(-.1378,48.2537,-3.90143),(-.16617,48.3689,-3.82418),(-.24237,48.46791,-3.69383),(-.16783,48.48341,-3.72661),(-.43788,48.62805,-3.44842),(-.34418,48.61865,-3.47574),(-.33667,48.56852,-3.55407),(-.29175,48.7529,-3.40318),(-.45337,48.72968,-3.36117),(-.57721,48.69979,-3.36842),(-.34923,48.87717,-3.32571),(-.38555,48.87699,-3.30975),(-.64104,48.28847,-3.42063),(-.5214,48.25168,-3.36411),(-.55749,48.27672,-3.32817),(-.51878,48.31438,-3.21753),(-.58251,48.33092,-3.28352),(-.47762,48.53358,-3.24899),(-.48901,48.54087,-3.26423),(-.48683,48.50864,-3.23534),(-.58398,48.69438,-3.36225),(-.52522,48.72682,-3.26403),(-.44606,48.7272,-3.23258),(-.46658,48.62598,-3.24849),(-.46317,48.60176,-3.20243),(-.43254,48.66398,-3.20122),(-.4466,48.61437,-3.13936),(-.38705,48.63887,-3.1513),(-.22004,48.45185,-3.43489),(-.51901,48.49767,-3.13026),(-.47472,48.58743,-3.13698),(-.52459,48.38571,-3.08597),(-.52872,48.4103,-3.10634),(-.50678,48.40284,-3.21778),(-.48056,48.30405,-3.11074),(-.49909,48.27583,-3.01951),(-.5197,48.33457,-3.00895),(-.53809,48.36734,-2.86416),(-.5359,48.41228,-2.93536),(-.53973,48.33454,-2.89547),(-.43619,48.45817,-2.80712),(-.50596,48.44908,-2.79489),(-.47564,48.43184,-2.67832),(-.37588,48.41508,-2.45687),(-.3943,48.43267,-2.56515),(-.42531,48.42242,-2.567),(-.44297,48.15376,-3.14031),(-.55588,48.13167,-3.06338),(-.52017,48.19523,-3.03956),(-.5085,48.2182,-2.83174),(-.50593,48.23947,-2.919),(-.5322,48.14428,-2.93472),(-.42076,48.0665,-2.58765),(-.4609,48.08003,-2.69119),(-.30039,47.9242,-2.3525),(-.33333,47.79818,-2.32679),(-.2148,47.78123,-2.27338),(-.68624,47.88755,-2.96094),(-.60663,47.83687,-2.92359),(-.64706,47.98794,-2.95038),(-.60262,48.06896,-3.09474),(-.46733,48.04397,-3.14765),(-.62267,48.02732,-3.11685),(-.5683,47.91442,-3.08558),(-.46581,47.822,-3.05681),(-.54814,47.85832,-3.02073),(-.28885,47.70697,-2.36855),(-.32285,47.72324,-2.32875),(-.39932,47.72856,-2.41971),(-.35857,47.77117,-2.65734),(-.43461,47.75744,-2.76896),(-.35805,47.79723,-2.76938),(-.42505,47.75161,-2.6668),(-.43179,47.77298,-2.86646),(-.42219,47.78675,-2.93769),(-.34487,47.81822,-2.88064),(-.23283,47.72583,-2.41974),(-.13801,47.73483,-2.4244),(-.13595,47.71699,-2.36947),(-.5509,48.01508,-3.59578),(-.56506,47.93806,-3.53459),(-.15529,47.78557,-3.99613),(-.19268,47.72937,-3.96409),(-.22284,47.80756,-3.88766),(-.54988,47.92182,-3.47374),(-.42488,47.99716,-3.50074),(-.44215,48.01975,-3.48063),(-.55846,47.91977,-3.47961),(-.44449,47.8904,-3.61591),(-.26644,47.94423,-3.57666),(-.23683,47.95705,-3.60054),(-.18826,47.72201,-3.95461),(-.09554,47.71321,-3.93873),(-.0844,47.63787,-3.98698),(-.11368,47.78965,-3.85208),(-.3473,47.7943,-2.97803),(-.25806,47.77887,-3.11054),(-.243,47.79025,-3.00529),(-.13281,47.7973,-3.01401),(-.40366,48.86729,-3.24132),(-.49805,48.88394,-3.23881),(-.47169,48.80778,-3.24123),(-.50723,48.4813,-2.88666),(-.35343,48.49688,-2.92062),(-.46336,48.22783,-3.12605),(-.50233,48.25944,-3.2354),(-.38896,47.98939,-3.5244),(-.34614,48.00783,-3.52995),(-.33452,48.23009,-3.31385),(-.30351,48.2123,-3.21892),(-.3501,48.12597,-3.1773),(-.36414,47.92203,-3.14785),(-.35631,47.81486,-3.11216),(-.25907,47.91128,-3.13307),(-.25863,47.78898,-3.12273),(-.21715,48.09089,-3.54846),(-.17592,48.08974,-3.58256),(-.1095,48.0051,-3.68598),(-.09664,48.09103,-3.6148),(-.30973,48.20821,-3.45291),(-.22655,48.18426,-3.50088),(-.09424,48.48463,-3.52919),(-.16074,48.47614,-3.49058),(-.152,48.34268,-3.48729),(-.24711,48.10718,-3.15342),(-.26322,48.36434,-3.21889),(-.27248,48.48476,-3.27502),(-.27451,48.4404,-3.20459),(-.21893,48.57211,-3.06853),(-.12731,48.56337,-3.03112),(-.13164,48.48846,-3.05824),(0,48.49455,-3.57092),(-.08102,48.34519,-3.5143),(-.27677,48.62506,-3.31231),(-.29533,48.56491,-3.25411),(0,48.60234,-3.60392),(-.09819,48.65799,-3.54527),(-.19653,47.97808,-3.64313),(-.3096,48.19667,-3.45701),(-.23495,48.08675,-3.51896),(-.4669,48.22194,-3.26825),(-.23087,48.48949,-2.93684),(-.13004,48.56623,-3.01936),(-.22126,48.57508,-3.05415),(-.39683,48.6878,-3.20007),(-.40068,48.77938,-3.22489),(0,47.82241,-2.90609),(-.1287,47.82246,-2.9165),(-.4526,47.81619,-3.05024),(-.10826,47.94202,-3.74291),(-.3143,47.87103,-3.73707),(-.41637,47.8225,-3.53526),(-.45568,48.14075,-3.4301),(-.42479,48.08112,-3.46625),(-.38812,48.11041,-3.47304),(-.59623,47.99764,-3.49161),(-.24635,47.96057,-3.8526),(-.26265,47.86033,-3.80242),(-.34358,48.04356,-3.73854),(-.29328,48.01405,-3.79227),(-.31834,47.89799,-3.74538),(-.51989,48.10418,-3.62303),(-.57693,48.19859,-3.58997),(-.46072,47.81583,-3.05091),(-.57122,47.77412,-2.75748),(-.32203,47.71754,-2.42862),(-.47022,47.73508,-2.55977),(-.39629,47.73703,-2.53805),(-.51523,47.79752,-2.9392),(-.48266,47.74567,-2.55335),(-.50463,47.81684,-2.56124),(-.3775,47.93503,-2.46698),(-.42789,47.8077,-2.42594),(-.44788,47.9443,-2.59257),(-.07882,48.00323,-2.19782),(0,47.98425,-2.18036),(-.49289,48.08927,-2.77776),(-.48772,48.20798,-2.78626),(-.51192,48.10324,-2.83858),(-.08044,48.3055,-2.15349),(-.08571,48.23442,-2.15922),(-.2358,48.38615,-2.33143),(-.15935,48.35775,-2.26683),(-.17171,48.36977,-2.33883),(-.53267,48.40753,-3.08319),(-.53069,48.46086,-3.02008),(-.52296,48.49178,-3.10791),(-.50051,48.56306,-3.27469),(0,48.45924,-3.80232),(-.2413,48.58324,-3.57606),(-.14262,48.37911,-3.84031),(-.35785,48.44683,-3.64941),(-.27288,48.33465,-3.72944),(-.04071,47.628,-4.29972),(-.00727,47.65925,-4.33524),(-.00771,47.46327,-4.43367),(-.12696,47.69511,-4.05369),(-.13405,47.38312,-4.15165),(-.075,47.3126,-4.28542),(-.00959,47.11933,-4.38098),(-.01007,47.12076,-4.27675),(-.687,48.48038,-3.70853),(-.51738,48.62405,-3.49388),(-.60728,48.63495,-3.5371),(-.90798,48.67294,-3.5341),(-.82618,48.65161,-3.47331),(-.96456,48.47532,-3.88099),(-.95505,48.33161,-3.6045),(-.76105,48.35676,-3.44408),(-1.0653,48.39208,-3.60203),(-1.07078,48.42725,-3.57727),(-.85743,48.61792,-3.43425),(-1.05273,48.59699,-3.6504),(-1.03062,48.59955,-3.62317),(-1.13024,48.47503,-3.67604),(-1.08715,48.66849,-3.70701),(-.22184,47.70121,-2.34409),(-.28007,48.3856,-3.29377),(-.29833,48.30824,-3.303),(-.49318,48.51718,-2.9696),(-.4769,48.53945,-2.98836),(-.51599,48.45145,-2.80357),(-.52139,48.43127,-2.80742),(-.5163,48.43506,-2.78438),(-.54736,48.3263,-2.80809),(-.53599,48.32938,-2.78349),(-.44686,47.82731,-3.06964),(-.57928,47.77659,-2.76944),(-.58213,47.78668,-2.7541),(-.32875,47.73731,-2.31928),(-.4113,47.74062,-2.41374),(-.38137,48.607,-3.09585),(-.01063,47.54514,-4.02113),(-.01027,47.21826,-4.22546),(-.26256,48.41922,-3.36869),(-.56488,48.1878,-3.4467),(-.48509,48.18957,-3.40106),(-.58815,48.08818,-3.48752),(-.17309,48.65784,-3.50224),(-.09698,48.65944,-3.55171),(-.08193,48.59191,-3.61578),(-.62866,48.32681,-3.64282),(-.20025,48.17865,-3.85658),(-.21012,48.22444,-3.83058),(-.40246,48.96954,-3.27315),(-.24974,48.90366,-3.33861),(-.25618,48.90511,-3.34499),(-.2644,48.6379,-3.50326),(-.11112,48.49091,-3.73767),(-.38132,48.16615,-3.43872),(-.31187,48.18305,-3.45396),(-.23921,48.08111,-3.50941),(-.57849,48.69659,-3.3708),(-.27134,47.8532,-3.78887),(-.25427,47.84949,-3.79229),(-.12795,47.37582,-4.14137),(-.32248,48.5863,-3.17357),(-.34432,48.63349,-3.1593),(-.23107,48.5797,-3.07232),(.30684,48.85853,-3.34681),(.34394,48.96054,-3.289),(.34923,48.87717,-3.31854),(.27539,48.57495,-3.11426),(.25618,48.90511,-3.33967),(.33598,48.96195,-3.28097),(.12058,47.48353,-4.07743),(.13869,47.5677,-4.05901),(.1645,47.65794,-4.01987),(.0808,47.20372,-4.27761),(.15099,47.89944,-3.73083),(.05893,47.21043,-4.35451),(.06313,48.3903,-3.85644),(.4365,48.63715,-3.43081),(.5672,48.0314,-3.44813),(.56966,47.98084,-3.46383),(.41637,47.8225,-3.53491),(.32344,47.81718,-3.58508),(.04808,48.20082,-4.0504),(.17413,48.65525,-3.49204),(.96732,48.62973,-3.55306),(.95882,48.6345,-3.54338),(.56438,48.60343,-3.62009),(.58156,48.44802,-3.65006),(.96275,48.68168,-3.58324),(1.12962,48.42973,-3.70164),(1.11816,48.60142,-3.71057),(1.13661,48.54495,-3.69978),(1.12205,48.60354,-3.72365),(1.14218,48.54156,-3.71106),(.49135,48.18441,-3.63342),(.53793,48.30844,-3.62622),(.3143,47.87103,-3.73707),(.35169,47.87651,-3.70063),(.24088,47.85766,-3.69691),(.41352,48.21948,-3.38581),(1.04494,48.59695,-3.85061),(.97121,48.65925,-3.80521),(.01027,47.21826,-4.22546),(.59464,48.11564,-3.50376),(.5509,48.56588,-3.27889),(.56856,48.51844,-3.27458),(.66211,48.56581,-3.32323),(.75355,48.60401,-3.38155),(.6353,48.60424,-3.3433),(.53365,47.97848,-2.75917),(.64667,47.81452,-2.83605),(.69626,47.90382,-2.95325),(.49526,47.96575,-3.14399),(.62338,48.00551,-3.11592),(.50127,47.94291,-3.13736),(.48627,48.5731,-3.06079),(.23874,48.49979,-3.12808),(.58088,48.4206,-3.26769),(.67012,48.34314,-3.35771),(.67564,48.45291,-3.33091),(.61711,47.90182,-2.82535),(.69337,47.9225,-2.95051),(.38137,48.607,-3.08737),(.27787,48.29293,-3.22079),(.28885,47.70697,-2.3404),(.21183,47.70273,-2.22488),(.22753,47.70121,-2.28404),(.94614,48.5264,-3.48656),(1.0955,48.39097,-3.75099),(1.01847,48.40577,-3.83792),(1.06503,48.52186,-3.87051),(.96376,48.37191,-3.77272),(.74558,48.36366,-3.68506),(.94633,48.57225,-3.86239),(.86636,48.67636,-3.78608),(1.01553,48.69279,-3.64815),(.92356,48.7376,-3.68708),(.83724,48.72775,-3.64263),(.80367,48.29057,-3.62748),(.08161,47.57279,-4.23114),(.1378,48.2537,-3.90125),(.16617,48.3689,-3.82345),(.43788,48.62805,-3.44194),(.34418,48.61865,-3.4707),(0,48.52841,-3.68968),(0,48.52772,-3.72513),(.38555,48.87699,-3.30178),(.55749,48.27672,-3.32167),(.5214,48.25168,-3.35846),(.51878,48.31438,-3.20993),(.57939,48.64402,-3.31379),(.39683,48.6878,-3.19171),(.38705,48.63887,-3.14297),(.22004,48.45185,-3.43181),(.51901,48.49767,-3.12037),(.52872,48.4103,-3.09676),(.52459,48.38571,-3.07646),(.52296,48.49178,-3.0978),(.48056,48.30405,-3.10271),(.5197,48.33457,-2.99925),(.43619,48.45817,-2.79641),(.42784,48.45441,-2.66881),(.47564,48.43184,-2.66616),(.33784,48.42172,-2.45153),(.42531,48.42242,-2.55546),(.37588,48.41508,-2.44616),(.15935,48.35775,-2.26205),(.18044,48.34585,-2.22175),(.27755,48.38362,-2.32036),(.08945,48.34993,-2.27764),(.08739,48.34441,-2.2346),(.5322,48.14428,-2.92604),(.5085,48.2182,-2.82188),(.51192,48.10324,-2.82985),(.37425,48.1827,-2.46521),(.29726,48.16975,-2.33742),(.4609,48.08003,-2.68251),(.19726,47.90755,-2.24128),(.18671,48.017,-2.24534),(.30039,47.9242,-2.34575),(.2148,47.78123,-2.22653),(.68624,47.88755,-2.95444),(.62267,48.02732,-3.11032),(.5683,47.91442,-3.08033),(.54814,47.85832,-3.01569),(.33029,47.71754,-2.40371),(.42505,47.75161,-2.66166),(.35857,47.77117,-2.65267),(.35805,47.79723,-2.76495),(.34487,47.81822,-2.87667),(.3473,47.7943,-2.97467),(.42219,47.78675,-2.93361),(.34358,48.04356,-3.73818),(.35972,47.92231,-3.71454),(.45568,48.14075,-3.42636),(.38812,48.11041,-3.47023),(.54988,47.92182,-3.47211),(.38896,47.98939,-3.52277),(0,47.70423,-3.90952),(.09554,47.71321,-3.93873),(.4526,47.81619,-3.04637),(.13281,47.7973,-3.01269),(.34338,48.44624,-2.81488),(.22685,48.44221,-2.82682),(.12137,48.40785,-2.71894),(.2199,48.41861,-2.70434),(.32437,48.64339,-3.21567),(.35386,48.68334,-3.19802),(.1306,48.47709,-2.93494),(.13004,48.56623,-3.01621),(.09424,48.48463,-3.52799),(.27677,48.62506,-3.30715),(.26329,48.52519,-3.33704),(0,48.35287,-3.53611),(.21472,48.35531,-3.15385),(.27451,48.4404,-3.19955),(.48901,48.54087,-3.25578),(1.07078,48.42725,-3.57391),(.97972,48.37482,-3.52884),(0,47.63098,-3.95483),(.29533,48.56491,-3.24849),(.09819,48.65799,-3.54387),(.4669,48.22194,-3.26238),(.23087,48.48949,-2.93126),(.12696,48.44279,-2.8373),(.40313,48.4809,-2.86293),(.2358,48.38615,-2.32441),(.1287,47.82246,-2.91497),(.42479,48.08112,-3.4634),(.26265,47.86033,-3.80242),(.23283,47.72583,-2.39783),(.13595,47.71699,-2.33583),(.13801,47.73483,-2.40207),(.43179,47.77298,-2.86204),(.43461,47.75744,-2.76416),(.55742,47.78335,-2.84675),(.51523,47.79752,-2.93442),(.64706,47.98794,-2.9426),(.60663,47.83687,-2.91775),(.33333,47.79818,-2.30861),(.07882,48.00323,-2.19255),(.28762,48.03774,-2.34619),(.50593,48.23947,-2.90963),(.50596,48.44908,-2.78275),(.50566,48.41086,-3.20892),(.58251,48.33092,-3.27587),(.05912,48.49302,-3.76404),(.23052,48.34724,-3.76558),(.44586,48.63083,-3.43916),(1.0051,48.68843,-3.62779),(.96275,48.64494,-3.55711),(.32332,47.75403,-2.53274),(.23597,47.75707,-2.52698),(.22028,48.28231,-3.16026),(.2979,48.58074,-3.03848),(.54272,48.31413,-2.80606),(.57122,47.77412,-2.75142),(.25666,48.01747,-3.13673),(.13687,48.09802,-3.10212),(.24711,48.10718,-3.15002),(.13279,48.01094,-3.09825),(.01094,47.31667,-4.17136),(.05656,48.19194,-4.03353),(.31798,47.82035,-3.59586),(.58889,48.69124,-3.3583),(.16087,47.6516,-4.00952),(-.27118,47.85636,-3.79074),(-.12683,47.90789,-3.75153),(-.2695,48.6477,-3.49214),(-.30769,48.72606,-3.41965),(-.35001,48.77529,-3.37089),(-.16083,48.58963,-3.60092),(-.23052,48.34724,-3.76679),(-.09333,48.16315,-3.5699),(-.16921,48.17247,-3.54425),(-.21092,48.33613,-3.44166),(-.01094,47.45786,-4.06633),(-.64015,47.80719,-2.83246),(-.13174,48.43245,-3.07645),(-.46666,48.57293,-3.24249),(-1.08728,48.66074,-3.69585),(-.87291,48.50104,-3.44492),(-1.0314,48.35943,-3.67001),(-.67012,48.34314,-3.36505),(-.80367,48.29057,-3.63035),(-.37345,48.82113,-3.34032),(-.35427,48.8128,-3.35225),(-.34165,48.79405,-3.36566),(-.37721,48.3119,-3.66887),(-.43283,48.83864,-3.30833),(-.57939,48.64402,-3.32338),(-.52577,48.35519,-3.00579),(-.37321,48.05495,-2.46591),(-.0791,47.89406,-2.21901),(-.54119,47.76788,-2.67164),(-.55742,47.78335,-2.85221),(-.59925,47.88229,-3.02115),(-.61875,47.87515,-2.9888),(-.64528,47.89204,-3.00121),(-.52998,47.75669,-2.67629),(-.35972,47.92231,-3.71454),(-.19502,47.88372,-3.92448),(-.35446,47.8033,-3.09679),(-.27675,48.39246,-2.47281),(-.33784,48.42172,-2.46127),(-.1306,48.47709,-2.93811),(-.38923,48.2135,-3.30353),(-.26329,48.52519,-3.34146),(-.13687,48.09802,-3.10414),(-.13724,48.18286,-3.10808),(-.36125,48.02676,-3.15608),(-.33064,48.06359,-3.50777),(-.44193,48.04403,-3.47121),(-.40313,48.4809,-2.87267),(-.13654,47.79261,-3.08054),(0,47.87683,-3.79722),(-.11296,47.69842,-2.21947),(0,47.68904,-2.17455),(-.10682,47.76711,-2.21842),(-.19726,47.90755,-2.26226),(-.07837,48.12675,-2.17993),(0,48.11605,-2.16008),(-.08739,48.34441,-2.23722),(-.08945,48.34993,-2.28031),(-.42784,48.45441,-2.68006),(-.49605,48.4837,-3.22161),(-.45922,48.78684,-3.32483),(-.00728,47.31741,-4.44726),(-.23394,48.71052,-3.36417),(-.32332,47.75403,-2.53726),(-.23597,47.75707,-2.53042),(-.54272,48.31413,-2.81748),(-.53365,47.97848,-2.7673),(-.25666,48.01747,-3.13987),(-.13279,48.01094,-3.09999),(-1.06675,48.57801,-3.65758),(-.56438,48.60343,-3.62553),(-.05656,48.19194,-4.03353),(.11354,47.89532,-3.76756),(.57721,48.69979,-3.35905),(.2695,48.6477,-3.48811),(.20025,48.17865,-3.85637),(.21012,48.22444,-3.8301),(.27288,48.33465,-3.72786),(.0729,47.54863,-4.04417),(.4113,47.74062,-2.40758),(.13174,48.43245,-3.07367),(.29833,48.30824,-3.29874),(1.03062,48.59955,-3.61844),(1.0653,48.39208,-3.59957),(.60728,48.63495,-3.53006),(.00771,47.46327,-4.43367),(.28032,48.80151,-3.38125),(.50051,48.56306,-3.26605),(.17171,48.36977,-2.33374),(.29347,48.37163,-2.31972),(.18599,48.33173,-2.21233),(.3105,48.29249,-2.32619),(.18702,48.26309,-2.21785),(.08571,48.23442,-2.1568),(.10682,47.76711,-2.18281),(.48266,47.74567,-2.54696),(.15529,47.78557,-3.99613),(.44449,47.8904,-3.61571),(.0844,47.63787,-3.98698),(.18826,47.72201,-3.95461),(.34942,48.10052,-3.48867),(.33064,48.06359,-3.50576),(.34614,48.00783,-3.52836),(.25907,47.91128,-3.13043),(.09664,48.09103,-3.61431),(.22655,48.18426,-3.49893),(0,47.76108,-2.52594),(0,47.73261,-2.41234),(.13729,47.76128,-2.52649),(.01106,47.36458,-4.12176),(-.01106,47.36458,-4.12176),(.00617,47.20132,-4.43339),(-.00654,47.76817,-4.2958),(.00654,47.76817,-4.2958),(-.00645,48.11063,-4.12722),(.0046,48.12181,-4.12686),(.00645,48.11063,-4.12722),(-.0046,48.12181,-4.12686),(.13472,48.35173,-3.09123),(.13599,48.26833,-3.10156),(.16921,48.17247,-3.54295),(.13575,47.80318,-3.09178),(.13256,47.90556,-3.10188),(.44193,48.04403,-3.46862),(0,48.43938,-2.84493),(0,48.39843,-2.7325),(.32715,48.42789,-2.6857),(.20969,48.39735,-2.59212),(.21557,47.79706,-3.88001),(.25427,47.84949,-3.79229),(.17544,48.08133,-3.91573),(.14828,47.97821,-3.98074),(.09549,47.76756,-4.12528),(.11555,47.8663,-4.05236),(.13099,47.78394,-2.65475),(0,47.78377,-2.6542),(.52998,47.75669,-2.66998),(.2151,47.71523,-2.21578),(.6247,47.953,-3.08258),(.42789,47.8077,-2.41899),(.07837,48.12675,-2.17791),(.41665,48.19499,-2.57694),(.39844,48.31855,-2.451),(.53564,48.31339,-2.88865),(0,48.36826,-2.50186),(.09288,48.36127,-2.34381),(.10586,48.37787,-2.49113),(0,48.35368,-2.35873),(.07486,48.3196,-2.16098),(.4875,48.41698,-2.66357),(.497,48.32755,-2.66335),(.28096,48.81069,-3.29549),(.23394,48.71052,-3.35981),(.34167,48.62892,-3.46074),(.42324,48.70186,-3.37983),(.10618,48.15315,-3.97385),(.05583,47.94883,-4.12559),(.07488,48.05777,-4.04344),(.00623,47.87807,-4.24285),(.00623,47.99468,-4.18504),(.04385,47.84464,-4.19671),(.08333,47.6702,-4.17926),(.76136,48.47859,-3.39903),(1.0314,48.35943,-3.66889),(1.01333,48.58384,-3.58916),(1.13495,48.46461,-3.68417),(.29333,48.49722,-2.92835),(.2414,47.78137,-2.65219),(.29659,48.51077,-3.18402),(.19494,48.38043,-2.4787),(.62477,47.91385,-3.03788),(.43979,48.40773,-2.5575),(0,47.79281,-3.07132),(.48772,48.20798,-2.77652),(.45207,48.20092,-2.68007),(.42385,48.07874,-3.67602),(.4011,48.18438,-3.67486),(.06978,47.37138,-4.13057),(.34513,48.8565,-3.24902),(.34844,48.77583,-3.22963),(.37345,48.82113,-3.33301),(.39298,48.80805,-3.33142),(.40288,48.78497,-3.3388),(.44557,47.96744,-3.65321),(.27134,47.8532,-3.78887),(.27118,47.85636,-3.79074),(-.34844,48.77583,-3.23714),(-.35386,48.68334,-3.20551),(-.28096,48.81069,-3.30135),(-.30724,48.71877,-3.26314),(-.34513,48.8565,-3.25658),(-.21557,47.79706,-3.88001),(-.4011,48.18438,-3.67656),(-.30093,48.19522,-3.74151),(-.42385,48.07874,-3.67707),(-.34167,48.62892,-3.46587),(-.30684,48.85853,-3.35294),(-.28032,48.80151,-3.38654),(0,48.25318,-3.55474),(-.08263,48.243,-3.53206),(-.06978,47.37138,-4.13057),(-.45207,48.20092,-2.68972),(-.2151,47.71523,-2.27333),(-.21183,47.70273,-2.28267),(-.13575,47.80318,-3.09299),(-.18599,48.33173,-2.21785),(-.27755,48.38362,-2.32857),(-.29347,48.37163,-2.32831),(-.18044,48.34585,-2.22714),(-.4875,48.41698,-2.67587),(0,48.53682,-2.99925),(0,48.53379,-3.01159),(-.58088,48.4206,-3.27618),(-.67564,48.45291,-3.33965),(0,48.26424,-3.08202),(0,48.17828,-3.08403),(-.13599,48.26833,-3.10399),(-.76071,48.47717,-3.40957),(-.08333,47.6702,-4.17926),(-.09549,47.76756,-4.12528),(-.04035,47.74081,-4.25666),(-.04385,47.84464,-4.19671),(-.00623,47.87807,-4.24285),(-.45363,48.32884,-2.57231),(-.497,48.32755,-2.67507),(-.43979,48.40773,-2.56926),(-.18702,48.26309,-2.22313),(-.09288,48.36127,-2.34656),(0,48.33509,-2.28899),(-.29726,48.16975,-2.34487),(-.3105,48.29249,-2.33475),(-.18251,48.14799,-2.24389),(-.41665,48.19499,-2.58639),(-.18671,48.017,-2.25007),(-.28762,48.03774,-2.35257),(-.58496,48.06442,-2.94208),(-.55644,48.00306,-2.83721),(-.13099,47.78394,-2.6566),(-.13729,47.76128,-2.52933),(-.11555,47.8663,-4.05236),(-.14828,47.97821,-3.98074),(-.17544,48.08133,-3.91573),(-.19494,48.38043,-2.48426),(-.30476,48.41099,-2.58417),(-.2199,48.41861,-2.71016),(-.32715,48.42789,-2.69432),(-.20969,48.39735,-2.59789),(-.22685,48.44221,-2.83252),(-.34338,48.44624,-2.82338),(-.12137,48.40785,-2.72215),(-.12696,48.44279,-2.84051),(-.34942,48.10052,-3.4911),(-.13256,47.90556,-3.10332),(-.15834,48.24633,-3.51447),(-.13472,48.35173,-3.09386),(-.21472,48.35531,-3.15775),(0,48.4867,-3.02673),(0,48.09122,-3.07783),(-.27185,47.94116,-3.56273),(0,47.90952,-3.07614),(0,48.47024,-2.92036),(-.23518,47.8252,-2.90157),(-.60597,47.901,-3.04276),(-.62477,47.91385,-3.04374),(-.6247,47.953,-3.0885),(0,48.32474,-2.21757),(-.38905,48.4013,-2.45601),(-.39844,48.31855,-2.46155),(-.53564,48.31339,-2.89931),(-.36196,48.70542,-3.39931),(-.42324,48.70186,-3.38705),(-.10618,48.15315,-3.97385),(-.07488,48.05777,-4.04344),(-.39298,48.80805,-3.33903),(-.36926,48.76019,-3.37042),(-.40288,48.78497,-3.34642),(-.39002,48.76507,-3.36149),(-1.01333,48.58384,-3.59449),(-1.0223,48.54752,-3.57872),(-1.13495,48.46461,-3.68505),(-.12746,47.7991,-2.78419),(-.24091,47.80426,-2.77682),(-.29659,48.51077,-3.18982),(-.07486,48.3196,-2.16322),(-.44557,47.96744,-3.65367),(-.11542,47.96276,-3.71467),(.10826,47.94202,-3.7429),(.11542,47.96276,-3.71457),(.27185,47.94116,-3.56188),(.39002,48.76507,-3.35429),(.36926,48.76019,-3.36364),(.35427,48.8128,-3.34539),(.34165,48.79405,-3.35918),(.30093,48.19522,-3.74047),(.30724,48.71877,-3.2568),(.49289,48.08927,-2.76903),(.60597,47.901,-3.03712),(.11415,48.38335,-2.60633),(.13219,47.69135,-2.24424),(0,47.70309,-2.33215),(0,47.67734,-2.26011),(1.0223,48.54752,-3.57352),(.04035,47.74081,-4.25666),(0,48.3777,-2.61983),(0,48.30722,-2.14185),(.45363,48.32884,-2.5609),(.18251,48.14799,-2.2392),(.55644,48.00306,-2.82904),(.58496,48.06442,-2.93377),(.11296,47.69842,-2.17685),(.12746,47.7991,-2.78253),(0,47.79207,-2.78469),(.23518,47.8252,-2.89878),(.13724,48.18286,-3.10585),(.09333,48.16315,-3.56923),(0,48.34792,-3.06882),(-.00623,47.99468,-4.18504),(.00728,47.31741,-4.44726),(0,48.11722,-3.65638),(.0766,47.93099,-3.76208),(.10974,47.68714,-2.18637),(0,47.67916,-2.1838),(.38905,48.4013,-2.44506),(.45337,48.72968,-3.35315),(.24091,47.80426,-2.7737),(0,48.43344,-3.04376),(0,48.1792,-3.6046),(0,48.0101,-3.07328),(-.10974,47.68714,-2.22831),(-.10586,48.37787,-2.49416),(-.13219,47.69135,-2.28907),(-.2414,47.78137,-2.65552),(-.29333,48.49722,-2.9354),(-.05583,47.94883,-4.12559),(-.37425,48.1827,-2.47413),(-.11415,48.38335,-2.60946),(-.32437,48.64339,-3.22232),(.35001,48.77529,-3.36438)]))),
        Shape(DEF='t6disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t6disc_Geo',coordIndex=[0,1,2,-1,0,3,1,-1,4,5,6,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,12,34,31,-1,35,27,21,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,40,46,-1,47,48,49,-1,50,51,45,-1,52,53,54,-1,4,55,56,-1,57,58,59,-1,60,61,59,-1,62,50,63,-1,64,65,66,-1,67,51,50,-1,65,64,68,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,88,-1,91,92,93,-1,94,95,96,-1,96,97,98,-1,99,100,101,-1,102,103,37,-1,104,105,106,-1,107,108,109,-1,110,111,109,-1,112,111,113,-1,114,115,116,-1,117,118,119,-1,105,120,121,-1,122,123,124,-1,81,80,125,-1,126,127,128,-1,128,129,126,-1,108,123,130,-1,131,132,73,-1,109,133,107,-1,134,119,135,-1,132,104,116,-1,136,137,138,-1,139,140,141,-1,37,142,143,-1,99,75,79,-1,144,145,146,-1,147,148,149,-1,94,150,151,-1,94,98,150,-1,152,153,95,-1,154,91,155,-1,156,157,88,-1,155,158,159,-1,160,83,82,-1,83,161,82,-1,162,161,85,-1,125,76,75,-1,163,164,79,-1,68,165,36,-1,166,167,11,-1,168,51,67,-1,58,9,8,-1,169,59,61,-1,3,170,171,-1,172,173,54,-1,174,175,176,-1,43,177,178,-1,179,177,180,-1,40,45,51,-1,181,38,37,-1,182,183,184,-1,16,18,20,-1,183,185,184,-1,186,130,10,-1,32,10,33,-1,55,4,187,-1,188,0,2,-1,188,2,189,-1,4,190,187,-1,32,186,10,-1,31,34,17,-1,191,192,193,-1,19,27,26,-1,37,143,181,-1,51,41,40,-1,179,180,194,-1,43,180,177,-1,176,195,174,-1,54,55,172,-1,3,0,170,-1,71,169,61,-1,8,59,58,-1,196,39,197,-1,198,199,185,-1,200,84,201,-1,165,102,36,-1,78,163,79,-1,165,202,102,-1,163,203,164,-1,162,80,161,-1,159,204,155,-1,156,88,90,-1,91,93,155,-1,164,145,79,-1,147,205,148,-1,144,99,145,-1,206,207,152,-1,99,79,145,-1,37,103,142,-1,208,132,131,-1,106,115,114,-1,132,116,73,-1,134,135,209,-1,210,121,120,-1,130,110,108,-1,130,186,110,-1,81,125,211,-1,123,108,124,-1,209,212,213,-1,214,136,138,-1,133,210,120,-1,212,215,216,-1,121,106,105,-1,117,119,134,-1,116,104,114,-1,115,140,116,-1,109,108,110,-1,121,136,214,-1,107,124,108,-1,114,104,106,-1,217,141,218,-1,37,36,102,-1,101,75,99,-1,96,98,94,-1,94,152,95,-1,92,219,93,-1,220,89,88,-1,88,157,86,-1,83,85,161,-1,80,82,161,-1,221,211,101,-1,77,79,75,-1,222,122,223,-1,68,36,65,-1,50,62,67,-1,7,41,224,-1,8,60,59,-1,169,57,59,-1,55,54,56,-1,54,173,52,-1,43,178,225,-1,47,49,226,-1,46,227,45,-1,39,228,40,-1,65,36,38,-1,229,230,231,-1,27,19,21,-1,12,31,33,-1,20,232,191,-1,31,30,32,-1,25,27,35,-1,25,233,26,-1,24,234,22,-1,20,18,21,-1,15,235,236,-1,12,33,10,-1,9,197,7,-1,4,6,190,-1,237,238,63,-1,239,238,237,-1,240,66,241,-1,64,66,240,-1,32,242,186,-1,32,29,242,-1,32,30,29,-1,243,244,245,-1,246,244,243,-1,23,247,13,-1,23,22,247,-1,248,249,250,-1,248,244,249,-1,192,251,250,-1,191,251,192,-1,232,251,191,-1,251,229,252,-1,229,251,230,-1,253,229,254,-1,253,236,229,-1,28,31,17,-1,31,28,30,-1,182,255,183,-1,182,256,255,-1,65,228,39,-1,65,38,228,-1,257,258,259,-1,257,260,258,-1,226,179,261,-1,226,177,179,-1,262,263,264,-1,265,263,262,-1,177,49,178,-1,49,177,226,-1,266,267,268,-1,269,267,266,-1,270,47,271,-1,227,47,270,-1,272,170,273,-1,272,171,170,-1,274,176,275,-1,176,274,195,-1,276,277,278,-1,279,277,276,-1,5,195,239,-1,5,174,195,-1,170,188,280,-1,0,188,170,-1,167,281,282,-1,167,166,281,-1,283,241,281,-1,240,241,283,-1,194,1,284,-1,1,194,268,-1,237,271,6,-1,237,270,271,-1,273,285,272,-1,273,24,285,-1,286,287,254,-1,175,287,286,-1,198,70,69,-1,198,185,70,-1,10,166,11,-1,288,166,10,-1,289,223,122,-1,160,223,289,-1,290,73,116,-1,290,74,73,-1,89,291,292,-1,89,220,291,-1,119,92,91,-1,92,119,118,-1,293,203,294,-1,203,293,164,-1,97,295,98,-1,296,295,97,-1,297,298,127,-1,265,298,297,-1,299,300,301,-1,299,302,300,-1,302,303,222,-1,303,302,304,-1,219,305,126,-1,305,219,306,-1,90,159,156,-1,159,90,204,-1,307,308,309,-1,308,307,310,-1,311,74,290,-1,74,311,310,-1,155,312,154,-1,312,155,204,-1,299,221,202,-1,221,299,301,-1,146,164,293,-1,145,164,146,-1,151,152,94,-1,313,152,151,-1,314,315,316,-1,314,142,315,-1,317,205,318,-1,205,317,148,-1,319,147,149,-1,319,316,147,-1,206,320,207,-1,320,206,321,-1,258,314,322,-1,260,314,258,-1,100,102,101,-1,103,102,100,-1,323,208,131,-1,324,208,323,-1,109,112,133,-1,109,111,112,-1,217,292,291,-1,215,292,217,-1,217,325,326,-1,217,218,325,-1,107,120,324,-1,120,107,133,-1,138,325,214,-1,138,327,325,-1,328,216,326,-1,329,216,328,-1,112,138,137,-1,112,330,138,-1,330,112,113,-1,329,331,213,-1,331,329,332,-1,331,333,334,-1,331,335,333,-1,336,337,330,-1,336,338,337,-1,131,289,323,-1,289,131,339,-1,78,340,309,-1,78,77,340,-1,86,341,342,-1,86,157,341,-1,158,128,343,-1,158,129,128,-1,157,296,341,-1,157,156,296,-1,203,308,344,-1,203,163,308,-1,81,221,301,-1,211,221,81,-1,122,323,289,-1,124,323,122,-1,338,345,337,-1,338,246,345,-1,334,346,117,-1,334,333,346,-1,328,332,329,-1,332,328,345,-1,326,327,328,-1,326,325,327,-1,105,324,120,-1,208,324,105,-1,214,218,347,-1,325,218,214,-1,348,215,212,-1,348,292,215,-1,106,349,115,-1,106,347,349,-1,210,136,121,-1,210,137,136,-1,124,324,323,-1,107,324,124,-1,141,347,218,-1,141,349,347,-1,316,144,147,-1,315,144,316,-1,143,314,260,-1,143,142,314,-1,95,319,149,-1,153,319,95,-1,316,322,314,-1,322,316,319,-1,350,321,206,-1,321,350,262,-1,162,77,76,-1,77,162,340,-1,92,306,219,-1,92,351,306,-1,352,88,87,-1,352,220,88,-1,310,72,74,-1,72,310,307,-1,344,310,311,-1,344,308,310,-1,126,93,219,-1,126,129,93,-1,353,303,304,-1,354,303,353,-1,82,301,300,-1,81,301,82,-1,127,355,128,-1,127,298,355,-1,296,317,341,-1,296,97,317,-1,75,211,125,-1,211,75,101,-1,118,351,92,-1,118,356,351,-1,292,312,89,-1,312,292,348,-1,290,140,357,-1,290,116,140,-1,289,83,160,-1,83,289,339,-1,354,10,130,-1,354,288,10,-1,70,169,71,-1,169,70,358,-1,233,175,286,-1,176,175,233,-1,272,359,52,-1,272,285,359,-1,196,65,39,-1,196,66,65,-1,63,270,237,-1,63,50,270,-1,284,179,194,-1,284,187,179,-1,263,297,189,-1,263,265,297,-1,282,241,360,-1,241,282,281,-1,288,281,166,-1,288,283,281,-1,305,280,188,-1,305,306,280,-1,239,274,238,-1,239,195,274,-1,69,278,198,-1,69,276,278,-1,287,54,53,-1,287,56,54,-1,280,273,170,-1,361,273,280,-1,196,241,66,-1,196,360,241,-1,50,227,270,-1,50,45,227,-1,43,266,180,-1,43,269,266,-1,362,257,363,-1,181,257,362,-1,47,261,271,-1,47,226,261,-1,48,364,49,-1,364,48,363,-1,320,42,44,-1,320,321,42,-1,46,363,48,-1,46,362,363,-1,365,286,231,-1,26,286,365,-1,26,233,286,-1,35,182,184,-1,182,35,21,-1,365,19,26,-1,365,366,19,-1,193,17,16,-1,28,17,193,-1,185,35,184,-1,35,185,25,-1,236,359,15,-1,359,236,253,-1,234,346,22,-1,356,346,234,-1,236,252,229,-1,236,235,252,-1,14,235,15,-1,14,367,235,-1,250,368,192,-1,250,249,368,-1,247,14,13,-1,247,369,14,-1,335,245,369,-1,243,245,335,-1,368,242,29,-1,242,368,336,-1,8,224,60,-1,7,224,8,-1,239,6,5,-1,239,237,6,-1,44,370,320,-1,44,371,370,-1,1,172,284,-1,3,172,1,-1,372,63,238,-1,62,63,372,-1,196,9,360,-1,196,197,9,-1,255,11,373,-1,255,12,11,-1,183,70,185,-1,183,358,70,-1,244,338,249,-1,338,244,246,-1,346,247,22,-1,333,247,346,-1,245,248,367,-1,245,244,248,-1,250,252,248,-1,252,250,251,-1,256,21,18,-1,256,182,21,-1,230,232,366,-1,230,251,232,-1,24,13,285,-1,24,23,13,-1,231,254,229,-1,254,231,286,-1,191,16,20,-1,16,191,193,-1,256,12,255,-1,256,34,12,-1,366,231,230,-1,365,231,366,-1,38,362,228,-1,362,38,181,-1,259,370,371,-1,259,258,370,-1,44,225,371,-1,44,43,225,-1,48,227,46,-1,227,48,47,-1,267,264,263,-1,267,269,264,-1,371,364,259,-1,371,225,364,-1,42,269,43,-1,42,264,269,-1,297,188,189,-1,297,305,188,-1,62,277,67,-1,62,372,277,-1,171,52,173,-1,272,52,171,-1,199,274,275,-1,199,374,274,-1,372,278,277,-1,372,374,278,-1,4,174,5,-1,4,56,174,-1,282,57,167,-1,57,282,58,-1,283,375,240,-1,375,283,353,-1,279,61,60,-1,279,276,61,-1,268,2,1,-1,2,268,267,-1,271,190,6,-1,190,271,261,-1,224,51,168,-1,224,41,51,-1,361,24,273,-1,361,234,24,-1,254,53,253,-1,287,53,254,-1,185,275,25,-1,199,275,185,-1,167,373,11,-1,167,57,373,-1,222,123,122,-1,222,303,123,-1,201,72,200,-1,72,201,73,-1,220,139,291,-1,220,352,139,-1,135,91,154,-1,91,135,119,-1,318,294,342,-1,294,318,293,-1,343,98,295,-1,343,150,98,-1,299,304,302,-1,299,376,304,-1,302,223,300,-1,222,223,302,-1,85,200,377,-1,84,200,85,-1,378,86,379,-1,86,378,87,-1,309,377,307,-1,309,340,377,-1,357,311,290,-1,357,378,311,-1,89,204,90,-1,89,312,204,-1,205,293,318,-1,205,146,293,-1,355,151,150,-1,355,313,151,-1,96,149,148,-1,95,149,96,-1,298,262,350,-1,298,265,262,-1,148,97,96,-1,148,317,97,-1,370,322,380,-1,322,370,258,-1,315,103,100,-1,315,142,103,-1,115,141,140,-1,115,349,141,-1,208,104,132,-1,208,105,104,-1,133,137,210,-1,133,112,137,-1,291,141,217,-1,291,139,141,-1,346,118,117,-1,346,356,118,-1,326,215,217,-1,216,215,326,-1,216,213,212,-1,213,216,329,-1,330,327,138,-1,337,327,330,-1,213,334,209,-1,334,213,331,-1,332,335,331,-1,332,243,335,-1,242,330,113,-1,242,336,330,-1,201,131,73,-1,201,339,131,-1,76,80,162,-1,76,125,80,-1,342,379,86,-1,379,342,294,-1,159,343,295,-1,159,158,343,-1,68,376,165,-1,375,376,68,-1,156,295,296,-1,156,159,295,-1,344,294,203,-1,344,379,294,-1,202,376,299,-1,202,165,376,-1,242,110,186,-1,113,110,242,-1,110,113,111,-1,345,243,332,-1,345,246,243,-1,334,134,209,-1,117,134,334,-1,337,328,327,-1,345,328,337,-1,135,212,209,-1,135,348,212,-1,347,121,214,-1,106,121,347,-1,100,144,315,-1,100,99,144,-1,370,207,320,-1,370,380,207,-1,153,207,380,-1,152,207,153,-1,146,147,144,-1,146,205,147,-1,350,355,298,-1,313,355,350,-1,319,380,322,-1,380,319,153,-1,313,206,152,-1,206,313,350,-1,126,297,127,-1,297,126,305,-1,309,163,78,-1,163,309,308,-1,352,378,357,-1,352,87,378,-1,307,200,72,-1,200,307,377,-1,311,379,344,-1,379,311,378,-1,155,129,158,-1,129,155,93,-1,160,300,223,-1,160,82,300,-1,375,304,376,-1,375,353,304,-1,85,340,162,-1,340,85,377,-1,128,150,343,-1,128,355,150,-1,341,318,342,-1,341,317,318,-1,102,221,101,-1,202,221,102,-1,348,154,312,-1,154,348,135,-1,352,140,139,-1,352,357,140,-1,83,201,84,-1,83,339,201,-1,123,354,130,-1,303,354,123,-1,169,373,57,-1,169,358,373,-1,233,275,176,-1,275,233,25,-1,52,253,53,-1,52,359,253,-1,351,234,361,-1,356,234,351,-1,197,41,7,-1,197,39,41,-1,261,187,190,-1,187,261,179,-1,267,189,2,-1,189,267,263,-1,360,58,282,-1,360,9,58,-1,288,353,283,-1,288,354,353,-1,69,61,276,-1,69,71,61,-1,3,173,172,-1,3,171,173,-1,374,238,274,-1,372,238,374,-1,198,374,199,-1,198,278,374,-1,56,175,174,-1,287,175,56,-1,306,361,280,-1,351,361,306,-1,168,60,224,-1,168,279,60,-1,321,264,42,-1,321,262,264,-1,259,363,257,-1,259,364,363,-1,180,268,194,-1,180,266,268,-1,364,178,49,-1,364,225,178,-1,257,143,260,-1,181,143,257,-1,46,228,362,-1,40,228,46,-1,20,366,232,-1,20,19,366,-1,15,285,13,-1,285,15,359,-1,18,34,256,-1,17,34,18,-1,235,248,252,-1,235,367,248,-1,192,28,193,-1,368,28,192,-1,368,29,28,-1,369,367,14,-1,369,245,367,-1,333,369,247,-1,335,369,333,-1,249,336,368,-1,336,249,338,-1,373,183,255,-1,373,358,183,-1,279,67,277,-1,168,67,279,-1,284,55,187,-1,172,55,284,-1,240,68,64,-1,240,375,68,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t6disc_Coord',point=[(.2149,47.64141,-2.20608),(.3228,47.71783,-2.27455),(.2121,47.69717,-2.19783),(.32224,47.66156,-2.2911),(.51504,47.69362,-2.65187),(.5326,47.70334,-2.75489),(.53956,47.76485,-2.74273),(.35629,47.79903,-3.08941),(.37161,47.76344,-3.11649),(.28086,47.75092,-3.1327),(.11243,47.64116,-3.13435),(.19835,47.64542,-3.1598),(.19025,47.62786,-3.11453),(.1908,47.5591,-2.38982),(.18342,47.55558,-2.48878),(.27598,47.57027,-2.47878),(.20837,47.56894,-2.98253),(.19055,47.56994,-3.00196),(.29922,47.58013,-2.96397),(.37646,47.57218,-2.88749),(.29619,47.56192,-2.89644),(.38364,47.58101,-2.9545),(.08678,47.55237,-2.34593),(.13633,47.55321,-2.35755),(.18583,47.54642,-2.26606),(.44742,47.57905,-2.93576),(.38851,47.57659,-2.87369),(.38661,47.57735,-2.88196),(.17145,47.57076,-2.98665),(.09174,47.57242,-2.9883),(.09837,47.58637,-3.05538),(.11407,47.58818,-3.07249),(.08932,47.59102,-3.06519),(.10139,47.5973,-3.07892),(.19398,47.62026,-3.10068),(.39852,47.58598,-2.95253),(0,47.78812,-3.04371),(0,47.81506,-2.9767),(.13281,47.7973,-2.99987),(.25839,47.7792,-3.095),(.3473,47.7943,-2.9635),(.35297,47.80277,-3.08044),(.13595,47.71699,-2.31052),(.23283,47.72583,-2.37131),(.13801,47.73483,-2.37621),(.42219,47.78675,-2.9228),(.34487,47.81822,-2.86073),(.43461,47.75744,-2.75002),(.35805,47.79723,-2.7467),(.35857,47.77117,-2.63252),(.50478,47.79591,-2.92275),(.44859,47.81493,-3.03371),(.35394,47.5858,-2.46292),(.41238,47.58516,-2.5803),(.45079,47.62189,-2.55497),(.46331,47.673,-2.54908),(.48493,47.6428,-2.66763),(.32671,47.68186,-3.15961),(.30442,47.717,-3.15248),(.38563,47.71807,-3.13523),(.38777,47.76367,-3.11545),(.41363,47.71555,-3.12743),(.50952,47.79242,-2.93064),(.51024,47.79098,-2.92383),(.13543,47.78821,-3.07267),(.13766,47.79347,-3.0634),(.13817,47.78809,-3.07356),(.45423,47.80984,-3.03682),(0,47.78122,-3.05233),(.43675,47.66535,-3.11938),(.42917,47.65818,-3.11771),(.43232,47.66607,-3.12147),(-.44132,47.62854,-3.0622),(-.43334,47.62252,-3.06188),(-.44218,47.62665,-3.05955),(-.35297,47.80277,-3.08044),(-.3577,47.79944,-3.08902),(-.4533,47.81287,-3.04436),(-.45423,47.80984,-3.03682),(-.44859,47.81493,-3.03371),(-.37161,47.76344,-3.11649),(-.28086,47.75092,-3.1327),(-.30442,47.717,-3.15248),(-.39552,47.67251,-3.14176),(-.43232,47.66607,-3.12147),(-.41363,47.71555,-3.12743),(-.5326,47.70334,-2.75489),(-.50528,47.64545,-2.76788),(-.48493,47.6428,-2.66763),(-.41238,47.58516,-2.5803),(-.43951,47.62189,-2.57033),(-.19165,47.5501,-2.30612),(-.08763,47.52729,-2.23516),(-.21216,47.5894,-2.27667),(-.32203,47.71754,-2.40389),(-.32332,47.75403,-2.50944),(-.38638,47.73703,-2.52728),(-.46523,47.73519,-2.53818),(-.3947,47.72799,-2.39562),(-.3473,47.7943,-2.9635),(-.243,47.79025,-2.99143),(-.25839,47.7792,-3.095),(-.13766,47.79347,-3.0634),(-.13281,47.7973,-2.99987),(-.39852,47.58598,-2.95253),(-.38364,47.58101,-2.9545),(-.37646,47.57218,-2.88749),(-.19398,47.62026,-3.10068),(-.10139,47.5973,-3.07892),(-.11407,47.58818,-3.07249),(-.08932,47.59102,-3.06519),(-.09837,47.58637,-3.05538),(-.17145,47.57076,-2.98665),(-.09174,47.57242,-2.9883),(-.38661,47.57735,-2.88196),(-.38851,47.57659,-2.87369),(-.44742,47.57905,-2.93576),(-.08678,47.55237,-2.36912),(-.0833,47.52356,-2.24209),(-.18583,47.54642,-2.3129),(-.29922,47.58013,-2.96397),(-.29619,47.56192,-2.89644),(-.19835,47.64542,-3.1598),(-.11243,47.64116,-3.13435),(-.19025,47.62786,-3.11453),(-.35629,47.79903,-3.08941),(-.11105,47.62558,-2.19797),(-.10986,47.68151,-2.19782),(-.2121,47.69717,-2.25535),(-.2149,47.64141,-2.26586),(0,47.62165,-3.12209),(-.38255,47.63636,-3.08634),(-.38783,47.63424,-3.07404),(-.19055,47.56994,-3.00196),(-.13633,47.55321,-2.38714),(-.2815,47.571,-2.38078),(-.26576,47.56208,-2.88706),(-.18715,47.56923,-2.97113),(-.17928,47.56327,-2.89421),(-.45363,47.59677,-2.78623),(-.46289,47.58105,-2.86115),(-.3758,47.58621,-2.78651),(-.1287,47.82246,-2.89685),(0,47.82241,-2.88645),(-.34487,47.81822,-2.86073),(-.42219,47.78675,-2.9228),(-.43179,47.77298,-2.84993),(-.35805,47.79723,-2.7467),(-.42505,47.75161,-2.64463),(-.35857,47.77117,-2.63252),(-.31943,47.72189,-2.30628),(-.28162,47.70697,-2.3577),(-.23283,47.72583,-2.39633),(-.23597,47.75707,-2.5027),(-.28857,47.57488,-2.37383),(-.31607,47.61114,-2.33851),(-.46331,47.673,-2.54908),(-.50215,47.69362,-2.66842),(-.32224,47.66156,-2.32128),(-.39546,47.66818,-2.41194),(-.32671,47.68186,-3.15961),(-.38563,47.71807,-3.13523),(-.38777,47.76367,-3.11545),(-.50952,47.79242,-2.93064),(-.50478,47.79591,-2.92275),(-.13543,47.78821,-3.07267),(.19454,47.65337,-3.16298),(.19971,47.65413,-3.16364),(.4533,47.81287,-3.04436),(.39552,47.67251,-3.14176),(.21216,47.5894,-2.2207),(.30816,47.61114,-2.32279),(.39546,47.66818,-2.41019),(.37631,47.61947,-2.44006),(.50528,47.64545,-2.76788),(.4632,47.60151,-2.78606),(.47183,47.58595,-2.86102),(.39629,47.73703,-2.51249),(.32332,47.75403,-2.50944),(.46523,47.73519,-2.53818),(.33029,47.71754,-2.38003),(.1287,47.82246,-2.89685),(.37386,47.62859,-3.0747),(.38255,47.63636,-3.08634),(.38783,47.63424,-3.07404),(.43334,47.62252,-3.06188),(0,47.59549,-3.0298),(.46962,47.72962,-2.53672),(.11105,47.62558,-2.15581),(.10986,47.68151,-2.15692),(.51289,47.75056,-2.65705),(.26576,47.56208,-2.88706),(.17928,47.56327,-2.89421),(.18715,47.56923,-2.97113),(.3947,47.72799,-2.39385),(.51128,47.64144,-2.85452),(.25575,47.775,-3.10471),(.26084,47.77547,-3.10494),(.44132,47.62854,-3.0622),(.44218,47.62665,-3.05955),(-.43675,47.66535,-3.11938),(-.42917,47.65818,-3.11771),(-.13817,47.78809,-3.07356),(-.51024,47.79098,-2.92383),(-.37631,47.61947,-2.44145),(-.43461,47.75744,-2.75002),(-.13595,47.71699,-2.346),(-.13801,47.73483,-2.40116),(-.37386,47.62859,-3.0747),(-.1908,47.5591,-2.41575),(-.20837,47.56894,-2.98253),(-.26084,47.77547,-3.10494),(-.27598,47.57027,-2.48207),(-.18342,47.55558,-2.49483),(-.29139,47.56492,-2.87295),(-.33357,47.57681,-2.59148),(-.27146,47.56902,-2.59804),(-.35262,47.58851,-2.68963),(-.3611,47.58306,-2.78762),(-.10375,47.57084,-2.21154),(-.44121,47.60704,-2.6861),(-.25575,47.775,-3.10471),(-.19454,47.65337,-3.16298),(-.19971,47.65413,-3.16364),(.3577,47.79944,-3.08902),(.23597,47.75707,-2.50146),(.42505,47.75161,-2.64463),(.43179,47.77298,-2.84993),(.243,47.79025,-2.99143),(.35262,47.58851,-2.68963),(.3611,47.58306,-2.78762),(.3758,47.58621,-2.78651),(.29139,47.56492,-2.87295),(.46289,47.58105,-2.86115),(.0833,47.52356,-2.2125),(.27146,47.56902,-2.59804),(.33357,47.57681,-2.59148),(.53539,47.77598,-2.83949),(.51134,47.71931,-2.93404),(.53353,47.70838,-2.84898),(.12551,47.74864,-3.10434),(.15296,47.74725,-3.11349),(0,47.57869,-2.97075),(0,47.54806,-2.60936),(.0821,47.55331,-2.70022),(.08259,47.54694,-2.61056),(0,47.54937,-2.70309),(.08491,47.54717,-2.41857),(.17605,47.56142,-2.69809),(.08399,47.55796,-2.79763),(.17772,47.56202,-2.79801),(.28447,47.56917,-2.79191),(.27529,47.57217,-2.69518),(.40344,47.5811,-2.58511),(.43161,47.6029,-2.6895),(.31381,47.64538,-3.1024),(.31173,47.63686,-3.08936),(.12746,47.7991,-2.76083),(0,47.78377,-2.6276),(.13099,47.78394,-2.62955),(0,47.79207,-2.76236),(.50857,47.7559,-2.65763),(0,47.67734,-2.23347),(.10763,47.68703,-2.16304),(.13219,47.69135,-2.21761),(0,47.67046,-2.16905),(.28162,47.70697,-2.32762),(.20904,47.70199,-2.20256),(.31943,47.72189,-2.2775),(.22753,47.70121,-2.25841),(.52999,47.78078,-2.83789),(.5346,47.76965,-2.7421),(.28857,47.57488,-2.34935),(.19165,47.5501,-2.25759),(.49249,47.64661,-2.93747),(.45591,47.58385,-2.93672),(.45764,47.71661,-3.10617),(.46866,47.75109,-3.05278),(.46412,47.68656,-3.06084),(.46364,47.76866,-3.07864),(.10375,47.57084,-2.17259),(.17206,47.69606,-3.14617),(.21775,47.70058,-3.15269),(.11701,47.69909,-3.12776),(.39898,47.7232,-2.3923),(.2815,47.571,-2.35688),(.45363,47.59677,-2.78623),(.44121,47.60704,-2.6861),(.11176,47.64941,-3.13826),(-.32597,47.67362,-3.15585),(-.45591,47.58385,-2.93672),(-.43161,47.6029,-2.6895),(-.40344,47.5811,-2.58511),(-.52999,47.78078,-2.83789),(-.53539,47.77598,-2.83949),(-.39898,47.7232,-2.39396),(-.46962,47.72962,-2.53672),(0,47.66412,-2.16311),(-.10763,47.68703,-2.20303),(-.15296,47.74725,-3.11349),(-.21775,47.70058,-3.15269),(-.23916,47.74719,-3.13063),(-.17206,47.69606,-3.14617),(-.11176,47.64941,-3.13826),(-.11701,47.69909,-3.12776),(0,47.612,-2.16041),(0,47.55903,-2.17502),(-.46412,47.68656,-3.06084),(-.50644,47.73625,-2.97818),(-.46866,47.75109,-3.05278),(-.48278,47.67815,-3.02403),(-.49249,47.64661,-2.93747),(-.35394,47.5858,-2.46365),(-.22184,47.70121,-2.31947),(-.12746,47.7991,-2.76083),(-.23518,47.8252,-2.8813),(-.24091,47.80426,-2.75301),(-.50857,47.7559,-2.65763),(-.5346,47.76965,-2.7421),(-.2414,47.78137,-2.62887),(0,47.73261,-2.38872),(0,47.70309,-2.308),(-.13099,47.78394,-2.62955),(-.31381,47.64538,-3.1024),(-.31173,47.63686,-3.08936),(-.28447,47.56917,-2.79191),(-.27529,47.57217,-2.69518),(-.17772,47.56202,-2.79801),(-.17605,47.56142,-2.69809),(-.18008,47.55625,-2.60359),(-.08756,47.5661,-2.89451),(-.08419,47.54335,-2.50452),(-.08259,47.54694,-2.61056),(0,47.5422,-2.43404),(-.08491,47.54717,-2.43315),(0,47.54401,-2.50732),(0,47.56842,-2.89209),(-.08399,47.55796,-2.79763),(0,47.55804,-2.79969),(-.39402,47.66427,-3.13797),(-.46364,47.76866,-3.07864),(-.51289,47.75056,-2.65705),(-.53956,47.76485,-2.74273),(-.3228,47.71783,-2.30333),(-.51134,47.71931,-2.93404),(-.0821,47.55331,-2.70022),(0,47.53761,-2.34999),(-.37407,47.57639,-2.86383),(-.34533,47.58162,-2.46911),(-.38537,47.57723,-2.86631),(-.13219,47.69135,-2.26246),(0,47.51541,-2.20035),(-.4632,47.60151,-2.78606),(0,47.68104,-3.10956),(0,47.62869,-3.12613),(-.20904,47.70199,-2.2593),(0,47.51186,-2.20894),(-.47183,47.58595,-2.86102),(.39402,47.66427,-3.13797),(.34533,47.58162,-2.46834),(.23916,47.74719,-3.13063),(.08763,47.52729,-2.20379),(.23518,47.8252,-2.8813),(.24091,47.80426,-2.75301),(.2414,47.78137,-2.62887),(.38537,47.57723,-2.86631),(.37407,47.57639,-2.86383),(.18008,47.55625,-2.60359),(.08756,47.5661,-2.89451),(.08419,47.54335,-2.49971),(0,47.76108,-2.4986),(.13729,47.76128,-2.49895),(.50644,47.73625,-2.97818),(.32597,47.67362,-3.15585),(.48278,47.67815,-3.02403),(0,47.73526,-3.08337),(-.12551,47.74864,-3.10434),(-.45764,47.71661,-3.10617),(-.51128,47.64144,-2.85452),(-.53353,47.70838,-2.84898),(-.13729,47.76128,-2.5024)]))),
        Shape(DEF='t7',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t7_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,5,4,-1,7,8,9,-1,8,10,11,-1,12,7,9,-1,8,13,14,-1,9,8,15,-1,16,17,4,-1,10,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,37,42,-1,43,44,26,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,47,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,74,75,76,-1,77,78,67,-1,79,52,80,-1,79,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,86,80,52,-1,69,95,70,-1,96,97,98,-1,95,99,100,-1,101,102,100,-1,103,104,105,-1,106,107,108,-1,109,110,111,-1,112,113,114,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,130,131,132,-1,39,62,40,-1,133,134,135,-1,136,137,138,-1,139,140,141,-1,142,143,144,-1,145,146,147,-1,148,149,150,-1,151,152,147,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,162,163,164,-1,165,166,162,-1,167,168,169,-1,170,171,172,-1,173,171,170,-1,174,175,176,-1,144,177,178,-1,179,180,181,-1,182,183,184,-1,182,185,183,-1,186,187,188,-1,189,190,191,-1,192,193,191,-1,194,195,196,-1,197,198,199,-1,200,197,201,-1,202,203,195,-1,204,205,206,-1,207,208,204,-1,209,185,152,-1,210,145,211,-1,212,151,213,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,219,218,-1,222,0,156,-1,18,10,7,-1,223,133,224,-1,225,226,138,-1,225,137,227,-1,228,229,230,-1,49,231,232,-1,231,233,234,-1,231,235,233,-1,236,237,238,-1,239,228,240,-1,240,241,239,-1,242,243,244,-1,245,242,246,-1,247,248,249,-1,250,251,252,-1,253,254,255,-1,212,256,257,-1,188,187,258,-1,99,98,259,-1,260,261,127,-1,127,262,263,-1,259,264,265,-1,266,267,31,-1,268,34,269,-1,270,271,272,-1,270,272,22,-1,273,274,21,-1,26,275,276,-1,277,278,279,-1,44,47,58,-1,280,281,28,-1,282,283,74,-1,284,285,286,-1,287,288,284,-1,289,290,291,-1,292,293,83,-1,294,295,83,-1,83,296,297,-1,298,299,300,-1,301,302,303,-1,304,143,305,-1,163,306,172,-1,217,307,308,-1,309,198,97,-1,216,310,96,-1,311,312,313,-1,38,314,315,-1,316,317,318,-1,134,319,135,-1,319,320,321,-1,322,323,324,-1,325,326,327,-1,327,328,329,-1,330,72,331,-1,332,333,334,-1,335,336,41,-1,123,337,338,-1,339,340,122,-1,170,338,337,-1,341,342,343,-1,103,344,345,-1,346,347,345,-1,348,114,121,-1,349,350,351,-1,352,353,354,-1,355,354,356,-1,357,358,359,-1,360,361,359,-1,362,353,352,-1,363,356,364,-1,365,366,367,-1,357,368,349,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,382,383,-1,384,385,386,-1,387,388,389,-1,390,391,392,-1,386,393,394,-1,395,396,397,-1,398,393,386,-1,399,286,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,411,412,-1,412,413,414,-1,415,416,417,-1,418,419,420,-1,421,422,423,-1,424,425,426,-1,427,428,429,-1,430,431,432,-1,400,433,434,-1,435,436,437,-1,429,438,427,-1,439,440,441,-1,442,443,444,-1,445,446,447,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,459,460,461,-1,462,463,464,-1,465,466,467,-1,468,469,470,-1,471,472,473,-1,360,474,475,-1,476,477,478,-1,479,480,481,-1,482,483,484,-1,485,486,460,-1,487,351,350,-1,488,489,490,-1,491,492,389,-1,444,437,442,-1,493,494,495,-1,496,497,498,-1,499,500,501,-1,502,501,500,-1,503,504,505,-1,506,507,508,-1,508,509,510,-1,511,475,512,-1,513,514,515,-1,514,513,516,-1,517,368,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,408,528,529,-1,530,531,508,-1,532,533,534,-1,535,536,512,-1,537,538,539,-1,538,540,539,-1,541,542,543,-1,544,545,546,-1,547,470,548,-1,549,550,547,-1,551,516,552,-1,553,469,468,-1,554,555,556,-1,557,558,516,-1,559,560,561,-1,562,559,561,-1,563,564,565,-1,566,567,568,-1,569,570,518,-1,571,572,569,-1,573,574,575,-1,576,577,578,-1,578,579,580,-1,499,581,500,-1,582,583,584,-1,585,586,587,-1,588,589,590,-1,591,589,592,-1,593,590,594,-1,595,596,597,-1,598,599,600,-1,601,505,504,-1,602,603,604,-1,605,606,607,-1,608,605,607,-1,372,374,575,-1,609,610,608,-1,611,612,613,-1,614,615,616,-1,617,495,494,-1,618,619,620,-1,621,622,623,-1,624,625,494,-1,626,394,393,-1,626,627,271,-1,628,629,630,-1,631,377,632,-1,377,376,633,-1,634,635,636,-1,636,637,634,-1,638,639,46,-1,281,379,378,-1,640,641,433,-1,642,643,644,-1,642,645,435,-1,646,647,648,-1,621,649,650,-1,651,621,623,-1,459,652,447,-1,461,653,654,-1,655,656,441,-1,452,657,658,-1,659,660,488,-1,476,661,488,-1,360,358,349,-1,662,663,664,-1,665,666,667,-1,665,667,668,-1,669,670,572,-1,671,462,672,-1,673,674,630,-1,387,492,385,-1,675,676,677,-1,534,678,411,-1,679,428,427,-1,672,680,681,-1,682,683,684,-1,684,685,682,-1,686,687,688,-1,432,431,683,-1,689,690,685,-1,392,391,691,-1,692,424,693,-1,694,532,410,-1,530,507,695,-1,696,428,679,-1,697,698,534,-1,699,700,426,-1,701,702,703,-1,704,705,706,-1,707,708,709,-1,710,711,712,-1,713,714,481,-1,715,716,717,-1,718,719,720,-1,405,721,722,-1,481,480,723,-1,723,715,724,-1,725,726,720,-1,727,479,728,-1,474,717,716,-1,713,729,714,-1,699,425,696,-1,730,395,731,-1,732,733,734,-1,735,736,737,-1,689,738,737,-1,685,690,682,-1,431,429,686,-1,686,688,684,-1,739,740,741,-1,742,743,744,-1,745,581,746,-1,745,747,748,-1,386,385,491,-1,749,671,750,-1,751,752,753,-1,572,754,755,-1,756,757,662,-1,527,526,524,-1,524,523,535,-1,488,660,758,-1,107,759,760,-1,761,762,457,-1,763,456,764,-1,453,765,655,-1,286,285,766,-1,767,768,769,-1,280,770,379,-1,771,772,378,-1,277,773,774,-1,380,775,776,-1,777,632,633,-1,778,419,779,-1,375,270,635,-1,632,394,626,-1,384,780,781,-1,624,494,493,-1,782,619,618,-1,618,620,783,-1,493,784,672,-1,614,785,786,-1,787,788,616,-1,561,789,790,-1,791,792,793,-1,613,612,794,-1,795,796,797,-1,797,798,799,-1,800,801,802,-1,372,365,803,-1,804,805,573,-1,603,806,807,-1,503,808,809,-1,237,236,596,-1,589,810,811,-1,591,595,812,-1,401,588,813,-1,814,815,816,-1,817,818,577,-1,818,819,578,-1,412,580,579,-1,820,821,822,-1,368,571,569,-1,569,823,824,-1,569,572,755,-1,755,754,749,-1,565,825,826,-1,790,825,554,-1,827,753,828,-1,829,830,560,-1,831,832,833,-1,834,828,835,-1,788,787,836,-1,837,838,752,-1,839,840,545,-1,841,545,544,-1,786,842,537,-1,402,582,843,-1,844,352,355,-1,397,396,697,-1,699,845,846,-1,716,526,525,-1,756,664,716,-1,667,847,791,-1,848,849,850,-1,793,668,791,-1,851,799,798,-1,852,853,854,-1,478,477,487,-1,855,541,829,-1,856,551,550,-1,515,556,555,-1,362,803,857,-1,858,843,859,-1,676,506,510,-1,818,500,860,-1,861,579,862,-1,863,501,502,-1,390,864,398,-1,827,558,865,-1,866,867,618,-1,389,388,691,-1,710,713,724,-1,490,489,711,-1,868,483,869,-1,481,707,728,-1,658,870,708,-1,106,871,657,-1,697,533,404,-1,842,538,537,-1,680,430,872,-1,680,672,464,-1,784,751,750,-1,873,456,458,-1,874,450,875,-1,765,455,876,-1,473,433,400,-1,877,439,441,-1,759,450,760,-1,763,878,879,-1,447,446,448,-1,431,430,880,-1,736,691,388,-1,432,690,423,-1,431,880,438,-1,687,428,696,-1,424,426,864,-1,767,434,641,-1,771,417,772,-1,411,413,412,-1,508,531,881,-1,374,373,882,-1,459,449,875,-1,883,812,884,-1,593,885,813,-1,772,46,45,-1,380,886,378,-1,730,887,888,-1,491,389,398,-1,395,889,396,-1,632,673,394,-1,385,384,781,-1,770,890,380,-1,773,891,415,-1,376,375,634,-1,821,892,512,-1,893,356,354,-1,894,895,896,-1,359,361,895,-1,896,820,897,-1,895,898,892,-1,820,896,895,-1,857,367,893,-1,857,893,353,-1,350,368,517,-1,899,900,901,-1,902,345,344,-1,338,170,903,-1,122,121,114,-1,122,118,123,-1,112,904,905,-1,906,907,908,-1,63,909,176,-1,910,911,105,-1,335,65,78,-1,912,913,900,-1,914,915,916,-1,917,67,918,-1,331,72,919,-1,329,73,330,-1,66,68,327,-1,331,325,329,-1,920,100,99,-1,921,65,335,-1,139,922,323,-1,923,139,322,-1,924,141,925,-1,926,29,314,-1,927,33,315,-1,311,313,99,-1,97,200,98,-1,307,928,929,-1,172,171,163,-1,930,931,932,-1,120,303,933,-1,303,302,934,-1,935,109,108,-1,291,936,89,-1,937,938,939,-1,940,53,82,-1,2,153,158,-1,941,942,943,-1,944,75,945,-1,946,947,644,-1,45,43,948,-1,639,47,46,-1,949,950,637,-1,636,635,22,-1,951,20,952,-1,953,952,269,-1,927,954,955,-1,271,627,268,-1,316,32,268,-1,956,957,958,-1,959,938,960,-1,261,961,262,-1,956,962,963,-1,964,188,965,-1,966,967,968,-1,251,250,160,-1,969,970,971,-1,6,247,5,-1,972,973,974,-1,249,248,975,-1,976,977,978,-1,978,979,976,-1,980,981,982,-1,983,984,985,-1,986,987,988,-1,989,990,48,-1,991,992,993,-1,990,992,235,-1,994,995,230,-1,181,50,996,-1,997,226,998,-1,218,929,222,-1,999,1000,1001,-1,214,1002,219,-1,213,1003,1002,-1,1004,209,152,-1,1004,151,212,-1,1005,131,1006,-1,148,1007,1008,-1,1009,191,1010,-1,1011,183,1012,-1,143,304,19,-1,915,914,910,-1,1013,1014,1015,-1,1016,1017,1018,-1,903,172,348,-1,1019,1020,1021,-1,1022,304,1023,-1,1024,1025,159,-1,1026,305,1027,-1,1010,1028,1029,-1,190,189,1030,-1,1031,211,145,-1,1007,148,150,-1,247,1032,142,-1,1014,140,139,-1,137,136,1033,-1,1033,1034,1035,-1,1036,1037,1038,-1,962,956,259,-1,1039,1040,38,-1,303,120,119,-1,1041,154,153,-1,1042,1043,1044,-1,116,115,1045,-1,341,114,1046,-1,155,154,1047,-1,1022,932,931,-1,1048,1049,1050,-1,1051,1052,196,-1,1051,192,1052,-1,1053,1054,1055,-1,1054,100,1055,-1,1056,1057,297,-1,1058,1042,117,-1,455,289,1059,-1,86,51,87,-1,82,81,1060,-1,1060,1061,82,-1,1062,1063,941,-1,936,1064,79,-1,921,69,68,-1,946,944,1065,-1,92,399,60,-1,102,101,73,-1,66,65,921,-1,64,63,77,-1,72,71,1066,-1,1067,1068,23,-1,1068,1069,23,-1,223,1070,1071,-1,223,1072,914,-1,1073,1074,1016,-1,1075,103,345,-1,1076,1077,996,-1,92,286,399,-1,315,316,39,-1,1078,36,35,-1,315,33,316,-1,62,1079,40,-1,926,1040,1039,-1,31,315,314,-1,1080,60,1081,-1,26,948,43,-1,20,22,272,-1,56,55,249,-1,1082,1083,12,-1,1084,931,14,-1,1085,3,1086,-1,15,14,931,-1,1087,1088,15,-1,16,1089,178,-1,3,1085,178,-1,1041,2,1,-1,178,1089,3,-1,16,178,1090,-1,930,1087,15,-1,15,931,930,-1,1086,1091,1085,-1,1092,16,1090,-1,6,1093,248,-1,1083,1094,12,-1,1089,4,3,-1,952,20,272,-1,274,1067,21,-1,31,954,315,-1,1039,126,926,-1,1079,124,40,-1,33,32,316,-1,315,39,38,-1,1095,44,58,-1,914,1072,910,-1,1076,996,232,-1,989,1096,1097,-1,1075,901,103,-1,1016,1098,1073,-1,914,1099,223,-1,223,1100,1070,-1,1069,57,23,-1,1067,274,1068,-1,1066,1101,72,-1,77,67,64,-1,68,66,921,-1,73,328,102,-1,60,93,92,-1,60,59,93,-1,1065,290,946,-1,1079,62,332,-1,936,79,90,-1,90,80,91,-1,1062,941,1102,-1,51,935,87,-1,129,943,942,-1,455,454,289,-1,117,53,1058,-1,95,312,311,-1,1055,1103,1053,-1,1051,193,192,-1,196,1008,1051,-1,1050,287,1048,-1,1104,1001,1000,-1,1084,1022,931,-1,1022,337,932,-1,155,1047,1105,-1,105,906,344,-1,1046,342,341,-1,110,116,1045,-1,1042,1044,115,-1,2,1041,153,-1,119,1106,303,-1,1102,1065,1062,-1,1107,1063,1108,-1,962,259,98,-1,1036,1109,1037,-1,1033,136,1034,-1,1033,227,137,-1,139,923,1014,-1,1014,1013,140,-1,19,304,1022,-1,150,1110,1007,-1,145,1111,1031,-1,1006,211,1031,-1,156,0,157,-1,1112,1113,1114,-1,1023,173,1022,-1,1115,1019,1021,-1,1016,1018,1116,-1,913,1013,1015,-1,910,104,915,-1,144,143,19,-1,1011,1012,1117,-1,1011,184,183,-1,1118,1029,1119,-1,191,190,1010,-1,1008,149,148,-1,1007,1051,1008,-1,1006,1120,1005,-1,146,145,210,-1,130,1121,211,-1,1004,152,151,-1,214,213,1002,-1,214,219,221,-1,156,1122,218,-1,218,308,929,-1,226,225,998,-1,1035,1038,1033,-1,994,234,995,-1,990,235,231,-1,991,993,1123,-1,1097,1124,993,-1,1125,238,1126,-1,240,1127,1128,-1,1129,986,988,-1,985,1130,983,-1,982,1131,980,-1,1131,982,973,-1,975,56,249,-1,972,974,1132,-1,6,248,247,-1,969,971,253,-1,160,159,251,-1,252,1133,164,-1,1134,968,1135,-1,999,85,263,-1,1136,964,965,-1,956,963,957,-1,261,262,127,-1,84,1137,127,-1,956,958,264,-1,268,317,316,-1,268,269,271,-1,954,1138,955,-1,34,953,269,-1,953,951,952,-1,636,22,949,-1,949,637,636,-1,273,1068,274,-1,639,1139,47,-1,948,281,45,-1,1140,93,59,-1,946,644,1141,-1,644,643,1141,-1,1142,941,943,-1,157,2,158,-1,82,1061,940,-1,937,939,1058,-1,89,1059,291,-1,108,87,935,-1,933,303,934,-1,933,1105,120,-1,1,930,932,-1,1022,173,337,-1,171,1143,163,-1,666,665,306,-1,929,308,307,-1,200,962,98,-1,313,98,99,-1,954,927,315,-1,314,1040,926,-1,1144,1037,1145,-1,924,1146,141,-1,1147,922,139,-1,139,323,322,-1,1072,1148,910,-1,911,928,307,-1,335,312,921,-1,920,1055,100,-1,329,330,331,-1,331,919,325,-1,327,326,66,-1,329,328,73,-1,72,1101,919,-1,125,124,1079,-1,917,64,67,-1,916,1099,914,-1,912,1013,913,-1,335,78,336,-1,910,105,104,-1,63,176,77,-1,907,904,908,-1,905,111,112,-1,122,340,118,-1,114,113,122,-1,338,903,121,-1,902,344,906,-1,899,901,1075,-1,350,349,368,-1,353,362,857,-1,367,1149,893,-1,895,821,820,-1,892,821,895,-1,1150,1151,366,-1,892,898,511,-1,361,898,895,-1,894,359,895,-1,893,1149,356,-1,512,822,821,-1,634,778,376,-1,1152,774,420,-1,638,772,416,-1,380,379,770,-1,781,1153,385,-1,389,391,390,-1,395,730,889,-1,389,390,398,-1,888,889,730,-1,772,45,378,-1,885,583,813,-1,883,1154,812,-1,875,868,459,-1,882,573,374,-1,417,416,772,-1,767,382,434,-1,735,424,864,-1,1155,687,696,-1,438,429,431,-1,423,872,432,-1,640,1156,768,-1,1155,696,425,-1,879,1157,763,-1,759,451,450,-1,877,441,656,-1,473,1158,433,-1,656,765,876,-1,449,874,875,-1,880,464,438,-1,750,671,784,-1,672,462,464,-1,680,872,466,-1,697,404,718,-1,106,657,107,-1,708,484,658,-1,481,714,707,-1,460,868,869,-1,711,1159,490,-1,717,710,724,-1,389,691,391,-1,866,1160,867,-1,827,834,558,-1,864,1161,398,-1,861,862,748,-1,818,860,819,-1,676,510,743,-1,515,1162,556,-1,856,550,549,-1,487,521,478,-1,518,570,520,-1,798,1163,851,-1,793,662,668,-1,791,668,667,-1,1164,847,1165,-1,716,715,756,-1,716,664,526,-1,699,703,845,-1,704,397,697,-1,704,1166,397,-1,1167,1168,506,-1,844,536,352,-1,843,1169,402,-1,582,584,843,-1,540,538,1170,-1,543,1170,830,-1,538,830,1170,-1,537,1171,786,-1,841,544,1172,-1,839,545,841,-1,468,1173,835,-1,752,836,837,-1,788,836,1174,-1,834,835,1173,-1,559,829,560,-1,827,828,834,-1,825,790,826,-1,749,1175,755,-1,755,823,569,-1,824,570,569,-1,569,518,368,-1,579,861,412,-1,578,577,818,-1,817,502,818,-1,816,1176,814,-1,1176,585,814,-1,589,811,594,-1,594,590,589,-1,596,595,237,-1,1177,809,1178,-1,503,809,1177,-1,604,603,807,-1,804,573,882,-1,803,1179,372,-1,802,1180,800,-1,799,795,797,-1,613,794,1181,-1,1182,848,1183,-1,789,826,790,-1,616,615,787,-1,786,1171,614,-1,672,681,493,-1,866,618,783,-1,493,1184,624,-1,384,1185,780,-1,626,631,632,-1,1186,271,270,-1,375,1186,270,-1,779,1187,778,-1,1188,777,633,-1,380,890,775,-1,774,278,277,-1,771,378,886,-1,379,281,280,-1,381,1189,1190,-1,769,1191,767,-1,286,766,400,-1,288,472,471,-1,655,436,453,-1,764,878,763,-1,763,1192,456,-1,761,651,762,-1,758,1193,488,-1,535,527,524,-1,757,668,662,-1,572,670,754,-1,751,753,750,-1,750,1194,749,-1,671,463,462,-1,385,492,491,-1,1161,732,734,-1,862,745,748,-1,746,747,745,-1,742,1195,743,-1,741,1196,739,-1,684,683,686,-1,686,683,431,-1,690,432,682,-1,737,738,735,-1,732,1197,733,-1,730,731,679,-1,713,712,729,-1,716,525,474,-1,728,705,727,-1,719,718,404,-1,720,719,725,-1,724,481,723,-1,722,406,405,-1,720,704,718,-1,717,724,715,-1,481,724,713,-1,710,712,713,-1,709,706,707,-1,706,1166,704,-1,701,703,731,-1,425,699,426,-1,533,697,534,-1,731,696,679,-1,695,721,530,-1,410,1198,694,-1,692,1155,424,-1,689,421,690,-1,683,682,432,-1,686,429,687,-1,684,689,685,-1,680,465,681,-1,427,463,679,-1,670,1199,698,-1,1196,741,509,-1,510,744,743,-1,675,677,1200,-1,859,497,863,-1,385,1153,387,-1,630,386,673,-1,672,784,671,-1,669,1199,670,-1,668,757,665,-1,662,664,756,-1,474,525,475,-1,349,1201,360,-1,488,490,476,-1,488,661,659,-1,452,451,657,-1,655,765,656,-1,1202,762,651,-1,651,623,1202,-1,653,622,654,-1,459,1203,652,-1,651,649,621,-1,621,650,1204,-1,646,648,1205,-1,1206,1156,1207,-1,642,644,645,-1,1158,640,433,-1,434,433,641,-1,281,378,45,-1,46,772,638,-1,419,418,779,-1,637,1152,634,-1,634,375,635,-1,376,1208,633,-1,377,633,632,-1,628,630,674,-1,626,271,631,-1,626,393,734,-1,625,617,494,-1,618,867,1157,-1,619,1209,620,-1,617,1210,495,-1,614,1171,615,-1,568,782,879,-1,1181,1211,1212,-1,850,849,1213,-1,792,1182,1183,-1,1211,1214,1215,-1,611,1216,612,-1,609,608,1217,-1,372,575,365,-1,605,1218,606,-1,604,977,602,-1,504,1219,601,-1,598,1220,599,-1,1178,1176,1177,-1,810,1154,811,-1,591,810,589,-1,588,1221,589,-1,814,585,587,-1,501,496,1222,-1,581,860,500,-1,578,819,579,-1,576,578,1223,-1,575,374,573,-1,571,669,572,-1,823,563,565,-1,565,824,823,-1,564,825,565,-1,561,790,562,-1,516,513,557,-1,557,865,558,-1,833,855,1162,-1,468,835,553,-1,516,558,552,-1,547,548,549,-1,546,1224,544,-1,1225,537,539,-1,512,527,535,-1,532,534,410,-1,508,507,530,-1,529,1226,408,-1,723,756,715,-1,527,475,525,-1,849,1227,1213,-1,851,795,799,-1,521,487,519,-1,542,1228,1224,-1,1229,1172,544,-1,515,555,513,-1,796,803,362,-1,511,512,892,-1,475,527,512,-1,510,506,508,-1,505,808,503,-1,500,818,502,-1,1222,499,501,-1,496,498,1230,-1,495,784,493,-1,1231,1232,443,-1,488,1193,489,-1,487,477,351,-1,460,869,485,-1,482,869,483,-1,481,728,479,-1,718,704,697,-1,476,1233,477,-1,360,475,1234,-1,360,1201,474,-1,567,566,520,-1,472,1235,473,-1,468,470,547,-1,467,1236,465,-1,465,680,466,-1,764,1237,1238,-1,459,868,460,-1,457,659,458,-1,765,453,455,-1,647,646,866,-1,452,875,450,-1,449,459,447,-1,445,447,652,-1,442,648,443,-1,877,874,439,-1,439,448,440,-1,735,864,392,-1,437,1207,435,-1,432,872,430,-1,428,687,429,-1,424,1155,425,-1,423,690,421,-1,415,418,420,-1,415,417,418,-1,414,580,412,-1,410,412,1198,-1,409,1150,407,-1,719,404,406,-1,811,1239,594,-1,401,582,402,-1,534,411,410,-1,771,886,1240,-1,386,491,398,-1,394,673,386,-1,390,392,864,-1,389,492,387,-1,386,630,384,-1,778,420,419,-1,377,1186,375,-1,353,893,354,-1,897,369,371,-1,357,349,358,-1,361,360,1234,-1,352,1241,362,-1,358,360,359,-1,359,894,357,-1,363,355,356,-1,354,355,352,-1,121,903,348,-1,348,1046,114,-1,345,902,346,-1,343,908,341,-1,337,173,170,-1,122,113,339,-1,123,1242,337,-1,78,77,176,-1,336,35,41,-1,332,334,1243,-1,330,73,72,-1,327,68,328,-1,327,329,325,-1,1244,322,324,-1,319,1245,320,-1,134,1245,319,-1,39,316,318,-1,317,1246,318,-1,38,1040,314,-1,216,96,313,-1,96,309,97,-1,308,220,217,-1,163,166,306,-1,305,1026,304,-1,1026,1023,304,-1,303,1106,301,-1,760,88,107,-1,299,1247,300,-1,297,294,83,-1,292,83,295,-1,291,1059,289,-1,284,1048,287,-1,288,285,284,-1,286,92,284,-1,74,61,282,-1,1190,1248,1081,-1,281,948,28,-1,44,43,47,-1,279,25,277,-1,276,27,26,-1,21,1249,273,-1,22,635,270,-1,268,32,34,-1,31,30,266,-1,259,956,264,-1,260,127,129,-1,259,920,99,-1,965,188,258,-1,212,257,1004,-1,253,1250,254,-1,164,1133,162,-1,142,1032,1025,-1,247,249,1020,-1,245,243,242,-1,54,242,244,-1,241,1251,239,-1,1128,241,240,-1,228,1127,240,-1,238,1125,236,-1,992,990,989,-1,238,1123,993,-1,230,995,1127,-1,228,230,1127,-1,225,227,1252,-1,138,137,225,-1,224,1100,223,-1,218,222,156,-1,221,218,1122,-1,220,308,218,-1,217,220,215,-1,256,212,214,-1,210,211,1121,-1,185,1253,152,-1,204,206,207,-1,195,194,202,-1,200,201,1254,-1,1255,197,199,-1,191,1256,192,-1,189,191,193,-1,188,1012,186,-1,185,182,1118,-1,178,1085,144,-1,140,1257,1258,-1,105,907,906,-1,176,1259,174,-1,173,1023,171,-1,172,903,170,-1,165,162,168,-1,1260,1114,251,-1,162,166,163,-1,159,161,1024,-1,1261,1262,1263,-1,155,1264,153,-1,1253,1119,1265,-1,147,146,151,-1,149,1120,150,-1,145,147,1111,-1,5,247,1086,-1,1145,180,1266,-1,1147,139,141,-1,138,1267,136,-1,135,224,133,-1,227,1033,1144,-1,39,318,62,-1,131,203,132,-1,127,1137,128,-1,124,126,1039,-1,121,123,338,-1,120,1268,118,-1,115,117,1042,-1,114,341,112,-1,109,111,1269,-1,108,1270,106,-1,344,103,105,-1,1268,1105,1047,-1,1268,120,1105,-1,1012,183,186,-1,1054,101,100,-1,95,311,99,-1,98,313,96,-1,1271,294,1272,-1,51,86,52,-1,876,455,89,-1,455,1059,89,-1,92,94,1049,-1,89,936,90,-1,760,86,88,-1,85,296,83,-1,79,80,90,-1,70,102,328,-1,126,125,1243,-1,73,101,71,-1,328,68,70,-1,78,65,67,-1,62,64,332,-1,61,1140,59,-1,57,1069,58,-1,223,1071,1072,-1,1273,1015,1014,-1,56,242,54,-1,53,117,51,-1,50,1274,48,-1,47,43,45,-1,42,1275,41,-1,40,1039,38,-1,37,41,35,-1,40,124,1039,-1,31,314,29,-1,26,28,948,-1,57,47,1139,-1,1067,279,950,-1,21,949,22,-1,19,11,10,-1,1089,16,4,-1,9,15,1088,-1,8,14,15,-1,1276,13,11,-1,1093,1277,1073,-1,11,13,8,-1,7,10,8,-1,4,17,6,-1,3,5,1086,-1,157,0,2,-1,1277,1074,1073,-1,1277,1083,1074,-1,1082,1087,1278,-1,1087,1082,1088,-1,1083,1092,1094,-1,1083,1277,1092,-1,952,271,269,-1,952,272,271,-1,1279,1248,1280,-1,1081,1279,1080,-1,1279,1081,1248,-1,232,50,49,-1,232,996,50,-1,1124,1281,1126,-1,1281,1124,1282,-1,916,1283,1099,-1,1284,1283,916,-1,997,1100,226,-1,1100,997,1070,-1,289,644,947,-1,644,289,454,-1,1137,83,293,-1,83,1137,84,-1,51,116,935,-1,51,117,116,-1,643,1050,1141,-1,643,1285,1050,-1,939,301,1043,-1,939,1286,301,-1,297,1272,294,-1,297,1057,1272,-1,204,1030,1110,-1,208,1030,204,-1,1287,202,194,-1,202,1287,199,-1,1049,284,92,-1,1049,1048,284,-1,1264,1001,1104,-1,1264,1288,1001,-1,1289,337,1242,-1,337,1289,932,-1,342,1290,1291,-1,342,1046,1290,-1,1106,1043,301,-1,1043,1106,1044,-1,945,1292,1108,-1,1293,1292,945,-1,1108,1294,1107,-1,1294,1108,1292,-1,292,1295,1296,-1,1297,1295,292,-1,1038,1144,1033,-1,1037,1144,1038,-1,1273,923,322,-1,923,1273,1014,-1,180,1109,1146,-1,1037,180,1145,-1,1037,1109,180,-1,228,985,986,-1,985,228,239,-1,1298,180,179,-1,1298,1266,180,-1,1299,1300,1301,-1,1299,1302,1300,-1,18,144,19,-1,18,177,144,-1,1028,190,1030,-1,1028,1010,190,-1,1265,1029,1028,-1,1265,1119,1029,-1,1303,1272,1288,-1,1271,1272,1303,-1,1027,1143,1026,-1,1143,1027,1304,-1,169,162,1133,-1,169,168,162,-1,1305,1115,1021,-1,1306,1115,1305,-1,970,1307,971,-1,970,1308,1307,-1,1293,1309,1292,-1,1293,1310,1309,-1,105,1078,907,-1,105,36,1078,-1,48,231,49,-1,48,990,231,-1,980,1311,1312,-1,980,244,1311,-1,1118,1253,185,-1,1118,1119,1253,-1,1005,196,195,-1,196,1005,1008,-1,1313,1314,1315,-1,1255,1314,1313,-1,1030,207,1028,-1,1030,208,207,-1,202,132,203,-1,202,309,132,-1,1002,1316,215,-1,1002,1003,1316,-1,248,1098,975,-1,248,1073,1098,-1,248,1093,1073,-1,1317,975,1098,-1,975,1317,246,-1,245,1070,997,-1,245,1318,1070,-1,1266,1319,1252,-1,1266,1298,1319,-1,235,991,1320,-1,235,992,991,-1,993,1126,238,-1,993,1124,1126,-1,992,1097,993,-1,989,1097,992,-1,1321,1282,1258,-1,1282,1321,1281,-1,1320,1322,1323,-1,1320,1324,1322,-1,1128,1325,1326,-1,1128,1327,1325,-1,1328,1329,1330,-1,1328,1331,1329,-1,987,985,984,-1,987,986,985,-1,1312,1252,1319,-1,1311,1252,1312,-1,984,1332,987,-1,1332,984,1333,-1,244,998,1311,-1,243,998,244,-1,1334,1333,1335,-1,1334,1332,1333,-1,981,1336,982,-1,981,1337,1336,-1,976,1338,1339,-1,1338,976,979,-1,1340,1341,1342,-1,1340,1343,1341,-1,1344,1308,1345,-1,1307,1308,1344,-1,974,1346,1132,-1,974,1342,1346,-1,1344,1347,802,-1,1348,1347,1344,-1,972,1305,1021,-1,1305,972,1132,-1,802,1307,1344,-1,802,801,1307,-1,1025,161,142,-1,1024,161,1025,-1,967,1349,968,-1,967,1306,1349,-1,971,1250,253,-1,971,1350,1250,-1,967,1351,1263,-1,1351,967,966,-1,1134,966,968,-1,1352,966,1134,-1,1353,1354,1112,-1,1354,1353,1355,-1,255,1134,1135,-1,1356,1134,255,-1,1357,1358,1355,-1,1357,1359,1358,-1,258,999,263,-1,258,257,999,-1,1254,961,963,-1,1254,1136,961,-1,260,957,261,-1,260,958,957,-1,1294,264,958,-1,264,1294,1360,-1,950,278,637,-1,950,279,278,-1,1361,1138,1362,-1,955,1138,1361,-1,1363,34,1364,-1,953,34,1363,-1,1363,276,1365,-1,1363,1366,276,-1,1095,1367,275,-1,1367,1095,1368,-1,1368,58,1069,-1,1368,1095,58,-1,282,1362,283,-1,282,1361,1362,-1,1081,399,1190,-1,1081,60,399,-1,946,94,76,-1,1141,94,946,-1,1108,1062,1065,-1,1108,1063,1062,-1,937,960,938,-1,937,1295,960,-1,938,1286,939,-1,1286,938,959,-1,88,108,107,-1,108,88,87,-1,1106,1369,1044,-1,119,1369,1106,-1,932,1041,1,-1,1041,932,1289,-1,1026,171,1023,-1,1026,1143,171,-1,30,1370,1371,-1,30,29,1370,-1,50,924,1274,-1,50,181,924,-1,1125,1372,1301,-1,1321,1372,1125,-1,1373,922,1147,-1,922,1373,1374,-1,320,1375,324,-1,320,1245,1375,-1,1148,911,910,-1,1148,928,911,-1,100,70,95,-1,100,102,70,-1,926,1066,1376,-1,926,126,1066,-1,318,63,62,-1,63,318,909,-1,918,325,917,-1,918,326,325,-1,913,916,915,-1,913,1015,916,-1,104,901,915,-1,104,103,901,-1,176,336,78,-1,176,175,336,-1,907,336,1377,-1,1078,336,907,-1,35,336,1078,-1,341,904,112,-1,341,908,904,-1,1378,1379,1380,-1,1379,1378,1259,-1,106,1381,1382,-1,1381,106,1270,-1,1383,1384,1385,-1,1384,1383,1386,-1,1387,1291,1388,-1,1387,1389,1291,-1,369,363,364,-1,1390,363,369,-1,894,897,371,-1,897,894,896,-1,774,415,420,-1,774,773,415,-1,593,1239,885,-1,593,594,1239,-1,608,882,373,-1,608,607,882,-1,768,641,640,-1,768,767,641,-1,735,691,736,-1,735,392,691,-1,440,648,442,-1,440,1205,648,-1,656,760,877,-1,760,656,876,-1,445,1205,446,-1,445,646,1205,-1,877,450,874,-1,877,760,450,-1,660,1202,758,-1,762,1202,660,-1,1391,1153,1392,-1,387,1153,1391,-1,1172,1393,548,-1,1393,1172,1229,-1,547,551,552,-1,547,550,551,-1,1394,478,521,-1,1394,1395,478,-1,1396,1233,1159,-1,1397,1233,1396,-1,657,870,658,-1,871,870,657,-1,714,708,707,-1,714,729,708,-1,1398,1399,1400,-1,1398,1401,1399,-1,648,1231,443,-1,648,647,1231,-1,1402,1403,1404,-1,1402,1405,1403,-1,1173,558,834,-1,1173,552,558,-1,1406,1196,881,-1,739,1196,1406,-1,819,862,579,-1,819,860,862,-1,1407,1408,1409,-1,1329,1408,1407,-1,1169,1410,1411,-1,1169,1412,1410,-1,1413,1414,1415,-1,1416,1414,1413,-1,795,1417,796,-1,795,853,1417,-1,795,1418,853,-1,796,1241,797,-1,796,362,1241,-1,1162,829,559,-1,829,1162,855,-1,1237,1394,566,-1,1394,1237,873,-1,522,798,523,-1,522,1163,798,-1,851,1418,795,-1,851,1419,1418,-1,792,1227,1182,-1,792,1164,1227,-1,757,723,1420,-1,757,756,723,-1,1421,1422,1423,-1,1421,1424,1422,-1,1216,801,800,-1,801,1216,1350,-1,702,845,703,-1,702,1425,845,-1,1426,720,726,-1,1426,727,720,-1,804,607,606,-1,804,882,607,-1,561,842,786,-1,561,560,842,-1,1427,838,837,-1,1427,553,838,-1,787,837,836,-1,837,787,1428,-1,753,838,828,-1,753,752,838,-1,1393,1429,856,-1,1429,1393,1430,-1,515,833,1162,-1,515,1431,833,-1,1432,827,865,-1,1432,1194,827,-1,1175,823,755,-1,563,823,1175,-1,409,1226,1433,-1,408,1226,409,-1,1434,574,1435,-1,1434,1436,574,-1,577,1437,817,-1,1437,577,576,-1,587,401,403,-1,587,588,401,-1,587,586,588,-1,1221,1438,1439,-1,1221,1440,1438,-1,591,237,595,-1,591,1441,237,-1,1442,1438,1443,-1,1442,1322,1438,-1,585,1178,1444,-1,1178,585,1176,-1,1445,1446,1447,-1,1445,1331,1446,-1,1412,1448,1410,-1,1449,1448,1412,-1,1449,1450,1448,-1,1450,1449,1451,-1,1452,601,1219,-1,806,601,1452,-1,1450,606,1218,-1,1450,1451,606,-1,1453,806,1452,-1,807,806,1453,-1,1453,1454,807,-1,1454,1453,1455,-1,1456,1454,1455,-1,1457,1454,1456,-1,1458,1459,1460,-1,1458,1456,1459,-1,820,844,1390,-1,822,844,820,-1,1217,1179,1461,-1,1179,1217,372,-1,1462,1458,1463,-1,1462,1464,1458,-1,1179,796,1417,-1,796,1179,803,-1,794,1211,1181,-1,794,1423,1211,-1,852,1465,1466,-1,852,854,1465,-1,793,1183,1467,-1,1183,793,792,-1,1213,1465,850,-1,1213,1468,1465,-1,1469,1215,1466,-1,1470,1215,1469,-1,1164,1213,1227,-1,1164,1471,1213,-1,1471,1164,1165,-1,1470,1472,1212,-1,1472,1470,1473,-1,1472,254,1474,-1,1472,1475,254,-1,1476,1477,1471,-1,1476,1358,1477,-1,789,786,785,-1,789,561,786,-1,879,1238,568,-1,879,764,1238,-1,879,878,764,-1,614,782,785,-1,782,614,619,-1,1399,1184,1478,-1,624,1184,1399,-1,629,384,630,-1,629,1185,384,-1,1479,674,777,-1,1479,628,674,-1,1480,777,1188,-1,1480,1479,777,-1,1481,1187,779,-1,1187,1481,1482,-1,776,886,380,-1,776,1240,886,-1,1483,773,277,-1,891,773,1483,-1,1189,280,1190,-1,1189,770,280,-1,1231,625,1401,-1,783,625,1231,-1,1191,382,767,-1,383,382,1191,-1,1204,1203,654,-1,1204,1402,1203,-1,519,350,517,-1,519,487,350,-1,1192,457,456,-1,457,1192,761,-1,711,1484,712,-1,1484,711,489,-1,671,754,463,-1,749,754,671,-1,1236,1485,1486,-1,1236,1392,1485,-1,1167,1416,1168,-1,597,1416,1167,-1,860,745,862,-1,860,581,745,-1,496,742,1222,-1,742,1230,1195,-1,742,496,1230,-1,744,509,741,-1,744,510,509,-1,1487,740,746,-1,1487,741,740,-1,698,888,670,-1,888,698,889,-1,732,1380,1197,-1,1488,1380,732,-1,482,712,1484,-1,482,729,712,-1,1489,846,845,-1,1489,1378,846,-1,871,1490,870,-1,1491,1490,871,-1,1492,719,406,-1,725,719,1492,-1,1493,1492,1386,-1,1493,725,1492,-1,1420,480,1494,-1,1420,723,480,-1,726,1493,1495,-1,726,725,1493,-1,406,1496,1492,-1,406,722,1496,-1,727,704,720,-1,705,704,727,-1,845,1497,1489,-1,1425,1497,845,-1,870,709,708,-1,1490,709,870,-1,706,728,707,-1,706,705,728,-1,731,1166,701,-1,731,397,1166,-1,397,731,395,-1,405,533,532,-1,405,404,533,-1,694,530,532,-1,694,531,530,-1,684,692,693,-1,684,688,692,-1,684,738,689,-1,684,693,738,-1,467,872,423,-1,467,466,872,-1,670,463,754,-1,888,463,670,-1,887,463,888,-1,1498,412,861,-1,412,1498,1198,-1,742,741,1487,-1,744,741,742,-1,1416,596,1414,-1,596,1416,597,-1,1200,583,885,-1,1200,584,583,-1,393,1161,734,-1,1161,393,398,-1,1486,465,1236,-1,1486,681,465,-1,529,1199,669,-1,678,1199,529,-1,661,458,659,-1,661,1395,458,-1,484,452,658,-1,484,483,452,-1,461,1203,459,-1,654,1203,461,-1,1405,763,1403,-1,1192,763,1405,-1,621,654,622,-1,621,1204,654,-1,1206,437,444,-1,1206,1207,437,-1,1158,435,640,-1,435,1158,642,-1,399,381,1190,-1,399,382,381,-1,1499,1191,769,-1,1499,1500,1191,-1,771,1481,417,-1,771,1240,1481,-1,1482,1240,776,-1,1481,1240,1482,-1,775,1188,1501,-1,775,1480,1188,-1,376,1187,1208,-1,778,1187,376,-1,628,1502,1500,-1,628,1479,1502,-1,733,626,734,-1,733,627,626,-1,1185,1499,1503,-1,1499,1185,629,-1,1478,1486,1485,-1,1478,1184,1486,-1,1210,620,1209,-1,620,1210,617,-1,568,785,782,-1,568,789,785,-1,1358,1504,1477,-1,1358,1359,1504,-1,1474,1250,611,-1,1474,254,1250,-1,1469,1473,1470,-1,1473,1469,1504,-1,1466,1468,1469,-1,1466,1465,1468,-1,1163,1467,1183,-1,522,1467,1163,-1,850,854,1419,-1,1465,854,850,-1,1423,1214,1211,-1,1423,1422,1214,-1,1424,1217,1461,-1,609,1217,1424,-1,1347,1180,802,-1,1180,1347,1505,-1,1460,610,609,-1,1460,1459,610,-1,1462,1180,1464,-1,1180,1462,800,-1,1456,1506,1459,-1,1456,1455,1506,-1,1435,573,805,-1,574,573,1435,-1,1507,1455,1453,-1,1455,1507,1506,-1,1452,1507,1453,-1,1452,1508,1507,-1,576,804,1437,-1,804,576,805,-1,1508,1219,1220,-1,1452,1219,1508,-1,817,1451,1449,-1,1451,817,1437,-1,504,1220,1219,-1,504,599,1220,-1,1329,1445,1408,-1,1329,1331,1445,-1,1443,1178,1447,-1,1443,1444,1178,-1,1176,503,1177,-1,1176,816,503,-1,592,1441,591,-1,592,1509,1441,-1,675,885,1239,-1,675,1200,885,-1,592,1221,1439,-1,592,589,1221,-1,1440,588,586,-1,1440,1221,588,-1,1449,858,817,-1,1449,1412,858,-1,414,1435,1223,-1,414,1434,1435,-1,575,1436,407,-1,574,1436,575,-1,407,365,575,-1,1150,365,407,-1,1150,366,365,-1,1432,563,1175,-1,1432,564,563,-1,555,557,513,-1,557,555,554,-1,1431,1429,833,-1,1431,1510,1429,-1,615,1428,787,-1,1428,615,1225,-1,839,553,1427,-1,553,839,469,-1,539,840,1511,-1,840,539,540,-1,789,567,826,-1,789,568,567,-1,829,543,830,-1,829,541,543,-1,543,540,1170,-1,543,546,540,-1,1171,1225,615,-1,1171,537,1225,-1,1437,606,1451,-1,1437,804,606,-1,588,593,813,-1,588,590,593,-1,1426,1495,1387,-1,1426,726,1495,-1,702,1491,1425,-1,702,1490,1491,-1,1423,1463,1421,-1,1463,1423,794,-1,1420,665,757,-1,665,1420,1512,-1,1419,848,850,-1,851,848,1419,-1,520,517,518,-1,520,519,517,-1,542,855,1228,-1,542,541,855,-1,544,1228,1229,-1,544,1224,1228,-1,1168,1413,695,-1,1168,1416,1413,-1,1411,600,815,-1,1411,1410,600,-1,1409,808,505,-1,1408,808,1409,-1,1513,1406,1498,-1,1513,739,1406,-1,747,1513,748,-1,1514,1513,747,-1,442,441,440,-1,442,655,441,-1,1400,1478,780,-1,1400,1399,1478,-1,1397,477,1233,-1,477,1397,351,-1,484,729,482,-1,729,484,708,-1,1159,476,490,-1,1233,476,1159,-1,476,1395,661,-1,1395,476,478,-1,1235,288,1285,-1,472,288,1235,-1,548,841,1172,-1,548,470,841,-1,467,1392,1236,-1,1392,467,1391,-1,660,457,762,-1,457,660,659,-1,1235,643,642,-1,1235,1285,643,-1,483,875,452,-1,483,868,875,-1,763,867,1403,-1,1157,867,763,-1,421,388,422,-1,388,421,736,-1,1207,640,435,-1,640,1207,1156,-1,583,401,813,-1,583,582,401,-1,1189,1502,1515,-1,1502,381,383,-1,1189,381,1502,-1,271,377,631,-1,271,1186,377,-1,364,370,369,-1,364,1151,370,-1,357,371,1433,-1,894,371,357,-1,409,1151,1150,-1,409,370,1151,-1,1046,1516,1290,-1,1046,348,1516,-1,1383,1493,1386,-1,1383,347,1493,-1,345,1383,1075,-1,1383,345,347,-1,1517,1270,1269,-1,1270,1517,1381,-1,1259,1489,174,-1,1259,1378,1489,-1,340,1045,1369,-1,340,339,1045,-1,900,915,901,-1,915,900,913,-1,318,1379,909,-1,1379,318,1246,-1,334,1101,1243,-1,919,1101,334,-1,1376,71,1053,-1,1066,71,1376,-1,42,911,307,-1,37,911,42,-1,324,1518,1244,-1,324,1375,1518,-1,1374,1038,1035,-1,1036,1374,1373,-1,1036,1038,1374,-1,319,1267,135,-1,319,321,1267,-1,1372,1258,1257,-1,1258,1372,1321,-1,1371,1103,1519,-1,1371,1370,1103,-1,309,310,132,-1,310,309,96,-1,306,165,666,-1,306,166,165,-1,1369,118,340,-1,119,118,1369,-1,298,295,294,-1,300,295,298,-1,300,292,295,-1,300,1297,292,-1,940,1295,937,-1,940,1296,1295,-1,93,76,94,-1,93,1140,76,-1,60,282,61,-1,282,60,1080,-1,958,1107,1294,-1,1107,958,260,-1,280,1248,1190,-1,280,28,1248,-1,25,1483,277,-1,1483,25,24,-1,44,275,26,-1,44,1095,275,-1,1249,1368,273,-1,1367,1368,1249,-1,1364,1366,1363,-1,1364,1520,1366,-1,927,1520,1364,-1,927,955,1520,-1,31,1138,954,-1,31,267,1138,-1,265,1360,1521,-1,1360,265,264,-1,263,965,258,-1,262,965,263,-1,1056,85,999,-1,297,85,1056,-1,297,296,85,-1,187,257,258,-1,187,1004,257,-1,1355,1476,1354,-1,1355,1358,1476,-1,254,1356,255,-1,254,1475,1356,-1,1356,1352,1134,-1,1522,1352,1356,-1,1112,169,1113,-1,1354,169,1112,-1,167,169,1354,-1,966,1523,1351,-1,1523,966,1352,-1,250,164,1304,-1,164,250,252,-1,968,1524,1135,-1,968,1349,1524,-1,1032,1020,1019,-1,247,1020,1032,-1,1525,1308,1526,-1,1525,1345,1308,-1,1020,972,1021,-1,249,972,1020,-1,1527,1344,1345,-1,1527,1348,1344,-1,1348,978,1347,-1,1348,979,978,-1,1336,1342,974,-1,1336,1340,1342,-1,1337,1340,1336,-1,1337,1334,1340,-1,1528,1335,1333,-1,1335,1528,1339,-1,980,1529,981,-1,980,1312,1529,-1,983,1333,984,-1,1333,983,1528,-1,1529,1319,1530,-1,1312,1319,1529,-1,1530,1298,1531,-1,1298,1530,1319,-1,1446,1328,1326,-1,1446,1331,1328,-1,1128,995,1327,-1,1127,995,1128,-1,1323,1442,1325,-1,1323,1322,1442,-1,237,1123,238,-1,237,1441,1123,-1,1126,1321,1125,-1,1126,1281,1321,-1,1323,235,1320,-1,1323,233,235,-1,232,994,1076,-1,231,994,232,-1,231,234,994,-1,321,136,1267,-1,136,321,1034,-1,1311,225,1252,-1,998,225,1311,-1,246,1318,245,-1,246,1317,1318,-1,246,56,975,-1,246,242,56,-1,1278,222,1017,-1,1278,0,222,-1,1278,1087,0,-1,219,215,220,-1,215,219,1002,-1,132,1316,130,-1,132,310,1316,-1,211,131,130,-1,211,1006,131,-1,1111,206,1532,-1,1265,1111,147,-1,1265,206,1111,-1,205,1110,150,-1,204,1110,205,-1,199,309,202,-1,199,198,309,-1,1255,201,197,-1,1313,201,1255,-1,199,1314,1255,-1,199,1287,1314,-1,192,1315,1314,-1,1256,1315,192,-1,1009,1256,191,-1,1009,184,1256,-1,183,209,186,-1,183,185,209,-1,1009,1029,1118,-1,1010,1029,1009,-1,1146,181,180,-1,1146,924,181,-1,1148,1116,1018,-1,1116,1148,1533,-1,283,1310,1293,-1,1362,1310,283,-1,1308,1524,1526,-1,970,1524,1308,-1,348,306,1516,-1,348,172,306,-1,1113,1133,252,-1,1113,169,1133,-1,161,1027,305,-1,161,160,1027,-1,1288,1057,1001,-1,1272,1057,1288,-1,1104,153,1264,-1,1104,158,153,-1,1019,1025,1032,-1,1262,1025,1019,-1,1262,1534,1025,-1,1276,19,1022,-1,11,19,1276,-1,1109,1373,1146,-1,1109,1036,1373,-1,912,140,1013,-1,912,1257,140,-1,229,986,1129,-1,986,229,228,-1,1330,1407,1535,-1,1407,1330,1329,-1,135,138,224,-1,135,1267,138,-1,322,1284,1273,-1,1284,322,1244,-1,131,195,203,-1,131,1005,195,-1,293,1296,1536,-1,293,292,1296,-1,1107,941,1063,-1,1107,942,941,-1,1360,1292,1309,-1,1360,1294,1292,-1,291,1065,1102,-1,291,290,1065,-1,111,113,112,-1,111,339,113,-1,1269,108,109,-1,108,1269,1270,-1,1047,1242,1268,-1,1242,1047,1289,-1,155,1288,1264,-1,155,1303,1288,-1,1120,1008,1005,-1,1120,149,1008,-1,95,921,312,-1,69,921,95,-1,1286,302,301,-1,302,1286,299,-1,86,91,80,-1,86,760,91,-1,1142,1060,81,-1,1142,943,1060,-1,760,89,91,-1,876,89,760,-1,941,1064,1102,-1,941,1142,1064,-1,125,332,1243,-1,125,1079,332,-1,1140,74,76,-1,1140,61,74,-1,54,973,55,-1,54,1131,973,-1,1096,48,1274,-1,1096,989,48,-1,23,279,1067,-1,23,25,279,-1,12,1088,1082,-1,9,1088,12,-1,1084,1276,1022,-1,14,1276,1084,-1,1276,14,13,-1,1083,1278,1074,-1,1083,1082,1278,-1,1277,6,17,-1,1093,6,1277,-1,1090,1094,1092,-1,1094,1090,1537,-1,0,930,1,-1,930,0,1087,-1,1067,949,21,-1,1067,950,949,-1,1139,23,57,-1,23,1139,24,-1,28,1280,1248,-1,27,1280,28,-1,1015,1284,916,-1,1273,1284,1015,-1,947,290,289,-1,290,947,946,-1,293,128,1137,-1,128,293,1536,-1,53,79,82,-1,79,53,52,-1,1141,1049,94,-1,1141,1050,1049,-1,1058,1043,1042,-1,1058,939,1043,-1,934,294,1271,-1,934,298,294,-1,29,1376,1370,-1,1376,29,926,-1,1110,189,1007,-1,1030,189,1110,-1,1538,1291,1290,-1,1388,1291,1538,-1,118,1242,123,-1,1268,1242,118,-1,266,1371,1521,-1,1371,266,30,-1,1539,905,1377,-1,1539,1517,905,-1,1136,262,961,-1,1136,965,262,-1,227,1266,1252,-1,1144,1266,227,-1,1145,1266,1144,-1,1518,133,1283,-1,133,1518,134,-1,1146,1147,141,-1,1373,1147,1146,-1,239,1130,985,-1,1130,239,1251,-1,1531,179,1540,-1,1531,1298,179,-1,1301,1541,1299,-1,1541,1301,1372,-1,1091,247,142,-1,1091,1086,247,-1,1253,147,152,-1,1265,147,1253,-1,1000,1122,1104,-1,1000,221,1122,-1,1542,1262,1261,-1,1542,1534,1262,-1,1304,163,1143,-1,163,1304,164,-1,1114,252,251,-1,1114,1113,252,-1,1534,159,1025,-1,1534,1542,159,-1,1306,1543,1349,-1,1306,1305,1543,-1,801,971,1307,-1,1350,971,801,-1,174,1539,175,-1,174,1544,1539,-1,902,1389,346,-1,902,343,1389,-1,1131,244,980,-1,1131,54,244,-1,186,1004,187,-1,186,209,1004,-1,194,1052,1287,-1,194,196,1052,-1,1315,1117,1313,-1,1315,1011,1117,-1,197,97,198,-1,97,197,200,-1,1028,206,1265,-1,206,1028,207,-1,1031,205,150,-1,1545,205,1031,-1,1121,213,210,-1,213,1121,1003,-1,215,310,216,-1,215,1316,310,-1,1001,1056,999,-1,1001,1057,1056,-1,1017,1074,1278,-1,1074,1017,1016,-1,1098,1116,1317,-1,1116,1098,1016,-1,1318,1071,1070,-1,1318,1533,1071,-1,224,226,1100,-1,224,138,226,-1,994,229,1540,-1,229,994,230,-1,234,1327,995,-1,234,233,1327,-1,1258,1096,925,-1,1096,1258,1282,-1,1509,1320,991,-1,1509,1324,1320,-1,1442,1326,1325,-1,1442,1446,1326,-1,241,1330,1251,-1,241,1328,1330,-1,1535,1546,1547,-1,1535,1407,1546,-1,987,1548,988,-1,1548,987,1332,-1,1546,1549,1547,-1,1549,1546,602,-1,1332,1337,1548,-1,1337,1332,1334,-1,977,1549,602,-1,976,1549,977,-1,1338,1335,1339,-1,1343,1335,1338,-1,1338,1341,1343,-1,1341,1338,1527,-1,1342,1525,1346,-1,1342,1341,1525,-1,177,7,1537,-1,7,177,18,-1,1305,1346,1543,-1,1132,1346,1305,-1,143,161,305,-1,143,142,161,-1,1263,1306,967,-1,1263,1115,1306,-1,1550,1263,1351,-1,1550,1261,1263,-1,1112,1550,1353,-1,1114,1550,1112,-1,1114,1260,1550,-1,1523,1355,1353,-1,1355,1523,1357,-1,969,255,1135,-1,255,969,253,-1,1551,1357,1522,-1,1551,1359,1357,-1,165,1552,666,-1,165,167,1552,-1,168,167,165,-1,200,963,962,-1,200,1254,963,-1,920,265,1519,-1,920,259,265,-1,1310,266,1309,-1,1310,267,266,-1,33,1364,34,-1,1364,33,927,-1,953,1365,951,-1,1363,1365,953,-1,27,1366,1280,-1,27,276,1366,-1,275,1365,276,-1,1367,1365,275,-1,273,1069,1068,-1,1069,273,1368,-1,1080,1361,282,-1,1080,1279,1361,-1,1293,74,283,-1,945,74,1293,-1,945,75,74,-1,1297,960,1295,-1,1297,1553,960,-1,959,1553,1247,-1,959,960,1553,-1,1286,1247,299,-1,959,1247,1286,-1,1369,115,1044,-1,1369,1045,115,-1,217,313,312,-1,313,217,216,-1,1301,236,1125,-1,236,1301,1300,-1,320,1034,321,-1,320,1554,1034,-1,324,1554,320,-1,324,323,1554,-1,1380,1246,1197,-1,1246,1380,1379,-1,175,1377,336,-1,175,1539,1377,-1,36,911,37,-1,911,36,105,-1,1382,1544,1497,-1,1544,1382,1381,-1,899,1299,1541,-1,1299,899,1385,-1,1385,1302,1299,-1,1302,1385,1384,-1,343,1291,1389,-1,342,1291,343,-1,1512,1290,1516,-1,1290,1512,1538,-1,897,1390,369,-1,820,1390,897,-1,364,1149,1151,-1,364,356,1149,-1,738,424,735,-1,738,693,424,-1,887,679,463,-1,887,730,679,-1,811,883,1239,-1,811,1154,883,-1,1498,694,1198,-1,694,1498,1406,-1,580,1223,578,-1,414,1223,580,-1,644,453,645,-1,454,453,644,-1,439,449,448,-1,439,874,449,-1,446,440,448,-1,440,446,1205,-1,445,1404,1160,-1,445,652,1404,-1,646,1160,866,-1,646,445,1160,-1,758,653,486,-1,758,1202,653,-1,873,764,456,-1,873,1237,764,-1,1229,1430,1393,-1,1430,1229,831,-1,828,553,835,-1,838,553,828,-1,766,473,400,-1,766,471,473,-1,566,521,520,-1,566,1394,521,-1,474,1397,1396,-1,1201,1397,474,-1,1494,479,1555,-1,1494,480,479,-1,486,1193,758,-1,485,1193,486,-1,1398,1206,1232,-1,1206,1398,1556,-1,1401,1232,1231,-1,1398,1232,1401,-1,1204,1405,1402,-1,1405,1204,650,-1,863,496,501,-1,496,863,497,-1,509,881,1196,-1,508,881,509,-1,498,843,677,-1,843,497,859,-1,843,498,497,-1,504,816,599,-1,503,816,504,-1,843,1412,1169,-1,843,858,1412,-1,1300,1415,1414,-1,1300,1302,1415,-1,536,822,512,-1,536,844,822,-1,797,536,535,-1,797,352,536,-1,797,1241,352,-1,856,516,551,-1,516,856,514,-1,559,556,1162,-1,559,562,556,-1,873,1395,1394,-1,1395,873,458,-1,663,522,524,-1,1467,522,663,-1,791,1164,792,-1,791,847,1164,-1,1557,1424,1461,-1,1424,1557,1422,-1,800,612,1216,-1,800,1462,612,-1,1400,1556,1398,-1,1400,1503,1556,-1,468,552,1173,-1,547,552,468,-1,1427,1428,1511,-1,1428,1427,837,-1,832,1229,1228,-1,832,831,1229,-1,1429,831,833,-1,1429,1430,831,-1,1510,515,514,-1,1510,1431,515,-1,556,790,554,-1,556,562,790,-1,865,564,1432,-1,865,557,564,-1,826,824,565,-1,826,567,824,-1,1226,669,571,-1,529,669,1226,-1,1436,1558,528,-1,1436,1434,1558,-1,1558,411,678,-1,413,411,1558,-1,1223,805,576,-1,805,1223,1435,-1,403,1411,587,-1,402,1411,403,-1,1169,1411,402,-1,1440,1443,1438,-1,1440,1444,1443,-1,812,810,591,-1,812,1154,810,-1,883,597,1167,-1,884,597,883,-1,1322,1439,1438,-1,1322,1324,1439,-1,809,1447,1178,-1,1447,809,1445,-1,1448,600,1410,-1,600,1448,598,-1,505,1559,1409,-1,505,601,1559,-1,598,1450,1560,-1,598,1448,1450,-1,806,1559,601,-1,603,1559,806,-1,1218,1560,1450,-1,1561,1560,1218,-1,1562,1218,605,-1,1562,1561,1218,-1,1454,604,807,-1,1563,604,1454,-1,610,605,608,-1,610,1562,605,-1,1457,1563,1454,-1,1505,1563,1457,-1,373,1217,608,-1,1217,373,372,-1,1464,1456,1458,-1,1464,1457,1456,-1,355,1390,844,-1,355,363,1390,-1,1463,1460,1421,-1,1458,1460,1463,-1,1557,853,852,-1,1557,1417,853,-1,1250,1216,611,-1,1250,1350,1216,-1,1466,1214,852,-1,1215,1214,1466,-1,1215,1212,1211,-1,1212,1215,1470,-1,1471,1468,1213,-1,1477,1468,1471,-1,1212,1474,1181,-1,1474,1212,1472,-1,1473,1475,1472,-1,1473,1551,1475,-1,1552,1471,1165,-1,1552,1476,1471,-1,1209,788,1210,-1,1209,616,788,-1,1157,782,618,-1,879,782,1157,-1,617,783,620,-1,617,625,783,-1,624,1401,625,-1,1399,1401,624,-1,278,1152,637,-1,278,774,1152,-1,629,1500,1499,-1,1500,629,628,-1,1479,1515,1502,-1,1515,1479,1480,-1,1482,1208,1187,-1,1482,1501,1208,-1,639,891,1483,-1,638,891,639,-1,783,647,866,-1,647,783,1231,-1,288,766,285,-1,288,471,766,-1,444,1232,1206,-1,444,443,1232,-1,652,1402,1404,-1,1203,1402,652,-1,761,649,651,-1,650,649,761,-1,1202,622,653,-1,623,622,1202,-1,657,759,107,-1,451,759,657,-1,1484,1193,485,-1,1193,1484,489,-1,351,1201,349,-1,1397,1201,351,-1,664,524,526,-1,664,663,524,-1,1392,781,1485,-1,1392,1153,781,-1,506,675,1167,-1,506,676,675,-1,1222,1487,499,-1,1222,742,1487,-1,1514,746,740,-1,1514,747,746,-1,698,678,534,-1,698,1199,678,-1,880,680,464,-1,880,430,680,-1,422,387,1391,-1,422,388,387,-1,426,1161,864,-1,700,1161,426,-1,692,687,1155,-1,687,692,688,-1,1413,721,695,-1,721,1413,722,-1,846,700,699,-1,846,1488,700,-1,731,699,696,-1,731,703,699,-1,701,706,709,-1,706,701,1166,-1,474,710,717,-1,474,1396,710,-1,1488,1378,1380,-1,846,1378,1488,-1,1491,106,1382,-1,871,106,1491,-1,1384,1492,1496,-1,1386,1492,1384,-1,1555,1387,1388,-1,1555,1426,1387,-1,1494,1512,1420,-1,1538,1512,1494,-1,1555,727,1426,-1,727,1555,479,-1,1302,1496,1415,-1,1384,1496,1302,-1,1415,722,1413,-1,1496,722,1415,-1,1425,1382,1497,-1,1491,1382,1425,-1,698,396,889,-1,697,396,698,-1,532,721,405,-1,530,721,532,-1,1488,1161,700,-1,732,1161,1488,-1,421,737,736,-1,737,421,689,-1,423,1391,467,-1,1391,423,422,-1,1513,740,739,-1,1513,1514,740,-1,499,746,581,-1,499,1487,746,-1,236,1414,596,-1,1300,1414,236,-1,495,751,784,-1,495,1174,751,-1,1194,753,827,-1,750,753,1194,-1,869,1484,485,-1,869,482,1484,-1,1405,761,1192,-1,1405,650,761,-1,768,1556,769,-1,768,1206,1556,-1,768,1156,1206,-1,1500,383,1191,-1,1500,1502,383,-1,417,779,418,-1,1481,779,417,-1,1501,776,775,-1,776,1501,1482,-1,1480,890,1515,-1,1480,775,890,-1,1501,633,1208,-1,633,1501,1188,-1,777,673,632,-1,674,673,777,-1,780,1503,1400,-1,780,1185,1503,-1,1184,681,1486,-1,1184,493,681,-1,1210,1174,495,-1,1210,788,1174,-1,1552,667,666,-1,1165,667,1552,-1,667,1165,847,-1,1504,1551,1473,-1,1504,1359,1551,-1,1474,613,1181,-1,611,613,1474,-1,1477,1469,1468,-1,1504,1469,1477,-1,1183,851,1163,-1,848,851,1183,-1,1422,852,1214,-1,1422,1557,852,-1,798,535,523,-1,798,797,535,-1,1460,1424,1421,-1,1424,1460,609,-1,365,857,803,-1,857,365,367,-1,1180,1457,1464,-1,1180,1505,1457,-1,978,1505,1347,-1,978,1563,1505,-1,1459,1562,610,-1,1459,1506,1562,-1,978,604,1563,-1,978,977,604,-1,1506,1561,1562,-1,1506,1507,1561,-1,1561,1508,1560,-1,1507,1508,1561,-1,603,1546,1559,-1,602,1546,603,-1,1560,1220,598,-1,1508,1220,1560,-1,1546,1409,1559,-1,1546,1407,1409,-1,1408,809,808,-1,1408,1445,809,-1,1447,1442,1443,-1,1447,1446,1442,-1,1439,1509,592,-1,1439,1324,1509,-1,597,812,595,-1,597,884,812,-1,1239,1167,675,-1,883,1167,1239,-1,1444,586,585,-1,1444,1440,586,-1,815,587,1411,-1,814,587,815,-1,413,1434,414,-1,413,1558,1434,-1,528,407,1436,-1,408,407,528,-1,571,1433,1226,-1,368,1433,571,-1,368,357,1433,-1,1238,566,568,-1,1238,1237,566,-1,1194,1175,749,-1,1194,1432,1175,-1,825,557,554,-1,564,557,825,-1,1429,514,856,-1,514,1429,1510,-1,833,1228,855,-1,832,1228,833,-1,751,836,752,-1,1174,836,751,-1,1225,1511,1428,-1,1225,539,1511,-1,1511,839,1427,-1,839,1511,840,-1,840,546,545,-1,840,540,546,-1,560,538,842,-1,560,830,538,-1,542,546,543,-1,546,542,1224,-1,584,677,843,-1,584,1200,677,-1,528,678,529,-1,1558,678,528,-1,1503,769,1556,-1,769,1503,1499,-1,794,1462,1463,-1,1462,794,612,-1,1461,1417,1557,-1,1461,1179,1417,-1,1182,849,848,-1,1182,1227,849,-1,662,1467,663,-1,793,1467,662,-1,853,1419,854,-1,853,1418,1419,-1,570,567,520,-1,570,824,567,-1,856,548,1393,-1,548,856,549,-1,1195,498,677,-1,1195,1230,498,-1,506,695,507,-1,506,1168,695,-1,599,815,600,-1,816,815,599,-1,743,677,676,-1,677,743,1195,-1,861,1513,1498,-1,748,1513,861,-1,858,502,817,-1,858,863,502,-1,863,858,859,-1,619,616,1209,-1,619,614,616,-1,709,702,701,-1,709,1490,702,-1,1485,780,1478,-1,781,780,1485,-1,437,655,442,-1,437,436,655,-1,1396,711,710,-1,711,1396,1159,-1,1555,1538,1494,-1,1538,1555,1388,-1,839,470,469,-1,839,841,470,-1,427,464,463,-1,464,427,438,-1,486,461,460,-1,486,653,461,-1,473,642,1158,-1,473,1235,642,-1,1160,1403,867,-1,1404,1403,1160,-1,434,399,400,-1,434,382,399,-1,436,645,453,-1,435,645,436,-1,1406,531,694,-1,531,1406,881,-1,1515,770,1189,-1,770,1515,890,-1,415,638,416,-1,891,638,415,-1,634,420,778,-1,634,1152,420,-1,511,1234,475,-1,511,361,1234,-1,898,361,511,-1,1433,370,409,-1,1433,371,370,-1,367,1151,1149,-1,1151,367,366,-1,1493,346,1495,-1,1493,347,346,-1,1385,1075,1383,-1,1385,899,1075,-1,906,343,902,-1,343,906,908,-1,1497,174,1489,-1,174,1497,1544,-1,905,1269,111,-1,1269,905,1517,-1,904,1377,905,-1,907,1377,904,-1,909,1259,176,-1,909,1379,1259,-1,900,1541,912,-1,899,1541,900,-1,66,918,67,-1,326,918,66,-1,317,1197,1246,-1,317,733,1197,-1,919,917,325,-1,919,333,917,-1,334,333,919,-1,101,1053,71,-1,101,1054,1053,-1,312,307,217,-1,312,42,307,-1,42,312,1275,-1,223,1283,133,-1,1099,1283,223,-1,323,1374,1554,-1,1374,323,922,-1,1554,1035,1034,-1,1554,1374,1035,-1,925,140,1258,-1,925,141,140,-1,1055,1519,1103,-1,1055,920,1519,-1,928,1018,929,-1,1018,928,1148,-1,1271,933,934,-1,1271,1303,933,-1,935,110,109,-1,935,116,110,-1,940,1058,53,-1,1058,940,937,-1,1553,300,1247,-1,300,1553,1297,-1,1296,1061,1536,-1,1061,1296,940,-1,1065,945,1108,-1,1065,944,945,-1,942,260,129,-1,1107,260,942,-1,24,639,1483,-1,639,24,1139,-1,951,1367,1249,-1,951,1365,1367,-1,1280,1520,1279,-1,1366,1520,1280,-1,1249,20,951,-1,20,1249,21,-1,1279,955,1361,-1,1279,1520,955,-1,268,733,317,-1,268,627,733,-1,1362,267,1310,-1,1138,267,1362,-1,1519,1521,1371,-1,1519,265,1521,-1,263,84,127,-1,84,263,85,-1,261,963,961,-1,957,963,261,-1,201,1136,1254,-1,201,964,1136,-1,1354,1552,167,-1,1354,1476,1552,-1,1475,1522,1356,-1,1475,1551,1522,-1,1522,1523,1352,-1,1357,1523,1522,-1,1353,1351,1523,-1,1353,1550,1351,-1,1304,160,250,-1,160,1304,1027,-1,1261,1260,1542,-1,1260,1261,1550,-1,970,1135,1524,-1,1135,970,969,-1,1262,1115,1263,-1,1262,1019,1115,-1,1346,1526,1543,-1,1526,1346,1525,-1,1537,178,177,-1,1537,1090,178,-1,1341,1345,1525,-1,1341,1527,1345,-1,972,55,973,-1,249,55,972,-1,979,1527,1338,-1,1527,979,1348,-1,982,974,973,-1,982,1336,974,-1,1343,1334,1335,-1,1340,1334,1343,-1,1549,1339,1528,-1,1339,1549,976,-1,1548,981,1529,-1,981,1548,1337,-1,1547,1528,983,-1,1528,1547,1549,-1,1529,988,1548,-1,1529,1530,988,-1,1547,1130,1535,-1,1547,983,1130,-1,1129,1530,1531,-1,988,1530,1129,-1,1326,241,1128,-1,1328,241,1326,-1,1441,991,1123,-1,1441,1509,991,-1,1274,925,1096,-1,1274,924,925,-1,1325,233,1323,-1,1325,1327,233,-1,1540,1076,994,-1,1540,1077,1076,-1,1077,1540,179,-1,243,997,998,-1,245,997,243,-1,1072,1533,1148,-1,1533,1072,1071,-1,1533,1317,1116,-1,1533,1318,1317,-1,929,1017,222,-1,1017,929,1018,-1,221,256,214,-1,221,1000,256,-1,1003,130,1316,-1,1003,1121,130,-1,151,210,213,-1,151,146,210,-1,1111,1545,1031,-1,1111,1532,1545,-1,205,1532,206,-1,205,1545,1532,-1,1313,964,201,-1,1117,964,1313,-1,1287,192,1314,-1,1052,192,1287,-1,1256,1011,1315,-1,184,1011,1256,-1,1000,257,256,-1,1000,999,257,-1,184,1118,182,-1,184,1009,1118,-1,1117,188,964,-1,1117,1012,188,-1,181,1077,179,-1,181,996,1077,-1,1495,1389,1387,-1,1495,346,1389,-1,1381,1539,1544,-1,1381,1517,1539,-1,1526,1349,1543,-1,1524,1349,1526,-1,665,1516,306,-1,1512,1516,665,-1,251,1542,1260,-1,1542,251,159,-1,1104,156,158,-1,1104,1122,156,-1,1006,150,1120,-1,1031,150,1006,-1,1085,142,144,-1,1085,1091,142,-1,1541,1257,912,-1,1541,1372,1257,-1,1129,1540,229,-1,1129,1531,1540,-1,1251,1535,1130,-1,1535,1251,1330,-1,1284,1518,1283,-1,1284,1244,1518,-1,1518,1245,134,-1,1245,1518,1375,-1,936,1102,1064,-1,936,291,1102,-1,1521,1309,266,-1,1521,1360,1309,-1,154,1289,1047,-1,1041,1289,154,-1,339,110,1045,-1,111,110,339,-1,1303,1105,933,-1,155,1105,1303,-1,288,1050,1285,-1,1050,288,287,-1,193,1007,189,-1,193,1051,1007,-1,1370,1053,1103,-1,1376,1053,1370,-1,298,302,299,-1,934,302,298,-1,128,943,129,-1,128,1060,943,-1,1536,1060,128,-1,1536,1061,1060,-1,1064,81,79,-1,1142,81,1064,-1,126,1101,1066,-1,1243,1101,126,-1,76,944,946,-1,75,944,76,-1,1282,1097,1096,-1,1282,1124,1097,-1,335,1275,312,-1,335,41,1275,-1,64,333,332,-1,64,917,333,-1,17,1092,1277,-1,17,16,1092,-1,1537,12,1094,-1,12,1537,7,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t7_Coord',point=[(-.4814,47.5652,-3.26569),(-.47921,47.65798,-3.23899),(-.44785,47.68578,-3.32646),(-.47043,47.56994,-2.94389),(-.48064,47.5594,-2.94853),(-.47825,47.55644,-2.94247),(-.46979,47.5016,-2.96819),(-.49603,47.56097,-3.17122),(-.4827,47.63787,-3.19417),(-.49324,47.55687,-3.17587),(-.48455,47.63689,-3.18775),(-.44228,47.67231,-3.15965),(-.49346,47.55624,-3.17523),(-.43792,47.67148,-3.16595),(-.43339,47.67018,-3.171),(-.48121,47.63827,-3.1962),(-.49131,47.50536,-2.97706),(-.4734,47.50419,-2.9724),(-.48803,47.62169,-3.15603),(-.45002,47.67273,-3.14491),(-.07228,46.41003,-4.10371),(-.05364,46.31995,-4.21111),(-.02366,46.40042,-4.11036),(-.06322,46.17107,-4.45949),(-.02371,46.16725,-4.46119),(-.01549,46.14116,-4.3938),(-.02182,46.6629,-4.43144),(-.0261,46.75874,-4.3201),(-.00684,46.79856,-4.34664),(-.39994,46.89585,-3.74112),(-.3789,46.94993,-3.77227),(-.32465,46.91349,-3.8064),(-.19412,46.74467,-3.91178),(-.20258,46.7546,-3.91757),(-.15462,46.66009,-3.99051),(-.31829,47.27949,-3.44538),(-.32023,47.27978,-3.42977),(-.43258,47.2823,-3.41891),(-.26214,46.85248,-3.78851),(-.24377,46.85165,-3.79475),(-.30823,46.85538,-3.71493),(-.43384,47.2797,-3.43354),(-.43686,47.28914,-3.42476),(-.01472,46.58842,-4.51074),(-.03718,46.56289,-4.49467),(-.00013,46.58693,-4.52269),(0,46.37982,-4.5483),(-.02155,46.39052,-4.54387),(-.36005,46.89646,-2.81312),(-.36573,46.89509,-2.80549),(-.37739,46.89204,-2.81449),(-.10153,47.74595,-3.59169),(-.10416,47.75425,-3.60778),(-.11062,47.76125,-3.59247),(-.4608,47.28754,-2.8027),(-.46987,47.38562,-2.80309),(-.47324,47.38803,-2.81559),(-.05003,46.26955,-4.50386),(-.04835,46.42289,-4.52543),(-.01855,47.10467,-4.21604),(-.0131,47.08296,-4.22606),(-.07948,47.19008,-4.11737),(-.29856,46.86341,-3.66339),(-.29988,47.02548,-3.63279),(-.30994,47.02539,-3.61866),(-.4343,47.15134,-3.53545),(-.43076,47.13548,-3.53209),(-.37252,47.14571,-3.56026),(-.47947,47.13238,-3.52118),(-.49171,47.13935,-3.52246),(-.55933,47.08577,-3.53917),(-.53649,46.91476,-3.58511),(-.52865,46.91971,-3.58517),(-.59532,46.99054,-3.53572),(-.0952,47.28821,-4.02099),(-.09609,47.30015,-4.01635),(-.0918,47.30061,-4.02882),(-.36104,47.15396,-3.56491),(-.36784,47.15892,-3.5612),(-.17336,47.65751,-3.68793),(-.06246,47.73795,-3.65267),(-.18817,47.6475,-3.67953),(-.17974,47.65536,-3.66851),(-.5166,47.74269,-3.51957),(-.51612,47.72972,-3.54556),(-.5334,47.73626,-3.53722),(-.0555,47.73217,-3.64059),(-.05761,47.68896,-3.63232),(-.0029,47.68358,-3.67584),(-.01323,47.61927,-3.75415),(-.07877,47.67529,-3.70484),(-.01157,47.68942,-3.72257),(-.05926,47.25012,-4.14266),(-.069,47.24131,-4.13923),(-.09259,47.34537,-4.07555),(-.58009,47.14281,-3.55603),(-.72972,47.31281,-3.70337),(-.69902,47.30928,-3.74603),(-.60804,47.22828,-3.67697),(-.60335,47.14726,-3.62616),(-.61375,47.06683,-3.5945),(-.60553,46.98913,-3.54113),(-.56168,47.07842,-3.54155),(-.27981,47.23207,-3.27136),(-.33515,47.23806,-3.28298),(-.32188,47.27235,-3.35174),(0,47.53027,-3.65487),(0,47.61982,-3.66753),(-.06286,47.63181,-3.62325),(-.14103,47.66347,-3.58099),(-.15667,47.69691,-3.52613),(-.22596,47.63519,-3.4708),(-.28123,47.56303,-3.39201),(-.30204,47.60943,-3.37544),(-.28536,47.58079,-3.29913),(-.17546,47.82471,-3.50173),(-.13158,47.72722,-3.55345),(-.1052,47.75797,-3.58048),(-.35569,47.77256,-3.38085),(-.34146,47.85029,-3.39842),(-.41094,47.84263,-3.35479),(-.29909,47.63006,-3.28658),(-.32285,47.65583,-3.35873),(-.35233,47.71017,-3.32828),(-.31616,46.85594,-3.70519),(-.36796,46.86147,-3.64492),(-.38286,46.86283,-3.64023),(-.448,47.6456,-3.65825),(-.31831,47.6594,-3.63437),(-.35272,47.58306,-3.69959),(-.9304,47.41614,-3.68121),(-1.05484,47.39414,-3.7592),(-.87576,47.3553,-3.73676),(-.61822,47.11388,-3.18689),(-.62329,47.10149,-3.18579),(-.6749,47.10247,-3.09106),(-.61299,46.9502,-2.92774),(-.60744,46.95128,-2.91438),(-.6551,47.05623,-2.997),(-.44232,46.88251,-3.10641),(-.39459,46.88696,-3.11251),(-.44487,46.88303,-2.99688),(-.45307,47.57899,-2.93665),(-.43899,47.6226,-3.06233),(-.45339,47.62123,-3.05883),(-1.01634,47.59722,-3.70591),(-.9721,47.68994,-3.69812),(-.98411,47.68706,-3.71953),(-1.15204,47.45706,-3.84937),(-1.15233,47.44508,-3.84239),(-1.14993,47.45607,-3.83662),(-.96658,47.69959,-3.69824),(-.9657,47.70437,-3.7076),(-.45732,47.70316,-3.37803),(-.47198,47.73165,-3.34888),(-.49366,47.75763,-3.38796),(-.48531,47.58997,-3.36907),(-.46131,47.62711,-3.36),(-.46028,47.66912,-3.40002),(-.37646,47.57218,-2.88749),(-.38364,47.58101,-2.9545),(-.39852,47.58598,-2.95253),(-.11407,47.58818,-3.07249),(-.19025,47.62786,-3.11453),(-.19398,47.62026,-3.10068),(-.08932,47.59102,-3.06519),(-.10139,47.5973,-3.07892),(-.09174,47.57242,-2.9883),(-.09837,47.58637,-3.05538),(-.17145,47.57076,-2.98665),(-.32706,47.67977,-3.19401),(-.32953,47.68189,-3.17149),(-.19631,47.64666,-3.20301),(-.40178,47.682,-3.17952),(-.12768,47.25341,-3.65899),(-.22183,47.26352,-3.59566),(-.25647,47.16327,-3.64602),(-.47816,47.59083,-3.065),(-.48407,47.56401,-2.95831),(-.51552,46.86685,-2.7482),(-.54189,46.88603,-2.84913),(-.42099,46.89045,-2.82378),(-.97735,47.7549,-3.90709),(-.92538,47.75194,-3.90245),(-1.01756,47.69264,-3.98101),(-.95078,47.75926,-3.82827),(-.87969,47.72421,-3.80977),(-.81941,47.71784,-3.73763),(-.74867,47.71969,-3.80186),(-1.16919,47.58825,-3.92925),(-1.164,47.6005,-3.9301),(-1.12161,47.62168,-3.96836),(-1.06437,47.52184,-4.02098),(-1.12748,47.54847,-3.96907),(-1.03628,47.37032,-3.93682),(-1.07649,47.36999,-3.88959),(-1.09934,47.39803,-3.93617),(-.75733,47.40487,-3.87247),(-.79946,47.34371,-3.82277),(-.9097,47.38305,-3.91773),(-.67072,47.37088,-3.78906),(-.73149,47.51523,-3.87003),(-.94957,47.35294,-3.87582),(-.9933,47.36643,-3.8263),(-1.11319,47.5572,-3.84599),(-1.10742,47.53746,-3.83101),(-1.06553,47.61435,-3.82565),(-1.07958,47.61231,-3.84491),(-1.10804,47.58361,-3.85268),(-.90648,47.74111,-3.7472),(-.97881,47.59596,-3.65914),(-1.08246,47.4779,-3.73708),(-.87626,47.67701,-3.59569),(-.87305,47.59747,-3.57126),(-.7862,47.59595,-3.50147),(-.72106,47.42668,-3.53751),(-.66635,47.36281,-3.59305),(-.5497,47.36205,-3.50041),(-.51782,47.5184,-3.3766),(-.65282,47.52182,-3.43837),(-.60198,47.435,-3.46325),(-.66487,47.59949,-3.45336),(-.47281,47.50235,-3.28574),(-.54322,47.18236,-3.17309),(-.66971,47.11361,-3.0875),(-.55194,47.03091,-2.89768),(-.57501,47.11755,-2.98504),(-.58024,46.90125,-2.87059),(-.41439,46.88091,-2.40041),(-.45134,46.87208,-2.52033),(-.36664,46.89258,-2.5104),(-.31964,46.92654,-2.72163),(-.40612,46.8938,-2.72389),(-.226,46.93765,-2.60871),(-.32156,46.90868,-2.61241),(-.22681,46.94308,-2.7169),(0,46.90014,-3.05906),(0,46.93925,-2.97889),(-.11966,46.93598,-2.99444),(-.35364,46.86933,-2.29333),(-.27303,46.88792,-2.34339),(-.21215,46.89773,-2.28888),(-.45789,47.29021,-2.83178),(-.47649,47.20081,-2.85199),(-.47315,47.19135,-2.80933),(-.4869,47.23715,-2.94694),(-.47958,47.31562,-2.92168),(-.47642,47.57587,-2.86347),(-.47286,47.48961,-2.88908),(-.48362,47.48557,-2.80433),(-.29922,47.58013,-2.96397),(-.29619,47.56192,-2.89644),(-.20837,47.56894,-2.98253),(-.08678,47.55237,-2.36912),(0,47.5422,-2.43404),(-.08491,47.54717,-2.43315),(-.78295,47.66491,-3.53397),(-.7661,47.72628,-3.57765),(-.72299,47.70081,-3.65572),(-.53539,47.18915,-3.7037),(-.37284,47.50066,-3.73149),(-.45407,47.53132,-3.73717),(-.57086,47.66617,-3.68038),(-.61199,47.70225,-3.58685),(-.43089,47.26958,-3.73511),(-.47637,47.15337,-3.72694),(-.34624,47.05288,-3.80032),(-.29381,47.00241,-3.85079),(-.10532,46.70616,-3.88696),(-.09243,46.62178,-3.94919),(0,46.50307,-4.01675),(0,46.59176,-3.96255),(-.01864,46.50961,-4.01708),(-.078,46.26961,-4.3357),(-.07425,46.20998,-4.31789),(-.05045,46.56176,-4.35593),(-.07638,46.64941,-4.25152),(0,46.13052,-4.37036),(0,46.14165,-4.3199),(-.01893,46.14877,-4.31668),(0,46.8019,-4.35731),(0,46.67137,-4.44933),(-.09707,47.10807,-4.08696),(-.14554,47.18597,-3.98802),(-.03967,47.27005,-4.15068),(0,47.22608,-4.18086),(0,47.18525,-4.206),(-.03161,47.39203,-4.08217),(0,47.40937,-4.07878),(-.00965,47.46867,-3.96554),(-.06053,47.41245,-3.96969),(-.07084,47.50434,-3.8392),(-.40637,47.79674,-3.52439),(-.41884,47.70922,-3.56142),(-.53699,47.79853,-3.43473),(-.49137,47.80395,-3.48645),(-.53153,47.74004,-3.52234),(-.56671,47.73974,-3.47581),(-.49922,47.90604,-3.40258),(-.42341,48.0058,-3.40999),(-.46087,47.89614,-3.45233),(-.31061,48.02693,-3.42256),(-.42148,48.00184,-3.39784),(-.41935,47.91688,-3.37443),(-.43263,47.67683,-3.14684),(-.38783,47.63424,-3.07404),(-.11118,47.64394,-3.13941),(-.47409,47.35818,-3.40464),(-.50232,47.43356,-3.38521),(-.83202,47.3192,-3.78476),(-.77434,47.35677,-3.65454),(-.60178,47.19908,-3.58639),(-.49933,47.26967,-3.54734),(-.63371,47.28193,-3.63079),(-.31905,46.88344,-3.7627),(-.24729,46.84712,-3.80873),(-.23509,46.84298,-3.8034),(-.11408,46.81143,-3.82806),(-.24478,46.90632,-3.73618),(-.66581,47.07229,-3.10472),(-.61981,47.02387,-3.1251),(-.65471,47.03498,-3.0464),(-.49532,46.93364,-3.21043),(-.52672,46.94648,-3.12239),(-.57039,47.0114,-3.19968),(-.42811,47.03628,-3.56811),(-.4234,47.07655,-3.55786),(-.45553,47.06811,-3.54501),(-.55066,47.07593,-3.53667),(-.48864,47.0363,-3.56182),(-.49197,46.99967,-3.5606),(-.47936,46.98239,-3.57641),(-.30961,46.86691,-3.653),(-.36107,46.99753,-3.60057),(-.39555,46.96364,-3.58998),(-.43803,47.24944,-3.50186),(-.29939,47.26848,-3.52845),(-.40575,47.68775,-3.22526),(-.34287,47.67351,-3.25872),(-.26808,47.68691,-3.44136),(-.31358,47.73308,-3.41014),(-.27162,47.53151,-3.31155),(-.1933,47.52924,-3.24121),(-.19396,47.4308,-3.24893),(-.27388,47.25705,-3.28472),(-.20428,47.23356,-3.24312),(-.09965,47.32815,-3.20677),(-.10288,47.23035,-3.21042),(-.19328,47.63943,-3.21744),(.47921,47.65798,-3.23899),(.44785,47.68578,-3.32646),(.4503,47.70566,-3.30969),(.46489,47.57651,-2.94455),(.47043,47.56994,-2.94389),(.4821,47.55948,-2.9529),(.48407,47.56401,-2.95831),(.49131,47.50536,-2.97706),(.47135,47.54647,-3.18809),(.47967,47.64035,-3.20177),(.48121,47.63827,-3.1962),(.43072,47.67009,-3.17791),(.43339,47.67018,-3.171),(.46584,47.57508,-2.93681),(.49416,47.50977,-2.98056),(.49156,47.50417,-2.97864),(.47286,47.48961,-2.88908),(.4698,47.49469,-2.97679),(.46979,47.5016,-2.96819),(.4814,47.5652,-3.26569),(.49038,47.52254,-3.08001),(.47028,47.51451,-3.08217),(.47338,47.54244,-3.1784),(.48362,47.48557,-2.80433),(.46987,47.38562,-2.80309),(.47324,47.38803,-2.81559),(.02366,46.40042,-4.11036),(.07228,46.41003,-4.10371),(.07752,46.52871,-4.01794),(.01472,46.58842,-4.51074),(.01016,46.67614,-4.44095),(.02182,46.6629,-4.43144),(.01167,46.96518,-4.26487),(.0131,47.08296,-4.22606),(.04241,47.0204,-4.19434),(.32465,46.91349,-3.8064),(.31905,46.88344,-3.7627),(.24729,46.84712,-3.80873),(.41169,46.86564,-3.72367),(.38286,46.86283,-3.64023),(.31658,46.85983,-3.72478),(.30823,46.85538,-3.71493),(.31616,46.85594,-3.70519),(.31186,46.85931,-3.66277),(.23509,46.84298,-3.8034),(.19412,46.74467,-3.91178),(.31829,47.27949,-3.44538),(.32023,47.27978,-3.42977),(.3166,47.2871,-3.43679),(.24377,46.85165,-3.79475),(0,47.09628,-4.24346),(.05926,47.25012,-4.14266),(.40612,46.8938,-2.72389),(.42082,46.88924,-2.72577),(.41197,46.89077,-2.71642),(.27981,47.23207,-3.27136),(.30441,47.10082,-3.24851),(.21446,47.10537,-3.23567),(.47744,47.42799,-3.00398),(.45385,47.44756,-3.0966),(.46611,47.50953,-3.08331),(.44138,47.20206,-3.24662),(.48557,47.25447,-3.19788),(.54322,47.18236,-3.17309),(.49405,47.24888,-3.15471),(.51092,47.21938,-3.06941),(.06322,46.17107,-4.45949),(.05003,46.26955,-4.50386),(.07831,46.28814,-4.49315),(.08368,46.18626,-4.43574),(.07425,46.20998,-4.31789),(.06706,46.17674,-4.30645),(.43865,46.89663,-3.60258),(.44457,46.89037,-3.61134),(.53649,46.91476,-3.58511),(.30994,47.02539,-3.61866),(.36104,47.15396,-3.56491),(.29988,47.02548,-3.63279),(.48173,47.14718,-3.52053),(.4343,47.15134,-3.53545),(.47947,47.13238,-3.52118),(.56168,47.07842,-3.54155),(.55066,47.07593,-3.53667),(.59532,46.99054,-3.53572),(.069,47.24131,-4.13923),(.01855,47.10467,-4.21604),(.0602,47.41022,-3.98369),(.06053,47.41245,-3.96969),(.06484,47.41046,-3.97154),(.49171,47.13935,-3.52246),(.07877,47.67529,-3.70484),(.20866,47.59449,-3.74546),(.07795,47.60734,-3.75041),(.16596,47.48179,-3.86631),(.17551,47.46622,-3.86086),(.16684,47.46979,-3.86703),(.23272,47.65096,-3.67116),(.18817,47.6475,-3.67953),(.17974,47.65536,-3.66851),(.17336,47.65751,-3.68793),(.10416,47.75425,-3.60778),(.0555,47.73217,-3.64059),(.05761,47.68896,-3.63232),(.12128,47.70471,-3.58639),(.00965,47.46867,-3.96554),(0,47.48066,-3.99125),(0,47.53735,-3.83392),(.53699,47.79853,-3.43473),(.49922,47.90604,-3.40258),(.53827,47.79071,-3.41729),(.11062,47.76125,-3.59247),(.13816,47.89534,-3.50795),(.14025,47.89869,-3.51635),(.60178,47.19908,-3.58639),(.49933,47.26967,-3.54734),(.58009,47.14281,-3.55603),(.61281,47.01349,-3.64075),(.62667,46.98342,-3.60993),(.5758,46.92515,-3.65276),(1.09934,47.39803,-3.93617),(1.07344,47.44759,-3.97573),(1.1388,47.47511,-3.93796),(.05178,47.35303,-4.10853),(.03161,47.39203,-4.08217),(.08243,47.34853,-4.08695),(.40575,47.68775,-3.22526),(.42506,47.66898,-3.16761),(.46048,47.80417,-3.37012),(.47198,47.73165,-3.34888),(.49366,47.75763,-3.38796),(.1933,47.52924,-3.24121),(.19329,47.58434,-3.2294),(.28536,47.58079,-3.29913),(.21963,47.76093,-3.4744),(.13158,47.72722,-3.55345),(.15667,47.69691,-3.52613),(.23554,47.91078,-3.45489),(.21693,48.00335,-3.47362),(.45732,47.70316,-3.37803),(.41935,47.91688,-3.37443),(.34146,47.85029,-3.39842),(.41094,47.84263,-3.35479),(.26214,46.85248,-3.78851),(.31733,46.87419,-3.74923),(.53539,47.18915,-3.7037),(.50495,47.30461,-3.73049),(.5777,47.33763,-3.73556),(.54013,46.88445,-2.90088),(.54565,46.88417,-2.88194),(.53121,46.88079,-2.89772),(.60604,46.95144,-2.99239),(.61299,46.9502,-2.92774),(.58095,46.89661,-2.88223),(.58024,46.90125,-2.87059),(.35364,46.86933,-2.29333),(.36156,46.8782,-2.28892),(.24706,46.86686,-2.19537),(.39459,46.88696,-3.11251),(.39924,46.89405,-3.12778),(.43046,46.88465,-3.12368),(.43933,46.88245,-3.11728),(.44232,46.88251,-3.10641),(.4369,47.67146,-3.16416),(.45002,47.67273,-3.14491),(1.08246,47.4779,-3.73708),(1.08961,47.4822,-3.74896),(1.0323,47.5975,-3.71368),(1.08743,47.46945,-3.74334),(.46131,47.62711,-3.36),(.48531,47.58997,-3.36907),(.46028,47.66912,-3.40002),(.48714,47.66173,-3.42348),(.4903,47.73691,-3.39999),(.37386,47.62859,-3.0747),(.38783,47.63424,-3.07404),(.38255,47.63636,-3.08634),(.40178,47.682,-3.17952),(.39845,47.67504,-3.15786),(.43263,47.67683,-3.14684),(.45621,47.37519,-3.11769),(.4454,47.40155,-3.21736),(.3892,46.9788,-3.2197),(.43628,46.95824,-3.21989),(.38404,47.08018,-3.26009),(.33515,47.23806,-3.28298),(.42398,47.26958,-3.27135),(.43899,47.6226,-3.06233),(.45339,47.62123,-3.05883),(.81696,47.74384,-3.87483),(.92538,47.75194,-3.90245),(.89356,47.67845,-3.99553),(1.01756,47.69264,-3.98101),(1.02077,47.7155,-3.82348),(1.08171,47.70446,-3.90678),(1.04333,47.73318,-3.90978),(1.164,47.6005,-3.9301),(1.12161,47.62168,-3.96836),(1.07729,47.69283,-3.95744),(1.13691,47.41471,-3.89418),(1.17326,47.51494,-3.89893),(1.15204,47.45706,-3.84937),(1.15233,47.44508,-3.84239),(1.14986,47.4426,-3.8343),(1.11991,47.38769,-3.82404),(.99509,47.4052,-3.98596),(.97881,47.59596,-3.65914),(1.01634,47.59722,-3.70591),(.9721,47.68994,-3.69812),(.96887,47.49785,-3.64305),(1.05484,47.39414,-3.7592),(.9657,47.70437,-3.7076),(.90648,47.74111,-3.7472),(.85202,47.73545,-3.66194),(.96658,47.69959,-3.69824),(.76686,47.51573,-3.5047),(.86391,47.50531,-3.56397),(.7862,47.59595,-3.50147),(.53865,47.70681,-3.44656),(.66053,47.66054,-3.47932),(.64836,47.7201,-3.51698),(.51782,47.5184,-3.3766),(.50528,47.59297,-3.39736),(.47281,47.50235,-3.28574),(.50232,47.43356,-3.38521),(.45789,47.29021,-2.83178),(.47958,47.31562,-2.92168),(.48036,47.40383,-2.89986),(.51463,47.11172,-2.87373),(.55194,47.03091,-2.89768),(.57501,47.11755,-2.98504),(.66971,47.11361,-3.0875),(.56868,47.17155,-3.08003),(.65471,47.03498,-3.0464),(.41481,46.89084,-2.73888),(.37739,46.89204,-2.81449),(.42099,46.89045,-2.82378),(.32245,46.88968,-2.50207),(.32156,46.90868,-2.61241),(.38943,46.88901,-2.61833),(.31964,46.92654,-2.72163),(.22526,46.9518,-2.81915),(.31228,46.91681,-2.81433),(.1143,46.95107,-2.89703),(.11397,46.96464,-2.81373),(.36005,46.89646,-2.81312),(.29585,46.94028,-2.89363),(.11966,46.93598,-2.99444),(.12236,46.91117,-3.07859),(.23388,46.91087,-3.07367),(.47094,46.93912,-2.52848),(.42388,46.89056,-2.39719),(.46319,46.88098,-2.51804),(.24806,46.94222,-2.19438),(0,47.04364,-2.17346),(.1108,47.04975,-2.18381),(.10605,47.1699,-2.20765),(.43725,47.28018,-2.68205),(.45889,47.185,-2.73401),(.44516,47.28231,-2.71981),(.44265,47.37702,-2.69534),(.42694,47.47541,-2.57662),(.40503,47.37199,-2.57975),(.08678,47.55237,-2.34593),(.1896,47.54618,-2.26115),(.13633,47.55321,-2.35755),(.66694,47.6824,-3.72677),(.7236,47.63147,-3.84924),(.63319,47.59732,-3.8064),(.47106,47.41772,-3.74525),(.448,47.6456,-3.65825),(.57086,47.66617,-3.68038),(.45407,47.53132,-3.73717),(.31995,47.90236,-3.51008),(.26896,47.94999,-3.49269),(.3219,47.9768,-3.46342),(.43089,47.26958,-3.73511),(.39827,47.39028,-3.73834),(.10532,46.70616,-3.88696),(0,46.70091,-3.90825),(.19436,46.88214,-3.99168),(.24947,46.95376,-3.90625),(.27586,46.86209,-3.8643),(.09243,46.62178,-3.94919),(.15462,46.66009,-3.99051),(.12207,46.56712,-4.05924),(.01794,46.30273,-4.19425),(0,46.39545,-4.11377),(0,46.30725,-4.18603),(0,46.20136,-4.24395),(.02466,46.25874,-4.5013),(0,46.25961,-4.5039),(.0918,47.30061,-4.02882),(.07587,47.20178,-4.1266),(.06229,47.43615,-4.05584),(0,47.4746,-4.04594),(0,47.47638,-4.01479),(.01337,47.46287,-3.9797),(.24869,47.58948,-3.72891),(.26001,47.53262,-3.75168),(.18383,47.48091,-3.84614),(.35675,47.89791,-3.49671),(.37797,47.8662,-3.49883),(.39983,47.9751,-3.44359),(.22949,47.66126,-3.6485),(.21919,48.00536,-3.4818),(.22611,47.87631,-3.53018),(.07084,47.50434,-3.8392),(.01323,47.61927,-3.75415),(.06286,47.63181,-3.62325),(.14103,47.66347,-3.58099),(.49616,47.90116,-3.38499),(.42148,48.00184,-3.39784),(.48451,47.8563,-3.38037),(.19025,47.62786,-3.11453),(.31381,47.64538,-3.1024),(.32953,47.68189,-3.17149),(0,47.62328,-3.12784),(0,47.59549,-3.0298),(.08932,47.59102,-3.06519),(.10139,47.5973,-3.07892),(.44842,47.42483,-3.30749),(.47409,47.35818,-3.40464),(.63371,47.28193,-3.63079),(.60335,47.14726,-3.62616),(.20258,46.7546,-3.91757),(.21085,46.7948,-3.93998),(.39026,46.89381,-2.97878),(.44487,46.88303,-2.99688),(.50109,46.87531,-2.91581),(.44169,47.32763,-3.23593),(.43803,47.24944,-3.50186),(.61375,47.06683,-3.5945),(.5823,47.08931,-3.67503),(.49197,46.99967,-3.5606),(.48864,47.0363,-3.56182),(.42811,47.03628,-3.56811),(.47936,46.98239,-3.57641),(.45553,47.06811,-3.54501),(.43076,47.13548,-3.53209),(.4234,47.07655,-3.55786),(.43075,46.96459,-3.5785),(.52865,46.91971,-3.58517),(.36796,46.86147,-3.64492),(.38427,47.07295,-3.57808),(.35961,47.03139,-3.59571),(.45902,47.04762,-3.26924),(.33802,46.89205,-3.16854),(.36784,47.15892,-3.5612),(.32188,47.27235,-3.35174),(.42444,47.2777,-3.34392),(.25647,47.16327,-3.64602),(.25582,47.03986,-3.69085),(.25269,47.37446,-3.49624),(.19564,47.37081,-3.56334),(.22183,47.26352,-3.59566),(.24626,47.34988,-3.32975),(.24641,47.44414,-3.33221),(.25061,47.46713,-3.4142),(.28123,47.56303,-3.39201),(.22596,47.63519,-3.4708),(.23073,47.47474,-3.48806),(.35233,47.71017,-3.32828),(.35569,47.77256,-3.38085),(.31358,47.73308,-3.41014),(.32285,47.65583,-3.35873),(.30204,47.60943,-3.37544),(.20672,47.6447,-3.22058),(.32706,47.67977,-3.19401),(.34287,47.67351,-3.25872),(.27388,47.25705,-3.28472),(.20428,47.23356,-3.24312),(.19545,47.33102,-3.25445),(.31936,47.00312,-3.21242),(.22304,46.99455,-3.22707),(.19328,47.63943,-3.21744),(.29909,47.63006,-3.28658),(.10288,47.23035,-3.21042),(.09965,47.32815,-3.20677),(.19396,47.4308,-3.24893),(.27162,47.53151,-3.31155),(.26808,47.68691,-3.44136),(.43384,47.2797,-3.43354),(.29939,47.26848,-3.52845),(.12322,46.90361,-3.77573),(0,46.78074,-3.86184),(.11408,46.81143,-3.82806),(.30961,46.86691,-3.653),(.37807,46.86965,-3.63162),(.39555,46.96364,-3.58998),(.36107,46.99753,-3.60057),(.52659,47.00178,-3.26177),(.57039,47.0114,-3.19968),(.52672,46.94648,-3.12239),(.53676,46.89932,-2.97717),(.46503,46.88531,-3.00499),(.49463,46.89854,-3.04994),(.66581,47.07229,-3.10472),(.61981,47.02387,-3.1251),(.62677,47.07482,-3.16854),(.62329,47.10149,-3.18579),(.66635,47.36281,-3.59305),(.72972,47.31281,-3.70337),(.69902,47.30928,-3.74603),(.79946,47.34371,-3.82277),(.83202,47.3192,-3.78476),(.5497,47.36205,-3.50041),(.60198,47.435,-3.46325),(.19631,47.64666,-3.20301),(.11118,47.64394,-3.13941),(.31061,48.02693,-3.42256),(.0029,47.68358,-3.67584),(0,47.68093,-3.71166),(.46087,47.89614,-3.45233),(.42341,48.0058,-3.40999),(.5166,47.74269,-3.51957),(.56671,47.73974,-3.47581),(.01207,47.54439,-3.83902),(.03967,47.27005,-4.15068),(.07948,47.19008,-4.11737),(.0952,47.28821,-4.02099),(.14554,47.18597,-3.98802),(.00684,46.79856,-4.34664),(.04835,46.42289,-4.52543),(.02155,46.39052,-4.54387),(.01549,46.14116,-4.3938),(.01893,46.14877,-4.31668),(.07638,46.64941,-4.25152),(.05045,46.56176,-4.35593),(.16955,46.7184,-4.02333),(.05364,46.31995,-4.21111),(.078,46.26961,-4.3357),(.34624,47.05288,-3.80032),(.3789,46.94993,-3.77227),(.61199,47.70225,-3.58685),(.37284,47.50066,-3.73149),(.60804,47.22828,-3.67697),(.72299,47.70081,-3.65572),(.81941,47.71784,-3.73763),(.73149,47.51523,-3.87003),(.64187,47.47987,-3.81223),(.7661,47.72628,-3.57765),(.87626,47.67701,-3.59569),(.11407,47.58818,-3.07249),(.19055,47.56994,-3.00196),(.19398,47.62026,-3.10068),(.28593,47.5714,-2.35309),(.38851,47.57659,-2.87369),(.46844,47.58138,-2.8602),(.45307,47.57899,-2.93665),(.39852,47.58598,-2.95253),(.38661,47.57735,-2.88196),(.09426,47.511,-2.19505),(0,47.49663,-2.18236),(0,47.45407,-2.17293),(.47642,47.57587,-2.86347),(.47315,47.19135,-2.80933),(.47649,47.20081,-2.85199),(.22768,47.0564,-2.23584),(.20252,47.1642,-2.26577),(.24306,46.86029,-2.20586),(.21215,46.89773,-2.28888),(.22236,46.95161,-2.9057),(.28262,46.94599,-2.90922),(.21319,46.95392,-2.98755),(.36573,46.89509,-2.80549),(.36664,46.89258,-2.5104),(.45134,46.87208,-2.52033),(.41439,46.88091,-2.40041),(.54291,46.9798,-2.82987),(.60744,46.95128,-2.91438),(.6551,47.05623,-2.997),(.49603,47.56097,-3.17122),(.48455,47.63689,-3.18775),(.48803,47.62169,-3.15603),(.65282,47.52182,-3.43837),(.66487,47.59949,-3.45336),(.87305,47.59747,-3.57126),(.78295,47.66491,-3.53397),(.87576,47.3553,-3.73676),(.94957,47.35294,-3.87582),(1.01065,47.71656,-3.80956),(.95078,47.75926,-3.82827),(1.10804,47.58361,-3.85268),(1.07958,47.61231,-3.84491),(1.06553,47.61435,-3.82565),(.9933,47.36643,-3.8263),(1.03628,47.37032,-3.93682),(.75733,47.40487,-3.87247),(.84751,47.43995,-3.98207),(.9097,47.38305,-3.91773),(1.06437,47.52184,-4.02098),(1.04195,47.61342,-4.00901),(1.12748,47.54847,-3.96907),(.87969,47.72421,-3.80977),(.54189,46.88603,-2.84913),(.47816,47.59083,-3.065),(.12768,47.25341,-3.65899),(.13201,47.15638,-3.68863),(.09837,47.58637,-3.05538),(.29619,47.56192,-2.89644),(.26576,47.56208,-2.88706),(.29139,47.56492,-2.87295),(.37646,47.57218,-2.88749),(.35262,47.58851,-2.68963),(.3758,47.58621,-2.78651),(.3611,47.58306,-2.78762),(1.01875,47.70509,-3.80621),(1.14993,47.45607,-3.83662),(.47825,47.55644,-2.94247),(.55316,46.89645,-2.84865),(.56162,46.88857,-2.85812),(.65971,47.04773,-3.00218),(.61822,47.11388,-3.18689),(.6749,47.10247,-3.09106),(.57174,46.89197,-2.86586),(.29856,46.86341,-3.66339),(.9304,47.41614,-3.68121),(.35272,47.58306,-3.69959),(.43059,47.69976,-3.5812),(.1052,47.75797,-3.58048),(.17546,47.82471,-3.50173),(.16953,47.56896,-3.56461),(.08233,47.54554,-3.61867),(.60553,46.98913,-3.54113),(.53771,47.78725,-3.41931),(.06246,47.73795,-3.65267),(.10153,47.74595,-3.59169),(0,47.61261,-3.74224),(.01157,47.68942,-3.72257),(.53153,47.74004,-3.52234),(.5334,47.73626,-3.53722),(.55933,47.08577,-3.53917),(.48376,46.93445,-3.21648),(.4608,47.28754,-2.8027),(.22696,46.95256,-2.99051),(.22157,46.95189,-2.99371),(.374,46.89108,-2.81927),(.03718,46.56289,-4.49467),(.43704,47.28205,-3.43325),(.43686,47.28914,-3.42476),(.43258,47.2823,-3.41891),(.0261,46.75874,-4.3201),(.02371,46.16725,-4.46119),(.44228,47.67231,-3.15965),(.48064,47.5594,-2.94853),(.47451,47.54793,-3.1823),(.4827,47.63787,-3.19417),(.49324,47.55687,-3.17587),(.49346,47.55624,-3.17523),(.43792,47.67148,-3.16595),(-.22304,46.99455,-3.22707),(-.31936,47.00312,-3.21242),(-.30441,47.10082,-3.24851),(-.19545,47.33102,-3.25445),(-.20672,47.6447,-3.22058),(-.25061,47.46713,-3.4142),(-.23073,47.47474,-3.48806),(-.24626,47.34988,-3.32975),(-.27312,47.36946,-3.42704),(-.24641,47.44414,-3.33221),(-.25582,47.03986,-3.69085),(-.42398,47.26958,-3.27135),(-.42444,47.2777,-3.34392),(-.33802,46.89205,-3.16854),(-.3892,46.9788,-3.2197),(-.44138,47.20206,-3.24662),(-.38404,47.08018,-3.26009),(-.45902,47.04762,-3.26924),(-.35961,47.03139,-3.59571),(-.38427,47.07295,-3.57808),(-.43075,46.96459,-3.5785),(-.5823,47.08931,-3.67503),(-.48173,47.14718,-3.52053),(-.49463,46.89854,-3.04994),(-.43933,46.88245,-3.11728),(-.42063,46.87734,-2.89007),(-.39026,46.89381,-2.97878),(-.41169,46.86564,-3.72367),(-.21085,46.7948,-3.93998),(-.43646,47.34711,-3.32882),(-.44842,47.42483,-3.30749),(-.47967,47.64035,-3.20177),(-.43072,47.67009,-3.17791),(-.42929,47.67821,-3.22969),(-.48451,47.8563,-3.38037),(-.49616,47.90116,-3.38499),(-.12128,47.70471,-3.58639),(-.07795,47.60734,-3.75041),(-.22611,47.87631,-3.53018),(-.26896,47.94999,-3.49269),(-.21919,48.00536,-3.4818),(-.2203,47.77285,-3.58543),(-.18383,47.48091,-3.84614),(-.26001,47.53262,-3.75168),(-.24869,47.58948,-3.72891),(-.06751,47.40137,-3.97421),(-.13599,47.34427,-3.95323),(-.0602,47.41022,-3.98369),(-.01337,47.46287,-3.9797),(-.01016,46.67614,-4.44095),(-.01794,46.30273,-4.19425),(-.01746,46.18745,-4.2662),(-.09982,46.46222,-4.14438),(-.07752,46.52871,-4.01794),(-.12207,46.56712,-4.05924),(-.27586,46.86209,-3.8643),(-.19436,46.88214,-3.99168),(-.50495,47.30461,-3.73049),(-.47106,47.41772,-3.74525),(-.39827,47.39028,-3.73834),(-.3219,47.9768,-3.46342),(-.31995,47.90236,-3.51008),(-.54892,47.5666,-3.76627),(-.5777,47.33763,-3.73556),(-.55257,47.44769,-3.76986),(-.7236,47.63147,-3.84924),(-.66694,47.6824,-3.72677),(-.27146,47.56902,-2.59804),(-.33357,47.57681,-2.59148),(-.27598,47.57027,-2.48207),(-.13633,47.55321,-2.38714),(-.1896,47.54618,-2.3088),(-.08601,47.52291,-2.23724),(-.44848,47.47782,-2.69339),(-.44265,47.37702,-2.69534),(-.40503,47.37199,-2.57975),(-.48036,47.40383,-2.89986),(-.10605,47.1699,-2.20765),(0,47.17058,-2.18528),(0,47.26387,-2.17521),(-.10769,47.26839,-2.21453),(-.45889,47.185,-2.73401),(-.43643,47.18043,-2.6721),(-.43725,47.28018,-2.68205),(-.24806,46.94222,-2.19438),(-.35209,46.94055,-2.29775),(-.36156,46.8782,-2.28892),(-.42388,46.89056,-2.39719),(-.42043,46.94057,-2.40586),(-.47094,46.93912,-2.52848),(-.29585,46.94028,-2.89363),(-.31228,46.91681,-2.81433),(-.11397,46.96464,-2.81373),(-.22526,46.9518,-2.81915),(-.22236,46.95161,-2.9057),(-.38943,46.88901,-2.61833),(-.32245,46.88968,-2.50207),(-.41481,46.89084,-2.73888),(-.51606,47.17308,-2.97174),(-.51463,47.11172,-2.87373),(-.64836,47.7201,-3.51698),(-.66053,47.66054,-3.47932),(-.53865,47.70681,-3.44656),(-.76686,47.51573,-3.5047),(-.86391,47.50531,-3.56397),(-.85202,47.73545,-3.66194),(-1.11991,47.38769,-3.82404),(-1.08743,47.46945,-3.74334),(-1.17326,47.51494,-3.89893),(-1.13691,47.41471,-3.89418),(-1.07729,47.69283,-3.95744),(-1.0868,47.6993,-3.91228),(-.89356,47.67845,-3.99553),(-.81696,47.74384,-3.87483),(-.39924,46.89405,-3.12778),(-.43046,46.88465,-3.12368),(-.43628,46.95824,-3.21989),(-.45385,47.44756,-3.0966),(-.46305,47.47684,-3.19599),(-.4454,47.40155,-3.21736),(-.45318,47.59671,-2.78624),(-.46712,47.58664,-2.79509),(-.44089,47.59484,-2.69537),(-.42506,47.66898,-3.16761),(-.39845,47.67504,-3.15786),(-.38661,47.57735,-2.88196),(-.38851,47.57659,-2.87369),(-.38255,47.63636,-3.08634),(-.37386,47.62859,-3.0747),(-1.08659,47.69323,-3.90036),(-1.08171,47.70446,-3.90678),(-1.16719,47.59236,-3.91859),(-1.08961,47.4822,-3.74896),(-.46844,47.58138,-2.8602),(-.58095,46.89661,-2.88223),(-.60604,46.95144,-2.99239),(-.5618,46.89824,-2.92525),(-.53389,46.88141,-2.90066),(-.54565,46.88417,-2.88194),(-.54013,46.88445,-2.90088),(-.31658,46.85983,-3.72478),(-.31733,46.87419,-3.74923),(-.4503,47.70566,-3.30969),(-.13816,47.89534,-3.50795),(-.21693,48.00335,-3.47362),(-.23554,47.91078,-3.45489),(-.21963,47.76093,-3.4744),(-.19329,47.58434,-3.2294),(-.4388,47.76358,-3.34558),(-.05178,47.35303,-4.10853),(-.08243,47.34853,-4.08695),(-.054,47.43305,-4.06824),(-1.1388,47.47511,-3.93796),(-1.07344,47.44759,-3.97573),(-.5758,46.92515,-3.65276),(-.62667,46.98342,-3.60993),(-.61281,47.01349,-3.64075),(-.5879,47.73649,-3.47199),(-.56547,47.73027,-3.45849),(-.14025,47.89869,-3.51635),(-.01207,47.54439,-3.83902),(-.23272,47.65096,-3.67116),(-.22949,47.66126,-3.6485),(-.16684,47.46979,-3.86703),(-.17551,47.46622,-3.86086),(-.20866,47.59449,-3.74546),(-.06484,47.41046,-3.97154),(-.44457,46.89037,-3.61134),(-.06706,46.17674,-4.30645),(-.08368,46.18626,-4.43574),(-.07831,46.28814,-4.49315),(-.51092,47.21938,-3.06941),(-.49405,47.24888,-3.15471),(-.48557,47.25447,-3.19788),(-.47002,47.49146,-2.98369),(-.46611,47.50953,-3.08331),(-.21446,47.10537,-3.23567),(-.41197,46.89077,-2.71642),(-.42082,46.88924,-2.72577),(-.3166,47.2871,-3.43679),(-.31186,46.85931,-3.66277),(-.04241,47.0204,-4.19434),(-.01167,46.96518,-4.26487),(-.47338,47.54244,-3.1784),(-.47028,47.51451,-3.08217),(-.42891,47.66929,-3.17178),(-.46489,47.57651,-2.94455),(-.46584,47.57508,-2.93681),(-.47135,47.54647,-3.18809),(-.47451,47.54793,-3.1823),(-.4821,47.55948,-2.9529),(-.49416,47.50977,-2.98056),(-.46188,47.57614,-2.93964),(-.49156,47.50417,-2.97864),(-.4698,47.49469,-2.97679),(-.49038,47.52254,-3.08001),(-.04857,46.4832,-4.45012),(-.29731,46.94266,-2.91524),(-.28262,46.94599,-2.90922),(-.47744,47.42799,-3.00398),(-.50117,47.14668,-3.2454),(-.56868,47.17155,-3.08003),(-.43865,46.89663,-3.60258),(-.16596,47.48179,-3.86631),(-.55867,46.97013,-3.67157),(-.48714,47.66173,-3.42348),(-.46048,47.80417,-3.37012),(-.32708,47.93429,-3.41204),(-.28535,47.46062,-3.77165),(-.2075,47.4126,-3.8509),(-.53121,46.88079,-2.89772),(-1.17182,47.52141,-3.89019),(-1.0323,47.5975,-3.71368),(-.17928,47.56327,-2.89421),(-.18715,47.56923,-2.97113),(-.26576,47.56208,-2.88706),(-.42745,47.60192,-2.68807),(-.45621,47.37519,-3.11769),(-.79792,47.6599,-3.9403),(-1.04333,47.73318,-3.90978),(-1.02077,47.7155,-3.82348),(-1.14986,47.4426,-3.8343),(-.96887,47.49785,-3.64305),(-.50528,47.59297,-3.39736),(-.1143,46.95107,-2.89703),(-.22079,46.95481,-2.97556),(-.12236,46.91117,-3.07859),(-.21319,46.95392,-2.98755),(-.32113,46.88215,-2.40309),(-.22307,46.90519,-2.38192),(-.46319,46.88098,-2.51804),(-.24706,46.86686,-2.19537),(-.44516,47.28231,-2.71981),(-.42694,47.47541,-2.57662),(-.19055,47.56994,-3.00196),(-.18342,47.55558,-2.49483),(-.1908,47.5591,-2.41575),(-.63319,47.59732,-3.8064),(-.43059,47.69976,-3.5812),(-.24947,46.95376,-3.90625),(-.02466,46.25874,-4.5013),(-.07587,47.20178,-4.1266),(-.06229,47.43615,-4.05584),(-.22179,47.58848,-3.73505),(-.31381,47.64538,-3.1024),(-.57174,46.89197,-2.86586),(-.56162,46.88857,-2.85812),(-.50109,46.87531,-2.91581),(-.46503,46.88531,-3.00499),(-.44169,47.32763,-3.23593),(.4734,47.50419,-2.9724),(.47002,47.49146,-2.98369),(.47351,47.49634,-2.98296),(.01746,46.18745,-4.2662),(.39994,46.89585,-3.74112),(.22079,46.95481,-2.97556),(.37252,47.14571,-3.56026),(.09609,47.30015,-4.01635),(.51612,47.72972,-3.54556),(.09259,47.34537,-4.07555),(.40411,47.78227,-3.33863),(.31831,47.6594,-3.63437),(.24478,46.90632,-3.73618),(.98411,47.68706,-3.71953),(.38364,47.58101,-2.9545),(.17145,47.57076,-2.98665),(.09174,47.57242,-2.9883),(.27312,47.36946,-3.42704),(.3187,46.91301,-3.04043),(.33502,46.8845,-3.15265),(.51552,46.86685,-2.7482),(.97735,47.7549,-3.90709),(.74867,47.71969,-3.80186),(1.16919,47.58825,-3.92925),(1.07649,47.36999,-3.88959),(.67072,47.37088,-3.78906),(.72106,47.42668,-3.53751),(.32113,46.88215,-2.40309),(.27303,46.88792,-2.34339),(.22307,46.90519,-2.38192),(.46712,47.58664,-2.79509),(.1112,47.44792,-2.19472),(.1908,47.5591,-2.38982),(.20837,47.56894,-2.98253),(.29922,47.58013,-2.96397),(.47637,47.15337,-3.72694),(.29381,47.00241,-3.85079),(.01864,46.50961,-4.01708),(.08007,46.36405,-4.23549),(.1276,46.63411,-4.09978),(.00718,46.92124,-4.28275),(0,46.92765,-4.2942),(.09707,47.10807,-4.08696),(.49137,47.80395,-3.48645),(.32708,47.93429,-3.41204),(.77434,47.35677,-3.65454),(.5169,46.87888,-2.93137),(.49532,46.93364,-3.21043),(0,46.87919,-3.82115),(.50117,47.14668,-3.2454),(.43646,47.34711,-3.32882),(.42063,46.87734,-2.89007),(.42929,47.67821,-3.22969),(.31422,48.03045,-3.433),(.2203,47.77285,-3.58543),(.29343,47.85517,-3.52685),(.22179,47.58848,-3.73505),(.13599,47.34427,-3.95323),(.06751,47.40137,-3.97421),(.09982,46.46222,-4.14438),(.54892,47.5666,-3.76627),(.55257,47.44769,-3.76986),(.27598,47.57027,-2.47878),(.18342,47.55558,-2.48878),(.17928,47.56327,-2.89421),(.33357,47.57681,-2.59148),(.27146,47.56902,-2.59804),(.08601,47.52291,-2.20669),(.44848,47.47782,-2.69339),(.43643,47.18043,-2.6721),(.35209,46.94055,-2.29775),(.42043,46.94057,-2.40586),(.22681,46.94308,-2.7169),(.5618,46.89824,-2.92525),(.51606,47.17308,-2.97174),(1.0868,47.6993,-3.91228),(.79792,47.6599,-3.9403),(.46305,47.47684,-3.19599),(.18715,47.56923,-2.97113),(1.08659,47.69323,-3.90036),(1.16719,47.59236,-3.91859),(.53389,46.88141,-2.90066),(.28535,47.46062,-3.77165),(.2075,47.4126,-3.8509),(.4388,47.76358,-3.34558),(.42891,47.66929,-3.17178),(.054,47.43305,-4.06824),(.55867,46.97013,-3.67157),(.56547,47.73027,-3.45849),(.5879,47.73649,-3.47199),(.29731,46.94266,-2.91524),(.04857,46.4832,-4.45012),(.46188,47.57614,-2.93964),(-.40444,47.72785,-3.29011),(-.37807,46.86965,-3.63162),(-.52659,47.00178,-3.26177),(-.62677,47.07482,-3.16854),(-.12322,46.90361,-3.77573),(-.39983,47.9751,-3.44359),(-.00718,46.92124,-4.28275),(-.08007,46.36405,-4.23549),(0,47.53761,-2.34999),(-.24306,46.86029,-2.20586),(-.54291,46.9798,-2.82987),(-1.01065,47.71656,-3.80956),(-.64187,47.47987,-3.81223),(-.84751,47.43995,-3.98207),(-1.04195,47.61342,-4.00901),(-.33502,46.8845,-3.15265),(-.3187,46.91301,-3.04043),(-.13201,47.15638,-3.68863),(-.29139,47.56492,-2.87295),(-.3611,47.58306,-2.78762),(-.3758,47.58621,-2.78651),(-.35262,47.58851,-2.68963),(-.4903,47.73691,-3.39999),(-1.01875,47.70509,-3.80621),(-.55316,46.89645,-2.84865),(-.65971,47.04773,-3.00218),(-.40411,47.78227,-3.33863),(-.16953,47.56896,-3.56461),(-.08233,47.54554,-3.61867),(-.53827,47.79071,-3.41729),(-.53771,47.78725,-3.41931),(-.48376,46.93445,-3.21648),(-.374,46.89108,-2.81927),(-.43704,47.28205,-3.43325),(-.4369,47.67146,-3.16416),(-.47351,47.49634,-2.98296),(-.46954,47.53795,-3.18251),(-.0924,46.92553,-4.1325),(-.04522,46.83861,-4.22943),(-.22157,46.95189,-2.99371),(-.22696,46.95256,-2.99051),(-.57256,47.09047,-3.24601),(-.51653,47.00638,-3.26955),(0,47.46294,-4.06189),(-.31422,48.03045,-3.433),(-.99509,47.4052,-3.98596),(-.51875,47.76712,-3.41161),(-.42737,47.71676,-3.29992),(-.10544,47.58262,-3.16416),(-.1041,47.52316,-3.17666),(-.2532,47.3026,-3.83124),(-.19273,47.24411,-3.91142),(-.31964,47.3442,-3.77319),(-.29343,47.85517,-3.52685),(-.28828,47.77487,-3.5608),(-.37797,47.8662,-3.49883),(-.52645,46.87541,-2.74556),(-.11725,46.88914,-3.18315),(0,46.88031,-3.13971),(-.11896,46.88195,-3.16847),(0,46.88818,-3.15549),(-.52042,47.77747,-3.40558),(-.31173,47.63686,-3.08936),(-.4203,47.57252,-2.58011),(-.40867,47.58161,-2.58274),(-.09426,47.511,-2.22761),(-.19732,47.53441,-2.29837),(-.30265,47.18487,-3.81993),(-.24259,47.13219,-3.88247),(-.50841,47.08453,-2.82037),(-.48894,47.07504,-2.73685),(-.81213,47.54403,-3.97598),(-.93847,47.46902,-4.03769),(-.90563,47.57476,-4.03395),(-.82574,47.42247,-3.59933),(-.47259,47.34639,-3.02836),(-.48368,47.27381,-3.05165),(-.52791,46.95071,-2.74587),(-.1124,46.96822,-2.71909),(-.23388,46.91087,-3.07367),(0,46.95132,-2.60484),(-.11396,46.95016,-2.60561),(0,46.97588,-2.71264),(-.11625,46.93276,-2.48824),(-.11012,46.91896,-2.36892),(-.22522,46.91592,-2.49727),(-.09786,46.89368,-2.24775),(0,46.85673,-2.14566),(-.11308,46.8594,-2.15248),(0,46.88872,-2.2508),(-.38464,47.06549,-2.43682),(-.3189,47.05867,-2.32525),(-.3606,47.1751,-2.45134),(-.29222,47.16874,-2.34791),(-.40125,47.2758,-2.57492),(-.4029,47.17756,-2.56517),(-.20459,47.2677,-2.26927),(-.20252,47.1642,-2.26577),(-.35447,47.27221,-2.45663),(-.28716,47.36572,-2.3574),(-.35208,47.36962,-2.46388),(-.29093,47.26942,-2.35087),(-.1112,47.44792,-2.22587),(-.21195,47.45414,-2.28577),(-.37551,47.4692,-2.45387),(0,47.36626,-2.18601),(-.10576,47.36158,-2.23088),(-.35019,47.58227,-2.46607),(0,47.50995,-2.19712),(-.27529,47.57217,-2.69518),(-.18008,47.55625,-2.60359),(-.17772,47.56202,-2.79801),(-.08756,47.5661,-2.89451),(-.08399,47.55796,-2.79763),(-.08419,47.54335,-2.50452),(-.0821,47.55331,-2.70022),(0,47.55804,-2.79969),(0,47.54937,-2.70309),(-.36252,47.22866,-3.7718),(-.13552,47.00339,-4.04354),(-.19183,47.07873,-3.9495),(-.1276,46.63411,-4.09978),(-.16955,46.7184,-4.02333),(-.10517,46.54713,-4.19179),(-.10253,46.72895,-4.16016),(-.08038,46.4618,-4.28715),(-.06625,46.3764,-4.38806),(-.27342,47.82097,-3.43471),(-.46349,46.92604,-3.70377),(-.44109,46.99283,-3.73441),(-.2338,46.88815,-3.17452),(-.5169,46.87888,-2.93137),(-.53676,46.89932,-2.97717),(-.597,47.04886,-3.19148),(-.47452,46.89315,-3.68862),(-.25269,47.37446,-3.49624),(0,47.14464,-3.7515),(-.13181,47.03545,-3.72541),(0,47.02085,-3.78777),(-.09871,47.45788,-3.61877),(0,47.43933,-3.65046),(-.10624,47.11344,-3.21292),(0,46.99276,-3.19292),(-.11056,46.99061,-3.21772),(0,47.11185,-3.1938),(0,47.43434,-3.17693),(0,47.5291,-3.15878),(-.10104,47.4262,-3.19404),(.49302,47.52748,-3.07886),(.47452,46.89315,-3.68862),(.46349,46.92604,-3.70377),(1.17182,47.52141,-3.89019),(.51875,47.76712,-3.41161),(.52042,47.77747,-3.40558),(.40444,47.72785,-3.29011),(.42737,47.71676,-3.29992),(.2532,47.3026,-3.83124),(.36252,47.22866,-3.7718),(.30265,47.18487,-3.81993),(.31964,47.3442,-3.77319),(.28828,47.77487,-3.5608),(.41884,47.70922,-3.56142),(.31054,47.67078,-3.61384),(.40637,47.79674,-3.52439),(.51653,47.00638,-3.26955),(0,46.86444,-2.13373),(.11308,46.8594,-2.15248),(.11585,46.8665,-2.14043),(.50174,46.86645,-2.63087),(.49072,46.85837,-2.63324),(.52645,46.87541,-2.74556),(.23288,46.89617,-3.19025),(.11896,46.88195,-3.16847),(.11725,46.88914,-3.18315),(.2338,46.88815,-3.17452),(.45318,47.59671,-2.78624),(.38537,47.57723,-2.86631),(.37407,47.57639,-2.86383),(.10662,47.63709,-3.15244),(.36537,47.57362,-2.46582),(.40867,47.58161,-2.58274),(.35019,47.58227,-2.46533),(.4203,47.57252,-2.58011),(.10776,47.35896,-3.62035),(.10104,47.4262,-3.19404),(.93847,47.46902,-4.03769),(.81213,47.54403,-3.97598),(1.10742,47.53746,-3.83101),(1.11319,47.5572,-3.84599),(1.06465,47.5814,-3.78331),(.82574,47.42247,-3.59933),(.46954,47.53795,-3.18251),(.48368,47.27381,-3.05165),(.4869,47.23715,-2.94694),(.47259,47.34639,-3.02836),(.50841,47.08453,-2.82037),(.11396,46.95016,-2.60561),(.1124,46.96822,-2.71909),(.226,46.93765,-2.60871),(0,46.95644,-2.89056),(0,46.94024,-2.48639),(.11625,46.93276,-2.48824),(.22522,46.91592,-2.49727),(.09786,46.89368,-2.24775),(0,46.91519,-2.36473),(.11012,46.91896,-2.36892),(.50578,46.94249,-2.63953),(.52791,46.95071,-2.74587),(.46977,47.07063,-2.65519),(.48894,47.07504,-2.73685),(.3189,47.05867,-2.32525),(.29222,47.16874,-2.34791),(.20459,47.2677,-2.26754),(.29093,47.26942,-2.35087),(.28716,47.36572,-2.35468),(.20241,47.3624,-2.27117),(.30798,47.46329,-2.33756),(.35208,47.36962,-2.46388),(.37551,47.4692,-2.45387),(.44089,47.59484,-2.69537),(.19732,47.53441,-2.25012),(.29613,47.56104,-2.34469),(.21195,47.45414,-2.24846),(.28447,47.56917,-2.79191),(.27529,47.57217,-2.69518),(.31173,47.63686,-3.08936),(.17772,47.56202,-2.79801),(.17605,47.56142,-2.69809),(.18008,47.55625,-2.60359),(.08756,47.5661,-2.89451),(.08419,47.54335,-2.49971),(.08259,47.54694,-2.61056),(.08491,47.54717,-2.41857),(0,47.54401,-2.50732),(0,47.56842,-2.89209),(.08399,47.55796,-2.79763),(.40725,47.10427,-3.75593),(.1502,46.80793,-4.07066),(.10253,46.72895,-4.16016),(.06625,46.3764,-4.38806),(.08038,46.4618,-4.28715),(0,46.16481,-4.46225),(.27342,47.82097,-3.43471),(.44109,46.99283,-3.73441),(.52908,47.04778,-3.70387),(.57826,46.95013,-3.05199),(.13181,47.03545,-3.72541),(0,47.22914,-3.71857),(.18275,47.4707,-3.55768),(.09871,47.45788,-3.61877),(.10624,47.11344,-3.21292),(0,47.23028,-3.18751),(.10544,47.58262,-3.16416),(0,47.33396,-3.18005),(.11056,46.99061,-3.21772),(0,47.33986,-3.66142),(.57256,47.09047,-3.24601),(.19183,47.07873,-3.9495),(.13552,47.00339,-4.04354),(.10517,46.54713,-4.19179),(.0924,46.92553,-4.1325),(.24259,47.13219,-3.88247),(.0821,47.55331,-2.70022),(.10576,47.36158,-2.21202),(.35447,47.27221,-2.45663),(.3606,47.1751,-2.45134),(.38464,47.06549,-2.43682),(0,46.97228,-2.80444),(1.08859,47.53903,-3.79463),(.90563,47.57476,-4.03395),(0,47.61538,-3.14156),(.57968,47.08013,-3.24024),(.597,47.04886,-3.19148),(.04522,46.83861,-4.22943),(-.10662,47.63709,-3.15244),(-.18275,47.4707,-3.55768),(-.57968,47.08013,-3.24024),(-.52908,47.04778,-3.70387),(-.1502,46.80793,-4.07066),(-.40725,47.10427,-3.75593),(-.08259,47.54694,-2.61056),(-.17605,47.56142,-2.69809),(-.28593,47.5714,-2.37706),(-.30798,47.46329,-2.35065),(-.29613,47.56104,-2.36795),(-.20241,47.3624,-2.28804),(-.22768,47.0564,-2.23584),(-.46977,47.07063,-2.65519),(-.50578,46.94249,-2.63953),(-.50174,46.86645,-2.63087),(-1.06465,47.5814,-3.78331),(-.46069,47.30096,-3.13913),(-.38537,47.57723,-2.86631),(-.11585,46.8665,-2.14043),(-.31054,47.67078,-3.61384),(-.49302,47.52748,-3.07886),(0,47.57224,-3.15022),(-.19564,47.37081,-3.56334),(-.49072,46.85837,-2.63324),(-.23288,46.89617,-3.19025),(-.37407,47.57639,-2.86383),(-.36537,47.57362,-2.46603),(-.10776,47.35896,-3.62035),(-1.08859,47.53903,-3.79463),(0,46.94257,-2.13127),(-.12262,46.94404,-2.13456),(-.43512,47.06852,-2.54689),(-.1108,47.04975,-2.18381),(-.28447,47.56917,-2.79191),(0,47.54806,-2.60936),(0,47.57869,-2.97075),(-.35675,47.89791,-3.49671),(-.57826,46.95013,-3.05199),(.1041,47.52316,-3.17666),(.19273,47.24411,-3.91142),(.42745,47.60192,-2.68807),(.46069,47.30096,-3.13913),(.12262,46.94404,-2.13456),(.43512,47.06852,-2.54689),(.4029,47.17756,-2.56517),(.40125,47.2758,-2.57492),(.10769,47.26839,-2.20874)]))),
        Shape(DEF='t7disc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(.9843,.949,.7843),emissiveColor=(0.6,0.6,0.6),shininess=0.050,specularColor=(.9647,.949,.9098))),
          geometry=IndexedFaceSet(DEF='t7disc_Geo',coordIndex=[0,1,2,-1,2,3,0,-1,4,5,6,-1,7,8,9,-1,7,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,5,22,-1,23,24,19,-1,25,26,27,-1,27,28,29,-1,30,31,32,-1,31,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,74,87,-1,88,89,90,-1,91,92,93,-1,94,95,96,-1,97,98,99,-1,100,101,93,-1,102,103,95,-1,104,105,106,-1,106,107,104,-1,108,109,110,-1,111,112,113,-1,114,115,112,-1,116,117,118,-1,119,120,121,-1,66,122,123,-1,124,125,126,-1,91,105,104,-1,102,127,106,-1,101,128,106,-1,99,129,130,-1,131,132,133,-1,134,131,135,-1,100,131,134,-1,136,137,79,-1,80,138,81,-1,137,139,140,-1,141,90,142,-1,143,85,84,-1,144,145,146,-1,147,148,149,-1,83,77,147,-1,86,150,151,-1,152,153,154,-1,64,63,155,-1,156,51,50,-1,157,126,125,-1,158,117,159,-1,160,161,162,-1,49,48,62,-1,163,164,165,-1,166,167,168,-1,41,32,169,-1,39,38,26,-1,170,171,28,-1,41,172,32,-1,173,174,35,-1,175,176,177,-1,178,179,180,-1,4,181,17,-1,2,182,183,-1,184,185,186,-1,13,187,188,-1,189,13,12,-1,2,1,9,-1,182,2,8,-1,8,6,5,-1,108,1,0,-1,189,190,191,-1,190,192,193,-1,194,191,190,-1,58,195,196,-1,197,198,199,-1,164,200,201,-1,202,54,53,-1,202,203,54,-1,164,163,200,-1,204,197,199,-1,58,196,205,-1,194,190,193,-1,189,191,187,-1,108,0,109,-1,21,8,5,-1,8,7,6,-1,2,9,8,-1,7,206,10,-1,7,207,206,-1,23,181,11,-1,13,189,187,-1,183,3,2,-1,208,4,17,-1,171,175,177,-1,178,209,43,-1,26,25,210,-1,170,28,179,-1,39,26,210,-1,41,169,211,-1,168,212,166,-1,163,165,46,-1,62,50,49,-1,213,214,215,-1,125,216,157,-1,156,50,64,-1,155,216,64,-1,153,65,154,-1,148,84,149,-1,147,149,83,-1,147,217,148,-1,144,89,145,-1,84,218,143,-1,148,74,84,-1,140,82,137,-1,136,139,137,-1,100,134,219,-1,107,220,104,-1,135,221,134,-1,131,133,135,-1,129,222,130,-1,101,106,105,-1,102,106,223,-1,127,224,107,-1,103,110,225,-1,113,98,111,-1,126,226,124,-1,123,67,66,-1,68,119,121,-1,116,118,227,-1,114,112,111,-1,110,103,108,-1,106,127,107,-1,95,224,102,-1,224,127,102,-1,98,129,99,-1,99,228,97,-1,229,230,231,-1,94,224,95,-1,92,132,93,-1,138,232,81,-1,138,150,233,-1,79,78,136,-1,83,149,84,-1,82,234,80,-1,79,147,77,-1,74,86,75,-1,235,71,73,-1,70,119,68,-1,67,154,65,-1,62,64,50,-1,236,85,237,-1,53,55,238,-1,52,49,50,-1,47,49,238,-1,46,165,44,-1,30,239,31,-1,38,40,239,-1,35,37,240,-1,31,215,33,-1,241,242,174,-1,27,29,243,-1,170,179,178,-1,243,25,27,-1,19,15,23,-1,13,244,14,-1,11,6,7,-1,9,207,7,-1,8,21,182,-1,3,245,0,-1,192,190,189,-1,166,56,167,-1,57,56,166,-1,201,246,164,-1,246,201,247,-1,199,248,204,-1,248,199,249,-1,250,167,56,-1,251,167,250,-1,0,252,253,-1,0,245,252,-1,17,196,208,-1,16,196,17,-1,254,255,256,-1,257,255,254,-1,192,12,258,-1,192,189,12,-1,259,260,261,-1,260,259,262,-1,108,9,1,-1,263,9,108,-1,259,10,206,-1,10,259,264,-1,23,244,24,-1,11,244,23,-1,11,14,244,-1,209,41,43,-1,41,209,172,-1,42,265,43,-1,265,42,266,-1,267,268,240,-1,269,268,267,-1,41,270,42,-1,211,270,41,-1,34,32,31,-1,34,169,32,-1,211,241,271,-1,169,241,211,-1,30,38,239,-1,272,38,30,-1,272,26,38,-1,272,273,26,-1,274,275,276,-1,275,274,277,-1,278,214,279,-1,280,214,278,-1,281,168,282,-1,281,212,168,-1,251,168,167,-1,251,283,168,-1,204,284,278,-1,204,248,284,-1,274,164,246,-1,164,274,165,-1,203,185,285,-1,203,186,185,-1,286,20,198,-1,286,18,20,-1,187,200,287,-1,200,187,191,-1,44,288,45,-1,44,36,288,-1,289,215,40,-1,289,213,215,-1,25,290,291,-1,290,25,243,-1,292,62,176,-1,63,62,292,-1,293,78,294,-1,293,136,78,-1,85,295,237,-1,295,85,143,-1,144,296,153,-1,296,144,146,-1,297,298,299,-1,300,298,297,-1,228,301,97,-1,302,301,228,-1,303,135,118,-1,303,304,135,-1,230,124,226,-1,124,230,305,-1,306,157,307,-1,306,126,157,-1,216,308,157,-1,155,308,216,-1,309,310,311,-1,309,312,310,-1,307,294,72,-1,293,294,307,-1,236,69,313,-1,236,237,69,-1,310,152,154,-1,162,152,310,-1,314,299,315,-1,297,299,314,-1,87,316,233,-1,87,217,316,-1,82,232,137,-1,82,81,232,-1,145,317,146,-1,145,267,317,-1,218,161,143,-1,218,142,161,-1,88,145,89,-1,145,88,318,-1,151,319,320,-1,151,266,319,-1,176,234,292,-1,175,234,176,-1,232,233,316,-1,232,138,233,-1,107,94,220,-1,107,224,94,-1,133,118,135,-1,133,227,118,-1,321,101,222,-1,321,128,101,-1,223,128,322,-1,223,106,128,-1,94,225,229,-1,96,225,94,-1,262,322,323,-1,262,324,322,-1,112,325,113,-1,325,112,326,-1,229,305,230,-1,225,305,229,-1,327,126,306,-1,327,226,126,-1,302,311,301,-1,309,311,302,-1,158,71,235,-1,158,159,71,-1,315,122,66,-1,315,299,122,-1,309,120,119,-1,309,302,120,-1,235,303,158,-1,235,328,303,-1,305,110,329,-1,110,305,225,-1,227,132,92,-1,227,133,132,-1,326,254,325,-1,326,257,254,-1,129,113,330,-1,113,129,98,-1,260,323,331,-1,260,262,323,-1,102,108,103,-1,102,263,108,-1,225,95,103,-1,225,96,95,-1,128,323,322,-1,128,321,323,-1,130,100,219,-1,130,101,100,-1,130,222,101,-1,101,91,93,-1,101,105,91,-1,91,220,92,-1,91,104,220,-1,319,332,320,-1,319,333,332,-1,334,318,88,-1,318,334,332,-1,74,217,87,-1,217,74,148,-1,142,335,161,-1,142,90,335,-1,292,82,140,-1,82,292,234,-1,79,217,147,-1,217,79,316,-1,275,336,296,-1,275,277,336,-1,237,70,69,-1,237,295,70,-1,73,294,337,-1,294,73,72,-1,73,328,235,-1,328,73,338,-1,312,119,70,-1,309,119,312,-1,66,336,315,-1,66,65,336,-1,231,226,327,-1,226,231,230,-1,221,304,121,-1,304,221,135,-1,123,97,301,-1,123,114,97,-1,335,153,152,-1,153,335,144,-1,85,339,83,-1,236,339,85,-1,308,136,293,-1,308,139,136,-1,62,177,176,-1,62,48,177,-1,210,291,281,-1,291,210,25,-1,280,215,214,-1,280,33,215,-1,276,36,44,-1,276,37,36,-1,340,297,247,-1,340,300,297,-1,287,188,187,-1,287,249,188,-1,18,250,205,-1,286,250,18,-1,202,186,203,-1,202,252,186,-1,55,341,342,-1,54,341,55,-1,290,238,55,-1,290,47,238,-1,343,248,344,-1,248,343,284,-1,251,345,283,-1,251,346,345,-1,283,282,168,-1,289,282,283,-1,280,284,59,-1,280,278,284,-1,276,165,274,-1,276,44,165,-1,43,347,178,-1,43,265,347,-1,273,27,26,-1,273,180,27,-1,241,173,271,-1,241,174,173,-1,36,174,288,-1,174,36,35,-1,40,31,239,-1,40,215,31,-1,240,173,35,-1,240,268,173,-1,319,42,270,-1,266,42,319,-1,23,17,181,-1,15,17,23,-1,348,24,244,-1,348,19,24,-1,348,20,19,-1,261,264,259,-1,264,261,258,-1,208,195,22,-1,195,208,196,-1,263,207,9,-1,349,207,263,-1,256,193,192,-1,256,255,193,-1,252,184,186,-1,252,245,184,-1,54,285,341,-1,203,285,54,-1,344,249,287,-1,344,248,249,-1,350,52,51,-1,350,351,52,-1,346,250,286,-1,346,251,250,-1,253,109,0,-1,253,352,109,-1,255,300,340,-1,300,255,257,-1,192,261,256,-1,258,261,192,-1,206,262,259,-1,262,206,324,-1,245,183,184,-1,245,3,183,-1,11,264,14,-1,264,11,10,-1,205,16,18,-1,196,16,205,-1,183,21,22,-1,182,21,183,-1,209,180,273,-1,180,209,178,-1,268,333,353,-1,333,268,269,-1,270,271,353,-1,271,270,211,-1,242,169,34,-1,242,241,169,-1,61,34,33,-1,34,61,242,-1,317,240,37,-1,240,317,267,-1,180,28,27,-1,179,28,180,-1,273,172,209,-1,272,172,273,-1,247,314,246,-1,247,297,314,-1,45,343,46,-1,45,60,343,-1,279,213,345,-1,214,213,279,-1,281,342,212,-1,281,291,342,-1,204,279,197,-1,204,278,279,-1,246,277,274,-1,246,314,277,-1,238,52,53,-1,52,238,49,-1,351,352,253,-1,351,350,352,-1,285,58,57,-1,285,185,58,-1,199,20,348,-1,199,198,20,-1,191,201,200,-1,201,191,194,-1,61,45,288,-1,60,45,61,-1,282,40,39,-1,282,289,40,-1,243,47,290,-1,47,243,29,-1,155,292,140,-1,155,63,292,-1,337,78,77,-1,337,294,78,-1,143,160,295,-1,160,143,161,-1,146,275,296,-1,146,317,275,-1,299,115,122,-1,299,298,115,-1,354,302,228,-1,120,302,354,-1,118,158,303,-1,158,118,117,-1,329,124,305,-1,355,124,329,-1,307,308,293,-1,308,307,157,-1,154,311,310,-1,67,311,154,-1,313,68,356,-1,68,313,69,-1,307,71,306,-1,71,307,72,-1,236,338,339,-1,236,313,338,-1,312,162,310,-1,160,162,312,-1,80,347,138,-1,80,357,347,-1,234,357,80,-1,234,175,357,-1,141,75,334,-1,141,76,75,-1,74,218,84,-1,76,218,74,-1,320,86,151,-1,320,75,86,-1,318,267,145,-1,318,269,267,-1,265,151,150,-1,265,266,151,-1,86,233,150,-1,86,87,233,-1,228,130,354,-1,99,130,228,-1,330,222,129,-1,330,321,222,-1,220,229,116,-1,94,229,220,-1,322,349,223,-1,322,324,349,-1,325,260,331,-1,325,254,260,-1,298,112,115,-1,298,326,112,-1,231,116,229,-1,231,117,116,-1,306,159,327,-1,159,306,71,-1,356,121,304,-1,356,68,121,-1,67,301,311,-1,67,123,301,-1,355,125,124,-1,355,156,125,-1,156,350,51,-1,355,350,156,-1,303,356,304,-1,328,356,303,-1,109,329,110,-1,352,329,109,-1,300,326,298,-1,300,257,326,-1,331,113,325,-1,331,330,113,-1,98,114,111,-1,98,97,114,-1,223,263,102,-1,223,349,263,-1,116,92,220,-1,116,227,92,-1,321,331,323,-1,321,330,331,-1,219,354,130,-1,134,354,219,-1,221,354,134,-1,132,100,93,-1,132,131,100,-1,333,318,332,-1,333,269,318,-1,334,320,332,-1,334,75,320,-1,76,142,218,-1,141,142,76,-1,90,144,335,-1,90,89,144,-1,88,141,334,-1,90,141,88,-1,137,316,79,-1,232,316,137,-1,347,150,138,-1,150,347,265,-1,65,296,336,-1,153,296,65,-1,312,295,160,-1,295,312,70,-1,337,338,73,-1,337,339,338,-1,313,328,338,-1,356,328,313,-1,277,315,336,-1,314,315,277,-1,156,216,125,-1,156,64,216,-1,352,355,329,-1,350,355,352,-1,117,327,159,-1,327,117,231,-1,221,120,354,-1,121,120,221,-1,122,114,123,-1,122,115,114,-1,152,161,335,-1,152,162,161,-1,83,337,77,-1,339,337,83,-1,155,139,308,-1,155,140,139,-1,177,47,29,-1,48,47,177,-1,210,282,39,-1,281,282,210,-1,59,33,280,-1,59,61,33,-1,275,37,276,-1,317,37,275,-1,194,247,201,-1,247,194,340,-1,249,348,188,-1,249,199,348,-1,56,205,250,-1,56,58,205,-1,202,253,252,-1,202,351,253,-1,290,342,291,-1,290,55,342,-1,344,46,343,-1,344,163,46,-1,197,345,346,-1,197,279,345,-1,166,342,341,-1,166,212,342,-1,283,213,289,-1,213,283,345,-1,60,284,343,-1,60,59,284,-1,347,170,178,-1,170,347,357,-1,357,171,170,-1,171,357,175,-1,28,177,29,-1,28,171,177,-1,288,242,61,-1,242,288,174,-1,272,32,172,-1,272,30,32,-1,268,271,173,-1,268,353,271,-1,353,319,270,-1,319,353,333,-1,22,4,208,-1,5,4,22,-1,4,11,181,-1,6,11,4,-1,16,19,18,-1,16,15,19,-1,244,188,348,-1,244,13,188,-1,14,258,12,-1,258,14,264,-1,184,22,195,-1,184,183,22,-1,349,206,207,-1,324,206,349,-1,260,256,261,-1,254,256,260,-1,193,340,194,-1,340,193,255,-1,195,185,184,-1,185,195,58,-1,57,341,285,-1,57,166,341,-1,198,346,286,-1,197,346,198,-1,287,163,344,-1,163,287,200,-1,53,351,202,-1,351,53,52,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='t7disc_Coord',point=[(.12236,46.91117,-3.07859),(.11966,46.93598,-2.99444),(.21319,46.95392,-2.98755),(.22157,46.95189,-2.99371),(.36005,46.89646,-2.81312),(.29585,46.94028,-2.89363),(.31228,46.91681,-2.81433),(.22526,46.9518,-2.81915),(.22236,46.95161,-2.9057),(.1143,46.95107,-2.89703),(.22681,46.94308,-2.7169),(.31964,46.92654,-2.72163),(.32245,46.88968,-2.50207),(.36664,46.89258,-2.5104),(.32156,46.90868,-2.61241),(.41481,46.89084,-2.73888),(.42099,46.89045,-2.82378),(.37739,46.89204,-2.81449),(.50748,46.88729,-2.84198),(.42082,46.88924,-2.72577),(.50817,46.8686,-2.74899),(.28262,46.94599,-2.90922),(.29731,46.94266,-2.91524),(.40612,46.8938,-2.72389),(.41197,46.89077,-2.71642),(.39189,46.76575,-3.09731),(.29904,46.67749,-2.97719),(.2107,46.69204,-3.07759),(.15773,46.72259,-3.099),(.21875,46.78796,-3.1705),(.38041,46.6761,-2.84483),(.4373,46.69054,-2.77725),(.35143,46.68512,-2.78605),(.49164,46.72759,-2.63773),(.4212,46.71987,-2.63747),(.2768,46.72136,-2.31647),(.28277,46.73641,-2.23274),(.16047,46.72673,-2.17251),(.34529,46.67767,-2.91947),(.44158,46.71892,-3.00478),(.4737,46.70667,-2.9464),(.26496,46.68827,-2.78757),(.15749,46.68453,-2.79388),(.16091,46.69059,-2.89269),(.28843,46.74502,-2.22433),(.39406,46.74851,-2.35301),(.39092,46.78331,-2.32473),(.21693,46.80108,-3.17797),(.1246,46.79657,-3.15712),(.12217,46.82068,-3.16625),(0,46.80618,-3.15341),(0,46.84366,-3.14958),(.12006,46.85222,-3.16877),(.2285,46.85724,-3.18438),(.33237,46.8609,-3.16643),(.32673,46.83597,-3.17143),(.44665,46.87597,-2.9984),(.44626,46.87658,-3.00163),(.43861,46.8841,-2.99283),(.45468,46.74473,-2.48442),(.45267,46.74476,-2.47816),(.4459,46.73573,-2.4863),(0,46.7752,-3.15124),(-.1246,46.79657,-3.15712),(-.12217,46.82068,-3.16625),(-.28068,46.77912,-2.20686),(-.26539,46.8197,-2.19964),(-.37767,46.82559,-2.30391),(-.52715,46.81904,-2.75792),(-.52448,46.77241,-2.76932),(-.5102,46.77309,-2.63195),(-.45391,46.84125,-3.02765),(-.44552,46.79808,-3.04887),(-.45951,46.77624,-3.01166),(-.35143,46.68512,-2.78605),(-.26605,46.69029,-2.65762),(-.34723,46.70588,-2.64446),(-.44158,46.71892,-3.00478),(-.41316,46.7507,-3.05793),(-.29904,46.67749,-2.97719),(-.13482,46.71721,-3.08064),(-.15074,46.71144,-3.08176),(-.15773,46.72259,-3.099),(-.4737,46.70667,-2.9464),(-.4373,46.69054,-2.77725),(-.50078,46.72326,-2.78087),(-.26496,46.68827,-2.78757),(-.29772,46.68138,-2.85402),(-.26747,46.71219,-2.38992),(-.2768,46.72136,-2.31647),(-.34132,46.72638,-2.39119),(-.36005,46.89646,-2.81312),(-.374,46.89108,-2.81927),(-.36573,46.89509,-2.80549),(-.22696,46.95256,-2.99051),(-.21319,46.95392,-2.98755),(-.22157,46.95189,-2.99371),(-.40754,46.88188,-2.40385),(-.32113,46.88215,-2.40309),(-.36664,46.89258,-2.5104),(-.40612,46.8938,-2.72389),(-.31964,46.92654,-2.72163),(-.1143,46.95107,-2.89703),(-.11966,46.93598,-2.99444),(-.29585,46.94028,-2.89363),(-.31228,46.91681,-2.81433),(-.22526,46.9518,-2.81915),(-.28262,46.94599,-2.90922),(0,46.93925,-2.97889),(0,46.90014,-3.05906),(-.12236,46.91117,-3.07859),(-.27303,46.88792,-2.34339),(-.21215,46.89773,-2.28888),(-.22307,46.90519,-2.38192),(-.34723,46.87081,-2.29731),(-.24049,46.8634,-2.21275),(-.39026,46.89381,-2.97878),(-.43861,46.8841,-2.99283),(-.49395,46.87549,-2.91354),(-.50738,46.81603,-2.63041),(-.49346,46.85139,-2.63278),(-.51724,46.85976,-2.74965),(-.24432,46.85303,-2.20369),(-.35552,46.86198,-2.29204),(-.2326,46.88118,-3.17675),(-.2285,46.85724,-3.18438),(-.33237,46.8609,-3.16643),(-.22236,46.95161,-2.9057),(-.22681,46.94308,-2.7169),(-.32245,46.88968,-2.50207),(-.38943,46.88901,-2.61833),(-.41481,46.89084,-2.73888),(-.37739,46.89204,-2.81449),(-.42099,46.89045,-2.82378),(-.42082,46.88924,-2.72577),(-.50748,46.88729,-2.84198),(-.39189,46.76575,-3.09731),(-.2107,46.69204,-3.07759),(-.16373,46.6982,-3.0021),(-.31573,46.80412,-3.16173),(-.21875,46.78796,-3.1705),(-.34864,46.71529,-2.51636),(-.40113,46.72388,-2.50689),(-.49164,46.72759,-2.63773),(-.28277,46.73641,-2.23274),(-.15391,46.72557,-2.27375),(-.16047,46.72673,-2.17251),(-.34529,46.67767,-2.91947),(-.38041,46.6761,-2.84483),(-.39154,46.67785,-2.8616),(-.16091,46.69059,-2.89269),(-.15749,46.68453,-2.79388),(-.39406,46.74851,-2.35301),(-.28843,46.74502,-2.22433),(-.39092,46.78331,-2.32473),(-.21693,46.80108,-3.17797),(-.12006,46.85222,-3.16877),(-.32673,46.83597,-3.17143),(-.44665,46.87597,-2.9984),(-.44626,46.87658,-3.00163),(-.45468,46.74473,-2.48442),(-.4459,46.73573,-2.4863),(-.45267,46.74476,-2.47816),(.37767,46.82559,-2.30391),(.26539,46.8197,-2.19964),(.28068,46.77912,-2.20686),(.45391,46.84125,-3.02765),(.45826,46.8302,-3.00825),(.45951,46.77624,-3.01166),(.34723,46.70588,-2.64446),(.13482,46.71721,-3.08064),(.12807,46.72987,-3.10265),(.29772,46.68138,-2.85402),(.26747,46.71219,-2.38992),(.34132,46.72638,-2.39119),(0,46.73527,-3.11278),(0,46.76264,-3.14469),(.12559,46.78354,-3.14929),(.16373,46.6982,-3.0021),(.15074,46.71144,-3.08176),(.19788,46.68286,-3.06423),(.36573,46.89509,-2.80549),(.22079,46.95481,-2.97556),(.22696,46.95256,-2.99051),(.3187,46.91301,-3.04043),(.38382,46.89066,-3.10231),(.33187,46.88644,-3.14573),(.40754,46.88188,-2.40385),(.44442,46.87353,-2.52318),(.32113,46.88215,-2.40309),(.27303,46.88792,-2.34339),(.34723,46.87081,-2.29731),(.22307,46.90519,-2.38192),(.21215,46.89773,-2.28888),(.24049,46.8634,-2.21275),(.39026,46.89381,-2.97878),(.42063,46.87734,-2.89007),(.52715,46.81904,-2.75792),(.51724,46.85976,-2.74965),(.49346,46.85139,-2.63278),(.35552,46.86198,-2.29204),(.24432,46.85303,-2.20369),(.2326,46.88118,-3.17675),(.3364,46.87741,-3.15513),(.50738,46.81603,-2.63041),(.49395,46.87549,-2.91354),(.1124,46.96822,-2.71909),(.11397,46.96464,-2.81373),(.374,46.89108,-2.81927),(.23543,46.68312,-2.9278),(.41316,46.7507,-3.05793),(.26605,46.69029,-2.65762),(.44552,46.79808,-3.04887),(.50964,46.73356,-2.78411),(.51006,46.73371,-2.77942),(.50078,46.72326,-2.78087),(-.22281,46.82582,-3.18482),(-.33279,46.67299,-2.90317),(-.4212,46.71987,-2.63747),(-.41197,46.89077,-2.71642),(-.29731,46.94266,-2.91524),(-.50817,46.8686,-2.74899),(-.32156,46.90868,-2.61241),(-.11397,46.96464,-2.81373),(-.22079,46.95481,-2.97556),(-.23388,46.91087,-3.07367),(-.3364,46.87741,-3.15513),(-.42063,46.87734,-2.89007),(-.44442,46.87353,-2.52318),(-.3187,46.91301,-3.04043),(-.33187,46.88644,-3.14573),(-.38382,46.89066,-3.10231),(-.19788,46.68286,-3.06423),(-.23543,46.68312,-2.9278),(-.12807,46.72987,-3.10265),(-.45826,46.8302,-3.00825),(-.50964,46.73356,-2.78411),(-.51006,46.73371,-2.77942),(.22281,46.82582,-3.18482),(.39154,46.67785,-2.8616),(.15391,46.72557,-2.27375),(.34864,46.71529,-2.51636),(.40113,46.72388,-2.50689),(.31573,46.80412,-3.16173),(.38943,46.88901,-2.61833),(.23388,46.91087,-3.07367),(.13232,46.81456,-2.14158),(.11358,46.85202,-2.15028),(.4654,46.8283,-2.50311),(.45353,46.86525,-2.51764),(.5029,46.8678,-2.91588),(.5076,46.81954,-2.93238),(.2338,46.88985,-3.16701),(.11948,46.88643,-3.15472),(0,46.91519,-2.36473),(.09786,46.89368,-2.24775),(.11012,46.91896,-2.36892),(0,46.88872,-2.2508),(.22522,46.91592,-2.49727),(.11396,46.95016,-2.60561),(0,46.94024,-2.48639),(.11625,46.93276,-2.48824),(0,46.95132,-2.60484),(0,46.95644,-2.89056),(.226,46.93765,-2.60871),(0,46.69884,-2.91289),(0,46.68128,-2.79332),(0,46.73237,-2.25694),(.15052,46.70787,-2.39685),(0,46.70243,-2.39489),(.16191,46.68067,-2.66608),(.26042,46.70199,-2.52739),(.33279,46.67299,-2.90317),(.28518,46.66988,-2.96133),(.14845,46.77043,-2.14565),(0,46.74083,-2.1496),(.16152,46.73399,-2.16214),(0,46.77371,-2.13869),(.5102,46.77309,-2.63195),(.52448,46.77241,-2.76932),(.50073,46.73664,-2.63563),(.42338,46.75974,-3.05883),(.45099,46.72815,-3.00676),(.50089,46.76404,-2.94311),(.46585,46.78343,-2.49083),(.39158,46.88194,-3.10862),(.51628,46.8795,-2.84349),(.4166,46.87372,-2.39908),(.3861,46.73956,-2.35843),(.48272,46.71645,-2.94974),(.32066,46.81672,-3.16861),(.40119,46.77628,-3.10053),(-.12559,46.78354,-3.14929),(-.40119,46.77628,-3.10053),(-.42338,46.75974,-3.05883),(-.50073,46.73664,-2.63563),(-.16152,46.73399,-2.16214),(0,46.84927,-2.14405),(-.11189,46.86209,-2.15997),(-.11358,46.85202,-2.15028),(0,46.85908,-2.15338),(-.4166,46.87372,-2.39908),(-.45353,46.86525,-2.51764),(-.5029,46.8678,-2.91588),(-.51628,46.8795,-2.84349),(-.2338,46.88985,-3.16701),(-.40303,46.84986,-3.11462),(-.40587,46.81008,-3.11245),(-.32066,46.81672,-3.16861),(-.4654,46.8283,-2.50311),(-.45315,46.78555,-2.44966),(-.44034,46.83324,-2.42187),(-.46585,46.78343,-2.49083),(-.52419,46.77906,-2.80309),(0,46.81475,-2.1366),(-.13232,46.81456,-2.14158),(-.28518,46.66988,-2.96133),(0,46.73354,-2.15999),(-.15052,46.70787,-2.39685),(0,46.68215,-2.67041),(-.16191,46.68067,-2.66608),(-.226,46.93765,-2.60871),(-.1124,46.96822,-2.71909),(-.11396,46.95016,-2.60561),(0,46.97588,-2.71264),(-.11012,46.91896,-2.36892),(-.09786,46.89368,-2.24775),(-.39158,46.88194,-3.10862),(-.5076,46.81954,-2.93238),(-.11948,46.88643,-3.15472),(-.22522,46.91592,-2.49727),(-.11625,46.93276,-2.48824),(-.15261,46.69673,-2.53187),(0,46.69215,-2.53465),(-.26042,46.70199,-2.52739),(-.3861,46.73956,-2.35843),(-.14845,46.77043,-2.14565),(-.45099,46.72815,-3.00676),(-.50089,46.76404,-2.94311),(-.48272,46.71645,-2.94974),(.11189,46.86209,-2.15997),(.40303,46.84986,-3.11462),(.40587,46.81008,-3.11245),(.45315,46.78555,-2.44966),(.44034,46.83324,-2.42187),(.52419,46.77906,-2.80309),(.52664,46.83249,-2.82389),(0,46.71707,-3.01189),(.48377,46.86047,-2.63567),(0,46.97228,-2.80444),(0,46.87318,-3.14164),(.1194,46.8768,-3.16355),(0,46.88218,-3.13213),(.15261,46.69673,-2.53187),(-.48377,46.86047,-2.63567),(-.1194,46.8768,-3.16355),(-.52664,46.83249,-2.82389),(0,46.72545,-3.09009)]))),
        Shape(DEF='t8',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='t8_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,5,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,19,21,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,52,55,-1,56,57,58,-1,7,59,60,-1,61,62,63,-1,64,65,66,-1,67,68,69,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,94,95,96,-1,97,98,99,-1,100,101,102,-1,103,104,105,-1,106,107,108,-1,109,110,111,-1,112,113,114,-1,115,116,70,-1,117,116,115,-1,118,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,130,131,132,-1,133,134,135,-1,136,137,138,-1,131,139,140,-1,141,137,142,-1,141,143,144,-1,140,145,146,-1,147,148,145,-1,149,150,147,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,169,43,170,-1,171,172,173,-1,174,175,176,-1,175,177,178,-1,179,176,173,-1,180,181,182,-1,183,184,185,-1,186,187,188,-1,174,187,189,-1,190,191,189,-1,192,193,194,-1,195,196,197,-1,198,199,200,-1,201,202,203,-1,204,205,206,-1,207,208,205,-1,209,210,211,-1,212,132,131,-1,213,25,24,-1,0,214,75,-1,215,115,216,-1,67,69,217,-1,218,219,220,-1,221,222,223,-1,224,225,122,-1,79,226,227,-1,228,229,110,-1,108,230,231,-1,232,76,233,-1,234,235,236,-1,236,237,234,-1,238,91,26,-1,239,240,241,-1,242,243,244,-1,245,246,247,-1,134,248,249,-1,250,251,252,-1,252,253,250,-1,254,255,217,-1,256,257,258,-1,220,259,260,-1,261,262,263,-1,264,265,266,-1,267,268,209,-1,269,197,196,-1,270,271,272,-1,273,274,275,-1,271,15,272,-1,18,17,276,-1,277,278,279,-1,280,259,220,-1,281,163,282,-1,56,283,284,-1,156,285,286,-1,269,287,197,-1,269,288,51,-1,289,290,291,-1,279,276,292,-1,293,294,295,-1,296,297,298,-1,299,300,301,-1,90,302,207,-1,303,84,304,-1,305,306,307,-1,308,309,310,-1,311,312,298,-1,82,313,87,-1,190,314,315,-1,316,317,318,-1,89,307,302,-1,299,274,319,-1,320,321,322,-1,323,321,324,-1,325,326,327,-1,328,329,330,-1,128,212,331,-1,332,140,333,-1,140,334,333,-1,331,335,128,-1,336,337,237,-1,338,339,102,-1,340,341,342,-1,343,344,153,-1,345,346,340,-1,250,253,124,-1,347,348,349,-1,350,351,352,-1,353,354,355,-1,356,357,358,-1,359,360,361,-1,362,363,357,-1,364,353,365,-1,366,367,368,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,376,379,-1,380,373,381,-1,382,383,384,-1,385,386,387,-1,388,315,389,-1,390,391,392,-1,393,394,395,-1,396,397,398,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,408,409,410,-1,411,412,413,-1,414,415,416,-1,417,418,406,-1,419,420,421,-1,422,423,424,-1,407,425,426,-1,427,428,429,-1,410,409,418,-1,418,415,410,-1,430,431,408,-1,432,369,371,-1,433,434,435,-1,435,434,436,-1,437,438,439,-1,440,441,442,-1,443,444,445,-1,444,446,445,-1,447,448,449,-1,450,451,452,-1,453,454,455,-1,456,457,458,-1,364,366,368,-1,459,460,461,-1,460,459,462,-1,463,464,456,-1,465,466,467,-1,468,469,470,-1,471,472,473,-1,474,475,476,-1,477,478,479,-1,480,481,482,-1,454,483,484,-1,485,486,487,-1,488,489,490,-1,491,492,493,-1,494,495,496,-1,497,498,499,-1,500,501,389,-1,389,502,503,-1,504,505,506,-1,505,507,508,-1,509,510,387,-1,511,512,513,-1,514,515,516,-1,517,518,519,-1,520,521,417,-1,522,523,524,-1,525,526,527,-1,403,528,529,-1,530,463,531,-1,532,533,534,-1,535,536,532,-1,537,538,539,-1,540,541,542,-1,543,544,545,-1,546,547,548,-1,549,550,551,-1,552,553,554,-1,555,556,557,-1,558,559,560,-1,561,445,446,-1,562,563,564,-1,565,566,368,-1,354,353,364,-1,354,567,355,-1,480,568,569,-1,570,571,572,-1,571,459,573,-1,559,574,263,-1,575,473,478,-1,576,577,477,-1,578,430,579,-1,410,414,580,-1,581,582,583,-1,584,585,586,-1,378,384,587,-1,391,390,588,-1,589,590,454,-1,371,591,592,-1,434,593,594,-1,595,591,596,-1,597,598,599,-1,600,601,602,-1,603,604,605,-1,603,606,607,-1,606,608,607,-1,451,450,609,-1,610,611,612,-1,613,610,455,-1,611,614,227,-1,453,455,452,-1,615,607,608,-1,616,617,606,-1,618,603,607,-1,616,605,619,-1,601,600,620,-1,595,621,592,-1,622,568,589,-1,623,391,624,-1,625,626,627,-1,628,33,629,-1,33,630,629,-1,586,631,584,-1,632,633,634,-1,399,635,636,-1,637,432,638,-1,639,640,416,-1,414,640,641,-1,409,408,642,-1,603,576,477,-1,643,644,645,-1,472,478,473,-1,479,476,646,-1,647,648,649,-1,650,461,460,-1,651,652,653,-1,80,654,655,-1,389,501,374,-1,656,380,657,-1,658,659,660,-1,589,568,480,-1,661,662,402,-1,663,664,665,-1,666,567,667,-1,668,354,669,-1,670,671,664,-1,672,673,674,-1,368,566,675,-1,649,676,677,-1,467,678,679,-1,467,549,680,-1,441,677,442,-1,681,443,682,-1,683,684,685,-1,686,687,688,-1,689,690,686,-1,542,691,545,-1,692,693,694,-1,533,532,695,-1,447,696,697,-1,532,536,698,-1,699,534,533,-1,536,700,698,-1,535,701,702,-1,458,457,699,-1,457,456,464,-1,464,703,704,-1,705,706,707,-1,530,708,709,-1,710,711,712,-1,713,714,438,-1,715,439,438,-1,716,717,718,-1,347,719,720,-1,721,722,723,-1,724,725,726,-1,633,727,728,-1,729,730,731,-1,728,727,732,-1,506,508,733,-1,733,519,518,-1,734,510,509,-1,508,735,736,-1,503,502,737,-1,489,504,738,-1,413,412,521,-1,437,439,739,-1,496,740,494,-1,493,492,741,-1,742,743,491,-1,485,744,745,-1,533,695,746,-1,483,622,484,-1,462,455,460,-1,677,441,678,-1,747,476,472,-1,748,429,428,-1,465,467,680,-1,749,750,751,-1,614,654,80,-1,752,753,754,-1,572,755,756,-1,757,758,759,-1,760,590,589,-1,589,482,761,-1,590,650,762,-1,620,600,763,-1,471,428,427,-1,764,541,765,-1,747,766,448,-1,767,679,768,-1,748,575,769,-1,770,263,574,-1,741,771,772,-1,352,719,487,-1,499,773,745,-1,437,774,417,-1,775,436,776,-1,777,371,398,-1,776,436,778,-1,779,433,580,-1,430,408,435,-1,748,469,468,-1,780,405,438,-1,407,406,409,-1,423,781,424,-1,417,774,520,-1,416,415,417,-1,411,413,782,-1,435,410,580,-1,783,784,785,-1,713,405,407,-1,397,396,786,-1,787,372,788,-1,788,789,659,-1,500,488,501,-1,790,384,791,-1,792,387,510,-1,311,512,511,-1,389,373,793,-1,314,737,502,-1,794,527,526,-1,795,383,660,-1,397,796,398,-1,797,798,366,-1,366,364,799,-1,800,801,802,-1,803,804,805,-1,806,799,365,-1,760,761,801,-1,807,808,809,-1,810,811,693,-1,356,759,812,-1,813,667,567,-1,813,814,667,-1,350,815,726,-1,816,817,818,-1,819,340,342,-1,155,820,821,-1,822,823,824,-1,825,266,826,-1,827,101,828,-1,829,326,325,-1,830,129,335,-1,831,832,833,-1,321,834,324,-1,321,109,835,-1,48,275,836,-1,837,83,82,-1,838,839,840,-1,841,842,840,-1,82,87,86,-1,305,307,843,-1,385,310,844,-1,191,315,388,-1,29,845,846,-1,847,208,848,-1,299,849,836,-1,45,850,851,-1,852,853,854,-1,163,855,284,-1,58,292,283,-1,289,291,192,-1,55,51,288,-1,269,284,856,-1,857,198,858,-1,858,201,857,-1,343,859,286,-1,269,856,288,-1,247,860,219,-1,856,292,55,-1,277,58,57,-1,861,862,16,-1,275,48,50,-1,863,18,279,-1,863,279,278,-1,196,864,281,-1,215,865,866,-1,135,249,254,-1,867,2,868,-1,240,1,0,-1,148,146,145,-1,321,323,104,-1,73,75,869,-1,75,214,869,-1,148,147,870,-1,221,223,871,-1,280,872,259,-1,245,218,65,-1,873,69,874,-1,115,875,876,-1,60,59,66,-1,92,91,96,-1,240,25,213,-1,209,877,168,-1,878,879,211,-1,304,880,881,-1,882,883,826,-1,200,199,884,-1,266,268,885,-1,268,886,885,-1,303,887,191,-1,887,174,189,-1,189,187,186,-1,310,309,185,-1,312,888,298,-1,889,890,891,-1,187,176,891,-1,194,287,269,-1,892,893,344,-1,94,894,318,-1,854,235,895,-1,870,158,896,-1,139,131,130,-1,144,130,138,-1,897,898,132,-1,899,124,253,-1,900,125,901,-1,902,903,904,-1,905,906,907,-1,561,446,908,-1,564,563,909,-1,830,835,109,-1,105,104,323,-1,105,910,102,-1,92,911,93,-1,869,912,913,-1,913,914,869,-1,915,263,262,-1,916,66,65,-1,7,60,917,-1,278,277,918,-1,292,276,55,-1,919,920,921,-1,40,39,922,-1,630,850,923,-1,924,925,926,-1,29,927,845,-1,240,239,26,-1,928,23,275,-1,18,21,19,-1,23,22,273,-1,929,930,931,-1,932,13,244,-1,6,5,933,-1,6,934,935,-1,935,934,936,-1,935,937,3,-1,868,243,938,-1,939,940,867,-1,214,940,941,-1,942,943,226,-1,943,227,226,-1,214,0,940,-1,939,942,940,-1,868,938,867,-1,935,944,937,-1,936,944,935,-1,935,5,6,-1,59,6,933,-1,5,4,9,-1,244,945,932,-1,946,929,931,-1,272,15,14,-1,273,275,23,-1,18,863,21,-1,275,947,928,-1,26,25,240,-1,29,28,927,-1,948,305,841,-1,924,926,32,-1,630,35,850,-1,949,950,951,-1,919,851,920,-1,270,278,918,-1,917,257,7,-1,65,220,916,-1,915,952,263,-1,913,330,914,-1,76,232,77,-1,912,233,913,-1,911,817,93,-1,853,852,91,-1,852,96,91,-1,953,954,97,-1,105,323,955,-1,109,956,830,-1,564,909,957,-1,958,959,900,-1,908,960,561,-1,961,905,907,-1,114,962,112,-1,876,963,964,-1,965,966,967,-1,902,968,903,-1,901,969,900,-1,897,132,970,-1,901,136,969,-1,144,139,130,-1,158,141,159,-1,325,327,833,-1,896,146,870,-1,971,94,318,-1,892,972,893,-1,269,192,194,-1,973,974,975,-1,187,891,188,-1,889,891,179,-1,185,976,310,-1,186,190,189,-1,887,977,174,-1,191,313,84,-1,84,303,191,-1,884,978,200,-1,266,885,826,-1,882,203,883,-1,979,980,981,-1,205,204,207,-1,878,211,264,-1,209,168,267,-1,213,1,240,-1,59,64,66,-1,873,217,69,-1,65,67,245,-1,221,982,222,-1,983,984,985,-1,148,870,146,-1,73,869,914,-1,104,109,321,-1,234,237,896,-1,0,241,240,-1,867,940,2,-1,219,860,280,-1,254,873,135,-1,917,916,260,-1,117,215,866,-1,986,918,987,-1,863,278,272,-1,18,276,279,-1,947,275,50,-1,946,861,16,-1,987,277,57,-1,55,288,856,-1,856,283,292,-1,219,218,247,-1,855,988,56,-1,285,343,286,-1,269,282,284,-1,55,52,51,-1,192,51,289,-1,989,236,990,-1,991,294,992,-1,284,282,163,-1,836,274,299,-1,847,981,208,-1,845,993,846,-1,388,793,191,-1,793,313,191,-1,385,792,310,-1,305,843,841,-1,994,82,86,-1,843,307,89,-1,995,931,838,-1,277,987,918,-1,88,996,994,-1,91,238,832,-1,997,998,999,-1,990,831,833,-1,336,989,998,-1,955,910,105,-1,1000,822,824,-1,1001,1002,819,-1,764,542,541,-1,1003,724,726,-1,422,707,523,-1,724,1004,725,-1,798,367,366,-1,811,694,693,-1,809,699,807,-1,694,811,746,-1,806,1005,799,-1,803,800,804,-1,802,1006,800,-1,366,799,805,-1,1007,811,810,-1,398,371,370,-1,657,1008,379,-1,795,660,659,-1,1009,794,526,-1,599,377,1010,-1,1011,656,375,-1,502,315,314,-1,373,380,793,-1,393,395,1012,-1,311,297,512,-1,510,308,792,-1,384,383,791,-1,787,788,659,-1,789,795,659,-1,397,786,1013,-1,1014,512,297,-1,713,407,426,-1,1015,1016,784,-1,435,408,410,-1,416,417,412,-1,409,406,418,-1,419,740,1017,-1,407,409,425,-1,438,437,780,-1,748,468,429,-1,579,430,435,-1,580,641,779,-1,778,597,776,-1,777,596,371,-1,775,579,436,-1,780,437,417,-1,1018,1010,377,-1,1019,783,785,-1,745,744,499,-1,487,486,352,-1,771,1020,772,-1,574,1021,770,-1,748,769,469,-1,1022,1023,1024,-1,448,474,747,-1,764,765,1025,-1,447,449,1026,-1,1026,696,447,-1,427,1027,471,-1,600,1028,763,-1,762,454,590,-1,761,760,589,-1,757,529,758,-1,572,651,755,-1,1029,1030,672,-1,1030,1031,672,-1,753,1032,754,-1,227,614,80,-1,1033,1034,1035,-1,465,1036,466,-1,428,473,748,-1,471,747,472,-1,455,762,460,-1,483,1037,622,-1,746,807,533,-1,1038,485,745,-1,1039,1040,393,-1,1041,788,1042,-1,742,420,743,-1,740,421,494,-1,739,774,437,-1,413,521,1043,-1,737,505,503,-1,506,505,508,-1,508,507,735,-1,734,1044,510,-1,1045,1046,514,-1,518,1047,733,-1,1048,730,738,-1,733,1048,506,-1,730,1047,731,-1,633,728,634,-1,721,723,1049,-1,716,718,1050,-1,714,715,438,-1,438,405,713,-1,710,1051,711,-1,709,1052,530,-1,1053,781,1054,-1,705,707,1055,-1,464,704,457,-1,464,1056,703,-1,458,699,812,-1,535,702,536,-1,536,702,700,-1,699,533,807,-1,1057,532,698,-1,697,1058,447,-1,532,537,695,-1,688,689,686,-1,688,1059,689,-1,1060,683,685,-1,681,682,1061,-1,677,676,442,-1,467,679,549,-1,677,1062,649,-1,368,675,1032,-1,672,1063,673,-1,670,664,1029,-1,669,753,668,-1,573,1005,806,-1,1064,1065,1066,-1,661,402,481,-1,589,480,482,-1,658,787,659,-1,657,379,656,-1,373,389,374,-1,1067,1068,653,-1,654,756,655,-1,460,762,650,-1,649,1062,647,-1,479,472,476,-1,472,479,478,-1,477,604,603,-1,642,425,409,-1,580,414,641,-1,639,416,411,-1,637,369,432,-1,634,1069,632,-1,1070,586,585,-1,377,599,375,-1,627,796,625,-1,624,1071,623,-1,484,622,589,-1,592,591,595,-1,595,594,621,-1,594,593,621,-1,779,593,433,-1,1072,1073,778,-1,620,1018,601,-1,619,1074,616,-1,618,576,603,-1,616,1075,617,-1,615,618,607,-1,455,610,452,-1,943,611,227,-1,455,462,613,-1,612,450,610,-1,609,1028,451,-1,606,617,1076,-1,1076,1077,606,-1,606,1077,608,-1,603,616,606,-1,603,605,616,-1,616,1074,1075,-1,600,602,1078,-1,597,599,1010,-1,436,1072,778,-1,591,371,596,-1,434,433,593,-1,371,592,1079,-1,589,454,484,-1,588,624,391,-1,949,951,1080,-1,583,400,581,-1,579,775,578,-1,576,1024,577,-1,575,748,473,-1,263,952,559,-1,573,806,571,-1,651,653,755,-1,570,459,571,-1,569,1081,480,-1,402,404,482,-1,482,481,402,-1,1082,663,1083,-1,669,354,364,-1,368,367,565,-1,564,673,562,-1,1084,543,1085,-1,561,1086,445,-1,558,1087,559,-1,556,1088,557,-1,1089,1090,1091,-1,1089,1092,1090,-1,543,1093,544,-1,537,539,695,-1,544,1093,1057,-1,532,534,535,-1,530,1052,702,-1,801,360,802,-1,463,458,531,-1,662,525,527,-1,524,1094,522,-1,521,412,417,-1,1095,1096,1097,-1,519,1098,517,-1,514,1046,515,-1,509,387,1099,-1,505,737,507,-1,504,503,505,-1,503,500,389,-1,499,771,497,-1,494,1100,495,-1,771,492,497,-1,491,743,492,-1,1039,393,1012,-1,1041,789,788,-1,487,772,485,-1,708,530,1101,-1,454,453,483,-1,479,604,477,-1,551,1062,677,-1,476,747,474,-1,473,428,471,-1,465,680,1036,-1,1033,1102,1034,-1,456,458,463,-1,461,573,459,-1,669,364,368,-1,758,531,759,-1,454,762,455,-1,452,610,450,-1,429,468,1103,-1,447,474,448,-1,577,769,575,-1,442,1104,440,-1,1105,431,578,-1,435,436,579,-1,435,580,433,-1,371,1079,432,-1,431,642,408,-1,415,414,410,-1,427,429,1103,-1,417,415,418,-1,424,1106,422,-1,419,421,740,-1,406,780,417,-1,416,640,414,-1,411,416,412,-1,358,1107,757,-1,1066,1019,785,-1,405,780,406,-1,370,396,398,-1,393,1108,394,-1,391,1015,392,-1,389,793,388,-1,315,502,389,-1,387,792,385,-1,384,378,382,-1,381,657,380,-1,382,660,383,-1,1109,375,599,-1,430,578,431,-1,658,381,787,-1,482,361,761,-1,364,365,799,-1,366,805,804,-1,359,1107,360,-1,565,810,693,-1,760,801,800,-1,1110,1068,667,-1,741,492,771,-1,352,722,350,-1,1054,1111,717,-1,348,1004,724,-1,1112,1113,569,-1,822,346,1114,-1,338,102,101,-1,322,321,835,-1,335,129,128,-1,829,325,238,-1,330,1115,328,-1,326,1116,327,-1,323,324,328,-1,1117,335,331,-1,274,836,275,-1,86,842,1118,-1,302,90,89,-1,316,318,894,-1,931,930,839,-1,1011,838,85,-1,315,191,190,-1,313,793,87,-1,981,980,208,-1,298,297,311,-1,310,792,308,-1,306,1119,307,-1,204,837,996,-1,301,849,299,-1,846,295,1120,-1,300,47,46,-1,300,30,47,-1,292,58,279,-1,51,192,269,-1,283,856,284,-1,857,1121,198,-1,284,855,56,-1,281,282,196,-1,220,219,280,-1,277,279,58,-1,17,54,276,-1,271,929,15,-1,273,1122,274,-1,272,278,270,-1,196,282,269,-1,11,839,930,-1,992,294,293,-1,268,210,209,-1,266,825,264,-1,770,261,263,-1,260,916,220,-1,1123,1124,1125,-1,217,873,254,-1,135,134,249,-1,245,247,218,-1,244,12,242,-1,239,241,74,-1,26,829,238,-1,26,239,829,-1,233,81,232,-1,231,1126,108,-1,229,1127,110,-1,227,80,79,-1,983,1128,984,-1,221,871,982,-1,218,220,65,-1,217,245,67,-1,75,241,0,-1,24,1129,213,-1,332,212,131,-1,211,877,209,-1,979,981,1130,-1,208,978,205,-1,201,203,882,-1,883,825,826,-1,198,200,858,-1,195,864,196,-1,192,291,193,-1,881,177,977,-1,191,887,189,-1,186,188,1131,-1,183,185,309,-1,179,891,176,-1,174,176,187,-1,170,1132,169,-1,178,171,173,-1,169,44,43,-1,340,346,341,-1,168,823,166,-1,1001,1133,1134,-1,163,281,164,-1,162,1135,160,-1,157,1136,158,-1,152,1137,153,-1,146,337,140,-1,144,138,141,-1,141,138,137,-1,140,332,131,-1,130,136,138,-1,1138,133,135,-1,132,898,130,-1,1139,1140,61,-1,1140,62,61,-1,121,224,122,-1,1141,118,120,-1,115,215,117,-1,223,222,964,-1,875,115,70,-1,112,1128,113,-1,111,956,109,-1,106,108,99,-1,103,228,104,-1,914,330,329,-1,1142,991,1143,-1,94,96,852,-1,93,26,91,-1,90,996,88,-1,85,842,86,-1,313,82,84,-1,1144,77,828,-1,80,655,81,-1,74,241,75,-1,70,72,875,-1,67,64,68,-1,64,67,65,-1,7,6,59,-1,58,283,56,-1,55,276,54,-1,53,289,51,-1,49,1145,50,-1,44,1146,42,-1,1147,922,39,-1,36,38,1148,-1,33,35,630,-1,839,838,931,-1,30,319,31,-1,27,1149,28,-1,24,26,93,-1,12,244,13,-1,10,933,5,-1,8,934,6,-1,5,935,3,-1,2,940,0,-1,940,226,941,-1,940,942,226,-1,867,1150,939,-1,938,1150,867,-1,1151,1150,938,-1,1151,1152,1150,-1,937,1151,3,-1,937,1152,1151,-1,936,1153,1154,-1,1155,1153,936,-1,8,261,1155,-1,8,1156,261,-1,1157,213,1129,-1,1157,1158,213,-1,1122,319,274,-1,1122,31,319,-1,1159,1157,1149,-1,932,1157,1159,-1,845,817,816,-1,845,927,817,-1,931,924,1160,-1,931,995,924,-1,995,925,924,-1,995,1161,925,-1,1162,1163,1164,-1,1165,1163,1162,-1,1166,44,1167,-1,1166,1146,44,-1,49,836,849,-1,836,49,48,-1,1168,270,918,-1,271,270,1168,-1,1169,915,1170,-1,1169,952,915,-1,141,68,933,-1,142,68,141,-1,993,295,846,-1,993,293,295,-1,847,1171,1172,-1,847,1173,1171,-1,827,1174,1175,-1,1174,827,1176,-1,98,106,99,-1,98,1177,106,-1,74,1178,326,-1,73,1178,74,-1,335,320,322,-1,335,1117,320,-1,1127,1179,1180,-1,1127,231,1179,-1,1179,1181,1180,-1,1179,1182,1181,-1,1183,909,563,-1,1184,909,1183,-1,1185,1186,1181,-1,1187,1186,1185,-1,1188,1185,1189,-1,1188,1190,1185,-1,1191,1192,1193,-1,1191,1194,1192,-1,958,897,1195,-1,900,897,958,-1,1196,1197,1198,-1,1196,1199,1197,-1,1200,962,114,-1,1200,1201,962,-1,967,1202,1203,-1,967,1204,1202,-1,962,1205,906,-1,1205,962,1170,-1,906,112,962,-1,906,905,112,-1,1125,223,964,-1,1125,216,223,-1,904,1206,902,-1,1203,1206,904,-1,1207,904,903,-1,904,1207,965,-1,1208,903,1209,-1,1208,1207,903,-1,1210,1196,1211,-1,1196,1210,1199,-1,1212,61,1213,-1,61,1212,1139,-1,899,125,124,-1,901,125,899,-1,874,137,1138,-1,142,137,874,-1,859,317,286,-1,1130,317,859,-1,1130,318,317,-1,883,152,1214,-1,883,203,152,-1,316,1215,1216,-1,316,895,1215,-1,162,988,1217,-1,162,161,988,-1,1218,820,1219,-1,820,1218,1220,-1,1221,1222,864,-1,1221,167,1222,-1,296,39,41,-1,296,1223,39,-1,921,182,1224,-1,921,1225,182,-1,170,888,1226,-1,170,1223,888,-1,180,974,973,-1,1227,974,180,-1,1228,976,185,-1,1228,181,976,-1,1229,975,1230,-1,1231,975,1229,-1,881,1232,177,-1,206,1232,881,-1,884,1233,1234,-1,199,1233,884,-1,195,885,886,-1,885,195,1235,-1,882,885,1235,-1,885,882,826,-1,200,208,980,-1,208,200,978,-1,1236,848,302,-1,848,1236,1237,-1,825,1214,1134,-1,825,883,1214,-1,823,879,824,-1,879,823,1238,-1,1239,970,127,-1,970,1239,1240,-1,280,876,872,-1,280,963,876,-1,961,258,71,-1,256,961,907,-1,961,256,258,-1,866,126,959,-1,866,865,126,-1,130,969,136,-1,130,898,969,-1,251,1213,252,-1,251,1212,1213,-1,63,1241,860,-1,1241,63,62,-1,1242,113,1243,-1,1242,1244,113,-1,79,233,912,-1,79,81,233,-1,214,912,869,-1,214,941,912,-1,233,78,913,-1,78,233,76,-1,932,1158,1157,-1,932,945,1158,-1,963,860,1241,-1,963,280,860,-1,1210,1209,1141,-1,1208,1209,1210,-1,865,216,1245,-1,865,215,216,-1,824,878,1134,-1,824,879,878,-1,290,178,1246,-1,178,290,171,-1,1247,918,986,-1,1247,1168,918,-1,1122,862,861,-1,273,862,1122,-1,1217,165,1248,-1,165,1217,988,-1,201,1249,202,-1,201,858,1249,-1,988,163,165,-1,163,988,855,-1,1171,1250,1251,-1,1250,1171,1142,-1,1120,29,846,-1,27,29,1120,-1,1131,1252,1253,-1,1252,1131,183,-1,1254,1229,1255,-1,1254,1256,1229,-1,922,1257,950,-1,1257,922,1147,-1,1166,38,37,-1,38,1166,1258,-1,1259,45,851,-1,46,45,1259,-1,981,1172,1130,-1,1172,981,847,-1,843,88,1118,-1,89,88,843,-1,840,85,838,-1,85,840,842,-1,1260,1152,937,-1,1261,1152,1260,-1,959,125,900,-1,126,125,959,-1,327,998,833,-1,327,999,998,-1,1262,1263,1116,-1,1263,1262,1264,-1,100,1265,1144,-1,1265,100,1266,-1,896,337,146,-1,896,237,337,-1,972,1267,821,-1,972,892,1267,-1,1000,346,822,-1,341,346,1000,-1,156,892,285,-1,1267,892,156,-1,1065,1019,1066,-1,1268,1019,1065,-1,523,423,422,-1,523,522,423,-1,1003,815,718,-1,815,1003,726,-1,524,349,348,-1,524,706,349,-1,1269,755,653,-1,1269,1270,755,-1,362,356,812,-1,362,357,356,-1,798,565,367,-1,565,798,810,-1,1107,357,360,-1,357,1107,358,-1,799,803,805,-1,1005,803,799,-1,809,1271,1272,-1,809,808,1271,-1,366,1273,797,-1,804,1273,366,-1,381,1008,657,-1,658,1008,381,-1,403,757,404,-1,757,403,529,-1,1274,1013,786,-1,1274,636,1013,-1,628,1275,1276,-1,628,1277,1275,-1,1278,1070,1279,-1,1278,1069,1070,-1,297,631,1014,-1,297,1280,631,-1,1256,1281,1282,-1,1256,1283,1281,-1,1253,507,1284,-1,1253,735,507,-1,791,623,790,-1,623,791,1016,-1,1285,1286,525,-1,1285,1287,1286,-1,625,1288,1289,-1,625,635,1288,-1,1290,742,1055,-1,742,1290,1291,-1,1292,779,641,-1,1293,779,1292,-1,1010,1294,1295,-1,1296,1294,1010,-1,1107,404,757,-1,1107,359,404,-1,722,1038,723,-1,722,1297,1038,-1,744,771,499,-1,771,744,1020,-1,577,1023,769,-1,577,1024,1023,-1,1298,683,1060,-1,1298,1299,683,-1,577,478,477,-1,575,478,577,-1,1300,549,1301,-1,550,549,1300,-1,1026,541,696,-1,541,1026,765,-1,451,600,1078,-1,600,451,1028,-1,1270,756,755,-1,1270,655,756,-1,670,672,674,-1,670,1029,672,-1,570,614,613,-1,614,570,654,-1,1035,1302,1033,-1,1302,1035,1303,-1,643,766,1027,-1,766,643,751,-1,1301,688,1300,-1,1301,1059,688,-1,765,1304,686,-1,765,1026,1304,-1,685,1084,1085,-1,685,1305,1084,-1,677,1036,551,-1,677,466,1036,-1,647,469,769,-1,470,469,647,-1,531,1101,530,-1,531,758,1101,-1,692,695,539,-1,692,746,695,-1,692,694,746,-1,1020,485,772,-1,485,1020,744,-1,1042,1100,1041,-1,495,1100,1042,-1,1306,784,1307,-1,784,1306,785,-1,1012,421,1291,-1,1012,494,421,-1,1308,420,419,-1,743,420,1308,-1,739,419,774,-1,739,1308,419,-1,521,1309,1043,-1,521,1310,1309,-1,1311,738,730,-1,738,1311,1312,-1,1281,1095,386,-1,1095,1281,1096,-1,506,738,504,-1,738,506,1048,-1,1098,509,516,-1,1098,734,509,-1,732,1313,1097,-1,732,727,1313,-1,732,1314,728,-1,732,1315,1314,-1,518,731,1047,-1,731,518,1316,-1,1045,1317,1046,-1,1317,1045,1318,-1,634,1319,586,-1,634,728,1319,-1,718,721,1050,-1,815,721,718,-1,1050,1049,715,-1,1049,1050,721,-1,716,715,714,-1,716,1050,715,-1,711,425,642,-1,426,425,711,-1,708,712,709,-1,710,712,708,-1,1053,716,1320,-1,1053,717,716,-1,1054,717,1053,-1,758,528,1101,-1,529,528,758,-1,706,1321,349,-1,705,1321,706,-1,534,703,535,-1,534,704,703,-1,646,475,700,-1,646,476,475,-1,540,696,541,-1,696,540,697,-1,566,692,1322,-1,566,693,692,-1,566,565,693,-1,686,749,687,-1,749,686,1304,-1,1323,684,683,-1,1323,1324,684,-1,1325,682,1326,-1,1061,682,1325,-1,1298,676,1089,-1,1298,442,676,-1,548,1061,1325,-1,548,547,1061,-1,649,1033,676,-1,649,1102,1033,-1,1327,1328,1329,-1,1202,1328,1327,-1,560,1201,554,-1,1201,560,1169,-1,1330,1324,1331,-1,1324,1330,684,-1,1332,1330,1333,-1,1332,1305,1330,-1,1334,1194,1183,-1,1194,1334,1335,-1,1336,1333,1337,-1,1333,1336,1332,-1,1338,1337,1339,-1,1340,1337,1338,-1,1338,1063,1341,-1,1342,1063,1338,-1,1343,1032,675,-1,1032,1343,754,-1,564,674,673,-1,564,1344,674,-1,1029,663,1030,-1,1029,664,663,-1,668,567,354,-1,567,668,813,-1,667,1345,1110,-1,667,814,1345,-1,1346,1347,671,-1,1346,1348,1347,-1,1110,1349,1068,-1,1110,1176,1349,-1,662,1285,525,-1,1285,662,661,-1,404,361,482,-1,404,359,361,-1,1350,569,1113,-1,1081,569,1350,-1,1307,1016,791,-1,1307,784,1016,-1,656,793,380,-1,793,656,1011,-1,1067,667,1068,-1,1067,666,667,-1,1052,1105,619,-1,1052,709,1105,-1,574,1087,1351,-1,1087,574,559,-1,604,646,605,-1,646,604,479,-1,782,639,411,-1,638,639,782,-1,638,1292,639,-1,1292,638,432,-1,1274,581,400,-1,1316,581,1274,-1,1275,1352,1353,-1,1275,1318,1352,-1,1279,1165,1278,-1,1279,1354,1165,-1,33,1276,1148,-1,1276,33,628,-1,375,1161,1011,-1,375,1109,1161,-1,635,923,1288,-1,635,401,923,-1,401,635,399,-1,1071,790,623,-1,1355,790,1071,-1,602,587,1355,-1,602,601,587,-1,1293,593,779,-1,1293,621,593,-1,1072,1356,1073,-1,1357,1356,1072,-1,1295,597,1010,-1,776,597,1295,-1,1024,618,1358,-1,1024,576,618,-1,1154,1077,1359,-1,1154,608,1077,-1,763,617,1075,-1,763,1360,617,-1,1361,1261,1362,-1,1261,1361,1363,-1,614,610,613,-1,610,614,611,-1,1361,450,612,-1,1361,609,450,-1,1361,1360,609,-1,1360,1361,1362,-1,1360,1076,617,-1,1362,1076,1360,-1,1153,608,1154,-1,1153,615,608,-1,1074,1296,1075,-1,1294,1296,1074,-1,598,1364,599,-1,598,1365,1364,-1,1357,596,1356,-1,1357,595,596,-1,434,1072,436,-1,434,594,1072,-1,1079,621,1293,-1,1079,592,621,-1,595,1072,594,-1,595,1357,1072,-1,1366,1355,1071,-1,1366,602,1355,-1,569,390,1112,-1,588,390,569,-1,1367,599,1364,-1,599,1367,1109,-1,925,1109,1367,-1,1161,1109,925,-1,1278,1162,1368,-1,1278,1165,1162,-1,633,1353,1352,-1,1353,633,632,-1,370,637,396,-1,370,369,637,-1,775,1295,578,-1,775,776,1295,-1,559,1169,560,-1,1169,559,952,-1,646,702,605,-1,646,700,702,-1,784,392,1015,-1,392,784,783,-1,1287,1108,1286,-1,1369,1108,1287,-1,1174,1110,1345,-1,1174,1176,1110,-1,671,665,664,-1,1347,665,671,-1,803,650,800,-1,803,461,650,-1,797,810,798,-1,810,797,1007,-1,675,1322,1370,-1,1322,675,566,-1,1342,673,1063,-1,562,673,1342,-1,1339,1342,1338,-1,1339,1371,1342,-1,1372,1332,1336,-1,1373,1332,1372,-1,1374,1375,1376,-1,1374,1335,1375,-1,1331,1333,1330,-1,1333,1331,1377,-1,684,1305,685,-1,684,1330,1305,-1,561,1374,1086,-1,561,1192,1374,-1,1242,1329,1302,-1,1327,1329,1242,-1,681,444,443,-1,444,681,1378,-1,1087,557,1088,-1,557,1087,558,-1,1303,553,552,-1,1035,553,1303,-1,547,681,1061,-1,681,547,546,-1,1033,1089,676,-1,1033,1092,1089,-1,1379,1323,1380,-1,1379,1324,1323,-1,545,540,542,-1,545,544,540,-1,698,475,1058,-1,698,700,475,-1,528,527,794,-1,527,528,403,-1,348,1094,524,-1,348,724,1094,-1,1039,1291,1290,-1,1039,1012,1291,-1,1381,1382,1383,-1,1381,1051,1382,-1,709,431,1105,-1,431,709,712,-1,1313,1318,1045,-1,1318,1313,1352,-1,1316,517,581,-1,1316,518,517,-1,1097,1315,732,-1,1097,1096,1315,-1,519,734,1098,-1,519,736,734,-1,516,517,1098,-1,516,515,517,-1,511,1314,1384,-1,513,1314,511,-1,1099,386,1095,-1,1099,387,386,-1,1309,1042,1312,-1,1309,495,1042,-1,1017,496,1310,-1,740,496,1017,-1,1385,499,498,-1,773,499,1385,-1,1066,1306,1369,-1,785,1306,1066,-1,788,489,1042,-1,788,490,489,-1,789,1100,395,-1,789,1041,1100,-1,1321,741,719,-1,493,741,1321,-1,486,722,352,-1,486,1297,722,-1,539,1322,692,-1,539,1372,1322,-1,551,468,470,-1,550,468,551,-1,1023,556,648,-1,556,1022,1088,-1,1022,556,1023,-1,691,1104,1085,-1,1104,691,440,-1,1093,532,1057,-1,537,532,1093,-1,686,1025,765,-1,1025,686,690,-1,1300,645,1103,-1,1300,688,645,-1,1303,1242,1302,-1,1242,1303,1244,-1,572,654,570,-1,756,654,572,-1,570,462,459,-1,613,462,570,-1,674,1386,670,-1,1386,674,1344,-1,1387,571,806,-1,571,1387,652,-1,452,1078,1388,-1,1078,452,451,-1,679,1301,549,-1,679,1389,1301,-1,679,767,1389,-1,682,445,1380,-1,682,443,445,-1,1060,442,1298,-1,442,1060,1104,-1,1358,1022,1024,-1,1358,1351,1022,-1,730,782,1311,-1,730,729,782,-1,578,1294,1105,-1,1294,578,1295,-1,1356,777,1365,-1,1356,596,777,-1,713,1381,1320,-1,713,426,1381,-1,1291,420,742,-1,420,1291,421,-1,1040,525,1286,-1,1040,526,525,-1,1350,1287,1285,-1,1350,1064,1287,-1,391,1016,1015,-1,391,623,1016,-1,1252,735,1253,-1,1252,1044,735,-1,1283,1254,1384,-1,1256,1254,1283,-1,1279,585,1080,-1,1279,1070,585,-1,1276,1353,1390,-1,1276,1275,1353,-1,399,1274,400,-1,399,636,1274,-1,1286,393,1040,-1,1286,1108,393,-1,658,382,1008,-1,658,660,382,-1,656,376,375,-1,656,379,376,-1,1362,1260,1076,-1,1362,1261,1260,-1,545,1085,543,-1,545,691,1085,-1,357,802,360,-1,802,357,363,-1,1272,1273,1006,-1,1272,1271,1273,-1,801,361,360,-1,761,361,801,-1,812,531,458,-1,531,812,759,-1,351,719,352,-1,351,720,719,-1,348,720,1004,-1,348,347,720,-1,718,1111,1003,-1,718,717,1111,-1,706,523,707,-1,706,524,523,-1,1113,1268,1065,-1,1112,1268,1113,-1,1267,155,821,-1,1267,156,155,-1,1133,341,1000,-1,342,341,1133,-1,139,145,140,-1,139,1391,145,-1,212,333,331,-1,212,332,333,-1,330,1266,1115,-1,330,1265,1266,-1,1116,834,1262,-1,1116,326,834,-1,1116,999,327,-1,1116,1263,999,-1,1264,331,333,-1,331,1264,1117,-1,1118,994,86,-1,1118,88,994,-1,236,854,853,-1,236,235,854,-1,300,1259,301,-1,1259,300,46,-1,1258,34,38,-1,34,1258,1392,-1,1147,1163,1257,-1,1163,1147,42,-1,41,297,296,-1,1280,297,41,-1,1231,1256,1282,-1,1256,1231,1229,-1,186,1253,1284,-1,1253,186,1131,-1,27,1119,306,-1,27,1120,1119,-1,1172,1251,971,-1,1251,1172,1171,-1,1288,30,1289,-1,30,1288,47,-1,1393,1248,154,-1,1248,1393,1217,-1,17,1394,54,-1,17,1395,1394,-1,1247,930,1168,-1,1247,1396,930,-1,853,990,236,-1,831,990,853,-1,877,823,168,-1,823,877,1238,-1,266,210,268,-1,266,265,210,-1,258,917,260,-1,257,917,258,-1,1141,1397,118,-1,1209,1397,1141,-1,446,1398,908,-1,444,1398,446,-1,66,917,60,-1,66,916,917,-1,964,1241,1399,-1,964,963,1241,-1,253,248,134,-1,253,252,248,-1,244,868,945,-1,244,243,868,-1,81,1270,232,-1,655,1270,81,-1,230,107,1400,-1,108,107,230,-1,226,912,941,-1,226,79,912,-1,1243,1128,983,-1,1243,113,1128,-1,255,1401,246,-1,255,225,1401,-1,62,1399,1241,-1,1399,62,1140,-1,121,252,1213,-1,248,252,121,-1,958,119,959,-1,119,958,1402,-1,259,72,260,-1,259,872,72,-1,1136,896,158,-1,1215,896,1136,-1,896,1215,234,-1,954,338,1403,-1,338,954,339,-1,978,206,205,-1,978,884,206,-1,295,1237,1236,-1,295,294,1237,-1,858,980,1249,-1,200,980,858,-1,201,1235,857,-1,201,882,1235,-1,1233,287,194,-1,1121,287,1233,-1,1232,193,1246,-1,1232,1234,193,-1,977,304,881,-1,887,304,977,-1,887,303,304,-1,973,1231,844,-1,973,975,1231,-1,178,176,175,-1,173,176,178,-1,185,890,1228,-1,184,890,185,-1,1227,1132,974,-1,169,1132,1227,-1,1226,1132,170,-1,1230,1132,1226,-1,172,179,173,-1,172,1404,179,-1,1225,180,182,-1,1225,1405,180,-1,1223,43,39,-1,43,1223,170,-1,166,1220,1218,-1,166,1114,1220,-1,167,1218,1222,-1,167,166,1218,-1,1222,1219,164,-1,1218,1219,1222,-1,56,161,57,-1,56,988,161,-1,160,1136,157,-1,160,1135,1136,-1,1219,154,1248,-1,820,154,1219,-1,820,155,154,-1,895,234,1215,-1,895,235,234,-1,1214,151,1002,-1,1214,152,151,-1,149,139,144,-1,139,149,1391,-1,874,68,142,-1,69,68,874,-1,134,899,253,-1,134,133,899,-1,127,956,1239,-1,129,956,127,-1,129,830,956,-1,224,1213,61,-1,224,121,1213,-1,120,1210,1141,-1,1199,1210,120,-1,1406,1207,1208,-1,1406,1407,1207,-1,116,1397,968,-1,117,1397,116,-1,965,1203,904,-1,967,1203,96