####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesRightTibiaFibula.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesRightTibiaFibula.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Right Tibia Fibula',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesRightTibiaFibula.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesRightTibiaFibula.x3d'),
    Transform(DEF='DSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Group(DEF='rtibfib',
        #  rtibia rfibia 
        children=[
        Shape(DEF='rtibia',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rtibia_Geo',coordIndex=[0,1,2,-1,1,3,2,-1,4,5,6,-1,4,7,5,-1,6,8,9,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,21,22,19,-1,21,23,22,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,28,31,29,-1,32,33,34,-1,35,36,37,-1,36,38,37,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,45,0,46,-1,8,48,9,-1,48,49,9,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,63,43,64,-1,65,66,67,-1,67,68,65,-1,69,70,71,-1,71,72,69,-1,58,73,74,-1,74,75,58,-1,76,77,78,-1,78,79,76,-1,59,80,78,-1,80,79,78,-1,81,60,82,-1,82,83,81,-1,84,85,86,-1,40,87,88,-1,88,47,40,-1,44,89,90,-1,44,91,89,-1,92,93,94,-1,92,27,93,-1,95,96,97,-1,96,98,97,-1,99,100,101,-1,99,102,100,-1,103,104,105,-1,105,106,103,-1,107,108,109,-1,108,110,109,-1,111,112,113,-1,114,115,116,-1,114,117,115,-1,118,119,120,-1,119,121,120,-1,122,123,124,-1,123,125,124,-1,126,127,128,-1,127,129,128,-1,130,83,131,-1,130,132,83,-1,52,133,134,-1,52,135,133,-1,134,50,52,-1,11,3,136,-1,11,10,3,-1,137,138,139,-1,137,140,138,-1,20,141,142,-1,20,143,141,-1,144,145,146,-1,147,148,149,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,158,159,156,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,166,169,167,-1,155,170,171,-1,145,144,172,-1,172,173,145,-1,174,175,176,-1,177,178,179,-1,177,180,178,-1,181,182,183,-1,184,185,186,-1,184,187,185,-1,188,189,190,-1,191,192,193,-1,191,194,192,-1,195,196,197,-1,198,199,200,-1,199,201,200,-1,202,203,204,-1,202,205,203,-1,206,207,208,-1,209,210,150,-1,211,212,213,-1,214,215,216,-1,217,218,219,-1,217,220,218,-1,175,221,222,-1,223,224,225,-1,226,227,228,-1,226,229,227,-1,227,230,231,-1,231,228,227,-1,232,233,234,-1,234,235,232,-1,236,237,238,-1,236,239,237,-1,240,241,242,-1,240,243,241,-1,244,245,246,-1,245,247,246,-1,248,249,250,-1,250,251,248,-1,252,253,192,-1,253,254,192,-1,201,151,255,-1,201,199,151,-1,256,257,258,-1,257,259,258,-1,260,261,262,-1,260,263,261,-1,264,265,266,-1,265,267,266,-1,268,269,172,-1,172,144,268,-1,270,170,271,-1,270,171,170,-1,195,272,273,-1,195,197,272,-1,253,274,254,-1,275,276,277,-1,278,279,280,-1,280,281,278,-1,282,283,284,-1,276,285,286,-1,287,168,288,-1,289,290,291,-1,289,292,290,-1,293,294,295,-1,296,297,298,-1,299,300,301,-1,299,244,300,-1,290,292,167,-1,167,302,290,-1,303,304,305,-1,306,307,308,-1,307,309,308,-1,310,311,312,-1,311,313,312,-1,314,159,315,-1,314,156,159,-1,302,231,232,-1,232,316,302,-1,317,318,319,-1,317,320,318,-1,321,322,323,-1,322,324,323,-1,325,322,326,-1,325,324,322,-1,327,325,34,-1,327,328,325,-1,192,254,193,-1,329,330,331,-1,329,332,330,-1,333,334,196,-1,315,335,314,-1,315,336,335,-1,337,338,339,-1,340,341,342,-1,341,343,342,-1,344,345,346,-1,347,33,32,-1,348,322,214,-1,348,326,322,-1,349,350,216,-1,350,214,216,-1,351,352,353,-1,351,354,352,-1,328,355,356,-1,319,323,357,-1,357,358,319,-1,356,359,360,-1,356,355,359,-1,358,357,361,-1,358,361,362,-1,361,363,362,-1,234,364,365,-1,365,366,234,-1,367,312,313,-1,368,369,370,-1,370,235,368,-1,371,372,373,-1,371,346,372,-1,374,375,170,-1,374,376,375,-1,377,378,347,-1,378,33,347,-1,379,238,380,-1,380,381,379,-1,382,128,383,-1,128,130,383,-1,384,385,386,-1,385,387,386,-1,388,352,389,-1,389,336,388,-1,390,391,281,-1,281,275,390,-1,392,256,258,-1,196,393,333,-1,196,195,393,-1,201,204,200,-1,201,202,204,-1,394,197,395,-1,396,397,198,-1,198,206,396,-1,139,398,399,-1,139,138,398,-1,131,383,130,-1,131,400,383,-1,401,273,272,-1,401,402,273,-1,403,404,405,-1,404,406,405,-1,137,407,140,-1,408,374,409,-1,408,376,374,-1,410,411,412,-1,411,413,412,-1,412,413,414,-1,413,415,414,-1,416,410,417,-1,410,412,417,-1,418,419,420,-1,420,421,418,-1,118,422,119,-1,118,423,422,-1,424,425,426,-1,424,427,425,-1,428,426,429,-1,428,430,426,-1,428,49,48,-1,428,429,49,-1,47,88,45,-1,431,136,432,-1,136,433,432,-1,21,434,23,-1,21,435,434,-1,436,437,438,-1,87,43,439,-1,87,64,43,-1,7,440,441,-1,7,4,440,-1,86,442,84,-1,77,443,444,-1,444,445,77,-1,446,79,447,-1,446,76,79,-1,448,447,449,-1,448,446,447,-1,450,451,452,-1,450,453,451,-1,129,73,58,-1,129,127,73,-1,289,454,455,-1,289,291,454,-1,166,168,287,-1,287,456,166,-1,298,218,457,-1,298,458,218,-1,459,164,460,-1,164,163,460,-1,461,462,463,-1,461,464,462,-1,465,466,461,-1,466,464,461,-1,467,468,469,-1,468,470,469,-1,471,472,473,-1,471,474,472,-1,456,475,166,-1,475,476,166,-1,477,478,479,-1,478,480,479,-1,223,267,265,-1,265,224,223,-1,479,161,481,-1,482,483,484,-1,483,268,484,-1,269,485,172,-1,269,486,485,-1,487,146,488,-1,487,484,146,-1,145,488,146,-1,31,28,489,-1,178,180,490,-1,491,300,263,-1,491,301,300,-1,300,492,263,-1,492,261,263,-1,492,493,261,-1,493,266,261,-1,494,495,496,-1,494,497,495,-1,498,499,500,-1,498,501,499,-1,502,503,504,-1,504,505,502,-1,175,506,176,-1,175,222,506,-1,507,508,498,-1,507,509,508,-1,510,511,500,-1,512,513,514,-1,512,515,513,-1,516,517,303,-1,303,305,516,-1,518,519,520,-1,521,516,522,-1,521,523,516,-1,524,525,411,-1,526,527,114,-1,528,529,100,-1,529,101,100,-1,102,530,531,-1,531,106,102,-1,532,533,104,-1,533,105,104,-1,534,416,418,-1,534,535,416,-1,536,73,127,-1,537,538,539,-1,537,540,538,-1,541,26,25,-1,25,542,541,-1,541,542,543,-1,543,544,541,-1,545,546,547,-1,547,548,545,-1,549,134,133,-1,72,550,551,-1,72,71,550,-1,552,553,66,-1,554,553,51,-1,553,552,51,-1,555,544,556,-1,555,541,544,-1,557,558,559,-1,557,560,558,-1,561,562,563,-1,561,564,562,-1,559,565,566,-1,559,567,565,-1,568,569,283,-1,568,570,569,-1,571,385,384,-1,384,572,571,-1,573,574,532,-1,573,572,574,-1,564,561,575,-1,561,122,575,-1,576,534,577,-1,576,578,534,-1,576,577,118,-1,118,120,576,-1,561,123,122,-1,562,564,141,-1,96,579,580,-1,96,581,579,-1,97,558,95,-1,558,582,95,-1,123,563,583,-1,123,561,563,-1,560,582,558,-1,560,584,582,-1,560,585,586,-1,560,557,585,-1,587,588,555,-1,587,589,588,-1,588,541,555,-1,588,26,541,-1,590,67,54,-1,54,591,590,-1,592,593,594,-1,594,586,592,-1,595,596,597,-1,597,598,595,-1,599,72,551,-1,599,65,72,-1,545,548,600,-1,24,601,27,-1,602,452,603,-1,452,604,603,-1,605,606,539,-1,539,538,605,-1,538,540,607,-1,607,608,538,-1,73,609,610,-1,73,536,609,-1,529,521,101,-1,529,611,521,-1,612,613,614,-1,527,411,114,-1,527,524,411,-1,524,615,525,-1,615,616,525,-1,515,512,617,-1,618,619,520,-1,618,620,619,-1,621,622,509,-1,621,623,622,-1,517,624,625,-1,513,626,627,-1,515,617,628,-1,628,629,515,-1,174,630,631,-1,174,176,630,-1,632,498,508,-1,632,501,498,-1,499,510,500,-1,499,633,510,-1,262,632,260,-1,262,501,632,-1,221,634,222,-1,634,635,222,-1,636,637,29,-1,637,30,29,-1,490,638,178,-1,638,639,178,-1,640,486,269,-1,640,160,486,-1,640,641,160,-1,640,642,641,-1,642,264,266,-1,266,493,642,-1,493,643,641,-1,641,642,493,-1,644,455,454,-1,454,645,644,-1,492,300,244,-1,244,246,492,-1,646,241,219,-1,241,217,219,-1,647,648,649,-1,649,243,647,-1,475,247,476,-1,247,245,476,-1,231,302,228,-1,302,167,228,-1,650,471,651,-1,471,473,651,-1,316,652,302,-1,316,653,652,-1,654,655,468,-1,468,467,654,-1,465,461,296,-1,296,656,465,-1,229,657,227,-1,229,297,657,-1,227,658,230,-1,227,657,658,-1,302,652,290,-1,291,659,454,-1,291,470,659,-1,660,645,454,-1,454,659,660,-1,661,662,663,-1,661,664,662,-1,57,132,129,-1,129,58,57,-1,59,78,82,-1,82,60,59,-1,665,666,445,-1,666,82,445,-1,665,667,668,-1,665,669,667,-1,670,671,63,-1,672,443,673,-1,672,444,443,-1,672,673,674,-1,673,675,674,-1,40,64,87,-1,40,39,64,-1,46,441,674,-1,674,41,46,-1,89,433,90,-1,433,1,90,-1,676,89,677,-1,89,91,677,-1,435,20,16,-1,435,21,20,-1,678,679,18,-1,678,680,679,-1,681,682,2,-1,2,683,681,-1,429,425,667,-1,429,426,425,-1,430,684,424,-1,424,426,430,-1,16,20,17,-1,20,142,17,-1,685,686,687,-1,685,688,686,-1,689,690,691,-1,689,692,690,-1,577,423,118,-1,577,421,423,-1,418,416,419,-1,416,417,419,-1,411,525,413,-1,525,693,413,-1,694,695,403,-1,415,696,697,-1,698,699,700,-1,698,701,699,-1,702,158,250,-1,158,157,250,-1,138,703,704,-1,138,140,703,-1,694,403,705,-1,403,405,705,-1,404,706,406,-1,706,707,406,-1,708,709,401,-1,708,710,709,-1,711,712,402,-1,402,713,711,-1,383,714,715,-1,383,400,714,-1,396,395,397,-1,396,394,395,-1,207,200,204,-1,255,202,201,-1,255,716,202,-1,716,717,718,-1,716,255,717,-1,719,212,720,-1,719,721,212,-1,722,723,331,-1,722,724,723,-1,385,725,387,-1,725,726,387,-1,284,569,727,-1,284,283,569,-1,728,596,729,-1,728,730,596,-1,729,595,382,-1,729,596,595,-1,280,731,257,-1,280,279,731,-1,631,630,732,-1,732,733,631,-1,734,735,278,-1,736,737,391,-1,391,738,736,-1,736,236,238,-1,238,379,736,-1,377,347,739,-1,739,738,377,-1,740,741,742,-1,742,743,740,-1,373,338,744,-1,373,372,338,-1,650,651,745,-1,651,341,745,-1,746,369,747,-1,747,748,749,-1,749,750,747,-1,748,751,270,-1,316,232,235,-1,235,370,316,-1,311,752,313,-1,753,360,359,-1,356,361,357,-1,356,360,361,-1,356,325,328,-1,356,324,325,-1,327,353,307,-1,327,351,353,-1,320,215,321,-1,321,318,320,-1,754,349,216,-1,754,462,349,-1,350,755,214,-1,755,348,214,-1,37,326,348,-1,37,38,326,-1,345,35,37,-1,345,344,35,-1,347,756,739,-1,347,757,756,-1,239,758,237,-1,338,372,755,-1,755,339,338,-1,346,340,344,-1,340,342,344,-1,341,759,343,-1,341,651,759,-1,193,254,760,-1,760,761,193,-1,331,330,762,-1,762,722,331,-1,344,763,35,-1,358,362,764,-1,464,349,462,-1,464,337,349,-1,339,755,350,-1,323,356,357,-1,323,324,356,-1,765,367,313,-1,313,153,765,-1,373,471,650,-1,373,474,471,-1,373,766,474,-1,745,767,371,-1,299,768,242,-1,299,301,768,-1,184,635,187,-1,769,770,771,-1,657,297,463,-1,309,367,308,-1,772,773,774,-1,773,775,774,-1,286,285,718,-1,718,717,286,-1,663,659,776,-1,663,660,659,-1,741,750,777,-1,741,740,750,-1,509,503,508,-1,778,687,691,-1,778,685,687,-1,779,111,108,-1,53,566,780,-1,53,781,566,-1,782,565,113,-1,113,112,782,-1,718,258,259,-1,150,255,151,-1,783,724,393,-1,212,784,213,-1,212,721,784,-1,299,646,244,-1,646,245,244,-1,753,359,308,-1,308,785,753,-1,483,269,268,-1,483,640,269,-1,262,261,266,-1,266,267,262,-1,786,263,260,-1,786,491,263,-1,634,787,788,-1,634,789,787,-1,790,717,210,-1,790,286,717,-1,720,332,719,-1,720,293,332,-1,497,488,495,-1,497,487,488,-1,641,161,160,-1,641,481,161,-1,646,242,241,-1,646,299,242,-1,235,366,368,-1,235,234,366,-1,364,753,365,-1,364,363,753,-1,264,642,640,-1,499,501,223,-1,458,791,218,-1,791,219,218,-1,328,306,355,-1,784,792,213,-1,152,793,294,-1,390,275,277,-1,716,205,202,-1,716,794,205,-1,394,272,197,-1,194,156,192,-1,194,157,156,-1,788,181,183,-1,788,787,181,-1,242,768,795,-1,179,178,796,-1,172,797,173,-1,769,771,798,-1,798,799,769,-1,155,773,153,-1,773,765,153,-1,458,298,297,-1,297,229,458,-1,623,305,304,-1,647,800,648,-1,791,169,801,-1,791,226,169,-1,162,644,645,-1,154,153,752,-1,153,313,752,-1,802,148,147,-1,747,750,740,-1,740,746,747,-1,742,803,654,-1,654,467,742,-1,804,143,19,-1,143,20,19,-1,564,688,142,-1,142,141,564,-1,805,589,562,-1,806,139,807,-1,806,137,139,-1,82,78,77,-1,77,445,82,-1,445,444,665,-1,444,808,665,-1,674,441,440,-1,440,672,674,-1,75,74,809,-1,809,810,75,-1,811,591,812,-1,811,556,591,-1,526,116,813,-1,526,114,116,-1,113,567,814,-1,113,565,567,-1,111,110,108,-1,111,815,110,-1,106,105,100,-1,100,102,106,-1,522,99,521,-1,99,101,521,-1,600,70,545,-1,91,27,677,-1,91,93,27,-1,44,93,91,-1,814,98,815,-1,60,81,61,-1,80,61,816,-1,80,59,61,-1,74,73,610,-1,610,809,74,-1,72,65,69,-1,65,68,69,-1,85,443,77,-1,77,76,85,-1,817,818,62,-1,819,79,80,-1,453,450,820,-1,94,671,450,-1,450,92,94,-1,821,670,63,-1,63,62,821,-1,5,8,6,-1,88,437,45,-1,437,436,45,-1,436,438,1,-1,438,90,1,-1,43,42,439,-1,177,29,31,-1,179,796,636,-1,588,24,26,-1,679,822,435,-1,822,434,435,-1,823,11,431,-1,11,136,431,-1,679,824,822,-1,825,826,531,-1,825,578,826,-1,2,682,0,-1,682,46,0,-1,827,808,440,-1,440,4,827,-1,667,49,429,-1,667,669,49,-1,827,6,9,-1,827,4,6,-1,667,425,668,-1,3,433,136,-1,3,1,433,-1,10,12,683,-1,3,683,2,-1,3,10,683,-1,669,9,49,-1,669,827,9,-1,46,7,441,-1,682,7,46,-1,578,828,826,-1,578,576,828,-1,434,823,431,-1,822,823,434,-1,433,676,432,-1,433,89,676,-1,177,636,29,-1,177,179,636,-1,37,755,345,-1,37,348,755,-1,45,1,0,-1,1,45,436,-1,437,87,439,-1,437,88,87,-1,821,820,670,-1,821,829,820,-1,94,63,671,-1,94,43,63,-1,450,602,92,-1,452,602,450,-1,451,604,452,-1,451,830,604,-1,831,832,549,-1,831,833,832,-1,673,442,675,-1,84,442,673,-1,834,71,70,-1,550,71,834,-1,75,56,58,-1,835,56,75,-1,453,829,836,-1,820,829,453,-1,540,819,607,-1,540,837,819,-1,838,839,537,-1,838,836,839,-1,115,531,530,-1,531,115,825,-1,113,815,111,-1,815,113,814,-1,612,813,116,-1,813,612,614,-1,840,811,812,-1,583,811,840,-1,556,590,591,-1,556,544,590,-1,542,602,603,-1,602,542,25,-1,546,70,69,-1,545,70,546,-1,841,609,536,-1,842,609,841,-1,810,835,75,-1,608,835,810,-1,609,549,610,-1,134,549,609,-1,86,817,442,-1,818,817,86,-1,444,440,808,-1,444,672,440,-1,684,843,424,-1,843,684,844,-1,845,846,847,-1,846,845,690,-1,403,692,848,-1,403,695,692,-1,849,807,714,-1,849,806,807,-1,589,850,588,-1,589,805,850,-1,469,851,743,-1,469,653,851,-1,743,746,740,-1,851,746,743,-1,646,791,801,-1,219,791,646,-1,169,476,801,-1,169,166,476,-1,480,644,479,-1,455,644,480,-1,852,292,289,-1,852,288,292,-1,765,772,785,-1,765,773,772,-1,511,853,618,-1,853,511,510,-1,853,798,854,-1,799,798,853,-1,855,31,734,-1,31,855,856,-1,505,186,185,-1,186,505,504,-1,304,622,623,-1,304,857,622,-1,787,768,181,-1,787,795,768,-1,207,203,208,-1,204,203,207,-1,794,718,259,-1,794,716,718,-1,649,165,858,-1,648,165,649,-1,754,215,320,-1,754,216,215,-1,859,363,364,-1,859,362,363,-1,365,785,772,-1,785,365,753,-1,774,368,366,-1,774,860,368,-1,171,751,775,-1,751,171,270,-1,163,380,460,-1,163,638,380,-1,163,800,638,-1,861,641,643,-1,861,481,641,-1,162,486,160,-1,162,862,486,-1,863,375,864,-1,863,865,375,-1,485,664,866,-1,485,662,664,-1,867,149,148,-1,867,145,149,-1,867,488,145,-1,495,488,867,-1,868,769,225,-1,868,770,769,-1,869,494,496,-1,870,494,869,-1,871,872,873,-1,871,802,872,-1,784,874,335,-1,784,721,874,-1,760,274,723,-1,760,254,274,-1,393,722,333,-1,393,724,722,-1,719,329,875,-1,329,719,332,-1,209,293,720,-1,209,294,293,-1,793,876,877,-1,876,793,878,-1,285,258,718,-1,258,285,392,-1,276,790,277,-1,276,286,790,-1,735,279,278,-1,279,735,733,-1,30,174,28,-1,174,30,175,-1,786,181,491,-1,182,181,786,-1,764,859,658,-1,859,764,362,-1,638,647,639,-1,800,647,638,-1,802,879,872,-1,802,147,879,-1,150,294,209,-1,294,150,152,-1,634,637,789,-1,637,634,221,-1,880,705,726,-1,880,704,705,-1,565,780,566,-1,780,565,782,-1,781,55,881,-1,55,781,53,-1,124,111,779,-1,112,111,124,-1,420,423,421,-1,882,423,420,-1,687,689,691,-1,687,422,689,-1,778,17,685,-1,883,17,778,-1,828,103,826,-1,828,107,103,-1,653,470,652,-1,470,653,469,-1,468,659,470,-1,468,776,659,-1,367,884,312,-1,884,367,309,-1,751,747,860,-1,751,748,747,-1,785,367,765,-1,308,367,785,-1,757,885,756,-1,885,757,763,-1,886,657,463,-1,886,658,657,-1,887,186,857,-1,887,184,186,-1,297,461,463,-1,297,296,461,-1,155,775,773,-1,171,775,155,-1,319,321,323,-1,321,319,318,-1,464,338,337,-1,466,338,464,-1,326,34,325,-1,326,38,34,-1,394,13,708,-1,394,888,13,-1,889,193,761,-1,889,191,193,-1,606,834,890,-1,833,834,606,-1,891,513,892,-1,891,514,513,-1,758,759,459,-1,758,343,759,-1,459,237,758,-1,459,460,237,-1,758,756,885,-1,756,758,239,-1,344,885,763,-1,344,342,885,-1,354,33,378,-1,33,354,351,-1,214,321,215,-1,214,322,321,-1,352,884,353,-1,352,388,884,-1,312,388,310,-1,312,884,388,-1,749,270,271,-1,749,748,270,-1,893,863,894,-1,893,865,863,-1,749,777,750,-1,777,749,893,-1,369,851,370,-1,369,746,851,-1,895,741,777,-1,896,741,895,-1,340,745,341,-1,745,340,767,-1,744,466,897,-1,744,338,466,-1,741,803,742,-1,741,896,803,-1,236,738,739,-1,736,738,236,-1,737,379,855,-1,736,379,737,-1,489,734,31,-1,734,489,735,-1,391,278,281,-1,737,278,391,-1,733,731,279,-1,733,732,731,-1,732,898,899,-1,732,630,898,-1,900,257,731,-1,257,900,259,-1,900,901,902,-1,900,899,901,-1,903,904,523,-1,903,901,904,-1,794,905,205,-1,794,902,905,-1,611,905,903,-1,905,611,906,-1,529,906,611,-1,906,529,907,-1,907,528,908,-1,907,529,528,-1,909,188,908,-1,189,188,909,-1,572,910,574,-1,384,910,572,-1,382,715,729,-1,382,383,715,-1,911,729,715,-1,911,728,729,-1,727,911,399,-1,727,728,911,-1,399,284,727,-1,398,284,399,-1,726,282,880,-1,725,282,726,-1,912,910,913,-1,912,189,910,-1,354,914,915,-1,354,378,914,-1,916,390,277,-1,916,914,390,-1,277,211,916,-1,211,277,790,-1,213,916,211,-1,213,792,916,-1,389,335,336,-1,335,389,784,-1,760,712,761,-1,783,712,760,-1,295,762,330,-1,762,295,877,-1,877,294,793,-1,877,295,294,-1,196,876,917,-1,876,196,334,-1,151,918,878,-1,151,199,918,-1,917,197,196,-1,197,917,395,-1,394,919,888,-1,394,396,919,-1,913,920,912,-1,707,920,913,-1,406,387,405,-1,406,386,387,-1,911,714,807,-1,714,911,715,-1,761,711,889,-1,761,712,711,-1,709,402,401,-1,709,713,402,-1,708,15,710,-1,15,708,13,-1,706,920,707,-1,706,14,920,-1,694,704,703,-1,704,694,705,-1,702,752,158,-1,702,154,752,-1,194,699,251,-1,699,194,191,-1,889,921,700,-1,921,889,711,-1,713,697,922,-1,697,713,709,-1,702,374,154,-1,409,374,702,-1,251,701,248,-1,701,251,699,-1,923,700,921,-1,923,698,700,-1,696,922,697,-1,696,924,922,-1,710,414,415,-1,414,710,15,-1,925,14,706,-1,925,926,14,-1,404,848,927,-1,848,404,403,-1,695,703,846,-1,703,695,694,-1,843,140,407,-1,843,847,140,-1,248,928,879,-1,928,248,701,-1,923,892,698,-1,923,891,892,-1,924,693,929,-1,693,924,696,-1,926,419,417,-1,419,926,925,-1,882,927,848,-1,882,420,927,-1,930,408,931,-1,930,376,408,-1,928,872,879,-1,627,872,928,-1,929,514,891,-1,514,929,616,-1,422,686,119,-1,422,687,686,-1,778,690,845,-1,691,690,778,-1,883,845,844,-1,883,778,845,-1,688,17,142,-1,685,17,688,-1,680,684,430,-1,680,678,684,-1,932,48,8,-1,932,933,48,-1,682,5,7,-1,681,5,682,-1,934,935,933,-1,824,935,934,-1,680,824,679,-1,824,680,935,-1,22,804,19,-1,22,936,804,-1,601,677,27,-1,601,936,677,-1,601,588,850,-1,601,24,588,-1,92,25,27,-1,25,92,602,-1,41,675,39,-1,41,674,675,-1,808,669,665,-1,827,669,808,-1,449,821,448,-1,821,449,829,-1,839,447,837,-1,839,449,447,-1,425,806,849,-1,425,427,806,-1,937,665,668,-1,665,937,666,-1,400,666,937,-1,666,400,131,-1,666,83,82,-1,131,83,666,-1,57,83,132,-1,57,81,83,-1,862,663,662,-1,862,660,663,-1,664,894,863,-1,894,664,661,-1,661,895,894,-1,895,661,938,-1,776,655,938,-1,468,655,776,-1,939,220,858,-1,939,940,220,-1,462,886,463,-1,886,462,754,-1,941,457,940,-1,941,656,457,-1,939,942,943,-1,942,939,164,-1,656,944,465,-1,944,656,941,-1,473,943,942,-1,473,472,943,-1,803,655,654,-1,803,896,655,-1,467,743,742,-1,743,467,469,-1,465,897,466,-1,766,465,944,-1,465,766,897,-1,169,228,167,-1,169,226,228,-1,287,478,456,-1,287,945,478,-1,475,861,247,-1,861,475,477,-1,241,649,217,-1,241,243,649,-1,801,245,646,-1,476,245,801,-1,246,493,492,-1,643,493,246,-1,477,481,861,-1,477,479,481,-1,482,265,483,-1,224,265,482,-1,931,797,930,-1,173,797,931,-1,638,381,380,-1,381,638,490,-1,789,636,796,-1,636,789,637,-1,795,240,242,-1,796,240,795,-1,768,491,181,-1,768,301,491,-1,788,635,634,-1,635,788,187,-1,224,868,225,-1,868,224,482,-1,867,802,871,-1,802,867,148,-1,626,869,873,-1,869,626,629,-1,628,798,870,-1,798,628,854,-1,624,630,176,-1,624,898,630,-1,625,184,887,-1,625,506,184,-1,620,628,617,-1,620,854,628,-1,513,629,626,-1,513,515,629,-1,898,517,904,-1,517,898,624,-1,517,887,303,-1,517,625,887,-1,946,509,507,-1,946,621,509,-1,618,519,511,-1,520,519,618,-1,620,512,619,-1,620,617,512,-1,947,946,948,-1,947,621,946,-1,615,619,512,-1,615,949,619,-1,613,947,614,-1,613,305,947,-1,526,948,518,-1,526,813,948,-1,524,949,615,-1,524,527,949,-1,612,522,613,-1,522,612,99,-1,530,116,115,-1,530,612,116,-1,535,410,416,-1,117,410,535,-1,908,533,909,-1,528,533,908,-1,605,608,810,-1,538,608,605,-1,537,950,838,-1,537,539,950,-1,830,838,950,-1,838,830,451,-1,890,70,600,-1,70,890,834,-1,133,831,549,-1,133,135,831,-1,951,69,68,-1,546,69,951,-1,593,50,842,-1,593,592,50,-1,841,595,598,-1,595,841,126,-1,597,593,598,-1,593,597,594,-1,554,586,585,-1,554,592,586,-1,553,55,66,-1,55,553,881,-1,805,804,850,-1,143,804,805,-1,555,811,587,-1,556,811,555,-1,557,881,585,-1,557,781,881,-1,584,586,594,-1,584,560,586,-1,730,597,596,-1,730,952,597,-1,584,570,582,-1,584,952,570,-1,780,812,53,-1,812,780,840,-1,589,563,562,-1,563,589,587,-1,782,840,780,-1,782,125,840,-1,581,95,568,-1,95,581,96,-1,725,581,282,-1,581,725,579,-1,580,571,953,-1,571,580,579,-1,98,567,97,-1,814,567,98,-1,98,580,815,-1,580,98,96,-1,575,119,686,-1,121,119,575,-1,120,954,955,-1,954,120,121,-1,573,110,953,-1,109,110,573,-1,109,532,104,-1,109,573,532,-1,418,577,534,-1,418,421,577,-1,953,815,580,-1,815,953,110,-1,122,121,575,-1,121,122,954,-1,686,564,575,-1,686,688,564,-1,572,953,571,-1,573,953,572,-1,385,579,725,-1,385,571,579,-1,568,282,581,-1,568,283,282,-1,558,567,559,-1,97,567,558,-1,568,582,570,-1,582,568,95,-1,562,143,805,-1,141,143,562,-1,583,587,811,-1,587,583,563,-1,781,559,566,-1,781,557,559,-1,569,952,730,-1,952,569,570,-1,594,952,584,-1,952,594,597,-1,54,812,591,-1,54,53,812,-1,553,585,881,-1,553,554,585,-1,598,842,841,-1,598,593,842,-1,592,51,50,-1,554,51,592,-1,135,599,551,-1,52,599,135,-1,68,590,951,-1,68,67,590,-1,831,551,550,-1,831,135,551,-1,832,810,809,-1,832,605,810,-1,604,547,603,-1,548,547,604,-1,950,600,830,-1,600,950,890,-1,539,890,950,-1,539,606,890,-1,535,578,825,-1,535,534,578,-1,532,909,533,-1,532,574,909,-1,105,528,100,-1,533,528,105,-1,117,825,115,-1,117,535,825,-1,117,411,410,-1,117,114,411,-1,530,99,612,-1,530,102,99,-1,527,518,949,-1,527,526,518,-1,948,614,947,-1,614,948,813,-1,305,522,516,-1,305,613,522,-1,616,512,514,-1,615,512,616,-1,520,949,518,-1,949,520,619,-1,519,948,946,-1,519,518,948,-1,623,947,305,-1,947,623,621,-1,904,516,523,-1,516,904,517,-1,511,946,507,-1,519,946,511,-1,854,618,853,-1,620,618,854,-1,500,507,498,-1,511,507,500,-1,503,622,504,-1,509,622,503,-1,506,624,176,-1,625,624,506,-1,506,635,184,-1,222,635,506,-1,629,870,869,-1,870,629,628,-1,627,873,872,-1,873,627,626,-1,871,495,867,-1,871,496,495,-1,494,770,497,-1,494,771,770,-1,267,501,262,-1,501,267,223,-1,260,502,786,-1,502,260,632,-1,505,786,502,-1,182,786,505,-1,789,795,787,-1,789,796,795,-1,639,796,178,-1,639,240,796,-1,490,856,381,-1,856,490,180,-1,149,173,931,-1,149,145,173,-1,866,930,797,-1,866,864,930,-1,485,797,172,-1,485,866,797,-1,144,484,268,-1,484,144,146,-1,484,868,482,-1,868,484,487,-1,945,480,478,-1,480,945,852,-1,456,477,475,-1,456,478,477,-1,474,944,472,-1,474,766,944,-1,370,653,316,-1,851,653,370,-1,473,759,651,-1,473,942,759,-1,472,941,943,-1,472,944,941,-1,942,459,759,-1,942,164,459,-1,943,940,939,-1,943,941,940,-1,457,296,298,-1,656,296,457,-1,858,164,939,-1,165,164,858,-1,940,218,220,-1,940,457,218,-1,938,896,895,-1,655,896,938,-1,663,938,661,-1,663,776,938,-1,162,660,862,-1,162,645,660,-1,937,714,400,-1,937,849,714,-1,668,849,937,-1,849,668,425,-1,837,79,819,-1,79,837,447,-1,836,449,839,-1,836,829,449,-1,450,670,820,-1,450,671,670,-1,62,448,821,-1,448,62,818,-1,818,446,448,-1,446,818,86,-1,86,76,446,-1,76,86,85,-1,850,936,601,-1,936,850,804,-1,936,676,677,-1,936,22,676,-1,434,432,23,-1,434,431,432,-1,934,822,824,-1,934,823,822,-1,933,12,934,-1,12,933,932,-1,8,681,932,-1,681,8,5,-1,933,428,48,-1,933,935,428,-1,430,935,680,-1,428,935,430,-1,883,18,17,-1,883,678,18,-1,678,844,684,-1,883,844,678,-1,929,525,616,-1,929,693,525,-1,892,627,928,-1,627,892,513,-1,149,408,147,-1,931,408,149,-1,848,689,882,-1,689,848,692,-1,925,420,419,-1,420,925,927,-1,417,414,926,-1,417,412,414,-1,413,696,415,-1,413,693,696,-1,929,923,924,-1,929,891,923,-1,928,698,892,-1,928,701,698,-1,409,147,408,-1,147,409,249,-1,424,407,427,-1,424,843,407,-1,847,703,140,-1,846,703,847,-1,927,706,404,-1,927,925,706,-1,15,926,414,-1,926,15,14,-1,921,924,923,-1,924,921,922,-1,249,702,250,-1,249,409,702,-1,415,709,710,-1,415,697,709,-1,922,711,713,-1,922,921,711,-1,700,191,889,-1,191,700,699,-1,427,137,806,-1,427,407,137,-1,13,920,14,-1,13,888,920,-1,315,388,336,-1,315,310,388,-1,273,712,783,-1,402,712,273,-1,807,399,911,-1,807,139,399,-1,726,405,387,-1,705,405,726,-1,386,707,913,-1,406,707,386,-1,912,888,919,-1,920,888,912,-1,190,396,206,-1,396,190,919,-1,918,395,917,-1,395,918,397,-1,917,878,918,-1,878,917,876,-1,720,211,209,-1,720,212,211,-1,874,253,252,-1,253,874,875,-1,915,784,389,-1,915,792,784,-1,792,914,916,-1,792,915,914,-1,790,209,211,-1,790,210,209,-1,256,275,281,-1,392,275,256,-1,738,390,377,-1,390,738,391,-1,914,377,390,-1,914,378,377,-1,354,389,352,-1,354,915,389,-1,919,189,912,-1,190,189,919,-1,384,913,910,-1,913,384,386,-1,284,880,282,-1,284,398,880,-1,727,730,728,-1,727,569,730,-1,126,382,595,-1,128,382,126,-1,189,574,910,-1,189,909,574,-1,208,908,188,-1,208,907,908,-1,907,203,906,-1,208,203,907,-1,205,906,203,-1,205,905,906,-1,523,611,903,-1,523,521,611,-1,902,903,905,-1,902,901,903,-1,902,259,900,-1,794,259,902,-1,901,898,904,-1,899,898,901,-1,731,899,900,-1,731,732,899,-1,381,855,379,-1,381,856,855,-1,154,170,155,-1,170,154,374,-1,376,864,375,-1,376,930,864,-1,371,340,346,-1,767,340,371,-1,777,894,895,-1,777,893,894,-1,893,271,865,-1,893,749,271,-1,364,233,859,-1,234,233,364,-1,360,363,361,-1,360,753,363,-1,309,353,884,-1,307,353,309,-1,319,764,317,-1,358,764,319,-1,351,34,33,-1,34,351,327,-1,885,343,758,-1,885,342,343,-1,337,350,349,-1,350,337,339,-1,833,605,832,-1,833,606,605,-1,329,723,274,-1,329,331,723,-1,397,199,198,-1,397,918,199,-1,708,272,394,-1,401,272,708,-1,721,875,874,-1,721,719,875,-1,36,763,757,-1,763,36,35,-1,32,757,347,-1,32,36,757,-1,772,366,365,-1,366,772,774,-1,859,230,658,-1,859,233,230,-1,159,310,315,-1,159,311,310,-1,307,328,327,-1,328,307,306,-1,745,373,650,-1,745,371,373,-1,373,897,766,-1,373,744,897,-1,857,303,887,-1,304,303,857,-1,632,503,502,-1,508,503,632,-1,369,860,747,-1,368,860,369,-1,293,330,332,-1,330,293,295,-1,852,287,288,-1,945,287,852,-1,291,652,470,-1,291,290,652,-1,828,108,107,-1,955,108,828,-1,531,103,106,-1,826,103,531,-1,882,422,423,-1,689,422,882,-1,112,125,782,-1,112,124,125,-1,704,398,138,-1,398,704,880,-1,483,264,640,-1,264,483,265,-1,221,30,637,-1,221,175,30,-1,251,157,194,-1,157,251,250,-1,633,223,225,-1,499,223,633,-1,320,886,754,-1,320,317,886,-1,631,735,489,-1,733,735,631,-1,281,257,256,-1,281,280,257,-1,392,276,275,-1,392,285,276,-1,150,717,255,-1,150,210,717,-1,878,152,151,-1,878,793,152,-1,877,334,762,-1,334,877,876,-1,762,333,722,-1,333,762,334,-1,723,783,760,-1,724,783,723,-1,875,274,253,-1,875,329,274,-1,335,252,314,-1,252,335,874,-1,393,273,783,-1,393,195,273,-1,249,879,147,-1,879,249,248,-1,873,496,871,-1,869,496,873,-1,870,771,494,-1,798,771,870,-1,497,868,487,-1,770,868,497,-1,486,662,485,-1,486,862,662,-1,863,866,664,-1,866,863,864,-1,170,865,271,-1,375,865,170,-1,247,643,246,-1,247,861,643,-1,639,243,240,-1,639,647,243,-1,460,238,237,-1,238,460,380,-1,739,239,236,-1,739,756,239,-1,860,775,751,-1,775,860,774,-1,231,233,232,-1,231,230,233,-1,359,306,308,-1,355,306,359,-1,317,658,886,-1,764,658,317,-1,229,791,458,-1,791,229,226,-1,648,163,165,-1,163,648,800,-1,858,217,649,-1,858,220,217,-1,198,207,206,-1,198,200,207,-1,188,206,208,-1,206,188,190,-1,192,314,252,-1,192,156,314,-1,183,187,788,-1,187,183,185,-1,857,504,622,-1,857,186,504,-1,185,182,505,-1,185,183,182,-1,489,174,631,-1,28,174,489,-1,856,177,31,-1,177,856,180,-1,737,734,278,-1,734,737,855,-1,853,633,799,-1,853,510,633,-1,288,167,292,-1,167,288,168,-1,455,852,289,-1,480,852,455,-1,644,161,479,-1,644,162,161,-1,158,311,159,-1,311,158,752,-1,225,799,633,-1,799,225,769,-1,692,846,690,-1,695,846,692,-1,844,847,843,-1,847,844,845,-1,12,823,934,-1,12,11,823,-1,43,93,44,-1,43,94,93,-1,546,543,547,-1,951,543,546,-1,608,816,835,-1,607,816,608,-1,130,129,132,-1,128,129,130,-1,536,126,841,-1,536,127,126,-1,842,134,609,-1,50,134,842,-1,603,543,542,-1,603,547,543,-1,951,544,543,-1,544,951,590,-1,125,583,840,-1,123,583,125,-1,122,779,954,-1,779,122,124,-1,108,954,779,-1,955,954,108,-1,109,103,107,-1,103,109,104,-1,437,42,438,-1,439,42,437,-1,81,56,61,-1,56,81,57,-1,451,836,838,-1,836,451,453,-1,537,837,540,-1,537,839,837,-1,607,80,816,-1,607,819,80,-1,817,64,39,-1,817,62,64,-1,442,39,675,-1,39,442,817,-1,443,84,673,-1,85,84,443,-1,56,816,61,-1,56,835,816,-1,832,610,549,-1,832,809,610,-1,833,550,834,-1,831,550,833,-1,55,67,66,-1,54,67,55,-1,548,830,600,-1,830,548,604,-1,552,52,51,-1,552,599,52,-1,599,66,65,-1,599,552,66,-1,41,47,46,-1,41,40,47,-1,90,42,44,-1,438,42,90,-1,38,32,34,-1,36,32,38,-1,372,345,755,-1,346,345,372,-1,22,432,676,-1,23,432,22,-1,679,16,18,-1,679,435,16,-1,955,576,120,-1,576,955,828,-1,683,932,681,-1,683,12,932,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rtibia_Coord',point=[(-1.6899,2.58667,-2.48132),(-1.70418,2.6087,-2.56478),(-1.66334,2.63436,-2.459),(-1.74679,2.78753,-2.4969),(-1.77876,2.6986,-2.01105),(-1.69656,2.68868,-2.09917),(-1.76745,2.78557,-2.00736),(-1.6898,2.53869,-2.1644),(-1.77627,2.96943,-2.00386),(-1.80131,2.87186,-1.95008),(-1.76691,2.89976,-2.43282),(-1.80201,3.00224,-2.49709),(-1.78209,3.03896,-2.33704),(-2.6873,11.32604,-.98244),(-2.57649,10.4456,-1.20009),(-2.58153,11.33432,-1.10455),(-2.10695,3.80159,-2.55952),(-2.08401,3.94967,-2.53175),(-2.08492,3.81752,-2.50431),(-2.15075,3.52364,-2.72617),(-2.15874,3.76191,-2.64825),(-2.10676,3.55536,-2.67462),(-2.1028,3.3576,-2.70654),(-2.05568,3.38303,-2.67276),(-2.26254,3.16752,-3.05392),(-2.34263,3.0016,-3.00859),(-2.33331,3.12858,-3.1269),(-2.16989,3.00101,-2.90572),(-4.21005,14.84837,-1.34484),(-4.24117,14.9553,-1.41215),(-4.19933,14.8509,-1.40107),(-4.22298,14.97451,-1.20209),(-3.3383,15.59043,-.66677),(-3.26625,15.58231,-.61083),(-3.21241,15.59736,-.82442),(-3.35709,15.6221,-.73623),(-3.34895,15.60112,-.69331),(-3.29082,15.62178,-.85478),(-3.24432,15.60823,-.84537),(-1.85939,2.4307,-2.34666),(-1.81495,2.43372,-2.35494),(-1.80986,2.41673,-2.33642),(-1.90874,2.69612,-2.67574),(-2.07071,2.76686,-2.66785),(-1.91688,2.71771,-2.69578),(-1.71411,2.58261,-2.4868),(-1.70989,2.45666,-2.30629),(-1.72658,2.47115,-2.32618),(-1.87428,3.17876,-1.96964),(-1.89991,3.07195,-1.87868),(-3.08971,2.9953,-2.588),(-2.96427,3.05122,-2.76134),(-2.9605,2.99398,-2.75621),(-2.92423,3.54533,-2.98229),(-2.90105,3.39147,-3.08571),(-2.91521,3.39097,-3.06258),(-2.68603,2.56972,-2.16035),(-2.69669,2.65087,-2.10147),(-2.87024,2.55907,-2.21927),(-2.31987,2.70637,-2.06097),(-2.37418,2.71013,-2.02391),(-2.44953,2.59864,-2.086),(-2.06123,2.71827,-2.49854),(-2.08671,2.76823,-2.64431),(-2.03774,2.702,-2.50493),(-2.93259,2.85986,-3.441),(-2.92519,3.07145,-3.34831),(-2.91163,3.07793,-3.36383),(-2.91352,2.84972,-3.44778),(-2.93411,2.74717,-3.3634),(-2.87421,2.69061,-3.27137),(-2.89235,2.70889,-3.26157),(-2.94497,2.76515,-3.34528),(-3.04668,2.59907,-2.27937),(-3.02826,2.58983,-2.29419),(-2.86252,2.55828,-2.24054),(-2.09913,2.75929,-2.03408),(-2.09038,2.75757,-2.01151),(-2.19796,2.81332,-2.02998),(-2.2068,2.82,-2.05226),(-2.32713,2.70735,-2.08194),(-2.46455,2.68131,-2.02899),(-2.26661,2.79625,-1.92168),(-2.47635,2.74518,-1.94945),(-1.94087,2.51516,-2.11993),(-2.02717,2.66521,-2.0369),(-2.03617,2.65021,-2.17238),(-1.8997,2.6614,-2.4622),(-1.79945,2.62291,-2.4528),(-1.94955,2.94885,-2.59366),(-1.8059,2.68405,-2.63143),(-1.98313,2.88137,-2.71875),(-2.23659,2.91292,-2.86977),(-2.05234,2.82509,-2.80038),(-2.16059,2.84468,-2.76263),(-3.07467,4.38148,-2.48179),(-3.05969,4.86735,-2.43516),(-3.04683,4.36723,-2.56104),(-3.00039,4.87866,-2.51023),(-3.22133,12.36691,-1.66551),(-3.21587,11.37463,-1.61766),(-3.33958,12.33947,-1.47744),(-3.09099,11.3921,-1.7264),(-2.8323,9.23596,-1.92084),(-2.94482,9.22775,-1.91327),(-3.08994,10.52722,-1.74994),(-2.99056,10.53358,-1.79043),(-2.79405,7.95188,-2.03868),(-2.73908,6.82577,-2.22598),(-2.90516,7.95381,-2.04152),(-2.8937,6.82745,-2.20129),(-2.78505,5.85341,-2.41242),(-2.79119,4.88622,-2.60061),(-2.89583,4.88244,-2.5554),(-2.67676,12.43273,-1.916),(-2.71292,11.41711,-1.92772),(-2.81699,12.41954,-1.90358),(-2.59747,11.41416,-1.91025),(-2.25814,6.8206,-2.31397),(-2.17705,5.88517,-2.47188),(-2.36783,6.82385,-2.3098),(-2.33843,5.89618,-2.51381),(-2.45906,4.88947,-2.7287),(-2.55588,4.40514,-2.84807),(-2.6699,4.89316,-2.66675),(-2.70408,4.38987,-2.78247),(-3.05261,2.86288,-2.19371),(-3.07599,2.75741,-2.21886),(-2.9277,2.79266,-2.06975),(-2.92864,2.72056,-2.10425),(-2.71929,2.79044,-1.98409),(-2.49526,2.86491,-1.8748),(-2.70955,2.71684,-2.01524),(-3.05511,2.89627,-2.63079),(-3.07637,2.89192,-2.57733),(-2.97643,2.90406,-2.75484),(-1.82009,2.99052,-2.5323),(-2.32582,3.71885,-1.87384),(-2.43468,4.24258,-1.94798),(-2.46905,3.67292,-1.89853),(-2.2705,4.22916,-1.948),(-2.22287,3.91729,-2.69884),(-2.14096,3.94712,-2.60853),(-2.2238,3.72953,-2.7621),(-2.01031,15.45375,-2.45141),(-1.74007,15.28372,-2.15873),(-2.0193,15.38407,-2.40456),(-1.6784,15.16729,-1.47831),(-1.68157,15.17082,-1.85484),(-1.66362,15.24544,-1.85672),(-3.37113,14.13109,-.36002),(-3.35107,14.11056,-.35344),(-3.34197,14.13632,-.34596),(-2.12303,15.76205,-.73992),(-2.06276,15.69648,-.73133),(-2.08319,15.79727,-.75238),(-2.31291,15.06841,-.61314),(-2.21009,15.08451,-.68208),(-2.10001,15.44884,-.68063),(-2.1672,15.43412,-.64919),(-2.56617,15.66105,-2.50444),(-2.597,15.65978,-2.48067),(-2.56514,15.68237,-2.48489),(-4.36295,15.51522,-1.46623),(-4.21846,15.57152,-1.55789),(-4.29765,15.52552,-1.66117),(-3.04165,15.73298,-1.95864),(-2.84976,15.89815,-1.85862),(-2.8564,15.87712,-1.87169),(-3.06138,15.75391,-1.95137),(-1.74847,15.78996,-1.07557),(-2.08491,15.82621,-.80681),(-2.00732,15.48856,-2.47897),(-1.6998,15.39945,-2.17275),(-4.19289,14.82114,-1.34479),(-4.18204,14.82389,-1.40092),(-3.93765,14.65641,-1.38307),(-4.27129,15.01884,-1.41833),(-4.36707,15.28208,-1.71785),(-4.342,15.16757,-1.71698),(-4.34587,15.20413,-1.44381),(-3.85083,15.05732,-2.00914),(-3.8232,15.02881,-1.99597),(-3.84091,15.01614,-1.97871),(-3.69692,14.73997,-1.68783),(-3.68562,14.91931,-1.89655),(-3.5606,14.79284,-1.79799),(-3.87721,14.97996,-1.82016),(-3.10839,11.34827,-1.05567),(-3.03327,10.48724,-1.18727),(-3.09442,11.34696,-1.02951),(-2.33835,14.87221,-.70422),(-2.34169,15.00369,-.60448),(-2.4118,14.85909,-.57474),(-2.25246,15.00983,-.69135),(-2.66959,13.88385,-.49052),(-2.78521,13.84742,-.39852),(-2.7674,13.41687,-.5406),(-3.24877,13.27613,-.53121),(-3.31093,13.70009,-.4348),(-3.26062,13.26954,-.55564),(-3.32952,13.70466,-.44976),(-3.32101,13.78709,-.52546),(-3.25102,13.26647,-.66564),(-3.25319,13.25484,-.62983),(-3.32704,13.803,-.58147),(-3.14815,12.31774,-.81815),(-3.18879,12.59253,-.75901),(-3.16291,12.32087,-.84339),(-3.24891,14.47654,-.32606),(-3.49458,14.47111,-.37735),(-3.28091,14.78225,-.38978),(-2.97077,14.8436,-.35761),(-2.96372,14.91974,-.37739),(-3.12138,15.76797,-1.28153),(-3.04199,15.90117,-1.3939),(-3.0539,15.90844,-1.39827),(-3.87852,15.51368,-2.07918),(-3.62234,15.60867,-2.10469),(-3.62311,15.57245,-2.11001),(-3.8737,15.53333,-2.0617),(-4.31938,14.97828,-1.68151),(-4.10828,14.90041,-1.5661),(-2.93121,15.01088,-2.33404),(-2.6873,15.23121,-2.39553),(-2.73366,15.06368,-2.34773),(-3.13076,15.79279,-1.93692),(-2.97476,15.90709,-1.85726),(-2.96572,15.90202,-1.86703),(-3.13828,15.80026,-1.92815),(-2.84484,15.97476,-1.7537),(-2.83557,15.97391,-1.76429),(-2.76255,15.98811,-1.70063),(-2.77502,15.98626,-1.69266),(-2.68905,15.9454,-1.40633),(-2.67567,15.94877,-1.41051),(-4.07001,15.61271,-.81574),(-4.188,15.61671,-.98507),(-4.19488,15.60873,-.98015),(-4.06332,15.62003,-.82429),(-4.22653,15.42801,-1.86857),(-3.89501,15.47422,-2.08432),(-3.89522,15.45936,-2.08556),(-4.22426,15.44252,-1.86613),(-3.30492,15.44717,-2.1193),(-3.30041,15.46085,-2.1155),(-3.10545,15.40077,-2.18217),(-3.09918,15.41297,-2.17564),(-1.82381,15.12081,-1.15747),(-1.80704,15.17999,-1.10698),(-2.0905,15.13813,-.75579),(-2.11744,15.06311,-.78407),(-2.44528,14.99591,-.52689),(-2.47161,14.92646,-.50717),(-2.43795,14.86181,-.54685),(-3.3829,14.10756,-.36787),(-3.73921,14.68758,-.49627),(-3.7762,14.67968,-.51714),(-3.59909,14.50348,-.51962),(-3.58462,14.44739,-.56402),(-3.35375,15.21763,-2.11958),(-3.16127,15.20919,-2.22),(-3.16177,15.181,-2.20893),(-3.35457,15.24477,-2.12411),(-2.72781,15.36715,-2.42239),(-2.71393,15.34302,-2.41977),(-2.95659,15.10151,-2.36687),(-2.94122,15.05422,-2.35374),(-2.2371,15.4872,-2.55045),(-2.23765,15.51417,-2.56583),(-2.08905,15.82999,-.84132),(-1.76323,15.80518,-1.08979),(-2.7307,13.42543,-.57303),(-2.65053,13.88183,-.52052),(-2.49472,14.86142,-.48846),(-3.58686,14.91475,-.41984),(-3.54884,14.85761,-.41038),(-3.53718,14.91833,-.40688),(-4.04688,14.90065,-.648),(-4.02671,14.87426,-.65231),(-3.89721,14.87166,-.52451),(-3.86476,14.89813,-.50553),(-2.88398,4.74131,-2.07675),(-2.92552,4.286,-2.19394),(-2.87114,4.26386,-2.15379),(-3.57977,14.69367,-.42962),(-3.54253,14.70012,-.41027),(-2.7946,15.70143,-1.89824),(-2.76806,15.84898,-1.87667),(-2.6724,15.82316,-1.93888),(-2.70342,15.89541,-1.85717),(-2.64929,15.82174,-1.92489),(-2.75508,15.86956,-1.8658),(-2.97773,14.69013,-.31592),(-3.22645,14.4358,-.31428),(-3.00797,14.4973,-.25261),(-3.41287,15.71406,-1.8656),(-3.23371,15.81209,-1.89516),(-3.39634,15.71582,-1.95576),(-3.64809,15.47484,-2.14133),(-3.35157,15.33293,-2.12429),(-3.64445,15.33067,-2.09758),(-2.75894,15.96124,-1.78504),(-3.32591,14.17957,-1.67972),(-3.25502,14.2034,-1.73823),(-3.20536,13.95597,-1.76425),(-2.82604,15.75344,-.93834),(-2.81106,15.72759,-.73252),(-2.65749,15.79666,-.96479),(-2.61425,15.73978,-.78042),(-2.31184,15.6521,-.59904),(-2.1715,15.67691,-.67322),(-2.33103,15.69652,-.67366),(-2.20512,15.72272,-.72222),(-2.40692,15.08679,-.54937),(-2.30154,15.40471,-.58631),(-2.71262,15.9738,-1.69509),(-3.00562,15.90583,-1.6448),(-2.9519,15.80181,-1.53069),(-2.929,15.79517,-1.54062),(-3.0153,15.91754,-1.60427),(-2.95624,15.80771,-1.38797),(-3.0553,15.71044,-1.28134),(-2.92012,15.79117,-1.40205),(-3.00327,15.71605,-1.25101),(-3.1105,15.63491,-1.04684),(-3.15727,15.6492,-1.05252),(-3.00678,15.64433,-.76999),(-2.9593,15.69434,-.99964),(-2.62542,14.86812,-.43785),(-2.74755,14.54065,-.27602),(-2.64453,14.54471,-.32379),(-2.73397,14.84895,-.40745),(-2.67562,14.25534,-.33838),(-2.75644,14.26306,-.27517),(-2.56376,15.07081,-.46654),(-2.56144,15.37653,-.5102),(-3.26974,15.79933,-1.38977),(-3.40484,15.65225,-1.30684),(-3.25744,15.77505,-1.3163),(-3.72158,15.58281,-1.0778),(-3.84997,15.55241,-1.20163),(-3.77226,15.62839,-.95796),(-3.94841,15.60571,-1.1366),(-3.52787,15.61771,-.89229),(-3.44166,15.64487,-.96763),(-3.57514,15.60988,-1.06937),(-3.52732,15.58189,-.56689),(-3.20776,15.67729,-1.05442),(-3.14151,15.93119,-1.44951),(-3.21506,15.81045,-1.31899),(-3.0141,15.6246,-.63084),(-2.7743,15.62121,-.51992),(-2.80394,15.68303,-.60519),(-3.01902,15.57682,-.55161),(-2.83116,15.75912,-.99849),(-2.85551,15.7468,-1.21456),(-2.86033,15.78593,-1.41242),(-2.87123,15.80979,-1.56353),(-2.68918,15.80582,-1.10646),(-2.71648,15.81218,-1.22901),(-2.78261,15.80679,-1.41928),(-2.83639,15.9343,-1.61888),(-2.73861,15.91442,-1.39958),(-2.72918,15.9246,-1.40255),(-2.6731,15.88772,-1.2359),(-2.6348,15.90022,-1.2495),(-2.49419,15.75446,-.82445),(-2.62155,15.89997,-1.25498),(-2.51117,15.86023,-1.2805),(-2.63375,15.94825,-1.4309),(-3.60318,15.58995,-1.23308),(-3.44949,15.63974,-1.1847),(-3.55759,15.58566,-1.25718),(-1.75163,15.70192,-1.05387),(-1.54452,15.74752,-1.46548),(-1.57235,15.63587,-1.44501),(-3.52945,15.52395,-.52194),(-3.28872,15.54955,-.55234),(-4.21259,15.40899,-.95569),(-4.31376,15.56382,-1.23732),(-4.31023,15.36482,-1.24056),(-2.91832,2.87573,-2.05283),(-2.72862,2.86329,-1.95347),(-2.90849,7.87615,-1.57132),(-2.8383,6.7374,-1.75445),(-2.82548,7.85301,-1.44882),(-2.76061,6.74201,-1.6776),(-2.56718,15.63641,-.53292),(-2.77071,15.33414,-.45085),(-3.54825,15.26321,-.47178),(-3.96356,15.2594,-.53622),(-3.62041,14.69321,-.44899),(-2.6015,14.26854,-.432),(-2.89554,12.28532,-.6624),(-2.95282,13.38261,-.4986),(-3.04607,12.28655,-.70674),(-3.13442,13.328,-.50184),(-2.67954,4.26902,-2.0053),(-2.69308,3.65036,-2.01231),(-2.49079,2.93926,-1.86179),(-2.59565,13.45839,-.71369),(-2.5695,13.86938,-.66601),(-2.45623,6.71751,-1.7527),(-2.52145,7.85337,-1.57136),(-2.65614,6.72198,-1.65144),(-2.73685,7.83906,-1.41725),(-2.2401,3.75136,-1.88415),(-1.59661,15.48408,-1.4624),(-1.75522,15.47934,-1.03489),(-2.39875,11.39555,-1.87241),(-2.39694,12.44993,-1.84734),(-2.31533,11.37724,-1.75742),(-2.31504,12.44116,-1.68333),(-2.37493,11.35984,-1.45134),(-2.32469,12.42879,-1.40136),(-2.32959,10.52739,-1.89022),(-2.30836,10.50921,-1.78496),(-2.29763,9.21422,-1.93874),(-2.27642,9.1849,-1.88456),(-2.25997,7.89811,-2.0315),(-2.25954,7.94474,-2.10733),(-2.12512,5.8473,-2.42828),(-2.19047,6.80949,-2.27205),(-2.11816,3.6733,-1.97659),(-2.13353,3.29081,-1.77649),(-2.02568,3.42339,-1.886),(-2.20515,3.53326,-1.82772),(-1.95153,3.36524,-1.97837),(-1.98011,3.27958,-1.85107),(-2.0215,3.50444,-2.02248),(-1.91709,3.2556,-2.59695),(-1.99179,3.24191,-2.62798),(-1.91029,2.97462,-2.55541),(-1.97634,3.39051,-2.64625),(-2.05296,3.58541,-2.61899),(-1.72511,2.6044,-2.55734),(-1.812,2.6662,-2.53638),(-1.80964,2.66583,-2.61977),(-1.91246,2.70787,-2.54352),(-1.79469,2.61386,-2.02073),(-1.7116,2.44017,-2.21005),(-1.86733,2.40383,-2.23285),(-2.01058,2.66483,-2.01714),(-1.96475,2.72595,-1.98268),(-2.08274,2.78496,-1.91929),(-2.149,2.82234,-2.12825),(-2.24619,2.90612,-2.13774),(-2.17968,2.8829,-2.26009),(-2.26519,3.02352,-2.27815),(-2.24618,2.91044,-2.84527),(-2.39494,2.96194,-2.76941),(-2.33496,2.92726,-2.91542),(-2.31872,2.98223,-2.67232),(-2.56536,15.75939,-2.0697),(-2.66863,15.75589,-2.09371),(-2.86906,15.60748,-1.97182),(-3.60927,15.62368,-2.00768),(-3.36451,15.7058,-2.04031),(-4.15694,15.60521,-1.26348),(-4.3075,15.57277,-1.24144),(-3.41128,15.74356,-1.74541),(-3.14364,15.92588,-1.64706),(-3.22313,15.8512,-1.79236),(-3.3355,15.79674,-1.58372),(-3.55516,15.64399,-1.66942),(-3.4439,15.65358,-1.48497),(-2.36745,15.68189,-1.7804),(-2.28392,15.68199,-1.92336),(-2.47947,15.73558,-1.76377),(-2.55022,15.76364,-1.86545),(-3.75881,15.54357,-1.36005),(-3.86834,15.55465,-1.52568),(-3.93541,15.54672,-1.40613),(-3.74602,15.5559,-1.41271),(-2.99687,15.51642,-2.10333),(-3.2116,15.60133,-2.04935),(-2.8657,15.52329,-2.18262),(-2.77717,15.60579,-2.02187),(-2.73441,15.65431,-2.24589),(-2.69109,15.74411,-2.08653),(-2.77406,15.56738,-2.42564),(-2.51615,15.32987,-2.46734),(-2.52825,15.43815,-2.50543),(-2.23923,15.38139,-2.4655),(-2.00772,15.69767,-2.53192),(-2.25671,15.67753,-2.57575),(-2.21939,15.26123,-2.39967),(-2.02842,15.27442,-2.36896),(-4.18293,14.86311,-1.1905),(-4.36169,15.32535,-1.47142),(-3.64456,15.20111,-2.05734),(-3.1654,15.2602,-2.23399),(-2.979,15.25757,-2.35087),(-2.22978,15.06268,-2.41252),(-2.03317,15.19997,-2.36001),(-2.04906,15.07572,-2.34249),(-2.22187,15.18624,-2.4032),(-3.04794,14.88423,-2.0484),(-2.90233,14.96067,-2.27069),(-2.84604,14.87309,-2.1494),(-3.13272,15.06822,-2.15687),(-3.44671,15.0058,-1.93997),(-3.34874,14.82442,-1.87208),(-3.53738,14.80513,-1.81345),(-3.66411,14.93016,-1.91234),(-3.8712,14.67508,-1.51456),(-3.01192,14.65003,-1.94451),(-3.26123,14.83357,-1.90915),(-3.24227,14.61418,-1.83837),(-2.7762,14.87117,-2.16644),(-2.80761,14.6435,-2.03893),(-2.30846,14.27796,-1.98563),(-2.05724,14.55014,-1.89414),(-2.15607,14.28236,-1.88935),(-2.23233,14.5654,-2.05953),(-3.5578,13.92977,-1.43982),(-3.61845,14.08029,-1.43654),(-2.7471,13.98661,-1.92),(-2.75547,14.24783,-1.9721),(-2.67569,14.23228,-1.99784),(-3.50822,13.39587,-1.27045),(-3.4366,13.43998,-1.48456),(-3.56771,13.90665,-1.20921),(-2.38429,13.56201,-1.90216),(-2.30052,13.55189,-1.83844),(-2.72067,13.54187,-1.91187),(-2.61216,13.55988,-1.92296),(-3.23946,11.36457,-1.49827),(-3.33713,12.33249,-1.35349),(-2.92929,11.42005,-1.88689),(-2.81723,10.54794,-1.91013),(-3.0104,9.21387,-1.829),(-3.12515,10.51914,-1.64591),(-2.38966,9.25436,-1.98825),(-2.48613,10.55113,-1.92588),(-3.10455,2.80028,-2.32548),(-2.47945,2.98068,-2.41348),(-2.66794,2.76372,-2.37922),(-2.68121,2.88934,-2.56921),(-2.47169,2.82601,-2.26902),(-2.41485,3.09771,-3.21896),(-2.42433,2.89876,-3.20268),(-2.59287,2.75491,-3.47048),(-2.56951,3.0764,-3.34549),(-2.77522,2.65132,-3.31869),(-2.80713,2.71413,-3.41915),(-2.59824,2.66489,-3.41484),(-2.61137,2.67244,-3.29749),(-3.01531,2.75347,-2.57802),(-2.9093,2.81581,-3.03644),(-2.93784,2.88293,-3.06028),(-2.91064,3.03609,-3.05167),(-2.94101,3.12101,-3.07454),(-2.97706,3.10984,-2.76913),(-2.42236,3.32843,-3.1338),(-2.5743,3.31838,-3.18124),(-2.9588,3.53369,-2.69407),(-3.06306,3.73013,-2.56908),(-2.95006,3.71639,-2.69358),(-3.06078,3.49233,-2.54504),(-2.41228,4.4031,-2.85089),(-2.30565,3.88049,-2.80145),(-2.45733,3.84618,-2.95649),(-2.24012,4.39172,-2.76592),(-2.90164,4.37471,-2.65163),(-2.9321,3.74749,-2.79188),(-2.94619,4.37492,-2.59374),(-3.00382,4.31548,-2.30609),(-2.98106,3.65728,-2.2682),(-3.03251,3.68498,-2.37647),(-2.92137,6.76724,-1.96641),(-2.95322,7.92681,-1.83302),(-2.97865,7.94641,-1.96311),(-2.96952,9.20579,-1.72215),(-2.24423,4.86396,-2.71861),(-2.43993,7.96031,-2.11857),(-2.34324,7.96506,-2.14071),(-2.48911,9.2518,-1.99953),(-2.96416,5.79015,-2.10921),(-3.0004,5.80386,-2.29016),(-2.96906,4.8158,-2.2235),(-3.07152,3.74808,-2.49187),(-2.61746,3.80517,-3.00782),(-3.10337,3.48403,-2.47228),(-2.9442,3.32707,-2.71532),(-3.07804,3.30369,-2.57067),(-2.4458,3.6275,-3.03189),(-2.34037,3.34168,-3.10226),(-2.36176,3.66414,-2.91812),(-2.73317,3.08043,-3.38426),(-2.75081,3.36832,-3.16046),(-3.1136,3.09942,-2.59862),(-3.14018,3.09794,-2.47095),(-3.13202,3.2918,-2.4816),(-3.0398,2.96833,-2.1685),(-2.99987,3.20329,-2.21614),(-3.08624,3.26335,-2.36861),(-3.09328,3.05565,-2.34657),(-2.90808,2.98106,-3.04808),(-2.69636,2.74498,-3.11808),(-2.21183,3.21147,-2.93289),(-2.33092,2.93685,-2.94265),(-2.43446,2.80337,-3.17236),(-2.47929,2.78632,-3.12443),(-2.83015,2.74405,-2.44796),(-2.79867,2.84311,-2.66654),(-2.45756,2.70099,-2.18607),(-2.6733,2.66087,-2.27658),(-3.12234,2.84876,-2.46403),(-3.03454,2.65617,-2.43639),(-3.46749,13.37382,-1.15183),(-2.99625,12.41592,-1.85891),(-3.12174,13.51358,-1.80276),(-3.02973,13.51431,-1.84363),(-2.34635,14.01615,-1.9289),(-2.21078,14.01764,-1.86008),(-2.28465,14.57194,-2.125),(-2.6425,14.61824,-2.10988),(-2.51886,14.22273,-2.00623),(-2.4941,14.59427,-2.15278),(-3.1762,14.21315,-1.79782),(-3.37144,14.57004,-1.76697),(-3.23109,14.20833,-1.75696),(-3.77969,14.42377,-1.39403),(-3.73333,14.45043,-1.48089),(-1.91259,14.83289,-2.04037),(-1.84741,14.86598,-1.84179),(-2.26932,14.81435,-2.26043),(-2.13754,14.81765,-2.18951),(-3.95756,14.6278,-1.18972),(-4.15479,14.83004,-1.18981),(-3.30694,15.04515,-1.98621),(-2.76927,14.99229,-2.28898),(-4.23167,15.09812,-1.8573),(-4.00931,14.99164,-1.74899),(-4.33571,15.09707,-1.70678),(-4.33799,15.00261,-1.68173),(-4.37213,15.50155,-1.47552),(-4.32929,15.46616,-1.72359),(-2.53918,15.46596,-2.528),(-2.77285,15.56187,-2.4383),(-2.73924,15.41814,-2.43248),(-2.95827,15.3861,-2.30696),(-2.71021,15.66723,-2.25587),(-2.56904,15.70524,-2.27447),(-3.64711,15.48472,-2.14291),(-4.3242,15.47986,-1.72347),(-4.31029,15.50806,-1.68223),(-4.21065,15.50025,-1.84249),(-3.75662,15.53743,-1.32157),(-3.89601,15.54797,-1.2983),(-2.67324,15.88033,-1.81804),(-2.60599,15.84647,-1.7264),(-2.28748,15.65604,-1.74752),(-2.1765,15.67838,-1.86719),(-3.61924,15.62952,-1.81927),(-3.08783,15.88092,-1.81849),(-2.9535,15.92102,-1.68489),(-2.47552,15.74826,-2.0653),(-2.39122,15.71878,-2.29064),(-1.85978,15.74375,-2.07695),(-2.0162,15.71476,-2.51774),(-2.14413,15.70522,-2.22782),(-1.69938,15.72917,-2.22321),(-2.0963,2.93173,-1.83492),(-2.3147,2.88305,-1.84864),(-2.0733,3.17439,-1.80285),(-2.11107,3.12957,-1.78388),(-1.99372,3.00236,-1.85096),(-2.19557,2.89195,-2.59346),(-2.17593,2.85033,-2.74019),(-1.86836,2.55312,-2.05947),(-1.92064,2.50849,-2.10542),(-1.80865,2.3761,-2.22022),(-1.83977,2.38206,-2.22802),(-2.05387,3.19943,-2.67288),(-2.09952,3.12021,-2.76844),(-2.06003,3.80363,-2.29499),(-2.02792,3.59898,-2.55994),(-2.03291,3.5822,-2.2489),(-1.68523,2.69748,-2.24256),(-1.68088,2.54949,-2.28621),(-1.72205,2.81167,-2.39457),(-2.0611,3.74657,-2.06879),(-2.02595,4.37344,-2.57954),(-2.07918,4.85048,-2.65932),(-2.01602,4.83172,-2.60066),(-2.08162,4.38897,-2.65388),(-2.13614,5.80479,-2.32785),(-2.05673,4.76458,-2.22555),(-2.01554,4.80411,-2.46945),(-2.22251,5.77361,-2.09622),(-2.24769,13.53497,-1.66602),(-2.43925,5.74863,-1.86285),(-2.32591,5.7617,-1.98497),(-2.25332,13.53306,-1.32481),(-2.32044,13.50544,-1.14694),(-2.04974,14.71561,-1.25038),(-2.18551,14.8863,-.85504),(-2.22315,14.69947,-.91131),(-1.93784,14.91612,-1.21115),(-2.03281,15.46355,-.71208),(-2.31439,4.74266,-1.99007),(-2.4826,4.73797,-1.93718),(-2.59652,5.74027,-1.813),(-2.52264,9.10547,-1.38781),(-2.7285,9.08819,-1.18729),(-2.71911,12.32257,-.81733),(-2.51799,13.47812,-.82005),(-2.5914,12.34922,-.92831),(-2.4512,14.2294,-.7827),(-2.51042,14.25653,-.61714),(-2.47981,13.88563,-.80145),(-2.49653,3.14952,-1.85945),(-2.71324,3.09102,-1.97273),(-3.4105,14.13638,-.48137),(-3.535,14.4614,-.41447),(-3.56195,14.45276,-.49212),(-2.74103,14.9122,-.40768),(-2.98011,14.76042,-.3354),(-2.74346,14.9818,-.40537),(-2.66604,14.29639,-.33313),(-2.55429,14.54665,-.38717),(-2.59942,14.28356,-.43005),(-2.86589,5.75046,-1.91307),(-2.74804,5.75888,-1.84803),(-2.87892,3.63107,-2.15412),(-2.89592,3.36926,-2.12703),(-2.90225,3.12482,-2.08447),(-3.00851,3.40278,-2.23344),(-3.88284,14.66631,-.68903),(-3.96267,14.62246,-.99896),(-4.08857,14.81425,-.95108),(-4.12633,14.91744,-.94584),(-4.10755,14.83935,-.94486),(-4.11133,15.42373,-.72518),(-4.11334,15.24738,-.68167),(-3.93867,15.46725,-.61311),(-3.87204,15.63584,-.66481),(-2.3096,15.69012,-1.40356),(-2.14021,15.63834,-1.60391),(-2.28658,15.64805,-1.60782),(-2.4031,15.7153,-1.5357),(-3.53846,15.60157,-1.32126),(-3.7176,15.55826,-1.27114),(-2.45822,15.81565,-1.31279),(-2.35997,15.81757,-1.11895),(-2.19384,15.82592,-.96059),(-1.93837,15.7843,-1.20276),(-2.13653,15.733,-1.30203),(-2.30181,15.86371,-.87669),(-2.11863,15.68694,-.70026),(-2.68467,15.87975,-1.23256),(-3.02694,15.9236,-1.60813),(-3.31043,15.68618,-1.08222),(-3.86679,15.64312,-.67432),(-3.51672,15.59239,-.59901),(-4.0499,15.62863,-1.07363),(-4.04216,15.57772,-1.28094),(-2.52212,14.55976,-.44886),(-2.45543,14.61368,-.58727),(-2.7509,14.30907,-.26339),(-3.48655,15.62079,-.67542),(-2.94695,15.91646,-1.67386),(-2.36845,15.83233,-.82286),(-3.68616,15.56618,-1.43775),(-3.67935,15.57067,-1.23154),(-3.88915,15.26761,-2.06929),(-2.60508,15.06117,-2.39082),(-2.46774,15.16381,-2.42396),(-2.47539,15.07064,-2.43479),(-2.54645,15.88364,-.98235),(-2.35629,15.85469,-.83929),(-2.51696,15.89427,-.98926),(-2.31543,15.86453,-.85784),(-2.23623,15.68709,-2.04828),(-1.9545,15.69224,-1.57344),(-1.99247,4.32671,-2.41327),(-2.68943,5.87044,-2.45179),(-2.89601,3.77614,-2.88037),(-2.93222,3.54151,-2.8322),(-2.82968,4.3789,-2.72779),(-2.57863,14.27142,-.47476),(-2.7481,15.0459,-.40484),(-2.57363,15.86651,-.97731),(-3.63878,15.17342,-2.04735),(-4.0445,15.12359,-1.95698),(-4.04015,15.08512,-1.94411),(-4.2355,15.12816,-1.86106),(-3.50501,14.71124,-.40289),(-3.34254,15.69113,-2.0476),(-2.96723,15.03305,-.40077),(-3.22864,14.20504,-.28527),(-3.42251,14.12915,-.55084),(-4.04796,15.26902,-1.98927),(-4.2263,15.28066,-1.88125),(-1.67906,15.57137,-2.19872),(-2.47605,14.9838,-2.39351),(-2.62339,14.99626,-2.33555),(-4.36833,15.50825,-1.47875),(-3.24196,15.62217,-2.04895),(-1.69217,15.13014,-1.85176),(-2.2575,15.65707,-1.68581),(-2.18422,3.47837,-2.82894),(-2.31041,3.68557,-2.85153),(-2.33716,3.48045,-1.83117),(-2.48781,3.4265,-1.8841),(-1.91431,2.77957,-1.94903),(-3.01508,2.64868,-2.43868),(-2.84412,2.64585,-2.34117),(-2.60055,3.57288,-3.09651),(-2.75733,3.55619,-3.04608),(-2.88923,13.51252,-1.86359),(-2.95362,4.88035,-2.53043),(-2.95253,5.82597,-2.36117),(-2.45113,2.59712,-2.10501),(-1.88526,2.44906,-2.33731),(-2.03137,2.65395,-2.28124),(-2.33156,2.75828,-2.11284),(-2.26388,2.97812,-2.65082),(-2.20198,2.924,-2.45693),(-1.94732,3.4055,-2.60444),(-1.87926,3.27475,-2.55333),(-1.93989,3.4376,-2.50509),(-2.61179,10.55033,-1.93207),(-2.68218,9.25651,-2.00668),(-1.8559,2.82487,-1.94573),(-2.61158,7.95721,-2.11361),(-2.26234,3.03163,-2.47111),(-2.54492,2.83019,-2.97546),(-2.94707,2.85442,-2.75556),(-2.99745,2.74311,-2.57315),(-2.93009,2.84144,-2.75006),(-2.89308,2.80275,-3.02835),(-2.68291,2.56786,-2.17986),(-2.35643,3.01588,-2.54079),(-2.36087,2.86847,-2.20173),(-2.4453,2.99569,-2.61384),(-2.37515,3.00475,-2.34378),(-2.7546,3.78689,-2.94521),(-3.09473,2.92859,-2.33359),(-3.12658,2.97399,-2.46505),(-2.13152,3.82638,-2.01177),(-2.06145,3.8715,-2.09618),(-2.03122,4.28092,-2.17639),(-2.19707,4.75264,-2.09735),(-2.15361,4.25293,-2.05977),(-2.30271,6.75059,-1.93578),(-2.34355,3.21186,-1.79634),(-2.23451,3.38988,-2.92504),(-2.53269,15.84037,-1.47444),(-2.68958,15.80985,-1.94586),(-2.64263,14.85286,-2.20766),(-2.47224,14.83018,-2.27315),(-4.20006,15.21327,-.9488),(-4.29744,15.17713,-1.22273),(-3.39623,14.56197,-1.75142),(-4.19651,15.51858,-1.8278),(-2.83009,15.94429,-1.62692),(-2.50549,15.89452,-.99868),(-2.95393,15.3982,-2.30039),(-2.2584,15.69651,-2.55845),(-1.5678,15.73282,-1.88816),(-1.55424,15.7145,-1.8904),(-1.55816,15.7632,-1.47219),(-1.68514,15.71051,-2.23135),(-1.75902,15.21114,-2.15207),(-2.47754,15.21952,-2.41888),(-2.07412,14.9812,-2.30174),(-2.2406,14.97046,-2.37431),(-1.78036,15.10241,-2.13941),(-1.75097,15.02927,-1.8459),(-1.8255,14.99448,-2.10636),(-2.58173,15.00503,-.45804),(-2.60706,14.93356,-.44779),(-3.00966,14.22346,-.25582),(-3.01618,14.28542,-.24291),(-3.21626,14.15281,-.29354),(-1.7147,15.09854,-1.4909),(-2.68919,4.74095,-1.96586),(-2.93248,3.36241,-2.89498),(-2.19448,6.78851,-2.19233),(-2.05063,3.93071,-2.3261),(-2.57422,15.68187,-.6113),(-3.81949,15.65074,-.81154),(-3.01613,15.90871,-1.65413),(-3.54567,14.51584,-1.64573),(-2.84287,11.30597,-.83479),(-2.39099,14.63888,-.73909),(-2.7486,2.82669,-2.90968),(-2.07639,14.28932,-1.64459),(-1.99852,14.58543,-1.6188),(-1.76839,15.74814,-1.51423),(-1.77245,15.74316,-1.83349),(-1.98196,15.69242,-1.78473),(-2.13587,15.65654,-1.74154),(-3.60356,15.58717,-1.3974),(-3.78833,14.41399,-1.18217),(-3.79079,14.40502,-1.02249),(-3.69688,14.42136,-.7593),(-3.63795,14.07649,-1.05116),(-3.51004,14.06403,-.80111),(-3.57819,13.91785,-1.0648),(-3.6272,14.06527,-1.19526),(-3.4359,13.86324,-.83349),(-3.33575,13.32976,-.88636),(-3.25583,12.32213,-1.12924),(-3.18956,11.35617,-1.35712),(-3.08266,10.49298,-1.54171),(-2.95848,9.16178,-1.3799),(-2.72043,3.37505,-1.99534),(-2.91258,10.4727,-1.03521),(-2.86426,9.11481,-1.2533),(-3.28778,15.28786,-.46851),(-2.96979,15.3051,-.4535),(-3.26829,14.95656,-.40698),(-2.95809,13.78484,-.37934),(-3.18208,13.70966,-.3958),(-2.95423,11.33394,-.86792),(-2.75479,10.44252,-.97624),(-2.27872,14.26613,-1.00801),(-2.29915,13.92817,-1.07214),(-2.14233,14.30347,-1.29267),(-2.20325,13.93434,-1.31043),(-2.39105,9.13834,-1.61464),(-2.38435,10.46528,-1.51626),(-2.36857,7.88902,-1.77571),(-1.84093,14.87462,-1.54179),(-2.15093,13.98956,-1.67081),(-1.56915,15.6075,-1.87664),(-1.60322,15.43392,-1.85222),(-1.78078,3.03762,-2.1545),(-1.86677,3.28656,-2.18737),(-1.86924,3.31031,-2.40349),(-1.9411,3.43715,-2.21159),(-2.145,3.31281,-2.81426),(-2.32896,3.03733,-1.8046),(-2.05877,15.69251,-1.95153),(-4.11595,15.55325,-1.76084),(-3.83484,15.57618,-1.94388),(-3.78618,15.59087,-1.78717),(-4.09886,15.57058,-1.49431),(-3.98405,15.56254,-1.67991),(-3.74647,15.56916,-1.59176),(-2.73778,15.69116,-1.94554),(-2.98247,14.23278,-1.86454),(-3.14572,13.96689,-1.80095),(-2.95208,13.95639,-1.8445),(-2.55124,14.00154,-1.95829),(-2.61945,2.89456,-2.78627),(-2.80065,2.7897,-3.49179),(-3.06988,3.44473,-2.35652),(-2.96242,6.8167,-2.11914),(-2.53339,5.8982,-2.516),(-2.56081,6.83176,-2.31506)]))),
        Shape(DEF='rfibula',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='lowleg_Geo',coordIndex=[0,1,2,-1,0,3,1,-1,4,5,6,-1,4,7,5,-1,8,9,10,-1,11,12,13,-1,12,14,13,-1,15,16,17,-1,16,18,17,-1,19,20,21,-1,22,23,24,-1,23,25,24,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,32,35,33,-1,15,33,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,34,17,46,-1,34,33,17,-1,47,48,49,-1,47,50,48,-1,51,52,53,-1,52,54,53,-1,55,56,57,-1,56,58,57,-1,59,60,61,-1,62,63,64,-1,65,66,61,-1,64,56,62,-1,56,67,62,-1,68,69,70,-1,69,71,70,-1,72,73,74,-1,73,75,74,-1,76,77,78,-1,77,55,78,-1,79,80,81,-1,81,82,79,-1,83,84,85,-1,86,84,87,-1,86,81,84,-1,88,89,90,-1,89,91,90,-1,92,93,94,-1,93,95,94,-1,96,97,98,-1,80,99,84,-1,99,85,84,-1,100,101,102,-1,101,103,102,-1,104,99,105,-1,104,106,99,-1,107,108,109,-1,110,111,112,-1,110,113,111,-1,88,114,115,-1,88,90,114,-1,95,96,13,-1,96,116,13,-1,117,94,118,-1,94,14,118,-1,58,64,111,-1,58,56,64,-1,119,120,107,-1,107,121,119,-1,122,123,124,-1,125,126,127,-1,127,128,125,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,133,136,134,-1,137,138,139,-1,137,140,138,-1,124,141,142,-1,143,144,145,-1,143,146,144,-1,147,148,149,-1,148,150,149,-1,151,152,153,-1,154,155,156,-1,154,151,155,-1,157,144,131,-1,144,132,131,-1,158,159,160,-1,161,162,163,-1,163,164,161,-1,150,165,123,-1,150,166,165,-1,64,63,111,-1,63,112,111,-1,167,168,21,-1,167,169,168,-1,170,171,172,-1,171,51,172,-1,121,173,174,-1,121,175,173,-1,174,176,177,-1,174,0,176,-1,177,176,178,-1,178,179,177,-1,180,66,57,-1,66,65,57,-1,181,1,3,-1,182,181,183,-1,181,184,183,-1,185,163,162,-1,162,186,185,-1,68,187,184,-1,187,183,184,-1,188,189,187,-1,189,190,187,-1,191,192,193,-1,191,194,192,-1,195,189,196,-1,195,190,189,-1,197,198,195,-1,195,199,197,-1,200,201,202,-1,203,204,205,-1,204,206,205,-1,207,208,154,-1,208,151,154,-1,135,139,133,-1,135,209,139,-1,210,211,212,-1,212,142,210,-1,213,214,215,-1,216,215,217,-1,215,218,217,-1,79,110,105,-1,79,113,110,-1,83,219,100,-1,219,101,100,-1,102,103,220,-1,103,221,220,-1,89,222,223,-1,223,224,89,-1,223,101,224,-1,101,219,224,-1,225,226,106,-1,225,227,226,-1,228,95,93,-1,228,96,95,-1,229,230,231,-1,6,232,4,-1,233,234,235,-1,235,4,233,-1,235,236,237,-1,235,238,236,-1,239,240,241,-1,239,5,240,-1,20,242,243,-1,20,244,242,-1,245,40,42,-1,42,246,245,-1,247,44,43,-1,247,248,44,-1,26,233,249,-1,249,27,26,-1,248,250,44,-1,251,238,235,-1,235,234,251,-1,252,253,254,-1,253,255,254,-1,256,231,222,-1,256,257,231,-1,258,115,259,-1,259,260,258,-1,261,258,260,-1,260,262,261,-1,263,19,264,-1,264,265,263,-1,167,20,39,-1,167,21,20,-1,37,245,266,-1,37,243,245,-1,266,246,267,-1,266,245,246,-1,236,268,269,-1,236,238,268,-1,270,268,271,-1,272,32,31,-1,31,273,272,-1,253,274,275,-1,274,36,275,-1,253,252,276,-1,276,274,253,-1,43,277,247,-1,278,279,280,-1,280,18,278,-1,281,282,283,-1,273,31,30,-1,30,169,273,-1,29,284,30,-1,280,279,281,-1,279,282,281,-1,46,18,280,-1,46,17,18,-1,16,285,18,-1,286,278,287,-1,286,279,278,-1,274,276,285,-1,285,16,274,-1,255,275,288,-1,255,253,275,-1,251,271,268,-1,268,238,251,-1,246,236,269,-1,269,267,246,-1,38,37,266,-1,250,289,44,-1,250,25,289,-1,262,263,265,-1,262,260,263,-1,290,244,259,-1,290,242,244,-1,234,291,255,-1,255,251,234,-1,233,291,234,-1,233,26,291,-1,248,247,28,-1,28,27,248,-1,241,292,293,-1,241,240,292,-1,294,295,92,-1,295,93,92,-1,232,118,249,-1,118,296,249,-1,297,295,294,-1,297,298,295,-1,264,168,283,-1,283,282,264,-1,299,8,300,-1,299,301,8,-1,224,219,227,-1,219,226,227,-1,105,97,104,-1,105,110,97,-1,87,100,302,-1,124,123,141,-1,123,165,141,-1,147,149,203,-1,203,205,147,-1,202,303,200,-1,303,304,200,-1,305,143,193,-1,305,146,143,-1,193,192,185,-1,185,305,193,-1,189,306,307,-1,307,196,189,-1,182,1,181,-1,182,194,1,-1,70,59,308,-1,70,60,59,-1,184,309,68,-1,309,69,68,-1,2,176,0,-1,71,74,76,-1,74,77,76,-1,109,81,175,-1,81,86,175,-1,74,75,77,-1,75,67,77,-1,81,80,84,-1,104,97,96,-1,96,228,104,-1,223,103,101,-1,223,230,103,-1,158,310,159,-1,158,311,310,-1,164,163,312,-1,142,141,313,-1,313,210,142,-1,154,314,315,-1,154,156,314,-1,209,316,139,-1,316,315,139,-1,166,150,148,-1,317,318,319,-1,191,176,2,-1,191,178,176,-1,145,144,157,-1,147,205,320,-1,320,321,147,-1,133,141,136,-1,133,313,141,-1,148,152,166,-1,148,153,152,-1,322,138,140,-1,320,205,206,-1,126,125,323,-1,323,307,126,-1,211,217,218,-1,218,212,211,-1,310,311,123,-1,311,150,123,-1,323,324,325,-1,325,307,323,-1,129,132,314,-1,217,211,186,-1,129,317,130,-1,121,109,175,-1,121,107,109,-1,94,95,14,-1,95,13,14,-1,98,326,116,-1,116,96,98,-1,113,58,111,-1,113,327,58,-1,53,54,73,-1,54,50,73,-1,79,105,80,-1,105,99,80,-1,99,106,85,-1,106,226,85,-1,97,63,98,-1,97,112,63,-1,290,292,40,-1,40,242,290,-1,114,297,293,-1,114,90,297,-1,228,225,106,-1,106,104,228,-1,94,117,92,-1,117,239,92,-1,89,224,91,-1,112,97,110,-1,87,84,83,-1,83,100,87,-1,73,47,75,-1,73,50,47,-1,69,72,71,-1,72,74,71,-1,68,188,187,-1,56,55,67,-1,55,77,67,-1,59,306,308,-1,79,327,113,-1,79,82,327,-1,107,66,180,-1,180,108,107,-1,65,61,78,-1,51,53,328,-1,328,172,51,-1,52,220,54,-1,220,9,54,-1,27,250,248,-1,27,329,250,-1,287,289,286,-1,268,270,269,-1,39,38,167,-1,35,36,33,-1,35,275,36,-1,254,255,291,-1,229,22,330,-1,22,24,330,-1,33,15,17,-1,48,326,49,-1,48,301,326,-1,11,13,116,-1,116,299,11,-1,6,239,117,-1,6,5,239,-1,116,301,299,-1,301,116,326,-1,48,54,9,-1,48,50,54,-1,331,229,330,-1,230,229,331,-1,267,270,332,-1,269,270,267,-1,278,285,333,-1,278,18,285,-1,334,335,336,-1,334,300,335,-1,337,329,338,-1,329,337,250,-1,78,57,65,-1,57,78,55,-1,82,180,327,-1,82,108,180,-1,228,295,225,-1,228,93,295,-1,293,290,114,-1,290,293,292,-1,40,243,242,-1,243,40,245,-1,327,57,58,-1,327,180,57,-1,130,319,339,-1,319,130,317,-1,325,204,340,-1,325,324,204,-1,149,303,203,-1,304,303,149,-1,341,212,218,-1,122,212,341,-1,157,128,127,-1,157,342,128,-1,304,150,311,-1,150,304,149,-1,151,343,152,-1,151,208,343,-1,134,343,208,-1,134,344,343,-1,135,208,207,-1,135,134,208,-1,320,155,321,-1,318,155,320,-1,166,345,165,-1,345,166,152,-1,133,138,313,-1,139,138,133,-1,156,318,317,-1,155,318,156,-1,147,153,148,-1,153,147,321,-1,328,69,309,-1,72,69,328,-1,151,321,155,-1,153,321,151,-1,183,190,346,-1,187,190,183,-1,347,319,206,-1,347,339,319,-1,342,339,128,-1,342,130,339,-1,348,177,179,-1,177,348,119,-1,59,120,349,-1,120,59,61,-1,350,126,351,-1,350,127,126,-1,143,191,193,-1,178,191,143,-1,206,318,320,-1,318,206,319,-1,352,51,171,-1,52,51,352,-1,353,87,302,-1,87,353,86,-1,62,75,47,-1,75,62,67,-1,170,3,0,-1,172,3,170,-1,81,108,82,-1,108,81,109,-1,353,175,86,-1,353,173,175,-1,70,76,60,-1,70,71,76,-1,2,194,191,-1,2,1,194,-1,127,145,157,-1,350,145,127,-1,189,308,306,-1,188,308,189,-1,351,307,306,-1,351,126,307,-1,325,196,307,-1,354,196,325,-1,355,199,354,-1,199,355,356,-1,159,213,160,-1,159,214,213,-1,201,357,356,-1,201,160,357,-1,198,312,346,-1,312,198,164,-1,357,161,197,-1,161,357,358,-1,322,185,186,-1,322,305,185,-1,210,186,211,-1,186,210,322,-1,140,305,322,-1,305,140,146,-1,315,137,139,-1,315,314,137,-1,311,200,304,-1,158,200,311,-1,352,100,102,-1,302,100,352,-1,63,326,98,-1,49,326,63,-1,335,221,331,-1,335,10,221,-1,227,295,298,-1,227,225,295,-1,12,334,338,-1,334,12,11,-1,250,24,25,-1,250,337,24,-1,257,229,231,-1,22,229,257,-1,330,337,336,-1,330,24,337,-1,232,233,4,-1,233,232,249,-1,40,240,41,-1,40,292,240,-1,247,254,28,-1,247,252,254,-1,114,259,115,-1,114,290,259,-1,257,258,261,-1,257,256,258,-1,359,265,360,-1,265,359,262,-1,359,25,23,-1,359,289,25,-1,45,289,287,-1,44,289,45,-1,282,286,360,-1,279,286,282,-1,167,273,169,-1,167,38,273,-1,361,275,35,-1,288,275,361,-1,271,255,288,-1,255,271,251,-1,333,287,278,-1,333,45,287,-1,46,281,284,-1,280,281,46,-1,284,283,30,-1,284,281,283,-1,15,274,16,-1,274,15,36,-1,270,288,361,-1,270,271,288,-1,35,272,361,-1,32,272,35,-1,272,38,332,-1,38,272,273,-1,267,38,266,-1,267,332,38,-1,332,361,272,-1,361,332,270,-1,263,20,19,-1,263,244,20,-1,360,264,282,-1,360,265,264,-1,360,289,359,-1,289,360,286,-1,23,262,359,-1,261,262,23,-1,260,244,263,-1,259,244,260,-1,115,256,88,-1,115,258,256,-1,222,88,256,-1,89,88,222,-1,241,92,239,-1,92,241,294,-1,277,252,247,-1,277,276,252,-1,249,329,27,-1,249,296,329,-1,246,237,236,-1,42,237,246,-1,20,37,39,-1,20,243,37,-1,41,5,7,-1,240,5,41,-1,6,118,232,-1,118,6,117,-1,235,7,4,-1,235,237,7,-1,338,296,12,-1,338,329,296,-1,336,331,330,-1,336,335,331,-1,22,261,23,-1,257,261,22,-1,222,230,223,-1,231,230,222,-1,11,300,334,-1,300,11,299,-1,230,221,103,-1,221,230,331,-1,298,224,227,-1,298,91,224,-1,221,9,220,-1,9,221,10,-1,9,301,48,-1,9,8,301,-1,52,102,220,-1,102,52,352,-1,47,63,62,-1,47,49,63,-1,218,214,341,-1,214,218,215,-1,216,213,215,-1,216,358,213,-1,316,154,315,-1,154,316,207,-1,347,204,324,-1,204,347,206,-1,146,132,144,-1,146,140,132,-1,216,186,162,-1,217,186,216,-1,164,197,161,-1,164,198,197,-1,163,192,312,-1,192,163,185,-1,160,200,158,-1,201,200,160,-1,358,160,213,-1,358,357,160,-1,202,356,355,-1,201,356,202,-1,195,354,199,-1,195,196,354,-1,356,197,199,-1,356,357,197,-1,340,354,325,-1,354,340,355,-1,348,351,349,-1,348,350,351,-1,145,178,143,-1,179,178,145,-1,324,125,347,-1,324,323,125,-1,194,312,192,-1,194,182,312,-1,182,346,312,-1,182,183,346,-1,355,303,202,-1,355,340,303,-1,349,119,348,-1,120,119,349,-1,119,174,177,-1,119,121,174,-1,170,174,173,-1,170,0,174,-1,173,171,170,-1,171,173,353,-1,309,172,328,-1,3,172,309,-1,171,302,352,-1,171,353,302,-1,169,283,168,-1,169,30,283,-1,159,341,214,-1,159,310,341,-1,162,358,216,-1,162,161,358,-1,313,322,210,-1,313,138,322,-1,306,349,351,-1,349,306,59,-1,350,179,145,-1,179,350,348,-1,347,128,339,-1,347,125,128,-1,136,344,134,-1,344,136,345,-1,122,142,212,-1,122,124,142,-1,195,346,190,-1,195,198,346,-1,72,53,73,-1,72,328,53,-1,314,317,129,-1,317,314,156,-1,345,141,165,-1,345,136,141,-1,140,314,132,-1,314,140,137,-1,152,344,345,-1,343,344,152,-1,207,209,135,-1,207,316,209,-1,310,122,341,-1,123,122,310,-1,342,131,130,-1,342,157,131,-1,340,203,303,-1,340,204,203,-1,293,294,241,-1,297,294,293,-1,91,297,90,-1,91,298,297,-1,61,107,120,-1,61,66,107,-1,85,219,83,-1,85,226,219,-1,60,78,61,-1,60,76,78,-1,308,68,70,-1,308,188,68,-1,338,336,337,-1,338,334,336,-1,29,46,284,-1,29,34,46,-1,277,285,276,-1,277,333,285,-1,277,45,333,-1,277,43,45,-1,42,7,237,-1,41,7,42,-1,31,34,29,-1,31,32,34,-1,28,291,26,-1,28,254,291,-1,264,21,168,-1,264,19,21,-1,10,300,8,-1,10,335,300,-1,12,118,14,-1,12,296,118,-1,3,184,181,-1,3,309,184,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lowleg_Coord',point=[(-3.34807,5.79703,-1.95756),(-3.40924,4.9032,-2.15639),(-3.3035,4.90165,-2.05435),(-3.451,5.83372,-2.11458),(-3.80922,14.31214,-1.71456),(-3.85277,14.11985,-1.53516),(-3.85416,14.13989,-1.6139),(-3.72738,14.3535,-1.54123),(-3.70363,11.13251,-1.87997),(-3.67193,10.28981,-1.96648),(-3.78608,11.13928,-1.85741),(-3.78774,12.81455,-1.75715),(-3.94465,13.52524,-1.68126),(-3.73444,12.802,-1.75365),(-3.87839,13.51279,-1.65478),(-4.23418,14.84166,-1.63631),(-4.27892,14.8042,-1.69764),(-4.28515,14.84805,-1.60159),(-4.38379,14.74864,-1.58488),(-4.12166,14.51593,-.99073),(-3.93481,14.45962,-.9913),(-4.09706,14.61358,-.99635),(-4.16756,13.54144,-1.32397),(-4.23706,13.77547,-1.29892),(-4.196,13.56965,-1.4515),(-4.23811,13.7873,-1.45499),(-4.03132,14.37145,-1.7105),(-4.08048,14.22089,-1.67505),(-4.09545,14.4035,-1.71087),(-4.21889,14.9559,-1.28728),(-4.24337,15.03473,-1.09327),(-4.1485,14.93568,-1.27388),(-4.16467,14.85547,-1.38737),(-4.17752,14.84167,-1.57434),(-4.22402,14.86499,-1.42016),(-4.10807,14.84109,-1.55681),(-4.17264,14.85392,-1.65004),(-3.80898,14.63356,-1.00894),(-3.96969,14.75391,-1.16723),(-3.88448,14.67659,-.95707),(-3.7914,14.30275,-1.21671),(-3.75037,14.34258,-1.35),(-3.74058,14.35627,-1.34685),(-4.30612,14.46735,-1.72173),(-4.32805,14.30721,-1.62793),(-4.36571,14.46632,-1.67703),(-4.32156,14.8867,-1.47463),(-3.45099,9.31943,-2.21687),(-3.53865,10.23955,-2.07485),(-3.49113,10.21217,-2.13845),(-3.49774,9.31806,-2.17403),(-3.62776,8.01805,-1.91064),(-3.76297,9.28813,-1.79866),(-3.59455,8.04561,-2.12124),(-3.64302,9.30639,-2.0465),(-3.20816,6.84721,-2.31063),(-3.35326,8.10408,-2.23335),(-3.1856,6.85368,-2.2838),(-3.35069,8.09999,-2.1684),(-3.04925,4.09457,-2.58941),(-3.19712,5.04811,-2.47812),(-3.10934,5.04082,-2.48248),(-3.43338,9.31559,-2.19314),(-3.46792,10.20802,-2.09748),(-3.41732,9.30798,-2.15362),(-3.11207,5.93678,-2.38126),(-3.11373,5.93068,-2.35357),(-3.40087,8.09661,-2.26646),(-3.27945,5.05912,-2.51569),(-3.37417,5.91824,-2.43945),(-3.24102,5.06447,-2.49775),(-3.3346,5.92848,-2.43437),(-3.42502,6.82247,-2.37496),(-3.46495,8.08607,-2.28858),(-3.36928,6.82924,-2.38182),(-3.42513,8.09616,-2.30032),(-3.2306,5.93439,-2.3855),(-3.29942,6.83181,-2.32105),(-3.1241,5.93925,-2.39406),(-3.44359,9.25796,-1.88151),(-3.44824,9.25189,-1.84286),(-3.21724,7.95363,-1.94757),(-3.26609,8.00076,-2.00813),(-3.57768,10.12224,-1.65378),(-3.43686,9.24654,-1.79085),(-3.5724,10.13623,-1.7084),(-3.35447,8.09735,-1.82126),(-3.47986,9.13324,-1.71361),(-3.96526,13.50255,-1.3065),(-3.93023,12.81581,-1.38208),(-3.94463,13.5045,-1.3558),(-3.89858,12.82097,-1.43213),(-3.85923,13.50698,-1.57539),(-3.76155,12.81572,-1.66478),(-3.85578,13.51542,-1.62897),(-3.72458,12.80954,-1.72591),(-3.61073,12.00247,-1.80965),(-3.50619,11.11821,-1.9172),(-3.52056,11.12457,-1.96183),(-3.56878,10.15004,-1.78918),(-3.68071,10.11194,-1.61775),(-3.82789,11.0712,-1.5347),(-3.8173,10.17387,-1.61318),(-3.9352,11.08362,-1.55164),(-3.5361,11.11289,-1.85055),(-3.53114,10.16621,-1.85205),(-3.65109,11.09731,-1.77463),(-3.09181,5.92073,-2.29819),(-3.14299,6.87296,-2.17708),(-3.11718,6.8829,-2.13041),(-3.51495,10.17385,-1.95443),(-3.45692,9.2877,-2.07475),(-3.49393,10.18881,-2.01731),(-3.46602,9.26963,-1.97837),(-3.95234,13.71038,-1.31641),(-3.97393,13.69081,-1.23316),(-3.61987,12.0107,-1.85048),(-3.86832,13.74353,-1.60092),(-3.88932,13.74518,-1.63442),(-3.06688,4.99687,-2.25119),(-3.08596,5.01998,-2.40133),(-3.15413,5.87426,-2.11139),(-3.35262,1.77202,-2.48262),(-3.3414,1.8234,-2.58298),(-3.29638,1.84802,-2.45853),(-2.93057,2.92126,-2.88676),(-2.93042,2.99966,-2.85899),(-2.908,2.96793,-2.53981),(-2.93195,2.90178,-2.58009),(-3.01182,2.47648,-2.42023),(-3.00936,2.57058,-2.52444),(-2.98199,2.61415,-2.45617),(-3.01553,2.51236,-2.31401),(-3.22461,2.15548,-2.23985),(-3.27369,2.13497,-2.46484),(-3.25277,2.18685,-2.40125),(-3.24805,1.95861,-2.44052),(-3.0891,2.43197,-2.24259),(-3.17405,2.31901,-2.21062),(-3.16579,2.30652,-2.2472),(-3.08989,2.48525,-2.20542),(-3.25527,1.91073,-2.41157),(-3.29992,1.86674,-2.38122),(-3.00762,3.04336,-2.15142),(-2.96793,2.76592,-2.31113),(-2.96522,3.12995,-2.31708),(-3.05166,2.73668,-2.17937),(-3.15855,1.99507,-2.8523),(-3.23129,1.97355,-2.78765),(-3.20132,1.99932,-2.88437),(-3.29627,1.88974,-2.76773),(-3.18,2.06962,-2.6714),(-3.24889,1.97487,-2.69119),(-3.20798,2.0121,-2.7371),(-3.08936,2.30732,-2.54393),(-3.11144,2.10281,-2.72791),(-3.06023,2.31928,-2.58776),(-2.91975,2.80896,-2.41047),(-3.44043,1.87235,-2.83536),(-3.46805,1.8576,-2.71232),(-3.53884,2.05606,-2.71618),(-3.60134,2.43087,-2.40769),(-3.53752,2.38588,-2.26172),(-3.39496,2.72282,-2.26886),(-3.4013,2.76066,-2.36709),(-3.29996,1.86392,-2.60734),(-3.25819,1.93664,-2.73061),(-3.97488,14.75643,-.93587),(-4.20047,14.69972,-1.00319),(-4.16525,14.94896,-1.02581),(-3.44033,6.74831,-1.85785),(-3.60353,8.001,-1.76422),(-3.51548,6.76759,-1.99682),(-3.32344,6.80066,-1.877),(-3.19531,5.82126,-1.99972),(-3.23616,6.83593,-1.95868),(-3.2075,4.9076,-2.02893),(-3.10827,4.93181,-2.10196),(-3.05567,3.88581,-2.12173),(-3.02689,3.93212,-2.21626),(-3.17484,6.86081,-2.23407),(-3.44733,4.91312,-2.22321),(-3.32812,3.92373,-2.28752),(-3.30489,4.00106,-2.45496),(-3.45626,4.93206,-2.34972),(-3.31084,2.68986,-2.18214),(-3.41912,2.36853,-2.20241),(-3.22237,4.06612,-2.61554),(-3.14764,4.09664,-2.6589),(-3.16174,3.35334,-2.85945),(-3.19891,3.30929,-2.77299),(-3.15542,3.87955,-2.12382),(-3.19363,3.00987,-2.2025),(-3.1042,3.02376,-2.15517),(-3.23971,3.89468,-2.18358),(-3.29501,2.93673,-2.84993),(-3.15055,2.94975,-3.11408),(-3.58823,2.51523,-2.63713),(-3.4156,2.81492,-2.5899),(-3.40575,2.64421,-2.91196),(-3.392,2.00922,-2.99486),(-3.41902,2.12398,-2.97643),(-3.3482,2.10651,-3.06773),(-3.13233,2.08753,-2.96533),(-3.05032,2.3256,-3.05479),(-3.09464,2.08962,-2.91497),(-3.0559,2.33762,-2.93528),(-3.20455,2.22833,-2.49523),(-3.23966,2.15758,-2.55546),(-3.22121,2.23934,-2.38159),(-3.35583,2.06566,-2.16208),(-3.43868,1.97774,-2.18624),(-3.38747,1.77727,-2.3551),(-3.58627,1.92499,-2.46363),(-3.50752,1.76394,-2.53816),(-3.52206,1.76188,-2.38703),(-3.56205,1.97158,-2.24194),(-3.49232,1.95746,-2.2078),(-3.44021,1.75697,-2.35932),(-3.71117,11.05796,-1.54913),(-3.86585,10.23574,-1.74806),(-3.93685,11.11155,-1.67319),(-3.9873,12.80897,-1.34139),(-3.91403,11.98076,-1.46109),(-3.82192,11.99896,-1.4847),(-3.71005,11.9485,-1.68949),(-3.70148,11.07231,-1.63619),(-3.76691,11.95385,-1.5904),(-3.67322,11.99654,-1.75066),(-4.0988,12.83567,-1.42332),(-4.01739,12.00745,-1.49173),(-4.06463,12.8233,-1.37834),(-3.85901,14.15892,-1.66024),(-3.93896,14.3364,-1.75753),(-3.90612,14.51953,-1.79128),(-3.73822,14.42475,-1.75252),(-3.69012,14.54314,-1.53185),(-3.70038,14.40384,-1.53596),(-3.72821,14.55131,-1.6413),(-3.87943,13.74103,-1.55947),(-3.86736,14.11563,-1.39885),(-3.901,13.73525,-1.48198),(-3.89079,14.29979,-1.07315),(-3.83638,14.44988,-1.04359),(-3.96281,14.30844,-.99105),(-3.74788,14.404,-1.19856),(-3.72426,14.48296,-1.35512),(-4.17358,14.45224,-1.75237),(-4.20951,14.26959,-1.68859),(-3.96291,14.18543,-1.69176),(-4.15048,13.7852,-1.61513),(-3.8368,14.67983,-1.75953),(-4.13977,14.63124,-1.81646),(-4.08391,14.77187,-1.76719),(-4.04519,14.58658,-1.77117),(-3.93814,14.73744,-1.76161),(-4.03838,13.5114,-1.25442),(-4.11918,13.52726,-1.27083),(-4.03383,13.68516,-1.18817),(-3.97173,14.05098,-1.03393),(-4.09458,14.10384,-1.01717),(-4.14037,13.71867,-1.20834),(-4.2359,14.2043,-1.11184),(-4.14998,14.34903,-.9819),(-4.23527,14.55394,-1.01211),(-4.25162,14.37752,-1.03944),(-3.75736,14.61481,-1.14393),(-3.77447,14.62757,-1.30317),(-3.79579,14.72072,-1.58577),(-3.77735,14.69092,-1.48841),(-3.9163,14.76093,-1.49531),(-3.86873,14.77345,-1.66472),(-4.10538,14.84596,-1.3546),(-4.12884,14.89272,-1.22036),(-4.17201,14.80842,-1.77696),(-4.06142,14.84093,-1.65674),(-4.19457,14.68281,-1.84898),(-4.28743,14.5266,-1.78363),(-4.42977,14.57023,-1.51202),(-4.46321,14.68458,-1.43388),(-4.41882,14.83447,-1.46942),(-4.44841,14.92766,-1.28177),(-4.45533,14.68984,-1.22873),(-4.41334,14.93108,-1.17534),(-4.32991,14.98779,-1.30844),(-4.3513,14.7313,-1.73342),(-4.46425,14.49962,-1.41095),(-4.40036,14.50569,-1.49549),(-3.98095,14.83156,-1.66164),(-4.37231,14.3094,-1.47135),(-3.9319,14.07717,-1.1598),(-3.97979,14.55529,-1.76662),(-3.88725,14.10423,-1.29498),(-3.93146,13.72998,-1.39939),(-3.87357,13.50295,-1.52981),(-3.81475,12.81636,-1.59454),(-3.96919,13.75482,-1.68039),(-3.90298,13.49826,-1.4392),(-3.85212,12.83251,-1.52132),(-3.6854,12.02307,-1.83388),(-3.79409,12.0292,-1.81097),(-3.60564,11.12706,-1.95226),(-3.58217,9.22963,-1.68643),(-3.16499,2.07817,-3.00425),(-3.23549,1.9916,-2.91808),(-3.22435,2.68989,-2.15639),(-3.02579,3.34981,-2.80236),(-2.94555,3.01143,-3.03789),(-3.11141,4.10166,-2.64344),(-3.47826,5.86666,-2.29805),(-3.38908,1.82997,-2.63511),(-3.34532,1.86895,-2.79761),(-3.28482,3.05199,-2.30009),(-3.24191,2.14126,-2.19072),(-3.01937,2.45467,-2.34281),(-3.0691,2.36188,-2.38639),(-3.192,2.26302,-2.44136),(-3.04378,2.35715,-2.6303),(-3.06929,2.14412,-2.76813),(-3.05574,2.35504,-2.79481),(-3.07335,2.11006,-2.85765),(-3.13998,2.03794,-2.78388),(-3.31393,2.38577,-2.16384),(-2.92512,2.91359,-3.05076),(-2.97056,2.71719,-3.13321),(-2.99696,2.72413,-3.17357),(-3.53981,11.11622,-2.00521),(-3.32035,8.05487,-2.08217),(-3.51887,6.79994,-2.22981),(-4.04168,13.76259,-1.66415),(-4.0994,12.86042,-1.53582),(-4.02651,12.03652,-1.59508),(-3.9646,14.74799,-1.32624),(-4.38741,14.5243,-1.70695),(-3.90791,12.83284,-1.72401),(-3.90267,12.02694,-1.77607),(-4.01253,12.84886,-1.67574),(-4.12554,13.57165,-1.60394),(-4.01457,13.54098,-1.6603),(-3.02943,2.61042,-2.73472),(-3.08047,2.3245,-3.09961),(-3.40188,1.75118,-2.50135),(-2.94228,2.78938,-2.4921),(-3.26275,2.11945,-2.56534),(-3.28327,2.10319,-2.51787),(-3.28426,1.92183,-2.59565),(-3.28654,3.1856,-2.53517),(-2.99622,2.67204,-2.96571),(-2.9989,4.00429,-2.36607),(-3.02949,4.06114,-2.50605),(-2.95377,3.22351,-2.48078),(-3.00285,3.29597,-2.66826),(-3.7302,9.28576,-1.67186),(-3.47866,8.03595,-1.7811),(-3.17476,2.73209,-3.20898),(-3.23682,2.33613,-3.15403),(-3.43094,2.30574,-2.95426),(-3.60351,2.20694,-2.67949),(-3.64078,2.12148,-2.43257),(-4.37272,14.30561,-1.24617),(-4.46713,14.49006,-1.23372),(-4.03868,14.84052,-1.53931)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesRightTibiaFibula.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesRightTibiaFibula.py load and self-test diagnostics complete.")
