####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesRightRadiusUlna.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesRightRadiusUlna.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Right RadiusUlna',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesRightRadiusUlna.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesRightRadiusUlna.x3d'),
    Transform(DEF='DSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Group(DEF='RightHumerus',
        #  rradius rulna 
        children=[
        Shape(DEF='rradius',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rradius_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,7,10,8,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,34,37,35,-1,35,37,38,-1,39,40,41,-1,40,42,41,-1,43,44,45,-1,43,46,44,-1,47,48,49,-1,47,50,48,-1,51,52,53,-1,53,54,51,-1,55,56,57,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,62,65,63,-1,66,67,63,-1,68,69,70,-1,70,71,68,-1,72,73,74,-1,75,76,77,-1,78,73,79,-1,72,80,73,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,92,93,90,-1,94,95,96,-1,25,88,97,-1,97,32,31,-1,95,94,98,-1,99,100,98,-1,99,33,100,-1,26,25,31,-1,25,97,31,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,108,110,109,-1,111,112,113,-1,114,115,116,-1,116,115,117,-1,115,118,117,-1,119,120,121,-1,122,123,124,-1,124,125,122,-1,126,127,128,-1,126,129,127,-1,126,130,129,-1,131,132,133,-1,131,134,132,-1,135,136,137,-1,136,138,137,-1,139,140,141,-1,142,140,143,-1,142,141,140,-1,128,144,145,-1,128,127,144,-1,146,147,121,-1,148,141,142,-1,148,149,141,-1,150,151,152,-1,150,153,151,-1,143,140,154,-1,154,155,156,-1,154,157,155,-1,140,158,154,-1,156,159,160,-1,161,162,163,-1,161,164,162,-1,165,166,167,-1,165,168,166,-1,134,169,132,-1,134,10,169,-1,170,171,172,-1,171,173,172,-1,174,175,176,-1,174,177,175,-1,135,178,136,-1,135,179,178,-1,180,181,182,-1,181,183,182,-1,184,185,186,-1,186,187,184,-1,4,188,189,-1,188,190,189,-1,188,4,191,-1,4,6,191,-1,192,117,193,-1,194,195,196,-1,144,197,113,-1,197,111,113,-1,198,199,193,-1,193,117,198,-1,200,117,201,-1,202,203,204,-1,203,146,204,-1,194,205,195,-1,194,206,205,-1,114,116,207,-1,144,127,129,-1,129,197,144,-1,208,209,210,-1,208,211,209,-1,209,191,210,-1,212,213,102,-1,213,103,102,-1,214,215,216,-1,216,217,214,-1,212,218,128,-1,212,102,218,-1,128,145,212,-1,144,113,219,-1,218,102,220,-1,102,217,220,-1,221,216,222,-1,216,223,222,-1,224,225,226,-1,225,227,226,-1,228,229,230,-1,229,231,230,-1,232,103,213,-1,232,233,103,-1,215,234,235,-1,234,236,235,-1,237,238,239,-1,237,240,238,-1,241,242,243,-1,241,244,242,-1,245,246,247,-1,245,84,246,-1,248,247,249,-1,250,51,54,-1,54,251,250,-1,252,253,254,-1,242,239,255,-1,255,256,242,-1,257,258,259,-1,259,260,257,-1,261,262,47,-1,47,49,261,-1,263,45,264,-1,263,265,45,-1,266,267,47,-1,47,262,266,-1,268,269,270,-1,270,271,268,-1,39,272,273,-1,39,41,272,-1,53,52,274,-1,275,276,277,-1,275,278,276,-1,279,280,281,-1,279,282,280,-1,62,283,284,-1,284,78,62,-1,285,286,287,-1,288,289,290,-1,95,291,292,-1,292,96,95,-1,292,293,294,-1,294,28,292,-1,295,13,296,-1,13,12,296,-1,297,298,299,-1,297,300,298,-1,301,302,303,-1,301,304,302,-1,305,301,306,-1,305,304,301,-1,239,307,255,-1,239,238,307,-1,22,21,16,-1,21,14,16,-1,20,308,18,-1,308,309,18,-1,310,311,312,-1,64,63,67,-1,67,66,313,-1,62,71,65,-1,314,315,316,-1,314,309,315,-1,317,318,319,-1,319,320,317,-1,321,322,323,-1,321,324,322,-1,325,326,327,-1,107,328,329,-1,107,109,328,-1,330,283,64,-1,330,331,283,-1,89,88,332,-1,88,333,332,-1,334,335,329,-1,334,327,335,-1,233,104,110,-1,233,232,104,-1,106,336,337,-1,106,105,336,-1,337,338,339,-1,337,336,338,-1,93,340,90,-1,88,87,97,-1,333,88,64,-1,92,326,325,-1,92,341,326,-1,342,343,91,-1,344,345,327,-1,345,335,327,-1,301,303,335,-1,335,345,301,-1,317,346,311,-1,70,347,348,-1,347,349,348,-1,324,321,313,-1,321,67,313,-1,62,64,283,-1,18,314,350,-1,18,309,314,-1,255,14,21,-1,255,307,14,-1,234,351,302,-1,302,304,234,-1,297,352,353,-1,353,354,297,-1,355,29,356,-1,356,24,355,-1,288,339,357,-1,357,289,288,-1,79,286,69,-1,79,287,286,-1,287,358,285,-1,358,359,285,-1,74,360,361,-1,360,362,361,-1,363,359,358,-1,364,278,275,-1,364,365,278,-1,283,366,284,-1,283,331,366,-1,367,277,276,-1,367,368,277,-1,76,369,77,-1,76,251,369,-1,39,48,40,-1,267,370,371,-1,371,50,267,-1,36,271,270,-1,45,265,43,-1,265,372,43,-1,373,374,261,-1,261,375,373,-1,376,248,377,-1,248,378,377,-1,248,249,378,-1,249,379,378,-1,296,12,380,-1,12,381,380,-1,382,256,383,-1,382,253,256,-1,12,11,381,-1,11,254,381,-1,11,252,254,-1,11,384,252,-1,251,385,250,-1,251,386,385,-1,85,84,245,-1,245,386,85,-1,75,387,300,-1,300,76,75,-1,388,243,252,-1,388,241,243,-1,235,236,240,-1,236,238,240,-1,234,215,351,-1,215,214,351,-1,389,218,390,-1,218,220,390,-1,226,227,228,-1,227,229,228,-1,230,219,147,-1,389,126,128,-1,128,218,389,-1,244,227,225,-1,244,241,227,-1,231,229,388,-1,388,391,231,-1,240,392,393,-1,240,237,392,-1,216,215,223,-1,215,235,223,-1,102,101,217,-1,101,214,217,-1,394,191,395,-1,394,188,191,-1,126,396,130,-1,126,389,396,-1,207,123,114,-1,207,397,123,-1,206,398,205,-1,206,399,398,-1,398,202,397,-1,202,204,397,-1,124,204,146,-1,125,400,122,-1,125,120,400,-1,401,119,121,-1,121,112,401,-1,121,113,112,-1,116,402,195,-1,191,6,193,-1,6,192,193,-1,403,196,404,-1,403,194,196,-1,9,5,7,-1,9,3,5,-1,136,178,405,-1,405,406,136,-1,176,407,179,-1,176,175,407,-1,180,408,181,-1,149,409,410,-1,149,411,409,-1,412,164,161,-1,412,413,164,-1,414,415,416,-1,414,172,415,-1,417,211,129,-1,129,130,417,-1,209,395,191,-1,118,201,117,-1,200,198,117,-1,125,121,120,-1,125,146,121,-1,125,124,146,-1,242,256,243,-1,108,418,110,-1,418,233,110,-1,231,391,419,-1,384,11,420,-1,421,100,422,-1,421,290,95,-1,25,24,356,-1,423,30,424,-1,423,422,30,-1,423,421,422,-1,32,97,425,-1,340,93,426,-1,323,427,321,-1,427,332,321,-1,332,333,321,-1,333,67,321,-1,76,86,85,-1,76,300,86,-1,360,74,73,-1,358,287,79,-1,358,73,80,-1,358,79,73,-1,352,297,299,-1,298,300,387,-1,64,67,333,-1,64,88,330,-1,88,25,330,-1,369,251,54,-1,53,82,369,-1,369,54,53,-1,369,82,77,-1,82,81,77,-1,57,428,61,-1,47,267,50,-1,35,371,370,-1,35,38,371,-1,37,34,286,-1,33,26,31,-1,33,99,26,-1,355,24,26,-1,429,430,258,-1,430,431,258,-1,431,259,258,-1,46,43,312,-1,416,175,414,-1,416,407,175,-1,432,171,165,-1,432,173,171,-1,195,402,196,-1,167,433,434,-1,435,433,167,-1,434,436,437,-1,434,433,436,-1,438,404,196,-1,183,404,438,-1,437,439,181,-1,437,436,439,-1,3,192,6,-1,192,3,440,-1,182,184,441,-1,442,184,182,-1,443,444,185,-1,445,444,443,-1,169,165,171,-1,165,169,168,-1,173,446,447,-1,446,173,432,-1,448,180,449,-1,180,448,408,-1,450,451,452,-1,453,451,450,-1,454,455,456,-1,457,455,454,-1,407,458,459,-1,458,407,416,-1,460,453,461,-1,460,451,453,-1,462,463,464,-1,131,463,462,-1,465,466,177,-1,466,465,133,-1,336,467,338,-1,467,336,295,-1,310,468,350,-1,468,310,372,-1,429,23,22,-1,23,429,258,-1,265,469,470,-1,265,263,469,-1,471,26,99,-1,471,355,26,-1,472,424,425,-1,473,424,472,-1,474,427,475,-1,474,476,427,-1,342,322,343,-1,342,323,322,-1,477,266,262,-1,264,266,477,-1,478,39,273,-1,479,39,478,-1,352,279,480,-1,352,299,279,-1,481,482,483,-1,481,353,482,-1,368,387,75,-1,368,367,387,-1,298,279,299,-1,279,298,282,-1,75,81,368,-1,81,75,77,-1,57,58,55,-1,61,58,57,-1,274,484,83,-1,272,484,274,-1,485,42,359,-1,42,485,41,-1,348,71,70,-1,71,348,65,-1,331,486,487,-1,331,330,486,-1,488,483,482,-1,488,489,483,-1,285,37,286,-1,38,37,285,-1,365,490,278,-1,490,365,361,-1,276,282,367,-1,276,280,282,-1,491,368,81,-1,491,277,368,-1,363,275,492,-1,275,363,364,-1,360,78,284,-1,360,73,78,-1,493,362,366,-1,493,494,362,-1,281,480,279,-1,281,495,480,-1,342,90,475,-1,91,90,342,-1,426,474,340,-1,426,473,474,-1,471,96,27,-1,94,96,471,-1,418,302,351,-1,108,302,418,-1,419,384,420,-1,384,419,391,-1,11,232,420,-1,11,104,232,-1,418,103,233,-1,418,101,103,-1,400,201,118,-1,496,201,400,-1,198,497,498,-1,198,200,497,-1,417,209,211,-1,417,395,209,-1,499,462,461,-1,499,500,462,-1,461,186,499,-1,453,186,461,-1,501,450,457,-1,501,187,450,-1,466,172,414,-1,466,170,172,-1,416,502,458,-1,416,415,502,-1,503,406,504,-1,406,503,505,-1,506,507,508,-1,507,506,509,-1,510,413,511,-1,510,164,413,-1,512,513,514,-1,513,512,162,-1,515,411,516,-1,515,409,411,-1,517,140,139,-1,517,158,140,-1,518,519,520,-1,518,521,519,-1,155,152,522,-1,152,155,157,-1,159,523,524,-1,523,159,156,-1,525,139,410,-1,139,525,517,-1,523,526,527,-1,523,522,526,-1,412,524,528,-1,524,412,529,-1,163,520,161,-1,520,163,518,-1,154,160,143,-1,156,160,154,-1,519,143,160,-1,519,521,143,-1,526,505,503,-1,526,151,505,-1,138,525,137,-1,138,153,525,-1,413,528,506,-1,528,413,412,-1,149,512,411,-1,148,512,149,-1,137,410,409,-1,410,137,525,-1,181,446,437,-1,181,408,446,-1,447,502,415,-1,447,448,502,-1,530,465,531,-1,530,463,465,-1,459,179,407,-1,179,459,178,-1,531,513,530,-1,513,531,514,-1,176,516,174,-1,516,176,515,-1,443,438,532,-1,442,438,443,-1,440,9,445,-1,440,3,9,-1,449,501,533,-1,449,441,501,-1,444,500,499,-1,444,8,500,-1,534,456,455,-1,405,456,534,-1,535,452,451,-1,536,452,535,-1,460,537,538,-1,460,464,537,-1,504,405,534,-1,406,405,504,-1,508,536,535,-1,507,536,508,-1,510,538,537,-1,511,538,510,-1,539,433,1,-1,539,436,433,-1,540,404,439,-1,540,403,404,-1,208,199,541,-1,210,199,208,-1,112,541,498,-1,112,111,541,-1,119,497,496,-1,119,401,497,-1,122,118,115,-1,122,400,118,-1,542,543,544,-1,543,542,545,-1,546,547,548,-1,546,549,547,-1,550,543,551,-1,550,552,543,-1,553,545,548,-1,554,545,553,-1,547,398,399,-1,547,202,398,-1,204,123,397,-1,204,124,123,-1,554,555,551,-1,555,554,556,-1,206,553,399,-1,557,553,206,-1,207,398,397,-1,205,398,207,-1,555,1,0,-1,1,555,539,-1,403,556,557,-1,540,556,403,-1,558,552,550,-1,559,552,558,-1,0,190,560,-1,0,2,190,-1,396,390,559,-1,389,390,396,-1,560,188,394,-1,560,190,188,-1,130,561,417,-1,130,396,561,-1,240,223,235,-1,240,393,223,-1,237,225,392,-1,237,244,225,-1,229,241,388,-1,241,229,227,-1,562,392,563,-1,562,393,392,-1,390,221,564,-1,390,220,221,-1,544,562,542,-1,544,222,562,-1,563,549,546,-1,563,224,549,-1,146,226,228,-1,203,226,146,-1,391,252,384,-1,252,391,388,-1,76,386,251,-1,85,386,76,-1,245,385,386,-1,245,376,385,-1,382,254,253,-1,381,254,382,-1,21,256,255,-1,383,256,21,-1,381,565,380,-1,381,382,565,-1,383,23,566,-1,383,21,23,-1,567,380,565,-1,568,380,567,-1,566,258,257,-1,566,23,258,-1,568,569,379,-1,568,567,569,-1,570,379,569,-1,378,379,570,-1,260,571,572,-1,260,259,571,-1,573,378,570,-1,377,378,573,-1,574,572,571,-1,575,572,574,-1,377,373,576,-1,377,573,373,-1,477,575,574,-1,374,575,477,-1,576,375,577,-1,576,373,375,-1,374,262,261,-1,374,477,262,-1,577,479,478,-1,577,375,479,-1,574,264,477,-1,263,264,574,-1,46,268,44,-1,46,269,268,-1,42,371,38,-1,42,40,371,-1,371,48,50,-1,371,40,48,-1,81,484,491,-1,81,83,484,-1,495,482,480,-1,482,495,488,-1,366,487,493,-1,487,366,331,-1,361,494,490,-1,362,494,361,-1,359,492,485,-1,492,359,363,-1,365,80,72,-1,365,364,80,-1,78,71,62,-1,68,71,78,-1,58,294,293,-1,58,60,294,-1,291,357,578,-1,357,291,289,-1,99,94,471,-1,99,98,94,-1,356,28,579,-1,356,29,28,-1,330,356,486,-1,330,25,356,-1,580,483,581,-1,580,481,483,-1,59,297,354,-1,59,582,297,-1,583,295,296,-1,295,583,467,-1,56,246,57,-1,56,584,246,-1,86,428,84,-1,428,86,582,-1,468,430,19,-1,430,468,470,-1,236,307,238,-1,236,305,307,-1,15,306,585,-1,14,306,15,-1,346,269,46,-1,346,586,269,-1,36,587,34,-1,587,36,270,-1,324,349,319,-1,349,324,313,-1,347,34,587,-1,347,70,34,-1,320,587,586,-1,320,347,587,-1,301,585,306,-1,585,301,345,-1,345,308,585,-1,308,345,344,-1,309,344,315,-1,309,308,344,-1,311,316,588,-1,311,314,316,-1,317,588,318,-1,317,311,588,-1,343,92,91,-1,343,341,92,-1,475,340,474,-1,475,90,340,-1,589,92,325,-1,93,92,589,-1,288,589,334,-1,288,290,589,-1,421,426,93,-1,421,423,426,-1,425,87,472,-1,97,87,425,-1,106,328,109,-1,106,337,328,-1,339,56,357,-1,339,338,56,-1,578,56,55,-1,56,578,357,-1,337,288,328,-1,337,339,288,-1,104,109,110,-1,104,106,109,-1,30,100,33,-1,422,100,30,-1,473,423,424,-1,426,423,473,-1,93,290,421,-1,589,290,93,-1,328,334,329,-1,328,288,334,-1,334,325,327,-1,589,325,334,-1,332,476,89,-1,427,476,332,-1,335,107,329,-1,303,107,335,-1,319,322,324,-1,319,318,322,-1,343,318,588,-1,318,343,322,-1,588,341,343,-1,588,316,341,-1,316,326,341,-1,316,315,326,-1,327,315,344,-1,315,327,326,-1,586,317,320,-1,586,346,317,-1,313,348,349,-1,313,66,348,-1,319,347,320,-1,319,349,347,-1,586,270,269,-1,586,587,270,-1,310,314,311,-1,310,350,314,-1,585,20,15,-1,585,308,20,-1,305,14,307,-1,305,306,14,-1,17,22,16,-1,22,17,429,-1,429,19,430,-1,429,17,19,-1,469,259,431,-1,259,469,571,-1,234,305,236,-1,234,304,305,-1,86,297,582,-1,86,300,297,-1,57,84,428,-1,57,246,84,-1,584,338,467,-1,584,56,338,-1,467,249,584,-1,249,467,583,-1,61,582,59,-1,61,428,582,-1,579,486,356,-1,486,579,489,-1,579,294,581,-1,579,28,294,-1,27,292,28,-1,27,96,292,-1,578,292,291,-1,578,293,292,-1,95,289,291,-1,290,289,95,-1,60,581,294,-1,60,580,581,-1,55,293,578,-1,293,55,58,-1,493,488,495,-1,488,493,487,-1,281,490,494,-1,281,280,490,-1,485,491,484,-1,491,485,492,-1,272,52,273,-1,52,272,274,-1,268,370,267,-1,271,370,268,-1,268,266,44,-1,267,266,268,-1,263,571,469,-1,574,571,263,-1,372,470,468,-1,372,265,470,-1,375,49,479,-1,375,261,49,-1,478,250,577,-1,51,250,478,-1,577,385,576,-1,250,385,577,-1,573,374,373,-1,573,575,374,-1,376,576,385,-1,376,377,576,-1,575,570,572,-1,573,570,575,-1,569,572,570,-1,569,260,572,-1,567,260,569,-1,567,257,260,-1,379,583,568,-1,249,583,379,-1,565,257,567,-1,565,566,257,-1,296,568,583,-1,296,380,568,-1,566,382,383,-1,565,382,566,-1,256,252,243,-1,253,252,256,-1,247,376,245,-1,247,248,376,-1,247,584,249,-1,247,246,584,-1,239,244,237,-1,239,242,244,-1,228,147,146,-1,228,230,147,-1,224,203,549,-1,224,226,203,-1,562,546,542,-1,562,563,546,-1,564,222,544,-1,564,221,222,-1,392,224,563,-1,392,225,224,-1,393,222,223,-1,222,393,562,-1,220,216,221,-1,220,217,216,-1,147,113,121,-1,147,219,113,-1,419,212,231,-1,419,213,212,-1,208,129,211,-1,197,129,208,-1,394,417,561,-1,394,395,417,-1,558,394,561,-1,558,560,394,-1,559,561,396,-1,559,558,561,-1,550,560,558,-1,550,0,560,-1,559,564,552,-1,390,564,559,-1,205,116,195,-1,205,207,116,-1,557,194,403,-1,557,206,194,-1,556,539,555,-1,539,556,540,-1,557,554,553,-1,556,554,557,-1,551,0,550,-1,0,551,555,-1,399,548,547,-1,553,548,399,-1,551,545,554,-1,551,543,545,-1,202,549,203,-1,547,549,202,-1,542,548,545,-1,542,546,548,-1,544,552,564,-1,552,544,543,-1,496,200,201,-1,496,497,200,-1,199,498,541,-1,498,199,198,-1,541,197,208,-1,541,111,197,-1,199,191,193,-1,191,199,210,-1,540,436,539,-1,540,439,436,-1,2,189,190,-1,435,189,2,-1,510,530,513,-1,510,537,530,-1,511,535,538,-1,508,535,511,-1,507,534,536,-1,504,534,507,-1,537,463,530,-1,537,464,463,-1,538,451,460,-1,535,451,538,-1,455,536,534,-1,455,452,536,-1,8,134,500,-1,8,10,134,-1,185,499,186,-1,185,444,499,-1,441,187,501,-1,441,184,187,-1,532,445,443,-1,532,440,445,-1,442,183,438,-1,182,183,442,-1,179,515,176,-1,515,179,135,-1,514,174,516,-1,514,531,174,-1,459,405,178,-1,459,456,405,-1,177,531,465,-1,531,177,174,-1,448,533,502,-1,448,449,533,-1,172,447,415,-1,172,173,447,-1,132,171,170,-1,132,169,171,-1,432,437,446,-1,432,434,437,-1,7,166,168,-1,5,166,7,-1,148,162,512,-1,163,162,148,-1,528,509,506,-1,527,509,528,-1,505,153,138,-1,505,151,153,-1,527,503,509,-1,527,526,503,-1,142,163,148,-1,518,163,142,-1,161,529,412,-1,529,161,520,-1,527,524,523,-1,527,528,524,-1,522,151,526,-1,152,151,522,-1,153,517,525,-1,517,153,150,-1,139,149,410,-1,139,141,149,-1,192,116,117,-1,192,402,116,-1,219,145,144,-1,145,219,230,-1,159,529,160,-1,524,529,159,-1,156,522,523,-1,522,156,155,-1,152,154,150,-1,152,157,154,-1,143,518,142,-1,518,143,521,-1,150,158,517,-1,150,154,158,-1,520,160,529,-1,520,519,160,-1,135,409,515,-1,135,137,409,-1,411,514,516,-1,514,411,512,-1,513,164,510,-1,513,162,164,-1,511,506,508,-1,511,413,506,-1,509,504,507,-1,504,509,503,-1,406,138,136,-1,406,505,138,-1,502,454,458,-1,502,533,454,-1,170,133,132,-1,133,170,466,-1,533,457,454,-1,533,501,457,-1,187,453,450,-1,187,186,453,-1,500,131,462,-1,500,134,131,-1,145,231,212,-1,145,230,231,-1,401,498,497,-1,112,498,401,-1,115,123,122,-1,115,114,123,-1,496,120,119,-1,496,400,120,-1,104,13,105,-1,11,13,104,-1,420,213,419,-1,213,420,232,-1,101,351,214,-1,418,351,101,-1,303,108,107,-1,303,302,108,-1,100,95,98,-1,100,421,95,-1,89,472,87,-1,476,472,89,-1,495,494,493,-1,494,495,281,-1,360,366,362,-1,366,360,284,-1,358,364,363,-1,358,80,364,-1,492,277,491,-1,492,275,277,-1,69,78,79,-1,69,68,78,-1,278,280,276,-1,278,490,280,-1,72,361,365,-1,361,72,74,-1,69,34,70,-1,286,34,69,-1,38,359,42,-1,38,285,359,-1,489,487,486,-1,487,489,488,-1,348,63,65,-1,348,66,63,-1,41,484,272,-1,41,485,484,-1,53,83,82,-1,53,274,83,-1,481,354,353,-1,354,481,580,-1,60,354,580,-1,60,59,354,-1,367,298,387,-1,282,298,367,-1,353,480,482,-1,353,352,480,-1,581,489,579,-1,483,489,581,-1,51,273,52,-1,478,273,51,-1,479,48,39,-1,49,48,479,-1,264,44,266,-1,45,44,264,-1,46,311,346,-1,311,46,312,-1,271,35,370,-1,36,35,271,-1,475,323,342,-1,475,427,323,-1,476,473,472,-1,474,473,476,-1,425,30,32,-1,424,30,425,-1,27,355,471,-1,27,29,355,-1,470,431,430,-1,431,470,469,-1,372,312,43,-1,372,310,312,-1,468,18,350,-1,19,18,468,-1,17,15,20,-1,16,15,17,-1,295,105,13,-1,295,336,105,-1,177,414,175,-1,414,177,466,-1,463,133,465,-1,133,463,131,-1,461,464,460,-1,462,464,461,-1,458,456,459,-1,454,456,458,-1,457,452,455,-1,450,452,457,-1,180,441,449,-1,182,441,180,-1,446,448,447,-1,408,448,446,-1,10,168,169,-1,168,10,7,-1,445,8,444,-1,9,8,445,-1,442,185,184,-1,443,185,442,-1,5,189,166,-1,5,4,189,-1,440,402,192,-1,402,440,532,-1,166,435,167,-1,166,189,435,-1,532,196,402,-1,438,196,532,-1,439,183,181,-1,439,404,183,-1,165,434,432,-1,167,434,165,-1,1,435,2,-1,1,433,435,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rradius_Coord',point=[(-8.01622,35.89713,-.86484),(-8.01291,36.02124,-.92244),(-8.02081,36.00597,-.94664),(-7.83268,36.2605,-1.28912),(-7.95366,36.20609,-1.24432),(-7.9621,36.25911,-1.2772),(-7.8291,36.20055,-1.26624),(-7.98413,36.37041,-1.37103),(-7.8305,36.41838,-1.38802),(-7.83285,36.37017,-1.35203),(-7.99442,36.41177,-1.41605),(-7.66159,32.21879,.83796),(-7.56841,31.39333,1.18256),(-7.58153,31.38452,1.17213),(-7.73067,31.58696,1.62114),(-7.62927,30.85178,2.00828),(-7.59703,30.85569,2.01223),(-7.56186,30.59134,2.14599),(-7.56444,30.28703,2.36027),(-7.52665,30.29452,2.36957),(-7.59958,30.58624,2.14714),(-7.66044,31.58279,1.61085),(-7.57218,30.84395,2.00512),(-7.54083,30.82639,1.97878),(-7.73509,29.31827,2.13628),(-7.72561,29.29596,2.26292),(-7.74591,29.40659,2.11727),(-7.71923,29.44869,1.98832),(-7.67397,29.39229,1.89213),(-7.71641,29.39684,2.01024),(-7.79868,29.52521,2.09225),(-7.75338,29.41859,2.12529),(-7.78552,29.43348,2.14876),(-7.75495,29.51366,2.06755),(-7.43099,29.28159,2.87032),(-7.35145,29.34305,2.88448),(-7.38747,29.35798,2.90515),(-7.3964,29.26949,2.83954),(-7.28385,29.33297,2.75208),(-7.04382,29.38647,2.38595),(-7.12233,29.42285,2.57208),(-7.10256,29.33212,2.35831),(-7.18083,29.36385,2.57351),(-7.42387,29.93579,2.66963),(-7.33685,29.85672,2.75396),(-7.36296,29.93069,2.6745),(-7.42472,29.82809,2.7575),(-7.19201,29.62917,2.67832),(-7.12686,29.50217,2.54038),(-7.12819,29.54576,2.51883),(-7.20157,29.57431,2.69926),(-6.96404,29.32432,1.99248),(-6.95414,29.29005,2.01379),(-6.98003,29.28983,1.96228),(-6.9944,29.30912,1.94359),(-7.5317,29.69624,1.71974),(-7.51844,29.94661,1.67587),(-7.50333,29.68826,1.71524),(-7.54671,29.54239,1.73045),(-7.5213,29.39257,1.75996),(-7.55235,29.39051,1.76094),(-7.51756,29.54096,1.72341),(-7.56941,29.21345,2.61806),(-7.67446,29.23249,2.49208),(-7.64244,29.20889,2.42052),(-7.62345,29.22245,2.65825),(-7.68466,29.25862,2.51136),(-7.67372,29.2761,2.43339),(-7.48515,29.2341,2.77994),(-7.4805,29.23602,2.7821),(-7.49317,29.24641,2.79584),(-7.50481,29.22566,2.75925),(-7.41181,29.35575,2.534),(-7.43631,29.31952,2.59683),(-7.45585,29.33824,2.50431),(-7.09241,29.29786,1.91752),(-7.16416,29.37168,1.88407),(-7.04609,29.29213,1.93175),(-7.46177,29.27876,2.6414),(-7.41575,29.29869,2.65871),(-7.36136,29.37311,2.55782),(-7.04345,29.27847,1.95093),(-7.00875,29.28157,1.94067),(-6.98965,29.25017,2.03586),(-7.335,29.59057,1.77778),(-7.24878,29.47063,1.83686),(-7.3084,29.45432,1.82108),(-7.74767,29.31165,2.29935),(-7.70089,29.25535,2.3409),(-7.74905,29.32338,2.32628),(-7.81255,29.65853,2.17127),(-7.80227,29.67322,2.20357),(-7.81527,29.86937,2.10765),(-7.79083,29.83994,2.03719),(-7.72715,29.5964,1.95552),(-7.72944,29.80106,1.91839),(-7.71714,29.59099,1.93203),(-7.74065,29.31001,2.2733),(-7.7414,29.603,2.00472),(-7.74378,29.50592,2.06001),(-7.74952,29.61289,2.01668),(-7.98042,34.00281,.14777),(-7.87933,34.64914,-.35318),(-7.8501,33.93281,.06005),(-7.6867,32.21332,.82795),(-7.60058,31.37591,1.16818),(-7.62556,31.36747,1.17068),(-7.90597,31.42538,1.37509),(-7.99089,32.33359,.98151),(-7.7868,31.38458,1.25679),(-7.82142,32.25788,.90899),(-7.66848,35.51855,-.99217),(-7.63798,35.52862,-.96878),(-7.66216,35.40354,-.84195),(-7.57595,35.84926,-1.02637),(-7.58863,35.8376,-1.03809),(-7.6174,36.00715,-1.07624),(-7.65846,35.96892,-1.14381),(-7.61655,35.8136,-1.0614),(-7.60657,35.56075,-.90678),(-7.59406,35.57076,-.89448),(-7.58156,35.45247,-.79625),(-7.5481,35.73728,-.97352),(-7.52992,35.75877,-.95478),(-7.52081,35.61256,-.86263),(-7.54291,35.59805,-.8816),(-7.81482,35.39708,-.87287),(-7.79748,35.39783,-.87316),(-7.80043,34.99104,-.60423),(-7.82457,35.50461,-.95645),(-7.8404,35.50623,-.94989),(-8.00973,36.46313,-1.50242),(-8.15727,36.5101,-1.37179),(-8.17277,36.52177,-1.38974),(-8.00559,36.44501,-1.46646),(-8.22411,36.90809,-1.10894),(-8.06292,36.93488,-.99906),(-8.20824,36.91568,-1.12441),(-8.0524,36.93698,-1.02628),(-8.07774,36.76954,-1.28949),(-7.99355,36.7543,-1.30388),(-8.07532,36.75877,-1.30845),(-8.0372,36.74069,-1.37114),(-7.98047,36.75182,-1.32579),(-7.72635,35.38723,-.85701),(-7.75714,35.00477,-.5957),(-7.52147,35.50835,-.73382),(-7.60097,35.31856,-.71015),(-8.14459,36.73752,-1.42976),(-8.20551,36.78502,-1.33952),(-7.99042,36.80314,-1.20279),(-7.89914,36.87939,-1.09179),(-7.93098,36.79965,-1.21142),(-8.0226,36.90469,-1.09912),(-7.96495,36.76924,-1.2683),(-7.93587,36.76659,-1.27476),(-7.91899,36.75646,-1.29113),(-7.94493,36.76807,-1.2712),(-7.98663,36.76951,-1.27548),(-7.90968,36.75048,-1.31341),(-7.91794,36.74571,-1.32479),(-7.85034,36.71795,-1.48747),(-8.03266,36.69625,-1.54817),(-8.01574,36.71049,-1.49989),(-7.80874,36.69224,-1.53647),(-8.13338,36.4598,-1.21632),(-8.06292,36.314,-1.21242),(-8.08146,36.34056,-1.15093),(-8.09422,36.42375,-1.2763),(-8.11448,36.46645,-1.31521),(-8.22626,36.57549,-1.27265),(-8.16416,36.51027,-1.24064),(-8.24159,36.63123,-1.17885),(-8.14701,36.55218,-1.17415),(-8.28193,36.68484,-1.3223),(-8.27655,36.67086,-1.19529),(-8.29027,36.75463,-1.20585),(-8.25483,36.60791,-1.30246),(-8.07934,36.89338,-.95215),(-8.21828,36.84672,-1.05344),(-7.90808,36.6016,-.94977),(-7.93778,36.47747,-.95105),(-7.79323,36.56297,-.99121),(-7.80924,36.45411,-.96221),(-7.67157,36.5561,-1.11101),(-7.65171,36.49906,-1.25234),(-7.59959,36.57294,-1.24369),(-7.62732,36.64818,-1.10671),(-7.91715,35.91709,-1.11921),(-8.04916,36.2584,-1.18484),(-8.00477,35.96906,-1.031),(-7.80123,35.91426,-1.1793),(-7.73522,36.22695,-1.22451),(-7.70675,35.95003,-1.16511),(-7.63342,36.13115,-.87416),(-7.58909,36.06818,-1.00132),(-7.6874,36.33641,-1.03675),(-7.76104,35.50192,-.98422),(-7.6687,35.74501,-1.14457),(-7.69637,35.74331,-1.16333),(-7.65629,35.75254,-1.13065),(-7.62856,35.79985,-1.07575),(-7.50645,35.67802,-.75342),(-7.51097,35.55282,-.67479),(-7.49773,35.63407,-.8113),(-7.52787,35.92611,-.9161),(-7.6155,36.01812,-.79014),(-7.54177,35.88711,-.98564),(-7.7902,35.64289,-1.11948),(-7.84962,35.74105,-1.1251),(-7.80351,35.73907,-1.15694),(-7.85085,35.64977,-1.06212),(-7.78075,34.64534,-.38638),(-7.74434,33.92194,-.02588),(-7.99959,34.02759,.1833),(-7.99744,34.07341,.25521),(-8.01531,34.78298,-.15061),(-7.95971,34.71365,-.24341),(-7.8667,34.99796,-.55863),(-7.65432,35.29297,-.74579),(-7.97277,35.0468,-.48859),(-8.01597,35.11942,-.3856),(-7.97334,35.21106,-.30845),(-7.95662,34.85491,-.07343),(-7.62301,35.22458,-.3015),(-7.62402,34.85888,-.07218),(-7.56663,35.1729,-.3781),(-7.58602,34.80328,-.14742),(-7.57102,35.09944,-.45924),(-7.60748,34.75447,-.24443),(-7.63801,35.06306,-.54586),(-7.65737,34.71661,-.35832),(-7.73245,33.15739,.30786),(-7.86151,33.21369,.44303),(-8.03439,33.34969,.63662),(-7.97035,34.13335,.35115),(-7.97349,33.37874,.74368),(-7.74172,34.17258,.44381),(-7.88036,33.43049,.77248),(-7.74113,33.41267,.7764),(-7.86398,34.19755,.40962),(-7.64284,34.11681,.2391),(-7.69215,33.39745,.73977),(-7.6898,33.35131,.64821),(-7.62456,34.14269,.37175),(-7.26412,29.60237,1.82486),(-7.38416,29.7226,1.75499),(-7.33635,29.7673,1.808),(-7.3109,29.79109,1.84736),(-7.3916,30.01102,1.76882),(-7.03046,29.41797,1.94685),(-7.09016,29.38596,1.90135),(-7.68623,33.28122,.50914),(-7.62924,32.32719,.98564),(-7.62658,32.30656,.93446),(-7.69635,32.44766,1.20289),(-7.62741,32.39873,1.10927),(-7.45725,30.54772,2.04656),(-7.49466,30.57584,2.09682),(-7.44344,30.21743,2.27532),(-7.4303,30.18628,2.20073),(-7.1778,29.60257,2.50703),(-7.213,29.71055,2.63421),(-7.37922,29.98763,2.57773),(-7.32667,29.92382,2.66148),(-7.41317,30.00281,2.60471),(-7.27217,29.83703,2.72443),(-7.25605,29.69496,2.7992),(-7.33096,29.70193,2.83854),(-7.42711,29.67636,2.84353),(-7.40194,29.46461,2.91063),(-7.3499,29.46672,2.89966),(-6.96736,29.27361,2.17097),(-6.96111,29.31339,2.19763),(-6.96427,29.26373,2.03584),(-7.22837,29.35338,2.30123),(-7.26323,29.32169,2.09775),(-7.1463,29.33186,2.09151),(-7.32382,29.35691,2.26299),(-7.33117,29.25623,1.94377),(-7.30962,29.3068,2.08426),(-7.38874,29.2442,2.03505),(-7.25476,29.28167,1.93492),(-7.62509,29.19968,2.41755),(-7.56238,29.27157,2.45213),(-7.29658,29.32405,2.72719),(-7.42095,29.25725,2.82488),(-7.37756,29.30589,2.68165),(-7.70484,30.27176,1.69611),(-7.67505,29.95232,1.78351),(-7.71841,29.97414,1.83706),(-7.66747,29.77192,1.81926),(-7.67937,29.57062,1.83417),(-7.60037,29.55371,1.75813),(-7.614,29.39813,1.79001),(-7.50681,30.55285,1.52858),(-7.48514,30.59835,1.54832),(-7.39421,29.30945,1.84512),(-7.25748,29.29238,1.9089),(-7.33561,29.26429,1.91482),(-7.26618,29.34514,1.87692),(-7.91862,31.51502,1.45057),(-8.00726,32.35099,1.0196),(-7.92232,31.45703,1.41053),(-7.98629,32.38501,1.05501),(-7.90282,32.41198,1.1894),(-7.80843,31.59243,1.56381),(-7.78703,32.45029,1.23317),(-7.64459,30.57331,2.1322),(-7.60598,30.25753,2.32457),(-7.48745,29.98375,2.61961),(-7.62394,29.89046,2.58308),(-7.47428,29.93163,2.65608),(-7.6837,29.31323,2.51742),(-7.61802,30.06198,2.44895),(-7.73245,30.19192,2.21554),(-7.71272,29.99122,2.32747),(-7.63443,29.71575,2.66179),(-7.69585,29.61519,2.51617),(-7.69709,29.51738,2.59367),(-7.59943,29.5839,2.72636),(-7.73818,29.38653,2.40772),(-7.74184,29.54652,2.39892),(-7.77223,29.51806,2.33574),(-7.73146,29.42278,2.45389),(-7.78739,30.05318,2.04988),(-7.7812,30.12304,2.09551),(-7.80539,30.414,1.94157),(-7.72645,30.50628,1.59377),(-7.81808,30.6134,1.70791),(-7.62669,29.17412,2.32118),(-7.60628,29.17611,2.33466),(-7.73096,29.37436,2.37192),(-7.67406,29.26645,2.40529),(-7.79535,30.30944,1.8338),(-7.85357,30.68526,1.8087),(-7.54733,30.54372,1.51592),(-7.60739,30.50396,1.54048),(-7.53427,30.28397,1.59544),(-7.60038,30.26457,1.63121),(-7.82498,29.65103,2.12817),(-7.76099,29.92008,2.20495),(-7.79376,29.62936,2.24076),(-7.75468,29.72454,2.30716),(-7.76784,30.51937,2.02744),(-7.80218,30.77756,1.86319),(-7.57295,29.75558,2.70949),(-7.54285,29.41173,2.79239),(-7.63637,29.24391,2.66858),(-7.65466,29.38154,2.65652),(-7.53787,30.10545,2.49456),(-8.02683,33.32287,.5914),(-7.38332,29.23371,1.91217),(-7.45715,29.14708,1.88675),(-7.50661,29.23956,1.81189),(-7.72089,29.39775,2.03749),(-7.72861,29.2898,2.13996),(-7.59481,29.92373,1.71489),(-7.33167,29.36022,2.59178),(-7.19907,29.35175,2.56012),(-7.52498,29.30667,2.44231),(-7.44742,29.3419,2.45373),(-7.51156,29.29366,2.3798),(-7.27537,29.37361,2.50633),(-7.32003,29.37565,2.48172),(-7.40074,29.36002,2.46526),(-7.55189,29.2606,2.37483),(-7.2026,29.2891,1.93349),(-7.09866,29.28577,1.93871),(-7.00969,29.30049,1.92756),(-7.30746,29.46331,2.87432),(-7.20955,29.43675,2.75597),(-7.44859,29.99973,2.61842),(-7.22634,29.63242,2.22505),(-7.26258,29.74046,2.42618),(-7.10572,29.51329,2.31686),(-7.23106,29.65639,1.87977),(-7.25825,29.68341,2.06264),(-7.32927,29.84379,1.99698),(-7.37407,30.05566,1.912),(-7.45011,30.67826,1.64832),(-7.54611,31.45272,1.32382),(-7.55745,31.48653,1.42793),(-7.60885,31.56099,1.535),(-7.69926,33.22227,.41069),(-7.15291,29.54672,1.92452),(-7.18914,29.48693,1.85265),(-7.20291,29.30102,1.9084),(-7.67308,34.03664,.14206),(-7.88457,35.3789,-.85252),(-7.97377,35.41751,-.73613),(-7.69552,33.98511,.06066),(-7.74145,34.89888,-.01658),(-7.85007,34.90196,-.00868),(-7.89805,35.74672,-1.0833),(-7.8639,35.74226,-1.11385),(-7.88807,35.51396,-.93117),(-7.51392,35.80058,-.91249),(-7.50547,35.84767,-.85136),(-7.60438,35.91927,-.7344),(-7.5906,35.72256,-1.00542),(-7.62701,35.53581,-.95329),(-7.67781,36.2722,-1.14224),(-7.77459,36.18204,-.79902),(-7.80955,36.39658,-.93737),(-7.89658,36.86434,-.92356),(-7.89314,36.90388,-.98292),(-8.21162,36.79299,-1.02587),(-7.96544,36.58904,-.98386),(-8.26407,36.84579,-1.25625),(-8.20815,36.82313,-1.2608),(-8.25371,36.78593,-1.34818),(-7.78484,36.72515,-1.43754),(-7.71446,36.70974,-1.47815),(-8.26218,36.64704,-1.18396),(-8.19523,36.74855,-1.01081),(-8.20483,36.76748,-1.01536),(-7.8656,35.65478,-1.05437),(-8.0044,33.29852,.55447),(-7.71797,33.93358,-.02074),(-7.71227,33.1633,.31222),(-7.74041,29.8065,1.9353),(-7.79335,29.62424,2.04516),(-7.80472,29.62812,2.06133),(-7.81378,29.52965,2.10633),(-7.80435,29.43845,2.16074),(-7.82555,29.64063,2.10329),(-7.78283,29.49535,2.31058),(-7.48111,29.54504,1.73299),(-7.53142,30.58862,2.12876),(-7.48597,30.28474,2.35817),(-7.45672,30.26245,2.33102),(-8.11326,36.5035,-1.16084),(-8.05028,36.30827,-1.07616),(-8.06432,36.36426,-1.10264),(-8.06757,36.28477,-1.1239),(-7.99711,36.37513,-.987),(-8.0096,36.43363,-1.0078),(-7.69181,36.39131,-1.06601),(-7.93321,36.4184,-.93162),(-7.73967,36.28578,-1.2475),(-7.77889,36.62362,-.99275),(-7.6865,36.49658,-1.10137),(-7.67114,36.44514,-1.22359),(-7.72366,36.44951,-1.34174),(-7.73425,36.39922,-1.30674),(-8.05461,36.57426,-1.03959),(-8.08505,36.62755,-1.04097),(-7.98573,36.64703,-.98246),(-7.90236,36.66412,-.9407),(-7.60956,36.68111,-1.11217),(-7.57389,36.62094,-1.27767),(-7.60185,36.70867,-1.12165),(-7.58288,36.59392,-1.26133),(-7.90333,36.79874,-.90128),(-7.72951,36.79921,-.97157),(-7.90128,36.82781,-.90733),(-7.73332,36.76478,-.96423),(-8.06463,36.81964,-.92803),(-8.06688,36.85279,-.93324),(-7.67472,36.53775,-1.42691),(-7.68564,36.51244,-1.40661),(-7.81595,36.47291,-1.48856),(-8.01356,36.48735,-1.52548),(-7.8125,36.49498,-1.51304),(-8.18294,36.54302,-1.40847),(-8.24268,36.58702,-1.28618),(-7.48073,30.30707,1.60645),(-7.49979,30.11416,2.5008),(-7.43239,30.09123,2.46194),(-7.4646,30.10935,2.49),(-7.72664,29.46838,2.00698),(-7.8215,29.45125,2.19145),(-7.83277,29.5423,2.14266),(-7.83328,29.55604,2.16914),(-7.80311,29.60682,2.21522),(-7.82307,29.4683,2.21951),(-7.27523,29.80857,2.52483),(-6.96754,29.35475,2.18421),(-7.04834,29.43076,2.36635),(-7.38114,29.22411,1.94114),(-7.47963,29.14784,1.88069),(-7.46078,29.13122,1.91349),(-7.48412,29.12956,1.90353),(-6.98726,29.26281,2.165),(-7.12047,29.31994,2.35326),(-7.5987,29.14893,2.17018),(-7.57548,29.14914,2.17684),(-7.51248,29.12957,2.03541),(-7.53579,29.12766,2.02506),(-7.36826,29.34278,2.24662),(-7.10044,29.32235,2.11014),(-7.18242,29.34396,2.32195),(-7.49782,29.2403,2.20363),(-7.46049,29.27511,2.2162),(-7.42445,29.20969,2.01749),(-7.6093,35.70899,-1.0293),(-7.63348,35.67865,-1.09299),(-7.6475,35.66436,-1.1061),(-7.70329,36.49289,-1.38389),(-7.82118,36.45853,-1.45038),(-7.74255,36.72869,-.96686),(-8.05858,36.78897,-.93115),(-7.77482,36.87832,-1.05135),(-7.76306,36.87421,-1.0304),(-7.89344,36.90567,-1.00295),(-7.63593,36.75448,-1.35433),(-7.63014,36.80166,-1.18194),(-7.60148,36.72905,-1.34631),(-7.65404,36.81356,-1.19788),(-7.79957,36.64222,-1.56697),(-7.67783,36.66497,-1.48441),(-8.1899,36.7347,-1.46385),(-8.04279,36.64363,-1.57685),(-8.21936,36.69456,-1.46832),(-8.29711,36.82083,-1.2356),(-8.28806,36.75662,-1.34182),(-8.04709,36.80008,-1.22992),(-7.9877,36.7302,-1.40596),(-7.92892,36.74425,-1.33618),(-7.88342,36.72894,-1.40435),(-7.96509,36.74565,-1.3406),(-7.90406,36.79529,-1.22199),(-7.85396,36.76519,-1.27057),(-7.83453,36.74776,-1.33443),(-8.15585,36.88363,-1.15549),(-7.8196,36.85795,-1.11985),(-7.73816,36.80348,-1.22683),(-7.72571,36.75424,-1.34465),(-7.85084,36.73327,-1.37053),(-8.02317,36.56435,-1.56096),(-8.21786,36.62626,-1.43557),(-7.68328,36.32865,-1.16834),(-7.90318,36.77354,-.90381),(-7.74148,36.82639,-.97842),(-7.57186,36.67324,-1.30145),(-7.60335,36.73241,-1.13538),(-7.80732,36.56167,-1.54796),(-7.66599,36.60239,-1.46411),(-7.97351,36.10121,-.84954),(-7.89421,36.15762,-.78596),(-7.68405,35.64232,-1.12138),(-7.86752,35.68972,-.4638),(-7.99702,35.76071,-.62027),(-7.98507,35.61515,-.52339),(-7.87715,35.81905,-.54344),(-7.7238,35.68458,-.4768),(-7.59722,35.74981,-.62857),(-7.73045,35.79942,-.55655),(-7.59389,35.63188,-.5562),(-8.02311,35.78869,-.80741),(-7.97829,35.88069,-.71534),(-8.03567,35.68026,-.74542),(-7.73316,35.95696,-.66382),(-7.86537,35.95964,-.64525),(-7.9735,35.9802,-.78456),(-7.86353,36.05196,-.70486),(-7.74069,36.05788,-.7181),(-7.99555,35.69987,-.91137),(-7.99231,35.59051,-.84213),(-7.99203,35.81502,-.96632),(-7.8907,35.63607,-1.02135),(-7.8488,35.25755,-.22154),(-7.73573,35.26722,-.24622),(-8.02913,35.51329,-.62012),(-7.45958,30.73967,1.77125),(-7.50525,30.80183,1.91992),(-7.41349,30.4664,1.87572),(-7.41324,30.40528,1.77709),(-7.3772,30.08762,2.01203),(-7.35305,29.89135,2.11074),(-7.40004,30.02891,2.37534),(-7.37738,29.96436,2.2854),(-7.28632,29.7095,2.19606),(-7.32233,29.88911,2.47671),(-7.30763,29.81139,2.36882),(-7.19829,29.59152,2.07905),(-7.03522,29.4572,2.13515),(-7.58865,29.74081,1.74461),(-7.66801,29.25077,1.95778),(-7.53676,29.22899,1.81562),(-7.57714,29.22572,1.83747),(-7.44794,29.41132,1.78981),(-7.4363,30.33386,1.65669),(-7.44207,29.9501,1.6969),(-7.66889,30.83222,1.99324),(-7.547,29.63269,2.7935),(-7.47617,29.44759,2.87028),(-7.71935,29.80168,2.41849),(-7.78864,30.00835,1.96642)]))),
        Shape(DEF='rulna',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0.5),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rulna_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,5,6,3,-1,7,8,9,-1,10,11,12,-1,12,13,10,-1,14,15,16,-1,15,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,33,36,34,-1,37,38,39,-1,40,41,42,-1,41,43,42,-1,44,45,46,-1,47,48,49,-1,47,50,48,-1,51,52,53,-1,54,55,56,-1,53,57,51,-1,58,59,60,-1,61,62,63,-1,64,65,62,-1,65,63,62,-1,66,67,68,-1,61,6,62,-1,69,62,6,-1,69,70,62,-1,71,72,73,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,78,81,79,-1,82,83,84,-1,85,86,87,-1,85,88,86,-1,89,9,8,-1,90,91,92,-1,93,94,95,-1,94,96,95,-1,97,98,99,-1,100,101,102,-1,103,104,105,-1,103,106,104,-1,107,108,109,-1,107,106,108,-1,110,111,112,-1,110,113,111,-1,114,115,116,-1,114,117,115,-1,96,114,116,-1,96,118,114,-1,119,120,121,-1,122,123,124,-1,122,125,123,-1,126,127,128,-1,127,129,128,-1,123,125,130,-1,131,31,132,-1,132,133,131,-1,134,135,136,-1,137,138,139,-1,140,39,38,-1,38,141,140,-1,71,142,143,-1,144,145,146,-1,147,148,149,-1,147,150,148,-1,151,152,4,-1,151,153,152,-1,154,155,47,-1,155,156,47,-1,157,158,159,-1,157,160,158,-1,161,40,37,-1,37,39,161,-1,162,163,39,-1,39,140,162,-1,82,164,165,-1,83,166,167,-1,83,168,166,-1,169,170,171,-1,172,173,174,-1,175,176,177,-1,152,5,4,-1,178,68,67,-1,179,180,181,-1,179,182,180,-1,183,68,178,-1,178,79,183,-1,184,185,186,-1,185,187,186,-1,188,85,189,-1,190,87,86,-1,190,191,87,-1,192,193,194,-1,195,196,197,-1,198,165,164,-1,199,200,137,-1,200,201,137,-1,202,203,204,-1,203,205,204,-1,133,132,206,-1,132,207,206,-1,158,208,159,-1,208,209,159,-1,210,211,212,-1,213,214,215,-1,216,217,218,-1,218,219,216,-1,220,221,222,-1,223,224,225,-1,226,227,228,-1,226,229,227,-1,230,231,232,-1,231,73,232,-1,233,44,46,-1,154,49,234,-1,154,47,49,-1,89,235,236,-1,46,7,237,-1,46,45,7,-1,238,239,240,-1,241,242,243,-1,244,245,246,-1,242,247,248,-1,249,76,250,-1,251,252,253,-1,253,254,251,-1,255,256,257,-1,255,258,256,-1,4,259,260,-1,4,3,259,-1,261,214,262,-1,261,263,214,-1,83,188,84,-1,264,265,56,-1,266,159,209,-1,266,267,159,-1,268,225,150,-1,268,269,225,-1,270,271,272,-1,271,273,272,-1,253,252,255,-1,255,257,253,-1,274,275,13,-1,13,12,274,-1,276,77,74,-1,277,278,279,-1,277,280,278,-1,281,282,283,-1,281,284,282,-1,285,286,287,-1,285,288,286,-1,289,259,3,-1,3,290,289,-1,137,139,199,-1,139,291,199,-1,292,293,42,-1,293,294,42,-1,295,296,297,-1,296,298,297,-1,299,300,301,-1,299,302,300,-1,303,17,304,-1,303,305,17,-1,134,65,306,-1,134,63,65,-1,307,308,309,-1,308,310,309,-1,311,312,313,-1,314,315,316,-1,314,317,315,-1,318,319,320,-1,318,321,319,-1,322,21,323,-1,322,22,21,-1,324,325,326,-1,324,98,325,-1,98,97,325,-1,327,101,100,-1,328,329,330,-1,328,331,329,-1,332,326,325,-1,332,130,326,-1,333,334,335,-1,334,336,335,-1,2,337,0,-1,338,339,340,-1,114,341,342,-1,343,279,344,-1,345,346,347,-1,348,349,350,-1,348,351,349,-1,352,353,354,-1,354,355,352,-1,356,357,168,-1,357,166,168,-1,358,300,359,-1,300,360,359,-1,295,212,211,-1,295,361,212,-1,266,209,210,-1,210,362,266,-1,186,187,58,-1,58,268,186,-1,363,218,303,-1,363,364,218,-1,365,50,236,-1,365,48,50,-1,366,136,135,-1,367,278,368,-1,197,369,370,-1,369,371,370,-1,372,298,373,-1,372,297,298,-1,13,374,375,-1,13,275,374,-1,344,376,377,-1,377,343,344,-1,95,116,378,-1,116,115,378,-1,379,380,381,-1,382,383,384,-1,384,385,382,-1,386,387,388,-1,387,389,388,-1,390,91,391,-1,272,392,270,-1,320,27,318,-1,320,25,27,-1,393,26,28,-1,393,394,26,-1,350,395,348,-1,350,396,395,-1,397,398,399,-1,397,400,398,-1,399,401,402,-1,399,398,401,-1,403,404,405,-1,403,406,404,-1,307,407,308,-1,307,408,407,-1,402,20,409,-1,402,401,20,-1,410,411,409,-1,412,413,414,-1,412,415,413,-1,416,417,418,-1,416,419,417,-1,420,334,333,-1,421,422,423,-1,424,333,335,-1,424,425,333,-1,426,425,424,-1,424,427,426,-1,428,429,430,-1,430,431,428,-1,432,433,434,-1,432,435,433,-1,436,387,386,-1,437,92,438,-1,437,90,92,-1,439,124,120,-1,120,440,439,-1,441,442,339,-1,441,443,442,-1,105,444,445,-1,105,104,444,-1,104,446,444,-1,104,447,446,-1,447,448,446,-1,360,302,351,-1,360,300,302,-1,394,449,26,-1,394,450,449,-1,242,451,247,-1,242,452,451,-1,453,454,75,-1,455,76,249,-1,455,456,76,-1,207,457,458,-1,41,263,261,-1,261,361,41,-1,352,459,460,-1,352,461,459,-1,462,463,464,-1,464,465,462,-1,464,143,465,-1,59,88,466,-1,164,467,468,-1,468,198,164,-1,469,470,471,-1,469,472,470,-1,220,473,221,-1,220,474,473,-1,5,69,6,-1,475,55,194,-1,475,476,55,-1,477,229,226,-1,226,182,477,-1,478,265,264,-1,479,480,481,-1,479,228,480,-1,357,208,158,-1,357,296,208,-1,482,87,191,-1,191,196,482,-1,189,85,87,-1,87,482,189,-1,483,484,485,-1,484,486,202,-1,284,487,488,-1,61,136,489,-1,459,461,490,-1,491,469,363,-1,492,493,494,-1,492,213,493,-1,495,494,493,-1,495,18,494,-1,175,496,176,-1,496,355,176,-1,461,496,154,-1,496,155,154,-1,497,9,156,-1,497,7,9,-1,244,498,499,-1,499,245,244,-1,131,451,500,-1,500,501,131,-1,502,503,504,-1,502,505,503,-1,96,116,95,-1,506,129,507,-1,507,508,509,-1,506,128,129,-1,509,510,511,-1,512,329,331,-1,331,513,512,-1,379,439,514,-1,514,380,379,-1,515,516,440,-1,515,517,516,-1,92,91,390,-1,432,518,519,-1,519,435,432,-1,337,2,102,-1,520,521,522,-1,523,521,520,-1,520,524,523,-1,426,525,425,-1,426,526,525,-1,527,528,529,-1,527,530,528,-1,531,532,533,-1,531,431,532,-1,534,422,416,-1,422,421,416,-1,535,534,418,-1,534,416,418,-1,417,419,536,-1,334,537,538,-1,334,539,537,-1,409,19,410,-1,409,20,19,-1,535,408,307,-1,535,418,408,-1,315,538,537,-1,315,406,538,-1,406,315,317,-1,317,404,406,-1,399,402,310,-1,402,309,310,-1,540,321,541,-1,540,319,321,-1,542,543,544,-1,544,545,542,-1,546,77,232,-1,547,548,549,-1,547,283,548,-1,122,124,379,-1,124,439,379,-1,550,328,551,-1,328,552,551,-1,342,553,117,-1,117,114,342,-1,125,122,553,-1,527,554,424,-1,554,427,424,-1,113,555,93,-1,555,94,93,-1,109,112,111,-1,109,108,112,-1,556,557,558,-1,556,559,557,-1,382,560,383,-1,382,561,560,-1,381,562,379,-1,562,563,379,-1,505,502,561,-1,502,560,561,-1,79,151,80,-1,79,178,151,-1,211,208,295,-1,208,296,295,-1,201,564,138,-1,565,372,566,-1,565,297,372,-1,278,280,368,-1,280,567,368,-1,481,480,64,-1,64,70,481,-1,568,459,490,-1,568,474,459,-1,188,83,167,-1,167,466,188,-1,158,166,357,-1,158,160,166,-1,298,165,569,-1,298,570,165,-1,222,470,220,-1,360,351,571,-1,572,573,574,-1,575,391,576,-1,575,390,391,-1,331,577,513,-1,99,126,128,-1,578,126,98,-1,98,579,578,-1,527,424,335,-1,335,530,527,-1,580,313,312,-1,312,581,580,-1,332,582,123,-1,582,121,123,-1,340,575,576,-1,576,338,340,-1,102,2,100,-1,583,584,585,-1,583,586,584,-1,324,579,98,-1,114,327,341,-1,114,118,327,-1,389,380,587,-1,380,514,587,-1,588,516,517,-1,517,589,588,-1,389,387,380,-1,316,315,537,-1,537,412,316,-1,321,241,590,-1,321,318,241,-1,591,244,246,-1,591,239,244,-1,405,540,592,-1,405,404,540,-1,312,593,581,-1,594,364,471,-1,595,545,544,-1,595,596,545,-1,305,218,217,-1,305,303,218,-1,15,597,304,-1,304,17,15,-1,299,397,302,-1,297,598,295,-1,598,599,295,-1,600,601,602,-1,601,603,602,-1,42,43,292,-1,43,604,292,-1,81,78,605,-1,219,362,210,-1,259,289,270,-1,606,281,607,-1,35,281,606,-1,606,33,35,-1,608,10,609,-1,608,11,10,-1,272,286,610,-1,272,273,286,-1,222,223,611,-1,222,221,223,-1,612,54,613,-1,82,356,168,-1,254,614,251,-1,254,615,614,-1,41,40,263,-1,40,616,263,-1,259,392,260,-1,259,270,392,-1,258,255,617,-1,618,619,574,-1,250,252,251,-1,250,620,252,-1,498,621,499,-1,243,622,623,-1,248,243,242,-1,248,622,243,-1,590,498,244,-1,573,572,367,-1,572,278,367,-1,624,235,625,-1,49,543,234,-1,543,542,234,-1,367,368,626,-1,489,11,61,-1,73,142,71,-1,627,228,227,-1,224,223,473,-1,223,221,473,-1,213,628,493,-1,213,215,628,-1,16,15,18,-1,18,495,16,-1,230,629,34,-1,34,231,230,-1,630,160,157,-1,191,190,631,-1,85,188,466,-1,466,88,85,-1,149,148,632,-1,632,633,149,-1,81,605,634,-1,634,635,81,-1,170,182,179,-1,170,477,182,-1,311,636,312,-1,311,637,636,-1,291,566,485,-1,74,76,456,-1,633,51,149,-1,633,638,51,-1,147,144,146,-1,147,149,144,-1,171,639,54,-1,83,82,168,-1,356,570,357,-1,640,641,201,-1,161,616,40,-1,642,294,293,-1,293,643,642,-1,548,283,282,-1,173,145,174,-1,246,644,626,-1,246,245,644,-1,237,233,46,-1,237,591,233,-1,228,627,645,-1,645,646,228,-1,67,66,153,-1,647,200,199,-1,648,630,157,-1,54,169,171,-1,282,640,548,-1,282,641,640,-1,201,138,137,-1,306,649,134,-1,228,646,650,-1,130,332,123,-1,651,110,112,-1,652,105,653,-1,652,103,105,-1,326,125,553,-1,326,130,125,-1,99,98,126,-1,636,423,422,-1,390,1,0,-1,338,441,339,-1,89,8,45,-1,654,44,368,-1,570,82,165,-1,570,356,82,-1,88,59,86,-1,86,59,58,-1,81,183,79,-1,81,635,183,-1,77,546,75,-1,479,481,655,-1,655,66,479,-1,635,180,183,-1,635,181,180,-1,656,480,228,-1,70,64,62,-1,656,228,650,-1,476,657,56,-1,56,55,476,-1,145,51,57,-1,145,144,51,-1,149,51,144,-1,657,658,56,-1,56,658,264,-1,47,9,50,-1,47,156,9,-1,627,659,645,-1,276,601,230,-1,43,361,599,-1,43,41,361,-1,295,599,361,-1,138,292,604,-1,604,139,138,-1,598,565,139,-1,139,604,598,-1,297,565,598,-1,21,24,19,-1,21,22,24,-1,31,131,501,-1,501,29,31,-1,660,24,413,-1,451,452,500,-1,212,361,261,-1,18,305,494,-1,18,17,305,-1,492,216,262,-1,492,217,216,-1,495,30,16,-1,495,661,30,-1,12,489,662,-1,12,11,489,-1,663,664,662,-1,662,366,663,-1,279,278,572,-1,45,8,7,-1,0,92,390,-1,250,665,620,-1,250,454,665,-1,453,462,666,-1,453,463,462,-1,667,275,277,-1,667,374,275,-1,664,280,274,-1,280,664,567,-1,668,669,624,-1,668,663,669,-1,669,366,135,-1,669,663,366,-1,375,670,671,-1,672,670,375,-1,261,216,212,-1,261,262,216,-1,217,494,305,-1,217,492,494,-1,29,450,673,-1,29,501,450,-1,398,323,401,-1,323,398,674,-1,675,676,400,-1,676,675,677,-1,500,678,449,-1,500,452,678,-1,679,680,681,-1,679,682,680,-1,23,413,24,-1,23,414,413,-1,230,77,276,-1,232,77,230,-1,564,643,293,-1,564,683,643,-1,602,488,600,-1,602,684,488,-1,629,35,34,-1,35,629,487,-1,293,138,564,-1,138,293,292,-1,294,40,42,-1,40,294,37,-1,603,38,642,-1,603,141,38,-1,659,685,645,-1,659,595,685,-1,686,544,543,-1,687,544,686,-1,53,688,689,-1,53,52,688,-1,478,658,690,-1,478,264,658,-1,691,476,692,-1,657,476,691,-1,174,57,693,-1,174,145,57,-1,64,656,65,-1,64,480,656,-1,634,181,635,-1,634,694,181,-1,69,481,70,-1,655,481,69,-1,44,626,368,-1,233,626,44,-1,44,625,45,-1,625,44,654,-1,585,391,583,-1,391,585,576,-1,340,695,575,-1,578,695,340,-1,575,1,390,-1,695,1,575,-1,107,104,106,-1,107,447,104,-1,446,696,697,-1,696,446,448,-1,698,444,699,-1,698,445,444,-1,653,700,652,-1,700,653,701,-1,103,556,558,-1,103,652,556,-1,503,697,696,-1,503,505,697,-1,382,699,561,-1,698,699,382,-1,502,93,95,-1,502,504,93,-1,702,560,378,-1,702,383,560,-1,559,703,704,-1,703,559,384,-1,557,704,705,-1,704,557,559,-1,706,707,708,-1,555,707,706,-1,709,710,711,-1,709,712,710,-1,713,563,562,-1,563,713,714,-1,715,507,716,-1,715,508,507,-1,717,509,718,-1,717,510,509,-1,719,720,721,-1,720,719,511,-1,306,646,722,-1,646,306,650,-1,630,60,59,-1,648,60,630,-1,723,157,724,-1,723,648,157,-1,5,655,69,-1,5,152,655,-1,722,645,685,-1,645,722,646,-1,246,233,591,-1,246,626,233,-1,725,726,727,-1,725,728,726,-1,641,684,683,-1,282,684,641,-1,164,84,729,-1,164,82,84,-1,689,691,693,-1,690,691,689,-1,146,186,147,-1,146,184,186,-1,51,730,52,-1,638,730,51,-1,731,634,605,-1,634,731,732,-1,726,337,727,-1,726,637,337,-1,170,733,477,-1,169,733,170,-1,734,613,732,-1,734,612,613,-1,369,631,735,-1,631,369,191,-1,193,475,194,-1,475,193,371,-1,736,285,287,-1,737,285,736,-1,648,269,60,-1,269,648,723,-1,166,630,167,-1,630,166,160,-1,281,487,284,-1,35,487,281,-1,729,188,189,-1,729,84,188,-1,198,549,738,-1,198,739,549,-1,373,483,372,-1,373,484,483,-1,486,373,740,-1,373,486,484,-1,661,493,628,-1,493,661,495,-1,455,207,458,-1,206,207,455,-1,741,627,227,-1,741,742,627,-1,743,687,686,-1,744,687,743,-1,649,135,134,-1,649,745,135,-1,464,453,72,-1,464,463,453,-1,377,746,343,-1,465,746,377,-1,747,375,374,-1,672,375,747,-1,748,143,142,-1,748,749,143,-1,274,662,664,-1,662,274,12,-1,626,573,367,-1,573,626,644,-1,745,669,135,-1,745,750,669,-1,243,621,498,-1,623,621,243,-1,751,573,644,-1,574,573,751,-1,619,258,617,-1,619,618,258,-1,621,751,499,-1,752,751,621,-1,4,80,151,-1,4,260,80,-1,456,458,162,-1,456,455,458,-1,732,288,734,-1,731,288,732,-1,753,754,195,-1,467,754,753,-1,607,271,270,-1,607,547,271,-1,250,614,249,-1,251,614,250,-1,755,617,756,-1,755,619,617,-1,757,608,609,-1,757,36,608,-1,36,231,34,-1,36,757,231,-1,165,738,569,-1,165,198,738,-1,606,270,289,-1,270,606,607,-1,392,610,78,-1,610,392,272,-1,611,267,758,-1,724,267,611,-1,193,370,371,-1,193,737,370,-1,195,370,753,-1,195,197,370,-1,169,759,733,-1,265,759,169,-1,598,43,599,-1,598,604,43,-1,14,597,15,-1,14,358,597,-1,748,757,609,-1,142,757,748,-1,649,722,744,-1,306,722,649,-1,542,760,568,-1,542,545,760,-1,758,222,611,-1,758,470,222,-1,350,310,308,-1,350,349,310,-1,581,521,580,-1,581,522,521,-1,761,762,411,-1,593,762,761,-1,763,403,405,-1,764,403,763,-1,765,766,767,-1,768,766,765,-1,497,769,7,-1,770,769,497,-1,590,239,238,-1,590,244,239,-1,412,539,415,-1,412,537,539,-1,676,771,674,-1,393,771,676,-1,772,677,675,-1,673,677,772,-1,661,31,30,-1,31,661,132,-1,457,628,215,-1,457,207,628,-1,411,773,409,-1,411,762,773,-1,427,774,426,-1,427,388,774,-1,775,526,776,-1,777,526,775,-1,429,778,433,-1,429,428,778,-1,521,435,519,-1,521,523,435,-1,313,438,92,-1,313,580,438,-1,637,0,337,-1,637,311,0,-1,587,516,588,-1,587,514,516,-1,589,551,779,-1,589,517,551,-1,552,432,434,-1,432,552,780,-1,781,437,518,-1,437,781,586,-1,586,90,437,-1,586,583,90,-1,100,341,327,-1,100,579,341,-1,716,442,782,-1,716,127,442,-1,720,783,582,-1,720,717,783,-1,339,127,126,-1,339,442,127,-1,721,582,332,-1,720,582,721,-1,553,324,326,-1,342,324,553,-1,695,2,1,-1,100,2,695,-1,119,550,515,-1,577,550,119,-1,784,584,785,-1,784,443,584,-1,443,585,584,-1,443,441,585,-1,19,660,786,-1,19,24,660,-1,524,429,523,-1,524,430,429,-1,593,522,581,-1,761,522,593,-1,335,536,530,-1,536,335,336,-1,582,119,121,-1,119,582,783,-1,767,541,238,-1,767,766,541,-1,395,787,768,-1,396,787,395,-1,360,347,359,-1,360,571,347,-1,472,220,470,-1,460,220,472,-1,176,347,177,-1,176,345,347,-1,740,298,569,-1,373,298,740,-1,788,789,790,-1,788,346,789,-1,631,172,735,-1,172,631,185,-1,460,474,220,-1,474,460,459,-1,45,235,89,-1,45,625,235,-1,61,134,136,-1,61,63,134,-1,758,471,470,-1,758,594,471,-1,565,291,139,-1,565,566,291,-1,203,640,205,-1,738,640,203,-1,641,564,201,-1,641,683,564,-1,260,78,80,-1,78,260,392,-1,10,748,609,-1,10,671,748,-1,226,180,182,-1,226,791,180,-1,143,72,71,-1,143,464,72,-1,704,714,713,-1,704,703,714,-1,558,112,108,-1,558,557,112,-1,503,111,504,-1,503,109,111,-1,703,792,714,-1,702,792,703,-1,793,794,101,-1,706,794,793,-1,381,387,795,-1,381,380,387,-1,712,705,710,-1,712,651,705,-1,792,378,115,-1,792,702,378,-1,101,118,793,-1,101,327,118,-1,706,796,794,-1,706,708,796,-1,707,651,712,-1,707,110,651,-1,577,783,513,-1,783,577,119,-1,727,102,797,-1,337,102,727,-1,744,745,649,-1,743,745,744,-1,798,794,796,-1,797,794,798,-1,798,799,436,-1,796,799,798,-1,397,351,302,-1,349,351,397,-1,317,540,404,-1,317,319,540,-1,407,350,308,-1,407,396,350,-1,682,316,680,-1,682,314,316,-1,412,680,316,-1,680,412,414,-1,403,538,406,-1,800,538,403,-1,417,408,418,-1,417,764,408,-1,334,800,336,-1,334,538,800,-1,411,801,761,-1,801,411,410,-1,410,786,801,-1,410,19,786,-1,415,533,532,-1,533,415,539,-1,528,416,421,-1,528,419,416,-1,660,431,430,-1,532,431,660,-1,531,420,525,-1,531,533,420,-1,423,728,529,-1,726,728,423,-1,525,777,531,-1,526,777,525,-1,524,801,786,-1,524,520,801,-1,637,423,636,-1,637,726,423,-1,518,438,519,-1,518,437,438,-1,779,775,589,-1,779,778,775,-1,588,774,587,-1,588,776,774,-1,727,798,725,-1,797,798,727,-1,330,781,780,-1,330,785,781,-1,517,550,551,-1,517,515,550,-1,514,440,516,-1,440,514,439,-1,329,782,784,-1,329,512,782,-1,802,553,122,-1,117,553,802,-1,799,711,795,-1,799,709,711,-1,445,653,105,-1,445,701,653,-1,765,803,804,-1,770,803,765,-1,177,571,805,-1,177,347,571,-1,501,449,450,-1,501,500,449,-1,769,238,240,-1,769,767,238,-1,806,177,803,-1,177,806,175,-1,32,16,30,-1,16,32,14,-1,7,240,237,-1,7,769,240,-1,50,89,236,-1,50,9,89,-1,155,175,806,-1,496,175,155,-1,461,355,496,-1,461,352,355,-1,790,491,363,-1,790,789,491,-1,247,615,254,-1,615,247,451,-1,621,256,752,-1,621,623,256,-1,616,39,163,-1,161,39,616,-1,363,304,790,-1,304,363,303,-1,568,234,542,-1,568,490,234,-1,686,365,743,-1,686,48,365,-1,136,662,489,-1,662,136,366,-1,749,465,143,-1,670,465,749,-1,672,465,670,-1,747,465,672,-1,807,465,747,-1,807,746,465,-1,488,282,284,-1,488,684,282,-1,739,273,271,-1,273,739,808,-1,737,753,370,-1,753,737,736,-1,605,610,731,-1,78,610,605,-1,185,173,172,-1,185,184,173,-1,187,86,58,-1,190,86,187,-1,268,147,186,-1,150,147,268,-1,473,809,224,-1,809,473,760,-1,596,632,809,-1,810,632,596,-1,742,659,627,-1,810,659,742,-1,229,741,227,-1,229,811,741,-1,52,759,688,-1,52,730,759,-1,179,694,639,-1,181,694,179,-1,759,478,688,-1,759,265,478,-1,54,265,169,-1,56,265,54,-1,811,759,730,-1,811,733,759,-1,55,612,194,-1,55,54,612,-1,639,170,179,-1,639,171,170,-1,741,730,638,-1,730,741,811,-1,810,595,659,-1,596,595,810,-1,809,545,596,-1,760,545,809,-1,742,632,810,-1,742,633,632,-1,224,632,148,-1,224,809,632,-1,223,724,611,-1,223,723,724,-1,364,219,218,-1,364,362,219,-1,735,174,692,-1,735,172,174,-1,692,475,735,-1,476,475,692,-1,731,286,288,-1,286,731,610,-1,197,191,369,-1,197,196,191,-1,484,812,485,-1,484,647,812,-1,204,484,202,-1,484,204,647,-1,33,289,290,-1,33,606,289,-1,743,750,745,-1,743,365,750,-1,472,491,353,-1,491,472,469,-1,206,615,133,-1,206,614,615,-1,376,620,665,-1,376,756,620,-1,258,752,256,-1,258,618,752,-1,257,248,253,-1,248,257,622,-1,790,597,788,-1,790,304,597,-1,346,354,789,-1,354,346,345,-1,788,358,359,-1,788,597,358,-1,806,770,497,-1,806,803,770,-1,678,242,241,-1,678,452,242,-1,14,772,301,-1,772,14,32,-1,804,177,805,-1,803,177,804,-1,318,678,241,-1,27,678,318,-1,675,301,772,-1,301,675,299,-1,805,395,804,-1,805,348,395,-1,509,506,507,-1,511,506,509,-1,511,719,506,-1,784,442,443,-1,782,442,784,-1,552,330,780,-1,552,328,330,-1,785,586,781,-1,586,785,584,-1,725,436,386,-1,798,436,725,-1,587,388,389,-1,587,774,388,-1,776,589,775,-1,589,776,588,-1,778,434,433,-1,434,778,779,-1,428,531,777,-1,428,431,531,-1,554,529,728,-1,554,527,529,-1,525,333,425,-1,525,420,333,-1,312,422,593,-1,312,636,422,-1,421,529,528,-1,423,529,421,-1,530,419,528,-1,530,536,419,-1,533,334,420,-1,533,539,334,-1,413,532,660,-1,415,532,413,-1,800,764,417,-1,800,403,764,-1,23,322,681,-1,322,23,22,-1,309,409,773,-1,409,309,402,-1,407,764,763,-1,407,408,764,-1,771,681,322,-1,771,679,681,-1,405,787,763,-1,405,592,787,-1,25,314,682,-1,314,25,320,-1,349,399,310,-1,399,349,397,-1,299,400,397,-1,299,675,400,-1,795,562,381,-1,562,795,711,-1,393,679,771,-1,679,393,28,-1,238,321,590,-1,321,238,541,-1,110,555,113,-1,707,555,110,-1,796,709,799,-1,708,709,796,-1,710,704,713,-1,704,710,705,-1,795,436,799,-1,436,795,387,-1,101,797,102,-1,794,797,101,-1,563,122,379,-1,802,122,563,-1,556,384,559,-1,556,385,384,-1,665,377,376,-1,377,665,666,-1,343,277,279,-1,277,343,667,-1,467,736,468,-1,753,736,467,-1,273,287,286,-1,287,273,808,-1,569,203,740,-1,569,738,203,-1,754,189,482,-1,189,754,729,-1,789,353,491,-1,789,354,353,-1,608,61,11,-1,608,290,61,-1,357,298,296,-1,357,570,298,-1,654,624,625,-1,654,668,624,-1,234,461,154,-1,461,234,490,-1,167,59,466,-1,59,167,630,-1,148,225,224,-1,150,225,148,-1,724,159,267,-1,724,157,159,-1,214,616,215,-1,214,263,616,-1,215,163,457,-1,215,616,163,-1,359,346,788,-1,359,347,346,-1,345,355,354,-1,176,355,345,-1,460,353,352,-1,460,472,353,-1,804,768,765,-1,395,768,804,-1,805,351,348,-1,351,805,571,-1,766,540,541,-1,766,592,540,-1,619,572,574,-1,619,755,572,-1,498,241,243,-1,590,241,498,-1,417,336,800,-1,417,536,336,-1,430,786,660,-1,524,786,430,-1,515,120,119,-1,120,515,440,-1,330,784,785,-1,330,329,784,-1,550,331,328,-1,331,550,577,-1,578,100,695,-1,578,579,100,-1,324,341,579,-1,342,341,324,-1,97,719,721,-1,506,719,97,-1,717,513,783,-1,718,513,717,-1,513,715,512,-1,718,715,513,-1,512,716,782,-1,512,715,716,-1,578,339,126,-1,339,578,340,-1,518,780,781,-1,518,432,780,-1,779,552,434,-1,551,552,779,-1,311,92,0,-1,311,313,92,-1,519,580,521,-1,580,519,438,-1,433,523,429,-1,523,433,435,-1,777,778,428,-1,777,775,778,-1,776,426,774,-1,526,426,776,-1,388,554,386,-1,427,554,388,-1,534,593,422,-1,593,534,762,-1,132,628,207,-1,132,661,628,-1,673,32,29,-1,772,32,673,-1,677,393,676,-1,394,393,677,-1,322,674,771,-1,322,323,674,-1,314,319,317,-1,320,319,314,-1,365,235,750,-1,236,235,365,-1,767,770,765,-1,770,767,769,-1,768,592,766,-1,787,592,768,-1,761,520,522,-1,761,801,520,-1,763,396,407,-1,396,763,787,-1,307,773,535,-1,307,309,773,-1,762,535,773,-1,762,534,535,-1,474,760,473,-1,474,568,760,-1,546,73,72,-1,73,546,232,-1,358,301,300,-1,301,358,14,-1,74,162,140,-1,456,162,74,-1,290,6,61,-1,290,3,6,-1,195,482,196,-1,754,482,195,-1,734,285,192,-1,734,288,285,-1,266,364,594,-1,362,364,266,-1,201,205,640,-1,201,200,205,-1,601,629,230,-1,601,600,629,-1,76,454,250,-1,76,75,454,-1,756,344,755,-1,756,376,344,-1,756,252,620,-1,617,252,756,-1,252,617,255,-1,572,344,279,-1,572,755,344,-1,644,499,751,-1,245,499,644,-1,281,547,607,-1,283,547,281,-1,547,739,271,-1,547,549,739,-1,60,268,58,-1,60,269,268,-1,266,758,267,-1,594,758,266,-1,140,276,74,-1,140,141,276,-1,256,622,257,-1,256,623,622,-1,618,751,752,-1,618,574,751,-1,253,247,254,-1,253,248,247,-1,237,239,591,-1,237,240,239,-1,155,497,156,-1,155,806,497,-1,668,368,567,-1,668,654,368,-1,290,36,33,-1,608,36,290,-1,671,749,748,-1,749,671,670,-1,746,667,343,-1,807,667,746,-1,666,465,377,-1,462,465,666,-1,72,75,546,-1,72,453,75,-1,744,685,687,-1,722,685,744,-1,65,650,306,-1,65,656,650,-1,479,226,228,-1,791,226,479,-1,363,471,364,-1,471,363,469,-1,214,492,262,-1,214,213,492,-1,219,212,216,-1,210,212,219,-1,210,208,211,-1,209,208,210,-1,249,206,455,-1,249,614,206,-1,133,451,131,-1,615,451,133,-1,202,740,203,-1,740,202,486,-1,200,204,205,-1,204,200,647,-1,372,485,566,-1,372,483,485,-1,485,199,291,-1,485,647,199,-1,647,485,812,-1,548,738,549,-1,738,548,640,-1,729,467,164,-1,754,467,729,-1,468,739,198,-1,468,808,739,-1,225,723,223,-1,225,269,723,-1,287,468,736,-1,287,808,468,-1,192,737,193,-1,192,285,737,-1,612,192,194,-1,612,734,192,-1,371,735,475,-1,735,371,369,-1,185,190,187,-1,185,631,190,-1,613,639,694,-1,54,639,613,-1,477,811,229,-1,477,733,811,-1,67,151,178,-1,67,153,151,-1,742,638,633,-1,741,638,742,-1,689,57,53,-1,689,693,57,-1,690,657,691,-1,658,657,690,-1,162,457,163,-1,162,458,457,-1,728,386,554,-1,725,386,728,-1,655,153,66,-1,153,655,152,-1,184,145,173,-1,145,184,146,-1,603,643,602,-1,603,642,643,-1,325,721,332,-1,325,97,721,-1,511,717,720,-1,717,511,510,-1,718,508,715,-1,718,509,508,-1,507,127,716,-1,127,507,129,-1,99,506,97,-1,99,128,506,-1,123,120,124,-1,120,123,121,-1,714,802,563,-1,714,792,802,-1,792,117,802,-1,117,792,115,-1,711,713,562,-1,711,710,713,-1,708,712,709,-1,707,712,708,-1,94,706,793,-1,94,555,706,-1,651,557,705,-1,651,112,557,-1,384,702,703,-1,702,384,383,-1,560,95,378,-1,95,560,502,-1,504,113,93,-1,113,504,111,-1,700,382,385,-1,700,698,382,-1,505,699,697,-1,699,505,561,-1,696,109,503,-1,696,107,109,-1,108,103,558,-1,106,103,108,-1,652,385,556,-1,385,652,700,-1,701,698,700,-1,698,701,445,-1,444,697,699,-1,697,444,446,-1,696,447,107,-1,696,448,447,-1,96,793,118,-1,94,793,96,-1,441,576,585,-1,576,441,338,-1,583,91,90,-1,91,583,391,-1,757,73,231,-1,142,73,757,-1,479,68,791,-1,66,68,479,-1,791,183,180,-1,183,791,68,-1,694,732,613,-1,732,694,634,-1,693,692,174,-1,691,692,693,-1,688,690,689,-1,688,478,690,-1,543,48,686,-1,49,48,543,-1,687,595,544,-1,685,595,687,-1,601,141,603,-1,141,601,276,-1,38,294,642,-1,38,37,294,-1,600,487,629,-1,600,488,487,-1,683,602,643,-1,683,684,602,-1,414,681,680,-1,681,414,23,-1,28,682,679,-1,28,25,682,-1,27,449,678,-1,449,27,26,-1,400,674,398,-1,674,400,676,-1,21,401,323,-1,21,20,401,-1,673,394,677,-1,673,450,394,-1,375,10,13,-1,375,671,10,-1,624,750,235,-1,624,669,750,-1,567,663,668,-1,567,664,663,-1,277,274,280,-1,277,275,274,-1,807,374,667,-1,807,747,374,-1,454,666,665,-1,454,453,666,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rulna_Coord',point=[(-7.17691,28.88063,1.58038),(-7.20223,28.82013,1.62413),(-7.26886,28.80085,1.58758),(-7.52635,36.82425,-1.53299),(-7.58533,36.94653,-1.68047),(-7.59932,36.91541,-1.72676),(-7.53376,36.80205,-1.59888),(-7.52169,35.39752,-1.29265),(-7.49902,35.69728,-1.44191),(-7.45911,35.74795,-1.56284),(-7.61358,36.62041,-1.39734),(-7.61287,36.63358,-1.43733),(-7.63529,36.54186,-1.45471),(-7.63936,36.54582,-1.40254),(-7.03028,34.9728,-.87925),(-6.93685,35.48965,-1.03407),(-6.95369,35.50402,-1.00521),(-6.85015,35.89551,-1.10943),(-6.8598,35.90515,-1.08005),(-7.13258,29.78818,1.44716),(-7.09781,30.22263,1.17763),(-7.11982,30.23294,1.20452),(-7.17893,30.25297,1.25304),(-7.20827,30.26586,1.28617),(-7.18644,29.81952,1.51082),(-7.42355,32.90489,.19804),(-7.44706,34.03686,-.29393),(-7.47003,34.03886,-.288),(-7.40206,32.9008,.18751),(-7.15735,35.0039,-.79953),(-7.01212,35.54259,-.95089),(-7.10882,35.59054,-.9022),(-7.08653,34.99451,-.82293),(-7.43539,36.76414,-1.26239),(-7.36898,36.79034,-1.10786),(-7.34704,36.80448,-1.12359),(-7.449,36.75909,-1.24885),(-6.87985,36.9974,-.88713),(-6.91772,37.0738,-.87686),(-6.92781,36.94268,-.89291),(-6.80423,36.90494,-.97095),(-6.71823,36.81829,-1.08608),(-6.79601,36.90635,-.98231),(-6.72026,36.8285,-1.09033),(-7.56782,36.1238,-1.38302),(-7.52389,35.87311,-1.38952),(-7.53969,35.86791,-1.34025),(-7.40709,36.00475,-1.76486),(-7.41191,36.23449,-1.83154),(-7.38615,36.21958,-1.85778),(-7.42852,36.02297,-1.73579),(-7.1063,37.19537,-2.13743),(-7.1253,37.36174,-2.01945),(-7.11213,37.3667,-2.01908),(-7.46968,37.53947,-1.62621),(-7.35673,37.59268,-1.63203),(-7.3587,37.59269,-1.64592),(-7.06271,37.39254,-2.02372),(-6.8527,37.13522,-1.92152),(-6.85213,36.91973,-1.81391),(-6.85871,36.91591,-1.8262),(-7.56425,36.67545,-1.4984),(-7.53309,36.78951,-1.6259),(-7.5308,36.77643,-1.65076),(-7.57488,36.87841,-1.7927),(-7.56644,36.8742,-1.79873),(-7.72295,37.15704,-1.86463),(-7.72343,37.20597,-1.80414),(-7.73239,37.28109,-1.76762),(-7.60626,36.89682,-1.76945),(-7.59004,36.88726,-1.78031),(-7.4141,36.63358,-1.1702),(-7.40305,36.60097,-1.13077),(-7.37989,36.67205,-1.12849),(-7.16236,36.87525,-.90649),(-7.3628,36.65463,-.97036),(-7.34998,36.62961,-.95559),(-7.22653,36.84642,-.93127),(-7.52729,37.15728,-1.62328),(-7.67634,37.26423,-1.68035),(-7.60317,37.12911,-1.66393),(-7.61697,37.28131,-1.62365),(-7.05033,36.95092,-1.59517),(-6.95936,36.91666,-1.6999),(-6.98969,36.98206,-1.66354),(-6.89762,37.02605,-1.73899),(-6.83974,37.20947,-1.86217),(-6.85872,37.22327,-1.82023),(-6.86966,36.99685,-1.76515),(-7.47599,35.80601,-1.48905),(-7.11919,28.85739,1.66332),(-7.13148,28.85224,1.65644),(-7.10977,28.9291,1.62876),(-7.41522,28.61376,1.67396),(-7.38904,28.6388,1.6604),(-7.38837,28.60982,1.72475),(-7.36441,28.64851,1.71171),(-7.3539,28.84605,1.80728),(-7.30715,28.79483,1.72228),(-7.30469,28.83417,1.76179),(-7.28844,28.77314,1.62956),(-7.3363,28.71936,1.6109),(-7.29475,28.7845,1.57252),(-7.49724,28.61359,1.73794),(-7.47274,28.59881,1.72514),(-7.47649,28.60686,1.7367),(-7.4882,28.60392,1.7138),(-7.47079,28.59576,1.7045),(-7.49862,28.60838,1.70434),(-7.47092,28.59791,1.69117),(-7.52714,28.63216,1.67098),(-7.4704,28.60229,1.68054),(-7.52184,28.62215,1.68961),(-7.46855,28.61237,1.66424),(-7.34304,28.6729,1.73278),(-7.38429,28.67362,1.80403),(-7.35484,28.65229,1.73165),(-7.38084,28.69399,1.80456),(-7.35277,28.66613,1.70426),(-7.40608,28.93285,2.04433),(-7.48701,28.9087,1.98605),(-7.47365,28.89674,1.96753),(-7.4446,28.76059,1.80881),(-7.49241,28.85819,1.87888),(-7.51315,28.86095,1.87943),(-7.44039,28.76932,1.81316),(-7.24607,28.85004,1.76571),(-7.22514,28.88159,1.80395),(-7.30155,28.88388,1.81171),(-7.29565,28.89031,1.8229),(-7.4273,28.81345,1.81968),(-7.15978,35.60284,-.89865),(-7.09897,35.94899,-.98482),(-7.15179,35.95536,-.92193),(-7.52363,36.74255,-1.71256),(-7.51984,36.54854,-1.64586),(-7.54323,36.58724,-1.58989),(-6.80464,36.89482,-1.06696),(-6.81088,36.91924,-1.01283),(-6.75809,36.85097,-1.10776),(-7.00165,36.92958,-.88938),(-6.97995,37.07153,-.88341),(-7.44492,36.65434,-1.2361),(-7.46294,36.57866,-1.22975),(-7.0912,37.2023,-2.13168),(-7.05078,37.39243,-2.02441),(-6.9881,37.26294,-2.07522),(-6.97515,37.22031,-2.07497),(-7.06635,36.99033,-2.09829),(-7.09608,37.15935,-2.12358),(-6.95791,37.06268,-2.03417),(-7.6699,37.11586,-1.73048),(-7.62237,36.95037,-1.75459),(-7.69797,37.1325,-1.80799),(-7.35916,35.98941,-1.7964),(-7.34553,35.67949,-1.66588),(-7.39882,35.70745,-1.61638),(-6.89917,36.82178,-1.77934),(-6.87816,36.82395,-1.71238),(-6.88473,36.80281,-1.72059),(-6.88493,36.8404,-1.75785),(-6.87513,36.94311,-.91626),(-7.07398,36.71074,-.98988),(-6.99716,36.74723,-1.00189),(-7.06551,36.96449,-1.58328),(-7.05889,36.95379,-1.57687),(-6.90591,36.88048,-1.70695),(-6.91092,36.89757,-1.72306),(-6.94278,36.89952,-1.68512),(-7.46451,37.50708,-1.82021),(-7.54318,37.484,-1.76266),(-7.52319,37.50257,-1.73506),(-6.98871,37.52883,-1.8816),(-7.01604,37.44467,-1.97576),(-7.09108,37.53402,-1.90148),(-7.27263,35.29042,-1.53462),(-7.23609,35.29931,-1.50733),(-7.27663,34.82428,-1.29418),(-7.72163,37.24517,-1.74801),(-7.616,37.45033,-1.69933),(-7.72209,37.36663,-1.70727),(-7.67628,37.40577,-1.62949),(-7.65134,37.40618,-1.75146),(-7.72535,37.34756,-1.69775),(-6.93062,37.30574,-2.01568),(-6.88213,37.34779,-1.94858),(-6.91205,37.26371,-2.01246),(-6.87545,37.30061,-1.94395),(-6.92132,36.99999,-1.71728),(-6.91736,37.03603,-1.7219),(-6.85884,37.3768,-1.84339),(-6.88775,37.41367,-1.80321),(-7.29888,37.49235,-1.41027),(-7.24411,37.52383,-1.42639),(-7.28575,37.555,-1.42366),(-7.03808,37.36311,-1.71633),(-6.94445,37.40925,-1.77476),(-7.01999,37.49444,-1.7268),(-7.08982,36.94664,-1.48723),(-6.83658,36.80959,-1.17104),(-6.91211,36.81863,-1.20734),(-6.96604,36.89218,-1.10208),(-6.90031,36.79315,-1.33154),(-6.98153,36.83892,-1.35003),(-6.89187,36.79068,-1.3142),(-6.96015,36.82398,-1.28889),(-7.19903,36.39655,-1.00329),(-7.09861,36.38217,-1.05161),(-6.84434,36.79681,-1.64449),(-6.85472,36.77387,-1.6467),(-6.74298,36.73004,-1.45089),(-6.72367,36.75157,-1.44047),(-6.66389,36.72394,-1.24057),(-6.76662,36.59911,-1.13583),(-6.75047,36.64864,-1.13665),(-6.89939,36.60832,-1.09032),(-6.67755,36.64415,-1.23377),(-6.69506,36.58087,-1.22515),(-6.73218,36.57568,-1.35365),(-6.7355,36.66812,-1.40358),(-7.09176,36.40225,-1.8497),(-7.06958,36.53781,-1.89743),(-7.06564,36.53922,-1.85961),(-6.97609,36.78576,-1.91902),(-7.07224,36.75366,-2.02592),(-6.95029,36.83966,-1.97426),(-7.68211,37.303,-1.83962),(-7.61613,37.15328,-2.00924),(-7.70556,37.14527,-1.91289),(-7.57789,37.28081,-1.93508),(-7.26253,36.8452,-1.00968),(-7.38544,36.76663,-1.09078),(-7.28854,36.78952,-.99762),(-7.55884,35.90754,-1.2928),(-7.35555,36.21292,-1.86907),(-7.46924,36.13522,-1.61347),(-7.44099,36.10563,-1.67024),(-7.53931,35.50372,-1.2036),(-7.60517,34.48709,-.69629),(-7.57861,34.97084,-.91881),(-7.57402,34.95221,-.95058),(-7.56586,34.55782,-.54915),(-7.49298,35.04625,-.74549),(-7.52004,35.04084,-.76804),(-7.58085,35.01808,-.83789),(-7.55868,35.62811,-1.07811),(-7.57154,35.60827,-1.11003),(-7.3874,35.63287,-.86651),(-7.40783,35.6325,-.87904),(-7.29723,36.5269,-.99033),(-7.4438,36.43724,-.999),(-7.40241,36.35197,-1.01005),(-7.43008,36.29876,-1.02454),(-7.4005,35.9714,-.93668),(-7.35849,35.9784,-.91062),(-7.46193,36.24432,-1.08847),(-7.43502,35.93027,-1.05333),(-7.42085,35.94373,-1.01311),(-7.48011,36.21299,-1.11982),(-7.44304,36.8515,-1.48435),(-7.52284,36.97533,-1.61542),(-6.66559,36.72186,-1.21418),(-6.68338,36.64865,-1.19751),(-6.73548,36.74734,-1.09377),(-7.27464,37.60317,-1.72939),(-7.34936,37.56341,-1.80929),(-6.90241,36.71014,-1.64068),(-6.92393,36.7488,-1.73909),(-6.89189,37.09377,-1.97276),(-6.89232,36.89639,-1.88898),(-7.35173,36.86673,-1.46732),(-7.23531,36.90772,-1.47144),(-7.3923,37.02321,-1.57319),(-7.29069,37.05817,-1.55779),(-7.65501,36.44489,-1.43097),(-7.66469,36.46895,-1.38566),(-7.12209,36.99826,-.90092),(-7.65702,36.38087,-1.34603),(-7.64617,36.26358,-1.30695),(-7.63929,36.31254,-1.2907),(-7.653,36.34977,-1.38647),(-7.28682,36.83256,-1.16246),(-7.05655,36.99334,-1.04788),(-7.17855,36.86679,-1.2045),(-7.18752,36.91953,-1.03531),(-7.30131,37.41776,-1.47065),(-7.34749,37.20959,-1.55852),(-7.26498,37.23594,-1.54837),(-7.40391,37.38319,-1.50483),(-7.4245,36.82273,-1.45092),(-7.51523,36.7651,-1.43395),(-6.78205,36.80298,-1.19418),(-6.80533,36.91916,-.99796),(-6.87408,37.02915,-.94738),(-6.87391,37.00471,-.89411),(-6.73107,36.80518,-1.45307),(-6.8462,36.84566,-1.62795),(-6.75335,36.83604,-1.43522),(-6.867,36.86913,-1.60139),(-7.08669,33.95788,-.49896),(-7.073,34.42471,-.75497),(-7.08242,34.44957,-.71177),(-7.09512,33.93791,-.54571),(-6.79047,36.22096,-1.25352),(-6.85002,35.86387,-1.18164),(-6.77999,36.24356,-1.17454),(-7.53624,36.84167,-1.83104),(-7.11272,30.70706,.65456),(-7.16644,31.73248,.18505),(-7.04592,30.73064,.72124),(-7.05821,31.76859,.24161),(-7.17411,28.9232,1.56344),(-7.17566,29.1434,1.50368),(-7.1096,28.96366,1.61231),(-7.43996,31.98241,.58503),(-7.38574,30.8822,1.00408),(-7.3662,30.88918,1.02287),(-7.47422,31.97106,.56257),(-7.58658,34.03585,-.29495),(-7.56192,32.89612,.19704),(-7.5111,32.90626,.22223),(-7.62049,34.02587,-.31785),(-7.15852,30.84147,.95294),(-7.06157,30.81029,.91596),(-7.31842,28.7785,1.71767),(-7.36655,28.82969,1.79892),(-7.37746,28.79944,1.78772),(-7.32407,28.71231,1.6787),(-7.22215,28.97877,2.06524),(-7.17476,28.90213,1.98238),(-7.14517,28.91318,1.99562),(-7.24351,28.95092,2.04507),(-7.3986,28.85982,1.83947),(-7.5202,29.56271,1.57677),(-7.49362,29.83165,1.44668),(-7.52238,29.50172,1.46417),(-7.52371,29.77005,1.33467),(-7.2577,28.85193,1.53266),(-7.19972,28.76612,1.7216),(-7.22909,28.83914,1.76056),(-7.23165,28.79451,1.68743),(-7.32624,28.71402,1.71126),(-7.33629,28.72282,1.73421),(-7.54018,36.4143,-1.26447),(-7.58474,36.30668,-1.23692),(-7.11477,35.34452,-1.3517),(-7.03692,35.36386,-1.2771),(-7.10884,34.87977,-1.13113),(-7.28373,33.81833,-.77465),(-7.10476,32.78544,-.18168),(-7.23243,32.76573,-.26735),(-7.11997,33.89509,-.6372),(-7.1485,36.05072,-1.76737),(-7.0805,36.09672,-1.63182),(-7.1119,35.74121,-1.51428),(-7.21658,35.68893,-1.65549),(-6.92746,36.88822,-1.67086),(-6.89381,36.86614,-1.69162),(-7.01071,34.94221,-.9392),(-7.04796,34.89545,-1.04806),(-7.0823,34.36902,-.83702),(-6.67452,36.78213,-1.22821),(-6.77334,36.68019,-1.45759),(-6.83773,36.20486,-1.34711),(-6.79532,36.58718,-1.44166),(-7.43786,36.27502,-1.75915),(-7.54923,36.52134,-1.56056),(-7.6149,36.16788,-1.29124),(-7.59782,36.26395,-1.39116),(-6.999,37.59402,-1.73619),(-7.16519,37.5036,-1.58527),(-7.1352,37.61993,-1.52547),(-6.77952,36.82361,-1.38822),(-6.86659,36.82468,-1.47779),(-7.56217,36.49659,-1.31924),(-7.55568,36.53954,-1.32599),(-7.51415,36.36541,-1.13736),(-7.48828,36.41884,-1.19185),(-7.40073,28.62745,1.78551),(-7.51534,28.79132,1.80537),(-7.5407,28.84916,1.76002),(-7.55,28.7873,1.75683),(-7.45507,28.61012,1.77595),(-7.45309,28.62437,1.78799),(-7.49961,28.63955,1.78402),(-7.48215,28.62125,1.77164),(-7.54229,28.93297,1.59358),(-7.56774,28.81957,1.65274),(-7.54284,28.99516,1.69149),(-7.54512,28.88941,1.7398),(-7.19067,28.81925,1.63415),(-7.15934,28.78637,1.68181),(-7.45001,37.00319,-1.5883),(-7.2964,32.90989,.0686),(-7.3239,34.00981,-.37193),(-7.41104,33.82168,-.76197),(-7.35773,32.757,-.28786),(-7.06311,32.82537,-.08215),(-7.05272,31.87312,.38928),(-7.01113,31.83347,.33875),(-7.13016,32.85487,-.0212),(-7.03858,30.79647,.89507),(-7.02034,30.7736,.81529),(-7.4599,30.79658,.80927),(-7.47864,31.92802,.4774),(-7.47354,31.8518,.34062),(-7.41893,30.85601,.94063),(-7.29199,31.74329,.15253),(-7.26937,30.72953,.64241),(-7.05748,30.19486,1.10102),(-7.12064,29.76261,1.38476),(-7.1172,29.72265,1.30585),(-7.31725,30.2803,1.30764),(-7.20985,29.82844,1.52204),(-7.22896,30.2708,1.29696),(-7.267,29.8405,1.51541),(-7.30142,29.63849,1.17155),(-7.40836,30.09312,1.02587),(-7.2889,30.05047,.96887),(-7.43361,29.688,1.20414),(-7.49899,29.57956,1.61206),(-7.30281,29.33823,1.32337),(-7.23207,29.35267,1.37141),(-7.31305,29.08914,1.44185),(-7.51691,29.22537,1.59365),(-7.54313,29.29355,1.72762),(-7.58687,29.15056,1.77272),(-7.53643,29.07213,1.65798),(-7.29349,29.25691,2.01417),(-7.16621,29.24744,1.98419),(-7.18355,29.35657,1.82317),(-7.28904,29.38159,1.85456),(-7.06114,29.04126,1.99588),(-7.1551,29.1742,2.035),(-7.18072,29.09606,2.08297),(-7.06467,29.13348,1.94874),(-7.5511,28.79287,1.60946),(-7.04974,28.90217,1.74661),(-7.04939,28.99714,1.70703),(-7.55241,28.88852,1.89848),(-7.49927,28.94129,2.01156),(-7.19148,28.76358,1.73195),(-7.20859,28.87111,1.80181),(-7.14419,28.77922,1.80161),(-7.44955,28.59487,1.74495),(-7.45843,28.59871,1.74999),(-7.45045,28.59443,1.73555),(-7.46403,28.59473,1.72049),(-7.45164,28.5943,1.72581),(-7.40816,34.53884,-.54848),(-7.27935,34.50986,-.59913),(-7.25873,35.6267,-.89187),(-7.37614,35.03409,-.74243),(-7.44728,36.51465,-1.10691),(-7.45604,36.49546,-1.01979),(-7.19475,36.54534,-.98678),(-7.18767,36.68549,-.9724),(-7.06128,36.58319,-1.02784),(-7.09639,36.57138,-1.01759),(-7.1584,36.19331,-1.86904),(-7.12109,36.21193,-1.81088),(-7.20718,36.0289,-1.83048),(-7.47003,36.52052,-1.20287),(-7.46368,36.53537,-1.18971),(-7.45625,36.56053,-1.20146),(-7.47638,36.50567,-1.21604),(-6.87273,36.97509,-1.75522),(-7.11951,37.12103,-1.62607),(-7.15663,37.09452,-1.5738),(-6.94039,36.23722,-1.49235),(-7.0152,36.52586,-1.74425),(-6.94624,36.5594,-1.60215),(-7.05681,36.24709,-1.67304),(-7.08491,36.53519,-1.95134),(-7.13021,36.35905,-1.90348),(-7.15452,37.64727,-1.53414),(-7.25392,37.62813,-1.70288),(-7.55987,37.39857,-1.85901),(-7.21201,37.59161,-1.79616),(-7.7184,37.15323,-1.89233),(-7.59412,36.93846,-1.85661),(-7.61941,36.93473,-1.85143),(-6.91827,37.19087,-1.77834),(-6.8577,36.78992,-1.3396),(-6.87607,36.79014,-1.3585),(-6.85466,36.78272,-1.31256),(-6.89298,36.7945,-1.3481),(-7.22891,36.89315,-1.03104),(-7.1153,37.02252,-.93317),(-7.55968,36.59856,-1.52727),(-7.2088,36.19334,-1.88851),(-6.95008,36.15693,-1.46892),(-6.70497,36.58951,-1.19189),(-6.84664,36.28372,-1.11609),(-6.78488,36.25762,-1.13635),(-6.89526,35.91277,-1.05587),(-7.25616,35.67181,-1.69637),(-7.42443,35.319,-1.45106),(-7.54541,35.03028,-.80102),(-7.47803,35.61957,-1.06235),(-7.35157,35.03104,-.74516),(-7.22798,35.0132,-.77626),(-7.40633,28.59989,1.72853),(-7.43311,28.59741,1.70557),(-7.42601,28.60256,1.68958),(-7.42989,28.59682,1.7325),(-7.32762,28.87952,1.82324),(-7.29179,28.89548,1.83883),(-7.29722,28.9039,1.85339),(-7.31343,28.90876,1.8597),(-7.32882,28.90263,1.85331),(-7.33613,28.89729,1.84462),(-7.21756,28.93247,1.93582),(-7.29267,28.95739,1.96632),(-7.58213,28.92579,1.89405),(-7.4272,28.96643,2.06996),(-7.523,28.99978,2.02798),(-7.4331,29.02326,2.07693),(-7.02242,28.96758,1.89657),(-7.01051,29.07254,1.84324),(-7.10645,29.27336,1.72177),(-7.02538,29.14377,1.80186),(-7.10949,29.24905,1.68483),(-7.07433,29.199,1.89469),(-7.12428,29.31435,1.78176),(-7.49294,29.34439,1.79858),(-7.52681,29.22435,1.93263),(-7.4939,29.1734,1.51588),(-7.44044,29.40879,1.34376),(-7.44067,29.13258,1.47103),(-7.46909,29.44136,1.38594),(-7.42673,29.38314,1.83454),(-7.2748,29.58869,1.67164),(-7.41616,29.59785,1.67014),(-7.19434,29.66413,1.20849),(-7.15692,30.08316,.98426),(-7.46037,29.71244,1.24302),(-7.38587,30.27969,1.2997),(-7.44391,30.25221,1.2408),(-7.40269,29.84512,1.50121),(-7.57579,32.85229,.10934),(-7.61513,33.97458,-.43311),(-7.37636,36.38554,-1.93864),(-7.39567,36.39287,-1.92882),(-7.40312,36.55784,-1.99099),(-7.38314,36.54903,-1.99222),(-7.30399,36.74864,-.98859),(-7.21124,36.86616,-1.33149),(-7.10139,36.88578,-1.22922),(-7.1327,36.90167,-1.3515),(-7.32618,28.98438,2.09792),(-7.30059,29.03321,2.11338),(-7.19844,29.03203,2.09365),(-7.38354,28.74484,1.79027),(-7.52878,29.01032,1.56942),(-7.46341,28.63655,1.63466),(-7.49653,28.62236,1.75609),(-7.53258,28.63686,1.73487),(-7.51152,28.62233,1.73878),(-7.52225,28.64202,1.76519),(-7.41448,28.61225,1.77651),(-7.42679,28.59939,1.75998),(-7.54594,28.7213,1.77422),(-7.50842,28.72466,1.80989),(-6.87966,37.03044,-.95791),(-6.72108,36.81282,-1.25444),(-6.76511,36.78951,-1.26002),(-7.57808,36.32689,-1.45316),(-7.20885,36.3572,-1.94767),(-7.01968,36.91863,-1.53503),(-6.91243,36.88769,-1.65834),(-7.12926,34.36016,-.8889),(-7.63936,36.26497,-1.2871),(-7.59202,36.16094,-1.25616),(-7.55092,36.17807,-1.23),(-7.22532,28.79299,1.66756),(-7.17751,28.76064,1.70537),(-7.3234,28.95271,2.07082),(-7.23912,28.79464,1.68293),(-7.29632,28.7769,1.67258),(-7.05496,29.03816,1.68369),(-7.13773,29.19202,1.58993),(-7.40026,28.90522,1.89506),(-7.14928,28.78607,1.69054),(-7.11515,28.77483,1.79628),(-7.16864,28.75841,1.71515),(-7.08445,28.81623,1.79057),(-7.60294,28.97768,1.86803),(-7.53915,29.06494,2.02081),(-7.43505,29.0859,2.06609),(-7.59985,34.54553,-.58254),(-7.55139,35.57652,-1.14866),(-7.53831,32.8329,-.0813),(-7.17474,29.39369,1.42738),(-6.92734,36.61724,-1.6185),(-7.44551,36.77271,-2.04028),(-7.4005,36.75614,-2.06423),(-6.92234,35.44192,-1.07398),(-6.70946,36.81244,-1.25003),(-6.68172,36.79353,-1.23143),(-7.11831,37.02034,-.92032),(-7.12459,37.00903,-.90883),(-7.00724,37.09279,-.91731),(-6.98225,37.08303,-.88943),(-6.74384,36.84424,-1.10434),(-7.58565,37.29033,-1.59373),(-7.38181,36.80004,-1.28902),(-7.32723,36.83182,-1.30643),(-7.5468,36.73342,-1.37544),(-7.55459,36.70044,-1.34702),(-7.44137,37.18359,-1.59158),(-6.97861,36.70572,-1.83397),(-7.43184,37.4977,-1.43664),(-7.52282,37.4589,-1.49044),(-7.26893,36.3877,-.99952),(-7.24053,35.96411,-.92348),(-6.87222,36.76163,-1.04411),(-7.48579,36.25939,-1.11126),(-7.52513,36.18165,-1.19554),(-7.55444,36.21201,-1.21795),(-7.47755,36.3673,-1.05188),(-7.45397,35.62439,-1.02788),(-7.42087,35.62519,-.95825),(-7.43012,35.62442,-.97738),(-7.52886,36.2649,-1.52934),(-7.5326,36.20164,-1.49889),(-7.5917,35.91818,-1.23),(-7.60827,37.09119,-2.02311),(-6.97567,36.3325,-1.10205),(-7.23382,36.88856,-1.01924),(-6.88488,36.84726,-1.77007),(-6.87,37.42398,-1.83932),(-7.21708,36.92473,-2.12558),(-7.217,37.09839,-2.17219),(-7.62439,37.38841,-1.52946),(-7.67553,37.36163,-1.61056),(-7.22891,29.11786,1.45248),(-7.24583,28.89762,1.51438),(-7.23277,37.1579,-2.15912),(-7.5703,37.4891,-1.65395),(-7.04246,36.88198,-1.255),(-7.0109,36.98865,-1.05671),(-6.91566,37.08517,-.88178),(-6.92513,37.10218,-.90897),(-7.57011,35.91978,-1.19572),(-7.51451,36.90774,-2.02688),(-7.55431,36.92771,-1.94028),(-6.86974,36.78696,-1.29379),(-6.89104,36.84646,-1.78906),(-7.50732,36.68154,-1.79112),(-7.57103,36.93375,-1.90034),(-7.53278,28.63543,1.67428),(-7.48822,28.61489,1.74846),(-7.47221,28.60521,1.74223),(-7.57294,36.24167,-1.43196),(-7.63329,36.9416,-1.83501),(-7.58484,36.93657,-1.86667),(-7.26056,37.62213,-1.71273),(-7.26697,37.61099,-1.72067),(-7.49776,36.90298,-2.04495),(-7.20757,29.56965,1.64977),(-6.99546,35.93079,-1.02977),(-7.56308,36.5264,-1.52632),(-7.54601,36.38331,-1.53449),(-7.56953,36.40329,-1.49822),(-7.48405,36.42196,-1.07482),(-7.46778,36.46674,-1.14938),(-7.55117,36.45544,-1.29186),(-7.55657,36.30489,-1.48603),(-7.52318,36.36135,-1.57575),(-7.49526,36.5564,-1.2597),(-7.54919,36.5825,-1.33275),(-7.49965,36.54294,-1.2604),(-7.18637,34.49001,-.63394),(-7.07781,31.8877,.4098),(-7.16322,33.97925,-.44238),(-7.15866,32.86556,-.00154),(-7.19461,33.98638,-.42473),(-7.43215,34.54283,-.54436),(-7.30989,31.972,.55988),(-7.24375,30.87789,1.01819),(-7.22201,30.8723,1.00958),(-7.33205,31.97653,.56905),(-6.93013,37.10172,-.91987),(-7.00644,37.09302,-.92966),(-7.46959,36.77578,-2.00911),(-7.42043,36.41179,-1.90173),(-7.42984,36.56848,-1.9627),(-7.15594,37.5112,-1.89393),(-7.14316,37.5168,-1.89317),(-7.20072,37.59921,-1.79106),(-7.16338,37.62037,-1.78799),(-7.15244,37.62676,-1.78103),(-7.10641,37.53718,-1.89635),(-7.63046,37.43071,-1.54408),(-7.23681,28.79393,1.65976),(-7.44601,28.59492,1.71514),(-7.44362,28.59518,1.73461),(-7.4596,28.60373,1.76349),(-7.44182,28.59605,1.75341),(-7.47796,28.61336,1.76103),(-7.46761,28.60352,1.74876),(-7.44869,28.64235,1.7989),(-7.5029,28.65777,1.79544),(-7.53323,28.65883,1.77031),(-7.54602,28.6513,1.73116),(-7.4613,28.65234,1.6191),(-7.52217,28.64722,1.64895),(-7.52226,28.6645,1.63486),(-7.54676,28.67978,1.64965),(-7.55694,28.6841,1.72155),(-7.56124,28.70546,1.71526),(-7.54258,28.66039,1.65946),(-7.54273,28.69952,1.77566),(-7.50641,28.70266,1.8077),(-7.23119,28.93395,1.92135),(-7.21028,28.90151,1.8653),(-7.35283,28.92904,1.92104),(-7.29362,28.95264,1.94565),(-7.33554,28.88604,1.83155),(-7.38099,28.90846,1.88758),(-7.37868,28.86513,1.83724),(-7.49956,36.80433,-1.91995),(-6.91303,36.84359,-1.85682),(-6.92161,36.78536,-1.79571),(-7.4651,28.88935,1.53856),(-7.33981,28.90933,1.48151),(-7.35087,28.8436,1.50355),(-7.45135,28.95344,1.51807),(-6.99826,37.01619,-1.65835),(-7.27872,37.3246,-2.04101),(-7.4885,37.34656,-1.54458),(-7.52205,37.41664,-1.48354),(-7.45639,37.42168,-1.92094),(-7.42314,37.46537,-1.42761),(-7.0116,37.623,-1.76096),(-7.20635,37.26239,-1.56963),(-7.24238,37.4365,-1.49224),(-7.06262,36.89957,-1.37352),(-7.1486,36.94618,-1.46764),(-6.94677,36.84532,-1.42851),(-7.42773,37.13676,-2.11842),(-7.42553,37.0756,-2.13091),(-7.45394,36.46235,-1.82694),(-7.46921,36.61222,-1.87869),(-7.48879,36.50166,-1.73395),(-7.49247,36.50426,-1.23854),(-7.49928,36.52977,-1.25552),(-7.50071,36.64164,-1.29705),(-7.48023,36.57473,-1.24864),(-7.47353,36.30966,-1.67911),(-7.49436,35.94141,-1.15266),(-7.47058,35.94353,-1.1203),(-7.15454,37.29163,-1.62388),(-7.02025,37.15548,-1.70118),(-7.58864,36.26243,-1.22755),(-7.50878,36.31487,-1.11887),(-7.4561,36.73128,-1.23082),(-6.98135,36.64194,-1.74524),(-7.31607,37.45832,-1.92529),(-7.21232,36.5358,-2.00963),(-7.14756,29.4282,1.50297),(-7.14097,29.69022,1.25293),(-7.35991,31.76507,.18807),(-7.36252,30.74053,.68427),(-7.4777,34.35666,-.95615),(-7.57982,33.91939,-.55493),(-7.57535,34.42989,-.80734),(-7.47652,33.84611,-.70425),(-7.54961,34.89691,-1.05228),(-7.45868,34.83896,-1.20437),(-7.20348,31.92992,.47971),(-7.16183,34.48474,-.64316),(-7.08679,30.12942,1.0291),(-7.60006,29.06631,1.81582),(-7.43154,29.17658,2.03399),(-7.53721,29.15239,1.97377),(-7.42976,29.24728,1.98631),(-7.29675,29.18485,2.0687),(-7.30332,29.10484,2.1052),(-7.09239,28.97478,2.0166),(-7.05469,28.89421,1.91205),(-7.19164,28.89423,1.8702),(-7.36591,28.9306,1.93812),(-7.13667,28.84431,1.90069),(-7.09668,28.84412,1.90344),(-7.15736,29.5166,1.62048),(-7.43168,32.77521,-.23203),(-6.96842,35.3882,-1.1948),(-7.00182,35.79506,-1.38515),(-6.8947,35.83912,-1.28422),(-7.72638,37.29564,-1.78649),(-7.43771,28.68722,1.81516),(-7.3788,28.65496,1.64859),(-7.43541,28.69266,1.58592),(-7.56564,28.75704,1.68371),(-7.50568,28.69553,1.60571),(-7.40781,28.74349,1.54711),(-7.48098,28.7568,1.57369),(-7.54965,28.72857,1.62874),(-7.49688,30.17873,1.12736),(-7.13896,29.47207,1.57491),(-7.43693,28.70905,1.81697),(-7.38489,34.81916,-1.27063),(-7.40085,34.32121,-1.01376),(-7.2869,34.30056,-1.02621),(-7.36343,35.29045,-1.51227),(-7.49812,36.51451,-1.24886),(-7.21797,37.08132,-1.54744),(-7.21323,36.72062,-2.07478),(-7.41756,36.88807,-2.09157),(-7.43198,37.28963,-2.0092),(-6.8622,36.78484,-1.30317)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesRightRadiusUlna.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesRightRadiusUlna.py load and self-test diagnostics complete.")
