####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesRightHumerus.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesRightHumerus.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Right Humerus',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesRightHumerus.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesRightHumerus.x3d'),
    Transform(DEF='RightHumerusParts',scale=(0.029,0.029,0.029),
      children=[
      Group(DEF='RightHumerus',
        #  rhumerus 
        children=[
        Shape(DEF='rhumerus',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rhumerus_Geo',coordIndex=[0,1,2,-1,3,4,1,-1,2,5,6,-1,7,8,9,-1,9,10,7,-1,4,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,18,26,-1,25,27,18,-1,18,28,26,-1,28,29,26,-1,30,31,24,-1,30,32,31,-1,33,34,16,-1,35,36,37,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,43,45,-1,47,38,48,-1,49,50,51,-1,40,52,41,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,60,62,61,-1,63,64,57,-1,65,66,63,-1,65,67,66,-1,68,69,70,-1,71,72,73,-1,72,74,73,-1,75,74,76,-1,74,77,76,-1,78,79,80,-1,79,81,80,-1,67,46,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,97,96,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,118,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,108,110,135,-1,136,137,138,-1,139,140,141,-1,142,143,144,-1,142,145,143,-1,146,147,148,-1,111,149,150,-1,137,151,152,-1,153,154,155,-1,156,157,158,-1,159,157,156,-1,159,160,157,-1,161,162,163,-1,164,163,165,-1,100,166,167,-1,168,169,170,-1,164,168,170,-1,171,166,172,-1,173,174,126,-1,175,176,177,-1,177,178,175,-1,179,175,180,-1,180,181,179,-1,182,183,184,-1,184,185,182,-1,186,187,188,-1,187,189,188,-1,190,191,192,-1,191,193,192,-1,194,195,196,-1,194,191,195,-1,197,175,179,-1,197,176,175,-1,198,199,200,-1,86,201,87,-1,202,203,204,-1,205,206,207,-1,208,209,210,-1,122,211,212,-1,213,214,120,-1,120,122,213,-1,215,216,217,-1,218,219,220,-1,9,221,222,-1,223,224,225,-1,226,227,228,-1,229,228,230,-1,1,0,3,-1,231,232,233,-1,234,235,236,-1,237,232,238,-1,236,239,240,-1,241,235,242,-1,243,244,245,-1,246,247,248,-1,248,207,246,-1,249,250,251,-1,252,35,43,-1,253,254,255,-1,253,256,254,-1,257,253,258,-1,259,260,258,-1,261,262,258,-1,263,264,258,-1,265,266,258,-1,267,256,253,-1,257,260,268,-1,268,269,257,-1,262,261,270,-1,270,271,262,-1,264,263,272,-1,272,273,264,-1,274,275,266,-1,276,277,278,-1,279,280,281,-1,281,282,279,-1,283,284,285,-1,286,287,288,-1,289,290,291,-1,292,293,294,-1,293,292,279,-1,287,286,295,-1,289,296,297,-1,298,299,300,-1,301,302,303,-1,301,304,302,-1,305,306,219,-1,305,307,306,-1,300,308,309,-1,310,311,312,-1,247,246,313,-1,77,314,315,-1,74,316,317,-1,318,319,320,-1,321,322,83,-1,83,323,321,-1,324,209,208,-1,324,325,209,-1,326,327,328,-1,329,330,331,-1,328,332,326,-1,328,333,332,-1,328,334,335,-1,328,327,334,-1,336,337,338,-1,184,339,340,-1,184,341,339,-1,341,342,343,-1,344,103,345,-1,346,143,145,-1,339,347,340,-1,336,343,337,-1,103,343,342,-1,348,349,350,-1,351,352,353,-1,142,354,145,-1,355,233,356,-1,357,358,359,-1,357,360,358,-1,361,362,363,-1,361,198,362,-1,111,364,365,-1,111,366,364,-1,367,368,329,-1,369,331,370,-1,369,371,331,-1,369,372,373,-1,369,374,372,-1,375,376,377,-1,376,378,379,-1,380,381,382,-1,382,350,380,-1,383,384,385,-1,386,387,388,-1,327,389,390,-1,327,326,389,-1,391,142,350,-1,392,393,394,-1,112,395,113,-1,396,397,398,-1,399,400,401,-1,400,402,401,-1,403,404,405,-1,406,338,407,-1,407,408,406,-1,409,154,410,-1,409,410,411,-1,412,413,414,-1,413,415,414,-1,342,104,103,-1,338,337,407,-1,405,388,387,-1,416,417,418,-1,419,420,421,-1,162,100,163,-1,422,423,424,-1,170,163,164,-1,425,426,427,-1,428,429,430,-1,419,161,170,-1,419,170,420,-1,428,430,431,-1,432,97,98,-1,113,433,366,-1,113,434,433,-1,435,436,437,-1,392,438,439,-1,440,441,442,-1,443,435,444,-1,445,446,447,-1,447,448,445,-1,410,154,449,-1,450,451,452,-1,450,453,451,-1,162,101,100,-1,454,455,456,-1,457,458,459,-1,457,460,458,-1,461,462,463,-1,461,464,462,-1,465,466,467,-1,467,468,465,-1,469,186,188,-1,469,470,186,-1,471,472,454,-1,463,115,461,-1,473,474,475,-1,476,477,478,-1,70,479,480,-1,481,482,483,-1,484,485,486,-1,487,488,485,-1,489,490,491,-1,491,490,492,-1,493,494,495,-1,494,496,495,-1,497,494,498,-1,497,496,494,-1,499,500,501,-1,487,485,484,-1,489,502,503,-1,504,505,492,-1,506,502,507,-1,506,508,502,-1,509,510,511,-1,511,512,509,-1,72,513,514,-1,515,516,517,-1,515,517,490,-1,517,518,519,-1,520,521,522,-1,520,523,521,-1,524,525,514,-1,526,479,69,-1,526,525,524,-1,526,513,527,-1,518,73,75,-1,518,528,73,-1,61,82,59,-1,529,530,531,-1,532,533,534,-1,534,535,532,-1,536,537,538,-1,539,540,541,-1,542,543,544,-1,52,51,545,-1,545,546,52,-1,41,547,548,-1,549,92,545,-1,550,551,552,-1,553,554,555,-1,556,557,558,-1,556,6,559,-1,560,555,554,-1,561,562,563,-1,564,565,566,-1,567,568,569,-1,570,571,93,-1,572,573,49,-1,574,573,572,-1,573,575,566,-1,522,68,483,-1,576,577,578,-1,579,578,580,-1,581,582,583,-1,582,584,583,-1,585,586,587,-1,587,588,585,-1,589,590,580,-1,591,592,593,-1,576,578,594,-1,595,596,597,-1,598,599,600,-1,599,601,602,-1,599,598,601,-1,474,603,475,-1,604,605,606,-1,607,608,609,-1,610,514,525,-1,521,610,611,-1,521,612,610,-1,613,604,614,-1,615,616,617,-1,615,278,616,-1,618,619,620,-1,621,622,623,-1,621,624,622,-1,625,626,627,-1,627,628,625,-1,629,630,631,-1,630,632,631,-1,633,634,635,-1,636,637,638,-1,636,639,637,-1,640,641,642,-1,643,644,645,-1,646,647,648,-1,646,649,647,-1,650,651,646,-1,652,653,654,-1,652,655,653,-1,656,657,658,-1,656,659,657,-1,660,661,662,-1,660,663,661,-1,664,659,665,-1,664,657,659,-1,666,661,667,-1,667,668,666,-1,669,670,671,-1,672,673,674,-1,520,522,675,-1,675,674,520,-1,123,482,124,-1,676,677,678,-1,500,679,484,-1,680,681,682,-1,683,684,685,-1,629,686,630,-1,687,632,688,-1,688,689,687,-1,669,690,691,-1,596,692,693,-1,694,695,696,-1,694,697,695,-1,638,635,634,-1,634,636,638,-1,698,699,700,-1,701,702,703,-1,701,704,702,-1,701,705,704,-1,706,607,707,-1,700,708,709,-1,9,222,710,-1,711,537,712,-1,711,538,537,-1,15,713,23,-1,23,714,15,-1,715,712,537,-1,537,716,715,-1,591,717,718,-1,719,552,551,-1,575,720,564,-1,721,722,723,-1,724,721,508,-1,724,722,721,-1,60,53,725,-1,53,726,725,-1,89,727,728,-1,729,730,731,-1,732,733,585,-1,543,734,735,-1,735,736,543,-1,737,738,739,-1,739,740,737,-1,741,742,743,-1,744,742,745,-1,742,33,745,-1,746,747,748,-1,746,749,747,-1,742,744,530,-1,744,531,530,-1,750,13,751,-1,750,531,13,-1,746,752,753,-1,753,749,746,-1,754,755,756,-1,754,534,755,-1,757,758,533,-1,533,529,757,-1,17,759,562,-1,16,760,761,-1,762,500,763,-1,762,764,500,-1,765,766,767,-1,766,768,767,-1,769,770,771,-1,772,773,774,-1,708,700,752,-1,775,776,777,-1,778,779,780,-1,781,782,783,-1,784,785,5,-1,784,786,785,-1,787,788,789,-1,790,791,792,-1,736,793,544,-1,544,543,736,-1,794,795,732,-1,794,796,795,-1,609,698,607,-1,608,601,797,-1,798,799,800,-1,6,801,802,-1,803,804,763,-1,804,768,763,-1,805,806,807,-1,806,776,807,-1,777,806,808,-1,806,809,808,-1,810,811,765,-1,811,766,765,-1,812,649,813,-1,812,647,649,-1,488,477,495,-1,814,815,816,-1,814,817,815,-1,487,818,125,-1,819,816,808,-1,820,767,821,-1,767,822,821,-1,643,683,682,-1,682,823,643,-1,824,825,826,-1,825,827,826,-1,173,828,158,-1,110,109,150,-1,108,135,829,-1,150,109,111,-1,197,112,196,-1,830,435,443,-1,830,436,435,-1,421,472,419,-1,831,378,376,-1,403,832,833,-1,833,404,403,-1,834,425,835,-1,184,183,341,-1,425,388,836,-1,425,386,388,-1,378,837,838,-1,838,833,378,-1,839,840,130,-1,129,839,130,-1,126,184,340,-1,841,842,130,-1,843,844,842,-1,845,160,846,-1,160,159,846,-1,154,847,155,-1,848,849,850,-1,453,851,451,-1,852,853,422,-1,461,854,855,-1,853,856,857,-1,858,859,860,-1,853,861,862,-1,862,863,864,-1,862,865,863,-1,853,864,866,-1,853,867,868,-1,869,870,871,-1,870,872,871,-1,873,853,874,-1,870,875,876,-1,876,877,870,-1,467,878,875,-1,875,468,467,-1,879,853,880,-1,144,881,882,-1,882,883,144,-1,324,884,885,-1,324,208,884,-1,886,887,888,-1,886,889,887,-1,138,890,891,-1,892,893,894,-1,892,390,893,-1,210,886,208,-1,210,895,886,-1,368,889,329,-1,362,896,360,-1,362,897,896,-1,332,898,899,-1,332,900,898,-1,324,901,325,-1,902,329,903,-1,902,330,329,-1,198,897,362,-1,904,905,132,-1,904,906,905,-1,322,907,908,-1,909,906,904,-1,909,910,906,-1,911,912,913,-1,911,84,912,-1,908,914,83,-1,915,323,213,-1,916,911,917,-1,916,918,911,-1,919,83,85,-1,119,118,920,-1,921,922,923,-1,922,924,923,-1,319,85,925,-1,926,922,298,-1,319,925,320,-1,927,928,929,-1,930,931,932,-1,930,933,931,-1,215,934,216,-1,215,935,934,-1,299,936,937,-1,938,298,300,-1,926,939,940,-1,939,941,940,-1,305,942,307,-1,943,944,945,-1,944,946,318,-1,944,943,946,-1,947,313,246,-1,948,949,249,-1,950,252,951,-1,950,952,252,-1,953,43,46,-1,954,315,314,-1,955,480,479,-1,74,514,316,-1,316,956,957,-1,958,959,527,-1,960,618,961,-1,960,962,618,-1,954,963,964,-1,823,682,965,-1,633,966,967,-1,968,310,969,-1,229,245,226,-1,558,557,550,-1,65,519,76,-1,574,572,36,-1,35,970,36,-1,39,43,37,-1,48,548,47,-1,48,971,40,-1,490,519,56,-1,972,553,973,-1,973,974,972,-1,975,976,0,-1,977,549,566,-1,8,575,978,-1,7,6,556,-1,785,979,5,-1,295,980,981,-1,784,4,12,-1,26,20,25,-1,20,19,982,-1,20,983,25,-1,984,4,3,-1,32,985,986,-1,986,987,32,-1,716,22,988,-1,989,990,991,-1,225,992,223,-1,225,993,992,-1,295,994,980,-1,295,993,994,-1,595,617,995,-1,996,596,595,-1,996,692,596,-1,631,632,687,-1,997,998,999,-1,1000,820,821,-1,821,1001,1000,-1,773,772,1002,-1,1002,1003,773,-1,1004,1005,774,-1,706,1006,607,-1,742,532,743,-1,742,530,532,-1,1007,1008,1009,-1,1009,1010,1007,-1,1011,1012,1013,-1,1014,1015,308,-1,597,615,617,-1,578,577,580,-1,1016,279,1017,-1,1018,287,981,-1,287,295,981,-1,1019,1020,1021,-1,284,1022,285,-1,593,1023,1024,-1,1025,284,283,-1,1025,291,1026,-1,1025,283,291,-1,1027,1028,585,-1,1024,580,601,-1,293,279,1016,-1,592,591,1029,-1,1024,607,1030,-1,716,284,715,-1,716,988,284,-1,1031,538,711,-1,1031,1032,538,-1,294,297,287,-1,590,1033,580,-1,578,615,597,-1,277,276,1034,-1,276,1035,1034,-1,277,1036,278,-1,596,1037,597,-1,1038,309,1039,-1,1040,1041,1042,-1,1040,1043,1041,-1,797,609,608,-1,752,700,753,-1,771,770,824,-1,770,1044,824,-1,669,668,690,-1,687,656,658,-1,1045,595,995,-1,1045,996,595,-1,1046,1036,277,-1,277,1047,1046,-1,1048,980,994,-1,1048,251,980,-1,227,245,244,-1,989,224,223,-1,3,1049,984,-1,11,4,984,-1,984,1049,986,-1,983,20,982,-1,11,19,21,-1,2,975,0,-1,759,563,562,-1,759,1050,563,-1,802,1051,6,-1,6,7,10,-1,558,8,556,-1,221,9,978,-1,1052,803,500,-1,803,763,500,-1,1053,1054,1055,-1,1053,1056,1054,-1,63,57,65,-1,48,42,548,-1,48,38,971,-1,78,548,79,-1,37,43,35,-1,36,970,1057,-1,1057,574,36,-1,573,549,50,-1,1058,745,1059,-1,1058,14,745,-1,1060,1061,1062,-1,574,245,229,-1,312,1063,310,-1,968,969,1064,-1,694,647,812,-1,694,1065,647,-1,1066,1067,635,-1,486,1068,500,-1,515,490,723,-1,317,316,957,-1,1069,955,479,-1,1070,528,958,-1,74,72,514,-1,479,70,69,-1,46,315,953,-1,46,77,315,-1,1071,1072,1073,-1,1071,1074,1072,-1,1075,1076,220,-1,1077,1078,949,-1,1079,947,1080,-1,1079,313,947,-1,946,933,930,-1,930,318,946,-1,944,318,320,-1,320,305,944,-1,320,942,305,-1,298,936,299,-1,932,931,935,-1,931,934,935,-1,945,944,305,-1,303,928,1081,-1,303,929,928,-1,1082,319,318,-1,318,930,1082,-1,320,925,942,-1,922,920,936,-1,1081,928,118,-1,118,86,1081,-1,121,215,1083,-1,215,1084,1083,-1,319,1082,919,-1,919,85,319,-1,1083,86,88,-1,919,213,323,-1,1085,132,352,-1,1085,904,132,-1,1086,1087,1088,-1,1086,1089,1087,-1,361,331,330,-1,361,370,331,-1,329,371,367,-1,329,331,371,-1,327,892,334,-1,327,390,892,-1,360,146,358,-1,360,896,146,-1,883,1090,1091,-1,1091,1092,883,-1,883,1092,144,-1,853,879,422,-1,878,467,459,-1,459,1093,878,-1,880,1094,879,-1,880,1095,1094,-1,853,873,880,-1,870,869,875,-1,869,468,875,-1,853,412,874,-1,342,341,104,-1,413,853,868,-1,867,853,866,-1,1096,1097,1098,-1,1097,1099,1098,-1,853,862,864,-1,865,861,1100,-1,865,862,861,-1,861,853,860,-1,463,116,115,-1,1101,1102,1103,-1,1103,848,1101,-1,1104,411,410,-1,156,158,828,-1,1105,1106,841,-1,1106,842,841,-1,1107,1108,1109,-1,1108,399,1109,-1,1110,400,1111,-1,1110,402,400,-1,828,126,159,-1,127,126,340,-1,839,129,426,-1,425,836,426,-1,339,1112,347,-1,142,391,1113,-1,1114,189,107,-1,189,187,107,-1,1114,1115,345,-1,428,431,1116,-1,1117,454,456,-1,437,179,1118,-1,437,395,197,-1,111,1119,149,-1,346,107,106,-1,597,1037,594,-1,753,700,699,-1,1066,635,638,-1,1120,1121,1122,-1,1120,1123,1121,-1,775,815,1124,-1,775,777,815,-1,1125,1126,1127,-1,1024,608,607,-1,1023,593,592,-1,488,495,496,-1,580,1024,1023,-1,806,777,776,-1,811,762,766,-1,1051,557,559,-1,1024,601,608,-1,801,6,1128,-1,1129,1056,1053,-1,1129,1130,1056,-1,965,1131,823,-1,965,1132,1131,-1,5,4,784,-1,826,771,824,-1,559,6,1051,-1,827,1133,1134,-1,767,820,765,-1,766,762,768,-1,762,763,768,-1,1135,1136,1137,-1,1135,1138,1136,-1,17,16,761,-1,17,1139,759,-1,17,761,1139,-1,1135,1140,1141,-1,1141,1138,1135,-1,64,1142,57,-1,748,1143,746,-1,748,1144,1143,-1,14,531,744,-1,14,13,531,-1,1044,774,1005,-1,1044,770,774,-1,1145,1146,1147,-1,1145,1148,1146,-1,1149,1150,1151,-1,1150,1152,1151,-1,14,744,745,-1,585,733,1153,-1,1154,1155,90,-1,730,1156,1157,-1,60,1158,62,-1,60,725,1158,-1,721,723,503,-1,1159,1160,1161,-1,504,1162,1163,-1,1164,1165,726,-1,726,1166,1164,-1,89,1154,90,-1,575,8,720,-1,8,558,720,-1,1167,552,719,-1,562,18,17,-1,562,28,18,-1,714,22,716,-1,714,23,22,-1,711,712,1168,-1,1168,1169,711,-1,707,607,698,-1,1170,28,561,-1,28,562,561,-1,700,707,698,-1,1171,639,1172,-1,1171,637,639,-1,1173,635,813,-1,599,602,1174,-1,1174,1175,599,-1,696,1064,969,-1,696,695,1064,-1,632,1176,688,-1,1177,1178,693,-1,1179,1180,1176,-1,625,1181,683,-1,683,685,625,-1,1182,1183,630,-1,630,686,1182,-1,643,684,683,-1,633,967,1184,-1,1185,1063,1186,-1,500,1187,679,-1,311,310,968,-1,1188,1189,124,-1,522,483,675,-1,1190,125,124,-1,1191,663,660,-1,1192,662,661,-1,652,1193,655,-1,1185,1194,1063,-1,1063,1195,310,-1,636,680,639,-1,1196,637,1197,-1,1198,968,1064,-1,1199,1200,1201,-1,633,681,634,-1,813,635,1067,-1,1202,1203,606,-1,1204,1205,1206,-1,1204,1207,1205,-1,626,685,691,-1,626,625,685,-1,631,687,658,-1,618,620,1208,-1,961,1209,1210,-1,606,1211,604,-1,206,1212,1046,-1,206,1213,1212,-1,1036,616,278,-1,514,610,612,-1,658,657,614,-1,1214,1203,1215,-1,1216,1217,629,-1,1216,1218,1217,-1,1219,1215,1220,-1,1219,1218,1215,-1,604,1213,605,-1,595,597,617,-1,1221,629,1217,-1,500,499,1052,-1,601,580,602,-1,598,797,601,-1,597,594,578,-1,593,717,591,-1,1030,593,1024,-1,582,581,1222,-1,1222,1223,582,-1,297,294,293,-1,1033,579,580,-1,576,1174,577,-1,541,54,53,-1,516,723,1224,-1,516,515,723,-1,517,516,518,-1,564,566,575,-1,573,566,549,-1,1225,79,548,-1,93,92,569,-1,568,93,569,-1,568,570,93,-1,565,569,977,-1,565,567,569,-1,977,566,565,-1,1226,561,1227,-1,561,563,1227,-1,551,554,1154,-1,719,89,728,-1,556,559,557,-1,560,554,551,-1,728,1167,719,-1,1225,548,547,-1,549,545,51,-1,51,50,549,-1,1228,91,90,-1,1228,1229,91,-1,1230,972,974,-1,1231,1232,54,-1,540,54,541,-1,540,1231,54,-1,79,541,81,-1,79,539,541,-1,532,529,533,-1,532,530,529,-1,56,519,65,-1,224,227,244,-1,526,524,513,-1,526,69,525,-1,527,479,526,-1,76,518,75,-1,76,519,518,-1,519,490,517,-1,524,514,513,-1,527,1070,958,-1,1233,507,1234,-1,1234,1235,1233,-1,505,491,492,-1,489,507,502,-1,489,491,507,-1,489,503,723,-1,475,499,501,-1,501,498,475,-1,1236,506,1233,-1,1233,1237,1236,-1,1233,506,507,-1,1068,501,500,-1,490,56,58,-1,57,56,65,-1,490,489,723,-1,484,486,500,-1,853,852,856,-1,181,1238,471,-1,853,857,860,-1,858,1239,1240,-1,858,1241,1239,-1,179,437,197,-1,467,457,459,-1,467,466,457,-1,1242,1243,1244,-1,1242,192,1243,-1,1245,171,1246,-1,450,428,453,-1,429,428,1247,-1,428,1248,1247,-1,96,171,1245,-1,455,454,472,-1,154,409,1249,-1,409,1250,1249,-1,438,392,1251,-1,1252,441,440,-1,366,111,113,-1,428,450,1248,-1,395,437,1253,-1,437,436,1253,-1,1117,1118,454,-1,95,97,1254,-1,440,1255,1256,-1,1257,1258,438,-1,1257,1259,1258,-1,1260,441,1252,-1,1261,169,1262,-1,1262,1263,1261,-1,854,1264,855,-1,472,471,419,-1,427,835,425,-1,127,426,129,-1,127,427,426,-1,449,1105,1265,-1,1265,410,449,-1,888,1101,1266,-1,163,170,161,-1,168,1262,169,-1,407,337,1267,-1,413,412,853,-1,1103,849,848,-1,407,1267,408,-1,1268,1269,1270,-1,1268,387,1269,-1,397,1271,398,-1,1116,1272,398,-1,1272,396,398,-1,859,861,860,-1,859,1100,861,-1,392,394,1273,-1,430,1274,431,-1,1274,1275,431,-1,390,1276,893,-1,390,389,1276,-1,1277,1278,1279,-1,832,403,1268,-1,1280,388,405,-1,381,1281,382,-1,142,1092,348,-1,833,379,378,-1,368,1282,1283,-1,368,367,1282,-1,1119,111,365,-1,357,374,363,-1,940,1284,924,-1,940,1285,1284,-1,1077,1286,1287,-1,142,144,1092,-1,142,344,354,-1,198,352,351,-1,351,897,198,-1,142,348,350,-1,376,379,377,-1,338,406,1269,-1,406,1270,1269,-1,347,1112,835,-1,1112,834,835,-1,340,347,835,-1,344,1267,1288,-1,344,1113,1267,-1,336,341,343,-1,336,339,341,-1,344,142,1113,-1,184,126,174,-1,338,1289,336,-1,118,1290,86,-1,1290,201,86,-1,363,370,361,-1,83,322,908,-1,1291,1292,321,-1,83,919,323,-1,298,922,936,-1,1293,956,316,-1,1294,1207,247,-1,1294,1205,1207,-1,312,311,1295,-1,635,1173,633,-1,1296,651,966,-1,937,313,299,-1,217,304,301,-1,217,1297,304,-1,1022,284,988,-1,299,313,1079,-1,1222,1016,1223,-1,1016,1017,1223,-1,288,297,296,-1,288,287,297,-1,286,988,295,-1,1298,980,1013,-1,280,1013,1012,-1,981,980,1298,-1,1022,988,286,-1,294,287,1018,-1,1011,1299,1012,-1,1300,1017,279,-1,282,1300,279,-1,270,261,264,-1,264,273,270,-1,271,1301,262,-1,260,259,1302,-1,1302,268,260,-1,267,257,269,-1,267,253,257,-1,255,265,258,-1,266,263,258,-1,264,261,258,-1,262,259,258,-1,260,257,258,-1,253,255,258,-1,1303,233,232,-1,232,1286,1303,-1,1014,1080,277,-1,234,236,240,-1,231,233,355,-1,235,234,242,-1,232,231,238,-1,226,245,227,-1,230,573,229,-1,990,989,223,-1,228,229,226,-1,673,679,1304,-1,960,961,1305,-1,229,573,574,-1,1203,248,1306,-1,1203,1202,248,-1,1307,1292,1088,-1,213,1308,915,-1,886,895,903,-1,313,1294,247,-1,361,1309,1310,-1,118,117,1290,-1,1311,101,162,-1,162,161,1311,-1,191,1312,195,-1,191,190,1312,-1,191,194,193,-1,194,109,193,-1,1313,182,465,-1,182,185,465,-1,466,1314,457,-1,466,1315,1314,-1,457,1316,460,-1,457,1314,1316,-1,1316,99,1317,-1,1316,1318,99,-1,1317,101,1319,-1,1317,99,101,-1,107,346,1115,-1,828,173,126,-1,1320,158,1321,-1,165,100,167,-1,95,1322,171,-1,167,166,1322,-1,165,163,100,-1,171,1322,166,-1,155,1321,153,-1,828,159,156,-1,842,1106,843,-1,157,1321,158,-1,158,1318,173,-1,141,883,882,-1,110,150,149,-1,149,1323,110,-1,1090,883,1324,-1,1325,881,1326,-1,1327,891,1328,-1,1329,1323,1330,-1,105,829,106,-1,352,1331,353,-1,482,1188,124,-1,202,118,928,-1,854,461,115,-1,112,197,395,-1,194,111,109,-1,105,108,829,-1,107,1115,1114,-1,183,104,341,-1,454,181,471,-1,96,95,171,-1,1332,322,321,-1,1332,907,322,-1,727,89,91,-1,1155,1154,554,-1,85,918,925,-1,81,59,82,-1,82,80,81,-1,76,77,65,-1,73,74,75,-1,513,72,71,-1,611,69,68,-1,67,82,61,-1,61,1333,67,-1,67,1333,66,-1,66,64,63,-1,53,60,59,-1,40,42,48,-1,51,52,40,-1,40,49,51,-1,573,50,49,-1,44,43,39,-1,42,41,548,-1,36,572,37,-1,16,18,27,-1,25,983,1334,-1,716,537,714,-1,27,33,16,-1,984,19,11,-1,10,9,975,-1,556,8,7,-1,1,4,2,-1,2,4,5,-1,978,9,8,-1,30,1058,1335,-1,1058,30,713,-1,1334,985,1335,-1,1334,983,985,-1,988,1336,992,-1,22,1336,988,-1,64,1333,1337,-1,1333,64,66,-1,482,675,483,-1,482,123,675,-1,1329,151,1338,-1,1329,1330,151,-1,136,891,1327,-1,136,138,891,-1,1339,134,133,-1,1339,1340,134,-1,141,1341,139,-1,1341,141,882,-1,1326,829,1325,-1,829,1326,106,-1,136,1341,1338,-1,136,139,1341,-1,148,890,152,-1,148,147,890,-1,1329,829,135,-1,1325,829,1329,-1,843,1342,845,-1,843,1106,1342,-1,153,157,160,-1,1321,157,153,-1,167,164,165,-1,164,167,1322,-1,100,1320,166,-1,100,158,1320,-1,1320,155,847,-1,1320,1321,155,-1,1343,462,464,-1,1343,180,462,-1,1344,464,1345,-1,1344,1343,464,-1,1345,1346,1344,-1,1347,1346,1345,-1,1319,1347,1348,-1,1319,1346,1347,-1,1317,1348,1349,-1,1317,1319,1348,-1,1349,1316,1317,-1,460,1316,1349,-1,1314,174,173,-1,1315,174,1314,-1,465,1315,466,-1,1315,465,185,-1,183,1350,104,-1,1350,183,182,-1,104,1351,102,-1,1351,104,1350,-1,189,102,1351,-1,189,1114,102,-1,1352,186,1353,-1,1352,187,186,-1,1354,1353,1243,-1,1354,1352,1353,-1,193,1243,192,-1,193,1354,1243,-1,176,196,195,-1,196,176,197,-1,199,1355,200,-1,1355,199,1356,-1,1357,1310,1309,-1,1357,1358,1310,-1,1205,204,203,-1,1205,1294,204,-1,1292,1086,1088,-1,1086,1292,1291,-1,1087,903,895,-1,902,903,1087,-1,211,1089,212,-1,211,1359,1089,-1,1086,212,1089,-1,1086,1308,212,-1,1306,1360,1203,-1,1360,1306,1361,-1,1207,1361,1306,-1,1207,1204,1361,-1,952,35,252,-1,952,970,35,-1,1362,1297,1363,-1,1362,1364,1297,-1,1365,1366,1367,-1,1365,1368,1366,-1,1369,1370,1371,-1,1369,1372,1370,-1,1365,1373,964,-1,1365,1367,1373,-1,0,1374,3,-1,976,1374,0,-1,710,1375,1376,-1,222,1375,710,-1,1377,233,1303,-1,233,1377,356,-1,1286,237,1287,-1,1286,232,237,-1,954,1072,315,-1,1072,954,1073,-1,1287,306,1378,-1,1075,306,1287,-1,1362,954,964,-1,1073,954,1362,-1,962,1379,1380,-1,962,960,1379,-1,277,947,1047,-1,947,277,1080,-1,1034,1014,277,-1,1014,1034,1015,-1,1038,1381,1011,-1,1039,1381,1038,-1,1048,1286,948,-1,1048,1303,1286,-1,238,234,240,-1,231,234,238,-1,231,242,234,-1,355,242,231,-1,1057,1076,243,-1,1076,1057,1382,-1,1033,269,579,-1,1033,267,269,-1,282,273,1300,-1,282,270,273,-1,259,1301,1302,-1,259,262,1301,-1,1383,255,254,-1,1383,265,255,-1,1035,1381,1034,-1,1035,1384,1381,-1,1384,1385,1386,-1,1384,1035,1385,-1,578,1387,615,-1,1387,578,1388,-1,288,1022,286,-1,1022,288,285,-1,296,291,283,-1,296,289,291,-1,981,1389,1018,-1,981,1298,1389,-1,1389,1013,280,-1,1298,1013,1389,-1,1016,290,293,-1,290,1016,1222,-1,272,1223,1017,-1,275,1223,272,-1,309,1015,1039,-1,309,308,1015,-1,1390,939,938,-1,949,939,1390,-1,950,945,218,-1,945,950,943,-1,1391,946,951,-1,946,1391,933,-1,934,1074,1071,-1,931,1074,934,-1,927,1392,1206,-1,929,1392,927,-1,216,1071,1363,-1,934,1071,216,-1,1378,307,1393,-1,1378,306,307,-1,204,313,937,-1,1294,313,204,-1,1173,966,633,-1,1296,966,1173,-1,1394,1395,1396,-1,1394,1210,1395,-1,311,1397,1295,-1,1398,1397,311,-1,1186,312,1295,-1,312,1186,1063,-1,1399,702,704,-1,1399,1400,702,-1,1401,1402,1403,-1,1401,1404,1402,-1,1405,1406,1407,-1,1406,1405,1408,-1,963,1293,1409,-1,963,956,1293,-1,248,205,207,-1,205,248,1202,-1,1292,1332,321,-1,1307,1332,1292,-1,914,333,912,-1,333,914,1410,-1,103,337,343,-1,103,1267,337,-1,383,1281,381,-1,383,385,1281,-1,338,1411,1289,-1,1269,1411,338,-1,1281,1270,406,-1,1281,385,1270,-1,833,377,379,-1,832,377,833,-1,351,896,897,-1,896,351,1412,-1,1326,144,143,-1,1326,881,144,-1,1285,941,1393,-1,941,1285,940,-1,916,924,1284,-1,924,916,923,-1,917,906,910,-1,917,1413,906,-1,1278,335,334,-1,905,335,1278,-1,1356,1310,1358,-1,1356,199,1310,-1,896,147,146,-1,147,896,1412,-1,365,152,1119,-1,148,152,365,-1,1414,358,1415,-1,359,358,1414,-1,1283,452,451,-1,452,1283,1282,-1,899,1416,1417,-1,899,898,1416,-1,381,375,383,-1,381,380,375,-1,1268,405,387,-1,1268,403,405,-1,384,832,1268,-1,377,832,384,-1,1324,1279,1090,-1,1324,1277,1279,-1,831,1418,1419,-1,376,1418,831,-1,1090,1419,1091,-1,1090,894,1419,-1,1420,430,429,-1,1420,1274,430,-1,1255,1248,1421,-1,1247,1248,1255,-1,1273,1251,392,-1,1256,1251,1273,-1,434,1422,1423,-1,1422,434,1253,-1,1312,1424,1425,-1,1312,190,1424,-1,1426,1427,1428,-1,1427,1426,1429,-1,1100,1430,1431,-1,1430,1100,859,-1,1275,1116,431,-1,1275,1272,1116,-1,397,849,1271,-1,397,411,849,-1,850,1432,1108,-1,850,1104,1432,-1,1433,1434,1280,-1,1435,1434,1433,-1,837,1436,838,-1,837,1437,1436,-1,1438,1280,1434,-1,1280,1438,388,-1,836,839,426,-1,836,840,839,-1,1439,1440,1441,-1,1439,1442,1440,-1,871,1443,1444,-1,872,1443,871,-1,445,1263,1260,-1,445,448,1263,-1,1261,421,420,-1,1261,1445,421,-1,1446,1447,1448,-1,1446,1449,1447,-1,1450,416,418,-1,416,1450,458,-1,158,99,1318,-1,100,99,158,-1,848,1266,1101,-1,1107,1266,848,-1,1265,1104,410,-1,1265,1432,1104,-1,1106,449,1342,-1,1106,1105,449,-1,131,846,128,-1,846,131,844,-1,340,427,127,-1,340,835,427,-1,1451,1274,1420,-1,1451,432,1274,-1,1345,1264,1347,-1,1345,855,1264,-1,441,1263,1262,-1,1260,1263,441,-1,1452,1258,1259,-1,1452,373,1258,-1,1251,1257,438,-1,1421,1257,1251,-1,454,179,181,-1,454,1118,179,-1,1421,450,1257,-1,1248,450,1421,-1,433,1423,1453,-1,433,434,1423,-1,452,1257,450,-1,452,1259,1257,-1,1252,1256,1273,-1,1252,440,1256,-1,96,1454,98,-1,1245,1454,96,-1,1246,1250,1455,-1,1249,1250,1246,-1,1110,841,130,-1,1110,1111,841,-1,372,357,359,-1,374,357,372,-1,1414,439,1456,-1,439,1414,1453,-1,1457,443,446,-1,830,443,1457,-1,1456,359,1414,-1,359,1456,372,-1,441,1420,442,-1,441,1451,1420,-1,418,1264,854,-1,418,417,1264,-1,851,1102,451,-1,1102,851,1103,-1,1455,397,396,-1,1455,1250,397,-1,1454,396,1272,-1,1454,1455,396,-1,722,1458,723,-1,722,1459,1458,-1,190,1242,1424,-1,190,192,1242,-1,1243,1460,1244,-1,1243,1353,1460,-1,469,1461,1444,-1,469,188,1461,-1,461,1345,464,-1,461,855,1345,-1,116,1462,114,-1,1462,116,1463,-1,1240,1464,1465,-1,1240,1239,1464,-1,860,1241,858,-1,860,857,1241,-1,1466,1467,1468,-1,1469,1467,1466,-1,1470,852,1471,-1,856,852,1470,-1,1069,1224,1472,-1,959,1224,1069,-1,1160,1188,1161,-1,1160,1189,1188,-1,482,1473,1188,-1,482,481,1473,-1,1237,1474,1236,-1,1237,511,1474,-1,1475,510,1476,-1,510,1475,1477,-1,1068,498,501,-1,498,1068,497,-1,1163,505,504,-1,1234,505,1163,-1,1478,1479,1480,-1,1478,1235,1479,-1,1481,509,1042,-1,1482,509,1481,-1,473,1483,474,-1,1484,1483,473,-1,494,1484,473,-1,1484,494,493,-1,1237,1235,1478,-1,1237,1233,1235,-1,1482,493,1476,-1,1484,493,1482,-1,1070,513,71,-1,527,513,1070,-1,957,963,954,-1,957,956,963,-1,751,1485,750,-1,1032,1485,751,-1,1486,758,757,-1,1486,1487,758,-1,1488,756,755,-1,1488,1489,756,-1,1490,1491,1492,-1,1491,1490,1493,-1,1494,1495,1496,-1,1494,1497,1495,-1,1498,1499,1500,-1,1501,1499,1498,-1,1502,1503,1504,-1,1502,1505,1503,-1,1506,1507,1508,-1,1509,1507,1506,-1,1497,1510,1495,-1,1497,1511,1510,-1,1512,1513,1514,-1,1512,1515,1513,-1,1516,1517,1518,-1,1517,1516,1519,-1,1520,1521,1522,-1,1523,1521,1520,-1,1524,1525,1526,-1,1524,1527,1525,-1,1528,1529,1530,-1,1529,1528,1531,-1,1527,754,1525,-1,1532,754,1527,-1,1533,54,1232,-1,1533,55,54,-1,1534,1166,1535,-1,1534,1164,1166,-1,1536,1537,1538,-1,1536,1539,1537,-1,1540,1541,1542,-1,1540,1543,1541,-1,793,1053,544,-1,1129,1053,793,-1,727,1229,1544,-1,727,91,1229,-1,1545,90,1155,-1,1545,1228,90,-1,1062,93,571,-1,1062,94,93,-1,1225,1546,1547,-1,1225,547,1546,-1,92,1548,1549,-1,94,1548,92,-1,1550,1546,1551,-1,1546,1550,1547,-1,1154,719,551,-1,719,1154,89,-1,973,1552,1553,-1,1554,1552,973,-1,1555,1556,1557,-1,1555,1558,1556,-1,1226,1559,1560,-1,1226,1227,1559,-1,1561,1548,1061,-1,1561,1562,1548,-1,1563,1564,1565,-1,1564,1563,1566,-1,540,1563,1231,-1,540,1550,1563,-1,1562,1549,1548,-1,1562,1567,1549,-1,549,569,92,-1,977,569,549,-1,516,528,518,-1,528,516,958,-1,955,1472,1568,-1,955,1069,1472,-1,1224,958,516,-1,958,1224,959,-1,1567,546,1549,-1,1567,1569,546,-1,1568,1458,1161,-1,1568,1472,1458,-1,1551,1569,1567,-1,1569,1551,1546,-1,290,581,1570,-1,1222,581,290,-1,584,586,583,-1,1571,586,584,-1,1572,590,587,-1,1033,590,1572,-1,686,1221,1573,-1,686,629,1221,-1,1203,1220,1215,-1,1220,1203,1360,-1,1218,1574,1217,-1,1574,1218,1219,-1,1214,1218,1216,-1,1214,1215,1218,-1,1211,614,604,-1,1575,614,1211,-1,613,657,664,-1,613,614,657,-1,1371,619,1366,-1,1576,619,1371,-1,1208,1577,1578,-1,1208,620,1577,-1,1210,1579,1395,-1,1210,1209,1579,-1,1220,1580,1219,-1,1580,1220,1581,-1,1045,1212,1213,-1,995,1212,1045,-1,1046,616,1036,-1,1046,1212,616,-1,205,606,605,-1,1202,606,205,-1,1214,606,1203,-1,1214,1211,606,-1,1394,1582,1305,-1,1394,1581,1582,-1,1208,961,618,-1,1208,1209,961,-1,1583,1365,1409,-1,1583,1368,1365,-1,1584,1585,1586,-1,1585,1584,1587,-1,1179,1183,1588,-1,1179,1176,1183,-1,927,202,928,-1,927,203,202,-1,1207,248,247,-1,1207,1306,248,-1,1183,632,630,-1,1176,632,1183,-1,682,633,965,-1,682,681,633,-1,1200,697,1201,-1,1589,697,1200,-1,1198,695,1590,-1,1198,1064,695,-1,1221,1574,1591,-1,1221,1217,1574,-1,1592,1593,1573,-1,1594,1593,1592,-1,1595,1596,1597,-1,1595,1598,1596,-1,1197,1599,1196,-1,1197,1600,1599,-1,1197,1171,1601,-1,1197,637,1171,-1,1595,1602,1603,-1,1595,1600,1602,-1,1604,1593,1598,-1,1182,1593,1604,-1,669,1605,670,-1,684,1605,669,-1,1194,1195,1063,-1,1194,1065,1195,-1,967,651,653,-1,967,966,651,-1,655,1132,1184,-1,1193,1132,655,-1,644,1606,1607,-1,644,1131,1606,-1,648,1185,1608,-1,648,1194,1185,-1,652,1606,1193,-1,1609,1606,652,-1,671,1610,999,-1,671,670,1610,-1,998,661,666,-1,1192,661,998,-1,1611,1191,660,-1,1611,1612,1191,-1,1613,1614,1615,-1,1613,1616,1614,-1,1617,1618,1619,-1,1618,1617,1620,-1,1407,1617,1405,-1,1407,1616,1617,-1,1404,1612,1614,-1,1401,1612,1404,-1,663,1400,1399,-1,663,1191,1400,-1,1579,1621,1622,-1,1579,1578,1621,-1,1623,1186,1624,-1,1186,1623,1185,-1,1397,1625,1295,-1,1397,1622,1625,-1,1626,1627,1628,-1,1626,1629,1627,-1,1189,1190,124,-1,1190,1189,478,-1,123,818,675,-1,818,123,125,-1,311,1630,1398,-1,311,968,1630,-1,1627,1622,1621,-1,1627,1625,1622,-1,764,1187,500,-1,764,1631,1187,-1,1632,1624,1629,-1,1623,1624,1632,-1,1184,965,633,-1,1184,1132,965,-1,1633,652,654,-1,1633,1634,652,-1,1635,1636,1637,-1,1636,1635,1638,-1,1133,1000,1134,-1,1000,1133,1639,-1,642,1605,645,-1,642,641,1605,-1,997,1192,998,-1,1640,1192,997,-1,1587,1602,1585,-1,1587,1603,1602,-1,623,1171,621,-1,623,1601,1171,-1,628,1181,625,-1,628,1172,1181,-1,1604,1183,1182,-1,1604,1588,1183,-1,1641,1179,1584,-1,1641,1180,1179,-1,1642,1586,622,-1,1642,1643,1586,-1,627,703,624,-1,627,701,703,-1,1644,811,810,-1,1644,1645,811,-1,1646,1637,825,-1,1646,1635,1637,-1,1647,824,1044,-1,1647,1648,824,-1,747,1649,1005,-1,747,1650,1649,-1,1651,753,1652,-1,753,1651,749,-1,1653,698,799,-1,698,1653,699,-1,664,692,996,-1,665,692,664,-1,1177,600,1178,-1,1654,600,1177,-1,1655,1656,800,-1,1656,1655,1657,-1,1658,798,1659,-1,1658,1660,798,-1,1661,1662,1663,-1,1640,1662,1661,-1,1664,997,1665,-1,1664,1666,997,-1,640,1667,1668,-1,1669,1667,640,-1,1609,1634,1670,-1,652,1634,1609,-1,650,1671,1672,-1,1608,1671,650,-1,693,665,1177,-1,693,692,665,-1,596,1174,1037,-1,596,1175,1174,-1,689,656,687,-1,689,1619,656,-1,1198,1594,1592,-1,1590,1594,1198,-1,1195,969,310,-1,1195,696,969,-1,1408,1176,1180,-1,1408,688,1176,-1,599,1178,600,-1,1178,599,1175,-1,580,1174,602,-1,580,577,1174,-1,1653,1663,1652,-1,1653,1660,1663,-1,706,700,709,-1,706,707,700,-1,29,1170,12,-1,29,28,1170,-1,1374,1673,1674,-1,1374,1376,1673,-1,1675,1676,1677,-1,1676,1675,1006,-1,1678,718,717,-1,1678,1679,718,-1,1680,1681,1682,-1,1680,1683,1681,-1,1684,1685,1686,-1,1687,1685,1684,-1,1688,1168,1689,-1,1688,1169,1168,-1,1690,1674,1673,-1,987,1674,1690,-1,1336,1690,990,-1,1336,31,1690,-1,1020,1689,1168,-1,1020,1019,1689,-1,795,1686,1691,-1,795,1684,1686,-1,1681,796,1029,-1,796,1681,1683,-1,607,1675,1030,-1,607,1006,1675,-1,567,728,568,-1,1167,728,567,-1,1226,1170,561,-1,1226,786,1170,-1,1555,785,1560,-1,1555,979,785,-1,1552,1128,1557,-1,1552,801,1128,-1,557,555,560,-1,557,1051,555,-1,1554,1051,802,-1,1051,1554,555,-1,720,550,552,-1,720,558,550,-1,1692,725,1693,-1,725,1692,1158,-1,1229,1694,1695,-1,1229,1228,1694,-1,1696,1697,1698,-1,1697,1696,1699,-1,1535,1700,1534,-1,1701,1700,1535,-1,1514,1158,1692,-1,1158,1514,1513,-1,504,1501,1162,-1,1499,1501,504,-1,1160,1702,476,-1,1159,1702,1160,-1,1159,1458,1459,-1,1159,1161,1458,-1,1499,492,1703,-1,504,492,1499,-1,1513,62,1158,-1,1513,1337,62,-1,1701,1704,1699,-1,1701,1705,1704,-1,1060,1697,1706,-1,1697,1060,1695,-1,791,1707,1708,-1,791,1709,1707,-1,1545,1710,1711,-1,1545,1230,1710,-1,1712,1713,790,-1,1713,1712,729,-1,1705,1232,1565,-1,1232,1705,1533,-1,1714,1715,1716,-1,1714,1717,1715,-1,1718,1719,1720,-1,1719,1718,1130,-1,1564,1706,1704,-1,1706,1564,1561,-1,731,1157,1054,-1,731,730,1157,-1,1713,1718,1709,-1,1713,1721,1718,-1,1722,1698,1723,-1,1698,1722,1696,-1,1715,1724,1725,-1,1717,1724,1715,-1,727,568,728,-1,727,570,568,-1,1043,1480,1726,-1,1480,1043,1040,-1,1043,1727,1728,-1,1043,1726,1727,-1,1729,1727,1730,-1,1729,1731,1727,-1,1732,1733,1734,-1,1732,1731,1733,-1,1735,1736,1737,-1,1736,1735,1733,-1,1735,1738,1739,-1,1738,1735,1740,-1,1740,1741,1738,-1,1741,1740,1742,-1,1743,1744,1742,-1,1743,1745,1744,-1,1746,1744,1747,-1,1746,1748,1744,-1,1749,1747,1750,-1,1749,1746,1747,-1,1135,1751,1750,-1,1135,1137,1751,-1,1751,1752,1753,-1,1752,1751,1754,-1,1754,1755,1752,-1,1755,1754,1756,-1,1757,1758,1759,-1,1758,1757,1756,-1,1757,1687,1760,-1,1757,1685,1687,-1,1761,1480,1479,-1,1761,1726,1480,-1,1762,1236,1474,-1,724,1236,1762,-1,268,1388,578,-1,1302,1388,268,-1,1147,737,1145,-1,1147,738,737,-1,1763,1149,1764,-1,1763,1150,1149,-1,1150,1765,1152,-1,1765,1150,1766,-1,1767,1766,1768,-1,1767,1769,1766,-1,1770,735,1771,-1,1770,1769,735,-1,543,1772,734,-1,543,542,1772,-1,1772,1773,1774,-1,1773,1772,739,-1,1146,743,1775,-1,1146,741,743,-1,1151,1693,1149,-1,1693,1151,1692,-1,738,1776,1777,-1,1776,738,1147,-1,1647,1664,1668,-1,1647,1649,1664,-1,662,1640,1661,-1,662,1192,1640,-1,1778,1779,1780,-1,1781,1779,1778,-1,1782,1783,1784,-1,1782,1758,1783,-1,1785,1485,1786,-1,1485,1785,1486,-1,1787,1786,1031,-1,1782,1786,1787,-1,1788,1755,1760,-1,1781,1755,1788,-1,1779,1789,1790,-1,1779,1791,1789,-1,1792,1120,1793,-1,1792,1123,1120,-1,1794,1144,1795,-1,1144,1794,1143,-1,1703,490,58,-1,1703,492,490,-1,751,15,536,-1,751,13,15,-1,1528,1490,1496,-1,1528,1526,1490,-1,1505,1516,1503,-1,1519,1516,1505,-1,1522,1508,1520,-1,1522,1506,1508,-1,1796,1495,1510,-1,1796,1531,1495,-1,1010,1797,1007,-1,1798,1797,1010,-1,1799,1746,1749,-1,1799,1800,1746,-1,1138,1801,1802,-1,1138,1141,1801,-1,535,1776,1775,-1,535,1532,1776,-1,761,1803,1139,-1,761,760,1803,-1,1775,532,535,-1,1775,743,532,-1,1136,1802,1804,-1,1138,1802,1136,-1,1805,1749,1753,-1,1799,1749,1805,-1,1798,1806,1797,-1,1798,1807,1806,-1,820,1639,765,-1,1639,820,1000,-1,826,1134,780,-1,826,827,1134,-1,1144,1004,1808,-1,748,1004,1144,-1,1809,1810,1811,-1,1812,1810,1809,-1,1126,1813,1814,-1,1813,1126,1125,-1,1815,1741,1816,-1,1741,1815,1738,-1,1774,1524,1530,-1,1773,1524,1774,-1,1817,1054,1157,-1,1817,1055,1054,-1,1818,782,1819,-1,783,782,1818,-1,1136,1785,1784,-1,1785,1136,1804,-1,1021,715,284,-1,1021,1020,715,-1,1820,1026,1027,-1,1820,1025,1026,-1,274,584,582,-1,1383,584,274,-1,1821,789,788,-1,1821,817,789,-1,1134,1001,1822,-1,1000,1001,1134,-1,1670,1635,1646,-1,1670,1634,1635,-1,5,1128,6,-1,1128,5,979,-1,1823,1511,1497,-1,1824,1511,1823,-1,1825,1739,1826,-1,1825,1734,1739,-1,1827,814,1828,-1,814,1827,1829,-1,819,1825,1828,-1,1825,819,1830,-1,1736,1831,1824,-1,1736,1729,1831,-1,1832,1770,1771,-1,1832,1521,1770,-1,1130,1540,1719,-1,1130,1129,1540,-1,1556,1833,1553,-1,1556,792,1833,-1,502,721,503,-1,508,721,502,-1,1778,1753,1752,-1,1778,1805,1753,-1,1813,1834,1009,-1,1816,1834,1813,-1,1835,1830,819,-1,1836,1830,1835,-1,1837,1042,1041,-1,1042,1837,1481,-1,1201,694,812,-1,694,1201,697,-1,1642,1402,1643,-1,1642,1403,1402,-1,1613,1654,1620,-1,1654,1613,1657,-1,1597,1589,1200,-1,1597,1596,1589,-1,554,972,1155,-1,554,553,972,-1,1833,1838,974,-1,1838,1833,1708,-1,1839,1835,809,-1,1837,1835,1839,-1,1840,1761,1841,-1,1840,1730,1761,-1,1518,1765,1523,-1,1152,1765,1518,-1,1536,1716,1542,-1,1714,1716,1536,-1,1767,1541,1543,-1,1767,1768,1541,-1,1509,1840,1507,-1,1831,1840,1509,-1,1836,1732,1830,-1,1836,1728,1732,-1,822,776,775,-1,822,804,776,-1,474,1839,805,-1,1483,1839,474,-1,1814,1842,1812,-1,1008,1842,1814,-1,1007,1843,1844,-1,1797,1843,1007,-1,1806,1792,1845,-1,1846,1792,1806,-1,1789,1678,1121,-1,1679,1678,1789,-1,807,1052,603,-1,807,803,1052,-1,1001,1124,1821,-1,1001,821,1124,-1,1847,1810,1848,-1,1847,779,1810,-1,1003,1849,1850,-1,1003,1002,1849,-1,1793,1851,1852,-1,1793,1795,1851,-1,1677,1853,1122,-1,1677,1676,1853,-1,787,1811,788,-1,787,1809,1811,-1,1847,772,769,-1,772,1847,1002,-1,1843,1852,1850,-1,1843,1845,1852,-1,1853,1143,1794,-1,708,1143,1853,-1,643,1131,644,-1,823,1131,643,-1,1415,1453,1414,-1,433,1453,1415,-1,1117,444,435,-1,444,1117,456,-1,1272,98,1454,-1,1275,98,1272,-1,1456,438,1258,-1,439,438,1456,-1,1854,446,445,-1,1457,446,1854,-1,1114,103,102,-1,1114,345,103,-1,382,406,408,-1,382,1281,406,-1,1112,336,1289,-1,1112,339,336,-1,401,1436,1855,-1,401,1435,1436,-1,846,126,128,-1,126,846,159,-1,401,1109,399,-1,401,1855,1109,-1,1856,1107,1109,-1,1266,1107,1856,-1,1432,1111,400,-1,1432,1265,1111,-1,1250,411,397,-1,1250,409,411,-1,854,1446,418,-1,854,1468,1446,-1,1467,424,1449,-1,1467,1471,424,-1,1464,115,114,-1,115,1464,1466,-1,1241,1469,1239,-1,1469,1241,1470,-1,1465,1430,1240,-1,1465,1429,1430,-1,1427,1463,1425,-1,1462,1463,1427,-1,1428,1857,1426,-1,1858,1857,1428,-1,1431,865,1100,-1,1859,865,1431,-1,1859,1098,1099,-1,1859,1857,1098,-1,1242,1860,1858,-1,1242,1244,1860,-1,1861,1098,1860,-1,1861,1096,1098,-1,1097,863,1099,-1,1097,1862,863,-1,1863,866,1862,-1,866,1863,867,-1,1864,1097,1096,-1,1097,1864,1865,-1,1861,470,1866,-1,1861,1460,470,-1,1867,1864,1866,-1,1867,1868,1864,-1,1869,1863,1865,-1,1869,1870,1863,-1,413,1870,415,-1,868,1870,413,-1,1442,1868,1440,-1,1869,1868,1442,-1,1444,1867,469,-1,1867,1444,1443,-1,1871,1441,877,-1,1871,1439,1441,-1,874,414,1872,-1,874,412,414,-1,1873,1871,1874,-1,1872,1871,1873,-1,1875,1874,876,-1,1875,1876,1874,-1,1095,873,1873,-1,1095,880,873,-1,1877,1095,1876,-1,1095,1877,1094,-1,1875,1093,1878,-1,1875,878,1093,-1,1093,458,1450,-1,458,1093,459,-1,1877,1448,1447,-1,1448,1877,1878,-1,423,879,1094,-1,423,422,879,-1,1415,146,364,-1,358,146,1415,-1,1325,1338,1341,-1,1338,1325,1329,-1,831,1276,378,-1,893,1276,831,-1,1416,1879,1437,-1,1416,885,1879,-1,884,1266,1856,-1,884,888,1266,-1,1282,1259,452,-1,1259,1282,1452,-1,371,1282,367,-1,371,1452,1282,-1,1324,1339,1277,-1,1339,1324,140,-1,898,885,1416,-1,898,324,885,-1,1277,133,1278,-1,133,1277,1339,-1,1278,132,905,-1,132,1278,133,-1,325,907,1332,-1,901,907,325,-1,1880,902,1359,-1,1880,330,902,-1,1085,198,200,-1,1085,352,198,-1,1881,1359,211,-1,1881,1880,1359,-1,200,1882,1085,-1,1355,1882,200,-1,88,1357,1881,-1,88,87,1357,-1,119,909,1882,-1,119,921,909,-1,1083,122,121,-1,122,1083,88,-1,932,120,214,-1,932,935,120,-1,86,1084,1081,-1,1083,1084,86,-1,920,202,936,-1,118,202,920,-1,1285,925,1284,-1,1285,942,925,-1,214,930,932,-1,1082,930,214,-1,1390,1038,250,-1,1390,309,1038,-1,301,1081,1084,-1,301,303,1081,-1,1079,1014,308,-1,1079,1080,1014,-1,1392,1379,1883,-1,1392,302,1379,-1,1364,304,1297,-1,304,1364,1380,-1,237,1075,1287,-1,239,1075,237,-1,220,1382,218,-1,220,1076,1382,-1,1072,1391,1884,-1,1391,1072,1074,-1,610,69,611,-1,610,525,69,-1,528,71,73,-1,1070,71,528,-1,1629,1625,1627,-1,1624,1625,1629,-1,679,677,1304,-1,679,1187,677,-1,1577,676,1885,-1,1577,1576,676,-1,672,679,673,-1,484,679,672,-1,672,487,484,-1,672,818,487,-1,485,496,497,-1,485,488,496,-1,684,691,685,-1,691,684,669,-1,642,1669,640,-1,642,1607,1669,-1,1644,1633,1672,-1,1633,1644,1638,-1,1200,1599,1597,-1,1200,1199,1599,-1,1067,812,813,-1,1201,812,1067,-1,1591,1630,968,-1,1591,1574,1630,-1,1630,1219,1580,-1,1630,1574,1219,-1,1305,1886,960,-1,1305,1582,1886,-1,574,243,245,-1,243,574,1057,-1,1706,1061,1060,-1,1706,1561,1061,-1,1559,790,1558,-1,790,1559,1712,-1,53,1166,726,-1,55,1166,53,-1,67,77,46,-1,67,65,77,-1,1163,1887,1479,-1,1163,1162,1887,-1,1517,1692,1151,-1,1692,1517,1514,-1,1722,1700,1696,-1,1722,1888,1700,-1,542,1053,1055,-1,1053,542,544,-1,1889,729,1712,-1,729,1889,730,-1,1538,1714,1536,-1,1888,1714,1538,-1,1060,571,1544,-1,1060,1062,571,-1,228,978,230,-1,228,221,978,-1,563,1889,1227,-1,1050,1889,563,-1,1145,1890,1803,-1,1145,737,1890,-1,1050,730,1889,-1,730,1050,1156,-1,759,1156,1050,-1,1156,759,1139,-1,985,982,986,-1,983,982,985,-1,986,19,984,-1,982,19,986,-1,3,1674,1049,-1,1374,1674,3,-1,224,1891,227,-1,224,989,1891,-1,224,1377,225,-1,224,244,1377,-1,243,241,244,-1,243,235,241,-1,1303,994,1377,-1,1303,1048,994,-1,1013,251,1011,-1,980,251,1013,-1,1047,206,1046,-1,207,206,1047,-1,1642,702,1403,-1,1642,703,702,-1,797,800,609,-1,1655,800,797,-1,660,1659,1611,-1,1658,1659,660,-1,765,1636,810,-1,765,1639,1636,-1,748,1005,1004,-1,748,747,1005,-1,1773,1527,1524,-1,1527,1773,1777,-1,1518,1151,1152,-1,1151,1518,1517,-1,1841,1479,1887,-1,1761,1479,1841,-1,1483,1837,1839,-1,1483,1481,1837,-1,817,1124,815,-1,1124,817,1821,-1,1826,1738,1815,-1,1826,1739,1738,-1,781,1497,1494,-1,1823,1497,781,-1,783,1745,1743,-1,783,1818,1745,-1,1814,1009,1008,-1,1009,1814,1813,-1,1140,1818,1141,-1,1818,1140,1745,-1,1850,1844,1843,-1,1849,1844,1850,-1,1807,1846,1806,-1,1807,1780,1846,-1,1784,1137,1136,-1,1784,1783,1137,-1,1385,276,1387,-1,1385,1035,276,-1,1381,1299,1011,-1,1299,1381,1384,-1,1572,267,1033,-1,1572,256,267,-1,584,254,1571,-1,254,584,1383,-1,1892,270,282,-1,270,1892,271,-1,1302,1893,1388,-1,1301,1893,1302,-1,1012,281,280,-1,281,1012,1299,-1,1791,1679,1789,-1,1791,1682,1679,-1,1169,1759,1787,-1,1759,1169,1688,-1,1029,794,592,-1,796,794,1029,-1,588,592,794,-1,588,589,592,-1,1023,589,580,-1,1023,592,589,-1,1153,1027,585,-1,1027,1153,1820,-1,1570,291,290,-1,1570,1026,291,-1,1019,1820,1153,-1,1021,1820,1019,-1,1788,1682,1791,-1,1788,1680,1682,-1,1677,1121,1678,-1,1122,1121,1677,-1,1892,281,1386,-1,281,1892,282,-1,1893,1387,1388,-1,1893,1385,1387,-1,1301,1892,1893,-1,271,1892,1301,-1,1223,274,582,-1,274,1223,275,-1,1571,256,1572,-1,256,1571,254,-1,1785,1487,1486,-1,1785,1804,1487,-1,1805,1780,1807,-1,1778,1780,1805,-1,1845,1793,1852,-1,1845,1792,1793,-1,1491,1801,1819,-1,1491,1489,1801,-1,1010,1834,1800,-1,1834,1010,1009,-1,1812,1848,1810,-1,1812,1842,1848,-1,1834,1741,1748,-1,1834,1816,1741,-1,1492,1819,782,-1,1491,1819,1492,-1,1894,1823,781,-1,1737,1823,1894,-1,1125,1829,1827,-1,1829,1125,1127,-1,805,603,474,-1,805,807,603,-1,1504,1887,1502,-1,1504,1841,1887,-1,1895,1530,1529,-1,1895,1774,1530,-1,1777,1532,1527,-1,1777,1776,1532,-1,1808,1795,1144,-1,1795,1808,1851,-1,764,811,1896,-1,764,762,811,-1,779,769,780,-1,1847,769,779,-1,799,1660,1653,-1,799,798,1660,-1,1615,1657,1613,-1,1657,1615,1656,-1,1649,1666,1664,-1,1649,1650,1666,-1,1406,1643,1402,-1,1641,1643,1406,-1,658,1575,631,-1,658,614,1575,-1,244,356,1377,-1,356,244,241,-1,225,994,993,-1,225,1377,994,-1,992,295,988,-1,992,993,295,-1,989,1375,1891,-1,991,1375,989,-1,992,990,223,-1,1336,990,992,-1,713,14,1058,-1,713,15,14,-1,987,1049,1674,-1,987,986,1049,-1,1059,33,27,-1,1059,745,33,-1,12,786,784,-1,1170,786,12,-1,1156,1803,1890,-1,1803,1156,1139,-1,1890,1157,1156,-1,1817,1157,1890,-1,1817,737,740,-1,1890,737,1817,-1,230,575,573,-1,230,978,575,-1,565,1167,567,-1,564,1167,565,-1,10,2,6,-1,10,975,2,-1,1764,1539,1763,-1,1537,1539,1764,-1,1710,1725,1724,-1,1838,1725,1710,-1,1694,1723,1698,-1,1694,1711,1723,-1,1165,1537,1764,-1,1164,1537,1165,-1,1502,1162,1501,-1,1502,1887,1162,-1,47,78,44,-1,47,548,78,-1,1704,1565,1564,-1,1704,1705,1565,-1,546,41,52,-1,546,1569,41,-1,1228,1711,1694,-1,1228,1545,1711,-1,1886,1204,1883,-1,1204,1886,1361,-1,1398,1580,1396,-1,1630,1580,1398,-1,968,1592,1591,-1,1198,1592,968,-1,1671,1632,1645,-1,1632,1671,1623,-1,1668,1648,1647,-1,1668,1667,1648,-1,649,1173,813,-1,649,1296,1173,-1,1066,637,1196,-1,1066,638,637,-1,125,488,487,-1,125,1190,488,-1,1474,1702,1762,-1,1474,1477,1702,-1,520,1369,523,-1,520,1372,1369,-1,962,1367,618,-1,962,1373,1367,-1,1578,1885,1621,-1,1578,1577,1885,-1,1370,1576,1371,-1,676,1576,1370,-1,1626,678,1631,-1,678,1626,1628,-1,1293,514,612,-1,316,514,1293,-1,1884,951,252,-1,951,1884,1391,-1,218,952,950,-1,218,1382,952,-1,1363,1073,1362,-1,1363,1071,1073,-1,302,1380,1379,-1,302,304,1380,-1,1883,1206,1392,-1,1206,1883,1204,-1,942,1393,307,-1,1285,1393,942,-1,926,938,939,-1,298,938,926,-1,204,936,202,-1,204,937,936,-1,217,1084,215,-1,217,301,1084,-1,250,949,1390,-1,949,250,249,-1,926,924,922,-1,926,940,924,-1,1284,918,916,-1,1284,925,918,-1,922,119,920,-1,119,922,921,-1,1082,213,919,-1,1082,214,213,-1,918,84,911,-1,918,85,84,-1,909,923,910,-1,921,923,909,-1,1355,119,1882,-1,117,119,1355,-1,1881,122,88,-1,122,1881,211,-1,83,912,84,-1,83,914,912,-1,913,917,911,-1,913,1413,917,-1,904,1882,909,-1,1882,904,1085,-1,1309,1881,1357,-1,1881,1309,1880,-1,323,1291,321,-1,323,915,1291,-1,1410,908,907,-1,914,908,1410,-1,330,1309,361,-1,1880,1309,330,-1,1410,901,900,-1,1410,907,901,-1,132,1331,352,-1,132,134,1331,-1,1088,895,210,-1,1088,1087,895,-1,324,900,901,-1,324,898,900,-1,1279,334,892,-1,1279,1278,334,-1,1331,1340,1327,-1,1331,134,1340,-1,889,903,329,-1,903,889,886,-1,389,1417,1276,-1,389,899,1417,-1,1090,892,894,-1,1279,892,1090,-1,139,1327,1340,-1,1327,139,136,-1,889,1283,887,-1,889,368,1283,-1,886,884,208,-1,886,888,884,-1,887,451,1102,-1,887,1283,451,-1,888,1102,1101,-1,888,887,1102,-1,885,1856,1879,-1,885,884,1856,-1,837,1276,1417,-1,1276,837,378,-1,1119,151,1330,-1,1119,152,151,-1,1447,1094,1877,-1,1447,423,1094,-1,1450,1878,1093,-1,1450,1448,1878,-1,1878,1876,1875,-1,1876,1878,1877,-1,1873,1876,1095,-1,1876,1873,1874,-1,876,878,1875,-1,878,876,875,-1,876,1871,877,-1,1871,876,1874,-1,873,1872,1873,-1,874,1872,873,-1,1872,1439,1871,-1,1872,414,1439,-1,877,872,870,-1,877,1441,872,-1,1443,1868,1867,-1,1868,1443,1440,-1,415,1869,1442,-1,1870,1869,415,-1,1870,867,1863,-1,1870,868,867,-1,1868,1865,1864,-1,1868,1869,1865,-1,469,1866,470,-1,469,1867,1866,-1,1866,1096,1861,-1,1096,1866,1864,-1,1865,1862,1097,-1,1862,1865,1863,-1,1862,864,863,-1,1862,866,864,-1,1460,1860,1244,-1,1460,1861,1860,-1,1858,1098,1857,-1,1858,1860,1098,-1,1099,865,1859,-1,865,1099,863,-1,1859,1426,1857,-1,1859,1431,1426,-1,1424,1858,1428,-1,1242,1858,1424,-1,1429,1462,1427,-1,1465,1462,1429,-1,1240,859,858,-1,1240,1430,859,-1,857,1470,1241,-1,1470,857,856,-1,1239,1466,1464,-1,1466,1239,1469,-1,1238,419,471,-1,419,1238,1897,-1,1471,422,424,-1,852,422,1471,-1,1468,1449,1446,-1,1468,1467,1449,-1,172,154,1249,-1,154,172,847,-1,398,851,453,-1,398,1271,851,-1,153,449,154,-1,153,1342,449,-1,1109,1879,1856,-1,1855,1879,1109,-1,842,131,130,-1,131,842,844,-1,1438,130,840,-1,1110,130,1438,-1,1855,1437,1879,-1,1855,1436,1437,-1,1433,833,838,-1,404,833,1433,-1,425,1411,386,-1,425,834,1411,-1,1268,385,384,-1,1270,385,1268,-1,376,380,1418,-1,380,376,375,-1,420,169,1261,-1,170,169,420,-1,394,1457,1854,-1,393,1457,394,-1,1422,436,830,-1,1253,436,1422,-1,364,433,1415,-1,366,433,364,-1,1330,149,1119,-1,1330,1323,149,-1,1646,1667,1670,-1,1646,1648,1667,-1,780,1822,778,-1,780,1134,1822,-1,1851,773,1003,-1,1808,773,1851,-1,1849,1842,1844,-1,1848,1842,1849,-1,497,486,485,-1,1068,486,497,-1,1122,1794,1120,-1,1122,1853,1794,-1,1003,1852,1851,-1,1003,1850,1852,-1,1848,1002,1847,-1,1849,1002,1848,-1,788,778,1822,-1,1811,778,788,-1,821,775,1124,-1,822,775,821,-1,1790,1121,1123,-1,1789,1121,1790,-1,1797,1845,1843,-1,1806,1845,1797,-1,1844,1008,1007,-1,1844,1842,1008,-1,1127,1809,787,-1,1126,1809,1127,-1,777,816,815,-1,816,777,808,-1,1672,1645,1644,-1,1672,1671,1645,-1,767,804,822,-1,767,768,804,-1,809,819,808,-1,809,1835,819,-1,1831,1730,1840,-1,1729,1730,1831,-1,1523,1770,1521,-1,1523,1765,1770,-1,1719,1542,1716,-1,1540,1542,1719,-1,1541,1763,1539,-1,1541,1768,1763,-1,1507,1841,1504,-1,1507,1840,1841,-1,1041,1728,1836,-1,1043,1728,1041,-1,805,809,806,-1,1839,809,805,-1,804,807,776,-1,807,804,803,-1,974,1553,1833,-1,974,973,1553,-1,1724,1711,1710,-1,1711,1724,1723,-1,1408,1641,1406,-1,1180,1641,1408,-1,598,1655,797,-1,600,1655,598,-1,1656,1611,1659,-1,1656,1615,1611,-1,1196,1199,1066,-1,1196,1599,1199,-1,1066,1201,1067,-1,1066,1199,1201,-1,476,1477,1475,-1,1702,1477,476,-1,1837,1836,1835,-1,1041,1836,1837,-1,1827,1815,1125,-1,1827,1826,1815,-1,794,585,588,-1,794,732,585,-1,1760,1680,1788,-1,1760,1687,1680,-1,1800,1748,1746,-1,1800,1834,1748,-1,792,1708,1833,-1,792,791,1708,-1,1543,736,1767,-1,793,736,1543,-1,1509,1824,1831,-1,1511,1824,1509,-1,1830,1734,1825,-1,1734,1830,1732,-1,816,1828,814,-1,1828,816,819,-1,1828,1826,1827,-1,1828,1825,1826,-1,1737,1824,1823,-1,1736,1824,1737,-1,1771,1529,1832,-1,1771,1895,1529,-1,1558,792,1556,-1,790,792,1558,-1,1133,825,1637,-1,1133,827,825,-1,1822,1821,788,-1,1001,1821,1822,-1,789,814,1829,-1,817,814,789,-1,787,1829,1127,-1,789,1829,787,-1,1570,1027,1026,-1,1028,1027,1570,-1,284,1820,1021,-1,1820,284,1025,-1,1787,711,1169,-1,1787,1031,711,-1,1141,1819,1801,-1,1141,1818,1819,-1,1712,1227,1889,-1,1227,1712,1559,-1,740,1055,1817,-1,1055,740,542,-1,1494,782,781,-1,1492,782,1494,-1,781,1743,1894,-1,783,1743,781,-1,1125,1816,1813,-1,1816,1125,1815,-1,1814,1809,1126,-1,1814,1812,1809,-1,779,1811,1810,-1,779,778,1811,-1,708,746,1143,-1,752,746,708,-1,1808,774,773,-1,1004,774,1808,-1,774,769,772,-1,774,770,769,-1,771,780,769,-1,771,826,780,-1,1631,677,1187,-1,1631,678,677,-1,1799,1807,1798,-1,1799,1805,1807,-1,1804,1488,1487,-1,1802,1488,1804,-1,34,760,16,-1,760,34,1148,-1,1803,1148,1145,-1,1803,760,1148,-1,1489,1802,1801,-1,1488,1802,1489,-1,1798,1800,1799,-1,1798,1010,1800,-1,1525,756,1493,-1,754,756,1525,-1,534,758,755,-1,534,533,758,-1,1496,1531,1528,-1,1531,1496,1495,-1,1796,1506,1522,-1,1796,1510,1506,-1,1503,1520,1508,-1,1503,1516,1520,-1,1505,1512,1519,-1,1505,1498,1512,-1,1493,1526,1525,-1,1526,1493,1490,-1,1651,1663,1662,-1,1651,1652,1663,-1,1120,1795,1793,-1,1795,1120,1794,-1,1846,1123,1792,-1,1846,1790,1123,-1,1781,1791,1779,-1,1781,1788,1791,-1,1758,1787,1759,-1,1758,1782,1787,-1,1031,1485,1032,-1,1786,1485,1031,-1,529,750,757,-1,531,750,529,-1,1784,1786,1782,-1,1786,1784,1785,-1,1781,1752,1755,-1,1781,1778,1752,-1,1780,1790,1846,-1,1779,1790,1780,-1,1650,1662,1666,-1,1651,1662,1650,-1,670,641,1610,-1,1605,641,670,-1,1693,1764,1149,-1,1693,1165,1764,-1,741,33,742,-1,34,33,741,-1,741,1148,34,-1,1148,741,1146,-1,1147,1775,1776,-1,1775,1147,1146,-1,739,1777,1773,-1,739,738,1777,-1,739,542,740,-1,739,1772,542,-1,1895,1772,1774,-1,734,1772,1895,-1,1771,734,1895,-1,735,734,1771,-1,735,1767,736,-1,735,1769,1767,-1,1765,1769,1770,-1,1766,1769,1765,-1,1768,1150,1763,-1,1766,1150,1768,-1,1153,1691,1019,-1,1153,733,1691,-1,506,724,508,-1,1236,724,506,-1,733,795,1691,-1,732,795,733,-1,1757,1688,1685,-1,1757,1759,1688,-1,1756,1760,1755,-1,1756,1757,1760,-1,1756,1783,1758,-1,1756,1754,1783,-1,1137,1754,1751,-1,1754,1137,1783,-1,1753,1750,1751,-1,1750,1753,1749,-1,1750,1140,1135,-1,1750,1747,1140,-1,1747,1745,1140,-1,1747,1744,1745,-1,1742,1748,1741,-1,1742,1744,1748,-1,1894,1742,1740,-1,1742,1894,1743,-1,1740,1737,1894,-1,1740,1735,1737,-1,1735,1734,1733,-1,1735,1739,1734,-1,1733,1729,1736,-1,1733,1731,1729,-1,1728,1731,1732,-1,1727,1731,1728,-1,1726,1730,1727,-1,1726,1761,1730,-1,1715,1707,1720,-1,1707,1715,1725,-1,1724,1722,1723,-1,1724,1717,1722,-1,1709,1720,1707,-1,1720,1709,1718,-1,1721,1054,1056,-1,1054,1721,731,-1,1056,1718,1721,-1,1130,1718,1056,-1,1720,1716,1715,-1,1716,1720,1719,-1,1888,1717,1714,-1,1888,1722,1717,-1,1534,1888,1538,-1,1700,1888,1534,-1,1838,1230,974,-1,1710,1230,1838,-1,729,1721,1713,-1,729,731,1721,-1,1708,1725,1838,-1,1708,1707,1725,-1,1709,790,1713,-1,790,1709,791,-1,1544,1695,1060,-1,1695,1544,1229,-1,1699,1706,1697,-1,1699,1704,1706,-1,1533,1701,1535,-1,1533,1705,1701,-1,1142,1515,1500,-1,1142,64,1515,-1,1459,724,1762,-1,1459,722,724,-1,1498,1515,1512,-1,1515,1498,1500,-1,1701,1696,1700,-1,1699,1696,1701,-1,1698,1695,1694,-1,1695,1698,1697,-1,725,1165,1693,-1,726,1165,725,-1,1159,1762,1702,-1,1459,1762,1159,-1,552,564,720,-1,552,1167,564,-1,560,550,557,-1,551,550,560,-1,1557,979,1555,-1,979,1557,1128,-1,802,1552,1554,-1,801,1552,802,-1,786,1560,785,-1,1560,786,1226,-1,12,21,29,-1,12,11,21,-1,1030,717,593,-1,1030,1675,717,-1,718,1029,591,-1,1029,718,1681,-1,1684,796,1683,-1,795,796,1684,-1,1019,1686,1689,-1,1019,1691,1686,-1,1168,715,1020,-1,715,1168,712,-1,1673,990,1690,-1,991,990,1673,-1,31,987,1690,-1,32,987,31,-1,714,536,15,-1,536,714,537,-1,1689,1685,1688,-1,1685,1689,1686,-1,1687,1683,1680,-1,1687,1684,1683,-1,1682,718,1679,-1,1682,1681,718,-1,1675,1678,717,-1,1677,1678,1675,-1,1376,991,1673,-1,1376,1375,991,-1,710,975,9,-1,976,975,710,-1,1676,708,1853,-1,708,1676,709,-1,1006,709,1676,-1,1006,706,709,-1,1661,660,662,-1,1658,660,1661,-1,1172,680,1181,-1,1172,639,680,-1,634,680,636,-1,634,681,680,-1,1177,1620,1654,-1,1177,1618,1620,-1,1590,1596,1594,-1,1589,1596,1590,-1,1065,696,1195,-1,694,696,1065,-1,693,1175,596,-1,693,1178,1175,-1,576,1037,1174,-1,1037,576,594,-1,1608,1623,1671,-1,1185,1623,1608,-1,1672,654,650,-1,1672,1633,654,-1,1670,1669,1609,-1,1670,1667,1669,-1,1668,1665,640,-1,1668,1664,1665,-1,1666,1640,997,-1,1666,1662,1640,-1,1663,1658,1661,-1,1663,1660,1658,-1,800,1659,798,-1,1659,800,1656,-1,1657,600,1654,-1,1657,1655,600,-1,613,996,1045,-1,996,613,664,-1,799,609,800,-1,609,799,698,-1,1652,699,1653,-1,1652,753,699,-1,749,1650,747,-1,749,1651,1650,-1,1649,1044,1005,-1,1649,1647,1044,-1,825,1648,1646,-1,824,1648,825,-1,810,1638,1644,-1,1636,1638,810,-1,1645,1896,811,-1,1645,1632,1896,-1,701,626,705,-1,626,701,627,-1,1642,624,703,-1,624,1642,622,-1,1586,1641,1584,-1,1586,1643,1641,-1,1172,621,1171,-1,621,1172,628,-1,1585,1601,623,-1,1585,1602,1601,-1,1587,1604,1603,-1,1604,1587,1588,-1,690,667,705,-1,668,667,690,-1,999,1665,997,-1,999,1610,1665,-1,691,705,626,-1,691,690,705,-1,1637,1639,1133,-1,1639,1637,1636,-1,1634,1638,1635,-1,1638,1634,1633,-1,682,1181,680,-1,682,683,1181,-1,1896,1631,764,-1,1896,1626,1631,-1,1304,676,1370,-1,1304,677,676,-1,678,1885,676,-1,678,1628,1885,-1,674,1372,520,-1,674,673,1372,-1,672,675,818,-1,672,674,675,-1,1896,1629,1626,-1,1896,1632,1629,-1,1628,1621,1885,-1,1628,1627,1621,-1,1624,1295,1625,-1,1295,1624,1186,-1,1395,1622,1397,-1,1395,1579,1622,-1,645,1607,642,-1,644,1607,645,-1,671,668,669,-1,671,666,668,-1,1399,661,663,-1,667,661,1399,-1,1401,1191,1612,-1,1400,1191,1401,-1,1404,1616,1407,-1,1404,1614,1616,-1,1405,1619,689,-1,1405,1617,1619,-1,1618,665,659,-1,665,1618,1177,-1,1620,1616,1613,-1,1620,1617,1616,-1,1614,1611,1615,-1,1614,1612,1611,-1,999,666,671,-1,998,666,999,-1,1619,659,656,-1,1619,1618,659,-1,1607,1609,1669,-1,1607,1606,1609,-1,653,650,654,-1,653,651,650,-1,646,1608,650,-1,646,648,1608,-1,1193,1131,1132,-1,1606,1131,1193,-1,1184,653,655,-1,1184,967,653,-1,646,1296,649,-1,651,1296,646,-1,647,1194,648,-1,647,1065,1194,-1,645,684,643,-1,645,1605,684,-1,1610,640,1665,-1,1610,641,640,-1,1573,1182,686,-1,1573,1593,1182,-1,1603,1598,1595,-1,1604,1598,1603,-1,1600,1601,1602,-1,1600,1197,1601,-1,1597,1600,1595,-1,1599,1600,1597,-1,1594,1598,1593,-1,1596,1598,1594,-1,1591,1573,1221,-1,1592,1573,1591,-1,1590,697,1589,-1,1590,695,697,-1,629,1575,1216,-1,631,1575,629,-1,1584,1588,1587,-1,1584,1179,1588,-1,628,624,621,-1,628,627,624,-1,1586,623,622,-1,623,1586,1585,-1,1366,618,1367,-1,1366,619,618,-1,1581,1360,1582,-1,1581,1220,1360,-1,1212,617,616,-1,617,1212,995,-1,604,1045,1213,-1,1045,604,613,-1,1216,1211,1214,-1,1575,1211,1216,-1,1396,1581,1394,-1,1396,1580,1581,-1,1578,1209,1208,-1,1579,1209,1578,-1,620,1576,1577,-1,620,619,1576,-1,523,1368,1583,-1,1369,1368,523,-1,521,68,522,-1,611,68,521,-1,499,603,1052,-1,499,475,603,-1,1028,586,585,-1,1028,583,586,-1,587,589,588,-1,590,589,587,-1,1571,587,586,-1,1571,1572,587,-1,1570,583,1028,-1,1570,581,583,-1,1188,1568,1161,-1,1188,1473,1568,-1,79,1547,539,-1,79,1225,1547,-1,480,1568,1473,-1,480,955,1568,-1,49,971,572,-1,971,49,40,-1,1566,1567,1562,-1,1551,1567,1566,-1,1231,1565,1232,-1,1565,1231,1563,-1,1564,1562,1561,-1,1564,1566,1562,-1,94,1061,1548,-1,1062,1061,94,-1,1558,1560,1559,-1,1555,1560,1558,-1,1553,1557,1556,-1,1552,1557,1553,-1,555,973,553,-1,555,1554,973,-1,540,1547,1550,-1,540,539,1547,-1,1563,1551,1566,-1,1551,1563,1550,-1,545,1549,546,-1,1549,545,92,-1,1569,547,41,-1,1569,1546,547,-1,1544,570,727,-1,1544,571,570,-1,1155,1230,1545,-1,1155,972,1230,-1,1540,793,1543,-1,1540,1129,793,-1,1542,1539,1536,-1,1542,1541,1539,-1,1538,1164,1534,-1,1538,1537,1164,-1,55,1535,1166,-1,1533,1535,55,-1,1832,1531,1796,-1,1832,1529,1531,-1,1530,1526,1528,-1,1530,1524,1526,-1,1522,1832,1796,-1,1521,1832,1522,-1,1520,1518,1523,-1,1518,1520,1516,-1,1514,1519,1512,-1,1514,1517,1519,-1,1337,1515,64,-1,1337,1513,1515,-1,1511,1506,1510,-1,1511,1509,1506,-1,1508,1504,1503,-1,1507,1504,1508,-1,1501,1505,1502,-1,1501,1498,1505,-1,1500,1703,1142,-1,1500,1499,1703,-1,1492,1496,1490,-1,1492,1494,1496,-1,1489,1493,756,-1,1489,1491,1493,-1,755,1487,1488,-1,1487,755,758,-1,750,1486,757,-1,750,1485,1486,-1,536,1032,751,-1,538,1032,536,-1,1532,534,754,-1,1532,535,534,-1,1142,58,57,-1,1142,1703,58,-1,521,1583,612,-1,521,523,1583,-1,612,1409,1293,-1,612,1583,1409,-1,314,957,954,-1,957,314,317,-1,507,505,1234,-1,507,491,505,-1,1478,511,1237,-1,511,1478,512,-1,1476,509,1482,-1,1476,510,509,-1,1190,477,488,-1,1190,478,477,-1,1484,1481,1483,-1,1481,1484,1482,-1,512,1042,509,-1,512,1040,1042,-1,1235,1163,1479,-1,1235,1234,1163,-1,1040,1478,1480,-1,512,1478,1040,-1,498,473,475,-1,498,494,473,-1,495,1476,493,-1,495,1475,1476,-1,511,1477,1474,-1,511,510,1477,-1,70,483,68,-1,483,70,481,-1,70,1473,481,-1,70,480,1473,-1,477,1475,495,-1,476,1475,477,-1,1160,478,1189,-1,1160,476,478,-1,723,1472,1224,-1,723,1458,1472,-1,479,959,1069,-1,527,959,479,-1,1469,1471,1467,-1,1470,1471,1469,-1,115,1468,854,-1,1466,1468,115,-1,1465,114,1462,-1,1465,1464,114,-1,465,869,1313,-1,468,869,465,-1,1463,178,177,-1,116,178,1463,-1,1460,186,470,-1,1460,1353,186,-1,1313,871,1898,-1,871,1313,869,-1,462,116,463,-1,462,178,116,-1,177,1425,1463,-1,1312,1425,177,-1,428,398,453,-1,428,1116,398,-1,1246,172,1249,-1,171,172,1246,-1,1103,1271,849,-1,1103,851,1271,-1,472,1445,455,-1,472,421,1445,-1,417,1347,1264,-1,417,1348,1347,-1,447,456,455,-1,447,444,456,-1,830,393,1422,-1,393,830,1457,-1,448,455,1445,-1,447,455,448,-1,1111,1105,841,-1,1111,1265,1105,-1,1245,1455,1454,-1,1246,1455,1245,-1,1451,1262,1254,-1,1451,441,1262,-1,446,444,447,-1,446,443,444,-1,440,1247,1255,-1,440,442,1247,-1,392,1453,1423,-1,392,439,1453,-1,1118,435,437,-1,1118,1117,435,-1,432,1275,1274,-1,432,98,1275,-1,161,1897,1311,-1,419,1897,161,-1,432,1254,97,-1,1451,1254,432,-1,846,843,845,-1,844,843,846,-1,1108,848,850,-1,1108,1107,848,-1,1254,168,95,-1,1254,1262,168,-1,458,1349,416,-1,1349,458,460,-1,1448,418,1446,-1,418,1448,1450,-1,1449,423,1447,-1,1449,424,423,-1,1273,1854,1252,-1,394,1854,1273,-1,1263,1445,1261,-1,448,1445,1263,-1,445,1252,1854,-1,445,1260,1252,-1,1348,416,1349,-1,417,416,1348,-1,402,1438,1434,-1,1438,402,1110,-1,386,1269,387,-1,1411,1269,386,-1,1444,1898,871,-1,1444,1461,1898,-1,1441,1443,872,-1,1441,1440,1443,-1,414,1442,1439,-1,414,415,1442,-1,840,388,1438,-1,388,840,836,-1,838,1435,1433,-1,838,1436,1435,-1,1437,1417,1416,-1,1417,1437,837,-1,1280,404,1433,-1,1280,405,404,-1,1434,401,402,-1,401,1434,1435,-1,1432,399,1108,-1,1432,400,399,-1,850,411,1104,-1,849,411,850,-1,1431,1429,1426,-1,1429,1431,1430,-1,1428,1425,1424,-1,1425,1428,1427,-1,194,112,111,-1,112,194,196,-1,113,1253,434,-1,1253,113,395,-1,1423,393,392,-1,393,1423,1422,-1,1256,1421,1251,-1,1255,1421,1256,-1,429,442,1420,-1,1247,442,429,-1,1091,1418,349,-1,1091,1419,1418,-1,1419,893,831,-1,1419,894,893,-1,1113,408,1267,-1,1113,391,408,-1,408,350,382,-1,408,391,350,-1,377,383,375,-1,384,383,377,-1,1091,348,1092,-1,1091,349,348,-1,326,899,389,-1,899,326,332,-1,369,363,374,-1,370,363,369,-1,369,1452,371,-1,369,373,1452,-1,372,1258,373,-1,372,1456,1258,-1,1412,890,147,-1,1412,891,890,-1,1328,891,1412,-1,364,148,365,-1,364,146,148,-1,361,199,198,-1,1310,199,361,-1,1290,1358,201,-1,1290,1356,1358,-1,362,357,363,-1,362,360,357,-1,1413,905,906,-1,1413,335,905,-1,910,916,917,-1,923,916,910,-1,353,1412,351,-1,353,1328,1412,-1,349,380,350,-1,380,349,1418,-1,834,1289,1411,-1,834,1112,1289,-1,354,345,1115,-1,354,344,345,-1,1288,103,344,-1,1288,1267,103,-1,335,913,328,-1,913,335,1413,-1,333,900,332,-1,333,1410,900,-1,333,913,912,-1,333,328,913,-1,209,1332,1307,-1,325,1332,209,-1,964,1409,1365,-1,964,963,1409,-1,77,317,314,-1,317,77,74,-1,1408,689,688,-1,1408,1405,689,-1,1402,1407,1406,-1,1402,1404,1407,-1,1403,1400,1401,-1,702,1400,1403,-1,704,667,1399,-1,705,667,704,-1,1397,1396,1395,-1,1396,1397,1398,-1,1305,1210,1394,-1,1305,961,1210,-1,949,941,939,-1,949,1078,941,-1,299,308,300,-1,299,1079,308,-1,1393,1078,1378,-1,1393,941,1078,-1,929,302,1392,-1,303,302,929,-1,927,1205,203,-1,927,1206,1205,-1,1074,933,1391,-1,933,1074,931,-1,951,943,950,-1,943,951,946,-1,305,218,945,-1,305,219,218,-1,938,309,1390,-1,938,300,309,-1,293,289,297,-1,289,293,290,-1,279,1389,280,-1,1389,279,292,-1,1389,294,1018,-1,1389,292,294,-1,283,288,296,-1,285,288,283,-1,1387,278,615,-1,276,278,1387,-1,1299,1386,281,-1,1299,1384,1386,-1,1893,1386,1385,-1,1893,1892,1386,-1,266,1383,274,-1,266,265,1383,-1,263,275,272,-1,263,266,275,-1,273,1017,1300,-1,273,272,1017,-1,269,578,579,-1,269,268,578,-1,953,252,43,-1,252,953,1884,-1,952,1057,970,-1,1382,1057,952,-1,236,243,1076,-1,235,243,236,-1,948,251,1048,-1,249,251,948,-1,250,1011,251,-1,1038,1011,250,-1,1039,1034,1381,-1,1015,1034,1039,-1,1047,246,207,-1,246,1047,947,-1,1883,960,1886,-1,1379,960,1883,-1,1373,1380,1364,-1,1373,962,1380,-1,1077,1378,1078,-1,1287,1378,1077,-1,220,306,1075,-1,220,219,306,-1,315,1884,953,-1,1884,315,1072,-1,239,1076,1075,-1,239,236,1076,-1,241,355,356,-1,241,242,355,-1,238,239,237,-1,238,240,239,-1,1891,228,227,-1,1891,221,228,-1,976,1376,1374,-1,976,710,1376,-1,222,1891,1375,-1,221,1891,222,-1,948,1077,949,-1,948,1286,1077,-1,1304,1372,673,-1,1304,1370,1372,-1,1368,1371,1366,-1,1371,1368,1369,-1,964,1364,1362,-1,1373,1364,964,-1,217,1363,1297,-1,216,1363,217,-1,1361,1582,1360,-1,1582,1361,1886,-1,212,213,122,-1,212,1308,213,-1,1359,1087,1089,-1,1359,902,1087,-1,210,1307,1088,-1,210,209,1307,-1,915,1086,1291,-1,1308,1086,915,-1,206,605,1213,-1,206,205,605,-1,201,1357,87,-1,1357,201,1358,-1,117,1356,1290,-1,117,1355,1356,-1,173,1316,1314,-1,1318,1316,173,-1,177,195,1312,-1,177,176,195,-1,109,1354,193,-1,109,108,1354,-1,108,1352,1354,-1,108,105,1352,-1,105,187,1352,-1,105,107,187,-1,188,1351,1461,-1,188,189,1351,-1,1461,1350,1898,-1,1461,1351,1350,-1,1898,182,1313,-1,1898,1350,182,-1,185,174,1315,-1,174,185,184,-1,101,1346,1319,-1,101,1311,1346,-1,1311,1344,1346,-1,1311,1897,1344,-1,1343,1897,1238,-1,1344,1897,1343,-1,1238,180,1343,-1,1238,181,180,-1,180,178,462,-1,175,178,180,-1,166,847,172,-1,166,1320,847,-1,1322,168,164,-1,168,1322,95,-1,160,1342,153,-1,160,845,1342,-1,106,143,346,-1,143,106,1326,-1,890,137,152,-1,890,138,137,-1,141,1324,883,-1,141,140,1324,-1,1115,145,354,-1,1115,346,145,-1,881,1341,882,-1,881,1325,1341,-1,140,1340,1339,-1,140,139,1340,-1,353,1327,1328,-1,1331,1327,353,-1,1338,137,136,-1,1338,151,137,-1,135,1323,1329,-1,110,1323,135,-1,127,131,128,-1,129,131,127,-1,935,121,120,-1,935,215,121,-1,45,82,46,-1,45,80,82,-1,1337,61,62,-1,61,1337,1333,-1,81,53,59,-1,81,541,53,-1,44,80,45,-1,44,78,80,-1,39,47,44,-1,39,38,47,-1,572,38,37,-1,572,971,38,-1,24,1336,22,-1,24,31,1336,-1,1335,32,30,-1,1335,985,32,-1,1334,27,25,-1,1334,1059,27,-1,1334,1058,1059,-1,1334,1335,1058,-1,23,30,24,-1,713,30,23,-1,20,29,21,-1,20,26,29,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rhumerus_Coord',point=[(-8.28979,37.25941,-1.29361),(-8.26605,37.19452,-1.28062),(-8.24568,37.20182,-1.22764),(-8.27957,37.20227,-1.34542),(-8.17304,37.04512,-1.27069),(-8.11423,37.06327,-1.15854),(-8.13767,37.22376,-1.11403),(-8.19052,37.36172,-1.15735),(-8.23221,37.45926,-1.18596),(-8.29064,37.39793,-1.26355),(-8.23872,37.33233,-1.20278),(-8.07489,36.94933,-1.35047),(-8.07574,36.93948,-1.25595),(-7.7078,37.06627,-1.71016),(-7.72837,37.064,-1.70881),(-7.71339,37.11368,-1.76322),(-7.84563,36.89001,-1.47923),(-7.89051,36.88034,-1.41647),(-7.92567,36.89024,-1.41761),(-8.05806,36.97136,-1.44418),(-7.95678,36.93676,-1.44477),(-8.00425,36.92723,-1.37929),(-7.72826,37.24629,-1.81958),(-7.73924,37.17737,-1.78897),(-7.74727,37.18606,-1.77515),(-7.87154,36.96069,-1.52634),(-7.93686,36.92615,-1.42522),(-7.83797,36.94631,-1.55021),(-7.95694,36.88404,-1.36055),(-7.97439,36.91555,-1.36878),(-7.77172,37.12866,-1.73472),(-7.88841,37.19833,-1.73323),(-7.89147,37.13726,-1.68298),(-7.77752,36.9472,-1.56821),(-7.78341,36.89143,-1.49801),(-7.80736,38.2122,-1.43751),(-7.90384,38.14701,-1.46297),(-7.83929,38.0945,-1.41762),(-7.78957,37.98633,-1.39627),(-7.77369,38.04312,-1.39668),(-7.87923,37.84619,-1.35532),(-7.82134,37.7594,-1.28661),(-7.81656,37.79977,-1.33817),(-7.71112,38.21477,-1.41059),(-7.66062,38.00124,-1.34787),(-7.59999,38.05856,-1.30961),(-7.52402,38.10839,-1.29187),(-7.72953,37.93439,-1.36751),(-7.81314,37.88639,-1.36779),(-7.95417,37.83209,-1.34296),(-7.94509,37.75092,-1.27124),(-7.90034,37.76975,-1.27569),(-7.86231,37.76607,-1.28926),(-7.61461,37.61602,-1.18301),(-7.65243,37.64042,-1.18175),(-7.65188,37.62489,-1.15013),(-7.43225,37.66891,-1.22151),(-7.46091,37.66712,-1.16953),(-7.42325,37.6457,-1.1646),(-7.58341,37.66834,-1.19899),(-7.59239,37.61326,-1.17667),(-7.56582,37.67058,-1.19278),(-7.56783,37.6086,-1.17616),(-7.48069,37.67713,-1.16264),(-7.48024,37.62423,-1.13508),(-7.48302,37.7719,-1.20802),(-7.49195,37.67977,-1.16249),(-7.51312,37.78278,-1.21906),(-6.95564,37.78376,-1.30231),(-7.11321,37.76995,-1.37445),(-6.98953,37.67431,-1.39713),(-7.27688,37.80985,-1.34986),(-7.29149,37.92756,-1.32936),(-7.33257,37.85118,-1.30368),(-7.33579,38.03992,-1.264),(-7.35318,37.83901,-1.28257),(-7.40817,37.83427,-1.25709),(-7.39353,38.06021,-1.24527),(-7.65787,37.81465,-1.30254),(-7.70676,37.70367,-1.25563),(-7.59834,37.82042,-1.25016),(-7.64497,37.66839,-1.21557),(-7.5629,37.80755,-1.22952),(-7.45875,42.87302,-1.32654),(-7.41375,42.86201,-1.49119),(-7.44186,41.89093,-1.50733),(-6.77072,40.70023,-1.42097),(-6.73123,41.80698,-1.2851),(-6.87394,41.79499,-1.18647),(-8.09036,37.59383,-.96379),(-8.0676,37.56403,-.91995),(-8.05002,37.61856,-.96087),(-7.90211,37.72917,-1.23615),(-7.95515,37.71957,-1.16432),(-7.91822,37.72916,-1.16143),(-6.73823,49.24988,-.29359),(-6.7652,49.11062,-.28103),(-6.77725,49.10752,-.24538),(-6.80257,48.92218,-.24839),(-6.66799,49.46774,-.36569),(-6.71138,49.40003,-.36958),(-6.62578,49.44117,-.3328),(-6.90225,49.14591,-1.67788),(-6.91274,49.09912,-1.62892),(-6.98109,49.29105,-1.54403),(-6.114,48.42898,-1.66711),(-6.24895,48.38095,-1.67201),(-6.36934,48.60668,-1.84119),(-5.92809,48.33841,-1.39228),(-5.85303,48.35445,-1.05594),(-6.01139,48.27978,-1.29509),(-6.10998,48.4224,-.71531),(-6.06652,48.55995,-.55916),(-6.26657,48.36071,-.50377),(-6.04148,49.16079,-.45927),(-6.23469,49.37483,-.38332),(-6.11772,49.00833,-.33863),(-6.65608,41.8172,-1.39583),(-6.68286,40.69256,-1.53362),(-6.71733,41.83492,-1.68246),(-7.18011,40.70153,-1.19783),(-7.13077,40.69483,-1.17931),(-7.13401,41.80881,-1.08653),(-6.88038,37.59324,-1.22589),(-6.92206,37.55646,-1.24371),(-6.8507,37.53043,-1.17819),(-6.92737,49.5468,-.81754),(-7.02009,49.54969,-.8083),(-7.01602,49.5513,-.76381),(-7.06216,49.51601,-.79391),(-7.16468,49.28961,-.74064),(-7.05079,49.51971,-.75063),(-6.71235,45.18973,-1.66015),(-6.6976,46.26335,-1.60663),(-6.60623,46.26836,-1.53089),(-6.04909,48.28688,-1.40779),(-6.33121,47.64569,-1.34299),(-6.28271,47.693,-1.23702),(-6.29413,47.64648,-1.23974),(-6.42284,47.65121,-1.46289),(-6.51517,47.66792,-1.53906),(-6.50378,47.71474,-1.54139),(-6.77724,48.64913,-1.6418),(-6.45165,48.37562,-1.7157),(-6.49422,48.26073,-1.65535),(-6.4885,48.49458,-1.74161),(-6.38496,47.73351,-.75002),(-6.32906,47.68344,-.96205),(-6.30689,47.79631,-.93324),(-6.11427,48.22533,-1.03705),(-5.99635,48.30434,-1.05739),(-6.24417,47.8197,-1.25361),(-6.25508,47.82063,-1.09146),(-6.87089,49.35737,-.40077),(-6.86819,49.14863,-.38166),(-6.81658,49.31099,-.39919),(-6.82238,49.45415,-.48901),(-6.82904,49.40506,-.43771),(-6.74103,49.41925,-.38312),(-6.89939,49.487,-.58992),(-6.87828,49.4189,-.44257),(-6.60511,49.34273,-.33775),(-6.65974,49.3727,-.35365),(-6.67553,49.35135,-.3424),(-6.7095,49.32297,-.33611),(-6.69775,49.34739,-.34778),(-6.73498,49.32983,-.36396),(-6.7167,49.33923,-.35859),(-6.72866,49.24114,-.27061),(-6.68672,49.21889,-.2497),(-6.64076,49.30888,-.30426),(-6.74049,49.25465,-.36009),(-6.75787,49.2576,-.37245),(-6.85038,49.5486,-.61069),(-6.92525,49.57444,-.8084),(-6.17037,48.97409,-.3178),(-6.05685,48.72468,-.44472),(-6.03812,48.73945,-.44542),(-6.16309,48.97903,-.31996),(-6.20537,48.95415,-.33582),(-6.3327,49.23424,-.29823),(-6.34868,49.2155,-.30408),(-7.01265,49.41302,-1.42937),(-7.01748,49.39109,-1.4169),(-6.98931,49.52233,-1.05658),(-6.99461,49.55999,-1.07502),(-6.34008,48.64999,-1.87966),(-6.35451,48.62935,-1.86459),(-6.63337,48.91552,-1.89558),(-6.64461,48.89636,-1.87055),(-5.87724,48.48313,-.75369),(-5.89637,48.47178,-.74681),(-5.79734,48.37112,-1.06404),(-5.82363,48.36086,-1.06022),(-5.9169,48.46196,-.73511),(-5.96585,48.57502,-.57921),(-5.99231,48.57094,-.5759),(-6.09786,48.70128,-.4531),(-6.555,45.11221,-1.16946),(-6.60572,43.95285,-1.25118),(-6.60427,43.95601,-1.29101),(-6.68857,41.80871,-1.29836),(-6.76713,39.51747,-1.7047),(-6.66347,38.80121,-1.71118),(-6.67766,38.79673,-1.76372),(-6.47615,38.06884,-1.81011),(-6.52885,38.05551,-1.82796),(-6.56016,38.23921,-1.78873),(-7.25178,47.27617,-.71516),(-7.26384,46.25867,-.76672),(-7.23777,46.25168,-.73359),(-7.15557,42.88829,-.96561),(-7.20082,42.88547,-.95123),(-7.21266,41.82134,-1.10189),(-7.22027,40.71609,-1.22101),(-7.14863,39.55246,-1.24083),(-7.10904,38.81955,-1.25205),(-7.04264,38.8113,-1.27681),(-7.9539,38.64758,-1.69375),(-8.0283,38.65968,-1.76683),(-8.07668,38.53226,-1.72681),(-8.31909,37.53659,-1.37161),(-8.30935,37.38673,-1.34594),(-8.06123,37.44016,-1.71688),(-8.18298,37.66312,-1.64932),(-8.07175,37.59886,-1.79779),(-8.29702,37.75351,-1.46529),(-8.28703,37.74145,-1.53213),(-8.31753,37.66862,-1.42801),(-8.28602,37.76237,-1.41328),(-8.29727,37.6805,-1.37904),(-8.10299,38.20508,-1.91111),(-8.01691,38.33542,-1.93968),(-8.07797,38.15985,-1.91546),(-8.17796,38.23315,-1.80272),(-8.17572,38.20228,-1.7246),(-8.12947,38.36841,-1.75881),(-8.03707,38.40857,-1.91808),(-8.0923,38.29259,-1.90471),(-8.09933,38.42318,-1.83371),(-8.14185,38.31244,-1.83349),(-8.18702,38.04225,-1.77378),(-8.18583,38.14342,-1.81182),(-8.15795,38.27744,-1.64677),(-8.1792,37.95738,-1.74514),(-8.23269,38.0072,-1.54603),(-6.59135,38.35014,-1.78652),(-6.55639,38.34911,-1.7598),(-6.51092,38.24073,-1.76299),(-7.70715,38.33724,-1.98854),(-7.62998,38.33346,-1.95799),(-7.73388,38.19339,-1.9779),(-7.69017,38.35558,-1.43611),(-7.11574,37.7357,-1.47853),(-7.14739,37.65794,-1.43779),(-7.16776,37.72153,-1.47053),(-7.06757,37.66443,-1.45996),(-7.06609,37.77539,-1.50195),(-7.18619,37.78206,-1.50109),(-7.14099,37.83061,-1.54658),(-7.10551,37.80874,-1.52951),(-7.2328,37.83693,-1.55432),(-7.18238,37.84541,-1.55864),(-7.25913,37.7704,-1.50847),(-7.26692,37.81566,-1.53844),(-7.20476,37.7273,-1.47609),(-7.23875,37.74498,-1.48987),(-7.01819,37.68408,-1.47742),(-7.01982,37.82174,-1.57971),(-6.95088,37.73942,-1.53975),(-7.28184,37.87915,-1.6296),(-7.19283,37.9118,-1.61885),(-7.33542,37.75487,-1.51965),(-7.3554,37.81992,-1.62184),(-7.28076,37.68938,-1.46684),(-7.30577,37.71924,-1.49092),(-7.00915,38.07598,-1.78983),(-6.81374,38.25748,-1.85571),(-6.84645,38.0616,-1.84942),(-7.47639,37.83289,-1.72923),(-7.46217,37.93678,-1.86948),(-7.34307,38.00302,-1.80322),(-7.32915,37.91984,-1.70373),(-7.46663,37.51958,-1.64369),(-7.46973,37.35926,-1.70423),(-7.54704,37.43565,-1.77068),(-7.63479,37.46505,-1.8564),(-7.62958,37.5554,-1.88219),(-7.58731,37.50529,-1.80538),(-7.48692,37.60801,-1.64296),(-7.40497,37.6554,-1.53944),(-7.43894,37.58088,-1.59833),(-7.50985,37.77548,-1.71028),(-7.44954,37.71759,-1.57421),(-7.53087,37.71341,-1.70165),(-7.71811,37.51076,-1.92996),(-7.50704,37.59371,-1.67042),(-7.53728,37.64419,-1.70476),(-7.16253,39.51011,-1.9466),(-6.8441,38.80103,-1.90489),(-7.15912,38.82006,-1.91489),(-6.87245,38.80427,-1.37916),(-6.72045,38.60255,-1.51608),(-6.75829,38.79768,-1.53426),(-6.851,38.60335,-1.40469),(-7.93612,38.86728,-1.76818),(-8.00105,38.64526,-1.84745),(-7.92967,38.86212,-1.8444),(-7.11237,38.60661,-1.90099),(-7.18384,38.60475,-1.90715),(-6.28588,37.63103,-1.52269),(-6.32089,37.69102,-1.51786),(-6.32452,37.64226,-1.4852),(-6.68233,38.58913,-1.82374),(-7.29952,38.17495,-1.25621),(-7.34679,38.23922,-1.26111),(-7.19346,38.07106,-1.31073),(-7.28262,38.12707,-1.26927),(-7.49414,39.60172,-1.54931),(-7.44239,40.72896,-1.55153),(-7.61498,39.61135,-1.69437),(-7.44573,43.98182,-1.02347),(-7.44883,43.98577,-1.09237),(-7.35197,42.88125,-1.03122),(-7.36343,47.29469,-.89772),(-7.32462,46.27354,-.95787),(-7.26372,46.28982,-1.54707),(-7.18474,46.28153,-1.59733),(-7.23929,45.17547,-1.66241),(-6.92788,46.21043,-.75394),(-6.89615,45.11292,-.87625),(-6.82303,46.2089,-.7935),(-7.30509,46.29001,-1.43661),(-7.33904,45.18325,-1.53973),(-7.05904,46.26834,-1.67733),(-7.04746,45.15497,-1.74038),(-7.09807,49.22678,-1.47096),(-7.08226,49.18996,-1.53634),(-7.24088,49.05898,-1.54058),(-7.0712,49.32398,-1.35844),(-6.99238,49.5012,-.99818),(-7.02847,49.37062,-1.40714),(-6.99637,49.2567,-1.52459),(-7.04816,49.25547,-1.4939),(-6.73223,48.79162,-1.70124),(-6.67673,48.82124,-1.74949),(-6.40801,48.49487,-1.78238),(-7.02931,49.43695,-1.11589),(-6.87527,48.51923,-1.6392),(-6.96081,48.44226,-1.62481),(-7.01594,48.71899,-1.64285),(-6.50631,46.26743,-1.24854),(-6.56341,45.1451,-1.4258),(-6.49886,46.27889,-1.3128),(-6.60697,48.64659,-1.73516),(-8.1405,38.128,-1.87764),(-8.1118,38.03212,-1.89527),(-6.49123,47.31977,-.73627),(-6.42717,47.73388,-.66415),(-6.45294,47.73122,-.61542),(-6.47026,47.31897,-.76023),(-6.61061,45.10514,-1.06407),(-6.54269,46.2115,-.93483),(-6.5825,46.20539,-.88425),(-6.35163,47.95393,-.68769),(-6.25251,48.0527,-.86515),(-6.27437,48.2692,-.53559),(-6.8192,47.31627,-.63896),(-6.89487,47.31995,-.64912),(-6.59959,47.31619,-.67734),(-6.64593,46.20631,-.86032),(-6.71276,47.31606,-.65759),(-6.47809,47.72944,-.59609),(-6.55357,47.73529,-.57887),(-6.51605,47.32156,-.71589),(-7.30916,48.62515,-1.53441),(-7.3169,48.3886,-1.44111),(-7.36911,48.68452,-1.39438),(-7.38061,48.20952,-1.24143),(-7.39077,48.4518,-1.32176),(-7.23487,48.6263,-1.59863),(-7.2483,48.69317,-1.59628),(-7.09226,48.75629,-1.63792),(-7.32425,48.69937,-1.53036),(-7.3603,48.74771,-1.42486),(-7.3297,48.77175,-1.52813),(-7.23077,49.13129,-1.16466),(-7.29872,49.01165,-1.22529),(-7.24174,49.1152,-1.05903),(-7.27893,47.29504,-1.34214),(-7.17503,47.30081,-1.45711),(-6.92859,48.85114,-1.64406),(-6.41811,48.31238,-.28358),(-6.43367,48.47471,-.20799),(-6.49483,48.4767,-.19433),(-6.25645,48.49438,-.45061),(-6.83316,48.79295,-.34544),(-6.86674,48.81877,-.3846),(-6.85611,48.5847,-.36741),(-7.22043,48.73136,-.52131),(-7.17845,48.93934,-.48031),(-7.33991,48.74621,-.71724),(-7.27533,48.94348,-.696),(-7.37259,48.82117,-1.27885),(-7.36007,48.81851,-1.22561),(-7.31848,48.95985,-1.19887),(-7.25513,48.86863,-1.57419),(-7.09274,49.10562,-1.62209),(-6.99356,48.8984,-1.62929),(-6.89903,49.00746,-.40048),(-6.95783,49.047,-.37998),(-6.94312,48.86946,-.41621),(-6.25839,49.64576,-1.50458),(-6.23302,49.6178,-1.54529),(-6.4174,49.64977,-1.57866),(-6.37512,49.57998,-1.64871),(-6.6265,49.5273,-.35961),(-6.59724,49.50661,-.34495),(-6.52006,49.59997,-.45275),(-6.54542,49.32162,-.31414),(-6.59917,49.26368,-.26738),(-6.54345,49.23881,-.26251),(-6.14046,49.6895,-1.17396),(-6.22198,49.74773,-1.002),(-6.19276,49.72548,-.99471),(-7.14677,49.31442,-1.10487),(-7.07813,49.46899,-.93697),(-7.03786,49.47717,-.98336),(-6.82823,48.39772,-.32322),(-6.83155,48.56505,-.25457),(-6.83155,48.5729,-.27338),(-6.82856,48.57757,-.28611),(-6.81833,48.92236,-.21743),(-6.32819,48.23289,-.4643),(-6.30987,48.34009,-.4076),(-6.32735,48.73427,-.26953),(-6.32102,48.6405,-.28725),(-6.24634,48.62805,-.39746),(-6.4634,48.19493,-.353),(-6.42417,48.18707,-.35962),(-6.67881,48.68951,-.14165),(-6.78412,48.90447,-.11682),(-6.81112,48.71726,-.13987),(-6.40243,48.76705,-.18265),(-6.40712,48.88918,-.18154),(-6.59433,48.86126,-.094),(-6.4878,48.80684,-.12438),(-6.46599,48.93879,-.14466),(-6.58643,49.01764,-.13605),(-6.93293,49.2002,-.38683),(-6.81289,48.29657,-.34887),(-6.86223,47.9408,-.54993),(-6.7804,47.90633,-.51235),(-6.85825,48.36131,-.3703),(-6.37021,49.17639,-.31811),(-6.44558,49.04477,-.1983),(-6.40142,48.98019,-.21719),(-6.8413,49.60445,-.61124),(-6.67901,49.55734,-.39545),(-6.83034,49.64968,-.61792),(-6.70118,49.51793,-.38142),(-6.45878,49.40689,-.29),(-6.3263,49.24088,-.2998),(-6.30579,49.26654,-.29936),(-6.46713,49.37357,-.28231),(-6.99529,49.59272,-1.08832),(-6.92327,49.63419,-.80442),(-6.90932,49.66907,-.81647),(-6.98067,49.61988,-1.11993),(-6.60362,48.94938,-1.9125),(-6.31045,48.70751,-1.88823),(-6.48705,49.27384,-.30059),(-6.47471,49.23597,-.28991),(-6.84291,37.43483,-1.03625),(-6.8201,37.39913,-.99447),(-6.73852,37.42273,-1.00924),(-6.97971,37.45269,-1.16218),(-6.92184,37.4572,-1.14227),(-6.94045,37.47914,-1.16586),(-7.13342,37.72547,-1.38786),(-7.03456,37.63403,-1.3882),(-6.96307,37.66246,-1.40042),(-6.9434,37.64265,-1.35715),(-6.92076,37.72837,-1.33386),(-6.78384,37.48093,-1.12545),(-6.81352,37.46433,-1.12844),(-6.77666,37.46701,-1.11967),(-6.81736,37.48605,-1.13412),(-6.87282,37.4608,-1.12954),(-7.23898,37.52095,-1.1755),(-7.28749,37.55573,-1.15849),(-7.23738,37.5171,-1.16545),(-7.2869,37.5484,-1.15038),(-6.9069,37.45392,-1.10195),(-6.86413,37.46193,-1.08681),(-6.91501,37.45854,-1.12414),(-6.86714,37.4621,-1.10765),(-6.79846,37.4666,-1.09863),(-6.78771,37.46109,-1.07682),(-6.71087,37.43183,-1.02908),(-6.63841,37.38707,-1.09635),(-6.74747,37.46375,-1.0741),(-7.18981,37.48672,-1.19102),(-7.19405,37.49003,-1.20608),(-7.27923,37.51326,-1.1327),(-7.25439,37.51175,-1.14529),(-7.16005,37.47183,-1.17833),(-7.19218,37.48044,-1.17879),(-7.16522,37.46626,-1.20527),(-7.02296,37.40796,-1.10672),(-7.03067,37.44745,-1.15247),(-7.09741,37.45042,-1.16499),(-7.09307,37.39892,-1.12807),(-7.19491,37.79857,-1.37224),(-7.20491,37.99337,-1.3371),(-7.26819,37.57252,-1.3254),(-7.26087,37.57989,-1.38753),(-7.35136,37.62193,-1.30098),(-7.34447,37.64423,-1.31157),(-7.38945,37.65624,-1.28079),(-6.8554,37.79759,-1.25876),(-6.92242,37.87414,-1.26532),(-6.87464,37.79188,-1.2692),(-6.90023,37.88716,-1.26064),(-7.17389,37.82345,-1.36807),(-7.1409,37.80143,-1.37317),(-7.15346,37.76683,-1.37931),(-7.18584,37.72087,-1.38688),(-7.30507,37.66775,-1.33275),(-7.6874,36.9198,-1.56977),(-7.69873,36.92635,-1.56824),(-7.70394,36.99297,-1.62792),(-7.6787,36.85769,-1.48764),(-7.65805,36.85549,-1.49174),(-7.62959,36.832,-1.42655),(-7.65723,36.8396,-1.41759),(-7.67798,37.12036,-1.765),(-7.66728,37.17908,-1.79727),(-7.63968,37.12775,-1.74821),(-7.71968,37.67449,-1.23726),(-7.71728,37.68264,-1.22131),(-7.65862,37.63617,-1.20427),(-7.72666,36.946,-1.11588),(-7.71266,36.9918,-1.05296),(-7.72403,36.99379,-1.03962),(-7.89877,37.71769,-1.25522),(-7.86169,37.72939,-1.26663),(-7.77492,37.74235,-1.28007),(-7.70849,37.82625,-1.33139),(-7.93468,37.70895,-1.24228),(-8.15048,37.50216,-.99745),(-8.13422,37.51079,-.94815),(-8.13376,37.56287,-1.01686),(-8.13061,37.40326,-.87801),(-8.12115,37.47953,-.90409),(-8.17452,37.385,-.90839),(-8.17977,37.40996,-1.04013),(-8.17097,37.43722,-.97464),(-8.17257,37.46585,-1.0585),(-8.18163,37.3914,-.99449),(-8.15663,37.45521,-.93351),(-8.02918,36.86392,-1.21263),(-7.93912,36.87292,-1.35433),(-8.00441,36.85719,-1.21776),(-8.13502,37.57944,-1.10273),(-8.08045,37.63241,-1.14051),(-8.1135,37.63495,-1.22977),(-8.0636,37.6563,-1.10621),(-8.03753,37.67935,-1.08022),(-7.98792,37.69663,-1.17465),(-8.00373,37.69275,-1.07042),(-7.97907,37.70132,-1.06927),(-7.93988,37.95354,-1.4103),(-8.14782,37.75272,-1.30254),(-8.09701,37.9887,-1.44874),(-8.1975,37.52581,-1.25446),(-6.7328,37.73913,-1.68356),(-6.73812,37.68776,-1.63569),(-6.9369,37.83373,-1.6289),(-6.84255,37.70355,-1.57769),(-6.73683,37.66768,-1.61563),(-7.33107,37.62146,-1.46053),(-7.32689,37.63519,-1.45959),(-7.24813,37.58731,-1.42877),(-7.2432,37.60443,-1.43451),(-7.13086,37.54766,-1.44172),(-7.12828,37.57342,-1.41264),(-7.00563,37.58246,-1.4473),(-7.009,37.5556,-1.4692),(-6.93115,37.58451,-1.49757),(-6.92999,37.61494,-1.47365),(-6.89881,37.28883,-1.78124),(-6.91978,37.40084,-1.64498),(-6.85448,37.32027,-1.81076),(-6.73719,37.79869,-1.75416),(-6.65921,37.82256,-1.85731),(-6.63891,37.73047,-1.83247),(-6.74604,37.85092,-1.82872),(-6.60705,37.52608,-1.81001),(-6.61104,37.56964,-1.81012),(-6.51074,37.54257,-1.84342),(-6.62272,37.52716,-1.80116),(-6.62343,37.5756,-1.79712),(-6.70222,37.37246,-.97006),(-6.40646,37.95188,-1.82692),(-6.45033,38.0029,-1.81732),(-6.41376,38.027,-1.7962),(-6.77622,37.30248,-1.80473),(-6.66962,37.44781,-1.80172),(-6.61618,37.36818,-1.8329),(-7.09574,37.92542,-1.30644),(-6.98115,37.86314,-1.28959),(-6.9718,37.96148,-1.26667),(-6.41927,37.86984,-1.85086),(-6.35194,37.87648,-1.83612),(-6.85078,37.968,-1.80789),(-6.71791,37.97186,-1.85894),(-6.68821,37.89721,-1.85812),(-6.65687,38.04273,-1.36307),(-6.64676,37.96119,-1.34121),(-6.62486,37.9619,-1.35739),(-6.08211,37.23969,-1.7904),(-6.08907,37.29982,-1.83723),(-6.06804,37.30112,-1.81785),(-6.10021,37.23682,-1.81526),(-6.13086,37.11028,-1.73931),(-6.14609,37.11093,-1.75304),(-6.12066,37.1693,-1.7838),(-6.1044,37.17027,-1.76283),(-6.22451,37.79544,-1.80415),(-6.15912,37.71593,-1.8258),(-6.23722,37.79216,-1.83363),(-6.16194,37.69724,-1.84758),(-6.18073,37.14289,-1.51612),(-6.13734,37.16523,-1.59215),(-6.13838,37.2394,-1.58603),(-6.10229,37.18641,-1.66045),(-6.06651,37.24515,-1.71145),(-6.09353,37.24412,-1.6437),(-6.09544,37.18145,-1.70337),(-6.36827,36.9925,-1.57942),(-6.31595,36.9926,-1.61484),(-6.31028,36.99769,-1.59642),(-6.21543,37.00609,-1.62394),(-6.2539,36.98618,-1.58443),(-6.26243,37.00195,-1.61035),(-6.26667,37.21867,-1.42283),(-6.22614,37.33845,-1.43371),(-6.26981,37.33144,-1.40172),(-6.22733,37.23131,-1.4626),(-6.31304,37.20559,-1.38687),(-6.26114,37.18695,-1.41897),(-6.3236,37.03446,-1.45259),(-6.26787,37.10376,-1.44963),(-6.31984,37.09101,-1.42828),(-6.27446,37.06852,-1.47186),(-6.29841,37.71607,-1.87452),(-6.35961,37.79441,-1.86239),(-6.28537,37.80704,-1.84665),(-6.36521,37.71107,-1.87708),(-6.37885,37.23564,-1.84858),(-6.30355,37.12411,-1.77635),(-6.36554,37.13515,-1.78589),(-6.31704,37.22081,-1.84803),(-6.42692,37.787,-1.87318),(-6.43133,37.70793,-1.8724),(-6.29418,37.0748,-1.72756),(-6.24418,37.12227,-1.77529),(-6.23931,37.07833,-1.74436),(-6.23502,37.03211,-1.70839),(-6.28458,37.02998,-1.6895),(-6.28921,37.04393,-1.70424),(-6.8062,37.56566,-1.15949),(-6.72356,37.64789,-1.18825),(-6.82251,37.63917,-1.19043),(-6.85186,37.63166,-1.18943),(-6.62717,37.79811,-1.29748),(-6.63259,37.66109,-1.23044),(-6.61362,37.66342,-1.26511),(-6.66054,37.52768,-1.14523),(-6.11923,37.138,-1.67941),(-6.14482,37.13882,-1.60799),(-6.16067,37.07605,-1.64676),(-6.15109,37.07641,-1.70657),(-6.22747,37.00466,-1.66602),(-6.15699,37.07621,-1.71715),(-6.15802,37.71759,-1.79409),(-6.20109,37.72289,-1.86048),(-6.15967,37.61729,-1.87493),(-6.21374,37.61844,-1.88335),(-6.20667,37.0805,-1.74029),(-6.17713,37.07876,-1.73065),(-6.51695,37.71721,-1.85595),(-6.51599,37.67596,-1.85719),(-6.17434,37.45141,-1.45411),(-6.16344,37.56271,-1.54449),(-6.20368,37.54118,-1.50469),(-6.1271,37.4735,-1.51607),(-6.61493,37.28193,-1.82805),(-6.63126,37.18889,-1.78356),(-6.67556,37.16888,-1.76633),(-6.16427,37.18015,-1.80706),(-6.19411,37.24837,-1.85372),(-6.14778,37.24516,-1.83865),(-6.1969,37.1916,-1.81411),(-6.19074,37.11385,-1.76588),(-6.7527,37.21282,-1.80889),(-6.72184,37.23395,-1.80186),(-6.71922,37.04078,-1.7597),(-6.73702,37.12661,-1.78038),(-8.30932,37.36035,-1.33596),(-7.46708,37.14638,-1.6767),(-7.46652,37.21112,-1.6778),(-7.75381,37.12113,-1.7534),(-7.69264,37.17736,-1.79696),(-7.46904,37.28276,-1.67185),(-7.6761,37.24298,-1.83666),(-6.84639,37.20414,-1.84871),(-6.89163,37.185,-1.79863),(-8.11015,37.57215,-.97168),(-8.15336,37.52264,-1.08062),(-7.16793,37.47039,-1.22808),(-7.14465,37.47012,-1.23246),(-7.18124,37.54312,-1.34488),(-7.13501,37.4521,-1.21263),(-7.60105,37.53204,-1.14532),(-7.62253,37.5472,-1.12169),(-8.03636,37.6595,-.99676),(-8.08588,37.63516,-1.00302),(-7.95963,36.93187,-1.00245),(-7.9409,36.8769,-1.10783),(-7.93073,36.93244,-1.00202),(-7.12194,37.40169,-1.58178),(-7.148,37.40683,-1.57861),(-7.6832,36.99567,-1.07391),(-7.67103,37.05787,-1.03655),(-7.69791,37.055,-1.00791),(-7.7519,36.89926,-1.25224),(-7.71767,36.89509,-1.25743),(-7.71066,36.90473,-1.19974),(-7.74333,36.90208,-1.18975),(-7.73741,36.88632,-1.50261),(-7.72652,36.944,-1.56983),(-7.71711,36.87504,-1.49767),(-7.72587,37.00283,-1.63021),(-7.75543,37.00148,-1.63314),(-6.68239,37.04521,-1.68737),(-6.64383,37.04184,-1.59888),(-6.67691,37.00171,-1.62883),(-6.64455,37.07984,-1.66736),(-7.6736,36.98119,-1.63178),(-7.67972,37.06936,-1.71199),(-6.69151,37.07756,-1.72559),(-6.64471,37.10825,-1.71856),(-7.60008,36.8202,-1.36603),(-7.58914,36.82275,-1.40803),(-7.55723,36.81879,-1.34707),(-7.65086,36.90705,-1.57082),(-7.62003,36.84234,-1.48003),(-7.91228,36.87604,-1.34449),(-7.84264,36.89152,-1.40997),(-7.86461,36.88454,-1.4036),(-6.57838,37.2883,-1.22185),(-6.6125,37.29333,-1.10699),(-6.5824,37.39405,-1.20036),(-6.58407,37.11742,-1.26334),(-6.57815,37.252,-1.22895),(-6.57925,37.10338,-1.13572),(-6.59745,37.22079,-1.11705),(-6.66037,36.8331,-1.43635),(-6.6545,36.92962,-1.46881),(-6.63759,36.91618,-1.43646),(-6.66797,36.82618,-1.50422),(-6.66954,36.83051,-1.54011),(-6.66493,36.93264,-1.52083),(-6.59158,37.06037,-.94377),(-6.62242,37.18291,-.93892),(-6.66883,37.07095,-.91716),(-6.57748,36.67456,-1.23916),(-6.59486,36.64782,-1.2964),(-6.64292,36.86835,-1.35523),(-7.28035,36.93491,-1.13572),(-7.31376,36.89458,-1.20657),(-7.29396,36.89609,-1.20833),(-8.10929,36.98996,-1.20688),(-8.12669,36.96171,-1.07356),(-8.09251,36.91647,-1.15242),(-6.67737,36.73696,-1.08874),(-6.57782,36.75649,-1.10298),(-6.66861,36.78497,-1.04553),(-8.04672,37.00643,-.93947),(-8.04696,37.09337,-.87929),(-8.06785,37.09308,-.88752),(-7.71695,37.05471,-.98071),(-7.04304,37.386,-1.59145),(-7.15459,37.27411,-1.63921),(-7.06971,37.26707,-1.67214),(-6.61355,37.45371,-1.82643),(-6.51124,37.31149,-1.85183),(-6.53509,37.30499,-1.84642),(-6.51344,37.39341,-1.86318),(-8.20038,37.21674,-.92527),(-8.20258,37.2856,-.93022),(-6.63783,37.30801,-.97405),(-6.59793,37.19387,-.96296),(-6.78305,37.31323,-.96725),(-6.72673,37.19314,-.93162),(-6.66507,37.29851,-.95071),(-6.76667,37.05942,-.93191),(-6.82149,37.18317,-.96546),(-6.55176,37.1596,-1.34753),(-6.52048,37.28997,-1.31231),(-6.18124,37.34744,-1.47762),(-6.19211,37.24635,-1.51396),(-6.75404,36.87175,-.97895),(-6.64658,36.94943,-.93537),(-6.75181,36.97178,-.93673),(-6.65709,36.84937,-.99268),(-6.83461,37.55331,-1.15772),(-6.89722,37.04733,-.98309),(-6.58905,37.05464,-1.17235),(-6.54991,36.95059,-1.00733),(-6.56976,37.07279,-.96851),(-6.20929,37.01354,-1.59973),(-6.60262,36.96796,-1.4386),(-6.59384,36.97744,-1.42072),(-6.62958,36.93239,-1.39914),(-6.61695,36.96366,-1.35813),(-6.86775,49.52557,-.60313),(-6.17005,48.33516,-1.58986),(-6.39418,48.64954,-.17918),(-7.28069,48.19168,-1.41213),(-7.37461,48.77424,-1.31338),(-7.39811,48.63956,-1.2313),(-7.13345,49.32934,-1.19844),(-7.01751,49.48273,-1.01428),(-7.17393,49.31108,-1.02976),(-7.41779,48.20297,-1.08425),(-7.4057,48.60583,-1.08293),(-7.1133,49.45211,-.88423),(-7.19104,49.31266,-.94612),(-7.08968,49.24821,-.48961),(-7.0689,49.34313,-.50013),(-6.9883,49.39442,-.44613),(-7.01274,49.45717,-.52981),(-6.9244,49.42225,-.44271),(-6.96882,49.48658,-.54408),(-6.80094,49.28147,-.38355),(-7.06888,48.4667,-.4894),(-6.992,48.66547,-.45108),(-7.03071,48.68699,-.42114),(-6.90409,48.39784,-.43422),(-6.09985,49.65006,-1.16909),(-6.09034,49.6071,-1.35968),(-6.42197,49.52089,-.40702),(-6.49587,49.43186,-.30226),(-6.05947,49.61065,-1.16426),(-6.02105,49.57131,-1.18945),(-5.90491,49.45545,-1.09438),(-5.88276,49.41863,-1.13853),(-5.98263,49.53197,-1.21463),(-5.94942,49.49695,-1.25975),(-5.94793,49.46346,-1.31445),(-5.86444,49.29993,-1.39791),(-5.95323,49.46162,-1.37932),(-5.8385,49.32798,-1.28753),(-5.98525,49.46066,-1.43879),(-6.08436,49.50481,-1.53934),(-6.16351,49.55161,-1.55966),(-6.99194,49.472,-1.45309),(-6.90996,49.58943,-1.49585),(-6.95029,49.37596,-1.594),(-6.83261,49.48236,-1.62231),(-6.28178,49.71772,-1.36445),(-6.28376,49.67371,-1.46386),(-6.9279,49.72752,-1.17519),(-6.83732,49.7843,-1.22327),(-6.79706,49.64234,-1.51994),(-6.84116,49.75776,-.87558),(-6.18235,49.70967,-1.20525),(-6.22742,49.73412,-1.26787),(-6.34665,48.22657,-1.61942),(-6.47145,47.83562,-1.55231),(-6.59636,47.84608,-1.60373),(-7.26547,47.80435,-.67446),(-7.40506,47.79105,-.82544),(-7.15102,47.31735,-.65634),(-7.07663,47.80082,-.62973),(-7.16462,47.79919,-.63615),(-7.02983,47.32136,-.67133),(-6.29553,47.65261,-1.13207),(-6.3432,47.40851,-1.19469),(-7.0722,47.30418,-1.58723),(-7.22821,47.81445,-1.43974),(-7.09005,47.80949,-1.55737),(-7.13808,46.2302,-.70532),(-6.44394,47.31106,-.85233),(-6.53099,46.22949,-1.03574),(-7.34537,47.29112,-1.10713),(-7.33424,47.28892,-1.23633),(-7.35548,46.28916,-1.26595),(-7.36585,46.28447,-1.09987),(-7.10609,45.10607,-.77084),(-7.09146,46.22357,-.71075),(-6.79283,43.99664,-1.72165),(-6.9092,45.15469,-1.75002),(-6.88923,43.9979,-1.80621),(-7.40569,45.18686,-1.20095),(-7.45549,43.99423,-1.24006),(-6.84054,42.84453,-1.7889),(-6.93255,42.87493,-1.84165),(-7.30822,42.88574,-1.7017),(-7.4004,43.98809,-1.54256),(-7.30291,44.00948,-1.6784),(-7.44123,43.99748,-1.39315),(-7.27626,42.88304,-.97633),(-7.15963,41.89787,-1.92232),(-7.06678,42.89278,-1.8333),(-7.32316,41.88232,-1.74675),(-7.41142,41.88357,-1.3199),(-6.79872,40.68303,-1.78345),(-6.93377,41.85625,-1.87671),(-7.02229,40.72517,-2.00679),(-7.04195,41.88402,-1.939),(-7.22889,40.74259,-2.01113),(-7.48763,40.74846,-1.80231),(-7.39681,39.52938,-2.00068),(-6.66041,38.80102,-1.67858),(-6.76896,39.5254,-1.63669),(-6.68059,38.79917,-1.63489),(-7.38118,39.5811,-1.42592),(-7.29875,38.83314,-1.29291),(-7.26382,39.54396,-1.29106),(-7.45157,38.84903,-1.39982),(-7.16861,38.82471,-1.2603),(-7.20456,39.55018,-1.26047),(-6.837,39.48647,-1.85641),(-6.71303,38.79753,-1.82653),(-7.32622,38.83149,-1.92735),(-7.59329,38.84706,-2.01433),(-7.54223,39.57814,-2.0061),(-7.75981,38.85185,-1.99723),(-7.71055,39.63236,-1.80504),(-7.74822,38.86629,-1.63622),(-7.67211,39.24334,-1.6778),(-7.85659,38.86388,-1.70453),(-7.60174,38.8531,-1.50727),(-6.68031,38.35299,-1.82531),(-7.79271,38.35284,-1.99996),(-7.64824,38.62494,-2.00981),(-7.79787,38.63671,-1.6009),(-7.63677,38.63721,-1.48715),(-7.85951,38.36259,-1.51633),(-7.51064,38.2259,-1.32682),(-7.1781,38.25477,-1.27338),(-7.08338,37.60667,-1.38029),(-7.09247,38.11863,-1.27703),(-7.1836,38.17158,-1.29152),(-7.24042,37.61814,-1.38593),(-7.18105,37.60498,-1.37893),(-6.5862,38.25943,-1.51855),(-6.53042,38.07829,-1.51801),(-6.73527,38.25118,-1.39278),(-7.05216,38.16853,-1.26532),(-6.96152,38.24435,-1.25546),(-6.19405,37.07673,-1.55522),(-6.21815,37.16346,-1.46423),(-6.22119,37.12207,-1.4806),(-6.25205,37.72129,-1.61226),(-6.23241,37.63104,-1.55646),(-7.88383,38.22552,-1.47404),(-7.89702,37.92878,-1.4015),(-8.091,37.4153,-.85119),(-8.13998,37.30922,-.86043),(-8.09039,37.31611,-.83551),(-8.26403,37.31784,-1.23049),(-8.29551,37.28827,-1.30857),(-8.00921,37.68036,-1.19082),(-8.30429,37.54307,-1.3341),(-8.15389,37.03614,-1.00665),(-7.72816,37.91536,-1.99174),(-7.6519,37.74279,-1.93005),(-8.00833,37.0106,-1.51198),(-7.89298,37.01906,-1.57972),(-8.17628,37.06546,-1.4143),(-7.88304,37.08281,-1.62077),(-8.05068,37.11213,-1.54857),(-8.06093,37.17025,-1.59499),(-7.69622,37.362,-1.87867),(-8.19319,37.48578,-1.59293),(-8.0644,37.29849,-1.65258),(-8.21147,37.33718,-1.55156),(-7.8857,37.38789,-1.83511),(-7.88377,37.55745,-1.88914),(-7.88758,37.9324,-1.97549),(-6.65726,37.88892,-1.86085),(-6.51864,37.80105,-1.86691),(-6.40083,37.0737,-1.68736),(-6.34554,37.07329,-1.70947),(-6.34162,37.05678,-1.69749),(-6.6068,36.99073,-1.22816),(-6.55016,36.85749,-1.05976),(-6.64613,36.62327,-1.4788),(-6.67231,36.65486,-1.57404),(-6.67037,36.95344,-1.56388),(-6.64279,37.00865,-1.53905),(-6.76436,37.19818,-1.83807),(-6.80651,36.65387,-1.43015),(-6.79621,36.64726,-1.34539),(-6.95183,36.74064,-1.3309),(-6.95374,36.7559,-1.4044),(-7.4227,38.21947,-1.90996),(-7.4429,38.06079,-1.87108),(-7.5714,37.95526,-1.95193),(-6.89547,38.36803,-1.87032),(-7.11756,38.38869,-1.86814),(-7.42866,37.72652,-1.54215),(-7.40729,37.73343,-1.53882),(-7.593,37.69826,-1.86211),(-7.22846,37.28303,-1.64171),(-7.32011,37.28022,-1.65226),(-7.3211,37.30984,-1.66331),(-7.56533,37.41978,-1.79041),(-6.8377,37.43719,-1.70002),(-6.74863,37.43642,-1.73378),(-7.43296,37.49786,-1.62622),(-7.4008,37.55964,-1.56311),(-7.26281,37.54489,-1.48768),(-7.25073,37.56386,-1.45576),(-6.96383,37.27465,-1.73996),(-6.8022,37.30669,-1.80251),(-7.47184,37.1036,-1.66221),(-7.63826,37.0801,-1.70066),(-6.93565,37.62725,-1.47546),(-7.12016,38.27972,-1.85171),(-7.14285,38.07988,-1.7675),(-6.74858,38.04651,-1.85976),(-6.69177,37.75244,-1.80846),(-7.34308,38.3479,-1.90903),(-7.18412,38.38282,-1.87422),(-7.09107,37.3653,-1.10753),(-7.02371,37.28239,-1.07316),(-7.02395,37.37466,-1.08743),(-7.08777,37.28918,-1.08637),(-6.62328,36.97637,-1.49335),(-6.51968,37.88548,-1.85294),(-6.65366,38.02162,-1.86794),(-6.67933,38.23492,-1.8261),(-7.86014,38.21679,-1.99504),(-8.19349,37.15114,-1.45843),(-7.9673,36.85424,-1.2176),(-8.18977,37.37302,-.94993),(-6.67269,37.38023,-.99273),(-7.77376,37.00327,-.99505),(-7.85629,36.93764,-1.0229),(-7.78833,36.95419,-1.06339),(-7.83722,37.00413,-.95216),(-8.04593,38.26523,-1.56692),(-7.77936,37.06542,-1.68618),(-7.8059,37.00586,-1.6245),(-7.9447,37.68377,-1.00373),(-7.91753,37.71466,-1.07165),(-7.93325,37.71352,-1.07037),(-6.30821,37.53832,-1.44129),(-6.20485,37.64595,-1.57512),(-6.22225,37.44804,-1.41805),(-6.08786,37.29209,-1.63079),(-6.13479,37.26964,-1.57394),(-6.76463,37.46879,-1.09795),(-7.12734,37.59808,-1.37914),(-7.2624,37.69214,-1.37036),(-7.16719,38.61969,-1.26399),(-7.33415,38.36882,-1.27185),(-7.17446,38.37641,-1.27025),(-7.30889,38.62801,-1.29333),(-8.0563,38.51439,-1.83661),(-8.11919,38.40485,-1.68679),(-7.88465,38.49649,-1.98173),(-7.81394,38.63642,-1.99759),(-6.8402,38.59302,-1.90486),(-6.82175,38.35911,-1.8706),(-6.8289,39.52712,-1.49641),(-7.3622,40.71693,-1.35557),(-6.89306,40.71471,-1.26799),(-6.95723,39.5433,-1.35589),(-6.60091,43.97821,-1.52963),(-7.25619,43.95859,-.89043),(-7.14952,45.10842,-.76377),(-7.2842,45.12996,-.82081),(-7.1943,43.96178,-.87638),(-6.91203,47.79111,-1.60132),(-6.91236,48.21278,-1.5971),(-6.68369,48.24717,-1.63422),(-6.7492,49.72597,-.69123),(-6.30261,49.79737,-1.06589),(-6.39065,49.82199,-1.17837),(-5.88592,48.90947,-1.66257),(-5.88071,49.11155,-1.60262),(-5.72429,48.83079,-1.45905),(-5.77564,49.04961,-1.4383),(-5.86062,49.3818,-1.18267),(-7.1402,48.0423,-.5882),(-7.07728,48.02054,-.58617),(-7.02104,48.43598,-.47291),(-6.99634,48.90353,-.36365),(-6.98156,49.19481,-.40162),(-6.9791,49.32675,-.41234),(-7.12833,48.47609,-.5033),(-7.08926,48.69264,-.42789),(-7.26858,48.51808,-.56371),(-7.20737,49.09439,-.71866),(-7.13458,49.08075,-.47729),(-7.10754,49.34534,-1.28235),(-6.86397,48.85788,-1.66689),(-6.65258,48.87983,-1.83952),(-6.51606,48.64523,-1.785),(-6.82402,48.58373,-.30866),(-6.33547,48.85537,-.27473),(-6.30184,48.91419,-.36541),(-6.18436,48.12523,-.99469),(-6.75828,36.8542,-1.81556),(-6.81254,36.95877,-1.84851),(-6.77538,36.96758,-1.84868),(-6.79941,36.85452,-1.80862),(-6.5709,36.93359,-.98358),(-6.94066,36.79371,-1.16128),(-6.79132,36.69404,-1.1743),(-6.78431,36.74473,-1.09989),(-8.17881,37.12456,-.95648),(-7.76087,37.06083,-.94085),(-7.8279,37.072,-.90491),(-6.24637,36.99492,-1.55991),(-6.23624,37.06273,-1.52131),(-6.61262,36.98263,-1.34536),(-6.62406,36.92682,-1.28397),(-7.24583,36.91329,-1.40326),(-7.33285,36.92365,-1.45956),(-7.25011,36.94219,-1.45309),(-7.32786,36.90112,-1.39928),(-7.88624,36.87328,-1.33308),(-7.24124,36.9063,-1.36244),(-7.31823,36.88793,-1.36071),(-7.449,37.62078,-1.13112),(-6.7073,36.99078,-1.7251),(-6.6932,36.92866,-1.66715),(-7.76878,36.88611,-1.37258),(-7.7352,36.87845,-1.44498),(-7.73431,36.87575,-1.3856),(-7.77862,36.88473,-1.43683),(-7.6189,37.39268,-1.06244),(-7.6313,37.30932,-1.02831),(-7.58746,37.39852,-1.05073),(-7.59493,37.30967,-1.01896),(-7.17397,37.41373,-1.58078),(-8.10445,37.53793,-.93213),(-8.08363,37.49973,-.87542),(-7.9213,36.85538,-1.22111),(-7.88698,36.8857,-1.11794),(-7.57302,37.53749,-1.13372),(-7.04539,37.48691,-1.23971),(-7.01219,37.50105,-1.23736),(-7.06174,37.55217,-1.3446),(-7.27146,37.45988,-1.10773),(-7.22156,37.43966,-1.11603),(-7.66732,37.48904,-1.03575),(-7.63375,37.47921,-1.07762),(-7.65997,37.5586,-1.09143),(-8.12019,37.61075,-1.03574),(-7.3255,37.20713,-1.65453),(-7.33204,37.15265,-1.64403),(-8.05613,36.89407,-1.23174),(-6.06869,37.24699,-1.76073),(-6.09374,37.1733,-1.736),(-6.18431,37.2057,-1.5121),(-6.64583,37.64831,-1.80176),(-6.6217,37.63579,-1.81624),(-6.1038,37.61189,-1.85377),(-6.4335,37.62751,-1.87113),(-6.51306,37.631,-1.848),(-6.06722,37.52339,-1.85604),(-6.10778,37.52928,-1.87711),(-6.12017,37.1162,-1.72211),(-6.09247,37.62973,-1.80142),(-6.09422,37.61787,-1.83715),(-6.22543,37.10485,-1.49164),(-6.32748,37.4423,-1.36437),(-6.35741,37.55281,-1.39293),(-6.6363,37.52408,-1.1634),(-6.99738,37.58376,-1.34815),(-6.96694,37.52875,-1.24053),(-6.90149,37.50559,-1.16954),(-6.31965,37.24738,-1.86205),(-6.35586,37.11472,-1.7496),(-6.2792,37.04836,-1.48651),(-6.27473,37.44516,-1.38796),(-6.2556,37.53836,-1.47498),(-6.05888,37.30123,-1.69661),(-6.05311,37.30307,-1.73584),(-6.18116,37.65578,-1.60033),(-6.07803,37.37322,-1.60879),(-6.07527,37.40816,-1.59864),(-6.12631,37.36861,-1.53955),(-6.43965,38.07643,-1.79179),(-6.41599,38.07274,-1.75041),(-6.52508,38.34278,-1.69659),(-6.62787,38.59759,-1.72241),(-6.62597,38.5979,-1.67944),(-6.53066,38.34029,-1.72833),(-6.61099,37.95924,-1.3666),(-6.51426,37.98027,-1.47911),(-6.48954,37.97901,-1.503),(-6.36347,37.95005,-1.8065),(-6.65537,37.95527,-1.86439),(-6.52308,37.9703,-1.83976),(-6.36212,37.97949,-1.76355),(-6.36661,37.98561,-1.74201),(-6.30294,37.89253,-1.78124),(-6.25549,37.81454,-1.74302),(-6.30965,37.90185,-1.74106),(-6.32639,37.9025,-1.69116),(-6.37104,37.9933,-1.69986),(-6.23514,37.78056,-1.74328),(-7.38379,37.67315,-1.50547),(-7.36368,37.67998,-1.49571),(-7.18372,37.56358,-1.37943),(-7.74385,37.7237,-1.26881),(-8.06553,36.88793,-1.12149),(-8.037,36.87585,-1.12214),(-8.04209,37.56491,-.9104),(-8.02475,37.61586,-.95543),(-8.07658,37.41634,-.84625),(-7.71655,37.67818,-1.1794),(-7.71562,37.66525,-1.13964),(-7.15923,37.46306,-1.17125),(-7.20169,37.45254,-1.14137),(-7.16232,37.41152,-1.13355),(-7.13212,37.45471,-1.18791),(-7.1302,37.45436,-1.17023),(-6.48156,49.344,-.2869),(-5.93859,49.39563,-.72583),(-5.81916,49.24372,-.82902),(-5.98162,49.52628,-1.0477),(-5.75102,48.40524,-1.07848),(-5.87836,48.35802,-1.40382),(-5.8372,48.41458,-1.41932),(-6.76254,49.10735,-.29611),(-6.77793,49.11249,-.34909),(-6.81079,48.55256,-.21091),(-6.80993,48.39784,-.2989),(-6.81193,49.1187,-.37416),(-6.83431,48.96866,-.38095),(-6.50559,48.33699,-.29813),(-6.63392,48.69142,-.12321),(-6.3118,48.4782,-.34901),(-6.77443,49.10022,-.21481),(-6.67203,48.52357,-.21055),(-6.59849,48.50802,-.21031),(-6.65918,48.25536,-.35671),(-6.53223,47.85303,-.53632),(-6.66576,47.88154,-.52347),(-6.66484,48.8537,-.09397),(-6.63008,49.15359,-.19538),(-6.7571,49.08701,-.16226),(-6.65279,49.02714,-.13251),(-6.53542,49.46258,-.31576),(-7.02033,49.04941,-.38486),(-7.20424,48.06562,-.60313),(-6.95734,49.0429,-1.66006),(-7.36076,48.84934,-1.32811),(-7.29566,49.01551,-1.47618),(-7.32238,48.85032,-1.51456),(-6.88507,48.61021,-.41018),(-6.81889,48.76972,-.29439),(-6.53437,48.49606,-.19395),(-6.84583,48.74666,-.22557),(-6.82929,48.75743,-.24888),(-7.33993,47.82124,-1.2624),(-6.71863,47.28414,-1.60128),(-6.91323,46.26234,-1.68521),(-6.89795,47.29938,-1.61815),(-7.32043,48.95885,-1.08209),(-7.25856,48.78249,-1.59126),(-6.78255,47.758,-.55686),(-6.87561,47.77789,-.59878),(-7.36348,40.75175,-1.98021),(-7.62405,39.60504,-1.95902),(-7.95138,38.35656,-1.96586),(-7.99006,38.50286,-1.92266),(-6.90264,48.98626,-1.66724),(-7.17029,49.21317,-1.39806),(-6.65884,41.81431,-1.35661),(-7.29631,43.96071,-.91684),(-7.32068,44.99683,-.85784),(-7.01594,38.04762,-1.26678),(-6.64827,38.59429,-1.7772),(-6.38761,37.66076,-1.42346),(-6.21873,37.19339,-1.46081),(-7.00322,38.60868,-1.27313),(-7.61534,37.85738,-1.93423),(-7.34455,38.07095,-1.80989),(-7.4161,37.82641,-1.67554),(-7.16561,37.91297,-1.61301),(-7.09346,37.88135,-1.59241),(-8.01281,38.21663,-1.95),(-6.66496,37.66589,-1.20621),(-6.49649,38.08116,-1.56564),(-6.48452,38.23927,-1.73526),(-7.30871,45.13706,-.85686),(-7.23453,42.8841,-.95426),(-6.66325,43.95331,-1.18792),(-6.62358,43.95157,-1.20604),(-6.57568,49.40829,-.30817),(-5.94515,48.58279,-.58134),(-7.00515,49.43968,-1.44213),(-6.84393,49.59678,-.6096),(-6.9236,49.60012,-.80715),(-6.70485,49.51059,-.37916),(-6.66689,49.48788,-.35434),(-6.70799,49.49253,-.37925),(-6.62162,49.45863,-.33008),(-6.77393,49.35152,-.37686),(-6.82685,49.3763,-.41548),(-6.7274,49.31618,-.34822),(-6.1079,48.16528,-1.27518),(-6.63378,47.6993,-1.59721),(-6.25316,48.20098,-1.55417),(-6.32952,48.25463,-1.63341),(-6.39896,47.27773,-1.27881),(-6.37757,47.28992,-1.16953),(-6.14046,48.16186,-1.38657),(-6.12045,48.14551,-1.27388),(-6.52797,46.27981,-1.39989),(-7.3602,45.16233,-1.0303),(-7.51231,37.67695,-1.1722),(-7.82881,37.01899,-1.60636),(-7.80149,37.07575,-1.66276),(-7.88526,37.25639,-1.76738),(-7.51158,37.61852,-1.14942),(-6.27935,47.82194,-1.36387),(-6.59561,47.26816,-1.54159),(-6.50753,47.26115,-1.46091),(-6.37469,47.82822,-1.48053),(-6.92798,49.35923,-.40573),(-6.47102,49.36557,-.2807),(-6.51725,49.39346,-.28937),(-6.51356,49.40119,-.29172),(-6.57056,49.42508,-.3045),(-6.56677,49.43254,-.30701),(-6.61791,49.46604,-.33239),(-6.66343,49.49533,-.35675),(-6.97727,49.31115,-1.55929),(-6.89827,49.16735,-1.70405),(-6.09327,48.44172,-1.68324),(-6.07421,48.45779,-1.69501),(-5.90611,48.34471,-1.3972),(-6.62906,42.82897,-1.32497),(-6.63148,42.82661,-1.28557),(-6.69145,42.82525,-1.23138),(-6.65013,42.82476,-1.24683),(-7.14936,43.9641,-.88705),(-6.41596,38.08392,-1.7126),(-6.48173,38.24761,-1.70451),(-7.00306,38.35889,-1.25373),(-7.08439,38.61558,-1.24756),(-6.90453,38.36399,-1.2837),(-6.83331,38.03385,-1.26932),(-6.72246,37.98729,-1.29251),(-6.75514,38.0774,-1.30275),(-6.80455,37.95601,-1.26002),(-6.77488,37.87243,-1.25351),(-6.67619,37.80529,-1.26114),(-6.69386,37.90393,-1.28367),(-6.74813,37.79393,-1.24405),(-6.86337,38.24971,-1.2871),(-8.29074,37.25714,-1.38231),(-8.29233,37.3705,-1.42692),(-8.29403,37.32688,-1.41187),(-8.0822,37.96117,-1.90962),(-7.9281,38.63998,-1.93728),(-6.62495,38.35682,-1.51768),(-6.77008,38.35883,-1.39536),(-7.18426,38.27185,-1.85776),(-8.01939,38.39268,-1.6092),(-7.22455,37.66887,-1.45012),(-7.18929,38.07919,-1.77028),(-7.14242,38.06118,-1.7616),(-7.19142,38.05689,-1.76609),(-7.01149,38.03232,-1.77266),(-7.04662,37.92314,-1.64795),(-7.54542,37.81743,-1.85688),(-7.41646,38.61361,-1.91816),(-7.4724,38.6328,-1.39001),(-6.6437,38.60018,-1.62661),(-7.85288,38.85585,-1.94636),(-6.44423,37.98627,-1.56527),(-6.45369,37.88058,-1.48367),(-6.39774,37.89302,-1.55931),(-6.42001,37.78205,-1.46003),(-6.36089,37.79827,-1.53914),(-6.25037,37.20715,-1.83582),(-6.252,37.25467,-1.86221),(-6.24977,37.32752,-1.8956),(-6.18745,37.39204,-1.90188),(-6.19301,37.31692,-1.88593),(-6.24386,37.39757,-1.90861),(-6.22291,37.53724,-1.89363),(-6.17849,37.45983,-1.90375),(-6.23585,37.46388,-1.90895),(-6.16825,37.53453,-1.89084),(-6.98142,38.04636,-1.26295),(-7.40027,45.18423,-1.35641),(-7.22353,49.15543,-1.34772),(-6.39867,47.29681,-1.05658),(-7.0408,44.00134,-1.79498),(-6.43034,47.87387,-.56222),(-6.39932,47.91104,-.60984),(-7.3994,47.80526,-1.0072),(-7.38326,47.81232,-1.14087),(-7.17023,48.38067,-1.55905),(-7.1268,48.17458,-1.55316),(-6.84197,48.73558,-.19645),(-6.66189,48.36749,-.29724),(-6.37418,48.47526,-.25208),(-6.36128,48.3244,-.32263),(-5.8187,48.52239,-.75965),(-5.8745,48.62986,-.5884),(-5.69701,48.94,-.94122),(-5.77425,48.84063,-.72168),(-5.71854,48.73334,-.86182),(-5.73446,49.01317,-.81259),(-5.76635,49.17465,-.92999),(-5.72287,49.10383,-1.0342),(-7.05035,48.90821,-.37054),(-7.36921,48.78359,-1.0865),(-7.32779,48.93935,-.9461),(-7.38592,48.75993,-.93669),(-7.4299,48.57709,-.92711),(-7.43345,48.19644,-.91829),(-7.25349,49.10812,-.94912),(-6.57714,49.61646,-1.62601),(-6.63072,49.44745,-1.73255),(-6.72033,49.55335,-1.63162),(-6.5049,49.52258,-1.71791),(-6.73455,49.35476,-1.73804),(-6.8549,49.23142,-1.74494),(-6.56651,49.13631,-.19569),(-6.40282,49.68074,-.58234),(-6.37819,49.76212,-.74729),(-6.4897,49.73548,-.61992),(-6.31611,49.7245,-.72311),(-6.5957,49.65155,-.49782),(-6.81518,48.91825,-.18374),(-6.67253,47.74703,-.56745),(-6.37104,48.1971,-.39923),(-6.78867,48.94106,-.30506),(-6.8012,48.95345,-.34889),(-6.46757,47.85116,-.54061),(-6.45406,48.63832,-.14045),(-7.12142,37.54256,-1.34547),(-7.11655,37.4743,-1.23359),(-6.03384,48.51306,-1.69883),(-6.89064,49.1887,-1.72434),(-5.85503,48.94962,-.5954),(-5.97384,48.78811,-.46224),(-5.97501,49.29341,-.57797),(-5.79755,49.08568,-.69621),(-6.1482,49.46719,-.51243),(-6.23731,49.66044,-.69939),(-6.31887,49.61386,-.55205),(-6.08522,49.53726,-.6718),(-6.05263,49.60194,-1.00049),(-6.13904,49.68313,-.98203),(-7.12389,37.56213,-1.37925),(-7.0104,37.60752,-1.39267),(-7.10127,37.45136,-1.18286),(-6.97498,37.45421,-1.14218),(-6.96956,37.45093,-1.12484),(-7.03162,37.44999,-1.17133),(-7.12809,37.39663,-1.13251),(-7.17171,37.38219,-1.10643),(-7.12848,37.36372,-1.11138),(-6.95014,37.38971,-1.05854),(-6.95839,37.4244,-1.08624),(-6.8895,37.39418,-1.02925),(-6.89925,37.42982,-1.06137),(-7.62167,36.9963,-1.62269),(-7.60548,36.92549,-1.5646),(-7.5777,36.86301,-1.48573),(-7.54309,36.84067,-1.42011),(-7.5139,36.83095,-1.36395),(-7.47875,36.8425,-1.16424),(-7.47453,36.82867,-1.27598),(-7.43948,36.8528,-1.1742),(-7.50777,36.81783,-1.25952),(-7.4093,36.90221,-1.08314),(-7.42684,36.9499,-1.00761),(-7.44511,36.89502,-1.07033),(-7.39026,36.95384,-1.02261),(-7.44958,37.48641,-1.05551),(-7.4149,37.5454,-1.10034),(-7.44773,37.5523,-1.09404),(-7.41253,37.48241,-1.06555),(-7.40561,37.41848,-1.03065),(-7.42743,37.31938,-.97265),(-7.38618,37.3158,-.98821),(-7.44627,37.42103,-1.01711),(-7.40059,37.10447,-.93141),(-7.36941,37.21537,-.95943),(-7.40709,37.21819,-.94229),(-7.36213,37.10244,-.94997),(-7.40866,37.02549,-.95549),(-7.3702,37.02638,-.97279),(-7.48578,37.48508,-1.05643),(-7.5159,37.54876,-1.10892),(-7.51844,37.47975,-1.06738),(-7.48443,37.55369,-1.0972),(-7.46568,37.31766,-.97101),(-7.51129,37.41225,-1.02388),(-7.50238,37.31168,-.98168),(-7.48291,37.41698,-1.01584),(-7.44698,37.22575,-.94118),(-7.49047,37.11393,-.94734),(-7.43911,37.10832,-.92868),(-7.49108,37.2174,-.95526),(-7.55717,36.85913,-1.15893),(-7.55653,36.81948,-1.27659),(-7.51488,36.84467,-1.15573),(-7.59634,36.83594,-1.2658),(-7.48212,36.89654,-1.06553),(-7.51117,36.96686,-1.01273),(-7.52987,36.90955,-1.0748),(-7.46596,36.95616,-1.00148),(-7.63406,36.83131,-1.35655),(-7.71571,37.64065,-1.10149),(-7.72539,37.50875,-.98312),(-7.71977,37.58147,-1.0457),(-7.73282,37.35166,-.90815),(-7.67696,37.41965,-.98715),(-7.73017,37.43719,-.93378),(-7.68495,37.33377,-.95772),(-7.74886,37.14024,-.8972),(-7.69349,37.23704,-.94168),(-7.7376,37.24927,-.89305),(-7.7059,37.13484,-.94364),(-8.00854,37.66911,-.99757),(-8.06207,37.50385,-.86852),(-7.78804,37.71712,-1.264),(-7.75346,37.69694,-1.25234),(-7.88932,37.73477,-1.16248),(-7.86545,37.73823,-1.24798),(-7.75195,37.70512,-1.23464),(-7.7895,37.72618,-1.24537),(-8.18437,37.22006,-.88268),(-8.13689,37.21115,-.86116),(-8.18804,37.29902,-.88887),(-8.1317,37.01349,-.97244),(-8.11434,37.10051,-.90119),(-8.15998,37.11151,-.91703),(-8.08921,37.00662,-.95577),(-8.062,36.9236,-1.03158),(-8.10196,36.93375,-1.04398),(-7.8628,37.71257,-1.08339),(-7.84452,37.73687,-1.16951),(-7.75439,37.69649,-1.17775),(-7.80881,37.69796,-1.10135),(-7.75544,37.67947,-1.12489),(-7.80171,37.71994,-1.17418),(-7.8297,37.73967,-1.24863),(-7.06806,37.57117,-1.37729),(-7.82737,37.73036,-1.26861),(-7.34147,37.59872,-1.48657),(-7.12753,37.58802,-1.41603),(-7.00828,37.59775,-1.44928),(-6.16041,37.70314,-1.72885),(-6.27575,37.81556,-1.68471),(-6.31065,37.87525,-1.81638),(-6.63694,37.87965,-1.31934),(-6.5937,37.88108,-1.35171),(-6.56639,37.87574,-1.37014),(-6.4984,37.88225,-1.44021),(-6.34399,37.9032,-1.63751),(-6.38457,37.99415,-1.65421),(-6.42597,38.0851,-1.67091),(-6.94252,37.9701,-1.26201),(-6.06689,37.45078,-1.86222),(-6.05732,37.37844,-1.83555),(-6.07593,37.37966,-1.85656),(-6.04937,37.44851,-1.84183),(-6.05401,37.5234,-1.83687),(-6.07969,37.48978,-1.58212),(-6.12565,37.57771,-1.5888),(-6.24092,37.75538,-1.68158),(-6.16685,37.68307,-1.66562),(-6.09523,37.61846,-1.7331),(-6.10385,37.60137,-1.66277),(-6.03871,37.44103,-1.74623),(-6.05559,37.50518,-1.6626),(-6.04842,37.42889,-1.67205),(-6.04742,37.51536,-1.73799),(-6.05207,37.37485,-1.68337),(-6.04466,37.37557,-1.7481),(-6.05495,37.30585,-1.79074),(-6.04616,37.381,-1.80494),(-6.03944,37.44566,-1.81146),(-6.04704,37.52125,-1.8074),(-6.27151,36.9972,-1.64164),(-6.28673,36.98469,-1.52176),(-6.29564,36.97466,-1.54659),(-6.32043,37.32361,-1.37191),(-6.3304,36.98285,-1.48527),(-6.33353,37.03088,-1.6688),(-6.38385,37.33076,-1.8864),(-6.32467,37.33227,-1.89721),(-6.37999,37.47532,-1.89883),(-6.32476,37.40439,-1.90925),(-6.38583,37.40593,-1.89918),(-6.31994,37.47155,-1.90859),(-6.31293,37.54297,-1.894),(-6.36989,37.62552,-1.88185),(-6.30735,37.62312,-1.88601),(-6.3718,37.54697,-1.88548),(-6.5317,37.79404,-1.36746),(-6.47595,37.78296,-1.40566),(-6.39456,37.43418,-1.3345),(-6.42082,37.55193,-1.35827),(-6.4495,37.66819,-1.38114),(-6.52177,37.54796,-1.30657),(-6.49948,37.67136,-1.3518),(-6.54296,37.67411,-1.3263),(-6.47488,37.5498,-1.33058),(-6.30365,37.81224,-1.62082),(-6.59886,37.52873,-1.23274),(-6.45726,37.4268,-1.30569),(-6.40288,37.08208,-1.41138),(-6.40851,37.02907,-1.43356),(-6.49387,37.02362,-1.41433),(-6.56589,37.06446,-1.37802),(-6.57876,37.01822,-1.39519),(-6.48618,37.07308,-1.39434),(-6.60093,37.03303,-1.31147),(-6.41161,37.10958,-1.7339),(-6.11439,37.4544,-1.88703),(-6.13451,37.30933,-1.86624),(-6.12271,37.38704,-1.883),(-6.47478,37.17447,-1.36026),(-6.46486,37.29935,-1.32894),(-6.5062,36.97924,-1.44224),(-6.53834,36.98175,-1.52204),(-6.51544,36.96915,-1.46254),(-6.55422,37.0189,-1.57488),(-6.55889,37.053,-1.62985),(-6.55979,37.09062,-1.69161),(-6.55955,37.12221,-1.74226),(-6.55002,37.2097,-1.80565),(-6.4368,37.54561,-1.86945),(-6.51288,37.46814,-1.85941),(-6.44652,37.40204,-1.88118),(-6.44373,37.47357,-1.88183),(-6.43719,37.23207,-1.83199),(-6.44516,37.32496,-1.86661),(-6.50387,37.22149,-1.81818),(-6.42098,37.13764,-1.77111),(-6.48469,37.09993,-1.71254),(-6.49422,37.13252,-1.7599),(-6.46274,37.02949,-1.61193),(-6.389,37.03672,-1.64214),(-6.47481,37.06403,-1.6605),(-6.42826,36.97033,-1.48648),(-6.4463,36.98758,-1.55316),(-6.34851,36.97141,-1.50828),(-6.41852,36.98105,-1.46376),(-6.39243,37.31155,-1.35054),(-6.39401,37.19006,-1.37359),(-8.21855,37.2809,-1.53621),(-8.21457,37.21158,-1.50395),(-6.791,37.19692,-1.84073),(-6.75467,37.09061,-1.84858),(-6.78197,37.08388,-1.85612),(-6.83187,37.08237,-1.8595),(-6.87642,37.0818,-1.80605),(-7.08755,37.11976,-1.66269),(-6.96922,37.18352,-1.7422),(-6.96776,37.09344,-1.73379),(-7.08151,37.19277,-1.67303),(-7.16692,37.21584,-1.64263),(-7.20779,37.16597,-1.62698),(-7.20064,37.22328,-1.63576),(-7.1749,37.15906,-1.63407),(-7.24905,37.16675,-1.63133),(-7.23811,37.2233,-1.64327),(-8.06455,37.23612,-1.62977),(-7.19211,37.28267,-1.632),(-7.5814,37.46774,-1.0928),(-7.60975,37.46236,-1.10388),(-7.98398,37.56882,-.91435),(-7.96314,37.63005,-.96028),(-7.84527,37.54543,-.93589),(-7.89403,37.62214,-.96664),(-7.91527,37.5617,-.91577),(-7.82922,37.60708,-.9882),(-7.77863,37.52739,-.96298),(-7.76685,37.59202,-1.02036),(-7.03182,37.4489,-1.18765),(-7.41824,37.61,-1.13329),(-7.81202,37.66315,-1.03894),(-7.75624,37.64843,-1.0724),(-7.87531,37.67721,-1.01373),(-7.99445,37.18622,-.81478),(-8.05047,37.19716,-.83084),(-7.99222,37.08771,-.86263),(-8.02944,37.41088,-.84293),(-8.00698,37.50035,-.86886),(-8.0229,36.92285,-1.01705),(-7.97906,37.0057,-.92296),(-7.80589,37.3674,-.87987),(-7.8939,37.28364,-.83763),(-7.81577,37.26697,-.86275),(-7.87822,37.38416,-.85641),(-7.9144,37.08013,-.87376),(-7.82145,37.1549,-.8671),(-7.90354,37.16946,-.8377),(-7.92019,37.0057,-.92178),(-7.86334,37.47103,-.88341),(-7.93845,37.49052,-.86575),(-7.95886,37.4001,-.83752),(-7.98155,37.29866,-.81744),(-7.12649,37.28721,-1.08898),(-7.12073,37.18379,-1.06625),(-7.08607,37.18005,-1.06364),(-7.16191,37.09709,-1.0473),(-7.15757,37.18988,-1.05479),(-7.12273,37.09383,-1.05882),(-7.08879,37.08925,-1.05698),(-7.13483,37.02946,-1.07744),(-7.09845,37.02022,-1.07856),(-7.14561,36.97997,-1.11191),(-7.1738,37.03187,-1.06959),(-7.18692,36.98388,-1.10551),(-7.12016,36.93206,-1.1687),(-7.10932,36.97119,-1.11286),(-7.1558,36.94258,-1.16602),(-7.14095,36.89015,-1.23697),(-7.17585,36.90117,-1.23143),(-7.21883,36.91042,-1.22311),(-7.19401,36.8862,-1.3079),(-7.23245,36.89406,-1.30066),(-7.167,36.89153,-1.37535),(-7.20214,36.90025,-1.36889),(-7.15947,36.87679,-1.31445),(-7.17057,36.8998,-1.41644),(-7.20746,36.90946,-1.40885),(-7.21127,36.9403,-1.45703),(-7.17881,36.97924,-1.5274),(-7.17389,36.92998,-1.46616),(-7.21485,36.98873,-1.5177),(-7.17929,37.04402,-1.57325),(-7.21404,37.05234,-1.56425),(-7.21355,37.11075,-1.60569),(-7.25288,37.05389,-1.56231),(-7.25214,37.11305,-1.60622),(-7.17827,37.1037,-1.61359),(-7.16046,37.2879,-1.07981),(-7.10715,37.44956,-1.20721),(-7.65359,37.31989,-.99777),(-7.64344,37.4098,-1.03576),(-7.6058,37.22055,-1.0029),(-7.64352,37.22362,-1.01886),(-7.68295,37.13615,-.98291),(-7.66779,37.23194,-.98509),(-7.65739,37.13456,-1.0172),(-7.61544,37.12792,-1.00009),(-7.62871,37.04902,-1.02101),(-7.69711,36.94826,-1.12988),(-7.66622,36.89194,-1.1933),(-7.65173,36.93485,-1.11929),(-7.70516,36.86473,-1.44052),(-7.69424,36.85817,-1.37656),(-7.67784,36.87509,-1.26044),(-7.08864,36.93048,-1.55203),(-6.95857,36.94311,-1.66712),(-6.95992,36.87424,-1.62657),(-7.0871,36.99305,-1.59304),(-7.3383,37.04897,-1.57173),(-7.25394,36.99002,-1.51543),(-7.33775,36.97934,-1.52113),(-7.44859,36.95497,-1.53271),(-7.4592,37.03308,-1.59393),(-7.3409,37.10089,-1.62125),(-7.08775,37.04805,-1.64111),(-6.85321,36.97923,-1.8035),(-6.8491,36.89199,-1.76349),(-6.95944,37.0044,-1.71473),(-6.79334,36.77497,-1.74462),(-6.7432,36.76986,-1.7578),(-6.72836,36.86825,-1.80591),(-6.71475,36.78758,-1.75223),(-7.4452,37.02748,-.95271),(-6.8273,36.69206,-1.53821),(-6.95554,36.7771,-1.48536),(-7.08347,36.85212,-1.43875),(-7.08052,36.83954,-1.38372),(-7.38958,36.87303,-1.35823),(-7.4144,36.87953,-1.40329),(-7.83994,36.88802,-1.34566),(-7.43525,36.89914,-1.46587),(-7.0858,36.88307,-1.49691),(-6.84093,36.75234,-1.63747),(-6.95717,36.82054,-1.57191),(-6.68031,36.87354,-1.61573),(-6.69301,36.66216,-1.182),(-6.62045,36.62572,-1.28119),(-6.60205,36.65772,-1.21787),(-6.70285,36.62976,-1.25752),(-6.94771,36.75331,-1.24848),(-6.79265,36.66135,-1.25112),(-7.05491,36.8765,-1.17356),(-7.06722,36.83789,-1.2436),(-7.8107,36.90777,-1.14882),(-7.30529,36.88303,-1.28908),(-7.35162,36.87956,-1.28393),(-7.29218,37.44518,-1.59065),(-6.57184,36.83997,-1.03709),(-6.55546,36.77455,-1.12458),(-7.26482,36.97222,-1.07869),(-7.24648,37.03113,-1.0376),(-7.03469,36.99046,-1.06871),(-7.04567,36.9239,-1.11282),(-6.92598,36.86872,-1.07922),(-6.91368,36.93846,-1.02927),(-6.7698,36.80257,-1.03094),(-7.02374,37.07034,-1.04593),(-7.23074,37.09619,-1.01901),(-7.4977,37.03675,-.96872),(-8.08784,37.20215,-.84315),(-7.07645,36.82606,-1.31552),(-6.91577,37.1716,-1.00321),(-7.02188,37.17198,-1.05429),(-6.93281,37.29831,-1.03176),(-8.04241,37.31022,-.82739),(-6.86431,37.30596,-1.00297),(-7.23533,37.19724,-1.02682),(-7.24593,37.30084,-1.04812),(-6.71582,36.61094,-1.3484),(-6.76353,36.64851,-1.56226),(-6.73507,36.61261,-1.44227),(-6.78445,36.71137,-1.67285),(-6.84656,36.81335,-1.70432),(-6.61709,36.63115,-1.37257),(-6.6436,36.60671,-1.3628),(-6.67176,36.60442,-1.46636),(-6.70026,36.63569,-1.57464),(-6.69815,36.72776,-1.68821),(-6.72501,36.70579,-1.68942),(-6.74736,36.97977,-1.83626),(-6.55937,48.65278,-.12256),(-7.39249,48.54479,-.73738),(-7.29959,48.10197,-.64375),(-5.67184,48.84288,-1.20422),(-5.68036,48.62611,-1.15589),(-5.71479,49.03305,-1.24212),(-5.75776,48.62288,-1.45337),(-5.92667,48.71073,-1.6829),(-5.91419,49.30962,-1.5127),(-6.07791,49.36688,-1.67196),(-6.15165,49.04937,-1.83681),(-6.09727,49.22269,-1.762),(-6.20988,48.90696,-1.87707),(-6.46805,49.10505,-1.89692),(-6.39031,49.23134,-1.85152),(-6.30614,49.35962,-1.79502),(-6.24685,49.45532,-1.70432),(-6.6468,49.69996,-1.52398),(-6.45985,49.71361,-1.50392),(-6.45996,49.7974,-1.3513),(-6.69062,49.82295,-1.29785),(-6.73046,49.81777,-.95632),(-6.60965,49.86356,-1.04927),(-6.52621,49.84208,-.88119),(-6.641,49.80331,-.78031),(-7.42178,48.15423,-.77795),(-6.9175,43.9691,-.99823),(-6.90872,42.90209,-1.09048),(-6.6598,42.8474,-1.60773),(-6.53288,38.34167,-1.64814),(-7.49899,38.36154,-1.34788),(-6.56938,37.80004,-1.34124),(-6.48899,38.24505,-1.66592),(-7.26328,37.40551,-1.08462),(-7.79473,37.45533,-.90755),(-7.99569,36.87521,-1.11562),(-7.82821,36.89305,-1.23912),(-8.29903,37.52547,-1.43681),(-7.19568,37.96882,-1.68761),(-7.15485,37.97057,-1.67885),(-7.20023,36.9494,-1.15903),(-7.6399,36.98418,-1.06122),(-6.49886,37.42181,-1.28684),(-6.52282,49.37756,-.2955),(-6.97048,49.33369,-1.57365)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesRightHumerus.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesRightHumerus.py load and self-test diagnostics complete.")
