####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesRightHand.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesRightHand.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Right Hand',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesRightHand.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesRightHand.x3d'),
    Transform(DEF='RightHandSkeletonParts',scale=(0.029,0.029,0.029),translation=(0,-0.015,0),
      children=[
      Viewpoint(DEF='RightHand',description='Right Hand',position=(-5,28,24)),
      Group(DEF='righthand',
        #  rcaptate rscphoid rhamate rlunate rpisform rtrpzium rtrpzoid rtrqtral rmc rmc2 rmc3 rmc4 rmc5 rpphal rpphal2 rpphal3 rpphal4 rpphal5 rmphal2 rmphal3 rmphal4 rmphal5 rdphal rdphal2 rdphal3 rdphal4 rdphal5 
        children=[
        Shape(DEF='rcaptate',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rcaptate_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,5,6,3,-1,5,7,6,-1,8,9,10,-1,10,11,8,-1,12,13,14,-1,15,16,17,-1,13,12,18,-1,11,19,20,-1,20,21,11,-1,22,23,24,-1,22,25,23,-1,26,27,14,-1,26,28,27,-1,29,30,31,-1,31,32,29,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,41,42,39,-1,43,44,45,-1,44,46,45,-1,47,48,49,-1,48,50,49,-1,2,51,0,-1,44,43,52,-1,47,53,54,-1,55,56,57,-1,57,58,55,-1,59,60,61,-1,59,62,60,-1,38,63,36,-1,38,64,63,-1,60,65,61,-1,60,66,65,-1,67,68,69,-1,69,70,67,-1,71,72,68,-1,73,74,75,-1,76,77,78,-1,77,79,78,-1,80,81,82,-1,80,6,81,-1,83,84,85,-1,86,87,88,-1,86,89,87,-1,89,90,91,-1,91,72,89,-1,92,26,93,-1,94,31,30,-1,23,95,96,-1,97,98,99,-1,100,101,102,-1,100,103,101,-1,45,104,39,-1,105,97,106,-1,107,97,108,-1,109,110,24,-1,109,111,110,-1,44,112,46,-1,113,114,115,-1,116,117,118,-1,115,38,113,-1,119,120,7,-1,119,121,120,-1,122,52,123,-1,122,124,52,-1,125,126,127,-1,125,128,126,-1,65,129,130,-1,65,131,129,-1,132,133,134,-1,132,135,133,-1,132,62,136,-1,66,60,134,-1,137,138,127,-1,139,140,141,-1,142,143,144,-1,144,145,142,-1,146,147,148,-1,149,150,73,-1,151,150,152,-1,153,150,154,-1,155,150,156,-1,157,150,158,-1,159,55,58,-1,159,160,55,-1,41,40,161,-1,162,142,163,-1,164,43,45,-1,165,166,167,-1,168,169,170,-1,169,171,170,-1,172,138,173,-1,138,137,173,-1,56,174,175,-1,174,176,175,-1,177,178,179,-1,180,181,179,-1,181,174,179,-1,131,182,129,-1,183,116,118,-1,37,184,185,-1,185,183,37,-1,117,116,159,-1,186,187,49,-1,160,188,189,-1,190,191,192,-1,190,193,194,-1,190,195,193,-1,30,196,197,-1,198,199,200,-1,198,201,199,-1,202,96,203,-1,202,204,96,-1,204,23,96,-1,205,27,206,-1,93,207,92,-1,208,207,10,-1,209,92,207,-1,210,211,212,-1,32,208,213,-1,214,215,216,-1,216,217,214,-1,210,4,211,-1,80,85,218,-1,82,85,80,-1,219,5,220,-1,221,222,121,-1,222,223,121,-1,224,225,219,-1,219,220,224,-1,210,213,4,-1,224,9,226,-1,224,10,9,-1,10,227,11,-1,93,13,228,-1,8,21,229,-1,8,11,21,-1,67,230,231,-1,42,45,39,-1,232,233,234,-1,233,235,234,-1,236,237,116,-1,98,97,238,-1,239,240,116,-1,241,242,239,-1,243,142,162,-1,148,244,146,-1,245,24,246,-1,245,247,24,-1,241,185,184,-1,241,239,185,-1,135,248,133,-1,135,249,248,-1,250,20,251,-1,229,252,253,-1,229,21,252,-1,251,17,250,-1,254,12,146,-1,146,244,254,-1,147,146,22,-1,116,185,239,-1,255,116,240,-1,103,256,101,-1,257,237,236,-1,257,258,237,-1,186,116,237,-1,259,214,51,-1,136,62,260,-1,252,16,253,-1,59,86,88,-1,19,261,20,-1,231,9,8,-1,231,230,9,-1,213,208,224,-1,213,224,220,-1,220,4,213,-1,224,226,225,-1,221,121,119,-1,119,262,221,-1,219,225,5,-1,85,84,78,-1,79,218,85,-1,220,5,4,-1,215,214,259,-1,208,10,224,-1,192,31,94,-1,93,10,207,-1,14,13,93,-1,93,26,14,-1,146,12,14,-1,206,27,28,-1,198,196,201,-1,263,28,191,-1,195,190,192,-1,55,160,189,-1,116,186,160,-1,117,159,264,-1,159,58,264,-1,183,185,116,-1,117,264,265,-1,129,266,128,-1,129,182,266,-1,230,67,267,-1,67,268,267,-1,126,269,270,-1,271,272,273,-1,169,168,274,-1,274,176,169,-1,158,150,275,-1,276,56,175,-1,188,160,186,-1,85,82,83,-1,116,160,159,-1,276,277,57,-1,275,149,278,-1,278,279,275,-1,156,150,157,-1,154,150,155,-1,152,150,153,-1,73,150,151,-1,275,150,149,-1,280,142,145,-1,280,163,142,-1,144,143,36,-1,36,63,144,-1,133,281,282,-1,133,248,281,-1,127,283,125,-1,127,138,283,-1,130,284,65,-1,284,61,65,-1,134,62,132,-1,134,60,62,-1,136,135,132,-1,133,282,66,-1,66,134,133,-1,285,286,287,-1,288,183,118,-1,288,37,183,-1,118,265,288,-1,118,117,265,-1,57,56,276,-1,24,110,246,-1,110,289,246,-1,103,290,256,-1,290,291,256,-1,99,108,97,-1,106,97,107,-1,238,97,105,-1,116,255,236,-1,292,293,294,-1,293,295,294,-1,99,111,291,-1,99,98,111,-1,256,109,101,-1,95,296,203,-1,203,96,95,-1,30,297,94,-1,30,197,297,-1,191,194,263,-1,191,190,194,-1,147,247,148,-1,7,225,119,-1,171,298,170,-1,67,70,268,-1,299,300,301,-1,300,302,301,-1,303,47,304,-1,303,53,47,-1,71,89,72,-1,71,87,89,-1,91,305,306,-1,91,90,305,-1,173,307,172,-1,212,29,210,-1,216,211,217,-1,216,212,211,-1,78,79,85,-1,186,308,187,-1,68,309,69,-1,68,67,231,-1,231,71,68,-1,88,260,62,-1,62,59,88,-1,288,38,37,-1,288,113,38,-1,178,177,189,-1,189,188,178,-1,241,184,142,-1,184,143,142,-1,286,310,311,-1,41,259,42,-1,222,308,232,-1,104,34,39,-1,34,312,39,-1,311,310,313,-1,212,216,196,-1,216,201,196,-1,14,27,205,-1,205,146,14,-1,312,40,39,-1,11,227,19,-1,19,228,261,-1,19,227,228,-1,16,15,136,-1,0,51,214,-1,214,314,0,-1,3,77,211,-1,211,4,3,-1,314,217,76,-1,314,214,217,-1,120,6,7,-1,120,81,6,-1,7,5,225,-1,81,1,0,-1,1,81,120,-1,211,76,217,-1,77,76,211,-1,252,17,16,-1,17,252,250,-1,228,18,261,-1,228,13,18,-1,102,315,316,-1,315,102,317,-1,318,215,161,-1,318,199,215,-1,101,204,202,-1,204,101,109,-1,23,109,24,-1,23,204,109,-1,92,28,26,-1,191,28,92,-1,196,29,212,-1,29,196,30,-1,222,187,308,-1,304,187,222,-1,1,234,2,-1,1,223,234,-1,165,286,285,-1,165,310,286,-1,166,242,243,-1,166,319,242,-1,320,34,104,-1,320,35,34,-1,166,285,319,-1,166,165,285,-1,36,184,37,-1,36,143,184,-1,321,300,322,-1,300,321,302,-1,178,47,54,-1,178,48,47,-1,114,288,265,-1,114,113,288,-1,282,182,131,-1,282,281,182,-1,300,69,322,-1,70,69,300,-1,55,177,56,-1,55,189,177,-1,88,323,260,-1,88,87,323,-1,324,140,325,-1,324,141,140,-1,314,83,0,-1,83,314,84,-1,3,79,77,-1,79,3,218,-1,326,305,90,-1,327,305,326,-1,172,328,329,-1,172,307,328,-1,272,173,273,-1,272,307,173,-1,328,306,305,-1,306,328,330,-1,8,323,231,-1,8,229,323,-1,301,53,303,-1,301,302,53,-1,299,70,300,-1,268,70,299,-1,91,68,72,-1,91,309,68,-1,331,171,332,-1,331,298,171,-1,322,333,321,-1,322,334,333,-1,119,335,262,-1,119,225,335,-1,247,22,24,-1,22,247,147,-1,263,95,336,-1,263,194,95,-1,94,195,192,-1,94,297,195,-1,197,295,297,-1,197,294,295,-1,200,337,292,-1,337,200,33,-1,293,203,296,-1,203,293,338,-1,256,111,109,-1,291,111,256,-1,337,317,338,-1,337,315,317,-1,287,124,122,-1,287,286,124,-1,255,257,236,-1,255,339,257,-1,318,34,33,-1,318,312,34,-1,289,106,340,-1,289,105,106,-1,107,290,313,-1,107,108,290,-1,111,238,110,-1,111,98,238,-1,246,340,341,-1,246,289,340,-1,313,103,311,-1,313,290,103,-1,2,235,164,-1,235,2,234,-1,165,341,310,-1,167,341,165,-1,283,130,125,-1,283,284,130,-1,38,342,64,-1,38,115,342,-1,343,163,280,-1,343,245,163,-1,74,151,344,-1,74,73,151,-1,152,345,346,-1,152,153,345,-1,154,347,348,-1,154,155,347,-1,349,157,350,-1,349,156,157,-1,158,279,351,-1,158,275,279,-1,278,324,352,-1,324,278,75,-1,270,346,137,-1,270,344,346,-1,345,273,173,-1,345,348,273,-1,353,349,170,-1,353,347,349,-1,168,351,274,-1,168,350,351,-1,279,352,354,-1,279,278,352,-1,233,237,258,-1,186,237,233,-1,354,276,175,-1,354,352,276,-1,175,274,354,-1,175,176,274,-1,273,355,271,-1,355,273,353,-1,270,139,141,-1,269,139,270,-1,181,176,174,-1,176,181,169,-1,356,298,331,-1,356,355,298,-1,272,357,330,-1,357,272,271,-1,266,126,128,-1,266,269,126,-1,333,181,180,-1,332,181,333,-1,358,331,334,-1,356,331,358,-1,359,69,309,-1,359,358,69,-1,330,359,306,-1,359,330,357,-1,327,283,329,-1,327,284,283,-1,64,266,182,-1,64,342,266,-1,277,325,114,-1,277,276,325,-1,296,295,293,-1,193,295,296,-1,206,25,205,-1,206,336,25,-1,335,268,299,-1,335,267,268,-1,304,221,303,-1,304,222,221,-1,260,229,253,-1,260,323,229,-1,136,253,16,-1,253,136,260,-1,232,186,233,-1,232,308,186,-1,257,123,258,-1,122,123,257,-1,315,33,35,-1,33,315,337,-1,339,240,319,-1,339,255,240,-1,166,162,167,-1,243,162,166,-1,360,145,249,-1,145,360,280,-1,244,15,254,-1,361,15,244,-1,360,135,136,-1,360,249,135,-1,251,261,18,-1,261,251,20,-1,326,59,61,-1,59,326,86,-1,144,249,145,-1,249,144,248,-1,360,15,361,-1,360,136,15,-1,361,280,360,-1,361,343,280,-1,245,162,163,-1,162,245,246,-1,343,244,148,-1,343,361,244,-1,341,162,246,-1,341,167,162,-1,240,242,319,-1,240,239,242,-1,285,339,319,-1,287,339,285,-1,112,362,100,-1,112,44,362,-1,164,42,2,-1,45,42,164,-1,93,227,10,-1,93,228,227,-1,230,226,9,-1,230,267,226,-1,267,225,226,-1,335,225,267,-1,303,262,301,-1,303,221,262,-1,41,215,259,-1,161,215,41,-1,213,29,32,-1,29,213,210,-1,208,209,207,-1,208,32,209,-1,28,336,206,-1,28,263,336,-1,198,292,294,-1,198,200,292,-1,194,296,95,-1,193,296,194,-1,193,297,295,-1,195,297,193,-1,63,248,144,-1,281,248,63,-1,61,327,326,-1,284,327,61,-1,309,306,359,-1,306,309,91,-1,358,357,356,-1,359,357,358,-1,322,358,334,-1,322,69,358,-1,321,180,54,-1,321,333,180,-1,179,54,180,-1,54,179,178,-1,56,179,174,-1,56,177,179,-1,342,269,266,-1,342,139,269,-1,329,138,172,-1,329,283,138,-1,271,356,357,-1,356,271,355,-1,332,169,181,-1,332,171,169,-1,352,325,276,-1,325,352,324,-1,355,170,298,-1,355,353,170,-1,235,258,123,-1,235,233,258,-1,112,320,46,-1,112,316,320,-1,351,354,274,-1,351,279,354,-1,170,350,168,-1,170,349,350,-1,348,353,273,-1,348,347,353,-1,346,173,137,-1,346,345,173,-1,141,344,270,-1,141,74,344,-1,350,158,351,-1,350,157,158,-1,347,156,349,-1,347,155,156,-1,153,348,345,-1,153,154,348,-1,344,152,346,-1,344,151,152,-1,149,75,278,-1,75,149,73,-1,245,148,247,-1,148,245,343,-1,140,342,115,-1,342,140,139,-1,129,125,130,-1,129,128,125,-1,137,126,270,-1,127,126,137,-1,123,164,235,-1,123,43,164,-1,123,52,43,-1,120,223,1,-1,223,120,121,-1,114,140,115,-1,114,325,140,-1,341,313,310,-1,341,340,313,-1,238,289,110,-1,238,105,289,-1,108,291,290,-1,291,108,99,-1,340,107,313,-1,340,106,107,-1,316,100,102,-1,316,112,100,-1,339,122,257,-1,339,287,122,-1,100,311,103,-1,362,311,100,-1,338,202,203,-1,338,317,202,-1,292,338,293,-1,338,292,337,-1,199,33,200,-1,33,199,318,-1,198,197,196,-1,198,294,197,-1,336,23,25,-1,336,95,23,-1,299,262,335,-1,301,262,299,-1,334,332,333,-1,334,331,332,-1,307,330,328,-1,330,307,272,-1,327,328,305,-1,329,328,327,-1,90,86,326,-1,90,89,86,-1,76,84,314,-1,78,84,76,-1,80,3,6,-1,218,3,80,-1,83,81,0,-1,82,81,83,-1,75,141,324,-1,75,74,141,-1,281,64,182,-1,281,63,64,-1,265,277,114,-1,265,264,277,-1,50,178,188,-1,50,48,178,-1,87,231,323,-1,71,231,87,-1,66,131,65,-1,66,282,131,-1,277,58,57,-1,58,277,264,-1,302,54,53,-1,302,321,54,-1,49,188,186,-1,49,50,188,-1,46,104,45,-1,46,320,104,-1,142,242,241,-1,243,242,142,-1,362,286,311,-1,362,124,286,-1,124,44,52,-1,44,124,362,-1,42,51,2,-1,42,259,51,-1,232,223,222,-1,234,223,232,-1,49,304,47,-1,49,187,304,-1,209,31,192,-1,31,209,32,-1,22,205,25,-1,205,22,146,-1,317,101,202,-1,317,102,101,-1,161,312,318,-1,40,312,161,-1,215,201,216,-1,215,199,201,-1,209,191,92,-1,209,192,191,-1,35,316,315,-1,316,35,320,-1,17,254,15,-1,254,17,251,-1,254,18,12,-1,18,254,251,-1,252,20,250,-1,21,20,252,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rcaptate_Coord',point=[(-7.59155,28.76393,2.64299),(-7.58463,28.77435,2.641),(-7.58821,28.7646,2.63554),(-7.47724,28.66923,2.95889),(-7.47376,28.66567,2.96495),(-7.42354,28.76061,2.83053),(-7.4315,28.75589,2.82181),(-7.42488,28.76672,2.8174),(-7.07402,28.65577,2.81713),(-7.12172,28.67384,2.84736),(-7.18692,28.54675,2.86038),(-7.06903,28.52844,2.84874),(-7.00051,28.30711,2.65398),(-7.00405,28.31154,2.66476),(-7.02141,28.29547,2.65945),(-6.93259,28.54182,2.53641),(-6.93113,28.54568,2.54766),(-6.92715,28.53109,2.55301),(-6.99406,28.31675,2.66098),(-7.06133,28.51603,2.8379),(-6.99057,28.53057,2.73314),(-6.99499,28.5447,2.73425),(-7.16532,28.38139,2.49709),(-7.23588,28.41679,2.46055),(-7.22883,28.42493,2.45624),(-7.17396,28.37317,2.50417),(-7.21614,28.34388,2.7132),(-7.0409,28.29294,2.65449),(-7.22729,28.34288,2.70762),(-7.49162,28.51464,2.88995),(-7.49188,28.50598,2.8785),(-7.38641,28.47522,2.90974),(-7.38165,28.48193,2.91873),(-7.59511,28.46167,2.59677),(-7.60722,28.47531,2.54316),(-7.60159,28.4736,2.54318),(-7.15068,28.97039,2.36604),(-7.1637,28.97188,2.36608),(-7.15217,28.98098,2.35972),(-7.68225,28.49967,2.52147),(-7.68422,28.50079,2.5302),(-7.62397,28.64916,2.59706),(-7.61435,28.6605,2.59346),(-7.48855,28.61992,2.54627),(-7.48511,28.60687,2.54283),(-7.55707,28.5915,2.55305),(-7.54907,28.58126,2.55207),(-7.48765,28.98869,2.58213),(-7.48881,28.99143,2.57459),(-7.48604,28.98057,2.57575),(-7.48728,28.98964,2.57333),(-7.59695,28.75182,2.63943),(-7.48328,28.6205,2.54301),(-7.42423,28.98369,2.68587),(-7.42209,28.99667,2.68598),(-7.41007,29.05586,2.45442),(-7.4091,29.06534,2.45417),(-7.36214,29.06493,2.41769),(-7.36348,29.05309,2.4207),(-6.95926,28.79463,2.57343),(-6.94462,28.87531,2.52979),(-6.93976,28.88098,2.5371),(-6.96054,28.78722,2.55966),(-7.09456,28.96331,2.3819),(-7.09433,28.96933,2.38019),(-6.96944,28.93314,2.4862),(-6.97683,28.92327,2.48313),(-7.13102,28.84558,2.82162),(-7.11934,28.84851,2.81589),(-7.23327,28.9604,2.81882),(-7.23831,28.94835,2.81948),(-7.06653,28.75359,2.76915),(-7.06237,28.81661,2.76441),(-7.13747,29.20659,2.48827),(-7.13414,29.19412,2.45384),(-7.15825,29.20166,2.46313),(-7.57916,28.64306,2.75607),(-7.56104,28.62889,2.82289),(-7.54576,28.64156,2.76125),(-7.53335,28.63977,2.79603),(-7.46505,28.70988,2.79372),(-7.48248,28.76318,2.72948),(-7.48652,28.72723,2.73756),(-7.54374,28.71343,2.69741),(-7.54948,28.66864,2.72128),(-7.51018,28.66802,2.77019),(-6.96861,28.78747,2.63584),(-7.02102,28.70973,2.68065),(-6.99838,28.69395,2.61868),(-7.01323,28.78938,2.6936),(-6.99651,28.86211,2.70096),(-7.04973,28.88649,2.75675),(-7.25935,28.40038,2.77325),(-7.1444,28.40979,2.7526),(-7.39679,28.45746,2.85464),(-7.30556,28.36765,2.55211),(-7.31379,28.38509,2.52046),(-7.30908,28.50997,2.52876),(-7.3115,28.47526,2.5232),(-7.33601,28.48241,2.52851),(-7.45274,28.51311,2.5387),(-7.38705,28.41004,2.51352),(-7.48366,28.43563,2.53021),(-7.40242,28.48968,2.51964),(-7.61233,28.48532,2.53486),(-7.26738,28.51403,2.50547),(-7.31187,28.54485,2.52252),(-7.35193,28.54181,2.53486),(-7.35168,28.50681,2.53479),(-7.31791,28.41792,2.50671),(-7.24551,28.44992,2.48033),(-7.31391,28.45453,2.5169),(-7.49231,28.53132,2.55333),(-7.18452,29.00931,2.35291),(-7.22826,29.03205,2.35838),(-7.15893,29.02101,2.33937),(-7.34125,28.86446,2.50607),(-7.31623,28.95579,2.46688),(-7.28393,28.93699,2.44945),(-7.39567,28.81887,2.74893),(-7.47972,28.77565,2.72477),(-7.45997,28.82767,2.69739),(-7.42689,28.65968,2.53522),(-7.45902,28.67636,2.54938),(-7.44229,28.60692,2.53318),(-6.96105,29.02969,2.47848),(-7.01541,29.12844,2.44557),(-6.99307,29.12791,2.49063),(-6.99441,29.02803,2.43187),(-6.98686,28.96068,2.43977),(-6.9522,28.95604,2.48272),(-6.99044,28.94474,2.44484),(-6.98423,28.80417,2.51926),(-7.00389,28.9007,2.46462),(-6.98414,28.88416,2.49117),(-6.98958,28.81537,2.48034),(-6.94203,28.67358,2.51898),(-7.04853,29.16978,2.51352),(-6.98355,29.119,2.54342),(-7.09666,29.11993,2.37306),(-7.14875,29.1141,2.34875),(-7.13302,29.18336,2.42995),(-7.18095,28.78321,2.41569),(-7.15655,28.88757,2.37331),(-7.09656,28.89616,2.39823),(-7.1011,28.80623,2.42385),(-7.1038,28.3388,2.54224),(-7.14844,28.40529,2.49),(-7.10491,28.45732,2.47505),(-7.15854,29.21561,2.49553),(-7.14187,29.21335,2.51567),(-7.12414,29.20218,2.49355),(-7.11106,29.2024,2.5148),(-7.11392,29.20312,2.52614),(-7.1282,29.21016,2.53482),(-7.14133,29.21415,2.53737),(-7.15595,29.21778,2.53519),(-7.16501,29.22127,2.5284),(-7.16745,29.22052,2.51435),(-7.36189,28.94866,2.49016),(-7.40556,28.94188,2.5164),(-7.68141,28.48762,2.62059),(-7.22898,28.63032,2.45115),(-7.16097,28.66632,2.42294),(-7.51972,28.68238,2.59076),(-7.35779,28.61422,2.51114),(-7.31318,28.65496,2.49654),(-7.32287,28.61781,2.5029),(-7.21814,29.22942,2.55849),(-7.29444,29.20726,2.5995),(-7.18763,29.21848,2.58104),(-7.26466,29.20108,2.6345),(-6.98909,29.13034,2.58267),(-7.05814,29.17336,2.55282),(-7.42154,29.12396,2.52486),(-7.31131,29.15843,2.44688),(-7.32067,29.1829,2.51448),(-7.44966,29.04885,2.50287),(-7.48339,28.99631,2.5721),(-7.46764,29.06869,2.55218),(-7.40298,29.07918,2.69054),(-7.36749,29.15912,2.65182),(-7.03471,28.97106,2.41242),(-7.26477,28.90915,2.44507),(-7.16945,28.8882,2.37462),(-7.24431,28.86629,2.44431),(-7.41935,28.86762,2.56154),(-7.49769,28.92458,2.58166),(-7.47883,28.99095,2.56824),(-7.44687,29.0393,2.49912),(-7.31677,28.41151,2.76316),(-7.26936,28.3964,2.76601),(-7.32978,28.43074,2.81841),(-7.36229,28.40862,2.66025),(-7.31128,28.39426,2.66052),(-7.3481,28.42739,2.75795),(-7.59442,28.50893,2.86134),(-7.49252,28.47663,2.79805),(-7.58799,28.46993,2.75034),(-7.69073,28.46778,2.71895),(-7.5848,28.45451,2.66014),(-7.65617,28.4962,2.78865),(-7.38809,28.39786,2.51873),(-7.38072,28.38838,2.53158),(-7.31755,28.40511,2.50845),(-7.11026,28.33043,2.55013),(-7.18542,28.29739,2.63401),(-7.22086,28.48585,2.82843),(-7.29543,28.52372,2.91771),(-7.32541,28.43734,2.82951),(-7.48919,28.5898,2.94183),(-7.56288,28.62156,2.83483),(-7.59458,28.51844,2.87109),(-7.37176,28.57148,2.985),(-7.60208,28.67799,2.68054),(-7.69474,28.47507,2.71993),(-7.66022,28.50449,2.78822),(-7.58824,28.63594,2.75717),(-7.48895,28.66194,2.86622),(-7.3551,28.7556,2.89192),(-7.3999,28.71667,2.95513),(-7.44424,28.8822,2.67747),(-7.50659,28.89378,2.58976),(-7.53797,28.83223,2.62566),(-7.29203,28.66059,2.94363),(-7.32505,28.81031,2.80317),(-7.23398,28.74035,2.83104),(-7.07531,28.52288,2.85149),(-7.0265,28.42015,2.77466),(-7.02413,28.61462,2.71066),(-7.13623,28.77959,2.83688),(-7.0735,28.74785,2.77867),(-7.5064,28.88702,2.58444),(-7.46265,28.80219,2.58067),(-7.53781,28.82714,2.6186),(-7.49511,28.74673,2.59067),(-7.38156,28.78644,2.52643),(-7.39548,28.80628,2.54221),(-7.2681,28.47722,2.50494),(-7.28555,28.79441,2.47362),(-7.31617,28.76765,2.49368),(-7.18594,28.79781,2.41646),(-7.25962,28.70008,2.46275),(-7.25151,28.68838,2.45874),(-7.03647,28.46299,2.51011),(-7.16317,28.54612,2.44157),(-7.20588,28.54015,2.45777),(-7.17769,28.45584,2.45271),(-7.03615,28.90873,2.43758),(-7.03229,28.82153,2.45632),(-6.93671,28.51476,2.61381),(-6.92687,28.42715,2.60283),(-6.94165,28.52753,2.61484),(-6.97664,28.5775,2.61473),(-6.93149,28.41843,2.59529),(-7.36686,28.76677,2.51224),(-7.3643,28.44857,2.5166),(-7.40954,28.7189,2.53697),(-7.43299,28.73945,2.55143),(-7.61832,28.66501,2.60423),(-6.99622,28.67932,2.60938),(-7.01627,28.42562,2.77145),(-7.39132,28.87348,2.73758),(-7.26853,28.36704,2.68634),(-7.31073,29.04342,2.39036),(-7.23476,29.02452,2.36381),(-7.04173,29.02417,2.39506),(-7.23572,28.83544,2.82124),(-7.23431,28.89424,2.8215),(-7.05056,29.12056,2.40826),(-7.08928,29.16935,2.44724),(-7.0875,29.14611,2.68998),(-7.04519,29.14321,2.657),(-7.10284,29.19496,2.57994),(-7.22633,29.22667,2.51182),(-7.16343,29.21703,2.50536),(-7.28435,29.13328,2.38481),(-7.30848,29.05462,2.38602),(-7.18238,29.20925,2.47245),(-7.19247,29.21763,2.49236),(-7.09191,28.66979,2.44357),(-7.0415,28.95929,2.41294),(-6.99639,28.93587,2.44502),(-6.94165,29.02911,2.53491),(-6.93133,28.95668,2.53829),(-7.36463,28.62605,2.51324),(-7.4041,28.59437,2.52454),(-7.39343,28.64209,2.52593),(-7.19138,29.0005,2.36042),(-7.23681,28.5242,2.4818),(-7.37899,28.50016,2.5293),(-7.35118,28.46877,2.52282),(-7.51975,28.4348,2.62454),(-7.46518,28.40517,2.59212),(-7.49792,28.44529,2.71064),(-7.4364,28.42771,2.68234),(-7.37029,28.38582,2.5507),(-7.41292,28.44921,2.77125),(-7.23491,29.19504,2.66955),(-7.32397,28.92373,2.78672),(-7.33112,28.98218,2.78942),(-7.38161,28.92997,2.73395),(-7.37768,28.98301,2.73713),(-7.4329,28.93484,2.67696),(-7.50054,28.92534,2.58854),(-6.98702,28.94747,2.70335),(-7.03998,28.97453,2.74485),(-7.00909,29.13292,2.61858),(-7.50394,28.89261,2.58307),(-7.11057,28.91184,2.80236),(-7.39478,28.58494,2.52293),(-7.40273,28.57942,2.52312),(-7.68036,28.4931,2.52888),(-7.3803,28.56401,2.53069),(-7.59395,28.68317,2.68523),(-7.53452,28.45103,2.54837),(-7.53351,28.46022,2.54236),(-7.48585,28.42617,2.5363),(-7.67775,28.47988,2.61968),(-7.31983,28.66687,2.49869),(-7.59902,28.48146,2.53676),(-7.37609,28.99601,2.73699),(-7.32827,28.99556,2.78976),(-7.02353,28.69761,2.68405),(-7.1663,29.19529,2.44158),(-7.21835,29.12436,2.35951),(-6.94773,28.86576,2.62226),(-6.94059,28.95209,2.62737),(-6.98008,29.03519,2.67551),(-6.94241,29.03678,2.61033),(-7.02753,29.04846,2.71678),(-7.29314,29.13704,2.73359),(-7.3303,29.14797,2.69267),(-7.36165,29.07769,2.7297),(-7.32036,29.07641,2.76895),(-7.32037,28.86012,2.79244),(-7.24849,28.33264,2.59367),(-7.52865,28.43844,2.58314),(-7.47703,28.41144,2.56082),(-7.38434,28.6975,2.52815),(-7.31921,28.56738,2.51502),(-7.32735,28.59222,2.50664),(-7.09187,29.02203,2.36307),(-7.09992,28.54282,2.46131),(-7.10316,29.18407,2.46609),(-7.08043,29.18665,2.54125),(-7.07369,29.18446,2.514),(-7.14188,29.21128,2.5665),(-7.11269,29.20237,2.56084),(-7.1745,29.21945,2.56165),(-7.19589,29.22734,2.54576),(-7.20164,29.22547,2.51287),(-7.1998,29.20284,2.4562),(-7.14283,29.20719,2.58768),(-7.21353,29.21584,2.48324),(-7.17355,29.17448,2.70298),(-7.19633,29.10708,2.7722),(-7.08174,29.05806,2.74993),(-7.21356,29.04361,2.80157),(-7.0994,29.00071,2.77721),(-7.02782,28.6741,2.47684),(-7.03607,28.54026,2.4858),(-7.44469,28.59346,2.53335)]))),
        Shape(DEF='rscphoid',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rscphoid_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,4,3,-1,7,8,9,-1,10,8,11,-1,12,13,14,-1,12,15,13,-1,16,17,18,-1,16,19,17,-1,20,21,22,-1,22,23,20,-1,24,25,26,-1,24,27,25,-1,28,29,20,-1,20,23,28,-1,30,31,32,-1,31,33,32,-1,34,35,36,-1,37,38,39,-1,40,41,39,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,41,52,-1,53,54,55,-1,56,54,57,-1,58,54,59,-1,60,54,61,-1,62,63,64,-1,65,66,67,-1,65,68,66,-1,69,70,71,-1,72,73,74,-1,74,75,72,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,83,9,84,-1,9,26,7,-1,0,85,86,-1,87,88,89,-1,89,90,87,-1,91,87,92,-1,93,94,95,-1,28,23,96,-1,23,97,96,-1,98,30,99,-1,100,101,93,-1,102,93,103,-1,104,93,105,-1,106,93,107,-1,95,108,93,-1,109,93,110,-1,111,93,112,-1,113,114,99,-1,115,116,117,-1,116,118,117,-1,117,118,77,-1,5,4,119,-1,5,120,121,-1,11,26,122,-1,79,52,123,-1,52,124,51,-1,125,126,127,-1,128,129,130,-1,130,131,128,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,138,141,139,-1,142,143,144,-1,14,21,20,-1,20,12,14,-1,19,145,17,-1,19,146,145,-1,147,148,18,-1,148,16,18,-1,149,150,151,-1,151,98,149,-1,32,152,153,-1,154,153,152,-1,154,155,153,-1,1,156,154,-1,143,86,157,-1,158,48,50,-1,159,160,161,-1,159,162,160,-1,163,158,164,-1,163,36,158,-1,165,166,167,-1,168,169,170,-1,170,171,168,-1,75,172,168,-1,168,72,75,-1,173,174,175,-1,173,2,174,-1,74,174,176,-1,177,178,179,-1,178,69,179,-1,71,179,69,-1,180,179,71,-1,180,181,179,-1,71,33,81,-1,71,32,33,-1,82,182,183,-1,82,81,24,-1,81,33,24,-1,37,39,184,-1,185,186,38,-1,186,40,38,-1,187,188,189,-1,187,190,188,-1,36,163,34,-1,35,191,192,-1,193,165,192,-1,194,195,193,-1,193,192,194,-1,196,197,195,-1,197,198,195,-1,40,186,199,-1,186,83,199,-1,186,182,83,-1,197,143,157,-1,197,144,143,-1,173,175,200,-1,157,85,198,-1,24,9,82,-1,24,26,9,-1,123,41,40,-1,196,194,201,-1,194,191,201,-1,194,196,195,-1,167,192,165,-1,191,194,192,-1,35,167,36,-1,35,192,167,-1,202,51,124,-1,202,203,51,-1,40,39,38,-1,185,38,37,-1,162,37,160,-1,185,37,43,-1,152,32,71,-1,44,204,42,-1,70,152,71,-1,205,152,70,-1,205,206,152,-1,177,181,207,-1,177,179,181,-1,2,176,174,-1,73,174,74,-1,72,168,171,-1,171,208,72,-1,163,164,188,-1,209,188,164,-1,189,188,209,-1,210,45,47,-1,211,212,213,-1,214,215,89,-1,216,217,96,-1,217,218,96,-1,85,157,86,-1,155,154,88,-1,154,156,88,-1,93,111,219,-1,206,154,152,-1,206,1,154,-1,149,98,114,-1,98,99,114,-1,121,220,3,-1,220,6,3,-1,220,16,148,-1,148,6,220,-1,17,21,14,-1,17,145,21,-1,221,143,142,-1,191,127,126,-1,67,133,136,-1,136,65,67,-1,222,134,133,-1,55,54,223,-1,118,224,78,-1,118,64,224,-1,225,54,226,-1,223,54,225,-1,125,127,124,-1,52,125,124,-1,52,41,123,-1,121,3,5,-1,77,5,119,-1,117,77,119,-1,117,119,115,-1,89,215,90,-1,92,215,218,-1,92,90,215,-1,23,22,227,-1,227,97,23,-1,112,93,109,-1,228,93,108,-1,94,93,106,-1,107,93,104,-1,105,93,102,-1,103,93,101,-1,99,30,113,-1,96,97,216,-1,97,229,216,-1,228,110,93,-1,92,87,90,-1,88,156,214,-1,214,89,88,-1,93,219,100,-1,221,20,29,-1,182,9,83,-1,182,82,9,-1,78,77,118,-1,205,70,69,-1,69,178,205,-1,222,131,134,-1,230,125,52,-1,140,231,232,-1,233,68,65,-1,65,234,233,-1,226,54,60,-1,61,54,58,-1,59,54,56,-1,57,54,53,-1,189,184,187,-1,189,160,184,-1,203,41,51,-1,203,39,41,-1,82,183,80,-1,170,235,236,-1,170,237,235,-1,198,197,157,-1,37,184,160,-1,40,199,123,-1,188,190,163,-1,25,238,26,-1,238,122,26,-1,153,155,113,-1,33,27,24,-1,33,31,27,-1,22,21,145,-1,145,239,22,-1,8,7,11,-1,19,220,240,-1,19,16,220,-1,18,14,13,-1,18,17,14,-1,11,7,26,-1,241,144,197,-1,242,201,191,-1,10,120,8,-1,10,121,120,-1,46,45,209,-1,209,50,46,-1,45,210,161,-1,161,209,45,-1,161,211,159,-1,161,210,211,-1,205,75,74,-1,178,75,205,-1,159,213,243,-1,159,211,213,-1,244,245,207,-1,244,246,245,-1,75,177,172,-1,177,75,178,-1,165,247,248,-1,193,247,165,-1,50,235,46,-1,49,235,50,-1,200,195,198,-1,200,249,195,-1,248,166,165,-1,248,236,166,-1,6,119,4,-1,6,115,119,-1,250,148,147,-1,250,251,148,-1,128,252,129,-1,252,128,253,-1,254,255,256,-1,255,254,257,-1,201,258,259,-1,201,242,258,-1,121,240,220,-1,121,10,240,-1,15,142,260,-1,15,12,142,-1,86,214,156,-1,86,261,214,-1,239,146,262,-1,239,145,146,-1,263,264,265,-1,264,263,266,-1,153,30,32,-1,153,113,30,-1,0,156,1,-1,156,0,86,-1,267,170,169,-1,267,237,170,-1,204,207,181,-1,204,244,207,-1,180,183,42,-1,80,183,180,-1,39,187,184,-1,187,39,203,-1,209,160,189,-1,209,161,160,-1,225,268,269,-1,226,268,225,-1,270,141,271,-1,139,141,270,-1,224,272,273,-1,224,274,272,-1,275,276,277,-1,275,278,276,-1,234,231,233,-1,232,231,234,-1,140,268,231,-1,139,268,140,-1,126,230,279,-1,126,125,230,-1,280,281,282,-1,281,280,283,-1,284,137,285,-1,137,284,135,-1,134,130,132,-1,134,131,130,-1,12,221,142,-1,12,20,221,-1,266,286,264,-1,287,286,266,-1,288,219,289,-1,100,219,288,-1,110,216,229,-1,216,110,228,-1,151,27,31,-1,290,27,151,-1,291,238,25,-1,292,238,291,-1,264,293,262,-1,293,264,286,-1,227,239,294,-1,227,22,239,-1,96,215,28,-1,96,218,215,-1,150,290,151,-1,150,295,290,-1,88,296,155,-1,88,87,296,-1,297,293,298,-1,293,297,294,-1,222,251,250,-1,251,222,299,-1,299,115,251,-1,299,116,115,-1,199,84,300,-1,199,83,84,-1,11,263,10,-1,11,122,263,-1,271,230,52,-1,230,271,141,-1,76,270,271,-1,76,273,270,-1,269,139,270,-1,268,139,269,-1,78,273,76,-1,78,224,273,-1,63,55,274,-1,63,53,55,-1,116,64,118,-1,116,62,64,-1,57,63,278,-1,63,57,53,-1,56,278,275,-1,56,57,278,-1,68,59,66,-1,68,58,59,-1,60,233,231,-1,233,60,61,-1,133,277,222,-1,277,133,67,-1,256,285,254,-1,285,256,284,-1,232,301,302,-1,301,232,234,-1,283,301,281,-1,283,302,301,-1,126,242,191,-1,242,126,280,-1,242,282,258,-1,280,282,242,-1,260,255,257,-1,260,241,255,-1,240,146,19,-1,240,265,146,-1,303,97,227,-1,303,229,97,-1,286,298,293,-1,286,289,298,-1,291,304,292,-1,291,305,304,-1,114,104,149,-1,104,114,107,-1,102,305,295,-1,103,305,102,-1,304,100,288,-1,304,101,100,-1,297,109,303,-1,109,297,112,-1,228,217,216,-1,108,217,228,-1,87,106,296,-1,106,87,94,-1,143,29,306,-1,29,143,221,-1,217,92,218,-1,217,91,92,-1,212,237,267,-1,237,212,47,-1,267,213,212,-1,267,246,213,-1,47,211,210,-1,47,212,211,-1,244,44,243,-1,244,204,44,-1,164,50,209,-1,158,50,164,-1,208,248,247,-1,248,208,171,-1,73,208,307,-1,73,72,208,-1,174,307,175,-1,73,307,174,-1,183,43,42,-1,183,185,43,-1,43,162,44,-1,37,162,43,-1,203,190,187,-1,190,203,202,-1,34,124,127,-1,202,124,34,-1,201,197,196,-1,197,201,259,-1,259,241,197,-1,259,255,241,-1,127,35,34,-1,127,191,35,-1,163,202,34,-1,202,163,190,-1,182,185,183,-1,182,186,185,-1,71,80,180,-1,71,81,80,-1,249,175,307,-1,249,200,175,-1,245,168,172,-1,168,245,169,-1,247,307,208,-1,247,249,307,-1,171,236,248,-1,236,171,170,-1,158,167,48,-1,36,167,158,-1,162,243,44,-1,159,243,162,-1,47,235,237,-1,46,235,47,-1,143,261,86,-1,306,261,143,-1,108,91,217,-1,91,108,95,-1,229,109,110,-1,303,109,229,-1,103,304,305,-1,101,304,103,-1,104,150,149,-1,105,150,104,-1,296,107,114,-1,296,106,107,-1,295,291,290,-1,305,291,295,-1,292,288,287,-1,292,304,288,-1,303,294,297,-1,294,303,227,-1,13,147,18,-1,13,253,147,-1,252,13,15,-1,253,13,252,-1,284,258,282,-1,284,256,258,-1,138,283,279,-1,138,302,283,-1,281,136,135,-1,136,281,301,-1,140,302,138,-1,302,140,232,-1,234,136,301,-1,136,234,65,-1,254,130,129,-1,254,285,130,-1,133,137,136,-1,137,133,132,-1,226,231,268,-1,231,226,60,-1,61,68,233,-1,68,61,58,-1,66,56,275,-1,66,59,56,-1,277,299,222,-1,299,277,276,-1,276,116,299,-1,116,276,62,-1,279,141,138,-1,230,141,279,-1,123,300,79,-1,199,300,123,-1,10,265,240,-1,10,263,265,-1,120,300,84,-1,120,5,300,-1,79,5,77,-1,79,300,5,-1,131,250,128,-1,250,131,222,-1,298,112,297,-1,111,112,298,-1,155,114,113,-1,155,296,114,-1,105,295,150,-1,105,102,295,-1,262,294,239,-1,294,262,293,-1,292,266,238,-1,287,266,292,-1,25,290,291,-1,25,27,290,-1,98,31,30,-1,151,31,98,-1,289,111,298,-1,111,289,219,-1,95,87,91,-1,95,94,87,-1,287,289,286,-1,288,289,287,-1,15,257,252,-1,257,15,260,-1,8,84,9,-1,84,8,120,-1,79,271,52,-1,271,79,76,-1,132,285,137,-1,132,130,285,-1,282,135,284,-1,135,282,281,-1,279,280,126,-1,283,280,279,-1,67,275,277,-1,67,66,275,-1,278,62,276,-1,278,63,62,-1,64,274,224,-1,64,63,274,-1,273,269,270,-1,273,272,269,-1,272,225,269,-1,225,272,223,-1,274,223,272,-1,223,274,55,-1,181,42,204,-1,180,42,181,-1,246,169,245,-1,246,267,169,-1,166,48,167,-1,166,49,48,-1,306,28,215,-1,306,29,28,-1,1,176,2,-1,1,206,176,-1,238,263,122,-1,266,263,238,-1,265,262,146,-1,262,265,264,-1,215,261,306,-1,214,261,215,-1,74,206,205,-1,74,176,206,-1,142,241,260,-1,144,241,142,-1,259,256,255,-1,259,258,256,-1,257,129,252,-1,257,254,129,-1,128,147,253,-1,128,250,147,-1,115,148,251,-1,148,115,6,-1,195,247,193,-1,249,247,195,-1,85,200,198,-1,173,200,85,-1,49,236,235,-1,49,166,236,-1,173,0,2,-1,173,85,0,-1,172,207,245,-1,207,172,177,-1,243,246,244,-1,243,213,246,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rscphoid_Coord',point=[(-7.15497,28.97097,2.87054),(-7.15169,28.952,2.86409),(-7.14941,28.95592,2.87413),(-7.14698,29.23543,2.16625),(-7.14511,29.24337,2.15571),(-6.99467,29.18349,2.26508),(-7.23595,29.32662,2.18101),(-7.0415,29.10256,2.33488),(-7.03767,29.1223,2.31465),(-6.98798,29.03305,2.45539),(-7.13543,29.20499,2.28945),(-7.05626,29.1086,2.3335),(-7.34033,29.31487,2.66913),(-7.37378,29.35175,2.58495),(-7.373,29.32941,2.5858),(-7.33714,29.34381,2.66284),(-7.30695,29.31745,2.36473),(-7.34889,29.31665,2.46993),(-7.35372,29.34533,2.46367),(-7.30071,29.29339,2.38137),(-7.35162,29.23138,2.6903),(-7.36879,29.24334,2.59687),(-7.36335,29.23622,2.59686),(-7.34796,29.22785,2.68659),(-6.98935,28.95881,2.54513),(-7.02636,29.02229,2.41933),(-7.02379,29.02447,2.41282),(-6.99568,28.96196,2.54715),(-7.34957,29.16921,2.71639),(-7.35119,29.17131,2.72076),(-7.04383,28.87746,2.67503),(-7.01625,28.90591,2.61873),(-7.044,28.8687,2.67947),(-7.01084,28.90062,2.61719),(-6.70758,29.11388,2.76672),(-6.75642,29.11711,2.85157),(-6.70243,29.04076,2.84801),(-6.70271,28.88199,2.58388),(-6.78251,28.94902,2.58028),(-6.72502,29.02053,2.61174),(-6.82647,29.03678,2.53701),(-6.80384,29.10718,2.58812),(-6.89317,28.80107,2.61007),(-6.79025,28.85196,2.58697),(-6.75633,28.69287,2.66377),(-6.55337,28.83284,2.77153),(-6.58177,28.85331,2.82583),(-6.63822,28.77031,2.80316),(-6.64781,28.93229,2.88506),(-6.67347,28.90194,2.92085),(-6.58318,28.86134,2.82933),(-6.7784,29.14817,2.62465),(-6.83171,29.20473,2.50615),(-7.07343,29.40029,2.3249),(-7.05719,29.40931,2.37671),(-7.02843,29.37375,2.33708),(-7.10843,29.42925,2.39675),(-7.10674,29.42093,2.36502),(-7.06515,29.42359,2.4408),(-7.08747,29.43162,2.43165),(-7.01703,29.40653,2.43583),(-7.04293,29.41923,2.4437),(-7.12133,29.3834,2.24774),(-7.09293,29.38403,2.27503),(-7.08407,29.35849,2.24319),(-7.0805,29.43495,2.54386),(-7.11927,29.44595,2.4885),(-7.14072,29.44966,2.50967),(-7.07357,29.42946,2.50652),(-7.0358,28.72955,2.82646),(-7.0624,28.74172,2.82992),(-6.99878,28.84086,2.69952),(-7.00374,28.77576,2.93508),(-7.0561,28.82443,2.93954),(-7.07466,28.72726,2.89327),(-7.02457,28.70766,2.8869),(-6.9198,29.25972,2.34598),(-6.97382,29.25464,2.24873),(-6.99001,29.29367,2.27377),(-6.89401,29.21253,2.34718),(-6.94131,28.89994,2.58768),(-6.9656,28.91129,2.6155),(-6.96643,28.96895,2.53116),(-6.94116,29.05628,2.45523),(-6.95793,29.08699,2.40883),(-7.16787,29.07241,2.87824),(-7.19007,29.0744,2.85096),(-7.17962,29.07942,2.78656),(-7.19787,29.05783,2.81344),(-7.26972,29.07543,2.78486),(-7.259,29.09617,2.7691),(-7.20346,29.1042,2.76135),(-7.23218,29.10308,2.77),(-7.10354,29.08722,2.66084),(-7.14155,29.08316,2.72362),(-7.15254,29.09756,2.71293),(-7.29253,29.1596,2.71932),(-7.30029,29.19239,2.68516),(-7.03091,28.92458,2.68092),(-7.05826,28.9218,2.69849),(-7.10883,29.12168,2.56969),(-7.09075,29.10376,2.57956),(-7.0613,29.04773,2.6293),(-7.07667,29.07078,2.60425),(-7.06723,29.03339,2.67111),(-7.06386,29.03633,2.6491),(-7.11391,29.04279,2.71358),(-7.08827,29.02976,2.69246),(-7.16354,29.11198,2.70225),(-7.17266,29.13652,2.64782),(-7.17152,29.12844,2.67575),(-7.14507,29.14166,2.5897),(-7.15462,29.14667,2.61048),(-7.10351,28.90556,2.77092),(-7.07303,28.97257,2.72419),(-7.23112,29.33304,2.17774),(-7.15196,29.37607,2.22426),(-7.10153,29.27193,2.15685),(-7.07905,29.32749,2.21583),(-7.13409,29.266,2.144),(-7.02003,29.14733,2.29429),(-7.13137,29.21409,2.26194),(-7.07841,29.10307,2.35373),(-6.84363,29.14806,2.49238),(-6.7632,29.18756,2.66821),(-6.81602,29.26209,2.65538),(-6.83492,29.29035,2.72775),(-6.78293,29.21028,2.75254),(-7.36559,29.41217,2.56354),(-7.3378,29.41256,2.63129),(-7.24681,29.43922,2.58087),(-7.25049,29.4363,2.54147),(-7.20492,29.44737,2.55585),(-7.16266,29.44538,2.5302),(-7.20709,29.4459,2.53588),(-7.11824,29.41687,2.65033),(-7.08964,29.43277,2.58102),(-7.15363,29.43382,2.62149),(-6.88602,29.35596,2.59828),(-6.89554,29.34518,2.51639),(-6.93065,29.37961,2.5478),(-6.86137,29.31945,2.56152),(-7.27741,29.31583,2.73891),(-7.28691,29.20195,2.77814),(-7.21148,29.28186,2.78988),(-7.33975,29.26849,2.47888),(-7.28854,29.24863,2.41092),(-7.36276,29.40688,2.44825),(-7.32437,29.39201,2.3093),(-7.03094,28.97982,2.68148),(-7.02421,28.98569,2.63748),(-7.01314,28.94371,2.62873),(-7.12888,28.81366,2.83858),(-7.10716,28.89497,2.7784),(-7.14991,28.94744,2.82956),(-7.14038,28.97134,2.79465),(-7.18888,29.06173,2.84476),(-7.1709,29.16721,2.84515),(-6.62158,28.96587,2.84724),(-6.64124,28.73149,2.7181),(-6.57507,28.8325,2.67323),(-6.57894,28.79898,2.72733),(-6.65519,28.77203,2.64403),(-6.63173,29.04253,2.7864),(-6.5983,28.977,2.80193),(-6.79587,28.98133,2.95047),(-6.73227,28.94187,2.94165),(-6.73118,29.01532,2.87861),(-6.92991,28.73412,2.90966),(-6.85455,28.71661,2.88018),(-6.7976,28.81042,2.91832),(-6.8613,28.84235,2.93173),(-6.96862,28.70907,2.87592),(-7.16379,29.06895,2.88319),(-7.11084,28.8952,2.91929),(-7.1252,29.03154,2.9162),(-7.14022,28.83411,2.87723),(-6.97122,28.70766,2.86951),(-7.02617,28.70607,2.88101),(-7.00831,28.72083,2.82206),(-6.94975,28.81863,2.65081),(-6.92404,28.70845,2.7676),(-6.91244,28.97575,2.52351),(-6.90885,28.89564,2.56724),(-6.65269,28.94534,2.63291),(-6.84133,28.93325,2.56081),(-6.85879,28.99125,2.52006),(-6.64194,28.99602,2.67168),(-6.52672,28.92926,2.73889),(-6.55088,28.88078,2.70602),(-6.63948,29.04139,2.71816),(-6.82926,29.20157,2.8349),(-6.82517,29.09048,2.87839),(-6.88219,29.04456,2.9529),(-6.89797,29.15258,2.86584),(-7.00822,29.10587,2.93636),(-6.99061,29.16436,2.84992),(-7.11635,29.21838,2.82897),(-7.13544,29.12616,2.89932),(-6.89438,29.07967,2.45515),(-7.13344,29.11973,2.90279),(-6.95788,29.25575,2.85585),(-6.69633,29.09556,2.70595),(-6.70637,29.06076,2.65523),(-6.84245,28.67533,2.72735),(-7.07245,28.72098,2.88486),(-7.14264,28.83288,2.86702),(-6.89737,28.68622,2.82545),(-6.94399,28.88854,2.94552),(-6.55099,28.83843,2.76988),(-6.5809,28.79656,2.73396),(-6.64058,28.7299,2.72502),(-6.6796,28.70785,2.7622),(-6.71741,28.67662,2.72977),(-7.26781,29.07469,2.79694),(-7.32747,29.11703,2.75312),(-7.23353,29.14877,2.71473),(-7.22511,29.13267,2.74036),(-7.26971,29.12838,2.7502),(-7.12577,29.13224,2.57921),(-7.22042,29.27704,2.28377),(-7.32045,29.21558,2.7332),(-7.25961,29.44319,2.44377),(-6.99998,29.36054,2.35983),(-6.99556,29.31564,2.28431),(-6.98564,29.36673,2.39611),(-6.99406,29.3898,2.42174),(-7.30475,29.21957,2.60703),(-7.16753,29.1202,2.68899),(-7.24195,29.16522,2.68885),(-6.83422,29.29316,2.60781),(-6.97925,29.39657,2.49811),(-6.9487,29.38654,2.56166),(-7.02869,29.42078,2.513),(-7.01576,29.41361,2.56852),(-6.67597,28.89596,2.92159),(-6.73504,28.93634,2.94334),(-6.74024,28.78764,2.88571),(-7.08228,29.10387,2.36272),(-7.33408,29.26165,2.48267),(-7.21807,29.26148,2.30914),(-7.19422,29.30626,2.7909),(-6.9531,29.26594,2.84995),(-6.7206,28.67638,2.7233),(-6.82533,28.65314,2.78621),(-6.8937,28.68689,2.83124),(-6.82154,28.65425,2.79187),(-6.88555,29.0395,2.95532),(-6.7982,28.97538,2.9526),(-7.01089,29.10051,2.93904),(-7.35665,29.41604,2.44627),(-7.31982,29.40027,2.3077),(-7.34544,29.40328,2.63514),(-7.37283,29.40303,2.56478),(-7.25283,29.3993,2.72266),(-7.17096,29.35183,2.78874),(-7.16329,29.36065,2.78268),(-7.25973,29.39034,2.72866),(-7.07398,29.31482,2.82647),(-7.07989,29.30516,2.83243),(-7.27034,29.34522,2.73469),(-7.26856,29.08215,2.802),(-7.28339,29.24281,2.41777),(-7.14871,29.1656,2.34862),(-7.21357,29.21517,2.37338),(-7.21653,29.21956,2.36412),(-7.14829,29.16308,2.35863),(-6.7873,28.69801,2.84034),(-6.9355,29.3659,2.47339),(-6.92219,29.31819,2.42399),(-6.89613,29.29117,2.44318),(-6.87387,29.26266,2.46391),(-6.95171,29.30425,2.34702),(-6.93417,29.28317,2.34573),(-7.00623,29.33285,2.2989),(-7.16034,29.4409,2.41897),(-7.19698,29.42588,2.33886),(-7.21001,29.44596,2.43077),(-7.15704,29.42413,2.35493),(-6.85722,29.32693,2.66382),(-6.92449,29.30619,2.77049),(-7.02328,29.37536,2.69586),(-7.04357,29.34297,2.76429),(-6.92106,29.34199,2.69976),(-7.1489,29.39194,2.71587),(-7.20165,29.41711,2.6731),(-7.17833,29.20302,2.43293),(-7.12984,29.16728,2.41749),(-7.11362,29.15299,2.48846),(-7.14808,29.17786,2.49781),(-7.00001,28.98505,2.57211),(-7.03109,29.04011,2.48163),(-7.08023,29.12418,2.42147),(-7.23394,29.22687,2.46644),(-7.27001,29.24153,2.52127),(-7.01912,29.0085,2.5979),(-7.12431,28.99866,2.76644),(-7.20577,29.2067,2.56033),(-7.18668,29.19674,2.51881),(-7.23737,29.42004,2.3252),(-6.92796,29.1413,2.36247),(-7.00551,29.3991,2.62307),(-6.92128,29.36937,2.62499),(-7.24185,29.1863,2.63502),(-7.07804,29.12074,2.4985),(-7.04984,29.05458,2.5478),(-7.33032,29.122,2.75406),(-7.03684,28.95842,2.94108)]))),
        Shape(DEF='rhamate',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rhamate_Geo',coordIndex=[0,1,2,-1,2,3,0,-1,4,5,6,-1,4,7,5,-1,8,9,10,-1,11,12,13,-1,12,14,13,-1,15,16,17,-1,18,19,20,-1,18,21,19,-1,22,21,18,-1,18,23,22,-1,24,25,26,-1,27,28,29,-1,27,30,28,-1,31,32,33,-1,32,34,33,-1,34,35,33,-1,35,36,33,-1,37,38,39,-1,39,40,37,-1,41,42,43,-1,41,44,42,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,42,52,53,-1,53,43,42,-1,54,1,55,-1,54,56,1,-1,57,58,59,-1,57,60,58,-1,61,62,63,-1,61,64,62,-1,31,33,65,-1,49,66,67,-1,5,68,6,-1,69,70,71,-1,72,73,74,-1,73,75,74,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,83,84,85,-1,84,86,85,-1,87,88,89,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,96,97,94,-1,41,43,98,-1,18,99,23,-1,100,101,102,-1,100,64,101,-1,103,88,104,-1,105,106,107,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,3,80,82,-1,3,115,80,-1,116,117,118,-1,119,120,118,-1,121,122,118,-1,118,107,123,-1,37,123,124,-1,125,118,126,-1,15,118,127,-1,125,67,66,-1,125,126,67,-1,128,129,130,-1,128,131,129,-1,20,25,132,-1,133,94,134,-1,94,97,134,-1,96,135,136,-1,136,97,96,-1,137,138,135,-1,138,139,135,-1,140,51,141,-1,141,98,140,-1,142,143,144,-1,142,145,143,-1,146,147,148,-1,47,149,150,-1,150,45,47,-1,151,55,1,-1,152,153,72,-1,72,74,152,-1,154,155,156,-1,154,157,155,-1,55,158,159,-1,158,160,159,-1,46,161,59,-1,162,163,148,-1,162,164,163,-1,165,19,21,-1,21,166,165,-1,84,167,168,-1,168,86,84,-1,169,170,171,-1,169,168,170,-1,172,173,174,-1,174,4,172,-1,88,175,176,-1,88,103,177,-1,88,178,179,-1,88,180,181,-1,35,182,183,-1,35,184,182,-1,88,87,185,-1,90,30,186,-1,186,93,90,-1,88,185,180,-1,88,181,178,-1,88,179,104,-1,88,177,175,-1,187,188,34,-1,34,32,187,-1,176,89,88,-1,189,190,191,-1,191,192,189,-1,7,4,174,-1,193,50,194,-1,193,195,50,-1,196,166,22,-1,166,21,22,-1,99,9,23,-1,163,131,148,-1,197,57,59,-1,59,161,197,-1,198,199,200,-1,198,201,199,-1,200,46,48,-1,200,161,46,-1,202,201,203,-1,202,204,201,-1,205,206,207,-1,151,208,153,-1,2,1,52,-1,158,55,209,-1,210,148,147,-1,210,162,148,-1,145,53,56,-1,145,142,53,-1,98,43,211,-1,96,137,135,-1,96,212,137,-1,130,132,25,-1,130,129,132,-1,66,49,111,-1,111,110,66,-1,213,118,125,-1,214,126,118,-1,107,124,123,-1,107,106,124,-1,107,118,122,-1,120,121,118,-1,117,119,118,-1,19,165,215,-1,215,26,19,-1,73,216,75,-1,216,68,75,-1,217,218,171,-1,171,219,217,-1,73,77,220,-1,220,216,73,-1,105,11,191,-1,191,190,105,-1,221,152,74,-1,222,223,224,-1,224,225,222,-1,125,66,110,-1,98,226,140,-1,227,228,229,-1,229,230,227,-1,61,71,231,-1,61,69,71,-1,232,18,20,-1,209,151,153,-1,153,152,209,-1,212,26,233,-1,212,24,26,-1,145,56,54,-1,234,220,77,-1,77,79,234,-1,28,30,90,-1,90,217,28,-1,118,123,214,-1,75,207,221,-1,221,74,75,-1,204,235,236,-1,71,70,237,-1,210,58,162,-1,213,127,118,-1,210,47,46,-1,108,138,238,-1,108,226,138,-1,51,195,141,-1,51,50,195,-1,67,50,49,-1,67,194,50,-1,194,40,39,-1,194,67,40,-1,94,128,130,-1,130,95,94,-1,118,15,116,-1,25,95,130,-1,25,24,95,-1,55,151,209,-1,98,141,41,-1,115,3,2,-1,32,239,240,-1,240,241,32,-1,190,189,242,-1,227,189,192,-1,189,227,230,-1,172,243,173,-1,172,223,243,-1,173,191,174,-1,173,192,191,-1,230,240,189,-1,230,241,240,-1,44,141,195,-1,141,44,41,-1,232,99,18,-1,99,232,102,-1,96,24,212,-1,24,96,95,-1,215,233,26,-1,17,233,215,-1,128,133,146,-1,128,94,133,-1,210,149,47,-1,147,149,210,-1,36,183,244,-1,36,35,183,-1,245,38,37,-1,38,245,246,-1,137,238,138,-1,137,247,238,-1,111,226,108,-1,226,111,140,-1,248,159,249,-1,248,250,159,-1,251,14,8,-1,251,155,14,-1,101,252,10,-1,252,101,231,-1,155,13,14,-1,157,13,155,-1,253,31,65,-1,253,254,31,-1,172,93,186,-1,93,172,4,-1,242,124,106,-1,242,255,124,-1,256,213,109,-1,256,127,213,-1,60,162,58,-1,162,60,164,-1,206,154,156,-1,206,205,154,-1,257,70,258,-1,237,70,257,-1,259,204,202,-1,259,235,204,-1,260,207,261,-1,221,207,260,-1,40,123,37,-1,214,123,40,-1,29,262,27,-1,29,263,262,-1,92,234,218,-1,234,92,220,-1,90,218,217,-1,218,90,92,-1,208,1,0,-1,1,208,151,-1,228,104,229,-1,228,103,104,-1,179,187,264,-1,187,179,178,-1,188,180,184,-1,188,181,180,-1,182,87,263,-1,182,185,87,-1,176,222,225,-1,222,176,175,-1,160,249,159,-1,249,160,198,-1,163,265,266,-1,163,164,265,-1,63,69,61,-1,63,267,69,-1,199,161,200,-1,197,161,199,-1,15,256,16,-1,15,127,256,-1,246,84,38,-1,167,84,246,-1,27,225,224,-1,262,225,27,-1,205,75,68,-1,205,207,75,-1,157,5,7,-1,5,157,154,-1,72,208,78,-1,72,153,208,-1,220,91,216,-1,220,92,91,-1,170,219,171,-1,268,219,170,-1,80,269,85,-1,80,115,269,-1,197,236,267,-1,199,236,197,-1,12,105,114,-1,12,11,105,-1,107,114,105,-1,107,122,114,-1,112,120,196,-1,112,121,120,-1,165,119,117,-1,166,119,165,-1,214,67,126,-1,40,67,214,-1,270,271,136,-1,270,144,271,-1,211,139,98,-1,270,139,211,-1,53,211,43,-1,142,211,53,-1,150,271,272,-1,271,150,134,-1,143,248,272,-1,248,143,250,-1,273,209,152,-1,209,273,158,-1,3,76,0,-1,3,82,76,-1,206,261,207,-1,206,258,261,-1,237,251,252,-1,257,251,237,-1,260,203,273,-1,260,202,203,-1,69,259,70,-1,259,69,235,-1,203,198,160,-1,203,201,198,-1,204,199,201,-1,204,236,199,-1,131,266,129,-1,131,163,266,-1,64,265,62,-1,64,100,265,-1,274,102,232,-1,102,274,100,-1,129,274,132,-1,129,266,274,-1,81,234,79,-1,81,169,234,-1,268,244,219,-1,268,36,244,-1,169,218,234,-1,169,171,218,-1,115,44,269,-1,115,42,44,-1,6,216,91,-1,216,6,68,-1,255,189,240,-1,255,242,189,-1,4,91,93,-1,4,6,91,-1,243,228,227,-1,243,275,228,-1,245,240,239,-1,245,255,240,-1,183,263,29,-1,183,182,263,-1,34,184,35,-1,34,188,184,-1,229,241,230,-1,241,229,264,-1,223,275,243,-1,223,222,275,-1,167,170,168,-1,167,253,170,-1,42,2,52,-1,2,42,115,-1,28,219,244,-1,217,219,28,-1,268,33,36,-1,268,65,33,-1,86,169,81,-1,86,168,169,-1,232,132,274,-1,232,20,132,-1,266,100,274,-1,266,265,100,-1,62,164,60,-1,62,265,164,-1,70,261,258,-1,261,70,259,-1,273,160,158,-1,160,273,203,-1,231,237,252,-1,237,231,71,-1,257,155,251,-1,156,155,257,-1,273,221,260,-1,273,152,221,-1,143,54,250,-1,54,143,145,-1,45,272,248,-1,45,150,272,-1,149,134,150,-1,134,149,133,-1,272,144,143,-1,144,272,271,-1,139,226,98,-1,138,226,139,-1,211,144,270,-1,142,144,211,-1,139,136,135,-1,139,270,136,-1,134,136,271,-1,134,97,136,-1,247,17,16,-1,233,17,247,-1,146,131,128,-1,146,148,131,-1,16,238,247,-1,238,16,256,-1,215,117,116,-1,215,165,117,-1,119,196,120,-1,196,119,166,-1,114,121,112,-1,114,122,121,-1,9,276,23,-1,276,9,8,-1,12,8,14,-1,8,12,276,-1,167,254,253,-1,167,246,254,-1,85,193,83,-1,193,85,269,-1,113,196,22,-1,112,196,113,-1,194,83,193,-1,83,194,39,-1,125,109,213,-1,125,110,109,-1,267,235,69,-1,236,235,267,-1,57,267,63,-1,57,197,267,-1,198,48,249,-1,198,200,48,-1,222,177,275,-1,222,175,177,-1,89,225,262,-1,176,225,89,-1,184,185,182,-1,184,180,185,-1,178,188,187,-1,188,178,181,-1,104,264,229,-1,264,104,179,-1,275,103,228,-1,275,177,103,-1,78,0,76,-1,0,78,208,-1,87,262,263,-1,87,89,262,-1,39,84,83,-1,39,38,84,-1,85,81,80,-1,85,86,81,-1,79,82,81,-1,82,79,76,-1,73,78,77,-1,78,73,72,-1,261,202,260,-1,261,259,202,-1,258,156,257,-1,258,206,156,-1,5,205,68,-1,154,205,5,-1,238,109,108,-1,238,256,109,-1,190,106,105,-1,190,242,106,-1,37,255,245,-1,124,255,37,-1,264,32,241,-1,264,187,32,-1,170,65,268,-1,170,253,65,-1,13,7,174,-1,7,13,157,-1,252,8,10,-1,8,252,251,-1,231,64,61,-1,231,101,64,-1,60,63,62,-1,63,60,57,-1,210,59,58,-1,210,46,59,-1,1,53,52,-1,56,53,1,-1,137,233,247,-1,137,212,233,-1,249,45,248,-1,48,45,249,-1,250,55,159,-1,54,55,250,-1,140,49,51,-1,49,140,111,-1,254,32,31,-1,32,254,239,-1,246,239,254,-1,246,245,239,-1,186,223,172,-1,223,186,224,-1,29,244,183,-1,244,29,28,-1,30,224,186,-1,224,30,27,-1,26,20,19,-1,26,25,20,-1,114,276,12,-1,114,113,276,-1,276,22,23,-1,22,276,113,-1,147,133,149,-1,146,133,147,-1,17,116,15,-1,215,116,17,-1,10,102,101,-1,10,99,102,-1,9,99,10,-1,269,195,193,-1,195,269,44,-1,191,13,174,-1,191,11,13,-1,173,227,192,-1,173,243,227,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rhamate_Coord',point=[(-7.12857,28.73735,2.30022),(-7.12725,28.86018,2.33022),(-7.13688,28.69338,2.39769),(-7.14281,28.66557,2.36991),(-7.17404,28.42748,1.99142),(-7.26353,28.4733,2.03676),(-7.20067,28.47609,2.04323),(-7.27873,28.42325,1.99906),(-7.59074,28.5553,1.99131),(-7.66291,28.60674,2.04833),(-7.64838,28.61976,2.04248),(-7.39757,28.40272,2.00551),(-7.49898,28.45259,1.99266),(-7.37856,28.43726,1.99371),(-7.47001,28.48718,1.9894),(-7.57186,28.44405,2.38493),(-7.60077,28.43466,2.48436),(-7.64926,28.45096,2.48474),(-7.73472,28.53047,2.1849),(-7.73788,28.48014,2.32818),(-7.73354,28.50064,2.33689),(-7.7335,28.5081,2.17647),(-7.71629,28.52597,2.06405),(-7.71208,28.54921,2.06469),(-7.68236,28.49763,2.49497),(-7.69353,28.50547,2.475),(-7.68933,28.48237,2.48947),(-6.99314,28.38493,2.00973),(-6.96197,28.37347,2.06046),(-6.95775,28.36128,2.04425),(-7.00092,28.40572,2.02142),(-7.16923,28.19381,2.15918),(-7.18649,28.18972,2.14394),(-7.08557,28.18401,2.16914),(-7.0713,28.18153,2.15315),(-6.98156,28.24018,2.13213),(-6.98788,28.25081,2.14309),(-7.323,28.31036,2.24102),(-7.30693,28.31826,2.25615),(-7.31423,28.33721,2.32296),(-7.33178,28.33833,2.31554),(-7.24956,28.48513,2.47529),(-7.17755,28.59523,2.45339),(-7.20228,28.59659,2.47015),(-7.23294,28.47404,2.45554),(-7.40307,28.99754,2.48021),(-7.48924,28.98761,2.51356),(-7.47596,28.99316,2.52566),(-7.41637,29.00145,2.46497),(-7.33927,28.36204,2.44756),(-7.32039,28.36961,2.44692),(-7.32951,28.37384,2.46209),(-7.15114,28.70865,2.42235),(-7.1652,28.71809,2.43502),(-7.15733,28.9321,2.3221),(-7.15384,28.93198,2.30279),(-7.13902,28.86673,2.3429),(-7.54887,28.90137,2.38161),(-7.52816,28.9456,2.47662),(-7.51805,28.95135,2.46472),(-7.56371,28.89367,2.38812),(-7.61427,28.76514,2.20668),(-7.59875,28.84844,2.30804),(-7.57901,28.86023,2.30541),(-7.63746,28.75747,2.20953),(-7.12015,28.20655,2.17088),(-7.35377,28.35949,2.43548),(-7.33508,28.35482,2.39098),(-7.2366,28.54989,2.09149),(-7.55585,28.79427,2.23122),(-7.49903,28.72045,2.16088),(-7.57023,28.71109,2.14626),(-7.1799,28.69944,2.20636),(-7.18847,28.63644,2.16546),(-7.23079,28.72366,2.18303),(-7.24411,28.66388,2.15276),(-7.14849,28.65658,2.26085),(-7.16825,28.61533,2.18673),(-7.15906,28.68167,2.23337),(-7.16676,28.58864,2.20788),(-7.16976,28.562,2.32964),(-7.18085,28.5301,2.23883),(-7.1524,28.60463,2.30703),(-7.29549,28.35437,2.3377),(-7.28491,28.33318,2.26856),(-7.22826,28.44223,2.33793),(-7.23473,28.41903,2.2608),(-7.01914,28.28545,2.00707),(-7.07795,28.24749,1.99627),(-7.03717,28.29094,1.99191),(-7.04119,28.43555,2.03112),(-7.1354,28.48617,2.0525),(-7.09142,28.46853,2.06807),(-7.08728,28.44451,2.01157),(-7.58094,28.75207,2.58118),(-7.62352,28.62703,2.54159),(-7.59026,28.61237,2.54929),(-7.5323,28.72834,2.56701),(-7.33274,28.50339,2.49244),(-7.69928,28.61241,2.10508),(-7.66116,28.73102,2.24186),(-7.64273,28.70216,2.12028),(-7.689,28.66373,2.14525),(-7.13591,28.24732,1.97957),(-7.14017,28.22862,1.9951),(-7.40574,28.39008,2.01483),(-7.37013,28.33417,2.09392),(-7.43593,28.39497,2.14894),(-7.45158,28.41552,2.48689),(-7.46292,28.40807,2.46277),(-7.39559,28.38455,2.44451),(-7.38411,28.38667,2.47547),(-7.62316,28.47288,2.01157),(-7.63111,28.48765,2.00129),(-7.50783,28.43925,2.00239),(-7.16198,28.58736,2.4206),(-7.61156,28.45493,2.35324),(-7.64712,28.45883,2.29749),(-7.50784,28.44363,2.2478),(-7.65329,28.4702,2.19217),(-7.62318,28.46704,2.14147),(-7.57807,28.45443,2.10394),(-7.50311,28.42892,2.09431),(-7.39564,28.37202,2.21762),(-7.34198,28.30512,2.17392),(-7.41127,28.40695,2.36293),(-7.38493,28.38694,2.32863),(-7.5283,28.43152,2.39743),(-7.59299,28.76201,2.57432),(-7.65948,28.69241,2.47208),(-7.63504,28.63861,2.53028),(-7.60808,28.79575,2.51133),(-7.70147,28.58336,2.40215),(-7.53006,28.86294,2.59298),(-7.48063,28.84354,2.56983),(-7.53655,28.59108,2.54452),(-7.47196,28.70745,2.54735),(-7.60117,28.46195,2.53089),(-7.51586,28.43656,2.52098),(-7.44176,28.55433,2.5174),(-7.37524,28.39961,2.48566),(-7.29338,28.42402,2.46802),(-7.23811,28.7518,2.46908),(-7.27135,28.91513,2.44628),(-7.32707,28.78,2.49319),(-7.1793,28.88688,2.38785),(-7.5413,28.8732,2.58453),(-7.51676,28.9265,2.56381),(-7.55144,28.89447,2.53294),(-7.4985,28.93075,2.56817),(-7.43133,28.93793,2.53887),(-7.14207,28.86691,2.28986),(-7.20557,28.78348,2.20631),(-7.16477,28.76539,2.23443),(-7.35399,28.49992,2.03832),(-7.45765,28.50097,1.99664),(-7.42569,28.53345,2.04438),(-7.37032,28.45607,2.00271),(-7.1926,28.90041,2.25695),(-7.24651,28.99466,2.32597),(-7.2763,28.95274,2.2885),(-7.50185,28.9556,2.45733),(-7.54085,28.92621,2.49222),(-7.61017,28.83304,2.44811),(-7.58373,28.86752,2.41001),(-7.72344,28.47014,2.32133),(-7.72219,28.48811,2.1729),(-7.24378,28.28758,2.21439),(-7.19027,28.37862,2.18195),(-7.14429,28.46035,2.15183),(-7.11177,28.32201,2.14754),(-7.08217,28.40222,2.10983),(-7.16266,28.40136,1.96956),(-7.26305,28.36423,1.97029),(-7.28644,28.39182,1.97911),(-7.08939,28.28635,1.96737),(-7.05435,28.29453,1.9788),(-7.11982,28.26788,1.96825),(-7.10713,28.20889,2.0295),(-7.12735,28.21349,2.01546),(-7.0287,28.23546,2.04628),(-7.07013,28.20992,2.04732),(-6.95313,28.28739,2.07401),(-6.94404,28.30167,2.09076),(-6.99048,28.23538,2.10257),(-7.00922,28.26329,2.03055),(-7.05302,28.41967,1.98896),(-7.14049,28.18411,2.07263),(-7.06905,28.18751,2.10277),(-7.28688,28.26189,2.05062),(-7.34264,28.33067,2.01482),(-7.32863,28.34858,1.99241),(-7.2988,28.32348,1.98544),(-7.28175,28.3824,2.41445),(-7.31546,28.35711,2.39799),(-7.28452,28.40952,2.44996),(-7.7014,28.50096,2.07612),(-7.52005,28.90527,2.38076),(-7.3531,28.97078,2.35325),(-7.47568,28.91825,2.36764),(-7.44538,28.9608,2.42667),(-7.39625,28.91887,2.31816),(-7.3779,28.83075,2.22714),(-7.32466,28.88544,2.25209),(-7.44406,28.88205,2.28869),(-7.32771,28.56659,2.09066),(-7.374,28.5907,2.09892),(-7.29693,28.67323,2.14617),(-7.14555,28.75657,2.26429),(-7.16116,28.88062,2.26157),(-7.49677,28.98311,2.52453),(-7.28791,28.63238,2.50154),(-7.64815,28.47985,2.52318),(-7.47586,28.42128,2.39399),(-7.38107,28.37234,2.283),(-7.68562,28.46709,2.4529),(-7.1853,28.55312,2.10715),(-7.01621,28.39843,2.06748),(-7.07432,28.43995,2.08789),(-7.00513,28.35667,2.10214),(-7.1525,28.53402,2.11687),(-7.25405,28.72958,2.17601),(-7.10853,28.33406,1.95489),(-7.14277,28.37608,1.96065),(-7.04089,28.39434,1.9789),(-7.04142,28.35058,1.97565),(-7.43784,28.42525,2.49664),(-7.2636,28.29991,1.98021),(-7.19813,28.263,1.97614),(-7.20416,28.22116,2.00741),(-7.26187,28.2477,2.03801),(-7.61934,28.70844,2.11894),(-7.7139,28.60458,2.21496),(-7.65298,28.46416,2.51369),(-7.13997,28.50317,2.13165),(-7.49192,28.84546,2.25939),(-7.48935,28.88151,2.30888),(-7.56291,28.66742,2.11161),(-7.52225,28.42242,2.51024),(-7.21535,28.2114,2.15712),(-7.25824,28.22777,2.10664),(-7.23454,28.21858,2.08556),(-7.33182,28.29691,2.07088),(-7.23256,28.33517,1.96363),(-6.94882,28.3161,2.10587),(-7.27736,28.26179,2.19661),(-7.26448,28.2687,2.20704),(-7.60503,28.44651,2.51987),(-7.3097,29.00533,2.39891),(-7.32392,29.00893,2.38204),(-7.23796,28.99191,2.34948),(-7.5772,28.56855,1.99925),(-7.62903,28.63203,2.05067),(-7.17027,28.23386,2.17846),(-7.19909,28.21494,2.16754),(-7.30727,28.26773,2.14563),(-7.52656,28.41575,2.47881),(-7.51554,28.60413,2.06988),(-7.44585,28.65229,2.11567),(-7.43161,28.77971,2.19706),(-7.31663,28.77094,2.18331),(-7.37081,28.72024,2.15237),(-7.00436,28.34917,1.99956),(-6.97134,28.33428,2.02745),(-7.17956,28.19752,2.04138),(-7.61724,28.81932,2.33183),(-7.65137,28.76949,2.3829),(-7.53944,28.8658,2.31438),(-7.03991,28.27813,2.1405),(-7.22,28.46185,2.41852),(-7.37954,28.66427,2.52196),(-7.41226,28.81379,2.5302),(-7.35675,28.93049,2.49086),(-7.26292,28.82527,2.20912),(-7.68422,28.69284,2.29755),(-7.17402,28.29677,1.95824),(-7.62013,28.50627,1.99736)]))),
        Shape(DEF='rlunate',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rlunate_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,1,6,7,-1,8,9,10,-1,2,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,34,36,35,-1,37,38,39,-1,40,31,30,-1,41,42,43,-1,41,44,42,-1,8,45,9,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,34,33,-1,55,56,34,-1,57,58,9,-1,55,58,59,-1,55,3,58,-1,7,11,2,-1,60,0,2,-1,61,62,63,-1,63,64,61,-1,65,66,67,-1,68,20,69,-1,2,70,71,-1,72,48,73,-1,74,75,35,-1,76,77,78,-1,79,20,80,-1,79,69,20,-1,81,82,83,-1,67,84,85,-1,36,25,86,-1,87,67,88,-1,89,67,90,-1,91,92,67,-1,93,67,94,-1,84,67,95,-1,96,67,97,-1,98,99,56,-1,98,100,99,-1,79,101,69,-1,79,102,101,-1,103,104,105,-1,106,77,107,-1,106,108,77,-1,36,86,109,-1,110,111,64,-1,112,111,110,-1,110,113,112,-1,114,70,115,-1,114,116,70,-1,117,16,118,-1,16,119,118,-1,17,83,82,-1,120,121,18,-1,120,122,121,-1,123,124,71,-1,71,125,123,-1,126,127,128,-1,126,43,127,-1,72,73,129,-1,130,131,132,-1,2,1,7,-1,133,134,90,-1,90,87,133,-1,135,136,137,-1,135,138,136,-1,26,139,140,-1,26,28,139,-1,99,100,133,-1,133,141,99,-1,142,143,144,-1,144,145,142,-1,146,147,148,-1,146,149,147,-1,14,150,15,-1,151,45,152,-1,20,153,154,-1,21,68,155,-1,135,103,105,-1,156,39,157,-1,35,36,158,-1,2,71,124,-1,5,159,160,-1,10,2,8,-1,48,161,162,-1,162,108,48,-1,29,31,163,-1,24,164,22,-1,15,144,143,-1,143,13,15,-1,152,165,166,-1,152,167,165,-1,19,153,20,-1,139,99,141,-1,139,28,99,-1,168,169,170,-1,168,38,169,-1,135,137,171,-1,171,155,135,-1,172,67,96,-1,173,11,130,-1,174,175,176,-1,161,48,72,-1,129,177,178,-1,129,73,177,-1,179,180,181,-1,182,183,17,-1,117,64,16,-1,114,184,185,-1,185,116,114,-1,61,64,111,-1,186,187,188,-1,186,189,187,-1,190,176,191,-1,83,41,81,-1,192,193,176,-1,154,194,20,-1,12,70,2,-1,85,97,67,-1,95,67,93,-1,94,67,92,-1,65,67,89,-1,90,67,87,-1,88,67,172,-1,67,66,91,-1,122,195,121,-1,122,179,195,-1,175,192,176,-1,188,37,196,-1,188,187,37,-1,23,197,198,-1,178,42,191,-1,128,182,126,-1,128,199,182,-1,83,200,41,-1,200,44,41,-1,201,77,76,-1,21,20,68,-1,135,155,103,-1,64,117,110,-1,70,202,115,-1,72,193,203,-1,33,3,55,-1,33,204,3,-1,59,58,57,-1,151,205,57,-1,205,206,57,-1,59,98,55,-1,98,56,55,-1,152,207,151,-1,207,205,151,-1,148,14,146,-1,148,150,14,-1,207,142,205,-1,207,143,142,-1,167,123,165,-1,167,124,123,-1,208,209,210,-1,35,158,74,-1,41,43,81,-1,43,126,81,-1,82,182,17,-1,164,211,212,-1,192,213,214,-1,214,132,192,-1,22,105,23,-1,64,200,83,-1,215,216,209,-1,216,217,209,-1,18,183,120,-1,18,17,183,-1,52,21,155,-1,184,218,219,-1,219,185,184,-1,181,195,179,-1,12,11,220,-1,9,58,160,-1,10,60,2,-1,4,3,204,-1,159,1,0,-1,159,6,1,-1,5,58,3,-1,160,58,5,-1,219,181,185,-1,219,195,181,-1,218,221,222,-1,221,218,184,-1,223,224,225,-1,224,223,226,-1,130,214,173,-1,130,132,214,-1,149,227,166,-1,149,146,227,-1,165,228,229,-1,123,228,165,-1,185,180,116,-1,181,180,185,-1,16,121,119,-1,121,16,18,-1,183,216,120,-1,217,216,183,-1,153,54,230,-1,153,19,54,-1,230,208,153,-1,230,231,208,-1,63,200,64,-1,200,63,232,-1,62,175,174,-1,62,233,175,-1,192,131,193,-1,131,192,132,-1,39,196,37,-1,156,196,39,-1,234,164,24,-1,211,164,234,-1,235,31,40,-1,31,235,163,-1,236,30,237,-1,40,30,236,-1,238,239,240,-1,238,241,239,-1,242,243,127,-1,244,243,242,-1,245,193,131,-1,245,203,193,-1,64,17,16,-1,83,17,64,-1,82,126,182,-1,81,126,82,-1,246,243,239,-1,246,247,243,-1,215,248,249,-1,248,215,231,-1,250,229,228,-1,229,250,251,-1,8,124,167,-1,8,2,124,-1,227,143,207,-1,227,13,143,-1,252,150,148,-1,252,253,150,-1,59,206,98,-1,57,206,59,-1,45,57,9,-1,45,151,57,-1,131,254,245,-1,131,130,254,-1,221,114,115,-1,221,184,114,-1,113,117,118,-1,110,117,113,-1,233,225,213,-1,225,233,255,-1,101,103,155,-1,103,101,104,-1,120,256,122,-1,256,120,216,-1,257,179,258,-1,257,180,179,-1,50,128,247,-1,128,50,199,-1,47,242,177,-1,47,244,242,-1,107,201,259,-1,107,77,201,-1,260,261,262,-1,261,260,237,-1,263,246,264,-1,246,263,51,-1,261,102,79,-1,261,265,102,-1,156,22,164,-1,157,22,156,-1,168,136,138,-1,170,136,168,-1,44,191,42,-1,191,44,190,-1,42,177,242,-1,177,42,178,-1,238,107,266,-1,107,238,106,-1,40,188,235,-1,188,40,186,-1,105,197,23,-1,197,105,104,-1,234,163,211,-1,163,234,29,-1,187,27,37,-1,267,27,187,-1,225,112,223,-1,255,112,225,-1,219,118,119,-1,219,218,118,-1,256,250,258,-1,256,249,250,-1,268,148,147,-1,252,148,268,-1,269,66,15,-1,91,66,269,-1,172,140,139,-1,96,140,172,-1,194,51,263,-1,194,49,51,-1,153,210,154,-1,153,208,210,-1,140,97,169,-1,96,97,140,-1,189,267,187,-1,267,189,270,-1,191,129,178,-1,191,176,129,-1,74,161,75,-1,161,74,162,-1,72,176,193,-1,129,176,72,-1,267,109,86,-1,270,109,267,-1,221,202,226,-1,115,202,221,-1,216,249,256,-1,216,215,249,-1,174,190,232,-1,174,176,190,-1,6,254,7,-1,6,4,254,-1,94,271,272,-1,271,94,92,-1,137,93,171,-1,137,95,93,-1,97,170,169,-1,170,97,85,-1,141,172,139,-1,141,88,172,-1,144,89,145,-1,144,65,89,-1,171,52,155,-1,52,171,272,-1,271,253,53,-1,253,271,269,-1,231,268,248,-1,230,268,231,-1,166,207,152,-1,207,166,227,-1,237,265,261,-1,237,30,265,-1,138,105,22,-1,135,105,138,-1,259,189,186,-1,201,189,259,-1,108,46,48,-1,108,106,46,-1,270,78,109,-1,78,270,76,-1,205,273,206,-1,205,142,273,-1,34,99,28,-1,34,56,99,-1,98,273,100,-1,206,273,98,-1,158,109,78,-1,109,158,36,-1,104,102,197,-1,104,101,102,-1,30,198,265,-1,30,32,198,-1,262,241,260,-1,241,262,264,-1,20,263,80,-1,20,194,263,-1,45,167,152,-1,45,8,167,-1,251,149,229,-1,149,251,147,-1,230,252,268,-1,230,54,252,-1,145,273,142,-1,145,134,273,-1,134,100,273,-1,133,100,134,-1,272,53,52,-1,53,272,271,-1,145,90,134,-1,145,89,90,-1,87,141,133,-1,141,87,88,-1,136,95,137,-1,136,84,95,-1,93,272,171,-1,272,93,94,-1,92,269,271,-1,269,92,91,-1,245,4,204,-1,254,4,245,-1,183,199,217,-1,183,182,199,-1,228,258,250,-1,258,228,257,-1,12,202,70,-1,12,220,202,-1,226,220,224,-1,220,226,202,-1,255,111,112,-1,61,111,255,-1,168,39,38,-1,157,39,168,-1,161,203,75,-1,72,203,161,-1,77,162,74,-1,162,77,108,-1,69,155,68,-1,69,101,155,-1,201,270,189,-1,76,270,201,-1,26,169,38,-1,140,169,26,-1,49,154,210,-1,154,49,194,-1,264,239,241,-1,264,246,239,-1,253,15,150,-1,269,15,253,-1,147,248,268,-1,248,147,251,-1,223,113,222,-1,113,223,112,-1,267,25,27,-1,86,25,267,-1,235,196,212,-1,196,235,188,-1,236,186,40,-1,259,186,236,-1,240,106,238,-1,46,106,240,-1,44,232,190,-1,44,200,232,-1,170,84,136,-1,85,84,170,-1,157,138,22,-1,168,138,157,-1,265,197,102,-1,198,197,265,-1,80,264,262,-1,80,263,264,-1,262,79,80,-1,79,262,261,-1,266,259,236,-1,266,107,259,-1,74,78,77,-1,78,74,158,-1,23,32,24,-1,198,32,23,-1,48,177,73,-1,48,47,177,-1,247,127,243,-1,127,247,128,-1,209,199,50,-1,199,209,217,-1,70,125,71,-1,70,116,125,-1,122,258,179,-1,258,122,256,-1,15,65,144,-1,15,66,65,-1,224,11,173,-1,224,220,11,-1,62,255,233,-1,255,62,61,-1,222,118,218,-1,113,118,222,-1,7,130,11,-1,254,130,7,-1,54,253,252,-1,54,53,253,-1,251,249,248,-1,251,250,249,-1,51,247,246,-1,51,50,247,-1,244,46,240,-1,244,47,46,-1,50,210,209,-1,210,50,49,-1,43,242,127,-1,42,242,43,-1,36,28,25,-1,36,34,28,-1,75,33,35,-1,204,33,75,-1,243,240,239,-1,240,243,244,-1,260,238,266,-1,260,241,238,-1,266,237,260,-1,236,237,266,-1,211,235,212,-1,163,235,211,-1,29,24,32,-1,234,24,29,-1,212,156,164,-1,212,196,156,-1,38,27,26,-1,27,38,37,-1,203,204,75,-1,204,203,245,-1,192,233,213,-1,175,233,192,-1,174,63,62,-1,232,63,174,-1,52,19,21,-1,19,52,54,-1,116,257,125,-1,180,257,116,-1,209,231,215,-1,209,208,231,-1,195,119,121,-1,195,219,119,-1,228,125,257,-1,228,123,125,-1,229,166,165,-1,229,149,166,-1,13,146,14,-1,227,146,13,-1,173,225,224,-1,214,225,173,-1,214,213,225,-1,222,226,223,-1,226,222,221,-1,0,160,159,-1,60,160,0,-1,60,9,160,-1,9,60,10,-1,6,5,4,-1,5,6,159,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rlunate_Coord',point=[(-7.68535,29.20388,2.3357),(-7.68146,29.20306,2.34081),(-7.71471,29.25366,2.37312),(-7.56425,29.09719,2.34433),(-7.56554,29.09851,2.35068),(-7.58985,29.1102,2.33626),(-7.6408,29.14583,2.32232),(-7.65262,29.17326,2.3819),(-7.71964,29.26202,2.30871),(-7.66135,29.14173,2.29793),(-7.69406,29.20484,2.32625),(-7.66414,29.20146,2.44517),(-7.6736,29.25596,2.42773),(-7.54548,29.36699,2.18468),(-7.52748,29.37114,2.18764),(-7.40402,29.3086,2.09424),(-7.39209,29.3161,2.61506),(-7.38015,29.31193,2.60008),(-7.38964,29.32715,2.59867),(-7.29683,29.39462,2.21965),(-7.23825,29.36542,2.23406),(-7.21621,29.36065,2.17282),(-7.10444,29.07505,2.14312),(-7.06518,29.11108,2.19052),(-7.06172,29.07786,2.21983),(-7.414,29.03462,2.14041),(-7.33622,29.01433,2.10895),(-7.33485,29.01285,2.11402),(-7.41841,29.03505,2.13536),(-7.10116,29.10432,2.25186),(-7.13496,29.14656,2.27823),(-7.12516,29.12889,2.27166),(-7.09808,29.11225,2.24914),(-7.47821,29.06749,2.28624),(-7.46197,29.04554,2.21131),(-7.4691,29.06797,2.28393),(-7.45472,29.04553,2.21374),(-7.25979,29.00767,2.10546),(-7.25943,29.00947,2.10069),(-7.24808,29.00859,2.10403),(-7.139,29.14081,2.27868),(-7.33927,29.2173,2.57313),(-7.32439,29.23972,2.51884),(-7.32231,29.24724,2.52041),(-7.34994,29.2065,2.57545),(-7.72462,29.2706,2.24446),(-7.31456,29.18627,2.36709),(-7.33056,29.19554,2.397),(-7.38624,29.16802,2.379),(-7.28126,29.32382,2.32736),(-7.29564,29.31012,2.35857),(-7.27358,29.30121,2.33184),(-7.22796,29.36276,2.16305),(-7.29222,29.37638,2.17),(-7.30595,29.39498,2.20866),(-7.53755,29.0877,2.27054),(-7.50867,29.08361,2.19389),(-7.64546,29.15237,2.2425),(-7.65713,29.1359,2.29507),(-7.62504,29.13476,2.23733),(-7.68985,29.20127,2.33024),(-7.4353,29.18976,2.64943),(-7.44123,29.16458,2.6473),(-7.39645,29.18528,2.63594),(-7.34612,29.20883,2.63268),(-7.39583,29.24046,2.05415),(-7.37592,29.25813,2.06202),(-7.34791,29.20198,2.04135),(-7.17355,29.32021,2.18999),(-7.17304,29.29658,2.20822),(-7.68311,29.31066,2.41042),(-7.6883,29.30564,2.38567),(-7.4452,29.14476,2.42981),(-7.40114,29.16686,2.43344),(-7.41721,29.1067,2.27489),(-7.48456,29.09178,2.35969),(-7.3438,29.10363,2.2146),(-7.34175,29.13835,2.25279),(-7.36687,29.10259,2.21428),(-7.17081,29.23904,2.23806),(-7.21015,29.2659,2.2503),(-7.33878,29.23479,2.56991),(-7.34208,29.25158,2.56971),(-7.34351,29.20886,2.62881),(-7.26969,29.17004,2.05656),(-7.29263,29.14749,2.05622),(-7.40465,29.04927,2.15677),(-7.40928,29.16753,2.05353),(-7.39147,29.14761,2.06314),(-7.41574,29.22281,2.04631),(-7.42384,29.19387,2.04547),(-7.35158,29.26292,2.06567),(-7.32725,29.26774,2.06934),(-7.25726,29.23267,2.05816),(-7.29991,29.26405,2.0639),(-7.25014,29.20084,2.05842),(-7.34292,29.13378,2.05975),(-7.31364,29.13623,2.05532),(-7.58935,29.13863,2.1785),(-7.4757,29.08336,2.11884),(-7.55035,29.1462,2.12209),(-7.12481,29.24595,2.18931),(-7.13151,29.21232,2.2259),(-7.08899,29.21168,2.15204),(-7.09691,29.19697,2.17359),(-7.06906,29.14817,2.158),(-7.29857,29.17708,2.33723),(-7.26302,29.15756,2.28146),(-7.36396,29.15304,2.3158),(-7.39205,29.067,2.17591),(-7.4265,29.25761,2.65272),(-7.42831,29.22079,2.64847),(-7.471,29.23954,2.63314),(-7.46887,29.28516,2.62817),(-7.60155,29.37391,2.47508),(-7.62072,29.33824,2.47182),(-7.59026,29.38285,2.43757),(-7.42008,29.28907,2.64383),(-7.46298,29.32994,2.61955),(-7.44198,29.35243,2.58518),(-7.3729,29.38063,2.48422),(-7.43104,29.35685,2.57367),(-7.4364,29.38836,2.47911),(-7.60877,29.37048,2.35895),(-7.67085,29.303,2.35843),(-7.60022,29.37704,2.39908),(-7.32713,29.26814,2.51922),(-7.2949,29.23952,2.47225),(-7.30134,29.26557,2.46112),(-7.41078,29.16622,2.4681),(-7.57168,29.13486,2.47667),(-7.50915,29.12282,2.48057),(-7.5131,29.13929,2.59829),(-7.46888,29.13634,2.07801),(-7.49343,29.18893,2.071),(-7.09737,29.18082,2.13389),(-7.20537,29.14537,2.08203),(-7.17012,29.20036,2.08554),(-7.13787,29.11012,2.11863),(-7.39908,29.07708,2.09525),(-7.33646,29.06993,2.09014),(-7.43347,29.09802,2.09677),(-7.66607,29.29037,2.15226),(-7.63569,29.33326,2.16614),(-7.4429,29.2754,2.07906),(-7.48183,29.24233,2.06399),(-7.55735,29.37694,2.22161),(-7.47676,29.39137,2.24704),(-7.46083,29.39148,2.22098),(-7.57926,29.37029,2.25211),(-7.44361,29.38022,2.19849),(-7.71015,29.27758,2.21053),(-7.6814,29.32443,2.23505),(-7.30859,29.40293,2.26147),(-7.28261,29.37713,2.28263),(-7.10897,29.27546,2.14624),(-7.16998,29.01885,2.1589),(-7.17824,29.03627,2.11786),(-7.43771,29.07455,2.24375),(-7.64313,29.14421,2.31645),(-7.65657,29.13741,2.30091),(-7.43763,29.12875,2.37065),(-7.40169,29.13725,2.32686),(-7.10687,29.09371,2.25021),(-7.08754,29.04323,2.2166),(-7.60174,29.36768,2.30329),(-7.59414,29.36501,2.24592),(-7.6761,29.31361,2.29666),(-7.19563,29.05582,2.10431),(-7.27978,29.07404,2.08166),(-7.24507,29.10166,2.07534),(-7.16901,29.26118,2.0876),(-7.37458,29.1375,2.0623),(-7.58788,29.17082,2.52457),(-7.43778,29.16059,2.64175),(-7.46981,29.15219,2.62599),(-7.43942,29.16389,2.55175),(-7.34565,29.20106,2.4494),(-7.36464,29.20557,2.49633),(-7.50821,29.39737,2.47354),(-7.57735,29.3882,2.43014),(-7.53529,29.38815,2.47832),(-7.33419,29.30133,2.51818),(-7.36015,29.37267,2.48354),(-7.55892,29.36599,2.52156),(-7.54752,29.38275,2.48756),(-7.21733,29.10656,2.22899),(-7.27882,29.03788,2.13961),(-7.19489,29.06425,2.19513),(-7.29976,29.07121,2.17722),(-7.3957,29.18232,2.57123),(-7.38358,29.20147,2.53126),(-7.5048,29.14102,2.60478),(-7.49979,29.12411,2.48133),(-7.26691,29.3376,2.2962),(-7.49328,29.38835,2.52665),(-7.17353,29.01954,2.16498),(-7.0972,29.16717,2.20203),(-7.09751,29.13747,2.23053),(-7.31251,29.30653,2.44171),(-7.34724,29.20406,2.62741),(-7.32074,29.10469,2.21495),(-7.63624,29.30144,2.46448),(-7.49275,29.10862,2.42222),(-7.49396,29.09019,2.36151),(-7.68557,29.28371,2.18294),(-7.62895,29.17245,2.18933),(-7.66203,29.33344,2.19886),(-7.3258,29.3964,2.30979),(-7.34102,29.38998,2.34934),(-7.31566,29.38601,2.3189),(-7.08588,29.04888,2.22389),(-7.09312,29.04281,2.22075),(-7.50915,29.14464,2.60752),(-7.51191,29.14097,2.60427),(-7.35688,29.39537,2.35337),(-7.36496,29.38783,2.41968),(-7.35233,29.3801,2.41969),(-7.51635,29.35831,2.56819),(-7.50485,29.38291,2.53771),(-7.65209,29.25155,2.45684),(-7.56907,29.32213,2.52937),(-7.5175,29.30642,2.58716),(-7.51531,29.25337,2.60171),(-7.58278,29.22366,2.53175),(-7.51411,29.19643,2.60636),(-7.57558,29.27714,2.53312),(-7.56963,29.37178,2.2117),(-7.59505,29.37794,2.35885),(-7.58696,29.37403,2.30374),(-7.32378,29.40719,2.25863),(-7.34005,29.40124,2.30532),(-7.3936,29.18144,2.62972),(-7.47291,29.15623,2.63032),(-7.06747,29.07306,2.22533),(-7.1151,29.08995,2.24839),(-7.16309,29.1576,2.2929),(-7.15953,29.16318,2.29206),(-7.23711,29.19949,2.35641),(-7.25508,29.21635,2.38421),(-7.25845,29.21046,2.38556),(-7.23426,29.20538,2.35599),(-7.29817,29.23275,2.47325),(-7.27591,29.22741,2.4125),(-7.2792,29.22119,2.41378),(-7.50154,29.10638,2.42094),(-7.26316,29.24888,2.36157),(-7.28355,29.25941,2.39153),(-7.4041,29.39807,2.30489),(-7.41203,29.3968,2.35595),(-7.47537,29.39877,2.3568),(-7.47604,29.39498,2.30185),(-7.38242,29.39446,2.21705),(-7.36787,29.37813,2.18411),(-7.5685,29.1161,2.41198),(-7.47367,29.19505,2.63312),(-7.42419,29.39245,2.41745),(-7.58572,29.38255,2.3945),(-7.49177,29.39796,2.4151),(-7.24016,29.13201,2.25519),(-7.18576,29.18074,2.30714),(-7.16557,29.19046,2.27007),(-7.19676,29.20921,2.28056),(-7.25153,29.29238,2.30516),(-7.24278,29.23843,2.33168),(-7.13439,29.17181,2.25963),(-7.18796,29.17513,2.30755),(-7.34103,29.0393,2.1435),(-7.39621,29.3995,2.25394),(-7.35506,29.31797,2.10144),(-7.34589,29.06904,2.17652),(-7.30614,29.32748,2.10874),(-7.25202,29.32084,2.09827),(-7.60854,29.19543,2.13855)]))),
        Shape(DEF='rpisform',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rpisform_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,13,11,14,-1,15,11,16,-1,17,11,18,-1,19,11,20,-1,21,11,22,-1,23,11,24,-1,25,11,26,-1,27,28,29,-1,30,28,31,-1,32,28,33,-1,34,28,35,-1,36,28,37,-1,38,28,39,-1,40,28,41,-1,42,28,43,-1,44,28,45,-1,46,28,47,-1,48,28,49,-1,50,28,51,-1,52,28,53,-1,54,28,55,-1,56,28,57,-1,58,28,59,-1,60,28,61,-1,62,28,63,-1,1,64,2,-1,65,0,2,-1,66,67,68,-1,66,69,67,-1,70,71,72,-1,70,73,71,-1,63,28,27,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,81,82,83,-1,84,85,26,-1,86,87,25,-1,76,75,24,-1,88,89,23,-1,89,22,23,-1,89,90,22,-1,91,92,93,-1,93,8,91,-1,90,94,22,-1,95,96,21,-1,97,98,20,-1,99,100,19,-1,101,102,18,-1,103,104,17,-1,105,106,16,-1,107,108,15,-1,109,110,14,-1,111,112,13,-1,113,114,12,-1,115,116,117,-1,115,2,116,-1,118,119,10,-1,83,11,80,-1,120,5,121,-1,120,3,5,-1,8,7,122,-1,8,123,9,-1,61,28,62,-1,59,28,60,-1,57,28,58,-1,55,28,56,-1,53,28,54,-1,51,28,52,-1,49,28,50,-1,47,28,48,-1,45,28,46,-1,43,28,44,-1,41,28,42,-1,39,28,40,-1,37,28,38,-1,35,28,36,-1,33,28,34,-1,31,28,32,-1,29,28,30,-1,26,11,83,-1,24,11,25,-1,22,11,23,-1,20,11,21,-1,18,11,19,-1,16,11,17,-1,14,11,15,-1,12,11,13,-1,80,11,10,-1,0,124,1,-1,124,125,1,-1,115,65,2,-1,122,91,8,-1,126,124,127,-1,126,125,124,-1,128,129,130,-1,128,131,129,-1,132,131,128,-1,132,133,131,-1,134,135,136,-1,134,137,135,-1,138,139,140,-1,138,141,139,-1,142,143,144,-1,143,142,145,-1,71,146,147,-1,71,148,146,-1,149,150,73,-1,149,151,150,-1,152,153,154,-1,152,155,153,-1,156,157,158,-1,159,157,156,-1,160,161,162,-1,161,160,72,-1,70,163,164,-1,70,165,163,-1,120,166,167,-1,121,166,120,-1,162,168,169,-1,168,162,161,-1,170,171,172,-1,170,173,171,-1,173,174,175,-1,174,173,170,-1,176,177,178,-1,177,176,179,-1,180,181,182,-1,181,180,183,-1,184,115,185,-1,65,115,184,-1,170,134,174,-1,170,140,134,-1,179,132,177,-1,179,136,132,-1,186,130,183,-1,186,128,130,-1,181,124,184,-1,181,127,124,-1,187,188,189,-1,187,190,188,-1,191,192,193,-1,191,194,192,-1,195,196,197,-1,195,198,196,-1,199,200,201,-1,199,202,200,-1,203,204,205,-1,203,206,204,-1,207,8,208,-1,207,123,8,-1,7,156,122,-1,7,154,156,-1,153,120,159,-1,153,3,120,-1,149,121,5,-1,121,149,164,-1,161,143,168,-1,161,147,143,-1,209,138,172,-1,209,145,138,-1,210,119,211,-1,210,78,119,-1,212,213,214,-1,212,215,213,-1,216,217,218,-1,217,216,219,-1,220,221,222,-1,221,220,223,-1,224,225,226,-1,224,227,225,-1,228,229,230,-1,228,231,229,-1,232,190,187,-1,232,233,190,-1,234,235,236,-1,234,237,235,-1,63,238,239,-1,63,27,238,-1,211,118,240,-1,211,119,118,-1,214,241,242,-1,214,213,241,-1,217,243,244,-1,217,219,243,-1,221,245,246,-1,221,223,245,-1,247,226,248,-1,247,224,226,-1,116,230,249,-1,116,228,230,-1,250,187,64,-1,250,232,187,-1,251,236,252,-1,251,234,236,-1,62,239,253,-1,62,63,239,-1,240,114,254,-1,240,118,114,-1,242,255,256,-1,242,241,255,-1,244,257,258,-1,244,243,257,-1,246,259,260,-1,246,245,259,-1,261,248,262,-1,261,247,248,-1,117,249,263,-1,117,116,249,-1,264,64,1,-1,264,250,64,-1,265,252,266,-1,265,251,252,-1,61,253,267,-1,61,62,253,-1,254,113,268,-1,254,114,113,-1,256,269,270,-1,256,255,269,-1,258,271,272,-1,258,257,271,-1,260,273,274,-1,260,259,273,-1,261,275,276,-1,261,262,275,-1,277,263,278,-1,277,117,263,-1,279,1,125,-1,279,264,1,-1,280,266,281,-1,280,265,266,-1,60,267,282,-1,60,61,267,-1,268,112,283,-1,268,113,112,-1,270,284,285,-1,270,269,284,-1,272,286,287,-1,272,271,286,-1,274,288,289,-1,274,273,288,-1,276,290,291,-1,276,275,290,-1,292,277,278,-1,293,277,292,-1,294,125,126,-1,294,279,125,-1,295,281,296,-1,295,280,281,-1,59,282,297,-1,59,60,282,-1,283,111,298,-1,283,112,111,-1,285,299,300,-1,285,284,299,-1,287,301,302,-1,287,286,301,-1,289,303,304,-1,289,288,303,-1,305,291,290,-1,306,291,305,-1,307,293,292,-1,308,293,307,-1,309,126,129,-1,309,294,126,-1,310,296,311,-1,310,295,296,-1,58,297,312,-1,58,59,297,-1,298,110,313,-1,298,111,110,-1,300,314,315,-1,300,299,314,-1,302,316,317,-1,302,301,316,-1,304,318,319,-1,304,303,318,-1,320,306,305,-1,321,306,320,-1,322,308,307,-1,323,308,322,-1,324,129,131,-1,324,309,129,-1,325,311,326,-1,325,310,311,-1,57,312,327,-1,57,58,312,-1,109,313,110,-1,328,313,109,-1,315,329,330,-1,315,314,329,-1,317,331,332,-1,317,316,331,-1,333,319,318,-1,334,319,333,-1,335,321,320,-1,336,321,335,-1,337,323,322,-1,338,323,337,-1,339,131,133,-1,339,324,131,-1,340,326,341,-1,340,325,326,-1,56,327,342,-1,56,57,327,-1,328,108,343,-1,328,109,108,-1,330,344,345,-1,330,329,344,-1,332,346,347,-1,332,331,346,-1,348,334,333,-1,349,334,348,-1,350,336,335,-1,351,336,350,-1,352,338,337,-1,353,338,352,-1,354,133,135,-1,354,339,133,-1,355,341,356,-1,355,340,341,-1,55,342,357,-1,55,56,342,-1,343,107,358,-1,343,108,107,-1,345,359,360,-1,345,344,359,-1,347,361,362,-1,347,346,361,-1,349,363,364,-1,349,348,363,-1,365,351,350,-1,366,351,365,-1,367,353,352,-1,368,353,367,-1,137,354,135,-1,369,354,137,-1,370,355,356,-1,371,355,370,-1,372,55,357,-1,54,55,372,-1,107,373,358,-1,373,107,106,-1,360,374,375,-1,360,359,374,-1,362,376,377,-1,362,361,376,-1,364,378,379,-1,364,363,378,-1,366,380,381,-1,366,365,380,-1,382,368,367,-1,383,368,382,-1,139,369,137,-1,384,369,139,-1,385,371,370,-1,386,371,385,-1,387,54,372,-1,53,54,387,-1,106,388,373,-1,388,106,105,-1,375,389,390,-1,375,374,389,-1,377,391,392,-1,377,376,391,-1,393,379,378,-1,394,379,393,-1,395,381,380,-1,396,381,395,-1,397,383,382,-1,398,383,397,-1,141,384,139,-1,399,384,141,-1,400,386,385,-1,401,386,400,-1,402,53,387,-1,52,53,402,-1,105,403,388,-1,403,105,104,-1,390,404,405,-1,390,389,404,-1,392,406,407,-1,392,391,406,-1,408,394,393,-1,409,394,408,-1,410,396,395,-1,411,396,410,-1,412,398,397,-1,413,398,412,-1,142,399,141,-1,414,399,142,-1,415,401,400,-1,416,401,415,-1,417,52,402,-1,51,52,417,-1,104,418,403,-1,418,104,103,-1,404,419,405,-1,419,404,420,-1,407,421,422,-1,407,406,421,-1,409,423,424,-1,409,408,423,-1,411,425,426,-1,411,410,425,-1,427,413,412,-1,428,413,427,-1,144,414,142,-1,429,414,144,-1,430,416,415,-1,431,416,430,-1,432,51,417,-1,50,51,432,-1,103,433,418,-1,433,103,102,-1,420,434,419,-1,434,420,435,-1,421,436,422,-1,436,421,437,-1,424,438,439,-1,424,423,438,-1,426,440,441,-1,426,425,440,-1,442,428,427,-1,443,428,442,-1,146,429,144,-1,444,429,146,-1,445,431,430,-1,446,431,445,-1,447,50,432,-1,49,50,447,-1,102,448,433,-1,448,102,101,-1,435,449,434,-1,449,435,450,-1,437,451,436,-1,451,437,452,-1,439,453,454,-1,439,438,453,-1,441,455,456,-1,441,440,455,-1,457,443,442,-1,458,443,457,-1,148,444,146,-1,459,444,148,-1,460,446,445,-1,461,446,460,-1,462,49,447,-1,48,49,462,-1,101,463,448,-1,463,101,100,-1,450,464,449,-1,464,450,465,-1,452,466,451,-1,466,452,467,-1,454,468,469,-1,454,453,468,-1,456,470,471,-1,456,455,470,-1,472,458,457,-1,473,458,472,-1,150,459,148,-1,474,459,150,-1,475,461,460,-1,476,461,475,-1,477,48,462,-1,47,48,477,-1,100,478,463,-1,478,100,99,-1,465,479,464,-1,479,465,480,-1,467,481,466,-1,481,467,482,-1,469,483,484,-1,469,468,483,-1,471,485,486,-1,471,470,485,-1,487,473,472,-1,488,473,487,-1,151,474,150,-1,489,474,151,-1,490,476,475,-1,491,476,490,-1,492,47,477,-1,46,47,492,-1,99,493,478,-1,493,99,98,-1,480,494,479,-1,494,480,495,-1,482,496,481,-1,496,482,497,-1,484,498,499,-1,484,483,498,-1,500,486,485,-1,501,486,500,-1,502,488,487,-1,503,488,502,-1,504,151,4,-1,504,489,151,-1,505,490,506,-1,505,491,490,-1,45,492,507,-1,45,46,492,-1,493,97,508,-1,493,98,97,-1,494,509,510,-1,494,495,509,-1,496,511,512,-1,496,497,511,-1,499,513,514,-1,499,498,513,-1,500,515,501,-1,515,500,516,-1,517,502,518,-1,517,503,502,-1,519,4,6,-1,519,504,4,-1,520,506,521,-1,520,505,506,-1,44,507,522,-1,44,45,507,-1,508,96,523,-1,508,97,96,-1,510,524,525,-1,510,509,524,-1,512,526,527,-1,512,511,526,-1,513,528,514,-1,528,513,529,-1,516,530,515,-1,530,516,531,-1,532,518,533,-1,532,517,518,-1,534,6,155,-1,534,519,6,-1,535,521,536,-1,535,520,521,-1,43,522,537,-1,43,44,522,-1,523,95,538,-1,523,96,95,-1,525,539,540,-1,525,524,539,-1,527,541,542,-1,527,526,541,-1,529,543,528,-1,543,529,544,-1,531,545,530,-1,545,531,546,-1,547,533,548,-1,547,532,533,-1,549,155,152,-1,549,534,155,-1,550,536,551,-1,550,535,536,-1,42,537,552,-1,42,43,537,-1,538,94,553,-1,538,95,94,-1,540,554,555,-1,540,539,554,-1,542,556,557,-1,542,541,556,-1,544,558,543,-1,558,544,559,-1,546,560,545,-1,560,546,561,-1,92,548,562,-1,92,547,548,-1,563,152,9,-1,563,549,152,-1,564,551,565,-1,564,550,551,-1,41,552,566,-1,41,42,552,-1,553,90,567,-1,553,94,90,-1,555,568,569,-1,555,554,568,-1,570,556,571,-1,570,557,556,-1,559,572,558,-1,572,559,573,-1,561,574,560,-1,574,561,575,-1,93,562,576,-1,93,92,562,-1,577,9,123,-1,577,563,9,-1,578,565,579,-1,578,564,565,-1,40,566,580,-1,40,41,566,-1,567,89,581,-1,567,90,89,-1,569,582,583,-1,569,568,582,-1,571,584,570,-1,584,571,585,-1,586,573,587,-1,586,572,573,-1,575,588,574,-1,588,575,589,-1,590,576,591,-1,590,93,576,-1,592,123,207,-1,592,577,123,-1,593,579,594,-1,593,578,579,-1,39,580,595,-1,39,40,580,-1,581,88,596,-1,581,89,88,-1,582,597,583,-1,597,582,598,-1,585,599,584,-1,599,585,600,-1,601,587,602,-1,601,586,587,-1,603,589,604,-1,603,588,589,-1,591,605,590,-1,605,591,606,-1,607,207,206,-1,607,592,207,-1,608,594,609,-1,608,593,594,-1,38,595,610,-1,38,39,595,-1,596,75,77,-1,596,88,75,-1,598,611,597,-1,611,598,612,-1,600,613,599,-1,613,600,614,-1,615,602,616,-1,615,601,602,-1,617,604,618,-1,617,603,604,-1,619,606,620,-1,619,605,606,-1,621,206,203,-1,621,607,206,-1,622,609,623,-1,622,608,609,-1,37,610,624,-1,37,38,610,-1,612,625,611,-1,625,612,626,-1,614,627,613,-1,627,614,628,-1,616,629,615,-1,629,616,630,-1,631,618,632,-1,631,617,618,-1,633,620,634,-1,633,619,620,-1,635,203,202,-1,635,621,203,-1,636,622,623,-1,637,622,636,-1,638,37,624,-1,36,37,638,-1,639,76,87,-1,639,74,76,-1,626,640,625,-1,640,626,641,-1,628,642,627,-1,642,628,643,-1,644,630,645,-1,644,629,630,-1,646,632,647,-1,646,631,632,-1,648,634,649,-1,648,633,634,-1,199,635,202,-1,650,635,199,-1,651,637,636,-1,652,637,651,-1,653,36,638,-1,35,36,653,-1,654,87,86,-1,654,639,87,-1,641,655,640,-1,655,641,656,-1,643,657,642,-1,657,643,658,-1,645,659,644,-1,659,645,660,-1,647,661,646,-1,661,647,662,-1,663,649,664,-1,663,648,649,-1,196,650,199,-1,665,650,196,-1,666,652,651,-1,667,652,666,-1,668,35,653,-1,34,35,668,-1,86,669,654,-1,669,86,85,-1,656,670,655,-1,670,656,671,-1,658,672,657,-1,672,658,673,-1,660,674,659,-1,674,660,675,-1,662,676,661,-1,676,662,677,-1,664,678,663,-1,678,664,679,-1,198,665,196,-1,680,665,198,-1,681,667,666,-1,682,667,681,-1,683,34,668,-1,33,34,683,-1,85,684,669,-1,684,85,84,-1,685,671,686,-1,685,670,671,-1,673,687,672,-1,687,673,688,-1,675,689,674,-1,689,675,690,-1,677,691,676,-1,691,677,692,-1,679,693,678,-1,693,679,694,-1,67,680,198,-1,695,680,67,-1,696,682,681,-1,697,682,696,-1,698,33,683,-1,32,33,698,-1,84,699,684,-1,699,84,82,-1,686,700,685,-1,700,686,701,-1,688,702,687,-1,702,688,703,-1,690,704,689,-1,704,690,705,-1,706,692,707,-1,706,691,692,-1,708,694,709,-1,708,693,694,-1,69,695,67,-1,710,695,69,-1,711,697,696,-1,712,697,711,-1,713,32,698,-1,31,32,713,-1,82,714,699,-1,714,82,81,-1,701,715,700,-1,715,701,716,-1,703,717,702,-1,717,703,718,-1,705,719,704,-1,719,705,720,-1,721,707,722,-1,721,706,707,-1,723,708,709,-1,724,708,723,-1,194,710,69,-1,725,710,194,-1,726,712,711,-1,727,712,726,-1,728,31,713,-1,30,31,728,-1,81,729,714,-1,729,81,79,-1,716,730,715,-1,730,716,731,-1,718,732,717,-1,732,718,733,-1,720,734,719,-1,734,720,735,-1,736,722,737,-1,736,721,722,-1,738,723,739,-1,738,724,723,-1,191,725,194,-1,740,725,191,-1,741,727,726,-1,742,727,741,-1,743,30,728,-1,29,30,743,-1,79,210,729,-1,210,79,78,-1,731,212,730,-1,212,731,215,-1,733,218,732,-1,218,733,216,-1,735,222,734,-1,222,735,220,-1,227,737,225,-1,227,736,737,-1,231,739,229,-1,231,738,739,-1,190,740,191,-1,233,740,190,-1,235,742,741,-1,237,742,235,-1,238,29,743,-1,27,29,238,-1,237,743,742,-1,238,743,237,-1,233,741,740,-1,235,741,233,-1,231,193,738,-1,188,193,231,-1,229,736,227,-1,229,739,736,-1,225,734,222,-1,225,737,734,-1,732,220,735,-1,220,732,218,-1,730,216,733,-1,216,730,212,-1,729,215,731,-1,215,729,210,-1,742,728,727,-1,743,728,742,-1,740,726,725,-1,741,726,740,-1,738,192,724,-1,193,192,738,-1,739,721,736,-1,739,723,721,-1,737,719,734,-1,737,722,719,-1,717,735,720,-1,735,717,732,-1,715,733,718,-1,733,715,730,-1,714,731,716,-1,731,714,729,-1,83,79,81,-1,79,83,80,-1,727,713,712,-1,728,713,727,-1,725,711,710,-1,726,711,725,-1,724,66,708,-1,192,66,724,-1,723,706,721,-1,723,709,706,-1,722,704,719,-1,722,707,704,-1,702,720,705,-1,720,702,717,-1,700,718,703,-1,718,700,715,-1,699,716,701,-1,716,699,714,-1,712,698,697,-1,713,698,712,-1,710,696,695,-1,711,696,710,-1,708,68,693,-1,66,68,708,-1,709,691,706,-1,709,694,691,-1,689,707,692,-1,707,689,704,-1,687,705,690,-1,705,687,702,-1,685,703,688,-1,703,685,700,-1,684,701,686,-1,701,684,699,-1,26,82,84,-1,82,26,83,-1,697,683,682,-1,698,683,697,-1,695,681,680,-1,696,681,695,-1,693,195,678,-1,68,195,693,-1,676,694,679,-1,694,676,691,-1,674,692,677,-1,692,674,689,-1,672,690,675,-1,690,672,687,-1,670,688,673,-1,688,670,685,-1,669,686,671,-1,686,669,684,-1,682,668,667,-1,683,668,682,-1,680,666,665,-1,681,666,680,-1,195,663,678,-1,195,197,663,-1,661,679,664,-1,679,661,676,-1,659,677,662,-1,677,659,674,-1,657,675,660,-1,675,657,672,-1,655,673,658,-1,673,655,670,-1,654,671,656,-1,671,654,669,-1,25,85,86,-1,85,25,26,-1,667,653,652,-1,668,653,667,-1,665,651,650,-1,666,651,665,-1,197,648,663,-1,197,201,648,-1,646,664,649,-1,664,646,661,-1,644,662,647,-1,662,644,659,-1,642,660,645,-1,660,642,657,-1,640,658,643,-1,658,640,655,-1,639,656,641,-1,656,639,654,-1,652,638,637,-1,653,638,652,-1,650,636,635,-1,651,636,650,-1,201,633,648,-1,201,200,633,-1,649,631,646,-1,649,634,631,-1,647,629,644,-1,647,632,629,-1,645,627,642,-1,645,630,627,-1,625,643,628,-1,643,625,640,-1,74,641,626,-1,641,74,639,-1,87,24,25,-1,87,76,24,-1,637,624,622,-1,638,624,637,-1,636,621,635,-1,636,623,621,-1,200,619,633,-1,200,205,619,-1,617,634,620,-1,634,617,631,-1,632,615,629,-1,632,618,615,-1,613,630,616,-1,630,613,627,-1,611,628,614,-1,628,611,625,-1,77,626,612,-1,626,77,74,-1,624,608,622,-1,624,610,608,-1,623,607,621,-1,623,609,607,-1,205,605,619,-1,205,204,605,-1,620,603,617,-1,620,606,603,-1,618,601,615,-1,618,604,601,-1,599,616,602,-1,616,599,613,-1,597,614,600,-1,614,597,611,-1,598,77,612,-1,598,596,77,-1,88,24,75,-1,88,23,24,-1,610,593,608,-1,610,595,593,-1,609,592,607,-1,609,594,592,-1,590,204,208,-1,204,590,605,-1,606,588,603,-1,606,591,588,-1,604,586,601,-1,604,589,586,-1,584,602,587,-1,602,584,599,-1,583,600,585,-1,600,583,597,-1,582,596,598,-1,582,581,596,-1,595,578,593,-1,595,580,578,-1,594,577,592,-1,594,579,577,-1,93,208,8,-1,208,93,590,-1,591,574,588,-1,591,576,574,-1,589,572,586,-1,589,575,572,-1,587,570,584,-1,587,573,570,-1,569,585,571,-1,585,569,583,-1,568,581,582,-1,568,567,581,-1,580,564,578,-1,580,566,564,-1,579,563,577,-1,579,565,563,-1,576,560,574,-1,576,562,560,-1,558,575,561,-1,575,558,572,-1,573,557,570,-1,573,559,557,-1,556,569,571,-1,556,555,569,-1,554,567,568,-1,554,553,567,-1,566,550,564,-1,566,552,550,-1,565,549,563,-1,565,551,549,-1,91,547,92,-1,91,158,547,-1,562,545,560,-1,562,548,545,-1,543,561,546,-1,561,543,558,-1,544,557,559,-1,544,542,557,-1,541,555,556,-1,541,540,555,-1,539,553,554,-1,539,538,553,-1,95,22,94,-1,95,21,22,-1,552,535,550,-1,552,537,535,-1,551,534,549,-1,551,536,534,-1,158,532,547,-1,158,157,532,-1,548,530,545,-1,548,533,530,-1,528,546,531,-1,546,528,543,-1,529,542,544,-1,529,527,542,-1,526,540,541,-1,526,525,540,-1,524,538,539,-1,524,523,538,-1,537,520,535,-1,537,522,520,-1,536,519,534,-1,536,521,519,-1,157,517,532,-1,157,167,517,-1,533,515,530,-1,533,518,515,-1,514,531,516,-1,531,514,528,-1,513,527,529,-1,513,512,527,-1,511,525,526,-1,511,510,525,-1,509,523,524,-1,509,508,523,-1,97,21,96,-1,97,20,21,-1,522,505,520,-1,522,507,505,-1,521,504,519,-1,521,506,504,-1,167,503,517,-1,167,166,503,-1,518,501,515,-1,518,502,501,-1,499,516,500,-1,516,499,514,-1,498,512,513,-1,498,496,512,-1,494,511,497,-1,511,494,510,-1,495,508,509,-1,495,493,508,-1,507,491,505,-1,507,492,491,-1,506,489,504,-1,506,490,489,-1,503,163,488,-1,166,163,503,-1,501,487,486,-1,502,487,501,-1,485,499,500,-1,485,484,499,-1,481,498,483,-1,498,481,496,-1,479,497,482,-1,497,479,494,-1,478,495,480,-1,495,478,493,-1,99,20,98,-1,99,19,20,-1,491,477,476,-1,492,477,491,-1,489,475,474,-1,490,475,489,-1,488,165,473,-1,163,165,488,-1,486,472,471,-1,487,472,486,-1,470,484,485,-1,470,469,484,-1,466,483,468,-1,483,466,481,-1,464,482,467,-1,482,464,479,-1,463,480,465,-1,480,463,478,-1,476,462,461,-1,477,462,476,-1,474,460,459,-1,475,460,474,-1,473,160,458,-1,165,160,473,-1,471,457,456,-1,472,457,471,-1,455,469,470,-1,455,454,469,-1,451,468,453,-1,468,451,466,-1,449,467,452,-1,467,449,464,-1,448,465,450,-1,465,448,463,-1,18,100,101,-1,100,18,19,-1,461,447,446,-1,462,447,461,-1,459,445,444,-1,460,445,459,-1,458,162,443,-1,160,162,458,-1,456,442,441,-1,457,442,456,-1,440,454,455,-1,440,439,454,-1,436,453,438,-1,453,436,451,-1,434,452,437,-1,452,434,449,-1,433,450,435,-1,450,433,448,-1,446,432,431,-1,447,432,446,-1,444,430,429,-1,445,430,444,-1,443,169,428,-1,162,169,443,-1,441,427,426,-1,442,427,441,-1,425,439,440,-1,425,424,439,-1,423,436,438,-1,423,422,436,-1,419,437,421,-1,437,419,434,-1,418,435,420,-1,435,418,433,-1,17,102,103,-1,102,17,18,-1,431,417,416,-1,432,417,431,-1,429,415,414,-1,430,415,429,-1,744,428,169,-1,744,413,428,-1,426,412,411,-1,427,412,426,-1,424,410,409,-1,425,410,424,-1,408,422,423,-1,408,407,422,-1,406,419,421,-1,406,405,419,-1,403,420,404,-1,420,403,418,-1,416,402,401,-1,417,402,416,-1,414,400,399,-1,415,400,414,-1,413,171,398,-1,744,171,413,-1,411,397,396,-1,412,397,411,-1,409,395,394,-1,410,395,409,-1,393,407,408,-1,393,392,407,-1,391,405,406,-1,391,390,405,-1,388,404,389,-1,404,388,403,-1,16,104,105,-1,104,16,17,-1,401,387,386,-1,402,387,401,-1,399,385,384,-1,400,385,399,-1,398,173,383,-1,171,173,398,-1,396,382,381,-1,397,382,396,-1,394,380,379,-1,395,380,394,-1,378,392,393,-1,378,377,392,-1,376,390,391,-1,376,375,390,-1,373,389,374,-1,389,373,388,-1,386,372,371,-1,387,372,386,-1,384,370,369,-1,385,370,384,-1,383,175,368,-1,173,175,383,-1,367,381,382,-1,367,366,381,-1,365,379,380,-1,365,364,379,-1,363,377,378,-1,363,362,377,-1,361,375,376,-1,361,360,375,-1,359,373,374,-1,359,358,373,-1,15,106,107,-1,106,15,16,-1,371,357,355,-1,372,357,371,-1,369,356,354,-1,370,356,369,-1,368,176,353,-1,175,176,368,-1,366,352,351,-1,367,352,366,-1,350,364,365,-1,350,349,364,-1,348,362,363,-1,348,347,362,-1,346,360,361,-1,346,345,360,-1,344,358,359,-1,344,343,358,-1,357,340,355,-1,357,342,340,-1,356,339,354,-1,356,341,339,-1,353,178,338,-1,176,178,353,-1,351,337,336,-1,352,337,351,-1,349,335,334,-1,350,335,349,-1,333,347,348,-1,333,332,347,-1,331,345,346,-1,331,330,345,-1,329,343,344,-1,329,328,343,-1,15,109,14,-1,108,109,15,-1,342,325,340,-1,342,327,325,-1,341,324,339,-1,341,326,324,-1,338,745,323,-1,178,745,338,-1,336,322,321,-1,337,322,336,-1,334,320,319,-1,335,320,334,-1,332,318,317,-1,333,318,332,-1,316,330,331,-1,316,315,330,-1,314,328,329,-1,314,313,328,-1,327,310,325,-1,327,312,310,-1,326,309,324,-1,326,311,309,-1,745,308,323,-1,745,180,308,-1,321,307,306,-1,322,307,321,-1,319,305,304,-1,320,305,319,-1,303,317,318,-1,303,302,317,-1,301,315,316,-1,301,300,315,-1,299,313,314,-1,299,298,313,-1,14,111,13,-1,110,111,14,-1,312,295,310,-1,312,297,295,-1,311,294,309,-1,311,296,294,-1,180,293,308,-1,180,182,293,-1,306,292,291,-1,307,292,306,-1,290,304,305,-1,290,289,304,-1,288,302,303,-1,288,287,302,-1,286,300,301,-1,286,285,300,-1,284,298,299,-1,284,283,298,-1,297,280,295,-1,297,282,280,-1,296,279,294,-1,296,281,279,-1,182,277,293,-1,182,185,277,-1,291,278,276,-1,292,278,291,-1,275,289,290,-1,275,274,289,-1,273,287,288,-1,273,272,287,-1,271,285,286,-1,271,270,285,-1,269,283,284,-1,269,268,283,-1,113,13,112,-1,113,12,13,-1,282,265,280,-1,282,267,265,-1,281,264,279,-1,281,266,264,-1,185,117,277,-1,185,115,117,-1,276,263,261,-1,278,263,276,-1,262,274,275,-1,262,260,274,-1,259,272,273,-1,259,258,272,-1,257,270,271,-1,257,256,270,-1,255,268,269,-1,255,254,268,-1,267,251,265,-1,267,253,251,-1,266,250,264,-1,266,252,250,-1,263,247,261,-1,263,249,247,-1,248,260,262,-1,248,246,260,-1,245,258,259,-1,245,244,258,-1,243,256,257,-1,243,242,256,-1,241,254,255,-1,241,240,254,-1,118,12,114,-1,118,10,12,-1,253,234,251,-1,253,239,234,-1,252,232,250,-1,252,236,232,-1,2,228,116,-1,2,189,228,-1,249,224,247,-1,249,230,224,-1,221,248,226,-1,248,221,246,-1,223,244,245,-1,223,217,244,-1,219,242,243,-1,219,214,242,-1,213,240,241,-1,213,211,240,-1,239,237,234,-1,239,238,237,-1,236,233,232,-1,236,235,233,-1,189,231,228,-1,189,188,231,-1,230,227,224,-1,230,229,227,-1,226,222,221,-1,226,225,222,-1,218,223,220,-1,223,218,217,-1,216,214,219,-1,216,212,214,-1,215,211,213,-1,215,210,211,-1,78,10,119,-1,78,80,10,-1,168,145,209,-1,168,143,145,-1,72,147,161,-1,72,71,147,-1,164,73,70,-1,164,149,73,-1,154,159,156,-1,154,153,159,-1,206,208,204,-1,206,207,208,-1,202,205,200,-1,202,203,205,-1,197,199,201,-1,197,196,199,-1,68,198,195,-1,68,67,198,-1,194,66,192,-1,194,69,66,-1,190,193,188,-1,190,191,193,-1,64,189,2,-1,64,187,189,-1,184,0,65,-1,184,124,0,-1,183,127,181,-1,183,130,127,-1,177,128,186,-1,177,132,128,-1,174,136,179,-1,174,134,136,-1,172,140,170,-1,172,138,140,-1,182,184,185,-1,184,182,181,-1,178,186,745,-1,186,178,177,-1,175,179,176,-1,179,175,174,-1,744,172,171,-1,172,744,209,-1,169,209,744,-1,209,169,168,-1,167,159,120,-1,167,157,159,-1,166,164,163,-1,164,166,121,-1,165,72,160,-1,72,165,70,-1,122,158,91,-1,156,158,122,-1,9,154,7,-1,9,152,154,-1,155,3,153,-1,155,6,3,-1,4,149,5,-1,4,151,149,-1,73,148,71,-1,73,150,148,-1,147,144,143,-1,147,146,144,-1,145,141,138,-1,145,142,141,-1,140,137,134,-1,140,139,137,-1,136,133,132,-1,136,135,133,-1,745,183,180,-1,183,745,186,-1,129,127,130,-1,129,126,127,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpisform_Coord',point=[(-7.32511,28.72041,2.06411),(-7.32699,28.72065,2.06457),(-7.33084,28.70488,2.07016),(-7.45591,28.73932,1.92992),(-7.44506,28.75415,1.92971),(-7.4447,28.75364,1.92762),(-7.45583,28.7399,1.93223),(-7.47737,28.69476,1.94499),(-7.48266,28.67888,1.95101),(-7.47695,28.696,1.94697),(-7.25802,28.60612,1.88606),(-7.26193,28.60657,1.87534),(-7.25589,28.60908,1.88463),(-7.25453,28.61176,1.88209),(-7.25411,28.61384,1.87877),(-7.25466,28.61505,1.87507),(-7.2561,28.61521,1.87145),(-7.25822,28.61433,1.86832),(-7.26076,28.61252,1.86604),(-7.26343,28.61003,1.86487),(-7.26592,28.60715,1.86494),(-7.26792,28.6042,1.86619),(-7.26918,28.60146,1.8685),(-7.26956,28.59928,1.87162),(-7.26905,28.59797,1.87525),(-7.26771,28.59777,1.87898),(-7.26571,28.59871,1.88233),(-7.38992,28.71733,2.00761),(-7.39485,28.72265,1.99904),(-7.39137,28.71609,2.00745),(-7.39294,28.71505,2.00701),(-7.39457,28.71424,2.00633),(-7.39621,28.71369,2.00542),(-7.39782,28.71341,2.00431),(-7.39933,28.71342,2.00304),(-7.4007,28.7137,2.00167),(-7.40189,28.71426,2.00023),(-7.40287,28.71506,1.99876),(-7.40359,28.7161,1.99732),(-7.40405,28.71733,1.99595),(-7.40422,28.71873,1.99467),(-7.40411,28.72024,1.99353),(-7.40371,28.72182,1.99256),(-7.40305,28.72343,1.99178),(-7.40215,28.72503,1.99121),(-7.40102,28.72654,1.99086),(-7.39972,28.72794,1.99074),(-7.39827,28.7292,1.99086),(-7.39672,28.73024,1.99122),(-7.39511,28.73106,1.99181),(-7.3935,28.73162,1.99262),(-7.39193,28.73191,1.99363),(-7.39045,28.73191,1.9948),(-7.38909,28.73164,1.99612),(-7.3879,28.73109,1.99755),(-7.38692,28.73027,1.99903),(-7.38618,28.72923,2.00053),(-7.3857,28.72799,2.00199),(-7.3855,28.72659,2.00336),(-7.38559,28.72506,2.00459),(-7.38596,28.72347,2.00565),(-7.3866,28.72185,2.00651),(-7.3875,28.72026,2.00713),(-7.38861,28.71873,2.0075),(-7.33512,28.70754,2.06946),(-7.32365,28.71934,2.06315),(-7.39414,28.64561,2.06756),(-7.41138,28.64193,2.0601),(-7.40978,28.63697,2.06195),(-7.39703,28.64954,2.06683),(-7.41767,28.77774,1.9238),(-7.4051,28.7891,1.92648),(-7.40398,28.78825,1.92491),(-7.41905,28.77899,1.92525),(-7.30294,28.56097,1.88572),(-7.28629,28.58115,1.87421),(-7.28466,28.57941,1.87979),(-7.30625,28.56502,1.87724),(-7.25727,28.59972,1.91025),(-7.26151,28.59538,1.90944),(-7.26059,28.60321,1.88615),(-7.26564,28.59113,1.90751),(-7.26958,28.58717,1.90454),(-7.26326,28.60062,1.88484),(-7.2733,28.58373,1.90065),(-7.27672,28.58106,1.89603),(-7.27981,28.57936,1.89089),(-7.28247,28.5788,1.88542),(-7.28733,28.58388,1.86898),(-7.2877,28.58742,1.86424),(-7.28738,28.59151,1.86009),(-7.47646,28.69223,1.94133),(-7.47814,28.68428,1.93176),(-7.48094,28.6692,1.94172),(-7.28635,28.59593,1.85657),(-7.28463,28.60046,1.85367),(-7.28226,28.60493,1.85139),(-7.2793,28.60937,1.84977),(-7.27593,28.61384,1.84895),(-7.27231,28.61824,1.84899),(-7.26853,28.62243,1.84986),(-7.26468,28.62627,1.85154),(-7.26081,28.62962,1.85398),(-7.25699,28.63239,1.85714),(-7.2533,28.63446,1.86095),(-7.24986,28.63575,1.86532),(-7.24678,28.63619,1.87017),(-7.24417,28.63576,1.87535),(-7.24215,28.63446,1.88071),(-7.24081,28.63234,1.88608),(-7.24024,28.62946,1.89126),(-7.24048,28.62596,1.89602),(-7.24156,28.62195,1.90025),(-7.24345,28.6176,1.90383),(-7.24608,28.61306,1.9067),(-7.32143,28.71817,2.06257),(-7.3209,28.69923,2.06777),(-7.31071,28.71408,2.063),(-7.24935,28.60849,1.90877),(-7.25313,28.60403,1.90997),(-7.45513,28.73843,1.92822),(-7.44331,28.7524,1.92617),(-7.47672,28.69377,1.94343),(-7.48015,28.6816,1.95515),(-7.31779,28.73443,2.05749),(-7.31996,28.73509,2.05751),(-7.31473,28.74917,2.04903),(-7.31253,28.74873,2.04887),(-7.30914,28.77485,2.02749),(-7.31173,28.76263,2.03917),(-7.30952,28.76239,2.03887),(-7.31133,28.77489,2.02795),(-7.31172,28.78575,2.0145),(-7.31385,28.78563,2.01517),(-7.32586,28.80173,1.98454),(-7.31944,28.79454,2.00084),(-7.31741,28.79481,1.99994),(-7.32777,28.80136,1.98568),(-7.34883,28.80822,1.95566),(-7.33816,28.80581,1.97091),(-7.33639,28.80623,1.96955),(-7.35043,28.8078,1.95724),(-7.36383,28.80681,1.94599),(-7.37647,28.80336,1.93577),(-7.3777,28.80302,1.93772),(-7.36241,28.80721,1.94421),(-7.39158,28.79706,1.93216),(-7.39078,28.7972,1.92998),(-7.4057,28.7891,1.92874),(-7.43241,28.76712,1.92576),(-7.41979,28.77915,1.92731),(-7.43295,28.76744,1.92786),(-7.47221,28.71007,1.94046),(-7.46517,28.72431,1.9334),(-7.47245,28.7093,1.93824),(-7.46507,28.72489,1.93571),(-7.47178,28.70831,1.93666),(-7.46381,28.72241,1.9294),(-7.47129,28.70722,1.93435),(-7.46445,28.72339,1.93174),(-7.40294,28.78761,1.92261),(-7.38961,28.79641,1.92843),(-7.38843,28.7959,1.92617),(-7.42995,28.76508,1.92219),(-7.43102,28.76588,1.92431),(-7.41666,28.77686,1.92169),(-7.44238,28.75144,1.92406),(-7.45449,28.73737,1.92592),(-7.37527,28.8026,1.93428),(-7.37391,28.80226,1.9321),(-7.33505,28.8055,1.96825),(-7.3457,28.80739,1.95253),(-7.34753,28.80749,1.9543),(-7.33309,28.80539,1.96663),(-7.32449,28.80098,1.9833),(-7.3224,28.80083,1.98186),(-7.31382,28.79381,1.9975),(-7.31029,28.78494,2.01337),(-7.30802,28.78459,2.01231),(-7.31601,28.79404,1.99875),(-7.30574,28.76082,2.03707),(-7.31107,28.74774,2.04789),(-7.30876,28.74693,2.0472),(-7.30807,28.76147,2.03785),(-7.31634,28.73337,2.05653),(-7.31407,28.73238,2.05592),(-7.30769,28.77398,2.02643),(-7.34557,28.6945,2.07249),(-7.35332,28.67859,2.07473),(-7.3415,28.69145,2.07325),(-7.35712,28.68195,2.07395),(-7.36962,28.67003,2.07373),(-7.38,28.65512,2.07224),(-7.36618,28.66638,2.07452),(-7.38296,28.65905,2.0715),(-7.42589,28.63094,2.05361),(-7.44332,28.6327,2.0421),(-7.443,28.62731,2.04326),(-7.42696,28.63612,2.052),(-7.4588,28.63263,2.02984),(-7.4725,28.63126,2.01447),(-7.4595,28.62719,2.03015),(-7.47075,28.63634,2.01551),(-7.47781,28.64394,1.99953),(-7.48327,28.65129,1.97949),(-7.48018,28.63957,1.99707),(-7.48074,28.65499,1.98286),(-7.48111,28.66803,1.96746),(-7.48367,28.66484,1.96364),(-7.36116,28.80647,1.94279),(-7.25394,28.59497,1.93243),(-7.24704,28.60205,1.93196),(-7.25472,28.59309,1.9752),(-7.24328,28.60169,1.954),(-7.24307,28.60428,1.97504),(-7.2527,28.59226,1.95456),(-7.25988,28.59752,1.99347),(-7.25424,28.61884,2.00895),(-7.26827,28.60519,2.00877),(-7.24667,28.61012,1.99371),(-7.2796,28.61528,2.02137),(-7.27796,28.6415,2.03216),(-7.2929,28.62677,2.0325),(-7.26495,28.62962,2.02135),(-7.30668,28.66527,2.05395),(-7.30706,28.63869,2.0435),(-7.2922,28.65358,2.04275),(-7.32114,28.65045,2.05509),(-7.33261,28.68498,2.07077),(-7.33449,28.66167,2.06634),(-7.32069,28.67615,2.06491),(-7.34546,28.67123,2.07229),(-7.35412,28.69979,2.06481),(-7.36407,28.68888,2.06608),(-7.36902,28.70755,2.03879),(-7.36982,28.69504,2.05395),(-7.36173,28.70395,2.05293),(-7.37504,28.70091,2.03951),(-7.38131,28.70793,2.0242),(-7.37755,28.71205,2.0238),(-7.24075,28.60947,1.93009),(-7.23454,28.6118,1.95146),(-7.23205,28.6163,1.97264),(-7.23403,28.62349,1.99159),(-7.24073,28.63309,2.00711),(-7.25123,28.64442,2.0197),(-7.26415,28.65657,2.03057),(-7.29318,28.6804,2.05185),(-7.27832,28.66875,2.04105),(-7.30795,28.69105,2.06227),(-7.34516,28.71115,2.06204),(-7.36367,28.71454,2.03705),(-7.35449,28.71327,2.05061),(-7.37426,28.71646,2.0227),(-7.23532,28.61719,1.92691),(-7.22685,28.62233,1.9471),(-7.22227,28.62909,1.96761),(-7.22251,28.63767,1.98673),(-7.22812,28.64811,2.00274),(-7.23826,28.6599,2.01584),(-7.25144,28.67229,2.02701),(-7.28121,28.69615,2.04803),(-7.26603,28.68455,2.03753),(-7.29674,28.70659,2.05787),(-7.33742,28.72289,2.05775),(-7.35913,28.72175,2.0343),(-7.34826,28.72287,2.04703),(-7.37154,28.72103,2.02093),(-7.23102,28.62496,1.92252),(-7.22061,28.63294,1.94109),(-7.21429,28.64225,1.96014),(-7.21297,28.65266,1.9787),(-7.21738,28.66408,1.99512),(-7.22698,28.67636,2.00887),(-7.24031,28.68895,2.02057),(-7.25559,28.70126,2.03126),(-7.27142,28.71275,2.04163),(-7.30243,28.72953,2.05608),(-7.28759,28.72285,2.05111),(-7.33116,28.73494,2.05186),(-7.35555,28.72905,2.03057),(-7.34326,28.73265,2.04214),(-7.36949,28.72566,2.0185),(-7.2281,28.63253,1.91708),(-7.21626,28.64328,1.93363),(-7.20862,28.65508,1.95088),(-7.20608,28.66757,1.96825),(-7.20952,28.68053,1.98426),(-7.21855,28.69364,1.99832),(-7.23184,28.70654,2.01061),(-7.24758,28.71882,2.02174),(-7.26422,28.73008,2.03225),(-7.28093,28.7397,2.04169),(-7.29645,28.74539,2.04686),(-7.32668,28.74712,2.04428),(-7.3531,28.7363,2.02586),(-7.33971,28.74243,2.03591),(-7.36818,28.73026,2.01546),(-7.22672,28.63963,1.91071),(-7.21416,28.65301,1.92498),(-7.20579,28.66715,1.94015),(-7.20261,28.68163,1.95589),(-7.20529,28.69608,1.97132),(-7.21376,28.71023,1.98542),(-7.22682,28.72369,1.99808),(-7.24271,28.73609,2.00968),(-7.2598,28.74706,2.02059),(-7.27696,28.75598,2.03038),(-7.29295,28.76057,2.03605),(-7.32416,28.75878,2.03543),(-7.35189,28.7433,2.02028),(-7.33778,28.75185,2.02854),(-7.36766,28.73466,2.01193),(-7.22694,28.64599,1.90356),(-7.21454,28.66184,1.91542),(-7.20618,28.67808,1.9283),(-7.20303,28.69437,1.94208),(-7.2055,28.71023,1.95641),(-7.21351,28.72531,1.97038),(-7.22613,28.73929,1.98342),(-7.24174,28.7518,1.99561),(-7.25883,28.7625,2.00706),(-7.27618,28.77079,2.01733),(-7.29237,28.77437,2.02365),(-7.32385,28.76939,2.02547),(-7.35201,28.74971,2.01408),(-7.33761,28.7604,2.02029),(-7.36799,28.7387,2.00801),(-7.22871,28.65134,1.89579),(-7.21747,28.66948,1.90524),(-7.20989,28.68754,1.91569),(-7.20739,28.70538,1.9274),(-7.21031,28.72251,1.94006),(-7.21824,28.73847,1.95329),(-7.23033,28.75292,1.96648),(-7.24535,28.76556,1.97915),(-7.26196,28.77604,1.99119),(-7.27909,28.78378,2.00209),(-7.29518,28.78647,2.00933),(-7.32604,28.77868,2.0143),(-7.35357,28.75536,2.00734),(-7.33939,28.7679,2.01119),(-7.36916,28.74227,2.0038),(-7.23189,28.65548,1.88759),(-7.22278,28.67571,1.89475),(-7.21669,28.69524,1.90272),(-7.2154,28.71435,1.91229),(-7.21909,28.73251,1.9232),(-7.22733,28.74927,1.93513),(-7.23918,28.7642,1.94768),(-7.2535,28.77699,1.96043),(-7.26931,28.78733,1.97297),(-7.28592,28.79461,1.98466),(-7.30153,28.79655,1.9931),(-7.33082,28.78642,2.00194),(-7.35661,28.76012,2.00019),(-7.34328,28.77419,2.00134),(-7.37122,28.7453,1.99938),(-7.23626,28.65825,1.87916),(-7.2301,28.68026,1.88427),(-7.22609,28.70079,1.89002),(-7.2264,28.72072,1.89768),(-7.23109,28.73957,1.907),(-7.23967,28.75693,1.9176),(-7.25129,28.7724,1.9291),(-7.26498,28.78556,1.94121),(-7.27994,28.79594,1.95376),(-7.29603,28.80288,1.96623),(-7.31093,28.80424,1.97596),(-7.33806,28.79236,1.98884),(-7.34926,28.77915,1.99099),(-7.36113,28.7639,1.99277),(-7.37409,28.74769,1.9949),(-7.24163,28.65955,1.87117),(-7.23871,28.68265,1.87416),(-7.2374,28.70385,1.87833),(-7.23953,28.72406,1.88444),(-7.24533,28.7432,1.89243),(-7.25427,28.76093,1.90182),(-7.26563,28.77685,1.9122),(-7.27862,28.79048,1.92342),(-7.29301,28.80121,1.93554),(-7.30858,28.80821,1.94831),(-7.32261,28.8092,1.95926),(-7.34727,28.79638,1.97612),(-7.35691,28.78257,1.98087),(-7.36689,28.76654,1.98548),(-7.37761,28.74931,1.99061),(-7.24767,28.65929,1.86402),(-7.24813,28.68286,1.86508),(-7.24992,28.70447,1.86774),(-7.25392,28.72451,1.87257),(-7.26085,28.74359,1.87942),(-7.27018,28.76146,1.8877),(-7.28131,28.77763,1.89708),(-7.29387,28.79138,1.90776),(-7.30799,28.8023,1.91963),(-7.323,28.80971,1.93232),(-7.33615,28.81107,1.94387),(-7.35816,28.79833,1.96436),(-7.36582,28.78429,1.97162),(-7.37342,28.76782,1.97899),(-7.3816,28.75011,1.98674),(-7.25406,28.65749,1.85774),(-7.258,28.68108,1.85751),(-7.26297,28.70284,1.85861),(-7.26878,28.72243,1.86188),(-7.27664,28.7411,1.86792),(-7.28624,28.7587,1.87555),(-7.29735,28.77437,1.88485),(-7.30991,28.7878,1.89554),(-7.3238,28.79893,1.90717),(-7.33847,28.80712,1.91958),(-7.35095,28.80938,1.93139),(-7.36993,28.79776,1.95471),(-7.37541,28.78403,1.96403),(-7.38048,28.7677,1.97355),(-7.38594,28.75006,1.98339),(-7.26058,28.65432,1.85236),(-7.27572,28.699,1.85145),(-7.26778,28.6774,1.85118),(-7.28305,28.71791,1.85329),(-7.29171,28.73576,1.85868),(-7.30192,28.75254,1.8664),(-7.31331,28.76741,1.87609),(-7.32592,28.78048,1.88696),(-7.33985,28.79202,1.89851),(-7.35439,28.80122,1.91057),(-7.36622,28.80458,1.92235),(-7.38218,28.7948,1.94752),(-7.38542,28.78184,1.95828),(-7.38789,28.76617,1.96926),(-7.39052,28.74915,1.98065),(-7.26707,28.64994,1.84785),(-7.28752,28.69289,1.84605),(-7.277,28.67191,1.84601),(-7.30652,28.72782,1.85183),(-7.2969,28.71114,1.84739),(-7.31735,28.74356,1.85992),(-7.32906,28.75765,1.8701),(-7.34199,28.77063,1.88136),(-7.35614,28.78272,1.89288),(-7.37058,28.79293,1.90458),(-7.38176,28.79737,1.91621),(-7.39468,28.78977,1.94256),(-7.39564,28.77792,1.95427),(-7.39545,28.76331,1.96617),(-7.3952,28.74743,1.97855),(-7.27341,28.64455,1.84422),(-7.29856,28.68459,1.84191),(-7.28567,28.66481,1.84191),(-7.32107,28.71771,1.84757),(-7.31024,28.70215,1.84347),(-7.33248,28.73241,1.85551),(-7.34474,28.74604,1.86617),(-7.35816,28.75915,1.87779),(-7.37256,28.7718,1.88935),(-7.38688,28.78282,1.90089),(-7.39735,28.78822,1.91247),(-7.40717,28.78293,1.93961),(-7.40584,28.77239,1.95188),(-7.40298,28.75922,1.96422),(-7.39987,28.74495,1.97711),(-7.27961,28.63828,1.84158),(-7.30889,28.6745,1.83859),(-7.29397,28.65638,1.83873),(-7.33499,28.70567,1.84486),(-7.32258,28.69098,1.84043),(-7.34734,28.71962,1.85267),(-7.36036,28.73311,1.86357),(-7.37433,28.74648,1.87539),(-7.38896,28.75959,1.88716),(-7.40305,28.77115,1.89894),(-7.4127,28.77723,1.91077),(-7.41938,28.77436,1.93849),(-7.41575,28.76538,1.95094),(-7.41029,28.75403,1.9633),(-7.40438,28.7418,1.97631),(-7.28559,28.63136,1.83996),(-7.31859,28.66313,1.8359),(-7.30186,28.64699,1.83642),(-7.348,28.69192,1.84259),(-7.334,28.67817,1.83777),(-7.36177,28.70537,1.851),(-7.37571,28.71881,1.86208),(-7.39023,28.73241,1.87401),(-7.40498,28.74579,1.88623),(-7.4187,28.7576,1.89867),(-7.42743,28.76424,1.91103),(-7.43093,28.76411,1.93898),(-7.42511,28.75706,1.95121),(-7.41718,28.74792,1.96327),(-7.40864,28.73807,1.97613),(-7.29125,28.62401,1.83945),(-7.32772,28.65096,1.834),(-7.30932,28.63702,1.83514),(-7.36029,28.67701,1.84082),(-7.34464,28.66425,1.83563),(-7.37555,28.68991,1.85002),(-7.39057,28.70306,1.86192),(-7.40541,28.71641,1.87423),(-7.42012,28.7298,1.88709),(-7.4333,28.7418,1.90038),(-7.44107,28.74923,1.9131),(-7.44153,28.75257,1.94051),(-7.42348,28.74107,1.96404),(-7.43368,28.74774,1.95236),(-7.4125,28.73389,1.97654),(-7.29648,28.61649,1.84017),(-7.31625,28.62676,1.8352),(-7.33618,28.63832,1.83343),(-7.35453,28.64969,1.83479),(-7.37196,28.66142,1.84053),(-7.38872,28.67365,1.85067),(-7.40473,28.68631,1.86311),(-7.4341,28.7122,1.88949),(-7.41971,28.69908,1.87592),(-7.45333,28.73317,1.91588),(-7.4466,28.72459,1.90322),(-7.45086,28.74013,1.94279),(-7.429,28.7337,1.96554),(-7.44121,28.73769,1.95429),(-7.41586,28.72938,1.97751),(-7.30117,28.6091,1.84216),(-7.32243,28.61651,1.83695),(-7.34371,28.6255,1.8349),(-7.36357,28.63494,1.83649),(-7.38283,28.64555,1.84318),(-7.41771,28.66887,1.86645),(-7.40104,28.65697,1.85405),(-7.44658,28.69413,1.8929),(-7.43269,28.68109,1.87929),(-7.46387,28.71666,1.91949),(-7.45821,28.70702,1.90674),(-7.45865,28.7272,1.94592),(-7.43356,28.72602,1.96775),(-7.44745,28.72724,1.95701),(-7.41861,28.72468,1.97903),(-7.30502,28.60177,1.84538),(-7.32763,28.60656,1.84053),(-7.34991,28.61296,1.83876),(-7.37142,28.62066,1.84135),(-7.39241,28.63014,1.8492),(-7.42888,28.65175,1.87178),(-7.41184,28.6407,1.85994),(-7.45701,28.67637,1.89772),(-7.44372,28.66344,1.88422),(-7.47229,28.70021,1.92454),(-7.4677,28.68963,1.91169),(-7.46464,28.71419,1.95021),(-7.43701,28.71827,1.97073),(-7.45219,28.71668,1.96069),(-7.42066,28.71993,1.98109),(-7.30771,28.59395,1.84958),(-7.33157,28.59605,1.84594),(-7.35465,28.60014,1.84518),(-7.37758,28.60689,1.84954),(-7.39978,28.61555,1.85793),(-7.43732,28.63532,1.87957),(-7.42004,28.62513,1.86833),(-7.46472,28.65932,1.90502),(-7.45202,28.64653,1.89166),(-7.4745,28.67285,1.91902),(-7.46859,28.70152,1.95606),(-7.4392,28.71067,1.97455),(-7.45525,28.70636,1.96553),(-7.42194,28.71527,1.98367),(-7.30918,28.58589,1.85485),(-7.33356,28.58455,1.85326),(-7.35786,28.58643,1.85482),(-7.40435,28.60031,1.86903),(-7.38167,28.5919,1.86032),(-7.44206,28.61962,1.89045),(-7.42473,28.60998,1.87952),(-7.46899,28.64322,1.91561),(-7.45677,28.63055,1.90243),(-7.47803,28.65699,1.92942),(-7.47053,28.68936,1.96389),(-7.44006,28.70343,1.97926),(-7.45671,28.69642,1.97185),(-7.42238,28.71082,1.98675),(-7.30941,28.57802,1.8613),(-7.33364,28.57272,1.86248),(-7.35886,28.57215,1.86724),(-7.40542,28.58329,1.88277),(-7.3829,28.57569,1.87392),(-7.44256,28.60431,1.90461),(-7.42546,28.59337,1.89329),(-7.46927,28.62832,1.9298),(-7.4573,28.61562,1.91679),(-7.48153,28.65469,1.95516),(-7.47815,28.64219,1.94332),(-7.4715,28.67741,1.97436),(-7.43989,28.69656,1.98503),(-7.45725,28.68674,1.98003),(-7.42196,28.70673,1.99029),(-7.30843,28.57089,1.86896),(-7.35767,28.55838,1.88061),(-7.33226,28.56182,1.87299),(-7.40253,28.56547,1.89895),(-7.38117,28.55946,1.88921),(-7.43864,28.58826,1.92177),(-7.42168,28.57561,1.90984),(-7.46563,28.61464,1.94745),(-7.45329,28.60165,1.93439),(-7.48064,28.64069,1.97225),(-7.47617,28.62805,1.96114),(-7.47111,28.6661,1.98722),(-7.43859,28.69028,1.99177),(-7.45645,28.67777,1.98986),(-7.42068,28.7031,1.99422),(-7.35414,28.54643,1.89431),(-7.32939,28.55284,1.88417),(-7.39626,28.54905,1.91527),(-7.37636,28.54476,1.90449),(-7.43113,28.57337,1.94037),(-7.41459,28.5593,1.92738),(-7.45918,28.60265,1.96711),(-7.44556,28.58873,1.95357),(-7.47725,28.62874,1.99082),(-7.47157,28.61577,1.9807),(-7.46827,28.65648,2.0013),(-7.43583,28.68496,1.99916),(-7.45355,28.67013,2.00072),(-7.41858,28.70005,1.99845),(-7.34805,28.5375,1.90783),(-7.32489,28.54653,1.89558),(-7.38711,28.53652,1.9317),(-7.36836,28.53332,1.91934),(-7.42074,28.56182,1.95915),(-7.4047,28.54684,1.94519),(-7.44927,28.59362,1.98658),(-7.43494,28.57855,1.97283),(-7.46935,28.62034,2.00862),(-7.4627,28.60691,1.99968),(-7.46195,28.64982,2.01485),(-7.44804,28.66466,2.01144),(-7.4314,28.68094,2.00678),(-7.41571,28.69765,2.00287),(-7.29873,28.5592,1.89431),(-7.33951,28.53262,1.92083),(-7.31874,28.54345,1.90681),(-7.37554,28.52979,1.94813),(-7.35798,28.52717,1.93408),(-7.40771,28.55513,1.97771),(-7.39223,28.53994,1.96292),(-7.43552,28.58829,2.00499),(-7.42171,28.57233,1.99173),(-7.45617,28.61615,2.02465),(-7.4489,28.60223,2.01708),(-7.45175,28.64656,2.02717),(-7.43983,28.66174,2.02135),(-7.42546,28.67853,2.01404),(-7.41214,28.69602,2.0073),(-7.29378,28.55985,1.90277),(-7.32916,28.53262,1.93335),(-7.31113,28.54389,1.91758),(-7.36186,28.52956,1.96416),(-7.3457,28.52708,1.94848),(-7.39262,28.55441,1.99494),(-7.37756,28.5394,1.98004),(-7.41954,28.58745,2.02102),(-7.40661,28.57138,2.00858),(-7.43934,28.61609,2.03841),(-7.43193,28.60183,2.03207),(-7.4386,28.64661,2.0377),(-7.42964,28.66153,2.02993),(-7.41841,28.67791,2.02052),(-7.40809,28.69526,2.01147),(-7.2882,28.56281,1.9108),(-7.31752,28.53734,1.94512),(-7.30242,28.54776,1.92763),(-7.34668,28.53567,1.97875),(-7.33192,28.53263,1.96204),(-7.37653,28.56036,2.00849),(-7.36171,28.54577,1.99431),(-7.40323,28.59096,2.03366),(-7.39053,28.57619,2.02161),(-7.42187,28.61976,2.04945),(-7.41457,28.6055,2.04399),(-7.42448,28.64955,2.04627),(-7.41862,28.66371,2.0371),(-7.41081,28.67895,2.02612),(-7.40374,28.69543,2.0152),(-7.28209,28.56768,1.91807),(-7.30495,28.54581,1.95559),(-7.29301,28.55454,1.9367),(-7.33103,28.54756,1.98975),(-7.31741,28.5431,1.97331),(-7.3599,28.57141,2.01804),(-7.3454,28.55791,2.00452),(-7.38668,28.5983,2.043),(-7.3738,28.58527,2.03091),(-7.4053,28.62622,2.05833),(-7.39792,28.61242,2.0533),(-7.41083,28.6546,2.05338),(-7.40773,28.66761,2.04313),(-7.40318,28.6813,2.03093),(-7.39916,28.69649,2.01839),(-7.27552,28.5739,1.92415),(-7.29203,28.55703,1.9637),(-7.28308,28.56326,1.94428),(-7.31522,28.56279,1.9973),(-7.30278,28.55693,1.98146),(-7.34281,28.58487,2.02459),(-7.32881,28.57294,2.01141),(-7.36958,28.60891,2.04962),(-7.35655,28.59655,2.03739),(-7.38963,28.63491,2.06538),(-7.38134,28.62219,2.06025),(-7.39834,28.6611,2.05944),(-7.39762,28.67271,2.04824),(-7.3958,28.68475,2.0349),(-7.39448,28.69836,2.02096),(-7.26851,28.58079,1.92866),(-7.27919,28.56951,1.9695),(-7.27272,28.57282,1.94973),(-7.29927,28.57835,2.00264),(-7.28817,28.57164,1.98717),(-7.32542,28.59825,2.02933),(-7.31189,28.58783,2.01649),(-7.3525,28.62172,2.05384),(-7.33917,28.60963,2.0417),(-7.36479,28.63417,2.06477),(-7.37403,28.64574,2.07016),(-7.3863,28.66917,2.06366),(-7.38791,28.67914,2.05176),(-7.38856,28.68931,2.03764),(-7.38988,28.70097,2.02279),(-7.26125,28.58787,1.9314),(-7.26668,28.58179,1.97331),(-7.26252,28.58263,1.95311),(-7.28336,28.59219,2.00664),(-7.27374,28.58534,1.99115),(-7.30872,28.61225,2.03175),(-7.29529,28.60136,2.01986),(-7.33638,28.63583,2.05531),(-7.32268,28.62394,2.0434),(-7.35927,28.65804,2.07225),(-7.34917,28.64756,2.06651),(-7.37483,28.67859,2.06578),(-7.37859,28.68668,2.05361),(-7.3816,28.69477,2.03915),(-7.38546,28.7042,2.02386),(-7.35946,28.80631,1.94087),(-7.30538,28.77349,2.02552)]))),
        Shape(DEF='rtrpzium',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rtrpzium_Geo',coordIndex=[0,1,2,-1,3,1,0,-1,3,4,1,-1,5,6,7,-1,5,7,8,-1,9,10,11,-1,12,13,14,-1,12,15,13,-1,16,17,18,-1,19,20,21,-1,20,22,21,-1,23,24,25,-1,26,27,28,-1,28,29,26,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,35,37,36,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,44,47,45,-1,48,49,50,-1,48,51,49,-1,50,49,52,-1,52,53,50,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,63,33,16,-1,20,64,65,-1,66,67,29,-1,68,39,38,-1,68,69,39,-1,70,71,72,-1,73,74,75,-1,76,77,78,-1,79,52,49,-1,80,81,82,-1,83,84,85,-1,83,86,84,-1,87,15,21,-1,23,25,88,-1,89,90,91,-1,92,93,94,-1,92,95,93,-1,85,96,97,-1,96,98,97,-1,99,100,101,-1,102,103,104,-1,103,105,104,-1,106,107,108,-1,109,110,111,-1,112,113,41,-1,114,115,116,-1,117,118,119,-1,117,120,118,-1,121,122,123,-1,124,72,125,-1,125,126,124,-1,127,128,129,-1,130,103,131,-1,103,132,131,-1,133,134,135,-1,134,136,135,-1,137,138,139,-1,139,140,137,-1,141,127,129,-1,129,142,141,-1,89,143,90,-1,89,144,143,-1,123,145,146,-1,35,147,37,-1,148,149,150,-1,8,151,152,-1,153,154,155,-1,155,7,153,-1,44,46,156,-1,119,46,157,-1,158,159,160,-1,158,161,159,-1,162,2,27,-1,163,164,165,-1,166,69,167,-1,24,31,33,-1,12,14,18,-1,27,65,28,-1,168,169,162,-1,170,55,171,-1,172,173,140,-1,172,174,173,-1,124,126,175,-1,176,78,58,-1,0,2,162,-1,177,178,179,-1,177,180,178,-1,181,182,183,-1,181,184,182,-1,185,186,187,-1,185,188,186,-1,189,190,191,-1,192,193,194,-1,195,196,30,-1,30,32,195,-1,99,160,159,-1,197,26,29,-1,198,141,142,-1,142,199,198,-1,138,200,141,-1,141,198,138,-1,27,101,162,-1,175,201,124,-1,202,163,113,-1,202,164,163,-1,17,30,196,-1,203,34,36,-1,204,71,5,-1,140,173,137,-1,173,205,137,-1,206,56,207,-1,208,158,160,-1,181,209,184,-1,181,210,209,-1,62,211,67,-1,212,213,64,-1,14,214,215,-1,101,40,216,-1,217,218,219,-1,217,220,218,-1,27,40,101,-1,182,14,183,-1,182,214,14,-1,221,74,222,-1,223,114,201,-1,224,225,226,-1,227,228,229,-1,148,108,230,-1,231,232,233,-1,231,234,232,-1,235,172,139,-1,172,140,139,-1,236,237,238,-1,236,105,237,-1,130,131,111,-1,239,141,200,-1,239,127,141,-1,146,145,240,-1,241,242,37,-1,37,147,241,-1,243,244,245,-1,206,207,246,-1,148,150,108,-1,165,164,208,-1,208,160,165,-1,102,247,248,-1,102,104,247,-1,111,110,130,-1,110,237,130,-1,104,236,249,-1,104,105,236,-1,250,103,102,-1,250,132,103,-1,251,159,252,-1,159,161,252,-1,168,100,251,-1,53,173,50,-1,53,205,173,-1,253,254,255,-1,256,185,257,-1,256,258,185,-1,17,196,259,-1,260,261,262,-1,263,264,51,-1,265,264,263,-1,193,192,81,-1,108,107,230,-1,230,107,266,-1,51,79,49,-1,224,267,268,-1,269,225,270,-1,271,218,272,-1,218,220,272,-1,14,215,18,-1,211,62,68,-1,26,197,38,-1,81,192,82,-1,273,274,54,-1,54,56,273,-1,37,186,36,-1,72,124,268,-1,270,201,114,-1,114,275,270,-1,38,40,26,-1,40,27,26,-1,72,268,70,-1,268,267,70,-1,276,277,165,-1,277,271,165,-1,233,278,231,-1,233,279,278,-1,242,280,37,-1,2,281,65,-1,13,282,183,-1,183,14,13,-1,27,2,65,-1,16,18,63,-1,18,215,63,-1,182,283,214,-1,182,284,283,-1,285,1,4,-1,286,184,209,-1,208,227,149,-1,164,227,208,-1,287,288,289,-1,290,291,292,-1,290,293,291,-1,294,288,287,-1,288,294,295,-1,155,8,7,-1,155,151,8,-1,296,80,297,-1,296,298,80,-1,299,300,301,-1,299,302,300,-1,266,303,230,-1,303,266,304,-1,305,150,229,-1,305,108,150,-1,306,307,308,-1,306,309,307,-1,5,152,204,-1,5,8,152,-1,310,230,303,-1,310,148,230,-1,149,310,208,-1,310,149,148,-1,194,309,126,-1,194,307,309,-1,281,1,285,-1,1,281,2,-1,181,311,210,-1,181,312,311,-1,284,184,286,-1,184,284,182,-1,63,214,283,-1,214,63,215,-1,281,20,65,-1,22,20,281,-1,31,313,32,-1,313,31,314,-1,315,195,316,-1,315,317,195,-1,318,319,320,-1,318,167,319,-1,166,277,321,-1,277,166,322,-1,280,323,324,-1,323,280,242,-1,325,231,278,-1,231,325,326,-1,279,327,43,-1,327,279,233,-1,328,279,329,-1,328,278,279,-1,330,325,331,-1,330,324,325,-1,280,186,37,-1,186,280,187,-1,276,321,277,-1,216,321,276,-1,332,333,334,-1,332,143,333,-1,186,144,36,-1,186,188,144,-1,43,335,41,-1,43,327,335,-1,114,336,275,-1,116,336,114,-1,337,70,267,-1,70,337,6,-1,338,339,340,-1,338,191,339,-1,129,146,240,-1,129,128,146,-1,213,29,28,-1,213,66,29,-1,30,16,33,-1,30,17,16,-1,201,268,124,-1,270,268,201,-1,338,189,191,-1,338,121,189,-1,240,341,129,-1,240,342,341,-1,255,262,261,-1,343,262,255,-1,344,154,153,-1,73,154,344,-1,273,206,345,-1,206,273,56,-1,236,245,346,-1,238,245,236,-1,78,347,289,-1,78,77,347,-1,348,349,350,-1,348,134,349,-1,134,351,349,-1,133,351,134,-1,352,73,75,-1,352,154,73,-1,246,353,354,-1,246,243,353,-1,59,355,249,-1,355,59,58,-1,356,51,48,-1,356,263,51,-1,193,80,298,-1,193,81,80,-1,357,207,170,-1,207,357,244,-1,358,245,359,-1,245,358,346,-1,211,38,197,-1,38,211,68,-1,322,271,277,-1,322,218,271,-1,220,360,272,-1,220,361,360,-1,233,336,327,-1,233,232,336,-1,269,275,362,-1,275,269,270,-1,225,268,270,-1,225,224,268,-1,152,82,192,-1,152,151,82,-1,363,171,221,-1,171,363,364,-1,365,366,367,-1,366,365,368,-1,369,370,371,-1,370,369,176,-1,372,287,373,-1,287,372,294,-1,374,293,375,-1,293,374,291,-1,98,376,97,-1,376,98,4,-1,285,22,281,-1,285,377,22,-1,299,107,378,-1,266,107,299,-1,379,298,302,-1,379,193,298,-1,47,380,45,-1,47,381,380,-1,340,382,338,-1,340,383,382,-1,384,385,386,-1,387,385,384,-1,323,388,326,-1,323,389,388,-1,390,256,257,-1,390,391,256,-1,392,315,393,-1,315,392,320,-1,344,156,222,-1,344,44,156,-1,120,394,118,-1,394,120,395,-1,396,397,398,-1,397,396,399,-1,136,400,401,-1,400,136,402,-1,403,350,349,-1,350,403,404,-1,405,406,407,-1,405,408,406,-1,96,409,410,-1,96,411,409,-1,412,413,93,-1,412,414,413,-1,177,94,180,-1,94,177,415,-1,416,235,417,-1,235,416,172,-1,48,418,356,-1,174,418,48,-1,51,419,79,-1,51,264,419,-1,260,52,420,-1,52,260,262,-1,317,196,195,-1,259,196,317,-1,256,421,258,-1,393,421,256,-1,185,330,257,-1,185,187,330,-1,351,422,423,-1,424,422,351,-1,425,255,426,-1,425,253,255,-1,427,255,254,-1,255,427,343,-1,50,174,48,-1,50,173,174,-1,341,142,129,-1,341,428,142,-1,209,9,178,-1,209,210,9,-1,169,251,429,-1,169,168,251,-1,100,159,251,-1,100,99,159,-1,430,420,431,-1,430,260,420,-1,132,252,161,-1,252,132,250,-1,370,358,368,-1,370,57,358,-1,41,432,112,-1,41,335,432,-1,433,434,435,-1,434,433,436,-1,237,103,130,-1,237,105,103,-1,247,295,248,-1,247,288,295,-1,434,113,112,-1,202,113,434,-1,437,114,223,-1,437,115,114,-1,202,227,164,-1,227,202,228,-1,229,436,305,-1,229,228,436,-1,438,241,147,-1,438,439,241,-1,388,440,234,-1,388,386,440,-1,309,441,442,-1,441,309,306,-1,354,300,345,-1,301,300,354,-1,237,353,238,-1,237,110,353,-1,366,357,364,-1,366,359,357,-1,443,425,190,-1,443,253,425,-1,145,439,438,-1,145,444,439,-1,11,406,445,-1,11,86,406,-1,139,198,446,-1,138,198,139,-1,447,177,179,-1,447,417,177,-1,83,375,407,-1,83,374,375,-1,448,250,449,-1,448,252,250,-1,310,158,208,-1,131,158,310,-1,354,110,109,-1,353,110,354,-1,102,449,250,-1,248,449,102,-1,221,394,363,-1,221,222,394,-1,260,117,261,-1,430,117,260,-1,419,431,420,-1,431,419,450,-1,176,57,370,-1,176,58,57,-1,407,372,405,-1,407,375,372,-1,92,415,446,-1,92,94,415,-1,446,199,92,-1,446,198,199,-1,386,451,440,-1,386,385,451,-1,438,240,145,-1,438,342,240,-1,326,234,231,-1,326,388,234,-1,452,391,390,-1,452,217,391,-1,131,303,111,-1,310,303,131,-1,109,301,354,-1,109,304,301,-1,442,126,309,-1,126,442,175,-1,345,296,273,-1,345,300,296,-1,335,115,432,-1,115,335,116,-1,382,444,122,-1,387,444,382,-1,153,381,47,-1,153,7,381,-1,143,88,90,-1,332,88,143,-1,24,284,25,-1,24,283,284,-1,13,87,282,-1,13,15,87,-1,178,11,179,-1,178,9,11,-1,411,312,409,-1,411,311,312,-1,374,85,97,-1,374,83,85,-1,421,313,334,-1,421,316,313,-1,217,392,391,-1,219,392,217,-1,219,320,392,-1,320,219,318,-1,33,283,24,-1,283,33,63,-1,67,60,62,-1,67,66,60,-1,397,367,395,-1,365,367,397,-1,453,417,447,-1,453,416,417,-1,364,170,171,-1,364,357,170,-1,404,347,350,-1,404,373,347,-1,423,453,454,-1,423,422,453,-1,455,254,456,-1,455,427,254,-1,190,380,191,-1,190,425,380,-1,337,383,340,-1,226,383,337,-1,248,290,449,-1,248,295,290,-1,171,54,75,-1,55,54,171,-1,412,90,88,-1,90,412,91,-1,169,0,162,-1,169,3,0,-1,99,165,160,-1,99,276,165,-1,452,329,361,-1,452,328,329,-1,69,62,167,-1,69,68,62,-1,433,437,441,-1,433,435,437,-1,378,106,308,-1,378,107,106,-1,457,203,89,-1,457,428,203,-1,138,455,200,-1,138,137,455,-1,427,53,343,-1,205,53,427,-1,137,427,455,-1,137,205,427,-1,199,428,457,-1,199,142,428,-1,89,36,144,-1,89,203,36,-1,223,175,442,-1,223,201,175,-1,64,19,212,-1,64,20,19,-1,71,6,5,-1,71,70,6,-1,239,128,127,-1,128,239,458,-1,328,390,331,-1,452,390,328,-1,98,410,377,-1,98,96,410,-1,409,282,87,-1,409,312,282,-1,25,286,414,-1,286,25,284,-1,135,265,133,-1,264,265,135,-1,222,73,344,-1,74,73,222,-1,414,209,413,-1,209,414,286,-1,459,448,292,-1,429,448,459,-1,288,355,289,-1,247,355,288,-1,402,369,400,-1,369,402,76,-1,267,226,337,-1,224,226,267,-1,456,253,443,-1,456,254,253,-1,422,416,453,-1,422,418,416,-1,403,454,408,-1,403,423,454,-1,247,249,355,-1,247,104,249,-1,454,447,445,-1,454,453,447,-1,400,371,399,-1,400,369,371,-1,17,61,60,-1,259,61,17,-1,61,167,62,-1,319,167,61,-1,218,318,219,-1,318,218,322,-1,258,334,333,-1,421,334,258,-1,100,162,101,-1,100,168,162,-1,429,252,448,-1,251,252,429,-1,377,21,22,-1,377,410,21,-1,10,86,11,-1,10,84,86,-1,93,91,412,-1,95,91,93,-1,332,23,88,-1,23,332,314,-1,382,121,338,-1,121,382,122,-1,119,156,46,-1,119,118,156,-1,339,7,6,-1,7,339,381,-1,226,385,383,-1,226,451,385,-1,297,352,274,-1,297,460,352,-1,307,193,379,-1,193,307,194,-1,306,433,441,-1,306,461,433,-1,217,361,220,-1,452,361,217,-1,333,185,258,-1,188,185,333,-1,242,389,323,-1,241,389,242,-1,444,384,439,-1,387,384,444,-1,451,362,440,-1,451,269,362,-1,456,458,239,-1,456,443,458,-1,428,34,203,-1,428,341,34,-1,200,456,239,-1,200,455,456,-1,89,95,457,-1,89,91,95,-1,408,445,406,-1,445,408,454,-1,348,76,402,-1,76,348,77,-1,396,450,401,-1,396,431,450,-1,430,120,117,-1,430,398,120,-1,368,359,366,-1,368,358,359,-1,264,450,419,-1,450,264,135,-1,135,401,450,-1,135,136,401,-1,244,246,207,-1,243,246,244,-1,131,161,158,-1,131,132,161,-1,292,449,290,-1,292,448,449,-1,179,445,447,-1,179,11,445,-1,235,446,415,-1,139,446,235,-1,225,451,226,-1,451,225,269,-1,145,122,444,-1,123,122,145,-1,443,189,458,-1,443,190,189,-1,119,261,117,-1,119,157,261,-1,395,363,394,-1,395,367,363,-1,308,379,378,-1,308,307,379,-1,437,442,441,-1,437,223,442,-1,440,232,234,-1,440,362,232,-1,439,389,241,-1,439,384,389,-1,35,438,147,-1,35,342,438,-1,434,228,202,-1,436,228,434,-1,432,437,435,-1,437,432,115,-1,405,373,404,-1,405,372,373,-1,111,304,109,-1,303,304,111,-1,461,436,433,-1,436,461,305,-1,112,435,434,-1,112,432,435,-1,399,365,397,-1,399,371,365,-1,101,276,99,-1,216,276,101,-1,431,398,430,-1,431,396,398,-1,429,3,169,-1,459,3,429,-1,84,311,411,-1,10,311,84,-1,413,178,180,-1,178,413,209,-1,457,92,199,-1,457,95,92,-1,349,423,403,-1,351,423,349,-1,380,426,45,-1,380,425,426,-1,356,422,424,-1,356,418,422,-1,393,316,421,-1,316,393,315,-1,420,79,419,-1,79,420,52,-1,418,172,416,-1,172,418,174,-1,415,417,235,-1,415,177,417,-1,93,180,94,-1,93,413,180,-1,25,412,88,-1,25,414,412,-1,87,410,409,-1,410,87,21,-1,85,411,96,-1,85,84,411,-1,407,86,83,-1,407,406,86,-1,404,408,405,-1,404,403,408,-1,134,402,136,-1,402,134,348,-1,399,401,400,-1,399,396,401,-1,398,395,120,-1,395,398,397,-1,118,222,156,-1,222,118,394,-1,259,319,61,-1,317,319,259,-1,391,393,256,-1,391,392,393,-1,331,257,330,-1,331,390,257,-1,389,386,388,-1,384,386,389,-1,383,387,382,-1,383,385,387,-1,381,191,380,-1,381,339,191,-1,378,302,299,-1,378,379,302,-1,4,377,285,-1,4,98,377,-1,291,97,376,-1,291,374,97,-1,375,294,372,-1,294,375,293,-1,373,289,347,-1,289,373,287,-1,76,176,369,-1,176,76,78,-1,371,368,365,-1,368,371,370,-1,367,364,363,-1,364,367,366,-1,75,221,171,-1,75,74,221,-1,460,154,352,-1,460,155,154,-1,71,125,72,-1,71,204,125,-1,362,336,232,-1,336,362,275,-1,361,42,360,-1,361,329,42,-1,69,321,39,-1,69,166,321,-1,197,67,211,-1,29,67,197,-1,64,28,65,-1,64,213,28,-1,12,212,19,-1,12,18,212,-1,57,346,358,-1,346,57,59,-1,359,244,357,-1,244,359,245,-1,56,170,207,-1,56,55,170,-1,296,274,273,-1,296,297,274,-1,58,289,355,-1,289,58,78,-1,243,238,353,-1,238,243,245,-1,426,261,157,-1,261,426,255,-1,45,157,46,-1,45,426,157,-1,424,263,356,-1,424,265,263,-1,133,424,351,-1,265,424,133,-1,350,77,348,-1,347,77,350,-1,249,346,59,-1,236,346,249,-1,345,246,354,-1,246,345,206,-1,274,75,54,-1,274,352,75,-1,44,153,47,-1,44,344,153,-1,343,52,262,-1,53,52,343,-1,458,121,123,-1,458,189,121,-1,42,113,360,-1,42,41,113,-1,60,18,17,-1,60,212,18,-1,163,271,272,-1,271,163,165,-1,341,35,34,-1,341,342,35,-1,128,123,146,-1,458,123,128,-1,6,340,339,-1,340,6,337,-1,327,116,335,-1,327,336,116,-1,163,360,113,-1,163,272,360,-1,143,188,333,-1,143,144,188,-1,314,334,313,-1,314,332,334,-1,66,212,60,-1,66,213,212,-1,216,39,321,-1,40,39,216,-1,324,187,280,-1,324,330,187,-1,331,278,328,-1,331,325,278,-1,43,329,279,-1,43,42,329,-1,324,326,325,-1,326,324,323,-1,322,167,318,-1,322,166,167,-1,320,317,315,-1,320,319,317,-1,316,32,313,-1,316,195,32,-1,314,24,23,-1,314,31,24,-1,21,12,19,-1,15,12,21,-1,282,181,183,-1,312,181,282,-1,210,10,9,-1,10,210,311,-1,125,152,192,-1,125,204,152,-1,305,106,108,-1,305,461,106,-1,297,82,460,-1,297,80,82,-1,126,192,194,-1,126,125,192,-1,306,106,461,-1,106,306,308,-1,229,149,227,-1,149,229,150,-1,266,301,304,-1,266,299,301,-1,300,298,296,-1,300,302,298,-1,460,151,155,-1,460,82,151,-1,459,4,3,-1,459,376,4,-1,295,293,290,-1,295,294,293,-1,292,376,459,-1,292,291,376,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rtrpzium_Coord',point=[(-6.64818,28.44327,3.10561),(-6.6423,28.44655,3.11712),(-6.68996,28.37927,3.15033),(-6.61655,28.48024,3.09397),(-6.6128,28.48497,3.10696),(-6.429,28.85653,2.68731),(-6.46322,28.87057,2.7126),(-6.41267,28.86897,2.69648),(-6.41894,28.8529,2.68602),(-6.59361,28.65515,3.20451),(-6.59045,28.63798,3.2021),(-6.53183,28.66891,3.18672),(-6.73342,28.50675,3.27631),(-6.74282,28.54797,3.29847),(-6.75822,28.55047,3.30165),(-6.71981,28.51364,3.27532),(-6.81854,28.50804,3.24095),(-6.82603,28.50315,3.23132),(-6.806,28.49562,3.24304),(-6.70597,28.4652,3.24888),(-6.70312,28.421,3.20369),(-6.69563,28.47802,3.25165),(-6.68844,28.4267,3.20123),(-6.80094,28.69236,3.23048),(-6.82558,28.63832,3.25455),(-6.74946,28.69875,3.22466),(-6.76484,28.3966,3.0525),(-6.75028,28.40042,3.04866),(-6.76067,28.40144,3.15164),(-6.77346,28.40785,3.14224),(-6.85962,28.56333,3.22599),(-6.83965,28.64457,3.21404),(-6.84225,28.64003,3.20082),(-6.85225,28.56943,3.23764),(-6.69175,28.92668,2.96008),(-6.6908,28.92645,2.94781),(-6.74646,28.87915,2.93615),(-6.74382,28.87815,2.92617),(-6.81182,28.42421,3.01669),(-6.8133,28.43031,3.01117),(-6.80592,28.42441,3.00541),(-6.691,28.68953,2.69792),(-6.70123,28.68996,2.70893),(-6.69493,28.70018,2.69972),(-6.36483,28.88862,2.75099),(-6.37146,28.90888,2.80661),(-6.36101,28.90247,2.80817),(-6.3769,28.89345,2.74899),(-6.36457,28.87074,3.13764),(-6.3698,28.90487,3.08109),(-6.37993,28.90849,3.0848),(-6.35455,28.86566,3.13115),(-6.36971,28.90511,3.01563),(-6.37904,28.91095,3.01993),(-6.35596,28.72751,2.62603),(-6.34731,28.70699,2.63355),(-6.3649,28.68278,2.61214),(-6.3625,28.59022,2.86136),(-6.35577,28.5766,2.92098),(-6.37597,28.56836,2.85918),(-6.79658,28.45511,3.21251),(-6.84561,28.49517,3.17808),(-6.84103,28.47197,3.1595),(-6.80945,28.55117,3.25765),(-6.75252,28.42209,3.19476),(-6.70065,28.38046,3.16058),(-6.78451,28.43039,3.17911),(-6.8043,28.43771,3.15437),(-6.827,28.44781,3.08343),(-6.81546,28.4773,3.03883),(-6.4813,28.8294,2.67989),(-6.46281,28.8273,2.67239),(-6.49956,28.7923,2.65613),(-6.36011,28.82105,2.6722),(-6.33995,28.80239,2.68541),(-6.35057,28.77693,2.64461),(-6.32575,28.64351,3.00466),(-6.31507,28.6314,3.04127),(-6.33357,28.59637,2.9904),(-6.36421,28.89457,3.07086),(-6.41646,28.74231,2.61547),(-6.42802,28.75497,2.63586),(-6.40929,28.78075,2.63378),(-6.52106,28.59142,3.13924),(-6.58353,28.60285,3.188),(-6.57499,28.55962,3.17063),(-6.52396,28.62817,3.16746),(-6.70629,28.52897,3.26298),(-6.77632,28.74657,3.20643),(-6.69666,28.85156,3.04504),(-6.72609,28.81133,3.10971),(-6.69331,28.80742,3.11378),(-6.61447,28.82214,3.11339),(-6.65501,28.79461,3.16082),(-6.61414,28.81287,3.14944),(-6.65389,28.81474,3.11358),(-6.60779,28.53713,3.18759),(-6.58121,28.53799,3.12605),(-6.61049,28.50896,3.14411),(-6.7089,28.46226,2.93848),(-6.68742,28.46938,2.96405),(-6.73726,28.42888,2.98588),(-6.44604,28.5491,2.85622),(-6.46216,28.53993,2.80758),(-6.41379,28.56081,2.85733),(-6.4261,28.55971,2.80859),(-6.53894,28.62098,2.7471),(-6.52466,28.60109,2.71438),(-6.56417,28.58329,2.77454),(-6.47304,28.55776,2.68892),(-6.45836,28.56321,2.72418),(-6.49902,28.53944,2.734),(-6.67748,28.67062,2.70868),(-6.71273,28.62113,2.75745),(-6.61134,28.76312,2.64442),(-6.63169,28.73854,2.64766),(-6.64218,28.74628,2.64005),(-6.34978,28.86964,2.86738),(-6.34067,28.84745,2.80505),(-6.35694,28.88941,2.83713),(-6.33891,28.82587,2.84052),(-6.49143,28.9066,2.83074),(-6.51874,28.89588,2.8396),(-6.52121,28.91427,2.86154),(-6.50922,28.78186,2.65558),(-6.46316,28.78236,2.67104),(-6.48609,28.74758,2.6787),(-6.56425,28.92925,2.94415),(-6.55826,28.93026,2.90869),(-6.60343,28.94197,2.9454),(-6.4783,28.53088,2.75895),(-6.56907,28.50938,2.82314),(-6.54838,28.53047,2.8649),(-6.30886,28.72884,3.14082),(-6.29866,28.69669,3.11775),(-6.31838,28.77834,3.06303),(-6.31842,28.73781,3.03789),(-6.43005,28.90434,3.0257),(-6.48834,28.89694,3.0323),(-6.47312,28.8619,3.09237),(-6.41742,28.89028,3.08817),(-6.55343,28.90701,2.99132),(-6.60295,28.90944,2.99344),(-6.76516,28.78391,3.08488),(-6.7546,28.82639,3.005),(-6.59535,28.89347,2.88134),(-6.56664,28.92725,2.89995),(-6.69619,28.89097,2.91276),(-6.58833,28.54529,2.7915),(-6.6387,28.54744,2.81779),(-6.60708,28.55998,2.80065),(-6.41549,28.82283,2.66462),(-6.43139,28.82283,2.67818),(-6.38282,28.86814,2.69529),(-6.37185,28.82201,2.6649),(-6.40236,28.82667,2.66319),(-6.34243,28.86912,2.76959),(-6.36412,28.90471,2.85756),(-6.62445,28.50763,2.85854),(-6.65908,28.50293,2.9167),(-6.68056,28.49583,2.89111),(-6.6045,28.52162,2.89144),(-6.68295,28.43517,3.05196),(-6.73351,28.55652,2.81591),(-6.71583,28.55381,2.81828),(-6.74372,28.51995,2.89454),(-6.80561,28.49217,3.02267),(-6.81792,28.53081,3.07028),(-6.66028,28.47254,2.99712),(-6.64773,28.47411,3.03191),(-6.34793,28.68838,2.65944),(-6.32769,28.73243,2.66366),(-6.40488,28.85915,3.14307),(-6.39434,28.90316,3.08678),(-6.38119,28.86594,3.13987),(-6.52339,28.76377,2.66636),(-6.34417,28.60555,2.93161),(-6.53834,28.78926,3.17192),(-6.60542,28.72388,3.19773),(-6.53634,28.74633,3.18551),(-6.60978,28.76832,3.17359),(-6.65931,28.62657,3.23577),(-6.71629,28.64513,3.2452),(-6.72154,28.59693,3.2712),(-6.66894,28.67596,3.22367),(-6.75778,28.79518,2.97303),(-6.75118,28.86807,2.93135),(-6.74341,28.83889,2.90667),(-6.75993,28.81858,2.99583),(-6.48174,28.91233,2.83878),(-6.45064,28.91049,2.84454),(-6.45421,28.9057,2.80817),(-6.45394,28.77593,2.66899),(-6.45339,28.72488,2.64124),(-6.47704,28.7407,2.67609),(-6.84107,28.61447,3.17783),(-6.85478,28.54168,3.21528),(-6.79029,28.41365,3.07835),(-6.54261,28.88489,3.03848),(-6.5969,28.87299,3.04469),(-6.5034,28.9027,2.98692),(-6.56992,28.78148,2.64475),(-6.68415,28.59497,2.77309),(-6.69503,28.89118,2.99939),(-6.4427,28.82682,2.68077),(-6.4009,28.9081,3.02241),(-6.4025,28.62991,2.62342),(-6.37763,28.64933,2.65666),(-6.6541,28.5401,2.83134),(-6.63828,28.70442,3.20962),(-6.62739,28.64046,3.22065),(-6.81565,28.44274,3.1189),(-6.78277,28.44857,3.216),(-6.77268,28.42621,3.18618),(-6.77923,28.58385,3.27757),(-6.7954,28.54474,3.26702),(-6.7868,28.45082,2.97638),(-6.7616,28.64424,2.93435),(-6.77219,28.55262,2.955),(-6.79171,28.59003,3.00156),(-6.75113,28.60079,2.87459),(-6.3268,28.77976,2.69839),(-6.32593,28.82724,2.73316),(-6.58005,28.758,2.65575),(-6.51768,28.81358,2.6897),(-6.55111,28.81396,2.68338),(-6.52626,28.83983,2.72743),(-6.65487,28.54993,2.82063),(-6.62934,28.5777,2.78949),(-6.61399,28.57035,2.79744),(-6.53062,28.56842,2.72269),(-6.70199,28.76303,2.7815),(-6.66268,28.76451,2.69922),(-6.68642,28.74368,2.72396),(-6.67817,28.77925,2.76215),(-6.46677,28.84348,3.14625),(-6.3961,28.57161,2.80948),(-6.43843,28.55872,2.75986),(-6.40461,28.58244,2.76298),(-6.51846,28.90856,2.94152),(-6.61142,28.94034,2.93729),(-6.6888,28.85889,2.87756),(-6.71223,28.85246,2.88819),(-6.42391,28.58519,2.71608),(-6.38809,28.61792,2.70871),(-6.39557,28.59174,2.75769),(-6.43849,28.58906,2.65515),(-6.39074,28.56945,2.93297),(-6.42335,28.56326,2.93782),(-6.38704,28.56112,2.86038),(-6.5277,28.55168,2.90669),(-6.63761,28.51009,2.94229),(-6.58455,28.53569,2.92435),(-6.40604,28.91473,2.89653),(-6.40539,28.91151,2.92024),(-6.37692,28.91331,2.90773),(-6.77639,28.71567,3.00959),(-6.75471,28.76157,2.94023),(-6.77349,28.74783,3.04549),(-6.85019,28.5184,3.19667),(-6.36515,28.89461,2.95191),(-6.36731,28.90683,2.91177),(-6.36868,28.90574,2.9631),(-6.33973,28.8346,3.14152),(-6.33793,28.82547,3.09984),(-6.32399,28.79674,3.14258),(-6.50856,28.58419,2.67887),(-6.49381,28.82965,2.68714),(-6.51416,28.79076,2.6582),(-6.58077,28.79748,2.69049),(-6.57436,28.79093,2.64652),(-6.7539,28.52145,2.91254),(-6.74178,28.56337,2.81945),(-6.37351,28.68421,2.60191),(-6.36734,28.73151,2.61923),(-6.61325,28.77126,2.64887),(-6.76616,28.48212,2.94145),(-6.7744,28.48987,2.9465),(-6.72583,28.74688,2.80087),(-6.71017,28.72293,2.74875),(-6.73566,28.84606,2.89884),(-6.68524,28.38792,3.16165),(-6.71143,28.58339,3.27),(-6.79465,28.59233,3.2701),(-6.72888,28.65705,3.24069),(-6.63886,28.45114,3.12731),(-6.67343,28.69341,3.21702),(-6.36635,28.59244,3.01239),(-6.37034,28.5867,2.99927),(-6.34016,28.58951,2.99852),(-6.47098,28.56504,3.03535),(-6.52941,28.54948,3.06732),(-6.53277,28.54513,3.05387),(-6.46757,28.57,3.04855),(-6.39953,28.58183,3.02557),(-6.40266,28.57647,3.01228),(-6.41269,28.69962,2.59257),(-6.40407,28.7417,2.61208),(-6.42404,28.70313,2.59714),(-6.4866,28.60656,2.64523),(-6.44514,28.64475,2.60658),(-6.47921,28.5979,2.64297),(-6.45451,28.65059,2.61087),(-6.52282,28.55833,2.72111),(-6.5019,28.57433,2.67808),(-6.56995,28.59155,2.77359),(-6.52523,28.6625,2.72626),(-6.4969,28.69876,2.69938),(-6.51642,28.65691,2.72314),(-6.50653,28.7035,2.70304),(-6.58435,28.53289,2.79627),(-6.62214,28.6242,3.21829),(-6.65358,28.61048,3.23483),(-6.82755,28.68261,3.18049),(-6.82383,28.68842,3.19257),(-6.82589,28.62211,3.11616),(-6.827,28.65427,3.15141),(-6.83872,28.58606,3.14801),(-6.80481,28.56038,3.03592),(-6.82831,28.55838,3.10913),(-6.81534,28.59118,3.07602),(-6.79476,28.45824,2.98072),(-6.7889,28.52235,2.98883),(-6.70416,28.8185,2.85496),(-6.7269,28.81009,2.86753),(-6.72639,28.77789,2.83341),(-6.70309,28.79044,2.81782),(-6.67227,28.72623,2.67207),(-6.73223,28.73614,2.80774),(-6.71529,28.71069,2.75337),(-6.73491,28.80384,2.87685),(-6.73361,28.77071,2.84302),(-6.80802,28.73239,3.17112),(-6.77124,28.77395,3.0773),(-6.81286,28.72529,3.16016),(-6.66627,28.7179,2.66865),(-6.6474,28.75351,2.64372),(-6.47327,28.87077,2.71707),(-6.46526,28.9001,2.8023),(-6.45563,28.89371,2.75513),(-6.469,28.89016,2.75802),(-6.65094,28.93395,2.95369),(-6.65062,28.93348,2.94248),(-6.37803,28.91196,2.96304),(-6.37068,28.86433,2.69945),(-6.41175,28.63127,2.61483),(-6.38495,28.5803,2.81057),(-6.32106,28.62532,3.04821),(-6.29685,28.66704,3.08951),(-6.30407,28.69124,3.12533),(-6.30248,28.65982,3.09548),(-6.31515,28.72484,3.14934),(-6.36113,28.77878,2.63664),(-6.43557,28.57659,2.71869),(-6.45038,28.58321,2.65354),(-6.36365,28.57037,2.92943),(-6.34718,28.83453,3.15),(-6.35905,28.65547,2.71375),(-6.36638,28.60643,2.81445),(-6.37022,28.62283,2.76778),(-6.72362,28.61939,2.77035),(-6.73426,28.65392,2.81668),(-6.6219,28.7813,2.69676),(-6.33194,28.75174,2.74659),(-6.3395,28.698,2.72022),(-6.34187,28.69902,2.84051),(-6.35133,28.66378,2.77682),(-6.33968,28.72291,2.79523),(-6.3533,28.64259,2.82173),(-6.33501,28.65877,2.94335),(-6.35527,28.62151,2.86665),(-6.34406,28.67525,2.88581),(-6.39239,28.60733,3.06378),(-6.35397,28.61888,3.05375),(-6.5256,28.56854,3.10005),(-6.46365,28.59116,3.08106),(-6.58649,28.51971,3.0882),(-6.63833,28.47949,3.1645),(-6.50195,28.63085,2.68479),(-6.47569,28.6746,2.6551),(-6.41145,28.90704,2.80521),(-6.41394,28.89215,2.7471),(-6.52209,28.87267,2.81564),(-6.52417,28.85619,2.77151),(-6.63342,28.83376,2.83509),(-6.5855,28.82371,2.78471),(-6.63264,28.81332,2.79346),(-6.58542,28.84068,2.82782),(-6.6798,28.80305,2.80225),(-6.68144,28.82695,2.8424),(-6.75048,28.72721,2.90452),(-6.76899,28.67988,2.97194),(-6.80237,28.62407,3.04291),(-6.81306,28.65825,3.08432),(-6.32441,28.80565,2.77302),(-6.32806,28.78223,2.81369),(-6.33878,28.77558,2.93903),(-6.33046,28.75562,2.85935),(-6.34017,28.80026,2.88988),(-6.33288,28.72913,2.90502),(-6.32587,28.71214,2.95512),(-6.33015,28.75804,2.98228),(-6.31846,28.69739,3.01278),(-6.34295,28.67905,3.13225),(-6.33975,28.64939,3.10127),(-6.38411,28.63705,3.10816),(-6.46216,28.65105,3.15079),(-6.45899,28.61645,3.11982),(-6.38577,28.66664,3.13883),(-6.64634,28.56628,3.22314),(-6.63771,28.51368,3.2092),(-6.61565,28.58479,3.2044),(-6.69591,28.77647,3.17223),(-6.64665,28.74947,3.18523),(-6.68354,28.73071,3.19689),(-6.54045,28.82804,3.14783),(-6.40129,28.82203,3.15865),(-6.46685,28.80814,3.16513),(-6.37058,28.82904,3.15376),(-6.3506,28.85313,3.04278),(-6.36051,28.87455,2.99997),(-6.81294,28.69417,3.125),(-6.36124,28.78937,3.15675),(-6.34916,28.71453,3.15453),(-6.33105,28.79553,3.15138),(-6.40874,28.91083,2.85086),(-6.37413,28.91116,2.85607),(-6.40314,28.90975,2.97132),(-6.64898,28.90026,2.9964),(-6.61252,28.51317,3.0119),(-6.3499,28.84504,2.92044),(-6.3447,28.82219,2.97309),(-6.65458,28.70451,2.67814),(-6.57908,28.64946,2.72643),(-6.64815,28.63909,2.72518),(-6.62532,28.67801,2.69698),(-6.60371,28.61092,2.75257),(-6.60251,28.71707,2.66883),(-6.64576,28.89215,2.89703),(-6.63958,28.8629,2.86604),(-6.63187,28.79299,2.75188),(-6.55445,28.68814,2.70034),(-6.5399,28.72994,2.68054),(-6.44249,28.91614,2.88556),(-6.59038,28.86704,2.85456),(-6.46872,28.69082,3.17273),(-6.53902,28.84324,3.10215),(-6.46728,28.76903,3.17335),(-6.5556,28.53989,2.99223),(-6.49528,28.55689,2.97172),(-6.33444,28.80407,3.00948),(-6.58559,28.80685,2.74165),(-6.74627,28.69298,2.86887),(-6.39859,28.78181,3.1634),(-6.39021,28.70217,3.16081),(-6.43562,28.90698,2.97935),(-6.44119,28.90972,2.933),(-6.64677,28.86221,3.04486),(-6.51156,28.91834,2.86945),(-6.58997,28.51613,3.07444),(-6.39551,28.78403,2.63156),(-6.54798,28.62651,2.75021)]))),
        Shape(DEF='rtrpzoid',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rtrpzoid_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,20,21,18,-1,22,16,15,-1,23,24,25,-1,25,26,23,-1,27,28,29,-1,27,30,28,-1,31,32,33,-1,33,34,31,-1,0,35,1,-1,0,36,35,-1,15,37,38,-1,39,9,11,-1,39,40,9,-1,7,26,25,-1,25,8,7,-1,41,42,43,-1,44,43,45,-1,45,46,44,-1,47,1,35,-1,48,49,50,-1,51,52,53,-1,51,54,52,-1,0,23,55,-1,56,54,57,-1,58,59,60,-1,61,62,63,-1,61,64,62,-1,65,66,67,-1,66,68,67,-1,69,70,71,-1,69,72,70,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,80,82,81,-1,83,84,85,-1,86,34,87,-1,88,89,90,-1,90,91,88,-1,92,93,94,-1,94,95,92,-1,81,96,79,-1,81,97,96,-1,98,19,99,-1,98,100,19,-1,101,102,27,-1,101,103,102,-1,104,105,3,-1,5,106,3,-1,107,24,3,-1,55,36,0,-1,21,108,109,-1,110,111,70,-1,102,103,7,-1,110,112,113,-1,72,114,112,-1,112,110,72,-1,115,71,70,-1,70,5,115,-1,63,116,61,-1,63,20,116,-1,117,21,118,-1,119,78,75,-1,120,78,77,-1,121,78,122,-1,123,78,124,-1,125,78,126,-1,127,128,58,-1,129,95,130,-1,130,131,129,-1,132,133,88,-1,133,60,88,-1,46,134,135,-1,46,45,28,-1,28,134,46,-1,136,29,137,-1,101,27,29,-1,29,138,101,-1,139,140,141,-1,142,139,143,-1,144,139,145,-1,146,139,147,-1,139,148,149,-1,150,151,32,-1,150,16,151,-1,152,22,48,-1,153,49,48,-1,15,154,48,-1,155,156,157,-1,156,98,157,-1,158,85,159,-1,160,67,161,-1,160,65,67,-1,61,116,161,-1,161,67,61,-1,162,152,50,-1,162,84,152,-1,163,164,10,-1,154,153,48,-1,165,49,153,-1,22,15,48,-1,48,50,152,-1,148,139,146,-1,147,139,144,-1,145,139,142,-1,143,139,166,-1,57,167,168,-1,57,54,167,-1,136,138,29,-1,44,41,43,-1,169,112,170,-1,171,172,173,-1,172,174,173,-1,175,89,12,-1,41,44,14,-1,44,135,14,-1,176,97,81,-1,176,174,97,-1,129,92,95,-1,129,177,92,-1,58,60,133,-1,126,78,123,-1,124,78,121,-1,122,78,120,-1,76,78,119,-1,125,75,78,-1,157,99,87,-1,157,98,99,-1,178,179,69,-1,69,71,178,-1,106,8,107,-1,6,110,113,-1,110,6,111,-1,25,24,107,-1,106,107,3,-1,105,4,3,-1,2,104,3,-1,168,180,181,-1,168,167,180,-1,158,182,183,-1,156,100,98,-1,156,184,100,-1,185,186,96,-1,96,97,185,-1,82,80,187,-1,95,9,130,-1,95,94,9,-1,87,34,33,-1,33,157,87,-1,155,84,83,-1,81,74,176,-1,81,82,74,-1,90,188,171,-1,171,173,90,-1,115,5,4,-1,67,64,61,-1,67,68,64,-1,128,59,58,-1,107,8,25,-1,181,101,168,-1,181,103,101,-1,141,166,139,-1,149,140,139,-1,50,49,162,-1,170,134,169,-1,135,44,46,-1,137,189,136,-1,102,7,113,-1,7,6,113,-1,28,45,29,-1,45,137,29,-1,190,40,39,-1,191,192,164,-1,164,153,191,-1,35,36,193,-1,0,194,24,-1,24,23,0,-1,152,84,151,-1,154,191,153,-1,154,195,191,-1,33,32,84,-1,32,151,84,-1,196,31,34,-1,197,198,199,-1,198,200,199,-1,47,201,1,-1,97,202,185,-1,203,190,41,-1,190,42,41,-1,80,159,162,-1,80,79,159,-1,186,185,160,-1,165,204,49,-1,165,93,204,-1,42,190,39,-1,160,182,186,-1,205,178,105,-1,105,206,205,-1,2,194,0,-1,117,108,21,-1,72,110,70,-1,71,115,178,-1,106,6,8,-1,106,111,6,-1,206,104,201,-1,206,105,104,-1,201,2,1,-1,104,2,201,-1,178,108,117,-1,205,108,178,-1,172,65,202,-1,65,172,66,-1,158,79,96,-1,159,79,158,-1,94,165,163,-1,94,93,165,-1,41,13,203,-1,14,13,41,-1,66,171,207,-1,66,172,171,-1,208,175,209,-1,208,188,175,-1,182,96,186,-1,96,182,158,-1,80,49,204,-1,80,162,49,-1,199,201,47,-1,199,200,201,-1,34,197,196,-1,86,197,34,-1,198,18,21,-1,18,198,210,-1,116,184,161,-1,184,116,100,-1,196,211,31,-1,196,212,211,-1,213,214,215,-1,214,213,17,-1,38,154,15,-1,38,195,154,-1,10,192,11,-1,164,192,10,-1,22,151,16,-1,22,152,151,-1,189,42,39,-1,43,42,189,-1,134,30,169,-1,134,28,30,-1,109,205,206,-1,108,205,109,-1,140,216,217,-1,216,140,149,-1,167,218,180,-1,218,167,219,-1,220,141,221,-1,220,166,141,-1,222,136,223,-1,56,136,222,-1,138,168,101,-1,168,138,57,-1,26,103,181,-1,26,7,103,-1,149,224,216,-1,149,148,224,-1,225,147,226,-1,147,225,146,-1,144,227,228,-1,145,227,144,-1,142,229,230,-1,143,229,142,-1,141,217,221,-1,141,140,217,-1,195,231,191,-1,231,195,232,-1,233,11,192,-1,234,11,233,-1,235,189,39,-1,236,189,235,-1,222,54,56,-1,222,52,54,-1,232,226,231,-1,226,232,225,-1,228,234,233,-1,227,234,228,-1,230,236,235,-1,229,236,230,-1,52,221,217,-1,221,52,222,-1,117,179,178,-1,118,179,117,-1,237,238,239,-1,237,114,238,-1,208,240,207,-1,208,241,240,-1,242,90,173,-1,242,91,90,-1,75,243,73,-1,75,125,243,-1,244,119,245,-1,119,244,76,-1,126,133,132,-1,123,133,126,-1,58,121,127,-1,121,58,124,-1,122,129,131,-1,120,129,122,-1,157,84,155,-1,157,33,84,-1,13,59,203,-1,59,13,60,-1,128,9,40,-1,130,9,128,-1,204,187,80,-1,187,204,246,-1,183,184,156,-1,183,182,184,-1,219,215,218,-1,219,213,215,-1,24,2,3,-1,24,194,2,-1,181,23,26,-1,23,181,180,-1,197,212,196,-1,212,197,199,-1,179,238,69,-1,179,62,238,-1,31,150,32,-1,31,211,150,-1,86,99,210,-1,87,99,86,-1,177,246,92,-1,177,244,246,-1,82,245,74,-1,245,82,187,-1,73,176,74,-1,73,242,176,-1,135,209,14,-1,135,247,209,-1,90,175,188,-1,175,90,89,-1,202,174,172,-1,202,97,174,-1,207,68,66,-1,240,68,207,-1,247,237,241,-1,247,170,237,-1,170,114,237,-1,112,114,170,-1,164,165,153,-1,163,165,164,-1,156,83,183,-1,156,155,83,-1,183,85,158,-1,183,83,85,-1,51,213,219,-1,37,213,51,-1,169,113,112,-1,30,113,169,-1,134,247,135,-1,134,170,247,-1,64,240,239,-1,64,68,240,-1,209,241,208,-1,247,241,209,-1,243,88,91,-1,243,132,88,-1,246,245,187,-1,246,244,245,-1,128,131,130,-1,131,128,127,-1,63,21,20,-1,248,21,63,-1,118,21,248,-1,210,19,18,-1,210,99,19,-1,214,211,193,-1,211,214,150,-1,239,62,64,-1,238,62,239,-1,115,105,178,-1,115,4,105,-1,109,198,21,-1,109,200,198,-1,212,47,35,-1,199,47,212,-1,218,36,55,-1,218,215,36,-1,17,150,214,-1,16,150,17,-1,204,92,246,-1,204,93,92,-1,128,203,59,-1,128,190,203,-1,128,40,190,-1,88,12,89,-1,60,12,88,-1,60,13,12,-1,242,174,176,-1,242,173,174,-1,162,85,84,-1,85,162,159,-1,120,177,129,-1,77,177,120,-1,127,122,131,-1,122,127,121,-1,133,124,58,-1,124,133,123,-1,125,132,243,-1,126,132,125,-1,245,75,74,-1,75,245,119,-1,77,244,177,-1,76,244,77,-1,91,73,243,-1,73,91,242,-1,239,241,237,-1,240,241,239,-1,69,114,72,-1,238,114,69,-1,62,248,63,-1,118,62,179,-1,62,118,248,-1,216,249,53,-1,216,224,249,-1,236,220,223,-1,220,236,229,-1,227,235,234,-1,230,235,227,-1,231,228,233,-1,228,231,226,-1,224,232,249,-1,225,232,224,-1,53,37,51,-1,53,38,37,-1,53,249,38,-1,189,223,136,-1,223,189,236,-1,234,39,11,-1,235,39,234,-1,191,233,192,-1,233,191,231,-1,249,195,38,-1,232,195,249,-1,229,166,220,-1,166,229,143,-1,145,230,227,-1,142,230,145,-1,226,144,228,-1,144,226,147,-1,148,225,224,-1,146,225,148,-1,136,57,138,-1,57,136,56,-1,221,223,220,-1,222,223,221,-1,180,55,23,-1,55,180,218,-1,54,219,167,-1,219,54,51,-1,217,53,52,-1,53,217,216,-1,206,200,109,-1,206,201,200,-1,30,102,113,-1,102,30,27,-1,189,45,43,-1,137,45,189,-1,17,37,15,-1,213,37,17,-1,215,193,36,-1,193,215,214,-1,193,212,35,-1,211,212,193,-1,184,160,161,-1,160,184,182,-1,116,19,100,-1,20,19,116,-1,197,210,198,-1,210,197,86,-1,207,188,208,-1,207,171,188,-1,209,12,14,-1,12,209,175,-1,163,9,94,-1,10,9,163,-1,202,160,185,-1,160,202,65,-1,111,5,70,-1,111,106,5,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rtrpzoid_Coord',point=[(-6.91268,28.37948,2.73988),(-6.91042,28.38968,2.73763),(-6.89147,28.38762,2.74907),(-6.84647,28.40459,2.77989),(-6.7813,28.42726,2.79208),(-6.78175,28.42146,2.82351),(-6.90446,28.31588,2.86865),(-6.92125,28.30348,2.8622),(-6.91285,28.31168,2.84716),(-7.34919,28.54992,3.18098),(-7.35531,28.5477,3.16109),(-7.35121,28.53884,3.18028),(-7.03181,28.54893,3.32324),(-7.05625,28.5359,3.3281),(-7.04945,28.52536,3.32557),(-7.09614,28.51235,2.94156),(-7.04322,28.52567,2.8754),(-7.05192,28.47488,2.87487),(-6.78438,28.61483,2.71573),(-6.81582,28.65236,2.77489),(-6.80287,28.64875,2.78369),(-6.77169,28.60539,2.71669),(-7.04786,28.53222,2.88027),(-6.94223,28.35145,2.75531),(-6.93178,28.35013,2.75999),(-6.92305,28.32696,2.80793),(-6.93098,28.3277,2.81014),(-6.94327,28.39697,3.06273),(-6.98696,28.41047,3.13061),(-6.99797,28.4099,3.12679),(-6.93565,28.40102,3.06862),(-6.97374,28.58828,2.67425),(-6.99515,28.60902,2.77781),(-6.99035,28.61676,2.77811),(-6.96294,28.59655,2.67798),(-6.96928,28.40306,2.72184),(-6.97286,28.39553,2.72448),(-7.09558,28.50409,2.94832),(-7.09981,28.50718,2.94867),(-7.29449,28.48044,3.29123),(-7.29459,28.48521,3.29464),(-7.20517,28.47046,3.3188),(-7.27751,28.47608,3.29507),(-7.16724,28.44564,3.254),(-7.11802,28.45158,3.28455),(-7.07594,28.42786,3.192),(-7.03852,28.46431,3.24507),(-6.9202,28.41318,2.72648),(-7.09761,28.57698,2.91372),(-7.20646,28.69156,2.95372),(-7.10945,28.65498,2.93462),(-7.09284,28.48378,2.97652),(-7.11843,28.47372,3.03529),(-7.12305,28.48947,3.01034),(-7.08966,28.46016,3.00936),(-6.95759,28.37387,2.73791),(-7.08703,28.45078,3.0767),(-7.06728,28.44478,3.04081),(-7.20122,28.58403,3.2879),(-7.20801,28.52996,3.31065),(-7.09303,28.57638,3.30885),(-6.80471,28.68788,2.89623),(-6.78112,28.60919,2.89149),(-6.79167,28.6328,2.83452),(-6.78631,28.67646,2.95169),(-6.79476,28.80378,3.0023),(-6.7792,28.79445,3.03523),(-6.78843,28.75609,2.95967),(-6.78231,28.74066,3.00133),(-6.77568,28.53625,2.88815),(-6.77956,28.4231,2.84607),(-6.75734,28.46373,2.81169),(-6.7881,28.48609,2.93091),(-7.02131,28.72472,3.14899),(-7.03546,28.75219,3.09274),(-7.10633,28.70933,3.14218),(-7.18794,28.6837,3.11886),(-7.21853,28.67173,3.12898),(-7.17395,28.65875,3.18776),(-7.01994,28.74737,2.99596),(-7.08564,28.71722,3.00426),(-6.99381,28.75737,3.03355),(-7.06147,28.73793,3.04419),(-6.96579,28.67924,2.89854),(-7.01185,28.63398,2.88134),(-6.98545,28.70466,2.92907),(-6.92398,28.59751,2.67587),(-6.93126,28.60774,2.69536),(-6.99639,28.65279,3.27296),(-6.93202,28.64307,3.28559),(-6.90343,28.70819,3.20572),(-6.96525,28.70087,3.20463),(-7.28689,28.66868,3.04256),(-7.30558,28.65403,3.02472),(-7.35946,28.6159,3.07418),(-7.32837,28.62559,3.09732),(-6.95602,28.77841,2.98668),(-6.926,28.77672,3.02305),(-6.91524,28.6571,2.80247),(-6.88983,28.62309,2.72274),(-6.83753,28.69653,2.84328),(-7.00925,28.39357,3.00632),(-6.89377,28.38742,3.00341),(-6.97363,28.35801,2.94051),(-6.86807,28.41783,2.74159),(-6.79893,28.43643,2.76705),(-6.83909,28.35235,2.86268),(-6.90623,28.34092,2.8024),(-6.75988,28.54501,2.7376),(-6.78255,28.52798,2.72807),(-6.81911,28.39611,2.95052),(-6.83337,28.35338,2.8866),(-6.82477,28.47252,3.05779),(-6.88396,28.39001,3.00458),(-6.80448,28.53381,2.98784),(-6.76407,28.44662,2.79992),(-6.82449,28.69149,2.84824),(-6.75401,28.56113,2.74863),(-6.76525,28.60047,2.7788),(-7.15556,28.69084,3.1242),(-7.23276,28.64782,3.15627),(-7.21582,28.61612,3.22664),(-7.23585,28.6283,3.19339),(-7.15527,28.64221,3.23557),(-7.18959,28.62496,3.24042),(-7.10171,28.68005,3.19819),(-7.1181,28.66132,3.22293),(-7.25334,28.56664,3.26036),(-7.27747,28.52566,3.28195),(-7.28715,28.62976,3.12033),(-7.32774,28.56833,3.19124),(-7.29362,28.59079,3.19417),(-7.0598,28.65627,3.25289),(-7.13372,28.61818,3.27794),(-6.95908,28.47739,3.20571),(-7.00404,28.50601,3.28175),(-7.09121,28.44485,3.1451),(-7.08019,28.42736,3.18311),(-7.0449,28.42946,3.07226),(-7.19774,28.50868,3.09248),(-7.17044,28.49731,3.07364),(-7.17164,28.49534,3.08912),(-7.22046,28.50216,3.13922),(-7.19132,28.49365,3.12983),(-7.23615,28.5212,3.08126),(-7.23558,28.51566,3.11422),(-7.19072,28.51534,3.05328),(-7.2149,28.52516,3.05749),(-7.17371,28.50784,3.05719),(-7.17208,28.50258,3.06541),(-6.99631,28.51326,2.8005),(-7.0125,28.62407,2.87409),(-7.01926,28.62904,2.88179),(-7.26395,28.5846,2.94319),(-7.16577,28.53781,2.931),(-6.96077,28.66574,2.88265),(-6.90784,28.70123,2.88626),(-6.95515,28.63561,2.7895),(-6.95681,28.7735,2.9741),(-7.01919,28.74223,2.98304),(-6.80761,28.80826,2.97649),(-6.79618,28.76489,2.9251),(-7.08414,28.71013,2.99182),(-7.36476,28.60763,3.06652),(-7.36107,28.56348,3.04372),(-7.30827,28.64608,3.01451),(-7.17284,28.49337,3.10461),(-7.04105,28.42765,2.94208),(-7.02515,28.41058,2.97421),(-6.8919,28.47472,3.13168),(-6.8594,28.50966,3.15642),(-6.81249,28.75336,3.10763),(-6.78685,28.79935,3.03923),(-6.89813,28.73675,3.13456),(-6.90524,28.76433,3.06592),(-6.90112,28.61944,3.2919),(-6.97654,28.75757,3.08057),(-7.25956,28.67702,3.06601),(-6.73908,28.49096,2.7816),(-6.76125,28.57985,2.84034),(-6.9925,28.39552,2.87495),(-6.98307,28.37674,2.90774),(-6.82773,28.80473,2.96402),(-6.91788,28.72828,2.91808),(-6.80908,28.76916,2.92057),(-6.81652,28.81167,2.98462),(-6.82576,28.80963,2.97468),(-7.11034,28.71938,3.02674),(-6.83878,28.70697,3.17889),(-7.16362,28.44487,3.23996),(-7.29044,28.48115,3.29763),(-7.26464,28.57873,2.94581),(-7.35604,28.55636,3.04414),(-6.97619,28.4062,2.7251),(-6.90919,28.37586,2.74573),(-7.16932,28.53233,2.93804),(-6.96597,28.58469,2.67121),(-6.92445,28.58451,2.66994),(-6.87563,28.58549,2.67041),(-6.91056,28.49156,2.69602),(-6.87153,28.4968,2.70303),(-6.87894,28.42682,2.7285),(-6.80273,28.80796,3.00802),(-7.21189,28.47975,3.32251),(-7.21089,28.69754,2.96296),(-6.74585,28.49328,2.76569),(-6.79789,28.45247,2.7545),(-6.80561,28.74619,3.10552),(-6.83202,28.69827,3.17585),(-6.895,28.60912,3.28875),(-6.87801,28.59809,2.67533),(-6.95695,28.48693,2.69319),(-6.9496,28.4864,2.68903),(-7.05215,28.4664,2.88013),(-7.01024,28.43811,2.80789),(-7.0095,28.42951,2.8129),(-7.14632,28.4974,3.03854),(-7.14336,28.48697,3.05526),(-7.00215,28.41436,2.84231),(-7.04747,28.44888,2.90934),(-7.14779,28.47889,3.11752),(-7.14047,28.47961,3.08547),(-7.11641,28.46409,3.08112),(-7.12459,28.46111,3.12879),(-7.14929,28.50784,3.02181),(-7.18412,28.52309,3.01446),(-7.2309,28.54229,3.02264),(-7.27304,28.52348,3.13591),(-7.27367,28.5345,3.07),(-7.18495,28.47948,3.16764),(-7.24311,28.4967,3.18605),(-7.24953,28.55644,2.98626),(-7.17779,28.52703,2.97439),(-7.31257,28.54419,3.05823),(-7.31169,28.52772,3.15761),(-7.26667,28.48758,3.23178),(-7.17943,28.46199,3.20357),(-6.82482,28.57848,3.06444),(-6.7928,28.57143,2.93967),(-6.80556,28.62735,3.00806),(-6.80741,28.69611,3.07321),(-6.83253,28.65189,3.14512),(-6.96469,28.7297,3.14133),(-7.0271,28.69375,3.2036),(-7.19945,28.7003,3.04639),(-7.13386,28.71473,3.05744),(-7.20561,28.70084,3.00865),(-6.89241,28.57418,3.26355),(-6.78293,28.62183,2.81169),(-7.12767,28.50526,2.98538)]))),
        Shape(DEF='rtrqtral',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rtrqtral_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,13,15,14,-1,16,17,18,-1,18,19,16,-1,20,21,22,-1,20,23,21,-1,24,25,26,-1,27,28,29,-1,27,30,28,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,44,47,-1,47,48,46,-1,49,50,51,-1,52,53,54,-1,52,55,53,-1,56,8,57,-1,58,59,60,-1,61,62,63,-1,63,64,61,-1,65,66,67,-1,68,69,2,-1,70,71,72,-1,72,73,70,-1,74,75,57,-1,76,77,78,-1,79,80,81,-1,79,82,80,-1,83,84,42,-1,85,86,87,-1,85,73,86,-1,88,89,90,-1,91,92,93,-1,93,94,91,-1,52,95,96,-1,95,97,96,-1,98,99,100,-1,101,102,103,-1,101,0,102,-1,104,55,105,-1,106,107,108,-1,106,109,107,-1,57,75,110,-1,111,112,113,-1,114,115,116,-1,115,117,116,-1,9,118,119,-1,9,120,118,-1,121,122,123,-1,1,124,2,-1,33,30,31,-1,33,28,30,-1,108,125,106,-1,76,126,127,-1,128,129,130,-1,131,132,133,-1,112,111,134,-1,135,136,137,-1,69,68,133,-1,138,139,50,-1,138,140,139,-1,141,142,143,-1,63,13,64,-1,63,15,13,-1,109,144,107,-1,109,61,144,-1,145,146,147,-1,145,148,146,-1,149,150,151,-1,152,41,40,-1,153,154,41,-1,88,83,89,-1,88,84,83,-1,6,8,155,-1,108,156,157,-1,156,5,157,-1,92,158,93,-1,91,159,160,-1,161,162,163,-1,14,146,164,-1,14,15,146,-1,165,166,167,-1,168,169,170,-1,171,99,172,-1,173,19,18,-1,173,174,19,-1,175,174,173,-1,173,176,175,-1,17,16,177,-1,178,179,180,-1,181,182,183,-1,7,154,153,-1,7,6,154,-1,74,57,184,-1,57,185,184,-1,186,187,188,-1,187,45,188,-1,19,104,16,-1,19,189,104,-1,190,191,66,-1,191,67,66,-1,192,193,12,-1,192,194,193,-1,195,196,60,-1,196,197,60,-1,48,198,199,-1,200,201,135,-1,135,202,200,-1,198,165,106,-1,106,199,198,-1,136,165,198,-1,136,166,165,-1,125,186,188,-1,46,199,188,-1,107,203,204,-1,204,156,107,-1,14,205,192,-1,192,12,14,-1,142,141,168,-1,141,206,168,-1,16,104,207,-1,207,177,16,-1,19,174,189,-1,174,208,189,-1,209,51,123,-1,210,85,211,-1,85,29,211,-1,90,212,27,-1,27,87,90,-1,39,213,36,-1,214,78,129,-1,90,94,212,-1,215,216,208,-1,208,53,189,-1,208,216,53,-1,217,218,219,-1,217,37,218,-1,63,147,146,-1,146,15,63,-1,218,220,219,-1,158,221,150,-1,8,7,222,-1,110,56,57,-1,41,154,223,-1,88,224,84,-1,88,86,224,-1,30,225,226,-1,226,31,30,-1,181,31,226,-1,95,227,194,-1,62,109,165,-1,62,61,109,-1,65,228,112,-1,172,229,169,-1,230,231,10,-1,120,124,1,-1,120,232,124,-1,233,234,117,-1,234,235,117,-1,44,236,47,-1,44,43,236,-1,109,106,165,-1,237,238,239,-1,240,113,112,-1,80,241,242,-1,80,82,241,-1,243,244,220,-1,244,219,220,-1,108,157,125,-1,31,181,32,-1,224,86,73,-1,73,72,224,-1,124,245,2,-1,2,102,0,-1,246,120,9,-1,246,232,120,-1,134,65,112,-1,134,66,65,-1,107,156,108,-1,192,95,194,-1,192,97,95,-1,104,53,55,-1,104,189,53,-1,247,0,101,-1,247,118,0,-1,140,230,139,-1,140,231,230,-1,58,110,59,-1,248,249,210,-1,249,70,210,-1,242,250,251,-1,252,80,242,-1,242,253,252,-1,42,84,224,-1,224,40,42,-1,204,75,3,-1,75,74,3,-1,71,254,255,-1,255,72,71,-1,85,70,73,-1,85,210,70,-1,204,203,75,-1,48,199,46,-1,56,110,58,-1,155,8,56,-1,53,216,54,-1,50,49,138,-1,45,44,188,-1,44,46,188,-1,115,256,257,-1,115,258,256,-1,259,161,260,-1,218,37,39,-1,261,24,26,-1,212,30,27,-1,212,225,30,-1,262,263,264,-1,105,207,104,-1,105,265,207,-1,266,267,268,-1,269,270,143,-1,146,148,142,-1,142,164,146,-1,196,13,12,-1,12,193,196,-1,271,154,6,-1,8,222,57,-1,272,273,274,-1,275,159,276,-1,275,160,159,-1,277,278,279,-1,278,277,280,-1,176,281,175,-1,176,282,281,-1,283,216,284,-1,216,283,54,-1,197,227,285,-1,227,197,194,-1,148,143,142,-1,148,269,143,-1,209,266,268,-1,209,286,266,-1,267,287,268,-1,267,288,287,-1,289,177,290,-1,289,17,177,-1,291,292,293,-1,291,294,292,-1,295,262,264,-1,295,296,262,-1,297,298,299,-1,297,300,298,-1,183,301,302,-1,303,301,183,-1,304,305,211,-1,304,306,305,-1,128,179,307,-1,128,130,179,-1,308,25,24,-1,25,308,309,-1,310,311,214,-1,310,312,311,-1,313,314,315,-1,316,314,313,-1,317,318,319,-1,317,320,318,-1,321,272,322,-1,272,321,323,-1,324,325,326,-1,325,324,273,-1,259,327,328,-1,327,259,260,-1,329,113,240,-1,329,330,113,-1,114,258,115,-1,114,331,258,-1,256,131,257,-1,256,332,131,-1,333,334,335,-1,334,333,336,-1,337,338,339,-1,340,338,337,-1,167,201,341,-1,167,166,201,-1,229,99,98,-1,172,99,229,-1,342,121,343,-1,121,342,300,-1,344,345,346,-1,347,345,344,-1,265,96,98,-1,265,105,96,-1,56,284,155,-1,56,283,284,-1,348,349,145,-1,348,228,349,-1,245,235,234,-1,350,235,245,-1,33,304,28,-1,33,351,304,-1,255,352,353,-1,255,254,352,-1,354,248,355,-1,248,354,249,-1,356,357,358,-1,356,359,357,-1,360,361,4,-1,360,362,361,-1,4,352,360,-1,4,184,352,-1,363,364,252,-1,364,363,365,-1,255,224,72,-1,40,224,255,-1,359,364,357,-1,364,359,81,-1,366,242,251,-1,253,242,366,-1,126,162,241,-1,163,162,126,-1,355,79,354,-1,178,79,355,-1,293,367,291,-1,293,280,367,-1,295,280,293,-1,295,278,280,-1,60,285,58,-1,60,197,285,-1,110,203,59,-1,110,75,203,-1,368,140,347,-1,368,231,140,-1,247,119,118,-1,369,119,247,-1,370,340,371,-1,370,336,340,-1,372,312,310,-1,372,373,312,-1,374,375,376,-1,374,377,375,-1,237,330,329,-1,237,378,330,-1,206,231,368,-1,10,231,206,-1,379,380,320,-1,381,380,379,-1,191,232,246,-1,191,350,232,-1,103,342,101,-1,103,382,342,-1,233,68,234,-1,133,68,233,-1,383,332,256,-1,384,332,383,-1,286,262,266,-1,263,262,286,-1,353,40,255,-1,353,152,40,-1,371,337,385,-1,340,337,371,-1,386,24,302,-1,386,308,24,-1,387,378,388,-1,387,330,378,-1,315,389,384,-1,315,314,389,-1,250,241,162,-1,250,242,241,-1,252,374,363,-1,374,252,253,-1,339,372,386,-1,338,372,339,-1,384,390,332,-1,389,390,384,-1,115,233,117,-1,115,257,233,-1,240,391,329,-1,202,391,240,-1,43,217,236,-1,217,43,392,-1,341,200,112,-1,201,200,341,-1,122,300,297,-1,300,122,121,-1,337,23,385,-1,337,21,23,-1,385,103,371,-1,385,382,103,-1,0,120,1,-1,0,118,120,-1,350,124,232,-1,350,245,124,-1,368,168,206,-1,368,171,168,-1,265,393,207,-1,265,394,393,-1,228,341,112,-1,228,348,341,-1,270,349,67,-1,349,270,269,-1,13,195,64,-1,196,195,13,-1,351,306,304,-1,351,395,306,-1,70,356,71,-1,70,249,356,-1,360,254,358,-1,360,352,254,-1,58,283,56,-1,283,58,285,-1,264,278,295,-1,396,278,264,-1,276,367,275,-1,276,397,367,-1,282,271,281,-1,282,398,271,-1,150,182,158,-1,182,150,149,-1,221,92,399,-1,158,92,221,-1,314,400,389,-1,401,400,314,-1,334,390,335,-1,334,132,390,-1,328,250,259,-1,328,251,250,-1,326,366,324,-1,326,377,366,-1,38,217,392,-1,38,37,217,-1,239,34,237,-1,35,34,239,-1,147,62,402,-1,63,62,147,-1,48,403,137,-1,48,47,403,-1,236,219,244,-1,236,217,219,-1,346,100,344,-1,346,394,100,-1,404,290,405,-1,404,289,290,-1,406,294,291,-1,294,406,407,-1,159,223,398,-1,83,223,159,-1,89,94,90,-1,91,94,89,-1,27,85,87,-1,85,27,29,-1,211,248,210,-1,248,211,305,-1,355,179,178,-1,355,307,179,-1,130,78,77,-1,130,129,78,-1,25,395,351,-1,395,25,309,-1,33,261,26,-1,261,33,32,-1,226,182,181,-1,226,158,182,-1,226,93,158,-1,93,226,225,-1,126,311,408,-1,126,76,311,-1,161,316,313,-1,161,163,316,-1,318,260,319,-1,327,260,318,-1,273,323,325,-1,273,272,323,-1,222,153,409,-1,222,7,153,-1,361,5,4,-1,157,5,361,-1,376,392,43,-1,392,376,375,-1,39,410,213,-1,410,39,38,-1,281,6,411,-1,281,271,6,-1,174,215,208,-1,174,175,215,-1,290,207,393,-1,207,290,177,-1,287,412,413,-1,412,287,405,-1,49,209,268,-1,51,209,49,-1,122,263,286,-1,122,297,263,-1,299,396,264,-1,396,299,20,-1,151,303,149,-1,151,22,303,-1,51,414,123,-1,51,50,414,-1,369,230,119,-1,369,139,230,-1,141,10,206,-1,141,11,10,-1,168,164,142,-1,170,164,168,-1,9,270,246,-1,9,11,270,-1,111,116,134,-1,111,114,116,-1,331,388,381,-1,387,388,331,-1,322,274,380,-1,322,272,274,-1,144,203,107,-1,144,59,203,-1,204,5,156,-1,5,204,3,-1,135,166,136,-1,135,201,166,-1,415,238,391,-1,415,243,238,-1,220,35,239,-1,220,218,35,-1,35,39,36,-1,218,39,35,-1,243,239,238,-1,239,243,220,-1,135,391,202,-1,391,135,415,-1,199,125,188,-1,199,106,125,-1,60,144,195,-1,60,59,144,-1,196,194,197,-1,196,193,194,-1,380,388,322,-1,388,380,381,-1,387,114,111,-1,331,114,387,-1,190,134,116,-1,190,66,134,-1,246,67,191,-1,270,67,246,-1,170,14,164,-1,170,205,14,-1,119,10,9,-1,230,10,119,-1,139,414,50,-1,139,369,414,-1,182,303,183,-1,182,149,303,-1,396,22,151,-1,396,20,22,-1,264,297,299,-1,297,264,263,-1,122,209,123,-1,122,286,209,-1,268,413,49,-1,413,268,287,-1,405,393,412,-1,393,405,290,-1,175,411,215,-1,411,175,281,-1,375,38,392,-1,38,375,410,-1,43,187,376,-1,187,43,45,-1,125,361,186,-1,125,157,361,-1,3,184,4,-1,184,3,74,-1,409,57,222,-1,409,185,57,-1,36,325,323,-1,213,325,36,-1,327,274,273,-1,327,318,274,-1,313,260,161,-1,260,313,319,-1,408,163,126,-1,163,408,316,-1,76,214,311,-1,76,78,214,-1,94,225,212,-1,94,93,225,-1,183,32,181,-1,32,183,261,-1,26,351,33,-1,351,26,25,-1,129,309,214,-1,129,395,309,-1,179,77,180,-1,77,179,130,-1,305,355,248,-1,355,305,307,-1,91,83,159,-1,83,91,89,-1,154,398,223,-1,271,398,154,-1,397,291,367,-1,291,397,406,-1,294,289,404,-1,294,407,289,-1,394,412,393,-1,346,412,394,-1,344,99,171,-1,344,100,99,-1,171,169,168,-1,171,172,169,-1,47,244,403,-1,47,236,244,-1,137,198,48,-1,198,137,136,-1,167,62,165,-1,62,167,402,-1,322,378,321,-1,322,388,378,-1,377,410,375,-1,326,410,377,-1,324,251,328,-1,324,366,251,-1,162,259,250,-1,161,259,162,-1,133,334,69,-1,334,133,132,-1,335,389,400,-1,335,390,389,-1,316,401,314,-1,408,401,316,-1,91,399,92,-1,91,160,399,-1,296,266,262,-1,267,266,296,-1,407,17,289,-1,407,18,17,-1,282,397,276,-1,397,282,176,-1,150,279,151,-1,221,279,150,-1,176,406,397,-1,406,176,173,-1,411,155,284,-1,155,411,6,-1,83,41,223,-1,41,83,42,-1,409,41,152,-1,409,153,41,-1,341,402,167,-1,341,348,402,-1,61,195,144,-1,195,61,64,-1,229,192,205,-1,229,97,192,-1,269,145,349,-1,269,148,145,-1,346,413,412,-1,346,345,413,-1,2,370,102,-1,370,2,69,-1,101,343,247,-1,101,342,343,-1,385,298,382,-1,385,23,298,-1,302,339,386,-1,302,301,339,-1,243,403,244,-1,243,415,403,-1,200,240,112,-1,200,202,240,-1,69,336,370,-1,69,334,336,-1,256,379,383,-1,256,258,379,-1,373,335,400,-1,373,333,335,-1,310,386,372,-1,310,308,386,-1,81,354,79,-1,81,359,354,-1,377,253,366,-1,377,374,253,-1,373,401,312,-1,400,401,373,-1,320,383,379,-1,320,317,383,-1,357,365,362,-1,365,357,364,-1,185,152,353,-1,185,409,152,-1,317,384,383,-1,384,317,315,-1,257,133,233,-1,133,257,131,-1,300,382,298,-1,382,300,342,-1,414,247,343,-1,369,247,414,-1,116,235,190,-1,116,117,235,-1,258,381,379,-1,381,258,331,-1,11,143,270,-1,11,141,143,-1,345,49,413,-1,49,345,138,-1,321,237,34,-1,321,378,237,-1,363,376,187,-1,376,363,374,-1,372,333,373,-1,372,338,333,-1,102,371,103,-1,102,370,371,-1,171,347,344,-1,171,368,347,-1,98,97,229,-1,96,97,98,-1,227,52,54,-1,227,95,52,-1,296,288,267,-1,296,292,288,-1,399,279,221,-1,277,279,399,-1,277,160,275,-1,277,399,160,-1,292,404,288,-1,404,292,294,-1,86,90,87,-1,86,88,90,-1,127,241,82,-1,126,241,127,-1,358,71,356,-1,358,254,71,-1,187,365,363,-1,365,187,186,-1,252,81,80,-1,81,252,364,-1,82,180,127,-1,79,180,82,-1,178,180,79,-1,362,186,361,-1,186,362,365,-1,358,362,360,-1,358,357,362,-1,359,249,354,-1,249,359,356,-1,128,395,129,-1,395,128,306,-1,353,184,185,-1,353,352,184,-1,2,234,68,-1,245,234,2,-1,350,190,235,-1,191,190,350,-1,67,228,65,-1,349,228,67,-1,145,402,348,-1,147,402,145,-1,105,52,96,-1,105,55,52,-1,98,394,265,-1,100,394,98,-1,347,138,345,-1,140,138,347,-1,343,123,414,-1,123,343,121,-1,205,169,229,-1,170,169,205,-1,415,137,403,-1,137,415,135,-1,301,337,339,-1,337,301,21,-1,333,340,336,-1,333,338,340,-1,132,332,390,-1,131,332,132,-1,113,387,111,-1,113,330,387,-1,329,238,237,-1,329,391,238,-1,328,273,324,-1,273,328,327,-1,213,326,325,-1,213,410,326,-1,323,34,36,-1,323,321,34,-1,320,274,318,-1,320,380,274,-1,319,315,317,-1,313,315,319,-1,312,408,311,-1,312,401,408,-1,214,308,310,-1,309,308,214,-1,180,76,127,-1,180,77,76,-1,307,306,128,-1,305,306,307,-1,28,211,29,-1,28,304,211,-1,261,302,24,-1,183,302,261,-1,303,21,301,-1,22,21,303,-1,23,299,298,-1,299,23,20,-1,293,296,295,-1,293,292,296,-1,173,407,406,-1,173,18,407,-1,288,405,287,-1,288,404,405,-1,285,54,283,-1,54,285,227,-1,284,215,411,-1,215,284,216,-1,275,280,277,-1,280,275,367,-1,279,396,151,-1,396,279,278,-1,398,276,159,-1,398,282,276,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rtrqtral_Coord',point=[(-7.67398,28.72307,1.94663),(-7.69076,28.75071,1.9861),(-7.67015,28.79865,1.99456),(-7.38052,28.84427,2.27096),(-7.37628,28.8536,2.26915),(-7.38396,28.85204,2.27693),(-7.34835,28.69881,2.08169),(-7.35537,28.74878,2.12994),(-7.38224,28.72792,2.13528),(-7.71777,28.66428,1.97872),(-7.71348,28.65446,1.97576),(-7.71576,28.6636,1.99036),(-7.5419,28.6765,2.13913),(-7.53554,28.69313,2.15496),(-7.61066,28.67283,2.11856),(-7.6131,28.70617,2.12553),(-7.49085,28.59531,2.00459),(-7.48609,28.59825,1.99182),(-7.47703,28.6211,1.98222),(-7.47119,28.61266,2.01168),(-7.49844,28.7779,1.85327),(-7.46282,28.86597,1.90068),(-7.43531,28.84667,1.87573),(-7.52093,28.79145,1.87923),(-7.39867,28.9678,1.96801),(-7.38758,28.98259,1.98617),(-7.37992,28.96713,1.9669),(-7.33444,28.88179,2.03207),(-7.3636,28.93909,2.01916),(-7.35386,28.91219,2.06726),(-7.34594,28.89191,2.00058),(-7.3604,28.90479,1.96353),(-7.37784,28.93455,1.94297),(-7.37187,28.96242,1.97016),(-7.54792,29.03932,2.4024),(-7.53768,29.01432,2.44109),(-7.51241,29.05958,2.40469),(-7.50228,29.01848,2.43126),(-7.47131,29.02267,2.41101),(-7.50855,29.05671,2.40781),(-7.38416,28.82357,2.07506),(-7.35916,28.77991,2.08001),(-7.37571,28.80388,2.03382),(-7.4436,28.98198,2.38876),(-7.45211,28.94403,2.37156),(-7.43492,28.94567,2.36347),(-7.46795,28.90409,2.33494),(-7.53155,28.93105,2.37989),(-7.56252,28.89118,2.31359),(-7.60015,28.60683,1.87416),(-7.66226,28.63453,1.86324),(-7.63376,28.64324,1.83851),(-7.49938,28.64517,2.08272),(-7.47064,28.63551,2.05736),(-7.46648,28.66671,2.09049),(-7.48587,28.62316,2.05608),(-7.40709,28.69929,2.15344),(-7.37096,28.77123,2.2144),(-7.44561,28.69195,2.18196),(-7.43634,28.75323,2.24981),(-7.48704,28.69017,2.19726),(-7.51837,28.77908,2.20716),(-7.61194,28.79851,2.17639),(-7.61514,28.74583,2.13477),(-7.5287,28.71353,2.17476),(-7.72491,28.83441,2.139),(-7.72611,28.84057,2.11975),(-7.72539,28.78446,2.08209),(-7.67707,28.86428,2.03026),(-7.64178,28.87838,2.0162),(-7.37523,28.91309,2.10905),(-7.38588,28.89043,2.12915),(-7.3853,28.85833,2.09341),(-7.37061,28.88306,2.08331),(-7.37453,28.81159,2.24671),(-7.38412,28.81564,2.25358),(-7.4457,29.05662,2.08065),(-7.40899,29.02702,2.0715),(-7.40974,29.02513,2.04622),(-7.41219,29.00298,2.14574),(-7.4581,29.02037,2.19935),(-7.42517,28.97848,2.18392),(-7.45403,29.04146,2.15511),(-7.37082,28.78351,1.98695),(-7.36397,28.81724,2.02048),(-7.35583,28.90451,2.07472),(-7.35488,28.85679,2.04733),(-7.33577,28.8747,2.03911),(-7.33204,28.83189,2.01596),(-7.35103,28.81377,1.9895),(-7.32043,28.84614,2.01008),(-7.35415,28.81155,1.98014),(-7.34856,28.82686,1.97072),(-7.32881,28.84245,1.97965),(-7.32379,28.84343,1.99791),(-7.50481,28.65844,2.12048),(-7.51144,28.63554,2.08125),(-7.52602,28.65419,2.10945),(-7.56288,28.61532,2.0563),(-7.6023,28.62404,2.04914),(-7.58844,28.61596,2.02915),(-7.6557,28.70038,1.90756),(-7.64946,28.76625,1.95721),(-7.62794,28.73708,1.91998),(-7.48996,28.59577,2.02006),(-7.49158,28.61818,2.0559),(-7.48065,28.86993,2.28676),(-7.42899,28.81929,2.2714),(-7.41513,28.87175,2.28876),(-7.50257,28.83031,2.2446),(-7.40236,28.76555,2.23526),(-7.69803,28.98167,2.21185),(-7.71353,28.87432,2.20085),(-7.68513,28.97601,2.25664),(-7.6997,28.98462,2.19643),(-7.70204,28.98376,2.17438),(-7.72136,28.89512,2.15203),(-7.71627,28.89654,2.12494),(-7.69421,28.68107,1.93889),(-7.70756,28.64781,1.93447),(-7.70709,28.70307,1.98011),(-7.61751,28.67308,1.83916),(-7.60364,28.67751,1.83223),(-7.63178,28.65371,1.83522),(-7.69532,28.77183,2.00413),(-7.42284,28.90748,2.32959),(-7.49006,29.09302,2.1225),(-7.44914,29.0621,2.11234),(-7.39808,29.00764,2.07065),(-7.40388,29.01648,2.03917),(-7.40232,29.01814,2.07084),(-7.6781,28.9807,2.11845),(-7.64623,28.96956,2.08552),(-7.681,28.90634,2.06163),(-7.72177,28.8898,2.16374),(-7.63702,28.886,2.353),(-7.62413,28.86247,2.28139),(-7.60379,28.88726,2.33265),(-7.63196,28.60989,1.90352),(-7.68799,28.63274,1.89885),(-7.6686,28.6224,1.93498),(-7.69964,28.66355,2.02824),(-7.67659,28.66279,2.07168),(-7.70376,28.69189,2.05127),(-7.44431,28.75805,2.25074),(-7.68657,28.74757,2.13081),(-7.64774,28.70437,2.11171),(-7.6524,28.74618,2.13082),(-7.6802,28.70316,2.10073),(-7.40614,28.87254,1.89483),(-7.38982,28.84478,1.91248),(-7.42712,28.84249,1.87759),(-7.37359,28.79306,2.11903),(-7.35197,28.75602,2.12237),(-7.34425,28.70501,2.07965),(-7.37956,28.70217,2.10867),(-7.40169,28.84775,2.2737),(-7.40365,28.87986,2.30079),(-7.353,28.84277,1.95018),(-7.37468,28.78005,1.97755),(-7.37895,28.79772,1.96556),(-7.54291,29.12555,2.17628),(-7.52123,29.10516,2.16962),(-7.51966,29.11121,2.15161),(-7.64437,28.66793,2.09531),(-7.60451,28.83929,2.22378),(-7.63694,28.8572,2.27263),(-7.64774,28.83771,2.22032),(-7.66601,28.65436,2.0706),(-7.62956,28.6477,2.08071),(-7.63915,28.65857,2.09015),(-7.64415,28.63491,2.03679),(-7.61428,28.63817,2.0635),(-7.46148,28.65587,1.97092),(-7.44146,28.64008,2.01987),(-7.41889,28.66213,2.02052),(-7.42412,28.70943,1.97184),(-7.49375,28.58225,1.99654),(-7.40376,29.0219,2.11134),(-7.4006,29.01944,2.09916),(-7.40695,29.02863,2.10634),(-7.38511,28.9069,1.91615),(-7.38884,28.89751,1.91017),(-7.39253,28.91063,1.91392),(-7.37016,28.81674,2.24008),(-7.36872,28.77851,2.20841),(-7.41953,28.9145,2.3283),(-7.43096,28.94997,2.3566),(-7.42646,28.91561,2.33785),(-7.47421,28.61209,2.02121),(-7.7248,28.84808,2.10915),(-7.72603,28.79089,2.07264),(-7.5417,28.66953,2.13088),(-7.51134,28.67142,2.15124),(-7.50576,28.66598,2.14362),(-7.49595,28.69379,2.19669),(-7.50525,28.68348,2.17739),(-7.49653,28.68073,2.17657),(-7.6013,28.84509,2.23072),(-7.48578,28.877,2.29568),(-7.64873,28.88295,2.34414),(-7.64993,28.87927,2.33842),(-7.64651,28.88768,2.34882),(-7.42241,28.81276,2.26861),(-7.39729,28.83989,2.26886),(-7.60666,28.6634,2.11408),(-7.69325,28.65429,2.02307),(-7.49992,28.57856,2.00328),(-7.44278,28.63847,2.03138),(-7.62368,28.64956,1.83435),(-7.36658,28.93136,2.09275),(-7.36561,28.93827,2.08335),(-7.32062,28.85262,2.00346),(-7.50654,29.06208,2.39561),(-7.41201,29.01912,2.0333),(-7.42156,28.65837,2.03119),(-7.44046,28.66765,2.05362),(-7.50388,28.99513,2.43697),(-7.52913,29.01033,2.44548),(-7.53645,28.99023,2.44908),(-7.55044,28.98458,2.45072),(-7.3759,28.82679,1.9392),(-7.36304,28.75908,2.17191),(-7.35609,28.75235,2.02354),(-7.37915,28.83745,2.05402),(-7.32734,28.85211,1.98247),(-7.34843,28.85038,1.95698),(-7.48742,28.66831,2.12611),(-7.7172,28.82474,2.15172),(-7.58429,28.64024,2.09064),(-7.70513,28.63957,1.936),(-7.69434,28.63817,1.95543),(-7.71224,28.7449,2.01809),(-7.70261,28.90282,2.08658),(-7.70087,28.85407,2.04923),(-7.71764,28.84988,2.08159),(-7.51004,28.97108,2.43336),(-7.60075,29.01554,2.38242),(-7.58715,28.96296,2.44008),(-7.55961,28.98879,2.44668),(-7.66582,28.93713,2.31091),(-7.49535,29.07918,2.16569),(-7.4912,29.05947,2.21732),(-7.57794,28.95916,2.44378),(-7.54436,28.96615,2.44324),(-7.69719,28.79541,2.01807),(-7.71928,28.72324,2.03259),(-7.67952,28.66512,1.89811),(-7.37807,28.95931,2.11147),(-7.38102,28.94268,2.13339),(-7.51381,29.08564,2.21389),(-7.50967,29.08077,2.22739),(-7.45651,28.99876,2.25187),(-7.47952,29.03923,2.27996),(-7.38695,28.86806,2.15069),(-7.39103,28.83852,2.10361),(-7.67469,29.03471,2.16907),(-7.69288,28.98205,2.14062),(-7.67319,29.03134,2.1985),(-7.53755,29.11164,2.20905),(-7.55446,29.12989,2.20552),(-7.3873,28.93799,1.93883),(-7.5573,28.6839,1.84785),(-7.56728,28.69758,1.83354),(-7.53265,28.72871,1.8417),(-7.53128,28.59543,2.02522),(-7.57568,28.64229,1.86024),(-7.56648,28.63066,1.88086),(-7.58857,28.61053,1.87287),(-7.70591,28.71399,2.06528),(-7.7179,28.71504,2.04052),(-7.35039,28.7018,2.06839),(-7.55783,29.11556,2.29282),(-7.55222,29.1189,2.28361),(-7.56177,29.1213,2.27555),(-7.40577,28.78254,1.94972),(-7.40191,28.76305,1.96257),(-7.3996,28.79734,1.94158),(-7.46452,28.75488,1.90231),(-7.40329,28.80876,1.92567),(-7.45586,28.74945,1.91792),(-7.38022,28.68912,2.04203),(-7.38715,28.73537,1.99297),(-7.43968,28.68513,2.1166),(-7.41352,28.68745,2.07465),(-7.46768,28.68106,2.15183),(-7.59863,28.67077,1.83157),(-7.5643,28.59776,1.90412),(-7.54723,28.61896,1.90648),(-7.50875,28.60599,1.95764),(-7.51792,28.58701,1.96302),(-7.49036,28.6829,1.92068),(-7.52636,28.64838,1.90739),(-7.49749,28.69164,1.90877),(-7.514,28.63959,1.9238),(-7.50583,28.70174,1.89428),(-7.53986,28.65943,1.88802),(-7.57252,28.70343,1.83422),(-7.57171,28.72177,1.858),(-7.53396,28.73774,1.84272),(-7.59646,28.6973,1.84727),(-7.43475,28.90243,1.91926),(-7.40657,28.93755,1.93856),(-7.4152,28.87718,1.89351),(-7.37347,28.96036,2.0377),(-7.37709,28.96394,2.09991),(-7.38314,28.98132,2.05667),(-7.38966,28.99345,2.09901),(-7.40659,28.98402,1.98868),(-7.39537,28.99841,2.00655),(-7.4348,29.00938,2.02048),(-7.45636,29.05766,2.07466),(-7.4798,29.04443,2.06151),(-7.55234,29.12779,2.17261),(-7.5565,29.09176,2.13492),(-7.59225,29.10638,2.16847),(-7.52616,29.11147,2.14532),(-7.60366,29.10984,2.1989),(-7.56344,29.1275,2.24247),(-7.56335,29.13113,2.20376),(-7.6005,29.10451,2.23451),(-7.56982,29.06812,2.34271),(-7.59286,29.09309,2.2856),(-7.53594,29.08984,2.34563),(-7.51396,29.08103,2.28836),(-7.52801,29.09026,2.34154),(-7.48795,29.053,2.35067),(-7.55456,29.12653,2.24238),(-7.52957,29.10202,2.23557),(-7.63014,28.97654,2.35084),(-7.65065,29.00988,2.29234),(-7.67044,29.02822,2.22517),(-7.66058,29.03219,2.14438),(-7.53726,28.98166,2.02523),(-7.60723,28.95594,2.04799),(-7.57976,29.00745,2.06827),(-7.56606,28.93396,2.00551),(-7.49276,28.88779,1.93124),(-7.49313,28.95457,1.98509),(-7.45841,28.92846,1.94941),(-7.523,28.91073,1.96623),(-7.68445,28.8413,2.23013),(-7.62512,28.69528,1.87108),(-7.64505,28.66805,1.86308),(-7.61488,28.61568,2.00072),(-7.60693,28.60139,1.93518),(-7.5814,28.59685,1.96489),(-7.64239,28.61718,1.96857),(-7.68977,28.80713,2.18472),(-7.71124,28.77101,2.10415),(-7.71642,28.79203,2.04579),(-7.37988,28.98048,1.99239),(-7.37834,28.83973,2.19898),(-7.38228,28.80952,2.15317),(-7.39672,28.973,2.13931),(-7.39168,28.9925,2.11117),(-7.39027,28.92334,2.15961),(-7.41,28.93117,2.20932),(-7.38956,28.90427,2.19033),(-7.40777,28.95076,2.17125),(-7.38252,28.87692,2.23262),(-7.39877,28.8849,2.29759),(-7.40376,28.90519,2.25823),(-7.44077,28.9733,2.31112),(-7.43021,28.95773,2.22885),(-7.42436,28.93505,2.28116),(-7.49562,29.06015,2.2857),(-7.44874,28.74538,1.93045),(-7.67068,28.6351,1.9971),(-7.68979,28.64117,1.89627),(-7.60984,28.85164,1.98006),(-7.57731,28.8255,1.94463),(-7.46336,28.9969,2.00451),(-7.50869,29.02788,2.04533),(-7.45564,29.01318,2.33979),(-7.45313,29.00829,2.39392),(-7.4406,28.98868,2.38108),(-7.47053,29.03309,2.347),(-7.61908,29.04324,2.32439),(-7.64622,29.07806,2.22055),(-7.5974,29.09862,2.26738),(-7.64316,29.07255,2.25087),(-7.60458,28.71694,1.88079),(-7.64455,29.08244,2.18493),(-7.63127,29.0787,2.1575),(-7.55242,28.80133,1.90847),(-7.42408,28.96733,1.96833),(-7.66674,29.0247,2.24248),(-7.63895,29.06728,2.26875),(-7.59219,29.06829,2.12267),(-7.61884,29.01952,2.10429),(-7.61451,28.92502,2.39665),(-7.45601,29.00334,2.40422),(-7.52521,28.58316,1.96762),(-7.55648,28.59683,1.99462),(-7.3876,28.99665,2.01332),(-7.49219,28.77365,1.85421),(-7.43845,28.73112,1.94594),(-7.36102,28.74664,2.01348),(-7.37438,28.81235,1.9556),(-7.5528,29.05755,2.08856),(-7.52383,29.07814,2.10462),(-7.65331,28.80282,2.17712),(-7.57013,28.92673,2.39323),(-7.52962,28.6107,1.92777),(-7.54178,28.58971,1.93035),(-7.4779,28.67169,1.94138),(-7.49695,28.63208,1.94981),(-7.49999,29.09499,2.11779),(-7.3608,28.76711,2.16539),(-7.46827,29.02744,2.39971),(-7.3822,28.68558,2.05324),(-7.54938,28.58558,1.93442),(-7.57316,28.59363,1.90675),(-7.66437,28.64327,1.86275),(-7.6056,28.923,2.40084)]))),
        Shape(DEF='rmc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,1),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,20,21,18,-1,22,23,24,-1,22,25,23,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,20,33,34,-1,35,20,32,-1,36,37,38,-1,37,36,39,-1,40,41,5,-1,42,0,43,-1,42,44,0,-1,45,20,34,-1,46,47,48,-1,49,50,51,-1,49,52,50,-1,53,54,48,-1,55,56,57,-1,58,59,60,-1,59,61,60,-1,61,62,57,-1,63,64,65,-1,66,67,68,-1,69,70,54,-1,54,71,69,-1,54,53,72,-1,72,71,54,-1,73,74,75,-1,74,76,75,-1,77,78,79,-1,79,45,77,-1,69,58,70,-1,58,60,70,-1,80,81,82,-1,80,83,81,-1,84,85,86,-1,87,88,89,-1,89,90,87,-1,86,85,91,-1,85,92,91,-1,93,94,95,-1,84,96,85,-1,97,41,98,-1,13,12,99,-1,99,12,100,-1,101,99,102,-1,12,14,103,-1,104,105,48,-1,106,107,108,-1,93,109,110,-1,111,112,113,-1,111,105,112,-1,114,115,116,-1,117,118,119,-1,119,120,117,-1,121,69,71,-1,34,33,122,-1,33,123,122,-1,57,60,61,-1,124,102,125,-1,102,126,125,-1,101,102,127,-1,128,129,130,-1,128,131,129,-1,33,35,132,-1,32,19,133,-1,31,134,135,-1,31,30,134,-1,136,51,22,-1,119,118,127,-1,118,137,127,-1,138,74,73,-1,57,139,140,-1,48,47,53,-1,27,141,28,-1,111,113,142,-1,48,143,46,-1,108,144,104,-1,109,67,66,-1,145,79,146,-1,146,147,145,-1,140,63,65,-1,148,48,54,-1,106,149,150,-1,106,151,152,-1,106,153,154,-1,106,108,155,-1,106,156,157,-1,106,150,158,-1,159,160,161,-1,159,162,160,-1,163,164,165,-1,163,166,164,-1,167,166,10,-1,89,11,10,-1,10,90,89,-1,168,169,167,-1,170,171,172,-1,173,36,174,-1,175,176,165,-1,176,163,165,-1,176,174,36,-1,173,174,177,-1,177,178,173,-1,39,173,179,-1,177,180,178,-1,181,180,177,-1,182,180,183,-1,182,184,180,-1,185,3,186,-1,187,3,188,-1,189,96,84,-1,41,40,96,-1,171,4,187,-1,6,40,7,-1,190,191,92,-1,92,192,190,-1,4,7,5,-1,193,87,194,-1,82,81,195,-1,195,44,82,-1,196,197,198,-1,198,199,196,-1,82,200,80,-1,82,201,200,-1,202,43,0,-1,202,42,43,-1,0,203,202,-1,204,202,205,-1,204,201,42,-1,204,206,200,-1,204,196,207,-1,204,208,197,-1,205,209,204,-1,210,209,190,-1,210,208,209,-1,204,209,208,-1,204,197,196,-1,204,207,206,-1,204,200,201,-1,204,42,202,-1,202,203,191,-1,191,205,202,-1,44,201,82,-1,44,42,201,-1,80,206,193,-1,80,200,206,-1,207,196,199,-1,199,211,207,-1,0,91,203,-1,0,2,91,-1,212,80,193,-1,193,194,212,-1,213,190,192,-1,3,187,4,-1,98,96,214,-1,96,189,214,-1,215,85,40,-1,85,96,40,-1,3,185,188,-1,216,98,217,-1,98,214,217,-1,177,218,181,-1,39,36,173,-1,179,173,178,-1,174,176,177,-1,171,187,172,-1,187,219,172,-1,170,172,220,-1,172,221,220,-1,10,9,167,-1,10,166,163,-1,222,216,120,-1,222,223,216,-1,106,158,156,-1,106,157,107,-1,106,155,153,-1,106,154,151,-1,152,149,106,-1,155,48,148,-1,148,153,155,-1,148,56,224,-1,148,54,56,-1,154,65,151,-1,154,224,65,-1,55,57,140,-1,65,64,225,-1,150,146,226,-1,143,111,115,-1,115,114,75,-1,121,71,27,-1,71,72,27,-1,121,25,58,-1,58,25,22,-1,62,139,57,-1,227,59,22,-1,26,118,228,-1,26,137,118,-1,73,229,138,-1,230,139,62,-1,231,139,230,-1,232,50,233,-1,50,18,233,-1,234,30,32,-1,19,32,20,-1,229,235,236,-1,127,124,119,-1,127,102,124,-1,125,126,237,-1,126,238,237,-1,77,45,34,-1,34,122,77,-1,239,240,241,-1,240,242,241,-1,243,228,117,-1,228,118,117,-1,57,70,60,-1,76,46,143,-1,143,115,76,-1,66,113,112,-1,244,245,130,-1,130,129,244,-1,103,246,12,-1,247,13,248,-1,12,246,249,-1,249,100,12,-1,41,96,98,-1,45,250,21,-1,103,251,16,-1,103,14,251,-1,252,15,253,-1,252,254,15,-1,15,249,246,-1,15,255,249,-1,6,213,192,-1,192,215,6,-1,256,86,2,-1,86,91,2,-1,89,88,257,-1,257,258,89,-1,40,6,215,-1,210,259,260,-1,212,83,80,-1,232,231,50,-1,232,63,231,-1,77,261,78,-1,261,262,78,-1,95,94,252,-1,252,253,95,-1,250,145,64,-1,64,233,250,-1,235,229,73,-1,46,74,141,-1,46,76,74,-1,59,58,22,-1,133,234,32,-1,121,58,69,-1,55,140,65,-1,54,70,56,-1,70,57,56,-1,18,50,52,-1,136,49,51,-1,27,263,141,-1,115,75,76,-1,126,255,238,-1,264,265,266,-1,266,267,264,-1,182,265,264,-1,41,97,186,-1,36,90,10,-1,268,269,38,-1,38,37,268,-1,22,51,227,-1,268,184,270,-1,268,179,184,-1,35,33,20,-1,29,121,27,-1,20,45,21,-1,136,30,234,-1,234,49,136,-1,18,52,19,-1,52,133,19,-1,29,25,121,-1,29,23,25,-1,27,72,263,-1,40,5,7,-1,265,256,266,-1,271,272,273,-1,272,271,274,-1,133,49,234,-1,52,49,133,-1,136,24,30,-1,22,24,136,-1,16,245,17,-1,16,251,245,-1,26,138,137,-1,138,26,28,-1,236,248,101,-1,248,236,128,-1,194,90,36,-1,194,87,90,-1,97,185,186,-1,97,223,185,-1,222,125,275,-1,222,124,125,-1,195,266,1,-1,195,267,266,-1,255,254,238,-1,255,15,254,-1,75,235,73,-1,235,75,114,-1,114,131,235,-1,131,114,116,-1,244,142,68,-1,142,244,129,-1,64,232,233,-1,232,64,63,-1,94,261,252,-1,261,94,262,-1,51,62,227,-1,51,230,62,-1,276,68,67,-1,276,244,68,-1,79,250,45,-1,79,145,250,-1,277,268,270,-1,269,268,277,-1,81,267,195,-1,277,267,81,-1,278,257,279,-1,278,258,257,-1,280,259,8,-1,260,259,280,-1,215,92,85,-1,215,192,92,-1,212,269,83,-1,212,38,269,-1,15,103,16,-1,246,103,15,-1,247,14,13,-1,14,247,251,-1,281,7,4,-1,7,281,282,-1,100,255,126,-1,100,249,255,-1,113,68,142,-1,66,68,113,-1,112,283,66,-1,283,112,144,-1,141,138,28,-1,74,138,141,-1,237,275,125,-1,284,275,237,-1,228,285,286,-1,228,243,285,-1,287,134,288,-1,134,287,289,-1,242,290,241,-1,242,135,290,-1,239,291,240,-1,239,160,291,-1,77,292,261,-1,122,292,77,-1,291,293,123,-1,291,294,293,-1,294,284,237,-1,294,162,284,-1,292,238,254,-1,292,293,238,-1,17,253,15,-1,17,276,253,-1,242,33,132,-1,242,240,33,-1,18,250,233,-1,18,21,250,-1,63,139,231,-1,139,63,140,-1,295,286,23,-1,295,228,286,-1,295,26,228,-1,286,24,23,-1,286,288,24,-1,142,115,111,-1,142,116,115,-1,95,109,93,-1,95,67,109,-1,262,226,78,-1,226,262,296,-1,156,296,93,-1,158,296,156,-1,78,146,79,-1,226,146,78,-1,149,146,150,-1,149,147,146,-1,152,65,225,-1,152,151,65,-1,56,65,224,-1,65,56,55,-1,154,148,224,-1,154,153,148,-1,289,218,175,-1,287,218,289,-1,181,243,297,-1,243,181,285,-1,164,239,241,-1,298,239,164,-1,185,284,188,-1,185,275,284,-1,217,120,216,-1,217,117,120,-1,161,299,300,-1,299,161,298,-1,159,300,219,-1,300,159,161,-1,300,169,221,-1,299,169,300,-1,258,11,89,-1,258,272,11,-1,273,258,278,-1,272,258,273,-1,170,271,281,-1,170,220,271,-1,37,179,268,-1,179,37,39,-1,270,267,277,-1,267,270,264,-1,189,265,182,-1,189,84,265,-1,217,183,297,-1,217,214,183,-1,278,282,273,-1,282,278,280,-1,198,260,279,-1,198,210,260,-1,211,257,88,-1,211,199,257,-1,206,211,193,-1,206,207,211,-1,198,208,210,-1,198,197,208,-1,205,190,209,-1,205,191,190,-1,199,279,257,-1,199,198,279,-1,190,259,210,-1,259,190,213,-1,171,281,4,-1,171,170,281,-1,91,191,203,-1,92,191,91,-1,41,3,5,-1,41,186,3,-1,182,214,189,-1,183,214,182,-1,84,256,265,-1,84,86,256,-1,264,184,182,-1,264,270,184,-1,297,180,181,-1,183,180,297,-1,184,178,180,-1,178,184,179,-1,175,177,176,-1,177,175,218,-1,36,163,176,-1,36,10,163,-1,220,274,271,-1,220,168,274,-1,9,168,167,-1,274,168,9,-1,221,168,220,-1,221,169,168,-1,167,299,166,-1,167,169,299,-1,221,219,300,-1,221,172,219,-1,187,159,219,-1,187,188,159,-1,166,298,164,-1,166,299,298,-1,117,297,243,-1,117,217,297,-1,188,162,159,-1,188,284,162,-1,298,160,239,-1,161,160,298,-1,241,165,164,-1,241,290,165,-1,287,181,218,-1,285,181,287,-1,290,175,165,-1,175,290,289,-1,152,147,149,-1,152,225,147,-1,145,225,64,-1,147,225,145,-1,158,226,296,-1,150,226,158,-1,93,157,156,-1,93,110,157,-1,93,262,94,-1,296,262,93,-1,283,157,110,-1,283,107,157,-1,105,144,112,-1,144,105,104,-1,30,288,134,-1,30,24,288,-1,135,132,31,-1,132,135,242,-1,17,244,276,-1,245,244,17,-1,248,99,101,-1,13,99,248,-1,254,261,292,-1,254,252,261,-1,293,237,238,-1,293,294,237,-1,160,294,291,-1,162,294,160,-1,292,123,293,-1,123,292,122,-1,123,240,291,-1,33,240,123,-1,289,135,134,-1,135,289,290,-1,285,288,286,-1,288,285,287,-1,120,124,222,-1,120,119,124,-1,295,29,26,-1,29,295,23,-1,235,128,236,-1,235,131,128,-1,283,109,66,-1,109,283,110,-1,144,107,283,-1,107,144,108,-1,105,143,48,-1,105,111,143,-1,48,108,104,-1,108,48,155,-1,100,102,99,-1,126,102,100,-1,98,223,97,-1,223,98,216,-1,211,87,193,-1,87,211,88,-1,213,8,259,-1,6,8,213,-1,279,280,278,-1,280,279,260,-1,38,194,36,-1,194,38,212,-1,277,83,269,-1,83,277,81,-1,263,46,141,-1,46,263,47,-1,62,59,227,-1,62,61,59,-1,95,276,67,-1,253,276,95,-1,129,116,142,-1,129,131,116,-1,72,47,263,-1,53,47,72,-1,50,230,51,-1,230,50,231,-1,0,195,1,-1,44,195,0,-1,223,275,185,-1,223,222,275,-1,31,35,32,-1,31,132,35,-1,130,251,247,-1,245,251,130,-1,229,101,127,-1,229,236,101,-1,247,128,130,-1,247,248,128,-1,137,229,127,-1,137,138,229,-1,281,273,282,-1,281,271,273,-1,274,11,272,-1,11,274,9,-1,282,8,7,-1,282,280,8,-1,1,256,2,-1,1,266,256,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmc_Coord',point=[(-6.54687,28.47107,2.84966),(-6.59919,28.42568,2.78068),(-6.61909,28.41321,2.79405),(-6.50634,28.27882,3.3051),(-6.62083,28.46529,3.26101),(-6.59076,28.3279,3.2116),(-6.65992,28.45042,3.15744),(-6.62188,28.46776,3.25541),(-6.63895,28.50794,3.16451),(-6.27973,28.66874,3.21707),(-6.18921,28.58509,3.21749),(-6.27933,28.67006,3.2096),(-6.11558,27.24563,3.6281),(-6.1307,27.27608,3.56279),(-6.09872,27.22442,3.58852),(-6.08563,27.26772,3.71957),(-6.07513,27.21244,3.63141),(-6.06219,27.20361,3.63014),(-5.60521,27.41511,3.60319),(-5.60983,27.42027,3.60324),(-5.63506,27.44016,3.67669),(-5.63078,27.43254,3.68061),(-5.74099,27.51129,3.40782),(-5.81585,27.41911,3.38295),(-5.74672,27.51566,3.40746),(-5.80961,27.417,3.38131),(-5.91645,27.38356,3.38874),(-5.83159,27.31342,3.37263),(-5.92008,27.37429,3.39095),(-5.82849,27.32298,3.37397),(-5.67682,27.57358,3.47763),(-5.66291,27.64005,3.57973),(-5.63421,27.57865,3.59858),(-5.78603,27.61768,3.70286),(-5.72349,27.46446,3.73917),(-5.65689,27.59764,3.64779),(-6.20228,28.53929,3.12533),(-6.22228,28.51303,2.96476),(-6.2403,28.53183,2.93464),(-6.21401,28.49141,2.98796),(-6.62974,28.34854,3.14242),(-6.54955,28.26449,3.16993),(-6.50706,28.50614,2.90986),(-6.54583,28.4724,2.85175),(-6.51083,28.48674,2.83489),(-5.68271,27.39886,3.78324),(-5.96096,27.28957,3.31569),(-5.85013,27.24067,3.32062),(-5.84634,27.16158,3.375),(-5.6194,27.52524,3.52376),(-5.54875,27.39062,3.48328),(-5.58168,27.45768,3.44094),(-5.61343,27.49567,3.54751),(-5.81119,27.22194,3.33105),(-5.77327,27.2312,3.34567),(-5.60787,27.25541,3.37018),(-5.66568,27.23693,3.33654),(-5.60579,27.29099,3.33463),(-5.70053,27.32043,3.30678),(-5.66422,27.38294,3.30691),(-5.68455,27.30938,3.30542),(-5.65038,27.36582,3.30987),(-5.6103,27.42788,3.35973),(-5.53,27.30555,3.49077),(-5.54502,27.31946,3.5773),(-5.62666,27.24122,3.4731),(-6.01425,27.10754,3.54848),(-6.04037,27.13744,3.63189),(-6.06029,27.14632,3.55586),(-5.73969,27.27376,3.32314),(-5.71787,27.26825,3.31614),(-5.77761,27.2403,3.34772),(-5.80449,27.23544,3.33465),(-6.09574,27.32387,3.35196),(-6.04237,27.31725,3.32175),(-6.09211,27.301,3.35064),(-6.04465,27.29881,3.32701),(-5.80241,27.36328,3.81186),(-5.79596,27.34762,3.81253),(-5.67646,27.37906,3.78827),(-6.33436,28.55294,2.9132),(-6.41047,28.50816,2.81312),(-6.43652,28.51528,2.84285),(-6.28702,28.53718,2.88705),(-6.5883,28.3768,2.92078),(-6.66444,28.34376,3.02843),(-6.64196,28.37007,2.88772),(-6.2363,28.62985,3.13918),(-6.27241,28.67581,3.16129),(-6.26783,28.677,3.17723),(-6.22741,28.62138,3.16003),(-6.65887,28.38129,2.87847),(-6.67189,28.36238,3.02492),(-5.94562,27.18195,3.71856),(-6.02699,27.21978,3.77353),(-6.05345,27.18995,3.74382),(-6.60811,28.29586,3.05292),(-6.48801,28.21562,3.18202),(-6.48277,28.20937,3.13246),(-6.15412,27.34714,3.55971),(-6.15989,27.36782,3.60295),(-6.1137,27.36187,3.45994),(-6.14895,27.44778,3.48067),(-6.09543,27.22377,3.63398),(-5.89703,27.1198,3.45994),(-5.93305,27.11625,3.44856),(-5.76442,27.19788,3.59129),(-5.86014,27.14006,3.56283),(-5.85182,27.13416,3.51259),(-5.99087,27.1312,3.63043),(-5.9508,27.13428,3.63125),(-6.00859,27.16098,3.41753),(-5.95715,27.10947,3.47147),(-6.02189,27.13199,3.48807),(-6.10901,27.27204,3.37878),(-6.05323,27.22421,3.37438),(-6.0945,27.23255,3.41735),(-6.19195,27.87892,3.28101),(-6.07353,27.62233,3.38358),(-6.13711,27.60971,3.42488),(-6.24785,27.86852,3.33189),(-5.82296,27.31579,3.37024),(-5.83285,27.43819,3.78166),(-5.89051,27.58335,3.71738),(-6.17734,27.61245,3.46005),(-6.20733,27.62873,3.52033),(-6.17103,27.45423,3.58372),(-6.10115,27.40581,3.43168),(-6.08122,27.2746,3.48911),(-6.07534,27.17872,3.51508),(-6.06493,27.21022,3.53033),(-6.10079,27.24068,3.42673),(-5.68577,27.64981,3.6343),(-5.61565,27.49968,3.55332),(-5.7982,27.78258,3.45584),(-5.77362,27.82507,3.52451),(-5.6735,27.56438,3.47325),(-6.02833,27.41541,3.40065),(-6.02959,27.4048,3.40179),(-5.56856,27.34775,3.38331),(-5.53866,27.28608,3.42445),(-5.95877,27.30166,3.3166),(-6.06834,27.168,3.50889),(-5.97699,27.20745,3.35464),(-5.90911,27.11509,3.47933),(-5.60362,27.36245,3.71443),(-5.68873,27.30373,3.73789),(-5.64575,27.28992,3.66916),(-5.7568,27.18467,3.39094),(-5.71325,27.24164,3.64348),(-5.75691,27.22244,3.66451),(-5.68206,27.21676,3.51509),(-5.68853,27.22415,3.58366),(-5.75453,27.18877,3.45447),(-5.72504,27.20879,3.48134),(-5.81346,27.15807,3.45867),(-5.84652,27.17859,3.64177),(-5.87097,27.15311,3.61031),(-5.81349,27.20483,3.66153),(-6.32972,28.19025,3.48798),(-6.12108,28.01695,3.56621),(-6.22741,28.23856,3.48466),(-6.22037,27.97076,3.55125),(-6.11625,28.44328,3.28911),(-6.0336,28.31006,3.42124),(-6.0136,28.29169,3.35067),(-6.12747,28.47366,3.36758),(-6.24148,28.62844,3.32257),(-6.35371,28.69413,3.27489),(-6.30857,28.60995,3.33723),(-6.55901,28.58966,3.28881),(-6.58868,28.48503,3.32367),(-6.5084,28.53638,3.35928),(-6.20383,28.45626,3.03057),(-6.19394,28.41782,3.1167),(-6.04335,28.23369,3.28682),(-6.12383,28.38856,3.21231),(-6.2186,28.29381,3.12484),(-6.23819,28.39879,3.01392),(-6.2614,28.46217,2.9513),(-6.33625,28.2813,3.03594),(-6.19878,28.08516,3.1927),(-6.46354,28.35469,2.89967),(-6.40527,28.24777,3.01737),(-6.38322,28.39,2.90429),(-6.40567,28.082,3.34172),(-6.50126,28.23298,3.22398),(-6.51884,28.31627,3.39849),(-6.42167,28.14188,3.46556),(-6.5478,28.31542,2.95655),(-6.63442,28.47974,3.06388),(-6.62401,28.42187,3.01382),(-6.6654,28.39451,3.08743),(-6.28117,28.59641,3.02807),(-6.21712,28.56594,3.08404),(-6.5228,28.46884,2.76857),(-6.42876,28.62317,3.02436),(-6.47821,28.61981,3.03733),(-6.51634,28.67596,3.08253),(-6.36383,28.69142,3.07555),(-6.38589,28.55872,2.93308),(-6.45918,28.53512,2.91318),(-6.55547,28.48297,2.95222),(-6.60058,28.44482,2.92302),(-6.48504,28.54958,2.97385),(-6.56912,28.48535,3.00179),(-6.362,28.59379,2.99034),(-6.38014,28.61826,3.01594),(-6.5401,28.57431,3.03393),(-6.56147,28.51958,3.02),(-6.59943,28.59255,3.08154),(-6.31226,28.65028,3.07225),(-6.24528,28.55254,2.94676),(-6.66046,28.45182,3.14346),(-6.46678,28.2162,3.04791),(-6.66035,28.3837,3.09936),(-6.36207,28.04413,3.23555),(-6.31184,28.0479,3.18291),(-6.13253,28.14104,3.21853),(-6.41684,28.37116,3.42051),(-6.46195,28.68099,3.27638),(-6.40537,28.58186,3.35391),(-6.29461,27.87073,3.37078),(-6.38094,28.05747,3.28968),(-5.70384,27.21201,3.41261),(-5.62234,27.2571,3.59083),(-5.78221,27.27525,3.76063),(-5.62408,27.44507,3.35564),(-6.01183,27.63466,3.35795),(-6.0939,27.39584,3.42943),(-5.57823,27.43547,3.42872),(-5.54981,27.38696,3.46683),(-5.53586,27.32496,3.49796),(-5.54908,27.34049,3.57726),(-5.6212,27.5296,3.5295),(-6.11476,27.28332,3.38844),(-6.10168,27.34998,3.45257),(-6.20472,27.66671,3.60065),(-6.15022,27.48113,3.66233),(-6.01645,28.05391,3.54027),(-5.8748,27.80561,3.63793),(-5.91153,28.07866,3.49705),(-5.78833,27.83032,3.57301),(-6.14641,27.89486,3.26688),(-6.0675,27.15786,3.56149),(-6.06923,27.19784,3.56836),(-6.10428,27.25285,3.68257),(-6.08312,27.22194,3.536),(-6.10172,27.27741,3.50106),(-6.15524,27.36563,3.64134),(-5.60295,27.38696,3.71008),(-6.08085,27.20581,3.5735),(-6.04151,27.23172,3.77422),(-6.06264,27.2029,3.74064),(-6.06673,27.30592,3.73868),(-6.15275,27.42299,3.65175),(-6.59946,28.39446,2.80034),(-6.3485,28.71379,3.15059),(-6.3486,28.71443,3.16536),(-6.63503,28.52348,3.15202),(-6.6109,28.60074,3.16173),(-5.9177,27.31637,3.80961),(-5.91007,27.2982,3.80742),(-5.84762,27.25166,3.32149),(-6.48082,28.41713,2.84772),(-6.51852,28.40337,2.86653),(-6.58416,28.40588,2.78732),(-6.51449,28.45514,2.77305),(-6.27685,28.49597,2.91593),(-6.27223,28.51822,2.89418),(-6.41332,28.43842,2.86311),(-6.48509,28.68496,3.20623),(-6.35034,28.70155,3.21293),(-6.48746,28.68574,3.19924),(-6.35069,28.70017,3.22019),(-6.31176,27.88153,3.41909),(-6.04915,27.15044,3.6297),(-6.40466,28.49291,2.81613),(-6.50125,28.69247,3.15948),(-6.50495,28.69181,3.14536),(-6.60931,28.60002,3.17586),(-6.58705,28.5885,3.2318),(-6.59041,28.58835,3.22495),(-5.92939,27.12212,3.55599),(-6.30779,27.92426,3.523),(-6.09737,27.9215,3.28245),(-5.94041,27.66312,3.36414),(-6.0328,27.96577,3.31275),(-5.87085,27.71191,3.39733),(-5.93478,28.02574,3.37492),(-5.89557,28.0639,3.44571),(-5.98859,27.76163,3.65659),(-5.93863,27.38897,3.77224),(-6.00894,27.53803,3.69971),(-6.08847,27.72184,3.6386),(-5.86615,27.40133,3.38584),(-5.87134,27.23037,3.74956),(-6.26928,28.06199,3.17197),(-6.13628,28.27707,3.45406),(-6.21517,28.43988,3.39666),(-6.30893,28.41296,3.42447)]))),
        Shape(DEF='rmc2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,1),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmc2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,2,7,8,-1,8,9,2,-1,2,9,10,-1,11,12,13,-1,11,14,12,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,25,29,-1,29,30,28,-1,26,28,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,50,53,51,-1,54,55,56,-1,55,57,56,-1,58,59,60,-1,61,62,63,-1,64,65,66,-1,67,68,27,-1,67,69,68,-1,70,71,72,-1,71,73,72,-1,74,75,76,-1,77,78,79,-1,77,80,78,-1,70,81,82,-1,70,72,81,-1,83,75,84,-1,75,85,84,-1,86,81,84,-1,86,87,81,-1,88,89,90,-1,88,91,89,-1,92,93,94,-1,93,95,94,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,102,100,111,-1,114,112,115,-1,112,116,113,-1,117,118,119,-1,119,118,120,-1,121,122,123,-1,122,124,125,-1,126,127,128,-1,127,129,130,-1,126,128,131,-1,131,132,126,-1,129,133,130,-1,129,134,133,-1,118,135,136,-1,118,137,135,-1,138,139,10,-1,10,9,138,-1,127,140,135,-1,141,142,143,-1,141,144,142,-1,142,145,143,-1,146,147,143,-1,138,148,149,-1,150,151,152,-1,153,154,155,-1,155,156,153,-1,157,158,159,-1,96,160,159,-1,117,161,118,-1,117,162,161,-1,163,164,165,-1,147,146,151,-1,146,163,151,-1,166,11,167,-1,14,11,168,-1,169,170,171,-1,172,173,169,-1,116,174,175,-1,176,177,178,-1,176,179,177,-1,12,180,181,-1,182,181,183,-1,184,185,183,-1,183,110,184,-1,186,114,187,-1,188,189,178,-1,189,190,178,-1,188,18,189,-1,191,192,193,-1,34,194,32,-1,195,196,197,-1,107,198,199,-1,107,200,198,-1,37,201,35,-1,202,24,203,-1,204,5,4,-1,204,52,5,-1,205,206,207,-1,205,208,206,-1,209,210,211,-1,211,212,209,-1,38,40,213,-1,214,48,47,-1,47,215,214,-1,216,217,218,-1,216,219,75,-1,216,218,30,-1,76,220,74,-1,76,73,220,-1,3,221,222,-1,3,223,221,-1,57,91,56,-1,91,88,56,-1,224,106,225,-1,226,227,228,-1,229,230,231,-1,230,228,231,-1,232,233,234,-1,232,148,233,-1,235,236,237,-1,237,238,235,-1,239,240,241,-1,139,242,243,-1,244,245,246,-1,247,248,246,-1,249,250,246,-1,251,0,252,-1,236,253,254,-1,251,255,256,-1,255,257,256,-1,258,259,260,-1,259,261,260,-1,200,107,106,-1,193,32,262,-1,263,264,265,-1,264,266,265,-1,267,268,269,-1,270,271,272,-1,273,260,261,-1,273,274,260,-1,275,276,277,-1,275,278,276,-1,279,280,281,-1,279,282,280,-1,283,284,65,-1,285,286,287,-1,288,287,286,-1,288,69,287,-1,65,48,289,-1,194,290,291,-1,191,292,192,-1,292,293,192,-1,212,214,209,-1,294,295,296,-1,294,297,295,-1,298,54,299,-1,300,301,298,-1,298,302,300,-1,303,304,299,-1,299,282,303,-1,305,306,307,-1,299,308,282,-1,299,309,308,-1,88,310,309,-1,309,56,88,-1,311,306,90,-1,90,86,311,-1,79,78,312,-1,312,313,79,-1,204,314,207,-1,62,61,58,-1,315,80,316,-1,205,317,318,-1,319,320,321,-1,319,322,323,-1,319,324,325,-1,319,326,45,-1,319,321,327,-1,328,329,330,-1,331,332,333,-1,331,334,332,-1,335,336,337,-1,338,93,92,-1,338,339,93,-1,1,340,341,-1,342,343,344,-1,121,345,346,-1,121,123,345,-1,146,145,163,-1,347,348,257,-1,347,349,348,-1,340,350,341,-1,350,17,341,-1,0,251,351,-1,148,232,149,-1,232,352,149,-1,245,233,353,-1,245,244,233,-1,249,238,239,-1,239,250,249,-1,354,240,237,-1,237,355,354,-1,355,179,356,-1,356,354,355,-1,357,176,190,-1,358,354,359,-1,232,264,352,-1,112,360,115,-1,112,111,360,-1,101,361,133,-1,133,99,101,-1,98,156,362,-1,98,363,156,-1,134,132,98,-1,151,150,147,-1,364,363,98,-1,98,131,364,-1,98,132,131,-1,365,366,367,-1,365,185,366,-1,12,181,182,-1,170,143,171,-1,170,141,143,-1,368,167,11,-1,369,370,371,-1,370,372,371,-1,373,374,375,-1,376,377,378,-1,379,380,381,-1,379,369,371,-1,379,382,383,-1,379,373,384,-1,379,385,376,-1,379,381,385,-1,379,376,373,-1,384,382,379,-1,379,383,369,-1,379,371,380,-1,371,372,380,-1,372,365,380,-1,168,386,387,-1,173,19,169,-1,172,181,180,-1,180,173,172,-1,372,185,365,-1,372,183,185,-1,119,184,110,-1,151,125,108,-1,153,363,388,-1,153,156,363,-1,388,389,153,-1,388,344,389,-1,96,98,362,-1,390,266,111,-1,266,360,111,-1,358,232,241,-1,190,176,178,-1,179,254,177,-1,179,355,254,-1,237,236,254,-1,254,355,237,-1,234,250,239,-1,234,391,250,-1,235,238,249,-1,249,248,235,-1,392,138,9,-1,392,353,138,-1,391,244,246,-1,139,138,149,-1,256,144,393,-1,394,348,349,-1,394,164,348,-1,394,334,395,-1,394,396,334,-1,397,154,121,-1,343,389,344,-1,123,122,165,-1,165,122,163,-1,336,397,337,-1,336,398,397,-1,345,334,331,-1,345,395,334,-1,399,333,400,-1,399,331,333,-1,401,273,261,-1,401,402,273,-1,319,403,326,-1,319,45,324,-1,319,404,322,-1,319,323,320,-1,59,44,60,-1,405,315,316,-1,406,204,4,-1,406,314,204,-1,52,407,5,-1,52,51,407,-1,205,318,82,-1,82,208,205,-1,75,217,216,-1,75,74,217,-1,311,307,306,-1,408,87,89,-1,409,57,55,-1,409,91,57,-1,56,299,54,-1,308,309,410,-1,309,310,410,-1,303,282,279,-1,279,304,303,-1,411,300,302,-1,411,412,300,-1,51,301,407,-1,298,413,54,-1,414,415,231,-1,196,416,197,-1,196,417,416,-1,215,209,214,-1,49,48,65,-1,418,225,29,-1,65,286,285,-1,285,66,65,-1,65,64,283,-1,105,419,106,-1,282,308,280,-1,229,281,230,-1,229,279,281,-1,420,421,422,-1,423,424,425,-1,423,426,424,-1,277,427,428,-1,277,276,427,-1,199,271,258,-1,268,427,429,-1,427,430,429,-1,305,431,410,-1,305,275,431,-1,432,92,330,-1,432,338,92,-1,199,433,271,-1,199,421,433,-1,199,258,260,-1,347,257,255,-1,255,434,347,-1,435,434,149,-1,257,145,142,-1,257,348,145,-1,142,256,257,-1,350,340,351,-1,166,167,15,-1,250,391,246,-1,248,249,246,-1,245,247,246,-1,244,391,233,-1,391,234,233,-1,8,236,392,-1,236,235,392,-1,232,239,241,-1,232,234,239,-1,253,236,8,-1,275,305,436,-1,299,56,309,-1,55,54,413,-1,413,437,55,-1,63,285,312,-1,63,66,285,-1,42,221,438,-1,42,222,221,-1,285,287,312,-1,287,313,312,-1,75,83,76,-1,219,85,75,-1,29,68,418,-1,217,31,218,-1,217,439,31,-1,65,284,49,-1,40,215,47,-1,47,213,40,-1,209,39,210,-1,39,43,210,-1,317,207,314,-1,317,205,207,-1,319,325,404,-1,50,204,437,-1,298,53,413,-1,440,441,442,-1,201,202,35,-1,202,203,35,-1,198,292,416,-1,416,422,198,-1,196,195,443,-1,444,445,446,-1,332,447,448,-1,174,449,175,-1,449,450,175,-1,104,366,451,-1,104,452,366,-1,232,358,264,-1,358,359,360,-1,359,115,360,-1,175,113,116,-1,175,453,113,-1,152,110,183,-1,183,181,152,-1,178,177,188,-1,18,177,16,-1,18,188,177,-1,171,172,169,-1,19,173,20,-1,173,180,20,-1,166,168,11,-1,163,122,151,-1,399,335,337,-1,399,400,335,-1,121,346,397,-1,120,104,451,-1,454,157,159,-1,158,96,159,-1,389,121,154,-1,154,153,389,-1,151,122,125,-1,172,455,181,-1,147,455,143,-1,147,150,455,-1,145,146,143,-1,144,256,142,-1,170,169,19,-1,127,137,128,-1,118,136,120,-1,104,120,136,-1,136,361,104,-1,130,133,361,-1,361,140,130,-1,140,127,130,-1,137,118,161,-1,126,129,127,-1,137,127,135,-1,364,131,161,-1,389,122,121,-1,389,343,122,-1,122,343,342,-1,342,124,122,-1,116,112,114,-1,456,113,453,-1,456,103,113,-1,361,101,104,-1,102,104,101,-1,101,100,102,-1,97,134,98,-1,266,390,457,-1,264,263,352,-1,330,92,94,-1,91,409,89,-1,409,408,89,-1,87,408,81,-1,311,84,85,-1,311,86,84,-1,305,458,436,-1,305,307,458,-1,74,220,217,-1,220,439,217,-1,69,418,68,-1,69,288,418,-1,62,66,63,-1,62,64,66,-1,459,289,48,-1,204,50,52,-1,210,43,42,-1,42,438,210,-1,39,38,43,-1,442,35,460,-1,35,203,460,-1,460,412,411,-1,29,27,68,-1,29,25,27,-1,28,26,25,-1,461,27,26,-1,461,67,27,-1,23,296,462,-1,22,294,296,-1,296,23,22,-1,22,24,202,-1,202,463,22,-1,20,387,21,-1,20,464,387,-1,350,15,17,-1,350,386,15,-1,14,464,12,-1,392,9,8,-1,7,253,8,-1,403,319,327,-1,223,5,407,-1,223,3,5,-1,1,7,2,-1,2,252,0,-1,2,10,252,-1,301,223,407,-1,462,223,301,-1,465,327,406,-1,465,403,327,-1,271,259,258,-1,271,270,259,-1,466,467,468,-1,467,466,469,-1,166,386,168,-1,386,166,15,-1,393,387,351,-1,393,21,387,-1,417,470,420,-1,417,471,470,-1,420,472,473,-1,470,472,420,-1,221,462,296,-1,462,221,223,-1,211,438,295,-1,211,210,438,-1,461,31,439,-1,461,26,31,-1,474,295,297,-1,211,295,474,-1,38,41,43,-1,38,475,41,-1,475,213,476,-1,475,38,213,-1,290,418,288,-1,290,477,418,-1,405,317,315,-1,405,318,317,-1,307,219,458,-1,311,219,307,-1,311,85,219,-1,305,310,306,-1,410,310,305,-1,424,328,478,-1,329,328,424,-1,479,480,481,-1,482,480,479,-1,263,483,352,-1,263,484,483,-1,485,456,377,-1,456,485,452,-1,113,102,111,-1,113,103,102,-1,161,486,364,-1,486,161,162,-1,131,137,161,-1,131,128,137,-1,135,361,136,-1,135,140,361,-1,133,97,99,-1,133,134,97,-1,138,233,148,-1,138,353,233,-1,96,487,160,-1,96,362,487,-1,95,454,159,-1,93,454,95,-1,119,451,184,-1,119,120,451,-1,399,397,346,-1,399,337,397,-1,176,356,179,-1,356,176,488,-1,386,351,387,-1,386,350,351,-1,144,21,393,-1,21,144,141,-1,366,184,451,-1,366,185,184,-1,264,360,266,-1,358,360,264,-1,489,449,357,-1,449,489,450,-1,167,190,189,-1,490,190,167,-1,447,491,448,-1,447,433,491,-1,212,474,492,-1,474,212,211,-1,196,471,417,-1,196,443,471,-1,446,262,459,-1,446,445,262,-1,212,446,214,-1,492,446,212,-1,492,444,446,-1,191,416,292,-1,416,191,197,-1,224,200,106,-1,224,293,200,-1,440,460,411,-1,440,442,460,-1,215,39,209,-1,215,40,39,-1,413,50,437,-1,53,50,413,-1,61,325,58,-1,325,61,404,-1,439,79,461,-1,439,77,79,-1,439,220,77,-1,67,287,69,-1,67,313,287,-1,64,58,283,-1,64,62,58,-1,89,86,90,-1,87,86,89,-1,60,283,58,-1,60,284,283,-1,278,436,493,-1,275,436,278,-1,226,448,491,-1,226,494,448,-1,400,494,495,-1,333,494,400,-1,10,243,252,-1,243,10,139,-1,248,392,235,-1,392,248,247,-1,340,0,351,-1,340,1,0,-1,255,242,434,-1,242,255,243,-1,466,434,435,-1,434,466,347,-1,435,469,466,-1,469,435,401,-1,445,193,262,-1,445,195,193,-1,267,432,268,-1,267,338,432,-1,329,432,330,-1,329,428,432,-1,277,431,275,-1,277,496,431,-1,429,269,268,-1,429,484,269,-1,497,427,276,-1,497,430,427,-1,105,493,419,-1,105,278,493,-1,107,497,105,-1,497,107,274,-1,426,329,424,-1,426,496,329,-1,281,426,423,-1,281,280,426,-1,498,425,495,-1,498,423,425,-1,433,499,491,-1,499,433,421,-1,228,498,226,-1,228,230,498,-1,231,227,414,-1,231,228,227,-1,308,431,280,-1,308,410,431,-1,422,199,198,-1,422,421,199,-1,477,225,418,-1,477,224,225,-1,214,459,48,-1,446,459,214,-1,471,474,470,-1,474,471,492,-1,500,473,472,-1,414,473,500,-1,463,414,500,-1,463,415,414,-1,300,24,23,-1,24,300,412,-1,202,415,463,-1,415,202,201,-1,36,279,229,-1,441,279,36,-1,440,302,304,-1,440,411,302,-1,441,304,279,-1,441,440,304,-1,409,437,206,-1,409,55,437,-1,81,208,82,-1,408,208,81,-1,458,216,30,-1,216,458,219,-1,313,461,79,-1,313,67,461,-1,405,71,70,-1,405,316,71,-1,204,206,437,-1,204,207,206,-1,501,6,502,-1,501,465,6,-1,323,503,315,-1,322,503,323,-1,58,324,59,-1,58,325,324,-1,45,501,46,-1,326,501,45,-1,406,321,314,-1,321,406,327,-1,433,272,271,-1,447,272,433,-1,335,495,425,-1,335,400,495,-1,273,429,430,-1,402,429,273,-1,468,504,396,-1,468,467,504,-1,402,484,429,-1,483,484,402,-1,328,94,482,-1,330,94,328,-1,331,346,345,-1,399,346,331,-1,481,336,479,-1,481,398,336,-1,395,123,165,-1,345,123,395,-1,396,349,468,-1,394,349,396,-1,348,163,145,-1,348,164,163,-1,253,1,341,-1,253,7,1,-1,253,177,254,-1,177,253,16,-1,449,186,488,-1,186,449,174,-1,241,354,358,-1,241,240,354,-1,114,174,116,-1,114,186,174,-1,157,457,390,-1,454,457,157,-1,160,481,480,-1,160,487,481,-1,96,99,97,-1,99,96,158,-1,344,486,342,-1,486,344,388,-1,397,155,154,-1,398,155,397,-1,109,125,124,-1,125,109,108,-1,372,182,183,-1,370,182,372,-1,464,168,387,-1,168,464,14,-1,375,489,490,-1,374,489,375,-1,378,175,450,-1,378,453,175,-1,381,365,367,-1,380,365,381,-1,13,382,11,-1,382,13,383,-1,485,381,367,-1,385,381,485,-1,373,378,374,-1,378,373,376,-1,382,368,11,-1,384,368,382,-1,370,383,13,-1,383,370,369,-1,377,453,378,-1,377,456,453,-1,374,450,489,-1,378,450,374,-1,368,490,167,-1,375,490,368,-1,182,13,12,-1,182,370,13,-1,485,366,452,-1,367,366,485,-1,124,117,109,-1,124,162,117,-1,388,364,486,-1,364,388,363,-1,398,487,155,-1,487,398,481,-1,390,100,99,-1,390,111,100,-1,93,457,454,-1,93,339,457,-1,99,157,390,-1,157,99,158,-1,265,484,263,-1,484,265,269,-1,354,187,359,-1,354,356,187,-1,357,488,176,-1,449,488,357,-1,252,255,251,-1,252,243,255,-1,352,435,149,-1,352,483,435,-1,95,482,94,-1,480,482,95,-1,335,479,336,-1,478,479,335,-1,483,401,435,-1,483,402,401,-1,332,396,504,-1,396,332,334,-1,268,428,427,-1,268,432,428,-1,425,478,335,-1,424,478,425,-1,332,494,333,-1,494,332,448,-1,467,272,504,-1,467,270,272,-1,320,314,321,-1,320,317,314,-1,326,465,501,-1,403,465,326,-1,503,404,61,-1,404,503,322,-1,320,315,317,-1,323,315,320,-1,61,78,503,-1,61,312,78,-1,61,63,312,-1,46,502,41,-1,46,501,502,-1,316,77,71,-1,80,77,316,-1,218,28,30,-1,28,218,31,-1,493,458,30,-1,436,458,493,-1,299,302,298,-1,299,304,302,-1,415,37,231,-1,37,415,201,-1,22,500,294,-1,22,463,500,-1,3,502,6,-1,3,222,502,-1,294,472,297,-1,500,472,294,-1,41,222,42,-1,41,502,222,-1,422,417,420,-1,417,422,416,-1,34,224,477,-1,33,224,34,-1,291,288,286,-1,291,290,288,-1,225,419,29,-1,225,106,419,-1,414,499,473,-1,414,227,499,-1,226,495,494,-1,226,498,495,-1,230,423,498,-1,423,230,281,-1,496,280,431,-1,496,426,280,-1,430,274,273,-1,497,274,430,-1,419,30,29,-1,419,493,30,-1,276,105,497,-1,105,276,278,-1,496,428,329,-1,277,428,496,-1,339,269,265,-1,338,269,339,-1,267,269,338,-1,260,107,199,-1,260,274,107,-1,259,401,261,-1,259,469,401,-1,434,139,149,-1,434,242,139,-1,341,16,253,-1,17,16,341,-1,240,238,237,-1,239,238,240,-1,35,441,36,-1,442,441,35,-1,36,231,37,-1,36,229,231,-1,227,491,499,-1,227,226,491,-1,504,447,332,-1,272,447,504,-1,60,49,284,-1,476,49,60,-1,76,72,73,-1,76,83,72,-1,408,206,208,-1,408,409,206,-1,412,203,24,-1,412,460,203,-1,293,198,200,-1,293,292,198,-1,33,293,224,-1,33,192,293,-1,194,289,459,-1,194,291,289,-1,197,193,195,-1,197,191,193,-1,195,444,443,-1,445,444,195,-1,459,32,194,-1,459,262,32,-1,193,33,32,-1,33,193,192,-1,443,492,471,-1,444,492,443,-1,357,490,489,-1,357,190,490,-1,189,15,167,-1,15,189,18,-1,150,181,455,-1,152,181,150,-1,187,115,359,-1,114,115,187,-1,455,171,143,-1,171,455,172,-1,464,180,12,-1,464,20,180,-1,488,187,356,-1,186,187,488,-1,395,164,394,-1,164,395,165,-1,480,159,160,-1,480,95,159,-1,362,155,487,-1,362,156,155,-1,247,353,392,-1,353,247,245,-1,134,126,132,-1,129,126,134,-1,162,342,486,-1,342,162,124,-1,375,384,373,-1,375,368,384,-1,109,119,110,-1,109,117,119,-1,339,266,457,-1,266,339,265,-1,108,152,151,-1,108,110,152,-1,385,377,376,-1,377,385,485,-1,452,103,456,-1,103,452,104,-1,482,478,328,-1,482,479,478,-1,306,88,90,-1,310,88,306,-1,81,83,84,-1,72,83,81,-1,318,70,82,-1,405,70,318,-1,78,315,503,-1,80,315,78,-1,220,71,77,-1,71,220,73,-1,477,194,34,-1,290,194,477,-1,289,286,65,-1,289,291,286,-1,476,44,475,-1,60,44,476,-1,51,298,301,-1,53,298,51,-1,49,213,47,-1,213,49,476,-1,46,475,44,-1,475,46,41,-1,59,45,44,-1,45,59,324,-1,470,297,472,-1,470,474,297,-1,221,295,438,-1,296,295,221,-1,473,421,420,-1,421,473,499,-1,141,19,21,-1,141,170,19,-1,256,351,251,-1,256,393,351,-1,468,347,466,-1,468,349,347,-1,469,270,467,-1,270,469,259,-1,465,4,6,-1,465,406,4,-1,300,462,301,-1,23,462,300,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmc2_Coord',point=[(-7.29785,28.34222,3.24071),(-7.29429,28.32866,3.21345),(-7.2868,28.31572,3.21329),(-6.9512,26.68315,4.09735),(-6.84636,26.67087,4.10553),(-6.8507,26.68964,4.10044),(-6.9354,26.65571,4.09883),(-7.29649,28.31902,3.20112),(-7.27403,28.28892,3.16521),(-7.27267,28.27506,3.17514),(-7.27476,28.25293,3.21806),(-7.1928,28.45692,3.13928),(-7.16204,28.46083,3.25209),(-7.12906,28.44659,3.21704),(-7.21744,28.4594,3.19307),(-7.29992,28.48192,3.11816),(-7.31072,28.47703,3.11689),(-7.30932,28.47702,3.12686),(-7.30534,28.48332,3.10337),(-7.23211,28.42793,3.26639),(-7.22709,28.46113,3.23831),(-7.27821,28.46498,3.20859),(-7.02426,26.83488,4.09983),(-6.9846,26.81865,4.11014),(-6.97408,26.88789,4.13732),(-6.93835,26.76055,3.72859),(-6.9037,26.69818,3.72198),(-6.94635,26.70322,3.73651),(-6.91568,26.7678,3.72802),(-6.95326,26.79779,3.72136),(-6.92202,26.80766,3.72947),(-6.87126,26.71803,3.73762),(-7.2325,26.75166,3.81816),(-7.18973,26.78669,3.77995),(-7.17417,26.73485,3.7919),(-6.95359,26.94054,4.14453),(-6.96473,27.01908,4.10273),(-6.98281,26.99936,4.10826),(-7.12876,26.6133,4.00345),(-7.15899,26.63682,3.99819),(-7.16168,26.61642,3.97085),(-7.09523,26.61147,4.05127),(-7.12117,26.64725,4.04391),(-7.14065,26.64403,4.02696),(-7.04167,26.54773,4.02109),(-6.97113,26.51355,4.04023),(-7.03863,26.56318,4.04806),(-7.14567,26.60393,3.94864),(-7.15277,26.64215,3.90934),(-7.09879,26.57378,3.94954),(-6.74607,26.72443,4.08501),(-6.80542,26.71857,4.07982),(-6.78125,26.70877,4.0904),(-6.75354,26.7411,4.07813),(-6.68872,26.81918,4.05134),(-6.67483,26.82038,4.03749),(-6.67081,26.87505,3.98932),(-6.66581,26.86103,3.99165),(-7.01028,26.49217,3.94169),(-7.03342,26.515,3.9836),(-7.06088,26.52668,3.9653),(-6.93698,26.47964,3.89245),(-6.97327,26.49646,3.89211),(-6.95628,26.50831,3.8543),(-6.99165,26.50905,3.88732),(-6.98955,26.55915,3.9236),(-6.97081,26.52583,3.84521),(-6.95303,26.65204,3.75019),(-6.96276,26.70737,3.74381),(-6.9682,26.65718,3.76641),(-6.68418,26.67207,3.88981),(-6.7172,26.64283,3.83032),(-6.68887,26.70412,3.86417),(-6.71945,26.66283,3.8239),(-6.77112,26.67965,3.78464),(-6.78735,26.70796,3.83957),(-6.72283,26.67926,3.81799),(-6.77775,26.63265,3.78483),(-6.85125,26.5488,3.80722),(-6.86747,26.61001,3.75381),(-6.78084,26.57239,3.83873),(-6.66581,26.74991,3.89284),(-6.66982,26.69386,3.94138),(-6.69643,26.71567,3.85613),(-6.67281,26.76218,3.88493),(-6.75462,26.76551,3.8657),(-6.66495,26.81161,3.90441),(-6.65411,26.80368,3.91428),(-6.6621,26.87866,3.94132),(-6.64707,26.85231,3.92927),(-6.65623,26.8628,3.92045),(-6.6575,26.86865,3.95186),(-6.95445,27.95187,3.2605),(-6.93446,28.0245,3.17985),(-6.93861,27.96035,3.27913),(-6.90312,28.03698,3.2042),(-6.8554,28.20457,3.12793),(-6.87376,28.2553,3.11522),(-6.85203,28.27744,3.17168),(-6.89437,28.22377,3.0315),(-6.93297,28.24611,3.00561),(-6.91271,28.26096,3.02173),(-6.93321,28.26102,2.99266),(-6.92934,28.27789,2.97374),(-6.90518,28.29773,3.02049),(-6.98685,27.13113,3.6422),(-7.05793,26.93104,3.71885),(-7.10641,27.13134,3.68585),(-7.00928,28.48129,3.34939),(-6.94881,28.47757,3.33192),(-6.97837,28.53142,3.28963),(-7.00562,28.19323,2.94798),(-7.02234,28.21955,2.88759),(-6.9891,28.252,2.87947),(-7.04673,28.23027,2.81222),(-7.05779,28.18496,2.87987),(-7.02761,28.2495,2.80978),(-6.86896,28.45017,3.27786),(-6.85796,28.38665,3.16486),(-6.88344,28.49137,3.23631),(-6.86794,28.39735,3.14562),(-6.94914,28.33705,3.42622),(-7.03455,28.42427,3.4236),(-7.03496,28.35249,3.43337),(-6.93286,28.44857,3.35464),(-7.02232,28.46222,3.37138),(-6.88391,28.31141,3.17827),(-6.89645,28.32153,3.17316),(-6.87804,28.32719,3.18888),(-6.89598,28.30248,3.15484),(-6.90153,28.31189,3.14953),(-6.83697,28.33606,3.21571),(-6.86063,28.30059,3.15935),(-6.88676,28.29039,3.10454),(-6.8756,28.28788,3.12682),(-6.90187,28.34303,3.16567),(-6.88304,28.36788,3.12899),(-6.882,28.3419,3.1848),(-7.2569,28.22079,3.1932),(-7.27063,28.24548,3.22133),(-6.90136,28.32491,3.15117),(-7.25973,28.4585,3.28252),(-7.2456,28.4476,3.32378),(-7.23376,28.4525,3.33122),(-7.26726,28.45467,3.2845),(-7.23678,28.44836,3.33556),(-7.22435,28.45319,3.34256),(-7.2076,28.46395,3.34304),(-7.208,28.17966,3.17685),(-7.19505,28.1198,3.23978),(-7.18798,28.47625,3.34078),(-7.15863,28.47267,3.36661),(-7.13374,28.5025,3.33287),(-6.87565,28.34003,3.38344),(-6.88432,28.31405,3.39219),(-6.85532,28.2609,3.32239),(-6.84616,28.28902,3.29878),(-6.90286,28.14781,3.03744),(-6.87931,28.17963,3.05134),(-6.86681,28.12123,3.10258),(-6.85688,28.16109,3.17473),(-6.83497,28.36084,3.2122),(-6.86115,28.42054,3.31075),(-7.16209,28.42829,3.38473),(-7.14933,28.34198,3.38856),(-7.11025,28.35435,3.41053),(-7.25898,28.47409,3.12525),(-7.26475,28.49714,3.03647),(-7.24122,28.46314,3.16701),(-7.217,28.44094,3.30567),(-7.23644,28.43546,3.29913),(-7.22341,28.44358,3.32125),(-7.19162,28.44375,3.3167),(-7.20506,28.44369,3.29399),(-7.0383,28.25656,2.80749),(-7.02187,28.26402,2.81526),(-7.23114,28.36276,2.90765),(-7.29412,28.4648,3.02254),(-7.28632,28.47152,3.01307),(-7.24118,28.35281,2.91485),(-7.17617,28.45883,3.26839),(-7.13362,28.49821,3.31689),(-7.08012,28.49165,3.26871),(-6.98222,28.53318,3.26423),(-6.89156,28.49758,3.21778),(-6.90741,28.4979,3.19569),(-7.05799,28.24048,2.81088),(-7.06205,28.23,2.81302),(-7.28747,28.47646,3.02275),(-7.27773,28.49458,3.02894),(-7.21126,28.45333,2.94321),(-7.23325,26.81544,3.80313),(-7.21069,26.80615,3.78686),(-7.23639,26.76387,3.81493),(-7.16542,26.69684,3.82465),(-7.23979,26.76311,3.82623),(-7.23174,26.81141,3.85327),(-7.24026,26.81519,3.82024),(-7.22741,26.9077,3.7895),(-7.18931,27.11024,3.7521),(-7.15254,26.92329,3.75619),(-7.00026,26.96214,4.11738),(-7.00513,26.90979,4.12373),(-6.95259,26.92947,4.14468),(-6.73116,26.66489,4.07923),(-6.69702,26.63236,4.01496),(-6.67302,26.73235,4.03618),(-6.71318,26.64912,4.06028),(-6.6688,26.71222,3.9825),(-7.15139,26.64602,3.986),(-7.14033,26.65455,4.01065),(-7.14374,26.69876,3.98955),(-7.17107,26.68798,3.9643),(-7.14082,26.59645,3.97003),(-7.18562,26.67188,3.93416),(-7.15634,26.62367,3.9554),(-6.85306,26.73693,3.79008),(-6.81283,26.68717,3.76074),(-6.86216,26.72895,3.74194),(-6.80437,26.76243,3.82016),(-6.77493,26.66246,3.77687),(-7.03691,26.69469,4.08994),(-7.03038,26.67803,4.09492),(-6.95628,26.69713,4.08791),(-7.13526,26.81835,3.76237),(-7.02562,26.8163,3.72545),(-7.06518,27.43314,3.8447),(-7.07332,27.16848,3.94943),(-7.02307,27.19903,3.98115),(-6.98024,27.07778,4.05301),(-7.00106,27.20156,3.97741),(-7.00039,27.06909,4.0555),(-7.16614,28.14369,3.05227),(-7.20784,28.18946,3.16834),(-7.16786,28.16103,3.07262),(-7.26327,28.29925,3.07977),(-7.27084,28.30739,3.07593),(-7.24605,28.26321,3.00943),(-7.24296,28.25932,3.01974),(-7.18121,28.18607,3.01507),(-7.18114,28.1861,3.00404),(-7.17636,28.17744,3.00846),(-7.27127,28.24548,3.2285),(-7.27524,28.25473,3.23017),(-7.20572,28.21091,3.13418),(-7.22605,28.23381,3.148),(-7.19964,28.23493,3.10206),(-7.23177,28.26401,3.13435),(-7.22792,28.2797,3.0869),(-7.19797,28.27204,3.0562),(-7.17224,28.21907,3.05754),(-7.28448,28.35413,3.28724),(-7.27869,28.26159,3.22764),(-7.31662,28.41499,3.15516),(-7.29641,28.36752,3.04379),(-7.25659,28.27129,3.29679),(-7.27979,28.36274,3.2951),(-7.24859,28.27628,3.30475),(-7.19545,27.36773,3.66509),(-7.18484,27.66182,3.54525),(-7.18687,27.36372,3.65342),(-7.1751,27.64758,3.52732),(-7.2342,26.74855,3.82269),(-7.08274,28.03127,3.13461),(-7.10834,28.08973,3.02227),(-7.05043,28.01938,3.12939),(-7.07137,28.08332,3.0166),(-7.0101,27.93567,3.23327),(-7.02793,27.82483,3.30289),(-7.03644,27.93353,3.22274),(-7.1721,27.67116,3.57221),(-7.18788,27.37949,3.68625),(-7.15779,27.68167,3.60249),(-7.11872,27.61416,3.48858),(-7.11245,27.35739,3.61263),(-6.91436,27.14946,3.68009),(-6.99324,27.35766,3.56943),(-6.94845,27.35682,3.59273),(-6.958,27.13486,3.64811),(-6.92707,27.0692,4.05161),(-6.9088,27.18703,3.80046),(-6.96546,27.20211,3.95255),(-6.82685,27.0222,3.92539),(-7.03075,26.50497,3.93236),(-7.05937,26.52677,3.945),(-6.96288,26.54632,3.81847),(-6.99851,26.60432,3.84764),(-6.96571,26.61454,3.78306),(-6.99987,26.6594,3.79855),(-7.12763,26.65189,3.87701),(-7.10593,26.69395,3.81536),(-7.10145,26.66247,3.84412),(-7.22771,26.86877,3.79621),(-7.17775,26.85675,3.77673),(-7.06337,26.79198,4.06776),(-7.11697,26.70738,4.01901),(-7.04626,26.73763,4.07603),(-7.1251,26.75734,4.00791),(-6.81964,26.80115,4.04816),(-6.75819,26.91249,3.99412),(-6.92836,26.83482,4.11358),(-6.88931,26.73518,4.06614),(-6.89051,26.88726,4.09003),(-6.83536,26.97306,4.01398),(-6.87177,26.95741,4.07256),(-6.82949,26.98777,3.78903),(-6.71492,26.89085,3.8877),(-6.76512,26.87132,3.84544),(-6.81494,27.00838,3.88188),(-6.72511,26.91864,3.94743),(-6.72097,26.91095,3.90868),(-6.7304,26.83523,3.8803),(-6.94801,26.5372,3.81119),(-6.94951,26.6106,3.76694),(-6.75722,26.59025,4.07233),(-6.75652,26.53203,3.92603),(-6.73451,26.58609,3.87298),(-6.72531,26.56658,4.02115),(-6.69236,26.62337,3.98842),(-6.88449,26.4865,4.03031),(-6.78406,26.51238,4.0218),(-6.81001,26.52636,4.05732),(-6.85402,26.46634,3.94749),(-6.79511,26.4896,3.97631),(-6.97769,26.49417,4.00641),(-6.95479,26.47125,3.97823),(-6.93105,26.53411,4.06853),(-6.85641,26.54509,4.08098),(-6.96076,27.85802,3.38433),(-6.96741,27.59201,3.49928),(-6.96632,27.84046,3.35429),(-7.06052,28.1232,3.51682),(-7.09875,27.96012,3.55962),(-7.06318,27.96603,3.5926),(-7.09374,28.11478,3.49823),(-6.99191,27.93433,3.54271),(-6.94925,28.06401,3.45193),(-6.97043,28.09516,3.48234),(-6.98558,27.93764,3.24544),(-6.98299,28.02006,3.15632),(-7.29078,28.44245,3.17716),(-7.31527,28.42203,3.16527),(-6.93448,28.42396,3.38829),(-6.9705,28.41663,3.42175),(-6.93556,28.40744,3.41087),(-7.04985,28.24553,3.4705),(-6.995,28.2297,3.45565),(-7.21448,28.15485,3.32162),(-7.20419,28.30634,3.34381),(-7.17969,28.18901,3.36878),(-7.30061,28.47012,3.16297),(-7.29394,28.46362,3.19729),(-7.13178,28.06736,3.15008),(-7.24577,28.22547,3.1769),(-7.17871,28.24861,2.90382),(-7.24163,28.31025,2.96563),(-7.1685,28.28833,2.86169),(-7.15781,28.39701,2.88899),(-7.10448,28.11093,2.98467),(-7.07583,28.1841,2.87795),(-7.08391,28.11243,2.97562),(-6.88895,28.32423,3.09577),(-6.84897,28.24205,3.20512),(-6.83515,28.32289,3.26757),(-6.83007,28.34137,3.23892),(-6.9652,28.44909,3.16985),(-6.88394,28.39722,3.10996),(-6.92898,28.40389,3.11378),(-7.17581,28.45057,3.06248),(-7.05063,28.43293,3.17158),(-7.06883,28.46382,3.22685),(-7.01603,28.43642,3.16853),(-7.01182,28.48114,3.21233),(-7.06331,28.39722,3.0548),(-7.09759,28.38687,2.96953),(-7.1481,28.42712,3.00036),(-7.03065,28.37936,3.05174),(-6.98534,28.34222,3.0098),(-7.04214,28.33603,2.93244),(-7.03123,28.40406,3.1175),(-6.99756,28.43005,3.151),(-6.97784,28.40422,3.12325),(-7.1048,28.42259,3.12009),(-7.08369,28.42585,3.16588),(-7.0975,28.41888,3.08862),(-6.99387,28.37981,3.08787),(-7.29153,28.47574,3.15968),(-7.28234,28.47028,3.19098),(-6.86059,28.37464,3.36284),(-6.9351,28.37268,3.42994),(-6.97844,28.17394,2.96685),(-7.17277,28.19833,3.08503),(-7.26689,28.2815,3.15633),(-7.28807,28.45997,3.21228),(-7.13593,28.23777,3.42163),(-7.09511,28.25338,3.44974),(-7.12783,28.09351,3.46417),(-6.93669,28.20203,3.43996),(-6.91062,28.16024,3.38084),(-7.01833,28.11078,3.4996),(-7.03495,27.95706,3.58731),(-7.16283,27.8827,3.40709),(-7.11622,27.85511,3.35322),(-6.8895,26.54178,4.07773),(-6.90363,26.46403,3.95351),(-6.70913,26.60737,3.9274),(-6.84451,26.60859,4.10271),(-6.86125,26.7,4.08551),(-6.65498,26.78884,3.95037),(-6.6611,26.80978,4.00486),(-6.82267,26.99582,3.82102),(-6.91124,26.90886,4.12431),(-6.93632,26.88362,4.13686),(-6.71326,26.76254,4.07307),(-7.07516,26.993,4.01325),(-7.03768,26.97763,4.07003),(-7.23693,26.86718,3.81567),(-7.21187,26.85143,3.86441),(-6.99638,26.71597,3.75526),(-6.96691,26.93209,3.69882),(-7.18224,26.94123,3.88017),(-7.20386,27.12543,3.77519),(-7.23034,26.91119,3.81257),(-7.00996,27.43053,3.81606),(-6.96955,27.62012,3.57244),(-7.01372,27.67473,3.69114),(-6.94064,27.38863,3.69475),(-7.01378,27.58451,3.45151),(-6.97753,27.58844,3.4789),(-7.05225,27.82889,3.30724),(-7.03725,27.58331,3.44724),(-6.90342,27.1555,3.70597),(-6.9842,27.82769,3.3321),(-7.17776,27.38983,3.70895),(-7.21146,28.14881,3.30161),(-7.18424,27.98922,3.35467),(-6.85619,26.96502,3.74482),(-6.69452,26.75356,4.07745),(-7.1187,26.66091,4.03158),(-6.82243,26.66747,3.75948),(-6.90239,26.94844,4.11604),(-6.93413,27.01117,4.10752),(-6.93966,26.94257,4.14356),(-7.22409,26.78642,3.87467),(-7.22028,26.74417,3.88675),(-7.23856,26.75334,3.82934),(-7.21711,26.71027,3.88125),(-7.14152,27.68904,3.63231),(-7.10931,27.70741,3.67076),(-7.10262,28.32613,2.84116),(-7.08803,28.33163,2.85143),(-6.87483,28.39264,3.12225),(-6.91067,28.30521,3.02165),(-6.98944,28.26469,2.88506),(-6.91237,28.10646,3.07216),(-7.19295,28.47147,3.33046),(-6.93803,28.28804,2.97289),(-6.97431,28.1048,3.04182),(-6.83045,26.8459,3.79043),(-7.19755,26.69187,3.86292),(-6.94065,26.93088,4.14592),(-6.88288,26.64912,3.73733),(-6.96575,26.73637,4.07095),(-7.03931,26.88905,4.08609),(-7.22466,28.4636,3.22434),(-6.911,26.60092,4.09636),(-7.18995,28.00866,3.37233),(-7.15854,27.91111,3.46558),(-7.15987,28.04964,3.41679),(-7.17795,27.89345,3.42981),(-7.1656,26.82409,3.94507),(-7.19724,26.80595,3.90557),(-7.13502,26.83994,3.97796),(-7.14579,26.964,3.93139),(-7.15498,26.7487,3.97573),(-7.10464,26.59282,4.00947),(-7.10759,26.57065,3.97219),(-7.11055,26.72884,3.78454),(-6.95927,27.88853,3.4373),(-6.93493,28.00879,3.37002),(-6.89675,28.06604,3.24791),(-6.89414,28.1097,3.31171),(-6.93317,27.97872,3.31607),(-7.12118,27.95387,3.26918),(-7.06164,27.93612,3.229),(-6.95314,28.34593,3.05364),(-6.85762,28.39578,3.33926),(-6.85536,28.2031,3.24268),(-7.15865,28.30073,2.85478),(-7.14493,28.40035,2.89596),(-7.20094,28.45631,2.95108),(-7.12033,27.41555,3.78706),(-7.18855,26.74272,3.94201),(-6.93278,26.93734,3.70445),(-7.07216,27.70922,3.71676),(-7.04858,27.69946,3.71502),(-6.93915,27.35987,3.61203),(-7.02257,27.35742,3.56329),(-7.04036,27.43401,3.8397),(-7.13468,27.14646,3.87848),(-7.07808,26.87274,4.04133),(-6.97978,26.59299,4.0898),(-7.01658,26.6419,4.09272),(-6.84319,26.49484,3.88421),(-7.13247,27.93499,3.5136)]))),
        Shape(DEF='rmc3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,1),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmc3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,4,7,5,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,14,17,15,-1,18,19,20,-1,18,21,19,-1,22,23,24,-1,23,25,24,-1,26,27,28,-1,27,29,28,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,34,37,35,-1,38,39,40,-1,38,41,39,-1,42,43,44,-1,45,46,47,-1,46,48,47,-1,46,49,48,-1,49,50,48,-1,51,52,53,-1,53,54,51,-1,55,56,57,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,62,65,63,-1,66,59,61,-1,67,60,59,-1,68,63,65,-1,68,69,63,-1,65,67,59,-1,70,71,72,-1,70,73,71,-1,74,75,76,-1,70,77,73,-1,70,78,77,-1,79,77,78,-1,79,80,77,-1,76,2,81,-1,51,82,83,-1,51,55,82,-1,83,52,51,-1,84,82,85,-1,84,86,82,-1,87,88,89,-1,88,90,89,-1,91,89,92,-1,89,93,92,-1,94,95,96,-1,95,97,96,-1,98,99,100,-1,101,102,103,-1,101,104,102,-1,105,104,106,-1,101,107,106,-1,108,109,106,-1,110,105,106,-1,111,112,113,-1,111,114,112,-1,115,111,113,-1,113,116,115,-1,117,118,119,-1,119,120,117,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,130,131,132,-1,132,133,130,-1,134,115,135,-1,135,136,134,-1,9,137,126,-1,126,138,9,-1,139,140,68,-1,68,141,139,-1,122,121,111,-1,111,142,122,-1,143,58,144,-1,143,145,58,-1,146,147,53,-1,146,148,147,-1,27,26,149,-1,149,150,151,-1,152,153,154,-1,152,155,153,-1,156,157,158,-1,159,160,161,-1,162,160,163,-1,164,160,165,-1,166,167,168,-1,3,169,6,-1,169,22,6,-1,170,171,172,-1,173,158,157,-1,173,174,158,-1,175,176,132,-1,175,177,176,-1,178,179,180,-1,178,181,179,-1,182,183,184,-1,185,186,187,-1,185,188,186,-1,189,190,191,-1,11,192,169,-1,193,194,195,-1,195,196,193,-1,197,198,199,-1,200,182,201,-1,182,202,203,-1,182,204,201,-1,182,205,206,-1,182,207,208,-1,182,209,210,-1,182,211,212,-1,213,214,215,-1,213,216,214,-1,217,14,25,-1,218,17,219,-1,220,171,192,-1,221,222,169,-1,221,223,222,-1,174,154,158,-1,174,224,154,-1,225,226,227,-1,226,156,227,-1,165,228,164,-1,165,229,228,-1,230,162,163,-1,230,231,162,-1,228,232,233,-1,232,226,233,-1,166,47,167,-1,234,235,236,-1,188,185,237,-1,238,239,151,-1,240,241,242,-1,242,243,240,-1,32,43,244,-1,44,245,40,-1,244,43,42,-1,246,43,198,-1,247,43,248,-1,249,43,31,-1,30,244,250,-1,30,32,244,-1,100,251,252,-1,253,254,26,-1,254,149,26,-1,255,256,257,-1,256,258,257,-1,16,259,24,-1,16,260,259,-1,261,262,263,-1,261,264,262,-1,155,265,266,-1,265,267,266,-1,268,269,18,-1,154,224,152,-1,19,21,270,-1,271,272,273,-1,273,274,271,-1,273,275,274,-1,276,136,139,-1,91,277,87,-1,277,278,87,-1,279,120,119,-1,280,2,1,-1,281,282,280,-1,73,2,71,-1,73,81,2,-1,283,284,285,-1,286,287,288,-1,286,289,287,-1,290,180,291,-1,180,179,291,-1,175,292,293,-1,294,9,138,-1,124,295,296,-1,297,124,298,-1,299,124,126,-1,300,124,301,-1,147,301,302,-1,147,148,301,-1,303,127,129,-1,86,127,304,-1,60,144,58,-1,141,305,276,-1,141,147,305,-1,276,305,136,-1,305,306,136,-1,307,308,309,-1,309,310,307,-1,311,312,313,-1,312,314,313,-1,315,316,317,-1,316,318,317,-1,60,67,319,-1,134,136,306,-1,141,320,147,-1,321,130,322,-1,321,323,130,-1,301,124,302,-1,125,124,300,-1,124,299,298,-1,295,124,297,-1,302,124,296,-1,175,293,324,-1,324,177,175,-1,131,292,132,-1,179,325,326,-1,179,75,325,-1,327,79,78,-1,327,328,329,-1,282,2,280,-1,330,331,123,-1,330,332,331,-1,333,334,335,-1,336,337,90,-1,338,339,97,-1,141,276,139,-1,95,274,275,-1,95,340,274,-1,64,341,342,-1,343,344,345,-1,343,346,344,-1,155,347,153,-1,252,248,100,-1,252,247,248,-1,31,33,348,-1,31,43,32,-1,248,43,249,-1,198,43,247,-1,44,43,246,-1,349,246,198,-1,198,197,349,-1,350,351,352,-1,350,353,351,-1,196,195,237,-1,195,354,237,-1,195,230,163,-1,163,159,195,-1,227,153,347,-1,227,156,153,-1,174,355,356,-1,174,173,355,-1,357,355,13,-1,357,356,355,-1,38,358,41,-1,197,359,218,-1,168,360,361,-1,361,362,168,-1,195,49,230,-1,195,194,49,-1,29,27,363,-1,182,210,211,-1,182,208,209,-1,182,206,207,-1,182,184,205,-1,182,200,183,-1,182,203,204,-1,182,212,202,-1,354,233,364,-1,25,16,24,-1,25,14,16,-1,365,359,199,-1,359,197,199,-1,366,15,365,-1,15,359,365,-1,171,220,172,-1,334,367,339,-1,334,368,367,-1,132,292,175,-1,173,232,369,-1,13,192,11,-1,370,371,372,-1,372,373,370,-1,374,160,164,-1,165,160,375,-1,163,160,159,-1,161,160,374,-1,238,234,193,-1,193,376,238,-1,151,239,377,-1,141,66,320,-1,141,68,66,-1,142,115,134,-1,142,111,115,-1,378,140,139,-1,123,122,379,-1,379,330,123,-1,130,323,131,-1,323,380,131,-1,128,84,381,-1,381,382,128,-1,117,120,333,-1,333,383,117,-1,2,282,71,-1,384,385,179,-1,385,291,179,-1,112,336,386,-1,112,114,336,-1,88,336,90,-1,88,386,336,-1,109,110,106,-1,107,108,106,-1,104,101,106,-1,107,101,103,-1,103,387,107,-1,104,105,388,-1,388,102,104,-1,105,389,388,-1,105,110,389,-1,390,391,266,-1,390,392,391,-1,393,18,269,-1,393,21,18,-1,394,315,265,-1,394,395,315,-1,90,396,89,-1,89,91,87,-1,82,55,85,-1,288,287,397,-1,287,398,397,-1,398,399,80,-1,80,397,398,-1,400,401,399,-1,74,76,400,-1,402,283,285,-1,326,384,179,-1,133,125,300,-1,400,398,74,-1,400,399,398,-1,74,325,75,-1,342,60,319,-1,342,144,60,-1,62,319,67,-1,68,140,69,-1,319,64,342,-1,319,62,64,-1,232,173,157,-1,65,62,67,-1,85,143,403,-1,55,57,145,-1,160,162,375,-1,41,253,404,-1,211,37,34,-1,405,406,348,-1,407,353,243,-1,407,351,353,-1,405,240,408,-1,169,192,221,-1,169,23,22,-1,169,222,23,-1,409,268,410,-1,409,269,268,-1,5,7,411,-1,259,260,412,-1,252,251,413,-1,3,5,411,-1,411,12,3,-1,338,414,92,-1,284,8,10,-1,78,328,327,-1,78,70,328,-1,70,72,328,-1,415,416,417,-1,328,415,329,-1,328,416,415,-1,418,280,345,-1,418,281,280,-1,416,72,419,-1,416,328,72,-1,396,337,383,-1,396,90,337,-1,420,118,117,-1,118,420,421,-1,422,423,417,-1,422,424,423,-1,419,417,416,-1,422,417,419,-1,338,93,339,-1,93,338,92,-1,91,414,425,-1,91,92,414,-1,414,97,426,-1,414,338,97,-1,427,251,428,-1,413,251,427,-1,412,7,4,-1,7,412,264,-1,3,11,169,-1,11,3,12,-1,122,429,379,-1,430,429,122,-1,263,427,428,-1,263,262,427,-1,4,259,412,-1,4,6,259,-1,366,262,260,-1,366,427,262,-1,407,193,196,-1,193,407,376,-1,240,353,408,-1,240,243,353,-1,350,408,353,-1,431,408,350,-1,358,214,216,-1,358,38,214,-1,258,50,257,-1,258,432,50,-1,375,231,433,-1,375,162,231,-1,369,172,173,-1,369,170,172,-1,434,435,436,-1,434,437,435,-1,234,194,193,-1,194,234,236,-1,310,397,438,-1,288,397,310,-1,143,55,145,-1,143,85,55,-1,56,61,57,-1,56,66,61,-1,226,157,156,-1,226,232,157,-1,74,287,325,-1,287,74,398,-1,81,400,76,-1,81,401,400,-1,384,292,385,-1,292,384,293,-1,326,293,384,-1,289,293,326,-1,286,439,324,-1,286,309,439,-1,285,307,402,-1,308,307,285,-1,325,289,326,-1,289,325,287,-1,438,327,329,-1,79,327,438,-1,129,382,440,-1,128,382,129,-1,52,304,441,-1,83,304,52,-1,277,425,442,-1,425,277,91,-1,443,390,444,-1,443,445,390,-1,267,315,317,-1,265,315,267,-1,394,446,395,-1,447,446,394,-1,393,313,448,-1,269,313,393,-1,311,449,450,-1,449,311,409,-1,445,451,190,-1,451,445,443,-1,452,453,454,-1,453,452,455,-1,448,314,346,-1,448,313,314,-1,444,266,267,-1,266,444,390,-1,454,456,452,-1,456,454,457,-1,458,123,331,-1,458,121,123,-1,318,459,460,-1,459,318,461,-1,110,462,389,-1,110,109,462,-1,463,107,387,-1,108,107,463,-1,119,464,279,-1,465,464,119,-1,321,129,323,-1,321,303,129,-1,291,380,440,-1,385,380,291,-1,466,421,420,-1,467,421,466,-1,282,72,71,-1,72,282,281,-1,76,0,2,-1,0,76,181,-1,466,337,336,-1,337,466,420,-1,272,342,341,-1,342,272,271,-1,85,381,84,-1,85,403,381,-1,177,138,176,-1,294,138,177,-1,468,378,469,-1,378,468,140,-1,330,470,8,-1,379,470,330,-1,378,136,135,-1,378,139,136,-1,146,303,321,-1,146,441,303,-1,471,358,472,-1,471,254,358,-1,473,457,99,-1,457,473,456,-1,239,376,242,-1,238,376,239,-1,377,363,27,-1,377,241,363,-1,191,474,189,-1,191,475,474,-1,476,477,392,-1,476,478,477,-1,479,350,352,-1,480,350,479,-1,392,481,391,-1,392,477,481,-1,17,359,15,-1,17,218,359,-1,373,482,370,-1,483,482,373,-1,371,484,166,-1,484,371,223,-1,484,221,485,-1,484,223,221,-1,224,486,152,-1,224,487,486,-1,488,417,423,-1,283,417,488,-1,205,489,490,-1,205,184,489,-1,37,210,361,-1,211,210,37,-1,362,208,491,-1,209,208,362,-1,207,492,493,-1,207,206,492,-1,204,494,201,-1,204,215,494,-1,203,495,213,-1,203,202,495,-1,212,34,496,-1,212,211,34,-1,225,233,226,-1,364,233,225,-1,368,497,367,-1,368,450,497,-1,225,481,186,-1,481,225,227,-1,172,355,173,-1,172,220,355,-1,436,171,170,-1,436,485,171,-1,365,252,413,-1,365,199,252,-1,354,374,233,-1,374,354,161,-1,498,499,500,-1,498,501,499,-1,44,349,245,-1,44,246,349,-1,489,183,502,-1,489,184,183,-1,503,363,405,-1,33,363,503,-1,33,29,363,-1,236,257,50,-1,236,235,257,-1,219,504,500,-1,504,219,502,-1,495,505,506,-1,496,505,495,-1,35,361,360,-1,37,361,35,-1,491,168,362,-1,491,372,168,-1,492,507,483,-1,490,507,492,-1,490,508,507,-1,489,508,490,-1,506,256,472,-1,506,505,256,-1,432,360,509,-1,35,360,432,-1,501,214,38,-1,214,501,498,-1,216,472,358,-1,506,472,216,-1,270,356,357,-1,356,270,487,-1,159,354,195,-1,161,354,159,-1,437,433,45,-1,229,433,437,-1,435,485,436,-1,484,485,435,-1,185,351,237,-1,352,351,185,-1,478,187,477,-1,478,479,187,-1,473,510,475,-1,473,511,510,-1,407,242,376,-1,407,243,242,-1,512,251,100,-1,512,513,251,-1,249,348,98,-1,249,31,348,-1,199,247,252,-1,199,198,247,-1,38,245,501,-1,38,40,245,-1,26,404,253,-1,26,28,404,-1,254,41,358,-1,254,253,41,-1,514,251,513,-1,514,428,251,-1,25,482,217,-1,25,23,482,-1,264,515,7,-1,264,261,515,-1,516,443,517,-1,443,516,451,-1,152,447,394,-1,486,447,152,-1,409,518,449,-1,518,409,410,-1,476,190,189,-1,476,445,190,-1,155,391,347,-1,155,266,391,-1,513,410,514,-1,513,518,410,-1,519,513,512,-1,513,519,518,-1,403,520,381,-1,520,403,521,-1,180,520,522,-1,180,290,520,-1,316,280,1,-1,316,523,280,-1,524,525,526,-1,524,178,525,-1,318,1,461,-1,318,316,1,-1,527,459,526,-1,527,528,459,-1,143,521,403,-1,521,143,144,-1,529,144,342,-1,529,521,144,-1,274,528,527,-1,340,528,274,-1,530,95,94,-1,340,95,530,-1,341,140,468,-1,140,341,69,-1,115,442,135,-1,277,442,115,-1,425,426,531,-1,425,414,426,-1,339,96,97,-1,339,367,96,-1,314,279,464,-1,312,279,314,-1,383,335,396,-1,383,333,335,-1,389,112,386,-1,462,112,389,-1,113,387,116,-1,113,463,387,-1,142,306,532,-1,142,134,306,-1,121,114,111,-1,458,114,121,-1,333,279,334,-1,279,333,120,-1,331,488,467,-1,332,488,331,-1,344,465,533,-1,465,344,464,-1,283,415,417,-1,283,402,415,-1,80,401,77,-1,401,80,399,-1,137,379,429,-1,137,470,379,-1,430,299,429,-1,430,298,299,-1,295,532,306,-1,532,295,297,-1,296,306,305,-1,296,295,306,-1,300,130,133,-1,322,130,300,-1,385,131,380,-1,385,292,131,-1,102,88,87,-1,102,388,88,-1,94,516,530,-1,94,534,516,-1,535,536,517,-1,460,536,535,-1,523,315,395,-1,523,316,315,-1,446,346,343,-1,346,446,448,-1,312,450,368,-1,450,312,311,-1,343,395,446,-1,343,523,395,-1,530,517,536,-1,530,516,517,-1,367,537,96,-1,537,367,497,-1,469,135,442,-1,378,135,469,-1,86,83,82,-1,83,86,304,-1,290,440,382,-1,290,291,440,-1,322,301,148,-1,300,301,322,-1,52,146,53,-1,441,146,52,-1,147,296,305,-1,296,147,302,-1,532,298,430,-1,532,297,298,-1,429,126,137,-1,429,299,126,-1,439,9,294,-1,10,9,439,-1,284,439,285,-1,10,439,284,-1,181,75,179,-1,181,76,75,-1,345,533,418,-1,533,345,344,-1,330,284,332,-1,330,8,284,-1,423,467,488,-1,467,423,421,-1,336,458,466,-1,336,114,458,-1,142,430,122,-1,142,532,430,-1,112,463,113,-1,463,112,462,-1,387,278,116,-1,278,387,103,-1,388,386,88,-1,386,388,389,-1,279,368,334,-1,279,312,368,-1,339,335,334,-1,339,93,335,-1,442,531,469,-1,425,531,442,-1,278,102,87,-1,278,103,102,-1,272,468,538,-1,341,468,272,-1,536,340,530,-1,340,536,528,-1,271,527,539,-1,274,527,271,-1,525,529,539,-1,522,529,525,-1,528,460,459,-1,528,536,460,-1,0,461,1,-1,0,524,461,-1,181,524,0,-1,181,178,524,-1,382,520,290,-1,520,382,381,-1,520,529,522,-1,521,529,520,-1,454,512,457,-1,519,512,454,-1,540,18,20,-1,268,18,540,-1,21,487,270,-1,487,21,486,-1,392,445,476,-1,392,390,445,-1,452,191,190,-1,191,452,456,-1,497,453,537,-1,497,541,453,-1,393,486,21,-1,393,447,486,-1,155,394,265,-1,152,394,155,-1,517,444,535,-1,444,517,443,-1,534,451,516,-1,451,534,455,-1,515,20,19,-1,515,261,20,-1,260,15,366,-1,260,16,15,-1,370,23,222,-1,482,23,370,-1,263,20,261,-1,20,263,540,-1,366,413,427,-1,366,365,413,-1,472,255,471,-1,472,256,255,-1,542,234,238,-1,542,235,234,-1,471,542,150,-1,471,255,542,-1,404,39,41,-1,404,250,39,-1,349,218,499,-1,349,197,218,-1,100,249,98,-1,100,248,249,-1,250,42,39,-1,42,250,244,-1,511,99,98,-1,473,99,511,-1,406,98,348,-1,406,511,98,-1,27,151,377,-1,27,149,151,-1,407,237,351,-1,407,196,237,-1,511,431,510,-1,431,511,406,-1,480,478,474,-1,480,479,478,-1,477,186,481,-1,186,477,187,-1,509,50,432,-1,48,50,509,-1,370,223,371,-1,222,223,370,-1,434,232,228,-1,232,434,369,-1,434,229,437,-1,434,228,229,-1,231,49,46,-1,49,231,230,-1,229,375,433,-1,375,229,165,-1,233,164,228,-1,164,233,374,-1,192,485,221,-1,485,192,171,-1,19,357,515,-1,270,357,19,-1,219,499,218,-1,500,499,219,-1,509,168,167,-1,168,509,360,-1,505,258,256,-1,36,258,505,-1,508,502,219,-1,489,502,508,-1,493,483,373,-1,493,492,483,-1,372,493,373,-1,493,372,491,-1,496,36,505,-1,34,36,496,-1,213,506,216,-1,495,506,213,-1,498,215,214,-1,215,498,494,-1,255,235,542,-1,235,255,257,-1,499,245,349,-1,501,245,499,-1,500,494,498,-1,494,500,504,-1,28,250,404,-1,30,250,28,-1,354,188,237,-1,364,188,354,-1,13,220,192,-1,13,355,220,-1,474,510,480,-1,475,510,474,-1,449,519,541,-1,449,518,519,-1,186,364,225,-1,188,364,186,-1,352,187,479,-1,352,185,187,-1,202,496,495,-1,202,212,496,-1,215,203,213,-1,204,203,215,-1,504,201,494,-1,200,201,504,-1,206,490,492,-1,206,205,490,-1,491,207,493,-1,208,207,491,-1,361,209,362,-1,210,209,361,-1,502,200,504,-1,183,200,502,-1,526,461,524,-1,461,526,459,-1,178,522,525,-1,178,180,522,-1,332,283,488,-1,284,283,332,-1,174,487,224,-1,174,356,487,-1,24,6,22,-1,24,259,6,-1,372,166,168,-1,372,371,166,-1,435,166,484,-1,435,47,166,-1,483,217,482,-1,507,217,483,-1,158,153,156,-1,154,153,158,-1,481,347,391,-1,347,481,227,-1,241,405,363,-1,240,405,241,-1,480,431,350,-1,510,431,480,-1,189,478,476,-1,189,474,478,-1,377,242,241,-1,377,239,242,-1,475,456,473,-1,456,475,191,-1,99,512,100,-1,512,99,457,-1,254,150,149,-1,150,254,471,-1,238,150,542,-1,238,151,150,-1,148,321,322,-1,148,146,321,-1,147,54,53,-1,147,320,54,-1,470,9,8,-1,137,9,470,-1,531,543,538,-1,531,426,543,-1,125,132,176,-1,125,133,132,-1,469,538,468,-1,469,531,538,-1,294,324,439,-1,294,177,324,-1,176,126,125,-1,138,126,176,-1,342,539,529,-1,271,539,342,-1,526,539,527,-1,526,525,539,-1,467,458,331,-1,467,466,458,-1,533,424,422,-1,424,533,465,-1,418,422,419,-1,422,418,533,-1,440,323,129,-1,380,323,440,-1,465,118,424,-1,465,119,118,-1,115,278,277,-1,278,115,116,-1,462,108,463,-1,109,108,462,-1,460,317,318,-1,460,535,317,-1,537,455,534,-1,455,537,453,-1,534,96,537,-1,534,94,96,-1,426,95,543,-1,426,97,95,-1,464,346,314,-1,346,464,344,-1,455,190,451,-1,455,452,190,-1,450,541,497,-1,541,450,449,-1,311,269,409,-1,311,313,269,-1,447,448,446,-1,393,448,447,-1,267,535,444,-1,267,317,535,-1,454,541,519,-1,541,454,453,-1,396,93,89,-1,396,335,93,-1,127,441,304,-1,441,127,303,-1,128,86,84,-1,128,127,86,-1,55,54,56,-1,54,55,51,-1,439,308,285,-1,309,308,439,-1,289,324,293,-1,286,324,289,-1,77,81,73,-1,77,401,81,-1,438,307,310,-1,438,329,307,-1,68,59,66,-1,59,68,65,-1,64,69,341,-1,64,63,69,-1,58,57,61,-1,145,57,58,-1,66,54,320,-1,54,66,56,-1,438,80,79,-1,397,80,438,-1,309,288,310,-1,286,288,309,-1,49,236,50,-1,49,194,236,-1,435,45,47,-1,437,45,435,-1,436,369,434,-1,369,436,170,-1,167,48,509,-1,47,48,167,-1,433,46,45,-1,433,231,46,-1,36,432,258,-1,36,35,432,-1,39,44,40,-1,39,42,44,-1,503,348,33,-1,348,503,405,-1,408,406,405,-1,406,408,431,-1,30,29,33,-1,28,29,30,-1,428,540,263,-1,514,540,428,-1,217,508,14,-1,508,217,507,-1,17,508,219,-1,508,17,14,-1,515,411,7,-1,357,411,515,-1,260,264,412,-1,260,262,264,-1,275,543,95,-1,543,275,273,-1,13,411,357,-1,13,12,411,-1,514,268,540,-1,514,410,268,-1,273,538,543,-1,272,538,273,-1,424,421,423,-1,424,118,421,-1,420,383,337,-1,117,383,420,-1,329,402,307,-1,415,402,329,-1,419,281,418,-1,419,72,281,-1,523,345,280,-1,345,523,343,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmc3_Coord',point=[(-7.34432,28.21234,3.11257),(-7.35468,28.06539,3.11598),(-7.29879,28.19503,3.01626),(-7.07127,26.57782,3.28251),(-7.12649,26.5516,3.21163),(-7.07822,26.58303,3.27537),(-7.12313,26.54519,3.21031),(-7.1417,26.63067,3.21018),(-7.08696,28.3185,2.59735),(-7.14705,28.3692,2.6599),(-7.10787,28.31453,2.66773),(-7.06804,26.67181,3.30533),(-7.08871,26.6666,3.29176),(-7.08671,26.73519,3.312),(-7.21352,26.46042,3.08348),(-7.28046,26.56711,3.03382),(-7.23905,26.55771,3.05078),(-7.25762,26.44568,3.08066),(-7.29355,27.09002,3.10238),(-7.21025,26.87294,3.19473),(-7.24774,26.85645,3.13032),(-7.26994,27.10286,3.16693),(-7.09671,26.51726,3.19494),(-7.09094,26.50629,3.19294),(-7.15727,26.51678,3.10871),(-7.15222,26.48867,3.1131),(-7.50633,26.37939,3.40718),(-7.54456,26.43691,3.42712),(-7.51056,26.38626,3.39072),(-7.53785,26.43389,3.40781),(-7.50919,26.3997,3.35117),(-7.53034,26.48463,3.30018),(-7.49556,26.42419,3.31753),(-7.543,26.45726,3.36246),(-7.15208,26.28008,3.38372),(-7.14553,26.3173,3.44283),(-7.18235,26.29413,3.44557),(-7.13666,26.29152,3.37627),(-7.37687,26.27263,3.28003),(-7.43387,26.31845,3.30096),(-7.40796,26.31327,3.26956),(-7.40618,26.28373,3.33223),(-7.43841,26.37983,3.28531),(-7.45953,26.45864,3.24925),(-7.4139,26.38786,3.258),(-7.15022,26.48317,3.52935),(-7.17966,26.4616,3.54189),(-7.11871,26.47539,3.52444),(-7.16058,26.43276,3.54009),(-7.2085,26.4452,3.55396),(-7.19619,26.421,3.56111),(-7.48338,28.62891,2.86044),(-7.47568,28.63003,2.85457),(-7.48693,28.56967,2.81635),(-7.52083,28.56377,2.81316),(-7.48833,28.63153,2.87973),(-7.53076,28.56282,2.83967),(-7.52294,28.56685,2.86022),(-7.53317,28.52147,2.88991),(-7.56262,28.48432,2.83636),(-7.53375,28.49625,2.88906),(-7.55003,28.51644,2.84507),(-7.6119,28.39418,2.81381),(-7.63225,28.4424,2.76063),(-7.62449,28.3912,2.80405),(-7.62207,28.44461,2.77311),(-7.56254,28.51157,2.80997),(-7.5732,28.44039,2.83895),(-7.6336,28.46732,2.72404),(-7.65014,28.43804,2.74159),(-7.15724,28.19485,2.85777),(-7.22985,28.13868,2.95848),(-7.18206,28.10072,2.88817),(-7.21213,28.22634,2.91522),(-7.28574,28.32376,3.00973),(-7.29115,28.33294,3.02126),(-7.29074,28.31728,3.02066),(-7.21308,28.23493,2.90841),(-7.16157,28.20356,2.85077),(-7.19917,28.24501,2.83195),(-7.23947,28.29129,2.86639),(-7.24449,28.26442,2.95682),(-7.48361,28.63728,2.88197),(-7.47577,28.63653,2.86692),(-7.44166,28.64346,2.92566),(-7.48651,28.62971,2.89315),(-7.4399,28.64805,2.91261),(-7.50356,28.14742,2.65956),(-7.47016,28.15264,2.63839),(-7.50218,28.11798,2.67279),(-7.46923,28.12648,2.64599),(-7.53151,28.13676,2.66583),(-7.544,28.03587,2.75066),(-7.53336,28.02769,2.74986),(-7.64992,27.80166,3.02302),(-7.64945,28.00961,2.92635),(-7.62284,27.78468,2.98339),(-7.63291,27.98961,2.8866),(-7.59803,26.58109,3.29377),(-7.63517,26.6684,3.25799),(-7.50731,26.6265,3.17962),(-7.47616,28.24341,2.62806),(-7.48803,28.19148,2.65064),(-7.48397,28.24401,2.62818),(-7.47532,28.21483,2.64306),(-7.45609,28.21569,2.63572),(-7.45273,28.2564,2.62956),(-7.46564,28.27957,2.60869),(-7.45091,28.27836,2.59891),(-7.44351,28.25372,2.6004),(-7.43813,28.22425,2.61223),(-7.44589,28.31745,2.53285),(-7.42749,28.24917,2.54976),(-7.45214,28.30608,2.55054),(-7.40592,28.24616,2.52865),(-7.48918,28.31919,2.55383),(-7.47922,28.30923,2.57184),(-7.33809,28.0122,2.61216),(-7.30459,28.01013,2.62148),(-7.3303,27.96449,2.67489),(-7.35111,27.9684,2.67444),(-7.277,28.30349,2.44766),(-7.27636,28.33256,2.45714),(-7.2581,28.30278,2.45092),(-7.34539,28.42412,2.68975),(-7.28179,28.43785,2.75955),(-7.25025,28.42199,2.72437),(-7.4029,28.65133,2.92508),(-7.40206,28.64729,2.94307),(-7.38896,28.64323,2.93062),(-7.33422,28.53289,2.86749),(-7.32067,28.51459,2.87671),(-7.30396,28.4515,2.80429),(-7.31274,28.45621,2.79538),(-7.49556,28.34517,2.56937),(-7.61195,28.36999,2.61628),(-7.5986,28.38927,2.61838),(-7.14927,28.37821,2.63522),(-7.23868,28.41384,2.73868),(-7.66539,28.4488,2.64722),(-7.69238,28.44615,2.66512),(-7.60288,28.46419,2.7191),(-7.43056,28.34139,2.52783),(-7.51056,28.56863,2.90658),(-7.52278,28.52052,2.91401),(-7.51459,28.567,2.88567),(-7.42679,28.59035,2.84661),(-7.50007,28.47718,2.76093),(-7.41109,28.53177,2.80741),(-7.47568,26.39159,3.45959),(-7.44786,26.39256,3.49106),(-7.47056,26.42839,3.49664),(-7.29445,27.15781,3.34297),(-7.29709,26.93987,3.48413),(-7.23575,26.93901,3.43053),(-7.35946,27.17329,3.41737),(-7.25549,26.78319,3.54104),(-7.19719,26.77884,3.49027),(-7.20782,26.83752,3.47287),(-7.25742,26.50698,3.53628),(-7.24354,26.53248,3.53017),(-7.26442,26.52559,3.53909),(-7.22953,26.50766,3.52604),(-7.23648,26.50203,3.52806),(-7.22207,26.56007,3.52641),(-7.21617,26.53237,3.52251),(-7.06064,26.47697,3.43353),(-7.09725,26.43064,3.4788),(-7.08528,26.36718,3.40331),(-7.04562,26.55854,3.29697),(-7.11636,26.68771,3.51849),(-7.04652,26.6805,3.42278),(-7.10421,26.73303,3.47951),(-7.15121,26.77034,3.46373),(-7.18551,26.84718,3.43186),(-7.27691,28.4211,2.85248),(-7.27243,28.4316,2.77176),(-7.23665,28.38268,2.80566),(-7.37526,28.31919,3.1231),(-7.33729,28.39449,3.08415),(-7.37288,28.39407,3.09836),(-7.33458,28.31805,3.0989),(-7.143,26.29335,3.2845),(-7.15901,26.29528,3.24669),(-7.14753,26.30267,3.24635),(-7.35096,26.56682,3.5612),(-7.32197,26.65307,3.58493),(-7.36353,26.65524,3.54707),(-7.32803,26.57138,3.57479),(-7.57817,26.84977,3.35746),(-7.61398,27.11741,3.28265),(-7.61712,26.82941,3.32112),(-7.04876,26.68504,3.32927),(-7.33578,26.4707,3.58227),(-7.27761,26.46182,3.57443),(-7.27262,26.4757,3.55221),(-7.33021,26.49873,3.56326),(-7.3517,26.44587,3.11724),(-7.41354,26.47123,3.17932),(-7.373,26.49363,3.12303),(-7.17063,26.28534,3.25202),(-7.1773,26.27714,3.26438),(-7.17543,26.26812,3.31636),(-7.18445,26.26612,3.29726),(-7.1844,26.2706,3.27743),(-7.1356,26.30868,3.25428),(-7.12568,26.31271,3.27042),(-7.12196,26.31216,3.28224),(-7.11899,26.30974,3.29845),(-7.12216,26.30344,3.31274),(-7.12861,26.2941,3.32647),(-7.14268,26.28522,3.33473),(-7.15915,26.27475,3.33154),(-7.23003,26.24561,3.30986),(-7.31225,26.24894,3.27229),(-7.22911,26.25469,3.27204),(-7.29078,26.24365,3.34297),(-7.1475,26.45883,3.12574),(-7.30114,26.41178,3.09741),(-7.23083,26.33727,3.14175),(-7.06992,26.74913,3.40884),(-7.03608,26.58869,3.34613),(-7.04143,26.52677,3.29314),(-7.03826,26.52586,3.36117),(-7.22354,26.93013,3.4016),(-7.27588,26.66176,3.57739),(-7.23611,26.67695,3.55605),(-7.28385,26.77944,3.56953),(-7.19795,26.59211,3.52175),(-7.17761,26.53183,3.5247),(-7.22236,26.46637,3.54178),(-7.20119,26.47762,3.53362),(-7.18442,26.69539,3.51648),(-7.25014,26.57954,3.54555),(-7.33166,26.45184,3.58797),(-7.31571,26.42656,3.58437),(-7.28412,26.44201,3.58375),(-7.33235,26.51283,3.55754),(-7.3997,26.45844,3.55856),(-7.49641,26.46807,3.49951),(-7.55267,26.51531,3.42877),(-7.54558,26.48954,3.4519),(-7.49904,26.48181,3.49311),(-7.49641,26.50608,3.47162),(-7.45818,26.39499,3.30378),(-7.39161,26.33268,3.22788),(-7.3992,26.41594,3.2201),(-7.43469,26.5131,3.17914),(-7.47852,26.53817,3.20814),(-7.53352,26.52515,3.26295),(-7.46777,26.34634,3.33657),(-7.39206,26.70951,3.10532),(-7.41488,26.55016,3.15095),(-7.45484,26.32012,3.38158),(-7.42699,26.31774,3.42815),(-7.33115,26.3491,3.53608),(-7.27984,26.30272,3.49567),(-7.27581,26.37603,3.56792),(-7.22568,26.33277,3.51923),(-7.18192,26.54442,3.12097),(-7.2451,26.60432,3.06916),(-7.22344,26.73095,3.12734),(-7.25583,26.67016,3.08516),(-7.26655,26.73597,3.10115),(-7.19988,26.6233,3.12944),(-7.37701,27.37013,3.35045),(-7.40035,27.16632,3.43012),(-7.41577,27.36571,3.37366),(-7.3247,27.08234,3.08328),(-7.32241,27.27961,3.05913),(-7.18835,26.89074,3.2577),(-7.59284,28.23606,2.93397),(-7.66254,28.22272,2.84488),(-7.65233,28.11471,2.89339),(-7.60801,28.13887,2.96472),(-7.65197,28.11094,2.89508),(-7.60837,28.438,2.65883),(-7.52261,28.22615,2.61898),(-7.50133,28.23616,2.62251),(-7.36345,27.90074,2.7471),(-7.30465,28.00973,3.01157),(-7.23442,28.05962,2.94137),(-7.25002,28.09378,2.97787),(-7.09667,28.16565,2.71949),(-7.07434,28.24767,2.65092),(-7.10327,28.19131,2.76892),(-7.20573,28.33483,2.8472),(-7.2616,28.32322,2.91458),(-7.23424,28.30619,2.85765),(-7.25218,28.36261,2.90206),(-7.38578,28.53075,3.01893),(-7.36607,28.52535,3.00322),(-7.30502,28.48012,2.88368),(-7.25375,28.3731,2.89674),(-7.20132,28.3694,2.76421),(-7.40978,28.41204,2.65067),(-7.41236,28.42628,2.69029),(-7.38637,28.40316,2.61582),(-7.32438,28.40162,2.59746),(-7.28019,28.40138,2.62441),(-7.33277,28.46259,2.77923),(-7.37392,28.46024,2.74727),(-7.40236,28.4444,2.71718),(-7.39985,28.64417,2.91091),(-7.44101,28.64487,2.88656),(-7.51786,28.41819,2.6889),(-7.49583,28.37377,2.60161),(-7.11373,28.18898,2.78553),(-7.11035,28.19799,2.7778),(-7.16132,28.30331,2.81442),(-7.19719,28.25737,2.82618),(-7.39338,27.43744,2.98887),(-7.37418,27.72458,2.8653),(-7.32986,27.44689,3.01074),(-7.31174,27.74345,2.89612),(-7.38707,27.56509,3.28974),(-7.37995,27.86745,3.17891),(-7.42842,27.56994,3.31233),(-7.41759,27.86989,3.21236),(-7.57566,28.338,2.88993),(-7.5589,28.49751,2.76957),(-7.37578,28.59961,2.88363),(-7.35792,28.53729,2.84428),(-7.35757,28.59037,2.90453),(-7.2055,28.34526,2.8396),(-7.28529,28.33443,3.01199),(-7.28264,28.38001,3.01573),(-7.13245,28.18231,2.80433),(-7.12548,28.16763,2.80389),(-7.11797,28.17993,2.79315),(-7.14095,28.30237,2.52664),(-7.24917,28.22929,2.47427),(-7.14496,28.2342,2.55395),(-7.42642,27.98924,2.69692),(-7.45467,27.91972,2.77832),(-7.46355,28.00438,2.71534),(-7.40632,28.15624,2.57418),(-7.40897,28.1048,2.60617),(-7.58508,28.00655,2.81779),(-7.53815,27.94959,2.83027),(-7.616,28.03502,3.00847),(-7.66181,28.3486,2.77649),(-7.58118,28.32037,2.90505),(-7.27903,27.78408,2.98078),(-7.24133,27.94434,2.88239),(-7.24433,27.95376,2.90822),(-7.2849,27.7692,2.94881),(-7.3209,26.9458,3.51791),(-7.56755,26.5086,3.33271),(-7.37258,26.36534,3.17876),(-7.51494,26.5583,3.44764),(-7.40325,26.50932,3.52304),(-7.41762,26.55473,3.51402),(-7.49844,26.5155,3.46617),(-7.29258,26.52499,3.55646),(-7.11375,26.79241,3.38291),(-7.15102,26.8363,3.35509),(-7.13512,26.77153,3.28647),(-7.36597,26.27241,3.38344),(-7.32168,26.53312,3.0518),(-7.12076,26.33367,3.43439),(-7.12124,26.30295,3.36882),(-7.10687,26.3189,3.34207),(-7.55174,26.45814,3.41651),(-7.28142,26.57729,3.56776),(-7.33414,26.58263,3.06164),(-7.29079,26.61284,3.05395),(-7.55561,27.76335,2.93742),(-7.46281,27.7364,2.89762),(-7.16023,26.69335,3.51603),(-7.04408,26.50106,3.29021),(-7.0419,26.49351,3.36249),(-7.0668,26.39054,3.34702),(-7.0781,26.40166,3.2826),(-7.24629,26.55359,3.53524),(-7.22132,26.51701,3.52373),(-7.40088,26.47183,3.5528),(-7.54075,26.47337,3.46286),(-7.68441,28.42673,2.64293),(-7.15109,28.32785,2.52436),(-7.34694,28.55511,2.93201),(-7.44338,28.58953,2.96934),(-7.39313,28.58838,2.98213),(-7.41159,28.05344,2.63808),(-7.28712,28.39761,3.01046),(-7.33205,28.50888,2.95196),(-7.41735,28.17856,2.58759),(-7.47251,28.28969,2.59736),(-7.46593,28.1901,2.63082),(-7.43164,28.20997,2.60453),(-7.43296,27.15737,3.42713),(-7.3573,26.94309,3.52434),(-7.39602,26.92497,3.49413),(-7.29137,27.29469,3.11031),(-7.31774,27.34818,3.27279),(-7.33877,27.53014,3.2064),(-7.46923,28.08446,2.66844),(-7.23757,28.29777,2.86238),(-7.26237,28.31527,2.91799),(-7.25886,28.30767,2.92231),(-7.28031,28.31535,2.99746),(-7.24292,28.2734,2.94884),(-7.10839,28.18144,2.77733),(-7.48622,28.57954,2.93758),(-7.45844,26.32429,3.36854),(-7.56639,26.49997,3.38984),(-7.58648,26.54707,3.36251),(-7.40075,26.50138,3.52566),(-7.55617,26.52417,3.42129),(-7.38555,27.26453,3.03362),(-7.37083,27.07389,3.0741),(-7.10325,26.66573,3.28111),(-7.18724,26.55676,3.12365),(-7.3631,26.64607,3.08348),(-7.60676,28.05565,2.7896),(-7.11329,28.17253,2.78429),(-7.12019,28.16027,2.79352),(-7.11939,28.12845,2.75209),(-7.2039,28.0233,2.87482),(-7.16768,28.07896,2.84826),(-7.32272,28.06323,2.57263),(-7.28984,28.05969,2.58285),(-7.16211,28.06177,2.80968),(-7.19234,28.08081,2.66832),(-7.21614,28.02974,2.70815),(-7.62187,28.16184,2.72235),(-7.65601,28.07983,2.83062),(-7.30629,26.67468,3.07188),(-7.32178,26.73652,3.0898),(-7.21602,28.37461,2.57234),(-7.29868,28.37273,2.52186),(-7.56454,26.56558,3.40328),(-7.17384,26.36762,3.51472),(-7.18216,26.49289,3.5263),(-7.15557,26.60423,3.52538),(-7.11268,26.52371,3.52292),(-7.11304,26.61626,3.52687),(-7.14509,26.52785,3.52532),(-7.1989,28.25083,2.82959),(-7.1592,28.31123,2.80719),(-7.37654,28.58086,2.97266),(-7.43802,28.63811,2.87514),(-7.62556,28.26241,2.67072),(-7.53721,27.3356,3.31596),(-7.45269,27.35373,3.37349),(-7.52428,27.14377,3.36803),(-7.29535,27.48279,3.10143),(-7.27677,27.31172,3.15929),(-7.30313,27.46605,3.05828),(-7.46512,27.2672,3.05519),(-7.47472,27.44711,3.01185),(-7.61769,27.31585,3.23791),(-7.64675,27.09384,3.22804),(-7.62221,27.27966,3.14442),(-7.61553,27.07858,3.18586),(-7.64739,27.29268,3.18487),(-7.65187,26.81119,3.27093),(-7.62708,26.80153,3.22687),(-7.28407,28.23023,2.46456),(-7.45797,28.07587,3.15163),(-7.46729,27.86347,3.21341),(-7.4021,28.07853,3.14941),(-7.43901,28.25242,2.58617),(-7.4528,28.28987,2.58403),(-7.27922,27.91839,2.80771),(-7.24814,27.97576,2.75828),(-7.30733,28.11436,2.53302),(-7.27508,28.10934,2.54415),(-7.70492,28.34421,2.72027),(-7.69956,28.3285,2.69422),(-7.10253,28.33868,2.58726),(-7.39681,26.32732,3.47624),(-7.33142,26.28061,3.44327),(-7.65348,26.69141,3.29938),(-7.55639,26.72597,3.39101),(-7.60574,26.71788,3.35283),(-7.47583,26.89181,3.4396),(-7.37581,26.7548,3.52908),(-7.45285,26.74291,3.473),(-7.43668,26.64809,3.49227),(-7.53369,26.63339,3.42094),(-7.32539,26.7742,3.57561),(-7.08917,26.48622,3.19535),(-7.10185,26.40052,3.22537),(-7.04893,26.53096,3.43473),(-7.0451,26.60866,3.42958),(-7.25215,27.12387,3.22429),(-7.19386,26.90587,3.31649),(-7.16854,28.13201,2.62843),(-7.15633,26.31791,3.21095),(-7.13333,26.32935,3.22652),(-7.10062,26.33131,3.31385),(-7.11397,26.33704,3.25843),(-7.10661,26.33594,3.28188),(-7.22016,26.26788,3.24474),(-7.21141,26.24979,3.34911),(-7.18302,26.26129,3.37569),(-7.5578,27.46323,3.04991),(-7.29949,26.27172,3.22124),(-7.32655,26.32926,3.15709),(-7.27058,26.29718,3.17344),(-7.35174,26.29467,3.21624),(-7.17895,26.30334,3.21166),(-7.56313,26.49444,3.38612),(-7.20203,26.28362,3.22213),(-7.22259,26.26789,3.43348),(-7.26507,26.24759,3.39041),(-7.13674,26.3879,3.16874),(-7.18546,26.36722,3.13843),(-7.14015,26.38775,3.50461),(-7.58275,26.62867,3.37976),(-7.61608,26.60468,3.33287),(-7.52057,26.82061,3.16064),(-7.43313,26.8488,3.12087),(-7.34481,26.84937,3.099),(-7.17097,26.7424,3.20109),(-7.62089,27.52112,3.18778),(-7.54924,27.54283,3.25446),(-7.45282,27.07486,3.09024),(-7.53105,27.07286,3.13325),(-7.44069,28.52967,3.00876),(-7.49036,28.52726,2.96959),(-7.43911,28.38585,3.09144),(-7.32881,27.83481,3.08188),(-7.38809,28.22131,3.1383),(-7.44396,28.31199,3.11789),(-7.45127,28.20598,3.13448),(-7.53357,28.17067,3.05893),(-7.54559,28.05818,3.08759),(-7.50984,28.39076,3.0264),(-7.62111,27.82565,3.08822),(-7.69128,28.19643,2.76276),(-7.41243,28.36999,2.55175),(-7.20057,28.01284,2.84322),(-7.64749,27.49891,3.13603),(-7.47155,27.5649,3.3106),(-7.55157,27.85534,3.16116),(-7.62024,27.48153,3.09349),(-7.70098,28.21425,2.79324),(-7.52066,28.27782,3.05115),(-7.29359,26.85346,3.10622),(-7.55026,27.271,3.09549),(-7.37037,26.40916,3.55626),(-7.66864,28.09684,2.8697)]))),
        Shape(DEF='rmc4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,1),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmc4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,4,7,-1,8,4,9,-1,10,4,11,-1,12,4,13,-1,14,15,16,-1,17,15,18,-1,19,15,20,-1,21,15,22,-1,23,15,24,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,36,37,38,-1,39,40,32,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,17,-1,17,18,49,-1,51,52,53,-1,54,55,51,-1,44,56,57,-1,57,58,44,-1,59,60,61,-1,62,63,64,-1,62,60,63,-1,65,66,67,-1,68,69,70,-1,71,72,73,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,78,81,79,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,88,91,89,-1,90,89,92,-1,93,94,95,-1,93,86,94,-1,96,92,89,-1,89,97,96,-1,98,99,100,-1,101,102,103,-1,91,104,105,-1,91,106,104,-1,107,63,108,-1,63,59,108,-1,109,110,111,-1,109,112,110,-1,113,114,115,-1,115,116,113,-1,117,118,119,-1,117,120,118,-1,121,122,123,-1,121,124,122,-1,125,126,127,-1,125,128,126,-1,129,130,131,-1,131,132,129,-1,133,132,131,-1,131,134,133,-1,135,136,137,-1,135,138,136,-1,109,139,128,-1,109,111,139,-1,128,125,109,-1,140,26,141,-1,140,142,26,-1,143,144,0,-1,0,145,143,-1,146,147,148,-1,146,149,147,-1,150,151,152,-1,150,153,151,-1,154,155,156,-1,155,157,156,-1,158,159,160,-1,158,161,159,-1,162,163,164,-1,163,165,164,-1,166,167,168,-1,168,169,166,-1,170,103,171,-1,103,172,171,-1,173,174,175,-1,176,177,178,-1,177,179,178,-1,180,181,182,-1,183,184,185,-1,183,186,184,-1,182,187,134,-1,134,131,182,-1,188,189,190,-1,188,178,189,-1,191,189,192,-1,189,179,192,-1,193,194,195,-1,195,196,193,-1,197,198,199,-1,200,201,202,-1,203,204,205,-1,53,206,199,-1,53,207,206,-1,160,208,209,-1,160,210,208,-1,84,211,82,-1,94,212,213,-1,211,157,214,-1,214,102,211,-1,215,216,217,-1,216,218,217,-1,171,174,170,-1,170,174,169,-1,169,174,166,-1,219,48,220,-1,221,48,47,-1,222,48,223,-1,219,224,48,-1,110,225,111,-1,225,192,111,-1,226,227,228,-1,229,230,228,-1,231,232,228,-1,233,234,228,-1,128,235,126,-1,128,177,235,-1,181,187,182,-1,25,236,28,-1,237,238,239,-1,240,241,242,-1,242,241,243,-1,244,245,246,-1,2,145,0,-1,247,245,248,-1,245,249,248,-1,1,250,2,-1,247,2,138,-1,251,252,147,-1,150,253,254,-1,150,146,253,-1,254,255,256,-1,87,257,258,-1,84,259,156,-1,156,259,260,-1,260,154,156,-1,52,51,217,-1,261,260,256,-1,261,262,260,-1,263,241,264,-1,265,206,207,-1,265,266,206,-1,267,268,163,-1,267,161,268,-1,163,162,267,-1,269,162,270,-1,269,267,162,-1,271,272,273,-1,273,263,271,-1,54,78,80,-1,274,69,50,-1,49,274,50,-1,49,275,274,-1,276,277,278,-1,276,279,277,-1,280,281,68,-1,280,282,281,-1,283,284,285,-1,283,286,284,-1,287,198,197,-1,287,288,198,-1,289,290,291,-1,292,293,294,-1,35,295,33,-1,296,297,298,-1,297,299,298,-1,300,301,31,-1,300,296,301,-1,301,302,303,-1,302,304,303,-1,305,294,293,-1,32,306,39,-1,42,41,307,-1,308,307,309,-1,310,311,312,-1,311,313,314,-1,315,316,317,-1,315,318,316,-1,319,320,321,-1,321,306,319,-1,307,322,323,-1,323,309,307,-1,324,4,3,-1,325,13,324,-1,325,323,13,-1,326,6,327,-1,326,5,6,-1,318,314,316,-1,318,312,314,-1,314,312,311,-1,311,328,313,-1,308,329,307,-1,329,330,307,-1,30,32,40,-1,29,331,32,-1,331,306,32,-1,332,330,333,-1,333,334,332,-1,297,335,299,-1,336,302,298,-1,336,337,302,-1,338,34,339,-1,34,340,339,-1,34,33,340,-1,33,292,340,-1,292,33,341,-1,342,343,277,-1,279,282,280,-1,279,276,282,-1,288,287,344,-1,344,345,288,-1,208,197,209,-1,208,289,197,-1,275,49,35,-1,346,347,348,-1,346,349,347,-1,350,349,346,-1,350,351,349,-1,69,274,70,-1,24,15,14,-1,342,352,343,-1,266,353,158,-1,266,265,353,-1,199,206,197,-1,354,79,81,-1,51,53,54,-1,355,272,271,-1,356,357,270,-1,270,162,356,-1,164,356,162,-1,52,207,53,-1,52,358,207,-1,207,359,265,-1,207,358,359,-1,360,361,225,-1,356,164,143,-1,164,362,143,-1,262,154,260,-1,358,217,218,-1,358,52,217,-1,85,87,258,-1,153,256,260,-1,144,143,362,-1,362,253,144,-1,152,363,185,-1,1,146,148,-1,136,138,2,-1,145,364,143,-1,237,365,118,-1,237,366,365,-1,176,239,367,-1,367,368,176,-1,235,177,369,-1,192,179,177,-1,370,371,62,-1,231,228,234,-1,229,228,232,-1,226,228,230,-1,233,228,227,-1,107,231,372,-1,107,232,231,-1,59,225,110,-1,59,61,225,-1,177,139,111,-1,177,128,139,-1,111,192,177,-1,224,373,48,-1,222,46,48,-1,221,220,48,-1,166,174,173,-1,105,104,101,-1,216,214,218,-1,206,209,197,-1,38,343,36,-1,289,287,197,-1,263,374,271,-1,375,178,188,-1,375,176,178,-1,135,376,133,-1,377,180,182,-1,182,378,377,-1,379,122,224,-1,378,130,141,-1,184,149,152,-1,152,185,184,-1,28,141,26,-1,28,378,141,-1,135,137,376,-1,263,273,241,-1,368,177,176,-1,368,369,177,-1,178,179,189,-1,171,175,174,-1,169,103,170,-1,169,168,103,-1,158,160,266,-1,380,355,381,-1,381,382,380,-1,262,155,154,-1,262,359,155,-1,150,152,149,-1,149,146,150,-1,151,153,260,-1,260,257,151,-1,148,147,252,-1,252,58,148,-1,257,259,258,-1,257,260,259,-1,86,83,94,-1,383,186,384,-1,383,385,186,-1,135,246,138,-1,127,126,386,-1,115,387,116,-1,133,134,246,-1,246,135,133,-1,127,388,389,-1,127,386,388,-1,124,120,117,-1,124,121,120,-1,60,59,63,-1,373,223,48,-1,390,242,249,-1,167,97,89,-1,214,216,172,-1,167,91,168,-1,167,89,91,-1,168,101,103,-1,168,105,101,-1,172,215,391,-1,172,216,215,-1,372,92,96,-1,60,371,61,-1,60,62,371,-1,392,66,65,-1,392,393,66,-1,374,195,194,-1,64,63,96,-1,275,394,274,-1,105,168,91,-1,58,57,148,-1,51,370,217,-1,51,55,370,-1,282,276,24,-1,24,14,282,-1,374,263,190,-1,264,241,240,-1,240,395,264,-1,366,396,365,-1,396,114,365,-1,56,44,397,-1,44,43,397,-1,205,398,317,-1,317,203,205,-1,329,399,400,-1,329,401,399,-1,402,290,289,-1,3,325,324,-1,3,403,325,-1,322,307,41,-1,41,404,322,-1,41,40,404,-1,305,405,406,-1,331,407,306,-1,31,30,300,-1,291,287,289,-1,291,344,287,-1,22,15,23,-1,20,15,21,-1,18,15,19,-1,16,15,17,-1,13,4,324,-1,11,4,12,-1,9,4,10,-1,7,4,8,-1,5,4,6,-1,193,196,408,-1,361,192,225,-1,361,191,192,-1,144,1,0,-1,191,408,196,-1,408,191,361,-1,409,293,292,-1,409,410,293,-1,406,407,331,-1,406,405,407,-1,37,411,412,-1,36,411,37,-1,413,411,414,-1,411,413,412,-1,352,67,415,-1,342,67,352,-1,416,11,404,-1,10,11,416,-1,40,332,30,-1,42,332,40,-1,404,12,322,-1,11,12,404,-1,8,321,320,-1,9,321,8,-1,290,400,399,-1,400,290,402,-1,291,399,417,-1,399,291,290,-1,309,314,313,-1,309,418,314,-1,398,202,419,-1,202,398,205,-1,420,421,422,-1,420,201,421,-1,331,303,406,-1,303,331,29,-1,309,328,308,-1,313,328,309,-1,316,203,317,-1,316,423,203,-1,114,424,365,-1,114,113,424,-1,396,395,240,-1,395,396,366,-1,190,264,188,-1,190,263,264,-1,23,276,278,-1,24,276,23,-1,282,16,281,-1,16,282,14,-1,19,425,426,-1,20,425,19,-1,21,38,37,-1,22,38,21,-1,427,275,35,-1,427,394,275,-1,195,190,189,-1,190,195,374,-1,428,328,311,-1,428,401,328,-1,68,284,286,-1,68,70,284,-1,350,72,429,-1,346,72,350,-1,430,61,371,-1,430,431,61,-1,88,432,433,-1,88,434,432,-1,391,98,100,-1,391,215,98,-1,102,172,103,-1,102,214,172,-1,212,104,106,-1,212,82,104,-1,242,396,240,-1,396,242,390,-1,117,373,124,-1,117,223,373,-1,435,116,387,-1,116,435,436,-1,379,437,438,-1,379,439,437,-1,372,388,92,-1,389,388,372,-1,397,440,56,-1,441,440,397,-1,366,375,395,-1,375,366,237,-1,183,384,186,-1,183,442,384,-1,443,93,95,-1,443,444,93,-1,86,84,83,-1,86,85,84,-1,58,45,44,-1,58,252,45,-1,85,259,84,-1,85,258,259,-1,427,445,446,-1,338,445,427,-1,426,35,49,-1,426,295,35,-1,382,447,448,-1,382,381,447,-1,449,450,451,-1,450,449,448,-1,355,452,272,-1,452,355,380,-1,243,273,453,-1,243,241,273,-1,253,255,254,-1,362,255,253,-1,100,175,391,-1,175,100,173,-1,115,249,387,-1,249,115,390,-1,230,108,112,-1,230,229,108,-1,125,226,109,-1,125,227,226,-1,238,367,239,-1,238,454,367,-1,378,236,377,-1,236,378,28,-1,455,456,457,-1,455,376,456,-1,458,459,460,-1,458,461,459,-1,433,462,213,-1,433,432,462,-1,459,384,442,-1,459,457,384,-1,182,130,378,-1,182,131,130,-1,236,235,369,-1,236,25,235,-1,121,181,454,-1,121,123,181,-1,132,376,455,-1,376,132,133,-1,435,244,437,-1,244,435,245,-1,271,194,355,-1,271,374,194,-1,210,159,463,-1,210,160,159,-1,464,415,465,-1,464,414,415,-1,466,467,468,-1,469,467,466,-1,38,277,343,-1,278,277,38,-1,470,66,471,-1,66,470,67,-1,472,473,393,-1,472,474,473,-1,283,475,286,-1,283,472,475,-1,456,137,441,-1,456,376,137,-1,460,442,443,-1,459,442,460,-1,476,142,434,-1,476,477,142,-1,140,461,458,-1,461,140,129,-1,436,221,116,-1,436,220,221,-1,46,119,424,-1,119,46,222,-1,124,224,122,-1,373,224,124,-1,127,227,125,-1,127,233,227,-1,229,107,108,-1,229,232,107,-1,231,389,372,-1,231,234,389,-1,62,98,370,-1,64,98,62,-1,99,98,64,-1,476,92,388,-1,90,92,476,-1,118,238,237,-1,238,118,120,-1,123,187,181,-1,123,438,187,-1,114,390,115,-1,390,114,396,-1,440,2,250,-1,440,136,2,-1,148,250,1,-1,148,57,250,-1,184,385,251,-1,184,186,385,-1,251,149,184,-1,251,147,149,-1,363,151,478,-1,363,152,151,-1,478,257,87,-1,257,478,151,-1,358,155,359,-1,358,218,155,-1,357,143,364,-1,357,356,143,-1,431,225,61,-1,431,360,225,-1,165,268,261,-1,165,163,268,-1,262,265,359,-1,262,353,265,-1,380,270,452,-1,380,269,270,-1,54,430,55,-1,430,54,80,-1,361,354,408,-1,361,360,354,-1,53,479,54,-1,53,199,479,-1,81,480,354,-1,480,81,75,-1,266,209,206,-1,160,209,266,-1,481,161,267,-1,481,159,161,-1,269,382,482,-1,382,269,380,-1,193,483,484,-1,193,480,483,-1,425,412,485,-1,412,425,37,-1,351,70,274,-1,350,70,351,-1,71,429,72,-1,486,429,71,-1,348,483,77,-1,347,483,348,-1,349,487,347,-1,488,487,349,-1,274,489,351,-1,489,274,394,-1,394,446,489,-1,394,427,446,-1,488,490,487,-1,488,491,490,-1,73,492,493,-1,73,74,492,-1,494,486,71,-1,494,495,486,-1,494,288,345,-1,494,493,288,-1,344,496,345,-1,344,497,496,-1,289,498,402,-1,498,289,208,-1,400,330,329,-1,400,333,330,-1,499,497,500,-1,497,499,496,-1,285,495,501,-1,486,495,285,-1,472,502,474,-1,472,283,502,-1,502,499,503,-1,502,501,499,-1,473,504,505,-1,473,474,504,-1,506,473,505,-1,506,471,473,-1,507,471,506,-1,507,470,471,-1,465,67,470,-1,415,67,465,-1,341,409,292,-1,341,413,409,-1,338,35,34,-1,427,35,338,-1,446,508,491,-1,508,446,445,-1,509,292,294,-1,509,340,292,-1,336,339,337,-1,510,339,336,-1,491,447,490,-1,447,491,508,-1,304,337,509,-1,337,304,302,-1,299,336,298,-1,451,336,299,-1,449,481,482,-1,481,449,335,-1,335,159,481,-1,159,335,463,-1,334,498,511,-1,334,333,498,-1,297,463,335,-1,463,297,512,-1,30,334,300,-1,332,334,30,-1,506,513,507,-1,506,315,513,-1,505,315,506,-1,315,505,318,-1,500,503,499,-1,503,500,310,-1,318,504,312,-1,505,504,318,-1,422,305,514,-1,405,305,422,-1,202,204,200,-1,202,205,204,-1,421,306,407,-1,421,319,306,-1,42,330,332,-1,307,330,42,-1,327,200,204,-1,515,200,327,-1,325,423,418,-1,423,325,403,-1,423,326,203,-1,423,403,326,-1,7,320,515,-1,320,7,8,-1,12,323,322,-1,323,12,13,-1,403,5,326,-1,5,403,3,-1,9,416,321,-1,416,9,10,-1,6,515,327,-1,515,6,7,-1,323,418,309,-1,418,323,325,-1,306,416,39,-1,306,321,416,-1,515,319,200,-1,319,515,320,-1,513,419,469,-1,513,398,419,-1,200,421,201,-1,421,200,319,-1,467,422,514,-1,422,467,420,-1,406,304,305,-1,303,304,406,-1,503,312,504,-1,503,310,312,-1,428,310,500,-1,428,311,310,-1,469,507,513,-1,466,507,469,-1,514,468,467,-1,514,410,468,-1,305,509,294,-1,305,304,509,-1,301,29,31,-1,301,303,29,-1,511,300,334,-1,511,512,300,-1,208,511,498,-1,511,208,210,-1,300,297,296,-1,300,512,297,-1,301,298,302,-1,296,298,301,-1,451,335,449,-1,451,299,335,-1,482,448,449,-1,482,382,448,-1,510,451,450,-1,510,336,451,-1,340,337,339,-1,340,509,337,-1,381,490,447,-1,381,516,490,-1,410,464,468,-1,410,409,464,-1,409,414,464,-1,413,414,409,-1,466,470,507,-1,465,470,466,-1,65,279,392,-1,279,65,277,-1,502,504,474,-1,502,503,504,-1,501,283,285,-1,502,283,501,-1,496,501,495,-1,496,499,501,-1,500,417,428,-1,497,417,500,-1,333,402,498,-1,402,333,400,-1,291,497,344,-1,497,291,417,-1,345,495,494,-1,495,345,496,-1,493,198,288,-1,493,492,198,-1,71,493,494,-1,73,493,71,-1,516,487,490,-1,484,487,516,-1,489,491,488,-1,489,446,491,-1,351,488,349,-1,489,488,351,-1,347,484,483,-1,487,484,347,-1,486,284,429,-1,486,285,284,-1,426,485,295,-1,426,425,485,-1,68,50,69,-1,50,68,281,-1,75,483,480,-1,77,483,75,-1,516,355,194,-1,516,381,355,-1,267,482,481,-1,482,267,269,-1,479,78,54,-1,479,76,78,-1,408,480,193,-1,408,354,480,-1,79,360,431,-1,360,79,354,-1,452,357,453,-1,270,357,452,-1,261,353,262,-1,261,268,353,-1,255,261,256,-1,255,165,261,-1,453,364,243,-1,453,357,364,-1,55,371,370,-1,55,430,371,-1,157,84,156,-1,157,211,84,-1,444,478,93,-1,444,363,478,-1,256,150,254,-1,150,256,153,-1,45,251,385,-1,251,45,252,-1,183,363,444,-1,185,363,183,-1,250,56,440,-1,57,56,250,-1,138,245,247,-1,245,138,246,-1,2,248,145,-1,2,247,248,-1,243,145,248,-1,243,364,145,-1,245,387,249,-1,435,387,245,-1,248,242,243,-1,242,248,249,-1,187,246,134,-1,187,244,246,-1,454,120,121,-1,454,238,120,-1,395,188,264,-1,395,375,188,-1,477,388,386,-1,476,388,477,-1,96,99,64,-1,96,97,99,-1,389,233,127,-1,233,389,234,-1,224,439,379,-1,439,224,219,-1,222,117,119,-1,117,222,223,-1,116,47,113,-1,116,221,47,-1,219,436,439,-1,436,219,220,-1,434,458,432,-1,142,458,434,-1,458,142,140,-1,91,433,106,-1,433,91,88,-1,215,370,98,-1,215,217,370,-1,218,157,155,-1,214,157,218,-1,82,101,104,-1,102,82,211,-1,102,101,82,-1,462,443,95,-1,460,443,462,-1,383,457,456,-1,383,384,457,-1,397,456,441,-1,43,456,397,-1,43,383,456,-1,492,199,198,-1,492,479,199,-1,479,74,76,-1,492,74,479,-1,279,475,392,-1,280,475,279,-1,471,393,473,-1,393,471,66,-1,315,398,513,-1,398,315,317,-1,203,327,204,-1,203,326,327,-1,469,420,467,-1,419,420,469,-1,468,465,466,-1,468,464,465,-1,463,511,210,-1,512,511,463,-1,484,194,193,-1,484,516,194,-1,196,189,191,-1,196,195,189,-1,187,437,244,-1,187,438,437,-1,377,367,180,-1,367,377,368,-1,25,126,235,-1,25,27,126,-1,455,129,132,-1,129,455,461,-1,460,432,458,-1,462,432,460,-1,457,461,455,-1,459,461,457,-1,369,377,236,-1,369,368,377,-1,180,454,181,-1,367,454,180,-1,226,112,109,-1,226,230,112,-1,391,171,172,-1,171,391,175,-1,166,100,167,-1,173,100,166,-1,362,165,255,-1,164,165,362,-1,268,158,353,-1,268,161,158,-1,453,272,452,-1,453,273,272,-1,445,450,508,-1,445,510,450,-1,448,508,450,-1,448,447,508,-1,338,510,445,-1,339,510,338,-1,385,43,45,-1,385,383,43,-1,444,442,183,-1,442,444,443,-1,237,176,375,-1,176,237,239,-1,441,136,440,-1,137,136,441,-1,141,129,140,-1,130,129,141,-1,386,27,477,-1,27,386,126,-1,112,59,110,-1,108,59,112,-1,424,118,365,-1,119,118,424,-1,437,436,435,-1,437,439,436,-1,122,438,123,-1,379,438,122,-1,27,142,477,-1,26,142,27,-1,96,107,372,-1,96,63,107,-1,83,212,94,-1,82,212,83,-1,99,167,100,-1,99,97,167,-1,106,213,212,-1,213,106,433,-1,434,90,476,-1,90,434,88,-1,93,87,86,-1,93,478,87,-1,213,95,94,-1,213,462,95,-1,80,431,430,-1,80,79,431,-1,75,78,76,-1,75,81,78,-1,73,77,74,-1,77,73,348,-1,72,348,73,-1,72,346,348,-1,350,284,70,-1,284,350,429,-1,286,280,68,-1,475,280,286,-1,392,472,393,-1,475,472,392,-1,144,146,1,-1,253,146,144,-1,22,278,38,-1,23,278,22,-1,425,21,37,-1,21,425,20,-1,49,19,426,-1,19,49,18,-1,281,17,50,-1,17,281,16,-1,47,424,113,-1,424,47,46,-1,418,316,314,-1,418,423,316,-1,308,401,329,-1,328,401,308,-1,421,405,422,-1,421,407,405,-1,419,201,420,-1,419,202,201,-1,401,417,399,-1,401,428,417,-1,39,404,40,-1,416,404,39,-1,67,277,65,-1,277,67,342,-1,414,352,415,-1,352,414,411,-1,485,413,341,-1,412,413,485,-1,36,352,411,-1,343,352,36,-1,485,33,295,-1,485,341,33,-1,293,514,305,-1,293,410,514,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmc4_Coord',point=[(-7.35124,28.1978,2.22709),(-7.37948,28.17307,2.20038),(-7.32603,28.3186,2.25644),(-7.64756,26.41874,2.5012),(-7.6272,26.44431,2.47868),(-7.63274,26.40792,2.49403),(-7.61462,26.4076,2.48092),(-7.60038,26.41612,2.46765),(-7.59479,26.43581,2.45694),(-7.59933,26.4583,2.45266),(-7.612,26.46844,2.45848),(-7.62513,26.47587,2.46556),(-7.64649,26.47909,2.48006),(-7.65874,26.46552,2.49357),(-7.44714,26.48765,2.85831),(-7.41483,26.48711,2.8475),(-7.44424,26.51357,2.85567),(-7.43133,26.52881,2.85089),(-7.40508,26.53039,2.84326),(-7.38608,26.5145,2.83891),(-7.3715,26.49038,2.83641),(-7.37778,26.46195,2.84021),(-7.40321,26.44457,2.84872),(-7.42905,26.44783,2.8559),(-7.44665,26.46868,2.85949),(-7.52477,28.40723,2.43117),(-7.53193,28.41761,2.3579),(-7.5304,28.43385,2.44799),(-7.52233,28.39799,2.37579),(-7.44278,26.64039,2.36109),(-7.55651,26.72544,2.3964),(-7.49253,26.71986,2.39822),(-7.52928,26.60322,2.37948),(-7.23488,26.62848,2.7298),(-7.29495,26.67322,2.69645),(-7.3209,26.67945,2.7703),(-7.34003,26.36955,2.84278),(-7.32019,26.42131,2.82984),(-7.3801,26.38685,2.85284),(-7.55985,26.56841,2.3832),(-7.60102,26.60257,2.40508),(-7.6736,26.61957,2.4266),(-7.66845,26.65732,2.41248),(-7.34441,28.34443,2.13117),(-7.30786,28.31722,2.12429),(-7.32874,28.31345,2.11733),(-7.35164,28.30827,2.49288),(-7.33889,28.30835,2.48363),(-7.36286,28.35492,2.47021),(-7.39271,26.58859,2.83523),(-7.44977,26.59186,2.86304),(-7.78499,28.1381,2.52672),(-7.77175,28.13473,2.49194),(-7.76496,28.01986,2.50698),(-7.74864,28.02589,2.61345),(-7.76298,28.15198,2.59771),(-7.29672,28.32684,2.14232),(-7.31972,28.26983,2.15631),(-7.32468,28.26562,2.13872),(-7.69534,28.31309,2.65026),(-7.72,28.31403,2.65309),(-7.71002,28.26773,2.65662),(-7.75131,28.30869,2.64053),(-7.73809,28.38316,2.62503),(-7.74706,28.38599,2.61371),(-7.47753,26.33014,2.87822),(-7.49839,26.31646,2.86591),(-7.38778,26.28486,2.83664),(-7.55508,26.6,2.94323),(-7.51628,26.67627,2.93125),(-7.5603,26.71473,2.93492),(-7.66565,27.0229,2.83115),(-7.64754,27.03694,2.85828),(-7.68918,27.31582,2.76674),(-7.69897,27.58022,2.70847),(-7.67619,27.8455,2.65412),(-7.69923,27.84339,2.65619),(-7.67646,27.58052,2.71161),(-7.70102,27.91327,2.65335),(-7.68643,28.02981,2.66001),(-7.71886,28.02874,2.65424),(-7.67767,27.91255,2.65253),(-7.83945,28.43332,2.19839),(-7.82999,28.41766,2.15577),(-7.86379,28.3823,2.16196),(-7.84968,28.37059,2.1602),(-7.81701,28.40305,2.15496),(-7.78924,28.31263,2.17787),(-7.72905,28.45912,2.38285),(-7.74543,28.46034,2.50052),(-7.72486,28.46448,2.49108),(-7.74761,28.46056,2.38721),(-7.72639,28.45675,2.57697),(-7.701,28.39414,2.16036),(-7.81521,28.41942,2.15631),(-7.70032,28.40491,2.1671),(-7.73325,28.45026,2.58515),(-7.75141,28.45227,2.50598),(-7.77462,28.3881,2.52729),(-7.76996,28.3982,2.53172),(-7.77197,28.39677,2.52168),(-7.82879,28.41253,2.30468),(-7.8384,28.40264,2.30227),(-7.83017,28.40354,2.31149),(-7.80356,28.45025,2.2749),(-7.75949,28.45321,2.37488),(-7.79607,28.45237,2.27189),(-7.72543,28.38752,2.63137),(-7.69053,28.32752,2.64692),(-7.55655,28.29429,2.6038),(-7.59948,28.27594,2.62748),(-7.55021,28.28319,2.59828),(-7.59999,28.28927,2.62645),(-7.32729,28.28588,2.48485),(-7.32499,28.27334,2.48133),(-7.31079,28.31439,2.45135),(-7.31561,28.32755,2.45384),(-7.40222,28.34987,2.49528),(-7.38558,28.29007,2.51432),(-7.37701,28.30069,2.51341),(-7.41087,28.34664,2.49271),(-7.4115,28.37655,2.4743),(-7.39695,28.4155,2.44667),(-7.40581,28.41519,2.44091),(-7.40215,28.37743,2.47688),(-7.53102,28.37502,2.5612),(-7.52544,28.43341,2.52529),(-7.53761,28.43876,2.52904),(-7.52201,28.36816,2.5564),(-7.50387,28.40881,2.31899),(-7.5001,28.40498,2.32658),(-7.45282,28.40489,2.33149),(-7.45078,28.41435,2.32788),(-7.39397,28.41882,2.33818),(-7.39196,28.40912,2.34789),(-7.34569,28.40375,2.31682),(-7.29692,28.37943,2.22625),(-7.30606,28.38953,2.22556),(-7.33883,28.3984,2.31684),(-7.52959,28.33586,2.57467),(-7.53739,28.41816,2.33972),(-7.52933,28.41264,2.34706),(-7.54345,28.42316,2.35175),(-7.39105,28.11033,2.20189),(-7.389,28.14093,2.21623),(-7.32151,28.22715,2.25691),(-7.44412,28.15711,2.20898),(-7.37772,28.18894,2.16299),(-7.37256,28.17979,2.17056),(-7.44284,28.1676,2.20331),(-7.56136,28.15235,2.19977),(-7.64984,28.14467,2.18949),(-7.56268,28.16032,2.19812),(-7.64579,28.13483,2.19344),(-7.82619,28.19608,2.22221),(-7.85471,28.22813,2.26997),(-7.88225,28.3165,2.19117),(-7.88836,28.34272,2.23259),(-7.65166,27.77538,2.37054),(-7.56447,27.51823,2.39897),(-7.65252,27.51852,2.41719),(-7.58337,27.76955,2.33726),(-7.43848,27.95517,2.28602),(-7.51363,27.94603,2.25637),(-7.4458,28.01833,2.21801),(-7.52918,28.00996,2.21407),(-7.74427,28.4225,2.44969),(-7.75238,28.45484,2.49573),(-7.75275,28.45374,2.39019),(-7.75086,28.42608,2.39588),(-7.77035,28.39692,2.36043),(-7.7911,28.37244,2.37539),(-7.84751,28.36553,2.33345),(-7.75853,28.38808,2.47093),(-7.75294,28.39505,2.40485),(-7.76388,28.36875,2.42288),(-7.46565,28.29625,2.4965),(-7.49972,28.32119,2.51306),(-7.44032,28.23628,2.53668),(-7.47628,28.24834,2.55492),(-7.46201,28.36373,2.40037),(-7.43687,28.39396,2.40059),(-7.4542,28.38342,2.35285),(-7.53742,28.34561,2.1597),(-7.46985,28.26766,2.16482),(-7.54751,28.27752,2.17459),(-7.47839,28.3391,2.14115),(-7.38905,28.40566,2.36816),(-7.39393,28.21634,2.5229),(-7.43225,28.12181,2.5949),(-7.38823,28.11233,2.55656),(-7.51564,28.14257,2.61692),(-7.53587,28.25822,2.59621),(-7.53162,27.85062,2.60643),(-7.477,27.84181,2.57458),(-7.45485,27.99628,2.59503),(-7.51897,28.00366,2.61809),(-7.74857,27.55504,2.4949),(-7.75878,27.57942,2.57798),(-7.75574,27.83175,2.53203),(-7.53779,26.33589,2.43328),(-7.4632,26.29203,2.39838),(-7.50618,26.26216,2.43229),(-7.6369,26.28223,2.53451),(-7.57464,26.29058,2.48321),(-7.57006,26.24783,2.48601),(-7.73206,27.79767,2.45018),(-7.75812,27.98946,2.40531),(-7.72557,27.2486,2.45068),(-7.71102,27.53224,2.44505),(-7.64209,27.24056,2.43709),(-7.86955,28.39483,2.2111),(-7.8295,28.43589,2.19931),(-7.78406,28.43753,2.20213),(-7.85745,28.36672,2.3227),(-7.79775,28.35046,2.44146),(-7.85599,28.35627,2.3358),(-7.79885,28.25936,2.46939),(-7.8402,28.24542,2.35555),(-7.35904,28.3898,2.44515),(-7.33863,28.36897,2.44507),(-7.33163,28.33568,2.4621),(-7.36922,28.31814,2.50077),(-7.38758,28.35224,2.48885),(-7.38119,28.39665,2.45293),(-7.60066,28.2585,2.62389),(-7.58068,28.3514,2.59686),(-7.56977,28.39313,2.57366),(-7.6134,28.4007,2.59315),(-7.66405,28.35478,2.62982),(-7.60483,28.33564,2.61582),(-7.65647,28.43204,2.58987),(-7.68081,28.40049,2.61103),(-7.5833,28.42855,2.56122),(-7.62228,28.44035,2.57146),(-7.51837,28.38473,2.46875),(-7.51221,28.37608,2.41045),(-7.39448,28.2613,2.50156),(-7.43736,28.3239,2.4718),(-7.4531,28.30181,2.48641),(-7.31597,28.22164,2.46476),(-7.30455,28.17995,2.45518),(-7.30194,28.25742,2.41573),(-7.28821,28.18631,2.36799),(-7.34951,28.39479,2.36575),(-7.32677,28.36099,2.37754),(-7.3437,28.40185,2.32542),(-7.29933,28.34263,2.32076),(-7.28795,28.26339,2.34316),(-7.30192,28.29034,2.39475),(-7.31685,28.28589,2.19545),(-7.39393,28.2571,2.14228),(-7.33623,28.26215,2.13149),(-7.44603,28.13221,2.22197),(-7.54916,28.13028,2.21812),(-7.53591,28.09865,2.20055),(-7.63699,28.11534,2.20323),(-7.72465,28.16479,2.19395),(-7.84676,28.31177,2.17129),(-7.86008,28.31081,2.17641),(-7.73238,28.14928,2.199),(-7.62646,28.01846,2.21574),(-7.73423,28.04176,2.22926),(-7.35321,28.10403,2.52645),(-7.35617,28.20075,2.50122),(-7.73961,27.97339,2.34698),(-7.6883,27.78269,2.40072),(-7.47443,27.79651,2.34377),(-7.60361,27.93903,2.26045),(-7.43034,27.80364,2.39123),(-7.37602,27.95857,2.33828),(-7.38572,27.98294,2.52736),(-7.36339,27.97663,2.48421),(-7.30856,28.0901,2.46534),(-7.49148,26.70395,2.90289),(-7.41292,26.68538,2.83858),(-7.49146,26.44589,2.8859),(-7.45631,26.34664,2.88537),(-7.44654,26.39392,2.87064),(-7.54179,26.41625,2.90849),(-7.56423,26.48475,2.91785),(-7.49328,26.55327,2.88019),(-7.50017,26.48772,2.8807),(-7.63065,26.57945,2.88382),(-7.5885,26.71697,2.93299),(-7.63188,26.70181,2.86858),(-7.57472,26.59305,2.93895),(-7.77437,27.2596,2.53711),(-7.76617,27.28954,2.6226),(-7.76587,27.25471,2.47925),(-7.78795,26.94925,2.47456),(-7.78771,26.95128,2.51383),(-7.21979,26.52522,2.63108),(-7.25159,26.45554,2.52004),(-7.25219,26.48548,2.51327),(-7.27393,26.62555,2.7871),(-7.46531,26.83678,2.42989),(-7.47808,26.97009,2.43446),(-7.4232,26.84267,2.45959),(-7.43954,26.97829,2.45155),(-7.54608,26.83488,2.41533),(-7.43696,26.70945,2.41684),(-7.39473,26.69788,2.4466),(-7.40378,26.643,2.38283),(-7.3513,26.6093,2.43177),(-7.3066,26.49415,2.40021),(-7.51773,26.48992,2.38211),(-7.73383,26.6304,2.42991),(-7.77403,26.62884,2.46191),(-7.75146,26.52914,2.51218),(-7.75499,26.55028,2.63379),(-7.78146,26.54865,2.56221),(-7.74031,26.45712,2.64764),(-7.76233,26.53442,2.52636),(-7.76098,26.44303,2.58877),(-7.62104,26.2511,2.61621),(-7.71741,26.34535,2.59453),(-7.63195,26.26282,2.55493),(-7.70678,26.35035,2.6525),(-7.52155,26.41151,2.39888),(-7.5557,26.42256,2.42979),(-7.56633,26.4776,2.42041),(-7.67974,26.53395,2.47801),(-7.70081,26.48988,2.50196),(-7.6591,26.44288,2.50147),(-7.68859,26.43833,2.52184),(-7.63807,26.35627,2.51523),(-7.59575,26.35134,2.47583),(-7.7829,26.61767,2.48685),(-7.77734,26.66325,2.45435),(-7.73454,26.7047,2.42846),(-7.42475,26.59019,2.33283),(-7.65498,26.72585,2.41161),(-7.7346,26.82236,2.42726),(-7.64582,26.83201,2.42339),(-7.48526,27.24348,2.4311),(-7.38452,26.85523,2.51468),(-7.35626,26.71145,2.52178),(-7.31226,26.7295,2.68453),(-7.33051,26.7333,2.60639),(-7.27593,26.6365,2.60816),(-7.22305,26.5034,2.74794),(-7.38076,26.30485,2.85073),(-7.37348,26.33751,2.85594),(-7.78097,26.95489,2.57463),(-7.75105,26.97266,2.66679),(-7.62912,27.03964,2.85575),(-7.60445,27.31192,2.74781),(-7.66142,27.31706,2.76695),(-7.57334,27.03619,2.81779),(-7.59317,26.86836,2.89454),(-7.53234,26.87567,2.86458),(-7.33998,26.30622,2.83178),(-7.69236,27.94418,2.29899),(-7.61015,28.01509,2.62942),(-7.43016,27.81978,2.51363),(-7.4033,28.03166,2.22656),(-7.32962,28.0614,2.29655),(-7.79085,28.11129,2.38035),(-7.78811,28.07847,2.31068),(-7.6029,28.14376,2.62711),(-7.58685,28.14314,2.62247),(-7.44414,28.09742,2.19691),(-7.59621,28.2863,2.18116),(-7.32454,28.15562,2.26688),(-7.34929,28.26967,2.50306),(-7.35948,28.25053,2.48258),(-7.46227,28.33987,2.43644),(-7.4887,28.33349,2.42833),(-7.50521,28.35365,2.44379),(-7.7856,28.27689,2.57143),(-7.74365,28.26914,2.64947),(-7.71909,28.45488,2.59015),(-7.38863,28.37325,2.47462),(-7.41876,27.98925,2.55969),(-7.39518,28.24516,2.51379),(-7.40039,28.39414,2.24212),(-7.49387,28.35098,2.39655),(-7.50553,28.38355,2.34836),(-7.38142,28.42007,2.43695),(-7.4197,27.80603,2.45315),(-7.43702,27.55838,2.54842),(-7.43902,27.55401,2.4961),(-7.40702,28.34972,2.13539),(-7.47997,28.35073,2.14724),(-7.40391,28.33089,2.1289),(-7.53886,28.4426,2.51864),(-7.30878,28.32377,2.44334),(-7.6261,28.46595,2.53773),(-7.62343,28.46372,2.55349),(-7.31215,28.27187,2.42301),(-7.79526,28.35853,2.43786),(-7.56299,26.40216,2.90089),(-7.58404,26.39071,2.87764),(-7.42295,26.71434,2.8347),(-7.35654,28.23328,2.49),(-7.32409,28.2404,2.46314),(-7.31086,28.34712,2.1403),(-7.55192,26.22714,2.50663),(-7.78616,26.80779,2.47305),(-7.77527,26.81191,2.44991),(-7.78372,26.65049,2.4791),(-7.77681,26.94797,2.45526),(-7.66755,26.39394,2.5284),(-7.61756,26.52953,2.43751),(-7.37115,26.50632,2.3493),(-7.37041,26.56262,2.34528),(-7.42639,26.51126,2.33702),(-7.58842,28.01197,2.6254),(-7.2301,26.37824,2.65459),(-7.25314,26.35707,2.53646),(-7.29433,26.3451,2.81181),(-7.25922,26.4073,2.79487),(-7.24053,26.39927,2.76824),(-7.2776,26.33057,2.78366),(-7.33123,26.28704,2.81273),(-7.59028,26.50188,2.4284),(-7.78658,26.8019,2.5242),(-7.74573,26.43756,2.56341),(-7.47634,26.23898,2.45837),(-7.42438,26.27754,2.40875),(-7.43516,26.38789,2.35754),(-7.38633,26.37954,2.37127),(-7.70889,26.35482,2.56567),(-7.34822,28.28532,2.50336),(-7.30713,26.4961,2.82452),(-7.33435,26.56115,2.82601),(-7.34712,26.72633,2.76356),(-7.78553,26.65005,2.5403),(-7.61949,26.8628,2.89652),(-7.72989,28.15174,2.65473),(-7.69248,28.15269,2.66371),(-7.67651,28.43103,2.26361),(-7.7656,28.44873,2.26688),(-7.65677,28.44978,2.36744),(-7.32334,28.3721,2.42175),(-7.32793,28.37296,2.43354),(-7.34834,28.40861,2.41492),(-7.38358,28.42221,2.42428),(-7.34993,28.40734,2.42745),(-7.28632,28.34625,2.16947),(-7.2975,28.36021,2.16706),(-7.53751,28.35706,2.16565),(-7.58866,28.37117,2.16749),(-7.59155,28.36098,2.16177),(-7.35395,26.87825,2.66221),(-7.39646,26.88581,2.72929),(-7.42183,27.28544,2.5939),(-7.4268,27.27331,2.53274),(-7.44129,27.2628,2.48784),(-7.38677,27.0038,2.57251),(-7.40563,26.98545,2.50905),(-7.35999,27.96617,2.41463),(-7.30096,28.08232,2.38829),(-7.44552,28.34756,2.44026),(-7.47319,28.39263,2.25204),(-7.40433,28.37106,2.18904),(-7.47931,28.37565,2.20282),(-7.56157,28.39925,2.25924),(-7.52723,28.37535,2.20833),(-7.57517,28.38687,2.2098),(-7.522,28.39277,2.2568),(-7.68717,28.41822,2.20747),(-7.55328,27.23733,2.42511),(-7.28115,26.29224,2.69482),(-7.33805,26.25393,2.7294),(-7.37066,26.22407,2.63034),(-7.35736,26.26557,2.48259),(-7.30422,26.27103,2.58524),(-7.42042,26.21906,2.52971),(-7.40802,26.24417,2.75874),(-7.53952,26.29396,2.80525),(-7.60786,26.47559,2.88174),(-7.62378,26.38413,2.82077),(-7.64898,26.46186,2.81805),(-7.58002,26.47916,2.91242),(-7.64115,28.46346,2.46253),(-7.54561,28.44406,2.45174),(-7.68762,28.29659,2.18302),(-7.73895,27.83213,2.6193),(-7.61359,27.8565,2.63361),(-7.49273,27.52575,2.40429),(-7.44819,27.54719,2.4489),(-7.60809,27.57641,2.69692),(-7.52202,27.55938,2.6531),(-7.24545,26.49841,2.79224),(-7.65196,26.84586,2.85245),(-7.51336,27.29971,2.701),(-7.48201,27.03159,2.75994),(-7.45575,26.88448,2.79614),(-7.45476,27.29355,2.65268),(-7.4298,27.02594,2.70564),(-7.74099,27.58805,2.65547),(-7.73853,27.30355,2.69938),(-7.71345,26.99599,2.74967),(-7.69363,26.8339,2.77087),(-7.7341,26.81886,2.68785),(-7.76949,26.80753,2.59268),(-7.73184,26.95811,2.43275),(-7.72096,26.67366,2.70307),(-7.75993,26.659,2.61433),(-7.67727,26.68661,2.78563),(-7.67291,26.5741,2.80385),(-7.71776,26.561,2.72502),(-7.69164,26.45793,2.73454),(-7.67281,26.361,2.74381),(-7.58052,26.26424,2.71216),(-7.44582,26.21361,2.66679),(-7.38572,27.01786,2.63824),(-7.31235,26.61783,2.51345),(-7.36271,26.86914,2.58957),(-7.63781,26.96914,2.4305),(-7.54766,26.96825,2.42696),(-7.49618,26.20618,2.57059),(-7.31168,26.35861,2.43873),(-7.57018,26.38128,2.44855),(-7.47042,27.55628,2.611)]))),
        Shape(DEF='rmc5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,1),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmc5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,17,-1,20,15,21,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,0,35,-1,0,42,35,-1,43,37,38,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,51,-1,55,25,24,-1,56,57,58,-1,57,59,58,-1,60,61,62,-1,20,23,63,-1,20,64,23,-1,65,66,67,-1,59,68,69,-1,59,57,68,-1,70,71,72,-1,65,19,73,-1,65,17,19,-1,25,73,19,-1,74,75,76,-1,31,60,62,-1,77,78,79,-1,0,41,80,-1,51,50,53,-1,81,82,83,-1,81,84,82,-1,85,54,4,-1,86,87,51,-1,51,88,86,-1,89,90,91,-1,90,92,91,-1,82,93,94,-1,93,95,94,-1,96,97,98,-1,96,99,97,-1,100,101,102,-1,103,104,105,-1,103,106,104,-1,107,108,109,-1,110,111,112,-1,111,113,112,-1,114,12,14,-1,114,115,12,-1,116,117,118,-1,116,119,117,-1,8,7,115,-1,120,121,45,-1,122,123,45,-1,124,125,45,-1,126,127,45,-1,128,129,45,-1,130,120,45,-1,44,122,45,-1,131,132,133,-1,51,87,52,-1,32,134,33,-1,135,36,136,-1,137,138,4,-1,139,117,119,-1,140,141,142,-1,143,138,144,-1,145,70,66,-1,114,146,147,-1,147,148,114,-1,8,149,150,-1,151,152,153,-1,52,154,155,-1,86,156,87,-1,156,154,87,-1,157,158,159,-1,158,160,159,-1,161,159,162,-1,159,163,162,-1,164,165,166,-1,164,167,165,-1,139,119,168,-1,169,170,165,-1,171,162,163,-1,163,34,171,-1,43,172,92,-1,173,174,141,-1,141,175,173,-1,175,176,173,-1,175,177,176,-1,113,178,179,-1,179,112,113,-1,5,101,3,-1,5,4,138,-1,91,92,172,-1,180,181,182,-1,180,183,181,-1,28,29,184,-1,184,185,28,-1,26,186,187,-1,26,188,186,-1,187,27,26,-1,29,27,187,-1,69,184,29,-1,189,190,191,-1,192,131,133,-1,48,193,194,-1,195,196,197,-1,197,198,195,-1,199,200,201,-1,201,202,199,-1,199,128,127,-1,199,203,128,-1,22,19,18,-1,195,21,17,-1,195,204,21,-1,205,49,48,-1,48,206,205,-1,207,208,58,-1,209,62,210,-1,209,31,62,-1,211,96,78,-1,96,212,78,-1,96,98,212,-1,98,213,212,-1,62,214,210,-1,62,215,214,-1,64,216,23,-1,216,217,23,-1,218,219,220,-1,221,75,74,-1,74,79,221,-1,59,69,29,-1,17,65,196,-1,196,195,17,-1,222,214,223,-1,222,210,214,-1,121,224,45,-1,124,198,125,-1,198,197,125,-1,21,225,20,-1,21,226,225,-1,227,28,185,-1,228,229,68,-1,30,29,187,-1,30,230,60,-1,60,31,30,-1,213,98,90,-1,90,231,213,-1,138,137,232,-1,40,39,143,-1,143,144,40,-1,233,85,3,-1,3,234,233,-1,88,235,86,-1,88,236,235,-1,103,108,107,-1,237,136,238,-1,237,239,136,-1,177,108,237,-1,177,178,108,-1,176,36,240,-1,176,238,36,-1,119,241,168,-1,119,242,241,-1,34,163,243,-1,243,32,34,-1,171,244,245,-1,171,34,244,-1,165,170,117,-1,117,139,165,-1,246,154,156,-1,246,247,154,-1,160,163,159,-1,160,243,163,-1,248,157,161,-1,157,159,161,-1,54,249,4,-1,54,53,249,-1,9,250,251,-1,115,114,148,-1,233,234,252,-1,252,253,233,-1,241,175,141,-1,241,179,175,-1,180,158,157,-1,180,182,158,-1,254,255,256,-1,220,257,42,-1,166,165,139,-1,34,33,244,-1,207,31,209,-1,121,258,259,-1,259,224,121,-1,129,130,45,-1,127,128,45,-1,125,126,45,-1,123,124,45,-1,224,46,45,-1,260,151,261,-1,12,262,263,-1,264,265,266,-1,267,169,146,-1,110,112,242,-1,250,9,153,-1,9,151,153,-1,268,147,246,-1,147,269,246,-1,235,270,86,-1,270,156,86,-1,101,5,102,-1,5,138,102,-1,92,98,97,-1,92,90,98,-1,186,30,187,-1,186,230,30,-1,96,211,99,-1,211,271,99,-1,85,51,54,-1,85,88,51,-1,254,81,52,-1,81,272,52,-1,36,238,136,-1,136,273,135,-1,136,239,273,-1,212,221,79,-1,79,78,212,-1,145,66,65,-1,65,73,145,-1,274,275,276,-1,274,277,275,-1,132,278,279,-1,279,280,132,-1,131,192,281,-1,192,277,281,-1,191,190,227,-1,227,185,191,-1,74,61,79,-1,61,74,215,-1,215,62,61,-1,59,29,58,-1,29,207,58,-1,31,207,29,-1,206,48,194,-1,135,39,38,-1,52,272,50,-1,249,53,282,-1,154,52,87,-1,283,171,284,-1,283,162,171,-1,23,22,63,-1,44,46,285,-1,285,286,44,-1,287,55,218,-1,220,2,288,-1,245,289,290,-1,290,291,245,-1,174,142,141,-1,292,293,294,-1,27,29,28,-1,193,295,274,-1,19,22,25,-1,16,18,17,-1,21,15,17,-1,288,296,287,-1,76,297,74,-1,261,298,260,-1,4,3,85,-1,25,55,299,-1,151,252,152,-1,151,260,252,-1,218,288,287,-1,220,288,218,-1,294,300,301,-1,294,293,300,-1,299,49,25,-1,47,49,299,-1,73,206,145,-1,205,206,73,-1,276,193,274,-1,194,193,276,-1,302,295,303,-1,295,302,274,-1,304,305,306,-1,305,304,307,-1,274,281,277,-1,302,281,274,-1,168,134,139,-1,134,168,140,-1,76,308,216,-1,76,309,308,-1,80,1,0,-1,1,80,310,-1,174,245,244,-1,245,174,289,-1,219,291,290,-1,219,311,291,-1,55,300,299,-1,55,287,300,-1,286,222,223,-1,286,285,222,-1,283,312,217,-1,283,284,312,-1,282,50,272,-1,282,53,50,-1,207,313,208,-1,207,209,313,-1,292,193,48,-1,193,292,295,-1,314,315,316,-1,314,317,315,-1,296,318,301,-1,318,296,319,-1,225,74,297,-1,225,215,74,-1,184,68,229,-1,184,69,68,-1,227,280,279,-1,190,280,227,-1,277,320,275,-1,192,320,277,-1,278,131,281,-1,132,131,278,-1,280,189,321,-1,190,189,280,-1,67,196,65,-1,67,201,196,-1,322,212,213,-1,212,322,221,-1,323,324,183,-1,231,324,323,-1,310,325,326,-1,310,80,325,-1,271,327,328,-1,271,211,327,-1,249,83,329,-1,282,83,249,-1,111,251,330,-1,251,111,331,-1,178,109,108,-1,109,178,113,-1,332,11,266,-1,261,11,332,-1,9,261,151,-1,11,261,9,-1,333,235,236,-1,235,333,334,-1,156,268,246,-1,270,268,156,-1,269,146,169,-1,147,146,269,-1,170,118,117,-1,335,118,170,-1,106,250,153,-1,336,250,106,-1,336,103,107,-1,336,106,103,-1,266,10,264,-1,11,10,266,-1,265,262,266,-1,265,263,262,-1,337,261,332,-1,298,261,337,-1,189,228,338,-1,189,229,228,-1,229,189,191,-1,339,42,257,-1,339,240,42,-1,340,183,324,-1,340,181,183,-1,248,180,157,-1,341,180,248,-1,255,158,182,-1,255,155,158,-1,263,342,343,-1,263,265,342,-1,253,236,233,-1,333,236,253,-1,270,149,268,-1,149,270,150,-1,335,343,118,-1,343,335,13,-1,344,111,110,-1,331,111,344,-1,106,152,104,-1,152,106,153,-1,263,13,12,-1,263,343,13,-1,264,331,344,-1,264,10,331,-1,298,333,253,-1,333,298,337,-1,334,8,150,-1,6,8,334,-1,324,93,340,-1,324,89,93,-1,84,254,256,-1,81,254,84,-1,345,243,160,-1,345,164,243,-1,345,167,164,-1,345,247,167,-1,247,269,167,-1,247,246,269,-1,244,142,174,-1,142,244,33,-1,240,173,176,-1,173,240,339,-1,177,238,176,-1,177,237,238,-1,108,239,237,-1,108,100,239,-1,273,100,102,-1,273,239,100,-1,172,95,91,-1,346,95,172,-1,232,329,94,-1,137,329,232,-1,232,144,138,-1,232,346,144,-1,325,92,97,-1,43,92,325,-1,341,322,323,-1,341,347,322,-1,162,308,161,-1,162,283,308,-1,289,257,290,-1,289,339,257,-1,188,317,314,-1,188,348,317,-1,133,349,350,-1,349,133,321,-1,307,281,302,-1,307,278,281,-1,306,351,348,-1,351,306,305,-1,301,351,294,-1,351,301,318,-1,215,226,214,-1,226,215,225,-1,352,353,354,-1,352,203,353,-1,200,125,197,-1,125,200,126,-1,198,123,355,-1,123,198,124,-1,355,122,356,-1,122,355,123,-1,356,44,286,-1,44,356,122,-1,46,259,285,-1,224,259,46,-1,357,358,359,-1,358,357,360,-1,259,208,313,-1,259,258,208,-1,121,357,258,-1,120,357,121,-1,130,352,360,-1,130,129,352,-1,226,223,214,-1,361,223,226,-1,320,362,71,-1,362,320,350,-1,354,362,363,-1,354,353,362,-1,359,364,56,-1,359,358,364,-1,228,57,56,-1,228,68,57,-1,364,349,338,-1,363,349,364,-1,99,316,326,-1,316,99,271,-1,55,312,311,-1,24,312,55,-1,23,312,24,-1,23,217,312,-1,216,297,76,-1,297,216,64,-1,211,77,327,-1,78,77,211,-1,97,326,325,-1,326,97,99,-1,220,290,257,-1,219,290,220,-1,308,217,216,-1,283,217,308,-1,221,347,75,-1,347,221,322,-1,284,311,312,-1,311,284,291,-1,220,0,2,-1,42,0,220,-1,315,1,310,-1,319,1,315,-1,310,316,315,-1,316,310,326,-1,338,56,364,-1,338,228,56,-1,222,209,210,-1,222,313,209,-1,208,56,58,-1,56,208,359,-1,358,363,364,-1,363,358,354,-1,350,363,362,-1,363,350,349,-1,353,71,362,-1,72,353,202,-1,71,353,72,-1,47,292,48,-1,293,292,47,-1,63,15,20,-1,15,63,16,-1,21,361,226,-1,21,204,361,-1,120,360,357,-1,130,360,120,-1,258,359,208,-1,258,357,359,-1,360,354,358,-1,354,360,352,-1,285,313,222,-1,285,259,313,-1,361,286,223,-1,286,361,356,-1,204,356,361,-1,355,356,204,-1,127,200,199,-1,126,200,127,-1,129,203,352,-1,128,203,129,-1,203,202,353,-1,203,199,202,-1,201,197,196,-1,201,200,197,-1,195,355,204,-1,195,198,355,-1,305,294,351,-1,303,294,305,-1,318,348,351,-1,318,317,348,-1,278,304,279,-1,304,278,307,-1,321,338,349,-1,321,189,338,-1,132,321,133,-1,132,280,321,-1,26,348,188,-1,26,306,348,-1,186,314,328,-1,186,188,314,-1,240,35,42,-1,240,36,35,-1,284,245,291,-1,171,245,284,-1,309,341,248,-1,309,347,341,-1,341,183,180,-1,183,341,323,-1,94,346,232,-1,94,95,346,-1,143,102,138,-1,143,273,102,-1,105,101,100,-1,3,101,105,-1,175,178,177,-1,179,178,175,-1,241,112,179,-1,241,242,112,-1,173,289,174,-1,173,339,289,-1,166,243,164,-1,243,166,32,-1,167,169,165,-1,167,269,169,-1,247,155,154,-1,247,345,155,-1,160,155,345,-1,155,160,158,-1,340,82,84,-1,340,93,82,-1,231,89,324,-1,231,90,89,-1,182,256,255,-1,182,181,256,-1,337,334,333,-1,6,334,337,-1,253,260,298,-1,253,252,260,-1,265,344,342,-1,264,344,265,-1,234,152,252,-1,152,234,104,-1,250,330,251,-1,250,336,330,-1,342,110,116,-1,344,110,342,-1,13,267,14,-1,13,335,267,-1,268,148,147,-1,148,268,149,-1,235,150,270,-1,150,235,334,-1,145,275,70,-1,276,275,145,-1,32,139,134,-1,139,32,166,-1,118,342,116,-1,118,343,342,-1,155,254,52,-1,155,255,254,-1,84,181,340,-1,84,256,181,-1,249,137,4,-1,329,137,249,-1,273,39,135,-1,273,143,39,-1,60,327,77,-1,60,230,327,-1,332,6,337,-1,6,332,7,-1,14,146,114,-1,146,14,267,-1,3,104,234,-1,104,3,105,-1,116,242,119,-1,116,110,242,-1,169,335,170,-1,267,335,169,-1,107,330,336,-1,107,109,330,-1,103,100,108,-1,103,105,100,-1,88,233,236,-1,85,233,88,-1,266,7,332,-1,266,262,7,-1,115,262,12,-1,7,262,115,-1,111,109,113,-1,330,109,111,-1,82,329,83,-1,82,94,329,-1,95,89,91,-1,93,89,95,-1,230,328,327,-1,186,328,230,-1,282,81,83,-1,272,81,282,-1,325,41,43,-1,41,325,80,-1,323,213,231,-1,213,323,322,-1,77,61,60,-1,77,79,61,-1,75,309,76,-1,75,347,309,-1,202,67,72,-1,201,67,202,-1,192,350,320,-1,192,133,350,-1,279,28,227,-1,28,279,304,-1,191,184,229,-1,191,185,184,-1,71,275,320,-1,70,275,71,-1,66,72,67,-1,66,70,72,-1,225,64,20,-1,225,297,64,-1,287,301,300,-1,301,287,296,-1,319,317,318,-1,317,319,315,-1,328,316,271,-1,328,314,316,-1,38,36,135,-1,36,38,37,-1,140,33,134,-1,142,33,140,-1,311,218,55,-1,311,219,218,-1,40,346,172,-1,40,144,346,-1,38,172,43,-1,38,40,172,-1,35,43,41,-1,35,37,43,-1,248,308,309,-1,308,248,161,-1,241,140,168,-1,141,140,241,-1,303,292,294,-1,303,295,292,-1,28,306,26,-1,306,28,304,-1,307,303,305,-1,303,307,302,-1,206,276,145,-1,206,194,276,-1,49,73,25,-1,49,205,73,-1,299,293,47,-1,293,299,300,-1,22,16,63,-1,22,18,16,-1,331,9,251,-1,9,331,10,-1,149,115,148,-1,115,149,8,-1,319,2,1,-1,319,288,2,-1,319,296,288,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmc5_Coord',point=[(-7.76574,27.52784,2.091),(-7.71332,27.21144,2.12486),(-7.67052,27.20602,2.16316),(-7.83421,28.46362,1.952),(-7.80409,28.5002,1.84501),(-7.80963,28.42185,1.91782),(-7.60112,28.55603,1.98949),(-7.57803,28.55625,2.05428),(-7.56205,28.56024,1.99664),(-7.69033,28.51357,2.11026),(-7.65168,28.48771,2.12127),(-7.65065,28.53019,2.09527),(-7.51849,28.55407,2.06521),(-7.41996,28.48932,2.08136),(-7.42586,28.55685,2.03437),(-7.27927,26.78999,1.90579),(-7.26519,26.78583,1.95852),(-7.22406,26.67872,1.95743),(-7.27579,26.76033,2.00366),(-7.2878,26.72931,2.02889),(-7.34883,26.85836,1.88248),(-7.29662,26.77313,1.85467),(-7.31377,26.79149,2.01815),(-7.3565,26.90008,1.9647),(-7.38918,26.87486,2.0421),(-7.35195,26.75435,2.06431),(-7.74705,26.55008,1.91297),(-7.74422,26.53676,1.86578),(-7.71774,26.4599,1.90523),(-7.66259,26.48198,1.79257),(-7.75556,26.63013,1.77891),(-7.63655,26.61366,1.71153),(-7.39325,28.19659,2.03812),(-7.42071,28.13422,2.13511),(-7.46942,28.00065,2.03661),(-7.81505,27.72279,2.01052),(-7.82859,27.84845,1.99688),(-7.85197,27.86348,1.92265),(-7.85586,27.88594,1.90921),(-7.85081,28.04969,1.90412),(-7.86196,28.0479,1.84825),(-7.81393,27.67466,2.0178),(-7.75722,27.5375,2.09625),(-7.85718,27.85883,1.90929),(-7.30345,26.4898,1.68645),(-7.28073,26.41258,1.70829),(-7.31703,26.47477,1.67208),(-7.43257,26.66953,2.14837),(-7.41415,26.58563,2.13557),(-7.39257,26.66045,2.11516),(-7.70308,28.49499,1.73283),(-7.73281,28.52536,1.77845),(-7.61378,28.48563,1.7151),(-7.76185,28.49019,1.74221),(-7.78453,28.50603,1.8314),(-7.47399,26.86742,2.15151),(-7.5754,26.33959,1.77574),(-7.63831,26.39984,1.75832),(-7.59131,26.44492,1.70139),(-7.64383,26.41369,1.76038),(-7.68099,26.70184,1.74321),(-7.58275,26.80146,1.71631),(-7.57627,26.72046,1.6835),(-7.32249,26.83956,1.95882),(-7.36542,26.93965,1.88321),(-7.22547,26.54271,1.99564),(-7.26912,26.40192,2.02835),(-7.25476,26.39409,2.01921),(-7.67963,26.3875,1.80394),(-7.67702,26.40858,1.80263),(-7.35295,26.33353,2.04231),(-7.35683,26.31609,2.03742),(-7.3399,26.32119,2.03423),(-7.29886,26.59263,2.04551),(-7.47816,26.90522,1.73039),(-7.527,27.2167,1.80194),(-7.45178,27.21719,1.83726),(-7.70053,26.81171,1.76545),(-7.70514,26.86734,1.77149),(-7.59471,26.87269,1.74097),(-7.79309,27.51627,2.0311),(-7.68302,28.43398,1.67708),(-7.78884,28.33868,1.66685),(-7.77759,28.42591,1.69891),(-7.68681,28.33501,1.66012),(-7.8001,28.50585,1.8535),(-7.59012,28.55112,1.77661),(-7.60073,28.53251,1.75687),(-7.71984,28.53008,1.80239),(-7.82481,28.04002,1.75189),(-7.84629,27.8289,1.79421),(-7.85562,28.04009,1.77026),(-7.87189,27.83577,1.81741),(-7.79761,28.19419,1.70728),(-7.82085,28.33678,1.6963),(-7.82946,28.19606,1.72628),(-7.79948,27.20168,1.81752),(-7.83976,27.49382,1.85294),(-7.82129,27.48915,1.82698),(-7.81121,27.20363,1.851),(-7.82925,28.37779,2.0316),(-7.82056,28.39901,1.95943),(-7.82392,28.38325,1.95995),(-7.83947,28.42575,2.11356),(-7.85049,28.45631,2.0373),(-7.85352,28.44101,2.03474),(-7.8302,28.44456,2.11245),(-7.82545,28.40378,2.17075),(-7.81812,28.34602,2.13471),(-7.7912,28.38024,2.18392),(-7.58549,28.30537,2.20005),(-7.71799,28.35432,2.20188),(-7.60489,28.2927,2.19439),(-7.72634,28.33369,2.20111),(-7.43381,28.57259,2.0089),(-7.52555,28.56244,2.03844),(-7.46343,28.32102,2.16527),(-7.38259,28.37109,2.11093),(-7.38964,28.38895,2.12098),(-7.45863,28.30522,2.15369),(-7.31872,26.38816,1.68168),(-7.32575,26.42141,1.66589),(-7.27979,26.49624,1.70953),(-7.25859,26.49538,1.73762),(-7.23829,26.47757,1.76234),(-7.23484,26.44374,1.77711),(-7.24712,26.40678,1.77401),(-7.2573,26.38333,1.76125),(-7.27288,26.36547,1.74111),(-7.29262,26.36133,1.72323),(-7.30929,26.36913,1.69784),(-7.60928,26.39436,2.13246),(-7.6521,26.38676,2.10404),(-7.60232,26.34715,2.0873),(-7.41386,28.18196,2.13097),(-7.84823,28.03863,1.96754),(-7.86034,28.0339,2.01751),(-7.83232,28.42526,1.80541),(-7.83134,28.38628,1.90792),(-7.39344,28.33306,2.09364),(-7.45499,28.16602,2.16933),(-7.54744,28.12752,2.17452),(-7.46235,28.12066,2.1718),(-7.84894,28.19955,1.90495),(-7.84543,28.19497,1.84515),(-7.33456,26.42313,2.02288),(-7.35332,28.55967,1.98727),(-7.37331,28.57833,1.93205),(-7.45365,28.57699,1.96243),(-7.48976,28.57262,1.91798),(-7.53343,28.56459,1.90942),(-7.7029,28.52352,2.09272),(-7.78447,28.50005,2.04633),(-7.77471,28.48765,2.10688),(-7.46673,28.49882,1.79083),(-7.44798,28.34838,1.76769),(-7.47331,28.55685,1.80287),(-7.46914,28.05065,1.82414),(-7.45632,28.2015,1.80135),(-7.44474,28.04594,1.87365),(-7.40592,28.21103,1.85002),(-7.4791,27.82048,1.88457),(-7.48452,27.81813,1.94827),(-7.42913,28.02353,1.95164),(-7.34889,28.35005,1.91731),(-7.33977,28.47344,2.00586),(-7.37817,28.33234,2.0274),(-7.36524,28.49624,1.92974),(-7.45105,28.28118,2.14574),(-7.33394,28.5415,1.98936),(-7.34461,28.46121,2.05848),(-7.49636,27.81614,2.01993),(-7.86482,28.04351,1.80536),(-7.68013,27.96286,2.13552),(-7.55361,27.96182,2.13556),(-7.6647,28.12664,2.1553),(-7.78334,27.98632,2.10175),(-7.79313,28.15621,2.14344),(-7.74034,28.30917,2.1624),(-7.63171,28.26027,2.16333),(-7.54593,28.04481,1.79662),(-7.60353,28.19044,1.71777),(-7.5247,28.19497,1.75964),(-7.62473,28.03853,1.7706),(-7.71622,26.4003,1.87461),(-7.72241,26.39983,1.89995),(-7.77876,26.65445,1.82411),(-7.76798,26.62304,1.82439),(-7.76178,26.65682,1.91648),(-7.69883,26.34788,1.92296),(-7.72507,26.37213,1.94309),(-7.72537,26.37258,1.89912),(-7.55767,26.37659,2.12721),(-7.49024,26.51901,2.12837),(-7.4337,26.504,2.10317),(-7.21213,26.61662,1.88844),(-7.2011,26.50774,1.93746),(-7.20242,26.47576,1.852),(-7.21984,26.55019,1.82665),(-7.23605,26.35052,1.83064),(-7.2146,26.39893,1.85781),(-7.2213,26.38554,1.95265),(-7.2635,26.32111,1.94732),(-7.27686,26.32065,1.79704),(-7.27057,26.67592,1.82199),(-7.3518,26.59301,2.0883),(-7.37733,26.51181,2.08466),(-7.5878,26.51324,1.66303),(-7.47892,26.42123,1.64382),(-7.56484,26.58929,1.65066),(-7.50641,26.68459,1.65521),(-7.78554,26.86649,1.81272),(-7.72197,27.20692,1.7961),(-7.74547,27.48955,1.82054),(-7.43457,26.75663,1.69957),(-7.46098,26.84678,1.72443),(-7.43053,27.21488,1.86679),(-7.41657,27.22152,1.95015),(-7.51974,26.92882,2.16472),(-7.55842,27.22549,2.1476),(-7.66326,27.21587,2.16628),(-7.61939,27.21285,1.79274),(-7.42587,26.62292,1.6339),(-7.38256,26.66736,1.68876),(-7.32866,26.44797,1.6625),(-7.39496,26.87083,1.79578),(-7.36535,26.78367,1.77608),(-7.72687,26.40565,1.941),(-7.6629,26.34205,1.8389),(-7.71561,26.3716,1.87089),(-7.76596,26.66034,1.79537),(-7.75789,27.82029,1.80237),(-7.84403,28.36186,1.78842),(-7.78973,28.51186,1.86645),(-7.82976,28.47895,1.95767),(-7.5867,28.55969,1.79808),(-7.70556,28.535,1.82475),(-7.84919,28.17186,2.11336),(-7.84324,28.02069,2.07217),(-7.84769,28.19667,2.02712),(-7.76709,27.83778,2.08301),(-7.57067,28.25759,2.16159),(-7.5807,28.2884,2.19034),(-7.36847,28.20758,1.93302),(-7.50814,27.97649,2.10328),(-7.54492,27.81508,2.07431),(-7.39661,28.55985,1.85598),(-7.40017,28.50024,1.85434),(-7.49503,27.81988,1.86364),(-7.78215,28.47208,1.74533),(-7.77032,28.4701,2.14939),(-7.73515,28.44467,2.16134),(-7.76994,28.51092,1.98668),(-7.72463,28.52801,1.93643),(-7.60469,28.42874,1.68694),(-7.51938,28.34584,1.70977),(-7.59607,28.33382,1.67136),(-7.68021,27.51352,2.12633),(-7.40431,26.42502,1.63334),(-7.40177,26.49678,1.61991),(-7.6936,28.53346,2.03153),(-7.65393,28.53804,2.07979),(-7.57219,28.54606,2.07638),(-7.52783,28.50507,2.09718),(-7.60041,28.47471,2.12459),(-7.56259,28.4819,2.11473),(-7.60833,28.54146,2.08181),(-7.34771,28.54569,2.00959),(-7.41428,28.57426,1.86612),(-7.36257,28.55795,1.92582),(-7.48078,28.56801,1.81645),(-7.80153,26.8631,1.8371),(-7.69926,28.48104,1.72094),(-7.84301,28.19981,1.96678),(-7.53788,26.4715,2.11767),(-7.46517,26.37175,2.10236),(-7.4467,26.44423,2.07664),(-7.54674,26.39916,2.12662),(-7.65599,26.41977,2.10513),(-7.70211,26.41171,1.99999),(-7.70389,26.37277,2.00653),(-7.60201,26.42322,2.13777),(-7.76215,28.47543,1.73113),(-7.4565,27.50251,1.94952),(-7.48493,27.50251,2.02336),(-7.37329,26.55515,1.64328),(-7.34321,26.57887,1.68324),(-7.50933,26.86136,2.17052),(-7.65638,27.15869,2.17117),(-7.58634,27.81594,2.10118),(-7.58216,27.50277,2.11815),(-7.53572,27.49966,2.09837),(-7.48434,26.61276,2.17813),(-7.48487,26.66727,2.17929),(-7.57747,26.63848,2.20557),(-7.5133,26.52567,2.14021),(-7.61947,26.8603,2.2128),(-7.4053,26.9377,1.80875),(-7.67503,28.53843,2.01145),(-7.45039,26.74602,2.15645),(-7.49238,26.74479,2.1741),(-7.59658,26.7506,2.21364),(-7.59345,26.4809,2.12582),(-7.58184,26.54773,2.15643),(-7.6866,26.46257,1.99797),(-7.65155,26.55383,2.10888),(-7.7023,26.55199,2.0154),(-7.64604,26.47263,2.09272),(-7.46553,27.49961,1.88839),(-7.47879,27.49852,1.87029),(-7.76081,27.21372,2.05173),(-7.51644,27.22294,2.12682),(-7.44585,27.22215,2.03215),(-7.46549,26.54099,1.61566),(-7.77389,26.75683,1.92036),(-7.73304,26.85491,2.05453),(-7.78599,26.85681,1.92424),(-7.72399,26.75597,2.04308),(-7.67273,26.75297,2.14657),(-7.67791,26.85542,2.15971),(-7.48093,26.3484,2.10349),(-7.65884,26.32668,1.98346),(-7.64044,27.49051,1.82676),(-7.6582,27.81262,1.81194),(-7.73196,28.03162,1.76758),(-7.83127,27.51159,1.93409),(-7.80438,27.20787,1.93249),(-7.77775,26.76607,1.80342),(-7.79052,26.75778,1.8292),(-7.80563,28.41664,1.7165),(-7.78282,28.39786,2.18277),(-7.68972,28.42021,2.1708),(-7.61537,28.54971,2.06645),(-7.66765,28.54105,1.91272),(-7.60049,28.55896,1.89908),(-7.35613,28.47125,2.07101),(-7.81208,28.4274,2.16782),(-7.64142,28.54633,1.99442),(-7.63302,26.30794,1.88594),(-7.68065,27.82359,2.10859),(-7.70741,28.19375,1.71041),(-7.56909,27.81496,1.83342),(-7.50733,28.40326,2.14918),(-7.4455,28.43753,2.11734),(-7.58796,28.39726,2.16994),(-7.38524,28.35474,1.8336),(-7.84364,28.19749,1.77753),(-7.55248,27.49509,1.84522),(-7.71494,26.65689,2.03164),(-7.59385,26.28605,1.9554),(-7.52848,26.29962,2.0558),(-7.66408,26.65233,2.12949),(-7.32036,26.30587,1.75603),(-7.32293,26.27492,1.90617),(-7.38838,26.26037,1.8275),(-7.26012,26.58788,1.78055),(-7.30047,26.59006,1.73135),(-7.3828,26.35983,1.67366),(-7.43039,26.28574,1.76993),(-7.46338,26.33857,1.70918),(-7.3546,26.32278,1.71443),(-7.3296,26.68597,1.74924),(-7.41038,26.27136,1.99117),(-7.48979,26.25678,1.89915),(-7.53341,26.28388,1.83671)]))),
        Shape(DEF='rpphal',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rpphal_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,5,6,3,-1,0,7,8,-1,9,0,10,-1,4,11,5,-1,4,12,11,-1,13,14,15,-1,13,16,14,-1,0,15,17,-1,3,18,4,-1,19,20,21,-1,21,22,19,-1,23,24,25,-1,24,26,25,-1,27,28,29,-1,28,30,29,-1,31,32,33,-1,34,35,36,-1,36,37,34,-1,0,38,7,-1,39,40,41,-1,39,42,40,-1,43,44,45,-1,44,46,45,-1,3,6,47,-1,48,49,50,-1,49,51,52,-1,51,53,52,-1,54,55,7,-1,55,8,7,-1,56,1,57,-1,57,58,56,-1,49,52,59,-1,59,50,49,-1,60,61,62,-1,62,63,60,-1,3,64,65,-1,3,47,66,-1,67,49,68,-1,67,51,49,-1,69,70,71,-1,69,72,70,-1,73,74,75,-1,75,76,73,-1,77,32,31,-1,31,78,77,-1,79,39,41,-1,41,80,79,-1,81,82,83,-1,81,84,82,-1,35,85,86,-1,35,34,85,-1,3,66,87,-1,88,52,53,-1,53,89,88,-1,0,17,57,-1,90,91,92,-1,91,93,92,-1,31,94,78,-1,31,95,94,-1,96,97,98,-1,97,99,98,-1,100,101,102,-1,103,104,105,-1,105,96,98,-1,106,107,105,-1,105,108,109,-1,105,110,111,-1,112,100,105,-1,113,114,115,-1,115,116,113,-1,117,24,23,-1,117,118,24,-1,119,120,121,-1,122,123,124,-1,122,125,123,-1,88,59,52,-1,88,126,59,-1,127,128,129,-1,126,125,122,-1,126,130,125,-1,125,131,123,-1,125,120,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,138,141,139,-1,101,142,28,-1,19,97,143,-1,19,99,97,-1,105,144,112,-1,105,100,110,-1,105,111,108,-1,109,106,105,-1,105,107,96,-1,105,98,103,-1,117,145,106,-1,106,109,117,-1,0,13,15,-1,146,0,2,-1,147,148,149,-1,148,150,149,-1,151,54,148,-1,151,55,54,-1,83,152,153,-1,83,82,152,-1,80,41,31,-1,31,33,80,-1,69,154,72,-1,154,155,72,-1,156,157,11,-1,3,87,64,-1,3,158,18,-1,159,51,160,-1,51,67,160,-1,39,6,161,-1,161,42,39,-1,162,133,132,-1,162,119,133,-1,105,104,144,-1,1,56,163,-1,163,2,1,-1,51,159,53,-1,159,164,53,-1,59,165,50,-1,59,166,165,-1,6,79,47,-1,6,39,79,-1,167,87,66,-1,167,168,87,-1,65,64,153,-1,64,169,153,-1,44,156,46,-1,156,154,46,-1,156,12,154,-1,12,155,154,-1,38,170,7,-1,170,54,7,-1,171,172,173,-1,84,81,149,-1,81,147,149,-1,174,175,176,-1,177,22,178,-1,22,21,178,-1,158,3,65,-1,18,73,4,-1,18,74,73,-1,0,146,10,-1,0,8,13,-1,16,179,14,-1,70,180,181,-1,5,11,182,-1,182,161,5,-1,72,76,180,-1,180,70,72,-1,38,0,9,-1,156,11,12,-1,5,161,6,-1,1,0,57,-1,62,38,9,-1,170,38,62,-1,163,172,2,-1,173,172,163,-1,94,183,184,-1,183,94,95,-1,185,40,42,-1,40,185,186,-1,4,155,12,-1,4,73,155,-1,60,70,181,-1,160,70,60,-1,76,155,73,-1,72,155,76,-1,2,187,146,-1,2,172,187,-1,17,14,188,-1,15,14,17,-1,151,16,55,-1,179,16,151,-1,158,153,152,-1,158,65,153,-1,189,149,190,-1,189,84,149,-1,191,192,135,-1,191,193,192,-1,194,142,195,-1,196,142,194,-1,196,28,142,-1,28,196,30,-1,197,178,198,-1,197,177,178,-1,176,199,143,-1,176,200,199,-1,175,201,202,-1,175,203,201,-1,115,204,205,-1,115,114,204,-1,81,206,147,-1,206,81,207,-1,190,180,189,-1,180,190,181,-1,82,74,152,-1,75,74,82,-1,61,149,150,-1,61,190,149,-1,90,127,91,-1,128,127,90,-1,157,182,11,-1,129,182,157,-1,208,46,209,-1,45,46,208,-1,18,152,74,-1,158,152,18,-1,64,168,169,-1,64,87,168,-1,66,79,167,-1,66,47,79,-1,166,210,165,-1,166,211,210,-1,144,212,213,-1,104,212,144,-1,198,162,132,-1,178,162,198,-1,214,119,121,-1,119,214,133,-1,40,31,41,-1,40,95,31,-1,44,157,156,-1,157,44,215,-1,71,209,69,-1,216,209,71,-1,60,190,61,-1,181,190,60,-1,167,85,168,-1,86,85,167,-1,153,217,83,-1,217,153,169,-1,170,148,54,-1,148,170,150,-1,13,55,16,-1,13,8,55,-1,80,35,86,-1,35,80,33,-1,151,147,206,-1,147,151,148,-1,34,217,85,-1,34,207,217,-1,89,172,171,-1,187,172,89,-1,218,219,220,-1,219,218,171,-1,184,171,173,-1,219,171,184,-1,129,185,182,-1,129,128,185,-1,104,221,212,-1,103,221,104,-1,107,145,174,-1,106,145,107,-1,109,118,117,-1,108,118,109,-1,116,110,113,-1,110,116,111,-1,145,23,203,-1,145,117,23,-1,143,174,176,-1,143,97,174,-1,22,99,19,-1,22,221,99,-1,222,197,195,-1,222,213,197,-1,27,101,28,-1,102,101,27,-1,137,139,223,-1,137,140,139,-1,127,136,224,-1,127,215,136,-1,225,192,134,-1,192,225,224,-1,134,193,132,-1,134,192,193,-1,121,93,214,-1,121,220,93,-1,131,119,162,-1,131,120,119,-1,125,121,120,-1,130,121,125,-1,211,122,124,-1,166,122,211,-1,226,165,210,-1,227,165,226,-1,228,49,48,-1,228,68,49,-1,229,227,226,-1,229,230,227,-1,140,136,43,-1,140,137,136,-1,216,208,209,-1,231,208,216,-1,232,233,234,-1,235,233,232,-1,232,228,230,-1,232,231,228,-1,139,204,29,-1,139,141,204,-1,30,191,223,-1,196,191,30,-1,162,21,131,-1,21,162,178,-1,123,199,124,-1,199,123,20,-1,210,201,226,-1,202,201,210,-1,26,233,235,-1,26,205,233,-1,25,235,229,-1,25,26,235,-1,126,218,130,-1,126,88,218,-1,205,141,233,-1,205,204,141,-1,201,229,226,-1,201,25,229,-1,200,124,199,-1,211,124,200,-1,20,131,21,-1,20,123,131,-1,194,132,193,-1,198,132,194,-1,29,223,139,-1,30,223,29,-1,235,230,229,-1,235,232,230,-1,231,68,228,-1,231,216,68,-1,234,231,232,-1,234,208,231,-1,138,233,141,-1,233,138,234,-1,215,43,136,-1,44,43,215,-1,48,230,228,-1,227,230,48,-1,50,227,48,-1,50,165,227,-1,166,126,122,-1,59,126,166,-1,218,121,130,-1,218,220,121,-1,133,225,134,-1,214,225,133,-1,93,225,214,-1,93,91,225,-1,223,135,137,-1,191,135,223,-1,224,91,127,-1,224,225,91,-1,24,116,115,-1,118,116,24,-1,114,102,27,-1,114,113,102,-1,212,22,177,-1,212,221,22,-1,174,203,175,-1,174,145,203,-1,100,222,101,-1,112,222,100,-1,113,100,102,-1,100,113,110,-1,118,111,116,-1,111,118,108,-1,97,107,174,-1,107,97,96,-1,221,98,99,-1,98,221,103,-1,112,213,222,-1,144,213,112,-1,90,183,186,-1,90,92,183,-1,78,163,56,-1,78,94,163,-1,93,219,92,-1,93,220,219,-1,184,92,219,-1,184,183,92,-1,171,88,89,-1,171,218,88,-1,53,187,89,-1,53,164,187,-1,37,236,179,-1,37,36,236,-1,206,179,151,-1,37,179,206,-1,207,83,217,-1,207,81,83,-1,36,77,236,-1,36,32,77,-1,236,58,188,-1,236,77,58,-1,169,85,217,-1,85,169,168,-1,86,79,80,-1,86,167,79,-1,77,56,58,-1,77,78,56,-1,189,76,75,-1,76,189,180,-1,160,71,70,-1,160,67,71,-1,67,216,71,-1,216,67,68,-1,154,209,46,-1,209,154,69,-1,213,177,197,-1,212,177,213,-1,57,188,58,-1,188,57,17,-1,211,202,210,-1,211,200,202,-1,45,234,138,-1,45,208,234,-1,43,138,140,-1,43,45,138,-1,215,129,157,-1,215,127,129,-1,128,186,185,-1,128,90,186,-1,150,62,61,-1,62,150,170,-1,84,75,82,-1,189,75,84,-1,207,37,206,-1,207,34,37,-1,35,32,36,-1,35,33,32,-1,204,27,29,-1,114,27,204,-1,24,205,26,-1,24,115,205,-1,203,25,201,-1,203,23,25,-1,200,175,202,-1,176,175,200,-1,20,143,199,-1,19,143,20,-1,195,198,194,-1,195,197,198,-1,195,101,222,-1,142,101,195,-1,193,196,194,-1,191,196,193,-1,135,224,136,-1,135,192,224,-1,179,188,14,-1,179,236,188,-1,146,164,10,-1,164,146,187,-1,63,160,60,-1,159,160,63,-1,42,182,185,-1,182,42,161,-1,186,95,40,-1,95,186,183,-1,184,163,94,-1,184,173,163,-1,159,10,164,-1,63,10,159,-1,9,63,62,-1,9,10,63,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpphal_Coord',point=[(-5.62545,26.38522,3.85167),(-5.58827,26.44224,3.95389),(-5.61784,26.50452,3.923),(-5.30602,26.48038,3.78147),(-5.37507,26.55409,3.70573),(-5.36575,26.57063,3.78452),(-5.3411,26.55203,3.87026),(-5.64786,26.30153,3.78649),(-5.63189,26.28422,3.8256),(-5.6606,26.37106,3.77542),(-5.67348,26.45879,3.78234),(-5.36968,26.57951,3.7836),(-5.38619,26.57034,3.71378),(-5.61782,26.28384,3.85928),(-5.60129,26.29303,3.87657),(-5.60661,26.29383,3.87971),(-5.61373,26.28312,3.85183),(-5.57906,26.33009,3.92264),(-5.33633,26.49495,3.68384),(-5.9169,27.19526,3.72586),(-5.91751,27.18482,3.73604),(-5.8518,27.24586,3.74024),(-5.85156,27.24992,3.73179),(-5.89965,27.10431,3.46411),(-5.80851,27.13369,3.44062),(-5.90013,27.0892,3.45931),(-5.80735,27.12551,3.43453),(-5.61612,27.24593,3.46913),(-5.61627,27.27181,3.51784),(-5.60473,27.24049,3.467),(-5.6025,27.26421,3.5217),(-5.47242,26.50314,3.92429),(-5.46014,26.46082,3.90122),(-5.45544,26.463,3.90052),(-5.45005,26.39473,3.81572),(-5.4436,26.40788,3.85053),(-5.44863,26.4055,3.85205),(-5.45531,26.391,3.81807),(-5.65743,26.35207,3.77644),(-5.34618,26.55285,3.87902),(-5.44193,26.57983,3.89939),(-5.41014,26.52857,3.91721),(-5.38362,26.5879,3.86244),(-5.52955,26.89449,3.64622),(-5.47614,26.76527,3.69543),(-5.54313,26.88894,3.63106),(-5.4859,26.759,3.6894),(-5.31442,26.51629,3.86871),(-5.79402,26.79682,3.65865),(-5.71297,26.6675,3.73991),(-5.80235,26.80388,3.68486),(-5.6765,26.54187,3.7699),(-5.71851,26.6704,3.75379),(-5.6779,26.54189,3.78117),(-5.64085,26.30148,3.78015),(-5.62509,26.28214,3.82115),(-5.58129,26.4481,3.95947),(-5.57768,26.39052,3.94989),(-5.56965,26.39322,3.94972),(-5.80572,26.81037,3.70291),(-5.59598,26.46422,3.77382),(-5.58563,26.40656,3.75706),(-5.65561,26.36876,3.76819),(-5.67086,26.45752,3.77736),(-5.28014,26.43381,3.72984),(-5.3024,26.45374,3.69643),(-5.28788,26.46203,3.82838),(-5.62901,26.55198,3.75838),(-5.67905,26.67163,3.71666),(-5.47465,26.6008,3.73321),(-5.52734,26.49561,3.76519),(-5.55911,26.56494,3.75024),(-5.44458,26.53548,3.72444),(-5.38223,26.54927,3.69543),(-5.34524,26.49408,3.67971),(-5.4099,26.46718,3.69589),(-5.437,26.51987,3.71995),(-5.51269,26.42384,3.93486),(-5.52633,26.47933,3.94918),(-5.31972,26.51332,3.87478),(-5.38295,26.49111,3.90088),(-5.47771,26.41048,3.75986),(-5.40236,26.45808,3.69187),(-5.36975,26.42633,3.69846),(-5.49726,26.43294,3.74745),(-5.33258,26.4068,3.79921),(-5.34486,26.43129,3.84466),(-5.26936,26.4353,3.77908),(-5.72066,26.68288,3.78911),(-5.67169,26.56363,3.82208),(-5.48534,26.65348,3.87466),(-5.53708,26.77539,3.84154),(-5.54245,26.63095,3.8873),(-5.59152,26.75429,3.86323),(-5.55934,26.53523,3.92474),(-5.50147,26.55553,3.90976),(-5.85478,27.16505,3.6087),(-5.91817,27.14835,3.63217),(-5.84101,27.1914,3.6288),(-5.88858,27.19069,3.6817),(-5.74216,27.21273,3.55786),(-5.66963,27.24682,3.53956),(-5.67235,27.23086,3.50166),(-5.81524,27.21135,3.63611),(-5.79213,27.22881,3.63134),(-5.79349,27.18288,3.58396),(-5.84978,27.15077,3.55408),(-5.85815,27.15348,3.58027),(-5.80345,27.1692,3.52856),(-5.83949,27.1535,3.54054),(-5.75657,27.19644,3.54157),(-5.77794,27.18074,3.53311),(-5.74388,27.2315,3.58776),(-5.69454,27.20067,3.4691),(-5.66878,27.20837,3.4343),(-5.73699,27.16096,3.42987),(-5.75001,27.16889,3.46317),(-5.86976,27.12396,3.49531),(-5.80736,27.14625,3.47056),(-5.74003,27.04744,3.79904),(-5.78436,27.03138,3.80169),(-5.7092,26.87271,3.83538),(-5.87348,26.94985,3.70427),(-5.90961,27.1519,3.75134),(-5.98079,27.0863,3.66979),(-5.8461,26.99408,3.76732),(-5.79213,26.81947,3.73931),(-5.48682,26.78032,3.80467),(-5.43841,26.6585,3.83638),(-5.42928,26.66183,3.82577),(-5.76896,26.847,3.80667),(-5.83784,27.20088,3.76401),(-5.70481,27.25965,3.72512),(-5.69571,27.0635,3.79638),(-5.65099,27.09309,3.76115),(-5.56548,27.08479,3.64966),(-5.52587,26.90479,3.70931),(-5.55361,27.07329,3.61492),(-5.58869,27.03546,3.53104),(-5.57945,27.19597,3.46687),(-5.56371,27.05896,3.55709),(-5.64031,27.1555,3.42393),(-5.63506,27.28793,3.56692),(-5.98058,27.13509,3.6475),(-5.76875,27.23901,3.61794),(-5.91034,27.12037,3.53014),(-5.65621,26.49105,3.84009),(-5.48931,26.40496,3.76118),(-5.56285,26.3432,3.76737),(-5.50258,26.43105,3.74913),(-5.58498,26.39519,3.75711),(-5.54608,26.32943,3.79054),(-5.33357,26.47713,3.67504),(-5.30776,26.44764,3.6923),(-5.43029,26.62917,3.72827),(-5.39356,26.56465,3.70367),(-5.41802,26.62884,3.72952),(-5.41917,26.6519,3.7871),(-5.32666,26.48019,3.67838),(-5.67144,26.47382,3.77758),(-5.60063,26.48126,3.77589),(-5.37232,26.58773,3.85248),(-5.7686,27.24223,3.7487),(-5.60999,26.51167,3.92579),(-5.67438,26.47597,3.7842),(-5.88933,26.9038,3.62507),(-5.88758,26.91942,3.65639),(-5.2925,26.45734,3.83476),(-5.2749,26.43046,3.78187),(-5.28599,26.42932,3.73034),(-5.65235,26.35336,3.7693),(-5.64297,26.59548,3.88384),(-5.62255,26.52041,3.91591),(-5.61725,26.52564,3.91817),(-5.92956,27.12666,3.57227),(-5.99384,27.0932,3.55852),(-5.99365,27.10329,3.58457),(-5.79201,27.29657,3.71673),(-5.78557,27.28917,3.72715),(-5.52665,26.33001,3.83556),(-5.52274,26.48654,3.76454),(-5.52353,26.48631,3.76476),(-5.38426,26.60086,3.84681),(-5.51004,26.57078,3.90521),(-5.56786,26.54992,3.91851),(-5.39705,26.60127,3.85799),(-5.45107,26.59456,3.89427),(-5.657,26.50508,3.8364),(-5.57213,26.3302,3.92062),(-5.50251,26.44313,3.74856),(-5.50778,26.44211,3.75014),(-5.5956,27.243,3.5919),(-5.58542,27.10411,3.70803),(-5.61888,27.26127,3.64792),(-5.64513,27.30079,3.63573),(-5.65823,27.31091,3.62699),(-5.62075,27.27741,3.57774),(-5.73055,27.31843,3.6926),(-5.72283,27.31212,3.7039),(-5.98486,27.12426,3.65449),(-5.99782,27.09054,3.59357),(-5.9726,27.07254,3.50104),(-5.99941,27.07921,3.55759),(-5.96772,27.08774,3.50421),(-5.6615,27.19807,3.42768),(-5.73398,27.1517,3.42354),(-5.47494,26.39695,3.77714),(-5.46882,26.40009,3.77475),(-5.60287,26.86259,3.61703),(-5.53569,26.72498,3.68971),(-6.00089,27.0271,3.55847),(-5.99453,27.05319,3.61037),(-5.79168,27.26354,3.67139),(-5.75045,27.27928,3.65469),(-5.65474,26.90262,3.83613),(-5.47356,26.77241,3.75769),(-5.61641,26.69151,3.69763),(-5.34247,26.40448,3.73884),(-5.69641,26.70878,3.85034),(-5.60136,26.61223,3.89506),(-5.65065,26.73279,3.86657),(-5.83563,27.23687,3.68816),(-5.69962,27.2732,3.60654),(-5.57266,27.2264,3.53649),(-5.54028,26.9282,3.76684),(-5.58914,26.92307,3.80183),(-5.97642,27.01553,3.50464),(-5.88061,26.90782,3.57475),(-5.74976,26.8041,3.63367),(-5.89545,27.03506,3.46184),(-5.83269,26.92854,3.54284),(-5.6815,26.82668,3.62412),(-5.7462,26.96998,3.51817),(-5.72013,27.10744,3.42024),(-5.66388,27.00075,3.51651),(-5.79436,27.07019,3.42945),(-5.50425,26.36075,3.88784)]))),
        Shape(DEF='rpphal2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rpphal2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,5,6,3,-1,7,8,9,-1,10,11,12,-1,12,13,10,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,21,26,22,-1,21,24,26,-1,27,28,29,-1,30,31,29,-1,29,28,30,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,38,41,39,-1,42,43,44,-1,36,45,46,-1,36,47,45,-1,9,8,48,-1,49,50,51,-1,52,53,54,-1,52,55,53,-1,56,57,58,-1,56,16,57,-1,59,60,61,-1,60,62,61,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,71,72,69,-1,73,74,75,-1,76,77,75,-1,78,79,80,-1,81,82,70,-1,78,81,83,-1,78,80,81,-1,14,84,85,-1,84,86,85,-1,87,57,88,-1,87,58,57,-1,19,89,17,-1,90,91,92,-1,17,93,94,-1,94,95,17,-1,17,96,18,-1,34,1,0,-1,0,32,34,-1,97,98,99,-1,99,100,97,-1,101,102,103,-1,103,104,101,-1,105,77,76,-1,105,106,77,-1,56,68,67,-1,107,108,109,-1,107,110,108,-1,111,112,113,-1,114,40,115,-1,111,116,117,-1,117,118,119,-1,120,121,117,-1,117,122,123,-1,117,124,125,-1,117,114,126,-1,19,127,128,-1,128,89,19,-1,129,130,131,-1,130,132,131,-1,130,133,134,-1,44,135,42,-1,44,136,135,-1,137,138,139,-1,137,140,138,-1,7,141,137,-1,137,8,7,-1,142,143,144,-1,144,145,142,-1,94,20,95,-1,94,146,20,-1,3,6,147,-1,6,148,147,-1,79,52,54,-1,79,149,80,-1,79,150,151,-1,16,15,152,-1,16,152,153,-1,16,56,67,-1,16,67,154,-1,155,156,29,-1,156,27,29,-1,147,148,157,-1,157,158,147,-1,159,160,31,-1,31,161,159,-1,162,163,164,-1,165,166,55,-1,55,167,165,-1,64,168,65,-1,62,169,72,-1,62,170,169,-1,171,168,50,-1,171,85,168,-1,172,173,174,-1,174,175,172,-1,173,172,176,-1,172,177,176,-1,174,178,175,-1,174,179,178,-1,69,167,55,-1,55,83,69,-1,180,10,13,-1,180,181,10,-1,163,87,164,-1,182,183,184,-1,182,185,183,-1,186,183,187,-1,186,184,183,-1,16,188,57,-1,154,84,16,-1,16,153,188,-1,189,190,191,-1,191,192,189,-1,193,194,150,-1,79,195,73,-1,79,151,149,-1,79,78,52,-1,79,54,195,-1,80,196,81,-1,73,150,79,-1,5,53,197,-1,18,26,19,-1,26,198,19,-1,199,200,201,-1,33,202,42,-1,203,204,136,-1,40,39,36,-1,36,115,40,-1,205,206,207,-1,207,208,205,-1,117,116,114,-1,126,124,117,-1,125,122,117,-1,117,123,120,-1,117,121,118,-1,117,119,111,-1,114,209,38,-1,64,210,170,-1,64,181,210,-1,211,109,108,-1,212,110,107,-1,213,202,32,-1,202,33,32,-1,22,96,95,-1,95,20,22,-1,94,93,129,-1,129,131,94,-1,146,214,215,-1,215,216,146,-1,217,201,200,-1,42,202,218,-1,128,90,89,-1,128,219,90,-1,220,221,222,-1,222,134,220,-1,17,95,96,-1,91,223,92,-1,224,225,68,-1,68,163,224,-1,224,163,162,-1,75,74,226,-1,226,76,75,-1,53,5,4,-1,77,107,109,-1,109,193,77,-1,75,77,73,-1,53,55,166,-1,70,69,83,-1,83,81,70,-1,170,62,60,-1,59,61,179,-1,179,227,59,-1,228,229,230,-1,68,56,58,-1,52,78,83,-1,83,55,52,-1,171,50,49,-1,43,47,44,-1,35,136,44,-1,114,38,40,-1,37,36,39,-1,167,72,169,-1,167,69,72,-1,182,28,27,-1,27,185,182,-1,103,102,25,-1,102,187,25,-1,216,103,21,-1,168,85,65,-1,67,231,232,-1,232,154,67,-1,15,14,171,-1,14,85,171,-1,84,14,16,-1,102,13,12,-1,74,73,195,-1,3,226,4,-1,233,6,5,-1,195,226,74,-1,226,195,4,-1,234,154,232,-1,84,154,234,-1,63,181,64,-1,63,10,181,-1,84,11,86,-1,84,234,11,-1,85,63,65,-1,86,63,85,-1,100,235,204,-1,235,100,236,-1,187,12,186,-1,102,12,187,-1,225,66,68,-1,66,225,161,-1,237,167,169,-1,165,167,237,-1,238,145,217,-1,238,239,145,-1,166,191,240,-1,166,165,191,-1,37,41,203,-1,37,39,41,-1,23,26,24,-1,23,198,26,-1,241,36,46,-1,115,36,241,-1,242,230,229,-1,243,230,242,-1,176,244,173,-1,176,245,244,-1,174,227,179,-1,246,227,174,-1,147,105,76,-1,105,147,158,-1,195,53,4,-1,53,195,54,-1,106,107,77,-1,107,106,212,-1,60,50,168,-1,60,59,50,-1,247,152,49,-1,153,152,247,-1,248,153,247,-1,188,153,248,-1,249,250,196,-1,249,251,250,-1,211,193,109,-1,211,194,193,-1,228,225,224,-1,252,225,228,-1,132,134,222,-1,130,134,132,-1,36,44,47,-1,36,35,44,-1,133,253,254,-1,255,253,133,-1,256,46,257,-1,256,241,46,-1,97,258,98,-1,209,258,97,-1,205,259,260,-1,112,259,205,-1,261,93,223,-1,129,93,261,-1,130,255,133,-1,255,130,262,-1,263,42,218,-1,43,42,263,-1,5,264,233,-1,5,197,264,-1,201,221,199,-1,201,144,221,-1,238,264,265,-1,264,238,213,-1,104,216,215,-1,103,216,104,-1,214,94,131,-1,146,94,214,-1,156,157,266,-1,157,156,155,-1,104,267,101,-1,104,268,267,-1,204,135,136,-1,135,204,235,-1,180,210,181,-1,180,269,210,-1,119,219,259,-1,118,219,119,-1,223,120,261,-1,223,121,120,-1,223,91,121,-1,262,122,255,-1,122,262,123,-1,125,256,253,-1,124,256,125,-1,99,208,207,-1,208,99,98,-1,260,206,205,-1,260,270,206,-1,199,220,271,-1,221,220,199,-1,254,271,220,-1,257,271,254,-1,45,43,263,-1,47,43,45,-1,238,202,213,-1,202,238,217,-1,239,142,145,-1,239,272,142,-1,25,183,9,-1,25,187,183,-1,141,156,273,-1,141,27,156,-1,266,0,274,-1,266,275,0,-1,276,2,236,-1,2,276,277,-1,140,274,277,-1,140,273,274,-1,48,198,23,-1,48,278,198,-1,214,279,215,-1,280,279,214,-1,144,222,221,-1,144,143,222,-1,218,199,263,-1,218,200,199,-1,207,276,99,-1,207,138,276,-1,139,270,281,-1,139,206,270,-1,19,278,127,-1,19,198,278,-1,131,280,214,-1,131,132,280,-1,194,151,150,-1,282,151,194,-1,166,197,53,-1,166,240,197,-1,196,149,249,-1,80,149,196,-1,275,6,233,-1,275,148,6,-1,66,231,67,-1,66,30,231,-1,192,267,189,-1,269,267,192,-1,186,232,184,-1,232,186,234,-1,184,231,182,-1,231,184,232,-1,157,160,158,-1,157,155,160,-1,212,230,110,-1,230,212,228,-1,242,162,164,-1,242,229,162,-1,269,237,210,-1,269,192,237,-1,178,61,71,-1,179,61,178,-1,108,176,177,-1,176,108,243,-1,178,250,175,-1,178,82,250,-1,247,283,248,-1,247,284,283,-1,51,246,284,-1,227,246,51,-1,87,285,164,-1,285,87,88,-1,285,248,283,-1,285,88,248,-1,268,215,279,-1,268,104,215,-1,272,190,189,-1,190,272,239,-1,189,268,272,-1,189,267,268,-1,245,283,244,-1,245,285,283,-1,284,244,283,-1,284,246,244,-1,242,285,245,-1,242,164,285,-1,251,175,250,-1,172,175,251,-1,284,49,51,-1,284,247,49,-1,178,70,82,-1,178,71,70,-1,286,172,251,-1,172,286,177,-1,177,211,108,-1,177,286,211,-1,50,227,51,-1,59,227,50,-1,170,168,64,-1,60,168,170,-1,169,210,237,-1,170,210,169,-1,165,192,191,-1,237,192,165,-1,110,243,108,-1,243,110,230,-1,224,229,228,-1,224,162,229,-1,158,159,105,-1,158,160,159,-1,30,182,231,-1,30,28,182,-1,160,29,31,-1,160,155,29,-1,157,275,266,-1,157,148,275,-1,101,13,102,-1,13,101,180,-1,149,282,249,-1,151,282,149,-1,143,132,222,-1,280,132,143,-1,127,281,270,-1,127,278,281,-1,206,138,207,-1,206,139,138,-1,99,236,100,-1,99,276,236,-1,142,280,143,-1,280,142,279,-1,20,216,21,-1,146,216,20,-1,23,9,48,-1,23,25,9,-1,137,281,8,-1,137,139,281,-1,273,137,141,-1,273,140,137,-1,277,138,140,-1,277,276,138,-1,274,2,277,-1,274,0,2,-1,266,273,156,-1,273,266,274,-1,233,213,32,-1,233,264,213,-1,185,9,183,-1,7,9,185,-1,279,272,268,-1,272,279,142,-1,218,217,200,-1,218,202,217,-1,45,257,46,-1,257,45,271,-1,220,133,254,-1,134,133,220,-1,271,263,199,-1,271,45,263,-1,17,223,93,-1,17,92,223,-1,270,128,127,-1,270,260,128,-1,124,241,256,-1,126,241,124,-1,255,125,253,-1,125,255,122,-1,261,123,262,-1,123,261,120,-1,118,90,219,-1,91,118,121,-1,118,91,90,-1,111,259,112,-1,119,259,111,-1,258,111,113,-1,111,258,116,-1,77,150,73,-1,193,150,77,-1,197,265,264,-1,197,240,265,-1,209,116,258,-1,209,114,116,-1,135,1,34,-1,135,235,1,-1,101,269,180,-1,101,267,269,-1,144,217,145,-1,201,217,144,-1,275,32,0,-1,233,32,275,-1,208,112,205,-1,113,112,208,-1,259,128,260,-1,259,219,128,-1,98,113,208,-1,258,113,98,-1,41,209,97,-1,38,209,41,-1,253,257,254,-1,253,256,257,-1,129,262,130,-1,261,262,129,-1,90,17,89,-1,90,92,17,-1,286,194,211,-1,194,286,282,-1,212,252,228,-1,106,252,212,-1,58,163,68,-1,58,87,163,-1,249,286,251,-1,249,282,286,-1,88,188,248,-1,57,188,88,-1,196,82,81,-1,196,250,82,-1,49,15,171,-1,152,15,49,-1,72,61,62,-1,72,71,61,-1,226,147,76,-1,147,226,3,-1,252,161,225,-1,159,161,252,-1,105,252,106,-1,105,159,252,-1,173,246,174,-1,173,244,246,-1,243,245,176,-1,243,242,245,-1,8,278,48,-1,8,281,278,-1,115,126,114,-1,115,241,126,-1,35,203,136,-1,35,37,203,-1,239,265,190,-1,239,238,265,-1,240,190,265,-1,240,191,190,-1,34,42,135,-1,33,42,34,-1,161,30,66,-1,30,161,31,-1,27,7,185,-1,7,27,141,-1,25,21,103,-1,25,24,21,-1,11,186,12,-1,234,186,11,-1,26,96,22,-1,18,96,26,-1,204,97,100,-1,203,97,204,-1,203,41,97,-1,235,2,1,-1,235,236,2,-1,86,10,63,-1,86,11,10,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpphal2_Coord',point=[(-6.75773,26.11857,4.34323),(-6.7767,26.35359,4.26848),(-6.81677,26.3541,4.26339),(-6.54214,25.57048,4.51947),(-6.49932,25.56273,4.50253),(-6.53527,25.675,4.46601),(-6.57604,25.65811,4.47244),(-6.90522,26.01273,4.15501),(-6.9996,26.21307,4.02363),(-6.88256,25.9999,4.10706),(-6.63851,25.44888,4.2203),(-6.64741,25.4443,4.21044),(-6.68867,25.55564,4.20745),(-6.67483,25.56088,4.21387),(-6.61729,25.37715,4.19004),(-6.58763,25.32767,4.17942),(-6.60435,25.31446,4.2303),(-6.90433,26.43957,3.7625),(-6.88696,26.32967,3.74519),(-6.92957,26.3452,3.75918),(-6.82774,26.25219,3.80275),(-6.83986,26.13424,3.93158),(-6.85581,26.24278,3.7905),(-6.90692,26.15219,3.94297),(-6.86265,26.13147,3.92605),(-6.83697,25.98197,4.06231),(-6.88,26.24399,3.79408),(-6.84587,25.79356,4.27757),(-6.76007,25.55789,4.33143),(-6.75661,25.57082,4.36384),(-6.72547,25.45102,4.36321),(-6.71112,25.47666,4.38802),(-6.67607,26.1278,4.33005),(-6.68595,26.34914,4.26762),(-6.73554,26.35307,4.27371),(-6.77512,26.67477,4.16744),(-6.75739,26.69858,4.13663),(-6.78873,26.68277,4.15369),(-6.8361,26.67025,4.12873),(-6.79867,26.68872,4.14674),(-6.81196,26.68674,4.12923),(-6.83031,26.67002,4.15476),(-6.68446,26.47877,4.2398),(-6.677,26.62302,4.19617),(-6.73686,26.63045,4.21091),(-6.66914,26.67404,4.15148),(-6.71856,26.69841,4.12131),(-6.69708,26.65605,4.176),(-6.96111,26.184,3.97276),(-6.55206,25.27243,4.18503),(-6.52134,25.38714,4.22622),(-6.49979,25.3328,4.23294),(-6.37845,25.53715,4.43691),(-6.45294,25.5786,4.46178),(-6.44665,25.56667,4.4649),(-6.39286,25.53639,4.41364),(-6.67409,25.30746,4.33533),(-6.63361,25.22902,4.32655),(-6.65665,25.25321,4.35666),(-6.47188,25.42348,4.29395),(-6.48005,25.43256,4.29645),(-6.46497,25.4272,4.29709),(-6.47588,25.43702,4.30273),(-6.61869,25.42122,4.21564),(-6.57351,25.40385,4.22907),(-6.57283,25.40829,4.21683),(-6.71597,25.39903,4.37181),(-6.69198,25.35906,4.3213),(-6.69467,25.30765,4.38083),(-6.34668,25.5042,4.39165),(-6.33622,25.49445,4.38833),(-6.40073,25.47595,4.33913),(-6.40852,25.48332,4.34451),(-6.47319,25.49165,4.53142),(-6.49855,25.51879,4.53266),(-6.50573,25.50152,4.54227),(-6.53195,25.50098,4.5428),(-6.47964,25.43821,4.5613),(-6.35127,25.49765,4.44308),(-6.40285,25.4923,4.48335),(-6.34235,25.46159,4.46212),(-6.31652,25.46949,4.42777),(-6.31328,25.45889,4.40437),(-6.337,25.49969,4.40957),(-6.64986,25.42065,4.21976),(-6.61075,25.39468,4.18814),(-6.63462,25.42311,4.20625),(-6.65689,25.24682,4.37012),(-6.63123,25.22696,4.34305),(-6.95789,26.44186,3.77758),(-6.94428,26.46132,3.78803),(-6.88873,26.46384,3.80357),(-6.90023,26.46403,3.77828),(-6.8536,26.45499,3.77122),(-6.79652,26.35529,3.76579),(-6.82848,26.33835,3.75255),(-6.86294,26.3333,3.74209),(-6.87374,26.63665,4.15314),(-6.95669,26.56776,4.12624),(-6.96946,26.53399,4.15562),(-6.86257,26.58293,4.19191),(-6.69523,25.7799,4.18172),(-6.75378,25.7709,4.15341),(-6.80328,25.9774,4.06407),(-6.74545,26.01133,4.10811),(-6.5905,25.49477,4.49449),(-6.5755,25.46612,4.50312),(-6.50259,25.42909,4.55826),(-6.5179,25.37745,4.52605),(-6.47442,25.41441,4.55932),(-6.55019,25.41851,4.52684),(-6.9497,26.51024,4.00019),(-7.0436,26.51094,3.97702),(-7.00637,26.5259,4.05445),(-6.83832,26.58255,4.05716),(-6.77262,26.69104,4.11596),(-6.89283,26.55279,4.04772),(-6.84323,26.51896,3.99734),(-6.91963,26.47561,3.89415),(-6.95699,26.49249,3.94164),(-6.80753,26.49224,3.88107),(-6.85792,26.47464,3.87647),(-6.74236,26.54957,3.93567),(-6.76643,26.51703,3.89882),(-6.7507,26.59673,4.01615),(-6.73175,26.57531,3.97038),(-6.78857,26.60584,4.04944),(-7.0104,26.36852,3.82059),(-7.00195,26.45309,3.79994),(-6.7786,26.49101,3.80615),(-6.71333,26.52204,3.84951),(-6.73336,26.39914,3.81971),(-6.66731,26.44516,3.8783),(-6.65783,26.58429,3.92095),(-6.63432,26.55647,3.93495),(-6.77089,26.48151,4.24542),(-6.79818,26.61011,4.20671),(-7.00769,26.2437,4.0922),(-7.0148,26.39738,4.13928),(-7.05901,26.34492,4.04741),(-6.98339,26.29319,4.18365),(-6.9208,26.02158,4.188),(-6.59758,26.28296,4.10705),(-6.57448,26.4043,4.02172),(-6.55468,26.44062,4.09213),(-6.59003,26.32903,4.15798),(-6.79366,26.26749,3.82777),(-6.57045,25.56654,4.5149),(-6.60321,25.64684,4.47672),(-6.36255,25.42747,4.50234),(-6.42664,25.4424,4.53873),(-6.39181,25.42331,4.52786),(-6.56508,25.27087,4.18725),(-6.56672,25.23316,4.22508),(-6.6713,25.41233,4.26366),(-6.71708,25.59981,4.42427),(-6.8239,25.83412,4.36011),(-6.66249,25.6249,4.46422),(-6.61587,25.53921,4.47956),(-6.64771,25.47646,4.45273),(-6.67095,25.51556,4.43932),(-6.69745,25.4349,4.40208),(-6.67158,25.35012,4.4331),(-6.68558,25.30314,4.40443),(-6.63832,25.29585,4.43278),(-6.44553,25.59078,4.39825),(-6.44309,25.59209,4.41002),(-6.39996,25.53104,4.40686),(-6.52829,25.39322,4.22515),(-6.44315,25.49854,4.36565),(-6.49716,25.44977,4.3129),(-6.58016,25.35122,4.17359),(-6.39521,25.32539,4.44283),(-6.48072,25.31974,4.39466),(-6.45268,25.33672,4.34914),(-6.36768,25.36587,4.38521),(-6.53188,25.3231,4.44406),(-6.45548,25.33945,4.49583),(-6.38177,25.43049,4.34787),(-6.44813,25.3938,4.30125),(-6.64266,25.57227,4.22891),(-6.60887,25.46005,4.24448),(-6.7567,25.55741,4.30138),(-6.81252,25.7714,4.1898),(-6.72798,25.54708,4.25183),(-6.83114,25.78379,4.23881),(-6.70591,25.53964,4.21277),(-6.7821,25.76577,4.15052),(-6.59465,25.21318,4.29071),(-6.56501,25.86232,4.27898),(-6.54998,25.88987,4.31244),(-6.49073,25.6847,4.38865),(-6.52176,25.64853,4.34496),(-6.4521,25.4226,4.55677),(-6.41916,25.39801,4.55306),(-6.48741,25.55364,4.50236),(-6.30694,25.42536,4.45198),(-6.50282,25.68515,4.43259),(-6.92549,26.26226,3.82255),(-6.57466,26.58321,4.11822),(-6.56635,26.47417,4.17862),(-6.56038,26.45962,4.13653),(-6.62918,26.34466,4.24948),(-6.81931,26.64814,4.17106),(-6.83066,26.5964,4.19924),(-7.05944,26.50267,3.97442),(-7.07987,26.4324,4.01065),(-7.03455,26.48679,4.10626),(-7.0188,26.51794,4.07118),(-6.87057,26.64038,4.12391),(-6.5337,25.51062,4.30787),(-6.42875,25.38364,4.55268),(-6.57693,25.45255,4.51872),(-6.62434,26.12338,4.29021),(-6.73482,26.31125,3.89369),(-6.75001,26.1848,3.99077),(-6.81665,26.14728,3.95138),(-6.59024,26.3427,4.19158),(-6.60309,26.47449,4.21659),(-6.98685,26.46919,3.81341),(-6.60375,26.60362,4.00384),(-6.56202,26.54021,4.04208),(-6.58398,26.49692,3.96493),(-6.87135,26.46858,3.7817),(-6.68649,25.37721,4.42808),(-6.68378,25.39315,4.41614),(-6.51501,25.53476,4.53248),(-6.45257,25.39038,4.29746),(-6.63668,25.43264,4.47493),(-6.61831,25.38763,4.47794),(-6.61336,25.39052,4.48179),(-6.71831,25.44199,4.32396),(-6.68566,25.43881,4.26612),(-6.61493,25.91291,4.39142),(-6.65989,25.44028,4.21953),(-6.8097,26.47815,4.23689),(-6.83956,26.47555,4.23034),(-6.48417,25.56032,4.35432),(-6.59291,26.12685,4.2474),(-6.59119,26.11997,4.23098),(-6.48993,25.68801,4.39975),(-6.7385,26.69154,4.10232),(-6.58739,25.34773,4.47586),(-6.58264,25.35094,4.47954),(-6.48563,25.31721,4.39126),(-6.5365,25.32012,4.44),(-6.4572,25.33367,4.34544),(-6.55524,25.23127,4.22671),(-6.585,25.20854,4.29933),(-6.33305,25.37726,4.5023),(-6.29852,25.40264,4.43098),(-6.32594,25.35884,4.4891),(-6.63418,25.44883,4.46083),(-6.65159,26.63348,3.97725),(-6.63552,26.63212,3.97934),(-6.67218,26.58937,3.9234),(-6.67994,26.66316,4.0287),(-6.65961,26.66732,4.04228),(-6.9424,26.57668,4.10184),(-7.03657,26.4933,3.89185),(-7.05505,26.48262,3.8854),(-6.78394,26.50074,3.81605),(-6.72704,26.52854,3.85572),(-6.6235,26.61638,4.183),(-6.57693,25.91013,4.35538),(-6.55085,25.89382,4.32424),(-6.75999,25.86719,4.40508),(-6.63072,25.81414,4.22823),(-6.67383,26.03951,4.1562),(-6.57259,25.60808,4.29202),(-7.07077,26.40347,3.91031),(-6.61973,26.65259,4.08418),(-6.60647,26.09355,4.20058),(-6.90423,26.06281,4.28019),(-6.83489,26.09668,4.32695),(-6.69076,25.89078,4.4111),(-6.94949,26.43886,4.1968),(-6.91388,26.33528,4.24036),(-6.98497,26.27894,3.87872),(-6.67696,26.23318,4.04339),(-6.66238,26.35725,3.95027),(-7.05427,26.30457,3.97049),(-6.38123,25.38305,4.53698),(-6.54601,25.24338,4.33734),(-6.50526,25.26903,4.26772),(-6.59743,25.26409,4.39807),(-6.38895,25.365,4.53726)]))),
        Shape(DEF='rpphal3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rpphal3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,6,9,7,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,3,22,4,-1,23,24,25,-1,25,26,23,-1,27,28,29,-1,27,30,28,-1,31,32,25,-1,33,34,35,-1,35,36,33,-1,37,38,39,-1,38,40,39,-1,41,42,43,-1,41,44,45,-1,41,46,42,-1,41,47,48,-1,41,45,49,-1,41,50,51,-1,41,52,53,-1,41,54,44,-1,41,43,55,-1,56,57,58,-1,56,53,57,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,65,68,66,-1,69,70,71,-1,72,73,74,-1,74,75,72,-1,76,77,78,-1,78,79,76,-1,80,81,82,-1,82,4,80,-1,83,84,85,-1,84,18,85,-1,86,87,88,-1,87,89,88,-1,90,9,38,-1,9,6,38,-1,18,17,91,-1,92,5,93,-1,92,3,5,-1,94,95,96,-1,96,97,94,-1,31,28,98,-1,22,3,88,-1,31,29,28,-1,31,99,32,-1,31,100,101,-1,102,91,80,-1,102,103,91,-1,104,105,106,-1,106,103,102,-1,107,104,106,-1,12,30,10,-1,30,108,10,-1,11,109,110,-1,111,112,113,-1,111,114,112,-1,115,116,2,-1,115,117,116,-1,77,2,118,-1,2,116,118,-1,106,22,107,-1,106,119,103,-1,106,102,22,-1,105,120,106,-1,106,120,119,-1,80,4,22,-1,22,102,80,-1,17,121,122,-1,123,124,125,-1,123,126,124,-1,31,127,100,-1,31,101,99,-1,31,25,24,-1,31,98,127,-1,128,59,129,-1,129,130,128,-1,131,132,133,-1,131,134,132,-1,135,136,137,-1,94,97,138,-1,138,139,94,-1,21,16,84,-1,16,18,84,-1,26,78,140,-1,26,79,78,-1,141,126,142,-1,141,124,126,-1,92,115,86,-1,115,143,86,-1,72,79,73,-1,79,26,73,-1,144,145,140,-1,140,78,144,-1,141,146,124,-1,146,62,124,-1,62,147,63,-1,62,146,147,-1,59,148,60,-1,59,128,148,-1,54,149,150,-1,54,48,149,-1,41,51,52,-1,41,49,50,-1,41,56,46,-1,41,48,54,-1,41,53,56,-1,29,31,24,-1,151,4,82,-1,151,5,4,-1,151,82,152,-1,121,17,16,-1,47,41,55,-1,21,84,19,-1,110,153,11,-1,8,93,5,-1,8,7,93,-1,154,10,108,-1,122,155,156,-1,157,158,159,-1,158,157,160,-1,160,161,162,-1,161,160,157,-1,163,164,165,-1,163,166,164,-1,167,135,137,-1,167,168,135,-1,169,170,171,-1,169,13,170,-1,121,155,122,-1,171,155,121,-1,154,172,10,-1,173,172,154,-1,10,109,11,-1,10,172,109,-1,16,20,169,-1,16,21,20,-1,92,88,3,-1,86,88,92,-1,32,74,73,-1,74,32,99,-1,101,174,175,-1,174,101,100,-1,176,98,12,-1,176,127,98,-1,23,177,27,-1,177,23,178,-1,179,123,180,-1,179,181,123,-1,182,50,183,-1,51,50,182,-1,49,184,185,-1,49,45,184,-1,149,47,186,-1,48,47,149,-1,42,187,188,-1,42,46,187,-1,134,69,189,-1,134,131,69,-1,138,60,148,-1,138,97,60,-1,190,182,191,-1,182,190,192,-1,90,37,193,-1,90,38,37,-1,194,195,196,-1,194,197,195,-1,198,146,199,-1,146,198,147,-1,200,201,202,-1,203,201,200,-1,204,205,206,-1,205,204,207,-1,208,209,210,-1,208,211,209,-1,212,213,214,-1,215,213,212,-1,145,142,126,-1,144,142,145,-1,140,23,26,-1,140,178,23,-1,216,174,217,-1,216,175,174,-1,2,143,115,-1,1,143,2,-1,218,219,220,-1,218,221,219,-1,222,223,224,-1,222,225,223,-1,63,215,212,-1,215,63,147,-1,108,27,177,-1,27,108,30,-1,12,153,176,-1,12,11,153,-1,226,227,228,-1,226,229,227,-1,230,190,231,-1,230,232,190,-1,233,234,235,-1,233,191,234,-1,236,237,238,-1,236,239,237,-1,133,240,131,-1,133,241,240,-1,236,139,242,-1,236,94,139,-1,243,239,244,-1,235,239,243,-1,233,245,231,-1,233,246,245,-1,247,248,249,-1,247,135,248,-1,250,207,251,-1,209,207,250,-1,107,88,89,-1,107,22,88,-1,105,219,221,-1,105,104,219,-1,157,252,161,-1,253,252,157,-1,254,165,255,-1,254,162,165,-1,256,156,257,-1,256,258,156,-1,226,259,260,-1,226,230,259,-1,234,185,237,-1,183,185,234,-1,184,95,238,-1,184,261,95,-1,96,149,61,-1,150,149,96,-1,262,263,186,-1,262,241,263,-1,240,188,70,-1,264,188,240,-1,187,228,227,-1,187,58,228,-1,265,189,213,-1,265,134,189,-1,130,266,267,-1,130,132,266,-1,148,268,138,-1,268,148,224,-1,269,242,139,-1,270,242,269,-1,270,244,242,-1,270,271,244,-1,243,272,246,-1,273,272,243,-1,274,275,276,-1,275,274,214,-1,260,277,278,-1,260,259,277,-1,229,260,276,-1,260,229,226,-1,275,69,71,-1,275,189,69,-1,133,130,129,-1,132,130,133,-1,64,212,279,-1,212,64,63,-1,201,280,125,-1,280,201,203,-1,281,64,279,-1,281,202,64,-1,282,202,281,-1,282,200,202,-1,283,277,284,-1,282,277,283,-1,272,283,284,-1,272,251,283,-1,207,283,251,-1,207,204,283,-1,248,206,205,-1,206,248,285,-1,271,286,287,-1,271,270,286,-1,250,210,209,-1,250,287,210,-1,270,288,286,-1,269,288,270,-1,40,33,65,-1,33,40,34,-1,289,194,112,-1,197,194,289,-1,290,198,196,-1,198,290,291,-1,292,193,225,-1,195,193,292,-1,293,67,288,-1,67,293,39,-1,293,224,223,-1,293,268,224,-1,290,267,266,-1,292,267,290,-1,291,266,265,-1,290,266,291,-1,177,167,108,-1,177,179,167,-1,179,168,167,-1,179,180,168,-1,168,280,285,-1,180,280,168,-1,294,220,87,-1,294,295,220,-1,296,82,81,-1,296,152,82,-1,119,85,18,-1,119,120,85,-1,120,221,85,-1,120,105,221,-1,33,258,256,-1,258,33,36,-1,258,152,296,-1,258,36,152,-1,256,65,33,-1,68,65,256,-1,156,296,122,-1,296,156,258,-1,297,135,247,-1,297,136,135,-1,7,289,298,-1,289,7,9,-1,298,93,7,-1,298,117,93,-1,116,111,118,-1,114,111,116,-1,77,144,78,-1,77,118,144,-1,1,294,143,-1,1,166,294,-1,164,76,299,-1,76,164,0,-1,255,164,299,-1,255,165,164,-1,217,254,216,-1,217,300,254,-1,153,300,217,-1,110,300,153,-1,294,163,295,-1,166,163,294,-1,253,159,19,-1,253,157,159,-1,141,199,146,-1,141,113,199,-1,194,113,112,-1,194,199,113,-1,83,19,84,-1,83,253,19,-1,218,253,83,-1,218,252,253,-1,110,160,300,-1,110,158,160,-1,216,255,75,-1,216,254,255,-1,255,72,75,-1,255,299,72,-1,79,299,76,-1,79,72,299,-1,92,117,115,-1,117,92,93,-1,144,111,142,-1,144,118,111,-1,114,117,298,-1,114,116,117,-1,112,298,289,-1,112,114,298,-1,113,142,111,-1,142,113,141,-1,109,158,110,-1,15,158,109,-1,171,297,155,-1,297,171,170,-1,136,154,137,-1,136,173,154,-1,247,155,297,-1,155,247,156,-1,156,249,257,-1,156,247,249,-1,135,285,248,-1,135,168,285,-1,35,152,36,-1,152,35,151,-1,91,119,18,-1,103,119,91,-1,122,81,17,-1,122,296,81,-1,126,181,145,-1,126,123,181,-1,178,145,181,-1,140,145,178,-1,265,215,291,-1,265,213,215,-1,225,267,292,-1,222,267,225,-1,268,288,269,-1,288,268,293,-1,223,39,293,-1,37,39,223,-1,196,292,290,-1,196,195,292,-1,291,147,198,-1,147,291,215,-1,289,90,197,-1,9,90,289,-1,66,288,67,-1,286,288,66,-1,66,287,286,-1,287,66,210,-1,273,287,250,-1,271,287,273,-1,211,257,249,-1,211,208,257,-1,204,282,283,-1,282,204,200,-1,251,273,250,-1,272,273,251,-1,285,203,206,-1,203,285,280,-1,278,282,281,-1,278,277,282,-1,281,274,278,-1,279,274,281,-1,125,62,201,-1,124,62,125,-1,214,279,212,-1,214,274,279,-1,276,71,229,-1,276,275,71,-1,259,284,277,-1,284,259,245,-1,278,276,260,-1,276,278,274,-1,284,246,272,-1,284,245,246,-1,244,273,243,-1,271,273,244,-1,139,268,269,-1,268,139,138,-1,263,59,61,-1,263,129,59,-1,222,130,267,-1,222,128,130,-1,266,134,265,-1,266,132,134,-1,57,52,192,-1,53,52,57,-1,227,188,187,-1,188,227,70,-1,241,264,240,-1,262,264,241,-1,61,186,263,-1,149,186,61,-1,261,96,95,-1,261,150,96,-1,238,185,184,-1,185,238,237,-1,183,191,182,-1,183,234,191,-1,220,252,218,-1,252,220,295,-1,257,68,256,-1,208,68,257,-1,300,162,254,-1,300,160,162,-1,161,295,163,-1,252,295,161,-1,104,89,219,-1,104,107,89,-1,87,143,294,-1,87,86,143,-1,205,249,248,-1,249,205,211,-1,230,245,259,-1,230,231,245,-1,246,235,243,-1,233,235,246,-1,242,239,236,-1,239,242,244,-1,70,229,71,-1,227,229,70,-1,129,241,133,-1,129,263,241,-1,238,94,236,-1,94,238,95,-1,235,237,239,-1,235,234,237,-1,231,191,233,-1,231,190,191,-1,228,230,226,-1,228,232,230,-1,151,8,5,-1,35,8,151,-1,136,170,173,-1,136,297,170,-1,224,128,222,-1,224,148,128,-1,193,223,225,-1,37,223,193,-1,6,35,34,-1,8,35,6,-1,219,87,220,-1,87,219,89,-1,83,221,218,-1,83,85,221,-1,80,17,81,-1,80,91,17,-1,77,0,2,-1,76,0,77,-1,175,75,74,-1,216,75,175,-1,217,176,153,-1,217,174,176,-1,214,189,275,-1,214,213,189,-1,39,65,67,-1,65,39,40,-1,68,210,66,-1,68,208,210,-1,211,207,209,-1,211,205,207,-1,206,200,204,-1,206,203,200,-1,202,62,64,-1,201,62,202,-1,199,196,198,-1,199,194,196,-1,193,197,90,-1,197,193,195,-1,58,232,228,-1,58,57,232,-1,232,192,190,-1,232,57,192,-1,60,96,61,-1,97,96,60,-1,69,240,70,-1,131,240,69,-1,46,58,187,-1,46,56,58,-1,188,43,42,-1,43,188,264,-1,186,55,262,-1,186,47,55,-1,45,261,184,-1,45,44,261,-1,183,49,185,-1,50,49,183,-1,192,51,182,-1,52,51,192,-1,44,150,261,-1,150,44,54,-1,43,262,55,-1,264,262,43,-1,38,34,40,-1,38,6,34,-1,180,125,280,-1,180,123,125,-1,177,181,179,-1,177,178,181,-1,27,24,23,-1,27,29,24,-1,98,30,12,-1,98,28,30,-1,174,127,176,-1,174,100,127,-1,99,175,74,-1,175,99,101,-1,25,73,26,-1,73,25,32,-1,14,19,159,-1,14,20,19,-1,14,169,20,-1,169,14,13,-1,137,108,167,-1,154,108,137,-1,169,121,16,-1,121,169,171,-1,173,13,172,-1,170,13,173,-1,166,0,164,-1,1,0,166,-1,163,162,161,-1,163,165,162,-1,159,15,14,-1,159,158,15,-1,172,15,109,-1,15,172,13,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpphal3_Coord',point=[(-6.56717,25.20225,3.35519),(-6.56989,25.19987,3.34592),(-6.57963,25.19987,3.3558),(-6.66239,25.15493,3.18211),(-6.69736,25.13492,3.2003),(-6.70561,25.19759,3.20577),(-6.93741,25.5827,3.21306),(-6.77007,25.30301,3.23037),(-6.78207,25.29834,3.2327),(-6.92164,25.58986,3.22708),(-6.56893,25.01377,3.51858),(-6.55431,24.99817,3.5152),(-6.55056,25.00751,3.5276),(-6.65522,25.02058,3.40545),(-6.64506,25.00405,3.40052),(-6.64292,25.00495,3.4085),(-6.65289,24.98888,3.27946),(-6.68529,25.01661,3.2581),(-6.59614,24.97594,3.22223),(-6.56661,24.97951,3.30068),(-6.64965,24.9879,3.32613),(-6.64146,24.97512,3.28042),(-6.63276,25.11968,3.17425),(-6.55094,25.21623,3.55653),(-6.52265,25.16948,3.53572),(-6.50298,25.18304,3.53094),(-6.5148,25.25462,3.53457),(-6.58569,25.17592,3.56556),(-6.548,25.09696,3.54162),(-6.5465,25.14479,3.5435),(-6.58255,25.08683,3.54447),(-6.49813,25.11999,3.526),(-6.45898,25.17893,3.51656),(-7.01638,25.55237,3.23909),(-6.97356,25.56873,3.22025),(-6.80242,25.29028,3.23805),(-6.82941,25.28093,3.25527),(-7.11339,25.97164,3.14291),(-7.05314,25.81583,3.17952),(-7.19498,25.93842,3.15361),(-7.11087,25.79272,3.19784),(-7.29681,26.25915,3.37377),(-7.2507,26.28747,3.39668),(-7.24927,26.28657,3.37565),(-7.32607,26.23828,3.32389),(-7.34269,26.23034,3.34341),(-7.25754,26.2848,3.41201),(-7.26848,26.2716,3.32728),(-7.28625,26.26067,3.31833),(-7.34982,26.22793,3.36397),(-7.34362,26.23369,3.39094),(-7.33336,26.24116,3.41041),(-7.31499,26.25291,3.4252),(-7.29586,26.26426,3.4298),(-7.30458,26.24996,3.31582),(-7.25324,26.28218,3.34976),(-7.27561,26.27536,3.42334),(-7.30021,26.27908,3.48941),(-7.26526,26.3045,3.47646),(-7.23683,26.30201,3.14747),(-7.25207,26.29695,3.1408),(-7.25176,26.30188,3.15653),(-6.90752,25.90623,3.52094),(-6.93983,26.06262,3.51421),(-6.95169,26.06144,3.53705),(-7.1686,25.76959,3.21615),(-7.33289,25.88888,3.26788),(-7.27143,25.91039,3.18736),(-7.2282,25.74448,3.27239),(-7.14065,26.38661,3.43232),(-7.16531,26.38682,3.43698),(-7.14331,26.39122,3.44975),(-6.42864,25.23704,3.49044),(-6.42811,25.23491,3.50345),(-6.38358,25.17842,3.50017),(-6.38362,25.17646,3.48596),(-6.5363,25.2406,3.43843),(-6.54777,25.24096,3.44406),(-6.52688,25.26456,3.52507),(-6.51018,25.25803,3.5201),(-6.70489,25.08033,3.21381),(-6.72867,25.09118,3.23295),(-6.72345,25.14331,3.2142),(-6.53143,24.99088,3.19055),(-6.58876,24.96531,3.23032),(-6.53979,24.99762,3.181),(-6.61371,25.17089,3.16635),(-6.55869,25.1443,3.14566),(-6.61913,25.15926,3.1574),(-6.56697,25.13395,3.14101),(-7.02658,25.82787,3.19362),(-6.66195,25.01669,3.23047),(-6.64218,25.17678,3.18433),(-6.69014,25.20331,3.20636),(-7.44217,26.22754,3.17734),(-7.43936,26.23528,3.18551),(-7.34948,26.27036,3.15529),(-7.34846,26.26616,3.14357),(-6.52955,25.06717,3.5302),(-6.43492,25.15009,3.51334),(-6.44472,25.066,3.51239),(-6.42866,25.1138,3.51099),(-6.64656,25.07969,3.19624),(-6.6347,25.03923,3.20744),(-6.55759,25.08059,3.15516),(-6.54498,25.0532,3.16101),(-6.59558,25.06801,3.1786),(-6.58574,25.10814,3.15632),(-6.59671,25.08593,3.53777),(-6.60315,25.00672,3.48236),(-6.51575,24.999,3.45926),(-6.67772,25.3473,3.4609),(-6.87002,25.60819,3.36465),(-6.83084,25.63585,3.44665),(-6.70418,25.32691,3.37559),(-6.60598,25.19061,3.25383),(-6.63765,25.24808,3.36838),(-6.66672,25.22372,3.27308),(-6.60783,25.27126,3.45726),(-6.59289,25.01454,3.20494),(-6.55623,25.01892,3.18134),(-6.685,25.02219,3.28764),(-6.7642,25.11769,3.3034),(-6.69919,25.36346,3.5585),(-6.81341,25.66127,3.52756),(-6.85065,25.6495,3.55299),(-6.6704,25.37803,3.54712),(-6.49006,25.04643,3.52216),(-7.21077,26.28243,3.12827),(-7.19119,26.31834,3.20379),(-7.17019,26.2992,3.19577),(-7.13787,26.3678,3.37816),(-7.14404,26.32168,3.30038),(-7.15991,26.33771,3.30102),(-7.10723,26.35066,3.37484),(-6.83698,25.26851,3.49682),(-6.70559,25.12986,3.48679),(-6.69571,25.15511,3.51939),(-7.34014,26.24057,3.11869),(-7.43723,26.19532,3.1646),(-6.52916,25.26303,3.5383),(-6.80617,25.66065,3.50944),(-6.66288,25.38047,3.53322),(-6.59192,25.1922,3.2475),(-6.58843,25.29735,3.53024),(-6.59182,25.29335,3.544),(-6.90603,25.90556,3.49583),(-6.9494,26.061,3.4759),(-7.24087,26.27262,3.10792),(-7.27976,26.27058,3.26295),(-7.31927,26.25413,3.25754),(-6.7285,25.18987,3.21441),(-6.74758,25.18006,3.2271),(-6.49369,24.99792,3.5076),(-6.61891,25.06949,3.5189),(-6.75174,25.10595,3.33659),(-6.87816,25.24526,3.35234),(-6.50238,25.02717,3.34525),(-6.54964,25.00357,3.37684),(-6.5533,25.00162,3.36731),(-6.4984,25.02889,3.35445),(-6.47306,25.07917,3.32162),(-6.46957,25.08095,3.3312),(-6.47792,25.12726,3.31677),(-6.50379,25.17067,3.33225),(-6.47493,25.12879,3.32472),(-6.50723,25.16803,3.32319),(-6.68693,25.18321,3.54187),(-6.78363,25.30213,3.55229),(-6.66388,25.00591,3.32432),(-6.66941,25.03723,3.40694),(-6.68579,25.02896,3.32481),(-6.61587,25.02282,3.48513),(-6.63821,25.0481,3.48597),(-6.41864,25.03632,3.50252),(-6.37898,25.10242,3.49926),(-6.48765,25.00573,3.51808),(-6.60137,25.19036,3.56973),(-6.5647,25.22844,3.56001),(-6.66445,25.24443,3.56413),(-6.73827,25.3413,3.56552),(-6.62578,25.27719,3.55902),(-7.36727,26.23091,3.44812),(-7.39329,26.21322,3.4077),(-7.39304,26.21093,3.31444),(-7.40664,26.2052,3.35387),(-7.24302,26.28891,3.28049),(-7.22878,26.32221,3.44615),(-7.21133,26.32703,3.41839),(-7.08604,26.36879,3.42972),(-7.38923,26.27683,3.57297),(-7.44229,26.22889,3.52455),(-7.33664,26.25266,3.47534),(-7.08224,25.98512,3.16074),(-6.97811,25.85201,3.34335),(-7.05175,25.9948,3.22632),(-7.02948,26.01259,3.32656),(-7.00815,25.83983,3.2519),(-6.98485,26.04011,3.40509),(-6.93606,25.87208,3.42697),(-7.12456,25.98312,3.61176),(-6.96905,25.88012,3.56481),(-7.02905,26.02978,3.58524),(-7.05279,25.83548,3.59058),(-7.22764,25.93696,3.59285),(-7.20036,25.76816,3.52729),(-7.1367,25.79158,3.57423),(-7.29084,25.90493,3.54113),(-7.25031,25.72883,3.35727),(-7.333,25.88103,3.45929),(-7.35318,25.87303,3.35297),(-7.23854,25.74085,3.45435),(-6.97099,26.18731,3.50297),(-7.02932,26.30273,3.43965),(-7.02371,26.30686,3.4898),(-6.9795,26.18388,3.45779),(-6.37767,25.10117,3.48722),(-6.41947,25.03253,3.49106),(-6.50785,25.04453,3.15475),(-6.52914,25.08808,3.1355),(-6.51595,25.09495,3.14196),(-6.52009,25.04628,3.14745),(-7.17199,26.2202,3.11761),(-7.16303,26.10743,3.10819),(-7.20712,26.20926,3.09395),(-7.12959,26.12131,3.12852),(-7.23387,26.36624,3.55437),(-7.18816,26.38564,3.48314),(-7.24379,26.36304,3.5403),(-7.16831,26.38898,3.49664),(-7.31522,26.31887,3.60196),(-7.3905,26.27032,3.58493),(-7.3188,26.32163,3.58282),(-7.44709,26.21855,3.5321),(-7.47192,26.19331,3.45086),(-7.47839,26.18199,3.4549),(-7.48571,26.19563,3.2552),(-7.49057,26.18418,3.35272),(-7.48065,26.20478,3.26193),(-7.49752,26.17331,3.35256),(-7.15853,26.36735,3.38145),(-7.17429,26.33601,3.30718),(-7.48911,26.16344,3.25286),(-7.47864,26.16157,3.45939),(-7.49768,26.1437,3.35279),(-7.37971,26.23503,3.60428),(-7.44051,26.1908,3.5414),(-6.86747,25.25235,3.43088),(-7.05053,25.54537,3.51829),(-7.08818,25.52514,3.44709),(-7.40394,25.99476,3.46499),(-7.3625,26.02547,3.55224),(-6.48174,25.05756,3.24046),(-6.50907,25.00749,3.27058),(-6.41787,25.08868,3.41105),(-6.42284,25.16074,3.40687),(-7.0721,25.53392,3.28031),(-7.09805,25.52394,3.35785),(-6.85764,25.26,3.2892),(-7.28362,26.29379,3.62849),(-7.19426,26.3409,3.59209),(-7.36405,26.23329,3.27415),(-7.21523,26.30855,3.32512),(-7.20265,26.31883,3.21809),(-7.20722,26.32237,3.3764),(-7.06251,26.28941,3.37464),(-7.10577,26.26445,3.29744),(-7.12894,26.23012,3.1929),(-7.3057,26.17,3.10199),(-7.40853,26.11768,3.15843),(-7.46215,26.09221,3.25598),(-7.4757,26.08591,3.3525),(-7.41475,26.11888,3.55618),(-7.45438,26.09718,3.46372),(-7.04811,26.29869,3.5398),(-7.08012,26.37506,3.47661),(-7.10543,26.37131,3.5221),(-7.23337,26.22306,3.65098),(-7.13353,26.2689,3.61411),(-6.99519,26.18917,3.54571),(-6.92787,25.61708,3.5765),(-7.08136,26.15593,3.60659),(-7.1813,26.10994,3.63394),(-7.29179,26.05996,3.61205),(-7.35005,26.16501,3.62076),(-6.99122,25.58116,3.56732),(-7.41164,25.99946,3.26518),(-7.4254,25.98545,3.34897),(-7.35604,26.03637,3.17159),(-6.90456,25.59616,3.27371),(-7.0705,26.1498,3.31181),(-7.01858,26.16447,3.38944),(-7.09061,26.12756,3.2043),(-7.26262,26.06814,3.11683),(-6.52663,25.15618,3.22635),(-6.48632,25.10553,3.22708),(-6.76962,25.14723,3.26082),(-6.7314,25.10773,3.41416),(-6.73728,25.30817,3.28808),(-6.4572,25.20952,3.4097),(-6.45169,25.03041,3.43168)]))),
        Shape(DEF='rpphal4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rpphal4_Geo',coordIndex=[0,1,2,-1,2,3,0,-1,4,5,6,-1,7,8,6,-1,9,10,6,-1,11,12,6,-1,13,14,6,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,23,26,24,-1,27,28,29,-1,27,30,28,-1,31,32,33,-1,32,30,33,-1,34,35,36,-1,37,38,39,-1,37,40,38,-1,41,42,43,-1,41,44,45,-1,41,46,47,-1,41,48,49,-1,41,50,51,-1,41,52,53,-1,41,54,55,-1,56,57,58,-1,57,59,58,-1,60,61,62,-1,60,63,61,-1,64,65,66,-1,64,67,65,-1,68,66,65,-1,24,26,28,-1,69,70,71,-1,72,73,68,-1,73,66,68,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,70,81,71,-1,81,82,71,-1,83,61,84,-1,84,85,83,-1,86,57,87,-1,57,88,87,-1,89,90,91,-1,90,92,91,-1,93,94,95,-1,93,96,94,-1,97,16,18,-1,98,3,99,-1,100,101,102,-1,100,103,104,-1,100,105,106,-1,100,27,29,-1,107,108,109,-1,108,110,109,-1,111,112,113,-1,112,82,113,-1,111,114,115,-1,115,112,111,-1,116,0,3,-1,116,117,0,-1,118,119,104,-1,119,105,104,-1,106,30,27,-1,106,33,30,-1,99,2,120,-1,121,122,31,-1,121,34,122,-1,123,124,125,-1,124,126,125,-1,118,34,121,-1,123,125,127,-1,36,128,34,-1,99,3,2,-1,31,122,129,-1,122,130,131,-1,122,132,130,-1,133,110,108,-1,133,134,110,-1,29,101,100,-1,100,106,27,-1,100,104,105,-1,100,135,103,-1,135,100,102,-1,136,137,131,-1,136,138,137,-1,116,139,140,-1,116,3,139,-1,141,96,93,-1,93,142,141,-1,143,144,145,-1,143,146,144,-1,147,148,143,-1,143,149,147,-1,83,150,151,-1,83,85,150,-1,152,153,154,-1,153,155,154,-1,31,129,32,-1,154,156,157,-1,69,26,70,-1,69,28,26,-1,94,158,159,-1,154,157,160,-1,160,161,154,-1,162,155,63,-1,63,60,162,-1,163,161,160,-1,163,164,161,-1,41,165,54,-1,41,55,52,-1,41,53,50,-1,41,51,48,-1,41,49,46,-1,41,47,44,-1,41,45,42,-1,41,43,165,-1,57,56,88,-1,56,166,88,-1,35,167,168,-1,119,118,121,-1,123,169,124,-1,123,170,169,-1,167,35,118,-1,35,34,118,-1,14,4,6,-1,12,13,6,-1,10,11,6,-1,8,9,6,-1,5,7,6,-1,1,171,2,-1,170,171,1,-1,128,122,34,-1,132,122,128,-1,172,91,173,-1,172,174,91,-1,175,176,92,-1,177,176,175,-1,177,130,178,-1,177,175,130,-1,13,97,179,-1,12,97,13,-1,11,22,16,-1,10,22,11,-1,9,180,20,-1,8,180,9,-1,181,5,120,-1,5,181,7,-1,99,14,98,-1,14,99,4,-1,98,139,3,-1,98,179,139,-1,180,182,183,-1,180,181,182,-1,123,120,2,-1,127,120,123,-1,182,120,127,-1,181,120,182,-1,36,124,169,-1,36,35,124,-1,184,185,186,-1,184,187,185,-1,71,188,69,-1,189,188,71,-1,190,58,62,-1,190,56,58,-1,166,191,88,-1,166,192,191,-1,193,194,195,-1,193,196,194,-1,197,198,199,-1,197,200,198,-1,201,202,203,-1,201,204,202,-1,42,205,206,-1,45,205,42,-1,202,46,207,-1,46,202,47,-1,208,48,209,-1,48,208,49,-1,152,51,50,-1,152,210,51,-1,53,211,153,-1,52,211,53,-1,84,54,85,-1,54,84,55,-1,165,212,150,-1,43,212,165,-1,164,95,213,-1,95,164,163,-1,154,162,156,-1,154,155,162,-1,190,151,214,-1,190,83,151,-1,215,159,158,-1,215,203,159,-1,216,217,218,-1,216,219,217,-1,213,94,159,-1,95,94,213,-1,201,215,220,-1,215,201,203,-1,221,96,141,-1,222,96,221,-1,221,223,198,-1,221,64,223,-1,224,225,226,-1,225,224,227,-1,228,229,230,-1,231,229,228,-1,232,147,233,-1,234,147,232,-1,148,38,235,-1,38,148,39,-1,137,32,129,-1,32,137,236,-1,237,138,238,-1,239,138,237,-1,216,212,206,-1,240,212,216,-1,205,201,219,-1,205,204,201,-1,203,207,159,-1,202,207,203,-1,209,213,208,-1,209,164,213,-1,154,210,152,-1,210,154,161,-1,153,63,155,-1,153,211,63,-1,241,160,40,-1,241,163,160,-1,242,243,149,-1,243,242,244,-1,233,149,243,-1,149,233,147,-1,245,230,229,-1,245,246,230,-1,247,145,59,-1,247,242,145,-1,246,79,78,-1,246,245,79,-1,248,249,250,-1,80,249,248,-1,172,248,250,-1,172,173,248,-1,251,88,191,-1,88,251,87,-1,252,174,251,-1,253,174,252,-1,252,254,253,-1,255,254,252,-1,256,90,89,-1,256,238,90,-1,257,254,258,-1,256,254,257,-1,194,259,255,-1,259,194,199,-1,259,198,223,-1,198,259,199,-1,258,72,257,-1,258,73,72,-1,260,261,262,-1,260,263,261,-1,264,68,265,-1,227,68,264,-1,263,266,267,-1,263,265,266,-1,232,261,268,-1,231,261,232,-1,268,269,270,-1,268,267,269,-1,67,266,65,-1,67,271,266,-1,270,39,234,-1,270,37,39,-1,272,270,269,-1,272,37,270,-1,58,145,144,-1,59,145,58,-1,235,143,148,-1,143,235,146,-1,272,93,241,-1,272,142,93,-1,196,218,217,-1,193,218,196,-1,192,214,273,-1,192,166,214,-1,144,62,58,-1,144,60,62,-1,146,156,162,-1,146,235,156,-1,163,93,95,-1,93,163,241,-1,140,77,274,-1,75,77,140,-1,275,246,78,-1,275,274,246,-1,117,275,276,-1,275,117,116,-1,276,178,117,-1,276,177,178,-1,175,131,130,-1,175,136,131,-1,238,136,90,-1,238,138,136,-1,236,226,25,-1,226,236,239,-1,135,188,185,-1,188,135,102,-1,104,187,118,-1,104,103,187,-1,69,29,28,-1,101,29,69,-1,277,82,81,-1,82,277,113,-1,134,26,23,-1,134,133,26,-1,134,278,110,-1,134,279,278,-1,225,264,279,-1,227,264,225,-1,262,278,260,-1,262,280,278,-1,280,228,74,-1,280,262,228,-1,76,107,109,-1,15,107,76,-1,281,21,282,-1,281,19,21,-1,111,281,282,-1,111,113,281,-1,111,283,114,-1,283,111,282,-1,131,129,122,-1,129,131,137,-1,0,284,1,-1,0,285,284,-1,286,186,115,-1,186,286,184,-1,287,114,283,-1,287,288,114,-1,287,127,125,-1,287,182,127,-1,125,288,287,-1,126,288,125,-1,286,126,168,-1,286,288,126,-1,283,182,287,-1,283,183,182,-1,115,288,286,-1,115,114,288,-1,168,184,286,-1,167,184,168,-1,168,124,35,-1,124,168,126,-1,106,119,33,-1,119,106,105,-1,117,285,0,-1,117,178,285,-1,30,24,28,-1,30,32,24,-1,183,282,21,-1,183,283,282,-1,189,115,186,-1,189,112,115,-1,82,189,71,-1,82,112,189,-1,113,289,281,-1,113,277,289,-1,289,15,17,-1,289,107,15,-1,74,109,280,-1,76,109,74,-1,277,107,289,-1,277,108,107,-1,110,280,109,-1,280,110,278,-1,279,260,278,-1,264,260,279,-1,279,23,225,-1,23,279,134,-1,108,81,133,-1,108,277,81,-1,133,70,26,-1,133,81,70,-1,187,135,185,-1,187,103,135,-1,102,69,188,-1,102,101,69,-1,226,237,224,-1,226,239,237,-1,136,92,90,-1,136,175,92,-1,177,290,176,-1,177,276,290,-1,276,78,290,-1,78,276,275,-1,116,274,275,-1,274,116,140,-1,75,139,18,-1,139,75,140,-1,230,274,77,-1,274,230,246,-1,40,157,38,-1,40,160,157,-1,162,144,146,-1,144,162,60,-1,56,214,166,-1,56,190,214,-1,273,193,192,-1,193,273,218,-1,220,200,197,-1,215,200,220,-1,272,40,37,-1,272,241,40,-1,57,247,59,-1,247,57,86,-1,142,269,271,-1,142,272,269,-1,271,141,142,-1,67,141,271,-1,271,267,266,-1,267,271,269,-1,268,234,232,-1,268,270,234,-1,268,263,267,-1,261,263,268,-1,265,65,266,-1,68,65,265,-1,265,260,264,-1,260,265,263,-1,231,262,261,-1,228,262,231,-1,223,258,259,-1,73,258,223,-1,224,257,72,-1,237,257,224,-1,258,255,259,-1,255,258,254,-1,257,238,256,-1,238,257,237,-1,256,253,254,-1,256,89,253,-1,195,255,252,-1,194,255,195,-1,174,89,91,-1,253,89,174,-1,252,191,195,-1,251,191,252,-1,248,176,290,-1,248,173,176,-1,172,86,87,-1,172,250,86,-1,247,250,249,-1,247,86,250,-1,80,290,78,-1,80,248,290,-1,249,242,247,-1,249,244,242,-1,79,243,244,-1,245,243,79,-1,229,243,245,-1,229,233,243,-1,145,149,143,-1,149,145,242,-1,63,84,61,-1,84,63,211,-1,161,209,210,-1,209,161,164,-1,208,159,207,-1,208,213,159,-1,204,47,202,-1,47,204,44,-1,206,219,216,-1,206,205,219,-1,240,150,212,-1,240,151,150,-1,80,244,249,-1,80,79,244,-1,137,239,236,-1,137,138,239,-1,148,234,39,-1,148,147,234,-1,233,231,232,-1,233,229,231,-1,230,74,228,-1,230,77,74,-1,76,18,15,-1,76,75,18,-1,68,224,72,-1,227,224,68,-1,23,226,225,-1,23,25,226,-1,64,73,223,-1,64,66,73,-1,215,222,200,-1,158,222,215,-1,221,67,64,-1,221,141,67,-1,222,94,96,-1,158,94,222,-1,240,218,273,-1,240,216,218,-1,219,220,217,-1,219,201,220,-1,273,151,240,-1,214,151,273,-1,62,83,190,-1,62,61,83,-1,235,157,156,-1,38,157,235,-1,165,85,54,-1,165,150,85,-1,211,55,84,-1,55,211,52,-1,153,50,53,-1,153,152,50,-1,210,48,51,-1,210,209,48,-1,207,49,208,-1,49,207,46,-1,45,204,205,-1,44,204,45,-1,43,206,212,-1,42,206,43,-1,200,221,198,-1,200,222,221,-1,196,199,194,-1,196,197,199,-1,195,192,193,-1,191,192,195,-1,217,197,196,-1,197,217,220,-1,167,187,184,-1,167,118,187,-1,186,188,189,-1,186,185,188,-1,33,121,31,-1,121,33,119,-1,32,25,24,-1,25,32,236,-1,17,281,289,-1,17,19,281,-1,123,171,170,-1,171,123,2,-1,20,183,21,-1,20,180,183,-1,16,19,17,-1,16,22,19,-1,179,18,139,-1,179,97,18,-1,14,179,98,-1,13,179,14,-1,5,99,120,-1,4,99,5,-1,8,181,180,-1,7,181,8,-1,22,9,20,-1,9,22,10,-1,97,11,16,-1,11,97,12,-1,169,128,36,-1,169,284,128,-1,132,178,130,-1,178,132,285,-1,173,92,176,-1,173,91,92,-1,174,87,251,-1,172,87,174,-1,284,132,128,-1,285,132,284,-1,169,1,284,-1,169,170,1,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpphal4_Coord',point=[(-6.95437,25.22191,2.69065),(-6.87364,25.13398,2.68899),(-6.84936,25.12465,2.71172),(-6.89978,25.25839,2.75072),(-6.76362,25.19998,2.75166),(-6.72665,25.17203,2.75068),(-6.7168,25.24451,2.75194),(-6.68841,25.19084,2.74594),(-6.65824,25.22146,2.74179),(-6.65913,25.2572,2.74359),(-6.67637,25.283,2.74755),(-6.69281,25.29761,2.75018),(-6.73747,25.29055,2.75992),(-6.77588,25.28328,2.7689),(-6.78911,25.24829,2.76309),(-6.7445,25.37461,2.74231),(-6.67266,25.34224,2.7487),(-6.67002,25.35338,2.73418),(-6.7517,25.37623,2.75888),(-6.63508,25.32441,2.73062),(-6.60146,25.26991,2.73524),(-6.59395,25.27094,2.72202),(-6.6424,25.31535,2.74387),(-6.98584,25.40965,2.43492),(-6.88009,25.30611,2.37432),(-7.00246,25.39698,2.41756),(-6.85435,25.30218,2.39123),(-6.90569,25.22113,2.40036),(-6.85996,25.29116,2.36721),(-6.84228,25.24538,2.36851),(-6.94093,25.25161,2.3994),(-6.98093,25.18264,2.45296),(-6.95939,25.26791,2.3999),(-6.96287,25.17442,2.43988),(-6.90909,25.10461,2.50752),(-6.89566,25.08428,2.52133),(-6.90989,25.10645,2.52694),(-7.38284,26.31549,2.70938),(-7.41173,26.39435,2.79979),(-7.3596,26.32102,2.81065),(-7.42143,26.39438,2.70421),(-7.60426,26.3144,2.62031),(-7.63131,26.29614,2.5979),(-7.63512,26.29338,2.60684),(-7.60924,26.31153,2.58155),(-7.62002,26.30405,2.58574),(-7.58923,26.32521,2.5869),(-7.60006,26.31784,2.58155),(-7.5734,26.3356,2.6224),(-7.57765,26.33295,2.60294),(-7.58267,26.32884,2.65015),(-7.57644,26.33325,2.64086),(-7.6022,26.31526,2.66007),(-7.5903,26.3235,2.65637),(-7.62826,26.29754,2.6466),(-7.61289,26.30793,2.65872),(-7.74345,26.18642,2.77494),(-7.70613,26.10511,2.77786),(-7.67268,26.22931,2.85999),(-7.63735,26.16098,2.84697),(-7.60795,26.35725,2.85733),(-7.69086,26.3196,2.81868),(-7.6944,26.30578,2.83608),(-7.61214,26.36161,2.83867),(-7.41068,26.16159,2.39062),(-7.32806,26.01194,2.44311),(-7.34117,26.00315,2.42394),(-7.38779,26.1777,2.41544),(-7.24388,25.81753,2.44388),(-6.78131,25.27384,2.34983),(-6.76949,25.30065,2.36395),(-6.74235,25.28327,2.35891),(-7.25969,25.81005,2.43037),(-7.36881,25.98452,2.41646),(-6.97159,25.56643,2.73558),(-6.88041,25.45482,2.74752),(-6.87616,25.45543,2.72848),(-6.97674,25.56037,2.75293),(-7.19404,25.58371,2.75996),(-7.28716,25.7639,2.78782),(-7.32602,25.74063,2.77712),(-6.7539,25.31548,2.44794),(-6.71722,25.27675,2.43806),(-7.74993,26.26259,2.7472),(-7.64404,26.30048,2.73051),(-7.67716,26.27943,2.69534),(-7.64568,26.01723,2.76945),(-7.7015,25.99113,2.67309),(-7.75037,26.07812,2.67393),(-7.43464,25.6647,2.53043),(-7.3162,25.51684,2.52999),(-7.44196,25.65473,2.58985),(-7.31282,25.5105,2.58413),(-7.44996,26.37692,2.51046),(-7.49118,26.40427,2.42478),(-7.48251,26.40692,2.5314),(-7.46262,26.36789,2.40765),(-6.75813,25.33659,2.76789),(-6.86209,25.25372,2.76637),(-6.81044,25.15544,2.75138),(-6.82525,25.17278,2.38735),(-6.79216,25.2322,2.35869),(-6.75493,25.20571,2.35655),(-6.78043,25.12432,2.38966),(-6.82122,25.11078,2.41089),(-6.89109,25.13408,2.4245),(-6.91314,25.16887,2.41877),(-6.77654,25.34734,2.65409),(-6.80854,25.31323,2.57493),(-6.89963,25.44106,2.66127),(-6.92087,25.43949,2.58946),(-6.6814,25.22765,2.54854),(-6.68068,25.2257,2.42633),(-6.70443,25.27418,2.55201),(-6.69316,25.17039,2.55429),(-6.68188,25.15538,2.43435),(-7.00828,25.36684,2.74888),(-7.06103,25.31767,2.701),(-6.83459,25.07149,2.4404),(-6.9077,25.10591,2.44083),(-6.74675,25.11253,2.74979),(-6.90905,25.09807,2.44951),(-7.00584,25.1963,2.51894),(-6.8442,25.10392,2.68976),(-6.88516,25.09546,2.617),(-6.79743,25.08434,2.6833),(-6.82384,25.08233,2.60472),(-6.75129,25.10024,2.73617),(-6.91486,25.11219,2.52866),(-6.99682,25.21439,2.46827),(-7.112,25.30013,2.57134),(-7.11738,25.30616,2.53056),(-7.0012,25.19917,2.55679),(-6.82433,25.3191,2.47256),(-6.95422,25.4274,2.51105),(-6.75488,25.154,2.36779),(-7.21185,25.40227,2.53148),(-7.10223,25.32834,2.47442),(-7.18336,25.42406,2.48309),(-6.85576,25.34546,2.78498),(-6.94178,25.42254,2.76139),(-7.42183,26.28857,2.40159),(-7.42419,26.29842,2.49951),(-7.43251,26.27496,2.87156),(-7.562,26.29332,2.89312),(-7.52333,26.21719,2.88242),(-7.48228,26.35719,2.87031),(-7.33211,26.20294,2.83377),(-7.37453,26.31081,2.84592),(-7.39037,26.17229,2.84577),(-7.69391,26.26297,2.6354),(-7.78017,26.25252,2.65544),(-7.5419,26.35903,2.70297),(-7.5634,26.34598,2.72562),(-7.49453,26.42477,2.78258),(-7.54175,26.40527,2.82154),(-7.47562,26.42121,2.80628),(-7.46357,26.42511,2.78737),(-7.51251,26.39669,2.40226),(-7.5354,26.40524,2.46237),(-7.46637,26.42214,2.69257),(-7.4934,26.41377,2.68579),(-7.53012,26.4022,2.83822),(-7.47023,26.40877,2.62825),(-7.49384,26.40766,2.63348),(-7.63579,26.29263,2.62793),(-7.78212,26.17741,2.67092),(-6.83029,25.06271,2.4634),(-6.82704,25.06992,2.51059),(-6.90274,25.12347,2.6161),(-6.87002,25.13004,2.68892),(-6.86773,25.1294,2.69145),(-7.57667,25.8329,2.65985),(-7.43189,25.66003,2.64947),(-7.58571,25.82698,2.59511),(-7.21114,25.40039,2.57931),(-7.30075,25.5116,2.64212),(-7.20167,25.40642,2.63592),(-7.0965,25.29988,2.62563),(-6.82667,25.32363,2.78393),(-6.61606,25.20487,2.73448),(-6.66641,25.14928,2.74131),(-6.66124,25.14367,2.72932),(-6.60435,25.20523,2.72101),(-6.74145,25.09089,2.40552),(-6.71631,25.13859,2.35716),(-6.69521,25.13778,2.37306),(-6.75253,25.09624,2.38876),(-6.71986,25.21767,2.34272),(-6.69832,25.22355,2.35638),(-7.75841,26.23958,2.76407),(-7.75954,26.08334,2.5747),(-7.78867,26.17989,2.57761),(-7.75913,26.21468,2.46227),(-7.67902,26.15188,2.40879),(-7.73722,26.11311,2.47795),(-7.70323,26.24379,2.4058),(-7.63762,26.28033,2.37666),(-7.54141,26.23658,2.35821),(-7.61111,26.19855,2.37426),(-7.57239,26.31178,2.36505),(-7.64927,26.343,2.41394),(-7.59387,26.33244,2.50688),(-7.5929,26.37472,2.41579),(-7.62362,26.31163,2.50732),(-7.6558,26.29156,2.52528),(-7.67728,26.27403,2.55382),(-7.56321,26.35318,2.52494),(-7.54033,26.36589,2.57689),(-7.52954,26.37373,2.62822),(-7.5317,26.37126,2.6648),(-7.6006,26.32327,2.7387),(-7.68891,26.2651,2.58983),(-7.50905,26.40797,2.55011),(-7.79037,26.22988,2.66298),(-7.5896,26.36361,2.38139),(-7.75723,26.28432,2.47529),(-7.70911,26.30159,2.41335),(-7.76498,26.26337,2.46441),(-7.7039,26.31447,2.43071),(-7.64755,26.33084,2.38785),(-7.45943,26.27704,2.3703),(-7.49079,26.35232,2.38126),(-7.46821,26.13255,2.37833),(-7.16517,25.63995,2.43424),(-7.07179,25.52663,2.45116),(-7.08961,25.5108,2.43564),(-7.14641,25.65106,2.45015),(-7.05318,25.69504,2.7443),(-7.16156,25.86383,2.78188),(-7.05635,25.68285,2.75957),(-7.15508,25.86994,2.76617),(-7.25347,26.04823,2.78857),(-7.25825,26.0382,2.8059),(-7.31966,26.21133,2.81),(-7.43267,26.38001,2.84247),(-7.0562,25.36315,2.42673),(-7.22616,25.57889,2.44371),(-7.2806,25.54303,2.48086),(-7.1421,25.46307,2.44594),(-7.77942,26.25818,2.57204),(-7.44039,26.3848,2.62269),(-7.47877,26.11977,2.8496),(-7.30281,26.00311,2.8167),(-7.39634,25.9599,2.81647),(-7.20461,25.81556,2.79474),(-7.11145,25.63962,2.77485),(-7.57406,26.06243,2.82349),(-7.39041,25.68857,2.73856),(-7.4661,25.91793,2.79736),(-7.53571,25.87617,2.7561),(-7.70762,25.99342,2.58124),(-7.68359,26.00333,2.49366),(-7.56837,25.84326,2.5222),(-7.51936,25.88576,2.46079),(-7.62367,26.04411,2.43605),(-7.38783,25.69835,2.4779),(-7.32914,25.73549,2.44385),(-7.45193,25.93296,2.4332),(-7.55329,26.09209,2.3979),(-7.11276,25.67297,2.60312),(-7.19222,25.86095,2.68567),(-7.08072,25.68426,2.6806),(-7.22433,25.847,2.60277),(-7.13027,25.66163,2.5229),(-7.23393,25.84082,2.51715),(-7.32393,26.02561,2.51283),(-7.32272,26.03729,2.60372),(-7.29625,26.04684,2.69534),(-7.37579,26.19267,2.60557),(-7.3501,26.20564,2.70844),(-7.38153,26.18402,2.49933),(-7.41251,26.30596,2.61331),(-7.7911,26.23621,2.57686),(-7.04042,25.52701,2.76459),(-7.10623,25.47818,2.75003),(-7.16942,25.43646,2.71104),(-6.7372,25.2989,2.56134),(-7.01784,25.54759,2.59951),(-7.04529,25.53374,2.5228),(-6.9951,25.55866,2.67109),(-6.65755,25.30099,2.6422),(-6.62598,25.24532,2.64158),(-6.62765,25.19269,2.6486),(-6.90747,25.12878,2.61619),(-6.99104,25.20523,2.62032),(-6.73385,25.10173,2.47081),(-6.69512,25.12433,2.66242),(-6.7408,25.12032,2.57864),(-6.69951,25.33529,2.64743),(-7.26135,25.53648,2.72309)]))),
        Shape(DEF='rpphal5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rpphal5_Geo',coordIndex=[0,1,2,-1,0,3,1,-1,4,5,6,-1,4,7,5,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,19,20,17,-1,21,22,23,-1,22,24,23,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,31,34,32,-1,35,36,34,-1,36,32,34,-1,2,1,37,-1,1,38,37,-1,39,40,41,-1,39,42,40,-1,40,43,44,-1,40,45,43,-1,46,47,48,-1,48,49,46,-1,50,27,51,-1,52,27,53,-1,54,27,55,-1,56,27,26,-1,51,27,57,-1,58,30,29,-1,28,59,60,-1,28,61,59,-1,62,63,64,-1,65,66,67,-1,67,68,65,-1,69,70,71,-1,71,37,69,-1,44,41,40,-1,72,73,74,-1,72,75,73,-1,76,77,63,-1,77,64,63,-1,78,79,80,-1,81,82,83,-1,83,84,81,-1,85,86,80,-1,87,88,89,-1,88,90,89,-1,7,91,92,-1,92,5,7,-1,93,85,80,-1,94,78,80,-1,95,96,80,-1,80,97,98,-1,99,100,80,-1,101,38,102,-1,38,103,102,-1,104,30,105,-1,61,30,106,-1,62,30,67,-1,107,108,109,-1,107,110,108,-1,63,66,74,-1,111,112,113,-1,112,114,113,-1,105,30,115,-1,116,46,117,-1,116,118,46,-1,4,119,120,-1,67,30,68,-1,106,30,62,-1,30,61,28,-1,30,104,68,-1,121,122,123,-1,124,125,126,-1,110,127,108,-1,110,128,127,-1,129,130,8,-1,131,132,133,-1,131,134,132,-1,100,135,80,-1,98,95,80,-1,96,94,80,-1,136,80,79,-1,86,137,80,-1,73,138,76,-1,138,6,76,-1,139,140,141,-1,141,142,139,-1,36,143,32,-1,143,144,32,-1,89,145,87,-1,66,65,146,-1,80,136,93,-1,147,148,94,-1,137,99,80,-1,74,73,76,-1,76,63,74,-1,149,41,44,-1,149,150,41,-1,151,152,153,-1,154,155,141,-1,141,156,154,-1,71,157,158,-1,71,70,157,-1,67,63,62,-1,67,66,63,-1,104,65,68,-1,104,159,65,-1,115,30,58,-1,160,57,27,-1,25,27,54,-1,55,27,52,-1,53,27,50,-1,6,77,76,-1,6,5,77,-1,47,118,120,-1,47,46,118,-1,7,118,91,-1,118,116,91,-1,41,161,39,-1,1,103,38,-1,37,38,69,-1,162,163,164,-1,164,113,162,-1,27,56,160,-1,165,166,49,-1,49,167,165,-1,33,144,168,-1,33,32,144,-1,169,15,170,-1,169,16,15,-1,22,171,24,-1,171,172,24,-1,173,174,18,-1,174,19,18,-1,10,175,176,-1,10,9,175,-1,177,178,179,-1,177,180,178,-1,97,80,135,-1,181,182,183,-1,182,184,183,-1,119,4,138,-1,4,6,138,-1,185,0,2,-1,185,123,0,-1,122,42,186,-1,122,187,42,-1,188,168,124,-1,188,33,168,-1,172,133,132,-1,133,172,189,-1,190,97,135,-1,169,97,190,-1,191,192,193,-1,192,191,194,-1,195,196,197,-1,195,198,196,-1,199,200,201,-1,199,202,200,-1,184,203,204,-1,203,184,182,-1,205,206,207,-1,208,206,205,-1,209,210,211,-1,209,212,210,-1,213,214,215,-1,216,214,213,-1,217,176,218,-1,217,10,176,-1,177,219,220,-1,177,179,219,-1,221,180,222,-1,180,221,178,-1,223,14,224,-1,223,15,14,-1,213,224,225,-1,224,213,215,-1,135,226,190,-1,135,100,226,-1,169,13,16,-1,169,190,13,-1,227,228,229,-1,228,227,230,-1,15,174,170,-1,174,15,19,-1,231,173,18,-1,147,173,231,-1,148,232,233,-1,148,234,232,-1,235,130,129,-1,235,236,130,-1,189,171,237,-1,171,189,172,-1,11,238,239,-1,226,238,11,-1,145,240,87,-1,145,241,240,-1,159,34,31,-1,159,242,34,-1,84,158,81,-1,84,243,158,-1,244,245,35,-1,244,121,245,-1,246,77,247,-1,77,246,64,-1,167,56,165,-1,160,56,167,-1,248,60,249,-1,248,250,60,-1,251,163,252,-1,164,163,251,-1,253,113,114,-1,253,162,113,-1,254,255,256,-1,257,255,254,-1,3,258,259,-1,258,3,260,-1,261,163,162,-1,261,262,163,-1,263,116,111,-1,263,91,116,-1,39,186,42,-1,39,260,186,-1,7,120,118,-1,120,7,4,-1,104,43,159,-1,105,43,104,-1,264,256,255,-1,264,101,256,-1,165,265,166,-1,165,266,265,-1,267,87,240,-1,267,268,87,-1,269,154,88,-1,269,155,154,-1,157,241,158,-1,157,270,241,-1,271,141,140,-1,271,156,141,-1,151,227,152,-1,230,227,151,-1,149,248,150,-1,250,248,149,-1,59,247,272,-1,246,247,59,-1,273,153,274,-1,153,273,275,-1,276,227,277,-1,227,276,152,-1,238,137,21,-1,238,99,137,-1,8,232,9,-1,8,130,232,-1,206,23,211,-1,206,239,23,-1,278,191,197,-1,278,279,191,-1,280,281,282,-1,280,283,281,-1,209,134,212,-1,209,132,134,-1,93,235,237,-1,93,136,235,-1,196,284,285,-1,284,196,201,-1,286,143,287,-1,143,286,288,-1,289,35,245,-1,35,289,36,-1,260,161,258,-1,161,260,39,-1,72,66,290,-1,72,74,66,-1,107,138,291,-1,107,119,138,-1,109,267,292,-1,268,267,109,-1,280,289,83,-1,280,287,289,-1,108,268,109,-1,108,269,268,-1,139,293,294,-1,293,139,142,-1,277,295,276,-1,277,296,295,-1,200,181,297,-1,200,182,181,-1,285,197,196,-1,278,197,285,-1,298,271,194,-1,156,271,298,-1,75,299,291,-1,75,273,299,-1,21,86,22,-1,21,137,86,-1,136,236,235,-1,79,236,136,-1,96,147,94,-1,173,147,96,-1,170,95,98,-1,170,174,95,-1,226,99,238,-1,226,100,99,-1,205,193,192,-1,207,193,205,-1,216,140,214,-1,216,271,140,-1,208,239,206,-1,208,11,239,-1,134,202,199,-1,202,134,131,-1,218,133,217,-1,131,133,218,-1,204,218,176,-1,204,203,218,-1,9,234,300,-1,9,232,234,-1,301,302,300,-1,301,221,302,-1,296,222,180,-1,222,296,277,-1,296,177,294,-1,177,296,180,-1,214,139,220,-1,140,139,214,-1,179,223,219,-1,20,223,179,-1,303,156,298,-1,303,154,156,-1,278,286,282,-1,286,278,285,-1,304,284,297,-1,304,288,284,-1,151,125,183,-1,153,125,151,-1,274,295,305,-1,274,276,295,-1,293,305,295,-1,293,128,305,-1,117,49,166,-1,46,49,117,-1,240,270,306,-1,241,270,240,-1,283,303,281,-1,90,303,283,-1,270,57,306,-1,270,51,57,-1,165,26,266,-1,165,56,26,-1,254,112,265,-1,114,112,254,-1,52,70,69,-1,70,52,53,-1,70,50,157,-1,70,53,50,-1,108,155,269,-1,155,108,127,-1,128,299,305,-1,110,299,128,-1,168,304,307,-1,144,304,168,-1,288,144,143,-1,288,304,144,-1,83,245,84,-1,83,289,245,-1,31,65,159,-1,146,65,31,-1,149,29,250,-1,149,58,29,-1,290,124,126,-1,188,124,290,-1,290,275,72,-1,290,126,275,-1,120,292,47,-1,120,119,292,-1,111,117,112,-1,116,117,111,-1,251,272,308,-1,249,272,251,-1,161,150,309,-1,41,150,161,-1,45,244,242,-1,244,45,187,-1,102,162,253,-1,102,261,162,-1,309,258,161,-1,258,309,262,-1,125,275,126,-1,153,275,125,-1,103,261,102,-1,103,259,261,-1,252,262,309,-1,252,163,262,-1,259,1,3,-1,103,1,259,-1,248,309,150,-1,248,252,309,-1,263,251,308,-1,263,164,251,-1,92,272,247,-1,272,92,308,-1,91,308,92,-1,91,263,308,-1,110,291,299,-1,291,110,107,-1,292,48,47,-1,267,48,292,-1,44,58,149,-1,44,115,58,-1,242,35,34,-1,242,244,35,-1,287,282,286,-1,282,287,280,-1,157,51,270,-1,51,157,50,-1,253,101,102,-1,256,101,253,-1,264,52,69,-1,52,264,55,-1,54,264,255,-1,264,54,55,-1,25,255,257,-1,25,54,255,-1,57,167,306,-1,167,57,160,-1,145,82,81,-1,145,89,82,-1,88,303,90,-1,88,154,303,-1,71,2,37,-1,71,185,2,-1,166,112,117,-1,166,265,112,-1,142,128,293,-1,142,127,128,-1,141,127,142,-1,141,155,127,-1,125,181,183,-1,125,307,181,-1,307,297,181,-1,307,304,297,-1,298,281,303,-1,298,279,281,-1,20,178,17,-1,20,179,178,-1,12,208,225,-1,12,11,208,-1,294,220,139,-1,220,294,177,-1,17,221,301,-1,221,17,178,-1,302,222,229,-1,222,302,221,-1,175,300,302,-1,175,9,300,-1,228,176,175,-1,228,204,176,-1,203,131,218,-1,203,202,131,-1,211,24,209,-1,23,24,211,-1,216,194,271,-1,194,216,192,-1,210,198,195,-1,210,212,198,-1,98,169,170,-1,169,98,97,-1,96,174,173,-1,174,96,95,-1,233,94,148,-1,233,78,94,-1,85,237,171,-1,237,85,93,-1,305,273,274,-1,305,299,273,-1,5,247,77,-1,5,92,247,-1,279,194,191,-1,298,194,279,-1,297,201,200,-1,284,201,297,-1,183,230,151,-1,183,184,230,-1,294,295,296,-1,295,294,293,-1,89,283,82,-1,89,90,283,-1,292,107,109,-1,292,119,107,-1,291,73,75,-1,291,138,73,-1,187,121,244,-1,187,122,121,-1,287,36,289,-1,36,287,143,-1,288,285,284,-1,288,286,285,-1,199,212,134,-1,199,198,212,-1,85,22,86,-1,171,22,85,-1,158,185,71,-1,185,158,243,-1,283,83,82,-1,83,283,280,-1,279,282,281,-1,282,279,278,-1,195,207,210,-1,195,193,207,-1,236,78,233,-1,236,79,78,-1,300,231,301,-1,300,234,231,-1,43,242,159,-1,43,45,242,-1,152,274,153,-1,152,276,274,-1,72,273,75,-1,275,273,72,-1,60,272,249,-1,60,59,272,-1,229,175,302,-1,175,229,228,-1,240,48,267,-1,48,240,306,-1,268,88,87,-1,268,269,88,-1,167,48,306,-1,49,48,167,-1,266,254,265,-1,257,254,266,-1,101,69,38,-1,69,101,264,-1,61,246,59,-1,106,246,61,-1,43,115,44,-1,43,105,115,-1,0,260,3,-1,186,260,0,-1,263,113,164,-1,113,263,111,-1,262,259,258,-1,262,261,259,-1,42,45,40,-1,45,42,187,-1,256,114,254,-1,256,253,114,-1,252,249,251,-1,252,248,249,-1,106,64,246,-1,64,106,62,-1,84,121,243,-1,245,121,84,-1,241,81,158,-1,81,241,145,-1,146,33,188,-1,31,33,146,-1,146,290,66,-1,146,188,290,-1,29,60,250,-1,60,29,28,-1,26,257,266,-1,257,26,25,-1,239,21,23,-1,238,21,239,-1,129,237,235,-1,237,129,189,-1,130,233,232,-1,236,233,130,-1,234,147,231,-1,234,148,147,-1,277,229,222,-1,229,277,227,-1,219,224,215,-1,223,224,219,-1,14,225,224,-1,225,14,12,-1,190,11,13,-1,190,226,11,-1,18,301,231,-1,17,301,18,-1,20,15,223,-1,20,19,15,-1,230,204,228,-1,204,230,184,-1,220,215,214,-1,220,219,215,-1,192,213,205,-1,192,216,213,-1,207,211,210,-1,206,211,207,-1,205,225,208,-1,225,205,213,-1,182,202,203,-1,202,182,200,-1,201,198,199,-1,198,201,196,-1,197,193,195,-1,193,197,191,-1,132,24,172,-1,132,209,24,-1,189,217,133,-1,217,189,129,-1,16,12,14,-1,12,16,13,-1,129,10,217,-1,129,8,10,-1,243,123,185,-1,121,123,243,-1,307,124,168,-1,125,124,307,-1,123,186,0,-1,123,122,186,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rpphal5_Coord',point=[(-7.00161,25.27014,1.81296),(-6.95661,25.23835,1.86872),(-6.96981,25.26102,1.87011),(-6.99236,25.25008,1.81689),(-6.90489,25.41137,1.76132),(-6.90428,25.42212,1.69069),(-6.91791,25.4215,1.69629),(-6.89107,25.40846,1.75764),(-7.63886,26.31213,1.74971),(-7.56091,26.33694,1.74914),(-7.63018,26.29104,1.73452),(-7.62948,26.26282,2.05767),(-7.55139,26.27792,2.06296),(-7.5739,26.29211,2.04365),(-7.49838,26.31002,2.0294),(-7.50008,26.33953,1.97855),(-7.52369,26.32185,2.01586),(-7.47504,26.36278,1.87041),(-7.50369,26.37246,1.87921),(-7.49862,26.35318,1.92434),(-7.47963,26.34072,1.92349),(-7.72919,26.21032,1.98207),(-7.75175,26.19912,1.93127),(-7.73375,26.19749,1.98968),(-7.75673,26.18252,1.93405),(-6.82209,25.3303,1.89745),(-6.82233,25.35133,1.89702),(-6.88052,25.32415,1.91518),(-6.9364,25.32844,1.60789),(-6.93646,25.31475,1.60843),(-6.98531,25.33851,1.63842),(-7.12787,25.40796,1.68996),(-7.16742,25.43008,1.74625),(-7.15951,25.46,1.71003),(-7.12656,25.37835,1.73388),(-7.10316,25.35175,1.77304),(-7.1608,25.41198,1.78746),(-6.92769,25.24036,1.89799),(-6.88838,25.22535,1.89494),(-7.01992,25.24474,1.74429),(-7.00928,25.24924,1.67425),(-6.98998,25.24247,1.66209),(-7.02844,25.2643,1.74743),(-7.02721,25.27565,1.66618),(-6.98943,25.25094,1.64625),(-7.02822,25.26791,1.68556),(-6.86277,25.43063,1.84221),(-6.88554,25.42638,1.84894),(-6.88372,25.4407,1.90128),(-6.84901,25.43408,1.89339),(-6.92804,25.33297,1.93125),(-6.91643,25.36319,1.9328),(-6.87653,25.27833,1.9118),(-6.90316,25.29702,1.92052),(-6.83158,25.31141,1.90196),(-6.85323,25.29137,1.90486),(-6.83595,25.36844,1.90166),(-6.88541,25.37194,1.91966),(-6.95304,25.29216,1.61885),(-6.88753,25.34777,1.59258),(-6.88842,25.32321,1.59261),(-6.93532,25.34198,1.60956),(-6.97446,25.38457,1.62872),(-6.96353,25.43495,1.63096),(-6.94533,25.42329,1.62214),(-7.07655,25.41364,1.66382),(-7.04214,25.44129,1.65948),(-7.00682,25.38916,1.64864),(-7.03045,25.3707,1.65706),(-6.87424,25.23881,1.90497),(-6.92736,25.27055,1.92161),(-6.94906,25.26422,1.908),(-7.07316,25.51598,1.68892),(-6.99757,25.45816,1.67539),(-7.01013,25.45198,1.66416),(-7.05802,25.51704,1.70104),(-6.95005,25.43646,1.64018),(-6.935,25.43338,1.62999),(-7.60328,26.31606,1.85426),(-7.63072,26.30056,1.84385),(-7.60777,26.27675,1.91043),(-7.0351,25.38389,1.94553),(-7.07344,25.4346,1.94646),(-7.10834,25.41333,1.88915),(-7.0435,25.34514,1.87952),(-7.68584,26.2405,1.8915),(-7.68081,26.24003,1.91614),(-7.00019,25.52333,1.94003),(-7.07498,25.60693,1.95467),(-7.0321,25.48326,1.95572),(-7.11226,25.56507,1.96188),(-6.8664,25.38668,1.74396),(-6.87759,25.40472,1.67578),(-7.68502,26.24953,1.86355),(-7.57507,26.32764,1.8708),(-7.54609,26.32872,1.92297),(-7.55394,26.33385,1.89532),(-7.56861,26.30674,1.96949),(-7.55048,26.31963,1.95243),(-7.65293,26.2547,1.96094),(-7.624,26.27234,1.97611),(-6.82969,25.25156,1.88069),(-6.8566,25.24699,1.84166),(-6.91545,25.22832,1.85995),(-7.04204,25.33517,1.66307),(-7.01133,25.29897,1.65585),(-6.95024,25.36719,1.61766),(-7.01949,25.49697,1.81134),(-7.08346,25.60712,1.8988),(-7.00362,25.51784,1.87771),(-7.1002,25.60346,1.83089),(-6.84108,25.35371,1.74875),(-6.78914,25.37345,1.8153),(-6.84123,25.32425,1.74686),(-6.79586,25.33077,1.81512),(-6.9856,25.28794,1.63885),(-6.86043,25.38847,1.75722),(-6.81585,25.42127,1.82952),(-6.88766,25.40805,1.77075),(-6.94805,25.43596,1.79282),(-6.90216,25.40938,1.77486),(-7.05872,25.32467,1.81832),(-7.01474,25.27858,1.80442),(-7.01147,25.27946,1.81389),(-7.1836,25.56223,1.70332),(-7.31304,25.81226,1.69098),(-7.16075,25.59189,1.69595),(-7.22514,25.82324,1.92788),(-7.23548,25.82887,1.85293),(-7.71637,26.271,1.75817),(-7.64351,26.32467,1.76352),(-7.71725,26.11026,1.76344),(-7.75868,26.12972,1.85645),(-7.74733,26.17016,1.77561),(-7.72409,26.08322,1.8536),(-7.59292,26.29311,1.97765),(-7.66165,26.27462,1.84579),(-7.67123,26.24377,1.93745),(-6.9759,25.43432,1.72155),(-7.38059,26.15783,1.96932),(-7.37887,26.13076,2.0275),(-7.30204,25.98484,2.00151),(-7.31123,25.99509,1.94859),(-7.2288,25.48918,1.80067),(-7.22562,25.50776,1.75525),(-7.01312,25.46014,1.95626),(-7.09595,25.43419,1.67024),(-7.5316,26.37328,1.83826),(-7.55969,26.36962,1.81484),(-6.92949,25.26591,1.61205),(-6.92609,25.25534,1.62325),(-7.37048,26.00518,1.6597),(-7.35092,26.00874,1.6671),(-7.27017,25.84043,1.69204),(-7.22451,25.82285,1.98818),(-7.21741,25.8286,1.9765),(-7.32335,25.96988,2.01489),(-6.97692,25.34643,1.94547),(-7.00554,25.34656,1.94123),(-7.10415,25.37444,1.68411),(-6.86053,25.3701,1.91028),(-6.97597,25.23597,1.71893),(-6.85427,25.29288,1.75269),(-6.85825,25.29355,1.73886),(-6.84784,25.3224,1.73511),(-6.79314,25.4139,1.8843),(-6.79522,25.42305,1.87223),(-6.84976,25.42832,1.90667),(-7.20357,25.53393,1.71869),(-7.5396,26.32386,2.00327),(-7.51596,26.34277,1.97404),(-7.76126,26.20234,1.86923),(-7.77015,26.1881,1.86587),(-7.51893,26.36834,1.88375),(-7.51247,26.35317,1.92507),(-7.53848,26.30578,1.73044),(-7.60547,26.2401,1.7147),(-7.43006,26.26902,1.91142),(-7.4486,26.33603,1.86014),(-7.45841,26.3181,1.92025),(-7.42748,26.28249,1.84661),(-7.49001,25.92394,1.69154),(-7.59298,26.04761,1.69062),(-7.42679,25.98042,1.65896),(-7.51518,26.1116,1.67104),(-6.98103,25.27275,1.8704),(-7.00674,25.27087,1.80334),(-7.03591,25.27274,1.75018),(-7.13321,25.48763,1.69123),(-7.75718,26.21827,1.79855),(-7.58225,26.29915,2.03002),(-7.55289,26.01429,2.02039),(-7.52469,26.11727,2.06764),(-7.59811,26.07087,2.03664),(-7.48422,26.06273,2.05038),(-7.64709,26.0376,1.97691),(-7.62431,25.97145,1.90322),(-7.60158,25.98185,1.96648),(-7.66869,26.02596,1.91422),(-7.67902,26.02774,1.84631),(-7.62988,26.00173,1.74879),(-7.63422,25.97228,1.83616),(-7.67429,26.05594,1.75783),(-7.63758,26.10286,1.70057),(-7.56135,26.17453,1.69109),(-7.57153,26.17653,2.08202),(-7.67399,26.18785,2.046),(-7.64205,26.13113,2.04698),(-7.60545,26.22539,2.07548),(-7.74398,26.13309,1.9321),(-7.6926,26.09333,1.987),(-7.72079,26.15173,1.99212),(-7.71306,26.08042,1.92446),(-7.49385,26.21846,2.0835),(-7.4087,26.2002,2.03967),(-7.44038,26.25598,2.04815),(-7.45194,26.1637,2.06831),(-7.70784,26.22658,1.73116),(-7.67724,26.16252,1.7135),(-7.44163,26.28975,1.98368),(-7.41314,26.24007,1.97878),(-7.46023,26.34567,1.80051),(-7.42247,26.26825,1.76195),(-7.4733,26.32013,1.98116),(-7.47181,26.28753,2.04242),(-7.52587,26.25174,2.0761),(-7.63442,26.27126,2.04193),(-7.41596,26.16629,1.68544),(-7.4896,26.22309,1.68907),(-7.44379,26.24818,1.71381),(-7.45783,26.14588,1.66355),(-7.51752,26.37751,1.82996),(-7.58847,26.35604,1.77645),(-7.59771,26.35327,1.79663),(-7.5514,26.37203,1.79697),(-7.70657,26.28173,1.78053),(-7.64432,26.32885,1.78235),(-7.74915,26.23298,1.81053),(-7.69017,26.23501,2.01921),(-7.68935,26.22444,2.03299),(-6.92658,25.46356,1.92675),(-6.97513,25.4222,1.95042),(-7.10488,25.35178,1.72377),(-7.02563,25.32573,1.87779),(-7.0857,25.32984,1.76851),(-7.07262,25.34242,1.82413),(-6.91369,25.39818,1.60484),(-6.90146,25.4065,1.6109),(-6.88345,25.29133,1.6008),(-6.87349,25.32176,1.59737),(-6.8945,25.29733,1.59268),(-6.85264,25.32328,1.65324),(-6.86681,25.28821,1.65868),(-6.81692,25.28422,1.824),(-6.77046,25.33529,1.86215),(-6.78822,25.29352,1.88159),(-6.79125,25.28362,1.8683),(-6.77253,25.3349,1.87694),(-6.95519,25.24285,1.78474),(-6.9504,25.24217,1.80097),(-6.99977,25.25198,1.80352),(-6.89489,25.25913,1.77456),(-6.8987,25.25991,1.76041),(-6.84875,25.35425,1.73661),(-6.83096,25.25851,1.89182),(-6.76491,25.38285,1.86271),(-6.76678,25.37993,1.87607),(-6.92363,25.47065,1.91214),(-6.99728,25.52968,1.92562),(-7.07065,25.61379,1.9422),(-6.95407,25.4034,1.94931),(-7.40732,26.10561,2.05279),(-6.87512,25.3478,1.5974),(-7.12819,25.6208,1.712),(-7.26065,25.84734,1.70625),(-7.13851,25.61444,1.69834),(-7.33456,26.01562,1.69239),(-7.39659,26.17926,1.72561),(-7.49023,25.85255,1.95251),(-7.44778,25.88856,1.99937),(-7.1872,25.50156,1.90126),(-7.3328,25.7441,1.97721),(-7.37276,25.71508,1.93318),(-7.1518,25.52719,1.94955),(-7.52815,25.84296,1.82436),(-7.5124,25.83776,1.88979),(-7.39595,25.7028,1.87394),(-7.21087,25.48869,1.85183),(-7.40873,25.70185,1.81936),(-7.1363,25.40895,1.84002),(-7.10458,25.5066,1.68518),(-7.03929,25.49967,1.74462),(-6.93101,25.45479,1.86089),(-7.32151,26.01029,1.87165),(-7.38558,26.16965,1.88767),(-7.32935,26.02018,1.77156),(-7.38895,26.18488,1.8066),(-7.5194,25.87657,1.75392),(-7.38904,25.93365,2.02209),(-7.11501,25.6113,1.75921),(-7.51698,26.35986,1.77031),(-7.48182,26.3698,1.81195),(-7.49375,26.33518,1.75587),(-7.277,25.78165,1.99214),(-7.39548,25.72764,1.76096),(-7.25227,25.83844,1.77264),(-6.88716,25.43599,1.91836),(-7.36144,25.7674,1.71519),(-6.85337,25.35608,1.65591),(-6.90763,25.25377,1.68011)]))),
        Shape(DEF='rmphal2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmphal2_Geo',coordIndex=[0,1,2,-1,3,2,4,-1,5,6,7,-1,5,8,6,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,20,22,21,-1,23,24,25,-1,26,24,27,-1,28,24,29,-1,30,24,31,-1,32,24,33,-1,34,35,36,-1,34,37,35,-1,38,2,39,-1,38,4,2,-1,40,41,42,-1,40,43,41,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,51,53,52,-1,54,55,56,-1,54,57,55,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,65,62,66,-1,65,67,62,-1,62,64,66,-1,68,69,70,-1,70,71,68,-1,72,73,74,-1,75,76,77,-1,76,78,77,-1,8,79,80,-1,81,82,76,-1,81,83,82,-1,74,73,68,-1,11,73,84,-1,85,73,13,-1,69,85,15,-1,86,87,88,-1,86,89,87,-1,90,91,18,-1,16,92,89,-1,87,92,93,-1,94,92,95,-1,90,92,91,-1,57,96,97,-1,57,98,96,-1,64,99,66,-1,100,45,51,-1,100,101,45,-1,102,64,63,-1,103,104,105,-1,104,106,105,-1,64,102,101,-1,107,64,108,-1,109,99,107,-1,110,111,112,-1,110,79,111,-1,59,113,114,-1,59,61,113,-1,61,115,113,-1,61,116,115,-1,114,117,59,-1,91,92,16,-1,95,92,90,-1,93,92,94,-1,89,92,87,-1,18,91,16,-1,118,93,49,-1,93,94,49,-1,88,87,119,-1,69,73,85,-1,15,85,13,-1,13,73,120,-1,121,9,84,-1,9,11,84,-1,84,73,72,-1,122,123,7,-1,124,125,126,-1,120,73,10,-1,5,79,8,-1,5,111,79,-1,72,127,128,-1,72,74,127,-1,68,73,69,-1,64,107,99,-1,105,107,103,-1,107,108,103,-1,129,51,50,-1,129,100,51,-1,130,88,131,-1,130,86,88,-1,132,49,48,-1,132,118,49,-1,45,44,51,-1,117,114,133,-1,65,134,135,-1,135,67,65,-1,136,137,138,-1,136,139,137,-1,44,46,140,-1,140,141,44,-1,97,142,143,-1,97,144,142,-1,32,35,38,-1,32,33,35,-1,25,24,32,-1,33,24,30,-1,31,24,28,-1,29,24,26,-1,27,24,23,-1,143,142,109,-1,145,83,81,-1,39,2,1,-1,1,146,39,-1,5,147,148,-1,148,111,5,-1,111,3,112,-1,111,148,3,-1,18,149,90,-1,15,70,69,-1,11,10,73,-1,147,5,7,-1,150,123,122,-1,20,123,150,-1,148,151,0,-1,148,147,151,-1,1,21,146,-1,19,21,1,-1,83,152,153,-1,152,83,145,-1,154,14,155,-1,154,149,14,-1,156,80,125,-1,80,156,157,-1,158,157,155,-1,158,6,157,-1,149,15,14,-1,149,18,15,-1,159,47,49,-1,159,160,47,-1,23,161,59,-1,23,25,161,-1,100,64,101,-1,100,108,64,-1,162,37,34,-1,37,162,163,-1,144,96,164,-1,96,144,97,-1,165,166,167,-1,165,168,166,-1,105,169,56,-1,106,169,105,-1,170,171,172,-1,171,170,173,-1,140,115,141,-1,140,174,115,-1,46,138,137,-1,138,46,45,-1,139,67,135,-1,139,136,67,-1,142,65,109,-1,142,134,65,-1,133,40,117,-1,40,133,43,-1,113,174,175,-1,113,115,174,-1,131,119,176,-1,131,88,119,-1,153,86,130,-1,153,17,86,-1,128,177,178,-1,127,177,128,-1,150,121,179,-1,150,9,121,-1,119,132,176,-1,119,118,132,-1,149,160,159,-1,160,149,154,-1,129,108,100,-1,103,108,129,-1,98,112,180,-1,112,98,110,-1,38,181,161,-1,181,38,39,-1,28,42,171,-1,28,29,42,-1,182,183,184,-1,183,182,185,-1,186,135,187,-1,135,186,139,-1,45,102,138,-1,45,101,102,-1,188,189,190,-1,191,189,188,-1,169,124,126,-1,169,167,124,-1,123,147,7,-1,123,151,147,-1,192,10,12,-1,192,120,10,-1,193,194,195,-1,193,104,194,-1,181,196,60,-1,181,197,196,-1,0,19,1,-1,151,19,0,-1,188,198,196,-1,188,199,198,-1,81,75,200,-1,81,76,75,-1,165,104,193,-1,106,104,165,-1,20,151,123,-1,151,20,19,-1,190,199,188,-1,190,201,199,-1,202,195,203,-1,193,195,202,-1,156,124,204,-1,124,156,125,-1,179,20,150,-1,179,22,20,-1,201,177,205,-1,190,177,201,-1,130,83,153,-1,83,130,82,-1,176,206,131,-1,176,203,206,-1,168,132,48,-1,168,202,132,-1,156,160,154,-1,156,204,160,-1,84,128,121,-1,128,84,72,-1,14,120,192,-1,14,13,120,-1,87,118,119,-1,87,93,118,-1,49,95,159,-1,49,94,95,-1,161,32,38,-1,32,161,25,-1,173,28,171,-1,173,31,28,-1,40,27,117,-1,40,26,27,-1,117,23,59,-1,117,27,23,-1,58,196,198,-1,58,60,196,-1,200,52,207,-1,200,75,52,-1,140,137,208,-1,46,137,140,-1,208,174,140,-1,208,209,174,-1,175,209,210,-1,174,209,175,-1,133,210,43,-1,210,133,175,-1,54,79,110,-1,54,126,79,-1,4,163,180,-1,4,37,163,-1,144,134,142,-1,134,144,211,-1,212,162,213,-1,212,164,162,-1,187,134,211,-1,134,187,135,-1,209,186,185,-1,208,186,209,-1,43,182,41,-1,43,210,182,-1,184,212,213,-1,184,183,212,-1,77,129,50,-1,77,194,129,-1,126,56,169,-1,54,56,126,-1,211,183,187,-1,211,212,183,-1,213,172,184,-1,170,172,213,-1,210,185,182,-1,185,210,209,-1,139,208,137,-1,139,186,208,-1,34,213,162,-1,34,170,213,-1,164,211,144,-1,211,164,212,-1,143,57,97,-1,55,57,143,-1,96,180,163,-1,98,180,96,-1,3,0,2,-1,148,0,3,-1,116,141,115,-1,116,53,141,-1,44,53,51,-1,53,44,141,-1,207,198,200,-1,58,198,207,-1,197,39,146,-1,39,197,181,-1,29,40,42,-1,29,26,40,-1,36,31,173,-1,31,36,30,-1,159,90,149,-1,159,95,90,-1,17,89,86,-1,17,16,89,-1,127,68,71,-1,74,68,127,-1,166,160,204,-1,166,47,160,-1,132,203,176,-1,132,202,203,-1,131,82,130,-1,82,131,206,-1,145,205,152,-1,145,201,205,-1,179,189,22,-1,179,178,189,-1,193,168,165,-1,193,202,168,-1,206,195,78,-1,206,203,195,-1,81,201,145,-1,199,201,81,-1,21,189,191,-1,21,22,189,-1,126,80,79,-1,126,125,80,-1,194,78,195,-1,78,194,77,-1,199,200,198,-1,199,81,200,-1,146,191,197,-1,146,21,191,-1,75,50,52,-1,75,77,50,-1,78,82,206,-1,76,82,78,-1,197,188,196,-1,197,191,188,-1,194,103,129,-1,104,103,194,-1,204,167,166,-1,167,204,124,-1,190,178,177,-1,189,178,190,-1,66,109,65,-1,109,66,99,-1,138,63,136,-1,138,102,63,-1,63,67,136,-1,62,67,63,-1,185,187,183,-1,187,185,186,-1,41,184,172,-1,184,41,182,-1,116,58,207,-1,116,61,58,-1,181,59,161,-1,60,59,181,-1,180,3,4,-1,180,112,3,-1,57,110,98,-1,110,57,54,-1,207,53,116,-1,52,53,207,-1,205,70,152,-1,205,71,70,-1,158,12,122,-1,12,158,192,-1,121,178,179,-1,121,128,178,-1,177,71,205,-1,177,127,71,-1,55,109,107,-1,55,143,109,-1,38,37,4,-1,37,38,35,-1,114,175,133,-1,113,175,114,-1,172,42,41,-1,42,172,171,-1,36,170,34,-1,36,173,170,-1,107,56,55,-1,105,56,107,-1,167,106,165,-1,169,106,167,-1,166,48,47,-1,48,166,168,-1,163,164,96,-1,163,162,164,-1,30,35,33,-1,30,36,35,-1,70,18,17,-1,18,70,15,-1,192,155,14,-1,192,158,155,-1,6,80,157,-1,6,8,80,-1,156,155,157,-1,156,154,155,-1,152,17,153,-1,70,17,152,-1,122,9,150,-1,122,12,9,-1,122,6,158,-1,7,6,122,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmphal2_Coord',point=[(-6.08287,25.24496,4.32886),(-6.07781,25.23807,4.34823),(-6.02849,25.18667,4.31908),(-6.0403,25.18813,4.30364),(-5.97018,25.15289,4.29586),(-6.24133,25.3807,4.36858),(-6.37628,25.48457,4.3762),(-6.34574,25.49004,4.42847),(-6.26682,25.3583,4.3319),(-6.38214,25.51166,4.4894),(-6.42293,25.48987,4.4713),(-6.41986,25.48779,4.48847),(-6.3949,25.51939,4.4562),(-6.46786,25.46989,4.44113),(-6.48139,25.49373,4.3589),(-6.51813,25.4208,4.43644),(-6.56593,25.36688,4.42755),(-6.58377,25.38253,4.51054),(-6.52344,25.41633,4.43096),(-6.22195,25.38568,4.42316),(-6.33315,25.48576,4.47487),(-6.22805,25.36711,4.45099),(-6.33616,25.47352,4.50861),(-5.93324,25.07781,4.33527),(-5.89193,25.08097,4.31117),(-5.93494,25.10056,4.32658),(-5.89338,25.05187,4.32019),(-5.91452,25.05632,4.33406),(-5.86069,25.07078,4.29533),(-5.87463,25.0573,4.30866),(-5.87925,25.10295,4.28963),(-5.86156,25.09111,4.28585),(-5.92254,25.11178,4.31393),(-5.8971,25.10778,4.29867),(-5.86746,25.131,4.2534),(-5.88293,25.13152,4.27455),(-5.86657,25.1249,4.26808),(-5.88425,25.13444,4.25943),(-5.96522,25.14744,4.31063),(-6.02569,25.1786,4.33301),(-5.89311,25.02325,4.32815),(-5.85701,25.02504,4.30059),(-5.85733,25.03363,4.30614),(-5.89469,25.01029,4.32777),(-6.0895,24.93931,4.20832),(-6.08796,24.94033,4.19472),(-6.08066,24.93293,4.20164),(-6.56222,25.36699,4.23758),(-6.57521,25.34229,4.24269),(-6.57919,25.36298,4.25519),(-6.19038,25.03947,4.25868),(-6.14059,24.99518,4.23339),(-6.17968,25.04254,4.2947),(-6.12258,25.00119,4.26284),(-6.13459,25.13276,4.20932),(-6.11942,25.06357,4.15305),(-6.17014,25.09766,4.18919),(-6.08193,25.09362,4.18392),(-6.09419,25.08752,4.36606),(-5.99967,25.07489,4.36296),(-6.05752,25.11375,4.38169),(-6.03633,25.05099,4.34195),(-6.03712,24.96887,4.09795),(-6.0415,24.9504,4.12463),(-6.08768,24.98996,4.14492),(-6.02258,24.98965,4.06643),(-6.04469,24.98988,4.09443),(-6.01423,24.96015,4.08362),(-6.485,25.44379,4.52885),(-6.49694,25.43201,4.50163),(-6.56435,25.39582,4.52751),(-6.50744,25.42592,4.56134),(-6.43352,25.47292,4.53283),(-6.4561,25.4566,4.49117),(-6.45993,25.45493,4.53845),(-6.23885,25.08106,4.32571),(-6.41123,25.18817,4.4055),(-6.24766,25.07835,4.28513),(-6.42534,25.17322,4.34928),(-6.14675,25.20878,4.2723),(-6.29035,25.33731,4.29755),(-6.37858,25.21299,4.45859),(-6.5655,25.27448,4.4601),(-6.52612,25.31117,4.51277),(-6.41679,25.48572,4.50563),(-6.48385,25.44233,4.46616),(-6.61491,25.33586,4.4496),(-6.60999,25.31862,4.36835),(-6.62552,25.3064,4.38902),(-6.59376,25.33953,4.416),(-6.52491,25.41825,4.35589),(-6.54544,25.38728,4.3967),(-6.56884,25.35994,4.35461),(-6.58821,25.32884,4.31408),(-6.57641,25.36269,4.2889),(-6.55353,25.39695,4.30217),(-5.97074,25.08393,4.18204),(-6.0126,25.06523,4.11785),(-6.04005,25.11879,4.22107),(-6.06683,25.01105,4.10541),(-6.14053,25.01031,4.20409),(-6.08816,24.96205,4.17336),(-6.06235,24.94641,4.15312),(-6.18843,25.06955,4.19893),(-6.24114,25.10611,4.22033),(-6.17758,25.0881,4.1894),(-6.23207,25.12592,4.20694),(-6.12701,25.05391,4.1535),(-6.13728,25.03046,4.17596),(-6.06006,25.03162,4.08087),(-6.09376,25.16156,4.24981),(-6.10906,25.23629,4.30355),(-6.05447,25.18299,4.28835),(-5.96755,25.00011,4.31896),(-5.94491,25.02099,4.35224),(-6.00309,24.97609,4.27039),(-6.07721,25.02968,4.307),(-5.93812,25.03187,4.35312),(-6.59356,25.30865,4.28628),(-6.61292,25.29551,4.34383),(-6.44551,25.48826,4.45178),(-6.38312,25.499,4.51715),(-6.37796,25.51857,4.44818),(-6.33783,25.49007,4.44729),(-6.3402,25.28041,4.24303),(-6.31572,25.30684,4.26699),(-6.18852,25.17402,4.22957),(-6.46131,25.44711,4.57628),(-6.40731,25.47869,4.55519),(-6.19319,25.04979,4.23091),(-6.61521,25.32192,4.45763),(-6.62445,25.29257,4.39081),(-6.58745,25.29613,4.27701),(-5.93572,25.01536,4.34957),(-6.00968,24.99656,4.06598),(-6.00165,24.9597,4.0832),(-6.02466,24.93274,4.1213),(-6.04581,24.92048,4.16806),(-6.05284,24.92675,4.16208),(-6.01497,24.92974,4.1247),(-6.05355,24.94558,4.23377),(-6.06323,24.95353,4.23749),(-6.04669,25.036,4.07562),(-6.05647,25.04199,4.08242),(-6.00218,25.06141,4.10958),(-6.50647,25.32462,4.52986),(-6.08119,25.22406,4.36225),(-6.23011,25.38874,4.38152),(-6.09301,25.24451,4.31396),(-6.49243,25.48433,4.34503),(-6.36529,25.50833,4.48448),(-6.22352,25.3907,4.3991),(-6.56303,25.38331,4.54036),(-6.58343,25.37003,4.52289),(-6.47952,25.48495,4.32474),(-6.46424,25.49916,4.3451),(-6.43867,25.44255,4.29956),(-6.41271,25.46231,4.33005),(-6.4189,25.52299,4.39976),(-6.54299,25.42088,4.27016),(-6.52847,25.42217,4.2566),(-5.97166,25.11603,4.33745),(-5.90759,25.11554,4.21181),(-5.9199,25.11959,4.21987),(-5.95815,25.08016,4.17304),(-6.39014,25.22673,4.22485),(-6.5285,25.34634,4.22687),(-6.37347,25.24575,4.21966),(-6.5453,25.32213,4.2304),(-6.22551,25.13543,4.20613),(-5.83391,25.0998,4.25329),(-5.83354,25.06195,4.28155),(-5.83087,25.05688,4.27259),(-5.83689,25.09936,4.26529),(-5.99591,24.96968,4.2668),(-5.9593,24.99294,4.31461),(-6.60607,25.27871,4.33143),(-6.45294,25.43487,4.58548),(-6.39192,25.47218,4.56324),(-6.36709,25.4948,4.51746),(-5.99803,25.14443,4.26364),(-6.0353,25.15139,4.36055),(-5.88972,24.99438,4.25504),(-5.92065,25.00486,4.17929),(-5.86722,25.0296,4.22652),(-5.93495,24.97796,4.21037),(-5.97676,24.94378,4.15757),(-5.96296,24.9751,4.1183),(-6.28072,25.28765,4.50233),(-6.36274,25.44643,4.55492),(-6.41012,25.39959,4.57976),(-6.24739,25.32716,4.48465),(-6.43195,25.52187,4.41459),(-6.4139,25.19784,4.2534),(-6.2503,25.08764,4.25214),(-6.42725,25.17905,4.30264),(-6.11402,25.15684,4.40967),(-6.091,25.1901,4.39116),(-6.15779,25.12888,4.40163),(-6.32657,25.25552,4.49344),(-6.20191,25.10427,4.37397),(-6.45367,25.36412,4.56651),(-6.5658,25.28079,4.2683),(-6.58176,25.25813,4.3212),(-6.48449,25.39557,4.24672),(-6.50495,25.41113,4.57075),(-6.58457,25.25319,4.38459),(-6.13654,25.0642,4.33757),(-6.01019,24.93106,4.19685),(-5.96479,24.96166,4.24371),(-5.92199,24.98048,4.28876),(-5.972,25.02005,4.09911),(-5.92813,25.04212,4.16362),(-5.87277,25.07774,4.20646)]))),
        Shape(DEF='rmphal3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmphal3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,7,10,8,-1,11,12,13,-1,11,14,12,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,26,24,27,-1,28,24,29,-1,30,24,31,-1,32,24,23,-1,33,34,35,-1,36,34,37,-1,38,34,39,-1,40,34,41,-1,35,34,42,-1,43,44,45,-1,44,46,45,-1,47,48,49,-1,50,51,52,-1,50,53,51,-1,36,54,39,-1,36,55,54,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,61,63,62,-1,64,65,66,-1,64,67,65,-1,51,68,69,-1,51,43,52,-1,43,45,52,-1,70,56,71,-1,72,73,74,-1,74,75,72,-1,53,76,77,-1,53,50,76,-1,78,79,80,-1,78,81,79,-1,82,83,84,-1,85,72,86,-1,85,87,72,-1,88,15,89,-1,15,18,89,-1,90,91,65,-1,92,93,94,-1,95,96,97,-1,66,65,98,-1,65,91,98,-1,27,69,26,-1,27,51,69,-1,62,57,59,-1,99,100,101,-1,101,102,99,-1,103,104,105,-1,106,107,108,-1,83,48,47,-1,47,84,83,-1,71,109,110,-1,111,109,71,-1,112,113,114,-1,50,115,76,-1,116,49,48,-1,117,77,118,-1,117,53,77,-1,107,105,119,-1,107,106,105,-1,68,117,120,-1,33,121,37,-1,33,122,121,-1,55,121,123,-1,124,102,101,-1,124,125,102,-1,126,127,21,-1,128,129,130,-1,131,132,133,-1,132,134,133,-1,135,136,137,-1,136,103,137,-1,73,138,101,-1,138,124,101,-1,139,140,54,-1,140,141,54,-1,89,142,88,-1,143,112,114,-1,82,84,144,-1,122,145,113,-1,113,121,122,-1,146,147,46,-1,46,44,146,-1,148,123,149,-1,148,139,123,-1,150,151,152,-1,151,153,152,-1,123,112,149,-1,53,68,51,-1,53,117,68,-1,52,115,50,-1,42,34,40,-1,41,34,38,-1,39,34,36,-1,37,34,33,-1,154,24,32,-1,155,24,30,-1,31,24,28,-1,29,24,26,-1,27,24,154,-1,25,24,155,-1,156,96,95,-1,156,157,96,-1,158,159,160,-1,160,161,158,-1,162,163,164,-1,165,166,167,-1,167,168,165,-1,169,90,170,-1,169,171,90,-1,106,172,173,-1,106,174,172,-1,175,7,9,-1,9,176,175,-1,177,178,179,-1,177,180,178,-1,156,128,130,-1,181,182,183,-1,171,184,22,-1,171,169,184,-1,185,186,187,-1,79,186,185,-1,188,81,189,-1,188,190,81,-1,141,191,17,-1,141,192,191,-1,193,175,140,-1,193,7,175,-1,10,99,194,-1,99,10,195,-1,196,125,3,-1,125,196,102,-1,182,197,198,-1,197,182,181,-1,98,199,200,-1,91,199,98,-1,181,200,197,-1,181,98,200,-1,91,171,199,-1,90,171,91,-1,201,127,126,-1,128,127,201,-1,202,135,137,-1,202,203,135,-1,135,180,136,-1,180,135,178,-1,177,204,205,-1,177,179,204,-1,206,196,207,-1,194,196,206,-1,175,208,192,-1,175,176,208,-1,174,209,172,-1,174,191,209,-1,173,105,106,-1,105,173,210,-1,170,211,169,-1,211,170,212,-1,12,213,13,-1,214,213,12,-1,166,215,167,-1,216,215,166,-1,12,168,167,-1,14,168,12,-1,209,217,218,-1,208,217,209,-1,164,160,159,-1,164,163,160,-1,93,2,1,-1,2,93,92,-1,127,97,219,-1,127,95,97,-1,220,221,222,-1,223,221,220,-1,224,225,226,-1,227,225,224,-1,228,222,229,-1,220,222,228,-1,230,42,142,-1,230,35,42,-1,4,0,5,-1,0,4,1,-1,231,158,232,-1,159,158,231,-1,108,233,234,-1,108,107,233,-1,104,117,118,-1,104,120,117,-1,155,235,70,-1,155,30,235,-1,236,28,237,-1,28,236,31,-1,238,239,240,-1,238,241,239,-1,242,159,231,-1,159,242,164,-1,157,243,244,-1,243,157,245,-1,11,96,246,-1,11,198,96,-1,247,22,184,-1,247,20,22,-1,133,94,93,-1,133,134,94,-1,205,61,177,-1,205,63,61,-1,59,236,62,-1,235,236,59,-1,248,9,249,-1,248,176,9,-1,152,249,150,-1,152,248,249,-1,49,89,234,-1,89,49,116,-1,147,250,110,-1,146,250,147,-1,149,143,251,-1,149,112,143,-1,111,138,87,-1,111,58,138,-1,142,116,228,-1,89,116,142,-1,190,0,2,-1,0,190,188,-1,125,57,252,-1,124,57,125,-1,216,253,215,-1,253,216,254,-1,255,256,257,-1,255,258,256,-1,259,132,260,-1,259,134,132,-1,2,261,262,-1,261,2,92,-1,48,223,220,-1,83,223,48,-1,263,264,265,-1,226,264,263,-1,266,267,114,-1,268,267,266,-1,124,58,57,-1,124,138,58,-1,251,148,149,-1,148,251,269,-1,173,270,271,-1,270,173,172,-1,59,70,235,-1,59,56,70,-1,23,250,146,-1,25,250,23,-1,180,61,272,-1,61,180,177,-1,120,103,136,-1,120,104,103,-1,241,126,239,-1,126,241,201,-1,262,273,274,-1,262,261,273,-1,79,211,80,-1,185,211,79,-1,268,86,267,-1,268,265,86,-1,100,73,101,-1,100,74,73,-1,133,178,131,-1,133,179,178,-1,5,188,207,-1,0,188,5,-1,249,8,275,-1,249,9,8,-1,172,218,270,-1,209,218,172,-1,103,210,137,-1,103,105,210,-1,131,135,203,-1,178,135,131,-1,132,203,258,-1,131,203,132,-1,150,275,78,-1,275,150,249,-1,276,165,277,-1,276,271,165,-1,278,257,279,-1,255,257,278,-1,280,158,161,-1,259,158,280,-1,262,187,186,-1,262,274,187,-1,152,253,254,-1,253,152,153,-1,281,14,282,-1,281,168,14,-1,246,279,282,-1,244,279,246,-1,231,278,243,-1,231,232,278,-1,247,274,240,-1,247,187,274,-1,67,283,284,-1,67,64,283,-1,166,271,270,-1,271,166,165,-1,130,242,245,-1,130,129,242,-1,163,201,241,-1,201,163,162,-1,128,162,129,-1,128,201,162,-1,200,19,219,-1,200,199,19,-1,28,285,237,-1,29,285,28,-1,44,23,146,-1,23,44,32,-1,272,60,286,-1,272,61,60,-1,193,269,195,-1,193,148,269,-1,55,37,121,-1,37,55,36,-1,122,35,230,-1,33,35,122,-1,88,41,15,-1,88,40,41,-1,120,286,68,-1,120,272,286,-1,77,119,118,-1,287,119,77,-1,18,234,89,-1,18,108,234,-1,115,84,76,-1,115,144,84,-1,87,109,111,-1,87,85,109,-1,114,145,266,-1,114,113,145,-1,288,226,225,-1,288,264,226,-1,115,45,227,-1,115,52,45,-1,289,83,82,-1,289,223,83,-1,267,72,75,-1,86,72,267,-1,227,144,115,-1,224,144,227,-1,220,116,48,-1,220,228,116,-1,147,225,46,-1,288,225,147,-1,229,266,145,-1,222,266,229,-1,109,264,288,-1,85,264,109,-1,107,287,233,-1,107,119,287,-1,41,16,15,-1,16,41,38,-1,142,40,88,-1,142,42,40,-1,38,54,16,-1,39,54,38,-1,62,252,57,-1,62,63,252,-1,235,31,236,-1,235,30,31,-1,51,154,43,-1,154,51,27,-1,29,69,285,-1,26,69,29,-1,197,219,97,-1,197,200,219,-1,21,239,126,-1,21,20,239,-1,129,164,242,-1,162,164,129,-1,156,245,157,-1,245,156,130,-1,198,97,96,-1,97,198,197,-1,11,282,14,-1,246,282,11,-1,67,212,170,-1,67,284,212,-1,273,160,238,-1,273,161,160,-1,243,279,244,-1,243,278,279,-1,257,282,279,-1,257,281,282,-1,283,215,253,-1,215,283,214,-1,212,80,211,-1,151,80,212,-1,261,161,273,-1,161,261,280,-1,232,255,278,-1,260,255,232,-1,281,256,277,-1,256,281,257,-1,254,248,152,-1,254,217,248,-1,189,78,275,-1,189,81,78,-1,203,256,258,-1,203,202,256,-1,210,271,276,-1,271,210,173,-1,176,217,208,-1,248,217,176,-1,275,206,189,-1,275,8,206,-1,204,1,4,-1,93,1,204,-1,221,265,268,-1,221,263,265,-1,141,16,54,-1,141,17,16,-1,184,187,247,-1,184,185,187,-1,153,283,253,-1,153,284,283,-1,238,274,273,-1,240,274,238,-1,136,272,120,-1,272,136,180,-1,110,288,147,-1,110,109,288,-1,64,214,283,-1,213,214,64,-1,250,155,70,-1,155,250,25,-1,74,269,251,-1,74,100,269,-1,267,143,114,-1,267,75,143,-1,222,268,266,-1,221,268,222,-1,85,265,264,-1,85,86,265,-1,224,82,144,-1,224,289,82,-1,151,78,80,-1,151,150,78,-1,2,186,190,-1,262,186,2,-1,261,94,280,-1,261,92,94,-1,260,258,255,-1,260,132,258,-1,277,168,281,-1,168,277,165,-1,202,277,256,-1,277,202,276,-1,195,100,99,-1,100,195,269,-1,112,121,113,-1,121,112,123,-1,145,230,229,-1,230,145,122,-1,77,84,287,-1,84,77,76,-1,87,73,72,-1,87,138,73,-1,75,251,143,-1,75,74,251,-1,71,250,70,-1,250,71,110,-1,84,233,287,-1,233,84,47,-1,286,237,285,-1,60,237,286,-1,148,140,139,-1,148,193,140,-1,285,68,286,-1,285,69,68,-1,93,179,133,-1,93,204,179,-1,280,134,259,-1,134,280,94,-1,170,65,67,-1,170,90,65,-1,66,213,64,-1,213,66,183,-1,157,246,96,-1,244,246,157,-1,245,231,243,-1,231,245,242,-1,160,241,238,-1,160,163,241,-1,240,20,247,-1,240,239,20,-1,237,62,236,-1,237,60,62,-1,56,111,71,-1,56,58,111,-1,123,54,55,-1,123,139,54,-1,104,119,105,-1,104,118,119,-1,47,234,233,-1,49,234,47,-1,158,260,232,-1,158,259,260,-1,284,151,212,-1,284,153,151,-1,189,207,188,-1,189,206,207,-1,142,229,230,-1,228,229,142,-1,226,289,224,-1,226,263,289,-1,227,46,225,-1,45,46,227,-1,223,263,221,-1,289,263,223,-1,154,44,43,-1,154,32,44,-1,219,21,127,-1,21,219,19,-1,218,254,216,-1,217,254,218,-1,13,198,11,-1,198,13,182,-1,216,270,218,-1,216,166,270,-1,167,214,12,-1,215,214,167,-1,183,13,213,-1,183,182,13,-1,208,191,192,-1,191,208,209,-1,8,194,206,-1,10,194,8,-1,3,207,196,-1,3,5,207,-1,4,205,204,-1,6,205,4,-1,276,137,210,-1,276,202,137,-1,128,95,127,-1,156,95,128,-1,98,183,66,-1,181,183,98,-1,63,6,252,-1,6,63,205,-1,252,3,125,-1,252,6,3,-1,194,102,196,-1,102,194,99,-1,195,7,193,-1,195,10,7,-1,175,141,140,-1,175,192,141,-1,17,174,18,-1,17,191,174,-1,190,79,81,-1,190,186,79,-1,199,22,19,-1,199,171,22,-1,169,185,184,-1,169,211,185,-1,174,108,18,-1,108,174,106,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmphal3_Coord',point=[(-6.01661,24.9658,3.19088),(-6.02585,24.94705,3.16093),(-6.23832,25.05193,3.20763),(-5.7899,24.88788,3.14256),(-5.91634,24.90409,3.13276),(-5.90215,24.92618,3.17009),(-5.8133,24.87327,3.09879),(-5.74663,24.94733,3.29106),(-5.86408,24.97065,3.27427),(-5.85725,24.97641,3.30919),(-5.75157,24.93155,3.24994),(-6.50435,24.98549,3.49972),(-6.41236,24.99916,3.53674),(-6.46881,25.02128,3.52869),(-6.44296,24.96012,3.4954),(-5.651,24.83049,3.32663),(-5.66491,24.88683,3.32638),(-5.69459,24.88909,3.32793),(-5.67409,24.81936,3.31799),(-6.4825,25.11973,3.35731),(-6.47265,25.17394,3.33706),(-6.48535,25.11657,3.3447),(-6.46509,25.17643,3.35726),(-5.63497,24.80639,2.99981),(-5.67247,24.79502,3.009),(-5.6506,24.82514,2.99861),(-5.6962,24.76645,3.02632),(-5.65776,24.75841,3.02255),(-5.71779,24.8049,3.0177),(-5.71562,24.79104,3.02094),(-5.69307,24.83034,3.00791),(-5.71159,24.81615,3.01451),(-5.63549,24.78917,3.00448),(-5.55119,24.89563,3.29129),(-5.58542,24.88806,3.30701),(-5.55099,24.87744,3.29413),(-5.58921,24.9251,3.29593),(-5.56672,24.91994,3.29149),(-5.62233,24.88475,3.31783),(-5.61328,24.91477,3.30863),(-5.58374,24.84776,3.30802),(-5.6116,24.86095,3.31734),(-5.56022,24.85931,3.30033),(-5.60395,24.75322,3.00711),(-5.59657,24.78591,2.99534),(-5.59723,24.75347,3.01339),(-5.58839,24.78637,2.99907),(-5.63312,24.751,3.2635),(-5.59597,24.77087,3.25453),(-5.61428,24.76218,3.28181),(-5.65465,24.7137,3.07521),(-5.63537,24.72256,3.02895),(-5.62799,24.72147,3.03459),(-5.66687,24.7168,3.07646),(-5.65126,24.93227,3.30976),(-5.59482,24.94775,3.28935),(-5.6727,24.88929,2.99697),(-5.71975,24.86312,3.06122),(-5.67274,24.90747,3.03782),(-5.70699,24.86998,3.01249),(-5.77636,24.82274,3.03304),(-5.80952,24.83118,3.05164),(-5.76187,24.83841,3.03011),(-5.79996,24.84629,3.05447),(-6.39662,25.1133,3.52621),(-6.40449,25.15374,3.49489),(-6.41452,25.11436,3.51772),(-6.38619,25.15302,3.49944),(-5.74522,24.74441,3.05368),(-5.7266,24.74758,3.04228),(-5.66621,24.88053,2.98931),(-5.6597,24.88739,2.9932),(-5.63049,24.90904,3.12784),(-5.64419,24.90883,3.13164),(-5.63571,24.93264,3.16664),(-5.62204,24.93239,3.16577),(-5.67256,24.71411,3.12863),(-5.68284,24.71883,3.1316),(-6.18684,25.11569,3.35317),(-6.31107,25.14119,3.33715),(-6.29539,25.15126,3.38492),(-6.20452,25.0932,3.3104),(-5.62887,24.75848,3.17958),(-5.61686,24.76682,3.21151),(-5.66734,24.73011,3.19647),(-5.61339,24.88779,3.07939),(-5.61269,24.89427,3.12977),(-5.65103,24.91002,3.08764),(-5.58119,24.80112,3.309),(-5.59026,24.77996,3.30253),(-6.42204,25.17791,3.4605),(-6.4267,25.14923,3.46418),(-6.25404,25.01899,3.15515),(-6.04351,24.91877,3.10294),(-6.264,24.99604,3.12821),(-6.53161,24.99783,3.388),(-6.55023,24.96238,3.41655),(-6.5269,25.00247,3.40146),(-6.43875,25.10017,3.47701),(-5.72249,24.91105,3.20403),(-5.67554,24.91017,3.19054),(-5.68469,24.88162,3.15887),(-5.73031,24.89205,3.16898),(-5.83099,24.77236,3.16826),(-5.80244,24.765,3.16158),(-5.80669,24.78635,3.22988),(-5.78081,24.82664,3.30183),(-5.70309,24.79219,3.28252),(-5.69159,24.80364,3.30142),(-5.61653,24.87791,3.03147),(-5.62299,24.86377,2.98352),(-5.66283,24.90731,3.03547),(-5.60456,24.97545,3.25275),(-5.55139,24.94849,3.26485),(-5.57118,24.93573,3.21525),(-5.63024,24.73163,3.0973),(-5.58702,24.77539,3.29339),(-5.7397,24.74037,3.08984),(-5.73477,24.7444,3.14589),(-5.72127,24.76019,3.20388),(-5.80229,24.7675,3.08808),(-5.55828,24.94903,3.27457),(-5.52001,24.89719,3.27703),(-5.60336,24.9715,3.26502),(-5.70054,24.87803,3.11439),(-5.7445,24.8754,3.13008),(-6.48887,25.10396,3.32064),(-6.49095,25.05693,3.35624),(-6.49957,25.03102,3.30209),(-6.50319,25.00408,3.24925),(-6.51758,24.98047,3.27765),(-6.06481,24.86607,3.11824),(-6.29014,24.91489,3.13781),(-6.05214,24.89994,3.09814),(-6.27622,24.95964,3.12014),(-5.95971,24.8151,3.13421),(-5.84891,24.78629,3.10427),(-5.95334,24.79517,3.19505),(-5.66301,24.90984,3.09259),(-5.65753,24.94925,3.28553),(-5.70145,24.94771,3.29464),(-5.70113,24.92461,3.31676),(-5.53627,24.82854,3.29406),(-5.61034,24.96085,3.20821),(-5.63,24.74772,3.145),(-5.51549,24.89493,3.26712),(-5.59673,24.81905,2.98213),(-5.59103,24.82144,2.98867),(-5.66252,24.95333,3.27134),(-5.6187,24.97472,3.25447),(-6.17704,25.11758,3.39599),(-6.28615,25.15103,3.4338),(-6.17877,25.08872,3.43967),(-6.28534,25.12899,3.48062),(-5.63942,24.77252,3.00964),(-5.67065,24.83359,3.00122),(-6.52932,24.98294,3.32796),(-6.55965,24.93748,3.32896),(-6.44243,25.01036,3.13919),(-6.48951,25.02701,3.16603),(-6.49022,25.07307,3.1744),(-6.42875,25.05896,3.14879),(-6.49424,25.0516,3.21757),(-6.4997,25.07201,3.18508),(-6.49754,25.03135,3.17764),(-6.244,24.9121,3.43876),(-6.22468,24.95476,3.46957),(-6.34893,24.98185,3.52168),(-6.38109,24.94404,3.48166),(-6.43066,25.19208,3.40588),(-6.40277,25.18463,3.45887),(-6.4452,25.18295,3.4094),(-5.8863,24.88131,3.3523),(-5.90625,24.84926,3.33297),(-5.76776,24.85047,3.32283),(-5.74533,24.94457,3.30502),(-5.85686,24.96795,3.32803),(-5.84294,24.84093,3.06529),(-5.95554,24.8415,3.1051),(-5.9465,24.87125,3.08644),(-5.84969,24.81572,3.0755),(-6.46394,25.06089,3.50276),(-6.48106,25.03671,3.51922),(-6.44241,25.0736,3.53185),(-6.44935,25.1838,3.35701),(-6.38559,25.1741,3.35454),(-6.32216,25.12781,3.29822),(-6.39618,25.16475,3.31636),(-6.00649,24.98488,3.22494),(-5.9914,24.9974,3.26036),(-6.21792,25.07789,3.27018),(-5.75498,24.89369,3.33107),(-5.74471,24.92487,3.32059),(-5.70463,24.95029,3.2812),(-5.76391,24.91423,3.21452),(-5.71268,24.93166,3.23932),(-5.77541,24.90087,3.17964),(-6.49251,25.03558,3.46336),(-6.5142,25.00561,3.48849),(-6.45211,25.13826,3.41794),(-6.46301,25.08236,3.4283),(-6.49254,25.07824,3.27103),(-6.07694,24.81034,3.22145),(-6.0747,24.83575,3.15314),(-5.94046,24.88567,3.09102),(-5.83314,24.85423,3.0692),(-5.87984,24.95226,3.23465),(-5.8918,24.94169,3.20135),(-5.86035,24.94595,3.34265),(-5.87019,24.91473,3.35471),(-5.93133,24.80728,3.2665),(-6.37422,25.18338,3.39642),(-6.35247,25.17809,3.45724),(-6.42799,25.0696,3.54184),(-6.37993,25.05273,3.54817),(-6.3214,25.03039,3.53237),(-6.20472,24.99451,3.47987),(-5.97056,24.97568,3.37978),(-5.98691,24.93607,3.39352),(-6.48869,25.05954,3.36927),(-5.55053,24.81895,3.23589),(-5.55794,24.83546,3.18575),(-5.53647,24.8462,3.22582),(-5.57117,24.80923,3.19748),(-5.59737,24.78691,3.11573),(-5.58534,24.80313,3.05784),(-5.58543,24.81491,3.10308),(-5.5951,24.7736,3.06952),(-5.52967,24.82603,3.28235),(-5.51505,24.85959,3.27297),(-5.52096,24.86291,3.28271),(-6.50261,24.97514,3.19324),(-6.46241,24.95469,3.16679),(-5.64123,24.75793,3.26826),(-5.62032,24.76706,3.28863),(-5.70266,24.85916,3.0051),(-5.74559,24.83419,3.02087),(-5.76137,24.81854,3.0256),(-6.48558,25.12384,3.21144),(-6.48658,25.15421,3.28004),(-6.47611,25.15957,3.26979),(-6.49674,25.11879,3.22058),(-6.50806,24.98247,3.2036),(-6.53021,24.93235,3.24302),(-6.55506,24.91778,3.32538),(-6.5335,24.94511,3.25129),(-6.54358,24.93909,3.42208),(-6.45868,25.18024,3.33192),(-5.96252,25.0024,3.35922),(-5.96211,25.01969,3.33155),(-5.62774,24.85702,2.98061),(-5.62529,24.96045,3.20893),(-5.77163,24.86305,3.08275),(-6.29467,25.08782,3.51057),(-6.18546,25.04698,3.46973),(-6.42501,24.8929,3.20435),(-6.30298,24.84657,3.27137),(-6.43766,24.86945,3.29707),(-6.30275,24.87181,3.18727),(-6.3866,24.99273,3.12614),(-6.40553,24.93786,3.15294),(-6.35213,25.07066,3.17456),(-6.34154,25.103,3.23069),(-5.58538,24.82452,3.14789),(-5.58944,24.84356,3.09184),(-5.59017,24.85223,3.13992),(-5.53711,24.88,3.22093),(-5.59362,24.91399,3.17131),(-5.56189,24.86651,3.17987),(-5.66911,24.93453,3.22675),(-6.0033,24.90895,3.39),(-6.02726,24.86985,3.36841),(-5.81387,24.80722,3.05686),(-6.41657,25.10317,3.18764),(-6.40831,25.13851,3.2454),(-5.97186,25.01759,3.2984),(-6.05603,24.82352,3.30713),(-6.2808,24.85903,3.36713),(-6.48604,24.90884,3.21929),(-6.50399,24.88836,3.31181),(-6.36867,25.03611,3.13713),(-6.42391,24.89387,3.40782),(-6.48808,24.9133,3.41925),(-6.35379,25.10995,3.52889),(-6.34365,25.15046,3.50094),(-5.7597,24.79473,3.03088),(-5.77846,24.79836,3.03877),(-5.67547,24.73512,3.19815),(-5.58732,24.83402,3.04609),(-5.59648,24.79798,3.15727)]))),
        Shape(DEF='rmphal4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmphal4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,6,9,7,-1,10,11,12,-1,10,13,11,-1,14,15,16,-1,14,17,15,-1,18,19,20,-1,20,21,18,-1,22,23,16,-1,24,25,26,-1,27,28,29,-1,27,30,31,-1,27,32,33,-1,27,34,35,-1,27,29,36,-1,37,38,39,-1,37,40,41,-1,37,42,43,-1,37,44,45,-1,37,46,38,-1,47,48,49,-1,49,50,47,-1,51,52,53,-1,54,55,56,-1,56,57,54,-1,58,59,60,-1,60,61,58,-1,62,63,64,-1,63,65,64,-1,66,67,68,-1,67,69,68,-1,13,70,71,-1,13,10,70,-1,72,73,54,-1,55,54,48,-1,48,47,55,-1,59,74,75,-1,76,57,56,-1,76,77,57,-1,61,78,79,-1,61,80,78,-1,81,82,83,-1,84,85,86,-1,84,87,85,-1,15,88,16,-1,15,89,88,-1,90,91,92,-1,93,94,11,-1,94,95,11,-1,79,96,97,-1,79,98,96,-1,99,100,101,-1,100,102,101,-1,103,104,105,-1,106,107,108,-1,109,25,110,-1,98,79,78,-1,78,111,98,-1,112,113,114,-1,115,116,72,-1,117,89,15,-1,117,118,89,-1,77,115,57,-1,77,119,115,-1,52,51,120,-1,121,76,56,-1,122,123,124,-1,125,74,126,-1,125,127,74,-1,51,82,81,-1,51,53,82,-1,88,22,16,-1,128,117,129,-1,61,60,63,-1,130,131,132,-1,133,70,104,-1,70,105,104,-1,134,135,136,-1,96,137,138,-1,96,98,137,-1,139,66,18,-1,92,91,23,-1,23,22,92,-1,124,123,140,-1,84,138,137,-1,137,87,84,-1,82,141,83,-1,136,142,143,-1,136,135,142,-1,122,112,144,-1,144,145,122,-1,146,50,147,-1,50,49,147,-1,11,95,12,-1,95,85,12,-1,124,86,113,-1,121,56,55,-1,148,149,150,-1,37,45,46,-1,37,43,44,-1,37,41,42,-1,37,39,40,-1,27,36,151,-1,27,35,152,-1,27,33,34,-1,27,31,32,-1,27,151,30,-1,27,152,28,-1,153,154,155,-1,16,23,156,-1,23,157,156,-1,158,78,159,-1,158,160,78,-1,108,107,161,-1,4,162,163,-1,80,159,78,-1,159,62,164,-1,62,159,80,-1,4,2,5,-1,4,163,2,-1,165,18,21,-1,165,139,18,-1,109,166,108,-1,110,166,109,-1,165,24,26,-1,165,21,24,-1,167,168,169,-1,168,167,170,-1,158,164,171,-1,158,159,164,-1,78,172,111,-1,160,172,78,-1,173,174,175,-1,173,176,174,-1,177,156,93,-1,177,178,156,-1,179,4,180,-1,4,179,162,-1,181,182,183,-1,181,184,182,-1,185,186,187,-1,188,186,185,-1,180,3,189,-1,180,4,3,-1,190,181,191,-1,188,181,190,-1,178,192,187,-1,178,177,192,-1,154,193,194,-1,153,193,154,-1,150,136,148,-1,134,136,150,-1,131,109,132,-1,131,1,109,-1,195,196,197,-1,195,198,196,-1,199,200,201,-1,202,200,199,-1,203,197,204,-1,203,195,197,-1,205,46,90,-1,38,46,205,-1,103,172,206,-1,172,103,175,-1,158,149,160,-1,158,150,149,-1,207,194,208,-1,207,209,194,-1,88,210,211,-1,89,210,88,-1,116,119,128,-1,115,119,116,-1,42,114,94,-1,42,41,114,-1,152,212,75,-1,212,152,35,-1,213,33,214,-1,213,34,33,-1,215,216,217,-1,218,216,215,-1,219,194,209,-1,219,154,194,-1,220,221,222,-1,220,223,221,-1,189,130,224,-1,3,130,189,-1,225,21,20,-1,24,21,225,-1,100,135,134,-1,135,100,99,-1,164,64,7,-1,64,164,62,-1,60,213,63,-1,60,212,213,-1,226,70,133,-1,71,70,226,-1,52,92,211,-1,52,120,92,-1,146,227,127,-1,146,147,227,-1,86,140,84,-1,124,140,86,-1,228,138,229,-1,96,138,228,-1,126,97,230,-1,58,97,126,-1,90,120,203,-1,90,92,120,-1,231,149,148,-1,231,206,149,-1,185,232,184,-1,185,233,232,-1,234,235,236,-1,237,235,234,-1,238,101,239,-1,99,101,238,-1,148,143,240,-1,148,136,143,-1,231,241,104,-1,231,242,241,-1,51,198,195,-1,51,81,198,-1,243,244,202,-1,245,244,243,-1,228,246,230,-1,228,247,246,-1,248,249,123,-1,248,250,249,-1,79,58,61,-1,58,79,97,-1,227,152,75,-1,227,28,152,-1,182,69,179,-1,251,69,182,-1,127,252,146,-1,252,127,125,-1,253,254,116,-1,253,8,254,-1,215,255,256,-1,215,217,255,-1,232,257,251,-1,257,232,258,-1,20,259,225,-1,259,20,260,-1,93,157,94,-1,156,157,93,-1,196,245,250,-1,244,245,196,-1,171,150,158,-1,171,134,150,-1,105,175,103,-1,173,175,105,-1,177,71,192,-1,177,13,71,-1,169,261,167,-1,169,17,261,-1,168,253,129,-1,168,262,253,-1,170,237,263,-1,170,235,237,-1,233,71,226,-1,71,233,192,-1,264,235,265,-1,264,236,235,-1,207,234,266,-1,207,239,234,-1,143,267,256,-1,143,142,267,-1,268,241,260,-1,268,269,241,-1,251,184,232,-1,251,182,184,-1,264,270,236,-1,264,271,270,-1,221,270,222,-1,270,221,266,-1,256,193,215,-1,267,193,256,-1,68,268,19,-1,268,68,257,-1,189,271,272,-1,189,224,271,-1,3,131,130,-1,3,5,131,-1,161,223,220,-1,161,107,223,-1,106,154,219,-1,106,155,154,-1,25,216,110,-1,216,25,24,-1,5,1,131,-1,2,1,5,-1,32,73,273,-1,32,31,73,-1,54,151,48,-1,54,30,151,-1,212,34,213,-1,34,212,35,-1,63,80,61,-1,62,80,63,-1,43,94,157,-1,43,42,94,-1,40,144,112,-1,40,39,144,-1,90,45,91,-1,46,45,90,-1,44,157,23,-1,44,43,157,-1,89,274,210,-1,274,89,118,-1,243,125,246,-1,252,125,243,-1,204,248,145,-1,204,197,248,-1,146,199,50,-1,146,252,199,-1,120,195,203,-1,120,51,195,-1,201,141,121,-1,201,200,141,-1,249,228,229,-1,249,247,228,-1,275,81,83,-1,198,81,275,-1,121,47,201,-1,55,47,121,-1,252,202,199,-1,243,202,252,-1,122,248,123,-1,145,248,122,-1,230,125,126,-1,125,230,246,-1,141,76,121,-1,141,82,76,-1,22,211,92,-1,88,211,22,-1,274,119,77,-1,119,274,118,-1,116,276,72,-1,276,116,254,-1,91,44,23,-1,45,44,91,-1,144,38,205,-1,144,39,38,-1,114,40,112,-1,114,41,40,-1,87,12,85,-1,87,176,12,-1,174,98,111,-1,137,98,174,-1,254,65,276,-1,65,254,64,-1,49,29,147,-1,49,36,29,-1,73,30,54,-1,73,31,30,-1,33,273,214,-1,33,32,273,-1,0,26,1,-1,26,0,165,-1,108,155,106,-1,166,155,108,-1,67,139,277,-1,139,67,66,-1,153,166,218,-1,153,155,166,-1,107,219,223,-1,219,107,106,-1,188,261,186,-1,188,190,261,-1,68,251,257,-1,69,251,68,-1,225,255,217,-1,255,225,259,-1,209,266,221,-1,266,209,207,-1,222,271,224,-1,271,222,270,-1,264,272,271,-1,272,264,191,-1,226,232,233,-1,226,258,232,-1,242,255,259,-1,255,242,240,-1,142,208,267,-1,142,238,208,-1,266,236,270,-1,266,234,236,-1,167,190,265,-1,261,190,167,-1,101,263,237,-1,101,102,263,-1,102,262,263,-1,102,6,262,-1,129,169,168,-1,117,169,129,-1,14,187,186,-1,14,178,187,-1,70,173,105,-1,10,173,70,-1,160,206,172,-1,160,149,206,-1,100,6,102,-1,9,6,100,-1,250,247,249,-1,245,247,250,-1,260,242,259,-1,242,260,241,-1,240,256,255,-1,143,256,240,-1,218,110,216,-1,218,166,110,-1,116,129,253,-1,129,116,128,-1,7,254,8,-1,7,64,254,-1,29,227,147,-1,29,28,227,-1,212,59,75,-1,212,60,59,-1,17,186,261,-1,17,14,186,-1,123,229,140,-1,123,249,229,-1,197,250,248,-1,197,196,250,-1,246,245,243,-1,247,245,246,-1,200,83,141,-1,275,83,200,-1,269,104,241,-1,133,104,269,-1,148,242,231,-1,148,240,242,-1,239,237,234,-1,101,237,239,-1,265,191,264,-1,265,190,191,-1,170,265,235,-1,170,167,265,-1,176,137,174,-1,176,87,137,-1,124,112,122,-1,124,113,112,-1,145,205,204,-1,145,144,205,-1,82,77,76,-1,77,82,274,-1,96,230,97,-1,96,228,230,-1,84,229,138,-1,84,140,229,-1,74,227,75,-1,74,127,227,-1,82,210,274,-1,82,53,210,-1,86,95,113,-1,86,85,95,-1,276,214,273,-1,276,65,214,-1,258,133,269,-1,258,226,133,-1,273,72,276,-1,72,273,73,-1,134,9,100,-1,171,9,134,-1,142,99,238,-1,142,135,99,-1,19,66,68,-1,18,66,19,-1,67,179,69,-1,67,162,179,-1,220,224,130,-1,220,222,224,-1,223,209,221,-1,223,219,209,-1,193,218,215,-1,153,218,193,-1,217,24,225,-1,216,24,217,-1,214,63,213,-1,63,214,65,-1,59,126,74,-1,58,126,59,-1,95,114,113,-1,95,94,114,-1,57,72,54,-1,72,57,115,-1,128,118,117,-1,119,118,128,-1,53,211,210,-1,53,52,211,-1,208,239,207,-1,239,208,238,-1,257,269,268,-1,269,257,258,-1,206,104,103,-1,206,231,104,-1,203,205,90,-1,205,203,204,-1,202,275,200,-1,244,275,202,-1,50,201,47,-1,199,201,50,-1,198,244,196,-1,198,275,244,-1,151,49,48,-1,36,49,151,-1,1,25,109,-1,1,26,25,-1,130,161,220,-1,130,132,161,-1,267,194,193,-1,267,208,194,-1,187,233,185,-1,187,192,233,-1,183,191,181,-1,183,272,191,-1,272,180,189,-1,183,180,272,-1,188,184,181,-1,188,185,184,-1,183,179,180,-1,183,182,179,-1,19,260,20,-1,19,268,260,-1,117,17,169,-1,17,117,15,-1,16,178,14,-1,178,16,156,-1,11,177,93,-1,13,177,11,-1,10,176,173,-1,10,12,176,-1,175,111,172,-1,175,174,111,-1,7,171,164,-1,9,171,7,-1,262,8,253,-1,262,6,8,-1,263,168,170,-1,262,168,263,-1,108,132,109,-1,108,161,132,-1,277,162,67,-1,277,163,162,-1,0,163,277,-1,0,2,163,-1,277,165,0,-1,277,139,165,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmphal4_Coord',point=[(-6.67183,25.18004,2.61171),(-6.68912,25.1629,2.54213),(-6.68239,25.15745,2.62032),(-6.72845,25.08999,2.66165),(-6.7004,25.11988,2.70372),(-6.70935,25.11538,2.64435),(-6.08521,24.99712,2.33819),(-5.96266,25.00757,2.31266),(-5.96933,24.9796,2.31912),(-6.07534,25.03107,2.32387),(-6.01916,25.1145,2.58472),(-5.8998,25.09042,2.58627),(-5.89955,25.09368,2.57482),(-6.02005,25.10738,2.59704),(-6.04856,25.00919,2.60867),(-5.92919,24.96223,2.56188),(-5.91914,24.98702,2.59088),(-6.06454,24.97558,2.58324),(-6.64024,25.27708,2.67025),(-6.62054,25.28384,2.67302),(-6.64294,25.29736,2.61254),(-6.65781,25.28807,2.61219),(-5.81622,24.9593,2.59516),(-5.79673,24.97163,2.60862),(-6.67614,25.287,2.53071),(-6.68632,25.22572,2.52594),(-6.68524,25.22748,2.53978),(-5.77461,24.9759,2.27247),(-5.75251,25.00981,2.26856),(-5.73512,24.9909,2.26963),(-5.7586,24.93671,2.28396),(-5.79966,24.94262,2.28349),(-5.82084,24.96798,2.2783),(-5.8236,24.98273,2.27638),(-5.8175,24.99521,2.27536),(-5.79831,25.01182,2.2729),(-5.73511,24.97231,2.27223),(-5.72974,25.03756,2.60471),(-5.69147,25.02998,2.59486),(-5.69254,25.04931,2.59418),(-5.71039,25.07381,2.59526),(-5.73474,25.07745,2.59736),(-5.76079,25.06378,2.60584),(-5.76938,25.0308,2.61033),(-5.75654,25.00661,2.60833),(-5.72541,24.99555,2.60093),(-5.70067,25.00977,2.5977),(-5.69404,24.93586,2.28232),(-5.70018,24.9361,2.27485),(-5.69316,24.9721,2.2678),(-5.68516,24.9725,2.27286),(-5.72584,24.92192,2.53422),(-5.74793,24.9083,2.55879),(-5.76436,24.89813,2.53581),(-5.73371,24.89964,2.28921),(-5.7267,24.89814,2.29594),(-5.75931,24.88326,2.33327),(-5.77241,24.8857,2.33324),(-5.79234,25.09189,2.31661),(-5.77965,25.07574,2.27183),(-5.8161,25.05181,2.28068),(-5.83402,25.04256,2.32804),(-5.91685,25.01678,2.30814),(-5.87342,25.01375,2.28726),(-5.9254,25.00094,2.30198),(-5.88784,24.9963,2.2863),(-6.62939,25.24825,2.70476),(-6.63573,25.20357,2.72383),(-6.6065,25.24766,2.71508),(-6.61822,25.20218,2.7364),(-6.13514,25.14529,2.60301),(-6.13704,25.13056,2.62037),(-5.85284,24.91353,2.30219),(-5.83215,24.91929,2.29339),(-5.76549,25.07492,2.2695),(-5.77128,25.06797,2.26371),(-5.78505,24.87565,2.3861),(-5.79647,24.87967,2.38833),(-5.9187,25.04711,2.4143),(-5.8217,25.05088,2.38722),(-5.90866,25.03164,2.34942),(-5.74162,24.92237,2.48626),(-5.7897,24.88356,2.45904),(-5.74932,24.91732,2.45051),(-5.76606,25.1278,2.50528),(-5.80864,25.10928,2.56914),(-5.75409,25.13187,2.55312),(-5.81379,25.08753,2.51744),(-5.83147,24.94764,2.57959),(-5.84252,24.93494,2.55087),(-5.67282,24.97979,2.59071),(-5.71971,24.94694,2.59644),(-5.72686,24.92528,2.58583),(-5.89988,25.06601,2.60112),(-5.79795,25.08085,2.60392),(-5.80581,25.10207,2.58218),(-5.76712,25.07663,2.41787),(-5.78624,25.08578,2.37516),(-5.81905,25.05606,2.43069),(-6.42904,25.10193,2.32281),(-6.18883,25.05403,2.32481),(-6.44285,25.05224,2.33336),(-6.20238,25.0154,2.33959),(-6.15657,25.13189,2.5072),(-6.3838,25.22612,2.58111),(-6.14732,25.1366,2.55022),(-6.69006,25.1212,2.41257),(-6.70772,25.09072,2.43534),(-6.6897,25.14149,2.46965),(-6.68957,25.1618,2.52808),(-6.68596,25.21559,2.49912),(-5.91114,25.05888,2.44993),(-5.69709,25.10767,2.58632),(-5.74514,25.12779,2.56568),(-5.74125,25.10166,2.59261),(-5.85161,24.90477,2.33987),(-5.91837,24.93008,2.3327),(-5.94233,24.93093,2.48411),(-5.84887,24.91116,2.46294),(-5.85417,24.90175,2.39907),(-5.72197,24.92191,2.57625),(-5.73804,24.90025,2.36179),(-5.69079,25.10967,2.57789),(-5.706,25.1002,2.51773),(-5.74171,25.13315,2.55266),(-5.72497,25.06214,2.31395),(-5.78067,25.09261,2.31544),(-5.72438,25.05346,2.26165),(-5.9281,24.91767,2.40842),(-5.95921,24.923,2.41228),(-6.75312,25.05198,2.57611),(-6.72739,25.09894,2.56476),(-6.73142,25.09335,2.55021),(-6.37641,25.22659,2.64473),(-6.18246,25.07154,2.3325),(-6.41985,25.13942,2.33719),(-6.41458,25.16027,2.36869),(-5.81708,25.07085,2.47493),(-5.76655,25.10018,2.45802),(-6.64356,25.24653,2.66811),(-5.75282,25.12851,2.50691),(-5.7452,24.91066,2.41321),(-6.53282,25.17243,2.33459),(-6.52205,25.20809,2.37517),(-5.6583,25.05442,2.58397),(-5.65213,25.05361,2.57407),(-5.68892,25.0103,2.26612),(-5.69382,25.00838,2.25827),(-6.40734,25.18845,2.42826),(-6.16779,25.115,2.44028),(-6.17296,25.09609,2.39937),(-5.73875,24.95407,2.27493),(-5.77429,25.01722,2.26952),(-6.67951,25.20033,2.3595),(-6.67726,25.16193,2.3543),(-6.67983,25.17534,2.38842),(-5.90986,25.0316,2.60661),(-5.80848,25.02952,2.61396),(-6.05229,25.06064,2.38014),(-5.93903,25.03486,2.35712),(-6.04324,25.08105,2.42729),(-6.7209,25.08637,2.4876),(-6.66387,25.15781,2.72901),(-6.67305,25.16034,2.68516),(-5.95387,25.0214,2.31974),(-6.66299,25.24013,2.61152),(-6.68154,25.19514,2.44596),(-6.21536,24.94634,2.53094),(-6.09168,24.93697,2.42575),(-6.07865,24.94131,2.50679),(-6.2249,24.94297,2.4377),(-6.07064,25.04578,2.33127),(-6.03839,25.09195,2.45927),(-6.0227,25.10911,2.5382),(-5.9055,25.06799,2.48338),(-6.03104,25.09995,2.49529),(-5.89808,25.0816,2.52617),(-6.02464,25.07915,2.61042),(-6.03436,25.04451,2.61761),(-6.64996,25.15299,2.74217),(-6.68682,25.10166,2.71549),(-6.55923,25.07082,2.71857),(-6.60003,25.13864,2.74938),(-6.62834,25.08373,2.72511),(-6.53557,25.12036,2.74054),(-6.4046,25.09399,2.7091),(-6.17724,25.027,2.63478),(-6.16248,25.05563,2.64414),(-6.4213,25.05294,2.69013),(-6.71769,25.06644,2.67452),(-6.43441,25.01162,2.64965),(-6.58467,25.03254,2.67128),(-6.14631,25.09957,2.63717),(-6.66833,25.20332,2.35078),(-6.66791,25.15611,2.34359),(-5.67932,24.97681,2.52731),(-5.68151,25.00032,2.47647),(-5.66519,25.00727,2.52228),(-5.69507,24.97075,2.48346),(-5.69091,24.98229,2.33622),(-5.71,24.95705,2.3924),(-5.70062,24.94947,2.34323),(-5.69778,24.98852,2.38449),(-5.66423,24.97906,2.57919),(-5.65005,25.01604,2.57575),(-5.65772,25.0179,2.58541),(-6.16562,25.125,2.46861),(-6.62735,25.08421,2.34237),(-6.6072,25.14442,2.32509),(-6.6797,25.09743,2.35488),(-5.7739,24.90429,2.54047),(-5.75545,24.91217,2.56562),(-5.80987,25.04173,2.27227),(-5.85496,25.01144,2.27945),(-5.87096,24.99368,2.28018),(-6.66972,25.25071,2.39626),(-6.68178,25.27332,2.46788),(-6.66993,25.28075,2.46029),(-6.68217,25.24371,2.4027),(-6.68779,25.10435,2.36595),(-6.7497,25.03717,2.48252),(-6.7122,25.04487,2.39649),(-6.74317,25.01728,2.4783),(-6.71798,25.05809,2.40615),(-6.74541,25.02725,2.58136),(-6.66137,25.29494,2.52891),(-6.37864,25.1988,2.68319),(-5.72848,25.04658,2.25713),(-5.75389,25.07791,2.41609),(-5.75394,25.1018,2.45856),(-5.7725,25.08732,2.37157),(-6.39614,25.20822,2.49877),(-6.50794,25.18249,2.73612),(-6.38676,25.15096,2.7082),(-6.5891,25.01812,2.37892),(-6.46919,24.96267,2.4596),(-6.61286,24.98079,2.46776),(-6.45958,25.00015,2.37673),(-6.54626,25.13053,2.31972),(-6.56527,25.07131,2.33647),(-6.51998,25.2365,2.43596),(-6.50167,25.26915,2.59748),(-6.51058,25.25395,2.51127),(-5.70241,25.01967,2.37589),(-5.70433,24.99257,2.43208),(-5.71014,25.02226,2.42664),(-5.72871,25.0662,2.36522),(-5.73508,25.06628,2.41826),(-5.6675,25.04311,2.52137),(-5.72207,25.08226,2.46638),(-5.68695,25.03325,2.47372),(-6.57523,25.19747,2.7413),(-5.69351,25.01594,2.32765),(-5.97033,24.94514,2.3453),(-5.929,24.97505,2.30376),(-6.59476,25.26543,2.44398),(-6.59343,25.23576,2.38118),(-6.5637,25.2439,2.71883),(-6.49706,25.22988,2.7115),(-6.59326,25.28399,2.5212),(-6.58278,25.29585,2.60775),(-6.19667,24.98791,2.6042),(-6.09162,24.96551,2.36441),(-6.21524,24.97866,2.37052),(-6.616,24.98796,2.58111),(-6.45962,24.96403,2.56311),(-6.6556,25.02975,2.38532),(-6.59797,25.19019,2.33746),(-6.56852,25.28367,2.67343),(-6.49713,25.26521,2.6644),(-6.68505,24.99524,2.47366),(-6.68555,25.00354,2.58399),(-6.65189,25.0444,2.67648),(-5.86831,24.96826,2.28289),(-5.79872,24.88814,2.46027),(-5.71533,24.96311,2.4369),(-5.88913,24.97003,2.28889),(-6.65441,25.19317,2.67195)]))),
        Shape(DEF='rmphal5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmphal5_Geo',coordIndex=[0,1,2,-1,2,3,0,-1,4,5,6,-1,4,7,5,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,14,17,15,-1,18,19,20,-1,14,16,8,-1,21,12,22,-1,23,24,25,-1,25,26,23,-1,27,28,29,-1,29,30,27,-1,31,32,33,-1,31,34,32,-1,35,36,37,-1,38,39,40,-1,38,34,39,-1,41,42,43,-1,44,45,46,-1,45,47,46,-1,48,49,50,-1,50,51,48,-1,37,36,40,-1,40,39,37,-1,52,53,54,-1,52,55,53,-1,56,57,58,-1,58,59,56,-1,60,61,62,-1,62,63,60,-1,64,65,66,-1,64,67,65,-1,68,19,69,-1,68,70,19,-1,15,71,72,-1,15,73,71,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,79,81,80,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,90,91,88,-1,92,93,94,-1,94,95,24,-1,12,96,97,-1,94,23,98,-1,46,47,30,-1,47,27,30,-1,94,99,92,-1,94,28,100,-1,64,66,101,-1,66,102,101,-1,102,103,104,-1,102,66,103,-1,8,105,106,-1,9,8,16,-1,11,107,108,-1,11,13,107,-1,22,12,109,-1,67,89,110,-1,89,88,110,-1,71,73,53,-1,53,111,71,-1,112,113,8,-1,114,115,116,-1,115,117,116,-1,85,118,119,-1,85,87,118,-1,120,12,121,-1,12,11,122,-1,19,70,20,-1,8,10,112,-1,123,103,66,-1,66,65,123,-1,124,125,126,-1,124,127,125,-1,67,110,128,-1,128,65,67,-1,94,29,28,-1,94,100,99,-1,38,129,130,-1,38,131,129,-1,132,94,98,-1,94,24,23,-1,94,133,95,-1,96,12,120,-1,93,133,94,-1,134,135,136,-1,134,6,135,-1,105,8,113,-1,76,75,0,-1,15,137,73,-1,138,70,68,-1,139,140,42,-1,42,41,139,-1,141,142,143,-1,144,145,138,-1,138,68,144,-1,146,67,64,-1,146,89,67,-1,147,142,141,-1,147,148,142,-1,149,150,60,-1,150,61,60,-1,143,142,57,-1,57,56,143,-1,132,29,94,-1,130,32,34,-1,34,38,130,-1,36,35,151,-1,151,152,36,-1,13,12,21,-1,153,141,143,-1,143,154,153,-1,155,114,116,-1,14,8,20,-1,108,156,11,-1,156,122,11,-1,72,71,157,-1,157,158,72,-1,159,160,161,-1,159,111,160,-1,162,163,164,-1,162,165,163,-1,97,109,12,-1,106,20,8,-1,122,121,12,-1,136,166,134,-1,166,167,134,-1,121,156,82,-1,156,121,122,-1,156,83,82,-1,135,83,156,-1,106,18,20,-1,168,18,106,-1,2,169,170,-1,4,169,2,-1,147,97,63,-1,147,109,97,-1,148,164,163,-1,164,148,62,-1,165,161,160,-1,161,165,162,-1,71,159,157,-1,71,111,159,-1,22,153,21,-1,22,141,153,-1,63,96,60,-1,97,96,63,-1,149,121,82,-1,121,149,120,-1,76,113,74,-1,113,76,105,-1,112,158,171,-1,10,158,112,-1,172,77,173,-1,172,75,77,-1,118,137,174,-1,118,54,137,-1,86,52,87,-1,86,59,52,-1,154,56,175,-1,154,143,56,-1,43,130,41,-1,43,32,130,-1,123,128,33,-1,65,128,123,-1,176,98,177,-1,176,132,98,-1,99,178,179,-1,99,100,178,-1,131,92,129,-1,131,93,92,-1,180,133,181,-1,180,95,133,-1,80,151,35,-1,126,151,80,-1,39,78,37,-1,78,39,182,-1,103,140,104,-1,103,42,140,-1,49,125,183,-1,49,184,125,-1,185,44,50,-1,186,44,185,-1,46,176,51,-1,176,46,30,-1,54,73,137,-1,54,53,73,-1,150,82,84,-1,82,150,149,-1,154,187,153,-1,154,90,187,-1,145,188,189,-1,188,145,144,-1,5,116,117,-1,7,116,5,-1,108,190,136,-1,108,107,190,-1,146,90,89,-1,90,146,187,-1,0,168,76,-1,168,0,3,-1,77,171,191,-1,74,171,77,-1,155,192,193,-1,155,173,192,-1,4,1,7,-1,4,2,1,-1,194,195,196,-1,195,194,197,-1,167,169,134,-1,167,198,169,-1,199,162,164,-1,199,200,162,-1,201,202,170,-1,202,201,203,-1,144,69,204,-1,69,144,68,-1,205,119,206,-1,119,205,85,-1,190,166,136,-1,190,207,166,-1,36,181,40,-1,181,36,180,-1,26,152,208,-1,26,25,152,-1,51,177,48,-1,177,51,176,-1,179,139,41,-1,179,178,139,-1,40,131,38,-1,181,131,40,-1,197,209,195,-1,197,210,209,-1,211,212,213,-1,211,127,212,-1,188,124,81,-1,214,124,188,-1,215,79,216,-1,189,79,215,-1,128,217,218,-1,217,128,110,-1,216,78,182,-1,79,78,216,-1,127,183,125,-1,127,211,183,-1,195,219,186,-1,209,219,195,-1,218,33,128,-1,218,31,33,-1,214,203,212,-1,214,204,203,-1,144,214,188,-1,144,204,214,-1,146,101,207,-1,101,146,64,-1,167,210,197,-1,167,166,210,-1,213,203,201,-1,212,203,213,-1,134,4,6,-1,134,169,4,-1,217,206,215,-1,217,205,206,-1,174,119,118,-1,138,119,174,-1,91,86,85,-1,175,86,91,-1,142,163,57,-1,148,163,142,-1,173,116,172,-1,173,155,116,-1,115,84,117,-1,115,150,84,-1,193,114,155,-1,114,193,200,-1,161,200,193,-1,162,200,161,-1,157,192,191,-1,159,192,157,-1,164,61,199,-1,61,164,62,-1,173,191,192,-1,173,77,191,-1,199,150,115,-1,150,199,61,-1,55,111,53,-1,55,160,111,-1,165,57,163,-1,165,58,57,-1,175,90,154,-1,90,175,91,-1,215,145,189,-1,215,206,145,-1,110,205,217,-1,110,88,205,-1,135,108,136,-1,135,156,108,-1,3,170,202,-1,3,2,170,-1,201,194,213,-1,201,198,194,-1,166,101,210,-1,166,207,101,-1,187,107,153,-1,187,190,107,-1,168,105,76,-1,106,105,168,-1,216,31,218,-1,182,31,216,-1,219,102,104,-1,209,102,219,-1,211,185,183,-1,211,196,185,-1,218,215,216,-1,215,218,217,-1,80,124,126,-1,124,80,81,-1,214,127,124,-1,214,212,127,-1,213,196,211,-1,196,213,194,-1,210,102,209,-1,102,210,101,-1,129,41,130,-1,129,179,41,-1,178,47,139,-1,178,27,47,-1,177,208,48,-1,177,26,208,-1,25,36,152,-1,36,25,180,-1,146,190,187,-1,146,207,190,-1,85,88,91,-1,85,205,88,-1,138,206,119,-1,138,145,206,-1,203,69,202,-1,203,204,69,-1,170,198,201,-1,170,169,198,-1,115,200,199,-1,115,114,200,-1,197,198,167,-1,197,194,198,-1,196,186,185,-1,186,196,195,-1,160,58,165,-1,55,58,160,-1,159,193,192,-1,193,159,161,-1,83,117,84,-1,5,117,83,-1,172,0,75,-1,0,172,1,-1,191,158,157,-1,158,191,171,-1,19,202,69,-1,19,18,202,-1,81,189,188,-1,81,79,189,-1,55,59,58,-1,59,55,52,-1,17,138,174,-1,17,70,138,-1,208,151,184,-1,151,208,152,-1,48,184,49,-1,208,184,48,-1,44,51,50,-1,44,46,51,-1,139,45,140,-1,47,45,139,-1,186,45,44,-1,219,45,186,-1,50,183,185,-1,50,49,183,-1,104,45,219,-1,104,140,45,-1,123,42,103,-1,123,43,42,-1,34,182,39,-1,182,34,31,-1,35,78,80,-1,35,37,78,-1,126,184,151,-1,125,184,126,-1,93,181,133,-1,181,93,131,-1,179,92,99,-1,129,92,179,-1,100,27,178,-1,100,28,27,-1,132,30,29,-1,30,132,176,-1,26,98,23,-1,177,98,26,-1,25,95,180,-1,25,24,95,-1,43,33,32,-1,123,33,43,-1,175,59,86,-1,175,56,59,-1,87,54,118,-1,87,52,54,-1,15,174,137,-1,174,15,17,-1,70,14,20,-1,70,17,14,-1,72,16,15,-1,16,72,9,-1,74,112,171,-1,112,74,113,-1,96,149,60,-1,120,149,96,-1,22,147,141,-1,109,147,22,-1,107,21,153,-1,21,107,13,-1,148,63,62,-1,148,147,63,-1,158,9,72,-1,10,9,158,-1,7,172,116,-1,7,1,172,-1,18,3,202,-1,3,18,168,-1,135,5,83,-1,6,5,135,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmphal5_Coord',point=[(-6.47578,24.87354,1.6276),(-6.47665,24.8689,1.68012),(-6.48857,24.89,1.68331),(-6.49736,24.89487,1.63162),(-6.47179,24.89708,1.73688),(-6.43096,24.88415,1.78257),(-6.44975,24.90384,1.78415),(-6.45778,24.87774,1.73654),(-6.45257,24.93501,1.58419),(-6.42075,24.95612,1.56432),(-6.41576,24.93414,1.56672),(-6.40649,24.96697,1.83209),(-6.3664,24.98529,1.83208),(-6.40278,24.99934,1.83401),(-6.46072,24.97725,1.58383),(-6.43306,25.00825,1.56486),(-6.44289,24.97735,1.56911),(-6.46156,25.00078,1.58279),(-6.51089,24.9292,1.61971),(-6.513,24.96214,1.60611),(-6.48281,24.94859,1.5951),(-6.37734,25.01472,1.83008),(-6.34001,25.01148,1.82869),(-6.91075,25.24414,1.71514),(-6.8834,25.28212,1.68478),(-6.9055,25.28684,1.61471),(-6.96873,25.23131,1.69195),(-6.83264,25.24552,1.90877),(-6.85223,25.25627,1.83428),(-6.87956,25.23553,1.82067),(-6.91039,25.21919,1.86415),(-6.75188,25.36961,1.72205),(-6.72715,25.39121,1.8242),(-6.71769,25.38178,1.822),(-6.76183,25.38249,1.72187),(-6.84409,25.33098,1.5683),(-6.8505,25.34088,1.57668),(-6.83577,25.33907,1.57415),(-6.77536,25.3868,1.72446),(-6.79084,25.37511,1.6488),(-6.79917,25.37692,1.658),(-6.73985,25.36839,1.86336),(-6.72504,25.36433,1.87598),(-6.72552,25.3698,1.86536),(-6.91679,25.19324,1.88406),(-6.81672,25.23222,1.93869),(-6.91795,25.20752,1.8782),(-6.82675,25.24265,1.93073),(-6.98358,25.20218,1.77186),(-6.98427,25.18653,1.77195),(-6.95587,25.18992,1.83317),(-6.9549,25.20399,1.82809),(-6.3869,25.03182,1.69005),(-6.40506,25.02987,1.62024),(-6.41368,25.03377,1.62451),(-6.37827,25.02495,1.68838),(-6.36106,25.05071,1.76604),(-6.35101,25.04799,1.7651),(-6.37156,25.03002,1.70664),(-6.38144,25.03608,1.70418),(-6.29507,24.94432,1.82729),(-6.29289,24.94093,1.81967),(-6.28855,24.9684,1.81669),(-6.29413,24.96983,1.82558),(-6.54685,25.10741,1.82558),(-6.63004,25.22333,1.82412),(-6.63134,25.20699,1.84206),(-6.54629,25.11706,1.80893),(-6.50615,25.00539,1.60243),(-6.52621,24.97123,1.61281),(-6.49241,25.00001,1.59841),(-6.3867,24.97744,1.55952),(-6.39597,24.97186,1.5538),(-6.42059,25.01376,1.56696),(-6.42133,24.88003,1.58651),(-6.46286,24.86789,1.62428),(-6.46359,24.87894,1.6104),(-6.41456,24.87656,1.60203),(-6.82198,25.32732,1.57701),(-6.70946,25.20406,1.60907),(-6.8349,25.31564,1.56791),(-6.72416,25.19165,1.60285),(-6.38965,24.89948,1.82503),(-6.40138,24.89508,1.81868),(-6.39024,24.89234,1.81735),(-6.44946,25.03822,1.70948),(-6.41242,25.03272,1.70934),(-6.41655,25.03063,1.69947),(-6.498,25.08425,1.78226),(-6.48984,25.08029,1.81188),(-6.41299,25.05395,1.8144),(-6.42835,25.04987,1.77186),(-6.79955,25.33456,1.77604),(-6.81137,25.34473,1.73985),(-6.85553,25.28056,1.75873),(-6.85359,25.30984,1.68376),(-6.33115,24.96497,1.82998),(-6.32863,24.97811,1.8298),(-6.91535,25.23195,1.75497),(-6.80026,25.3229,1.80872),(-6.82122,25.28726,1.83753),(-6.56476,25.07652,1.83817),(-6.65394,25.1623,1.87081),(-6.71534,25.35441,1.87379),(-6.7405,25.28952,1.92907),(-6.46291,24.90521,1.59819),(-6.47663,24.9219,1.60245),(-6.42816,25.00929,1.83518),(-6.44703,24.95068,1.82399),(-6.32737,24.99105,1.82713),(-6.54915,25.12184,1.79012),(-6.37806,24.97915,1.61805),(-6.41886,24.91372,1.57581),(-6.43276,24.89909,1.58517),(-6.38381,24.8956,1.72873),(-6.35757,24.89732,1.77079),(-6.44678,24.87273,1.73399),(-6.41918,24.88079,1.78051),(-6.43719,25.02673,1.6335),(-6.47304,25.02665,1.64677),(-6.35182,24.9501,1.82856),(-6.37845,24.94228,1.82886),(-6.39252,24.9547,1.83053),(-6.7159,25.3604,1.86236),(-6.76326,25.13748,1.62161),(-6.97298,25.1908,1.67033),(-6.9009,25.2624,1.57662),(-6.79624,25.0808,1.66741),(-6.63014,25.23702,1.80205),(-6.75969,25.37254,1.80591),(-6.7401,25.38982,1.81899),(-6.79219,25.37437,1.73109),(-6.90386,25.22768,1.79281),(-6.83018,25.3276,1.70407),(-6.48315,24.92681,1.78649),(-6.42922,24.91752,1.8211),(-6.46486,24.95149,1.81774),(-6.42948,25.01761,1.57046),(-6.49186,25.01072,1.60828),(-6.76533,25.30741,1.92353),(-6.75138,25.30094,1.93039),(-6.33292,25.045,1.82686),(-6.32603,25.04571,1.81801),(-6.33871,25.05266,1.81766),(-6.55878,25.03614,1.6195),(-6.55088,25.04934,1.62667),(-6.49054,25.0725,1.82146),(-6.29952,24.99507,1.8234),(-6.29611,24.99584,1.81564),(-6.33643,24.91497,1.82444),(-6.33598,24.90874,1.81719),(-6.91257,25.27704,1.57666),(-6.9126,25.28597,1.58613),(-6.36663,25.04661,1.82548),(-6.36767,25.04956,1.81709),(-6.3923,24.89126,1.70757),(-6.41803,24.92433,1.82865),(-6.37873,24.93578,1.56601),(-6.38686,24.93309,1.55876),(-6.37083,24.94391,1.62249),(-6.35825,24.98635,1.68621),(-6.35669,24.9564,1.68952),(-6.34588,24.95816,1.71504),(-6.31849,24.99456,1.7645),(-6.31345,24.96247,1.76325),(-6.34844,24.98564,1.71131),(-6.53239,24.99077,1.82215),(-6.55666,24.96021,1.7961),(-6.49117,24.90302,1.61932),(-6.50153,24.91885,1.7431),(-6.5179,24.91377,1.68838),(-6.39469,24.89906,1.57114),(-6.46655,24.86507,1.67852),(-6.40291,24.88293,1.65),(-6.45832,25.01119,1.58957),(-6.39138,25.04442,1.76866),(-6.94354,25.21491,1.81905),(-6.96683,25.21384,1.7677),(-6.77747,25.30286,1.90498),(-6.75178,25.36,1.85268),(-6.85086,25.33635,1.6054),(-6.8094,25.36538,1.67093),(-6.78024,25.36072,1.64867),(-6.96365,25.16739,1.76646),(-6.9889,25.20785,1.67538),(-6.93548,25.1675,1.82832),(-6.89999,25.17477,1.87853),(-6.41505,25.04705,1.823),(-6.61748,25.08399,1.62082),(-6.60798,25.09916,1.62804),(-6.44477,25.01551,1.83217),(-6.38728,24.89923,1.58104),(-6.37626,24.90931,1.62873),(-6.36349,24.92566,1.69444),(-6.65184,24.98512,1.76486),(-6.75654,25.07241,1.83211),(-6.78259,25.06153,1.78551),(-6.63365,24.99747,1.80879),(-6.57312,24.95114,1.75583),(-6.31987,24.93148,1.7671),(-6.35082,24.9302,1.72257),(-6.59085,24.94832,1.70056),(-6.53118,24.92557,1.63748),(-6.59706,24.96336,1.6479),(-6.58151,25.00099,1.62601),(-6.51656,25.07483,1.71829),(-6.5388,25.06516,1.6531),(-6.50427,25.0399,1.82959),(-6.9879,25.22144,1.68289),(-6.70414,25.1101,1.86962),(-6.59606,25.03007,1.83782),(-6.79712,25.06096,1.73159),(-6.67018,25.00052,1.65869),(-6.66657,24.98372,1.71123),(-6.64619,25.0391,1.62802),(-6.59178,25.11177,1.65284),(-6.68637,25.22576,1.65207),(-6.57285,25.11763,1.722),(-6.65813,25.2321,1.72805),(-6.80436,25.21344,1.93452)]))),
        Shape(DEF='rdphal',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rdphal_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,13,16,14,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,23,26,24,-1,27,21,28,-1,29,30,31,-1,29,32,30,-1,33,21,34,-1,35,21,36,-1,37,38,39,-1,37,40,38,-1,41,2,42,-1,41,43,2,-1,44,45,46,-1,44,47,45,-1,48,49,50,-1,48,51,49,-1,2,7,52,-1,2,8,7,-1,53,54,55,-1,55,56,53,-1,52,0,2,-1,57,58,59,-1,60,61,62,-1,61,63,62,-1,64,65,66,-1,67,68,69,-1,68,70,69,-1,71,72,73,-1,71,74,72,-1,75,76,68,-1,76,70,68,-1,74,71,77,-1,78,79,80,-1,78,81,79,-1,82,83,65,-1,82,84,83,-1,66,65,85,-1,37,65,86,-1,87,50,44,-1,44,88,87,-1,89,21,90,-1,91,21,35,-1,92,56,55,-1,92,8,56,-1,93,94,95,-1,93,96,94,-1,97,24,98,-1,24,26,98,-1,99,21,100,-1,28,21,33,-1,101,102,83,-1,101,103,102,-1,34,21,104,-1,100,21,20,-1,14,16,25,-1,16,23,25,-1,105,6,106,-1,106,107,105,-1,81,57,79,-1,57,59,79,-1,108,109,110,-1,111,112,95,-1,112,93,95,-1,113,114,115,-1,115,116,113,-1,36,21,27,-1,5,52,117,-1,5,0,52,-1,82,65,39,-1,86,65,64,-1,118,119,120,-1,118,121,119,-1,122,123,124,-1,124,125,122,-1,126,127,128,-1,128,129,126,-1,130,80,131,-1,80,79,131,-1,52,132,117,-1,52,7,132,-1,133,134,68,-1,37,39,65,-1,135,58,57,-1,135,136,58,-1,130,96,80,-1,130,108,96,-1,78,112,137,-1,78,93,112,-1,71,138,77,-1,103,101,122,-1,122,42,103,-1,106,6,8,-1,8,92,106,-1,139,53,56,-1,56,43,139,-1,22,21,89,-1,104,21,99,-1,66,140,64,-1,140,141,64,-1,123,47,49,-1,49,124,123,-1,90,21,91,-1,94,142,95,-1,23,16,143,-1,143,144,23,-1,145,146,147,-1,145,148,146,-1,119,139,29,-1,139,32,29,-1,149,128,150,-1,151,127,152,-1,153,154,155,-1,111,133,156,-1,12,9,88,-1,76,157,158,-1,159,45,47,-1,160,3,5,-1,160,140,3,-1,45,157,76,-1,45,159,157,-1,70,40,69,-1,70,38,40,-1,161,162,77,-1,161,141,162,-1,132,136,63,-1,136,132,105,-1,163,62,135,-1,62,163,72,-1,112,73,137,-1,73,112,164,-1,164,111,156,-1,164,112,111,-1,19,154,153,-1,154,19,18,-1,165,166,167,-1,168,166,165,-1,169,170,171,-1,172,170,169,-1,173,174,175,-1,176,174,173,-1,177,178,143,-1,179,178,177,-1,180,181,182,-1,180,183,181,-1,22,184,185,-1,89,184,22,-1,90,186,187,-1,91,186,90,-1,188,36,189,-1,36,188,35,-1,190,28,191,-1,28,190,27,-1,33,192,193,-1,34,192,33,-1,104,194,195,-1,99,194,104,-1,176,196,153,-1,196,176,197,-1,185,165,19,-1,184,165,185,-1,187,169,168,-1,186,169,187,-1,172,189,183,-1,189,172,188,-1,181,191,15,-1,191,181,190,-1,193,177,13,-1,192,177,193,-1,195,173,179,-1,194,173,195,-1,149,198,128,-1,199,198,149,-1,200,201,144,-1,200,202,201,-1,152,203,204,-1,152,127,203,-1,127,150,128,-1,150,127,151,-1,205,206,207,-1,208,206,205,-1,209,210,211,-1,210,209,212,-1,213,120,214,-1,213,118,120,-1,18,199,149,-1,18,17,199,-1,215,148,216,-1,215,217,148,-1,218,51,48,-1,219,51,218,-1,220,126,221,-1,126,220,222,-1,223,219,224,-1,223,51,219,-1,53,119,121,-1,53,139,119,-1,98,54,97,-1,98,145,54,-1,225,110,109,-1,225,226,110,-1,227,228,229,-1,227,131,228,-1,230,146,231,-1,147,146,230,-1,201,98,26,-1,98,201,216,-1,226,94,110,-1,226,142,94,-1,210,180,214,-1,210,170,180,-1,124,51,223,-1,124,49,51,-1,232,47,123,-1,232,159,47,-1,158,84,82,-1,158,157,84,-1,86,141,161,-1,64,141,86,-1,140,85,3,-1,85,140,66,-1,4,103,1,-1,103,4,102,-1,119,211,120,-1,29,211,119,-1,175,200,178,-1,200,175,204,-1,205,17,167,-1,199,17,205,-1,41,30,32,-1,41,125,30,-1,50,233,48,-1,50,87,233,-1,221,116,220,-1,116,221,113,-1,146,217,234,-1,146,148,217,-1,106,230,229,-1,230,106,92,-1,235,115,109,-1,115,235,236,-1,9,114,88,-1,9,225,114,-1,101,123,122,-1,123,101,232,-1,164,71,73,-1,164,138,71,-1,78,96,93,-1,80,96,78,-1,109,130,235,-1,109,108,130,-1,95,237,111,-1,95,142,237,-1,68,10,75,-1,68,134,10,-1,117,63,61,-1,117,132,63,-1,5,61,160,-1,117,61,5,-1,228,58,107,-1,228,59,58,-1,96,110,94,-1,96,108,110,-1,14,213,182,-1,213,14,25,-1,43,8,2,-1,43,56,8,-1,235,131,227,-1,131,235,130,-1,29,209,211,-1,31,209,29,-1,212,170,210,-1,212,171,170,-1,42,125,41,-1,42,122,125,-1,46,76,75,-1,46,45,76,-1,182,214,180,-1,182,213,214,-1,92,147,230,-1,92,55,147,-1,226,9,11,-1,226,225,9,-1,229,107,106,-1,107,229,228,-1,135,81,163,-1,135,57,81,-1,222,127,126,-1,222,203,127,-1,178,144,143,-1,178,200,144,-1,155,152,174,-1,155,151,152,-1,67,77,138,-1,77,67,69,-1,162,74,77,-1,162,60,74,-1,204,174,152,-1,175,174,204,-1,202,216,201,-1,202,215,216,-1,87,114,113,-1,88,114,87,-1,149,154,18,-1,150,154,149,-1,196,22,185,-1,196,20,22,-1,218,128,198,-1,129,128,218,-1,83,85,65,-1,102,85,83,-1,166,212,208,-1,166,171,212,-1,31,206,209,-1,224,206,31,-1,163,78,137,-1,81,78,163,-1,231,234,236,-1,146,234,231,-1,232,83,84,-1,232,101,83,-1,97,118,24,-1,121,118,97,-1,142,11,237,-1,142,226,11,-1,136,107,58,-1,107,136,105,-1,60,72,74,-1,60,62,72,-1,156,138,164,-1,67,138,156,-1,12,75,10,-1,75,12,46,-1,60,160,61,-1,162,160,60,-1,236,116,115,-1,234,116,236,-1,46,88,44,-1,46,12,88,-1,114,109,115,-1,114,225,109,-1,227,236,235,-1,236,227,231,-1,55,145,147,-1,55,54,145,-1,220,234,217,-1,234,220,116,-1,87,221,233,-1,113,221,87,-1,125,223,30,-1,124,223,125,-1,198,219,218,-1,198,207,219,-1,47,50,49,-1,50,47,44,-1,222,202,203,-1,215,202,222,-1,43,32,139,-1,32,43,41,-1,42,1,103,-1,42,2,1,-1,102,3,85,-1,102,4,3,-1,40,86,161,-1,86,40,37,-1,82,38,158,-1,39,38,82,-1,159,84,157,-1,84,159,232,-1,224,207,206,-1,224,219,207,-1,167,208,205,-1,208,167,166,-1,229,231,227,-1,230,231,229,-1,131,59,228,-1,131,79,59,-1,216,145,98,-1,216,148,145,-1,54,121,97,-1,54,53,121,-1,30,224,31,-1,30,223,224,-1,233,126,129,-1,233,221,126,-1,222,217,215,-1,222,220,217,-1,129,48,233,-1,218,48,129,-1,67,133,68,-1,67,156,133,-1,151,154,150,-1,151,155,154,-1,25,118,213,-1,25,24,118,-1,211,214,120,-1,214,211,210,-1,208,209,206,-1,212,209,208,-1,204,202,200,-1,204,203,202,-1,26,144,201,-1,144,26,23,-1,207,199,205,-1,207,198,199,-1,194,176,173,-1,197,176,194,-1,192,179,177,-1,195,179,192,-1,15,193,13,-1,193,15,191,-1,183,190,181,-1,190,183,189,-1,186,172,169,-1,188,172,186,-1,184,168,165,-1,187,168,184,-1,153,185,19,-1,185,153,196,-1,194,100,197,-1,100,194,99,-1,34,195,192,-1,104,195,34,-1,191,33,193,-1,33,191,28,-1,189,27,190,-1,27,189,36,-1,91,188,186,-1,35,188,91,-1,89,187,184,-1,90,187,89,-1,197,20,196,-1,197,100,20,-1,172,180,170,-1,183,180,172,-1,182,15,14,-1,182,181,15,-1,13,143,16,-1,177,143,13,-1,179,175,178,-1,173,175,179,-1,153,174,176,-1,153,155,174,-1,171,168,169,-1,171,166,168,-1,19,167,17,-1,19,165,167,-1,237,10,134,-1,11,10,237,-1,237,133,111,-1,133,237,134,-1,137,72,163,-1,72,137,73,-1,63,135,62,-1,63,136,135,-1,6,132,7,-1,105,132,6,-1,69,161,77,-1,69,40,161,-1,158,70,76,-1,158,38,70,-1,141,160,162,-1,141,140,160,-1,5,1,0,-1,1,5,4,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rdphal_Coord',point=[(-5.37099,26.13455,4.10855),(-5.35406,26.13383,4.10767),(-5.39241,26.19865,4.08256),(-5.34373,26.0603,4.14119),(-5.34596,26.07262,4.13868),(-5.36251,26.06957,4.13942),(-5.402,26.12135,4.07614),(-5.39528,26.12722,4.09424),(-5.43162,26.18574,4.06559),(-5.29256,26.10166,4.01414),(-5.25244,26.04345,4.04703),(-5.26435,26.03767,4.02882),(-5.27952,26.10938,4.02672),(-5.61239,26.39778,3.93651),(-5.60642,26.40618,3.98147),(-5.60069,26.41178,3.97386),(-5.61705,26.39048,3.93839),(-5.27357,26.46238,3.84853),(-5.27459,26.46122,3.84637),(-5.28198,26.46843,3.84767),(-5.40632,26.44608,3.85145),(-5.44985,26.44757,3.87836),(-5.38625,26.45642,3.8614),(-5.61392,26.35862,3.95035),(-5.61026,26.33998,4.0119),(-5.61051,26.37642,3.99742),(-5.58983,26.32721,3.95764),(-5.48975,26.44127,3.91953),(-5.50668,26.43216,3.9159),(-5.42262,26.37642,4.0208),(-5.33683,26.34975,4.01892),(-5.34214,26.38704,3.99995),(-5.4075,26.341,4.02987),(-5.5122,26.42656,3.90326),(-5.505,26.43116,3.88474),(-5.44276,26.4582,3.90439),(-5.468,26.45085,3.91714),(-5.285,25.97407,4.12258),(-5.27023,25.98066,4.11045),(-5.28017,25.99414,4.12069),(-5.2822,25.94809,4.11013),(-5.38755,26.26955,4.05051),(-5.36184,26.20264,4.07518),(-5.43639,26.26004,4.05535),(-5.28425,26.17329,4.01757),(-5.27755,26.11667,4.0505),(-5.27211,26.11443,4.03805),(-5.28641,26.18337,4.03394),(-5.25798,26.30673,3.97349),(-5.27341,26.25997,4.02244),(-5.27518,26.24259,4.00608),(-5.25962,26.33089,3.98712),(-5.38774,26.13321,4.1071),(-5.52898,26.29976,4.03021),(-5.55155,26.27767,4.0029),(-5.49706,26.22547,4.01098),(-5.4794,26.24105,4.03931),(-5.38487,25.96489,4.04476),(-5.39433,25.98669,4.06183),(-5.38559,25.98831,4.04395),(-5.35952,25.94524,4.11607),(-5.37376,25.98425,4.14004),(-5.37881,25.9475,4.10012),(-5.38727,25.9862,4.12003),(-5.31185,25.97892,4.13568),(-5.29867,26.00938,4.13466),(-5.31918,25.9988,4.14335),(-5.26706,25.92916,4.07505),(-5.24134,25.97039,4.07569),(-5.27456,25.93899,4.09715),(-5.25929,25.97704,4.09775),(-5.32569,25.90313,4.07851),(-5.36346,25.91776,4.06781),(-5.33961,25.90054,4.05203),(-5.34178,25.91707,4.08495),(-5.25089,26.05383,4.06633),(-5.2609,26.05902,4.08629),(-5.31221,25.9202,4.10226),(-5.35016,25.93792,4.01693),(-5.3688,25.98785,4.0331),(-5.35575,25.98712,4.01654),(-5.37273,25.94557,4.03108),(-5.28264,26.03658,4.11701),(-5.30692,26.08101,4.11924),(-5.28602,26.07027,4.10487),(-5.32486,26.0402,4.13974),(-5.30091,25.96459,4.12427),(-5.29518,26.22347,3.98722),(-5.29434,26.16307,4.00307),(-5.38952,26.46299,3.87199),(-5.40397,26.46373,3.88151),(-5.41844,26.46408,3.89124),(-5.44738,26.17354,4.03149),(-5.31991,25.93517,4.01683),(-5.30627,25.9851,4.01533),(-5.29792,25.9564,4.00941),(-5.33387,25.98714,4.01543),(-5.58773,26.30492,4.00901),(-5.56592,26.29752,3.96663),(-5.46005,26.44255,3.85022),(-5.4346,26.44715,3.84656),(-5.31314,26.12288,4.09183),(-5.33067,26.07676,4.1317),(-5.33686,26.131,4.10439),(-5.48517,26.43515,3.86591),(-5.40943,26.05699,4.0989),(-5.40992,26.11391,4.04571),(-5.4052,26.05026,4.05401),(-5.34048,26.04023,4.00678),(-5.34543,26.09479,4.00199),(-5.32361,26.03911,4.0063),(-5.27166,25.93358,4.03062),(-5.31379,25.90889,4.02339),(-5.35118,26.21547,3.95497),(-5.33077,26.15357,3.98053),(-5.37512,26.16204,3.97758),(-5.41258,26.22353,3.94118),(-5.3839,26.06737,4.13312),(-5.57411,26.35885,4.03517),(-5.49912,26.35455,4.04354),(-5.51402,26.37993,4.03711),(-5.55718,26.32752,4.03695),(-5.32912,26.2051,4.06168),(-5.30479,26.1945,4.04856),(-5.30025,26.27029,4.03231),(-5.33497,26.27944,4.04033),(-5.36723,26.31479,3.85836),(-5.3768,26.35761,3.81255),(-5.25904,26.34377,3.87165),(-5.25627,26.31491,3.92115),(-5.3597,26.0415,4.01477),(-5.37756,26.04449,4.02513),(-5.40214,26.06049,4.12041),(-5.25618,25.94117,4.04998),(-5.24432,25.97388,4.05432),(-5.38901,25.95634,4.08275),(-5.39415,25.98975,4.09835),(-5.34663,25.90978,4.03465),(-5.30847,25.90627,4.06746),(-5.4786,26.32864,4.04066),(-5.33383,25.99178,4.14689),(-5.32114,25.95746,4.12943),(-5.28442,25.98354,4.0153),(-5.59665,26.40206,3.88395),(-5.57581,26.36846,3.89495),(-5.53576,26.27239,3.97602),(-5.46259,26.21963,3.97485),(-5.48539,26.22075,3.99255),(-5.51108,26.26998,3.94849),(-5.26755,26.40572,3.85273),(-5.29552,26.3943,3.83358),(-5.35066,26.40118,3.80811),(-5.39311,26.40627,3.79885),(-5.331,26.44357,3.8125),(-5.32384,26.43773,3.81046),(-5.33075,26.43699,3.80759),(-5.26465,25.92736,4.04871),(-5.27189,26.06412,4.09769),(-5.27118,26.05309,4.10198),(-5.28528,26.1188,4.06288),(-5.34983,25.98721,4.14637),(-5.30496,25.93786,4.1143),(-5.33648,25.95047,4.12637),(-5.37307,25.92627,4.05145),(-5.31031,25.89965,4.03796),(-5.28924,26.48645,3.87273),(-5.31769,26.4906,3.89841),(-5.28169,26.48339,3.87792),(-5.32287,26.49261,3.89141),(-5.36133,26.49653,3.916),(-5.42536,26.47876,3.95982),(-5.35592,26.49473,3.92345),(-5.42882,26.48101,3.95183),(-5.47916,26.43618,3.79904),(-5.40988,26.44392,3.79011),(-5.47907,26.43093,3.79548),(-5.41166,26.44946,3.79424),(-5.59446,26.40725,3.88565),(-5.54592,26.41045,3.83418),(-5.54555,26.41571,3.83758),(-5.50181,26.45558,3.99693),(-5.5601,26.43378,3.9906),(-5.5641,26.42912,3.99972),(-5.50106,26.45907,3.98768),(-5.33252,26.47593,3.87036),(-5.3265,26.46191,3.84987),(-5.3869,26.48106,3.90523),(-5.35914,26.47935,3.88684),(-5.43507,26.46956,3.93081),(-5.48578,26.45428,3.95627),(-5.52907,26.43531,3.96033),(-5.56063,26.41827,3.95123),(-5.55529,26.41645,3.88721),(-5.56964,26.40794,3.92484),(-5.47055,26.43759,3.8218),(-5.51842,26.4232,3.85083),(-5.3649,26.4434,3.82734),(-5.42113,26.4469,3.81637),(-5.23869,26.36273,3.90913),(-5.2581,26.41524,3.87082),(-5.5266,26.38026,3.84452),(-5.54676,26.32495,3.89954),(-5.50143,26.34075,3.8537),(-5.4463,26.35059,3.8218),(-5.46459,26.39543,3.80715),(-5.26373,26.43482,3.89764),(-5.2919,26.40932,3.94961),(-5.24216,26.37941,3.93318),(-5.30583,26.45428,3.91876),(-5.34832,26.42274,3.97737),(-5.42992,26.44798,3.98072),(-5.43383,26.40918,4.00521),(-5.35228,26.46335,3.94718),(-5.57097,26.39711,4.01789),(-5.50867,26.42151,4.01628),(-5.49329,26.30682,3.88844),(-5.53247,26.29541,3.92482),(-5.4823,26.27499,3.92244),(-5.24053,26.33245,3.94305),(-5.24581,26.35421,3.96191),(-5.44523,26.27681,3.90264),(-5.35864,26.28004,3.91422),(-5.4472,26.31504,3.85769),(-5.29419,26.34145,4.00343),(-5.28972,26.37593,3.97821),(-5.31253,26.09088,3.9998),(-5.29476,26.03649,4.00544),(-5.38249,26.10216,4.01994),(-5.39557,26.04644,4.03616),(-5.40068,26.10675,4.03057),(-5.437,26.16789,4.01704),(-5.41659,26.1657,4.0039),(-5.29516,26.12078,4.07512),(-5.27974,26.28411,3.95548),(-5.4359,26.22148,3.95738),(-5.36319,26.09836,4.0106),(-5.39395,26.16401,3.99009),(-5.25571,25.97765,4.03636)]))),
        Shape(DEF='rdphal2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rdphal2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,20,22,21,-1,23,17,24,-1,25,17,26,-1,27,17,28,-1,29,30,31,-1,30,32,31,-1,33,34,35,-1,33,36,34,-1,37,7,0,-1,7,6,0,-1,38,39,40,-1,40,41,38,-1,42,43,44,-1,42,45,43,-1,0,2,37,-1,46,47,48,-1,49,50,51,-1,49,52,50,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,61,63,62,-1,50,64,65,-1,50,52,64,-1,57,66,67,-1,57,59,66,-1,68,62,63,-1,69,70,71,-1,70,72,71,-1,73,74,75,-1,75,54,73,-1,76,54,53,-1,77,54,31,-1,78,17,79,-1,28,17,80,-1,81,82,83,-1,82,84,83,-1,72,48,85,-1,48,86,85,-1,87,17,88,-1,26,17,23,-1,73,89,90,-1,73,91,89,-1,92,17,25,-1,18,17,87,-1,93,8,94,-1,94,95,93,-1,46,48,72,-1,72,70,46,-1,96,43,97,-1,81,98,99,-1,81,83,98,-1,24,17,27,-1,29,54,75,-1,55,54,77,-1,100,101,102,-1,101,103,102,-1,104,105,106,-1,106,107,104,-1,108,70,109,-1,70,69,109,-1,64,7,37,-1,37,65,64,-1,57,110,111,-1,54,29,31,-1,48,47,86,-1,47,112,86,-1,84,97,109,-1,109,69,84,-1,113,98,71,-1,98,83,71,-1,68,114,62,-1,115,90,116,-1,90,89,116,-1,43,117,118,-1,118,44,43,-1,119,45,42,-1,42,120,119,-1,121,122,123,-1,123,124,121,-1,79,17,16,-1,88,17,92,-1,125,126,127,-1,127,128,125,-1,55,129,53,-1,55,130,129,-1,131,132,74,-1,131,133,132,-1,80,17,78,-1,81,134,82,-1,135,136,21,-1,135,137,136,-1,138,104,139,-1,140,105,141,-1,21,142,135,-1,21,22,142,-1,143,144,145,-1,146,111,99,-1,147,11,10,-1,148,132,66,-1,34,36,133,-1,3,129,149,-1,3,5,129,-1,66,133,36,-1,66,132,133,-1,56,30,59,-1,56,32,30,-1,150,151,68,-1,150,130,151,-1,112,64,52,-1,94,64,112,-1,61,86,49,-1,61,85,86,-1,113,152,98,-1,152,113,60,-1,99,152,146,-1,99,98,152,-1,13,144,14,-1,13,145,144,-1,153,154,155,-1,154,153,156,-1,157,158,159,-1,158,157,160,-1,161,162,163,-1,162,161,164,-1,165,166,137,-1,166,165,167,-1,136,168,169,-1,168,136,170,-1,171,172,173,-1,171,174,172,-1,79,175,176,-1,16,175,79,-1,177,78,178,-1,78,177,80,-1,179,28,180,-1,28,179,27,-1,23,181,182,-1,24,181,23,-1,25,183,184,-1,26,183,25,-1,185,92,186,-1,92,185,88,-1,187,164,145,-1,188,164,187,-1,176,13,154,-1,175,13,176,-1,158,178,156,-1,178,158,177,-1,172,180,160,-1,180,172,179,-1,182,174,168,-1,181,174,182,-1,184,170,166,-1,183,170,184,-1,162,186,167,-1,186,162,185,-1,189,104,190,-1,139,104,189,-1,135,127,191,-1,135,142,127,-1,192,105,140,-1,192,126,105,-1,138,105,104,-1,141,105,138,-1,193,194,195,-1,193,196,194,-1,197,198,199,-1,197,200,198,-1,201,102,202,-1,201,100,102,-1,15,139,189,-1,15,14,139,-1,203,123,128,-1,203,204,123,-1,205,206,207,-1,206,205,208,-1,106,122,209,-1,125,122,106,-1,210,205,211,-1,208,205,210,-1,38,212,213,-1,38,41,212,-1,101,214,103,-1,101,215,214,-1,216,217,218,-1,216,219,217,-1,43,220,117,-1,96,220,43,-1,108,221,222,-1,108,119,221,-1,223,120,224,-1,225,120,223,-1,22,203,142,-1,203,22,218,-1,96,134,220,-1,82,134,96,-1,198,173,157,-1,201,173,198,-1,211,226,227,-1,211,205,226,-1,228,133,131,-1,228,34,133,-1,74,148,75,-1,74,132,148,-1,55,151,130,-1,77,151,55,-1,5,53,129,-1,53,5,76,-1,1,91,4,-1,91,1,89,-1,116,229,40,-1,116,0,229,-1,212,100,200,-1,101,100,212,-1,165,192,163,-1,192,165,191,-1,207,226,205,-1,230,226,207,-1,189,155,15,-1,195,155,189,-1,231,230,207,-1,231,232,230,-1,121,209,122,-1,233,209,121,-1,204,124,123,-1,124,204,224,-1,214,234,219,-1,234,214,235,-1,221,236,93,-1,236,221,225,-1,117,147,118,-1,117,11,147,-1,115,131,90,-1,131,115,228,-1,62,152,60,-1,62,114,152,-1,83,69,71,-1,83,84,69,-1,45,97,43,-1,109,97,45,-1,134,99,237,-1,99,134,81,-1,67,110,57,-1,67,12,110,-1,65,149,50,-1,3,149,65,-1,46,95,47,-1,95,46,222,-1,82,97,84,-1,96,97,82,-1,19,171,202,-1,19,169,171,-1,6,229,0,-1,6,235,229,-1,109,119,108,-1,109,45,119,-1,213,200,197,-1,212,200,213,-1,199,157,159,-1,198,157,199,-1,115,40,39,-1,40,115,116,-1,67,36,33,-1,67,66,36,-1,230,147,35,-1,230,232,147,-1,173,202,171,-1,201,202,173,-1,234,225,223,-1,234,236,225,-1,236,235,6,-1,234,235,236,-1,11,220,9,-1,11,117,220,-1,222,93,95,-1,222,221,93,-1,105,125,106,-1,105,126,125,-1,20,218,22,-1,218,20,216,-1,137,191,165,-1,135,191,137,-1,161,141,143,-1,161,140,141,-1,68,58,114,-1,56,58,68,-1,51,68,63,-1,51,150,68,-1,192,161,163,-1,192,140,161,-1,21,169,19,-1,21,136,169,-1,142,128,127,-1,142,203,128,-1,118,232,233,-1,232,118,147,-1,44,233,121,-1,44,118,233,-1,138,14,144,-1,139,14,138,-1,16,187,175,-1,16,18,187,-1,107,190,104,-1,206,190,107,-1,37,3,65,-1,37,2,3,-1,54,91,73,-1,54,76,91,-1,159,194,199,-1,194,159,153,-1,210,197,196,-1,213,197,210,-1,39,228,115,-1,227,228,39,-1,72,113,71,-1,85,113,72,-1,224,42,124,-1,120,42,224,-1,74,90,131,-1,74,73,90,-1,102,216,20,-1,216,102,103,-1,134,9,220,-1,9,134,237,-1,94,47,95,-1,94,112,47,-1,49,63,61,-1,63,49,51,-1,114,146,152,-1,146,114,58,-1,33,12,67,-1,33,10,12,-1,150,50,149,-1,51,50,150,-1,124,44,121,-1,42,44,124,-1,10,35,147,-1,10,33,35,-1,6,93,236,-1,6,8,93,-1,219,223,217,-1,219,234,223,-1,233,231,209,-1,232,231,233,-1,227,38,211,-1,39,38,227,-1,229,214,215,-1,235,214,229,-1,206,193,190,-1,208,193,206,-1,226,35,34,-1,35,226,230,-1,40,215,41,-1,40,229,215,-1,89,0,116,-1,89,1,0,-1,76,4,91,-1,76,5,4,-1,77,32,151,-1,31,32,77,-1,30,75,148,-1,75,30,29,-1,227,34,228,-1,227,226,34,-1,196,208,210,-1,196,193,208,-1,195,153,155,-1,153,195,194,-1,217,224,204,-1,223,224,217,-1,225,119,120,-1,221,119,225,-1,70,222,46,-1,70,108,222,-1,218,204,203,-1,218,217,204,-1,103,219,216,-1,103,214,219,-1,41,101,212,-1,41,215,101,-1,211,213,210,-1,211,38,213,-1,209,107,106,-1,209,231,107,-1,128,122,125,-1,128,123,122,-1,207,107,231,-1,107,207,206,-1,111,58,57,-1,111,146,58,-1,144,141,138,-1,144,143,141,-1,20,202,102,-1,202,20,19,-1,201,200,100,-1,198,200,201,-1,199,196,197,-1,194,196,199,-1,191,126,192,-1,191,127,126,-1,190,195,189,-1,190,193,195,-1,164,185,162,-1,185,164,188,-1,167,184,166,-1,184,167,186,-1,183,168,170,-1,182,168,183,-1,181,172,174,-1,179,172,181,-1,160,177,158,-1,177,160,180,-1,156,176,154,-1,176,156,178,-1,175,145,13,-1,187,145,175,-1,188,88,185,-1,88,188,87,-1,186,25,184,-1,25,186,92,-1,26,182,183,-1,23,182,26,-1,24,179,181,-1,27,179,24,-1,180,80,177,-1,80,180,28,-1,178,79,176,-1,79,178,78,-1,18,188,187,-1,18,87,188,-1,173,160,157,-1,160,173,172,-1,169,174,171,-1,169,168,174,-1,137,170,136,-1,170,137,166,-1,163,167,165,-1,167,163,162,-1,164,143,145,-1,164,161,143,-1,156,159,158,-1,156,153,159,-1,154,15,155,-1,154,13,15,-1,12,237,110,-1,237,12,9,-1,111,237,99,-1,110,237,111,-1,85,60,113,-1,60,85,61,-1,49,112,52,-1,49,86,112,-1,94,7,64,-1,8,7,94,-1,151,56,68,-1,151,32,56,-1,59,148,66,-1,59,30,148,-1,149,130,150,-1,149,129,130,-1,2,4,3,-1,4,2,1,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rdphal2_Coord',point=[(-5.71536,24.9026,4.14408),(-5.67583,24.88197,4.11195),(-5.67034,24.89329,4.11863),(-5.62009,24.8821,4.09817),(-5.628,24.86974,4.09234),(-5.62075,24.86939,4.08633),(-5.70766,24.94211,4.1403),(-5.66719,24.9221,4.11612),(-5.67272,24.94055,4.10612),(-5.70567,24.89174,3.9789),(-5.73374,24.88978,4.03371),(-5.73341,24.90927,4.02693),(-5.70175,24.8695,3.98692),(-5.98934,24.91428,4.12423),(-5.98957,24.91185,4.11722),(-5.98911,24.9094,4.11869),(-5.9451,24.98252,4.15963),(-5.9238,25.01928,4.18047),(-5.94409,25.00646,4.15362),(-5.80495,25.06136,4.25315),(-5.78009,25.04894,4.24242),(-5.82066,25.10759,4.21926),(-5.81115,25.08069,4.196),(-5.89109,25.03689,4.20682),(-5.89459,25.01946,4.20942),(-5.90752,25.06042,4.19042),(-5.89486,25.05223,4.19867),(-5.90186,25.0033,4.20802),(-5.91433,24.99283,4.19883),(-5.62208,24.85186,4.01082),(-5.62514,24.85446,3.9931),(-5.60808,24.85918,4.00458),(-5.60317,24.8716,3.98258),(-5.73199,24.87548,4.0397),(-5.76595,24.87466,4.07813),(-5.77127,24.88582,4.06354),(-5.72384,24.87047,4.04961),(-5.66514,24.90657,4.12313),(-5.83089,24.87111,4.17689),(-5.794,24.87942,4.14675),(-5.77232,24.89487,4.16447),(-5.80886,24.89675,4.19751),(-5.75239,24.9791,4.07513),(-5.721,24.95649,4.03395),(-5.76426,24.97658,4.06138),(-5.7119,24.96261,4.04693),(-5.62582,24.98298,4.01659),(-5.61023,24.97814,4.03079),(-5.61267,24.98777,4.00565),(-5.57073,24.95105,4.02657),(-5.56754,24.91186,4.06544),(-5.56712,24.92658,4.02485),(-5.57597,24.93467,4.06134),(-5.59499,24.86504,4.0463),(-5.61437,24.85271,4.03573),(-5.59185,24.86955,4.02848),(-5.60956,24.87659,3.96628),(-5.65304,24.85812,3.95245),(-5.62126,24.88786,3.94429),(-5.63553,24.85548,3.97817),(-5.59167,24.96457,3.95378),(-5.58137,24.96798,3.98436),(-5.58188,24.93602,3.96349),(-5.57882,24.94054,3.98282),(-5.6124,24.9262,4.10097),(-5.61507,24.90253,4.10297),(-5.682,24.84619,4.02222),(-5.6953,24.85331,4.0037),(-5.58135,24.90611,3.97923),(-5.65412,24.97896,3.98482),(-5.63901,24.97762,4.00142),(-5.62949,24.98658,3.95779),(-5.61566,24.99241,3.98179),(-5.65703,24.85265,4.0717),(-5.66724,24.84969,4.04995),(-5.64537,24.84617,4.03304),(-5.61782,24.86132,4.06672),(-5.59562,24.87236,4.00904),(-5.9339,24.97981,4.17947),(-5.94113,24.97611,4.17003),(-5.92677,24.98346,4.18878),(-5.66487,24.94774,3.93566),(-5.67323,24.94312,3.95793),(-5.64015,24.96455,3.94057),(-5.66344,24.96326,3.97302),(-5.59239,24.98392,3.98408),(-5.58244,24.96798,4.02597),(-5.94459,25.03067,4.15968),(-5.93759,25.0484,4.16653),(-5.68161,24.87265,4.10309),(-5.69187,24.86635,4.08507),(-5.63956,24.86236,4.08474),(-5.92222,25.05815,4.17746),(-5.6845,24.96848,4.08912),(-5.6211,24.94675,4.09051),(-5.64646,24.97526,4.06064),(-5.69846,24.95016,3.99422),(-5.69282,24.96189,4.00218),(-5.62446,24.96197,3.92775),(-5.64981,24.91951,3.92276),(-5.80685,24.94752,4.24805),(-5.79477,24.93318,4.23537),(-5.78721,24.99564,4.25282),(-5.77517,24.9809,4.23394),(-5.92966,24.92913,4.06696),(-5.94017,25.03493,4.07545),(-5.89845,25.0085,4.07494),(-5.89146,24.91402,4.07515),(-5.6708,24.97572,4.03012),(-5.68183,24.97032,4.01535),(-5.66719,24.87358,3.9432),(-5.64781,24.89327,3.93002),(-5.58899,24.95319,4.05357),(-5.60475,24.97906,3.95194),(-5.59738,24.92958,3.94961),(-5.74848,24.87673,4.11806),(-5.73027,24.88704,4.13367),(-5.73086,24.93531,4.01892),(-5.77001,24.9476,4.04667),(-5.70221,24.96917,4.06045),(-5.73854,24.98266,4.09077),(-5.80774,25.00228,4.08446),(-5.84558,25.03002,4.09986),(-5.82766,25.03696,4.12002),(-5.79202,25.00191,4.10017),(-5.88487,25.06059,4.09499),(-5.91965,25.08057,4.09523),(-5.88848,25.0997,4.12152),(-5.85753,25.06952,4.11913),(-5.58312,24.87548,4.05257),(-5.5805,24.88592,4.01898),(-5.70598,24.86538,4.07008),(-5.67363,24.8455,4.03628),(-5.71516,24.8671,4.05973),(-5.68102,24.92711,3.94594),(-5.86399,25.12065,4.18276),(-5.8381,25.11754,4.23592),(-5.87649,25.13948,4.21207),(-5.95965,24.95455,4.08535),(-5.96149,24.91995,4.09367),(-5.96523,25.04316,4.09913),(-5.9649,25.00745,4.08959),(-5.84984,25.09935,4.1496),(-5.98597,24.98407,4.10163),(-5.9861,24.977,4.10156),(-5.98518,24.9792,4.10816),(-5.63789,24.90383,3.92658),(-5.77158,24.90437,4.05406),(-5.66634,24.84433,4.03064),(-5.57462,24.88897,4.0583),(-5.57258,24.9012,4.02161),(-5.58603,24.88845,3.99163),(-5.61175,24.95199,3.92978),(-5.9553,24.90069,4.1788),(-5.9794,24.89822,4.15068),(-5.97742,24.89028,4.14953),(-5.959,24.90841,4.17736),(-5.89621,24.93877,4.23782),(-5.9377,24.9192,4.2054),(-5.93383,24.91092,4.20708),(-5.9009,24.94663,4.23548),(-5.98633,25.05236,4.12019),(-5.96574,25.10068,4.14573),(-5.96568,25.10434,4.14085),(-5.98564,25.04948,4.12616),(-5.92033,25.13327,4.17321),(-5.87845,25.1355,4.21516),(-5.92077,25.12941,4.17782),(-5.83383,25.0727,4.25936),(-5.82581,25.07175,4.26215),(-5.84359,25.11417,4.23773),(-5.83619,25.01971,4.27005),(-5.86436,24.97739,4.26248),(-5.85801,24.97134,4.26587),(-5.84369,25.02346,4.26652),(-5.96787,24.94613,4.13927),(-5.95985,24.93325,4.16024),(-5.93091,24.94789,4.19804),(-5.94531,24.9406,4.17922),(-5.88087,24.98765,4.23674),(-5.90587,24.96664,4.21831),(-5.86629,25.02005,4.23952),(-5.85929,25.05492,4.23434),(-5.86667,25.08531,4.21824),(-5.89201,25.10155,4.20173),(-5.95237,25.07751,4.15378),(-5.92153,25.09713,4.17569),(-5.96571,24.99348,4.12754),(-5.96653,25.04165,4.13992),(-5.95756,24.89911,4.10607),(-5.92179,24.88745,4.09176),(-5.9055,25.11764,4.14915),(-5.94421,25.09325,4.11958),(-5.91341,24.86715,4.11596),(-5.92889,24.88825,4.16975),(-5.94739,24.87943,4.13378),(-5.8983,24.87385,4.15927),(-5.87596,24.88201,4.19822),(-5.87194,24.9281,4.23326),(-5.90677,24.89781,4.20354),(-5.84419,24.91444,4.22687),(-5.83452,24.9604,4.25769),(-5.81377,25.0087,4.26217),(-5.82645,25.06848,4.14431),(-5.8056,25.0349,4.14066),(-5.86122,24.86728,4.12117),(-5.89141,24.88404,4.0917),(-5.85998,24.88754,4.09772),(-5.88751,24.86381,4.11748),(-5.85619,24.97862,4.08341),(-5.87227,24.86701,4.1551),(-5.8461,24.86728,4.14941),(-5.8252,24.90138,4.21551),(-5.8528,24.87333,4.18938),(-5.77104,24.96868,4.20933),(-5.78796,24.92531,4.21574),(-5.77034,25.0335,4.21693),(-5.78592,25.02686,4.16557),(-5.7977,25.05438,4.1797),(-5.76869,25.01395,4.18965),(-5.70825,24.93003,3.97914),(-5.69262,24.97386,4.07449),(-5.65876,24.98106,4.04478),(-5.75764,25.00238,4.1367),(-5.77408,25.00264,4.11822),(-5.72583,24.98481,4.10618),(-5.81319,24.87479,4.10054),(-5.80386,24.87572,4.12335),(-5.75743,24.87426,4.09799),(-5.75387,24.9164,4.17734),(-5.81465,24.88899,4.08326),(-5.85482,24.91586,4.08303),(-5.81155,24.91042,4.07193),(-5.81162,24.9619,4.06849),(-5.74563,24.99421,4.15386),(-5.7423,24.95604,4.17216),(-5.71709,24.97888,4.12077),(-5.67599,24.89307,3.94047)]))),
        Shape(DEF='rdphal3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rdphal3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,20,22,21,-1,23,17,24,-1,25,17,26,-1,27,17,28,-1,29,30,31,-1,30,32,31,-1,33,34,35,-1,33,36,34,-1,37,7,0,-1,7,6,0,-1,38,39,40,-1,40,41,38,-1,42,43,44,-1,42,45,43,-1,0,2,37,-1,46,47,48,-1,49,50,51,-1,49,52,50,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,61,63,62,-1,50,64,65,-1,50,52,64,-1,57,66,67,-1,57,59,66,-1,68,62,63,-1,69,70,71,-1,70,72,71,-1,73,74,75,-1,75,54,73,-1,76,54,53,-1,77,54,31,-1,78,17,79,-1,28,17,80,-1,81,82,83,-1,82,84,83,-1,85,17,86,-1,26,17,23,-1,73,87,88,-1,73,89,87,-1,90,17,25,-1,18,17,85,-1,19,21,91,-1,91,92,19,-1,93,8,94,-1,94,95,93,-1,46,48,72,-1,72,70,46,-1,96,43,97,-1,81,98,99,-1,81,83,98,-1,24,17,27,-1,29,54,75,-1,55,54,77,-1,100,101,102,-1,101,103,102,-1,104,105,106,-1,106,107,104,-1,108,70,109,-1,70,69,109,-1,64,7,37,-1,37,65,64,-1,57,110,111,-1,54,29,31,-1,48,47,112,-1,47,113,112,-1,84,97,109,-1,109,69,84,-1,114,98,71,-1,98,83,71,-1,68,115,62,-1,116,87,117,-1,116,88,87,-1,43,118,119,-1,119,44,43,-1,120,45,42,-1,42,121,120,-1,122,123,124,-1,124,125,122,-1,79,17,16,-1,86,17,90,-1,126,127,128,-1,128,129,126,-1,55,130,53,-1,55,131,130,-1,80,17,78,-1,81,132,82,-1,133,91,21,-1,133,134,91,-1,135,104,136,-1,137,105,138,-1,21,139,133,-1,21,22,139,-1,140,141,142,-1,143,111,99,-1,144,11,10,-1,145,146,66,-1,34,36,147,-1,3,130,148,-1,3,5,130,-1,66,147,36,-1,66,146,147,-1,32,59,56,-1,32,30,59,-1,149,150,68,-1,149,131,150,-1,52,94,64,-1,94,52,113,-1,61,112,49,-1,61,151,112,-1,152,114,60,-1,152,98,114,-1,99,152,143,-1,99,98,152,-1,14,142,141,-1,14,13,142,-1,153,154,155,-1,156,154,153,-1,157,158,159,-1,160,158,157,-1,161,162,163,-1,162,161,164,-1,165,166,134,-1,166,165,167,-1,91,168,92,-1,168,91,169,-1,170,171,172,-1,170,173,171,-1,79,174,175,-1,16,174,79,-1,176,78,177,-1,78,176,80,-1,178,28,179,-1,28,178,27,-1,23,180,181,-1,24,180,23,-1,25,182,183,-1,26,182,25,-1,184,90,185,-1,90,184,86,-1,142,186,164,-1,186,142,187,-1,175,13,156,-1,174,13,175,-1,160,177,153,-1,177,160,176,-1,171,179,157,-1,179,171,178,-1,181,173,168,-1,180,173,181,-1,183,169,166,-1,182,169,183,-1,162,185,167,-1,185,162,184,-1,188,136,104,-1,136,188,189,-1,128,133,139,-1,133,128,190,-1,191,105,137,-1,191,127,105,-1,135,105,104,-1,138,105,135,-1,192,193,194,-1,192,195,193,-1,196,197,198,-1,196,199,197,-1,100,200,201,-1,100,102,200,-1,189,14,136,-1,189,15,14,-1,202,124,129,-1,202,203,124,-1,204,205,206,-1,205,204,207,-1,106,123,208,-1,126,123,106,-1,209,204,210,-1,207,204,209,-1,38,211,212,-1,38,41,211,-1,213,103,101,-1,213,214,103,-1,215,216,217,-1,215,218,216,-1,219,43,96,-1,219,118,43,-1,108,220,221,-1,108,120,220,-1,121,222,223,-1,121,224,222,-1,22,202,139,-1,202,22,217,-1,96,132,219,-1,82,132,96,-1,172,197,201,-1,172,159,197,-1,225,210,204,-1,210,225,226,-1,227,147,228,-1,227,34,147,-1,74,145,75,-1,74,146,145,-1,131,77,150,-1,77,131,55,-1,5,53,130,-1,53,5,76,-1,1,89,4,-1,89,1,87,-1,117,229,40,-1,117,0,229,-1,211,100,199,-1,101,100,211,-1,165,191,163,-1,191,165,190,-1,206,225,204,-1,230,225,206,-1,189,154,15,-1,194,154,189,-1,231,230,206,-1,231,232,230,-1,122,208,123,-1,233,208,122,-1,203,125,124,-1,125,203,224,-1,234,218,214,-1,235,218,234,-1,236,220,223,-1,236,93,220,-1,119,11,144,-1,119,118,11,-1,116,228,88,-1,228,116,227,-1,115,60,62,-1,115,152,60,-1,69,83,84,-1,71,83,69,-1,97,45,109,-1,97,43,45,-1,132,99,237,-1,99,132,81,-1,67,110,57,-1,67,12,110,-1,65,148,50,-1,3,148,65,-1,46,95,47,-1,95,46,221,-1,82,97,84,-1,96,97,82,-1,19,170,200,-1,19,92,170,-1,0,234,229,-1,0,6,234,-1,120,109,45,-1,109,120,108,-1,212,199,196,-1,211,199,212,-1,198,159,158,-1,197,159,198,-1,40,116,117,-1,40,39,116,-1,36,67,66,-1,67,36,33,-1,232,35,230,-1,35,232,144,-1,201,170,172,-1,201,200,170,-1,235,223,222,-1,235,236,223,-1,236,234,6,-1,235,234,236,-1,11,219,9,-1,11,118,219,-1,221,93,95,-1,221,220,93,-1,151,48,112,-1,72,48,151,-1,105,126,106,-1,105,127,126,-1,20,217,22,-1,217,20,215,-1,134,190,165,-1,133,190,134,-1,161,138,140,-1,161,137,138,-1,68,58,115,-1,56,58,68,-1,51,68,63,-1,51,149,68,-1,163,137,161,-1,191,137,163,-1,139,129,128,-1,139,202,129,-1,119,232,233,-1,232,119,144,-1,44,233,122,-1,44,119,233,-1,141,136,14,-1,136,141,135,-1,16,187,174,-1,16,18,187,-1,107,188,104,-1,205,188,107,-1,3,37,2,-1,65,37,3,-1,76,73,54,-1,73,76,89,-1,158,193,198,-1,193,158,155,-1,209,196,195,-1,212,196,209,-1,39,227,116,-1,226,227,39,-1,72,114,71,-1,151,114,72,-1,42,224,121,-1,42,125,224,-1,74,88,228,-1,74,73,88,-1,215,102,103,-1,215,20,102,-1,219,237,9,-1,219,132,237,-1,94,47,95,-1,94,113,47,-1,49,63,61,-1,63,49,51,-1,115,143,152,-1,143,115,58,-1,33,12,67,-1,33,10,12,-1,50,149,51,-1,50,148,149,-1,44,125,42,-1,44,122,125,-1,35,10,33,-1,144,10,35,-1,6,93,236,-1,6,8,93,-1,218,222,216,-1,218,235,222,-1,233,231,208,-1,232,231,233,-1,226,38,210,-1,39,38,226,-1,229,214,213,-1,234,214,229,-1,205,192,188,-1,207,192,205,-1,230,34,225,-1,35,34,230,-1,213,40,229,-1,40,213,41,-1,87,0,117,-1,87,1,0,-1,76,4,89,-1,76,5,4,-1,77,32,150,-1,31,32,77,-1,30,75,145,-1,75,30,29,-1,228,146,74,-1,228,147,146,-1,34,226,225,-1,226,34,227,-1,195,207,209,-1,195,192,207,-1,194,155,154,-1,155,194,193,-1,224,216,222,-1,224,203,216,-1,120,223,220,-1,120,121,223,-1,221,70,108,-1,46,70,221,-1,217,203,202,-1,217,216,203,-1,103,218,215,-1,103,214,218,-1,41,101,211,-1,41,213,101,-1,210,212,209,-1,210,38,212,-1,208,107,106,-1,208,231,107,-1,129,123,126,-1,129,124,123,-1,206,107,231,-1,107,206,205,-1,111,58,57,-1,111,143,58,-1,141,138,135,-1,141,140,138,-1,20,200,102,-1,200,20,19,-1,201,199,100,-1,197,199,201,-1,195,198,193,-1,195,196,198,-1,190,127,191,-1,190,128,127,-1,188,194,189,-1,188,192,194,-1,164,184,162,-1,184,164,186,-1,185,166,167,-1,183,166,185,-1,182,168,169,-1,181,168,182,-1,173,178,171,-1,178,173,180,-1,157,176,160,-1,176,157,179,-1,153,175,156,-1,175,153,177,-1,174,142,13,-1,187,142,174,-1,186,86,184,-1,86,186,85,-1,90,183,185,-1,25,183,90,-1,26,181,182,-1,23,181,26,-1,180,27,178,-1,27,180,24,-1,179,80,176,-1,80,179,28,-1,177,79,175,-1,79,177,78,-1,187,85,186,-1,187,18,85,-1,171,159,172,-1,157,159,171,-1,92,173,170,-1,92,168,173,-1,134,169,91,-1,169,134,166,-1,163,167,165,-1,167,163,162,-1,164,140,142,-1,164,161,140,-1,160,155,158,-1,153,155,160,-1,156,15,154,-1,156,13,15,-1,9,110,12,-1,237,110,9,-1,111,237,99,-1,110,237,111,-1,151,60,114,-1,60,151,61,-1,49,113,52,-1,49,112,113,-1,94,7,64,-1,8,7,94,-1,150,56,68,-1,150,32,56,-1,59,145,66,-1,59,30,145,-1,148,131,149,-1,148,130,131,-1,2,4,3,-1,4,2,1,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rdphal3_Coord',point=[(-5.34399,24.7705,3.09541),(-5.29186,24.76314,3.0655),(-5.28891,24.77151,3.07705),(-5.23064,24.76899,3.06448),(-5.23621,24.75927,3.05284),(-5.22713,24.76126,3.04857),(-5.33845,24.80966,3.10742),(-5.28736,24.79994,3.08545),(-5.292,24.82116,3.0812),(-5.28984,24.82132,2.93624),(-5.3326,24.79884,2.98149),(-5.33212,24.81994,2.98196),(-5.28599,24.79719,2.93689),(-5.63077,24.7861,3.02528),(-5.62915,24.78636,3.0178),(-5.62877,24.78348,3.01839),(-5.59974,24.83855,3.09245),(-5.58648,24.86614,3.12997),(-5.59975,24.86364,3.09569),(-5.48606,24.88077,3.23974),(-5.45583,24.87317,3.23017),(-5.49916,24.93726,3.22124),(-5.47963,24.92028,3.19096),(-5.56084,24.87357,3.16826),(-5.56319,24.85593,3.1636),(-5.57656,24.9019,3.15789),(-5.56447,24.89118,3.16538),(-5.56868,24.84095,3.15486),(-5.57828,24.8342,3.13971),(-5.20775,24.77244,2.97039),(-5.20678,24.78146,2.9539),(-5.1924,24.78191,2.97011),(-5.18299,24.80194,2.95477),(-5.33119,24.78301,2.98256),(-5.3773,24.76767,3.01209),(-5.38007,24.78365,3.00102),(-5.32467,24.77468,2.99188),(-5.28589,24.78257,3.08718),(-5.47282,24.72715,3.09239),(-5.42609,24.74658,3.07384),(-5.40926,24.75499,3.10068),(-5.45731,24.74421,3.12568),(-5.3718,24.86852,3.04917),(-5.32515,24.86249,3.00797),(-5.38065,24.87108,3.03281),(-5.31944,24.86364,3.02435),(-5.22435,24.89527,3.0213),(-5.21145,24.8856,3.03646),(-5.20889,24.90407,3.0157),(-5.16771,24.86181,3.0317),(-5.17111,24.81011,3.05557),(-5.16127,24.83915,3.02213),(-5.1804,24.83326,3.05772),(-5.19001,24.77222,3.01464),(-5.20616,24.76414,2.99599),(-5.18252,24.78314,2.99994),(-5.18612,24.81267,2.93979),(-5.22672,24.79971,2.91113),(-5.19413,24.83143,2.92063),(-5.21408,24.78785,2.93796),(-5.17314,24.90142,2.96342),(-5.16994,24.89346,2.99555),(-5.16234,24.8707,2.96432),(-5.16404,24.86787,2.9847),(-5.22722,24.81009,3.08437),(-5.22846,24.78677,3.07735),(-5.27221,24.76214,2.96628),(-5.2821,24.77563,2.94846),(-5.16267,24.83634,2.96855),(-5.24547,24.90288,2.98374),(-5.23354,24.89562,3.00208),(-5.21506,24.92049,2.96675),(-5.20695,24.91731,2.99437),(-5.25932,24.75027,3.02084),(-5.26398,24.75537,2.99688),(-5.23684,24.75853,2.98435),(-5.21829,24.76083,3.02766),(-5.18165,24.79296,2.98162),(-5.59258,24.82874,3.11255),(-5.59745,24.82864,3.10079),(-5.58779,24.82885,3.12418),(-5.24264,24.89123,2.92436),(-5.25549,24.87844,2.94153),(-5.21978,24.90572,2.94031),(-5.25067,24.89217,2.96493),(-5.60437,24.88449,3.11013),(-5.6007,24.89894,3.12455),(-5.29471,24.75744,3.05252),(-5.30004,24.758,3.03089),(-5.24546,24.75492,3.04045),(-5.58843,24.90438,3.14169),(-5.52277,24.94041,3.23705),(-5.51129,24.88714,3.24769),(-5.3025,24.85396,3.07249),(-5.23508,24.83344,3.07968),(-5.25598,24.87137,3.0558),(-5.29091,24.87141,2.97274),(-5.28809,24.87972,2.98564),(-5.20084,24.90822,2.93101),(-5.22173,24.86928,2.9056),(-5.474,24.77398,3.1928),(-5.45642,24.76513,3.17799),(-5.45991,24.81835,3.21901),(-5.44042,24.81141,3.19799),(-5.55555,24.82212,2.98895),(-5.58005,24.9198,3.03328),(-5.53234,24.89521,3.03138),(-5.51506,24.80506,2.99875),(-5.27336,24.88281,3.02168),(-5.28063,24.88298,3.00341),(-5.24043,24.81772,2.9048),(-5.21896,24.8416,2.90353),(-5.18108,24.87803,3.03455),(-5.19316,24.85362,3.0539),(-5.18768,24.91579,2.96407),(-5.17434,24.86952,2.94554),(-5.36958,24.75509,3.05451),(-5.35545,24.75935,3.07683),(-5.3298,24.84776,2.98415),(-5.37996,24.84881,3.00716),(-5.31344,24.865,3.04162),(-5.36162,24.86629,3.0682),(-5.43639,24.88664,3.05576),(-5.48439,24.90706,3.07331),(-5.47128,24.9064,3.09862),(-5.42356,24.88063,3.07368),(-5.52902,24.93766,3.07232),(-5.56847,24.95627,3.07296),(-5.54435,24.96515,3.11129),(-5.50707,24.93753,3.104),(-5.18042,24.77999,3.02695),(-5.16983,24.80241,2.99918),(-5.25962,24.86756,2.92307),(-5.53658,24.96275,3.18221),(-5.55912,24.96972,3.21426),(-5.59436,24.83926,3.00937),(-5.59489,24.80314,3.0044),(-5.61298,24.91861,3.05339),(-5.60646,24.88809,3.03146),(-5.5106,24.95483,3.14571),(-5.6289,24.86107,3.02989),(-5.6283,24.85437,3.02724),(-5.6291,24.85402,3.03441),(-5.20884,24.85304,2.90619),(-5.37947,24.80484,2.99845),(-5.25785,24.75743,2.97694),(-5.26692,24.75638,2.98113),(-5.31787,24.7678,3.00212),(-5.17441,24.79085,3.03906),(-5.16372,24.81607,3.00882),(-5.16892,24.81487,2.97295),(-5.18286,24.90865,2.99865),(-5.18717,24.89811,2.93208),(-5.6112,24.76114,3.07961),(-5.62204,24.75396,3.04302),(-5.60698,24.75328,3.07899),(-5.62511,24.76109,3.04651),(-5.56876,24.77674,3.16062),(-5.59249,24.7528,3.11391),(-5.5637,24.76843,3.16102),(-5.59688,24.76128,3.11445),(-5.64086,24.91934,3.07202),(-5.63085,24.95623,3.1181),(-5.63007,24.96153,3.11487),(-5.64122,24.91439,3.07672),(-5.59423,24.97766,3.16579),(-5.56141,24.96476,3.21528),(-5.59532,24.97229,3.1686),(-5.51896,24.88897,3.24362),(-5.52849,24.93645,3.23632),(-5.51814,24.83442,3.23385),(-5.54083,24.79651,3.20519),(-5.53449,24.78955,3.20758),(-5.52539,24.83921,3.23022),(-5.61498,24.81113,3.05536),(-5.61036,24.79117,3.07218),(-5.59078,24.79145,3.11923),(-5.60048,24.79131,3.09578),(-5.55243,24.81562,3.18088),(-5.57161,24.80211,3.15048),(-5.54146,24.84568,3.19842),(-5.5368,24.88097,3.20779),(-5.54395,24.91583,3.20214),(-5.56806,24.93716,3.18708),(-5.6163,24.9313,3.12006),(-5.5918,24.94225,3.15453),(-5.62374,24.90204,3.09088),(-5.61477,24.86068,3.06188),(-5.54926,24.77325,2.99905),(-5.59173,24.7787,3.00944),(-5.57119,24.97184,3.14051),(-5.60156,24.95908,3.09544),(-5.54451,24.74504,3.01642),(-5.57601,24.74508,3.07158),(-5.58588,24.74978,3.03066),(-5.53988,24.73555,3.06286),(-5.52702,24.72917,3.10737),(-5.53618,24.76022,3.15799),(-5.56215,24.74191,3.1116),(-5.50413,24.74986,3.15281),(-5.49155,24.82708,3.2271),(-5.50679,24.78241,3.20083),(-5.48043,24.92756,3.13386),(-5.45298,24.89703,3.12197),(-5.49014,24.74377,3.0318),(-5.51643,24.77035,3.00379),(-5.48447,24.77177,3.01687),(-5.51701,24.74155,3.02187),(-5.48558,24.86397,3.03666),(-5.51064,24.73084,3.06177),(-5.48134,24.7335,3.06171),(-5.47989,24.74181,3.14123),(-5.49953,24.72442,3.10064),(-5.44299,24.76495,3.15769),(-5.42776,24.80885,3.17065),(-5.43666,24.86794,3.20197),(-5.43788,24.88037,3.14685),(-5.45769,24.90131,3.16827),(-5.42485,24.85936,3.16876),(-5.29586,24.85772,2.94941),(-5.30763,24.8644,3.05874),(-5.26522,24.88261,3.04015),(-5.39689,24.86796,3.11574),(-5.35261,24.86278,3.08634),(-5.40932,24.87486,3.09477),(-5.43386,24.75904,3.02422),(-5.42998,24.75159,3.04815),(-5.37345,24.76004,3.03261),(-5.31078,24.76245,3.01328),(-5.39531,24.77099,3.12448),(-5.43207,24.77895,3.01245),(-5.47768,24.80425,3.01395),(-5.42765,24.80359,3.00982),(-5.43187,24.85398,3.02501),(-5.3855,24.81082,3.13608),(-5.38804,24.85397,3.13169),(-5.34676,24.85184,3.09999),(-5.25041,24.83719,2.90711)]))),
        Shape(DEF='rdphal4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rdphal4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,20,22,21,-1,23,17,24,-1,25,17,26,-1,27,17,28,-1,29,30,31,-1,30,32,31,-1,33,34,35,-1,33,36,34,-1,37,7,0,-1,7,6,0,-1,38,39,40,-1,40,41,38,-1,42,43,44,-1,42,45,43,-1,0,2,37,-1,46,47,48,-1,49,50,51,-1,49,52,50,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,61,63,62,-1,50,64,65,-1,50,52,64,-1,57,66,67,-1,57,59,66,-1,68,62,63,-1,69,70,71,-1,70,72,71,-1,73,74,75,-1,75,54,73,-1,76,54,53,-1,77,54,31,-1,78,17,79,-1,28,17,80,-1,81,82,83,-1,82,84,83,-1,85,17,86,-1,26,17,23,-1,73,87,88,-1,73,89,87,-1,90,17,25,-1,18,17,85,-1,19,21,91,-1,91,92,19,-1,93,8,94,-1,94,95,93,-1,46,48,72,-1,72,70,46,-1,96,43,97,-1,81,98,99,-1,81,83,98,-1,24,17,27,-1,29,54,75,-1,55,54,77,-1,100,101,102,-1,101,103,102,-1,104,105,106,-1,106,107,104,-1,108,70,109,-1,70,69,109,-1,64,7,37,-1,37,65,64,-1,57,110,111,-1,54,29,31,-1,48,47,112,-1,47,113,112,-1,84,97,109,-1,109,69,84,-1,114,98,71,-1,98,83,71,-1,68,115,62,-1,116,87,117,-1,116,88,87,-1,43,118,119,-1,119,44,43,-1,120,45,42,-1,42,121,120,-1,122,123,124,-1,124,125,122,-1,79,17,16,-1,86,17,90,-1,126,127,128,-1,128,129,126,-1,55,130,53,-1,55,131,130,-1,80,17,78,-1,81,132,82,-1,133,91,21,-1,133,134,91,-1,135,104,136,-1,137,105,138,-1,21,139,133,-1,21,22,139,-1,140,141,142,-1,143,111,99,-1,144,11,10,-1,145,146,66,-1,34,36,147,-1,3,130,148,-1,3,5,130,-1,66,147,36,-1,66,146,147,-1,32,59,56,-1,32,30,59,-1,149,150,68,-1,149,131,150,-1,52,94,64,-1,94,52,113,-1,61,112,49,-1,61,151,112,-1,152,114,60,-1,152,98,114,-1,99,152,143,-1,99,98,152,-1,14,142,141,-1,14,13,142,-1,153,154,155,-1,156,154,153,-1,157,158,159,-1,160,158,157,-1,161,162,163,-1,161,164,162,-1,165,134,166,-1,167,134,165,-1,91,168,92,-1,168,91,169,-1,170,171,172,-1,170,173,171,-1,79,174,175,-1,16,174,79,-1,80,176,177,-1,78,176,80,-1,178,28,179,-1,28,178,27,-1,180,24,181,-1,24,180,23,-1,25,182,183,-1,26,182,25,-1,184,90,185,-1,90,184,86,-1,142,186,163,-1,186,142,187,-1,175,13,156,-1,174,13,175,-1,177,153,160,-1,176,153,177,-1,171,179,157,-1,179,171,178,-1,168,181,173,-1,181,168,180,-1,183,169,167,-1,182,169,183,-1,161,185,165,-1,185,161,184,-1,188,136,104,-1,136,188,189,-1,128,133,139,-1,133,128,190,-1,191,105,137,-1,191,127,105,-1,135,105,104,-1,138,105,135,-1,192,193,194,-1,192,195,193,-1,196,197,198,-1,196,199,197,-1,102,200,100,-1,200,102,201,-1,189,14,136,-1,189,15,14,-1,124,202,203,-1,202,124,129,-1,204,205,206,-1,205,204,207,-1,106,123,208,-1,126,123,106,-1,207,209,210,-1,207,204,209,-1,38,211,212,-1,38,41,211,-1,213,103,101,-1,213,214,103,-1,215,216,217,-1,215,218,216,-1,219,43,96,-1,219,118,43,-1,108,220,221,-1,108,120,220,-1,222,121,223,-1,224,121,222,-1,22,202,139,-1,202,22,217,-1,96,132,219,-1,82,132,96,-1,172,197,200,-1,172,159,197,-1,225,204,226,-1,209,204,225,-1,227,147,228,-1,227,34,147,-1,74,145,75,-1,74,146,145,-1,131,77,150,-1,77,131,55,-1,76,130,5,-1,53,130,76,-1,1,89,4,-1,89,1,87,-1,229,117,0,-1,117,229,40,-1,211,100,199,-1,101,100,211,-1,166,191,164,-1,191,166,190,-1,206,226,204,-1,230,226,206,-1,189,154,15,-1,194,154,189,-1,231,230,206,-1,231,232,230,-1,122,208,123,-1,233,208,122,-1,203,125,124,-1,125,203,223,-1,234,218,214,-1,235,218,234,-1,236,220,224,-1,236,93,220,-1,119,11,144,-1,119,118,11,-1,116,228,88,-1,228,116,227,-1,115,60,62,-1,115,152,60,-1,69,83,84,-1,71,83,69,-1,97,45,109,-1,97,43,45,-1,132,99,237,-1,99,132,81,-1,12,57,67,-1,12,110,57,-1,65,148,50,-1,3,148,65,-1,46,95,47,-1,95,46,221,-1,82,97,84,-1,96,97,82,-1,19,170,201,-1,19,92,170,-1,0,234,229,-1,0,6,234,-1,120,109,45,-1,109,120,108,-1,212,199,196,-1,211,199,212,-1,198,159,158,-1,197,159,198,-1,40,116,117,-1,40,39,116,-1,36,67,66,-1,67,36,33,-1,232,35,230,-1,35,232,144,-1,200,170,172,-1,200,201,170,-1,235,224,222,-1,235,236,224,-1,236,234,6,-1,235,234,236,-1,118,9,11,-1,118,219,9,-1,95,220,93,-1,221,220,95,-1,151,48,112,-1,72,48,151,-1,105,126,106,-1,105,127,126,-1,20,217,22,-1,217,20,215,-1,190,134,133,-1,190,166,134,-1,162,138,140,-1,162,137,138,-1,68,58,115,-1,56,58,68,-1,51,68,63,-1,51,149,68,-1,164,137,162,-1,191,137,164,-1,129,139,202,-1,139,129,128,-1,119,232,233,-1,232,119,144,-1,44,233,122,-1,44,119,233,-1,141,136,14,-1,136,141,135,-1,16,187,174,-1,16,18,187,-1,107,188,104,-1,205,188,107,-1,65,2,3,-1,65,37,2,-1,54,89,73,-1,54,76,89,-1,193,158,155,-1,193,198,158,-1,210,196,195,-1,212,196,210,-1,225,116,39,-1,225,227,116,-1,72,114,71,-1,151,114,72,-1,42,223,121,-1,42,125,223,-1,74,88,228,-1,74,73,88,-1,215,102,103,-1,215,20,102,-1,219,237,9,-1,219,132,237,-1,113,95,94,-1,113,47,95,-1,49,63,61,-1,63,49,51,-1,115,143,152,-1,143,115,58,-1,33,12,67,-1,33,10,12,-1,50,149,51,-1,50,148,149,-1,125,44,122,-1,42,44,125,-1,35,10,33,-1,144,10,35,-1,8,236,6,-1,8,93,236,-1,218,222,216,-1,218,235,222,-1,233,231,208,-1,232,231,233,-1,39,209,225,-1,39,38,209,-1,229,214,213,-1,234,214,229,-1,205,192,188,-1,207,192,205,-1,230,34,226,-1,35,34,230,-1,213,40,229,-1,40,213,41,-1,87,0,117,-1,87,1,0,-1,5,89,76,-1,5,4,89,-1,32,77,31,-1,32,150,77,-1,30,75,145,-1,75,30,29,-1,146,228,147,-1,228,146,74,-1,226,227,225,-1,226,34,227,-1,192,210,195,-1,192,207,210,-1,194,155,154,-1,155,194,193,-1,223,216,222,-1,223,203,216,-1,224,120,121,-1,220,120,224,-1,70,221,46,-1,70,108,221,-1,217,203,202,-1,217,216,203,-1,103,218,215,-1,103,214,218,-1,41,101,211,-1,41,213,101,-1,209,212,210,-1,209,38,212,-1,208,107,106,-1,208,231,107,-1,123,129,124,-1,129,123,126,-1,206,107,231,-1,107,206,205,-1,111,58,57,-1,111,143,58,-1,141,138,135,-1,141,140,138,-1,20,201,102,-1,201,20,19,-1,200,199,100,-1,197,199,200,-1,195,198,193,-1,195,196,198,-1,190,127,191,-1,190,128,127,-1,188,194,189,-1,188,192,194,-1,163,184,161,-1,184,163,186,-1,185,167,165,-1,183,167,185,-1,182,168,169,-1,180,168,182,-1,173,178,171,-1,178,173,181,-1,157,177,160,-1,177,157,179,-1,176,156,153,-1,175,156,176,-1,174,142,13,-1,187,142,174,-1,186,86,184,-1,86,186,85,-1,90,183,185,-1,25,183,90,-1,26,180,182,-1,23,180,26,-1,181,27,178,-1,27,181,24,-1,179,80,177,-1,80,179,28,-1,78,175,176,-1,79,175,78,-1,187,85,186,-1,187,18,85,-1,172,157,159,-1,157,172,171,-1,92,173,170,-1,92,168,173,-1,167,91,134,-1,169,91,167,-1,164,165,166,-1,165,164,161,-1,163,140,142,-1,163,162,140,-1,160,155,158,-1,153,155,160,-1,156,15,154,-1,156,13,15,-1,9,110,12,-1,237,110,9,-1,111,237,99,-1,110,237,111,-1,151,60,114,-1,60,151,61,-1,49,113,52,-1,49,112,113,-1,94,7,64,-1,8,7,94,-1,150,56,68,-1,150,32,56,-1,59,145,66,-1,59,30,145,-1,131,148,130,-1,148,131,149,-1,2,4,3,-1,4,2,1,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rdphal4_Coord',point=[(-5.4444,24.97737,2.42491),(-5.38541,24.98951,2.40418),(-5.38694,24.99674,2.4176),(-5.32621,25.01249,2.41648),(-5.32686,25.00319,2.40228),(-5.31773,25.0084,2.40001),(-5.45276,25.01605,2.4429),(-5.39541,25.02421,2.42983),(-5.40574,25.04486,2.42697),(-5.37956,25.07012,2.27889),(-5.42274,25.02814,2.31381),(-5.42873,25.04931,2.31683),(-5.36852,25.04696,2.27756),(-5.72233,24.92542,2.29555),(-5.71956,24.9274,2.28824),(-5.71842,24.92453,2.28859),(-5.71857,24.97515,2.37687),(-5.71999,25.00007,2.42125),(-5.72671,24.99968,2.38309),(-5.64293,25.02397,2.55619),(-5.609,25.02635,2.55176),(-5.66998,25.07996,2.54107),(-5.6404,25.07351,2.51211),(-5.70314,25.00814,2.46665),(-5.69936,24.99062,2.45935),(-5.72563,25.03388,2.45605),(-5.71161,25.02523,2.46498),(-5.69882,24.97559,2.44752),(-5.70379,24.96874,2.42922),(-5.28888,25.03819,2.3252),(-5.28791,25.05026,2.30954),(-5.27646,25.05196,2.32919),(-5.27062,25.07719,2.31773),(-5.41672,25.01254,2.31338),(-5.46279,24.97942,2.33231),(-5.46853,24.99649,2.32225),(-5.40927,25.0044,2.3233),(-5.38898,25.00695,2.42989),(-5.55873,24.89885,2.39014),(-5.51512,24.93436,2.38305),(-5.50541,24.9429,2.41501),(-5.55403,24.91457,2.42944),(-5.49404,25.07555,2.38313),(-5.43903,25.0894,2.34986),(-5.50089,25.07844,2.36483),(-5.43643,25.08936,2.36796),(-5.35105,25.14786,2.38816),(-5.33783,25.1392,2.40525),(-5.33743,25.16189,2.38665),(-5.28637,25.12832,2.40666),(-5.27806,25.07161,2.42442),(-5.27152,25.10905,2.39556),(-5.29465,25.09184,2.42739),(-5.27855,25.0354,2.37418),(-5.28904,25.02601,2.3508),(-5.27197,25.05087,2.36195),(-5.2745,25.0896,2.30298),(-5.30613,25.07023,2.26371),(-5.28496,25.10939,2.28387),(-5.29444,25.05732,2.29245),(-5.29242,25.17798,2.34016),(-5.29218,25.16547,2.37283),(-5.27254,25.15009,2.33975),(-5.27675,25.14335,2.35996),(-5.33857,25.05119,2.44233),(-5.33157,25.02869,2.43218),(-5.3491,25.01072,2.30646),(-5.36005,25.02449,2.28773),(-5.26316,25.1149,2.34004),(-5.36809,25.15598,2.34619),(-5.35709,25.14891,2.36662),(-5.3404,25.1849,2.33712),(-5.33597,25.17928,2.36672),(-5.34178,24.99321,2.36366),(-5.34397,25.00105,2.33874),(-5.31588,25.01385,2.33188),(-5.30534,25.01397,2.38036),(-5.27103,25.06405,2.34449),(-5.71182,24.96392,2.39781),(-5.71468,24.96444,2.38474),(-5.70904,24.96338,2.41072),(-5.35188,25.15514,2.28458),(-5.36363,25.13588,2.29804),(-5.33622,25.17328,2.30733),(-5.36688,25.147,2.3246),(-5.74003,25.01682,2.39935),(-5.74316,25.02987,2.41656),(-5.38436,24.98521,2.38963),(-5.38622,24.98795,2.36643),(-5.33267,24.99836,2.38717),(-5.73547,25.03581,2.43729),(-5.69701,25.07391,2.55275),(-5.67124,25.022,2.55985),(-5.42467,25.07623,2.41967),(-5.35267,25.07315,2.43861),(-5.38096,25.10936,2.41421),(-5.40186,25.11377,2.32189),(-5.40372,25.12069,2.33665),(-5.31661,25.18259,2.30202),(-5.32134,25.14214,2.26715),(-5.59079,24.9284,2.49821),(-5.56817,24.92691,2.48566),(-5.59459,24.97228,2.53313),(-5.56964,24.97426,2.51482),(-5.65249,24.98842,2.27805),(-5.7138,25.07189,2.32972),(-5.65865,25.0608,2.33479),(-5.60873,24.98093,2.29448),(-5.39602,25.12177,2.37698),(-5.40025,25.12302,2.35677),(-5.32416,25.08552,2.25648),(-5.30985,25.11557,2.26238),(-5.30504,25.14036,2.40869),(-5.31286,25.10933,2.42319),(-5.31132,25.18821,2.33948),(-5.28097,25.14875,2.3179),(-5.45834,24.96179,2.37592),(-5.44932,24.96619,2.4022),(-5.43523,25.07741,2.32278),(-5.48919,25.06069,2.33611),(-5.43375,25.08947,2.38705),(-5.48642,25.07293,2.40447),(-5.56478,25.0747,2.37862),(-5.62157,25.07886,2.38905),(-5.61256,25.07755,2.41762),(-5.55321,25.06921,2.39895),(-5.67501,25.09727,2.38235),(-5.71994,25.10486,2.377),(-5.70504,25.11393,2.4223),(-5.65844,25.09788,2.41934),(-5.27342,25.04374,2.38968),(-5.26508,25.0738,2.36602),(-5.36136,25.12696,2.27701),(-5.70839,25.10171,2.4963),(-5.73822,25.09703,2.52528),(-5.69963,24.99137,2.29293),(-5.68839,24.95592,2.28354),(-5.74949,25.05817,2.34339),(-5.73012,25.03316,2.31872),(-5.67411,25.10714,2.46336),(-5.74397,25.00017,2.30934),(-5.7409,24.99407,2.30597),(-5.74278,24.9923,2.31312),(-5.30371,25.12938,2.26853),(-5.47393,25.0183,2.32219),(-5.33518,25.00818,2.31981),(-5.34457,25.00391,2.3221),(-5.40213,24.99769,2.3344),(-5.27275,25.05421,2.4046),(-5.26475,25.08753,2.37874),(-5.26358,25.09095,2.34078),(-5.31013,25.17657,2.37509),(-5.30014,25.17607,2.30476),(-5.70437,24.8967,2.35236),(-5.70687,24.89269,2.31181),(-5.69768,24.89011,2.3517),(-5.71266,24.89837,2.31557),(-5.68039,24.91035,2.44596),(-5.68895,24.88774,2.39042),(-5.67292,24.90337,2.44645),(-5.69597,24.89492,2.39105),(-5.7894,25.07992,2.41035),(-5.7805,25.04803,2.35679),(-5.78014,25.04219,2.36096),(-5.78969,25.08598,2.40782),(-5.76737,25.09729,2.47131),(-5.76745,25.10346,2.46928),(-5.73916,25.09126,2.52528),(-5.67874,25.02241,2.55432),(-5.70138,25.06851,2.55037),(-5.65976,24.96971,2.53815),(-5.66605,24.93034,2.4997),(-5.65805,24.92472,2.50265),(-5.66782,24.9731,2.53349),(-5.71924,24.94975,2.33253),(-5.71139,24.92822,2.3484),(-5.70555,24.92711,2.37465),(-5.69986,24.92597,2.4007),(-5.67932,24.95035,2.47461),(-5.68924,24.93667,2.43792),(-5.68807,25.0155,2.51298),(-5.68046,24.9805,2.49833),(-5.70481,25.04938,2.50976),(-5.73272,25.06656,2.49181),(-5.76772,25.05867,2.41248),(-5.75243,25.0706,2.45414),(-5.76139,25.03228,2.37764),(-5.73513,24.99828,2.345),(-5.63312,24.93959,2.28404),(-5.67868,24.93152,2.28653),(-5.7386,25.10828,2.44746),(-5.75741,25.09472,2.39352),(-5.62274,24.90973,2.29955),(-5.66321,24.89172,2.34956),(-5.66763,24.90062,2.30613),(-5.62298,24.89367,2.34699),(-5.61567,24.88333,2.39452),(-5.64259,24.90329,2.44809),(-5.65513,24.88564,2.39307),(-5.60675,24.90267,2.44822),(-5.62724,24.92639,2.50064),(-5.63001,24.97085,2.53588),(-5.63391,25.09022,2.45428),(-5.59542,25.06931,2.44424),(-5.57089,24.92093,2.3264),(-5.60041,24.94497,2.29535),(-5.57127,24.95303,2.31552),(-5.59527,24.91294,2.31041),(-5.60361,25.04162,2.34626),(-5.56402,24.90802,2.35768),(-5.59233,24.89725,2.35138),(-5.57831,24.90328,2.44042),(-5.58581,24.88731,2.39276),(-5.55141,24.93388,2.46761),(-5.55174,24.97984,2.48912),(-5.58369,25.03119,2.52622),(-5.57951,25.05261,2.47093),(-5.60909,25.06444,2.49122),(-5.56384,25.03148,2.49364),(-5.39875,25.10264,2.29537),(-5.43064,25.08759,2.40573),(-5.39094,25.12071,2.39757),(-5.52986,25.05678,2.44608),(-5.54081,25.06381,2.42283),(-5.47941,25.06885,2.42453),(-5.51623,24.94265,2.35651),(-5.51837,24.95306,2.33204),(-5.46006,24.96939,2.35325),(-5.39531,24.9924,2.34668),(-5.50036,24.95873,2.44414),(-5.52067,24.97547,2.32266),(-5.57388,24.9879,2.3177),(-5.5233,25.00179,2.32374),(-5.5453,25.04846,2.34427),(-5.50461,24.99934,2.46267),(-5.51947,25.04255,2.46264),(-5.47256,25.05721,2.43845),(-5.34036,25.10185,2.25904)]))),
        Shape(DEF='rdphal5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rdphal5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,13,16,14,-1,17,18,19,-1,19,20,17,-1,18,17,21,-1,22,23,24,-1,25,26,27,-1,26,28,27,-1,29,23,30,-1,31,32,33,-1,32,34,33,-1,35,36,37,-1,35,38,36,-1,39,23,40,-1,41,23,42,-1,43,44,45,-1,44,46,45,-1,47,48,49,-1,47,5,48,-1,50,11,0,-1,11,10,0,-1,34,51,52,-1,34,32,51,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,57,60,58,-1,0,2,50,-1,61,62,63,-1,61,64,62,-1,65,66,67,-1,68,69,70,-1,68,71,69,-1,72,73,74,-1,75,76,77,-1,75,78,76,-1,63,79,61,-1,79,80,61,-1,69,81,82,-1,69,71,81,-1,76,3,83,-1,76,78,3,-1,84,61,80,-1,85,86,87,-1,86,88,87,-1,89,90,91,-1,91,73,89,-1,92,73,72,-1,93,73,45,-1,94,23,95,-1,42,23,96,-1,55,10,97,-1,97,53,55,-1,98,99,100,-1,99,101,100,-1,88,67,102,-1,67,103,102,-1,104,26,105,-1,104,28,26,-1,106,23,107,-1,40,23,29,-1,89,108,109,-1,89,110,108,-1,111,23,39,-1,24,23,106,-1,25,27,112,-1,112,113,25,-1,114,115,116,-1,115,12,116,-1,86,67,88,-1,86,65,67,-1,117,58,118,-1,98,119,120,-1,98,100,119,-1,30,23,41,-1,82,50,7,-1,50,2,7,-1,43,73,91,-1,74,73,93,-1,38,121,36,-1,38,57,121,-1,122,123,124,-1,124,125,122,-1,86,85,126,-1,126,127,86,-1,81,11,50,-1,50,82,81,-1,47,14,16,-1,16,83,47,-1,76,128,129,-1,73,43,45,-1,67,66,103,-1,66,130,103,-1,57,131,121,-1,57,59,131,-1,101,118,126,-1,126,85,101,-1,132,119,87,-1,119,100,87,-1,84,64,61,-1,58,133,134,-1,134,59,58,-1,135,60,57,-1,57,38,135,-1,12,115,97,-1,97,10,12,-1,95,23,22,-1,107,23,111,-1,74,136,72,-1,74,137,136,-1,138,6,90,-1,138,4,6,-1,96,23,94,-1,98,139,99,-1,140,112,27,-1,140,141,112,-1,36,142,143,-1,143,37,36,-1,144,135,35,-1,135,38,35,-1,33,145,146,-1,33,34,145,-1,147,148,149,-1,147,150,148,-1,151,122,152,-1,153,123,154,-1,27,155,140,-1,27,28,155,-1,156,20,19,-1,157,129,120,-1,158,15,14,-1,159,6,3,-1,48,5,4,-1,7,136,160,-1,7,9,136,-1,46,78,75,-1,46,44,78,-1,161,162,84,-1,161,137,162,-1,71,116,81,-1,116,71,130,-1,79,103,68,-1,79,102,103,-1,62,132,63,-1,62,119,132,-1,120,62,157,-1,120,119,62,-1,163,164,165,-1,166,164,163,-1,167,168,169,-1,170,168,167,-1,171,172,173,-1,172,171,174,-1,175,141,176,-1,177,141,175,-1,178,113,112,-1,179,113,178,-1,180,181,182,-1,180,183,181,-1,95,184,185,-1,22,184,95,-1,96,186,187,-1,94,186,96,-1,41,188,189,-1,42,188,41,-1,190,30,191,-1,30,190,29,-1,39,192,193,-1,40,192,39,-1,107,194,195,-1,111,194,107,-1,19,196,174,-1,196,19,197,-1,185,18,166,-1,184,18,185,-1,187,163,170,-1,186,163,187,-1,189,167,181,-1,188,167,189,-1,179,191,183,-1,191,179,190,-1,193,178,177,-1,192,178,193,-1,195,175,172,-1,194,175,195,-1,198,152,122,-1,152,198,199,-1,140,200,201,-1,140,155,200,-1,202,123,153,-1,202,203,123,-1,151,123,122,-1,154,123,151,-1,204,205,206,-1,204,207,205,-1,208,147,209,-1,208,150,147,-1,148,210,149,-1,148,211,210,-1,199,17,152,-1,199,21,17,-1,212,213,214,-1,212,142,213,-1,215,216,217,-1,215,218,216,-1,124,219,220,-1,221,219,124,-1,222,218,223,-1,216,218,222,-1,145,224,146,-1,145,56,224,-1,105,143,104,-1,105,54,143,-1,58,225,133,-1,117,225,58,-1,127,144,226,-1,127,135,144,-1,28,212,155,-1,212,28,104,-1,117,139,225,-1,99,139,117,-1,147,182,169,-1,149,182,147,-1,227,218,228,-1,223,218,227,-1,229,4,138,-1,229,48,4,-1,90,159,91,-1,90,6,159,-1,137,93,162,-1,93,137,74,-1,92,136,9,-1,72,136,92,-1,1,110,8,-1,110,1,108,-1,230,231,52,-1,230,0,231,-1,33,148,150,-1,146,148,33,-1,176,202,173,-1,202,176,201,-1,215,228,218,-1,232,228,215,-1,199,164,21,-1,206,164,199,-1,233,232,215,-1,233,234,232,-1,220,131,235,-1,220,219,131,-1,142,121,213,-1,121,142,36,-1,97,144,35,-1,97,115,144,-1,134,15,158,-1,134,133,15,-1,236,138,109,-1,138,236,229,-1,85,100,101,-1,87,100,85,-1,118,60,126,-1,118,58,60,-1,139,120,237,-1,120,139,98,-1,16,76,83,-1,16,128,76,-1,82,160,69,-1,7,160,82,-1,65,114,66,-1,114,65,226,-1,99,118,101,-1,117,118,99,-1,25,180,210,-1,25,113,180,-1,0,55,231,-1,0,10,55,-1,135,126,60,-1,126,135,127,-1,31,150,208,-1,33,150,31,-1,209,169,168,-1,147,169,209,-1,236,52,51,-1,52,236,230,-1,5,83,3,-1,83,5,47,-1,234,49,232,-1,49,234,158,-1,149,180,182,-1,149,210,180,-1,53,35,37,-1,53,97,35,-1,15,225,13,-1,15,133,225,-1,114,144,115,-1,226,144,114,-1,123,221,124,-1,123,203,221,-1,201,141,140,-1,201,176,141,-1,171,154,156,-1,171,153,154,-1,84,77,64,-1,75,77,84,-1,70,84,80,-1,70,161,84,-1,173,153,171,-1,202,153,173,-1,155,214,200,-1,155,212,214,-1,134,234,235,-1,234,134,158,-1,59,235,131,-1,59,134,235,-1,20,152,17,-1,152,20,151,-1,22,197,184,-1,22,24,197,-1,125,198,122,-1,217,198,125,-1,73,110,89,-1,73,92,110,-1,211,146,224,-1,148,146,211,-1,205,168,165,-1,205,209,168,-1,222,208,207,-1,31,208,222,-1,227,236,51,-1,227,229,236,-1,88,132,87,-1,102,132,88,-1,90,109,138,-1,90,89,109,-1,26,224,105,-1,26,211,224,-1,225,237,13,-1,225,139,237,-1,130,114,116,-1,130,66,114,-1,68,80,79,-1,80,68,70,-1,64,157,62,-1,157,64,77,-1,69,161,70,-1,69,160,161,-1,109,230,236,-1,109,108,230,-1,49,14,47,-1,158,14,49,-1,54,37,143,-1,54,53,37,-1,213,131,219,-1,131,213,121,-1,235,233,220,-1,234,233,235,-1,51,223,227,-1,51,32,223,-1,231,56,145,-1,55,56,231,-1,217,204,198,-1,216,204,217,-1,232,48,228,-1,49,48,232,-1,221,200,214,-1,221,203,200,-1,145,52,231,-1,52,145,34,-1,108,0,230,-1,108,1,0,-1,9,110,92,-1,9,8,110,-1,46,93,45,-1,46,162,93,-1,44,91,159,-1,91,44,43,-1,228,229,227,-1,228,48,229,-1,207,216,222,-1,207,204,216,-1,206,165,164,-1,165,206,205,-1,86,226,65,-1,86,127,226,-1,104,142,212,-1,104,143,142,-1,56,105,224,-1,56,54,105,-1,223,31,222,-1,223,32,31,-1,220,125,124,-1,220,233,125,-1,219,214,213,-1,214,219,221,-1,233,217,125,-1,233,215,217,-1,129,77,76,-1,129,157,77,-1,20,154,151,-1,20,156,154,-1,26,210,211,-1,210,26,25,-1,207,209,205,-1,207,208,209,-1,201,203,202,-1,201,200,203,-1,198,206,199,-1,198,204,206,-1,174,195,172,-1,195,174,196,-1,194,177,175,-1,193,177,194,-1,192,179,178,-1,190,179,192,-1,183,189,181,-1,189,183,191,-1,188,170,167,-1,187,170,188,-1,186,166,163,-1,185,166,186,-1,184,19,18,-1,197,19,184,-1,196,107,195,-1,107,196,106,-1,111,193,194,-1,39,193,111,-1,40,190,192,-1,29,190,40,-1,191,41,189,-1,41,191,30,-1,42,187,188,-1,96,187,42,-1,94,185,186,-1,95,185,94,-1,197,106,196,-1,197,24,106,-1,181,169,182,-1,167,169,181,-1,113,183,180,-1,113,179,183,-1,177,112,141,-1,178,112,177,-1,173,175,176,-1,175,173,172,-1,174,156,19,-1,174,171,156,-1,170,165,168,-1,163,165,170,-1,166,21,164,-1,166,18,21,-1,13,128,16,-1,237,128,13,-1,129,237,120,-1,128,237,129,-1,102,63,132,-1,63,102,79,-1,68,130,71,-1,68,103,130,-1,116,11,81,-1,12,11,116,-1,162,75,84,-1,162,46,75,-1,78,159,3,-1,78,44,159,-1,137,160,136,-1,160,137,161,-1,2,8,7,-1,8,2,1,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rdphal5_Coord',point=[(-6.11597,24.92468,1.7218),(-6.06245,24.93024,1.71636),(-6.06295,24.93739,1.72925),(-6.02799,24.94502,1.63011),(-6.07881,24.94085,1.64813),(-6.08497,24.94859,1.63684),(-6.02435,24.93805,1.64542),(-6.00527,24.94571,1.73757),(-6.00683,24.93645,1.72368),(-5.99798,24.94013,1.72243),(-6.11947,24.96199,1.74181),(-6.06858,24.96488,1.74146),(-6.07668,24.98604,1.73878),(-6.05197,25.007,1.6026),(-6.09584,24.97399,1.62745),(-6.09985,24.99552,1.6312),(-6.04322,24.98265,1.60151),(-6.36031,24.94435,1.5448),(-6.3629,24.94244,1.55111),(-6.37034,25.00847,1.58441),(-6.36873,25.01064,1.57783),(-6.35967,24.94125,1.54455),(-6.351,24.97795,1.64172),(-6.34351,24.99019,1.69043),(-6.35261,25.00028,1.65486),(-6.2635,24.97699,1.82326),(-6.23653,24.97654,1.82253),(-6.27781,25.03492,1.81991),(-6.25823,25.02805,1.79445),(-6.32362,24.98362,1.73445),(-6.32464,24.96887,1.72262),(-6.24949,24.8655,1.64684),(-6.22498,24.8714,1.6515),(-6.23836,24.8725,1.69511),(-6.21724,24.88049,1.69137),(-6.13872,25.01714,1.72725),(-6.19032,25.01988,1.71716),(-6.18015,25.00892,1.73876),(-6.1456,25.02348,1.70801),(-6.33777,25.01308,1.73192),(-6.32735,25.00088,1.73778),(-6.32823,24.95805,1.70726),(-6.3354,24.95716,1.6883),(-5.96971,24.9627,1.6528),(-5.96784,24.97388,1.63783),(-5.95686,24.97423,1.65749),(-5.94931,24.99753,1.64702),(-6.09121,24.95779,1.62672),(-6.13546,24.93394,1.63138),(-6.13959,24.95201,1.62296),(-6.06366,24.94746,1.74121),(-6.18436,24.89757,1.65989),(-6.17339,24.90088,1.69319),(-6.17175,24.99239,1.75294),(-6.20598,24.98246,1.774),(-6.16402,24.94965,1.74761),(-6.20305,24.9333,1.76052),(-6.15299,25.02887,1.68723),(-6.10532,25.03546,1.66465),(-6.15925,25.03429,1.66941),(-6.10266,25.03453,1.68228),(-5.94414,25.06916,1.66865),(-5.96693,25.09782,1.63283),(-5.95972,25.09936,1.66784),(-5.95247,25.06865,1.64711),(-6.01884,25.08057,1.71238),(-6.00683,25.07052,1.72938),(-6.00428,25.09203,1.71138),(-5.95858,25.05185,1.73263),(-5.9547,24.99586,1.74889),(-5.9465,25.03053,1.7225),(-5.96918,25.01823,1.75167),(-5.95949,24.95955,1.70036),(-5.97053,24.95152,1.67722),(-5.95241,24.97326,1.68934),(-5.95183,25.00982,1.63256),(-5.98216,24.99495,1.59184),(-5.95959,25.03019,1.61339),(-5.97324,24.98135,1.62087),(-5.96089,25.088,1.6998),(-5.94902,25.06379,1.68829),(-6.01347,24.98562,1.76244),(-6.00881,24.96256,1.75262),(-6.03698,24.9597,1.61134),(-5.93884,25.03354,1.6694),(-6.03429,25.09008,1.67083),(-6.02494,25.08202,1.69144),(-6.00441,25.11356,1.66276),(-6.0009,25.10816,1.69187),(-6.02224,24.92804,1.68507),(-6.02412,24.93554,1.66144),(-5.9969,24.94349,1.65737),(-5.98643,24.94313,1.70459),(-5.95085,24.9855,1.6729),(-6.34573,24.96172,1.65783),(-6.34903,24.96569,1.64586),(-6.34238,24.95769,1.6696),(-6.13307,25.00414,1.73971),(-6.01803,25.08518,1.61098),(-6.03194,25.06875,1.6241),(-6.00181,25.10088,1.63407),(-6.03427,25.08068,1.65001),(-5.97655,25.10165,1.70105),(-5.97524,25.06655,1.73391),(-6.23739,25.01862,1.77518),(-6.21831,24.98078,1.80222),(-6.3583,25.01393,1.67486),(-6.35653,25.02189,1.69445),(-6.06214,24.926,1.70254),(-6.06429,24.92894,1.68058),(-6.01301,24.93224,1.70864),(-6.34719,25.02092,1.71528),(-6.2993,25.03154,1.82743),(-6.2861,24.97803,1.82424),(-6.04942,25.04709,1.73407),(-6.09123,25.0188,1.73165),(-6.02532,25.00872,1.75854),(-6.06977,25.05369,1.64375),(-6.07078,25.06079,1.65807),(-5.98163,25.10667,1.62928),(-5.9901,25.06728,1.59511),(-6.20163,25.0302,1.69465),(-6.29873,24.99136,1.554),(-6.33287,25.07341,1.62149),(-6.29139,25.05288,1.62623),(-6.26347,24.9728,1.57175),(-6.0673,25.06265,1.67793),(-6.06321,25.0609,1.69768),(-5.99777,25.01246,1.58409),(-5.98183,25.03955,1.59092),(-5.98543,25.038,1.74737),(-6.21166,25.0403,1.67559),(-5.97636,25.11224,1.66619),(-6.10324,25.02378,1.63824),(-6.15216,25.0172,1.64116),(-6.09961,25.03371,1.70077),(-5.95356,24.96722,1.71553),(-5.94402,24.99454,1.69401),(-6.07275,24.93463,1.6606),(-6.02986,25.05916,1.6032),(-6.30851,25.06644,1.78326),(-6.33081,25.06263,1.80539),(-6.23104,25.02903,1.73394),(-6.2181,25.00699,1.75596),(-6.09615,25.03095,1.71866),(-6.20982,24.89322,1.73137),(-6.22294,24.88682,1.74435),(-6.29249,24.88231,1.69264),(-6.24057,24.88945,1.75282),(-6.27107,24.89205,1.74954),(-6.26224,24.87555,1.69742),(-6.33682,25.0028,1.5664),(-6.3323,24.96738,1.54916),(-6.36248,25.06425,1.63056),(-6.35336,25.04318,1.60112),(-6.28394,25.07238,1.75646),(-6.37008,25.01634,1.58262),(-5.97485,25.05214,1.59732),(-6.14288,24.97415,1.62472),(-6.01527,24.9407,1.64422),(-5.95169,24.97766,1.72998),(-5.94233,25.00815,1.70644),(-5.94147,25.01036,1.66994),(-6.3508,24.90478,1.59819),(-6.35336,24.90553,1.56001),(-6.34591,24.89707,1.59656),(-6.3577,24.91204,1.56427),(-6.3231,24.89586,1.68893),(-6.33719,24.88696,1.63202),(-6.31773,24.88801,1.68838),(-6.34225,24.89511,1.63368),(-6.38751,25.05665,1.63929),(-6.38427,25.07529,1.69653),(-6.38366,25.08136,1.69503),(-6.38801,25.05061,1.6422),(-6.35835,25.07559,1.75686),(-6.35761,25.08185,1.7559),(-6.3324,25.0571,1.80445),(-6.30375,25.02696,1.82412),(-6.29251,24.97966,1.81883),(-6.2872,24.9304,1.79232),(-6.30258,24.90133,1.74561),(-6.29643,24.89467,1.74791),(-6.29369,24.93501,1.78811),(-6.35769,24.96226,1.5926),(-6.35356,24.93773,1.60191),(-6.34772,24.93105,1.62607),(-6.34137,24.92363,1.6499),(-6.32778,24.92336,1.6875),(-6.31351,24.92601,1.72583),(-6.30515,24.97909,1.77903),(-6.30671,24.94863,1.75622),(-6.31295,25.01357,1.78433),(-6.33387,25.03713,1.77151),(-6.35246,25.05158,1.73818),(-6.37078,25.05254,1.6966),(-6.37399,25.03596,1.65761),(-6.36217,25.00818,1.61784),(-6.28808,24.93915,1.55068),(-6.32695,24.94117,1.54705),(-6.3108,25.0915,1.71922),(-6.33573,25.0861,1.73965),(-6.35789,25.08786,1.68611),(-6.32811,25.09495,1.67408),(-6.28187,24.90598,1.56037),(-6.31753,24.8923,1.59757),(-6.32068,24.90654,1.55957),(-6.28333,24.88582,1.60018),(-6.27571,24.86754,1.64276),(-6.30925,24.87801,1.6368),(-6.26316,24.92814,1.79304),(-6.23435,24.92614,1.7949),(-6.25657,25.05227,1.74612),(-6.24585,25.04414,1.71034),(-6.27779,25.0699,1.71502),(-6.23423,24.93485,1.59027),(-6.25797,24.90178,1.57468),(-6.25988,24.93578,1.56607),(-6.23616,24.90244,1.59452),(-6.2553,25.05235,1.68353),(-6.2501,25.02226,1.6352),(-6.29415,25.07973,1.67963),(-6.25629,24.88181,1.60946),(-6.23045,24.88516,1.62206),(-6.21564,24.92728,1.78121),(-6.06737,25.04204,1.61779),(-6.058,25.0593,1.71768),(-6.18575,24.90819,1.63646),(-6.18731,24.92065,1.61519),(-6.13342,24.92283,1.65021),(-6.12229,24.91561,1.69799),(-6.16559,24.91243,1.72422),(-6.18784,24.9435,1.60971),(-6.23322,24.96883,1.59891),(-6.18796,24.9693,1.61475),(-6.20113,25.01642,1.63969),(-6.13175,24.91409,1.67074),(-6.01182,25.03096,1.58615)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesRightHand.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesRightHand.py load and self-test diagnostics complete.")
