####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesRightFoot.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesRightFoot.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Right Foot',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesRightFoot.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesRightFoot.x3d'),
    Transform(DEF='RightFootSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Viewpoint(DEF='feet',description='RightFoot',fieldOfView=0.785,position=(-3,3,15)),
      Group(DEF='RightFoot',
        #  rtalus rcalc rcuboid rlcun rmcun rnaviclr [missingsomething] rfmet rmet2 rmet3 rmet4 rmet5 rfprox rfpprox2 rfpprox3 rfpprox4 rfpprox5 rfmphal rfmphal2 rfmphal3 rfmphal4 rfdphal rfdphal2 rfdphal3 rfdphal4 rfdphal5 
        children=[
        Shape(DEF='rtalus',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rtalus_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,12,14,15,-1,16,17,18,-1,19,20,21,-1,22,21,23,-1,23,18,22,-1,9,24,4,-1,8,24,9,-1,8,25,24,-1,26,27,28,-1,29,30,31,-1,29,32,30,-1,33,34,28,-1,35,30,2,-1,35,36,30,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,43,46,44,-1,47,48,49,-1,47,50,48,-1,51,52,53,-1,54,55,56,-1,54,57,55,-1,58,59,60,-1,61,62,63,-1,64,65,66,-1,67,68,69,-1,69,70,67,-1,71,64,66,-1,66,72,71,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,82,76,78,-1,82,83,76,-1,81,84,85,-1,81,86,84,-1,87,88,89,-1,90,54,91,-1,92,93,94,-1,93,95,94,-1,87,96,97,-1,97,98,87,-1,92,99,100,-1,92,94,99,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,110,111,112,-1,110,113,111,-1,111,114,115,-1,111,113,114,-1,116,117,118,-1,116,119,117,-1,120,121,122,-1,123,124,125,-1,124,126,125,-1,127,128,120,-1,120,129,127,-1,130,131,132,-1,133,134,135,-1,135,136,133,-1,137,138,139,-1,139,140,137,-1,141,114,113,-1,142,143,144,-1,145,146,147,-1,147,148,145,-1,146,149,150,-1,151,152,153,-1,154,60,155,-1,154,58,60,-1,156,157,158,-1,156,159,157,-1,160,161,162,-1,162,163,160,-1,55,159,150,-1,164,165,166,-1,165,167,166,-1,168,169,103,-1,168,170,169,-1,171,172,173,-1,174,175,26,-1,176,88,177,-1,178,157,57,-1,95,91,179,-1,180,130,181,-1,180,131,130,-1,41,182,42,-1,182,183,42,-1,184,185,183,-1,185,186,183,-1,187,188,189,-1,190,99,191,-1,190,192,99,-1,193,194,60,-1,195,58,160,-1,179,190,191,-1,196,197,198,-1,197,56,198,-1,199,145,148,-1,200,201,143,-1,193,143,194,-1,143,142,194,-1,159,202,150,-1,203,204,205,-1,203,206,204,-1,153,207,167,-1,207,208,167,-1,209,210,211,-1,209,212,210,-1,213,214,215,-1,213,216,214,-1,217,218,219,-1,218,220,219,-1,221,222,223,-1,223,224,221,-1,225,226,227,-1,225,228,226,-1,229,203,226,-1,226,228,229,-1,230,231,232,-1,232,233,230,-1,234,183,182,-1,235,43,45,-1,235,236,43,-1,109,108,237,-1,144,212,142,-1,212,209,142,-1,238,239,240,-1,241,242,243,-1,244,245,110,-1,244,246,245,-1,247,248,102,-1,249,247,237,-1,246,244,250,-1,250,101,246,-1,110,251,113,-1,110,245,251,-1,252,253,254,-1,141,255,256,-1,256,114,141,-1,104,106,257,-1,111,115,258,-1,161,154,253,-1,154,258,253,-1,104,257,190,-1,257,192,190,-1,151,153,167,-1,167,165,151,-1,165,259,151,-1,151,259,260,-1,260,240,151,-1,261,238,262,-1,238,263,262,-1,264,265,266,-1,264,267,265,-1,268,172,171,-1,268,269,172,-1,171,270,271,-1,63,272,61,-1,264,266,273,-1,266,61,273,-1,274,275,276,-1,277,278,279,-1,280,281,282,-1,283,284,280,-1,280,282,13,-1,125,126,285,-1,285,286,125,-1,287,124,288,-1,11,282,289,-1,11,13,282,-1,290,291,292,-1,292,293,290,-1,291,294,292,-1,295,296,297,-1,295,139,296,-1,298,299,286,-1,299,125,286,-1,300,301,134,-1,301,135,134,-1,302,303,304,-1,302,305,303,-1,306,307,308,-1,308,309,306,-1,310,36,35,-1,311,312,36,-1,36,310,311,-1,313,314,315,-1,315,316,313,-1,317,318,319,-1,319,316,317,-1,129,320,317,-1,317,321,129,-1,322,323,324,-1,325,119,326,-1,325,327,119,-1,328,329,330,-1,82,331,73,-1,82,332,331,-1,74,333,329,-1,74,334,333,-1,335,336,337,-1,338,176,339,-1,176,177,339,-1,78,340,341,-1,341,332,78,-1,342,343,344,-1,344,65,342,-1,345,346,53,-1,53,47,345,-1,347,348,349,-1,350,351,352,-1,351,353,352,-1,347,349,354,-1,354,355,347,-1,354,356,355,-1,356,357,355,-1,358,359,350,-1,350,352,358,-1,360,361,362,-1,363,364,358,-1,358,357,363,-1,85,365,366,-1,367,368,369,-1,367,97,368,-1,90,181,54,-1,90,180,181,-1,26,370,371,-1,26,372,370,-1,373,372,28,-1,373,374,372,-1,38,33,28,-1,375,376,0,-1,376,377,0,-1,26,371,378,-1,378,174,26,-1,378,379,380,-1,378,371,379,-1,381,341,340,-1,381,382,341,-1,380,381,340,-1,340,383,380,-1,384,379,385,-1,386,51,387,-1,386,52,51,-1,70,388,389,-1,389,67,70,-1,39,390,37,-1,391,392,393,-1,186,42,183,-1,394,395,49,-1,197,91,54,-1,48,394,49,-1,396,390,397,-1,396,8,390,-1,387,51,398,-1,51,399,398,-1,2,30,32,-1,29,31,312,-1,384,382,381,-1,384,312,382,-1,400,401,402,-1,400,403,401,-1,7,404,3,-1,377,376,370,-1,28,34,373,-1,374,405,372,-1,28,372,26,-1,98,177,87,-1,177,88,87,-1,86,406,84,-1,96,407,408,-1,407,409,408,-1,410,409,192,-1,410,411,409,-1,363,412,413,-1,413,414,363,-1,79,356,80,-1,349,415,354,-1,394,48,416,-1,344,417,66,-1,66,65,344,-1,418,52,386,-1,418,419,52,-1,333,420,421,-1,333,422,420,-1,331,423,334,-1,423,424,334,-1,425,426,427,-1,425,428,426,-1,329,421,429,-1,329,333,421,-1,329,328,74,-1,328,75,74,-1,429,330,329,-1,429,430,330,-1,188,431,314,-1,188,432,431,-1,433,17,16,-1,434,311,435,-1,436,437,438,-1,439,437,325,-1,325,127,439,-1,324,440,441,-1,324,323,440,-1,439,129,321,-1,439,127,129,-1,314,431,442,-1,442,315,314,-1,300,132,443,-1,300,134,132,-1,444,445,446,-1,446,447,444,-1,301,448,135,-1,448,137,135,-1,449,298,300,-1,298,301,300,-1,298,286,448,-1,448,301,298,-1,286,450,448,-1,291,451,294,-1,291,452,451,-1,289,453,454,-1,289,282,453,-1,455,280,15,-1,274,453,275,-1,274,293,453,-1,63,456,272,-1,456,290,272,-1,457,22,18,-1,18,17,457,-1,272,274,61,-1,171,173,458,-1,458,459,270,-1,457,460,461,-1,461,22,457,-1,263,462,262,-1,462,463,262,-1,260,263,238,-1,238,240,260,-1,464,462,465,-1,464,463,462,-1,164,259,165,-1,164,466,259,-1,258,254,253,-1,258,115,254,-1,162,161,253,-1,255,141,235,-1,235,45,255,-1,113,251,141,-1,251,235,141,-1,467,112,155,-1,155,468,467,-1,247,102,109,-1,109,237,247,-1,247,249,469,-1,469,248,247,-1,243,470,471,-1,243,242,470,-1,472,240,239,-1,468,473,467,-1,236,235,474,-1,226,203,205,-1,205,475,226,-1,476,477,229,-1,229,228,476,-1,227,226,478,-1,226,475,478,-1,222,228,225,-1,222,476,228,-1,223,225,216,-1,223,222,225,-1,210,219,479,-1,219,224,479,-1,211,480,481,-1,207,482,208,-1,482,483,208,-1,459,458,205,-1,205,204,459,-1,484,149,485,-1,484,55,149,-1,218,147,146,-1,146,486,218,-1,487,485,145,-1,195,487,488,-1,195,489,487,-1,252,196,162,-1,60,59,193,-1,179,191,95,-1,191,94,95,-1,189,180,187,-1,460,490,25,-1,460,457,490,-1,111,155,112,-1,491,492,257,-1,192,257,410,-1,493,494,233,-1,441,128,324,-1,441,120,128,-1,495,496,123,-1,119,327,117,-1,176,89,88,-1,26,175,497,-1,497,27,26,-1,250,473,109,-1,481,209,211,-1,198,56,484,-1,56,55,484,-1,107,468,142,-1,468,194,142,-1,160,58,161,-1,58,154,161,-1,159,57,157,-1,159,55,57,-1,498,451,452,-1,452,206,498,-1,237,499,249,-1,237,481,499,-1,162,196,198,-1,153,152,500,-1,500,207,153,-1,501,207,500,-1,501,482,207,-1,63,204,456,-1,63,459,204,-1,265,271,266,-1,500,152,170,-1,149,55,150,-1,252,162,253,-1,138,296,139,-1,138,502,296,-1,136,135,137,-1,137,140,136,-1,132,134,130,-1,134,133,130,-1,125,495,123,-1,125,299,495,-1,14,12,279,-1,12,277,279,-1,127,325,128,-1,503,504,505,-1,428,117,337,-1,428,118,117,-1,322,326,506,-1,254,115,106,-1,115,114,106,-1,250,109,102,-1,102,101,250,-1,468,107,473,-1,107,109,473,-1,105,196,252,-1,105,179,196,-1,90,91,507,-1,94,191,99,-1,365,410,413,-1,365,411,410,-1,508,416,362,-1,362,493,508,-1,418,386,77,-1,386,343,77,-1,410,509,413,-1,509,414,413,-1,354,80,356,-1,354,415,80,-1,80,415,510,-1,332,82,78,-1,511,512,513,-1,327,436,117,-1,436,514,117,-1,171,458,270,-1,61,266,62,-1,54,56,197,-1,163,162,198,-1,70,512,388,-1,69,515,516,-1,516,513,69,-1,47,49,395,-1,395,345,47,-1,510,81,80,-1,256,491,257,-1,404,33,37,-1,33,38,37,-1,1,517,308,-1,308,307,1,-1,28,184,38,-1,31,36,312,-1,370,376,371,-1,376,379,371,-1,31,30,36,-1,8,460,25,-1,8,396,460,-1,518,465,267,-1,14,519,520,-1,19,22,461,-1,19,21,22,-1,19,461,464,-1,16,455,520,-1,13,12,280,-1,12,15,280,-1,7,3,5,-1,392,24,393,-1,24,25,393,-1,384,385,29,-1,29,312,384,-1,32,375,0,-1,32,0,2,-1,35,306,310,-1,35,307,306,-1,375,29,385,-1,29,375,32,-1,5,24,392,-1,5,4,24,-1,16,23,283,-1,16,18,23,-1,23,20,521,-1,21,20,23,-1,464,460,396,-1,460,464,461,-1,236,522,182,-1,236,474,522,-1,385,376,375,-1,376,385,379,-1,10,404,37,-1,10,3,404,-1,391,403,6,-1,304,403,391,-1,308,401,303,-1,308,517,401,-1,491,255,523,-1,491,256,255,-1,345,516,515,-1,345,395,516,-1,513,70,69,-1,70,513,512,-1,524,399,346,-1,525,399,524,-1,526,514,436,-1,526,527,514,-1,83,73,528,-1,83,82,73,-1,529,330,530,-1,529,328,330,-1,531,416,508,-1,394,416,531,-1,414,532,533,-1,509,532,414,-1,365,84,411,-1,84,365,85,-1,86,510,530,-1,81,510,86,-1,418,76,534,-1,77,76,418,-1,386,344,343,-1,386,387,344,-1,395,531,516,-1,395,394,531,-1,494,533,532,-1,533,494,361,-1,535,348,528,-1,535,349,348,-1,97,536,98,-1,536,97,367,-1,467,250,244,-1,250,467,473,-1,537,336,538,-1,537,426,336,-1,337,426,428,-1,337,336,426,-1,440,539,540,-1,440,323,539,-1,541,503,542,-1,543,503,541,-1,14,544,519,-1,279,544,14,-1,287,12,11,-1,12,287,277,-1,545,495,299,-1,545,546,495,-1,547,548,549,-1,550,548,547,-1,542,505,551,-1,542,503,505,-1,485,146,145,-1,146,485,149,-1,452,204,206,-1,456,204,452,-1,62,459,63,-1,62,270,459,-1,266,270,62,-1,271,270,266,-1,297,498,552,-1,451,498,297,-1,158,553,156,-1,295,553,158,-1,554,249,499,-1,249,554,469,-1,60,468,155,-1,468,60,194,-1,209,107,142,-1,209,108,107,-1,482,469,554,-1,501,469,482,-1,294,502,292,-1,502,294,296,-1,472,471,169,-1,472,239,471,-1,286,555,450,-1,555,286,285,-1,556,557,558,-1,559,557,556,-1,504,560,505,-1,504,561,560,-1,278,559,556,-1,278,288,559,-1,562,549,563,-1,562,547,549,-1,496,546,564,-1,496,495,546,-1,326,128,325,-1,322,128,326,-1,322,324,128,-1,327,437,436,-1,325,437,327,-1,493,232,508,-1,232,493,233,-1,492,523,565,-1,492,491,523,-1,10,390,8,-1,37,390,10,-1,262,234,261,-1,234,262,566,-1,366,413,412,-1,366,365,413,-1,489,160,163,-1,160,489,195,-1,487,484,485,-1,487,489,484,-1,488,200,59,-1,488,199,200,-1,147,217,567,-1,147,218,217,-1,146,202,486,-1,146,150,202,-1,568,156,553,-1,569,156,568,-1,552,229,477,-1,552,498,229,-1,205,173,475,-1,173,205,458,-1,166,570,269,-1,166,571,570,-1,554,483,482,-1,554,572,483,-1,481,573,499,-1,573,481,480,-1,574,480,479,-1,480,574,573,-1,215,572,213,-1,572,215,483,-1,212,219,210,-1,212,217,219,-1,479,223,574,-1,479,224,223,-1,227,216,225,-1,216,227,214,-1,486,220,218,-1,486,575,220,-1,576,222,221,-1,576,476,222,-1,575,202,569,-1,486,202,575,-1,476,568,477,-1,576,568,476,-1,41,236,182,-1,236,41,43,-1,241,235,251,-1,241,474,235,-1,230,494,577,-1,233,494,230,-1,102,168,103,-1,102,248,168,-1,44,565,523,-1,577,565,44,-1,268,466,164,-1,268,265,466,-1,267,462,578,-1,465,462,267,-1,500,168,501,-1,500,170,168,-1,246,103,470,-1,103,246,101,-1,263,578,462,-1,263,260,578,-1,566,183,234,-1,566,39,183,-1,20,518,579,-1,518,20,19,-1,580,275,281,-1,276,275,580,-1,581,284,521,-1,580,284,581,-1,579,521,20,-1,579,581,521,-1,290,274,272,-1,290,293,274,-1,451,296,294,-1,297,296,451,-1,448,138,137,-1,448,450,138,-1,450,502,138,-1,450,555,502,-1,299,449,545,-1,449,299,298,-1,140,157,136,-1,158,157,140,-1,520,541,582,-1,519,541,520,-1,583,433,16,-1,583,584,433,-1,25,585,393,-1,25,490,585,-1,586,583,582,-1,586,587,583,-1,585,588,589,-1,584,588,585,-1,302,391,393,-1,302,304,391,-1,590,587,586,-1,590,591,587,-1,592,589,588,-1,592,593,589,-1,594,590,595,-1,590,594,591,-1,596,592,597,-1,592,596,593,-1,308,305,309,-1,305,308,303,-1,598,594,595,-1,598,447,594,-1,597,599,596,-1,597,446,599,-1,600,447,598,-1,600,444,447,-1,446,601,599,-1,446,445,601,-1,444,602,603,-1,600,602,444,-1,445,435,601,-1,445,604,435,-1,443,131,319,-1,443,132,131,-1,431,438,442,-1,431,605,438,-1,315,439,321,-1,442,439,315,-1,449,443,606,-1,443,449,300,-1,318,550,606,-1,318,548,550,-1,121,561,563,-1,121,560,561,-1,288,564,559,-1,288,496,564,-1,504,543,558,-1,543,504,503,-1,505,441,440,-1,505,560,441,-1,436,605,526,-1,605,436,438,-1,423,382,434,-1,423,341,382,-1,434,424,423,-1,434,435,424,-1,422,603,420,-1,422,604,603,-1,457,433,490,-1,457,17,433,-1,607,608,609,-1,610,608,607,-1,432,187,611,-1,432,188,187,-1,313,188,314,-1,313,189,188,-1,432,605,431,-1,432,609,605,-1,430,530,330,-1,530,430,612,-1,537,369,613,-1,537,367,369,-1,538,335,614,-1,538,336,335,-1,427,430,429,-1,427,613,430,-1,425,429,421,-1,429,425,427,-1,608,527,526,-1,608,338,527,-1,331,341,423,-1,332,341,331,-1,424,333,334,-1,424,422,333,-1,615,421,420,-1,421,615,425,-1,425,118,428,-1,118,425,615,-1,383,78,77,-1,340,78,383,-1,72,417,525,-1,417,72,66,-1,513,531,511,-1,531,513,516,-1,416,616,362,-1,616,416,48,-1,48,617,616,-1,48,50,617,-1,50,419,617,-1,50,52,419,-1,612,86,530,-1,406,86,612,-1,358,360,359,-1,358,364,360,-1,533,363,414,-1,533,364,363,-1,412,79,366,-1,412,356,79,-1,192,407,99,-1,192,409,407,-1,408,411,84,-1,409,411,408,-1,84,368,408,-1,368,84,406,-1,339,98,536,-1,339,177,98,-1,176,100,89,-1,176,610,100,-1,93,607,611,-1,607,93,92,-1,389,71,67,-1,71,389,497,-1,64,497,175,-1,71,497,64,-1,405,370,372,-1,377,370,405,-1,373,7,400,-1,34,7,373,-1,618,374,402,-1,374,618,405,-1,6,400,7,-1,6,403,400,-1,517,402,401,-1,402,517,618,-1,1,618,517,-1,1,0,618,-1,312,434,382,-1,312,311,434,-1,463,396,397,-1,396,463,464,-1,279,556,544,-1,279,278,556,-1,565,509,492,-1,509,565,532,-1,197,179,91,-1,197,196,179,-1,257,509,410,-1,492,509,257,-1,619,186,388,-1,42,186,619,-1,39,397,390,-1,39,566,397,-1,39,184,183,-1,39,38,184,-1,185,388,186,-1,389,388,185,-1,388,511,619,-1,511,388,512,-1,379,381,380,-1,381,379,384,-1,378,383,342,-1,378,380,383,-1,174,342,65,-1,174,378,342,-1,0,405,618,-1,405,0,377,-1,402,373,400,-1,373,402,374,-1,34,404,7,-1,33,404,34,-1,65,175,174,-1,64,175,65,-1,185,497,389,-1,185,27,497,-1,54,178,57,-1,178,54,181,-1,507,611,187,-1,611,507,93,-1,92,610,607,-1,610,92,100,-1,369,406,612,-1,369,368,406,-1,408,97,96,-1,408,368,97,-1,81,366,79,-1,366,81,85,-1,363,356,412,-1,356,363,357,-1,361,364,533,-1,361,360,364,-1,359,362,616,-1,359,360,362,-1,350,616,617,-1,350,359,616,-1,358,355,357,-1,355,358,352,-1,347,352,353,-1,352,347,355,-1,617,351,350,-1,617,419,351,-1,47,52,50,-1,47,53,52,-1,351,620,353,-1,620,351,534,-1,348,353,620,-1,347,353,348,-1,524,69,68,-1,524,515,69,-1,68,525,524,-1,68,72,525,-1,342,77,343,-1,342,383,77,-1,419,534,351,-1,419,418,534,-1,514,337,117,-1,514,335,337,-1,527,335,514,-1,614,335,527,-1,610,338,608,-1,610,176,338,-1,339,527,338,-1,614,527,339,-1,74,331,334,-1,73,331,74,-1,426,613,427,-1,426,537,613,-1,536,614,339,-1,536,538,614,-1,613,612,430,-1,612,613,369,-1,609,526,605,-1,609,608,526,-1,131,189,313,-1,131,180,189,-1,609,611,607,-1,609,432,611,-1,615,603,602,-1,420,603,615,-1,604,424,435,-1,424,604,422,-1,118,602,116,-1,118,615,602,-1,560,120,441,-1,120,560,121,-1,558,544,556,-1,558,543,544,-1,557,563,561,-1,563,557,562,-1,545,606,550,-1,606,545,449,-1,317,548,318,-1,317,320,548,-1,606,319,318,-1,319,606,443,-1,317,315,321,-1,315,317,316,-1,442,437,439,-1,438,437,442,-1,313,319,131,-1,319,313,316,-1,311,601,435,-1,601,311,310,-1,445,603,604,-1,444,603,445,-1,506,602,600,-1,506,116,602,-1,599,310,306,-1,599,601,310,-1,539,600,598,-1,539,506,600,-1,306,596,599,-1,596,306,309,-1,594,446,597,-1,594,447,446,-1,598,540,539,-1,540,598,595,-1,309,593,596,-1,593,309,305,-1,591,597,592,-1,591,594,597,-1,551,595,590,-1,551,540,595,-1,305,589,593,-1,589,305,302,-1,588,591,592,-1,587,591,588,-1,551,586,542,-1,551,590,586,-1,589,393,585,-1,589,302,393,-1,587,584,583,-1,587,588,584,-1,582,542,586,-1,541,542,582,-1,490,584,585,-1,433,584,490,-1,582,16,520,-1,582,583,16,-1,136,178,133,-1,136,157,178,-1,124,496,288,-1,496,124,123,-1,140,295,158,-1,295,140,139,-1,555,292,502,-1,555,454,292,-1,292,453,293,-1,453,292,454,-1,277,288,278,-1,288,277,287,-1,452,290,456,-1,290,452,291,-1,126,289,285,-1,289,126,11,-1,284,281,280,-1,281,284,580,-1,281,453,282,-1,275,453,281,-1,274,273,61,-1,273,274,276,-1,264,581,579,-1,581,264,273,-1,273,580,581,-1,273,276,580,-1,171,265,268,-1,271,265,171,-1,579,267,264,-1,579,518,267,-1,466,260,259,-1,578,260,466,-1,522,238,261,-1,522,243,238,-1,169,470,103,-1,470,169,471,-1,578,265,267,-1,578,466,265,-1,472,151,240,-1,152,151,472,-1,164,269,268,-1,164,166,269,-1,105,190,179,-1,190,105,104,-1,111,154,155,-1,154,111,258,-1,257,114,256,-1,257,106,114,-1,501,248,469,-1,168,248,501,-1,470,245,246,-1,242,245,470,-1,251,242,241,-1,242,251,245,-1,532,577,494,-1,532,565,577,-1,577,46,230,-1,44,46,577,-1,182,261,234,-1,522,261,182,-1,232,619,511,-1,232,231,619,-1,230,40,231,-1,40,230,46,-1,576,569,568,-1,575,569,576,-1,220,576,221,-1,220,575,576,-1,227,570,214,-1,227,478,570,-1,221,219,220,-1,219,221,224,-1,570,215,214,-1,215,570,571,-1,216,574,223,-1,574,216,213,-1,208,215,571,-1,483,215,208,-1,213,573,574,-1,573,213,572,-1,211,479,480,-1,211,210,479,-1,572,499,573,-1,554,499,572,-1,167,571,166,-1,167,208,571,-1,269,478,172,-1,269,570,478,-1,498,203,229,-1,498,206,203,-1,553,477,568,-1,553,552,477,-1,159,569,202,-1,159,156,569,-1,212,567,217,-1,212,144,567,-1,59,143,193,-1,59,200,143,-1,201,199,148,-1,201,200,199,-1,199,487,145,-1,487,199,488,-1,489,198,484,-1,163,198,489,-1,59,195,488,-1,58,195,59,-1,566,463,397,-1,566,262,463,-1,27,184,28,-1,27,185,184,-1,231,42,619,-1,231,40,42,-1,181,133,178,-1,181,130,133,-1,90,187,180,-1,507,187,90,-1,508,511,531,-1,511,508,232,-1,547,564,546,-1,564,547,562,-1,122,563,549,-1,563,122,121,-1,561,558,557,-1,558,561,504,-1,559,562,557,-1,564,562,559,-1,285,454,555,-1,454,285,289,-1,475,172,478,-1,475,173,172,-1,243,239,238,-1,239,243,471,-1,152,169,170,-1,152,472,169,-1,481,108,209,-1,481,237,108,-1,295,552,553,-1,297,552,295,-1,201,144,143,-1,567,144,201,-1,567,148,147,-1,567,201,148,-1,122,129,120,-1,122,320,129,-1,116,326,119,-1,116,506,326,-1,549,320,122,-1,548,320,549,-1,550,546,545,-1,550,547,546,-1,124,11,126,-1,124,287,11,-1,519,543,541,-1,544,543,519,-1,551,440,540,-1,505,440,551,-1,539,322,506,-1,539,323,322,-1,252,106,105,-1,252,254,106,-1,244,112,467,-1,112,244,110,-1,407,87,89,-1,407,96,87,-1,538,367,537,-1,538,536,367,-1,99,89,100,-1,89,99,407,-1,93,91,95,-1,93,507,91,-1,83,534,76,-1,83,620,534,-1,415,535,529,-1,415,349,535,-1,515,346,345,-1,515,524,346,-1,620,528,348,-1,620,83,528,-1,387,417,344,-1,387,398,417,-1,362,494,493,-1,362,361,494,-1,398,525,417,-1,398,399,525,-1,75,528,73,-1,75,535,528,-1,328,535,75,-1,529,535,328,-1,415,530,510,-1,530,415,529,-1,72,67,71,-1,67,72,68,-1,399,53,346,-1,399,51,53,-1,45,523,255,-1,523,45,44,-1,40,43,41,-1,40,46,43,-1,304,401,403,-1,303,401,304,-1,6,392,391,-1,5,392,6,-1,474,243,522,-1,474,241,243,-1,465,19,464,-1,465,518,19,-1,521,283,23,-1,521,284,283,-1,283,455,16,-1,283,280,455,-1,520,15,14,-1,15,520,455,-1,10,4,3,-1,10,9,4,-1,2,307,35,-1,2,1,307,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rtalus_Coord',point=[(-3.13459,2.64733,-2.72555),(-3.07362,2.75422,-2.76949),(-3.0221,2.69259,-2.86979),(-3.06228,2.59994,-1.98561),(-3.03105,2.66388,-1.96595),(-3.04704,2.69662,-2.00971),(-3.05597,2.71937,-2.05696),(-3.13643,2.64567,-2.15571),(-2.88771,2.62457,-1.93139),(-3.00743,2.64912,-1.95045),(-3.03251,2.59711,-1.96622),(-1.75201,2.32913,-1.77376),(-1.79858,2.43466,-1.78068),(-1.83473,2.42496,-1.75739),(-1.83136,2.54116,-1.82949),(-1.92989,2.51337,-1.80691),(-2.23471,2.57908,-1.8617),(-2.4058,2.58431,-1.86909),(-2.39881,2.57177,-1.85265),(-2.61035,2.48289,-1.75864),(-2.55291,2.48736,-1.76601),(-2.56179,2.5006,-1.77745),(-2.5744,2.5194,-1.79371),(-2.38515,2.53022,-1.8371),(-3.00581,2.67767,-1.95975),(-2.8667,2.64855,-1.92802),(-3.20512,2.31495,-2.52186),(-3.16848,2.27465,-2.4082),(-3.17864,2.34986,-2.39722),(-3.02764,2.58124,-2.93629),(-3.00515,2.62581,-2.93943),(-2.98952,2.6028,-2.95841),(-3.04396,2.59925,-2.91049),(-3.11276,2.4399,-2.17802),(-3.16577,2.50486,-2.26742),(-2.96706,2.68782,-2.89604),(-2.94693,2.62145,-2.95275),(-3.05619,2.52219,-2.01093),(-3.09558,2.41942,-2.16443),(-2.89445,2.37125,-2.0678),(-2.74501,2.0281,-2.21825),(-2.73626,2.05618,-2.19511),(-2.91518,2.08033,-2.18725),(-2.62979,2.01408,-2.23912),(-2.48366,1.98484,-2.31837),(-2.47061,2.0029,-2.29102),(-2.64042,1.98995,-2.26306),(-3.28527,1.8457,-2.55399),(-2.99884,1.79121,-2.49689),(-3.2158,1.78588,-2.46499),(-3.12639,1.93152,-2.62774),(-3.36155,1.96215,-2.68309),(-3.24072,2.05406,-2.76748),(-3.3336,1.91915,-2.63536),(-1.76829,1.97557,-2.44828),(-1.75119,1.84401,-2.32633),(-1.78115,1.93352,-2.43678),(-1.74602,1.88397,-2.32323),(-2.14817,1.8074,-2.41824),(-2.10914,1.70057,-2.26215),(-2.28117,1.758,-2.30097),(-2.34206,2.36061,-1.31296),(-2.37547,2.3629,-1.2731),(-2.29882,2.34508,-1.18772),(-3.39668,2.08699,-2.64048),(-3.34996,2.1047,-2.72241),(-3.41989,2.05559,-2.66783),(-3.37771,1.97859,-2.47702),(-3.3994,1.94304,-2.51108),(-3.33538,1.87954,-2.41885),(-3.29603,1.91026,-2.38565),(-3.39525,2.03554,-2.55894),(-3.41332,1.99494,-2.58455),(-2.85525,2.25235,-3.23994),(-2.65672,2.21689,-3.28579),(-2.66621,2.1661,-3.29518),(-3.04656,2.24932,-3.03703),(-3.16391,2.22302,-2.92854),(-3.0509,2.27142,-3.0325),(-2.2532,1.94742,-3.10882),(-2.32734,1.9489,-3.17283),(-2.22059,1.88147,-3.15909),(-2.93819,2.27176,-3.16115),(-2.94258,2.2519,-3.16398),(-2.08534,1.8509,-3.10302),(-2.10927,1.86381,-3.08496),(-2.20855,1.8983,-3.18656),(-1.83492,1.86429,-3.05481),(-1.81038,1.88264,-3.05032),(-1.78944,1.8739,-2.98576),(-1.72479,2.06266,-2.54239),(-1.74263,2.02475,-2.56541),(-1.71424,1.99718,-2.7337),(-1.718,2.03799,-2.64425),(-1.7399,1.97447,-2.71963),(-1.74396,2.00198,-2.6256),(-1.86888,1.84771,-3.03902),(-1.93391,1.89192,-3.12897),(-1.87488,1.90805,-3.11463),(-1.77669,1.91588,-2.83604),(-1.74018,1.92934,-2.85171),(-2.43394,1.7718,-1.82478),(-2.42902,1.74754,-1.79899),(-2.50929,1.87417,-1.74034),(-1.93747,2.01016,-2.59923),(-1.9077,1.99614,-2.55523),(-2.04835,2.01221,-2.50994),(-2.26503,1.54955,-2.02842),(-2.29248,1.52893,-1.95101),(-2.33077,1.65373,-1.91466),(-2.34459,1.8862,-2.18735),(-2.28274,1.93462,-2.2761),(-2.33161,1.86121,-2.20849),(-2.3015,1.95855,-2.26409),(-2.20821,2.01663,-2.39713),(-2.18743,1.99711,-2.3937),(-1.95019,2.49753,-3.01645),(-1.95361,2.38019,-3.10414),(-1.98802,2.38857,-3.11466),(-1.9249,2.48246,-3.00755),(-1.84454,2.65898,-2.48736),(-1.82664,2.63436,-2.37772),(-1.81631,2.59703,-2.37178),(-1.68598,2.23881,-1.91727),(-1.72023,2.30232,-1.83479),(-1.68922,2.20115,-1.90654),(-1.72199,2.26982,-1.81185),(-1.84981,2.63913,-2.62586),(-1.86065,2.67879,-2.63302),(-1.84672,2.61848,-2.49524),(-1.77469,2.09099,-2.35194),(-1.80344,2.21294,-2.45738),(-1.79286,2.12697,-2.32844),(-1.76984,2.00856,-2.26231),(-1.7742,2.04869,-2.2392),(-1.78148,1.92753,-2.06134),(-1.7688,1.87973,-2.08114),(-1.77106,1.90171,-1.86978),(-1.74821,1.95973,-1.77666),(-1.73115,1.91622,-1.75501),(-1.74644,1.85891,-1.8628),(-2.31203,2.01351,-2.33599),(-2.23288,1.53685,-2.04849),(-2.16761,1.57613,-2.0587),(-2.16194,1.56347,-2.04181),(-1.84588,1.61471,-2.1595),(-1.81871,1.61632,-2.14981),(-1.94025,1.55822,-2.08176),(-1.9512,1.57211,-2.10199),(-1.77308,1.69085,-2.21975),(-1.75573,1.67576,-2.17073),(-2.63326,2.09261,-1.51117),(-2.61543,2.01448,-1.52738),(-2.61828,2.01308,-1.49785),(-2.17501,1.82751,-2.42061),(-2.30272,1.78115,-2.29914),(-1.70342,1.75797,-1.89707),(-1.7352,1.80217,-2.12083),(-1.71141,1.78766,-1.90042),(-1.73449,1.76711,-2.12651),(-2.02362,1.85664,-2.46051),(-2.03696,1.88491,-2.47652),(-1.87805,1.94181,-2.47484),(-1.8765,1.91224,-2.4514),(-2.60898,2.1716,-1.3815),(-2.61351,2.13181,-1.44883),(-2.56394,2.1045,-1.32143),(-2.60904,2.02828,-1.42444),(-2.52545,1.80913,-1.62167),(-2.53848,1.97797,-1.71648),(-2.5859,1.91409,-1.57421),(-2.46735,2.31762,-1.26346),(-2.45651,2.22572,-1.20712),(-2.41295,2.266,-1.19452),(-3.23456,2.22006,-2.63851),(-3.26933,2.19991,-2.56164),(-1.74717,1.9371,-3.04755),(-1.82298,1.91538,-3.09791),(-1.74315,1.93652,-2.30574),(-1.80051,1.9707,-2.59994),(-1.7235,2.11905,-2.51019),(-1.74972,2.03896,-2.39029),(-2.71757,2.16161,-2.10336),(-2.88823,2.24443,-2.11563),(-3.10333,2.28063,-2.25389),(-3.1115,2.21412,-2.28743),(-3.00177,2.12355,-2.20942),(-1.70495,2.11017,-2.64408),(-1.72904,2.1831,-2.65011),(-1.72698,2.17386,-2.603),(-1.85671,2.00135,-2.66956),(-1.77905,1.9749,-2.71505),(-1.9262,1.96023,-2.82094),(-2.22775,1.66474,-2.19069),(-2.27907,1.65963,-2.17431),(-2.00814,1.82735,-2.42086),(-1.78688,1.93984,-2.49522),(-1.77413,1.95973,-2.4753),(-1.82108,1.93251,-2.44689),(-1.95455,1.61483,-2.14818),(-2.07072,1.60373,-2.11142),(-2.06776,1.56834,-2.07508),(-1.74431,1.66361,-2.0781),(-2.07126,2.05442,-1.16666),(-2.17888,2.24969,-1.14195),(-2.24348,2.21951,-1.12226),(-2.04219,2.1023,-1.20199),(-2.59352,1.89761,-1.50041),(-2.53705,1.9216,-1.392),(-2.26249,1.50103,-1.94826),(-2.14851,1.49229,-1.85326),(-2.23255,1.51439,-1.87777),(-2.13623,1.50853,-1.92915),(-2.2792,1.65136,-1.41537),(-2.28286,1.83466,-1.24401),(-2.36379,1.80368,-1.31554),(-2.15324,1.69465,-1.34845),(-2.03317,1.50419,-1.94345),(-1.91876,1.50988,-2.0018),(-2.02951,1.47451,-1.84704),(-1.89412,1.50009,-1.85793),(-1.91124,1.50382,-1.691),(-1.93852,1.60897,-1.47802),(-2.08712,1.5596,-1.48634),(-2.04054,1.4935,-1.67452),(-2.04745,1.72393,-1.3158),(-2.14311,1.96399,-1.16337),(-2.19867,1.90475,-1.19601),(-1.95292,1.77667,-1.31016),(-1.85102,1.87168,-1.30375),(-2.67012,1.90792,-2.33384),(-2.79592,1.91609,-2.30491),(-2.86029,1.81145,-2.36263),(-2.69228,1.828,-2.42973),(-2.78373,2.23632,-2.03617),(-2.45896,2.04762,-2.18864),(-2.58729,2.09366,-2.14789),(-2.37821,1.5932,-1.83498),(-2.62548,2.18644,-1.7961),(-2.57678,2.09645,-1.71274),(-2.60243,2.15671,-1.65135),(-2.52826,2.07156,-2.00665),(-2.52609,2.05087,-1.98062),(-2.60003,2.13459,-1.89112),(-2.30858,1.79772,-2.04831),(-2.41487,1.9646,-2.09525),(-2.42043,1.87106,-1.96455),(-2.42042,1.66262,-1.75788),(-2.47395,1.71858,-1.67395),(-2.43744,1.60579,-1.70487),(-2.33491,1.69299,-1.93394),(-2.40915,2.00267,-2.14429),(-1.93081,1.97418,-2.51083),(-2.00059,1.94098,-2.49162),(-2.05019,1.99235,-2.48287),(-2.32242,2.01153,-2.40601),(-2.21871,2.03481,-2.47225),(-2.04295,2.02649,-2.65196),(-2.15181,1.91714,-2.40582),(-2.62941,2.18928,-1.50059),(-2.63792,2.24456,-1.60955),(-2.67895,2.22821,-1.95669),(-2.72078,2.35265,-1.91523),(-2.64593,2.2977,-1.77052),(-2.48015,2.36628,-1.53327),(-2.56504,2.30953,-1.40616),(-2.48208,2.35155,-1.38049),(-2.57542,2.37111,-1.54808),(-2.55551,2.25223,-1.31795),(-2.51306,2.15191,-1.25309),(-2.39113,2.35323,-1.25426),(-2.47778,2.33929,-1.32556),(-2.25956,2.33393,-1.27149),(-2.3246,2.33127,-1.52384),(-2.2137,2.35549,-1.32911),(-2.11473,2.32825,-1.5192),(-2.20761,2.33964,-1.52028),(-1.77776,2.43617,-1.81113),(-1.79485,2.51416,-1.87144),(-1.80666,2.53871,-1.85081),(-1.96955,2.49795,-1.80391),(-2.01002,2.39024,-1.67666),(-1.90754,2.40537,-1.71043),(-2.21711,2.54465,-1.84892),(-2.19276,2.48059,-1.78779),(-1.75107,2.18546,-1.76379),(-1.7378,2.10859,-1.89226),(-1.73951,2.34222,-1.80791),(-1.75251,2.42175,-1.93739),(-1.8093,2.29848,-1.70472),(-2.12897,2.23313,-1.26363),(-2.00479,2.12385,-1.31473),(-1.96254,2.20369,-1.37636),(-2.08813,2.30165,-1.35015),(-1.90273,2.06284,-1.37217),(-1.68586,1.85806,-1.75004),(-1.76234,2.01455,-1.60218),(-1.71062,1.9328,-1.55211),(-1.72286,2.14427,-2.05293),(-1.67691,2.19777,-2.03319),(-1.76451,2.1183,-2.19938),(-1.78715,2.00654,-2.03902),(-2.93987,2.83567,-2.22875),(-3.05625,2.85658,-2.4702),(-3.05681,2.80902,-2.24445),(-2.94277,2.86683,-2.47394),(-2.92474,2.8024,-2.74663),(-3.03912,2.77029,-2.76724),(-3.05787,2.83345,-2.63163),(-2.93566,2.83698,-2.61353),(-2.84739,2.63438,-2.96794),(-2.82659,2.49558,-3.05674),(-2.95916,2.51124,-2.9892),(-1.80427,2.27727,-2.54101),(-1.81417,2.30367,-2.61992),(-1.84449,2.3982,-2.60095),(-1.86141,2.3664,-2.48562),(-1.86754,2.51109,-2.418),(-1.84984,2.42542,-2.31303),(-1.86564,2.3106,-2.38234),(-1.82454,2.56469,-2.39039),(-1.8637,2.53489,-2.54204),(-1.91532,2.66217,-2.79089),(-1.91896,2.74293,-2.66543),(-1.89256,2.72631,-2.65691),(-1.86911,2.56254,-2.81679),(-1.91446,2.61574,-2.84914),(-1.9184,2.45091,-3.00944),(-2.47481,2.089,-3.2759),(-2.44311,2.21592,-3.22614),(-2.40587,2.08004,-3.25531),(-2.84531,2.30708,-3.18403),(-2.95956,2.28857,-3.1142),(-2.46021,2.30682,-3.19217),(-2.64599,2.29047,-3.20835),(-1.90858,2.22187,-3.17489),(-1.9663,2.21604,-3.19705),(-1.96766,2.26555,-3.17607),(-1.76713,2.03279,-3.10297),(-1.82751,2.01909,-3.16051),(-3.04854,2.30076,-3.01994),(-2.9675,2.32496,-3.07225),(-3.25727,2.19029,-2.83182),(-3.30806,2.13071,-2.83358),(-3.40726,2.05892,-2.74469),(-3.36448,1.82145,-2.50582),(-3.40067,1.86059,-2.57733),(-2.73076,2.16251,-3.21232),(-2.84095,2.20485,-3.24651),(-2.67781,2.11979,-3.28962),(-2.79734,2.07072,-2.81884),(-2.95722,2.19365,-2.98524),(-2.65265,2.08946,-2.95692),(-2.81033,2.1739,-3.12754),(-2.5098,2.06155,-3.17135),(-2.57205,2.08359,-3.04676),(-2.31804,2.00572,-3.02434),(-2.40061,2.00929,-2.91982),(-2.50161,2.00985,-2.80749),(-2.65813,1.94807,-2.67163),(-2.55035,1.87559,-2.60246),(-2.52875,1.81877,-2.55618),(-2.68285,1.7826,-2.50645),(-2.29093,1.96504,-2.79831),(-2.41038,1.93747,-2.70621),(-2.04046,1.90713,-2.96246),(-2.1221,1.91399,-3.01484),(-1.98918,2.00567,-3.20669),(-2.04431,1.88848,-3.16605),(-2.06496,1.99972,-3.20657),(-3.1743,2.41607,-2.64233),(-3.1761,2.39099,-2.65324),(-3.18663,2.3769,-2.50753),(-3.18169,2.5393,-2.3757),(-3.1683,2.53456,-2.4837),(-3.07223,2.57853,-2.8848),(-3.13014,2.50021,-2.78534),(-3.15188,2.51283,-2.66526),(-3.16684,2.27444,-2.74703),(-3.11128,2.47553,-2.80919),(-3.08339,2.32565,-2.84732),(-3.01876,2.4004,-2.97211),(-2.9672,2.4283,-3.01615),(-3.14245,2.26012,-2.92855),(-3.04189,2.50505,-2.94124),(-3.05859,2.55492,-2.90793),(-3.29651,2.10638,-2.83878),(-3.39655,2.03652,-2.75353),(-3.15175,2.00624,-2.32159),(-3.24343,2.08992,-2.38642),(-2.93494,2.52675,-1.9859),(-3.02992,2.74012,-2.0551),(-3.0214,2.7139,-2.00569),(-2.92794,2.73245,-2.00052),(-3.16623,1.74351,-2.40196),(-3.27956,1.75392,-2.44714),(-2.7176,2.54762,-1.86968),(-2.81636,2.49699,-1.92338),(-3.41428,2.00633,-2.71738),(-3.412,1.92059,-2.6432),(-3.14335,2.70352,-2.32316),(-3.08172,2.83821,-2.46915),(-3.14192,2.7003,-2.46546),(-3.08336,2.78942,-2.25036),(-3.07932,2.54281,-2.02179),(-3.15885,2.52185,-2.57362),(-2.11211,1.87785,-3.16009),(-1.82663,1.8616,-2.95895),(-2.01971,1.8352,-3.07475),(-1.93771,1.87246,-2.95462),(-2.0151,1.95274,-2.81101),(-1.99634,1.89137,-2.9673),(-2.18863,1.96882,-2.90564),(-2.04509,1.94758,-2.83506),(-2.22478,1.91067,-2.67857),(-2.4985,2.04655,-3.26928),(-2.92781,1.72307,-2.43696),(-3.4294,2.02557,-2.69963),(-3.15189,2.19383,-2.92761),(-3.09576,2.14097,-2.88069),(-2.31969,2.38915,-3.14336),(-2.30215,2.30889,-3.1815),(-2.45357,2.36951,-3.14451),(-2.83947,2.34464,-3.13923),(-2.63754,2.35659,-3.16287),(-2.12442,2.30262,-3.20228),(-2.00188,2.21129,-3.20419),(-2.11541,2.21644,-3.22051),(-2.00414,2.26971,-3.18268),(-2.26794,2.20939,-3.1966),(-2.21895,2.08976,-3.19719),(-1.79232,2.29927,-2.717),(-1.7309,2.17953,-2.72348),(-2.40818,2.60377,-1.88758),(-2.82259,2.45464,-3.07084),(-2.64695,2.47071,-3.09348),(-1.87925,2.33705,-2.99432),(-1.8483,2.45285,-2.83022),(-1.8359,2.37273,-2.83196),(-1.86023,2.52192,-2.63909),(-1.92313,2.81211,-2.49812),(-1.85589,2.73489,-2.47829),(-1.83977,2.39371,-2.691),(-1.83485,2.21135,-2.27764),(-2.33773,2.63231,-2.91858),(-2.45566,2.63413,-2.93315),(-2.44807,2.77199,-2.69562),(-2.34448,2.77305,-2.71534),(-1.76445,1.99289,-1.89543),(-1.73703,2.19573,-2.14175),(-1.74706,2.01011,-1.79933),(-1.83744,1.98175,-1.3351),(-2.03667,2.12132,-1.22366),(-2.01217,2.31951,-1.53271),(-1.90498,2.24273,-1.53618),(-1.98242,2.54278,-1.82582),(-2.16987,2.26461,-1.16185),(-2.60808,2.56982,-1.83731),(-2.35088,2.32302,-1.17708),(-2.31743,2.34016,-1.18023),(-2.68506,2.563,-1.85543),(-2.62697,2.50299,-1.78362),(-2.63813,2.38065,-1.74356),(-2.72818,2.44944,-1.8434),(-2.65083,2.48321,-1.78696),(-2.60324,2.41664,-1.70244),(-2.61056,2.26334,-1.45836),(-2.29706,1.77452,-2.06779),(-2.3053,1.66832,-2.13905),(-2.47608,1.66181,-1.60944),(-2.52361,1.97148,-1.84),(-2.55114,2.03618,-1.7741),(-2.57271,2.06536,-1.68447),(-2.3149,1.68306,-1.97488),(-2.57575,2.114,-2.07039),(-2.31113,2.14424,-1.1447),(-1.81944,1.67567,-1.51317),(-1.70713,1.80505,-1.5238),(-2.36387,2.08786,-1.16054),(-2.15766,1.48935,-1.68449),(-2.2724,1.52272,-1.73014),(-2.35485,1.56765,-1.83414),(-2.53452,1.77106,-1.52248),(-2.43425,1.76156,-1.42379),(-1.79718,1.85005,-2.37622),(-1.79095,1.70111,-2.24026),(-1.81012,1.57462,-2.03317),(-1.85875,1.72852,-2.28497),(-1.96448,1.72511,-2.28639),(-1.8699,1.84155,-2.38706),(-2.65808,2.63107,-1.90815),(-2.22044,2.02826,-2.50691),(-2.2171,1.98848,-2.56029),(-2.69401,1.77647,-2.46662),(-2.5279,1.81578,-2.51892),(-1.6714,2.23157,-2.02172),(-1.71082,2.32754,-1.99123),(-3.27709,2.15622,-2.47766),(-1.83387,1.95884,-1.32623),(-2.41548,1.58624,-1.69113),(-2.59732,1.89876,-1.52628),(-2.54719,1.77633,-1.54899),(-1.76971,2.05626,-1.63379),(-1.89783,2.7791,-2.16982),(-1.87353,2.74114,-2.179),(-1.91789,2.80476,-2.39),(-1.9468,2.63214,-2.86504),(-1.71981,2.05903,-2.57936),(-2.92289,1.72621,-2.40691),(-2.20289,1.92164,-2.64318),(-2.31952,1.96289,-3.20077),(-3.08605,1.84121,-2.31441),(-3.2238,1.88649,-2.36116),(-3.23721,1.86441,-2.37773),(-1.8821,2.25515,-3.13791),(-3.37966,1.83791,-2.48113),(-3.28808,1.76757,-2.41372),(-3.08259,2.81604,-2.63258),(-2.5712,2.42585,-1.6852),(-1.86884,2.624,-1.88696),(-1.99847,2.59225,-1.86314),(-2.35684,2.4777,-1.78132),(-2.64214,2.1694,-2.00298),(-2.34032,1.99683,-2.43058),(-3.4202,1.87737,-2.55453),(-3.43597,1.93772,-2.62229),(-1.80247,2.20991,-2.99101),(-1.81441,2.13065,-3.12875),(-2.8568,2.22959,-3.24559),(-2.4823,2.06548,-3.27852),(-2.36474,2.01954,-3.23705),(-3.16834,1.75446,-2.35982),(-2.36025,1.87101,-2.56781),(-2.37509,1.86609,-2.60313),(-3.03588,2.23001,-3.03544),(-2.67189,2.14389,-3.29888),(-1.93664,2.01811,-3.19983),(-1.99775,2.09553,-3.22598),(-1.94521,2.09079,-3.21367),(-1.95242,2.7555,-2.67299),(-1.95798,2.83081,-2.50236),(-1.90974,2.71529,-2.0073),(-1.93009,2.79681,-2.16344),(-1.87927,2.69976,-2.01918),(-1.84123,2.61452,-1.90426),(-1.6825,2.2579,-2.10949),(-1.67603,2.28564,-2.08755),(-1.73489,2.39988,-2.16368),(-1.7838,2.48797,-2.27846),(-1.77384,2.51605,-2.25708),(-1.74649,2.37625,-2.18523),(-1.95169,2.82348,-2.39195),(-1.70326,1.90352,-1.54133),(-1.67691,1.83012,-1.74353),(-2.45864,1.65065,-1.58419),(-1.76389,2.09737,-1.67515),(-1.8154,2.56162,-1.92707),(-1.79259,2.5564,-2.07127),(-1.84953,2.65027,-2.03425),(-1.76511,2.46551,-1.97873),(-1.84669,2.71144,-2.37081),(-1.8176,2.64947,-2.20305),(-1.7615,2.47247,-2.12563),(-1.79182,2.56987,-2.23961),(-1.72286,2.37784,-2.03567),(-2.37346,1.93443,-2.48292),(-2.80775,2.36195,-1.99152),(-2.06375,1.55379,-2.05383),(-1.68952,1.70936,-1.71221),(-1.71013,1.67646,-1.88688),(-2.4203,2.03569,-1.20227),(-2.48376,1.99209,-1.27973),(-2.37253,1.63449,-1.50634),(-2.32031,1.55436,-1.6),(-2.21479,1.54768,-1.51955),(-1.78878,1.55944,-1.88627),(-1.78596,1.58929,-1.70375),(-2.51078,1.91624,-2.39917),(-2.62455,2.31496,-1.59394),(-2.51156,2.4215,-1.67154),(-2.20075,2.40174,-1.67642),(-2.3448,2.40154,-1.66536),(-2.05991,2.71739,-1.99709),(-2.29652,2.70136,-2.02211),(-2.43727,2.69725,-2.0181),(-2.68979,2.71097,-2.00215),(-2.10894,2.81452,-2.20965),(-2.33934,2.78744,-2.20907),(-2.46322,2.78021,-2.20582),(-2.7271,2.82214,-2.22336),(-2.12839,2.8458,-2.42271),(-2.34126,2.81942,-2.43336),(-2.47956,2.83335,-2.45264),(-2.70287,2.86258,-2.46532),(-2.34194,2.81071,-2.55254),(-2.1222,2.83942,-2.54637),(-2.69089,2.84363,-2.60032),(-2.46571,2.81755,-2.56333),(-2.12867,2.79238,-2.7016),(-2.67036,2.7918,-2.73827),(-2.12085,2.64976,-2.92725),(-2.66647,2.63981,-2.95636),(-2.1153,2.4978,-3.06487),(-2.33886,2.47381,-3.07753),(-2.46204,2.46142,-3.08483),(-1.79483,2.28666,-2.85173),(-1.8181,2.30575,-2.21911),(-1.70052,2.04405,-2.83384),(-1.74595,2.10165,-2.97611),(-1.74123,2.15962,-2.85923),(-1.71521,1.99072,-2.92764),(-1.70708,2.09164,-2.71844),(-2.18115,1.98459,-3.19255),(-2.08366,2.11717,-3.2272),(-1.86043,2.09893,-3.17239),(-2.11817,2.40248,-3.15496),(-2.80345,1.87896,-2.58167),(-2.9489,2.0089,-2.7205),(-3.13471,2.68449,-2.61909),(-3.00035,1.9457,-2.25934),(-2.93898,2.23444,-3.15957)]))),
        Shape(DEF='rcalc',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rcalc_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,22,23,20,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,30,33,31,-1,30,34,33,-1,35,36,37,-1,37,38,35,-1,39,40,41,-1,39,42,40,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,51,52,49,-1,53,54,55,-1,53,56,54,-1,57,45,58,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,65,68,66,-1,69,70,71,-1,72,73,74,-1,75,76,77,-1,78,79,80,-1,80,81,78,-1,82,83,84,-1,82,85,83,-1,86,69,87,-1,86,88,69,-1,89,90,91,-1,91,92,89,-1,75,93,94,-1,94,76,75,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,105,107,106,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,113,115,114,-1,116,117,118,-1,17,119,120,-1,120,121,17,-1,122,123,124,-1,125,15,16,-1,16,126,125,-1,127,128,129,-1,130,26,25,-1,131,132,133,-1,134,135,136,-1,134,137,135,-1,1,14,138,-1,1,139,14,-1,140,141,142,-1,141,143,142,-1,131,144,132,-1,144,145,132,-1,126,16,146,-1,16,147,146,-1,148,21,149,-1,21,150,149,-1,151,152,153,-1,154,155,156,-1,155,157,156,-1,158,159,160,-1,159,161,160,-1,116,38,162,-1,163,164,165,-1,61,60,166,-1,167,168,169,-1,167,170,168,-1,171,172,173,-1,99,174,100,-1,99,175,174,-1,176,177,178,-1,177,179,178,-1,180,181,182,-1,46,35,118,-1,46,33,35,-1,183,57,184,-1,183,185,57,-1,186,187,188,-1,189,190,191,-1,192,189,193,-1,194,84,195,-1,194,196,84,-1,197,198,187,-1,199,87,69,-1,199,200,87,-1,46,45,47,-1,46,58,45,-1,201,202,203,-1,204,102,205,-1,204,103,102,-1,206,207,208,-1,209,210,211,-1,212,213,214,-1,212,215,213,-1,24,216,23,-1,24,217,216,-1,110,218,107,-1,110,219,218,-1,220,221,222,-1,223,224,225,-1,223,226,224,-1,227,41,228,-1,227,39,41,-1,229,230,231,-1,229,232,230,-1,233,169,234,-1,233,235,169,-1,236,237,226,-1,236,238,237,-1,239,240,241,-1,242,243,244,-1,242,245,243,-1,246,247,248,-1,246,95,247,-1,249,250,251,-1,249,252,250,-1,253,246,250,-1,253,254,246,-1,255,256,257,-1,255,258,256,-1,259,260,261,-1,262,260,263,-1,95,246,254,-1,97,9,74,-1,97,7,9,-1,264,265,266,-1,266,267,264,-1,268,269,270,-1,268,271,269,-1,272,273,274,-1,274,275,272,-1,276,39,227,-1,276,277,39,-1,278,279,280,-1,278,281,279,-1,282,191,283,-1,282,189,191,-1,280,276,284,-1,284,285,280,-1,286,285,287,-1,287,288,286,-1,194,9,8,-1,8,196,194,-1,289,290,291,-1,291,292,289,-1,221,293,294,-1,221,295,293,-1,296,297,298,-1,297,299,298,-1,300,301,302,-1,300,86,301,-1,303,304,305,-1,303,306,304,-1,289,292,307,-1,195,308,309,-1,188,310,186,-1,188,292,310,-1,311,312,313,-1,313,314,311,-1,315,316,187,-1,317,100,318,-1,319,320,321,-1,319,206,320,-1,322,323,324,-1,325,174,178,-1,326,178,179,-1,159,158,327,-1,123,328,2,-1,328,329,2,-1,122,330,331,-1,330,332,333,-1,330,334,332,-1,124,2,335,-1,2,336,335,-1,337,338,339,-1,337,340,338,-1,341,342,343,-1,344,345,346,-1,345,347,346,-1,348,0,2,-1,2,329,348,-1,121,13,17,-1,349,350,351,-1,156,352,353,-1,354,355,356,-1,357,217,358,-1,358,359,357,-1,203,202,216,-1,202,360,216,-1,361,202,362,-1,202,201,362,-1,111,105,363,-1,105,364,363,-1,365,366,364,-1,366,367,364,-1,368,369,366,-1,368,370,369,-1,365,371,372,-1,365,104,371,-1,373,374,375,-1,373,180,374,-1,376,377,378,-1,379,52,376,-1,376,380,379,-1,381,382,383,-1,382,384,383,-1,385,263,386,-1,385,387,263,-1,49,52,379,-1,388,389,101,-1,388,390,389,-1,391,392,393,-1,391,394,392,-1,395,43,396,-1,397,398,399,-1,399,400,397,-1,401,402,362,-1,203,403,201,-1,403,404,201,-1,405,400,406,-1,405,397,400,-1,407,408,409,-1,410,411,412,-1,410,413,411,-1,28,414,415,-1,28,416,414,-1,417,418,419,-1,420,236,421,-1,420,422,236,-1,414,128,415,-1,27,423,28,-1,184,57,58,-1,133,424,425,-1,133,426,424,-1,45,44,47,-1,44,66,47,-1,424,426,427,-1,427,163,424,-1,428,429,430,-1,431,432,433,-1,431,434,432,-1,430,63,428,-1,430,434,63,-1,435,62,64,-1,435,165,62,-1,436,437,438,-1,439,172,440,-1,172,171,440,-1,441,442,443,-1,444,445,446,-1,445,447,446,-1,448,182,449,-1,448,450,182,-1,437,451,452,-1,453,454,455,-1,455,456,453,-1,456,457,458,-1,459,460,449,-1,459,461,460,-1,462,463,450,-1,450,448,462,-1,464,445,444,-1,444,106,464,-1,465,466,467,-1,442,172,439,-1,442,441,172,-1,173,468,171,-1,469,425,470,-1,469,398,425,-1,471,472,435,-1,472,165,435,-1,205,473,474,-1,205,113,473,-1,112,473,113,-1,112,475,473,-1,205,474,204,-1,476,63,434,-1,476,64,63,-1,165,472,424,-1,424,163,165,-1,477,478,479,-1,425,397,133,-1,425,398,397,-1,37,480,481,-1,37,482,480,-1,483,418,417,-1,483,484,418,-1,412,409,410,-1,485,486,408,-1,136,357,359,-1,136,487,357,-1,137,134,488,-1,134,489,488,-1,405,406,490,-1,406,135,490,-1,406,403,487,-1,406,400,403,-1,401,362,201,-1,201,404,401,-1,402,401,491,-1,401,492,491,-1,402,491,108,-1,185,493,494,-1,185,183,493,-1,391,395,396,-1,396,394,391,-1,494,495,61,-1,59,61,495,-1,495,496,59,-1,53,390,388,-1,388,497,53,-1,51,498,499,-1,51,50,498,-1,386,500,501,-1,386,263,500,-1,450,502,182,-1,450,503,502,-1,366,372,368,-1,366,365,372,-1,363,402,111,-1,402,108,111,-1,363,361,362,-1,362,402,363,-1,366,369,504,-1,504,367,366,-1,216,20,23,-1,216,360,20,-1,217,26,358,-1,217,24,26,-1,505,354,506,-1,354,356,506,-1,126,355,125,-1,126,356,355,-1,369,507,504,-1,20,360,507,-1,507,508,20,-1,350,349,509,-1,148,510,19,-1,19,511,148,-1,13,138,14,-1,13,121,138,-1,138,121,336,-1,336,2,138,-1,512,345,513,-1,512,514,345,-1,157,341,343,-1,155,370,515,-1,515,98,155,-1,340,516,238,-1,340,337,516,-1,517,419,328,-1,419,329,328,-1,333,331,330,-1,333,518,331,-1,124,123,2,-1,519,518,520,-1,519,521,518,-1,520,522,523,-1,520,524,522,-1,525,325,526,-1,525,318,325,-1,527,528,529,-1,529,530,527,-1,319,207,206,-1,319,531,207,-1,324,323,532,-1,176,175,375,-1,375,533,176,-1,534,535,536,-1,534,537,535,-1,534,309,307,-1,307,316,534,-1,73,312,538,-1,538,90,73,-1,539,9,194,-1,539,540,9,-1,309,289,307,-1,309,308,289,-1,541,542,543,-1,543,544,541,-1,298,545,546,-1,298,299,545,-1,220,295,221,-1,220,545,295,-1,547,310,292,-1,292,291,547,-1,196,271,268,-1,268,82,196,-1,270,548,274,-1,270,549,548,-1,287,285,550,-1,285,284,550,-1,85,82,268,-1,268,273,85,-1,551,493,552,-1,553,58,281,-1,553,184,58,-1,277,116,162,-1,162,39,277,-1,269,554,549,-1,549,270,269,-1,555,283,191,-1,555,556,283,-1,557,558,283,-1,283,556,557,-1,282,264,552,-1,282,559,264,-1,258,560,256,-1,258,561,560,-1,562,563,564,-1,564,565,562,-1,260,566,261,-1,260,262,566,-1,566,258,255,-1,92,567,249,-1,92,568,567,-1,567,240,259,-1,567,244,240,-1,167,527,170,-1,528,527,167,-1,569,215,212,-1,231,230,228,-1,230,227,228,-1,225,570,223,-1,225,571,570,-1,222,81,220,-1,222,78,81,-1,183,192,193,-1,193,493,183,-1,234,572,233,-1,565,564,96,-1,573,574,575,-1,575,88,573,-1,247,576,248,-1,577,319,321,-1,305,304,578,-1,253,562,565,-1,565,254,253,-1,37,579,482,-1,37,36,579,-1,580,581,87,-1,87,200,580,-1,94,582,583,-1,94,93,582,-1,307,292,188,-1,552,193,189,-1,189,282,552,-1,46,31,33,-1,46,48,31,-1,461,454,467,-1,175,178,174,-1,175,176,178,-1,179,584,326,-1,528,169,235,-1,528,167,169,-1,463,378,450,-1,340,585,338,-1,340,586,585,-1,424,472,425,-1,353,508,154,-1,154,156,353,-1,160,587,120,-1,120,588,160,-1,153,152,159,-1,159,327,153,-1,409,589,410,-1,140,142,590,-1,591,127,592,-1,591,128,127,-1,338,517,328,-1,328,593,338,-1,356,594,506,-1,356,595,594,-1,125,18,15,-1,125,130,18,-1,596,579,143,-1,143,141,596,-1,29,480,482,-1,482,27,29,-1,126,146,595,-1,595,356,126,-1,597,590,598,-1,135,137,490,-1,415,29,28,-1,599,127,129,-1,1,138,2,-1,348,418,11,-1,373,98,515,-1,515,370,373,-1,373,99,98,-1,112,114,600,-1,600,601,112,-1,110,107,111,-1,107,105,111,-1,602,381,443,-1,381,603,443,-1,438,437,452,-1,460,448,449,-1,155,154,369,-1,369,370,155,-1,69,88,575,-1,575,70,69,-1,245,543,542,-1,542,604,245,-1,604,542,70,-1,70,575,604,-1,78,75,79,-1,78,93,75,-1,605,296,298,-1,605,214,296,-1,82,84,196,-1,211,91,209,-1,163,428,164,-1,163,477,428,-1,60,59,394,-1,59,392,394,-1,60,394,396,-1,396,166,60,-1,606,388,101,-1,43,45,396,-1,57,185,166,-1,376,51,377,-1,376,52,51,-1,434,430,432,-1,164,62,165,-1,41,40,607,-1,607,608,41,-1,35,34,36,-1,35,33,34,-1,422,586,340,-1,590,597,140,-1,193,552,493,-1,20,150,21,-1,20,508,150,-1,609,610,351,-1,609,611,610,-1,17,15,18,-1,17,13,15,-1,14,147,16,-1,14,139,147,-1,124,330,122,-1,559,265,264,-1,5,4,597,-1,595,413,594,-1,595,411,413,-1,146,12,612,-1,147,12,146,-1,0,139,1,-1,0,10,139,-1,613,557,614,-1,613,558,557,-1,615,616,617,-1,615,618,616,-1,8,619,620,-1,8,7,619,-1,610,119,510,-1,611,119,610,-1,350,609,351,-1,514,609,350,-1,150,353,509,-1,508,353,150,-1,481,39,162,-1,39,481,42,-1,608,621,420,-1,608,607,621,-1,430,393,432,-1,430,429,393,-1,43,622,44,-1,43,395,622,-1,163,478,477,-1,163,427,478,-1,497,606,431,-1,497,388,606,-1,57,396,45,-1,166,396,57,-1,63,164,428,-1,164,63,62,-1,605,546,623,-1,605,298,546,-1,624,291,290,-1,624,625,291,-1,547,76,94,-1,626,76,547,-1,627,301,581,-1,213,301,627,-1,74,95,97,-1,247,95,74,-1,628,245,242,-1,245,628,543,-1,576,74,73,-1,247,74,576,-1,372,444,446,-1,372,371,444,-1,448,466,462,-1,448,460,466,-1,383,603,381,-1,383,465,603,-1,602,442,389,-1,602,443,442,-1,629,113,205,-1,629,115,113,-1,370,630,373,-1,630,370,368,-1,440,205,102,-1,629,205,440,-1,631,632,11,-1,632,631,407,-1,358,505,359,-1,354,505,358,-1,598,5,597,-1,598,488,5,-1,506,3,489,-1,506,594,3,-1,585,517,338,-1,633,517,585,-1,415,591,634,-1,591,415,128,-1,482,596,27,-1,596,482,579,-1,26,125,355,-1,26,130,125,-1,592,599,635,-1,127,599,592,-1,29,634,480,-1,29,415,634,-1,413,589,6,-1,413,410,589,-1,611,120,119,-1,120,611,588,-1,514,636,609,-1,514,512,636,-1,346,637,638,-1,637,346,342,-1,639,344,640,-1,639,641,344,-1,161,152,642,-1,159,152,161,-1,349,610,149,-1,349,351,610,-1,637,341,317,-1,637,342,341,-1,608,228,41,-1,643,228,608,-1,585,621,635,-1,586,621,585,-1,378,384,376,-1,378,463,384,-1,326,325,178,-1,326,526,325,-1,456,644,453,-1,456,458,644,-1,645,468,173,-1,645,646,468,-1,318,637,317,-1,318,525,637,-1,182,447,449,-1,181,447,182,-1,455,461,459,-1,461,455,454,-1,95,565,96,-1,254,565,95,-1,647,578,304,-1,199,578,647,-1,198,315,187,-1,198,648,315,-1,335,587,649,-1,336,587,335,-1,650,502,503,-1,577,502,650,-1,251,576,89,-1,251,248,576,-1,574,170,651,-1,168,170,574,-1,271,8,620,-1,196,8,271,-1,252,567,652,-1,567,252,249,-1,313,73,72,-1,73,313,312,-1,210,538,653,-1,538,210,209,-1,654,234,655,-1,234,654,572,-1,357,403,203,-1,487,403,357,-1,241,651,170,-1,651,241,243,-1,605,212,214,-1,656,212,605,-1,421,570,643,-1,223,570,421,-1,657,225,656,-1,657,571,225,-1,80,657,623,-1,658,657,80,-1,229,570,571,-1,570,229,231,-1,79,658,80,-1,79,659,658,-1,302,654,300,-1,302,660,654,-1,660,572,654,-1,661,572,660,-1,662,663,516,-1,662,233,663,-1,569,661,660,-1,664,661,569,-1,237,516,663,-1,238,516,237,-1,212,664,569,-1,224,664,212,-1,575,651,604,-1,574,651,575,-1,604,243,245,-1,604,651,243,-1,259,239,260,-1,259,240,239,-1,244,568,242,-1,567,568,244,-1,652,566,255,-1,652,261,566,-1,560,562,256,-1,560,563,562,-1,266,258,566,-1,266,561,258,-1,617,563,615,-1,563,617,564,-1,613,560,561,-1,613,614,560,-1,552,665,551,-1,552,264,665,-1,283,559,282,-1,283,558,559,-1,557,554,618,-1,554,557,556,-1,269,620,616,-1,271,620,269,-1,556,549,554,-1,549,556,555,-1,58,279,281,-1,279,58,117,-1,183,553,192,-1,553,183,184,-1,222,294,582,-1,294,222,221,-1,547,583,310,-1,547,94,583,-1,75,659,79,-1,75,666,659,-1,667,77,668,-1,77,667,669,-1,670,668,671,-1,668,670,667,-1,624,671,625,-1,624,272,671,-1,273,270,274,-1,273,268,270,-1,672,192,553,-1,673,192,672,-1,286,672,278,-1,674,672,286,-1,675,190,673,-1,676,190,675,-1,230,550,284,-1,550,230,232,-1,675,677,678,-1,675,674,677,-1,555,548,549,-1,555,676,548,-1,669,550,666,-1,669,287,550,-1,677,667,670,-1,677,288,667,-1,548,275,274,-1,548,678,275,-1,83,195,84,-1,83,308,195,-1,679,295,680,-1,293,295,679,-1,681,310,583,-1,681,186,310,-1,295,299,680,-1,545,299,295,-1,682,581,580,-1,682,627,581,-1,655,574,573,-1,574,655,168,-1,541,70,542,-1,70,541,71,-1,543,683,544,-1,683,543,628,-1,540,74,9,-1,540,72,74,-1,72,684,313,-1,684,72,540,-1,539,534,536,-1,534,539,309,-1,683,653,685,-1,683,210,653,-1,684,535,686,-1,536,535,684,-1,534,315,537,-1,316,315,534,-1,687,199,647,-1,200,199,687,-1,688,580,689,-1,688,682,580,-1,680,297,690,-1,680,299,297,-1,647,691,687,-1,691,647,692,-1,693,689,694,-1,693,688,689,-1,679,690,695,-1,679,680,690,-1,306,696,692,-1,696,306,697,-1,694,698,699,-1,694,691,698,-1,693,648,695,-1,648,693,700,-1,685,311,697,-1,311,685,653,-1,314,698,696,-1,686,698,314,-1,537,699,535,-1,537,700,699,-1,533,320,701,-1,320,533,321,-1,650,702,531,-1,650,703,702,-1,207,528,208,-1,528,207,529,-1,531,529,207,-1,531,702,529,-1,702,530,529,-1,530,702,323,-1,322,530,323,-1,704,530,322,-1,318,174,325,-1,318,100,174,-1,332,705,706,-1,707,705,332,-1,708,638,709,-1,708,640,638,-1,707,639,705,-1,710,639,707,-1,701,711,712,-1,320,711,701,-1,709,713,708,-1,713,709,714,-1,713,524,706,-1,713,522,524,-1,523,519,520,-1,715,519,523,-1,716,712,711,-1,716,717,712,-1,649,334,335,-1,718,334,649,-1,334,707,332,-1,707,334,718,-1,524,518,333,-1,520,518,524,-1,519,719,521,-1,717,719,519,-1,662,716,720,-1,662,721,716,-1,719,337,339,-1,721,337,719,-1,593,331,722,-1,593,122,331,-1,338,722,339,-1,593,722,338,-1,375,99,373,-1,99,375,175,-1,352,157,343,-1,352,156,157,-1,343,350,352,-1,350,343,347,-1,513,327,512,-1,327,513,153,-1,512,158,636,-1,512,327,158,-1,336,120,587,-1,336,121,120,-1,348,10,0,-1,11,10,348,-1,507,154,508,-1,369,154,507,-1,504,360,202,-1,504,507,360,-1,511,21,148,-1,22,21,511,-1,361,364,367,-1,361,363,364,-1,446,181,630,-1,447,181,446,-1,503,703,650,-1,723,703,503,-1,324,724,499,-1,532,724,324,-1,723,450,378,-1,723,503,450,-1,55,382,725,-1,55,380,382,-1,704,500,726,-1,501,500,704,-1,704,498,501,-1,498,704,322,-1,50,385,386,-1,49,385,50,-1,322,499,498,-1,499,322,324,-1,725,389,390,-1,725,602,389,-1,497,56,53,-1,497,727,56,-1,496,54,56,-1,496,728,54,-1,495,728,496,-1,495,729,728,-1,493,495,494,-1,493,551,495,-1,61,185,494,-1,61,166,185,-1,399,401,404,-1,492,401,399,-1,492,730,491,-1,492,469,730,-1,137,598,490,-1,137,488,598,-1,487,135,406,-1,487,136,135,-1,632,411,612,-1,632,412,411,-1,11,484,631,-1,11,418,484,-1,485,407,631,-1,485,408,407,-1,486,28,423,-1,486,416,28,-1,731,423,732,-1,731,486,423,-1,589,731,733,-1,589,409,731,-1,734,4,733,-1,4,734,597,-1,735,484,483,-1,735,736,484,-1,483,129,735,-1,483,599,129,-1,592,40,591,-1,592,607,40,-1,732,27,596,-1,27,732,423,-1,734,596,141,-1,734,732,596,-1,141,597,734,-1,140,597,141,-1,397,131,133,-1,397,405,131,-1,143,36,34,-1,143,579,36,-1,145,30,32,-1,145,142,30,-1,737,68,65,-1,32,68,737,-1,478,622,479,-1,478,67,622,-1,103,606,101,-1,103,476,606,-1,64,103,204,-1,103,64,476,-1,730,112,601,-1,475,112,730,-1,115,451,114,-1,115,646,451,-1,425,471,470,-1,425,472,471,-1,204,435,64,-1,474,435,204,-1,473,470,471,-1,475,470,473,-1,600,438,109,-1,438,600,436,-1,646,452,451,-1,646,645,452,-1,465,738,603,-1,467,738,465,-1,464,107,218,-1,107,464,106,-1,467,453,738,-1,453,467,454,-1,644,172,441,-1,173,172,644,-1,645,457,452,-1,645,458,457,-1,455,218,456,-1,218,455,464,-1,219,452,457,-1,438,452,219,-1,457,218,219,-1,457,456,218,-1,464,459,445,-1,464,455,459,-1,441,453,644,-1,441,738,453,-1,109,219,110,-1,438,219,109,-1,449,445,459,-1,449,447,445,-1,443,738,441,-1,603,738,443,-1,451,600,114,-1,437,600,451,-1,600,437,436,-1,469,475,730,-1,469,470,475,-1,471,474,473,-1,471,435,474,-1,434,606,476,-1,606,434,431,-1,392,432,393,-1,433,432,392,-1,426,65,427,-1,426,737,65,-1,44,67,66,-1,67,44,622,-1,32,48,68,-1,48,32,31,-1,133,737,426,-1,737,133,132,-1,32,132,145,-1,737,132,32,-1,142,34,30,-1,142,143,34,-1,131,490,144,-1,131,405,490,-1,598,144,490,-1,590,144,598,-1,58,118,117,-1,46,118,58,-1,279,116,277,-1,117,116,279,-1,480,42,481,-1,480,634,42,-1,42,591,40,-1,591,42,634,-1,607,635,621,-1,592,635,607,-1,340,236,422,-1,340,238,236,-1,599,417,633,-1,417,599,483,-1,735,128,414,-1,129,128,735,-1,736,414,416,-1,414,736,735,-1,733,6,589,-1,6,733,4,-1,733,732,734,-1,733,731,732,-1,409,486,731,-1,409,408,486,-1,416,485,736,-1,486,485,416,-1,736,631,484,-1,631,736,485,-1,612,11,632,-1,11,612,12,-1,469,399,398,-1,492,399,469,-1,400,404,403,-1,399,404,400,-1,551,729,495,-1,551,665,729,-1,56,59,496,-1,56,727,59,-1,725,53,55,-1,725,390,53,-1,728,379,54,-1,728,49,379,-1,49,729,385,-1,728,729,49,-1,50,501,498,-1,50,386,501,-1,385,665,387,-1,729,665,385,-1,380,54,379,-1,54,380,55,-1,381,725,382,-1,725,381,602,-1,382,376,384,-1,382,380,376,-1,377,499,724,-1,51,499,377,-1,462,384,463,-1,384,462,383,-1,724,378,377,-1,723,378,724,-1,723,532,703,-1,723,724,532,-1,182,374,180,-1,182,502,374,-1,374,577,321,-1,502,577,374,-1,364,104,365,-1,105,104,364,-1,367,202,361,-1,367,504,202,-1,419,348,329,-1,348,419,418,-1,641,153,513,-1,151,153,641,-1,344,513,345,-1,641,513,344,-1,347,514,350,-1,347,345,514,-1,342,347,343,-1,347,342,346,-1,633,419,517,-1,633,417,419,-1,330,335,334,-1,124,335,330,-1,722,518,521,-1,722,331,518,-1,516,721,662,-1,516,337,721,-1,339,521,719,-1,339,722,521,-1,721,717,716,-1,721,719,717,-1,333,706,524,-1,333,332,706,-1,718,710,707,-1,718,642,710,-1,649,642,718,-1,161,642,649,-1,720,711,208,-1,720,716,711,-1,717,715,712,-1,717,519,715,-1,706,708,713,-1,706,705,708,-1,179,715,523,-1,715,179,177,-1,177,712,715,-1,701,712,177,-1,705,640,708,-1,639,640,705,-1,525,638,637,-1,709,638,525,-1,714,525,526,-1,709,525,714,-1,714,522,713,-1,714,584,522,-1,704,527,530,-1,726,527,704,-1,702,532,323,-1,702,703,532,-1,320,208,711,-1,208,320,206,-1,650,319,577,-1,531,319,650,-1,176,701,177,-1,176,533,701,-1,584,523,522,-1,584,179,523,-1,648,537,315,-1,648,700,537,-1,686,699,698,-1,535,699,686,-1,697,314,696,-1,314,697,311,-1,198,695,648,-1,198,679,695,-1,699,693,694,-1,700,693,699,-1,691,696,698,-1,691,692,696,-1,303,697,306,-1,697,303,685,-1,688,695,690,-1,695,688,693,-1,687,694,689,-1,694,687,691,-1,304,692,647,-1,692,304,306,-1,682,690,297,-1,690,682,688,-1,200,689,580,-1,689,200,687,-1,199,71,578,-1,199,69,71,-1,686,313,684,-1,686,314,313,-1,311,538,312,-1,311,653,538,-1,685,544,683,-1,685,303,544,-1,540,536,684,-1,536,540,539,-1,628,210,683,-1,210,628,211,-1,303,541,544,-1,303,305,541,-1,541,578,71,-1,305,578,541,-1,86,573,88,-1,573,86,300,-1,213,302,301,-1,213,215,302,-1,627,297,296,-1,627,682,297,-1,197,294,293,-1,294,197,681,-1,198,293,679,-1,293,198,197,-1,290,308,83,-1,289,308,290,-1,670,678,677,-1,275,678,670,-1,288,669,667,-1,288,287,669,-1,232,666,550,-1,666,232,659,-1,678,676,675,-1,548,676,678,-1,674,288,677,-1,674,286,288,-1,191,676,555,-1,191,190,676,-1,673,674,675,-1,673,672,674,-1,278,285,286,-1,278,280,285,-1,284,227,230,-1,284,276,227,-1,673,189,192,-1,190,189,673,-1,278,553,281,-1,672,553,278,-1,280,277,276,-1,280,279,277,-1,273,624,85,-1,273,272,624,-1,275,671,272,-1,671,275,670,-1,668,625,671,-1,626,625,668,-1,77,626,668,-1,626,77,76,-1,666,77,669,-1,77,666,75,-1,582,78,222,-1,582,93,78,-1,294,583,582,-1,681,583,294,-1,616,554,269,-1,616,618,554,-1,267,665,264,-1,665,267,387,-1,561,265,613,-1,266,265,561,-1,560,615,563,-1,560,614,615,-1,619,564,617,-1,564,619,96,-1,566,267,266,-1,262,267,566,-1,387,262,263,-1,267,262,387,-1,259,652,567,-1,259,261,652,-1,253,256,562,-1,257,256,253,-1,257,250,252,-1,257,253,250,-1,260,500,263,-1,260,239,500,-1,252,255,257,-1,252,652,255,-1,240,243,241,-1,244,243,240,-1,500,241,726,-1,239,241,500,-1,224,237,664,-1,226,237,224,-1,664,663,661,-1,237,663,664,-1,215,660,302,-1,569,660,215,-1,661,233,572,-1,663,233,661,-1,233,720,235,-1,662,720,233,-1,169,655,234,-1,169,168,655,-1,208,235,720,-1,528,235,208,-1,229,659,232,-1,658,659,229,-1,643,231,228,-1,570,231,643,-1,658,571,657,-1,229,571,658,-1,656,623,657,-1,623,656,605,-1,223,236,226,-1,421,236,223,-1,656,224,212,-1,225,224,656,-1,170,726,241,-1,170,527,726,-1,489,505,506,-1,489,134,505,-1,217,203,216,-1,217,357,203,-1,130,22,511,-1,130,25,22,-1,655,300,654,-1,655,573,300,-1,538,91,90,-1,538,209,91,-1,250,248,251,-1,246,248,250,-1,7,96,619,-1,7,97,96,-1,249,89,92,-1,249,251,89,-1,160,649,587,-1,160,161,649,-1,220,546,545,-1,220,81,546,-1,466,461,467,-1,466,460,461,-1,491,601,108,-1,491,730,601,-1,539,195,309,-1,195,539,194,-1,197,186,681,-1,186,197,187,-1,188,316,307,-1,188,187,316,-1,171,629,440,-1,171,468,629,-1,630,180,373,-1,630,181,180,-1,321,375,374,-1,321,533,375,-1,317,98,100,-1,155,98,317,-1,526,584,714,-1,584,526,326,-1,646,629,468,-1,646,115,629,-1,458,173,644,-1,458,645,173,-1,479,428,477,-1,479,429,428,-1,420,643,608,-1,421,643,420,-1,118,38,116,-1,118,35,38,-1,160,636,158,-1,588,636,160,-1,609,588,611,-1,609,636,588,-1,642,151,710,-1,642,152,151,-1,710,641,639,-1,710,151,641,-1,640,346,638,-1,640,344,346,-1,341,155,317,-1,155,341,157,-1,509,149,150,-1,149,509,349,-1,149,510,148,-1,149,610,510,-1,144,142,145,-1,144,590,142,-1,635,633,585,-1,599,633,635,-1,328,122,593,-1,328,123,122,-1,359,134,136,-1,505,134,359,-1,3,488,489,-1,488,3,5,-1,355,358,26,-1,355,354,358,-1,511,18,130,-1,19,18,511,-1,412,407,409,-1,407,412,632,-1,108,600,109,-1,600,108,601,-1,101,440,102,-1,101,439,440,-1,101,442,439,-1,101,389,442,-1,462,465,383,-1,462,466,465,-1,446,368,372,-1,368,446,630,-1,371,106,444,-1,371,104,106,-1,91,568,92,-1,91,211,568,-1,73,89,576,-1,73,90,89,-1,242,211,628,-1,242,568,211,-1,86,581,301,-1,86,87,581,-1,296,213,627,-1,214,213,296,-1,625,547,291,-1,625,626,547,-1,85,290,83,-1,85,624,290,-1,623,81,80,-1,546,81,623,-1,59,433,392,-1,727,433,59,-1,47,68,48,-1,68,47,66,-1,67,427,65,-1,67,478,427,-1,433,497,431,-1,727,497,433,-1,429,391,393,-1,479,391,429,-1,395,479,622,-1,395,391,479,-1,586,420,621,-1,586,422,420,-1,162,37,481,-1,162,38,37,-1,25,23,22,-1,24,23,25,-1,509,352,350,-1,353,352,509,-1,510,17,19,-1,119,17,510,-1,620,617,616,-1,617,620,619,-1,618,614,557,-1,614,618,615,-1,265,558,613,-1,265,559,558,-1,10,147,139,-1,12,147,10,-1,595,612,411,-1,146,612,595,-1,413,3,594,-1,413,6,3,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rcalc_Coord',point=[(-2.09102,1.89711,-2.79458),(-2.07396,1.88827,-2.78853),(-1.98442,1.88319,-2.84942),(-2.8727,1.72273,-2.51747),(-3.02853,1.80011,-2.56592),(-3.03793,1.78553,-2.55444),(-2.86794,1.74036,-2.52682),(-3.28185,.51416,-3.97546),(-3.29905,.54913,-3.9918),(-3.20134,.54496,-4.04602),(-2.24724,1.88676,-2.72034),(-2.34165,1.91876,-2.76841),(-2.34207,1.87973,-2.69229),(-2.12896,1.86211,-2.62675),(-2.22731,1.86357,-2.69545),(-2.2334,1.81984,-2.61341),(-2.32176,1.85057,-2.67306),(-2.12244,1.86631,-2.60707),(-2.22576,1.81674,-2.59158),(-2.20959,1.8222,-2.55625),(-2.37994,1.74502,-2.30706),(-2.33419,1.78278,-2.37724),(-2.3594,1.75029,-2.44424),(-2.4215,1.7236,-2.38475),(-2.46049,1.69812,-2.48304),(-2.39495,1.73174,-2.52977),(-2.48683,1.70543,-2.54181),(-3.07244,2.1696,-3.03469),(-2.92021,2.18362,-3.16891),(-2.95696,2.19014,-3.18836),(-3.36076,1.78618,-2.72795),(-3.36756,1.76997,-2.74006),(-3.38205,1.68438,-2.614),(-3.34452,1.86566,-2.84289),(-3.34161,1.87981,-2.82752),(-3.24586,2.04302,-3.01753),(-3.24636,2.05782,-3.00207),(-3.11939,2.14616,-3.09079),(-3.11215,2.13254,-3.12765),(-2.89371,2.11002,-3.33146),(-2.69367,2.06869,-3.43125),(-2.70441,2.05578,-3.44622),(-2.88329,2.12468,-3.32067),(-3.49473,1.47761,-2.69448),(-3.49102,1.50705,-2.68811),(-3.44914,1.59303,-2.84124),(-3.33172,1.85222,-2.96346),(-3.41039,1.67223,-2.79639),(-3.39207,1.71156,-2.77358),(-3.10825,.86293,-2.32149),(-2.99521,.80222,-2.30127),(-2.96777,.8334,-2.16214),(-3.06625,.87108,-2.15573),(-3.2929,1.09747,-2.0445),(-3.19736,.97661,-2.1583),(-3.20545,.97673,-2.03119),(-3.30451,1.09191,-2.16375),(-3.44041,1.54661,-2.8758),(-3.31871,1.83934,-3.07636),(-3.39789,1.18235,-2.34381),(-3.41972,1.27958,-2.55046),(-3.3941,1.19911,-2.59392),(-3.40161,1.37941,-2.14649),(-3.40186,1.35864,-2.13977),(-3.37558,1.42422,-1.94146),(-3.46507,1.53003,-2.49686),(-3.44201,1.57935,-2.66585),(-3.47264,1.49835,-2.50995),(-3.42316,1.61476,-2.64844),(-2.19469,.46692,-3.77759),(-2.28584,.45506,-3.48629),(-2.22684,.36532,-3.62421),(-3.02264,.37709,-3.96195),(-2.97704,.28169,-3.75105),(-3.12456,.41173,-3.91554),(-2.84957,1.88236,-4.09343),(-2.95667,1.79088,-4.11785),(-2.97539,1.8018,-4.07439),(-2.69991,1.88565,-4.09635),(-2.70428,1.89278,-4.08182),(-2.5519,1.84276,-4.05488),(-2.55184,1.83485,-4.06874),(-3.29992,.73911,-4.00523),(-3.25048,.89126,-4.13553),(-3.25861,.75719,-4.07111),(-3.27576,.9147,-4.08286),(-2.15467,.67402,-3.93913),(-2.15407,.65424,-3.96821),(-2.20027,.49683,-3.75621),(-2.93059,.28805,-3.61104),(-2.91923,.27143,-3.62495),(-2.86649,.25861,-3.53481),(-2.87688,.27671,-3.52758),(-2.84092,1.87118,-4.10982),(-2.94165,1.78865,-4.13532),(-3.17688,.43349,-3.8734),(-3.26371,.40599,-3.77563),(-3.19021,.43982,-3.88956),(-2.2048,1.5463,-2.09692),(-2.20679,1.52627,-2.10568),(-2.11054,1.50649,-2.09439),(-3.28163,1.23643,-1.75661),(-3.33154,1.35919,-1.74187),(-3.33848,1.35153,-1.77261),(-2.57324,1.63842,-1.75203),(-2.68736,1.71309,-1.72497),(-2.58362,1.61129,-1.73508),(-2.69227,1.70233,-1.71403),(-2.96025,1.92742,-1.68448),(-2.95535,1.90614,-1.65704),(-2.81655,1.79757,-1.69495),(-2.81316,1.80544,-1.70683),(-3.27219,1.86285,-1.74108),(-3.32828,1.68879,-1.73379),(-3.25095,1.8441,-1.70286),(-3.31635,1.68337,-1.72053),(-3.08694,2.11201,-3.20291),(-3.2155,2.02423,-3.17307),(-3.23156,2.02266,-3.08536),(-2.11738,1.88281,-2.55447),(-2.00307,1.90121,-2.62481),(-2.00918,1.8936,-2.67241),(-1.9613,1.83138,-2.90983),(-1.96232,1.8568,-2.90633),(-1.88494,1.86512,-2.87473),(-2.33795,1.77654,-2.60032),(-2.41621,1.83758,-2.65068),(-2.5557,2.0378,-3.367),(-2.68862,2.12056,-3.36598),(-2.55484,2.0446,-3.34109),(-2.32928,1.76532,-2.57649),(-3.3784,1.72784,-2.40695),(-3.39924,1.71341,-2.41796),(-3.39477,1.71486,-2.32776),(-2.90526,1.67136,-2.48072),(-3.0759,1.67393,-2.48612),(-2.90866,1.66164,-2.46156),(-3.0673,1.69004,-2.50461),(-2.06549,1.87805,-2.7857),(-2.24033,1.87475,-2.70604),(-3.31115,1.87102,-2.64307),(-3.28889,1.95338,-2.71978),(-3.34536,1.85582,-2.65851),(-3.32468,1.93641,-2.75797),(-3.32659,1.81288,-2.57101),(-3.35597,1.79933,-2.58341),(-2.42981,1.8575,-2.65325),(-2.33654,1.86554,-2.67846),(-2.2709,1.80069,-2.44711),(-2.25526,1.83849,-2.39269),(-2.30652,1.80636,-2.3059),(-1.71274,1.90803,-2.46171),(-1.74282,1.94428,-2.51303),(-1.78366,1.91751,-2.47058),(-2.27976,1.66915,-2.10138),(-2.19261,1.62334,-2.06207),(-2.26928,1.68523,-2.1019),(-2.18646,1.64467,-2.05839),(-1.86856,1.96726,-2.53722),(-1.80187,1.97579,-2.53699),(-1.88893,1.94962,-2.57919),(-1.7817,1.97397,-2.57768),(-3.03633,2.12677,-3.21015),(-3.46595,1.44937,-2.37904),(-3.45166,1.38403,-2.28628),(-3.41336,1.47301,-2.17249),(-3.42996,1.35638,-2.72397),(-2.55245,.79278,-2.95322),(-2.4345,.75503,-3.25446),(-2.45901,.85804,-3.10628),(-2.57796,.68209,-3.07625),(-3.26969,1.42309,-1.71005),(-3.25335,1.31616,-1.70541),(-3.18601,1.50165,-1.7146),(-2.1094,1.41062,-2.16105),(-2.19953,1.43401,-2.15467),(-2.15883,1.3538,-2.24012),(-2.13753,1.39336,-2.33095),(-2.08544,1.35515,-2.23975),(-2.06454,1.40886,-2.33499),(-2.43404,1.46148,-1.99733),(-2.45265,1.49425,-1.92457),(-2.50585,1.37476,-1.95497),(-3.45186,1.27272,-3.00027),(-3.40749,1.50586,-3.05263),(-3.44672,1.33687,-2.824),(-2.9662,1.47461,-4.22741),(-2.90514,1.34284,-4.28338),(-3.02739,1.345,-4.26124),(-3.42068,1.01411,-3.20251),(-3.37355,.9935,-3.34651),(-3.43806,.87297,-3.34383),(-3.39419,1.22804,-3.20772),(-3.42929,1.02471,-3.12314),(-3.20861,.66121,-4.08779),(-3.20323,.79167,-4.14909),(-3.30677,.63459,-4.0013),(-2.79827,1.4998,-4.23794),(-2.72282,1.33724,-4.29357),(-2.18918,.42184,-3.84309),(-2.17079,.61416,-4.01099),(-2.80492,1.69148,-2.19357),(-2.60926,1.66446,-2.15372),(-2.66531,1.63557,-2.30563),(-3.3522,1.51065,-1.7977),(-3.35887,1.59126,-1.73178),(-2.34966,1.16852,-2.44749),(-2.40896,1.1036,-2.49818),(-2.35219,1.20124,-2.69039),(-2.83973,.22432,-3.53823),(-2.78582,.1966,-3.55006),(-2.81441,.25669,-3.47353),(-2.31411,1.5109,-3.83324),(-2.20666,1.18832,-3.99558),(-2.25597,1.45063,-3.99484),(-2.24194,1.26974,-3.83507),(-2.55152,1.70033,-2.33841),(-2.58461,1.70576,-2.43373),(-2.74285,1.65985,-1.70607),(-2.88629,1.77449,-1.67306),(-2.57748,1.75859,-4.11889),(-2.59538,1.73518,-4.15766),(-2.66672,1.83494,-4.14184),(-2.43273,1.74314,-3.51493),(-2.3467,1.56079,-3.63451),(-2.41043,1.66567,-3.68605),(-2.32743,1.6413,-3.44708),(-2.82876,2.02944,-3.45185),(-2.68378,1.99217,-3.51116),(-2.62806,1.86741,-3.75193),(-2.78971,1.97313,-3.59322),(-2.66382,1.92643,-3.58696),(-2.77245,1.94053,-3.74972),(-2.35837,1.23786,-3.16174),(-2.38868,1.00805,-3.25358),(-2.40224,1.07996,-2.96568),(-2.31628,1.72147,-3.30411),(-2.29662,1.5003,-3.35694),(-2.2636,1.64349,-3.21155),(-2.83095,.5996,-3.01063),(-2.81291,.55087,-3.10843),(-2.68446,.60097,-3.06026),(-2.71524,.27694,-3.35744),(-2.64322,.49128,-3.18128),(-2.7712,.44153,-3.22183),(-2.56294,.30966,-3.29665),(-3.09455,.43767,-3.74267),(-3.11973,.40847,-3.89569),(-3.03734,.36188,-3.74016),(-2.93035,.39723,-3.49213),(-3.04592,.46426,-3.62192),(-2.98968,.37898,-3.6218),(-3.02129,.49951,-3.48833),(-3.14309,.46219,-3.58753),(-3.15915,.42561,-3.71413),(-3.11805,.559,-3.33165),(-3.21214,.48066,-3.45165),(-3.13335,.50732,-3.4557),(-3.16817,.53827,-3.314),(-2.94034,.54268,-3.17987),(-2.97554,.64181,-3.02179),(-3.01205,.59063,-3.19904),(-3.03778,.66806,-3.01681),(-2.97375,.7242,-2.85189),(-3.30863,.75684,-3.03648),(-3.35319,.65388,-3.16345),(-3.21947,.62202,-3.16883),(-3.16888,.67794,-3.01256),(-3.34076,.7316,-3.93004),(-3.48746,.59064,-3.77241),(-3.37781,.75321,-3.79211),(-3.39774,.60729,-3.91069),(-3.25499,1.10928,-4.0106),(-3.28986,.9264,-3.9695),(-3.31496,.94461,-3.82527),(-3.25489,1.11821,-3.84891),(-3.00193,2.03195,-3.42411),(-3.05424,2.08887,-3.29867),(-3.26391,1.75967,-3.39673),(-3.19464,2.00045,-3.27425),(-3.14359,1.92789,-3.41439),(-3.30086,1.80714,-3.22424),(-3.41842,.77918,-3.17514),(-3.46452,.67148,-3.31734),(-2.98513,1.98474,-3.56733),(-3.08263,1.88634,-3.56177),(-3.19413,1.70794,-3.55091),(-3.06013,1.85533,-3.74602),(-3.13831,1.68564,-3.71192),(-3.17072,1.09367,-4.26074),(-3.22266,1.09233,-4.1828),(-3.1402,1.34116,-4.17844),(-3.08334,1.34333,-4.2404),(-2.67481,1.55253,-4.22917),(-2.73868,1.68609,-4.16882),(-2.54492,1.62377,-4.1799),(-2.25191,1.44635,-4.01892),(-2.3004,1.37021,-4.15114),(-2.34245,1.6173,-4.02783),(-2.39606,1.52232,-4.1446),(-2.21654,.76386,-3.7538),(-2.18717,.88398,-3.99295),(-2.20304,.94504,-3.85287),(-2.47675,.15941,-3.60291),(-2.26227,.24764,-3.73164),(-2.32872,.23541,-3.59883),(-2.38513,.19413,-3.81143),(-3.10194,1.10271,-4.31228),(-3.19285,.9022,-4.20553),(-3.09563,.90392,-4.31652),(-3.00497,1.54606,-4.21182),(-2.74356,.2001,-3.81196),(-2.87732,.24019,-3.78026),(-2.90755,.33462,-3.99802),(-2.73479,.29686,-4),(-2.84658,1.12842,-4.34346),(-2.97228,1.11458,-4.33883),(-2.09368,1.59845,-2.05035),(-2.02836,1.50824,-2.11897),(-2.35315,1.19517,-2.26915),(-2.27977,1.28478,-2.36614),(-2.27452,1.25809,-2.23976),(-2.72473,.78316,-2.34745),(-2.62916,.82781,-2.34814),(-2.68431,.80868,-2.23919),(-1.99497,1.40463,-2.20805),(-1.99253,1.3981,-2.29761),(-1.85117,1.9432,-2.506),(-2.04188,1.83686,-2.95378),(-2.06662,1.85569,-2.93589),(-1.83748,1.8201,-2.87135),(-1.96734,1.77114,-2.89503),(-1.7079,1.80407,-2.73103),(-1.79911,1.73452,-2.80642),(-1.76116,1.8815,-2.77164),(-1.83927,1.93881,-2.77015),(-1.94642,1.93023,-2.71811),(-2.22006,1.6037,-3.06294),(-2.17028,1.80803,-3.06612),(-2.14868,1.69321,-2.99675),(-2.24381,1.67619,-3.1443),(-2.09091,1.61831,-2.04603),(-1.97537,1.64589,-2.10152),(-2.08062,1.67834,-2.13065),(-1.78466,1.74646,-2.29396),(-1.89079,1.7753,-2.34598),(-1.87862,1.67652,-2.18425),(-1.98154,1.72237,-2.22624),(-2.18693,1.92483,-2.82931),(-2.24668,1.84905,-2.37843),(-2.08596,1.76313,-2.27607),(-2.18079,1.89003,-2.43078),(-2.18886,1.71756,-2.16755),(-2.32733,1.76363,-2.20597),(-2.5933,1.70858,-2.5352),(-2.49929,1.71721,-2.56146),(-2.55405,1.77966,-2.59097),(-2.70743,1.64902,-2.40063),(-2.59454,1.69857,-2.51195),(-2.74152,1.66709,-2.47908),(-2.49275,1.69766,-2.21382),(-2.73062,1.72646,-2.01361),(-2.92697,1.73474,-2.02558),(-2.77015,1.75837,-1.84521),(-2.63627,1.70263,-1.83211),(-2.53612,1.62615,-1.81455),(-2.45226,1.61178,-1.9239),(-2.57524,1.667,-1.97002),(-2.42511,1.57865,-1.90871),(-2.35581,1.62055,-2.07942),(-2.31474,1.56799,-2.08636),(-2.52531,1.60551,-1.7707),(-2.48953,1.59643,-1.8023),(-2.30952,1.54583,-2.08721),(-2.38698,1.40633,-2.09147),(-2.27393,1.44292,-2.13468),(-3.02023,.88844,-2.06391),(-2.92025,.90207,-2.06624),(-2.84112,1.02745,-1.97687),(-3.0999,.88137,-2.15209),(-3.10997,.88202,-2.05044),(-3.14663,.94481,-1.772),(-3.11532,.91424,-1.86506),(-3.00784,.93216,-1.79661),(-3.0009,.91803,-1.88027),(-3.10947,.81057,-2.59264),(-2.99479,.74627,-2.58056),(-3.12993,.74574,-2.8681),(-3.31456,1.21882,-1.90453),(-3.2739,1.06888,-1.74524),(-3.2788,1.10209,-1.87314),(-3.51088,1.36091,-2.48334),(-3.41263,1.19777,-2.34301),(-3.49216,1.27089,-2.34643),(-3.43056,1.29508,-2.54279),(-3.51253,1.42562,-2.57237),(-3.43738,1.36959,-2.7085),(-3.2857,1.67903,-2.34114),(-3.26151,1.7277,-2.26406),(-3.13766,1.67949,-2.22003),(-3.14499,1.62606,-2.32426),(-2.97314,1.73099,-2.04052),(-2.97562,1.81854,-1.85673),(-2.97683,1.58114,-2.31151),(-2.97045,1.63461,-2.20722),(-3.28285,1.68613,-2.42609),(-3.13229,1.61303,-2.42289),(-2.56493,1.95147,-2.78491),(-2.66536,2.00375,-2.85973),(-2.73474,1.9114,-2.73141),(-2.70865,1.82684,-2.63518),(-2.56843,1.81453,-2.61263),(-2.61073,1.85543,-2.66707),(-2.69793,1.72936,-2.55209),(-2.70018,2.1378,-3.26056),(-2.8549,2.1709,-3.27956),(-2.75857,2.12657,-3.12555),(-2.26913,1.91876,-3.06296),(-2.28396,1.94418,-2.88507),(-2.18958,1.87685,-2.99985),(-2.42711,1.85659,-3.36957),(-2.42979,1.80311,-3.43807),(-2.30043,1.77923,-3.24188),(-2.97527,2.14018,-2.98971),(-3.43075,1.59476,-2.28093),(-3.36259,1.72458,-2.23917),(-3.4221,1.59016,-2.36367),(-3.46371,1.48542,-2.41912),(-3.46219,1.3292,-2.29959),(-3.49543,1.29457,-2.33666),(-3.44247,1.27872,-2.24149),(-3.37692,1.2167,-2.07807),(-3.43611,1.24945,-2.24417),(-3.39309,1.20413,-2.21169),(-3.4123,1.2735,-2.10891),(-3.41104,1.53471,-1.97976),(-3.10007,1.89005,-1.66651),(-3.0972,1.86887,-1.66158),(-3.01111,1.8628,-1.64512),(-3.2699,1.23963,-1.74221),(-3.31981,1.36112,-1.72795),(-3.18006,1.17781,-1.71496),(-3.26391,1.07064,-1.7325),(-3.2269,1.01946,-1.73781),(-2.52927,1.57201,-1.75909),(-2.53825,1.53799,-1.78097),(-2.4823,1.55996,-1.79708),(-2.49882,1.51912,-1.80764),(-2.72689,1.20043,-1.84758),(-2.57891,1.40234,-1.83771),(-2.69904,1.17593,-1.92958),(-3.19362,1.80089,-1.67925),(-3.10668,1.73904,-1.67621),(-2.94946,1.32766,-1.74666),(-2.82132,1.27264,-1.78926),(-2.7096,1.46506,-1.76318),(-2.84687,1.53349,-1.74379),(-2.95804,1.63173,-1.7134),(-2.98529,1.587,-1.71389),(-2.6368,1.42653,-1.79343),(-2.73465,1.20689,-1.83275),(-2.78005,1.24118,-1.81161),(-2.85899,1.02745,-1.8352),(-2.84911,1.02975,-1.91572),(-2.62027,1.58081,-1.7338),(-3.00707,.94832,-1.78058),(-2.8699,1.04217,-1.81081),(-2.9286,1.09525,-1.76965),(-3.2621,1.53839,-1.70592),(-3.22488,1.81225,-2.06854),(-3.317,1.77669,-2.05342),(-3.41649,1.6451,-1.99209),(-3.43959,1.59973,-2.19002),(-3.37899,1.68914,-1.8401),(-3.37039,1.57303,-1.8085),(-3.29851,1.83747,-1.87807),(-3.37381,1.32731,-1.93063),(-3.46632,1.43254,-2.39399),(-3.46562,1.46539,-2.42936),(-3.51355,1.38121,-2.46594),(-2.98297,2.1745,-3.20886),(-3.02351,2.13973,-3.19947),(-3.10255,2.16781,-3.05843),(-2.38938,1.99696,-3.14288),(-2.42132,1.99889,-3.00349),(-2.64085,2.03585,-2.91943),(-2.80599,2.0818,-2.95115),(-2.94995,1.60569,-2.39361),(-3.05256,1.7499,-2.54022),(-2.88331,1.68431,-2.51292),(-3.25234,1.73913,-2.54105),(-3.06437,1.86744,-1.87134),(-3.10248,1.76875,-2.05372),(-3.43378,1.07038,-2.97141),(-3.40474,1.16612,-2.75133),(-3.31555,1.03061,-2.64397),(-3.29788,1.07208,-2.35248),(-3.36521,1.19776,-2.07103),(-2.84028,.76147,-2.32565),(-2.78929,.8037,-2.21146),(-2.82925,.66428,-2.83277),(-2.87787,.72914,-2.57255),(-2.44224,1.32507,-2.04881),(-2.59977,1.12145,-2.00885),(-2.52112,1.62761,-2.0816),(-2.73888,1.67624,-2.49863),(-2.69211,1.69231,-2.54187),(-2.41769,1.67261,-2.13935),(-2.34007,1.7544,-2.21883),(-2.29586,1.81627,-2.29234),(-2.19923,1.8503,-2.50251),(-2.29625,1.78243,-2.5029),(-1.92767,1.88537,-2.45535),(-1.8363,1.85153,-2.41126),(-1.99289,1.83582,-2.39661),(-2.21524,1.54888,-2.09994),(-2.25883,1.53232,-3.12864),(-2.16866,1.83131,-3.05041),(-1.97059,1.70334,-2.83065),(-2.11881,1.54465,-2.67903),(-2.0211,1.57161,-2.67344),(-2.07154,1.65026,-2.85858),(-1.87284,1.47087,-2.4717),(-2.03831,1.49268,-2.51779),(-1.83948,1.57529,-2.63223),(-1.92918,1.52934,-2.17055),(-1.93439,1.42598,-2.2596),(-2.59959,.75069,-2.89229),(-2.45861,1.00059,-2.75933),(-2.50301,.96335,-2.54988),(-2.63853,.82211,-2.58756),(-2.4311,1.07638,-2.28285),(-2.64193,.85881,-2.18258),(-2.21423,1.32907,-2.22634),(-3.00013,.89538,-4.35119),(-2.78302,.65826,-4.29958),(-2.98205,.67022,-4.2542),(-2.79574,.90454,-4.37205),(-2.8741,.21321,-3.65622),(-3.0701,.68395,-4.21658),(-3.05088,.53197,-4.12489),(-2.35968,.27506,-3.47761),(-2.43018,.35802,-3.34443),(-2.55451,.28844,-3.31911),(-2.5278,.20545,-3.46594),(-2.4777,1.65268,-4.12742),(-2.41967,1.74841,-4.0521),(-3.03776,1.61262,-4.16266),(-3.33076,.9542,-3.66104),(-3.41337,.77825,-3.63687),(-2.93037,1.93485,-3.74853),(-3.35571,.94155,-2.92056),(-3.39756,.85867,-3.07003),(-3.35479,1.48983,-3.21652),(-3.50174,.58142,-3.59379),(-3.42884,.8022,-3.46852),(-3.48495,.62515,-3.4331),(-3.48595,.55808,-3.40258),(-3.45406,.5961,-3.30849),(-3.38382,.68129,-3.16484),(-3.34119,.46375,-3.42177),(-3.28124,.53878,-3.30804),(-3.24285,.42106,-3.54374),(-3.34026,.397,-3.54111),(-3.3102,.38262,-3.67687),(-3.24504,.41063,-3.69244),(-3.08837,.60933,-3.18173),(-2.89207,.42363,-3.35745),(-2.82365,.27647,-3.45769),(-2.26367,1.31617,-3.73976),(-2.55952,1.85282,-3.57187),(-2.52015,1.78978,-3.73075),(-2.34551,1.09281,-3.3381),(-2.28023,.65706,-3.55292),(-2.38262,.64466,-3.37933),(-2.29769,.48851,-3.46998),(-2.99118,.29505,-3.74337),(-2.35566,1.23144,-2.1612),(-2.23725,.30363,-3.68026),(-3.23603,2.10395,-2.93043),(-2.19475,.81666,-4.09141),(-2.18555,.87253,-4.02653),(-2.81171,1.82867,-4.15345),(-2.90287,1.73763,-4.17506),(-1.96157,1.4122,-2.31694),(-2.26811,1.84497,-3.17727),(-2.29427,1.79493,-3.22617),(-1.91888,1.94698,-2.63626),(-2.00183,1.92403,-2.55485),(-2.79781,1.81203,-2.6189),(-3.31181,1.86104,-2.63446),(-2.68921,2.10569,-3.39997),(-2.56346,2.01776,-3.39249),(-2.04011,1.80505,-2.95727),(-2.69032,1.71081,-2.54312),(-2.55681,1.80014,-2.60318),(-3.20627,2.10465,-2.89168),(-3.20469,1.85846,-2.62985),(-3.22057,1.80728,-2.61462),(-2.39053,1.95468,-3.26346),(-3.11251,1.92247,-1.67745),(-3.11622,1.94091,-1.71682),(-3.23494,1.0135,-1.74929),(-3.1389,.95472,-1.76025),(-2.43712,.38496,-3.32656),(-2.33992,1.62417,-4.01341),(-3.32321,1.23832,-1.90953),(-2.57312,1.98426,-3.42354),(-2.57707,1.9708,-3.43947),(-2.10224,1.90831,-2.4785),(-2.18843,1.87956,-2.4455),(-2.11167,1.90114,-2.49546),(-2.43949,1.87198,-2.6643),(-3.41916,.56176,-3.304),(-3.44552,.50426,-3.39561),(-3.46423,.43774,-3.54497),(-3.49417,.48912,-3.72952),(-3.45205,.43356,-3.71944),(-3.50443,.49026,-3.56049),(-3.3719,.46897,-3.87825),(-3.41199,.51794,-3.89167),(-2.42563,1.872,-3.35492),(-3.51352,1.44847,-2.55748),(-2.41926,1.75589,-4.03827),(-3.23166,1.10184,-4.15799),(-3.15007,1.34596,-4.15667),(-3.05008,1.61654,-4.14326),(-2.20514,1.18234,-4.02054),(-2.70472,.25676,-3.37472),(-3.34721,1.59218,-1.71907),(-2.42287,1.56092,-1.90757),(-2.48432,1.97276,-2.85043),(-2.48686,1.90994,-2.72506),(-2.26249,1.87502,-3.15545),(-2.869,2.1567,-3.2998),(-2.40023,1.93016,-3.28752),(-2.00048,1.934,-2.51566),(-1.97034,1.62755,-2.10841),(-1.87179,1.65925,-2.19191),(-1.72406,1.80618,-2.39924),(-1.76547,1.71866,-2.30877),(-1.7442,1.83167,-2.38513),(-1.72418,1.94162,-2.54773),(-2.56887,1.91465,-3.50121),(-3.08814,1.4143,-1.72276),(-3.1373,1.64852,-1.6907),(-3.22853,1.67057,-1.69258),(-2.20243,.36927,-3.9261),(-2.67705,1.14026,-4.34654),(-1.777,1.97068,-2.63888),(-2.4597,1.07317,-2.13162),(-2.51321,.56217,-3.25132),(-3.02198,.54397,-3.34991),(-2.74929,.16407,-3.66176),(-2.29197,.92258,-3.54595),(-2.34566,.8084,-3.41926),(-2.37086,1.62899,-3.86829),(-2.47157,1.78073,-3.90059),(-2.58375,1.85901,-3.92316),(-2.74437,1.92174,-3.94314),(-2.25105,1.06241,-3.64737),(-2.30375,1.23109,-3.46497),(-2.29932,1.41183,-3.02771),(-2.30842,1.37493,-3.2674),(-2.30855,1.39662,-3.55363),(-3.25357,.84012,-2.87878),(-2.88647,1.91628,-3.93471),(-3.1063,1.66462,-3.89868),(-3.08347,1.62833,-4.04421),(-3.01937,1.83186,-3.92754),(-3.18319,1.38336,-3.88335),(-3.17899,1.35505,-4.03773),(-3.31008,1.45576,-3.35478),(-3.34605,1.19884,-3.34414),(-3.25007,1.42368,-3.54455),(-3.30138,1.15766,-3.50997),(-3.35411,.97581,-3.50428),(-3.21159,1.40456,-3.69306),(-3.28122,1.12917,-3.66752),(-2.57874,1.38291,-4.28136),(-2.45159,1.4392,-4.23513),(-2.85532,1.63575,-4.18744),(-2.23892,1.12386,-4.13436),(-2.68732,.16887,-3.52011),(-2.95161,.51345,-4.15939),(-2.62647,.14058,-3.65409),(-2.75512,.4901,-4.18856),(-2.18923,.56495,-4.06541),(-2.31587,1.04442,-4.26062),(-2.22664,.73624,-4.15807),(-2.39089,1.27086,-4.26276),(-2.35885,.51092,-4.15124),(-2.34569,.31288,-4.00362),(-2.45038,.98898,-4.3489),(-2.39567,.66998,-4.26063),(-2.51075,1.20638,-4.33281),(-2.53795,.2926,-4.01563),(-2.55346,.18322,-3.82684),(-2.56904,.48872,-4.17969),(-2.59313,.6818,-4.30701),(-2.61853,.92717,-4.37456),(-2.20666,1.35848,-2.33582),(-2.53964,.93635,-2.32156),(-2.56212,.94503,-2.14182),(-2.74288,.74109,-2.59265),(-1.68705,1.73346,-2.49698),(-1.73417,1.64522,-2.57431),(-1.66222,1.85794,-2.58927),(-1.73768,1.61586,-2.36929),(-1.84768,1.55518,-2.25352),(-1.68981,1.89305,-2.48042),(-2.28183,1.33198,-2.62842),(-2.19037,1.4342,-2.54261),(-1.77232,1.52603,-2.42908),(-1.87131,1.46175,-2.31255),(-2.1189,1.48126,-2.53272),(-2.26405,1.40142,-2.7688),(-2.18588,1.50526,-2.72883),(-1.71086,1.9338,-2.62816),(-2.17062,1.5988,-2.90348),(-2.32521,1.28007,-2.83266),(-2.23921,1.52168,-2.96582),(-2.0489,1.73839,-2.93565),(-2.69416,.97831,-2.05047),(-2.73845,.87362,-2.11991),(-3.21982,1.01481,-1.86055),(-2.68849,.68216,-2.87383),(-3.37936,1.1871,-2.20375),(-3.19072,.94695,-2.34091),(-3.21866,.90197,-2.60327),(-3.19679,1.89057,-1.89873),(-2.89299,1.95962,-2.77358),(-3.09096,2.04657,-2.82458),(-2.97034,1.85394,-2.64728),(-3.17119,1.92592,-2.70295),(-2.56077,2.07738,-3.21868),(-2.58983,2.06602,-3.07803),(-3.42502,1.61472,-2.46271),(-3.06211,1.11313,-1.741)]))),
        Shape(DEF='rcuboid',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rcuboid_Geo',coordIndex=[0,1,2,-1,2,1,3,-1,4,5,6,-1,7,8,9,-1,7,10,8,-1,11,1,0,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,21,24,22,-1,25,26,27,-1,28,29,30,-1,29,31,30,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,41,10,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,52,55,53,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,64,65,62,-1,66,67,68,-1,69,70,71,-1,72,23,22,-1,72,73,23,-1,74,75,39,-1,76,77,78,-1,77,36,78,-1,79,80,81,-1,79,82,80,-1,83,84,85,-1,83,82,84,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,91,93,92,-1,0,94,95,-1,0,96,94,-1,97,98,99,-1,98,100,99,-1,101,102,103,-1,101,104,102,-1,105,106,107,-1,108,109,110,-1,45,44,111,-1,69,71,112,-1,113,94,114,-1,115,116,117,-1,118,71,70,-1,115,119,120,-1,120,116,115,-1,121,122,123,-1,124,125,126,-1,124,44,125,-1,127,128,129,-1,129,130,127,-1,131,132,133,-1,123,134,135,-1,136,137,138,-1,138,139,136,-1,140,138,137,-1,141,142,143,-1,141,144,142,-1,145,146,147,-1,145,148,146,-1,149,46,48,-1,149,33,46,-1,47,46,32,-1,32,150,47,-1,1,151,152,-1,153,154,155,-1,154,121,118,-1,156,157,158,-1,156,159,157,-1,160,161,20,-1,162,163,164,-1,164,165,162,-1,16,166,17,-1,16,162,166,-1,162,167,163,-1,162,16,167,-1,30,168,169,-1,30,170,168,-1,37,171,35,-1,10,172,8,-1,10,173,172,-1,174,175,176,-1,5,172,177,-1,5,8,172,-1,169,178,179,-1,169,168,178,-1,57,180,58,-1,57,181,180,-1,182,183,184,-1,182,185,183,-1,186,187,188,-1,186,189,187,-1,190,189,145,-1,189,186,145,-1,191,192,193,-1,85,0,2,-1,85,84,0,-1,194,195,196,-1,195,197,196,-1,194,198,199,-1,198,200,199,-1,201,202,203,-1,201,204,202,-1,205,206,207,-1,208,15,17,-1,209,210,211,-1,212,148,213,-1,212,146,148,-1,141,214,147,-1,141,215,214,-1,216,217,113,-1,113,218,216,-1,190,219,189,-1,190,220,219,-1,221,115,81,-1,217,11,95,-1,217,222,11,-1,82,79,223,-1,223,84,82,-1,224,225,3,-1,3,226,224,-1,227,228,229,-1,227,230,228,-1,231,232,233,-1,234,235,177,-1,177,236,234,-1,78,237,238,-1,78,239,237,-1,77,37,36,-1,41,240,241,-1,41,42,240,-1,9,242,243,-1,130,123,122,-1,122,244,130,-1,134,129,125,-1,125,245,134,-1,57,56,32,-1,46,33,32,-1,182,246,185,-1,64,247,65,-1,248,249,250,-1,250,251,248,-1,250,183,185,-1,170,185,246,-1,175,252,253,-1,253,169,175,-1,254,255,178,-1,256,257,258,-1,154,259,155,-1,259,159,155,-1,260,112,71,-1,71,261,260,-1,262,263,264,-1,262,108,263,-1,265,266,267,-1,261,138,260,-1,268,269,270,-1,269,271,270,-1,254,272,131,-1,254,246,272,-1,273,227,229,-1,274,30,31,-1,250,274,251,-1,250,185,274,-1,251,275,248,-1,276,29,68,-1,276,25,29,-1,277,278,247,-1,277,279,278,-1,280,247,64,-1,280,277,247,-1,63,281,64,-1,282,283,284,-1,285,286,287,-1,286,288,287,-1,50,282,284,-1,150,289,111,-1,245,44,43,-1,245,125,44,-1,290,127,291,-1,258,257,49,-1,49,292,258,-1,293,153,294,-1,293,122,153,-1,243,42,7,-1,243,295,42,-1,239,78,36,-1,238,237,108,-1,108,262,238,-1,177,172,296,-1,296,236,177,-1,297,298,299,-1,144,300,92,-1,92,142,144,-1,196,301,302,-1,195,303,197,-1,304,305,306,-1,305,307,306,-1,308,309,310,-1,2,3,225,-1,79,117,311,-1,311,223,79,-1,116,312,313,-1,145,147,314,-1,315,316,317,-1,317,318,315,-1,14,319,12,-1,320,321,206,-1,205,207,322,-1,323,324,325,-1,19,326,160,-1,327,90,328,-1,15,167,16,-1,329,103,102,-1,329,330,103,-1,331,332,333,-1,333,334,331,-1,335,200,104,-1,303,336,281,-1,303,195,336,-1,337,279,338,-1,337,278,279,-1,280,339,277,-1,340,341,342,-1,120,265,343,-1,120,119,265,-1,175,179,176,-1,175,169,179,-1,132,256,234,-1,256,344,234,-1,252,66,28,-1,28,253,252,-1,252,175,174,-1,324,323,98,-1,323,345,98,-1,346,347,321,-1,347,206,321,-1,348,160,349,-1,12,319,350,-1,159,106,157,-1,122,293,244,-1,235,351,6,-1,306,352,353,-1,353,354,306,-1,220,190,355,-1,356,249,248,-1,356,33,149,-1,149,249,356,-1,220,357,219,-1,246,168,170,-1,147,144,141,-1,147,146,144,-1,330,329,346,-1,329,347,346,-1,358,43,45,-1,136,358,45,-1,136,139,358,-1,359,11,222,-1,359,360,11,-1,196,197,305,-1,305,301,196,-1,130,291,127,-1,130,244,291,-1,131,272,257,-1,119,115,361,-1,147,214,314,-1,362,363,221,-1,362,364,363,-1,140,137,266,-1,137,365,266,-1,198,366,333,-1,198,367,366,-1,368,369,370,-1,368,371,369,-1,372,97,373,-1,97,99,373,-1,0,95,11,-1,142,92,93,-1,93,53,142,-1,374,317,316,-1,316,375,374,-1,143,218,141,-1,96,84,223,-1,96,0,84,-1,79,81,115,-1,115,117,79,-1,376,377,264,-1,377,262,264,-1,378,76,238,-1,76,78,238,-1,379,353,352,-1,380,357,220,-1,381,180,181,-1,382,51,383,-1,285,287,384,-1,385,62,386,-1,62,65,386,-1,386,65,247,-1,247,278,386,-1,44,124,287,-1,272,282,257,-1,184,286,182,-1,257,282,50,-1,50,49,257,-1,171,37,387,-1,37,40,387,-1,7,9,243,-1,288,48,47,-1,276,21,25,-1,388,389,390,-1,391,342,341,-1,367,302,366,-1,302,392,366,-1,393,323,394,-1,160,20,19,-1,302,367,196,-1,10,7,42,-1,225,85,2,-1,152,3,1,-1,40,37,38,-1,325,394,323,-1,394,325,395,-1,396,323,393,-1,396,345,323,-1,397,366,392,-1,366,397,398,-1,191,399,390,-1,399,191,193,-1,388,341,389,-1,388,391,341,-1,390,400,388,-1,400,390,399,-1,276,24,21,-1,276,401,24,-1,27,275,251,-1,27,26,275,-1,283,182,286,-1,283,246,182,-1,383,50,384,-1,50,383,51,-1,283,272,246,-1,282,272,283,-1,365,267,266,-1,365,402,267,-1,298,227,299,-1,230,227,298,-1,403,298,404,-1,405,298,403,-1,406,407,408,-1,407,406,241,-1,240,409,410,-1,409,240,411,-1,412,385,386,-1,413,385,412,-1,284,384,50,-1,284,285,384,-1,292,382,414,-1,49,382,292,-1,49,51,382,-1,270,290,291,-1,270,271,290,-1,415,337,338,-1,337,415,416,-1,417,418,419,-1,417,420,418,-1,72,421,420,-1,421,72,192,-1,105,422,110,-1,422,105,107,-1,423,352,424,-1,423,379,352,-1,39,425,426,-1,75,425,39,-1,377,238,262,-1,377,378,238,-1,264,83,376,-1,83,264,427,-1,225,377,376,-1,377,225,224,-1,76,428,308,-1,76,378,428,-1,390,429,191,-1,389,429,390,-1,87,430,431,-1,89,430,87,-1,311,96,223,-1,432,96,311,-1,433,52,434,-1,52,433,435,-1,216,143,55,-1,143,216,218,-1,208,374,15,-1,374,208,317,-1,375,436,327,-1,375,316,436,-1,437,214,438,-1,314,214,437,-1,199,335,439,-1,199,200,335,-1,440,441,442,-1,443,441,440,-1,444,445,446,-1,447,445,444,-1,389,340,429,-1,340,389,341,-1,211,86,448,-1,89,86,211,-1,357,430,210,-1,449,430,357,-1,450,380,451,-1,450,452,380,-1,114,453,454,-1,432,453,114,-1,347,331,455,-1,347,329,331,-1,456,398,396,-1,456,334,398,-1,371,434,369,-1,371,433,434,-1,302,370,392,-1,302,368,370,-1,332,198,333,-1,200,198,332,-1,457,364,458,-1,364,457,459,-1,422,460,263,-1,460,422,458,-1,365,136,289,-1,137,136,365,-1,461,266,361,-1,461,140,266,-1,460,80,427,-1,460,362,80,-1,115,363,361,-1,115,221,363,-1,462,463,312,-1,462,464,463,-1,344,268,351,-1,344,269,268,-1,351,270,465,-1,351,268,270,-1,466,305,304,-1,466,301,305,-1,359,467,360,-1,468,467,359,-1,358,245,43,-1,358,469,245,-1,112,461,470,-1,112,260,461,-1,471,472,201,-1,471,473,472,-1,204,474,475,-1,204,476,474,-1,188,164,186,-1,188,165,164,-1,142,55,143,-1,142,53,55,-1,218,215,141,-1,215,218,113,-1,219,210,209,-1,219,357,210,-1,150,56,402,-1,150,32,56,-1,420,477,418,-1,420,421,477,-1,355,380,220,-1,451,380,355,-1,343,180,381,-1,343,265,180,-1,209,448,187,-1,209,211,448,-1,381,478,343,-1,478,381,479,-1,309,379,423,-1,309,480,379,-1,74,38,310,-1,38,74,39,-1,481,244,293,-1,244,481,465,-1,482,108,237,-1,482,109,108,-1,239,35,483,-1,36,35,239,-1,319,484,350,-1,319,485,484,-1,12,486,13,-1,12,202,486,-1,13,346,321,-1,13,486,346,-1,393,456,396,-1,393,322,456,-1,97,160,326,-1,372,160,97,-1,487,213,488,-1,213,487,212,-1,456,207,455,-1,456,322,207,-1,372,349,160,-1,489,349,372,-1,487,300,212,-1,487,328,300,-1,174,66,252,-1,174,413,66,-1,41,406,490,-1,241,406,41,-1,234,351,235,-1,351,234,344,-1,63,491,273,-1,63,62,491,-1,174,385,413,-1,174,492,385,-1,303,493,426,-1,303,228,493,-1,478,464,462,-1,478,450,464,-1,452,494,449,-1,452,479,494,-1,277,495,279,-1,277,339,495,-1,338,496,415,-1,338,497,496,-1,497,447,496,-1,445,447,497,-1,445,495,443,-1,445,497,495,-1,280,281,336,-1,281,280,64,-1,446,498,444,-1,499,498,446,-1,500,442,101,-1,500,440,442,-1,441,280,439,-1,280,441,339,-1,329,332,331,-1,329,102,332,-1,499,472,498,-1,499,476,472,-1,101,474,500,-1,101,103,474,-1,162,471,166,-1,165,471,162,-1,486,330,346,-1,330,486,475,-1,374,167,15,-1,374,488,167,-1,375,328,487,-1,327,328,375,-1,349,436,348,-1,91,436,349,-1,348,161,160,-1,348,315,161,-1,324,19,325,-1,19,324,326,-1,322,394,205,-1,322,393,394,-1,321,14,13,-1,320,14,321,-1,206,501,320,-1,205,501,206,-1,14,485,319,-1,502,485,14,-1,503,317,208,-1,503,318,317,-1,501,18,502,-1,395,18,501,-1,484,315,318,-1,161,315,484,-1,192,88,421,-1,192,191,88,-1,213,164,163,-1,148,164,213,-1,453,312,463,-1,453,313,312,-1,95,113,217,-1,95,94,113,-1,373,489,372,-1,489,373,54,-1,360,354,151,-1,360,467,354,-1,373,369,434,-1,373,99,369,-1,371,466,468,-1,368,466,371,-1,480,308,428,-1,308,480,309,-1,426,197,303,-1,426,425,197,-1,424,306,307,-1,352,306,424,-1,301,368,302,-1,301,466,368,-1,425,305,197,-1,305,425,307,-1,196,198,194,-1,196,367,198,-1,366,334,333,-1,398,334,366,-1,40,504,387,-1,504,40,493,-1,405,230,298,-1,405,504,230,-1,505,506,507,-1,505,404,506,-1,403,490,406,-1,508,490,403,-1,509,505,232,-1,509,508,505,-1,172,509,296,-1,172,173,509,-1,236,231,133,-1,236,296,231,-1,510,511,242,-1,294,511,510,-1,159,511,155,-1,159,156,511,-1,59,109,482,-1,61,109,59,-1,295,60,411,-1,295,158,60,-1,410,483,35,-1,409,483,410,-1,293,510,481,-1,510,293,294,-1,292,269,258,-1,271,269,292,-1,128,290,414,-1,290,128,127,-1,123,512,121,-1,123,135,512,-1,139,469,358,-1,513,469,139,-1,150,44,47,-1,150,111,44,-1,126,383,124,-1,126,382,383,-1,284,286,285,-1,284,283,286,-1,439,336,199,-1,439,280,336,-1,337,386,278,-1,337,412,386,-1,276,67,416,-1,276,68,67,-1,418,514,515,-1,477,514,418,-1,275,417,248,-1,275,73,417,-1,22,192,72,-1,192,22,193,-1,73,26,23,-1,275,26,73,-1,274,27,251,-1,274,31,27,-1,297,491,492,-1,491,297,299,-1,179,507,176,-1,179,233,507,-1,481,4,6,-1,481,510,4,-1,261,139,138,-1,261,513,139,-1,402,289,150,-1,402,365,289,-1,266,119,361,-1,265,119,266,-1,459,112,470,-1,69,112,459,-1,70,154,118,-1,259,154,70,-1,263,427,264,-1,427,263,460,-1,181,479,381,-1,479,181,494,-1,462,343,478,-1,462,120,343,-1,195,199,336,-1,194,199,195,-1,107,159,259,-1,107,106,159,-1,457,259,70,-1,107,259,457,-1,71,121,512,-1,121,71,118,-1,361,470,461,-1,361,363,470,-1,261,512,513,-1,71,512,261,-1,121,153,122,-1,121,154,153,-1,236,132,234,-1,236,133,132,-1,178,233,179,-1,255,233,178,-1,506,492,174,-1,506,297,492,-1,274,170,30,-1,185,170,274,-1,183,249,149,-1,183,250,249,-1,416,401,276,-1,416,415,401,-1,388,496,447,-1,388,400,496,-1,356,34,33,-1,356,419,34,-1,149,184,183,-1,48,184,149,-1,57,34,515,-1,57,32,34,-1,513,135,469,-1,513,512,135,-1,134,130,129,-1,134,123,130,-1,414,126,128,-1,126,414,382,-1,4,242,9,-1,4,510,242,-1,407,35,171,-1,407,410,35,-1,42,411,240,-1,295,411,42,-1,409,482,483,-1,409,59,482,-1,158,61,60,-1,61,158,157,-1,294,155,511,-1,155,294,153,-1,156,242,511,-1,243,242,156,-1,254,133,255,-1,131,133,254,-1,232,296,509,-1,231,296,232,-1,173,508,509,-1,173,490,508,-1,507,232,505,-1,233,232,507,-1,508,404,505,-1,508,403,404,-1,408,504,405,-1,408,387,504,-1,504,228,230,-1,504,493,228,-1,100,392,370,-1,392,100,397,-1,75,307,425,-1,75,424,307,-1,226,428,224,-1,428,226,480,-1,306,467,304,-1,467,306,354,-1,99,370,369,-1,99,100,370,-1,433,468,359,-1,433,371,468,-1,11,151,1,-1,360,151,11,-1,359,435,433,-1,222,435,359,-1,222,216,435,-1,222,217,216,-1,221,80,362,-1,221,81,80,-1,215,438,214,-1,438,215,454,-1,514,494,181,-1,514,431,494,-1,355,145,314,-1,355,190,145,-1,146,300,144,-1,300,146,212,-1,477,431,514,-1,431,477,87,-1,187,340,342,-1,187,448,340,-1,485,18,20,-1,18,485,502,-1,395,205,394,-1,395,501,205,-1,318,350,484,-1,318,503,350,-1,502,320,501,-1,502,14,320,-1,12,503,516,-1,12,350,503,-1,316,348,436,-1,316,315,348,-1,487,374,375,-1,374,487,488,-1,475,202,204,-1,475,486,202,-1,166,201,203,-1,471,201,166,-1,500,476,499,-1,500,474,476,-1,473,498,472,-1,342,498,473,-1,101,335,104,-1,442,335,101,-1,443,339,441,-1,443,495,339,-1,342,444,498,-1,444,342,391,-1,440,499,446,-1,440,500,499,-1,400,415,496,-1,415,400,401,-1,497,279,495,-1,279,497,338,-1,209,189,219,-1,187,189,209,-1,342,188,187,-1,342,473,188,-1,176,506,174,-1,507,506,176,-1,515,181,57,-1,515,514,181,-1,450,437,464,-1,450,451,437,-1,30,253,28,-1,30,169,253,-1,229,303,281,-1,303,229,228,-1,246,178,168,-1,246,254,178,-1,273,281,63,-1,229,281,273,-1,62,492,491,-1,62,385,492,-1,6,177,235,-1,5,177,6,-1,173,41,490,-1,41,173,10,-1,408,171,387,-1,171,408,407,-1,40,426,493,-1,40,39,426,-1,91,489,93,-1,489,91,349,-1,488,163,167,-1,163,488,213,-1,328,92,300,-1,328,90,92,-1,98,326,324,-1,97,326,98,-1,455,206,347,-1,206,455,207,-1,516,202,12,-1,516,203,202,-1,203,17,166,-1,203,517,17,-1,517,203,516,-1,485,161,484,-1,485,20,161,-1,243,158,295,-1,158,243,156,-1,483,237,239,-1,482,237,483,-1,6,465,481,-1,465,6,351,-1,353,480,226,-1,480,353,379,-1,423,310,309,-1,74,310,423,-1,152,226,3,-1,152,353,226,-1,267,180,265,-1,267,58,180,-1,478,452,450,-1,478,479,452,-1,421,87,477,-1,421,88,87,-1,419,248,417,-1,419,356,248,-1,165,473,471,-1,165,188,473,-1,93,54,53,-1,93,489,54,-1,145,164,148,-1,186,164,145,-1,103,475,474,-1,475,103,330,-1,201,476,204,-1,201,472,476,-1,260,140,461,-1,260,138,140,-1,134,469,135,-1,134,245,469,-1,304,468,466,-1,467,468,304,-1,125,128,126,-1,129,128,125,-1,465,291,244,-1,465,270,291,-1,344,258,269,-1,256,258,344,-1,132,257,256,-1,257,132,131,-1,117,313,311,-1,116,313,117,-1,120,312,116,-1,120,462,312,-1,464,438,463,-1,437,438,464,-1,113,454,215,-1,114,454,113,-1,459,70,69,-1,70,459,457,-1,255,231,233,-1,255,133,231,-1,45,289,136,-1,45,111,289,-1,458,362,460,-1,362,458,364,-1,110,263,108,-1,263,110,422,-1,364,470,363,-1,364,459,470,-1,107,458,422,-1,458,107,457,-1,157,105,61,-1,105,157,106,-1,102,200,332,-1,104,200,102,-1,397,98,345,-1,98,397,100,-1,455,334,456,-1,455,331,334,-1,114,96,432,-1,96,114,94,-1,454,463,438,-1,453,463,454,-1,449,380,452,-1,449,357,380,-1,89,210,430,-1,89,211,210,-1,448,429,340,-1,86,429,448,-1,391,447,444,-1,388,447,391,-1,446,443,440,-1,445,443,446,-1,442,439,335,-1,441,439,442,-1,314,451,355,-1,314,437,451,-1,90,436,91,-1,90,327,436,-1,55,435,216,-1,55,52,435,-1,313,432,311,-1,453,432,313,-1,431,449,494,-1,430,449,431,-1,191,86,88,-1,429,86,191,-1,77,308,310,-1,77,76,308,-1,378,224,428,-1,378,377,224,-1,376,85,225,-1,376,83,85,-1,427,82,83,-1,82,427,80,-1,151,353,152,-1,353,151,354,-1,74,424,75,-1,74,423,424,-1,61,110,109,-1,110,61,105,-1,515,419,418,-1,34,419,515,-1,420,73,72,-1,420,417,73,-1,412,416,67,-1,412,337,416,-1,414,271,292,-1,271,414,290,-1,66,29,28,-1,66,68,29,-1,413,67,66,-1,413,412,67,-1,411,59,409,-1,59,411,60,-1,241,410,407,-1,410,241,240,-1,405,406,408,-1,405,403,406,-1,404,297,506,-1,298,297,404,-1,299,273,491,-1,227,273,299,-1,58,402,56,-1,402,58,267,-1,434,54,373,-1,434,52,54,-1,384,124,383,-1,384,287,124,-1,48,286,184,-1,288,286,48,-1,287,47,44,-1,288,47,287,-1,310,37,77,-1,310,38,37,-1,401,399,24,-1,401,400,399,-1,27,29,25,-1,29,27,31,-1,25,23,26,-1,25,21,23,-1,193,24,399,-1,24,193,22,-1,398,345,396,-1,398,397,345,-1,18,325,19,-1,395,325,18,-1,517,208,17,-1,208,516,503,-1,517,516,208,-1,5,9,8,-1,9,5,4,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rcuboid_Coord',point=[(-2.83242,1.18208,-1.00275),(-2.87665,1.11985,-1.04572),(-2.83428,1.11477,-1.06577),(-2.8988,1.04008,-1.1347),(-2.54798,1.31775,-1.78071),(-2.56146,1.36201,-1.80786),(-2.45166,1.40327,-1.78537),(-2.73631,1.26714,-1.70509),(-2.68266,1.32082,-1.76021),(-2.66302,1.27774,-1.73724),(-2.74289,1.29889,-1.74924),(-2.92753,1.15188,-1.01249),(-3.48766,1.52568,-.97862),(-3.53857,1.46692,-1.07894),(-3.48612,1.38837,-1.06449),(-3.2247,1.6515,-.73916),(-3.22033,1.70248,-.74986),(-3.31964,1.7109,-.79232),(-3.34436,1.18451,-1.04868),(-3.29766,1.12148,-1.03411),(-3.29277,1.183,-.94094),(-3.02257,1.91239,-1.38359),(-2.97966,1.92043,-1.23203),(-2.93026,1.9253,-1.32325),(-3.05327,1.89355,-1.27954),(-3.01517,1.90716,-1.41973),(-2.90631,1.92812,-1.38074),(-2.89641,1.92868,-1.40108),(-2.96143,1.92778,-1.62069),(-2.98549,1.89297,-1.5358),(-2.86201,1.91631,-1.61957),(-2.86779,1.90323,-1.5364),(-2.63175,1.67375,-1.28548),(-2.60225,1.84263,-1.36427),(-2.71161,1.80657,-1.25493),(-3.01294,1.08729,-1.63376),(-3.059,1.02548,-1.61028),(-3.18774,1.03846,-1.70822),(-3.20479,1.03397,-1.70596),(-3.22563,1.03855,-1.6969),(-3.20962,1.04808,-1.7131),(-2.8507,1.2555,-1.73744),(-2.81075,1.23732,-1.67954),(-2.56513,1.56807,-1.37223),(-2.53036,1.64893,-1.45568),(-2.58051,1.57181,-1.34834),(-2.57551,1.7641,-1.42413),(-2.57747,1.74402,-1.43277),(-2.58042,1.77346,-1.43442),(-2.46244,1.58416,-1.5581),(-2.47945,1.59809,-1.5516),(-2.467,1.5892,-1.53829),(-3.01646,1.13987,-.90402),(-2.98189,1.17454,-.85584),(-3.02657,1.13511,-.88711),(-2.96676,1.17695,-.87593),(-2.69957,1.58513,-1.20822),(-2.71223,1.65365,-1.19522),(-2.71494,1.50168,-1.17761),(-2.80346,1.14957,-1.50129),(-2.77784,1.17062,-1.51933),(-2.71883,1.15616,-1.38401),(-3.25715,1.67461,-1.68815),(-3.3412,1.52433,-1.68678),(-3.3729,1.50338,-1.64628),(-3.28257,1.65588,-1.63603),(-3.13123,1.88087,-1.63408),(-3.13774,1.84248,-1.56712),(-3.12371,1.85457,-1.56037),(-2.58702,1.27457,-1.24451),(-2.56885,1.22539,-1.25407),(-2.50371,1.31269,-1.25402),(-2.94044,1.93465,-1.20684),(-2.86513,1.93429,-1.28088),(-3.20015,.98137,-1.62857),(-3.23928,1.02494,-1.60828),(-3.03788,.95247,-1.52165),(-3.1004,.9767,-1.61803),(-3.00377,.99264,-1.53072),(-2.75669,1.22187,-1.09867),(-2.71984,1.19332,-1.14474),(-2.73005,1.23245,-1.14759),(-2.75161,1.18407,-1.10203),(-2.75219,1.13065,-1.1226),(-2.79976,1.18026,-1.0412),(-2.80424,1.11969,-1.08496),(-3.05393,1.87433,-1.01512),(-3.0068,1.8822,-1.03728),(-3.02563,1.89196,-1.05082),(-3.03917,1.86332,-1.00486),(-2.97776,1.21081,-.78446),(-3.00543,1.15685,-.82574),(-2.95683,1.20808,-.80404),(-2.99029,1.15635,-.84449),(-2.85804,1.22551,-.94687),(-2.87117,1.18554,-.96793),(-2.82527,1.21521,-.99121),(-3.23217,1.06208,-1.02308),(-3.30952,1.01418,-1.1494),(-3.21122,1.07308,-1.03674),(-3.29419,1.03931,-1.15696),(-3.47043,1.5098,-1.26823),(-3.52623,1.35006,-1.33825),(-3.5078,1.46962,-1.22026),(-3.50574,1.38882,-1.40697),(-2.68656,1.13873,-1.34789),(-2.6532,1.16407,-1.36562),(-2.62073,1.16187,-1.25697),(-2.76323,1.08782,-1.31945),(-2.76935,1.12104,-1.37008),(-2.73498,1.10693,-1.32904),(-2.60059,1.61547,-1.32758),(-2.59627,1.2924,-1.24849),(-2.89096,1.23585,-.90253),(-2.85779,1.24968,-.94141),(-2.75028,1.2985,-1.16291),(-2.78667,1.33151,-1.0965),(-2.77321,1.27983,-1.09169),(-2.48945,1.24723,-1.29098),(-2.75333,1.35912,-1.16467),(-2.79755,1.40502,-1.10569),(-2.46058,1.25773,-1.32006),(-2.423,1.25077,-1.51246),(-2.40826,1.27669,-1.45246),(-2.51358,1.64216,-1.46683),(-2.47029,1.51946,-1.44321),(-2.45945,1.53621,-1.45642),(-2.37347,1.32305,-1.51482),(-2.40204,1.41729,-1.4582),(-2.41501,1.40661,-1.4443),(-2.38071,1.30615,-1.50385),(-2.51637,1.65152,-1.63326),(-2.48034,1.60344,-1.69203),(-2.57874,1.63004,-1.67488),(-2.42671,1.37266,-1.41642),(-2.4363,1.35048,-1.38083),(-2.59544,1.558,-1.32617),(-2.66223,1.48732,-1.24327),(-2.62934,1.45802,-1.2515),(-2.55893,1.51659,-1.31304),(-2.68341,1.45212,-1.23178),(-2.93763,1.30469,-.84901),(-2.94597,1.22165,-.82546),(-2.92785,1.22751,-.84914),(-2.95228,1.29979,-.80035),(-3.07146,1.54262,-.83097),(-3.01459,1.44421,-.78456),(-3.01392,1.44729,-.83473),(-3.08108,1.53303,-.78459),(-2.60217,1.85684,-1.38469),(-2.6344,1.66333,-1.29969),(-2.9606,1.08408,-1.09887),(-2.93449,1.06138,-1.1132),(-2.45943,1.21422,-1.50952),(-2.49187,1.21582,-1.32771),(-2.52962,1.18496,-1.44539),(-2.69853,1.2164,-1.56509),(-2.68058,1.19024,-1.41515),(-2.73759,1.20355,-1.5476),(-2.62389,1.18719,-1.39251),(-3.19372,1.08174,-.92333),(-3.27567,1.193,-.91408),(-3.20949,1.71809,-.76396),(-3.14818,1.65488,-.73944),(-3.13306,1.63749,-.7888),(-3.19678,1.71834,-.80554),(-3.31852,1.73037,-.8071),(-3.16628,1.65686,-.72879),(-2.76427,1.87223,-1.62859),(-2.88482,1.90624,-1.65011),(-2.76008,1.87665,-1.60368),(-3.08206,1.0714,-1.71701),(-2.68158,1.34656,-1.76593),(-2.75082,1.32023,-1.75658),(-3.186,1.78995,-1.68216),(-3.0836,1.86552,-1.67214),(-3.05454,1.83991,-1.67226),(-2.56527,1.38499,-1.80725),(-2.75258,1.84808,-1.65391),(-2.87881,1.8737,-1.67375),(-2.73716,1.48521,-1.14966),(-2.83645,1.64617,-1.08609),(-2.58841,1.77784,-1.52088),(-2.60722,1.86182,-1.43956),(-2.58416,1.77715,-1.50088),(-2.74473,1.87561,-1.54876),(-3.11484,1.64444,-.83503),(-3.1491,1.76522,-.87747),(-3.1818,1.72974,-.84131),(-3.07591,1.64092,-.86957),(-3.03842,1.57835,-.89059),(-3.06534,1.89502,-1.07917),(-3.01681,1.9114,-1.13508),(-3.02967,1.90501,-1.14621),(-3.41608,1.23818,-1.57598),(-3.38529,1.24539,-1.62295),(-3.3726,1.16766,-1.52928),(-3.34029,1.14757,-1.5624),(-3.4513,1.19842,-1.45853),(-3.45195,1.36197,-1.56706),(-3.4953,1.30275,-1.46019),(-3.36797,1.6592,-.93045),(-3.48684,1.54258,-.99044),(-3.40147,1.65427,-.88785),(-3.4535,1.56271,-1.0284),(-3.51224,1.1711,-1.2647),(-3.56418,1.29649,-1.24899),(-3.56096,1.18627,-1.29948),(-3.2916,1.61291,-.78479),(-3.12386,1.76537,-.88348),(-3.05072,1.76074,-.93934),(-3.08535,1.8137,-.94126),(-3.00408,1.44886,-.73184),(-3.08879,1.52042,-.73308),(-2.98316,1.4368,-.90352),(-2.91062,1.30702,-.89472),(-2.94133,1.18634,-.90295),(-2.91098,1.1892,-.93181),(-2.91683,1.23065,-.86809),(-3.05602,1.64031,-.87326),(-3.02819,1.58105,-.89568),(-2.70904,1.24081,-1.18625),(-2.95752,1.14966,-.98041),(-2.80038,1.21479,-1.02765),(-2.90771,.99525,-1.23518),(-2.82999,1.04129,-1.14781),(-2.97118,1.00689,-1.21938),(-3.29994,1.46203,-1.70519),(-3.32949,1.23629,-1.69448),(-3.36469,1.40096,-1.66856),(-3.22094,1.32055,-1.70995),(-2.704,1.60113,-1.69608),(-2.80628,1.56306,-1.70724),(-2.84599,1.74683,-1.69131),(-2.42832,1.47678,-1.76195),(-2.44741,1.42455,-1.7857),(-2.5682,1.49061,-1.73643),(-2.88949,1.0647,-1.44218),(-2.91457,1.01078,-1.43109),(-2.98205,1.04298,-1.52799),(-2.86903,1.20256,-1.65888),(-2.91305,1.19962,-1.73267),(-2.64343,1.23471,-1.71429),(-2.72146,1.23967,-1.64683),(-2.40869,1.2835,-1.60799),(-2.47476,1.46631,-1.38875),(-2.61145,1.7679,-1.5895),(-3.30582,1.63532,-1.58558),(-2.71767,1.95633,-1.3156),(-2.69456,1.94904,-1.3298),(-2.70043,1.95249,-1.39157),(-2.77593,1.94996,-1.38233),(-3.12598,1.87847,-1.64641),(-2.94885,1.92106,-1.63787),(-2.61066,1.76209,-1.60192),(-2.70206,1.75354,-1.65765),(-2.45191,1.5949,-1.69097),(-2.49186,1.6442,-1.62574),(-2.43674,1.58978,-1.67155),(-2.56733,1.19161,-1.27984),(-2.62773,1.37104,-1.25826),(-2.54803,1.38886,-1.24421),(-2.80458,1.04846,-1.28936),(-2.68277,1.11674,-1.23964),(-2.72546,1.09096,-1.20654),(-2.74677,1.46529,-1.15427),(-2.71233,1.44547,-1.19218),(-2.71973,1.48433,-1.18762),(-2.41423,1.42651,-1.75911),(-2.40343,1.45974,-1.74121),(-2.40693,1.35773,-1.70764),(-2.40635,1.41085,-1.66317),(-2.5098,1.65033,-1.62518),(-3.33156,1.51602,-1.69842),(-2.82316,1.90702,-1.53661),(-2.79647,1.94886,-1.34173),(-3.13581,1.85477,-1.48429),(-3.35177,1.62842,-1.48189),(-3.26676,1.70315,-1.55763),(-3.30122,1.68354,-1.4421),(-3.42879,1.5011,-1.57354),(-3.37782,1.41009,-1.65609),(-2.51048,1.64852,-1.60787),(-2.59248,1.74152,-1.57335),(-2.55751,1.66544,-1.55697),(-2.5385,1.66099,-1.50093),(-2.57297,1.74279,-1.5131),(-2.52935,1.65565,-1.47907),(-2.56894,1.74156,-1.44994),(-2.61087,1.60595,-1.31229),(-2.39001,1.36703,-1.58921),(-2.39433,1.2981,-1.61251),(-2.42969,1.50674,-1.59794),(-2.43731,1.25347,-1.63071),(-2.49505,1.22325,-1.64749),(-2.77278,1.22038,-1.61458),(-2.6789,1.46391,-1.74015),(-3.16685,1.59875,-1.71034),(-3.08688,1.41545,-1.71704),(-3.19635,1.56986,-1.70922),(-2.94909,1.30163,-.75482),(-3.28782,1.10542,-1.38812),(-3.35136,1.08124,-1.34696),(-3.34235,1.2286,-1.68264),(-3.16247,1.08957,-1.28913),(-3.25498,1.09325,-1.41284),(-3.12803,1.05561,-1.31452),(-3.22497,1.04596,-1.44213),(-3.0856,.93954,-1.50173),(-3.13439,.94701,-1.48633),(-3.17279,.97174,-1.6379),(-2.80499,1.2668,-1.01735),(-2.84534,1.38276,-1.03525),(-2.8161,1.31831,-1.02221),(-3.00042,1.46727,-.90219),(-3.17415,1.2842,-.81193),(-3.11477,1.32442,-.78104),(-3.19783,1.45277,-.77875),(-3.25416,1.41689,-.82047),(-3.45891,1.43745,-.96538),(-3.52142,1.35008,-1.16416),(-3.56657,1.41428,-1.16248),(-3.5216,1.09033,-1.33516),(-3.44646,1.02221,-1.26623),(-3.33431,1.01967,-1.14257),(-3.38333,1.08586,-1.17004),(-3.25828,1.07194,-1.01184),(-2.99115,1.26941,-.75821),(-2.96787,1.2981,-.73964),(-3.5422,1.32827,-1.30025),(-3.53191,1.4544,-1.1958),(-3.53969,1.22288,-1.35878),(-3.52074,1.24992,-1.39267),(-3.47605,1.14364,-1.40212),(-3.49344,1.11731,-1.37935),(-3.49309,1.41176,-1.4371),(-3.42133,1.38626,-1.61313),(-3.22407,1.76787,-1.52937),(-3.25003,1.73785,-1.40231),(-3.36876,1.61737,-1.45573),(-3.17219,1.83075,-.9793),(-3.19658,1.81494,-1.01263),(-3.25659,1.77425,-.91377),(-2.81584,1.532,-1.09892),(-2.41684,1.46938,-1.75419),(-3.43494,1.00925,-1.29056),(-3.56506,1.43854,-1.17938),(-3.56724,1.30857,-1.26675),(-3.11084,1.1992,-.8145),(-3.04743,1.12767,-.8543),(-3.44511,1.45587,-.94019),(-2.43245,1.42429,-1.77626),(-3.09973,1.01364,-1.32385),(-3.00502,1.03189,-1.19416),(-3.03261,1.05963,-1.17383),(-3.02891,1.56997,-.90219),(-2.69968,1.94613,-1.30597),(-2.99594,1.64523,-.92936),(-2.56473,1.53949,-1.34765),(-3.03451,1.1274,-1.04769),(-2.9982,1.1166,-1.0781),(-2.73081,1.32643,-1.2008),(-2.68808,1.20256,-1.18746),(-2.69467,1.24825,-1.20634),(-2.67016,1.21343,-1.19972),(-2.67904,1.52039,-1.23006),(-3.44666,1.08435,-1.37655),(-3.40671,1.14368,-1.41993),(-3.23153,1.08186,-1.19308),(-3.19032,1.08408,-1.05041),(-3.27221,1.0524,-1.16975),(-3.1472,1.09541,-1.07872),(-3.16646,1.07014,-.94134),(-3.14416,1.09117,-.9568),(-3.1396,1.48681,-.73704),(-3.05362,1.36286,-.75012),(-2.76807,1.06517,-1.17343),(-2.84595,1.00911,-1.25926),(-2.95372,.97501,-1.40988),(-3.08223,.98761,-1.32962),(-2.98406,1.5704,-.93667),(-2.81318,1.55039,-1.09192),(-2.4627,1.56613,-1.50378),(-2.48882,1.61718,-1.49553),(-2.51354,1.63918,-1.49929),(-3.22586,1.73905,-1.67998),(-3.23489,1.71195,-1.61585),(-3.10059,1.08453,-1.72741),(-3.18619,1.82378,-1.17817),(-3.13897,1.85396,-1.11421),(-3.12595,1.85953,-1.12867),(-3.22065,1.79867,-1.04594),(-3.39355,1.05408,-1.31347),(-3.49672,1.04452,-1.32081),(-3.46989,1.07668,-1.26566),(-3.40947,1.13532,-1.16725),(-3.48966,1.0386,-1.34895),(-3.41449,1.0361,-1.29937),(-3.46664,1.06498,-1.35948),(-3.09051,1.87468,-1.19906),(-3.16389,1.83786,-1.26301),(-3.15184,1.84047,-1.34572),(-2.70423,1.56805,-1.21778),(-2.96569,1.31923,-1.73632),(-3.00379,1.45438,-1.71768),(-3.04816,1.28777,-1.72837),(-2.9262,1.21536,-1.74323),(-2.97528,1.14372,-1.72791),(-2.98973,1.15647,-1.739),(-2.86771,1.14832,-1.5784),(-2.92967,1.15283,-1.64831),(-2.82272,1.18237,-1.5939),(-3.1977,1.77351,-1.59219),(-3.19509,1.79752,-1.66209),(-2.41592,1.46197,-1.52799),(-3.20533,1.79973,-1.37198),(-3.16373,1.83051,-1.49778),(-2.80478,1.93177,-1.24777),(-2.86509,1.92392,-1.16193),(-2.78173,1.92218,-1.2373),(-2.88593,1.93366,-1.17433),(-2.97099,1.91328,-1.09912),(-2.65179,1.13931,-1.2483),(-3.16386,.96089,-1.47435),(-3.19443,1.00357,-1.45825),(-3.29508,1.08659,-1.57915),(-3.28569,1.12279,-1.68737),(-2.71585,1.14624,-1.16322),(-3.00157,.95965,-1.37637),(-3.09157,1.88392,-1.05027),(-2.98366,1.75614,-.99384),(-2.94605,1.76676,-1.02922),(-2.82474,1.26354,-.98029),(-3.07551,1.11532,-1.00408),(-3.11909,1.10209,-.97388),(-2.99295,1.1461,-.93727),(-3.05174,1.235,-.78636),(-2.95992,1.46621,-.94513),(-2.94277,1.42699,-.9445),(-3.45682,1.47939,-1.52542),(-3.39097,1.6091,-1.27584),(-3.3993,1.59723,-1.40854),(-3.43455,1.55338,-1.33838),(-3.34861,1.65249,-1.35258),(-3.28633,1.73425,-1.14258),(-3.29771,1.70728,-1.29663),(-3.34759,1.66468,-1.21332),(-3.24515,1.76516,-1.2545),(-3.10504,1.82135,-.94801),(-2.94638,1.65108,-.9826),(-2.93544,1.56473,-.98714),(-2.98854,1.55738,-.94145),(-2.93155,1.57677,-.98141),(-2.83739,1.31356,-.98001),(-2.87394,1.31027,-.93736),(-3.56765,1.1979,-1.32939),(-3.51891,1.09134,-1.3671),(-2.63135,1.19141,-1.22761),(-2.65544,1.17662,-1.21573),(-2.64668,1.22764,-1.21576),(-2.67948,1.1618,-1.20384),(-2.69665,1.34568,-1.23572),(-2.86223,1.43932,-1.03956),(-2.90254,1.41725,-.9855),(-2.91959,1.4652,-.98806),(-2.42504,1.34623,-1.71653),(-3.20161,1.09973,-1.25895),(-3.06525,1.09227,-1.14972),(-3.10425,1.10962,-1.11769),(-2.4857,1.44783,-1.35132),(-2.66996,1.2642,-1.22898),(-3.30547,1.72758,-.84549),(-3.34534,1.67282,-.97263),(-3.28177,1.739,-.88514),(-3.4783,1.51743,-1.14339),(-3.50661,1.49748,-1.11492),(-3.42485,1.57958,-1.06708),(-2.95222,1.90416,-1.08499),(-2.88319,1.56637,-1.03623),(-2.88108,1.58048,-1.02979),(-3.05716,.973,-1.34197),(-2.44742,1.32131,-1.73694),(-2.85641,1.10352,-1.46489),(-2.93025,1.09456,-1.54051),(-3.35434,1.31442,-.91404),(-3.36845,1.29857,-.93974),(-3.53705,1.48198,-1.08844),(-3.01697,1.43785,-.71904),(-3.10089,1.51115,-.72452),(-3.03118,1.12155,-.87199),(-2.86258,1.27423,-1.74746),(-3.24591,1.66589,-1.70027),(-3.2138,1.73355,-1.69202),(-3.27685,1.13443,-1.69973),(-2.89882,1.65044,-1.02737),(-3.32493,1.66808,-1.39734),(-3.22401,1.78358,-1.31689),(-3.27387,1.72263,-1.34946),(-3.32184,1.69555,-1.03094),(-3.39803,1.62215,-1.13001),(-3.43396,1.56591,-1.19912),(-3.45173,1.21315,-1.16293),(-3.40119,1.26306,-1.05864),(-3.34997,1.55761,-.84531),(-3.17608,1.21124,-1.71934),(-2.92019,1.49315,-1.71829),(-3.08995,1.64325,-1.71058),(-2.98816,1.70126,-1.71086),(-2.88275,1.35058,-1.74424),(-2.76902,1.40067,-1.74224),(-2.53095,1.26176,-1.74636),(-2.59851,1.20278,-1.60963),(-2.4618,1.33055,-1.29478),(-2.49412,1.42628,-1.29338),(-2.88827,1.78309,-1.08362),(-2.79392,1.80129,-1.17414),(-3.40133,1.63997,-.87356),(-3.36108,1.67601,-.83295)]))),
        Shape(DEF='rfmphal',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfmphal_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,24,25,26,-1,25,27,26,-1,28,29,30,-1,28,31,29,-1,32,33,34,-1,33,35,34,-1,36,23,37,-1,36,38,23,-1,39,40,9,-1,36,41,42,-1,36,37,41,-1,13,15,43,-1,44,45,39,-1,44,46,45,-1,47,48,49,-1,50,51,52,-1,50,53,51,-1,54,55,56,-1,54,57,55,-1,49,3,58,-1,59,10,60,-1,10,12,60,-1,61,62,63,-1,64,8,65,-1,64,11,8,-1,66,67,68,-1,69,70,71,-1,71,72,69,-1,73,74,75,-1,76,77,78,-1,79,80,32,-1,32,34,79,-1,32,80,81,-1,80,82,81,-1,63,62,83,-1,62,4,83,-1,84,85,86,-1,85,87,86,-1,88,89,90,-1,88,91,89,-1,92,93,94,-1,94,95,92,-1,43,19,13,-1,96,97,98,-1,99,100,101,-1,44,39,9,-1,7,65,8,-1,102,22,103,-1,102,23,22,-1,92,104,93,-1,105,106,107,-1,108,68,67,-1,5,58,3,-1,109,89,91,-1,3,49,48,-1,26,110,24,-1,26,111,110,-1,112,77,113,-1,75,114,115,-1,116,117,118,-1,119,120,24,-1,24,110,119,-1,69,121,122,-1,123,124,62,-1,62,61,123,-1,125,126,127,-1,126,128,127,-1,129,130,131,-1,129,132,130,-1,10,53,133,-1,10,59,53,-1,38,134,135,-1,38,136,134,-1,9,11,44,-1,11,64,44,-1,1,61,63,-1,0,109,91,-1,137,21,135,-1,135,60,137,-1,7,16,65,-1,16,138,65,-1,95,43,92,-1,98,139,96,-1,101,140,99,-1,72,121,69,-1,8,133,6,-1,141,38,36,-1,37,23,142,-1,81,143,32,-1,143,33,32,-1,144,27,70,-1,27,25,70,-1,69,122,145,-1,146,147,148,-1,104,7,6,-1,6,93,104,-1,133,11,10,-1,133,8,11,-1,40,12,9,-1,75,74,149,-1,149,108,75,-1,75,108,114,-1,108,67,114,-1,150,72,151,-1,150,121,72,-1,107,150,105,-1,149,152,127,-1,152,149,74,-1,125,78,84,-1,125,153,78,-1,154,112,145,-1,154,155,112,-1,107,121,150,-1,121,107,122,-1,151,71,90,-1,151,72,71,-1,123,156,120,-1,123,88,156,-1,119,5,124,-1,118,5,119,-1,84,77,85,-1,84,78,77,-1,118,58,5,-1,118,117,58,-1,29,157,30,-1,29,158,157,-1,29,52,158,-1,52,29,159,-1,6,94,93,-1,6,50,94,-1,7,15,16,-1,104,15,7,-1,160,54,56,-1,97,54,160,-1,96,45,161,-1,139,45,96,-1,40,100,137,-1,100,40,101,-1,39,101,40,-1,140,101,39,-1,71,25,156,-1,70,25,71,-1,162,144,76,-1,162,27,144,-1,152,162,153,-1,163,162,152,-1,164,143,81,-1,164,165,143,-1,166,167,168,-1,166,169,167,-1,170,146,148,-1,170,171,146,-1,142,102,172,-1,142,23,102,-1,141,136,38,-1,2,136,141,-1,173,158,174,-1,157,158,173,-1,105,151,175,-1,105,150,151,-1,138,132,176,-1,132,138,130,-1,46,161,45,-1,161,46,177,-1,104,43,15,-1,92,43,104,-1,178,43,95,-1,178,179,43,-1,34,47,79,-1,28,47,34,-1,98,140,139,-1,140,98,99,-1,180,181,182,-1,183,181,180,-1,184,102,103,-1,184,171,102,-1,138,64,65,-1,138,176,64,-1,99,22,100,-1,99,103,22,-1,59,135,134,-1,59,60,135,-1,43,17,19,-1,43,179,17,-1,185,131,186,-1,129,131,185,-1,84,126,125,-1,126,84,86,-1,168,187,166,-1,168,188,187,-1,132,57,177,-1,132,129,57,-1,136,51,134,-1,136,174,51,-1,167,186,165,-1,167,185,186,-1,189,126,188,-1,126,189,128,-1,89,151,90,-1,89,175,151,-1,141,42,109,-1,42,141,36,-1,116,119,110,-1,118,119,116,-1,116,114,117,-1,116,115,114,-1,145,113,69,-1,112,113,145,-1,113,76,144,-1,76,113,77,-1,115,110,111,-1,115,116,110,-1,73,26,163,-1,73,111,26,-1,28,48,47,-1,30,48,28,-1,189,81,82,-1,189,164,81,-1,166,190,148,-1,190,166,187,-1,181,148,190,-1,148,181,170,-1,37,191,41,-1,191,37,142,-1,172,191,142,-1,183,191,172,-1,109,2,141,-1,109,0,2,-1,66,58,67,-1,66,49,58,-1,192,108,149,-1,108,192,68,-1,106,154,107,-1,154,106,180,-1,124,4,62,-1,4,124,5,-1,147,55,169,-1,147,56,55,-1,174,52,51,-1,158,52,174,-1,137,12,40,-1,60,12,137,-1,14,131,130,-1,131,14,18,-1,35,17,179,-1,35,33,17,-1,177,54,161,-1,54,177,57,-1,53,6,133,-1,50,6,53,-1,135,23,38,-1,23,135,21,-1,160,171,184,-1,146,171,160,-1,165,20,143,-1,165,186,20,-1,178,29,31,-1,29,178,159,-1,61,88,123,-1,61,91,88,-1,182,85,155,-1,85,182,87,-1,128,149,127,-1,128,192,149,-1,157,63,83,-1,157,173,63,-1,41,106,105,-1,191,106,41,-1,106,183,180,-1,106,191,183,-1,190,182,181,-1,190,87,182,-1,87,187,86,-1,190,187,87,-1,128,82,192,-1,128,189,82,-1,192,80,68,-1,192,82,80,-1,80,66,68,-1,79,66,80,-1,75,111,73,-1,115,111,75,-1,69,144,70,-1,113,144,69,-1,74,163,152,-1,74,73,163,-1,175,109,42,-1,175,89,109,-1,164,188,168,-1,188,164,189,-1,1,173,2,-1,1,63,173,-1,185,169,55,-1,185,167,169,-1,86,188,126,-1,188,86,187,-1,129,55,57,-1,129,185,55,-1,186,18,20,-1,131,18,186,-1,159,95,94,-1,95,159,178,-1,134,53,59,-1,53,134,51,-1,97,184,98,-1,97,160,184,-1,44,176,46,-1,64,176,44,-1,98,103,99,-1,98,184,103,-1,170,183,172,-1,170,181,183,-1,155,180,182,-1,180,155,154,-1,66,47,49,-1,66,79,47,-1,179,31,35,-1,31,179,178,-1,176,177,46,-1,177,176,132,-1,14,138,16,-1,130,138,14,-1,42,105,175,-1,42,41,105,-1,174,2,173,-1,174,136,2,-1,171,172,102,-1,172,171,170,-1,148,169,166,-1,148,147,169,-1,165,168,167,-1,168,165,164,-1,35,28,34,-1,35,31,28,-1,24,156,25,-1,120,156,24,-1,163,27,162,-1,26,27,163,-1,76,153,162,-1,78,153,76,-1,22,137,100,-1,22,21,137,-1,45,140,39,-1,140,45,139,-1,161,97,96,-1,161,54,97,-1,56,146,160,-1,147,146,56,-1,17,143,20,-1,17,33,143,-1,14,19,18,-1,19,14,13,-1,52,94,50,-1,52,159,94,-1,48,4,3,-1,83,4,48,-1,83,30,157,-1,30,83,48,-1,91,1,0,-1,61,1,91,-1,117,67,58,-1,117,114,67,-1,123,119,124,-1,123,120,119,-1,156,90,71,-1,156,88,90,-1,154,122,107,-1,122,154,145,-1,112,85,77,-1,112,155,85,-1,127,153,125,-1,127,152,153,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfmphal_Coord',point=[(-3.22933,.07117,3.11541),(-3.21913,.07219,3.11887),(-3.25787,.07651,3.19916),(-3.08816,.07618,3.02188),(-3.10166,.05942,3.01539),(-3.07476,.06806,2.94363),(-3.2073,.07203,3.45617),(-3.22146,.09662,3.48283),(-3.25987,.068,3.45844),(-3.38643,.0519,3.41879),(-3.31998,.06306,3.4287),(-3.32487,.05951,3.44121),(-3.37895,.05111,3.4045),(-3.22209,.17369,3.45392),(-3.24436,.18436,3.45889),(-3.22263,.14487,3.47941),(-3.24354,.1418,3.48874),(-3.20772,.18052,3.34727),(-3.24105,.19847,3.40937),(-3.22039,.1847,3.41079),(-3.22616,.19707,3.34597),(-3.38668,.06769,3.30055),(-3.39642,.0761,3.29926),(-3.37795,.07995,3.25044),(-3.16422,.12819,2.93253),(-3.20297,.12717,2.92787),(-3.18181,.21162,2.94424),(-3.22075,.20546,2.94411),(-3.17552,.11811,3.21919),(-3.18876,.0904,3.29431),(-3.17964,.08749,3.22006),(-3.1887,.11064,3.29165),(-3.17877,.19754,3.21607),(-3.19753,.18398,3.28447),(-3.17553,.15942,3.21559),(-3.18864,.15186,3.28626),(-3.32341,.06477,3.18028),(-3.35317,.07737,3.16881),(-3.34319,.07127,3.26148),(-3.44751,.0753,3.41798),(-3.42727,.04538,3.38633),(-3.32927,.07701,3.0869),(-3.29976,.05825,3.09907),(-3.19782,.13927,3.40741),(-3.40301,.08879,3.43836),(-3.45978,.13091,3.4304),(-3.41584,.14221,3.43803),(-3.14865,.12535,3.14872),(-3.15198,.08338,3.14834),(-3.07539,.12685,3.04093),(-3.2028,.06967,3.40264),(-3.24405,.06912,3.34226),(-3.20253,.07858,3.34851),(-3.24927,.06489,3.39499),(-3.42018,.20132,3.37803),(-3.36813,.20968,3.32892),(-3.39679,.19907,3.32368),(-3.38796,.2033,3.38269),(-3.05214,.12744,2.99462),(-3.30982,.06953,3.38509),(-3.36164,.05289,3.36237),(-3.17935,.0763,2.99911),(-3.14108,.03953,3.0075),(-3.19693,.06652,3.12881),(-3.34222,.10372,3.45128),(-3.27893,.10056,3.47439),(-3.10129,.19136,3.06432),(-3.06569,.21938,2.99438),(-3.09892,.25664,3.06705),(-3.27569,.13166,2.92522),(-3.23769,.12717,2.9258),(-3.23465,.07753,2.89508),(-3.27522,.07408,2.89682),(-3.14804,.284,2.94786),(-3.15068,.32204,2.94542),(-3.08944,.28464,2.96082),(-3.30061,.28237,2.94599),(-3.33426,.277,2.94338),(-3.31004,.31713,2.93851),(-3.14932,.16753,3.14746),(-3.1434,.22666,3.15259),(-3.19668,.22937,3.21256),(-3.17711,.25747,3.14647),(-3.16455,.06893,3.14332),(-3.31966,.32516,2.9485),(-3.34796,.27466,2.956),(-3.30757,.29974,3.03029),(-3.34594,.26214,3.02322),(-3.19249,.0647,2.89713),(-3.2452,.03761,2.98606),(-3.23268,.06231,2.90156),(-3.19704,.07648,2.99537),(-3.19133,.10583,3.43396),(-3.19265,.08812,3.44597),(-3.18985,.08249,3.40538),(-3.19292,.10519,3.40619),(-3.45324,.16813,3.40059),(-3.43332,.18597,3.37112),(-3.43378,.13387,3.36787),(-3.4242,.0905,3.35379),(-3.41747,.05984,3.34384),(-3.43676,.05944,3.37521),(-3.38099,.11465,3.25484),(-3.40434,.10258,3.30431),(-3.20578,.10941,3.47667),(-3.3129,.05543,2.97433),(-3.33263,.10929,2.97015),(-3.33421,.10273,2.93903),(-3.07711,.28068,2.97919),(-3.26065,.05884,3.10777),(-3.12803,.13403,2.94338),(-3.14313,.21785,2.94542),(-3.34257,.18827,2.94846),(-3.30159,.18916,2.94662),(-3.07102,.21888,2.97408),(-3.08728,.21775,2.96558),(-3.08251,.13574,2.95745),(-3.05753,.13018,2.97365),(-3.07605,.08439,2.93193),(-3.10954,.07159,2.91437),(-3.16085,.07608,2.8957),(-3.29922,.0905,2.90855),(-3.31771,.11611,2.92393),(-3.1623,.0653,2.90139),(-3.11039,.05575,2.92195),(-3.26353,.3513,2.94841),(-3.25948,.32598,3.04196),(-3.21753,.35242,2.95264),(-3.21277,.31666,3.04582),(-3.34337,.20804,3.39142),(-3.29235,.18951,3.4454),(-3.28533,.20296,3.40198),(-3.3522,.19056,3.42592),(-3.25495,.06647,3.44378),(-3.29924,.07344,3.33377),(-3.35362,.06208,3.31192),(-3.28882,.07731,3.28199),(-3.40194,.04852,3.34516),(-3.29487,.14959,3.47063),(-3.46666,.13163,3.41523),(-3.45605,.08586,3.40558),(-3.3025,.06235,3.18483),(-3.3607,.09291,3.17092),(-3.21456,.2017,3.28293),(-3.26045,.19664,2.94885),(-3.33028,.14904,2.93529),(-3.38732,.18906,3.26795),(-3.37776,.20252,3.27135),(-3.36752,.21677,3.18891),(-3.14947,.33239,2.95971),(-3.30684,.07232,2.91958),(-3.27552,.06173,2.90712),(-3.21438,.34147,2.9391),(-3.26015,.33999,2.93595),(-3.3505,.14769,2.95417),(-3.35729,.18596,2.96464),(-3.19423,.07516,2.89112),(-3.19434,.07262,3.21679),(-3.20278,.07837,3.29392),(-3.19192,.08826,3.34979),(-3.41061,.18075,3.31922),(-3.44521,.17566,3.41543),(-3.24188,.2825,2.94237),(-3.19684,.28357,2.94345),(-3.24398,.24378,3.20969),(-3.2571,.21614,3.28031),(-3.33051,.23865,3.19763),(-3.311,.22772,3.27731),(-3.29416,.25429,3.20481),(-3.34803,.21605,3.27516),(-3.37274,.16251,3.17542),(-3.38883,.15162,3.25893),(-3.36616,.12771,3.17316),(-3.2205,.06996,3.20916),(-3.23892,.07336,3.28952),(-3.2815,.03596,2.982),(-3.35582,.15076,3.44526),(-3.4065,.18458,3.42045),(-3.1918,.10792,3.34891),(-3.19431,.14557,3.34684),(-3.346,.14894,2.98111),(-3.35897,.17386,3.09268),(-3.35702,.19053,2.99203),(-3.34793,.14076,3.09149),(-3.41274,.14273,3.3134),(-3.32714,.21786,3.33437),(-3.27115,.20955,3.34115),(-3.31051,.26127,3.12012),(-3.27548,.28086,3.13231),(-3.22864,.27137,3.13884),(-3.34567,.24167,3.10793),(-3.34421,.10812,3.09108),(-3.15226,.2962,3.05515)]))),
        Shape(DEF='rfmphal2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfmphal2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,7,10,8,-1,11,12,13,-1,14,8,15,-1,8,16,15,-1,17,18,19,-1,19,20,17,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,17,30,28,-1,30,31,28,-1,30,17,20,-1,23,32,33,-1,33,32,34,-1,34,35,33,-1,36,37,38,-1,38,33,36,-1,39,40,41,-1,41,42,39,-1,43,42,44,-1,42,41,44,-1,45,22,21,-1,21,46,45,-1,47,42,48,-1,49,50,51,-1,26,30,52,-1,17,28,18,-1,4,53,54,-1,5,55,56,-1,26,57,30,-1,27,58,28,-1,58,18,28,-1,59,49,60,-1,51,11,15,-1,15,61,51,-1,62,9,63,-1,62,64,9,-1,65,66,67,-1,67,61,65,-1,68,10,7,-1,69,70,71,-1,44,0,2,-1,72,42,43,-1,35,73,36,-1,74,42,47,-1,74,75,45,-1,75,22,45,-1,76,32,75,-1,47,77,74,-1,78,79,73,-1,73,35,78,-1,36,33,35,-1,80,7,81,-1,80,68,7,-1,16,66,65,-1,82,63,83,-1,82,62,63,-1,62,84,64,-1,62,85,84,-1,51,60,49,-1,29,60,67,-1,29,59,60,-1,31,30,57,-1,86,87,88,-1,88,89,86,-1,19,90,20,-1,19,6,90,-1,52,30,20,-1,71,91,25,-1,70,0,12,-1,66,16,92,-1,32,76,34,-1,39,45,46,-1,43,44,79,-1,44,2,79,-1,48,78,93,-1,48,72,78,-1,42,72,48,-1,50,49,70,-1,49,71,70,-1,71,59,91,-1,71,49,59,-1,12,50,70,-1,31,57,91,-1,23,22,32,-1,22,75,32,-1,86,6,3,-1,86,90,6,-1,89,94,90,-1,90,86,89,-1,89,95,94,-1,10,16,8,-1,28,31,29,-1,0,96,12,-1,56,84,97,-1,84,56,98,-1,81,9,64,-1,81,7,9,-1,99,100,101,-1,99,80,100,-1,54,5,4,-1,55,5,54,-1,10,92,16,-1,68,92,10,-1,58,54,53,-1,58,101,54,-1,87,84,85,-1,97,84,87,-1,102,103,104,-1,88,103,102,-1,105,106,107,-1,108,106,105,-1,25,57,26,-1,91,57,25,-1,73,2,109,-1,79,2,73,-1,110,21,107,-1,46,21,110,-1,34,77,93,-1,34,76,77,-1,70,1,0,-1,69,1,70,-1,12,111,112,-1,12,96,111,-1,106,113,114,-1,113,106,104,-1,115,116,95,-1,115,117,116,-1,29,91,59,-1,29,31,91,-1,4,19,53,-1,4,6,19,-1,60,61,67,-1,51,61,60,-1,14,9,8,-1,63,9,14,-1,82,85,62,-1,82,103,85,-1,27,101,58,-1,27,99,101,-1,66,99,27,-1,92,99,66,-1,52,95,116,-1,94,95,52,-1,117,38,37,-1,115,38,117,-1,11,50,12,-1,11,51,50,-1,111,110,114,-1,110,111,40,-1,104,82,113,-1,104,103,82,-1,89,102,95,-1,102,89,88,-1,78,43,79,-1,78,72,43,-1,74,76,75,-1,77,76,74,-1,112,13,12,-1,112,83,13,-1,74,39,42,-1,74,45,39,-1,115,105,38,-1,105,115,108,-1,107,114,110,-1,107,106,114,-1,113,83,112,-1,113,82,83,-1,96,40,111,-1,40,96,41,-1,41,0,44,-1,41,96,0,-1,71,24,69,-1,71,25,24,-1,109,1,118,-1,2,1,109,-1,37,118,117,-1,37,109,118,-1,26,116,24,-1,52,116,26,-1,27,67,66,-1,67,27,29,-1,98,80,81,-1,100,80,98,-1,63,13,83,-1,63,14,13,-1,16,61,15,-1,65,61,16,-1,97,86,3,-1,97,87,86,-1,52,90,94,-1,52,20,90,-1,24,117,118,-1,116,117,24,-1,95,108,115,-1,102,108,95,-1,114,112,111,-1,112,114,113,-1,69,118,1,-1,24,118,69,-1,93,47,48,-1,93,77,47,-1,23,38,105,-1,23,33,38,-1,40,46,110,-1,46,40,39,-1,36,109,37,-1,73,109,36,-1,34,78,35,-1,78,34,93,-1,107,23,105,-1,107,21,23,-1,108,104,106,-1,102,104,108,-1,85,88,87,-1,85,103,88,-1,56,100,98,-1,55,100,56,-1,53,18,58,-1,19,18,53,-1,101,55,54,-1,100,55,101,-1,80,92,68,-1,99,92,80,-1,14,11,13,-1,14,15,11,-1,64,98,81,-1,98,64,84,-1,3,56,97,-1,3,5,56,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfmphal2_Coord',point=[(-3.6427,.19123,2.75659),(-3.69666,.14495,2.74097),(-3.65712,.12989,2.67248),(-3.90921,.13904,2.98841),(-3.89886,.12035,2.99778),(-3.89484,.13675,3.00609),(-3.90964,.12454,2.98062),(-3.74985,.23422,3.06458),(-3.69848,.19183,3.04011),(-3.75325,.25314,3.04901),(-3.70928,.18374,3.05763),(-3.71131,.22103,2.87622),(-3.69396,.24383,2.82898),(-3.71902,.23469,2.87895),(-3.71413,.22195,2.95519),(-3.70651,.20867,2.9496),(-3.69419,.17038,3.04794),(-3.85819,.09252,2.91778),(-3.85646,.08116,2.95292),(-3.90304,.0792,2.95178),(-3.89765,.10971,2.90662),(-3.82332,.26639,2.62677),(-3.80796,.25273,2.63917),(-3.86055,.21925,2.63866),(-3.81782,.11258,2.8036),(-3.81604,.12382,2.85305),(-3.82862,.12046,2.85261),(-3.78912,.09359,3.02676),(-3.81296,.09338,2.96101),(-3.79235,.09764,2.96447),(-3.85784,.10136,2.9021),(-3.80932,.10617,2.94821),(-3.83954,.16045,2.6359),(-3.85903,.14898,2.63867),(-3.73534,.14715,2.62615),(-3.73976,.129,2.62355),(-3.81189,.10038,2.62861),(-3.82309,.09053,2.64253),(-3.86898,.14534,2.6438),(-3.69785,.31201,2.68362),(-3.70002,.32206,2.69427),(-3.65585,.26438,2.71984),(-3.66204,.26104,2.70536),(-3.62714,.19679,2.69706),(-3.62291,.19584,2.71156),(-3.77523,.27842,2.6434),(-3.7854,.30834,2.6363),(-3.7001,.20202,2.67413),(-3.66713,.20032,2.66939),(-3.74373,.1512,2.86087),(-3.6993,.18045,2.8369),(-3.71084,.17644,2.86718),(-3.88819,.11502,2.8475),(-3.88497,.0719,2.99405),(-3.86781,.12188,3.02457),(-3.86963,.13922,3.02507),(-3.883,.17553,3.01868),(-3.82167,.12119,2.91338),(-3.83458,.07571,3.00529),(-3.78028,.12346,2.90778),(-3.73677,.12964,2.89718),(-3.69833,.15841,2.92947),(-3.82396,.24519,2.96658),(-3.75684,.25983,2.97065),(-3.82199,.22772,3.03704),(-3.69119,.14126,2.99471),(-3.72432,.1114,3.02332),(-3.73027,.11521,2.94904),(-3.73188,.17862,3.06844),(-3.73615,.14974,2.81233),(-3.68572,.18357,2.81452),(-3.75764,.15215,2.85005),(-3.64983,.19856,2.67484),(-3.73409,.0994,2.62853),(-3.74194,.21866,2.66731),(-3.77013,.20263,2.65559),(-3.74166,.17212,2.64809),(-3.71558,.18642,2.6588),(-3.67366,.1601,2.64136),(-3.65626,.13467,2.65758),(-3.79504,.16081,3.06387),(-3.81371,.21382,3.05085),(-3.8386,.27457,2.87736),(-3.76938,.27483,2.8875),(-3.8556,.21227,3.02153),(-3.86643,.23121,2.96004),(-3.91835,.1597,2.93165),(-3.90425,.19754,2.95174),(-3.91377,.22014,2.86013),(-3.91311,.17148,2.85258),(-3.9161,.14377,2.92222),(-3.80787,.12388,2.91233),(-3.7307,.16208,3.06649),(-3.68319,.16915,2.64114),(-3.90896,.15461,2.85058),(-3.91523,.16065,2.77869),(-3.67004,.25694,2.76647),(-3.89563,.18749,3.0067),(-3.84869,.19789,3.03263),(-3.79191,.14523,3.06211),(-3.82928,.14802,3.04565),(-3.82705,.13248,3.04494),(-3.9197,.22905,2.78064),(-3.88042,.25632,2.87091),(-3.89019,.26981,2.79746),(-3.8756,.22298,2.64539),(-3.86948,.2764,2.70842),(-3.84002,.27803,2.63317),(-3.89921,.22526,2.70615),(-3.74111,.09126,2.64157),(-3.79295,.31469,2.64123),(-3.72389,.30796,2.75818),(-3.75807,.29234,2.83263),(-3.84221,.29145,2.81582),(-3.818,.30605,2.71489),(-3.89471,.15165,2.70636),(-3.88548,.10614,2.79204),(-3.85907,.09774,2.71366),(-3.7806,.10208,2.71686)]))),
        Shape(DEF='rfmphal3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfmphal3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,18,21,19,-1,22,23,24,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,29,32,30,-1,26,33,34,-1,26,28,33,-1,35,30,36,-1,37,38,39,-1,37,40,38,-1,31,41,42,-1,42,43,31,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,51,8,52,-1,53,40,54,-1,54,55,53,-1,11,56,9,-1,57,58,59,-1,59,60,57,-1,59,61,25,-1,25,60,59,-1,62,63,64,-1,62,65,63,-1,66,56,11,-1,66,67,56,-1,0,2,68,-1,16,69,17,-1,4,70,5,-1,70,71,5,-1,53,72,73,-1,53,74,72,-1,14,75,12,-1,76,61,59,-1,76,77,61,-1,78,26,34,-1,79,80,23,-1,81,35,36,-1,32,22,24,-1,82,83,84,-1,85,86,58,-1,85,87,86,-1,42,41,75,-1,75,14,42,-1,88,89,12,-1,31,43,90,-1,90,29,31,-1,91,3,5,-1,17,69,47,-1,47,49,17,-1,92,68,2,-1,93,94,20,-1,93,95,94,-1,96,97,29,-1,29,90,96,-1,6,9,56,-1,98,99,100,-1,100,101,98,-1,49,48,102,-1,102,103,49,-1,46,45,104,-1,43,39,38,-1,43,42,39,-1,84,33,82,-1,33,28,82,-1,105,106,23,-1,106,79,23,-1,27,26,78,-1,78,107,27,-1,77,88,83,-1,101,108,98,-1,92,109,68,-1,109,110,68,-1,89,13,12,-1,6,8,9,-1,104,111,46,-1,10,112,11,-1,108,113,98,-1,5,114,91,-1,2,115,92,-1,103,44,46,-1,103,102,44,-1,116,104,64,-1,116,111,104,-1,63,21,18,-1,66,21,63,-1,6,113,7,-1,117,113,6,-1,99,118,119,-1,99,98,118,-1,15,120,16,-1,15,1,120,-1,115,70,4,-1,2,70,115,-1,3,121,122,-1,3,91,121,-1,95,123,94,-1,95,114,123,-1,104,62,64,-1,104,45,62,-1,99,48,100,-1,99,102,48,-1,47,124,125,-1,47,69,124,-1,126,92,127,-1,126,109,92,-1,128,129,93,-1,128,130,129,-1,118,67,65,-1,118,117,67,-1,108,131,132,-1,131,108,101,-1,133,134,135,-1,133,136,134,-1,110,0,68,-1,110,137,0,-1,88,76,89,-1,88,77,76,-1,138,87,139,-1,138,86,87,-1,140,137,141,-1,136,137,140,-1,97,142,105,-1,96,142,97,-1,10,72,74,-1,10,143,72,-1,21,144,19,-1,21,112,144,-1,82,77,83,-1,77,82,61,-1,79,107,78,-1,107,79,106,-1,35,75,41,-1,35,81,75,-1,88,145,83,-1,12,145,88,-1,146,23,80,-1,146,24,23,-1,146,84,147,-1,146,33,84,-1,126,54,148,-1,126,130,54,-1,108,7,113,-1,149,7,108,-1,107,150,27,-1,107,151,150,-1,87,152,140,-1,87,85,152,-1,153,154,155,-1,153,156,154,-1,157,52,149,-1,157,158,52,-1,73,96,90,-1,96,73,72,-1,14,39,42,-1,14,159,39,-1,138,13,89,-1,138,160,13,-1,51,161,162,-1,161,51,151,-1,152,132,134,-1,152,157,132,-1,127,115,122,-1,127,92,115,-1,128,54,130,-1,54,128,55,-1,119,65,62,-1,118,65,119,-1,101,125,131,-1,125,101,100,-1,120,135,124,-1,120,133,135,-1,110,141,137,-1,141,110,154,-1,71,49,103,-1,71,17,49,-1,46,114,5,-1,46,123,114,-1,111,123,46,-1,153,39,159,-1,153,37,39,-1,53,38,40,-1,53,73,38,-1,160,139,156,-1,160,138,139,-1,158,50,52,-1,158,57,50,-1,8,162,9,-1,8,51,162,-1,161,105,142,-1,105,161,106,-1,36,32,24,-1,32,36,30,-1,145,36,147,-1,145,81,36,-1,83,147,84,-1,83,145,147,-1,80,78,34,-1,79,78,80,-1,143,9,162,-1,143,10,9,-1,106,151,107,-1,151,106,161,-1,60,27,150,-1,60,25,27,-1,159,156,153,-1,159,160,156,-1,46,71,103,-1,46,5,71,-1,15,71,70,-1,15,17,71,-1,155,110,109,-1,155,154,110,-1,140,134,136,-1,134,140,152,-1,132,149,108,-1,132,157,149,-1,117,56,67,-1,6,56,117,-1,144,128,19,-1,55,128,144,-1,121,93,129,-1,121,95,93,-1,148,109,126,-1,148,155,109,-1,124,131,125,-1,124,135,131,-1,58,158,85,-1,58,57,158,-1,150,57,60,-1,150,50,57,-1,58,76,59,-1,58,86,76,-1,160,14,13,-1,160,159,14,-1,90,38,73,-1,43,38,90,-1,142,162,161,-1,142,143,162,-1,74,55,144,-1,74,53,55,-1,37,155,148,-1,37,153,155,-1,156,141,154,-1,156,139,141,-1,85,157,152,-1,85,158,157,-1,151,50,150,-1,151,51,50,-1,149,8,7,-1,52,8,149,-1,148,40,37,-1,148,54,40,-1,129,122,121,-1,127,122,129,-1,24,147,36,-1,24,146,147,-1,34,146,80,-1,34,33,146,-1,12,81,145,-1,75,81,12,-1,30,41,31,-1,30,35,41,-1,97,32,29,-1,97,22,32,-1,82,25,61,-1,82,28,25,-1,116,20,94,-1,20,116,18,-1,74,112,10,-1,144,112,74,-1,72,142,96,-1,72,143,142,-1,105,22,97,-1,105,23,22,-1,133,1,0,-1,133,120,1,-1,140,139,87,-1,140,141,139,-1,86,89,76,-1,89,86,138,-1,136,0,137,-1,0,136,133,-1,135,132,131,-1,135,134,132,-1,65,66,63,-1,65,67,66,-1,93,19,128,-1,20,19,93,-1,130,127,129,-1,130,126,127,-1,48,125,100,-1,48,47,125,-1,45,119,62,-1,119,45,44,-1,94,111,116,-1,94,123,111,-1,91,95,121,-1,91,114,95,-1,4,122,115,-1,4,3,122,-1,15,2,1,-1,15,70,2,-1,124,16,120,-1,124,69,16,-1,119,102,99,-1,44,102,119,-1,98,117,118,-1,98,113,117,-1,112,66,11,-1,112,21,66,-1,64,18,116,-1,63,18,64,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfmphal3_Coord',point=[(-4.16408,.14424,2.04131),(-4.16998,.13669,2.01746),(-4.07984,.19119,2.01008),(-3.98154,.29286,2.04412),(-4.01339,.25341,2.02174),(-4.07245,.30679,2.02478),(-4.18779,.34038,2.1383),(-4.22433,.30785,2.12555),(-4.22792,.28826,2.17589),(-4.17838,.33648,2.19485),(-4.11633,.34488,2.20771),(-4.14283,.36394,2.1486),(-4.16073,.17237,2.32457),(-4.16815,.19894,2.30067),(-4.07816,.22057,2.3173),(-4.17235,.14694,2.00469),(-4.19236,.14505,2.00582),(-4.20549,.18572,2.00491),(-4.09047,.4022,2.06983),(-4.06539,.36639,2.12193),(-4.05494,.3836,2.07882),(-4.09863,.37793,2.11123),(-4.08859,.31364,2.37115),(-4.13267,.31334,2.36879),(-4.1165,.28072,2.37622),(-4.3163,.20178,2.29514),(-4.32545,.23103,2.31272),(-4.32209,.2319,2.29451),(-4.3156,.2023,2.3085),(-4.04,.30167,2.35799),(-4.02562,.27115,2.36791),(-4.02095,.27576,2.35716),(-4.05279,.29652,2.3719),(-4.29718,.20838,2.32789),(-4.31246,.2428,2.32173),(-4.03311,.2431,2.36514),(-4.08166,.24058,2.37088),(-4.04355,.25124,2.21513),(-4.04839,.27441,2.28312),(-4.05947,.25125,2.28374),(-4.03753,.27708,2.22131),(-4.02687,.24197,2.35455),(-4.04589,.24699,2.3258),(-4.03805,.27235,2.32598),(-4.20486,.38987,1.99669),(-4.16566,.41525,2.00222),(-4.13096,.37789,2.01778),(-4.27526,.21485,1.99858),(-4.28919,.26255,2.00192),(-4.25867,.24147,2.00281),(-4.26288,.2468,2.22419),(-4.24751,.27499,2.22723),(-4.25405,.25518,2.16856),(-4.05722,.31299,2.22306),(-4.01173,.28,2.16868),(-4.04598,.32277,2.16392),(-4.16086,.35674,2.14434),(-4.25321,.21778,2.2259),(-4.24072,.18973,2.23136),(-4.26393,.1814,2.27307),(-4.29356,.20783,2.2693),(-4.29156,.16761,2.30004),(-4.16752,.42139,2.01576),(-4.12439,.40582,2.05996),(-4.12176,.43169,2.03447),(-4.16125,.40447,2.04685),(-4.13021,.3811,2.11037),(-4.15625,.37859,2.10703),(-4.09053,.19474,2.03774),(-4.23662,.15813,2.01008),(-4.08503,.20061,1.99765),(-4.13595,.25208,2.01236),(-4.09164,.3284,2.2757),(-4.06297,.31025,2.2778),(-4.08308,.33829,2.21887),(-4.05645,.20659,2.34772),(-4.23752,.17136,2.27588),(-4.24531,.15564,2.30792),(-4.31297,.2547,2.31587),(-4.24579,.29496,2.33355),(-4.24127,.27877,2.34402),(-4.05996,.20915,2.3582),(-4.2901,.16949,2.31305),(-4.2392,.15591,2.32169),(-4.26864,.17614,2.32713),(-4.22824,.18827,2.17272),(-4.21849,.18614,2.23563),(-4.20051,.17933,2.17042),(-4.22625,.15587,2.3116),(-4.2108,.17185,2.28192),(-4.05265,.30431,2.32796),(-3.98107,.31398,2.04805),(-4.0183,.23488,2.05668),(-4.01751,.35746,2.08349),(-4.04276,.40642,2.05403),(-4.00697,.37046,2.05986),(-4.08206,.32575,2.32847),(-4.08392,.32382,2.35668),(-4.23783,.35174,2.0305),(-4.24602,.36406,2.00066),(-4.29857,.26137,2.01227),(-4.28911,.26466,2.03654),(-4.24016,.36062,1.98602),(-4.20162,.31894,2.00876),(-4.12114,.42384,2.01848),(-4.13406,.32574,2.34725),(-4.23838,.30535,2.31238),(-4.2996,.26168,2.29595),(-4.27731,.26467,2.07204),(-4.03302,.22559,2.09221),(-4.10338,.19382,2.08166),(-4.07931,.41815,2.03198),(-4.10499,.36298,2.15103),(-4.22586,.32807,2.08627),(-4.01183,.36699,2.04638),(-4.00823,.24134,2.03307),(-4.07876,.42434,2.04841),(-4.19244,.35416,2.10124),(-4.19953,.37988,2.03501),(-4.20799,.3947,2.00782),(-4.18829,.13525,2.01804),(-3.97191,.31506,2.06475),(-3.97071,.28356,2.05872),(-4.04537,.39985,2.03694),(-4.24249,.15232,2.02259),(-4.28455,.21233,2.00959),(-3.9943,.26013,2.12242),(-3.97858,.27347,2.08555),(-4.03182,.33785,2.12291),(-3.9778,.29963,2.09177),(-3.99286,.28391,2.12965),(-4.26957,.21363,2.03664),(-4.25652,.21364,2.07497),(-4.18441,.14215,2.04159),(-4.22769,.1655,2.07657),(-4.23367,.15837,2.04454),(-4.18454,.15083,2.07614),(-4.16341,.15308,2.07705),(-4.19469,.18917,2.24382),(-4.17297,.18319,2.17538),(-4.1875,.16257,2.12032),(-4.16279,.16752,2.12837),(-4.12859,.32653,2.31755),(-4.12401,.33248,2.26993),(-4.07316,.352,2.16076),(-4.16634,.17413,2.33503),(-4.22356,.24102,2.35517),(-4.19276,.20222,2.34829),(-4.01562,.25504,2.16387),(-4.26352,.26114,2.1129),(-4.29656,.23664,2.26649),(-4.27635,.26202,2.27036),(-4.22724,.1755,2.11815),(-4.07333,.23194,2.20434),(-4.11751,.20305,2.13625),(-4.05379,.22873,2.14833),(-4.13243,.21301,2.19073),(-4.25132,.21549,2.11537),(-4.24636,.21839,2.17186),(-4.08938,.23014,2.27847),(-4.16019,.21299,2.26095),(-4.22246,.30652,2.28834),(-4.20097,.32014,2.24865)]))),
        Shape(DEF='rfmphal4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfmphal4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,1,-1,21,23,22,-1,8,7,24,-1,25,26,27,-1,28,29,30,-1,30,31,28,-1,32,33,34,-1,32,35,33,-1,36,14,13,-1,37,38,39,-1,38,40,39,-1,41,42,43,-1,41,44,42,-1,16,45,17,-1,46,47,48,-1,46,49,47,-1,50,51,18,-1,50,52,51,-1,53,54,43,-1,43,42,53,-1,55,56,57,-1,57,58,55,-1,53,59,60,-1,53,61,59,-1,62,63,64,-1,63,65,64,-1,22,2,1,-1,66,67,68,-1,69,66,70,-1,66,71,70,-1,72,5,4,-1,13,71,40,-1,13,5,71,-1,73,58,57,-1,73,74,58,-1,20,19,25,-1,52,50,75,-1,50,76,75,-1,77,60,59,-1,59,78,77,-1,11,49,46,-1,11,16,49,-1,26,34,33,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,31,88,28,-1,89,19,51,-1,90,91,92,-1,92,93,90,-1,94,95,90,-1,95,91,90,-1,96,13,12,-1,67,66,97,-1,2,22,98,-1,99,100,101,-1,99,102,100,-1,103,10,104,-1,103,45,10,-1,105,106,107,-1,107,108,105,-1,50,18,20,-1,20,109,50,-1,52,110,51,-1,52,111,110,-1,45,16,10,-1,112,8,113,-1,112,6,8,-1,37,39,68,-1,36,13,114,-1,115,74,73,-1,115,110,74,-1,116,83,82,-1,116,73,57,-1,57,81,116,-1,26,117,27,-1,26,33,117,-1,86,80,79,-1,118,100,102,-1,118,119,100,-1,120,65,121,-1,120,122,65,-1,38,37,123,-1,37,124,123,-1,97,66,69,-1,18,51,19,-1,123,125,126,-1,123,7,125,-1,11,10,16,-1,38,114,13,-1,13,40,38,-1,112,15,17,-1,127,5,72,-1,128,2,98,-1,68,39,66,-1,106,121,129,-1,121,106,105,-1,9,104,10,-1,9,120,104,-1,7,130,125,-1,7,6,130,-1,126,38,123,-1,38,126,114,-1,101,97,99,-1,67,97,101,-1,69,2,128,-1,69,70,2,-1,127,131,0,-1,127,72,131,-1,4,62,132,-1,4,3,62,-1,96,129,63,-1,96,12,129,-1,107,114,126,-1,107,36,114,-1,124,68,133,-1,37,68,124,-1,134,135,136,-1,134,137,135,-1,65,138,64,-1,122,138,65,-1,108,104,105,-1,108,103,104,-1,119,139,100,-1,119,140,139,-1,141,102,98,-1,141,118,102,-1,20,77,109,-1,142,77,20,-1,143,144,145,-1,143,78,144,-1,102,128,98,-1,99,128,102,-1,146,79,56,-1,146,86,79,-1,95,48,55,-1,46,48,95,-1,9,94,147,-1,9,11,94,-1,129,65,63,-1,129,121,65,-1,117,35,148,-1,33,35,117,-1,56,81,57,-1,79,81,56,-1,116,115,73,-1,116,82,115,-1,19,84,149,-1,84,19,89,-1,86,150,87,-1,150,86,146,-1,88,151,85,-1,32,151,88,-1,152,80,151,-1,80,152,83,-1,136,131,132,-1,131,136,135,-1,153,93,154,-1,155,93,153,-1,92,110,111,-1,110,92,74,-1,24,123,124,-1,7,123,24,-1,113,15,112,-1,15,113,156,-1,59,157,158,-1,59,61,157,-1,145,76,143,-1,76,145,159,-1,154,160,153,-1,154,75,160,-1,94,161,147,-1,94,90,161,-1,58,92,91,-1,92,58,74,-1,60,142,162,-1,60,77,142,-1,100,133,101,-1,100,139,133,-1,153,21,137,-1,153,160,21,-1,132,64,136,-1,62,64,132,-1,122,161,138,-1,122,147,161,-1,130,45,103,-1,45,130,17,-1,113,140,157,-1,140,113,8,-1,144,119,118,-1,144,158,119,-1,160,23,21,-1,160,159,23,-1,89,110,115,-1,89,51,110,-1,30,54,148,-1,54,30,43,-1,41,150,47,-1,29,150,41,-1,85,28,88,-1,28,85,87,-1,26,152,34,-1,26,149,152,-1,149,83,152,-1,84,83,149,-1,83,81,80,-1,83,116,81,-1,146,47,150,-1,48,47,146,-1,15,49,16,-1,44,49,15,-1,61,42,156,-1,61,53,42,-1,162,27,117,-1,27,162,142,-1,50,143,76,-1,50,109,143,-1,75,111,52,-1,75,154,111,-1,96,5,13,-1,96,3,5,-1,70,5,127,-1,70,71,5,-1,39,71,66,-1,71,39,40,-1,159,141,23,-1,141,159,145,-1,124,139,24,-1,139,124,133,-1,126,108,107,-1,108,126,125,-1,161,134,138,-1,134,161,155,-1,135,0,131,-1,135,1,0,-1,117,54,162,-1,117,148,54,-1,119,157,140,-1,157,119,158,-1,44,47,49,-1,44,41,47,-1,53,162,54,-1,53,60,162,-1,91,55,58,-1,91,95,55,-1,157,156,113,-1,157,61,156,-1,161,93,155,-1,90,93,161,-1,75,159,160,-1,75,76,159,-1,78,158,144,-1,78,59,158,-1,29,43,30,-1,29,41,43,-1,156,44,15,-1,44,156,42,-1,154,92,111,-1,93,92,154,-1,137,155,153,-1,134,155,137,-1,34,151,32,-1,151,34,152,-1,31,32,88,-1,35,32,31,-1,151,86,85,-1,151,80,86,-1,25,149,26,-1,149,25,19,-1,82,89,115,-1,82,84,89,-1,87,29,28,-1,87,150,29,-1,31,148,35,-1,31,30,148,-1,120,147,122,-1,120,9,147,-1,46,94,11,-1,46,95,94,-1,56,48,146,-1,48,56,55,-1,118,145,144,-1,141,145,118,-1,109,78,143,-1,77,78,109,-1,25,142,20,-1,27,142,25,-1,23,98,22,-1,23,141,98,-1,139,8,24,-1,140,8,139,-1,125,103,108,-1,130,103,125,-1,138,136,64,-1,138,134,136,-1,137,1,135,-1,137,21,1,-1,133,67,101,-1,68,67,133,-1,106,36,107,-1,14,36,106,-1,3,63,62,-1,3,96,63,-1,72,132,131,-1,72,4,132,-1,0,70,127,-1,70,0,2,-1,69,99,97,-1,128,99,69,-1,17,6,112,-1,6,17,130,-1,105,120,121,-1,120,105,104,-1,129,14,106,-1,129,12,14,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfmphal4_Coord',point=[(-4.40469,.31423,1.55955),(-4.4147,.30696,1.58041),(-4.46683,.26569,1.545),(-4.40475,.43208,1.5786),(-4.37645,.38339,1.57707),(-4.46948,.37325,1.5604),(-4.61997,.38473,1.6045),(-4.62727,.40359,1.56806),(-4.62903,.33463,1.58113),(-4.50788,.41556,1.67051),(-4.54541,.41485,1.66833),(-4.51334,.39725,1.70659),(-4.48346,.47063,1.58515),(-4.53418,.4332,1.56046),(-4.52781,.47273,1.57434),(-4.61561,.34713,1.67681),(-4.57072,.38857,1.69517),(-4.58515,.39299,1.65618),(-4.54192,.26661,1.73886),(-4.53595,.24341,1.75012),(-4.57308,.24149,1.72121),(-4.42941,.29605,1.61168),(-4.47863,.26783,1.56732),(-4.49127,.26535,1.60163),(-4.63159,.33929,1.54279),(-4.58491,.22652,1.73817),(-4.59647,.22544,1.74728),(-4.59581,.22591,1.73596),(-4.66622,.3095,1.75547),(-4.65552,.31774,1.73785),(-4.67204,.28976,1.7355),(-4.67046,.28834,1.75007),(-4.65055,.2678,1.76431),(-4.64156,.23389,1.74945),(-4.62457,.24017,1.76219),(-4.66488,.26252,1.74681),(-4.56845,.46292,1.55905),(-4.6232,.33899,1.50978),(-4.62359,.40865,1.53682),(-4.60323,.31801,1.50992),(-4.57256,.36354,1.53091),(-4.6365,.32087,1.71484),(-4.63747,.30397,1.68708),(-4.65129,.29716,1.71049),(-4.62272,.33602,1.69502),(-4.562,.40807,1.66388),(-4.51158,.38711,1.73456),(-4.59274,.36229,1.7324),(-4.5127,.38201,1.75882),(-4.58041,.37459,1.7155),(-4.53724,.27849,1.72197),(-4.47633,.28828,1.75419),(-4.47947,.29196,1.7376),(-4.62609,.27791,1.68737),(-4.64623,.27099,1.71183),(-4.4752,.38198,1.76834),(-4.47849,.37834,1.79358),(-4.44615,.35955,1.79371),(-4.45343,.36358,1.76692),(-4.5987,.2534,1.66969),(-4.60361,.25207,1.69406),(-4.61836,.28025,1.67028),(-4.39988,.4348,1.59084),(-4.44092,.46362,1.59583),(-4.41116,.42142,1.61136),(-4.45246,.4424,1.61374),(-4.56545,.26985,1.52324),(-4.59415,.23616,1.51675),(-4.61792,.28987,1.50323),(-4.52687,.23084,1.53382),(-4.47238,.27454,1.53505),(-4.52722,.31952,1.54156),(-4.3781,.36345,1.57227),(-4.43407,.33688,1.79189),(-4.44459,.33542,1.76386),(-4.46832,.29676,1.6988),(-4.51756,.27859,1.68621),(-4.58236,.24873,1.69743),(-4.57341,.24655,1.66712),(-4.48403,.36811,1.80619),(-4.50879,.33741,1.80956),(-4.45767,.35362,1.80604),(-4.44596,.30866,1.78875),(-4.48445,.30277,1.80307),(-4.46706,.27797,1.7813),(-4.60687,.33296,1.78122),(-4.51888,.3667,1.80424),(-4.61142,.34794,1.77252),(-4.66518,.29845,1.76025),(-4.46324,.27647,1.77178),(-4.4581,.36919,1.71869),(-4.46062,.36828,1.74041),(-4.45072,.33603,1.7437),(-4.4407,.33743,1.7156),(-4.48159,.39157,1.71611),(-4.48396,.38399,1.73938),(-4.44366,.45827,1.58094),(-4.54918,.22557,1.53118),(-4.51955,.22851,1.56782),(-4.54415,.21688,1.54344),(-4.59711,.22835,1.55921),(-4.59711,.22818,1.5262),(-4.54296,.22293,1.56522),(-4.55878,.43016,1.6285),(-4.53382,.43352,1.63427),(-4.53075,.45604,1.60649),(-4.52913,.47891,1.58992),(-4.57101,.46795,1.57099),(-4.56614,.45288,1.59291),(-4.56442,.25127,1.70403),(-4.45227,.31245,1.76273),(-4.45646,.31149,1.74302),(-4.61402,.36316,1.64149),(-4.62855,.32602,1.63105),(-4.59952,.43957,1.54474),(-4.44029,.30854,1.77918),(-4.43901,.33187,1.80137),(-4.64206,.23283,1.73773),(-4.54993,.22747,1.59599),(-4.59482,.23639,1.58942),(-4.5009,.43254,1.63745),(-4.49367,.45566,1.61207),(-4.46485,.42372,1.64535),(-4.6284,.4121,1.54909),(-4.63133,.33701,1.51859),(-4.59832,.42956,1.57966),(-4.60405,.44286,1.5585),(-4.40964,.32586,1.55008),(-4.52337,.22146,1.54561),(-4.4828,.47569,1.59852),(-4.59218,.41063,1.61848),(-4.36865,.35414,1.58466),(-4.36803,.38375,1.59196),(-4.6266,.2865,1.51299),(-4.39771,.34846,1.64562),(-4.38197,.34487,1.60668),(-4.38023,.36648,1.61292),(-4.39904,.32946,1.63878),(-4.42926,.39942,1.6451),(-4.62394,.28557,1.54198),(-4.61803,.2831,1.58406),(-4.52633,.23281,1.59924),(-4.59018,.24051,1.71724),(-4.54935,.25124,1.6721),(-4.56267,.23912,1.63503),(-4.53611,.24476,1.64267),(-4.51831,.37915,1.78542),(-4.47513,.40645,1.67878),(-4.66505,.26279,1.73484),(-4.54163,.24424,1.75959),(-4.60577,.35896,1.75394),(-4.59124,.29916,1.78963),(-4.56567,.26593,1.78179),(-4.4227,.32126,1.67511),(-4.44489,.31437,1.70907),(-4.42003,.34097,1.67992),(-4.62983,.31372,1.66887),(-4.61794,.28198,1.63144),(-4.59497,.24456,1.6341),(-4.50625,.27054,1.65061),(-4.45057,.29506,1.66204),(-4.44714,.38076,1.68026),(-4.61902,.24821,1.71398)]))),
        Shape(DEF='rlcun',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,1),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rlcun_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,1,6,2,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,14,16,15,-1,17,18,10,-1,19,20,21,-1,21,22,19,-1,2,23,0,-1,24,25,26,-1,27,28,29,-1,28,30,29,-1,30,31,29,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,38,39,36,-1,40,41,42,-1,43,44,45,-1,44,46,45,-1,40,47,41,-1,47,48,41,-1,49,50,51,-1,52,53,51,-1,51,50,52,-1,54,55,56,-1,57,54,58,-1,57,59,54,-1,60,61,62,-1,62,46,60,-1,54,56,58,-1,63,64,65,-1,66,67,68,-1,68,69,66,-1,70,71,72,-1,73,74,75,-1,73,76,74,-1,77,78,79,-1,77,80,78,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,87,90,88,-1,91,41,48,-1,92,34,93,-1,34,94,93,-1,95,96,66,-1,49,97,50,-1,20,12,98,-1,99,100,101,-1,102,37,103,-1,38,104,105,-1,14,106,107,-1,29,108,109,-1,38,110,111,-1,38,105,110,-1,112,111,28,-1,112,39,111,-1,113,114,115,-1,116,68,117,-1,116,118,68,-1,119,67,120,-1,119,117,67,-1,66,69,95,-1,18,121,122,-1,121,123,122,-1,49,124,125,-1,84,126,127,-1,84,86,126,-1,128,129,130,-1,131,35,132,-1,133,102,134,-1,135,104,136,-1,135,105,104,-1,137,138,136,-1,136,139,137,-1,140,141,142,-1,9,137,7,-1,143,7,144,-1,7,142,144,-1,144,145,146,-1,146,143,144,-1,62,147,148,-1,149,83,82,-1,149,52,83,-1,52,150,83,-1,151,152,57,-1,147,62,153,-1,51,59,49,-1,55,154,155,-1,152,151,156,-1,151,157,156,-1,158,56,55,-1,159,160,91,-1,161,92,93,-1,93,162,161,-1,163,164,165,-1,165,166,163,-1,33,167,168,-1,169,163,166,-1,164,163,94,-1,94,34,164,-1,160,170,91,-1,160,171,170,-1,172,144,142,-1,142,173,172,-1,58,56,158,-1,59,51,54,-1,120,49,59,-1,151,57,58,-1,83,123,81,-1,153,174,147,-1,175,3,5,-1,175,176,3,-1,177,1,0,-1,178,8,7,-1,137,142,7,-1,137,139,142,-1,139,136,179,-1,136,104,179,-1,135,136,138,-1,138,180,135,-1,103,134,102,-1,181,182,141,-1,181,183,182,-1,140,181,141,-1,140,32,181,-1,43,126,184,-1,43,127,126,-1,185,186,85,-1,187,100,21,-1,188,125,124,-1,124,49,67,-1,68,67,117,-1,36,189,37,-1,190,30,28,-1,191,13,192,-1,13,15,192,-1,22,193,194,-1,22,191,193,-1,77,79,195,-1,195,196,77,-1,31,197,198,-1,31,199,197,-1,38,111,39,-1,35,131,200,-1,201,202,203,-1,201,204,202,-1,205,27,29,-1,51,53,206,-1,61,207,208,-1,118,209,68,-1,107,106,210,-1,210,211,107,-1,212,213,16,-1,16,107,212,-1,188,214,125,-1,214,215,125,-1,216,197,217,-1,93,218,162,-1,219,44,43,-1,43,184,219,-1,206,54,51,-1,65,75,63,-1,75,74,63,-1,191,21,100,-1,191,22,21,-1,79,220,195,-1,79,78,220,-1,209,64,63,-1,72,221,214,-1,188,72,214,-1,188,70,72,-1,152,119,120,-1,152,156,119,-1,152,120,59,-1,59,57,152,-1,154,54,206,-1,154,55,54,-1,61,208,153,-1,153,62,61,-1,42,222,90,-1,90,40,42,-1,219,223,60,-1,60,44,219,-1,224,42,41,-1,224,157,42,-1,49,120,67,-1,225,45,148,-1,148,145,225,-1,182,185,85,-1,85,173,182,-1,46,44,60,-1,226,36,39,-1,39,115,226,-1,164,227,165,-1,164,168,227,-1,226,115,228,-1,115,114,228,-1,132,140,179,-1,179,133,132,-1,27,202,28,-1,202,112,28,-1,204,229,112,-1,112,202,204,-1,230,80,77,-1,201,203,231,-1,231,232,201,-1,109,205,29,-1,7,233,178,-1,7,143,233,-1,6,1,234,-1,234,235,6,-1,194,19,22,-1,14,13,99,-1,18,11,10,-1,107,16,14,-1,192,193,191,-1,193,236,237,-1,236,193,192,-1,238,239,240,-1,239,238,241,-1,242,243,213,-1,243,242,244,-1,175,245,9,-1,175,246,245,-1,178,176,8,-1,178,23,176,-1,247,0,233,-1,0,247,177,-1,248,249,250,-1,248,121,249,-1,169,251,171,-1,252,251,169,-1,253,254,255,-1,253,256,254,-1,257,258,259,-1,257,260,258,-1,216,261,262,-1,216,263,261,-1,264,265,217,-1,264,266,265,-1,267,268,269,-1,268,267,270,-1,271,187,98,-1,187,271,272,-1,273,19,194,-1,273,274,19,-1,275,235,234,-1,235,275,276,-1,231,205,109,-1,231,203,205,-1,201,25,24,-1,201,232,25,-1,229,277,278,-1,277,229,204,-1,277,26,278,-1,277,24,26,-1,104,133,179,-1,133,104,102,-1,114,227,228,-1,114,165,227,-1,33,164,34,-1,33,168,164,-1,85,172,173,-1,84,172,85,-1,162,128,161,-1,128,162,129,-1,45,127,43,-1,127,45,225,-1,128,183,161,-1,183,128,279,-1,145,147,82,-1,148,147,145,-1,158,151,58,-1,158,222,151,-1,88,222,158,-1,90,222,88,-1,219,280,223,-1,281,280,219,-1,208,206,153,-1,208,154,206,-1,156,224,119,-1,156,157,224,-1,68,63,69,-1,209,63,68,-1,70,124,96,-1,70,188,124,-1,72,282,221,-1,72,71,282,-1,283,284,285,-1,286,284,283,-1,11,287,12,-1,288,287,11,-1,100,13,191,-1,100,99,13,-1,289,106,290,-1,289,210,106,-1,108,195,220,-1,195,108,198,-1,260,65,64,-1,65,260,257,-1,198,29,31,-1,198,108,29,-1,291,292,279,-1,293,292,291,-1,293,186,292,-1,184,281,219,-1,294,281,184,-1,295,293,291,-1,295,296,293,-1,130,297,298,-1,129,297,130,-1,73,265,282,-1,263,265,73,-1,125,97,49,-1,125,215,97,-1,282,266,221,-1,265,266,282,-1,269,287,286,-1,271,287,269,-1,192,243,236,-1,192,15,243,-1,107,299,212,-1,211,299,107,-1,28,110,190,-1,28,111,110,-1,264,300,270,-1,264,199,300,-1,301,214,285,-1,301,215,214,-1,254,113,278,-1,254,252,113,-1,64,253,260,-1,64,118,253,-1,64,209,118,-1,92,32,34,-1,181,32,92,-1,206,174,153,-1,206,53,174,-1,215,150,97,-1,150,215,301,-1,284,122,302,-1,122,284,288,-1,232,80,25,-1,232,78,80,-1,203,27,205,-1,203,202,27,-1,31,300,199,-1,300,31,289,-1,196,198,197,-1,195,198,196,-1,196,259,77,-1,196,262,259,-1,261,73,75,-1,73,261,263,-1,300,290,303,-1,300,289,290,-1,17,275,249,-1,274,275,17,-1,238,273,237,-1,238,276,273,-1,244,236,243,-1,244,241,236,-1,212,242,213,-1,180,242,212,-1,110,135,299,-1,110,105,135,-1,115,112,229,-1,39,112,115,-1,255,278,26,-1,254,278,255,-1,116,251,256,-1,251,116,304,-1,302,285,284,-1,285,302,301,-1,99,303,290,-1,303,99,101,-1,272,100,187,-1,272,101,100,-1,294,126,296,-1,294,184,126,-1,296,89,294,-1,296,295,89,-1,279,130,291,-1,279,128,130,-1,92,183,181,-1,161,183,92,-1,138,9,245,-1,137,9,138,-1,37,305,103,-1,37,189,305,-1,35,167,33,-1,35,200,167,-1,139,140,142,-1,139,179,140,-1,176,2,3,-1,23,2,176,-1,5,246,175,-1,5,239,246,-1,240,276,238,-1,276,240,235,-1,247,81,248,-1,247,146,81,-1,234,249,275,-1,249,234,250,-1,91,224,41,-1,91,170,224,-1,222,157,151,-1,222,42,157,-1,207,60,223,-1,207,61,60,-1,145,172,225,-1,172,145,144,-1,304,171,251,-1,171,304,170,-1,252,166,113,-1,169,166,252,-1,305,228,227,-1,305,189,228,-1,165,113,166,-1,113,165,114,-1,168,305,227,-1,305,168,167,-1,94,160,159,-1,160,94,163,-1,45,62,148,-1,45,46,62,-1,223,155,207,-1,280,155,223,-1,91,218,159,-1,91,48,218,-1,170,119,224,-1,170,304,119,-1,207,154,208,-1,207,155,154,-1,146,82,81,-1,146,145,82,-1,123,248,81,-1,123,121,248,-1,1,250,234,-1,1,177,250,-1,4,235,240,-1,235,4,6,-1,241,246,239,-1,241,244,246,-1,233,146,247,-1,233,143,146,-1,141,173,142,-1,182,173,141,-1,132,134,131,-1,132,133,134,-1,103,131,134,-1,131,103,200,-1,305,200,103,-1,167,200,305,-1,180,245,242,-1,245,180,138,-1,87,295,298,-1,87,89,295,-1,292,185,279,-1,292,186,185,-1,298,47,87,-1,298,297,47,-1,301,83,150,-1,301,302,83,-1,288,18,122,-1,11,18,288,-1,74,69,63,-1,95,69,74,-1,304,117,119,-1,117,304,116,-1,118,256,253,-1,256,118,116,-1,204,24,277,-1,24,204,201,-1,189,226,228,-1,189,36,226,-1,231,78,232,-1,231,220,78,-1,220,109,108,-1,220,231,109,-1,211,30,190,-1,211,210,30,-1,212,135,180,-1,135,212,299,-1,10,274,17,-1,19,274,10,-1,197,262,196,-1,262,197,216,-1,269,283,267,-1,286,283,269,-1,261,65,257,-1,75,65,261,-1,302,123,83,-1,123,302,122,-1,101,268,303,-1,272,268,101,-1,97,52,50,-1,52,97,150,-1,258,26,230,-1,255,26,258,-1,115,278,113,-1,278,115,229,-1,267,221,266,-1,283,221,267,-1,299,190,110,-1,190,299,211,-1,194,237,273,-1,194,193,237,-1,271,12,287,-1,98,12,271,-1,270,303,268,-1,303,270,300,-1,199,217,197,-1,217,199,264,-1,76,95,74,-1,76,96,95,-1,291,298,295,-1,130,298,291,-1,296,86,293,-1,296,126,86,-1,159,93,94,-1,93,159,218,-1,40,87,47,-1,40,90,87,-1,294,88,281,-1,89,88,294,-1,293,85,186,-1,86,85,293,-1,259,230,77,-1,259,258,230,-1,30,289,31,-1,30,210,289,-1,290,14,99,-1,14,290,106,-1,10,20,19,-1,10,12,20,-1,286,288,284,-1,286,287,288,-1,283,214,221,-1,283,285,214,-1,76,282,71,-1,282,76,73,-1,76,70,96,-1,76,71,70,-1,67,96,124,-1,66,96,67,-1,281,158,280,-1,88,158,281,-1,55,280,158,-1,55,155,280,-1,147,149,82,-1,147,174,149,-1,52,174,53,-1,149,174,52,-1,218,129,162,-1,297,129,218,-1,297,48,47,-1,297,218,48,-1,183,185,182,-1,185,183,279,-1,84,225,172,-1,127,225,84,-1,140,35,32,-1,140,132,35,-1,38,102,104,-1,38,37,102,-1,25,230,26,-1,80,230,25,-1,274,276,275,-1,276,274,273,-1,21,98,187,-1,21,20,98,-1,272,269,268,-1,272,271,269,-1,266,270,267,-1,270,266,264,-1,263,217,265,-1,217,263,216,-1,262,257,259,-1,262,261,257,-1,255,260,253,-1,258,260,255,-1,256,252,254,-1,256,251,252,-1,163,171,160,-1,169,171,163,-1,249,18,17,-1,249,121,18,-1,248,177,247,-1,248,250,177,-1,23,233,0,-1,233,23,178,-1,176,9,8,-1,176,175,9,-1,242,246,244,-1,245,246,242,-1,213,15,16,-1,15,213,243,-1,3,6,4,-1,2,6,3,-1,5,240,239,-1,5,4,240,-1,237,241,238,-1,241,237,236,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rlcun_Coord',point=[(-2.58259,1.31685,-1.05489),(-2.59245,1.26986,-.99651),(-2.6132,1.26612,-1.04874),(-2.65128,1.25688,-1.06146),(-2.65608,1.22369,-1.01661),(-2.69732,1.24112,-1.04071),(-2.61956,1.23706,-1.0071),(-2.65262,1.42812,-1.11263),(-2.66404,1.33465,-1.08392),(-2.73922,1.29678,-1.05588),(-2.68222,1.24229,-.57705),(-2.67956,1.26323,-.56471),(-2.69673,1.24717,-.56028),(-2.89629,1.22072,-.61287),(-2.9163,1.2391,-.60768),(-2.86481,1.20845,-.68114),(-2.87385,1.22731,-.68551),(-2.65841,1.25736,-.6495),(-2.66622,1.27936,-.64751),(-2.69401,1.19277,-.6112),(-2.7095,1.20211,-.59093),(-2.76924,1.18014,-.59957),(-2.76196,1.17348,-.61984),(-2.61786,1.31493,-1.0683),(-3.18301,1.87143,-.56833),(-3.19411,1.85994,-.5476),(-3.15772,1.8713,-.54007),(-3.099,1.59547,-.65187),(-3.07726,1.60579,-.67299),(-3.04193,1.48497,-.5628),(-3.01988,1.46012,-.56792),(-3.0201,1.48002,-.54557),(-2.81049,1.83465,-1.16286),(-2.89027,1.95856,-1.14227),(-2.87143,1.97924,-1.13598),(-2.83632,1.82042,-1.16108),(-3.15552,1.70865,-.80139),(-3.04821,1.63274,-.8522),(-3.03076,1.61535,-.83186),(-3.13412,1.72638,-.76902),(-2.61067,2.09973,-.87768),(-2.61793,2.10655,-.86412),(-2.59521,2.10891,-.85465),(-2.51793,1.62918,-1.0789),(-2.48431,1.62755,-1.03984),(-2.52047,1.61001,-1.07518),(-2.48886,1.6098,-1.0343),(-2.66054,2.09509,-.94413),(-2.67359,2.10769,-.93587),(-2.66788,1.79041,-.61631),(-2.64544,1.75686,-.78057),(-2.63942,1.77786,-.80026),(-2.62723,1.66901,-.8102),(-2.61467,1.68096,-.82761),(-2.55195,1.83197,-.83751),(-2.53496,1.81794,-.8478),(-2.54077,1.83959,-.84315),(-2.58799,1.86518,-.72329),(-2.54496,1.85318,-.83435),(-2.62399,1.85967,-.72925),(-2.47565,1.61805,-1.02693),(-2.497,1.57374,-.95603),(-2.51079,1.56051,-.97287),(-2.84573,1.93573,-.25367),(-2.87118,1.94197,-.25917),(-2.87389,1.9274,-.25486),(-2.69675,1.88755,-.43853),(-2.70903,1.8877,-.4627),(-2.77104,1.96189,-.35902),(-2.75583,1.94705,-.33837),(-2.70446,1.685,-.41264),(-2.73563,1.67013,-.37124),(-2.70644,1.59684,-.39154),(-2.79134,1.72751,-.35319),(-2.82154,1.86034,-.29891),(-2.84253,1.85009,-.29607),(-2.76388,1.73877,-.35102),(-3.22114,1.78324,-.44404),(-3.29853,1.77159,-.52621),(-3.27813,1.74507,-.50383),(-3.23231,1.80788,-.47286),(-2.6158,1.39691,-.8678),(-2.58603,1.52203,-.88471),(-2.65195,1.4978,-.74132),(-2.56651,1.62309,-1.14278),(-2.64567,1.65679,-1.17956),(-2.60409,1.67897,-1.13478),(-2.62205,2.01199,-.96692),(-2.5282,1.89985,-.95756),(-2.58151,1.8886,-1.0037),(-2.57514,2.01726,-.9133),(-2.70417,2.13192,-.86204),(-2.83763,1.97496,-1.14398),(-2.81069,2.06242,-1.08327),(-2.85347,2.07161,-1.04406),(-2.73042,1.87594,-.38635),(-2.69923,1.78041,-.42906),(-2.64923,1.68395,-.64616),(-2.72264,1.22966,-.57353),(-2.89996,1.23319,-.59256),(-2.84143,1.20198,-.60503),(-2.86114,1.24239,-.58068),(-2.92908,1.55056,-.94125),(-2.978,1.67815,-.92989),(-2.9148,1.53659,-.92157),(-2.95381,1.53591,-.83615),(-2.96645,1.31039,-.59223),(-2.91132,1.30657,-.66749),(-3.1313,1.52933,-.54902),(-3.14152,1.53275,-.61318),(-2.98275,1.52173,-.7427),(-3.05496,1.62789,-.755),(-3.14245,1.71087,-.68799),(-3.06677,1.92636,-.70417),(-3.16983,1.84977,-.8278),(-3.20374,1.81186,-.7828),(-2.80655,1.99768,-.44053),(-2.76942,1.97551,-.44612),(-2.83002,1.97606,-.36317),(-2.70717,2.00132,-.562),(-2.65713,1.90478,-.58822),(-2.63318,1.30195,-.76541),(-2.66644,1.33925,-.6097),(-2.64151,1.36521,-.75902),(-2.70917,1.76762,-.44481),(-2.70128,1.68821,-.46037),(-2.55297,1.69759,-1.08246),(-2.52639,1.62783,-1.08904),(-2.80387,1.98195,-1.16724),(-2.77495,2.04048,-1.09887),(-2.75314,1.99544,-1.1098),(-2.86949,1.71524,-1.08656),(-2.7904,1.62982,-1.14939),(-2.85314,1.56336,-1.04094),(-2.91858,1.60187,-.97281),(-2.90294,1.44582,-.84235),(-2.843,1.4608,-.93142),(-2.75432,1.37075,-1.03932),(-2.78755,1.33184,-.95135),(-2.77594,1.49353,-1.01995),(-2.76503,1.63327,-1.14776),(-2.75009,1.71918,-1.17678),(-2.65869,1.56514,-1.13979),(-2.60414,1.42948,-1.09823),(-2.59623,1.54518,-1.09578),(-2.57061,1.54633,-1.03196),(-2.59589,1.42791,-.99234),(-2.57119,1.54179,-.89358),(-2.55389,1.56532,-1.02861),(-2.60867,1.57293,-.84017),(-2.65054,1.59088,-.69374),(-2.59403,1.97809,-.7763),(-2.63124,1.92278,-.59762),(-2.54031,1.57362,-.84663),(-2.5394,1.70359,-.82038),(-2.50987,1.73391,-.87372),(-2.68186,2.01043,-.57759),(-2.63957,2.06892,-.72241),(-2.52039,1.89544,-.93774),(-2.77558,2.11633,-.94088),(-2.79083,2.10939,-.87505),(-2.82264,1.9855,-1.16869),(-2.79545,2.05328,-1.09626),(-2.90887,2.05552,-.92645),(-3.00105,1.95323,-1.00462),(-3.11662,1.90196,-.89818),(-2.98766,1.98463,-.81857),(-2.9789,1.86759,-1.0252),(-3.00991,1.93171,-1.02197),(-2.93563,2.00672,-.79161),(-2.74149,2.08957,-.7136),(-2.83662,2.04786,-.74091),(-2.57008,1.60435,-1.14263),(-2.65656,1.64212,-1.18247),(-2.59331,1.58635,-.85297),(-2.7318,1.27714,-1.05573),(-2.65749,1.30984,-1.08425),(-2.57761,1.31905,-.98857),(-2.62148,1.33889,-1.0692),(-2.83011,1.54899,-1.03035),(-2.81744,1.31328,-.86207),(-2.79206,1.85355,-1.16793),(-2.75399,1.76466,-1.20811),(-2.78392,1.87109,-1.18725),(-2.52616,1.70084,-1.05952),(-2.73975,1.7725,-1.20673),(-2.72258,1.7715,-1.19187),(-2.78274,1.21338,-.58473),(-2.71669,1.67722,-.43033),(-3.12104,1.74225,-.85018),(-3.00576,1.49783,-.64784),(-2.83441,1.18399,-.6269),(-2.84033,1.18336,-.67289),(-2.80787,1.16709,-.66267),(-2.74786,1.17042,-.63821),(-3.21373,1.63964,-.51787),(-3.12796,1.69934,-.46265),(-3.03785,1.58963,-.49014),(-3.12586,1.53404,-.53056),(-2.97819,1.50702,-.51166),(-2.90294,1.76807,-1.05282),(-3.29854,1.79688,-.60913),(-3.15644,1.69706,-.66401),(-3.21119,1.65059,-.64301),(-3.25242,1.82147,-.65546),(-3.13383,1.54786,-.63538),(-2.55863,1.70598,-.81005),(-2.4955,1.62971,-.91252),(-2.52374,1.58895,-.84912),(-2.85237,1.95257,-.27886),(-2.99499,1.39247,-.57862),(-2.96646,1.40916,-.65786),(-2.86207,1.30324,-.75887),(-2.8403,1.21755,-.76823),(-2.70193,1.5573,-.41258),(-2.69029,1.59552,-.48618),(-2.9742,1.62818,-.44973),(-2.96713,1.6129,-.45615),(-2.73644,2.08857,-1.01059),(-2.47494,1.69799,-1.01931),(-3.21967,1.63684,-.5359),(-2.71831,1.56353,-.39916),(-2.56741,2.01484,-.89067),(-2.46661,1.6922,-.99858),(-2.66316,2.06954,-.72922),(-2.52861,1.61004,-1.08574),(-3.19775,1.80143,-.81037),(-3.13049,1.88926,-.9173),(-3.18272,1.83785,-.84767),(-3.22968,1.81506,-.68039),(-3.2121,1.80567,-.44273),(-3.22526,1.63739,-.61504),(-3.30733,1.78633,-.58106),(-2.59413,1.34143,-1.05503),(-2.60767,1.23929,-.90358),(-2.644,1.20953,-.92097),(-2.80336,1.17709,-.75583),(-2.77,1.16384,-.74003),(-2.73056,1.17685,-.83422),(-2.72953,1.20881,-.95595),(-2.68964,1.19917,-.93727),(-2.76435,1.18811,-.85126),(-2.7996,1.23294,-.86644),(-2.83115,1.19967,-.76684),(-2.79137,1.21419,-.86411),(-2.77114,1.25556,-.96535),(-2.76268,1.23704,-.96554),(-2.58917,1.33902,-.98888),(-2.60116,1.31512,-.87352),(-2.62357,1.2807,-.7681),(-2.58997,1.29525,-.87369),(-2.89506,1.99549,-.58299),(-2.98164,1.96111,-.6436),(-2.96666,1.93892,-.42653),(-3.03404,1.92884,-.54752),(-3.06297,1.90532,-.48333),(-2.93869,1.96227,-.48638),(-3.01733,1.88002,-.31205),(-3.11604,1.85079,-.38019),(-3.12022,1.8319,-.37808),(-3.01818,1.89544,-.3176),(-2.96401,1.78309,-.36027),(-3.04663,1.74138,-.41148),(-2.90976,1.6665,-.40928),(-2.91845,1.52587,-.48399),(-2.89567,1.63596,-.42213),(-2.8582,1.54458,-.45631),(-2.8196,1.44735,-.48875),(-2.84126,1.33452,-.54329),(-2.782,1.34738,-.52635),(-2.87895,1.4302,-.50893),(-2.75635,1.28338,-.54701),(-2.80896,1.26279,-.56393),(-2.718,1.17267,-.71255),(-2.67439,1.19582,-.68626),(-2.64261,1.21609,-.79875),(-2.68335,1.18889,-.8164),(-3.16405,1.88603,-.60226),(-3.12778,1.89496,-.60859),(-2.76918,1.87482,-1.18584),(-2.48651,1.78106,-.96927),(-2.49424,1.78648,-.98933),(-2.762,1.66171,-.37164),(-2.7039,1.47077,-.44727),(-2.67676,1.3876,-.50302),(-2.6901,1.47838,-.45472),(-2.69052,1.38185,-.49383),(-2.69352,1.3149,-.52703),(-2.67825,1.31726,-.53773),(-2.98864,1.39398,-.56013),(-2.95877,1.31149,-.5756),(-2.7107,1.87498,-1.12605),(-2.72777,1.78125,-1.1921),(-2.65927,1.77809,-1.13241),(-2.54266,1.78542,-1.02942),(-2.641,1.87711,-1.06211),(-2.60099,1.784,-1.07815),(-2.72443,2.07581,-1.02048),(-2.69567,2.00315,-1.04982),(-2.93412,1.4285,-.74906),(-2.93641,1.4149,-.53368),(-2.68209,1.51121,-.53088),(-2.67407,1.4269,-.57558),(-2.90013,1.32155,-.56021),(-2.774,2.02524,-.54125),(-3.06762,1.79003,-.91973)]))),
        Shape(DEF='rmcun',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmcun_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,5,6,3,-1,7,8,9,-1,7,10,8,-1,3,11,12,-1,3,13,11,-1,0,14,1,-1,15,16,17,-1,16,18,17,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,40,41,38,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,5,4,51,-1,4,52,51,-1,53,54,55,-1,53,56,54,-1,57,58,59,-1,60,61,57,-1,61,58,57,-1,32,62,63,-1,64,65,66,-1,33,67,68,-1,33,69,67,-1,70,71,72,-1,73,74,75,-1,75,76,73,-1,77,78,79,-1,79,80,77,-1,80,81,77,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,88,91,89,-1,85,92,93,-1,93,86,85,-1,94,47,83,-1,94,95,47,-1,96,97,98,-1,31,99,29,-1,100,101,102,-1,100,103,101,-1,41,104,38,-1,105,51,106,-1,35,104,107,-1,100,108,109,-1,109,110,100,-1,111,112,113,-1,111,52,112,-1,114,115,116,-1,115,117,116,-1,118,119,120,-1,121,119,122,-1,123,119,124,-1,125,119,126,-1,127,128,129,-1,127,91,128,-1,127,130,89,-1,89,91,127,-1,131,132,25,-1,133,76,134,-1,135,136,137,-1,135,138,136,-1,32,139,33,-1,140,26,141,-1,141,142,140,-1,21,143,144,-1,21,145,143,-1,146,131,147,-1,143,24,148,-1,143,145,24,-1,149,150,151,-1,149,152,150,-1,129,153,127,-1,129,154,153,-1,155,156,157,-1,155,158,156,-1,159,160,56,-1,159,161,160,-1,68,34,33,-1,162,163,164,-1,165,47,166,-1,167,168,169,-1,167,170,168,-1,171,131,172,-1,171,132,131,-1,173,174,135,-1,173,135,152,-1,135,137,152,-1,175,75,74,-1,78,20,79,-1,146,176,177,-1,178,179,180,-1,181,182,179,-1,183,171,172,-1,172,184,183,-1,185,160,161,-1,161,186,185,-1,176,154,129,-1,187,82,188,-1,82,189,188,-1,190,191,192,-1,190,193,191,-1,194,23,25,-1,28,27,195,-1,27,196,195,-1,197,198,28,-1,198,199,28,-1,200,118,201,-1,202,203,204,-1,202,205,203,-1,206,207,64,-1,49,208,209,-1,30,50,31,-1,210,148,43,-1,210,143,148,-1,7,211,12,-1,7,212,211,-1,173,149,213,-1,173,152,149,-1,213,149,214,-1,215,13,216,-1,215,11,13,-1,4,12,211,-1,4,3,12,-1,217,108,100,-1,100,102,217,-1,218,219,220,-1,113,221,111,-1,113,222,221,-1,223,219,218,-1,218,224,223,-1,225,13,226,-1,225,216,13,-1,9,227,212,-1,212,7,9,-1,227,9,228,-1,42,44,229,-1,229,31,230,-1,43,148,231,-1,231,44,43,-1,48,50,30,-1,232,64,233,-1,234,235,236,-1,237,238,239,-1,238,240,239,-1,241,118,200,-1,242,119,118,-1,199,141,26,-1,193,243,191,-1,244,245,189,-1,246,18,130,-1,246,247,18,-1,177,176,86,-1,176,87,86,-1,180,179,182,-1,248,179,178,-1,80,70,81,-1,80,71,70,-1,76,249,73,-1,250,251,252,-1,250,150,251,-1,253,254,162,-1,255,165,256,-1,165,166,256,-1,63,139,32,-1,155,256,62,-1,257,258,259,-1,257,260,258,-1,46,254,47,-1,261,262,263,-1,261,264,262,-1,188,265,187,-1,266,45,95,-1,267,79,268,-1,267,269,79,-1,19,21,144,-1,177,172,146,-1,172,131,146,-1,144,210,270,-1,144,143,210,-1,92,271,93,-1,271,272,93,-1,34,158,32,-1,168,61,169,-1,61,55,169,-1,126,119,242,-1,124,119,125,-1,122,119,123,-1,120,119,121,-1,273,274,275,-1,276,207,48,-1,208,97,96,-1,208,277,97,-1,2,1,278,-1,50,230,31,-1,279,91,88,-1,279,128,91,-1,280,265,281,-1,95,45,47,-1,179,154,176,-1,179,248,154,-1,73,247,74,-1,74,246,175,-1,74,247,246,-1,282,283,284,-1,166,47,254,-1,166,253,63,-1,166,254,253,-1,139,69,33,-1,139,285,69,-1,49,207,286,-1,49,48,207,-1,68,67,287,-1,287,206,68,-1,155,258,256,-1,237,288,203,-1,288,234,203,-1,58,168,289,-1,58,61,168,-1,234,288,235,-1,239,290,291,-1,239,292,290,-1,209,109,50,-1,209,293,109,-1,228,294,227,-1,228,295,294,-1,50,49,209,-1,26,28,199,-1,228,296,297,-1,298,39,38,-1,35,38,104,-1,34,68,66,-1,299,99,31,-1,25,300,131,-1,301,22,19,-1,301,302,22,-1,73,249,303,-1,303,282,73,-1,129,87,176,-1,276,29,233,-1,304,199,305,-1,2,306,0,-1,192,307,190,-1,307,192,308,-1,198,305,199,-1,305,198,309,-1,304,141,199,-1,310,141,304,-1,311,312,142,-1,313,312,311,-1,232,29,314,-1,233,29,232,-1,30,276,48,-1,30,29,276,-1,151,315,316,-1,151,317,315,-1,284,73,282,-1,284,247,73,-1,280,318,319,-1,281,318,280,-1,320,321,245,-1,320,322,321,-1,323,299,324,-1,99,299,323,-1,325,140,326,-1,327,140,325,-1,66,206,64,-1,66,68,206,-1,1,298,328,-1,1,39,298,-1,37,235,329,-1,37,36,235,-1,50,108,230,-1,50,109,108,-1,294,212,227,-1,294,330,212,-1,4,112,52,-1,211,112,4,-1,40,1,14,-1,40,39,1,-1,274,331,332,-1,333,331,274,-1,108,334,230,-1,108,217,334,-1,167,335,336,-1,169,335,167,-1,239,337,292,-1,240,337,239,-1,329,290,328,-1,291,290,329,-1,203,238,237,-1,203,205,238,-1,168,338,289,-1,168,170,338,-1,57,45,60,-1,46,45,57,-1,67,339,287,-1,67,340,339,-1,312,323,326,-1,323,312,314,-1,63,285,139,-1,285,63,253,-1,286,206,287,-1,286,207,206,-1,246,341,175,-1,246,153,341,-1,78,181,342,-1,78,77,181,-1,153,248,341,-1,154,248,153,-1,134,75,72,-1,75,134,76,-1,85,279,92,-1,128,279,85,-1,183,272,343,-1,184,272,183,-1,344,193,197,-1,193,344,243,-1,345,257,346,-1,257,345,260,-1,255,84,165,-1,255,244,84,-1,82,347,348,-1,82,187,347,-1,349,280,15,-1,265,280,349,-1,278,328,290,-1,278,1,328,-1,6,306,226,-1,0,306,6,-1,234,204,203,-1,236,204,234,-1,208,286,277,-1,49,286,208,-1,275,332,107,-1,275,274,332,-1,273,293,274,-1,350,293,273,-1,218,330,294,-1,220,330,218,-1,200,351,352,-1,201,351,200,-1,353,101,103,-1,354,101,353,-1,223,355,219,-1,355,223,356,-1,222,357,221,-1,357,222,358,-1,359,360,361,-1,359,362,360,-1,175,363,75,-1,363,175,341,-1,364,342,147,-1,78,342,364,-1,180,81,70,-1,180,182,81,-1,303,252,251,-1,303,249,252,-1,365,335,54,-1,335,365,174,-1,261,58,289,-1,261,59,58,-1,366,163,263,-1,366,164,163,-1,367,158,34,-1,367,156,158,-1,177,184,172,-1,86,184,177,-1,123,356,354,-1,356,123,124,-1,297,270,210,-1,270,297,296,-1,324,44,231,-1,324,299,44,-1,22,79,20,-1,268,79,22,-1,267,368,269,-1,369,368,267,-1,136,185,283,-1,185,136,138,-1,288,239,291,-1,288,237,239,-1,60,266,53,-1,45,266,60,-1,370,347,349,-1,347,370,186,-1,265,321,281,-1,321,265,188,-1,371,361,372,-1,361,371,359,-1,272,373,343,-1,272,271,373,-1,67,366,340,-1,366,67,69,-1,163,57,59,-1,163,162,57,-1,374,264,202,-1,374,262,264,-1,255,258,260,-1,255,256,258,-1,309,259,305,-1,309,257,259,-1,304,259,157,-1,305,259,304,-1,34,65,367,-1,65,34,66,-1,63,256,166,-1,62,256,63,-1,162,46,57,-1,46,162,254,-1,54,160,365,-1,160,54,56,-1,283,303,136,-1,303,283,282,-1,368,252,133,-1,368,250,252,-1,72,363,70,-1,75,363,72,-1,348,186,161,-1,186,348,347,-1,370,284,283,-1,284,370,17,-1,359,279,88,-1,371,279,359,-1,189,84,244,-1,82,84,189,-1,345,375,320,-1,345,346,375,-1,308,372,361,-1,308,192,372,-1,191,343,373,-1,243,343,191,-1,344,171,183,-1,344,195,171,-1,326,142,312,-1,140,142,326,-1,116,121,114,-1,116,120,121,-1,122,354,353,-1,123,354,122,-1,355,126,358,-1,355,125,126,-1,242,241,357,-1,242,118,241,-1,167,238,170,-1,238,167,240,-1,288,329,235,-1,288,291,329,-1,236,331,98,-1,236,235,331,-1,208,333,209,-1,96,333,208,-1,99,314,29,-1,314,99,323,-1,325,231,23,-1,231,325,324,-1,229,334,42,-1,229,230,334,-1,297,43,42,-1,210,43,297,-1,19,270,301,-1,19,144,270,-1,301,296,8,-1,301,270,296,-1,302,268,22,-1,302,215,268,-1,216,369,267,-1,369,216,225,-1,317,150,250,-1,151,150,317,-1,292,213,214,-1,292,337,213,-1,350,115,110,-1,350,117,115,-1,35,298,38,-1,35,37,298,-1,105,376,352,-1,105,106,376,-1,351,275,352,-1,351,273,275,-1,275,104,352,-1,275,107,104,-1,352,41,105,-1,352,104,41,-1,111,376,106,-1,111,221,376,-1,222,220,219,-1,220,222,113,-1,110,103,100,-1,110,115,103,-1,351,350,273,-1,351,117,350,-1,226,315,225,-1,306,315,226,-1,290,214,278,-1,290,292,214,-1,173,337,336,-1,337,173,213,-1,316,149,151,-1,316,214,149,-1,225,317,369,-1,225,315,317,-1,215,267,268,-1,215,216,267,-1,10,215,302,-1,10,11,215,-1,8,302,301,-1,10,302,8,-1,42,228,297,-1,334,228,42,-1,299,229,44,-1,299,31,229,-1,340,263,262,-1,340,366,263,-1,202,97,374,-1,202,204,97,-1,202,338,205,-1,264,338,202,-1,118,116,201,-1,120,116,118,-1,358,242,357,-1,358,126,242,-1,356,125,355,-1,124,125,356,-1,121,353,114,-1,121,122,353,-1,195,197,28,-1,195,344,197,-1,327,23,194,-1,327,325,23,-1,171,196,132,-1,195,196,171,-1,308,346,307,-1,308,375,346,-1,373,192,191,-1,372,192,373,-1,322,375,360,-1,322,320,375,-1,188,245,321,-1,245,188,189,-1,319,362,90,-1,362,319,318,-1,371,92,279,-1,271,92,371,-1,349,17,370,-1,349,15,17,-1,283,186,370,-1,283,185,186,-1,348,159,94,-1,348,161,159,-1,176,147,342,-1,147,176,146,-1,363,248,178,-1,341,248,363,-1,368,134,269,-1,134,368,133,-1,185,365,160,-1,138,365,185,-1,21,78,364,-1,78,21,20,-1,300,24,145,-1,25,24,300,-1,174,336,335,-1,174,173,336,-1,53,61,60,-1,55,61,53,-1,289,264,261,-1,338,264,289,-1,367,313,311,-1,367,65,313,-1,258,157,259,-1,258,155,157,-1,62,158,155,-1,62,32,158,-1,157,310,304,-1,157,156,310,-1,287,277,286,-1,339,277,287,-1,162,285,253,-1,164,285,162,-1,271,372,373,-1,271,371,372,-1,318,360,362,-1,360,318,322,-1,128,87,129,-1,85,87,128,-1,16,130,18,-1,89,130,16,-1,277,374,97,-1,374,277,339,-1,150,137,251,-1,137,150,152,-1,369,250,368,-1,317,250,369,-1,24,231,148,-1,24,23,231,-1,145,364,300,-1,364,145,21,-1,217,224,295,-1,224,217,102,-1,27,194,196,-1,194,27,327,-1,156,311,310,-1,311,156,367,-1,69,164,366,-1,69,285,164,-1,263,59,261,-1,263,163,59,-1,138,174,365,-1,174,138,135,-1,251,136,303,-1,137,136,251,-1,133,249,76,-1,252,249,133,-1,178,70,363,-1,178,180,70,-1,182,77,81,-1,182,181,77,-1,300,147,131,-1,364,147,300,-1,194,132,196,-1,25,132,194,-1,130,153,246,-1,153,130,127,-1,88,362,359,-1,88,90,362,-1,361,375,308,-1,361,360,375,-1,221,241,376,-1,241,221,357,-1,219,358,222,-1,358,219,355,-1,354,223,101,-1,356,223,354,-1,115,353,103,-1,353,115,114,-1,201,117,351,-1,116,117,201,-1,241,352,376,-1,200,352,241,-1,113,330,220,-1,113,112,330,-1,295,218,294,-1,218,295,224,-1,293,110,109,-1,110,293,350,-1,40,105,41,-1,40,51,105,-1,52,106,51,-1,106,52,111,-1,316,278,214,-1,2,278,316,-1,333,98,331,-1,98,333,96,-1,101,224,102,-1,101,223,224,-1,204,98,97,-1,98,204,236,-1,3,226,13,-1,3,6,226,-1,348,83,82,-1,348,94,83,-1,257,307,346,-1,257,309,307,-1,347,265,349,-1,347,187,265,-1,165,83,47,-1,165,84,83,-1,244,260,345,-1,260,244,255,-1,197,190,198,-1,190,197,193,-1,343,344,183,-1,243,344,343,-1,93,184,86,-1,93,272,184,-1,319,89,16,-1,90,89,319,-1,71,79,269,-1,71,80,79,-1,342,179,176,-1,342,181,179,-1,72,269,134,-1,72,71,269,-1,65,232,313,-1,232,65,64,-1,339,262,374,-1,339,340,262,-1,170,205,338,-1,238,205,170,-1,159,53,266,-1,159,56,53,-1,240,336,337,-1,167,336,240,-1,54,169,55,-1,54,335,169,-1,266,94,159,-1,266,95,94,-1,334,295,228,-1,217,295,334,-1,36,331,235,-1,36,332,331,-1,14,51,40,-1,5,51,14,-1,330,211,212,-1,330,112,211,-1,333,293,209,-1,333,274,293,-1,37,328,298,-1,37,329,328,-1,107,36,35,-1,107,332,36,-1,276,64,207,-1,233,64,276,-1,327,26,140,-1,27,26,327,-1,324,326,323,-1,324,325,326,-1,345,245,244,-1,345,320,245,-1,281,322,318,-1,321,322,281,-1,15,319,16,-1,280,319,15,-1,284,18,247,-1,17,18,284,-1,306,316,315,-1,316,306,2,-1,313,314,312,-1,232,314,313,-1,310,142,141,-1,311,142,310,-1,309,190,307,-1,309,198,190,-1,7,11,10,-1,12,11,7,-1,9,296,228,-1,9,8,296,-1,5,0,6,-1,5,14,0,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmcun_Coord',point=[(-1.72093,1.84346,-.64375),(-1.74755,1.91917,-.66086),(-1.75356,1.90911,-.58533),(-1.6273,1.64624,-.74603),(-1.6146,1.66807,-.76958),(-1.6831,1.79125,-.692),(-1.68729,1.77337,-.66707),(-1.64094,1.40088,-.87714),(-1.68622,1.28277,-.92884),(-1.70588,1.31105,-.94372),(-1.62709,1.37212,-.85975),(-1.59201,1.46286,-.81035),(-1.6086,1.49126,-.83255),(-1.61897,1.6272,-.7174),(-1.7145,1.85543,-.67725),(-1.81186,1.60105,.21779),(-1.7261,1.56378,.20453),(-1.80357,1.63243,.15961),(-1.73296,1.5869,.14232),(-1.70516,1.14485,-.71834),(-1.65239,1.14156,-.56205),(-1.73373,1.08865,-.59098),(-1.62482,1.21648,-.67642),(-2.09014,1.09416,-.67541),(-1.98425,1.06078,-.66542),(-1.99357,1.01729,-.54026),(-2.26907,1.12768,-.37972),(-2.24678,1.07966,-.41161),(-2.28095,1.07339,-.28531),(-2.11703,1.43557,-.72119),(-2.09817,1.46753,-.78685),(-2.08075,1.35568,-.89886),(-2.14635,1.60682,-.17405),(-2.13198,1.65505,-.2583),(-2.14751,1.58123,-.28696),(-1.86714,1.91501,-.69112),(-1.92666,1.91077,-.69218),(-1.86916,1.94567,-.69176),(-1.82032,1.91467,-.68723),(-1.76163,1.90953,-.67846),(-1.72963,1.8512,-.69337),(-1.78379,1.84655,-.69548),(-1.90624,1.22715,-.99531),(-1.91437,1.15502,-.90639),(-2.04775,1.23059,-.89194),(-2.1957,1.78965,.16254),(-2.22381,1.77076,.15198),(-2.21769,1.74465,.23464),(-2.08303,1.54083,-.72755),(-2.10797,1.57084,-.72071),(-2.09542,1.50787,-.85614),(-1.69738,1.78684,-.7073),(-1.62811,1.67539,-.77865),(-2.14086,1.90113,.03408),(-2.06252,1.9547,-.08518),(-2.09173,1.95392,-.10263),(-2.11523,1.9068,.05303),(-2.20747,1.81199,.0183),(-2.14812,1.91394,-.13724),(-2.16735,1.86513,-.15421),(-2.18016,1.83209,.02793),(-2.11079,1.91763,-.11499),(-2.16785,1.57199,-.04737),(-2.18699,1.65304,-.01838),(-2.10386,1.52607,-.52529),(-2.12895,1.498,-.44948),(-2.11716,1.57416,-.40972),(-2.11608,1.66495,-.37181),(-2.10563,1.64735,-.37005),(-2.15007,1.67211,-.28071),(-1.59162,1.32296,-.33923),(-1.59324,1.42521,-.41289),(-1.60404,1.47263,-.32901),(-1.66957,1.66178,.0612),(-1.64386,1.64397,.05925),(-1.6193,1.55821,-.15804),(-1.63924,1.57004,-.18202),(-1.64665,1.10868,-.4592),(-1.66582,1.11256,-.47235),(-1.58089,1.26111,-.52647),(-1.57048,1.25647,-.50518),(-1.5955,1.21236,-.43195),(-2.08292,1.7044,.2552),(-2.18634,1.73307,.25974),(-2.19121,1.6671,.21599),(-1.76599,1.10735,-.07907),(-1.81288,1.03733,-.13579),(-1.75577,1.11306,-.09249),(-1.69046,1.36258,.09559),(-1.64731,1.438,.11848),(-1.68541,1.41863,.12583),(-1.66341,1.36966,.07821),(-1.79525,1.10757,-.06566),(-1.82678,1.043,-.10695),(-2.18453,1.76666,.25439),(-2.20046,1.77652,.22313),(-1.9984,1.82266,-.63116),(-2.02634,1.82242,-.54582),(-1.99062,1.84803,-.62509),(-2.12025,1.33722,-.80219),(-1.98554,1.4129,-.92362),(-1.867,1.41443,-.93644),(-1.87056,1.37027,-.97306),(-1.96232,1.43969,-.89429),(-1.83843,1.8417,-.69639),(-1.73584,1.78436,-.70492),(-1.71535,1.76112,-.71279),(-1.88939,1.85334,-.70135),(-1.99775,1.39396,-.94597),(-2.07553,1.51678,-.85387),(-2.04711,1.5234,-.84584),(-1.65943,1.66475,-.77545),(-1.62027,1.53,-.8622),(-1.65273,1.53829,-.85537),(-1.96554,1.53694,-.80542),(-2.00188,1.53273,-.82877),(-1.94353,1.60585,-.77407),(-1.98469,1.62563,-.78103),(-1.85519,1.6082,-.7473),(-1.85496,1.55015,-.7894),(-1.90661,1.58213,-.76823),(-1.91791,1.5458,-.78655),(-1.89506,1.51249,-.81483),(-1.86276,1.50561,-.83041),(-1.84594,1.50495,-.82613),(-1.82853,1.51616,-.81814),(-1.80536,1.54717,-.8023),(-1.64368,1.40561,.03613),(-1.70548,1.2435,.00818),(-1.67287,1.28202,-.02016),(-1.64207,1.47164,.05703),(-1.88935,1.04357,-.36816),(-1.99921,.98176,-.42153),(-1.65591,1.59729,-.28172),(-1.62292,1.49659,-.33326),(-1.9105,1.93496,-.13183),(-1.84333,1.87001,-.06192),(-1.83949,1.8843,-.14396),(-1.92913,1.90695,-.06065),(-2.13663,1.65897,-.15911),(-2.2321,1.17929,-.49657),(-2.2596,1.23584,-.33522),(-2.20951,1.2884,-.43),(-1.80587,1.1009,-.75518),(-1.72549,1.12656,-.72905),(-1.83496,1.07382,-.61489),(-1.79143,1.05489,-.27172),(-1.77835,1.05198,-.38289),(-1.94689,1.1079,-.78591),(-1.81633,1.93639,-.33439),(-1.76877,1.82321,-.25464),(-1.76058,1.84984,-.37101),(-1.8352,1.90047,-.2253),(-1.61642,1.42399,-.01299),(-1.63923,1.26197,-.06915),(-2.17545,1.47097,-.08939),(-2.19316,1.40242,-.2538),(-2.1748,1.35426,-.14518),(-2.16831,1.53685,-.19754),(-2.15521,1.83913,.17075),(-2.03111,1.86745,.09612),(-2.07005,1.79535,.18322),(-2.21899,1.7352,-.01732),(-2.17773,1.76596,-.1672),(-2.17905,1.72872,-.17304),(-2.21083,1.67405,.19851),(-2.21532,1.70102,.14809),(-2.01944,2.00725,-.22591),(-2.07878,1.95362,-.17861),(-2.05606,1.98209,-.16591),(-2.03777,1.96914,-.23905),(-2.03014,.92773,-.32767),(-1.89285,.96318,-.26841),(-1.89148,1.96483,-.20222),(-1.92611,1.94148,-.13248),(-1.59026,1.51769,-.01862),(-1.70886,1.092,-.17754),(-1.79863,1.0248,-.22015),(-1.61581,1.25389,-.18427),(-1.67854,1.09309,-.18415),(-1.61494,1.21207,-.26819),(-1.66567,1.08543,-.36821),(-1.62284,1.15198,-.339),(-2.01602,.93055,-.24991),(-1.89178,.98638,-.18566),(-1.94783,1.83206,.1115),(-1.99143,1.75049,.17179),(-2.01597,1.67536,.24121),(-1.97449,1.60843,.21085),(-2.03899,1.58837,.18713),(-2.22165,1.18524,-.14089),(-2.08573,1.06402,-.13899),(-2.01969,1.2022,-.05692),(-2.25359,1.05956,-.2324),(-2.11375,1.03573,-.55906),(-2.15816,.9315,-.34209),(-2.1373,.98291,-.44259),(-2.27114,1.06311,-.25013),(-2.24143,1.19094,-.16131),(-2.24243,1.18733,-.21471),(-1.84411,1.69574,-.71665),(-1.88875,1.68632,-.72968),(-2.04272,1.92952,-.38624),(-1.98446,2.00224,-.48455),(-1.9987,1.92444,-.51348),(-2.01571,1.99841,-.35537),(-2.08561,1.60025,-.4933),(-2.07832,1.57044,-.60018),(-2.0669,1.68341,-.68034),(-2.07813,1.64882,-.78021),(-1.80137,1.13164,-.89696),(-1.60414,1.52245,-.85032),(-1.62976,1.41854,-.90439),(-1.84449,1.98032,-.31465),(-1.80528,1.95935,-.47149),(-1.57823,1.405,-.73116),(-1.62013,1.57954,-.65168),(-1.87267,1.33745,-1.00122),(-1.73382,1.40212,-.93905),(-1.76079,1.45889,-.89745),(-1.69815,1.44525,-.90895),(-1.70414,1.64945,-.77026),(-1.69907,1.54545,-.84765),(-1.81308,1.43026,-.91191),(-1.80248,1.3862,-.95621),(-1.6571,1.72872,-.57463),(-1.67214,1.76468,-.6405),(-1.70051,1.32827,-.96953),(-1.78269,1.29856,-1.00276),(-2.03144,1.30736,-.95029),(-2.01472,1.37531,-.95132),(-2.07439,1.15866,-.78845),(-2.12022,1.45988,-.56888),(-2.10965,1.48642,-.61959),(-1.9624,1.96332,-.59167),(-1.94131,1.92559,-.67945),(-1.97392,1.92769,-.60264),(-1.95102,1.99894,-.47394),(-1.98282,1.9957,-.34182),(-1.92281,2.01488,-.46641),(-1.9685,2.02131,-.33657),(-1.80084,1.67654,-.72672),(-1.81162,1.58867,-.77831),(-2.15352,.94908,-.25147),(-2.17281,1.54178,.1055),(-2.0189,1.54507,.16487),(-1.61829,1.50418,.00377),(-1.67668,1.64498,.10223),(-1.60914,1.26643,-.09808),(-1.68946,1.72152,-.11663),(-1.72329,1.74527,-.30718),(-1.76578,1.81194,-.17458),(-1.70784,1.7321,-.21468),(-2.22361,1.67222,-.03521),(-2.2347,1.72458,.13497),(-2.18968,1.5403,.08719),(-2.17362,1.54819,.02768),(-2.13309,1.33413,-.02852),(-2.1333,1.45018,-.0314),(-2.14609,1.33092,-.09851),(-2.15115,1.43368,.01551),(-2.12657,1.88796,-.21697),(-2.09417,1.80741,-.32337),(-2.13067,1.78523,-.24282),(-2.0856,1.91271,-.27982),(-1.92959,1.62844,.22993),(-2.17948,1.82835,.16064),(-1.61639,1.51076,-.5371),(-1.56625,1.33887,-.62718),(-1.61099,1.44632,-.42653),(-1.72355,1.1711,-.86688),(-1.8298,1.10589,-.06442),(-1.89504,.99697,-.16018),(-1.94778,1.78165,-.72255),(-1.96024,1.80766,-.71886),(-1.92539,1.79919,-.71368),(-2.09715,1.50654,-.65792),(-2.06774,1.7014,-.57438),(-1.7772,1.94383,-.57268),(-1.7338,1.24379,.0255),(-1.84417,1.57393,.21698),(-1.87765,1.5653,.20634),(-1.76269,1.71336,.0933),(-1.85312,1.77091,.11574),(-1.76332,1.70092,.11219),(-2.18315,1.67991,-.1886),(-2.11079,1.59527,-.61273),(-2.1136,1.63294,-.49295),(-1.93138,1.97142,-.57666),(-2.11117,1.9506,-.18541),(-1.86338,1.99044,-.56927),(-1.8953,1.98997,-.57606),(-1.89574,2.01061,-.45794),(-2.05857,1.64985,-.79099),(-1.70985,1.35302,-.9714),(-1.78894,1.33321,-.99576),(-1.74266,1.2363,-.95997),(-1.79503,1.19832,-.97977),(-1.82559,1.94588,-.6883),(-2.10282,1.28438,-.84772),(-1.85804,1.05036,-.51016),(-1.68854,1.20364,-.84113),(-1.61685,1.29707,-.78729),(-1.76008,1.80329,-.08879),(-2.20872,1.27281,-.18005),(-2.19465,1.26031,-.15791),(-1.70816,1.84061,-.6084),(-2.16649,1.25713,-.07774),(-1.99106,1.29252,.0094),(-2.18769,1.26338,-.09662),(-2.22642,1.32109,-.29391),(-2.18389,1.37084,-.38869),(-2.1751,1.34593,-.52719),(-2.15187,1.42378,-.48615),(-2.13741,1.38778,-.61764),(-1.70094,1.82113,-.52458),(-1.7528,1.89105,-.49903),(-1.71729,1.77253,-.40509),(-1.82615,1.51574,.18819),(-1.76009,1.53589,.2068),(-1.98389,1.47769,.13624),(-1.94316,1.5515,.18409),(-1.90488,1.49388,.1609),(-2.15122,1.29026,-.72083),(-2.13683,1.22958,-.74579),(-2.17521,1.16798,-.62987),(-2.19338,1.22619,-.60629),(-2.21427,1.12138,-.51693),(-1.8306,1.96374,-.67407),(-1.86721,1.96444,-.67802),(-1.64676,1.43159,-.91493),(-1.96092,1.86586,-.69341),(-1.94049,1.86509,-.70502),(-1.97752,1.81099,-.70671),(-1.87558,1.3136,-1.01009),(-2.02628,1.97747,-.14692),(-1.98874,2.0033,-.20816),(-1.9324,2.01644,-.32928),(-2.07065,1.96731,-.25146),(-2.08611,1.71664,-.4622),(-2.10362,1.72939,-.34584),(-1.58566,1.43226,-.03841),(-1.69149,1.08754,-.37364),(-2.02336,.94271,-.22766),(-2.15899,.93768,-.27566),(-2.12758,1.43146,.03747),(-2.11052,1.32766,-.01124),(-2.01062,1.71071,.24083),(-2.08743,1.74259,.25547),(-1.89984,1.65494,.22964),(-2.02975,1.64032,-.78633),(-1.91782,1.7365,-.72635),(-1.83386,1.76571,-.69988),(-1.92939,1.47635,-.85295),(-1.86602,1.4586,-.88801),(-1.7949,1.4893,-.85979),(-1.82988,1.46943,-.87082),(-1.74824,1.62672,-.77124),(-1.74864,1.55072,-.82306),(-1.7677,1.33551,.08585),(-1.86285,1.3796,.09085),(-1.87875,1.31454,.04833),(-1.75595,1.39538,.11728),(-1.59881,1.41894,-.1643),(-1.75478,1.0626,-.49294),(-1.96057,1.91942,-.06282),(-2.13602,1.72794,-.25702),(-2.1584,1.44974,-.351),(-1.66894,1.62394,-.36198),(-1.66527,1.66565,-.4569),(-1.89152,1.6894,.16622),(-1.79147,1.22937,.02483),(-1.9072,1.21252,-.01707),(-1.95773,1.09107,-.1021),(-2.06077,1.81513,-.43687),(-1.97128,1.35868,.06062),(-1.74609,1.72866,-.71846)]))),
        Shape(DEF='rfmet',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfmet_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,10,28,29,-1,30,31,32,-1,32,31,33,-1,28,30,29,-1,34,35,36,-1,37,38,31,-1,31,30,37,-1,39,40,41,-1,42,43,44,-1,44,45,42,-1,46,47,48,-1,49,50,51,-1,51,52,49,-1,53,54,55,-1,55,56,53,-1,57,58,26,-1,58,27,26,-1,59,60,61,-1,62,63,18,-1,64,65,66,-1,64,67,65,-1,21,68,69,-1,70,71,72,-1,71,73,72,-1,69,74,21,-1,75,76,77,-1,75,78,76,-1,79,80,81,-1,36,82,83,-1,84,85,86,-1,84,87,85,-1,81,88,79,-1,89,83,90,-1,73,45,40,-1,91,92,93,-1,94,95,58,-1,96,87,81,-1,97,98,99,-1,100,101,9,-1,101,102,9,-1,103,104,105,-1,104,106,105,-1,107,108,109,-1,76,110,111,-1,76,112,110,-1,113,114,115,-1,113,116,114,-1,117,118,119,-1,117,120,118,-1,7,121,122,-1,7,123,121,-1,124,125,126,-1,117,100,127,-1,117,128,100,-1,129,130,131,-1,132,133,134,-1,132,135,133,-1,136,137,138,-1,131,139,140,-1,141,142,143,-1,141,144,142,-1,145,146,147,-1,147,148,145,-1,149,144,141,-1,149,150,144,-1,151,152,153,-1,154,155,156,-1,155,157,156,-1,129,158,159,-1,129,160,158,-1,161,162,163,-1,163,164,161,-1,159,130,129,-1,158,165,166,-1,166,133,158,-1,167,143,168,-1,169,170,171,-1,171,172,169,-1,173,174,175,-1,175,108,173,-1,80,6,176,-1,69,177,178,-1,7,9,179,-1,102,180,181,-1,180,182,181,-1,15,60,13,-1,183,184,185,-1,185,33,183,-1,186,28,10,-1,187,29,188,-1,30,188,29,-1,189,190,191,-1,27,192,193,-1,194,26,25,-1,194,190,26,-1,195,196,197,-1,37,191,198,-1,199,196,195,-1,199,200,196,-1,201,202,203,-1,201,204,202,-1,56,49,205,-1,198,194,206,-1,206,207,198,-1,46,48,207,-1,207,206,46,-1,208,209,210,-1,210,211,208,-1,34,36,85,-1,62,212,213,-1,35,213,82,-1,16,18,63,-1,16,214,17,-1,16,215,214,-1,216,43,217,-1,217,215,216,-1,95,94,39,-1,50,216,51,-1,216,218,51,-1,54,95,41,-1,219,220,221,-1,219,222,220,-1,72,40,19,-1,72,73,40,-1,69,223,224,-1,69,178,223,-1,4,92,91,-1,4,225,92,-1,226,176,227,-1,227,228,226,-1,229,87,230,-1,87,96,230,-1,231,88,232,-1,64,233,234,-1,235,224,223,-1,235,236,224,-1,39,94,237,-1,238,184,239,-1,238,185,184,-1,10,185,238,-1,240,61,60,-1,184,241,239,-1,184,242,241,-1,15,14,243,-1,237,94,244,-1,244,243,237,-1,155,245,152,-1,245,246,152,-1,139,131,247,-1,248,246,249,-1,250,251,252,-1,250,137,251,-1,253,0,109,-1,253,1,0,-1,254,255,256,-1,255,257,256,-1,247,258,259,-1,260,261,262,-1,261,263,262,-1,264,265,266,-1,265,267,266,-1,268,269,270,-1,271,272,167,-1,271,273,272,-1,274,275,276,-1,276,164,274,-1,160,162,158,-1,132,277,278,-1,278,279,132,-1,130,159,135,-1,135,280,130,-1,281,282,77,-1,281,149,282,-1,283,148,147,-1,147,284,283,-1,108,107,285,-1,174,286,104,-1,287,175,288,-1,289,290,291,-1,290,292,291,-1,274,98,275,-1,274,99,98,-1,77,293,75,-1,77,282,293,-1,294,295,78,-1,294,296,295,-1,157,151,297,-1,151,298,297,-1,275,122,121,-1,275,98,122,-1,99,170,97,-1,99,171,170,-1,291,287,288,-1,291,292,287,-1,175,174,104,-1,104,288,175,-1,286,106,104,-1,169,172,299,-1,299,300,169,-1,301,120,302,-1,301,173,120,-1,303,128,304,-1,303,305,128,-1,306,307,115,-1,307,308,115,-1,309,116,113,-1,111,145,281,-1,310,150,311,-1,310,312,150,-1,284,147,313,-1,314,299,172,-1,271,167,168,-1,168,134,271,-1,160,163,162,-1,160,156,163,-1,297,156,157,-1,297,163,156,-1,269,315,270,-1,141,316,149,-1,136,261,260,-1,136,317,261,-1,317,258,254,-1,254,261,317,-1,318,319,320,-1,319,321,320,-1,322,323,253,-1,323,1,253,-1,324,248,249,-1,139,247,259,-1,140,129,131,-1,325,220,13,-1,243,186,12,-1,243,244,186,-1,183,326,184,-1,326,242,184,-1,241,61,239,-1,241,327,61,-1,238,61,240,-1,238,239,61,-1,60,182,180,-1,60,59,182,-1,238,240,11,-1,12,186,10,-1,33,185,10,-1,232,88,84,-1,328,69,329,-1,69,68,329,-1,236,74,224,-1,236,70,74,-1,224,74,69,-1,72,19,21,-1,54,41,44,-1,51,63,330,-1,51,218,63,-1,95,39,41,-1,43,42,217,-1,215,16,218,-1,218,216,215,-1,218,16,63,-1,213,63,62,-1,213,212,82,-1,85,208,211,-1,211,34,85,-1,208,85,87,-1,87,229,208,-1,212,62,66,-1,66,331,212,-1,206,332,46,-1,206,333,332,-1,49,52,205,-1,202,334,203,-1,335,336,38,-1,25,27,193,-1,189,26,190,-1,335,197,336,-1,30,32,188,-1,32,187,188,-1,205,332,333,-1,333,337,205,-1,325,13,60,-1,328,296,177,-1,296,294,177,-1,248,338,153,-1,338,314,153,-1,248,318,338,-1,318,339,338,-1,314,171,153,-1,314,172,171,-1,313,340,284,-1,278,142,341,-1,278,277,142,-1,342,343,344,-1,344,345,342,-1,344,346,345,-1,344,347,346,-1,347,348,346,-1,348,349,346,-1,162,161,158,-1,297,274,164,-1,164,163,297,-1,99,298,171,-1,154,156,160,-1,160,129,154,-1,155,151,157,-1,155,152,151,-1,350,310,283,-1,350,315,310,-1,0,107,109,-1,147,146,308,-1,308,313,147,-1,145,148,311,-1,311,281,145,-1,285,307,108,-1,351,352,353,-1,354,355,356,-1,355,357,356,-1,133,135,158,-1,135,159,158,-1,165,358,166,-1,359,341,360,-1,360,268,359,-1,24,361,22,-1,354,362,125,-1,125,124,354,-1,361,24,8,-1,8,7,361,-1,141,272,316,-1,363,364,267,-1,364,266,267,-1,271,133,166,-1,271,134,133,-1,365,226,366,-1,226,367,366,-1,105,106,22,-1,106,23,22,-1,361,122,98,-1,98,97,361,-1,115,114,306,-1,128,305,100,-1,305,101,100,-1,80,96,81,-1,80,365,96,-1,328,177,69,-1,89,86,83,-1,36,35,82,-1,214,215,368,-1,74,70,21,-1,70,72,21,-1,12,15,243,-1,240,60,15,-1,192,27,58,-1,58,95,192,-1,192,54,53,-1,192,95,54,-1,46,332,369,-1,28,189,30,-1,189,191,30,-1,43,55,54,-1,54,44,43,-1,30,191,37,-1,35,370,213,-1,37,198,371,-1,32,33,10,-1,29,187,10,-1,33,31,38,-1,10,187,32,-1,60,180,325,-1,372,173,108,-1,234,67,64,-1,93,373,91,-1,220,222,13,-1,238,11,10,-1,7,122,361,-1,324,374,319,-1,321,375,323,-1,376,375,321,-1,173,118,120,-1,173,372,118,-1,335,37,371,-1,38,37,335,-1,210,202,211,-1,202,210,334,-1,377,200,378,-1,200,377,196,-1,38,183,33,-1,38,336,183,-1,369,370,46,-1,369,330,370,-1,26,28,57,-1,26,189,28,-1,370,47,46,-1,370,35,47,-1,379,368,235,-1,379,214,368,-1,373,223,178,-1,223,373,380,-1,381,177,294,-1,91,177,381,-1,231,212,331,-1,231,90,212,-1,325,102,101,-1,325,180,102,-1,226,382,367,-1,226,228,382,-1,356,265,264,-1,265,356,357,-1,273,166,358,-1,273,271,166,-1,3,267,227,-1,3,363,267,-1,272,364,316,-1,364,272,266,-1,127,24,302,-1,127,8,24,-1,257,341,359,-1,257,278,341,-1,280,131,130,-1,131,280,247,-1,132,168,277,-1,132,134,168,-1,383,358,165,-1,383,362,358,-1,362,356,358,-1,362,354,356,-1,355,382,357,-1,355,384,382,-1,260,137,136,-1,251,137,260,-1,385,386,387,-1,385,262,386,-1,313,307,285,-1,313,308,307,-1,310,269,312,-1,315,269,310,-1,284,388,353,-1,388,284,340,-1,283,353,350,-1,284,353,283,-1,274,298,99,-1,274,297,298,-1,112,309,113,-1,309,112,295,-1,310,148,283,-1,311,148,310,-1,292,322,253,-1,322,292,290,-1,389,318,320,-1,318,389,339,-1,106,301,23,-1,301,106,286,-1,175,109,108,-1,175,287,109,-1,124,390,391,-1,126,390,124,-1,392,393,394,-1,393,392,395,-1,230,396,397,-1,396,230,366,-1,337,56,205,-1,337,53,56,-1,198,398,371,-1,398,198,207,-1,203,200,199,-1,203,334,200,-1,369,205,52,-1,205,369,332,-1,193,333,25,-1,333,193,337,-1,399,235,368,-1,399,236,235,-1,64,17,233,-1,64,18,17,-1,90,232,89,-1,232,90,231,-1,400,401,402,-1,401,400,403,-1,404,208,229,-1,209,208,404,-1,403,378,401,-1,378,403,377,-1,50,43,216,-1,43,50,55,-1,45,41,40,-1,41,45,44,-1,19,405,20,-1,19,237,405,-1,219,21,20,-1,21,219,68,-1,303,329,221,-1,406,329,303,-1,236,71,70,-1,399,71,236,-1,380,93,234,-1,380,373,93,-1,96,366,230,-1,365,366,96,-1,396,392,407,-1,392,396,408,-1,409,182,410,-1,182,409,181,-1,411,61,327,-1,411,59,61,-1,326,403,242,-1,326,377,403,-1,393,410,394,-1,410,393,409,-1,411,412,413,-1,327,412,411,-1,407,394,413,-1,407,392,394,-1,414,413,412,-1,414,407,413,-1,13,405,14,-1,13,222,405,-1,101,220,325,-1,101,305,220,-1,415,129,140,-1,415,154,129,-1,139,416,140,-1,139,259,416,-1,138,245,415,-1,138,417,245,-1,324,417,250,-1,417,324,249,-1,388,351,353,-1,418,351,388,-1,385,419,420,-1,385,387,419,-1,375,418,2,-1,375,419,418,-1,420,374,252,-1,374,420,376,-1,320,323,322,-1,320,321,323,-1,324,318,248,-1,324,319,318,-1,270,421,422,-1,421,270,423,-1,261,256,263,-1,261,254,256,-1,259,317,416,-1,259,258,317,-1,421,352,386,-1,421,423,352,-1,416,136,138,-1,416,317,136,-1,391,384,355,-1,391,395,384,-1,124,355,354,-1,124,391,355,-1,316,282,149,-1,316,364,282,-1,150,360,144,-1,312,360,150,-1,341,144,360,-1,144,341,142,-1,276,362,383,-1,276,125,362,-1,161,165,158,-1,383,165,161,-1,340,285,107,-1,340,313,285,-1,77,111,281,-1,76,111,77,-1,111,146,145,-1,110,146,111,-1,309,119,116,-1,119,309,304,-1,306,118,372,-1,118,306,114,-1,304,117,119,-1,304,128,117,-1,289,348,347,-1,348,289,291,-1,104,349,288,-1,346,349,104,-1,424,103,300,-1,424,345,103,-1,425,426,299,-1,342,426,425,-1,347,427,289,-1,344,427,347,-1,338,299,314,-1,338,425,299,-1,105,300,103,-1,300,105,169,-1,427,339,389,-1,428,339,427,-1,100,8,127,-1,100,9,8,-1,170,361,97,-1,170,22,361,-1,153,298,151,-1,153,171,298,-1,179,123,7,-1,123,179,429,-1,363,5,293,-1,363,3,5,-1,5,91,381,-1,5,4,91,-1,296,329,406,-1,296,328,329,-1,293,381,75,-1,5,381,293,-1,295,406,309,-1,295,296,406,-1,364,293,282,-1,364,363,293,-1,429,181,409,-1,429,179,181,-1,302,23,301,-1,302,24,23,-1,339,425,338,-1,339,428,425,-1,389,289,427,-1,389,290,289,-1,344,428,427,-1,344,343,428,-1,428,342,425,-1,343,342,428,-1,426,300,299,-1,426,424,300,-1,345,104,103,-1,345,346,104,-1,288,348,291,-1,348,288,349,-1,304,406,303,-1,304,309,406,-1,76,295,112,-1,76,78,295,-1,280,132,279,-1,132,280,135,-1,161,276,383,-1,161,164,276,-1,276,121,125,-1,276,275,121,-1,141,167,272,-1,141,143,167,-1,268,422,359,-1,422,268,270,-1,273,266,272,-1,273,264,266,-1,429,126,123,-1,126,429,390,-1,393,429,409,-1,390,429,393,-1,227,265,228,-1,265,227,267,-1,262,421,386,-1,262,263,421,-1,353,423,350,-1,352,423,353,-1,421,256,422,-1,263,256,421,-1,270,350,423,-1,270,315,350,-1,258,255,254,-1,258,247,255,-1,256,359,422,-1,256,257,359,-1,250,374,324,-1,250,252,374,-1,376,419,375,-1,376,420,419,-1,2,388,0,-1,2,418,388,-1,420,251,385,-1,252,251,420,-1,351,419,387,-1,419,351,418,-1,137,417,138,-1,137,250,417,-1,417,246,245,-1,249,246,417,-1,416,415,140,-1,416,138,415,-1,154,245,155,-1,154,415,245,-1,153,246,248,-1,152,246,153,-1,237,14,405,-1,14,237,243,-1,402,412,400,-1,402,414,412,-1,404,414,402,-1,414,404,397,-1,241,412,327,-1,241,400,412,-1,411,394,410,-1,411,413,394,-1,400,242,403,-1,241,242,400,-1,410,59,411,-1,59,410,182,-1,379,234,233,-1,379,380,234,-1,79,66,65,-1,331,66,79,-1,397,407,414,-1,397,396,407,-1,408,395,392,-1,395,408,384,-1,80,226,365,-1,226,80,176,-1,80,65,225,-1,79,65,80,-1,234,92,67,-1,93,92,234,-1,68,221,329,-1,221,68,219,-1,19,39,237,-1,40,39,19,-1,20,222,219,-1,20,405,222,-1,305,221,220,-1,221,305,303,-1,217,368,215,-1,217,399,368,-1,330,213,370,-1,213,330,63,-1,401,210,209,-1,378,210,401,-1,209,402,401,-1,209,404,402,-1,89,84,86,-1,84,89,232,-1,214,233,17,-1,233,214,379,-1,207,201,398,-1,207,48,201,-1,25,206,194,-1,206,25,333,-1,192,337,193,-1,337,192,53,-1,201,47,204,-1,48,47,201,-1,203,398,201,-1,199,398,203,-1,398,195,371,-1,195,398,199,-1,195,335,371,-1,335,195,197,-1,198,190,194,-1,198,191,190,-1,28,244,57,-1,28,186,244,-1,94,57,244,-1,57,94,58,-1,179,102,181,-1,9,102,179,-1,227,6,3,-1,6,227,176,-1,230,404,229,-1,397,404,230,-1,366,408,396,-1,408,366,367,-1,395,390,393,-1,390,395,391,-1,286,173,301,-1,174,173,286,-1,290,320,322,-1,320,290,389,-1,292,109,287,-1,253,109,292,-1,22,169,105,-1,169,22,170,-1,146,115,308,-1,115,146,110,-1,342,424,426,-1,345,424,342,-1,388,107,0,-1,107,388,340,-1,312,268,360,-1,312,269,268,-1,281,150,149,-1,281,311,150,-1,387,352,351,-1,387,386,352,-1,251,262,385,-1,251,260,262,-1,367,384,408,-1,384,367,382,-1,277,143,142,-1,277,168,143,-1,247,279,255,-1,247,280,279,-1,255,278,257,-1,255,279,278,-1,121,126,125,-1,123,126,121,-1,117,302,120,-1,302,117,127,-1,118,116,119,-1,116,118,114,-1,110,113,115,-1,112,113,110,-1,358,264,273,-1,264,358,356,-1,228,357,382,-1,228,265,357,-1,307,372,108,-1,306,372,307,-1,240,12,11,-1,240,15,12,-1,399,42,71,-1,399,217,42,-1,84,81,87,-1,88,81,84,-1,90,82,212,-1,83,82,90,-1,88,331,79,-1,331,88,231,-1,36,86,85,-1,83,86,36,-1,178,91,373,-1,177,91,178,-1,75,294,78,-1,75,381,294,-1,235,380,379,-1,235,223,380,-1,45,71,42,-1,45,73,71,-1,66,18,64,-1,66,62,18,-1,67,225,65,-1,225,67,92,-1,35,204,47,-1,35,34,204,-1,49,55,50,-1,56,55,49,-1,330,52,51,-1,52,330,369,-1,336,326,183,-1,326,336,197,-1,197,377,326,-1,196,377,197,-1,378,334,210,-1,334,378,200,-1,211,204,34,-1,204,211,202,-1,225,6,80,-1,6,225,4,-1,323,2,1,-1,375,2,323,-1,321,374,376,-1,374,321,319,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfmet_Coord',point=[(-2.14398,.21765,1.52179),(-2.13054,.18156,1.65225),(-2.18437,.18829,1.64413),(-2.42954,.92853,.96513),(-2.3966,.94577,.69491),(-2.42141,.8553,.94298),(-2.37978,1.04387,.74266),(-1.99243,.76162,1.36363),(-1.97842,.68491,1.3443),(-2.0013,.75956,1.15628),(-1.62249,1.15186,.12749),(-1.65053,1.12509,.21876),(-1.71392,1.0554,.14316),(-1.84815,.99892,.47999),(-1.82073,1.0289,.27821),(-1.76778,1.05212,.33515),(-2.49154,1.11167,-.12638),(-2.49739,1.09482,-.04363),(-2.50253,1.14638,-.01573),(-2.09364,.93742,.04098),(-2.10606,.93266,.19604),(-2.22393,.91855,.20422),(-1.9263,.6475,1.58343),(-1.94213,.59973,1.51293),(-1.95212,.63466,1.46113),(-1.96393,1.09581,-.09769),(-1.85486,1.06478,-.0966),(-1.9716,.99313,-.14923),(-1.72845,1.13189,-.00721),(-1.7144,1.16593,.03612),(-1.74916,1.23492,.07444),(-1.65534,1.32412,.13704),(-1.67836,1.25086,.12335),(-1.6415,1.32502,.15236),(-2.34957,1.47885,.05659),(-2.32771,1.35237,-.01601),(-2.35035,1.38807,.01611),(-1.75441,1.27107,.1028),(-1.66103,1.35509,.14091),(-1.99908,.91974,-.12613),(-2.07638,.90152,-.10539),(-2.09546,.8952,-.18012),(-2.30468,.87653,-.16479),(-2.35221,.9132,-.22514),(-2.20094,.88234,-.19938),(-2.21412,.87597,-.14604),(-2.26029,1.25848,-.06865),(-2.30112,1.35065,-.01582),(-2.25078,1.33503,.01072),(-2.40822,1.00454,-.2165),(-2.42647,.99083,-.22392),(-2.4393,1.05955,-.17399),(-2.41375,1.05919,-.16956),(-2.17603,.93844,-.23216),(-2.17771,.91555,-.23785),(-2.34737,.93159,-.2316),(-2.33878,.94922,-.2243),(-1.84749,1.04356,-.10192),(-1.94185,.98244,-.14041),(-1.81344,1.10914,.61203),(-1.80092,1.02757,.5384),(-1.74471,1.17481,.46567),(-2.49842,1.19268,.00603),(-2.45641,1.16326,-.11556),(-2.47957,1.11338,.11733),(-2.39414,1.12916,.30429),(-2.48204,1.16064,.1279),(-2.40244,1.07977,.28921),(-2.22209,.90333,.36009),(-2.30656,.8976,.37205),(-2.26751,.87781,.03241),(-2.28487,.87396,-.10256),(-2.2007,.89062,.03716),(-2.21611,.87687,-.10862),(-2.26828,.90144,.20008),(-2.40917,.67051,1.14494),(-2.40957,.57786,1.26965),(-2.44818,.60852,1.25684),(-2.3813,.63816,1.14409),(-2.39555,1.2012,.32885),(-2.3554,1.16884,.51665),(-2.39142,1.27089,.36717),(-2.35587,1.36247,.00458),(-2.39024,1.37219,.02943),(-2.47103,1.38298,.24667),(-2.40716,1.48385,.14202),(-2.43639,1.4545,.13906),(-2.44688,1.40568,.28567),(-2.42367,1.26049,.3081),(-2.47636,1.37412,.0633),(-2.48718,1.27032,.04129),(-2.37008,.89235,.65408),(-2.37685,1.01001,.44011),(-2.38941,.95932,.41455),(-1.89233,.96432,-.10909),(-2.02459,.93778,-.19516),(-2.3676,1.3452,.42258),(-2.00118,.7071,1.70359),(-2.02081,.72751,1.69105),(-2.02611,.75245,1.83313),(-2.0211,.69422,1.14712),(-2.00393,.77326,.97544),(-1.97003,.82804,.99458),(-1.9542,.50814,1.73765),(-1.99016,.46715,1.67934),(-1.91602,.62652,1.59874),(-1.9367,.57962,1.53229),(-2.14677,.2325,1.51002),(-2.09882,.32609,1.50216),(-2.04582,.2282,1.60156),(-2.33758,.44168,1.42125),(-2.45843,.47831,1.40239),(-2.3221,.52854,1.28994),(-2.23368,.50096,1.30088),(-2.18175,.41186,1.41478),(-2.24989,.40867,1.42853),(-2.20268,.48924,1.30346),(-2.07645,.55201,1.29513),(-2.11401,.43568,1.41098),(-2.12724,.52035,1.29462),(-2.06947,.47718,1.41389),(-2.08979,.84728,1.49168),(-1.99117,.73195,1.48787),(-2.07793,.8941,1.382),(-2.26045,.99457,1.39134),(-2.25953,.94526,1.50251),(-2.22344,.97897,1.39164),(-1.9978,.61315,1.31945),(-2.083,.61883,1.19316),(-2.4282,.93465,1.81469),(-2.54997,.89181,1.81823),(-2.54549,.8889,1.83875),(-2.59979,.72261,1.7356),(-2.58379,.8074,1.71248),(-2.60686,.7465,1.70038),(-2.5793,.79232,1.7512),(-2.37234,.65941,2.09511),(-2.34094,.64775,2.10523),(-2.331,.78534,2.04917),(-2.55606,.831,1.90712),(-2.45975,.89978,1.9105),(-2.61794,.71045,1.44724),(-2.63436,.67559,1.58319),(-2.62763,.71218,1.57727),(-2.61845,.67499,1.46612),(-2.47102,.45213,1.46443),(-2.35137,.4033,1.51164),(-2.36132,.38099,1.52054),(-2.49703,.43299,1.4786),(-2.59747,.6207,1.37829),(-2.60741,.59356,1.40253),(-2.03876,.79334,1.93343),(-2.04505,.79005,1.95519),(-1.98712,.66708,1.9737),(-2.30011,.92788,1.85086),(-2.1259,.86971,1.91075),(-2.29508,.9295,1.82711),(-2.1189,.86705,1.89009),(-2.51664,.87497,1.70999),(-2.52435,.86852,1.73843),(-2.41072,.93995,1.79692),(-2.3899,.93405,1.72429),(-2.39524,.92814,1.75688),(-2.285,.92531,1.78036),(-2.2777,.91917,1.74591),(-2.49933,.88379,1.64086),(-2.55003,.84977,1.62981),(-2.59782,.75389,1.58184),(-2.62007,.70968,1.6405),(-1.94303,.6301,1.75009),(-1.952,.65313,1.74416),(-2.01021,.68475,1.91669),(-2.00254,.65956,1.91028),(-2.05163,.43628,1.46867),(-2.03893,.42876,1.49219),(-2.07773,.32796,1.51876),(-2.37256,1.08873,.76454),(-2.34316,.86499,.63841),(-2.34921,.90081,.41267),(-1.99355,.82666,1.20306),(-1.90583,.93551,.76356),(-1.9639,.90564,1.01139),(-1.89634,.99347,.82391),(-1.6357,1.4188,.1884),(-1.6174,1.36366,.24564),(-1.60891,1.26003,.20838),(-1.69918,1.0654,.01925),(-1.65937,1.17623,.07749),(-1.69374,1.19612,.05667),(-1.74054,1.14655,-.00666),(-1.78787,1.18137,.01386),(-1.76244,1.23737,.07645),(-2.03267,.95428,-.19881),(-2.00617,.99664,-.15174),(-1.91498,1.2071,-.01768),(-1.84753,1.5368,.21562),(-1.84909,1.6009,.24821),(-1.7297,1.53935,.21679),(-1.88427,1.29211,.07403),(-2.0027,1.5661,.2117),(-2.00824,1.67063,.23743),(-2.23084,1.44894,.10916),(-2.30976,1.59962,.17201),(-2.19514,1.58215,.17802),(-2.32819,1.48894,.06158),(-2.33517,1.04059,-.15102),(-2.10405,1.21376,-.03289),(-2.06331,1.31173,.03845),(-2.365,1.61059,.26938),(-2.23349,1.6478,.32498),(-2.20618,1.66239,.2428),(-2.33763,1.60772,.18974),(-2.48522,1.2369,.02243),(-2.39453,1.26814,-.0465),(-2.45734,.99353,-.06608),(-2.46972,.99788,-.13438),(-2.46262,.99099,-.20193),(-2.34695,.89083,-.15849),(-2.49631,1.08294,-.16958),(-2.12308,.90625,.35272),(-2.01055,.8629,.67033),(-2.14556,.85135,.61111),(-1.97289,.95229,.41118),(-2.37392,.91603,.20964),(-2.32579,.90134,.22164),(-2.36827,1.05676,.46762),(-2.37354,1.16487,.79645),(-2.42252,1.00143,.98933),(-2.4061,1.06587,1.01154),(-2.37191,1.50734,.40131),(-2.34599,1.45205,.50098),(-2.49526,1.25379,.15369),(-2.4996,1.3247,.20146),(-2.47972,1.06147,.08981),(-2.43005,1.00773,.24451),(-2.40075,.93092,.06201),(-2.33011,.88965,.04568),(-1.9586,.98737,.04677),(-1.63796,1.18697,.30505),(-1.6712,1.27576,.36943),(-1.72508,1.09435,.39118),(-1.76611,1.42162,.46066),(-1.73418,1.49175,.34498),(-1.81145,1.04612,.08859),(-1.78895,1.03763,-.05893),(-2.1516,.81025,2.00063),(-2.08195,.73176,2.01746),(-2.5946,.77442,1.9014),(-1.99617,.57533,2.03942),(-2.10143,.68076,2.06381),(-2.25527,.62109,2.11873),(-2.38585,.47068,2.07351),(-2.27306,.46388,2.07691),(-2.05128,.17757,1.68066),(-2.57418,.54783,2.02439),(-2.63075,.6495,1.90001),(-2.60733,.44131,1.89085),(-2.63547,.57761,1.81864),(-2.55375,.72854,1.99023),(-2.54616,.79071,1.94644),(-2.4169,.48056,2.06449),(-2.4848,.50324,2.06166),(-2.46282,.28234,1.95711),(-2.51055,.35544,1.93063),(-2.45974,.92136,1.35119),(-2.43006,.9705,1.21169),(-2.48931,.86372,1.32568),(-2.44678,.91492,1.1847),(-2.67899,.55612,1.56822),(-2.63816,.51046,1.46384),(-2.62559,.42515,1.55159),(-2.58671,.80452,1.60477),(-2.54871,.82247,1.43345),(-2.5099,.87566,1.45907),(-2.12396,.81501,1.7992),(-2.10672,.81069,1.65641),(-2.27552,.90482,1.64192),(-2.616,.68239,1.67129),(-2.63461,.59447,1.808),(-2.63176,.65964,1.88269),(-2.59793,.77559,1.8827),(-2.52549,.50647,1.39173),(-2.49593,.69282,1.2706),(-2.49993,.38419,1.51208),(-2.40217,.29711,1.50782),(-2.16067,.32202,1.48664),(-1.9725,.50694,1.49014),(-2.02922,.24531,1.6098),(-2.01795,.34584,1.66013),(-2.01234,.28658,1.82539),(-2.02774,.20576,1.86643),(-2.00401,.28753,1.75212),(-2.03493,.19342,1.68536),(-2.43723,.75515,1.15577),(-2.3645,.75143,.91867),(-2.3122,.60215,1.15044),(-2.32154,.71103,.93194),(-2.12219,.82549,1.83179),(-2.03078,.76165,1.8597),(-1.97745,.55361,1.88675),(-1.96155,.54313,1.79725),(-1.97895,.52253,1.46706),(-1.98567,.5537,1.41753),(-2.14906,.71012,.95704),(-2.13452,.58946,1.18864),(-2.07179,.73533,.96402),(-2.17617,.39862,1.43054),(-2.16533,.34223,1.47782),(-2.25627,.37296,1.49708),(-2.22305,.57998,1.16505),(-2.57206,.47051,1.42735),(-2.5543,.50238,1.4125),(-2.63629,.52912,1.44553),(-2.25594,.34342,1.51214),(-1.98048,.64728,1.95735),(-2.58391,.4587,1.44651),(-2.58639,.72613,1.39804),(-2.45768,.69519,2.05437),(-2.05526,.43513,2.03987),(-2.14325,.42366,2.06124),(-2.07275,.25573,1.97072),(-2.15738,.24727,1.97766),(-2.04195,.18899,1.86727),(-2.14158,.16702,1.84077),(-2.13209,.59621,2.09935),(-1.92341,.90231,.73434),(-1.71348,1.54781,.23884),(-1.81563,1.34898,.5742),(-2.30153,.84526,.64001),(-2.24297,.83806,.62655),(-2.37315,1.15531,-.1246),(-2.48873,1.20037,.13933),(-2.31324,1.12475,-.12535),(-2.14452,1.09343,-.10819),(-2.19456,1.64918,.21948),(-1.71748,1.42262,.16654),(-1.65525,1.42534,.17095),(-2.17878,1.00779,-.16406),(-1.98573,.55741,2.027),(-2.03904,.43444,2.02332),(-2.29332,.25699,1.55514),(-2.68094,.58036,1.65339),(-2.00386,.46761,1.8512),(-2.01134,.45045,1.85153),(-2.01728,.42216,1.84041),(-1.9947,.47012,1.79737),(-2.00586,.45662,1.78191),(-2.01176,.40485,1.81973),(-2.00947,.40414,1.79964),(-2.01425,.4197,1.77631),(-2.5177,.37355,1.52601),(-2.41657,.2259,1.64626),(-2.44624,.24241,1.63959),(-2.41793,.28441,1.51842),(-2.34807,.98781,1.39892),(-2.33215,1.03709,1.26056),(-2.41411,.96392,1.37914),(-2.38433,1.01024,1.23637),(-2.45503,.91392,1.48774),(-2.68175,.56273,1.65602),(-2.68163,.57651,1.55908),(-1.98102,.69569,1.49592),(-2.36157,.96194,1.50871),(-2.45342,.84372,1.1703),(-2.50636,.78289,1.29008),(-2.36144,1.26375,.58235),(-2.33713,1.35443,.64861),(-2.34275,1.23679,.82877),(-2.43327,.96029,-.07329),(-2.35057,1.14753,-.12608),(-2.29189,1.26025,-.07042),(-1.84911,1.40215,.15565),(-2.10348,.40921,1.44558),(-2.37989,.93275,.39817),(-2.19557,.43108,2.06929),(-2.19603,.17077,1.83514),(-2.21161,.2469,1.97673),(-1.8415,1.60885,.27057),(-2.00936,1.68371,.25915),(-2.42862,.96081,.07022),(-2.40408,.94458,.21274),(-2.39266,.78302,.92594),(-2.36088,1.11448,1.03145),(-2.3959,.93051,1.63785),(-2.30156,1.13347,1.0578),(-2.43572,.2672,1.96268),(-2.4612,.22847,1.79329),(-2.43296,.21149,1.79852),(-2.29985,.24101,1.57231),(-2.05572,.26686,1.96067),(-2.18778,1.01267,1.28077),(-2.26177,1.04387,1.28017),(-2.19254,1.25913,.88553),(-2.13829,1.10376,1.07146),(-2.08428,1.22409,.8991),(-2.23512,1.13462,1.0741),(-2.2409,1.39355,.68984),(-2.22147,1.48629,.56769),(-2.0277,1.41895,.138),(-2.33806,.88543,-.09702),(-1.89109,1.51112,.50356),(-2.05029,1.65929,.35298),(-2.08954,1.56143,.50911),(-1.8639,1.59041,.36309),(-2.22981,1.5434,.47777),(-1.96334,.98616,.22828),(-2.23197,.6961,.94978),(-2.14824,1.40453,.71098),(-2.2622,1.25791,.86593),(-2.01204,1.03322,1.05199),(-1.96519,1.13187,.87525),(-1.87698,1.26011,.70085),(-1.94204,1.44287,.61231),(-2.00982,1.34687,.73074),(-2.11683,1.49518,.60213),(-2.3184,.87676,1.95505),(-2.43066,.79369,2.00531),(-2.20209,.72998,2.08192),(-2.31679,.2146,1.65143),(-2.32469,.20327,1.81478),(-2.3057,.25711,1.96171),(-2.52849,.33025,1.73503),(-2.63816,.42236,1.70887),(-2.52053,.33688,1.60218),(-1.99669,.48168,1.81341),(-1.98543,.49585,1.92363),(-2.00133,.48552,1.83916),(-2.03004,.34471,1.89113),(-2.00979,.44013,1.923),(-2.06648,.94091,1.27234)]))),
        Shape(DEF='rmet2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmet2_Geo',coordIndex=[0,1,2,-1,0,3,1,-1,4,5,6,-1,5,7,6,-1,8,9,10,-1,10,11,8,-1,12,13,6,-1,12,14,13,-1,5,15,7,-1,5,16,15,-1,17,18,13,-1,19,20,21,-1,22,23,24,-1,22,25,23,-1,16,26,15,-1,16,27,26,-1,28,29,30,-1,28,31,29,-1,19,32,33,-1,19,21,32,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,40,43,41,-1,44,35,45,-1,46,47,37,-1,37,48,46,-1,49,50,51,-1,51,52,49,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,11,-1,62,63,64,-1,64,10,62,-1,65,66,67,-1,66,68,67,-1,69,70,71,-1,71,72,69,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,82,83,80,-1,84,85,86,-1,85,84,87,-1,87,88,85,-1,89,90,91,-1,92,93,94,-1,92,95,93,-1,96,97,98,-1,99,100,67,-1,101,97,96,-1,101,102,97,-1,103,104,105,-1,105,106,103,-1,107,108,109,-1,108,110,109,-1,105,111,112,-1,105,113,111,-1,109,110,114,-1,113,105,104,-1,115,116,117,-1,118,70,69,-1,119,120,121,-1,121,122,119,-1,45,123,42,-1,124,125,126,-1,124,127,125,-1,31,28,128,-1,129,130,128,-1,130,31,128,-1,131,132,133,-1,119,134,135,-1,136,137,138,-1,136,139,137,-1,140,141,142,-1,143,135,144,-1,143,145,135,-1,146,147,148,-1,146,149,147,-1,139,150,151,-1,139,152,150,-1,153,154,26,-1,26,155,153,-1,40,123,156,-1,40,42,123,-1,157,133,132,-1,157,158,133,-1,35,159,36,-1,35,44,159,-1,160,161,162,-1,123,141,163,-1,116,164,117,-1,116,165,164,-1,166,167,168,-1,166,169,167,-1,170,171,172,-1,171,173,172,-1,174,175,176,-1,177,68,66,-1,177,178,68,-1,179,180,181,-1,109,182,107,-1,183,184,185,-1,183,186,184,-1,187,188,189,-1,190,61,191,-1,191,192,190,-1,192,193,194,-1,194,195,192,-1,182,196,197,-1,198,199,200,-1,199,201,200,-1,202,203,204,-1,203,205,204,-1,206,190,207,-1,206,208,190,-1,80,209,210,-1,80,83,209,-1,211,212,213,-1,213,214,211,-1,215,82,80,-1,80,79,215,-1,216,217,218,-1,217,219,218,-1,152,139,220,-1,139,136,220,-1,221,222,223,-1,67,224,65,-1,225,226,227,-1,225,174,226,-1,228,229,189,-1,229,187,189,-1,188,86,189,-1,86,230,189,-1,231,223,232,-1,223,233,232,-1,72,234,69,-1,72,235,234,-1,236,237,238,-1,239,240,241,-1,239,242,63,-1,243,236,62,-1,244,8,61,-1,8,11,61,-1,179,245,183,-1,86,231,246,-1,246,84,86,-1,247,248,246,-1,249,250,251,-1,93,252,253,-1,196,175,238,-1,238,237,196,-1,196,182,175,-1,254,101,91,-1,254,255,101,-1,256,176,175,-1,224,67,100,-1,112,114,106,-1,108,104,103,-1,257,258,102,-1,259,260,182,-1,259,109,261,-1,261,262,259,-1,263,97,102,-1,102,262,263,-1,264,265,111,-1,111,113,264,-1,266,264,113,-1,113,267,266,-1,98,212,89,-1,200,94,268,-1,268,212,200,-1,218,219,269,-1,80,210,81,-1,211,214,270,-1,271,272,273,-1,81,269,273,-1,115,117,166,-1,166,274,115,-1,275,276,277,-1,276,278,277,-1,279,280,222,-1,279,281,280,-1,279,282,283,-1,284,281,283,-1,281,279,283,-1,37,47,285,-1,286,287,20,-1,287,288,20,-1,41,159,44,-1,41,289,159,-1,123,45,290,-1,29,291,51,-1,51,30,29,-1,125,129,292,-1,54,168,167,-1,57,293,294,-1,294,58,57,-1,295,27,296,-1,296,297,295,-1,298,275,299,-1,275,277,299,-1,14,298,17,-1,298,299,17,-1,34,300,301,-1,300,302,301,-1,153,303,154,-1,303,304,154,-1,120,305,306,-1,305,307,306,-1,134,119,122,-1,122,308,134,-1,309,136,138,-1,310,148,122,-1,122,121,310,-1,38,285,143,-1,38,37,285,-1,300,34,36,-1,311,312,160,-1,299,277,158,-1,277,313,158,-1,297,314,315,-1,297,296,314,-1,293,57,28,-1,133,158,313,-1,313,316,133,-1,51,50,30,-1,317,48,318,-1,317,319,48,-1,306,307,320,-1,320,321,306,-1,289,43,32,-1,289,41,43,-1,25,322,23,-1,25,323,322,-1,287,324,288,-1,287,284,324,-1,283,312,311,-1,325,187,229,-1,325,326,187,-1,327,325,328,-1,327,329,325,-1,330,81,273,-1,269,331,332,-1,332,273,269,-1,333,271,273,-1,272,330,273,-1,198,211,270,-1,270,334,335,-1,270,214,334,-1,210,218,269,-1,219,331,269,-1,268,89,212,-1,204,336,202,-1,336,337,202,-1,102,258,262,-1,259,182,109,-1,257,338,258,-1,338,339,258,-1,110,108,103,-1,105,112,106,-1,340,341,342,-1,67,343,99,-1,344,78,77,-1,77,345,344,-1,196,346,197,-1,196,237,346,-1,347,174,225,-1,347,175,174,-1,348,93,95,-1,348,252,93,-1,92,201,349,-1,72,76,235,-1,246,248,84,-1,248,87,84,-1,350,351,181,-1,181,352,353,-1,181,354,352,-1,190,208,355,-1,355,61,190,-1,243,237,236,-1,239,241,242,-1,236,238,356,-1,62,10,243,-1,10,9,243,-1,71,76,72,-1,71,77,76,-1,227,357,358,-1,227,226,357,-1,68,178,359,-1,269,81,210,-1,331,349,201,-1,201,199,331,-1,95,360,361,-1,95,92,360,-1,362,192,195,-1,195,79,362,-1,176,68,359,-1,176,67,68,-1,363,82,215,-1,215,364,363,-1,191,193,192,-1,217,92,349,-1,217,360,92,-1,241,186,183,-1,365,366,367,-1,366,88,367,-1,368,78,344,-1,369,78,368,-1,174,176,226,-1,176,359,226,-1,232,75,74,-1,232,235,75,-1,276,279,370,-1,276,282,279,-1,371,22,24,-1,307,372,320,-1,372,373,320,-1,318,291,317,-1,291,29,317,-1,309,374,375,-1,20,19,376,-1,19,377,376,-1,19,22,377,-1,22,371,377,-1,161,160,12,-1,160,378,12,-1,311,324,284,-1,284,283,311,-1,379,294,293,-1,379,18,294,-1,380,306,381,-1,306,321,381,-1,148,382,146,-1,148,310,382,-1,27,295,155,-1,155,26,27,-1,318,48,39,-1,48,37,39,-1,136,309,383,-1,220,134,308,-1,308,152,220,-1,384,328,385,-1,384,327,328,-1,133,316,53,-1,58,132,131,-1,129,128,386,-1,386,292,129,-1,164,124,169,-1,124,126,169,-1,120,119,305,-1,131,133,55,-1,133,53,55,-1,358,387,227,-1,358,388,387,-1,389,347,225,-1,225,390,389,-1,391,377,371,-1,391,165,377,-1,377,116,376,-1,377,165,116,-1,286,20,376,-1,108,107,392,-1,111,261,112,-1,261,109,114,-1,114,112,261,-1,266,337,264,-1,337,336,264,-1,355,244,61,-1,91,101,96,-1,262,258,259,-1,256,393,343,-1,85,88,366,-1,215,79,195,-1,366,394,85,-1,75,78,369,-1,75,76,78,-1,251,361,360,-1,75,235,76,-1,63,62,239,-1,62,236,239,-1,395,386,57,-1,57,59,395,-1,55,54,167,-1,396,59,0,-1,396,395,59,-1,397,373,372,-1,398,291,318,-1,318,39,398,-1,322,323,321,-1,323,399,321,-1,38,375,39,-1,289,32,288,-1,32,21,288,-1,23,172,24,-1,314,379,293,-1,314,296,379,-1,159,311,36,-1,159,324,311,-1,25,19,33,-1,25,22,19,-1,173,371,172,-1,371,24,172,-1,28,314,293,-1,28,30,314,-1,288,21,20,-1,7,15,400,-1,15,401,400,-1,13,14,17,-1,13,4,6,-1,400,402,403,-1,402,404,403,-1,249,360,405,-1,251,360,249,-1,193,352,194,-1,352,193,353,-1,61,406,191,-1,406,61,60,-1,407,363,408,-1,407,409,363,-1,410,405,411,-1,249,405,410,-1,379,13,18,-1,13,379,4,-1,161,404,162,-1,404,161,403,-1,402,401,412,-1,400,401,402,-1,29,130,317,-1,130,29,31,-1,124,413,414,-1,124,391,413,-1,288,159,289,-1,324,159,288,-1,412,154,304,-1,401,154,412,-1,379,27,16,-1,296,27,379,-1,173,391,371,-1,173,413,391,-1,300,162,302,-1,300,160,162,-1,303,382,415,-1,153,382,303,-1,146,295,149,-1,295,146,155,-1,315,416,297,-1,315,417,416,-1,301,415,142,-1,301,303,415,-1,418,399,323,-1,399,418,156,-1,171,320,373,-1,171,170,320,-1,419,47,46,-1,47,419,397,-1,45,34,290,-1,35,34,45,-1,395,420,421,-1,420,395,396,-1,422,423,424,-1,425,423,422,-1,2,426,427,-1,1,426,2,-1,56,0,59,-1,0,56,3,-1,386,421,292,-1,386,395,421,-1,131,427,426,-1,55,427,131,-1,421,428,292,-1,421,424,428,-1,73,361,251,-1,73,429,361,-1,364,195,194,-1,364,215,195,-1,365,352,354,-1,352,365,430,-1,431,408,367,-1,431,407,408,-1,176,343,67,-1,256,343,176,-1,260,393,256,-1,393,260,339,-1,253,89,268,-1,90,89,253,-1,266,432,337,-1,433,432,266,-1,434,264,336,-1,434,265,264,-1,341,338,342,-1,341,435,338,-1,97,436,98,-1,97,263,436,-1,254,345,340,-1,345,254,437,-1,438,286,115,-1,438,439,286,-1,419,173,171,-1,419,413,173,-1,224,71,65,-1,224,77,71,-1,115,376,116,-1,115,286,376,-1,356,389,240,-1,389,356,347,-1,225,387,390,-1,227,387,225,-1,358,385,388,-1,440,385,358,-1,53,441,54,-1,384,441,53,-1,316,384,53,-1,316,327,384,-1,312,378,160,-1,378,312,442,-1,220,383,144,-1,220,136,383,-1,443,121,380,-1,121,443,310,-1,418,25,33,-1,418,323,25,-1,418,32,43,-1,32,418,33,-1,39,374,398,-1,39,375,374,-1,305,372,307,-1,305,145,372,-1,14,378,298,-1,14,12,378,-1,282,275,442,-1,275,282,276,-1,281,444,280,-1,281,445,444,-1,233,235,232,-1,233,234,235,-1,446,447,448,-1,274,447,446,-1,359,357,226,-1,178,357,359,-1,369,348,429,-1,348,369,368,-1,368,252,348,-1,252,368,344,-1,351,179,181,-1,351,245,179,-1,449,87,248,-1,431,87,449,-1,251,247,73,-1,250,247,251,-1,229,450,451,-1,228,450,229,-1,217,405,360,-1,216,405,217,-1,209,409,411,-1,83,409,209,-1,392,182,197,-1,392,107,182,-1,335,331,199,-1,331,335,332,-1,334,204,205,-1,334,452,204,-1,453,203,202,-1,203,453,454,-1,211,200,212,-1,200,211,198,-1,444,69,234,-1,69,444,118,-1,450,390,387,-1,184,390,450,-1,243,346,237,-1,243,9,346,-1,389,184,186,-1,389,390,184,-1,183,242,241,-1,245,242,183,-1,60,350,406,-1,60,64,350,-1,181,406,350,-1,181,353,406,-1,183,230,455,-1,230,183,185,-1,411,216,209,-1,405,216,411,-1,431,410,407,-1,431,449,410,-1,231,74,246,-1,74,231,232,-1,217,331,219,-1,217,349,331,-1,433,8,244,-1,456,8,433,-1,437,344,345,-1,437,252,344,-1,99,393,435,-1,99,343,393,-1,435,339,338,-1,435,393,339,-1,267,433,266,-1,433,267,456,-1,333,203,454,-1,205,203,333,-1,213,434,452,-1,213,436,434,-1,362,272,207,-1,272,362,330,-1,271,454,206,-1,454,271,333,-1,199,270,335,-1,199,198,270,-1,205,273,332,-1,273,205,333,-1,177,446,178,-1,177,438,446,-1,448,441,440,-1,447,441,448,-1,328,388,385,-1,328,451,388,-1,313,327,316,-1,313,329,327,-1,278,325,329,-1,278,326,325,-1,221,326,370,-1,326,221,187,-1,126,292,428,-1,292,126,125,-1,46,413,419,-1,414,413,46,-1,164,391,124,-1,164,165,391,-1,381,399,163,-1,321,399,381,-1,381,443,380,-1,443,381,140,-1,386,28,57,-1,28,386,128,-1,50,314,30,-1,50,315,314,-1,17,158,157,-1,17,299,158,-1,398,457,52,-1,457,398,374,-1,49,151,417,-1,458,151,49,-1,150,149,416,-1,150,147,149,-1,120,380,121,-1,306,380,120,-1,152,147,150,-1,152,308,147,-1,457,137,458,-1,138,137,457,-1,383,375,38,-1,375,383,309,-1,135,305,119,-1,135,145,305,-1,374,138,457,-1,309,138,374,-1,458,139,151,-1,137,139,458,-1,145,285,372,-1,145,143,285,-1,310,415,382,-1,443,415,310,-1,417,150,416,-1,150,417,151,-1,458,52,457,-1,458,49,52,-1,302,303,301,-1,304,303,302,-1,157,18,17,-1,157,294,18,-1,422,396,425,-1,422,420,396,-1,169,428,167,-1,428,169,126,-1,163,140,381,-1,163,141,140,-1,170,23,322,-1,170,172,23,-1,372,47,397,-1,47,372,285,-1,319,46,48,-1,319,414,46,-1,287,439,445,-1,286,439,287,-1,445,118,444,-1,445,439,118,-1,370,222,221,-1,222,370,279,-1,278,370,326,-1,278,276,370,-1,277,329,313,-1,277,278,329,-1,54,447,168,-1,54,441,447,-1,357,440,358,-1,448,440,357,-1,274,438,115,-1,274,446,438,-1,272,206,207,-1,271,206,272,-1,330,79,81,-1,330,362,79,-1,98,213,212,-1,98,436,213,-1,453,337,432,-1,453,202,337,-1,197,456,267,-1,456,197,346,-1,392,267,113,-1,267,392,197,-1,265,261,111,-1,265,262,261,-1,265,263,262,-1,182,256,175,-1,182,260,256,-1,341,224,100,-1,341,340,224,-1,340,255,254,-1,340,342,255,-1,90,252,437,-1,90,253,252,-1,432,208,453,-1,432,355,208,-1,73,246,74,-1,73,247,246,-1,449,249,410,-1,250,249,449,-1,85,180,455,-1,85,394,180,-1,86,455,230,-1,86,85,455,-1,455,179,183,-1,455,180,179,-1,63,245,351,-1,63,242,245,-1,240,186,241,-1,186,240,389,-1,11,64,60,-1,10,64,11,-1,347,238,175,-1,356,238,347,-1,231,188,223,-1,231,86,188,-1,189,185,228,-1,189,230,185,-1,187,223,188,-1,223,187,221,-1,451,387,388,-1,450,387,451,-1,233,222,280,-1,233,223,222,-1,135,220,144,-1,135,134,220,-1,216,210,209,-1,216,218,210,-1,192,207,190,-1,192,362,207,-1,206,453,208,-1,454,453,206,-1,334,213,452,-1,334,214,213,-1,452,336,204,-1,452,434,336,-1,332,334,205,-1,332,335,334,-1,200,92,94,-1,200,201,92,-1,456,9,8,-1,456,346,9,-1,430,367,408,-1,430,365,367,-1,451,325,229,-1,451,328,325,-1,228,184,450,-1,185,184,228,-1,95,429,348,-1,361,429,95,-1,248,250,449,-1,248,247,250,-1,394,181,180,-1,181,394,354,-1,178,448,357,-1,446,448,178,-1,168,274,166,-1,168,447,274,-1,280,234,233,-1,280,444,234,-1,284,445,281,-1,284,287,445,-1,298,442,275,-1,298,378,442,-1,169,117,164,-1,117,169,166,-1,163,156,123,-1,163,399,156,-1,132,294,157,-1,294,132,58,-1,308,148,147,-1,308,122,148,-1,142,123,290,-1,142,141,123,-1,140,415,443,-1,415,140,142,-1,144,38,143,-1,144,383,38,-1,442,283,282,-1,442,312,283,-1,130,125,127,-1,130,129,125,-1,384,440,441,-1,385,440,384,-1,118,66,70,-1,177,66,118,-1,77,340,345,-1,77,224,340,-1,439,177,118,-1,177,439,438,-1,91,437,254,-1,437,91,90,-1,113,108,392,-1,108,113,104,-1,106,110,103,-1,114,110,106,-1,255,102,101,-1,255,257,102,-1,100,435,341,-1,100,99,435,-1,257,342,338,-1,342,257,255,-1,265,436,263,-1,265,434,436,-1,244,432,433,-1,432,244,355,-1,89,96,98,-1,91,96,89,-1,268,93,253,-1,268,94,93,-1,339,259,258,-1,339,260,259,-1,409,82,363,-1,409,83,82,-1,367,87,431,-1,88,87,367,-1,354,366,365,-1,394,366,354,-1,75,429,73,-1,75,369,429,-1,70,65,71,-1,70,66,65,-1,240,236,356,-1,236,240,239,-1,423,55,167,-1,423,427,55,-1,58,426,56,-1,131,426,58,-1,424,167,428,-1,424,423,167,-1,1,56,426,-1,3,56,1,-1,423,2,427,-1,2,423,425,-1,420,424,421,-1,422,424,420,-1,291,52,51,-1,291,398,52,-1,373,419,171,-1,373,397,419,-1,170,321,320,-1,322,321,170,-1,43,156,418,-1,156,43,40,-1,45,41,44,-1,42,41,45,-1,417,50,49,-1,50,417,315,-1,297,149,295,-1,297,416,149,-1,153,146,382,-1,153,155,146,-1,290,301,142,-1,290,34,301,-1,160,36,311,-1,300,36,160,-1,124,319,127,-1,414,319,124,-1,412,302,162,-1,412,304,302,-1,401,26,154,-1,401,15,26,-1,317,127,319,-1,127,317,130,-1,162,402,412,-1,402,162,404,-1,12,403,161,-1,403,12,6,-1,16,4,379,-1,4,16,5,-1,351,64,63,-1,351,350,64,-1,407,411,409,-1,410,411,407,-1,364,408,363,-1,408,364,430,-1,430,194,352,-1,430,364,194,-1,353,191,406,-1,353,193,191,-1,7,403,6,-1,7,400,403,-1,425,0,2,-1,396,0,425,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmet2_Coord',point=[(-3.10515,.73732,1.68843),(-3.09887,.76525,1.65676),(-3.09561,.76628,1.64286),(-3.09979,.75606,1.67754),(-2.8199,.78586,1.79982),(-2.81505,.77842,1.80549),(-2.79508,.78196,1.76054),(-2.81009,.76824,1.80699),(-2.77938,1.8761,-.24139),(-2.80963,1.84611,-.15632),(-2.76274,1.90545,-.15432),(-2.72252,1.92593,-.21307),(-2.79455,.79719,1.66508),(-2.81792,.79871,1.77787),(-2.81875,.84409,1.68003),(-2.83977,.74981,1.85915),(-2.87841,.78223,1.85514),(-2.86702,.89397,1.70586),(-2.88944,.84554,1.78553),(-2.87224,.56733,1.47834),(-2.8567,.65924,1.41895),(-2.8264,.64991,1.41571),(-2.87836,.4856,1.54885),(-2.86532,.41413,1.6201),(-2.89071,.44033,1.58368),(-2.85773,.48605,1.55121),(-2.84252,.74531,1.88304),(-2.88639,.78749,1.87634),(-3.12787,.69681,1.81799),(-3.14115,.60069,1.8647),(-3.14017,.7058,1.83685),(-3.12525,.60765,1.84634),(-2.80642,.63609,1.4161),(-2.851,.5621,1.48113),(-2.71638,.67873,1.55155),(-2.71463,.71578,1.39832),(-2.74982,.75426,1.41196),(-3.09055,.43338,1.71279),(-3.11316,.45842,1.91816),(-3.17042,.5184,1.87823),(-2.76041,.62561,1.40114),(-2.74476,.68119,1.37636),(-2.73621,.67465,1.38462),(-2.77149,.62888,1.39672),(-2.71683,.71337,1.39627),(-2.71016,.70475,1.40261),(-3.02742,.42362,1.52735),(-3.02474,.41407,1.53762),(-3.08914,.44156,1.70323),(-3.14521,.73766,1.89128),(-3.14275,.73913,1.8788),(-3.16508,.68312,1.87203),(-3.16921,.67158,1.88677),(-3.01501,.89344,1.47805),(-3.01632,.87787,1.46821),(-3.0595,.83783,1.54993),(-3.08127,.79026,1.7036),(-3.11087,.7157,1.78261),(-3.06616,.81171,1.70217),(-3.11178,.71363,1.7466),(-2.7049,1.9348,-.19425),(-2.67428,1.95054,-.26562),(-2.80357,1.86905,-.09646),(-2.77615,1.89484,-.06431),(-2.74103,1.91606,-.13114),(-2.66325,1.29581,.20296),(-2.73628,1.27824,.43849),(-2.74616,1.36971,.21626),(-2.78666,1.30784,.44067),(-2.68124,1.27113,.46153),(-2.70921,1.27384,.44208),(-2.63916,1.29311,.20887),(-2.59126,1.317,.22196),(-2.3612,1.60284,.11419),(-2.43594,1.5235,.19833),(-2.44667,1.49193,.17805),(-2.58422,1.32351,.21368),(-2.63265,1.28998,.18279),(-2.56152,1.32605,.17634),(-2.34768,1.99783,-.14509),(-2.21424,2.00802,-.0956),(-2.32438,1.881,-.15238),(-2.22776,2.01398,-.09071),(-2.21124,2.00454,-.08398),(-2.4713,1.69414,.27658),(-2.50632,1.71771,.26531),(-2.54853,1.62959,.38955),(-2.39248,1.77627,.21036),(-2.4337,1.79758,.18957),(-2.44858,1.23182,-.36285),(-2.45405,1.21846,-.34106),(-2.46536,1.22088,-.35306),(-2.30829,1.52339,-.11548),(-2.33421,1.36014,-.18435),(-2.32372,1.37597,-.20215),(-2.31521,1.50888,-.09472),(-2.49064,1.2713,-.39031),(-2.50222,1.29119,-.397),(-2.47101,1.28754,-.4029),(-2.74269,1.36377,.1399),(-2.73494,1.34524,.15647),(-2.51073,1.25205,-.35726),(-2.52865,1.2755,-.35066),(-2.67166,1.5849,-.19813),(-2.68456,1.58954,-.25191),(-2.67326,1.58038,-.26737),(-2.66148,1.57368,-.20602),(-2.73939,1.60467,-.14274),(-2.73059,1.60533,-.15504),(-2.69053,1.53152,-.16213),(-2.69379,1.55093,-.16742),(-2.62928,1.52055,-.29219),(-2.63016,1.52449,-.27916),(-2.68411,1.59598,-.27569),(-2.68383,1.54122,-.17847),(-2.85658,.83638,1.25193),(-2.92085,.64904,1.39827),(-2.95859,.6663,1.41398),(-2.74837,1.11256,.7903),(-2.93462,.54383,2.04807),(-2.90466,.44635,1.94995),(-2.86894,.50764,1.96284),(-2.92565,.61455,2.07002),(-2.71666,.57019,1.51712),(-3.01618,.48074,1.50381),(-3.05879,.54427,1.67946),(-3.03209,.56739,1.54476),(-3.06826,.4981,1.67748),(-3.10287,.63027,1.81291),(-3.07786,.58374,1.75742),(-3.09482,.56614,1.81041),(-3.06608,.84687,1.62319),(-3.05279,.84991,1.63532),(-3.02188,.87825,1.56596),(-2.97675,.54021,2.05379),(-2.99201,.46972,2.00469),(-3.08445,.56213,2.03226),(-3.10654,.62703,2.02691),(-3.1302,.58249,1.99955),(-3.06264,.65343,2.05351),(-2.74471,.53579,1.66669),(-2.73053,.54241,1.61106),(-2.744,.60117,1.67329),(-3.05201,.41721,1.92354),(-3.05401,.461,1.98602),(-2.99295,.40603,1.9373),(-2.85811,.76034,1.95837),(-2.91716,.75677,2.02069),(-2.88421,.69942,2.02305),(-2.89667,.81727,1.9393),(-2.9712,.78007,2.00832),(-3.04445,.76429,1.98753),(-3.00578,.65033,2.06624),(-2.81949,.66387,1.91097),(-2.8272,.67953,1.85574),(-2.85487,.76242,1.94504),(-2.80077,.53395,1.47898),(-2.99606,.87241,1.67298),(-2.97928,.91992,1.57719),(-2.75764,.7313,1.38701),(-2.77778,.76282,1.5585),(-2.77942,.74839,1.66906),(-2.78787,.691,1.7038),(-2.7388,.512,1.57367),(-2.98676,.56741,1.45934),(-2.93829,.56147,1.46023),(-2.97493,.74563,1.44439),(-3.02817,.7465,1.52962),(-3.00138,.80876,1.46853),(-3.01236,.65828,1.49033),(-2.87868,.38094,1.65107),(-2.93711,.40778,1.54883),(-2.87773,.4029,1.63301),(-2.93892,.44208,1.52839),(-2.79781,1.55808,.24306),(-2.82929,1.59025,.07802),(-2.78028,1.49427,.23031),(-2.7706,1.11552,.78547),(-2.8185,1.17597,.78529),(-2.60716,1.82363,.11331),(-2.55239,1.81179,.13983),(-2.50998,1.87688,.03664),(-2.76735,1.56594,-.04562),(-2.7047,1.77016,.1904),(-2.78048,1.66754,.3003),(-2.72641,1.69013,.33738),(-2.76799,1.73513,.19404),(-2.7351,1.36251,.88758),(-2.60928,1.52872,.56236),(-2.68294,1.58528,.53308),(-2.59326,1.99498,-.3032),(-2.54843,1.97138,-.15126),(-2.47718,1.99375,-.1999),(-2.46763,1.95783,-.11121),(-2.41448,1.95062,-.09343),(-2.3621,2.01172,-.14652),(-2.82869,1.61512,-.04982),(-2.77412,1.66425,-.16492),(-2.30222,1.45845,-.28699),(-2.29014,1.54523,-.23504),(-2.29656,1.44559,-.27556),(-2.28841,1.54026,-.21709),(-2.59257,1.68334,-.42405),(-2.58472,1.6967,-.41886),(-2.53268,1.6698,-.37796),(-2.52716,1.68296,-.37165),(-2.64377,1.90949,-.38934),(-2.58123,1.98669,-.30866),(-2.66004,1.91909,-.39033),(-2.17024,1.944,-.0704),(-2.17264,1.93542,-.08516),(-2.37764,1.37272,-.40202),(-2.37951,1.35533,-.40107),(-2.47224,1.44853,-.42266),(-2.45191,1.45485,-.41261),(-2.34172,2.0134,-.13776),(-2.18239,1.83515,-.07101),(-2.23636,1.71638,-.14567),(-2.18545,1.83894,-.08675),(-2.24076,1.7266,-.15872),(-3.0368,.54623,2.05103),(-2.64863,1.29718,.87987),(-2.62667,1.21968,.87712),(-2.56921,1.44873,.55031),(-2.65744,1.29326,.18022),(-2.81588,1.60538,.24537),(-2.84956,1.4287,.4633),(-2.8535,1.48244,.47308),(-2.76447,1.58314,.52306),(-2.82692,1.39009,.88583),(-2.6435,1.67606,.35884),(-2.48201,1.5601,.38595),(-2.49324,1.45874,.32959),(-2.57291,1.35487,.52895),(-2.627,1.313,.49524),(-2.54212,1.38787,.27577),(-2.83874,1.79929,-.01417),(-2.83749,1.72879,-.06479),(-2.85318,1.69873,.03614),(-2.82585,1.82187,.03017),(-2.82167,1.74667,.11397),(-2.80365,1.79879,.09656),(-2.76526,1.85809,.02317),(-2.82981,1.81952,-.09954),(-2.73327,1.91246,-.31188),(-2.6895,1.85046,.08193),(-2.42464,1.63827,.29686),(-2.34462,1.69842,.19245),(-2.34881,1.72812,.20737),(-2.24213,1.77734,.04911),(-2.26481,1.75859,.08804),(-2.28179,1.67666,.01392),(-2.42824,1.26756,-.07088),(-2.37724,1.26093,-.28002),(-2.5612,1.21471,-.16089),(-2.59508,1.25576,-.17848),(-2.72706,1.47263,.0564),(-2.6087,1.29314,-.18957),(-2.59406,1.39531,-.20981),(-2.61186,1.42547,-.1919),(-2.67503,1.46976,-.06694),(-2.62765,1.51202,-.28708),(-2.57974,1.39293,-.32471),(-2.55752,1.40365,-.40861),(-2.61622,1.60651,-.35675),(-2.6056,1.51802,-.39708),(-2.66466,1.65873,-.3766),(-2.71833,1.66081,-.28855),(-2.36733,1.27618,-.29833),(-2.26177,1.79118,-.1607),(-2.38885,1.46916,-.36572),(-2.55585,1.85117,-.32789),(-2.52293,1.88395,-.276),(-2.43884,1.75109,-.2324),(-2.91603,.8935,1.25438),(-2.80583,.96022,1.46645),(-2.78601,1.02653,1.34544),(-2.86545,.99033,1.47899),(-2.84269,1.06486,1.36775),(-2.70935,1.06672,1.1519),(-2.64443,1.17503,.85494),(-2.70507,1.02922,1.11511),(-2.75983,.96403,1.3313),(-2.73413,.90152,1.31716),(-2.75729,.87092,1.29083),(-3.03476,.37812,1.74414),(-2.83427,.83221,1.25673),(-2.80173,.8486,1.27116),(-2.78208,.71828,1.35878),(-2.76758,.70031,1.36717),(-2.71205,.6665,1.54831),(-3.1711,.58393,1.88876),(-3.05766,.60403,1.68607),(-3.02499,.76174,1.81711),(-3.0115,.83405,1.75038),(-2.89193,.81788,1.92685),(-2.91101,.81968,1.85269),(-2.95125,.84133,1.91352),(-2.81334,.92086,1.54594),(-2.86462,.95556,1.56325),(-2.77222,.74334,1.56373),(-2.74832,.61377,1.67685),(-2.78097,.6643,1.7014),(-2.78044,.61152,1.80173),(-2.80223,.65926,1.79269),(-2.95209,.4117,1.94028),(-2.85056,.39779,1.7916),(-2.9122,.3685,1.77157),(-2.95503,.63693,2.07652),(-3.13576,.53423,1.98496),(-2.84785,.57696,1.96587),(-2.75587,.777,1.40159),(-2.756,.83065,1.42795),(-2.94989,.98697,1.47274),(-3.01642,.77024,1.83768),(-3.04757,.80475,1.89317),(-2.98516,.93713,1.47215),(-3.1144,.54081,1.84193),(-3.17301,.52634,1.86769),(-3.07833,.46067,1.68072),(-2.88078,.37503,1.66225),(-2.82783,.41294,1.61738),(-2.83628,.41471,1.61073),(-2.82532,.46949,1.5454),(-2.77074,.74362,1.37472),(-2.88294,1.20674,1.1755),(-2.80636,1.19875,1.18949),(-2.95341,1.02242,1.34117),(-2.93399,1.17518,1.15125),(-2.92523,1.06048,1.35299),(-2.45817,1.90807,-.20905),(-2.3064,1.63387,-.20407),(-2.4226,1.63669,-.27678),(-2.5542,1.77814,-.35631),(-2.51016,1.57418,-.41257),(-2.40561,1.55294,-.32131),(-2.59927,1.61849,-.37034),(-2.64678,1.66276,-.39384),(-2.67745,1.32103,-.06639),(-2.66194,1.4206,-.05902),(-2.6424,1.24752,.0158),(-2.70397,1.30311,.07254),(-2.66018,1.27584,-.05664),(-2.72531,1.4195,.11377),(-2.48667,1.28435,.07098),(-2.58566,1.23673,.03453),(-2.80236,1.76356,-.16467),(-2.81216,1.6612,.16686),(-2.38068,1.4113,.03034),(-2.29966,1.62503,-.19058),(-2.63754,1.92379,-.05574),(-2.66602,1.90332,-.00312),(-2.44556,1.90603,-.02217),(-2.48866,1.91777,-.03812),(-2.47691,1.86072,.05054),(-2.71701,1.91768,-.33172),(-2.84297,1.70281,.09012),(-2.86464,1.24338,.8169),(-2.89943,1.29396,.84063),(-2.82137,1.3697,.45516),(-2.25745,1.68453,-.04912),(-2.28626,1.65436,-.00364),(-2.46765,1.98658,-.20443),(-2.294,1.97097,-.021),(-2.38665,1.95128,-.08068),(-2.44761,1.86149,.05996),(-2.46104,1.7855,.17028),(-2.37191,1.86738,.11534),(-2.45927,1.37896,.12391),(-2.44476,1.4594,.14996),(-2.72741,1.12998,1.17543),(-2.92469,.47316,1.51917),(-2.97502,.3624,1.75819),(-2.94557,.40068,1.55471),(-3.17241,.56384,1.92606),(-3.1647,.51148,1.91318),(-2.89719,.6474,1.39942),(-2.91181,.56168,1.46491),(-2.78312,.85247,1.53718),(-2.89868,.81372,1.83114),(-2.81067,.45746,1.80304),(-2.76118,.46836,1.63516),(-2.81997,.65324,1.92022),(-3.09691,.48955,1.98402),(-2.9763,.99117,1.33557),(-2.94676,1.14563,1.13478),(-3.08368,.64052,1.77538),(-2.8514,1.50085,.48081),(-2.90064,1.31146,.84846),(-2.79696,1.6924,.18689),(-2.8085,1.6358,.26764),(-2.95423,.47137,1.50634),(-2.7421,1.61499,-.15201),(-2.70926,1.42231,.05477),(-2.48935,1.78761,.15733),(-3.08341,.66178,1.75432),(-3.10097,.72506,1.68637),(-2.96427,.40563,1.54209),(-3.1758,.58288,1.90047),(-2.81337,.46978,1.54649),(-2.80362,.75627,1.80338),(-2.82788,.69841,1.83886),(-2.79816,.752,1.79021),(-2.79149,.77041,1.76148),(-2.79342,.75307,1.76954),(-2.21946,1.7961,.01017),(-2.59303,1.94742,-.10316),(-2.28568,1.90498,.06228),(-2.33295,1.91918,.04717),(-2.24954,1.95368,-.00523),(-2.24634,1.85473,.06949),(-2.21949,1.89154,.02108),(-2.80756,.68332,1.78976),(-2.95799,.44324,1.51982),(-3.02247,.449,1.51427),(-2.77847,.59784,1.80315),(-2.954,.84044,1.92572),(-3.0502,.80503,1.90487),(-2.81245,.53527,1.47687),(-2.95972,.41329,1.53278),(-3.09427,.71672,1.6706),(-3.05969,.6293,1.67524),(-3.08995,.72544,1.65047),(-3.03869,.74899,1.55055),(-3.04211,.66499,1.59293),(-3.08904,.74597,1.64012),(-3.07821,.82781,1.61863),(-3.06592,.83203,1.56177),(-3.03339,.64478,1.57492),(-2.36201,1.57077,.08616),(-2.41699,1.90674,-.01111),(-2.32183,1.85629,.12978),(-2.68716,1.79318,-.37114),(-2.70327,1.78769,-.35196),(-2.58857,1.5263,-.41139),(-2.72008,1.33921,.0615),(-2.54165,1.41192,-.4215),(-2.50798,1.20668,-.13633),(-2.82398,.9879,1.03888),(-2.80214,.98353,1.0449),(-2.9449,1.12951,1.12455),(-2.97682,.97564,1.32525),(-2.77297,.89172,1.44736),(-2.78791,.52993,1.80496),(-2.70192,1.14045,.81915),(-2.75916,1.00378,1.07601),(-2.86166,1.02137,1.04571),(-2.9486,.93895,1.29187),(-2.90599,1.0791,1.0878),(-2.27319,1.81794,.11787),(-2.81999,1.55317,.50221),(-2.87842,1.35553,.86732),(-2.52521,1.57219,-.41918),(-2.63868,1.78974,-.41289),(-2.62162,1.79338,-.40921),(-2.59493,1.74648,.24347),(-2.75602,1.77855,-.2637),(-3.16962,.61622,1.9411),(-3.13456,.70073,1.96217)]))),
        Shape(DEF='rmet3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmet3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,31,32,33,-1,31,34,32,-1,35,36,37,-1,36,38,37,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,45,43,46,-1,48,40,49,-1,48,41,40,-1,47,46,50,-1,50,51,47,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,66,-1,65,67,66,-1,68,69,70,-1,70,71,68,-1,71,63,68,-1,72,73,74,-1,73,75,74,-1,76,77,78,-1,78,79,76,-1,28,80,81,-1,28,82,80,-1,83,84,85,-1,85,86,83,-1,5,4,87,-1,4,88,87,-1,89,90,91,-1,89,92,90,-1,93,94,95,-1,96,97,98,-1,98,99,96,-1,22,100,23,-1,22,101,100,-1,102,103,104,-1,104,105,102,-1,106,107,108,-1,106,109,107,-1,110,111,112,-1,110,113,111,-1,114,115,116,-1,117,118,119,-1,94,120,121,-1,122,123,124,-1,125,126,127,-1,128,129,130,-1,128,131,129,-1,132,133,134,-1,134,135,132,-1,133,132,136,-1,137,138,139,-1,140,9,141,-1,141,142,140,-1,143,144,145,-1,143,146,144,-1,146,147,144,-1,148,149,150,-1,151,152,153,-1,152,16,153,-1,52,154,155,-1,156,157,158,-1,6,159,160,-1,159,161,160,-1,162,8,7,-1,7,163,162,-1,164,112,111,-1,154,54,157,-1,154,52,54,-1,165,136,166,-1,30,82,28,-1,167,29,28,-1,167,168,29,-1,169,170,171,-1,172,173,174,-1,175,46,43,-1,176,39,41,-1,176,177,39,-1,171,68,178,-1,178,173,171,-1,179,180,181,-1,182,118,183,-1,184,185,186,-1,185,187,186,-1,110,188,189,-1,110,112,188,-1,190,137,191,-1,192,125,127,-1,193,194,195,-1,194,121,195,-1,116,115,15,-1,196,197,198,-1,199,155,103,-1,155,104,103,-1,189,188,200,-1,201,202,203,-1,201,204,202,-1,205,199,206,-1,206,186,205,-1,207,208,117,-1,209,210,211,-1,210,212,211,-1,213,214,215,-1,214,216,215,-1,217,218,219,-1,105,111,113,-1,104,155,154,-1,154,220,104,-1,221,184,206,-1,221,106,184,-1,222,18,20,-1,223,224,225,-1,15,153,16,-1,15,226,153,-1,194,94,121,-1,227,228,164,-1,227,229,228,-1,230,231,109,-1,231,107,109,-1,230,204,232,-1,230,56,204,-1,233,234,235,-1,202,204,55,-1,204,56,55,-1,236,237,238,-1,238,239,236,-1,240,241,139,-1,139,242,240,-1,9,190,166,-1,190,191,166,-1,243,141,9,-1,9,244,243,-1,141,192,127,-1,96,120,94,-1,245,246,247,-1,245,99,246,-1,97,134,98,-1,97,248,134,-1,249,192,243,-1,249,123,192,-1,124,250,251,-1,136,165,252,-1,253,254,252,-1,252,165,253,-1,179,255,256,-1,162,247,246,-1,162,163,247,-1,257,258,32,-1,259,260,261,-1,262,38,36,-1,75,84,263,-1,75,264,84,-1,68,171,170,-1,63,71,265,-1,212,266,267,-1,266,175,267,-1,268,81,269,-1,51,270,47,-1,39,271,272,-1,272,40,39,-1,273,45,47,-1,274,44,275,-1,274,42,44,-1,276,277,278,-1,278,279,276,-1,280,281,282,-1,281,88,282,-1,92,89,48,-1,1,283,2,-1,275,284,280,-1,45,177,176,-1,285,286,48,-1,287,288,76,-1,76,289,287,-1,36,290,262,-1,36,291,290,-1,78,77,292,-1,77,34,292,-1,77,257,34,-1,257,32,34,-1,286,92,48,-1,48,49,285,-1,44,284,275,-1,280,48,89,-1,280,284,48,-1,281,280,89,-1,275,293,294,-1,24,277,276,-1,24,295,277,-1,45,273,177,-1,288,296,80,-1,288,287,296,-1,297,298,168,-1,297,299,298,-1,300,301,302,-1,303,304,62,-1,303,305,304,-1,306,69,68,-1,68,170,306,-1,264,307,84,-1,73,35,37,-1,75,5,74,-1,299,297,308,-1,309,310,54,-1,54,311,309,-1,312,6,8,-1,313,133,136,-1,136,252,313,-1,250,123,249,-1,250,124,123,-1,98,134,133,-1,133,313,98,-1,93,248,97,-1,93,129,248,-1,245,120,96,-1,96,99,245,-1,11,244,9,-1,191,137,139,-1,139,314,191,-1,139,241,315,-1,315,314,139,-1,316,317,144,-1,144,147,316,-1,239,318,236,-1,239,319,318,-1,320,242,321,-1,242,322,321,-1,185,184,108,-1,184,106,108,-1,323,324,325,-1,312,325,159,-1,159,6,312,-1,326,327,225,-1,326,328,327,-1,208,329,117,-1,329,208,330,-1,330,331,329,-1,160,332,163,-1,160,333,332,-1,207,114,334,-1,53,223,225,-1,53,335,223,-1,105,104,220,-1,216,336,215,-1,216,209,336,-1,337,338,339,-1,210,340,212,-1,340,266,212,-1,341,216,303,-1,216,214,303,-1,342,343,344,-1,343,295,344,-1,294,293,278,-1,278,277,294,-1,311,345,309,-1,52,199,205,-1,52,155,199,-1,206,184,186,-1,346,110,189,-1,102,105,113,-1,113,57,102,-1,17,116,15,-1,347,194,331,-1,331,330,347,-1,348,193,195,-1,348,183,193,-1,125,192,128,-1,192,123,128,-1,349,202,346,-1,349,203,202,-1,55,110,202,-1,110,346,202,-1,233,150,149,-1,233,235,150,-1,8,350,312,-1,179,181,255,-1,300,67,351,-1,282,88,352,-1,68,63,178,-1,284,41,48,-1,284,176,41,-1,297,353,308,-1,354,65,64,-1,169,83,306,-1,306,170,169,-1,46,301,50,-1,46,355,301,-1,356,357,358,-1,356,359,357,-1,101,145,100,-1,101,143,145,-1,233,185,234,-1,233,197,185,-1,360,130,361,-1,360,126,130,-1,136,362,10,-1,363,12,14,-1,14,364,363,-1,364,244,11,-1,166,136,10,-1,156,227,365,-1,188,366,240,-1,188,228,366,-1,254,253,367,-1,253,368,367,-1,163,7,6,-1,6,160,163,-1,220,154,365,-1,17,16,198,-1,16,152,198,-1,224,326,225,-1,201,203,236,-1,203,237,236,-1,320,200,188,-1,127,142,141,-1,127,369,142,-1,370,371,219,-1,332,247,163,-1,207,117,372,-1,117,119,372,-1,119,118,373,-1,193,331,194,-1,110,57,113,-1,110,55,57,-1,22,21,108,-1,108,107,22,-1,220,365,111,-1,111,105,220,-1,22,107,231,-1,94,97,96,-1,94,93,97,-1,246,313,162,-1,89,2,281,-1,89,91,2,-1,296,272,374,-1,374,269,296,-1,351,86,375,-1,86,85,375,-1,3,5,263,-1,263,169,3,-1,2,91,0,-1,1,0,376,-1,76,257,77,-1,76,288,257,-1,64,66,60,-1,69,377,70,-1,69,378,377,-1,379,265,380,-1,379,59,265,-1,379,354,59,-1,378,69,306,-1,19,198,152,-1,19,196,198,-1,222,187,18,-1,222,186,187,-1,381,382,340,-1,63,58,61,-1,43,45,44,-1,287,49,40,-1,356,383,384,-1,2,283,385,-1,276,174,27,-1,27,24,276,-1,295,24,26,-1,26,344,295,-1,25,27,386,-1,100,344,26,-1,100,145,344,-1,157,54,310,-1,363,364,11,-1,141,243,192,-1,9,166,10,-1,387,4,3,-1,387,388,4,-1,75,263,5,-1,308,261,299,-1,388,172,279,-1,172,388,387,-1,26,23,100,-1,23,26,25,-1,235,389,150,-1,235,386,389,-1,386,305,389,-1,305,386,27,-1,390,385,283,-1,390,391,385,-1,392,393,394,-1,392,292,393,-1,395,30,29,-1,30,395,258,-1,61,381,340,-1,61,58,381,-1,52,335,53,-1,52,205,335,-1,18,196,19,-1,18,187,196,-1,67,377,378,-1,67,65,377,-1,308,358,357,-1,358,308,353,-1,259,307,38,-1,259,396,307,-1,397,391,398,-1,397,385,391,-1,399,376,0,-1,399,400,376,-1,358,167,268,-1,353,167,358,-1,73,264,75,-1,73,37,264,-1,257,80,82,-1,257,288,80,-1,2,88,281,-1,88,2,87,-1,356,300,359,-1,356,384,300,-1,286,289,401,-1,286,285,289,-1,269,383,356,-1,269,374,383,-1,285,287,289,-1,49,287,285,-1,99,313,246,-1,313,99,98,-1,402,106,221,-1,106,402,109,-1,118,329,183,-1,118,117,329,-1,329,193,183,-1,329,331,193,-1,120,403,121,-1,120,245,403,-1,404,13,405,-1,404,251,13,-1,12,362,406,-1,12,363,362,-1,190,140,407,-1,9,140,190,-1,201,318,408,-1,201,236,318,-1,349,237,203,-1,349,321,237,-1,198,148,17,-1,198,149,148,-1,365,164,111,-1,365,227,164,-1,373,345,327,-1,373,409,345,-1,410,253,315,-1,253,410,368,-1,366,241,240,-1,241,366,411,-1,367,162,254,-1,8,162,367,-1,244,249,243,-1,249,244,364,-1,123,131,128,-1,122,131,123,-1,412,405,135,-1,405,412,404,-1,406,136,132,-1,362,136,406,-1,413,94,194,-1,95,94,413,-1,414,130,129,-1,361,130,414,-1,360,127,126,-1,371,127,360,-1,108,234,185,-1,234,108,21,-1,197,149,198,-1,149,197,233,-1,415,116,416,-1,415,417,116,-1,347,413,194,-1,413,347,418,-1,21,235,234,-1,235,21,23,-1,384,301,300,-1,50,301,384,-1,86,306,83,-1,306,86,378,-1,271,177,273,-1,271,39,177,-1,382,301,355,-1,382,302,301,-1,282,278,293,-1,278,282,352,-1,351,378,86,-1,67,378,351,-1,227,158,229,-1,227,156,158,-1,419,8,367,-1,350,8,419,-1,317,219,420,-1,370,219,317,-1,321,238,237,-1,322,238,321,-1,347,334,417,-1,334,347,330,-1,197,187,185,-1,197,196,187,-1,326,226,328,-1,326,153,226,-1,294,295,343,-1,294,277,295,-1,342,145,420,-1,342,344,145,-1,336,415,215,-1,336,418,415,-1,303,61,341,-1,61,303,62,-1,421,337,422,-1,421,338,337,-1,211,422,423,-1,421,422,211,-1,423,95,413,-1,422,95,423,-1,226,115,372,-1,115,226,15,-1,215,416,213,-1,416,215,415,-1,182,348,333,-1,182,183,348,-1,328,372,119,-1,226,372,328,-1,119,327,328,-1,119,373,327,-1,325,409,159,-1,409,325,324,-1,373,182,161,-1,118,182,373,-1,230,424,231,-1,424,230,232,-1,232,146,424,-1,146,232,408,-1,316,318,319,-1,316,147,318,-1,144,420,145,-1,144,317,420,-1,142,239,140,-1,142,319,239,-1,315,165,314,-1,315,253,165,-1,166,314,165,-1,314,166,191,-1,337,361,414,-1,337,339,361,-1,333,403,332,-1,333,348,403,-1,256,411,366,-1,256,255,411,-1,181,368,410,-1,181,180,368,-1,309,409,324,-1,345,409,309,-1,180,367,368,-1,367,180,419,-1,323,157,310,-1,323,425,157,-1,312,323,325,-1,350,323,312,-1,174,178,304,-1,178,174,173,-1,261,426,299,-1,426,261,260,-1,84,396,85,-1,396,84,307,-1,377,380,70,-1,377,379,380,-1,303,389,305,-1,389,303,214,-1,65,379,377,-1,65,354,379,-1,216,210,209,-1,216,341,210,-1,340,355,266,-1,382,355,340,-1,46,266,355,-1,175,266,46,-1,427,299,426,-1,299,427,298,-1,395,168,298,-1,29,168,395,-1,81,296,269,-1,81,80,296,-1,82,258,257,-1,258,82,30,-1,267,338,421,-1,267,42,338,-1,275,343,274,-1,343,275,294,-1,280,293,275,-1,280,282,293,-1,397,5,87,-1,74,5,397,-1,401,76,79,-1,401,289,76,-1,90,79,399,-1,401,79,90,-1,0,90,399,-1,91,90,0,-1,394,398,391,-1,394,428,398,-1,428,393,429,-1,394,393,428,-1,427,31,33,-1,427,430,31,-1,291,430,290,-1,291,429,430,-1,427,290,430,-1,426,290,427,-1,430,393,31,-1,430,429,393,-1,290,260,262,-1,260,290,426,-1,431,429,291,-1,428,429,431,-1,428,72,398,-1,72,428,431,-1,390,400,392,-1,376,400,390,-1,400,292,392,-1,292,400,78,-1,87,385,397,-1,87,2,385,-1,388,88,4,-1,388,352,88,-1,279,352,388,-1,279,278,352,-1,274,342,218,-1,342,274,343,-1,42,218,338,-1,218,42,274,-1,42,175,43,-1,267,175,42,-1,374,271,270,-1,374,272,271,-1,374,51,383,-1,270,51,374,-1,358,269,356,-1,268,269,358,-1,33,298,427,-1,298,33,395,-1,357,375,432,-1,375,357,359,-1,421,212,267,-1,421,211,212,-1,340,341,61,-1,210,341,340,-1,300,66,67,-1,300,302,66,-1,63,304,178,-1,62,304,63,-1,380,71,70,-1,380,265,71,-1,27,304,305,-1,27,174,304,-1,432,85,396,-1,432,375,85,-1,260,38,262,-1,259,38,260,-1,425,350,419,-1,425,323,350,-1,310,324,323,-1,324,310,309,-1,157,179,158,-1,425,179,157,-1,313,254,162,-1,313,252,254,-1,255,410,411,-1,181,410,255,-1,256,158,179,-1,256,229,158,-1,228,256,366,-1,228,229,256,-1,14,251,250,-1,13,251,14,-1,348,121,403,-1,348,195,121,-1,422,414,95,-1,337,414,422,-1,339,360,361,-1,360,339,217,-1,217,371,360,-1,217,219,371,-1,138,242,139,-1,322,242,138,-1,238,140,239,-1,140,238,407,-1,369,319,142,-1,369,316,319,-1,408,204,201,-1,408,232,204,-1,424,143,101,-1,143,424,146,-1,101,231,424,-1,101,22,231,-1,109,56,230,-1,109,402,56,-1,242,188,240,-1,242,320,188,-1,333,161,182,-1,161,333,160,-1,418,423,413,-1,423,418,336,-1,213,148,150,-1,148,213,416,-1,151,223,20,-1,224,223,151,-1,335,20,223,-1,20,335,222,-1,221,199,103,-1,221,206,199,-1,402,57,56,-1,102,57,402,-1,150,214,213,-1,214,150,389,-1,336,211,423,-1,336,209,211,-1,330,207,334,-1,330,208,207,-1,152,20,19,-1,152,151,20,-1,189,349,346,-1,349,189,200,-1,417,114,116,-1,114,417,334,-1,217,338,218,-1,338,217,339,-1,322,407,238,-1,138,407,322,-1,218,420,219,-1,218,342,420,-1,179,419,180,-1,179,425,419,-1,73,431,35,-1,73,72,431,-1,273,270,271,-1,47,270,273,-1,172,171,173,-1,172,387,171,-1,171,3,169,-1,171,387,3,-1,353,168,167,-1,353,297,168,-1,418,417,415,-1,418,347,417,-1,416,17,148,-1,416,116,17,-1,316,370,317,-1,316,369,370,-1,129,95,414,-1,129,93,95,-1,405,132,135,-1,406,132,405,-1,131,404,412,-1,404,131,122,-1,53,311,54,-1,53,225,311,-1,315,411,410,-1,315,241,411,-1,409,161,159,-1,409,373,161,-1,327,311,225,-1,345,311,327,-1,112,228,188,-1,112,164,228,-1,156,154,157,-1,154,156,365,-1,224,153,326,-1,153,224,151,-1,200,321,349,-1,200,320,321,-1,147,408,318,-1,146,408,147,-1,138,190,407,-1,190,138,137,-1,371,369,127,-1,371,370,369,-1,129,412,248,-1,129,131,412,-1,248,135,134,-1,412,135,248,-1,125,130,126,-1,130,125,128,-1,363,10,362,-1,11,10,363,-1,405,12,406,-1,13,12,405,-1,122,251,404,-1,122,124,251,-1,364,250,249,-1,364,14,250,-1,332,245,247,-1,332,403,245,-1,114,372,115,-1,207,372,114,-1,103,402,221,-1,102,402,103,-1,40,296,287,-1,272,296,40,-1,351,359,300,-1,359,351,375,-1,401,92,286,-1,92,401,90,-1,169,84,83,-1,84,169,263,-1,261,396,259,-1,261,432,396,-1,81,167,28,-1,167,81,268,-1,399,78,400,-1,399,79,78,-1,283,376,390,-1,283,1,376,-1,398,74,397,-1,74,398,72,-1,38,264,37,-1,38,307,264,-1,308,432,261,-1,308,357,432,-1,59,64,60,-1,354,64,59,-1,58,66,381,-1,58,60,66,-1,302,381,66,-1,302,382,381,-1,222,205,186,-1,205,222,335,-1,383,50,384,-1,51,50,383,-1,44,176,284,-1,176,44,45,-1,291,35,431,-1,291,36,35,-1,32,395,33,-1,32,258,395,-1,292,31,393,-1,292,34,31,-1,391,392,394,-1,391,390,392,-1,23,386,235,-1,23,25,386,-1,276,172,174,-1,276,279,172,-1,63,59,58,-1,265,59,63,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmet3_Coord',point=[(-3.31978,.44026,1.44742),(-3.32426,.42322,1.42283),(-3.34681,.47148,1.35864),(-3.55429,.45788,1.27791),(-3.53486,.45584,1.26697),(-3.55356,.43358,1.28458),(-2.90881,1.94815,-.21784),(-2.81549,1.91692,-.16785),(-2.82305,1.79789,-.22691),(-2.79587,1.31,-.14174),(-2.8099,1.48452,-.17159),(-2.81986,1.47302,-.13704),(-2.83129,1.58763,-.0633),(-2.84518,1.58458,-.02305),(-2.85061,1.54825,-.04357),(-3.28005,1.67878,-.01444),(-3.30983,1.63152,-.05671),(-3.29545,1.55242,.01868),(-3.27765,1.51687,-.11918),(-3.29234,1.53612,-.09468),(-3.29477,1.61286,-.1765),(-3.23597,1.27249,.12013),(-3.22018,1.24443,.12173),(-3.26204,1.21495,.26131),(-3.38322,.90875,.88066),(-3.34965,1.06832,.56784),(-3.32581,1.05556,.56926),(-3.41715,.92162,.87438),(-3.32723,.75887,1.72644),(-3.34354,.69246,1.77479),(-3.33043,.68227,1.76773),(-3.40754,.42921,1.74551),(-3.38425,.54071,1.81434),(-3.40502,.53982,1.82157),(-3.39018,.43745,1.73951),(-3.67583,.36599,1.49545),(-3.6986,.40814,1.61118),(-3.71237,.40844,1.48323),(-3.72443,.45593,1.59019),(-3.25112,.66534,1.54345),(-3.33766,.59713,1.67533),(-3.30162,.60359,1.53954),(-3.18346,1.04248,1.01302),(-3.2645,.85563,1.30713),(-3.26049,.83369,1.2974),(-3.25541,.83458,1.31973),(-3.32296,.88025,1.43392),(-3.31465,.8662,1.45274),(-3.32106,.57179,1.53152),(-3.34367,.5766,1.67053),(-3.40241,.84125,1.54639),(-3.38205,.83672,1.55484),(-3.15496,1.5878,-.44069),(-3.18699,1.62386,-.43512),(-3.15165,1.62866,-.45424),(-3.03969,1.30242,-.36914),(-3.08681,1.28451,-.29005),(-3.05633,1.3338,-.36204),(-3.48581,.85138,1.37089),(-3.57977,.73957,1.44934),(-3.52543,.80647,1.49124),(-3.47427,.88309,1.26901),(-3.48602,.83981,1.21822),(-3.51488,.76654,1.28683),(-3.53576,.79573,1.51507),(-3.56447,.75556,1.54541),(-3.497,.81698,1.51942),(-3.5551,.75364,1.57006),(-3.5433,.62707,1.34787),(-3.61312,.57965,1.47114),(-3.62385,.60749,1.46397),(-3.57058,.6489,1.38249),(-3.56984,.36288,1.34362),(-3.66045,.3853,1.36114),(-3.56547,.38195,1.31573),(-3.65027,.41327,1.34913),(-3.38464,.46484,1.70758),(-3.38126,.44836,1.72155),(-3.37999,.39811,1.62774),(-3.37361,.41713,1.62129),(-3.31737,.66463,1.72971),(-3.32748,.7692,1.69855),(-3.3252,.67411,1.75853),(-3.63175,.50571,1.49657),(-3.66004,.46801,1.51198),(-3.6487,.58931,1.61854),(-3.63392,.60202,1.58702),(-3.41267,.46103,1.31889),(-3.40556,.49227,1.30208),(-3.32521,.48119,1.46196),(-3.35278,.43383,1.53811),(-3.32219,.45902,1.46317),(-3.3526,.45054,1.54064),(-2.99195,1.65395,.15619),(-3.00849,1.68466,.15575),(-3.04829,1.60736,.26519),(-2.94055,1.71181,.05906),(-2.93192,1.67649,.05954),(-2.89114,1.68869,-.03374),(-2.89515,1.71654,-.02536),(-3.23533,1.20255,.26334),(-3.20493,1.2212,.12164),(-3.07908,1.39025,-.34519),(-3.08613,1.42667,-.34744),(-2.96007,1.44489,-.43462),(-2.96684,1.41222,-.43495),(-3.15632,1.41614,-.20478),(-3.19631,1.3032,-.04347),(-3.20245,1.33767,-.03312),(-3.14495,1.38183,-.21054),(-2.99311,1.35241,-.42574),(-2.97352,1.38054,-.47346),(-2.96606,1.35992,-.47637),(-3.00244,1.38424,-.4148),(-3.21878,1.69296,.00898),(-3.24185,1.68809,.00164),(-3.28867,1.61129,.05989),(-3.11215,1.83552,-.15329),(-3.09666,1.85692,-.18514),(-3.11511,1.84824,-.19519),(-2.97208,1.78109,.08671),(-2.99834,1.78708,.101),(-2.87671,1.55412,.07905),(-2.88071,1.48922,.10199),(-2.86485,1.53467,.05455),(-2.92428,1.37271,.13793),(-2.93576,1.36746,.15439),(-2.96056,1.32516,.10168),(-2.9224,1.46939,.16276),(-2.93168,1.55697,.14253),(-2.93397,1.47166,.18124),(-2.91847,1.54981,.1292),(-2.84251,1.65798,-.1276),(-2.84357,1.67774,-.13584),(-2.88446,1.67393,-.03567),(-2.87415,1.65473,-.03441),(-2.79515,1.57477,-.20394),(-2.73691,1.29927,-.36541),(-2.74334,1.27153,-.37875),(-2.6751,1.25529,-.42978),(-2.80669,1.28081,-.14067),(-2.85518,1.30909,-.02788),(-2.8683,1.27871,-.03712),(-3.18006,1.20868,.12404),(-3.15138,1.20767,.13226),(-3.20083,1.19348,.27471),(-3.12036,1.18343,-.0035),(-3.09258,1.19088,.01532),(-3.31919,1.45616,.15445),(-3.31421,1.42454,.14196),(-3.34882,1.34098,.2866),(-3.32462,1.67545,-.15224),(-3.31344,1.6099,-.0793),(-3.32789,1.71317,-.13512),(-2.97819,1.53417,-.4572),(-3.01929,1.51865,-.43157),(-2.91638,1.40831,-.49323),(-2.95733,1.55214,-.46011),(-2.9002,1.42419,-.48001),(-3.00145,1.92801,-.26558),(-2.91878,1.94884,-.19497),(-3.01035,1.93392,-.25372),(-2.80762,1.7903,-.19234),(-2.81365,1.91956,-.12168),(-2.95563,1.37242,-.48374),(-2.72096,1.50133,-.27651),(-2.79178,1.42054,-.2676),(-3.34837,.77935,1.72659),(-3.39614,.71994,1.7724),(-3.61407,.47894,1.34911),(-3.58539,.54213,1.35778),(-3.52396,.59401,1.28897),(-3.46065,.65829,1.19536),(-3.4799,.68244,1.22238),(-3.44264,.74733,1.13402),(-3.30699,.92861,1.3295),(-3.27733,.72608,1.38067),(-3.24424,.77134,1.40057),(-3.5064,.7141,1.25842),(-2.82129,1.50061,-.41611),(-2.72113,1.52005,-.35646),(-2.69568,1.45882,-.38106),(-3.04257,1.89777,-.15196),(-3.06736,1.83649,-.01167),(-3.17635,1.46466,-.20096),(-3.21549,1.3938,-.01757),(-3.21736,1.4941,-.21918),(-3.25772,1.4851,-.09015),(-2.84823,1.21248,-.51653),(-2.88017,1.22381,-.48645),(-2.76589,1.29252,-.3028),(-2.76108,1.35848,-.3402),(-2.88723,1.37297,.11591),(-3.06897,1.77971,.07533),(-3.08288,1.72201,.1457),(-3.02636,1.79257,.09078),(-3.27358,1.49495,-.04358),(-3.26396,1.45967,-.00664),(-3.28981,1.51801,.00847),(-3.12301,1.46981,-.32191),(-2.86033,1.20867,-.47993),(-2.97672,1.18478,-.25043),(-2.99577,1.24734,-.38079),(-2.93476,1.21103,-.3583),(-3.05875,1.21622,-.2945),(-3.18072,1.53193,-.33114),(-3.17321,1.47216,-.22368),(-3.16795,1.75791,-.03992),(-3.13358,1.78812,-.03325),(-3.27635,1.33384,.68373),(-3.336,1.14834,1.00163),(-3.22046,1.34498,.70752),(-3.27465,1.14842,1.01932),(-3.32041,1.44208,.30838),(-3.38006,1.231,.63672),(-3.26125,1.50888,.32099),(-3.33596,1.2992,.65917),(-3.03351,1.30548,.31641),(-3.14316,1.14686,.65222),(-3.0551,1.27624,.30396),(-2.94088,1.42307,-.47643),(-3.14223,1.42501,-.24044),(-3.23079,1.51391,-.2174),(-3.26002,1.69279,-.32559),(-3.28779,1.7533,-.30896),(-3.24393,1.78268,-.39893),(-3.26568,1.74846,-.0895),(-2.91511,1.39322,-.49918),(-2.84167,1.23883,-.52373),(-2.84345,1.33033,-.49756),(-3.12306,1.25271,-.21393),(-3.18934,1.24724,-.06154),(-3.09371,1.195,-.1801),(-3.28106,1.37109,.12231),(-3.26626,1.33342,.11397),(-3.32111,1.25512,.27289),(-2.94711,1.18551,-.23406),(-2.90437,1.2054,-.34477),(-2.82549,1.2166,-.32648),(-2.86306,1.22245,-.18631),(-2.70632,1.21361,-.49094),(-2.64471,1.2816,-.44611),(-2.74649,1.20701,-.46367),(-2.84635,1.41316,-.01343),(-2.83006,1.43614,-.08605),(-2.89565,1.82632,.01671),(-2.81789,1.7841,-.14678),(-2.81171,1.88985,-.08313),(-2.9089,1.655,.05902),(-2.86167,1.51284,.00113),(-2.86167,1.5337,.00649),(-2.85486,1.57495,.02195),(-2.72659,1.64487,-.23956),(-2.68307,1.51398,-.30397),(-2.71731,1.66166,-.2534),(-2.69404,1.34783,-.45216),(-2.75258,1.33129,-.47998),(-3.3443,.55197,1.7875),(-3.36513,.5895,1.81556),(-3.69961,.53833,1.66873),(-3.67199,.5234,1.73123),(-3.62399,.64778,1.74729),(-3.69258,.43141,1.64719),(-3.63478,.44559,1.35254),(-3.71024,.42444,1.47951),(-3.59209,.7166,1.44609),(-3.35429,.93849,1.32537),(-3.23275,1.11421,1.03343),(-3.34086,.78492,1.7001),(-3.34673,.76821,1.66554),(-3.33072,.82879,1.56146),(-3.25311,.73901,1.55564),(-3.3118,.68013,1.66929),(-3.24109,.79962,1.4168),(-3.21683,.97229,.97137),(-3.27978,.7587,1.25283),(-3.42626,.73702,1.13097),(-3.38253,.7234,1.14187),(-3.39495,.65865,1.19944),(-3.43876,.65243,1.18976),(-3.32301,.62792,1.31094),(-3.3434,.51123,1.34011),(-3.37739,.58197,1.25358),(-3.33515,.40832,1.41524),(-3.29016,.69888,1.36108),(-3.36719,.48983,1.62271),(-3.36469,.46155,1.58562),(-3.34568,.57699,1.70474),(-3.33591,.55472,1.75837),(-3.37203,.47669,1.63985),(-3.62726,.42165,1.72393),(-3.59861,.35618,1.61968),(-3.39834,.38554,1.64922),(-3.35748,.66405,1.20779),(-3.33785,.73457,1.1789),(-3.34138,.90943,.89792),(-3.32074,.66338,1.6984),(-3.46158,.75634,1.75726),(-3.46425,.6404,1.82885),(-3.56086,.66483,1.79565),(-3.4985,.7771,1.61676),(-3.45134,.83829,1.53621),(-3.46691,.8366,1.5332),(-3.42166,1.05387,.93737),(-3.47925,.79145,1.16987),(-3.44217,.97495,.89485),(-3.62094,.55339,1.48275),(-3.72033,.4708,1.58013),(-3.51683,.78726,1.73465),(-3.11662,1.76847,-.39335),(-3.04996,1.63664,-.4438),(-3.20395,1.79021,-.41685),(-2.90195,1.8119,-.26388),(-2.81477,1.74292,-.15831),(-2.69744,1.41978,-.34156),(-2.65316,1.4345,-.35486),(-3.01096,1.2491,.06544),(-3.06447,1.23547,.16961),(-3.00706,1.1665,-.10952),(-2.91774,1.22543,-.06606),(-2.83172,1.20217,-.47433),(-2.86813,1.2217,-.40527),(-2.79611,1.2294,-.4028),(-2.92578,1.68892,-.36927),(-3.02127,1.81459,-.35031),(-2.98206,1.83243,-.32712),(-3.28353,1.78233,-.2939),(-3.16877,1.85689,-.35058),(-3.21149,1.82834,-.24147),(-3.08388,1.8245,-.00464),(-3.14904,1.74019,.04513),(-3.08836,1.77183,.06816),(-2.83925,1.91594,-.08024),(-2.93734,1.91336,-.12546),(-3.19171,1.71082,.02295),(-3.19493,1.55217,-.32953),(-3.21563,1.55619,.33463),(-3.02082,1.44303,.35592),(-3.11328,1.227,.69779),(-3.00779,1.38439,.34554),(-3.4001,.92862,1.31212),(-3.4013,1.11398,.97157),(-3.2131,1.08351,.6119),(-3.27719,.92965,.93401),(-3.28184,1.07145,.59468),(-3.15804,1.85079,-.36249),(-2.9376,1.26265,-.41261),(-3.16431,1.69221,.12353),(-2.98753,1.84024,.01677),(-2.89659,1.23063,-.42108),(-2.86931,1.74362,-.29),(-3.5692,.70601,1.61006),(-3.40206,.57738,1.24653),(-3.41831,.79509,1.72549),(-3.58836,.73222,1.47512),(-3.39185,.89306,1.41709),(-3.4331,.77391,1.65836),(-3.52083,.79541,1.70629),(-3.41806,.80202,1.6974),(-3.50385,.77426,1.6438),(-2.9887,1.34332,.23015),(-2.9684,1.42746,.25851),(-2.80124,1.56753,-.11816),(-2.81251,1.54654,-.09406),(-2.84986,1.52849,-.05265),(-2.92401,1.40307,-.49235),(-2.70883,1.23346,-.50418),(-2.72421,1.6669,-.27045),(-2.6889,1.52397,-.33294),(-2.98146,1.29787,.09168),(-3.03049,1.28563,.19373),(-3.01133,1.3127,.20933),(-3.18067,1.76546,-.0559),(-3.07517,1.88974,-.31442),(-3.34351,.77156,1.64116),(-3.56931,.70555,1.64335),(-3.32566,.41282,1.43968),(-3.62316,.64891,1.54781),(-3.62285,.62725,1.56838),(-3.59843,.71729,1.46504),(-3.59756,.71228,1.45607),(-3.43936,.88053,1.40269),(-3.43139,.88541,1.40646),(-3.41469,.77744,1.62558),(-3.42809,.77786,1.62351),(-3.35343,.39833,1.40593),(-3.37794,1.08759,.57369),(-3.49181,.56752,1.23395),(-3.47218,.5595,1.22999),(-3.40158,1.15702,.60588),(-3.3376,.3957,1.43096),(-3.35609,.38621,1.42178),(-3.38559,.35312,1.55699),(-3.41659,.37445,1.65291),(-3.40521,.34129,1.55323),(-3.38119,.59847,1.82444),(-3.69521,.54856,1.65281),(-3.43673,.37137,1.36229),(-3.44397,.35914,1.37629),(-3.3585,.39505,1.54912),(-3.36485,.37417,1.54783),(-3.36851,.44295,1.59504),(-3.13122,1.38999,-.24043),(-2.91845,1.8555,.01148),(-2.86358,1.60428,.03473),(-2.85072,1.6174,-.02401),(-2.83162,1.61975,-.07777),(-2.77688,1.26197,-.30556),(-3.03645,1.16284,-.12468),(-3.06695,1.88392,-.32702),(-2.65529,1.44277,-.37204),(-2.64992,1.2948,-.46206),(-2.89499,1.63858,.05247),(-3.10717,1.64703,.25037),(-2.97322,1.4992,.24549),(-3.23811,1.58451,.20952),(-3.30119,1.52484,.18327),(-3.21438,1.65997,.09806),(-3.19001,1.62424,.22908),(-2.76904,1.65035,-.30371),(-3.11242,1.21453,.27421),(-3.16887,1.31581,.72234),(-3.08792,1.54329,.37352),(-3.13158,1.57206,.35503),(-3.15949,1.18893,-.03224),(-2.87326,1.59472,-.39269),(-3.61861,.51567,1.7789),(-3.51492,.51586,1.80651),(-3.47547,.32414,1.54014),(-3.49274,.35358,1.6407),(-3.51463,.4166,1.74805),(-3.58011,.33352,1.51979),(-3.61809,.68097,1.70904)]))),
        Shape(DEF='rmet4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmet4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,15,18,16,-1,19,16,20,-1,19,17,16,-1,21,22,23,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,36,37,34,-1,30,38,39,-1,38,40,39,-1,41,42,43,-1,44,42,41,-1,44,45,42,-1,46,47,48,-1,48,49,46,-1,50,51,52,-1,50,53,51,-1,54,27,55,-1,27,56,55,-1,57,58,59,-1,60,61,62,-1,60,63,61,-1,64,31,65,-1,65,66,64,-1,67,68,69,-1,67,70,68,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,82,83,80,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,86,93,94,-1,94,84,86,-1,95,96,97,-1,95,98,99,-1,95,100,98,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,113,116,114,-1,96,117,118,-1,118,119,96,-1,120,121,122,-1,123,124,125,-1,110,126,111,-1,126,127,111,-1,128,118,87,-1,128,129,118,-1,130,131,132,-1,132,133,134,-1,135,136,137,-1,138,139,78,-1,138,140,139,-1,141,142,143,-1,144,125,141,-1,145,146,103,-1,147,148,149,-1,149,150,147,-1,151,73,152,-1,73,72,152,-1,101,153,102,-1,153,154,102,-1,103,155,156,-1,103,102,155,-1,107,115,108,-1,157,158,159,-1,99,160,93,-1,161,43,42,-1,162,41,43,-1,11,163,9,-1,11,164,163,-1,165,163,166,-1,165,167,163,-1,168,169,170,-1,168,171,169,-1,172,26,173,-1,174,175,176,-1,175,177,176,-1,178,179,180,-1,181,59,58,-1,182,24,26,-1,183,184,185,-1,185,186,183,-1,187,188,132,-1,132,131,187,-1,189,121,120,-1,189,190,121,-1,191,192,193,-1,192,194,193,-1,195,191,193,-1,196,197,198,-1,197,158,198,-1,199,200,198,-1,200,201,198,-1,202,203,157,-1,204,205,206,-1,139,140,136,-1,207,208,209,-1,209,210,207,-1,211,212,213,-1,213,214,211,-1,215,126,113,-1,126,110,113,-1,114,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,86,-1,226,227,228,-1,226,117,227,-1,229,225,230,-1,225,224,230,-1,94,93,160,-1,231,232,97,-1,222,233,234,-1,235,236,237,-1,238,209,239,-1,238,210,209,-1,85,84,92,-1,92,240,85,-1,241,242,239,-1,224,86,85,-1,243,244,245,-1,101,246,153,-1,246,247,153,-1,248,249,250,-1,149,251,72,-1,105,252,253,-1,252,254,253,-1,255,256,257,-1,60,62,48,-1,62,258,48,-1,59,259,57,-1,260,170,261,-1,62,262,263,-1,263,258,62,-1,263,264,265,-1,265,266,263,-1,267,268,168,-1,23,269,21,-1,23,270,269,-1,271,268,182,-1,22,25,272,-1,25,273,272,-1,272,34,37,-1,37,274,272,-1,275,276,51,-1,51,53,275,-1,29,277,278,-1,29,66,277,-1,279,165,280,-1,280,281,279,-1,282,1,283,-1,282,284,1,-1,164,36,35,-1,164,285,36,-1,286,287,10,-1,287,11,10,-1,288,289,290,-1,288,291,289,-1,292,293,294,-1,293,295,294,-1,296,294,13,-1,294,14,13,-1,297,3,298,-1,299,5,300,-1,301,4,302,-1,303,304,82,-1,303,305,304,-1,8,16,6,-1,8,20,16,-1,306,307,63,-1,307,61,63,-1,308,178,68,-1,308,179,178,-1,309,70,310,-1,311,312,313,-1,313,314,311,-1,32,315,33,-1,316,186,185,-1,317,183,318,-1,183,186,318,-1,319,184,183,-1,183,320,319,-1,31,33,65,-1,321,322,310,-1,310,70,321,-1,308,68,309,-1,68,70,309,-1,323,324,306,-1,324,307,306,-1,60,47,325,-1,60,48,47,-1,326,20,327,-1,326,328,20,-1,49,329,46,-1,329,327,46,-1,326,330,328,-1,330,331,328,-1,332,19,302,-1,19,333,302,-1,332,3,297,-1,6,16,18,-1,18,0,6,-1,300,5,334,-1,335,5,299,-1,336,12,14,-1,14,289,336,-1,291,287,289,-1,291,11,287,-1,334,286,300,-1,337,278,67,-1,278,277,67,-1,166,338,280,-1,280,165,166,-1,339,39,40,-1,275,55,340,-1,275,53,55,-1,27,54,273,-1,273,25,27,-1,182,172,271,-1,182,26,172,-1,266,265,341,-1,341,43,266,-1,263,262,264,-1,168,170,260,-1,260,267,168,-1,270,342,343,-1,342,201,343,-1,307,324,344,-1,316,259,186,-1,259,59,186,-1,343,201,345,-1,201,200,345,-1,346,347,348,-1,346,249,347,-1,255,105,256,-1,105,253,256,-1,155,254,252,-1,72,251,152,-1,148,251,149,-1,349,249,248,-1,245,350,351,-1,243,352,244,-1,241,143,142,-1,241,353,143,-1,242,241,142,-1,91,240,92,-1,91,238,242,-1,238,354,355,-1,238,356,354,-1,357,354,356,-1,91,356,238,-1,358,359,74,-1,360,76,361,-1,76,75,361,-1,237,98,362,-1,237,236,98,-1,234,363,364,-1,222,234,364,-1,96,231,97,-1,100,362,98,-1,227,95,99,-1,103,156,145,-1,96,227,117,-1,221,365,366,-1,365,367,366,-1,129,368,118,-1,368,119,118,-1,369,370,371,-1,107,215,115,-1,215,113,115,-1,114,194,192,-1,192,216,114,-1,112,190,189,-1,189,116,112,-1,372,373,211,-1,372,374,373,-1,209,372,375,-1,209,208,372,-1,376,377,207,-1,207,210,376,-1,79,78,207,-1,78,208,207,-1,78,374,208,-1,374,372,208,-1,140,137,136,-1,378,379,77,-1,342,196,201,-1,196,198,201,-1,197,192,191,-1,197,218,192,-1,121,205,122,-1,121,380,205,-1,367,274,37,-1,367,365,274,-1,43,341,162,-1,340,55,381,-1,306,63,382,-1,337,69,383,-1,337,67,69,-1,176,172,173,-1,176,177,172,-1,384,299,385,-1,384,335,299,-1,163,164,166,-1,9,386,10,-1,301,302,387,-1,378,388,379,-1,242,238,239,-1,95,227,96,-1,389,388,203,-1,389,379,388,-1,159,204,157,-1,390,148,147,-1,390,391,148,-1,153,151,154,-1,151,152,154,-1,390,392,393,-1,150,125,144,-1,394,130,132,-1,132,134,394,-1,78,389,138,-1,395,139,136,-1,396,248,212,-1,211,373,212,-1,118,117,87,-1,131,130,380,-1,370,96,119,-1,370,231,96,-1,368,397,398,-1,398,371,368,-1,399,126,215,-1,399,400,126,-1,398,369,371,-1,401,252,402,-1,243,240,352,-1,243,85,240,-1,245,224,85,-1,85,243,245,-1,358,354,357,-1,225,226,228,-1,225,229,226,-1,156,155,89,-1,95,97,100,-1,235,237,234,-1,237,363,234,-1,378,403,404,-1,82,304,83,-1,304,405,83,-1,74,76,358,-1,226,88,117,-1,88,87,117,-1,352,406,244,-1,329,81,80,-1,54,53,50,-1,54,55,53,-1,258,261,48,-1,261,49,48,-1,47,8,407,-1,47,46,8,-1,408,337,2,-1,408,278,337,-1,29,38,30,-1,38,51,40,-1,38,281,51,-1,339,40,51,-1,51,276,339,-1,315,409,33,-1,21,173,26,-1,2,284,167,-1,2,1,284,-1,0,2,6,-1,2,7,6,-1,410,13,12,-1,410,331,13,-1,386,411,10,-1,2,167,408,-1,412,50,52,-1,287,336,289,-1,4,334,5,-1,4,301,334,-1,335,15,298,-1,384,15,335,-1,0,283,1,-1,0,18,283,-1,410,328,331,-1,333,328,410,-1,385,386,282,-1,411,386,385,-1,284,163,167,-1,284,9,163,-1,413,414,415,-1,413,44,414,-1,416,417,56,-1,45,417,416,-1,281,52,51,-1,280,52,281,-1,409,418,419,-1,418,409,315,-1,420,28,421,-1,28,420,64,-1,419,422,423,-1,422,419,418,-1,424,276,275,-1,423,276,424,-1,340,425,426,-1,340,381,425,-1,408,29,278,-1,279,29,408,-1,407,7,383,-1,407,8,7,-1,268,161,182,-1,161,268,43,-1,279,38,29,-1,279,281,38,-1,268,266,43,-1,268,267,266,-1,341,57,162,-1,341,58,57,-1,264,427,428,-1,264,262,427,-1,69,178,429,-1,69,68,178,-1,430,185,184,-1,431,185,430,-1,432,409,419,-1,432,319,409,-1,63,325,180,-1,60,325,63,-1,70,277,321,-1,67,277,70,-1,433,403,293,-1,403,433,404,-1,292,304,434,-1,304,292,405,-1,435,37,36,-1,367,37,435,-1,361,367,435,-1,361,366,367,-1,233,235,234,-1,75,235,233,-1,362,363,237,-1,363,362,232,-1,93,225,228,-1,225,93,86,-1,226,145,88,-1,226,229,145,-1,246,230,351,-1,246,146,230,-1,406,240,436,-1,406,352,240,-1,437,123,438,-1,124,123,437,-1,224,351,230,-1,351,224,245,-1,107,399,215,-1,109,399,107,-1,439,126,400,-1,439,127,126,-1,440,401,402,-1,128,401,440,-1,397,129,441,-1,368,129,397,-1,369,217,364,-1,108,217,369,-1,247,442,443,-1,350,442,247,-1,146,229,230,-1,229,146,145,-1,121,444,187,-1,121,190,444,-1,395,373,374,-1,373,395,445,-1,135,130,394,-1,135,206,130,-1,135,202,206,-1,137,202,135,-1,105,446,106,-1,446,105,255,-1,257,188,447,-1,188,257,448,-1,396,349,248,-1,396,449,349,-1,132,448,133,-1,188,448,132,-1,325,407,429,-1,47,407,325,-1,157,388,158,-1,157,203,388,-1,108,398,109,-1,398,108,369,-1,138,203,202,-1,389,203,138,-1,421,418,420,-1,422,418,421,-1,424,430,432,-1,426,430,424,-1,413,431,425,-1,413,415,431,-1,10,300,286,-1,411,300,10,-1,450,291,288,-1,450,285,291,-1,385,300,411,-1,385,299,300,-1,17,298,15,-1,17,297,298,-1,451,303,174,-1,303,451,305,-1,294,405,292,-1,294,296,405,-1,303,81,452,-1,82,81,303,-1,429,383,69,-1,383,429,407,-1,445,136,453,-1,136,445,395,-1,158,191,159,-1,158,197,191,-1,218,196,219,-1,197,196,218,-1,122,204,195,-1,122,205,204,-1,120,195,193,-1,122,195,120,-1,453,135,394,-1,453,136,135,-1,433,199,404,-1,433,200,199,-1,77,389,78,-1,77,379,389,-1,396,453,449,-1,453,396,445,-1,403,207,377,-1,403,79,207,-1,376,295,377,-1,376,454,295,-1,372,214,375,-1,211,214,372,-1,353,239,455,-1,353,241,239,-1,393,375,214,-1,375,393,455,-1,106,111,127,-1,106,446,111,-1,116,194,114,-1,116,189,194,-1,220,217,216,-1,223,217,220,-1,109,397,399,-1,109,398,397,-1,439,402,104,-1,402,439,440,-1,119,371,370,-1,371,119,368,-1,128,89,401,-1,128,87,89,-1,232,364,363,-1,364,232,231,-1,98,74,359,-1,74,98,236,-1,221,233,222,-1,366,233,221,-1,360,358,76,-1,360,354,358,-1,94,357,90,-1,94,160,357,-1,356,90,357,-1,91,90,356,-1,361,450,360,-1,361,435,450,-1,290,354,288,-1,290,355,354,-1,355,454,376,-1,290,454,355,-1,242,240,91,-1,242,142,240,-1,456,353,392,-1,353,456,143,-1,143,144,141,-1,143,456,144,-1,142,436,240,-1,142,141,436,-1,244,350,245,-1,442,350,244,-1,71,125,150,-1,123,125,71,-1,349,347,249,-1,349,133,347,-1,148,346,251,-1,148,391,346,-1,457,152,251,-1,154,152,457,-1,458,155,102,-1,458,254,155,-1,253,458,459,-1,253,254,458,-1,347,448,460,-1,133,448,347,-1,251,348,457,-1,251,346,348,-1,460,348,347,-1,460,459,348,-1,428,344,461,-1,344,428,427,-1,461,462,428,-1,462,461,463,-1,186,181,318,-1,186,59,181,-1,464,461,465,-1,464,463,461,-1,461,324,465,-1,461,344,324,-1,451,270,343,-1,269,270,451,-1,169,177,175,-1,171,177,169,-1,21,176,173,-1,21,269,176,-1,56,381,55,-1,56,417,381,-1,365,23,274,-1,365,466,23,-1,284,386,9,-1,386,284,282,-1,14,290,289,-1,290,14,454,-1,332,17,19,-1,17,332,297,-1,4,332,302,-1,4,3,332,-1,333,387,302,-1,410,387,333,-1,80,330,326,-1,80,83,330,-1,329,326,327,-1,329,80,326,-1,20,46,327,-1,46,20,8,-1,382,323,306,-1,467,323,382,-1,311,310,312,-1,309,310,311,-1,322,312,310,-1,468,312,322,-1,322,65,33,-1,322,321,65,-1,317,320,183,-1,317,468,320,-1,464,317,318,-1,313,317,464,-1,323,465,324,-1,465,323,314,-1,311,323,467,-1,323,311,314,-1,465,313,464,-1,314,313,465,-1,409,320,33,-1,409,319,320,-1,468,33,320,-1,33,468,322,-1,468,313,312,-1,468,317,313,-1,467,309,311,-1,467,308,309,-1,308,382,179,-1,382,308,467,-1,469,49,261,-1,469,329,49,-1,330,13,331,-1,296,13,330,-1,410,336,387,-1,12,336,410,-1,345,304,305,-1,304,345,434,-1,294,454,14,-1,454,294,295,-1,35,166,164,-1,35,338,166,-1,435,285,450,-1,285,435,36,-1,34,273,412,-1,272,273,34,-1,22,274,23,-1,22,272,274,-1,416,42,45,-1,42,416,161,-1,466,270,23,-1,466,342,270,-1,171,172,177,-1,171,271,172,-1,175,469,169,-1,175,452,469,-1,269,174,176,-1,269,451,174,-1,463,318,181,-1,464,318,463,-1,462,181,58,-1,462,463,181,-1,427,307,344,-1,427,61,307,-1,200,434,345,-1,434,200,433,-1,459,457,348,-1,459,458,457,-1,257,460,448,-1,257,256,460,-1,256,459,460,-1,459,256,253,-1,154,458,102,-1,458,154,457,-1,249,391,250,-1,391,249,346,-1,73,443,438,-1,443,73,151,-1,437,244,406,-1,244,437,442,-1,153,443,151,-1,443,153,247,-1,124,141,125,-1,141,124,436,-1,150,456,147,-1,150,144,456,-1,147,392,390,-1,392,147,456,-1,238,376,210,-1,355,376,238,-1,360,288,354,-1,360,450,288,-1,75,236,235,-1,74,236,75,-1,399,441,400,-1,399,397,441,-1,364,223,222,-1,223,364,217,-1,466,221,219,-1,466,365,221,-1,223,219,221,-1,220,219,223,-1,218,216,192,-1,218,220,216,-1,390,214,213,-1,393,214,390,-1,209,455,239,-1,209,375,455,-1,455,392,353,-1,455,393,392,-1,377,293,403,-1,377,295,293,-1,134,453,394,-1,449,453,134,-1,206,380,130,-1,206,205,380,-1,202,204,206,-1,202,157,204,-1,199,158,388,-1,199,198,158,-1,195,159,191,-1,195,204,159,-1,193,189,120,-1,194,189,193,-1,380,187,131,-1,380,121,187,-1,444,446,447,-1,444,111,446,-1,187,447,188,-1,187,444,447,-1,342,219,196,-1,342,466,219,-1,54,412,273,-1,412,54,50,-1,469,81,329,-1,469,452,81,-1,174,452,175,-1,303,452,174,-1,168,271,171,-1,268,271,168,-1,261,169,469,-1,170,169,261,-1,83,296,330,-1,405,296,83,-1,343,305,451,-1,305,343,345,-1,167,279,408,-1,279,167,165,-1,285,11,291,-1,285,164,11,-1,44,162,414,-1,41,162,44,-1,426,431,430,-1,425,431,426,-1,419,424,432,-1,424,419,423,-1,29,64,66,-1,28,64,29,-1,378,199,388,-1,378,404,199,-1,180,382,63,-1,180,179,382,-1,250,212,248,-1,212,250,213,-1,401,155,252,-1,89,155,401,-1,349,134,133,-1,449,134,349,-1,255,447,446,-1,447,255,257,-1,104,252,105,-1,104,402,252,-1,150,72,71,-1,150,149,72,-1,390,250,391,-1,390,213,250,-1,137,138,202,-1,140,138,137,-1,396,373,445,-1,373,396,212,-1,139,374,78,-1,139,395,374,-1,190,111,444,-1,190,112,111,-1,440,400,441,-1,440,439,400,-1,351,247,246,-1,247,351,350,-1,438,442,437,-1,438,443,442,-1,364,370,369,-1,364,231,370,-1,108,114,217,-1,115,114,108,-1,116,110,112,-1,113,110,116,-1,128,441,129,-1,128,440,441,-1,104,127,439,-1,104,106,127,-1,71,438,123,-1,73,438,71,-1,406,124,437,-1,406,436,124,-1,101,146,246,-1,101,103,146,-1,160,358,357,-1,160,359,358,-1,359,99,98,-1,359,160,99,-1,156,88,145,-1,88,156,89,-1,90,84,94,-1,92,84,90,-1,93,227,99,-1,93,228,227,-1,100,232,362,-1,97,232,100,-1,75,366,361,-1,75,233,366,-1,434,293,292,-1,293,434,433,-1,378,79,403,-1,79,378,77,-1,57,414,162,-1,414,57,259,-1,58,265,462,-1,341,265,58,-1,277,65,321,-1,66,65,277,-1,315,420,418,-1,315,32,420,-1,432,184,319,-1,430,184,432,-1,316,431,415,-1,316,185,431,-1,180,429,178,-1,429,180,325,-1,61,262,62,-1,427,262,61,-1,265,428,462,-1,265,264,428,-1,260,258,263,-1,258,260,261,-1,416,182,161,-1,416,24,182,-1,383,2,337,-1,383,7,2,-1,267,263,266,-1,260,263,267,-1,417,425,381,-1,425,417,413,-1,275,426,424,-1,275,340,426,-1,30,421,28,-1,421,30,39,-1,52,338,412,-1,52,280,338,-1,423,339,276,-1,423,422,339,-1,420,31,64,-1,420,32,31,-1,34,338,35,-1,412,338,34,-1,421,339,422,-1,39,339,421,-1,26,22,21,-1,25,22,26,-1,416,27,24,-1,416,56,27,-1,44,417,45,-1,44,413,417,-1,415,259,316,-1,259,415,414,-1,283,385,282,-1,385,283,384,-1,333,20,328,-1,19,20,333,-1,301,286,334,-1,286,301,387,-1,384,18,15,-1,283,18,384,-1,298,5,335,-1,3,5,298,-1,287,387,336,-1,286,387,287,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmet4_Coord',point=[(-4.01941,.49798,1.04426),(-4.01407,.49552,1.03658),(-4.02259,.47319,1.05369),(-4.02729,.61824,.98247),(-4.02171,.6307,.97534),(-4.01971,.61383,.96384),(-4.05661,.56133,1.11132),(-4.06853,.55228,1.12865),(-4.00524,.64796,1.20291),(-3.89033,.59577,.8709),(-3.91182,.63626,.88123),(-3.87233,.72279,.78487),(-3.86353,.84089,.85076),(-3.84747,.86311,.86362),(-3.80261,1.02496,.57907),(-4.03285,.5359,1.03163),(-4.05014,.5601,1.09839),(-4.04376,.57419,1.07616),(-4.02398,.5047,1.03894),(-3.98804,.6738,1.1124),(-3.97971,.67727,1.13842),(-3.6973,.68526,.81885),(-3.70226,.6752,.80556),(-3.636,.84294,.54698),(-3.69289,.51484,.93702),(-3.69781,.5693,.8778),(-3.69059,.57519,.89307),(-3.70568,.51029,.92327),(-3.89979,.40658,.84668),(-3.92138,.42715,.91389),(-3.87997,.41936,.84409),(-3.92586,.36489,.85582),(-3.91406,.36086,.85074),(-3.94984,.33004,.92344),(-3.77745,.62482,.73704),(-3.79814,.63055,.73752),(-3.74743,.79299,.48639),(-3.72675,.78367,.48393),(-3.86853,.4313,.84146),(-3.86817,.41571,.83866),(-3.86044,.42514,.84157),(-3.66704,.44875,1.00552),(-3.66768,.46852,.98403),(-3.69523,.46997,1.0721),(-3.67745,.41487,.95561),(-3.68137,.44415,.94807),(-3.96119,.68315,1.24044),(-3.97053,.67409,1.26045),(-3.89876,.67823,1.28599),(-3.88823,.69167,1.26671),(-3.79945,.48023,.84915),(-3.84861,.43051,.84339),(-3.831,.46225,.83741),(-3.80241,.45559,.8692),(-3.75709,.50263,.87572),(-3.75866,.47536,.89041),(-3.70707,.48372,.93155),(-3.66993,.40015,1.03104),(-3.70161,.38369,1.15322),(-3.70983,.33522,1.08316),(-3.92482,.67753,1.30002),(-3.83094,.61621,1.35381),(-3.81532,.62421,1.33765),(-3.93835,.66505,1.31364),(-3.91744,.39081,.84686),(-3.95892,.37087,.89733),(-3.95268,.39257,.89851),(-4.09093,.44047,1.09718),(-4.11806,.52869,1.17964),(-4.10507,.53746,1.16121),(-4.10557,.42302,1.10681),(-3.49516,1.42893,-.91602),(-3.47131,1.43831,-.9333),(-3.48581,1.40989,-.92073),(-3.496,1.0424,-.39242),(-3.48588,1.00305,-.30298),(-3.52325,1.04446,-.31328),(-3.41546,1.54806,-.12121),(-3.3821,1.6517,-.23991),(-3.44763,1.5662,-.13118),(-3.82444,.81823,1.13605),(-3.7866,.80936,1.14119),(-3.76911,.84053,1.0388),(-3.79612,.84303,1.03313),(-3.48324,1.24828,-.53268),(-3.47483,1.26162,-.57281),(-3.42294,1.20091,-.57101),(-3.19278,1.09087,-.77997),(-3.23985,1.12827,-.77725),(-3.17506,1.09963,-.87011),(-3.53715,1.28096,-.43963),(-3.55375,1.33206,-.38741),(-3.53802,1.2967,-.4603),(-3.40076,1.17412,-.55989),(-3.47994,1.2174,-.4983),(-3.32605,1.04447,-.6351),(-3.2482,1.05688,-.68989),(-3.32106,1.02733,-.61518),(-3.41054,1.07994,-.56067),(-3.40894,1.10621,-.57024),(-3.34246,1.03352,-.60697),(-3.26425,1.13848,-.88707),(-3.24408,1.14607,-.89553),(-3.25371,1.12889,-.87727),(-3.00823,1.15089,-.79863),(-3.00302,1.19126,-.81565),(-2.98963,1.17421,-.78541),(-3.11614,1.03736,-.55677),(-3.21525,1.01706,-.45195),(-3.13079,1.01587,-.57369),(-3.04622,1.19149,-.62855),(-3.02173,1.22034,-.65278),(-3.03902,1.22027,-.61493),(-3.07317,1.16336,-.58863),(-3.10545,1.11425,-.48411),(-3.10142,1.09675,-.5107),(-3.06686,1.18939,-.57015),(-3.22932,1.08407,-.73738),(-3.20792,1.07441,-.74686),(-3.21874,1.05093,-.69678),(-3.06881,1.34526,-.48832),(-3.08582,1.39469,-.54141),(-3.08717,1.3895,-.4811),(-3.5291,1.43158,-.84462),(-3.5457,1.42343,-.80252),(-3.55007,1.4869,-.80418),(-3.074,1.12324,-.65307),(-3.07254,1.13911,-.69227),(-3.14149,1.08209,-.74283),(-3.15584,1.0569,-.70751),(-3.10907,1.53692,-.53346),(-3.12516,1.49248,-.57257),(-3.11927,1.55354,-.64459),(-3.13164,1.55904,-.66213),(-3.13935,1.57464,-.64468),(-3.15822,1.54276,-.40637),(-3.24795,1.64294,-.42149),(-3.26086,1.53165,-.23092),(-3.33346,1.5691,-.17427),(-3.36313,1.65756,-.24374),(-3.32059,1.57924,-.20055),(-3.59323,1.48027,-.71482),(-3.59516,1.45283,-.5696),(-3.57637,1.53056,-.67607),(-3.55955,1.51773,-.79439),(-3.27164,1.13691,-.81655),(-3.29714,1.14897,-.82564),(-3.47906,1.6038,-.84962),(-3.46007,1.58855,-.85794),(-3.47993,1.54291,-.89112),(-3.51497,1.5431,-.86544),(-3.44561,1.38194,-.90908),(-3.43676,1.39751,-.92837),(-3.3508,1.25123,-.90536),(-3.334,1.27224,-.90998),(-3.17348,1.12077,-.88672),(-3.20343,1.10768,-.8765),(-3.25237,1.43662,-.24272),(-3.28644,1.31627,-.10688),(-3.21275,1.37519,-.23833),(-3.46923,1.16549,-.47602),(-3.67289,.48417,.97862),(-3.66732,.42326,1.02957),(-3.87197,.58894,.85696),(-3.83731,.66298,.75653),(-3.88059,.48588,.88093),(-3.85022,.56644,.83727),(-3.90704,.5007,.91906),(-3.74473,.53389,1.13912),(-3.71359,.64463,1.15946),(-3.74993,.58322,1.20151),(-3.7296,.58529,1.08836),(-3.69224,.61192,.95745),(-3.69353,.63075,.9172),(-3.7187,.7534,1.00374),(-3.70802,.71061,1.08537),(-3.70669,.69738,.96274),(-3.71291,.65837,1.01855),(-4.05308,.63141,1.2572),(-4.05688,.6138,1.27093),(-3.9947,.66341,1.28872),(-3.74306,.32782,1.15578),(-3.6775,.51778,.96545),(-3.81589,.28251,.9825),(-3.77326,.31941,.94093),(-3.71639,.33974,.93132),(-3.73397,.30055,1.03899),(-3.0757,1.41031,-.57443),(-3.02679,1.46457,-.63807),(-3.0497,1.2574,-.52875),(-3.04225,1.28788,-.58015),(-3.1616,1.2479,-.24911),(-3.14844,1.17023,-.30731),(-3.10944,1.27524,-.4238),(-3.0727,1.19213,-.46789),(-3.12327,1.35904,-.41913),(-3.36659,1.14612,.02677),(-3.24586,1.19636,-.12866),(-3.37674,1.24205,.0461),(-3.43157,1.36011,.06799),(-3.50606,1.23588,.27843),(-3.48184,1.16325,.25206),(-3.25814,1.50988,-.21687),(-3.32059,1.47649,-.17485),(-3.16625,1.45165,-.40681),(-3.15145,1.46844,-.44226),(-3.14637,1.5178,-.40776),(-3.49836,1.56476,-.14806),(-3.44071,1.63145,-.29328),(-3.48036,1.5859,-.38843),(-3.52576,1.48812,-.21496),(-3.34706,1.72997,-.58462),(-3.31609,1.74184,-.66789),(-3.38301,1.7298,-.6944),(-3.40689,1.70576,-.64309),(-3.08297,1.07612,-.62564),(-3.18324,1.08448,-.37967),(-3.23942,1.02764,-.39939),(-3.27173,1.12373,-.16231),(-3.40329,1.06128,.00252),(-3.30446,1.07751,-.17958),(-3.49232,.96238,-.05013),(-3.40918,.98224,-.25855),(-3.35734,1.00626,-.20125),(-3.37546,1.18172,-.67431),(-3.34329,1.18485,-.63331),(-3.26867,1.13864,-.73267),(-3.31196,1.1149,-.64488),(-3.32728,1.17146,-.61312),(-3.2945,1.14841,-.76327),(-3.31521,1.15665,-.78497),(-3.28481,1.01992,-.58536),(-3.33692,.99804,-.56775),(-3.46609,.98569,-.29704),(-3.39623,.97171,-.44411),(-3.41705,.98591,-.45283),(-3.4352,1.01486,-.47937),(-3.37542,.99552,-.54224),(-3.54767,1.40078,-.25612),(-3.49923,1.54868,-.4385),(-3.57288,1.37884,-.57595),(-3.57031,1.51627,-.51454),(-3.58067,1.43925,-.41509),(-3.47324,1.26977,-.59047),(-3.46606,1.31919,-.70008),(-3.3787,1.18895,-.69336),(-3.30726,1.15746,-.83651),(-3.35418,1.24446,-.83362),(-3.30235,1.73449,-.67745),(-3.28493,1.62876,-.70762),(-3.37243,1.72369,-.7045),(-3.40246,1.49933,-.86902),(-3.08707,1.12819,-.85705),(-3.05768,1.23492,-.79334),(-3.13883,1.16405,-.84938),(-2.96774,1.25553,-.74334),(-2.99936,1.29286,-.73652),(-2.9654,1.33936,-.69995),(-3.80891,.63423,1.29696),(-3.67743,.35552,.97409),(-3.78416,.53571,1.23218),(-3.79671,.63784,1.26842),(-3.79814,.53522,1.33622),(-3.79263,.51831,1.2536),(-3.7834,.44923,1.297),(-3.76845,.39823,1.2461),(-3.75986,.46724,1.19674),(-3.75992,.4987,1.18496),(-3.70913,.49733,1.08584),(-3.69996,.74359,.89662),(-3.61472,.9162,.60341),(-3.70191,.544,1.03067),(-3.74674,.63392,.75167),(-3.74095,.55349,.82605),(-3.67887,.79253,.4877),(-3.82754,.41053,.87461),(-3.84623,.40979,.84698),(-4.0261,.39809,.9765),(-3.96124,.43162,.97222),(-3.90957,.45596,.91945),(-3.84769,.47013,.83586),(-3.86143,.44452,.84086),(-3.9419,.5332,.93087),(-4.01941,.50262,1.03226),(-3.92605,.52084,.92445),(-3.77102,.83872,.50009),(-3.96867,.69942,.90235),(-3.90937,.7806,.80876),(-3.68111,1.08224,.17079),(-3.81676,.94519,.54995),(-3.68262,1.15948,.17668),(-3.7982,.89332,.52449),(-3.70851,1.0818,.62631),(-3.5747,1.27501,.27549),(-3.7549,1.06447,.60787),(-3.62462,1.27255,.25045),(-3.81844,.89723,.88349),(-4.03702,.59692,1.03532),(-4.03208,.57192,1.00747),(-3.98887,.56795,.94548),(-3.98063,.61025,.92342),(-4.00093,.68005,.94455),(-3.9977,.679,.99642),(-3.755,.82586,1.03836),(-3.74625,.88703,.92684),(-3.7418,.87514,.93344),(-3.95657,.57232,1.35325),(-3.86833,.59012,1.36454),(-4.12849,.50043,1.22888),(-4.13451,.39655,1.17148),(-4.10601,.36233,1.12005),(-4.0972,.36593,1.2304),(-4.05987,.31537,1.16347),(-3.95245,.27263,1.19659),(-3.997,.35559,1.28326),(-3.89101,.35067,.85386),(-3.68581,.34797,.96003),(-3.90941,.2558,1.11075),(-3.82156,.2647,1.13343),(-3.86771,.31938,.90392),(-3.89867,.30464,.94745),(-4.03396,.37661,.97688),(-4.0304,.3249,1.01465),(-4.01015,.45089,1.33143),(-3.93852,.46475,1.35554),(-3.97928,.67707,1.27584),(-3.87649,.80684,1.11996),(-3.91676,.74771,1.18771),(-3.92,.74247,1.08333),(-3.85319,.75531,1.22718),(-3.83616,.8334,1.02137),(-3.89102,.7846,.99146),(-4.01302,.63904,1.03324),(-3.93914,.72749,1.06431),(-3.99904,.66693,.93119),(-4.02288,.56047,.99345),(-3.90736,.7987,.81888),(-4.04,.45781,1.06715),(-3.81267,.53709,.80064),(-3.85988,.40938,.8396),(-3.76963,.42219,.90265),(-3.70095,.40664,1.1594),(-3.48542,1.08605,.22053),(-3.62834,.99102,.63488),(-3.84806,.49782,1.36226),(-3.65565,1.04193,.64067),(-3.35835,1.58536,-.78481),(-3.16398,1.50631,-.71545),(-3.2247,1.42229,-.77663),(-3.21986,1.65779,-.6561),(-3.36021,1.23226,-.79203),(-3.32565,1.16549,-.79426),(-3.55987,1.36064,-.59368),(-3.53444,1.57781,-.63094),(-3.60583,1.17866,-.0403),(-3.61836,1.26203,-.0169),(-3.56538,1.29214,-.29045),(-3.55425,1.19136,-.32436),(-3.55184,1.17606,-.31819),(-3.47208,1.1486,-.46355),(-3.58974,1.06159,-.05653),(-3.54371,.98237,-.06011),(-3.36161,1.00306,-.56189),(-3.35099,.98761,-.54012),(-3.28528,.99511,-.45448),(-3.55788,.93692,.14655),(-3.52246,.96743,-.05735),(-3.5943,.92624,.13014),(-3.14511,1.02632,-.66368),(-3.23483,.9999,-.47704),(-3.25628,1.01744,-.5841),(-3.17713,.99649,-.5913),(-3.37232,1.69645,-.47543),(-3.30361,1.74567,-.54273),(-3.33551,1.73078,-.43335),(-3.43522,1.66073,-.55062),(-3.59963,1.3517,.01516),(-3.55064,1.39393,.05918),(-3.45243,1.44107,.00754),(-3.38881,1.51076,-.11374),(-3.13116,1.47557,-.53414),(-3.74222,.43113,.90028),(-4.02379,.57964,1.30964),(-4.08158,.54026,1.14026),(-4.02227,.52636,1.01717),(-3.9638,.55468,.93412),(-3.91899,.59824,.89147),(-3.9708,.7113,.91522),(-3.35254,1.45255,-.10493),(-3.36416,1.53551,-.15701),(-3.42456,1.66186,-.78045),(-3.4093,1.64968,-.79147),(-3.48879,1.61709,-.71361),(-3.44057,1.65548,-.68996),(-3.11913,1.56175,-.53115),(-3.30598,1.71923,-.42717),(-3.29259,1.73368,-.66),(-3.11795,1.03489,-.65701),(-3.14996,1.00104,-.58564),(-3.09673,1.05668,-.64837),(-3.0932,1.10022,-.67274),(-3.09916,1.09305,-.82992),(-3.07362,1.10126,-.81912),(-3.50343,1.40495,.06164),(-3.4689,1.39274,.06812),(-3.78044,.89617,.92211),(-3.57111,1.40364,-.73696),(-4.02198,.63936,1.22375),(-3.94739,.45998,.97501),(-3.88029,.34286,.86219),(-3.91187,.76595,.97806),(-3.94641,.60361,.90579),(-3.78959,.53428,.79741),(-3.6871,.41199,.94113),(-3.67612,.3716,.95705),(-3.68458,.36452,.94393),(-3.69354,.4871,.94521),(-3.69333,.44053,.93431),(-3.87062,.36367,.84778),(-3.85748,.35981,.85628),(-3.90202,.37873,.83934),(-3.88441,.39663,.83729),(-3.86556,.38405,.84235),(-3.85023,.38217,.8516),(-3.83447,.38263,.88231),(-3.7331,.40411,.90637),(-3.7694,.3928,.90985),(-3.8125,.52792,1.35262),(-3.79645,.43536,1.31101),(-4.04133,.63994,1.24137),(-3.77224,.33684,.9259),(-3.71842,.35575,.91737),(-3.84944,.33606,.8953),(-3.54041,1.2632,.28266),(-3.67618,1.0754,.63147),(-3.62213,.94664,.12883),(-3.5821,1.42065,-.73326),(-3.53407,1.40721,-.80683),(-3.51579,1.41333,-.85373),(-3.09097,1.11724,-.70602),(-3.11886,1.09251,-.72632),(-3.12618,1.06985,-.69696),(-3.45156,1.35451,-.80905),(-3.44653,1.3654,-.85156),(-3.02404,1.29285,-.61863),(-3.27986,1.73669,-.5418),(-2.96386,1.24926,-.73373),(-2.96171,1.33552,-.6888),(-3.02667,1.46196,-.65201),(-3.21648,1.66295,-.6396),(-3.65758,1.01044,.15026),(-3.70979,.80003,.92597),(-3.75081,.78032,1.13811),(-3.21666,1.66603,-.54387),(-3.66896,1.24228,.2065),(-3.46087,1.6225,-.57118),(-3.54049,1.56436,-.75339),(-3.28726,1.32203,-.8577),(-3.19936,1.21942,-.84232),(-3.13223,1.31181,-.77574),(-3.07435,1.38712,-.71553),(-3.84209,.39832,1.31439),(-3.77592,.37516,1.2506),(-3.80244,.34397,1.24688),(-3.87302,.28276,1.21398),(-3.92855,.36011,1.29845),(-3.50537,1.01421,.1905),(-4.09182,.47806,1.29017),(-3.98665,.28761,1.05924),(-3.76288,.71892,1.22155)]))),
        Shape(DEF='rmet5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rmet5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,23,24,21,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,36,37,34,-1,38,39,40,-1,38,35,39,-1,41,42,19,-1,41,43,42,-1,44,45,46,-1,46,47,44,-1,48,49,50,-1,49,51,50,-1,51,52,53,-1,51,54,52,-1,55,49,56,-1,49,57,56,-1,55,58,59,-1,55,56,58,-1,14,60,61,-1,14,13,60,-1,62,63,64,-1,62,65,63,-1,66,67,68,-1,66,69,67,-1,70,71,72,-1,71,65,72,-1,73,74,75,-1,74,76,75,-1,77,78,79,-1,77,80,81,-1,77,82,83,-1,77,84,85,-1,43,86,87,-1,43,88,86,-1,89,31,90,-1,91,92,93,-1,94,72,95,-1,96,97,70,-1,76,98,99,-1,100,101,102,-1,102,103,100,-1,104,36,105,-1,106,107,108,-1,109,110,111,-1,97,112,70,-1,32,23,22,-1,113,9,114,-1,9,115,114,-1,116,113,117,-1,113,114,117,-1,118,114,115,-1,118,119,114,-1,120,121,122,-1,123,4,3,-1,124,125,126,-1,127,128,129,-1,130,131,132,-1,132,133,130,-1,134,135,136,-1,134,137,135,-1,138,139,140,-1,141,142,16,-1,143,144,145,-1,144,146,145,-1,147,148,149,-1,148,150,149,-1,151,152,153,-1,152,154,153,-1,155,156,157,-1,158,159,160,-1,160,161,158,-1,162,163,164,-1,165,166,167,-1,168,169,170,-1,171,172,128,-1,173,174,175,-1,176,173,177,-1,176,174,173,-1,178,179,180,-1,181,182,177,-1,182,176,177,-1,159,183,184,-1,166,155,157,-1,185,186,187,-1,188,154,189,-1,190,191,162,-1,192,193,194,-1,195,190,196,-1,195,197,190,-1,153,198,150,-1,153,199,198,-1,191,190,197,-1,170,169,200,-1,169,201,200,-1,202,135,139,-1,203,204,205,-1,5,206,207,-1,208,209,127,-1,171,128,127,-1,5,181,3,-1,197,210,211,-1,212,192,213,-1,212,214,192,-1,215,188,216,-1,215,199,188,-1,217,182,218,-1,217,219,182,-1,220,221,222,-1,222,223,220,-1,224,225,1,-1,0,226,227,-1,219,228,229,-1,229,230,219,-1,231,170,232,-1,233,124,202,-1,202,139,233,-1,234,235,236,-1,235,237,236,-1,238,120,239,-1,238,240,120,-1,226,121,241,-1,122,242,120,-1,243,244,245,-1,224,160,225,-1,224,161,160,-1,246,247,1,-1,170,231,168,-1,238,248,186,-1,186,240,238,-1,242,239,120,-1,249,250,251,-1,249,252,250,-1,124,132,253,-1,205,254,203,-1,255,256,147,-1,198,257,258,-1,259,260,261,-1,259,201,260,-1,262,263,264,-1,189,265,266,-1,176,222,174,-1,176,230,222,-1,267,268,152,-1,16,269,17,-1,16,270,269,-1,3,177,123,-1,271,272,273,-1,271,274,272,-1,275,276,277,-1,275,278,276,-1,279,275,280,-1,279,281,275,-1,138,282,252,-1,126,202,124,-1,283,206,5,-1,127,284,285,-1,209,286,127,-1,287,36,104,-1,288,289,290,-1,290,291,288,-1,107,42,108,-1,292,33,107,-1,106,108,293,-1,82,85,86,-1,85,11,86,-1,91,74,294,-1,294,92,91,-1,9,85,84,-1,9,11,85,-1,119,67,295,-1,119,63,67,-1,296,69,297,-1,296,298,69,-1,299,66,300,-1,299,301,66,-1,101,51,53,-1,101,100,51,-1,302,303,304,-1,302,103,303,-1,305,277,276,-1,305,306,277,-1,307,308,309,-1,308,310,309,-1,311,39,35,-1,312,311,34,-1,312,307,311,-1,313,312,314,-1,37,36,287,-1,315,316,58,-1,54,55,59,-1,317,61,318,-1,45,44,319,-1,320,321,322,-1,323,324,325,-1,37,291,290,-1,37,287,291,-1,311,35,34,-1,326,38,40,-1,327,328,329,-1,327,330,328,-1,331,332,308,-1,332,333,308,-1,310,306,334,-1,306,305,334,-1,332,335,333,-1,335,336,333,-1,100,103,302,-1,337,338,300,-1,302,51,100,-1,302,50,51,-1,339,340,341,-1,66,68,300,-1,68,337,300,-1,342,269,343,-1,342,296,269,-1,71,344,345,-1,71,346,344,-1,63,119,64,-1,116,347,348,-1,116,117,347,-1,349,350,351,-1,351,352,349,-1,353,354,355,-1,355,356,353,-1,353,314,354,-1,18,357,358,-1,358,19,18,-1,127,285,359,-1,127,286,171,-1,278,360,276,-1,278,361,360,-1,4,123,362,-1,123,363,362,-1,123,173,364,-1,123,177,173,-1,365,366,367,-1,368,369,370,-1,369,371,370,-1,151,267,152,-1,151,372,267,-1,265,373,266,-1,373,374,266,-1,375,261,376,-1,375,262,261,-1,201,259,200,-1,257,198,199,-1,199,215,257,-1,256,377,270,-1,256,255,377,-1,197,378,210,-1,197,195,378,-1,187,156,185,-1,379,327,380,-1,380,381,379,-1,382,383,384,-1,384,385,382,-1,234,386,178,-1,168,387,169,-1,387,388,169,-1,212,2,389,-1,190,243,245,-1,190,162,243,-1,164,165,162,-1,390,375,391,-1,390,392,375,-1,393,379,332,-1,379,335,332,-1,167,380,327,-1,327,329,167,-1,184,183,394,-1,175,364,173,-1,175,395,364,-1,396,397,398,-1,217,170,399,-1,217,232,170,-1,183,159,158,-1,223,222,230,-1,217,218,400,-1,400,232,217,-1,372,148,143,-1,372,151,148,-1,258,378,195,-1,5,207,401,-1,236,383,382,-1,203,254,402,-1,359,208,127,-1,402,403,203,-1,131,253,132,-1,193,404,194,-1,404,405,194,-1,211,191,197,-1,211,163,191,-1,163,406,389,-1,163,211,406,-1,149,258,195,-1,195,255,149,-1,191,163,162,-1,255,196,377,-1,156,187,157,-1,163,389,407,-1,389,247,407,-1,158,166,183,-1,158,155,166,-1,156,227,185,-1,408,246,160,-1,246,225,160,-1,225,246,1,-1,181,218,182,-1,181,409,218,-1,384,285,284,-1,389,214,212,-1,394,163,407,-1,394,164,163,-1,152,268,410,-1,410,154,152,-1,147,149,255,-1,410,411,265,-1,133,132,412,-1,129,284,127,-1,253,125,124,-1,3,181,177,-1,4,283,5,-1,118,115,109,-1,109,6,118,-1,81,80,413,-1,413,110,81,-1,86,414,82,-1,414,83,82,-1,27,26,415,-1,416,72,94,-1,417,418,350,-1,350,349,417,-1,12,14,419,-1,32,20,19,-1,38,326,105,-1,75,76,420,-1,76,99,420,-1,91,41,421,-1,304,303,422,-1,8,423,6,-1,93,88,91,-1,424,11,10,-1,43,41,88,-1,41,91,88,-1,77,85,82,-1,77,83,80,-1,77,81,78,-1,77,79,84,-1,413,93,92,-1,92,110,413,-1,91,76,74,-1,425,96,70,-1,95,423,8,-1,8,94,95,-1,111,92,294,-1,426,427,60,-1,60,13,426,-1,428,337,344,-1,429,430,338,-1,318,59,58,-1,291,27,288,-1,27,415,288,-1,44,426,431,-1,107,33,32,-1,36,35,38,-1,289,354,290,-1,354,314,290,-1,38,105,36,-1,292,107,106,-1,32,22,20,-1,300,338,430,-1,34,314,312,-1,118,64,119,-1,88,414,86,-1,110,92,111,-1,244,432,433,-1,348,434,116,-1,348,435,434,-1,255,195,196,-1,165,183,166,-1,348,432,435,-1,433,432,348,-1,69,301,297,-1,69,66,301,-1,436,23,89,-1,436,24,23,-1,300,437,299,-1,300,430,437,-1,438,439,440,-1,441,439,438,-1,357,21,442,-1,21,357,18,-1,443,444,445,-1,446,444,443,-1,447,448,449,-1,447,450,448,-1,101,46,102,-1,47,46,101,-1,289,106,354,-1,292,106,289,-1,34,290,314,-1,290,34,37,-1,415,33,288,-1,415,31,33,-1,104,323,287,-1,324,323,104,-1,27,287,323,-1,27,291,287,-1,322,326,320,-1,322,105,326,-1,451,452,48,-1,451,453,452,-1,44,427,426,-1,44,47,427,-1,317,417,29,-1,317,316,417,-1,418,454,97,-1,315,454,418,-1,428,346,455,-1,428,344,346,-1,64,95,62,-1,95,64,423,-1,7,294,456,-1,294,7,111,-1,72,425,70,-1,72,416,425,-1,93,414,88,-1,93,413,414,-1,86,424,87,-1,11,424,86,-1,424,355,293,-1,424,10,355,-1,457,422,458,-1,457,304,422,-1,428,338,337,-1,428,453,338,-1,339,458,422,-1,339,341,458,-1,459,12,460,-1,12,459,431,-1,52,427,53,-1,427,52,60,-1,461,319,459,-1,461,321,319,-1,91,98,76,-1,91,421,98,-1,351,75,420,-1,425,75,351,-1,462,324,463,-1,462,325,324,-1,28,14,29,-1,419,14,28,-1,47,53,427,-1,47,101,53,-1,464,465,313,-1,464,466,465,-1,379,330,327,-1,330,379,393,-1,31,26,90,-1,26,31,415,-1,413,83,414,-1,413,80,83,-1,6,111,7,-1,6,109,111,-1,298,117,295,-1,298,347,117,-1,467,468,284,-1,468,467,469,-1,470,469,471,-1,470,468,469,-1,129,472,473,-1,129,128,472,-1,474,475,476,-1,477,475,474,-1,372,478,267,-1,372,479,478,-1,220,267,478,-1,220,268,267,-1,408,394,407,-1,184,394,408,-1,480,359,383,-1,480,208,359,-1,209,480,207,-1,209,208,480,-1,481,178,180,-1,234,178,481,-1,161,227,156,-1,161,224,227,-1,165,394,183,-1,165,164,394,-1,0,224,1,-1,227,224,0,-1,192,482,193,-1,192,214,482,-1,406,214,389,-1,482,214,406,-1,391,404,483,-1,404,391,405,-1,411,373,265,-1,373,411,484,-1,228,397,229,-1,398,397,228,-1,260,213,485,-1,388,213,260,-1,390,188,189,-1,188,390,216,-1,200,399,170,-1,200,486,399,-1,487,136,126,-1,476,136,487,-1,474,402,472,-1,403,402,474,-1,204,471,469,-1,471,204,488,-1,402,473,472,-1,473,402,254,-1,477,172,489,-1,477,128,172,-1,386,385,490,-1,382,385,386,-1,204,491,488,-1,204,203,491,-1,236,480,383,-1,237,480,236,-1,492,366,370,-1,367,366,492,-1,493,145,368,-1,493,479,145,-1,494,404,495,-1,494,483,404,-1,168,496,387,-1,168,180,496,-1,231,400,481,-1,231,232,400,-1,374,397,396,-1,374,373,397,-1,175,222,221,-1,175,174,222,-1,364,497,498,-1,395,497,364,-1,179,121,499,-1,179,122,121,-1,500,479,493,-1,478,479,500,-1,141,369,146,-1,141,501,369,-1,441,15,439,-1,16,15,441,-1,356,464,353,-1,356,502,464,-1,503,330,466,-1,503,328,330,-1,282,250,252,-1,282,504,250,-1,505,273,272,-1,505,492,273,-1,248,187,186,-1,506,187,248,-1,379,507,335,-1,379,381,507,-1,508,251,509,-1,508,506,251,-1,263,375,392,-1,263,262,375,-1,277,333,336,-1,306,333,277,-1,217,228,219,-1,399,228,217,-1,165,243,162,-1,243,165,167,-1,240,185,241,-1,240,186,185,-1,122,178,386,-1,178,122,179,-1,386,242,122,-1,386,490,242,-1,508,380,157,-1,508,381,380,-1,506,249,251,-1,248,249,506,-1,242,133,239,-1,130,133,242,-1,385,284,468,-1,384,284,385,-1,507,279,280,-1,509,279,507,-1,245,196,190,-1,245,377,196,-1,270,343,269,-1,270,377,343,-1,510,378,511,-1,510,210,378,-1,482,510,495,-1,482,406,510,-1,494,257,215,-1,494,511,257,-1,194,376,485,-1,376,194,405,-1,401,235,409,-1,235,401,237,-1,392,374,263,-1,266,374,392,-1,263,396,264,-1,263,374,396,-1,176,219,230,-1,176,182,219,-1,493,365,500,-1,493,366,365,-1,144,148,147,-1,148,144,143,-1,371,501,512,-1,501,371,369,-1,438,271,512,-1,361,271,438,-1,371,492,370,-1,371,273,492,-1,175,367,395,-1,175,365,367,-1,475,363,134,-1,362,363,475,-1,363,137,134,-1,137,363,498,-1,395,513,497,-1,395,367,513,-1,505,138,513,-1,505,282,138,-1,281,278,275,-1,281,274,278,-1,491,403,487,-1,203,403,491,-1,323,25,27,-1,323,325,25,-1,442,24,514,-1,442,21,24,-1,329,432,244,-1,432,329,328,-1,434,503,502,-1,434,435,503,-1,313,353,464,-1,313,314,353,-1,515,421,358,-1,515,98,421,-1,99,516,420,-1,517,516,99,-1,74,456,294,-1,456,74,73,-1,347,433,348,-1,347,342,433,-1,113,434,518,-1,113,116,434,-1,115,78,109,-1,115,79,78,-1,6,64,118,-1,6,423,64,-1,345,337,68,-1,345,344,337,-1,70,346,71,-1,70,112,346,-1,452,428,455,-1,452,453,428,-1,360,437,340,-1,437,360,440,-1,50,304,457,-1,50,302,304,-1,55,51,49,-1,54,51,55,-1,339,305,340,-1,339,334,305,-1,326,102,46,-1,326,40,102,-1,306,308,333,-1,308,306,310,-1,465,332,331,-1,332,465,393,-1,303,310,334,-1,309,310,303,-1,309,103,39,-1,309,303,103,-1,322,463,324,-1,322,519,463,-1,320,319,321,-1,319,320,45,-1,463,520,462,-1,463,521,520,-1,461,522,519,-1,461,523,522,-1,459,44,431,-1,459,319,44,-1,460,524,523,-1,524,460,525,-1,526,522,527,-1,526,521,522,-1,515,357,444,-1,358,357,515,-1,445,527,443,-1,445,526,527,-1,525,450,524,-1,450,525,448,-1,30,352,449,-1,352,30,349,-1,517,447,516,-1,517,446,447,-1,446,515,444,-1,517,515,446,-1,449,516,447,-1,516,449,352,-1,318,316,317,-1,318,58,316,-1,318,60,52,-1,318,61,60,-1,56,315,58,-1,454,315,56,-1,448,419,28,-1,448,525,419,-1,524,443,527,-1,443,524,450,-1,445,514,526,-1,442,514,445,-1,521,514,520,-1,514,521,526,-1,523,527,522,-1,527,523,524,-1,419,460,12,-1,525,460,419,-1,460,461,459,-1,460,523,461,-1,521,519,522,-1,519,521,463,-1,313,331,312,-1,331,313,465,-1,39,307,309,-1,39,311,307,-1,312,308,307,-1,308,312,331,-1,276,340,305,-1,340,276,360,-1,457,48,50,-1,48,457,451,-1,455,57,452,-1,528,57,455,-1,296,17,269,-1,297,17,296,-1,72,62,95,-1,72,65,62,-1,295,69,298,-1,295,67,69,-1,78,110,109,-1,78,81,110,-1,518,9,113,-1,9,518,10,-1,433,343,244,-1,433,342,343,-1,73,94,456,-1,73,416,94,-1,420,352,351,-1,516,352,420,-1,517,98,515,-1,517,99,98,-1,87,293,108,-1,293,87,424,-1,288,292,289,-1,288,33,292,-1,43,108,42,-1,108,43,87,-1,502,518,434,-1,502,356,518,-1,435,328,503,-1,435,432,328,-1,356,10,518,-1,356,355,10,-1,24,520,514,-1,24,436,520,-1,421,19,358,-1,421,41,19,-1,489,206,283,-1,489,172,206,-1,125,487,126,-1,491,487,125,-1,139,252,233,-1,139,138,252,-1,250,281,279,-1,250,504,281,-1,277,280,275,-1,280,277,336,-1,274,361,278,-1,274,271,361,-1,504,274,281,-1,272,274,504,-1,513,492,505,-1,513,367,492,-1,138,497,513,-1,138,140,497,-1,363,364,498,-1,363,123,364,-1,512,273,371,-1,271,273,512,-1,361,440,360,-1,361,438,440,-1,270,142,256,-1,16,142,270,-1,142,147,256,-1,144,147,142,-1,221,365,175,-1,221,500,365,-1,229,223,230,-1,229,484,223,-1,398,264,396,-1,398,486,264,-1,392,189,266,-1,392,390,189,-1,486,259,264,-1,259,486,200,-1,376,260,485,-1,261,260,376,-1,376,391,375,-1,376,405,391,-1,511,495,510,-1,494,495,511,-1,406,210,510,-1,210,406,211,-1,511,258,257,-1,511,378,258,-1,377,244,343,-1,377,245,244,-1,253,491,125,-1,488,491,253,-1,252,412,233,-1,412,252,249,-1,250,509,251,-1,250,279,509,-1,280,335,507,-1,280,336,335,-1,242,470,130,-1,470,242,490,-1,249,238,412,-1,238,249,248,-1,234,382,386,-1,234,236,382,-1,157,167,166,-1,157,380,167,-1,212,388,387,-1,213,388,212,-1,244,167,329,-1,244,243,167,-1,401,181,5,-1,409,181,401,-1,264,261,262,-1,264,259,261,-1,509,381,508,-1,381,509,507,-1,157,506,508,-1,187,506,157,-1,272,282,505,-1,282,272,504,-1,502,466,464,-1,502,503,466,-1,301,439,15,-1,301,299,439,-1,16,501,141,-1,16,441,501,-1,146,368,145,-1,146,369,368,-1,227,241,185,-1,227,226,241,-1,499,226,0,-1,226,499,121,-1,240,121,120,-1,240,241,121,-1,238,133,412,-1,238,239,133,-1,124,412,132,-1,233,412,124,-1,140,498,497,-1,140,137,498,-1,220,484,411,-1,220,223,484,-1,407,246,408,-1,246,407,247,-1,478,221,220,-1,478,500,221,-1,481,168,231,-1,168,481,180,-1,2,387,496,-1,212,387,2,-1,483,215,216,-1,494,215,483,-1,193,495,404,-1,482,495,193,-1,493,370,366,-1,493,368,370,-1,477,362,475,-1,477,489,362,-1,362,283,4,-1,489,283,362,-1,490,468,470,-1,385,468,490,-1,480,401,207,-1,480,237,401,-1,473,205,467,-1,205,473,254,-1,488,131,471,-1,131,488,253,-1,205,469,467,-1,469,205,204,-1,403,476,487,-1,403,474,476,-1,202,136,135,-1,136,202,126,-1,154,265,189,-1,410,265,154,-1,485,192,194,-1,485,213,192,-1,388,201,169,-1,388,260,201,-1,399,398,228,-1,399,486,398,-1,373,229,397,-1,373,484,229,-1,483,390,391,-1,483,216,390,-1,198,149,150,-1,258,149,198,-1,153,188,199,-1,153,154,188,-1,2,247,389,-1,247,2,1,-1,481,235,234,-1,481,400,235,-1,235,218,409,-1,235,400,218,-1,180,499,496,-1,180,179,499,-1,359,384,383,-1,359,285,384,-1,286,207,206,-1,286,209,207,-1,172,286,206,-1,172,171,286,-1,496,0,2,-1,0,496,499,-1,160,184,408,-1,159,184,160,-1,156,158,161,-1,155,158,156,-1,150,151,153,-1,148,151,150,-1,142,146,144,-1,142,141,146,-1,479,143,145,-1,372,143,479,-1,411,268,220,-1,410,268,411,-1,137,139,135,-1,137,140,139,-1,476,134,136,-1,475,134,476,-1,477,472,128,-1,477,474,472,-1,473,284,129,-1,284,473,467,-1,130,471,131,-1,130,470,471,-1,296,347,298,-1,296,342,347,-1,295,114,119,-1,295,117,114,-1,84,115,9,-1,84,79,115,-1,89,32,31,-1,32,89,23,-1,466,393,465,-1,466,330,393,-1,528,56,57,-1,528,454,56,-1,29,349,30,-1,29,417,349,-1,430,340,437,-1,341,340,430,-1,325,529,25,-1,462,529,325,-1,425,350,96,-1,425,351,350,-1,350,97,96,-1,97,350,418,-1,519,321,461,-1,519,322,321,-1,431,13,12,-1,13,431,426,-1,334,422,303,-1,334,339,422,-1,341,429,458,-1,341,430,429,-1,451,458,429,-1,451,457,458,-1,462,436,529,-1,520,436,462,-1,354,293,355,-1,106,293,354,-1,65,345,63,-1,65,71,345,-1,416,75,425,-1,416,73,75,-1,63,68,67,-1,345,68,63,-1,8,456,94,-1,7,456,8,-1,528,97,454,-1,528,112,97,-1,455,112,528,-1,455,346,112,-1,417,315,418,-1,316,315,417,-1,61,29,14,-1,61,317,29,-1,453,429,338,-1,451,429,453,-1,48,57,49,-1,48,452,57,-1,52,59,318,-1,54,59,52,-1,104,322,324,-1,105,322,104,-1,46,320,326,-1,45,320,46,-1,19,107,32,-1,19,42,107,-1,103,40,39,-1,103,102,40,-1,449,28,30,-1,449,448,28,-1,450,446,443,-1,447,446,450,-1,442,444,357,-1,442,445,444,-1,441,512,501,-1,441,438,512,-1,440,299,437,-1,439,299,440,-1,90,25,529,-1,25,90,26,-1,18,22,21,-1,18,20,22,-1,529,89,90,-1,529,436,89,-1,297,15,17,-1,297,301,15,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rmet5_Coord',point=[(-3.65503,1.37954,-.9894),(-3.64656,1.38915,-.98041),(-3.63578,1.39327,-.99779),(-3.65686,.96514,-1.39993),(-3.68517,.92042,-1.42685),(-3.69247,.99047,-1.49846),(-4.13521,.54764,.71516),(-4.17802,.52102,.75165),(-4.14009,.49654,.7242),(-4.10658,.73866,.69559),(-4.15141,.79738,.65478),(-4.17196,.76518,.72517),(-4.31653,.35115,.55026),(-4.29228,.35905,.55881),(-4.29227,.33366,.66491),(-3.6772,.86964,-.14147),(-3.59843,.93659,-.33266),(-3.66636,.89421,-.13398),(-4.4063,.72747,.80235),(-4.33938,.73298,.82415),(-4.40073,.75554,.77183),(-4.43422,.72968,.7786),(-4.41488,.75465,.75887),(-4.43429,.76884,.72271),(-4.46442,.74633,.70675),(-4.42873,.8006,.5214),(-4.40639,.82217,.53293),(-4.40571,.81624,.46475),(-4.30824,.339,.71134),(-4.25301,.32238,.69564),(-4.27938,.33948,.73512),(-4.38519,.80148,.64935),(-4.39286,.77245,.73511),(-4.3607,.80738,.65626),(-4.35915,.72704,.37375),(-4.38013,.61543,.39161),(-4.39908,.61387,.41346),(-4.37954,.72923,.3884),(-4.39317,.59597,.40536),(-4.3199,.59205,.33556),(-4.32362,.57598,.34694),(-4.24934,.71114,.83346),(-4.32003,.73385,.80363),(-4.24302,.72189,.81507),(-4.30075,.40935,.4192),(-4.32162,.44288,.38728),(-4.30974,.46521,.36977),(-4.28312,.42018,.42025),(-4.12755,.50959,.52097),(-4.16106,.45348,.56412),(-4.16217,.50489,.45218),(-4.2027,.45227,.51827),(-4.22682,.4132,.57054),(-4.21717,.44056,.51631),(-4.20997,.42068,.57666),(-4.18125,.42304,.60685),(-4.16261,.41902,.61535),(-4.14393,.45205,.57378),(-4.21028,.37475,.67041),(-4.20218,.39668,.63356),(-4.26972,.36964,.56199),(-4.26949,.33831,.66174),(-4.05135,.51409,.63779),(-3.95486,.56392,.56744),(-4.06284,.53313,.6437),(-4.0268,.48708,.63556),(-3.82651,.69577,.34027),(-3.88628,.64107,.47256),(-3.89005,.61147,.45393),(-3.82068,.71162,.35256),(-4.06426,.4158,.68412),(-4.02604,.46154,.61747),(-4.07226,.4413,.69935),(-4.16928,.4863,.8209),(-4.20292,.56186,.85691),(-4.17408,.46881,.83961),(-4.22044,.55668,.87656),(-4.14395,.68663,.77749),(-4.13882,.67175,.77463),(-4.12891,.67803,.76611),(-4.1576,.6815,.78892),(-4.14848,.67177,.7824),(-4.14936,.70131,.78058),(-4.15745,.68987,.78808),(-4.13067,.69665,.76592),(-4.1404,.70215,.77329),(-4.20051,.75505,.77306),(-4.22271,.76314,.77064),(-4.21593,.70176,.81854),(-4.42954,.78998,.64305),(-4.42423,.79348,.62713),(-4.20718,.65346,.84721),(-4.20059,.62794,.79174),(-4.19865,.6648,.81785),(-4.13372,.48052,.7277),(-4.10493,.48385,.69645),(-4.08672,.40061,.7188),(-4.10432,.3821,.67175),(-4.29606,.57241,.8916),(-4.28937,.53954,.88845),(-4.22465,.48752,.40899),(-4.24206,.47799,.40825),(-4.27406,.53133,.3508),(-4.25825,.53794,.33879),(-4.4659,.63723,.45054),(-4.44992,.57937,.42972),(-4.30128,.79154,.6656),(-4.369,.76815,.72177),(-4.27267,.77565,.75417),(-4.15297,.59881,.73745),(-4.18045,.64165,.78213),(-4.19964,.58617,.77362),(-4.07588,.41198,.63274),(-4.02878,.78406,.58689),(-3.99785,.71632,.57945),(-4.09705,.64373,.70026),(-3.97307,.81958,.51151),(-3.93769,.76339,.5096),(-4.08303,.58039,.66482),(-3.98728,.63436,.56525),(-3.84512,1.25615,-1.09712),(-3.77697,1.30069,-1.09582),(-3.82291,1.23745,-1.25049),(-3.69967,.92057,-1.33301),(-3.97356,.94251,-1.12545),(-3.96851,.95082,-1.30221),(-3.91713,.86781,-1.34313),(-3.82811,1.03249,-1.61378),(-3.84307,.97991,-1.58068),(-3.8694,1.02921,-1.60483),(-3.9952,1.10012,-1.28099),(-4.02013,1.08519,-1.28956),(-4.00643,1.06206,-1.11336),(-3.98923,1.08785,-1.10822),(-3.88759,.87483,-1.34662),(-3.87625,.85737,-1.15949),(-3.90595,.86342,-1.34456),(-3.85958,.85951,-1.16665),(-3.8186,.897,-.93378),(-3.84869,.87516,-1.04516),(-3.8341,.87611,-1.05039),(-3.53616,.95851,-.51546),(-3.52597,.98671,-.50291),(-3.38886,1.00504,-.81434),(-3.45053,.99808,-.66067),(-3.40836,.97705,-.82253),(-3.46327,.96977,-.67031),(-3.46222,1.06317,-.62363),(-3.38981,1.05007,-.80496),(-3.4535,1.10264,-.59178),(-3.36083,1.07414,-.78809),(-3.36468,1.04656,-.90218),(-3.34555,1.03212,-.99547),(-3.32908,1.07153,-.90164),(-3.30271,1.06928,-1.00736),(-3.79645,1.23905,-.59109),(-3.79075,1.26786,-.67802),(-3.83249,1.18988,-.52894),(-3.78245,1.25514,-.589),(-3.7615,1.27045,-.57673),(-3.76263,1.31184,-.655),(-3.77831,1.28442,-.67137),(-3.68156,1.22936,-.47458),(-3.65371,1.31058,-.63914),(-3.69778,1.2649,-.55435),(-3.74969,1.22466,-.48758),(-3.76984,1.2194,-.49482),(-3.81076,1.1623,-.29939),(-3.69797,1.28326,-1.30929),(-3.6704,1.31583,-1.33301),(-3.65085,1.2144,-1.42092),(-3.80485,.98053,-1.58538),(-3.79978,.9635,-1.57163),(-3.62285,.94378,-1.19881),(-3.58169,.9546,-1.19377),(-3.58774,.94049,-1.08544),(-3.59342,.98637,-1.30243),(-3.63145,.96682,-1.30729),(-3.76933,1.2564,-1.32564),(-3.76944,1.26183,-1.28072),(-3.73638,1.27865,-1.29874),(-3.63379,1.00689,-1.37948),(-3.60596,1.02351,-1.36164),(-3.75936,1.22954,-.49803),(-3.73927,1.2773,-.5699),(-3.77476,1.28516,-.88659),(-3.82481,1.25355,-.88089),(-3.83141,1.22279,-.7031),(-3.30196,1.09619,-.99306),(-3.29915,1.09124,-1.01458),(-3.64387,1.21406,-.4168),(-3.65045,1.24221,-.45276),(-3.54215,1.43807,-.99329),(-3.52242,1.42631,-.96895),(-3.51844,1.42959,-.99392),(-3.55911,1.16925,-.46087),(-3.58669,1.13549,-.4355),(-3.60815,1.24366,-.45635),(-3.36278,1.10445,-.79048),(-3.32848,1.10211,-.89478),(-3.62913,1.22076,-1.40916),(-3.64841,1.31403,-1.33385),(-3.888,.86053,-1.15499),(-3.9361,.98341,-1.51996),(-3.96659,1.07951,-1.5241),(-3.92052,1.07248,-1.59791),(-3.74121,.98375,-1.55721),(-3.73256,1.05087,-1.55841),(-3.79021,1.09082,-1.57645),(-3.76317,1.0498,-1.58463),(-3.56411,1.28064,-.61029),(-3.61125,1.3173,-.63099),(-3.5895,1.3916,-1.0316),(-3.56805,1.43404,-1.06717),(-3.56653,1.40963,-.92466),(-3.34812,1.13879,-.89694),(-3.31631,1.14505,-.99137),(-3.63356,1.12433,-1.40916),(-3.65401,1.10777,-1.41635),(-3.57258,1.03384,-1.36105),(-3.38388,.98928,-1.10942),(-3.44402,.96133,-1.08147),(-3.48793,.96271,-1.18526),(-3.42392,.97635,-1.20618),(-3.71822,1.32686,-.87043),(-3.69904,1.37802,-.85094),(-3.73786,1.31415,-.98158),(-3.72755,1.31433,-.88191),(-3.5436,1.06224,-1.37242),(-3.48223,1.0194,-1.30825),(-3.53268,1.00752,-1.3067),(-3.68981,1.20601,-1.41589),(-3.67633,1.19548,-1.42393),(-3.94991,.94605,-1.00729),(-3.75547,1.19282,-1.4244),(-3.71579,1.15398,-1.44595),(-3.77021,1.17344,-1.49478),(-3.74144,1.13685,-1.50104),(-3.9027,1.18096,-.98844),(-3.92442,1.1958,-1.08753),(-3.82807,1.25907,-.99083),(-3.76847,1.29561,-.99186),(-3.94096,1.18163,-1.25599),(-3.73293,1.15365,-.24887),(-3.76331,1.08382,-.07922),(-3.70835,1.14075,-.24164),(-3.67073,1.39324,-.83463),(-3.61913,1.36999,-.81647),(-3.88419,1.16853,-.88939),(-3.9318,1.05497,-.88053),(-3.90734,.95579,-.72476),(-3.93216,1.05259,-.72773),(-3.92104,.95842,-.88919),(-4.02234,1.07307,-1.29201),(-3.89484,1.02149,-1.61376),(-3.56562,1.12747,-.46281),(-3.53799,1.07435,-.47665),(-3.38554,1.13098,-.79112),(-3.4517,1.14012,-.59578),(-3.58434,1.25654,-1.32853),(-3.59347,1.39224,-1.19678),(-3.52856,1.29813,-1.20455),(-3.46498,1.19307,-1.19584),(-3.43479,1.12184,-1.19675),(-3.53808,1.15942,-1.32621),(-3.34453,1.01414,-1.12494),(-3.33743,1.05022,-1.10419),(-3.36429,1.00215,-.97818),(-3.36824,1.00909,-1.06791),(-3.66161,.9477,-.12104),(-3.60982,1.00812,-.30461),(-3.69698,.88733,-.57165),(-3.75696,.88551,-.7387),(-3.68014,.89959,-.74806),(-3.76028,.86432,-.58905),(-3.87806,.85494,-.45962),(-3.89037,.78503,-.20938),(-3.96552,.81234,-.22914),(-3.80496,.83771,-.41912),(-3.92007,.96188,-.59042),(-3.93626,.94318,-.43517),(-3.83874,.86789,-.60532),(-3.81894,.89354,-.88519),(-3.7135,.95175,-1.5035),(-3.89846,1.0915,-1.58952),(-3.86535,1.10923,-1.58184),(-3.76956,.99783,-1.58326),(-4.42609,.73212,.41167),(-4.34905,.83544,.54135),(-4.30109,.81092,.55469),(-4.32895,.7898,.43412),(-4.39173,.81583,.45154),(-4.32905,.79205,.65891),(-4.23627,.78714,.68458),(-4.21034,.58111,.79183),(-3.91055,.68898,.48513),(-3.72841,.86803,.12019),(-3.72692,.81916,.09564),(-3.84421,.76058,.36318),(-3.7788,.75694,.04862),(-3.87671,.68363,.3006),(-3.73581,.79749,.08195),(-4.19582,.50126,.38231),(-4.22064,.57463,.28557),(-4.13492,.55435,.33864),(-3.98311,.70668,-.04648),(-4.05327,.76244,-.05992),(-4.31262,.67737,.2944),(-4.20647,.76015,.1697),(-4.26807,.614,.28271),(-4.16498,.69363,.14499),(-4.35668,.63755,.35284),(-4.31429,.75191,.3349),(-4.24906,.81688,.37561),(-4.29761,.79487,.42001),(-4.15568,.35648,.68122),(-4.20028,.33448,.69672),(-4.24057,.32994,.68174),(-4.2255,.37504,.66053),(-4.33719,.42464,.40797),(-4.3942,.51146,.37571),(-4.41401,.49161,.39992),(-4.46158,.57102,.44162),(-4.44108,.73118,.42869),(-4.47854,.64386,.46284),(-4.46384,.71908,.48591),(-4.38116,.53742,.3585),(-3.91948,1.07267,-.13073),(-3.9433,.9814,.11855),(-3.85396,1.07732,-.10916),(-3.99316,.97272,.08336),(-4.2133,.80825,.19424),(-4.08109,.90731,-.00747),(-4.08639,.83869,-.03816),(-4.11193,.63775,.14992),(-4.01359,.97632,-.20162),(-4.0032,.90128,-.22817),(-3.9197,.58812,.42377),(-3.99032,.61041,.39967),(-4.03388,.63227,.20453),(-3.89926,.71372,-.0069),(-3.99821,.64444,.2253),(-3.77443,.91657,.15746),(-3.68825,1.00786,-.08099),(-3.98264,.52166,.52488),(-3.95836,.53445,.55259),(-4.0342,.4557,.58681),(-3.8741,.82249,.37662),(-3.91912,.8605,.37752),(-4.20171,.34712,.76426),(-4.13558,.36327,.76029),(-4.15928,.39935,.82436),(-4.24262,.39095,.82256),(-4.2313,.81786,.48147),(-4.27089,.80777,.56268),(-4.20101,.80273,.6205),(-4.15748,.8303,.52941),(-4.45086,.66081,.83003),(-4.37301,.68248,.86219),(-3.8097,1.12715,-1.56767),(-3.81358,.79343,-.18639),(-3.73732,.86181,-.39468),(-3.78677,.88548,-1.45786),(-3.78823,.87468,-1.36343),(-3.6939,.91301,-1.20975),(-3.57533,.93102,-.97482),(-3.57461,.93024,-.92296),(-3.68521,.91381,-.95589),(-3.45821,.93325,-.84315),(-3.50359,.93533,-.69585),(-3.56629,.93095,-.85995),(-3.58602,.91895,-.71004),(-3.37507,1.00734,-.89864),(-3.39722,.99266,-1.22464),(-3.39967,1.03978,-1.20237),(-3.41716,1.228,-1.11191),(-3.48631,1.32865,-1.09453),(-3.64118,1.06611,-.25678),(-3.49747,1.2028,-.59837),(-3.97751,1.05356,-.15758),(-3.8575,1.15435,-.34095),(-3.90774,1.10312,-.38615),(-3.81709,1.18872,-1.50041),(-3.80272,1.15576,-1.54156),(-3.87644,1.12479,-1.56498),(-3.90816,1.15091,-1.49792),(-3.82731,1.21701,-1.43348),(-3.63641,1.35471,-1.15583),(-3.61096,1.3987,-1.18765),(-3.59969,1.37104,-.81135),(-3.31904,1.14411,-1.01628),(-3.38584,1.25428,-1.01258),(-3.36847,1.12116,-1.10728),(-4.04293,.96404,.04817),(-3.70937,1.27241,-.56787),(-3.68712,.91159,-1.08278),(-3.48973,1.06185,-1.31793),(-3.47202,1.03824,-1.30693),(-3.53137,1.08182,-1.36609),(-3.60731,1.14412,-1.41146),(-3.69653,1.17215,-1.42512),(-3.69798,1.08176,-1.50196),(-3.86858,.97071,-1.59176),(-3.88867,.91985,-1.54084),(-3.45532,1.35281,-.95798),(-3.45436,1.35282,-.98368),(-3.5737,1.36098,-.80165),(-3.67011,1.30463,-.64424),(-3.7216,1.3251,-.64225),(-3.67099,1.08838,-1.43987),(-3.3408,1.00702,-1.09576),(-3.3549,.99449,-1.12516),(-3.9668,1.05677,-.99691),(-4.18556,.67449,.80418),(-4.19895,.69612,.80566),(-4.37451,.82892,.54223),(-4.12078,.45431,.77561),(-4.19881,.32843,.71499),(-4.1399,.35394,.6986),(-4.32655,.34252,.67565),(-4.22096,.46579,.87211),(-4.28263,.66407,.87052),(-4.11831,.56744,.31624),(-4.11609,.50318,.69976),(-4.18562,.78083,.70301),(-4.12216,.43568,.79318),(-4.28825,.36973,.50828),(-4.27111,.3813,.51096),(-4.00458,.52293,.50683),(-4.00342,.61071,.39316),(-3.93754,.66405,.26295),(-4.30912,.36513,.50022),(-3.85949,.98115,.16686),(-3.81646,.95077,.1631),(-4.03226,.85344,.48829),(-3.96515,.89467,.37656),(-4.46298,.75957,.63318),(-3.839,.73533,.02086),(-3.68563,.87935,-.38026),(-3.71407,.82956,-.15713),(-3.76375,.81147,-.17176),(-3.63408,.89685,-.36585),(-4.478,.6594,.8065),(-4.48043,.5045,.80206),(-4.48093,.59287,.83761),(-4.50392,.59333,.81303),(-4.45904,.50697,.8276),(-4.41424,.43854,.80898),(-4.37484,.37603,.74591),(-4.35269,.38001,.77314),(-4.43412,.43198,.782),(-4.07303,.56495,.47072),(-4.10932,.50736,.53282),(-4.05823,.56206,.48177),(-4.13962,.37838,.64926),(-4.06507,.4568,.56231),(-4.18194,.50888,.76777),(-4.1065,.56437,.39292),(-4.07555,.58786,.34409),(-4.35776,.39321,.4853),(-4.37663,.3757,.55806),(-4.44067,.46074,.4819),(-4.49468,.69594,.5587),(-4.51074,.61871,.52548),(-4.18402,.83398,.41409),(-4.15719,.86841,.24163),(-4.10329,.88126,.28318),(-3.915,1.08289,-1.59983),(-3.94567,1.10123,-1.51389),(-3.96302,1.0916,-1.52368),(-3.97798,1.10616,-1.4313),(-3.99953,1.09694,-1.43811),(-3.85754,.96922,-1.59429),(-3.88575,1.02769,-1.61907),(-3.87805,.91485,-1.541),(-3.88194,.88936,-1.47305),(-3.89987,.87845,-1.47655),(-3.86093,.92477,-1.52786),(-3.38696,.97671,-.97717),(-3.39391,.97992,-.89904),(-3.76606,1.11051,-1.54895),(-3.72671,1.20458,-1.40922),(-3.54671,1.39698,-.89781),(-3.38516,1.25419,-.98677),(-3.40572,.97737,-1.22257),(-3.54951,1.42819,-1.07497),(-3.5913,1.1595,-1.401),(-3.91067,.88308,-1.47632),(-4.00261,1.0848,-1.43913),(-3.7916,.91525,-1.52223),(-3.93647,1.16374,-1.41343),(-3.95848,.9629,-1.45197),(-3.68252,.90791,-.87533),(-3.44962,.94082,-.90681),(-3.4118,1.23822,-.90179),(-3.48291,1.33657,-.88413),(-3.69318,1.3515,-1.11576),(-3.76615,.88155,-1.07525),(-3.78747,.87023,-1.19842),(-3.71498,1.33788,-1.11049),(-3.44428,.94185,-.97123),(-3.57489,.9258,-.53787),(-4.11761,.85084,.44956),(-4.04918,.89403,.32473),(-3.82215,.88443,-.73982),(-3.75114,.89262,-.88564),(-3.88364,1.14759,-.72684),(-3.94824,1.03701,-.43119),(-3.89198,1.12436,-.55659),(-3.9353,1.04723,-.5889),(-3.51729,1.31892,-.79762),(-3.44348,1.21919,-.80525),(-3.63575,.90652,-.55475),(-3.74964,.89648,-.95216),(-4.51864,.67104,.69416),(-4.37527,.59118,.88396),(-4.29203,.45147,.86219),(-4.35265,.52858,.88253),(-4.09085,.82791,.56153),(-4.49145,.55091,.50844),(-4.50875,.68335,.61226),(-4.5325,.6042,.59376),(-4.50346,.52955,.58142),(-4.45938,.44075,.55495),(-4.46639,.42959,.68064),(-4.38243,.36698,.67648),(-4.54462,.59461,.69143),(-4.51559,.51108,.68701),(-4.10907,.40998,.60842),(-4.4537,.77066,.60269)]))),
        Shape(DEF='rfprox',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfprox_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,0,6,7,-1,8,4,9,-1,4,6,9,-1,4,10,5,-1,11,12,13,-1,14,15,16,-1,16,17,14,-1,18,19,14,-1,20,15,21,-1,15,22,21,-1,13,12,23,-1,24,25,26,-1,27,28,29,-1,27,30,28,-1,30,25,24,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,35,44,-1,45,46,47,-1,47,48,45,-1,9,49,8,-1,9,50,49,-1,51,0,2,-1,52,53,10,-1,53,54,10,-1,55,56,57,-1,55,58,56,-1,59,60,61,-1,59,62,60,-1,63,64,65,-1,66,44,67,-1,63,65,68,-1,35,64,44,-1,49,69,8,-1,70,52,69,-1,71,72,73,-1,71,74,72,-1,75,76,77,-1,76,78,77,-1,79,66,80,-1,81,34,36,-1,82,83,84,-1,69,49,70,-1,49,85,70,-1,86,87,88,-1,89,73,90,-1,5,89,3,-1,60,91,61,-1,61,92,42,-1,61,93,92,-1,94,57,46,-1,94,55,57,-1,45,95,96,-1,45,48,95,-1,95,97,98,-1,95,48,97,-1,53,99,100,-1,100,38,53,-1,101,54,37,-1,62,59,102,-1,103,41,104,-1,105,66,67,-1,106,107,108,-1,109,110,111,-1,29,109,112,-1,27,113,114,-1,115,116,117,-1,18,118,119,-1,119,19,18,-1,16,120,17,-1,16,121,120,-1,12,11,122,-1,123,33,32,-1,124,13,21,-1,125,126,124,-1,126,127,124,-1,127,126,128,-1,128,129,127,-1,130,131,132,-1,133,65,134,-1,65,135,134,-1,136,28,30,-1,30,137,136,-1,137,138,139,-1,140,24,26,-1,141,142,143,-1,144,145,146,-1,144,147,145,-1,148,149,150,-1,151,147,152,-1,147,144,152,-1,68,153,154,-1,68,155,153,-1,138,137,156,-1,136,137,139,-1,132,157,130,-1,158,159,131,-1,131,160,158,-1,11,124,127,-1,11,13,124,-1,161,162,163,-1,121,16,123,-1,164,22,19,-1,19,119,164,-1,18,26,118,-1,165,151,166,-1,161,149,148,-1,167,168,169,-1,167,170,168,-1,171,172,173,-1,174,115,175,-1,115,117,175,-1,114,117,116,-1,27,29,113,-1,29,112,113,-1,111,112,109,-1,176,177,167,-1,66,105,178,-1,179,180,40,-1,97,103,104,-1,104,98,97,-1,62,102,181,-1,181,182,62,-1,38,37,54,-1,183,81,36,-1,36,184,183,-1,91,93,61,-1,91,185,93,-1,73,92,71,-1,73,89,92,-1,1,0,7,-1,50,9,0,-1,86,186,187,-1,186,188,187,-1,44,66,189,-1,94,190,191,-1,80,192,190,-1,43,193,194,-1,43,195,193,-1,196,68,154,-1,154,192,196,-1,178,80,66,-1,191,192,146,-1,191,190,192,-1,34,81,188,-1,81,187,188,-1,60,62,106,-1,62,182,106,-1,42,59,61,-1,42,41,59,-1,10,101,5,-1,10,54,101,-1,81,183,85,-1,85,187,81,-1,44,195,43,-1,44,189,195,-1,0,51,197,-1,80,190,198,-1,48,47,97,-1,47,181,97,-1,103,59,41,-1,103,102,59,-1,179,37,39,-1,194,36,43,-1,36,35,43,-1,79,189,66,-1,54,53,38,-1,191,55,94,-1,131,130,160,-1,160,130,199,-1,130,200,199,-1,25,27,114,-1,25,30,27,-1,116,25,114,-1,116,26,25,-1,201,117,114,-1,122,150,149,-1,23,163,33,-1,17,18,14,-1,19,22,14,-1,22,15,14,-1,150,122,11,-1,69,4,8,-1,9,6,0,-1,7,4,3,-1,7,6,4,-1,73,88,90,-1,86,49,87,-1,197,50,0,-1,50,87,49,-1,87,50,197,-1,88,2,90,-1,88,51,2,-1,202,203,129,-1,202,204,203,-1,205,161,148,-1,205,162,161,-1,21,23,20,-1,21,13,23,-1,12,149,23,-1,149,12,122,-1,21,164,206,-1,22,164,21,-1,175,201,207,-1,175,117,201,-1,208,126,125,-1,209,126,208,-1,210,211,212,-1,211,210,176,-1,159,110,109,-1,159,158,110,-1,115,119,118,-1,174,119,115,-1,128,176,210,-1,177,176,128,-1,26,115,118,-1,116,115,26,-1,199,204,202,-1,199,200,204,-1,213,214,215,-1,216,214,213,-1,217,218,219,-1,220,218,217,-1,137,221,156,-1,137,222,221,-1,104,223,98,-1,104,180,223,-1,224,95,225,-1,95,224,96,-1,226,189,79,-1,189,226,195,-1,36,227,184,-1,227,36,194,-1,228,38,100,-1,39,38,228,-1,101,179,40,-1,101,37,179,-1,102,97,181,-1,97,102,103,-1,229,190,94,-1,198,190,229,-1,90,1,89,-1,2,1,90,-1,226,80,198,-1,226,79,80,-1,64,34,188,-1,34,64,35,-1,99,85,183,-1,85,99,70,-1,101,42,5,-1,101,40,42,-1,107,182,230,-1,107,106,182,-1,58,191,146,-1,191,58,55,-1,80,196,192,-1,196,80,178,-1,231,198,229,-1,198,231,226,-1,178,68,196,-1,178,105,68,-1,146,232,58,-1,146,145,232,-1,233,234,186,-1,234,233,142,-1,235,74,78,-1,235,236,74,-1,78,82,235,-1,76,82,78,-1,92,77,71,-1,93,77,92,-1,232,185,237,-1,232,75,185,-1,185,108,237,-1,91,108,185,-1,194,224,227,-1,224,194,193,-1,183,100,99,-1,183,184,100,-1,223,179,39,-1,179,223,180,-1,135,64,188,-1,135,65,64,-1,58,237,56,-1,232,237,58,-1,176,169,211,-1,176,167,169,-1,173,174,175,-1,172,174,173,-1,171,238,208,-1,171,173,238,-1,167,209,170,-1,167,177,209,-1,239,112,111,-1,113,112,239,-1,238,168,170,-1,238,207,168,-1,168,111,169,-1,239,111,168,-1,205,236,235,-1,205,148,236,-1,82,151,83,-1,82,147,151,-1,165,217,216,-1,165,166,217,-1,18,120,240,-1,17,120,18,-1,241,216,213,-1,165,216,241,-1,205,242,162,-1,242,205,84,-1,242,213,31,-1,242,241,213,-1,32,121,123,-1,32,215,121,-1,157,243,130,-1,157,244,243,-1,244,138,245,-1,138,244,157,-1,139,131,136,-1,139,132,131,-1,246,133,245,-1,246,155,133,-1,137,24,222,-1,137,30,24,-1,155,247,153,-1,155,246,247,-1,153,144,154,-1,152,144,153,-1,152,247,248,-1,153,247,152,-1,248,221,220,-1,247,221,248,-1,218,24,140,-1,222,24,218,-1,158,199,212,-1,199,158,160,-1,200,249,204,-1,200,250,249,-1,210,129,128,-1,210,202,129,-1,249,251,252,-1,251,249,143,-1,236,251,253,-1,251,236,148,-1,234,134,135,-1,254,134,234,-1,142,254,234,-1,142,141,254,-1,154,146,192,-1,154,144,146,-1,243,141,250,-1,243,254,141,-1,253,143,142,-1,251,143,253,-1,204,252,203,-1,252,204,249,-1,212,202,210,-1,212,199,202,-1,250,143,249,-1,250,141,143,-1,130,250,200,-1,130,243,250,-1,26,240,140,-1,18,240,26,-1,219,140,240,-1,219,218,140,-1,166,220,217,-1,166,248,220,-1,151,248,166,-1,151,152,248,-1,156,247,246,-1,156,221,247,-1,133,68,65,-1,155,68,133,-1,28,131,159,-1,136,131,28,-1,157,139,138,-1,139,157,132,-1,245,134,244,-1,245,133,134,-1,244,254,243,-1,244,134,254,-1,206,124,21,-1,206,125,124,-1,31,162,242,-1,33,162,31,-1,162,33,163,-1,203,150,11,-1,203,252,150,-1,84,241,242,-1,84,83,241,-1,165,83,151,-1,165,241,83,-1,120,215,214,-1,120,121,215,-1,240,214,219,-1,120,214,240,-1,84,235,82,-1,84,205,235,-1,207,239,168,-1,201,239,207,-1,239,114,113,-1,114,239,201,-1,208,170,209,-1,208,238,170,-1,110,169,111,-1,211,169,110,-1,237,107,56,-1,237,108,107,-1,49,187,85,-1,187,49,86,-1,188,234,135,-1,186,234,188,-1,225,39,228,-1,225,223,39,-1,47,182,181,-1,230,182,47,-1,227,225,228,-1,227,224,225,-1,46,230,47,-1,46,57,230,-1,96,229,45,-1,231,229,96,-1,42,89,5,-1,92,89,42,-1,108,60,106,-1,91,60,108,-1,75,93,185,-1,77,93,75,-1,76,147,82,-1,76,145,147,-1,253,74,236,-1,74,253,72,-1,72,142,233,-1,72,253,142,-1,88,186,86,-1,186,88,233,-1,156,245,138,-1,156,246,245,-1,145,75,232,-1,145,76,75,-1,71,78,74,-1,77,78,71,-1,73,233,88,-1,73,72,233,-1,10,69,52,-1,69,10,4,-1,68,67,63,-1,67,68,105,-1,63,44,64,-1,67,44,63,-1,56,230,57,-1,56,107,230,-1,53,70,99,-1,70,53,52,-1,197,88,87,-1,197,51,88,-1,1,3,89,-1,1,7,3,-1,45,94,46,-1,229,94,45,-1,184,228,100,-1,228,184,227,-1,231,195,226,-1,231,193,195,-1,193,96,224,-1,193,231,96,-1,225,98,223,-1,98,225,95,-1,180,41,40,-1,41,180,104,-1,220,222,218,-1,221,222,220,-1,216,219,214,-1,217,219,216,-1,31,215,32,-1,213,215,31,-1,172,206,164,-1,172,171,206,-1,164,174,172,-1,164,119,174,-1,109,28,159,-1,29,28,109,-1,212,110,158,-1,110,212,211,-1,209,128,126,-1,177,128,209,-1,171,125,206,-1,208,125,171,-1,175,238,173,-1,238,175,207,-1,33,20,23,-1,20,33,123,-1,161,23,149,-1,161,163,23,-1,15,123,16,-1,15,20,123,-1,148,252,251,-1,150,252,148,-1,129,11,127,-1,129,203,11,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfprox_Coord',point=[(-2.57836,.3523,2.96568),(-2.48823,.41219,2.97327),(-2.51073,.39016,2.93257),(-2.49402,.39264,3.02007),(-2.55893,.32162,3.03881),(-2.46019,.44112,3.04757),(-2.57417,.33302,3.0148),(-2.51586,.39435,3.00638),(-2.57647,.25094,2.99011),(-2.58705,.27636,2.98523),(-2.56402,.32785,3.08097),(-2.32788,.62446,2.26746),(-2.24838,.62725,2.27257),(-2.20875,.62594,2.23445),(-1.97773,.44421,1.9877),(-1.99139,.527,2.04038),(-1.99433,.51401,2.04858),(-1.96825,.43523,2.00712),(-1.98561,.32758,1.96402),(-1.98358,.44431,1.978),(-2.07487,.60347,2.12843),(-2.08546,.60485,2.11196),(-2.0029,.52721,2.02947),(-2.20696,.62552,2.27584),(-2.16529,.19315,1.97853),(-2.17913,.23712,1.96656),(-2.04085,.28469,1.92861),(-2.3,.21391,1.9672),(-2.43343,.19446,1.99111),(-2.43128,.20545,1.98607),(-2.29846,.20375,1.96867),(-2.1058,.51998,2.24746),(-2.08555,.55788,2.19722),(-2.18853,.60052,2.26979),(-2.50908,.20684,2.7738),(-2.44454,.18514,2.76997),(-2.46794,.15777,2.80606),(-2.4774,.34359,3.09829),(-2.50096,.23063,3.0694),(-2.41273,.24405,3.07392),(-2.34684,.41482,3.03476),(-2.32202,.40734,3.03808),(-2.33474,.42636,3.01127),(-2.38626,.18159,2.84645),(-2.37062,.21341,2.7902),(-2.24077,.13871,2.92033),(-2.15946,.09803,2.9007),(-2.16911,.11126,2.99847),(-2.2446,.1612,3.0036),(-2.5748,.22471,2.92619),(-2.58261,.26419,2.94307),(-2.55568,.34992,2.89982),(-2.59314,.21836,3.05049),(-2.58376,.21151,3.0593),(-2.55417,.3231,3.08727),(-2.09689,.12932,2.84385),(-2.07007,.11002,2.89271),(-2.08446,.0962,2.89059),(-2.08219,.14572,2.85083),(-2.21539,.3696,3.07056),(-2.12744,.29723,3.09029),(-2.20915,.37509,3.05353),(-2.14193,.28864,3.10117),(-2.38814,.20285,2.68807),(-2.43771,.20059,2.76448),(-2.4293,.20921,2.63753),(-2.29727,.22783,2.81179),(-2.34256,.21534,2.74993),(-2.29208,.21775,2.66216),(-2.58717,.2238,2.9978),(-2.5884,.14726,2.95605),(-2.34524,.41551,2.90942),(-2.45425,.40196,2.84569),(-2.46428,.41165,2.91007),(-2.3514,.41941,2.84784),(-2.11308,.31541,2.89716),(-2.12841,.31165,2.83612),(-2.22414,.36851,2.90412),(-2.22582,.37127,2.84313),(-2.29243,.21162,2.84499),(-2.23436,.19185,2.80949),(-2.52574,.17129,2.81303),(-2.14057,.34694,2.66671),(-2.11918,.36722,2.48405),(-2.14259,.40071,2.49524),(-2.55577,.1548,2.87129),(-2.55416,.25695,2.86631),(-2.55636,.27253,2.88434),(-2.54168,.34527,2.87137),(-2.45786,.42016,2.97401),(-2.4885,.39182,2.91872),(-2.11191,.30576,3.05799),(-2.33926,.41162,2.97099),(-2.22261,.36579,2.9651),(-2.16633,.11842,2.8503),(-2.31147,.18794,3.00608),(-2.30952,.18238,2.94145),(-2.25581,.21492,3.08852),(-2.31855,.25392,3.07499),(-2.5768,.13669,2.96117),(-2.50269,.13742,2.96891),(-2.45312,.43175,3.06061),(-2.1925,.32066,3.09695),(-2.25795,.3386,3.09578),(-2.3239,.35405,3.07046),(-2.29454,.22279,2.73698),(-2.0687,.1831,3.06979),(-2.06862,.11638,2.99771),(-2.05764,.20523,3.0342),(-2.51847,.258,1.99185),(-2.59631,.35884,2.03123),(-2.41813,.33725,2.07219),(-2.40989,.26463,2.02103),(-2.28237,.24418,2.00675),(-2.17876,.2537,1.97009),(-2.02354,.34384,1.93996),(-2.05275,.29129,1.92977),(-2.14831,.32511,2.02693),(-2.00798,.34162,1.93965),(-1.99531,.44446,1.95861),(-1.94937,.41723,2.04596),(-1.99964,.50471,2.08955),(-2.33308,.59674,2.33817),(-2.08325,.58399,2.15046),(-2.21074,.6346,2.15707),(-2.20915,.65023,2.11183),(-2.29927,.64936,2.14054),(-2.30994,.64746,2.1694),(-2.43609,.64029,2.16065),(-2.43495,.62841,2.1938),(-2.59497,.35988,2.18717),(-2.53907,.22574,2.07484),(-2.5451,.19532,2.14511),(-2.41918,.19571,2.42898),(-2.49208,.23398,2.44816),(-2.49376,.22611,2.63438),(-2.4433,.1765,2.06351),(-2.2936,.16439,2.05598),(-2.45247,.16843,2.16794),(-2.46685,.1527,2.12432),(-2.02005,.23403,1.98538),(-2.51552,.37786,2.48788),(-2.51139,.35099,2.68984),(-2.48824,.41699,2.4989),(-2.10095,.19519,2.6264),(-2.08098,.22497,2.82333),(-2.09631,.17888,2.79864),(-2.09488,.23913,2.6348),(-2.34663,.50093,2.51832),(-2.32436,.56911,2.38833),(-2.365,.56637,2.37115),(-2.06843,.2577,2.44854),(-2.09383,.20781,2.43814),(-2.15471,.19101,2.44037),(-2.1692,.16982,2.64299),(-2.29485,.1973,2.43497),(-2.29494,.17211,2.14394),(-2.53231,.20972,2.19531),(-2.60483,.35388,2.03665),(-2.52939,.25196,1.99628),(-2.60022,.35831,2.10724),(-2.29514,.55706,2.38279),(-2.23106,.54167,2.37039),(-2.2155,.59496,2.30555),(-2.00073,.52963,2.00387),(-2.02604,.29738,2.27402),(-2.01762,.26775,2.2521),(-2.42836,.54792,2.14615),(-2.26828,.44777,2.11408),(-2.4276,.46417,2.11946),(-2.27575,.54845,2.12466),(-2.0964,.6153,2.0744),(-2.01194,.5332,2.00363),(-2.11546,.54247,2.08196),(-2.00997,.44637,1.95906),(-2.12532,.43533,2.05932),(-2.56074,.55612,2.10437),(-2.43292,.63343,2.1491),(-2.2551,.2015,2.76231),(-2.401,.34523,3.07856),(-2.34717,.35135,3.07113),(-2.16918,.18343,3.08378),(-2.08332,.17544,3.0767),(-2.5423,.14221,2.8707),(-2.49001,.14117,2.87683),(-2.10507,.3124,2.95836),(-2.54282,.2714,2.79772),(-2.53738,.19555,2.826),(-2.51695,.23297,2.76897),(-2.31488,.21531,2.84238),(-2.17566,.15007,2.81241),(-2.10721,.15923,2.80947),(-2.17691,.15946,2.80151),(-2.32449,.19545,2.90074),(-2.38742,.17425,2.85634),(-2.3228,.19922,2.89035),(-2.21317,.17521,2.71282),(-2.56728,.29457,2.90701),(-2.23895,.16713,2.86446),(-2.59865,.46509,2.13605),(-2.58401,.44726,2.21537),(-2.19142,.32609,2.04346),(-2.55616,.53612,2.16834),(-2.43264,.6025,2.26596),(-2.54439,.50894,2.23219),(-2.23733,.47184,2.51693),(-2.09211,.62047,2.08171),(-2.19666,.44155,2.08669),(-2.21246,.64366,2.10375),(-2.3022,.64093,2.13101),(-2.56868,.55741,2.11237),(-2.60377,.47992,2.05905),(-2.61231,.4788,2.06565),(-2.04846,.43477,2.22526),(-1.95814,.36877,2.12589),(-2.01384,.47267,2.16195),(-1.98952,.337,2.19661),(-1.98716,.26503,2.17024),(-2.01326,.20212,2.08342),(-1.95706,.26924,2.09922),(-2.03072,.20734,2.15896),(-2.15644,.17102,2.14499),(-2.15566,.16095,2.06184),(-2.34421,.25586,3.07317),(-2.33189,.18434,2.93986),(-2.33579,.1893,3.00431),(-2.30113,.19684,2.89248),(-2.40308,.1604,2.90912),(-2.40829,.15761,2.98093),(-2.2401,.15867,2.87914),(-2.08302,.10529,3.00143),(-2.30342,.19304,2.90378),(-2.06528,.20853,2.88088),(-2.52861,.34178,2.82055),(-2.52703,.28602,2.6702),(-2.23994,.41053,2.68969),(-2.35591,.44419,2.69693),(-2.05466,.19192,2.93859),(-2.19545,.54547,2.10331),(-2.26819,.32781,2.07284),(-1.95675,.29953,2.01823),(-2.08443,.38851,2.31058),(-2.13426,.4609,2.3367),(-2.54757,.33405,2.32266),(-2.51967,.22258,2.29396),(-2.43843,.17654,2.27062),(-2.29661,.17983,2.23188),(-2.15752,.1811,2.22812),(-2.04844,.21257,2.2345),(-2.51348,.46146,2.35664),(-2.54149,.40585,2.34712),(-2.43131,.47907,2.50928),(-2.42537,.54741,2.3704),(-2.45662,.42109,2.69682),(-2.51867,.30657,2.46745)]))),
        Shape(DEF='rfpprox2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfpprox2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,22,23,24,-1,25,24,23,-1,23,26,25,-1,27,23,28,-1,29,30,31,-1,32,33,34,-1,11,35,36,-1,0,2,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,44,47,48,-1,49,50,51,-1,52,50,53,-1,54,50,55,-1,56,57,58,-1,58,49,56,-1,59,60,5,-1,60,61,5,-1,3,62,4,-1,63,64,65,-1,65,66,63,-1,67,68,69,-1,69,70,67,-1,71,72,73,-1,72,74,73,-1,41,43,0,-1,75,37,76,-1,75,77,37,-1,78,79,80,-1,80,12,78,-1,22,81,82,-1,83,84,85,-1,85,86,83,-1,87,14,88,-1,87,89,14,-1,90,91,92,-1,91,93,92,-1,41,80,94,-1,41,77,80,-1,95,96,76,-1,96,97,76,-1,98,29,99,-1,40,39,100,-1,57,55,58,-1,57,101,55,-1,102,45,103,-1,63,45,64,-1,47,44,46,-1,104,45,105,-1,106,107,6,-1,70,108,67,-1,109,110,73,-1,111,112,113,-1,112,35,113,-1,114,10,9,-1,113,35,115,-1,116,117,118,-1,119,120,121,-1,120,122,121,-1,11,115,35,-1,17,123,19,-1,123,20,19,-1,73,110,71,-1,116,118,73,-1,124,110,125,-1,124,71,110,-1,71,124,70,-1,126,67,127,-1,6,107,85,-1,85,84,6,-1,68,128,129,-1,68,130,128,-1,128,131,129,-1,131,132,129,-1,72,133,134,-1,135,133,136,-1,135,134,133,-1,46,45,104,-1,48,64,44,-1,103,45,63,-1,105,45,102,-1,66,81,22,-1,22,24,66,-1,3,5,137,-1,5,138,137,-1,4,139,140,-1,4,141,139,-1,32,30,98,-1,1,38,40,-1,141,62,142,-1,141,4,62,-1,41,0,37,-1,37,77,41,-1,66,143,81,-1,66,65,143,-1,47,80,48,-1,80,79,48,-1,13,144,145,-1,146,147,148,-1,147,97,148,-1,108,70,124,-1,81,143,78,-1,78,82,81,-1,27,149,62,-1,41,94,150,-1,68,67,126,-1,126,130,68,-1,9,11,116,-1,11,117,116,-1,64,48,65,-1,58,50,49,-1,79,143,65,-1,65,48,79,-1,98,99,47,-1,47,46,98,-1,1,40,2,-1,40,151,2,-1,59,5,4,-1,55,50,58,-1,53,50,54,-1,51,50,52,-1,143,79,78,-1,152,51,153,-1,64,45,44,-1,30,29,98,-1,150,42,41,-1,80,47,94,-1,109,73,118,-1,154,107,106,-1,39,38,31,-1,155,100,34,-1,23,138,26,-1,23,137,138,-1,23,22,28,-1,23,27,137,-1,11,10,115,-1,146,91,156,-1,133,72,69,-1,47,99,94,-1,156,90,157,-1,156,91,90,-1,158,159,160,-1,158,161,159,-1,14,145,88,-1,14,13,145,-1,162,163,164,-1,163,162,165,-1,166,22,82,-1,28,22,166,-1,165,138,167,-1,26,138,165,-1,34,168,155,-1,163,168,34,-1,34,39,31,-1,34,100,39,-1,118,169,109,-1,169,118,86,-1,107,170,85,-1,107,154,170,-1,40,155,171,-1,100,155,40,-1,31,150,29,-1,150,31,42,-1,153,52,139,-1,153,51,52,-1,140,59,4,-1,140,172,59,-1,60,57,173,-1,101,57,60,-1,151,56,152,-1,56,151,174,-1,175,174,171,-1,173,174,175,-1,0,38,1,-1,0,43,38,-1,46,176,98,-1,176,46,104,-1,177,102,178,-1,177,105,102,-1,63,179,103,-1,66,179,63,-1,171,151,40,-1,151,171,174,-1,116,74,9,-1,116,73,74,-1,83,11,36,-1,11,83,117,-1,180,6,84,-1,180,7,6,-1,130,106,181,-1,130,126,106,-1,62,95,142,-1,95,62,149,-1,182,124,125,-1,182,108,124,-1,148,96,183,-1,148,97,96,-1,13,146,144,-1,13,147,146,-1,184,121,185,-1,121,184,119,-1,186,187,188,-1,187,186,189,-1,18,190,16,-1,18,191,190,-1,120,19,192,-1,120,193,19,-1,189,122,194,-1,189,186,122,-1,160,92,195,-1,92,160,90,-1,78,14,89,-1,12,14,78,-1,82,89,184,-1,78,89,82,-1,82,185,166,-1,82,184,185,-1,166,196,149,-1,166,185,196,-1,141,37,2,-1,141,142,37,-1,153,141,2,-1,141,153,139,-1,54,140,53,-1,172,140,54,-1,155,175,171,-1,175,155,168,-1,167,5,61,-1,5,167,138,-1,137,62,3,-1,62,137,27,-1,66,25,179,-1,25,66,24,-1,178,164,177,-1,164,178,162,-1,16,111,113,-1,190,111,16,-1,159,190,157,-1,111,190,159,-1,112,7,180,-1,112,161,7,-1,194,135,136,-1,192,135,194,-1,188,197,186,-1,188,183,197,-1,132,194,136,-1,132,189,194,-1,195,187,131,-1,195,92,187,-1,129,136,133,-1,129,132,136,-1,158,195,198,-1,158,160,195,-1,198,131,128,-1,198,195,131,-1,128,181,198,-1,181,128,130,-1,106,127,154,-1,106,126,127,-1,127,108,182,-1,67,108,127,-1,110,169,125,-1,110,109,169,-1,119,193,120,-1,119,87,193,-1,135,199,134,-1,135,21,199,-1,199,9,74,-1,199,114,9,-1,87,15,193,-1,87,88,15,-1,97,75,76,-1,97,147,75,-1,86,117,83,-1,86,118,117,-1,20,10,114,-1,10,20,123,-1,192,21,135,-1,192,19,21,-1,72,199,74,-1,72,134,199,-1,180,35,112,-1,180,36,35,-1,182,154,127,-1,170,154,182,-1,198,8,158,-1,8,198,181,-1,68,133,69,-1,68,129,133,-1,189,131,187,-1,131,189,132,-1,93,183,188,-1,183,93,148,-1,121,186,197,-1,121,122,186,-1,111,161,112,-1,111,159,161,-1,144,156,191,-1,144,146,156,-1,177,33,176,-1,33,177,164,-1,25,178,179,-1,178,25,162,-1,61,168,167,-1,61,175,168,-1,152,49,51,-1,56,49,152,-1,54,101,172,-1,101,54,55,-1,152,2,151,-1,153,2,152,-1,96,149,196,-1,96,95,149,-1,147,12,75,-1,147,13,12,-1,145,191,18,-1,144,191,145,-1,93,146,148,-1,93,91,146,-1,122,192,194,-1,122,120,192,-1,193,17,19,-1,193,15,17,-1,191,157,190,-1,191,156,157,-1,92,188,187,-1,92,93,188,-1,185,197,196,-1,197,185,121,-1,184,87,119,-1,184,89,87,-1,183,196,197,-1,183,96,196,-1,125,170,182,-1,169,170,125,-1,75,80,77,-1,12,80,75,-1,142,76,37,-1,76,142,95,-1,71,69,72,-1,70,69,71,-1,8,106,6,-1,8,181,106,-1,84,36,180,-1,84,83,36,-1,29,94,99,-1,29,150,94,-1,178,103,179,-1,178,102,103,-1,104,177,176,-1,104,105,177,-1,61,173,175,-1,60,173,61,-1,173,56,174,-1,57,56,173,-1,172,60,59,-1,172,101,60,-1,139,53,140,-1,139,52,53,-1,43,31,38,-1,43,42,31,-1,33,98,176,-1,32,98,33,-1,170,86,85,-1,170,169,86,-1,164,34,33,-1,34,164,163,-1,30,34,31,-1,30,32,34,-1,167,163,165,-1,167,168,163,-1,149,28,166,-1,149,27,28,-1,26,162,25,-1,165,162,26,-1,199,20,114,-1,21,20,199,-1,17,113,123,-1,16,113,17,-1,115,123,113,-1,115,10,123,-1,88,18,15,-1,88,145,18,-1,161,8,7,-1,8,161,158,-1,160,157,90,-1,157,160,159,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfpprox2_Coord',point=[(-3.25653,.17135,2.76181),(-3.26667,.15636,2.77787),(-3.28237,.17695,2.75895),(-3.28236,.30402,2.79473),(-3.28949,.27866,2.78615),(-3.29615,.27851,2.89454),(-3.10365,.35413,1.91383),(-3.09176,.33292,1.94167),(-3.12671,.34304,1.9217),(-2.80901,.49828,2.02536),(-2.86627,.41346,2.12782),(-2.85763,.4324,2.0237),(-3.09573,.286,2.61283),(-3.09656,.30283,2.53541),(-3.08728,.31527,2.53902),(-3.024,.35889,2.36579),(-3.00352,.35708,2.27361),(-2.98266,.37968,2.2998),(-3.04002,.33432,2.35462),(-2.98857,.44237,2.32833),(-2.93389,.43117,2.24535),(-2.95218,.47253,2.26014),(-3.09971,.35733,2.70444),(-3.18655,.33306,2.8045),(-3.1228,.32785,2.81141),(-3.1226,.30602,2.87982),(-3.18419,.29485,2.88265),(-3.23015,.34561,2.70253),(-3.17357,.37192,2.70713),(-3.12897,.1819,2.81812),(-3.11733,.1637,2.83381),(-3.17162,.18484,2.83168),(-3.12058,.14389,2.87447),(-3.11083,.13911,2.91765),(-3.17595,.15232,2.90504),(-2.91935,.38745,2.07567),(-2.9146,.39253,2.00536),(-3.24862,.22945,2.67911),(-3.21721,.16491,2.81649),(-3.22001,.14689,2.83045),(-3.27157,.10891,2.82921),(-3.16823,.21444,2.77444),(-3.1736,.19547,2.80416),(-3.21378,.17772,2.79468),(-3.0438,.21589,2.77386),(-3.02313,.2466,2.85376),(-3.04516,.15421,2.83458),(-3.06799,.2141,2.7609),(-3.03491,.28804,2.75068),(-3.31922,.18301,2.86439),(-3.32337,.20205,2.86041),(-3.31557,.18906,2.84949),(-3.31844,.20672,2.84362),(-3.31974,.21493,2.8496),(-3.32061,.22031,2.86366),(-3.32254,.21128,2.87861),(-3.31276,.14904,2.87738),(-3.31874,.18673,2.90257),(-3.32445,.19521,2.87872),(-3.31389,.26709,2.88275),(-3.32582,.22746,2.9313),(-3.30936,.23099,2.94572),(-3.25885,.33204,2.70015),(-3.0391,.30947,2.81904),(-3.02821,.29232,2.76542),(-3.03584,.3148,2.75048),(-3.05705,.32266,2.8183),(-3.21712,.61948,2.06565),(-3.22973,.62151,2.0755),(-3.12507,.66637,2.14057),(-3.12201,.66421,2.12916),(-2.98016,.68117,2.11436),(-2.97647,.68514,2.12593),(-2.82546,.59367,2.02166),(-2.82224,.59015,2.03936),(-3.16761,.26535,2.60648),(-3.22465,.26909,2.60293),(-3.17389,.24614,2.69039),(-3.06498,.34589,2.62294),(-3.06265,.3116,2.6902),(-3.1003,.27204,2.68991),(-3.07175,.35179,2.70341),(-3.08059,.39477,2.63723),(-2.91534,.40194,1.99493),(-2.98456,.39215,1.98872),(-2.98235,.41941,1.97433),(-2.91463,.45582,1.98365),(-3.04409,.38681,2.47378),(-3.05527,.33953,2.45546),(-3.05313,.36537,2.55279),(-3.14073,.33812,2.21045),(-3.13997,.32419,2.32639),(-3.1808,.36918,2.20732),(-3.1843,.34218,2.32408),(-3.09803,.20229,2.7647),(-3.25594,.3073,2.61227),(-3.23356,.33293,2.53097),(-3.21141,.29235,2.52169),(-3.06119,.14254,2.83593),(-3.08095,.19034,2.78113),(-3.22033,.12708,2.87111),(-3.32525,.21819,2.90144),(-3.0333,.26683,2.91699),(-3.03648,.29966,2.87236),(-3.02749,.14342,2.91615),(-3.02587,.19117,2.95018),(-3.16127,.41716,1.88725),(-3.11512,.38989,1.91464),(-3.10987,.62605,2.09725),(-2.86928,.5207,1.99592),(-2.8905,.57431,2.0198),(-3.0229,.37587,2.16607),(-2.99315,.37236,2.04676),(-2.96364,.37839,2.20311),(-2.86366,.45074,2.1572),(-2.88652,.39274,2.09987),(-2.8122,.50441,2.00981),(-2.85995,.44385,2.01207),(-2.86402,.49896,1.99415),(-3.07936,.46695,2.4925),(-3.06606,.49456,2.41534),(-3.15171,.48244,2.48634),(-3.14229,.53029,2.408),(-2.93351,.40399,2.22657),(-3.06288,.64992,2.10532),(-2.96943,.54462,2.02837),(-3.20798,.51714,1.95306),(-3.16994,.52368,1.98557),(-3.23557,.49589,2.06104),(-3.21033,.60045,2.1397),(-3.22299,.5088,1.95765),(-3.218,.46848,2.13798),(-3.20486,.56889,2.22191),(-3.12635,.64378,2.19301),(-3.00277,.60996,2.20567),(-3.0265,.55941,2.27964),(-3.12267,.60564,2.27095),(-3.23331,.31908,2.80054),(-3.2401,.28901,2.88994),(-3.30847,.21627,2.80382),(-3.30693,.24484,2.81925),(-3.30292,.22788,2.75576),(-3.27036,.2721,2.69092),(-3.05467,.33333,2.69477),(-3.08468,.31538,2.44006),(-3.07131,.31591,2.44256),(-3.14702,.30127,2.42412),(-3.16102,.28457,2.52255),(-3.1993,.31757,2.42292),(-3.23949,.37187,2.62655),(-3.13785,.19317,2.79614),(-3.28992,.11966,2.83236),(-3.30438,.15656,2.84232),(-3.3009,.18521,2.80562),(-3.11915,.41915,1.91997),(-3.23144,.12326,2.9064),(-3.12163,.32238,2.32971),(-3.11198,.33458,2.21813),(-3.13004,.32259,1.98978),(-3.11075,.33519,2.10808),(-3.13797,.33964,2.10893),(-3.10378,.31842,1.99245),(-3.12007,.26825,2.93247),(-3.1778,.19735,2.9384),(-3.10898,.1897,2.95931),(-3.17987,.26099,2.92657),(-3.16578,.40105,2.63439),(-3.24328,.24714,2.94123),(-3.23198,.18376,2.9502),(-2.92691,.47633,1.98583),(-2.99271,.44115,1.97564),(-3.29282,.10125,2.89983),(-3.31802,.24047,2.87213),(-3.31517,.17579,2.93301),(-3.30816,.111,2.89124),(-3.29875,.17287,2.94564),(-3.04111,.13295,2.92232),(-3.04347,.18477,2.96385),(-3.05495,.27317,2.92818),(-3.05489,.31253,2.8743),(-2.98443,.38097,2.00014),(-3.17955,.40561,1.89294),(-3.04753,.52476,2.02443),(-3.22183,.36541,2.43172),(-3.0809,.43084,2.569),(-3.15981,.43467,2.56445),(-3.19332,.50404,2.37827),(-3.21413,.43763,2.22299),(-3.20776,.39789,2.33246),(-3.19959,.53646,2.30009),(-3.03865,.35799,2.24625),(-3.05821,.33507,2.34916),(-3.04704,.52306,2.34548),(-3.02038,.41041,2.39829),(-3.13181,.57574,2.32997),(-3.18092,.37858,2.1106),(-3.21982,.41173,2.55293),(-3.20757,.45787,2.46561),(-3.1926,.38603,1.98234),(-2.89968,.51505,2.17997)]))),
        Shape(DEF='rfpprox3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfpprox3_Geo',coordIndex=[0,1,2,-1,1,3,2,-1,4,5,6,-1,7,8,9,-1,10,11,12,-1,11,13,12,-1,14,11,15,-1,14,16,11,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,39,42,40,-1,43,44,45,-1,44,46,45,-1,37,47,28,-1,48,49,47,-1,20,50,51,-1,20,22,50,-1,39,52,53,-1,54,55,56,-1,56,57,54,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,65,66,67,-1,67,68,65,-1,69,70,71,-1,72,73,74,-1,75,76,71,-1,62,77,78,-1,79,80,81,-1,79,82,80,-1,83,84,85,-1,83,86,84,-1,87,88,89,-1,87,90,88,-1,91,92,93,-1,94,95,96,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,103,105,104,-1,106,107,60,-1,62,65,68,-1,108,109,27,-1,110,111,112,-1,44,113,46,-1,114,115,116,-1,117,118,119,-1,118,120,119,-1,121,122,123,-1,122,120,123,-1,123,120,124,-1,125,126,127,-1,23,128,129,-1,130,38,109,-1,131,132,133,-1,1,31,30,-1,30,3,1,-1,71,134,56,-1,71,135,69,-1,136,137,71,-1,138,139,62,-1,62,68,63,-1,139,10,12,-1,139,138,10,-1,140,19,85,-1,19,83,85,-1,140,141,57,-1,60,107,58,-1,67,59,61,-1,67,142,59,-1,103,102,143,-1,143,6,103,-1,102,144,145,-1,96,95,146,-1,147,148,5,-1,148,101,5,-1,149,150,151,-1,150,73,151,-1,152,54,153,-1,153,74,152,-1,154,9,94,-1,9,155,94,-1,98,154,96,-1,154,94,96,-1,78,65,62,-1,138,62,64,-1,71,137,156,-1,70,75,71,-1,71,55,135,-1,134,71,156,-1,3,157,18,-1,3,30,157,-1,90,158,88,-1,129,159,23,-1,159,24,23,-1,160,24,159,-1,160,161,24,-1,162,99,121,-1,99,122,121,-1,163,164,165,-1,164,163,166,-1,163,100,166,-1,167,100,163,-1,167,101,100,-1,89,168,87,-1,89,157,168,-1,122,101,148,-1,122,99,101,-1,169,170,40,-1,40,171,169,-1,31,172,29,-1,85,141,140,-1,120,148,119,-1,120,122,148,-1,71,76,136,-1,173,77,62,-1,102,104,144,-1,174,175,176,-1,153,177,74,-1,177,72,74,-1,145,143,102,-1,145,175,143,-1,106,84,86,-1,86,14,106,-1,178,158,179,-1,178,88,158,-1,180,97,181,-1,181,79,180,-1,182,183,184,-1,184,185,182,-1,185,151,80,-1,80,82,185,-1,169,8,13,-1,169,117,8,-1,55,54,152,-1,152,135,55,-1,77,173,97,-1,173,98,97,-1,186,98,173,-1,186,154,98,-1,141,54,57,-1,141,153,54,-1,56,55,71,-1,123,187,121,-1,28,115,26,-1,130,36,38,-1,188,34,189,-1,41,40,170,-1,114,26,115,-1,28,38,37,-1,86,190,14,-1,190,16,14,-1,15,11,10,-1,9,8,155,-1,8,191,155,-1,105,1,0,-1,105,192,1,-1,103,192,105,-1,155,147,193,-1,155,191,147,-1,194,86,83,-1,194,190,86,-1,160,109,108,-1,160,159,109,-1,195,132,131,-1,196,132,195,-1,91,110,92,-1,110,91,111,-1,53,34,127,-1,53,189,34,-1,197,51,50,-1,113,51,197,-1,44,198,199,-1,43,198,44,-1,36,200,37,-1,200,36,201,-1,202,92,110,-1,202,203,92,-1,33,127,34,-1,33,125,127,-1,165,204,128,-1,165,164,204,-1,121,205,206,-1,187,205,121,-1,162,206,207,-1,206,162,121,-1,133,160,131,-1,160,133,161,-1,116,112,114,-1,116,208,112,-1,209,210,188,-1,210,209,211,-1,52,158,203,-1,52,179,158,-1,210,212,35,-1,210,213,212,-1,49,116,115,-1,116,49,211,-1,108,26,195,-1,27,26,108,-1,212,113,197,-1,113,212,46,-1,123,21,187,-1,124,21,123,-1,214,22,215,-1,214,126,22,-1,107,10,138,-1,107,15,10,-1,180,77,97,-1,77,180,78,-1,138,58,107,-1,138,64,58,-1,17,140,134,-1,140,17,19,-1,136,104,137,-1,136,144,104,-1,75,149,184,-1,70,149,75,-1,150,135,152,-1,135,150,69,-1,144,76,183,-1,136,76,144,-1,7,139,12,-1,7,186,139,-1,118,169,171,-1,118,117,169,-1,181,82,79,-1,181,176,82,-1,178,190,88,-1,16,190,178,-1,106,216,84,-1,60,216,106,-1,72,59,142,-1,72,177,59,-1,174,95,217,-1,95,174,146,-1,175,182,176,-1,182,175,145,-1,73,80,151,-1,73,72,80,-1,216,153,141,-1,216,177,153,-1,4,143,217,-1,143,4,6,-1,175,217,143,-1,175,174,217,-1,145,183,182,-1,145,144,183,-1,100,162,166,-1,100,99,162,-1,147,119,148,-1,119,147,191,-1,163,31,167,-1,31,163,172,-1,188,218,209,-1,188,189,218,-1,43,48,219,-1,43,45,48,-1,40,214,171,-1,40,42,214,-1,29,25,24,-1,29,172,25,-1,172,165,25,-1,172,163,165,-1,207,198,220,-1,198,207,206,-1,128,201,129,-1,201,128,204,-1,32,24,161,-1,32,29,24,-1,41,178,179,-1,170,178,41,-1,132,93,133,-1,132,91,93,-1,39,179,52,-1,41,179,39,-1,0,156,137,-1,0,2,156,-1,62,186,173,-1,62,139,186,-1,119,8,117,-1,8,119,191,-1,89,18,157,-1,89,194,18,-1,192,101,167,-1,192,5,101,-1,149,185,184,-1,149,151,185,-1,180,81,66,-1,81,180,79,-1,217,193,4,-1,95,193,217,-1,152,73,150,-1,152,74,73,-1,106,15,107,-1,15,106,14,-1,170,16,178,-1,170,11,16,-1,169,11,170,-1,169,13,11,-1,134,2,17,-1,156,2,134,-1,203,90,92,-1,158,90,203,-1,32,157,30,-1,157,32,168,-1,199,20,51,-1,199,205,20,-1,118,124,120,-1,124,118,215,-1,206,199,198,-1,205,199,206,-1,27,38,28,-1,27,109,38,-1,211,213,210,-1,211,49,213,-1,197,35,212,-1,35,197,33,-1,110,208,202,-1,110,112,208,-1,196,26,114,-1,195,26,196,-1,81,67,66,-1,142,67,81,-1,1,167,31,-1,1,192,167,-1,155,95,94,-1,155,193,95,-1,220,221,207,-1,220,200,221,-1,96,181,97,-1,146,181,96,-1,93,168,133,-1,93,87,168,-1,92,87,93,-1,92,90,87,-1,88,194,89,-1,88,190,194,-1,84,141,85,-1,84,216,141,-1,185,176,182,-1,185,82,176,-1,146,176,181,-1,146,174,176,-1,80,142,81,-1,80,72,142,-1,177,60,59,-1,177,216,60,-1,126,50,22,-1,125,50,126,-1,171,215,118,-1,214,215,171,-1,70,150,149,-1,69,150,70,-1,76,184,183,-1,75,184,76,-1,140,56,134,-1,56,140,57,-1,105,137,104,-1,137,105,0,-1,66,78,180,-1,78,66,65,-1,63,67,61,-1,68,67,63,-1,186,9,154,-1,186,7,9,-1,61,64,63,-1,64,61,58,-1,126,42,127,-1,42,126,214,-1,21,215,22,-1,215,21,124,-1,219,47,37,-1,219,48,47,-1,49,45,213,-1,45,49,48,-1,47,115,28,-1,47,49,115,-1,202,209,218,-1,208,209,202,-1,213,46,212,-1,45,46,213,-1,127,39,53,-1,127,42,39,-1,200,204,221,-1,204,200,201,-1,35,188,210,-1,35,34,188,-1,211,208,116,-1,211,209,208,-1,114,111,196,-1,114,112,111,-1,161,168,32,-1,161,133,168,-1,164,221,204,-1,164,166,221,-1,205,21,20,-1,205,187,21,-1,207,166,162,-1,207,221,166,-1,128,25,165,-1,23,25,128,-1,200,219,37,-1,200,220,219,-1,52,189,53,-1,218,189,52,-1,130,159,129,-1,159,130,109,-1,220,43,219,-1,220,198,43,-1,51,44,199,-1,44,51,113,-1,125,197,50,-1,197,125,33,-1,203,218,52,-1,218,203,202,-1,196,91,132,-1,111,91,196,-1,108,131,160,-1,195,131,108,-1,36,129,201,-1,36,130,129,-1,18,83,19,-1,18,194,83,-1,8,12,13,-1,12,8,7,-1,4,147,5,-1,193,147,4,-1,103,5,192,-1,6,5,103,-1,17,3,18,-1,2,3,17,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfpprox3_Coord',point=[(-3.59958,.26349,2.43702),(-3.60085,.2924,2.36526),(-3.59902,.29066,2.45417),(-3.60535,.31622,2.37978),(-3.67393,.24228,2.41261),(-3.66251,.27162,2.34211),(-3.66004,.2447,2.41734),(-3.76588,.25192,2.3715),(-3.75561,.27798,2.30619),(-3.7646,.24268,2.36716),(-3.76218,.31972,2.42792),(-3.74202,.34277,2.34734),(-3.76902,.28457,2.39511),(-3.75876,.31167,2.32577),(-3.72483,.33526,2.44835),(-3.75466,.32738,2.43751),(-3.71331,.35738,2.36351),(-3.61028,.32291,2.46061),(-3.617,.35354,2.38158),(-3.61519,.32679,2.4629),(-3.67628,.32288,1.7187),(-3.67692,.31395,1.73894),(-3.72706,.40603,1.73794),(-3.35487,.35135,1.80925),(-3.34805,.41808,1.84871),(-3.36919,.34642,1.8404),(-3.41882,.52724,1.81032),(-3.37494,.49276,1.78491),(-3.4396,.45905,1.77125),(-3.45834,.38969,1.9771),(-3.54756,.37885,2.15417),(-3.55612,.32573,2.15478),(-3.46689,.44439,1.98512),(-3.72276,.48877,1.72029),(-3.71261,.54798,1.79463),(-3.68979,.49224,1.75192),(-3.40003,.37777,1.7188),(-3.46781,.39393,1.72083),(-3.38754,.41265,1.74118),(-3.70777,.57487,1.88861),(-3.7452,.49051,1.96542),(-3.71364,.52132,1.97028),(-3.7362,.5251,1.87655),(-3.55821,.37701,1.69296),(-3.604,.35546,1.66611),(-3.57322,.40489,1.71301),(-3.62502,.3875,1.68106),(-3.50679,.42769,1.75287),(-3.52253,.42228,1.74496),(-3.54319,.46025,1.78242),(-3.72171,.41988,1.67254),(-3.67513,.37059,1.65685),(-3.64883,.62389,1.90576),(-3.7001,.59763,1.86751),(-3.62019,.30186,2.63985),(-3.61232,.29297,2.63642),(-3.6082,.29637,2.59602),(-3.61779,.30491,2.59526),(-3.81634,.30199,2.5604),(-3.78937,.29448,2.61899),(-3.76278,.30922,2.58125),(-3.84444,.27519,2.59468),(-3.80534,.24184,2.50345),(-3.85028,.26842,2.58256),(-3.82257,.29466,2.5494),(-3.87637,.19692,2.60962),(-3.87244,.19393,2.62051),(-3.86347,.24147,2.61659),(-3.86711,.23884,2.60415),(-3.62179,.22673,2.69229),(-3.61787,.1902,2.67901),(-3.60243,.22978,2.60992),(-3.73825,.2534,2.65468),(-3.68914,.24135,2.6836),(-3.68721,.26451,2.67238),(-3.60763,.15855,2.64002),(-3.60151,.15411,2.58807),(-3.83563,.14869,2.52481),(-3.85519,.14917,2.57077),(-3.78127,.15306,2.60512),(-3.73534,.20503,2.65397),(-3.80312,.19519,2.64695),(-3.72238,.18333,2.62224),(-3.65156,.33577,2.46385),(-3.70632,.31858,2.54916),(-3.65808,.31787,2.55221),(-3.69213,.34527,2.46442),(-3.5243,.53212,1.99615),(-3.65134,.47281,2.14907),(-3.60234,.45447,2.15311),(-3.57976,.56907,1.98965),(-3.45604,.63035,1.87384),(-3.54106,.63267,1.90888),(-3.46069,.60058,1.90337),(-3.76315,.19829,2.43416),(-3.72508,.18479,2.45898),(-3.78147,.16415,2.47543),(-3.82755,.13919,2.52593),(-3.79522,.17683,2.4614),(-3.57597,.32012,1.92695),(-3.54,.32348,1.93526),(-3.63334,.30183,2.12925),(-3.62894,.21345,2.4933),(-3.62082,.2453,2.42489),(-3.60885,.22274,2.50078),(-3.60316,.25756,2.43303),(-3.74796,.31852,2.53392),(-3.78033,.31197,2.5277),(-3.34858,.52198,1.79553),(-3.34295,.42644,1.7517),(-3.53674,.62859,1.89246),(-3.46018,.62674,1.86202),(-3.50682,.60991,1.87471),(-3.66335,.38232,1.65514),(-3.46221,.56851,1.84251),(-3.47969,.48773,1.80502),(-3.51835,.53728,1.84036),(-3.74542,.32942,2.10955),(-3.7182,.35781,1.93058),(-3.71549,.29816,2.10848),(-3.67312,.29133,1.91307),(-3.58837,.29238,1.79673),(-3.62932,.29253,1.91578),(-3.6366,.28392,1.80277),(-3.67517,.3039,1.81628),(-3.73772,.48319,1.72387),(-3.74308,.48024,1.76238),(-3.73113,.54099,1.7975),(-3.38918,.3121,1.79304),(-3.35445,.36166,1.73185),(-3.36135,.37896,1.72543),(-3.36569,.56998,1.82936),(-3.40261,.60404,1.85006),(-3.39716,.54739,1.89403),(-3.60801,.28912,2.5478),(-3.62028,.25934,2.67855),(-3.59942,.17576,2.5519),(-3.60236,.23459,2.50875),(-3.79308,.29667,2.50852),(-3.78661,.25744,2.46447),(-3.61894,.29769,2.55285),(-3.67255,.31468,2.59855),(-3.79974,.249,2.63958),(-3.66531,.21773,2.49258),(-3.60545,.16927,2.54356),(-3.63916,.16708,2.53436),(-3.73516,.15445,2.50248),(-3.70896,.24695,2.31041),(-3.68317,.28936,2.11391),(-3.62696,.18664,2.68503),(-3.63119,.22663,2.6989),(-3.68316,.18965,2.67854),(-3.62922,.26249,2.68371),(-3.68316,.30709,2.63934),(-3.77899,.20739,2.42815),(-3.74533,.22774,2.3699),(-3.59718,.26508,2.52853),(-3.55395,.43614,2.15714),(-3.61446,.57462,1.98495),(-3.33077,.42522,1.76697),(-3.33855,.51999,1.807),(-3.3702,.49954,1.87673),(-3.53998,.30889,1.80926),(-3.49458,.30786,1.94672),(-3.43772,.29975,1.81141),(-3.40424,.30368,1.82433),(-3.50282,.31165,1.81363),(-3.57778,.30609,2.14844),(-3.48809,.50014,2.00013),(-3.75675,.37156,2.11658),(-3.74314,.41108,2.12562),(-3.74452,.42225,1.94764),(-3.47057,.33682,1.95925),(-3.80382,.1879,2.46709),(-3.7042,.18665,2.53409),(-3.67817,.18963,2.54289),(-3.71074,.17249,2.58901),(-3.73203,.30407,2.63446),(-3.69176,.44536,2.13865),(-3.66446,.57035,1.97799),(-3.85162,.14344,2.57854),(-3.75981,.1293,2.55199),(-3.65429,.1391,2.58532),(-3.60824,.14456,2.58555),(-3.6154,.15063,2.64289),(-3.67176,.15328,2.6382),(-3.78204,.22585,2.43681),(-3.62795,.28325,1.76324),(-3.67083,.56378,1.82691),(-3.68398,.59951,1.85607),(-3.68569,.37198,2.37967),(-3.7338,.25253,2.3029),(-3.6169,.27715,2.35647),(-3.71287,.21588,2.38469),(-3.65166,.36247,2.38224),(-3.37279,.56826,1.81722),(-3.41011,.60207,1.83905),(-3.70905,.4272,1.66909),(-3.55613,.35889,1.69609),(-3.60817,.3341,1.66851),(-3.46941,.37581,1.72264),(-3.40731,.35838,1.72183),(-3.59137,.62001,1.89633),(-3.59534,.62418,1.91421),(-3.42658,.30984,1.78143),(-3.61993,.2978,1.72845),(-3.5783,.30327,1.76621),(-3.52968,.31831,1.77899),(-3.55818,.58691,1.87571),(-3.61125,.57586,1.85944),(-3.63348,.50393,1.78601),(-3.57662,.51802,1.82092),(-3.6528,.42822,1.7078),(-3.59733,.44422,1.74511),(-3.74061,.45199,1.85506),(-3.71942,.38266,1.83431),(-3.72127,.31509,2.59593),(-3.69154,.21293,2.48311),(-3.64004,.62155,1.8886),(-3.50499,.38906,1.71221),(-3.50425,.37193,1.71356),(-3.49277,.3216,1.78377)]))),
        Shape(DEF='rfpprox4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfpprox4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,3,-1,11,12,13,-1,13,14,11,-1,13,15,14,-1,16,17,18,-1,18,19,16,-1,20,18,17,-1,20,21,11,-1,12,22,13,-1,23,24,25,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,33,34,35,-1,33,36,34,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,52,54,53,-1,55,56,32,-1,56,30,32,-1,57,58,59,-1,17,21,20,-1,33,35,60,-1,35,61,60,-1,62,63,64,-1,65,66,22,-1,65,67,66,-1,68,69,37,-1,69,70,37,-1,71,72,73,-1,73,67,71,-1,42,74,75,-1,75,40,42,-1,45,76,77,-1,78,45,79,-1,80,45,47,-1,81,45,82,-1,83,84,85,-1,85,86,83,-1,69,68,87,-1,88,89,90,-1,89,91,90,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,100,8,7,-1,7,101,100,-1,102,103,25,-1,102,104,103,-1,105,27,106,-1,107,108,109,-1,108,110,109,-1,111,3,10,-1,112,4,0,-1,113,25,103,-1,103,114,113,-1,115,15,23,-1,115,14,15,-1,116,117,118,-1,99,119,120,-1,99,121,119,-1,8,24,6,-1,106,27,97,-1,27,29,97,-1,96,122,97,-1,123,91,89,-1,124,125,93,-1,125,94,93,-1,46,45,44,-1,45,80,126,-1,76,45,78,-1,45,127,82,-1,128,39,129,-1,45,81,43,-1,130,131,107,-1,131,108,107,-1,132,114,133,-1,132,134,114,-1,14,135,20,-1,14,115,135,-1,31,136,5,-1,95,97,29,-1,2,137,19,-1,137,72,19,-1,20,11,14,-1,50,138,48,-1,139,140,132,-1,132,133,139,-1,141,50,49,-1,141,142,50,-1,131,99,108,-1,143,144,145,-1,145,92,143,-1,59,146,57,-1,87,147,69,-1,126,79,45,-1,40,39,41,-1,77,127,45,-1,129,148,128,-1,132,146,134,-1,34,149,35,-1,9,36,33,-1,9,150,36,-1,112,151,152,-1,98,121,99,-1,16,72,71,-1,12,65,22,-1,16,19,72,-1,71,65,21,-1,2,19,18,-1,21,65,12,-1,12,11,21,-1,65,71,67,-1,3,111,1,-1,100,101,98,-1,9,136,150,-1,5,4,153,-1,1,4,3,-1,4,1,0,-1,71,17,16,-1,17,71,21,-1,154,98,122,-1,154,121,98,-1,96,155,156,-1,96,95,155,-1,157,6,15,-1,6,157,105,-1,111,60,116,-1,10,60,111,-1,118,2,1,-1,118,137,2,-1,117,158,159,-1,61,158,117,-1,150,31,30,-1,31,150,136,-1,146,140,57,-1,140,146,132,-1,38,70,160,-1,38,37,70,-1,63,161,83,-1,161,63,162,-1,163,164,84,-1,165,164,163,-1,166,148,167,-1,148,166,168,-1,148,169,167,-1,129,169,148,-1,170,91,123,-1,171,91,170,-1,40,37,39,-1,68,37,40,-1,75,172,87,-1,75,74,172,-1,62,162,63,-1,173,162,62,-1,39,77,41,-1,39,127,77,-1,174,165,163,-1,165,174,175,-1,176,162,177,-1,176,161,162,-1,79,178,179,-1,178,79,126,-1,43,180,175,-1,43,81,180,-1,128,127,39,-1,127,128,82,-1,78,179,181,-1,79,179,78,-1,182,47,177,-1,47,182,80,-1,41,76,42,-1,77,76,41,-1,31,153,32,-1,31,5,153,-1,90,143,88,-1,90,144,143,-1,143,94,183,-1,94,143,92,-1,184,53,54,-1,53,184,185,-1,99,186,100,-1,186,99,131,-1,187,188,189,-1,188,187,190,-1,191,52,192,-1,191,54,52,-1,193,184,194,-1,193,142,184,-1,189,195,187,-1,195,189,196,-1,197,110,120,-1,110,197,198,-1,102,100,186,-1,102,8,100,-1,138,199,200,-1,138,50,199,-1,140,201,202,-1,140,139,201,-1,203,204,205,-1,203,58,204,-1,94,203,183,-1,125,203,94,-1,133,138,139,-1,48,138,133,-1,102,24,8,-1,25,24,102,-1,135,113,206,-1,135,115,113,-1,207,151,208,-1,152,151,207,-1,150,209,36,-1,210,209,150,-1,97,7,106,-1,7,97,101,-1,15,22,157,-1,13,22,15,-1,1,116,118,-1,111,116,1,-1,211,119,212,-1,119,211,213,-1,122,101,97,-1,101,122,98,-1,214,149,215,-1,149,214,158,-1,216,26,217,-1,216,155,26,-1,51,218,196,-1,218,51,109,-1,120,213,197,-1,213,120,119,-1,216,219,220,-1,221,219,216,-1,206,114,134,-1,206,113,114,-1,222,202,201,-1,160,202,222,-1,223,146,59,-1,134,146,223,-1,215,219,221,-1,219,215,224,-1,210,197,213,-1,197,210,56,-1,196,225,195,-1,196,218,225,-1,149,224,215,-1,149,34,224,-1,217,28,66,-1,217,26,28,-1,53,109,51,-1,53,107,109,-1,175,168,165,-1,168,175,180,-1,104,141,49,-1,104,226,141,-1,124,59,125,-1,124,223,59,-1,181,171,170,-1,181,179,171,-1,173,177,162,-1,182,177,173,-1,168,128,148,-1,180,128,168,-1,64,83,86,-1,64,63,83,-1,185,107,53,-1,107,185,130,-1,130,141,226,-1,130,185,141,-1,164,227,228,-1,164,166,227,-1,200,227,229,-1,199,227,200,-1,222,167,169,-1,222,229,167,-1,114,48,133,-1,48,114,103,-1,230,147,231,-1,205,147,230,-1,172,89,231,-1,123,89,172,-1,36,224,34,-1,36,209,224,-1,30,210,150,-1,30,56,210,-1,153,124,93,-1,124,153,152,-1,73,137,159,-1,72,137,73,-1,157,66,28,-1,157,22,66,-1,208,2,18,-1,151,2,208,-1,73,158,214,-1,158,73,159,-1,223,152,207,-1,124,152,223,-1,225,32,232,-1,55,32,225,-1,61,116,60,-1,116,61,117,-1,220,154,156,-1,220,212,154,-1,186,130,226,-1,131,130,186,-1,226,102,186,-1,226,104,102,-1,87,231,147,-1,172,231,87,-1,89,230,231,-1,89,88,230,-1,145,93,92,-1,145,232,93,-1,69,205,204,-1,69,147,205,-1,201,229,222,-1,201,200,229,-1,103,49,48,-1,103,104,49,-1,229,166,167,-1,229,227,166,-1,228,194,85,-1,194,228,193,-1,195,232,145,-1,232,195,225,-1,191,85,194,-1,191,86,85,-1,90,233,190,-1,90,91,233,-1,192,86,191,-1,192,64,86,-1,176,163,161,-1,176,174,163,-1,234,182,173,-1,178,182,234,-1,42,170,74,-1,42,181,170,-1,232,153,93,-1,232,32,153,-1,199,228,227,-1,228,199,193,-1,156,216,220,-1,156,155,216,-1,190,62,188,-1,62,190,233,-1,218,55,225,-1,218,198,55,-1,219,209,211,-1,219,224,209,-1,214,67,73,-1,235,67,214,-1,207,134,223,-1,206,134,207,-1,204,70,69,-1,236,70,204,-1,169,160,222,-1,38,160,169,-1,235,66,67,-1,66,235,217,-1,211,220,219,-1,211,212,220,-1,198,109,110,-1,198,218,109,-1,64,188,62,-1,188,64,192,-1,221,217,235,-1,221,216,217,-1,215,235,214,-1,215,221,235,-1,212,121,154,-1,121,212,119,-1,10,33,60,-1,9,33,10,-1,105,7,6,-1,105,106,7,-1,209,213,211,-1,213,209,210,-1,4,152,153,-1,4,112,152,-1,208,206,207,-1,208,135,206,-1,115,25,113,-1,115,23,25,-1,125,58,203,-1,59,58,125,-1,183,205,230,-1,183,203,205,-1,58,236,204,-1,58,57,236,-1,139,200,201,-1,139,138,200,-1,50,193,199,-1,50,142,193,-1,108,120,110,-1,108,99,120,-1,198,56,55,-1,198,197,56,-1,187,145,144,-1,145,187,195,-1,52,196,189,-1,196,52,51,-1,194,54,191,-1,194,184,54,-1,192,189,188,-1,192,52,189,-1,144,190,187,-1,190,144,90,-1,142,185,184,-1,185,142,141,-1,88,183,230,-1,88,143,183,-1,46,174,176,-1,44,174,46,-1,178,80,182,-1,126,80,178,-1,76,181,42,-1,78,181,76,-1,81,128,180,-1,82,128,81,-1,171,178,234,-1,171,179,178,-1,177,46,176,-1,47,46,177,-1,85,164,228,-1,85,84,164,-1,44,175,174,-1,175,44,43,-1,91,234,233,-1,171,234,91,-1,38,129,39,-1,38,169,129,-1,233,173,62,-1,233,234,173,-1,74,123,172,-1,170,123,74,-1,68,75,87,-1,75,68,40,-1,165,166,164,-1,168,166,165,-1,83,163,84,-1,163,83,161,-1,57,202,236,-1,140,202,57,-1,160,236,202,-1,160,70,236,-1,61,149,158,-1,61,35,149,-1,118,159,137,-1,117,159,118,-1,151,0,2,-1,0,151,112,-1,6,23,15,-1,24,23,6,-1,28,105,157,-1,105,28,27,-1,155,29,26,-1,29,155,95,-1,122,156,154,-1,96,156,122,-1,135,18,20,-1,208,18,135,-1,9,5,136,-1,9,3,5,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfpprox4_Coord',point=[(-4.00544,.34058,1.88945),(-4.00441,.34313,1.90954),(-4.00601,.32414,1.90401),(-4.02222,.38183,1.86315),(-4.0211,.37484,1.84521),(-4.03435,.39114,1.84475),(-4.16399,.20801,1.84468),(-4.20344,.23195,1.83343),(-4.18808,.25143,1.78631),(-4.05709,.40535,1.90836),(-4.01939,.38158,1.90916),(-4.09521,.23415,1.91888),(-4.09954,.21978,1.92812),(-4.12021,.21654,1.88611),(-4.11122,.2276,1.87909),(-4.14715,.20604,1.85345),(-4.04694,.25625,1.94432),(-4.06392,.25496,1.92771),(-4.03655,.27864,1.90191),(-4.02599,.28168,1.91371),(-4.08657,.25843,1.8935),(-4.08832,.24753,1.94347),(-4.12282,.20356,1.94259),(-4.14406,.23546,1.808),(-4.16031,.23716,1.80171),(-4.15003,.25035,1.71627),(-4.22349,.2269,1.98889),(-4.21702,.20329,1.95662),(-4.20712,.20272,1.97148),(-4.23539,.22705,1.97795),(-4.09111,.42414,1.83675),(-4.07496,.41938,1.83947),(-4.07179,.44723,1.75656),(-4.058,.40152,1.95898),(-4.05654,.38897,2.00552),(-4.0463,.38526,2.00774),(-4.07317,.40934,1.95771),(-3.86575,.40506,1.28085),(-3.89394,.38754,1.27199),(-3.8915,.41269,1.27623),(-3.80581,.43902,1.27845),(-3.83332,.4476,1.2877),(-3.81101,.52758,1.33254),(-4.03274,.44966,1.28379),(-4.05366,.46675,1.29177),(-3.98768,.4898,1.32759),(-4.05476,.49966,1.31907),(-4.03715,.51093,1.33426),(-4.11877,.26287,1.54023),(-4.14478,.27813,1.52668),(-4.14872,.27602,1.44059),(-4.19716,.47241,1.54025),(-4.17995,.51013,1.45936),(-4.21178,.4305,1.52078),(-4.20523,.46392,1.44228),(-4.12873,.44517,1.74392),(-4.13641,.41407,1.82827),(-3.96946,.34403,1.49402),(-3.91119,.34059,1.5083),(-3.97113,.34669,1.57586),(-4.01822,.37782,1.96016),(-4.02546,.36383,2.0116),(-4.10393,.59958,1.37882),(-4.16438,.56415,1.32846),(-4.16589,.55717,1.35086),(-4.09294,.24072,1.95275),(-4.16383,.21538,1.98213),(-4.11165,.24639,1.98823),(-3.79495,.42256,1.28111),(-3.77301,.387,1.32623),(-3.87832,.38477,1.31202),(-4.08154,.24798,1.9546),(-4.03402,.26185,1.96117),(-4.05079,.28727,2.01091),(-3.73959,.57667,1.32441),(-3.73687,.49175,1.29213),(-3.90152,.5054,1.33398),(-3.90356,.47081,1.31565),(-3.93293,.5297,1.34626),(-3.97876,.52946,1.35431),(-4.01946,.52217,1.34946),(-4.02225,.44065,1.27994),(-3.99074,.43207,1.28624),(-4.19565,.51712,1.28549),(-4.18543,.4416,1.21038),(-4.21808,.41276,1.26682),(-4.19838,.50425,1.32948),(-3.72225,.48113,1.29642),(-3.87452,.56627,1.46688),(-3.84821,.60769,1.40987),(-3.97483,.59245,1.45107),(-3.96928,.61755,1.40196),(-3.95083,.47087,1.59565),(-3.9898,.43417,1.67512),(-3.92653,.45165,1.59953),(-4.2482,.25506,1.98885),(-4.27006,.28404,1.96506),(-4.25291,.26047,1.87976),(-4.26989,.32638,1.83747),(-4.26188,.33976,1.78454),(-4.22401,.28671,1.76959),(-4.23695,.27598,1.82494),(-4.17561,.26136,1.69873),(-4.1393,.25827,1.62323),(-4.1577,.2718,1.61103),(-4.17714,.18849,1.89813),(-4.21332,.2143,1.8853),(-4.2294,.39993,1.6006),(-4.25428,.3697,1.69318),(-4.21346,.43391,1.6212),(-4.22676,.39803,1.70982),(-4.01051,.369,1.90904),(-4.00857,.34508,1.84305),(-4.10803,.2627,1.72347),(-4.09417,.2803,1.6329),(-4.11583,.2439,1.81411),(-4.00025,.35408,1.96084),(-4.00406,.34804,2.00493),(-3.99166,.32626,1.95873),(-4.23781,.35527,1.85337),(-4.23887,.36647,1.80012),(-4.26659,.33584,1.84146),(-4.28212,.31633,1.88877),(-3.83432,.61872,1.37523),(-3.96419,.38132,1.66663),(-3.92532,.39695,1.59014),(-3.99907,.52581,1.35189),(-3.93188,.44218,1.30111),(-3.9916,.38239,1.23883),(-3.92623,.36048,1.23576),(-4.23472,.3612,1.59329),(-4.25314,.34931,1.68906),(-4.03222,.31804,1.56237),(-4.06777,.28782,1.55247),(-4.04947,.30767,1.64268),(-4.0813,.27294,1.82337),(-4.06469,.41095,1.89184),(-3.99387,.31273,1.95856),(-4.08919,.25307,1.45883),(-4.03397,.28629,1.4737),(-3.9997,.33106,1.48559),(-4.19844,.31288,1.51713),(-4.18863,.31864,1.43212),(-3.90617,.52635,1.52469),(-3.99354,.5611,1.50881),(-4.01783,.50995,1.58863),(-4.01182,.33027,1.56727),(-3.71968,.43909,1.34782),(-3.99079,.31794,1.19937),(-4.05104,.37993,2.01501),(-4.07797,.41237,1.90095),(-4.0093,.33089,1.84091),(-3.9933,.36008,1.75251),(-4.0156,.40482,1.76136),(-4.27617,.32885,1.89366),(-4.23857,.25988,2.00029),(-4.26401,.29545,1.9731),(-4.1603,.18411,1.91068),(-4.03206,.35686,2.01878),(-4.00757,.33863,2.00832),(-3.90745,.37089,1.30359),(-4.17788,.52103,1.27972),(-4.14855,.56345,1.32031),(-4.16831,.44909,1.20804),(-4.13975,.37003,1.17137),(-4.12603,.38122,1.17097),(-4.08617,.3356,1.17603),(-3.99224,.29828,1.20154),(-4.0767,.35188,1.17625),(-3.91731,.34978,1.24548),(-3.84226,.61266,1.3621),(-3.96797,.61124,1.38668),(-3.72825,.578,1.33333),(-4.0933,.59429,1.36531),(-4.11426,.45329,1.24932),(-4.07656,.41375,1.23005),(-4.12231,.51584,1.30211),(-4.08667,.53882,1.33313),(-4.00889,.56926,1.36911),(-3.96753,.57671,1.37407),(-4.0525,.39917,1.22709),(-3.87437,.57719,1.3576),(-4.05348,.55996,1.36169),(-3.84603,.47893,1.5349),(-4.21489,.38008,1.43033),(-4.22534,.36876,1.51246),(-4.21608,.29906,1.68634),(-4.07148,.5563,1.49208),(-4.11901,.57584,1.42317),(-4.13858,.54639,1.47818),(-4.05213,.58525,1.43584),(-4.2068,.48166,1.38475),(-4.16987,.53254,1.40446),(-4.18107,.32893,1.3241),(-4.21831,.39347,1.34469),(-4.09253,.51526,1.57547),(-4.1567,.49972,1.55847),(-4.18808,.38883,1.81695),(-4.18551,.42205,1.72822),(-4.12931,.28729,1.32809),(-4.04983,.25421,1.3504),(-3.98493,.29228,1.37737),(-3.94992,.35274,1.39254),(-3.85901,.40927,1.52755),(-3.85238,.35525,1.41726),(-3.78708,.42084,1.44016),(-4.06841,.29089,1.733),(-4.02512,.3138,1.74222),(-4.0407,.2949,1.83269),(-4.12716,.3947,1.94144),(-4.12958,.39929,1.88465),(-4.19258,.36444,1.92187),(-4.24117,.34765,1.90727),(-4.19038,.37657,1.86943),(-4.07884,.31322,2.02935),(-4.10509,.34392,2.02887),(-4.20706,.27741,2.01076),(-4.18644,.24385,2.00231),(-4.17609,.45761,1.64044),(-4.1778,.33971,1.98375),(-4.22868,.31757,1.98168),(-4.16132,.30439,2.01133),(-3.94813,.31491,1.27928),(-4.00476,.33186,1.65182),(-4.11714,.37413,2.00082),(-4.11553,.47881,1.66053),(-4.20313,.30311,1.60126),(-4.11129,.29855,1.21561),(-4.16843,.34215,1.21623),(-4.01949,.26447,1.24075),(-3.77989,.50278,1.46991),(-3.73228,.5322,1.40265),(-4.04934,.47205,1.67352),(-4.03982,.61345,1.39142),(-4.03489,.60796,1.37767),(-4.13707,.27256,2.0066),(-3.9226,.36504,1.40063)]))),
        Shape(DEF='rfpprox5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfpprox5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,19,21,20,-1,22,23,24,-1,25,26,17,-1,27,12,14,-1,28,29,30,-1,31,32,33,-1,34,35,30,-1,34,36,35,-1,37,38,39,-1,39,40,37,-1,41,42,32,-1,43,37,40,-1,43,44,37,-1,45,46,47,-1,47,48,45,-1,49,50,51,-1,52,53,54,-1,1,55,2,-1,43,56,57,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,31,41,32,-1,15,17,65,-1,66,64,63,-1,63,67,66,-1,68,69,70,-1,71,32,42,-1,71,6,32,-1,72,26,73,-1,65,74,75,-1,65,76,74,-1,77,78,79,-1,13,80,81,-1,13,82,80,-1,12,82,13,-1,12,83,84,-1,12,11,85,-1,86,87,88,-1,88,87,89,-1,87,90,89,-1,76,65,22,-1,91,92,93,-1,91,94,92,-1,95,96,97,-1,97,98,46,-1,46,95,97,-1,64,99,100,-1,64,101,99,-1,34,30,29,-1,29,28,102,-1,103,104,105,-1,103,3,104,-1,106,47,98,-1,96,107,97,-1,108,109,110,-1,26,111,73,-1,111,112,73,-1,22,24,76,-1,89,113,114,-1,114,115,89,-1,86,116,117,-1,86,88,116,-1,12,79,118,-1,85,83,12,-1,84,82,12,-1,119,13,120,-1,119,14,13,-1,26,25,111,-1,121,23,122,-1,121,24,23,-1,12,118,11,-1,101,123,124,-1,72,73,125,-1,126,127,39,-1,126,7,127,-1,32,68,33,-1,128,67,129,-1,128,66,67,-1,64,130,62,-1,64,100,130,-1,131,126,132,-1,126,133,132,-1,17,16,25,-1,35,134,135,-1,136,128,129,-1,61,137,59,-1,138,139,140,-1,138,45,139,-1,141,37,142,-1,142,48,141,-1,133,126,38,-1,43,40,143,-1,144,37,44,-1,53,133,54,-1,53,132,133,-1,50,62,130,-1,130,51,50,-1,46,98,47,-1,44,43,55,-1,39,38,126,-1,55,43,57,-1,57,2,55,-1,55,145,44,-1,146,102,28,-1,28,147,146,-1,69,128,136,-1,70,33,68,-1,128,69,68,-1,92,94,120,-1,94,119,120,-1,90,87,10,-1,87,148,10,-1,18,20,119,-1,119,94,18,-1,149,150,19,-1,149,151,150,-1,27,79,12,-1,27,21,77,-1,77,79,27,-1,17,22,65,-1,20,21,27,-1,13,81,120,-1,152,10,9,-1,152,90,10,-1,72,153,26,-1,143,56,43,-1,154,155,59,-1,59,137,154,-1,59,155,60,-1,144,142,37,-1,134,3,103,-1,4,3,134,-1,154,140,156,-1,140,154,137,-1,157,135,158,-1,135,157,159,-1,159,1,0,-1,159,157,1,-1,56,127,71,-1,56,143,127,-1,149,160,161,-1,160,149,162,-1,20,14,119,-1,14,20,27,-1,19,77,21,-1,19,150,77,-1,94,162,18,-1,94,91,162,-1,163,78,164,-1,163,165,78,-1,80,109,108,-1,109,80,166,-1,120,167,92,-1,167,120,81,-1,152,165,163,-1,165,152,9,-1,109,168,86,-1,168,109,166,-1,147,30,35,-1,147,28,30,-1,102,169,170,-1,146,169,102,-1,171,136,172,-1,171,69,136,-1,42,2,57,-1,42,41,2,-1,48,106,141,-1,48,47,106,-1,53,130,132,-1,53,51,130,-1,107,61,58,-1,61,107,96,-1,50,58,62,-1,107,58,50,-1,37,133,38,-1,141,133,37,-1,48,139,45,-1,48,142,139,-1,138,137,61,-1,138,140,137,-1,172,129,5,-1,172,136,129,-1,35,4,134,-1,35,36,4,-1,159,35,135,-1,147,35,159,-1,146,2,169,-1,146,0,2,-1,25,160,173,-1,16,160,25,-1,161,151,149,-1,161,75,151,-1,174,3,5,-1,174,104,3,-1,175,102,170,-1,175,29,102,-1,131,130,100,-1,131,132,130,-1,176,103,105,-1,103,176,158,-1,177,72,125,-1,178,72,177,-1,8,22,17,-1,8,179,22,-1,123,180,181,-1,101,180,123,-1,101,122,99,-1,101,124,122,-1,112,182,183,-1,112,111,182,-1,184,185,186,-1,187,185,184,-1,116,188,117,-1,189,188,116,-1,190,114,121,-1,190,115,114,-1,74,24,191,-1,76,24,74,-1,188,177,187,-1,177,188,181,-1,118,9,11,-1,118,165,9,-1,192,114,113,-1,192,191,114,-1,68,178,128,-1,72,178,68,-1,166,83,168,-1,84,83,166,-1,148,11,10,-1,85,11,148,-1,190,123,189,-1,190,124,123,-1,122,190,121,-1,124,190,122,-1,152,89,90,-1,152,113,89,-1,193,191,192,-1,74,191,193,-1,164,151,193,-1,150,151,164,-1,184,110,109,-1,186,110,184,-1,185,73,112,-1,125,73,185,-1,183,93,194,-1,182,93,183,-1,110,167,108,-1,110,194,167,-1,156,105,154,-1,176,105,156,-1,131,99,195,-1,99,131,100,-1,52,106,98,-1,106,52,54,-1,155,105,104,-1,105,155,154,-1,174,63,60,-1,174,67,63,-1,180,128,178,-1,66,128,180,-1,32,8,153,-1,8,32,6,-1,145,158,176,-1,145,157,158,-1,57,71,42,-1,56,71,57,-1,144,145,196,-1,44,145,144,-1,176,196,145,-1,176,156,196,-1,143,39,127,-1,143,40,39,-1,157,55,1,-1,145,55,157,-1,7,179,8,-1,7,126,179,-1,153,68,32,-1,153,72,68,-1,33,175,170,-1,33,70,175,-1,70,171,175,-1,171,70,69,-1,67,5,129,-1,67,174,5,-1,101,66,180,-1,64,66,101,-1,195,126,131,-1,195,179,126,-1,49,98,97,-1,49,52,98,-1,50,97,107,-1,97,50,49,-1,92,194,93,-1,167,194,92,-1,110,183,194,-1,110,186,183,-1,187,125,185,-1,177,125,187,-1,182,91,93,-1,182,173,91,-1,75,193,151,-1,193,75,74,-1,164,192,163,-1,193,192,164,-1,189,181,188,-1,181,189,123,-1,89,116,88,-1,89,115,116,-1,165,79,78,-1,118,79,165,-1,168,85,148,-1,83,85,168,-1,82,166,80,-1,82,84,166,-1,113,163,192,-1,152,163,113,-1,184,86,117,-1,184,109,86,-1,191,121,114,-1,24,121,191,-1,115,189,116,-1,190,189,115,-1,117,187,184,-1,188,187,117,-1,186,112,183,-1,185,112,186,-1,111,173,182,-1,111,25,173,-1,195,122,23,-1,195,99,122,-1,181,178,177,-1,180,178,181,-1,153,17,26,-1,153,8,17,-1,179,23,22,-1,179,195,23,-1,34,175,171,-1,175,34,29,-1,60,104,174,-1,104,60,155,-1,15,75,161,-1,15,65,75,-1,162,173,160,-1,162,91,173,-1,41,169,2,-1,31,169,41,-1,147,0,146,-1,147,159,0,-1,5,36,172,-1,36,5,4,-1,62,60,63,-1,62,58,60,-1,51,52,49,-1,52,51,53,-1,96,138,61,-1,95,138,96,-1,138,46,45,-1,138,95,46,-1,141,54,133,-1,141,106,54,-1,34,172,36,-1,34,171,172,-1,31,170,169,-1,31,33,170,-1,86,148,87,-1,148,86,168,-1,81,108,167,-1,108,81,80,-1,78,150,164,-1,150,78,77,-1,16,161,160,-1,16,15,161,-1,19,162,149,-1,162,19,18,-1,7,71,127,-1,71,7,6,-1,142,196,139,-1,142,144,196,-1,156,139,196,-1,139,156,140,-1,103,135,134,-1,103,158,135,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfpprox5_Coord',point=[(-4.36503,.32697,1.52252),(-4.38517,.31582,1.5225),(-4.35619,.31989,1.47441),(-4.48313,.4396,1.53036),(-4.46251,.44661,1.5334),(-4.46096,.46571,1.47051),(-4.36906,.35939,1.31786),(-4.38309,.34829,1.31307),(-4.34377,.38435,1.20664),(-4.47705,.42102,.77273),(-4.51618,.46367,.78517),(-4.43747,.48152,.82529),(-4.32058,.54946,.88643),(-4.17506,.57922,.86798),(-4.21901,.51809,.84829),(-4.28524,.40062,1.03513),(-4.27258,.40766,1.03797),(-4.3144,.39447,1.12101),(-4.22263,.45724,.82864),(-4.23692,.44978,.82781),(-4.23618,.46663,.82443),(-4.24312,.46077,.82339),(-4.37559,.36195,1.10722),(-4.4271,.36253,1.09779),(-4.43058,.34646,1.01314),(-4.22574,.42203,1.04866),(-4.26664,.44511,1.13443),(-4.25009,.47438,.83423),(-4.35217,.39142,1.56764),(-4.33303,.41338,1.53113),(-4.40055,.43665,1.56906),(-4.29879,.36371,1.43103),(-4.33242,.3998,1.33071),(-4.29328,.37466,1.43223),(-4.39243,.4598,1.54149),(-4.41196,.43751,1.57221),(-4.41548,.45483,1.53913),(-4.4345,.2742,1.43511),(-4.4288,.28346,1.39465),(-4.41778,.29404,1.39687),(-4.42561,.28558,1.43823),(-4.34247,.33422,1.42521),(-4.36027,.33309,1.42314),(-4.42264,.30487,1.50887),(-4.44062,.29882,1.52115),(-4.54739,.26889,1.49752),(-4.55934,.26986,1.48195),(-4.49855,.25289,1.44218),(-4.48642,.25451,1.45658),(-4.55607,.33898,1.365),(-4.59113,.39751,1.38366),(-4.53247,.34725,1.31609),(-4.51356,.29473,1.36996),(-4.50256,.31363,1.32124),(-4.47952,.26756,1.37694),(-4.42385,.31056,1.52728),(-4.40076,.31981,1.46076),(-4.37737,.32126,1.46985),(-4.60032,.40874,1.43395),(-4.59159,.3891,1.51503),(-4.56394,.42927,1.44431),(-4.611,.36683,1.50994),(-4.57927,.41313,1.38382),(-4.54529,.43609,1.39414),(-4.51679,.4159,1.29171),(-4.32635,.36415,1.0261),(-4.47027,.46942,1.31343),(-4.50329,.45129,1.40506),(-4.33503,.45059,1.33789),(-4.3752,.48375,1.43534),(-4.3199,.44174,1.43794),(-4.38818,.33326,1.42092),(-4.31576,.47708,1.22716),(-4.25601,.49717,1.14369),(-4.3657,.32223,.92217),(-4.29594,.35351,.94149),(-4.37857,.33035,1.01521),(-4.28323,.39238,.79658),(-4.34006,.35877,.78195),(-4.33784,.43547,.81765),(-4.20125,.67837,.90248),(-4.10321,.63092,.83848),(-4.23884,.62841,.8991),(-4.36337,.61113,.9239),(-4.29837,.6314,.9231),(-4.43612,.57063,.88431),(-4.41919,.66281,.94786),(-4.51406,.57455,.87818),(-4.50762,.56207,.91661),(-4.53074,.44048,.84569),(-4.52215,.45731,.79214),(-4.134,.42131,.86392),(-4.09063,.52057,.80907),(-4.08099,.47178,.87714),(-4.14351,.46466,.81404),(-4.59884,.32243,1.50224),(-4.61832,.35612,1.49723),(-4.57337,.32956,1.41572),(-4.52712,.28544,1.41349),(-4.47368,.38201,1.1756),(-4.51088,.3641,1.28013),(-4.4967,.43252,1.18379),(-4.31549,.37354,1.52527),(-4.48583,.42009,1.56095),(-4.53402,.41224,1.51935),(-4.5313,.39666,1.53983),(-4.48276,.25637,1.41635),(-4.61023,.39467,1.42885),(-4.19492,.68196,.91142),(-4.29964,.69894,.94551),(-4.18467,.66474,.94508),(-4.18947,.4636,1.05347),(-4.18562,.53344,1.06183),(-4.49616,.39137,.82469),(-4.4834,.38784,.9189),(-4.51403,.45298,.93797),(-4.50151,.53231,.96772),(-4.42699,.64069,.99377),(-4.39525,.44799,.81398),(-4.15684,.4811,.80941),(-4.10303,.53149,.80837),(-4.47195,.38429,1.01305),(-4.47138,.39244,1.09504),(-4.49076,.469,1.10233),(-4.49221,.44587,1.09982),(-4.27538,.52409,1.1454),(-4.42736,.32293,1.29825),(-4.40632,.32052,1.41647),(-4.38829,.4758,1.33141),(-4.44083,.47276,1.42093),(-4.51849,.35573,1.30154),(-4.4805,.32565,1.28296),(-4.48706,.31997,1.30712),(-4.45851,.2707,1.37882),(-4.46549,.4305,1.5629),(-4.45657,.4077,1.57604),(-4.39874,.48321,1.43129),(-4.58928,.37571,1.52778),(-4.58975,.32815,1.51843),(-4.5133,.27692,1.53118),(-4.56476,.34254,1.54027),(-4.46396,.25903,1.42144),(-4.46183,.26118,1.47974),(-4.41257,.31239,1.45378),(-4.44989,.2694,1.49354),(-4.44844,.31755,1.54933),(-4.31993,.3601,1.52432),(-4.36528,.38189,1.5731),(-4.50283,.57626,.86974),(-4.21903,.40435,.87105),(-4.27361,.37964,.80193),(-4.26685,.34341,.85257),(-4.48339,.40919,.77631),(-4.31095,.42931,1.2195),(-4.57221,.38754,1.53288),(-4.5741,.40032,1.51742),(-4.5487,.35228,1.54776),(-4.41683,.3371,1.56757),(-4.474,.39685,1.57306),(-4.40086,.34942,1.57196),(-4.23335,.41147,.9576),(-4.25141,.40109,.9527),(-4.20133,.41536,.87366),(-4.43479,.37896,.7756),(-4.34258,.34317,.78593),(-4.42827,.39317,.77312),(-4.29808,.69479,.93571),(-4.09264,.63029,.84293),(-4.40978,.65958,.93644),(-4.29728,.35851,1.47924),(-4.29157,.37012,1.48017),(-4.38483,.47752,1.48372),(-4.40874,.47798,1.48125),(-4.17767,.41969,.95935),(-4.51862,.44151,1.45457),(-4.32214,.43103,1.48275),(-4.51149,.37548,1.55232),(-4.3396,.55046,1.14118),(-4.36018,.50374,1.22422),(-4.39281,.35532,1.19216),(-4.44354,.50351,1.21169),(-4.43023,.54533,1.12809),(-4.12879,.46804,.95802),(-4.13098,.55233,.9874),(-4.30356,.6551,1.00261),(-4.22875,.5777,1.06638),(-4.20373,.62327,1.00679),(-4.31413,.61628,1.05672),(-4.42698,.6031,1.04239),(-4.49603,.50244,1.02195),(-4.50071,.45108,1.01172),(-4.43594,.34796,.91991),(-4.44258,.34939,.82662),(-4.35458,.31413,.82904),(-4.07722,.57276,.90976),(-4.43688,.35621,1.18031),(-4.49776,.28441,1.54008)]))),
        Shape(DEF='rfdphal',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfdphal_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,7,9,8,-1,3,5,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,21,23,22,-1,24,25,26,-1,26,19,27,-1,28,29,30,-1,31,32,33,-1,31,34,32,-1,35,31,33,-1,36,37,38,-1,36,38,39,-1,40,38,41,-1,42,43,44,-1,42,45,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,60,61,62,-1,60,63,61,-1,64,58,65,-1,66,7,64,-1,64,65,66,-1,1,67,68,-1,69,56,49,-1,70,71,48,-1,72,73,74,-1,75,76,77,-1,63,78,77,-1,25,79,80,-1,25,24,79,-1,81,82,29,-1,83,84,85,-1,86,87,82,-1,87,88,82,-1,48,89,49,-1,90,6,12,-1,91,51,53,-1,91,52,51,-1,47,86,48,-1,47,92,86,-1,50,52,93,-1,93,94,50,-1,31,35,95,-1,95,29,31,-1,96,97,98,-1,96,99,97,-1,100,101,67,-1,102,67,101,-1,37,41,38,-1,76,75,7,-1,103,59,58,-1,104,58,39,-1,105,0,40,-1,0,104,40,-1,106,78,103,-1,103,107,106,-1,69,49,89,-1,89,108,69,-1,107,109,106,-1,107,110,109,-1,0,2,110,-1,111,112,68,-1,113,114,115,-1,113,116,114,-1,117,118,119,-1,16,11,13,-1,120,121,122,-1,90,11,123,-1,123,83,90,-1,124,125,123,-1,124,126,125,-1,23,127,128,-1,129,130,131,-1,130,132,131,-1,27,129,26,-1,10,131,3,-1,131,132,3,-1,75,9,7,-1,75,133,9,-1,134,135,133,-1,135,9,133,-1,136,137,138,-1,137,139,138,-1,138,140,18,-1,18,141,138,-1,142,122,143,-1,138,144,140,-1,138,139,144,-1,145,146,147,-1,146,148,147,-1,8,9,135,-1,149,148,4,-1,149,147,148,-1,8,12,6,-1,70,10,5,-1,70,150,10,-1,144,151,140,-1,79,150,81,-1,79,10,150,-1,90,83,85,-1,85,6,90,-1,14,152,145,-1,153,118,117,-1,117,154,153,-1,115,117,113,-1,115,155,117,-1,156,68,112,-1,157,158,109,-1,158,159,109,-1,73,160,74,-1,74,161,69,-1,69,108,74,-1,161,162,163,-1,163,91,161,-1,107,58,104,-1,107,103,58,-1,104,38,40,-1,77,164,75,-1,164,71,75,-1,58,64,6,-1,57,65,58,-1,165,37,36,-1,165,166,37,-1,102,101,167,-1,101,100,41,-1,105,1,0,-1,99,168,97,-1,32,42,33,-1,169,94,31,-1,52,170,171,-1,171,93,52,-1,169,82,88,-1,172,50,88,-1,56,69,55,-1,129,27,130,-1,6,39,58,-1,172,88,87,-1,23,173,127,-1,174,166,165,-1,175,61,77,-1,59,103,60,-1,6,64,7,-1,48,164,89,-1,48,71,164,-1,81,29,28,-1,90,12,11,-1,153,176,118,-1,176,177,118,-1,178,2,156,-1,178,157,2,-1,175,77,76,-1,60,62,57,-1,57,59,60,-1,63,77,61,-1,49,54,47,-1,49,56,54,-1,87,86,92,-1,55,91,53,-1,42,44,45,-1,42,32,43,-1,38,104,39,-1,39,6,36,-1,126,23,21,-1,25,179,26,-1,26,179,19,-1,128,143,141,-1,142,127,173,-1,12,152,13,-1,12,180,152,-1,122,136,143,-1,5,4,134,-1,4,148,134,-1,8,180,12,-1,111,102,96,-1,119,113,117,-1,149,130,151,-1,130,149,132,-1,135,148,146,-1,134,148,135,-1,136,121,137,-1,121,136,122,-1,14,13,152,-1,13,14,16,-1,17,141,18,-1,128,141,17,-1,141,136,138,-1,136,141,143,-1,27,18,140,-1,27,19,18,-1,25,181,20,-1,181,25,80,-1,33,46,182,-1,46,33,42,-1,183,184,125,-1,184,183,185,-1,186,95,35,-1,186,187,95,-1,174,99,166,-1,99,174,168,-1,172,92,188,-1,172,87,92,-1,105,67,1,-1,105,100,67,-1,178,158,157,-1,178,189,158,-1,176,190,98,-1,153,190,176,-1,191,171,170,-1,191,119,171,-1,114,163,162,-1,114,116,163,-1,160,155,115,-1,155,160,73,-1,96,190,111,-1,96,98,190,-1,43,34,177,-1,34,43,32,-1,54,92,47,-1,54,188,92,-1,89,192,108,-1,89,164,192,-1,65,62,66,-1,65,57,62,-1,120,142,173,-1,122,142,120,-1,94,88,50,-1,88,94,169,-1,188,53,51,-1,54,53,188,-1,177,93,171,-1,34,93,177,-1,31,82,169,-1,31,29,82,-1,98,46,45,-1,97,46,98,-1,174,187,186,-1,187,174,84,-1,6,165,36,-1,6,85,165,-1,61,66,62,-1,61,175,66,-1,55,161,91,-1,69,161,55,-1,192,159,72,-1,159,192,193,-1,160,161,74,-1,160,162,161,-1,72,158,73,-1,159,158,72,-1,194,111,190,-1,112,111,194,-1,154,190,153,-1,194,190,154,-1,117,189,154,-1,117,155,189,-1,16,195,11,-1,195,16,15,-1,95,30,29,-1,95,185,30,-1,173,195,120,-1,124,195,173,-1,184,84,83,-1,184,187,84,-1,24,10,79,-1,24,131,10,-1,48,150,70,-1,48,86,150,-1,133,5,134,-1,5,133,70,-1,151,147,149,-1,144,147,151,-1,180,145,152,-1,145,180,146,-1,144,145,147,-1,144,139,145,-1,139,14,145,-1,139,137,14,-1,70,75,71,-1,70,133,75,-1,26,131,24,-1,26,129,131,-1,82,150,86,-1,81,150,82,-1,124,23,126,-1,124,173,23,-1,83,125,184,-1,123,125,83,-1,11,124,123,-1,11,195,124,-1,185,181,30,-1,185,183,181,-1,20,183,21,-1,20,181,183,-1,15,120,195,-1,121,120,15,-1,113,191,116,-1,113,119,191,-1,154,178,194,-1,154,189,178,-1,156,194,178,-1,194,156,112,-1,109,2,157,-1,109,110,2,-1,0,107,104,-1,0,110,107,-1,193,109,159,-1,106,109,193,-1,164,193,192,-1,193,164,77,-1,103,63,60,-1,103,78,63,-1,166,167,37,-1,167,166,102,-1,37,101,41,-1,167,101,37,-1,176,43,177,-1,176,44,43,-1,34,94,93,-1,94,34,31,-1,52,163,170,-1,52,91,163,-1,165,84,174,-1,85,84,165,-1,79,28,80,-1,79,81,28,-1,77,106,193,-1,77,78,106,-1,108,72,74,-1,108,192,72,-1,45,176,98,-1,176,45,44,-1,102,68,67,-1,68,102,111,-1,160,114,162,-1,115,114,160,-1,116,170,163,-1,116,191,170,-1,171,118,177,-1,119,118,171,-1,1,156,2,-1,68,156,1,-1,73,189,155,-1,189,73,158,-1,7,175,76,-1,175,7,66,-1,51,172,188,-1,50,172,51,-1,99,102,166,-1,96,102,99,-1,168,186,182,-1,174,186,168,-1,41,105,40,-1,41,100,105,-1,35,182,186,-1,35,33,182,-1,187,185,95,-1,187,184,185,-1,125,21,183,-1,125,126,21,-1,97,182,46,-1,97,168,182,-1,80,30,181,-1,30,80,28,-1,17,179,22,-1,19,179,17,-1,20,179,25,-1,20,22,179,-1,128,22,23,-1,22,128,17,-1,127,143,128,-1,127,142,143,-1,121,14,137,-1,15,14,121,-1,8,146,180,-1,135,146,8,-1,151,27,140,-1,27,151,130,-1,4,132,149,-1,132,4,3,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfdphal_Coord',point=[(-2.53596,.13913,2.94032),(-2.52526,.16426,2.92459),(-2.4465,.13079,2.94363),(-2.45779,.07478,3.52595),(-2.46685,.06674,3.52491),(-2.45414,.06955,3.51491),(-2.55579,.14555,3.32535),(-2.52337,.08654,3.35936),(-2.56889,.13841,3.41763),(-2.5312,.10615,3.43581),(-2.44151,.10878,3.53116),(-2.57881,.1823,3.42706),(-2.58789,.15399,3.40478),(-2.63751,.14234,3.43596),(-2.64822,.1455,3.48394),(-2.65122,.16277,3.48915),(-2.64783,.15543,3.46553),(-2.58491,.14889,3.70553),(-2.58827,.12655,3.70263),(-2.57109,.12903,3.69759),(-2.49873,.2059,3.60397),(-2.53021,.23511,3.59837),(-2.54977,.20077,3.67328),(-2.58419,.2246,3.6628),(-2.48438,.14767,3.58781),(-2.4857,.1807,3.5991),(-2.53134,.13184,3.63553),(-2.56325,.09187,3.66041),(-2.41386,.17568,3.46569),(-2.36238,.18883,3.35147),(-2.42498,.19947,3.45432),(-2.28028,.23236,3.22792),(-2.34825,.35231,3.14136),(-2.37029,.30994,3.18348),(-2.21928,.26876,3.15304),(-2.3844,.29125,3.21306),(-2.57729,.14642,3.20446),(-2.5896,.18051,3.07695),(-2.59851,.13796,3.16624),(-2.58681,.12779,3.21568),(-2.61911,.13974,3.07454),(-2.61979,.14937,3.07273),(-2.35628,.35353,3.13797),(-2.34439,.35417,3.13747),(-2.35043,.3577,3.12896),(-2.36258,.35574,3.13246),(-2.36803,.35363,3.13683),(-2.22599,.02529,3.31862),(-2.33067,.04584,3.37943),(-2.21861,.01094,3.29466),(-2.12907,.0924,3.24631),(-2.11347,.07753,3.23301),(-2.0571,.11536,3.15527),(-2.11377,.05388,3.22277),(-2.12974,.02879,3.27993),(-2.1239,.03909,3.21688),(-2.14004,.0198,3.26655),(-2.57495,.06346,3.28982),(-2.59874,.0651,3.22042),(-2.57292,.05799,3.28304),(-2.53478,.04596,3.32297),(-2.464,.0363,3.30839),(-2.53305,.05199,3.33193),(-2.46543,.0323,3.29946),(-2.56605,.09293,3.30284),(-2.57175,.07164,3.29348),(-2.52583,.07086,3.34035),(-2.53208,.17778,2.9265),(-2.51809,.17851,2.92499),(-2.17028,.00166,3.19256),(-2.42689,.07651,3.47943),(-2.38802,.04367,3.3669),(-2.25931,.0763,3.05011),(-2.22126,.11682,2.98664),(-2.20121,.07017,3.06231),(-2.44736,.04205,3.3539),(-2.45477,.04776,3.32784),(-2.41174,.02953,3.23328),(-2.46366,.03297,3.22623),(-2.44606,.15504,3.53459),(-2.45071,.18673,3.53672),(-2.40968,.14701,3.47329),(-2.32179,.12811,3.38112),(-2.52319,.21185,3.4042),(-2.47733,.23551,3.30588),(-2.50849,.21576,3.30293),(-2.31224,.0761,3.39613),(-2.21719,.07229,3.32184),(-2.1936,.09595,3.28248),(-2.3053,.01687,3.26677),(-2.57223,.17363,3.40488),(-2.06243,.06677,3.12442),(-2.22597,.04965,3.33055),(-2.13339,.19604,3.16119),(-2.20641,.16587,3.23301),(-2.42312,.25287,3.318),(-2.50502,.26207,2.9912),(-2.43411,.32531,3.11393),(-2.42022,.32861,3.04347),(-2.49972,.25687,3.07591),(-2.55371,.17002,2.9305),(-2.55461,.20224,2.94443),(-2.51714,.24762,2.97921),(-2.52652,.04014,3.21914),(-2.57342,.11403,3.07783),(-2.55016,.15681,2.92969),(-2.43873,.05247,3.122),(-2.49889,.0887,3.11571),(-2.26188,.02655,3.1604),(-2.39745,.09114,3.01803),(-2.47225,.12106,2.9972),(-2.50598,.24637,2.97697),(-2.4764,.19801,2.96287),(-2.11431,.14801,3.0497),(-2.08826,.06765,3.0154),(-2.1267,.09745,2.99618),(-2.04387,.08464,3.05485),(-2.19495,.21106,3.04136),(-2.17483,.29636,3.08172),(-2.10024,.20792,3.10079),(-2.65315,.17645,3.59553),(-2.66823,.15716,3.572),(-2.67184,.16278,3.63413),(-2.53862,.22016,3.46363),(-2.58411,.23069,3.57003),(-2.5031,.24638,3.50135),(-2.54579,.2398,3.59159),(-2.62646,.2124,3.67308),(-2.60946,.17039,3.69323),(-2.52252,.08604,3.62849),(-2.50763,.05953,3.62128),(-2.4749,.09986,3.57505),(-2.47617,.05365,3.56038),(-2.48462,.06416,3.45478),(-2.49964,.06179,3.50868),(-2.54085,.11311,3.48407),(-2.66804,.14225,3.63103),(-2.66515,.13738,3.5726),(-2.63466,.10591,3.64908),(-2.60722,.0984,3.58255),(-2.58475,.08692,3.66293),(-2.62445,.1534,3.68834),(-2.64646,.19901,3.66764),(-2.63576,.16747,3.68325),(-2.53612,.05324,3.60885),(-2.58305,.10131,3.52894),(-2.55243,.11583,3.49475),(-2.51307,.05193,3.55225),(-2.5043,.05699,3.52458),(-2.48611,.04326,3.55601),(-2.40472,.10429,3.48442),(-2.51841,.04776,3.61532),(-2.6335,.1236,3.44906),(-2.30374,.33969,3.04211),(-2.30017,.242,3.02733),(-2.21211,.13517,2.98421),(-2.44327,.14856,2.94215),(-2.36216,.10982,2.95697),(-2.2851,.12046,2.96849),(-2.31757,.0824,3.03791),(-2.13518,.08313,2.99835),(-2.11568,.01515,3.08325),(-2.09012,.05131,3.01885),(-2.04188,.06749,3.06551),(-2.35801,.02305,3.25013),(-2.51554,.22077,3.18729),(-2.52345,.23039,3.09635),(-2.58708,.18385,3.0621),(-2.43792,.29322,3.15965),(-2.2306,.15851,3.25874),(-2.03583,.12371,3.1181),(-2.10137,.21113,3.12136),(-2.13979,.06804,3.29059),(-2.61929,.22117,3.63366),(-2.44526,.27394,3.19693),(-2.46087,.0445,3.31204),(-2.30823,.35461,3.05843),(-2.17951,.30265,3.0984),(-2.35885,.12822,2.95234),(-2.53773,.17394,3.66517),(-2.58514,.14321,3.41786),(-2.46145,.21274,3.53111),(-2.39446,.31321,3.1738),(-2.48362,.24121,3.51413),(-2.47705,.23469,3.42125),(-2.45464,.23028,3.42963),(-2.40866,.29333,3.20405),(-2.44642,.25564,3.30992),(-2.12888,.04715,3.29107),(-2.28182,.13906,2.96433),(-2.41076,.31577,3.02726),(-2.04152,.13235,3.09614),(-2.31537,.03804,3.14842),(-2.36896,.04951,3.13645),(-2.39584,.21776,3.00587),(-2.61904,.19558,3.53644)]))),
        Shape(DEF='rfdphal2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfdphal2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,11,0,9,-1,12,13,14,-1,15,16,17,-1,18,8,5,-1,19,20,21,-1,20,22,21,-1,23,24,25,-1,25,26,23,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,35,40,-1,41,32,31,-1,42,43,44,-1,42,19,43,-1,35,45,33,-1,46,17,47,-1,17,16,47,-1,6,8,1,-1,48,18,49,-1,18,50,49,-1,51,52,53,-1,51,26,52,-1,54,55,56,-1,57,58,13,-1,57,59,58,-1,60,49,61,-1,60,62,49,-1,2,9,0,-1,18,63,64,-1,65,46,47,-1,47,66,65,-1,30,32,67,-1,68,29,52,-1,38,33,69,-1,29,70,53,-1,71,19,21,-1,71,43,19,-1,72,73,74,-1,72,75,73,-1,14,76,77,-1,77,78,14,-1,24,79,80,-1,79,81,80,-1,82,25,24,-1,24,80,82,-1,83,84,85,-1,83,86,84,-1,20,87,88,-1,88,22,20,-1,89,90,91,-1,73,81,79,-1,73,75,81,-1,92,71,93,-1,94,45,35,-1,36,38,69,-1,27,29,68,-1,55,65,66,-1,66,56,55,-1,15,17,95,-1,18,48,63,-1,1,0,6,-1,96,60,95,-1,60,61,95,-1,12,97,9,-1,71,92,43,-1,92,98,43,-1,67,32,27,-1,51,53,99,-1,66,100,101,-1,101,56,66,-1,54,5,4,-1,47,100,66,-1,47,16,100,-1,10,102,103,-1,103,11,10,-1,104,105,31,-1,106,107,70,-1,107,108,70,-1,109,39,110,-1,111,38,37,-1,37,112,113,-1,38,34,33,-1,35,39,94,-1,32,28,27,-1,29,53,52,-1,74,69,33,-1,74,73,69,-1,67,114,30,-1,67,115,114,-1,116,117,118,-1,116,119,117,-1,77,75,78,-1,77,81,75,-1,64,2,1,-1,64,57,2,-1,97,120,10,-1,10,9,97,-1,120,97,44,-1,121,103,102,-1,102,122,121,-1,122,102,98,-1,9,2,12,-1,4,103,121,-1,103,4,3,-1,64,8,18,-1,8,64,1,-1,5,50,18,-1,5,101,50,-1,42,75,72,-1,78,75,42,-1,77,80,81,-1,77,91,80,-1,90,123,82,-1,124,123,90,-1,125,126,127,-1,125,128,126,-1,118,129,130,-1,129,118,117,-1,127,119,116,-1,127,126,119,-1,131,132,133,-1,132,131,134,-1,135,68,136,-1,68,135,27,-1,74,45,87,-1,45,74,33,-1,67,135,115,-1,135,67,27,-1,79,23,36,-1,79,24,23,-1,87,94,88,-1,87,45,94,-1,40,137,138,-1,139,137,40,-1,111,113,140,-1,37,113,111,-1,105,41,31,-1,105,141,41,-1,34,111,139,-1,34,38,111,-1,108,53,70,-1,108,99,53,-1,141,106,41,-1,141,107,106,-1,110,141,105,-1,138,141,110,-1,3,11,103,-1,11,3,7,-1,102,120,98,-1,120,102,10,-1,54,101,5,-1,56,101,54,-1,142,85,143,-1,142,62,85,-1,89,124,90,-1,89,84,124,-1,116,135,127,-1,116,115,135,-1,144,145,146,-1,145,144,147,-1,92,122,98,-1,92,148,122,-1,39,134,94,-1,134,39,109,-1,149,148,92,-1,150,148,149,-1,60,85,62,-1,60,83,85,-1,145,151,152,-1,145,153,151,-1,17,96,95,-1,96,17,153,-1,63,142,59,-1,48,142,63,-1,49,154,61,-1,49,50,154,-1,15,61,154,-1,61,15,95,-1,55,150,65,-1,148,150,55,-1,109,132,134,-1,109,104,132,-1,23,37,36,-1,23,112,37,-1,28,41,106,-1,28,32,41,-1,99,140,113,-1,99,108,140,-1,138,107,141,-1,137,107,138,-1,129,93,155,-1,129,156,93,-1,58,89,76,-1,58,143,89,-1,131,22,88,-1,131,157,22,-1,97,14,44,-1,97,12,14,-1,158,149,156,-1,158,152,149,-1,114,130,133,-1,114,118,130,-1,146,117,119,-1,146,158,117,-1,127,136,125,-1,136,127,135,-1,86,147,144,-1,86,83,147,-1,124,86,128,-1,86,124,84,-1,123,136,159,-1,123,125,136,-1,128,144,126,-1,128,86,144,-1,146,152,158,-1,152,146,145,-1,118,115,116,-1,114,115,118,-1,158,129,117,-1,156,129,158,-1,92,156,149,-1,93,156,92,-1,157,133,130,-1,157,131,133,-1,91,76,89,-1,91,77,76,-1,13,76,14,-1,13,58,76,-1,78,44,14,-1,44,78,42,-1,155,71,21,-1,71,155,93,-1,108,137,140,-1,108,107,137,-1,51,113,112,-1,99,113,51,-1,106,29,28,-1,106,70,29,-1,26,112,23,-1,26,51,112,-1,132,31,30,-1,132,104,31,-1,65,151,46,-1,65,150,151,-1,54,121,55,-1,54,4,121,-1,64,59,57,-1,63,59,64,-1,122,55,121,-1,122,148,55,-1,46,153,17,-1,153,46,151,-1,83,96,147,-1,83,60,96,-1,59,143,58,-1,59,142,143,-1,152,150,149,-1,151,150,152,-1,147,153,145,-1,153,147,96,-1,119,144,146,-1,119,126,144,-1,159,82,123,-1,25,82,159,-1,143,84,89,-1,143,85,84,-1,62,48,49,-1,142,48,62,-1,87,72,74,-1,87,20,72,-1,98,44,43,-1,44,98,120,-1,5,7,3,-1,7,5,8,-1,109,105,104,-1,105,109,110,-1,139,35,34,-1,40,35,139,-1,140,139,111,-1,140,137,139,-1,40,110,39,-1,40,138,110,-1,136,52,159,-1,136,68,52,-1,133,30,114,-1,133,132,30,-1,36,73,79,-1,69,73,36,-1,26,159,52,-1,159,26,25,-1,88,134,131,-1,134,88,94,-1,130,155,157,-1,155,130,129,-1,123,128,125,-1,128,123,124,-1,91,82,80,-1,90,82,91,-1,20,42,72,-1,42,20,19,-1,157,21,22,-1,21,157,155,-1,154,101,100,-1,154,50,101,-1,100,15,154,-1,100,16,15,-1,13,2,57,-1,2,13,12,-1,7,0,11,-1,0,7,6,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfdphal2_Coord',point=[(-3.30483,.05964,3.73979),(-3.33807,.04825,3.73894),(-3.32998,.08492,3.67423),(-3.31503,.05541,3.78266),(-3.32435,.06516,3.78822),(-3.36532,.0312,3.7946),(-3.31334,.04067,3.75713),(-3.31034,.04179,3.7632),(-3.36104,.02388,3.78908),(-3.31757,.09875,3.67754),(-3.31487,.10605,3.67922),(-3.2999,.06437,3.74339),(-3.31196,.09139,3.62315),(-3.31535,.08232,3.61959),(-3.27403,.10057,3.56963),(-3.48632,.07885,3.73946),(-3.48196,.09116,3.75316),(-3.50283,.10696,3.70555),(-3.36645,.01746,3.78768),(-3.21099,.15896,3.54791),(-3.19082,.16076,3.53123),(-3.25655,.22853,3.54973),(-3.24211,.23854,3.52456),(-3.2721,.03355,3.43476),(-3.27412,.02076,3.44475),(-3.33609,.01227,3.42998),(-3.33076,.03296,3.42239),(-3.47118,.11018,3.43395),(-3.43426,.11208,3.44093),(-3.42552,.09188,3.43961),(-3.4519,.18125,3.42862),(-3.40601,.17142,3.44017),(-3.43309,.14369,3.44185),(-3.18129,.13279,3.50431),(-3.24802,.12703,3.48688),(-3.25548,.15809,3.47837),(-3.224,.06356,3.46425),(-3.26388,.08008,3.46303),(-3.24628,.10293,3.47995),(-3.27648,.18287,3.46537),(-3.27516,.15599,3.474),(-3.39825,.14518,3.45018),(-3.20805,.13339,3.5446),(-3.27006,.15326,3.58835),(-3.26928,.1252,3.58),(-3.18587,.15573,3.5046),(-3.48934,.14289,3.71363),(-3.47914,.11689,3.76219),(-3.37555,0,3.71753),(-3.42378,.00573,3.71141),(-3.40353,.0324,3.78216),(-3.34194,.05726,3.4343),(-3.40324,.04841,3.4277),(-3.38344,.0723,3.43566),(-3.36408,.0918,3.78301),(-3.36576,.15165,3.74365),(-3.38688,.10018,3.77997),(-3.3365,.07102,3.66911),(-3.32405,.05786,3.60869),(-3.33895,.04546,3.6567),(-3.44421,.06424,3.65045),(-3.46326,.03234,3.71253),(-3.41377,.03481,3.64318),(-3.35065,.01777,3.72723),(-3.34775,.03997,3.73356),(-3.44526,.16761,3.73115),(-3.44482,.12222,3.77489),(-3.4824,.14192,3.43365),(-3.45042,.08196,3.43544),(-3.17759,.10847,3.50253),(-3.38596,.09403,3.44714),(-3.30407,.19718,3.58668),(-3.18611,.13438,3.53017),(-3.17654,.10628,3.51224),(-3.17814,.13187,3.51603),(-3.18914,.10636,3.52229),(-3.29197,.06345,3.55252),(-3.24963,.05157,3.4996),(-3.21139,.10563,3.5351),(-3.227,.05505,3.47116),(-3.28536,.02072,3.45702),(-3.23497,.04854,3.48195),(-3.33992,.01052,3.44526),(-3.43622,.07521,3.58694),(-3.40332,.04504,3.53021),(-3.40548,.04707,3.58988),(-3.44632,.07038,3.52876),(-3.18472,.15923,3.51872),(-3.21832,.22892,3.50162),(-3.35175,.03772,3.52878),(-3.34385,.01508,3.46756),(-3.2964,.02556,3.47793),(-3.34603,.17855,3.63083),(-3.33804,.20657,3.58006),(-3.21724,.21265,3.48299),(-3.4971,.06929,3.70594),(-3.46216,.09239,3.64953),(-3.30506,.10899,3.62928),(-3.30453,.14192,3.636),(-3.3439,.07489,3.44308),(-3.44013,.0688,3.7757),(-3.3989,.04568,3.78988),(-3.31609,.12266,3.68296),(-3.29566,.09079,3.75075),(-3.36659,.19938,3.43926),(-3.36071,.17672,3.44815),(-3.39134,.11573,3.45224),(-3.34838,.1194,3.46323),(-3.3461,.09628,3.45299),(-3.31785,.19994,3.44435),(-3.3158,.17823,3.45364),(-3.26909,.10152,3.47323),(-3.29271,.05981,3.44752),(-3.29936,.07561,3.4535),(-3.47293,.19636,3.44112),(-3.50485,.13962,3.44762),(-3.507,.13752,3.47171),(-3.47802,.19569,3.51123),(-3.47791,.20404,3.48339),(-3.49932,.13388,3.49758),(-3.3037,.11675,3.63133),(-3.30253,.10495,3.75491),(-3.32141,.13009,3.68277),(-3.40962,.0284,3.45394),(-3.40788,.03067,3.4778),(-3.46797,.06288,3.46258),(-3.48602,.09852,3.49124),(-3.49206,.09802,3.46675),(-3.46301,.06386,3.48597),(-3.40676,.24474,3.52484),(-3.40279,.25275,3.49588),(-3.30514,.24715,3.45662),(-3.37575,.22723,3.42578),(-3.38602,.24417,3.43852),(-3.30141,.22792,3.44108),(-3.4903,.10028,3.44576),(-3.46658,.0653,3.44469),(-3.3093,.12252,3.47158),(-3.31403,.15173,3.46666),(-3.27225,.1253,3.48054),(-3.30681,.09906,3.46251),(-3.35395,.14936,3.46001),(-3.37378,.02614,3.6442),(-3.36451,.03692,3.59222),(-3.46285,.10407,3.53825),(-3.46485,.13447,3.59677),(-3.4703,.14302,3.5453),(-3.45518,.10288,3.59123),(-3.35875,.15879,3.67519),(-3.41272,.18917,3.62006),(-3.42163,.17321,3.66884),(-3.45994,.15688,3.65733),(-3.45364,.16917,3.60382),(-3.47081,.12445,3.64984),(-3.43807,.05109,3.76842),(-3.32999,.24947,3.53437),(-3.40416,.21,3.56768),(-3.32219,.25763,3.50579),(-3.4577,.18831,3.55003),(-3.40482,.02989,3.43605)]))),
        Shape(DEF='rfdphal3',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfdphal3_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,2,7,-1,8,9,10,-1,11,4,12,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,24,29,30,-1,21,20,31,-1,32,25,24,-1,9,33,34,-1,9,8,33,-1,11,0,35,-1,36,37,38,-1,16,39,40,-1,39,41,40,-1,42,43,44,-1,45,46,47,-1,46,48,47,-1,49,50,51,-1,51,52,49,-1,49,53,54,-1,49,52,53,-1,55,37,56,-1,37,57,56,-1,2,58,0,-1,59,60,12,-1,10,61,57,-1,57,62,10,-1,33,63,64,-1,64,34,33,-1,65,66,67,-1,65,68,66,-1,21,69,22,-1,18,39,70,-1,25,71,27,-1,72,41,18,-1,73,74,75,-1,73,76,74,-1,77,78,79,-1,78,80,79,-1,81,82,13,-1,82,83,13,-1,84,14,13,-1,13,83,84,-1,85,86,48,-1,48,46,85,-1,87,88,86,-1,86,85,87,-1,89,90,91,-1,89,92,90,-1,93,94,95,-1,93,96,94,-1,95,52,97,-1,95,53,52,-1,98,99,100,-1,99,101,100,-1,102,103,104,-1,82,81,78,-1,78,77,82,-1,75,97,52,-1,32,24,105,-1,27,71,28,-1,18,70,19,-1,9,61,10,-1,38,59,12,-1,58,35,0,-1,106,60,59,-1,106,107,60,-1,56,61,108,-1,56,57,61,-1,52,73,75,-1,52,51,73,-1,21,19,69,-1,41,109,40,-1,38,37,110,-1,37,55,110,-1,111,112,63,-1,112,43,63,-1,4,3,44,-1,111,63,33,-1,8,111,33,-1,113,114,6,-1,6,115,113,-1,116,20,68,-1,30,117,65,-1,27,26,118,-1,119,120,26,-1,121,30,29,-1,121,117,30,-1,23,25,27,-1,30,105,24,-1,17,19,21,-1,41,39,18,-1,89,91,69,-1,91,22,69,-1,96,90,92,-1,92,122,96,-1,79,76,123,-1,79,100,76,-1,8,10,62,-1,62,111,8,-1,107,0,60,-1,107,1,0,-1,107,124,1,-1,114,58,2,-1,2,6,114,-1,125,11,35,-1,115,51,50,-1,38,12,36,-1,3,113,126,-1,3,5,113,-1,58,125,35,-1,114,125,58,-1,60,11,12,-1,60,0,11,-1,4,36,12,-1,4,112,36,-1,101,76,100,-1,101,74,76,-1,123,77,79,-1,77,123,127,-1,128,83,82,-1,128,103,83,-1,84,129,130,-1,84,102,129,-1,131,132,133,-1,134,132,131,-1,90,93,135,-1,90,96,93,-1,133,122,92,-1,132,122,133,-1,136,66,137,-1,136,67,66,-1,138,70,139,-1,138,19,70,-1,25,98,80,-1,98,25,32,-1,89,19,138,-1,89,69,19,-1,81,15,28,-1,13,15,81,-1,105,98,32,-1,98,105,99,-1,140,121,29,-1,141,121,140,-1,142,26,120,-1,142,118,26,-1,116,31,20,-1,143,31,116,-1,27,140,23,-1,27,118,140,-1,72,109,41,-1,144,109,72,-1,143,145,31,-1,143,146,145,-1,117,143,116,-1,143,117,121,-1,5,114,113,-1,5,125,114,-1,115,7,51,-1,115,6,7,-1,123,73,147,-1,76,73,123,-1,44,112,4,-1,112,44,43,-1,88,110,55,-1,110,88,148,-1,104,129,102,-1,104,87,129,-1,92,138,133,-1,89,138,92,-1,30,67,105,-1,30,65,67,-1,107,149,124,-1,106,149,107,-1,86,55,56,-1,86,88,55,-1,47,150,151,-1,152,150,47,-1,9,108,61,-1,9,152,108,-1,59,110,106,-1,110,59,38,-1,36,57,37,-1,36,62,57,-1,42,54,64,-1,54,42,49,-1,119,28,15,-1,119,26,28,-1,21,145,17,-1,21,31,145,-1,144,120,109,-1,144,142,120,-1,143,141,146,-1,143,121,141,-1,93,97,153,-1,95,97,93,-1,154,128,127,-1,155,128,154,-1,149,104,155,-1,148,104,149,-1,136,101,99,-1,136,156,101,-1,154,7,124,-1,154,147,7,-1,94,53,95,-1,94,151,53,-1,90,137,91,-1,90,135,137,-1,45,96,122,-1,45,94,96,-1,133,139,131,-1,133,138,139,-1,129,85,134,-1,129,87,85,-1,157,131,139,-1,131,157,130,-1,134,46,132,-1,85,46,134,-1,45,151,94,-1,45,47,151,-1,137,156,136,-1,137,135,156,-1,103,155,104,-1,128,155,103,-1,124,155,154,-1,149,155,124,-1,147,127,123,-1,154,127,147,-1,153,75,74,-1,153,97,75,-1,146,142,144,-1,146,141,142,-1,109,119,40,-1,120,119,109,-1,145,18,17,-1,72,18,145,-1,16,119,15,-1,40,119,16,-1,66,20,22,-1,68,20,66,-1,64,43,42,-1,64,63,43,-1,64,150,34,-1,64,54,150,-1,44,126,42,-1,44,3,126,-1,50,42,126,-1,49,42,50,-1,34,152,9,-1,34,150,152,-1,56,48,86,-1,56,108,48,-1,106,148,149,-1,110,148,106,-1,2,124,7,-1,2,1,124,-1,151,54,53,-1,54,151,150,-1,152,48,108,-1,47,48,152,-1,122,46,45,-1,122,132,46,-1,157,84,130,-1,84,157,14,-1,148,87,104,-1,148,88,87,-1,98,79,80,-1,98,100,79,-1,147,51,7,-1,73,51,147,-1,5,11,125,-1,5,4,11,-1,65,116,68,-1,65,117,116,-1,144,145,146,-1,144,72,145,-1,29,23,140,-1,24,23,29,-1,141,118,142,-1,141,140,118,-1,80,71,25,-1,78,71,80,-1,139,39,157,-1,139,70,39,-1,137,22,91,-1,137,66,22,-1,28,78,81,-1,78,28,71,-1,14,39,16,-1,39,14,157,-1,99,67,136,-1,99,105,67,-1,135,153,156,-1,135,93,153,-1,130,134,131,-1,130,129,134,-1,103,84,83,-1,84,103,102,-1,127,82,77,-1,82,127,128,-1,156,74,101,-1,156,153,74,-1,62,112,111,-1,36,112,62,-1,115,126,113,-1,115,50,126,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfdphal3_Coord',point=[(-3.82482,.09214,3.27808),(-3.8113,.12021,3.23268),(-3.81096,.14349,3.23897),(-3.83677,.11491,3.32766),(-3.86882,.07822,3.3334),(-3.82816,.10595,3.32179),(-3.81038,.14925,3.24043),(-3.79628,.15294,3.21001),(-3.95329,.12876,3.2942),(-3.95152,.14308,3.24714),(-3.95122,.11639,3.28023),(-3.86392,.07134,3.32767),(-3.8679,.06455,3.32615),(-3.76036,.05876,3.03926),(-3.80642,.04641,3.02387),(-3.75828,.07177,3.02946),(-3.80026,.06751,3.01662),(-3.86442,.13988,3.02692),(-3.85866,.12057,3.02325),(-3.89803,.13561,3.01995),(-3.84829,.19958,3.04249),(-3.86456,.17073,3.03624),(-3.89012,.20685,3.02767),(-3.74016,.16684,3.06887),(-3.74787,.19679,3.0674),(-3.69881,.17731,3.07098),(-3.74835,.11876,3.05282),(-3.73744,.14303,3.06203),(-3.72231,.10511,3.04883),(-3.75934,.19303,3.06989),(-3.76436,.21929,3.06717),(-3.83692,.17405,3.04991),(-3.70504,.1996,3.07415),(-3.95571,.15427,3.30386),(-3.94539,.17967,3.25603),(-3.82036,.0918,3.29591),(-3.89652,.07674,3.32122),(-3.89063,.04933,3.24997),(-3.85492,.04738,3.25566),(-3.84945,.07844,3.01656),(-3.80255,.09086,3.02866),(-3.82946,.10333,3.02674),(-3.85909,.19796,3.28552),(-3.88474,.14724,3.32499),(-3.86779,.14058,3.32768),(-3.89495,.16602,3.14327),(-3.88567,.12808,3.13452),(-3.89655,.16285,3.17782),(-3.88533,.1324,3.17116),(-3.841,.19984,3.23835),(-3.81713,.17405,3.24499),(-3.80038,.1815,3.21643),(-3.82823,.21492,3.21239),(-3.87149,.22077,3.20228),(-3.88476,.20948,3.23272),(-3.86622,.07338,3.20355),(-3.88976,.10018,3.21175),(-3.92167,.07251,3.25201),(-3.81059,.11134,3.27901),(-3.83842,.06689,3.26566),(-3.82741,.08387,3.27244),(-3.94666,.10629,3.24655),(-3.9207,.09271,3.30816),(-3.93035,.16239,3.31646),(-3.91729,.2076,3.27389),(-3.79427,.23304,3.05662),(-3.84396,.25689,3.03603),(-3.79111,.26194,3.05441),(-3.8269,.22949,3.04907),(-3.90961,.16587,3.02754),(-3.88129,.10924,3.01634),(-3.69385,.15326,3.07028),(-3.82736,.12456,3.03959),(-3.77423,.18955,3.1868),(-3.77004,.26451,3.15231),(-3.79982,.23071,3.18779),(-3.729,.1999,3.12986),(-3.70479,.15017,3.09165),(-3.69454,.15099,3.08026),(-3.7066,.17804,3.09962),(-3.6984,.17638,3.08282),(-3.72496,.09626,3.0568),(-3.7313,.08908,3.0689),(-3.7672,.05788,3.05157),(-3.80744,.04422,3.03905),(-3.87369,.09594,3.12366),(-3.87023,.10651,3.16591),(-3.84485,.07393,3.12477),(-3.85099,.08093,3.16821),(-3.9279,.16157,3.0434),(-3.91108,.22655,3.08331),(-3.91023,.22025,3.04045),(-3.92528,.15878,3.06818),(-3.86887,.27102,3.12969),(-3.8939,.21169,3.14975),(-3.86177,.23693,3.16901),(-3.90841,.21785,3.11091),(-3.82038,.23789,3.18201),(-3.70693,.20279,3.0897),(-3.73918,.26832,3.0975),(-3.71335,.20354,3.1054),(-3.75914,.27562,3.12628),(-3.80722,.04832,3.06143),(-3.7732,.06182,3.07255),(-3.80982,.07028,3.12364),(-3.73372,.25294,3.07444),(-3.81751,.08938,3.2169),(-3.81256,.11199,3.23005),(-3.90297,.12655,3.21163),(-3.80074,.10815,3.03848),(-3.83843,.06777,3.20411),(-3.92497,.11002,3.31589),(-3.89489,.09024,3.32924),(-3.80896,.14254,3.29072),(-3.80845,.1163,3.28271),(-3.81334,.16706,3.24498),(-3.81656,.20735,3.05614),(-3.78776,.21171,3.06305),(-3.75155,.13972,3.06271),(-3.76836,.09647,3.04258),(-3.77109,.11167,3.04947),(-3.78205,.18563,3.07195),(-3.91538,.15527,3.09431),(-3.72346,.17518,3.12138),(-3.7981,.12671,3.20047),(-3.81973,.09301,3.30197),(-3.81557,.15603,3.29526),(-3.72164,.14772,3.11026),(-3.74194,.091,3.08762),(-3.84959,.05951,3.07031),(-3.85377,.05745,3.04487),(-3.89331,.08813,3.04812),(-3.90251,.12138,3.08458),(-3.91049,.12104,3.05685),(-3.88638,.08883,3.07581),(-3.86765,.27944,3.10279),(-3.79815,.28053,3.07006),(-3.85559,.27285,3.04836),(-3.91309,.12402,3.03359),(-3.89534,.09118,3.02762),(-3.75461,.16303,3.07125),(-3.77645,.15724,3.07216),(-3.77454,.13431,3.06062),(-3.80658,.18074,3.06474),(-3.79974,.12906,3.05058),(-3.8299,.14553,3.04737),(-3.80035,.15159,3.06385),(-3.76879,.16207,3.17654),(-3.82435,.07379,3.17031),(-3.80123,.09732,3.18712),(-3.90872,.19035,3.22105),(-3.89439,.19794,3.18578),(-3.9114,.15751,3.21281),(-3.81846,.28059,3.14218),(-3.76748,.13755,3.16477),(-3.77455,.09964,3.14773),(-3.8132,.28928,3.11632),(-3.85264,.05953,3.02674)]))),
        Shape(DEF='rfdphal4',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfdphal4_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,2,7,-1,8,9,10,-1,4,11,12,-1,11,13,12,-1,14,4,12,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,20,22,21,-1,23,24,25,-1,23,26,24,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,34,39,40,-1,31,30,41,-1,17,42,43,-1,42,44,43,-1,26,35,34,-1,9,45,46,-1,9,8,45,-1,14,0,47,-1,13,48,49,-1,22,50,51,-1,50,52,51,-1,53,54,55,-1,56,57,58,-1,57,59,58,-1,56,58,60,-1,58,61,60,-1,62,63,64,-1,62,65,63,-1,66,48,67,-1,67,68,66,-1,2,69,0,-1,70,71,12,-1,46,45,72,-1,45,73,72,-1,74,75,76,-1,76,77,74,-1,31,78,32,-1,28,50,79,-1,35,80,37,-1,81,52,28,-1,82,83,84,-1,83,85,84,-1,86,87,88,-1,87,89,88,-1,90,91,19,-1,91,92,19,-1,93,86,65,-1,65,94,93,-1,95,20,19,-1,19,92,95,-1,96,97,98,-1,98,99,96,-1,100,101,102,-1,100,103,101,-1,104,58,105,-1,104,61,58,-1,23,25,15,-1,25,18,15,-1,106,107,93,-1,91,90,83,-1,83,82,91,-1,108,105,58,-1,28,27,109,-1,109,81,28,-1,26,34,24,-1,37,80,38,-1,28,79,29,-1,74,32,75,-1,74,30,32,-1,9,110,10,-1,49,70,12,-1,69,47,0,-1,64,71,70,-1,70,62,64,-1,68,110,111,-1,68,67,110,-1,2,1,63,-1,63,7,2,-1,58,42,108,-1,58,59,42,-1,31,29,78,-1,52,112,51,-1,49,48,66,-1,66,113,49,-1,4,3,55,-1,114,73,45,-1,8,114,45,-1,5,14,115,-1,5,4,14,-1,116,30,74,-1,117,81,109,-1,117,118,81,-1,40,119,77,-1,37,36,120,-1,121,122,36,-1,123,40,39,-1,123,119,40,-1,33,35,37,-1,40,24,34,-1,27,29,31,-1,52,50,28,-1,80,35,85,-1,85,83,80,-1,124,50,125,-1,124,79,50,-1,90,38,80,-1,80,83,90,-1,100,102,78,-1,102,32,78,-1,126,101,103,-1,103,127,126,-1,82,89,87,-1,87,91,82,-1,64,0,71,-1,64,1,0,-1,64,63,1,-1,6,128,2,-1,128,69,2,-1,115,14,47,-1,129,59,57,-1,49,12,13,-1,3,130,131,-1,3,5,130,-1,115,69,128,-1,115,47,69,-1,71,14,12,-1,71,0,14,-1,84,89,82,-1,84,43,89,-1,87,92,91,-1,87,107,92,-1,95,132,133,-1,95,106,132,-1,134,135,136,-1,137,135,134,-1,101,138,139,-1,101,126,138,-1,136,127,103,-1,135,127,136,-1,140,75,141,-1,140,76,75,-1,142,79,124,-1,142,29,79,-1,85,26,23,-1,85,35,26,-1,78,142,100,-1,78,29,142,-1,90,21,38,-1,19,21,90,-1,39,143,123,-1,143,39,144,-1,120,122,145,-1,122,120,36,-1,41,116,146,-1,41,30,116,-1,33,120,144,-1,33,37,120,-1,52,118,112,-1,118,52,81,-1,109,146,117,-1,146,109,41,-1,119,146,116,-1,146,119,123,-1,5,128,130,-1,5,115,128,-1,129,7,59,-1,129,6,7,-1,55,11,4,-1,11,55,54,-1,113,97,94,-1,113,66,97,-1,106,96,132,-1,93,96,106,-1,103,142,136,-1,100,142,103,-1,147,148,149,-1,147,150,148,-1,40,76,24,-1,40,77,76,-1,68,97,66,-1,98,97,68,-1,151,152,148,-1,151,153,152,-1,9,111,110,-1,9,151,111,-1,62,49,113,-1,62,70,49,-1,48,154,67,-1,48,13,154,-1,10,67,154,-1,10,110,67,-1,53,60,72,-1,60,53,56,-1,21,36,38,-1,121,36,21,-1,27,41,109,-1,27,31,41,-1,112,145,122,-1,118,145,112,-1,117,123,143,-1,117,146,123,-1,104,155,138,-1,104,105,155,-1,16,42,17,-1,42,16,108,-1,140,18,25,-1,140,156,18,-1,88,7,63,-1,88,44,7,-1,152,104,157,-1,152,61,104,-1,101,141,102,-1,101,139,141,-1,149,126,127,-1,149,157,126,-1,136,124,134,-1,136,142,124,-1,98,147,99,-1,98,150,147,-1,132,99,137,-1,132,96,99,-1,125,134,124,-1,134,125,133,-1,137,147,135,-1,99,147,137,-1,149,152,157,-1,149,148,152,-1,157,138,126,-1,138,157,104,-1,141,156,140,-1,141,139,156,-1,107,86,93,-1,87,86,107,-1,63,86,88,-1,65,86,63,-1,43,88,89,-1,88,43,44,-1,155,108,16,-1,155,105,108,-1,118,143,145,-1,118,117,143,-1,51,122,121,-1,122,51,112,-1,22,121,21,-1,51,121,22,-1,73,53,72,-1,53,73,54,-1,72,153,46,-1,72,60,153,-1,55,131,53,-1,55,3,131,-1,57,53,131,-1,56,53,57,-1,46,151,9,-1,46,153,151,-1,98,111,150,-1,68,111,98,-1,62,94,65,-1,113,94,62,-1,153,61,152,-1,60,61,153,-1,150,151,148,-1,150,111,151,-1,127,147,149,-1,127,135,147,-1,125,95,133,-1,95,125,20,-1,94,96,93,-1,94,97,96,-1,114,54,73,-1,114,11,54,-1,23,84,85,-1,23,15,84,-1,42,7,44,-1,42,59,7,-1,6,130,128,-1,129,130,6,-1,77,116,74,-1,77,119,116,-1,144,34,33,-1,34,144,39,-1,145,144,120,-1,145,143,144,-1,141,32,102,-1,141,75,32,-1,22,125,50,-1,22,20,125,-1,25,76,140,-1,25,24,76,-1,139,155,156,-1,139,138,155,-1,133,137,134,-1,133,132,137,-1,107,95,92,-1,95,107,106,-1,15,43,84,-1,15,17,43,-1,156,16,18,-1,156,155,16,-1,154,11,114,-1,13,11,154,-1,114,10,154,-1,114,8,10,-1,129,131,130,-1,129,57,131,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfdphal4_Coord',point=[(-4.11977,.21303,2.52748),(-4.1366,.23021,2.49753),(-4.14042,.25129,2.50128),(-4.1354,.2415,2.56937),(-4.14737,.20309,2.57154),(-4.1235,.23438,2.56469),(-4.14041,.25663,2.5021),(-4.13661,.25532,2.48835),(-4.27739,.22607,2.54188),(-4.30446,.23131,2.49947),(-4.28009,.21351,2.53052),(-4.18551,.20862,2.56758),(-4.14409,.19116,2.56309),(-4.18686,.19564,2.56159),(-4.14116,.19717,2.5669),(-4.04486,.30362,2.41736),(-4.1318,.35193,2.43491),(-4.06464,.29971,2.43278),(-4.12167,.36143,2.41328),(-4.08619,.16368,2.3481),(-4.15709,.14304,2.33731),(-4.09034,.17429,2.3385),(-4.15894,.1613,2.32929),(-4.03782,.30265,2.40627),(-4.09074,.34096,2.37812),(-4.09653,.3559,2.39306),(-4.03742,.29869,2.39425),(-4.2771,.21023,2.34488),(-4.2649,.19455,2.34432),(-4.31072,.2008,2.3397),(-4.26459,.26642,2.34453),(-4.28283,.23756,2.34502),(-4.30891,.26488,2.33171),(-4.09067,.26225,2.38332),(-4.11059,.28692,2.37772),(-4.02294,.27984,2.39383),(-4.09196,.21769,2.36196),(-4.07989,.24153,2.37643),(-4.04182,.21096,2.36176),(-4.13033,.2813,2.37522),(-4.1413,.30351,2.3689),(-4.25121,.2464,2.35371),(-4.11983,.28886,2.4645),(-4.05108,.27814,2.43019),(-4.10876,.26445,2.45818),(-4.27934,.24937,2.54844),(-4.29959,.26554,2.5043),(-4.11896,.21995,2.54278),(-4.20721,.16141,2.50755),(-4.15545,.16663,2.51181),(-4.23581,.16072,2.33537),(-4.17525,.18094,2.33897),(-4.22152,.18574,2.34068),(-4.1921,.30001,2.52676),(-4.19229,.25736,2.56597),(-4.16868,.25475,2.56844),(-4.19644,.29499,2.49715),(-4.15438,.27769,2.50438),(-4.19448,.30415,2.48647),(-4.14658,.28047,2.49189),(-4.2537,.29508,2.49253),(-4.25462,.30005,2.47822),(-4.14246,.20047,2.48612),(-4.1362,.23091,2.48201),(-4.13692,.22255,2.49587),(-4.13602,.20338,2.47255),(-4.21406,.1761,2.47683),(-4.25224,.1762,2.50837),(-4.2506,.19581,2.48268),(-4.12028,.23601,2.52621),(-4.1356,.18737,2.51878),(-4.12318,.20471,2.52318),(-4.26461,.29725,2.51716),(-4.2496,.26216,2.55834),(-4.23507,.29799,2.34617),(-4.24962,.31879,2.33234),(-4.18023,.33551,2.34869),(-4.18889,.30858,2.35243),(-4.32779,.22576,2.33808),(-4.28553,.18079,2.3419),(-4.00832,.25963,2.39249),(-4.22785,.20482,2.3506),(-4.0194,.25695,2.41049),(-4.00616,.25848,2.40111),(-4.02887,.2818,2.41657),(-4.01933,.28024,2.40386),(-4.10793,.20596,2.4373),(-4.0613,.19844,2.39457),(-4.10389,.24192,2.45016),(-4.04232,.25335,2.42265),(-4.04088,.2036,2.36843),(-4.0458,.1973,2.37861),(-4.09621,.16245,2.35934),(-4.16351,.17119,2.41922),(-4.17047,.17679,2.46014),(-4.15727,.14201,2.35108),(-4.21961,.1674,2.42167),(-4.21527,.17737,2.45874),(-4.25303,.19503,2.45558),(-4.26755,.18039,2.42035),(-4.34578,.22057,2.35131),(-4.33117,.28398,2.37908),(-4.32991,.27488,2.34192),(-4.34382,.2202,2.37289),(-4.2568,.31181,2.44737),(-4.19793,.32217,2.45763),(-4.15808,.14699,2.37075),(-4.10618,.1661,2.37798),(-4.16503,.32055,2.46272),(-4.23777,.22277,2.35528),(-4.29116,.20028,2.50162),(-4.27346,.21612,2.48092),(-4.18065,.19639,2.34657),(-4.17129,.17656,2.47702),(-4.23291,.21802,2.55928),(-4.1158,.22195,2.54801),(-4.22405,.28061,2.3543),(-4.19481,.23536,2.36568),(-4.18739,.21516,2.35576),(-4.18013,.29123,2.36014),(-4.10429,.23575,2.3717),(-4.11918,.19383,2.34928),(-4.13059,.20656,2.35475),(-4.16916,.26993,2.3702),(-4.2948,.16404,2.35151),(-4.23121,.14512,2.34384),(-4.3257,.27903,2.40407),(-4.3326,.22063,2.39582),(-4.11705,.2412,2.52903),(-4.14708,.27228,2.50481),(-4.12259,.26493,2.53408),(-4.13368,.27616,2.5372),(-4.22768,.14857,2.38096),(-4.23251,.1443,2.35994),(-4.29294,.16306,2.36756),(-4.3136,.1924,2.39167),(-4.32212,.18882,2.37013),(-4.28576,.16678,2.38812),(-4.27131,.33634,2.41479),(-4.27314,.34159,2.39022),(-4.18712,.3526,2.36087),(-4.2615,.33247,2.34213),(-4.32409,.18951,2.35132),(-4.15428,.2462,2.37278),(-4.11577,.25601,2.37921),(-4.14501,.22591,2.36364),(-4.2093,.25962,2.36412),(-4.2889,.20679,2.42749),(-4.29088,.24081,2.46206),(-4.30329,.23926,2.43192),(-4.27618,.21526,2.4585),(-4.28784,.24179,2.47977),(-4.28765,.27335,2.46611),(-4.28437,.27238,2.48438),(-4.22731,.20265,2.55371),(-4.2039,.35591,2.4238),(-4.20111,.36225,2.40044),(-4.30137,.28101,2.43337)]))),
        Shape(DEF='rfdphal5',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfdphal5_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,5,7,-1,6,3,5,-1,8,2,9,-1,10,11,12,-1,4,13,14,-1,13,15,14,-1,16,4,14,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,22,24,23,-1,21,23,25,-1,25,26,21,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,25,-1,34,38,39,-1,31,30,40,-1,7,41,42,-1,7,5,41,-1,19,43,44,-1,43,45,44,-1,46,35,34,-1,11,47,48,-1,11,10,47,-1,16,0,49,-1,15,50,51,-1,24,52,53,-1,52,54,53,-1,55,56,57,-1,58,59,60,-1,60,61,58,-1,62,63,64,-1,63,65,64,-1,66,67,68,-1,68,69,66,-1,67,50,70,-1,70,68,67,-1,2,71,0,-1,72,73,14,-1,48,47,74,-1,47,75,74,-1,76,77,78,-1,76,79,77,-1,31,80,32,-1,28,52,81,-1,35,82,37,-1,83,54,28,-1,84,85,86,-1,85,87,86,-1,88,89,90,-1,89,91,90,-1,92,88,63,-1,63,93,92,-1,94,22,21,-1,21,95,94,-1,96,97,98,-1,97,99,98,-1,100,66,69,-1,69,101,100,-1,98,61,102,-1,98,99,61,-1,103,104,17,-1,104,20,17,-1,105,106,92,-1,107,26,85,-1,85,84,107,-1,108,102,61,-1,83,28,109,-1,28,27,109,-1,46,34,110,-1,37,82,25,-1,28,81,29,-1,11,111,12,-1,51,72,14,-1,71,49,0,-1,62,73,72,-1,62,64,73,-1,68,111,112,-1,68,70,111,-1,2,1,65,-1,65,9,2,-1,61,60,43,-1,43,108,61,-1,31,29,80,-1,54,113,53,-1,66,100,92,-1,92,93,66,-1,51,50,67,-1,67,114,51,-1,4,3,57,-1,115,75,47,-1,10,115,47,-1,5,16,41,-1,5,4,16,-1,116,30,79,-1,117,83,109,-1,117,118,83,-1,39,119,76,-1,37,36,120,-1,121,122,36,-1,123,39,38,-1,123,119,39,-1,33,35,37,-1,39,110,34,-1,27,29,31,-1,54,52,28,-1,82,35,87,-1,87,85,82,-1,26,25,82,-1,82,85,26,-1,124,125,80,-1,125,32,80,-1,126,127,128,-1,127,129,128,-1,86,17,19,-1,19,44,86,-1,10,12,130,-1,130,115,10,-1,64,65,1,-1,41,16,49,-1,131,60,59,-1,51,14,15,-1,41,71,42,-1,41,49,71,-1,73,16,14,-1,73,0,16,-1,44,84,86,-1,84,44,91,-1,89,95,107,-1,89,106,95,-1,94,132,133,-1,94,105,132,-1,134,135,136,-1,137,135,134,-1,129,138,139,-1,129,127,138,-1,136,126,128,-1,135,126,136,-1,140,77,141,-1,140,78,77,-1,142,81,143,-1,142,29,81,-1,87,46,103,-1,87,35,46,-1,80,142,124,-1,80,29,142,-1,103,110,104,-1,103,46,110,-1,38,144,123,-1,144,38,145,-1,120,122,146,-1,122,120,36,-1,116,40,30,-1,147,40,116,-1,33,120,145,-1,33,37,120,-1,118,54,83,-1,118,113,54,-1,147,109,40,-1,147,117,109,-1,119,147,116,-1,147,119,123,-1,131,9,60,-1,131,8,9,-1,57,13,4,-1,13,57,56,-1,114,66,93,-1,114,67,66,-1,92,132,105,-1,92,100,132,-1,128,142,136,-1,124,142,128,-1,148,149,150,-1,149,148,151,-1,39,78,110,-1,39,76,78,-1,99,58,61,-1,58,99,152,-1,151,153,97,-1,154,153,151,-1,11,112,111,-1,11,154,112,-1,72,114,62,-1,114,72,51,-1,50,130,70,-1,50,15,130,-1,12,70,130,-1,12,111,70,-1,55,152,74,-1,152,55,58,-1,23,36,25,-1,121,36,23,-1,31,109,27,-1,31,40,109,-1,113,146,122,-1,118,146,113,-1,123,117,147,-1,117,123,144,-1,138,102,155,-1,98,102,138,-1,18,43,19,-1,43,18,108,-1,107,21,26,-1,107,95,21,-1,140,20,104,-1,140,156,20,-1,90,9,65,-1,90,45,9,-1,125,139,141,-1,125,129,139,-1,149,127,126,-1,149,96,127,-1,136,143,134,-1,136,142,143,-1,69,150,101,-1,69,148,150,-1,132,101,137,-1,132,100,101,-1,133,143,157,-1,134,143,133,-1,137,150,135,-1,101,150,137,-1,149,97,96,-1,149,151,97,-1,129,124,128,-1,124,129,125,-1,96,138,127,-1,138,96,98,-1,156,141,139,-1,140,141,156,-1,106,88,92,-1,89,88,106,-1,65,88,90,-1,63,88,65,-1,91,45,90,-1,91,44,45,-1,155,108,18,-1,155,102,108,-1,118,144,146,-1,118,117,144,-1,53,122,121,-1,122,53,113,-1,24,121,23,-1,53,121,24,-1,77,30,32,-1,79,30,77,-1,75,55,74,-1,55,75,56,-1,74,153,48,-1,74,152,153,-1,57,6,55,-1,57,3,6,-1,59,55,6,-1,58,55,59,-1,48,154,11,-1,48,153,154,-1,69,112,148,-1,68,112,69,-1,62,93,63,-1,114,93,62,-1,97,152,99,-1,152,97,153,-1,148,154,151,-1,148,112,154,-1,126,150,149,-1,126,135,150,-1,94,157,22,-1,94,133,157,-1,115,56,75,-1,115,13,56,-1,103,86,87,-1,103,17,86,-1,45,60,9,-1,43,60,45,-1,8,7,42,-1,131,7,8,-1,76,116,79,-1,76,119,116,-1,145,34,33,-1,34,145,38,-1,146,145,120,-1,146,144,145,-1,81,157,143,-1,81,52,157,-1,141,32,125,-1,141,77,32,-1,22,52,24,-1,52,22,157,-1,104,78,140,-1,104,110,78,-1,139,155,156,-1,139,138,155,-1,133,137,134,-1,133,132,137,-1,106,94,95,-1,94,106,105,-1,91,107,84,-1,107,91,89,-1,156,18,20,-1,156,155,18,-1,130,13,115,-1,15,13,130,-1,0,64,1,-1,64,0,73,-1,42,2,8,-1,42,71,2,-1,131,6,7,-1,131,59,6,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfdphal5_Coord',point=[(-4.51647,.24134,1.94018),(-4.52599,.26075,1.91635),(-4.52426,.28047,1.92155),(-4.52249,.26742,1.97795),(-4.54126,.23193,1.97632),(-4.51392,.25993,1.97336),(-4.51248,.30156,1.95426),(-4.50574,.29014,1.95079),(-4.52294,.28546,1.92279),(-4.51923,.28508,1.90961),(-4.65049,.26873,1.94305),(-4.67067,.27818,1.9056),(-4.65326,.25768,1.93095),(-4.57278,.24113,1.97115),(-4.54078,.221,1.9673),(-4.57594,.22935,1.96424),(-4.53718,.22612,1.97163),(-4.42238,.32377,1.86494),(-4.48571,.37626,1.88211),(-4.44225,.3205,1.87855),(-4.47164,.3862,1.86263),(-4.48125,.22141,1.78523),(-4.53688,.21335,1.77019),(-4.48048,.23214,1.77673),(-4.53424,.23078,1.76391),(-4.43973,.25133,1.80396),(-4.4421,.24438,1.80977),(-4.63088,.26834,1.77678),(-4.62172,.25577,1.77567),(-4.66113,.2588,1.7692),(-4.61275,.31661,1.78159),(-4.63284,.29164,1.77877),(-4.6517,.31828,1.76671),(-4.46993,.29679,1.82678),(-4.47879,.31971,1.82262),(-4.40932,.30191,1.84122),(-4.47857,.26546,1.80259),(-4.46562,.28006,1.81891),(-4.4966,.31751,1.81888),(-4.49938,.33776,1.81418),(-4.6041,.29861,1.78957),(-4.5105,.24889,1.95652),(-4.5073,.26761,1.94415),(-4.495,.31483,1.8983),(-4.43779,.29934,1.87477),(-4.49219,.2918,1.89062),(-4.41516,.32053,1.84265),(-4.65013,.29095,1.95115),(-4.66275,.31048,1.9133),(-4.51365,.24775,1.95115),(-4.59519,.20215,1.91279),(-4.55353,.20275,1.91971),(-4.59864,.22924,1.76594),(-4.54687,.24803,1.77398),(-4.58436,.25159,1.77377),(-4.55903,.33105,1.94343),(-4.56954,.28846,1.97328),(-4.54887,.28337,1.9766),(-4.56266,.32782,1.91865),(-4.52974,.30657,1.92615),(-4.52141,.3095,1.9147),(-4.55791,.33723,1.90923),(-4.53657,.23623,1.90265),(-4.52987,.24133,1.8901),(-4.52793,.25396,1.9141),(-4.52455,.26368,1.90148),(-4.59606,.22581,1.87114),(-4.59707,.22041,1.88849),(-4.62532,.23936,1.89389),(-4.62441,.24307,1.86767),(-4.63087,.2194,1.91256),(-4.51133,.26324,1.94085),(-4.53448,.21947,1.92897),(-4.52103,.23414,1.9352),(-4.62763,.33675,1.93017),(-4.6214,.29953,1.96336),(-4.53832,.34823,1.79652),(-4.5913,.36518,1.77481),(-4.52492,.37296,1.79555),(-4.58168,.34293,1.78726),(-4.67345,.28182,1.76871),(-4.64131,.24218,1.77109),(-4.40373,.28257,1.83882),(-4.58884,.2659,1.78449),(-4.41627,.27945,1.85538),(-4.40351,.28031,1.84708),(-4.41635,.30194,1.86295),(-4.4074,.30084,1.85104),(-4.50476,.2459,1.86571),(-4.46451,.23974,1.83348),(-4.49378,.2729,1.88122),(-4.43788,.27749,1.86575),(-4.55277,.22581,1.84315),(-4.56091,.22344,1.8745),(-4.54041,.21098,1.78326),(-4.49199,.221,1.79545),(-4.6566,.32505,1.85798),(-4.64843,.31568,1.88131),(-4.61193,.35164,1.8771),(-4.61402,.34008,1.89786),(-4.59746,.22247,1.84261),(-4.6355,.23317,1.83994),(-4.55555,.35479,1.89088),(-4.41551,.32323,1.8545),(-4.44818,.38031,1.84388),(-4.54476,.21243,1.80243),(-4.5032,.22281,1.81313),(-4.44952,.23875,1.81878),(-4.52616,.34951,1.89724),(-4.59557,.27946,1.78991),(-4.44579,.36686,1.8285),(-4.66235,.24675,1.90591),(-4.64278,.26066,1.89263),(-4.55052,.25998,1.78224),(-4.56306,.21881,1.89067),(-4.6124,.25534,1.96157),(-4.57491,.32634,1.79429),(-4.55908,.28795,1.80303),(-4.55474,.27365,1.79225),(-4.53489,.3318,1.80293),(-4.48612,.27974,1.81286),(-4.50255,.2523,1.78737),(-4.51042,.26313,1.79314),(-4.5314,.31258,1.81137),(-4.69175,.27669,1.78002),(-4.67066,.32882,1.77621),(-4.68678,.27223,1.82346),(-4.67492,.3275,1.83647),(-4.69334,.2745,1.80081),(-4.67549,.33464,1.81258),(-4.60926,.24047,1.95523),(-4.52478,.30069,1.92645),(-4.60126,.21128,1.80906),(-4.60218,.21099,1.78834),(-4.65381,.22207,1.79388),(-4.67237,.24515,1.81824),(-4.67709,.24429,1.79681),(-4.65006,.22281,1.81431),(-4.6189,.37709,1.85437),(-4.61623,.3842,1.83109),(-4.5293,.38894,1.80832),(-4.60137,.37859,1.78469),(-4.67581,.24688,1.77871),(-4.65283,.22492,1.77847),(-4.52467,.29285,1.81256),(-4.49169,.29553,1.82123),(-4.51985,.27812,1.80258),(-4.56674,.30752,1.80277),(-4.6426,.26211,1.87088),(-4.66216,.28704,1.85385),(-4.65239,.256,1.84776),(-4.6534,.28751,1.87554),(-4.61551,.3341,1.91128),(-4.64786,.31311,1.89897),(-4.65274,.28691,1.89281),(-4.55166,.38839,1.86825),(-4.54501,.39609,1.84647),(-4.59809,.21417,1.77302)]))),
        Shape(DEF='rnaviclr',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rnaviclr_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,10,12,11,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,19,-1,24,25,26,-1,21,27,28,-1,29,30,31,-1,7,32,33,-1,32,34,33,-1,24,35,36,-1,24,26,35,-1,7,33,8,-1,37,38,39,-1,39,28,37,-1,40,41,42,-1,43,42,44,-1,43,40,42,-1,45,46,47,-1,46,48,47,-1,49,34,50,-1,51,52,53,-1,53,54,51,-1,55,56,57,-1,58,59,60,-1,60,61,58,-1,62,63,64,-1,63,61,64,-1,65,66,67,-1,68,69,70,-1,70,71,68,-1,72,73,74,-1,72,75,73,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,82,83,80,-1,3,84,4,-1,85,86,87,-1,88,89,90,-1,91,67,66,-1,92,93,94,-1,95,92,94,-1,96,97,65,-1,97,66,65,-1,98,99,100,-1,101,102,103,-1,98,104,105,-1,98,100,104,-1,106,107,108,-1,109,110,111,-1,109,112,110,-1,113,112,109,-1,113,114,112,-1,115,116,117,-1,115,118,116,-1,56,116,119,-1,56,120,116,-1,103,102,107,-1,121,122,123,-1,123,124,121,-1,125,126,127,-1,126,128,127,-1,101,125,127,-1,101,103,125,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,136,137,138,-1,29,20,139,-1,20,19,139,-1,30,29,140,-1,29,139,140,-1,141,30,142,-1,143,144,145,-1,143,146,144,-1,144,147,145,-1,148,149,150,-1,148,151,149,-1,152,153,154,-1,155,156,157,-1,158,159,133,-1,159,160,133,-1,161,155,162,-1,155,157,162,-1,163,154,153,-1,164,160,159,-1,164,165,160,-1,163,153,166,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,174,176,175,-1,168,177,169,-1,168,178,177,-1,179,180,181,-1,182,183,184,-1,182,147,183,-1,185,186,187,-1,187,188,185,-1,166,156,189,-1,189,190,166,-1,191,192,193,-1,194,195,196,-1,197,198,199,-1,140,139,200,-1,139,23,200,-1,140,201,202,-1,140,200,201,-1,157,203,162,-1,204,205,124,-1,124,206,204,-1,207,208,209,-1,125,210,211,-1,131,212,213,-1,212,214,213,-1,215,216,217,-1,215,134,216,-1,218,119,219,-1,18,123,16,-1,220,221,122,-1,222,146,223,-1,222,144,146,-1,62,224,35,-1,225,226,227,-1,225,228,226,-1,229,230,231,-1,229,232,230,-1,92,233,234,-1,233,235,234,-1,236,107,102,-1,102,237,236,-1,238,239,240,-1,239,241,240,-1,242,243,244,-1,242,245,243,-1,195,246,169,-1,246,167,169,-1,247,248,249,-1,248,250,249,-1,251,171,246,-1,171,170,246,-1,252,253,254,-1,255,256,257,-1,255,80,256,-1,258,255,259,-1,255,260,259,-1,261,262,263,-1,254,264,265,-1,254,266,267,-1,268,254,150,-1,254,269,270,-1,254,271,272,-1,273,269,274,-1,275,276,277,-1,278,90,279,-1,90,280,279,-1,281,282,283,-1,66,284,91,-1,285,286,287,-1,285,288,286,-1,288,72,289,-1,188,187,259,-1,195,194,251,-1,251,246,195,-1,271,290,291,-1,271,253,290,-1,292,293,274,-1,292,294,293,-1,295,71,296,-1,295,68,71,-1,297,42,298,-1,297,44,42,-1,40,299,300,-1,40,43,299,-1,77,301,78,-1,74,4,302,-1,74,303,4,-1,173,196,244,-1,173,194,196,-1,198,245,199,-1,245,242,199,-1,304,305,306,-1,307,264,308,-1,307,265,264,-1,215,267,309,-1,268,149,310,-1,268,150,149,-1,311,223,146,-1,146,312,311,-1,313,314,160,-1,313,315,314,-1,316,317,238,-1,21,28,138,-1,37,318,38,-1,37,319,318,-1,319,320,318,-1,23,139,19,-1,49,321,322,-1,321,323,322,-1,324,46,52,-1,324,325,46,-1,62,26,326,-1,62,35,26,-1,327,262,328,-1,329,330,331,-1,330,332,331,-1,333,334,335,-1,209,336,262,-1,337,112,114,-1,337,208,112,-1,93,234,338,-1,234,339,338,-1,340,341,342,-1,93,17,94,-1,57,218,343,-1,57,119,218,-1,344,237,39,-1,344,236,237,-1,101,127,345,-1,127,212,345,-1,346,115,347,-1,115,348,347,-1,125,349,210,-1,125,350,349,-1,103,107,106,-1,106,351,103,-1,352,344,353,-1,352,236,344,-1,354,355,356,-1,354,352,355,-1,262,261,209,-1,271,254,253,-1,296,357,358,-1,296,71,357,-1,172,180,249,-1,346,351,106,-1,346,347,351,-1,15,210,359,-1,210,349,359,-1,9,348,117,-1,348,115,117,-1,229,128,360,-1,229,214,128,-1,101,345,102,-1,102,130,136,-1,102,345,130,-1,28,237,138,-1,361,362,363,-1,363,186,361,-1,104,100,364,-1,364,365,104,-1,366,16,367,-1,2,110,368,-1,110,207,368,-1,336,209,208,-1,208,337,336,-1,369,370,56,-1,370,333,335,-1,331,371,372,-1,8,330,329,-1,373,327,328,-1,373,374,327,-1,49,375,321,-1,49,50,375,-1,51,24,376,-1,51,25,24,-1,46,45,52,-1,45,53,52,-1,375,325,324,-1,377,378,318,-1,318,320,377,-1,379,318,378,-1,379,38,318,-1,49,322,33,-1,380,319,31,-1,380,320,319,-1,20,27,21,-1,200,23,381,-1,239,137,241,-1,135,240,241,-1,133,160,216,-1,160,314,216,-1,165,313,160,-1,382,152,154,-1,382,157,152,-1,181,383,382,-1,384,385,386,-1,387,266,388,-1,264,267,217,-1,217,308,264,-1,389,19,390,-1,391,392,242,-1,392,199,242,-1,5,393,3,-1,394,395,256,-1,394,396,395,-1,397,79,76,-1,397,396,79,-1,398,41,40,-1,40,300,398,-1,53,44,297,-1,53,45,44,-1,399,293,183,-1,293,400,183,-1,401,292,402,-1,401,294,292,-1,403,404,252,-1,402,271,291,-1,363,187,186,-1,285,72,288,-1,285,75,72,-1,263,405,0,-1,263,406,405,-1,2,368,0,-1,226,407,227,-1,407,287,227,-1,408,278,279,-1,408,409,278,-1,65,187,363,-1,363,410,65,-1,252,386,403,-1,401,402,411,-1,254,272,269,-1,254,270,148,-1,254,268,266,-1,254,267,264,-1,254,265,252,-1,255,257,260,-1,83,394,256,-1,256,80,83,-1,412,413,414,-1,247,249,180,-1,246,170,167,-1,170,250,167,-1,391,242,196,-1,242,244,196,-1,385,181,415,-1,268,388,266,-1,268,310,388,-1,237,102,138,-1,92,234,93,-1,233,416,235,-1,416,362,235,-1,185,417,179,-1,179,418,185,-1,156,204,189,-1,156,155,204,-1,262,327,419,-1,327,374,420,-1,421,422,226,-1,422,407,226,-1,423,105,10,-1,423,424,105,-1,215,217,267,-1,134,133,216,-1,425,341,340,-1,426,427,428,-1,94,17,429,-1,429,430,94,-1,161,431,155,-1,200,381,432,-1,432,201,200,-1,27,20,29,-1,202,201,433,-1,433,434,202,-1,196,195,169,-1,169,391,196,-1,97,96,193,-1,435,280,89,-1,280,90,89,-1,429,17,16,-1,247,179,417,-1,247,180,179,-1,417,185,188,-1,177,391,169,-1,436,182,184,-1,152,157,156,-1,135,158,133,-1,135,132,158,-1,382,203,157,-1,148,150,254,-1,437,23,22,-1,437,381,23,-1,145,147,438,-1,437,146,143,-1,437,312,146,-1,142,30,202,-1,30,140,202,-1,436,184,439,-1,21,390,19,-1,136,138,102,-1,129,136,130,-1,360,122,121,-1,360,220,122,-1,118,440,119,-1,119,116,118,-1,120,117,116,-1,120,423,117,-1,119,57,56,-1,354,108,107,-1,351,350,103,-1,359,349,348,-1,349,347,348,-1,103,350,125,-1,422,435,1,-1,96,410,191,-1,96,65,410,-1,1,435,441,-1,441,2,1,-1,442,279,280,-1,280,421,442,-1,193,96,191,-1,425,443,444,-1,444,341,425,-1,445,90,278,-1,445,88,90,-1,88,446,89,-1,443,447,444,-1,86,99,87,-1,342,426,340,-1,342,430,426,-1,283,448,281,-1,449,63,450,-1,63,326,450,-1,326,63,62,-1,343,55,57,-1,343,60,55,-1,64,61,60,-1,60,343,64,-1,369,56,55,-1,64,224,62,-1,393,451,3,-1,323,321,36,-1,325,375,452,-1,330,33,322,-1,330,8,33,-1,33,34,49,-1,27,319,37,-1,37,28,27,-1,39,237,28,-1,389,22,19,-1,94,430,95,-1,430,342,95,-1,211,126,125,-1,12,104,365,-1,11,12,13,-1,372,329,331,-1,4,303,5,-1,77,453,301,-1,281,286,282,-1,281,225,286,-1,423,9,117,-1,423,10,9,-1,323,35,332,-1,35,323,36,-1,377,452,375,-1,454,452,377,-1,297,455,456,-1,297,298,455,-1,457,298,458,-1,457,455,298,-1,375,376,321,-1,376,375,324,-1,449,61,63,-1,58,61,449,-1,55,59,369,-1,60,59,55,-1,459,460,357,-1,459,461,460,-1,3,462,84,-1,3,463,462,-1,453,448,283,-1,464,448,453,-1,357,70,459,-1,357,71,70,-1,255,81,80,-1,81,255,275,-1,426,465,340,-1,426,466,465,-1,99,465,466,-1,465,99,86,-1,446,85,87,-1,88,85,446,-1,467,278,409,-1,467,445,278,-1,467,443,425,-1,467,192,443,-1,416,191,410,-1,416,447,191,-1,442,408,279,-1,442,284,408,-1,421,435,422,-1,421,280,435,-1,9,359,348,-1,11,359,9,-1,350,347,349,-1,351,347,350,-1,114,120,56,-1,120,114,113,-1,468,354,356,-1,468,108,354,-1,2,111,110,-1,2,441,111,-1,159,213,231,-1,159,158,213,-1,161,230,431,-1,161,164,230,-1,21,137,390,-1,21,138,137,-1,469,436,439,-1,434,436,469,-1,437,432,381,-1,437,143,432,-1,178,248,188,-1,168,248,178,-1,180,415,181,-1,415,180,172,-1,470,471,472,-1,470,400,471,-1,251,412,171,-1,251,413,412,-1,167,248,168,-1,248,167,250,-1,93,473,17,-1,93,338,473,-1,395,199,392,-1,395,197,199,-1,451,198,474,-1,451,305,198,-1,396,197,395,-1,396,397,197,-1,434,182,436,-1,434,433,182,-1,205,230,232,-1,205,431,230,-1,429,426,430,-1,426,429,427,-1,466,428,364,-1,466,426,428,-1,87,98,475,-1,87,99,98,-1,428,366,476,-1,428,427,366,-1,476,367,477,-1,476,366,367,-1,340,478,425,-1,478,340,465,-1,447,233,444,-1,416,233,447,-1,407,1,0,-1,407,422,1,-1,419,420,479,-1,419,327,420,-1,480,282,289,-1,480,301,282,-1,345,131,130,-1,131,345,212,-1,481,166,190,-1,163,166,481,-1,418,154,482,-1,179,154,418,-1,362,410,363,-1,416,410,362,-1,483,387,316,-1,387,483,309,-1,484,437,22,-1,437,484,312,-1,485,310,311,-1,310,485,388,-1,486,184,470,-1,184,486,398,-1,306,487,304,-1,306,486,487,-1,412,290,404,-1,412,414,290,-1,464,83,448,-1,83,464,394,-1,403,385,415,-1,403,386,385,-1,147,399,183,-1,399,147,488,-1,270,273,489,-1,269,273,270,-1,294,176,471,-1,294,401,176,-1,479,70,490,-1,70,479,459,-1,408,193,409,-1,97,193,408,-1,228,491,226,-1,228,492,491,-1,226,442,421,-1,442,226,491,-1,435,446,441,-1,435,89,446,-1,405,407,0,-1,407,405,287,-1,493,70,69,-1,490,70,493,-1,406,479,490,-1,479,406,419,-1,69,285,493,-1,69,75,285,-1,492,82,81,-1,82,492,228,-1,392,177,257,-1,391,177,392,-1,148,489,151,-1,148,270,489,-1,402,272,271,-1,292,272,402,-1,404,415,412,-1,403,415,404,-1,291,414,494,-1,290,414,291,-1,402,494,411,-1,291,494,402,-1,401,175,176,-1,411,175,401,-1,456,295,296,-1,295,456,455,-1,144,488,147,-1,488,144,222,-1,184,300,439,-1,184,398,300,-1,458,42,41,-1,42,458,298,-1,480,78,301,-1,480,462,78,-1,76,474,397,-1,474,76,463,-1,396,464,79,-1,396,394,464,-1,495,74,73,-1,495,303,74,-1,393,41,306,-1,41,393,458,-1,243,472,174,-1,243,487,472,-1,484,389,317,-1,484,22,389,-1,316,388,485,-1,388,316,387,-1,314,217,216,-1,217,314,308,-1,384,307,315,-1,384,386,307,-1,315,383,384,-1,313,383,315,-1,181,384,383,-1,181,385,384,-1,383,203,382,-1,383,313,203,-1,483,135,134,-1,135,483,240,-1,239,390,137,-1,390,239,389,-1,379,50,34,-1,379,378,50,-1,454,48,452,-1,454,496,48,-1,496,142,497,-1,142,496,141,-1,320,454,377,-1,380,454,320,-1,375,378,377,-1,50,378,375,-1,51,358,25,-1,54,358,51,-1,24,321,376,-1,24,36,321,-1,25,357,460,-1,358,357,25,-1,450,373,449,-1,450,374,373,-1,64,331,224,-1,64,371,331,-1,335,262,336,-1,335,328,262,-1,373,58,449,-1,373,334,58,-1,333,369,59,-1,333,370,369,-1,56,337,114,-1,56,370,337,-1,207,261,368,-1,207,209,261,-1,368,263,0,-1,261,263,368,-1,498,481,339,-1,498,482,481,-1,206,17,473,-1,206,18,17,-1,205,121,124,-1,205,232,121,-1,477,122,221,-1,367,122,477,-1,498,362,361,-1,235,362,498,-1,447,192,191,-1,447,443,192,-1,478,88,445,-1,478,85,88,-1,105,475,98,-1,105,424,475,-1,218,64,343,-1,218,371,64,-1,14,221,211,-1,477,221,14,-1,11,15,359,-1,15,11,13,-1,353,32,499,-1,32,353,500,-1,8,372,6,-1,8,329,372,-1,440,219,119,-1,501,219,440,-1,355,6,501,-1,355,499,6,-1,479,461,459,-1,479,420,461,-1,356,501,440,-1,356,355,501,-1,501,372,219,-1,372,501,6,-1,499,7,6,-1,499,32,7,-1,499,352,353,-1,499,355,352,-1,500,344,39,-1,344,500,353,-1,236,354,107,-1,354,236,352,-1,365,477,14,-1,476,477,365,-1,219,371,218,-1,372,371,219,-1,465,85,478,-1,85,465,86,-1,87,441,446,-1,441,87,111,-1,425,445,467,-1,425,478,445,-1,121,229,360,-1,232,229,121,-1,189,206,473,-1,189,204,206,-1,367,123,122,-1,367,16,123,-1,235,339,234,-1,235,498,339,-1,339,190,338,-1,481,190,339,-1,361,482,498,-1,361,418,482,-1,419,263,262,-1,419,406,263,-1,336,370,335,-1,336,337,370,-1,334,59,58,-1,334,333,59,-1,328,334,373,-1,335,334,328,-1,224,332,35,-1,332,224,331,-1,420,450,461,-1,420,374,450,-1,460,26,25,-1,326,26,460,-1,380,496,454,-1,141,496,380,-1,496,47,48,-1,496,497,47,-1,31,141,380,-1,31,30,141,-1,239,317,389,-1,238,317,239,-1,315,308,314,-1,315,307,308,-1,134,309,483,-1,309,134,215,-1,311,149,223,-1,149,311,310,-1,485,317,316,-1,317,485,484,-1,245,305,304,-1,198,305,245,-1,487,470,472,-1,470,487,486,-1,243,173,244,-1,173,243,174,-1,303,457,5,-1,457,303,495,-1,306,398,486,-1,398,306,41,-1,451,463,3,-1,451,474,463,-1,480,84,462,-1,502,84,480,-1,455,495,295,-1,455,457,495,-1,438,182,433,-1,438,147,182,-1,439,299,469,-1,300,299,439,-1,497,43,47,-1,497,299,43,-1,296,54,456,-1,54,296,358,-1,400,294,471,-1,294,400,293,-1,411,503,175,-1,411,494,503,-1,494,413,503,-1,494,414,413,-1,274,272,292,-1,272,274,269,-1,151,488,222,-1,151,489,488,-1,259,178,188,-1,178,259,260,-1,275,492,81,-1,277,492,275,-1,286,289,282,-1,286,288,289,-1,493,287,405,-1,493,285,287,-1,73,295,495,-1,295,73,68,-1,405,490,493,-1,406,490,405,-1,491,284,442,-1,91,284,491,-1,492,91,491,-1,492,277,91,-1,228,281,82,-1,228,225,281,-1,277,67,91,-1,277,276,67,-1,399,274,293,-1,399,273,274,-1,178,257,177,-1,178,260,257,-1,488,273,399,-1,273,488,489,-1,386,265,307,-1,386,252,265,-1,258,187,65,-1,258,259,187,-1,301,283,282,-1,283,301,453,-1,253,404,290,-1,252,404,253,-1,245,487,243,-1,245,304,487,-1,311,484,485,-1,311,312,484,-1,266,309,267,-1,266,387,309,-1,240,316,238,-1,316,240,483,-1,482,163,481,-1,154,163,482,-1,213,229,231,-1,229,213,214,-1,286,227,287,-1,286,225,227,-1,502,289,72,-1,502,480,289,-1,149,222,223,-1,151,222,149,-1,469,497,142,-1,469,299,497,-1,220,211,221,-1,220,126,211,-1,342,444,95,-1,342,341,444,-1,212,128,214,-1,212,127,128,-1,211,15,14,-1,210,15,211,-1,364,476,365,-1,364,428,476,-1,16,427,429,-1,427,16,366,-1,112,207,110,-1,207,112,208,-1,466,100,99,-1,466,364,100,-1,162,313,165,-1,162,203,313,-1,433,432,438,-1,201,432,433,-1,197,474,198,-1,397,474,197,-1,451,306,305,-1,451,393,306,-1,256,392,257,-1,256,395,392,-1,338,189,473,-1,338,190,189,-1,250,172,249,-1,250,170,172,-1,418,186,185,-1,418,361,186,-1,194,413,251,-1,413,194,503,-1,415,171,412,-1,171,415,172,-1,188,247,417,-1,248,247,188,-1,184,400,470,-1,184,183,400,-1,472,176,174,-1,472,471,176,-1,173,503,194,-1,175,503,173,-1,153,156,166,-1,156,153,152,-1,161,165,164,-1,161,162,165,-1,179,382,154,-1,179,181,382,-1,438,143,145,-1,432,143,438,-1,202,469,142,-1,434,469,202,-1,241,136,129,-1,137,136,241,-1,135,129,132,-1,129,135,241,-1,164,231,230,-1,164,159,231,-1,213,132,131,-1,158,132,213,-1,128,220,360,-1,126,220,128,-1,123,206,124,-1,206,123,18,-1,118,356,440,-1,468,356,118,-1,346,108,468,-1,346,106,108,-1,115,468,118,-1,115,346,468,-1,113,423,120,-1,423,113,424,-1,424,109,475,-1,424,113,109,-1,105,12,10,-1,105,104,12,-1,284,97,408,-1,284,66,97,-1,111,475,109,-1,111,87,475,-1,192,409,193,-1,467,409,192,-1,155,205,204,-1,205,155,431,-1,72,302,502,-1,302,72,74,-1,258,275,255,-1,258,276,275,-1,448,82,281,-1,448,83,82,-1,453,79,464,-1,453,77,79,-1,462,76,78,-1,463,76,462,-1,502,4,84,-1,302,4,502,-1,75,68,73,-1,75,69,68,-1,65,276,258,-1,65,67,276,-1,461,326,460,-1,461,450,326,-1,324,51,376,-1,51,324,52,-1,53,456,54,-1,53,297,456,-1,5,458,393,-1,5,457,458,-1,452,46,325,-1,46,452,48,-1,47,44,45,-1,47,43,44,-1,27,31,319,-1,31,27,29,-1,34,500,379,-1,500,34,32,-1,39,379,500,-1,39,38,379,-1,332,322,323,-1,332,330,322,-1,92,444,233,-1,92,95,444,-1,14,12,365,-1,13,12,14,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rnaviclr_Coord',point=[(-2.14178,1.67348,-.80687),(-2.2132,1.6703,-.85899),(-2.20212,1.5382,-.90956),(-2.33457,2.23632,-.81162),(-2.31264,2.22972,-.79869),(-2.20145,2.2104,-.84069),(-1.56768,1.29842,-1.24418),(-1.51783,1.36128,-1.23143),(-1.514,1.37444,-1.21574),(-1.83369,1.38934,-1.24717),(-1.9221,1.38452,-1.18293),(-1.86339,1.39357,-1.27196),(-1.95273,1.38276,-1.22338),(-1.87808,1.39055,-1.28791),(-1.92247,1.37355,-1.35383),(-1.85274,1.39332,-1.30955),(-2.1858,1.26376,-1.52033),(-2.26856,1.23581,-1.57432),(-2.23121,1.26187,-1.5908),(-1.60414,1.82497,-1.53936),(-1.58714,1.82037,-1.53482),(-1.56441,1.76866,-1.59812),(-1.68406,1.86182,-1.4529),(-1.66338,1.87187,-1.43494),(-1.58258,1.66715,-.89901),(-1.68096,1.83462,-.76019),(-1.58352,1.65482,-.87709),(-1.5556,1.80775,-1.51017),(-1.52638,1.69188,-1.61554),(-1.61479,1.87722,-1.43123),(-1.69456,1.9682,-1.25928),(-1.61316,1.87602,-1.40544),(-1.49555,1.41725,-1.34599),(-1.50478,1.38746,-1.2346),(-1.49103,1.43202,-1.32809),(-1.51774,1.54451,-.98268),(-1.51545,1.56319,-.99523),(-1.51618,1.68908,-1.59694),(-1.48987,1.54967,-1.53638),(-1.49241,1.53465,-1.55143),(-1.98144,2.13621,-.96417),(-2.09903,2.19296,-.96205),(-1.98632,2.12732,-.92918),(-1.87011,2.0679,-.96445),(-1.87713,2.06493,-.91674),(-1.79181,1.98463,-.93877),(-1.73089,1.89437,-.97285),(-1.79261,1.98964,-.98696),(-1.74172,1.90142,-1.01597),(-1.51344,1.47848,-1.21507),(-1.52909,1.50922,-1.25553),(-1.68057,1.88842,-.85773),(-1.69604,1.89949,-.9117),(-1.77131,1.99585,-.86369),(-1.77133,1.98816,-.80761),(-1.8247,1.33094,-1.11809),(-1.89698,1.34108,-1.12974),(-1.8177,1.32893,-1.13697),(-1.63562,1.36343,-1.00592),(-1.73034,1.32715,-1.07179),(-1.72567,1.33349,-1.093),(-1.62796,1.36753,-1.02881),(-1.5706,1.52202,-.9272),(-1.58636,1.51872,-.91443),(-1.62076,1.36552,-1.04845),(-2.65839,1.67725,-1.19435),(-2.57497,1.60721,-1.15615),(-2.65506,1.68603,-1.17185),(-2.04942,2.02941,-.70609),(-2.05985,2.0154,-.71315),(-1.94236,1.94324,-.69098),(-1.92235,1.97229,-.69304),(-2.23667,2.15249,-.75607),(-2.13605,2.07777,-.72506),(-2.22608,2.1622,-.75894),(-2.14106,2.05784,-.73014),(-2.49452,2.14695,-.83814),(-2.52382,2.09109,-.8354),(-2.49131,2.13762,-.82824),(-2.52998,2.09417,-.85083),(-2.62201,1.95095,-.99141),(-2.61966,1.93588,-.9847),(-2.55338,1.97126,-.90622),(-2.55641,1.98743,-.90885),(-2.32951,2.22812,-.80073),(-2.18904,1.45848,-1.08688),(-2.17237,1.42461,-1.10866),(-2.13696,1.44429,-1.03692),(-2.25151,1.55869,-1.00979),(-2.22389,1.63829,-.9255),(-2.29548,1.62055,-.97642),(-2.5734,1.68443,-1.10821),(-2.30966,1.24551,-1.54083),(-2.30986,1.2459,-1.58294),(-2.29021,1.23692,-1.54243),(-2.29632,1.2583,-1.48814),(-2.6202,1.64837,-1.19487),(-2.57241,1.59704,-1.16821),(-2.07654,1.39495,-1.13493),(-2.14772,1.40682,-1.12141),(-2.07972,1.38844,-1.15505),(-1.69185,1.55838,-1.57755),(-1.62052,1.61865,-1.63796),(-1.67393,1.54139,-1.57224),(-1.99512,1.37893,-1.20082),(-1.99326,1.38239,-1.15842),(-1.67973,1.47744,-1.47225),(-1.65176,1.52689,-1.57106),(-1.66754,1.45228,-1.49452),(-2.05305,1.39169,-1.0766),(-2.12739,1.42662,-1.00258),(-2.13748,1.42746,-1.01366),(-2.04723,1.38314,-1.06477),(-1.98681,1.3729,-1.11141),(-1.98086,1.36664,-1.09693),(-1.769,1.38016,-1.27873),(-1.80318,1.33519,-1.21736),(-1.81065,1.37754,-1.22621),(-1.76653,1.33973,-1.29076),(-1.78592,1.31949,-1.20998),(-1.90935,1.35136,-1.14426),(-2.0976,1.36928,-1.53983),(-2.09106,1.33779,-1.52016),(-2.17387,1.2877,-1.55907),(-2.17277,1.32315,-1.58731),(-1.78908,1.48199,-1.49817),(-1.8881,1.43347,-1.49771),(-1.80591,1.50505,-1.52132),(-1.90425,1.4664,-1.51693),(-1.71158,1.62526,-1.60702),(-1.70903,1.60193,-1.59703),(-1.83088,1.56242,-1.53671),(-1.83874,1.57488,-1.5591),(-1.96077,1.54492,-1.53774),(-1.93793,1.58394,-1.44429),(-1.83548,1.59411,-1.5579),(-1.59618,1.66792,-1.64871),(-1.59915,1.69497,-1.63951),(-1.5688,1.68465,-1.64591),(-1.64621,1.88389,-1.43154),(-1.71541,1.97297,-1.27654),(-1.70971,1.96614,-1.1991),(-1.74063,2.01714,-1.1702),(-1.79482,1.99467,-1.26267),(-1.85823,2.06361,-1.20684),(-1.84749,2.0698,-1.20142),(-1.80741,1.98431,-1.25941),(-1.93609,2.1397,-1.16688),(-2.09299,1.83738,-1.19285),(-1.98093,1.87171,-1.19768),(-2.08724,1.81369,-1.19613),(-2.0172,1.91996,-1.17707),(-2.33642,1.41563,-1.72503),(-2.36205,1.39724,-1.71518),(-2.40068,1.46583,-1.63932),(-2.28414,1.40617,-1.71428),(-2.31348,1.38542,-1.72716),(-2.30489,1.42598,-1.7132),(-1.94772,1.53537,-1.54647),(-2.05092,1.49618,-1.56019),(-2.0563,1.5066,-1.55728),(-2.20567,1.45082,-1.66602),(-2.21476,1.46258,-1.6597),(-2.36195,1.37384,-1.70264),(-2.14069,1.47218,-1.60977),(-2.15056,1.48462,-1.60293),(-2.35242,1.3568,-1.7142),(-2.63232,1.88397,-1.25733),(-2.65813,1.88489,-1.26031),(-2.66844,1.96948,-1.23179),(-2.54369,1.80481,-1.34657),(-2.5342,1.81625,-1.36105),(-2.47504,1.67291,-1.44664),(-2.52133,2.17849,-1.20429),(-2.47302,2.25316,-1.1602),(-2.50832,2.17439,-1.20982),(-2.46478,2.24756,-1.16866),(-2.67908,1.95955,-1.21291),(-2.67413,1.87958,-1.25125),(-2.46665,1.57122,-1.55639),(-2.46141,1.58859,-1.5357),(-2.44322,1.59018,-1.553),(-1.93148,2.15239,-1.14349),(-2.11017,2.22358,-1.10986),(-2.10301,2.23343,-1.09642),(-2.5535,1.6154,-1.3985),(-2.55253,1.59332,-1.35061),(-2.65054,1.70506,-1.24405),(-2.6325,1.74829,-1.29916),(-2.29855,1.31941,-1.69664),(-2.33969,1.31521,-1.6883),(-2.5151,1.55727,-1.24154),(-2.47063,1.5835,-1.22198),(-2.54031,1.61071,-1.20352),(-2.58213,2.00651,-1.31011),(-2.61647,1.98999,-1.2612),(-2.61526,2.02557,-1.24566),(-2.53534,2.15078,-.9931),(-2.43479,2.2207,-.95813),(-2.54178,2.15687,-1.02633),(-1.72784,1.9392,-1.30164),(-1.77543,2.00766,-1.20038),(-1.76203,2.03252,-1.19214),(-2.26902,1.44783,-1.64657),(-2.26251,1.33663,-1.6866),(-2.18442,1.37776,-1.6081),(-2.24607,1.27285,-1.62134),(-2.06829,1.44179,-.95668),(-2.01076,1.40805,-.98949),(-1.98783,1.47196,-.90245),(-1.81947,1.42215,-1.40008),(-1.88396,1.39645,-1.43373),(-1.82271,1.53766,-1.52811),(-1.94175,1.52438,-1.52228),(-1.92072,1.49575,-1.52043),(-2.01228,1.64703,-1.32001),(-2.00889,1.5473,-1.45253),(-2.06597,1.6269,-1.3365),(-1.70036,1.31263,-1.14599),(-1.6749,1.27835,-1.20141),(-1.97648,1.3849,-1.49716),(-1.98027,1.37375,-1.47456),(-1.90274,2.0202,-1.21147),(-1.84982,1.96204,-1.2442),(-1.55143,1.44283,-1.00133),(-2.41851,1.92007,-.8089),(-2.38656,1.73721,-.93481),(-2.2828,1.78914,-.83245),(-2.49014,1.87724,-.92246),(-2.0173,1.44686,-1.53098),(-2.13798,1.44482,-1.57389),(-2.04667,1.47688,-1.52847),(-2.11713,1.41091,-1.55766),(-2.36887,1.34133,-1.39974),(-2.33006,1.26456,-1.57424),(-2.37924,1.36261,-1.4636),(-1.57933,1.51743,-1.57235),(-1.53391,1.62833,-1.63657),(-1.74532,1.70726,-1.484),(-1.67402,1.70696,-1.56673),(-1.80571,1.6344,-1.53663),(-1.71068,1.63673,-1.60436),(-2.5463,2.15959,-1.08645),(-2.45041,2.23481,-1.08421),(-2.52172,2.15959,-1.14637),(-2.44397,2.23705,-1.02645),(-2.5881,1.88772,-1.29634),(-2.54563,1.63539,-1.42741),(-2.61618,1.75744,-1.3101),(-2.49506,1.64519,-1.42011),(-2.56665,1.77699,-1.31149),(-2.57504,1.92329,-1.34951),(-2.22723,1.76833,-1.23343),(-2.22891,1.79073,-1.22214),(-2.14852,1.79357,-1.21258),(-2.6982,1.86875,-1.12079),(-2.63427,1.99224,-1.01033),(-2.69393,1.93382,-1.14798),(-2.68711,1.74225,-1.17883),(-2.66736,1.73997,-1.23569),(-2.6937,1.87329,-1.18173),(-2.0053,1.5323,-.86314),(-1.86672,1.55494,-.80113),(-2.02377,1.62181,-.8152),(-2.15815,1.721,-1.24591),(-2.19373,1.73245,-1.24497),(-2.09629,1.75821,-1.22392),(-2.12512,1.73898,-1.23725),(-2.08172,1.78983,-1.20003),(-2.13643,1.86357,-1.18433),(-2.11462,1.85055,-1.18831),(-2.22458,1.81168,-1.21127),(-2.17451,1.85445,-1.1884),(-2.11894,1.96619,-1.15222),(-2.16784,1.96751,-1.14544),(-2.69215,1.85936,-1.11134),(-2.68211,1.73859,-1.166),(-2.63625,1.77563,-1.10385),(-2.38464,1.59901,-1.07526),(-2.41352,1.59541,-1.06073),(-2.32051,1.622,-.9696),(-2.48291,1.98031,-.81703),(-2.42661,2.04742,-.79434),(-2.49446,2.00347,-.82306),(-2.52703,1.5997,-1.12663),(-2.18654,1.95776,-.74685),(-2.36583,1.975,-.78313),(-2.22273,1.85276,-.78895),(-2.2962,2.04966,-.75808),(-2.34059,2.09951,-.77055),(-2.35763,1.8173,-1.24563),(-2.34804,1.85163,-1.21907),(-2.2187,1.95364,-1.14376),(-2.20378,2.14525,-1.12122),(-2.30156,2.14115,-1.13022),(-2.0153,2.06748,-.73496),(-1.89692,2.00468,-.7039),(-1.87655,2.06261,-.85194),(-1.98744,2.11668,-.86309),(-1.84267,2.07932,-1.04683),(-1.95689,2.16952,-1.05329),(-2.46313,2.09446,-.80253),(-2.29481,2.20518,-.78553),(-2.20642,2.19047,-.7839),(-2.35666,2.27137,-.99713),(-2.35542,2.2581,-.9408),(-2.2102,2.24247,-.96052),(-2.2303,1.62674,-1.33812),(-2.12947,1.61684,-1.3453),(-1.97516,1.68103,-1.29972),(-1.94829,1.82212,-1.22277),(-1.81804,1.88163,-1.28322),(-1.76694,1.91015,-1.32119),(-2.24837,1.47258,-1.56078),(-2.08756,1.52853,-1.4697),(-2.24019,1.51522,-1.47828),(-1.82754,1.71219,-1.37229),(-1.73074,1.75726,-1.45506),(-1.51354,1.62492,-1.43186),(-1.54852,1.79614,-1.49146),(-1.55847,1.70079,-1.36547),(-1.53457,1.57778,-1.10596),(-1.48305,1.43808,-1.18679),(-1.49968,1.48544,-1.10356),(-1.62043,1.72393,-1.03058),(-1.63558,1.73317,-1.06589),(-1.59438,1.63609,-.84723),(-1.77907,1.61975,-.76544),(-1.76239,1.51675,-.85029),(-1.51971,1.3798,-1.16643),(-1.48318,1.41999,-1.17289),(-1.5311,1.3909,-1.09729),(-1.50054,1.46392,-1.09482),(-1.77038,1.34974,-1.02572),(-1.69856,1.38751,-.97505),(-1.81647,1.41991,-.93881),(-1.91599,1.42411,-.92818),(-1.95539,1.37358,-1.02278),(-2.3249,1.26464,-1.64251),(-2.34606,1.30395,-1.62463),(-2.2437,1.36258,-1.29659),(-2.31323,1.35875,-1.34877),(-2.27692,1.30579,-1.40236),(-1.71859,1.3271,-1.11252),(-1.50249,1.51915,-1.56137),(-1.70562,1.57789,-1.58699),(-1.71676,1.4309,-1.38816),(-1.74267,1.44958,-1.38049),(-1.79378,1.39875,-1.28336),(-1.77645,1.45123,-1.37825),(-1.73448,1.48505,-1.46791),(-1.71372,1.48526,-1.46652),(-1.59643,1.4337,-1.49228),(-1.51199,1.46347,-1.47344),(-1.65454,1.444,-1.49788),(-1.61309,1.35899,-1.421),(-1.68773,1.38425,-1.4193),(-1.80333,1.90536,-.68083),(-1.79438,1.94387,-.70786),(-1.82036,1.39885,-1.29529),(-1.99755,1.42262,-1.51814),(-2.4739,1.50387,-1.44009),(-2.46241,1.48084,-1.37437),(-2.55154,1.57125,-1.30272),(-2.09161,1.35211,-1.22783),(-2.01692,1.35635,-1.26976),(-2.12615,1.29348,-1.42415),(-2.11091,1.31046,-1.46583),(-2.12162,1.53978,-.89743),(-1.83323,1.32297,-1.09868),(-1.87116,1.35847,-1.03424),(-1.60356,1.34148,-1.10678),(-1.58149,1.30934,-1.16105),(-1.65602,1.50699,-.87045),(-1.66679,1.61062,-.80196),(-1.56397,1.62566,-1.13131),(-1.60344,1.70672,-.982),(-1.56824,1.64785,-1.25502),(-1.53534,1.54853,-1.33899),(-1.48919,1.49614,-1.42938),(-1.61206,1.82212,-1.2819),(-1.73785,1.92394,-1.30915),(-2.39244,1.49284,-1.62555),(-2.37142,1.51661,-1.55784),(-2.36347,1.57118,-1.46052),(-2.40601,1.61453,-1.45843),(-2.29904,1.6739,-1.32273),(-1.95071,1.72106,-1.2731),(-1.94169,1.77198,-1.24903),(-1.66585,1.78938,-1.52891),(-1.59932,1.78209,-1.58807),(-2.65543,2.02716,-1.19196),(-2.66232,2.027,-1.1074),(-2.2019,2.22167,-.87883),(-2.57506,2.01997,-.91383),(-2.63209,2.04489,-1.01876),(-2.58203,2.06034,-.9185),(-2.51726,2.13382,-.90016),(-2.10405,2.21463,-1.0622),(-2.1244,2.13337,-1.13281),(-2.22519,2.27742,-1.12564),(-2.38691,2.09317,-1.15424),(-2.27918,1.91606,-1.17293),(-2.33849,1.71831,-1.30858),(-2.3579,1.78031,-1.27186),(-2.13494,1.79313,-.77018),(-2.02893,1.75551,-.74843),(-2.23057,1.73885,-.84165),(-2.51908,1.58988,-1.13827),(-2.48168,1.61005,-1.16416),(-2.52432,1.55673,-1.25187),(-2.42146,2.05886,-1.18525),(-2.52129,1.83005,-1.35748),(-2.55915,1.92704,-1.34898),(-2.51617,1.87989,-1.32253),(-2.45938,1.6768,-1.4496),(-2.43218,1.46891,-1.30073),(-2.55386,1.61942,-1.42413),(-2.47179,1.53649,-1.49892),(-1.88584,1.70169,-.74054),(-1.73935,1.70433,-.72985),(-2.32926,1.63325,-.96471),(-2.22567,1.68396,-.86185),(-1.91422,1.37704,-1.15656),(-1.9907,1.39118,-1.12378),(-2.35953,1.4882,-1.25223),(-2.1871,1.32245,-1.31845),(-2.15912,1.30315,-1.37088),(-2.13672,1.31884,-1.32885),(-2.2203,1.26389,-1.47376),(-2.23828,1.2702,-1.45189),(-2.20332,1.41713,-1.62683),(-1.7849,2.00045,-1.2302),(-1.82702,2.07505,-1.16006),(-1.81402,2.09079,-1.16102),(-2.22355,1.66086,-.88423),(-1.92185,2.17264,-1.14661),(-1.75186,1.92634,-1.33065),(-1.84041,2.07081,-1.18612),(-1.92623,2.18605,-1.11825),(-1.74904,1.31646,-1.28214),(-2.21239,1.53812,-.91968),(-2.42146,1.60439,-1.05375),(-2.38539,1.48926,-1.27895),(-2.35464,1.34049,-1.3857),(-2.33914,1.56826,-1.09938),(-2.21389,1.55633,-.95128),(-2.42277,1.46954,-1.29046),(-2.5046,2.00549,-.84687),(-1.59587,1.50373,-.89756),(-1.6155,1.62361,-.82591),(-2.34242,2.23282,-.85306),(-1.63971,1.74039,-1.08877),(-2.5275,2.05017,-.83016),(-1.6384,1.77131,-1.17388),(-1.99466,2.10059,-.80568),(-1.88114,2.04844,-.79211),(-2.10292,2.16549,-.83169),(-2.09768,2.18004,-.88708),(-1.81297,1.87397,-.67419),(-1.68377,1.79797,-.73064),(-1.69525,1.76944,-.72178),(-2.41974,2.18248,-.80973),(-2.42438,2.1904,-.8203),(-2.53403,2.04358,-.85393),(-2.20032,1.39831,-1.18253),(-2.15312,1.36628,-1.20105),(-2.44155,1.5875,-1.19167),(-1.70627,1.4012,-1.41756),(-1.80704,2.09431,-1.13056),(-2.22489,2.28648,-1.11407),(-2.35023,2.31045,-1.13621),(-2.35307,2.3175,-1.12671),(-2.28664,1.2524,-1.63881),(-2.42285,2.1893,-.87512),(-2.06483,1.40904,-1.08631),(-2.07264,1.32241,-1.35643),(-2.01078,1.34768,-1.40735),(-2.25639,1.47695,-1.15102),(-1.84127,1.7962,-.68752),(-2.39536,2.14135,-.78425),(-2.3578,1.34287,-1.67342),(-2.40058,1.43667,-1.58582),(-1.88205,1.64343,-1.4071),(-1.73459,1.83994,-1.40028),(-1.81148,1.80436,-1.33134),(-2.21902,2.25879,-1.05112),(-2.34773,2.2781,-1.05403),(-1.98381,2.07714,-1.18146),(-2.0558,1.94426,-1.16511),(-1.99187,1.86083,-.7042),(-2.46844,1.70844,-1.02344),(-2.5496,1.83705,-.98962),(-2.10929,1.89875,-.73132),(-2.49293,1.93684,-1.26886),(-2.11813,2.13862,-.76185),(-1.73662,1.93184,-1.08557),(-1.78696,2.00641,-1.05553),(-2.38898,1.39378,-1.52513),(-1.53924,1.36682,-1.37501),(-1.49197,1.4761,-1.43948),(-1.6476,1.27926,-1.27542),(-2.30709,2.1953,-.78142),(-2.5659,2.0061,-1.3117)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesRightFoot.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesRightFoot.py load and self-test diagnostics complete.")
