####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesRightFemur.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesRightFemur.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Right Femur',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesRightFemur.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesRightFemur.x3d'),
    Transform(DEF='DSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Group(DEF='RightFemur',
        children=[
        Shape(DEF='rfemur',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='rfemur_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,14,15,12,-1,16,17,18,-1,18,6,16,-1,19,20,21,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,28,38,39,-1,39,40,28,-1,41,42,43,-1,43,44,41,-1,45,46,47,-1,48,49,50,-1,50,51,48,-1,52,53,54,-1,52,55,53,-1,56,57,58,-1,59,60,57,-1,61,62,63,-1,61,64,62,-1,65,66,67,-1,61,63,68,-1,69,70,71,-1,71,72,69,-1,73,74,75,-1,76,77,78,-1,77,76,79,-1,80,81,82,-1,83,74,81,-1,81,84,83,-1,82,85,80,-1,86,87,88,-1,73,75,89,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,94,97,95,-1,90,98,93,-1,99,100,94,-1,100,97,94,-1,101,102,103,-1,104,105,106,-1,107,68,63,-1,108,109,110,-1,111,112,113,-1,109,114,110,-1,114,115,110,-1,116,117,75,-1,117,89,75,-1,118,119,120,-1,119,121,120,-1,115,122,123,-1,115,114,122,-1,113,124,125,-1,113,126,124,-1,104,127,128,-1,104,129,127,-1,130,131,132,-1,130,133,131,-1,134,135,136,-1,137,138,139,-1,140,131,138,-1,138,141,140,-1,142,143,144,-1,143,145,144,-1,146,147,148,-1,149,150,151,-1,151,152,149,-1,153,154,155,-1,156,157,158,-1,158,159,156,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,168,169,166,-1,170,171,172,-1,170,173,171,-1,174,175,168,-1,168,167,174,-1,28,40,176,-1,176,177,28,-1,176,40,178,-1,179,180,31,-1,46,181,182,-1,46,45,181,-1,182,183,184,-1,182,181,183,-1,185,45,47,-1,186,187,41,-1,188,189,190,-1,191,192,193,-1,192,194,193,-1,195,196,197,-1,195,5,196,-1,198,199,200,-1,201,202,0,-1,203,204,16,-1,204,17,16,-1,205,206,207,-1,207,208,205,-1,209,210,211,-1,210,212,211,-1,213,214,215,-1,215,216,213,-1,217,215,218,-1,217,216,215,-1,219,220,221,-1,222,223,224,-1,222,225,223,-1,226,227,228,-1,110,229,108,-1,110,230,229,-1,231,232,233,-1,231,234,232,-1,235,127,236,-1,235,237,127,-1,153,151,238,-1,238,239,153,-1,240,241,242,-1,243,244,245,-1,246,244,247,-1,248,249,250,-1,251,252,225,-1,251,253,252,-1,254,255,11,-1,255,256,11,-1,200,199,257,-1,258,259,260,-1,258,261,259,-1,159,216,156,-1,159,213,216,-1,238,151,150,-1,262,263,264,-1,265,266,267,-1,265,267,268,-1,267,269,268,-1,270,70,69,-1,271,272,273,-1,273,274,271,-1,275,276,277,-1,277,278,275,-1,279,280,264,-1,279,281,280,-1,282,283,284,-1,283,285,284,-1,286,29,287,-1,287,288,286,-1,52,289,290,-1,52,291,289,-1,292,293,294,-1,292,295,293,-1,296,297,298,-1,297,299,298,-1,282,276,283,-1,276,275,283,-1,300,301,302,-1,303,304,305,-1,304,306,305,-1,307,22,308,-1,307,309,22,-1,310,311,312,-1,312,313,310,-1,314,315,313,-1,314,316,315,-1,317,318,319,-1,317,320,318,-1,321,322,323,-1,321,324,322,-1,325,316,326,-1,325,327,316,-1,328,329,330,-1,328,331,329,-1,332,33,32,-1,32,333,332,-1,334,335,298,-1,336,337,338,-1,337,339,338,-1,340,341,342,-1,340,343,341,-1,344,345,346,-1,346,347,344,-1,348,349,350,-1,349,351,350,-1,352,353,354,-1,354,355,352,-1,356,357,358,-1,359,360,361,-1,361,362,359,-1,363,329,364,-1,329,331,364,-1,332,333,365,-1,365,366,332,-1,336,367,368,-1,368,369,336,-1,370,371,372,-1,372,158,370,-1,239,157,153,-1,239,238,373,-1,246,374,375,-1,376,377,378,-1,378,379,376,-1,380,381,382,-1,380,383,381,-1,384,385,386,-1,387,386,388,-1,389,385,377,-1,385,384,377,-1,390,377,376,-1,390,389,377,-1,149,391,392,-1,149,152,391,-1,249,393,250,-1,393,394,250,-1,250,395,396,-1,396,397,250,-1,398,399,400,-1,400,401,398,-1,402,403,404,-1,404,405,402,-1,406,407,408,-1,408,409,406,-1,410,411,412,-1,412,413,410,-1,414,415,416,-1,416,413,414,-1,414,417,418,-1,414,419,417,-1,420,421,422,-1,422,423,420,-1,424,420,425,-1,424,426,420,-1,427,428,429,-1,429,430,427,-1,431,432,433,-1,434,435,436,-1,436,437,434,-1,137,438,141,-1,141,138,137,-1,439,440,441,-1,439,442,440,-1,132,441,130,-1,132,443,441,-1,444,139,138,-1,445,384,386,-1,445,446,384,-1,381,446,382,-1,381,384,446,-1,445,447,448,-1,445,449,447,-1,450,444,133,-1,450,451,444,-1,452,441,440,-1,440,453,452,-1,235,451,237,-1,451,450,237,-1,454,455,456,-1,457,458,459,-1,129,460,461,-1,460,462,461,-1,463,107,106,-1,464,465,466,-1,464,467,465,-1,464,468,467,-1,469,470,471,-1,469,472,470,-1,473,474,305,-1,473,475,474,-1,306,476,307,-1,476,477,307,-1,478,477,479,-1,478,480,477,-1,51,181,48,-1,51,183,181,-1,481,53,183,-1,183,51,481,-1,482,49,483,-1,482,50,49,-1,325,484,485,-1,486,52,54,-1,486,291,52,-1,487,488,489,-1,490,365,491,-1,492,333,32,-1,32,493,492,-1,492,493,494,-1,494,495,492,-1,496,179,497,-1,497,498,496,-1,499,28,27,-1,39,37,500,-1,37,300,500,-1,501,502,503,-1,501,504,502,-1,162,161,289,-1,488,505,369,-1,369,506,488,-1,507,368,508,-1,507,509,368,-1,510,164,511,-1,510,165,164,-1,512,513,514,-1,514,515,512,-1,515,514,516,-1,516,517,515,-1,302,301,518,-1,518,517,302,-1,178,519,520,-1,178,500,519,-1,521,522,162,-1,521,523,522,-1,524,525,526,-1,526,527,524,-1,528,524,529,-1,528,516,524,-1,530,531,532,-1,531,533,532,-1,534,535,536,-1,534,537,535,-1,538,539,540,-1,541,513,542,-1,542,538,541,-1,543,544,545,-1,545,546,543,-1,547,548,549,-1,549,550,547,-1,551,552,553,-1,553,539,551,-1,194,554,555,-1,555,556,194,-1,557,532,558,-1,557,535,532,-1,559,189,560,-1,559,190,189,-1,559,561,562,-1,559,563,561,-1,564,565,503,-1,564,566,565,-1,562,567,568,-1,562,561,567,-1,569,570,571,-1,571,572,569,-1,573,574,570,-1,570,569,573,-1,575,576,577,-1,575,564,576,-1,578,579,580,-1,568,581,582,-1,583,582,581,-1,581,584,583,-1,585,586,587,-1,587,588,585,-1,589,590,591,-1,591,592,589,-1,593,594,595,-1,593,596,594,-1,597,598,599,-1,599,600,597,-1,591,601,602,-1,591,590,601,-1,603,604,605,-1,603,606,604,-1,574,573,607,-1,588,605,608,-1,608,609,588,-1,610,611,612,-1,613,607,612,-1,614,615,612,-1,616,617,612,-1,618,609,612,-1,608,619,612,-1,620,621,354,-1,354,622,620,-1,353,356,354,-1,356,622,354,-1,358,623,624,-1,358,625,623,-1,626,627,628,-1,629,630,631,-1,631,632,629,-1,633,634,635,-1,633,636,634,-1,637,638,639,-1,639,640,637,-1,204,641,642,-1,6,8,16,-1,8,643,16,-1,644,645,646,-1,646,647,644,-1,648,649,650,-1,648,651,649,-1,652,653,654,-1,653,655,654,-1,656,657,658,-1,657,659,658,-1,657,660,659,-1,652,661,660,-1,659,662,663,-1,664,665,666,-1,664,198,665,-1,667,20,19,-1,667,668,20,-1,350,21,348,-1,350,19,21,-1,669,670,349,-1,669,671,670,-1,672,673,674,-1,674,675,672,-1,229,674,676,-1,229,675,674,-1,5,221,3,-1,229,677,675,-1,229,230,677,-1,678,219,661,-1,219,662,661,-1,652,654,679,-1,679,680,652,-1,654,681,682,-1,682,679,654,-1,682,683,684,-1,682,685,683,-1,686,683,685,-1,686,687,683,-1,688,689,690,-1,691,255,254,-1,691,692,255,-1,693,677,230,-1,694,669,695,-1,694,671,669,-1,696,697,698,-1,696,699,697,-1,700,701,702,-1,700,703,701,-1,113,704,111,-1,704,705,111,-1,233,232,702,-1,702,701,233,-1,706,707,708,-1,708,709,706,-1,710,711,712,-1,233,713,231,-1,233,707,713,-1,714,715,716,-1,714,717,715,-1,62,64,718,-1,719,65,720,-1,719,89,65,-1,721,716,715,-1,721,722,716,-1,723,724,725,-1,723,726,724,-1,727,728,729,-1,727,730,728,-1,731,732,733,-1,731,734,732,-1,735,736,737,-1,735,738,736,-1,739,740,741,-1,741,742,739,-1,475,99,98,-1,98,474,475,-1,299,169,168,-1,168,743,299,-1,72,71,744,-1,744,338,72,-1,745,337,746,-1,337,505,746,-1,272,281,279,-1,747,262,748,-1,262,749,748,-1,750,278,751,-1,278,266,751,-1,752,753,33,-1,752,754,753,-1,755,756,757,-1,758,759,760,-1,91,761,92,-1,91,762,761,-1,763,764,765,-1,763,766,764,-1,767,768,769,-1,770,60,59,-1,770,771,60,-1,330,329,772,-1,329,773,772,-1,774,775,776,-1,774,777,775,-1,778,779,780,-1,778,781,779,-1,782,783,784,-1,782,785,783,-1,786,366,787,-1,786,332,366,-1,754,752,788,-1,752,780,788,-1,779,776,757,-1,757,756,779,-1,268,789,790,-1,789,757,775,-1,757,776,775,-1,772,791,785,-1,772,773,791,-1,792,774,781,-1,792,793,774,-1,794,793,791,-1,795,771,770,-1,770,796,795,-1,797,267,277,-1,797,269,267,-1,753,754,281,-1,283,798,799,-1,749,262,264,-1,264,280,749,-1,264,284,745,-1,799,338,339,-1,799,72,338,-1,800,801,802,-1,270,803,70,-1,804,741,740,-1,804,805,741,-1,806,807,808,-1,806,809,807,-1,731,807,734,-1,807,95,734,-1,810,811,812,-1,810,813,811,-1,738,733,736,-1,738,731,733,-1,814,815,816,-1,816,103,814,-1,730,737,736,-1,730,727,737,-1,817,818,813,-1,817,819,818,-1,116,820,118,-1,820,119,118,-1,117,63,62,-1,117,821,63,-1,124,126,234,-1,126,232,234,-1,706,713,707,-1,122,702,822,-1,122,700,702,-1,122,114,823,-1,823,700,122,-1,669,824,695,-1,669,825,824,-1,684,826,827,-1,684,683,826,-1,828,359,829,-1,829,830,828,-1,12,831,692,-1,692,691,12,-1,832,833,834,-1,832,835,833,-1,836,688,837,-1,836,832,688,-1,684,679,682,-1,684,838,679,-1,838,680,679,-1,108,838,109,-1,108,680,838,-1,220,678,108,-1,108,229,220,-1,229,676,220,-1,673,672,21,-1,672,348,21,-1,355,19,350,-1,355,667,19,-1,658,663,839,-1,658,659,663,-1,207,840,841,-1,207,842,840,-1,842,843,844,-1,844,845,842,-1,206,846,847,-1,847,843,206,-1,848,647,646,-1,848,849,647,-1,645,644,643,-1,643,8,645,-1,7,850,851,-1,852,853,854,-1,629,855,853,-1,629,636,855,-1,856,857,858,-1,632,626,628,-1,632,631,626,-1,634,628,859,-1,634,632,628,-1,354,667,355,-1,354,621,667,-1,609,608,612,-1,617,618,612,-1,615,616,612,-1,607,614,612,-1,611,613,612,-1,619,610,612,-1,618,588,609,-1,618,585,588,-1,860,861,615,-1,614,573,862,-1,614,607,573,-1,863,603,605,-1,594,589,592,-1,592,595,594,-1,588,587,581,-1,587,584,581,-1,864,865,580,-1,564,866,566,-1,564,575,866,-1,572,566,866,-1,866,569,572,-1,867,191,188,-1,188,868,867,-1,532,533,558,-1,533,869,558,-1,194,556,870,-1,870,193,194,-1,539,553,540,-1,538,542,551,-1,551,539,538,-1,545,871,872,-1,545,544,871,-1,537,532,535,-1,537,530,532,-1,556,873,523,-1,556,555,873,-1,530,874,531,-1,525,514,513,-1,513,541,525,-1,524,514,525,-1,524,516,514,-1,534,875,537,-1,875,876,537,-1,873,552,510,-1,510,877,873,-1,878,163,165,-1,878,879,163,-1,880,881,882,-1,880,520,881,-1,519,528,883,-1,519,302,528,-1,163,879,509,-1,509,507,163,-1,509,879,884,-1,884,506,509,-1,314,313,312,-1,40,39,178,-1,39,500,178,-1,885,286,886,-1,885,29,286,-1,177,887,888,-1,177,889,887,-1,180,491,492,-1,492,495,180,-1,37,890,301,-1,301,300,37,-1,310,889,176,-1,310,891,889,-1,346,892,327,-1,327,893,346,-1,894,895,364,-1,325,896,484,-1,325,482,896,-1,314,326,316,-1,314,481,326,-1,897,186,898,-1,485,899,304,-1,485,484,899,-1,899,476,304,-1,476,306,304,-1,900,303,305,-1,294,901,292,-1,294,478,901,-1,308,473,306,-1,306,307,308,-1,23,309,902,-1,23,22,309,-1,25,308,22,-1,25,903,308,-1,24,904,905,-1,24,906,904,-1,907,908,909,-1,910,120,911,-1,910,912,120,-1,913,914,915,-1,913,916,914,-1,917,916,913,-1,917,918,916,-1,919,920,918,-1,919,921,920,-1,68,463,922,-1,68,107,463,-1,923,924,925,-1,926,458,455,-1,926,927,458,-1,928,929,236,-1,929,930,236,-1,931,932,933,-1,934,935,936,-1,457,937,938,-1,457,459,937,-1,939,940,938,-1,939,941,940,-1,452,130,441,-1,452,942,130,-1,943,944,945,-1,439,441,443,-1,946,947,948,-1,946,949,947,-1,442,950,951,-1,442,439,950,-1,952,953,954,-1,955,956,436,-1,956,437,436,-1,957,958,959,-1,960,434,437,-1,960,961,434,-1,962,434,961,-1,433,432,963,-1,432,964,963,-1,965,966,432,-1,966,967,432,-1,420,423,425,-1,419,412,426,-1,412,968,426,-1,969,970,143,-1,0,202,403,-1,202,404,403,-1,971,393,402,-1,972,399,398,-1,973,395,394,-1,395,250,394,-1,201,2,224,-1,201,0,2,-1,149,392,974,-1,390,376,211,-1,211,212,390,-1,389,975,976,-1,976,385,389,-1,384,381,378,-1,378,377,384,-1,383,977,978,-1,978,979,383,-1,376,980,211,-1,376,379,980,-1,981,247,397,-1,247,982,397,-1,983,984,985,-1,983,986,984,-1,987,988,989,-1,988,990,989,-1,155,991,391,-1,391,152,155,-1,157,239,370,-1,370,158,157,-1,371,983,992,-1,297,993,293,-1,297,296,993,-1,368,506,369,-1,368,509,506,-1,338,367,336,-1,338,744,367,-1,33,271,34,-1,33,753,271,-1,496,994,995,-1,496,498,994,-1,996,694,997,-1,998,999,1000,-1,998,1001,999,-1,15,831,12,-1,15,978,831,-1,1002,1003,1004,-1,1004,1005,1002,-1,639,638,1006,-1,1006,1007,639,-1,1008,1009,1010,-1,1008,1011,1009,-1,1012,1013,933,-1,1012,1011,1013,-1,356,624,622,-1,356,358,624,-1,1014,856,858,-1,0,403,1,-1,893,1015,347,-1,347,346,893,-1,1016,166,1017,-1,1016,167,166,-1,488,487,273,-1,273,1018,488,-1,1019,784,783,-1,765,303,900,-1,765,1020,303,-1,311,874,312,-1,311,880,874,-1,346,345,1021,-1,1021,892,346,-1,480,309,307,-1,307,477,480,-1,1022,1023,1024,-1,276,282,263,-1,263,1025,276,-1,477,1026,479,-1,993,1027,293,-1,1027,294,293,-1,499,27,286,-1,286,288,499,-1,487,274,273,-1,280,281,754,-1,38,28,499,-1,748,757,759,-1,748,755,757,-1,285,745,284,-1,1018,279,746,-1,277,267,266,-1,266,278,277,-1,273,272,279,-1,279,1018,273,-1,173,1028,171,-1,1029,805,1030,-1,262,747,1025,-1,1025,263,262,-1,755,748,749,-1,156,217,154,-1,156,216,217,-1,1031,258,1032,-1,258,1033,1032,-1,1034,1035,406,-1,1036,403,402,-1,257,199,1037,-1,1037,1038,257,-1,622,624,620,-1,1003,633,857,-1,1003,1039,633,-1,223,150,974,-1,243,248,982,-1,375,1040,1041,-1,1042,1043,433,-1,1043,431,433,-1,935,934,452,-1,452,453,935,-1,127,928,236,-1,127,461,928,-1,108,678,680,-1,115,693,110,-1,693,230,110,-1,447,945,1044,-1,392,202,974,-1,202,201,974,-1,1045,1040,980,-1,1045,1041,1040,-1,219,221,5,-1,5,195,219,-1,21,20,1046,-1,20,1047,1046,-1,17,204,642,-1,642,10,17,-1,991,218,1048,-1,991,217,218,-1,391,1049,202,-1,202,392,391,-1,228,1050,226,-1,1050,261,226,-1,1051,1052,1053,-1,1053,422,1051,-1,148,147,424,-1,147,417,424,-1,395,973,1054,-1,973,1055,1054,-1,210,396,212,-1,396,1056,212,-1,1057,208,841,-1,208,207,841,-1,630,852,644,-1,852,643,644,-1,223,225,150,-1,663,195,197,-1,220,219,678,-1,504,1058,1059,-1,504,501,1058,-1,1060,547,1061,-1,1062,897,898,-1,1063,1064,1065,-1,1064,1026,1065,-1,1066,497,885,-1,497,30,885,-1,31,30,179,-1,30,497,179,-1,1066,885,886,-1,886,1067,1066,-1,177,176,889,-1,782,772,785,-1,295,1068,1069,-1,1069,1070,295,-1,1070,1069,166,-1,166,169,1070,-1,1071,163,507,-1,1071,164,163,-1,511,1072,510,-1,1073,290,289,-1,154,153,157,-1,157,156,154,-1,150,149,974,-1,430,1074,1053,-1,430,966,1074,-1,143,970,145,-1,970,1075,145,-1,435,434,132,-1,584,600,593,-1,593,583,584,-1,444,952,139,-1,444,1076,952,-1,955,438,136,-1,136,135,955,-1,960,964,961,-1,960,963,964,-1,1077,1078,1079,-1,1077,1080,1078,-1,1081,1082,1083,-1,129,106,460,-1,129,104,106,-1,112,126,113,-1,112,822,126,-1,118,120,912,-1,912,821,118,-1,732,816,815,-1,732,734,816,-1,128,936,104,-1,693,115,123,-1,461,127,129,-1,704,113,125,-1,473,305,306,-1,100,816,97,-1,816,734,97,-1,98,99,93,-1,99,94,93,-1,95,97,734,-1,93,96,91,-1,93,94,96,-1,1084,75,83,-1,1085,84,81,-1,81,80,1085,-1,1086,86,1087,-1,1087,1088,1086,-1,74,82,81,-1,74,73,82,-1,77,1089,1090,-1,1089,1091,1090,-1,86,88,1090,-1,1084,83,1089,-1,78,73,89,-1,75,74,83,-1,1092,283,275,-1,1092,798,283,-1,1093,801,1094,-1,801,800,1094,-1,761,58,57,-1,737,812,735,-1,737,810,812,-1,173,170,1095,-1,1095,1096,173,-1,55,183,53,-1,898,186,44,-1,186,41,44,-1,36,494,37,-1,287,29,31,-1,29,885,30,-1,894,887,1021,-1,691,13,12,-1,691,1097,13,-1,18,10,9,-1,18,17,10,-1,633,858,857,-1,633,635,858,-1,1097,254,1098,-1,254,1097,691,-1,902,993,1099,-1,1027,993,902,-1,888,894,364,-1,888,887,894,-1,429,1100,1101,-1,429,428,1100,-1,1102,1103,1104,-1,1102,1032,1103,-1,992,372,371,-1,992,1033,372,-1,494,890,37,-1,494,493,890,-1,48,1062,49,-1,1062,48,185,-1,1028,1096,1105,-1,1028,173,1096,-1,1106,742,741,-1,1107,742,1106,-1,1108,812,1109,-1,735,812,1108,-1,1110,796,770,-1,1110,790,796,-1,59,56,1111,-1,57,56,59,-1,1073,170,1068,-1,1073,1095,170,-1,88,73,78,-1,88,82,73,-1,77,88,78,-1,77,1090,88,-1,1086,87,86,-1,1086,1112,87,-1,1085,1088,1087,-1,1113,1088,1085,-1,1114,80,85,-1,1114,1115,80,-1,1087,84,1085,-1,1087,1091,84,-1,1113,1086,1088,-1,1112,1115,1114,-1,1113,1112,1086,-1,1113,1115,1112,-1,125,66,718,-1,124,66,125,-1,1084,815,820,-1,815,1084,732,-1,1116,103,1117,-1,814,103,1116,-1,821,317,63,-1,821,912,317,-1,942,237,450,-1,237,942,1118,-1,102,1117,103,-1,102,903,1117,-1,106,319,460,-1,319,106,107,-1,1081,1119,240,-1,1081,1083,1119,-1,241,1080,1077,-1,241,1120,1080,-1,963,1079,1078,-1,1079,963,960,-1,436,438,955,-1,436,141,438,-1,957,1121,958,-1,957,1122,1121,-1,137,952,954,-1,139,952,137,-1,583,595,1123,-1,583,593,595,-1,597,584,587,-1,584,597,600,-1,1124,602,586,-1,1124,591,602,-1,131,435,132,-1,140,435,131,-1,1125,1126,1127,-1,1128,1126,1125,-1,966,1129,1074,-1,966,965,1129,-1,427,1053,1052,-1,427,430,1053,-1,227,1031,1130,-1,1031,227,226,-1,260,1033,258,-1,260,372,1033,-1,1071,508,1131,-1,1071,507,508,-1,290,1068,295,-1,290,1073,1068,-1,1016,1093,1132,-1,1016,801,1093,-1,802,1016,1017,-1,801,1016,802,-1,886,888,1067,-1,888,886,26,-1,330,782,994,-1,330,772,782,-1,328,497,1066,-1,328,498,497,-1,888,28,177,-1,888,26,28,-1,1062,483,49,-1,483,1062,898,-1,1023,1133,1064,-1,1023,1022,1133,-1,42,187,1063,-1,42,41,187,-1,1064,479,1026,-1,1064,1133,479,-1,557,560,189,-1,557,558,560,-1,504,554,1134,-1,1059,554,504,-1,1135,501,1136,-1,1135,1058,501,-1,526,871,544,-1,871,526,1137,-1,1138,343,1060,-1,341,343,1138,-1,543,1139,527,-1,1139,543,548,-1,1140,189,188,-1,1140,557,189,-1,379,1045,980,-1,379,1141,1045,-1,642,1098,10,-1,1098,642,1142,-1,1143,13,1097,-1,1143,1144,13,-1,1145,676,674,-1,1145,3,676,-1,1046,673,21,-1,1046,1146,673,-1,1147,225,222,-1,1147,251,225,-1,625,1037,623,-1,625,1148,1037,-1,20,664,1047,-1,664,20,668,-1,1149,196,1150,-1,1149,197,196,-1,644,631,630,-1,631,644,647,-1,849,627,626,-1,627,849,846,-1,841,1150,1057,-1,841,1149,1150,-1,395,1056,396,-1,395,1054,1056,-1,973,1151,1055,-1,1151,973,1152,-1,1153,1075,1154,-1,145,1075,1153,-1,1155,144,1156,-1,1127,144,1155,-1,417,1125,418,-1,417,147,1125,-1,424,1129,148,-1,424,425,1129,-1,423,1053,1074,-1,423,422,1053,-1,227,1051,228,-1,1051,227,1052,-1,261,1157,259,-1,261,1050,1157,-1,391,1048,1049,-1,391,991,1048,-1,198,1158,199,-1,198,1159,1158,-1,203,643,852,-1,643,203,16,-1,845,840,842,-1,845,656,840,-1,234,1160,67,-1,1160,234,231,-1,921,461,462,-1,461,921,928,-1,1161,224,2,-1,1161,222,224,-1,378,1141,379,-1,378,979,1141,-1,243,247,244,-1,982,247,243,-1,222,1162,1147,-1,222,1161,1162,-1,1163,1003,857,-1,1004,1003,1163,-1,1158,624,623,-1,1158,620,624,-1,1164,403,1036,-1,1,403,1164,-1,1035,1165,971,-1,1035,1034,1165,-1,258,226,261,-1,258,1031,226,-1,741,1029,1106,-1,805,1029,741,-1,750,1166,1092,-1,750,1030,1166,-1,521,875,534,-1,521,162,875,-1,290,292,52,-1,290,295,292,-1,160,1105,1096,-1,160,1167,1105,-1,337,285,339,-1,745,285,337,-1,760,757,789,-1,759,757,760,-1,33,786,752,-1,786,33,332,-1,272,753,281,-1,753,272,271,-1,1168,1169,925,-1,917,1169,1168,-1,1170,468,1000,-1,468,1170,467,-1,759,747,748,-1,758,747,759,-1,586,578,1124,-1,586,585,578,-1,896,899,484,-1,896,1171,899,-1,891,892,1021,-1,892,891,315,-1,766,1172,764,-1,1173,1172,766,-1,765,1015,1020,-1,764,1015,765,-1,893,1020,1015,-1,893,485,1020,-1,1066,331,328,-1,331,1066,1067,-1,1174,743,1175,-1,743,1174,334,-1,1176,1177,1178,-1,1176,1179,1177,-1,1175,168,175,-1,1175,743,168,-1,1016,174,167,-1,174,1016,1131,-1,175,744,1175,-1,744,175,367,-1,299,1070,169,-1,297,1070,299,-1,1180,345,344,-1,1180,895,345,-1,1181,253,251,-1,1181,357,253,-1,253,1182,252,-1,253,1183,1182,-1,1184,1182,1183,-1,989,1182,1184,-1,1185,987,1186,-1,1187,987,1185,-1,1188,671,1189,-1,1188,670,671,-1,1012,932,1190,-1,1012,933,932,-1,1010,704,125,-1,1009,704,1010,-1,1191,1192,1193,-1,1192,1191,1194,-1,638,1005,1006,-1,638,1002,1005,-1,639,1195,1144,-1,1195,639,1007,-1,977,831,978,-1,977,1196,831,-1,1197,829,1198,-1,1197,1199,829,-1,999,1170,1000,-1,999,1200,1170,-1,907,1001,998,-1,907,1201,1001,-1,1202,1203,909,-1,1202,1204,1203,-1,1177,1205,1206,-1,1177,1179,1205,-1,1207,1193,1192,-1,1207,1208,1193,-1,857,1162,1163,-1,1162,857,856,-1,995,490,496,-1,995,1209,490,-1,337,369,505,-1,369,337,336,-1,508,367,175,-1,508,368,367,-1,1138,563,1210,-1,1138,1211,563,-1,424,419,426,-1,424,417,419,-1,1103,983,985,-1,992,983,1103,-1,990,371,370,-1,988,371,990,-1,225,238,150,-1,225,252,238,-1,1182,990,373,-1,1182,989,990,-1,986,987,1187,-1,986,988,987,-1,1187,984,986,-1,1188,984,1187,-1,1006,375,1007,-1,246,375,1006,-1,981,209,374,-1,981,210,209,-1,15,979,978,-1,1141,979,15,-1,979,381,383,-1,979,378,381,-1,1161,1163,1162,-1,1161,1212,1163,-1,245,1,1164,-1,1,245,1212,-1,243,1164,248,-1,243,245,1164,-1,210,397,396,-1,210,981,397,-1,1054,1213,1214,-1,1054,1055,1213,-1,1215,1216,975,-1,1216,1215,1214,-1,1216,400,1217,-1,1216,1218,400,-1,1219,388,1220,-1,1219,387,388,-1,1221,1220,399,-1,1221,1219,1220,-1,399,1217,400,-1,399,1220,1217,-1,1055,1222,1213,-1,1151,1222,1055,-1,394,971,1165,-1,394,393,971,-1,249,402,393,-1,402,249,1036,-1,1154,1165,1034,-1,1165,1154,1152,-1,1222,1082,1223,-1,1222,970,1082,-1,958,1223,1082,-1,958,401,1223,-1,970,1083,1082,-1,970,969,1083,-1,1153,1034,406,-1,1034,1153,1154,-1,1224,405,404,-1,1224,407,405,-1,1049,1225,1224,-1,1049,1048,1225,-1,142,969,143,-1,142,1226,969,-1,240,959,1081,-1,959,240,242,-1,1227,1048,218,-1,1225,1048,1227,-1,1227,413,416,-1,1227,410,413,-1,1126,1226,142,-1,1126,1228,1226,-1,1043,1229,1128,-1,1229,1043,1042,-1,1120,1229,1080,-1,1228,1229,1120,-1,1230,412,411,-1,1230,968,412,-1,426,421,420,-1,968,421,426,-1,1230,1050,1231,-1,1230,1157,1050,-1,433,1078,1042,-1,1078,433,963,-1,1101,967,429,-1,967,1101,1232,-1,1233,1103,985,-1,1103,1233,1104,-1,962,964,1232,-1,964,962,961,-1,1101,951,950,-1,1100,951,1101,-1,432,1232,964,-1,1232,432,967,-1,960,956,1079,-1,956,960,437,-1,242,1077,1234,-1,1077,242,241,-1,1121,401,958,-1,1121,398,401,-1,1235,1122,953,-1,1235,1121,1122,-1,957,242,134,-1,957,959,242,-1,135,956,955,-1,135,1234,956,-1,1236,953,952,-1,1235,953,1236,-1,950,443,962,-1,439,443,950,-1,1237,951,1233,-1,1237,442,951,-1,984,946,985,-1,949,946,984,-1,949,996,947,-1,949,1189,996,-1,1238,946,948,-1,1237,946,1238,-1,1239,1236,1240,-1,1236,1239,1241,-1,1219,944,943,-1,1219,1221,944,-1,939,380,382,-1,380,939,1242,-1,446,448,941,-1,445,448,446,-1,944,1243,945,-1,1243,944,1239,-1,1244,1076,1245,-1,1244,1240,1076,-1,948,1246,1238,-1,1247,1246,948,-1,996,1248,947,-1,997,1248,996,-1,1249,1248,931,-1,1247,1248,1249,-1,935,1246,1250,-1,453,1246,935,-1,1251,1245,1252,-1,1244,1245,1251,-1,1044,1243,1253,-1,945,1243,1044,-1,941,1254,940,-1,941,448,1254,-1,938,1242,939,-1,1242,938,937,-1,1198,459,1197,-1,459,1198,937,-1,457,940,456,-1,457,938,940,-1,1044,454,1254,-1,1255,454,1044,-1,1256,1251,1257,-1,1256,1253,1251,-1,235,930,1252,-1,930,235,236,-1,1250,936,935,-1,1258,936,1250,-1,1259,931,933,-1,1259,1249,931,-1,933,1260,1259,-1,933,1013,1260,-1,1258,104,936,-1,1258,105,104,-1,930,1261,1257,-1,1261,930,929,-1,1256,923,1255,-1,1256,924,923,-1,458,1192,1194,-1,927,1192,458,-1,923,926,455,-1,925,926,923,-1,1168,929,919,-1,1168,1261,929,-1,1013,463,1260,-1,922,463,1013,-1,462,920,921,-1,462,318,920,-1,917,919,918,-1,1168,919,917,-1,465,926,466,-1,927,926,465,-1,917,1262,1169,-1,917,913,1262,-1,920,916,918,-1,920,1263,916,-1,912,320,317,-1,320,912,910,-1,1263,914,916,-1,1263,1264,914,-1,1265,913,915,-1,1262,913,1265,-1,1265,1266,468,-1,1267,1266,1265,-1,915,469,1268,-1,914,469,915,-1,1264,911,472,-1,911,1264,910,-1,911,121,1269,-1,911,120,121,-1,1268,1270,1267,-1,1268,1271,1270,-1,998,908,907,-1,998,1266,908,-1,908,1272,909,-1,1272,908,1270,-1,1273,1271,471,-1,1273,1274,1271,-1,470,1275,1276,-1,1275,470,1269,-1,1275,1117,1277,-1,1275,1116,1117,-1,905,1273,1276,-1,1273,905,904,-1,1278,1274,1279,-1,1272,1274,1278,-1,1280,1202,1278,-1,1280,1206,1202,-1,906,1279,904,-1,906,1281,1279,-1,903,1277,1117,-1,1277,903,25,-1,903,473,308,-1,102,473,903,-1,1282,24,23,-1,906,24,1282,-1,1280,1283,1284,-1,1280,1281,1283,-1,1178,1284,1285,-1,1284,1178,1177,-1,1282,1286,1283,-1,1099,1286,1282,-1,296,1099,993,-1,1099,296,1286,-1,1285,296,298,-1,1286,296,1285,-1,1167,1094,1105,-1,1167,1287,1094,-1,166,172,1017,-1,172,166,1069,-1,901,52,292,-1,901,55,52,-1,1022,47,46,-1,1022,1024,47,-1,1065,477,476,-1,1065,1026,477,-1,42,1065,1171,-1,42,1063,1065,-1,896,42,1171,-1,896,43,42,-1,482,43,896,-1,482,483,43,-1,326,482,325,-1,482,326,50,-1,1018,505,488,-1,1018,746,505,-1,511,1071,1132,-1,511,164,1071,-1,486,314,312,-1,486,54,314,-1,315,327,892,-1,315,316,327,-1,1021,895,894,-1,1021,345,895,-1,274,301,890,-1,274,518,301,-1,286,26,886,-1,286,27,26,-1,312,876,486,-1,312,874,876,-1,176,311,310,-1,176,178,311,-1,300,519,500,-1,302,519,300,-1,881,519,883,-1,520,519,881,-1,878,884,879,-1,878,512,884,-1,551,878,165,-1,551,542,878,-1,877,523,873,-1,877,522,523,-1,874,537,876,-1,874,530,537,-1,529,527,1139,-1,529,524,527,-1,343,1288,1289,-1,340,1288,343,-1,342,881,340,-1,342,882,881,-1,880,531,874,-1,880,882,531,-1,553,873,555,-1,553,552,873,-1,556,521,870,-1,556,523,521,-1,525,1137,526,-1,1137,525,541,-1,1136,503,565,-1,503,1136,501,-1,553,554,1059,-1,553,555,554,-1,192,867,1290,-1,192,191,867,-1,1140,870,536,-1,1140,193,870,-1,1060,1211,1138,-1,1061,1211,1060,-1,1061,1291,1211,-1,1061,1292,1291,-1,868,190,1293,-1,188,190,868,-1,545,572,571,-1,545,872,572,-1,502,1294,576,-1,1295,1294,502,-1,864,1290,867,-1,864,1296,1290,-1,546,571,1297,-1,546,545,571,-1,1298,550,549,-1,1299,550,1298,-1,1292,1300,1291,-1,1300,1292,1301,-1,562,582,1293,-1,582,562,568,-1,1298,1302,1303,-1,1298,1297,1302,-1,1304,1301,1299,-1,606,1301,1304,-1,1305,1303,1302,-1,1306,1303,1305,-1,866,860,862,-1,860,866,575,-1,1307,577,1308,-1,1307,861,577,-1,579,1294,1296,-1,1308,1294,579,-1,1296,580,579,-1,864,580,1296,-1,1123,580,865,-1,1123,1309,580,-1,594,1310,589,-1,1310,594,1311,-1,1312,596,599,-1,1313,596,1312,-1,1314,598,601,-1,1315,598,1314,-1,1301,603,1300,-1,603,1301,606,-1,1316,606,1304,-1,606,1316,604,-1,1306,613,611,-1,613,1306,1305,-1,615,862,860,-1,615,614,862,-1,616,861,1307,-1,616,615,861,-1,578,618,617,-1,618,578,585,-1,610,604,1316,-1,619,604,610,-1,621,668,667,-1,621,1159,668,-1,353,1186,1184,-1,1186,353,352,-1,1317,208,1057,-1,1317,1318,208,-1,665,200,1319,-1,198,200,665,-1,1320,1321,1322,-1,1319,1321,1320,-1,1038,1323,1324,-1,1325,1323,1038,-1,1321,1326,1322,-1,1324,1326,1321,-1,628,1326,859,-1,628,1327,1326,-1,634,1323,635,-1,1323,634,859,-1,1327,1322,1326,-1,1318,1322,1327,-1,855,633,1039,-1,636,633,855,-1,630,853,852,-1,853,630,629,-1,854,855,1328,-1,855,854,853,-1,1329,1003,1002,-1,1329,1039,1003,-1,1329,1330,1328,-1,1329,637,1330,-1,203,854,1331,-1,852,854,203,-1,641,1330,1332,-1,1331,1330,641,-1,640,1142,1332,-1,640,1143,1142,-1,850,1333,851,-1,1333,850,1334,-1,1335,1336,1337,-1,1335,1338,1336,-1,7,1335,1339,-1,851,1335,7,-1,8,1339,645,-1,8,7,1339,-1,849,847,846,-1,847,849,848,-1,646,651,848,-1,1340,651,646,-1,648,843,847,-1,844,843,648,-1,843,207,206,-1,842,207,843,-1,655,845,844,-1,653,845,655,-1,649,681,650,-1,681,649,1341,-1,656,839,840,-1,656,658,839,-1,840,1149,841,-1,1149,840,839,-1,1057,1342,1317,-1,1150,1342,1057,-1,1343,1344,1342,-1,1343,1345,1344,-1,1345,665,1344,-1,666,665,1345,-1,1346,1345,1347,-1,666,1345,1346,-1,352,1185,1186,-1,352,351,1185,-1,3,1347,4,-1,1145,1347,3,-1,672,825,348,-1,672,1348,825,-1,1338,686,1336,-1,686,1338,833,-1,1349,832,836,-1,1349,835,832,-1,1333,833,1338,-1,834,833,1333,-1,256,689,1334,-1,689,256,690,-1,1196,692,831,-1,692,1196,1350,-1,255,690,256,-1,690,255,1351,-1,1350,1352,1351,-1,1350,1353,1352,-1,1353,359,828,-1,1353,360,359,-1,1352,837,688,-1,1352,1354,837,-1,1355,683,687,-1,683,1355,826,-1,827,838,684,-1,827,823,838,-1,1348,824,825,-1,1348,1356,824,-1,824,1357,695,-1,1358,1357,824,-1,693,1359,1356,-1,693,123,1359,-1,703,823,827,-1,703,700,823,-1,826,1360,1361,-1,1360,826,1355,-1,1349,1362,1363,-1,1362,1349,836,-1,1354,696,837,-1,699,696,1354,-1,1199,830,829,-1,830,1199,1364,-1,1365,1363,1362,-1,1363,1365,1366,-1,709,1361,1360,-1,1361,709,708,-1,112,1359,123,-1,1359,112,111,-1,1357,705,1367,-1,1357,1358,705,-1,1367,1011,1012,-1,1009,1011,1367,-1,1366,1368,1369,-1,1368,1366,1365,-1,712,698,697,-1,712,1370,698,-1,1364,1191,710,-1,1191,1364,1199,-1,1368,1371,1372,-1,1368,1370,1371,-1,706,1373,713,-1,706,1369,1373,-1,125,64,1010,-1,718,64,125,-1,231,714,1160,-1,714,231,713,-1,1374,1373,1372,-1,1374,717,1373,-1,1375,1371,711,-1,1375,1376,1371,-1,1377,1208,1200,-1,1375,1208,1377,-1,725,1374,1376,-1,1374,725,724,-1,1200,1378,1377,-1,999,1378,1200,-1,723,1379,1380,-1,723,1378,1379,-1,726,729,721,-1,726,1381,729,-1,728,719,722,-1,719,728,76,-1,117,118,821,-1,118,117,116,-1,79,1089,77,-1,79,1084,1089,-1,1382,1380,817,-1,1380,1382,1381,-1,1001,819,1379,-1,819,1001,1201,-1,818,1201,1203,-1,819,1201,818,-1,817,810,1382,-1,817,813,810,-1,733,730,736,-1,79,730,733,-1,119,815,814,-1,119,820,815,-1,818,811,813,-1,1383,811,818,-1,1383,1205,1384,-1,1383,1204,1205,-1,1109,811,1385,-1,812,811,1109,-1,738,807,731,-1,738,808,807,-1,103,100,101,-1,103,816,100,-1,809,95,807,-1,809,96,95,-1,1108,806,808,-1,1108,1107,806,-1,739,1384,1386,-1,739,1385,1384,-1,1386,1176,1387,-1,1386,1179,1176,-1,809,1388,762,-1,809,806,1388,-1,740,270,804,-1,270,740,1387,-1,1030,804,1166,-1,805,804,1030,-1,263,284,264,-1,263,282,284,-1,72,798,69,-1,799,798,72,-1,788,280,754,-1,280,788,749,-1,1388,1029,58,-1,1388,1106,1029,-1,56,1029,751,-1,58,1029,56,-1,90,763,1389,-1,763,90,769,-1,60,766,768,-1,60,1173,766,-1,266,1110,1111,-1,1110,266,265,-1,795,775,777,-1,795,796,775,-1,323,795,321,-1,323,771,795,-1,322,347,1172,-1,344,347,322,-1,1390,1180,324,-1,363,1180,1390,-1,791,1390,794,-1,1390,791,773,-1,792,791,793,-1,785,791,792,-1,778,792,781,-1,1391,792,778,-1,1209,784,1019,-1,1209,995,784,-1,1391,786,787,-1,786,1391,778,-1,779,788,780,-1,756,788,779,-1,778,752,786,-1,752,778,780,-1,787,783,1391,-1,787,1019,783,-1,1019,366,1209,-1,1019,787,366,-1,784,994,782,-1,995,994,784,-1,785,1391,783,-1,1391,785,792,-1,774,779,781,-1,774,776,779,-1,794,774,793,-1,774,794,777,-1,773,363,1390,-1,329,363,773,-1,344,324,1180,-1,344,322,324,-1,1173,771,323,-1,1173,60,771,-1,321,777,794,-1,321,795,777,-1,265,790,1110,-1,790,265,268,-1,751,1111,56,-1,1111,751,266,-1,769,766,763,-1,768,766,769,-1,1015,1172,347,-1,1172,1015,764,-1,1389,765,900,-1,763,765,1389,-1,98,1389,474,-1,1389,98,90,-1,767,761,57,-1,767,92,761,-1,762,58,761,-1,762,1388,58,-1,797,760,269,-1,758,760,797,-1,756,749,788,-1,755,749,756,-1,276,797,277,-1,276,1025,797,-1,69,1092,1166,-1,1092,69,798,-1,264,746,279,-1,264,745,746,-1,1166,270,69,-1,270,1166,804,-1,1387,803,270,-1,803,1387,1176,-1,96,762,91,-1,96,809,762,-1,806,1106,1388,-1,806,1107,1106,-1,1386,740,739,-1,1386,1387,740,-1,1205,1386,1384,-1,1179,1386,1205,-1,1385,742,1109,-1,742,1385,739,-1,99,101,100,-1,99,475,101,-1,735,808,738,-1,735,1108,808,-1,1385,1383,1384,-1,811,1383,1385,-1,1203,1383,818,-1,1204,1383,1203,-1,732,79,733,-1,732,1084,79,-1,1382,737,727,-1,1382,810,737,-1,819,1380,1379,-1,817,1380,819,-1,727,1381,1382,-1,727,729,1381,-1,730,76,728,-1,730,79,76,-1,78,719,76,-1,719,78,89,-1,728,721,729,-1,722,721,728,-1,1381,723,1380,-1,726,723,1381,-1,999,1379,1378,-1,999,1001,1379,-1,1377,723,725,-1,1378,723,1377,-1,721,724,726,-1,721,715,724,-1,720,722,719,-1,722,720,716,-1,716,1160,714,-1,1160,716,720,-1,717,724,715,-1,717,1374,724,-1,1377,1376,1375,-1,1376,1377,725,-1,1208,711,1193,-1,1208,1375,711,-1,1376,1372,1371,-1,1376,1374,1372,-1,717,713,1373,-1,717,714,713,-1,124,67,66,-1,67,124,234,-1,1372,1369,1368,-1,1369,1372,1373,-1,1370,711,1371,-1,1370,712,711,-1,710,1193,711,-1,710,1191,1193,-1,710,697,1364,-1,710,712,697,-1,1370,1365,698,-1,1370,1368,1365,-1,1369,709,1366,-1,1369,706,709,-1,701,707,233,-1,701,708,707,-1,232,822,702,-1,232,126,822,-1,1009,705,704,-1,1009,1367,705,-1,1012,1357,1367,-1,1012,1190,1357,-1,705,1359,111,-1,1358,1359,705,-1,708,703,1361,-1,703,708,701,-1,1360,1366,709,-1,1360,1363,1366,-1,698,1362,696,-1,1362,698,1365,-1,1364,699,830,-1,699,1364,697,-1,1354,830,699,-1,830,1354,828,-1,836,696,1362,-1,696,836,837,-1,1355,1363,1360,-1,1363,1355,1349,-1,827,1361,703,-1,1361,827,826,-1,1358,1356,1359,-1,1358,824,1356,-1,695,1190,694,-1,1357,1190,695,-1,677,1356,1348,-1,693,1356,677,-1,109,823,114,-1,109,838,823,-1,1349,687,835,-1,687,1349,1355,-1,828,1352,1353,-1,1352,828,1354,-1,690,1352,688,-1,1352,690,1351,-1,1351,692,1350,-1,255,692,1351,-1,1350,360,1353,-1,1350,1196,360,-1,832,689,688,-1,832,834,689,-1,686,835,687,-1,835,686,833,-1,685,1336,686,-1,1336,685,1341,-1,1341,682,681,-1,685,682,1341,-1,680,661,652,-1,661,680,678,-1,677,672,675,-1,677,1348,672,-1,669,348,825,-1,669,349,348,-1,1346,1145,1146,-1,1346,1347,1145,-1,1046,1346,1146,-1,1046,1047,1346,-1,349,1185,351,-1,349,670,1185,-1,1047,666,1346,-1,1047,664,666,-1,5,1343,196,-1,1343,5,4,-1,1344,1319,1320,-1,665,1319,1344,-1,4,1345,1343,-1,4,1347,1345,-1,1342,196,1343,-1,1342,1150,196,-1,1344,1317,1342,-1,1344,1320,1317,-1,839,197,1149,-1,839,663,197,-1,659,661,662,-1,659,660,661,-1,652,657,653,-1,652,660,657,-1,653,656,845,-1,656,653,657,-1,681,655,650,-1,654,655,681,-1,1341,1337,1336,-1,1341,649,1337,-1,844,650,655,-1,844,648,650,-1,651,1337,649,-1,651,1340,1337,-1,651,847,848,-1,651,648,847,-1,645,1340,646,-1,645,1339,1340,-1,1333,1335,851,-1,1335,1333,1338,-1,1339,1337,1340,-1,1337,1339,1335,-1,1334,18,9,-1,850,18,1334,-1,642,1332,1142,-1,642,641,1332,-1,639,1143,640,-1,639,1144,1143,-1,637,1332,1330,-1,637,640,1332,-1,1331,204,203,-1,1331,641,204,-1,1331,1328,1330,-1,854,1328,1331,-1,1002,637,1329,-1,637,1002,638,-1,1039,1328,855,-1,1039,1329,1328,-1,634,629,632,-1,636,629,634,-1,627,1327,628,-1,205,1327,627,-1,1318,205,208,-1,1318,1327,205,-1,859,1324,1323,-1,859,1326,1324,-1,635,1325,858,-1,1323,1325,635,-1,1324,257,1038,-1,257,1324,1321,-1,1320,1318,1317,-1,1320,1322,1318,-1,1319,257,1321,-1,200,257,1319,-1,1325,1037,1148,-1,1038,1037,1325,-1,858,1148,1014,-1,1325,1148,858,-1,353,1183,356,-1,353,1184,1183,-1,1159,620,1158,-1,620,1159,621,-1,1181,358,357,-1,1181,625,358,-1,619,605,604,-1,608,605,619,-1,1307,617,616,-1,617,1307,578,-1,574,613,1305,-1,607,613,574,-1,1316,611,610,-1,611,1316,1306,-1,1300,863,567,-1,863,1300,603,-1,863,588,581,-1,588,863,605,-1,597,601,598,-1,602,601,597,-1,600,596,593,-1,600,599,596,-1,1314,590,1392,-1,590,1314,601,-1,1315,599,598,-1,1312,599,1315,-1,1311,596,1313,-1,1311,594,596,-1,589,1392,590,-1,1392,589,1310,-1,582,1123,865,-1,583,1123,582,-1,567,581,568,-1,581,567,863,-1,1309,578,580,-1,1309,1124,578,-1,578,1308,579,-1,578,1307,1308,-1,1308,576,1294,-1,1308,577,576,-1,861,575,577,-1,861,860,575,-1,862,569,866,-1,862,573,569,-1,570,1305,1302,-1,574,1305,570,-1,1306,1304,1303,-1,1316,1304,1306,-1,1303,1299,1298,-1,1304,1299,1303,-1,1302,571,570,-1,1297,571,1302,-1,1293,865,868,-1,1293,582,865,-1,1291,567,561,-1,1291,1300,567,-1,550,1301,1292,-1,1301,550,1299,-1,1298,546,1297,-1,1298,549,546,-1,868,864,867,-1,868,865,864,-1,1296,1295,1290,-1,1296,1294,1295,-1,576,503,502,-1,576,564,503,-1,566,872,565,-1,566,572,872,-1,1293,559,562,-1,190,559,1293,-1,561,1211,1291,-1,563,1211,561,-1,547,1292,1061,-1,547,550,1292,-1,559,1210,563,-1,559,560,1210,-1,536,557,1140,-1,557,536,535,-1,192,1295,1134,-1,1290,1295,192,-1,504,1295,502,-1,1295,504,1134,-1,1059,540,553,-1,1059,1058,540,-1,546,548,543,-1,549,548,546,-1,871,565,872,-1,565,871,1136,-1,1135,541,538,-1,1137,541,1135,-1,538,1058,1135,-1,1058,538,540,-1,521,536,870,-1,534,536,521,-1,882,533,531,-1,533,882,342,-1,340,883,1288,-1,881,883,340,-1,1288,528,529,-1,883,528,1288,-1,529,1289,1288,-1,529,1139,1289,-1,552,165,510,-1,552,551,165,-1,178,880,311,-1,520,880,178,-1,516,302,517,-1,302,516,528,-1,517,489,515,-1,518,489,517,-1,542,512,878,-1,512,542,513,-1,512,489,884,-1,515,489,512,-1,488,884,489,-1,506,884,488,-1,486,875,291,-1,486,876,875,-1,877,1072,1287,-1,1072,877,510,-1,38,288,35,-1,38,499,288,-1,890,271,274,-1,34,271,890,-1,333,491,365,-1,491,333,492,-1,491,496,490,-1,180,496,491,-1,180,179,496,-1,487,518,274,-1,487,489,518,-1,54,481,314,-1,54,53,481,-1,1287,1093,1094,-1,1287,1072,1093,-1,1132,1131,1016,-1,1071,1131,1132,-1,481,50,326,-1,481,51,50,-1,183,901,184,-1,55,901,183,-1,186,1023,187,-1,1023,186,1024,-1,184,478,479,-1,184,901,478,-1,309,1027,902,-1,309,480,1027,-1,1068,172,1069,-1,1068,170,172,-1,802,1028,800,-1,1028,802,171,-1,1095,289,161,-1,1095,1073,289,-1,1178,298,335,-1,1178,1285,298,-1,1286,1284,1283,-1,1285,1284,1286,-1,1284,1206,1280,-1,1177,1206,1284,-1,1283,906,1282,-1,1281,906,1283,-1,102,475,473,-1,102,101,475,-1,1279,1280,1278,-1,1281,1280,1279,-1,909,1278,1202,-1,909,1272,1278,-1,904,1274,1273,-1,1274,904,1279,-1,1277,1276,1275,-1,1276,1277,905,-1,1116,1269,121,-1,1269,1116,1275,-1,471,1276,1273,-1,1276,471,470,-1,1270,1274,1272,-1,1274,1270,1271,-1,1267,908,1266,-1,1267,1270,908,-1,1268,471,1271,-1,1268,469,471,-1,1269,472,911,-1,472,1269,470,-1,469,1264,472,-1,469,914,1264,-1,915,1267,1265,-1,1268,1267,915,-1,1266,1000,468,-1,1266,998,1000,-1,1262,468,464,-1,1262,1265,468,-1,320,1264,1263,-1,320,910,1264,-1,1263,318,320,-1,920,318,1263,-1,464,1169,1262,-1,464,466,1169,-1,1207,927,465,-1,1192,927,1207,-1,466,925,1169,-1,926,925,466,-1,460,318,462,-1,460,319,318,-1,106,1260,463,-1,106,105,1260,-1,928,919,929,-1,919,928,921,-1,458,1197,459,-1,1194,1197,458,-1,456,458,457,-1,456,455,458,-1,455,1255,923,-1,454,1255,455,-1,1257,924,1256,-1,1257,1261,924,-1,1259,105,1258,-1,1259,1260,105,-1,1249,1258,1250,-1,1259,1258,1249,-1,1252,1257,1251,-1,930,1257,1252,-1,1253,1255,1044,-1,1256,1255,1253,-1,454,940,1254,-1,454,456,940,-1,937,362,1242,-1,362,937,1198,-1,1254,447,1044,-1,448,447,1254,-1,1244,1253,1243,-1,1244,1251,1253,-1,451,1252,1245,-1,1252,451,235,-1,452,1118,942,-1,934,1118,452,-1,1250,1247,1249,-1,1246,1247,1250,-1,932,1248,997,-1,1248,932,931,-1,947,1247,948,-1,1248,1247,947,-1,453,1238,1246,-1,453,440,1238,-1,444,1245,1076,-1,444,451,1245,-1,1240,1243,1239,-1,1244,1243,1240,-1,945,449,943,-1,447,449,945,-1,941,382,446,-1,941,939,382,-1,361,1242,362,-1,380,1242,361,-1,386,449,445,-1,449,386,387,-1,387,943,449,-1,387,1219,943,-1,944,1241,1239,-1,1221,1241,944,-1,1240,952,1076,-1,1236,952,1240,-1,131,444,138,-1,131,133,444,-1,1238,442,1237,-1,442,1238,440,-1,1188,949,984,-1,1188,1189,949,-1,946,1233,985,-1,946,1237,1233,-1,132,962,443,-1,132,434,962,-1,1235,1241,972,-1,1235,1236,1241,-1,136,953,1122,-1,136,954,953,-1,972,1121,1235,-1,972,398,1121,-1,1079,1234,1077,-1,1079,956,1234,-1,1232,950,962,-1,1232,1101,950,-1,966,429,967,-1,966,430,429,-1,1102,427,1130,-1,427,1102,428,-1,1100,1233,951,-1,1104,1233,1100,-1,1042,1080,1229,-1,1042,1078,1080,-1,1051,421,1231,-1,421,1051,422,-1,968,1231,421,-1,968,1230,1231,-1,411,1157,1230,-1,411,214,1157,-1,1119,1228,1120,-1,1119,1226,1228,-1,1128,1228,1126,-1,1229,1228,1128,-1,415,1156,409,-1,1155,1156,415,-1,415,418,1155,-1,415,414,418,-1,413,419,414,-1,413,412,419,-1,415,408,416,-1,415,409,408,-1,215,411,410,-1,215,214,411,-1,218,410,1227,-1,218,215,410,-1,1225,416,408,-1,1225,1227,416,-1,1083,1226,1119,-1,1083,969,1226,-1,409,1153,406,-1,1153,409,1156,-1,1224,408,407,-1,1224,1225,408,-1,404,1049,1224,-1,404,202,1049,-1,1035,407,406,-1,405,407,1035,-1,1081,958,1082,-1,1081,959,958,-1,1223,1213,1222,-1,1218,1213,1223,-1,970,1151,1075,-1,1222,1151,970,-1,405,971,402,-1,405,1035,971,-1,1165,973,394,-1,1165,1152,973,-1,401,1218,1223,-1,401,400,1218,-1,1220,976,1217,-1,1220,388,976,-1,972,1221,399,-1,1221,972,1241,-1,1217,975,1216,-1,975,1217,976,-1,1218,1214,1213,-1,1218,1216,1214,-1,1056,1214,1215,-1,1214,1056,1054,-1,212,1215,390,-1,1056,1215,212,-1,1036,248,1164,-1,1036,249,248,-1,397,248,250,-1,248,397,982,-1,1005,245,244,-1,1005,1004,245,-1,975,390,1215,-1,389,390,975,-1,385,388,386,-1,388,385,976,-1,380,977,383,-1,361,977,380,-1,1040,374,209,-1,374,1040,375,-1,1007,1041,1195,-1,1007,375,1041,-1,244,1006,1005,-1,246,1006,244,-1,373,252,1182,-1,373,238,252,-1,988,983,371,-1,986,983,988,-1,370,373,990,-1,239,373,370,-1,1013,1008,922,-1,1013,1011,1008,-1,834,1334,689,-1,834,1333,1334,-1,365,1209,366,-1,365,490,1209,-1,364,1180,363,-1,1180,364,895,-1,1170,1208,1207,-1,1170,1200,1208,-1,1204,1206,1205,-1,1206,1204,1202,-1,1201,909,1203,-1,909,1201,907,-1,1199,1194,1191,-1,1194,1199,1197,-1,1198,359,362,-1,1198,829,359,-1,361,1196,977,-1,361,360,1196,-1,1190,997,694,-1,1190,932,997,-1,996,671,694,-1,671,996,1189,-1,670,1187,1185,-1,670,1188,1187,-1,1186,989,1184,-1,1186,987,989,-1,357,1183,253,-1,357,356,1183,-1,350,352,355,-1,350,351,352,-1,342,869,533,-1,342,341,869,-1,294,480,478,-1,1027,480,294,-1,71,1175,744,-1,71,1174,1175,-1,334,299,743,-1,299,334,298,-1,522,1287,1167,-1,522,877,1287,-1,283,339,285,-1,339,283,799,-1,803,1178,335,-1,1178,803,1176,-1,803,334,1174,-1,335,334,803,-1,1067,364,331,-1,1067,888,364,-1,1021,889,891,-1,887,889,1021,-1,485,303,1020,-1,485,304,303,-1,474,900,305,-1,1389,900,474,-1,1172,323,322,-1,323,1172,1173,-1,324,794,1390,-1,794,324,321,-1,327,485,893,-1,325,485,327,-1,315,310,313,-1,315,891,310,-1,1171,476,899,-1,1171,1065,476,-1,1313,1310,1311,-1,1313,1392,1310,-1,1312,1392,1313,-1,1315,1392,1312,-1,1314,1392,1315,-1,1025,758,797,-1,1025,747,758,-1,1207,467,1170,-1,467,1207,465,-1,925,1261,1168,-1,925,924,1261,-1,1070,293,295,-1,1070,297,293,-1,1030,751,1029,-1,750,751,1030,-1,162,1167,160,-1,162,522,1167,-1,291,162,289,-1,875,162,291,-1,36,288,287,-1,36,35,288,-1,278,1092,275,-1,278,750,1092,-1,789,269,760,-1,789,268,269,-1,213,260,259,-1,260,213,159,-1,1231,228,1051,-1,1231,1050,228,-1,9,256,1334,-1,9,11,256,-1,1004,1212,245,-1,1004,1163,1212,-1,856,1147,1162,-1,1014,1147,856,-1,374,247,981,-1,246,247,374,-1,155,217,991,-1,155,154,217,-1,1234,134,242,-1,135,134,1234,-1,67,720,65,-1,720,67,1160,-1,625,1014,1148,-1,1014,625,1181,-1,214,259,1157,-1,213,259,214,-1,425,1074,1129,-1,425,423,1074,-1,418,1127,1155,-1,418,1125,1127,-1,1156,145,1153,-1,1156,144,145,-1,1152,1075,1151,-1,1152,1154,1075,-1,1040,211,980,-1,211,1040,209,-1,205,846,206,-1,205,627,846,-1,631,849,626,-1,631,647,849,-1,668,198,664,-1,668,1159,198,-1,199,623,1037,-1,1158,623,199,-1,251,1014,1181,-1,1147,1014,251,-1,224,974,201,-1,223,974,224,-1,1146,674,673,-1,1146,1145,674,-1,220,3,221,-1,220,676,3,-1,1144,14,13,-1,1144,1195,14,-1,1097,1142,1143,-1,1142,1097,1098,-1,1195,1045,14,-1,1195,1041,1045,-1,662,195,663,-1,662,1393,195,-1,1060,1289,547,-1,1060,343,1289,-1,547,1139,548,-1,1289,1139,547,-1,527,544,543,-1,527,526,544,-1,341,1210,869,-1,341,1138,1210,-1,1137,1136,871,-1,1137,1135,1136,-1,1134,194,192,-1,554,194,1134,-1,191,1140,188,-1,193,1140,191,-1,558,1210,560,-1,558,869,1210,-1,1133,184,479,-1,1133,182,184,-1,898,43,483,-1,43,898,44,-1,187,1064,1063,-1,187,1023,1064,-1,1022,182,1133,-1,1022,46,182,-1,181,185,48,-1,181,45,185,-1,31,495,287,-1,31,180,495,-1,498,330,994,-1,328,330,498,-1,287,494,36,-1,287,495,494,-1,1072,1132,1093,-1,511,1132,1072,-1,171,1017,172,-1,171,802,1017,-1,161,1096,1095,-1,160,1096,161,-1,175,1131,508,-1,174,1131,175,-1,159,372,260,-1,159,158,372,-1,155,151,153,-1,155,152,151,-1,1130,1052,227,-1,1130,427,1052,-1,965,148,1129,-1,965,146,148,-1,147,1128,1125,-1,1043,1128,147,-1,1127,142,144,-1,1126,142,1127,-1,435,141,436,-1,435,140,141,-1,1309,591,1124,-1,1309,592,591,-1,597,586,602,-1,587,586,597,-1,595,1309,1123,-1,1309,595,592,-1,438,954,136,-1,137,954,438,-1,1122,134,136,-1,134,1122,957,-1,1120,240,1119,-1,240,1120,241,-1,128,934,936,-1,128,1118,934,-1,107,317,319,-1,107,63,317,-1,65,718,66,-1,718,65,62,-1,130,450,133,-1,130,942,450,-1,127,1118,128,-1,1118,127,237,-1,814,121,119,-1,814,1116,121,-1,820,75,1084,-1,75,820,116,-1,117,65,89,-1,65,117,62,-1,822,123,122,-1,112,123,822,-1,769,92,767,-1,769,90,92,-1,1091,86,1090,-1,1087,86,1091,-1,87,82,88,-1,87,85,82,-1,1113,80,1115,-1,1113,1085,80,-1,1112,85,87,-1,1112,1114,85,-1,83,1091,1089,-1,83,84,1091,-1,1174,70,803,-1,71,70,1174,-1,61,922,1008,-1,61,68,922,-1,1010,61,1008,-1,1010,64,61,-1,768,57,60,-1,768,767,57,-1,770,1111,1110,-1,59,1111,770,-1,796,789,775,-1,796,790,789,-1,1109,1107,1108,-1,1109,742,1107,-1,1105,800,1028,-1,800,1105,1094,-1,47,1062,185,-1,47,897,1062,-1,897,1024,186,-1,897,47,1024,-1,35,39,38,-1,35,37,39,-1,34,493,32,-1,493,34,890,-1,1130,1032,1102,-1,1032,1130,1031,-1,1103,1033,992,-1,1103,1032,1033,-1,428,1104,1100,-1,428,1102,1104,-1,25,905,1277,-1,25,24,905,-1,1099,23,902,-1,1099,1282,23,-1,146,1043,147,-1,146,431,1043,-1,195,662,219,-1,195,1393,662,-1,14,1141,15,-1,14,1045,1141,-1,11,1098,254,-1,11,10,1098,-1,850,6,18,-1,850,7,6,-1,965,431,146,-1,431,965,432,-1,1212,2,1,-1,2,1212,1161,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='rfemur_Coord',point=[(-2.40079,15.87257,-1.49738),(-2.46394,15.93483,-1.25226),(-2.47444,15.93905,-1.3421),(-3.98351,17.14044,-1.71109),(-4.10047,16.93686,-1.94174),(-4.23845,16.93095,-1.84263),(-3.65704,16.27415,-.06206),(-3.72484,16.28852,-.13205),(-3.69758,16.1514,-.15255),(-3.52276,16.66232,.11868),(-3.42844,16.60096,.12581),(-3.45132,16.71548,.13267),(-2.8311,16.77455,-.21137),(-2.83952,16.69649,-.21121),(-2.60947,16.67926,-.30501),(-2.61747,16.73661,-.31207),(-3.61489,16.25247,.03046),(-3.53817,16.42257,.08351),(-3.61065,16.43909,.05593),(-3.41747,16.87574,-1.79708),(-3.51058,16.8358,-1.92342),(-3.42967,17.01308,-1.7169),(-3.70198,28.29487,-.9215),(-3.63143,28.30491,-.80466),(-3.68598,27.38189,-.78184),(-3.84599,27.36776,-.87974),(-4.34173,30.91048,-1.21096),(-4.38865,30.89803,-1.20111),(-4.29151,30.86767,-1.18238),(-4.44645,31.26442,-1.14545),(-4.40866,31.26413,-1.17211),(-4.4132,31.37626,-1.11832),(-4.55838,31.46111,-.66611),(-4.71033,31.4897,-.57654),(-4.52705,31.44613,-.59891),(-4.38519,31.12278,-.91855),(-4.37391,31.2248,-.89934),(-4.23409,31.17318,-.79101),(-4.364,30.88667,-.9757),(-4.19685,30.95083,-.83591),(-4.06247,30.83775,-.98798),(-3.39821,29.41559,-1.51215),(-3.42318,29.39365,-1.51882),(-3.4403,29.50512,-1.53629),(-3.40561,29.50325,-1.51682),(-3.22584,29.70377,-1.28409),(-3.20492,29.65829,-1.26079),(-3.28469,29.63737,-1.37803),(-3.31711,29.78728,-1.34136),(-3.37531,29.75631,-1.40865),(-3.42607,29.77648,-1.347),(-3.36672,29.83471,-1.25221),(-3.31549,29.91069,-.76041),(-3.30819,29.91525,-1.02366),(-3.3307,30.01832,-.98183),(-3.3088,29.85014,-.97458),(-4.82643,29.49536,-.57109),(-4.80054,29.50106,-.82676),(-4.7382,29.13469,-.56539),(-4.93437,29.78141,-.84447),(-4.7124,29.85436,-1.24667),(-3.41041,20.30532,-1.0023),(-3.68721,21.28558,-.96876),(-3.57058,21.33717,-.98562),(-3.55793,20.29949,-1.01766),(-3.71876,21.28262,-.95551),(-3.68673,20.29296,-1.02321),(-3.708,20.28365,-.96892),(-3.31804,20.32557,-.98928),(-4.47921,29.91637,-.2078),(-4.18186,29.52204,-.1347),(-4.12322,29.90651,-.14964),(-4.36728,30.27741,-.15151),(-3.90733,23.42002,-.92091),(-3.90736,23.55214,-.92713),(-3.88716,23.54708,-.95804),(-4.13003,23.55182,-.57935),(-3.95044,23.54832,-.85991),(-3.93339,23.42051,-.88143),(-4.21755,24.56781,-.56715),(-3.89924,23.56125,-.90448),(-3.90306,23.54849,-.91102),(-3.91179,23.44299,-.90992),(-3.92063,23.57701,-.90964),(-3.92039,23.56578,-.90313),(-3.89468,23.55644,-.88845),(-3.92387,23.56234,-.86713),(-3.90654,23.55679,-.87059),(-3.92653,23.44326,-.88748),(-3.81777,22.41068,-.97678),(-4.51213,29.19822,-1.11047),(-4.6184,28.85547,-.91226),(-4.646,29.17633,-.92876),(-4.49361,28.89203,-1.03879),(-4.45288,28.20847,-1.04386),(-4.46514,27.28918,-.96267),(-4.59517,28.19548,-.93677),(-4.38058,27.30395,-1.0089),(-4.43916,28.90815,-1.08667),(-4.3608,28.21902,-1.09524),(-4.30898,27.31785,-1.03294),(-4.16024,27.34042,-1.0079),(-4.03158,27.35048,-.97647),(-4.08582,26.34668,-.98992),(-2.5533,18.7611,-1.24528),(-2.66094,18.74891,-1.2397),(-2.87539,19.50655,-1.11389),(-3.22339,20.3478,-.9869),(-4.03398,17.24943,-1.34983),(-3.9895,17.37914,-1.3041),(-3.96967,17.37842,-1.33191),(-3.63427,18.13467,-1.20989),(-3.74088,18.12683,-1.19466),(-3.64258,18.66659,-1.1544),(-3.92109,17.56412,-1.27393),(-3.89886,17.56028,-1.29787),(-3.8683,23.54792,-.98254),(-3.78848,22.41252,-.99078),(-3.80261,23.55691,-.97874),(-3.9068,24.61684,-.97899),(-3.77778,23.56122,-.95237),(-3.87971,24.62191,-.96027),(-3.84372,17.834,-1.21683),(-3.81303,17.83699,-1.23642),(-3.67086,19.44758,-1.07916),(-3.64045,19.44532,-1.09505),(-3.67719,18.66606,-1.14425),(-2.25908,18.29123,-1.34604),(-2.28459,18.29061,-1.36938),(-2.51807,18.76214,-1.22942),(-1.91976,17.64882,-1.66685),(-1.66419,17.4757,-1.90504),(-1.67582,17.45985,-1.92494),(-1.89005,17.64824,-1.64827),(-1.33371,16.90018,-1.89545),(-1.36198,17.00903,-1.94797),(-1.3505,17.09776,-1.82343),(-1.47686,17.3474,-1.7714),(-1.58169,17.43872,-1.81863),(-1.5552,17.39529,-1.69416),(-1.61895,17.46515,-1.91432),(-1.50673,17.38799,-1.8879),(-1.5901,16.05878,-2.21874),(-1.55972,15.94328,-1.94259),(-1.58462,15.96476,-2.24399),(-1.57631,15.83846,-1.97721),(-1.8315,16.90037,-2.67099),(-1.80483,16.65331,-2.77727),(-1.84376,16.88942,-2.7145),(-2.39951,15.93008,-1.60474),(-2.45295,16.02463,-1.56378),(-2.39124,16.07006,-1.74585),(-2.36556,15.97022,-1.81026),(-2.38734,16.20758,-1.99492),(-2.37734,16.15345,-2.17826),(-2.34677,16.08175,-2.06926),(-2.36935,16.32576,-2.30235),(-2.33255,16.37736,-2.04842),(-2.35528,16.6119,-2.18423),(-2.4213,16.60372,-2.35624),(-3.28315,30.24746,-.55606),(-3.25971,30.23281,-.57842),(-3.13296,30.52859,-.64466),(-3.59629,30.64246,-.21297),(-3.57508,30.61352,-.21952),(-3.46243,30.84218,-.20056),(-3.49726,29.49685,-.25241),(-3.66752,29.87987,-.18346),(-3.68139,29.84614,-.20181),(-3.51096,29.46309,-.26005),(-3.35516,29.72369,-.52931),(-3.41563,29.66737,-.44095),(-3.39624,29.62055,-.43685),(-3.3761,29.73826,-.52212),(-3.77697,30.27134,-.13577),(-3.80495,30.29007,-.14234),(-4.0398,30.8263,-1.01511),(-4.27328,30.85037,-1.19684),(-3.84712,31.02327,-.98606),(-4.3957,31.40587,-1.1295),(-4.39393,31.40945,-1.10027),(-3.22183,29.72977,-1.2486),(-3.20056,29.65758,-1.22044),(-3.27691,29.82824,-1.08831),(-3.26674,29.6686,-1.07691),(-3.29538,29.74215,-1.35392),(-3.33657,29.4697,-1.46256),(-3.32958,29.30222,-1.44084),(-2.59855,31.00044,-1.09295),(-2.77182,31.02029,-1.31173),(-2.69723,31.10501,-1.30323),(-2.60276,30.95761,-.61314),(-2.67242,31.02941,-.30442),(-2.63288,30.95996,-.61532),(-2.69984,31.02277,-.31764),(-4.25305,16.91006,-1.82344),(-4.33223,16.70236,-1.93306),(-4.32463,16.69736,-1.90434),(-3.53366,16.40237,-1.99),(-3.37357,16.17595,-1.78251),(-3.47686,16.15822,-1.85237),(-2.42902,15.90532,-1.51962),(-2.34846,15.79997,-1.64407),(-3.59059,16.23594,.03751),(-3.51916,16.40613,.11064),(-4.20002,15.81606,-1.20525),(-4.20473,15.84243,-1.19471),(-4.28767,15.91072,-1.42043),(-4.2984,15.88022,-1.43433),(-2.00086,16.28897,-.4937),(-1.9226,16.02841,-.65048),(-1.99712,16.33369,-.5063),(-1.90194,16.05331,-.66921),(-2.52032,16.59515,-2.50939),(-2.51834,16.59432,-2.54306),(-2.44381,16.27819,-2.51606),(-2.43388,16.28843,-2.48648),(-2.40749,16.10394,-2.34821),(-2.41158,16.07943,-2.37246),(-4.21116,17.0244,-1.56979),(-4.17364,17.03631,-1.56374),(-4.19422,17.03625,-1.60334),(-2.67354,16.02622,-1.29333),(-2.49372,15.95932,-1.47379),(-2.48586,15.94348,-1.43672),(-2.68462,16.05045,-1.31181),(-2.42968,17.08843,-2.08188),(-2.41234,17.10286,-2.07589),(-2.4299,17.10672,-2.1099),(-3.92886,17.23101,-1.46773),(-3.82866,17.34931,-1.40692),(-3.86814,19.45301,-.75654),(-3.80058,18.64618,-1.01586),(-3.88448,18.62498,-.80584),(-3.72021,19.44725,-.97527),(-2.06222,17.97485,-1.38366),(-2.20644,18.25502,-1.24793),(-2.11668,17.9911,-1.44327),(-2.51512,16.24993,-1.52765),(-2.37648,16.4471,-1.69076),(-1.36035,16.53028,-2.0276),(-1.37656,16.60763,-2.08601),(-1.35993,16.69931,-1.95562),(-2.41545,15.98472,-.81373),(-2.51457,16.07499,-.67967),(-2.54687,15.98887,-.91478),(-2.47177,16.25123,-.48542),(-2.35418,16.04296,-.63552),(-2.18902,15.89847,-.98875),(-2.04294,15.78219,-1.11102),(-1.91299,15.85161,-1.03869),(-2.85143,16.08649,-1.18466),(-2.71044,16.21381,-1.33091),(-2.91583,16.25084,-1.24809),(-3.17645,16.77529,.02752),(-3.17392,16.87202,.03468),(-3.46307,16.806,.11554),(-3.46067,16.0897,-1.80387),(-2.42869,17.01897,-2.18018),(-2.51681,16.86969,-2.45133),(-2.42481,16.85886,-2.30053),(-2.50297,17.02361,-2.28025),(-4.91344,30.93512,-.22782),(-4.8191,30.80812,-.17237),(-4.76706,31.20227,-.15402),(-5.14703,29.95334,-.35363),(-4.99299,29.79119,-.35456),(-5.10905,30.02101,-.24381),(-5.19645,30.14417,-.40344),(-5.13199,30.22354,-.3764),(-4.23459,29.15905,-.11875),(-4.5222,31.43272,-.40029),(-4.52107,31.46325,-.1924),(-4.31604,31.33217,-.17605),(-4.25497,31.35178,-.43866),(-4.80548,30.36218,-.11042),(-4.90064,30.45152,-.11717),(-5.0167,30.14944,-.12427),(-4.92891,29.94338,-.19132),(-4.64574,31.35985,-.12459),(-4.87633,31.32088,-.22176),(-4.74737,31.47378,-.23668),(-4.75823,30.72282,-.13513),(-4.69776,30.66618,-.15837),(-4.63981,31.02516,-.06072),(-4.57718,30.94972,-.04509),(-4.46307,31.11021,-1.1769),(-4.48047,31.27117,-.98209),(-4.46883,31.09616,-1.03148),(-3.24611,30.22194,-.61442),(-3.31727,29.88545,-.70807),(-3.2786,30.25526,-.75129),(-3.33527,29.68102,-.79214),(-3.35836,29.41519,-.71712),(-3.3808,29.53534,-.79286),(-3.32743,29.62861,-.65837),(-3.47221,29.06097,-.47669),(-3.42806,29.24303,-.48042),(-3.60291,29.11969,-.32708),(-3.54739,29.27039,-.30813),(-3.99224,31.30764,-.70829),(-4.01285,31.37365,-.62355),(-3.86356,31.45372,-.67815),(-3.87946,29.24111,-1.28925),(-3.73772,29.26572,-1.38112),(-3.87528,28.97036,-1.22874),(-3.61999,28.96221,-1.18085),(-3.57564,28.95638,-1.04596),(-3.79139,28.28539,-1.0022),(-3.54648,28.94604,-.91732),(-3.77293,30.5505,-1.067),(-3.65877,30.74936,-1.04844),(-3.44284,30.43884,-.9945),(-3.63017,30.31047,-1.07316),(-3.49297,30.07045,-1.08085),(-3.87353,30.23778,-1.20846),(-3.72821,30.05559,-1.23713),(-3.53576,21.34911,-.97813),(-3.00237,20.3544,-.92602),(-3.18788,20.35646,-.97645),(-3.30777,21.41869,-.86035),(-4.80225,30.34298,-1.39907),(-4.60382,30.22444,-1.47528),(-4.71483,30.1624,-1.36803),(-4.66815,30.45476,-1.50334),(-3.6843,29.83794,-1.38574),(-3.58127,29.92397,-1.26911),(-3.83346,29.99436,-1.38865),(-4.46548,31.32253,-1.31988),(-4.60895,31.25145,-1.42199),(-4.59077,31.39928,-1.43127),(-4.45925,31.18241,-1.35257),(-4.74946,31.60515,-.75368),(-4.6032,31.51485,-.76905),(-3.76437,29.40047,-.23359),(-3.78965,29.15911,-.21647),(-4.17195,30.77695,-.00265),(-4.34753,30.90742,.03663),(-4.29942,30.5643,-.09208),(-4.43875,30.75564,-.0558),(-3.43951,31.55697,-1.2985),(-3.2434,31.31622,-1.4801),(-3.29811,31.28807,-1.366),(-3.40587,31.63291,-1.49285),(-4.38953,30.32251,-1.49182),(-4.25745,30.37097,-1.45305),(-4.16286,30.11826,-1.42853),(-4.3208,30.08408,-1.43791),(-3.36927,17.07373,-1.62378),(-3.21844,17.03707,-1.56034),(-3.34146,16.88646,-1.66082),(-3.21184,16.89821,-1.55303),(-3.19705,16.72534,-1.53963),(-3.18637,16.60465,-1.46969),(-3.32465,16.52053,-1.61018),(-3.3475,16.70118,-1.67539),(-3.17744,16.41712,-1.34593),(-3.145,16.27332,-1.24392),(-3.1916,16.21989,-1.34512),(-2.87923,17.4475,-.24276),(-2.85006,17.22593,-.23144),(-2.64273,17.21549,-.35322),(-2.66725,17.4236,-.32298),(-4.54263,30.90691,-1.4789),(-4.40086,30.92361,-1.43193),(-4.55887,31.6777,-.89592),(-4.68966,31.72653,-.96588),(-3.98066,30.51444,-.12025),(-3.93961,30.5471,-.11969),(-4.1425,30.87985,-.0318),(-2.35992,16.61899,-1.81041),(-2.43144,16.79668,-1.86914),(-2.37088,16.84447,-2.16578),(-2.54802,16.44356,-1.57426),(-2.27307,16.27241,-.45484),(-2.41508,16.43779,-.38584),(-1.9817,16.54411,-.48596),(-1.9973,16.69621,-.49282),(-2.21985,16.73372,-.45985),(-2.19157,16.61625,-.42828),(-2.49326,17.21409,-.42569),(-2.25881,16.98409,-.50488),(-2.29243,17.23395,-.46437),(-2.46458,17.0008,-.43345),(-2.09001,16.98909,-.50871),(-1.8901,16.85477,-.54636),(-1.92974,17.02144,-.56084),(-1.79086,17.05983,-.71343),(-1.7323,16.918,-.68158),(-1.79201,16.60683,-.61241),(-1.81397,16.40123,-.6278),(-2.33853,15.86586,-1.86979),(-2.35428,15.83454,-1.64563),(-1.93402,15.72136,-1.26247),(-1.79233,15.80325,-1.21885),(-1.71682,15.88881,-.96368),(-1.81196,15.91437,-.83037),(-2.08318,15.94608,-.75639),(-1.39992,16.84346,-1.22528),(-1.55027,16.87981,-.95924),(-1.47888,16.67679,-1.03802),(-1.38816,16.61513,-1.28638),(-2.10825,15.71594,-1.37286),(-2.33163,15.79787,-1.47179),(-2.23541,15.74632,-1.67054),(-2.01815,15.70892,-1.68632),(-1.79694,15.74794,-2.00262),(-2.02882,15.73712,-1.96789),(-2.05965,15.84407,-2.2458),(-1.80388,15.88372,-2.26116),(-2.33334,16.2551,-2.6093),(-2.38678,16.60721,-2.67026),(-2.2612,16.622,-2.74335),(-2.18797,16.27602,-2.66106),(-1.91664,16.29115,-2.71664),(-1.8425,16.05802,-2.51429),(-2.124,16.02214,-2.48723),(-1.8346,16.65059,-2.79217),(-1.75273,16.35306,-2.71429),(-2.01023,16.64789,-2.77711),(-2.03282,17.13394,-2.54092),(-2.24427,17.11592,-2.46041),(-2.17003,17.19071,-2.2622),(-1.98736,17.15038,-2.43601),(-1.87013,16.90507,-2.73378),(-1.91728,17.10072,-2.5356),(-2.06454,16.9239,-2.70771),(-2.25147,17.15202,-2.12011),(-2.21158,17.15411,-2.04013),(-2.08841,17.14471,-2.09324),(-2.13078,17.16243,-2.19106),(-1.77395,16.92748,-2.58211),(-1.77418,17.08548,-2.39673),(-1.68263,17.04281,-2.42266),(-1.64767,17.33995,-1.98226),(-1.6296,17.43803,-1.95764),(-1.5022,17.31969,-2.00515),(-1.53498,17.26741,-2.08244),(-1.41869,17.29145,-1.86154),(-2.03081,17.37936,-1.79982),(-2.25839,17.60611,-1.63773),(-2.03822,17.62429,-1.69051),(-2.21833,17.32951,-1.73755),(-1.88742,17.42037,-1.86837),(-1.839,17.62803,-1.58038),(-2.04072,17.28717,-.56223),(-2.17697,17.2494,-.4922),(-2.01622,17.53246,-.6975),(-2.11484,17.49241,-.54381),(-1.92281,17.29024,-.67091),(-2.00297,17.79574,-1.53529),(-1.95047,17.79713,-1.48627),(-2.13054,17.79578,-1.57909),(-2.29137,17.79135,-1.57885),(-2.25821,18.04765,-.48792),(-2.42904,18.59653,-.37112),(-2.37067,18.04715,-.41932),(-2.48509,17.99782,-.34235),(-2.64928,18.5525,-.24264),(-2.57919,17.98552,-.29587),(-2.83905,19.51216,-1.1062),(-2.43941,18.7561,-1.13665),(-2.69771,19.48952,-1.00953),(-3.00312,19.49346,-1.09829),(-2.97674,21.33324,-.16744),(-2.84159,20.17556,-.12604),(-2.70857,20.23679,-.25938),(-3.03416,21.31686,-.09115),(-3.23039,22.41985,-.0529),(-3.28104,23.6653,-.46322),(-3.49951,24.69988,-.66125),(-3.36664,24.72098,-.52362),(-3.39974,23.66182,-.6336),(-3.88961,28.26543,-1.05193),(-4.14161,28.93117,-1.18464),(-4.14793,28.22308,-1.08183),(-3.54149,29.09547,-1.26716),(-3.48283,29.21143,-1.07746),(-3.40187,29.57294,-.93303),(-3.35021,29.48335,-1.08533),(-3.49429,29.25182,-.91489),(-3.46321,29.97653,-1.12074),(-3.49582,29.7,-1.45117),(-3.39785,29.67213,-1.4698),(-3.7525,29.61485,-1.4413),(-3.89993,29.65167,-1.36734),(-3.31335,30.28858,-.8882),(-4.128,31.29364,-.17726),(-4.18109,31.12418,-.10743),(-3.98467,31.30814,-.18686),(-4.47175,31.68217,-1.13104),(-4.42371,31.54967,-.97564),(-4.45111,31.41878,-.84787),(-4.41253,31.39373,-.78503),(-4.37348,31.24579,-.90244),(-4.46609,31.29252,-.97417),(-4.43354,31.50612,-1.28871),(-4.39813,31.28437,-1.19401),(-4.45289,31.35699,-1.31118),(-4.43399,30.86054,-1.06993),(-3.93923,31.17475,-.91025),(-3.11692,31.40665,.0755),(-2.83359,31.37007,.07316),(-3.02913,31.53651,.11846),(-2.95076,31.24882,-.01346),(-4.29953,31.03135,.00026),(-4.03446,30.96615,-.09864),(-3.69953,30.4225,-.17492),(-3.76982,30.33303,-.14165),(-3.85405,30.65282,-.13618),(-3.32024,30.66313,-.31491),(-3.41828,30.41359,-.29619),(-3.69178,31.2305,-.19961),(-3.58516,31.39045,-.16482),(-3.71509,31.55713,-.27023),(-3.83799,31.40714,-.23604),(-3.71307,31.60115,-.55476),(-3.88028,31.43891,-.45875),(-4.0154,31.34431,-.44644),(-3.78897,31.31526,-.92687),(-3.71808,31.22227,-1.0303),(-2.99119,30.82209,-.61675),(-3.19772,30.55883,-.50124),(-3.01882,30.81678,-.43367),(-3.67444,31.82756,-.54352),(-3.65079,31.72304,-.25827),(-3.60835,31.92196,-.22319),(-3.71039,32.0622,-.50804),(-3.70736,31.62833,-.6835),(-3.64471,31.83597,-.75386),(-3.12672,30.98792,-1.14949),(-3.18083,31.01909,-1.17318),(-3.02678,31.02384,-1.2909),(-3.12957,31.09858,-1.30206),(-3.00413,30.87493,-.94744),(-2.93881,31.00405,-1.19979),(-2.87241,30.97972,-1.04869),(-3.04972,30.9363,-1.05061),(-3.35661,31.36216,-.03836),(-3.22677,31.24904,-.08604),(-3.18944,31.29072,.00752),(-3.51138,31.54134,-.10352),(-3.44367,31.20856,-.14588),(-3.71346,32.09727,-.50397),(-3.60865,31.95775,-.20756),(-3.54829,32.10204,-.1502),(-3.61878,32.2495,-.52233),(-3.59505,32.05794,-1.31069),(-3.70834,32.1516,-.90728),(-3.63889,32.27239,-.97601),(-3.51542,32.1404,-1.35045),(-3.32402,31.06495,-.1801),(-3.19266,30.94189,-.26684),(-3.06988,31.09551,-.13532),(-2.83252,31.10338,-.15947),(-2.94501,30.9667,-.22889),(-2.85647,30.91511,-.39486),(-2.78872,31.01552,-1.28571),(-2.89962,31.06277,-1.36705),(-2.82862,31.16926,-1.46016),(-2.88665,31.06963,-1.39769),(-2.93307,31.50248,-1.61287),(-2.71684,31.32433,-1.45514),(-3.02964,31.32873,-1.5649),(-2.90214,31.84136,.07626),(-3.19095,31.69506,.12544),(-3.04079,31.95213,.05079),(-2.81397,31.84148,-1.52278),(-2.60513,31.60669,-1.42308),(-3.0416,32.25465,-.12653),(-3.14344,32.40591,-.30176),(-3.35681,32.28433,-.17201),(-3.17102,32.05677,.01135),(-2.9025,32.3851,-.38933),(-2.95457,32.41098,-.44348),(-2.79232,32.06374,-.0743),(-2.72248,31.67563,.04892),(-2.68386,31.93474,-.09914),(-2.51232,32.08409,-.59592),(-2.43218,31.71496,-.3722),(-2.36999,31.64926,-.62693),(-2.54238,31.91419,-1.23571),(-2.46287,31.52231,-1.23344),(-2.44418,31.65086,-1.14265),(-2.50981,31.87358,-1.15094),(-2.51068,32.10051,-.82581),(-2.50299,32.06405,-.86438),(-2.5101,32.07122,-.99003),(-2.57469,32.14812,-1.05636),(-2.47744,31.7251,-.79245),(-2.48257,31.93113,-.73245),(-2.4675,31.95706,-.73045),(-2.4004,31.72369,-.7627),(-2.44567,31.67315,-1.1101),(-2.48924,31.70517,-.90123),(-2.39924,31.6259,-.95689),(-2.48706,31.72859,-.98118),(-2.50392,32.04246,-.96984),(-2.54467,31.93562,-.93866),(-2.51171,31.80319,-1.02124),(-2.50483,31.85684,-1.11849),(-2.53274,31.95556,-.82987),(-2.49951,32.0246,-.86535),(-2.83795,32.15454,-1.34531),(-2.8279,32.34236,-1.14375),(-2.66915,32.22703,-1.10391),(-2.95829,32.2597,-1.3171),(-2.83825,32.38556,-.54983),(-2.67177,32.28753,-.939),(-2.61859,32.2316,-.85694),(-2.83026,32.40527,-.91465),(-2.8761,32.4334,-.84916),(-2.69415,32.29939,-.71231),(-2.8825,32.43987,-.6977),(-2.75398,32.32884,-.48108),(-2.68069,32.2752,-.50156),(-2.63013,32.23548,-.54955),(-2.60045,32.21554,-.67325),(-2.5665,32.19357,-.76324),(-2.75964,32.35542,-.94789),(-3.35004,16.26033,-1.7026),(-3.45533,16.42112,-1.83511),(-3.27344,16.37616,-1.50698),(-3.27931,16.09106,-1.57923),(-3.26905,16.21856,-1.53998),(-3.21142,16.07696,-1.34103),(-4.00339,15.81855,-.93053),(-4.09924,15.79892,-1.07763),(-3.9237,15.74336,-1.10065),(-3.61193,15.8158,-.54298),(-3.73884,15.92308,-.40516),(-3.83613,15.88776,-.6891),(-3.77649,15.78753,-.81965),(-3.25157,15.88435,-.89514),(-3.60631,15.77626,-.96547),(-3.4182,15.88097,-1.09434),(-3.46844,15.81507,-.71554),(-3.02532,16.27782,-.28772),(-2.87951,16.31619,-.42904),(-2.82359,16.50273,-.27572),(-3.00186,16.46908,-.15585),(-3.36795,16.38213,.06229),(-3.40461,16.56493,.13336),(-3.67464,16.06163,-.1749),(-3.75133,15.9537,-.40539),(-3.76824,16.08859,-.38857),(-3.88013,16.0262,-.64524),(-3.84609,15.91844,-.68173),(-4.10346,16.17946,-.99344),(-4.06404,16.43358,-.79379),(-4.16464,16.42036,-.91477),(-4.01178,16.18169,-.83936),(-4.31095,16.68656,-1.17416),(-4.27496,16.44695,-1.18997),(-4.26568,16.6776,-1.0388),(-4.25391,16.44234,-1.05549),(-4.24007,16.33788,-1.42509),(-4.25354,16.50426,-1.41242),(-4.2572,16.48285,-1.54744),(-4.2539,16.70299,-1.6697),(-4.2755,16.68606,-1.41695),(-4.26797,16.79068,-1.41395),(-4.22041,16.86761,-1.68491),(-4.27132,16.71232,-1.80516),(-3.5687,16.63729,-2.0398),(-3.74043,16.35928,-2.08454),(-3.72794,16.66969,-2.07644),(-3.47457,16.66784,-1.84037),(-3.55941,16.62914,-2.00647),(-3.2086,17.15528,-1.45226),(-3.03555,17.05797,-1.5798),(-3.04732,17.18619,-1.49068),(-3.5741,17.18642,-1.56369),(-3.61382,17.12811,-1.71209),(-3.84561,17.15716,-1.6911),(-3.81718,17.25337,-1.54587),(-3.96453,17.14,-1.67169),(-3.78675,17.34273,-1.43678),(-4.18724,17.02972,-1.40038),(-4.20072,16.97347,-1.04404),(-4.22658,16.9963,-1.20301),(-4.17622,16.66283,-.91917),(-4.12992,16.9607,-.91238),(-3.98868,17.27966,-.79661),(-4.03299,17.30902,-.9399),(-4.02868,16.94648,-.77663),(-3.88822,16.95642,-.5878),(-3.87625,17.24706,-.57303),(-3.5012,17.22374,.03388),(-3.58114,16.95959,.055),(-3.47808,16.99829,.08401),(-3.00024,16.7781,-.08533),(-2.99996,16.86862,-.09566),(-3.78398,17.54802,-1.29795),(-3.12093,17.53075,-1.35763),(-3.26989,17.52733,-1.3525),(-3.4568,17.68487,-.0031),(-3.25231,17.97965,.00437),(-3.49709,17.98082,-.02449),(-3.22083,17.71184,-.02659),(-3.95014,17.81568,-1.04106),(-3.93042,18.05441,-.85681),(-3.89403,18.10067,-1.04173),(-3.95245,17.79486,-.91375),(-3.56847,18.65985,-1.13155),(-3.495,18.13726,-1.21205),(-3.89134,18.58223,-.50176),(-3.88619,18.613,-.62198),(-3.94522,18.04026,-.72049),(-3.88669,18.03892,-.55348),(-3.20708,18.53009,-.01029),(-3.31735,19.29066,.0235),(-3.27457,18.5243,.01254),(-3.94367,19.42404,-.47074),(-3.98848,20.15734,-.43258),(-4.06485,21.20779,-.1854),(-4.05534,21.2277,-.33186),(-3.96182,20.13338,-.24154),(-3.65543,20.2966,-1.03651),(-4.06832,22.36663,-.5759),(-3.98901,21.22879,-.64631),(-4.14705,22.3199,-.10282),(-4.1647,22.33004,-.17994),(-3.92287,22.34478,.10921),(-4.00359,21.20803,-.06766),(-3.81942,21.21358,.08055),(-4.11241,22.33591,.00035),(-4.35356,24.55632,-.12255),(-4.26585,23.52945,-.18099),(-4.25388,23.5524,-.11453),(-4.35497,24.54952,-.24723),(-4.51177,26.31753,-.7303),(-4.06141,25.41499,-.93545),(-4.31975,25.41673,-.61909),(-4.23963,26.32904,-.97084),(-4.53785,26.36089,-.1852),(-4.43049,25.42499,-.28645),(-4.40064,25.48072,-.13387),(-4.54716,26.34342,-.39274),(-4.45328,28.26668,-.10471),(-4.45189,28.8503,-.1543),(-4.53779,28.84698,-.17923),(-4.53267,28.23608,-.21009),(-3.72878,29.61677,-.21689),(-4.0706,30.29848,-.13402),(-4.54043,31.028,.00428),(-4.46971,31.14024,.01006),(-5.0066,30.73047,-.33504),(-5.10777,30.85251,-.37952),(-5.05365,31.05634,-.25647),(-4.76626,29.706,-.23301),(-4.83184,29.50442,-.38712),(-4.96479,31.4655,-.46166),(-4.71012,31.43687,-.40738),(-4.902,31.4518,-.30901),(-5.16011,30.9027,-.38015),(-5.1853,30.95575,-.41312),(-5.28209,30.68751,-.48464),(-5.10152,30.55487,-.42642),(-5.21947,30.65051,-.46285),(-5.16775,30.46822,-.47814),(-4.76447,29.15797,-.77592),(-4.75032,28.81829,-.7831),(-4.38634,29.52998,-1.26559),(-4.42016,29.79949,-1.34865),(-4.21908,29.58166,-1.30592),(-4.5274,29.75667,-1.29138),(-4.69606,29.49826,-.99137),(-4.65281,29.67491,-1.20056),(-4.59749,29.49545,-1.15566),(-5.04125,29.93732,-.87284),(-4.83055,30.10035,-1.2609),(-4.811,31.38319,-1.38496),(-4.78008,31.21453,-1.41063),(-5.10222,30.88222,-1.13183),(-5.19287,30.47075,-.90443),(-5.19869,30.75934,-.81103),(-5.0317,30.59978,-1.2391),(-5.06392,31.41593,-.91074),(-5.16032,31.09178,-.68618),(-5.05851,31.30951,-.58359),(-5.09693,31.21425,-.95388),(-4.81243,31.42205,-1.38846),(-4.91252,31.51207,-1.23194),(-4.75182,31.59912,-1.33531),(-4.96467,31.32319,-1.25752),(-4.91153,31.65849,-.79121),(-4.86869,31.70373,-.96468),(-5.11769,31.14387,-.34321),(-5.24042,30.37834,-.53236),(-5.17571,30.13469,-.59295),(-4.98267,31.11716,-1.29976),(-5.0456,31.27108,-1.1634),(-5.04013,31.00106,-1.2402),(-4.96791,30.66512,-1.31236),(-4.91681,30.2677,-1.28206),(-5.10722,30.13934,-.88945),(-5.03211,30.37498,-.31639),(-4.63318,30.30284,-.1767),(-4.56603,30.54136,-.15471),(-3.5052,29.84825,-.32319),(-3.59581,30.00193,-.24085),(-3.51095,29.72282,-.296),(-3.94472,29.14729,-.13334),(-4.49994,29.14692,-.16433),(-4.57877,29.13648,-.20535),(-4.69534,28.19305,-.58824),(-4.64159,27.25872,-.86642),(-4.67267,27.25196,-.52327),(-4.74099,28.18248,-.82902),(-4.35325,25.49914,-.03028),(-4.35797,26.43049,.04531),(-4.44755,26.39569,-.07029),(-4.23308,25.53061,.05974),(-3.99869,25.42868,-.98002),(-4.04139,25.41722,-.96618),(-4.20324,26.33178,-.99628),(-4.1209,24.65702,.11295),(-4.04472,25.57734,.13652),(-3.92623,24.6626,.14929),(-3.94539,24.61656,-.96965),(-3.72165,22.41283,-.98569),(-3.77318,18.13158,-1.17437),(-3.97027,17.52004,-1.07543),(-3.43211,17.52947,-1.33561),(-3.39145,17.20582,-1.48758),(-3.95417,17.48465,-.78643),(-3.9709,17.49403,-.94903),(-3.03212,17.45549,-.12455),(-2.8774,17.6928,-.18941),(-3.06231,17.69422,-.10249),(-2.8229,16.85263,-.21166),(-3.67287,17.21807,-.17569),(-3.80501,16.93888,-.39886),(-3.70854,16.94216,-.13209),(-3.79076,17.20976,-.3715),(-3.6816,17.46003,-.16527),(-3.48722,17.44425,.0032),(-4.02458,17.35448,-1.1211),(-4.31823,16.43616,-1.72797),(-4.29413,16.22032,-1.55645),(-4.39446,16.12065,-1.71774),(-4.24428,16.06038,-1.31004),(-4.17725,16.01308,-1.16773),(-4.19077,16.16773,-1.14345),(-4.21554,16.18934,-1.22866),(-4.10316,15.82723,-1.0663),(-4.09781,15.9731,-1.02506),(-4.00767,15.96733,-.87667),(-4.01213,15.84843,-.92551),(-3.69046,16.45358,.00708),(-3.7387,16.44271,-.10647),(-3.65935,16.02964,-.18167),(-3.5254,15.88989,-.37117),(-3.46795,16.02209,-.21464),(-3.37765,15.86742,-.48853),(-3.06961,16.06332,-1.0301),(-3.0403,16.02935,-.95976),(-3.23986,16.0049,-1.12512),(-3.72782,15.76808,-1.18107),(-2.7414,32.19448,-.26305),(-2.645,32.1342,-.30357),(-2.81167,32.28959,-.31053),(-2.70313,32.0579,-1.32487),(-2.37327,31.37791,-.63198),(-2.38475,31.44418,-1.00754),(-2.93308,32.13945,-.04918),(-2.53015,31.02496,-.60611),(-2.52126,31.09637,-1.0448),(-3.09961,31.14408,-1.43758),(-2.81335,30.94615,-.62607),(-3.44049,31.7192,.00637),(-3.35448,31.87917,.03535),(-3.11204,30.87258,-.31926),(-3.28782,30.68423,-1.02021),(-3.16995,30.55,-.79106),(-3.20931,30.57141,-.93745),(-3.2529,30.58081,-.40321),(-3.54874,31.00786,-.17691),(-3.67247,30.79705,-.15789),(-3.52675,30.97223,-1.11467),(-3.51763,31.44943,-1.16065),(-3.37335,31.22427,-1.2599),(-3.62269,31.57277,-1.01392),(-3.86707,31.10253,-.16905),(-4.40904,31.24156,-1.18385),(-4.4005,31.13636,-1.19692),(-4.25772,30.67333,-1.33482),(-4.3341,30.9186,-1.23563),(-4.18332,30.71405,-1.22549),(-4.31665,31.36106,-.66095),(-4.00353,30.44875,-1.18716),(-3.99415,30.17939,-1.36882),(-4.05787,29.90295,-1.4004),(-4.27902,30.66035,-1.40788),(-4.33653,30.62544,-1.46036),(-3.58579,29.5435,-1.51874),(-3.33091,29.64095,-1.42486),(-3.36151,29.64331,-1.45564),(-3.68861,29.28201,-1.42221),(-4.01168,29.24507,-1.24576),(-3.32171,29.74574,-.93104),(-3.52208,28.93485,-.80729),(-3.99483,27.35495,-.9538),(-3.49237,26.49284,-.57352),(-3.64953,26.45868,-.7457),(-3.57121,27.39431,-.56419),(-3.62534,24.70078,.05635),(-3.55079,24.68581,.00099),(-3.69812,25.57755,.06202),(-3.49526,22.48124,-.85024),(-3.66561,23.58531,-.8448),(-3.6877,22.41792,-.9745),(-2.89904,21.40567,-.40575),(-3.13012,22.51828,-.45611),(-3.10834,22.51603,-.36617),(-2.90076,21.41965,-.48085),(-2.63132,20.33369,-.51368),(-2.65891,20.3637,-.59693),(-2.4357,19.47244,-.76306),(-2.75267,20.37807,-.73528),(-2.52556,19.47716,-.86141),(-3.16167,19.46875,-1.07349),(-2.26346,18.67781,-.60858),(-2.23026,18.70342,-.7217),(-2.41205,19.40627,-.54704),(-2.52847,19.34182,-.34674),(-2.73885,19.28352,-.16588),(-2.35214,18.75017,-1.05886),(-2.25341,18.74002,-.95674),(-2.13442,18.20072,-1.10846),(-2.86077,17.9276,-1.3616),(-2.96403,17.92462,-1.32603),(-3.01201,18.21312,-1.27085),(-2.22344,17.98115,-1.47633),(-2.33233,17.97334,-1.50199),(-2.40953,18.28377,-1.37363),(-2.54694,17.64565,-.35097),(-2.40051,17.64603,-.39404),(-2.33712,17.42904,-.4476),(-2.32765,17.66462,-.44276),(-2.26363,17.46698,-.46387),(-2.03307,17.7962,-1.55597),(-1.8643,17.30524,-.76062),(-1.80749,17.33331,-.8469),(-1.97514,17.54928,-.76199),(-2.55636,17.2613,-1.64228),(-2.76039,17.57064,-1.46981),(-2.60331,17.58305,-1.54425),(-2.72366,17.25074,-1.60647),(-2.02517,17.28303,-1.83769),(-2.18615,17.24255,-1.80634),(-1.57775,17.30395,-1.59329),(-1.40672,17.11162,-1.58467),(-1.44139,17.23948,-1.72705),(-1.41419,17.21731,-2.00427),(-1.4506,17.13565,-2.0806),(-1.3027,16.73889,-1.72607),(-1.3156,16.58661,-1.53936),(-1.32283,16.62421,-1.76519),(-1.548,17.22914,-2.18533),(-1.66323,17.31318,-2.04293),(-1.84969,17.31221,-1.90809),(-1.57732,17.17969,-2.28179),(-1.67459,17.21242,-2.19408),(-1.85008,17.07124,-2.46897),(-1.94414,17.13252,-2.34783),(-1.90938,17.12856,-2.20235),(-2.28229,16.91928,-2.63279),(-1.47678,16.07264,-1.92206),(-1.49053,16.02131,-1.66098),(-1.90315,15.69675,-1.36754),(-1.45473,16.95473,-1.1735),(-1.61749,15.89048,-1.14008),(-2.44311,15.92912,-1.54491),(-1.67111,16.53373,-.75639),(-1.68861,16.76774,-.69947),(-2.63567,17.02521,-.34146),(-2.6256,16.79398,-.31922),(-2.42182,16.73916,-.38677),(-2.17963,16.53387,-.41161),(-2.13784,16.0346,-.62457),(-2.29643,15.97942,-.76672),(-2.5044,16.95888,-1.79471),(-2.69641,17.08371,-1.69269),(-2.52659,17.07465,-1.72816),(-2.66197,16.9676,-1.71123),(-2.82091,16.80559,-1.65079),(-2.64164,16.81509,-1.72783),(-2.79279,16.66191,-1.57593),(-2.59777,16.63646,-1.67177),(-2.3366,15.95003,-2.14131),(-2.43928,16.96886,-1.87143),(-3.45815,29.23466,-.71834),(-4.58838,31.43576,-1.43547),(-4.59677,31.61715,-1.36756),(-2.90788,17.54932,-1.42714),(-2.92183,17.66541,-1.38887),(-3.51138,23.60444,.05062),(-3.51037,22.41447,.0882),(-3.43662,22.46737,.07408),(-3.59099,23.64664,.08243),(-2.91099,16.12272,-.59777),(-2.96466,16.02255,-.77523),(-2.72374,16.04232,-.81671),(-2.70627,16.1075,-.65697),(-2.62647,16.2978,-.4591),(-2.60048,16.50029,-.34044),(-3.29708,19.41152,-1.07679),(-3.36873,18.65948,-1.14194),(-3.45355,19.42632,-1.08028),(-3.22193,18.65927,-1.16071),(-3.1775,18.16223,-1.2177),(-3.05958,18.71608,-1.16765),(-3.11091,16.08449,-1.12817),(-4.25289,29.87429,-1.37052),(-3.6093,30.0267,-.20818),(-3.50273,29.68706,-.2793),(-4.38127,31.23348,-.08418),(-4.81157,31.68439,-1.17637),(-4.05381,29.62375,-1.33094),(-4.15701,30.40847,-1.3558),(-3.2411,29.47469,-1.30069),(-3.28011,29.34035,-1.3738),(-3.28029,29.48694,-1.38885),(-4.93605,30.56457,-.2415),(-3.3871,29.23864,-1.19898),(-3.47565,29.24324,-.81666),(-3.41463,29.76741,-.45637),(-4.71902,29.1114,-.35431),(-4.63624,29.37629,-.22486),(-2.40204,17.07087,-2.06421),(-2.40743,17.05415,-2.00985),(-2.39971,16.99389,-2.06593),(-1.76355,15.73782,-1.69595),(-1.82979,15.71015,-1.69435),(-2.18762,15.77911,-1.19117),(-3.27245,16.06031,-1.59115),(-3.37316,15.97618,-1.54197),(-3.14466,15.94621,-.66129),(-2.17638,16.48391,-.39993),(-2.40858,16.59691,-.34286),(-1.60584,16.7879,-2.50237),(-1.73729,16.72034,-2.63363),(-2.0575,17.74138,-.72561),(-2.40943,16.62918,-.3625),(-3.45153,17.0189,-1.75456),(-3.52004,16.85669,-1.95161),(-2.34299,15.91928,-2.15407),(-2.34517,15.83233,-1.88077),(-2.5021,17.04959,-2.2958),(-2.29168,17.17938,-2.18329),(-2.27386,17.1747,-2.15421),(-2.15362,17.19065,-2.2289),(-1.69497,15.9109,-.95536),(-1.59704,15.91759,-1.13357),(-1.78733,15.93704,-.82449),(-4.40132,16.10115,-1.74079),(-3.13246,31.38595,.05423),(-2.97036,31.23443,-.03846),(-3.39911,31.64764,-1.52442),(-3.37005,31.73147,-1.55157),(-3.34643,29.71829,-1.40863),(-3.34505,29.25647,-1.43489),(-3.28381,29.30083,-1.3532),(-3.44693,29.15969,-1.35453),(-4.40911,31.24843,-1.20204),(-4.3939,31.14362,-1.21898),(-3.32024,29.64022,-.62337),(-3.38278,29.45625,-.43364),(-3.38607,29.41886,-.43722),(-3.68404,30.40857,-.17646),(-3.40705,30.38696,-.32425),(-3.31037,29.88075,-.67254),(-1.97765,17.14918,-2.39497),(-1.56196,15.81439,-1.69186),(-1.75617,17.515,-1.3943),(-1.42002,16.83395,-2.1649),(-1.48791,16.97452,-2.33067),(-1.46086,17.06068,-2.20883),(-1.4699,16.72643,-2.28697),(-1.34155,16.41576,-1.82439),(-1.3629,16.28053,-1.61176),(-1.38243,16.24597,-1.87062),(-3.9645,24.61587,-.94014),(-3.91533,23.56623,-.89986),(-3.90057,23.62178,-.86273),(-3.93061,23.56648,-.87696),(-3.90471,23.625,-.87568),(-3.94181,23.57733,-.87813),(-3.93752,23.55291,-.86863),(-3.93567,23.56603,-.88023),(-4.69413,29.98634,-.18195),(-3.5587,30.15085,-.24482),(-3.47778,30.03728,-.35391),(-3.3287,29.89383,-.59641),(-3.34693,29.92504,-.57821),(-3.00078,16.68757,-.07521),(-3.1746,16.67914,.03266),(-3.49906,28.92366,-.69712),(-2.1918,17.18051,-1.9187),(-2.04795,17.19862,-1.95704),(-2.35755,17.09703,-1.98706),(-2.43606,17.05974,-1.86051),(-2.35585,17.12452,-1.86717),(-3.39916,29.96327,-.48917),(-4.67868,28.806,-.35604),(-4.61418,28.20548,-.31514),(-4.62398,27.30234,-.23457),(-4.53267,27.35008,-.12874),(-5.10647,29.93769,-.61741),(-4.96974,29.77864,-.60109),(-3.88643,23.61725,-.86554),(-3.89495,23.62484,-.89032),(-3.87675,23.61696,-.88012),(-3.88047,23.62089,-.89321),(-3.96935,25.43385,-.96305),(-4.05314,26.3532,-.96973),(-2.14313,17.98887,-1.46279),(-1.40323,16.35795,-2.08769),(-1.43521,16.51266,-2.2045),(-1.34157,16.83818,-1.46896),(-1.31931,16.9319,-1.65632),(-2.38244,31.59345,-.95697),(-2.46244,31.9814,-.69561),(-1.72802,16.36963,-2.69897),(-1.63245,16.20959,-2.41476),(-1.63233,16.11037,-2.48507),(-1.69357,16.44357,-2.5771),(-1.88931,17.08777,-2.50852),(-2.37595,17.09191,-2.05398),(-3.75769,30.31669,-.14106),(-3.56571,30.18111,-.21861),(-3.23844,29.46308,-1.26624),(-2.80935,31.11546,-.13838),(-3.25508,31.53524,.06725),(-3.24521,31.56152,.08894),(-3.44743,31.68859,-.01166),(-3.23185,31.32436,-1.50947),(-3.70221,32.11751,-.90369),(-2.62665,31.00085,-1.09618),(-2.41556,16.68417,-.37459),(-3.16665,16.64219,.04334),(-2.98981,16.65151,-.06594),(-2.83474,16.65942,-.20012),(-3.85714,17.15504,-1.7304),(-3.61976,17.12823,-1.75245),(-2.8424,16.06491,-1.16013),(-3.20578,16.04641,-1.34379),(-4.37604,16.40823,-1.87259),(-4.38316,16.40265,-1.9021),(-1.53765,15.849,-1.41043),(-1.56059,15.8237,-1.40669),(-1.60041,15.81464,-1.98438),(-1.58671,15.7907,-1.6947),(-1.65396,16.0913,-2.49735),(-1.60686,15.94217,-2.25338),(-2.51584,16.88422,-2.48089),(-3.37362,16.20318,-1.75796),(-3.52515,16.41523,-1.95654),(-3.93267,20.233,-.69658),(-2.63742,16.00417,-1.2206),(-2.81292,16.05329,-1.10392),(-2.7765,16.01998,-1.03343),(-2.35317,15.93036,-1.04479),(-1.71645,15.76765,-1.40061),(-4.57294,29.56614,-.188),(-3.31087,30.26954,-.50232),(-2.41113,19.45136,-.6898),(-2.64726,20.28371,-.387),(-3.28022,21.3173,.06528),(-3.59578,29.33877,-1.48151),(-4.523,29.96915,-1.39401),(-4.6214,29.90894,-1.31924),(-3.97914,29.68069,-.17733),(-3.91793,29.9993,-.15705),(-3.9499,28.87317,-.10408),(-3.85417,28.3135,-.12311),(-3.79933,28.86599,-.18591),(-3.95986,28.31332,-.07783),(-4.45414,30.59969,-1.49712),(-3.12076,16.10498,-1.15468),(-2.76286,16.4925,-1.44948),(-2.94911,16.44863,-1.36227),(-2.97589,16.6195,-1.49233),(-3.02842,16.92336,-1.58831),(-2.9937,16.75481,-1.57207),(-2.84966,16.95671,-1.65404),(-2.85697,17.06737,-1.63962),(-2.87169,17.2315,-1.55569),(-3.16128,17.86793,-1.27253),(-2.97302,18.56234,-.09161),(-2.92313,19.24086,-.08438),(-3.05442,19.30288,-.03531),(-2.79617,18.50924,-.1737),(-2.6088,16.64501,-.28783),(-2.84514,17.05288,-.22115),(-2.70777,18.00552,-.24402),(-2.6839,17.661,-.28431),(-2.9027,18.00472,-.15492),(-3.37708,21.30667,.08103),(-3.67881,24.70018,.07314),(-3.77532,26.47472,.01849),(-3.78626,25.64031,.09108),(-3.90745,26.49142,.07348),(-3.97525,27.44859,-.0063),(-3.86455,27.4098,-.06609),(-3.07944,20.12825,-.01556),(-3.20072,20.16875,.01334),(-4.60439,31.72515,-1.20816),(-3.09322,31.15542,-1.46961),(-3.18954,31.48379,-1.57168),(-2.61062,15.98159,-1.11955),(-1.56554,16.14144,-1.09498),(-1.63015,16.19077,-.93102),(-1.70781,16.25114,-.78268),(-1.57981,16.46212,-.8882),(-1.58101,16.72365,-.84783),(-1.4799,16.42368,-1.08342),(-1.7273,17.09606,-.82687),(-1.63612,16.89956,-.8211),(-1.6728,17.12811,-.92561),(-1.50222,16.0491,-1.38971),(-1.39759,16.35399,-1.34786),(-2.20576,15.76778,-1.93807),(-2.22463,15.87187,-2.20444),(-1.52613,16.17756,-2.19627),(-2.26887,16.03563,-2.4582),(-1.56097,16.32692,-2.33945),(-1.58838,16.52717,-2.44999),(-2.40868,16.90731,-2.56429),(-2.38515,17.0878,-2.39383),(-1.87047,17.20382,-2.04982),(-2.36603,17.1673,-1.75835),(-1.41151,16.9367,-2.02885),(-1.40196,17.02862,-1.3953),(-1.56646,17.23368,-1.34508),(-2.37357,17.27884,-1.69657),(-2.42573,17.58485,-1.603),(-1.72695,17.38836,-1.06049),(-1.73153,17.47236,-1.23978),(-1.60356,17.17815,-1.13514),(-2.51821,17.40821,-.39348),(-1.87852,17.60081,-.99647),(-1.86732,17.66457,-1.16563),(-1.9003,17.71173,-1.31771),(-2.45892,17.77932,-1.55587),(-2.63205,17.76079,-1.4905),(-2.8058,17.71935,-1.42725),(-2.68748,17.95775,-1.42921),(-2.49072,17.97245,-1.49055),(-1.96946,17.85421,-1.09468),(-2.00988,17.91113,-1.23434),(-1.98272,17.82228,-.94259),(-2.17948,17.67992,-.53874),(-2.13167,18.08112,-.67835),(-2.0867,18.12389,-.86433),(-2.09064,18.1652,-.97286),(-2.55271,18.27442,-1.38081),(-2.74273,18.24028,-1.34048),(-2.82213,18.724,-1.20555),(-2.22132,18.71889,-.85304),(-2.92119,21.39131,-.28403),(-3.03254,21.42712,-.6677),(-3.24763,22.50599,-.62162),(-3.14907,22.47779,-.21902),(-3.41202,23.61705,-.02131),(-3.31407,23.65596,-.20771),(-3.27289,23.68248,-.39488),(-3.76648,24.66727,-.8739),(-3.43533,24.71652,-.16755),(-3.36377,24.73018,-.42812),(-3.54179,25.58742,-.17173),(-3.42835,25.58212,-.55853),(-3.43501,25.59049,-.4617),(-3.8412,25.44074,-.8829),(-3.57415,25.5398,-.71325),(-3.89239,26.40976,-.88),(-3.6318,26.46498,-.18026),(-3.50581,26.50538,-.45304),(-3.71743,27.40553,-.21943),(-3.56954,27.39347,-.46623),(-3.55843,28.28595,-.59991),(-3.55768,28.27919,-.48942),(-3.70432,28.31002,-.26088),(-3.6423,28.87663,-.3058),(-3.51897,28.87891,-.47375),(-3.36946,30.31405,-.38882),(-3.55705,31.73919,-1.11621),(-3.59327,32.0305,-1.29611),(-2.59743,31.1018,-.27457),(-3.10821,31.67336,-1.63028),(-3.27044,31.86191,-1.60072),(-2.6121,31.20844,-1.2665),(-2.57477,31.51356,-.08098),(-2.69683,31.22258,-.05988),(-2.46584,31.40332,-.27979),(-3.42683,32.43856,-.59439),(-3.44047,32.4472,-.97043),(-3.31758,32.31094,-1.32997),(-2.97266,31.96984,-1.56275),(-3.12963,32.11957,-1.52255),(-3.25192,32.49264,-.60559),(-3.21441,32.49161,-.93944),(-3.11368,32.41843,-1.18313),(-3.04311,32.4874,-.65493),(-3.02528,32.49687,-.88253),(-2.56476,32.08226,-.40281),(-2.51888,31.79532,-.22252),(-2.38257,31.71047,-.73658),(-2.51708,31.73342,-.83217),(-2.51853,31.72103,-.8885),(-2.54264,31.76098,-.91864),(-2.52985,31.73667,-.91407),(-2.55103,31.79328,-.86176),(-2.55373,31.79127,-.88894),(-2.9735,32.44763,-1.04694),(-4.18934,16.0496,-1.88994),(-4.1201,15.84595,-1.6448),(-3.73102,16.11408,-1.97185),(-3.98152,16.05641,-1.952),(-3.68545,15.95637,-1.80445),(-3.94865,15.85524,-1.7225),(-3.51145,15.86536,-1.2471),(-3.6165,15.84586,-1.49165),(-3.32916,15.97194,-1.31729),(-3.82438,15.77646,-1.43185),(-4.03345,15.77955,-1.33528),(-3.28808,16.00267,-.304),(-3.09345,16.05335,-.45807),(-3.21286,16.23119,-.13741),(-3.38667,16.21972,-.04711),(-3.18414,16.41801,-.03551),(-3.73615,16.69151,-.12838),(-3.63549,16.69057,.06014),(-3.81642,16.46624,-.34322),(-3.9094,16.66447,-.57539),(-3.93663,16.43388,-.60408),(-3.81566,16.6779,-.38392),(-3.80016,16.24618,-.35824),(-3.90764,16.21013,-.61445),(-4.06827,16.66908,-.79523),(-4.21154,16.35961,-2.04064),(-4.16315,16.70034,-2.04864),(-3.98118,16.36369,-2.08394),(-3.93823,16.68422,-2.07997),(-3.70599,16.89987,-1.98156),(-3.92608,16.91955,-1.98926),(-3.55489,17.24815,-1.49539),(-3.79671,17.44566,-.37299),(-3.00385,17.04381,-.11461),(-3.18762,17.02467,.02511),(-3.18714,17.23152,-.01016),(-3.0157,17.22277,-.11587),(-3.19917,17.45031,-.03967),(-3.87053,17.45221,-.57016),(-3.5449,17.52818,-1.33994),(-3.28707,17.85992,-1.26683),(-3.45955,17.85259,-1.26775),(-3.58974,17.85049,-1.26896),(-3.88798,17.7406,-.5477),(-3.95195,17.77297,-.73838),(-3.69822,17.69747,-.17766),(-3.79313,17.71491,-.34141),(-3.09425,17.99171,-.06276),(-3.71594,17.99731,-.19302),(-3.80677,17.99716,-.3351),(-3.30541,18.16786,-1.21425),(-3.70539,18.52178,-.13452),(-3.81343,18.57234,-.31018),(-3.543,18.50775,-.00511),(-3.58931,19.31105,.00714),(-3.78003,19.33264,-.14341),(-3.8901,19.34929,-.30497),(-3.85677,20.1441,-.08327),(-3.45527,20.13709,.08135),(-3.64747,20.1316,.06667),(-3.61225,21.25302,.12693),(-3.73303,22.36542,.135),(-3.84096,23.60709,.14594),(-4.01359,23.60946,.11747),(-4.21596,23.55924,-.03284),(-4.31956,24.58598,-.02041),(-4.14273,26.47191,.10527),(-4.21539,27.44028,.03445),(-4.44299,27.39782,-.02239),(-4.20026,28.31302,-.05261),(-4.20444,28.87752,-.09103),(-4.72902,28.80965,-.58252),(-4.25313,29.22845,-1.21937),(-4.72672,30.83117,-1.49002),(-5.00415,31.45363,-1.11188),(-2.54189,31.77989,-.84381),(-4.23554,16.88704,-1.74831)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesRightFemur.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesRightFemur.py load and self-test diagnostics complete.")
