####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesMandible.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    meta(content='BonesMandible.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Mandible',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesMandible.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesMandible.x3d'),
    Transform(DEF='MandibleSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Viewpoint(DEF='Head',description='Hips',position=(0,55,25)),
      Group(DEF='Manible',
        #  lacl lacr frontal ethmoid ethmoid2 inconl inconr mand maxl maxr nasall nasalr occip palatl palatr parietl parietr sphenoid templ tempr vom zygol zygor 
        #  atlas axis c2disc c3 c3disc c4 
        children=[
        Shape(DEF='mand',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='mand_Geo',coordIndex=[0,1,2,-1,3,4,2,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,31,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,45,55,56,-1,57,58,59,-1,60,61,62,-1,63,58,57,-1,64,65,66,-1,67,68,69,-1,70,71,72,-1,6,73,63,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,108,105,-1,109,110,111,-1,112,113,114,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,130,118,131,-1,132,133,119,-1,134,135,136,-1,137,138,139,-1,140,141,115,-1,142,143,144,-1,145,146,147,-1,148,149,150,-1,151,152,153,-1,154,155,156,-1,154,157,155,-1,158,159,160,-1,161,162,163,-1,164,165,166,-1,167,159,158,-1,168,169,170,-1,171,172,173,-1,174,175,176,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,186,187,184,-1,188,189,190,-1,191,192,193,-1,194,195,178,-1,196,188,197,-1,198,199,200,-1,201,202,203,-1,204,205,201,-1,206,207,208,-1,209,210,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,219,221,222,-1,223,224,225,-1,226,227,228,-1,229,230,231,-1,232,233,234,-1,232,216,215,-1,235,236,237,-1,238,220,222,-1,239,240,241,-1,242,243,244,-1,245,246,247,-1,248,249,239,-1,250,251,252,-1,253,254,255,-1,256,257,247,-1,258,259,252,-1,260,261,262,-1,263,264,265,-1,266,267,268,-1,269,260,270,-1,271,272,273,-1,274,275,276,-1,277,278,279,-1,280,281,282,-1,283,284,285,-1,286,287,288,-1,289,290,291,-1,292,293,288,-1,294,295,296,-1,297,298,264,-1,264,298,299,-1,300,301,302,-1,303,287,304,-1,305,250,306,-1,307,308,303,-1,309,310,311,-1,312,313,314,-1,315,316,311,-1,317,318,319,-1,320,316,315,-1,321,322,323,-1,324,325,326,-1,327,328,329,-1,330,312,331,-1,332,333,334,-1,335,336,337,-1,338,339,340,-1,341,342,343,-1,344,345,346,-1,347,348,349,-1,350,351,352,-1,353,354,355,-1,355,354,356,-1,357,358,359,-1,360,356,361,-1,362,363,364,-1,365,366,367,-1,368,369,370,-1,371,372,373,-1,261,374,274,-1,375,376,377,-1,296,378,273,-1,286,374,379,-1,380,293,381,-1,382,245,383,-1,384,385,386,-1,377,387,388,-1,389,390,391,-1,389,391,265,-1,392,245,393,-1,394,395,396,-1,350,347,349,-1,397,249,248,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,404,411,-1,412,413,414,-1,415,416,417,-1,413,418,414,-1,414,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,428,-1,429,430,431,-1,409,432,433,-1,425,434,435,-1,436,437,438,-1,439,440,441,-1,442,443,444,-1,333,445,334,-1,271,260,266,-1,334,446,447,-1,448,449,450,-1,451,452,453,-1,454,455,244,-1,456,457,458,-1,244,243,459,-1,460,461,462,-1,463,464,465,-1,466,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,472,479,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,489,490,491,-1,492,493,494,-1,495,496,497,-1,498,499,500,-1,501,502,503,-1,504,505,506,-1,507,508,509,-1,510,511,512,-1,513,504,508,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,523,524,525,-1,310,526,527,-1,528,314,529,-1,530,531,532,-1,321,533,534,-1,535,536,537,-1,538,539,540,-1,541,542,543,-1,484,482,544,-1,482,481,545,-1,546,547,548,-1,544,482,549,-1,488,550,489,-1,490,551,552,-1,553,554,555,-1,556,557,326,-1,521,558,522,-1,559,560,561,-1,562,563,564,-1,565,502,501,-1,566,523,567,-1,568,498,500,-1,569,570,563,-1,571,569,565,-1,572,573,574,-1,575,576,577,-1,578,572,574,-1,579,580,581,-1,582,568,583,-1,575,584,585,-1,577,586,567,-1,587,588,589,-1,525,584,523,-1,580,590,581,-1,591,592,593,-1,591,594,595,-1,596,564,597,-1,564,598,597,-1,599,600,601,-1,505,602,603,-1,604,581,605,-1,606,607,608,-1,609,610,477,-1,496,611,506,-1,612,613,614,-1,615,616,613,-1,617,497,506,-1,618,619,620,-1,621,622,623,-1,624,625,626,-1,627,628,629,-1,630,631,632,-1,630,632,627,-1,633,634,635,-1,636,637,638,-1,639,640,641,-1,642,643,644,-1,645,646,647,-1,648,649,650,-1,649,648,651,-1,652,653,654,-1,616,655,656,-1,646,657,647,-1,658,659,637,-1,660,661,662,-1,633,663,634,-1,664,649,665,-1,666,667,668,-1,527,532,315,-1,669,670,671,-1,470,469,672,-1,553,555,673,-1,674,533,556,-1,675,676,677,-1,676,678,677,-1,678,679,677,-1,680,681,682,-1,683,684,685,-1,686,687,688,-1,689,690,691,-1,692,693,694,-1,695,696,697,-1,698,699,700,-1,701,702,703,-1,704,705,706,-1,707,708,709,-1,710,711,712,-1,713,714,715,-1,710,716,717,-1,718,719,720,-1,721,722,723,-1,724,725,726,-1,727,728,729,-1,708,730,731,-1,732,733,734,-1,735,736,737,-1,738,739,740,-1,741,742,743,-1,744,745,746,-1,747,748,749,-1,750,751,739,-1,740,752,753,-1,754,755,742,-1,756,757,758,-1,759,760,761,-1,762,763,764,-1,765,766,706,-1,763,762,767,-1,768,769,770,-1,771,772,747,-1,773,774,775,-1,776,775,777,-1,765,778,779,-1,749,780,771,-1,781,710,717,-1,782,783,781,-1,784,725,724,-1,785,786,787,-1,788,789,790,-1,789,791,790,-1,786,785,792,-1,793,794,739,-1,795,796,722,-1,797,798,799,-1,788,800,801,-1,802,803,804,-1,805,806,807,-1,708,707,720,-1,738,740,785,-1,750,808,809,-1,810,811,812,-1,813,814,815,-1,816,817,699,-1,818,819,774,-1,774,698,775,-1,757,820,821,-1,761,760,822,-1,711,710,781,-1,823,824,825,-1,826,827,828,-1,829,828,830,-1,831,832,826,-1,833,825,834,-1,835,836,834,-1,837,838,839,-1,840,9,8,-1,841,842,843,-1,844,845,779,-1,846,803,802,-1,847,848,849,-1,850,851,852,-1,853,676,821,-1,685,854,855,-1,856,817,857,-1,857,858,859,-1,860,861,853,-1,862,863,864,-1,815,814,865,-1,684,866,867,-1,866,868,867,-1,717,716,869,-1,870,871,872,-1,873,874,875,-1,876,877,878,-1,879,880,881,-1,373,874,882,-1,371,390,389,-1,880,883,884,-1,885,886,887,-1,888,882,876,-1,889,805,890,-1,891,892,893,-1,894,895,896,-1,897,898,899,-1,900,901,902,-1,903,904,905,-1,906,907,908,-1,909,886,902,-1,910,911,901,-1,912,280,282,-1,371,269,372,-1,913,914,915,-1,916,917,918,-1,919,920,921,-1,922,923,924,-1,925,926,927,-1,928,929,916,-1,930,931,932,-1,933,934,935,-1,936,937,938,-1,393,939,940,-1,941,400,942,-1,943,944,945,-1,910,946,947,-1,250,381,306,-1,948,394,949,-1,300,352,950,-1,951,952,953,-1,416,954,417,-1,955,956,957,-1,958,959,960,-1,961,955,962,-1,963,964,965,-1,966,967,922,-1,964,963,406,-1,968,969,970,-1,419,418,971,-1,963,972,973,-1,974,975,976,-1,977,975,974,-1,978,979,980,-1,981,982,983,-1,984,408,985,-1,986,987,988,-1,989,990,991,-1,992,993,994,-1,995,996,997,-1,998,999,1000,-1,1001,1002,1003,-1,422,1004,1005,-1,442,970,443,-1,442,1006,1007,-1,1008,1009,1010,-1,1011,961,1012,-1,1013,1014,1015,-1,1016,959,1017,-1,1018,956,375,-1,1019,285,1020,-1,1021,944,943,-1,1022,1023,1024,-1,1025,332,1026,-1,1013,1027,1028,-1,1012,1029,1030,-1,918,1031,1032,-1,416,1033,953,-1,1034,1035,1036,-1,1037,1038,349,-1,1039,302,1040,-1,1041,1042,1043,-1,1044,382,383,-1,1045,1046,1047,-1,1019,1045,285,-1,1048,1049,913,-1,1050,1051,1052,-1,1050,1053,1054,-1,1055,1056,1057,-1,1058,1059,1060,-1,1061,1062,1063,-1,1064,1065,1066,-1,1067,1068,1069,-1,1070,1071,1072,-1,1073,1074,1075,-1,1076,1077,1078,-1,1079,1080,1081,-1,1082,1083,1084,-1,1085,1086,1087,-1,1088,1089,1090,-1,1091,1092,1093,-1,1094,1095,1096,-1,1097,1098,1099,-1,1100,1101,1102,-1,1103,1104,1105,-1,1106,1107,1108,-1,1109,1110,1111,-1,1112,1113,1114,-1,1091,1111,1115,-1,1116,1117,1076,-1,1118,1119,1120,-1,1121,1122,1123,-1,1124,1125,1126,-1,1127,1128,1129,-1,1130,1131,1132,-1,1133,1134,1135,-1,1136,1137,1138,-1,1139,1140,1141,-1,1142,1143,1144,-1,1143,1132,1144,-1,1145,1146,1147,-1,1141,1144,1148,-1,1149,1135,1134,-1,1150,1151,1148,-1,1152,1153,1154,-1,1155,1156,1157,-1,1158,1159,1160,-1,1161,1162,1163,-1,1164,1165,1166,-1,1167,1122,1057,-1,1168,1169,1170,-1,1171,1172,1173,-1,1174,1175,1176,-1,1177,1178,1179,-1,1180,1181,1182,-1,1183,1184,1185,-1,1186,1187,1188,-1,1189,1190,1191,-1,1192,1193,1176,-1,1194,1195,1169,-1,1196,1197,1198,-1,1199,1200,1201,-1,1202,1203,1204,-1,1205,1206,1207,-1,1208,1209,1210,-1,1211,1209,1212,-1,1213,1214,1215,-1,1216,1217,1218,-1,1219,1220,1221,-1,1222,1223,1224,-1,1225,1226,1227,-1,1228,1229,1230,-1,1231,1232,1233,-1,1234,1235,1236,-1,1237,1238,1239,-1,1240,1241,1242,-1,1243,1244,1245,-1,1246,1247,1248,-1,1249,1250,1251,-1,1252,1253,1254,-1,1255,1256,1257,-1,1258,1259,1260,-1,1261,1262,1263,-1,1264,1265,1266,-1,1267,1260,1268,-1,1269,1270,1271,-1,1272,1273,1274,-1,1270,1275,1276,-1,1277,1278,1279,-1,1280,1281,1282,-1,1283,1284,1285,-1,1286,1287,1288,-1,1289,1290,1291,-1,1292,1293,1294,-1,1282,1281,1295,-1,1296,1285,1297,-1,1298,1299,1300,-1,1301,1302,1303,-1,1304,1305,1306,-1,1307,1308,1309,-1,1310,1311,1312,-1,1313,1314,1315,-1,1316,1317,1318,-1,1319,1320,1321,-1,1322,1323,1324,-1,1325,1326,1327,-1,1328,1329,1330,-1,1331,1332,1333,-1,1334,1335,1336,-1,1337,1338,1339,-1,1340,1341,1342,-1,1340,1343,1341,-1,1344,1345,1346,-1,1347,1348,1349,-1,1350,1351,1352,-1,1352,1353,1350,-1,1354,1355,1356,-1,1357,1358,1359,-1,1360,1361,1362,-1,1363,1364,1365,-1,1366,1367,1368,-1,1366,1369,1367,-1,1370,1371,1372,-1,1373,1367,1374,-1,1368,1375,1376,-1,1377,1348,1378,-1,1379,1376,1380,-1,1376,1379,1381,-1,1382,1383,1346,-1,1384,1385,1386,-1,1387,1388,1349,-1,1378,1379,1380,-1,1389,1390,1391,-1,1392,1393,1394,-1,1395,1396,1397,-1,1398,1399,1400,-1,1401,1402,1403,-1,1404,1405,1406,-1,1407,1408,1409,-1,1410,1411,1412,-1,1413,1414,1415,-1,1416,1417,1418,-1,1419,1420,1421,-1,1422,1423,1417,-1,1424,1425,1426,-1,1427,1428,1429,-1,1430,1431,1432,-1,1433,1434,1435,-1,1436,1437,1438,-1,1439,1440,1441,-1,1387,1442,1388,-1,1443,1444,1445,-1,1446,1447,1448,-1,1449,1450,1451,-1,1452,1444,1443,-1,1453,1454,1445,-1,1455,1456,1371,-1,1457,1369,1381,-1,1458,1459,1460,-1,1461,1413,1462,-1,1463,1461,1464,-1,1465,1458,1466,-1,1467,1468,1469,-1,1470,1468,1471,-1,1472,1473,1474,-1,1475,1476,1477,-1,1478,1474,1479,-1,1478,1480,1474,-1,1481,1482,1483,-1,1484,1485,1486,-1,1487,1488,1489,-1,1490,1491,1492,-1,1493,1494,1495,-1,1496,1497,1498,-1,1479,1499,1500,-1,1492,1501,1502,-1,1478,1500,1480,-1,1503,1504,1505,-1,1506,1507,1508,-1,1509,1510,1511,-1,1512,1513,1514,-1,1515,1516,1517,-1,1518,1509,1519,-1,1520,1521,1522,-1,1523,1524,1525,-1,1526,1527,1523,-1,1527,1528,1524,-1,1529,1530,1531,-1,1532,1533,1534,-1,1535,1536,1537,-1,1538,1539,1540,-1,1541,1542,1543,-1,1544,1545,1546,-1,1547,1548,1549,-1,1550,1551,1552,-1,1553,1554,1555,-1,1556,1321,1557,-1,1558,1559,1554,-1,1560,1561,1562,-1,1563,1564,1565,-1,1566,1567,1568,-1,1566,1569,1570,-1,1540,1571,1572,-1,1573,1574,1575,-1,1576,1577,1578,-1,1579,1580,1578,-1,1581,1582,1583,-1,1584,1585,1586,-1,1587,1588,1589,-1,1590,1591,1592,-1,1593,1594,1595,-1,1596,1597,1598,-1,1597,1599,1598,-1,1600,1601,1602,-1,1603,1604,1605,-1,1606,1607,1608,-1,1609,1610,1611,-1,1612,1611,1613,-1,1614,1615,1616,-1,1617,1618,1619,-1,1620,1621,1389,-1,1622,1392,1623,-1,1619,1624,1625,-1,1625,1626,1627,-1,1628,1629,1406,-1,1630,1631,671,-1,535,1632,1633,-1,1634,1635,1636,-1,1637,1635,1638,-1,1639,1640,1641,-1,1642,1643,1644,-1,1645,1646,1647,-1,1647,1648,1649,-1,1650,1651,1652,-1,1589,1653,1654,-1,1655,1656,1584,-1,1587,1589,1657,-1,1607,1658,1659,-1,1660,1661,1662,-1,1592,1663,1664,-1,1657,1665,1586,-1,1607,1666,1658,-1,1667,1655,1668,-1,1669,1670,1612,-1,1671,1672,1673,-1,1674,1675,1676,-1,1677,1672,1678,-1,1679,1598,1599,-1,1680,1681,1682,-1,1683,1684,1685,-1,1592,1591,1683,-1,1686,1687,1688,-1,1689,1690,1691,-1,1692,1693,1694,-1,1695,1696,1686,-1,1584,1586,1665,-1,1612,1670,1666,-1,1697,1698,1699,-1,1699,1700,1697,-1,1701,1535,1702,-1,1703,1704,1705,-1,1597,1706,1707,-1,1708,1709,539,-1,1710,1711,1712,-1,1713,1714,1715,-1,1716,1596,1714,-1,1717,1605,1718,-1,1719,1720,1721,-1,1722,1723,1724,-1,1716,1725,1726,-1,1727,1728,1726,-1,1729,1730,1731,-1,1732,1733,644,-1,1734,1735,1736,-1,1737,1738,1739,-1,1740,1741,1742,-1,1743,1744,1731,-1,1745,1734,1746,-1,1747,1748,1749,-1,1750,1751,1734,-1,1752,1753,1713,-1,1754,1755,1756,-1,1757,1758,1759,-1,1760,1761,1762,-1,1760,1763,1764,-1,1765,1724,1766,-1,1749,1767,1768,-1,1769,1770,1771,-1,1772,1773,1774,-1,1775,1776,1777,-1,1778,1389,1621,-1,1741,643,1779,-1,1780,1704,1781,-1,1782,1783,1784,-1,1636,1785,1786,-1,1787,1402,1401,-1,1783,1788,1567,-1,1789,1790,1570,-1,1791,1535,1701,-1,1792,1793,1794,-1,1795,1562,1796,-1,1797,1798,1799,-1,1800,1801,1802,-1,1803,1804,1805,-1,1806,1807,1808,-1,1809,1805,1804,-1,1577,1810,1811,-1,1812,1813,1814,-1,1815,1816,1817,-1,1818,1819,1820,-1,1821,1822,1823,-1,1824,1528,1825,-1,1826,1827,1828,-1,1829,1830,1831,-1,1827,1832,1833,-1,1834,1835,1836,-1,1837,1838,1839,-1,1840,1841,1838,-1,1838,1841,1842,-1,1827,1843,1828,-1,1826,1844,1845,-1,1846,1840,1847,-1,1848,1849,1850,-1,1579,1851,1852,-1,1853,1577,1854,-1,1855,1856,1857,-1,1858,1859,1860,-1,1861,1862,1863,-1,1862,1861,1864,-1,1865,1866,1867,-1,1868,1869,1870,-1,1871,1872,1873,-1,1874,1875,1876,-1,1877,1878,1879,-1,1880,1881,1882,-1,1883,1884,1885,-1,1879,1886,1887,-1,1888,1889,1890,-1,1891,1892,1893,-1,1841,1894,1895,-1,1837,1896,1897,-1,1898,1899,1847,-1,1579,1853,1900,-1,1838,1837,1897,-1,1901,1902,1903,-1,1814,1904,1905,-1,1906,1808,1907,-1,1866,1865,1862,-1,1908,1909,1910,-1,1911,1912,1913,-1,1914,1915,1916,-1,1868,1917,1918,-1,1919,1920,1921,-1,1922,1921,1923,-1,1924,1925,1926,-1,1927,1928,1929,-1,1930,1931,1932,-1,1876,1933,1081,-1,1934,1935,1936,-1,1937,1938,1895,-1,1893,1892,1939,-1,1822,1940,1941,-1,1525,1521,1942,-1,1526,1845,1943,-1,1944,1910,1909,-1,1844,1909,1845,-1,1945,1946,1947,-1,1948,1949,1950,-1,1328,1951,1952,-1,1953,1946,1945,-1,1440,1954,1441,-1,1955,1956,1957,-1,1956,1955,1958,-1,1959,1960,1961,-1,1962,1963,1964,-1,1963,1960,1820,-1,1965,1966,1826,-1,1967,1961,1968,-1,1607,1969,1608,-1,1970,1971,1972,-1,1973,1974,1975,-1,1976,1977,1978,-1,1979,1980,1360,-1,1385,1384,1981,-1,1982,1983,1984,-1,1985,1986,1987,-1,1988,1989,1990,-1,1991,1992,1993,-1,1434,1994,1995,-1,1433,1996,1482,-1,1997,1998,1977,-1,1999,2000,2001,-1,2002,2000,2003,-1,1972,2004,2005,-1,1327,2006,2007,-1,2008,2009,2010,-1,2011,1994,1431,-1,2012,1452,2013,-1,2014,1994,2015,-1,2016,2017,1506,-1,2018,2019,2020,-1,2021,2022,2023,-1,2024,2011,2025,-1,2024,2026,2027,-1,2023,2022,2026,-1,2028,1428,2029,-1,2030,2031,2032,-1,2033,2034,2035,-1,2036,2037,2038,-1,2039,2040,2035,-1,2041,2042,2043,-1,2044,2045,2046,-1,2047,2048,2049,-1,2050,2051,2052,-1,2053,2054,2055,-1,2056,2057,2058,-1,2059,2060,2061,-1,2062,2063,2064,-1,1452,1443,2065,-1,2066,2060,2059,-1,2067,2068,2069,-1,2070,2071,2072,-1,2073,2074,2075,-1,2076,2077,2078,-1,2076,2079,2077,-1,2049,2080,2081,-1,2082,2083,2084,-1,2085,2086,2087,-1,2047,2088,2089,-1,2090,1488,1487,-1,1519,2091,2092,-1,2020,2093,2094,-1,2092,2095,2096,-1,2097,2098,2012,-1,1449,2099,2100,-1,2101,2102,2103,-1,2104,2105,2106,-1,2107,2103,2108,-1,2021,1518,2022,-1,1984,2109,1494,-1,2110,2111,2004,-1,2112,2113,2114,-1,2115,2116,1422,-1,2117,2014,2118,-1,2119,2120,2121,-1,2122,2123,1460,-1,1466,2124,2125,-1,2099,2126,2127,-1,1331,1461,2128,-1,2124,2129,2130,-1,1360,2131,1979,-1,2132,2133,2134,-1,2135,2006,2136,-1,1382,1463,1464,-1,2137,2010,2124,-1,2110,2004,2138,-1,2139,2140,2141,-1,1430,2033,2025,-1,2075,2142,2143,-1,2144,2145,1989,-1,1511,1510,2146,-1,2091,2147,2092,-1,2103,2148,2104,-1,2149,1534,1533,-1,2150,2151,2152,-1,2153,2154,1453,-1,2155,2156,1446,-1,2146,2018,2157,-1,2158,2159,2160,-1,1982,2054,1489,-1,2083,2161,2162,-1,2163,2068,2067,-1,2164,2165,2166,-1,2167,2168,1479,-1,2169,2170,2171,-1,2172,2085,1501,-1,2173,2174,1498,-1,2058,2175,2084,-1,2176,2177,2178,-1,2172,2059,2061,-1,2179,2180,2175,-1,2181,2090,2182,-1,2143,2183,2075,-1,1499,2170,2164,-1,1487,2182,2090,-1,2052,2051,2184,-1,2037,1488,2038,-1,2096,2185,2092,-1,1486,2186,2052,-1,2014,2015,2187,-1,2188,1484,2021,-1,2189,2156,2190,-1,1364,2191,1365,-1,2192,1419,2193,-1,2194,2195,2141,-1,2196,2065,2197,-1,2198,1413,1461,-1,2194,2199,2200,-1,1327,1977,1998,-1,2201,2111,2202,-1,2203,1465,1466,-1,2003,2000,2123,-1,1994,1434,1432,-1,2204,2205,2206,-1,2207,1986,2208,-1,2117,2209,1995,-1,1421,2210,2211,-1,1430,2025,2011,-1,2212,1384,2132,-1,1949,2213,2214,-1,1950,2215,1439,-1,1327,1326,1978,-1,1382,1464,2216,-1,1976,2217,2218,-1,1467,1327,2007,-1,2219,2220,2221,-1,2222,1976,1978,-1,1836,1835,2223,-1,2224,1609,2225,-1,1901,2226,2227,-1,1820,2228,2229,-1,1954,1981,2230,-1,2231,2232,1945,-1,1947,1946,2217,-1,2233,2234,2235,-1,1441,2236,1948,-1,1949,2237,2238,-1,2239,1948,2240,-1,2241,2233,1972,-1,1824,1825,2241,-1,1981,1953,2230,-1,2240,2236,2242,-1,2243,2231,1947,-1,2244,1885,1890,-1,1866,1864,2245,-1,1880,1862,2246,-1,1858,2247,2248,-1,1965,1526,1523,-1,1917,1470,1471,-1,2249,1528,1527,-1,1527,1526,1941,-1,1940,1822,2250,-1,2251,2252,1895,-1,2253,2254,2255,-1,1884,2256,2257,-1,2258,2259,2260,-1,2261,2262,2263,-1,2264,2265,2266,-1,2267,2268,2269,-1,2270,2269,2262,-1,1924,2271,2272,-1,2269,1923,2262,-1,2273,2274,2275,-1,2276,2277,2278,-1,2279,2280,2281,-1,2282,1918,2235,-1,2283,1802,1917,-1,1863,1880,2284,-1,1912,1911,1908,-1,1823,1943,2285,-1,2246,1865,2286,-1,2287,2288,1877,-1,2289,2290,2291,-1,2292,2293,2294,-1,2295,2255,2296,-1,2297,2298,2299,-1,1851,2300,2301,-1,1896,2302,1897,-1,2303,2304,2305,-1,2306,2307,2308,-1,2289,2309,1936,-1,1900,1854,2299,-1,2291,2310,2309,-1,1841,2311,1894,-1,2312,2275,2313,-1,2244,2312,2314,-1,1877,2315,2316,-1,1884,2317,1890,-1,1913,1912,1933,-1,1912,2318,2319,-1,2320,2321,2316,-1,2322,1886,1883,-1,1882,2323,2284,-1,2324,1830,1888,-1,2325,2326,2323,-1,2283,1870,2327,-1,1817,1858,1860,-1,2328,2329,2288,-1,1877,1871,2315,-1,1914,1916,2330,-1,1803,2331,2332,-1,2291,2290,1860,-1,1577,2333,1810,-1,2334,1966,2335,-1,2336,2337,2294,-1,1841,1840,1846,-1,2338,2302,1898,-1,2292,2294,2339,-1,2244,1889,2273,-1,2340,1843,1833,-1,2341,2274,2273,-1,2274,2342,2293,-1,1944,2343,1830,-1,2344,1844,1826,-1,2345,1821,1823,-1,1815,2346,1904,-1,1812,1816,1813,-1,2347,2248,2247,-1,2348,2349,1861,-1,2250,2350,2351,-1,1808,2352,1805,-1,2353,1806,1906,-1,2354,1866,2245,-1,2355,1802,1801,-1,2356,2357,2358,-1,1787,2359,2360,-1,1782,2361,1783,-1,2362,1780,1789,-1,1631,2363,2364,-1,1623,1733,1739,-1,1618,1395,1778,-1,2365,1768,2366,-1,2367,2368,2369,-1,1752,1713,2370,-1,2371,1762,2372,-1,2373,2374,1617,-1,1603,2375,2376,-1,2377,1741,1740,-1,1746,1736,2367,-1,1747,2367,2375,-1,1743,1738,2378,-1,644,643,1732,-1,2379,1729,2380,-1,1729,2381,2380,-1,1391,1390,2382,-1,2383,1763,1762,-1,1723,1717,1727,-1,1753,1752,2384,-1,2384,2385,2386,-1,1725,1753,2386,-1,2387,2388,2389,-1,1757,2373,2390,-1,1714,1596,2391,-1,2370,1715,2389,-1,2392,1718,1605,-1,2393,614,2394,-1,2395,2396,2397,-1,1782,2398,2399,-1,1536,2400,1537,-1,2401,1557,2402,-1,1792,1696,2403,-1,2404,2405,2406,-1,1563,2407,1564,-1,2408,2409,2410,-1,2411,2412,2413,-1,1555,2414,2415,-1,2416,2417,2418,-1,1538,2419,1539,-1,1593,2419,2420,-1,1694,2417,2416,-1,2421,2422,2423,-1,2424,2425,1674,-1,2426,2427,2428,-1,2429,1660,2430,-1,1683,1591,1684,-1,2422,2430,1682,-1,1671,2427,1678,-1,1683,2431,2432,-1,2433,1698,2434,-1,2433,2410,1699,-1,1671,2435,1592,-1,1661,2429,1675,-1,2436,1654,2437,-1,1584,1665,2410,-1,1657,1589,1654,-1,2438,1611,1610,-1,2439,1405,2360,-1,2440,1689,2441,-1,2442,2443,1644,-1,1573,1575,2444,-1,2445,2446,1643,-1,2447,1576,1642,-1,2445,1642,1580,-1,1635,1785,1636,-1,2448,2449,1632,-1,2450,1730,2451,-1,2360,1405,1404,-1,1626,2452,2453,-1,2450,2454,1730,-1,1620,1776,2455,-1,2456,1395,1618,-1,2422,1681,2423,-1,2457,1609,1611,-1,1582,1581,1565,-1,1600,2397,2396,-1,1598,2391,1596,-1,2458,2459,2460,-1,1665,2461,2410,-1,1579,1578,1853,-1,1579,2462,1645,-1,1642,1576,1578,-1,2463,2333,1577,-1,2464,2465,1572,-1,2398,1784,1781,-1,1561,2466,1562,-1,2415,1322,2467,-1,1324,2468,2469,-1,1544,243,2470,-1,2471,2472,456,-1,1530,2473,1521,-1,1521,2473,2474,-1,1504,1503,2475,-1,1356,1355,2476,-1,2475,2477,2478,-1,2479,1518,1519,-1,2480,2481,2482,-1,1506,2017,2483,-1,1496,1498,2484,-1,1510,2485,1475,-1,1502,1501,2486,-1,2487,1493,2057,-1,1496,2484,2045,-1,1489,2044,1487,-1,1489,2053,2044,-1,2488,1983,1982,-1,2109,2141,2140,-1,1983,1481,1483,-1,2489,1472,1480,-1,2186,1486,1473,-1,2177,2490,2089,-1,1466,1999,2129,-1,2491,1333,1332,-1,2137,1414,2010,-1,2120,2199,2492,-1,2493,2494,1448,-1,2495,1440,2496,-1,1350,2495,2496,-1,2497,2197,1445,-1,1450,2100,1447,-1,2498,2494,1456,-1,1456,2499,2500,-1,1373,1374,1372,-1,2501,1980,1457,-1,1444,1453,1445,-1,2502,1374,2131,-1,1948,1950,1439,-1,1438,2503,2504,-1,1422,1424,1423,-1,2112,2505,2506,-1,2507,2508,2509,-1,2114,2510,2505,-1,1419,1421,2193,-1,2511,2141,2195,-1,1413,2008,1414,-1,2512,2513,2514,-1,2515,2516,2517,-1,2518,2519,2520,-1,2520,2519,2028,-1,2478,2521,1504,-1,2522,2523,1634,-1,2439,2524,2525,-1,2526,2527,2528,-1,1641,2529,2524,-1,1389,2530,1390,-1,1392,2531,1393,-1,2532,1396,1395,-1,2533,2534,2535,-1,1377,2536,2537,-1,1375,2538,2533,-1,1946,1953,2539,-1,1382,2540,1383,-1,1373,1368,1367,-1,1352,2476,2541,-1,2534,2533,2542,-1,2500,2543,1371,-1,1369,1374,1367,-1,1371,1368,1372,-1,2544,2545,1363,-1,2545,2544,2152,-1,2546,2547,2548,-1,2549,1374,2502,-1,1980,2541,2476,-1,1351,1354,1356,-1,1353,1388,1442,-1,1442,2495,1350,-1,2098,2099,2012,-1,1338,1342,2550,-1,2551,2552,1337,-1,1337,1339,2553,-1,1336,1332,1331,-1,1331,1334,1336,-1,2554,2555,2556,-1,2557,2558,1542,-1,2558,1543,1542,-1,2559,1305,1304,-1,2560,2561,2562,-1,2563,1312,1311,-1,2564,2565,2566,-1,1308,1301,2567,-1,2568,2569,2560,-1,2560,1306,2561,-1,2570,1315,2571,-1,2572,2573,2574,-1,2575,2576,2577,-1,2566,1301,1303,-1,1310,2566,2578,-1,1299,2579,1300,-1,2580,2581,2582,-1,2583,2584,2585,-1,2586,1283,2587,-1,2588,2589,2590,-1,2591,2592,2593,-1,2594,2595,2591,-1,2596,1269,1271,-1,2597,1273,1272,-1,2598,2599,2600,-1,2601,2602,2603,-1,1260,1259,1268,-1,2604,1267,2605,-1,1266,2606,2607,-1,2608,2609,2606,-1,2610,2611,1264,-1,2612,2600,2602,-1,2612,2613,2600,-1,1261,2614,1262,-1,2615,1258,2616,-1,2617,2618,2619,-1,1251,2620,1256,-1,2621,2622,2623,-1,2624,1237,1239,-1,1230,2625,2626,-1,1219,2627,1231,-1,2628,1218,1225,-1,2629,2630,2631,-1,2632,2633,2424,-1,2634,1196,1198,-1,1169,1195,2635,-1,2636,2637,2638,-1,1183,2639,1204,-1,2640,2641,1199,-1,2642,2643,1182,-1,2644,1176,2645,-1,2646,2647,1186,-1,1184,1183,2641,-1,1177,2648,2649,-1,2650,1169,1168,-1,2651,2652,2653,-1,1171,1178,2649,-1,2654,2655,2656,-1,2654,2657,2655,-1,2658,2659,2660,-1,2661,2662,2658,-1,2663,2662,2661,-1,2664,2665,2666,-1,2667,2668,2669,-1,1137,2670,2671,-1,1136,1138,1134,-1,1121,1123,2672,-1,1119,1116,1078,-1,2673,2674,2675,-1,2676,1114,2677,-1,1111,2678,2679,-1,2680,2681,1113,-1,2682,2683,2684,-1,2685,1110,1109,-1,2686,2687,2683,-1,2688,2689,2690,-1,2691,2692,2693,-1,2694,2695,2696,-1,2697,2698,2699,-1,2690,2700,2701,-1,2702,2703,1095,-1,2704,2705,1092,-1,1097,2685,1098,-1,2685,2706,1098,-1,2707,2708,2691,-1,2709,2710,2711,-1,2712,2713,2714,-1,2715,2716,2717,-1,2718,1068,1067,-1,1163,1066,1065,-1,1062,2719,1063,-1,1055,1077,2720,-1,1079,2721,2722,-1,1070,1060,2723,-1,2724,1073,1059,-1,2725,2726,2261,-1,2727,2673,2728,-1,2729,2730,2731,-1,2732,2733,2729,-1,1049,2734,913,-1,378,290,261,-1,349,348,1037,-1,2735,300,2736,-1,385,393,2737,-1,400,941,1037,-1,934,938,935,-1,2738,2739,2740,-1,931,922,932,-1,2741,364,2742,-1,2743,417,2744,-1,431,2745,2746,-1,2747,921,2748,-1,2749,2750,2751,-1,444,973,972,-1,2752,1027,1013,-1,1028,1008,2753,-1,1013,2754,2755,-1,385,2737,2756,-1,2757,2758,2759,-1,969,2760,970,-1,2761,375,956,-1,2762,970,442,-1,420,419,974,-1,401,2763,2764,-1,988,2765,2766,-1,2767,1003,2768,-1,2769,2770,995,-1,989,2771,2772,-1,2773,2774,2775,-1,994,2776,2777,-1,994,993,2776,-1,982,2778,2779,-1,952,2780,2781,-1,2769,1000,2770,-1,981,2778,982,-1,979,2782,2783,-1,421,2784,2785,-1,2786,2787,2788,-1,2764,2789,2790,-1,976,975,2777,-1,2791,2792,2793,-1,2794,2795,2796,-1,968,2797,969,-1,2798,2799,2800,-1,2801,2802,2803,-1,2804,2805,2806,-1,2805,2804,966,-1,2807,918,917,-1,2807,2806,972,-1,961,2808,2809,-1,956,2810,957,-1,2811,1012,2812,-1,2813,437,1022,-1,967,929,923,-1,2756,2781,2780,-1,929,967,917,-1,247,257,939,-1,350,1038,2814,-1,2815,301,2816,-1,906,1042,910,-1,2817,1034,2818,-1,2819,941,2820,-1,936,2821,2822,-1,2822,2821,398,-1,2823,947,2824,-1,366,2740,367,-1,928,368,929,-1,1023,2825,2826,-1,2827,2828,2829,-1,2830,2831,2832,-1,1005,1004,2744,-1,878,2833,2834,-1,261,273,378,-1,901,911,2823,-1,2835,2836,2837,-1,2818,2838,2839,-1,517,2840,727,-1,2841,892,891,-1,702,733,732,-1,2842,890,805,-1,2843,805,889,-1,892,890,875,-1,2844,2845,2846,-1,2847,2848,2849,-1,2850,2851,872,-1,2850,2852,2851,-1,900,2853,2854,-1,372,2855,373,-1,900,870,2856,-1,870,2849,871,-1,2857,2858,706,-1,2859,705,703,-1,2860,706,705,-1,817,2859,863,-1,716,2861,766,-1,2862,2863,884,-1,856,855,854,-1,847,851,850,-1,2864,2865,2866,-1,2867,2868,2869,-1,2870,2871,759,-1,831,2872,2873,-1,828,827,2874,-1,831,826,828,-1,2875,2876,824,-1,2877,2878,744,-1,700,777,775,-1,2857,2860,816,-1,2879,814,813,-1,2880,680,2881,-1,2882,792,2883,-1,2884,806,805,-1,807,2885,2886,-1,2887,2888,2889,-1,2890,2891,728,-1,795,2892,2887,-1,2888,2893,2894,-1,2894,2895,2896,-1,2897,724,2898,-1,782,2899,783,-1,2899,2900,783,-1,869,716,766,-1,2901,769,2902,-1,768,770,869,-1,767,2903,2904,-1,2902,780,749,-1,2869,867,868,-1,875,2905,2906,-1,2907,820,757,-1,813,2908,2909,-1,750,749,751,-1,743,2910,2911,-1,2912,680,2880,-1,790,791,2913,-1,483,2914,2915,-1,2888,2887,726,-1,702,864,2859,-1,2840,896,728,-1,2898,724,721,-1,899,898,2916,-1,2900,711,783,-1,2900,707,711,-1,2917,2918,714,-1,703,705,704,-1,2919,2918,733,-1,881,858,2920,-1,699,854,2921,-1,807,2922,2885,-1,753,692,697,-1,692,2923,689,-1,735,737,791,-1,690,2924,811,-1,2904,686,688,-1,681,2912,2925,-1,2926,2881,680,-1,686,865,814,-1,2927,682,681,-1,676,675,758,-1,2928,2929,2930,-1,2931,2932,603,-1,2933,2934,474,-1,2935,2936,2937,-1,2938,673,470,-1,2939,542,541,-1,476,470,672,-1,475,2940,2941,-1,1779,2942,2943,-1,315,532,2944,-1,314,2945,331,-1,2946,2947,2948,-1,2949,2950,2951,-1,2952,666,2953,-1,2954,2955,663,-1,2956,2957,2958,-1,2956,638,637,-1,2959,2960,2961,-1,2962,2963,2964,-1,2965,620,627,-1,1750,651,1751,-1,2952,2966,655,-1,2967,2968,665,-1,2969,2970,2971,-1,2950,2972,2973,-1,2943,2942,654,-1,646,645,2951,-1,648,612,651,-1,644,2974,642,-1,2969,2975,2976,-1,2977,2978,634,-1,2979,629,628,-1,2954,633,2980,-1,661,2981,2982,-1,2979,2983,2984,-1,628,627,620,-1,618,620,2965,-1,2985,2986,2987,-1,539,538,2988,-1,613,2989,2990,-1,509,508,611,-1,2991,2941,2940,-1,2992,2993,2933,-1,2994,605,2995,-1,2996,514,2997,-1,2998,2999,519,-1,593,592,3000,-1,3001,3002,554,-1,3003,3004,3005,-1,578,574,498,-1,3006,574,3007,-1,3008,575,3009,-1,3010,3011,3012,-1,3010,3012,582,-1,3013,587,3014,-1,568,3015,507,-1,2999,3016,519,-1,571,565,3007,-1,727,3017,2998,-1,492,3018,561,-1,3019,3020,498,-1,3013,567,586,-1,3021,3017,727,-1,561,512,492,-1,565,563,502,-1,3022,510,512,-1,3023,3024,3025,-1,3026,547,3027,-1,544,3026,3028,-1,3022,3023,546,-1,490,549,482,-1,3029,3030,3031,-1,3032,543,3033,-1,541,3034,327,-1,3035,3036,469,-1,1633,536,535,-1,3037,3038,3039,-1,3040,3041,529,-1,567,523,584,-1,3042,3043,519,-1,558,895,3044,-1,2978,2984,2989,-1,3045,504,513,-1,3011,3010,496,-1,3046,503,3047,-1,596,559,561,-1,512,493,492,-1,493,3048,562,-1,480,484,483,-1,3049,3050,479,-1,473,3051,474,-1,554,553,3052,-1,462,461,1559,-1,1559,461,3053,-1,3054,3055,3056,-1,3057,3058,463,-1,3059,3060,459,-1,243,3061,459,-1,2992,606,608,-1,2994,2995,3062,-1,3063,3064,3065,-1,450,449,3066,-1,3067,2920,858,-1,862,3067,857,-1,862,3068,3069,-1,3070,448,3071,-1,443,3072,444,-1,3073,3074,3075,-1,3076,3077,3078,-1,1030,1029,433,-1,3079,3080,441,-1,3081,438,437,-1,447,446,3082,-1,436,3083,3084,-1,410,996,3085,-1,996,2772,992,-1,430,429,435,-1,426,2743,427,-1,3086,3087,3088,-1,1005,419,420,-1,3089,404,410,-1,992,3089,3085,-1,409,984,432,-1,3089,405,404,-1,861,3090,853,-1,3091,3090,908,-1,400,399,933,-1,1039,300,302,-1,352,1039,3092,-1,934,933,399,-1,293,3093,275,-1,377,388,3094,-1,951,3095,2780,-1,2780,3096,386,-1,1017,392,384,-1,287,286,379,-1,376,951,387,-1,1044,275,382,-1,370,3097,925,-1,928,367,369,-1,365,916,1032,-1,2803,3098,3099,-1,363,3100,3101,-1,362,364,2741,-1,920,3102,3103,-1,2828,3104,3105,-1,954,3106,3107,-1,3092,347,350,-1,3108,3109,3110,-1,1025,3111,3112,-1,323,557,321,-1,542,2939,3113,-1,312,2985,313,-1,318,324,319,-1,316,3114,311,-1,2985,330,3115,-1,3040,3116,3117,-1,2816,255,3118,-1,264,3119,3120,-1,3121,3122,3123,-1,3124,3125,3126,-1,3125,3124,3127,-1,302,301,3128,-1,305,251,250,-1,3129,3130,3131,-1,3129,295,294,-1,3123,3122,3132,-1,287,3131,3130,-1,374,289,379,-1,275,374,286,-1,3131,287,289,-1,269,270,3133,-1,274,3134,262,-1,277,279,3135,-1,3136,3137,958,-1,266,260,269,-1,297,3138,294,-1,3139,3140,259,-1,247,3141,256,-1,2815,3126,3128,-1,251,3142,252,-1,3143,258,3142,-1,239,3144,248,-1,397,2736,300,-1,246,3141,247,-1,888,2834,263,-1,3145,2854,2853,-1,244,459,2994,-1,3146,3147,451,-1,451,3148,3149,-1,2735,2736,3150,-1,3151,3060,3059,-1,3152,3153,3154,-1,3155,3156,3157,-1,230,3158,3159,-1,3160,224,3161,-1,3162,3163,3164,-1,3162,3165,3163,-1,3166,229,3167,-1,3168,237,236,-1,3169,3170,217,-1,3171,3172,3173,-1,3174,211,3175,-1,3176,3177,3178,-1,3179,3180,3181,-1,3182,3183,3184,-1,3173,3172,3185,-1,3186,3187,3175,-1,3188,3189,3190,-1,3191,3192,3193,-1,3194,3195,196,-1,199,3193,3196,-1,189,3197,190,-1,184,187,3198,-1,3199,176,3200,-1,175,3201,3197,-1,3202,168,3203,-1,3204,3205,3206,-1,3203,170,3207,-1,3208,3209,3210,-1,3210,3211,3212,-1,3213,3214,3215,-1,3216,161,3217,-1,3218,154,165,-1,3219,166,3220,-1,162,3221,3222,-1,3223,3224,3225,-1,165,156,3226,-1,163,3222,153,-1,160,3227,3228,-1,3229,3230,3231,-1,3232,3233,3228,-1,153,3234,3235,-1,3236,3237,145,-1,3238,3239,3240,-1,3241,3239,3242,-1,3243,134,3244,-1,3245,3246,3247,-1,3248,3249,3250,-1,3251,3252,138,-1,116,3253,117,-1,3254,127,129,-1,3255,123,3256,-1,119,133,3257,-1,3258,3259,3260,-1,3261,129,128,-1,3262,126,125,-1,3263,3264,3260,-1,116,115,141,-1,3265,3266,3267,-1,3268,3269,3270,-1,109,111,3271,-1,25,3272,3273,-1,3273,3272,3274,-1,3275,3276,3277,-1,3275,3278,3276,-1,3279,3280,3281,-1,3282,3283,3284,-1,97,83,3285,-1,94,3286,3287,-1,3288,3284,3289,-1,3290,3291,3292,-1,3293,3294,3295,-1,3289,3296,3297,-1,3298,3299,82,-1,84,88,85,-1,3285,83,3300,-1,3296,3301,3302,-1,3295,3303,3304,-1,3305,3306,3307,-1,78,3308,79,-1,3309,3310,75,-1,3311,67,69,-1,71,3312,72,-1,39,69,61,-1,3313,3314,3315,-1,3316,3317,3318,-1,3319,3320,3321,-1,3322,3323,44,-1,3324,3325,3326,-1,37,39,60,-1,3327,3328,3329,-1,3330,30,3331,-1,3332,3333,3334,-1,3335,3336,3337,-1,26,3338,3339,-1,3340,3341,3309,-1,3342,3343,11,-1,3344,3345,13,-1,3346,22,21,-1,3347,3345,3348,-1,3349,3350,21,-1,3339,13,20,-1,3308,3351,3352,-1,3353,3354,3355,-1,3356,3357,3358,-1,3359,3360,3356,-1,3359,3356,3358,-1,3357,3361,3358,-1,3362,3363,3364,-1,3364,3365,3362,-1,3353,3366,3354,-1,3308,3270,3351,-1,3339,3367,13,-1,3350,3346,21,-1,3348,23,3347,-1,19,3368,17,-1,22,3369,20,-1,11,3367,3342,-1,3341,3370,3309,-1,3350,3335,3337,-1,3332,3334,16,-1,3371,1,3358,-1,30,3372,3331,-1,3327,3373,3328,-1,3374,37,60,-1,3325,42,3326,-1,43,3322,44,-1,3375,3376,3377,-1,3318,3378,3316,-1,3313,3315,3379,-1,39,61,60,-1,71,64,3312,-1,3311,69,39,-1,3340,3309,75,-1,74,76,3380,-1,78,3268,3308,-1,3307,3381,3305,-1,3382,3295,3304,-1,3296,3302,3297,-1,3300,3383,3285,-1,84,86,88,-1,81,3298,82,-1,3289,3297,3384,-1,3293,3295,3382,-1,3292,3385,3290,-1,3288,3289,3298,-1,94,3386,3286,-1,3285,3387,97,-1,3284,3288,3282,-1,3279,3388,3280,-1,3273,3274,3389,-1,25,24,3272,-1,3271,3390,109,-1,3270,3308,3268,-1,3265,3391,3266,-1,3392,116,141,-1,3260,3393,3263,-1,125,3394,3262,-1,128,3395,3261,-1,3258,3260,3264,-1,3257,120,119,-1,3255,121,123,-1,3254,129,125,-1,138,3396,3397,-1,138,3252,3396,-1,116,3398,3253,-1,3251,3399,3252,-1,3248,3250,130,-1,3245,3247,132,-1,3243,3400,134,-1,3241,3242,3401,-1,3238,3242,3239,-1,3402,3236,145,-1,153,3403,3234,-1,3228,3404,3232,-1,3229,3231,3405,-1,160,3228,3233,-1,163,153,152,-1,165,154,156,-1,3223,3225,3406,-1,3222,163,162,-1,3219,164,166,-1,3218,3407,154,-1,3216,3408,161,-1,3213,3215,3409,-1,3210,3209,3211,-1,3208,3410,3209,-1,3203,3207,3411,-1,3206,3412,3204,-1,3202,3203,3413,-1,3197,193,175,-1,3200,177,3199,-1,184,3198,185,-1,189,191,3197,-1,199,3196,200,-1,3194,3414,3195,-1,3191,3415,3192,-1,3188,3416,3189,-1,3175,3417,3186,-1,3172,3418,3185,-1,3184,3419,3182,-1,3179,3420,3180,-1,3176,3178,3421,-1,3174,3175,3187,-1,3171,3422,3172,-1,3423,3424,3425,-1,3423,3426,3424,-1,3168,221,219,-1,217,216,3169,-1,221,3168,236,-1,238,3166,3167,-1,233,3165,223,-1,3165,3162,223,-1,3160,3161,3427,-1,230,3159,3428,-1,3155,3157,3429,-1,3152,3154,3430,-1,3151,3431,3060,-1,465,580,579,-1,3149,3146,451,-1,910,3432,907,-1,3145,3433,2854,-1,300,249,397,-1,3434,3144,3150,-1,3143,3435,258,-1,254,253,3436,-1,253,3139,3436,-1,3128,301,2815,-1,298,297,294,-1,299,3437,268,-1,268,265,299,-1,269,267,266,-1,3438,3135,3439,-1,274,262,261,-1,1044,284,283,-1,289,291,3131,-1,286,293,275,-1,3440,308,306,-1,3130,304,287,-1,3132,3138,3123,-1,3129,294,3132,-1,3122,3130,3129,-1,3131,295,3129,-1,3128,1040,302,-1,3441,2834,2833,-1,3120,297,264,-1,3122,3129,3132,-1,2815,2816,3118,-1,3040,529,3116,-1,331,312,314,-1,320,315,3040,-1,3442,317,3029,-1,3442,318,317,-1,312,330,2985,-1,323,3039,557,-1,3443,3109,3444,-1,3108,3444,3109,-1,350,352,3092,-1,3445,954,3107,-1,3446,3447,2741,-1,920,3448,3102,-1,2741,3447,362,-1,363,3449,3100,-1,3099,3450,2803,-1,3451,365,1032,-1,368,928,369,-1,370,925,3452,-1,882,390,371,-1,264,263,3119,-1,387,377,376,-1,1017,384,1016,-1,2780,3095,3096,-1,951,376,3095,-1,377,3453,1018,-1,3093,382,275,-1,3106,3454,3107,-1,2821,399,398,-1,352,300,1039,-1,400,933,942,-1,3455,405,3089,-1,3089,410,3085,-1,406,3456,964,-1,420,422,1005,-1,2746,3086,3088,-1,426,415,2743,-1,435,434,430,-1,996,992,3085,-1,3088,431,2746,-1,410,997,996,-1,3082,3457,447,-1,3081,3458,438,-1,441,3459,3079,-1,280,912,3460,-1,1030,433,3072,-1,1012,1030,2812,-1,2841,3461,3462,-1,3463,276,3464,-1,3069,3067,862,-1,862,857,863,-1,3067,858,857,-1,3465,450,3066,-1,1021,3063,3065,-1,2995,3466,3062,-1,608,2993,2992,-1,3050,3467,3468,-1,3469,3470,3471,-1,243,1546,3061,-1,459,3061,3059,-1,3472,3057,463,-1,3056,462,3054,-1,3473,3431,3474,-1,462,1559,3475,-1,467,3476,3477,-1,514,2996,601,-1,3478,2938,3479,-1,2935,3480,3479,-1,479,472,3049,-1,550,3481,489,-1,550,486,3482,-1,545,481,737,-1,562,494,493,-1,512,511,493,-1,498,3483,499,-1,3147,3146,3484,-1,3011,496,495,-1,3010,509,496,-1,513,3485,3045,-1,2978,2989,656,-1,517,727,518,-1,558,3486,895,-1,3042,558,3043,-1,3487,3020,3488,-1,623,527,526,-1,3040,2944,3041,-1,3489,3115,3490,-1,622,530,623,-1,660,3491,622,-1,3037,3039,323,-1,671,670,1630,-1,1633,3492,536,-1,541,543,3034,-1,3032,3034,543,-1,3029,524,3030,-1,482,491,490,-1,3022,3024,3023,-1,3028,485,544,-1,3027,3493,3026,-1,3024,3494,3025,-1,560,3022,512,-1,596,561,3018,-1,563,562,502,-1,3495,3021,727,-1,3496,3013,586,-1,3497,3019,498,-1,3015,568,500,-1,492,494,3018,-1,2998,518,727,-1,573,571,3007,-1,2999,3498,3016,-1,3499,3055,464,-1,507,583,568,-1,3014,566,3013,-1,582,583,3010,-1,3011,3500,3012,-1,575,585,3009,-1,3007,501,3006,-1,567,584,577,-1,574,3483,498,-1,319,3009,585,-1,508,504,611,-1,3005,3501,3003,-1,3001,3502,3002,-1,593,3000,3503,-1,3018,494,562,-1,519,518,2998,-1,2994,604,605,-1,2933,3504,2992,-1,2940,3505,2991,-1,509,611,496,-1,612,615,613,-1,613,616,2989,-1,644,539,2988,-1,2985,2987,3506,-1,2965,3507,618,-1,628,620,495,-1,2979,2984,2978,-1,662,661,2982,-1,633,635,2980,-1,2979,2977,629,-1,2977,2979,2978,-1,3508,2969,2976,-1,644,2988,2974,-1,648,615,612,-1,2973,646,2951,-1,2943,654,3509,-1,2973,2951,2950,-1,2969,2971,647,-1,665,651,2967,-1,2952,655,650,-1,617,2983,2979,-1,1750,2967,651,-1,2965,627,3510,-1,2964,3511,2962,-1,2990,2931,613,-1,2960,3512,2961,-1,637,659,2956,-1,2958,638,2956,-1,633,2954,663,-1,2953,3513,2952,-1,2949,3514,2950,-1,314,528,2945,-1,2944,3040,315,-1,1779,643,2942,-1,2938,3478,673,-1,475,2941,3515,-1,476,672,477,-1,2939,541,3035,-1,3516,674,3517,-1,3516,3518,674,-1,673,471,470,-1,2933,2993,2934,-1,603,3519,2931,-1,468,467,3520,-1,2928,2930,3521,-1,757,676,758,-1,681,3522,743,-1,680,3523,2926,-1,2925,3522,681,-1,791,3524,735,-1,2883,3525,694,-1,692,753,2923,-1,3526,685,684,-1,884,2863,880,-1,2919,733,702,-1,704,701,703,-1,3527,766,2861,-1,2917,3528,2918,-1,898,2929,2916,-1,721,3529,2892,-1,3529,724,2887,-1,724,3529,721,-1,2919,714,2918,-1,2859,703,702,-1,3530,2888,726,-1,2915,799,483,-1,791,737,2913,-1,743,742,2910,-1,749,748,751,-1,752,3531,2923,-1,686,814,687,-1,3532,687,814,-1,2909,2879,813,-1,756,2907,757,-1,684,867,3526,-1,2869,868,3533,-1,2902,749,809,-1,2903,865,2904,-1,869,779,768,-1,809,2901,2902,-1,869,766,765,-1,2898,847,2897,-1,795,722,2892,-1,2894,2889,2888,-1,790,2913,483,-1,2892,3529,2887,-1,728,2895,2890,-1,3534,2884,805,-1,792,695,2883,-1,2879,3532,814,-1,2857,816,819,-1,700,775,698,-1,860,3535,761,-1,861,860,822,-1,824,3536,2875,-1,823,3536,824,-1,830,828,2874,-1,832,831,2873,-1,2870,759,3537,-1,2869,3332,2867,-1,2866,786,2864,-1,848,847,850,-1,692,3525,697,-1,3068,448,3069,-1,3068,3071,448,-1,2859,864,863,-1,2860,2857,706,-1,2859,2860,705,-1,2857,818,2858,-1,870,887,2849,-1,900,885,870,-1,372,3538,2855,-1,900,2856,2853,-1,2849,887,2847,-1,882,888,390,-1,890,2842,875,-1,807,2842,805,-1,702,732,864,-1,2928,2916,2929,-1,2839,883,2818,-1,901,2823,902,-1,277,3135,3438,-1,2834,888,878,-1,2744,414,1005,-1,948,3539,3540,-1,2830,2832,3541,-1,2826,1024,1023,-1,3542,1036,3543,-1,368,923,929,-1,366,3544,2740,-1,2823,911,947,-1,3545,927,926,-1,936,2822,1041,-1,2819,2814,941,-1,2817,1035,1034,-1,1042,946,910,-1,2814,351,350,-1,939,393,247,-1,916,929,917,-1,2780,386,2756,-1,967,923,922,-1,437,3084,1022,-1,2811,1011,1012,-1,2809,956,961,-1,965,2807,972,-1,2804,2807,917,-1,3546,2805,966,-1,2804,2806,2807,-1,2801,2803,3547,-1,3546,2798,2800,-1,2794,2796,1031,-1,3548,971,3549,-1,2791,962,2792,-1,2777,424,976,-1,2790,3550,2764,-1,2786,963,2787,-1,2785,422,421,-1,980,979,2783,-1,2769,3551,1000,-1,952,951,2780,-1,2775,2751,2773,-1,989,2772,990,-1,3552,3553,2790,-1,978,2767,2768,-1,988,2766,3554,-1,3555,401,2764,-1,419,3548,974,-1,970,3556,443,-1,956,2809,2761,-1,969,3557,2760,-1,385,2756,386,-1,3558,3559,3560,-1,3561,3562,2759,-1,2753,1014,1028,-1,1013,2755,2752,-1,3563,2808,1011,-1,2806,444,972,-1,409,408,984,-1,2750,2773,2751,-1,417,412,2744,-1,1035,3564,1036,-1,2742,3545,2741,-1,2740,396,2738,-1,1037,3565,400,-1,393,940,2737,-1,348,3565,1037,-1,276,283,3464,-1,2729,3566,2732,-1,2729,2731,3566,-1,2728,3567,2727,-1,2725,3568,2726,-1,1058,2724,1059,-1,1071,1070,2723,-1,1079,2722,3569,-1,1069,3570,1067,-1,1072,1061,1070,-1,1163,1162,1066,-1,2715,2717,2723,-1,2713,1084,3571,-1,2714,3572,2712,-1,2711,3573,2709,-1,2708,3574,2691,-1,1091,2704,1092,-1,2702,3575,2703,-1,2700,3576,2701,-1,3577,3578,3579,-1,2695,3580,2696,-1,2693,2698,2691,-1,2689,3581,2690,-1,2683,2682,2686,-1,2685,3582,1110,-1,2682,2684,2674,-1,2680,3583,2681,-1,1111,2679,1115,-1,2676,1112,1114,-1,2675,2728,2673,-1,1119,1078,1120,-1,1116,1119,3584,-1,3585,3586,3587,-1,3585,3588,3586,-1,1139,3589,3590,-1,1139,3591,3589,-1,1134,1133,1136,-1,2670,3592,2671,-1,2669,3593,2667,-1,2666,3594,2664,-1,2663,3595,2662,-1,2661,2658,3596,-1,2658,3597,2659,-1,3598,3599,3600,-1,1171,1173,1178,-1,2653,3601,2651,-1,2650,1168,2636,-1,2649,1178,1177,-1,3602,1184,2641,-1,2646,3603,2647,-1,1176,1193,2645,-1,1182,3604,2642,-1,2640,1199,3605,-1,1183,1204,1200,-1,2636,1168,2637,-1,1169,2635,1170,-1,2634,1198,3606,-1,2632,3607,2633,-1,2629,3608,2630,-1,2628,1216,1218,-1,1219,1231,3609,-1,2626,1228,1230,-1,2624,1239,1235,-1,2621,2623,3610,-1,1251,1250,2620,-1,2618,3611,2619,-1,2614,2601,1262,-1,1264,1266,2610,-1,1265,2608,2606,-1,1266,2607,3612,-1,1267,3613,2605,-1,1259,3614,1268,-1,2601,2603,3615,-1,2600,2610,2598,-1,2597,2605,1273,-1,2596,1271,3616,-1,2594,3617,2595,-1,2591,2595,2592,-1,3618,2588,2590,-1,1283,1296,2587,-1,2583,1295,2584,-1,3619,3620,3621,-1,3619,3622,3620,-1,2580,3623,2581,-1,3624,3625,2578,-1,1299,3626,2579,-1,1310,2578,3625,-1,2566,1303,2578,-1,2575,2577,2569,-1,2573,3627,2574,-1,3628,2570,2571,-1,2560,3629,1306,-1,2569,3629,2560,-1,1308,2567,3630,-1,2566,1310,2564,-1,1311,3631,2563,-1,2562,3626,2560,-1,2559,3632,1305,-1,3633,3634,3635,-1,2470,243,3636,-1,2493,3637,2494,-1,3635,1333,2491,-1,2551,2553,3638,-1,2550,1342,1341,-1,2493,3639,3640,-1,2551,3641,2552,-1,1361,1360,1355,-1,1350,1353,1442,-1,1351,1356,1352,-1,3642,1355,2215,-1,1980,2501,2541,-1,2549,1370,1374,-1,3643,3644,3645,-1,3646,2214,2213,-1,2545,1364,1363,-1,1371,2538,1368,-1,1369,2131,1374,-1,2538,1371,2543,-1,1352,1356,2476,-1,1348,1347,1378,-1,1388,3647,1349,-1,1353,3647,1388,-1,1463,1346,1461,-1,1375,1368,2538,-1,3648,3638,3649,-1,2535,1375,2533,-1,2532,1395,2456,-1,1777,3650,3651,-1,1395,1397,1778,-1,1398,1400,3652,-1,1778,1397,2530,-1,1629,3653,1404,-1,2524,1399,2525,-1,1634,2527,2522,-1,2531,3651,1393,-1,1504,2475,2478,-1,3654,3655,3656,-1,2518,2520,3657,-1,2517,3658,2515,-1,2514,3659,2512,-1,2137,2130,1415,-1,1413,2198,2008,-1,2510,2114,3660,-1,2505,2112,2114,-1,2509,3661,2507,-1,2506,3662,2112,-1,1424,1426,1423,-1,2503,1435,2504,-1,1948,1439,1441,-1,2502,2131,1360,-1,1444,2153,1453,-1,1980,1979,1457,-1,2500,1371,1456,-1,2498,1456,1455,-1,1450,1449,2100,-1,1454,3663,1445,-1,2496,1351,1350,-1,2127,2493,1448,-1,1462,1415,2130,-1,2137,1415,1414,-1,1464,1997,2216,-1,2129,1999,1997,-1,1997,2130,2129,-1,1466,1458,1999,-1,2089,2178,2177,-1,1473,1472,2186,-1,1480,2490,2489,-1,1983,1483,1984,-1,2140,1494,2109,-1,1983,2488,1481,-1,1982,1488,2488,-1,2045,3664,1496,-1,1493,1495,2057,-1,2486,1497,1502,-1,1475,1477,1510,-1,1507,3665,1508,-1,3666,1506,2483,-1,2480,2482,3667,-1,2022,1518,2479,-1,1519,2158,2479,-1,3668,3669,2185,-1,3670,3671,1532,-1,3672,1964,1963,-1,1521,1525,1530,-1,3673,3674,3675,-1,3676,1571,2356,-1,1324,2467,1322,-1,1551,1554,1553,-1,1553,1552,1551,-1,2469,2467,1324,-1,1688,1687,1550,-1,1796,1562,3677,-1,3678,1783,2361,-1,1791,3679,1572,-1,2398,1781,1703,-1,2464,1572,3680,-1,1642,1578,1580,-1,1579,1645,1580,-1,2447,1644,1573,-1,1586,1585,1587,-1,2395,1597,1596,-1,2435,1590,1592,-1,2459,1656,1685,-1,1600,2396,2403,-1,1707,1706,1673,-1,1589,1588,3681,-1,1706,1600,3682,-1,1565,3683,1582,-1,1612,1606,1608,-1,2438,3684,2412,-1,2423,1640,2421,-1,2456,1618,1617,-1,1620,1777,1776,-1,3685,2452,1624,-1,3685,1621,2452,-1,1621,2453,2452,-1,1404,3686,2360,-1,2448,1632,535,-1,540,539,1709,-1,1635,1403,1785,-1,1580,1645,2445,-1,2447,2463,1576,-1,1643,1642,2445,-1,2442,1644,1643,-1,2439,2360,2359,-1,2438,1610,3684,-1,1657,1654,3687,-1,2410,2433,1584,-1,2436,3687,1654,-1,2429,2421,1675,-1,1592,1664,1671,-1,2433,1699,1698,-1,1655,2433,2434,-1,1683,1667,2431,-1,1667,1668,2431,-1,1683,2432,3688,-1,3689,3690,1552,-1,1678,1672,1671,-1,1682,1681,2422,-1,1660,3691,2430,-1,2426,1212,2427,-1,2424,3692,2425,-1,1694,1693,2417,-1,2416,2418,3693,-1,2415,2467,1555,-1,2411,2438,2412,-1,2408,2410,2461,-1,1680,3694,2413,-1,2413,2412,1680,-1,2457,1612,1608,-1,1563,3695,2407,-1,2404,3696,2405,-1,1792,3697,1696,-1,2402,3698,2401,-1,1536,2358,2400,-1,1782,2399,2364,-1,2397,1597,2395,-1,1735,2393,2394,-1,2394,2376,3699,-1,2396,2395,3700,-1,2370,2389,1627,-1,1714,2391,3701,-1,1715,2370,1713,-1,3702,1757,2390,-1,2388,3703,2389,-1,1725,1716,1753,-1,1753,2384,2386,-1,1723,1727,1766,-1,2383,1762,3704,-1,1391,2382,1637,-1,3705,3706,1748,-1,1748,3707,3705,-1,1745,1746,2369,-1,1738,1737,2378,-1,2367,1736,2375,-1,1746,1734,1736,-1,1740,3708,2377,-1,2376,1604,1603,-1,2454,1622,1738,-1,1738,1743,2454,-1,2390,2373,1617,-1,1762,1761,2372,-1,1727,1765,1766,-1,2370,3709,1752,-1,1746,2367,2369,-1,2365,3710,1768,-1,1778,3685,1618,-1,1596,1716,2395,-1,1733,3711,1739,-1,2364,671,1631,-1,1780,1781,1789,-1,1403,1637,2382,-1,1403,1635,1637,-1,1790,1783,1567,-1,1790,1784,1783,-1,1787,2360,3712,-1,2356,2358,1536,-1,2355,3713,3714,-1,2353,1906,2348,-1,1805,1809,1808,-1,1940,3715,2278,-1,2348,1861,1863,-1,3716,3717,3718,-1,1812,3719,1816,-1,2345,1823,1911,-1,1826,1828,2344,-1,3720,1944,1830,-1,2341,1829,1831,-1,2274,3721,2342,-1,2340,1833,3722,-1,1831,3723,3721,-1,3724,3725,3726,-1,1958,3727,3728,-1,1841,1846,2311,-1,2336,2294,2342,-1,1832,1827,1955,-1,1812,2333,3729,-1,1860,2328,2291,-1,2332,1804,1803,-1,2330,3730,1914,-1,2328,2288,2306,-1,1817,1860,2290,-1,1858,1872,1859,-1,2355,1801,1914,-1,3731,3732,3733,-1,3733,2331,3731,-1,1800,2283,2327,-1,2325,3734,2326,-1,2324,3720,1830,-1,2323,2326,2284,-1,1885,2322,1883,-1,2315,2320,2316,-1,2318,3735,2319,-1,1912,2319,1933,-1,2317,1888,1890,-1,2316,1878,1877,-1,2244,2273,2312,-1,2275,1893,2313,-1,2311,2254,1894,-1,2309,2289,2291,-1,1854,3736,2299,-1,1905,2289,1936,-1,2328,2306,2308,-1,1849,2303,2305,-1,1851,2301,3737,-1,2298,3738,2299,-1,2295,3739,2255,-1,2293,2342,2294,-1,2289,2346,2290,-1,1877,1887,2287,-1,2246,1862,1865,-1,1908,2318,1912,-1,1917,1868,2283,-1,2282,2235,3740,-1,2275,2312,2273,-1,2269,1922,1923,-1,2271,1926,3741,-1,2272,3742,1924,-1,3741,3743,1929,-1,2262,2726,2270,-1,2269,2270,2267,-1,2264,3744,2265,-1,2261,2726,2262,-1,3733,3732,2263,-1,1884,1883,2256,-1,2253,2255,3739,-1,1895,1894,2251,-1,3745,1938,1937,-1,1917,1802,1470,-1,1822,1821,2250,-1,1526,1943,1941,-1,2249,1527,1941,-1,1917,1471,1918,-1,1523,2335,1965,-1,3746,1880,2246,-1,2244,1890,1889,-1,1947,1951,2243,-1,3747,2240,2242,-1,1981,2539,1953,-1,3748,1824,2241,-1,2241,1972,2005,-1,2239,2237,1948,-1,2236,2240,1948,-1,2496,1440,1439,-1,2234,2233,2241,-1,1947,2217,2222,-1,1954,2230,1441,-1,1960,1963,1962,-1,2239,1961,1967,-1,3749,2224,2225,-1,1583,1836,2223,-1,2222,1978,1952,-1,2219,3750,2220,-1,1467,1325,1327,-1,1976,2222,2217,-1,1327,1978,1977,-1,3646,2213,3751,-1,2215,1354,1439,-1,2212,3752,1384,-1,2011,1431,1430,-1,1421,2211,2193,-1,2117,1995,2014,-1,3753,3754,1436,-1,1431,1994,1432,-1,2117,2118,3755,-1,2122,1460,1459,-1,2003,2123,3756,-1,2126,3757,2127,-1,1466,2125,2203,-1,2111,2149,2202,-1,1998,2136,1327,-1,3648,2500,3638,-1,2194,2492,2199,-1,2198,1461,1333,-1,2065,1443,2197,-1,2141,2109,2194,-1,3758,2020,3759,-1,2189,2190,3760,-1,1484,2052,2021,-1,2015,3761,2187,-1,1486,2052,1484,-1,2096,3762,2185,-1,2037,2488,1488,-1,2184,2021,2052,-1,1487,2044,2182,-1,2164,1500,1499,-1,2143,2039,2183,-1,2182,2073,2181,-1,2058,2179,2175,-1,2176,2178,1476,-1,3763,2058,2084,-1,2173,3764,2174,-1,2085,2486,1501,-1,3765,2169,2171,-1,2167,1479,2074,-1,2166,1500,2164,-1,2162,2084,2083,-1,1982,3766,2054,-1,1519,2092,2158,-1,2158,2160,2479,-1,3767,3768,2106,-1,2146,2019,2018,-1,3769,2148,2103,-1,2155,2190,2156,-1,2153,2020,2154,-1,2150,2152,2544,-1,2202,2149,1533,-1,1991,3770,2016,-1,3771,2521,1409,-1,2104,2108,2103,-1,1510,2041,2146,-1,2075,2074,2142,-1,2196,2139,2141,-1,2110,2138,3772,-1,3756,3773,3774,-1,3775,1345,1344,-1,2135,2136,2002,-1,2546,2548,3776,-1,2544,3776,2150,-1,2132,2134,3777,-1,3778,1363,2549,-1,2124,2130,2137,-1,2099,2127,2100,-1,1466,2129,2124,-1,2120,1996,2121,-1,1422,1416,2115,-1,2112,3779,2113,-1,1984,1483,2109,-1,1492,3780,1501,-1,3781,2193,2211,-1,1476,2178,1477,-1,2021,2184,1518,-1,2157,2018,3782,-1,2107,2101,2103,-1,2104,2148,2105,-1,3783,3784,3785,-1,3786,3787,3788,-1,1449,2012,2099,-1,2097,2012,3789,-1,3783,3790,3791,-1,2092,2147,2095,-1,2020,2153,2093,-1,2158,2092,2159,-1,2090,2038,1488,-1,2047,2089,3792,-1,2085,2087,2173,-1,2082,2084,2175,-1,2164,2062,2165,-1,2073,2167,2074,-1,2070,2072,3793,-1,2067,2069,3794,-1,2013,1452,2065,-1,2062,2064,2165,-1,2057,2179,2058,-1,2053,1489,2054,-1,2050,2052,2186,-1,2049,3795,2047,-1,2046,2182,2044,-1,2043,3796,2041,-1,2035,2183,2039,-1,2033,2035,2040,-1,2096,3797,3762,-1,2030,2032,2027,-1,2028,2029,3798,-1,2023,2026,2024,-1,3761,2024,2027,-1,2025,2023,2024,-1,2021,2023,2188,-1,2020,2094,2018,-1,3758,2154,2020,-1,2016,1506,3799,-1,2014,1995,1994,-1,2012,1449,1452,-1,2011,2015,1994,-1,1414,2008,2010,-1,3800,1346,1345,-1,1327,2136,2006,-1,1972,2138,2004,-1,2002,2001,2000,-1,3754,3753,2115,-1,1997,1977,2216,-1,1433,1482,3801,-1,1995,1435,1434,-1,2205,2110,3772,-1,1993,3770,1991,-1,1985,2208,1986,-1,3802,3803,2200,-1,1984,3766,1982,-1,1385,1981,1954,-1,1359,1358,3645,-1,1976,2216,1977,-1,1970,1972,2233,-1,1799,1834,3804,-1,1965,2335,1966,-1,1960,1959,1820,-1,3747,1959,1961,-1,1955,1957,1832,-1,1953,1945,2232,-1,1952,3805,1328,-1,1948,2237,1949,-1,2231,1945,1947,-1,1844,1944,1909,-1,1944,3720,1910,-1,1526,1965,1845,-1,1830,1829,1889,-1,2234,3806,2280,-1,1521,1520,1942,-1,1815,1813,1816,-1,1939,3807,1893,-1,1937,1895,2252,-1,1936,2309,1934,-1,1933,3808,1081,-1,3809,1930,1932,-1,1927,1929,3743,-1,1926,2271,1924,-1,2271,3741,1929,-1,1921,1922,1919,-1,3810,1868,1918,-1,2235,1918,1471,-1,2282,3810,1918,-1,1913,2345,1911,-1,1908,2285,1909,-1,1862,1864,1866,-1,1814,1905,3811,-1,2229,1818,1820,-1,2338,1847,1840,-1,1901,2227,1902,-1,1897,1840,1838,-1,1847,2338,1898,-1,3812,1903,1898,-1,1895,1842,1841,-1,2275,1891,1893,-1,1888,1830,1889,-1,1886,2322,1887,-1,1884,1890,1885,-1,2284,1880,1882,-1,1879,1887,1877,-1,1874,3813,1875,-1,3814,1875,2350,-1,2315,1871,1873,-1,2242,3815,3747,-1,2283,1868,1870,-1,1865,1867,3816,-1,1907,1808,1809,-1,1855,3817,1856,-1,1853,1854,1900,-1,1852,2462,1579,-1,3737,1848,1850,-1,1846,1847,2303,-1,1826,1845,1965,-1,1901,3749,1969,-1,1842,1839,1838,-1,1834,1799,1835,-1,2275,2293,1891,-1,2275,2274,2293,-1,1833,1843,1827,-1,1944,1844,2344,-1,2344,2343,1944,-1,1826,1966,1827,-1,2241,3806,2234,-1,2350,2250,3814,-1,1811,1854,1577,-1,3818,1873,2248,-1,2348,1863,2284,-1,1804,2245,1809,-1,1806,1808,1906,-1,1862,1880,1863,-1,1805,2352,3819,-1,1800,1802,2283,-1,1797,1799,3804,-1,1794,3697,1792,-1,1791,3676,1535,-1,1783,3678,1788,-1,1787,3712,1402,-1,1786,3820,1636,-1,1784,2398,1782,-1,1704,1703,1781,-1,1788,1568,1567,-1,1742,1741,1779,-1,1621,3685,1778,-1,2531,1775,1777,-1,3821,1769,1771,-1,1767,3822,1768,-1,1765,3823,1724,-1,1764,3824,1760,-1,1762,1763,1760,-1,3825,1757,1759,-1,2394,1793,3826,-1,1756,2371,1754,-1,1753,1714,1713,-1,1734,3827,1750,-1,1728,1718,3700,-1,1747,2375,1748,-1,1745,3827,1734,-1,1743,2378,1744,-1,3828,1740,1742,-1,3821,1737,1739,-1,1735,3699,1736,-1,1733,1708,644,-1,1729,1731,2381,-1,1727,1717,1728,-1,1726,1728,1716,-1,1723,1766,1724,-1,3829,1719,1721,-1,1717,1718,1728,-1,1714,1753,1716,-1,1714,3701,1715,-1,1710,1712,1394,-1,1708,539,644,-1,2394,3699,1735,-1,1597,2397,1706,-1,1703,1705,3830,-1,1701,1702,3831,-1,3683,1565,1564,-1,1666,1606,1612,-1,1686,3832,1695,-1,1694,3833,1692,-1,1689,1691,3834,-1,1688,3835,1686,-1,2397,1600,1706,-1,1681,1680,1398,-1,1592,1683,3688,-1,2430,2422,2429,-1,1667,1683,1685,-1,1680,1682,3694,-1,1677,1679,1599,-1,1677,1599,1672,-1,1674,1661,1675,-1,1673,3836,1671,-1,2468,3690,3689,-1,1612,3837,1669,-1,1655,2434,1668,-1,1607,1606,1666,-1,1657,1586,1587,-1,2435,1671,3836,-1,1592,1615,1663,-1,1660,2429,1661,-1,1658,3838,1659,-1,1584,2433,1655,-1,1665,1657,2461,-1,1589,3681,1653,-1,1650,1652,3839,-1,1649,3840,1647,-1,1647,2445,1645,-1,1644,2447,1642,-1,1639,2374,1640,-1,1635,2523,1638,-1,1634,2523,1635,-1,2361,3841,3820,-1,1632,3842,1633,-1,1406,3843,1628,-1,1620,2455,1621,-1,2422,2421,2429,-1,1612,2457,1611,-1,1609,2224,1610,-1,1603,1605,1717,-1,1602,3682,1600,-1,1597,1707,1599,-1,2460,2459,3844,-1,1657,3687,2461,-1,1587,1585,1588,-1,1584,2458,1585,-1,1583,2223,1581,-1,1577,1576,2463,-1,1575,3845,3729,-1,1577,1853,1578,-1,1572,2465,1540,-1,1791,3846,3679,-1,3847,2441,1689,-1,1558,1554,1551,-1,3053,1554,1559,-1,1555,3848,1553,-1,1552,3690,1550,-1,1556,1547,1549,-1,1546,243,1544,-1,1702,1535,1537,-1,1534,3670,1532,-1,1529,2473,1530,-1,1528,1824,1524,-1,1527,1524,1523,-1,1525,1942,1523,-1,3778,2549,3849,-1,3850,3851,1968,-1,3852,1511,2146,-1,1509,2485,1510,-1,3853,3751,2213,-1,1506,3666,1507,-1,1505,3854,1503,-1,2017,3855,2483,-1,1500,2166,1480,-1,1478,1479,1500,-1,1497,2486,1498,-1,1494,2140,1495,-1,1502,1490,1492,-1,1488,1982,1489,-1,1482,2492,1483,-1,1480,1472,1474,-1,1474,1473,2142,-1,1465,1459,1458,-1,1462,1464,1461,-1,1999,1458,2000,-1,3856,3857,2511,-1,1369,1366,1381,-1,1371,1370,1455,-1,3663,2497,1445,-1,1452,1451,1444,-1,1451,1452,1449,-1,1446,1448,2155,-1,1373,1372,1368,-1,1443,1445,2197,-1,1455,1370,1365,-1,2504,1436,1438,-1,2503,1433,1435,-1,1430,1432,3858,-1,1429,3859,1427,-1,1424,3860,1425,-1,1417,1416,1422,-1,1420,3861,1421,-1,3862,2144,1989,-1,1415,1462,1413,-1,1410,1412,3863,-1,1412,1411,3864,-1,1404,1406,1629,-1,1401,1403,2382,-1,3865,1786,1785,-1,3652,1400,2529,-1,1641,3652,2529,-1,1389,1778,2530,-1,1777,3651,2531,-1,1391,1620,1389,-1,1349,2537,1387,-1,1377,1380,2536,-1,1344,3866,3775,-1,3867,3775,3866,-1,1463,1382,1346,-1,3638,2553,3649,-1,1381,1366,1376,-1,1378,1380,1377,-1,1376,1366,1368,-1,3648,2534,2542,-1,1372,1374,1370,-1,3868,3642,2215,-1,1360,1362,2502,-1,1358,3643,3645,-1,3760,3869,2189,-1,1354,2215,1355,-1,1347,1349,3647,-1,3641,3870,1343,-1,3640,3871,2493,-1,1346,1383,1344,-1,2551,1337,2553,-1,1337,2552,1338,-1,2491,1335,3635,-1,1333,1461,1331,-1,2493,3871,3637,-1,1442,1385,1954,-1,1328,3805,1329,-1,3872,1544,2470,-1,1334,1331,2128,-1,1321,3873,1319,-1,1316,1318,3874,-1,1313,3875,1314,-1,3876,1304,2577,-1,3876,2559,1304,-1,1310,1312,2564,-1,1308,3630,1309,-1,3629,1304,1306,-1,1301,1308,1302,-1,1300,3877,1298,-1,2578,1303,1302,-1,3878,3619,3879,-1,3878,3880,3619,-1,1296,1297,3881,-1,1295,2583,1282,-1,1294,3882,1292,-1,1289,1291,3883,-1,1288,3884,1286,-1,1283,1285,1296,-1,1280,3885,1281,-1,1277,1279,3886,-1,1270,1276,3887,-1,1272,1274,3888,-1,1269,3889,1270,-1,1267,1268,3613,-1,1265,2606,1266,-1,1263,2615,1261,-1,1260,3890,1258,-1,1255,1251,1256,-1,1252,1254,3891,-1,1249,3892,1250,-1,1247,3893,1248,-1,1243,1245,3894,-1,1240,3895,1241,-1,1237,2625,1238,-1,1234,2624,1235,-1,1231,3896,1232,-1,1228,3897,1229,-1,1225,1218,1226,-1,3898,1222,1224,-1,1221,3899,1219,-1,1217,3900,1218,-1,3901,1228,2626,-1,3901,3902,1228,-1,3903,1213,1215,-1,1211,1210,1209,-1,1208,1210,3904,-1,1205,3905,1206,-1,1204,3906,1202,-1,1199,1201,3907,-1,1197,3908,1198,-1,1169,2650,1194,-1,1176,3909,1192,-1,1189,1191,3910,-1,1188,2646,1186,-1,1185,2639,1183,-1,1181,3604,1182,-1,1179,3909,1177,-1,1176,2644,1174,-1,1172,3911,1173,-1,1170,3912,1168,-1,1167,1057,1056,-1,1164,3913,1165,-1,1161,1160,1162,-1,1158,1160,1161,-1,1155,1157,3914,-1,1152,1154,3915,-1,1148,3916,1150,-1,1134,2665,1149,-1,1141,1148,1151,-1,1147,3917,1145,-1,1139,1141,3591,-1,1137,2671,1138,-1,1135,3918,1133,-1,1143,1130,1132,-1,1127,1129,3919,-1,1124,1126,3920,-1,1121,1057,1122,-1,1116,1076,1078,-1,1091,1115,2704,-1,1112,2680,1113,-1,1109,1111,1091,-1,1106,1108,3921,-1,1105,3922,1103,-1,1100,3578,1101,-1,3923,2688,3924,-1,1094,2702,1095,-1,1109,1091,1093,-1,1089,3925,1090,-1,1085,1087,3926,-1,1082,1084,3927,-1,1050,3566,3928,-1,1081,2721,1079,-1,1060,2715,2723,-1,1076,3929,1077,-1,1075,1059,1073,-1,1058,1064,3930,-1,1061,1072,3931,-1,1066,3932,1064,-1,1061,3931,1062,-1,1060,1070,1058,-1,1055,3933,1056,-1,3934,3935,3936,-1,3935,3937,3936,-1,1050,1054,1051,-1,1051,3938,1052,-1,1044,383,3939,-1,1041,946,1042,-1,3126,2815,3124,-1,3940,3941,937,-1,1036,3542,1034,-1,416,415,1033,-1,2828,3942,3104,-1,1012,2791,1029,-1,970,2760,3556,-1,1013,1028,1014,-1,3063,1021,943,-1,1020,3943,1019,-1,1018,2810,956,-1,1016,960,959,-1,1011,2808,961,-1,1007,2762,442,-1,422,2785,1004,-1,1003,2767,1001,-1,3944,3945,3946,-1,1000,3947,998,-1,997,2769,995,-1,994,3948,992,-1,990,3949,991,-1,988,434,986,-1,408,403,985,-1,978,3950,979,-1,974,3951,977,-1,974,976,420,-1,973,2787,963,-1,3548,419,971,-1,970,3952,968,-1,963,2786,406,-1,3953,966,922,-1,972,963,965,-1,961,956,955,-1,958,960,3136,-1,1044,3939,284,-1,921,3103,3954,-1,954,949,417,-1,953,387,951,-1,249,300,950,-1,948,395,394,-1,910,947,911,-1,944,3564,945,-1,2820,941,942,-1,938,2821,936,-1,365,928,916,-1,3955,3543,3956,-1,2832,2831,3957,-1,922,924,932,-1,921,2747,919,-1,1032,916,918,-1,913,2833,914,-1,281,280,3538,-1,371,267,269,-1,901,3432,910,-1,2823,1039,1040,-1,886,885,902,-1,906,910,907,-1,903,3958,904,-1,900,902,885,-1,897,899,3959,-1,894,3044,895,-1,2891,729,728,-1,2886,3960,807,-1,876,878,888,-1,2849,2848,871,-1,885,887,870,-1,822,884,883,-1,874,873,882,-1,3961,2855,3538,-1,881,2920,879,-1,876,2847,877,-1,2906,873,875,-1,872,2856,870,-1,869,770,717,-1,2925,3532,2879,-1,815,865,3962,-1,690,689,2923,-1,864,732,862,-1,860,853,821,-1,856,857,859,-1,817,863,857,-1,685,2921,854,-1,849,2897,847,-1,802,784,846,-1,845,768,779,-1,840,755,754,-1,840,833,9,-1,837,3963,838,-1,834,825,835,-1,834,9,833,-1,829,3964,828,-1,833,823,825,-1,781,783,711,-1,3965,3966,3967,-1,3968,2862,3969,-1,822,860,761,-1,757,821,676,-1,2904,865,686,-1,774,819,698,-1,818,2857,819,-1,3970,813,815,-1,810,3971,811,-1,809,749,750,-1,740,696,785,-1,720,719,708,-1,806,2922,807,-1,3972,802,804,-1,788,801,3973,-1,799,3974,797,-1,3975,793,739,-1,2864,786,792,-1,787,738,785,-1,2897,784,724,-1,3976,782,781,-1,3977,781,717,-1,771,747,749,-1,869,765,779,-1,2868,776,777,-1,776,773,775,-1,772,812,747,-1,769,2901,770,-1,2904,763,767,-1,765,706,2858,-1,762,764,3978,-1,761,3979,759,-1,3980,756,758,-1,755,2910,742,-1,744,675,677,-1,3531,3981,2923,-1,752,2923,753,-1,739,794,750,-1,746,2877,744,-1,741,743,3522,-1,739,752,740,-1,486,736,694,-1,2845,2918,3528,-1,708,719,730,-1,727,2840,728,-1,726,2887,724,-1,2894,796,2889,-1,721,2892,722,-1,3982,3983,2844,-1,3984,3985,3986,-1,709,3987,3527,-1,713,2917,714,-1,707,709,711,-1,3527,2861,712,-1,706,766,704,-1,701,2919,702,-1,699,2921,700,-1,3525,692,694,-1,3988,3989,3990,-1,687,3991,688,-1,3965,3992,855,-1,680,2912,681,-1,2925,2879,3993,-1,676,853,678,-1,674,556,3517,-1,3478,553,673,-1,671,609,669,-1,497,628,495,-1,315,311,527,-1,3994,666,668,-1,664,3995,649,-1,662,3491,660,-1,658,637,2962,-1,646,3490,657,-1,616,656,2989,-1,654,2942,652,-1,649,651,665,-1,655,648,650,-1,2971,645,647,-1,664,665,2968,-1,2966,639,641,-1,3996,3508,3997,-1,3508,2976,3997,-1,638,3998,636,-1,634,2978,635,-1,632,3510,627,-1,630,627,629,-1,3999,624,626,-1,4000,621,623,-1,2965,4001,3507,-1,619,495,620,-1,2984,2983,4002,-1,614,2393,612,-1,497,496,506,-1,609,477,672,-1,606,4003,607,-1,604,3473,581,-1,603,2932,505,-1,2996,599,601,-1,517,519,3043,-1,3472,2414,3057,-1,3472,2415,2414,-1,595,4004,591,-1,3467,4005,3468,-1,4006,4005,3484,-1,591,4004,592,-1,580,4007,590,-1,587,589,4008,-1,577,4009,586,-1,3006,3483,574,-1,575,577,584,-1,582,4010,568,-1,579,581,3473,-1,3056,3055,3499,-1,578,4011,572,-1,575,4012,576,-1,573,3007,574,-1,569,563,565,-1,570,564,563,-1,568,3497,498,-1,566,567,3013,-1,501,3007,565,-1,564,3018,562,-1,560,512,561,-1,521,3486,558,-1,556,533,557,-1,552,549,490,-1,549,548,544,-1,546,3023,547,-1,545,491,482,-1,544,485,484,-1,542,4013,543,-1,535,537,2448,-1,4014,2975,4015,-1,321,557,533,-1,4016,531,3491,-1,2975,657,4015,-1,529,3041,528,-1,527,311,310,-1,525,585,584,-1,558,3044,3043,-1,516,2997,514,-1,506,611,504,-1,495,619,3011,-1,3047,503,3048,-1,564,596,3018,-1,2913,480,483,-1,485,2914,483,-1,484,480,482,-1,737,736,545,-1,478,479,4017,-1,2940,475,477,-1,467,4018,3476,-1,3472,579,2415,-1,465,3472,463,-1,462,3056,460,-1,579,3472,465,-1,4019,3049,2934,-1,455,242,244,-1,450,3069,448,-1,805,2843,4020,-1,3064,4021,3065,-1,3952,4022,4023,-1,444,1006,442,-1,1006,444,2806,-1,441,3080,439,-1,436,3084,437,-1,3081,4024,3458,-1,433,1029,409,-1,431,3088,429,-1,2782,426,428,-1,425,435,423,-1,420,976,421,-1,419,1005,414,-1,417,2743,415,-1,2744,412,414,-1,411,402,410,-1,409,2793,407,-1,406,2786,404,-1,401,403,408,-1,3565,398,400,-1,398,3565,348,-1,348,2824,398,-1,2823,2824,1039,-1,1038,350,349,-1,348,347,3092,-1,245,247,393,-1,265,268,389,-1,377,3094,3453,-1,384,386,3096,-1,382,3093,245,-1,380,3093,293,-1,296,273,272,-1,377,1018,375,-1,261,290,374,-1,373,882,371,-1,3452,368,370,-1,928,365,367,-1,363,3101,364,-1,361,4025,360,-1,359,4026,357,-1,356,360,355,-1,921,920,3103,-1,954,416,3106,-1,351,950,352,-1,346,4027,344,-1,343,4028,341,-1,338,340,4029,-1,3547,340,339,-1,334,447,332,-1,327,3034,328,-1,326,4030,324,-1,4031,329,4032,-1,325,3442,3029,-1,3117,320,3040,-1,330,331,3115,-1,311,3114,309,-1,303,304,307,-1,3120,3121,3123,-1,303,288,287,-1,877,2847,887,-1,3128,4033,1040,-1,289,287,379,-1,296,272,294,-1,3132,294,3138,-1,4034,266,3437,-1,4034,271,266,-1,3440,303,308,-1,293,292,381,-1,289,374,290,-1,288,293,286,-1,284,4035,285,-1,1020,285,4035,-1,1046,4036,1047,-1,274,374,275,-1,271,4034,272,-1,3437,266,268,-1,265,391,263,-1,264,299,265,-1,2756,2737,4037,-1,255,254,3435,-1,3142,258,252,-1,251,3143,3142,-1,2736,397,3434,-1,3434,3150,2736,-1,4038,4039,4040,-1,3470,455,454,-1,3470,3469,455,-1,238,3167,220,-1,235,4041,236,-1,232,234,216,-1,233,223,234,-1,230,4042,231,-1,226,228,4043,-1,223,3162,224,-1,221,236,222,-1,219,222,220,-1,217,4044,215,-1,219,218,4045,-1,212,214,4046,-1,4047,4048,3426,-1,4047,4049,4048,-1,209,211,3174,-1,206,208,4050,-1,204,4051,205,-1,201,205,202,-1,198,200,4052,-1,196,3195,188,-1,4053,183,180,-1,4053,4054,183,-1,194,4055,195,-1,191,193,3197,-1,188,190,4056,-1,186,4057,187,-1,183,185,4058,-1,195,180,182,-1,177,179,3199,-1,171,173,4059,-1,168,170,3203,-1,167,4060,159,-1,164,3218,165,-1,161,163,4061,-1,158,160,3230,-1,3227,3406,3228,-1,3406,4062,3228,-1,153,3235,151,-1,148,150,4063,-1,145,3237,146,-1,144,4008,142,-1,140,4064,141,-1,137,3251,138,-1,134,136,127,-1,140,115,4065,-1,4065,4066,140,-1,3250,132,119,-1,4067,130,131,-1,127,136,128,-1,124,3254,125,-1,121,4068,122,-1,118,120,4069,-1,117,4065,115,-1,114,4070,112,-1,109,4071,110,-1,4072,4073,4074,-1,4072,4075,4073,-1,107,4076,108,-1,104,106,101,-1,101,106,102,-1,98,100,4077,-1,95,4078,96,-1,92,94,4079,-1,89,91,4080,-1,86,4081,87,-1,85,3300,83,-1,82,4082,80,-1,4083,76,75,-1,74,3340,75,-1,6,63,7,-1,70,72,4084,-1,67,4085,68,-1,64,66,3312,-1,63,4086,58,-1,60,62,4087,-1,57,59,4088,-1,45,56,3376,-1,52,54,4089,-1,51,47,49,-1,54,4090,4091,-1,4092,43,45,-1,3325,40,42,-1,38,3311,39,-1,4093,34,36,-1,33,4094,32,-1,26,28,3338,-1,17,3368,4095,-1,25,3347,23,-1,3349,3335,3350,-1,4096,3341,3352,-1,14,16,3334,-1,13,3367,11,-1,8,10,4097,-1,5,7,4098,-1,2,1,3,-1,2,4099,0,-1,4100,4101,4102,-1,4100,4103,4101,-1,4104,4105,4106,-1,4104,4107,4105,-1,801,4100,3973,-1,801,4108,4100,-1,846,4109,4104,-1,849,4109,846,-1,4110,3363,3362,-1,4110,4111,3363,-1,4112,4113,4114,-1,4112,4115,4113,-1,4116,4117,4118,-1,4116,4119,4117,-1,3363,4120,3364,-1,3363,4121,4120,-1,4117,4122,4123,-1,4117,4124,4122,-1,4120,4125,4126,-1,4120,4127,4125,-1,4114,4128,3493,-1,4114,4113,4128,-1,4129,4099,2,-1,4099,4129,4130,-1,4131,4132,4133,-1,4131,4134,4132,-1,4135,4136,4137,-1,4135,4138,4136,-1,4139,4140,4141,-1,4139,4142,4140,-1,4143,4135,4144,-1,4143,4145,4135,-1,4146,4147,4148,-1,4146,4139,4147,-1,4129,4,4149,-1,4,4129,2,-1,4150,4151,4152,-1,4153,4151,4150,-1,4154,167,4155,-1,4154,4060,167,-1,4153,4156,4157,-1,4156,4153,4158,-1,4159,4154,4110,-1,4159,4160,4154,-1,4161,4162,4121,-1,4161,4156,4162,-1,4163,4164,4165,-1,4163,10,4164,-1,4166,4167,2876,-1,4168,4167,4166,-1,4169,4170,4171,-1,4169,4172,4170,-1,3323,4173,4174,-1,4175,4173,3323,-1,4176,3354,3366,-1,4176,4177,3354,-1,4178,70,4179,-1,4178,4180,70,-1,65,10,4163,-1,4097,10,65,-1,4181,4085,4182,-1,4181,4183,4085,-1,4184,4185,4186,-1,4185,4184,4187,-1,4188,4189,4168,-1,4189,4188,4190,-1,3353,4191,3366,-1,4192,4191,3353,-1,4193,4194,4195,-1,4193,4196,4194,-1,4180,4197,4198,-1,4197,4180,4178,-1,4199,2874,4200,-1,2874,4199,4201,-1,4202,4191,4203,-1,4202,4204,4191,-1,4205,837,839,-1,837,4205,4206,-1,4207,4208,4209,-1,4207,4210,4208,-1,4211,4212,4213,-1,4214,4212,4211,-1,4215,4216,4217,-1,4215,4218,4216,-1,3351,4219,4220,-1,3270,4219,3351,-1,4221,77,18,-1,4222,77,4221,-1,4223,4224,4225,-1,4226,4224,4223,-1,4227,4228,4229,-1,4227,4230,4228,-1,4231,4232,4233,-1,4231,27,4232,-1,21,3347,3349,-1,3347,21,3345,-1,3352,3368,19,-1,3352,3341,3368,-1,13,21,20,-1,13,3345,21,-1,4222,78,77,-1,4222,4234,78,-1,17,4233,4235,-1,4233,17,4095,-1,4236,4237,4238,-1,4237,4236,4239,-1,4235,4232,4240,-1,4235,4233,4232,-1,4241,14,4218,-1,14,4241,4242,-1,4237,4219,4238,-1,4243,4219,4237,-1,4244,3341,4096,-1,4244,3370,3341,-1,12,4245,4246,-1,4245,12,4229,-1,2867,16,4247,-1,2867,3332,16,-1,4248,4249,4250,-1,4251,4249,4248,-1,4252,4253,4254,-1,4252,4225,4253,-1,4255,844,4256,-1,4255,845,844,-1,4257,33,31,-1,4257,4258,33,-1,4259,4260,4261,-1,4259,4262,4260,-1,4263,4264,4265,-1,4263,4266,4264,-1,4267,3361,3357,-1,4268,3361,4267,-1,3372,4269,3331,-1,3372,4270,4269,-1,4263,4271,4272,-1,4263,4265,4271,-1,4273,4266,4263,-1,4273,4274,4266,-1,4268,2865,3361,-1,2866,2865,4268,-1,4275,848,850,-1,848,4275,4276,-1,4270,4277,4278,-1,4277,4270,3372,-1,4279,4280,4281,-1,4279,4282,4280,-1,46,4283,4284,-1,46,48,4283,-1,47,3315,49,-1,47,46,3315,-1,3321,4285,4087,-1,3320,4285,3321,-1,4286,4287,4288,-1,4286,4289,4287,-1,54,4290,4089,-1,54,4091,4290,-1,3324,4291,4292,-1,3324,3326,4291,-1,4293,4294,4295,-1,4293,4296,4294,-1,4297,4298,4299,-1,4297,4300,4298,-1,4301,4302,4303,-1,4302,4301,4304,-1,3322,4188,4305,-1,4306,4188,3322,-1,4307,4308,4309,-1,4307,4310,4308,-1,4311,4312,4313,-1,4311,4314,4312,-1,4285,4311,3374,-1,4315,4311,4285,-1,4316,4317,4318,-1,4316,4319,4317,-1,4320,40,3325,-1,4320,4321,40,-1,4322,4087,62,-1,4087,4322,3321,-1,4323,4286,4324,-1,4323,4325,4286,-1,3378,4279,4326,-1,3378,3318,4279,-1,4327,59,4328,-1,59,4327,34,-1,4329,4330,4331,-1,4329,4324,4330,-1,4332,4333,4334,-1,4332,4326,4333,-1,4335,3379,4328,-1,4335,3313,3379,-1,4336,4337,4338,-1,4337,4336,4339,-1,4340,4341,4342,-1,4341,4340,4343,-1,4344,4345,4346,-1,4345,4344,4347,-1,4312,4303,4302,-1,4312,4314,4303,-1,4348,4338,4349,-1,4348,4350,4338,-1,4351,4352,4353,-1,4352,4351,4342,-1,66,4346,3312,-1,66,4354,4346,-1,4174,44,3323,-1,4174,4355,44,-1,4177,4356,3354,-1,4177,4357,4356,-1,4358,4098,7,-1,4098,4358,4359,-1,4170,4302,4165,-1,4170,4312,4302,-1,4187,4360,4361,-1,4187,4362,4360,-1,4363,4364,4365,-1,4364,4363,4086,-1,4364,4366,4367,-1,4366,4364,73,-1,48,4368,4283,-1,48,35,4368,-1,4369,35,48,-1,4369,36,35,-1,4369,4370,36,-1,4369,4371,4370,-1,4369,4282,4371,-1,4372,4282,4369,-1,4372,4280,4282,-1,4372,4373,4280,-1,3377,4373,4372,-1,3377,4374,4373,-1,3377,4289,4374,-1,3377,4287,4289,-1,3377,4375,4287,-1,4376,4377,4378,-1,4376,90,4377,-1,4379,4380,4381,-1,4382,4380,4379,-1,4383,4384,4385,-1,4386,4384,4383,-1,4387,3381,3290,-1,3305,3381,4387,-1,4388,4389,4390,-1,4388,4391,4389,-1,4392,4393,4394,-1,4393,4392,4395,-1,3273,3335,25,-1,3335,3273,4396,-1,4396,4397,4398,-1,4397,4396,4399,-1,4400,4401,4402,-1,4401,4400,4403,-1,4404,4405,4406,-1,4404,4407,4405,-1,4408,4388,4409,-1,4408,4410,4388,-1,4234,4393,78,-1,4234,4411,4393,-1,4412,4378,4413,-1,4412,4376,4378,-1,4414,4380,4382,-1,4414,4415,4380,-1,104,4416,4417,-1,4418,4416,104,-1,4419,4420,4421,-1,4422,4420,4419,-1,4423,4424,4425,-1,4424,4423,4426,-1,3307,4407,4404,-1,3307,3306,4407,-1,4427,4428,4429,-1,4427,4430,4428,-1,3285,4431,3286,-1,3285,3383,4431,-1,3384,3298,3289,-1,3298,3384,3299,-1,4427,4432,4433,-1,4432,4427,4429,-1,4425,4434,4435,-1,4434,4425,4424,-1,4436,4404,4437,-1,4436,3307,4404,-1,4438,3289,3284,-1,4438,3296,3289,-1,3387,3286,3386,-1,3387,3285,3286,-1,4439,4081,86,-1,4439,4080,4081,-1,4401,4437,4440,-1,4401,4436,4437,-1,4433,4441,4442,-1,4441,4433,4432,-1,4435,4443,4444,-1,4443,4435,4434,-1,3288,4421,3282,-1,4421,3288,4419,-1,4445,3386,4446,-1,4445,3387,3386,-1,4447,4448,4449,-1,4448,4447,4450,-1,4442,4451,4452,-1,4451,4442,4441,-1,3281,4445,4453,-1,3281,95,4445,-1,4454,90,89,-1,4454,4377,90,-1,3283,4455,4456,-1,4457,4455,3283,-1,4453,4446,4458,-1,4453,4445,4446,-1,4459,4460,4461,-1,4460,4459,4462,-1,4463,4410,4408,-1,4463,4402,4410,-1,4452,4464,4465,-1,4464,4452,4451,-1,3279,4453,4466,-1,3279,3281,4453,-1,4377,3276,4467,-1,3276,4377,4454,-1,4468,4469,4470,-1,4469,4468,4471,-1,4472,4473,4474,-1,4473,4472,4475,-1,4476,4477,4478,-1,4476,4479,4477,-1,106,108,4480,-1,105,108,106,-1,4481,4482,4483,-1,4481,4484,4482,-1,3277,4485,3275,-1,4485,3277,3388,-1,4397,4486,4487,-1,4397,4488,4486,-1,4489,4490,4491,-1,4490,4489,4492,-1,4493,4494,4495,-1,4494,4493,4496,-1,4418,4415,4416,-1,4415,4418,4497,-1,4498,4483,4499,-1,4498,4481,4483,-1,3275,4500,4501,-1,4500,3275,4485,-1,4502,4503,4504,-1,4236,4503,4502,-1,4505,3272,4506,-1,3272,4505,3274,-1,4507,4508,4509,-1,4508,4507,4510,-1,4511,4512,4501,-1,4511,4513,4512,-1,3271,107,4514,-1,3271,4076,107,-1,4515,4499,4516,-1,4515,4498,4499,-1,3269,4236,4238,-1,3269,4503,4236,-1,4506,24,4517,-1,24,4506,3272,-1,4518,4519,4520,-1,4519,4518,4515,-1,4521,4513,4511,-1,4521,3343,4513,-1,4514,3390,3271,-1,3310,3390,4514,-1,4405,3305,3303,-1,4407,3305,4405,-1,4407,3306,3305,-1,109,4226,4071,-1,4224,4226,109,-1,4522,4523,4524,-1,4523,4522,4520,-1,4525,4526,4527,-1,4528,4526,4525,-1,136,4529,128,-1,136,4530,4529,-1,3258,3265,3267,-1,4531,3265,3258,-1,4532,122,4068,-1,4532,4533,122,-1,4534,4535,4533,-1,4534,4536,4535,-1,4069,4537,4538,-1,4069,4539,4537,-1,4540,3257,3256,-1,3257,4540,4541,-1,4542,4543,4544,-1,4543,4542,4545,-1,3260,4546,3393,-1,3260,4547,4546,-1,4548,4549,4550,-1,4548,4551,4549,-1,4552,3262,3394,-1,3262,4552,4553,-1,4554,4555,4556,-1,4554,4557,4555,-1,4558,4258,4559,-1,4558,33,4258,-1,4560,4561,4562,-1,4560,4563,4561,-1,4262,4564,4260,-1,4262,4565,4564,-1,4064,4566,4567,-1,4566,4064,140,-1,4566,4532,114,-1,4566,4568,4532,-1,4569,4570,3360,-1,4569,4571,4570,-1,4531,4560,3265,-1,4563,4560,4531,-1,3262,4572,126,-1,4572,3262,4573,-1,4561,4574,4529,-1,4561,4556,4574,-1,4575,4576,4577,-1,4575,4550,4576,-1,3256,133,3255,-1,133,3256,3257,-1,4544,3397,4578,-1,4579,3397,4544,-1,4134,4577,4132,-1,4134,4575,4577,-1,4572,4580,4581,-1,4580,4572,4582,-1,4583,4132,4577,-1,4584,4132,4583,-1,121,3247,4585,-1,3247,121,3255,-1,3398,4579,3253,-1,3398,139,4579,-1,4581,4586,4587,-1,4586,4581,4580,-1,3398,3392,4588,-1,3392,3398,116,-1,130,4589,3248,-1,4589,130,4067,-1,4590,3247,3246,-1,4590,4585,3247,-1,4587,4146,4591,-1,4146,4587,4586,-1,4590,4592,112,-1,4593,4592,4590,-1,4594,3251,137,-1,4594,4595,3251,-1,3248,4596,4597,-1,4596,3248,4589,-1,4591,4148,4598,-1,4148,4591,4146,-1,4599,4600,3400,-1,4599,4558,4600,-1,4601,4602,4603,-1,4602,4601,4604,-1,4605,4606,4607,-1,4606,4605,4608,-1,4609,4610,4611,-1,4609,4612,4610,-1,4613,4614,4615,-1,4614,4613,4598,-1,4260,4559,4258,-1,4260,4564,4559,-1,4616,4264,4617,-1,4264,4616,4618,-1,3356,4619,3357,-1,3356,4620,4619,-1,4621,4269,4622,-1,4269,4621,4623,-1,4624,4625,4626,-1,4624,4627,4625,-1,4628,4629,4630,-1,4628,4631,4629,-1,4632,4633,4634,-1,4632,4635,4633,-1,4636,4627,4624,-1,4636,4630,4627,-1,3241,4637,3239,-1,4638,4637,3241,-1,4639,4640,3240,-1,4639,4641,4640,-1,4642,3241,3401,-1,4642,4643,3241,-1,4644,3206,3205,-1,4644,3208,3206,-1,4645,4646,4647,-1,4645,4648,4646,-1,4649,4650,4651,-1,4649,4647,4650,-1,4633,4652,4653,-1,4633,4654,4652,-1,4629,4651,4655,-1,4629,4649,4651,-1,4656,4657,4658,-1,4656,4659,4657,-1,4660,4658,4657,-1,4661,4658,4660,-1,4637,3402,4639,-1,4637,3188,3402,-1,4662,4663,4664,-1,4662,4665,4663,-1,4666,4667,4063,-1,4667,4666,4668,-1,4669,4670,4671,-1,4669,4672,4670,-1,4673,4662,4674,-1,4673,4675,4662,-1,149,4676,4677,-1,4676,149,148,-1,4678,4679,4680,-1,4678,4674,4679,-1,148,4681,4676,-1,4681,148,4682,-1,4683,4684,4685,-1,4684,4683,4686,-1,4687,4688,4689,-1,4688,4687,4690,-1,4689,4691,4692,-1,4691,4689,4688,-1,4693,4694,4695,-1,4694,4693,4696,-1,4697,4698,4699,-1,4698,4697,4685,-1,4700,4701,4702,-1,4700,4703,4701,-1,4704,4705,151,-1,4705,4704,4706,-1,4707,3404,4708,-1,3404,4707,4709,-1,4710,4711,4712,-1,4710,4713,4711,-1,4714,4715,4716,-1,4715,4714,4717,-1,4718,4719,4720,-1,4718,4712,4719,-1,4716,4721,4722,-1,4721,4716,4715,-1,156,4700,3226,-1,156,4723,4700,-1,152,4705,4724,-1,152,151,4705,-1,3232,3231,3233,-1,3231,3232,4725,-1,3233,3230,160,-1,3230,3233,3231,-1,4726,3225,4727,-1,3225,4726,4728,-1,3220,153,3222,-1,3220,3403,153,-1,4729,4722,4730,-1,4729,4731,4722,-1,4732,4733,4734,-1,4733,4732,4729,-1,3406,4735,3223,-1,4735,3406,3227,-1,3219,3222,3221,-1,3219,3220,3222,-1,4736,4737,4738,-1,4737,4736,4739,-1,4740,4741,4742,-1,4741,4740,4738,-1,4743,4744,4745,-1,4744,4743,4746,-1,3224,3216,3217,-1,3215,3216,3224,-1,4747,3221,4748,-1,4747,3219,3221,-1,4749,4750,4751,-1,4750,4749,3407,-1,4752,4753,4751,-1,4752,4754,4753,-1,3213,4755,4160,-1,3213,3409,4755,-1,4756,3408,4757,-1,4756,4758,3408,-1,4759,4760,4761,-1,4760,4759,4762,-1,4763,4764,4668,-1,4764,4763,4761,-1,4765,4766,4767,-1,4766,4765,4768,-1,4757,4769,4756,-1,4770,4769,4757,-1,4771,4772,4773,-1,4771,4774,4772,-1,4775,4776,4777,-1,4776,4775,4778,-1,4779,4780,4781,-1,4779,4782,4780,-1,4783,4784,4785,-1,4784,4783,4786,-1,4787,4788,4789,-1,4787,4790,4788,-1,4791,4787,3211,-1,4791,4792,4787,-1,4793,4794,4795,-1,4793,4796,4794,-1,4797,4798,4799,-1,4798,4797,4800,-1,4801,4802,4803,-1,4802,4801,4804,-1,4805,4806,4807,-1,4806,4805,4808,-1,3212,4809,3210,-1,4809,3212,4807,-1,4810,4811,4812,-1,4810,4813,4811,-1,4814,4815,3411,-1,4815,4814,4816,-1,4817,4818,4819,-1,4817,4820,4818,-1,4821,4817,4822,-1,4821,4823,4817,-1,4824,4825,3412,-1,4825,4824,4826,-1,4827,3209,3410,-1,4827,4828,3209,-1,4829,4830,4831,-1,4830,4829,4832,-1,4833,170,4834,-1,170,4833,3207,-1,4834,4059,4835,-1,4836,4059,4834,-1,4837,4838,4839,-1,4838,4837,4840,-1,4841,4648,4645,-1,4841,4830,4648,-1,168,4842,4843,-1,4842,168,3202,-1,4838,4844,4845,-1,4844,4838,4846,-1,4654,3204,4652,-1,4654,3205,3204,-1,4842,4847,4848,-1,4847,4842,4849,-1,171,4683,4850,-1,4683,171,4851,-1,4852,4687,4853,-1,4687,4852,4845,-1,4854,4855,4856,-1,4854,4857,4855,-1,143,4858,144,-1,4858,143,4859,-1,4860,4861,4862,-1,4863,4861,4860,-1,4864,4865,4866,-1,4864,4863,4865,-1,4867,4868,4869,-1,4868,4867,4870,-1,4871,4872,4873,-1,4871,4874,4872,-1,4875,4876,4877,-1,4878,4876,4875,-1,4879,4880,4869,-1,4879,4881,4880,-1,4882,4883,4884,-1,4873,4883,4882,-1,4885,4886,4887,-1,4885,4888,4886,-1,4869,4889,4867,-1,4889,4869,4880,-1,2947,4890,4891,-1,4892,4890,2947,-1,4893,4894,4895,-1,4893,4896,4894,-1,4897,4898,4899,-1,4897,4900,4898,-1,4901,4902,4903,-1,4902,4901,4904,-1,4854,4905,4906,-1,4854,4907,4905,-1,4908,4909,3994,-1,4909,4908,4903,-1,4910,4911,4912,-1,4910,4895,4911,-1,2949,4913,3514,-1,2949,4897,4913,-1,4914,4058,185,-1,4914,4915,4058,-1,179,4916,3199,-1,4917,4916,179,-1,4918,4919,4920,-1,4921,4919,4918,-1,4922,4923,4924,-1,4922,4925,4923,-1,4926,4927,4928,-1,4927,4926,4918,-1,3201,190,3197,-1,190,3201,4924,-1,187,4929,3198,-1,187,4930,4929,-1,4931,4932,4927,-1,4933,4932,4931,-1,177,4934,4935,-1,4934,177,3200,-1,4936,4053,4055,-1,4936,4052,4053,-1,4937,4057,4938,-1,4937,4939,4057,-1,4932,4940,4941,-1,4942,4940,4932,-1,4934,4943,4944,-1,4943,4934,192,-1,4945,4946,4947,-1,4946,4945,4944,-1,3196,3192,4938,-1,3193,3192,3196,-1,4948,4949,4942,-1,4950,4949,4948,-1,3414,4951,3195,-1,3414,4952,4951,-1,4953,4954,4952,-1,4953,203,4954,-1,4955,4956,4957,-1,4956,4955,4947,-1,4958,3193,199,-1,4958,3191,3193,-1,4959,4960,4961,-1,4959,4950,4960,-1,4962,3194,4963,-1,4962,3414,3194,-1,4964,4962,4965,-1,4964,4953,4962,-1,3191,3236,3190,-1,3236,3191,4958,-1,4961,4966,4959,-1,4967,4966,4961,-1,4968,4966,4969,-1,4968,4970,4966,-1,4964,4971,4972,-1,4971,4964,4965,-1,3189,4973,4974,-1,3416,4973,3189,-1,4975,4976,4977,-1,4975,4969,4976,-1,4978,4979,4971,-1,4980,4979,4978,-1,4981,4982,4983,-1,4982,4981,4051,-1,4984,4862,4861,-1,4984,4980,4862,-1,4982,4985,4859,-1,4985,4982,4986,-1,4987,3417,3175,-1,4987,4988,3417,-1,4989,4990,3421,-1,4990,4989,4991,-1,3172,4992,3418,-1,3172,4993,4992,-1,4994,3418,4992,-1,4995,3418,4994,-1,4995,3185,3418,-1,4995,4996,3185,-1,4991,4996,4995,-1,4991,4997,4996,-1,4989,4997,4991,-1,4989,208,4997,-1,4998,208,4989,-1,4998,4050,208,-1,3186,4050,4998,-1,3417,4050,3186,-1,4988,4050,3417,-1,4988,4999,4050,-1,209,3177,5000,-1,209,3174,3177,-1,5001,210,5002,-1,5003,210,5001,-1,5004,3424,5005,-1,5004,3425,3424,-1,5004,5006,5007,-1,5004,5008,5006,-1,3182,5009,3183,-1,5009,3182,5010,-1,3171,5011,5012,-1,5011,3171,5013,-1,5014,5015,5016,-1,5015,5014,5017,-1,5018,212,5019,-1,212,5018,5020,-1,5021,212,4046,-1,5021,5019,212,-1,5022,5023,5024,-1,5022,3423,5023,-1,5025,5026,5027,-1,5025,5028,5026,-1,5029,4884,5030,-1,5029,4882,4884,-1,5031,4047,5032,-1,5031,4049,4047,-1,5029,5033,5034,-1,5029,5035,5033,-1,5036,3181,5037,-1,5036,3179,3181,-1,5038,5039,5040,-1,5038,213,5039,-1,3420,5041,5042,-1,3420,3179,5041,-1,4887,5043,5044,-1,5043,4887,4886,-1,5045,5043,5046,-1,5043,5045,5037,-1,3422,4993,3172,-1,3422,5047,4993,-1,3419,3421,4990,-1,3419,3176,3421,-1,5048,3175,211,-1,5048,4987,3175,-1,5049,207,5008,-1,5049,5050,207,-1,4048,3424,3426,-1,4048,5051,3424,-1,5016,5009,5052,-1,5016,5015,5009,-1,5053,5020,5018,-1,5020,5053,5054,-1,5001,5055,5056,-1,5057,5055,5001,-1,4876,5058,5059,-1,4876,5060,5058,-1,5061,5062,5063,-1,5061,5064,5062,-1,5065,5066,5067,-1,5065,5068,5066,-1,5069,5070,5071,-1,5070,5069,5072,-1,3429,5073,5074,-1,5073,3429,3157,-1,5075,5076,5077,-1,5075,3160,5076,-1,5078,4043,228,-1,4043,5078,5079,-1,230,3166,3158,-1,3166,230,229,-1,5080,5081,5082,-1,5080,5083,5081,-1,5084,5085,5086,-1,5087,5085,5084,-1,5088,232,5089,-1,5088,233,232,-1,5090,5072,5091,-1,5090,5092,5072,-1,5093,5082,5081,-1,5082,5093,5063,-1,215,5089,232,-1,5089,215,5094,-1,5095,5096,5097,-1,5098,5096,5095,-1,5099,5100,5101,-1,5099,5102,5100,-1,5103,5104,4907,-1,5105,5104,5103,-1,5106,5107,4896,-1,5106,5108,5107,-1,5100,5109,5110,-1,5100,5105,5109,-1,5111,5112,5108,-1,5113,5112,5111,-1,5114,5115,5110,-1,5116,5115,5114,-1,5117,5118,5113,-1,5119,5118,5117,-1,5120,5121,5122,-1,5121,5120,5123,-1,5124,5125,5126,-1,5125,5124,5127,-1,5128,5129,5122,-1,5129,5128,5130,-1,5131,5132,5133,-1,5132,5131,5134,-1,5135,5136,5137,-1,5136,5135,5138,-1,5139,5120,5140,-1,5139,5133,5120,-1,3165,5141,3163,-1,3165,5142,5141,-1,3160,5143,5076,-1,3160,3427,5143,-1,3159,5078,5144,-1,3158,5078,3159,-1,5080,5074,5073,-1,5080,5145,5074,-1,5146,3156,5147,-1,3156,5146,3157,-1,5148,3163,5141,-1,5148,5149,3163,-1,3427,5150,5143,-1,5151,5150,3427,-1,5152,5144,5153,-1,5152,3159,5144,-1,3152,5152,5154,-1,3152,3430,5152,-1,5128,5147,3156,-1,5128,5155,5147,-1,5156,5148,5124,-1,5156,5149,5148,-1,5151,5157,5150,-1,5158,5157,5151,-1,5154,5153,5159,-1,5154,5152,5153,-1,3152,5118,5119,-1,5118,3152,5154,-1,5160,5099,5161,-1,5162,5099,5160,-1,5163,3151,3059,-1,5164,3151,5163,-1,5165,451,3147,-1,5165,452,451,-1,4003,3466,607,-1,4003,3062,3466,-1,5166,5167,5168,-1,5166,5169,5167,-1,5170,2852,5171,-1,5170,5172,2852,-1,5173,2853,2851,-1,2853,5173,3145,-1,2734,3121,3120,-1,2734,1049,3121,-1,397,3144,3434,-1,397,248,3144,-1,3435,3436,258,-1,3435,254,3436,-1,1046,1019,5174,-1,1045,1019,1046,-1,3463,4036,3134,-1,3463,1047,4036,-1,279,3133,270,-1,279,278,3133,-1,250,380,381,-1,250,252,380,-1,304,3122,307,-1,3130,3122,304,-1,886,915,914,-1,915,886,909,-1,3435,3118,255,-1,3143,3118,3435,-1,2734,2833,913,-1,2734,3441,2833,-1,2815,305,3124,-1,3118,305,2815,-1,940,241,240,-1,940,939,241,-1,3116,314,313,-1,529,314,3116,-1,3506,3034,3032,-1,3506,328,3034,-1,3107,5175,3445,-1,5175,3107,5176,-1,5177,3102,3448,-1,5177,5178,3102,-1,2802,3098,2803,-1,5179,3098,2802,-1,926,3097,5180,-1,925,3097,926,-1,5181,3095,2761,-1,3095,5181,3096,-1,395,2738,396,-1,2738,395,5182,-1,5183,950,5184,-1,5183,249,950,-1,342,5185,5186,-1,5185,342,341,-1,2839,906,908,-1,2839,2838,906,-1,5187,3956,3940,-1,3956,5187,3955,-1,411,403,402,-1,411,2788,403,-1,425,986,434,-1,986,425,2776,-1,334,5188,446,-1,334,3078,5188,-1,3458,3080,438,-1,3458,439,3080,-1,4024,439,3458,-1,4024,440,439,-1,5189,3460,912,-1,5190,3460,5189,-1,5191,5192,5193,-1,5194,5192,5191,-1,5195,3462,3461,-1,5195,5196,3462,-1,903,5197,3958,-1,4021,5197,903,-1,3943,5198,5199,-1,1020,5198,3943,-1,2812,3557,2811,-1,2812,2760,3557,-1,5200,3077,5201,-1,5200,5202,3077,-1,1030,2760,2812,-1,1030,3556,2760,-1,5203,5204,5205,-1,5206,5204,5203,-1,2920,3069,450,-1,3069,2920,3067,-1,1035,945,3564,-1,945,1035,2817,-1,3466,5207,5208,-1,2995,5207,3466,-1,458,606,2992,-1,458,3471,606,-1,5209,453,452,-1,453,5209,5210,-1,5211,5212,5213,-1,5214,5212,5211,-1,3058,464,463,-1,3058,3499,464,-1,3473,5211,579,-1,5211,3473,3474,-1,3005,3475,3501,-1,3005,462,3475,-1,3054,462,3005,-1,3476,5215,5216,-1,5215,3476,4018,-1,5217,5218,5219,-1,5217,5215,5218,-1,5220,5221,3504,-1,5220,5222,5221,-1,3515,473,5223,-1,3051,473,3515,-1,545,486,488,-1,545,736,486,-1,5224,5225,5226,-1,5224,5227,5225,-1,3006,503,3046,-1,3006,501,503,-1,5228,5229,5230,-1,5231,5229,5228,-1,4016,3041,2944,-1,3041,4016,5232,-1,2944,531,4016,-1,531,2944,532,-1,5233,5234,5235,-1,521,5234,5233,-1,601,3038,3037,-1,5236,3038,601,-1,469,4031,669,-1,469,3036,4031,-1,5237,555,5238,-1,555,5237,673,-1,1633,670,3492,-1,670,1633,1630,-1,534,674,5239,-1,534,533,674,-1,5240,3030,524,-1,5240,624,3030,-1,551,510,552,-1,551,511,510,-1,4128,3026,3493,-1,3028,3026,4128,-1,4017,4006,5241,-1,4006,4017,479,-1,5242,5243,5244,-1,5245,5243,5242,-1,3020,3496,586,-1,3019,3496,3020,-1,559,597,5244,-1,559,596,597,-1,5246,3008,5247,-1,3008,5246,5248,-1,3488,5249,3487,-1,5250,5249,3488,-1,5251,3498,2999,-1,5252,3498,5251,-1,5253,3046,3485,-1,3046,5253,3006,-1,3496,587,3013,-1,587,3496,588,-1,3497,5254,3019,-1,5255,5254,3497,-1,3020,578,498,-1,3020,3487,578,-1,576,5256,5257,-1,576,5258,5256,-1,4011,5259,572,-1,4011,4626,5259,-1,3014,4008,144,-1,4008,3014,587,-1,523,5240,524,-1,566,5240,523,-1,5260,5210,5207,-1,5260,3503,5210,-1,5261,5262,5263,-1,5262,5261,595,-1,3001,5264,3502,-1,5265,5264,3001,-1,4007,3005,3004,-1,4007,580,3005,-1,5263,5266,5267,-1,5266,5263,5262,-1,3004,591,4007,-1,591,3004,594,-1,5268,520,522,-1,5247,520,5268,-1,3494,5269,5270,-1,3494,3024,5269,-1,5271,5248,5246,-1,4695,5248,5271,-1,5272,5252,4691,-1,5272,3498,5252,-1,4699,5273,3016,-1,4698,5273,4699,-1,493,5274,5275,-1,511,5274,493,-1,5276,5277,5278,-1,3148,5277,5276,-1,3146,5279,3484,-1,3146,5280,5279,-1,3037,514,601,-1,514,3037,5281,-1,5229,5282,5226,-1,5282,5229,5283,-1,3147,4005,5165,-1,3484,4005,3147,-1,3507,660,5284,-1,660,3507,4001,-1,5285,624,5240,-1,624,5285,625,-1,5286,621,4000,-1,621,5286,2960,-1,5287,661,5288,-1,661,5287,2981,-1,5289,2954,2980,-1,5289,5290,2954,-1,2969,657,2975,-1,647,657,2969,-1,531,622,3491,-1,531,530,622,-1,5291,3508,3996,-1,5291,5292,3508,-1,2943,5293,5294,-1,2943,3509,5293,-1,1751,612,2393,-1,1751,651,612,-1,5232,636,4014,-1,2963,636,5232,-1,641,2978,656,-1,635,2978,641,-1,640,635,641,-1,640,2980,635,-1,5295,5286,626,-1,5286,5295,5296,-1,4864,2959,2961,-1,5297,2959,4864,-1,624,526,3030,-1,526,624,3999,-1,4867,630,629,-1,4889,630,4867,-1,5298,4874,2955,-1,4874,5298,4872,-1,658,4877,659,-1,4877,658,4875,-1,5299,3511,2982,-1,5299,5300,3511,-1,631,4889,5301,-1,4889,631,630,-1,650,3995,667,-1,650,649,3995,-1,2950,5302,653,-1,3514,5302,2950,-1,5303,5304,5305,-1,5303,4892,5304,-1,2974,652,642,-1,652,2974,2972,-1,645,2946,2948,-1,2946,645,2971,-1,4857,3995,664,-1,4857,5306,3995,-1,2973,2974,3489,-1,2973,2972,2974,-1,5289,2976,5307,-1,5289,3997,2976,-1,605,5207,2995,-1,605,5260,5207,-1,331,3490,3115,-1,3490,331,2945,-1,3505,5308,2991,-1,5308,3505,5309,-1,5237,3113,2939,-1,5237,5239,3113,-1,2937,478,5310,-1,478,2937,5223,-1,3504,458,2992,-1,5221,458,3504,-1,5221,456,458,-1,608,5311,4019,-1,608,607,5311,-1,3519,5312,2931,-1,3519,5313,5312,-1,5314,467,3477,-1,3520,467,5314,-1,5315,5316,5317,-1,5318,5316,5315,-1,5318,899,2916,-1,899,5318,5319,-1,2997,5219,2996,-1,2997,5217,5219,-1,5320,2881,2926,-1,688,2881,5320,-1,2922,5321,2885,-1,2922,5322,5321,-1,4040,5323,5324,-1,5323,4040,5168,-1,5325,5326,5321,-1,5325,5327,5326,-1,5328,4039,4038,-1,5328,5329,4039,-1,5330,5331,5332,-1,5330,5280,5331,-1,5333,5225,5227,-1,5225,5333,5278,-1,854,817,856,-1,699,817,854,-1,734,2918,2845,-1,2918,734,733,-1,5334,2929,898,-1,5334,5335,2929,-1,5336,5337,5338,-1,5337,5336,730,-1,2889,795,2887,-1,796,795,2889,-1,2911,679,2927,-1,679,2911,745,-1,5339,5340,5341,-1,5339,2896,5340,-1,715,2919,701,-1,2919,715,714,-1,5342,3521,5343,-1,3521,5342,600,-1,799,5344,3974,-1,799,2915,5344,-1,690,3981,2924,-1,690,2923,3981,-1,2880,688,3991,-1,2881,688,2880,-1,5345,5346,5171,-1,5345,5347,5346,-1,5348,873,2906,-1,5348,5349,873,-1,5350,5351,5352,-1,5353,5351,5350,-1,2908,3970,5354,-1,2908,813,3970,-1,5355,758,2878,-1,5355,3980,758,-1,5356,5350,5357,-1,5356,5353,5350,-1,820,5358,3535,-1,2907,5358,820,-1,810,3989,3971,-1,810,5359,3989,-1,5360,5361,5362,-1,5363,5361,5360,-1,5364,5365,5366,-1,3523,5365,5364,-1,5367,3533,868,-1,5368,3533,5367,-1,5369,2858,818,-1,5369,5370,2858,-1,808,5371,5372,-1,5373,5371,808,-1,2899,5374,2900,-1,2899,5375,5374,-1,5376,5371,5377,-1,5376,3977,5371,-1,726,5378,5379,-1,725,5378,726,-1,5380,3530,5381,-1,3530,5380,2888,-1,5382,5381,3530,-1,5383,5381,5382,-1,799,790,483,-1,798,790,799,-1,5384,4122,4677,-1,5384,5385,4122,-1,5381,4125,5386,-1,5381,5383,4125,-1,5340,2895,728,-1,5340,2896,2895,-1,5335,2930,2929,-1,5387,2930,5335,-1,3985,5388,3986,-1,5388,3985,5389,-1,3986,5387,5335,-1,5388,5387,3986,-1,5224,4038,5390,-1,5391,4038,5224,-1,691,5364,689,-1,3988,5364,691,-1,866,5392,5393,-1,5394,5392,866,-1,3962,5393,815,-1,3962,5367,5393,-1,2910,745,2911,-1,2910,746,745,-1,5395,2862,5396,-1,2863,2862,5395,-1,3524,2883,735,-1,3524,2882,2883,-1,827,4200,2874,-1,4200,827,841,-1,5397,4212,5398,-1,4212,5397,5399,-1,5400,5401,5402,-1,5401,5400,5403,-1,5404,4210,4207,-1,5404,5405,4210,-1,5406,4195,5407,-1,4195,5406,4193,-1,4198,5408,5409,-1,4197,5408,4198,-1,5410,5405,5404,-1,5410,5411,5405,-1,5408,756,3980,-1,5412,756,5408,-1,3979,3537,759,-1,5407,3537,3979,-1,823,840,754,-1,823,833,840,-1,5413,5414,5398,-1,5413,5415,5414,-1,5416,5417,5354,-1,5417,5416,5402,-1,5404,5418,5410,-1,5418,5404,5419,-1,5420,5368,5421,-1,5420,5422,5368,-1,5369,3344,4246,-1,5369,773,3344,-1,3333,2869,3533,-1,3332,2869,3333,-1,4249,762,5423,-1,4249,767,762,-1,780,4252,771,-1,4252,780,5424,-1,5425,5426,5377,-1,5426,5425,4273,-1,3975,5427,5428,-1,3975,787,5427,-1,701,3987,715,-1,3987,701,704,-1,719,721,723,-1,719,718,721,-1,688,763,2904,-1,688,5320,763,-1,5429,5430,5431,-1,5429,5362,5430,-1,2850,871,2848,-1,2850,872,871,-1,692,5432,5433,-1,692,689,5432,-1,880,2818,883,-1,2817,2818,880,-1,373,893,874,-1,373,2855,893,-1,3961,5434,2855,-1,3961,5435,5434,-1,853,3091,5436,-1,3091,853,3090,-1,5349,882,873,-1,876,882,5349,-1,5203,2844,3983,-1,2845,2844,5203,-1,889,892,5437,-1,889,890,892,-1,3068,732,734,-1,862,732,3068,-1,5438,3984,5439,-1,5438,3985,3984,-1,5205,2845,5203,-1,5205,734,2845,-1,5440,5362,5429,-1,5362,5440,5360,-1,5343,5441,5342,-1,5441,5343,5442,-1,5384,4676,5443,-1,5384,4677,4676,-1,5444,897,5445,-1,897,5444,898,-1,5446,4021,3064,-1,5446,5197,4021,-1,2854,901,900,-1,901,2854,3432,-1,5447,2836,2835,-1,5448,2836,5447,-1,269,3538,372,-1,3133,3538,269,-1,3133,281,3538,-1,5449,3094,5450,-1,5449,3453,3094,-1,3443,339,3109,-1,339,3443,3547,-1,5451,5452,5453,-1,5452,5451,5454,-1,3084,5455,5456,-1,3084,3083,5455,-1,5457,3073,3075,-1,5457,5458,3073,-1,5459,5460,5461,-1,5462,5460,5459,-1,5463,5464,5465,-1,5463,5466,5464,-1,5467,5468,5469,-1,5470,5468,5467,-1,921,5471,5472,-1,5471,921,3954,-1,3560,5473,5474,-1,5473,3560,5475,-1,1023,3541,2825,-1,1023,5456,3541,-1,3956,335,5476,-1,3956,3543,335,-1,5477,5452,5478,-1,5477,5453,5452,-1,5466,4026,5464,-1,5466,357,4026,-1,3105,2829,2828,-1,2829,3105,5479,-1,932,2742,930,-1,932,3545,2742,-1,3542,3955,5480,-1,3542,3543,3955,-1,936,3940,937,-1,936,5187,3940,-1,369,2740,2739,-1,369,367,2740,-1,5481,2738,5482,-1,5481,2739,2738,-1,356,5461,361,-1,356,5459,5461,-1,3444,5177,3443,-1,3444,358,5177,-1,2832,3104,3942,-1,5179,3104,2832,-1,5456,1022,3084,-1,5456,1023,1022,-1,3563,2809,2808,-1,3563,5483,2809,-1,2807,5484,918,-1,5484,2807,965,-1,3953,5485,2798,-1,5485,3953,5486,-1,2831,5487,5488,-1,2830,5487,2831,-1,5489,5454,5490,-1,5489,5452,5454,-1,3098,5491,3099,-1,3098,3957,5491,-1,2794,918,5484,-1,2794,1031,918,-1,1029,2793,409,-1,1029,2791,2793,-1,406,3455,5492,-1,3455,406,405,-1,2772,995,990,-1,995,2772,996,-1,2784,428,2785,-1,5493,428,2784,-1,5494,2774,5495,-1,5494,5496,2774,-1,3947,3551,3550,-1,3551,3947,1000,-1,1033,5497,5498,-1,5497,1033,5499,-1,1001,982,2779,-1,1001,2745,982,-1,3944,991,5500,-1,991,3944,5501,-1,5502,2749,3945,-1,2749,5502,2750,-1,1018,5503,2810,-1,1018,5449,5503,-1,5449,1018,3453,-1,5504,2792,5505,-1,5506,2792,5504,-1,3550,3553,3947,-1,3550,2790,3553,-1,2778,5507,2779,-1,2778,5508,5507,-1,435,5509,423,-1,435,429,5509,-1,5494,5504,5510,-1,5494,5511,5504,-1,5512,5513,5514,-1,5512,5515,5513,-1,2757,2797,2758,-1,5516,2797,2757,-1,5517,5518,4024,-1,5519,5518,5517,-1,1016,5483,960,-1,1016,5181,5483,-1,5520,5521,5522,-1,5520,5523,5521,-1,5524,5520,5525,-1,5520,5524,5526,-1,5525,5522,5174,-1,5525,5520,5522,-1,3136,5198,3137,-1,3136,5527,5198,-1,5193,5528,5191,-1,5193,1015,5528,-1,5529,5530,3112,-1,5529,5531,5530,-1,2754,3561,2755,-1,2754,3562,3561,-1,1027,3076,445,-1,1027,2752,3076,-1,969,5532,3557,-1,969,2797,5532,-1,2799,5485,5200,-1,2799,2798,5485,-1,999,2770,1000,-1,2770,999,3949,-1,957,5503,5533,-1,957,2810,5503,-1,3947,5534,998,-1,5534,3947,3553,-1,998,2750,5502,-1,2750,998,5534,-1,423,2784,421,-1,423,5509,2784,-1,2776,424,2777,-1,425,424,2776,-1,2778,2766,5508,-1,2778,981,2766,-1,2751,2768,1003,-1,2768,2751,2775,-1,5535,353,5536,-1,5535,354,353,-1,359,346,4025,-1,359,3108,346,-1,3101,2742,364,-1,5537,2742,3101,-1,924,3545,932,-1,3545,924,927,-1,948,5182,395,-1,3540,5182,948,-1,5538,3539,5539,-1,5538,3540,3539,-1,3452,927,924,-1,927,3452,925,-1,5183,4037,240,-1,4037,5183,5540,-1,2730,5541,2731,-1,2730,5542,5541,-1,5543,5544,5545,-1,5543,5546,5544,-1,2297,5541,5547,-1,5548,5541,2297,-1,2253,5544,5549,-1,3739,5544,2253,-1,5550,5551,3935,-1,5550,5552,5551,-1,5553,5554,5555,-1,5553,5556,5554,-1,5557,5558,5559,-1,5558,5557,5560,-1,5561,5550,5562,-1,5561,5563,5550,-1,5564,5558,5565,-1,5564,2630,5558,-1,5566,5567,5568,-1,5566,5561,5567,-1,5569,5570,5571,-1,5569,3936,5570,-1,5572,5573,5574,-1,5572,5575,5573,-1,5576,5577,5578,-1,5576,5579,5577,-1,5573,5580,5581,-1,5573,5582,5580,-1,5583,5584,5585,-1,5583,5586,5584,-1,5581,5587,5588,-1,5581,5589,5587,-1,5584,5590,5591,-1,5584,5592,5590,-1,5546,5593,5594,-1,5546,5590,5593,-1,5595,5596,5597,-1,5595,5598,5596,-1,3610,5599,5600,-1,5599,3610,5601,-1,5602,5603,5604,-1,5602,5605,5603,-1,5606,5601,5607,-1,5551,5601,5606,-1,5603,5563,5608,-1,5603,5609,5563,-1,1924,5610,1925,-1,5610,1924,5611,-1,5612,5613,2695,-1,5612,5614,5613,-1,5615,5616,1928,-1,5615,5617,5616,-1,5618,2705,5611,-1,2705,5618,5619,-1,5620,5621,5622,-1,5621,5620,5623,-1,5624,3567,5625,-1,5624,2727,3567,-1,5626,1114,5627,-1,2677,1114,5626,-1,5628,5629,5630,-1,5628,5631,5629,-1,5632,5633,5634,-1,5632,5635,5633,-1,5636,3567,5637,-1,5625,3567,5636,-1,5638,5612,5639,-1,5612,5638,5614,-1,5620,5640,5641,-1,5620,5642,5640,-1,5643,5644,5645,-1,5646,5644,5643,-1,5647,5627,5648,-1,5626,5627,5647,-1,5630,2267,2270,-1,5630,5629,2267,-1,5634,5649,5650,-1,5634,5633,5649,-1,5651,5637,2266,-1,5636,5637,5651,-1,5652,5653,5654,-1,5652,5655,5653,-1,5656,5614,5638,-1,5614,5656,1920,-1,1079,5657,5658,-1,1079,3569,5657,-1,5659,5660,5661,-1,5660,5659,5662,-1,5663,5664,5665,-1,5663,5666,5664,-1,5667,5668,5669,-1,5668,5667,5670,-1,5671,1073,2724,-1,5671,5672,1073,-1,5673,1118,2718,-1,5673,5674,1118,-1,1068,1078,1077,-1,1078,1068,1120,-1,1075,1060,1059,-1,1060,1075,2715,-1,1071,5675,1072,-1,1071,5676,5675,-1,5677,5678,5679,-1,5680,5678,5677,-1,5681,5665,5664,-1,5681,5682,5665,-1,5683,1066,1162,-1,5683,5684,1066,-1,5657,5685,5686,-1,5679,5685,5657,-1,1056,5687,1167,-1,5687,1056,5662,-1,1062,5682,2719,-1,5665,5682,1062,-1,5688,5689,5658,-1,5688,5690,5689,-1,5691,5692,3932,-1,5691,3808,5692,-1,5693,5661,5660,-1,5661,5693,5694,-1,5695,5696,5697,-1,5695,5698,5696,-1,2257,5699,5700,-1,5701,5699,2257,-1,5702,1052,5703,-1,5702,2732,1052,-1,5704,3927,1084,-1,3927,5704,5705,-1,5706,5707,5703,-1,5708,5707,5706,-1,5709,5710,5711,-1,5712,5710,5709,-1,5713,5714,5715,-1,5716,5714,5713,-1,5717,5718,5719,-1,5717,1085,5718,-1,5720,5721,5722,-1,5720,5723,5721,-1,1934,5724,5725,-1,5724,1934,5726,-1,5715,2251,5713,-1,5715,2252,2251,-1,3571,1083,1939,-1,1084,1083,3571,-1,5727,5728,5729,-1,5728,5727,5730,-1,1104,2710,2709,-1,5731,2710,1104,-1,5732,5733,5734,-1,5732,5735,5733,-1,1108,2693,5736,-1,1108,1107,2693,-1,5737,5738,5739,-1,5737,5740,5738,-1,5741,5742,2689,-1,5741,5743,5742,-1,2703,5744,5745,-1,3575,5744,2703,-1,5746,5747,5748,-1,5746,5749,5747,-1,1098,5750,1099,-1,5750,1098,5751,-1,5752,5753,5754,-1,1100,5753,5752,-1,2694,2700,5755,-1,2700,2694,3576,-1,2696,3576,2694,-1,3576,2696,5756,-1,5736,2692,5757,-1,5736,2693,2692,-1,1102,5758,5759,-1,1102,5760,5758,-1,5761,1093,1092,-1,1093,5761,5758,-1,5748,5762,5763,-1,5748,5747,5762,-1,1095,5764,1096,-1,1095,5765,5764,-1,5766,5767,5768,-1,5769,5767,5766,-1,5770,5742,5739,-1,5742,5770,5771,-1,5727,5772,5773,-1,5727,5774,5772,-1,5735,5775,5733,-1,5735,1106,5775,-1,5776,3581,5771,-1,3581,5776,5777,-1,5778,5779,5780,-1,5778,5773,5779,-1,1105,2682,5781,-1,1105,2686,2682,-1,5777,2690,3581,-1,2690,5777,2700,-1,5782,5783,5784,-1,5785,5783,5782,-1,5786,5787,5788,-1,5789,5787,5786,-1,1100,5759,5753,-1,1100,1102,5759,-1,5790,2678,5791,-1,5790,5792,2678,-1,5793,5794,5795,-1,5784,5794,5793,-1,5788,2680,1112,-1,5788,5796,2680,-1,5797,5756,2696,-1,5757,5756,5797,-1,5798,5622,5621,-1,5798,5799,5622,-1,5800,2727,5624,-1,5800,5801,2727,-1,2684,5802,5803,-1,2683,5802,2684,-1,5632,2678,5792,-1,2678,5632,2679,-1,5804,5795,5805,-1,5793,5795,5804,-1,2675,2684,5806,-1,2674,2684,2675,-1,5807,2696,3580,-1,5797,2696,5807,-1,5654,5808,5652,-1,5806,5808,5654,-1,5809,5810,5811,-1,5812,5810,5809,-1,5813,5814,5815,-1,5813,5816,5814,-1,1146,5817,5818,-1,1146,5819,5817,-1,5820,5821,5822,-1,5820,1158,5821,-1,5823,1128,5824,-1,1129,1128,5823,-1,5825,5826,5827,-1,5828,5826,5825,-1,1123,5829,5830,-1,5829,1123,1122,-1,5682,5831,2719,-1,5831,5682,5832,-1,5833,5834,5835,-1,5836,5834,5833,-1,5823,3586,3588,-1,5823,5837,3586,-1,5825,5838,5839,-1,5825,5840,5838,-1,5811,5841,5809,-1,5811,5842,5841,-1,5814,5843,5815,-1,5814,5844,5843,-1,5845,2716,2715,-1,5845,5846,2716,-1,5847,2661,3596,-1,2661,5847,5848,-1,5849,3591,5850,-1,3591,5849,3589,-1,5851,5852,5853,-1,3598,5852,5851,-1,5854,1147,5855,-1,5854,3917,1147,-1,5856,5857,5858,-1,5856,5859,5857,-1,5860,5861,5862,-1,5863,5861,5860,-1,5864,5865,5866,-1,5867,5865,5864,-1,1132,3593,5868,-1,1132,1131,3593,-1,2666,2671,5869,-1,1138,2671,2666,-1,5870,5871,5872,-1,5870,5873,5871,-1,5874,5875,5876,-1,5877,5875,5874,-1,5878,5879,5880,-1,5881,5879,5878,-1,5882,5883,5884,-1,5869,5883,5882,-1,2669,5868,3593,-1,5868,2669,5885,-1,1149,2664,5886,-1,1149,2665,2664,-1,5887,5888,5889,-1,5890,5888,5887,-1,5891,5892,5893,-1,5819,5892,5891,-1,5894,5895,5896,-1,5897,5895,5894,-1,1152,3594,1153,-1,2664,3594,1152,-1,5844,5898,5899,-1,5900,5898,5844,-1,5885,5901,5902,-1,5885,2669,5901,-1,5903,5896,5904,-1,5894,5896,5903,-1,5905,5889,5906,-1,5887,5889,5905,-1,5907,5891,5893,-1,5891,5907,5908,-1,5901,5909,5910,-1,5901,5911,5909,-1,5912,1155,5913,-1,5912,1156,1155,-1,3595,5914,2662,-1,3595,5915,5914,-1,5916,5917,5918,-1,5919,5917,5916,-1,5920,5921,5922,-1,5923,5921,5920,-1,5924,5925,5926,-1,5924,5828,5925,-1,5914,5927,3597,-1,5914,5928,5927,-1,5929,2654,5930,-1,5929,5931,2654,-1,5932,5848,5847,-1,5843,5848,5932,-1,1158,5933,1159,-1,5820,5933,1158,-1,5934,5935,5936,-1,5937,5935,5934,-1,5938,5939,5940,-1,5938,5941,5939,-1,5942,2658,2660,-1,3596,2658,5942,-1,5943,5944,5945,-1,5943,5946,5944,-1,2655,5947,5948,-1,2657,5947,2655,-1,5949,5941,5950,-1,5939,5941,5949,-1,5951,5952,5953,-1,5954,5952,5951,-1,5955,5956,5957,-1,5958,5956,5955,-1,5959,5960,5961,-1,5959,5962,5960,-1,2659,3913,1164,-1,2659,5963,3913,-1,5964,2656,5965,-1,5966,2656,5964,-1,5967,1122,1167,-1,5967,5829,1122,-1,5968,5964,5969,-1,5970,5964,5968,-1,5971,5972,5973,-1,5974,5972,5971,-1,5975,1116,3584,-1,5975,1117,1116,-1,5976,1166,1165,-1,1166,5976,5977,-1,5670,5978,5979,-1,5969,5978,5670,-1,5980,5981,3603,-1,5982,5981,5980,-1,5983,1178,1173,-1,5983,1179,1178,-1,5984,1180,1182,-1,1180,5984,5985,-1,5986,3601,2653,-1,5987,3601,5986,-1,5988,2636,5989,-1,5988,2650,2636,-1,1188,5990,2646,-1,5991,5990,1188,-1,5992,1190,1189,-1,5992,5993,1190,-1,5994,5995,5996,-1,5994,5997,5995,-1,5998,1189,5999,-1,5998,5992,1189,-1,6000,6001,6002,-1,6000,6003,6001,-1,6004,6005,6006,-1,6004,6007,6005,-1,2648,1175,6008,-1,2648,1177,1175,-1,6009,6010,6011,-1,6010,6009,6012,-1,3911,6013,6014,-1,3911,6015,6013,-1,6016,6017,6018,-1,6016,6019,6017,-1,6020,6021,6022,-1,6023,6021,6020,-1,5981,6024,6025,-1,5981,5996,6024,-1,5986,6026,6027,-1,5986,6022,6026,-1,6028,6029,6030,-1,6029,6028,6031,-1,6032,6033,6034,-1,6005,6033,6032,-1,6035,6036,6037,-1,6035,6038,6036,-1,2638,5989,2636,-1,5989,2638,5995,-1,6039,2640,6040,-1,6039,6041,2640,-1,6042,6032,6043,-1,6044,6032,6042,-1,5983,6045,6046,-1,5983,6014,6045,-1,3910,1197,1196,-1,3910,1191,1197,-1,1183,1199,2641,-1,1183,1200,1199,-1,1186,2651,6047,-1,1186,2647,2651,-1,6048,6043,6049,-1,6042,6043,6048,-1,1205,1192,3905,-1,1193,1192,1205,-1,2634,2635,1195,-1,2634,3606,2635,-1,6047,3601,6050,-1,6047,2651,3601,-1,6051,6052,6053,-1,6054,6052,6051,-1,6021,3912,6011,-1,3912,6021,6023,-1,1198,6055,6056,-1,1198,3908,6055,-1,6057,1201,6058,-1,3907,1201,6057,-1,6059,6053,6060,-1,6051,6053,6059,-1,6061,6016,6062,-1,6061,6019,6016,-1,6063,6064,6065,-1,6064,6063,6066,-1,6067,6068,6069,-1,6067,6070,6068,-1,6071,6072,6073,-1,6071,6074,6072,-1,5714,6075,6076,-1,6060,6075,5714,-1,6077,6073,6078,-1,6079,6073,6077,-1,6080,5710,6081,-1,6080,6082,5710,-1,5708,6010,5705,-1,6010,5708,6083,-1,6079,5717,6084,-1,6079,6077,5717,-1,6085,6086,6087,-1,6085,6088,6086,-1,6089,6090,6091,-1,6089,6092,6090,-1,6093,6094,6095,-1,6093,6096,6094,-1,6097,6098,6099,-1,6097,6091,6098,-1,2633,6100,6101,-1,2633,6102,6100,-1,6103,1210,1211,-1,6103,6104,1210,-1,6105,6106,2426,-1,6105,6107,6106,-1,6108,6109,6110,-1,6108,6111,6109,-1,6112,6113,6114,-1,6112,6110,6113,-1,6115,6092,6089,-1,6115,6116,6092,-1,6114,6117,6088,-1,6114,6113,6117,-1,6118,1213,6119,-1,1213,6118,1214,-1,3886,6120,6104,-1,3886,1279,6120,-1,1215,6121,3903,-1,6121,1215,6103,-1,6122,6123,6124,-1,6122,6125,6123,-1,6126,6127,6128,-1,6129,6127,6126,-1,5554,6130,5555,-1,5554,6131,6130,-1,6123,6132,6133,-1,6123,6134,6132,-1,2629,6135,6128,-1,2629,2631,6135,-1,1651,6136,6137,-1,6136,1651,1650,-1,6132,6138,6139,-1,6132,6140,6138,-1,6141,6142,6143,-1,6144,6142,6141,-1,6145,6146,6147,-1,6148,6146,6145,-1,6149,6150,6151,-1,6152,6150,6149,-1,6153,6151,1700,-1,6149,6151,6153,-1,6154,6155,6156,-1,6143,6155,6154,-1,6157,6158,6159,-1,6147,6158,6157,-1,6160,6161,1217,-1,6160,6162,6161,-1,6163,6164,6165,-1,6166,6164,6163,-1,1221,6167,3899,-1,6168,6167,1221,-1,6169,6170,6171,-1,6169,6172,6170,-1,6173,6174,6175,-1,6176,6174,6173,-1,6177,6178,3898,-1,6170,6178,6177,-1,1228,6173,3897,-1,3902,6173,1228,-1,6161,6179,6180,-1,6161,6181,6179,-1,6163,6182,6183,-1,6163,6184,6182,-1,6185,1219,3609,-1,1220,1219,6185,-1,6184,6186,6187,-1,6184,6188,6186,-1,6179,2625,1237,-1,6179,2626,2625,-1,6189,6190,6191,-1,6190,6189,6192,-1,6189,6193,6194,-1,6189,6195,6193,-1,2622,3609,6196,-1,6185,3609,2622,-1,6197,1227,1226,-1,1227,6197,6198,-1,6199,6200,6201,-1,6199,6202,6200,-1,6203,6204,6205,-1,6202,6204,6203,-1,5600,2621,3610,-1,6206,2621,5600,-1,1243,1232,1244,-1,1233,1232,1243,-1,1236,6207,6208,-1,1236,1235,6207,-1,6209,6210,6211,-1,6212,6210,6209,-1,6213,6214,6211,-1,6213,6215,6214,-1,6216,1242,1241,-1,1242,6216,6217,-1,6218,6208,6207,-1,6208,6218,6219,-1,6218,6129,6220,-1,6218,6221,6129,-1,6215,6222,6214,-1,6215,6223,6222,-1,6217,6224,6131,-1,6217,6216,6224,-1,6225,6226,6227,-1,6225,6228,6226,-1,6229,6230,6231,-1,6232,6230,6229,-1,6233,6234,6235,-1,6233,6236,6234,-1,6237,6238,6239,-1,6240,6238,6237,-1,6241,6242,6243,-1,6244,6242,6241,-1,6243,1247,1246,-1,6243,6245,1247,-1,6246,6247,6248,-1,6246,6249,6247,-1,6250,6251,6252,-1,6253,6251,6250,-1,6254,6255,6256,-1,6254,6257,6255,-1,6258,6259,6260,-1,6261,6259,6258,-1,6262,6263,6264,-1,6260,6263,6262,-1,6248,6265,6266,-1,6248,6247,6265,-1,1249,6252,3892,-1,6250,6252,1249,-1,6256,6267,6268,-1,6256,6255,6267,-1,6267,6269,6270,-1,6267,6271,6269,-1,1252,6264,1253,-1,6262,6264,1252,-1,6272,6111,6108,-1,6272,6273,6111,-1,6274,6275,1255,-1,6276,6275,6274,-1,6277,2620,1250,-1,6277,6278,2620,-1,6270,6279,6280,-1,6270,6269,6279,-1,6281,6274,6282,-1,6283,6274,6281,-1,6284,2620,6285,-1,1256,2620,6284,-1,6286,6280,6287,-1,6288,6280,6286,-1,6289,3891,6290,-1,6291,3891,6289,-1,6116,6144,6092,-1,6116,6292,6144,-1,6293,6294,6148,-1,6285,6294,6293,-1,6295,6296,6152,-1,6287,6296,6295,-1,6297,6236,6233,-1,6244,6298,6242,-1,6299,6236,6297,-1,6299,6300,6236,-1,6230,6300,6299,-1,6230,6301,6300,-1,6232,6301,6230,-1,6232,6240,6301,-1,6302,6240,6232,-1,6302,6238,6240,-1,6303,6238,6302,-1,6303,6304,6238,-1,6228,6304,6303,-1,6228,6305,6304,-1,6225,6305,6228,-1,6225,6244,6305,-1,6225,6298,6244,-1,6306,6307,6308,-1,6309,6307,6306,-1,6310,6311,6312,-1,6310,6313,6311,-1,6308,6314,6306,-1,6312,6314,6308,-1,6315,3611,6316,-1,2619,3611,6315,-1,6317,6318,6319,-1,6317,6320,6318,-1,6321,6322,6323,-1,6322,6321,6324,-1,6325,6326,6327,-1,6325,6328,6326,-1,6329,6330,6331,-1,6330,6329,6319,-1,6332,6333,6334,-1,6335,6333,6332,-1,6336,6327,6337,-1,6325,6327,6336,-1,6338,6339,6340,-1,6339,6338,6341,-1,6342,6343,6344,-1,6343,6342,6345,-1,6346,6347,6348,-1,6346,6349,6347,-1,6350,6351,6352,-1,6350,6353,6351,-1,6354,6355,6356,-1,6354,6357,6355,-1,6358,6359,6353,-1,6358,6360,6359,-1,6361,6355,6362,-1,6355,6361,6363,-1,6364,1770,6365,-1,6364,6348,1770,-1,1264,6366,1265,-1,1264,6367,6366,-1,6368,2612,2614,-1,2612,6368,6369,-1,6370,6371,6372,-1,6370,6373,6371,-1,6374,6375,6376,-1,6375,6374,6377,-1,2616,1261,2615,-1,1261,2616,6378,-1,6372,6379,6380,-1,6372,6381,6379,-1,2604,6382,1267,-1,6375,6382,2604,-1,2611,2600,2613,-1,2611,2610,2600,-1,2606,6383,2607,-1,2606,2609,6383,-1,6384,6379,6385,-1,6379,6384,6386,-1,3614,1263,6387,-1,1259,1263,3614,-1,2600,2603,2602,-1,2600,2599,2603,-1,2598,2596,2599,-1,2598,1269,2596,-1,6388,6383,6389,-1,6383,6388,6390,-1,1272,6384,2597,-1,6384,1272,6391,-1,6392,3614,6393,-1,1268,3614,6392,-1,2603,6394,3615,-1,2603,6395,6394,-1,6396,2596,3616,-1,6395,2596,6396,-1,6388,6397,6398,-1,6388,6399,6397,-1,6392,6400,6401,-1,6392,6402,6400,-1,6403,2594,6402,-1,6403,3617,2594,-1,6404,6396,6405,-1,6406,6396,6404,-1,6407,6408,6409,-1,6407,6398,6408,-1,6410,6411,6412,-1,6410,3888,6411,-1,6411,6413,6414,-1,6411,6415,6413,-1,2595,6416,6417,-1,3617,6416,2595,-1,1276,1277,3887,-1,1276,1278,1277,-1,6418,6419,6420,-1,6419,6418,6421,-1,6422,6418,6423,-1,6418,6422,6424,-1,6425,2591,2593,-1,6426,2591,6425,-1,6427,6428,6429,-1,6428,6427,6430,-1,6431,6313,6310,-1,6431,6424,6313,-1,6432,6425,6433,-1,6434,6425,6432,-1,6435,6436,6102,-1,6437,6436,6435,-1,6438,2617,2619,-1,6438,6432,2617,-1,6439,6440,1758,-1,6439,6441,6440,-1,6442,6443,6444,-1,6442,6445,6443,-1,6446,6447,6448,-1,6447,6446,6449,-1,6450,2586,2587,-1,6451,2586,6450,-1,6452,6453,6454,-1,6452,6455,6453,-1,2585,6456,6457,-1,2585,2584,6456,-1,3878,6458,6459,-1,3878,6460,6458,-1,6461,6462,6459,-1,6461,6463,6462,-1,1295,6464,2584,-1,1295,6465,6464,-1,6466,1297,6467,-1,3881,1297,6466,-1,6468,6469,6470,-1,6468,6471,6469,-1,6472,6473,6474,-1,6473,6472,6475,-1,6475,6476,6477,-1,6475,6472,6476,-1,3879,3621,6478,-1,3879,3619,3621,-1,6479,6480,6481,-1,6479,6482,6480,-1,6483,6331,6330,-1,6331,6483,6484,-1,6485,6486,6487,-1,6486,6485,6488,-1,6489,6490,6484,-1,6489,6491,6490,-1,6492,6493,6494,-1,6495,6493,6492,-1,6496,2581,6497,-1,6496,2582,2581,-1,6470,3883,6468,-1,6470,6494,3883,-1,6335,6498,6333,-1,6335,6499,6498,-1,6500,6501,6328,-1,6495,6501,6500,-1,6486,1290,6499,-1,6488,1290,6486,-1,1286,6446,1287,-1,6449,6446,1286,-1,2590,6461,6502,-1,2590,2589,6461,-1,3622,6503,6504,-1,6505,6503,3622,-1,6506,3884,6507,-1,6508,3884,6506,-1,6454,6474,6473,-1,6454,6457,6474,-1,6509,6510,6460,-1,6510,6509,6511,-1,6487,6512,6324,-1,6487,6486,6512,-1,6513,6514,6515,-1,6513,6516,6514,-1,6517,6518,2562,-1,6517,6519,6518,-1,1310,3624,1311,-1,1310,3625,3624,-1,6514,1302,6520,-1,6516,1302,6514,-1,6516,2578,1302,-1,6516,3624,2578,-1,6516,6521,3624,-1,6522,6518,1302,-1,6523,6518,6522,-1,6524,6518,6523,-1,3877,6518,6524,-1,1300,6518,3877,-1,1300,2579,6518,-1,6525,6526,2575,-1,6527,6526,6525,-1,6528,2574,6529,-1,1309,2574,6528,-1,6530,3630,2567,-1,6530,2572,3630,-1,2565,2571,6531,-1,2564,2571,2565,-1,2563,3628,1312,-1,2563,6532,3628,-1,6533,6534,6535,-1,6533,6536,6534,-1,6537,6538,6539,-1,6537,6540,6538,-1,3629,2577,1304,-1,2569,2577,3629,-1,6541,6528,6527,-1,6541,6542,6528,-1,2563,6513,6543,-1,3631,6513,2563,-1,6544,2562,2561,-1,6517,2562,6544,-1,6545,6546,6547,-1,6545,6548,6546,-1,6549,6550,6551,-1,6550,6549,6552,-1,6553,6554,6555,-1,6553,6357,6554,-1,6556,6346,6557,-1,6556,6558,6346,-1,6343,6559,6560,-1,6559,6343,6561,-1,6562,6556,6563,-1,6556,6562,6564,-1,6565,6566,6567,-1,6566,6565,6568,-1,6569,6570,6571,-1,6569,6564,6570,-1,6572,6573,6574,-1,6575,6573,6572,-1,6576,6577,6578,-1,6548,6577,6576,-1,6579,6572,6580,-1,6579,6581,6572,-1,6582,6340,6583,-1,6338,6340,6582,-1,6584,6545,6585,-1,6584,6586,6545,-1,6587,6582,6575,-1,6587,6588,6582,-1,1305,6589,6540,-1,3632,6589,1305,-1,6590,2576,6591,-1,6590,6592,2576,-1,6593,2573,6594,-1,6593,6595,2573,-1,6596,6536,6597,-1,6596,6534,6536,-1,6598,6599,6597,-1,6598,6600,6599,-1,2559,6601,6602,-1,2559,3876,6601,-1,6603,6604,6605,-1,6603,6606,6604,-1,3875,1316,6607,-1,3875,1313,1316,-1,6608,6609,6580,-1,6610,6609,6608,-1,6611,6612,6613,-1,6611,6614,6612,-1,6615,6616,6617,-1,6616,6615,6618,-1,6619,6620,6621,-1,6619,6622,6620,-1,6620,6571,6570,-1,6620,6623,6571,-1,6547,6357,6354,-1,6547,6554,6357,-1,6624,6625,6568,-1,6624,6626,6625,-1,6627,3674,6628,-1,3674,6627,6629,-1,6630,1542,2400,-1,6630,2557,1542,-1,6631,6632,6633,-1,6631,6634,6632,-1,6635,3817,6636,-1,6635,6637,3817,-1,1386,2537,2133,-1,1387,2537,1386,-1,3867,2534,3775,-1,2535,2534,3867,-1,3633,1335,1334,-1,3633,3635,1335,-1,1340,3641,1343,-1,2552,3641,1340,-1,3870,2551,2499,-1,3641,2551,3870,-1,2502,3849,2549,-1,3849,2502,1362,-1,2545,3760,1364,-1,2545,3869,3760,-1,1362,1357,2547,-1,1357,1362,1361,-1,2214,3644,3868,-1,2214,3646,3644,-1,2542,2538,2543,-1,2542,2533,2538,-1,3647,1352,2541,-1,1353,1352,3647,-1,2218,2540,1382,-1,2218,2212,2540,-1,1341,3640,3639,-1,1341,1343,3640,-1,2212,3866,2540,-1,2132,3866,2212,-1,1345,2550,3800,-1,6638,2550,1345,-1,3757,1334,3639,-1,3757,3633,1334,-1,1392,1712,1623,-1,1394,1712,1392,-1,1393,3650,1394,-1,3650,1393,3651,-1,2439,1406,1405,-1,2525,1406,2439,-1,3865,1403,1402,-1,1785,1403,3865,-1,6639,3771,6640,-1,6639,2521,3771,-1,3657,2517,2518,-1,3657,3658,2517,-1,2512,3654,2513,-1,3654,2512,3655,-1,6641,6642,6643,-1,6641,6644,6642,-1,1418,6645,3754,-1,1418,3773,6645,-1,2509,2506,3661,-1,2506,2509,3662,-1,1979,1369,1457,-1,1979,2131,1369,-1,3637,1456,2494,-1,3637,2499,1456,-1,1450,1446,6646,-1,1450,1447,1446,-1,3857,6641,3789,-1,3856,6641,3857,-1,6647,1459,1465,-1,6648,1459,6647,-1,1971,2006,6649,-1,2007,2006,1971,-1,2056,2487,2057,-1,2056,6650,2487,-1,2483,3667,3666,-1,6651,3667,2483,-1,3855,6651,2483,-1,6651,3855,6652,-1,2102,3769,2103,-1,3769,2102,6653,-1,6654,6655,6656,-1,6654,6657,6655,-1,2479,2026,2022,-1,2026,2479,2160,-1,6658,6659,6660,-1,6659,6658,6661,-1,6662,6663,6664,-1,6662,1516,6663,-1,6665,6666,6667,-1,6666,6665,6668,-1,1511,1519,1509,-1,1511,2091,1519,-1,3671,6669,2221,-1,3671,3670,6669,-1,3672,6670,1964,-1,6670,3672,3727,-1,2400,1541,1537,-1,1541,2400,1542,-1,6671,3872,6630,-1,6671,6672,3872,-1,1539,1571,1540,-1,1539,2356,1571,-1,2469,1555,2467,-1,2469,3848,1555,-1,3689,1553,3848,-1,3689,1552,1553,-1,6673,1560,6674,-1,1561,1560,6673,-1,6673,6675,6676,-1,6673,6677,6675,-1,6678,3831,6679,-1,1701,3831,6678,-1,6680,2464,3680,-1,6681,2464,6680,-1,3729,2444,1575,-1,3729,6682,2444,-1,6683,2405,6684,-1,2405,6683,2406,-1,2458,1656,2459,-1,1584,1656,2458,-1,3696,6685,6686,-1,3696,2404,6685,-1,1574,1588,6687,-1,1588,1574,2443,-1,6688,1600,1695,-1,1600,6688,1601,-1,6689,1399,6690,-1,6689,2525,1399,-1,2527,3841,2528,-1,1634,3841,2527,-1,6691,1581,1690,-1,6691,1565,1581,-1,1786,1788,3678,-1,1786,6692,1788,-1,2532,2359,1787,-1,2532,6693,2359,-1,6694,1402,3712,-1,3865,1402,6694,-1,2442,1653,3681,-1,1653,2442,6695,-1,3840,2445,1647,-1,3840,2446,2445,-1,2444,2447,1573,-1,2444,2463,2447,-1,2419,2465,2420,-1,1538,2465,2419,-1,1538,1540,2465,-1,3834,3847,1689,-1,6696,3847,3834,-1,2225,2457,1608,-1,2225,1609,2457,-1,6697,1658,6698,-1,1658,6697,3838,-1,6699,6700,6698,-1,6699,2408,6700,-1,3691,6701,6702,-1,3691,1614,6701,-1,6703,2409,6704,-1,2409,6703,6705,-1,6706,2411,6707,-1,1613,2411,6706,-1,1686,3697,1687,-1,1696,3697,1686,-1,3682,1673,1706,-1,3836,1673,3682,-1,1599,1673,1672,-1,1599,1707,1673,-1,6708,6709,6710,-1,6711,6709,6708,-1,6712,6713,6714,-1,6713,6712,2432,-1,1209,1677,1678,-1,1209,1208,1677,-1,1679,1208,6309,-1,1679,1677,1208,-1,6715,3692,6105,-1,6715,2425,3692,-1,1680,3684,6690,-1,3684,1680,2412,-1,3833,3673,1692,-1,6716,3673,3833,-1,3832,2418,6717,-1,3693,2418,3832,-1,6718,6719,6720,-1,6718,6721,6719,-1,6686,2418,2417,-1,6685,2418,6686,-1,6722,2460,6723,-1,6722,6724,2460,-1,2438,1613,1611,-1,2438,2411,1613,-1,2436,6725,6726,-1,2436,2437,6725,-1,6154,6710,6709,-1,6154,6727,6710,-1,6728,6729,6707,-1,6729,6728,6156,-1,6724,6730,6687,-1,6724,6722,6730,-1,6731,2417,1693,-1,6731,6686,2417,-1,6732,6721,6733,-1,6719,6721,6732,-1,6689,6734,3843,-1,6735,6734,6689,-1,6722,6736,6730,-1,6722,6737,6736,-1,1693,6738,6731,-1,1693,1692,6738,-1,2403,2392,1792,-1,2392,2403,2396,-1,1782,2363,2361,-1,1782,2364,2363,-1,2376,3826,1604,-1,3826,2376,2394,-1,1720,2370,1627,-1,3709,2370,1720,-1,2391,1679,6739,-1,1679,2391,1598,-1,6740,3702,2390,-1,6741,3702,6740,-1,1728,2395,1716,-1,1728,3700,2395,-1,6742,1752,3709,-1,6742,2384,1752,-1,6743,6744,1764,-1,6744,6743,6745,-1,3706,2379,2380,-1,3705,2379,3706,-1,2451,1775,2450,-1,1775,2451,1776,-1,1767,2380,6746,-1,1767,3706,2380,-1,3711,3821,1739,-1,1769,3821,3711,-1,1742,6747,6748,-1,1779,6747,1742,-1,1745,6361,6749,-1,6361,1745,2369,-1,3611,6741,2388,-1,3611,2618,6741,-1,6750,6314,6751,-1,6750,6752,6314,-1,1619,2390,1617,-1,6740,2390,1619,-1,6753,6336,2385,-1,6336,6753,6754,-1,3823,6320,6317,-1,3823,1765,6320,-1,6323,1761,1760,-1,6322,1761,6323,-1,2371,6755,1754,-1,2371,2372,6755,-1,2385,6742,6753,-1,2384,6742,2385,-1,2379,1722,6745,-1,2379,3705,1722,-1,1736,2376,2375,-1,2376,1736,3699,-1,6756,3708,1740,-1,6756,6365,3708,-1,6757,6758,6746,-1,6759,6758,6757,-1,3822,2366,1768,-1,2366,3822,6360,-1,1623,1738,1622,-1,1738,1623,1739,-1,1711,2449,1709,-1,1711,6760,2449,-1,1548,6761,1549,-1,5212,6761,1548,-1,2527,6760,2522,-1,2526,6760,2527,-1,6762,2364,2399,-1,2364,6762,671,-1,5222,1705,6679,-1,1705,5222,5308,-1,6763,6694,3686,-1,6763,6692,6694,-1,2401,6764,6765,-1,6764,2401,3698,-1,1560,6766,6674,-1,1560,6767,6766,-1,1834,6768,3804,-1,6769,6768,1834,-1,3683,6677,1582,-1,6675,6677,3683,-1,2355,3730,3713,-1,2355,1914,3730,-1,3715,2250,2351,-1,1940,2250,3715,-1,2245,1861,2349,-1,2245,1864,1861,-1,6770,6771,6772,-1,6773,6771,6770,-1,6774,6775,6772,-1,6776,6775,6774,-1,6777,3845,6778,-1,6777,3719,3845,-1,6779,6780,6781,-1,6779,6733,6780,-1,1528,6782,1825,-1,6782,1528,2249,-1,1889,2341,2273,-1,1889,1829,2341,-1,2274,1831,3721,-1,2274,2341,1831,-1,6783,3726,6784,-1,6783,3724,3726,-1,1956,3725,1957,-1,3725,1956,6785,-1,2343,1831,1830,-1,3723,1831,2343,-1,3812,6786,6787,-1,3812,1896,6786,-1,6788,2352,1856,-1,6788,3714,2352,-1,6789,1833,6790,-1,6789,3722,1833,-1,1904,1813,1815,-1,1904,1814,1813,-1,1915,1801,1800,-1,1915,1914,1801,-1,2288,1871,1877,-1,2329,1871,2288,-1,3818,2347,6791,-1,2248,2347,3818,-1,6792,6793,6794,-1,6792,6795,6793,-1,6796,6797,6798,-1,6797,6796,6799,-1,6800,2354,2332,-1,2354,6800,6801,-1,2330,3732,3731,-1,2330,6802,3732,-1,6803,2277,6804,-1,6805,2277,6803,-1,6806,3810,2282,-1,3810,6806,6807,-1,1931,2279,2258,-1,6808,2279,1931,-1,6809,6810,6811,-1,6810,6809,6812,-1,6813,6814,6634,-1,6814,6813,6815,-1,6816,6817,2325,-1,6817,6816,2720,-1,1881,3746,6818,-1,1881,1880,3746,-1,1875,1933,1876,-1,1933,1875,1913,-1,6819,6818,3746,-1,6819,6820,6818,-1,6821,2288,2287,-1,2288,6821,2306,-1,6822,6823,6824,-1,6822,1938,6823,-1,6825,6821,6826,-1,6825,6827,6821,-1,2299,2300,1900,-1,2300,2299,3738,-1,6828,1905,1936,-1,3811,1905,6828,-1,2306,6827,2307,-1,2306,6821,6827,-1,1850,2305,6829,-1,1850,1849,2305,-1,2227,6830,1902,-1,6830,2227,6831,-1,3738,2295,2296,-1,2298,2295,3738,-1,6832,5568,2304,-1,6833,5568,6832,-1,5569,6834,6835,-1,5569,6836,6834,-1,6837,6838,6774,-1,6838,6837,6684,-1,6786,6839,6840,-1,6841,6839,6786,-1,6842,1963,6843,-1,1963,6842,6844,-1,6845,6846,6847,-1,6787,6846,6845,-1,6824,2339,6822,-1,6824,2292,2339,-1,2329,1872,1871,-1,2329,1859,1872,-1,6848,2286,6849,-1,6848,2246,2286,-1,1908,1823,2285,-1,1908,1911,1823,-1,3813,6848,6850,-1,6819,6848,3813,-1,2278,6805,6851,-1,2277,6805,2278,-1,2278,1941,1940,-1,2278,2249,1941,-1,6825,1087,5722,-1,6825,6852,1087,-1,1922,2268,6853,-1,2268,1922,2269,-1,2268,3742,2272,-1,2267,3742,2268,-1,1927,6854,6855,-1,1927,3743,6854,-1,5656,6856,6857,-1,6858,6856,5656,-1,6859,6860,6861,-1,6862,6860,6859,-1,3744,6863,6864,-1,6863,3744,2264,-1,1920,6857,1921,-1,6857,1920,5656,-1,5650,6865,3809,-1,5649,6865,5650,-1,6866,6867,6868,-1,6867,6866,6869,-1,6870,6871,6872,-1,6864,6871,6870,-1,6873,6874,6875,-1,6874,6873,6876,-1,6877,1870,1869,-1,6877,6866,1870,-1,3732,6878,2263,-1,3732,6802,6878,-1,3816,6879,6880,-1,3816,1867,6879,-1,6799,6881,2265,-1,6799,6796,6881,-1,2720,6882,6817,-1,2720,6883,6882,-1,1884,5700,2317,-1,5700,1884,2257,-1,3735,5692,2319,-1,3735,3930,5692,-1,1881,5694,1882,-1,5694,1881,6884,-1,6885,2316,2321,-1,5697,2316,6885,-1,1886,6886,6887,-1,1886,1879,6886,-1,5721,2307,6827,-1,6888,2307,5721,-1,6889,3928,6890,-1,6889,6828,3928,-1,3571,1938,3745,-1,3571,6823,1938,-1,3748,1530,1824,-1,3748,1531,1530,-1,2250,2345,3814,-1,1821,2345,2250,-1,1804,2354,2245,-1,1804,2332,2354,-1,6891,1887,2322,-1,2287,1887,6891,-1,1951,6635,2243,-1,6635,1951,1328,-1,6892,6893,6894,-1,6895,6893,6892,-1,6896,6773,6770,-1,6896,6897,6773,-1,6632,6898,6899,-1,6632,6900,6898,-1,6897,6901,6773,-1,6897,6633,6901,-1,2222,1951,1947,-1,1951,2222,1952,-1,2237,1967,6902,-1,1967,2237,2239,-1,6903,6904,6905,-1,6903,1522,6904,-1,6905,6658,3850,-1,6658,6905,6904,-1,6906,2474,6907,-1,6906,6908,2474,-1,1970,2235,1471,-1,2233,2235,1970,-1,6905,6909,6903,-1,6905,6910,6909,-1,6790,1832,1957,-1,6790,1833,1832,-1,6911,6633,6897,-1,6631,6633,6911,-1,3804,3695,1797,-1,3804,2407,3695,-1,1607,6912,2226,-1,1607,1659,6912,-1,6847,6913,6845,-1,6847,6914,6913,-1,6842,6781,6915,-1,6842,6779,6781,-1,1529,1532,6907,-1,1532,1529,1533,-1,3750,6916,2220,-1,6917,6916,3750,-1,6917,6918,6919,-1,6917,3750,6918,-1,1976,1382,2216,-1,1382,1976,2218,-1,2497,6920,6921,-1,2497,3663,6920,-1,1432,6922,3858,-1,1432,3801,6922,-1,3657,1411,1410,-1,2520,1411,3657,-1,1513,2107,1514,-1,6923,2107,1513,-1,6924,2113,3779,-1,6924,6925,2113,-1,6926,6927,6928,-1,6927,6926,6929,-1,6930,6931,6932,-1,6931,6930,6933,-1,6934,6935,6936,-1,6935,6934,2192,-1,6937,3781,6938,-1,6937,2193,3781,-1,6939,1992,1991,-1,6940,1992,6939,-1,1989,6940,1990,-1,1992,6940,1989,-1,2110,6941,2111,-1,3660,6941,2110,-1,2034,1430,3858,-1,2033,1430,2034,-1,3864,3861,6942,-1,3864,6943,3861,-1,6944,2207,6945,-1,2207,6944,1986,-1,3863,2507,3661,-1,1412,2507,3863,-1,3773,2123,6645,-1,3756,2123,3773,-1,3658,1410,2514,-1,1410,3658,3657,-1,6946,2125,2009,-1,2203,2125,6946,-1,3656,2510,3660,-1,3656,3655,2510,-1,2195,2200,6947,-1,2194,2200,2195,-1,3757,2493,2127,-1,2493,3757,3639,-1,2511,2196,2141,-1,2511,2065,2196,-1,2506,2512,3659,-1,2505,2512,2506,-1,2508,6948,6949,-1,2508,6950,6948,-1,1991,3799,6939,-1,2016,3799,1991,-1,2157,3852,2146,-1,3852,2157,6951,-1,2190,1364,3760,-1,2190,2191,1364,-1,6952,6953,6954,-1,6952,6955,6953,-1,3761,2032,2187,-1,3761,2027,2032,-1,6956,6957,6958,-1,6959,6957,6956,-1,6960,3755,2118,-1,3755,6960,6961,-1,2092,3669,2159,-1,2092,2185,3669,-1,2088,3795,2077,-1,2047,3795,2088,-1,2183,2073,2075,-1,2183,2181,2073,-1,6962,3793,6963,-1,3793,6962,2070,-1,3792,6964,2166,-1,2490,3792,2089,-1,6964,3792,2490,-1,2180,6965,6966,-1,2179,6965,2180,-1,6967,2171,3764,-1,6967,3765,2171,-1,6968,6969,6970,-1,6969,6968,6971,-1,2171,1499,6972,-1,2170,1499,2171,-1,6973,2069,6974,-1,3794,2069,6973,-1,2161,2066,2162,-1,6975,2066,2161,-1,3780,1491,3763,-1,3780,1492,1491,-1,2054,1493,2487,-1,3766,1493,2054,-1,3762,3790,6976,-1,3790,3762,3797,-1,2108,2478,2477,-1,2108,2104,2478,-1,6639,2481,2480,-1,2481,6639,6640,-1,6665,3782,2189,-1,6977,3782,6665,-1,2148,6978,2105,-1,2148,3769,6978,-1,2190,2498,2191,-1,2190,2155,2498,-1,6646,2094,2093,-1,2094,6646,6979,-1,6980,2151,2150,-1,6980,6981,2151,-1,2219,6982,6983,-1,2219,6984,6982,-1,6985,6667,6666,-1,6985,6986,6667,-1,6984,3769,6982,-1,6984,6978,3769,-1,6933,6987,6988,-1,6933,6930,6987,-1,3799,3786,6939,-1,3786,3799,3787,-1,2104,3768,2478,-1,2104,2106,3768,-1,6976,3783,6989,-1,6976,3790,3783,-1,3762,3668,2185,-1,3668,3762,6976,-1,2163,6967,2087,-1,2163,2067,6967,-1,6990,3759,6991,-1,6990,3758,3759,-1,6992,2081,6993,-1,6994,2081,6992,-1,2072,6995,6996,-1,2072,2071,6995,-1,3781,1988,1990,-1,2211,1988,3781,-1,6997,2039,1485,-1,2039,6997,2040,-1,3858,2037,2034,-1,6922,2037,3858,-1,2061,2085,2172,-1,2085,2061,2086,-1,6996,2083,2072,-1,2161,2083,6996,-1,2505,3655,2512,-1,2505,2510,3655,-1,1423,2517,2516,-1,1423,1426,2517,-1,6644,6998,6642,-1,3803,6998,6644,-1,2003,2135,2002,-1,2003,6999,2135,-1,6656,7000,7001,-1,6655,7000,6656,-1,2548,3645,7001,-1,2548,1359,3645,-1,3637,3870,2499,-1,3870,3637,3871,-1,6919,6657,6654,-1,6919,6918,6657,-1,1455,2191,2498,-1,2191,1455,1365,-1,2098,7002,3634,-1,2097,7002,2098,-1,3753,2504,2209,-1,1436,2504,3753,-1,3803,7003,6998,-1,3803,3802,7003,-1,7004,2200,2199,-1,2200,7004,3802,-1,2115,2209,2117,-1,3753,2209,2115,-1,2116,1424,1422,-1,1424,2116,7005,-1,3659,3661,2506,-1,3659,3863,3661,-1,3660,2113,6941,-1,3660,2114,2113,-1,2082,2072,2083,-1,3793,2072,2082,-1,2086,2060,7006,-1,2086,2061,2060,-1,2167,2182,2046,-1,2182,2167,2073,-1,2071,7007,6995,-1,7007,2071,6993,-1,2070,6993,2071,-1,6992,6993,2070,-1,7008,6991,2076,-1,6990,6991,7008,-1,3764,2087,6967,-1,2173,2087,3764,-1,3785,6989,3783,-1,6989,3785,6923,-1,3784,6653,2102,-1,3784,7009,6653,-1,2105,3767,2106,-1,2105,6664,3767,-1,7010,6954,6953,-1,7011,6954,7010,-1,3665,7012,1508,-1,3665,7013,7012,-1,6669,6978,6984,-1,6669,6662,6978,-1,6986,7014,3791,-1,6985,7014,6986,-1,6983,7015,7016,-1,6983,6982,7015,-1,3763,2056,2058,-1,3763,1491,2056,-1,6668,2545,2152,-1,6668,3869,2545,-1,6662,2105,6978,-1,2105,6662,6664,-1,6986,7017,6667,-1,3797,7017,6986,-1,6933,1408,7018,-1,6933,6988,1408,-1,2480,1505,6639,-1,2480,6652,1505,-1,2477,1512,1514,-1,2475,1512,2477,-1,3796,2146,2041,-1,3796,2019,2146,-1,2036,2090,2181,-1,2090,2036,2038,-1,2179,1495,6965,-1,2179,2057,1495,-1,6921,7019,6966,-1,6921,6920,7019,-1,2087,7006,2163,-1,2086,7006,2087,-1,2080,2048,7020,-1,2080,2049,2048,-1,2043,2076,6991,-1,2076,2043,2079,-1,6969,1453,2154,-1,6971,1453,6969,-1,1454,1453,6971,-1,6996,2069,2068,-1,6995,2069,6996,-1,3765,2067,3794,-1,6967,2067,3765,-1,6966,2139,6921,-1,6965,2139,6966,-1,2064,7020,2048,-1,2063,7020,2064,-1,2070,7021,6992,-1,2070,6962,7021,-1,2487,2055,2054,-1,2055,2487,6650,-1,2142,1486,2143,-1,1473,1486,2142,-1,2042,1510,1477,-1,2042,2041,1510,-1,2025,2040,6997,-1,2025,2033,2040,-1,6945,1427,3859,-1,6945,2207,1427,-1,6955,6961,6953,-1,6955,7022,6961,-1,6959,1986,6944,-1,1986,6959,1987,-1,7010,2187,2032,-1,6960,2187,7010,-1,6997,2023,2025,-1,2188,2023,6997,-1,3759,2019,3796,-1,3759,2020,2019,-1,6977,2157,3782,-1,6951,2157,6977,-1,1508,3799,1506,-1,1508,3787,3799,-1,7005,3860,1424,-1,7023,3860,7005,-1,1417,2516,7024,-1,1423,2516,1417,-1,1515,6663,1516,-1,1515,7025,6663,-1,2009,2124,2010,-1,2009,2125,2124,-1,6649,1972,1971,-1,6649,2138,1972,-1,2009,7026,6946,-1,2009,2008,7026,-1,2514,2515,3658,-1,2514,2513,2515,-1,2122,6645,2123,-1,6645,2122,1437,-1,1999,1998,1997,-1,1999,2001,1998,-1,7023,3859,3860,-1,6945,3859,7023,-1,7027,6945,7023,-1,7027,6944,6945,-1,6943,1421,3861,-1,6943,2210,1421,-1,2492,1996,2120,-1,1996,2492,1482,-1,2209,1435,1995,-1,2209,2504,1435,-1,6941,2149,2111,-1,2149,6941,7028,-1,1989,1993,1992,-1,1993,1989,2145,-1,3786,6937,6938,-1,3786,3788,6937,-1,7012,6936,6935,-1,7012,7013,6936,-1,6932,6949,6948,-1,6949,6932,6931,-1,6927,7029,6928,-1,7018,7029,6927,-1,1515,6924,7025,-1,1515,6925,6924,-1,2149,1517,1534,-1,1517,2149,7028,-1,1416,3754,2115,-1,1416,1418,3754,-1,3766,1494,1493,-1,1494,3766,1984,-1,2196,6921,2139,-1,2196,2497,6921,-1,2196,2197,2497,-1,1973,3853,2213,-1,3853,1973,1975,-1,6659,6917,1974,-1,6917,6659,6916,-1,6843,6779,6842,-1,6843,7030,6779,-1,2226,6831,2227,-1,2226,6912,6831,-1,1325,1469,1329,-1,1325,1467,1469,-1,6814,2247,6900,-1,7031,2247,6814,-1,7032,1968,1961,-1,7032,6910,1968,-1,6844,3672,1963,-1,6844,7033,3672,-1,2337,3722,6789,-1,2336,3722,2337,-1,3815,1959,3747,-1,3815,7034,1959,-1,7033,3727,3672,-1,7033,3728,3727,-1,1856,1808,1857,-1,1856,2352,1808,-1,2473,6907,2474,-1,6907,2473,1529,-1,6660,1974,7035,-1,1974,6660,6659,-1,6770,6894,6896,-1,6892,6894,6770,-1,6634,6900,6632,-1,6634,6814,6900,-1,7036,6897,6896,-1,7036,6911,6897,-1,1330,6788,6637,-1,6788,1330,7037,-1,1845,2285,1943,-1,1845,1909,2285,-1,1522,7038,6904,-1,1521,7038,1522,-1,1521,7039,7038,-1,1939,6823,3571,-1,1939,1892,6823,-1,1935,6828,1936,-1,3928,6828,1935,-1,2307,7040,2308,-1,7040,2307,6888,-1,1893,3926,2313,-1,3926,1893,3807,-1,6883,2321,6882,-1,2321,6883,6885,-1,6818,6884,1881,-1,6884,6818,5690,-1,3808,2319,5692,-1,3808,1933,2319,-1,2317,7041,7042,-1,5700,7041,2317,-1,6887,1883,1886,-1,6887,2256,1883,-1,2265,7043,6799,-1,3744,7043,2265,-1,6880,7044,3816,-1,6861,7044,6880,-1,2263,1923,3733,-1,2263,2262,1923,-1,2258,1932,1931,-1,1932,2258,2260,-1,7045,1869,6807,-1,7045,6877,1869,-1,6878,6875,6874,-1,6878,6802,6875,-1,6856,1867,6801,-1,6856,6879,1867,-1,6877,6869,6866,-1,6869,6877,5645,-1,1932,5650,3809,-1,5650,1932,7046,-1,6864,5653,6871,-1,5653,6864,6863,-1,7047,6861,6880,-1,6859,6861,7047,-1,7048,2263,6878,-1,2261,2263,7048,-1,1928,7049,1929,-1,5616,7049,1928,-1,2272,6853,2268,-1,6853,2272,7049,-1,6853,1919,1922,-1,1919,6853,7050,-1,3715,2276,2278,-1,7051,2276,3715,-1,6849,6850,6848,-1,6850,6849,6798,-1,2320,6791,7052,-1,2320,3818,6791,-1,1905,2346,2289,-1,2346,1905,1904,-1,1818,7053,7054,-1,1818,2229,7053,-1,6915,6844,6842,-1,6844,6915,7055,-1,7056,3725,3724,-1,7057,3725,7056,-1,1798,6783,1799,-1,6783,1798,7058,-1,1903,7059,1901,-1,1903,3812,7059,-1,5567,2304,5568,-1,5567,2305,2304,-1,5565,6831,5564,-1,5565,6830,6831,-1,1900,1851,1579,-1,1851,1900,2300,-1,7060,1902,6830,-1,7060,1899,1902,-1,6829,1852,1850,-1,6834,1852,6829,-1,6889,3811,6828,-1,1811,3811,6889,-1,6826,6852,6825,-1,6826,2314,6852,-1,6824,1892,1891,-1,6824,6823,1892,-1,6826,2287,6891,-1,2287,6826,6821,-1,2324,7061,7062,-1,2324,7042,7061,-1,1874,6819,3813,-1,6819,1874,6820,-1,6815,7031,6814,-1,7031,6815,1807,-1,6812,7036,6810,-1,7036,6812,6794,-1,3717,7052,6791,-1,3717,7063,7052,-1,1930,2282,3740,-1,2282,1930,6806,-1,2276,6804,2277,-1,2276,6872,6804,-1,6801,1866,2354,-1,6801,1867,1866,-1,1800,6873,1915,-1,1800,2327,6873,-1,2286,3816,7044,-1,2286,1865,3816,-1,6799,7064,6797,-1,7064,6799,7043,-1,2236,6809,2242,-1,2236,7065,6809,-1,7066,6795,7067,-1,7066,6793,6795,-1,2348,1907,2349,-1,1907,2348,1906,-1,1872,2248,1873,-1,1872,1858,2248,-1,1850,1851,3737,-1,1850,1852,1851,-1,1797,7068,6914,-1,3695,7068,1797,-1,1828,2340,2344,-1,1843,2340,1828,-1,7059,6787,6845,-1,7059,3812,6787,-1,3713,7069,3819,-1,3730,7069,3713,-1,1969,2226,1901,-1,2226,1969,1607,-1,6841,6789,6839,-1,2337,6789,6841,-1,1799,6784,1835,-1,1799,6783,6784,-1,1827,2334,1955,-1,1966,2334,1827,-1,1943,1822,1941,-1,1822,1943,1823,-1,7070,7071,6838,-1,7072,7071,7070,-1,7030,6733,6779,-1,7030,6732,6733,-1,2555,6778,2556,-1,2555,6777,6778,-1,7053,6776,7054,-1,7053,6775,6776,-1,6773,2554,6771,-1,6901,2554,6773,-1,7054,1819,1818,-1,7054,7073,1819,-1,3819,1803,1805,-1,1803,3819,7069,-1,7074,3683,1564,-1,7074,6675,3683,-1,1836,6769,1834,-1,7075,6769,1836,-1,6768,7076,7077,-1,7076,6768,6769,-1,1562,6767,1560,-1,6767,1562,1795,-1,5312,1794,1793,-1,5312,5313,1794,-1,2440,1568,1788,-1,2440,2441,1568,-1,2471,3831,1702,-1,2471,5221,3831,-1,2471,456,5221,-1,3680,1789,6680,-1,2362,1789,3680,-1,3865,6692,1786,-1,3865,6694,6692,-1,3820,1634,1636,-1,1634,3820,3841,-1,3053,1555,1554,-1,3053,2414,1555,-1,1741,1732,643,-1,1741,2377,1732,-1,2394,5312,1793,-1,2394,614,5312,-1,2368,6361,2369,-1,2368,6363,6361,-1,1774,1737,1772,-1,2378,1737,1774,-1,2377,1733,1732,-1,3711,1733,2377,-1,7078,7079,6759,-1,7078,7080,7079,-1,6365,1769,3708,-1,1769,6365,1770,-1,2368,1747,3710,-1,2368,2367,1747,-1,6744,3823,7081,-1,6744,1724,3823,-1,6337,2385,6336,-1,2386,2385,6337,-1,1754,7082,3829,-1,1754,6755,7082,-1,6322,2372,1761,-1,7083,2372,6322,-1,6317,7081,3823,-1,7084,7081,6317,-1,2386,7085,1725,-1,7085,2386,6337,-1,2453,1721,1626,-1,2453,1755,1721,-1,6752,6306,6314,-1,6306,6752,6739,-1,6309,6739,1679,-1,6309,6306,6739,-1,6749,7086,1745,-1,6749,7087,7086,-1,7088,1755,2453,-1,1755,7088,1756,-1,3704,7088,2451,-1,7088,3704,1756,-1,1735,1751,2393,-1,1735,1734,1751,-1,7086,1742,6748,-1,7086,3828,1742,-1,2381,6746,2380,-1,2381,6757,6746,-1,1625,2452,1626,-1,1625,1624,2452,-1,1724,6745,1722,-1,1724,6744,6745,-1,1720,6742,3709,-1,1719,6742,1720,-1,3701,6739,6752,-1,6739,3701,2391,-1,3703,1619,1625,-1,1619,3703,6740,-1,1712,1709,1708,-1,1711,1709,1712,-1,1704,6679,1705,-1,1704,6678,6679,-1,7089,7090,7091,-1,7090,1594,7092,-1,7090,7089,1594,-1,1565,1628,1563,-1,6691,1628,1565,-1,6719,1594,1593,-1,6719,6732,1594,-1,7093,7090,7072,-1,7090,7093,7091,-1,6687,1585,6724,-1,1585,6687,1588,-1,6706,6157,3837,-1,6157,6706,7094,-1,6703,6159,7095,-1,6703,1669,6159,-1,6727,6156,6728,-1,6156,6727,6154,-1,2437,1651,6725,-1,2437,1652,1651,-1,2408,6704,2409,-1,2408,6699,6704,-1,1695,2403,1696,-1,1600,2403,1695,-1,1629,6691,3653,-1,1629,1628,6691,-1,1686,3693,3832,-1,3835,3693,1686,-1,6716,6764,7096,-1,6716,3833,6764,-1,7097,2421,1640,-1,2421,7097,1675,-1,6093,1668,2434,-1,6093,6095,1668,-1,6714,6701,6712,-1,6701,6714,6099,-1,1614,1660,1615,-1,1660,1614,3691,-1,1671,2428,2427,-1,1671,1664,2428,-1,7097,1676,1675,-1,1676,7097,3825,-1,1323,1557,2401,-1,1557,1323,1322,-1,6708,1682,2430,-1,6708,6710,1682,-1,2413,6707,2411,-1,2413,6728,6707,-1,6712,1614,1616,-1,1614,6712,6701,-1,3694,6728,2413,-1,6727,6728,3694,-1,2408,3687,6700,-1,2408,2461,3687,-1,1662,1615,1660,-1,1615,1662,1663,-1,2437,1653,1652,-1,1654,1653,2437,-1,2420,2464,6720,-1,2465,2464,2420,-1,1647,5571,1648,-1,5571,1647,1646,-1,2446,3839,6695,-1,2446,3840,3839,-1,1643,6695,2442,-1,6695,1643,2446,-1,2449,2526,1632,-1,2449,6760,2526,-1,1787,1396,2532,-1,1401,1396,1787,-1,3820,3678,2361,-1,3820,1786,3678,-1,3653,1690,1689,-1,3653,6691,1690,-1,6696,1566,3847,-1,1569,1566,6696,-1,6693,2439,2359,-1,2439,6693,2524,-1,1610,6913,7098,-1,1610,2224,6913,-1,1640,3652,1641,-1,3652,1640,2423,-1,2392,1604,3826,-1,1604,2392,1605,-1,6723,1601,6688,-1,6723,2460,1601,-1,1575,6687,6730,-1,6687,1575,1574,-1,7099,2404,6737,-1,6685,2404,7099,-1,7093,3675,7091,-1,3675,7093,6738,-1,1684,1590,7100,-1,1591,1590,1684,-1,6736,6683,7101,-1,2406,6683,6736,-1,1581,6781,6780,-1,6781,1581,2223,-1,3830,6762,2399,-1,6762,3830,5309,-1,3846,1701,6678,-1,1791,1701,3846,-1,2441,1566,1568,-1,3847,1566,2441,-1,7102,7077,7103,-1,7077,7102,6768,-1,6677,6674,7104,-1,6673,6674,6677,-1,7077,3677,7103,-1,1796,3677,7077,-1,2415,1547,1322,-1,2415,5213,1547,-1,1550,2468,1324,-1,1550,3690,2468,-1,5212,1547,5213,-1,1547,5212,1548,-1,3636,2557,2470,-1,3636,2558,2557,-1,2356,1535,3676,-1,2356,1536,1535,-1,2472,2558,3636,-1,1543,2558,2472,-1,1539,6629,6627,-1,6629,1539,2419,-1,1533,1531,2202,-1,1533,1529,1531,-1,1525,1824,1530,-1,1524,1824,1525,-1,6903,7105,7106,-1,7105,6903,6909,-1,2147,1511,3852,-1,2147,2091,1511,-1,1513,7011,7107,-1,1513,6954,7011,-1,2095,3852,6951,-1,2095,2147,3852,-1,6668,2151,6666,-1,2151,6668,2152,-1,6906,2221,2220,-1,2221,6906,3671,-1,3850,6660,3851,-1,3850,6658,6660,-1,7009,7015,6653,-1,7015,7009,7108,-1,3853,6656,3751,-1,6656,3853,6654,-1,2482,3665,1507,-1,2482,2481,3665,-1,3667,1507,3666,-1,3667,2482,1507,-1,6952,2475,1503,-1,6952,1512,2475,-1,2174,2484,1498,-1,7109,2484,2174,-1,2050,2176,2051,-1,2177,2176,2050,-1,1477,7110,2042,-1,7110,1477,2178,-1,2204,6999,3774,-1,2206,6999,2204,-1,2007,1970,1467,-1,2007,1971,1970,-1,7024,2515,7111,-1,2516,2515,7024,-1,2198,7002,7112,-1,2198,1333,7002,-1,2119,2199,2120,-1,7004,2199,2119,-1,1451,6646,2093,-1,1450,6646,1451,-1,1437,3754,6645,-1,3754,1437,1436,-1,1481,3801,1482,-1,1481,6922,3801,-1,1429,3860,3859,-1,3860,1429,1425,-1,7026,6643,6642,-1,7112,6643,7026,-1,6639,1504,2521,-1,6639,1505,1504,-1,2529,1399,2524,-1,2529,1400,1399,-1,1394,1638,1710,-1,3650,1638,1394,-1,6690,1398,1680,-1,6690,1399,1398,-1,2524,1639,1641,-1,2524,6693,1639,-1,2128,3639,1334,-1,3639,2128,1341,-1,2537,1348,1377,-1,2537,1349,1348,-1,2132,3867,3866,-1,2132,3777,3867,-1,2553,6638,3649,-1,2553,1339,6638,-1,1381,2501,1457,-1,1347,2501,1381,-1,1380,1375,2535,-1,1375,1380,1376,-1,1358,1361,1355,-1,1358,1357,1361,-1,1363,3776,2544,-1,1363,3778,3776,-1,2547,1359,2548,-1,2547,1357,1359,-1,3871,1343,3870,-1,3640,1343,3871,-1,1341,3800,2550,-1,3800,1341,2128,-1,3777,2535,3867,-1,1380,2535,3777,-1,1387,1385,1442,-1,1387,1386,1385,-1,1326,1329,3805,-1,1326,1325,1329,-1,7066,6634,6631,-1,6813,6634,7066,-1,6628,2357,6627,-1,6628,7113,2357,-1,1321,2402,1557,-1,1320,2402,1321,-1,6615,6568,6565,-1,6615,6624,6568,-1,6585,6547,6354,-1,6545,6547,6585,-1,6570,6621,6620,-1,6621,6570,7114,-1,6621,6604,6619,-1,6604,6621,6626,-1,6601,6618,7115,-1,6601,6616,6618,-1,6613,7116,6600,-1,6613,6612,7116,-1,1318,6610,6608,-1,1317,6610,1318,-1,1316,7117,1317,-1,1313,7117,1316,-1,6606,6619,6604,-1,6606,6595,6619,-1,6616,3876,6592,-1,3876,6616,6601,-1,6589,6600,6598,-1,6589,6613,6600,-1,6597,6538,6598,-1,6597,6536,6538,-1,2570,1313,1315,-1,7117,1313,2570,-1,3627,6595,6606,-1,6595,3627,2573,-1,2577,6592,3876,-1,6592,2577,2576,-1,6575,6583,6573,-1,6575,6582,6583,-1,6586,6548,6545,-1,6577,6548,6586,-1,6588,6338,6582,-1,6352,6338,6588,-1,6574,6580,6572,-1,6608,6580,6574,-1,6578,6614,6576,-1,6612,6614,6578,-1,6581,6575,6572,-1,6587,6575,6581,-1,6571,7118,6569,-1,7118,6571,7119,-1,6568,7120,6566,-1,7120,6568,6625,-1,6564,6558,6556,-1,6558,6564,6569,-1,6560,6567,6566,-1,6560,6559,6567,-1,6563,6557,7121,-1,6563,6556,6557,-1,6555,6561,6553,-1,6561,6555,6559,-1,6567,6552,6565,-1,6567,6550,6552,-1,6546,6554,6547,-1,6554,6546,6551,-1,7122,6517,6544,-1,7123,6517,7122,-1,6542,1309,6528,-1,6542,1307,1309,-1,2568,3626,1299,-1,3626,2568,2560,-1,6539,6544,6537,-1,6544,6539,7122,-1,7124,6535,6543,-1,7124,6533,6535,-1,6531,1315,1314,-1,2571,1315,6531,-1,2572,6594,2573,-1,6530,6594,2572,-1,7125,6526,6529,-1,7125,6591,6526,-1,6534,7126,7127,-1,6596,7126,6534,-1,6523,6541,6524,-1,6542,6541,6523,-1,7123,6519,6517,-1,7123,6520,6519,-1,3631,6516,6513,-1,3631,6521,6516,-1,7128,6324,6321,-1,7128,6487,6324,-1,6511,7129,6510,-1,7129,6511,6482,-1,6496,6454,6473,-1,6452,6454,6496,-1,6508,6469,7130,-1,6508,6506,6469,-1,3880,3622,3619,-1,3880,6505,3622,-1,2589,6463,6461,-1,2589,6450,6463,-1,1281,6465,1295,-1,1281,6444,6465,-1,1292,1287,6446,-1,1292,3882,1287,-1,7131,1297,1285,-1,7131,7132,1297,-1,7133,6495,6500,-1,6493,6495,7133,-1,7133,6333,6498,-1,7134,6333,7133,-1,6468,1291,6504,-1,6468,3883,1291,-1,6497,7135,7136,-1,6497,2581,7135,-1,1289,6494,6493,-1,1289,3883,6494,-1,6480,6484,6483,-1,6480,6489,6484,-1,3621,6488,6485,-1,3621,3620,6488,-1,7137,6484,6490,-1,7137,6331,6484,-1,6474,6481,6472,-1,6474,6479,6481,-1,6509,6478,6491,-1,6509,3879,6478,-1,2582,6477,2580,-1,2582,6475,6477,-1,2582,6473,6475,-1,6496,6473,2582,-1,6506,6470,6469,-1,7138,6470,6506,-1,7139,3881,6466,-1,7140,3881,7139,-1,6508,1286,3884,-1,7141,1286,6508,-1,6502,6459,6458,-1,6502,6461,6459,-1,3880,6459,6462,-1,3880,3878,6459,-1,2584,7129,6456,-1,7129,2584,6464,-1,1294,2585,6453,-1,1294,2583,2585,-1,1284,7142,7143,-1,1284,6447,7142,-1,1283,6447,1284,-1,2586,6447,1283,-1,2586,6448,6447,-1,6451,6448,2586,-1,6451,7144,6448,-1,2588,7144,6451,-1,2588,7145,7144,-1,3618,7145,2588,-1,3618,1280,7145,-1,3618,3885,1280,-1,3618,6442,3885,-1,3618,6445,6442,-1,7142,6449,7146,-1,7142,6447,6449,-1,7145,1282,1293,-1,7145,1280,1282,-1,6445,2590,6443,-1,6445,3618,2590,-1,2617,6433,6441,-1,6432,6433,2617,-1,6435,7147,7148,-1,7147,6435,3607,-1,6433,2593,7149,-1,6425,2593,6433,-1,7150,6424,6422,-1,6424,7150,6313,-1,7151,1279,6430,-1,1279,7151,6120,-1,6437,7152,6436,-1,6417,7152,6437,-1,6423,7153,6422,-1,6423,6414,7153,-1,6420,6423,6418,-1,6420,6412,6423,-1,1276,6428,1278,-1,1276,6409,6428,-1,7154,6417,6416,-1,7154,7152,6417,-1,6412,6414,6423,-1,6412,6411,6414,-1,7155,6412,6420,-1,7155,6410,6412,-1,6409,1275,6407,-1,1275,6409,1276,-1,6405,3616,6119,-1,6396,3616,6405,-1,3617,7156,6416,-1,6403,7156,3617,-1,6393,6402,6392,-1,6393,6403,6402,-1,6391,3888,6410,-1,6391,1272,3888,-1,6390,6398,6407,-1,6390,6388,6398,-1,6394,6396,6406,-1,6394,6395,6396,-1,3615,7157,7158,-1,3615,6394,7157,-1,6401,1268,6392,-1,3613,1268,6401,-1,6399,6389,7159,-1,6389,6399,6388,-1,3612,1269,2598,-1,3612,3889,1269,-1,6387,1262,7158,-1,1263,1262,6387,-1,6386,6380,6379,-1,6380,6386,7159,-1,1267,3890,1260,-1,6382,3890,1267,-1,6379,7160,6385,-1,6381,7160,6379,-1,6375,7161,6382,-1,6375,6377,7161,-1,6371,6381,6372,-1,6381,6371,7162,-1,6378,2614,1261,-1,2614,6378,6368,-1,2611,6367,1264,-1,2611,7163,6367,-1,6348,1771,1770,-1,6348,6347,1771,-1,6345,7164,7087,-1,6345,6342,7164,-1,6360,7165,2366,-1,6358,7165,6360,-1,6357,6362,6355,-1,6357,6553,6362,-1,6353,6584,6358,-1,6350,6584,6353,-1,7166,6347,6349,-1,7166,7167,6347,-1,6344,7168,6342,-1,6344,7121,7168,-1,6341,1773,6339,-1,1773,6341,7080,-1,6337,7169,7085,-1,6327,7169,6337,-1,7134,6334,6333,-1,7134,7170,6334,-1,7171,6331,7137,-1,6331,7171,6329,-1,6327,7172,7169,-1,6327,6326,7172,-1,6324,7083,6322,-1,7083,6324,6512,-1,7084,6319,6329,-1,7084,6317,6319,-1,7173,7085,7169,-1,7174,7085,7173,-1,1758,7147,1759,-1,1758,6440,7147,-1,7175,6312,6308,-1,6310,6312,7175,-1,7151,6308,6307,-1,7151,7175,6308,-1,7176,6290,7177,-1,6289,6290,7176,-1,7178,6287,6295,-1,6286,6287,7178,-1,7179,6285,6293,-1,6284,6285,7179,-1,6116,6282,6292,-1,6281,6282,6116,-1,7180,6291,6289,-1,7181,6291,7180,-1,7182,6286,7183,-1,7182,6288,6286,-1,7184,1256,6284,-1,1257,1256,7184,-1,7185,6281,7186,-1,7185,6283,6281,-1,6279,7187,7181,-1,6269,7187,6279,-1,7182,6277,7188,-1,6277,7182,6278,-1,1250,7189,6277,-1,3892,7189,1250,-1,6283,6276,6274,-1,6265,6276,6283,-1,3893,6108,7190,-1,3893,6272,6108,-1,7191,6262,1252,-1,7192,6262,7191,-1,6268,6270,7193,-1,6268,6267,6270,-1,7194,6268,7195,-1,7194,6256,6268,-1,6275,6250,1249,-1,7196,6250,6275,-1,7197,6266,6273,-1,7197,6248,6266,-1,6264,1246,1248,-1,6263,1246,6264,-1,6260,6241,6263,-1,6259,6241,6260,-1,6255,6237,7198,-1,6257,6237,6255,-1,6252,6235,7199,-1,6251,6235,6252,-1,6249,7200,6247,-1,6249,6229,7200,-1,6245,7201,1247,-1,6245,6227,7201,-1,6242,6245,6243,-1,6242,6298,6245,-1,6239,6304,6261,-1,6238,6304,6239,-1,6236,6254,6234,-1,6236,6300,6254,-1,6231,6299,6253,-1,6230,6299,6231,-1,6228,6246,6226,-1,6228,6303,6246,-1,6122,6216,7202,-1,6216,6122,6224,-1,6223,7203,7204,-1,6215,7203,6223,-1,6129,7205,6127,-1,6221,7205,6129,-1,6218,7206,6221,-1,6207,7206,6218,-1,1241,7202,6216,-1,1241,7207,7202,-1,7208,3894,7209,-1,7208,1243,3894,-1,6211,7210,6209,-1,6211,6214,7210,-1,7211,6212,6209,-1,1238,6212,7211,-1,6197,6208,7212,-1,6197,1236,6208,-1,1242,1232,1240,-1,1232,1242,1244,-1,7213,6206,5600,-1,6193,6206,7213,-1,6213,6202,6203,-1,6200,6202,6213,-1,6210,6201,6200,-1,1229,6201,6210,-1,1226,1236,6197,-1,1226,1234,1236,-1,6187,1232,3896,-1,6187,1240,1232,-1,6185,2621,1223,-1,6185,2622,2621,-1,6204,6189,6194,-1,6192,6189,6204,-1,7214,6192,6199,-1,7214,6190,6192,-1,6180,1237,2624,-1,6180,6179,1237,-1,1227,6188,1225,-1,6188,1227,6186,-1,1223,1220,6185,-1,1222,1220,1223,-1,1222,1221,1220,-1,7215,1221,1222,-1,6165,1225,6188,-1,6165,2628,1225,-1,6181,2626,6179,-1,6181,3901,2626,-1,7216,7217,7214,-1,6175,7217,7216,-1,6171,6177,6191,-1,6171,6170,6177,-1,6175,7218,7217,-1,6174,7218,6175,-1,6172,6178,6170,-1,6172,7219,6178,-1,3899,7220,7221,-1,6167,7220,3899,-1,6165,7222,2628,-1,6164,7222,6165,-1,6162,6181,6161,-1,6162,7223,6181,-1,7094,6147,6157,-1,6145,6147,7094,-1,6709,6143,6154,-1,6141,6143,6709,-1,7095,6149,6153,-1,7224,6149,7095,-1,7224,6152,6149,-1,6295,6152,7224,-1,7225,6148,6145,-1,6293,6148,7225,-1,7226,2631,7227,-1,6135,2631,7226,-1,6133,6139,6726,-1,6133,6132,6139,-1,7227,2630,5564,-1,2631,2630,7227,-1,6134,6140,6132,-1,6134,7228,6140,-1,6130,6137,6136,-1,6130,7229,6137,-1,6128,7230,2629,-1,6127,7230,6128,-1,6125,6134,6123,-1,6125,7231,6134,-1,1215,6104,6103,-1,1215,3886,6104,-1,7232,6102,6436,-1,6102,7232,6100,-1,1213,7233,7234,-1,7233,1213,3903,-1,7234,6119,1213,-1,7234,6405,6119,-1,7235,6088,6085,-1,7235,6114,6088,-1,7236,6089,7237,-1,7236,6115,6089,-1,6114,7238,6112,-1,7235,7238,6114,-1,7190,6110,6112,-1,7190,6108,6110,-1,6107,3692,6101,-1,3692,6107,6105,-1,2426,1211,1212,-1,2426,6106,1211,-1,6101,7239,6107,-1,6101,6100,7239,-1,6091,6711,6098,-1,6091,6090,6711,-1,6094,7240,6095,-1,6094,6087,7240,-1,6092,6141,6090,-1,6092,6144,6141,-1,6088,7241,6086,-1,6088,6117,7241,-1,6008,2649,2648,-1,7242,2649,6008,-1,7243,6003,6000,-1,7243,7244,6003,-1,7245,7244,7243,-1,7245,7246,7244,-1,7247,7246,7245,-1,7247,6004,7246,-1,7248,6004,7247,-1,1172,6004,7248,-1,1172,6007,6004,-1,1172,7249,6007,-1,1171,7249,1172,-1,1171,7242,7249,-1,2649,7242,1171,-1,6068,3927,6012,-1,6068,1082,3927,-1,6080,7250,6082,-1,6080,6066,7250,-1,6078,6072,7251,-1,6073,6072,6078,-1,6076,7252,3572,-1,6075,7252,6076,-1,6072,6057,7253,-1,6074,6057,6072,-1,6056,6070,6067,-1,6056,6084,6070,-1,6065,7254,6063,-1,6065,5987,7254,-1,7253,6058,6081,-1,6057,6058,7253,-1,6060,1207,6075,-1,6053,1207,6060,-1,6058,1203,7255,-1,1201,1203,6058,-1,3908,6071,6055,-1,3908,7256,6071,-1,2635,6009,1170,-1,2635,6069,6009,-1,6053,1205,1207,-1,6052,1205,6053,-1,1206,7257,7258,-1,3905,7257,1206,-1,3906,6050,1202,-1,3906,6047,6050,-1,7259,1199,3907,-1,3605,1199,7259,-1,7257,1192,7260,-1,1192,7257,3905,-1,6049,7261,6054,-1,6043,7261,6049,-1,7262,1195,1194,-1,7262,2634,1195,-1,1191,7263,1197,-1,1191,6040,7263,-1,7260,3909,1179,-1,3909,7260,1192,-1,6036,6042,7264,-1,6036,6044,6042,-1,1190,6040,1191,-1,1190,6039,6040,-1,7265,2650,5988,-1,7265,1194,2650,-1,6038,6044,6036,-1,6038,6006,6044,-1,1181,7266,3604,-1,1181,6002,7266,-1,1177,1176,1175,-1,1177,3909,1176,-1,6044,6005,6032,-1,6006,6005,6044,-1,6017,6030,5575,-1,6030,6017,6028,-1,2653,6022,5986,-1,2653,6020,6022,-1,5996,2638,6024,-1,5995,2638,5996,-1,6022,6083,6026,-1,6021,6083,6022,-1,6019,6028,6017,-1,6019,7267,6028,-1,3938,7254,6027,-1,1051,7254,3938,-1,6027,5987,5986,-1,7254,5987,6027,-1,1174,6008,1175,-1,7242,6008,1174,-1,7244,6038,6035,-1,7244,7246,6038,-1,6000,1181,7243,-1,6000,6002,1181,-1,7265,5998,5999,-1,7268,5998,7265,-1,1185,5991,1188,-1,7269,5991,1185,-1,7270,3602,6041,-1,7270,7271,3602,-1,5982,5996,5981,-1,5982,5994,5996,-1,3603,6025,2647,-1,3603,5981,6025,-1,6029,1182,2643,-1,1182,6029,5984,-1,5983,7260,1179,-1,5983,6046,7260,-1,1137,5810,2670,-1,1137,5811,5810,-1,1136,5811,1137,-1,1136,5842,5811,-1,1133,5842,1136,-1,3918,5842,1133,-1,5859,5842,3918,-1,5859,3590,5842,-1,5856,3590,5859,-1,5856,1139,3590,-1,1130,1139,5856,-1,1143,1139,1130,-1,1143,1140,1139,-1,1143,1142,1140,-1,5667,5969,5670,-1,5968,5969,5667,-1,5977,1117,1166,-1,1117,5977,1076,-1,7272,3913,7273,-1,3913,7272,1165,-1,5846,7274,2716,-1,5846,7275,7274,-1,7276,5974,5971,-1,7277,5974,7276,-1,7278,5680,5677,-1,5953,5680,7278,-1,7279,5682,5681,-1,7279,5832,5682,-1,5965,2655,7277,-1,2656,2655,5965,-1,5963,7273,3913,-1,5963,5945,7273,-1,5846,7280,7275,-1,7281,7280,5846,-1,7277,5948,5974,-1,2655,5948,7277,-1,5953,5934,5680,-1,5952,5934,5953,-1,7282,5832,7279,-1,7282,7283,5832,-1,5957,5939,5949,-1,5956,5939,5957,-1,5927,5945,5963,-1,5927,5943,5945,-1,7284,5938,5926,-1,5938,7284,5941,-1,5936,5920,5958,-1,5935,5920,5936,-1,5916,1159,5933,-1,5916,5954,1159,-1,1157,5813,7285,-1,1156,5813,1157,-1,2654,3915,2657,-1,5931,3915,2654,-1,5928,5943,5927,-1,5928,5910,5943,-1,5840,7286,5838,-1,5840,5835,7286,-1,5922,5905,5940,-1,5921,5905,5922,-1,5918,5903,5937,-1,5917,5903,5918,-1,5915,5928,5914,-1,5915,5902,5928,-1,1154,5913,1155,-1,1153,5913,1154,-1,5911,5929,5909,-1,5911,7287,5929,-1,7288,5907,5893,-1,7288,5919,5907,-1,5889,5924,5906,-1,5889,7289,5924,-1,5904,7290,5923,-1,5896,7290,5904,-1,2669,5911,5901,-1,2669,2668,5911,-1,2663,1150,3595,-1,7291,1150,2663,-1,1153,5882,5913,-1,3594,5882,1153,-1,5896,5878,7290,-1,5895,5878,5896,-1,5874,5893,5892,-1,5874,7288,5893,-1,5889,5872,7289,-1,5888,5872,5889,-1,7292,5886,7293,-1,7292,1149,5886,-1,7291,1151,1150,-1,5850,1151,7291,-1,5888,5870,5872,-1,5866,5870,5888,-1,5895,5881,5878,-1,5862,5881,5895,-1,5892,5877,5874,-1,1145,5877,5892,-1,7294,3589,5849,-1,5841,3589,7294,-1,1138,2665,1134,-1,1138,2666,2665,-1,1131,2667,3593,-1,1131,5858,2667,-1,5850,1141,1151,-1,3591,1141,5850,-1,5870,5865,3919,-1,5865,5870,5866,-1,5862,5851,5881,-1,5861,5851,5862,-1,1145,7295,5877,-1,3917,7295,1145,-1,5841,3590,3589,-1,5842,3590,5841,-1,1130,5858,1131,-1,1130,5856,5858,-1,7295,5854,7296,-1,5854,7295,3917,-1,1127,5865,7297,-1,1127,3919,5865,-1,5861,3598,5851,-1,3599,3598,5861,-1,5898,5850,7291,-1,5850,5898,5849,-1,7280,3596,5942,-1,3596,7280,5847,-1,7298,5846,5845,-1,7298,7281,5846,-1,5814,5900,5844,-1,5814,7299,5900,-1,5830,5681,1123,-1,5830,7279,5681,-1,5827,5840,5825,-1,5827,7300,5840,-1,5824,5837,5823,-1,5824,7301,5837,-1,7302,5836,5833,-1,5817,5836,7302,-1,7283,5831,5832,-1,5821,5831,7283,-1,2719,1161,1163,-1,5831,1161,2719,-1,5830,7303,7304,-1,5829,7303,5830,-1,5871,5827,5826,-1,5871,3585,5827,-1,1125,5855,1147,-1,5855,1125,1124,-1,5822,5908,5820,-1,5908,5822,5834,-1,7298,5962,5959,-1,5962,7298,5845,-1,5816,7299,5814,-1,5816,7305,7299,-1,5734,2697,5732,-1,2711,2697,5734,-1,2711,2707,2697,-1,2710,2707,2711,-1,5731,2707,2710,-1,7306,2707,5731,-1,7307,2707,7306,-1,7307,2708,2707,-1,5729,2708,7307,-1,5728,2708,5729,-1,5728,3923,2708,-1,5740,3923,5728,-1,5737,3923,5740,-1,5743,3923,5737,-1,5743,5741,3923,-1,7308,5806,5654,-1,2675,5806,7308,-1,5806,5803,5808,-1,2684,5803,5806,-1,7309,5804,7310,-1,7309,5793,5804,-1,7311,5631,5628,-1,7311,7312,5631,-1,2727,5781,2673,-1,5801,5781,2727,-1,5799,7313,5622,-1,5799,5780,7313,-1,2700,7314,5755,-1,2700,5777,7314,-1,5796,3583,2680,-1,5796,7315,3583,-1,5795,7316,7317,-1,5794,7316,5795,-1,5790,7318,5792,-1,5790,7319,7318,-1,5753,7312,7311,-1,5753,5759,7312,-1,5788,5766,5796,-1,5787,5766,5788,-1,5784,5764,5794,-1,5783,5764,5784,-1,5791,5763,5790,-1,7320,5763,5791,-1,1106,5802,5775,-1,1106,3921,5802,-1,5773,5800,5779,-1,5773,5772,5800,-1,5771,5798,5776,-1,5771,5770,5798,-1,2687,5733,5775,-1,3573,5733,2687,-1,5774,3922,5772,-1,5774,1103,3922,-1,5739,7321,5770,-1,5739,5738,7321,-1,2685,7322,3582,-1,1097,7322,2685,-1,5787,5769,5766,-1,5745,5769,5787,-1,5783,1096,5764,-1,7323,1096,5783,-1,5748,7320,7324,-1,5748,5763,7320,-1,5619,1092,2705,-1,1092,5619,5761,-1,1101,5760,1102,-1,1101,5751,5760,-1,5756,2701,3576,-1,2701,5756,7325,-1,7311,5754,5753,-1,7326,5754,7311,-1,7327,5751,1101,-1,7327,5750,5751,-1,7328,5748,7324,-1,7328,5746,5748,-1,7329,1096,7323,-1,7329,1094,1096,-1,7330,3579,5767,-1,7330,3577,3579,-1,5743,5739,5742,-1,5743,5737,5739,-1,1107,2698,2693,-1,1107,2699,2698,-1,1103,5731,1104,-1,7306,5731,1103,-1,5740,5730,5738,-1,5740,5728,5730,-1,3745,2713,3571,-1,2714,2713,3745,-1,3566,6890,3928,-1,3566,2731,6890,-1,5726,5711,5724,-1,5711,5726,7040,-1,1087,5720,5722,-1,1086,5720,1087,-1,5717,1086,1085,-1,5717,6077,1086,-1,6076,5715,5714,-1,6076,7331,5715,-1,5711,6082,5724,-1,5710,6082,5711,-1,5707,5705,5704,-1,5707,5708,5705,-1,2713,5704,1084,-1,7332,5704,2713,-1,7333,5703,5707,-1,5703,7333,5702,-1,5700,5671,7041,-1,5699,5671,5700,-1,6886,5698,5669,-1,5698,6886,5696,-1,3933,2720,6816,-1,1055,2720,3933,-1,5658,1080,1079,-1,5658,5689,1080,-1,3932,3930,1064,-1,3932,5692,3930,-1,5660,6816,5693,-1,5660,3933,6816,-1,5701,7334,5699,-1,7335,7334,5701,-1,7336,5685,7337,-1,5685,7336,5686,-1,7278,5684,5683,-1,7278,2722,5684,-1,2716,5674,2717,-1,2716,7274,5674,-1,5955,5679,5678,-1,5955,5685,5679,-1,5675,3931,1072,-1,3931,5675,5663,-1,1163,1063,2719,-1,1163,1065,1063,-1,3932,5684,5691,-1,3932,1066,5684,-1,3931,5665,1062,-1,3931,5663,5665,-1,5699,5672,5671,-1,5699,7334,5672,-1,5976,5698,5695,-1,5698,5976,7338,-1,2672,5666,3570,-1,5666,2672,5664,-1,5662,3933,5660,-1,3933,5662,1056,-1,5658,5686,5688,-1,5658,5657,5686,-1,6858,5638,7339,-1,5638,6858,5656,-1,7340,5655,5652,-1,7340,6855,5655,-1,2266,7341,2264,-1,5637,7341,2266,-1,5641,6859,7047,-1,5641,5640,6859,-1,1925,7342,7343,-1,5610,7342,1925,-1,6867,5626,5647,-1,7344,5626,6867,-1,5633,5643,5649,-1,5633,5646,5643,-1,5641,5623,5620,-1,5623,5641,7345,-1,5617,3580,7346,-1,5807,3580,5617,-1,5644,5805,7347,-1,5804,5805,5644,-1,2679,5634,7348,-1,2679,5632,5634,-1,3568,2681,7349,-1,2681,3568,2725,-1,2677,7344,7350,-1,2677,5626,7344,-1,5622,5642,5620,-1,5622,7313,5642,-1,5639,5755,7314,-1,5755,5639,5612,-1,5631,5618,5629,-1,5631,5619,5618,-1,7050,5613,1919,-1,5613,7050,7346,-1,5630,7349,5628,-1,5630,3568,7349,-1,5563,5552,5550,-1,5563,5609,5552,-1,5607,7351,5606,-1,5607,7209,7351,-1,5609,5605,7352,-1,5603,5605,5609,-1,3610,5607,5601,-1,3610,2623,5607,-1,7353,5602,6205,-1,5602,7353,5605,-1,2730,5574,5588,-1,2729,5574,2730,-1,5590,7354,5593,-1,5590,5592,7354,-1,5589,5595,5587,-1,5589,7355,5595,-1,5586,5592,5584,-1,5586,6048,5592,-1,5580,5589,5581,-1,5580,5578,5589,-1,5579,5583,5577,-1,5579,7356,5583,-1,2733,5574,2729,-1,5572,5574,2733,-1,5571,7357,1648,-1,5571,5570,7357,-1,5567,5562,7358,-1,5567,5561,5562,-1,5565,5560,7359,-1,5565,5558,5560,-1,5562,3935,3934,-1,5562,5550,3935,-1,5560,7360,7361,-1,5560,5557,7360,-1,5570,5553,7357,-1,5570,7362,5553,-1,3935,5606,3937,-1,3935,5551,5606,-1,5713,2253,5549,-1,2253,5713,2251,-1,5547,2298,2297,-1,5547,7363,2298,-1,5546,5549,5544,-1,5546,5594,5549,-1,5542,5547,5541,-1,5542,5597,5547,-1,277,1046,7364,-1,277,3438,1046,-1,5522,5189,7364,-1,5189,5522,5521,-1,1043,936,1041,-1,1043,5187,936,-1,5539,5175,7365,-1,5175,5539,3539,-1,4028,362,341,-1,4028,363,362,-1,336,360,345,-1,336,355,360,-1,354,5459,356,-1,354,5535,5459,-1,5515,5450,5513,-1,5449,5450,5515,-1,7366,418,413,-1,7366,971,418,-1,3948,3089,992,-1,3948,3455,3089,-1,3088,5509,429,-1,3088,3087,5509,-1,3552,5495,7367,-1,5495,3552,7368,-1,955,5533,5505,-1,955,957,5533,-1,5501,3946,2765,-1,5501,3944,3946,-1,4023,968,3952,-1,7369,968,4023,-1,2759,7369,7370,-1,2759,2758,7369,-1,1009,1028,333,-1,1009,1008,1028,-1,3560,2813,5475,-1,3559,2813,3560,-1,5518,7371,7372,-1,5518,5519,7371,-1,1015,7373,5528,-1,1015,7374,7373,-1,7375,5524,5199,-1,7375,5516,5524,-1,5528,905,7376,-1,5528,7373,905,-1,3943,5174,1019,-1,3943,5525,5174,-1,2809,5181,2761,-1,5483,5181,2809,-1,5525,5199,5524,-1,5525,3943,5199,-1,7377,7378,7379,-1,7377,7376,7378,-1,3112,7380,5529,-1,3111,7380,3112,-1,7381,3083,3082,-1,7381,5455,3083,-1,2755,7382,2752,-1,2755,3561,7382,-1,4023,7370,7369,-1,4023,5201,7370,-1,5496,5510,7383,-1,5496,5494,5510,-1,5514,5497,3950,-1,5497,5514,5513,-1,5507,3946,3945,-1,5508,3946,5507,-1,5492,3456,406,-1,5492,7384,3456,-1,962,5505,2792,-1,962,955,5505,-1,5500,3949,999,-1,3949,5500,991,-1,3945,5500,5502,-1,5500,3945,3944,-1,5499,3950,5497,-1,3950,5499,979,-1,7385,3555,997,-1,3555,402,401,-1,402,3555,7385,-1,2775,5496,5512,-1,2774,5496,2775,-1,977,7386,7387,-1,977,3951,7386,-1,2789,2763,7388,-1,2763,2789,2764,-1,7386,2794,7384,-1,2795,2794,7386,-1,5488,5453,5477,-1,5487,5453,5488,-1,5487,5455,7381,-1,5455,5487,2830,-1,5486,5490,5485,-1,5490,5486,5489,-1,965,3456,5484,-1,965,964,3456,-1,3136,5483,3563,-1,3136,960,5483,-1,2813,1024,5475,-1,1024,2813,1022,-1,5467,357,5466,-1,5467,5178,357,-1,345,4025,346,-1,4025,345,360,-1,953,3106,416,-1,953,952,3106,-1,942,5538,2820,-1,5538,942,7389,-1,2821,934,399,-1,934,2821,938,-1,3110,343,4027,-1,338,343,3110,-1,938,3941,5180,-1,3941,938,937,-1,358,3108,359,-1,3108,358,3444,-1,3957,5488,5491,-1,2831,5488,3957,-1,3448,3443,5177,-1,3448,7390,3443,-1,1032,2796,3451,-1,2796,1032,1031,-1,5536,1036,3564,-1,1036,5536,353,-1,5473,2828,2827,-1,2828,5473,2826,-1,2826,5475,1024,-1,5475,2826,5473,-1,2748,5472,5474,-1,2748,921,5472,-1,5471,5469,5468,-1,3954,5469,5471,-1,5463,5519,5470,-1,7371,5519,5463,-1,5465,5461,5460,-1,5464,5461,5465,-1,5535,5462,5459,-1,5535,5457,5462,-1,2752,3077,3076,-1,3077,2752,7382,-1,3109,338,3110,-1,338,3109,339,-1,7366,365,3451,-1,7366,366,365,-1,5450,388,5498,-1,5450,3094,388,-1,1040,902,2823,-1,909,902,1040,-1,7378,5448,5447,-1,7378,904,5448,-1,7391,904,3958,-1,904,7391,5448,-1,3064,3066,5446,-1,3063,3066,3064,-1,5445,2884,5444,-1,5445,5332,2884,-1,5442,7392,5341,-1,5442,5343,7392,-1,5443,727,729,-1,5443,3495,727,-1,600,2928,3521,-1,600,599,2928,-1,5167,7393,7394,-1,7393,5167,7395,-1,3528,7396,7397,-1,3528,2917,7396,-1,5206,7398,5204,-1,5206,7399,7398,-1,7400,2847,7401,-1,2848,2847,7400,-1,879,2817,880,-1,2817,879,945,-1,7402,7403,7404,-1,7402,7405,7403,-1,3461,5435,5195,-1,3461,5434,5435,-1,7404,7406,5196,-1,7404,7403,7406,-1,3462,7399,2841,-1,3462,7398,7399,-1,5168,7394,5323,-1,5168,5167,7394,-1,5433,5169,5166,-1,5433,5432,5169,-1,5323,5440,7407,-1,5323,7394,5440,-1,5431,7408,5429,-1,7408,5431,7409,-1,2851,2856,872,-1,2853,2856,2851,-1,777,3526,867,-1,700,3526,777,-1,721,7410,2898,-1,7410,721,718,-1,2899,4278,4277,-1,4278,2899,782,-1,784,849,846,-1,784,2897,849,-1,5427,786,2866,-1,5427,787,786,-1,3373,3976,5376,-1,3327,3976,3373,-1,5424,2902,7411,-1,5424,780,2902,-1,7412,764,5359,-1,7412,3978,764,-1,5422,3533,5368,-1,3333,3533,5422,-1,4246,5370,5369,-1,4245,5370,4246,-1,5423,3978,7413,-1,762,3978,5423,-1,7414,5353,5356,-1,838,5353,7414,-1,5411,832,5405,-1,5411,826,832,-1,842,826,5411,-1,3536,5415,5413,-1,823,5415,3536,-1,823,754,5415,-1,5358,5407,3979,-1,5407,5358,5406,-1,5355,5408,3980,-1,5408,5355,5409,-1,5402,7415,5400,-1,5416,7415,5402,-1,7416,5409,7417,-1,4198,5409,7416,-1,7418,4193,5406,-1,4193,7418,7419,-1,7420,841,2870,-1,4200,841,7420,-1,4207,5419,5404,-1,7421,5419,4207,-1,837,5400,3963,-1,5403,5400,837,-1,7422,5399,5397,-1,5399,7422,4203,-1,7423,7417,7424,-1,7416,7417,7423,-1,4167,7425,7426,-1,7425,4167,7427,-1,7425,828,3964,-1,828,7425,831,-1,683,5357,5350,-1,5357,683,3992,-1,7428,2862,884,-1,3969,2862,7428,-1,3968,5396,2862,-1,3968,7429,5396,-1,822,7428,884,-1,7428,822,760,-1,821,3535,860,-1,821,820,3535,-1,699,819,816,-1,699,698,819,-1,3970,5393,5392,-1,3970,815,5393,-1,3981,751,748,-1,3981,3531,751,-1,718,5374,7410,-1,718,720,5374,-1,7430,5341,7392,-1,5341,7430,5339,-1,5439,5334,7431,-1,5334,5439,3984,-1,5383,4126,4125,-1,5383,7432,4126,-1,4123,5385,7433,-1,5385,4123,4122,-1,7434,788,3973,-1,789,788,7434,-1,5379,797,3974,-1,797,5379,5378,-1,2888,7433,2893,-1,7433,2888,5380,-1,2914,7435,2915,-1,7435,2914,7436,-1,787,739,738,-1,787,3975,739,-1,791,7437,3524,-1,789,7437,791,-1,5378,3972,797,-1,802,3972,5378,-1,725,802,5378,-1,784,802,725,-1,750,5373,808,-1,794,5373,750,-1,5421,5367,3962,-1,5421,5368,5367,-1,2868,867,2869,-1,777,867,2868,-1,3962,2903,5421,-1,3962,865,2903,-1,7412,7413,3978,-1,4096,7413,7412,-1,3988,3523,5364,-1,2926,3523,3988,-1,7393,5363,5360,-1,5347,5363,7393,-1,760,2871,7428,-1,759,2871,760,-1,5418,5357,3967,-1,5418,5356,5357,-1,742,5415,754,-1,742,741,5415,-1,2878,7438,5355,-1,7438,2878,2877,-1,5392,5354,3970,-1,5416,5354,5392,-1,7429,842,5411,-1,842,7429,3968,-1,5361,5349,5348,-1,5361,7401,5349,-1,5365,5170,7439,-1,5170,5365,7440,-1,3990,2926,3988,-1,2926,3990,5320,-1,2912,3991,2925,-1,3991,2912,2880,-1,696,753,697,-1,740,753,696,-1,3525,695,697,-1,3525,2883,695,-1,2930,5343,3521,-1,5343,2930,7392,-1,5388,7430,5387,-1,5388,7441,7430,-1,5341,895,5442,-1,5341,5340,895,-1,2927,678,682,-1,2927,679,678,-1,730,723,5337,-1,730,719,723,-1,2896,796,2894,-1,2896,722,796,-1,7396,5338,5389,-1,5338,7396,5336,-1,5438,2844,2846,-1,5438,3982,2844,-1,715,731,713,-1,731,715,3987,-1,3987,708,731,-1,708,3987,709,-1,5395,858,881,-1,859,858,5395,-1,7442,5332,5445,-1,7442,5330,5332,-1,3482,5329,5328,-1,3482,693,5329,-1,5327,7443,7444,-1,7443,5327,5325,-1,5324,7407,7444,-1,7407,5324,5323,-1,2996,7445,599,-1,2996,5219,7445,-1,5319,3959,899,-1,3959,5319,7446,-1,5315,5319,5318,-1,5319,5315,7447,-1,468,5315,5317,-1,5315,468,3520,-1,3475,5313,3519,-1,3475,1559,5313,-1,4019,7448,3467,-1,4019,5311,7448,-1,3480,7449,7450,-1,3480,5310,7449,-1,5223,472,478,-1,472,5223,473,-1,609,6762,610,-1,671,6762,609,-1,7451,329,328,-1,329,7451,4032,-1,6761,5214,7452,-1,5214,6761,5212,-1,537,2987,538,-1,537,7451,2987,-1,646,3489,3490,-1,2973,3489,646,-1,3994,2953,666,-1,4909,2953,3994,-1,7453,5292,5291,-1,5292,7453,5305,-1,653,7454,654,-1,653,5302,7454,-1,616,648,655,-1,615,648,616,-1,2980,3997,5289,-1,2980,640,3997,-1,5287,631,7455,-1,631,5287,632,-1,5300,2962,3511,-1,5300,658,2962,-1,659,7456,2956,-1,7456,659,4877,-1,7457,2955,4874,-1,7457,663,2955,-1,5301,7455,631,-1,7458,7455,5301,-1,3999,623,526,-1,623,3999,4000,-1,4858,625,5285,-1,4858,7459,625,-1,5286,3512,2960,-1,5286,5296,3512,-1,4857,2968,4855,-1,664,2968,4857,-1,6747,2943,5294,-1,2943,6747,1779,-1,2968,5294,5293,-1,2967,5294,2968,-1,5292,2969,3508,-1,5292,2970,2969,-1,2966,656,655,-1,2966,641,656,-1,313,3033,3116,-1,3032,3033,313,-1,2962,636,2963,-1,2962,637,636,-1,7460,663,7457,-1,7460,634,663,-1,5284,5297,3507,-1,5284,2959,5297,-1,3507,7461,618,-1,3507,5297,7461,-1,5284,622,621,-1,5284,660,622,-1,4002,617,506,-1,4002,2983,617,-1,669,672,469,-1,669,609,672,-1,7462,467,466,-1,467,7462,4018,-1,5278,5230,5225,-1,5278,5277,5230,-1,3002,7442,515,-1,7442,3002,3502,-1,5282,7463,7464,-1,5283,7463,5282,-1,451,3000,7465,-1,453,3000,451,-1,7466,571,7467,-1,7466,569,571,-1,7468,4691,5252,-1,4691,7468,4692,-1,5272,3016,3498,-1,4699,3016,5272,-1,4678,5245,7469,-1,4678,5243,5245,-1,3495,7470,3021,-1,7470,3495,4681,-1,7471,2999,2998,-1,7471,5251,2999,-1,3503,590,593,-1,3503,5260,590,-1,3047,7472,5267,-1,3047,5275,7472,-1,595,5231,4004,-1,5231,595,5261,-1,5279,5265,5241,-1,5279,5264,5265,-1,595,7473,5262,-1,7473,595,594,-1,453,3503,3000,-1,3503,453,5210,-1,521,3009,5234,-1,520,3009,521,-1,589,5254,7474,-1,589,588,5254,-1,3401,3500,4642,-1,3401,3012,3500,-1,3012,3242,582,-1,3012,3401,3242,-1,4626,5249,4624,-1,4011,5249,4626,-1,4694,576,4012,-1,576,4694,5258,-1,507,3010,583,-1,507,509,3010,-1,507,513,508,-1,513,507,3015,-1,603,3003,3501,-1,3003,603,602,-1,5268,5273,7475,-1,5273,5268,3042,-1,598,5252,5251,-1,7468,5252,598,-1,5250,4009,5257,-1,5250,3488,4009,-1,5244,7471,5242,-1,5244,597,7471,-1,3017,5245,5242,-1,3021,5245,3017,-1,3043,894,517,-1,3043,3044,894,-1,3052,3001,554,-1,3001,3052,7450,-1,479,4005,4006,-1,479,3468,4005,-1,479,3050,3468,-1,491,488,489,-1,491,545,488,-1,544,547,3026,-1,544,548,547,-1,3031,526,310,-1,526,3031,3030,-1,2987,328,3506,-1,2987,7451,328,-1,5238,554,322,-1,554,5238,555,-1,2448,538,540,-1,2448,537,538,-1,3492,669,4031,-1,670,669,3492,-1,600,5236,601,-1,600,5342,5236,-1,5441,521,5233,-1,5441,3486,521,-1,530,527,623,-1,530,532,527,-1,2945,657,3490,-1,4015,657,2945,-1,3041,4014,528,-1,5232,4014,3041,-1,525,319,585,-1,319,525,317,-1,2990,2932,2931,-1,4002,2932,2990,-1,3485,3047,3045,-1,3485,3046,3047,-1,7476,7477,550,-1,7476,7464,7477,-1,7463,5267,7472,-1,5267,7463,5263,-1,5277,5228,5230,-1,5228,5277,7465,-1,500,5253,3015,-1,499,5253,500,-1,897,516,515,-1,516,897,3959,-1,488,486,550,-1,488,487,486,-1,480,737,481,-1,480,2913,737,-1,475,2936,476,-1,2937,2936,475,-1,477,3505,2940,-1,3505,477,610,-1,2936,3479,2938,-1,2935,3479,2936,-1,7478,5219,5218,-1,7445,5219,7478,-1,5215,7462,5218,-1,5215,4018,7462,-1,5218,466,7478,-1,5218,7462,466,-1,580,3054,3005,-1,465,3054,580,-1,459,604,2994,-1,459,3060,604,-1,3474,5214,5211,-1,7452,5214,3474,-1,243,457,456,-1,243,242,457,-1,3062,244,2994,-1,3062,454,244,-1,457,3471,458,-1,457,3469,3471,-1,3471,4003,606,-1,3470,4003,3471,-1,7479,4020,2843,-1,3983,4020,7479,-1,7480,4021,903,-1,7480,3065,4021,-1,443,1030,3072,-1,443,3556,1030,-1,5199,5527,7375,-1,5198,5527,5199,-1,5530,7481,7482,-1,5530,3074,7481,-1,7483,5196,5195,-1,7404,5196,7483,-1,2805,1006,2806,-1,1007,1006,2805,-1,5521,5190,5189,-1,5521,7379,5190,-1,1015,2754,1013,-1,5193,2754,1015,-1,440,5518,7484,-1,440,4024,5518,-1,2776,2771,986,-1,2771,2776,993,-1,976,423,421,-1,976,424,423,-1,431,982,2745,-1,431,983,982,-1,1042,2838,7485,-1,2838,1042,906,-1,933,7389,942,-1,7389,933,5482,-1,5176,3454,7486,-1,3454,5176,3107,-1,295,291,296,-1,295,3131,291,-1,392,383,245,-1,392,1017,383,-1,268,371,389,-1,371,268,267,-1,5179,3105,3104,-1,2802,3105,5179,-1,5178,358,357,-1,5177,358,5178,-1,7365,5176,7487,-1,7365,5175,5176,-1,337,345,344,-1,336,345,337,-1,4028,338,4029,-1,4028,343,338,-1,1026,7488,7484,-1,1026,332,7488,-1,4013,3113,3518,-1,3113,4013,542,-1,3516,3117,7489,-1,3516,3114,3117,-1,2986,3115,3489,-1,3115,2986,2985,-1,3150,939,257,-1,3150,241,939,-1,3124,306,308,-1,305,306,3124,-1,887,914,877,-1,914,887,886,-1,294,4034,298,-1,294,272,4034,-1,288,3440,292,-1,288,303,3440,-1,260,279,270,-1,3135,279,260,-1,3464,1047,3463,-1,3464,1045,1047,-1,1044,276,275,-1,283,276,1044,-1,273,260,271,-1,260,273,261,-1,277,282,278,-1,912,282,277,-1,2735,301,300,-1,2735,2816,301,-1,3122,1049,1048,-1,1049,3122,3121,-1,5171,7439,5170,-1,7439,5171,5346,-1,4039,5168,4040,-1,4039,5166,5168,-1,607,5208,5311,-1,607,3466,5208,-1,5101,5161,5099,-1,5101,5158,5161,-1,3153,5119,7490,-1,5119,3153,3152,-1,7491,7492,5116,-1,7491,7493,7492,-1,5150,7492,7494,-1,5157,7492,5150,-1,5160,5149,5156,-1,5160,7495,5149,-1,7496,5155,7497,-1,5155,7496,5147,-1,3429,3154,3155,-1,3429,7498,3154,-1,7499,5153,5144,-1,7500,5153,7499,-1,5151,3161,7501,-1,5151,3427,3161,-1,7502,5141,7503,-1,7502,5148,5141,-1,7504,3157,5146,-1,7504,5073,3157,-1,228,5144,5078,-1,228,7499,5144,-1,7505,5140,7506,-1,7505,5139,5140,-1,5138,7507,5136,-1,7507,5138,7508,-1,7507,5134,4904,-1,7507,5132,5134,-1,5130,7490,5129,-1,7490,5130,3153,-1,5127,7509,5125,-1,7509,5127,7497,-1,5123,7509,5121,-1,7509,5123,7508,-1,7490,5117,7506,-1,7490,5119,5117,-1,7510,5116,5114,-1,7491,5116,7510,-1,7511,5113,5111,-1,5117,5113,7511,-1,7512,5110,5109,-1,5114,5110,7512,-1,7512,4896,5107,-1,4894,4896,7512,-1,4899,7505,7511,-1,4899,4898,7505,-1,5104,5098,5095,-1,5102,5098,5104,-1,5098,7513,5096,-1,5098,5162,7513,-1,5162,5156,7513,-1,5162,5160,5156,-1,5066,5081,5087,-1,5081,5066,5093,-1,7514,220,3167,-1,7514,7515,220,-1,235,5092,5090,-1,235,237,5092,-1,216,7516,3169,-1,234,7516,216,-1,5142,233,5088,-1,5142,3165,233,-1,7517,5086,5085,-1,7517,7518,5086,-1,5073,5083,5080,-1,5073,7504,5083,-1,231,7519,7514,-1,231,5145,7519,-1,3166,4041,5079,-1,4041,3166,238,-1,5090,4043,235,-1,5090,226,4043,-1,5077,7520,5075,-1,7520,5077,5091,-1,225,234,223,-1,234,225,7516,-1,5061,3170,5071,-1,7521,3170,5061,-1,7521,217,3170,-1,5068,217,7521,-1,5068,4044,217,-1,5065,4044,5068,-1,5065,7522,4044,-1,4045,220,7515,-1,4045,218,220,-1,7522,5067,5094,-1,7522,5065,5067,-1,7521,5063,5093,-1,7521,5061,5063,-1,4878,5060,4876,-1,4878,7523,5060,-1,5056,5023,7524,-1,5055,5023,5056,-1,5026,5053,5018,-1,5026,7525,5053,-1,3183,5015,7526,-1,5015,3183,5009,-1,7527,4048,5042,-1,4048,7527,5051,-1,5008,206,5006,-1,5008,207,206,-1,4990,3182,3419,-1,3182,4990,7528,-1,3180,7523,7529,-1,7523,3180,5031,-1,7530,5046,7531,-1,5046,7530,5045,-1,5044,7532,4887,-1,5044,7529,7532,-1,3179,5014,5041,-1,3179,5036,5014,-1,213,5020,5039,-1,213,212,5020,-1,5037,7533,5036,-1,7533,5037,5045,-1,5030,5035,5029,-1,5030,5024,5035,-1,7523,5032,5060,-1,5031,5032,7523,-1,4882,5034,7534,-1,5029,5034,4882,-1,5033,5028,5025,-1,5033,5057,5028,-1,4047,3423,5022,-1,4047,3426,3423,-1,7535,5019,5021,-1,7535,5027,5019,-1,5018,5027,5026,-1,5019,5027,5018,-1,5016,5041,5014,-1,5016,7536,5041,-1,3422,5012,7537,-1,5012,3422,3171,-1,5003,211,210,-1,5003,5048,211,-1,5005,5008,5004,-1,5005,5049,5008,-1,5007,3425,5004,-1,5007,7524,3425,-1,5002,209,7525,-1,5002,210,209,-1,5000,5054,5053,-1,5000,7538,5054,-1,4996,5050,7539,-1,5050,4996,4997,-1,4995,4990,4991,-1,7528,4990,4995,-1,7540,4988,4987,-1,7540,4999,4988,-1,4985,5295,7459,-1,4985,7541,5295,-1,7542,4980,4984,-1,7542,4979,4980,-1,4657,4983,4660,-1,4983,4657,4981,-1,4972,4979,7543,-1,4979,4972,4971,-1,4860,4969,4975,-1,4860,4968,4969,-1,4974,4976,4967,-1,4973,4976,4974,-1,201,4972,204,-1,4972,201,4964,-1,4970,7544,7545,-1,4968,7544,4970,-1,4959,4970,7546,-1,4966,4970,4959,-1,3190,3415,3191,-1,3190,3189,3415,-1,7547,205,7548,-1,205,7547,202,-1,4965,4963,7549,-1,4965,4962,4963,-1,4963,7550,7551,-1,4963,3194,7550,-1,4961,7552,7553,-1,4961,4960,7552,-1,7554,4957,7555,-1,4957,7554,4955,-1,203,7556,4954,-1,203,202,7556,-1,4952,7557,4951,-1,4952,4954,7557,-1,4950,7558,4960,-1,4950,4948,7558,-1,4052,7554,198,-1,7554,4052,4936,-1,7559,4055,194,-1,7559,4936,4055,-1,192,7557,4943,-1,7557,192,191,-1,4941,196,197,-1,4940,196,4941,-1,4939,7558,7560,-1,4937,7558,4939,-1,4052,4054,4053,-1,4052,200,4054,-1,4055,180,195,-1,4055,4053,180,-1,3200,192,4934,-1,192,3200,193,-1,4927,4941,4928,-1,4932,4941,4927,-1,4939,187,4057,-1,4939,4930,187,-1,180,4058,181,-1,180,183,4058,-1,4924,4056,190,-1,4056,4924,4923,-1,4927,4920,4931,-1,4927,4918,4920,-1,3199,174,176,-1,4916,174,3199,-1,4923,7561,7562,-1,4925,7561,4923,-1,4919,7563,4920,-1,4919,7564,7563,-1,182,4917,179,-1,7565,4917,182,-1,7566,185,3198,-1,7566,4914,185,-1,3514,7567,5302,-1,3514,4913,7567,-1,4906,4857,4854,-1,5306,4857,4906,-1,7568,4903,4902,-1,7568,4909,4903,-1,4906,7569,7570,-1,4906,4905,7569,-1,7571,4904,5134,-1,7571,4902,4904,-1,4897,7572,4913,-1,4897,4899,7572,-1,7573,4895,4894,-1,4911,4895,7573,-1,4891,5131,7574,-1,4890,5131,4891,-1,4880,5301,4889,-1,5301,4880,7575,-1,4887,7576,4885,-1,7576,4887,7532,-1,7534,4873,4882,-1,4871,4873,7534,-1,4881,7575,4880,-1,4881,7531,7575,-1,4877,5059,7456,-1,4876,5059,4877,-1,7577,4874,4871,-1,7577,7457,4874,-1,3512,4861,2961,-1,4861,3512,4984,-1,4866,7578,7579,-1,7578,4866,4865,-1,4863,4975,4865,-1,4863,4860,4975,-1,4643,7579,7578,-1,7579,4643,4642,-1,4780,7580,7581,-1,4790,7582,4788,-1,4780,4775,7580,-1,4782,4775,4780,-1,4782,4778,4775,-1,7583,4778,4782,-1,7583,7584,4778,-1,7585,7584,7583,-1,7585,7586,7584,-1,4786,7586,7585,-1,4786,4774,7586,-1,4783,4774,4786,-1,4783,4772,4774,-1,7587,4772,4783,-1,7587,7588,4772,-1,7582,7588,7587,-1,7582,4790,7588,-1,4845,4690,4687,-1,4690,4845,4844,-1,4851,4686,4683,-1,4686,4851,7589,-1,4847,7590,7591,-1,4847,4849,7590,-1,3204,7592,4652,-1,7592,3204,7593,-1,4846,172,4844,-1,172,4846,173,-1,169,4843,7589,-1,4843,169,168,-1,4831,4841,7594,-1,4841,4831,4830,-1,4838,4821,4846,-1,4838,4840,4821,-1,169,4834,170,-1,169,4836,4834,-1,4815,4831,3413,-1,4831,4815,4829,-1,4646,4828,4827,-1,4646,4812,4828,-1,4826,4837,4825,-1,4837,4826,7595,-1,7596,7597,7595,-1,7597,7596,4803,-1,4819,4799,4833,-1,4819,4818,4799,-1,4816,4829,4815,-1,4829,4816,4793,-1,4812,4791,4828,-1,4812,4811,4791,-1,7598,7595,4826,-1,7595,7598,7596,-1,4784,4803,7596,-1,4803,4784,4801,-1,4818,4797,4799,-1,4818,4781,4797,-1,4776,4793,4816,-1,4793,4776,4796,-1,4811,4792,4791,-1,4811,4773,4792,-1,4792,4790,4787,-1,4792,7588,4790,-1,7587,4785,4808,-1,4785,7587,4783,-1,4804,4782,4779,-1,4804,7583,4782,-1,7580,4777,4800,-1,4777,7580,4775,-1,4794,4774,4771,-1,4794,7586,4774,-1,4663,4756,4769,-1,4663,7599,4756,-1,3213,7600,3214,-1,7601,7600,3213,-1,4752,4668,4666,-1,4668,4752,4763,-1,7599,4665,7602,-1,4663,4665,7599,-1,4758,7599,4748,-1,4756,7599,4758,-1,4765,4152,4742,-1,4765,4150,4152,-1,4751,4763,4752,-1,4763,4751,4750,-1,3407,4759,4750,-1,4759,3407,3218,-1,4748,162,4758,-1,4748,3221,162,-1,4060,4735,159,-1,4060,4755,4735,-1,4744,4734,4151,-1,4744,4746,4734,-1,4738,4753,4741,-1,4753,4738,4737,-1,4739,4749,4737,-1,4749,4739,157,-1,3227,159,4735,-1,159,3227,160,-1,4746,4732,4734,-1,4746,7603,4732,-1,4731,4732,4720,-1,4729,4732,4731,-1,157,7604,155,-1,157,4739,7604,-1,4061,4726,4727,-1,4061,4724,4726,-1,3228,4708,3404,-1,3228,4062,4708,-1,4724,7605,4726,-1,4724,4705,7605,-1,7606,156,155,-1,156,7606,4723,-1,4731,4716,4722,-1,4731,7607,4716,-1,7608,4723,7606,-1,4723,7608,7609,-1,7607,4714,4716,-1,7607,7610,4714,-1,4725,4713,4710,-1,4725,7611,4713,-1,4708,7612,4707,-1,4708,7613,7612,-1,3235,4704,151,-1,3235,7614,4704,-1,4723,4703,4700,-1,4723,7609,4703,-1,4685,7615,4698,-1,7615,4685,4684,-1,7616,7466,7467,-1,7466,7616,7617,-1,4653,7617,7616,-1,7617,4653,7618,-1,4690,7619,4688,-1,7619,4690,7620,-1,4686,7621,4684,-1,7621,4686,7622,-1,4682,7470,4681,-1,7470,4682,7623,-1,7624,4680,4679,-1,5270,4680,7624,-1,149,7625,150,-1,149,4124,7625,-1,7623,4675,4673,-1,7623,7626,4675,-1,7624,4672,4669,-1,7624,7627,4672,-1,7628,4063,150,-1,4063,7628,4666,-1,4675,4665,4662,-1,4675,7629,4665,-1,4672,7630,4670,-1,4672,4770,7630,-1,147,4661,7631,-1,147,4658,4661,-1,146,4658,147,-1,146,4656,4658,-1,7555,4656,146,-1,7555,4957,4656,-1,4635,4654,4633,-1,4635,7632,4654,-1,7633,4647,4649,-1,7633,4645,4647,-1,7632,3205,4654,-1,7632,4644,3205,-1,7634,3208,4644,-1,7634,3410,3208,-1,4008,7635,142,-1,589,7635,4008,-1,7636,4641,7631,-1,4640,4641,7636,-1,4696,5258,4694,-1,4696,7637,5258,-1,4626,4632,5259,-1,4625,4632,4626,-1,4634,4653,7616,-1,4634,4633,4653,-1,4630,4655,4627,-1,4630,4629,4655,-1,7638,4540,7639,-1,7638,4541,4540,-1,4535,4541,7638,-1,4535,7640,4541,-1,4536,7640,4535,-1,7641,7640,4536,-1,7641,4539,7640,-1,7641,4537,4539,-1,7641,7642,4537,-1,4528,7642,7641,-1,4528,7643,7642,-1,4525,7643,4528,-1,4545,7643,4525,-1,4545,7644,7643,-1,4545,4542,7644,-1,4623,3331,4269,-1,3331,4623,4607,-1,3357,4603,4267,-1,3357,4619,4603,-1,4618,4265,4264,-1,4265,4618,7645,-1,4558,4094,33,-1,4094,4558,4599,-1,4598,4107,4614,-1,4107,4598,4148,-1,4611,4595,4621,-1,4611,4610,4595,-1,7646,7647,7648,-1,7649,7647,7646,-1,4604,4616,4602,-1,4616,4604,7650,-1,3400,7651,4599,-1,7651,3400,3243,-1,3246,4604,4601,-1,4604,3246,3245,-1,4596,7652,4612,-1,4596,4589,7652,-1,4605,137,4588,-1,4605,4594,137,-1,3246,4593,4590,-1,4601,4593,3246,-1,7653,7654,7655,-1,7653,7656,7654,-1,4589,7657,7652,-1,4589,4067,7657,-1,7656,4530,7654,-1,7656,4562,4530,-1,124,4587,7658,-1,4587,124,4581,-1,139,3397,4579,-1,139,138,3397,-1,3255,132,3247,-1,132,3255,133,-1,4067,7659,7657,-1,4067,131,7659,-1,3259,4584,4583,-1,7660,4584,3259,-1,126,4581,124,-1,4581,126,4572,-1,7661,4575,4134,-1,7661,7662,4575,-1,4578,3396,7663,-1,3397,3396,4578,-1,4526,4066,4065,-1,7664,4066,4526,-1,7662,4550,4575,-1,7662,4548,4550,-1,4573,4582,4572,-1,4582,4573,7665,-1,3265,7666,3391,-1,4560,7666,3265,-1,4571,7667,4570,-1,4571,7668,7667,-1,4568,4533,4532,-1,4568,4534,4533,-1,7649,4567,7668,-1,4567,7649,4064,-1,7669,4564,4565,-1,7669,7653,4564,-1,4563,4556,4561,-1,4563,4554,4556,-1,7648,4608,7646,-1,4606,4608,7648,-1,4556,7670,4574,-1,4556,4555,7670,-1,4553,4573,3262,-1,4573,4553,7671,-1,7672,4551,4548,-1,7672,7673,4551,-1,4578,4542,4544,-1,4578,7644,4542,-1,7664,4536,4534,-1,7664,7641,4536,-1,7663,7644,4578,-1,7663,7643,7644,-1,7639,3256,123,-1,3256,7639,4540,-1,4065,4527,4526,-1,4065,117,4527,-1,112,7667,113,-1,7667,112,4592,-1,7654,136,135,-1,136,7654,4530,-1,7674,3263,7675,-1,7674,3264,3263,-1,4230,4521,7676,-1,4230,4227,4521,-1,7677,4071,4226,-1,7677,7678,4071,-1,7678,110,4071,-1,7678,4516,110,-1,3343,4379,4513,-1,3343,3342,4379,-1,4520,7679,4518,-1,4520,4522,7679,-1,7680,4517,7681,-1,4517,7680,4506,-1,7682,7683,7684,-1,7683,7682,4509,-1,4516,7685,110,-1,4516,4499,7685,-1,107,4083,4514,-1,4083,107,4417,-1,4501,7686,4511,-1,7686,4501,4500,-1,4510,7687,4508,-1,7687,4510,4491,-1,4395,4504,4503,-1,4395,4392,4504,-1,4501,3278,3275,-1,4501,4512,3278,-1,4072,4481,4498,-1,4072,4074,4481,-1,108,7688,7689,-1,4076,7688,108,-1,7690,4512,4381,-1,4512,7690,3278,-1,4496,4507,4494,-1,4507,4496,4474,-1,4492,4505,4490,-1,4505,4492,4470,-1,4476,4392,7691,-1,4504,4392,4476,-1,4074,4484,4481,-1,4074,4466,4484,-1,7689,4480,108,-1,7689,7692,4480,-1,7691,4479,4476,-1,7691,7693,4479,-1,4460,4474,4496,-1,4474,4460,4472,-1,4464,4470,4492,-1,4470,4464,4468,-1,4480,102,106,-1,4480,4457,102,-1,3277,4454,7694,-1,3277,3276,4454,-1,4482,7695,7696,-1,4482,7697,7695,-1,7698,4471,98,-1,4383,4471,7698,-1,4448,4461,4477,-1,4461,4448,4459,-1,7699,4465,4475,-1,4465,7699,4452,-1,7695,4456,4455,-1,7695,92,4456,-1,4420,4413,7700,-1,4413,4420,4412,-1,4078,3281,3280,-1,3281,4078,95,-1,7701,4452,7699,-1,4452,7701,4442,-1,4077,7698,98,-1,7698,4077,7702,-1,4450,4459,4448,-1,4459,4450,4444,-1,95,3387,4445,-1,95,97,3387,-1,4438,92,4079,-1,4456,92,4438,-1,4080,7703,89,-1,7703,4080,4439,-1,4434,7704,4443,-1,7704,4434,7705,-1,4432,100,4441,-1,100,4432,7706,-1,4389,3293,4447,-1,4389,3294,3293,-1,86,96,4439,-1,96,86,84,-1,7707,4435,7708,-1,4435,7707,4425,-1,7709,4433,7710,-1,4433,7709,4427,-1,7711,4081,7712,-1,4081,7711,87,-1,4429,7713,7714,-1,4429,4428,7713,-1,7715,4425,7707,-1,4425,7715,4423,-1,7716,4427,7709,-1,4427,7716,4430,-1,4421,7700,103,-1,4420,7700,4421,-1,4417,7717,4083,-1,4416,7717,4417,-1,4415,7718,4380,-1,4415,4497,7718,-1,7719,4376,4412,-1,7719,7720,4376,-1,4411,4394,4393,-1,4411,4487,4394,-1,4410,4391,4388,-1,4410,4440,4391,-1,4403,4436,4401,-1,4436,4403,7721,-1,4384,4397,4399,-1,4488,4397,4384,-1,3338,4379,3342,-1,3338,4382,4379,-1,4524,7676,4522,-1,4524,4230,7676,-1,4394,7691,4392,-1,4394,7722,7691,-1,3294,4391,7723,-1,4391,3294,4389,-1,3290,7721,3291,-1,3381,7721,3290,-1,4400,4383,7698,-1,4400,4386,4383,-1,7718,4381,4380,-1,7718,7690,4381,-1,7720,90,4376,-1,7720,91,90,-1,4294,3319,7724,-1,4294,4300,3319,-1,4296,4300,4294,-1,7725,4300,4296,-1,7725,4298,4300,-1,7726,4298,7725,-1,4291,4298,7726,-1,3326,4298,4291,-1,3326,4091,4298,-1,42,4091,3326,-1,41,4091,42,-1,7727,4091,41,-1,7728,4091,7727,-1,7728,4290,4091,-1,73,4205,4366,-1,4205,73,6,-1,4365,7729,4363,-1,4365,7730,7729,-1,4084,4179,70,-1,4179,4084,4353,-1,4361,4348,7731,-1,4361,4360,4348,-1,66,4163,4304,-1,65,4163,66,-1,57,7,63,-1,7,57,4358,-1,7732,4357,4177,-1,7732,4334,4357,-1,7733,4355,4174,-1,7733,4331,4355,-1,4304,4354,66,-1,4304,4301,4354,-1,7734,4353,4084,-1,4353,7734,4351,-1,7735,4348,4360,-1,4348,7735,4350,-1,61,4339,62,-1,61,4337,4339,-1,4354,4344,4346,-1,4354,52,4344,-1,4320,4342,4351,-1,4342,4320,4340,-1,4350,4336,4338,-1,4350,4318,4336,-1,58,4328,59,-1,58,4335,4328,-1,4359,4326,4332,-1,4359,3378,4326,-1,4356,4324,4329,-1,4356,4323,4324,-1,7736,50,7737,-1,50,7736,51,-1,4088,34,4093,-1,4088,59,34,-1,7738,4325,4323,-1,7738,7739,4325,-1,62,4295,4322,-1,62,4339,4295,-1,4089,4344,52,-1,4344,4089,7740,-1,4340,3325,3324,-1,4340,4320,3325,-1,4318,4293,4336,-1,4318,4317,4293,-1,3374,4313,37,-1,4311,4313,3374,-1,4311,7741,4314,-1,4311,4315,7741,-1,50,4310,4307,-1,50,49,4310,-1,43,4306,3322,-1,7742,4306,43,-1,4165,4304,4163,-1,4304,4165,4302,-1,4299,4091,4090,-1,4299,4298,4091,-1,7724,4295,4294,-1,4322,4295,7724,-1,4292,7726,4319,-1,4292,4291,7726,-1,4290,7740,4089,-1,7740,4290,7728,-1,3377,7736,3375,-1,7736,3377,4372,-1,4087,3374,60,-1,4285,3374,4087,-1,49,3314,4310,-1,49,3315,3314,-1,4327,4283,4368,-1,4327,4284,4283,-1,36,3317,4093,-1,3317,36,4370,-1,4373,4281,4280,-1,7739,4281,4373,-1,3372,29,4277,-1,29,3372,30,-1,849,4276,4109,-1,849,848,4276,-1,7743,2866,4268,-1,5427,2866,7743,-1,4273,4272,5426,-1,4273,4263,4272,-1,4270,4622,4269,-1,4270,3329,4622,-1,4615,4109,4276,-1,4109,4615,4614,-1,4617,4266,7744,-1,4266,4617,4264,-1,7745,4569,7746,-1,4569,7745,7747,-1,3330,7748,30,-1,7749,7748,3330,-1,3359,4259,7746,-1,3359,0,4259,-1,4228,844,7750,-1,844,4228,4256,-1,5424,4225,4252,-1,5424,4223,4225,-1,4250,5423,4220,-1,4249,5423,4250,-1,7751,4247,3348,-1,7751,2867,4247,-1,5422,4217,4216,-1,5422,5420,4217,-1,4227,3343,4521,-1,4227,11,3343,-1,7684,4243,4237,-1,7752,4243,7684,-1,14,7681,15,-1,14,4242,7681,-1,4240,4221,4235,-1,4221,4240,7753,-1,4239,7684,4237,-1,7684,4239,7682,-1,4235,18,17,-1,4235,4221,18,-1,74,4095,3368,-1,4095,74,3380,-1,15,4247,16,-1,15,7754,4247,-1,4232,26,3369,-1,27,26,4232,-1,4524,4255,4256,-1,4524,4523,4255,-1,4225,7755,4253,-1,4224,7755,4225,-1,18,79,19,-1,77,79,18,-1,7752,4217,4248,-1,7752,4215,4217,-1,4213,5399,4192,-1,4212,5399,4213,-1,4210,7756,4208,-1,4210,2873,7756,-1,4366,839,7757,-1,839,4366,4205,-1,5401,4204,4202,-1,5401,7758,4204,-1,4200,4182,4199,-1,4200,7420,4182,-1,4097,7423,8,-1,7423,4097,7759,-1,4178,7760,4197,-1,7760,4178,4186,-1,7761,7762,7758,-1,7761,7763,7762,-1,7764,4192,3353,-1,4213,4192,7764,-1,4208,7765,7730,-1,4208,7756,7765,-1,4185,4361,4196,-1,4185,4187,4361,-1,4085,4199,4182,-1,4199,4085,67,-1,4097,64,7759,-1,4097,65,64,-1,4179,4186,4178,-1,4186,4179,4184,-1,7762,4177,4176,-1,7762,7732,4177,-1,38,4169,7766,-1,4172,4169,38,-1,7427,7767,2872,-1,7427,4189,7767,-1,4166,4175,4305,-1,4166,7768,4175,-1,4201,830,2874,-1,7766,830,4201,-1,4162,4158,7769,-1,4162,4156,4158,-1,4155,4110,4154,-1,4110,4155,4111,-1,4158,4150,7770,-1,4158,4153,4150,-1,7771,167,4745,-1,4155,167,7771,-1,7772,4143,4103,-1,7772,7773,4143,-1,4148,4105,4107,-1,4148,4147,4105,-1,4147,4141,7774,-1,4147,4139,4141,-1,4144,4137,4149,-1,4144,4135,4137,-1,4141,4131,7775,-1,4141,4140,4131,-1,4136,7776,4137,-1,4136,3266,7776,-1,4133,4584,4138,-1,4133,4132,4584,-1,7776,4130,4129,-1,7776,7777,4130,-1,4113,7778,4128,-1,4113,3365,7778,-1,4125,7779,5386,-1,4125,4127,7779,-1,4124,4677,4122,-1,4124,149,4677,-1,4121,4127,4120,-1,4121,4162,4127,-1,4124,4119,7625,-1,4117,4119,4124,-1,7600,4112,7780,-1,7600,7601,4112,-1,4111,4121,3363,-1,4111,4161,4121,-1,4106,846,4104,-1,846,4106,803,-1,4102,3973,4100,-1,3973,4102,7434,-1,4106,7781,7782,-1,4106,4105,7781,-1,4102,4,3,-1,4102,4101,4,-1,7746,3360,3359,-1,4569,3360,7746,-1,4108,4103,4100,-1,4108,7772,4103,-1,4614,4104,4109,-1,4614,4107,4104,-1,801,7782,4108,-1,804,7782,801,-1,4767,7625,4119,-1,4767,4766,7625,-1,4159,3362,4115,-1,4159,4110,3362,-1,7780,4114,7783,-1,7780,4112,4114,-1,7769,4118,7779,-1,7769,4116,4118,-1,4118,4123,7784,-1,4118,4117,4123,-1,3364,4126,7785,-1,3364,4120,4126,-1,7783,3493,3027,-1,7783,4114,3493,-1,4130,4262,4099,-1,4262,4130,4565,-1,4140,4134,4131,-1,4140,7661,4134,-1,4145,4138,4135,-1,4145,4133,4138,-1,4586,4139,4146,-1,4586,4142,4139,-1,7773,4145,4143,-1,7773,7775,4145,-1,7781,7773,7772,-1,7781,7774,7773,-1,4149,4101,4144,-1,4101,4149,4,-1,4157,4151,4153,-1,4157,4744,4151,-1,4755,4154,4160,-1,4755,4060,4154,-1,7771,4156,4161,-1,7771,4157,4156,-1,4160,7601,3213,-1,7601,4160,4159,-1,7765,7767,7786,-1,7767,7765,7756,-1,834,10,9,-1,10,834,4164,-1,4305,4168,4166,-1,4188,4168,4305,-1,829,4171,836,-1,829,4169,4171,-1,7764,4174,4173,-1,7764,7733,4174,-1,5,7787,7763,-1,5,4098,7787,-1,71,4180,7788,-1,4180,71,70,-1,4171,4165,4164,-1,4171,4170,4165,-1,4194,4183,4181,-1,4194,7731,4183,-1,5,7761,4206,-1,7761,5,7763,-1,4175,4211,4173,-1,7768,4211,4175,-1,4204,3366,4191,-1,4204,4176,3366,-1,4185,4193,7419,-1,4193,4185,4196,-1,7788,4198,7416,-1,4198,7788,4180,-1,836,4164,834,-1,836,4171,4164,-1,4195,4181,7789,-1,4195,4194,4181,-1,4206,5403,837,-1,5403,4206,7761,-1,7421,4209,4367,-1,7421,4207,4209,-1,7768,4214,4211,-1,2875,4214,7768,-1,4218,3334,4216,-1,4218,14,3334,-1,4220,4243,4250,-1,4219,4243,4220,-1,4222,7753,3337,-1,4222,4221,7753,-1,7790,7677,7791,-1,7792,7677,7790,-1,11,4229,12,-1,11,4227,4229,-1,3380,4233,4095,-1,3380,4231,4233,-1,3340,3368,3341,-1,74,3368,3340,-1,3339,3342,3367,-1,3338,3342,3339,-1,4240,3369,22,-1,4240,4232,3369,-1,4508,4242,4241,-1,4242,4508,7687,-1,3337,4234,4222,-1,3337,3336,4234,-1,23,4517,24,-1,23,7754,4517,-1,7683,4218,4215,-1,4218,7683,4241,-1,4238,3270,3269,-1,4219,3270,4238,-1,7790,845,4255,-1,845,7790,7793,-1,13,4246,3344,-1,4246,13,12,-1,4251,4217,5420,-1,4251,4248,4217,-1,4254,3370,4244,-1,3370,4254,4253,-1,7791,7793,7790,-1,7411,7793,7791,-1,7745,4257,7748,-1,7745,4261,4257,-1,0,3358,1,-1,0,3359,3358,-1,4261,4258,4257,-1,4258,4261,4260,-1,7794,4268,4267,-1,7743,4268,7794,-1,4094,4275,32,-1,4275,4094,7795,-1,4272,7796,3328,-1,4272,4271,7796,-1,4266,5428,7744,-1,4274,5428,4266,-1,3371,3361,2865,-1,3371,3358,3361,-1,32,850,852,-1,850,32,4275,-1,3329,4278,3327,-1,4278,3329,4270,-1,3318,4282,4279,-1,3318,4371,4282,-1,34,4368,35,-1,34,4327,4368,-1,48,51,4369,-1,47,51,48,-1,7786,7797,7765,-1,7786,4308,7797,-1,4325,4289,4286,-1,4325,4374,4289,-1,4288,4375,56,-1,4288,4287,4375,-1,7727,40,7798,-1,40,7727,41,-1,4317,4296,4293,-1,4317,7725,4296,-1,4300,3320,3319,-1,4297,3320,4300,-1,4303,53,4301,-1,53,4303,7799,-1,3376,4092,45,-1,3375,4092,3376,-1,3375,7737,4092,-1,7736,7737,3375,-1,4190,4308,7786,-1,4190,4309,4308,-1,4172,4312,4170,-1,4172,4313,4312,-1,3320,4315,4285,-1,4297,4315,3320,-1,4316,4292,4319,-1,4316,4343,4292,-1,7798,4321,4347,-1,4321,7798,40,-1,7741,4090,7799,-1,7741,4299,4090,-1,4288,4324,4286,-1,4330,4324,4288,-1,4326,4281,4333,-1,4326,4279,4281,-1,4328,4284,4327,-1,4328,3379,4284,-1,55,4331,4330,-1,4355,4331,55,-1,4334,7738,4357,-1,4334,4333,7738,-1,57,3316,4358,-1,57,4088,3316,-1,45,4355,55,-1,44,4355,45,-1,4343,7735,4341,-1,7735,4343,4316,-1,4347,7734,4345,-1,7734,4347,4321,-1,4314,7799,4303,-1,4314,7741,7799,-1,68,4338,4337,-1,68,4349,4338,-1,4342,4362,4352,-1,4362,4342,4341,-1,3312,4345,72,-1,3312,4346,4345,-1,7742,4309,4306,-1,4309,7742,4307,-1,3354,4329,3355,-1,3354,4356,4329,-1,4098,4332,7787,-1,4098,4359,4332,-1,4335,4086,4363,-1,4086,4335,58,-1,68,4183,4349,-1,4085,4183,68,-1,4352,4187,4184,-1,4187,4352,4362,-1,4086,73,4364,-1,73,4086,63,-1,4306,4190,4188,-1,4190,4306,4309,-1,4365,4367,4209,-1,4367,4365,4364,-1,7711,7800,7801,-1,7800,7711,7712,-1,4378,4467,7802,-1,4378,4377,4467,-1,4403,3291,7721,-1,4403,7702,3291,-1,4399,4385,4384,-1,4399,3389,4385,-1,3303,4406,4405,-1,4406,3303,3295,-1,4390,4409,4388,-1,4409,4390,7693,-1,4395,78,4393,-1,3268,78,4395,-1,4396,3336,3335,-1,4398,3336,4396,-1,4386,4402,4463,-1,4402,4386,4400,-1,4437,4406,7723,-1,4437,4404,4406,-1,4486,4409,7722,-1,4486,4408,4409,-1,7803,7801,7800,-1,7803,7804,7801,-1,7805,4378,7802,-1,7805,4413,4378,-1,28,4382,3338,-1,28,4414,4382,-1,101,4418,104,-1,7806,4418,101,-1,81,4422,4419,-1,80,4422,81,-1,4426,7807,4424,-1,7807,4426,7808,-1,3290,7809,4387,-1,3290,3385,7809,-1,3286,7810,3287,-1,3286,4431,7810,-1,4429,7706,4432,-1,7706,4429,7714,-1,4424,7705,4434,-1,7705,4424,7807,-1,4079,3296,4438,-1,4079,3301,3296,-1,7712,4080,91,-1,4080,7712,4081,-1,3292,7702,4077,-1,7702,3292,3291,-1,7710,4442,7701,-1,4442,7710,4433,-1,7708,4444,4450,-1,4444,7708,4435,-1,4422,4412,4420,-1,4412,4422,7719,-1,4446,94,93,-1,4446,3386,94,-1,4439,4078,7703,-1,4078,4439,96,-1,4390,4447,4449,-1,4390,4389,4447,-1,4441,99,4451,-1,99,4441,100,-1,4443,7811,4462,-1,7811,4443,7704,-1,89,7694,4454,-1,7694,89,7703,-1,4457,3282,102,-1,4457,3283,3282,-1,4458,93,7697,-1,4458,4446,93,-1,4462,4472,4460,-1,4472,4462,7811,-1,7693,4449,4479,-1,7693,4390,4449,-1,4451,4468,4464,-1,4468,4451,99,-1,4466,4458,4484,-1,4466,4453,4458,-1,7700,7805,7806,-1,7805,7700,4413,-1,7696,4455,7692,-1,7696,7695,4455,-1,4475,4489,4473,-1,4489,4475,4465,-1,4477,4493,4478,-1,4493,4477,4461,-1,4471,4385,4469,-1,4385,4471,4383,-1,4483,7696,7812,-1,4483,4482,7696,-1,3388,4073,4485,-1,4073,3388,3279,-1,7806,4497,4418,-1,4497,7806,7805,-1,4469,3389,3274,-1,3389,4469,4385,-1,4473,4491,4510,-1,4491,4473,4489,-1,4495,4478,4493,-1,4495,4502,4478,-1,105,4417,107,-1,4417,105,104,-1,4499,7812,7685,-1,4499,4483,7812,-1,4485,4075,4500,-1,4075,4485,4073,-1,4502,4239,4236,-1,4239,4502,4495,-1,4490,4506,7680,-1,4506,4490,4505,-1,4494,4509,7682,-1,4509,4494,4507,-1,4513,4381,4512,-1,4513,4379,4381,-1,111,4076,3271,-1,111,7688,4076,-1,4072,4515,4518,-1,4515,4072,4498,-1,3268,4503,3269,-1,3268,4395,4503,-1,4515,7678,4519,-1,7678,4515,4516,-1,4511,7676,4521,-1,7676,4511,7686,-1,75,4514,4083,-1,75,3310,4514,-1,3390,4224,109,-1,7755,4224,3390,-1,4520,7792,4523,-1,7792,4520,4519,-1,4533,7638,122,-1,7638,4533,4535,-1,3395,4529,4574,-1,3395,128,4529,-1,3264,4531,3258,-1,7674,4531,3264,-1,4068,114,4532,-1,114,4068,4070,-1,122,7639,123,-1,122,7638,7639,-1,4541,120,3257,-1,120,4541,7640,-1,4538,7642,7813,-1,4538,4537,7642,-1,4527,4545,4525,-1,4527,4543,4545,-1,4576,4546,4547,-1,4576,7814,4546,-1,7665,7673,7672,-1,7665,7815,7673,-1,3394,7816,4552,-1,3394,3261,7816,-1,4559,4600,4558,-1,4559,7655,4600,-1,4606,7749,3330,-1,7648,7749,4606,-1,7666,4562,7656,-1,7666,4560,4562,-1,7747,4571,4569,-1,4571,7747,7647,-1,140,4568,4566,-1,4568,140,4066,-1,4567,114,113,-1,4567,4566,114,-1,7777,4565,4130,-1,7669,4565,7777,-1,7674,4563,4531,-1,4554,4563,7674,-1,4547,4577,4576,-1,4583,4577,4547,-1,118,4538,131,-1,118,4069,4538,-1,3253,4544,4543,-1,3253,4579,4544,-1,131,7813,7659,-1,131,4538,7813,-1,4582,7817,4580,-1,7817,4582,7818,-1,4562,4529,4530,-1,4562,4561,4529,-1,130,119,118,-1,130,3250,119,-1,4070,121,4585,-1,4070,4068,121,-1,4580,4142,4586,-1,4142,4580,7817,-1,127,3244,134,-1,3244,127,3254,-1,4588,139,3398,-1,4588,137,139,-1,112,4585,4590,-1,112,4070,4585,-1,7658,4591,7819,-1,4591,7658,4587,-1,141,7649,7646,-1,4064,7649,141,-1,4610,3251,4595,-1,4610,3399,3251,-1,3249,4597,7650,-1,4597,3249,3248,-1,7819,4598,4613,-1,4598,7819,4591,-1,4564,7655,4559,-1,4564,7653,7655,-1,4601,4619,4593,-1,4603,4619,4601,-1,4607,4594,4605,-1,4607,4623,4594,-1,7645,4612,4609,-1,7645,4596,4612,-1,7651,4615,7795,-1,4615,7651,4613,-1,4609,7796,4271,-1,7796,4609,4611,-1,4617,4602,4616,-1,4617,7794,4602,-1,7648,7747,7749,-1,7647,7747,7648,-1,4622,4611,4621,-1,4622,7796,4611,-1,4625,4635,4632,-1,4625,7820,4635,-1,7637,4631,4628,-1,7637,7591,4631,-1,4634,7467,7821,-1,4634,7616,7467,-1,5256,4630,4636,-1,5256,4628,4630,-1,4661,142,7635,-1,4661,4660,142,-1,3239,4639,3240,-1,3239,4637,4639,-1,4640,7474,7822,-1,4640,7636,7474,-1,4647,4827,4650,-1,4647,4646,4827,-1,4651,7634,7823,-1,4651,4650,7634,-1,7591,7633,4631,-1,7591,7590,7633,-1,4655,7823,7820,-1,4655,4651,7823,-1,3237,4958,7824,-1,3236,4958,3237,-1,4638,3188,4637,-1,4638,3416,3188,-1,4641,3402,145,-1,4639,3402,4641,-1,4664,4769,7627,-1,4664,4663,4769,-1,4668,7626,4667,-1,7626,4668,4764,-1,4670,7600,7780,-1,4670,7630,7600,-1,4674,4664,4679,-1,4674,4662,4664,-1,4682,4063,4667,-1,4682,148,4063,-1,4671,3494,4669,-1,3025,3494,4671,-1,7469,4674,4678,-1,7469,4673,4674,-1,4848,4696,4693,-1,4696,4848,4847,-1,4850,4685,4697,-1,4685,4850,4683,-1,4853,4689,7825,-1,4689,4853,4687,-1,7825,4692,7826,-1,4692,7825,4689,-1,7621,4695,5271,-1,4695,7621,4693,-1,7619,4699,5272,-1,4699,7619,4697,-1,4702,7827,3234,-1,4702,4701,7827,-1,4706,7605,4705,-1,7605,4706,7828,-1,4709,3232,3404,-1,3232,4709,7829,-1,4712,7830,4719,-1,4712,4711,7830,-1,4717,7831,4715,-1,7831,4717,7832,-1,4710,4718,3405,-1,4718,4710,4712,-1,7831,155,7604,-1,155,7831,7606,-1,3226,4702,7833,-1,3226,4700,4702,-1,4728,7605,7613,-1,4728,4726,7605,-1,4728,3406,3225,-1,3406,4728,4062,-1,166,3403,3220,-1,166,7833,3403,-1,4736,4722,4721,-1,4736,4730,4722,-1,3405,7603,3229,-1,7603,3405,4718,-1,3230,4743,158,-1,4743,3230,3229,-1,4727,161,4061,-1,3217,161,4727,-1,4738,4730,4736,-1,4738,4740,4730,-1,4733,4742,4152,-1,4742,4733,4740,-1,158,4745,167,-1,4745,158,4743,-1,3224,3409,3215,-1,3409,3224,3223,-1,4762,3219,4747,-1,4762,164,3219,-1,4737,4751,4753,-1,4751,4737,4749,-1,4754,4741,4753,-1,4754,4768,4741,-1,3216,4757,3408,-1,7834,4757,3216,-1,4747,4760,4762,-1,7602,4760,4747,-1,4764,4760,7629,-1,4764,4761,4760,-1,7628,4768,4754,-1,7628,4766,4768,-1,4770,7834,7630,-1,4770,4757,7834,-1,4773,7588,4792,-1,4773,4772,7588,-1,4778,4796,4776,-1,4796,4778,7584,-1,4781,7581,4797,-1,4781,4780,7581,-1,4786,4801,4784,-1,4801,4786,7585,-1,4788,4805,4789,-1,4805,4788,7582,-1,3211,4789,3212,-1,3211,4787,4789,-1,4795,4771,4813,-1,4795,4794,4771,-1,4800,4814,4798,-1,4814,4800,4777,-1,4802,4779,4820,-1,4802,4804,4779,-1,4808,7598,4806,-1,7598,4808,4785,-1,4807,4824,4809,-1,4824,4807,4806,-1,4832,4813,4810,-1,4832,4795,4813,-1,4798,3411,3207,-1,3411,4798,4814,-1,4823,4820,4817,-1,4823,4802,4820,-1,4840,4823,4821,-1,4840,7597,4823,-1,4809,3412,3206,-1,3412,4809,4824,-1,4830,4810,4648,-1,4830,4832,4810,-1,4835,4833,4834,-1,4835,4819,4833,-1,173,4835,4059,-1,173,4822,4835,-1,4825,4839,7593,-1,4839,4825,4837,-1,3202,4849,4842,-1,4849,3202,7594,-1,4059,4851,171,-1,4851,4059,4836,-1,4839,4845,4852,-1,4845,4839,4838,-1,7590,4645,7633,-1,7590,4841,4645,-1,4843,4848,7622,-1,4848,4843,4842,-1,172,4850,7620,-1,4850,172,171,-1,7592,4853,7618,-1,4853,7592,4852,-1,4912,4856,4855,-1,4856,4912,4911,-1,4638,4643,7835,-1,4638,3241,4643,-1,5296,7541,7542,-1,5295,7541,5296,-1,2961,4863,4864,-1,2961,4861,4863,-1,7460,4868,4870,-1,7836,4868,7460,-1,7837,4873,4872,-1,4883,4873,7837,-1,5046,4886,7838,-1,5046,5043,4886,-1,7577,7839,7836,-1,7577,7840,7839,-1,5059,4884,4883,-1,5059,5058,4884,-1,7838,4888,7458,-1,4888,7838,4886,-1,4868,4879,4869,-1,4868,7841,4879,-1,4856,4907,4854,-1,4856,5103,4907,-1,7567,4896,4893,-1,7567,5106,4896,-1,4900,7574,4898,-1,4900,4891,7574,-1,7842,4903,4908,-1,4903,7842,4901,-1,4892,7571,4890,-1,4892,5303,7571,-1,7570,3994,668,-1,3994,7570,4908,-1,7454,4895,4910,-1,7454,4893,4895,-1,2949,4900,4897,-1,2949,2948,4900,-1,4058,7843,181,-1,4915,7843,4058,-1,7844,3198,4929,-1,7844,7566,3198,-1,4926,4921,4918,-1,7845,4921,4926,-1,7846,4924,3201,-1,7846,4922,4924,-1,4916,7846,174,-1,4917,7846,4916,-1,4917,4922,7846,-1,7565,4922,4917,-1,7565,4925,4922,-1,7565,7561,4925,-1,7843,7561,7565,-1,7843,7845,7561,-1,4915,7845,7843,-1,4914,7845,4915,-1,4914,4921,7845,-1,7566,4921,4914,-1,7566,4919,4921,-1,7844,4919,7566,-1,7844,7564,4919,-1,7562,4928,7847,-1,4928,7562,4926,-1,195,179,178,-1,195,182,179,-1,4930,7563,4929,-1,4930,7848,7563,-1,7848,4933,4931,-1,7560,4933,7848,-1,7847,188,4056,-1,197,188,7847,-1,4935,178,177,-1,4935,194,178,-1,4054,184,183,-1,4054,186,184,-1,3196,4057,186,-1,3196,4938,4057,-1,4933,4942,4932,-1,4948,4942,4933,-1,189,3195,4951,-1,3195,189,188,-1,4944,4935,4934,-1,4944,4945,4935,-1,7559,4947,4955,-1,4947,7559,4945,-1,7552,4938,3192,-1,7552,4937,4938,-1,7550,4942,4949,-1,7550,4940,4942,-1,7556,4944,4943,-1,7556,4946,4944,-1,4947,7547,4956,-1,7547,4947,4946,-1,199,7824,4958,-1,7824,199,198,-1,7546,4950,4959,-1,7546,4949,4950,-1,4952,4962,4953,-1,4962,4952,3414,-1,203,4964,201,-1,4964,203,4953,-1,4957,4659,4656,-1,4659,4957,4956,-1,4967,7553,4974,-1,4967,4961,7553,-1,4967,4969,4966,-1,4976,4969,4967,-1,7549,4971,4965,-1,4978,4971,7549,-1,7548,4051,4981,-1,4051,7548,205,-1,4977,4973,7835,-1,4977,4976,4973,-1,7544,4980,4978,-1,4862,4980,7544,-1,4051,4986,4982,-1,4986,4051,204,-1,4660,143,142,-1,4983,143,4660,-1,4986,7541,4985,-1,7541,4986,7543,-1,5050,208,207,-1,5050,4997,208,-1,3178,4989,3421,-1,3178,4998,4989,-1,4994,4993,7849,-1,4993,4994,4992,-1,7525,5000,5053,-1,209,5000,7525,-1,5000,3176,7538,-1,5000,3177,3176,-1,5003,5056,7850,-1,5003,5001,5056,-1,5012,5051,7527,-1,5051,5012,5011,-1,5007,7851,7850,-1,5007,5006,7851,-1,5010,5052,5009,-1,5052,5010,5047,-1,5013,5005,5011,-1,5005,5013,5049,-1,7526,5017,5040,-1,7526,5015,5017,-1,7841,4046,4879,-1,5021,4046,7841,-1,5042,4049,3420,-1,4049,5042,4048,-1,5055,5024,5023,-1,5035,5024,5055,-1,7535,7840,7852,-1,7535,7839,7840,-1,5058,5030,4884,-1,7853,5030,5058,-1,5032,5022,7853,-1,5032,4047,5022,-1,5025,5034,5033,-1,7852,5034,5025,-1,213,7530,214,-1,213,5038,7530,-1,5040,7533,5038,-1,7533,5040,5017,-1,3420,5031,3180,-1,5031,3420,4049,-1,4046,4881,4879,-1,4881,4046,214,-1,5044,5037,3181,-1,5044,5043,5037,-1,5047,7849,4993,-1,5047,5010,7849,-1,4987,7851,7540,-1,5048,7851,4987,-1,7539,5049,5013,-1,5049,7539,5050,-1,5052,7536,5016,-1,7536,5052,7537,-1,5054,5039,5020,-1,5039,5054,7854,-1,5057,5002,5028,-1,5057,5001,5002,-1,5093,5068,7521,-1,5068,5093,5066,-1,5071,3169,5069,-1,5071,3170,3169,-1,7855,237,3168,-1,7855,5092,237,-1,5071,5064,5061,-1,5071,4045,5064,-1,5070,4045,5071,-1,5070,219,4045,-1,7855,219,5070,-1,7855,3168,219,-1,5075,7516,225,-1,7516,5075,7520,-1,226,5091,5077,-1,5091,226,5090,-1,235,5079,4041,-1,235,4043,5079,-1,231,3167,229,-1,3167,231,7514,-1,5082,5145,5080,-1,5145,5082,7519,-1,5085,7504,7517,-1,5083,7504,5085,-1,7518,5088,5086,-1,7518,5142,5088,-1,5091,5069,7520,-1,5091,5072,5069,-1,238,236,4041,-1,238,222,236,-1,5063,7519,5082,-1,7519,5063,5062,-1,5094,5084,5089,-1,5084,5094,5067,-1,5096,5137,5097,-1,5096,5135,5137,-1,5102,5162,5098,-1,5099,5162,5102,-1,5095,4907,5104,-1,5095,4905,4907,-1,7572,5108,5106,-1,7572,5111,5108,-1,5105,7573,5109,-1,5103,7573,5105,-1,5108,7510,5107,-1,5112,7510,5108,-1,5110,5101,5100,-1,5115,5101,5110,-1,7856,5113,5118,-1,7856,5112,5113,-1,5140,5122,5129,-1,5122,5140,5120,-1,5138,5126,5125,-1,5126,5138,5135,-1,5122,5155,5128,-1,5122,5121,5155,-1,7574,5133,5139,-1,5133,7574,5131,-1,5137,4901,7842,-1,5137,5136,4901,-1,5133,5123,5120,-1,5133,5132,5123,-1,7503,5142,7518,-1,5142,7503,5141,-1,5076,7857,227,-1,5076,5143,7857,-1,7498,5074,4042,-1,7498,3429,5074,-1,5147,7858,5146,-1,5147,7496,7858,-1,7495,3163,5149,-1,7495,3164,3163,-1,7494,5143,5150,-1,7494,7857,5143,-1,3430,3159,5152,-1,3430,3428,3159,-1,3156,5130,5128,-1,5130,3156,3155,-1,5127,5148,7502,-1,5127,5124,5148,-1,7501,5158,5151,-1,5161,5158,7501,-1,5159,7500,7493,-1,5159,5153,7500,-1,5118,5159,7856,-1,5118,5154,5159,-1,4905,5097,7569,-1,4905,5095,5097,-1,5116,5157,5115,-1,5116,7492,5157,-1,452,7448,5209,-1,5165,7448,452,-1,3470,3062,4003,-1,3470,454,3062,-1,5169,7395,5167,-1,5169,7859,7395,-1,5172,2851,2852,-1,5172,5173,2851,-1,3120,3441,2734,-1,3441,3120,3119,-1,308,3127,3124,-1,3127,308,307,-1,3144,241,3150,-1,3144,239,241,-1,259,3436,3139,-1,3436,259,258,-1,252,3140,380,-1,3140,252,259,-1,3463,274,276,-1,3134,274,3463,-1,958,4035,284,-1,958,3137,4035,-1,3439,3134,4036,-1,262,3134,3439,-1,278,281,3133,-1,278,282,281,-1,306,292,3440,-1,292,306,381,-1,3437,298,4034,-1,298,3437,299,-1,4033,909,1040,-1,4033,915,909,-1,256,253,257,-1,256,3139,253,-1,3125,915,4033,-1,915,3125,913,-1,2737,240,4037,-1,240,2737,940,-1,7860,310,309,-1,3031,310,7860,-1,3039,326,557,-1,326,3039,4030,-1,3518,7489,4013,-1,7489,3518,3516,-1,3114,320,3117,-1,3114,316,320,-1,333,1025,1009,-1,333,332,1025,-1,4027,3108,3110,-1,346,3108,4027,-1,5184,351,7861,-1,351,5184,950,-1,5180,3446,926,-1,5180,3941,3446,-1,4025,4026,359,-1,361,4026,4025,-1,291,378,296,-1,291,290,378,-1,3093,246,245,-1,3093,380,246,-1,1016,3096,5181,-1,1016,384,3096,-1,5482,5182,7389,-1,5482,2738,5182,-1,5540,5184,7487,-1,5184,5540,5183,-1,2824,3092,1039,-1,2824,348,3092,-1,3940,5476,7862,-1,3956,5476,3940,-1,5480,5187,1043,-1,5480,3955,5187,-1,2763,408,407,-1,2763,401,408,-1,984,2787,432,-1,2787,984,985,-1,3544,412,394,-1,412,3544,413,-1,428,2783,2782,-1,428,5493,2783,-1,3080,436,438,-1,436,3080,3079,-1,3079,3083,436,-1,3459,3083,3079,-1,7377,5194,5191,-1,5523,5194,7377,-1,1025,7372,3111,-1,1025,1026,7372,-1,3958,7402,7391,-1,5197,7402,3958,-1,5532,2811,3557,-1,7863,2811,5532,-1,2799,5201,4023,-1,5201,2799,5200,-1,3112,1009,1025,-1,3112,1010,1009,-1,3078,5202,5188,-1,3078,3077,5202,-1,3070,5205,5204,-1,3070,3071,5205,-1,945,3465,943,-1,879,3465,945,-1,5208,5210,5209,-1,5207,5210,5208,-1,3049,3467,3050,-1,3049,4019,3467,-1,460,3057,461,-1,3057,460,3058,-1,460,3499,3058,-1,460,3056,3499,-1,3477,5216,7864,-1,5216,3477,3476,-1,5217,5216,5215,-1,5217,7865,5216,-1,3504,7866,5220,-1,7866,3504,2933,-1,4017,5310,478,-1,5310,4017,7449,-1,551,489,3481,-1,551,490,489,-1,5226,5391,5224,-1,5282,5391,5226,-1,502,3048,503,-1,3048,502,562,-1,5261,5229,5231,-1,5261,5283,5229,-1,511,3481,5274,-1,551,3481,511,-1,504,5266,7867,-1,3045,5266,504,-1,324,5235,5234,-1,324,4030,5235,-1,3036,329,4031,-1,329,3036,327,-1,515,5281,3002,-1,515,514,5281,-1,673,2939,471,-1,673,5237,2939,-1,556,309,3517,-1,556,7860,309,-1,3518,5239,674,-1,5239,3518,3113,-1,3022,552,510,-1,546,552,3022,-1,7436,4128,7778,-1,7436,3028,4128,-1,4038,7476,5328,-1,7476,4038,5391,-1,5241,7449,4017,-1,7449,5241,5265,-1,322,534,5238,-1,534,322,321,-1,7868,5244,5243,-1,7868,559,5244,-1,519,5273,3042,-1,519,3016,5273,-1,564,7468,598,-1,570,7468,564,-1,5248,575,3008,-1,5248,4012,575,-1,3487,4011,578,-1,5249,4011,3487,-1,588,3019,5254,-1,588,3496,3019,-1,4636,5257,5256,-1,5250,5257,4636,-1,572,7821,573,-1,572,5259,7821,-1,582,3238,4010,-1,582,3242,3238,-1,144,5285,3014,-1,144,4858,5285,-1,593,4007,591,-1,4007,593,590,-1,4030,3038,5235,-1,3038,4030,3039,-1,5241,3484,5279,-1,3484,5241,4006,-1,5262,7867,5266,-1,5262,7473,7867,-1,602,7473,3003,-1,7473,602,7867,-1,3042,522,558,-1,3042,5268,522,-1,5270,7868,4680,-1,5270,5269,7868,-1,7466,570,569,-1,7826,570,7466,-1,4012,4695,4694,-1,4012,5248,4695,-1,7615,5246,7475,-1,5271,5246,7615,-1,7477,5275,5274,-1,7477,7472,5275,-1,4004,5228,592,-1,4004,5231,5228,-1,5264,5280,5330,-1,5280,5264,5279,-1,5236,5235,3038,-1,5235,5236,5233,-1,7464,7472,7477,-1,7464,7463,7472,-1,7465,592,5228,-1,7465,3000,592,-1,4002,505,2932,-1,506,505,4002,-1,4001,661,660,-1,661,4001,5288,-1,3500,619,7869,-1,3011,619,3500,-1,626,4000,3999,-1,4000,626,5286,-1,497,2979,628,-1,497,617,2979,-1,3510,5287,5288,-1,3510,632,5287,-1,5290,5307,2958,-1,5289,5307,5290,-1,3997,639,3996,-1,639,3997,640,-1,2945,4014,4015,-1,528,4014,2945,-1,3996,3513,5291,-1,3996,639,3513,-1,5307,2975,3998,-1,5307,2976,2975,-1,7459,626,625,-1,626,7459,5295,-1,4866,5297,4864,-1,4866,7461,5297,-1,4888,5299,7870,-1,4885,5299,4888,-1,2977,4867,629,-1,4867,2977,4870,-1,2957,4872,5298,-1,4872,2957,7837,-1,7576,658,5300,-1,4875,658,7576,-1,7870,2982,2981,-1,7870,5299,2982,-1,2958,5298,5290,-1,2957,5298,2958,-1,2952,667,666,-1,2952,650,667,-1,5304,2971,2970,-1,2946,2971,5304,-1,5305,7568,5303,-1,7568,5305,7453,-1,5291,2953,7453,-1,5291,3513,2953,-1,4910,654,7454,-1,4910,3509,654,-1,667,5306,668,-1,667,3995,5306,-1,4014,3998,2975,-1,4014,636,3998,-1,3061,5163,3059,-1,1546,5163,3061,-1,4031,536,3492,-1,4031,4032,536,-1,5310,2935,2937,-1,5310,3480,2935,-1,2991,5222,5220,-1,5308,5222,2991,-1,5239,5238,534,-1,5239,5237,5238,-1,5260,581,590,-1,605,581,5260,-1,7447,3477,7864,-1,7447,5314,3477,-1,5316,2916,2928,-1,2916,5316,5318,-1,7865,2997,516,-1,2997,7865,5217,-1,745,677,679,-1,745,744,677,-1,685,3992,683,-1,3992,685,855,-1,687,2925,3991,-1,687,3532,2925,-1,7409,7871,3960,-1,7409,5431,7871,-1,5329,5166,4039,-1,5166,5329,5433,-1,7409,5327,7408,-1,7409,5326,5327,-1,5390,4040,5324,-1,4038,4040,5390,-1,5280,7872,5331,-1,5280,3146,7872,-1,5322,5278,5333,-1,5278,5322,5276,-1,712,716,710,-1,712,2861,716,-1,3527,711,709,-1,3527,712,711,-1,3984,5335,5334,-1,3984,3986,5335,-1,3985,2846,7397,-1,5438,2846,3985,-1,3527,704,766,-1,704,3527,3987,-1,7873,2896,5339,-1,7873,722,2896,-1,682,7874,7875,-1,682,678,7874,-1,2917,5336,7396,-1,2917,713,5336,-1,5382,3974,5344,-1,5382,5379,3974,-1,7440,5172,5170,-1,7440,7875,5172,-1,675,2878,758,-1,675,744,2878,-1,691,811,3971,-1,811,691,690,-1,5347,7400,5363,-1,5347,5345,7400,-1,5352,7415,5394,-1,5351,7415,5352,-1,3993,5415,741,-1,5414,5415,3993,-1,755,746,2910,-1,755,7876,746,-1,3966,5411,5410,-1,5411,3966,7429,-1,3535,3979,761,-1,5358,3979,3535,-1,3969,2871,843,-1,2871,3969,7428,-1,5362,5348,5430,-1,5361,5348,5362,-1,5366,7439,7859,-1,5365,7439,5366,-1,2924,748,747,-1,2924,3981,748,-1,772,810,812,-1,772,7877,810,-1,5370,765,2858,-1,765,5370,778,-1,5372,3977,717,-1,5371,3977,5372,-1,3977,3976,781,-1,5376,3976,3977,-1,5375,7410,5374,-1,5375,851,7410,-1,5373,5377,5371,-1,5373,5425,5377,-1,798,788,790,-1,800,788,798,-1,792,7878,2864,-1,7878,792,2882,-1,5425,794,793,-1,5425,5373,794,-1,5383,5344,7432,-1,5383,5382,5344,-1,5385,2891,2890,-1,5384,2891,5385,-1,804,800,3972,-1,800,804,801,-1,5386,5380,5381,-1,5380,5386,7784,-1,7435,7778,7785,-1,7435,7436,7778,-1,5227,5390,7443,-1,5224,5390,5227,-1,5338,7873,7441,-1,7873,5338,5337,-1,7431,898,5444,-1,5334,898,7431,-1,5227,5325,5333,-1,5227,7443,5325,-1,707,5374,720,-1,5374,707,2900,-1,717,2901,5372,-1,2901,717,770,-1,3990,5359,764,-1,5359,3990,3989,-1,5352,866,684,-1,5352,5394,866,-1,5393,868,866,-1,868,5393,5367,-1,7429,3965,5396,-1,3965,7429,3966,-1,856,3965,855,-1,856,859,3965,-1,3373,5377,5426,-1,3373,5376,5377,-1,835,824,7426,-1,825,824,835,-1,829,835,3964,-1,835,829,836,-1,5405,2873,4210,-1,5405,832,2873,-1,5398,4214,5413,-1,4214,5398,4212,-1,5402,4202,5417,-1,4202,5402,5401,-1,7757,838,7414,-1,839,838,7757,-1,5413,2875,3536,-1,4214,2875,5413,-1,5407,7789,3537,-1,7789,5407,4195,-1,4197,5412,5408,-1,7760,5412,4197,-1,5419,5356,5418,-1,5356,5419,7414,-1,7417,5355,7438,-1,5409,5355,7417,-1,756,7418,2907,-1,756,5412,7418,-1,7424,755,840,-1,7424,7876,755,-1,5397,2908,7422,-1,5397,2909,2908,-1,5400,5351,3963,-1,5400,7415,5351,-1,7877,4096,7412,-1,7877,4244,4096,-1,7750,779,778,-1,844,779,7750,-1,7751,773,776,-1,7751,3344,773,-1,4249,2903,767,-1,4251,2903,4249,-1,771,4254,772,-1,4254,771,4252,-1,7411,769,7793,-1,7411,2902,769,-1,793,4273,5425,-1,4273,793,4274,-1,3371,7437,7879,-1,3371,7878,7437,-1,851,29,852,-1,851,5375,29,-1,450,879,2920,-1,450,3465,879,-1,700,685,3526,-1,685,700,2921,-1,3993,3522,2925,-1,3993,741,3522,-1,809,5372,2901,-1,5372,809,808,-1,678,5436,7874,-1,853,5436,678,-1,7401,876,5349,-1,7401,2847,876,-1,5345,2848,7400,-1,5345,2850,2848,-1,5436,3433,3145,-1,5436,3091,3433,-1,3960,5326,7409,-1,5326,3960,2886,-1,891,2855,5434,-1,893,2855,891,-1,7406,5204,7398,-1,7406,3070,5204,-1,5196,7398,3462,-1,7406,7398,5196,-1,7405,5197,5446,-1,7405,7402,5197,-1,822,2839,861,-1,2839,822,883,-1,2845,7397,2846,-1,3528,7397,2845,-1,5437,2843,889,-1,7479,2843,5437,-1,3071,734,5205,-1,3068,734,3071,-1,3982,5439,7880,-1,3982,5438,5439,-1,7479,7399,5206,-1,5437,7399,7479,-1,874,892,875,-1,874,893,892,-1,7871,5430,2905,-1,7871,5431,5430,-1,894,2840,517,-1,896,2840,894,-1,5340,896,895,-1,896,5340,728,-1,5443,4681,3495,-1,4681,5443,4676,-1,5331,2922,806,-1,7872,2922,5331,-1,5435,2837,2836,-1,2837,5435,3961,-1,2833,877,914,-1,877,2833,878,-1,3961,280,2837,-1,280,3961,3538,-1,7376,904,7378,-1,905,904,7376,-1,5190,2835,3460,-1,2835,5190,5447,-1,415,5499,1033,-1,415,426,5499,-1,3547,7390,2801,-1,3547,3443,7390,-1,3957,5179,2832,-1,3957,3098,5179,-1,5536,5457,5535,-1,5536,5458,5457,-1,5460,5531,5529,-1,5531,5460,5462,-1,7380,5463,5465,-1,7380,7371,5463,-1,5519,5468,5470,-1,5519,5517,5468,-1,5471,3558,5472,-1,7881,3558,5471,-1,2827,5474,5473,-1,2827,2748,5474,-1,3541,3942,2825,-1,3541,2832,3942,-1,7862,3941,3940,-1,3446,3941,7862,-1,344,5186,337,-1,5186,344,342,-1,4029,363,4028,-1,4029,3449,363,-1,340,3449,4029,-1,340,3450,3449,-1,2802,5479,3105,-1,5479,2802,2801,-1,337,5476,335,-1,5476,337,5186,-1,240,249,5183,-1,240,239,249,-1,355,335,353,-1,355,336,335,-1,948,954,3445,-1,954,948,949,-1,2739,370,369,-1,2739,5481,370,-1,5481,3097,370,-1,5481,935,3097,-1,3547,3450,340,-1,2803,3450,3547,-1,5479,2747,2829,-1,2747,5479,919,-1,3081,3558,7881,-1,3559,3558,3081,-1,284,959,958,-1,284,3939,959,-1,5490,5188,5202,-1,5490,5454,5188,-1,2798,966,3953,-1,2798,3546,966,-1,5453,7381,5451,-1,7381,5453,5487,-1,930,5486,931,-1,5489,5486,930,-1,4022,970,2762,-1,4022,3952,970,-1,973,432,2787,-1,973,433,432,-1,3551,997,3555,-1,3551,2769,997,-1,2768,3950,978,-1,2768,5514,3950,-1,5495,5511,5494,-1,7368,5511,5495,-1,433,444,3072,-1,973,444,433,-1,5506,2793,2792,-1,5506,407,2793,-1,7882,1001,2767,-1,1001,7882,2745,-1,3554,434,988,-1,430,434,3554,-1,989,5501,987,-1,989,991,5501,-1,5503,5515,7383,-1,5449,5515,5503,-1,977,3948,994,-1,7387,3948,977,-1,5511,5506,5504,-1,5511,7388,5506,-1,5502,999,998,-1,999,5502,5500,-1,2779,1002,1001,-1,1002,2779,5507,-1,3086,2745,7882,-1,3086,2746,2745,-1,427,2785,428,-1,2785,427,1004,-1,2758,968,7369,-1,2797,968,2758,-1,333,1027,445,-1,333,1028,1027,-1,440,7488,441,-1,7484,7488,440,-1,3563,5527,3136,-1,5527,3563,7863,-1,7374,1014,2753,-1,7374,1015,1014,-1,383,959,3939,-1,383,1017,959,-1,5540,2756,4037,-1,7486,2756,5540,-1,5526,5523,5520,-1,5526,5194,5523,-1,7373,903,905,-1,7373,7480,903,-1,5194,2757,5192,-1,5526,2757,5194,-1,3073,3065,3074,-1,3073,1021,3065,-1,5451,3082,446,-1,7381,3082,5451,-1,446,5454,5451,-1,5454,446,5188,-1,7382,5201,3077,-1,7382,7370,5201,-1,2786,411,404,-1,2788,411,2786,-1,5533,7383,5510,-1,5533,5503,7383,-1,3553,7367,5534,-1,7367,3553,3552,-1,2829,2748,2827,-1,2748,2829,2747,-1,7384,5484,3456,-1,2794,5484,7384,-1,971,3451,2796,-1,3451,971,7366,-1,3554,981,983,-1,2766,981,3554,-1,1003,2749,2751,-1,2749,1003,1002,-1,3102,3954,3103,-1,5469,3954,3102,-1,5480,1034,3542,-1,7485,1034,5480,-1,5456,2830,3541,-1,5456,5455,2830,-1,3539,3445,5175,-1,948,3445,3539,-1,7389,3540,5538,-1,3540,7389,5182,-1,5185,3446,7862,-1,5185,3447,3446,-1,2819,7365,7861,-1,7365,2819,5539,-1,946,2822,947,-1,2822,946,1041,-1,5174,7364,1046,-1,7364,5174,5522,-1,4033,3126,3125,-1,4033,3128,3126,-1,5702,2733,2732,-1,7883,2733,5702,-1,5596,5545,7363,-1,5596,5543,5545,-1,2731,5548,6890,-1,2731,5541,5548,-1,3739,5545,5544,-1,2295,5545,3739,-1,5557,5604,7360,-1,5557,7204,5604,-1,7362,5556,5553,-1,7362,7351,5556,-1,7884,6130,6136,-1,7884,5555,6130,-1,5566,5563,5561,-1,5566,5608,5563,-1,3936,7362,5570,-1,3936,3937,7362,-1,6833,5566,5568,-1,6833,7361,5566,-1,6835,3936,5569,-1,6835,3934,3936,-1,1649,6136,1650,-1,1649,7884,6136,-1,2642,5578,5580,-1,2642,5576,5578,-1,7264,6048,5586,-1,7264,6042,6048,-1,5577,5585,7355,-1,5577,5583,5585,-1,5573,5588,5574,-1,5573,5581,5588,-1,5585,5591,5598,-1,5585,5584,5591,-1,5543,5590,5546,-1,5543,5591,5590,-1,5597,5587,5595,-1,5542,5587,5597,-1,7352,5600,5599,-1,7352,7213,5600,-1,5602,7204,7203,-1,7204,5602,5604,-1,5601,5552,5599,-1,5552,5601,5551,-1,5603,7360,5604,-1,7360,5603,5608,-1,1928,7885,5615,-1,1927,7885,1928,-1,1919,5614,1920,-1,5614,1919,5613,-1,1090,5617,5615,-1,1090,5807,5617,-1,3742,5611,1924,-1,5611,3742,5618,-1,5623,7886,5621,-1,7886,5623,7887,-1,7888,5625,7889,-1,7888,5624,5625,-1,5627,1113,7890,-1,1114,1113,5627,-1,5610,1115,7342,-1,2704,1115,5610,-1,5635,5646,5633,-1,5635,7310,5646,-1,5637,2728,7341,-1,3567,2728,5637,-1,5639,7339,5638,-1,5639,7887,7339,-1,5642,7891,5640,-1,5642,7889,7891,-1,5645,7347,6869,-1,5644,7347,5645,-1,5648,7890,7048,-1,5627,7890,5648,-1,7046,5634,5650,-1,7348,5634,7046,-1,7891,5651,6862,-1,7891,5636,5651,-1,5654,6863,7308,-1,5654,5653,6863,-1,5616,7346,7050,-1,5617,7346,5616,-1,7345,7047,7892,-1,7345,5641,7047,-1,7893,5659,5661,-1,7893,7336,5659,-1,1057,1069,1055,-1,1069,1057,1121,-1,1076,7894,3929,-1,7894,1076,5977,-1,5668,5979,7895,-1,5668,5670,5979,-1,5676,5674,5673,-1,5676,2717,5674,-1,1065,1061,1063,-1,1064,1061,1065,-1,1068,1055,1069,-1,1068,1077,1055,-1,1061,1058,1070,-1,1061,1064,1058,-1,1123,5664,2672,-1,1123,5681,5664,-1,5673,1067,7896,-1,2718,1067,5673,-1,7897,5950,5687,-1,5949,5950,7897,-1,5676,7896,5675,-1,5676,5673,7896,-1,3569,5679,5657,-1,5677,5679,3569,-1,5662,7897,5687,-1,7897,5662,5659,-1,1077,6883,2720,-1,1077,3929,6883,-1,7041,2724,7898,-1,5671,2724,7041,-1,2721,3808,5691,-1,2721,1081,3808,-1,5694,7893,5661,-1,7893,5694,6884,-1,7894,5697,6885,-1,7894,5695,5697,-1,2257,7895,5701,-1,2257,2256,7895,-1,2712,7332,2713,-1,2712,7899,7332,-1,7900,5702,7333,-1,7900,7883,5702,-1,5712,5723,7251,-1,5712,5709,5723,-1,1053,7250,1054,-1,7250,1053,5725,-1,5719,1083,1082,-1,5719,5718,1083,-1,6078,5723,5720,-1,6078,7251,5723,-1,5709,5721,5723,-1,5709,6888,5721,-1,1935,5725,1053,-1,5725,1935,1934,-1,2252,7331,1937,-1,5715,7331,2252,-1,1939,5718,3807,-1,1083,5718,1939,-1,5729,5774,5727,-1,5729,7307,5774,-1,5732,2699,5735,-1,5732,2697,2699,-1,1089,5736,3925,-1,1089,1108,5736,-1,5611,2704,5610,-1,2704,5611,2705,-1,2688,5741,2689,-1,3923,5741,2688,-1,5745,7901,5769,-1,5744,7901,5745,-1,5749,7902,5747,-1,5749,7903,7902,-1,1097,7904,7322,-1,1099,7904,1097,-1,1100,3579,3578,-1,1100,5752,3579,-1,2695,5755,5612,-1,5755,2695,2694,-1,3925,5757,5797,-1,3925,5736,5757,-1,7312,5758,5761,-1,7312,5759,5758,-1,5758,2706,1093,-1,2706,5758,5760,-1,5747,5785,5762,-1,5747,7902,5785,-1,2703,5765,1095,-1,2703,5789,5765,-1,5767,5752,5768,-1,5767,3579,5752,-1,5771,2689,5742,-1,2689,5771,3581,-1,5730,5773,5778,-1,5730,5727,5773,-1,1104,2686,1105,-1,1104,2709,2686,-1,1106,2699,1107,-1,5735,2699,1106,-1,7321,5780,5799,-1,7321,5778,5780,-1,3922,5781,5801,-1,3922,1105,5781,-1,5757,7325,5756,-1,2692,7325,5757,-1,7319,5785,5782,-1,5762,5785,7319,-1,7316,5789,5786,-1,5765,5789,7316,-1,5754,5768,5752,-1,5768,5754,7315,-1,5791,1111,1110,-1,5791,2678,1111,-1,7309,5784,5793,-1,5782,5784,7309,-1,2676,5788,1112,-1,5786,5788,2676,-1,7905,1108,1089,-1,3921,1108,7905,-1,5621,5776,5798,-1,5776,5621,7886,-1,5779,5624,7888,-1,5779,5800,5624,-1,5803,3921,7905,-1,5802,3921,5803,-1,5792,5635,5632,-1,5792,7318,5635,-1,5805,7317,7350,-1,5795,7317,5805,-1,7906,1089,1088,-1,7905,1089,7906,-1,7906,5652,5808,-1,7906,7340,5652,-1,5809,7907,5812,-1,7907,5809,7908,-1,5815,7285,5813,-1,7285,5815,7909,-1,5836,5819,5891,-1,5819,5836,5817,-1,5831,1158,1161,-1,1158,5831,5821,-1,1129,3588,5873,-1,1129,5823,3588,-1,5828,5839,5925,-1,5828,5825,5839,-1,7338,5669,5698,-1,5669,7338,5667,-1,5674,1119,1118,-1,5674,7274,1119,-1,5835,5822,7286,-1,5834,5822,5835,-1,1126,5818,7910,-1,1125,5818,1126,-1,5839,7282,7304,-1,5839,5838,7282,-1,5809,7294,7908,-1,5809,5841,7294,-1,5815,5932,7909,-1,5815,5843,5932,-1,7274,3584,1119,-1,3584,7274,7275,-1,5848,2663,2661,-1,2663,5848,5899,-1,5853,7911,5867,-1,5852,7911,5853,-1,7301,1126,5837,-1,7301,3920,1126,-1,7912,5863,7913,-1,7912,3600,5863,-1,5859,1135,5857,-1,5859,3918,1135,-1,1141,1142,1144,-1,1140,1142,1141,-1,5875,5863,5860,-1,7913,5863,5875,-1,5879,5867,5864,-1,5853,5867,5879,-1,5837,7910,3586,-1,5837,1126,7910,-1,1144,5868,1148,-1,1144,1132,5868,-1,5857,1149,7292,-1,5857,1135,1149,-1,3592,5869,2671,-1,3592,5883,5869,-1,3586,7302,3587,-1,3586,7910,7302,-1,5876,5860,5897,-1,5875,5860,5876,-1,5880,5864,5890,-1,5879,5864,5880,-1,7907,5884,5883,-1,7907,7305,5884,-1,1148,5885,3916,-1,1148,5868,5885,-1,7914,5890,5887,-1,5880,5890,7914,-1,3587,5833,7300,-1,3587,7302,5833,-1,7915,5897,5894,-1,5876,5897,7915,-1,5886,1152,7916,-1,5886,2664,1152,-1,7305,5912,5884,-1,7305,5816,5912,-1,5902,3916,5885,-1,3916,5902,5915,-1,7293,7916,7287,-1,7293,5886,7916,-1,5921,5887,5905,-1,7914,5887,5921,-1,7300,5835,5840,-1,7300,5833,5835,-1,5917,5894,5903,-1,7915,5894,5917,-1,7916,3915,5931,-1,7916,1152,3915,-1,1156,5816,5813,-1,5912,5816,1156,-1,5933,5919,5916,-1,5907,5919,5933,-1,5935,5923,5920,-1,5904,5923,5935,-1,5906,5926,5938,-1,5906,5924,5926,-1,3597,2662,5914,-1,2662,3597,2658,-1,5909,5930,5946,-1,5909,5929,5930,-1,5947,1155,3914,-1,1154,1155,5947,-1,5838,7283,7282,-1,5838,7286,7283,-1,5952,5937,5934,-1,5918,5937,5952,-1,5956,5940,5939,-1,5922,5940,5956,-1,7281,5847,7280,-1,5932,5847,7281,-1,5946,5966,5944,-1,5946,5930,5966,-1,5948,3914,7917,-1,5947,3914,5948,-1,5967,5941,7284,-1,5941,5967,5950,-1,1160,5954,5951,-1,1159,5954,1160,-1,5678,5958,5955,-1,5936,5958,5678,-1,5961,5972,7917,-1,5961,5960,5972,-1,2660,1164,5975,-1,2660,2659,1164,-1,5944,5964,5970,-1,5944,5966,5964,-1,5950,1167,5687,-1,5950,5967,1167,-1,1162,5951,5683,-1,1160,5951,1162,-1,5969,5965,5978,-1,5964,5965,5969,-1,5960,5973,5972,-1,5960,1074,5973,-1,1166,5975,1164,-1,5975,1166,1117,-1,5855,7296,5854,-1,7297,1128,1127,-1,7911,1128,7297,-1,7911,5824,1128,-1,5852,5824,7911,-1,5852,7301,5824,-1,3598,7301,5852,-1,3598,3920,7301,-1,3600,3920,3598,-1,5855,7912,7296,-1,1124,7912,5855,-1,1124,3600,7912,-1,3600,1124,3920,-1,7338,1165,7272,-1,1165,7338,5976,-1,5979,7276,7335,-1,5978,7276,5979,-1,5989,7918,5988,-1,7918,5989,7919,-1,7257,6061,7258,-1,7920,6061,7257,-1,5575,5582,5573,-1,5582,5575,6030,-1,6011,1170,6009,-1,1170,6011,3912,-1,3602,7921,1184,-1,7271,7921,3602,-1,5993,6039,1190,-1,5993,7922,6039,-1,5995,7919,5989,-1,5997,7919,5995,-1,6015,7247,5985,-1,7248,7247,6015,-1,6003,6035,6001,-1,6003,7244,6035,-1,6005,7249,6033,-1,6007,7249,6005,-1,1172,6015,3911,-1,1172,7248,6015,-1,7899,7923,6062,-1,7899,2712,7923,-1,6014,6031,6045,-1,6014,6013,6031,-1,6016,7883,7900,-1,6016,6018,7883,-1,7924,6023,6020,-1,2637,6023,7924,-1,6025,7924,2652,-1,6025,6024,7924,-1,6027,5706,3938,-1,6027,6026,5706,-1,6031,5984,6029,-1,5984,6031,6013,-1,6034,1174,2644,-1,6033,1174,6034,-1,1173,6014,5983,-1,1173,3911,6014,-1,6001,6037,7925,-1,6001,6035,6037,-1,2639,1188,1187,-1,1185,1188,2639,-1,3910,5999,1189,-1,5999,3910,7262,-1,7925,7356,5579,-1,7925,6037,7356,-1,6043,6034,7261,-1,6032,6034,6043,-1,5579,7266,7925,-1,7266,5579,5576,-1,3906,1186,6047,-1,1187,1186,3906,-1,2642,5582,2643,-1,2642,5580,5582,-1,1193,6052,2645,-1,1193,1205,6052,-1,1197,7256,3908,-1,1197,7263,7256,-1,1201,1204,1203,-1,1200,1204,1201,-1,6023,1168,3912,-1,1168,6023,2637,-1,7354,6054,6051,-1,6049,6054,7354,-1,5987,6050,3601,-1,6050,5987,6065,-1,1198,6067,3606,-1,1198,6056,6067,-1,6074,3907,6057,-1,7259,3907,6074,-1,5593,6051,6059,-1,7354,6051,5593,-1,7258,7252,1206,-1,7258,7923,7252,-1,6080,6064,6066,-1,7255,6064,6080,-1,6012,6069,6068,-1,6009,6069,6012,-1,6055,6073,6079,-1,6055,6071,6073,-1,5716,6060,5714,-1,6059,6060,5716,-1,6062,7900,7899,-1,6062,6016,7900,-1,5712,6081,5710,-1,7253,6081,5712,-1,6063,1051,1054,-1,6063,7254,1051,-1,5719,6084,5717,-1,6070,6084,5719,-1,6086,6714,6713,-1,6086,7241,6714,-1,7237,6091,6097,-1,7237,6089,6091,-1,7926,6087,6094,-1,7926,6085,6087,-1,7241,6099,6714,-1,7241,6097,6099,-1,6104,3904,1210,-1,3904,6104,6120,-1,6106,6103,1211,-1,6106,6121,6103,-1,3904,6309,1208,-1,3904,6307,6309,-1,1253,7238,1254,-1,1253,7927,7238,-1,6111,7186,6109,-1,6111,7185,7186,-1,6110,7236,6113,-1,6110,6109,7236,-1,6290,7926,7177,-1,6290,7928,7926,-1,6113,7237,6117,-1,6113,7236,7237,-1,6436,7929,7232,-1,6436,7152,7929,-1,1277,1215,1214,-1,1215,1277,3886,-1,7239,3903,6121,-1,7239,7233,3903,-1,6224,6124,7229,-1,6224,6122,6124,-1,6220,6126,7228,-1,6220,6129,6126,-1,3608,6223,5559,-1,6222,6223,3608,-1,6124,6133,7930,-1,6124,6123,6133,-1,6126,6135,7931,-1,6126,6128,6135,-1,6725,6137,7930,-1,6137,6725,1651,-1,6140,7932,6138,-1,6140,7931,7932,-1,6143,7179,6155,-1,6142,7179,6143,-1,6147,7178,6158,-1,6146,7178,6147,-1,6151,7176,7933,-1,6150,7176,6151,-1,1700,7933,1697,-1,6151,7933,1700,-1,6156,7225,6729,-1,6155,7225,6156,-1,6159,7224,7095,-1,6158,7224,6159,-1,7934,1217,1216,-1,7934,6160,1217,-1,6183,6166,6163,-1,7935,6166,6183,-1,7215,6168,1221,-1,7936,6168,7215,-1,7937,6171,7938,-1,7937,6169,6171,-1,3902,6176,6173,-1,7939,6176,3902,-1,7938,6191,6190,-1,7938,6171,6191,-1,3897,6175,7216,-1,6173,6175,3897,-1,1217,6180,3900,-1,1217,6161,6180,-1,6183,2627,7221,-1,6183,6182,2627,-1,3898,7215,1222,-1,6178,7215,3898,-1,3896,6184,6187,-1,6182,6184,3896,-1,1218,1234,1226,-1,1218,3900,1234,-1,1229,7216,6201,-1,3897,7216,1229,-1,6191,6195,6189,-1,6191,6177,6195,-1,6193,1224,6206,-1,6195,1224,6193,-1,6196,1231,1233,-1,3609,1231,6196,-1,6186,6198,3895,-1,6186,1227,6198,-1,1238,1230,6212,-1,2625,1230,1238,-1,6202,6192,6204,-1,6199,6192,6202,-1,6205,6194,7353,-1,6204,6194,6205,-1,1233,7208,6196,-1,1233,1243,7208,-1,3895,7207,1241,-1,3895,6198,7207,-1,1235,7206,6207,-1,1235,1239,7206,-1,6221,7211,7205,-1,7206,7211,6221,-1,6203,6215,6213,-1,6203,7203,6215,-1,6217,1244,1242,-1,1244,6217,1245,-1,6219,7212,6208,-1,7212,6219,7940,-1,6219,6220,7231,-1,6219,6218,6220,-1,7230,6214,6222,-1,7210,6214,7230,-1,1245,6131,5554,-1,1245,6217,6131,-1,6174,7937,7218,-1,6176,7937,6174,-1,6176,6169,7937,-1,7939,6169,6176,-1,7939,6172,6169,-1,7941,6172,7939,-1,7941,7219,6172,-1,7223,7219,7941,-1,7223,7936,7219,-1,6162,7936,7223,-1,6162,6168,7936,-1,6160,6168,6162,-1,6160,6167,6168,-1,6160,7220,6167,-1,7934,7220,6160,-1,7934,7935,7220,-1,7222,7935,7934,-1,6164,7935,7222,-1,6164,6166,7935,-1,6249,6232,6229,-1,6302,6232,6249,-1,6251,6233,6235,-1,6297,6233,6251,-1,6301,6237,6257,-1,6301,6240,6237,-1,6259,6244,6241,-1,6305,6244,6259,-1,6263,6243,1246,-1,6241,6243,6263,-1,6226,6248,7197,-1,6226,6246,6248,-1,7196,6253,6250,-1,6231,6253,7196,-1,6234,6256,7194,-1,6234,6254,6256,-1,7942,6261,6258,-1,6239,6261,7942,-1,7192,6260,6262,-1,6258,6260,7192,-1,1247,6272,3893,-1,1247,7201,6272,-1,6265,7200,6276,-1,6247,7200,6265,-1,3892,7199,7189,-1,6252,7199,3892,-1,6267,7198,6271,-1,6255,7198,6267,-1,6269,7943,7187,-1,6271,7943,6269,-1,6264,7927,1253,-1,6264,1248,7927,-1,6273,7185,6111,-1,6273,6266,7185,-1,1255,1249,1251,-1,6275,1249,1255,-1,7195,7193,7188,-1,7195,6268,7193,-1,7193,6280,6288,-1,7193,6270,6280,-1,6291,1252,3891,-1,7191,1252,6291,-1,6282,1255,1257,-1,6274,1255,6282,-1,6285,6278,6294,-1,2620,6278,6285,-1,6287,6279,6296,-1,6280,6279,6287,-1,3891,7928,6290,-1,3891,1254,7928,-1,6144,7184,6142,-1,6292,7184,6144,-1,6148,7183,6146,-1,6294,7183,6148,-1,6152,7180,6150,-1,6296,7180,6152,-1,6749,6362,7944,-1,6749,6361,6362,-1,1759,3607,2632,-1,7147,3607,1759,-1,6315,6313,7150,-1,6313,6315,6311,-1,6312,6751,6314,-1,6312,6311,6751,-1,7945,6320,7946,-1,6320,7945,6318,-1,7171,6323,7947,-1,6323,7171,6321,-1,7948,6328,6325,-1,7948,6500,6328,-1,6319,7949,6330,-1,7949,6319,6318,-1,7083,6335,6332,-1,6512,6335,7083,-1,6754,6325,6336,-1,7948,6325,6754,-1,7945,7950,7951,-1,7950,7945,7173,-1,6561,6345,7944,-1,6561,6343,6345,-1,6557,6348,6364,-1,6557,6346,6348,-1,6352,6341,6338,-1,6352,6351,6341,-1,7165,6354,6356,-1,6585,6354,7165,-1,7079,6353,6359,-1,6351,6353,7079,-1,6363,6356,6355,-1,6356,6363,2365,-1,6365,7168,6364,-1,7168,6365,6756,-1,6339,1772,7167,-1,6339,1773,1772,-1,6369,2613,2612,-1,2613,6369,7952,-1,6373,2608,7953,-1,6370,2608,6373,-1,7954,6376,7160,-1,6376,7954,6374,-1,3890,2616,1258,-1,3890,7955,2616,-1,6372,7956,6370,-1,6372,6380,7956,-1,7957,6375,2604,-1,6376,6375,7957,-1,1263,1258,2615,-1,1258,1263,1259,-1,6389,2609,7956,-1,2609,6389,6383,-1,2597,6385,7957,-1,6385,2597,6384,-1,2599,6395,2603,-1,2599,2596,6395,-1,2607,6390,7958,-1,2607,6383,6390,-1,6391,6386,6384,-1,6386,6391,7959,-1,6393,6387,7960,-1,3614,6387,6393,-1,7156,7157,7961,-1,7960,7157,7156,-1,1275,3889,7958,-1,3889,1275,1270,-1,7155,6399,7959,-1,6399,7155,6397,-1,6401,1274,1273,-1,6401,6400,1274,-1,6402,7962,6400,-1,6402,2594,7962,-1,7154,6406,6404,-1,7961,6406,7154,-1,1270,6118,1271,-1,1270,3887,6118,-1,6398,6419,6408,-1,6398,6397,6419,-1,3888,6415,6411,-1,3888,1274,6415,-1,6415,6426,6413,-1,6415,7962,6426,-1,1214,3887,1277,-1,6118,3887,1214,-1,6421,6408,6419,-1,6408,6421,6429,-1,6421,6424,6431,-1,6421,6418,6424,-1,6434,6426,6425,-1,6413,6426,6434,-1,6430,1278,6428,-1,1278,6430,1279,-1,6427,6310,7175,-1,6427,6431,6310,-1,6432,7153,6434,-1,7153,6432,6438,-1,7148,6437,6435,-1,2592,6437,7148,-1,7150,2619,6315,-1,7150,6438,2619,-1,6440,7148,7147,-1,7149,7148,6440,-1,3885,6444,1281,-1,3885,6442,6444,-1,6446,7144,1292,-1,6448,7144,6446,-1,7143,1285,1284,-1,7143,7131,1285,-1,7963,6455,6452,-1,7963,1288,6455,-1,3882,1288,1287,-1,3882,6455,1288,-1,7964,6460,6510,-1,6460,7964,6458,-1,6462,6505,3880,-1,6462,7139,6505,-1,6465,7964,6464,-1,6465,7965,7964,-1,7132,6467,1297,-1,7132,7130,6467,-1,6504,6471,6468,-1,6504,6503,6471,-1,7136,7963,6497,-1,7136,6507,7963,-1,6477,7951,7950,-1,7951,6477,6476,-1,6489,6482,6511,-1,6482,6489,6480,-1,7966,6330,7949,-1,6330,7966,6483,-1,7967,6487,7128,-1,6487,7967,6485,-1,7967,6491,6478,-1,6491,7967,6490,-1,6472,7966,6476,-1,6472,6481,7966,-1,7135,6495,6492,-1,6501,6495,7135,-1,7138,6494,6470,-1,7138,6492,6494,-1,6512,6499,6335,-1,6512,6486,6499,-1,3623,6328,6501,-1,3623,6326,6328,-1,6499,1289,6498,-1,1290,1289,6499,-1,7141,6449,1286,-1,7146,6449,7141,-1,1293,2583,1294,-1,1293,1282,2583,-1,6443,6502,7965,-1,6443,2590,6502,-1,7140,1296,3881,-1,2587,1296,7140,-1,6503,6467,6471,-1,6466,6467,6503,-1,6507,1288,7963,-1,3884,1288,6507,-1,6457,6479,6474,-1,6457,6456,6479,-1,3879,6460,3878,-1,6460,3879,6509,-1,1311,6521,3631,-1,1311,3624,6521,-1,6518,3626,2562,-1,3626,6518,2579,-1,6542,6522,1307,-1,6542,6523,6522,-1,6591,2575,6526,-1,6591,2576,2575,-1,3627,6529,2574,-1,3627,7125,6529,-1,6530,1314,6594,-1,6531,1314,6530,-1,2570,6532,7127,-1,6532,2570,3628,-1,6533,7122,6539,-1,7122,6533,7124,-1,2561,6537,6544,-1,2561,1306,6537,-1,6527,1298,6541,-1,1298,6527,6525,-1,6543,6515,7124,-1,6513,6515,6543,-1,7968,6614,7969,-1,6614,7968,6576,-1,6548,7968,6546,-1,6576,7968,6548,-1,6550,6559,6555,-1,6559,6550,6567,-1,6558,6349,6346,-1,6558,7970,6349,-1,6560,6344,6343,-1,6560,7971,6344,-1,6563,7120,6562,-1,6563,7971,7120,-1,7972,7970,7118,-1,7973,7970,7972,-1,7114,6564,6562,-1,6564,7114,6570,-1,7972,6574,6573,-1,7972,7974,6574,-1,7975,6578,6577,-1,7975,7976,6578,-1,7116,6581,6579,-1,7116,7976,6581,-1,6583,7166,7973,-1,6340,7166,6583,-1,6350,6586,6584,-1,6350,7977,6586,-1,7975,6588,6587,-1,7975,7977,6588,-1,6598,6540,6589,-1,6598,6538,6540,-1,6603,6591,7125,-1,6603,6590,6591,-1,6594,3875,6593,-1,3875,6594,1314,-1,7127,6535,6534,-1,7127,6532,6535,-1,6609,6597,6599,-1,6596,6597,6609,-1,2559,6611,3632,-1,2559,6602,6611,-1,6605,6590,6603,-1,6590,6605,6617,-1,6593,6607,6622,-1,6593,3875,6607,-1,6607,3874,6623,-1,6607,1316,3874,-1,6599,6580,6609,-1,6599,6579,6580,-1,6611,7969,6614,-1,6611,6602,7969,-1,6624,6617,6605,-1,6617,6624,6615,-1,6622,6623,6620,-1,6622,6607,6623,-1,6571,3874,7119,-1,6623,3874,6571,-1,6552,7115,6618,-1,7115,6552,6549,-1,3873,5163,1319,-1,5163,3873,5164,-1,3675,6629,1595,-1,3675,3674,6629,-1,6671,2400,2358,-1,6671,6630,2400,-1,6633,6899,6901,-1,6633,6632,6899,-1,6636,1855,7067,-1,6636,3817,1855,-1,1328,6637,6635,-1,1330,6637,1328,-1,2536,2133,2537,-1,2536,2134,2133,-1,1335,1332,1336,-1,1335,2491,1332,-1,1340,1338,2552,-1,1340,1342,1338,-1,2150,2548,6980,-1,2548,2150,3776,-1,2547,3849,1362,-1,2547,2546,3849,-1,3868,3643,3642,-1,3868,3644,3643,-1,2499,3638,2500,-1,2499,2551,3638,-1,2212,2217,3752,-1,2218,2217,2212,-1,6638,1338,2550,-1,1338,6638,1339,-1,1384,2133,2132,-1,1384,1386,2133,-1,3649,1345,3775,-1,1345,3649,6638,-1,3633,2126,3634,-1,3633,3757,2126,-1,1777,1391,3650,-1,1391,1777,1620,-1,2523,1710,1638,-1,2523,2522,1710,-1,6644,3856,6947,-1,6641,3856,6644,-1,1420,6942,3861,-1,1420,6950,6942,-1,1427,2029,1428,-1,2029,1427,7978,-1,3801,1434,1433,-1,3801,1432,1434,-1,1440,1442,1954,-1,1440,2495,1442,-1,1447,2127,1448,-1,1447,2100,2127,-1,1444,2093,2153,-1,1451,2093,1444,-1,2013,3789,2012,-1,3857,3789,2013,-1,3789,6643,2097,-1,6641,6643,3789,-1,7111,7979,7024,-1,7979,7111,7980,-1,6649,2135,7981,-1,2006,2135,6649,-1,1467,1471,1468,-1,1471,1467,1970,-1,2177,2489,2490,-1,2177,2050,2489,-1,1491,6650,2056,-1,1490,6650,1491,-1,1499,2168,6972,-1,1479,2168,1499,-1,6652,3854,1505,-1,6652,3855,3854,-1,6640,6988,6987,-1,6640,3771,6988,-1,3791,3784,3783,-1,3791,7009,3784,-1,6657,7982,6655,-1,7982,6657,7016,-1,6661,6916,6659,-1,6916,6661,6908,-1,3767,6663,1407,-1,3767,6664,6663,-1,6977,6667,7017,-1,6667,6977,6665,-1,2030,2159,3669,-1,2159,2030,2160,-1,1516,6669,3670,-1,6669,1516,6662,-1,2031,3669,3668,-1,2030,3669,2031,-1,6909,3727,7105,-1,6909,6670,3727,-1,7038,1521,2474,-1,1521,7038,7039,-1,2201,2004,2111,-1,2005,2004,2201,-1,7096,6671,7113,-1,6671,7096,6672,-1,1537,2471,1702,-1,1537,1541,2471,-1,3673,6628,3674,-1,6716,6628,3673,-1,1549,1321,1556,-1,1321,1549,3873,-1,2468,3848,2469,-1,2468,3689,3848,-1,1547,1557,1322,-1,1556,1557,1547,-1,1558,1550,1687,-1,1558,1551,1550,-1,6676,1561,6673,-1,2466,1561,6676,-1,7983,6675,7074,-1,7983,6676,6675,-1,5221,6679,3831,-1,5221,5222,6679,-1,3679,1780,2362,-1,1780,3679,3846,-1,6682,2463,2444,-1,3729,2463,6682,-1,3729,2333,2463,-1,7070,6684,2405,-1,7070,6838,6684,-1,2459,1684,3844,-1,2459,1685,1684,-1,3696,6731,7984,-1,6731,3696,6686,-1,2455,2453,1621,-1,7088,2453,2455,-1,6690,6735,6689,-1,6735,6690,3684,-1,3843,1563,1628,-1,1563,3843,6734,-1,2528,2361,2363,-1,2528,3841,2361,-1,2440,6692,6763,-1,1788,6692,2440,-1,1631,1633,3842,-1,1630,1633,1631,-1,3712,3686,6694,-1,3712,2360,3686,-1,2374,7097,1640,-1,2374,2373,7097,-1,3681,2443,2442,-1,3681,1588,2443,-1,1645,6836,1646,-1,1645,2462,6836,-1,3839,1649,1650,-1,1649,3839,3840,-1,6778,1575,7101,-1,6778,3845,1575,-1,6718,6696,3834,-1,6718,6681,6696,-1,1667,1656,1655,-1,1685,1656,1667,-1,7985,6698,6700,-1,6698,7985,6697,-1,3836,1602,7100,-1,3836,3682,1602,-1,1666,6698,1658,-1,1666,6699,6698,-1,2430,6702,6708,-1,2430,3691,6702,-1,1669,6704,1670,-1,6704,1669,6703,-1,3844,7100,1602,-1,1684,7100,3844,-1,1674,1662,1661,-1,2425,1662,1674,-1,6715,1664,1663,-1,1664,6715,2428,-1,3688,1615,1592,-1,3688,1616,1615,-1,6098,6708,6702,-1,6098,6711,6708,-1,7240,2432,2431,-1,7240,6713,2432,-1,2424,1676,2632,-1,1674,1676,2424,-1,6715,2426,2428,-1,2426,6715,6105,-1,6724,2458,2460,-1,6724,1585,2458,-1,1323,6765,7986,-1,2401,6765,1323,-1,6717,6685,7099,-1,2418,6685,6717,-1,6721,3834,1691,-1,3834,6721,6718,-1,1688,7986,3835,-1,1688,1323,7986,-1,6688,7099,6723,-1,6717,7099,6688,-1,2416,3835,7986,-1,3693,3835,2416,-1,3838,6138,7932,-1,3838,6697,6138,-1,7985,6726,6139,-1,7985,2436,6726,-1,6705,1700,1699,-1,1700,6705,6153,-1,6707,7094,6706,-1,7094,6707,6729,-1,7984,2405,3696,-1,7070,2405,7984,-1,1691,6733,6721,-1,1691,6780,6733,-1,6735,7068,6734,-1,6735,7098,7068,-1,2419,1595,6629,-1,1595,2419,1593,-1,2373,3825,7097,-1,1757,3825,2373,-1,3703,6741,6740,-1,2388,6741,3703,-1,1755,3829,1721,-1,1755,1754,3829,-1,2383,1764,1763,-1,2383,6743,1764,-1,2454,1731,1730,-1,1731,2454,1743,-1,1708,1623,1712,-1,1733,1623,1708,-1,1767,1748,3706,-1,1767,1749,1748,-1,3708,3711,2377,-1,3708,1769,3711,-1,6748,1750,3827,-1,6747,1750,6748,-1,1717,3707,1603,-1,3707,1717,1723,-1,1723,3705,3707,-1,1723,1722,3705,-1,6741,6439,3702,-1,2618,6439,6741,-1,2387,6751,6316,-1,6751,2387,6750,-1,7987,6754,6753,-1,6754,7987,7170,-1,1727,7174,7946,-1,1727,1726,7174,-1,7947,1760,3824,-1,6323,1760,7947,-1,6755,6334,7082,-1,6334,6755,6332,-1,6753,1719,7987,-1,6742,1719,6753,-1,1721,1627,1626,-1,1721,1720,1627,-1,1774,7080,7078,-1,1773,7080,1774,-1,3821,1772,1737,-1,3821,1771,1772,-1,6360,6758,6359,-1,3822,6758,6360,-1,1744,6759,6757,-1,7078,6759,1744,-1,7087,3828,7086,-1,7164,3828,7087,-1,1729,6745,6743,-1,1729,2379,6745,-1,7096,3698,6672,-1,7096,6764,3698,-1,1622,2531,1392,-1,1775,2531,1622,-1,5308,3830,1705,-1,5309,3830,5308,-1,6678,1780,3846,-1,6678,1704,1780,-1,1571,1791,1572,-1,1571,3676,1791,-1,1687,1794,1558,-1,1687,3697,1794,-1,6761,3873,1549,-1,6761,5164,3873,-1,6767,7076,6766,-1,6767,1795,7076,-1,6766,7104,6674,-1,6766,7075,7104,-1,1582,7104,1583,-1,6677,7104,1582,-1,6768,2407,3804,-1,6768,7102,2407,-1,1470,2355,3714,-1,2355,1470,1802,-1,1812,1810,2333,-1,1814,1810,1812,-1,7034,1820,1959,-1,1820,7034,2228,-1,6898,3719,6777,-1,1816,3719,6898,-1,6772,6892,6770,-1,6772,6775,6892,-1,6771,6774,6772,-1,6774,6771,6837,-1,3719,3729,3845,-1,3719,1812,3729,-1,7092,7073,7090,-1,7092,1819,7073,-1,6851,2249,2278,-1,6851,6782,2249,-1,1825,3806,2241,-1,1825,6782,3806,-1,7057,1957,3725,-1,6790,1957,7057,-1,1837,7988,1896,-1,7988,1837,1839,-1,1897,2338,1840,-1,2338,1897,2302,-1,1896,6841,6786,-1,1896,7988,6841,-1,1856,6637,6788,-1,6637,1856,3817,-1,6847,7058,1798,-1,6847,6846,7058,-1,6840,7057,7056,-1,6840,6839,7057,-1,2303,1848,1846,-1,2303,1849,1848,-1,7067,7989,6636,-1,7989,7067,6795,-1,6791,3718,3717,-1,6791,2347,3718,-1,1857,1807,6815,-1,1857,1808,1807,-1,7990,6794,6812,-1,7990,6792,6794,-1,6798,7991,6796,-1,6798,6849,7991,-1,1916,6802,2330,-1,1916,6875,6802,-1,7064,6870,7051,-1,7064,7043,6870,-1,6807,1868,3810,-1,1868,6807,1869,-1,2258,2281,2259,-1,2279,2281,2258,-1,6811,2242,6809,-1,6811,3815,2242,-1,6793,6631,6911,-1,6631,6793,7066,-1,2353,3734,3716,-1,2353,2326,3734,-1,6882,7063,6817,-1,7052,7063,6882,-1,7062,3735,2318,-1,7062,7061,3735,-1,1859,2328,1860,-1,2329,2328,1859,-1,1842,1938,6822,-1,1895,1938,1842,-1,3738,2301,2300,-1,2301,3738,2296,-1,7992,1846,1848,-1,1846,7992,2311,-1,2303,6832,2304,-1,1847,6832,2303,-1,6787,6840,6846,-1,6786,6840,6787,-1,1903,1899,1898,-1,1902,1899,1903,-1,3736,6890,5548,-1,6890,3736,6889,-1,7060,6833,6832,-1,7359,6833,7060,-1,6835,6829,7358,-1,6835,6834,6829,-1,7054,7071,7073,-1,7054,6776,7071,-1,7055,7033,6844,-1,7993,7033,7055,-1,6843,1820,1819,-1,1820,6843,1963,-1,7058,3724,6783,-1,3724,7058,7056,-1,2556,6684,6837,-1,6684,2556,6683,-1,7031,2347,2247,-1,2347,7031,3718,-1,3818,2315,1873,-1,3818,2320,2315,-1,2350,7064,2351,-1,2350,6797,7064,-1,7062,1908,1910,-1,2318,1908,7062,-1,6848,3746,2246,-1,6848,6819,3746,-1,3730,3731,7069,-1,3730,2330,3731,-1,2280,6782,6851,-1,6782,2280,3806,-1,1814,1811,1810,-1,1814,3811,1811,-1,7343,1926,1925,-1,2260,1926,7343,-1,6858,6879,6856,-1,7892,6879,6858,-1,6862,6881,6860,-1,5651,6881,6862,-1,6855,7994,5655,-1,6855,6854,7994,-1,5649,7045,6865,-1,5643,7045,5649,-1,6868,5647,6876,-1,5647,6868,6867,-1,6854,6804,7994,-1,6854,6803,6804,-1,3741,2260,2259,-1,3741,1926,2260,-1,1870,6868,2327,-1,6868,1870,6866,-1,3809,6806,1930,-1,6806,3809,6865,-1,6801,6857,6856,-1,6801,6800,6857,-1,6861,7991,7044,-1,6860,7991,6861,-1,6872,7994,6804,-1,6871,7994,6872,-1,6820,5690,6818,-1,6820,5689,5690,-1,3930,7061,7898,-1,3930,3735,7061,-1,1876,1080,1874,-1,1080,1876,1081,-1,2323,5694,5693,-1,2323,1882,5694,-1,5697,1878,2316,-1,5696,1878,5697,-1,5722,6827,6825,-1,5721,6827,5722,-1,5726,2308,7040,-1,5726,2310,2308,-1,3723,2344,2340,-1,2343,2344,3723,-1,1839,2294,7988,-1,1839,2339,2294,-1,3813,2350,1875,-1,3813,6850,2350,-1,2326,2348,2284,-1,2326,2353,2348,-1,6811,6894,6893,-1,6811,6810,6894,-1,2231,7989,2232,-1,2231,2243,7989,-1,6900,1816,6898,-1,6900,2247,1816,-1,1968,6902,1967,-1,1968,3851,6902,-1,6902,2238,2237,-1,6902,7035,2238,-1,1469,1470,7037,-1,1468,1470,1469,-1,1441,7065,2236,-1,7065,1441,2230,-1,1958,7105,3727,-1,7105,1958,1955,-1,1961,1962,7032,-1,1961,1960,1962,-1,2335,1942,2334,-1,1942,2335,1523,-1,3726,6785,7993,-1,3726,3725,6785,-1,1955,7106,7105,-1,1955,2334,7106,-1,6810,6896,6894,-1,7036,6896,6810,-1,7098,6914,7068,-1,6913,6914,7098,-1,7227,6831,6912,-1,7227,5564,6831,-1,2223,6915,6781,-1,1835,6915,2223,-1,3671,6907,1532,-1,3671,6906,6907,-1,1978,3805,1952,-1,1326,3805,1978,-1,1974,6919,1975,-1,6919,1974,6917,-1,1949,2215,1950,-1,1949,3868,2215,-1,2214,3868,1949,-1,3663,6971,6920,-1,3663,1454,6971,-1,2520,3864,1411,-1,2028,3864,2520,-1,7022,6958,6957,-1,6955,6958,7022,-1,7995,2017,7996,-1,7995,3855,2017,-1,1517,6925,1515,-1,1517,7028,6925,-1,6928,3779,6926,-1,3779,6928,6924,-1,6929,6931,6927,-1,6929,6949,6931,-1,6936,6948,6934,-1,6948,6936,6932,-1,6935,2193,6937,-1,2192,2193,6935,-1,6940,3786,6938,-1,6939,3786,6940,-1,1985,3770,1993,-1,1985,7996,3770,-1,3656,2204,7980,-1,3656,2205,2204,-1,7022,7027,7997,-1,7022,6957,7027,-1,2509,6949,6929,-1,2509,2508,6949,-1,1988,3862,1989,-1,7998,3862,1988,-1,2116,2117,3755,-1,2116,2115,2117,-1,2206,3772,7981,-1,2206,2205,3772,-1,3774,2003,3756,-1,3774,6999,2003,-1,1996,2503,2121,-1,1996,1433,2503,-1,2119,7999,6648,-1,2119,2121,7999,-1,6926,2112,3662,-1,6926,3779,2112,-1,6942,1412,3864,-1,6942,2507,1412,-1,2144,2208,2145,-1,2208,2144,7978,-1,2016,7996,2017,-1,2016,3770,7996,-1,2094,3782,2018,-1,2094,6979,3782,-1,3755,7005,2116,-1,7997,7005,3755,-1,2011,3761,2015,-1,2011,2024,3761,-1,6961,7997,3755,-1,7997,6961,7022,-1,2014,6960,2118,-1,2187,6960,2014,-1,6950,6934,6948,-1,6950,1420,6934,-1,2027,2160,2030,-1,2160,2027,2026,-1,2034,2036,2035,-1,2034,2037,2036,-1,1480,6964,2490,-1,1480,2166,6964,-1,2048,3792,2064,-1,2047,3792,2048,-1,8000,3793,2082,-1,8000,6963,3793,-1,2077,6994,2078,-1,2077,3795,6994,-1,7110,2077,2079,-1,7110,2088,2077,-1,2170,2062,2164,-1,2169,2062,2170,-1,2059,2162,2066,-1,2059,3780,2162,-1,6972,3764,2171,-1,2174,3764,6972,-1,6970,6963,6968,-1,6970,6962,6963,-1,2035,2181,2183,-1,2036,2181,2035,-1,2049,6994,3795,-1,2049,2081,6994,-1,2063,6974,7020,-1,2063,6973,6974,-1,6975,2060,2066,-1,6975,7006,2060,-1,8001,1496,3664,-1,8001,1497,1496,-1,2076,7021,7008,-1,2076,2078,7021,-1,7019,6963,8000,-1,7019,6968,6963,-1,3797,3791,3790,-1,3791,3797,6986,-1,6987,7013,3665,-1,7013,6987,6930,-1,6979,1446,2156,-1,6979,6646,1446,-1,6655,8002,7000,-1,6655,7982,8002,-1,8002,6985,6981,-1,7014,6985,8002,-1,7000,6981,6980,-1,7000,8002,6981,-1,6668,2189,3869,-1,6668,6665,2189,-1,6982,6653,7015,-1,6982,3769,6653,-1,6663,7029,1407,-1,6663,7025,7029,-1,3785,2102,2101,-1,3785,3784,2102,-1,1514,2108,2477,-1,1514,2107,2108,-1,7017,2096,2095,-1,7017,3797,2096,-1,7010,2031,7011,-1,7010,2032,2031,-1,2062,6973,2063,-1,2169,6973,2062,-1,6969,3758,6990,-1,6969,2154,3758,-1,7007,7020,6974,-1,2080,7020,7007,-1,6995,6974,2069,-1,7007,6974,6995,-1,2055,3664,2053,-1,2055,8001,3664,-1,2045,7109,2046,-1,7109,2045,2484,-1,6650,8001,2055,-1,1490,8001,6650,-1,2068,2161,6996,-1,2068,6975,2161,-1,3798,2210,6943,-1,3798,7998,2210,-1,6929,3662,2509,-1,6929,6926,3662,-1,2205,3660,2110,-1,2205,3656,3660,-1,7997,7023,7005,-1,7027,7023,7997,-1,2109,2492,2194,-1,2109,1483,2492,-1,3857,2065,2511,-1,2013,2065,3857,-1,6648,2122,1459,-1,7999,2122,6648,-1,6998,2203,6946,-1,7003,2203,6998,-1,7001,3751,6656,-1,7001,3645,3751,-1,1344,2540,3866,-1,1344,1383,2540,-1,7001,6980,2548,-1,7000,6980,7001,-1,2001,2136,1998,-1,2002,2136,2001,-1,6642,6946,7026,-1,6998,6946,6642,-1,1418,7024,7979,-1,1418,1417,7024,-1,3802,6647,7003,-1,7004,6647,3802,-1,6947,3803,6644,-1,3803,6947,2200,-1,1987,7996,1985,-1,1987,7995,7996,-1,2138,7981,3772,-1,7981,2138,6649,-1,2192,1420,1419,-1,1420,2192,6934,-1,6920,6968,7019,-1,6968,6920,6971,-1,2488,6922,1481,-1,2488,2037,6922,-1,1474,2074,1479,-1,1474,2142,2074,-1,8001,1502,1497,-1,8001,1490,1502,-1,6993,2080,7007,-1,2081,2080,6993,-1,6970,6990,7008,-1,6970,6969,6990,-1,2489,2186,1472,-1,2186,2489,2050,-1,7107,6923,1513,-1,7107,6989,6923,-1,6955,1503,6958,-1,6952,1503,6955,-1,3854,6958,1503,-1,6958,3854,6956,-1,3670,1517,1516,-1,3670,1534,1517,-1,3791,7108,7009,-1,7108,3791,7014,-1,2221,6984,2219,-1,2221,6669,6984,-1,7982,7014,8002,-1,7982,7108,7014,-1,6666,6981,6985,-1,6666,2151,6981,-1,6918,7016,6657,-1,6918,6983,7016,-1,7018,1407,7029,-1,1407,7018,1408,-1,3855,6956,3854,-1,3855,7995,6956,-1,6923,2101,2107,-1,6923,3785,2101,-1,6989,3668,6976,-1,6989,7107,3668,-1,7008,6962,6970,-1,7008,7021,6962,-1,6966,8000,2180,-1,7019,8000,6966,-1,2163,6975,2068,-1,6975,2163,7006,-1,1485,2143,1486,-1,1485,2039,2143,-1,6991,3796,2043,-1,6991,3759,3796,-1,2169,3794,6973,-1,3765,3794,2169,-1,2168,2046,7109,-1,2046,2168,2167,-1,1498,2085,2173,-1,2085,1498,2486,-1,2162,3763,2084,-1,3780,3763,2162,-1,2042,2079,2043,-1,2042,7110,2079,-1,1518,2485,1509,-1,2485,1518,2184,-1,2078,6992,7021,-1,6992,2078,6994,-1,2180,2082,2175,-1,2180,8000,2082,-1,2166,2064,3792,-1,2166,2165,2064,-1,1475,2184,2051,-1,1475,2485,2184,-1,6957,6944,7027,-1,6944,6957,6959,-1,7995,6959,6956,-1,1987,6959,7995,-1,6953,6960,7010,-1,6961,6960,6953,-1,1485,2188,6997,-1,1485,1484,2188,-1,6979,2189,3782,-1,6979,2156,2189,-1,3788,1508,7012,-1,1508,3788,3787,-1,2211,7998,1988,-1,2210,7998,2211,-1,1429,2028,2519,-1,2028,1429,1428,-1,1437,7999,1438,-1,1437,2122,7999,-1,1438,2121,2503,-1,1438,7999,2121,-1,7003,1465,2203,-1,6647,1465,7003,-1,1460,2000,1458,-1,2123,2000,1460,-1,1333,3634,7002,-1,1333,3635,3634,-1,7980,3654,3656,-1,7111,3654,7980,-1,7998,2029,3862,-1,3798,2029,7998,-1,1425,2519,2518,-1,1425,1429,2519,-1,1426,2518,2517,-1,1426,1425,2518,-1,7111,2513,3654,-1,2515,2513,7111,-1,3773,7979,3774,-1,7979,3773,1418,-1,2145,1985,1993,-1,2145,2208,1985,-1,6938,1990,6940,-1,6938,3781,1990,-1,3788,6935,6937,-1,6935,3788,7012,-1,6936,6930,6932,-1,6936,7013,6930,-1,6931,7018,6927,-1,6931,6933,7018,-1,7025,6928,7029,-1,6924,6928,7025,-1,6925,6941,2113,-1,6925,7028,6941,-1,7978,2207,2208,-1,7978,1427,2207,-1,6943,2028,3798,-1,6943,3864,2028,-1,6965,2140,2139,-1,6965,1495,2140,-1,1975,6654,3853,-1,6919,6654,1975,-1,3750,6983,6918,-1,6983,3750,2219,-1,2213,2238,1973,-1,1949,2238,2213,-1,2539,1384,3752,-1,1981,1384,2539,-1,1973,7035,1974,-1,2238,7035,1973,-1,1819,7030,6843,-1,7030,1819,7092,-1,7226,6912,1659,-1,7227,6912,7226,-1,3749,7059,2224,-1,1901,7059,3749,-1,1969,2225,1608,-1,2225,1969,3749,-1,6811,7034,3815,-1,6811,6893,7034,-1,1961,2240,3747,-1,1961,2239,2240,-1,6910,6670,6909,-1,6670,6910,7032,-1,7993,3728,7033,-1,7993,6785,3728,-1,2334,1520,7106,-1,1520,2334,1942,-1,1964,7032,1962,-1,7032,1964,6670,-1,1953,6792,7990,-1,6792,1953,2232,-1,6636,2243,6635,-1,2243,6636,7989,-1,2005,3748,2241,-1,2201,3748,2005,-1,7038,6908,6661,-1,7038,2474,6908,-1,7035,3851,6660,-1,7035,6902,3851,-1,6904,6661,6658,-1,6904,7038,6661,-1,6910,3850,1968,-1,6910,6905,3850,-1,7053,2228,6895,-1,2229,2228,7053,-1,1329,7037,1330,-1,1329,1469,7037,-1,2232,6795,6792,-1,2232,7989,6795,-1,2230,7990,7065,-1,2230,1953,7990,-1,7037,3714,6788,-1,3714,7037,1470,-1,2324,1910,3720,-1,2324,7062,1910,-1,3814,1913,1875,-1,1913,3814,2345,-1,6822,1839,1842,-1,2339,1839,6822,-1,2251,2254,2253,-1,2251,1894,2254,-1,2309,5726,1934,-1,2309,2310,5726,-1,2313,1087,6852,-1,1087,2313,3926,-1,1879,5696,6886,-1,1879,1878,5696,-1,3734,6817,7063,-1,3734,2325,6817,-1,1874,5689,6820,-1,5689,1874,1080,-1,7042,7898,7061,-1,7898,7042,7041,-1,2325,5693,6816,-1,5693,2325,2323,-1,7043,6864,6870,-1,6864,7043,3744,-1,3743,6803,6854,-1,3741,6803,3743,-1,6803,3741,2259,-1,6800,1921,6857,-1,6800,1923,1921,-1,6800,3733,1923,-1,6865,6807,6806,-1,7045,6807,6865,-1,6868,6873,2327,-1,6876,6873,6868,-1,6796,6860,6881,-1,6860,6796,7991,-1,6876,5648,6874,-1,5648,6876,5647,-1,5643,6877,7045,-1,5645,6877,5643,-1,2260,7046,1932,-1,7046,2260,7343,-1,6871,5655,7994,-1,5655,6871,5653,-1,6881,2266,2265,-1,2266,6881,5651,-1,7892,6880,6879,-1,7047,6880,7892,-1,6874,7048,6878,-1,7048,6874,5648,-1,7049,7050,6853,-1,5616,7050,7049,-1,2271,7049,2272,-1,1929,7049,2271,-1,7051,2351,7064,-1,3715,2351,7051,-1,2280,6808,2234,-1,6808,2280,2279,-1,6851,2281,2280,-1,6851,6805,2281,-1,6808,2235,2234,-1,3740,2235,6808,-1,6850,6797,2350,-1,6850,6798,6797,-1,7063,3716,3734,-1,3717,3716,7063,-1,2322,2244,6891,-1,1885,2244,2322,-1,6824,2293,2292,-1,1891,2293,6824,-1,6776,6838,7071,-1,6776,6774,6838,-1,1835,7055,6915,-1,7055,1835,6784,-1,6784,7993,7055,-1,3726,7993,6784,-1,7358,2305,5567,-1,7358,6829,2305,-1,6830,7359,7060,-1,5565,7359,6830,-1,2299,5548,2297,-1,5548,2299,3736,-1,2301,1848,3737,-1,7992,1848,2301,-1,7060,1847,1899,-1,6832,1847,7060,-1,6834,2462,1852,-1,6836,2462,6834,-1,2328,2310,2291,-1,2328,2308,2310,-1,6889,1854,1811,-1,1854,6889,3736,-1,2296,7992,2301,-1,7992,2296,2255,-1,2255,2311,7992,-1,2311,2255,2254,-1,2313,2314,2312,-1,2314,2313,6852,-1,2314,6891,2244,-1,6891,2314,6826,-1,1888,7042,2324,-1,2317,7042,1888,-1,7052,2321,2320,-1,7052,6882,2321,-1,1807,3718,7031,-1,3718,1807,1806,-1,6794,6911,7036,-1,6911,6794,6793,-1,1931,3740,6808,-1,3740,1931,1930,-1,7051,6872,2276,-1,7051,6870,6872,-1,6800,2331,3733,-1,6800,2332,2331,-1,6875,1915,6873,-1,1916,1915,6875,-1,7044,6849,2286,-1,6849,7044,7991,-1,2259,6805,6803,-1,2281,6805,2259,-1,7065,6812,6809,-1,7065,7990,6812,-1,1855,6815,6813,-1,1857,6815,1855,-1,1806,3716,3718,-1,2353,3716,1806,-1,2349,1809,2245,-1,1907,1809,2349,-1,1817,2346,1815,-1,2346,1817,2290,-1,7069,2331,1803,-1,7069,3731,2331,-1,6914,1798,1797,-1,6847,1798,6914,-1,6846,7056,7058,-1,6846,6840,7056,-1,2224,6845,6913,-1,2224,7059,6845,-1,3714,3819,2352,-1,3714,3713,3819,-1,7988,2337,6841,-1,7988,2294,2337,-1,2302,3812,1898,-1,2302,1896,3812,-1,6839,6790,7057,-1,6789,6790,6839,-1,1958,6785,1956,-1,1958,3728,6785,-1,2336,2340,3722,-1,3723,2340,2336,-1,2342,3723,2336,-1,3721,3723,2342,-1,7072,7073,7071,-1,7090,7073,7072,-1,7092,6732,7030,-1,7092,1594,6732,-1,2554,6837,6771,-1,6837,2554,2556,-1,6775,6895,6892,-1,6775,7053,6895,-1,6899,6777,2555,-1,6898,6777,6899,-1,7034,6895,2228,-1,7034,6893,6895,-1,2247,1817,1816,-1,2247,1858,1817,-1,7102,1564,2407,-1,7102,7074,1564,-1,1583,7075,1836,-1,7104,7075,1583,-1,7075,7076,6769,-1,6766,7076,7075,-1,7076,1796,7077,-1,1795,1796,7076,-1,5313,1558,1794,-1,5313,1559,1558,-1,6627,2356,1539,-1,6627,2357,2356,-1,6681,1569,6696,-1,6681,6680,1569,-1,1572,2362,3680,-1,3679,2362,1572,-1,1570,6680,1789,-1,1570,1569,6680,-1,1632,2528,3842,-1,1632,2526,2528,-1,5163,1545,1319,-1,1545,5163,1546,-1,2383,2451,1730,-1,2383,3704,2451,-1,6363,3710,2365,-1,6363,2368,3710,-1,1740,7164,6756,-1,1740,3828,7164,-1,3822,6746,6758,-1,3822,1767,6746,-1,6359,6759,7079,-1,6758,6759,6359,-1,2378,7078,1744,-1,7078,2378,1774,-1,3710,1749,1768,-1,3710,1747,1749,-1,7081,1764,6744,-1,1764,7081,3824,-1,3829,7987,1719,-1,3829,7082,7987,-1,2372,6332,6755,-1,6332,2372,7083,-1,7084,3824,7081,-1,7947,3824,7084,-1,7085,1726,1725,-1,7174,1726,7085,-1,7082,7170,7987,-1,7170,7082,6334,-1,6316,2388,2387,-1,6316,3611,2388,-1,3702,1758,1757,-1,6439,1758,3702,-1,1730,6743,2383,-1,1730,1729,6743,-1,6748,1745,7086,-1,1745,6748,3827,-1,1731,6757,2381,-1,1731,1744,6757,-1,1603,1748,2375,-1,1603,3707,1748,-1,1637,3650,1391,-1,3650,1637,1638,-1,3704,2371,1756,-1,3704,1762,2371,-1,1765,7946,6320,-1,1765,1727,7946,-1,6750,2389,1715,-1,6750,2387,2389,-1,6752,1715,3701,-1,6752,6750,1715,-1,1625,2389,3703,-1,1625,1627,2389,-1,3700,2392,2396,-1,3700,1718,2392,-1,3872,3698,2402,-1,6672,3698,3872,-1,1562,8003,3677,-1,2466,8003,1562,-1,7984,7072,7070,-1,7984,7093,7072,-1,6780,1690,1581,-1,1691,1690,6780,-1,6737,2406,6736,-1,2406,6737,2404,-1,1692,3675,6738,-1,3675,1692,3673,-1,2434,1697,6093,-1,2434,1698,1697,-1,7095,6705,6703,-1,6153,6705,7095,-1,3837,6159,1669,-1,6159,3837,6157,-1,6697,6139,6138,-1,6697,7985,6139,-1,7932,1659,3838,-1,7226,1659,7932,-1,1670,6699,1666,-1,1670,6704,6699,-1,6765,3833,1694,-1,6765,6764,3833,-1,1695,6717,6688,-1,1695,3832,6717,-1,1593,6720,6719,-1,2420,6720,1593,-1,3843,2525,6689,-1,1406,2525,3843,-1,7986,1694,2416,-1,6765,1694,7986,-1,3825,2632,1676,-1,3825,1759,2632,-1,1212,1678,2427,-1,1212,1209,1678,-1,6095,2431,1668,-1,6095,7240,2431,-1,6702,6099,6098,-1,6099,6702,6701,-1,1663,2425,6715,-1,1663,1662,2425,-1,2432,1616,3688,-1,1616,2432,6712,-1,1682,6727,3694,-1,1682,6710,6727,-1,6705,2410,2409,-1,2410,6705,1699,-1,6706,1612,1613,-1,6706,3837,1612,-1,6700,2436,7985,-1,6700,3687,2436,-1,3686,3653,6763,-1,1404,3653,3686,-1,6681,6720,2464,-1,6718,6720,6681,-1,7101,2556,6778,-1,6683,2556,7101,-1,5571,6836,5569,-1,5571,1646,6836,-1,6695,1652,1653,-1,6695,3839,1652,-1,1617,1639,2456,-1,2374,1639,1617,-1,2522,1711,1710,-1,2522,6760,1711,-1,1689,6763,3653,-1,2440,6763,1689,-1,1709,2448,540,-1,1709,2449,2448,-1,2363,3842,2528,-1,3842,2363,1631,-1,6734,3695,1563,-1,6734,7068,3695,-1,3684,7098,6735,-1,3684,1610,7098,-1,1618,1624,1619,-1,1618,3685,1624,-1,2454,1775,1622,-1,1775,2454,2450,-1,2451,2455,1776,-1,2455,2451,7088,-1,1398,2423,1681,-1,3652,2423,1398,-1,1792,3826,1793,-1,3826,1792,2392,-1,2460,1602,1601,-1,2460,3844,1602,-1,6730,7101,1575,-1,6730,6736,7101,-1,6723,6737,6722,-1,7099,6737,6723,-1,6731,7093,7984,-1,6738,7093,6731,-1,7100,2435,3836,-1,2435,7100,1590,-1,1573,2443,1574,-1,1573,1644,2443,-1,1790,1781,1784,-1,1781,1790,1789,-1,3830,2398,1703,-1,2399,2398,3830,-1,1566,1790,1567,-1,1570,1790,1566,-1,7074,7103,7983,-1,7103,7074,7102,-1,8003,6676,7983,-1,8003,2466,6676,-1,3677,7983,7103,-1,3677,8003,7983,-1,1550,1323,1688,-1,1323,1550,1324,-1,2402,1544,3872,-1,2402,1320,1544,-1,1319,1544,1320,-1,1544,1319,1545,-1,2472,243,456,-1,2472,3636,243,-1,2470,6630,3872,-1,2470,2557,6630,-1,1541,2472,2471,-1,1541,1543,2472,-1,6716,7113,6628,-1,7113,6716,7096,-1,1531,2201,2202,-1,2201,1531,3748,-1,7106,1522,6903,-1,7106,1520,1522,-1,6954,1512,6952,-1,6954,1513,1512,-1,3768,1407,1409,-1,3768,3767,1407,-1,7107,2031,3668,-1,7011,2031,7107,-1,6951,7017,2095,-1,7017,6951,6977,-1,6908,2220,6916,-1,2220,6908,6906,-1,6988,1409,1408,-1,6988,3771,1409,-1,7108,7016,7015,-1,7016,7108,7982,-1,6651,2480,3667,-1,2480,6651,6652,-1,6987,2481,6640,-1,6987,3665,2481,-1,6972,7109,2174,-1,2168,7109,6972,-1,3664,2044,2053,-1,3664,2045,2044,-1,2059,1501,3780,-1,2059,2172,1501,-1,2051,1476,1475,-1,2176,1476,2051,-1,2178,2088,7110,-1,2178,2089,2088,-1,6999,7981,2135,-1,6999,2206,7981,-1,7980,3774,7979,-1,3774,7980,2204,-1,1462,1997,1464,-1,1462,2130,1997,-1,7112,2097,6643,-1,7002,2097,7112,-1,7004,6648,6647,-1,7004,2119,6648,-1,2498,1448,2494,-1,2498,2155,1448,-1,1439,1351,2496,-1,1354,1351,1439,-1,3862,7978,2144,-1,7978,3862,2029,-1,2507,6950,2508,-1,6950,2507,6942,-1,2195,3856,2511,-1,3856,2195,6947,-1,2008,7112,7026,-1,2198,7112,2008,-1,3863,2514,1410,-1,2514,3863,3659,-1,1409,2478,3768,-1,1409,2521,2478,-1,2530,1396,1390,-1,2530,1397,1396,-1,1390,1401,2382,-1,1390,1396,1401,-1,2456,6693,2532,-1,6693,2456,1639,-1,3634,2099,2098,-1,2126,2099,3634,-1,3648,3775,2534,-1,3775,3648,3649,-1,3752,1946,2539,-1,2217,1946,3752,-1,2541,1347,3647,-1,2541,2501,1347,-1,1378,1381,1379,-1,1378,1347,1381,-1,2543,3648,2542,-1,2500,3648,2543,-1,3643,1355,3642,-1,1355,3643,1358,-1,2546,3778,3849,-1,2546,3776,3778,-1,2549,1365,1370,-1,1365,2549,1363,-1,1355,1980,2476,-1,1360,1980,1355,-1,3646,3645,3644,-1,3645,3646,3751,-1,1346,2128,1461,-1,1346,3800,2128,-1,2134,1380,3777,-1,2536,1380,2134,-1,6813,7067,1855,-1,7066,7067,6813,-1,6901,2555,2554,-1,6901,6899,2555,-1,7113,2358,2357,-1,7113,6671,2358,-1,7089,1595,1594,-1,7091,1595,7089,-1,7091,3675,1595,-1,6618,6565,6552,-1,6618,6615,6565,-1,7119,1318,7974,-1,3874,1318,7119,-1,6626,7114,6625,-1,6626,6621,7114,-1,6626,6605,6604,-1,6605,6626,6624,-1,6602,7115,7969,-1,6602,6601,7115,-1,6579,6600,7116,-1,6599,6600,6579,-1,1317,7126,6610,-1,1317,7117,7126,-1,6622,6595,6593,-1,6595,6622,6619,-1,6592,6617,6616,-1,6592,6590,6617,-1,3632,6613,6589,-1,3632,6611,6613,-1,6596,6610,7126,-1,6596,6609,6610,-1,7127,7117,2570,-1,7127,7126,7117,-1,6606,7125,3627,-1,6606,6603,7125,-1,6573,7973,7972,-1,6573,6583,7973,-1,7977,6577,6586,-1,7975,6577,7977,-1,6352,7977,6350,-1,6352,6588,7977,-1,7974,6608,6574,-1,1318,6608,7974,-1,7976,6612,6578,-1,7116,6612,7976,-1,7976,6587,6581,-1,7975,6587,7976,-1,7118,7974,7972,-1,7118,7119,7974,-1,6625,6562,7120,-1,6562,6625,7114,-1,6569,7970,6558,-1,7970,6569,7118,-1,6566,7971,6560,-1,7971,6566,7120,-1,7121,7971,6563,-1,7971,7121,6344,-1,7973,6349,7970,-1,7973,7166,6349,-1,6551,6555,6554,-1,6555,6551,6550,-1,7968,6551,6546,-1,7968,6549,6551,-1,7969,6549,7968,-1,7969,7115,6549,-1,7124,7123,7122,-1,6515,7123,7124,-1,1301,2565,2567,-1,1301,2566,2565,-1,6525,1299,1298,-1,1299,6525,2568,-1,1306,6540,6537,-1,1306,1305,6540,-1,6536,6539,6538,-1,6539,6536,6533,-1,6532,6543,6535,-1,2563,6543,6532,-1,2564,3628,2571,-1,1312,3628,2564,-1,2567,6531,6530,-1,2565,6531,2567,-1,2572,1309,3630,-1,2572,2574,1309,-1,6527,6529,6526,-1,6528,6529,6527,-1,2568,2575,2569,-1,6525,2575,2568,-1,6518,6520,1302,-1,6518,6519,6520,-1,1308,6522,1302,-1,1308,1307,6522,-1,1298,6524,6541,-1,1298,3877,6524,-1,6520,6515,6514,-1,7123,6515,6520,-1,6456,6482,6479,-1,6456,7129,6482,-1,6497,6452,6496,-1,7963,6452,6497,-1,6471,7130,6469,-1,6467,7130,6471,-1,6463,2587,7140,-1,6450,2587,6463,-1,7965,6444,6443,-1,6444,7965,6465,-1,7146,7132,7131,-1,7146,7141,7132,-1,6493,6498,1289,-1,6493,7133,6498,-1,6326,2580,7172,-1,3623,2580,6326,-1,6488,1291,1290,-1,3620,1291,6488,-1,6492,7136,7135,-1,7138,7136,6492,-1,6501,2581,3623,-1,6501,7135,2581,-1,6483,6481,6480,-1,6481,6483,7966,-1,6478,6485,7967,-1,6478,3621,6485,-1,6490,7128,7137,-1,7128,6490,7967,-1,7949,6476,7966,-1,7949,7951,6476,-1,6491,6511,6509,-1,6511,6491,6489,-1,3620,6504,1291,-1,3622,6504,3620,-1,2580,7950,7172,-1,7950,2580,6477,-1,7138,6507,7136,-1,7138,6506,6507,-1,6462,7140,7139,-1,6463,7140,6462,-1,7130,7141,6508,-1,7132,7141,7130,-1,7965,6458,7964,-1,7965,6502,6458,-1,6505,6466,6503,-1,7139,6466,6505,-1,6510,6464,7964,-1,6510,7129,6464,-1,3882,6453,6455,-1,3882,1294,6453,-1,6453,6457,6454,-1,6457,6453,2585,-1,7131,7142,7146,-1,7143,7142,7131,-1,7144,1293,1292,-1,7144,7145,1293,-1,2588,6450,2589,-1,2588,6451,6450,-1,6441,7149,6440,-1,6433,7149,6441,-1,3607,6102,2633,-1,6102,3607,6435,-1,7149,2592,7148,-1,2593,2592,7149,-1,6438,6422,7153,-1,6422,6438,7150,-1,6430,7175,7151,-1,6430,6427,7175,-1,2592,6417,6437,-1,2595,6417,2592,-1,6434,6414,6413,-1,6414,6434,7153,-1,6431,6429,6421,-1,6429,6431,6427,-1,6409,6429,6428,-1,6409,6408,6429,-1,7152,6404,7929,-1,7154,6404,7152,-1,6426,2594,2591,-1,7962,2594,6426,-1,6415,6400,7962,-1,1274,6400,6415,-1,6397,6420,6419,-1,6397,7155,6420,-1,6119,1271,6118,-1,3616,1271,6119,-1,6416,7961,7154,-1,7156,7961,6416,-1,7960,6403,6393,-1,7960,7156,6403,-1,7959,6410,7155,-1,7959,6391,6410,-1,7958,6407,1275,-1,7958,6390,6407,-1,7961,6394,6406,-1,7157,6394,7961,-1,7158,7960,6387,-1,7158,7157,7960,-1,1273,3613,6401,-1,2605,3613,1273,-1,7959,7159,6386,-1,7159,7959,6399,-1,2607,3889,3612,-1,2607,7958,3889,-1,1266,2598,2610,-1,1266,3612,2598,-1,2601,7158,1262,-1,2601,3615,7158,-1,2605,7957,2604,-1,7957,2605,2597,-1,7159,7956,6380,-1,7956,7159,6389,-1,6370,2609,2608,-1,6370,7956,2609,-1,2614,2602,2601,-1,2614,2612,2602,-1,6385,6376,7957,-1,7160,6376,6385,-1,7955,6378,2616,-1,7955,6368,6378,-1,7161,6368,7955,-1,7161,6369,6368,-1,6377,6369,7161,-1,6374,6369,6377,-1,6374,7952,6369,-1,7954,7952,6374,-1,7954,7163,7952,-1,7954,6367,7163,-1,7162,6367,7954,-1,7162,6366,6367,-1,6371,6366,7162,-1,6371,7953,6366,-1,6371,6373,7953,-1,6382,7955,3890,-1,6382,7161,7955,-1,7162,7160,6381,-1,7160,7162,7954,-1,1265,7953,2608,-1,1265,6366,7953,-1,7952,2611,2613,-1,2611,7952,7163,-1,7167,1771,6347,-1,7167,1772,1771,-1,6342,6756,7164,-1,6342,7168,6756,-1,2366,6356,2365,-1,7165,6356,2366,-1,6351,7080,6341,-1,6351,7079,7080,-1,6358,6585,7165,-1,6584,6585,6358,-1,6340,7167,7166,-1,6340,6339,7167,-1,7121,6364,7168,-1,7121,6557,6364,-1,6553,7944,6362,-1,6553,6561,7944,-1,7172,7173,7169,-1,7172,7950,7173,-1,7170,7948,6754,-1,7134,7948,7170,-1,7137,6321,7171,-1,7137,7128,6321,-1,7951,6318,7945,-1,7951,7949,6318,-1,7134,6500,7948,-1,7134,7133,6500,-1,6329,7947,7084,-1,7947,6329,7171,-1,7173,7946,7174,-1,7946,7173,7945,-1,6311,6316,6751,-1,6311,6315,6316,-1,6441,2618,2617,-1,2618,6441,6439,-1,6307,6120,7151,-1,6307,3904,6120,-1,7944,7087,6749,-1,6345,7087,7944,-1,6150,6289,7176,-1,7180,6289,6150,-1,6146,6286,7178,-1,7183,6286,6146,-1,6142,6284,7179,-1,7184,6284,6142,-1,7186,6116,6115,-1,7186,6281,6116,-1,6296,7181,7180,-1,6279,7181,6296,-1,6294,7182,7183,-1,6278,7182,6294,-1,6292,1257,7184,-1,6282,1257,6292,-1,7181,7191,6291,-1,7187,7191,7181,-1,7188,6288,7182,-1,7188,7193,6288,-1,7189,7188,6277,-1,7189,7195,7188,-1,6266,6283,7185,-1,6266,6265,6283,-1,1248,7190,7927,-1,1248,3893,7190,-1,7187,7192,7191,-1,7943,7192,7187,-1,6271,7942,7943,-1,7198,7942,6271,-1,7199,7195,7189,-1,7199,7194,7195,-1,6276,7196,6275,-1,7200,7196,6276,-1,7201,6273,6272,-1,7201,7197,6273,-1,7943,6258,7192,-1,7942,6258,7943,-1,7198,6239,7942,-1,6237,6239,7198,-1,6235,7194,7199,-1,6235,6234,7194,-1,7200,6231,7196,-1,6229,6231,7200,-1,6227,7197,7201,-1,6227,6226,7197,-1,6298,6227,6245,-1,6298,6225,6227,-1,6261,6305,6259,-1,6304,6305,6261,-1,6300,6257,6254,-1,6300,6301,6257,-1,6253,6297,6251,-1,6299,6297,6253,-1,6303,6249,6246,-1,6303,6302,6249,-1,7202,6125,6122,-1,7202,7940,6125,-1,5554,3894,1245,-1,3894,5554,5556,-1,6127,7210,7230,-1,7205,7210,6127,-1,7231,7940,6219,-1,7940,7231,6125,-1,7940,7207,7212,-1,7207,7940,7202,-1,6205,7203,6203,-1,6205,5602,7203,-1,7205,6209,7210,-1,7211,6209,7205,-1,7206,1238,7211,-1,1239,1238,7206,-1,6198,7212,7207,-1,6198,6197,7212,-1,6196,2623,2622,-1,6196,7208,2623,-1,6194,7213,7353,-1,6194,6193,7213,-1,6211,6200,6213,-1,6210,6200,6211,-1,6212,1229,6210,-1,1230,1229,6212,-1,3895,6187,6186,-1,6187,3895,1240,-1,6206,1223,2621,-1,1224,1223,6206,-1,6195,3898,1224,-1,6177,3898,6195,-1,7214,6201,7216,-1,7214,6199,6201,-1,3900,2624,1234,-1,3900,6180,2624,-1,1231,6182,3896,-1,2627,6182,1231,-1,7221,1219,3899,-1,7221,2627,1219,-1,6163,6188,6184,-1,6163,6165,6188,-1,7217,6190,7214,-1,7217,7938,6190,-1,3901,7939,3902,-1,7941,7939,3901,-1,7218,7938,7217,-1,7218,7937,7938,-1,7219,7215,6178,-1,7219,7936,7215,-1,7935,7221,7220,-1,7935,6183,7221,-1,7222,1216,2628,-1,7222,7934,1216,-1,7223,3901,6181,-1,7223,7941,3901,-1,6729,6145,7094,-1,7225,6145,6729,-1,1697,6096,6093,-1,7933,6096,1697,-1,7933,7177,6096,-1,7176,7177,7933,-1,6158,6295,7224,-1,7178,6295,6158,-1,6155,6293,7225,-1,7179,6293,6155,-1,7932,6135,7226,-1,7931,6135,7932,-1,6726,7930,6133,-1,7930,6726,6725,-1,5559,2630,3608,-1,5559,5558,2630,-1,7228,7931,6140,-1,7228,6126,7931,-1,7229,7930,6137,-1,7229,6124,7930,-1,2629,6222,3608,-1,7230,6222,2629,-1,7231,7228,6134,-1,7231,6220,7228,-1,6131,7229,6130,-1,6131,6224,7229,-1,6100,7233,7239,-1,6100,7232,7233,-1,7232,7234,7233,-1,7232,7929,7234,-1,7929,6405,7234,-1,7929,6404,6405,-1,7928,6085,7926,-1,7928,7235,6085,-1,6109,6115,7236,-1,6109,7186,6115,-1,1254,7235,7928,-1,1254,7238,7235,-1,7927,6112,7238,-1,7927,7190,6112,-1,6101,2424,2633,-1,2424,6101,3692,-1,6121,6107,7239,-1,6107,6121,6106,-1,6711,6141,6709,-1,6711,6090,6141,-1,6087,6713,7240,-1,6713,6087,6086,-1,7177,6094,6096,-1,7177,7926,6094,-1,6117,6097,7241,-1,6117,7237,6097,-1,5991,5980,5990,-1,7269,5980,5991,-1,7269,5982,5980,-1,7921,5982,7269,-1,7921,5994,5982,-1,7921,5997,5994,-1,7271,5997,7921,-1,7270,5997,7271,-1,7922,5997,7270,-1,7922,7919,5997,-1,5993,7919,7922,-1,5993,7918,7919,-1,5993,7268,7918,-1,5992,7268,5993,-1,5992,5998,7268,-1,1082,6070,5719,-1,6068,6070,1082,-1,6066,1054,7250,-1,6066,6063,1054,-1,7251,7253,5712,-1,6072,7253,7251,-1,3572,7923,2712,-1,7252,7923,3572,-1,5594,6059,5716,-1,5593,6059,5594,-1,6056,6079,6084,-1,6056,6055,6079,-1,6083,6011,6010,-1,6011,6083,6021,-1,6081,7255,6080,-1,6058,7255,6081,-1,6075,1206,7252,-1,1207,1206,6075,-1,7255,1202,6064,-1,1203,1202,7255,-1,7256,6074,6071,-1,7256,7259,6074,-1,3606,6069,2635,-1,3606,6067,6069,-1,6065,1202,6050,-1,1202,6065,6064,-1,7920,6019,6061,-1,7920,7267,6019,-1,7263,7259,7256,-1,7263,3605,7259,-1,6046,7267,7920,-1,6046,6045,7267,-1,6054,2645,6052,-1,7261,2645,6054,-1,3910,2634,7262,-1,3910,1196,2634,-1,1204,1187,3906,-1,2639,1187,1204,-1,6040,3605,7263,-1,6040,2640,3605,-1,5576,3604,7266,-1,3604,5576,2642,-1,7261,2644,2645,-1,6034,2644,7261,-1,6037,7264,7356,-1,6037,6036,7264,-1,5999,1194,7265,-1,5999,7262,1194,-1,6041,2641,2640,-1,6041,3602,2641,-1,7925,6002,6001,-1,6002,7925,7266,-1,6013,5985,5984,-1,5985,6013,6015,-1,6018,5575,5572,-1,5575,6018,6017,-1,2652,6020,2653,-1,2652,7924,6020,-1,6024,2637,7924,-1,2638,2637,6024,-1,6026,5708,5706,-1,6083,5708,6026,-1,6045,6028,7267,-1,6045,6031,6028,-1,5705,6012,3927,-1,6012,5705,6010,-1,7258,6062,7923,-1,7258,6061,6062,-1,6033,7242,1174,-1,7249,7242,6033,-1,7246,6006,6038,-1,7246,6004,6006,-1,1180,7243,1181,-1,7245,7243,1180,-1,7268,5988,7918,-1,7268,7265,5988,-1,7922,6041,6039,-1,7922,7270,6041,-1,1184,7269,1185,-1,7921,7269,1184,-1,5990,3603,2646,-1,5990,5980,3603,-1,2652,2647,6025,-1,2651,2647,2652,-1,6030,2643,5582,-1,2643,6030,6029,-1,7260,7920,7257,-1,6046,7920,7260,-1,7245,5985,7247,-1,7245,1180,5985,-1,5973,7334,5971,-1,5973,5672,7334,-1,7272,5667,7338,-1,7272,5968,5667,-1,7273,5968,7272,-1,7273,5970,5968,-1,5962,1074,5960,-1,5962,1075,1074,-1,7277,5978,5965,-1,7277,7276,5978,-1,5683,5953,7278,-1,5951,5953,5683,-1,5685,5957,7337,-1,5955,5957,5685,-1,5945,5970,7273,-1,5945,5944,5970,-1,3584,2660,5975,-1,5942,2660,3584,-1,5974,7917,5972,-1,5948,7917,5974,-1,5680,5936,5678,-1,5934,5936,5680,-1,7284,5829,5967,-1,7284,7303,5829,-1,1157,7917,3914,-1,1157,5961,7917,-1,5930,2656,5966,-1,5930,2654,2656,-1,5963,3597,5927,-1,3597,5963,2659,-1,5961,7285,5959,-1,1157,7285,5961,-1,5958,5922,5956,-1,5920,5922,5958,-1,5954,5918,5952,-1,5916,5918,5954,-1,7303,5926,5925,-1,5926,7303,7284,-1,2657,1154,5947,-1,3915,1154,2657,-1,5910,5946,5943,-1,5910,5909,5946,-1,5820,5907,5933,-1,5908,5907,5820,-1,5940,5906,5938,-1,5905,5906,5940,-1,5937,5904,5935,-1,5903,5904,5937,-1,5902,5910,5928,-1,5902,5901,5910,-1,5843,5899,5848,-1,5844,5899,5843,-1,7287,5931,5929,-1,7287,7916,5931,-1,5919,7915,5917,-1,7288,7915,5919,-1,7289,5828,5924,-1,7289,5826,5828,-1,5923,7914,5921,-1,7290,7914,5923,-1,2668,7287,5911,-1,2668,7293,7287,-1,1150,5915,3595,-1,1150,3916,5915,-1,5913,5884,5912,-1,5882,5884,5913,-1,7290,5880,7914,-1,5878,5880,7290,-1,7288,5876,7915,-1,5874,5876,7288,-1,5872,5826,7289,-1,5872,5871,5826,-1,3594,5869,5882,-1,2666,5869,3594,-1,2667,7293,2668,-1,2667,7292,7293,-1,5900,5849,5898,-1,7294,5849,5900,-1,5890,5866,5888,-1,5864,5866,5890,-1,5897,5862,5895,-1,5860,5862,5897,-1,5819,1145,5892,-1,1146,1145,5819,-1,5883,5812,7907,-1,3592,5812,5883,-1,5858,7292,2667,-1,5858,5857,7292,-1,5873,3919,1129,-1,3919,5873,5870,-1,5881,5853,5879,-1,5851,5853,5881,-1,5877,7913,5875,-1,7295,7913,5877,-1,3592,5810,5812,-1,2670,5810,3592,-1,7296,7913,7295,-1,7296,7912,7913,-1,5867,7297,5865,-1,7911,7297,5867,-1,5863,3599,5861,-1,3600,3599,5863,-1,5899,7291,2663,-1,7291,5899,5898,-1,7275,5942,3584,-1,5942,7275,7280,-1,7909,7281,7298,-1,7909,5932,7281,-1,7299,7294,5900,-1,7299,7908,7294,-1,7304,7279,5830,-1,7304,7282,7279,-1,3585,7300,5827,-1,3585,3587,7300,-1,7910,5817,7302,-1,5818,5817,7910,-1,7283,5822,5821,-1,5822,7283,7286,-1,5962,2715,1075,-1,5962,5845,2715,-1,5971,7335,7276,-1,5971,7334,7335,-1,5925,7304,7303,-1,5925,5839,7304,-1,3585,5873,3588,-1,5871,5873,3585,-1,5818,1147,1146,-1,1147,5818,1125,-1,5908,5836,5891,-1,5908,5834,5836,-1,5959,7909,7298,-1,5959,7285,7909,-1,7305,7908,7299,-1,7305,7907,7908,-1,1099,7328,7904,-1,5750,7328,1099,-1,5750,5746,7328,-1,5750,5749,5746,-1,7327,5749,5750,-1,7327,7903,5749,-1,7327,7329,7903,-1,7327,1094,7329,-1,3577,1094,7327,-1,3577,2702,1094,-1,3577,3575,2702,-1,3577,5744,3575,-1,3577,7901,5744,-1,3577,7330,7901,-1,7341,2675,7308,-1,2728,2675,7341,-1,7905,5808,5803,-1,7905,7906,5808,-1,7350,2676,2677,-1,7317,2676,7350,-1,7318,7310,5635,-1,7318,7309,7310,-1,7349,3583,7326,-1,3583,7349,2681,-1,2673,2682,2674,-1,5781,2682,2673,-1,5780,7888,7313,-1,5780,5779,7888,-1,5777,7886,7314,-1,5777,5776,7886,-1,7315,7326,3583,-1,7315,5754,7326,-1,7317,5786,2676,-1,7316,5786,7317,-1,7318,5782,7309,-1,7319,5782,7318,-1,7320,1110,3582,-1,7320,5791,1110,-1,5766,7315,5796,-1,5766,5768,7315,-1,5794,5765,7316,-1,5764,5765,5794,-1,5763,7319,5790,-1,5763,5762,7319,-1,5775,2683,2687,-1,5775,5802,2683,-1,5772,5801,5800,-1,5772,3922,5801,-1,5770,5799,5798,-1,5770,7321,5799,-1,2692,3574,7325,-1,2691,3574,2692,-1,3573,2686,2709,-1,3573,2687,2686,-1,5738,5778,7321,-1,5738,5730,5778,-1,7324,3582,7322,-1,7324,7320,3582,-1,5789,5745,5787,-1,2703,5745,5789,-1,7323,5785,7902,-1,7323,5783,5785,-1,5760,1098,2706,-1,1098,5760,5751,-1,7312,5619,5631,-1,7312,5761,5619,-1,3925,5807,1090,-1,3925,5797,5807,-1,7325,3924,2701,-1,3924,7325,3574,-1,2701,2688,2690,-1,2688,2701,3924,-1,7326,5628,7349,-1,7311,5628,7326,-1,3577,1101,3578,-1,3577,7327,1101,-1,7324,7904,7328,-1,7904,7324,7322,-1,7903,7323,7902,-1,7903,7329,7323,-1,5769,7330,5767,-1,7901,7330,5769,-1,3574,3923,3924,-1,2708,3923,3574,-1,1093,2685,1109,-1,2685,1093,2706,-1,2691,2697,2707,-1,2697,2691,2698,-1,5734,3573,2711,-1,5734,5733,3573,-1,7307,1103,5774,-1,7307,7306,1103,-1,3807,1085,3926,-1,5718,1085,3807,-1,1937,2714,3745,-1,7331,2714,1937,-1,1053,3928,1935,-1,1053,1050,3928,-1,7040,5709,5711,-1,5709,7040,6888,-1,6077,5720,1086,-1,6077,6078,5720,-1,7331,3572,2714,-1,6076,3572,7331,-1,5725,6082,7250,-1,6082,5725,5724,-1,7899,7333,7332,-1,7900,7333,7899,-1,1050,2732,3566,-1,1050,1052,2732,-1,7332,5707,5704,-1,7332,7333,5707,-1,6887,5669,5668,-1,5669,6887,6886,-1,3929,6885,6883,-1,7894,6885,3929,-1,5688,6884,5690,-1,5688,7893,6884,-1,7898,1058,3930,-1,2724,1058,7898,-1,2256,5668,7895,-1,6887,5668,2256,-1,1074,5672,5973,-1,1074,1073,5672,-1,5659,7337,7897,-1,7337,5659,7336,-1,7278,3569,2722,-1,7278,5677,3569,-1,5666,5675,7896,-1,5663,5675,5666,-1,7337,5949,7897,-1,5957,5949,7337,-1,3570,7896,1067,-1,3570,5666,7896,-1,2718,1120,1068,-1,1118,1120,2718,-1,5691,2722,2721,-1,5691,5684,2722,-1,2723,5676,1071,-1,5676,2723,2717,-1,7895,7335,5701,-1,7895,5979,7335,-1,5977,5695,7894,-1,5695,5977,5976,-1,1121,3570,1069,-1,3570,1121,2672,-1,5688,7336,7893,-1,5688,5686,7336,-1,7892,7339,7345,-1,7339,7892,6858,-1,7885,6855,7340,-1,7885,1927,6855,-1,2264,7308,6863,-1,7341,7308,2264,-1,5640,6862,6859,-1,5640,7891,6862,-1,7348,7343,7342,-1,7348,7046,7343,-1,7048,2725,2261,-1,7890,2725,7048,-1,6869,7344,6867,-1,7347,7344,6869,-1,7889,5636,7891,-1,7889,5625,5636,-1,7345,7887,5623,-1,7887,7345,7339,-1,1088,7340,7906,-1,1088,7885,7340,-1,7310,5644,5646,-1,7310,5804,5644,-1,7342,2679,7348,-1,1115,2679,7342,-1,1113,2725,7890,-1,1113,2681,2725,-1,7347,7350,7344,-1,5805,7350,7347,-1,7313,7889,5642,-1,7313,7888,7889,-1,7314,7887,5639,-1,7314,7886,7887,-1,5629,3742,2267,-1,5629,5618,3742,-1,7346,2695,5613,-1,2695,7346,3580,-1,3568,2270,2726,-1,5630,2270,3568,-1,5615,1088,1090,-1,7885,1088,5615,-1,5556,7209,3894,-1,7351,7209,5556,-1,5609,5599,5552,-1,5609,7352,5599,-1,5607,7208,7209,-1,5607,2623,7208,-1,7353,7352,5605,-1,7353,7213,7352,-1,5542,5588,5587,-1,2730,5588,5542,-1,5598,5543,5596,-1,5598,5591,5543,-1,7355,5598,5595,-1,7355,5585,5598,-1,5592,6049,7354,-1,5592,6048,6049,-1,5578,7355,5589,-1,5578,5577,7355,-1,7356,5586,5583,-1,7356,7264,5586,-1,7883,5572,2733,-1,6018,5572,7883,-1,1648,7884,1649,-1,1648,7357,7884,-1,7358,3934,6835,-1,7358,5562,3934,-1,7359,7361,6833,-1,7359,5560,7361,-1,7361,5608,5566,-1,7361,7360,5608,-1,7357,5555,7884,-1,7357,5553,5555,-1,3937,7351,7362,-1,3937,5606,7351,-1,5559,7204,5557,-1,5559,6223,7204,-1,5545,2298,7363,-1,2298,5545,2295,-1,5549,5716,5713,-1,5549,5594,5716,-1,5597,7363,5547,-1,5597,5596,7363,-1,3938,5703,1052,-1,5703,3938,5706,-1,3140,246,380,-1,3141,246,3140,-1,7379,5447,5190,-1,7379,7378,5447,-1,912,7364,5189,-1,912,277,7364,-1,2820,5539,2819,-1,5539,2820,5538,-1,935,5482,933,-1,5482,935,5481,-1,952,3454,3106,-1,3454,952,2781,-1,394,417,949,-1,394,412,417,-1,8004,5478,5537,-1,5478,8004,5477,-1,353,3543,1036,-1,353,335,3543,-1,361,5464,4026,-1,361,5461,5464,-1,919,2801,7390,-1,919,5479,2801,-1,1002,3945,2749,-1,1002,5507,3945,-1,5509,5493,2784,-1,5493,5509,3087,-1,3948,5492,3455,-1,5492,3948,7387,-1,975,994,2777,-1,977,994,975,-1,5534,2773,2750,-1,7367,2773,5534,-1,7367,2774,2773,-1,2774,7367,5495,-1,5505,5510,5504,-1,5510,5505,5533,-1,2765,987,5501,-1,987,2765,988,-1,7370,3561,2759,-1,7382,3561,7370,-1,5193,3562,2754,-1,5193,5192,3562,-1,1010,2753,1008,-1,1010,7482,2753,-1,5202,5485,5490,-1,5485,5202,5200,-1,7881,4024,3081,-1,7881,5517,4024,-1,7374,7480,7373,-1,7374,7481,7480,-1,5526,5516,2757,-1,5516,5526,5524,-1,5191,7376,7377,-1,5191,5528,7376,-1,2783,7882,980,-1,2783,3086,7882,-1,4035,5198,1020,-1,4035,3137,5198,-1,2753,7481,7374,-1,7482,7481,2753,-1,5532,5516,7375,-1,5516,5532,2797,-1,3111,7371,7380,-1,3111,7372,7371,-1,3457,441,7488,-1,3457,3459,441,-1,3078,445,3076,-1,445,3078,334,-1,1012,962,2791,-1,1012,961,962,-1,974,3549,3951,-1,3548,3549,974,-1,426,979,5499,-1,426,2782,979,-1,5513,5498,5497,-1,5513,5450,5498,-1,5508,2765,3946,-1,2765,5508,2766,-1,7368,2790,2789,-1,7368,3552,2790,-1,3951,2795,7386,-1,2795,3951,3549,-1,5512,7383,5515,-1,5512,5496,7383,-1,987,2771,989,-1,2771,987,986,-1,430,983,431,-1,430,3554,983,-1,980,2767,978,-1,2767,980,7882,-1,2770,990,995,-1,990,2770,3949,-1,7388,407,5506,-1,7388,2763,407,-1,7368,7388,5511,-1,7368,2789,7388,-1,2775,5514,2768,-1,2775,5512,5514,-1,7387,7384,5492,-1,7387,7386,7384,-1,3555,3550,3551,-1,3550,3555,2764,-1,7385,410,402,-1,7385,997,410,-1,3549,2796,2795,-1,3549,971,2796,-1,1007,3546,2800,-1,2805,3546,1007,-1,5469,5178,5467,-1,5469,3102,5178,-1,5486,922,931,-1,922,5486,3953,-1,5478,5489,930,-1,5452,5489,5478,-1,966,917,967,-1,966,2804,917,-1,5537,930,2742,-1,930,5537,5478,-1,1011,7863,3563,-1,7863,1011,2811,-1,2813,3081,437,-1,2813,3559,3081,-1,3100,5537,3101,-1,5537,3100,8004,-1,341,3447,5185,-1,3447,341,362,-1,5530,3075,3074,-1,5530,5531,3075,-1,1037,2814,1038,-1,1037,941,2814,-1,2818,7485,2838,-1,2818,1034,7485,-1,7861,2814,2819,-1,7861,351,2814,-1,342,4027,343,-1,342,344,4027,-1,5180,935,938,-1,3097,935,5180,-1,947,398,2824,-1,947,2822,398,-1,3099,8004,3100,-1,8004,3099,5491,-1,5491,5477,8004,-1,5491,5488,5477,-1,920,7390,3448,-1,920,919,7390,-1,2740,394,396,-1,3544,394,2740,-1,368,924,923,-1,368,3452,924,-1,944,5536,3564,-1,5458,5536,944,-1,2825,2828,2826,-1,3942,2828,2825,-1,5472,3560,5474,-1,5472,3558,3560,-1,5468,7881,5471,-1,5468,5517,7881,-1,5466,5470,5467,-1,5463,5470,5466,-1,5529,5465,5460,-1,5465,5529,7380,-1,5462,3075,5531,-1,5462,5457,3075,-1,3073,944,1021,-1,5458,944,3073,-1,926,2741,3545,-1,926,3446,2741,-1,2743,1004,427,-1,2744,1004,2743,-1,5498,953,1033,-1,388,953,5498,-1,388,387,953,-1,3460,2837,280,-1,2835,2837,3460,-1,5448,7483,2836,-1,7391,7483,5448,-1,5332,806,2884,-1,5332,5331,806,-1,5384,729,2891,-1,5384,5443,729,-1,3091,907,3433,-1,3091,908,907,-1,689,5366,5432,-1,5366,689,5364,-1,2841,5437,892,-1,2841,7399,5437,-1,4020,3534,805,-1,4020,7880,3534,-1,713,730,5336,-1,730,713,731,-1,2842,2905,875,-1,2842,7871,2905,-1,3983,7880,4020,-1,3983,3982,7880,-1,680,7875,7440,-1,680,682,7875,-1,5446,449,7405,-1,3066,449,5446,-1,2836,5195,5435,-1,7483,5195,2836,-1,5434,2841,891,-1,5434,3461,2841,-1,5429,7407,5440,-1,7407,5429,7408,-1,5432,7859,5169,-1,5432,5366,7859,-1,7394,5360,5440,-1,7394,7393,5360,-1,7874,3145,5173,-1,5436,3145,7874,-1,816,2859,817,-1,816,2860,2859,-1,7403,3070,7406,-1,7403,448,3070,-1,7403,8005,448,-1,5375,4277,29,-1,5375,2899,4277,-1,7878,2865,2864,-1,2865,7878,3371,-1,5428,793,3975,-1,4274,793,5428,-1,3327,782,3976,-1,4278,782,3327,-1,772,4244,7877,-1,4254,4244,772,-1,4251,5421,2903,-1,5420,5421,4251,-1,776,2867,7751,-1,776,2868,2867,-1,4245,778,5370,-1,778,4245,7750,-1,768,7793,769,-1,768,845,7793,-1,5353,3963,5351,-1,3963,5353,838,-1,5354,7422,2908,-1,7422,5354,5417,-1,2870,843,2871,-1,841,843,2870,-1,2907,5406,5358,-1,2907,7418,5406,-1,7438,7424,7417,-1,7438,7876,7424,-1,841,826,842,-1,841,827,826,-1,2909,5398,5414,-1,2909,5397,5398,-1,7760,7418,5412,-1,7419,7418,7760,-1,7789,2870,3537,-1,7420,2870,7789,-1,7421,7414,5419,-1,7757,7414,7421,-1,5417,4203,7422,-1,4203,5417,4202,-1,840,7423,7424,-1,7423,840,8,-1,7425,2872,831,-1,2872,7425,7427,-1,7426,3964,835,-1,7425,3964,7426,-1,2876,7426,824,-1,4167,7426,2876,-1,3967,3992,3965,-1,3992,3967,5357,-1,5350,684,683,-1,5350,5352,684,-1,747,811,2924,-1,747,812,811,-1,696,792,785,-1,695,792,696,-1,5326,2885,5321,-1,5326,2886,2885,-1,3534,5444,2884,-1,7431,5444,3534,-1,7880,7431,3534,-1,7431,7880,5439,-1,5333,5321,5322,-1,5333,5325,5321,-1,7432,7785,4126,-1,7432,7435,7785,-1,7784,7433,5380,-1,7433,7784,4123,-1,7879,789,7434,-1,7437,789,7879,-1,2893,2895,2894,-1,2895,2893,2890,-1,7441,5339,7430,-1,5339,7441,7873,-1,2890,7433,5385,-1,2890,2893,7433,-1,2915,7432,5344,-1,7432,2915,7435,-1,2882,7437,7878,-1,7437,2882,3524,-1,797,800,798,-1,3972,800,797,-1,851,2898,7410,-1,2898,851,847,-1,739,3531,752,-1,3531,739,751,-1,773,818,774,-1,773,5369,818,-1,5359,7877,7412,-1,7877,5359,810,-1,764,5320,3990,-1,764,763,5320,-1,7395,5347,7393,-1,5346,5347,7395,-1,2906,5430,5348,-1,2906,2905,5430,-1,3968,843,842,-1,843,3968,3969,-1,5410,3967,3966,-1,5410,5418,3967,-1,2879,5414,3993,-1,2879,2909,5414,-1,7876,2877,746,-1,7876,7438,2877,-1,5416,5394,7415,-1,5416,5392,5394,-1,5363,7401,5361,-1,5363,7400,7401,-1,3523,7440,5365,-1,3523,680,7440,-1,3988,3971,3989,-1,3988,691,3971,-1,2850,5171,2852,-1,5345,5171,2850,-1,5379,3530,726,-1,5379,5382,3530,-1,5389,7441,5388,-1,5389,5338,7441,-1,5387,7392,2930,-1,5387,7430,7392,-1,5173,7875,7874,-1,5172,7875,5173,-1,5337,722,7873,-1,5337,723,722,-1,7397,5389,3985,-1,5389,7397,7396,-1,2863,881,880,-1,2863,5395,881,-1,859,5396,3965,-1,859,5395,5396,-1,5322,7872,5276,-1,5322,2922,7872,-1,486,693,3482,-1,486,694,693,-1,7443,5324,7444,-1,5390,5324,7443,-1,7408,7444,7407,-1,7408,5327,7444,-1,693,5433,5329,-1,5433,693,692,-1,807,7871,2842,-1,3960,7871,807,-1,735,694,736,-1,694,735,2883,-1,743,2927,681,-1,2911,2927,743,-1,599,5316,2928,-1,599,7445,5316,-1,7446,516,3959,-1,516,7446,7865,-1,7447,7446,5319,-1,7446,7447,7864,-1,5315,5314,7447,-1,5315,3520,5314,-1,3151,6761,7452,-1,3151,5164,6761,-1,3519,3501,3475,-1,3519,603,3501,-1,474,3049,472,-1,474,2934,3049,-1,3515,7866,3051,-1,3515,2941,7866,-1,2936,470,476,-1,2938,470,2936,-1,3033,4013,7489,-1,3033,543,4013,-1,475,5223,2937,-1,475,3515,5223,-1,327,3035,541,-1,3036,3035,327,-1,3057,3053,461,-1,3057,2414,3053,-1,642,2942,643,-1,642,652,2942,-1,5312,613,2931,-1,5312,614,613,-1,3509,4912,5293,-1,4912,3509,4910,-1,5305,2970,5292,-1,2970,5305,5304,-1,7453,4909,7568,-1,4909,7453,2953,-1,2948,2951,645,-1,2948,2949,2951,-1,4892,2946,5304,-1,2946,4892,2947,-1,5288,2965,3510,-1,4001,2965,5288,-1,2955,5290,5298,-1,2955,2954,5290,-1,2981,7455,7870,-1,7455,2981,5287,-1,4885,5300,5299,-1,7576,5300,4885,-1,2956,7837,2957,-1,7837,2956,7456,-1,4870,634,7460,-1,4870,2977,634,-1,7458,7870,7455,-1,4888,7870,7458,-1,662,4016,3491,-1,662,2964,4016,-1,7579,7461,4866,-1,7869,7461,7579,-1,7869,4642,3500,-1,7869,7579,4642,-1,5293,4855,2968,-1,5293,4912,4855,-1,2964,5232,4016,-1,2963,5232,2964,-1,1750,5294,2967,-1,5294,1750,6747,-1,2972,653,652,-1,2972,2950,653,-1,2966,3513,639,-1,2966,2952,3513,-1,3489,2988,2986,-1,2988,3489,2974,-1,3116,7489,3117,-1,3033,7489,3116,-1,2958,3998,638,-1,2958,5307,3998,-1,2982,2964,662,-1,2982,3511,2964,-1,2959,621,2960,-1,5284,621,2959,-1,7869,618,7461,-1,619,618,7869,-1,538,2986,2988,-1,2986,538,2987,-1,5220,2941,2991,-1,5220,7866,2941,-1,5276,3149,3148,-1,3146,5276,7872,-1,3146,3149,5276,-1,5342,5233,5236,-1,5342,5441,5233,-1,5330,3502,5264,-1,5330,7442,3502,-1,5226,5230,5229,-1,5230,5226,5225,-1,5247,3009,520,-1,5247,3008,3009,-1,4698,7475,5273,-1,7615,7475,4698,-1,7826,7468,570,-1,4692,7468,7826,-1,4680,5243,4678,-1,4680,7868,5243,-1,7469,3021,7470,-1,7469,5245,3021,-1,5251,597,598,-1,5251,7471,597,-1,505,7867,602,-1,7867,505,504,-1,5281,323,322,-1,5281,3037,323,-1,594,3003,7473,-1,3003,594,3004,-1,3048,5275,3047,-1,3048,493,5275,-1,7822,5254,5255,-1,7474,5254,7822,-1,5255,3238,7822,-1,5255,4010,3238,-1,573,7467,571,-1,573,7821,7467,-1,5250,4624,5249,-1,4636,4624,5250,-1,586,3488,3020,-1,4009,3488,586,-1,5255,568,4010,-1,5255,3497,568,-1,3014,5240,566,-1,5285,5240,3014,-1,7475,5247,5268,-1,7475,5246,5247,-1,5257,577,576,-1,5257,4009,577,-1,5242,2998,3017,-1,5242,7471,2998,-1,3485,3015,5253,-1,3485,513,3015,-1,559,5269,560,-1,5269,559,7868,-1,3022,5269,3024,-1,5269,3022,560,-1,7450,5265,3001,-1,7450,7449,5265,-1,550,5328,7476,-1,550,3482,5328,-1,3027,3023,3025,-1,547,3023,3027,-1,7436,485,3028,-1,7436,2914,485,-1,546,549,552,-1,548,549,546,-1,4032,537,536,-1,4032,7451,537,-1,3114,3517,309,-1,3517,3114,3516,-1,471,3035,469,-1,471,2939,3035,-1,3002,322,554,-1,3002,5281,322,-1,3479,7450,3052,-1,7450,3479,3480,-1,326,7860,556,-1,325,7860,326,-1,5442,3486,5441,-1,5442,895,3486,-1,317,524,3029,-1,525,524,317,-1,2989,4002,2990,-1,2984,4002,2989,-1,3045,5267,5266,-1,3045,3047,5267,-1,5274,550,7477,-1,3481,550,5274,-1,5283,5263,7463,-1,5263,5283,5261,-1,451,5277,3148,-1,7465,5277,451,-1,499,3006,5253,-1,3006,499,3483,-1,5391,7464,7476,-1,7464,5391,5282,-1,5445,515,7442,-1,897,515,5445,-1,6762,3505,610,-1,5309,3505,6762,-1,2933,3051,7866,-1,3051,2933,474,-1,3479,553,3478,-1,553,3479,3052,-1,5317,7445,7478,-1,5316,7445,5317,-1,7864,7865,7446,-1,7865,7864,5216,-1,466,5317,7478,-1,5317,466,468,-1,5211,2415,579,-1,5211,5213,2415,-1,464,3054,465,-1,464,3055,3054,-1,3431,7452,3474,-1,3151,7452,3431,-1,2993,4019,2934,-1,2993,608,4019,-1,455,457,242,-1,457,455,3469,-1,5165,3467,7448,-1,4005,3467,5165,-1,3465,3063,943,-1,3465,3066,3063,-1,7405,8005,7403,-1,448,7405,449,-1,8005,7405,448,-1,3983,5206,5203,-1,3983,7479,5206,-1,4022,2799,4023,-1,2799,4022,2800,-1,7480,3074,3065,-1,7481,3074,7480,-1,2762,2800,4022,-1,1007,2800,2762,-1,7375,7863,5532,-1,5527,7863,7375,-1,5530,1010,3112,-1,5530,7482,1010,-1,7391,7404,7483,-1,7402,7404,7391,-1,5523,7379,5521,-1,7377,7379,5523,-1,3562,2757,2759,-1,3562,5192,2757,-1,7372,7484,5518,-1,7372,1026,7484,-1,3082,3459,3457,-1,3082,3083,3459,-1,993,2772,2771,-1,2772,993,992,-1,5493,3086,2783,-1,3086,5493,3087,-1,985,2788,2787,-1,2788,985,403,-1,861,908,3090,-1,2839,908,861,-1,1043,7485,5480,-1,7485,1043,1042,-1,7862,5186,5185,-1,5476,5186,7862,-1,7487,7486,5540,-1,7486,7487,5176,-1,7486,2781,2756,-1,2781,7486,3454,-1,2761,376,375,-1,376,2761,3095,-1,393,384,392,-1,393,385,384,-1,263,390,888,-1,263,391,390,-1,366,413,3544,-1,366,7366,413,-1,3100,3450,3099,-1,3449,3450,3100,-1,7487,7861,7365,-1,7861,7487,5184,-1,447,7488,332,-1,447,3457,7488,-1,324,3442,325,-1,324,318,3442,-1,3032,2985,3506,-1,2985,3032,313,-1,319,5234,3009,-1,319,324,5234,-1,3031,325,3029,-1,3031,7860,325,-1,257,2735,3150,-1,253,2735,257,-1,3138,3120,3123,-1,3138,297,3120,-1,3127,913,3125,-1,3127,1048,913,-1,3118,251,305,-1,3118,3143,251,-1,262,3135,260,-1,262,3439,3135,-1,1045,283,285,-1,1045,3464,283,-1,3438,4036,1046,-1,3438,3439,4036,-1,3139,3141,3140,-1,3141,3139,256,-1,2816,253,255,-1,2735,253,2816,-1,307,1048,3127,-1,1048,307,3122,-1,2834,3119,263,-1,2834,3441,3119,-1,3433,3432,2854,-1,3433,907,3432,-1,7859,5346,7395,-1,5346,7859,7439,-1,5311,5209,7448,-1,5311,5208,5209,-1,604,3431,3473,-1,3431,604,3060,-1,5115,5158,5101,-1,5115,5157,5158,-1,5097,7842,7569,-1,7842,5097,5137,-1,7493,7856,5159,-1,7491,7856,7493,-1,7494,7493,7500,-1,7492,7493,7494,-1,5161,7495,5160,-1,5161,7501,7495,-1,7497,7502,7496,-1,7497,5127,7502,-1,3155,3153,5130,-1,3153,3155,3154,-1,7498,3430,3154,-1,3430,7498,3428,-1,7500,7857,7494,-1,7500,7499,7857,-1,3164,7501,3161,-1,7495,7501,3164,-1,7496,7503,7858,-1,7496,7502,7503,-1,7517,5146,7858,-1,7517,7504,5146,-1,3428,4042,230,-1,4042,3428,7498,-1,7499,227,7857,-1,228,227,7499,-1,3161,3162,3164,-1,224,3162,3161,-1,7518,7858,7503,-1,7518,7517,7858,-1,5132,7508,5123,-1,5132,7507,7508,-1,5136,4904,4901,-1,5136,7507,4904,-1,4898,5139,7505,-1,5139,4898,7574,-1,5121,7497,5155,-1,5121,7509,7497,-1,5125,7508,5138,-1,5125,7509,7508,-1,5129,7506,5140,-1,5129,7490,7506,-1,5112,7491,7510,-1,7856,7491,5112,-1,7511,7506,5117,-1,7506,7511,7505,-1,5114,5107,7510,-1,5114,7512,5107,-1,4894,5109,7573,-1,4894,7512,5109,-1,4899,5111,7572,-1,4899,7511,5111,-1,5105,5102,5104,-1,5100,5102,5105,-1,7513,5135,5096,-1,5135,7513,5126,-1,5124,7513,5156,-1,5126,7513,5124,-1,5067,5087,5084,-1,5087,5067,5066,-1,7519,7515,7514,-1,7519,5062,7515,-1,3169,7520,5069,-1,7516,7520,3169,-1,5086,5089,5084,-1,5086,5088,5089,-1,5087,5083,5085,-1,5081,5083,5087,-1,5145,4042,5074,-1,231,4042,5145,-1,3158,5079,5078,-1,5079,3158,3166,-1,5077,227,226,-1,5077,5076,227,-1,225,3160,5075,-1,225,224,3160,-1,7855,5072,5092,-1,7855,5070,5072,-1,215,7522,5094,-1,4044,7522,215,-1,5064,7515,5062,-1,5064,4045,7515,-1,7524,3423,3425,-1,5023,3423,7524,-1,5028,7525,5026,-1,5028,5002,7525,-1,3184,7526,7854,-1,7526,3184,3183,-1,7537,7527,7536,-1,7527,7537,5012,-1,3173,5013,3171,-1,5013,3173,7539,-1,5006,7540,7851,-1,5006,206,7540,-1,3174,3178,3177,-1,3174,3187,3178,-1,7528,5010,3182,-1,5010,7528,7849,-1,3181,7529,5044,-1,7529,3181,3180,-1,7531,214,7530,-1,7531,4881,214,-1,7529,4878,7532,-1,7529,7523,4878,-1,5036,5017,5014,-1,5036,7533,5017,-1,5045,5038,7533,-1,5038,5045,7530,-1,7852,5027,7535,-1,7852,5025,5027,-1,5024,7853,5022,-1,5030,7853,5024,-1,5060,7853,5058,-1,5032,7853,5060,-1,7534,7852,7840,-1,5034,7852,7534,-1,5057,5035,5055,-1,5033,5035,5057,-1,7839,5021,7841,-1,7535,5021,7839,-1,7854,5040,5039,-1,7854,7526,5040,-1,7536,5042,5041,-1,7536,7527,5042,-1,7537,5047,3422,-1,7537,5052,5047,-1,7850,5048,5003,-1,7850,7851,5048,-1,5051,5005,3424,-1,5051,5011,5005,-1,7524,7850,5056,-1,5007,7850,7524,-1,3184,3176,3419,-1,3184,7538,3176,-1,7538,7854,5054,-1,7538,3184,7854,-1,3185,7539,3173,-1,7539,3185,4996,-1,7528,4994,7849,-1,7528,4995,4994,-1,3187,4998,3178,-1,3187,3186,4998,-1,206,4999,7540,-1,206,4050,4999,-1,7543,7542,7541,-1,7542,7543,4979,-1,4859,4983,4982,-1,143,4983,4859,-1,204,7543,4986,-1,7543,204,4972,-1,4968,4862,7544,-1,4860,4862,4968,-1,3416,7835,4973,-1,4638,7835,3416,-1,4659,4981,4657,-1,4981,4659,7548,-1,4978,7545,7544,-1,4978,7549,7545,-1,7545,7546,4970,-1,7545,7551,7546,-1,4974,3415,3189,-1,4974,7553,3415,-1,7548,4956,7547,-1,7548,4659,4956,-1,7549,7551,7545,-1,7549,4963,7551,-1,7551,4949,7546,-1,7551,7550,4949,-1,3192,7553,7552,-1,3415,7553,3192,-1,198,7555,7824,-1,7555,198,7554,-1,4946,202,7547,-1,202,4946,7556,-1,4954,4943,7557,-1,4954,7556,4943,-1,3194,4940,7550,-1,3194,196,4940,-1,4960,4937,7552,-1,4960,7558,4937,-1,7554,7559,4955,-1,7554,4936,7559,-1,4945,194,4935,-1,4945,7559,194,-1,191,4951,7557,-1,4951,191,189,-1,7560,4948,4933,-1,7558,4948,7560,-1,200,186,4054,-1,200,3196,186,-1,4928,197,7847,-1,4941,197,4928,-1,4930,7560,7848,-1,4939,7560,4930,-1,175,3200,176,-1,193,3200,175,-1,4923,7847,4056,-1,7847,4923,7562,-1,7848,4920,7563,-1,7848,4931,4920,-1,174,3201,175,-1,174,7846,3201,-1,7562,7845,4926,-1,7561,7845,7562,-1,4929,7564,7844,-1,7564,4929,7563,-1,181,7565,182,-1,7843,7565,181,-1,2948,4891,4900,-1,2948,2947,4891,-1,4893,5302,7567,-1,7454,5302,4893,-1,7570,5306,4906,-1,668,5306,7570,-1,4902,5303,7568,-1,5303,4902,7571,-1,7569,4908,7570,-1,4908,7569,7842,-1,4890,5134,5131,-1,4890,7571,5134,-1,4913,5106,7567,-1,4913,7572,5106,-1,4911,5103,4856,-1,4911,7573,5103,-1,7841,7836,7839,-1,4868,7836,7841,-1,7575,7458,5301,-1,7458,7575,7838,-1,7532,4875,7576,-1,4875,7532,4878,-1,7840,4871,7534,-1,7577,4871,7840,-1,7531,7838,7575,-1,7531,5046,7838,-1,7456,4883,7837,-1,5059,4883,7456,-1,7457,7836,7460,-1,7577,7836,7457,-1,5296,4984,3512,-1,4984,5296,7542,-1,4859,7459,4858,-1,4859,4985,7459,-1,4865,4977,7578,-1,4977,4865,4975,-1,7578,7835,4643,-1,7578,4977,7835,-1,4652,7618,4653,-1,7618,4652,7592,-1,4844,7620,4690,-1,7620,4844,172,-1,7589,7622,4686,-1,7622,7589,4843,-1,7594,7590,4849,-1,7590,7594,4841,-1,7593,4852,7592,-1,4852,7593,4839,-1,4836,7589,4851,-1,7589,4836,169,-1,3413,7594,3202,-1,7594,3413,4831,-1,3412,7593,3204,-1,7593,3412,4825,-1,4846,4822,173,-1,4846,4821,4822,-1,4822,4819,4835,-1,4822,4817,4819,-1,3411,3413,3203,-1,3413,3411,4815,-1,4648,4812,4646,-1,4648,4810,4812,-1,3208,4809,3206,-1,3208,3210,4809,-1,7595,4840,4837,-1,4840,7595,7597,-1,4803,4823,7597,-1,4823,4803,4802,-1,4799,3207,4833,-1,3207,4799,4798,-1,4793,4832,4829,-1,4832,4793,4795,-1,4828,3211,3209,-1,4828,4791,3211,-1,4806,4826,4824,-1,4826,4806,7598,-1,4785,7596,7598,-1,7596,4785,4784,-1,4820,4781,4818,-1,4820,4779,4781,-1,4777,4816,4814,-1,4816,4777,4776,-1,4813,4773,4811,-1,4813,4771,4773,-1,4789,4807,3212,-1,4807,4789,4805,-1,7582,4808,4805,-1,4808,7582,7587,-1,4801,7583,4804,-1,4801,7585,7583,-1,7581,4800,4797,-1,4800,7581,7580,-1,7584,4794,4796,-1,4794,7584,7586,-1,7610,4717,4714,-1,7610,7832,4717,-1,7830,7832,7610,-1,7830,7608,7832,-1,4711,7608,7830,-1,4711,7609,7608,-1,4713,7609,4711,-1,4713,4703,7609,-1,7611,4703,4713,-1,7611,4701,4703,-1,7829,4701,7611,-1,7829,7827,4701,-1,4709,7827,7829,-1,4707,7827,4709,-1,4707,7614,7827,-1,7612,7614,4707,-1,7612,4704,7614,-1,7612,4706,4704,-1,7612,7828,4706,-1,7630,3214,7600,-1,7630,7834,3214,-1,4754,4666,7628,-1,4666,4754,4752,-1,7629,7602,4665,-1,7629,4760,7602,-1,4748,7602,4747,-1,7599,7602,4748,-1,3215,7834,3216,-1,3214,7834,3215,-1,4768,4742,4741,-1,4768,4765,4742,-1,4750,4761,4763,-1,4761,4750,4759,-1,4759,164,4762,-1,4759,3218,164,-1,4758,161,3408,-1,4758,162,161,-1,4755,3223,4735,-1,4755,3409,3223,-1,4734,4152,4151,-1,4152,4734,4733,-1,4729,4740,4733,-1,4740,4729,4730,-1,157,3407,4749,-1,3407,157,154,-1,3224,4727,3225,-1,3224,3217,4727,-1,3229,4746,4743,-1,4746,3229,7603,-1,7603,4720,4732,-1,7603,4718,4720,-1,4721,4739,4736,-1,4739,4721,7604,-1,165,7833,166,-1,165,3226,7833,-1,4724,163,152,-1,4061,163,4724,-1,4725,3405,3231,-1,3405,4725,4710,-1,4062,7613,4708,-1,4062,4728,7613,-1,7833,3234,3403,-1,7833,4702,3234,-1,4715,7604,4721,-1,7604,4715,7831,-1,4720,7607,4731,-1,4720,4719,7607,-1,7832,7606,7831,-1,7606,7832,7608,-1,4719,7610,7607,-1,4719,7830,7610,-1,7829,4725,3232,-1,4725,7829,7611,-1,7828,7613,7605,-1,7613,7828,7612,-1,3234,7614,3235,-1,3234,7827,7614,-1,4688,5272,4691,-1,5272,4688,7619,-1,4684,5271,7615,-1,5271,4684,7621,-1,7617,7826,7466,-1,7826,7617,7825,-1,7618,7825,7617,-1,7825,7618,4853,-1,7620,4697,7619,-1,4697,7620,4850,-1,7622,4693,7621,-1,4693,7622,4848,-1,7470,4673,7469,-1,7470,7623,4673,-1,4669,5270,7624,-1,3494,5270,4669,-1,4682,7626,7623,-1,4682,4667,7626,-1,4679,7627,7624,-1,4679,4664,7627,-1,4766,150,7625,-1,150,4766,7628,-1,7626,7629,4675,-1,7626,4764,7629,-1,7627,4770,4672,-1,7627,4769,4770,-1,145,7631,4641,-1,145,147,7631,-1,3402,3190,3236,-1,3188,3190,3402,-1,7824,146,3237,-1,7824,7555,146,-1,7820,7632,4635,-1,7820,7823,7632,-1,4631,4649,4629,-1,4631,7633,4649,-1,4644,7823,7634,-1,7823,4644,7632,-1,4650,3410,7634,-1,4650,4827,3410,-1,589,7636,7635,-1,7474,7636,589,-1,3240,7822,3238,-1,3240,4640,7822,-1,7631,7635,7636,-1,7631,4661,7635,-1,5258,4628,5256,-1,5258,7637,4628,-1,5259,4634,7821,-1,5259,4632,4634,-1,4696,7591,7637,-1,4696,4847,7591,-1,4627,7820,4625,-1,4627,4655,7820,-1,8006,4552,7816,-1,8006,4553,4552,-1,7814,3393,4546,-1,4549,3393,7814,-1,4549,3263,3393,-1,4551,3263,4549,-1,4551,7675,3263,-1,7673,7675,4551,-1,7673,4557,7675,-1,7673,4555,4557,-1,7815,4555,7673,-1,7671,4555,7815,-1,7671,7670,4555,-1,4553,7670,7671,-1,7670,4553,8006,-1,3330,4607,4606,-1,3330,3331,4607,-1,4267,4602,7794,-1,4267,4603,4602,-1,7645,4271,4265,-1,4271,7645,4609,-1,4599,7795,4094,-1,7795,4599,7651,-1,4597,7645,4618,-1,7645,4597,4596,-1,4623,4595,4594,-1,4623,4621,4595,-1,4620,4593,4619,-1,4620,4592,4593,-1,7650,4618,4616,-1,4618,7650,4597,-1,3243,4613,7651,-1,4613,3243,7819,-1,3245,7650,4604,-1,7650,3245,3249,-1,4612,3399,4610,-1,4612,7652,3399,-1,4608,4588,3392,-1,4608,4605,4588,-1,3244,7819,3243,-1,7819,3244,7658,-1,135,3400,4600,-1,3400,135,134,-1,132,3249,3245,-1,3249,132,3250,-1,7652,3252,3399,-1,7652,7657,3252,-1,7658,3254,124,-1,7658,3244,3254,-1,3266,7660,3267,-1,3266,4136,7660,-1,7657,3396,3252,-1,7657,7659,3396,-1,3267,3259,3258,-1,3267,7660,3259,-1,7817,7662,7661,-1,7817,7818,7662,-1,7659,7663,3396,-1,7659,7813,7663,-1,117,4543,4527,-1,117,3253,4543,-1,7818,4548,7662,-1,7818,7672,4548,-1,4583,3260,3259,-1,4583,4547,3260,-1,125,3261,3394,-1,125,129,3261,-1,7665,7818,4582,-1,7818,7665,7672,-1,3391,7669,7777,-1,7666,7669,3391,-1,7668,113,7667,-1,7668,4567,113,-1,4066,4534,4568,-1,4534,4066,7664,-1,7647,7668,4571,-1,7668,7647,7649,-1,7666,7653,7669,-1,7666,7656,7653,-1,4620,3360,4570,-1,3360,4620,3356,-1,4592,4570,7667,-1,4570,4592,4620,-1,3395,7816,3261,-1,3395,8006,7816,-1,7671,7665,4573,-1,7665,7671,7815,-1,4550,7814,4576,-1,4550,4549,7814,-1,7675,4554,7674,-1,4554,7675,4557,-1,4528,7664,4526,-1,7664,4528,7641,-1,7813,7643,7663,-1,7813,7642,7643,-1,7640,4069,120,-1,4069,7640,4539,-1,3392,7646,4608,-1,141,7646,3392,-1,3266,7777,7776,-1,3391,7777,3266,-1,7655,135,4600,-1,135,7655,7654,-1,4574,8006,3395,-1,8006,4574,7670,-1,7711,88,87,-1,7801,88,7711,-1,7801,85,88,-1,7804,85,7801,-1,7804,3300,85,-1,7804,3383,3300,-1,7804,4431,3383,-1,4082,4431,7804,-1,4082,7810,4431,-1,82,7810,4082,-1,82,3302,7810,-1,82,3297,3302,-1,3299,3297,82,-1,3299,3384,3297,-1,4519,7677,7792,-1,7677,4519,7678,-1,3310,7755,3390,-1,3309,7755,3310,-1,7713,4387,7809,-1,3303,7715,3304,-1,3303,4423,7715,-1,3305,4423,3303,-1,3305,4426,4423,-1,3305,7808,4426,-1,3305,7716,7808,-1,3305,4430,7716,-1,3305,4428,4430,-1,4387,4428,3305,-1,4387,7713,4428,-1,8007,4414,28,-1,8007,7717,4414,-1,7686,4522,7676,-1,4522,7686,7679,-1,7687,7681,4242,-1,7681,7687,7680,-1,3336,4411,4234,-1,3336,4398,4411,-1,4075,4518,7679,-1,4518,4075,4072,-1,110,7688,111,-1,110,7685,7688,-1,4416,4414,7717,-1,4414,4416,4415,-1,4500,7679,7686,-1,7679,4500,4075,-1,4491,7680,7687,-1,7680,4491,4490,-1,4398,4487,4411,-1,4398,4397,4487,-1,4495,7682,4239,-1,7682,4495,4494,-1,7685,7689,7688,-1,7685,7812,7689,-1,4478,4504,4476,-1,4502,4504,4478,-1,4474,4510,4507,-1,4510,4474,4473,-1,3274,4470,4469,-1,3274,4505,4470,-1,4467,3278,7690,-1,3278,4467,3276,-1,3279,4074,4073,-1,4074,3279,4466,-1,7812,7692,7689,-1,7812,7696,7692,-1,4488,4408,4486,-1,4488,4463,4408,-1,4461,4496,4493,-1,4496,4461,4460,-1,4465,4492,4489,-1,4492,4465,4464,-1,7692,4457,4480,-1,7692,4455,4457,-1,7694,3388,3277,-1,3388,7694,3280,-1,4484,7697,4482,-1,4484,4458,7697,-1,4471,99,98,-1,4471,4468,99,-1,4479,4448,4477,-1,4479,4449,4448,-1,7811,4475,4472,-1,4475,7811,7699,-1,7697,92,7695,-1,7697,93,92,-1,3282,103,102,-1,103,3282,4421,-1,7703,3280,7694,-1,3280,7703,4078,-1,7704,7699,7811,-1,7699,7704,7701,-1,4402,4440,4410,-1,4402,4401,4440,-1,4444,4462,4459,-1,4462,4444,4443,-1,4456,3284,3283,-1,4456,4438,3284,-1,3293,4450,4447,-1,4450,3293,7708,-1,7705,7701,7704,-1,7701,7705,7710,-1,7706,4077,100,-1,4077,7706,3292,-1,80,7719,4422,-1,7719,80,7803,-1,97,84,83,-1,97,96,84,-1,94,3301,4079,-1,94,3287,3301,-1,3298,4419,3288,-1,4419,3298,81,-1,7707,3293,3382,-1,7708,3293,7707,-1,7807,7710,7705,-1,7710,7807,7709,-1,7714,3292,7706,-1,3292,7714,3385,-1,4082,7803,80,-1,7803,4082,7804,-1,3287,3302,3301,-1,3287,7810,3302,-1,7809,7714,7713,-1,3385,7714,7809,-1,7707,3304,7715,-1,7707,3382,3304,-1,7808,7709,7807,-1,7709,7808,7716,-1,103,7806,101,-1,7700,7806,103,-1,4083,8007,76,-1,7717,8007,4083,-1,4497,7802,7718,-1,4497,7805,7802,-1,7719,7800,7720,-1,7719,7803,7800,-1,4487,7722,4394,-1,4487,4486,7722,-1,4440,7723,4391,-1,4440,4437,7723,-1,7721,3307,4436,-1,3307,7721,3381,-1,4384,4463,4488,-1,4463,4384,4386,-1,76,4231,3380,-1,76,8007,4231,-1,7791,4226,4223,-1,7677,4226,7791,-1,7722,7693,7691,-1,7722,4409,7693,-1,7723,3295,3294,-1,7723,4406,3295,-1,3389,4396,3273,-1,4399,4396,3389,-1,7702,4400,7698,-1,4403,4400,7702,-1,7690,7802,4467,-1,7718,7802,7690,-1,91,7800,7712,-1,7720,7800,91,-1,4209,7730,4365,-1,4209,4208,7730,-1,7797,7730,7765,-1,7730,7797,7729,-1,4353,4184,4179,-1,4184,4353,4352,-1,7731,4349,4183,-1,7731,4348,4349,-1,3313,4363,7729,-1,4363,3313,4335,-1,7787,4334,7732,-1,7787,4332,4334,-1,4331,3355,4329,-1,7733,3355,4331,-1,3314,7729,7797,-1,7729,3314,3313,-1,4345,4084,72,-1,4084,4345,7734,-1,4341,4360,4362,-1,4360,4341,7735,-1,69,4337,61,-1,69,68,4337,-1,52,4301,53,-1,4354,4301,52,-1,4321,4351,7734,-1,4351,4321,4320,-1,4316,4350,7735,-1,4350,4316,4318,-1,7737,4307,7742,-1,4307,7737,50,-1,4358,3378,4359,-1,4358,3316,3378,-1,4357,4323,4356,-1,4357,7738,4323,-1,46,3379,3315,-1,3379,46,4284,-1,4088,3317,3316,-1,4088,4093,3317,-1,4333,7739,7738,-1,4333,4281,7739,-1,56,4330,4288,-1,55,4330,56,-1,7740,4347,4344,-1,4347,7740,7798,-1,3324,4343,4340,-1,4343,3324,4292,-1,4339,4293,4295,-1,4339,4336,4293,-1,37,4172,38,-1,4313,4172,37,-1,4315,4299,7741,-1,4315,4297,4299,-1,4092,7742,43,-1,7737,7742,4092,-1,3323,4305,4175,-1,3322,4305,3323,-1,54,7799,4090,-1,54,53,7799,-1,7724,3321,4322,-1,3321,7724,3319,-1,4319,7725,4317,-1,4319,7726,7725,-1,7728,7798,7740,-1,7798,7728,7727,-1,4375,3376,56,-1,3376,4375,3377,-1,3311,7766,4201,-1,38,7766,3311,-1,4310,7797,4308,-1,4310,3314,7797,-1,7736,4369,51,-1,7736,4372,4369,-1,4370,3318,3317,-1,3318,4370,4371,-1,7739,4374,4325,-1,7739,4373,4374,-1,31,852,29,-1,852,31,32,-1,7879,1,3371,-1,7879,3,1,-1,7744,5427,7743,-1,5428,5427,7744,-1,4272,3373,5426,-1,3373,4272,3328,-1,3328,4622,3329,-1,3328,7796,4622,-1,4276,7795,4615,-1,4276,4275,7795,-1,7794,7744,7743,-1,7744,7794,4617,-1,7749,7745,7748,-1,7749,7747,7745,-1,7748,31,30,-1,31,7748,4257,-1,7746,4261,7745,-1,4259,4261,7746,-1,4229,7750,4245,-1,7750,4229,4228,-1,4223,7411,7791,-1,5424,7411,4223,-1,4096,3351,7413,-1,3351,4096,3352,-1,3333,4216,3334,-1,3333,5422,4216,-1,3344,3348,3345,-1,3344,7751,3348,-1,7413,4220,5423,-1,7413,3351,4220,-1,4230,4256,4228,-1,4256,4230,4524,-1,7683,7752,7684,-1,4215,7752,7683,-1,7754,7681,4517,-1,7754,15,7681,-1,4231,28,27,-1,4231,8007,28,-1,4241,4509,4508,-1,4241,7683,4509,-1,3346,4240,22,-1,7753,4240,3346,-1,3349,25,3335,-1,3349,3347,25,-1,7754,3348,4247,-1,7754,23,3348,-1,3337,3346,3350,-1,3337,7753,3346,-1,3369,3339,20,-1,26,3339,3369,-1,4523,7790,4255,-1,4523,7792,7790,-1,4253,3309,3370,-1,7755,3309,4253,-1,19,3308,3352,-1,79,3308,19,-1,4243,4248,4250,-1,4243,7752,4248,-1,4203,4192,5399,-1,4203,4191,4192,-1,4168,7427,4167,-1,7427,4168,4189,-1,7757,4367,4366,-1,7757,7421,4367,-1,5403,7758,5401,-1,5403,7761,7758,-1,4181,7420,7789,-1,7420,4181,4182,-1,7759,7416,7423,-1,7416,7759,7788,-1,4186,7419,7760,-1,7419,4186,4185,-1,7758,4176,4204,-1,7758,7762,4176,-1,4213,4173,4211,-1,4213,7764,4173,-1,6,4206,4205,-1,4206,6,5,-1,4196,7731,4194,-1,4196,4361,7731,-1,67,4201,4199,-1,4201,67,3311,-1,64,7788,7759,-1,7788,64,71,-1,7763,7732,7762,-1,7763,7787,7732,-1,7733,3353,3355,-1,7764,3353,7733,-1,7766,829,830,-1,4169,829,7766,-1,4189,7786,7767,-1,4189,4190,7786,-1,7768,2876,2875,-1,4166,2876,7768,-1,7756,2872,7767,-1,2872,7756,2873,-1,4116,4158,7770,-1,7769,4158,4116,-1,4161,4155,7771,-1,4111,4155,4161,-1,4767,4150,4765,-1,7770,4150,4767,-1,4745,4157,7771,-1,4745,4744,4157,-1,4144,4103,4143,-1,4103,4144,4101,-1,4147,7781,4105,-1,4147,7774,7781,-1,7774,7775,7773,-1,7774,4141,7775,-1,4149,7776,4129,-1,4149,4137,7776,-1,7775,4133,4145,-1,7775,4131,4133,-1,4142,7661,4140,-1,4142,7817,7661,-1,4138,7660,4136,-1,4138,4584,7660,-1,4671,3027,3025,-1,4671,7783,3027,-1,3365,7785,7778,-1,3365,3364,7785,-1,7779,7784,5386,-1,7779,4118,7784,-1,4115,3365,4113,-1,4115,3362,3365,-1,4162,7779,4127,-1,4162,7769,7779,-1,4670,7783,4671,-1,4670,7780,7783,-1,7601,4115,4112,-1,7601,4159,4115,-1,7770,4119,4116,-1,7770,4767,4119,-1,7782,803,4106,-1,803,7782,804,-1,7434,3,7879,-1,7434,4102,3,-1,7782,7772,4108,-1,7782,7781,7772,-1,4099,4259,0,-1,4259,4099,4262,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='mand_Coord',point=[(.68843,54.60526,2.17363),(.67453,54.60828,2.18283),(.69643,54.54138,2.19492),(.67174,54.60624,2.21248),(.6827,54.5388,2.22105),(1.01094,54.68284,1.57054),(1.04107,54.68197,1.57126),(1.03027,54.60926,1.54281),(.84995,54.82616,1.42033),(.8518,54.82425,1.44031),(.87215,54.77235,1.42217),(1.08093,54.65481,1.87389),(1.0899,54.69421,1.87456),(1.09697,54.70075,1.84229),(.98643,54.69555,1.65315),(1.03714,54.70241,1.67572),(1.03481,54.73355,1.68937),(.81014,54.67696,1.78374),(.81066,54.67764,1.78031),(.7857,54.68302,1.77679),(1.09198,54.69954,1.84087),(1.09243,54.70133,1.83132),(1.05694,54.69247,1.8283),(1.09069,54.68996,1.76014),(1.09148,54.64887,1.73883),(1.08024,54.64245,1.75158),(1.05527,54.65727,1.83638),(.98169,54.65801,1.81704),(.98272,54.61783,1.82122),(.95843,54.70048,2.2183),(.96795,54.64255,2.20367),(.96186,54.64084,2.22098),(.95137,54.63808,2.24744),(.94405,54.57071,2.23971),(1.04569,54.51706,1.41628),(1.03932,54.51297,1.41366),(1.03795,54.51217,1.4183),(1.06071,54.64354,1.41841),(1.07259,54.70649,1.44467),(1.06869,54.64575,1.40926),(.97915,54.56048,1.31598),(.98419,54.55405,1.32097),(.98544,54.55386,1.32018),(.96352,54.57527,1.39359),(.95315,54.57187,1.40453),(.97683,54.5375,1.39348),(1.04501,54.52034,1.3998),(1.0395,54.52124,1.39554),(1.03969,54.51533,1.40044),(1.04066,54.53485,1.39531),(1.02235,54.5354,1.38698),(1.03336,54.52241,1.38998),(.95481,54.57419,1.3369),(.95753,54.57159,1.3474),(.97364,54.55336,1.33991),(.97562,54.53492,1.40561),(.99895,54.51974,1.39815),(1.03601,54.55216,1.48101),(1.04618,54.55328,1.4641),(1.04596,54.52622,1.43688),(1.04898,54.5899,1.38046),(1.04897,54.59089,1.37126),(1.03735,54.56726,1.35919),(1.04359,54.60921,1.53076),(.90143,54.72609,1.36055),(.89039,54.72212,1.38652),(.91731,54.65994,1.36584),(1.08733,54.71092,1.42521),(1.05794,54.65193,1.3693),(1.06685,54.64833,1.39651),(.91953,54.72899,1.3386),(.91208,54.72819,1.34608),(.92974,54.66696,1.32547),(1.06258,54.68371,1.55835),(.80053,54.64506,1.79098),(.81065,54.60798,1.79772),(.81948,54.60973,1.79656),(.81968,54.65997,1.7496),(.83136,54.61779,1.71237),(.80409,54.66179,1.74448),(.96814,54.38081,1.75275),(.94868,54.37954,1.75053),(.96301,54.36995,1.7535),(1.00172,54.36594,1.79809),(1.01271,54.36659,1.80001),(1.00362,54.36053,1.78531),(1.02034,54.36941,1.79649),(1.01275,54.36388,1.77985),(1.00964,54.36182,1.78385),(1.02697,54.40616,1.79721),(1.02283,54.41001,1.78679),(1.02305,54.39622,1.78481),(.92882,54.38359,1.79353),(.95124,54.385,1.8023),(.95747,54.37565,1.79368),(1.00452,54.38941,1.82013),(1.01446,54.38035,1.81068),(1.00482,54.37911,1.80992),(1.09154,54.46469,1.66797),(1.08012,54.46702,1.64381),(1.08263,54.44798,1.63965),(.88262,54.43399,1.76085),(.88296,54.40933,1.75824),(.90422,54.41621,1.75584),(.86742,54.46102,1.76969),(.85203,54.45635,1.77689),(.86951,54.42811,1.76427),(.83303,54.49026,1.7913),(.85354,54.45085,1.78655),(.80487,54.58112,1.86986),(.85767,54.50711,1.88213),(.83317,54.51799,1.85691),(.78347,54.36028,2.05003),(.80002,54.35778,2.06347),(.82417,54.31617,2.03699),(.92201,54.32656,2.05124),(.93248,54.32857,2.04363),(.91796,54.30433,2.02386),(.87533,54.31355,1.95739),(.85971,54.31466,1.95906),(.86944,54.29496,1.96631),(.82871,54.30261,2.00152),(.85712,54.28695,1.99447),(.8525,54.2876,1.98969),(.90892,54.31602,2.23848),(.89845,54.27375,2.20392),(.8941,54.27405,2.21657),(.91631,54.31952,2.20553),(.89441,54.27332,2.18026),(.89837,54.27598,2.19139),(.87018,54.33676,1.95912),(.88869,54.31529,1.95829),(.82908,54.33048,1.96661),(.84278,54.31347,1.96649),(.92892,54.37074,2.22639),(.92445,54.37232,2.21149),(.91073,54.31843,2.19339),(.95914,54.38519,2.04168),(.93505,54.33661,1.99016),(.93864,54.33279,2.01088),(.88853,54.32019,2.05644),(.93033,54.37084,2.08662),(.47355,54.55244,2.92238),(.47936,54.54693,2.95392),(.49165,54.58672,2.96499),(.3585,54.43191,2.78697),(.38136,54.37207,2.81078),(.38934,54.4251,2.81083),(.75723,54.61545,2.59508),(.77065,54.61526,2.58362),(.76473,54.55892,2.56763),(.67034,54.2231,2.3906),(.66629,54.2287,2.38979),(.66602,54.22736,2.40149),(.69422,54.23894,2.44208),(.69908,54.22208,2.42571),(.69269,54.22247,2.42843),(.70543,54.23921,2.44109),(.66665,54.31357,2.36147),(.65693,54.31442,2.35954),(.67207,54.25499,2.35914),(.61749,54.30872,2.40141),(.61988,54.30535,2.41833),(.64981,54.24835,2.39584),(.66171,54.29556,2.46405),(.68245,54.24065,2.43994),(.67308,54.24188,2.43282),(.66316,54.38967,2.37003),(.63647,54.34204,2.77617),(.65168,54.34298,2.75941),(.63516,54.28316,2.74256),(.66037,54.41264,2.70989),(.63776,54.41546,2.68663),(.63251,54.35065,2.6794),(.2945,54.03707,2.85345),(.29823,54.03597,2.85443),(.29807,54.03605,2.85316),(.31841,54.04923,2.82899),(.31111,54.0571,2.81728),(.29263,54.03873,2.83274),(.29247,54.07323,2.80428),(.27905,54.05369,2.82176),(.28582,54.04584,2.82547),(.28693,54.07803,2.80414),(.28132,54.08264,2.80805),(.27148,54.06315,2.81937),(.29529,54.13451,2.80381),(.27837,54.08466,2.81542),(.33447,54.10345,2.90628),(.34936,54.09707,2.8968),(.31155,54.05149,2.871),(.35999,54.09333,2.88279),(.36127,54.09452,2.87113),(.32179,54.04482,2.85753),(.3464,54.10833,2.81958),(.30155,54.06501,2.81011),(.33997,54.17656,2.92911),(.32265,54.11017,2.90188),(.33621,54.25573,2.80289),(.31385,54.25881,2.79401),(.30976,54.19773,2.80172),(.43469,54.34085,2.96974),(.4232,54.285,2.93055),(.4198,54.28296,2.95129),(.4424,54.39242,2.98133),(.44301,54.34273,2.94858),(.196,54.22068,2.94246),(.20108,54.21852,2.94867),(.20107,54.21078,2.93194),(.20659,54.29637,2.88667),(.20073,54.29313,2.90897),(.19817,54.25634,2.90745),(.24321,54.43428,2.87344),(.26524,54.42745,2.8874),(.27035,54.48211,2.90326),(.14419,54.20292,2.93797),(.1386,54.19661,2.93847),(.14395,54.19415,2.94444),(.14357,54.18552,2.97057),(.14284,54.18465,2.96999),(.14178,54.18577,2.97986),(.14208,54.18393,2.96856),(.1383,54.18289,2.97721),(.1252,54.22012,2.92174),(.1121,54.23487,2.92739),(.11858,54.21428,2.92903),(.11321,54.19612,2.97149),(.09936,54.21661,2.98176),(.09843,54.21404,2.99466),(.12843,54.19685,3.0028),(.12028,54.21281,3.01908),(.13315,54.20015,3.00175),(.13584,54.21316,2.92642),(.13241,54.2246,2.919),(.13011,54.21006,2.92679),(.12287,54.18893,2.97587),(.13621,54.18187,2.97313),(.13461,54.18161,2.96836),(.12999,54.18873,2.99137),(1.63935,55.30405,.53857),(1.66101,55.34772,.45398),(1.6493,55.29853,.48823),(.03455,53.56842,2.69145),(0,53.59731,2.67477),(.06107,53.59295,2.6719),(1.63779,55.12704,.46924),(1.62557,55.07634,.50526),(1.62736,55.13229,.48201),(1.64352,55.2863,.60771),(1.61657,55.31677,.65731),(1.57494,54.76858,.69138),(1.57233,54.893,.72955),(1.58783,54.9421,.65368),(1.58548,55.09396,.67869),(1.57106,55.00944,.74952),(1.55243,55.02058,.792),(1.61826,55.07731,.54982),(1.61854,55.16729,.56206),(1.57137,54.96573,.7172),(1.59799,54.99099,.61073),(1.58826,54.41334,.89514),(1.60948,54.48268,.79967),(1.60663,54.48775,.82551),(1.49502,54.30485,.94198),(1.5255,54.39211,.86018),(1.50185,54.30782,.92861),(1.56336,54.37269,.88077),(1.53005,54.31156,.93121),(1.51893,54.30291,.9213),(1.57303,54.34598,.97009),(1.57281,54.38533,.96418),(1.57649,54.38578,.84143),(1.59464,54.44627,.76591),(1.60153,54.44999,.77542),(1.62872,54.57917,.75635),(1.63834,54.66041,.64723),(1.64095,54.6768,.7121),(1.57141,54.5303,.96438),(1.54528,54.41691,1.01764),(1.56178,54.41024,.9633),(1.53381,54.46472,1.08261),(1.54104,54.42617,1.06206),(1.53638,54.44362,1.04282),(1.65518,54.88943,.67667),(1.67609,55.09764,.55168),(1.64338,54.90003,.69739),(1.62226,54.59506,.6667),(1.59512,54.57027,.69963),(1.61057,54.65709,.64716),(1.61306,54.53641,.70047),(1.61301,54.49507,.74001),(1.60935,54.49151,.72996),(1.60884,54.66577,.64219),(1.63139,54.66015,.63657),(1.57536,54.45144,.77331),(1.57882,54.47236,.74792),(1.60676,54.45892,.7348),(1.53281,54.46599,.86278),(1.54238,54.38701,.8429),(1.53752,54.38122,.85578),(1.5924,55.2391,.75008),(1.54714,55.05936,.88239),(1.53903,55.08518,.95015),(1.57666,54.64069,.70764),(1.57444,54.5829,.71532),(1.5438,54.84387,.80152),(1.57477,54.66828,.70731),(1.57894,54.59098,.73072),(1.57826,54.64834,.73169),(.45761,54.49308,3.08318),(.46168,54.53029,3.08774),(.37306,54.52721,3.11173),(.19244,54.54518,3.1799),(.20315,54.50491,3.17567),(.20875,54.54429,3.18185),(.35878,54.55304,3.12645),(.35897,54.52981,3.11299),(.58343,54.58348,2.95336),(.58182,54.54921,2.93811),(.60398,54.55285,2.92635),(.34959,54.53201,3.11777),(.55566,54.15412,2.86387),(.55361,54.00966,2.814),(.5729,54.15538,2.85611),(.5902,54.50219,2.92781),(.56088,54.49753,2.95672),(.55214,54.39549,2.95154),(.15355,54.15772,2.977),(.14349,54.28321,3.06525),(.12692,54.15538,2.98663),(.18431,54.54533,3.18275),(.1911,54.5644,3.18668),(1.54213,56.03928,1.47695),(1.53992,56.00908,1.44654),(1.57085,56.05198,1.32316),(1.38269,55.61613,1.40905),(1.39673,55.6783,1.44323),(1.39621,55.68489,1.42626),(1.45018,56.00584,1.50002),(1.44695,56.12153,1.53068),(1.45293,56.12789,1.51476),(1.41902,55.80709,1.3753),(1.41438,55.80084,1.39098),(1.43924,55.88941,1.44866),(1.41213,55.77629,1.45778),(1.41252,55.77022,1.47491),(1.42663,55.87168,1.50172),(1.51188,55.10295,1.05355),(1.46645,55.16514,1.04436),(1.53723,55.13732,1.06319),(1.6209,55.23632,.80309),(1.64165,55.32761,.70904),(1.60624,55.24041,.78001),(1.39708,55.56385,1.53496),(1.40924,55.63723,1.56004),(1.40691,55.64156,1.54727),(1.42691,55.73153,1.58953),(1.45808,56.08193,1.65744),(1.45365,56.08559,1.6439),(1.44581,55.96458,1.61942),(1.42022,55.73703,1.57242),(1.43338,55.83555,1.60837),(1.47112,55.844,1.29076),(1.47183,55.9316,1.35357),(1.48233,55.84884,1.28499),(1.63727,55.9725,.43873),(1.61975,55.96968,.42464),(1.61798,55.90822,.54602),(1.62274,55.86883,.69492),(1.61105,55.85085,.67788),(1.59042,55.78585,.81394),(1.48164,54.20045,1.14125),(1.50947,54.23676,1.15684),(1.40511,54.12661,1.36224),(1.61898,54.56793,.70882),(1.71965,55.83728,.09801),(1.70747,55.8311,.09034),(1.68257,55.93915,.03676),(1.61172,54.46718,.75216),(1.61622,54.56302,.69765),(1.61981,54.89601,.57716),(1.60917,54.67791,.64618),(1.63853,54.89279,.57016),(1.6486,55.12849,.47712),(1.68395,55.45626,.31633),(1.67901,55.46341,.32832),(1.70282,55.58667,.25346),(1.66431,55.93869,.04063),(1.67058,55.95067,.02674),(1.46812,54.18884,1.13609),(1.44742,54.18037,1.14702),(1.4967,54.30429,.94245),(1.66051,55.30599,.38767),(1.65488,55.31704,.39972),(1.632,55.86584,.26522),(1.66271,55.74585,.39436),(1.65086,55.76251,.41136),(1.63022,55.26243,.6643),(1.46833,55.34117,1.04035),(1.52336,55.43699,.94247),(1.54741,55.42209,.92145),(1.95612,56.25331,.28271),(1.92289,56.27883,.30991),(1.92023,56.24019,.328),(1.90005,56.30211,.27491),(1.87493,56.30386,.24945),(1.86473,56.2514,.28378),(1.95381,56.17896,.25317),(1.9423,56.21487,.29804),(1.90963,56.1273,.31477),(1.90456,56.30737,.27904),(1.91663,56.2772,.30994),(1.58096,55.98882,.13386),(1.58481,56.0025,.24347),(1.58118,56.06248,.17123),(1.54075,56.03941,.06917),(1.58993,55.96934,.0929),(1.5809,55.98595,.11185),(1.58214,56.06729,.19254),(1.57646,56.13708,.13865),(1.56552,56.21642,.08986),(1.53618,56.29558,.0646),(1.55984,56.20819,.0807),(1.51147,56.38047,.07167),(1.52405,56.38175,.08026),(1.50304,56.46309,.10879),(1.49163,56.10207,.04782),(1.49821,56.11329,.05652),(1.43668,56.20075,.02739),(1.42848,56.44805,.08034),(1.42548,56.45808,.08109),(1.3545,56.41788,.05192),(1.89533,56.12857,.32299),(1.83842,56.04051,.33255),(1.49822,56.47514,.10661),(1.49349,56.46258,.10533),(1.58506,56.38595,1.5279),(1.58725,56.41107,1.60971),(1.5848,56.39992,1.60336),(1.54774,56.36897,1.64174),(1.5279,56.30771,1.66073),(1.55469,56.31401,1.56386),(1.73464,55.95814,.46273),(1.74879,55.9509,.4264),(1.7722,55.99213,.40274),(1.57021,56.02325,1.3184),(1.5781,56.09172,1.29428),(1.5713,56.08488,1.33533),(1.34299,54.8504,1.74286),(1.37123,54.96586,1.69857),(1.36499,54.97223,1.71226),(.49831,53.60706,2.45078),(.4079,53.60623,2.52882),(.40582,53.61138,2.52383),(.06398,53.58248,2.68041),(.04245,53.56167,2.69527),(0,53.46942,2.77165),(.0312,53.49874,2.74343),(.06514,53.45623,2.76978),(.05534,53.62228,2.65896),(.00992,53.95084,2.58484),(.00894,53.95177,2.59392),(.04746,53.95833,2.58037),(.03332,53.84438,2.56537),(.06133,53.86447,2.56064),(.06764,53.85571,2.56778),(.6872,54.04661,2.58042),(.70911,54.01364,2.57433),(.71698,54.04757,2.54716),(.16398,53.85633,2.9671),(.22891,53.75143,2.99104),(.22809,53.86302,2.9269),(.34315,53.45376,2.87581),(.28674,53.4481,2.95354),(.24756,53.42955,2.89354),(.23938,53.58834,3.06609),(.22789,53.67029,3.0376),(.16745,53.66421,3.04195),(.39161,53.50008,2.95079),(.42136,53.47627,2.83537),(.61869,54.71434,2.34592),(.59653,54.68111,2.34174),(.59839,54.69402,2.37159),(.64793,54.73141,2.35267),(.62037,54.7167,2.35943),(.63405,54.73289,2.39386),(.60308,54.59482,2.25153),(.59448,54.58483,2.30133),(.58832,54.57768,2.33703),(.58225,54.57039,2.37268),(.58066,54.61203,2.38447),(.58249,54.61263,2.37349),(.51966,54.66066,2.55761),(.50838,54.61262,2.55852),(.51519,54.65881,2.56636),(.27668,54.68939,2.90351),(.2639,54.65783,2.85664),(.23877,54.65443,2.87212),(.4321,54.70111,2.78146),(.39989,54.69264,2.75059),(.38572,54.69287,2.76525),(.43529,54.66159,2.66191),(.46821,54.65884,2.63291),(.43256,54.60894,2.64005),(.30301,54.46301,2.76653),(.23976,54.45287,2.81674),(.24058,54.59671,2.85125),(.30867,54.66072,2.78963),(.29997,54.60099,2.7834),(.28886,54.66044,2.81437),(.54671,54.68299,2.46464),(.53909,54.6128,2.48632),(.53714,54.67681,2.49892),(.32967,54.60313,2.74964),(.70273,54.04436,2.70329),(.72529,53.92263,2.65246),(.77819,54.01976,2.62232),(.74303,54.67696,2.69759),(.71763,54.69229,2.68675),(.69946,54.67887,2.74165),(.69739,54.6268,2.8662),(.71659,54.52872,2.84659),(.72055,54.62775,2.83033),(.56182,54.64085,2.94996),(.54841,54.59224,2.99956),(.58472,54.60211,2.95567),(.46314,54.56774,3.08669),(.39806,54.56515,3.11466),(.21779,54.58047,3.18607),(.26202,54.53815,3.18338),(.36809,54.60001,3.13208),(.35499,54.60495,3.13773),(.36204,54.56253,3.13443),(.49814,54.27334,2.96465),(.47709,54.14896,2.89652),(0,54.14339,3.00277),(.0519,54.14896,3.00069),(.05474,54.28674,3.08304),(.04451,54.39635,3.14662),(0,54.48362,3.1877),(0,54.40497,3.13702),(.20456,54.1631,2.95552),(.2547,54.15939,2.94913),(.22437,54.27931,3.04947),(.60921,54.73057,2.40427),(.58852,54.61181,2.33706),(.57374,54.72888,2.43833),(.59187,54.72548,2.42026),(.58939,54.72948,2.41628),(.57793,54.68785,2.39704),(.57706,54.41952,2.32147),(.56667,54.61297,2.42196),(.56014,54.68693,2.42939),(.45009,53.8146,2.83847),(.54143,53.86178,2.77362),(.44246,53.85855,2.82745),(.51384,54.38425,3.0124),(.55103,54.28023,2.9249),(.73891,54.63737,2.77417),(.58013,54.72637,2.54366),(.56293,54.72609,2.50021),(.53499,54.68341,2.55974),(.49863,54.66208,2.60044),(.52979,54.69909,2.63382),(.5563,54.70166,2.63567),(.49531,54.69969,2.64451),(.51424,54.65003,2.95834),(.54365,54.66917,2.90338),(.36506,54.69586,2.80164),(.5304,54.69723,2.63779),(.55482,54.69394,2.6411),(.49599,54.69903,2.64709),(.46155,54.68541,2.70499),(.46874,54.69345,2.67491),(.45634,54.68927,2.7059),(.62404,54.65946,2.86938),(.58901,54.66289,2.85796),(.58396,54.66818,2.86324),(.46301,54.68757,2.74274),(.0752,53.83042,2.57119),(.1497,53.85274,2.58128),(.16534,53.74279,2.60495),(.32715,54.6929,2.824),(.32403,54.696,2.8178),(.58583,54.64945,2.92465),(.62058,54.62635,2.91584),(.51159,54.6823,2.8719),(.49178,54.65146,2.92448),(.47201,54.65786,2.89399),(.46463,54.62101,2.8878),(.23115,53.74549,2.59544),(.30354,53.89917,2.55292),(.40144,53.78359,2.51681),(.30306,53.76511,2.55943),(.31193,54.02736,2.56409),(.35041,54.02704,2.5169),(.5667,54.71936,2.58729),(.61058,54.71982,2.6179),(.59844,54.69868,2.65361),(.7818,54.09134,2.58894),(.75926,54.21515,2.67151),(.69869,54.18811,2.75906),(.24828,54.27128,2.7627),(.17183,54.26649,2.78369),(.12093,53.66527,2.63779),(.16924,53.66598,2.62827),(.12678,53.4555,2.75987),(.17732,53.52345,2.72161),(.18322,53.45408,2.76403),(.10268,53.74404,3.03137),(.10767,53.65955,3.04777),(.27027,54.59885,2.81727),(.06534,54.64669,2.95749),(.09849,54.59439,2.93097),(0,54.58971,2.94433),(.08462,54.64888,2.94508),(.10863,54.65029,2.94052),(.22244,54.65164,2.87995),(.31255,54.68775,2.93733),(.30312,54.69166,2.90259),(.2999,54.68996,2.94971),(.39254,54.63206,3.09506),(.36867,54.6353,3.11459),(.4164,54.58355,3.10522),(.48576,54.59011,3.03845),(.48207,54.58968,3.03653),(.46154,54.58558,3.06198),(.28927,54.67803,2.95781),(.25941,54.68518,2.92325),(.25847,54.68068,2.92883),(.28424,54.66909,2.95845),(.29648,54.66529,2.99289),(.2996,54.6744,3.00018),(.19885,54.6804,3.02733),(.20297,54.67869,2.97921),(.19329,54.68505,3.02692),(.24454,54.63166,3.16545),(.24524,54.63159,3.16185),(.22679,54.64324,3.15581),(.1682,54.67918,3.05902),(.1815,54.68447,3.06403),(.17674,54.69012,3.02493),(.02516,54.58613,3.20542),(0,54.60673,3.1757),(0,54.54723,3.20088),(.12922,54.61343,3.20119),(.13351,54.61257,3.20427),(.1515,54.62765,3.19549),(.08551,54.68576,2.98416),(.08675,54.68502,2.99011),(.12369,54.68788,2.98959),(.05377,54.67782,3.01997),(.05003,54.61424,3.19836),(.06079,54.61753,3.19444),(.04557,54.62733,3.17583),(.12419,54.69034,2.98228),(.16352,54.69116,2.97974),(.18146,54.62028,3.19695),(.26655,54.62055,3.15908),(.24493,54.62606,3.16012),(.33612,54.66549,3.07412),(.31893,54.66039,3.08862),(.31074,54.64338,3.13483),(.19999,54.6753,3.02354),(.05995,54.6718,3.02001),(.05792,54.6754,3.02075),(.15077,54.66645,3.01542),(.12472,54.67617,2.98404),(.12705,54.65318,2.97325),(.09531,53.84759,2.9966),(.03471,53.848,3.01338),(0,53.74462,3.03948),(.16591,53.74621,3.01158),(.33413,53.86095,2.88022),(.40744,54.27323,2.9998),(.88545,54.8491,1.35966),(.94749,54.85163,1.34311),(.86977,54.80164,1.35748),(.88861,54.7381,1.33592),(.85909,54.79133,1.37783),(.82446,54.63639,1.52768),(.83093,54.76075,1.44158),(.84754,54.67386,1.42321),(1.07561,54.85294,1.66648),(1.02637,54.84715,1.67269),(1.08291,54.85409,1.68806),(.82094,54.80481,1.63822),(.82919,54.80934,1.6117),(.79912,54.78093,1.65631),(.73008,54.52893,1.85228),(.73096,54.67028,1.89051),(.72873,54.6879,1.82893),(.69261,54.49704,1.96459),(.65515,54.46515,2.07753),(.62441,54.61018,2.14301),(.65576,54.67417,2.0994),(.6812,54.68457,2.06123),(.6771,54.62938,2.04904),(1.10892,54.81581,1.80201),(1.12393,54.81463,1.79611),(1.09141,54.83033,1.74694),(1.10189,54.64208,2.01118),(1.15839,54.63735,1.94216),(1.14488,54.69766,1.95872),(1.07414,54.69682,2.00694),(1.1128,54.72403,1.95669),(1.08724,54.73906,1.94429),(1.01366,54.72812,2.16001),(1.02998,54.69378,2.14904),(1.0424,54.71422,2.0868),(.99806,54.7637,2.06019),(1.01895,54.74103,2.10707),(1.02431,54.74738,2.06284),(1.07245,54.58895,2.12057),(1.12798,54.57383,2.02381),(1.09161,54.62352,2.04932),(1.00731,54.76237,2.03562),(.95513,54.77557,2.03057),(.99272,54.7043,2.28216),(1.00728,54.66171,2.25901),(1.00164,54.71027,2.24619),(.95571,54.68961,2.36403),(.9181,54.6001,2.44478),(.96986,54.62785,2.35998),(.89622,54.74783,2.36503),(.84325,54.75216,2.36912),(.81834,54.7388,2.42827),(.74155,54.70231,2.6274),(.81993,54.66195,2.63565),(.76792,54.69822,2.61502),(1.01675,54.61998,2.24834),(1.04591,54.65815,2.1396),(1.22378,54.65814,1.9036),(1.20657,54.62257,1.93355),(1.2735,54.60029,1.89139),(.61537,54.66816,2.22927),(.60209,54.61016,2.2565),(.61134,54.67959,2.28317),(.71126,54.73353,2.05329),(.76511,54.74875,2.04175),(.70526,54.69724,2.02013),(.8167,54.86151,1.50391),(.82548,54.86577,1.46577),(.82188,54.82892,1.45563),(.86033,54.84985,1.37019),(.84556,54.84303,1.39737),(.84635,54.87539,1.40447),(.77292,54.76539,1.91931),(.7768,54.75406,1.96218),(.81979,54.76642,1.95425),(.814,54.76571,1.99643),(.77564,54.7513,1.9848),(.73846,54.71353,1.98834),(.70478,54.65041,2.0044),(.83388,54.86516,1.46645),(.83886,54.8719,1.43451),(.944,54.88846,1.37937),(.9442,54.89,1.37489),(.90242,54.88654,1.37607),(1.10583,54.8995,1.43461),(1.11122,54.90674,1.43157),(1.06672,54.90498,1.40134),(.77978,54.80763,1.74367),(.77438,54.80722,1.73638),(.76585,54.80115,1.77221),(1.03942,54.77075,1.97496),(1.0564,54.74171,2.00401),(.80613,54.81573,1.6994),(.96227,54.75955,1.98083),(.92046,54.75571,1.97365),(.96009,54.76555,1.98816),(.77724,54.76476,1.91378),(.76374,54.77933,1.85254),(1.09796,54.79653,1.86337),(1.10333,54.79883,1.86508),(1.10018,54.81414,1.80375),(1.09342,54.80768,1.80381),(1.07762,54.8209,1.75161),(1.03565,54.76912,1.96802),(1.00104,54.76149,1.98598),(.82188,54.75399,1.94816),(.96487,54.76689,2.10102),(.97555,54.76062,2.14223),(.98265,54.76432,2.1399),(.8426,54.74937,2.36287),(.68241,54.72789,2.08376),(.68713,54.72745,2.08726),(.71374,54.73235,2.05688),(.66205,54.7159,2.29509),(.65441,54.71377,2.26512),(.65662,54.71964,2.2999),(.6492,54.7145,2.26748),(.65745,54.71648,2.13153),(.81308,54.74921,2.04864),(.81358,54.75568,2.0428),(.89857,54.66267,2.44734),(.88326,54.6609,2.47298),(.74583,54.74642,2.34901),(.68927,54.73192,2.32016),(.68286,54.73834,2.36808),(.69328,54.72656,2.31444),(.69356,54.6633,2.30667),(.7885,54.74954,2.36011),(.79094,54.67327,2.33977),(.74868,54.66868,2.3306),(1.09898,53.81443,2.18272),(.93318,53.67143,2.3937),(1.0138,53.70223,2.06485),(.86075,54.77362,2.00839),(.86711,54.76025,1.96965),(.75749,54.78654,1.82516),(.74214,54.73985,1.87269),(.75601,54.77816,1.85503),(.86722,54.85285,1.58475),(.85492,54.8376,1.62776),(.89936,54.84524,1.63692),(1.13817,54.78115,1.85415),(1.18939,54.78459,1.81632),(1.0945,54.79006,1.90215),(1.11988,54.78399,1.85866),(.9861,54.89631,1.3825),(.97435,54.86891,1.3382),(1.1517,54.91746,1.39721),(.83792,54.85045,1.46365),(.84124,54.84372,1.46317),(.84131,54.84428,1.46068),(1.12262,54.84965,1.51712),(1.12261,54.84596,1.51093),(1.11919,54.84207,1.51296),(1.02458,54.81529,1.48716),(1.10218,54.81095,1.49116),(1.11883,54.8412,1.51553),(1.12136,54.84398,1.52045),(.83976,54.84822,1.45232),(.86276,54.8212,1.44996),(.9361,54.83509,1.4768),(.93587,54.81624,1.47066),(1.02107,54.79389,1.59415),(1.0654,54.82326,1.60653),(1.06208,54.79515,1.59214),(.84073,54.85234,1.4345),(1.12459,54.84949,1.49394),(1.12534,54.8714,1.52311),(1.12472,54.87854,1.50057),(1.00774,54.72196,1.9727),(.97301,54.71856,1.97295),(.8388,54.67846,2.35102),(.92838,54.75149,2.33161),(.92788,54.69152,2.31164),(.89392,54.6854,2.34687),(.93459,54.69406,2.28095),(.95461,54.75042,2.2811),(.94482,54.69686,2.25319),(.98456,54.81585,1.31107),(1.13785,54.8497,1.73133),(1.14691,54.86148,1.68538),(1.23419,54.83604,1.70889),(1.24518,54.83088,1.70811),(1.26768,54.89467,1.66635),(1.23923,54.85515,1.63946),(1.06958,54.89707,1.36106),(1.08801,54.89371,1.31535),(1.28493,54.75545,1.8279),(1.21062,54.75343,1.80104),(1.17745,54.67908,1.89066),(.85603,54.82585,1.67408),(.98125,54.84635,1.65642),(1.03777,54.82167,1.71491),(.97885,54.82229,1.68194),(1.00081,54.7646,1.9934),(1.20526,54.5178,1.29279),(1.15393,54.44311,1.33622),(1.07042,54.49073,1.3119),(1.25033,54.00571,1.52715),(1.30707,54.02078,1.54103),(1.21065,53.91671,1.71839),(1.22549,54.13962,1.39989),(1.29663,54.36776,1.2638),(1.32518,54.28895,1.21582),(1.38877,55.11226,1.66666),(1.32999,55.0768,1.55916),(1.28406,54.94253,1.63809),(1.30339,54.07319,1.43369),(1.24144,55.02875,1.39273),(1.22624,54.90869,1.45269),(1.27955,54.69224,1.24587),(1.33816,54.62537,1.22658),(1.2635,54.4459,1.29882),(1.38962,54.16832,1.179),(1.18267,53.98509,2.02932),(1.19309,53.94873,1.97958),(1.31906,54.22208,1.65935),(1.25363,54.05792,1.81153),(1.32999,54.16402,1.62711),(.75802,54.64509,2.70368),(.78773,54.55503,2.69709),(.76888,54.64872,2.69107),(.80691,53.97487,2.55986),(.88852,54.02711,2.46815),(.82983,54.03855,2.54921),(1.20842,54.75704,1.25142),(1.29347,54.92092,1.20932),(1.37204,54.87062,1.18354),(1.49192,55.18573,1.44057),(1.49093,54.98804,1.31092),(1.4946,55.1662,1.33274),(1.24443,55.18982,1.25796),(1.21494,54.97261,1.24321),(1.16034,55.01342,1.27381),(1.42375,54.82089,1.15071),(1.30386,55.16262,1.21084),(1.36495,55.10789,1.15419),(1.54628,54.55449,1.04922),(1.49007,54.67126,.9901),(1.37924,54.54118,1.16379),(1.47224,54.74005,1.08009),(1.64946,56.00193,.49247),(1.67799,56.02454,.55099),(1.70534,56.07282,.43932),(1.47811,56.44513,1.65747),(1.4834,56.42739,1.71248),(1.48824,56.50166,1.74952),(1.62661,55.98172,.78675),(1.61682,55.91876,.73202),(1.58835,55.85782,.87747),(1.55051,55.76788,1.00082),(1.53171,55.76959,1.0508),(1.54889,55.7865,1.01618),(1.63278,55.91859,.56105),(1.63491,55.96091,.61182),(1.5797,56.01853,1.03485),(1.59821,55.9816,.89579),(1.58569,55.93614,.94932),(1.57767,55.52869,.81479),(1.54659,55.5663,.89865),(1.55392,55.65789,.9052),(1.41408,55.51274,1.13829),(1.44429,55.60014,1.13585),(1.4968,55.59211,1.02259),(1.64998,55.28533,.46699),(1.66136,55.33674,.43173),(1.56901,55.40997,.90346),(1.58976,55.50755,.7993),(1.425,55.25243,1.65684),(1.4483,55.38466,1.65679),(1.41721,55.25175,1.64859),(1.34511,55.29366,1.176),(1.39602,55.23552,1.104),(1.68117,55.72567,.36805),(1.64071,55.85141,.22855),(1.62637,55.32441,.68324),(1.69109,55.83458,.09632),(1.65551,55.83499,.12284),(1.61296,55.94382,.06089),(1.65086,55.84571,.2043),(1.81273,55.95243,.16737),(1.76973,55.82887,.16539),(1.77811,55.94086,.11319),(1.70046,55.30114,.48873),(1.68345,55.29743,.42061),(1.70543,55.45187,.3624),(1.8028,55.83836,.26979),(1.84873,55.96407,.22739),(1.85894,56.17938,.34293),(1.83608,56.18733,.33816),(1.76856,56.12369,.40962),(1.6663,56.00168,.67523),(1.65198,55.99417,.65936),(1.66371,55.75985,.68146),(1.67845,55.75383,.629),(1.68226,55.88875,.51711),(1.6041,56.08592,.267),(1.77906,56.10886,.40459),(1.83082,56.06714,.3742),(1.60572,56.20941,.1188),(1.6013,56.29055,.0968),(1.54466,56.30098,.07367),(1.65491,56.28271,.12475),(1.41414,56.26587,-.06923),(1.4243,56.1834,-.0064),(1.37831,56.27076,-.01206),(1.36849,56.47961,.01369),(1.35183,56.45079,-.0083),(1.35597,56.46083,.03267),(1.9079,56.13784,.32085),(1.90792,56.17219,.34893),(1.57852,56.47848,.13387),(1.59044,56.51077,.11563),(1.50266,56.51825,.09907),(1.67686,56.48605,.13377),(1.78032,56.44984,.164),(1.6959,56.51036,.09372),(1.76532,56.40721,.16592),(1.65886,56.44723,.14833),(1.65816,56.36044,.12191),(1.85957,56.40198,.20655),(1.85082,56.37427,.21844),(1.92908,56.31993,.28547),(1.84418,56.46298,.05174),(1.81858,56.47776,.09361),(1.89119,56.41962,.14862),(1.36408,56.38858,-.08497),(1.4863,56.41633,-.1185),(1.50302,56.35426,-.13567),(1.53449,56.11209,.06059),(1.57321,56.12547,.12703),(1.73782,56.00835,.46144),(1.7127,55.9913,.56344),(1.50535,55.87001,1.51121),(1.52528,55.93552,1.54533),(1.51319,55.85555,1.59918),(1.75603,55.73228,.3716),(1.78169,55.84683,.34371),(1.50663,55.67448,1.2257),(1.50076,55.69002,1.32216),(1.50211,55.52207,1.25334),(1.69307,55.45847,.32623),(1.66892,55.30664,.39374),(1.699,55.93745,.04571),(1.64769,54.89711,.73983),(1.66896,55.10069,.66234),(1.46055,55.38212,1.64878),(1.59135,56.50507,1.56204),(1.58969,56.49558,1.51374),(1.58581,56.57128,1.58163),(1.52797,55.96609,1.57838),(1.51334,56.0449,1.62094),(1.51685,55.864,1.29053),(1.49546,55.88122,1.4023),(1.84139,56.03401,.32482),(1.78273,55.9208,.37156),(1.67677,56.08083,.36646),(1.66599,56.05147,.41192),(1.55608,56.01059,.03428),(1.32277,55.34226,1.38961),(1.37536,55.35658,1.52121),(1.38458,55.46796,1.51339),(1.52875,55.31737,1.0341),(1.60724,55.25222,.84689),(1.48157,55.05529,1.04459),(1.51248,54.99668,1.04396),(1.37823,55.4202,1.14888),(1.29598,55.33085,1.2497),(1.33567,55.44774,1.24662),(1.65757,54.89314,.60568),(1.61942,54.68881,.76921),(1.60794,54.68777,.85021),(1.61648,54.65469,.76608),(1.53141,54.61625,.87681),(1.52111,54.57166,.91309),(-.6788,54.61024,2.15768),(-.70723,54.54064,2.12596),(-.68968,54.60581,2.16623),(-.6869,54.61295,2.12735),(-.70396,54.54317,2.10468),(-.77918,54.68471,1.77483),(-.79259,54.6641,1.72861),(-.79681,54.66268,1.73993),(-1.09697,54.70075,1.84229),(-1.07999,54.65894,1.84916),(-1.07377,54.65892,1.84411),(-1.09243,54.70133,1.83132),(-1.06363,54.67518,1.79347),(-1.08239,54.68189,1.78759),(-1.09722,54.70273,1.83157),(-1.08878,54.68358,1.78441),(-1.09069,54.68996,1.76014),(-.81014,54.67696,1.78374),(-.78333,54.68167,1.78479),(-.7857,54.68302,1.77679),(-1.09198,54.69954,1.84087),(-1.05622,54.69177,1.83173),(-1.05694,54.69247,1.8283),(-1.08093,54.65481,1.87389),(-1.07208,54.61125,1.87072),(-1.06338,54.61585,1.85241),(-.7821,54.64145,1.8063),(-.77755,54.68254,1.78581),(-.79282,54.64298,1.79351),(-.98308,54.72183,1.66943),(-.9791,54.77256,1.68323),(-1.03082,54.77249,1.70844),(-.98197,54.56513,2.15006),(-.97941,54.646,2.16707),(-.96795,54.64255,2.20367),(-.96628,54.64829,2.09797),(-.93937,54.6461,2.07897),(-.93372,54.7055,2.07597),(-1.08069,54.69925,1.48088),(-1.05807,54.62087,1.43921),(-1.06447,54.70182,1.47117),(-1.06869,54.64575,1.40926),(-1.06071,54.64354,1.41841),(-1.03946,54.5888,1.38894),(-.98952,54.55265,1.31936),(-.98401,54.56027,1.31401),(-.99118,54.55861,1.31378),(-1.01714,54.53814,1.3482),(-1.01197,54.53883,1.35134),(-1.01147,54.53623,1.34419),(-.96378,54.57042,1.35665),(-.98773,54.54735,1.35165),(-.98108,54.56349,1.36485),(-1.03176,54.51313,1.4294),(-1.03879,54.51304,1.42724),(-1.03579,54.52347,1.45274),(-1.04919,54.53179,1.40774),(-1.04652,54.53374,1.40083),(-1.0504,54.56327,1.41195),(-1.04898,54.5899,1.38046),(-1.04897,54.59089,1.37126),(-1.06685,54.64833,1.39651),(-.92974,54.66696,1.32547),(-.90143,54.72609,1.36055),(-.91208,54.72819,1.34608),(-1.08733,54.71092,1.42521),(-.81065,54.60798,1.79772),(-.78985,54.59965,1.80905),(-.81416,54.64531,1.79081),(-.81948,54.60973,1.79656),(-.80053,54.64506,1.79098),(-.80409,54.66179,1.74448),(-.82227,54.61759,1.70878),(-.83136,54.61779,1.71237),(-1.05671,54.39983,1.63931),(-1.0658,54.40984,1.65765),(-1.05074,54.40621,1.6579),(-1.01957,54.39865,1.62728),(-1.02357,54.39845,1.63014),(-.99712,54.40502,1.63939),(-.96706,54.36169,1.77356),(-.95381,54.36828,1.77862),(-.94191,54.36928,1.76953),(-.99706,54.36083,1.78296),(-1.00172,54.36594,1.79809),(-.9919,54.36782,1.79254),(-1.00362,54.36053,1.78531),(-1.00964,54.36182,1.78385),(-1.01271,54.36659,1.80001),(-.96301,54.36995,1.7535),(-.95911,54.36876,1.75531),(-.9387,54.37581,1.75283),(-.95853,54.36736,1.75839),(-.96067,54.36387,1.76697),(-.93688,54.37251,1.75959),(-1.08779,54.42509,1.65472),(-1.07405,54.42549,1.6657),(-1.07478,54.41114,1.65397),(-.91962,54.38068,1.76121),(-.99143,54.37814,1.80457),(-.90565,54.39345,1.75429),(-.92321,54.38607,1.75381),(-1.00223,54.40676,1.83454),(-1.01354,54.41045,1.83274),(-1.01356,54.427,1.84335),(-1.03012,54.43604,1.83129),(-1.03362,54.4454,1.81356),(-1.0414,54.4695,1.82967),(-1.07534,54.53725,1.70351),(-1.08575,54.54442,1.69261),(-1.08838,54.59109,1.71419),(-1.07732,54.5865,1.72188),(-1.09148,54.64887,1.73883),(-1.08024,54.64245,1.75158),(-.80751,54.53504,1.8209),(-.80487,54.58112,1.86986),(-.7883,54.59488,1.82319),(-.80536,54.62018,1.69342),(-.92201,54.32656,2.05124),(-.93248,54.32857,2.04363),(-.94849,54.37306,2.08089),(-.8706,54.24935,2.17023),(-.86496,54.2487,2.16894),(-.87245,54.25284,2.1689),(-.87814,54.25069,2.19114),(-.87954,54.25135,2.18366),(-.89845,54.27375,2.20392),(-.87958,54.25199,2.17752),(-.877,54.25202,2.17307),(-.89441,54.27332,2.18026),(-.83788,54.248,2.16767),(-.82986,54.24572,2.17115),(-.80967,54.26684,2.17044),(-.85971,54.31466,1.95906),(-.86944,54.29496,1.96631),(-.85976,54.29338,1.96904),(-.82871,54.30261,2.00152),(-.83356,54.30906,1.98301),(-.85357,54.29023,1.97961),(-.90078,54.29537,1.97792),(-.89579,54.29586,1.97363),(-.91644,54.31596,1.97135),(-.91631,54.31952,2.20553),(-.91255,54.31744,2.22114),(-.92687,54.30521,2.01696),(-.93827,54.33016,2.03262),(-.93505,54.33661,1.99016),(-.92285,54.33815,1.97771),(-.95163,54.38974,2.01919),(-.87018,54.33676,1.95912),(-.85476,54.3351,1.95995),(-.83634,54.38575,1.98087),(-.78315,54.3728,2.00965),(-.80216,54.38073,1.9857),(-.82908,54.33048,1.96661),(-.926,54.36813,2.24469),(-.93813,54.42863,2.24265),(-.93043,54.42651,2.26357),(-.30993,54.65784,2.8466),(-.32366,54.65706,2.82615),(-.31412,54.59161,2.81636),(-.34683,54.58894,2.8015),(-.3544,54.65361,2.80575),(-.35035,54.37925,2.79313),(-.32376,54.38437,2.78505),(-.32746,54.4378,2.78361),(-.67231,54.22163,2.39852),(-.67537,54.22004,2.40847),(-.66602,54.22736,2.40149),(-.67463,54.23436,2.363),(-.67802,54.23415,2.36378),(-.68086,54.22583,2.36952),(-.68214,54.2338,2.36546),(-.67802,54.2533,2.36229),(-.68852,54.25227,2.36702),(-.66629,54.2287,2.38979),(-.65203,54.24714,2.40917),(-.64981,54.24835,2.39584),(-.69908,54.22208,2.42571),(-.71138,54.23924,2.43787),(-.70543,54.23921,2.44109),(-.65966,54.25519,2.36248),(-.62638,54.3159,2.37125),(-.6356,54.31703,2.36478),(-.66393,54.24466,2.42438),(-.66171,54.29556,2.46405),(-.64547,54.29729,2.45404),(-.68245,54.24065,2.43994),(-.70124,54.29239,2.47379),(-.68078,54.29348,2.47258),(-.61864,54.31192,2.38559),(-.59569,54.38189,2.414),(-.60082,54.38598,2.39253),(-.62303,54.38992,2.36882),(-.61093,54.38852,2.37753),(-.60205,54.44951,2.3864),(-.52274,54.20204,2.67118),(-.5251,54.20096,2.68254),(-.50603,54.24538,2.67718),(-.6082,54.23627,2.74007),(-.63516,54.28316,2.74256),(-.62037,54.28193,2.75375),(-.51015,54.29611,2.64251),(-.49413,54.295,2.65541),(-.48059,54.35947,2.64589),(-.60682,54.28095,2.76538),(-.63647,54.34204,2.77617),(-.61928,54.34207,2.78673),(-.29823,54.03597,2.85443),(-.32179,54.04482,2.85753),(-.3176,54.04574,2.86557),(-.29622,54.03616,2.84256),(-.31841,54.04923,2.82899),(-.32136,54.04646,2.84148),(-.27148,54.06315,2.81937),(-.26898,54.0671,2.82314),(-.28132,54.08264,2.80805),(-.31155,54.05149,2.871),(-.35999,54.09333,2.88279),(-.30976,54.19773,2.80172),(-.29881,54.2625,2.80238),(-.31385,54.25881,2.79401),(-.33997,54.17656,2.92911),(-.35339,54.17103,2.93983),(-.36696,54.22991,2.96207),(-.29484,54.26225,2.81615),(-.29313,54.32638,2.81272),(-.29793,54.38766,2.7984),(-.28796,54.38701,2.81273),(-.29156,54.43844,2.82005),(-.20184,54.21664,2.9091),(-.19596,54.22791,2.9092),(-.20158,54.23046,2.90142),(-.20797,54.20809,2.93053),(-.20876,54.20834,2.92828),(-.22185,54.2131,2.93674),(-.23932,54.24419,2.89482),(-.2305,54.25231,2.88575),(-.24474,54.28925,2.8753),(-.29033,54.44203,3.06189),(-.27245,54.43981,3.07947),(-.26782,54.38664,3.05652),(-.21386,54.22974,2.89309),(-.20761,54.2317,2.89643),(-.21331,54.25961,2.88293),(-.19817,54.25634,2.90745),(-.21724,54.21379,2.94607),(-.24166,54.23148,2.95039),(-.13678,54.19183,2.94268),(-.1386,54.19661,2.93847),(-.14395,54.19415,2.94444),(-.13621,54.18187,2.97313),(-.14137,54.18342,2.96648),(-.14208,54.18393,2.96856),(-.12941,54.24293,2.91027),(-.13308,54.24336,2.926),(-.1381,54.22436,2.93445),(-.13437,54.18265,2.96316),(-.13461,54.18161,2.96836),(-.12067,54.19037,2.96818),(-.14178,54.18577,2.97986),(-.14491,54.18974,2.97962),(-.13801,54.19322,2.99246),(-.11167,54.24493,3.05),(-.11099,54.20984,3.01651),(-.12028,54.21281,3.01908),(-.10827,54.27411,3.07314),(-.1237,54.27754,3.06667),(-.12615,54.31362,3.09039),(-.06913,53.66198,2.62911),(-.0798,53.66422,2.63853),(-.06477,53.71325,2.61367),(-.0752,53.83042,2.57119),(-.1497,53.85274,2.58128),(-.06764,53.85571,2.56778),(-1.21494,54.97261,1.24321),(-1.23321,54.9599,1.23435),(-1.30386,55.16262,1.21084),(-1.06861,54.67193,1.27169),(-1.133,54.83257,1.27144),(-1.05096,54.68809,1.27269),(-1.59782,55.22729,.7123),(-1.63022,55.26243,.6643),(-1.61657,55.31677,.65731),(-1.62134,55.18435,.58076),(-1.62576,55.26745,.59074),(-1.6118,55.24187,.6487),(-1.56536,54.94248,.72077),(-1.56029,54.98813,.75979),(-1.55651,54.94293,.77026),(-1.57874,54.99013,.71447),(-1.58548,55.09396,.67869),(-1.57106,55.00944,.74952),(-1.60591,55.01789,.60452),(-1.55476,54.89115,.8982),(-1.54774,54.94345,.84654),(-1.54714,55.05936,.88239),(-1.57536,54.45144,.77331),(-1.57249,54.48183,.79875),(-1.53281,54.46599,.86278),(-1.50185,54.30782,.92861),(-1.51893,54.30291,.9213),(-1.54931,54.36579,.8711),(-1.53752,54.38122,.85578),(-1.53005,54.31156,.93121),(-1.58826,54.41334,.89514),(-1.56336,54.37269,.88077),(-1.59386,54.50142,.84073),(-1.57803,54.43069,.90501),(-1.59076,54.51277,.8916),(-1.60948,54.48268,.79967),(-1.60663,54.48775,.82551),(-1.62102,54.59437,.77769),(-1.65518,54.88943,.67667),(-1.67609,55.09764,.55168),(-1.65757,54.89314,.60568),(-1.58938,54.49886,.73485),(-1.61306,54.53641,.70047),(-1.59512,54.57027,.69963),(-1.60935,54.49151,.72996),(-1.63834,54.66041,.64723),(-1.63139,54.66015,.63657),(-1.62226,54.59506,.6667),(-1.61622,54.56302,.69765),(-1.61898,54.56793,.70882),(-1.57444,54.5829,.71532),(-1.56331,54.55462,.76142),(-1.57575,54.49174,.80949),(-1.55766,54.51937,.78863),(-1.55251,54.54196,.78326),(-1.56224,54.54883,.79415),(-1.57882,54.47236,.74792),(-1.51248,54.99668,1.04396),(-1.53362,54.94391,.97096),(-1.40667,54.45819,1.0989),(-1.4365,54.36094,1.03348),(-1.46884,54.43956,.9824),(-1.52233,54.40022,.87675),(-1.5255,54.39211,.86018),(-.33679,54.53399,3.1305),(-.33704,54.49931,3.11593),(-.25704,54.50316,3.17967),(-.16635,54.54907,3.19645),(-.18431,54.54533,3.18275),(-.17061,54.50516,3.18186),(-.37306,54.52721,3.11173),(-.36375,54.49797,3.10313),(-.35897,54.52981,3.11299),(-.60398,54.55285,2.92635),(-.5902,54.50219,2.92781),(-.58182,54.54921,2.93811),(-.36554,54.38938,3.06986),(-.34477,54.27513,3.01366),(-.2835,54.27692,3.03057),(-.55566,54.15412,2.86387),(-.55103,54.28023,2.9249),(-.5842,54.28504,2.90294),(-1.50766,55.86051,1.64219),(-1.50825,55.95749,1.65464),(-1.52797,55.96609,1.57838),(-1.44661,55.99803,1.52114),(-1.44188,56.11526,1.54766),(-1.44084,56.10955,1.56469),(-1.60624,55.24041,.78001),(-1.6209,55.23632,.80309),(-1.51188,55.10295,1.05355),(-1.47672,55.78405,1.21632),(-1.471,55.77887,1.22546),(-1.47029,55.71374,1.16724),(-1.48045,56.42395,1.72543),(-1.47614,56.32193,1.7008),(-1.4834,56.42739,1.71248),(-1.48233,55.84884,1.28499),(-1.47112,55.844,1.29076),(-1.48359,55.93728,1.34324),(-1.47456,56.04249,1.40931),(-1.47183,55.9316,1.35357),(-1.5107,56.26615,1.49018),(-1.50011,56.26533,1.49815),(-1.47787,56.15126,1.46042),(-1.66599,56.05147,.41192),(-1.64946,56.00193,.49247),(-1.63727,55.9725,.43873),(-1.61798,55.90822,.54602),(-1.63278,55.91859,.56105),(-1.62274,55.86883,.69492),(-1.55051,55.76788,1.00082),(-1.54772,55.72029,.95714),(-1.59042,55.78585,.81394),(-1.48164,54.20045,1.14125),(-1.44742,54.18037,1.14702),(-1.30339,54.07319,1.43369),(-1.49502,54.30485,.94198),(-1.69109,55.83458,.09632),(-1.70747,55.8311,.09034),(-1.68257,55.93915,.03676),(-1.69307,55.45847,.32623),(-1.68395,55.45626,.31633),(-1.66051,55.30599,.38767),(-1.70282,55.58667,.25346),(-1.70978,55.58035,.24615),(-1.72574,55.71457,.15739),(-1.71071,55.72111,.16456),(-1.699,55.93745,.04571),(-1.68242,55.95298,.02432),(-1.63853,54.89279,.57016),(-1.63133,54.89169,.56266),(-1.60676,54.45892,.7348),(-1.52336,55.43699,.94247),(-1.57767,55.52869,.81479),(-1.54659,55.5663,.89865),(-1.5924,55.2391,.75008),(-1.48654,55.06858,1.04382),(-1.53903,55.08518,.95015),(-1.48157,55.05529,1.04459),(-1.58976,55.50755,.7993),(-1.54741,55.42209,.92145),(-1.16034,55.01342,1.27381),(-1.08658,54.88283,1.29871),(-1.09944,54.86691,1.28557),(-.98456,54.81585,1.31107),(-1.08801,54.89371,1.31535),(-1.90005,56.30211,.27491),(-1.87493,56.30386,.24945),(-1.84922,56.35115,.21637),(-1.89533,56.12857,.32299),(-1.9079,56.13784,.32085),(-1.90963,56.1273,.31477),(-1.85366,56.3585,.21325),(-1.76532,56.40721,.16592),(-1.90456,56.30737,.27904),(-1.58481,56.0025,.24347),(-1.60915,55.92195,.35483),(-1.58096,55.98882,.13386),(-1.83608,56.18733,.33816),(-1.81471,56.18954,.31035),(-1.86473,56.2514,.28378),(-1.56552,56.21642,.08986),(-1.57646,56.13708,.13865),(-1.55984,56.20819,.0807),(-1.38013,56.35095,.04151),(-1.36631,56.34672,.03411),(-1.3512,56.4031,.04558),(-1.49821,56.11329,.05652),(-1.54348,56.04758,.08262),(-1.49163,56.10207,.04782),(-1.49349,56.46258,.10533),(-1.42848,56.44805,.08034),(-1.49822,56.47514,.10661),(-1.76911,56.41752,.16707),(-1.85082,56.37427,.21844),(-1.3545,56.41788,.05192),(-1.36365,56.40251,.05515),(-1.5781,56.09172,1.29428),(-1.5713,56.08488,1.33533),(-1.56695,56.18381,1.384),(-1.58725,56.41107,1.60971),(-1.5514,56.39023,1.66287),(-1.54821,56.41057,1.67481),(-1.77704,55.96477,.37395),(-1.84139,56.03401,.32482),(-1.78273,55.9208,.37156),(-1.58089,56.02433,1.20491),(-1.5978,55.93632,1.04708),(-1.58229,55.99175,1.19171),(-1.46721,55.6019,1.66561),(-1.48823,55.53611,1.5741),(-1.46648,55.50317,1.653),(-1.7722,55.99213,.40274),(-1.74879,55.9509,.4264),(-1.31666,54.72452,1.79916),(-1.34299,54.8504,1.74286),(-1.32084,54.71554,1.78298),(-1.28493,54.75545,1.8279),(-1.32927,54.84871,1.74101),(-1.3373,54.8512,1.74558),(-1.21062,54.75343,1.80104),(-1.24518,54.83088,1.70811),(-1.26768,54.89467,1.66635),(-1.40437,55.10842,1.66639),(-1.36499,54.97223,1.71226),(-1.39737,55.11202,1.67588),(-1.48078,55.20737,1.51246),(-1.43191,55.24861,1.64912),(-1.46055,55.38212,1.64878),(-.18392,53.44432,2.77151),(-.18322,53.45408,2.76403),(-.12678,53.4555,2.75987),(-.35755,53.43825,2.74261),(-.35503,53.44619,2.73831),(-.35734,53.43859,2.7449),(-.06799,53.46727,2.76229),(-.06649,53.53323,2.73394),(-.0396,53.50247,2.73942),(-.05534,53.62228,2.65896),(-.04336,53.62774,2.64621),(0,53.6127,2.65843),(-.04408,53.78548,2.58657),(-.03909,53.7778,2.58184),(-.06362,53.73816,2.58969),(-.06881,53.93632,2.56377),(-.04746,53.95833,2.58037),(-.04344,53.95469,2.57199),(-.00992,53.95084,2.58484),(-.00894,53.95177,2.59392),(-.00529,53.91098,2.56996),(-.07184,53.74467,2.60038),(-.10872,53.74483,2.60457),(-.06462,54.09558,2.67225),(0,54.0858,2.68192),(-.73102,53.98067,2.56834),(-.69537,53.98284,2.61168),(-.70911,54.01364,2.57433),(-.69869,54.18811,2.75906),(-.76914,54.07095,2.61149),(-.70273,54.04436,2.70329),(-.394,53.74335,2.94548),(-.32844,53.75532,2.96359),(-.37383,53.76609,2.91784),(-.41307,53.68511,2.96999),(-.37124,53.67692,3.00494),(-.26355,53.45129,2.76871),(-.34315,53.45376,2.87581),(-.58225,54.57039,2.37268),(-.56845,54.56094,2.40522),(-.57706,54.41952,2.32147),(-.59653,54.68111,2.34174),(-.61134,54.67959,2.28317),(-.61869,54.71434,2.34592),(-.64793,54.73141,2.35267),(-.62037,54.7167,2.35943),(-.72529,53.92263,2.65246),(-.77819,54.01976,2.62232),(-.81546,54.01753,2.5773),(-.49863,54.66208,2.60044),(-.50838,54.61262,2.55852),(-.51519,54.65881,2.56636),(-.51966,54.66066,2.55761),(-.53909,54.6128,2.48632),(-.53714,54.67681,2.49892),(-.39989,54.69264,2.75059),(-.41407,54.6924,2.73595),(-.4321,54.70111,2.78146),(-.55515,53.47387,2.56995),(-.68669,53.52515,2.43977),(-.53473,53.5379,2.52549),(-.27668,54.68939,2.90351),(-.2639,54.65783,2.85664),(-.30078,54.69425,2.87737),(-.30512,54.6947,2.84585),(-.30301,54.46301,2.76653),(-.36626,54.47315,2.71668),(-.36193,54.6054,2.7133),(-.16352,54.69116,2.97974),(-.13936,54.65115,2.92844),(-.16941,54.65329,2.91527),(-.71763,54.69229,2.68675),(-.74155,54.70231,2.6274),(-.74303,54.67696,2.69759),(-.75098,54.64224,2.72371),(-.75327,54.54287,2.77325),(-.73891,54.63737,2.77417),(-.69946,54.67887,2.74165),(-.71245,54.66846,2.79219),(-.51118,54.67939,2.81337),(-.47398,54.69285,2.83006),(-.48052,54.68679,2.77779),(-.46314,54.56774,3.08669),(-.39806,54.56515,3.11466),(-.4164,54.58355,3.10522),(-.26202,54.53815,3.18338),(-.33217,54.56671,3.14313),(-.16517,54.58644,3.20535),(-.11186,54.56648,3.22758),(-.36809,54.60001,3.13208),(-.36867,54.6353,3.11459),(-.34418,54.63912,3.12624),(-.33612,54.66549,3.07412),(-.62247,54.1594,2.83209),(-.5729,54.15538,2.85611),(0,53.84823,3.02311),(-.03471,53.848,3.01338),(-.0519,54.14896,3.00069),(0,54.003,3.01185),(-.15355,54.15772,2.977),(-.22437,54.27931,3.04947),(-.20456,54.1631,2.95552),(-.23962,54.38553,3.12623),(-.20432,54.38932,3.1251),(-.5125,54.53423,3.04538),(-.54841,54.59224,2.99956),(-.55582,54.54395,2.98137),(-.59839,54.69402,2.37159),(-.57793,54.68785,2.39704),(-.58066,54.61203,2.38447),(-.63405,54.73289,2.39386),(-.63193,54.72741,2.39915),(-.61151,54.72809,2.40724),(-.60806,54.69595,2.40361),(-.58659,54.69699,2.4123),(-.57077,54.69664,2.43387),(-.56719,54.69487,2.46175),(-.57205,54.72714,2.46662),(-.56516,54.7294,2.46348),(-.56293,54.72609,2.50021),(-.49531,54.69969,2.64451),(-.46821,54.65884,2.63291),(-.53499,54.68341,2.55974),(-.69901,54.71176,2.62848),(-.74121,54.70063,2.62197),(-.51159,54.6823,2.8719),(-.49857,54.65796,2.92054),(-.478,54.66447,2.89137),(-.44456,54.67807,2.85202),(-.39828,54.69182,2.8175),(-.52912,54.67909,2.57717),(-.68566,54.71124,2.66849),(-.46604,54.69521,2.67226),(-.46874,54.69345,2.67491),(-.66495,54.68369,2.71256),(-.66971,54.69091,2.70824),(-.36506,54.69586,2.80164),(-.32403,54.696,2.8178),(-.30867,54.66072,2.78963),(-.49178,54.65146,2.92448),(-.51424,54.65003,2.95834),(-.50694,54.64693,2.95761),(-.31091,54.69352,2.8473),(-.32715,54.6929,2.824),(-.30552,54.69037,2.875),(-.66218,54.62497,2.89432),(-.62058,54.62635,2.91584),(-.62404,54.65946,2.86938),(-.45634,54.68927,2.7059),(-.40073,54.66247,2.69744),(-.43529,54.66159,2.66191),(-.23683,54.13508,2.65127),(-.1457,54.11343,2.66421),(-.1347,53.96496,2.57731),(-.54143,53.86178,2.77362),(-.62025,53.87087,2.72737),(-.63985,53.75175,2.73278),(-.40667,53.69412,2.51753),(-.40144,53.78359,2.51681),(-.30306,53.76511,2.55943),(-.31576,54.29493,2.69797),(-.24828,54.27128,2.7627),(-.52926,54.65243,2.63076),(-.5304,54.69723,2.63779),(-.55482,54.69394,2.6411),(-.55527,54.65086,2.63802),(-.17472,53.43419,2.89854),(-.13405,53.44374,2.7667),(-.1714,53.59137,3.0546),(-.1747,53.51088,3.04616),(-.09949,53.53032,3.03164),(-.29997,54.60099,2.7834),(-.28886,54.66044,2.81437),(-.05341,54.51704,3.21206),(-.04451,54.39635,3.14662),(-.16342,54.38994,3.13439),(-.10908,54.39054,3.14823),(-.11232,54.50425,3.20755),(-.31884,54.68337,3.00331),(-.2999,54.68996,2.94971),(-.3317,54.67441,3.00519),(-.25941,54.68518,2.92325),(-.19485,54.68292,2.97972),(-.18351,54.65158,2.90255),(-.31215,54.65536,3.08742),(-.31893,54.66039,3.08862),(-.31074,54.64338,3.13483),(-.19106,54.68261,3.06595),(-.19329,54.68505,3.02692),(-.19606,54.67659,3.06599),(-.25847,54.68068,2.92883),(-.22354,54.68115,2.94091),(-.20297,54.67869,2.97921),(-.21799,54.6826,2.93933),(-.18662,54.66413,3.14873),(-.19133,54.64841,3.17182),(-.16322,54.64775,3.17478),(-.02516,54.58613,3.20542),(-.06162,54.57167,3.22634),(-.05377,54.67782,3.01997),(-.06534,54.64669,2.95749),(-.08551,54.68576,2.98416),(-.12922,54.61343,3.20119),(-.13351,54.61257,3.20427),(-.10536,54.60248,3.21523),(-.04557,54.62733,3.17583),(-.03698,54.62912,3.18003),(-.03202,54.64102,3.1434),(-.1515,54.62765,3.19549),(-.15713,54.64263,3.16956),(-.04956,54.66287,3.06115),(-.05792,54.6754,3.02075),(-.12369,54.68788,2.98959),(-.15372,54.68865,3.02126),(-.1492,54.68279,3.0223),(0,54.66885,3.06298),(0,54.65855,3.02812),(-.30555,54.68094,2.99871),(-.28927,54.67803,2.95781),(-.28816,54.62996,3.14753),(-.28875,54.63134,3.15004),(-.26811,54.62521,3.1618),(-.48207,54.58968,3.03653),(-.47262,54.56031,3.02244),(-.48832,54.57018,2.99099),(-.22706,54.6369,3.15209),(-.24493,54.62606,3.16012),(-.24524,54.63159,3.16185),(-.22679,54.64324,3.15581),(-.20941,54.65671,3.14037),(-.19999,54.6753,3.02354),(-.19885,54.6804,3.02733),(-.16171,54.67244,3.05877),(-.15077,54.66645,3.01542),(-.07906,54.60626,3.20631),(-.07933,54.60083,3.20469),(-.10139,54.59866,3.20931),(-.12317,54.59946,3.20055),(-.14547,54.60213,3.18559),(-.14609,54.61576,3.19129),(-.19284,54.58422,3.1923),(-.21779,54.58047,3.18607),(-.20875,54.54429,3.18185),(-.35878,54.55304,3.12645),(0,54.64399,3.15226),(-.24982,53.50203,3.04161),(-.23938,53.58834,3.06609),(-.16591,53.74621,3.01158),(-.22891,53.75143,2.99104),(-.22789,53.67029,3.0376),(-.2547,54.15939,2.94913),(-.2536,54.01079,2.93024),(-.43839,54.38369,3.06314),(-.33413,53.86095,2.88022),(-.33563,53.60119,3.04863),(-.33315,53.67778,3.01976),(-.24756,53.42955,2.89354),(-.17275,54.44886,2.8545),(-.10575,54.44485,2.8926),(-.1001,54.26335,2.80047),(-.7424,54.02354,2.53148),(-.71698,54.04757,2.54716),(-.81474,54.23066,2.60125),(-.86578,54.25528,2.53751),(-.87823,54.12603,2.49801),(-.90242,54.88654,1.37607),(-.88545,54.8491,1.35966),(-.94749,54.85163,1.34311),(-.82188,54.82892,1.45563),(-.82026,54.82044,1.4956),(-.83093,54.76075,1.44158),(-.76304,54.7204,1.68626),(-.79599,54.59582,1.63021),(-.82446,54.63639,1.52768),(-.82496,54.74952,1.53894),(-.61537,54.66816,2.22927),(-.64515,54.70947,2.22067),(-.62441,54.61018,2.14301),(-.64336,54.61966,2.11023),(-.62714,54.6657,2.15715),(-.6771,54.62938,2.04904),(-.69261,54.49704,1.96459),(-.70478,54.65041,2.0044),(-.91577,53.67157,2.07902),(-.84099,53.59586,2.23335),(-1.0138,53.70223,2.06485),(-1.10768,54.83829,1.73798),(-1.13785,54.8497,1.73133),(-1.12393,54.81463,1.79611),(-1.35146,54.96784,1.70252),(-1.28406,54.94253,1.63809),(-1.15839,54.63735,1.94216),(-1.16679,54.54037,2.00306),(-1.13363,54.58326,2.00925),(-1.02821,54.74765,2.04939),(-1.0564,54.74171,2.00401),(-1.04559,54.72154,2.06262),(-1.14014,54.48108,2.05222),(-1.09993,54.52706,2.09617),(-.8313,54.06643,2.537),(-.88852,54.02711,2.46815),(-.82983,54.03855,2.54921),(-.90808,54.66586,2.42927),(-.90092,54.70002,2.41639),(-.95571,54.68961,2.36403),(-.86165,54.7154,2.44311),(-.89622,54.74783,2.36503),(-.93259,54.75097,2.34057),(-1.12798,54.57383,2.02381),(-1.14488,54.69766,1.95872),(-1.17327,54.73846,1.91142),(-.81834,54.7388,2.42827),(-.79869,54.7076,2.49668),(-.76884,54.74713,2.41),(-.74846,54.72203,2.45444),(-.70432,54.7267,2.42446),(-.68286,54.73834,2.36808),(-.67958,54.7294,2.40412),(-.62622,54.71341,2.32715),(-.6492,54.7145,2.26748),(-.89578,54.45746,1.49406),(-.88183,54.57902,1.40465),(-.85707,54.53779,1.50168),(-.73326,54.66466,1.95555),(-.74759,54.71876,1.97081),(-.73846,54.71353,1.98834),(-.82919,54.80934,1.6117),(-.85492,54.8376,1.62776),(-.82094,54.80481,1.63822),(-.8339,54.82593,1.59231),(-.86722,54.85285,1.58475),(-.84263,54.85194,1.5671),(-.84576,54.85199,1.56232),(-.9861,54.89631,1.3825),(-.98521,54.89283,1.38761),(-.944,54.88846,1.37937),(-.7768,54.75406,1.96218),(-.74851,54.71865,1.9593),(-.74672,54.72587,1.91193),(-.97757,54.81387,1.68685),(-1.03777,54.82167,1.71491),(-1.03243,54.8125,1.71591),(-.81979,54.76642,1.95425),(-.82188,54.75399,1.94816),(-.86955,54.75422,1.9629),(-.85603,54.82585,1.67408),(-.85587,54.818,1.67882),(-.80613,54.81573,1.6994),(-.96227,54.75955,1.98083),(-1.00104,54.76149,1.98598),(-.96009,54.76555,1.98816),(-.92046,54.75571,1.97365),(-.86711,54.76025,1.96965),(-1.03942,54.77075,1.97496),(-1.00731,54.76237,2.03562),(-1.00081,54.7646,1.9934),(-.98579,54.75572,2.17358),(-.97866,54.75471,2.17481),(-.97555,54.76062,2.14223),(-.89329,54.74621,2.35597),(-.92838,54.75149,2.33161),(-.9181,54.6001,2.44478),(-.89857,54.66267,2.44734),(-.85564,54.66156,2.54105),(-.81275,54.70186,2.53131),(-.65662,54.71964,2.2999),(-.81993,54.66195,2.63565),(-.80668,54.69593,2.57452),(-.85132,54.66064,2.57183),(-.65576,54.67417,2.0994),(-.65745,54.71648,2.13153),(-.80077,54.73625,1.61515),(-.82292,54.74021,1.5714),(-1.11988,54.78399,1.85866),(-1.14046,54.75124,1.9073),(-1.11348,54.75727,1.89952),(-1.10892,54.81581,1.80201),(-1.10018,54.81414,1.80375),(-1.07762,54.8209,1.75161),(-.86033,54.84985,1.37019),(-.87478,54.88122,1.38197),(-.86308,54.87924,1.3882),(-.97435,54.86891,1.3382),(-1.06958,54.89707,1.36106),(-.86604,54.81814,1.46405),(-.84488,54.8149,1.47135),(-.8379,54.84494,1.46723),(-.84124,54.84372,1.46317),(-.83792,54.85045,1.46365),(-1.10218,54.81095,1.49116),(-1.11436,54.81366,1.48617),(-1.12261,54.84596,1.51093),(-1.11395,54.81465,1.51511),(-1.10231,54.81688,1.50795),(-1.11883,54.8412,1.51553),(-1.10583,54.8995,1.43461),(-1.11668,54.89264,1.46274),(-1.11584,54.85707,1.45504),(-1.07281,54.81175,1.75437),(-.69114,54.6754,2.09218),(-.6786,54.67228,2.13056),(-.66458,54.71784,2.13397),(-.93459,54.69406,2.28095),(-.95461,54.75042,2.2811),(-.97283,54.70479,2.17278),(-1.14691,54.86148,1.68538),(-1.23419,54.83604,1.70889),(-1.31027,54.72757,1.81853),(-1.18939,54.78459,1.81632),(-1.1128,54.72403,1.95669),(-1.19253,54.42707,1.31487),(-1.2635,54.4459,1.29882),(-1.20526,54.5178,1.29279),(-1.40511,54.12661,1.36224),(-1.47895,54.37492,1.24774),(-1.50947,54.23676,1.15684),(-1.13773,54.59889,1.28089),(-1.20842,54.75704,1.25142),(-1.17398,54.25272,1.43035),(-1.38962,54.16832,1.179),(-1.22842,54.44426,1.98169),(-1.17783,54.31786,2.0696),(-1.1068,54.38687,2.12921),(-1.19083,54.29737,2.05405),(-1.12559,53.81503,1.88313),(-1.19309,53.94873,1.97958),(-1.25363,54.05792,1.81153),(-1.18267,53.98509,2.02932),(-1.09898,53.81443,2.18272),(-1.17173,54.01501,2.06855),(-1.17745,54.67908,1.89066),(-1.20657,54.62257,1.93355),(-1.31906,54.22208,1.65935),(-1.2969,54.2659,1.69689),(-.76548,54.6662,2.68628),(-1.1572,55.01915,1.28969),(-1.23964,55.19352,1.27662),(-1.2763,55.22196,1.39813),(-1.49266,54.57694,1.22137),(-1.45827,54.66188,1.34729),(-1.49707,54.60274,1.21007),(-1.37204,54.87062,1.18354),(-1.36495,55.10789,1.15419),(-1.29347,54.92092,1.20932),(-1.61172,54.46718,.75216),(-1.60153,54.44999,.77542),(-1.32518,54.28895,1.21582),(-1.57321,56.12547,.12703),(-1.58118,56.06248,.17123),(-1.56177,56.04507,.08614),(-1.57323,56.41658,1.44053),(-1.56538,56.31804,1.38251),(-1.5741,56.32144,1.37048),(-1.5173,56.54992,1.64028),(-1.56834,56.57505,1.57237),(-1.53998,56.59256,1.65068),(-1.58581,56.57128,1.58163),(-1.57592,56.5798,1.57337),(-1.57806,56.50203,1.5054),(-1.63491,55.96091,.61182),(-1.61682,55.91876,.73202),(-1.61885,55.85056,.48559),(-1.45091,55.17137,1.0444),(-1.39602,55.23552,1.104),(-1.46833,55.34117,1.04035),(-1.4719,55.48156,1.0398),(-1.43924,55.3679,1.06691),(-1.37823,55.4202,1.14888),(-1.41408,55.51274,1.13829),(-1.37536,55.35658,1.52121),(-1.36638,55.23754,1.53409),(-1.29598,55.33085,1.2497),(-1.24443,55.18982,1.25796),(-1.64165,55.32761,.70904),(-1.6221,55.34394,.74928),(-1.60724,55.25222,.84689),(-1.67799,56.02454,.55099),(-1.70654,55.5837,.28454),(-1.70671,55.69994,.21181),(-1.62661,55.98172,.78675),(-1.65198,55.99417,.65936),(-1.59135,56.50507,1.56204),(-1.5853,56.40988,1.53255),(-1.76432,55.72795,.31496),(-1.8028,55.83836,.26979),(-1.76973,55.82887,.16539),(-1.77906,56.10886,.40459),(-1.73072,56.0564,.45416),(-1.72359,56.0738,.46425),(-1.69404,56.032,.57343),(-1.70534,56.07282,.43932),(-1.70781,56.01973,.57671),(-1.67901,55.99419,.68473),(-1.47115,56.24517,1.55694),(-1.52332,56.37553,1.53373),(-1.68299,55.96562,.67175),(-1.64703,55.93993,.79845),(-1.65268,55.98135,.80557),(-1.67677,56.08083,.36646),(-1.65459,56.08165,.30812),(-1.67423,56.12988,.25638),(-1.61689,56.13738,.21162),(-1.6041,56.08592,.267),(-1.60192,56.13687,.20224),(-1.77282,56.19402,.25818),(-1.7148,56.12953,.31488),(-1.84842,56.00139,.27656),(-1.90925,56.09069,.26537),(-1.89388,56.06168,.2074),(-1.54466,56.30098,.07367),(-1.52405,56.38175,.08026),(-1.59166,56.37098,.097),(-1.97893,56.26409,.2251),(-1.963,56.31659,.18377),(-1.95355,56.297,.1396),(-1.91428,56.24167,.32697),(-1.89592,56.16335,.35063),(-1.85894,56.17938,.34293),(-1.53618,56.29558,.0646),(-1.49828,56.19923,.03477),(-1.4651,56.29587,.04194),(-1.38497,56.28783,.0247),(-1.42608,56.19304,.02126),(-1.37831,56.27076,-.01206),(-1.35183,56.45079,-.0083),(-1.37283,56.47897,-.02607),(-1.36849,56.47961,.01369),(-1.86899,56.42499,.18025),(-1.89119,56.41962,.14862),(-1.94462,56.34635,.21849),(-1.65551,55.83499,.12284),(-1.36321,56.45724,-.04897),(-1.62019,56.53743,.01772),(-1.60725,56.51316,-.04378),(-1.73733,56.49805,0),(-1.76594,56.27549,-.07331),(-1.76652,56.34486,-.07798),(-1.66737,56.36076,-.12789),(-1.65491,56.28271,.12475),(-1.75424,56.33774,.16201),(-1.73503,56.26897,.16867),(-1.86197,56.13235,.11135),(-1.94839,56.20081,.18882),(-1.88577,56.19493,.09158),(-1.93358,56.1507,.1962),(-1.91369,56.34306,.07965),(-1.91658,56.30207,.07158),(-1.53325,56.27665,-.13791),(-1.50302,56.35426,-.13567),(-1.38209,56.33022,-.08088),(-1.42347,56.49374,.07309),(-1.43762,56.52506,.035),(-1.52098,56.541,.0536),(-1.96533,56.21807,.241),(-1.95612,56.25331,.28271),(-1.60572,56.20941,.1188),(-1.75706,55.91694,.41193),(-1.68226,55.88875,.51711),(-1.73697,55.71988,.16664),(-1.76018,55.71551,.22917),(-1.72738,55.75489,.5275),(-1.67845,55.75383,.629),(-1.66241,55.49302,.46304),(-1.68718,55.46667,.376),(-1.68685,55.46307,.35198),(-1.67901,55.46341,.32832),(-1.53615,55.69251,1.15218),(-1.545,55.57456,1.13316),(-1.50663,55.67448,1.2257),(-1.49546,55.88122,1.4023),(-1.49219,55.69776,1.47125),(-1.50535,55.87001,1.51121),(-1.53885,55.84643,1.18258),(-1.51685,55.864,1.29053),(-1.5809,55.98595,.11185),(-1.38458,55.46796,1.51339),(-1.43676,55.38407,1.65062),(-1.42691,55.73153,1.58953),(-1.44275,55.60227,1.66469),(-1.40924,55.63723,1.56004),(-1.54653,55.86177,1.08893),(-1.54027,55.93343,1.15731),(-1.58569,55.93614,.94932),(-1.59821,55.9816,.89579),(-1.63027,55.68389,.54797),(-1.65086,55.76251,.41136),(-1.61559,55.78151,.62931),(-1.55392,55.65789,.9052),(-1.4968,55.59211,1.02259),(-1.52875,55.31737,1.0341),(-1.56901,55.40997,.90346),(-1.66136,55.33674,.43173),(-1.65488,55.31704,.39972),(-1.58624,55.10928,.69898),(-1.49793,55.33059,1.03562),(-1.46645,55.16514,1.04436),(-1.61301,54.49507,.74001),(-1.49007,54.67126,.9901),(-1.50659,54.53224,.93525),(-1.52111,54.57166,.91309),(-1.33567,55.44774,1.24662),(-1.34511,55.29366,1.176),(-1.53723,55.13732,1.06319),(-1.32277,55.34226,1.38961),(-1.55608,56.01059,.03428),(-1.54075,56.03941,.06917),(-1.58993,55.96934,.0929),(-1.84295,56.31611,.21638),(-1.81565,56.25684,.23308),(-1.56097,56.48398,1.54695),(-1.56865,56.50049,1.5079),(-1.78169,55.84683,.34371),(-1.74846,55.86944,.44134),(-1.50076,55.69002,1.32216),(-1.4483,55.38466,1.65679),(-1.64769,54.89711,.73983),(-1.65905,55.1033,.71644),(-1.66896,55.10069,.66234),(-1.71965,55.83728,.09801),(-1.73867,55.93915,.07785),(-1.66892,55.30664,.39374),(-1.70543,55.45187,.3624),(-1.75603,55.73228,.3716),(-1.73464,55.95814,.46273),(-1.70932,55.94933,.5341),(-1.7127,55.9913,.56344),(-1.4863,56.41633,-.1185),(-1.36408,56.38858,-.08497),(-1.54545,56.54656,.00135),(-1.85957,56.40198,.20655),(-1.91731,56.3711,.2423),(-1.92908,56.31993,.28547),(-1.65816,56.36044,.12191),(-1.65886,56.44723,.14833),(-1.79498,56.47543,.13584),(-1.78032,56.44984,.164),(-1.67686,56.48605,.13377),(-1.35597,56.46083,.03267),(-1.50266,56.51825,.09907),(-1.57852,56.47848,.13387),(-1.41414,56.26587,-.06923),(-1.90792,56.17219,.34893),(-1.92023,56.24019,.328),(-1.9423,56.21487,.29804),(-1.4243,56.1834,-.0064),(-1.47103,56.1791,-.04836),(-1.64359,56.20596,.14702),(-1.6013,56.29055,.0968),(-1.70733,56.19866,.19265),(-1.83082,56.06714,.3742),(-1.66545,55.9017,.64771),(-1.89915,56.24399,.31194),(-1.63692,55.99085,.7929),(-1.76856,56.12369,.40962),(-1.71492,55.45651,.45417),(-1.68345,55.29743,.42061),(-1.66273,55.10353,.50836),(-1.47233,56.41536,1.75878),(-1.48824,56.50166,1.74952),(-1.64071,55.85141,.22855),(-1.65086,55.84571,.2043),(-1.61296,55.94382,.06089),(-1.66431,55.93869,.04063),(-1.62637,55.32441,.68324),(-1.66271,55.74585,.39436),(-1.68117,55.72567,.36805),(-1.41721,55.25175,1.64859),(-1.425,55.25243,1.65684),(-1.60248,55.48765,.78475),(-1.36901,55.58432,1.2752),(-1.37089,55.52703,1.38998),(-1.35733,55.54079,1.2733),(-1.54935,56.30552,1.40787),(-1.5633,56.41568,1.44435),(-1.58835,55.85782,.87747),(-1.47811,56.44513,1.65747),(-1.49429,56.5285,1.69245),(-1.47224,54.74005,1.08009),(-1.53381,54.46472,1.08261),(-1.54104,54.42617,1.06206),(-1.57303,54.34598,.97009),(-1.43332,55.05463,1.10445),(-1.33816,54.62537,1.22658),(-1.42375,54.82089,1.15071),(-1.4946,55.1662,1.33274),(-1.47047,55.019,1.41774),(-1.49192,55.18573,1.44057),(-1.27955,54.69224,1.24587),(-.80691,53.97487,2.55986),(-.78773,54.55503,2.69709),(-.75802,54.64509,2.70368),(-.76792,54.69822,2.61502),(-.78325,54.69598,2.60156),(-1.00036,53.75124,1.9273),(-.95301,53.70928,2.00278),(-1.22549,54.13962,1.39989),(-1.15393,54.44311,1.33622),(-1.10532,54.34998,1.44277),(-1.24144,55.02875,1.39273),(-1.22624,54.90869,1.45269),(-1.1517,54.91746,1.39721),(-1.25033,54.00571,1.52715),(-1.40699,54.271,1.44273),(-1.46603,54.42093,1.29009),(-1.32999,54.16402,1.62711),(-1.30707,54.02078,1.54103),(-1.32999,55.0768,1.55916),(-1.19727,53.93823,1.62109),(-1.07042,54.49073,1.3119),(-.95513,54.77557,2.03057),(-.8245,54.81116,1.54436),(-.89936,54.84524,1.63692),(-.73008,54.52893,1.85228),(-.73096,54.67028,1.89051),(-1.23923,54.85515,1.63946),(-1.08291,54.85409,1.68806),(-.89392,54.6854,2.34687),(-.92788,54.69152,2.31164),(-.8388,54.67846,2.35102),(-.8426,54.74937,2.36287),(-.7885,54.74954,2.36011),(-.97301,54.71856,1.97295),(-1.00774,54.72196,1.9727),(-1.12472,54.87854,1.50057),(-1.12534,54.8714,1.52311),(-1.12459,54.84949,1.49394),(-.84995,54.82616,1.42033),(-.83976,54.84822,1.45232),(-.84073,54.85234,1.4345),(-1.06208,54.79515,1.59214),(-1.02315,54.82312,1.60421),(-1.02107,54.79389,1.59415),(-.93587,54.81624,1.47066),(-.9361,54.83509,1.4768),(-.84131,54.84428,1.46068),(-.86276,54.8212,1.44996),(-1.11919,54.84207,1.51296),(-1.02534,54.83469,1.49355),(-.99806,54.7637,2.06019),(-1.01895,54.74103,2.10707),(-.98265,54.76432,2.1399),(-1.1111,54.86534,1.58896),(-1.12207,54.87164,1.56656),(-1.16647,54.8718,1.62175),(-1.13054,54.88591,1.50192),(-1.20558,54.8938,1.50899),(-1.13182,54.87895,1.52526),(-1.06672,54.90498,1.40134),(-.9442,54.89,1.37489),(-.80078,54.81652,1.69553),(-1.13817,54.78115,1.85415),(-.90667,54.84877,1.59681),(-.86075,54.77362,2.00839),(-.814,54.76571,1.99643),(-.68241,54.72789,2.08376),(-.70526,54.69724,2.02013),(-.71126,54.73353,2.05329),(-1.00164,54.71027,2.24619),(-1.01366,54.72812,2.16001),(-1.00728,54.66171,2.25901),(-.74868,54.66868,2.3306),(-.74912,54.74188,2.34273),(-.67098,54.66158,2.28919),(-.69356,54.6633,2.30667),(-.66205,54.7159,2.29509),(-.68927,54.73192,2.32016),(-.74583,54.74642,2.34901),(-.88326,54.6609,2.47298),(-.7823,54.71357,2.47577),(-.7766,54.71046,2.47711),(-.74512,54.71424,2.45876),(-.81358,54.75568,2.0428),(-.81308,54.74921,2.04864),(-.76645,54.74592,2.0468),(-.68713,54.72745,2.08726),(-.71374,54.73235,2.05688),(-.84325,54.75216,2.36912),(-.96487,54.76689,2.10102),(-.9594,54.76053,2.10561),(-.9299,54.7668,2.07264),(-.77292,54.76539,1.91931),(-.77724,54.76476,1.91378),(-1.03565,54.76912,1.96802),(-1.10333,54.79883,1.86508),(-1.09342,54.80768,1.80381),(-.75601,54.77816,1.85503),(-.76374,54.77933,1.85254),(-.91817,54.76387,1.98038),(-.77978,54.80763,1.74367),(-1.07651,54.77972,1.9393),(-.774,54.80133,1.7731),(-.77438,54.80722,1.73638),(-.90295,54.88575,1.38128),(-.76511,54.74875,2.04175),(-.77564,54.7513,1.9848),(-.84635,54.87539,1.40447),(-.82548,54.86577,1.46577),(-.8167,54.86151,1.50391),(-.60209,54.61016,2.2565),(-1.2735,54.60029,1.89139),(-1.22378,54.65814,1.9036),(-1.04591,54.65815,2.1396),(-1.01675,54.61998,2.24834),(-.86276,54.68736,2.47999),(-.99272,54.7043,2.28216),(-1.09161,54.62352,2.04932),(-1.02431,54.74738,2.06284),(-1.02998,54.69378,2.14904),(-1.07414,54.69682,2.00694),(-1.10189,54.64208,2.01118),(-1.09141,54.83033,1.74694),(-.6812,54.68457,2.06123),(-.72873,54.6879,1.82893),(-.79912,54.78093,1.65631),(-.82291,54.78536,1.59846),(-1.02637,54.84715,1.67269),(-1.07561,54.85294,1.66648),(-.84754,54.67386,1.42321),(-.76392,54.78067,1.71698),(-.81916,54.85636,1.54439),(-.86977,54.80164,1.35748),(-.26155,53.4585,2.76231),(-.25056,53.53176,2.70558),(-.17732,53.52345,2.72161),(-.51384,54.38425,3.0124),(-.49814,54.27334,2.96465),(-.16398,53.85633,2.9671),(-.32107,53.49359,3.00954),(-.09531,53.84759,2.9966),(-.10268,53.74404,3.03137),(-.12705,54.65318,2.97325),(-.15159,54.64361,3.00892),(-.08675,54.68502,2.99011),(-.08732,54.6756,2.98713),(-.05995,54.6718,3.02001),(-.32502,54.67694,3.02897),(-.26739,54.62546,3.15947),(-.26655,54.62055,3.15908),(-.48576,54.59011,3.03845),(-.50446,54.57529,3.05186),(-.12419,54.69034,2.98228),(-.10863,54.65029,2.94052),(-.05003,54.61424,3.19836),(-.14819,54.6258,3.19305),(-.18395,54.67488,3.10926),(-.1711,54.66901,3.10499),(-.16787,54.657,3.1503),(-.30886,54.38905,3.09415),(-.22016,54.64827,3.16017),(-.2996,54.6744,3.00018),(-.29648,54.66529,2.99289),(-.28424,54.66909,2.95845),(-.35515,54.6596,3.04951),(-.39385,54.63065,3.08764),(-.35173,54.66484,3.05652),(-.46402,54.58435,3.06507),(-.30312,54.69166,2.90259),(-.16932,54.59616,2.89118),(0,54.6348,2.97508),(-.09849,54.59439,2.93097),(-.23877,54.65443,2.87212),(-.24058,54.59671,2.85125),(-.27027,54.59885,2.81727),(-.16745,53.66421,3.04195),(-.10767,53.65955,3.04777),(-.12394,53.52379,2.73062),(-.16534,53.74279,2.60495),(-.12093,53.66527,2.63779),(-.23976,54.45287,2.81674),(-.4666,54.05502,2.4033),(-.57521,53.96654,2.28715),(-.52763,54.06901,2.2947),(-.7818,54.09134,2.58894),(-.61058,54.71982,2.6179),(-.59844,54.69868,2.65361),(-.5563,54.70166,2.63567),(-.70391,54.66015,2.829),(-.69739,54.6268,2.8662),(-.68389,54.65715,2.85512),(0,53.909,2.57159),(0,53.82038,2.57783),(-.30354,53.89917,2.55292),(-.37655,53.90501,2.5061),(-.35041,54.02704,2.5169),(-.45528,53.46035,2.65426),(-.50465,53.48472,2.72521),(-.56182,54.64085,2.94996),(-.58583,54.64945,2.92465),(-.58472,54.60211,2.95567),(-.4803,54.61124,2.92776),(-.47201,54.65786,2.89399),(-.38355,54.6393,2.81265),(-.35942,54.68995,2.80628),(-.3941,54.68569,2.82198),(-.54365,54.66917,2.90338),(-.58396,54.66818,2.86324),(-.46155,54.68541,2.70499),(-.46805,54.68106,2.73928),(-.52979,54.69909,2.63382),(-.49599,54.69903,2.64709),(-.38572,54.69287,2.76525),(-.58165,54.72124,2.53648),(-.56817,54.72503,2.49928),(-.72055,54.62775,2.83033),(-.55214,54.39549,2.95154),(-.44246,53.85855,2.82745),(-.45009,53.8146,2.83847),(-.56014,54.68693,2.42939),(-.56667,54.61297,2.42196),(-.58832,54.57768,2.33703),(-.60921,54.73057,2.40427),(-.58939,54.72948,2.41628),(-.58249,54.61263,2.37349),(0,54.28593,3.07007),(-.05474,54.28674,3.08304),(-.19451,54.62385,3.19182),(-.22856,54.61821,3.1847),(-.35499,54.60495,3.13773),(-.31328,54.61224,3.15628),(-.18146,54.62028,3.19695),(-.2654,54.57322,3.18103),(-.46168,54.53029,3.08774),(-.74195,54.65973,2.72934),(-.46916,54.61077,2.6023),(-.43256,54.60894,2.64005),(-.42937,54.48856,2.63792),(-.5667,54.71936,2.58729),(-.65515,54.73091,2.39862),(-.58852,54.61181,2.33706),(-.46531,53.50214,2.89791),(-.42136,53.47627,2.83537),(-.67794,54.00417,2.61991),(-.03178,53.83779,2.57287),(-.06133,53.86447,2.56064),(-.03332,53.84438,2.56537),(-.06107,53.59295,2.6719),(-.06514,53.45623,2.76978),(-.0312,53.49874,2.74343),(-1.37123,54.96586,1.69857),(-1.41056,54.90885,1.56201),(-1.57085,56.05198,1.32316),(-1.57649,54.38578,.84143),(-1.57021,56.02325,1.3184),(-1.53992,56.00908,1.44654),(-1.73782,56.00835,.46144),(-1.55469,56.31401,1.56386),(-1.5279,56.30771,1.66073),(-1.54774,56.36897,1.64174),(-1.58506,56.38595,1.5279),(-1.50304,56.46309,.10879),(-1.83842,56.04051,.33255),(-1.42548,56.45808,.08109),(-1.43668,56.20075,.02739),(-1.58214,56.06729,.19254),(-1.91663,56.2772,.30994),(-1.92289,56.27883,.30991),(-1.64352,55.2863,.60771),(-1.632,55.86584,.26522),(-1.62736,55.13229,.48201),(-1.63779,55.12704,.46924),(-1.4967,54.30429,.94245),(-1.46812,54.18884,1.13609),(-1.67058,55.95067,.02674),(-1.6486,55.12849,.47712),(-1.61981,54.89601,.57716),(-1.60917,54.67791,.64618),(-1.59464,54.44627,.76591),(-1.62872,54.57917,.75635),(-1.61105,55.85085,.67788),(-1.5977,55.81659,.84438),(-1.42022,55.73703,1.57242),(-1.43259,55.83922,1.59485),(-1.45365,56.08559,1.6439),(-1.45808,56.08193,1.65744),(-1.44513,55.96103,1.63341),(-1.40691,55.64156,1.54727),(-1.63065,55.84172,.18465),(-1.41252,55.77022,1.47491),(-1.41213,55.77629,1.45778),(-1.43539,55.87655,1.48569),(-1.41438,55.80084,1.39098),(-1.41902,55.80709,1.3753),(-1.43521,55.89679,1.43158),(-1.44619,56.01315,1.48273),(-1.45293,56.12789,1.51476),(-1.44695,56.12153,1.53068),(-1.54213,56.03928,1.47695),(-.14349,54.28321,3.06525),(-.17748,54.28203,3.05701),(-.56088,54.49753,2.95672),(-.58625,54.39877,2.92682),(-.09828,54.15332,2.99467),(-.12692,54.15538,2.98663),(-.10337,54.00746,2.99018),(-.57116,54.54774,2.95126),(-.34959,54.53201,3.11777),(-.1911,54.5644,3.18668),(-.45761,54.49308,3.08318),(-1.57666,54.64069,.70764),(-1.57826,54.64834,.73169),(-1.57894,54.59098,.73072),(-1.54346,54.5212,.85457),(-1.53411,54.47524,.8776),(-1.61057,54.65709,.64716),(-1.29663,54.36776,1.2638),(-1.5196,54.87692,1.00115),(-1.56138,54.38383,.8327),(-1.57239,54.65284,.70486),(-1.60884,54.66577,.64219),(-1.64338,54.90003,.69739),(-1.66904,55.10152,.5762),(-1.61648,54.65469,.76608),(-1.60995,54.62116,.78951),(-1.60794,54.68777,.85021),(-1.64095,54.6768,.7121),(-1.55243,55.02058,.792),(-1.58783,54.9421,.65368),(-1.57137,54.96573,.7172),(-1.57233,54.893,.72955),(-.71843,54.15647,1.97286),(-.70821,54.17761,1.97565),(-.65623,54.11536,2.07937),(-.06398,53.58248,2.68041),(-.04245,53.56167,2.69527),(-.12416,54.27736,2.89918),(-.13584,54.21316,2.92642),(-.14251,54.2133,2.94017),(-.14686,54.20394,2.94674),(-.14117,54.19641,2.99086),(-.13382,54.19047,2.99366),(-.12999,54.18873,2.99137),(-.1383,54.18289,2.97721),(-.12569,54.18793,2.9852),(-.13011,54.21006,2.92679),(-.1252,54.22012,2.92174),(-.12889,54.21596,3.01728),(-.12843,54.19685,3.0028),(-.11512,54.19381,2.98055),(-.09843,54.21404,2.99466),(-.11321,54.19612,2.97149),(-.11858,54.21428,2.92903),(-.1121,54.23487,2.92739),(-.11903,54.23835,2.91518),(-.14284,54.18465,2.96999),(-.14506,54.19577,2.94472),(-.2481,54.49036,2.88306),(-.26524,54.42745,2.8874),(-.24321,54.43428,2.87344),(-.20504,54.2585,2.89129),(-.20073,54.29313,2.90897),(-.20659,54.29637,2.88667),(-.20532,54.20873,2.93253),(-.21194,54.2145,2.95147),(-.20107,54.21078,2.93194),(-.20108,54.21852,2.94867),(-.196,54.22068,2.94246),(-.43469,54.34085,2.96974),(-.45825,54.39374,2.95646),(-.4424,54.39242,2.98133),(-.4198,54.28296,2.95129),(-.44301,54.34273,2.94858),(-.32894,54.19367,2.80257),(-.32265,54.11017,2.90188),(-.30326,54.13153,2.80001),(-.31468,54.12557,2.80204),(-.29247,54.07323,2.80428),(-.31111,54.0571,2.81728),(-.30155,54.06501,2.81011),(-.32827,54.1177,2.81149),(-.30406,54.05877,2.87441),(-.33447,54.10345,2.90628),(-.27837,54.08466,2.81542),(-.2931,54.13535,2.81642),(-.26834,54.06897,2.82711),(-.27769,54.08466,2.82327),(-.28693,54.07803,2.80414),(-.27547,54.05805,2.82082),(-.28582,54.04584,2.82547),(-.27905,54.05369,2.82176),(-.29263,54.03873,2.83274),(-.29807,54.03605,2.85316),(-.2945,54.03707,2.85345),(-.41083,54.5414,3.06068),(-.4178,54.56538,3.06726),(-.38501,54.54671,3.05063),(-.65168,54.34298,2.75941),(-.66665,54.31357,2.36147),(-.65693,54.31442,2.35954),(-.64835,54.39075,2.36464),(-.67308,54.24188,2.43282),(-.69422,54.23894,2.44208),(-.69269,54.22247,2.42843),(-.67131,54.23334,2.36815),(-.67034,54.2231,2.3906),(-.75165,54.55846,2.57469),(-.77065,54.61526,2.58362),(-.75723,54.61545,2.59508),(-.49165,54.58672,2.96499),(-.47355,54.55244,2.92238),(-.93864,54.33279,2.01088),(-.96035,54.37665,2.06966),(-.91008,54.30451,2.02903),(-.88853,54.32019,2.05644),(-.88618,54.30119,2.02914),(-.84278,54.31347,1.96649),(-.88869,54.31529,1.95829),(-.87533,54.31355,1.95739),(-.7771,54.30174,2.18845),(-.78401,54.30365,2.17908),(-.8941,54.27405,2.21657),(-.90892,54.31602,2.23848),(-.8525,54.2876,1.98969),(-.83218,54.30154,2.01113),(-.87586,54.24962,2.17779),(-.87424,54.24966,2.17318),(-.91796,54.30433,2.02386),(-.81397,54.31757,2.02401),(-.82417,54.31617,2.03699),(-.80002,54.35778,2.06347),(-.98046,54.44406,1.86471),(-.99961,54.47542,1.88632),(-.97626,54.47326,1.88661),(-1.00089,54.44585,1.86809),(-.85203,54.45635,1.77689),(-.83178,54.48548,1.80181),(-.83303,54.49026,1.7913),(-.88262,54.43399,1.76085),(-.86951,54.42811,1.76427),(-.90422,54.41621,1.75584),(-1.00452,54.38941,1.82013),(-1.00482,54.37911,1.80992),(-1.01446,54.38035,1.81068),(-.95747,54.37565,1.79368),(-.95124,54.385,1.8023),(-.92882,54.38359,1.79353),(-1.01275,54.36388,1.77985),(-1.02034,54.36941,1.79649),(-.81968,54.65997,1.7496),(-1.03027,54.60926,1.54281),(-1.04359,54.60921,1.53076),(-1.06258,54.68371,1.55835),(-.93452,54.6674,1.31803),(-.91953,54.72899,1.3386),(-1.05794,54.65193,1.3693),(-1.08279,54.71547,1.39304),(-.92311,54.66451,1.33971),(-.89039,54.72212,1.38652),(-1.03601,54.55216,1.48101),(-1.04618,54.55328,1.4641),(-1.05279,54.61188,1.50559),(-1.03436,54.56478,1.36682),(-1.04323,54.5241,1.44639),(-1.04596,54.52622,1.43688),(-1.00064,54.52011,1.39561),(-.99895,54.51974,1.39815),(-.97683,54.5375,1.39348),(-1.03336,54.52241,1.38998),(-1.02235,54.5354,1.38698),(-1.04066,54.53485,1.39531),(-.93191,54.6353,1.414),(-.90271,54.71239,1.44122),(-.96421,54.62954,1.41141),(-1.03969,54.51533,1.40044),(-1.0395,54.52124,1.39554),(-1.04501,54.52034,1.3998),(-.95315,54.57187,1.40453),(-.9855,54.5405,1.38705),(-.98544,54.55386,1.32018),(-.97915,54.56048,1.31598),(-1.0849,54.7073,1.43748),(-1.07259,54.70649,1.44467),(-1.02749,54.56495,1.37207),(-1.03118,54.51663,1.39457),(-1.01951,54.51717,1.39354),(-1.0436,54.51349,1.4221),(-1.03795,54.51217,1.4183),(-1.03932,54.51297,1.41366),(-.94405,54.57071,2.23971),(-.96186,54.64084,2.22098),(-.95137,54.63808,2.24744),(-1.05691,54.61689,1.84741),(-.98272,54.61783,1.82122),(-.98169,54.65801,1.81704),(-.80969,54.67629,1.78719),(-1.07256,54.6402,1.75442),(-.77453,54.73404,1.79239),(-1.03481,54.73355,1.68937),(-1.03714,54.70241,1.67572),(-1.05527,54.65727,1.83638),(-1.0899,54.69421,1.87456),(-.87335,54.77615,1.4042),(-.8518,54.82425,1.44031),(-1.01003,54.60896,1.54518),(-1.04107,54.68197,1.57126),(-.69643,54.54138,2.19492),(-.6827,54.5388,2.22105),(-.67174,54.60624,2.21248),(-.68843,54.60526,2.17363),(-.72208,54.54431,2.19233),(1.50659,54.53224,.93525),(1.58624,55.10928,.69898),(1.59782,55.22729,.7123),(1.68685,55.46307,.35198),(1.63027,55.68389,.54797),(1.61559,55.78151,.62931),(1.61885,55.85056,.48559),(1.47672,55.78405,1.21632),(1.54027,55.93343,1.15731),(1.54348,56.04758,.08262),(1.56177,56.04507,.08614),(1.33811,56.38926,-.01033),(1.3512,56.4031,.04558),(1.49429,56.5285,1.69245),(1.51081,56.56529,1.71956),(1.64559,56.43171,-.10131),(1.75678,56.4175,-.05749),(1.66737,56.36076,-.12789),(1.53885,55.84643,1.18258),(1.49219,55.69776,1.47125),(1.545,55.57456,1.13316),(1.53615,55.69251,1.15218),(1.70654,55.5837,.28454),(1.6077,55.49873,.95628),(1.62284,55.63335,.88152),(1.58331,55.63452,1.0074),(1.74846,55.86944,.44134),(1.73697,55.71988,.16664),(1.70932,55.94933,.5341),(1.96533,56.21807,.241),(1.97893,56.26409,.2251),(1.52098,56.541,.0536),(1.43762,56.52506,.035),(1.38209,56.33022,-.08088),(1.53325,56.27665,-.13791),(1.91731,56.3711,.2423),(1.86899,56.42499,.18025),(1.66284,56.4582,.14868),(1.76911,56.41752,.16707),(1.76652,56.34486,-.07798),(1.76594,56.27549,-.07331),(1.67668,56.28252,-.13084),(1.5772,56.46777,.13429),(1.59166,56.37098,.097),(1.37283,56.47897,-.02607),(1.36321,56.45724,-.04897),(1.71071,55.72111,.16456),(1.70671,55.69994,.21181),(1.42608,56.19304,.02126),(1.38497,56.28783,.0247),(1.4651,56.29587,.04194),(1.49828,56.19923,.03477),(1.89915,56.24399,.31194),(1.89592,56.16335,.35063),(1.91428,56.24167,.32697),(1.95989,56.25106,.17488),(1.95355,56.297,.1396),(1.84842,56.00139,.27656),(1.89388,56.06168,.2074),(1.90925,56.09069,.26537),(1.7148,56.12953,.31488),(1.67423,56.12988,.25638),(1.65459,56.08165,.30812),(1.65943,55.61995,.71491),(1.65268,55.98135,.80557),(1.64703,55.93993,.79845),(1.68299,55.96562,.67175),(1.48112,56.35801,1.58951),(1.52332,56.37553,1.53373),(1.50011,56.26533,1.49815),(1.69404,56.032,.57343),(1.70781,56.01973,.57671),(1.73072,56.0564,.45416),(1.72359,56.0738,.46425),(1.76432,55.72795,.31496),(1.76018,55.71551,.22917),(1.73867,55.93915,.07785),(1.74261,55.72927,.48195),(1.768,55.84132,.40173),(1.57541,56.50956,1.63627),(1.6221,55.34394,.74928),(1.54774,54.94345,.84654),(1.55525,55.03354,.81465),(1.36638,55.23754,1.53409),(1.2763,55.22196,1.39813),(1.6353,55.425,.66202),(1.60248,55.48765,.78475),(1.4719,55.48156,1.0398),(1.43924,55.3679,1.06691),(1.43332,55.05463,1.10445),(1.45091,55.17137,1.0444),(1.57806,56.50203,1.5054),(1.57592,56.5798,1.57337),(1.53998,56.59256,1.65068),(1.56834,56.57505,1.57237),(1.5173,56.54992,1.64028),(1.5741,56.32144,1.37048),(1.56538,56.31804,1.38251),(1.5633,56.41568,1.44435),(1.40667,54.45819,1.0989),(1.4365,54.36094,1.03348),(1.49707,54.60274,1.21007),(1.45827,54.66188,1.34729),(1.49266,54.57694,1.22137),(1.23964,55.19352,1.27662),(1.1572,55.01915,1.28969),(.76548,54.6662,2.68628),(1.2969,54.2659,1.69689),(1.12559,53.81503,1.88313),(1.17173,54.01501,2.06855),(1.19083,54.29737,2.05405),(1.22842,54.44426,1.98169),(1.17783,54.31786,2.0696),(1.17398,54.25272,1.43035),(1.10532,54.34998,1.44277),(1.19253,54.42707,1.31487),(1.01704,54.41142,1.40511),(.9844,54.56784,1.29947),(.94584,54.49233,1.39475),(1.06861,54.67193,1.27169),(1.14954,54.81585,1.26594),(1.40699,54.271,1.44273),(1.13773,54.59889,1.28089),(1.11348,54.75727,1.89952),(1.07651,54.77972,1.9393),(1.17327,54.73846,1.91142),(1.14046,54.75124,1.9073),(1.02821,54.74765,2.04939),(1.20558,54.8938,1.50899),(1.23035,54.89529,1.4991),(.66458,54.71784,2.13397),(.6786,54.67228,2.13056),(.69114,54.6754,2.09218),(1.06959,54.76765,1.75329),(1.07281,54.81175,1.75437),(1.03243,54.8125,1.71591),(1.11584,54.85707,1.45504),(1.11668,54.89264,1.46274),(1.10231,54.81688,1.50795),(1.11395,54.81465,1.51511),(1.11436,54.81366,1.48617),(.84488,54.8149,1.47135),(.86604,54.81814,1.46405),(.86308,54.87924,1.3882),(.87478,54.88122,1.38197),(.84263,54.85194,1.5671),(.82292,54.74021,1.5714),(.80077,54.73625,1.61515),(.64732,54.70925,2.17622),(.62714,54.6657,2.15715),(.94647,53.78287,2.43611),(.91577,53.67157,2.07902),(.95301,53.70928,2.00278),(.86165,54.7154,2.44311),(.79869,54.7076,2.49668),(.86276,54.68736,2.47999),(.80668,54.69593,2.57452),(.78325,54.69598,2.60156),(.90808,54.66586,2.42927),(.81275,54.70186,2.53131),(.85564,54.66156,2.54105),(.85132,54.66064,2.57183),(.88176,54.58873,2.54552),(.89329,54.74621,2.35597),(.93259,54.75097,2.34057),(.97866,54.75471,2.17481),(.98579,54.75572,2.17358),(.91817,54.76387,1.98038),(.86955,54.75422,1.9629),(.85587,54.818,1.67882),(.80078,54.81652,1.69553),(1.14879,53.89055,1.69543),(1.19727,53.93823,1.62109),(.98521,54.89283,1.38761),(.86814,54.84871,1.57662),(.84576,54.85199,1.56232),(.83221,54.86992,1.43064),(.83244,54.83691,1.4263),(.82496,54.74952,1.53894),(.62622,54.71341,2.32715),(.65515,54.73091,2.39862),(.67958,54.7294,2.40412),(.8313,54.06643,2.537),(1.09993,54.52706,2.09617),(1.16679,54.54037,2.00306),(1.13363,54.58326,2.00925),(1.35146,54.96784,1.70252),(1.10768,54.83829,1.73798),(.84099,53.59586,2.23335),(.73326,54.66466,1.95555),(.74672,54.72587,1.91193),(.8245,54.81116,1.54436),(.76304,54.7204,1.68626),(.84053,54.77179,1.41802),(.81045,54.09101,2.55462),(.87823,54.12603,2.49801),(.86578,54.25528,2.53751),(.10575,54.44485,2.8926),(.17275,54.44886,2.8545),(.17472,53.43419,2.89854),(.26232,53.45098,2.76892),(.37124,53.67692,3.00494),(.33315,53.67778,3.01976),(.33563,53.60119,3.04863),(.32844,53.75532,2.96359),(.2536,54.01079,2.93024),(.1714,53.59137,3.0546),(.1747,53.51088,3.04616),(.03698,54.62912,3.18003),(.03202,54.64102,3.1434),(.33217,54.56671,3.14313),(.19284,54.58422,3.1923),(.14609,54.61576,3.19129),(.14547,54.60213,3.18559),(.12317,54.59946,3.20055),(.10139,54.59866,3.20931),(.07906,54.60626,3.20631),(.10358,54.60355,3.20969),(.1492,54.68279,3.0223),(.15959,54.65292,3.05384),(.19606,54.67659,3.06599),(.19608,54.66742,3.06004),(.22706,54.6369,3.15209),(.20884,54.64496,3.13528),(.20941,54.65671,3.14037),(.35515,54.6596,3.04951),(.39385,54.63065,3.08764),(.35569,54.60446,3.03995),(.26739,54.62546,3.15947),(.26811,54.62521,3.1618),(.28875,54.63134,3.15004),(.31884,54.68337,3.00331),(.15372,54.68865,3.02126),(.04321,54.6684,3.06147),(.04956,54.66287,3.06115),(.16322,54.64775,3.17478),(.15713,54.64263,3.16956),(.14819,54.6258,3.19305),(.07331,54.60284,3.21118),(.10536,54.60248,3.21523),(.06162,54.57167,3.22634),(.19133,54.64841,3.17182),(.18662,54.66413,3.14873),(.22354,54.68115,2.94091),(.19485,54.68292,2.97972),(.21799,54.6826,2.93933),(.19106,54.68261,3.06595),(.31215,54.65536,3.08742),(.30748,54.63908,3.13196),(.18351,54.65158,2.90255),(.16941,54.65329,2.91527),(.17061,54.50516,3.18186),(.11232,54.50425,3.20755),(.10908,54.39054,3.14823),(.05341,54.51704,3.21206),(.13936,54.65115,2.92844),(.12879,54.59515,2.91391),(.09949,53.53032,3.03164),(.13405,53.44374,2.7667),(.18392,53.44432,2.77151),(.12427,53.587,2.66991),(.16858,53.58944,2.65385),(.76914,54.07095,2.61149),(.76202,54.04516,2.63088),(.68566,54.71124,2.66849),(.66971,54.69091,2.70824),(.40667,53.69412,2.51753),(.55434,53.72438,2.81843),(.62025,53.87087,2.72737),(.23683,54.13508,2.65127),(.23793,54.00984,2.59917),(.1347,53.96496,2.57731),(.40073,54.66247,2.69744),(.46604,54.69521,2.67226),(.65827,54.65644,2.87066),(.66218,54.62497,2.89432),(.30512,54.6947,2.84585),(.30078,54.69425,2.87737),(.31091,54.69352,2.8473),(.49857,54.65796,2.92054),(.50694,54.64693,2.95761),(.34174,54.66076,2.75323),(.69497,54.67712,2.74478),(.69901,54.71176,2.62848),(.52912,54.67909,2.57717),(.44456,54.67807,2.85202),(.47398,54.69285,2.83006),(.70057,54.70568,2.62171),(.56516,54.7294,2.46348),(.57908,54.72545,2.44003),(.57205,54.72714,2.46662),(.57077,54.69664,2.43387),(.61151,54.72809,2.40724),(.58659,54.69699,2.4123),(.63193,54.72741,2.39915),(.55582,54.54395,2.98137),(.50446,54.57529,3.05186),(.5125,54.53423,3.04538),(.20432,54.38932,3.1251),(.23962,54.38553,3.12623),(.17748,54.28203,3.05701),(.19172,54.01005,2.95874),(.15228,54.01087,2.97517),(.62247,54.1594,2.83209),(.6345,54.29866,2.8674),(.5842,54.28504,2.90294),(.33679,54.53399,3.1305),(.2654,54.57322,3.18103),(.71245,54.66846,2.79219),(.74195,54.65973,2.72934),(.75098,54.64224,2.72371),(.36626,54.47315,2.71668),(.39596,54.60711,2.67794),(.42937,54.48856,2.63792),(.46916,54.61077,2.6023),(.26355,53.45129,2.76871),(.35734,53.43859,2.7449),(.25019,53.45161,2.97532),(.45769,53.80442,2.8534),(0,53.9489,2.59628),(.06881,53.93632,2.56377),(.06243,53.93322,2.55732),(.04344,53.95469,2.57199),(.00529,53.91098,2.56996),(.01118,53.91269,2.56341),(.06913,53.66198,2.62911),(.0798,53.66422,2.63853),(.04336,53.62774,2.64621),(.11837,53.57785,2.6783),(1.43191,55.24861,1.64912),(1.48078,55.20737,1.51246),(1.48401,55.36563,1.53392),(1.40437,55.10842,1.66639),(1.32927,54.84871,1.74101),(1.31027,54.72757,1.81853),(1.3373,54.8512,1.74558),(1.32084,54.71554,1.78298),(1.31666,54.72452,1.79916),(1.77704,55.96477,.37395),(1.46648,55.50317,1.653),(1.48823,55.53611,1.5741),(1.46721,55.6019,1.66561),(1.58229,55.99175,1.19171),(1.5978,55.93632,1.04708),(1.58089,56.02433,1.20491),(1.57465,56.36745,1.53539),(1.57425,56.38027,1.59844),(1.54821,56.41057,1.67481),(1.5794,56.19527,1.35894),(1.58544,56.31917,1.43822),(1.5853,56.40988,1.53255),(1.85366,56.3585,.21325),(1.36631,56.34672,.03411),(1.38013,56.35095,.04151),(1.36365,56.40251,.05515),(1.84922,56.35115,.21637),(1.08658,54.88283,1.29871),(1.09944,54.86691,1.28557),(1.48654,55.06858,1.04382),(1.63133,54.89169,.56266),(1.67585,55.95165,.02428),(1.72574,55.71457,.15739),(1.70978,55.58035,.24615),(1.54772,55.72029,.95714),(1.5107,56.26615,1.49018),(1.4836,56.15686,1.44804),(1.48089,56.04757,1.39819),(1.48359,55.93728,1.34324),(1.47614,56.32193,1.7008),(1.48045,56.42395,1.72543),(1.56097,56.48398,1.54695),(1.55,56.48168,1.55524),(1.63065,55.84172,.18465),(1.68341,55.70679,.29775),(1.43762,55.99303,1.53704),(1.44188,56.11526,1.54766),(1.44661,55.99803,1.52114),(1.50825,55.95749,1.65464),(1.50766,55.86051,1.64219),(.30724,54.15439,2.93937),(.36375,54.49797,3.10313),(.16635,54.54907,3.19645),(.25704,54.50316,3.17967),(.33704,54.49931,3.11593),(1.5422,54.94331,.82316),(1.52233,54.40022,.87675),(1.53411,54.47524,.8776),(1.54346,54.5212,.85457),(1.56224,54.54883,.79415),(1.57575,54.49174,.80949),(1.54874,54.8356,.82566),(1.52305,54.78463,.94319),(1.55476,54.89115,.8982),(1.54445,54.6878,.83626),(1.53362,54.94391,.97096),(1.55251,54.54196,.78326),(1.56331,54.55462,.76142),(1.58938,54.49886,.73485),(1.55766,54.51937,.78863),(1.55215,54.39353,1.03122),(1.62102,54.59437,.77769),(1.57803,54.43069,.90501),(1.71492,55.45651,.45417),(1.69267,55.30398,.5143),(1.57249,54.48183,.79875),(1.60591,55.01789,.60452),(1.60373,54.99268,.59386),(1.61779,55.06266,.53187),(1.56536,54.94248,.72077),(1.55651,54.94293,.77026),(1.62576,55.26745,.59074),(1.05096,54.68809,1.27269),(.68669,53.52515,2.43977),(.53473,53.5379,2.52549),(.59697,53.60615,2.36522),(.64183,53.56565,2.40236),(1.62134,55.18435,.58076),(.0572,53.71038,2.60409),(.10767,54.31098,3.0949),(.12615,54.31362,3.09039),(.1237,54.27754,3.06667),(.13689,54.28114,3.05757),(.14202,54.28688,3.0392),(.13549,54.25516,3.02143),(.11099,54.20984,3.01651),(.09907,54.24471,3.04697),(.10612,54.2277,2.94243),(.09957,54.2716,2.92111),(.11903,54.23835,2.91518),(.12416,54.27736,2.89918),(.10853,54.27712,2.90113),(.12941,54.24293,2.91027),(.12358,54.19411,3.00067),(.13382,54.19047,2.99366),(.14137,54.18342,2.96648),(.13678,54.19183,2.94268),(.14296,54.19185,2.94738),(.23533,54.23053,2.96587),(.22185,54.2131,2.93674),(.21724,54.21379,2.94607),(.20504,54.2585,2.89129),(.19596,54.22791,2.9092),(.22416,54.25758,2.88146),(.21331,54.25961,2.88293),(.20761,54.2317,2.89643),(.28291,54.38985,3.0363),(.27245,54.43981,3.07947),(.29033,54.44203,3.06189),(.23932,54.24419,2.89482),(.25557,54.28204,2.89497),(.24474,54.28925,2.8753),(.20797,54.20809,2.93053),(.20184,54.21664,2.9091),(.20158,54.23046,2.90142),(.29928,54.44015,2.80054),(.28796,54.38701,2.81273),(.29793,54.38766,2.7984),(.3009,54.32654,2.7982),(.29484,54.26225,2.81615),(.29881,54.2625,2.80238),(.35049,54.23552,2.95353),(.35339,54.17103,2.93983),(.29831,54.19916,2.80548),(.3176,54.04574,2.86557),(.26898,54.0671,2.82314),(.29622,54.03616,2.84256),(.32136,54.04646,2.84148),(.29716,54.03791,2.85791),(.61928,54.34207,2.78673),(.62037,54.28193,2.75375),(.49947,54.36029,2.62307),(.48059,54.35947,2.64589),(.49413,54.295,2.65541),(.61725,54.23683,2.73007),(.48994,54.29345,2.67481),(.51034,54.2442,2.68895),(.50603,54.24538,2.67718),(.5251,54.20096,2.68254),(.52274,54.20204,2.67118),(.61837,54.44962,2.37815),(.60205,54.44951,2.3864),(.61093,54.38852,2.37753),(.60082,54.38598,2.39253),(.61864,54.31192,2.38559),(.68078,54.29348,2.47258),(.64547,54.29729,2.45404),(.66393,54.24466,2.42438),(.62597,54.30271,2.43382),(.65203,54.24714,2.40917),(.6356,54.31703,2.36478),(.62638,54.3159,2.37125),(.65385,54.25482,2.36889),(.68372,54.22422,2.42546),(.66551,54.25592,2.35859),(.67463,54.23436,2.363),(.68852,54.25227,2.36702),(.67802,54.2533,2.36229),(.68214,54.2338,2.36546),(.68086,54.22583,2.36952),(.67802,54.23415,2.36378),(.67537,54.22004,2.40847),(.67231,54.22163,2.39852),(.32376,54.38437,2.78505),(.35035,54.37925,2.79313),(.3544,54.65361,2.80575),(.31412,54.59161,2.81636),(.34683,54.58894,2.8015),(.30639,54.58978,2.83663),(.32366,54.65706,2.82615),(.93043,54.42651,2.26357),(.926,54.36813,2.24469),(.80216,54.38073,1.9857),(.78315,54.3728,2.00965),(.81808,54.3249,1.98744),(.85848,54.38771,1.98315),(.83634,54.38575,1.98087),(.85476,54.3351,1.95995),(.95163,54.38974,2.01919),(.92285,54.33815,1.97771),(.92687,54.30521,2.01696),(.91255,54.31744,2.22114),(.83356,54.30906,1.98301),(.85357,54.29023,1.97961),(.85976,54.29338,1.96904),(.80967,54.26684,2.17044),(.80235,54.26519,2.1778),(.82986,54.24572,2.17115),(.87958,54.25199,2.17752),(.87814,54.25069,2.19114),(.84109,54.2456,2.16953),(.83788,54.248,2.16767),(.79789,54.30662,2.17283),(.75524,54.35159,2.1888),(.78401,54.30365,2.17908),(.82227,54.61759,1.70878),(.80536,54.62018,1.69342),(.79259,54.6641,1.72861),(.80751,54.53504,1.8209),(1.08838,54.59109,1.71419),(1.07732,54.5865,1.72188),(1.08575,54.54442,1.69261),(1.03523,54.46032,1.84507),(1.03362,54.4454,1.81356),(1.03012,54.43604,1.83129),(1.0414,54.4695,1.82967),(1.00001,54.4225,1.84897),(1.01354,54.41045,1.83274),(1.00223,54.40676,1.83454),(.90565,54.39345,1.75429),(.90634,54.38931,1.76363),(.91962,54.38068,1.76121),(.9919,54.36782,1.79254),(.9818,54.36787,1.78927),(.9666,54.36872,1.78449),(.92321,54.38607,1.75381),(.93688,54.37251,1.75959),(1.07478,54.41114,1.65397),(1.07405,54.42549,1.6657),(1.08779,54.42509,1.65472),(.96934,54.41673,1.63409),(.97781,54.41706,1.6473),(.99712,54.40502,1.63939),(.94191,54.36928,1.76953),(.96067,54.36387,1.76697),(.9387,54.37581,1.75283),(.95911,54.36876,1.75531),(.99706,54.36083,1.78296),(.95381,54.36828,1.77862),(.96706,54.36169,1.77356),(1.02357,54.39845,1.63014),(1.01957,54.39865,1.62728),(1.05671,54.39983,1.63931),(1.05004,54.39927,1.63882),(1.05074,54.40621,1.6579),(.79681,54.66268,1.73993),(.7821,54.64145,1.8063),(.78985,54.59965,1.80905),(1.0849,54.7073,1.43748),(.92311,54.66451,1.33971),(1.05211,54.56019,1.42253),(1.0504,54.56327,1.41195),(1.04652,54.53374,1.40083),(1.03579,54.52347,1.45274),(1.03879,54.51304,1.42724),(1.03176,54.51313,1.4294),(1.01147,54.53623,1.34419),(1.01197,54.53883,1.35134),(1.01714,54.53814,1.3482),(.93191,54.6353,1.414),(.91539,54.63399,1.42129),(.99118,54.55861,1.31378),(.98401,54.56027,1.31401),(.98952,54.55265,1.31936),(.96249,54.70743,2.10349),(.93937,54.6461,2.07897),(.96628,54.64829,2.09797),(.96547,54.56294,2.1716),(.98197,54.56513,2.15006),(1.03082,54.77249,1.70844),(.9791,54.77256,1.68323),(.98308,54.72183,1.66943),(1.07256,54.6402,1.75442),(.99478,54.63029,1.75627),(.98675,54.66721,1.78688),(1.05691,54.61689,1.84741),(1.07377,54.65892,1.84411),(.79282,54.64298,1.79351),(.77755,54.68254,1.78581),(1.06338,54.61585,1.85241),(1.07208,54.61125,1.87072),(1.0942,54.75212,1.84949),(1.09722,54.70273,1.83157),(1.05651,54.69309,1.82467),(1.08878,54.68358,1.78441),(1.09118,54.71782,1.77531),(1.08239,54.68189,1.78759),(1.06363,54.67518,1.79347),(.78344,54.6895,1.75086),(.77918,54.68471,1.77483),(.88554,54.69516,1.5296),(.93348,54.61539,1.51725),(.91866,54.62043,1.50465),(.70723,54.54064,2.12596),(.70396,54.54317,2.10468),(.6788,54.61024,2.15768),(.68968,54.60581,2.16623),(.72702,54.54078,2.13828),(.6869,54.61295,2.12735),(.65438,54.57621,2.39186),(.67265,54.57587,2.39961),(.67212,54.63585,2.40276),(.65109,54.63688,2.39729),(.90561,54.68977,1.54258),(1.07999,54.65894,1.84916),(.78333,54.68167,1.78479),(1.05622,54.69177,1.83173),(.77565,54.67948,1.8015),(.66636,54.6688,2.1741),(.97941,54.646,2.16707),(.93372,54.7055,2.07597),(1.03946,54.5888,1.38894),(1.00587,54.52161,1.3919),(1.00064,54.52011,1.39561),(1.00868,54.51669,1.39801),(1.02479,54.52381,1.45238),(1.04919,54.53179,1.40774),(.81416,54.64531,1.79081),(1.0658,54.40984,1.65765),(.99375,54.40561,1.63121),(.99299,54.36097,1.78163),(.95853,54.36736,1.75839),(1.08096,54.41154,1.64542),(.97689,54.37758,1.79969),(.99143,54.37814,1.80457),(1.01356,54.427,1.84335),(1.07534,54.53725,1.70351),(.7883,54.59488,1.82319),(.77454,54.35446,2.18283),(.94849,54.37306,2.08089),(.83413,54.24454,2.17264),(.87954,54.25135,2.18366),(.877,54.25202,2.17307),(.91644,54.31596,1.97135),(.92555,54.31356,1.9836),(.93827,54.33016,2.03262),(.93444,54.39054,2.00765),(.93813,54.42863,2.24265),(.30993,54.65784,2.8466),(.32746,54.4378,2.78361),(.67209,54.2266,2.41395),(.67781,54.22599,2.36951),(.68989,54.23254,2.37093),(.65966,54.25519,2.36248),(.70124,54.29239,2.47379),(.59569,54.38189,2.414),(.62303,54.38992,2.36882),(.49404,54.29147,2.69337),(.6082,54.23627,2.74007),(.51015,54.29611,2.64251),(.60682,54.28095,2.76538),(.36696,54.22991,2.96207),(.29313,54.32638,2.81272),(.29156,54.43844,2.82005),(.20018,54.21561,2.9156),(.20876,54.20834,2.92828),(.2305,54.25231,2.88575),(.26782,54.38664,3.05652),(.21386,54.22974,2.89309),(.24166,54.23148,2.95039),(.21246,54.33792,3.03003),(.2254,54.30056,3.0194),(.21259,54.30448,3.01114),(.22806,54.33481,3.03748),(.09214,54.26539,2.94686),(.11167,54.24493,3.05),(.1337,54.25094,3.03518),(.10827,54.27411,3.07314),(.06477,53.71325,2.61367),(1.23321,54.9599,1.23435),(1.133,54.83257,1.27144),(1.6118,55.24187,.6487),(1.56029,54.98813,.75979),(1.57874,54.99013,.71447),(1.54931,54.36579,.8711),(1.59076,54.51277,.8916),(1.59386,54.50142,.84073),(1.57239,54.65284,.70486),(1.46884,54.43956,.9824),(.57116,54.54774,2.95126),(1.45949,56.2363,1.58271),(1.44084,56.10955,1.56469),(1.69822,55.71415,.32595),(1.47029,55.71374,1.16724),(1.471,55.77887,1.22546),(1.4738,56.3259,1.68709),(1.47456,56.04249,1.40931),(1.47787,56.15126,1.46042),(1.63804,56.03186,.36021),(1.5977,55.81659,.84438),(1.68242,55.95298,.02432),(1.67781,55.7013,.27346),(1.84295,56.31611,.21638),(1.81471,56.18954,.31035),(1.56695,56.18381,1.384),(1.5514,56.39023,1.66287),(1.57413,56.30979,1.46511),(1.53185,54.56864,1.09632),(1.34096,54.41338,1.58978),(1.33045,54.43312,1.61863),(1.63006,54.64682,.74745),(1.63315,54.68427,.74866),(1.39737,55.11202,1.67588),(.16963,53.58015,2.66252),(.35503,53.44619,2.73831),(.35755,53.43825,2.74261),(.0396,53.50247,2.73942),(.06649,53.53323,2.73394),(.06799,53.46727,2.76229),(.03178,53.83779,2.57287),(.10872,53.74483,2.60457),(.07184,53.74467,2.60038),(.06462,54.09558,2.67225),(.69537,53.98284,2.61168),(.73102,53.98067,2.56834),(.37383,53.76609,2.91784),(.394,53.74335,2.94548),(.41307,53.68511,2.96999),(.56845,54.56094,2.40522),(.61611,54.44233,2.1991),(.41407,54.6924,2.73595),(.55515,53.47387,2.56995),(.36193,54.6054,2.7133),(.75327,54.54287,2.77325),(.48052,54.68679,2.77779),(.51118,54.67939,2.81337),(.11186,54.56648,3.22758),(.16517,54.58644,3.20535),(.34418,54.63912,3.12624),(.04759,54.00505,3.00178),(.60806,54.69595,2.40361),(.56719,54.69487,2.46175),(.74121,54.70063,2.62197),(.478,54.66447,2.89137),(.39828,54.69182,2.8175),(.66495,54.68369,2.71256),(.04215,53.92302,2.55571),(.30552,54.69037,2.875),(.1457,54.11343,2.66421),(.63985,53.75175,2.73278),(.30719,53.68219,2.57505),(.10112,53.45336,2.90321),(.10358,53.59507,3.05288),(.16342,54.38994,3.13439),(.3317,54.67441,3.00519),(.16787,54.657,3.1503),(.03913,54.63471,3.14058),(.30555,54.68094,2.99871),(.28816,54.62996,3.14753),(.38828,54.5849,3.06392),(.16171,54.67244,3.05877),(.07933,54.60083,3.20469),(.24982,53.50203,3.04161),(.36554,54.38938,3.06986),(.43839,54.38369,3.06314),(.34477,54.27513,3.01366),(.1001,54.26335,2.80047),(.7424,54.02354,2.53148),(.81474,54.23066,2.60125),(.82026,54.82044,1.4956),(.79599,54.59582,1.63021),(.64515,54.70947,2.22067),(.64336,54.61966,2.11023),(1.06221,54.84117,1.70649),(1.04559,54.72154,2.06262),(1.14014,54.48108,2.05222),(.90092,54.70002,2.41639),(.7823,54.71357,2.47577),(.74759,54.71876,1.97081),(.8339,54.82593,1.59231),(.97757,54.81387,1.68685),(1.04935,53.91792,2.28407),(1.02646,54.90305,1.39035),(.8379,54.84494,1.46723),(1.09942,54.86147,1.43042),(1.47895,54.37492,1.24774),(1.67388,55.62473,.4623),(1.66199,55.65208,.51038),(1.57323,56.41658,1.44053),(1.35824,55.45953,1.38812),(1.37089,55.52703,1.38998),(1.60915,55.92195,.35483),(1.54653,55.86177,1.08893),(1.67901,55.99419,.68473),(1.47115,56.24517,1.55694),(1.60192,56.13687,.20224),(1.61689,56.13738,.21162),(1.963,56.31659,.18377),(1.94462,56.34635,.21849),(1.91658,56.30207,.07158),(1.91369,56.34306,.07965),(1.42347,56.49374,.07309),(1.96196,56.2911,.26261),(1.75706,55.91694,.41193),(1.72738,55.75489,.5275),(1.50831,56.49794,1.75827),(1.53919,56.5047,1.70904),(1.53016,56.56173,1.72799),(1.55865,55.67617,1.07954),(1.5525,55.56912,1.109),(1.73461,55.59405,.38809),(1.43676,55.38407,1.65062),(1.49793,55.33059,1.03562),(-.67453,54.60828,2.18283),(-1.01094,54.68284,1.57054),(-.87215,54.77235,1.42217),(-.98643,54.69555,1.65315),(-.81066,54.67764,1.78031),(-.95843,54.70048,2.2183),(-.95206,54.56813,2.25976),(-1.04569,54.51706,1.41628),(-1.01822,54.52279,1.38731),(-.98419,54.55405,1.32097),(-.96352,54.57527,1.39359),(-.98074,54.54948,1.33866),(-.97822,54.55221,1.34645),(-.97364,54.55336,1.33991),(-.94794,54.70731,1.44531),(-.97562,54.53492,1.40561),(-1.03735,54.56726,1.35919),(-.91731,54.65994,1.36584),(-.83065,54.54398,1.79818),(-.96342,54.43305,1.65861),(-1.01075,54.41915,1.66402),(-.9954,54.43693,1.67021),(-.98609,54.41772,1.65357),(-.96814,54.38081,1.75275),(-.97743,54.37017,1.75651),(-.94868,54.37954,1.75053),(-1.02091,54.37511,1.78704),(-.94106,54.37622,1.78593),(-1.01399,54.39236,1.81925),(-.88296,54.40933,1.75824),(-.86742,54.46102,1.76969),(-.85354,54.45085,1.78655),(-1.04034,54.40417,1.61346),(-1.04544,54.40432,1.61512),(-1.05047,54.40445,1.61682),(-.78347,54.36028,2.05003),(-.87575,54.29552,1.96635),(-.85712,54.28695,1.99447),(-.80235,54.26519,2.1778),(-.8868,54.33767,1.96299),(-.95914,54.38519,2.04168),(-.47936,54.54693,2.95392),(-.76473,54.55892,2.56763),(-.66551,54.25592,2.35859),(-.66316,54.38967,2.37003),(-.38828,54.5849,3.06392),(-.29529,54.13451,2.80381),(-.34936,54.09707,2.8968),(-.36127,54.09452,2.87113),(-.3464,54.10833,2.81958),(-.33621,54.25573,2.80289),(-.4232,54.285,2.93055),(-.19979,54.21192,2.92986),(-.22806,54.33481,3.03748),(-.24997,54.38598,3.06731),(-.23119,54.38789,3.06761),(-.24566,54.33217,3.03977),(-.27035,54.48211,2.90326),(-.1447,54.18719,2.97035),(-.14357,54.18552,2.97057),(-.14419,54.20292,2.93797),(-.09936,54.21661,2.98176),(-.13315,54.20015,3.00175),(-.13241,54.2246,2.919),(-.12287,54.18893,2.97587),(-.14624,54.19256,2.97798),(-.13499,54.27545,2.92332),(-1.6493,55.29853,.48823),(-1.66101,55.34772,.45398),(-1.63935,55.30405,.53857),(-.03455,53.56842,2.69145),(-1.62557,55.07634,.50526),(-1.57494,54.76858,.69138),(-1.61854,55.16729,.56206),(-1.61826,55.07731,.54982),(-1.59799,54.99099,.61073),(-1.57281,54.38533,.96418),(-1.56178,54.41024,.9633),(-1.54528,54.41691,1.01764),(-1.57141,54.5303,.96438),(-1.53638,54.44362,1.04282),(-1.54238,54.38701,.8429),(-1.57477,54.66828,.70731),(-1.5438,54.84387,.80152),(-.20315,54.50491,3.17567),(-.19244,54.54518,3.1799),(-.58343,54.58348,2.95336),(-.55361,54.00966,2.814),(-1.39621,55.68489,1.42626),(-1.39673,55.6783,1.44323),(-1.38269,55.61613,1.40905),(-1.45018,56.00584,1.50002),(-1.43924,55.88941,1.44866),(-1.42663,55.87168,1.50172),(-1.39708,55.56385,1.53496),(-1.44581,55.96458,1.61942),(-1.43338,55.83555,1.60837),(-1.67585,55.95165,.02428),(-1.51147,56.38047,.07167),(-1.52265,56.30978,1.69124),(-1.5848,56.39992,1.60336),(-1.57425,56.38027,1.59844),(-1.64041,55.8905,.79853),(-1.67766,55.92344,.64928),(-1.48401,55.36563,1.53392),(-1.48625,55.18943,1.48417),(-1.16523,54.0287,2.08725),(-.40582,53.61138,2.52383),(-.4079,53.60623,2.52882),(-.49831,53.60706,2.45078),(-.26232,53.45098,2.76892),(-.6872,54.04661,2.58042),(-.22809,53.86302,2.9269),(-.28674,53.4481,2.95354),(-.39161,53.50008,2.95079),(-.54671,54.68299,2.46464),(-.32967,54.60313,2.74964),(-.76202,54.04516,2.63088),(-.71659,54.52872,2.84659),(-.36204,54.56253,3.13443),(-.47709,54.14896,2.89652),(-.58013,54.72637,2.54366),(-.46301,54.68757,2.74274),(-.04215,53.92302,2.55571),(-.06243,53.93322,2.55732),(-.54964,54.67265,2.83992),(-.46463,54.62101,2.8878),(-.31193,54.02736,2.56409),(-.65827,54.65644,2.87066),(-.75926,54.21515,2.67151),(-.50186,53.94517,2.39009),(-.17183,54.26649,2.78369),(-.16924,53.66598,2.62827),(-.08462,54.64888,2.94508),(-.22244,54.65164,2.87995),(-.31255,54.68775,2.93733),(-.46154,54.58558,3.06198),(-.39254,54.63206,3.09506),(-.24454,54.63166,3.16545),(-.1815,54.68447,3.06403),(-.1682,54.67918,3.05902),(-.17674,54.69012,3.02493),(-.06079,54.61753,3.19444),(-.31398,54.67264,3.04022),(-.12472,54.67617,2.98404),(-.07331,54.60284,3.21118),(-.40744,54.27323,2.9998),(-.85909,54.79133,1.37783),(-.88861,54.7381,1.33592),(-1.12396,54.86003,1.65235),(-.75214,54.77305,1.76711),(-.74698,54.76622,1.79009),(-.74243,54.70335,1.76006),(-.65515,54.46515,2.07753),(-1.08724,54.73906,1.94429),(-1.0424,54.71422,2.0868),(-1.07245,54.58895,2.12057),(-1.06029,54.68265,2.06495),(-.99419,54.23617,2.31978),(-1.07123,54.31518,2.19999),(-1.00474,54.20335,2.30216),(-1.2034,54.22091,2.01606),(-1.17805,54.24748,2.07887),(-.60308,54.59482,2.25153),(-.84556,54.84303,1.39737),(-.83221,54.86992,1.43064),(-.83886,54.8719,1.43451),(-.83388,54.86516,1.46645),(-.76585,54.80115,1.77221),(-1.09796,54.79653,1.86337),(-.65441,54.71377,2.26512),(-.72655,54.74212,2.3882),(-.69328,54.72656,2.31444),(-.79094,54.67327,2.33977),(-1.11122,54.90674,1.43157),(-1.12262,54.84965,1.51712),(-1.02458,54.81529,1.48716),(-1.12136,54.84398,1.52045),(-1.0654,54.82326,1.60653),(-.94482,54.69686,2.25319),(-.90439,54.82144,1.6704),(-1.21065,53.91671,1.71839),(-1.38877,55.11226,1.66666),(-.76888,54.64872,2.69107),(-1.49093,54.98804,1.31092),(-1.54628,54.55449,1.04922),(-1.37924,54.54118,1.16379),(-1.54889,55.7865,1.01618),(-1.53171,55.76959,1.0508),(-1.5797,56.01853,1.03485),(-1.44429,55.60014,1.13585),(-1.64998,55.28533,.46699),(-1.77811,55.94086,.11319),(-1.81273,55.95243,.16737),(-1.70046,55.30114,.48873),(-1.6663,56.00168,.67523),(-1.66371,55.75985,.68146),(-1.35425,56.33248,-.01204),(-1.59044,56.51077,.11563),(-1.6959,56.51036,.09372),(-1.53449,56.11209,.06059),(-1.51319,55.85555,1.59918),(-1.52528,55.93552,1.54533),(-1.50211,55.52207,1.25334),(-1.58969,56.49558,1.51374),(-1.51334,56.0449,1.62094),(-1.35824,55.45953,1.38812),(-1.45665,55.64298,1.13943),(-1.3745,55.59011,1.25376),(-1.54874,54.8356,.82566),(-1.61942,54.68881,.76921),(-1.53141,54.61625,.87681),(-1.63315,54.68427,.74866),(-1.44342,55.70634,1.68239),(-1.33811,56.38926,-.01033),(-1.51081,56.56529,1.71956),(-1.73461,55.59405,.38809),(-1.58331,55.63452,1.0074),(-1.5525,55.56912,1.109),(-1.55865,55.67617,1.07954),(-1.53016,56.56173,1.72799),(-1.53919,56.5047,1.70904),(-1.50831,56.49794,1.75827),(-1.67349,55.59386,.36815),(-1.62284,55.63335,.88152),(-1.6077,55.49873,.95628),(-1.96196,56.2911,.26261),(-1.67668,56.28252,-.13084),(-1.71569,56.51605,.04652),(-1.95989,56.25106,.17488),(-1.84873,55.96407,.22739),(-1.65943,55.61995,.71491),(-1.48112,56.35801,1.58951),(-1.57541,56.50956,1.63627),(-1.55525,55.03354,.81465),(-1.61975,55.96968,.42464),(-1.66199,55.65208,.51038),(-1.67388,55.62473,.4623),(-.81045,54.09101,2.55462),(-1.14954,54.81585,1.26594),(-1.23035,54.89529,1.4991),(-.97372,54.7067,2.14061),(-1.06959,54.76765,1.75329),(-1.09942,54.86147,1.43042),(-1.02646,54.90305,1.39035),(-.64732,54.70925,2.17622),(-.88176,54.58873,2.54552),(-.97885,54.82229,1.68194),(-1.06221,54.84117,1.70649),(-1.14879,53.89055,1.69543),(-.86814,54.84871,1.57662),(-.92958,54.50988,1.39671),(-.74214,54.73985,1.87269),(-.84053,54.77179,1.41802),(-.19172,54.01005,2.95874),(-.10358,54.60355,3.20969),(-.15959,54.65292,3.05384),(-.19608,54.66742,3.06004),(-.20884,54.64496,3.13528),(-.49851,54.60905,2.99791),(-.12879,54.59515,2.91391),(-.04321,54.6684,3.06147),(-.03913,54.63471,3.14058),(-.30748,54.63908,3.13196),(-.10358,53.59507,3.05288),(-.10112,53.45336,2.90321),(-.31528,54.16477,2.61006),(-.30719,53.68219,2.57505),(-.55434,53.72438,2.81843),(-.23793,54.00984,2.59917),(-.34174,54.66076,2.75323),(-.69497,54.67712,2.74478),(-.70057,54.70568,2.62171),(-.57908,54.72545,2.44003),(-.59187,54.72548,2.42026),(-.15228,54.01087,2.97517),(-.04759,54.00505,3.00178),(-.6345,54.29866,2.8674),(-.39596,54.60711,2.67794),(-.61611,54.44233,2.1991),(-.25019,53.45161,2.97532),(-.45769,53.80442,2.8534),(-.01118,53.91269,2.56341),(-1.63006,54.64682,.74745),(-1.33045,54.43312,1.61863),(-1.34096,54.41338,1.58978),(-1.768,55.84132,.40173),(-1.53185,54.56864,1.09632),(-1.5794,56.19527,1.35894),(-1.58544,56.31917,1.43822),(-1.68341,55.70679,.29775),(-1.67781,55.7013,.27346),(-1.63804,56.03186,.36021),(-1.4836,56.15686,1.44804),(-1.48089,56.04757,1.39819),(-1.4738,56.3259,1.68709),(-1.55,56.48168,1.55524),(-1.43762,55.99303,1.53704),(-1.45949,56.2363,1.58271),(-.30724,54.15439,2.93937),(-1.52305,54.78463,.94319),(-1.54445,54.6878,.83626),(-1.55215,54.39353,1.03122),(-1.69267,55.30398,.5143),(-1.60373,54.99268,.59386),(-1.61779,55.06266,.53187),(-.12427,53.587,2.66991),(-.0572,53.71038,2.60409),(-.10767,54.31098,3.0949),(-.09907,54.24471,3.04697),(-.10853,54.27712,2.90113),(-.14296,54.19185,2.94738),(-.21259,54.30448,3.01114),(-.21246,54.33792,3.03003),(-.2254,54.30056,3.0194),(-.23533,54.23053,2.96587),(-.22416,54.25758,2.88146),(-.28291,54.38985,3.0363),(-.25557,54.28204,2.89497),(-.20018,54.21561,2.9156),(-.29928,54.44015,2.80054),(-.3009,54.32654,2.7982),(-.35049,54.23552,2.95353),(-.29831,54.19916,2.80548),(-.29716,54.03791,2.85791),(-.49947,54.36029,2.62307),(-.61725,54.23683,2.73007),(-.51034,54.2442,2.68895),(-.61837,54.44962,2.37815),(-.61749,54.30872,2.40141),(-.65385,54.25482,2.36889),(-.70467,54.22267,2.42048),(-.68989,54.23254,2.37093),(-.67781,54.22599,2.36951),(-.67209,54.2266,2.41395),(-.69213,54.21704,2.42022),(-.69707,54.21713,2.41731),(-.3585,54.43191,2.78697),(-.30639,54.58978,2.83663),(-.92892,54.37074,2.22639),(-.81808,54.3249,1.98744),(-.85848,54.38771,1.98315),(-.93444,54.39054,2.00765),(-.89837,54.27598,2.19139),(-.92555,54.31356,1.9836),(-.86538,54.25281,2.16595),(-.93033,54.37084,2.08662),(-.83317,54.51799,1.85691),(-1.03523,54.46032,1.84507),(-1.00001,54.4225,1.84897),(-.90634,54.38931,1.76363),(-1.08096,54.41154,1.64542),(-.99299,54.36097,1.78163),(-.99375,54.40561,1.63121),(-1.05004,54.39927,1.63882),(-1.05211,54.56019,1.42253),(-1.02479,54.52381,1.45238),(-1.00868,54.51669,1.39801),(-1.00587,54.52161,1.3919),(-1.05127,54.62329,1.43191),(-.96249,54.70743,2.10349),(-.96547,54.56294,2.1716),(-.66636,54.6688,2.1741),(-.77565,54.67948,1.8015),(-1.0942,54.75212,1.84949),(-1.05651,54.69309,1.82467),(-1.09118,54.71782,1.77531),(-.78344,54.6895,1.75086),(-.67212,54.63585,2.40276),(-.67265,54.57587,2.39961),(-.65109,54.63688,2.39729),(-.65438,54.57621,2.39186),(-.72702,54.54078,2.13828),(1.66273,55.10353,.50836),(1.3745,55.59011,1.25376),(1.45665,55.64298,1.13943),(1.56865,56.50049,1.5079),(1.65905,55.1033,.71644),(1.62019,56.53743,.01772),(1.60725,56.51316,-.04378),(1.54545,56.54656,.00135),(1.91079,56.39573,.11262),(1.75424,56.33774,.16201),(1.79498,56.47543,.13584),(1.47103,56.1791,-.04836),(1.64359,56.20596,.14702),(1.66545,55.9017,.64771),(1.63692,55.99085,.7929),(1.47233,56.41536,1.75878),(1.35733,55.54079,1.2733),(1.36901,55.58432,1.2752),(1.54935,56.30552,1.40787),(1.47047,55.019,1.41774),(.81546,54.01753,2.5773),(1.00036,53.75124,1.9273),(1.46603,54.42093,1.29009),(.90439,54.82144,1.6704),(1.02315,54.82312,1.60421),(1.02534,54.83469,1.49355),(1.16647,54.8718,1.62175),(1.12207,54.87164,1.56656),(1.1111,54.86534,1.58896),(1.13182,54.87895,1.52526),(1.13054,54.88591,1.50192),(.90667,54.84877,1.59681),(.74044,54.75535,1.82634),(.74912,54.74188,2.34273),(.67098,54.66158,2.28919),(.72655,54.74212,2.3882),(.76645,54.74592,2.0468),(.9594,54.76053,2.10561),(.9299,54.7668,2.07264),(.774,54.80133,1.7731),(1.06461,54.8997,1.407),(.90295,54.88575,1.38128),(.74851,54.71865,1.9593),(1.17805,54.24748,2.07887),(1.2034,54.22091,2.01606),(1.00474,54.20335,2.30216),(1.07123,54.31518,2.19999),(.99419,54.23617,2.31978),(1.06029,54.68265,2.06495),(.74243,54.70335,1.76006),(.74698,54.76622,1.79009),(.75214,54.77305,1.76711),(.82291,54.78536,1.59846),(1.12396,54.86003,1.65235),(.81916,54.85636,1.54439),(.15159,54.64361,3.00892),(.08732,54.6756,2.98713),(.1711,54.66901,3.10499),(.18395,54.67488,3.10926),(.22016,54.64827,3.16017),(.46402,54.58435,3.06507),(.42359,54.59453,3.0879),(.32502,54.67694,3.02897),(.16932,54.59616,2.89118),(.12394,53.52379,2.73062),(.37655,53.90501,2.5061),(.45528,53.46035,2.65426),(.50465,53.48472,2.72521),(.23313,53.87778,2.58736),(.4803,54.61124,2.92776),(.54964,54.67265,2.83992),(.35942,54.68995,2.80628),(.46805,54.68106,2.73928),(.62309,54.65751,2.86304),(.2835,54.27692,3.03057),(.22856,54.61821,3.1847),(.19451,54.62385,3.19182),(.31328,54.61224,3.15628),(.46531,53.50214,2.89791),(.67794,54.00417,2.61991),(.26155,53.4585,2.76231),(1.16523,54.0287,2.08725),(1.48625,55.18943,1.48417),(1.67766,55.92344,.64928),(1.64041,55.8905,.79853),(1.52265,56.30978,1.69124),(1.43259,55.83922,1.59485),(1.44513,55.96103,1.63341),(1.43539,55.87655,1.48569),(1.43521,55.89679,1.43158),(1.44619,56.01315,1.48273),(.58625,54.39877,2.92682),(.10337,54.00746,2.99018),(.09828,54.15332,2.99467),(1.5196,54.87692,1.00115),(1.56138,54.38383,.8327),(1.66904,55.10152,.5762),(1.60995,54.62116,.78951),(1.68718,55.46667,.376),(.65623,54.11536,2.07937),(.70821,54.17761,1.97565),(.71843,54.15647,1.97286),(.12569,54.18793,2.9852),(.12889,54.21596,3.01728),(.11512,54.19381,2.98055),(.14506,54.19577,2.94472),(.1447,54.18719,2.97035),(.2481,54.49036,2.88306),(.23119,54.38789,3.06761),(.24566,54.33217,3.03977),(.24997,54.38598,3.06731),(.19979,54.21192,2.92986),(.45825,54.39374,2.95646),(.32894,54.19367,2.80257),(.31468,54.12557,2.80204),(.30326,54.13153,2.80001),(.32827,54.1177,2.81149),(.30406,54.05877,2.87441),(.2931,54.13535,2.81642),(.27547,54.05805,2.82082),(.64922,54.34805,2.70253),(.64835,54.39075,2.36464),(.6509,54.24983,2.38519),(.67131,54.23334,2.36815),(.75165,54.55846,2.57469),(.89075,54.3643,2.08732),(.91008,54.30451,2.02903),(.88618,54.30119,2.02914),(.8868,54.33767,1.96299),(.83218,54.30154,2.01113),(.87575,54.29552,1.96635),(.81397,54.31757,2.02401),(.84379,54.57311,1.90637),(.97626,54.47326,1.88661),(1.00089,54.44585,1.86809),(.98046,54.44406,1.86471),(.99961,54.47542,1.88632),(.83178,54.48548,1.80181),(1.09017,54.44455,1.66073),(1.01399,54.39236,1.81925),(.94106,54.37622,1.78593),(1.02473,54.3916,1.79259),(1.02091,54.37511,1.78704),(.97743,54.37017,1.75651),(.83065,54.54398,1.79818),(.93452,54.6674,1.31803),(1.08279,54.71547,1.39304),(1.05279,54.61188,1.50559),(1.03436,54.56478,1.36682),(1.04323,54.5241,1.44639),(.97139,54.55682,1.33435),(.97822,54.55221,1.34645),(.98074,54.54948,1.33866),(.9855,54.5405,1.38705),(1.0436,54.51349,1.4221),(.95206,54.56813,2.25976),(.80969,54.67629,1.78719),(.77453,54.73404,1.79239),(.87335,54.77615,1.4042),(1.01003,54.60896,1.54518),(.72208,54.54431,2.19233),(.67602,54.60256,2.28573),(.68546,54.53643,2.25366),(.67324,54.60416,2.25193),(.68889,54.53505,2.28415),(.8453,54.61966,2.34517),(.80666,54.54614,2.33066),(.79743,54.61448,2.33389),(.85292,54.55093,2.34208),(.6986,54.60428,2.30323),(.90043,54.62661,2.34107),(.65513,54.49674,2.38151),(.66943,54.4963,2.38788),(.61627,54.57769,2.39447),(.62989,54.63849,2.39225),(.60981,54.63866,2.39996),(.63489,54.57731,2.38719),(.77671,54.5674,2.48266),(.79756,54.6179,2.51979),(.78385,54.62123,2.489),(.78945,54.56523,2.51257),(.69273,54.6334,2.41752),(.69102,54.5745,2.41341),(.8004,54.66886,2.56873),(.80626,54.67145,2.52756),(.79194,54.61542,2.5592),(.74278,54.68174,2.45459),(.69819,54.68741,2.42456),(.73638,54.6278,2.44969),(.62954,54.69492,2.39496),(.71423,54.47558,2.20014),(.73894,54.47804,2.1972),(.7644,54.34751,2.26289),(.7783,54.30015,2.22963),(.74939,54.34636,2.25116),(.78956,54.301,2.23934),(.72076,54.40165,2.24558),(.74699,54.34827,2.2025),(.72179,54.40408,2.21586),(.74578,54.34616,2.22854),(.82204,54.41085,2.30768),(.80207,54.35124,2.27735),(.79016,54.40738,2.30066),(.83023,54.3543,2.28357),(.70371,54.46742,2.28417),(.70102,54.46871,2.25617),(.7249,54.4013,2.27108),(.85815,54.41475,2.31625),(.81197,54.47787,2.32565),(.85462,54.48239,2.33561),(.69941,54.4704,2.22349),(.7609,54.44045,2.45221),(.73764,54.37675,2.415),(.75055,54.37343,2.4311),(.74594,54.44272,2.43248),(.65097,54.45159,2.37529),(.66677,54.45103,2.38283),(.72573,54.49203,2.42525),(.72027,54.44503,2.41667),(.75147,54.4895,2.44412),(.63712,54.49728,2.37837),(.63388,54.45247,2.37176),(.6881,54.49592,2.39983),(.73175,54.57133,2.44297),(.88936,54.71841,1.40538),(.88759,54.77095,1.43582),(.90555,54.71622,1.42074),(.88045,54.77136,1.45721),(.93725,54.81672,1.47459),(.94185,54.76914,1.46332),(1.02446,54.76309,1.46915),(.95234,54.70973,1.43689),(.94668,54.7654,1.45505),(1.01895,54.70642,1.44829),(.87421,54.70683,1.47209),(.913,54.62991,1.44825),(.87924,54.71102,1.44837),(.93056,54.68739,1.5505),(.95161,54.61339,1.52519),(.92509,54.78427,1.3523),(.93281,54.72823,1.33272),(.90871,54.78399,1.35719),(1.08534,54.77725,1.39296),(1.09935,54.77397,1.4156),(1.07217,54.71883,1.37174),(.95995,54.72627,1.32943),(.99046,54.77995,1.354),(.95718,54.78305,1.35031),(.98828,54.72308,1.33209),(.94794,54.70731,1.44531),(1.02111,54.76644,1.47783),(1.01447,54.70152,1.45672),(.89234,54.74894,1.55345),(.86833,54.75332,1.54066),(1.02108,54.83474,1.38325),(1.0527,54.77772,1.37073),(1.05711,54.83352,1.39498),(1.02078,54.779,1.35982),(.91002,54.83705,1.37117),(.89076,54.83599,1.37509),(1.1059,54.76611,1.45048),(1.11732,54.82299,1.47585),(1.10289,54.76047,1.46211),(.91475,54.79582,1.57102),(.88142,54.79674,1.56223),(.92195,54.74732,1.56167),(1.05188,54.74393,1.58489),(1.01651,54.74397,1.58307),(1.10945,54.80792,1.54662),(1.09805,54.76075,1.51665),(1.09549,54.75688,1.53548),(1.11211,54.81183,1.52805),(.85448,54.76429,1.48546),(.83968,54.80345,1.52969),(.85535,54.75686,1.52168),(.83896,54.8109,1.49151),(.91953,54.69,1.64071),(.94883,54.71999,1.66322),(.91449,54.71822,1.65706),(.95304,54.69268,1.64682),(.80055,54.67015,1.69565),(.78865,54.69535,1.72164),(.89618,54.67841,1.79458),(.90099,54.66449,1.76964),(.83196,54.66158,1.92684),(.79712,54.62994,1.8782),(.79026,54.66573,1.88354),(.83721,54.62597,1.91924),(1.06816,54.6498,1.90266),(1.04179,54.67768,1.94138),(1.07297,54.6865,1.90837),(1.03839,54.64146,1.9343),(.89769,54.65316,1.80157),(.98077,54.6819,1.81675),(.89549,54.67704,1.80132),(.91014,54.62287,1.73422),(.896,54.67774,1.79798),(.8323,54.58329,1.64757),(.83461,54.63904,1.6377),(.80736,54.62876,1.66984),(.85714,54.59197,1.62089),(.9814,54.68259,1.81338),(.95745,54.66546,1.62998),(.98977,54.66752,1.63859),(.8273,54.6769,1.6577),(.77193,54.72986,1.81371),(1.06913,54.73688,1.92019),(1.08606,54.74458,1.88652),(1.07397,54.7266,1.73384),(.86459,54.71398,1.65689),(.81649,54.75709,1.68802),(.82024,54.70672,1.67525),(.86076,54.76442,1.66996),(.78654,54.7161,1.89541),(.77305,54.67531,1.82294),(.76934,54.72569,1.83505),(.97684,54.6682,1.96131),(1.01468,54.67167,1.96098),(.95172,54.63497,2.21612),(.92718,54.5696,2.22673),(.77414,54.60248,2.18293),(.87211,54.56111,2.20725),(.87024,54.61329,2.19764),(.77921,54.55113,2.19159),(.8573,54.63815,2.04828),(.82701,54.5701,2.02617),(.86325,54.57261,2.03472),(.81956,54.63415,2.0396),(.71281,54.55071,2.06491),(.69767,54.61661,2.08629),(.98009,54.57106,2.11444),(.9775,54.64757,2.13508),(.90378,54.57547,2.04298),(.89959,54.64271,2.05628),(.85071,54.69672,2.05412),(.813,54.69268,2.04549),(.94113,54.63527,2.27519),(.93442,54.63273,2.30586),(.97283,54.70479,2.17278),(.97372,54.7067,2.14061),(1.02479,54.51329,1.42914),(1.0222,54.51263,1.41818),(1.01778,54.51386,1.42607),(1.02649,54.51217,1.42003),(1.04078,54.5148,1.40324),(1.04668,54.51937,1.40409),(1.02749,54.56495,1.37207),(1.00184,54.51618,1.41539),(1.008,54.51525,1.40612),(.99901,54.51776,1.40786),(1.00958,54.51442,1.41041),(.9795,54.55164,1.33353),(.9945,54.55064,1.31995),(.99756,54.55613,1.31524),(1.01424,54.54676,1.32576),(1.00979,54.54062,1.33292),(1.0169,54.54334,1.33302),(1.00782,54.54319,1.32745),(1.00162,54.54193,1.3535),(.98929,54.54482,1.34358),(.98773,54.54735,1.35165),(1.00118,54.53973,1.34564),(.93651,54.59811,1.36007),(.92822,54.655,1.39588),(.94483,54.59658,1.36963),(.91854,54.65617,1.38463),(.90271,54.71239,1.44122),(.96421,54.62954,1.41141),(1.01716,54.5678,1.39486),(1.05127,54.62329,1.43191),(1.01128,54.62425,1.41839),(1.04506,54.56505,1.40563),(1.01134,54.58814,1.39015),(.96846,54.64868,1.41177),(1.02033,54.6457,1.42293),(.9702,54.58894,1.38084),(1.00532,54.56173,1.37131),(1.00468,54.57588,1.31472),(1.00802,54.55109,1.31926),(1.01621,54.57404,1.3201),(1.00308,54.55378,1.31676),(.97084,54.57884,1.30992),(.96538,54.57872,1.31237),(1.0183,54.53889,1.3447),(.98615,54.52746,1.43857),(.97869,54.5298,1.43215),(1.00726,54.51513,1.42077),(1.01422,54.52419,1.45161),(1.04658,54.51828,1.40997),(1.04944,54.52933,1.41944),(.95339,54.56125,1.46426),(.97454,54.53156,1.42234),(.94841,54.56344,1.45015),(.99856,54.55349,1.49095),(1.00463,54.52489,1.4476),(.98632,54.55442,1.48531),(1.05279,54.55613,1.43925),(1.02844,54.57225,1.33118),(1.04435,54.59403,1.35218),(1.03587,54.59718,1.33556),(1.03434,54.56994,1.34285),(.98201,54.57863,1.30938),(.98817,54.60388,1.3084),(.97215,54.60623,1.30538),(.99386,54.57711,1.31173),(.9583,54.57683,1.32335),(.94576,54.60642,1.31553),(.94029,54.60484,1.3261),(.96236,54.57815,1.31601),(1.02713,54.65711,1.33178),(1.04431,54.65558,1.34815),(1.01881,54.59957,1.31992),(.95692,54.60688,1.30646),(.96398,54.66585,1.31138),(.94408,54.66714,1.31297),(.93561,54.60124,1.3454),(.9512,54.56858,1.42106),(.96279,54.55784,1.47315),(.97444,54.55637,1.47846),(1.02635,54.55216,1.49127),(1.01218,54.55273,1.4914),(1.0056,54.65993,1.32114),(1.0142,54.72178,1.33673),(.98559,54.66205,1.31535),(1.05743,54.61415,1.47917),(1.07167,54.68846,1.53878),(1.07813,54.69199,1.51597),(1.07696,54.7464,1.57397),(1.08824,54.75265,1.55397),(1.04046,54.51395,1.40802),(1.03118,54.51663,1.39457),(1.03579,54.51187,1.42027),(1.03149,54.51199,1.42027),(1.01951,54.51717,1.39354),(1.01694,54.51334,1.41516),(1.01233,54.51386,1.41306),(1.00788,54.51642,1.39969),(1.01665,54.41142,1.78045),(1.02326,54.4302,1.79196),(1.01673,54.43223,1.78586),(1.04698,54.55468,1.84535),(1.0298,54.51218,1.8221),(1.0366,54.50932,1.82743),(1.04001,54.55664,1.83971),(1.07086,54.48092,1.688),(1.06354,54.5004,1.69661),(1.07133,54.50173,1.69326),(1.063,54.47978,1.69116),(1.06197,54.40056,1.63844),(.93983,54.44767,1.66098),(.95558,54.43149,1.65191),(.93052,54.4464,1.65425),(.96342,54.43305,1.65861),(.87233,54.52637,1.66852),(.85312,54.57483,1.68969),(.88135,54.52593,1.67401),(.84398,54.57508,1.68503),(1.06884,54.58469,1.72474),(1.0104,54.53313,1.70463),(1.00215,54.58086,1.72901),(1.06738,54.53619,1.70673),(1.06852,54.46052,1.68642),(1.03833,54.43942,1.67723),(1.03195,54.45608,1.6845),(1.06616,54.4415,1.67727),(1.02427,54.4055,1.65124),(1.02917,54.39845,1.6328),(1.00403,54.4058,1.64603),(1.03638,54.39868,1.63524),(.96772,54.47148,1.68029),(.92162,54.46511,1.6656),(.98023,54.45247,1.6748),(.92295,54.57924,1.71152),(.98778,54.41071,1.76564),(.98447,54.43076,1.76967),(.97336,54.56006,1.81724),(.97605,54.51244,1.80098),(.91343,54.5078,1.78637),(.85208,54.49584,1.78342),(.92158,54.47228,1.77109),(.93642,54.39117,1.75119),(.95313,54.40705,1.75318),(.92209,54.4,1.75307),(.95986,54.39395,1.75256),(1.0257,54.40215,1.61537),(1.01377,54.41475,1.60106),(1.00253,54.41187,1.60709),(1.03261,54.40345,1.613),(1.05164,54.41724,1.60766),(1.05794,54.40409,1.62173),(1.06659,54.41625,1.61653),(1.05047,54.40445,1.61682),(.98649,54.36118,1.77952),(1.06715,54.43103,1.61805),(1.04775,54.43208,1.60431),(1.00106,54.42961,1.59645),(.98348,54.42528,1.60344),(1.04554,54.42062,1.66929),(1.01075,54.41915,1.66402),(.92611,54.37719,1.77427),(1.02426,54.38493,1.80449),(.9954,54.43693,1.67021),(1.06471,54.4509,1.61594),(1.04059,54.45239,1.60071),(.98213,54.44645,1.58975),(.96038,54.4415,1.60221),(.99029,54.38893,1.81475),(.97426,54.38809,1.8088),(.94372,54.43223,1.63558),(.92192,54.45036,1.62038),(.91819,54.44708,1.63727),(.94579,54.43501,1.62128),(1.06241,54.47015,1.61677),(1.03246,54.47343,1.59897),(.98573,54.40523,1.82949),(1.02933,54.42683,1.80488),(.89671,54.3988,1.7875),(.9139,54.38438,1.77889),(.88537,54.40463,1.76849),(.96885,54.40373,1.82299),(.93745,54.45762,1.5995),(.94899,54.48629,1.58843),(.92124,54.4784,1.60139),(.96279,54.46517,1.58705),(1.02283,54.47533,1.68827),(1.05581,54.49011,1.61585),(1.02347,54.49298,1.5988),(.98337,54.42096,1.84292),(1.02745,54.45004,1.79888),(1.07497,54.48536,1.64674),(1.08289,54.50556,1.67968),(1.07448,54.51142,1.65079),(1.08474,54.48368,1.672),(.98113,54.49097,1.58868),(.99231,54.51899,1.59414),(.96919,54.51747,1.59032),(1.00275,54.49145,1.59274),(.88341,54.48971,1.6484),(.90543,54.47084,1.62327),(.88543,54.49558,1.62814),(.9005,54.46632,1.6432),(.87224,54.42297,1.77586),(.95696,54.44187,1.85827),(.93105,54.41536,1.82827),(.92118,54.43639,1.84791),(.9616,54.41873,1.83704),(1.01685,54.45086,1.85889),(.95742,54.49351,1.68482),(.94243,54.53077,1.69071),(1.0175,54.49713,1.69527),(1.01483,54.52039,1.59857),(1.04447,54.55653,1.62247),(1.00587,54.55884,1.60152),(1.04934,54.51774,1.61685),(.90495,54.50433,1.60402),(.91701,54.55339,1.5918),(.88221,54.5461,1.60676),(.93536,54.51242,1.58901),(.97737,54.47752,1.78484),(.94686,54.47175,1.88256),(.90802,54.46714,1.87331),(1.0182,54.48179,1.87749),(1.03808,54.49253,1.85989),(.86185,54.53433,1.63136),(.82821,54.57724,1.67319),(.85869,54.52849,1.65466),(1.07402,54.54936,1.65857),(1.0743,54.59754,1.67717),(.95517,54.55675,1.592),(.96761,54.6061,1.6098),(.9385,54.60467,1.60471),(.98081,54.5578,1.59666),(1.04887,54.53947,1.88171),(1.04649,54.50159,1.84516),(1.05664,54.54714,1.86295),(.80792,54.53926,1.8076),(.94445,54.51108,1.90636),(.89806,54.50682,1.89678),(1.07834,54.66205,1.70213),(.97609,54.51385,1.91002),(.94275,54.57724,1.93274),(.97613,54.57954,1.93836),(1.06098,54.60423,1.89528),(1.01023,54.5833,1.93981),(.97627,54.63276,1.95272),(1.01243,54.63594,1.95303),(.89366,54.28925,1.99584),(.89036,54.28943,2.00426),(.89644,54.29004,1.99964),(.88848,54.28811,1.99845),(.88781,54.2768,2.17289),(.90211,54.32114,2.1857),(.82037,54.26832,2.16475),(.84176,54.29912,2.01763),(.86157,54.28658,1.99852),(.86584,54.28649,2.00185),(.86419,54.2862,1.99486),(.86776,54.28598,1.99772),(.88133,54.29341,1.97008),(.88168,54.2961,1.96659),(.87586,54.29286,1.9698),(.85759,54.28853,1.98063),(.8626,54.29096,1.97186),(.89828,54.29173,1.98666),(.90163,54.29138,1.99501),(.90267,54.29336,1.98708),(.89764,54.29046,1.99224),(.8319,54.24385,2.18023),(.82762,54.24497,2.18002),(.84309,54.2459,2.19757),(.83498,54.24376,2.18918),(.83238,54.24471,2.1928),(.8445,54.24475,2.19334),(.8756,54.24932,2.18274),(.87437,54.24883,2.18887),(.84722,54.25021,2.16346),(.86496,54.2487,2.16894),(.86538,54.25281,2.16595),(.84831,54.24669,2.16652),(.94166,54.49977,2.23797),(.92178,54.49809,2.22495),(.82827,54.31079,2.16594),(.86966,54.27417,2.16341),(.87684,54.31646,2.17323),(.83982,54.27062,2.15769),(.87475,54.49175,2.20837),(.78905,54.48235,2.195),(.8434,54.31483,2.04636),(.82791,54.35616,2.07693),(.85415,54.29763,2.02539),(.78596,54.54358,2.15813),(.74466,54.48899,2.11919),(.79717,54.49183,2.13654),(.88196,54.27244,2.23111),(.87094,54.24907,2.2002),(.87245,54.25284,2.1689),(.81179,54.26265,2.21513),(.82818,54.24437,2.1888),(.80396,54.26205,2.20773),(.90078,54.29537,1.97792),(.92843,54.30888,1.99972),(.86347,54.30901,2.26167),(.89144,54.31269,2.25872),(.86366,54.26846,2.23142),(.80341,54.26209,2.19322),(.77536,54.29977,2.21051),(.81085,54.31961,2.0125),(.86215,54.35775,2.29114),(.8989,54.36237,2.28846),(.96035,54.37665,2.06966),(.88234,54.38912,1.98862),(.77719,54.365,2.03478),(.89975,54.41999,2.3132),(.75338,54.41356,2.07733),(.74839,54.41562,2.0581),(.9733,54.43786,2.06789),(.9636,54.4427,2.04354),(.87865,54.43989,2.00507),(.84933,54.43789,1.99827),(.90359,54.48839,2.33294),(.94805,54.49804,2.2561),(.93227,54.43079,2.22527),(.75695,54.42144,2.02852),(.75398,54.50129,2.01643),(.72797,54.49311,2.04804),(.78,54.43003,2.00186),(.97525,54.43011,2.09696),(.96762,54.50892,2.14783),(.98282,54.51173,2.12925),(.96095,54.42802,2.11332),(.91042,54.51669,2.02535),(.94258,54.44281,2.029),(.94685,54.51724,2.04494),(.91151,54.44234,2.01153),(.93349,54.49359,2.30425),(.9058,54.5573,2.33985),(.93762,54.56283,2.30903),(.80566,54.50859,2.00673),(.7935,54.56705,2.0223),(.83754,54.51149,2.01002),(.72031,54.49112,2.08806),(.72462,54.489,2.10531),(.97257,54.51664,2.06439),(.96844,54.57559,2.0815),(.98211,54.51284,2.09349),(.48076,54.64249,2.76411),(.46951,54.58079,2.7235),(.46477,54.6459,2.73183),(.48452,54.5776,2.7538),(.55164,54.56995,2.81368),(.51314,54.49766,2.77344),(.51248,54.57373,2.78655),(.55032,54.49408,2.7992),(.46287,54.5838,2.69191),(.47169,54.50931,2.65734),(.46881,54.58601,2.66424),(.46604,54.50722,2.6836),(.51053,54.63837,2.79897),(.30576,54.51311,2.80336),(.29798,54.51139,2.82297),(.33772,54.51051,2.78883),(.37163,54.58449,2.80684),(.36197,54.50616,2.79405),(.30589,54.65358,2.87245),(.30308,54.58673,2.86075),(.47554,54.35762,2.66919),(.54795,54.34562,2.77089),(.52386,54.28751,2.73228),(.51501,54.34879,2.74807),(.54975,54.28467,2.75078),(.51467,54.41351,2.7586),(.49151,54.35204,2.72053),(.49005,54.41691,2.72977),(.49839,54.42555,2.62766),(.49558,54.51065,2.63222),(.47624,54.42431,2.65094),(.4866,54.50133,2.74235),(.41567,54.36273,2.83994),(.45187,54.40408,2.89252),(.42957,54.41472,2.84436),(.43665,54.35297,2.88527),(.46164,54.47485,2.9069),(.44089,54.48527,2.85689),(.62575,54.56414,2.53597),(.60151,54.48892,2.48549),(.59317,54.56787,2.50364),(.62773,54.4858,2.5132),(.74318,54.48101,2.54982),(.7296,54.55828,2.58361),(.72133,54.48096,2.55603),(.57253,54.63491,2.45316),(.58449,54.57674,2.41986),(.57529,54.63765,2.42757),(.58189,54.57435,2.44352),(.65638,54.62078,2.58156),(.62218,54.6234,2.55516),(.6588,54.56137,2.56109),(.76426,54.66888,2.60628),(.77814,54.6687,2.59422),(.62104,54.68266,2.57074),(.58477,54.62768,2.51843),(.57927,54.68875,2.53227),(.73914,54.66996,2.61811),(.73309,54.6165,2.60636),(.68259,54.49274,2.76146),(.68284,54.56605,2.80552),(.69099,54.56854,2.77389),(.67487,54.49038,2.79147),(.58557,54.50602,2.64846),(.62112,54.5795,2.67655),(.58881,54.58254,2.65482),(.61624,54.50314,2.66909),(.62625,54.64452,2.68176),(.59184,54.64776,2.65861),(.64477,54.56437,2.83987),(.61562,54.62966,2.85571),(.65138,54.6284,2.85574),(.61118,54.56556,2.83984),(.67801,54.57274,2.73111),(.70063,54.63284,2.78547),(.68683,54.63732,2.73989),(.68468,54.21796,2.41784),(.68173,54.21699,2.40906),(.67979,54.21894,2.41445),(.68566,54.21635,2.41144),(.67503,54.22103,2.38835),(.67149,54.22476,2.38029),(.67544,54.22227,2.38125),(.67875,54.22292,2.37635),(.67552,54.22562,2.37293),(.6803,54.22328,2.37373),(.68962,54.22467,2.37516),(.69352,54.22105,2.38308),(.69516,54.22366,2.3798),(.68875,54.22202,2.37884),(.70129,54.21801,2.39795),(.70497,54.21831,2.40711),(.70537,54.21985,2.39879),(.70093,54.21708,2.40316),(.69738,54.23125,2.37682),(.69989,54.22245,2.38514),(.70364,54.22988,2.38317),(.70994,54.22336,2.41274),(.71179,54.22767,2.40173),(.69213,54.21704,2.42022),(.66664,54.23011,2.38114),(.68466,54.22563,2.37079),(.66764,54.23145,2.37593),(.65019,54.25341,2.37622),(.6691,54.23217,2.37235),(.71686,54.24801,2.39437),(.72305,54.2451,2.41017),(.708,54.2298,2.39044),(.7095,54.24963,2.3837),(.73391,54.30285,2.41187),(.72366,54.30582,2.3992),(.64388,54.31693,2.35953),(.72176,54.24089,2.42632),(.72684,54.29201,2.46867),(.74064,54.29514,2.45158),(.71138,54.23924,2.43787),(.74295,54.29891,2.42948),(.75581,54.3621,2.48174),(.75929,54.36776,2.45092),(.68455,54.31141,2.37102),(.71289,54.38051,2.3988),(.68492,54.3852,2.38096),(.70439,54.3083,2.38459),(.63351,54.36576,2.47783),(.60891,54.37217,2.45548),(.71766,54.29162,2.47292),(.70915,54.35737,2.50774),(.72851,54.35755,2.5046),(.73934,54.4343,2.53308),(.73975,54.35877,2.49812),(.75089,54.43443,2.52679),(.63419,54.39138,2.3627),(.58897,54.44445,2.45099),(.58906,54.44667,2.42707),(.59787,54.37825,2.4346),(.68255,54.35883,2.50325),(.65832,54.43707,2.52128),(.68762,54.43632,2.53494),(.65911,54.36117,2.49263),(.71722,54.43476,2.53826),(.68925,54.48154,2.55372),(.77142,54.43805,2.4777),(.77334,54.48303,2.52332),(.7771,54.48593,2.49415),(.76817,54.4359,2.50899),(.58891,54.49236,2.45715),(.58763,54.49486,2.43124),(.56118,54.16906,2.69163),(.55716,54.16499,2.68165),(.55273,54.16987,2.68577),(.56278,54.16445,2.68555),(.57904,54.16373,2.68722),(.58132,54.16786,2.69725),(.58561,54.16798,2.69414),(.57618,54.16365,2.68929),(.58283,54.17035,2.66822),(.58088,54.16485,2.67374),(.58838,54.16966,2.67388),(.57719,54.1653,2.66998),(.55971,54.16687,2.65907),(.56179,54.17239,2.65333),(.55655,54.17271,2.65183),(.56319,54.16667,2.66007),(.54348,54.17139,2.67215),(.55007,54.16643,2.66806),(.54207,54.17204,2.66534),(.55101,54.166,2.67259),(.53048,54.19981,2.69346),(.5467,54.1707,2.67869),(.57611,54.19549,2.72443),(.56818,54.16843,2.69599),(.5663,54.19602,2.72231),(.57406,54.16811,2.69726),(.59122,54.16876,2.68305),(.60186,54.19567,2.71206),(.60474,54.19656,2.70071),(.5895,54.16822,2.68984),(.56916,54.17177,2.65751),(.57954,54.20049,2.66586),(.56795,54.20159,2.65805),(.57611,54.17111,2.66219),(.54337,54.17251,2.6594),(.53608,54.2033,2.65133),(.5249,54.20283,2.66125),(.5488,54.17282,2.65374),(.50776,54.24595,2.66249),(.55149,54.23878,2.73421),(.54053,54.19842,2.70526),(.53185,54.24067,2.7206),(.55464,54.19707,2.71504),(.59537,54.19527,2.71923),(.59823,54.23599,2.74729),(.58821,54.19506,2.72442),(.60315,54.24119,2.68585),(.60001,54.19807,2.68539),(.61427,54.23978,2.69753),(.59076,54.19922,2.67593),(.59461,54.291,2.66669),(.61652,54.28851,2.68639),(.58517,54.24323,2.6697),(.5213,54.24701,2.64938),(.53544,54.29577,2.6362),(.53967,54.24695,2.64565),(.50513,54.28966,2.71241),(.51784,54.2426,2.70416),(.58138,54.23658,2.7473),(.56946,54.2831,2.7608),(.58622,54.28224,2.76387),(.56773,54.23732,2.74435),(.61953,54.23806,2.71827),(.63784,54.28498,2.7269),(.63059,54.28665,2.70214),(.65785,54.34487,2.73536),(.55254,54.29474,2.64103),(.57912,54.35619,2.63752),(.55027,54.35864,2.62125),(.57196,54.29314,2.65144),(.57122,54.34429,2.78411),(.6312,54.40528,2.80556),(.64875,54.40577,2.79289),(.61027,54.41859,2.6619),(.58183,54.42126,2.64277),(.60626,54.35364,2.65579),(.60686,54.4899,2.82403),(.63875,54.48878,2.82406),(.60162,54.40632,2.80554),(.67025,54.49672,2.72086),(.67183,54.40894,2.74752),(.55162,54.42382,2.62572),(.55299,54.50879,2.63009),(.06817,54.60713,2.99882),(.05212,54.63799,3.05327),(.05629,54.5973,3.04045),(.06567,54.64725,3.01086),(.48832,54.57018,2.99099),(.48004,54.54179,2.98815),(.31691,54.48842,2.96585),(.34832,54.55603,3.02433),(.33957,54.47856,3.00642),(.3244,54.56563,2.98311),(.33314,54.61976,2.99138),(.30941,54.5772,2.91928),(.31626,54.63807,2.92794),(.25614,54.65118,2.91959),(.21948,54.59782,2.92153),(.25478,54.5968,2.90954),(.22104,54.65214,2.93162),(.19206,54.57539,3.03009),(.19604,54.6169,3.09183),(.19409,54.56476,3.0733),(.19285,54.62779,3.04762),(.26457,54.59499,3.15108),(.23974,54.54557,3.1313),(.24267,54.59746,3.15117),(.26117,54.54308,3.1312),(.25008,54.54438,2.89495),(.27823,54.58807,2.93421),(.27307,54.5356,2.9198),(.19316,54.51247,3.05447),(.20372,54.55618,3.10452),(.20157,54.50414,3.08522),(.30325,54.59812,3.11949),(.30321,54.55622,3.05566),(.29901,54.54603,3.10029),(.30755,54.60851,3.07385),(.28206,54.64105,2.94967),(.15259,54.57338,3.15281),(.14667,54.56801,3.17543),(.15188,54.60762,3.16103),(.04803,54.57056,3.15696),(.05089,54.50534,3.09618),(.04339,54.57842,3.12232),(.05503,54.49871,3.12698),(.1026,54.56195,3.19838),(.12306,54.49505,3.15671),(.10365,54.49227,3.16396),(.12438,54.56423,3.19006),(.15483,54.52767,3.01829),(.1621,54.5908,3.07752),(.16008,54.60052,3.03441),(.15663,54.5199,3.05684),(.09436,54.53545,2.95676),(.08965,54.61474,2.96658),(.073,54.52943,2.98594),(.15369,54.60857,2.99846),(.15869,54.63484,3.04463),(.04213,54.61921,3.13451),(.0475,54.5889,3.0768),(.04624,54.62977,3.08901),(.08056,54.56275,3.19335),(.27069,54.06145,2.82365),(.27392,54.05748,2.82472),(.29281,54.0371,2.84379),(.28965,54.0393,2.83522),(.27308,54.06789,2.84983),(.26994,54.06571,2.83814),(.26993,54.06957,2.8385),(.27283,54.06423,2.84825),(.29022,54.044,2.85936),(.28929,54.04968,2.865),(.29306,54.04424,2.86261),(.28708,54.04854,2.86127),(.27692,54.06472,2.85776),(.28182,54.07914,2.85248),(.28808,54.07301,2.86474),(.26834,54.06897,2.82711),(.27769,54.08466,2.82327),(.27973,54.08166,2.8413),(.29912,54.12769,2.86965),(.29538,54.13113,2.85219),(.36101,54.09653,2.85433),(.35673,54.10064,2.83719),(.34945,54.18868,2.81621),(.29431,54.19752,2.83094),(.29482,54.19857,2.81656),(.29204,54.13478,2.82753),(.31979,54.18492,2.91078),(.30895,54.12044,2.88717),(.30577,54.19099,2.88642),(.39053,54.171,2.89536),(.39024,54.17439,2.87257),(.38632,54.17786,2.85284),(.40714,54.23247,2.88728),(.40258,54.23655,2.86388),(.30032,54.19494,2.86072),(.31004,54.25275,2.90285),(.30127,54.25786,2.86997),(.37367,54.16858,2.92906),(.38771,54.22664,2.95004),(.40324,54.2844,2.97208),(.40357,54.22614,2.93111),(.38948,54.24297,2.83392),(.4187,54.29366,2.87412),(.40276,54.30164,2.83577),(.31785,54.32332,2.79115),(.29831,54.31952,2.87752),(.29805,54.25975,2.85136),(.29507,54.32315,2.85225),(.38069,54.28812,2.98709),(.36084,54.29452,2.97747),(.41286,54.34065,2.99493),(.38448,54.34454,3.0101),(.29417,54.38073,2.8833),(.2889,54.38383,2.85586),(.31574,54.42285,2.94792),(.30019,54.43097,2.89444),(.31159,54.3731,2.93594),(.3892,54.39448,3.02312),(.42,54.39198,3.00691),(.28945,54.43599,2.84336),(.28732,54.38554,2.8352),(.30124,54.49907,2.9039),(.29381,54.43341,2.86732),(.2981,54.5037,2.8753),(.36575,54.40077,3.01267),(.4004,54.46407,3.04205),(.37515,54.46926,3.03224),(.45782,54.39871,2.92305),(.46802,54.46445,2.97116),(.4676,54.46945,2.93758),(.38501,54.54671,3.05063),(.46593,54.53955,3.01758),(.45424,54.46226,2.99992),(.19384,54.22605,2.92172),(.1991,54.21458,2.9212),(.20528,54.21555,2.90747),(.21753,54.22547,2.89661),(.20647,54.21485,2.90807),(.21,54.20895,2.92402),(.22405,54.21494,2.92503),(.20992,54.21124,2.91571),(.20861,54.2133,2.91028),(.20532,54.20873,2.93253),(.20278,54.20968,2.93318),(.20379,54.21605,2.90807),(.19877,54.2133,2.92645),(.21795,54.2984,2.87393),(.19886,54.32314,2.94675),(.20063,54.33015,2.91364),(.19806,54.28783,2.93662),(.21075,54.27061,2.9919),(.22218,54.26619,2.99928),(.20022,54.24412,2.96048),(.20263,54.2761,2.97777),(.20731,54.23921,2.97116),(.26125,54.2751,2.92053),(.24368,54.23913,2.91146),(.23519,54.26333,2.99819),(.24744,54.26263,2.98821),(.22644,54.23183,2.97458),(.28117,54.34403,2.97759),(.27214,54.31381,2.93076),(.27255,54.30626,2.96198),(.27812,54.35369,2.93963),(.21688,54.37941,2.87155),(.21724,54.43507,2.88129),(.24022,54.37869,2.86535),(.21712,54.49134,2.89171),(.21432,54.39129,3.0597),(.20098,54.34309,3.01517),(.20085,54.39689,3.04206),(.19437,54.42176,2.93948),(.20053,54.37322,2.8918),(.19865,54.43022,2.90357),(.19673,54.36634,2.92131),(.19373,54.45894,3.03441),(.20027,54.45088,3.06529),(.25412,54.439,3.09133),(.2336,54.44119,3.09135),(.19297,54.41401,2.97324),(.19245,54.46904,2.9924),(.19448,54.40465,3.01241),(.28939,54.39838,2.99898),(.29432,54.45193,3.01932),(.2779,54.4185,2.91812),(.25997,54.37099,2.87626),(.27099,54.36257,2.90531),(.27583,54.33652,3.00818),(.26204,54.33308,3.02888),(.29885,54.50467,3.03766),(.29475,54.49462,3.08127),(.28969,54.4635,2.97168),(.29414,54.51668,2.98895),(.24458,54.23493,2.93107),(.19582,54.25332,2.92714),(.21654,54.23492,2.97626),(.20624,54.2162,2.95191),(.24015,54.2974,3.0206),(.26147,54.26927,2.94542),(.2196,54.33921,2.87088),(.23848,54.33698,2.86586),(.19591,54.34987,2.99133),(.19955,54.31611,2.97491),(.19511,54.35864,2.95571),(.21908,54.49824,3.10189),(.22169,54.55004,3.12151),(.23675,54.49399,3.11151),(.14595,54.18969,2.96818),(.14624,54.19256,2.97798),(.14702,54.19569,2.97326),(.14571,54.18884,2.96971),(.14633,54.19504,2.95355),(.14726,54.20087,2.96087),(.14714,54.20274,2.95407),(.14653,54.19383,2.95831),(.13557,54.18829,2.95024),(.1413,54.18633,2.95738),(.14213,54.18906,2.95264),(.13476,54.18573,2.95512),(.13664,54.22445,3.00069),(.13557,54.21981,3.01146),(.11524,54.20719,2.94229),(.10216,54.22172,2.96138),(.11335,54.20077,2.95627),(.10424,54.21075,3.00762),(.11893,54.19383,2.99324),(.13924,54.2074,2.98932),(.14296,54.20282,2.97711),(.14278,54.2002,2.98328),(.13964,54.21032,2.98138),(.14308,54.21135,2.95104),(.13987,54.21579,2.96558),(.13894,54.221,2.94879),(.14303,54.20794,2.9632),(.1381,54.22436,2.93445),(.14251,54.2133,2.94017),(.12067,54.19037,2.96818),(.12127,54.1949,2.95536),(.13437,54.18265,2.96316),(.14729,54.19814,2.96851),(.14686,54.20394,2.94674),(.09889,54.47912,2.93749),(.13176,54.43636,2.9177),(.13179,54.4825,2.93428),(.1003,54.43256,2.92053),(.08719,54.3864,2.9344),(.07025,54.42052,2.98798),(.07783,54.37927,2.97218),(.08051,54.42763,2.95056),(.06247,54.52144,3.02324),(.07473,54.4735,2.96707),(.06526,54.46607,3.00491),(.06894,54.49478,3.14649),(.05642,54.44432,3.10843),(.0701,54.44051,3.12799),(.05907,54.45845,3.03759),(.06488,54.41306,3.02082),(.08491,54.43827,3.14093),(.07348,54.39551,3.11117),(.08736,54.39319,3.1243),(.06041,54.40584,3.0607),(.06986,54.3715,3.00453),(.06466,54.36436,3.04499),(.10575,54.3936,3.1292),(.09033,54.35195,3.10857),(.10874,54.35249,3.11349),(.14997,54.40813,3.08961),(.1554,54.37329,3.05143),(.15035,54.36704,3.07444),(.15537,54.41429,3.06654),(.14369,54.35025,2.92465),(.15326,54.38939,2.96919),(.14974,54.39325,2.93615),(.14944,54.34669,2.95736),(.14729,54.32503,3.05795),(.1455,54.36105,3.09427),(.14219,54.3191,3.07666),(.14923,54.50466,3.12417),(.15461,54.45843,3.08262),(.14912,54.45239,3.10573),(.15475,54.51053,3.10089),(.14977,54.43397,2.95139),(.15576,54.47448,3.00003),(.15007,54.47904,2.96753),(.15513,54.43011,2.98406),(.14385,54.44667,3.12566),(.1447,54.40224,3.1095),(.13499,54.27545,2.92332),(.13308,54.24336,2.926),(.08835,54.25989,2.9716),(.09083,54.24595,3.03925),(.1382,54.2034,2.99862),(.13748,54.25952,3.00645),(.14442,54.29236,3.01957),(.13835,54.30998,2.921),(.12514,54.31123,2.89178),(.08107,54.29127,2.98147),(.08714,54.29799,2.9525),(.09351,54.27366,3.06985),(.08424,54.27605,3.05879),(.09111,54.31034,3.09148),(.15086,54.33162,3.03372),(.12694,54.351,2.8955),(.07605,54.32955,2.99248),(.08292,54.33659,2.96102),(.07852,54.31252,3.07909),(.10425,54.34862,2.89672),(.09161,54.34321,2.92602),(.10246,54.39091,2.90487),(0,53.66242,2.62884),(0,53.7,2.6101),(.43591,53.54007,2.59803),(.74618,54.2319,1.87983),(.79561,54.26588,1.7828),(.75697,54.21123,1.87755),(.78402,54.28627,1.78452),(.89578,54.45746,1.49406),(.90937,54.43766,1.49421),(.92958,54.50988,1.39671),(.96659,54.58462,1.30083),(1.61712,54.90828,.85599),(1.69291,55.61054,.42545),(1.67955,55.60424,.39703),(1.46141,56.20339,1.6661),(1.46487,56.20071,1.68012),(1.53369,56.37464,1.52503),(1.51676,55.68647,1.03071),(1.71966,55.58439,.25713),(1.64478,55.6678,.52978),(1.63732,55.39252,.57235),(1.6453,55.40174,.59793),(1.40536,55.73038,1.32121),(1.39944,55.72092,1.3413),(1.36102,55.53964,1.25053),(1.58487,56.05395,1.19587),(1.57452,54.73253,1.01983),(1.55994,54.74536,1.06977),(1.56135,55.341,1.12873),(1.56241,55.51143,1.08794),(1.54013,55.51635,1.15061),(1.58066,55.33866,1.07201),(1.38228,54.57237,1.51423),(1.37226,54.59028,1.54462),(1.4616,55.0278,1.45966),(1.69363,55.30892,.61781),(1.68334,55.31311,.67335),(1.624,55.93692,.91137),(1.61938,55.90199,.91413),(1.60436,55.97025,1.03967),(1.24381,54.4136,1.94052),(1.28715,54.57019,1.84722),(1.28239,54.58299,1.86735),(1.24882,54.4018,1.92307),(.23443,53.59756,2.62667),(.23654,53.59078,2.63393),(.31282,53.60952,2.59513),(.31043,53.61721,2.58759),(.04408,53.78548,2.58657),(0,53.79131,2.57769),(0,53.80268,2.58133),(.03909,53.7778,2.58184),(.67687,54.00392,2.62131),(.69529,53.98142,2.61263),(.76173,54.04462,2.62807),(.67408,54.03172,2.60094),(.76886,54.06924,2.60939),(.09855,53.48343,2.97297),(0,53.47121,2.90303),(0,53.50316,2.96677),(.32107,53.49359,3.00954),(.64612,53.99178,2.1851),(.6285,53.86814,2.29551),(.57521,53.96654,2.28715),(.70481,53.90491,2.20182),(.48249,53.80854,2.45073),(.50186,53.94517,2.39009),(.5522,53.83136,2.39002),(.43921,53.92509,2.44789),(.27075,54.60784,3.1776),(.7151,54.42546,2.83097),(.65282,54.51455,2.89779),(.64723,54.41026,2.88962),(.70678,54.31532,2.80595),(.35088,54.00477,2.90054),(.45848,54.00389,2.8598),(.36704,54.14812,2.92683),(.50391,54.60983,3.00082),(.55614,53.52029,2.79451),(.65797,54.71652,2.60695),(.6234,54.71515,2.57495),(.62038,54.72104,2.58083),(.66031,54.71038,2.60056),(.6804,54.65589,2.84988),(.68389,54.65715,2.85512),(.65523,54.65536,2.86538),(.48472,54.6807,2.77267),(.51431,54.67382,2.80708),(.63882,54.69544,2.67942),(.63432,54.68794,2.68403),(.37482,54.66356,2.72199),(.43758,54.67209,2.85406),(.3941,54.68569,2.82198),(.55223,54.63435,2.82785),(.55267,54.6675,2.83358),(.58666,54.63124,2.84941),(.45769,54.6491,2.6982),(.23284,53.66934,2.61138),(.4085,54.04103,2.45991),(.34707,54.17092,2.58138),(.40444,54.1855,2.51506),(.6643,53.62359,2.73808),(.56922,53.6109,2.83334),(.35644,54.30919,2.65921),(.41631,54.32959,2.58394),(.70391,54.66015,2.829),(.56817,54.72503,2.49928),(.56579,54.69254,2.49508),(.67262,54.629,2.8404),(.6595,54.64073,2.7117),(.70827,54.66796,2.79211),(.53568,54.53989,2.47326),(.49496,54.50603,2.55474),(.6868,53.63104,2.27398),(.57394,53.71918,2.37834),(.66169,53.75017,2.28507),(.64697,53.53845,2.69222),(.75204,53.60174,2.59038),(.61477,54.02048,2.78286),(.52763,54.06901,2.2947),(.4666,54.05502,2.4033),(.35173,54.66484,3.05652),(.49851,54.60905,2.99791),(.42282,54.5954,3.08388),(.30723,54.667,3.03877),(.31398,54.67264,3.04022),(.19356,54.67302,3.11209),(.19854,54.66737,3.10871),(.16436,54.66228,3.1018),(.16111,54.65066,3.14766),(.04352,54.65162,3.09723),(.03692,54.65819,3.09969),(.44936,54.5591,3.0475),(.4178,54.56538,3.06726),(.33683,54.66928,3.00205),(.19925,54.65647,3.10423),(.30539,54.62645,3.12836),(.28613,54.62168,3.14646),(.29391,54.63188,2.98242),(.06341,54.6065,3.19195),(.15754,54.61301,3.1371),(.15545,54.63064,3.16726),(.15889,54.63613,3.14397),(.08932,54.65342,2.97784),(.20464,54.66162,3.1464),(0,53.54569,3.0192),(0,53.60294,3.04666),(.41658,53.6038,2.98404),(.25056,53.53176,2.70558),(0,54.44292,2.91693),(0,54.26842,2.81493),(.7446,54.0005,2.54181),(.74336,54.02405,2.53006),(.80913,54.08879,2.55402),(.71693,54.04901,2.54634),(.82897,54.06514,2.53699),(.82734,54.03862,2.54856),(.76392,54.78067,1.71698),(.84686,53.70654,2.07933),(.77663,53.65592,2.18359),(.82644,54.13361,1.88629),(.78587,54.07788,1.97986),(.82041,53.8298,2.09148),(.91709,53.75715,1.97592),(.89137,53.87845,1.99109),(.62874,54.28101,2.13204),(.68129,54.32045,2.01957),(.77163,53.69388,2.64119),(.84261,53.63659,2.49156),(.85905,53.73838,2.53814),(.74944,53.78115,2.19268),(.94172,54.09555,2.39363),(.92944,54.17055,2.42073),(1.0374,54.54145,2.22003),(.98367,54.58258,2.34814),(.99991,54.49635,2.31559),(.89604,54.50739,2.53209),(.84445,54.57469,2.62676),(.85923,54.48217,2.60577),(.75776,54.3356,2.72068),(.81583,54.35838,2.64495),(.70432,54.7267,2.42446),(.98158,54.36113,1.50471),(.87411,54.38439,1.59231),(.94612,54.31084,1.60473),(1.13012,54.00959,1.58527),(1.17781,54.0746,1.49236),(1.0616,54.85073,1.6251),(1.01829,54.84677,1.61488),(1.01803,54.85043,1.62313),(1.06133,54.84549,1.6164),(.9087,54.84501,1.58872),(.87996,54.88157,1.38531),(1.09272,54.85127,1.60391),(1.09538,54.85821,1.61129),(1.02494,54.89841,1.39576),(.76007,54.7933,1.80191),(.99238,54.17739,1.71749),(1.08413,54.12796,1.60407),(1.03693,54.06145,1.70249),(1.03259,54.24096,1.62114),(.76628,54.56567,1.73005),(.82586,54.4921,1.60118),(.78788,54.44624,1.70829),(.94152,54.82175,1.6762),(.94171,54.81356,1.68128),(1.08845,54.78857,1.89964),(1.07054,54.77856,1.93408),(.89502,54.76763,2.05566),(.90644,54.77624,2.0168),(.85531,54.75912,2.05197),(.97471,54.75123,2.22803),(.96714,54.75071,2.22718),(.9285,54.76073,2.07821),(.89322,54.76187,2.06104),(.78744,54.75366,2.3677),(.76884,54.74713,2.41),(.7941,54.70454,2.49921),(.7766,54.71046,2.47711),(.74846,54.72203,2.45444),(.74512,54.71424,2.45876),(.77974,54.69383,2.59731),(.80198,54.694,2.57181),(.77434,54.67795,2.473),(.91153,54.28763,2.46281),(.9647,54.34004,2.36998),(1.01693,54.40627,2.27569),(.72076,54.02827,2.08311),(.58866,54.083,2.18692),(.9446,54.84588,1.60841),(.94238,54.84529,1.64674),(.98026,54.84782,1.61874),(1.23736,54.87148,1.58183),(1.18451,54.88129,1.56832),(.84699,54.82899,1.55527),(.83119,54.83226,1.53427),(.85438,54.8003,1.54894),(.98246,54.82264,1.60091),(.9484,54.79384,1.58166),(.94597,54.8232,1.59104),(.9828,54.79331,1.59084),(1.11624,54.83662,1.55573),(1.11921,54.8409,1.53522),(1.023,54.86492,1.39352),(1.06107,54.86331,1.4061),(.90478,54.86557,1.37987),(.88424,54.86403,1.38421),(1.11664,54.86388,1.5625),(1.12058,54.8662,1.5418),(.94495,54.86691,1.37999),(.82932,54.83912,1.49697),(.82571,54.85652,1.54167),(.8237,54.86147,1.50371),(.94512,54.84224,1.60003),(.91036,54.82509,1.57952),(1.10658,54.85782,1.58354),(1.10767,54.83222,1.5759),(.91053,54.76879,1.67052),(.90489,54.81322,1.67541),(.94482,54.77068,1.67693),(.78492,54.74572,1.73419),(.8282,54.71189,1.93859),(.85531,54.7529,2.05785),(.89337,54.70193,2.05622),(.72363,54.68171,2.05016),(.77794,54.68868,2.04189),(.98973,53.99493,1.8015),(1.07719,53.94171,1.68565),(1.02425,53.87382,1.78666),(.7507,54.40131,1.81372),(.71599,54.36088,1.91636),(1.37741,54.36192,1.52452),(1.42438,54.50708,1.41872),(1.00539,54.7548,1.28079),(1.23502,54.16041,1.90465),(1.15352,54.25714,2.11219),(1.08231,54.1285,2.22094),(.95217,54.11383,1.81438),(.76018,54.44099,2.75434),(.80735,54.45822,2.67562),(.76598,54.69587,2.6096),(.91251,53.91129,2.45328),(.82905,53.85625,2.55098),(1.44754,55.0553,1.52838),(1.52263,54.77463,1.16937),(1.47748,54.82113,1.31958),(1.67955,55.99427,.00097),(1.65308,55.99536,-.00248),(1.59454,56.14973,1.21924),(1.58876,56.09276,1.12233),(1.57934,56.16321,1.21001),(1.60277,56.08421,1.13563),(1.58791,56.32228,1.39156),(1.58529,56.41542,1.4535),(1.45344,55.60142,1.67219),(1.45283,55.5035,1.66067),(1.44342,55.70634,1.68239),(1.45213,55.80895,1.72336),(1.44339,55.81142,1.71414),(1.45343,55.70445,1.69072),(1.4554,56.06135,1.75521),(1.44608,55.93437,1.74276),(1.45423,55.93269,1.75082),(1.44805,56.06234,1.74693),(1.44977,56.18467,1.74865),(1.46868,56.30936,1.76086),(1.46212,56.31085,1.75184),(1.4564,56.1835,1.75716),(1.47892,56.41432,1.76844),(1.49638,56.50208,1.76048),(1.54942,56.59865,1.65604),(1.51916,56.56891,1.72915),(1.55872,56.58978,1.65901),(1.38731,55.66169,1.30094),(1.56654,56.15525,1.21688),(1.57435,56.08409,1.1273),(1.49717,56.45975,1.61598),(1.33351,55.45159,1.26951),(1.59217,55.72133,.7608),(1.60766,55.61069,.68051),(1.7344,55.5825,.29881),(1.74893,56.1245,.37838),(1.62871,55.9831,.91405),(1.61278,55.99564,.90166),(1.57371,56.23423,1.28478),(1.56006,56.22756,1.29794),(1.59599,56.02877,1.03185),(1.60927,56.01857,1.04189),(1.5291,56.19939,1.35713),(1.81565,56.25684,.23308),(1.39816,56.29274,.0318),(1.82328,56.19078,.01568),(1.84983,56.2651,-.00619),(1.75247,56.18825,-.04305),(1.55977,56.06988,-.02111),(1.62496,55.99916,.00406),(1.49706,56.08192,.0133),(1.71569,56.51605,.04652),(1.60903,56.53206,.0671),(1.73733,56.49805,0),(1.73333,55.99631,.04428),(1.86197,56.13235,.11135),(1.8378,56.03078,.14386),(1.93358,56.1507,.1962),(1.46487,56.498,-.06699),(1.45487,56.52443,-.02275),(1.444,56.3725,.05597),(1.79811,56.11084,.04617),(1.88577,56.19493,.09158),(1.67392,56.17874,-.09562),(1.61855,56.06431,-.04003),(1.56737,56.17131,-.0973),(1.67624,56.07095,-.03885),(1.6443,55.48717,.78033),(1.48059,56.30825,1.75847),(1.50863,56.17915,1.68464),(1.47015,56.18292,1.75381),(1.61281,55.11568,.94583),(1.58753,54.92652,1.0238),(1.60618,54.91781,.92925),(1.59465,55.12395,1.04944),(1.64083,55.32631,.81906),(1.62572,55.1095,.84786),(1.60899,55.33619,.95363),(1.70863,55.47019,.58633),(1.51744,55.34727,1.22239),(1.46561,55.81026,1.71903),(1.49599,55.6907,1.61501),(1.46718,55.7056,1.68592),(1.71543,55.61791,.59719),(1.78509,56.00797,.08601),(1.8569,56.3882,.00691),(1.44275,55.60227,1.66469),(1.44227,55.50393,1.65403),(1.53268,56.01136,1.22388),(1.63655,55.57484,.64742),(1.65499,55.52681,.55601),(1.66241,55.49302,.46304),(-.67324,54.60416,2.25193),(-.68546,54.53643,2.25366),(-.76583,54.54189,2.32127),(-.79743,54.61448,2.33389),(-.75516,54.60988,2.32469),(-.80666,54.54614,2.33066),(-.67602,54.60256,2.28573),(-.66398,54.66321,2.25605),(-.8453,54.61966,2.34517),(-.69102,54.5745,2.41341),(-.66943,54.4963,2.38788),(-.6881,54.49592,2.39983),(-.61627,54.57769,2.39447),(-.60287,54.49791,2.39267),(-.5978,54.57796,2.40165),(-.61942,54.49764,2.38389),(-.78945,54.56523,2.51257),(-.79194,54.61542,2.5592),(-.78437,54.56093,2.54726),(-.79756,54.6179,2.51979),(-.73638,54.6278,2.44969),(-.69273,54.6334,2.41752),(-.73175,54.57133,2.44297),(-.77814,54.6687,2.59422),(-.8004,54.66886,2.56873),(-.7667,54.62415,2.46737),(-.74278,54.68174,2.45459),(-.77434,54.67795,2.473),(-.65195,54.69281,2.39997),(-.62989,54.63849,2.39225),(-.62954,54.69492,2.39496),(-.73894,54.47804,2.1972),(-.73081,54.40737,2.19786),(-.71423,54.47558,2.20014),(-.75532,54.41054,2.19194),(-.77536,54.29977,2.21051),(-.74939,54.34636,2.25116),(-.74578,54.34616,2.22854),(-.7783,54.30015,2.22963),(-.74699,54.34827,2.2025),(-.72179,54.40408,2.21586),(-.75524,54.35159,2.1888),(-.7644,54.34751,2.26289),(-.79016,54.40738,2.30066),(-.7419,54.4026,2.28434),(-.80207,54.35124,2.27735),(-.70102,54.46871,2.25617),(-.69941,54.4704,2.22349),(-.72076,54.40165,2.24558),(-.81197,54.47787,2.32565),(-.77433,54.47387,2.31747),(-.82204,54.41085,2.30768),(-.85462,54.48239,2.33561),(-.85292,54.55093,2.34208),(-.70371,54.46742,2.28417),(-.71098,54.53668,2.30048),(-.68889,54.53505,2.28415),(-.7239,54.46895,2.29895),(-.68768,54.44863,2.39511),(-.68492,54.3852,2.38096),(-.66677,54.45103,2.38283),(-.7609,54.44045,2.45221),(-.75147,54.4895,2.44412),(-.76774,54.4875,2.46518),(-.74594,54.44272,2.43248),(-.65513,54.49674,2.38151),(-.65097,54.45159,2.37529),(-.75989,54.56921,2.46074),(-.72573,54.49203,2.42525),(-1.10289,54.76047,1.46211),(-1.0865,54.75872,1.46808),(-.87924,54.71102,1.44837),(-.88045,54.77136,1.45721),(-.86048,54.76884,1.46282),(-1.0862,54.76637,1.49544),(-1.02602,54.81589,1.49107),(-1.02111,54.76644,1.47783),(-1.02446,54.76309,1.46915),(-1.01895,54.70642,1.44829),(-.90561,54.68977,1.54258),(-.91866,54.62043,1.50465),(-.93348,54.61539,1.51725),(-.88554,54.69516,1.5296),(-.98906,54.60948,1.54343),(-.98186,54.6831,1.56877),(-.90871,54.78399,1.35719),(-.89961,54.78298,1.36436),(-.90555,54.71622,1.42074),(-.94668,54.7654,1.45505),(-.88759,54.77095,1.43582),(-.95234,54.70973,1.43689),(-1.07217,54.71883,1.37174),(-1.0527,54.77772,1.37073),(-1.08534,54.77725,1.39296),(-1.04167,54.72053,1.34659),(-.98247,54.74405,1.5804),(-1.01651,54.74397,1.58307),(-.85448,54.76429,1.48546),(-.87421,54.70683,1.47209),(-.92195,54.74732,1.56167),(-.89234,54.74894,1.55345),(-.93056,54.68739,1.5505),(-1.02108,54.83474,1.38325),(-.99046,54.77995,1.354),(-.98634,54.83555,1.37645),(-1.02078,54.779,1.35982),(-.89076,54.83599,1.37509),(-.8799,54.83446,1.38164),(-1.05711,54.83352,1.39498),(-1.09343,54.83265,1.41761),(-.9828,54.79331,1.59084),(-1.09549,54.75688,1.53548),(-1.10155,54.8038,1.5648),(-1.08824,54.75265,1.55397),(-1.10945,54.80792,1.54662),(-.83896,54.8109,1.49151),(-.95304,54.69268,1.64682),(-.94883,54.71999,1.66322),(-.8273,54.6769,1.6577),(-.78865,54.69535,1.72164),(-.82024,54.70672,1.67525),(-.80055,54.67015,1.69565),(-.98128,54.68325,1.80988),(-.90099,54.66449,1.76964),(-.98675,54.66721,1.78688),(-.89618,54.67841,1.79458),(-.88532,54.6269,1.93772),(-.94003,54.66586,1.95609),(-.88203,54.66247,1.94651),(-.94101,54.63055,1.94734),(-1.07297,54.6865,1.90837),(-1.06816,54.6498,1.90266),(-.89549,54.67704,1.80132),(-.89769,54.65316,1.80157),(-.9814,54.68259,1.81338),(-.98077,54.6819,1.81675),(-.98977,54.66752,1.63859),(-.96761,54.6061,1.6098),(-.95745,54.66546,1.62998),(-.99627,54.60748,1.61511),(-.91014,54.62287,1.73422),(-.99478,54.63029,1.75627),(-1.07834,54.66205,1.70213),(-1.07586,54.69782,1.71958),(-.925,54.66138,1.62341),(-.91953,54.69,1.64071),(-.80736,54.62876,1.66984),(-.91449,54.71822,1.65706),(-.94482,54.77068,1.67693),(-.91053,54.76879,1.67052),(-1.07397,54.7266,1.73384),(-1.0864,54.7614,1.79533),(-.78492,54.74572,1.73419),(-.81649,54.75709,1.68802),(-.79026,54.66573,1.88354),(-.8282,54.71189,1.93859),(-.78654,54.7161,1.89541),(-.83196,54.66158,1.92684),(-1.04179,54.67768,1.94138),(-1.03793,54.72805,1.95307),(-1.01468,54.67167,1.96098),(-.77414,54.60248,2.18293),(-.77459,54.60259,2.18013),(-.95603,54.6354,2.20482),(-.94562,54.55966,2.17636),(-.78596,54.54358,2.15813),(-.87065,54.61333,2.19486),(-.87808,54.5509,2.17325),(-.81956,54.63415,2.0396),(-.7935,54.56705,2.0223),(-.78447,54.63013,2.03599),(-.82701,54.5701,2.02617),(-.90043,54.62661,2.34107),(-.93762,54.56283,2.30903),(-.93442,54.63273,2.30586),(-.9058,54.5573,2.33985),(-.96844,54.57559,2.0815),(-.9775,54.64757,2.13508),(-.98009,54.57106,2.11444),(-.89959,54.64271,2.05628),(-.85071,54.69672,2.05412),(-.89337,54.70193,2.05622),(-.8573,54.63815,2.04828),(-.73016,54.623,2.04428),(-.69767,54.61661,2.08629),(-.72363,54.68171,2.05016),(-1.01778,54.51386,1.42607),(-1.01694,54.51334,1.41516),(-1.0222,54.51263,1.41818),(-1.01301,54.51455,1.42333),(-1.03579,54.51187,1.42027),(-1.04078,54.5148,1.40324),(-1.04658,54.51828,1.40997),(-1.04046,54.51395,1.40802),(-1.04668,54.51937,1.40409),(-1.04506,54.56505,1.40563),(-1.00958,54.51442,1.41041),(-1.00726,54.51513,1.42077),(-1.00184,54.51618,1.41539),(-1.01233,54.51386,1.41306),(-1.00788,54.51642,1.39969),(-.99901,54.51776,1.40786),(-1.008,54.51525,1.40612),(-.98331,54.55396,1.32227),(-.97638,54.55991,1.31955),(-1.00782,54.54319,1.32745),(-1.00802,54.55109,1.31926),(-1.01424,54.54676,1.32576),(-1.00344,54.54636,1.32287),(-1.00118,54.53973,1.34564),(-1.00162,54.54193,1.3535),(-.95753,54.57159,1.3474),(-.94483,54.59658,1.36963),(-.93651,54.59811,1.36007),(-.91539,54.63399,1.42129),(-.98654,54.56961,1.39014),(-1.01716,54.5678,1.39486),(-1.01134,54.58814,1.39015),(-.9702,54.58894,1.38084),(-1.00532,54.56173,1.37131),(-1.02033,54.6457,1.42293),(-1.01621,54.57404,1.3201),(-1.02844,54.57225,1.33118),(-.98201,54.57863,1.30938),(-.97084,54.57884,1.30992),(-.9583,54.57683,1.32335),(-.97139,54.55682,1.33435),(-.95481,54.57419,1.3369),(-.9738,54.55902,1.32484),(-.97869,54.5298,1.43215),(-.97454,54.53156,1.42234),(-1.01422,54.52419,1.45161),(-1.00463,54.52489,1.4476),(-1.02479,54.51329,1.42914),(-1.04944,54.52933,1.41944),(-.94841,54.56344,1.45015),(-.9512,54.56858,1.42106),(-.99528,54.52637,1.44254),(-.98632,54.55442,1.48531),(-.97444,54.55637,1.47846),(-1.02635,54.55216,1.49127),(-1.00298,54.60195,1.31236),(-.99386,54.57711,1.31173),(-.98817,54.60388,1.3084),(-1.00468,54.57588,1.31472),(-.94956,54.60694,1.31013),(-.96236,54.57815,1.31601),(-.94576,54.60642,1.31553),(-.96538,54.57872,1.31237),(-1.03587,54.59718,1.33556),(-1.04435,54.59403,1.35218),(-1.04431,54.65558,1.34815),(-.98559,54.66205,1.31535),(-.97215,54.60623,1.30538),(-.96398,54.66585,1.31138),(-.94029,54.60484,1.3261),(-1.01128,54.62425,1.41839),(-.95339,54.56125,1.46426),(-.96279,54.55784,1.47315),(-.99856,54.55349,1.49095),(-1.01218,54.55273,1.4914),(-1.05279,54.55613,1.43925),(-1.05743,54.61415,1.47917),(-.98828,54.72308,1.33209),(-.95995,54.72627,1.32943),(-1.07167,54.68846,1.53878),(-1.01447,54.70152,1.45672),(-1.07813,54.69199,1.51597),(-1.01324,54.38143,1.77396),(-1.01059,54.36577,1.77493),(-1.00479,54.36737,1.76978),(-1.01837,54.37793,1.77983),(-1.02745,54.45004,1.79888),(-1.01673,54.43223,1.78586),(-1.02118,54.4529,1.79321),(-1.02326,54.4302,1.79196),(-1.06616,54.4415,1.67727),(-1.06547,54.42324,1.66827),(-1.07452,54.44235,1.67423),(-1.07133,54.50173,1.69326),(-1.06738,54.53619,1.70673),(-1.06354,54.5004,1.69661),(-1.00403,54.4058,1.64603),(-1.02917,54.39845,1.6328),(-.92162,54.46511,1.6656),(-.93052,54.4464,1.65425),(-.93983,54.44767,1.66098),(-.91352,54.46413,1.65986),(-.84398,54.57508,1.68503),(-.85312,54.57483,1.68969),(-1.06884,54.58469,1.72474),(-1.00215,54.58086,1.72901),(-1.03195,54.45608,1.6845),(-1.063,54.47978,1.69116),(-1.02283,54.47533,1.68827),(-1.06852,54.46052,1.68642),(-1.02427,54.4055,1.65124),(-.95742,54.49351,1.68482),(-.90487,54.48783,1.66978),(-.96772,54.47148,1.68029),(-.99141,54.38086,1.76038),(-.99275,54.36903,1.76293),(-.98042,54.4506,1.77471),(-.98447,54.43076,1.76967),(-1.04001,54.55664,1.83971),(-.97336,54.56006,1.81724),(-.92158,54.47228,1.77109),(-.93052,54.44515,1.76149),(-.95986,54.39395,1.75256),(-.93642,54.39117,1.75119),(-1.03182,54.41689,1.6013),(-1.03261,54.40345,1.613),(-1.01377,54.41475,1.60106),(-1.06582,54.40147,1.63623),(-1.06197,54.40056,1.63844),(-.97643,54.36161,1.77604),(-.9818,54.36787,1.78927),(-.9666,54.36872,1.78449),(-.98649,54.36118,1.77952),(-1.04775,54.43208,1.60431),(-1.04174,54.41712,1.60457),(-1.03474,54.43248,1.60013),(-1.05164,54.41724,1.60766),(-.98348,54.42528,1.60344),(-.99405,54.4073,1.62226),(-.97116,54.41925,1.62181),(-1.00253,54.41187,1.60709),(-.92611,54.37719,1.77427),(-1.02426,54.38493,1.80449),(-.96934,54.41673,1.63409),(-.95558,54.43149,1.65191),(-.94372,54.43223,1.63558),(-.97781,54.41706,1.6473),(-1.08263,54.44798,1.63965),(-1.06715,54.43103,1.61805),(-1.06471,54.4509,1.61594),(-1.08173,54.42837,1.63732),(-1.00691,54.45081,1.59133),(-1.00106,54.42961,1.59645),(-.98213,54.44645,1.58975),(-1.02147,54.43223,1.59554),(-1.0257,54.3985,1.81185),(-1.02473,54.3916,1.79259),(-1.02697,54.40616,1.79721),(-.9139,54.38438,1.77889),(-.99029,54.38893,1.81475),(-.93745,54.45762,1.5995),(-.94579,54.43501,1.62128),(-.92192,54.45036,1.62038),(-.96038,54.4415,1.60221),(-1.07656,54.46174,1.68334),(-1.09017,54.44455,1.66073),(-1.09154,54.46469,1.66797),(-1.03246,54.47343,1.59897),(-1.02423,54.4533,1.59529),(-1.0131,54.47219,1.59311),(-1.04059,54.45239,1.60071),(-.95313,54.40705,1.75318),(-.94705,54.42635,1.75711),(-.98778,54.41071,1.76564),(-.91546,54.39697,1.80401),(-.89671,54.3988,1.7875),(-1.02347,54.49298,1.5988),(-1.00275,54.49145,1.59274),(-.92124,54.4784,1.60139),(-.90543,54.47084,1.62327),(-1.08474,54.48368,1.672),(-1.07086,54.48092,1.688),(-.93105,54.41536,1.82827),(-.90461,54.41188,1.81423),(-.93998,54.39874,1.81417),(-1.02933,54.42683,1.80488),(-1.02822,54.41858,1.82231),(-.87224,54.42297,1.77586),(-.88537,54.40463,1.76849),(-1.07448,54.51142,1.65079),(-1.05581,54.49011,1.61585),(-1.04934,54.51774,1.61685),(-1.07497,54.48536,1.64674),(-.96919,54.51747,1.59032),(-.94899,54.48629,1.58843),(-.93536,54.51242,1.58901),(-.98113,54.49097,1.58868),(-.9005,54.46632,1.6432),(-.89679,54.4869,1.66422),(-.88341,54.48971,1.6484),(-.86634,54.44019,1.81257),(-.88527,54.41467,1.79762),(-.9616,54.41873,1.83704),(-.95696,54.44187,1.85827),(-.98337,54.42096,1.84292),(-.97737,54.47752,1.78484),(-1.08289,54.50556,1.67968),(-1.00587,54.55884,1.60152),(-.99231,54.51899,1.59414),(-.98081,54.5578,1.59666),(-1.01483,54.52039,1.59857),(-.88543,54.49558,1.62814),(-.88221,54.5461,1.60676),(-.90495,54.50433,1.60402),(-.86185,54.53433,1.63136),(-.85208,54.49584,1.78342),(-.88936,54.43488,1.83526),(-.90802,54.46714,1.87331),(-.8731,54.46641,1.85996),(-.92118,54.43639,1.84791),(-1.01685,54.45086,1.85889),(-1.0182,54.48179,1.87749),(-.85714,54.59197,1.62089),(-.8323,54.58329,1.64757),(-1.0743,54.59754,1.67717),(-1.04447,54.55653,1.62247),(-1.04028,54.60544,1.63782),(-1.07402,54.54936,1.65857),(-.9385,54.60467,1.60471),(-.91701,54.55339,1.5918),(-.89574,54.60022,1.60447),(-.95517,54.55675,1.592),(-1.0366,54.50932,1.82743),(-1.05664,54.54714,1.86295),(-1.04649,54.50159,1.84516),(-1.04698,54.55468,1.84535),(-.85146,54.4737,1.83566),(-.94445,54.51108,1.90636),(-.97609,54.51385,1.91002),(-.94686,54.47175,1.88256),(-.82821,54.57724,1.67319),(-.88983,54.57303,1.9229),(-.94275,54.57724,1.93274),(-.89806,54.50682,1.89678),(-1.03323,54.59159,1.92289),(-1.04887,54.53947,1.88171),(-1.06098,54.60423,1.89528),(-1.02507,54.52715,1.90054),(-.80792,54.53926,1.8076),(-.79712,54.62994,1.8782),(-.77986,54.6379,1.82499),(-.97613,54.57954,1.93836),(-.97627,54.63276,1.95272),(-.86055,54.2865,1.99162),(-.86157,54.28658,1.99852),(-.86419,54.2862,1.99486),(-.88781,54.2768,2.17289),(-.82037,54.26832,2.16475),(-.84253,54.24949,2.16468),(-.77207,54.41251,2.0896),(-.75338,54.41356,2.07733),(-.89644,54.29004,1.99964),(-.89036,54.28943,2.00426),(-.85684,54.28687,1.98798),(-.85759,54.28853,1.98063),(-.89694,54.29308,1.97965),(-.89344,54.29337,1.97648),(-.86776,54.28598,1.99772),(-.88267,54.28784,2.00463),(-.86584,54.28649,2.00185),(-.88211,54.28706,2.00009),(-.89828,54.29173,1.98666),(-.90267,54.29336,1.98708),(-.8319,54.24385,2.18023),(-.82818,54.24437,2.1888),(-.82762,54.24497,2.18002),(-.83212,54.24354,2.18647),(-.85192,54.24562,2.19503),(-.86038,54.24784,2.20161),(-.8512,54.24685,2.19944),(-.86015,54.24656,2.19706),(-.8756,54.24932,2.18274),(-.96095,54.42802,2.11332),(-.94957,54.50636,2.15448),(-.94209,54.42522,2.11899),(-.96762,54.50892,2.14783),(-.83982,54.27062,2.15769),(-.86966,54.27417,2.16341),(-.84722,54.25021,2.16346),(-.87475,54.49175,2.20837),(-.80366,54.41569,2.18859),(-.78905,54.48235,2.195),(-.87627,54.42383,2.19978),(-.82791,54.35616,2.07693),(-.8895,54.41733,2.11914),(-.81452,54.4112,2.10795),(-.89075,54.3643,2.08732),(-.85415,54.29763,2.02539),(-.84176,54.29912,2.01763),(-.79717,54.49183,2.13654),(-.74466,54.48899,2.11919),(-.81614,54.35927,2.17833),(-.79789,54.30662,2.17283),(-.77454,54.35446,2.18283),(-.82827,54.31079,2.16594),(-.86366,54.26846,2.23142),(-.87094,54.24907,2.2002),(-.88196,54.27244,2.23111),(-.83238,54.24471,2.1928),(-.83171,54.26474,2.2238),(-.81179,54.26265,2.21513),(-.84309,54.2459,2.19757),(-.88907,54.29626,1.96904),(-.9023,54.31705,1.9614),(-.88168,54.2961,1.96659),(-.83931,54.30631,2.25581),(-.86347,54.30901,2.26167),(-.84669,54.26649,2.22723),(-.87684,54.31646,2.17323),(-.90211,54.32114,2.1857),(-.81085,54.31961,2.0125),(-.83023,54.3543,2.28357),(-.86215,54.35775,2.29114),(-.77719,54.365,2.03478),(-.89975,54.41999,2.3132),(-.91961,54.36714,2.26399),(-.92538,54.4246,2.28668),(-.8989,54.36237,2.28846),(-.94258,54.44281,2.029),(-.9636,54.4427,2.04354),(-.84933,54.43789,1.99827),(-.8221,54.43547,1.99553),(-.90359,54.48839,2.33294),(-.93349,54.49359,2.30425),(-.92147,54.4301,2.21702),(-.92178,54.49809,2.22495),(-.72031,54.49112,2.08806),(-.75695,54.42144,2.02852),(-.74839,54.41562,2.0581),(-.72797,54.49311,2.04804),(-.9733,54.43786,2.06789),(-.98282,54.51173,2.12925),(-.97525,54.43011,2.09696),(-.98211,54.51284,2.09349),(-.91151,54.44234,2.01153),(-.87193,54.51389,2.01781),(-.91042,54.51669,2.02535),(-.87865,54.43989,2.00507),(-.9392,54.49569,2.27894),(-.94289,54.56564,2.28451),(-.94235,54.57592,2.06403),(-.90378,54.57547,2.04298),(-.94685,54.51724,2.04494),(-.75398,54.50129,2.01643),(-.80566,54.50859,2.00673),(-.74217,54.56016,2.02862),(-.88374,54.49838,2.15143),(-.97257,54.51664,2.06439),(-.46604,54.50722,2.6836),(-.46951,54.58079,2.7235),(-.46287,54.5838,2.69191),(-.47234,54.50437,2.71358),(-.55032,54.49408,2.7992),(-.58399,54.56703,2.83392),(-.55164,54.56995,2.81368),(-.58103,54.49131,2.81841),(-.49083,54.65295,2.64047),(-.46881,54.58601,2.66424),(-.46402,54.65145,2.66872),(-.49399,54.58742,2.63774),(-.51248,54.57373,2.78655),(-.55223,54.63435,2.82785),(-.51053,54.63837,2.79897),(-.44089,54.48527,2.85689),(-.45236,54.5631,2.87118),(-.46164,54.47485,2.9069),(-.33772,54.51051,2.78883),(-.30576,54.51311,2.80336),(-.42402,54.62728,2.84491),(-.37163,54.58449,2.80684),(-.40789,54.57545,2.83185),(-.50513,54.28966,2.71241),(-.51501,54.34879,2.74807),(-.49151,54.35204,2.72053),(-.52386,54.28751,2.73228),(-.47889,54.35472,2.69505),(-.49005,54.41691,2.72977),(-.47684,54.41972,2.70308),(-.54917,54.41018,2.7825),(-.57766,54.40762,2.80033),(-.4866,54.50133,2.74235),(-.31785,54.32332,2.79115),(-.34438,54.31626,2.80084),(-.29798,54.51139,2.82297),(-.36197,54.50616,2.79405),(-.58891,54.49236,2.45715),(-.59317,54.56787,2.50364),(-.58106,54.57164,2.47198),(-.60151,54.48892,2.48549),(-.6931,54.55907,2.58184),(-.72133,54.48096,2.55603),(-.7296,54.55828,2.58361),(-.68925,54.48154,2.55372),(-.58449,54.57674,2.41986),(-.59123,54.497,2.40893),(-.62218,54.6234,2.55516),(-.58477,54.62768,2.51843),(-.62575,54.56414,2.53597),(-.73309,54.6165,2.60636),(-.57529,54.63765,2.42757),(-.57253,54.63491,2.45316),(-.65795,54.67789,2.59636),(-.62104,54.68266,2.57074),(-.65638,54.62078,2.58156),(-.61118,54.56556,2.83984),(-.63875,54.48878,2.82406),(-.64477,54.56437,2.83987),(-.60686,54.4899,2.82403),(-.69099,54.56854,2.77389),(-.67025,54.49672,2.72086),(-.67801,54.57274,2.73111),(-.68259,54.49274,2.76146),(-.58881,54.58254,2.65482),(-.55299,54.50879,2.63009),(-.55448,54.58546,2.63547),(-.58557,54.50602,2.64846),(-.59184,54.64776,2.65861),(-.65138,54.6284,2.85574),(-.66471,54.56494,2.82546),(-.67262,54.629,2.8404),(-.68683,54.63732,2.73989),(-.65234,54.57595,2.70466),(-.6595,54.64073,2.7117),(-.67864,54.21798,2.40441),(-.67979,54.21894,2.41445),(-.68173,54.21699,2.40906),(-.6721,54.22521,2.3773),(-.67544,54.22227,2.38125),(-.67149,54.22476,2.38029),(-.67572,54.22251,2.3798),(-.6803,54.22328,2.37373),(-.68171,54.22316,2.3741),(-.69735,54.22004,2.38774),(-.69516,54.22366,2.3798),(-.69989,54.22245,2.38514),(-.69352,54.22105,2.38308),(-.70071,54.21756,2.41309),(-.70093,54.21708,2.40316),(-.70497,54.21831,2.40711),(-.6976,54.21641,2.4077),(-.69738,54.23125,2.37682),(-.68962,54.22467,2.37516),(-.68372,54.22422,2.42546),(-.67814,54.22548,2.42034),(-.68468,54.21796,2.41784),(-.6691,54.23217,2.37235),(-.67352,54.22539,2.37502),(-.66764,54.23145,2.37593),(-.67207,54.25499,2.35914),(-.6509,54.24983,2.38519),(-.65019,54.25341,2.37622),(-.66664,54.23011,2.38114),(-.7095,54.24963,2.3837),(-.708,54.2298,2.39044),(-.70364,54.22988,2.38317),(-.71686,54.24801,2.39437),(-.70439,54.3083,2.38459),(-.72366,54.30582,2.3992),(-.69928,54.25044,2.37369),(-.64388,54.31693,2.35953),(-.62597,54.30271,2.43382),(-.61988,54.30535,2.41833),(-.72305,54.2451,2.41017),(-.74064,54.29514,2.45158),(-.72176,54.24089,2.42632),(-.74295,54.29891,2.42948),(-.75929,54.36776,2.45092),(-.73391,54.30285,2.41187),(-.75055,54.37343,2.4311),(-.68455,54.31141,2.37102),(-.65911,54.36117,2.49263),(-.63351,54.36576,2.47783),(-.72851,54.35755,2.5046),(-.72684,54.29201,2.46867),(-.73975,54.35877,2.49812),(-.71766,54.29162,2.47292),(-.75581,54.3621,2.48174),(-.75089,54.43443,2.52679),(-.76817,54.4359,2.50899),(-.58906,54.44667,2.42707),(-.59282,54.44877,2.40276),(-.65832,54.43707,2.52128),(-.62801,54.43808,2.50139),(-.65854,54.48309,2.53651),(-.68762,54.43632,2.53494),(-.7587,54.48105,2.54228),(-.77334,54.48303,2.52332),(-.58763,54.49486,2.43124),(-.55315,54.16554,2.67694),(-.55273,54.16987,2.68577),(-.5467,54.1707,2.67869),(-.55716,54.16499,2.68165),(-.57406,54.16811,2.69726),(-.57618,54.16365,2.68929),(-.58132,54.16786,2.69725),(-.57135,54.16382,2.68929),(-.58277,54.16425,2.67984),(-.58838,54.16966,2.67388),(-.59122,54.16876,2.68305),(-.58088,54.16485,2.67374),(-.56916,54.17177,2.65751),(-.56319,54.16667,2.66007),(-.56179,54.17239,2.65333),(-.56809,54.16625,2.66285),(-.54337,54.17251,2.6594),(-.55007,54.16643,2.66806),(-.54207,54.17204,2.66534),(-.55094,54.16674,2.6641),(-.54348,54.17139,2.67215),(-.56118,54.16906,2.69163),(-.5663,54.19602,2.72231),(-.55464,54.19707,2.71504),(-.56818,54.16843,2.69599),(-.59537,54.19527,2.71923),(-.5895,54.16822,2.68984),(-.60186,54.19567,2.71206),(-.58561,54.16798,2.69414),(-.58283,54.17035,2.66822),(-.57954,54.20049,2.66586),(-.59076,54.19922,2.67593),(-.57611,54.17111,2.66219),(-.54762,54.20311,2.64884),(-.5488,54.17282,2.65374),(-.53608,54.2033,2.65133),(-.55655,54.17271,2.65183),(-.5213,54.24701,2.64938),(-.5249,54.20283,2.66125),(-.50776,54.24595,2.66249),(-.56773,54.23732,2.74435),(-.55149,54.23878,2.73421),(-.58517,54.24323,2.6697),(-.60315,54.24119,2.68585),(-.57196,54.29314,2.65144),(-.59461,54.291,2.66669),(-.56902,54.24475,2.65882),(-.51784,54.2426,2.70416),(-.53185,54.24067,2.7206),(-.58622,54.28224,2.76387),(-.59823,54.23599,2.74729),(-.58138,54.23658,2.7473),(-.63784,54.28498,2.7269),(-.65785,54.34487,2.73536),(-.57912,54.35619,2.63752),(-.60626,54.35364,2.65579),(-.57122,54.34429,2.78411),(-.59356,54.34287,2.78824),(-.56946,54.2831,2.7608),(-.64875,54.40577,2.79289),(-.66469,54.40675,2.77534),(-.63776,54.41546,2.68663),(-.61027,54.41859,2.6619),(-.63251,54.35065,2.6794),(-.53014,54.42512,2.61969),(-.49839,54.42555,2.62766),(-.52977,54.35987,2.61548),(-.60162,54.40632,2.80554),(-.67487,54.49038,2.79147),(-.67183,54.40894,2.74752),(-.61624,54.50314,2.66909),(-.58183,54.42126,2.64277),(-.58162,54.16389,2.68436),(-.55101,54.166,2.67259),(-.57904,54.16373,2.68722),(-.57719,54.1653,2.66998),(-.57271,54.16581,2.66597),(-.56744,54.16403,2.68845),(-.56278,54.16445,2.68555),(-.55971,54.16687,2.65907),(-.55455,54.16694,2.66034),(-.31122,54.64918,2.90076),(-.30308,54.58673,2.86075),(-.30625,54.58196,2.88999),(-.30589,54.65358,2.87245),(-.30124,54.49907,2.9039),(-.3244,54.56563,2.98311),(-.30941,54.5772,2.91928),(-.31691,54.48842,2.96585),(-.31626,54.63807,2.92794),(-.34832,54.55603,3.02433),(-.35569,54.60446,3.03995),(-.19285,54.62779,3.04762),(-.19483,54.58339,2.99445),(-.19206,54.57539,3.03009),(-.1968,54.636,3.01122),(-.22169,54.55004,3.12151),(-.24267,54.59746,3.15117),(-.22423,54.60195,3.14114),(-.23974,54.54557,3.1313),(-.28984,54.57908,2.96624),(-.27307,54.5356,2.9198),(-.27823,54.58807,2.93421),(-.28572,54.52682,2.95019),(-.19409,54.56476,3.0733),(-.19265,54.52283,3.01227),(-.19316,54.51247,3.05447),(-.28415,54.59579,3.13835),(-.29901,54.54603,3.10029),(-.30325,54.59812,3.11949),(-.28033,54.54382,3.11875),(-.29391,54.63188,2.98242),(-.28206,54.64105,2.94967),(-.14923,54.50466,3.12417),(-.14667,54.56801,3.17543),(-.14378,54.49917,3.14457),(-.15259,54.57338,3.15281),(-.04339,54.57842,3.12232),(-.05392,54.5138,3.05545),(-.05089,54.50534,3.09618),(-.0475,54.5889,3.0768),(-.08401,54.4924,3.15939),(-.1026,54.56195,3.19838),(-.08056,54.56275,3.19335),(-.10365,54.49227,3.16396),(-.15663,54.5199,3.05684),(-.15873,54.57947,3.1271),(-.15475,54.51053,3.10089),(-.1621,54.5908,3.07752),(-.12868,54.53824,2.95327),(-.08965,54.61474,2.96658),(-.12701,54.61638,2.96257),(-.09436,54.53545,2.95676),(-.16008,54.60052,3.03441),(-.1609,54.62457,3.08757),(-.15869,54.63484,3.04463),(-.06567,54.64725,3.01086),(-.06817,54.60713,2.99882),(-.08932,54.65342,2.97784),(-.06365,54.5658,3.17887),(-.06341,54.6065,3.19195),(-.26921,54.06386,2.82575),(-.27069,54.06145,2.82365),(-.28965,54.0393,2.83522),(-.28361,54.04574,2.82878),(-.269,54.06947,2.8328),(-.26994,54.06571,2.83814),(-.26993,54.06957,2.8385),(-.26907,54.06562,2.83273),(-.28287,54.05387,2.86047),(-.28929,54.04968,2.865),(-.28418,54.05635,2.8639),(-.28708,54.04854,2.86127),(-.29281,54.0371,2.84379),(-.28182,54.07914,2.85248),(-.27973,54.08166,2.8413),(-.27308,54.06789,2.84983),(-.29306,54.04424,2.86261),(-.29204,54.13478,2.82753),(-.30895,54.12044,2.88717),(-.28808,54.07301,2.86474),(-.29912,54.12769,2.86965),(-.36101,54.09653,2.85433),(-.29768,54.19617,2.84542),(-.29359,54.13321,2.83824),(-.29431,54.19752,2.83094),(-.31979,54.18492,2.91078),(-.38914,54.16882,2.91145),(-.39053,54.171,2.89536),(-.37213,54.18436,2.82802),(-.34945,54.18868,2.81621),(-.3619,54.24976,2.81582),(-.30127,54.25786,2.86997),(-.29805,54.25975,2.85136),(-.30032,54.19494,2.86072),(-.38771,54.22664,2.95004),(-.37367,54.16858,2.92906),(-.40357,54.22614,2.93111),(-.40755,54.22866,2.91316),(-.40276,54.30164,2.83577),(-.37382,54.30893,2.81695),(-.38948,54.24297,2.83392),(-.29456,54.26131,2.83353),(-.29507,54.32315,2.85225),(-.29245,54.32517,2.83349),(-.3262,54.24489,2.93301),(-.36084,54.29452,2.97747),(-.32895,54.30355,2.95556),(-.38448,54.34454,3.0101),(-.36293,54.35187,2.99906),(-.38069,54.28812,2.98709),(-.42276,54.28931,2.9013),(-.44256,54.34766,2.9155),(-.31159,54.3731,2.93594),(-.29831,54.31952,2.87752),(-.30928,54.31205,2.91924),(-.29417,54.38073,2.8833),(-.337,54.41217,2.98884),(-.33146,54.36201,2.97789),(-.31574,54.42285,2.94792),(-.42,54.39198,3.00691),(-.41286,54.34065,2.99493),(-.29381,54.43341,2.86732),(-.28732,54.38554,2.8352),(-.2889,54.38383,2.85586),(-.28945,54.43599,2.84336),(-.30019,54.43097,2.89444),(-.4004,54.46407,3.04205),(-.43173,54.46182,3.02562),(-.3892,54.39448,3.02312),(-.4676,54.46945,2.93758),(-.45187,54.40408,2.89252),(-.45782,54.39871,2.92305),(-.37515,54.46926,3.03224),(-.44936,54.5591,3.0475),(-.46593,54.53955,3.01758),(-.44288,54.5391,3.04387),(-.1991,54.21458,2.9212),(-.19389,54.22341,2.93368),(-.19384,54.22605,2.92172),(-.19877,54.2133,2.92645),(-.21753,54.22547,2.89661),(-.20861,54.2133,2.91028),(-.20647,54.21485,2.90807),(-.22137,54.22074,2.90223),(-.20624,54.2162,2.95191),(-.20278,54.20968,2.93318),(-.23848,54.33698,2.86586),(-.21795,54.2984,2.87393),(-.2196,54.33921,2.87088),(-.23329,54.2957,2.8702),(-.20063,54.33015,2.91364),(-.20602,54.33558,2.8851),(-.20263,54.2761,2.97777),(-.21075,54.27061,2.9919),(-.20311,54.30983,2.99559),(-.20731,54.23921,2.97116),(-.22218,54.26619,2.99928),(-.21654,54.23492,2.97626),(-.19806,54.28783,2.93662),(-.19582,54.25332,2.92714),(-.24744,54.26263,2.98821),(-.25666,54.26465,2.96942),(-.27583,54.33652,3.00818),(-.27255,54.30626,2.96198),(-.28117,54.34403,2.97759),(-.26713,54.3004,2.98824),(-.19865,54.43022,2.90357),(-.21688,54.37941,2.87155),(-.20053,54.37322,2.8918),(-.21724,54.43507,2.88129),(-.19744,54.48588,2.91991),(-.21712,54.49134,2.89171),(-.21432,54.39129,3.0597),(-.19673,54.36634,2.92131),(-.19297,54.41401,2.97324),(-.19437,54.42176,2.93948),(-.19511,54.35864,2.95571),(-.19245,54.46904,2.9924),(-.19373,54.45894,3.03441),(-.2336,54.44119,3.09135),(-.25773,54.49165,3.11144),(-.23675,54.49399,3.11151),(-.25412,54.439,3.09133),(-.19448,54.40465,3.01241),(-.20027,54.45088,3.06529),(-.20085,54.39689,3.04206),(-.28589,54.4088,2.95554),(-.29432,54.45193,3.01932),(-.28939,54.39838,2.99898),(-.28969,54.4635,2.97168),(-.24022,54.37869,2.86535),(-.25997,54.37099,2.87626),(-.29475,54.49462,3.08127),(-.27647,54.49242,3.09929),(-.29414,54.51668,2.98895),(-.28145,54.47337,2.9338),(-.20022,54.24412,2.96048),(-.25527,54.29693,3.01099),(-.26204,54.33308,3.02888),(-.24015,54.2974,3.0206),(-.27214,54.31381,2.93076),(-.26554,54.3221,2.89862),(-.26125,54.2751,2.92053),(-.20098,54.34309,3.01517),(-.19955,54.31611,2.97491),(-.19591,54.34987,2.99133),(-.26117,54.54308,3.1312),(-.14702,54.19569,2.97326),(-.14638,54.19142,2.96491),(-.14729,54.19814,2.96851),(-.14595,54.18969,2.96818),(-.14714,54.20274,2.95407),(-.14586,54.19592,2.94808),(-.14633,54.19504,2.95355),(-.14653,54.19383,2.95831),(-.14571,54.18884,2.96971),(-.14104,54.18408,2.96307),(-.1413,54.18633,2.95738),(-.14213,54.18906,2.95264),(-.12566,54.20502,2.93218),(-.11524,54.20719,2.94229),(-.12269,54.19954,2.9435),(-.12127,54.1949,2.95536),(-.11335,54.20077,2.95627),(-.11893,54.19383,2.99324),(-.12358,54.19411,3.00067),(-.1382,54.2034,2.99862),(-.13964,54.21032,2.98138),(-.13664,54.22445,3.00069),(-.13924,54.2074,2.98932),(-.1382,54.22749,2.99078),(-.13894,54.221,2.94879),(-.13636,54.23412,2.96937),(-.13987,54.21579,2.96558),(-.13445,54.23907,2.9464),(-.13557,54.18829,2.95024),(-.13476,54.18573,2.95512),(-.14278,54.2002,2.98328),(-.14308,54.21135,2.95104),(-.15007,54.47904,2.96753),(-.13176,54.43636,2.9177),(-.13179,54.4825,2.93428),(-.14977,54.43397,2.95139),(-.10246,54.39091,2.90487),(-.08051,54.42763,2.95056),(-.1003,54.43256,2.92053),(-.08719,54.3864,2.9344),(-.073,54.52943,2.98594),(-.09889,54.47912,2.93749),(-.07473,54.4735,2.96707),(-.0701,54.44051,3.12799),(-.06894,54.49478,3.14649),(-.08491,54.43827,3.14093),(-.06526,54.46607,3.00491),(-.05907,54.45845,3.03759),(-.06247,54.52144,3.02324),(-.06097,54.39933,3.09137),(-.05642,54.44432,3.10843),(-.07348,54.39551,3.11117),(-.07783,54.37927,2.97218),(-.06488,54.41306,3.02082),(-.07025,54.42052,2.98798),(-.06986,54.3715,3.00453),(-.08736,54.39319,3.1243),(-.07645,54.35436,3.09545),(-.09033,54.35195,3.10857),(-.15035,54.36704,3.07444),(-.1447,54.40224,3.1095),(-.1455,54.36105,3.09427),(-.14997,54.40813,3.08961),(-.14974,54.39325,2.93615),(-.15513,54.43011,2.98406),(-.15326,54.38939,2.96919),(-.15086,54.33162,3.03372),(-.14729,54.32503,3.05795),(-.1554,54.37329,3.05143),(-.14912,54.45239,3.10573),(-.14385,54.44667,3.12566),(-.15483,54.52767,3.01829),(-.14913,54.53334,2.986),(-.15576,54.47448,3.00003),(-.15537,54.41429,3.06654),(-.15461,54.45843,3.08262),(-.13651,54.27198,2.94727),(-.09214,54.26539,2.94686),(-.10612,54.2277,2.94243),(-.09957,54.2716,2.92111),(-.09083,54.24595,3.03925),(-.10424,54.21075,3.00762),(-.08183,54.24929,3.02131),(-.13549,54.25516,3.02143),(-.13748,54.25952,3.00645),(-.13749,54.26647,2.97304),(-.14442,54.29236,3.01957),(-.1429,54.30016,2.98261),(-.10437,54.30942,2.89423),(-.12514,54.31123,2.89178),(-.08835,54.25989,2.9716),(-.07613,54.28463,3.01593),(-.08107,54.29127,2.98147),(-.08334,54.25397,3.00269),(-.09351,54.27366,3.06985),(-.14219,54.3191,3.07666),(-.14202,54.28688,3.0392),(-.13689,54.28114,3.05757),(-.13835,54.30998,2.921),(-.14944,54.34669,2.95736),(-.14132,54.30649,2.94942),(-.14369,54.35025,2.92465),(-.08292,54.33659,2.96102),(-.09435,54.30469,2.91895),(-.08714,54.29799,2.9525),(-.09161,54.34321,2.92602),(-.07608,54.27922,3.04209),(-.07852,54.31252,3.07909),(-.06944,54.31643,3.05932),(-.08424,54.27605,3.05879),(-.09111,54.31034,3.09148),(-.07605,54.32955,2.99248),(-.06466,54.36436,3.04499),(-.06998,54.32252,3.02948),(-.33724,53.53464,2.67376),(-.31282,53.60952,2.59513),(-.43591,53.54007,2.59803),(-.11837,53.57785,2.6783),(-.83486,54.32513,1.6873),(-.78402,54.28627,1.78452),(-.79561,54.26588,1.7828),(-.82175,54.34436,1.69029),(-.9844,54.56784,1.29947),(-.94584,54.49233,1.39475),(-.96659,54.58462,1.30083),(-1.5422,54.94331,.82316),(-1.53383,56.16761,1.51305),(-1.5116,56.17783,1.65381),(-1.67955,55.60424,.39703),(-1.67963,55.50967,.51772),(-1.66815,55.50336,.49081),(-1.69291,55.61054,.42545),(-1.51676,55.68647,1.03071),(-1.71966,55.58439,.25713),(-1.62063,55.59293,.66436),(-1.60766,55.61069,.68051),(-1.29283,55.33616,1.271),(-1.39816,56.29274,.0318),(-1.57465,56.36745,1.53539),(-1.57413,56.30979,1.46511),(-1.54013,55.51635,1.15061),(-1.55994,54.74536,1.06977),(-1.58753,54.92652,1.0238),(-1.57452,54.73253,1.01983),(-1.57236,54.92836,1.07253),(-1.37226,54.59028,1.54462),(-1.42111,54.72177,1.45855),(-1.38228,54.57237,1.51423),(-1.41174,54.738,1.49027),(-1.49289,55.5375,1.53055),(-1.49599,55.6907,1.61501),(-1.5021,55.694,1.57311),(-1.70863,55.47019,.58633),(-1.68334,55.31311,.67335),(-1.69732,55.47538,.64141),(-1.69363,55.30892,.61781),(-1.4877,55.36696,1.49021),(-1.21075,54.21025,1.99427),(-.16963,53.58015,2.66252),(-.16858,53.58944,2.65385),(-.69529,53.98142,2.61263),(-.73175,53.97923,2.56838),(-.76173,54.04462,2.62807),(-.67687,54.00392,2.62131),(-.7769,54.02039,2.61995),(-.17297,53.46416,2.976),(-.09855,53.48343,2.97297),(-.41658,53.6038,2.98404),(-.48317,53.59943,2.92046),(-.59448,54.58483,2.30133),(-.58866,54.083,2.18692),(-.64612,53.99178,2.1851),(-.4085,54.04103,2.45991),(-.43921,53.92509,2.44789),(-.53568,54.53989,2.47326),(-.35644,54.30919,2.65921),(-.64723,54.41026,2.88962),(-.65282,54.51455,2.89779),(-.61477,54.02048,2.78286),(-.35088,54.00477,2.90054),(-.51653,54.49321,3.03441),(-.36704,54.14812,2.92683),(-.57374,54.72888,2.43833),(-.47859,53.70013,2.89505),(-.66031,54.71038,2.60056),(-.65797,54.71652,2.60695),(-.64936,54.71585,2.6435),(-.62038,54.72104,2.58083),(-.51431,54.67382,2.80708),(-.55267,54.6675,2.83358),(-.63432,54.68794,2.68403),(-.63882,54.69544,2.67942),(-.59598,54.69087,2.65924),(-.70827,54.66796,2.79211),(-.69949,54.65952,2.82712),(-.58901,54.66289,2.85796),(-.61562,54.62966,2.85571),(-.62309,54.65751,2.86304),(-.58666,54.63124,2.84941),(-.48472,54.6807,2.77267),(-.46477,54.6459,2.73183),(-.48076,54.64249,2.76411),(-.43758,54.67209,2.85406),(-.31043,53.61721,2.58759),(-.34707,54.17092,2.58138),(-.56922,53.6109,2.83334),(-.64697,53.53845,2.69222),(-.55614,53.52029,2.79451),(-.6643,53.62359,2.73808),(-.47619,54.35,2.5092),(-.41631,54.32959,2.58394),(-.49496,54.50603,2.55474),(-.56579,54.69254,2.49508),(-.57927,54.68875,2.53227),(-.65523,54.65536,2.86538),(-.6804,54.65589,2.84988),(-.69193,54.63019,2.81915),(-.52663,54.38476,2.41502),(-.48249,53.80854,2.45073),(-.75204,53.60174,2.59038),(-.77163,53.69388,2.64119),(-.70678,54.31532,2.80595),(-.7151,54.42546,2.83097),(-.51857,54.22412,2.34801),(-.46181,54.20007,2.44918),(-.49854,53.7071,2.44411),(-.3091,54.68706,2.90141),(-.42359,54.59453,3.0879),(-.42282,54.5954,3.08388),(-.30723,54.667,3.03877),(-.20464,54.66162,3.1464),(-.19854,54.66737,3.10871),(-.19356,54.67302,3.11209),(-.16436,54.66228,3.1018),(0,54.66259,3.10132),(-.03692,54.65819,3.09969),(-.05212,54.63799,3.05327),(-.33683,54.66928,3.00205),(-.33314,54.61976,2.99138),(-.3187,54.68299,2.93791),(-.3052,54.6542,3.03327),(-.30268,54.62121,3.02294),(-.28613,54.62168,3.14646),(-.04678,54.61085,3.16899),(-.16111,54.65066,3.14766),(-.16136,54.64384,3.09578),(-.15889,54.63613,3.14397),(-.10542,54.28292,3.07861),(0,53.73757,2.59146),(0,53.65991,3.04773),(-.45848,54.00389,2.8598),(-.23284,53.66934,2.61138),(-.23115,53.74549,2.59544),(-.74572,53.99964,2.54104),(-.7446,54.0005,2.54181),(-.80913,54.08879,2.55402),(-.82897,54.06514,2.53699),(-.90463,54.05416,1.90768),(-.78587,54.07788,1.97986),(-.85708,53.9945,2.00157),(-.82644,54.13361,1.88629),(-.7839,53.94071,2.10053),(-.89137,53.87845,1.99109),(-.82041,53.8298,2.09148),(-.68129,54.32045,2.01957),(-.62874,54.28101,2.13204),(-.85905,53.73838,2.53814),(-.7456,53.80122,2.64968),(-.82905,53.85625,2.55098),(-1.23736,54.87148,1.58183),(-.92944,54.17055,2.42073),(-.94172,54.09555,2.39363),(-1.15352,54.25714,2.11219),(-.93567,54.54235,2.43584),(-.89604,54.50739,2.53209),(-.91334,54.66215,1.30842),(-1.0374,54.54145,2.22003),(-1.06054,54.46907,2.18431),(-.74044,54.75535,1.82634),(-1.06895,54.29547,1.53177),(-.94612,54.31084,1.60473),(-1.03259,54.24096,1.62114),(-.98158,54.36113,1.50471),(-.98091,54.84436,1.61058),(-1.01803,54.85043,1.62313),(-.98026,54.84782,1.61874),(-1.01829,54.84677,1.61488),(-.8237,54.86147,1.50371),(-.82571,54.85652,1.54167),(-.85317,54.87664,1.40816),(-1.12058,54.8662,1.5418),(-1.11664,54.86388,1.5625),(-1.1264,54.87389,1.54542),(-1.06461,54.8997,1.407),(-1.02494,54.89841,1.39576),(-1.12265,54.89927,1.46345),(-1.13012,54.00959,1.58527),(-1.03693,54.06145,1.70249),(-1.07719,53.94171,1.68565),(-1.08413,54.12796,1.60407),(-.86023,54.40337,1.59454),(-.78788,54.44624,1.70829),(-.82586,54.4921,1.60118),(-.77972,54.73988,1.7633),(-.76827,54.79408,1.80245),(-.90489,54.81322,1.67541),(-.94152,54.82175,1.6762),(-.94171,54.81356,1.68128),(-.85531,54.75912,2.05197),(-.96193,54.75005,2.2864),(-.96714,54.75071,2.22718),(-.97471,54.75123,2.22803),(-.89322,54.76187,2.06104),(-.89502,54.76763,2.05566),(-.85531,54.7529,2.05785),(-.65379,54.70992,2.17761),(-.70056,54.7199,2.42876),(-.80198,54.694,2.57181),(-.77974,54.69383,2.59731),(-.7941,54.70454,2.49921),(-.79219,54.67491,2.49556),(-.67673,54.72319,2.40923),(-.67435,54.6907,2.40504),(-.65433,54.7253,2.40416),(-.72076,54.02827,2.08311),(-.70481,53.90491,2.20182),(-.99991,54.49635,2.31559),(-.95257,54.44793,2.40805),(-.98367,54.58258,2.34814),(-.94647,53.78287,2.43611),(-.93318,53.67143,2.3937),(-1.04935,53.91792,2.28407),(-.85923,54.48217,2.60577),(-.90259,54.40913,2.50053),(-.86406,54.3812,2.57355),(-.94238,54.84529,1.64674),(-.9446,54.84588,1.60841),(-.98125,54.84635,1.65642),(-1.18451,54.88129,1.56832),(-.9285,54.76073,2.07821),(-.93638,54.83495,1.47754),(-1.11921,54.8409,1.53522),(-1.11211,54.81183,1.52805),(-.83119,54.83226,1.53427),(-.82932,54.83912,1.49697),(-.83968,54.80345,1.52969),(-.91475,54.79582,1.57102),(-.94597,54.8232,1.59104),(-.91036,54.82509,1.57952),(-.9484,54.79384,1.58166),(-1.08997,54.79803,1.58179),(-1.0952,54.8261,1.59479),(-1.06107,54.86331,1.4061),(-.94495,54.86691,1.37999),(-.91002,54.83705,1.37117),(-.90478,54.86557,1.37987),(-.94763,54.83753,1.37111),(-1.09272,54.85127,1.60391),(-1.10767,54.83222,1.5759),(-1.10658,54.85782,1.58354),(-.87996,54.88157,1.38531),(-.87265,54.86216,1.39151),(-.86698,54.87939,1.39325),(-.88424,54.86403,1.38421),(-.98616,54.86559,1.38612),(-.85667,54.85857,1.40651),(-.84699,54.82899,1.55527),(-.87513,54.82563,1.57),(-.98246,54.82264,1.60091),(-.76601,54.78669,1.82756),(-.77193,54.72986,1.81371),(-.86076,54.76442,1.66996),(-.76934,54.72569,1.83505),(-.87823,54.71274,1.95829),(-.93623,54.71619,1.9678),(-.813,54.69268,2.04549),(-.65162,54.70963,2.22021),(-.66247,54.66568,2.21613),(-.90644,54.77624,2.0168),(-.94055,53.93669,1.89599),(-1.02425,53.87382,1.78666),(-.98973,53.99493,1.8015),(-.97067,53.81549,1.88098),(-.95217,54.11383,1.81438),(-.86702,54.18935,1.79327),(-.71599,54.36088,1.91636),(-.74618,54.2319,1.87983),(-.7507,54.40131,1.81372),(-.75697,54.21123,1.87755),(-1.37741,54.36192,1.52452),(-1.28715,54.57019,1.84722),(-1.34748,54.64421,1.65115),(-1.31077,54.49143,1.71633),(-1.4616,55.0278,1.45966),(-1.44754,55.0553,1.52838),(-1.43209,54.87316,1.46511),(-1.24882,54.4018,1.92307),(-1.27559,54.3272,1.80441),(-.90657,54.2501,1.69874),(-.76598,54.69587,2.6096),(-.80735,54.45822,2.67562),(-.81583,54.35838,2.64495),(-.91251,53.91129,2.45328),(-1.4412,54.86104,1.43167),(-1.47748,54.82113,1.31958),(-1.53833,54.95561,1.16029),(-1.52263,54.77463,1.16937),(-1.65308,55.99536,-.00248),(-1.62496,55.99916,.00406),(-1.61114,56.02916,.34378),(-1.57379,55.81582,1.05719),(-1.45343,55.70445,1.69072),(-1.45344,55.60142,1.67219),(-1.44339,55.81142,1.71414),(-1.45423,55.93269,1.75082),(-1.45213,55.80895,1.72336),(-1.44608,55.93437,1.74276),(-1.47015,56.18292,1.75381),(-1.4554,56.06135,1.75521),(-1.4564,56.1835,1.75716),(-1.469,56.06161,1.75095),(-1.46212,56.31085,1.75184),(-1.47892,56.41432,1.76844),(-1.46868,56.30936,1.76086),(-1.49638,56.50208,1.76048),(-1.51916,56.56891,1.72915),(-1.55872,56.58978,1.65901),(-1.54942,56.59865,1.65604),(-1.44227,55.50393,1.65403),(-1.46141,56.20339,1.6661),(-1.47088,56.34853,1.61876),(-1.56006,56.22756,1.29794),(-1.5291,56.19939,1.35713),(-1.6353,55.425,.66202),(-1.69822,55.71415,.32595),(-1.44977,56.18467,1.74865),(-1.44805,56.06234,1.74693),(-1.46487,56.20071,1.68012),(-1.74261,55.72927,.48195),(-1.58487,56.05395,1.19587),(-1.60927,56.01857,1.04189),(-1.60436,55.97025,1.03967),(-1.60277,56.08421,1.13563),(-1.58813,56.22141,1.29888),(-1.57934,56.16321,1.21001),(-1.59454,56.14973,1.21924),(-1.57371,56.23423,1.28478),(-1.61278,55.99564,.90166),(-1.59599,56.02877,1.03185),(-1.75247,56.18825,-.04305),(-1.67392,56.17874,-.09562),(-1.92674,56.30555,.29246),(-1.49706,56.08192,.0133),(-1.55977,56.06988,-.02111),(-1.60903,56.53206,.0671),(-1.67624,56.07095,-.03885),(-1.73333,55.99631,.04428),(-1.73659,56.09139,-.00005),(-1.67955,55.99427,.00097),(-1.66284,56.4582,.14868),(-1.81858,56.47776,.09361),(-1.84418,56.46298,.05174),(-1.46487,56.498,-.06699),(-1.62534,55.77557,.81648),(-1.72771,55.59909,.54571),(-1.48103,55.52673,1.40543),(-1.7344,55.5825,.29881),(-1.61712,54.90828,.85599),(-1.62572,55.1095,.84786),(-1.51744,55.34727,1.22239),(-1.54024,55.1403,1.18022),(-1.48424,55.35465,1.3701),(-1.64083,55.32631,.81906),(-1.6443,55.48717,.78033),(-1.50863,56.17915,1.68464),(-1.50796,56.04504,1.66837),(-1.60108,55.79205,.93735),(-1.78509,56.00797,.08601),(-1.8378,56.03078,.14386),(-1.84983,56.2651,-.00619),(-1.86084,56.32207,-.00965),(-1.90753,56.25365,.07408),(-1.75678,56.4175,-.05749),(-1.64559,56.43171,-.10131),(-1.74893,56.1245,.37838),(-1.65499,55.52681,.55601),(-1.36102,55.53964,1.25053),(-1.60618,54.91781,.92925),(-1.59177,54.7138,.93252),(-1.63732,55.39252,.57235),(-1.63655,55.57484,.64742),(-1.64478,55.6678,.52978),(-1.53268,56.01136,1.22388),(-1.45487,56.52443,-.02275),(-1.8569,56.3882,.00691),(-1.79811,56.11084,.04617),(-1.56241,55.51143,1.08794),(-1.62871,55.9831,.91405),(-1.624,55.93692,.91137),(-1.49,56.41249,1.76625),(-1.48059,56.30825,1.75847),(-1.60899,55.33619,.95363),(-1.56135,55.341,1.12873),(-1.57981,55.12406,1.09845),(-1.71543,55.61791,.59719),(-1.46839,55.93344,1.74585),(-1.61855,56.06431,-.04003),(-1.91079,56.39573,.11262),(-1.82328,56.19078,.01568),(-1.58876,56.09276,1.12233),(-1.53591,56.10321,1.2939),(-1.40536,55.73038,1.32121),(-1.46718,55.7056,1.68592),(-1.65809,55.40723,.62404),(-1.56654,56.15525,1.21688),(-1.45283,55.5035,1.66067),(-1.46561,55.81026,1.71903),(-.84261,53.63659,2.49156),(-.76628,54.56567,1.73005),(-1.23502,54.16041,1.90465),(-1.13566,54.08186,2.16221),(-1.06889,53.81199,1.81874),(-1.42438,54.50708,1.41872),(-.99238,54.17739,1.71749),(-1.00539,54.7548,1.28079),(-1.38423,54.78981,1.59679),(-1.34744,54.84545,1.73074),(-.77794,54.68868,2.04189),(-1.06913,54.73688,1.92019),(-1.07054,54.77856,1.93408),(-1.06133,54.84549,1.6164),(-.9087,54.84501,1.58872),(-1.023,54.86492,1.39352),(-1.10898,54.82912,1.44022),(-.88142,54.79674,1.56223),(-.86489,54.83144,1.39511),(-1.02562,54.83454,1.49426),(-.93725,54.81672,1.47459),(-1.09538,54.85821,1.61129),(-.75749,54.78654,1.82516),(-.91709,53.75715,1.97592),(-.84686,53.70654,2.07933),(-.98633,53.99659,2.35307),(-.9647,54.34004,2.36998),(-1.01693,54.40627,2.27569),(-.91153,54.28763,2.46281),(-.84445,54.57469,2.62676),(-.80809,54.69996,2.53106),(-1.08845,54.78857,1.89964),(-1.0945,54.79006,1.90215),(-.76007,54.7933,1.80191),(-1.0616,54.85073,1.6251),(-1.17781,54.0746,1.49236),(-.87411,54.38439,1.59231),(-.90937,54.43766,1.49421),(-.75776,54.3356,2.72068),(-.83244,54.83691,1.4263),(-.6285,53.86814,2.29551),(-.74944,53.78115,2.19268),(-.66169,53.75017,2.28507),(-.77663,53.65592,2.18359),(-.76886,54.06924,2.60939),(-.82734,54.03862,2.54856),(-.74336,54.02405,2.53006),(-.71693,54.04901,2.54634),(-.15545,54.63064,3.16726),(-.15754,54.61301,3.1371),(-.15188,54.60762,3.16103),(-.19925,54.65647,3.10423),(-.30539,54.62645,3.12836),(-.26457,54.59499,3.15108),(-.19604,54.6169,3.09183),(-.25614,54.65118,2.91959),(-.04352,54.65162,3.09723),(-.04624,54.62977,3.08901),(-.27075,54.60784,3.1776),(-.64183,53.56565,2.40236),(-.6868,53.63104,2.27398),(-.59697,53.60615,2.36522),(-.76384,53.5605,2.33611),(-.57394,53.71918,2.37834),(-.70063,54.63284,2.78547),(-.62625,54.64452,2.68176),(-.23443,53.59756,2.62667),(-.50391,54.60983,3.00082),(-.76018,54.44099,2.75434),(-.40444,54.1855,2.51506),(-.37482,54.66356,2.72199),(-.57532,54.24816,2.24756),(-.78117,54.08913,2.58755),(-.68647,54.04804,2.5804),(-.81337,54.0182,2.57583),(-1.24381,54.4136,1.94052),(-1.28239,54.58299,1.86735),(-1.61938,55.90199,.91413),(-1.58066,55.33866,1.07201),(-1.5772,56.46777,.13429),(-1.95381,56.17896,.25317),(-1.39944,55.72092,1.3413),(-1.6453,55.40174,.59793),(-.23654,53.59078,2.63393),(-.06422,54.35815,3.0757),(-.10425,54.34862,2.89672),(-.15202,54.3401,2.99338),(-.12323,54.24751,3.04406),(-.10575,54.3936,3.1292),(-.10874,54.35249,3.11349),(-.06041,54.40584,3.0607),(-.05503,54.49871,3.12698),(-.14303,54.20794,2.9632),(-.14726,54.20087,2.96087),(-.14296,54.20282,2.97711),(-.10216,54.22172,2.96138),(-.1337,54.25094,3.03518),(-.13557,54.21981,3.01146),(-.21908,54.49824,3.10189),(-.19886,54.32314,2.94675),(-.26147,54.26927,2.94542),(-.22405,54.21494,2.92503),(-.24458,54.23493,2.93107),(-.29885,54.50467,3.03766),(-.30321,54.55622,3.05566),(-.2779,54.4185,2.91812),(-.27099,54.36257,2.90531),(-.20157,54.50414,3.08522),(-.27812,54.35369,2.93963),(-.23519,54.26333,2.99819),(-.22644,54.23183,2.97458),(-.24368,54.23913,2.91146),(-.20992,54.21124,2.91571),(-.21,54.20895,2.92402),(-.20528,54.21555,2.90747),(-.20379,54.21605,2.90807),(-.22392,54.21754,2.91336),(-.48004,54.54179,2.98815),(-.46802,54.46445,2.97116),(-.45424,54.46226,2.99992),(-.33957,54.47856,3.00642),(-.29498,54.50835,2.84673),(-.43665,54.35297,2.88527),(-.36575,54.40077,3.01267),(-.4187,54.29366,2.87412),(-.31004,54.25275,2.90285),(-.40714,54.23247,2.88728),(-.38632,54.17786,2.85284),(-.35673,54.10064,2.83719),(-.29538,54.13113,2.85219),(-.27692,54.06472,2.85776),(-.29022,54.044,2.85936),(-.27283,54.06423,2.84825),(-.27392,54.05748,2.82472),(-.04213,54.61921,3.13451),(-.15369,54.60857,2.99846),(-.12306,54.49505,3.15671),(-.12438,54.56423,3.19006),(-.04803,54.57056,3.15696),(-.25478,54.5968,2.90954),(-.30755,54.60851,3.07385),(-.20372,54.55618,3.10452),(-.25008,54.54438,2.89495),(-.21948,54.59782,2.92153),(-.22104,54.65214,2.93162),(-.2981,54.5037,2.8753),(-.52982,54.51018,2.6236),(-.49558,54.51065,2.63222),(-.64588,54.49977,2.69577),(-.65767,54.48932,2.81039),(-.55162,54.42382,2.62572),(-.55027,54.35864,2.62125),(-.64922,54.34805,2.70253),(-.66037,54.41264,2.70989),(-.6312,54.40528,2.80556),(-.54975,54.28467,2.75078),(-.54795,54.34562,2.77089),(-.55254,54.29474,2.64103),(-.63059,54.28665,2.70214),(-.61953,54.23806,2.71827),(-.49404,54.29147,2.69337),(-.53544,54.29577,2.6362),(-.53967,54.24695,2.64565),(-.61652,54.28851,2.68639),(-.60001,54.19807,2.68539),(-.61427,54.23978,2.69753),(-.58821,54.19506,2.72442),(-.54053,54.19842,2.70526),(-.56795,54.20159,2.65805),(-.60474,54.19656,2.70071),(-.57611,54.19549,2.72443),(-.53048,54.19981,2.69346),(-.58897,54.44445,2.45099),(-.77142,54.43805,2.4777),(-.7771,54.48593,2.49415),(-.71722,54.43476,2.53826),(-.68255,54.35883,2.50325),(-.59787,54.37825,2.4346),(-.63419,54.39138,2.3627),(-.63388,54.45247,2.37176),(-.73934,54.4343,2.53308),(-.70915,54.35737,2.50774),(-.60891,54.37217,2.45548),(-.71289,54.38051,2.3988),(-.71179,54.22767,2.40173),(-.68466,54.22563,2.37079),(-.70994,54.22336,2.41274),(-.70537,54.21985,2.39879),(-.70129,54.21801,2.39795),(-.68875,54.22202,2.37884),(-.67875,54.22292,2.37635),(-.67552,54.22562,2.37293),(-.67503,54.22103,2.38835),(-.68566,54.21635,2.41144),(-.62112,54.5795,2.67655),(-.68284,54.56605,2.80552),(-.73914,54.66996,2.61811),(-.76426,54.66888,2.60628),(-.6588,54.56137,2.56109),(-.58189,54.57435,2.44352),(-.74318,54.48101,2.54982),(-.62773,54.4858,2.5132),(-.42957,54.41472,2.84436),(-.38934,54.4251,2.81083),(-.38136,54.37207,2.81078),(-.471,54.42237,2.67528),(-.51467,54.41351,2.7586),(-.51314,54.49766,2.77344),(-.47554,54.35762,2.66919),(-.39974,54.49669,2.82052),(-.45769,54.6491,2.6982),(-.48452,54.5776,2.7538),(-.87437,54.24883,2.18887),(-.83413,54.24454,2.17264),(-.83498,54.24376,2.18918),(-.84109,54.2456,2.16953),(-.8445,54.24475,2.19334),(-.84582,54.24632,2.16749),(-.84831,54.24669,2.16652),(-.8689,54.24775,2.19585),(-.71281,54.55071,2.06491),(-.86325,54.57261,2.03472),(-.94805,54.49804,2.2561),(-.83754,54.51149,2.01002),(-.72462,54.489,2.10531),(-.78,54.43003,2.00186),(-.9091,54.39092,1.9938),(-.92445,54.37232,2.21149),(-.93227,54.43079,2.22527),(-.88234,54.38912,1.98862),(-.91073,54.31843,2.19339),(-.89144,54.31269,2.25872),(-.92843,54.30888,1.99972),(-.90545,54.33896,1.96634),(-.81799,54.30391,2.25101),(-.90163,54.29138,1.99501),(-.80341,54.26209,2.19322),(-.87816,54.36622,2.18792),(-.89764,54.29046,1.99224),(-.8626,54.29096,1.97186),(-.88133,54.29341,1.97008),(-.87586,54.29286,1.9698),(-.84379,54.57311,1.90637),(-.85767,54.50711,1.88213),(-.9009,54.61527,1.80567),(-.90052,54.55803,1.80309),(-1.01023,54.5833,1.93981),(-1.006,54.51927,1.91293),(-1.03959,54.66993,1.66117),(-.92295,54.57924,1.71152),(-.91343,54.5078,1.78637),(-.97605,54.51244,1.80098),(-.94243,54.53077,1.69071),(-1.0104,54.53313,1.70463),(-.85869,54.52849,1.65466),(-1.03397,54.47562,1.81163),(-1.0175,54.49713,1.69527),(-.96885,54.40373,1.82299),(-1.08012,54.46702,1.64381),(-.91819,54.44708,1.63727),(-.99258,54.46998,1.58828),(-.92209,54.4,1.75307),(-.97689,54.37758,1.79969),(-.97426,54.38809,1.8088),(-.99217,54.39579,1.7636),(-1.07762,54.41391,1.63108),(-1.06347,54.40286,1.62937),(-1.02052,54.39984,1.62271),(-1.0298,54.51218,1.8221),(-1.01665,54.41142,1.78045),(-.98023,54.45247,1.6748),(-1.03638,54.39868,1.63524),(-1.03833,54.43942,1.67723),(-.87233,54.52637,1.66852),(-.88135,54.52593,1.67401),(-1.02283,54.41001,1.78679),(-1.03149,54.51199,1.42027),(-1.02649,54.51217,1.42003),(-1.07696,54.7464,1.57397),(-1.0056,54.65993,1.32114),(-1.0142,54.72178,1.33673),(-.92822,54.655,1.39588),(-.96846,54.64868,1.41177),(-.95161,54.61339,1.52519),(-.913,54.62991,1.44825),(-.93561,54.60124,1.3454),(-.95692,54.60688,1.30646),(-.94408,54.66714,1.31297),(-1.02713,54.65711,1.33178),(-1.01881,54.59957,1.31992),(-1.03434,54.56994,1.34285),(-.98615,54.52746,1.43857),(-1.0183,54.53889,1.3447),(-.99756,54.55613,1.31524),(-1.0169,54.54334,1.33302),(-1.00193,54.53654,1.38495),(-.91854,54.65617,1.38463),(-.98929,54.54482,1.34358),(-1.00979,54.54062,1.33292),(-.9945,54.55064,1.31995),(-.9795,54.55164,1.33353),(-.94113,54.63527,2.27519),(-.95172,54.63497,2.21612),(-.87024,54.61329,2.19764),(-1.03839,54.64146,1.9343),(-1.01243,54.63594,1.95303),(-.871,54.68363,1.63992),(-.87674,54.65022,1.62241),(-.83721,54.62597,1.91924),(-.85535,54.75686,1.52168),(-1.09805,54.76075,1.51665),(-1.05188,54.74393,1.58489),(-1.1059,54.76611,1.45048),(-1.11732,54.82299,1.47585),(-.92509,54.78427,1.3523),(-.86833,54.75332,1.54066),(-.94185,54.76914,1.46332),(-.95718,54.78305,1.35031),(-1.09935,54.77397,1.4156),(-.88936,54.71841,1.40538),(-.93281,54.72823,1.33272),(-.63712,54.49728,2.37837),(-.72027,54.44503,2.41667),(-.73764,54.37675,2.415),(-.85815,54.41475,2.31625),(-.7249,54.4013,2.27108),(-.78956,54.301,2.23934),(-.60981,54.63866,2.39996),(-.69819,54.68741,2.42456),(-.80626,54.67145,2.52756),(-.77671,54.5674,2.48266),(-.78385,54.62123,2.489),(-.63489,54.57731,2.38719),(-.6986,54.60428,2.30323),(1.59177,54.7138,.93252),(1.67963,55.50967,.51772),(1.61114,56.02916,.34378),(1.86084,56.32207,-.00965),(1.90753,56.25365,.07408),(1.62534,55.77557,.81648),(1.60108,55.79205,.93735),(1.469,56.06161,1.75095),(1.50796,56.04504,1.66837),(1.48424,55.35465,1.3701),(1.48103,55.52673,1.40543),(1.69732,55.47538,.64141),(1.54024,55.1403,1.18022),(1.57981,55.12406,1.09845),(1.53833,54.95561,1.16029),(1.57236,54.92836,1.07253),(1.46839,55.93344,1.74585),(1.58813,56.22141,1.29888),(1.57379,55.81582,1.05719),(1.73659,56.09139,-.00005),(1.77282,56.19402,.25818),(1.92674,56.30555,.29246),(1.70733,56.19866,.19265),(1.73503,56.26897,.16867),(1.94839,56.20081,.18882),(1.62063,55.59293,.66436),(1.47088,56.34853,1.61876),(1.4412,54.86104,1.43167),(.86406,54.3812,2.57355),(.90657,54.2501,1.69874),(.86702,54.18935,1.79327),(.83486,54.32513,1.6873),(1.06054,54.46907,2.18431),(1.1068,54.38687,2.12921),(1.31077,54.49143,1.71633),(1.27559,54.3272,1.80441),(1.06895,54.29547,1.53177),(1.12906,54.19034,1.517),(1.43209,54.87316,1.46511),(1.38423,54.78981,1.59679),(1.41174,54.738,1.49027),(1.41056,54.90885,1.56201),(1.34748,54.64421,1.65115),(.90463,54.05416,1.90768),(.94055,53.93669,1.89599),(.97067,53.81549,1.88098),(.96193,54.75005,2.2864),(.87823,54.71274,1.95829),(.76827,54.79408,1.80245),(.77972,54.73988,1.7633),(1.0952,54.8261,1.59479),(.98091,54.84436,1.61058),(.8799,54.83446,1.38164),(.87265,54.86216,1.39151),(.98616,54.86559,1.38612),(.98634,54.83555,1.37645),(1.10898,54.82912,1.44022),(1.10155,54.8038,1.5648),(.87513,54.82563,1.57),(.86489,54.83144,1.39511),(.85667,54.85857,1.40651),(1.02562,54.83454,1.49426),(.93638,54.83495,1.47754),(1.02602,54.81589,1.49107),(1.12265,54.89927,1.46345),(1.1264,54.87389,1.54542),(.90259,54.40913,2.50053),(.98633,53.99659,2.35307),(.70056,54.7199,2.42876),(.80809,54.69996,2.53106),(.66398,54.66321,2.25605),(.67673,54.72319,2.40923),(.65433,54.7253,2.40416),(.65162,54.70963,2.22021),(.86698,54.87939,1.39325),(.86023,54.40337,1.59454),(.85707,54.53779,1.50168),(.95257,54.44793,2.40805),(.7456,53.80122,2.64968),(.7839,53.94071,2.10053),(.85708,53.9945,2.00157),(.78117,54.08913,2.58755),(.81337,54.0182,2.57583),(.74572,53.99964,2.54104),(.33724,53.53464,2.67376),(.48317,53.59943,2.92046),(.47859,53.70013,2.89505),(.10542,54.28292,3.07861),(.06362,53.73816,2.58969),(.16136,54.64384,3.09578),(.04678,54.61085,3.16899),(.3052,54.6542,3.03327),(.22423,54.60195,3.14114),(.1968,54.636,3.01122),(.30268,54.62121,3.02294),(.47262,54.56031,3.02244),(.20029,54.64572,2.96887),(.3187,54.68299,2.93791),(.67517,54.03078,2.60025),(.46181,54.20007,2.44918),(.51857,54.22412,2.34801),(.49854,53.7071,2.44411),(.52926,54.65243,2.63076),(.49083,54.65295,2.64047),(.59598,54.69087,2.65924),(.65795,54.67789,2.59636),(.69828,54.67318,2.61755),(.64936,54.71585,2.6435),(.47619,54.35,2.5092),(.31528,54.16477,2.61006),(.42402,54.62728,2.84491),(.69949,54.65952,2.82712),(.57532,54.24816,2.24756),(.52663,54.38476,2.41502),(.68647,54.04804,2.5804),(1.21075,54.21025,1.99427),(1.4877,55.36696,1.49021),(1.49289,55.5375,1.53055),(1.5021,55.694,1.57311),(1.42111,54.72177,1.45855),(1.5116,56.17783,1.65381),(1.29283,55.33616,1.271),(1.67349,55.59386,.36815),(1.66815,55.50336,.49081),(1.53383,56.16761,1.51305),(.30886,54.38905,3.09415),(.12686,54.35586,3.10665),(.06422,54.35815,3.0757),(.06998,54.32252,3.02948),(.06944,54.31643,3.05932),(.07613,54.28463,3.01593),(.10437,54.30942,2.89423),(.1429,54.30016,2.98261),(.15202,54.3401,2.99338),(.12323,54.24751,3.04406),(.08183,54.24929,3.02131),(.07608,54.27922,3.04209),(.09435,54.30469,2.91895),(.14132,54.30649,2.94942),(.13651,54.27198,2.94727),(.1382,54.22749,2.99078),(.12398,54.44173,3.13837),(.12482,54.39701,3.12215),(.15757,54.46728,3.0387),(.1577,54.42305,3.02269),(.15597,54.38235,3.00781),(.06097,54.39933,3.09137),(.10456,54.43851,3.14555),(.05458,54.45078,3.07766),(.13262,54.3946,2.90213),(.13801,54.19322,2.99246),(.14491,54.18974,2.97962),(.12566,54.20502,2.93218),(.13636,54.23412,2.96937),(.13445,54.23907,2.9464),(.14117,54.19641,2.99086),(.12269,54.19954,2.9435),(.14638,54.19142,2.96491),(.14586,54.19592,2.94808),(.25773,54.49165,3.11144),(.20311,54.30983,2.99559),(.20602,54.33558,2.8851),(.26554,54.3221,2.89862),(.25527,54.29693,3.01099),(.22137,54.22074,2.90223),(.27647,54.49242,3.09929),(.28145,54.47337,2.9338),(.28572,54.52682,2.95019),(.28033,54.54382,3.11875),(.28589,54.4088,2.95554),(.19265,54.52283,3.01227),(.19744,54.48588,2.91991),(.26713,54.3004,2.98824),(.25666,54.26465,2.96942),(.23329,54.2957,2.8702),(.21194,54.2145,2.95147),(.19389,54.22341,2.93368),(.44288,54.5391,3.04387),(.41083,54.5414,3.06068),(.43173,54.46182,3.02562),(.337,54.41217,2.98884),(.33146,54.36201,2.97789),(.30928,54.31205,2.91924),(.42276,54.28931,2.9013),(.44256,54.34766,2.9155),(.36293,54.35187,2.99906),(.3262,54.24489,2.93301),(.32895,54.30355,2.95556),(.29456,54.26131,2.83353),(.29245,54.32517,2.83349),(.3619,54.24976,2.81582),(.37382,54.30893,2.81695),(.40755,54.22866,2.91316),(.38914,54.16882,2.91145),(.29768,54.19617,2.84542),(.37213,54.18436,2.82802),(.29359,54.13321,2.83824),(.28287,54.05387,2.86047),(.28418,54.05635,2.8639),(.269,54.06947,2.8328),(.26907,54.06562,2.83273),(.28361,54.04574,2.82878),(.26921,54.06386,2.82575),(.06365,54.5658,3.17887),(.1609,54.62457,3.08757),(.12868,54.53824,2.95327),(.12701,54.61638,2.96257),(.15873,54.57947,3.1271),(.08401,54.4924,3.15939),(.05392,54.5138,3.05545),(.14378,54.49917,3.14457),(.28984,54.57908,2.96624),(.28415,54.59579,3.13835),(.19483,54.58339,2.99445),(.30625,54.58196,2.88999),(.31122,54.64918,2.90076),(.58162,54.16389,2.68436),(.58277,54.16425,2.67984),(.55094,54.16674,2.6641),(.57271,54.16581,2.66597),(.57135,54.16382,2.68929),(.56809,54.16625,2.66285),(.56744,54.16403,2.68845),(.55455,54.16694,2.66034),(.55315,54.16554,2.67694),(.66469,54.40675,2.77534),(.57766,54.40762,2.80033),(.58103,54.49131,2.81841),(.53014,54.42512,2.61969),(.52977,54.35987,2.61548),(.59356,54.34287,2.78824),(.55427,54.24601,2.65047),(.55864,54.20238,2.65277),(.56902,54.24475,2.65882),(.54762,54.20311,2.64884),(.6014,54.44132,2.47551),(.60287,54.49791,2.39267),(.61942,54.49764,2.38389),(.62801,54.43808,2.50139),(.69928,54.25044,2.37369),(.70467,54.22267,2.42048),(.6721,54.22521,2.3773),(.69707,54.21713,2.41731),(.70295,54.22146,2.39055),(.69488,54.21596,2.41096),(.69155,54.21575,2.4131),(.69963,54.21919,2.39188),(.68423,54.22293,2.37489),(.67638,54.22265,2.37878),(.67352,54.22539,2.37502),(.67634,54.2197,2.39542),(.69193,54.63019,2.81915),(.49399,54.58742,2.63774),(.53007,54.58692,2.62864),(.52982,54.51018,2.6236),(.65234,54.57595,2.70466),(.64588,54.49977,2.69577),(.66471,54.56494,2.82546),(.65767,54.48932,2.81039),(.69425,54.61832,2.60425),(.57171,54.63186,2.48392),(.78437,54.56093,2.54726),(.6931,54.55907,2.58184),(.58106,54.57164,2.47198),(.7587,54.48105,2.54228),(.65854,54.48309,2.53651),(.59123,54.497,2.40893),(.39974,54.49669,2.82052),(.471,54.42237,2.67528),(.54917,54.41018,2.7825),(.47889,54.35472,2.69505),(.45236,54.5631,2.87118),(.40789,54.57545,2.83185),(.58399,54.56703,2.83392),(.86055,54.2865,1.99162),(.85684,54.28687,1.98798),(.87034,54.29229,1.96963),(.88211,54.28706,2.00009),(.88753,54.29362,1.97228),(.89344,54.29337,1.97648),(.89694,54.29308,1.97965),(.87193,54.51389,2.01781),(.94209,54.42522,2.11899),(.88374,54.49838,2.15143),(.94957,54.50636,2.15448),(.8895,54.41733,2.11914),(.8221,54.43547,1.99553),(.9392,54.49569,2.27894),(.9091,54.39092,1.9938),(.87627,54.42383,2.19978),(.91647,54.37361,2.20437),(.92147,54.4301,2.21702),(.87816,54.36622,2.18792),(.90545,54.33896,1.96634),(.91961,54.36714,2.26399),(.9023,54.31705,1.9614),(.7771,54.30174,2.18845),(.81799,54.30391,2.25101),(.83171,54.26474,2.2238),(.89579,54.29586,1.97363),(.88267,54.28784,2.00463),(.86038,54.24784,2.20161),(.81614,54.35927,2.17833),(.77207,54.41251,2.0896),(.81452,54.4112,2.10795),(.80366,54.41569,2.18859),(.8706,54.24935,2.17023),(.8689,54.24775,2.19585),(.8512,54.24685,2.19944),(.85192,54.24562,2.19503),(.84253,54.24949,2.16468),(.84582,54.24632,2.16749),(1.03323,54.59159,1.92289),(.88532,54.6269,1.93772),(.88983,54.57303,1.9229),(1.006,54.51927,1.91293),(1.04028,54.60544,1.63782),(1.03959,54.66993,1.66117),(.89574,54.60022,1.60447),(.925,54.66138,1.62341),(.87674,54.65022,1.62241),(.8731,54.46641,1.85996),(1.02507,54.52715,1.90054),(.99627,54.60748,1.61511),(.85146,54.4737,1.83566),(.86634,54.44019,1.81257),(1.03397,54.47562,1.81163),(.89679,54.4869,1.66422),(.88527,54.41467,1.79762),(.91352,54.46413,1.65986),(1.02822,54.41858,1.82231),(.91546,54.39697,1.80401),(.90461,54.41188,1.81423),(.93998,54.39874,1.81417),(1.07656,54.46174,1.68334),(1.0131,54.47219,1.59311),(.94705,54.42635,1.75711),(1.02423,54.4533,1.59529),(1.07452,54.44235,1.67423),(1.0257,54.3985,1.81185),(1.00691,54.45081,1.59133),(1.02147,54.43223,1.59554),(1.08173,54.42837,1.63732),(.99405,54.4073,1.62226),(.97116,54.41925,1.62181),(1.04174,54.41712,1.60457),(1.03474,54.43248,1.60013),(1.01059,54.36577,1.77493),(1.01837,54.37793,1.77983),(1.06347,54.40286,1.62937),(1.07762,54.41391,1.63108),(1.02052,54.39984,1.62271),(1.04544,54.40432,1.61512),(.90052,54.55803,1.80309),(1.02765,54.4783,1.80598),(.99217,54.39579,1.7636),(1.01735,54.39684,1.77806),(1.06547,54.42324,1.66827),(.90487,54.48783,1.66978),(.98609,54.41772,1.65357),(1.01195,54.53653,1.3427),(1.00344,54.54636,1.32287),(.99913,54.54862,1.32089),(.98331,54.55396,1.32227),(.98136,54.55333,1.32637),(1.05882,54.61791,1.45185),(1.08028,54.69572,1.49515),(1.04167,54.72053,1.34659),(.9701,54.6106,1.53516),(.91038,54.62374,1.48525),(.94956,54.60694,1.31013),(1.00298,54.60195,1.31236),(1.01822,54.52279,1.38731),(1.00193,54.53654,1.38495),(.99528,54.52637,1.44254),(1.01301,54.51455,1.42333),(.9738,54.55902,1.32484),(.98108,54.56349,1.36485),(.98654,54.56961,1.39014),(.73016,54.623,2.04428),(.78447,54.63013,2.03599),(.87065,54.61333,2.19486),(.77459,54.60259,2.18013),(.87808,54.5509,2.17325),(.95603,54.6354,2.20482),(.94562,54.55966,2.17636),(1.03793,54.72805,1.95307),(1.0864,54.7614,1.79533),(.871,54.68363,1.63992),(.98128,54.68325,1.80988),(1.07586,54.69782,1.71958),(.77986,54.6379,1.82499),(1.09978,54.76384,1.50351),(1.08997,54.79803,1.58179),(.95186,54.74481,1.57175),(.88672,54.78064,1.37851),(.94763,54.83753,1.37111),(.98247,54.74405,1.5804),(.95587,54.68427,1.56043),(.98186,54.6831,1.56877),(.87475,54.69915,1.50965),(1.08069,54.69925,1.48088),(1.0865,54.75872,1.46808),(1.0862,54.76637,1.49544),(.86048,54.76884,1.46282),(.75989,54.56921,2.46074),(.76774,54.4875,2.46518),(.68768,54.44863,2.39511),(.71098,54.53668,2.30048),(.7239,54.46895,2.29895),(.77433,54.47387,2.31747),(.7419,54.4026,2.28434),(.73081,54.40737,2.19786),(.75532,54.41054,2.19194),(.65195,54.69281,2.39997),(.7667,54.62415,2.46737),(.5978,54.57796,2.40165),(.76583,54.54189,2.32127),(.75516,54.60988,2.32469),(.58974,54.639,2.40781),(.79219,54.67491,2.49556),(.67435,54.6907,2.40504),(1.06447,54.70182,1.47117),(.98906,54.60948,1.54343),(.89961,54.78298,1.36436),(1.09343,54.83265,1.41761),(.94003,54.66586,1.95609),(.88203,54.66247,1.94651),(.94101,54.63055,1.94734),(.93623,54.71619,1.9678),(.74217,54.56016,2.02862),(.94289,54.56564,2.28451),(.94235,54.57592,2.06403),(1.05807,54.62087,1.43921),(.97638,54.55991,1.31955),(.96378,54.57042,1.35665),(1.01324,54.38143,1.77396),(1.00479,54.36737,1.76978),(1.02118,54.4529,1.79321),(.99141,54.38086,1.76038),(.99275,54.36903,1.76293),(.98042,54.4506,1.77471),(.93052,54.44515,1.76149),(1.03182,54.41689,1.6013),(1.04034,54.40417,1.61346),(1.06582,54.40147,1.63623),(.97643,54.36161,1.77604),(.99258,54.46998,1.58828),(.88936,54.43488,1.83526),(.88907,54.29626,1.96904),(.83212,54.24354,2.18647),(.86015,54.24656,2.19706),(.87586,54.24962,2.17779),(.83931,54.30631,2.25581),(.84669,54.26649,2.22723),(.92538,54.4246,2.28668),(.47234,54.50437,2.71358),(.46402,54.65145,2.66872),(.38355,54.6393,2.81265),(.47684,54.41972,2.70308),(.34438,54.31626,2.80084),(.55448,54.58546,2.63547),(.55527,54.65086,2.63802),(.67864,54.21798,2.40441),(.67572,54.22251,2.3798),(.68171,54.22316,2.3741),(.69735,54.22004,2.38774),(.70071,54.21756,2.41309),(.6976,54.21641,2.4077),(.67814,54.22548,2.42034),(.59282,54.44877,2.40276),(.29498,54.50835,2.84673),(.19824,54.59278,2.95301),(.20588,54.60818,3.12376),(.29843,54.56866,3.00587),(.19763,54.53994,2.93675),(.19405,54.53061,2.97728),(.2188,54.54525,2.90585),(.14913,54.53334,2.986),(.27734,54.05318,2.82551),(.26865,54.06515,2.82828),(.27632,54.06125,2.85528),(.29393,54.03821,2.85519),(.29751,54.06452,2.87199),(.27863,54.08321,2.8325),(.22392,54.21754,2.91336),(.19858,54.28204,2.95934),(.19619,54.24921,2.94492),(.1942,54.47663,2.95829),(.21647,54.44524,3.08188),(.25371,54.32993,2.87317),(.14104,54.18408,2.96307),(.07645,54.35436,3.09545),(.08334,54.25397,3.00269),(.13749,54.26647,2.97304),(.82175,54.34436,1.69029),(.51653,54.49321,3.03441),(1.65809,55.40723,.62404),(1.39352,55.67006,1.28061),(1.72771,55.59909,.54571),(.73175,53.97923,2.56838),(.7769,54.02039,2.61995),(.17297,53.46416,2.976),(.31576,54.29493,2.69797),(.58165,54.72124,2.53648),(.3091,54.68706,2.90141),(.31004,54.64135,3.08413),(1.06889,53.81199,1.81874),(.76384,53.5605,2.33611),(.93567,54.54235,2.43584),(.91334,54.66215,1.30842),(.88183,54.57902,1.40465),(.85317,54.87664,1.40816),(.76601,54.78669,1.82756),(.65379,54.70992,2.17761),(.66247,54.66568,2.21613),(1.13566,54.08186,2.16221),(1.49,56.41249,1.76625),(1.35425,56.33248,-.01204),(-.77921,54.55113,2.19159),(-.58974,54.639,2.40781),(-1.09978,54.76384,1.50351),(-.91038,54.62374,1.48525),(-.87475,54.69915,1.50965),(-.9701,54.6106,1.53516),(-.95587,54.68427,1.56043),(-.88672,54.78064,1.37851),(-.95186,54.74481,1.57175),(-.85438,54.8003,1.54894),(-.86459,54.71398,1.65689),(-.77305,54.67531,1.82294),(-.97684,54.6682,1.96131),(-.896,54.67774,1.79798),(-.83461,54.63904,1.6377),(-1.08606,54.74458,1.88652),(-.92718,54.5696,2.22673),(-.87211,54.56111,2.20725),(-.98136,54.55333,1.32637),(-1.00308,54.55378,1.31676),(-.99913,54.54862,1.32089),(-1.01195,54.53653,1.3427),(-1.05882,54.61791,1.45185),(-1.08028,54.69572,1.49515),(-1.02305,54.39622,1.78481),(-1.01735,54.39684,1.77806),(-1.02765,54.4783,1.80598),(-1.04554,54.42062,1.66929),(-1.0257,54.40215,1.61537),(-1.05794,54.40409,1.62173),(-1.06659,54.41625,1.61653),(-.96279,54.46517,1.58705),(-1.06241,54.47015,1.61677),(-.98573,54.40523,1.82949),(-1.03808,54.49253,1.85989),(-.89366,54.28925,1.99584),(-.88848,54.28811,1.99845),(-.91647,54.37361,2.20437),(-.87034,54.29229,1.96963),(-.88753,54.29362,1.97228),(-.94166,54.49977,2.23797),(-.8434,54.31483,2.04636),(-.80396,54.26205,2.20773),(-.47169,54.50931,2.65734),(-.48994,54.29345,2.67481),(-.47624,54.42431,2.65094),(-.41567,54.36273,2.83994),(-.57171,54.63186,2.48392),(-.69425,54.61832,2.60425),(-.69828,54.67318,2.61755),(-.53007,54.58692,2.62864),(-.67634,54.2197,2.39542),(-.67638,54.22265,2.37878),(-.68423,54.22293,2.37489),(-.69963,54.21919,2.39188),(-.70295,54.22146,2.39055),(-.69488,54.21596,2.41096),(-.6014,54.44132,2.47551),(-.69155,54.21575,2.4131),(-.55864,54.20238,2.65277),(-.55427,54.24601,2.65047),(-.05629,54.5973,3.04045),(-.19824,54.59278,2.95301),(-.20029,54.64572,2.96887),(-.20588,54.60818,3.12376),(-.29843,54.56866,3.00587),(-.19405,54.53061,2.97728),(-.2188,54.54525,2.90585),(-.19763,54.53994,2.93675),(-.27734,54.05318,2.82551),(-.26865,54.06515,2.82828),(-.27632,54.06125,2.85528),(-.29393,54.03821,2.85519),(-.27863,54.08321,2.8325),(-.29751,54.06452,2.87199),(-.29482,54.19857,2.81656),(-.30577,54.19099,2.88642),(-.39024,54.17439,2.87257),(-.40258,54.23655,2.86388),(-.40324,54.2844,2.97208),(-.25371,54.32993,2.87317),(-.19858,54.28204,2.95934),(-.19619,54.24921,2.94492),(-.1942,54.47663,2.95829),(-.21647,54.44524,3.08188),(-.13262,54.3946,2.90213),(-.12694,54.351,2.8955),(-.10456,54.43851,3.14555),(-.05458,54.45078,3.07766),(-.12482,54.39701,3.12215),(-.12398,54.44173,3.13837),(-.12686,54.35586,3.10665),(-.1577,54.42305,3.02269),(-.15597,54.38235,3.00781),(-.15757,54.46728,3.0387),(-1.53369,56.37464,1.52503),(-1.39352,55.67006,1.28061),(-1.38731,55.66169,1.30094),(-1.33351,55.45159,1.26951),(-1.59465,55.12395,1.04944),(-.67408,54.03172,2.60094),(-.5522,53.83136,2.39002),(-.6234,54.71515,2.57495),(-.23313,53.87778,2.58736),(-.31004,54.64135,3.08413),(-.96986,54.62785,2.35998),(-1.01704,54.41142,1.40511),(-1.12906,54.19034,1.517),(-.94512,54.84224,1.60003),(-.78744,54.75366,2.3677),(-1.08231,54.1285,2.22094),(-1.11624,54.83662,1.55573),(-1.58791,56.32228,1.39156),(-1.58529,56.41542,1.4535),(-1.57435,56.08409,1.1273),(-1.49717,56.45975,1.61598),(-1.59217,55.72133,.7608),(-1.56737,56.17131,-.0973),(-1.444,56.3725,.05597),(-1.61281,55.11568,.94583),(-.67517,54.03078,2.60025),(1.53591,56.10321,1.2939),(1.34744,54.84545,1.73074),(.87424,54.24966,2.17318),(.9009,54.61527,1.80567)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesMandible.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesMandible.py load and self-test diagnostics complete.")
