package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Human bone model for Left Tibia Fibula. </p>
 <p> Related links: Catalog page <a href="../../../Medical/BonesLeftTibiaFibulaIndex.html" target="_blank">BonesLeftTibiaFibula</a>,  source <a href="../../../Medical/BonesLeftTibiaFibula.java">BonesLeftTibiaFibula.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/BonesLeftTibiaFibula.x3d">BonesLeftTibiaFibula.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Damon Hernandez, Joe Williams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Human bone model for Left Tibia Fibula </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Joe Williams, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 5 December 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftTibiaFibula.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftTibiaFibula.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Damon Hernandez, Joe Williams
 */

public class BonesLeftTibiaFibula
{
	/** Default constructor to create this object. */
	public BonesLeftTibiaFibula ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("BonesLeftTibiaFibula.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Damon Hernandez, Joe Williams"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Human bone model for Left Tibia Fibula"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Joe Williams, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("5 December 2013"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftTibiaFibula.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("BonesLeftTibiaFibula.x3d"))
    .addChild(new Transform("DSkeletonParts").setScale(0.029,0.029,0.029)
      .addChild(new Group("rtibfib")
        .addComments(" rtibia rfibia ")
        .addChild(new Shape("ltibia")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("ltibia_Geo").setDEF("ltibia_Geo").setCreaseAngle(1.571).setCoordIndex(getltibia_Geo_6_14_coordIndex())
            .setCoord(new Coordinate("ltibia_Coord").setPoint(getltibia_Coord_7_14_point()))))
        .addChild(new Shape("lfibula")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,0.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfibula_Geo").setDEF("lfibula_Geo").setCreaseAngle(1.571).setCoordIndex(getlfibula_Geo_6_19_coordIndex())
            .setCoord(new Coordinate("lfibula_Coord").setPoint(getlfibula_Coord_7_19_point())))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getltibia_Geo_6_14_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,6,7,4,-1,8,9,7,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,21,22,19,-1,22,23,19,-1,24,25,26,-1,25,27,26,-1,28,29,30,-1,29,31,30,-1,32,33,34,-1,34,29,32,-1,35,36,37,-1,38,39,40,-1,38,41,39,-1,42,43,44,-1,45,46,47,-1,48,49,2,-1,2,50,48,-1,8,51,9,-1,51,52,9,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,69,46,70,-1,46,71,70,-1,72,73,74,-1,73,75,74,-1,76,77,78,-1,78,79,76,-1,80,81,63,-1,63,82,80,-1,83,84,85,-1,85,86,83,-1,86,85,87,-1,87,68,86,-1,88,67,89,-1,89,90,88,-1,91,92,93,-1,94,43,48,-1,94,95,43,-1,96,97,45,-1,45,98,96,-1,99,27,59,-1,99,100,27,-1,101,102,103,-1,102,104,103,-1,105,106,107,-1,106,108,107,-1,109,110,111,-1,110,112,111,-1,113,114,115,-1,114,116,115,-1,117,118,119,-1,120,121,122,-1,122,123,120,-1,124,125,126,-1,126,127,124,-1,128,129,130,-1,128,131,129,-1,132,133,134,-1,132,135,133,-1,136,137,138,-1,136,90,137,-1,139,140,53,-1,140,141,53,-1,53,55,139,-1,142,12,11,-1,142,3,12,-1,143,144,145,-1,145,146,143,-1,147,148,20,-1,20,149,147,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,162,163,164,-1,162,165,163,-1,166,167,168,-1,169,170,171,-1,172,173,174,-1,172,175,173,-1,176,177,159,-1,178,152,151,-1,151,179,178,-1,180,181,182,-1,33,183,34,-1,33,184,183,-1,185,186,187,-1,188,189,190,-1,190,191,188,-1,187,192,193,-1,192,194,193,-1,195,196,197,-1,198,199,200,-1,199,201,200,-1,202,203,204,-1,205,206,207,-1,206,208,207,-1,209,210,211,-1,209,212,210,-1,213,214,215,-1,158,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,224,227,225,-1,228,229,181,-1,230,231,232,-1,233,234,235,-1,233,236,234,-1,237,238,236,-1,236,233,237,-1,239,240,241,-1,241,242,239,-1,243,244,245,-1,244,246,245,-1,247,248,249,-1,247,250,248,-1,251,252,253,-1,251,254,252,-1,255,256,257,-1,255,258,256,-1,259,208,206,-1,259,157,208,-1,260,261,262,-1,260,263,261,-1,262,264,265,-1,262,266,264,-1,267,268,269,-1,268,270,269,-1,271,272,273,-1,271,274,272,-1,152,275,276,-1,152,178,275,-1,277,176,278,-1,277,177,176,-1,279,202,204,-1,204,280,279,-1,258,255,281,-1,282,283,284,-1,285,286,287,-1,287,288,285,-1,289,290,291,-1,291,229,289,-1,292,293,294,-1,295,296,297,-1,295,298,296,-1,299,263,283,-1,300,172,301,-1,302,303,304,-1,303,305,304,-1,306,307,308,-1,309,310,311,-1,309,312,310,-1,313,314,315,-1,316,249,317,-1,317,318,316,-1,175,305,303,-1,303,319,175,-1,320,321,322,-1,323,324,325,-1,323,326,324,-1,327,328,329,-1,329,330,327,-1,331,319,332,-1,331,237,319,-1,333,334,335,-1,334,336,335,-1,337,338,339,-1,337,340,338,-1,338,340,341,-1,341,342,338,-1,35,341,343,-1,341,344,343,-1,198,258,199,-1,345,346,347,-1,346,348,347,-1,203,349,350,-1,351,352,353,-1,354,355,356,-1,356,357,354,-1,358,359,360,-1,37,36,361,-1,223,338,362,-1,338,342,362,-1,221,363,364,-1,221,223,363,-1,365,366,367,-1,367,368,365,-1,369,370,344,-1,371,370,369,-1,371,372,370,-1,373,374,375,-1,376,377,378,-1,376,379,377,-1,327,330,380,-1,381,358,382,-1,381,383,358,-1,177,384,385,-1,384,386,385,-1,387,388,389,-1,387,390,388,-1,391,132,392,-1,391,138,132,-1,393,394,395,-1,394,396,395,-1,397,398,399,-1,397,366,398,-1,288,400,284,-1,400,401,284,-1,262,265,260,-1,350,204,203,-1,350,402,204,-1,205,211,206,-1,205,209,211,-1,403,202,404,-1,207,405,406,-1,406,215,207,-1,407,143,146,-1,146,408,407,-1,138,409,136,-1,138,391,409,-1,279,410,411,-1,279,280,410,-1,412,413,414,-1,413,415,414,-1,144,416,145,-1,417,385,418,-1,385,386,418,-1,419,420,421,-1,420,422,421,-1,423,424,419,-1,424,420,419,-1,425,419,426,-1,419,421,426,-1,427,428,429,-1,429,430,427,-1,125,431,126,-1,125,432,431,-1,433,434,435,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_2()
		{
			int[] value = {433,436,434,-1,437,438,439,-1,437,433,438,-1,52,437,439,-1,52,51,437,-1,50,94,48,-1,23,440,19,-1,440,441,19,-1,442,443,444,-1,445,446,5,-1,446,6,5,-1,93,447,91,-1,448,449,83,-1,83,450,448,-1,451,85,452,-1,85,84,452,-1,453,451,454,-1,451,452,454,-1,58,455,56,-1,58,456,455,-1,136,457,458,-1,136,409,457,-1,458,90,136,-1,458,88,90,-1,63,81,135,-1,81,133,135,-1,459,302,304,-1,459,460,302,-1,301,172,174,-1,174,461,301,-1,462,171,463,-1,171,170,463,-1,464,465,466,-1,466,467,464,-1,468,469,470,-1,468,471,469,-1,472,470,473,-1,472,474,470,-1,475,476,477,-1,475,478,476,-1,479,480,481,-1,479,482,480,-1,483,484,485,-1,483,486,484,-1,174,487,461,-1,174,488,487,-1,489,490,491,-1,489,492,490,-1,274,232,231,-1,231,272,274,-1,493,167,489,-1,276,494,495,-1,495,496,276,-1,497,150,498,-1,150,496,498,-1,150,497,151,-1,499,30,31,-1,500,183,184,-1,291,290,501,-1,501,32,291,-1,270,316,502,-1,316,318,502,-1,270,503,316,-1,270,268,503,-1,271,504,503,-1,503,268,271,-1,231,230,505,-1,505,495,231,-1,506,507,508,-1,507,509,508,-1,510,511,512,-1,511,513,512,-1,514,515,516,-1,514,517,515,-1,180,518,181,-1,518,228,181,-1,510,519,520,-1,521,522,523,-1,522,524,523,-1,322,525,320,-1,322,526,525,-1,527,528,529,-1,422,530,531,-1,122,532,533,-1,106,105,534,-1,105,535,534,-1,536,537,111,-1,537,108,111,-1,110,109,538,-1,109,539,538,-1,428,426,540,-1,426,541,540,-1,133,81,542,-1,543,544,545,-1,543,546,544,-1,25,24,547,-1,547,548,25,-1,549,547,550,-1,549,548,547,-1,551,552,553,-1,551,554,552,-1,555,556,77,-1,556,557,77,-1,140,139,558,-1,559,76,79,-1,559,560,76,-1,75,561,562,-1,562,561,563,-1,563,54,562,-1,550,547,564,-1,564,565,550,-1,566,567,568,-1,566,569,567,-1,296,570,566,-1,296,298,570,-1,571,572,573,-1,573,293,571,-1,395,396,574,-1,396,575,574,-1,538,574,576,-1,538,577,574,-1,578,579,580,-1,578,130,579,-1,581,540,582,-1,540,583,582,-1,126,581,127,-1,581,582,127,-1,580,584,585,-1,585,578,580,-1,130,129,579,-1,147,580,586,-1,587,588,104,-1,587,589,588,-1,569,570,101,-1,569,566,570,-1,103,590,101,-1,590,569,101,-1,591,579,129,-1,591,592,579,-1,593,568,567,-1,567,594,593,-1,564,595,596,-1,595,597,596,-1,564,24,595,-1,564,547,24,-1,598,73,599,-1,598,61,73,-1,600,601,602,-1,602,594,600,-1,603,604,605,-1,605,606,603,-1,607,601,608,-1,601,605,608,-1,559,79,609,-1,79,74,609,-1,557,553,552,-1,27,610,26,-1,611,58,57,-1,611,612,58,-1,543,613,614,-1,614,546,543,-1,615,546,616,-1,615,544,546,-1,617,618,81,-1,618,542,81,-1,105,619,535,-1,619,620,535,-1,621,622,623,-1,122,531,532,-1,122,422,531,-1,530,624,531,-1,624,625,531,-1,626,523,524,-1,527,627,628,-1,527,629,627,-1,630,631,632,-1,630,633,631,-1,634,635,526,-1,636,637,522,-1,638,626,524,-1,638,639,626,-1,640,641,182,-1,641,180,182,-1,512,513,642,-1,642,643,512,-1,510,520,644,-1,644,511,510,-1,269,513,267,-1,269,642,513,-1,194,290,193,-1,194,501,290,-1,29,291,32,-1,29,28,291,-1,184,645,500,-1,184,646,645,-1,168,647,648,-1,647,649,648,-1,504,273,649,-1,504,271,273,-1,647,650,649,-1,650,504,649,-1,460,459,651,-1,651,652,460,-1,249,316,503,-1,503,247,249,-1,226,244,653,-1,653,224,226,-1,654,655,246,-1,654,656,655,-1,657,485,658,-1,657,483,485,-1,319,659,332,-1,319,660,659,-1,480,477,481,-1,480,475,477,-1,468,470,474,-1,474,315,468,-1,236,661,234,-1,661,314,234,-1,238,661,236,-1,238,662,661,-1,303,660,319,-1,460,663,302,-1,663,482,302,-1,460,664,663,-1,460,652,664,-1,665,478,475,-1,665,666,478,-1,667,668,669,-1,667,670,668,-1,88,86,68,-1,68,67,88,-1,450,88,671,-1,88,458,671,-1,672,673,671,-1,672,674,673,-1,71,675,676,-1,677,449,678,-1,449,448,678,-1,679,677,678,-1,679,680,677,-1,95,69,44,-1,44,43,95,-1,679,445,49,-1,49,42,679,-1,98,681,96,-1,98,1,681,-1,97,96,682,-1,682,683,97,-1,18,20,441,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_3()
		{
			int[] value = {20,19,441,-1,0,684,685,-1,0,686,684,-1,436,433,437,-1,437,674,436,-1,435,687,438,-1,438,433,435,-1,688,584,689,-1,688,585,584,-1,690,691,692,-1,690,693,691,-1,126,429,581,-1,126,431,429,-1,427,425,428,-1,425,426,428,-1,522,694,636,-1,522,695,694,-1,420,696,422,-1,696,530,422,-1,414,697,698,-1,699,700,424,-1,701,702,703,-1,701,704,702,-1,254,162,705,-1,254,165,162,-1,706,144,143,-1,706,707,144,-1,708,412,698,-1,412,414,698,-1,413,709,415,-1,709,710,415,-1,411,711,712,-1,411,713,711,-1,714,715,716,-1,716,410,714,-1,405,404,406,-1,405,403,404,-1,209,205,214,-1,206,211,259,-1,211,717,259,-1,261,259,717,-1,261,718,259,-1,719,720,721,-1,719,219,720,-1,345,257,722,-1,257,723,722,-1,400,724,401,-1,400,725,724,-1,366,726,367,-1,366,397,726,-1,394,727,396,-1,727,728,396,-1,729,293,292,-1,729,571,293,-1,730,731,732,-1,730,603,731,-1,392,604,603,-1,603,730,392,-1,620,733,734,-1,620,619,733,-1,264,286,285,-1,264,735,286,-1,641,640,736,-1,736,737,641,-1,287,738,739,-1,400,387,389,-1,389,725,400,-1,239,242,389,-1,389,388,239,-1,740,361,724,-1,724,725,740,-1,741,742,743,-1,741,744,742,-1,352,383,381,-1,381,745,352,-1,746,355,658,-1,355,657,658,-1,747,748,749,-1,750,747,751,-1,750,752,747,-1,278,753,752,-1,331,332,754,-1,754,755,331,-1,327,756,328,-1,372,371,757,-1,374,371,369,-1,374,373,371,-1,344,340,369,-1,344,341,340,-1,324,368,343,-1,324,365,368,-1,339,222,336,-1,336,334,339,-1,364,464,467,-1,467,221,364,-1,223,362,363,-1,362,758,363,-1,362,41,38,-1,362,342,41,-1,38,360,359,-1,38,40,360,-1,740,310,361,-1,310,312,361,-1,240,759,241,-1,758,383,352,-1,352,351,758,-1,357,356,358,-1,358,360,357,-1,354,657,355,-1,354,760,657,-1,257,345,255,-1,345,347,255,-1,256,258,198,-1,198,761,256,-1,40,309,360,-1,762,763,375,-1,464,364,471,-1,364,353,471,-1,363,758,351,-1,374,369,337,-1,369,340,337,-1,327,380,764,-1,764,161,327,-1,381,382,765,-1,765,745,381,-1,765,746,745,-1,746,658,484,-1,658,485,484,-1,243,192,317,-1,192,318,317,-1,189,766,190,-1,767,768,769,-1,465,314,661,-1,323,380,326,-1,718,263,299,-1,718,261,263,-1,770,664,667,-1,770,663,664,-1,643,517,630,-1,690,689,771,-1,690,688,689,-1,116,119,772,-1,118,298,295,-1,118,117,298,-1,272,494,273,-1,494,648,273,-1,266,262,261,-1,157,259,158,-1,402,723,773,-1,774,720,219,-1,219,218,774,-1,249,653,317,-1,249,248,653,-1,323,372,757,-1,757,775,323,-1,276,275,648,-1,648,494,276,-1,269,502,776,-1,269,270,502,-1,777,193,289,-1,193,290,289,-1,216,299,778,-1,216,718,299,-1,718,158,259,-1,718,216,158,-1,721,308,719,-1,721,348,308,-1,507,498,509,-1,507,497,498,-1,168,493,647,-1,168,167,493,-1,244,243,653,-1,243,317,653,-1,779,378,755,-1,378,377,755,-1,331,238,237,-1,331,780,238,-1,376,781,379,-1,376,757,781,-1,235,782,783,-1,235,234,782,-1,648,649,273,-1,232,513,511,-1,227,783,782,-1,227,224,783,-1,370,325,344,-1,218,784,774,-1,307,785,156,-1,282,284,401,-1,211,786,717,-1,211,210,786,-1,202,279,404,-1,185,193,777,-1,185,187,193,-1,194,192,243,-1,501,184,33,-1,179,787,178,-1,788,767,769,-1,769,789,788,-1,161,790,159,-1,161,764,790,-1,314,313,782,-1,782,234,314,-1,321,320,631,-1,656,791,655,-1,173,235,783,-1,783,792,173,-1,652,651,166,-1,756,161,160,-1,756,327,161,-1,155,154,793,-1,742,747,749,-1,742,751,747,-1,477,476,741,-1,741,481,477,-1,21,20,794,-1,20,148,794,-1,584,580,147,-1,147,149,584,-1,586,597,795,-1,146,145,796,-1,796,797,146,-1,83,86,88,-1,88,450,83,-1,798,448,450,-1,450,671,798,-1,446,679,678,-1,446,445,679,-1,551,549,799,-1,799,554,551,-1,800,80,82,-1,82,801,800,-1,616,802,615,-1,616,803,802,-1,598,565,804,-1,804,805,598,-1,123,122,533,-1,533,806,123,-1,570,298,117,-1,117,807,570,-1,116,808,119,-1,116,114,808,-1,106,109,111,-1,111,108,106,-1,619,105,809,-1,105,107,809,-1,552,77,557,-1,683,100,97,-1,683,27,100,-1,97,100,45,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_4()
		{
			int[] value = {808,102,807,-1,66,89,67,-1,802,66,68,-1,68,87,802,-1,617,81,80,-1,80,800,617,-1,78,74,79,-1,78,72,74,-1,83,449,84,-1,449,92,84,-1,70,810,811,-1,87,85,812,-1,813,56,455,-1,56,675,59,-1,675,99,59,-1,71,814,70,-1,71,676,814,-1,7,9,4,-1,50,443,94,-1,50,444,443,-1,815,47,46,-1,31,29,34,-1,32,501,33,-1,24,26,595,-1,441,816,817,-1,441,440,816,-1,818,142,819,-1,142,11,819,-1,816,820,817,-1,536,821,822,-1,821,583,822,-1,2,49,0,-1,49,686,0,-1,446,798,823,-1,823,6,446,-1,437,51,674,-1,51,673,674,-1,8,7,823,-1,7,6,823,-1,672,436,674,-1,142,681,3,-1,681,1,3,-1,685,10,12,-1,685,3,0,-1,685,12,3,-1,8,673,51,-1,8,823,673,-1,5,49,445,-1,49,5,686,-1,824,583,821,-1,824,582,583,-1,819,440,818,-1,440,819,816,-1,682,681,825,-1,682,96,681,-1,758,38,359,-1,758,362,38,-1,1,50,2,-1,444,50,1,-1,95,443,815,-1,95,94,443,-1,813,814,676,-1,813,826,814,-1,71,99,675,-1,71,46,99,-1,612,456,58,-1,612,827,456,-1,828,829,558,-1,828,830,829,-1,447,677,680,-1,677,447,93,-1,76,555,77,-1,555,76,560,-1,65,82,63,-1,82,65,803,-1,826,455,831,-1,455,826,813,-1,812,544,615,-1,812,832,544,-1,833,834,545,-1,833,831,834,-1,536,120,537,-1,822,120,536,-1,808,117,119,-1,807,117,808,-1,806,623,123,-1,621,623,806,-1,804,835,805,-1,835,804,591,-1,599,565,598,-1,599,550,565,-1,57,548,611,-1,25,548,57,-1,77,554,78,-1,554,77,552,-1,618,608,542,-1,608,618,607,-1,803,801,82,-1,801,803,616,-1,558,618,617,-1,618,558,139,-1,811,91,447,-1,91,811,810,-1,446,448,798,-1,446,678,448,-1,836,687,435,-1,837,687,836,-1,838,839,840,-1,693,839,838,-1,691,414,841,-1,691,697,414,-1,797,842,843,-1,797,796,842,-1,844,597,595,-1,844,795,597,-1,845,479,743,-1,845,659,479,-1,749,743,742,-1,743,749,845,-1,783,653,792,-1,653,783,224,-1,488,173,792,-1,488,174,173,-1,651,492,489,-1,492,651,459,-1,305,846,304,-1,305,300,846,-1,847,764,775,-1,847,790,764,-1,848,519,628,-1,520,519,848,-1,788,848,849,-1,848,788,789,-1,31,390,739,-1,850,390,31,-1,191,516,188,-1,514,516,191,-1,633,321,631,-1,633,851,321,-1,212,214,213,-1,214,212,209,-1,261,786,266,-1,261,717,786,-1,169,654,852,-1,654,169,656,-1,222,467,336,-1,222,221,467,-1,781,853,379,-1,781,763,853,-1,775,376,847,-1,757,376,775,-1,331,377,780,-1,755,377,331,-1,779,854,378,-1,779,855,854,-1,753,176,856,-1,278,176,753,-1,857,171,462,-1,645,171,857,-1,645,791,171,-1,647,858,650,-1,647,493,858,-1,859,166,168,-1,859,860,166,-1,384,861,862,-1,384,863,861,-1,668,864,865,-1,668,670,864,-1,153,866,154,-1,153,151,866,-1,497,866,151,-1,866,497,507,-1,769,505,230,-1,769,768,505,-1,508,867,506,-1,867,508,868,-1,869,870,871,-1,869,793,870,-1,872,774,873,-1,872,720,774,-1,258,874,199,-1,258,281,874,-1,722,402,350,-1,722,723,402,-1,347,721,875,-1,348,721,347,-1,308,217,719,-1,308,307,217,-1,876,785,877,-1,878,785,876,-1,778,283,282,-1,778,299,283,-1,286,738,287,-1,736,738,286,-1,182,28,30,-1,181,28,182,-1,187,776,502,-1,776,187,186,-1,853,762,662,-1,763,762,853,-1,655,645,646,-1,645,655,791,-1,879,793,869,-1,879,155,793,-1,307,158,217,-1,156,158,307,-1,708,880,727,-1,708,706,880,-1,60,881,882,-1,62,881,60,-1,119,128,772,-1,128,119,118,-1,431,430,429,-1,430,431,883,-1,692,688,690,-1,692,432,688,-1,17,771,689,-1,771,17,884,-1,112,824,821,-1,112,115,824,-1,482,659,660,-1,479,659,482,-1,663,480,482,-1,663,770,480,-1,885,380,330,-1,326,380,885,-1,747,753,855,-1,747,752,753,-1,380,775,764,-1,775,380,323,-1,661,466,465,-1,661,662,466,-1,191,886,851,-1,191,190,886,-1,468,314,465,-1,468,315,314,-1,163,887,164,-1,887,163,888,-1,856,159,790,-1,159,856,176,-1,339,333,337,-1,334,333,339,-1,352,471,353,-1,471,352,469,-1,35,342,341,-1,35,41,342,-1,15,404,712,-1,15,889,404,-1,198,890,761,-1,198,200,890,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_5()
		{
			int[] value = {888,399,887,-1,888,873,399,-1,555,613,556,-1,613,555,830,-1,522,891,695,-1,522,521,891,-1,760,759,463,-1,760,354,759,-1,240,463,759,-1,240,462,463,-1,310,759,311,-1,241,759,310,-1,311,360,309,-1,311,357,360,-1,36,367,892,-1,368,367,36,-1,339,223,222,-1,339,338,223,-1,375,337,333,-1,374,337,375,-1,885,366,365,-1,885,398,366,-1,763,373,375,-1,763,781,373,-1,398,330,329,-1,398,885,330,-1,779,754,748,-1,755,754,779,-1,278,750,277,-1,278,752,750,-1,861,893,894,-1,861,863,893,-1,895,750,751,-1,893,750,895,-1,845,748,754,-1,845,749,748,-1,744,666,895,-1,666,744,478,-1,746,356,355,-1,765,356,746,-1,469,745,896,-1,469,352,745,-1,476,744,741,-1,476,478,744,-1,892,361,36,-1,361,892,724,-1,725,242,740,-1,242,725,389,-1,388,857,239,-1,857,388,897,-1,739,499,31,-1,738,499,739,-1,287,400,288,-1,400,287,387,-1,735,736,286,-1,735,737,736,-1,898,737,899,-1,898,641,737,-1,264,900,735,-1,266,900,264,-1,901,900,902,-1,901,899,900,-1,903,734,733,-1,903,901,734,-1,904,786,210,-1,904,902,786,-1,904,620,734,-1,905,620,904,-1,905,535,620,-1,906,535,905,-1,534,906,907,-1,534,535,906,-1,197,908,907,-1,908,197,196,-1,909,574,577,-1,574,909,395,-1,910,392,730,-1,910,391,392,-1,730,911,910,-1,730,732,911,-1,911,729,408,-1,911,732,729,-1,292,408,729,-1,408,292,407,-1,294,727,880,-1,727,294,728,-1,909,912,913,-1,909,196,912,-1,914,367,726,-1,914,892,367,-1,401,915,282,-1,401,914,915,-1,220,282,915,-1,778,282,220,-1,915,218,220,-1,915,784,218,-1,873,397,399,-1,774,397,873,-1,714,256,761,-1,256,714,773,-1,916,306,346,-1,877,306,916,-1,307,877,785,-1,307,306,877,-1,876,203,917,-1,349,203,876,-1,918,157,878,-1,918,208,157,-1,202,917,203,-1,403,917,202,-1,919,404,889,-1,919,406,404,-1,920,913,912,-1,913,920,709,-1,394,413,412,-1,394,393,413,-1,843,911,797,-1,910,911,843,-1,715,761,890,-1,715,714,761,-1,410,713,411,-1,410,716,713,-1,13,712,711,-1,15,712,13,-1,920,710,709,-1,920,14,710,-1,706,698,707,-1,708,698,706,-1,756,705,162,-1,756,160,705,-1,704,201,251,-1,200,201,704,-1,921,890,701,-1,715,890,921,-1,699,716,922,-1,713,716,699,-1,385,705,160,-1,705,385,417,-1,702,251,253,-1,704,251,702,-1,701,923,921,-1,701,703,923,-1,922,700,699,-1,922,924,700,-1,423,711,424,-1,13,711,423,-1,14,925,710,-1,14,926,925,-1,841,415,927,-1,414,415,841,-1,707,697,838,-1,698,697,707,-1,144,836,416,-1,144,840,836,-1,694,253,879,-1,702,253,694,-1,695,923,703,-1,695,891,923,-1,696,924,928,-1,700,924,696,-1,427,926,425,-1,925,926,427,-1,927,883,841,-1,927,430,883,-1,418,929,930,-1,418,386,929,-1,869,694,879,-1,694,869,636,-1,521,928,891,-1,624,928,521,-1,585,432,125,-1,585,688,432,-1,693,771,839,-1,771,693,690,-1,839,884,837,-1,839,771,884,-1,17,584,149,-1,584,17,689,-1,687,931,438,-1,687,932,931,-1,52,933,9,-1,52,934,933,-1,4,686,5,-1,686,4,684,-1,935,936,934,-1,936,935,820,-1,820,931,817,-1,935,931,820,-1,818,681,142,-1,825,681,818,-1,794,22,21,-1,794,937,22,-1,683,610,27,-1,683,937,610,-1,595,610,844,-1,595,26,610,-1,25,59,27,-1,57,59,25,-1,680,42,44,-1,680,679,42,-1,69,815,46,-1,815,69,95,-1,673,798,671,-1,798,673,823,-1,814,453,454,-1,826,453,814,-1,451,833,832,-1,451,453,833,-1,796,436,842,-1,796,434,436,-1,671,457,672,-1,458,457,671,-1,90,64,137,-1,90,89,64,-1,667,860,670,-1,667,664,860,-1,894,668,861,-1,669,668,894,-1,666,669,894,-1,665,669,666,-1,475,770,665,-1,770,475,480,-1,782,938,227,-1,938,782,313,-1,225,939,852,-1,225,940,939,-1,465,471,468,-1,465,464,471,-1,938,472,940,-1,938,474,472,-1,941,939,942,-1,170,939,941,-1,942,483,941,-1,942,486,483,-1,743,481,741,-1,479,481,743,-1,896,470,469,-1,470,943,473,-1,896,943,470,-1,233,173,175,-1,233,235,173,-1,490,301,461,-1,490,944,301,-1,858,487,250,-1,491,487,858,-1,654,244,226,-1,654,246,244,-1,248,792,653,-1,792,248,488,-1,504,247,503,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_6()
		{
			int[] value = {247,504,650,-1,493,491,858,-1,493,489,491,-1,272,495,494,-1,495,272,231,-1,864,275,178,-1,864,859,275,-1,787,930,929,-1,930,787,179,-1,897,645,857,-1,500,645,897,-1,245,194,243,-1,194,245,501,-1,502,192,187,-1,502,318,192,-1,766,777,289,-1,189,777,766,-1,793,866,870,-1,154,866,793,-1,867,637,871,-1,638,637,867,-1,788,639,868,-1,849,639,788,-1,641,635,180,-1,641,898,635,-1,190,634,886,-1,190,518,634,-1,643,945,512,-1,643,630,945,-1,639,627,626,-1,639,849,627,-1,638,522,637,-1,638,524,522,-1,526,898,903,-1,635,898,526,-1,886,526,322,-1,886,634,526,-1,630,946,945,-1,630,632,946,-1,528,628,519,-1,628,528,527,-1,523,627,629,-1,523,626,627,-1,946,947,948,-1,946,632,947,-1,629,625,523,-1,629,949,625,-1,733,809,525,-1,809,733,619,-1,947,622,621,-1,947,320,622,-1,948,533,529,-1,948,806,533,-1,949,531,625,-1,949,532,531,-1,809,623,622,-1,107,623,809,-1,123,537,120,-1,123,623,537,-1,421,541,426,-1,541,421,121,-1,539,907,908,-1,907,539,534,-1,616,614,801,-1,614,616,546,-1,950,545,834,-1,950,543,545,-1,834,827,950,-1,456,827,834,-1,829,140,558,-1,829,141,140,-1,78,799,72,-1,799,78,554,-1,55,601,607,-1,55,602,601,-1,604,608,605,-1,134,608,604,-1,601,606,605,-1,600,606,601,-1,594,563,593,-1,594,602,563,-1,60,561,75,-1,882,561,60,-1,794,795,844,-1,795,794,148,-1,804,564,596,-1,564,804,565,-1,882,568,593,-1,882,881,568,-1,594,951,600,-1,594,567,951,-1,606,731,603,-1,606,952,731,-1,572,951,590,-1,572,952,951,-1,805,297,62,-1,835,297,805,-1,592,597,586,-1,596,597,592,-1,586,579,592,-1,586,580,579,-1,835,295,297,-1,835,131,295,-1,103,588,573,-1,104,588,103,-1,588,728,294,-1,589,728,588,-1,575,587,953,-1,589,587,575,-1,570,102,101,-1,102,570,807,-1,587,102,808,-1,104,102,587,-1,125,578,585,-1,578,125,124,-1,954,127,955,-1,124,127,954,-1,114,576,953,-1,576,114,113,-1,538,113,110,-1,538,576,113,-1,581,428,540,-1,581,429,428,-1,808,953,587,-1,114,953,808,-1,124,130,578,-1,954,130,124,-1,953,574,575,-1,574,953,576,-1,589,396,728,-1,589,575,396,-1,294,573,588,-1,294,293,573,-1,590,573,572,-1,103,573,590,-1,148,586,795,-1,586,148,147,-1,596,591,804,-1,592,591,596,-1,566,881,296,-1,566,568,881,-1,951,569,590,-1,569,951,567,-1,952,571,731,-1,572,571,952,-1,952,600,951,-1,606,600,952,-1,805,61,598,-1,805,62,61,-1,593,561,882,-1,593,563,561,-1,54,602,55,-1,602,54,563,-1,609,141,559,-1,141,609,53,-1,599,72,799,-1,599,73,72,-1,559,829,560,-1,559,141,829,-1,801,828,800,-1,801,614,828,-1,551,612,611,-1,612,551,553,-1,557,950,827,-1,556,950,557,-1,556,543,950,-1,556,613,543,-1,583,541,822,-1,583,540,541,-1,908,538,539,-1,908,577,538,-1,534,109,106,-1,109,534,539,-1,822,121,120,-1,822,541,121,-1,422,121,421,-1,422,122,121,-1,107,537,623,-1,107,108,537,-1,529,532,949,-1,529,533,532,-1,621,948,947,-1,806,948,621,-1,809,320,525,-1,809,622,320,-1,523,624,521,-1,624,523,625,-1,949,527,529,-1,629,527,949,-1,948,528,946,-1,948,529,528,-1,947,631,320,-1,632,631,947,-1,525,903,733,-1,526,903,525,-1,946,519,945,-1,519,946,528,-1,628,849,848,-1,849,628,627,-1,945,510,512,-1,510,945,519,-1,633,517,514,-1,517,633,630,-1,635,518,180,-1,518,635,634,-1,766,518,190,-1,518,766,228,-1,868,638,867,-1,639,638,868,-1,871,636,869,-1,637,636,871,-1,507,870,866,-1,507,506,870,-1,768,508,509,-1,768,767,508,-1,513,274,267,-1,232,274,513,-1,515,269,776,-1,642,269,515,-1,776,516,515,-1,516,776,186,-1,289,228,766,-1,228,289,229,-1,501,646,184,-1,501,245,646,-1,850,500,897,-1,183,500,850,-1,179,153,930,-1,179,151,153,-1,929,865,787,-1,929,862,865,-1,787,864,178,-1,787,865,864,-1,496,152,276,-1,150,152,496,-1,505,496,495,-1,498,496,505,-1,648,859,168,-1,275,859,648,-1,492,944,490,-1,846,944,492,-1,491,461,487,-1,491,490,461,-1,488,250,487,-1,488,248,250,-1,175,237,233,-1,175,319,237,-1,473,484,486,-1,473,943,484,-1,659,754,332,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_7()
		{
			int[] value = {754,659,845,-1,760,483,657,-1,760,941,483,-1,472,486,942,-1,472,473,486,-1,463,941,760,-1,463,170,941,-1,940,942,939,-1,940,472,942,-1,315,938,313,-1,938,315,474,-1,170,852,939,-1,852,170,169,-1,227,940,225,-1,227,938,940,-1,665,667,669,-1,665,770,667,-1,664,166,860,-1,664,652,166,-1,137,63,135,-1,137,64,63,-1,843,457,409,-1,843,842,457,-1,842,672,457,-1,436,672,842,-1,85,832,812,-1,451,832,85,-1,453,831,833,-1,453,826,831,-1,676,56,813,-1,676,675,56,-1,454,70,814,-1,810,70,454,-1,452,810,454,-1,91,810,452,-1,84,91,452,-1,92,91,84,-1,937,844,610,-1,794,844,937,-1,682,937,683,-1,682,22,937,-1,825,440,23,-1,825,818,440,-1,932,817,931,-1,16,817,932,-1,816,936,820,-1,816,819,936,-1,10,934,936,-1,933,934,10,-1,684,9,933,-1,4,9,684,-1,439,934,52,-1,439,935,934,-1,935,438,931,-1,438,935,439,-1,18,149,20,-1,17,149,18,-1,16,884,17,-1,16,932,884,-1,837,932,687,-1,932,837,884,-1,530,928,624,-1,530,696,928,-1,418,153,155,-1,153,418,930,-1,692,841,883,-1,691,841,692,-1,430,925,427,-1,927,925,430,-1,423,425,926,-1,423,419,425,-1,700,420,424,-1,700,696,420,-1,923,928,924,-1,923,891,928,-1,703,694,695,-1,703,702,694,-1,155,417,418,-1,252,417,155,-1,416,435,434,-1,416,836,435,-1,707,840,144,-1,840,707,838,-1,710,927,415,-1,710,925,927,-1,926,13,423,-1,14,13,926,-1,924,921,923,-1,922,921,924,-1,705,252,254,-1,705,417,252,-1,713,424,711,-1,713,699,424,-1,715,922,716,-1,715,921,922,-1,200,701,890,-1,704,701,200,-1,145,434,796,-1,145,416,434,-1,920,15,14,-1,920,889,15,-1,398,887,399,-1,398,329,887,-1,714,280,773,-1,280,714,410,-1,910,409,391,-1,910,843,409,-1,408,797,911,-1,408,146,797,-1,412,727,394,-1,727,412,708,-1,709,393,913,-1,393,709,413,-1,889,912,919,-1,912,889,920,-1,406,195,215,-1,919,195,406,-1,403,918,917,-1,405,918,403,-1,878,917,918,-1,876,917,878,-1,220,719,217,-1,220,219,719,-1,281,872,874,-1,875,872,281,-1,774,726,397,-1,774,784,726,-1,914,784,915,-1,914,726,784,-1,217,778,220,-1,217,216,778,-1,284,265,288,-1,265,284,260,-1,724,914,401,-1,724,892,914,-1,196,919,912,-1,919,196,195,-1,913,395,909,-1,393,395,913,-1,880,292,294,-1,880,407,292,-1,731,729,732,-1,731,571,729,-1,392,134,604,-1,134,392,132,-1,577,196,909,-1,577,908,196,-1,907,213,197,-1,907,906,213,-1,212,906,905,-1,906,212,213,-1,905,210,212,-1,905,904,210,-1,734,902,904,-1,734,901,902,-1,266,902,900,-1,902,266,786,-1,898,901,903,-1,901,898,899,-1,899,735,900,-1,899,737,735,-1,390,897,388,-1,390,850,897,-1,177,160,159,-1,385,160,177,-1,862,386,384,-1,862,929,386,-1,356,382,358,-1,382,356,765,-1,894,895,666,-1,894,893,895,-1,277,893,863,-1,277,750,893,-1,780,379,853,-1,379,780,377,-1,781,371,373,-1,781,757,371,-1,365,326,885,-1,326,365,324,-1,762,333,335,-1,333,762,375,-1,35,368,36,-1,343,368,35,-1,354,311,759,-1,354,357,311,-1,363,353,364,-1,351,353,363,-1,614,830,828,-1,614,613,830,-1,208,405,207,-1,208,918,405,-1,279,712,404,-1,712,279,411,-1,722,346,345,-1,722,916,346,-1,875,720,872,-1,875,721,720,-1,309,39,312,-1,40,39,309,-1,312,37,361,-1,312,39,37,-1,378,847,376,-1,854,847,378,-1,238,853,662,-1,238,780,853,-1,329,164,887,-1,329,328,164,-1,344,324,343,-1,325,324,344,-1,746,896,745,-1,746,943,896,-1,746,484,943,-1,322,851,886,-1,851,322,321,-1,517,642,515,-1,642,517,643,-1,855,748,747,-1,748,855,779,-1,346,308,348,-1,306,308,346,-1,790,854,856,-1,854,790,847,-1,301,846,300,-1,846,301,944,-1,660,302,482,-1,660,303,302,-1,751,744,895,-1,751,742,744,-1,116,824,115,-1,824,116,955,-1,112,536,111,-1,536,112,821,-1,432,883,431,-1,883,432,692,-1,131,118,295,-1,131,128,118,-1,296,62,297,-1,296,881,62,-1,407,706,143,-1,880,706,407,-1,28,229,291,-1,28,181,229,-1,165,251,201,-1,254,251,165,-1,232,644,230,-1,644,232,511,-1,466,336,467,-1,466,335,336,-1,271,267,274,-1,271,268,267,-1};
			return value;
		}
		private int[] getltibia_Geo_6_14_coordIndex_8()
		{
			int[] value = {738,640,499,-1,640,738,736,-1,264,288,265,-1,264,285,288,-1,283,260,284,-1,283,263,260,-1,156,878,157,-1,156,785,878,-1,349,877,916,-1,876,877,349,-1,350,916,722,-1,349,916,350,-1,773,257,256,-1,257,773,723,-1,255,875,281,-1,255,347,875,-1,874,873,888,-1,872,873,874,-1,280,402,773,-1,280,204,402,-1,879,252,155,-1,253,252,879,-1,506,871,870,-1,871,506,867,-1,767,868,508,-1,868,767,788,-1,505,509,498,-1,509,505,768,-1,670,859,864,-1,670,860,859,-1,865,861,668,-1,862,861,865,-1,863,177,277,-1,177,863,384,-1,650,250,247,-1,650,858,250,-1,246,646,245,-1,246,655,646,-1,239,462,240,-1,857,462,239,-1,241,740,242,-1,241,310,740,-1,856,855,753,-1,854,855,856,-1,325,372,323,-1,372,325,370,-1,662,335,466,-1,335,662,762,-1,171,656,169,-1,791,656,171,-1,226,852,654,-1,226,225,852,-1,214,207,215,-1,214,205,207,-1,215,197,213,-1,195,197,215,-1,888,199,874,-1,888,163,199,-1,201,163,165,-1,199,163,201,-1,189,185,777,-1,188,185,189,-1,514,851,633,-1,514,191,851,-1,186,188,516,-1,186,185,188,-1,182,499,640,-1,499,182,30,-1,34,850,31,-1,183,850,34,-1,739,387,287,-1,390,387,739,-1,644,848,789,-1,644,520,848,-1,175,300,305,-1,172,300,175,-1,846,459,304,-1,459,846,492,-1,167,651,489,-1,167,166,651,-1,328,162,164,-1,756,162,328,-1,789,230,644,-1,769,230,789,-1,838,691,693,-1,691,838,697,-1,840,837,836,-1,839,837,840,-1,819,10,936,-1,819,11,10,-1,100,46,45,-1,100,99,46,-1,135,138,137,-1,138,135,132,-1,134,542,608,-1,134,133,542,-1,139,607,618,-1,607,139,55,-1,549,611,548,-1,549,551,611,-1,550,799,549,-1,599,799,550,-1,591,131,835,-1,131,591,129,-1,772,130,954,-1,128,130,772,-1,954,116,772,-1,116,954,955,-1,112,113,115,-1,110,113,112,-1,47,443,442,-1,443,47,815,-1,65,89,66,-1,64,89,65,-1,831,456,834,-1,455,456,831,-1,832,545,544,-1,832,833,545,-1,87,615,802,-1,87,812,615,-1,69,811,44,-1,69,70,811,-1,44,447,680,-1,811,447,44,-1,93,449,677,-1,449,93,92,-1,802,65,66,-1,802,803,65,-1,617,828,558,-1,617,800,828,-1,560,830,555,-1,830,560,829,-1,73,60,75,-1,60,73,61,-1,827,553,557,-1,612,553,827,-1,53,562,54,-1,53,609,562,-1,75,609,74,-1,75,562,609,-1,98,444,1,-1,98,442,444,-1,48,42,49,-1,48,43,42,-1,47,98,45,-1,98,47,442,-1,37,41,35,-1,41,37,39,-1,359,383,758,-1,383,359,358,-1,825,22,682,-1,22,825,23,-1,18,817,16,-1,18,441,817,-1,582,955,127,-1,824,955,582,-1,933,685,684,-1,933,10,685,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getltibia_Coord_7_14_point_1()
		{
			double[] value = {1.66334,2.63436,-2.459,1.70418,2.6087,-2.56478,1.6899,2.58667,-2.48132,1.74679,2.78753,-2.4969,1.69656,2.68868,-2.09917,1.6898,2.53869,-2.1644,1.77876,2.6986,-2.01105,1.76745,2.78557,-2.00736,1.80131,2.87186,-1.95008,1.77627,2.96943,-2.00386,1.78209,3.03896,-2.33704,1.80201,3.00224,-2.49709,1.76691,2.89976,-2.43282,2.58153,11.33432,-1.10455,2.57649,10.4456,-1.20009,2.6873,11.32604,-.98244,2.08492,3.81752,-2.50431,2.08401,3.94967,-2.53175,2.10695,3.80159,-2.55952,2.10676,3.55536,-2.67462,2.15874,3.76191,-2.64825,2.15075,3.52364,-2.72617,2.1028,3.3576,-2.70654,2.05568,3.38303,-2.67276,2.33331,3.12858,-3.1269,2.34263,3.0016,-3.00859,2.26254,3.16752,-3.05392,2.16989,3.00101,-2.90572,4.19933,14.8509,-1.40107,4.24117,14.9553,-1.41215,4.21005,14.84837,-1.34484,4.22298,14.97451,-1.20209,4.33571,15.09707,-1.70678,4.342,15.16757,-1.71698,4.27129,15.01884,-1.41833,3.21241,15.59736,-.82442,3.26625,15.58231,-.61083,3.3383,15.59043,-.66677,3.29082,15.62178,-.85478,3.34895,15.60112,-.69331,3.35709,15.6221,-.73623,3.24432,15.60823,-.84537,1.80986,2.41673,-2.33642,1.81495,2.43372,-2.35494,1.85939,2.4307,-2.34666,1.91688,2.71771,-2.69578,2.07071,2.76686,-2.66785,1.90874,2.69612,-2.67574,1.72658,2.47115,-2.32618,1.70989,2.45666,-2.30629,1.71411,2.58261,-2.4868,1.89991,3.07195,-1.87868,1.87428,3.17876,-1.96964,2.9605,2.99398,-2.75621,2.96427,3.05122,-2.76134,3.08971,2.9953,-2.588,2.24618,2.91044,-2.84527,2.33092,2.93685,-2.94265,2.33496,2.92726,-2.91542,2.23659,2.91292,-2.86977,2.91521,3.39097,-3.06258,2.90105,3.39147,-3.08571,2.92423,3.54533,-2.98229,2.87024,2.55907,-2.21927,2.69669,2.65087,-2.10147,2.68603,2.56972,-2.16035,2.44953,2.59864,-2.086,2.37418,2.71013,-2.02391,2.31987,2.70637,-2.06097,2.03774,2.702,-2.50493,2.06123,2.71827,-2.49854,2.08671,2.76823,-2.64431,2.91352,2.84972,-3.44778,2.91163,3.07793,-3.36383,2.93259,2.85986,-3.441,2.92519,3.07145,-3.34831,2.89235,2.70889,-3.26157,2.87421,2.69061,-3.27137,2.93411,2.74717,-3.3634,2.94497,2.76515,-3.34528,3.02826,2.58983,-2.29419,3.04668,2.59907,-2.27937,2.86252,2.55828,-2.24054,2.09038,2.75757,-2.01151,2.09913,2.75929,-2.03408,2.2068,2.82,-2.05226,2.19796,2.81332,-2.02998,2.32713,2.70735,-2.08194,2.26661,2.79625,-1.92168,2.46455,2.68131,-2.02899,2.47635,2.74518,-1.94945,2.03617,2.65021,-2.17238,2.02717,2.66521,-2.0369,1.94087,2.51516,-2.11993,1.79945,2.62291,-2.4528,1.8997,2.6614,-2.4622,1.94955,2.94885,-2.59366,1.98313,2.88137,-2.71875,1.8059,2.68405,-2.63143,2.16059,2.84468,-2.76263};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_2()
		{
			double[] value = {2.05234,2.82509,-2.80038,3.04683,4.36723,-2.56104,3.00039,4.87866,-2.51023,3.07467,4.38148,-2.48179,3.05969,4.86735,-2.43516,3.33958,12.33947,-1.47744,3.21587,11.37463,-1.61766,3.22133,12.36691,-1.66551,3.09099,11.3921,-1.7264,3.08994,10.52722,-1.74994,2.94482,9.22775,-1.91327,2.99056,10.53358,-1.79043,2.8323,9.23596,-1.92084,2.90516,7.95381,-2.04152,2.8937,6.82745,-2.20129,2.79405,7.95188,-2.03868,2.73908,6.82577,-2.22598,2.89583,4.88244,-2.5554,2.79119,4.88622,-2.60061,2.78505,5.85341,-2.41242,2.71292,11.41711,-1.92772,2.59747,11.41416,-1.91025,2.67676,12.43273,-1.916,2.81699,12.41954,-1.90358,2.33843,5.89618,-2.51381,2.17705,5.88517,-2.47188,2.25814,6.8206,-2.31397,2.36783,6.82385,-2.3098,2.6699,4.89316,-2.66675,2.55588,4.40514,-2.84807,2.45906,4.88947,-2.7287,2.70408,4.38987,-2.78247,2.9277,2.79266,-2.06975,3.07599,2.75741,-2.21886,3.05261,2.86288,-2.19371,2.92864,2.72056,-2.10425,2.49526,2.86491,-1.8748,2.70955,2.71684,-2.01524,2.71929,2.79044,-1.98409,3.07637,2.89192,-2.57733,3.05511,2.89627,-2.63079,2.97643,2.90406,-2.75484,1.82009,2.99052,-2.5323,2.43468,4.24258,-1.94798,2.2705,4.22916,-1.948,2.32582,3.71885,-1.87384,2.46905,3.67292,-1.89853,2.22287,3.91729,-2.69884,2.2238,3.72953,-2.7621,2.14096,3.94712,-2.60853,2.0193,15.38407,-2.40456,1.74007,15.28372,-2.15873,2.01031,15.45375,-2.45141,1.66362,15.24544,-1.85672,1.68157,15.17082,-1.85484,1.6784,15.16729,-1.47831,3.34197,14.13632,-.34596,3.35107,14.11056,-.35344,3.37113,14.13109,-.36002,2.08319,15.79727,-.75238,2.06276,15.69648,-.73133,2.12303,15.76205,-.73992,2.10001,15.44884,-.68063,2.31291,15.06841,-.61314,2.1672,15.43412,-.64919,2.21009,15.08451,-.68208,2.56514,15.68237,-2.48489,2.597,15.65978,-2.48067,2.56617,15.66105,-2.50444,4.29765,15.52552,-1.66117,4.21846,15.57152,-1.55789,4.36295,15.51522,-1.46623,2.8564,15.87712,-1.87169,3.06138,15.75391,-1.95137,3.04165,15.73298,-1.95864,2.84976,15.89815,-1.85862,2.08491,15.82621,-.80681,1.74847,15.78996,-1.07557,2.00732,15.48856,-2.47897,1.6998,15.39945,-2.17275,3.93765,14.65641,-1.38307,4.18204,14.82389,-1.40092,4.19289,14.82114,-1.34479,4.34587,15.20413,-1.44381,4.36707,15.28208,-1.71785,3.84091,15.01614,-1.97871,3.8232,15.02881,-1.99597,3.85083,15.05732,-2.00914,3.68562,14.91931,-1.89655,3.87721,14.97996,-1.82016,3.69692,14.73997,-1.68783,3.5606,14.79284,-1.79799,3.88915,15.26761,-2.06929,4.0445,15.12359,-1.95698,4.04796,15.26902,-1.98927,3.09442,11.34696,-1.02951,3.03327,10.48724,-1.18727,3.10839,11.34827,-1.05567,2.4118,14.85909,-.57474,2.34169,15.00369,-.60448};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_3()
		{
			double[] value = {2.33835,14.87221,-.70422,2.25246,15.00983,-.69135,2.7674,13.41687,-.5406,2.78521,13.84742,-.39852,2.66959,13.88385,-.49052,3.26062,13.26954,-.55564,3.32952,13.70466,-.44976,3.24877,13.27613,-.53121,3.31093,13.70009,-.4348,3.25319,13.25484,-.62983,3.32704,13.803,-.58147,3.32101,13.78709,-.52546,3.25102,13.26647,-.66564,3.16291,12.32087,-.84339,3.18879,12.59253,-.75901,3.14815,12.31774,-.81815,3.49458,14.47111,-.37735,3.24891,14.47654,-.32606,2.96372,14.91974,-.37739,2.97077,14.8436,-.35761,3.28091,14.78225,-.38978,3.0539,15.90844,-1.39827,3.04199,15.90117,-1.3939,3.12138,15.76797,-1.28153,3.62311,15.57245,-2.11001,3.8737,15.53333,-2.0617,3.87852,15.51368,-2.07918,3.62234,15.60867,-2.10469,4.10828,14.90041,-1.5661,4.31938,14.97828,-1.68151,2.73366,15.06368,-2.34773,2.6873,15.23121,-2.39553,2.93121,15.01088,-2.33404,2.96572,15.90202,-1.86703,3.13828,15.80026,-1.92815,3.13076,15.79279,-1.93692,2.97476,15.90709,-1.85726,2.83557,15.97391,-1.76429,2.84484,15.97476,-1.7537,4.19488,15.60873,-.98015,4.188,15.61671,-.98507,4.06332,15.62003,-.82429,4.07001,15.61271,-.81574,3.89522,15.45936,-2.08556,3.89501,15.47422,-2.08432,4.22653,15.42801,-1.86857,4.22426,15.44252,-1.86613,3.10545,15.40077,-2.18217,3.30041,15.46085,-2.1155,3.30492,15.44717,-2.1193,3.09918,15.41297,-2.17564,2.11744,15.06311,-.78407,1.80704,15.17999,-1.10698,1.82381,15.12081,-1.15747,2.0905,15.13813,-.75579,2.49472,14.86142,-.48846,2.52212,14.55976,-.44886,2.55429,14.54665,-.38717,2.43795,14.86181,-.54685,3.3829,14.10756,-.36787,3.62041,14.69321,-.44899,3.56195,14.45276,-.49212,3.59909,14.50348,-.51962,3.57977,14.69367,-.42962,3.7762,14.67968,-.51714,3.73921,14.68758,-.49627,3.58462,14.44739,-.56402,3.16177,15.181,-2.20893,3.16127,15.20919,-2.22,3.35375,15.21763,-2.11958,3.35457,15.24477,-2.12411,2.95659,15.10151,-2.36687,2.71393,15.34302,-2.41977,2.72781,15.36715,-2.42239,2.94122,15.05422,-2.35374,2.23765,15.51417,-2.56583,2.2371,15.4872,-2.55045,1.76323,15.80518,-1.08979,2.08905,15.82999,-.84132,2.7307,13.42543,-.57303,2.65053,13.88183,-.52052,2.47161,14.92646,-.50717,3.53718,14.91833,-.40688,3.54884,14.85761,-.41038,3.58686,14.91475,-.41984,3.89721,14.87166,-.52451,4.02671,14.87426,-.65231,4.04688,14.90065,-.648,3.86476,14.89813,-.50553,4.23167,15.09812,-1.8573,4.2355,15.12816,-1.86106,4.33799,15.00261,-1.68173,2.87114,4.26386,-2.15379,2.92552,4.286,-2.19394,2.88398,4.74131,-2.07675,2.82968,4.3789,-2.72779,2.9321,3.74749,-2.79188,2.89601,3.77614,-2.88037,2.90164,4.37471,-2.65163,3.54253,14.70012,-.41027};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_4()
		{
			double[] value = {2.76806,15.84898,-1.87667,2.7946,15.70143,-1.89824,2.64929,15.82174,-1.92489,2.70342,15.89541,-1.85717,2.6724,15.82316,-1.93888,2.75508,15.86956,-1.8658,3.00797,14.4973,-.25261,3.22645,14.4358,-.31428,2.97773,14.69013,-.31592,3.48655,15.62079,-.67542,3.86679,15.64312,-.67432,3.81949,15.65074,-.81154,3.51672,15.59239,-.59901,3.39634,15.71582,-1.95576,3.23371,15.81209,-1.89516,3.41287,15.71406,-1.8656,3.35157,15.33293,-2.12429,3.64809,15.47484,-2.14133,3.64445,15.33067,-2.09758,2.75894,15.96124,-1.78504,3.20536,13.95597,-1.76425,3.25502,14.2034,-1.73823,3.32591,14.17957,-1.67972,2.65749,15.79666,-.96479,2.81106,15.72759,-.73252,2.82604,15.75344,-.93834,2.61425,15.73978,-.78042,2.20512,15.72272,-.72222,2.1715,15.67691,-.67322,2.31184,15.6521,-.59904,2.33103,15.69652,-.67366,2.76255,15.98811,-1.70063,2.71262,15.9738,-1.69509,2.929,15.79517,-1.54062,2.9519,15.80181,-1.53069,3.00562,15.90583,-1.6448,3.0153,15.91754,-1.60427,2.92012,15.79117,-1.40205,3.0553,15.71044,-1.28134,2.95624,15.80771,-1.38797,3.00327,15.71605,-1.25101,3.1105,15.63491,-1.04684,3.15727,15.6492,-1.05252,3.00678,15.64433,-.76999,2.9593,15.69434,-.99964,2.64453,14.54471,-.32379,2.74755,14.54065,-.27602,2.62542,14.86812,-.43785,2.73397,14.84895,-.40745,2.75644,14.26306,-.27517,2.67562,14.25534,-.33838,3.25744,15.77505,-1.3163,3.40484,15.65225,-1.30684,3.26974,15.79933,-1.38977,3.94841,15.60571,-1.1366,3.84997,15.55241,-1.20163,3.72158,15.58281,-1.0778,3.77226,15.62839,-.95796,3.57514,15.60988,-1.06937,3.44166,15.64487,-.96763,3.52787,15.61771,-.89229,3.52732,15.58189,-.56689,3.20776,15.67729,-1.05442,3.21506,15.81045,-1.31899,3.14151,15.93119,-1.44951,2.80394,15.68303,-.60519,2.7743,15.62121,-.51992,3.01902,15.57682,-.55161,3.0141,15.6246,-.63084,2.85551,15.7468,-1.21456,2.83116,15.75912,-.99849,2.71648,15.81218,-1.22901,2.68918,15.80582,-1.10646,2.78261,15.80679,-1.41928,2.86033,15.78593,-1.41242,2.87123,15.80979,-1.56353,2.6731,15.88772,-1.2359,2.68905,15.9454,-1.40633,2.6348,15.90022,-1.2495,2.72918,15.9246,-1.40255,2.49419,15.75446,-.82445,3.55759,15.58566,-1.25718,3.60318,15.58995,-1.23308,3.44949,15.63974,-1.1847,1.54452,15.74752,-1.46548,1.75163,15.70192,-1.05387,1.57235,15.63587,-1.44501,4.11334,15.24738,-.68167,4.21259,15.40899,-.95569,4.11133,15.42373,-.72518,4.20006,15.21327,-.9488,2.72862,2.86329,-1.95347,2.91832,2.87573,-2.05283,2.82548,7.85301,-1.44882,2.76061,6.74201,-1.6776,2.90849,7.87615,-1.57132,2.8383,6.7374,-1.75445,2.77071,15.33414,-.45085,2.56718,15.63641,-.53292,2.56144,15.37653,-.5102};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_5()
		{
			double[] value = {3.96356,15.2594,-.53622,3.54825,15.26321,-.47178,2.6015,14.26854,-.432,2.95282,13.38261,-.4986,2.89554,12.28532,-.6624,3.13442,13.328,-.50184,3.04607,12.28655,-.70674,2.67954,4.26902,-2.0053,2.69308,3.65036,-2.01231,2.49079,2.93926,-1.86179,2.5695,13.86938,-.66601,2.59565,13.45839,-.71369,2.65614,6.72198,-1.65144,2.73685,7.83906,-1.41725,2.45623,6.71751,-1.7527,2.52145,7.85337,-1.57136,2.2401,3.75136,-1.88415,1.75522,15.47934,-1.03489,1.59661,15.48408,-1.4624,2.31533,11.37724,-1.75742,2.31504,12.44116,-1.68333,2.39875,11.39555,-1.87241,2.39694,12.44993,-1.84734,2.37493,11.35984,-1.45134,2.32469,12.42879,-1.40136,2.30836,10.50921,-1.78496,2.32959,10.52739,-1.89022,2.27642,9.1849,-1.88456,2.29763,9.21422,-1.93874,2.25954,7.94474,-2.10733,2.25997,7.89811,-2.0315,2.19047,6.80949,-2.27205,2.12512,5.8473,-2.42828,2.02568,3.42339,-1.886,2.20515,3.53326,-1.82772,2.11816,3.6733,-1.97659,2.13353,3.29081,-1.77649,1.98011,3.27958,-1.85107,2.0215,3.50444,-2.02248,1.95153,3.36524,-1.97837,1.97634,3.39051,-2.64625,2.05296,3.58541,-2.61899,1.80964,2.66583,-2.61977,1.812,2.6662,-2.53638,1.72511,2.6044,-2.55734,1.7116,2.44017,-2.21005,1.79469,2.61386,-2.02073,1.86733,2.40383,-2.23285,1.96475,2.72595,-1.98268,2.01058,2.66483,-2.01714,2.08274,2.78496,-1.91929,2.24619,2.90612,-2.13774,2.149,2.82234,-2.12825,2.26519,3.02352,-2.27815,2.17968,2.8829,-2.26009,2.31872,2.98223,-2.67232,2.39494,2.96194,-2.76941,2.32896,3.03733,-1.8046,2.3147,2.88305,-1.84864,2.66863,15.75589,-2.09371,2.56536,15.75939,-2.0697,2.86906,15.60748,-1.97182,4.3075,15.57277,-1.24144,4.15694,15.60521,-1.26348,3.14364,15.92588,-1.64706,3.22313,15.8512,-1.79236,3.01613,15.90871,-1.65413,3.02694,15.9236,-1.60813,3.41128,15.74356,-1.74541,3.4439,15.65358,-1.48497,3.55516,15.64399,-1.66942,3.3355,15.79674,-1.58372,3.78618,15.59087,-1.78717,3.74647,15.56916,-1.59176,3.61924,15.62952,-1.81927,2.1765,15.67838,-1.86719,2.2575,15.65707,-1.68581,2.28748,15.65604,-1.74752,2.13587,15.65654,-1.74154,2.47947,15.73558,-1.76377,2.28392,15.68199,-1.92336,2.36745,15.68189,-1.7804,2.55022,15.76364,-1.86545,3.93541,15.54672,-1.40613,3.74602,15.5559,-1.41271,3.75881,15.54357,-1.36005,3.86834,15.55465,-1.52568,2.99687,15.51642,-2.10333,3.2116,15.60133,-2.04935,2.73441,15.65431,-2.24589,2.77717,15.60579,-2.02187,2.8657,15.52329,-2.18262,2.69109,15.74411,-2.08653,2.77406,15.56738,-2.42564,2.52825,15.43815,-2.50543,2.51615,15.32987,-2.46734,2.23923,15.38139,-2.4655,2.02842,15.27442,-2.36896,2.21939,15.26123,-2.39967,4.18293,14.86311,-1.1905};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_6()
		{
			double[] value = {4.36169,15.32535,-1.47142,4.2263,15.28066,-1.88125,3.64456,15.20111,-2.05734,3.1654,15.2602,-2.23399,2.979,15.25757,-2.35087,2.47754,15.21952,-2.41888,2.04906,15.07572,-2.34249,2.03317,15.19997,-2.36001,2.22978,15.06268,-2.41252,2.22187,15.18624,-2.4032,2.84604,14.87309,-2.1494,2.90233,14.96067,-2.27069,3.04794,14.88423,-2.0484,3.13272,15.06822,-2.15687,3.53738,14.80513,-1.81345,3.44671,15.0058,-1.93997,3.66411,14.93016,-1.91234,3.34874,14.82442,-1.87208,3.8712,14.67508,-1.51456,2.80761,14.6435,-2.03893,2.7762,14.87117,-2.16644,2.15607,14.28236,-1.88935,2.05724,14.55014,-1.89414,2.30846,14.27796,-1.98563,2.23233,14.5654,-2.05953,3.5578,13.92977,-1.43982,3.61845,14.08029,-1.43654,2.67569,14.23228,-1.99784,2.75547,14.24783,-1.9721,2.7471,13.98661,-1.92,2.30052,13.55189,-1.83844,2.38429,13.56201,-1.90216,2.61216,13.55988,-1.92296,2.72067,13.54187,-1.91187,3.23946,11.36457,-1.49827,3.33713,12.33249,-1.35349,2.81723,10.54794,-1.91013,2.92929,11.42005,-1.88689,3.0104,9.21387,-1.829,3.12515,10.51914,-1.64591,2.38966,9.25436,-1.98825,2.48613,10.55113,-1.92588,3.10455,2.80028,-2.32548,2.68121,2.88934,-2.56921,2.47169,2.82601,-2.26902,2.47945,2.98068,-2.41348,2.66794,2.76372,-2.37922,2.41485,3.09771,-3.21896,2.42433,2.89876,-3.20268,2.59287,2.75491,-3.47048,2.56951,3.0764,-3.34549,2.59824,2.66489,-3.41484,2.77522,2.65132,-3.31869,2.61137,2.67244,-3.29749,2.80713,2.71413,-3.41915,2.89308,2.80275,-3.02835,2.7486,2.82669,-2.90968,2.69636,2.74498,-3.11808,3.01531,2.75347,-2.57802,2.93784,2.88293,-3.06028,2.9093,2.81581,-3.03644,2.94101,3.12101,-3.07454,2.91064,3.03609,-3.05167,2.97706,3.10984,-2.76913,2.42236,3.32843,-3.1338,2.5743,3.31838,-3.18124,2.95006,3.71639,-2.69358,3.06078,3.49233,-2.54504,2.9588,3.53369,-2.69407,3.06306,3.73013,-2.56908,2.94619,4.37492,-2.59374,2.98106,3.65728,-2.2682,3.03251,3.68498,-2.37647,3.00382,4.31548,-2.30609,2.95322,7.92681,-1.83302,2.92137,6.76724,-1.96641,2.97865,7.94641,-1.96311,2.96952,9.20579,-1.72215,2.24423,4.86396,-2.71861,2.41228,4.4031,-2.85089,2.24012,4.39172,-2.76592,2.34324,7.96506,-2.14071,2.43993,7.96031,-2.11857,2.48911,9.2518,-1.99953,2.08162,4.38897,-2.65388,2.07918,4.85048,-2.65932,2.30565,3.88049,-2.80145,3.0004,5.80386,-2.29016,2.96906,4.8158,-2.2235,2.96416,5.79015,-2.10921,3.07152,3.74808,-2.49187,2.61746,3.80517,-3.00782,2.45733,3.84618,-2.95649,2.9442,3.32707,-2.71532,3.07804,3.30369,-2.57067,2.34037,3.34168,-3.10226,2.4458,3.6275,-3.03189,2.36176,3.66414,-2.91812,2.75081,3.36832,-3.16046,2.73317,3.08043,-3.38426};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_7()
		{
			double[] value = {3.13202,3.2918,-2.4816,3.14018,3.09794,-2.47095,3.1136,3.09942,-2.59862,2.99987,3.20329,-2.21614,3.0398,2.96833,-2.1685,3.09328,3.05565,-2.34657,3.08624,3.26335,-2.36861,3.12658,2.97399,-2.46505,3.09473,2.92859,-2.33359,2.90808,2.98106,-3.04808,2.21183,3.21147,-2.93289,2.43446,2.80337,-3.17236,2.47929,2.78632,-3.12443,2.79867,2.84311,-2.66654,2.83015,2.74405,-2.44796,2.45756,2.70099,-2.18607,2.6733,2.66087,-2.27658,3.03454,2.65617,-2.43639,3.12234,2.84876,-2.46403,3.50822,13.39587,-1.27045,3.46749,13.37382,-1.15183,3.02973,13.51431,-1.84363,3.12174,13.51358,-1.80276,2.99625,12.41592,-1.85891,2.21078,14.01764,-1.86008,2.34635,14.01615,-1.9289,2.28465,14.57194,-2.125,2.4941,14.59427,-2.15278,2.6425,14.61824,-2.10988,2.51886,14.22273,-2.00623,3.24227,14.61418,-1.83837,3.23109,14.20833,-1.75696,3.1762,14.21315,-1.79782,3.37144,14.57004,-1.76697,3.73333,14.45043,-1.48089,3.77969,14.42377,-1.39403,1.84741,14.86598,-1.84179,1.91259,14.83289,-2.04037,2.13754,14.81765,-2.18951,2.26932,14.81435,-2.26043,4.15479,14.83004,-1.18981,3.95756,14.6278,-1.18972,3.30694,15.04515,-1.98621,3.26123,14.83357,-1.90915,2.76927,14.99229,-2.28898,4.37213,15.50155,-1.47552,4.32929,15.46616,-1.72359,2.77285,15.56187,-2.4383,2.53918,15.46596,-2.528,2.73924,15.41814,-2.43248,2.95827,15.3861,-2.30696,2.71021,15.66723,-2.25587,2.56904,15.70524,-2.27447,3.64711,15.48472,-2.14291,4.21065,15.50025,-1.84249,4.3242,15.47986,-1.72347,4.31029,15.50806,-1.68223,3.89601,15.54797,-1.2983,3.75662,15.53743,-1.32157,2.60599,15.84647,-1.7264,2.67324,15.88033,-1.81804,3.08783,15.88092,-1.81849,2.9535,15.92102,-1.68489,2.47552,15.74826,-2.0653,2.39122,15.71878,-2.29064,2.05877,15.69251,-1.95153,1.98196,15.69242,-1.78473,2.14413,15.70522,-2.22782,1.69938,15.72917,-2.22321,1.85978,15.74375,-2.07695,2.0162,15.71476,-2.51774,2.0963,2.93173,-1.83492,2.11107,3.12957,-1.78388,1.99372,3.00236,-1.85096,2.0733,3.17439,-1.80285,2.17593,2.85033,-2.74019,2.19557,2.89195,-2.59346,1.92064,2.50849,-2.10542,1.86836,2.55312,-2.05947,1.80865,2.3761,-2.22022,1.83977,2.38206,-2.22802,1.91029,2.97462,-2.55541,2.05387,3.19943,-2.67288,2.09952,3.12021,-2.76844,1.68523,2.69748,-2.24256,1.72205,2.81167,-2.39457,1.68088,2.54949,-2.28621,2.0611,3.74657,-2.06879,2.01602,4.83172,-2.60066,2.02595,4.37344,-2.57954,2.01554,4.80411,-2.46945,2.22251,5.77361,-2.09622,2.13614,5.80479,-2.32785,2.05673,4.76458,-2.22555,1.84093,14.87462,-1.54179,1.99852,14.58543,-1.6188,2.24769,13.53497,-1.66602,2.32591,5.7617,-1.98497,2.43925,5.74863,-1.86285,2.32044,13.50544,-1.14694};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_8()
		{
			double[] value = {2.25332,13.53306,-1.32481,2.22315,14.69947,-.91131,1.93784,14.91612,-1.21115,2.04974,14.71561,-1.25038,2.18551,14.8863,-.85504,2.03281,15.46355,-.71208,2.4826,4.73797,-1.93718,2.31439,4.74266,-1.99007,2.59652,5.74027,-1.813,2.7285,9.08819,-1.18729,2.52264,9.10547,-1.38781,2.5914,12.34922,-.92831,2.71911,12.32257,-.81733,2.51799,13.47812,-.82005,2.51042,14.25653,-.61714,2.4512,14.2294,-.7827,2.47981,13.88563,-.80145,3.4105,14.13638,-.48137,3.535,14.4614,-.41447,2.98011,14.76042,-.3354,2.74346,14.9818,-.40537,2.74103,14.9122,-.40768,2.66604,14.29639,-.33313,2.59942,14.28356,-.43005,3.52945,15.52395,-.52194,3.93867,15.46725,-.61311,2.96979,15.3051,-.4535,2.74804,5.75888,-1.84803,2.86589,5.75046,-1.91307,2.87892,3.63107,-2.15412,2.90225,3.12482,-2.08447,3.00851,3.40278,-2.23344,2.89592,3.36926,-2.12703,3.56771,13.90665,-1.20921,3.57819,13.91785,-1.0648,3.88284,14.66631,-.68903,4.08857,14.81425,-.95108,3.96267,14.62246,-.99896,4.10755,14.83935,-.94486,4.12633,14.91744,-.94584,3.87204,15.63584,-.66481,2.28658,15.64805,-1.60782,2.3096,15.69012,-1.40356,2.4031,15.7153,-1.5357,2.14021,15.63834,-1.60391,3.53846,15.60157,-1.32126,3.7176,15.55826,-1.27114,2.35997,15.81757,-1.11895,2.51117,15.86023,-1.2805,2.45822,15.81565,-1.31279,1.93837,15.7843,-1.20276,2.13653,15.733,-1.30203,2.19384,15.82592,-.96059,2.30181,15.86371,-.87669,2.63375,15.94825,-1.4309,2.67567,15.94877,-1.41051,2.11863,15.68694,-.70026,2.68467,15.87975,-1.23256,3.31043,15.68618,-1.08222,4.0499,15.62863,-1.07363,4.04216,15.57772,-1.28094,2.45543,14.61368,-.58727,2.94695,15.91646,-1.67386,2.83639,15.9343,-1.61888,2.36845,15.83233,-.82286,3.67935,15.57067,-1.23154,4.00931,14.99164,-1.74899,2.47539,15.07064,-2.43479,2.46774,15.16381,-2.42396,2.60508,15.06117,-2.39082,2.23623,15.68709,-2.04828,1.99247,4.32671,-2.41327,2.68943,5.87044,-2.45179,2.57863,14.27142,-.47476,2.7481,15.0459,-.40484,2.57363,15.86651,-.97731,3.63878,15.17342,-2.04735,4.04015,15.08512,-1.94411,3.50501,14.71124,-.40289,2.62155,15.89997,-1.25498,2.77502,15.98626,-1.69266,2.73861,15.91442,-1.39958,3.36451,15.7058,-2.04031,3.34254,15.69113,-2.0476,2.96723,15.03305,-.40077,3.22864,14.20504,-.28527,3.42251,14.12915,-.55084,1.67906,15.57137,-2.19872,2.47605,14.9838,-2.39351,2.62339,14.99626,-2.33555,2.35629,15.85469,-.83929,4.36833,15.50825,-1.47875,3.24196,15.62217,-2.04895,1.69217,15.13014,-1.85176,2.18422,3.47837,-2.82894,2.31041,3.68557,-2.85153,2.33716,3.48045,-1.83117,2.48781,3.4265,-1.8841,1.91431,2.77957,-1.94903,2.80065,2.7897,-3.49179};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_9()
		{
			double[] value = {3.01508,2.64868,-2.43868,2.84412,2.64585,-2.34117,2.45113,2.59712,-2.10501,2.68291,2.56786,-2.17986,2.60055,3.57288,-3.09651,2.75733,3.55619,-3.04608,2.88923,13.51252,-1.86359,2.95362,4.88035,-2.53043,2.95253,5.82597,-2.36117,3.4366,13.43998,-1.48456,2.03137,2.65395,-2.28124,1.88526,2.44906,-2.33731,2.33156,2.75828,-2.11284,2.26388,2.97812,-2.65082,2.20198,2.924,-2.45693,1.91246,2.70787,-2.54352,1.94732,3.4055,-2.60444,2.02792,3.59898,-2.55994,1.91709,3.2556,-2.59695,1.87926,3.27475,-2.55333,1.93989,3.4376,-2.50509,2.68218,9.25651,-2.00668,2.61179,10.55033,-1.93207,1.8559,2.82487,-1.94573,2.61158,7.95721,-2.11361,1.99179,3.24191,-2.62798,2.26234,3.03163,-2.47111,2.54492,2.83019,-2.97546,2.99745,2.74311,-2.57315,2.94707,2.85442,-2.75556,2.93009,2.84144,-2.75006,2.35643,3.01588,-2.54079,2.36087,2.86847,-2.20173,2.37515,3.00475,-2.34378,2.4453,2.99569,-2.61384,2.7546,3.78689,-2.94521,2.13152,3.82638,-2.01177,2.06145,3.8715,-2.09618,2.19707,4.75264,-2.09735,2.03122,4.28092,-2.17639,2.15361,4.25293,-2.05977,2.30271,6.75059,-1.93578,2.34355,3.21186,-1.79634,2.49653,3.14952,-1.85945,2.23451,3.38988,-2.92504,2.53269,15.84037,-1.47444,2.68958,15.80985,-1.94586,2.54645,15.88364,-.98235,2.64263,14.85286,-2.20766,2.47224,14.83018,-2.27315,4.29744,15.17713,-1.22273,3.39623,14.56197,-1.75142,4.19651,15.51858,-1.8278,2.83009,15.94429,-1.62692,2.51696,15.89427,-.98926,2.50549,15.89452,-.99868,2.31543,15.86453,-.85784,4.31376,15.56382,-1.23732,2.95393,15.3982,-2.30039,2.25671,15.67753,-2.57575,2.2584,15.69651,-2.55845,1.5678,15.73282,-1.88816,1.55424,15.7145,-1.8904,1.55816,15.7632,-1.47219,2.00772,15.69767,-2.53192,1.68514,15.71051,-2.23135,1.75902,15.21114,-2.15207,2.07412,14.9812,-2.30174,2.2406,14.97046,-2.37431,1.75097,15.02927,-1.8459,1.78036,15.10241,-2.13941,1.8255,14.99448,-2.10636,2.58173,15.00503,-.45804,2.56376,15.07081,-.46654,2.44528,14.99591,-.52689,2.60706,14.93356,-.44779,3.00966,14.22346,-.25582,3.01618,14.28542,-.24291,3.21626,14.15281,-.29354,1.7147,15.09854,-1.4909,2.68919,4.74095,-1.96586,2.93222,3.54151,-2.8322,2.93248,3.36241,-2.89498,2.19448,6.78851,-2.19233,2.05063,3.93071,-2.3261,2.57422,15.68187,-.6113,3.54567,14.51584,-1.64573,2.30154,15.40471,-.58631,2.40692,15.08679,-.54937,2.84287,11.30597,-.83479,2.39099,14.63888,-.73909,2.07639,14.28932,-1.64459,3.28872,15.54955,-.55234,1.76839,15.74814,-1.51423,1.77245,15.74316,-1.83349,1.9545,15.69224,-1.57344,3.60356,15.58717,-1.3974,4.31023,15.36482,-1.24056,3.78833,14.41399,-1.18217,3.79079,14.40502,-1.02249};
			return value;
		}
		private double[] getltibia_Coord_7_14_point_10()
		{
			double[] value = {3.69688,14.42136,-.7593,3.63795,14.07649,-1.05116,3.51004,14.06403,-.80111,3.6272,14.06527,-1.19526,3.4359,13.86324,-.83349,3.33575,13.32976,-.88636,3.25583,12.32213,-1.12924,3.18956,11.35617,-1.35712,3.08266,10.49298,-1.54171,2.95848,9.16178,-1.3799,2.71324,3.09102,-1.97273,2.72043,3.37505,-1.99534,2.91258,10.4727,-1.03521,2.86426,9.11481,-1.2533,3.28778,15.28786,-.46851,3.26829,14.95656,-.40698,2.7509,14.30907,-.26339,2.95809,13.78484,-.37934,3.18208,13.70966,-.3958,2.95423,11.33394,-.86792,2.75479,10.44252,-.97624,2.27872,14.26613,-1.00801,2.29915,13.92817,-1.07214,2.14233,14.30347,-1.29267,2.20325,13.93434,-1.31043,2.39105,9.13834,-1.61464,2.38435,10.46528,-1.51626,2.36857,7.88902,-1.77571,2.15093,13.98956,-1.67081,1.56915,15.6075,-1.87664,1.60322,15.43392,-1.85222,2.03291,3.5822,-2.2489,2.06003,3.80363,-2.29499,1.78078,3.03762,-2.1545,1.86677,3.28656,-2.18737,1.9411,3.43715,-2.21159,1.86924,3.31031,-2.40349,2.145,3.31281,-2.81426,3.60927,15.62368,-2.00768,4.11595,15.55325,-1.76084,3.83484,15.57618,-1.94388,4.09886,15.57058,-1.49431,3.98405,15.56254,-1.67991,3.68616,15.56618,-1.43775,2.73778,15.69116,-1.94554,3.01192,14.65003,-1.94451,2.98247,14.23278,-1.86454,3.14572,13.96689,-1.80095,2.95208,13.95639,-1.8445,2.55124,14.00154,-1.95829,2.61945,2.89456,-2.78627,3.10337,3.48403,-2.47228,3.06988,3.44473,-2.35652,2.96242,6.8167,-2.11914,2.53339,5.8982,-2.516,2.56081,6.83176,-2.31506};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfibula_Geo_6_19_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,6,7,4,-1,8,9,10,-1,11,12,13,-1,12,14,13,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,26,27,28,-1,27,29,28,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,38,39,36,-1,40,36,21,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,19,39,-1,19,36,39,-1,51,52,53,-1,51,54,52,-1,55,56,57,-1,56,58,57,-1,59,60,61,-1,59,62,60,-1,63,64,65,-1,66,67,68,-1,63,69,70,-1,71,60,66,-1,66,68,71,-1,72,73,74,-1,74,75,72,-1,76,77,78,-1,77,79,78,-1,80,61,81,-1,61,82,81,-1,83,84,85,-1,85,86,83,-1,87,88,89,-1,90,86,91,-1,90,88,86,-1,92,93,94,-1,94,95,92,-1,96,97,98,-1,88,99,83,-1,88,87,99,-1,100,101,102,-1,101,103,102,-1,104,99,105,-1,105,106,104,-1,107,108,109,-1,110,111,112,-1,112,113,110,-1,114,95,94,-1,114,115,95,-1,11,15,116,-1,15,98,116,-1,117,12,118,-1,12,119,118,-1,110,60,62,-1,110,66,60,-1,120,121,122,-1,120,109,121,-1,123,124,125,-1,126,127,128,-1,127,129,128,-1,130,131,132,-1,130,133,131,-1,134,135,136,-1,135,137,136,-1,138,139,140,-1,138,141,139,-1,142,143,144,-1,142,145,143,-1,146,147,123,-1,148,149,150,-1,149,151,150,-1,152,153,154,-1,152,155,153,-1,156,157,158,-1,140,158,159,-1,159,138,140,-1,130,149,160,-1,130,132,149,-1,161,162,163,-1,164,165,166,-1,166,167,164,-1,110,67,66,-1,110,113,67,-1,23,168,169,-1,23,170,168,-1,91,171,90,-1,91,172,171,-1,173,57,174,-1,57,175,174,-1,176,177,172,-1,172,91,176,-1,178,177,120,-1,177,176,120,-1,179,180,2,-1,2,178,179,-1,181,180,182,-1,180,179,182,-1,59,70,183,-1,70,69,183,-1,1,3,184,-1,185,186,187,-1,186,184,187,-1,165,164,188,-1,164,189,188,-1,190,191,192,-1,190,193,191,-1,194,195,196,-1,196,197,194,-1,198,199,200,-1,200,201,198,-1,202,203,204,-1,205,203,206,-1,205,161,203,-1,207,208,209,-1,207,210,208,-1,158,211,212,-1,212,159,158,-1,136,142,134,-1,142,213,134,-1,214,215,216,-1,216,146,214,-1,217,218,219,-1,220,217,221,-1,220,222,217,-1,104,111,84,-1,104,112,111,-1,102,103,89,-1,103,223,89,-1,224,225,100,-1,225,101,100,-1,226,93,227,-1,227,228,226,-1,227,223,228,-1,223,103,228,-1,105,229,230,-1,105,231,229,-1,232,98,233,-1,232,116,98,-1,234,235,236,-1,7,237,4,-1,238,239,240,-1,240,7,238,-1,241,242,238,-1,242,243,238,-1,244,5,245,-1,245,246,244,-1,247,248,24,-1,247,249,248,-1,44,46,250,-1,250,251,44,-1,49,252,253,-1,49,48,252,-1,254,32,31,-1,254,240,32,-1,48,255,252,-1,238,256,239,-1,238,243,256,-1,257,258,259,-1,257,260,258,-1,226,261,262,-1,226,234,261,-1,263,114,264,-1,263,265,114,-1,263,264,266,-1,266,267,263,-1,268,269,270,-1,268,25,269,-1,41,24,169,-1,24,23,169,-1,271,250,43,-1,250,247,43,-1,272,251,271,-1,251,250,271,-1,273,274,242,-1,274,243,242,-1,275,274,276,-1,33,277,278,-1,33,38,277,-1,279,280,258,-1,279,40,280,-1,281,259,258,-1,258,280,281,-1,253,282,49,-1,283,284,285,-1,34,283,285,-1,285,286,34,-1,34,33,278,-1,278,168,34,-1,34,286,35,-1,285,287,288,-1,285,284,287,-1,288,22,50,-1,22,19,50,-1,22,289,20,-1,290,291,292,-1,291,287,292,-1,289,281,280,-1,280,20,289,-1,293,279,260,-1,279,258,260,-1,37,277,38,-1,37,294,277,-1,242,251,272,-1,272,273,242,-1,271,43,42,-1,48,27,255,-1,48,295,27,-1,270,269,263,-1,263,267,270,-1,265,248,296,-1,248,249,296,-1,260,297,239,-1,239,256,260,-1,253,281,282,-1,253,259,281,-1,30,252,31,-1,30,253,252,-1,298,244,246,-1,298,299,244,-1,300,232,301,-1,232,302,301,-1,254,303,237,-1,303,117,237,-1,118,237,117,-1,118,4,237,-1,7,241,238,-1,7,6,241,-1,301,304,305,-1,301,302,304,-1,283,268,284,-1,283,170,268,-1,226,228,234,-1,228,235,234,-1,10,17,16,-1,16,306,10,-1,231,223,227,-1,227,229,231,-1,106,112,104,-1,106,97,112,-1};
			return value;
		}
		private int[] getlfibula_Geo_6_19_coordIndex_2()
		{
			int[] value = {171,102,90,-1,147,307,123,-1,307,124,123,-1,212,308,159,-1,308,309,159,-1,204,310,202,-1,204,311,310,-1,194,151,312,-1,194,150,151,-1,195,194,312,-1,312,189,195,-1,184,196,187,-1,184,3,196,-1,313,64,75,-1,313,65,64,-1,74,73,186,-1,73,314,186,-1,2,180,0,-1,81,82,72,-1,82,76,72,-1,176,91,107,-1,91,86,107,-1,82,71,76,-1,71,77,76,-1,88,83,86,-1,98,97,106,-1,106,233,98,-1,103,235,228,-1,103,101,235,-1,162,315,163,-1,315,316,163,-1,317,164,167,-1,318,147,146,-1,146,216,318,-1,309,138,159,-1,309,319,138,-1,153,155,320,-1,321,139,141,-1,0,181,197,-1,0,180,181,-1,160,149,148,-1,322,207,154,-1,154,323,322,-1,137,147,318,-1,318,136,137,-1,157,156,153,-1,153,320,157,-1,143,145,324,-1,210,207,322,-1,325,125,124,-1,124,315,325,-1,326,129,127,-1,127,327,326,-1,222,220,215,-1,215,214,222,-1,327,328,326,-1,328,329,326,-1,319,132,131,-1,188,215,220,-1,133,141,131,-1,176,109,120,-1,176,107,109,-1,12,11,119,-1,11,116,119,-1,15,18,98,-1,18,96,98,-1,62,330,111,-1,111,110,62,-1,79,56,55,-1,79,52,56,-1,83,99,84,-1,99,104,84,-1,231,105,99,-1,99,87,231,-1,96,67,97,-1,67,113,97,-1,46,299,296,-1,296,249,46,-1,305,95,115,-1,115,298,305,-1,105,230,233,-1,233,106,105,-1,300,118,119,-1,300,245,118,-1,92,227,93,-1,112,97,113,-1,89,88,102,-1,88,90,102,-1,77,53,79,-1,53,52,79,-1,72,76,73,-1,76,78,73,-1,190,192,74,-1,71,82,60,-1,82,61,60,-1,313,331,65,-1,330,85,84,-1,84,111,330,-1,183,69,108,-1,69,109,108,-1,80,63,70,-1,332,55,173,-1,55,57,173,-1,56,224,58,-1,56,9,224,-1,252,333,31,-1,252,255,333,-1,292,295,290,-1,273,276,274,-1,169,42,41,-1,297,260,257,-1,334,26,236,-1,26,28,236,-1,19,21,36,-1,51,18,54,-1,18,17,54,-1,15,11,16,-1,11,13,16,-1,118,5,4,-1,118,245,5,-1,56,54,9,-1,56,52,54,-1,236,335,334,-1,335,236,235,-1,276,272,336,-1,272,276,273,-1,289,291,337,-1,289,22,291,-1,338,339,340,-1,338,306,339,-1,333,341,342,-1,255,341,333,-1,59,80,70,-1,61,80,59,-1,183,85,330,-1,183,108,85,-1,302,233,230,-1,302,232,233,-1,116,300,119,-1,116,232,300,-1,296,298,115,-1,299,298,296,-1,247,46,249,-1,250,46,247,-1,59,330,62,-1,59,183,330,-1,321,133,343,-1,141,133,321,-1,208,328,344,-1,208,329,328,-1,310,152,209,-1,152,310,311,-1,214,325,222,-1,325,214,125,-1,128,160,126,-1,128,345,160,-1,155,311,316,-1,152,311,155,-1,346,158,157,-1,346,211,158,-1,346,135,211,-1,346,347,135,-1,211,134,212,-1,211,135,134,-1,140,322,323,-1,322,140,139,-1,348,320,307,-1,157,320,348,-1,145,136,318,-1,136,145,142,-1,156,154,153,-1,323,154,156,-1,73,332,314,-1,332,73,78,-1,323,158,140,-1,158,323,156,-1,193,185,349,-1,185,193,190,-1,321,350,210,-1,321,343,350,-1,343,345,128,-1,343,133,345,-1,179,351,182,-1,122,351,179,-1,121,65,352,-1,63,65,121,-1,127,353,354,-1,127,126,353,-1,197,150,194,-1,150,197,181,-1,139,210,322,-1,321,210,139,-1,155,307,320,-1,124,307,155,-1,57,355,175,-1,355,57,58,-1,77,68,53,-1,71,68,77,-1,1,174,2,-1,174,1,173,-1,108,86,85,-1,107,86,108,-1,81,75,64,-1,81,72,75,-1,186,190,74,-1,186,185,190,-1,196,0,197,-1,196,3,0,-1,148,126,160,-1,126,148,353,-1,313,191,331,-1,191,313,192,-1,327,354,331,-1,327,127,354,-1,356,328,327,-1,328,356,357,-1,193,356,191,-1,356,193,198,-1,201,358,357,-1,206,358,201,-1,219,162,161,-1,219,218,162,-1,317,199,349,-1,167,199,317,-1,166,205,200,-1,359,205,166,-1,189,324,188,-1,189,312,324,-1,188,216,215,-1,324,216,188,-1,312,143,324,-1,151,143,312,-1,144,309,142,-1,144,319,309,-1,204,316,311,-1,316,204,163,-1,102,355,100,-1,355,102,171,-1,18,67,96,-1,67,18,51,-1,225,338,335,-1,225,8,338,-1,302,229,304,-1,302,230,229,-1,339,14,342,-1,13,14,339,-1,26,255,27,-1,26,341,255,-1,236,261,234,-1,261,236,28,-1};
			return value;
		}
		private int[] getlfibula_Geo_6_19_coordIndex_3()
		{
			int[] value = {341,334,340,-1,341,26,334,-1,240,237,7,-1,254,237,240,-1,244,46,45,-1,244,299,46,-1,257,253,30,-1,257,259,253,-1,265,115,114,-1,265,296,115,-1,264,261,266,-1,264,262,261,-1,270,360,361,-1,267,360,270,-1,27,360,29,-1,27,295,360,-1,295,47,290,-1,47,295,48,-1,292,284,361,-1,284,292,287,-1,278,169,168,-1,278,42,169,-1,279,294,37,-1,294,279,293,-1,260,275,293,-1,256,275,260,-1,290,337,291,-1,290,47,337,-1,285,50,286,-1,50,285,288,-1,22,287,291,-1,288,287,22,-1,280,21,20,-1,40,21,280,-1,293,276,294,-1,293,275,276,-1,42,277,336,-1,278,277,42,-1,42,272,271,-1,42,336,272,-1,274,256,243,-1,274,275,256,-1,294,336,277,-1,276,336,294,-1,24,269,25,-1,24,248,269,-1,268,361,284,-1,268,270,361,-1,295,361,360,-1,292,361,295,-1,267,29,360,-1,29,267,266,-1,248,263,269,-1,263,248,265,-1,262,114,94,-1,262,264,114,-1,94,226,262,-1,226,94,93,-1,300,246,245,-1,301,246,300,-1,239,32,240,-1,239,297,32,-1,333,254,31,-1,333,303,254,-1,241,251,242,-1,251,241,44,-1,43,24,41,-1,43,247,24,-1,5,45,6,-1,45,5,244,-1,303,342,14,-1,303,333,342,-1,335,340,334,-1,335,338,340,-1,266,28,29,-1,28,266,261,-1,306,13,339,-1,16,13,306,-1,225,235,101,-1,335,235,225,-1,227,304,229,-1,227,92,304,-1,9,225,224,-1,8,225,9,-1,17,9,54,-1,17,10,9,-1,100,58,224,-1,355,58,100,-1,67,53,68,-1,67,51,53,-1,218,222,325,-1,217,222,218,-1,219,221,217,-1,219,359,221,-1,209,154,207,-1,209,152,154,-1,208,350,329,-1,210,350,208,-1,132,151,149,-1,132,143,151,-1,188,221,165,-1,221,188,220,-1,200,167,166,-1,200,199,167,-1,195,164,317,-1,189,164,195,-1,204,161,163,-1,161,204,203,-1,161,359,219,-1,161,205,359,-1,206,202,358,-1,202,206,203,-1,357,198,201,-1,357,356,198,-1,200,206,201,-1,200,205,206,-1,357,344,328,-1,358,344,357,-1,327,191,356,-1,327,331,191,-1,354,351,352,-1,354,353,351,-1,181,148,150,-1,148,181,182,-1,129,329,350,-1,129,326,329,-1,317,196,195,-1,317,187,196,-1,349,187,317,-1,349,185,187,-1,310,358,202,-1,310,344,358,-1,122,352,351,-1,352,122,121,-1,178,122,179,-1,178,120,122,-1,178,174,177,-1,178,2,174,-1,175,177,174,-1,172,177,175,-1,173,314,332,-1,314,173,1,-1,171,175,355,-1,171,172,175,-1,283,168,170,-1,283,34,168,-1,325,162,218,-1,325,315,162,-1,359,165,221,-1,359,166,165,-1,324,318,216,-1,324,145,318,-1,308,142,309,-1,142,308,213,-1,352,331,354,-1,65,331,352,-1,182,353,148,-1,351,353,182,-1,128,350,343,-1,128,129,350,-1,347,137,135,-1,348,137,347,-1,146,125,214,-1,146,123,125,-1,349,198,193,-1,349,199,198,-1,55,78,79,-1,55,332,78,-1,141,319,131,-1,138,319,141,-1,147,348,307,-1,147,137,348,-1,319,143,132,-1,144,143,319,-1,347,157,348,-1,157,347,346,-1,213,212,134,-1,213,308,212,-1,130,345,133,-1,130,160,345,-1,316,124,155,-1,124,316,315,-1,209,344,310,-1,209,208,344,-1,301,298,246,-1,298,301,305,-1,305,92,95,-1,305,304,92,-1,109,63,121,-1,109,69,63,-1,223,87,89,-1,223,231,87,-1,80,64,63,-1,80,81,64,-1,74,313,75,-1,74,192,313,-1,340,342,341,-1,340,339,342,-1,50,35,286,-1,50,39,35,-1,289,282,281,-1,289,337,282,-1,47,282,337,-1,47,49,282,-1,6,44,241,-1,44,6,45,-1,39,33,35,-1,39,38,33,-1,37,40,279,-1,36,40,37,-1,297,30,32,-1,297,257,30,-1,23,268,170,-1,23,25,268,-1,306,8,10,-1,306,338,8,-1,117,14,12,-1,117,303,14,-1,186,1,184,-1,186,314,1,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfibula_Coord_7_19_point_1()
		{
			double[] value = {3.3035,4.90165,-2.05435,3.451,5.83372,-2.11458,3.34807,5.79703,-1.95756,3.40924,4.9032,-2.15639,3.85416,14.13989,-1.6139,3.85277,14.11985,-1.53516,3.72738,14.3535,-1.54123,3.80922,14.31214,-1.71456,3.78608,11.13928,-1.85741,3.67193,10.28981,-1.96648,3.70363,11.13251,-1.87997,3.73444,12.802,-1.75365,3.87839,13.51279,-1.65478,3.78774,12.81455,-1.75715,3.94465,13.52524,-1.68126,3.61987,12.0107,-1.85048,3.6854,12.02307,-1.83388,3.60564,11.12706,-1.95226,3.53981,11.11622,-2.00521,4.28515,14.84805,-1.60159,4.27892,14.8042,-1.69764,4.23418,14.84166,-1.63631,4.38379,14.74864,-1.58488,4.09706,14.61358,-.99635,3.93481,14.45962,-.9913,4.12166,14.51593,-.99073,4.196,13.56965,-1.4515,4.23811,13.7873,-1.45499,4.16756,13.54144,-1.32397,4.23706,13.77547,-1.29892,4.09545,14.4035,-1.71087,4.08048,14.22089,-1.67505,4.03132,14.37145,-1.7105,4.1485,14.93568,-1.27388,4.24337,15.03473,-1.09327,4.21889,14.9559,-1.28728,4.17752,14.84167,-1.57434,4.10807,14.84109,-1.55681,4.16467,14.85547,-1.38737,4.22402,14.86499,-1.42016,4.17264,14.85392,-1.65004,3.88448,14.67659,-.95707,3.96969,14.75391,-1.16723,3.80898,14.63356,-1.00894,3.74058,14.35627,-1.34685,3.75037,14.34258,-1.35,3.7914,14.30275,-1.21671,4.36571,14.46632,-1.67703,4.32805,14.30721,-1.62793,4.30612,14.46735,-1.72173,4.32156,14.8867,-1.47463,3.49113,10.21217,-2.13845,3.49774,9.31806,-2.17403,3.45099,9.31943,-2.21687,3.53865,10.23955,-2.07485,3.59455,8.04561,-2.12124,3.64302,9.30639,-2.0465,3.62776,8.01805,-1.91064,3.76297,9.28813,-1.79866,3.1856,6.85368,-2.2838,3.35326,8.10408,-2.23335,3.20816,6.84721,-2.31063,3.35069,8.09999,-2.1684,3.10934,5.04082,-2.48248,3.19712,5.04811,-2.47812,3.04925,4.09457,-2.58941,3.41732,9.30798,-2.15362,3.46792,10.20802,-2.09748,3.43338,9.31559,-2.19314,3.11373,5.93068,-2.35357,3.11207,5.93678,-2.38126,3.40087,8.09661,-2.26646,3.3346,5.92848,-2.43437,3.37417,5.91824,-2.43945,3.27945,5.05912,-2.51569,3.24102,5.06447,-2.49775,3.36928,6.82924,-2.38182,3.42513,8.09616,-2.30032,3.42502,6.82247,-2.37496,3.46495,8.08607,-2.28858,3.1241,5.93925,-2.39406,3.2306,5.93439,-2.3855,3.29942,6.83181,-2.32105,3.44824,9.25189,-1.84286,3.44359,9.25796,-1.88151,3.26609,8.00076,-2.00813,3.21724,7.95363,-1.94757,3.5724,10.13623,-1.7084,3.43686,9.24654,-1.79085,3.57768,10.12224,-1.65378,3.47986,9.13324,-1.71361,3.35447,8.09735,-1.82126,3.89858,12.82097,-1.43213,3.93023,12.81581,-1.38208,3.96526,13.50255,-1.3065,3.94463,13.5045,-1.3558,3.52056,11.12457,-1.96183,3.50619,11.11821,-1.9172,3.61073,12.00247,-1.80965,3.56878,10.15004,-1.78918};
			return value;
		}
		private double[] getlfibula_Coord_7_19_point_2()
		{
			double[] value = {3.8173,10.17387,-1.61318,3.9352,11.08362,-1.55164,3.68071,10.11194,-1.61775,3.82789,11.0712,-1.5347,3.53114,10.16621,-1.85205,3.65109,11.09731,-1.77463,3.5361,11.11289,-1.85055,3.11718,6.8829,-2.13041,3.14299,6.87296,-2.17708,3.09181,5.92073,-2.29819,3.45692,9.2877,-2.07475,3.46602,9.26963,-1.97837,3.51495,10.17385,-1.95443,3.49393,10.18881,-2.01731,3.97393,13.69081,-1.23316,3.95234,13.71038,-1.31641,3.72458,12.80954,-1.72591,3.88932,13.74518,-1.63442,3.86832,13.74353,-1.60092,3.85578,13.51542,-1.62897,3.15413,5.87426,-2.11139,3.08596,5.01998,-2.40133,3.06688,4.99687,-2.25119,3.29638,1.84802,-2.45853,3.3414,1.8234,-2.58298,3.35262,1.77202,-2.48262,2.908,2.96793,-2.53981,2.93042,2.99966,-2.85899,2.93195,2.90178,-2.58009,2.93057,2.92126,-2.88676,2.98199,2.61415,-2.45617,3.01182,2.47648,-2.42023,3.01553,2.51236,-2.31401,3.00936,2.57058,-2.52444,3.25277,2.18685,-2.40125,3.27369,2.13497,-2.46484,3.22461,2.15548,-2.23985,3.24805,1.95861,-2.44052,3.06023,2.31928,-2.58776,3.06929,2.14412,-2.76813,3.11144,2.10281,-2.72791,3.04378,2.35715,-2.6303,3.16579,2.30652,-2.2472,3.08989,2.48525,-2.20542,3.0891,2.43197,-2.24259,3.17405,2.31901,-2.21062,3.29992,1.86674,-2.38122,3.25527,1.91073,-2.41157,2.96522,3.12995,-2.31708,2.96793,2.76592,-2.31113,3.00762,3.04336,-2.15142,3.05166,2.73668,-2.17937,3.20132,1.99932,-2.88437,3.23129,1.97355,-2.78765,3.15855,1.99507,-2.8523,3.29627,1.88974,-2.76773,3.20798,2.0121,-2.7371,3.24889,1.97487,-2.69119,3.18,2.06962,-2.6714,3.08936,2.30732,-2.54393,2.91975,2.80896,-2.41047,3.53884,2.05606,-2.71618,3.46805,1.8576,-2.71232,3.44043,1.87235,-2.83536,3.39496,2.72282,-2.26886,3.53752,2.38588,-2.26172,3.60134,2.43087,-2.40769,3.4013,2.76066,-2.36709,4.16525,14.94896,-1.02581,3.97488,14.75643,-.93587,4.20047,14.69972,-1.00319,3.58217,9.22963,-1.68643,3.47866,8.03595,-1.7811,3.51548,6.76759,-1.99682,3.44033,6.74831,-1.85785,3.60353,8.001,-1.76422,3.23616,6.83593,-1.95868,3.32344,6.80066,-1.877,3.19531,5.82126,-1.99972,3.10827,4.93181,-2.10196,3.2075,4.9076,-2.02893,3.05567,3.88581,-2.12173,3.02689,3.93212,-2.21626,3.17484,6.86081,-2.23407,3.44733,4.91312,-2.22321,3.30489,4.00106,-2.45496,3.45626,4.93206,-2.34972,3.32812,3.92373,-2.28752,3.41912,2.36853,-2.20241,3.31084,2.68986,-2.18214,3.22237,4.06612,-2.61554,3.16174,3.35334,-2.85945,3.14764,4.09664,-2.6589,3.19891,3.30929,-2.77299,3.1042,3.02376,-2.15517,3.19363,3.00987,-2.2025,3.23971,3.89468,-2.18358,3.15542,3.87955,-2.12382,3.29501,2.93673,-2.84993,3.4156,2.81492,-2.5899};
			return value;
		}
		private double[] getlfibula_Coord_7_19_point_3()
		{
			double[] value = {3.58823,2.51523,-2.63713,3.40575,2.64421,-2.91196,3.3482,2.10651,-3.06773,3.41902,2.12398,-2.97643,3.392,2.00922,-2.99486,3.60351,2.20694,-2.67949,3.43094,2.30574,-2.95426,3.09464,2.08962,-2.91497,3.05032,2.3256,-3.05479,3.13233,2.08753,-2.96533,3.0559,2.33762,-2.93528,3.23966,2.15758,-2.55546,3.20455,2.22833,-2.49523,3.22121,2.23934,-2.38159,3.38747,1.77727,-2.3551,3.43868,1.97774,-2.18624,3.35583,2.06566,-2.16208,3.52206,1.76188,-2.38703,3.50752,1.76394,-2.53816,3.58627,1.92499,-2.46363,3.49232,1.95746,-2.2078,3.56205,1.97158,-2.24194,3.44021,1.75697,-2.35932,3.71117,11.05796,-1.54913,3.86585,10.23574,-1.74806,3.93685,11.11155,-1.67319,3.9873,12.80897,-1.34139,3.82192,11.99896,-1.4847,3.91403,11.98076,-1.46109,3.76691,11.95385,-1.5904,3.71005,11.9485,-1.68949,3.70148,11.07231,-1.63619,3.76155,12.81572,-1.66478,3.67322,11.99654,-1.75066,4.06463,12.8233,-1.37834,4.01739,12.00745,-1.49173,4.0988,12.83567,-1.42332,3.85901,14.15892,-1.66024,3.73822,14.42475,-1.75252,3.90612,14.51953,-1.79128,3.93896,14.3364,-1.75753,3.70038,14.40384,-1.53596,3.69012,14.54314,-1.53185,3.72821,14.55131,-1.6413,3.86736,14.11563,-1.39885,3.87943,13.74103,-1.55947,3.901,13.73525,-1.48198,3.83638,14.44988,-1.04359,3.96281,14.30844,-.99105,3.89079,14.29979,-1.07315,3.74788,14.404,-1.19856,3.72426,14.48296,-1.35512,4.20951,14.26959,-1.68859,4.17358,14.45224,-1.75237,3.96291,14.18543,-1.69176,4.15048,13.7852,-1.61513,3.8368,14.67983,-1.75953,4.04519,14.58658,-1.77117,4.08391,14.77187,-1.76719,4.13977,14.63124,-1.81646,3.93814,14.73744,-1.76161,4.11918,13.52726,-1.27083,4.03838,13.5114,-1.25442,4.09458,14.10384,-1.01717,4.03383,13.68516,-1.18817,3.97173,14.05098,-1.03393,4.14037,13.71867,-1.20834,4.2359,14.2043,-1.11184,4.23527,14.55394,-1.01211,4.14998,14.34903,-.9819,4.25162,14.37752,-1.03944,3.75736,14.61481,-1.14393,3.77447,14.62757,-1.30317,3.77735,14.69092,-1.48841,3.79579,14.72072,-1.58577,3.86873,14.77345,-1.66472,3.9163,14.76093,-1.49531,4.10538,14.84596,-1.3546,4.12884,14.89272,-1.22036,4.06142,14.84093,-1.65674,4.17201,14.80842,-1.77696,4.19457,14.68281,-1.84898,4.28743,14.5266,-1.78363,4.41334,14.93108,-1.17534,4.45533,14.68984,-1.22873,4.44841,14.92766,-1.28177,4.32991,14.98779,-1.30844,4.46321,14.68458,-1.43388,4.41882,14.83447,-1.46942,4.3513,14.7313,-1.73342,4.40036,14.50569,-1.49549,4.42977,14.57023,-1.51202,4.46425,14.49962,-1.41095,3.98095,14.83156,-1.66164,4.03868,14.84052,-1.53931,4.37231,14.3094,-1.47135,3.9319,14.07717,-1.1598,3.97979,14.55529,-1.76662,3.93146,13.72998,-1.39939,3.88725,14.10423,-1.29498};
			return value;
		}
		private double[] getlfibula_Coord_7_19_point_4()
		{
			double[] value = {3.85923,13.50698,-1.57539,3.87357,13.50295,-1.52981,3.81475,12.81636,-1.59454,3.96919,13.75482,-1.68039,3.85212,12.83251,-1.52132,3.90298,13.49826,-1.4392,3.79409,12.0292,-1.81097,3.29996,1.86392,-2.60734,3.192,2.26302,-2.44136,3.0691,2.36188,-2.38639,3.16499,2.07817,-3.00425,3.23549,1.9916,-2.91808,3.22435,2.68989,-2.15639,3.11141,4.10166,-2.64344,3.47826,5.86666,-2.29805,3.38908,1.82997,-2.63511,3.34532,1.86895,-2.79761,3.28482,3.05199,-2.30009,3.24191,2.14126,-2.19072,3.01937,2.45467,-2.34281,3.25819,1.93664,-2.73061,3.05574,2.35504,-2.79481,3.07335,2.11006,-2.85765,3.13998,2.03794,-2.78388,3.31393,2.38577,-2.16384,3.40188,1.75118,-2.50135,2.92512,2.91359,-3.05076,2.94555,3.01143,-3.03789,2.99696,2.72413,-3.17357,2.97056,2.71719,-3.13321,3.32035,8.05487,-2.08217,3.02579,3.34981,-2.80236,3.51887,6.79994,-2.22981,4.04168,13.76259,-1.66415,4.0994,12.86042,-1.53582,4.02651,12.03652,-1.59508,3.9646,14.74799,-1.32624,4.38741,14.5243,-1.70695,3.90267,12.02694,-1.77607,3.90791,12.83284,-1.72401,4.01253,12.84886,-1.67574,4.12554,13.57165,-1.60394,4.01457,13.54098,-1.6603,3.02943,2.61042,-2.73472,3.08047,2.3245,-3.09961,2.94228,2.78938,-2.4921,3.26275,2.11945,-2.56534,3.28327,2.10319,-2.51787,3.28426,1.92183,-2.59565,3.28654,3.1856,-2.53517,2.99622,2.67204,-2.96571,2.9989,4.00429,-2.36607,3.02949,4.06114,-2.50605,2.95377,3.22351,-2.48078,3.00285,3.29597,-2.66826,3.7302,9.28576,-1.67186,3.15055,2.94975,-3.11408,3.17476,2.73209,-3.20898,3.23682,2.33613,-3.15403,3.64078,2.12148,-2.43257,4.37272,14.30561,-1.24617,4.46713,14.49006,-1.23372};
			return value;
		}

		/** Large attribute array: IndexedFaceSet DEF='ltibia_Geo' coordIndex field, scene-graph level=6, element #14, 7632 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getltibia_Geo_6_14_coordIndex()
		{
			MFInt32 ltibia_Geo_6_14_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_1()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_2()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_3()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_4()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_5()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_6()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_7()))
				.append(new MFInt32(getltibia_Geo_6_14_coordIndex_8()));
			return ltibia_Geo_6_14_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='ltibia_Coord' point field, scene-graph level=7, element #14, 2868 total numbers made up of 956 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getltibia_Coord_7_14_point()
		{
			MFVec3f ltibia_Coord_7_14_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getltibia_Coord_7_14_point_1()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_2()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_3()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_4()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_5()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_6()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_7()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_8()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_9()))
				.append(new MFVec3f(getltibia_Coord_7_14_point_10()));
			return ltibia_Coord_7_14_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfibula_Geo' coordIndex field, scene-graph level=6, element #19, 2880 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfibula_Geo_6_19_coordIndex()
		{
			MFInt32 lfibula_Geo_6_19_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfibula_Geo_6_19_coordIndex_1()))
				.append(new MFInt32(getlfibula_Geo_6_19_coordIndex_2()))
				.append(new MFInt32(getlfibula_Geo_6_19_coordIndex_3()));
			return lfibula_Geo_6_19_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfibula_Coord' point field, scene-graph level=7, element #19, 1086 total numbers made up of 362 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfibula_Coord_7_19_point()
		{
			MFVec3f lfibula_Coord_7_19_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfibula_Coord_7_19_point_1()))
				.append(new MFVec3f(getlfibula_Coord_7_19_point_2()))
				.append(new MFVec3f(getlfibula_Coord_7_19_point_3()))
				.append(new MFVec3f(getlfibula_Coord_7_19_point_4()));
			return lfibula_Coord_7_19_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return BonesLeftTibiaFibula model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new BonesLeftTibiaFibula().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Medical.BonesLeftTibiaFibula\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Medical.BonesLeftTibiaFibula self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Medical/BonesLeftTibiaFibula_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Medical/BonesLeftTibiaFibula_JavaExport.x3d"; 
                String filenameX3DV = "Medical/BonesLeftTibiaFibula_JavaExport.x3dv"; 
                String filenameJSON = "Medical/BonesLeftTibiaFibula_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
