package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Human bone model for Left Radius Ulna. </p>
 <p> Related links: Catalog page <a href="../../../Medical/BonesLeftRadiusUlnaIndex.html" target="_blank">BonesLeftRadiusUlna</a>,  source <a href="../../../Medical/BonesLeftRadiusUlna.java">BonesLeftRadiusUlna.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/BonesLeftRadiusUlna.x3d">BonesLeftRadiusUlna.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Damon Hernandez, Joe Williams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Human bone model for Left Radius Ulna </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Joe Williams, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 5 December 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftRadiusUlna.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftRadiusUlna.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Damon Hernandez, Joe Williams
 */

public class BonesLeftRadiusUlna
{
	/** Default constructor to create this object. */
	public BonesLeftRadiusUlna ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("BonesLeftRadiusUlna.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Damon Hernandez, Joe Williams"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Human bone model for Left Radius Ulna"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Joe Williams, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("5 December 2013"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftRadiusUlna.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("BonesLeftRadiusUlna.x3d"))
    .addChild(new Group("LeftArm")
      .addComments(" lradius lulna ")
      .addChild(new Transform("LeftradulnSkeletonParts").setScale(0.029,0.029,0.029)
        .addChild(new Shape("lradius")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lradius_Geo").setDEF("lradius_Geo").setCreaseAngle(1.571).setCoordIndex(getlradius_Geo_6_14_coordIndex())
            .setCoord(new Coordinate("lradius_Coord").setPoint(getlradius_Coord_7_14_point()))))
        .addChild(new Shape("lulna")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,1.0,0.5).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lulna_Geo").setDEF("lulna_Geo").setCreaseAngle(1.571).setCoordIndex(getlulna_Geo_6_19_coordIndex())
            .setCoord(new Coordinate("lulna_Coord").setPoint(getlulna_Coord_7_19_point())))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getlradius_Geo_6_14_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,4,6,5,-1,7,8,9,-1,8,10,9,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,37,38,39,-1,39,40,37,-1,41,42,43,-1,42,44,43,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,52,53,54,-1,53,55,54,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,62,63,60,-1,60,64,65,-1,61,66,67,-1,67,68,61,-1,69,70,68,-1,68,67,69,-1,71,72,73,-1,74,75,76,-1,77,72,78,-1,72,79,73,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,89,92,90,-1,93,94,95,-1,96,87,25,-1,33,30,96,-1,97,95,94,-1,97,31,98,-1,97,99,31,-1,33,25,24,-1,33,96,25,-1,100,101,102,-1,103,104,105,-1,106,107,108,-1,106,109,107,-1,110,111,112,-1,113,114,115,-1,116,114,113,-1,113,117,116,-1,118,119,120,-1,121,122,123,-1,121,124,122,-1,125,126,127,-1,128,129,127,-1,127,126,128,-1,130,131,132,-1,131,133,132,-1,134,135,136,-1,136,137,134,-1,138,139,140,-1,138,141,139,-1,142,143,144,-1,143,145,144,-1,146,147,148,-1,149,126,125,-1,125,150,149,-1,118,151,152,-1,153,154,155,-1,155,156,153,-1,157,147,158,-1,158,159,157,-1,159,160,157,-1,160,161,157,-1,157,162,147,-1,159,163,160,-1,161,164,157,-1,154,141,138,-1,138,165,154,-1,166,167,168,-1,166,142,167,-1,169,170,171,-1,169,172,170,-1,131,173,133,-1,173,10,133,-1,174,175,176,-1,174,177,175,-1,178,179,180,-1,179,181,180,-1,139,182,140,-1,182,183,140,-1,184,185,186,-1,184,187,185,-1,188,189,190,-1,190,191,188,-1,192,193,4,-1,193,194,4,-1,195,6,194,-1,6,4,194,-1,196,117,197,-1,198,199,200,-1,110,112,149,-1,112,201,149,-1,202,203,117,-1,117,196,202,-1,204,117,205,-1,206,152,207,-1,152,208,207,-1,199,209,200,-1,209,210,200,-1,211,113,115,-1,128,126,149,-1,149,201,128,-1,212,213,214,-1,212,215,213,-1,212,195,215,-1,101,216,217,-1,101,100,216,-1,218,219,220,-1,220,221,218,-1,125,101,217,-1,125,222,101,-1,217,150,125,-1,223,110,149,-1,224,101,222,-1,224,221,101,-1,225,226,227,-1,226,218,227,-1,228,229,230,-1,229,231,230,-1,232,233,234,-1,233,235,234,-1,216,236,237,-1,216,100,236,-1,238,239,219,-1,239,240,219,-1,241,242,243,-1,241,244,242,-1,245,246,247,-1,245,248,246,-1,249,85,250,-1,249,251,85,-1,252,249,253,-1,254,255,256,-1,256,257,254,-1,258,259,260,-1,241,248,261,-1,261,262,241,-1,263,264,265,-1,265,266,263,-1,267,268,45,-1,45,47,267,-1,269,41,270,-1,270,271,269,-1,272,273,274,-1,273,275,274,-1,34,38,37,-1,34,276,38,-1,277,278,40,-1,40,39,277,-1,279,280,281,-1,282,283,284,-1,282,285,283,-1,286,287,288,-1,286,289,287,-1,290,291,62,-1,62,78,290,-1,292,293,294,-1,295,296,297,-1,298,299,93,-1,299,94,93,-1,300,298,28,-1,300,301,298,-1,302,12,303,-1,12,11,303,-1,304,305,306,-1,305,307,306,-1,308,309,310,-1,309,311,310,-1,312,311,313,-1,312,310,311,-1,262,244,241,-1,262,314,244,-1,14,16,22,-1,16,23,22,-1,20,315,18,-1,20,316,315,-1,317,318,319,-1,64,60,63,-1,320,65,64,-1,61,68,62,-1,321,322,323,-1,322,316,323,-1,324,325,326,-1,325,327,326,-1,328,329,330,-1,328,331,329,-1,332,333,334,-1,335,106,108,-1,335,336,106,-1,337,87,86,-1,337,338,87,-1,339,92,89,-1,339,334,92,-1,335,332,340,-1,335,341,332,-1,109,237,236,-1,109,105,237,-1,342,104,103,-1,342,343,104,-1,344,343,342,-1,344,345,343,-1,91,346,89,-1,96,88,87,-1,63,87,338,-1,334,333,92,-1,333,347,92,-1,90,348,349,-1,332,341,350,-1,341,351,350,-1,341,308,310,-1,310,351,341,-1,326,327,352,-1,327,353,352,-1,318,353,327,-1,66,354,67,-1,66,355,354,-1,320,330,329,-1,320,64,330,-1,291,63,62,-1,356,316,20,-1,356,323,316,-1,23,314,262,-1,23,16,314,-1,309,240,311,-1,309,357,240,-1,53,358,306,-1,306,359,53,-1,59,360,57,-1,59,361,360,-1,27,362,26,-1,26,363,27,-1};
			return value;
		}
		private int[] getlradius_Geo_6_14_coordIndex_2()
		{
			int[] value = {364,297,296,-1,364,344,297,-1,69,293,77,-1,293,292,77,-1,294,365,292,-1,294,366,365,-1,367,368,71,-1,367,369,368,-1,365,366,370,-1,284,371,372,-1,284,283,371,-1,290,373,291,-1,373,374,291,-1,285,375,376,-1,285,282,375,-1,279,278,280,-1,278,277,280,-1,38,48,39,-1,276,377,378,-1,378,46,276,-1,272,274,379,-1,43,380,41,-1,380,270,41,-1,268,381,382,-1,268,383,381,-1,384,252,253,-1,253,385,384,-1,386,387,302,-1,387,12,302,-1,388,261,389,-1,261,259,389,-1,387,258,12,-1,258,13,12,-1,258,390,13,-1,258,260,390,-1,256,391,257,-1,391,392,257,-1,250,84,392,-1,250,85,84,-1,307,76,75,-1,307,393,76,-1,260,247,394,-1,260,245,247,-1,242,244,238,-1,244,239,238,-1,357,220,240,-1,220,219,240,-1,395,224,396,-1,224,222,396,-1,234,235,228,-1,235,229,228,-1,151,223,232,-1,125,396,222,-1,125,127,396,-1,231,247,246,-1,231,229,247,-1,235,233,397,-1,397,394,235,-1,398,243,242,-1,398,399,243,-1,226,238,218,-1,238,219,218,-1,221,102,101,-1,221,220,102,-1,400,195,401,-1,195,194,401,-1,214,128,201,-1,214,213,128,-1,113,211,199,-1,211,209,199,-1,124,402,211,-1,211,115,124,-1,209,403,210,-1,403,404,210,-1,402,206,403,-1,206,207,403,-1,152,206,121,-1,118,120,405,-1,405,111,118,-1,111,110,118,-1,212,202,196,-1,196,195,212,-1,199,406,113,-1,196,6,195,-1,196,197,6,-1,407,408,409,-1,409,410,407,-1,9,3,7,-1,3,5,7,-1,411,182,139,-1,411,412,182,-1,183,413,178,-1,413,179,178,-1,185,414,186,-1,415,416,417,-1,415,418,416,-1,168,419,420,-1,168,167,419,-1,137,136,421,-1,136,174,421,-1,128,422,129,-1,128,213,422,-1,195,400,215,-1,117,204,116,-1,117,203,205,-1,119,152,123,-1,119,118,152,-1,152,121,123,-1,245,261,248,-1,109,423,107,-1,109,236,423,-1,424,397,233,-1,425,13,390,-1,426,99,427,-1,94,295,427,-1,363,26,25,-1,428,426,429,-1,428,32,426,-1,426,427,429,-1,430,96,30,-1,431,89,346,-1,330,432,328,-1,330,337,432,-1,330,338,337,-1,330,64,338,-1,72,71,368,-1,77,292,365,-1,79,77,365,-1,79,72,77,-1,290,368,369,-1,369,373,290,-1,370,79,365,-1,370,372,79,-1,304,306,358,-1,393,307,305,-1,338,64,63,-1,254,257,433,-1,433,81,281,-1,281,254,433,-1,74,81,433,-1,74,82,81,-1,57,360,49,-1,46,378,47,-1,276,34,36,-1,36,377,276,-1,293,434,35,-1,430,32,428,-1,430,30,32,-1,33,24,98,-1,98,31,33,-1,24,26,362,-1,263,435,436,-1,435,437,436,-1,263,266,435,-1,317,43,44,-1,421,179,137,-1,179,413,137,-1,198,406,199,-1,438,169,439,-1,169,438,440,-1,441,439,442,-1,441,438,439,-1,443,444,198,-1,444,443,187,-1,445,442,185,-1,445,441,442,-1,197,5,6,-1,446,5,197,-1,190,184,447,-1,184,190,448,-1,449,450,189,-1,450,449,451,-1,171,173,175,-1,170,173,171,-1,452,177,453,-1,454,177,452,-1,186,455,456,-1,414,455,186,-1,457,458,408,-1,458,457,459,-1,409,460,461,-1,460,409,462,-1,134,413,463,-1,137,413,134,-1,459,464,465,-1,459,457,464,-1,466,467,468,-1,467,466,132,-1,469,470,181,-1,130,470,469,-1,471,343,345,-1,303,343,471,-1,472,319,356,-1,380,319,472,-1,21,436,22,-1,263,436,21,-1,473,270,474,-1,473,271,270,-1,24,475,98,-1,24,362,475,-1,428,476,430,-1,476,428,477,-1,432,478,479,-1,432,480,478,-1,331,349,348,-1,331,328,349,-1,379,35,434,-1,379,36,35,-1,481,482,267,-1,482,481,269,-1,39,483,277,-1,483,39,484,-1,255,281,280,-1,254,281,255,-1,288,358,485,-1,288,304,358,-1,393,375,76,-1,393,376,375,-1,288,305,304,-1,287,305,288,-1,82,76,375,-1,74,76,82,-1,58,49,51,-1,49,58,57,-1,486,279,80,-1,279,486,278,-1,37,487,366,-1,40,487,37,-1,488,374,489,-1,488,490,374,-1,54,491,52,-1,54,492,491,-1,35,294,293,-1,294,35,34,-1,493,371,283,-1,367,371,493,-1,287,285,376,-1,287,289,285,-1,375,494,82,-1,375,282,494,-1,284,370,495,-1,372,370,284,-1,78,368,290,-1,78,72,368,-1,369,496,373,-1,369,497,496,-1,485,286,288,-1,485,498,286,-1,91,349,479,-1,349,91,90,-1};
			return value;
		}
		private int[] getlradius_Geo_6_14_coordIndex_3()
		{
			int[] value = {478,431,346,-1,478,477,431,-1,93,475,29,-1,475,93,95,-1,309,423,357,-1,423,309,107,-1,390,424,425,-1,397,424,390,-1,237,13,425,-1,237,105,13,-1,100,423,236,-1,100,102,423,-1,204,499,116,-1,499,204,500,-1,501,203,502,-1,501,205,203,-1,215,422,213,-1,215,400,422,-1,467,503,465,-1,467,504,503,-1,188,465,503,-1,465,188,459,-1,458,505,462,-1,458,191,505,-1,174,469,421,-1,174,176,469,-1,411,506,507,-1,508,506,411,-1,509,510,511,-1,512,510,509,-1,419,513,514,-1,419,167,513,-1,416,515,516,-1,416,418,515,-1,147,517,148,-1,147,162,517,-1,518,519,520,-1,518,521,519,-1,147,522,158,-1,147,146,522,-1,156,161,523,-1,164,161,156,-1,524,163,525,-1,160,163,524,-1,526,146,417,-1,522,146,526,-1,148,165,415,-1,517,165,148,-1,527,524,528,-1,527,523,524,-1,525,420,529,-1,530,420,525,-1,520,166,168,-1,519,166,520,-1,158,518,159,-1,158,521,518,-1,508,527,506,-1,508,153,527,-1,529,419,510,-1,420,419,529,-1,143,417,416,-1,417,143,526,-1,415,138,418,-1,165,138,415,-1,452,185,442,-1,452,414,185,-1,135,453,136,-1,135,455,453,-1,470,531,532,-1,470,466,531,-1,183,463,413,-1,182,463,183,-1,144,532,531,-1,145,532,144,-1,516,178,180,-1,515,178,516,-1,444,450,533,-1,450,444,448,-1,7,446,451,-1,7,5,446,-1,505,456,534,-1,505,447,456,-1,504,449,503,-1,504,8,449,-1,461,410,409,-1,410,461,412,-1,408,535,457,-1,535,408,407,-1,536,464,537,-1,536,468,464,-1,412,507,410,-1,507,412,411,-1,407,511,535,-1,511,407,509,-1,537,513,536,-1,513,537,514,-1,438,538,1,-1,438,441,538,-1,443,539,445,-1,443,540,539,-1,202,214,541,-1,214,202,212,-1,541,111,502,-1,541,112,111,-1,501,120,500,-1,501,405,120,-1,116,122,114,-1,116,499,122,-1,542,543,544,-1,545,543,542,-1,546,547,548,-1,546,549,547,-1,542,550,551,-1,542,552,550,-1,545,553,548,-1,553,545,554,-1,403,546,404,-1,403,207,546,-1,124,206,402,-1,124,121,206,-1,555,554,551,-1,556,554,555,-1,553,210,404,-1,210,553,557,-1,403,211,402,-1,211,403,209,-1,1,555,2,-1,538,555,1,-1,556,540,557,-1,540,556,539,-1,552,558,550,-1,558,552,559,-1,193,2,560,-1,193,0,2,-1,395,561,559,-1,561,395,396,-1,194,560,401,-1,194,193,560,-1,562,129,422,-1,562,561,129,-1,226,242,238,-1,226,398,242,-1,231,243,399,-1,231,246,243,-1,247,235,394,-1,229,235,247,-1,399,563,564,-1,399,398,563,-1,227,395,565,-1,227,224,395,-1,563,544,543,-1,563,225,544,-1,549,564,547,-1,549,230,564,-1,228,152,234,-1,152,228,208,-1,260,397,390,-1,394,397,260,-1,392,75,257,-1,75,392,84,-1,391,250,392,-1,391,566,250,-1,258,389,259,-1,389,258,387,-1,261,23,262,-1,23,261,388,-1,567,387,386,-1,567,389,387,-1,21,388,568,-1,21,23,388,-1,386,569,567,-1,569,386,570,-1,263,568,264,-1,263,21,568,-1,571,570,384,-1,571,569,570,-1,384,572,571,-1,572,384,385,-1,573,265,574,-1,573,266,265,-1,385,575,572,-1,575,385,576,-1,574,577,573,-1,577,574,578,-1,381,576,579,-1,381,575,576,-1,578,482,577,-1,482,578,383,-1,382,579,580,-1,382,381,579,-1,267,383,268,-1,267,482,383,-1,484,580,483,-1,484,382,580,-1,269,577,482,-1,577,269,271,-1,275,44,42,-1,275,273,44,-1,267,378,481,-1,47,378,267,-1,48,276,46,-1,48,38,276,-1,486,82,494,-1,486,80,82,-1,52,498,485,-1,491,498,52,-1,489,373,496,-1,374,373,489,-1,497,367,493,-1,367,497,369,-1,495,366,487,-1,370,366,495,-1,79,371,73,-1,79,372,371,-1,68,78,62,-1,78,68,70,-1,300,58,301,-1,300,56,58,-1,364,299,581,-1,296,299,364,-1,95,98,475,-1,95,97,98,-1,28,363,582,-1,28,27,363,-1,363,490,488,-1,363,25,490,-1,54,583,584,-1,54,55,583,-1,306,59,359,-1,306,361,59,-1,303,585,302,-1,471,585,303,-1,251,50,49,-1,251,586,50,-1,360,83,85,-1,361,83,360,-1,437,472,17,-1,474,472,437,-1,314,239,244,-1,314,313,239,-1,312,15,587,-1,15,312,16,-1,273,353,44,-1,273,352,353,-1,588,379,434,-1,272,379,588,-1,355,329,324,-1,320,329,355,-1,434,354,588,-1,434,67,354,-1};
			return value;
		}
		private int[] getlradius_Geo_6_14_coordIndex_4()
		{
			int[] value = {588,326,352,-1,588,354,326,-1,587,310,312,-1,351,310,587,-1,315,351,587,-1,350,351,315,-1,350,316,322,-1,350,315,316,-1,321,318,589,-1,321,323,318,-1,589,327,325,-1,589,318,327,-1,92,348,90,-1,92,347,348,-1,291,490,63,-1,291,374,490,-1,346,479,478,-1,346,91,479,-1,339,297,340,-1,339,295,297,-1,431,427,89,-1,431,429,427,-1,88,430,476,-1,430,88,96,-1,336,103,106,-1,336,342,103,-1,50,344,364,-1,50,345,344,-1,50,581,51,-1,364,581,50,-1,297,342,336,-1,297,344,342,-1,106,105,109,-1,106,103,105,-1,99,32,31,-1,32,99,426,-1,429,477,428,-1,477,429,431,-1,295,89,427,-1,89,295,339,-1,340,336,335,-1,340,297,336,-1,334,340,332,-1,340,334,339,-1,480,337,86,-1,337,480,432,-1,108,341,335,-1,341,108,308,-1,331,324,329,-1,331,325,324,-1,325,348,589,-1,331,348,325,-1,347,589,348,-1,347,321,589,-1,333,321,347,-1,333,322,321,-1,322,332,350,-1,333,332,322,-1,66,320,355,-1,66,65,320,-1,354,324,326,-1,354,355,324,-1,272,352,273,-1,272,588,352,-1,323,319,318,-1,323,356,319,-1,18,587,15,-1,18,315,587,-1,16,313,314,-1,16,312,313,-1,22,19,14,-1,436,19,22,-1,17,436,437,-1,17,19,436,-1,266,473,435,-1,573,473,266,-1,313,240,239,-1,313,311,240,-1,306,83,361,-1,306,307,83,-1,85,49,360,-1,85,251,49,-1,345,586,471,-1,345,50,586,-1,252,471,586,-1,585,471,252,-1,488,582,363,-1,492,582,488,-1,300,582,584,-1,300,28,582,-1,298,29,28,-1,298,93,29,-1,298,581,299,-1,298,301,581,-1,296,94,299,-1,94,296,295,-1,584,56,300,-1,584,583,56,-1,301,51,581,-1,58,51,301,-1,491,496,498,-1,489,496,491,-1,493,286,497,-1,493,289,286,-1,494,487,486,-1,495,487,494,-1,74,257,75,-1,74,433,257,-1,377,275,378,-1,275,377,274,-1,481,275,42,-1,275,481,378,-1,573,271,473,-1,271,573,577,-1,474,380,472,-1,474,270,380,-1,45,382,484,-1,45,268,382,-1,256,483,580,-1,483,256,255,-1,391,580,579,-1,580,391,256,-1,383,575,381,-1,383,578,575,-1,579,566,391,-1,579,576,566,-1,572,578,574,-1,578,572,575,-1,253,576,385,-1,576,253,566,-1,574,571,572,-1,574,265,571,-1,265,569,571,-1,265,264,569,-1,585,384,570,-1,384,585,252,-1,264,567,569,-1,264,568,567,-1,570,302,585,-1,570,386,302,-1,389,568,388,-1,568,389,567,-1,260,261,245,-1,261,260,259,-1,566,249,250,-1,566,253,249,-1,586,249,252,-1,586,251,249,-1,246,241,243,-1,246,248,241,-1,151,234,152,-1,151,232,234,-1,208,230,549,-1,208,228,230,-1,547,563,543,-1,547,564,563,-1,225,565,544,-1,225,227,565,-1,230,399,564,-1,230,231,399,-1,225,398,226,-1,563,398,225,-1,218,224,227,-1,218,221,224,-1,110,151,118,-1,110,223,151,-1,217,424,233,-1,217,216,424,-1,422,401,562,-1,422,400,401,-1,127,561,396,-1,129,561,127,-1,401,558,562,-1,401,560,558,-1,562,559,561,-1,562,558,559,-1,560,550,558,-1,560,2,550,-1,565,559,552,-1,559,565,395,-1,200,557,540,-1,200,210,557,-1,538,556,555,-1,539,556,538,-1,554,557,553,-1,557,554,556,-1,2,551,550,-1,555,551,2,-1,548,404,546,-1,404,548,553,-1,545,551,554,-1,545,542,551,-1,549,207,208,-1,207,549,546,-1,548,543,545,-1,548,547,543,-1,552,544,565,-1,542,544,552,-1,123,499,119,-1,122,499,123,-1,205,500,204,-1,205,501,500,-1,502,202,541,-1,203,202,502,-1,201,541,214,-1,201,112,541,-1,198,540,443,-1,198,200,540,-1,441,539,538,-1,441,445,539,-1,192,0,193,-1,0,192,440,-1,531,513,144,-1,531,536,513,-1,535,514,537,-1,514,535,511,-1,410,509,407,-1,509,410,507,-1,466,536,531,-1,466,468,536,-1,457,537,464,-1,537,457,535,-1,133,8,504,-1,133,10,8,-1,503,189,188,-1,503,449,189,-1,191,447,505,-1,191,190,447,-1,451,533,450,-1,451,446,533,-1,187,448,444,-1,448,187,184,-1,515,183,178,-1,140,183,515,-1,180,145,516,-1,180,532,145,-1,412,463,182,-1,412,461,463,-1,532,181,470,-1,180,181,532,-1,534,455,135,-1,534,456,455,-1,453,174,136,-1,453,177,174,-1,175,131,176,-1,175,173,131,-1,442,454,452,-1,442,439,454,-1,172,9,170,-1,9,172,3,-1};
			return value;
		}
		private int[] getlradius_Geo_6_14_coordIndex_5()
		{
			int[] value = {142,526,143,-1,526,142,166,-1,512,529,510,-1,529,512,528,-1,154,508,141,-1,154,153,508,-1,506,528,512,-1,506,527,528,-1,166,522,526,-1,522,166,519,-1,530,168,420,-1,520,168,530,-1,525,528,524,-1,525,529,528,-1,153,523,527,-1,523,153,156,-1,517,154,165,-1,155,154,517,-1,417,148,415,-1,417,146,148,-1,113,197,117,-1,113,406,197,-1,150,223,149,-1,232,223,150,-1,530,163,159,-1,163,530,525,-1,523,160,524,-1,161,160,523,-1,157,156,155,-1,157,164,156,-1,519,158,522,-1,521,158,519,-1,162,155,517,-1,162,157,155,-1,159,520,530,-1,159,518,520,-1,418,140,515,-1,418,138,140,-1,145,416,516,-1,143,416,145,-1,167,144,513,-1,167,142,144,-1,510,514,511,-1,510,419,514,-1,507,512,509,-1,506,512,507,-1,141,411,139,-1,141,508,411,-1,460,135,134,-1,460,534,135,-1,130,176,131,-1,469,176,130,-1,462,534,460,-1,462,505,534,-1,459,191,458,-1,459,188,191,-1,132,504,467,-1,132,133,504,-1,233,150,217,-1,233,232,150,-1,502,405,501,-1,405,502,111,-1,124,114,122,-1,124,115,114,-1,119,500,120,-1,119,499,500,-1,11,105,104,-1,105,11,13,-1,216,425,424,-1,237,425,216,-1,357,102,220,-1,102,357,423,-1,107,308,108,-1,107,309,308,-1,94,99,97,-1,94,427,99,-1,476,86,88,-1,86,476,480,-1,84,307,75,-1,84,83,307,-1,497,498,496,-1,286,498,497,-1,282,495,494,-1,282,284,495,-1,78,69,77,-1,78,70,69,-1,289,283,285,-1,289,493,283,-1,367,73,371,-1,71,73,367,-1,434,69,67,-1,69,434,293,-1,366,34,37,-1,366,294,34,-1,489,492,488,-1,491,492,489,-1,60,66,61,-1,60,65,66,-1,486,40,278,-1,486,487,40,-1,80,281,81,-1,80,279,281,-1,87,490,25,-1,490,87,63,-1,359,55,53,-1,583,55,359,-1,359,56,583,-1,359,59,56,-1,305,376,393,-1,376,305,287,-1,485,53,52,-1,485,358,53,-1,492,584,582,-1,584,492,54,-1,277,255,280,-1,255,277,483,-1,48,484,39,-1,484,48,45,-1,42,269,481,-1,269,42,41,-1,318,44,353,-1,317,44,318,-1,36,274,377,-1,274,36,379,-1,328,479,349,-1,328,432,479,-1,477,480,476,-1,480,477,478,-1,362,29,475,-1,362,27,29,-1,435,474,437,-1,473,474,435,-1,317,380,43,-1,317,319,380,-1,20,472,356,-1,472,20,17,-1,15,19,18,-1,19,15,14,-1,104,303,11,-1,104,343,303,-1,421,181,179,-1,469,181,421,-1,130,466,470,-1,132,466,130,-1,468,465,464,-1,465,468,467,-1,461,134,463,-1,134,461,460,-1,408,462,409,-1,462,408,458,-1,447,186,456,-1,186,447,184,-1,455,452,453,-1,452,455,414,-1,175,454,171,-1,175,177,454,-1,170,10,173,-1,9,10,170,-1,8,451,449,-1,451,8,7,-1,189,448,190,-1,448,189,450,-1,192,3,172,-1,192,4,3,-1,406,446,197,-1,533,446,406,-1,440,172,169,-1,440,192,172,-1,198,533,406,-1,533,198,444,-1,187,445,185,-1,187,443,445,-1,439,171,454,-1,171,439,169,-1,440,1,0,-1,440,438,1,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlradius_Coord_7_14_point_1()
		{
			double[] value = {8.02081,36.00597,-.94664,8.01291,36.02124,-.92244,8.01622,35.89713,-.86484,7.9621,36.25911,-1.2772,7.95366,36.20609,-1.24432,7.83268,36.2605,-1.28912,7.8291,36.20055,-1.26624,7.83285,36.37017,-1.35203,7.8305,36.41838,-1.38802,7.98413,36.37041,-1.37103,7.99442,36.41177,-1.41605,7.58153,31.38452,1.17213,7.56841,31.39333,1.18256,7.66159,32.21879,.83796,7.59703,30.85569,2.01223,7.62927,30.85178,2.00828,7.73067,31.58696,1.62114,7.52665,30.29452,2.36957,7.59958,30.58624,2.14714,7.56186,30.59134,2.14599,7.56444,30.28703,2.36027,7.54083,30.82639,1.97878,7.57218,30.84395,2.00512,7.66044,31.58279,1.61085,7.74591,29.40659,2.11727,7.72561,29.29596,2.26292,7.73509,29.31827,2.13628,7.71641,29.39684,2.01024,7.67397,29.39229,1.89213,7.71923,29.44869,1.98832,7.78552,29.43348,2.14876,7.75495,29.51366,2.06755,7.79868,29.52521,2.09225,7.75338,29.41859,2.12529,7.28385,29.33297,2.75208,7.3964,29.26949,2.83954,7.35145,29.34305,2.88448,7.18083,29.36385,2.57351,7.12233,29.42285,2.57208,7.04382,29.38647,2.38595,7.10256,29.33212,2.35831,7.36296,29.93069,2.6745,7.33685,29.85672,2.75396,7.42387,29.93579,2.66963,7.42472,29.82809,2.7575,7.12819,29.54576,2.51883,7.20157,29.57431,2.69926,7.19201,29.62917,2.67832,7.12686,29.50217,2.54038,7.50333,29.68826,1.71524,7.51844,29.94661,1.67587,7.5317,29.69624,1.71974,7.46078,29.13122,1.91349,7.45715,29.14708,1.88675,7.48412,29.12956,1.90353,7.47963,29.14784,1.88069,7.55235,29.39051,1.76094,7.51756,29.54096,1.72341,7.54671,29.54239,1.73045,7.5213,29.39257,1.75996,7.67446,29.23249,2.49208,7.62345,29.22245,2.65825,7.56941,29.21345,2.61806,7.64244,29.20889,2.42052,7.67372,29.2761,2.43339,7.68466,29.25862,2.51136,7.63637,29.24391,2.66858,7.49317,29.24641,2.79584,7.50481,29.22566,2.75925,7.4805,29.23602,2.7821,7.48515,29.2341,2.77994,7.45585,29.33824,2.50431,7.43631,29.31952,2.59683,7.41181,29.35575,2.534,7.04609,29.29213,1.93175,7.16416,29.37168,1.88407,7.09241,29.29786,1.91752,7.41575,29.29869,2.65871,7.46177,29.27876,2.6414,7.36136,29.37311,2.55782,6.98965,29.25017,2.03586,7.00875,29.28157,1.94067,7.04345,29.27847,1.95093,7.3084,29.45432,1.82108,7.24878,29.47063,1.83686,7.335,29.59057,1.77778,7.74905,29.32338,2.32628,7.70089,29.25535,2.3409,7.74767,29.31165,2.29935,7.79083,29.83994,2.03719,7.80227,29.67322,2.20357,7.81255,29.65853,2.17127,7.81527,29.86937,2.10765,7.71714,29.59099,1.93203,7.72944,29.80106,1.91839,7.72715,29.5964,1.95552,7.74065,29.31001,2.2733,7.7414,29.603,2.00472,7.74378,29.50592,2.06001,7.74952,29.61289,2.01668};
			return value;
		}
		private double[] getlradius_Coord_7_14_point_2()
		{
			double[] value = {7.8501,33.93281,.06005,7.87933,34.64914,-.35318,7.98042,34.00281,.14777,7.62556,31.36747,1.17068,7.60058,31.37591,1.16818,7.6867,32.21332,.82795,7.7868,31.38458,1.25679,7.99089,32.33359,.98151,7.90597,31.42538,1.37509,7.82142,32.25788,.90899,7.66216,35.40354,-.84195,7.63798,35.52862,-.96878,7.66848,35.51855,-.99217,7.6174,36.00715,-1.07624,7.58863,35.8376,-1.03809,7.57595,35.84926,-1.02637,7.61655,35.8136,-1.0614,7.65846,35.96892,-1.14381,7.58156,35.45247,-.79625,7.59406,35.57076,-.89448,7.60657,35.56075,-.90678,7.52081,35.61256,-.86263,7.5481,35.73728,-.97352,7.54291,35.59805,-.8816,7.52992,35.75877,-.95478,7.80043,34.99104,-.60423,7.79748,35.39783,-.87316,7.81482,35.39708,-.87287,7.82457,35.50461,-.95645,7.8404,35.50623,-.94989,8.17277,36.52177,-1.38974,8.15727,36.5101,-1.37179,8.00973,36.46313,-1.50242,8.00559,36.44501,-1.46646,8.06463,36.81964,-.92803,8.05858,36.78897,-.93115,8.19523,36.74855,-1.01081,8.20483,36.76748,-1.01536,8.20824,36.91568,-1.12441,8.06292,36.93488,-.99906,8.22411,36.90809,-1.10894,8.0524,36.93698,-1.02628,8.03266,36.69625,-1.54817,8.1899,36.7347,-1.46385,8.04279,36.64363,-1.57685,8.21936,36.69456,-1.46832,8.07532,36.75877,-1.30845,7.99355,36.7543,-1.30388,8.07774,36.76954,-1.28949,7.72635,35.38723,-.85701,7.75714,35.00477,-.5957,7.60097,35.31856,-.71015,7.52147,35.50835,-.73382,7.89914,36.87939,-1.09179,8.0226,36.90469,-1.09912,7.99042,36.80314,-1.20279,7.93098,36.79965,-1.21142,7.96495,36.76924,-1.2683,7.98047,36.75182,-1.32579,7.91794,36.74571,-1.32479,7.91899,36.75646,-1.29113,7.93587,36.76659,-1.27476,7.98663,36.76951,-1.27548,7.90968,36.75048,-1.31341,7.94493,36.76807,-1.2712,8.15585,36.88363,-1.15549,8.01574,36.71049,-1.49989,7.80874,36.69224,-1.53647,7.85034,36.71795,-1.48747,8.08146,36.34056,-1.15093,8.09422,36.42375,-1.2763,8.13338,36.4598,-1.21632,8.06292,36.314,-1.21242,8.11448,36.46645,-1.31521,8.24159,36.63123,-1.17885,8.16416,36.51027,-1.24064,8.22626,36.57549,-1.27265,8.14701,36.55218,-1.17415,8.29027,36.75463,-1.20585,8.27655,36.67086,-1.19529,8.28193,36.68484,-1.3223,8.25483,36.60791,-1.30246,8.07934,36.89338,-.95215,8.21828,36.84672,-1.05344,7.79323,36.56297,-.99121,7.93778,36.47747,-.95105,7.90808,36.6016,-.94977,7.80924,36.45411,-.96221,7.59959,36.57294,-1.24369,7.65171,36.49906,-1.25234,7.67157,36.5561,-1.11101,7.62732,36.64818,-1.10671,8.04916,36.2584,-1.18484,8.00477,35.96906,-1.031,7.91715,35.91709,-1.11921,7.80123,35.91426,-1.1793,7.70675,35.95003,-1.16511,7.73522,36.22695,-1.22451,7.6874,36.33641,-1.03675,7.58909,36.06818,-1.00132};
			return value;
		}
		private double[] getlradius_Coord_7_14_point_3()
		{
			double[] value = {7.63342,36.13115,-.87416,7.76104,35.50192,-.98422,7.69637,35.74331,-1.16333,7.6687,35.74501,-1.14457,7.62856,35.79985,-1.07575,7.65629,35.75254,-1.13065,7.49773,35.63407,-.8113,7.50645,35.67802,-.75342,7.51097,35.55282,-.67479,7.52787,35.92611,-.9161,7.6155,36.01812,-.79014,7.54177,35.88711,-.98564,7.80351,35.73907,-1.15694,7.85085,35.64977,-1.06212,7.7902,35.64289,-1.11948,7.84962,35.74105,-1.1251,7.74434,33.92194,-.02588,7.78075,34.64534,-.38638,8.01531,34.78298,-.15061,7.99744,34.07341,.25521,7.99959,34.02759,.1833,7.95971,34.71365,-.24341,7.8667,34.99796,-.55863,7.65432,35.29297,-.74579,7.97277,35.0468,-.48859,7.97334,35.21106,-.30845,7.95662,34.85491,-.07343,8.01597,35.11942,-.3856,7.56663,35.1729,-.3781,7.58602,34.80328,-.14742,7.62301,35.22458,-.3015,7.62402,34.85888,-.07218,7.63801,35.06306,-.54586,7.65737,34.71661,-.35832,7.57102,35.09944,-.45924,7.60748,34.75447,-.24443,7.86151,33.21369,.44303,7.73245,33.15739,.30786,7.97035,34.13335,.35115,7.97349,33.37874,.74368,8.03439,33.34969,.63662,7.74113,33.41267,.7764,7.86398,34.19755,.40962,7.74172,34.17258,.44381,7.88036,33.43049,.77248,7.6898,33.35131,.64821,7.62456,34.14269,.37175,7.64284,34.11681,.2391,7.69215,33.39745,.73977,7.33635,29.7673,1.808,7.26412,29.60237,1.82486,7.38416,29.7226,1.75499,7.3916,30.01102,1.76882,7.3109,29.79109,1.84736,6.9944,29.30912,1.94359,6.96404,29.32432,1.99248,7.03046,29.41797,1.94685,7.09016,29.38596,1.90135,7.62658,32.30656,.93446,7.62924,32.32719,.98564,7.68623,33.28122,.50914,7.62741,32.39873,1.10927,7.69635,32.44766,1.20289,7.49466,30.57584,2.09682,7.45725,30.54772,2.04656,7.4303,30.18628,2.20073,7.44344,30.21743,2.27532,7.213,29.71055,2.63421,7.1778,29.60257,2.50703,7.32667,29.92382,2.66148,7.41317,30.00281,2.60471,7.37922,29.98763,2.57773,7.40194,29.46461,2.91063,7.42711,29.67636,2.84353,7.3499,29.46672,2.89966,7.33096,29.70193,2.83854,7.20955,29.43675,2.75597,6.96111,29.31339,2.19763,6.96736,29.27361,2.17097,6.96427,29.26373,2.03584,6.95414,29.29005,2.01379,6.98003,29.28983,1.96228,7.1463,29.33186,2.09151,7.32382,29.35691,2.26299,7.22837,29.35338,2.30123,7.26323,29.32169,2.09775,7.38874,29.2442,2.03505,7.25476,29.28167,1.93492,7.33117,29.25623,1.94377,7.30962,29.3068,2.08426,7.56238,29.27157,2.45213,7.62509,29.19968,2.41755,7.37756,29.30589,2.68165,7.42095,29.25725,2.82488,7.29658,29.32405,2.72719,7.71841,29.97414,1.83706,7.67505,29.95232,1.78351,7.70484,30.27176,1.69611,7.67937,29.57062,1.83417,7.66747,29.77192,1.81926};
			return value;
		}
		private double[] getlradius_Coord_7_14_point_4()
		{
			double[] value = {7.614,29.39813,1.79001,7.60037,29.55371,1.75813,7.48514,30.59835,1.54832,7.50681,30.55285,1.52858,7.33561,29.26429,1.91482,7.25748,29.29238,1.9089,7.39421,29.30945,1.84512,7.26618,29.34514,1.87692,7.92232,31.45703,1.41053,8.00726,32.35099,1.0196,7.91862,31.51502,1.45057,7.98629,32.38501,1.05501,7.80843,31.59243,1.56381,7.90282,32.41198,1.1894,7.78703,32.45029,1.23317,7.64459,30.57331,2.1322,7.60598,30.25753,2.32457,7.47428,29.93163,2.65608,7.62394,29.89046,2.58308,7.48745,29.98375,2.61961,7.6837,29.31323,2.51742,7.71272,29.99122,2.32747,7.73245,30.19192,2.21554,7.61802,30.06198,2.44895,7.69709,29.51738,2.59367,7.69585,29.61519,2.51617,7.59943,29.5839,2.72636,7.63443,29.71575,2.66179,7.77223,29.51806,2.33574,7.73146,29.42278,2.45389,7.73818,29.38653,2.40772,7.74184,29.54652,2.39892,7.80539,30.414,1.94157,7.7812,30.12304,2.09551,7.78739,30.05318,2.04988,7.81808,30.6134,1.70791,7.72645,30.50628,1.59377,7.73096,29.37436,2.37192,7.67406,29.26645,2.40529,7.78864,30.00835,1.96642,7.79535,30.30944,1.8338,7.85357,30.68526,1.8087,7.60739,30.50396,1.54048,7.54733,30.54372,1.51592,7.60038,30.26457,1.63121,7.53427,30.28397,1.59544,7.82498,29.65103,2.12817,7.76099,29.92008,2.20495,7.75468,29.72454,2.30716,7.79376,29.62936,2.24076,7.76784,30.51937,2.02744,7.80218,30.77756,1.86319,7.547,29.63269,2.7935,7.57295,29.75558,2.70949,7.54285,29.41173,2.79239,7.65466,29.38154,2.65652,7.53787,30.10545,2.49456,8.02683,33.32287,.5914,7.38332,29.23371,1.91217,7.50661,29.23956,1.81189,7.48111,29.54504,1.73299,7.44794,29.41132,1.78981,7.72089,29.39775,2.03749,7.72861,29.2898,2.13996,7.59481,29.92373,1.71489,7.33167,29.36022,2.59178,7.19907,29.35175,2.56012,7.44742,29.3419,2.45373,7.52498,29.30667,2.44231,7.51156,29.29366,2.3798,7.27537,29.37361,2.50633,7.40074,29.36002,2.46526,7.32003,29.37565,2.48172,7.55189,29.2606,2.37483,7.60628,29.17611,2.33466,7.09866,29.28577,1.93871,7.2026,29.2891,1.93349,7.30746,29.46331,2.87432,7.25605,29.69496,2.7992,7.38747,29.35798,2.90515,7.44859,29.99973,2.61842,7.22634,29.63242,2.22505,7.10572,29.51329,2.31686,7.26258,29.74046,2.42618,7.37407,30.05566,1.912,7.32927,29.84379,1.99698,7.45011,30.67826,1.64832,7.54611,31.45272,1.32382,7.60885,31.56099,1.535,7.55745,31.48653,1.42793,7.69926,33.22227,.41069,7.15291,29.54672,1.92452,7.18914,29.48693,1.85265,7.20291,29.30102,1.9084,7.67308,34.03664,.14206,7.97377,35.41751,-.73613,7.88457,35.3789,-.85252,7.69552,33.98511,.06066,7.85007,34.90196,-.00868,7.74145,34.89888,-.01658};
			return value;
		}
		private double[] getlradius_Coord_7_14_point_5()
		{
			double[] value = {7.8639,35.74226,-1.11385,7.89805,35.74672,-1.0833,7.51392,35.80058,-.91249,7.50547,35.84767,-.85136,7.60438,35.91927,-.7344,7.62701,35.53581,-.95329,7.67781,36.2722,-1.14224,7.60335,36.73241,-1.13538,7.60185,36.70867,-1.12165,7.72951,36.79921,-.97157,7.74148,36.82639,-.97842,7.89314,36.90388,-.98292,7.89658,36.86434,-.92356,8.21162,36.79299,-1.02587,7.96544,36.58904,-.98386,8.20815,36.82313,-1.2608,8.25371,36.78593,-1.34818,8.20551,36.78502,-1.33952,8.26407,36.84579,-1.25625,7.71446,36.70974,-1.47815,7.78484,36.72515,-1.43754,8.26218,36.64704,-1.18396,7.8656,35.65478,-1.05437,8.0044,33.29852,.55447,7.71797,33.93358,-.02074,7.71227,33.1633,.31222,7.79335,29.62424,2.04516,7.74041,29.8065,1.9353,7.81378,29.52965,2.10633,7.80472,29.62812,2.06133,7.80435,29.43845,2.16074,7.82555,29.64063,2.10329,7.78283,29.49535,2.31058,7.00969,29.30049,1.92756,7.43099,29.28159,2.87032,7.45672,30.26245,2.33102,7.53142,30.58862,2.12876,7.48597,30.28474,2.35817,8.05028,36.30827,-1.07616,8.06432,36.36426,-1.10264,8.06757,36.28477,-1.1239,7.99711,36.37513,-.987,8.0096,36.43363,-1.0078,7.80955,36.39658,-.93737,7.69181,36.39131,-1.06601,7.93321,36.4184,-.93162,7.73967,36.28578,-1.2475,7.77889,36.62362,-.99275,7.6865,36.49658,-1.10137,7.72366,36.44951,-1.34174,7.67114,36.44514,-1.22359,7.73425,36.39922,-1.30674,8.05461,36.57426,-1.03959,8.08505,36.62755,-1.04097,8.11326,36.5035,-1.16084,7.98573,36.64703,-.98246,7.90236,36.66412,-.9407,7.57389,36.62094,-1.27767,7.60956,36.68111,-1.11217,7.58288,36.59392,-1.26133,7.90333,36.79874,-.90128,7.90128,36.82781,-.90733,7.73332,36.76478,-.96423,8.06688,36.85279,-.93324,7.67472,36.53775,-1.42691,7.68564,36.51244,-1.40661,8.01356,36.48735,-1.52548,7.81595,36.47291,-1.48856,7.8125,36.49498,-1.51304,8.24268,36.58702,-1.28618,8.18294,36.54302,-1.40847,7.48073,30.30707,1.60645,7.49979,30.11416,2.5008,7.43239,30.09123,2.46194,7.4646,30.10935,2.49,7.72664,29.46838,2.00698,7.8215,29.45125,2.19145,7.83277,29.5423,2.14266,7.83328,29.55604,2.16914,7.80311,29.60682,2.21522,7.82307,29.4683,2.21951,7.27217,29.83703,2.72443,7.27523,29.80857,2.52483,6.96754,29.35475,2.18421,7.04834,29.43076,2.36635,7.38114,29.22411,1.94114,6.98726,29.26281,2.165,7.12047,29.31994,2.35326,7.5987,29.14893,2.17018,7.57548,29.14914,2.17684,7.62669,29.17412,2.32118,7.51248,29.12957,2.03541,7.53579,29.12766,2.02506,7.36826,29.34278,2.24662,7.10044,29.32235,2.11014,7.18242,29.34396,2.32195,7.49782,29.2403,2.20363,7.46049,29.27511,2.2162,7.42445,29.20969,2.01749,7.5906,35.72256,-1.00542};
			return value;
		}
		private double[] getlradius_Coord_7_14_point_6()
		{
			double[] value = {7.6093,35.70899,-1.0293,7.63348,35.67865,-1.09299,7.6475,35.66436,-1.1061,7.70329,36.49289,-1.38389,7.82118,36.45853,-1.45038,7.74255,36.72869,-.96686,7.77482,36.87832,-1.05135,7.76306,36.87421,-1.0304,7.89344,36.90567,-1.00295,7.63014,36.80166,-1.18194,7.63593,36.75448,-1.35433,7.60148,36.72905,-1.34631,7.65404,36.81356,-1.19788,7.79957,36.64222,-1.56697,7.67783,36.66497,-1.48441,8.29711,36.82083,-1.2356,8.28806,36.75662,-1.34182,8.04709,36.80008,-1.22992,7.92892,36.74425,-1.33618,7.9877,36.7302,-1.40596,7.88342,36.72894,-1.40435,7.96509,36.74565,-1.3406,8.0372,36.74069,-1.37114,7.90406,36.79529,-1.22199,7.85396,36.76519,-1.27057,7.83453,36.74776,-1.33443,8.14459,36.73752,-1.42976,7.8196,36.85795,-1.11985,7.73816,36.80348,-1.22683,7.72571,36.75424,-1.34465,7.85084,36.73327,-1.37053,8.02317,36.56435,-1.56096,8.21786,36.62626,-1.43557,7.68328,36.32865,-1.16834,7.90318,36.77354,-.90381,7.57186,36.67324,-1.30145,7.80732,36.56167,-1.54796,7.66599,36.60239,-1.46411,7.97351,36.10121,-.84954,7.89421,36.15762,-.78596,7.77459,36.18204,-.79902,7.68405,35.64232,-1.12138,7.99702,35.76071,-.62027,7.86752,35.68972,-.4638,7.98507,35.61515,-.52339,7.87715,35.81905,-.54344,7.59722,35.74981,-.62857,7.7238,35.68458,-.4768,7.73045,35.79942,-.55655,7.59389,35.63188,-.5562,8.02311,35.78869,-.80741,7.97829,35.88069,-.71534,8.03567,35.68026,-.74542,7.73316,35.95696,-.66382,7.86537,35.95964,-.64525,7.9735,35.9802,-.78456,7.86353,36.05196,-.70486,7.74069,36.05788,-.7181,7.99555,35.69987,-.91137,7.99231,35.59051,-.84213,7.99203,35.81502,-.96632,7.88807,35.51396,-.93117,7.8907,35.63607,-1.02135,7.8488,35.25755,-.22154,7.73573,35.26722,-.24622,8.02913,35.51329,-.62012,7.23106,29.65639,1.87977,7.45958,30.73967,1.77125,7.50525,30.80183,1.91992,7.41349,30.4664,1.87572,7.41324,30.40528,1.77709,7.3772,30.08762,2.01203,7.35305,29.89135,2.11074,7.40004,30.02891,2.37534,7.37738,29.96436,2.2854,7.28632,29.7095,2.19606,7.25825,29.68341,2.06264,7.32233,29.88911,2.47671,7.30763,29.81139,2.36882,7.19829,29.59152,2.07905,7.03522,29.4572,2.13515,7.58865,29.74081,1.74461,7.66801,29.25077,1.95778,7.53676,29.22899,1.81562,7.57714,29.22572,1.83747,7.4363,30.33386,1.65669,7.44207,29.9501,1.6969,7.66889,30.83222,1.99324,7.47617,29.44759,2.87028,7.71935,29.80168,2.41849};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlulna_Geo_6_19_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,8,9,6,-1,10,11,12,-1,13,14,11,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,21,24,22,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,39,42,40,-1,43,44,45,-1,46,47,48,-1,45,49,43,-1,50,51,52,-1,53,54,55,-1,54,56,57,-1,54,53,56,-1,58,59,60,-1,54,61,55,-1,61,54,62,-1,54,63,62,-1,64,65,66,-1,67,68,69,-1,67,70,68,-1,71,72,73,-1,71,74,72,-1,75,76,77,-1,78,79,80,-1,78,81,79,-1,4,3,82,-1,83,84,85,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,97,99,98,-1,100,99,101,-1,101,102,100,-1,103,104,105,-1,105,106,103,-1,107,108,109,-1,109,110,107,-1,111,112,113,-1,114,115,116,-1,116,117,114,-1,118,119,120,-1,118,121,119,-1,122,116,115,-1,25,123,124,-1,124,125,25,-1,126,127,128,-1,129,130,131,-1,34,132,133,-1,34,33,132,-1,134,135,66,-1,136,137,138,-1,139,140,141,-1,141,142,139,-1,143,144,145,-1,143,146,144,-1,147,148,62,-1,147,146,148,-1,41,149,150,-1,41,151,149,-1,35,152,153,-1,153,33,35,-1,33,154,132,-1,33,155,154,-1,156,157,77,-1,158,159,160,-1,160,76,158,-1,161,162,163,-1,164,165,166,-1,167,168,169,-1,143,148,146,-1,59,58,170,-1,170,58,171,-1,171,74,170,-1,172,173,174,-1,172,175,173,-1,176,80,177,-1,81,178,179,-1,81,78,178,-1,180,181,182,-1,182,178,180,-1,183,184,185,-1,186,187,188,-1,157,156,189,-1,131,190,191,-1,131,192,190,-1,193,194,195,-1,195,196,193,-1,197,125,124,-1,197,198,125,-1,199,200,201,-1,199,202,200,-1,203,204,205,-1,206,207,208,-1,209,210,211,-1,209,212,210,-1,213,214,215,-1,216,217,218,-1,219,220,221,-1,220,222,221,-1,223,224,225,-1,223,64,224,-1,36,38,226,-1,227,41,150,-1,227,39,41,-1,228,229,82,-1,230,37,36,-1,230,5,37,-1,231,232,233,-1,234,235,236,-1,237,238,239,-1,240,241,235,-1,242,67,243,-1,244,245,246,-1,244,247,245,-1,248,249,143,-1,249,250,143,-1,251,207,252,-1,207,253,252,-1,254,255,154,-1,254,256,255,-1,75,177,76,-1,46,257,258,-1,202,259,260,-1,202,199,259,-1,140,216,261,-1,216,262,261,-1,263,264,265,-1,263,266,264,-1,244,267,268,-1,244,246,267,-1,9,269,270,-1,9,8,269,-1,69,68,271,-1,224,272,32,-1,272,30,32,-1,273,274,275,-1,273,276,274,-1,277,278,279,-1,279,280,277,-1,281,282,283,-1,282,284,283,-1,250,285,286,-1,250,249,285,-1,191,129,131,-1,191,287,129,-1,288,289,290,-1,289,291,290,-1,292,293,294,-1,293,295,294,-1,296,297,298,-1,296,299,297,-1,300,301,302,-1,300,14,301,-1,303,56,128,-1,56,53,128,-1,213,304,305,-1,213,306,304,-1,307,308,309,-1,308,310,309,-1,311,312,313,-1,314,315,316,-1,314,317,315,-1,318,319,320,-1,318,321,319,-1,322,20,323,-1,322,15,20,-1,324,325,326,-1,325,91,326,-1,325,92,91,-1,95,94,327,-1,328,329,330,-1,328,331,329,-1,332,18,333,-1,18,17,333,-1,334,335,336,-1,335,337,336,-1,2,338,0,-1,339,340,341,-1,342,343,109,-1,344,273,345,-1,346,347,348,-1,349,350,351,-1,349,352,350,-1,353,354,355,-1,355,356,353,-1,160,357,358,-1,160,159,357,-1,359,360,361,-1,360,299,361,-1,204,203,294,-1,203,362,294,-1,202,260,363,-1,363,205,202,-1,52,175,261,-1,175,172,261,-1,302,209,364,-1,209,365,364,-1,228,42,366,-1,228,40,42,-1,127,126,367,-1,368,276,369,-1,370,180,186,-1,370,371,180,-1,293,292,372,-1,372,373,293,-1,374,375,344,-1,344,345,374,-1,376,110,86,-1,376,107,110,-1,377,378,379,-1,380,381,382,-1,380,383,381,-1,384,385,386,-1,384,387,385,-1,388,84,389,-1,265,390,263,-1,320,23,318,-1,320,21,23,-1,391,392,393,-1,392,394,393,-1,22,24,395,-1,24,396,395,-1,351,397,349,-1,351,398,397,-1,399,400,401,-1,399,402,400,-1,403,402,399,-1,403,404,402,-1,405,406,407,-1,405,408,406,-1,310,409,309,-1,310,410,409,-1,411,404,403,-1,411,16,404,-1,411,412,413,-1,414,415,416,-1};
			return value;
		}
		private int[] getlulna_Geo_6_19_coordIndex_2()
		{
			int[] value = {415,417,416,-1,418,419,420,-1,418,421,419,-1,336,337,422,-1,423,424,425,-1,334,426,427,-1,334,336,426,-1,426,428,429,-1,429,427,426,-1,430,431,432,-1,430,433,431,-1,434,435,436,-1,435,437,436,-1,386,385,438,-1,112,439,440,-1,112,114,439,-1,340,441,442,-1,441,443,442,-1,444,445,446,-1,447,97,96,-1,447,448,97,-1,350,299,360,-1,350,297,299,-1,24,449,396,-1,24,450,449,-1,450,451,449,-1,450,452,451,-1,241,453,235,-1,241,454,453,-1,70,455,456,-1,243,255,256,-1,243,67,255,-1,254,457,198,-1,252,458,362,-1,252,253,458,-1,459,460,354,-1,459,461,460,-1,462,134,463,-1,464,79,51,-1,465,466,157,-1,157,189,465,-1,467,468,469,-1,467,306,468,-1,214,470,215,-1,214,471,470,-1,61,62,148,-1,47,472,473,-1,473,183,47,-1,221,474,475,-1,221,222,474,-1,258,257,476,-1,477,219,478,-1,477,479,219,-1,201,200,357,-1,200,295,357,-1,78,80,176,-1,176,480,78,-1,481,482,483,-1,482,484,483,-1,482,485,484,-1,482,195,485,-1,482,486,196,-1,196,195,482,-1,487,488,278,-1,489,126,55,-1,490,460,461,-1,364,469,491,-1,492,493,208,-1,208,494,492,-1,493,13,495,-1,493,492,13,-1,168,496,169,-1,168,355,496,-1,150,149,460,-1,149,496,460,-1,151,5,497,-1,151,3,5,-1,238,498,239,-1,238,499,498,-1,452,123,451,-1,452,454,123,-1,86,110,89,-1,500,501,502,-1,500,503,501,-1,504,505,503,-1,329,331,506,-1,506,507,329,-1,508,439,379,-1,379,378,508,-1,509,510,511,-1,511,440,509,-1,512,513,514,-1,514,515,512,-1,389,84,83,-1,93,0,338,-1,516,517,518,-1,519,520,521,-1,520,522,521,-1,415,523,417,-1,415,332,523,-1,420,425,524,-1,425,424,524,-1,418,420,525,-1,420,524,525,-1,526,419,421,-1,527,528,337,-1,527,529,528,-1,413,16,411,-1,413,17,16,-1,309,418,525,-1,309,409,418,-1,529,406,317,-1,529,527,406,-1,408,317,406,-1,408,315,317,-1,308,307,399,-1,307,403,399,-1,530,321,531,-1,530,319,321,-1,532,533,534,-1,533,535,534,-1,223,68,536,-1,537,538,539,-1,538,280,539,-1,540,541,542,-1,541,330,542,-1,108,543,342,-1,342,109,108,-1,543,117,116,-1,427,544,521,-1,427,429,544,-1,88,545,104,-1,88,87,545,-1,379,117,546,-1,546,547,379,-1,106,100,102,-1,102,103,106,-1,548,549,381,-1,381,383,548,-1,379,550,377,-1,379,547,550,-1,549,551,552,-1,549,548,551,-1,71,170,74,-1,71,145,170,-1,294,295,204,-1,295,200,204,-1,130,553,192,-1,554,372,555,-1,372,292,555,-1,368,274,276,-1,368,556,274,-1,57,479,477,-1,477,63,57,-1,490,470,557,-1,490,461,470,-1,558,158,464,-1,464,51,558,-1,158,76,177,-1,177,464,158,-1,357,159,201,-1,159,559,201,-1,560,561,293,-1,560,156,561,-1,215,306,213,-1,562,350,360,-1,563,564,565,-1,566,389,567,-1,566,388,389,-1,507,568,329,-1,118,120,90,-1,91,569,570,-1,91,120,569,-1,334,521,522,-1,334,427,521,-1,115,571,572,-1,115,111,571,-1,341,567,339,-1,341,566,567,-1,95,0,93,-1,573,512,574,-1,512,515,574,-1,91,570,326,-1,343,575,109,-1,343,327,575,-1,576,378,387,-1,576,508,378,-1,510,509,577,-1,577,578,510,-1,378,385,387,-1,317,314,416,-1,416,529,317,-1,579,320,319,-1,579,236,320,-1,237,239,580,-1,239,232,580,-1,581,408,405,-1,581,531,408,-1,582,583,312,-1,467,365,584,-1,532,534,585,-1,585,586,532,-1,212,302,301,-1,212,209,302,-1,14,587,11,-1,14,300,587,-1,297,401,298,-1,588,589,292,-1,292,294,588,-1,590,591,592,-1,590,593,591,-1,290,594,288,-1,290,595,594,-1,69,132,255,-1,132,154,255,-1,55,61,286,-1,61,250,286,-1,596,73,72,-1,205,363,211,-1,265,285,249,-1,597,279,598,-1,279,29,31,-1,31,598,279,-1,599,7,600,-1,7,6,600,-1,273,344,565,-1,344,601,565,-1,602,499,238,-1,602,603,499,-1,604,282,263,-1,282,266,263,-1,305,214,213,-1,305,218,214,-1,605,48,606,-1,160,358,77,-1,607,608,609,-1,608,610,609,-1,253,152,458,-1,253,611,152,-1,248,265,249,-1,248,390,265,-1,612,246,245,-1,563,613,614,-1,607,267,242,-1,267,615,242,-1,499,616,498,-1,617,618,234,-1,235,234,618,-1,618,240,235,-1,239,498,579,-1};
			return value;
		}
		private int[] getlulna_Geo_6_19_coordIndex_3()
		{
			int[] value = {369,276,564,-1,276,565,564,-1,619,229,620,-1,227,535,39,-1,535,533,39,-1,621,368,369,-1,55,6,489,-1,31,30,600,-1,600,286,31,-1,66,135,64,-1,220,219,622,-1,471,218,217,-1,471,214,218,-1,495,11,10,-1,495,13,11,-1,224,623,225,-1,224,32,623,-1,218,262,216,-1,218,624,262,-1,625,559,558,-1,182,179,178,-1,464,80,79,-1,464,177,80,-1,179,182,173,-1,173,175,179,-1,139,142,626,-1,626,627,139,-1,628,596,72,-1,72,629,628,-1,605,630,48,-1,630,631,48,-1,475,474,162,-1,162,632,475,-1,312,633,313,-1,312,634,633,-1,481,554,287,-1,255,67,69,-1,45,635,626,-1,626,142,45,-1,136,138,141,-1,138,142,141,-1,48,631,161,-1,160,77,76,-1,357,561,358,-1,192,636,637,-1,152,611,153,-1,638,291,639,-1,291,289,639,-1,277,280,538,-1,164,137,165,-1,621,238,237,-1,621,602,238,-1,36,580,230,-1,36,226,580,-1,640,219,641,-1,640,622,219,-1,144,60,59,-1,191,190,486,-1,625,558,642,-1,161,163,48,-1,131,130,192,-1,128,643,303,-1,644,641,219,-1,115,572,122,-1,106,105,645,-1,646,96,647,-1,96,98,647,-1,543,122,324,-1,543,116,122,-1,120,91,90,-1,424,423,634,-1,2,1,389,-1,340,442,341,-1,37,4,82,-1,368,38,648,-1,156,77,358,-1,358,561,156,-1,81,51,79,-1,52,51,81,-1,74,629,72,-1,74,171,629,-1,70,536,68,-1,147,478,60,-1,147,477,478,-1,171,649,650,-1,650,629,171,-1,219,479,651,-1,54,57,63,-1,644,219,651,-1,46,652,472,-1,472,47,46,-1,49,45,137,-1,45,138,137,-1,138,45,142,-1,46,653,652,-1,258,653,46,-1,40,3,41,-1,3,151,41,-1,640,654,622,-1,225,591,271,-1,588,362,594,-1,362,458,594,-1,362,588,294,-1,595,130,129,-1,595,290,130,-1,129,555,589,-1,589,595,129,-1,589,555,292,-1,17,20,15,-1,17,18,20,-1,451,25,27,-1,451,123,25,-1,415,18,332,-1,452,453,454,-1,252,362,203,-1,492,14,13,-1,492,301,14,-1,251,212,494,-1,251,210,212,-1,10,655,495,-1,10,28,655,-1,656,489,9,-1,489,6,9,-1,656,657,367,-1,657,658,367,-1,565,276,273,-1,5,4,37,-1,389,83,2,-1,148,250,61,-1,148,143,250,-1,659,242,615,-1,659,455,242,-1,660,456,661,-1,660,662,456,-1,269,663,275,-1,269,664,663,-1,274,657,270,-1,556,657,274,-1,665,666,620,-1,665,658,666,-1,367,665,127,-1,367,658,665,-1,667,668,669,-1,668,667,670,-1,210,252,203,-1,210,251,252,-1,492,212,301,-1,492,494,212,-1,449,27,671,-1,449,451,27,-1,322,402,404,-1,672,402,322,-1,673,674,400,-1,675,674,673,-1,676,452,450,-1,676,453,452,-1,677,678,679,-1,677,680,678,-1,415,19,18,-1,415,414,19,-1,68,225,271,-1,225,68,223,-1,638,553,291,-1,638,681,553,-1,487,590,592,-1,487,682,590,-1,29,623,32,-1,488,623,29,-1,130,291,553,-1,290,291,130,-1,152,289,288,-1,35,289,152,-1,34,593,639,-1,34,133,593,-1,152,594,458,-1,288,594,152,-1,683,654,640,-1,683,586,654,-1,532,684,533,-1,684,532,685,-1,686,43,687,-1,686,44,43,-1,653,476,688,-1,653,258,476,-1,472,689,690,-1,689,472,652,-1,49,164,691,-1,49,137,164,-1,651,57,56,-1,651,479,57,-1,650,628,629,-1,650,630,628,-1,477,62,63,-1,62,477,147,-1,621,38,368,-1,38,621,226,-1,619,38,37,-1,648,38,619,-1,388,573,574,-1,566,573,388,-1,692,339,567,-1,339,692,569,-1,1,567,389,-1,567,1,692,-1,97,101,99,-1,97,448,101,-1,693,446,694,-1,447,446,693,-1,445,695,696,-1,445,444,695,-1,697,646,647,-1,698,646,697,-1,699,98,700,-1,699,647,98,-1,694,701,693,-1,694,552,701,-1,696,381,549,-1,381,696,695,-1,88,551,86,-1,88,702,551,-1,548,703,376,-1,548,383,703,-1,704,705,706,-1,380,705,704,-1,706,707,708,-1,705,707,706,-1,709,710,711,-1,710,709,545,-1,712,713,714,-1,712,715,713,-1,547,716,550,-1,717,716,547,-1,575,110,109,-1,110,575,89,-1,502,718,719,-1,502,501,718,-1,503,720,721,-1,503,505,720,-1,722,723,724,-1,504,723,722,-1,641,303,725,-1,644,303,641,-1,50,558,51,-1,558,50,642,-1,625,624,726,-1,625,642,624,-1,640,725,683,-1,641,725,640,-1,226,237,580,-1,226,621,237,-1};
			return value;
		}
		private int[] getlulna_Geo_6_19_coordIndex_4()
		{
			int[] value = {727,728,729,-1,727,730,728,-1,201,625,199,-1,201,559,625,-1,682,636,681,-1,636,682,277,-1,75,157,731,-1,75,77,157,-1,689,687,691,-1,687,689,688,-1,172,136,141,-1,172,174,136,-1,732,45,44,-1,45,732,635,-1,628,733,596,-1,734,733,628,-1,338,727,729,-1,338,633,727,-1,735,162,474,-1,162,735,163,-1,475,650,649,-1,650,475,632,-1,605,736,734,-1,605,606,736,-1,473,184,183,-1,371,184,473,-1,283,737,281,-1,737,283,738,-1,262,642,50,-1,624,642,262,-1,558,159,158,-1,559,159,558,-1,488,279,278,-1,279,488,29,-1,177,731,176,-1,177,75,731,-1,537,189,739,-1,537,740,189,-1,483,373,372,-1,483,484,373,-1,373,485,741,-1,484,485,373,-1,493,655,742,-1,495,655,493,-1,198,256,254,-1,256,198,197,-1,622,743,220,-1,622,744,743,-1,685,745,684,-1,745,685,746,-1,127,643,128,-1,127,747,643,-1,456,463,65,-1,456,662,463,-1,748,374,345,-1,374,748,462,-1,668,749,664,-1,749,668,670,-1,134,750,135,-1,134,751,750,-1,656,270,657,-1,9,270,656,-1,564,621,369,-1,602,621,564,-1,665,747,127,-1,665,752,747,-1,616,234,498,-1,234,616,617,-1,609,267,607,-1,609,268,267,-1,564,603,602,-1,603,564,563,-1,245,613,612,-1,245,614,613,-1,603,616,499,-1,616,603,753,-1,71,143,145,-1,71,248,143,-1,284,734,736,-1,734,284,733,-1,754,755,188,-1,755,754,466,-1,264,597,265,-1,264,539,597,-1,608,242,243,-1,242,608,607,-1,612,601,756,-1,612,613,601,-1,600,272,599,-1,600,30,272,-1,739,156,560,-1,739,189,156,-1,265,598,285,-1,597,598,265,-1,604,390,73,-1,263,390,604,-1,259,305,304,-1,305,259,726,-1,370,184,371,-1,370,738,184,-1,370,188,755,-1,370,186,188,-1,757,163,735,-1,163,757,257,-1,594,589,588,-1,594,595,589,-1,587,12,11,-1,587,361,12,-1,272,750,599,-1,750,272,135,-1,725,643,746,-1,643,725,303,-1,758,535,557,-1,758,534,535,-1,308,349,310,-1,308,352,349,-1,517,582,759,-1,517,516,582,-1,760,761,412,-1,761,760,583,-1,407,762,405,-1,762,407,763,-1,764,765,766,-1,765,764,767,-1,768,497,5,-1,497,768,769,-1,232,579,233,-1,232,239,579,-1,528,416,417,-1,528,529,416,-1,770,673,672,-1,673,770,395,-1,675,771,674,-1,771,675,671,-1,25,655,28,-1,125,655,25,-1,742,457,206,-1,742,198,457,-1,772,412,411,-1,772,760,412,-1,773,429,428,-1,773,384,429,-1,432,774,775,-1,774,432,431,-1,776,777,435,-1,776,778,777,-1,437,517,779,-1,437,780,517,-1,781,311,83,-1,781,759,311,-1,2,633,338,-1,2,313,633,-1,509,576,577,-1,509,508,576,-1,540,578,782,-1,540,510,578,-1,436,541,434,-1,783,541,436,-1,784,514,785,-1,515,514,784,-1,85,515,784,-1,85,574,515,-1,343,95,327,-1,343,570,95,-1,441,719,786,-1,441,119,719,-1,787,722,571,-1,787,720,722,-1,119,340,120,-1,119,441,340,-1,571,724,572,-1,724,571,722,-1,326,543,324,-1,543,326,342,-1,0,692,1,-1,692,0,95,-1,542,113,511,-1,113,542,568,-1,512,788,513,-1,512,443,788,-1,573,443,512,-1,573,442,443,-1,572,324,122,-1,325,324,572,-1,777,789,780,-1,777,790,789,-1,516,583,582,-1,583,516,761,-1,526,334,522,-1,335,334,526,-1,113,571,111,-1,787,571,113,-1,530,766,233,-1,530,764,766,-1,791,398,767,-1,398,791,397,-1,346,360,359,-1,346,562,360,-1,215,468,306,-1,468,215,459,-1,346,168,167,-1,346,348,168,-1,293,741,560,-1,741,293,373,-1,792,793,794,-1,792,347,793,-1,166,182,181,-1,173,182,166,-1,470,459,215,-1,461,459,470,-1,229,37,82,-1,229,619,37,-1,128,55,126,-1,128,53,55,-1,467,304,306,-1,467,584,304,-1,287,555,129,-1,287,554,555,-1,637,194,193,-1,194,637,739,-1,553,636,192,-1,553,681,636,-1,73,248,71,-1,390,248,73,-1,750,7,599,-1,750,669,7,-1,649,221,475,-1,649,795,221,-1,8,664,269,-1,668,664,8,-1,65,134,66,-1,65,463,134,-1,717,706,716,-1,717,704,706,-1,106,700,100,-1,106,707,700,-1,103,701,702,-1,103,102,701,-1,796,704,717,-1,704,796,703,-1,394,797,94,-1,797,394,710,-1,385,377,798,-1,385,378,377,-1,708,715,712,-1,708,645,715,-1,376,796,107,-1,376,703,796,-1,575,94,797,-1,575,327,94,-1};
			return value;
		}
		private int[] getlulna_Geo_6_19_coordIndex_5()
		{
			int[] value = {392,710,394,-1,392,711,710,-1,645,709,715,-1,645,105,709,-1,787,568,507,-1,113,568,787,-1,93,729,393,-1,729,93,338,-1,747,746,643,-1,746,747,745,-1,799,391,438,-1,391,799,392,-1,350,401,297,-1,401,350,352,-1,531,315,408,-1,531,321,315,-1,349,410,310,-1,349,397,410,-1,314,680,677,-1,314,316,680,-1,677,416,314,-1,414,416,677,-1,527,407,406,-1,407,527,800,-1,409,421,418,-1,409,763,421,-1,800,337,335,-1,800,527,337,-1,801,412,761,-1,413,412,801,-1,333,413,801,-1,333,17,413,-1,802,417,523,-1,528,417,802,-1,420,520,425,-1,420,419,520,-1,803,332,790,-1,332,803,523,-1,422,433,430,-1,422,802,433,-1,730,423,519,-1,423,730,727,-1,778,790,777,-1,803,790,778,-1,801,789,333,-1,801,518,789,-1,423,633,634,-1,423,727,633,-1,781,785,779,-1,781,784,785,-1,774,782,578,-1,774,776,782,-1,773,577,576,-1,773,775,577,-1,391,729,728,-1,729,391,393,-1,83,784,781,-1,83,85,784,-1,514,328,783,-1,514,513,328,-1,542,510,540,-1,542,511,510,-1,440,508,509,-1,439,508,440,-1,786,331,788,-1,786,506,331,-1,543,546,117,-1,546,543,108,-1,714,799,798,-1,714,713,799,-1,646,447,96,-1,698,447,646,-1,444,447,698,-1,446,447,444,-1,804,765,805,-1,765,804,769,-1,562,167,806,-1,562,346,167,-1,233,768,231,-1,233,766,768,-1,167,807,804,-1,169,807,167,-1,10,26,28,-1,12,26,10,-1,231,5,230,-1,231,768,5,-1,82,40,228,-1,82,3,40,-1,169,149,807,-1,149,169,496,-1,355,460,496,-1,355,354,460,-1,491,794,364,-1,491,792,794,-1,610,241,609,-1,454,241,610,-1,247,616,753,-1,247,617,616,-1,33,611,155,-1,611,33,153,-1,300,364,794,-1,302,364,300,-1,227,557,535,-1,227,490,557,-1,366,684,745,-1,366,42,684,-1,656,126,489,-1,367,126,656,-1,463,660,462,-1,463,662,660,-1,462,751,134,-1,462,667,751,-1,462,670,667,-1,462,749,670,-1,462,808,749,-1,462,748,808,-1,277,487,278,-1,277,682,487,-1,266,740,264,-1,809,740,266,-1,755,738,370,-1,737,738,755,-1,604,596,733,-1,596,604,73,-1,165,173,166,-1,165,174,173,-1,81,175,52,-1,175,81,179,-1,141,261,172,-1,261,141,140,-1,810,471,217,-1,758,471,810,-1,627,585,810,-1,585,627,811,-1,654,744,622,-1,744,654,811,-1,743,222,220,-1,743,812,222,-1,757,44,686,-1,757,732,44,-1,630,632,631,-1,632,630,650,-1,476,757,686,-1,476,257,757,-1,257,48,163,-1,48,257,46,-1,757,812,732,-1,757,735,812,-1,606,47,183,-1,606,48,47,-1,162,631,632,-1,162,161,631,-1,732,743,635,-1,812,743,732,-1,586,811,654,-1,811,586,585,-1,534,810,585,-1,810,534,758,-1,627,744,811,-1,627,626,744,-1,627,217,139,-1,627,810,217,-1,726,218,305,-1,726,624,218,-1,211,365,209,-1,211,363,365,-1,164,181,690,-1,164,166,181,-1,473,690,181,-1,690,473,472,-1,282,733,284,-1,604,733,282,-1,178,186,180,-1,178,187,186,-1,187,78,480,-1,187,178,78,-1,285,31,286,-1,285,598,31,-1,752,745,747,-1,752,366,745,-1,491,468,353,-1,469,468,491,-1,610,197,124,-1,610,608,197,-1,615,375,659,-1,615,756,375,-1,753,245,247,-1,753,614,245,-1,240,244,268,-1,618,244,240,-1,587,794,793,-1,587,300,794,-1,356,347,792,-1,348,347,356,-1,361,793,359,-1,361,587,793,-1,769,807,497,-1,769,804,807,-1,235,676,236,-1,235,453,676,-1,771,12,296,-1,26,12,771,-1,167,805,806,-1,805,167,804,-1,676,320,236,-1,320,676,21,-1,296,674,771,-1,298,674,296,-1,398,806,805,-1,398,351,806,-1,702,552,551,-1,702,701,552,-1,502,118,500,-1,502,121,118,-1,500,504,503,-1,500,723,504,-1,441,788,443,-1,788,441,786,-1,328,541,783,-1,328,330,541,-1,438,728,386,-1,728,438,391,-1,384,576,387,-1,384,773,576,-1,578,775,774,-1,577,775,578,-1,434,776,435,-1,782,776,434,-1,436,779,785,-1,779,436,437,-1,518,780,789,-1,518,517,780,-1,433,778,431,-1,433,803,778,-1,426,432,428,-1,426,430,432,-1,519,544,730,-1,519,521,544,-1,336,430,426,-1,336,422,430,-1,802,803,433,-1,802,523,803,-1,424,312,583,-1,424,634,312,-1,519,425,520,-1,425,519,423,-1,419,522,520,-1,419,526,522,-1,337,802,422,-1,337,528,802,-1};
			return value;
		}
		private int[] getlulna_Geo_6_19_coordIndex_6()
		{
			int[] value = {763,800,421,-1,763,407,800,-1,323,19,679,-1,20,19,323,-1,411,307,772,-1,403,307,411,-1,763,410,762,-1,763,409,410,-1,679,770,323,-1,679,678,770,-1,791,405,762,-1,791,581,405,-1,316,23,680,-1,318,23,316,-1,399,352,308,-1,401,352,399,-1,400,298,401,-1,400,674,298,-1,550,798,377,-1,714,798,550,-1,678,395,770,-1,22,395,678,-1,319,233,579,-1,530,233,319,-1,379,114,117,-1,379,439,114,-1,545,105,104,-1,105,545,709,-1,713,392,799,-1,392,713,711,-1,706,712,716,-1,708,712,706,-1,438,798,799,-1,385,798,438,-1,393,94,93,-1,94,393,394,-1,700,705,699,-1,700,707,705,-1,380,699,705,-1,380,382,699,-1,374,659,375,-1,661,659,374,-1,275,345,273,-1,663,345,275,-1,737,466,465,-1,466,737,755,-1,281,266,282,-1,809,266,281,-1,194,560,741,-1,194,739,560,-1,176,754,480,-1,731,754,176,-1,353,792,491,-1,353,356,792,-1,55,600,6,-1,55,286,600,-1,293,357,295,-1,293,561,357,-1,620,648,619,-1,620,666,648,-1,460,227,150,-1,490,227,460,-1,216,139,217,-1,139,216,140,-1,199,726,259,-1,199,625,726,-1,611,207,206,-1,611,253,207,-1,155,206,457,-1,155,611,206,-1,347,359,793,-1,347,346,359,-1,355,348,356,-1,348,355,168,-1,353,459,354,-1,353,468,459,-1,767,805,765,-1,805,767,398,-1,350,806,351,-1,562,806,350,-1,531,764,530,-1,531,581,764,-1,565,613,563,-1,565,601,613,-1,236,498,234,-1,498,236,579,-1,335,421,800,-1,335,526,421,-1,759,312,311,-1,312,759,582,-1,333,790,332,-1,790,333,789,-1,112,511,113,-1,440,511,112,-1,788,328,513,-1,788,331,328,-1,329,542,330,-1,568,542,329,-1,95,569,692,-1,95,570,569,-1,343,326,570,-1,326,343,342,-1,723,92,724,-1,92,723,500,-1,507,720,787,-1,720,507,721,-1,718,507,506,-1,507,718,721,-1,719,506,786,-1,719,718,506,-1,340,569,120,-1,339,569,340,-1,783,785,514,-1,783,436,785,-1,541,782,434,-1,782,541,540,-1,83,313,2,-1,83,311,313,-1,759,779,517,-1,781,779,759,-1,780,435,777,-1,437,435,780,-1,776,431,778,-1,776,774,431,-1,428,775,773,-1,775,428,432,-1,544,384,386,-1,384,544,429,-1,583,524,424,-1,760,524,583,-1,742,125,198,-1,742,655,125,-1,26,671,27,-1,671,26,771,-1,395,675,673,-1,675,395,396,-1,672,323,770,-1,672,322,323,-1,321,316,315,-1,316,321,318,-1,229,366,752,-1,366,229,228,-1,769,766,765,-1,768,766,769,-1,581,767,764,-1,767,581,791,-1,518,761,516,-1,518,801,761,-1,397,762,410,-1,791,762,397,-1,772,309,525,-1,772,307,309,-1,525,760,772,-1,525,524,760,-1,758,470,471,-1,758,557,470,-1,64,536,65,-1,223,536,64,-1,296,361,299,-1,12,361,296,-1,480,188,187,-1,188,480,754,-1,283,736,185,-1,283,284,736,-1,365,260,584,-1,260,365,363,-1,193,192,637,-1,193,190,192,-1,623,591,225,-1,623,592,591,-1,455,67,242,-1,455,70,67,-1,344,756,601,-1,344,375,756,-1,267,756,615,-1,267,612,756,-1,246,612,267,-1,539,279,597,-1,279,539,280,-1,740,539,264,-1,740,537,539,-1,261,50,52,-1,261,262,50,-1,304,260,259,-1,260,304,584,-1,271,132,69,-1,271,133,132,-1,618,247,244,-1,618,617,247,-1,603,614,753,-1,603,563,614,-1,241,268,609,-1,241,240,268,-1,232,230,580,-1,232,231,230,-1,497,149,151,-1,497,807,149,-1,368,666,556,-1,368,648,666,-1,751,669,750,-1,667,669,751,-1,663,748,345,-1,748,663,808,-1,462,661,374,-1,661,462,660,-1,70,65,536,-1,70,456,65,-1,683,746,685,-1,746,683,725,-1,644,56,303,-1,644,651,56,-1,221,478,219,-1,478,221,795,-1,467,364,365,-1,469,364,467,-1,494,207,251,-1,494,208,207,-1,203,211,210,-1,211,203,205,-1,200,205,204,-1,205,200,202,-1,493,206,208,-1,493,742,206,-1,197,243,256,-1,197,608,243,-1,454,124,123,-1,124,454,610,-1,741,195,194,-1,485,195,741,-1,196,190,193,-1,486,190,196,-1,481,372,554,-1,481,483,372,-1,191,481,287,-1,486,481,191,-1,482,481,486,-1,739,538,537,-1,637,538,739,-1,466,731,157,-1,731,466,754,-1,740,465,189,-1,740,809,465,-1,465,281,737,-1,465,809,281,-1,738,185,184,-1,738,283,185,-1,185,606,183,-1,185,736,606,-1,181,371,473,-1,180,371,181,-1};
			return value;
		}
		private int[] getlulna_Geo_6_19_coordIndex_7()
		{
			int[] value = {812,474,222,-1,812,735,474,-1,145,59,170,-1,145,144,59,-1,635,744,626,-1,744,635,743,-1,49,687,43,-1,49,691,687,-1,652,688,689,-1,688,652,653,-1,457,154,155,-1,457,254,154,-1,386,730,544,-1,730,386,728,-1,144,147,60,-1,146,147,144,-1,137,174,165,-1,136,174,137,-1,637,277,538,-1,637,636,277,-1,638,593,590,-1,638,639,593,-1,724,325,572,-1,724,92,325,-1,720,504,722,-1,505,504,720,-1,501,721,718,-1,501,503,721,-1,119,502,719,-1,121,502,119,-1,500,90,92,-1,500,118,90,-1,112,115,114,-1,111,115,112,-1,546,717,547,-1,546,796,717,-1,108,796,546,-1,107,796,108,-1,716,714,550,-1,716,712,714,-1,715,711,713,-1,711,715,709,-1,710,87,797,-1,710,545,87,-1,707,645,708,-1,707,106,645,-1,703,380,704,-1,383,380,703,-1,86,548,376,-1,551,548,86,-1,104,702,88,-1,103,702,104,-1,381,697,382,-1,381,695,697,-1,696,552,694,-1,549,552,696,-1,102,693,701,-1,102,101,693,-1,98,100,700,-1,100,98,99,-1,382,647,699,-1,697,647,382,-1,695,698,697,-1,444,698,695,-1,694,445,696,-1,446,445,694,-1,448,693,101,-1,448,447,693,-1,797,89,575,-1,89,797,87,-1,566,442,573,-1,341,442,566,-1,84,574,85,-1,388,574,84,-1,64,272,224,-1,272,64,135,-1,58,478,795,-1,478,58,60,-1,171,795,649,-1,58,795,171,-1,734,630,605,-1,628,630,734,-1,690,691,164,-1,691,690,689,-1,688,686,687,-1,688,476,686,-1,42,533,684,-1,533,42,39,-1,586,685,532,-1,685,586,683,-1,133,591,593,-1,271,591,133,-1,289,34,639,-1,289,35,34,-1,488,592,623,-1,488,487,592,-1,590,681,638,-1,590,682,681,-1,679,414,677,-1,19,414,679,-1,680,22,678,-1,680,23,22,-1,450,21,676,-1,24,21,450,-1,672,400,402,-1,673,400,672,-1,404,15,322,-1,404,16,15,-1,396,671,675,-1,396,449,671,-1,7,668,8,-1,7,669,668,-1,752,620,229,-1,752,665,620,-1,658,556,666,-1,658,657,556,-1,270,275,274,-1,270,269,275,-1,664,808,663,-1,664,749,808,-1,661,455,659,-1,661,456,455,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlulna_Coord_7_19_point_1()
		{
			double[] value = {7.26886,28.80085,1.58758,7.20223,28.82013,1.62413,7.17691,28.88063,1.58038,7.45911,35.74795,-1.56284,7.49902,35.69728,-1.44191,7.52169,35.39752,-1.29265,7.61287,36.63358,-1.43733,7.61358,36.62041,-1.39734,7.63936,36.54582,-1.40254,7.63529,36.54186,-1.45471,6.95369,35.50402,-1.00521,6.93685,35.48965,-1.03407,7.03028,34.9728,-.87925,6.8598,35.90515,-1.08005,6.85015,35.89551,-1.10943,7.11982,30.23294,1.20452,7.09781,30.22263,1.17763,7.13258,29.78818,1.44716,7.18644,29.81952,1.51082,7.20827,30.26586,1.28617,7.17893,30.25297,1.25304,7.47003,34.03886,-.288,7.40206,32.9008,.18751,7.42355,32.90489,.19804,7.44706,34.03686,-.29393,7.10882,35.59054,-.9022,7.08653,34.99451,-.82293,7.15735,35.0039,-.79953,7.01212,35.54259,-.95089,7.34704,36.80448,-1.12359,7.449,36.75909,-1.24885,7.43539,36.76414,-1.26239,7.36898,36.79034,-1.10786,6.92781,36.94268,-.89291,6.91772,37.0738,-.87686,6.87985,36.9974,-.88713,7.53969,35.86791,-1.34025,7.52389,35.87311,-1.38952,7.56782,36.1238,-1.38302,7.38615,36.21958,-1.85778,7.42852,36.02297,-1.73579,7.40709,36.00475,-1.76486,7.41191,36.23449,-1.83154,7.11213,37.3667,-2.01908,7.1253,37.36174,-2.01945,7.1063,37.19537,-2.13743,7.3587,37.59269,-1.64592,7.35673,37.59268,-1.63203,7.46968,37.53947,-1.62621,7.06271,37.39254,-2.02372,6.85871,36.91591,-1.8262,6.85213,36.91973,-1.81391,6.8527,37.13522,-1.92152,7.5308,36.77643,-1.65076,7.53309,36.78951,-1.6259,7.56425,36.67545,-1.4984,7.56644,36.8742,-1.79873,7.57488,36.87841,-1.7927,7.73239,37.28109,-1.76762,7.72343,37.20597,-1.80414,7.72295,37.15704,-1.86463,7.53376,36.80205,-1.59888,7.60626,36.89682,-1.76945,7.59004,36.88726,-1.78031,7.37989,36.67205,-1.12849,7.40305,36.60097,-1.13077,7.4141,36.63358,-1.1702,7.34998,36.62961,-.95559,7.22653,36.84642,-.93127,7.16236,36.87525,-.90649,7.3628,36.65463,-.97036,7.60317,37.12911,-1.66393,7.61697,37.28131,-1.62365,7.52729,37.15728,-1.62328,7.67634,37.26423,-1.68035,6.98969,36.98206,-1.66354,6.95936,36.91666,-1.6999,7.05033,36.95092,-1.59517,6.85872,37.22327,-1.82023,6.86966,36.99685,-1.76515,6.89762,37.02605,-1.73899,6.83974,37.20947,-1.86217,7.47599,35.80601,-1.48905,7.10977,28.9291,1.62876,7.13148,28.85224,1.65644,7.11919,28.85739,1.66332,7.38837,28.60982,1.72475,7.38904,28.6388,1.6604,7.41522,28.61376,1.67396,7.36441,28.64851,1.71171,7.30469,28.83417,1.76179,7.30715,28.79483,1.72228,7.3539,28.84605,1.80728,7.29475,28.7845,1.57252,7.3363,28.71936,1.6109,7.28844,28.77314,1.62956,7.47649,28.60686,1.7367,7.47274,28.59881,1.72514,7.49724,28.61359,1.73794,7.4882,28.60392,1.7138};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_2()
		{
			double[] value = {7.49862,28.60838,1.70434,7.47079,28.59576,1.7045,7.47092,28.59791,1.69117,7.4704,28.60229,1.68054,7.46855,28.61237,1.66424,7.52714,28.63216,1.67098,7.52184,28.62215,1.68961,7.38429,28.67362,1.80403,7.38084,28.69399,1.80456,7.34304,28.6729,1.73278,7.35484,28.65229,1.73165,7.47365,28.89674,1.96753,7.48701,28.9087,1.98605,7.40608,28.93285,2.04433,7.51315,28.86095,1.87943,7.49241,28.85819,1.87888,7.44039,28.76932,1.81316,7.4446,28.76059,1.80881,7.30155,28.88388,1.81171,7.22514,28.88159,1.80395,7.24607,28.85004,1.76571,7.29565,28.89031,1.8229,7.4273,28.81345,1.81968,7.15978,35.60284,-.89865,7.15179,35.95536,-.92193,7.09897,35.94899,-.98482,7.54323,36.58724,-1.58989,7.51984,36.54854,-1.64586,7.52363,36.74255,-1.71256,6.75809,36.85097,-1.10776,6.81088,36.91924,-1.01283,6.80464,36.89482,-1.06696,7.00165,36.92958,-.88938,6.97995,37.07153,-.88341,7.46294,36.57866,-1.22975,7.44492,36.65434,-1.2361,6.9881,37.26294,-2.07522,7.05078,37.39243,-2.02441,7.0912,37.2023,-2.13168,7.06635,36.99033,-2.09829,6.95791,37.06268,-2.03417,6.97515,37.22031,-2.07497,7.09608,37.15935,-2.12358,7.58533,36.94653,-1.68047,7.69797,37.1325,-1.80799,7.6699,37.11586,-1.73048,7.62237,36.95037,-1.75459,7.63329,36.9416,-1.83501,7.59932,36.91541,-1.72676,7.34553,35.67949,-1.66588,7.35916,35.98941,-1.7964,7.39882,35.70745,-1.61638,6.80423,36.90494,-.97095,6.87513,36.94311,-.91626,7.07398,36.71074,-.98988,6.99716,36.74723,-1.00189,7.05889,36.95379,-1.57687,7.06551,36.96449,-1.58328,6.91092,36.89757,-1.72306,6.90591,36.88048,-1.70695,6.94278,36.89952,-1.68512,7.52319,37.50257,-1.73506,7.54318,37.484,-1.76266,7.46451,37.50708,-1.82021,7.09108,37.53402,-1.90148,7.01604,37.44467,-1.97576,6.98871,37.52883,-1.8816,7.27663,34.82428,-1.29418,7.23609,35.29931,-1.50733,7.27263,35.29042,-1.53462,7.72163,37.24517,-1.74801,7.72535,37.34756,-1.69775,6.91205,37.26371,-2.01246,6.88213,37.34779,-1.94858,6.93062,37.30574,-2.01568,6.87545,37.30061,-1.94395,6.91736,37.03603,-1.7219,6.92132,36.99999,-1.71728,6.88775,37.41367,-1.80321,6.85884,37.3768,-1.84339,6.999,37.59402,-1.73619,7.0116,37.623,-1.76096,6.87,37.42398,-1.83932,7.28575,37.555,-1.42366,7.24411,37.52383,-1.42639,7.29888,37.49235,-1.41027,7.01999,37.49444,-1.7268,6.94445,37.40925,-1.77476,7.03808,37.36311,-1.71633,7.08982,36.94664,-1.48723,6.91211,36.81863,-1.20734,6.83658,36.80959,-1.17104,6.96604,36.89218,-1.10208,6.96015,36.82398,-1.28889,6.98153,36.83892,-1.35003,6.90031,36.79315,-1.33154,6.89187,36.79068,-1.3142,7.19903,36.39655,-1.00329,7.09861,36.38217,-1.05161,6.88473,36.80281,-1.72059};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_3()
		{
			double[] value = {6.84434,36.79681,-1.64449,6.87816,36.82395,-1.71238,6.85472,36.77387,-1.6467,6.66389,36.72394,-1.24057,6.72367,36.75157,-1.44047,6.74298,36.73004,-1.45089,6.89939,36.60832,-1.09032,6.75047,36.64864,-1.13665,6.76662,36.59911,-1.13583,6.73218,36.57568,-1.35365,6.67755,36.64415,-1.23377,6.7355,36.66812,-1.40358,6.69506,36.58087,-1.22515,7.06564,36.53922,-1.85961,7.06958,36.53781,-1.89743,7.09176,36.40225,-1.8497,6.95029,36.83966,-1.97426,7.07224,36.75366,-2.02592,6.97609,36.78576,-1.91902,7.70556,37.14527,-1.91289,7.61613,37.15328,-2.00924,7.68211,37.303,-1.83962,7.57789,37.28081,-1.93508,7.28854,36.78952,-.99762,7.38544,36.76663,-1.09078,7.26253,36.8452,-1.00968,7.55884,35.90754,-1.2928,7.35555,36.21292,-1.86907,7.44099,36.10563,-1.67024,7.46924,36.13522,-1.61347,7.53931,35.50372,-1.2036,7.57402,34.95221,-.95058,7.57861,34.97084,-.91881,7.60517,34.48709,-.69629,7.52004,35.04084,-.76804,7.49298,35.04625,-.74549,7.56586,34.55782,-.54915,7.57154,35.60827,-1.11003,7.55868,35.62811,-1.07811,7.58085,35.01808,-.83789,7.40783,35.6325,-.87904,7.3874,35.63287,-.86651,7.4438,36.43724,-.999,7.29723,36.5269,-.99033,7.42085,35.94373,-1.01311,7.48011,36.21299,-1.11982,7.46193,36.24432,-1.08847,7.43502,35.93027,-1.05333,7.52284,36.97533,-1.61542,7.44304,36.8515,-1.48435,7.52635,36.82425,-1.53299,6.68338,36.64865,-1.19751,6.66559,36.72186,-1.21418,6.73548,36.74734,-1.09377,7.09639,36.57138,-1.01759,7.18767,36.68549,-.9724,7.19475,36.54534,-.98678,7.34936,37.56341,-1.80929,7.27464,37.60317,-1.72939,6.92393,36.7488,-1.73909,6.90241,36.71014,-1.64068,6.89189,37.09377,-1.97276,6.89232,36.89639,-1.88898,7.3923,37.02321,-1.57319,7.23531,36.90772,-1.47144,7.35173,36.86673,-1.46732,7.29069,37.05817,-1.55779,7.43008,36.29876,-1.02454,7.4005,35.9714,-.93668,7.66469,36.46895,-1.38566,7.65501,36.44489,-1.43097,7.12209,36.99826,-.90092,7.4561,36.73128,-1.23082,7.63929,36.31254,-1.2907,7.653,36.34977,-1.38647,7.65702,36.38087,-1.34603,7.64617,36.26358,-1.30695,7.05655,36.99334,-1.04788,7.18752,36.91953,-1.03531,7.28682,36.83256,-1.16246,7.17855,36.86679,-1.2045,7.26498,37.23594,-1.54837,7.34749,37.20959,-1.55852,7.30131,37.41776,-1.47065,7.40391,37.38319,-1.50483,7.4245,36.82273,-1.45092,7.51523,36.7651,-1.43395,6.78205,36.80298,-1.19418,6.79601,36.90635,-.98231,6.87391,37.00471,-.89411,6.80533,36.91916,-.99796,6.87408,37.02915,-.94738,6.75335,36.83604,-1.43522,6.867,36.86913,-1.60139,6.73107,36.80518,-1.45307,6.8462,36.84566,-1.62795,7.08242,34.44957,-.71177,7.09512,33.93791,-.54571,7.08669,33.95788,-.49896,7.073,34.42471,-.75497};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_4()
		{
			double[] value = {6.85002,35.86387,-1.18164,6.77999,36.24356,-1.17454,6.79047,36.22096,-1.25352,7.53624,36.84167,-1.83104,6.98135,36.64194,-1.74524,6.97861,36.70572,-1.83397,7.0152,36.52586,-1.74425,7.04592,30.73064,.72124,7.05821,31.76859,.24161,7.11272,30.70706,.65456,7.16644,31.73248,.18505,7.1096,28.96366,1.61231,7.17566,29.1434,1.50368,7.17411,28.9232,1.56344,7.3662,30.88918,1.02287,7.47422,31.97106,.56257,7.43996,31.98241,.58503,7.38574,30.8822,1.00408,7.5111,32.90626,.22223,7.62049,34.02587,-.31785,7.58658,34.03585,-.29495,7.56192,32.89612,.19704,7.06157,30.81029,.91596,7.15852,30.84147,.95294,7.37746,28.79944,1.78772,7.36655,28.82969,1.79892,7.31842,28.7785,1.71767,7.32407,28.71231,1.6787,7.14517,28.91318,1.99562,7.24351,28.95092,2.04507,7.22215,28.97877,2.06524,7.17476,28.90213,1.98238,7.20757,29.56965,1.64977,7.15736,29.5166,1.62048,7.52238,29.50172,1.46417,7.52371,29.77005,1.33467,7.5202,29.56271,1.57677,7.49362,29.83165,1.44668,7.2577,28.85193,1.53266,7.23165,28.79451,1.68743,7.22909,28.83914,1.76056,7.19972,28.76612,1.7216,7.33629,28.72282,1.73421,7.32624,28.71402,1.71126,7.58474,36.30668,-1.23692,7.54018,36.4143,-1.26447,7.10884,34.87977,-1.13113,7.03692,35.36386,-1.2771,7.11477,35.34452,-1.3517,7.23243,32.76573,-.26735,7.11997,33.89509,-.6372,7.28373,33.81833,-.77465,7.10476,32.78544,-.18168,7.0805,36.09672,-1.63182,7.1485,36.05072,-1.76737,7.21658,35.68893,-1.65549,7.1119,35.74121,-1.51428,6.89381,36.86614,-1.69162,6.92746,36.88822,-1.67086,7.04796,34.89545,-1.04806,7.0823,34.36902,-.83702,7.01071,34.94221,-.9392,6.67452,36.78213,-1.22821,6.77334,36.68019,-1.45759,6.83773,36.20486,-1.34711,6.79532,36.58718,-1.44166,7.43786,36.27502,-1.75915,7.54923,36.52134,-1.56056,7.59782,36.26395,-1.39116,7.6149,36.16788,-1.29124,7.16519,37.5036,-1.58527,7.1352,37.61993,-1.52547,6.77952,36.82361,-1.38822,6.86659,36.82468,-1.47779,7.48828,36.41884,-1.19185,7.51415,36.36541,-1.13736,7.40073,28.62745,1.78551,7.55,28.7873,1.75683,7.5407,28.84916,1.76002,7.51534,28.79132,1.80537,7.49961,28.63955,1.78402,7.45507,28.61012,1.77595,7.48215,28.62125,1.77164,7.45309,28.62437,1.78799,7.54284,28.99516,1.69149,7.56774,28.81957,1.65274,7.54229,28.93297,1.59358,7.54512,28.88941,1.7398,7.15934,28.78637,1.68181,7.19067,28.81925,1.63415,7.45001,37.00319,-1.5883,7.48098,28.7568,1.57369,7.50568,28.69553,1.60571,7.40781,28.74349,1.54711,7.43541,28.69266,1.58592,7.2964,32.90989,.0686,7.3239,34.00981,-.37193,7.35773,32.757,-.28786,7.41104,33.82168,-.76197,7.01113,31.83347,.33875};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_5()
		{
			double[] value = {7.13016,32.85487,-.0212,7.06311,32.82537,-.08215,7.05272,31.87312,.38928,7.02034,30.7736,.81529,7.03858,30.79647,.89507,7.47354,31.8518,.34062,7.41893,30.85601,.94063,7.4599,30.79658,.80927,7.47864,31.92802,.4774,7.26937,30.72953,.64241,7.29199,31.74329,.15253,7.05748,30.19486,1.10102,7.1172,29.72265,1.30585,7.12064,29.76261,1.38476,7.22896,30.2708,1.29696,7.20985,29.82844,1.52204,7.31725,30.2803,1.30764,7.267,29.8405,1.51541,7.2889,30.05047,.96887,7.43361,29.688,1.20414,7.30142,29.63849,1.17155,7.40836,30.09312,1.02587,7.49899,29.57956,1.61206,7.31305,29.08914,1.44185,7.23207,29.35267,1.37141,7.30281,29.33823,1.32337,7.54313,29.29355,1.72762,7.51691,29.22537,1.59365,7.58687,29.15056,1.77272,7.53643,29.07213,1.65798,7.49294,29.34439,1.79858,7.42976,29.24728,1.98631,7.52681,29.22435,1.93263,7.42673,29.38314,1.83454,7.18072,29.09606,2.08297,7.1551,29.1742,2.035,7.06114,29.04126,1.99588,7.06467,29.13348,1.94874,7.5511,28.79287,1.60946,7.55241,28.88852,1.89848,7.49927,28.94129,2.01156,7.20859,28.87111,1.80181,7.19148,28.76358,1.73195,7.14419,28.77922,1.80161,7.45843,28.59871,1.74999,7.44955,28.59487,1.74495,7.45045,28.59443,1.73555,7.45164,28.5943,1.72581,7.46403,28.59473,1.72049,7.27935,34.50986,-.59913,7.40816,34.53884,-.54848,7.22798,35.0132,-.77626,7.35157,35.03104,-.74516,7.37614,35.03409,-.74243,7.25873,35.6267,-.89187,7.45604,36.49546,-1.01979,7.44728,36.51465,-1.10691,7.06128,36.58319,-1.02784,6.71823,36.81829,-1.08608,7.12109,36.21193,-1.81088,7.20718,36.0289,-1.83048,7.1584,36.19331,-1.86904,7.47638,36.50567,-1.21604,7.45625,36.56053,-1.20146,6.87273,36.97509,-1.75522,7.15663,37.09452,-1.5738,7.11951,37.12103,-1.62607,6.94624,36.5594,-1.60215,7.05681,36.24709,-1.67304,6.94039,36.23722,-1.49235,7.13021,36.35905,-1.90348,7.08491,36.53519,-1.95134,7.25392,37.62813,-1.70288,7.15452,37.64727,-1.53414,7.55987,37.39857,-1.85901,7.65134,37.40618,-1.75146,7.21201,37.59161,-1.79616,7.61941,36.93473,-1.85143,7.7184,37.15323,-1.89233,7.59412,36.93846,-1.85661,6.91827,37.19087,-1.77834,6.85466,36.78272,-1.31256,6.8622,36.78484,-1.30317,6.8577,36.78992,-1.3396,6.87607,36.79014,-1.3585,6.89298,36.7945,-1.3481,6.86974,36.78696,-1.29379,7.1153,37.02252,-.93317,7.22891,36.89315,-1.03104,7.55968,36.59856,-1.52727,7.2088,36.19334,-1.88851,6.95008,36.15693,-1.46892,6.78488,36.25762,-1.13635,6.84664,36.28372,-1.11609,6.70497,36.58951,-1.19189,6.89526,35.91277,-1.05587,7.25616,35.67181,-1.69637,7.42443,35.319,-1.45106,7.54541,35.03028,-.80102,7.47803,35.61957,-1.06235};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_6()
		{
			double[] value = {7.32762,28.87952,1.82324,7.29722,28.9039,1.85339,7.29179,28.89548,1.83883,7.31343,28.90876,1.8597,7.33613,28.89729,1.84462,7.32882,28.90263,1.85331,7.21756,28.93247,1.93582,7.29267,28.95739,1.96632,7.58213,28.92579,1.89405,7.523,28.99978,2.02798,7.4331,29.02326,2.07693,7.4272,28.96643,2.06996,7.11515,28.77483,1.79628,7.09668,28.84412,1.90344,7.05469,28.89421,1.91205,7.08445,28.81623,1.79057,7.10949,29.24905,1.68483,7.02538,29.14377,1.80186,7.10645,29.27336,1.72177,7.44067,29.13258,1.47103,7.44044,29.40879,1.34376,7.4939,29.1734,1.51588,7.46909,29.44136,1.38594,7.2748,29.58869,1.67164,7.19434,29.66413,1.20849,7.15692,30.08316,.98426,7.46037,29.71244,1.24302,7.44391,30.25221,1.2408,7.40269,29.84512,1.50121,7.38587,30.27969,1.2997,7.61513,33.97458,-.43311,7.57579,32.85229,.10934,7.40312,36.55784,-1.99099,7.39567,36.39287,-1.92882,7.38314,36.54903,-1.99222,7.37636,36.38554,-1.93864,7.30399,36.74864,-.98859,7.1327,36.90167,-1.3515,7.10139,36.88578,-1.22922,7.21124,36.86616,-1.33149,7.30059,29.03321,2.11338,7.19844,29.03203,2.09365,7.32618,28.98438,2.09792,7.38354,28.74484,1.79027,7.52878,29.01032,1.56942,7.46341,28.63655,1.63466,7.43693,28.70905,1.81697,7.50842,28.72466,1.80989,7.41448,28.61225,1.77651,7.42679,28.59939,1.75998,7.54594,28.7213,1.77422,7.40633,28.59989,1.72853,7.42989,28.59682,1.7325,6.87966,37.03044,-.95791,6.76511,36.78951,-1.26002,6.72108,36.81282,-1.25444,7.57808,36.32689,-1.45316,7.20885,36.3572,-1.94767,6.88488,36.84726,-1.77007,6.88493,36.8404,-1.75785,7.01968,36.91863,-1.53503,6.91243,36.88769,-1.65834,7.12926,34.36016,-.8889,7.55092,36.17807,-1.23,7.59202,36.16094,-1.25616,7.63936,36.26497,-1.2871,7.17751,28.76064,1.70537,7.22532,28.79299,1.66756,7.3234,28.95271,2.07082,7.23912,28.79464,1.68293,7.29632,28.7769,1.67258,7.40026,28.90522,1.89506,7.3986,28.85982,1.83947,7.16864,28.75841,1.71515,7.14928,28.78607,1.69054,7.35277,28.66613,1.70426,7.60294,28.97768,1.86803,7.53915,29.06494,2.02081,7.43505,29.0859,2.06609,7.59985,34.54553,-.58254,7.55139,35.57652,-1.14866,7.53831,32.8329,-.0813,7.13773,29.19202,1.58993,7.17474,29.39369,1.42738,6.92734,36.61724,-1.6185,7.4005,36.75614,-2.06423,7.44551,36.77271,-2.04028,6.92234,35.44192,-1.07398,6.68172,36.79353,-1.23143,6.70946,36.81244,-1.25003,7.00724,37.09279,-.91731,7.12459,37.00903,-.90883,7.11831,37.02034,-.92032,6.98225,37.08303,-.88943,6.72026,36.8285,-1.09033,6.74384,36.84424,-1.10434,7.58565,37.29033,-1.59373,7.32723,36.83182,-1.30643,7.38181,36.80004,-1.28902,7.55459,36.70044,-1.34702};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_7()
		{
			double[] value = {7.5468,36.73342,-1.37544,7.58864,36.26243,-1.22755,7.57011,35.91978,-1.19572,7.49436,35.94141,-1.15266,7.44137,37.18359,-1.59158,7.52282,37.4589,-1.49044,7.43184,37.4977,-1.43664,7.40241,36.35197,-1.01005,7.26893,36.3877,-.99952,7.35849,35.9784,-.91062,7.24053,35.96411,-.92348,6.87222,36.76163,-1.04411,7.48579,36.25939,-1.11126,7.55444,36.21201,-1.21795,7.52513,36.18165,-1.19554,7.47755,36.3673,-1.05188,7.45397,35.62439,-1.02788,7.43012,35.62442,-.97738,7.42087,35.62519,-.95825,7.5326,36.20164,-1.49889,7.52886,36.2649,-1.52934,7.5917,35.91818,-1.23,7.60827,37.09119,-2.02311,7.23382,36.88856,-1.01924,6.91303,36.84359,-1.85682,6.89917,36.82178,-1.77934,7.217,37.09839,-2.17219,7.21708,36.92473,-2.12558,7.62439,37.38841,-1.52946,7.67553,37.36163,-1.61056,7.63046,37.43071,-1.54408,7.5703,37.4891,-1.65395,7.616,37.45033,-1.69933,7.24583,28.89762,1.51438,7.22891,29.11786,1.45248,7.23277,37.1579,-2.15912,7.0109,36.98865,-1.05671,7.04246,36.88198,-1.255,6.92513,37.10218,-.90897,6.91566,37.08517,-.88178,7.51451,36.90774,-2.02688,7.55431,36.92771,-1.94028,6.89104,36.84646,-1.78906,7.50732,36.68154,-1.79112,7.57103,36.93375,-1.90034,7.53278,28.63543,1.67428,7.47221,28.60521,1.74223,7.48822,28.61489,1.74846,7.57294,36.24167,-1.43196,7.72209,37.36663,-1.70727,7.67628,37.40577,-1.62949,7.58484,36.93657,-1.86667,7.26056,37.62213,-1.71273,7.26697,37.61099,-1.72067,7.49776,36.90298,-2.04495,6.99546,35.93079,-1.02977,7.56308,36.5264,-1.52632,7.56953,36.40329,-1.49822,7.54601,36.38331,-1.53449,7.48405,36.42196,-1.07482,7.47003,36.52052,-1.20287,7.46778,36.46674,-1.14938,7.46368,36.53537,-1.18971,7.55117,36.45544,-1.29186,7.56217,36.49659,-1.31924,7.52318,36.36135,-1.57575,7.55657,36.30489,-1.48603,7.49526,36.5564,-1.2597,7.55568,36.53954,-1.32599,7.54919,36.5825,-1.33275,7.49965,36.54294,-1.2604,7.18637,34.49001,-.63394,7.07781,31.8877,.4098,7.15866,32.86556,-.00154,7.16322,33.97925,-.44238,7.19461,33.98638,-.42473,7.43215,34.54283,-.54436,7.24375,30.87789,1.01819,7.30989,31.972,.55988,7.22201,30.8723,1.00958,7.33205,31.97653,.56905,6.93013,37.10172,-.91987,7.00644,37.09302,-.92966,7.46959,36.77578,-2.00911,7.42043,36.41179,-1.90173,7.42984,36.56848,-1.9627,7.15594,37.5112,-1.89393,7.14316,37.5168,-1.89317,7.20072,37.59921,-1.79106,7.16338,37.62037,-1.78799,7.15244,37.62676,-1.78103,7.10641,37.53718,-1.89635,7.23681,28.79393,1.65976,7.44601,28.59492,1.71514,7.44362,28.59518,1.73461,7.4596,28.60373,1.76349,7.44182,28.59605,1.75341,7.47796,28.61336,1.76103,7.46761,28.60352,1.74876,7.49653,28.62236,1.75609};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_8()
		{
			double[] value = {7.51152,28.62233,1.73878,7.43311,28.59741,1.70557,7.42601,28.60256,1.68958,7.44869,28.64235,1.7989,7.5029,28.65777,1.79544,7.52225,28.64202,1.76519,7.53323,28.65883,1.77031,7.53258,28.63686,1.73487,7.54602,28.6513,1.73116,7.52217,28.64722,1.64895,7.4613,28.65234,1.6191,7.52226,28.6645,1.63486,7.55694,28.6841,1.72155,7.54676,28.67978,1.64965,7.56124,28.70546,1.71526,7.54258,28.66039,1.65946,7.54273,28.69952,1.77566,7.50641,28.70266,1.8077,7.23119,28.93395,1.92135,7.21028,28.90151,1.8653,7.35283,28.92904,1.92104,7.29362,28.95264,1.94565,7.38099,28.90846,1.88758,7.33554,28.88604,1.83155,7.37868,28.86513,1.83724,7.49956,36.80433,-1.91995,6.92161,36.78536,-1.79571,7.33981,28.90933,1.48151,7.4651,28.88935,1.53856,7.35087,28.8436,1.50355,7.45135,28.95344,1.51807,6.99826,37.01619,-1.65835,7.27872,37.3246,-2.04101,7.4885,37.34656,-1.54458,7.52205,37.41664,-1.48354,7.45639,37.42168,-1.92094,7.42314,37.46537,-1.42761,7.20635,37.26239,-1.56963,7.24238,37.4365,-1.49224,7.06262,36.89957,-1.37352,7.1486,36.94618,-1.46764,6.94677,36.84532,-1.42851,6.97567,36.3325,-1.10205,7.42773,37.13676,-2.11842,7.42553,37.0756,-2.13091,7.45394,36.46235,-1.82694,7.46921,36.61222,-1.87869,7.48879,36.50166,-1.73395,7.49247,36.50426,-1.23854,7.49928,36.52977,-1.25552,7.50071,36.64164,-1.29705,7.48023,36.57473,-1.24864,7.47353,36.30966,-1.67911,7.47058,35.94353,-1.1203,7.02025,37.15548,-1.70118,7.15454,37.29163,-1.62388,7.50878,36.31487,-1.11887,7.31607,37.45832,-1.92529,7.21232,36.5358,-2.00963,7.05496,29.03816,1.68369,7.14097,29.69022,1.25293,7.14756,29.4282,1.50297,7.35991,31.76507,.18807,7.36252,30.74053,.68427,7.57982,33.91939,-.55493,7.4777,34.35666,-.95615,7.57535,34.42989,-.80734,7.47652,33.84611,-.70425,7.54961,34.89691,-1.05228,7.45868,34.83896,-1.20437,7.20348,31.92992,.47971,7.16183,34.48474,-.64316,7.08679,30.12942,1.0291,7.60006,29.06631,1.81582,7.43154,29.17658,2.03399,7.53721,29.15239,1.97377,7.29675,29.18485,2.0687,7.16621,29.24744,1.98419,7.29349,29.25691,2.01417,7.01051,29.07254,1.84324,7.07433,29.199,1.89469,7.04939,28.99714,1.70703,7.30332,29.10484,2.1052,7.09239,28.97478,2.0166,7.04974,28.90217,1.74661,7.02242,28.96758,1.89657,7.19164,28.89423,1.8702,7.36591,28.9306,1.93812,7.13667,28.84431,1.90069,7.12428,29.31435,1.78176,7.18355,29.35657,1.82317,7.43168,32.77521,-.23203,7.00182,35.79506,-1.38515,6.96842,35.3882,-1.1948,6.8947,35.83912,-1.28422,7.72638,37.29564,-1.78649,7.43771,28.68722,1.81516,7.3788,28.65496,1.64859,7.56564,28.75704,1.68371,7.54965,28.72857,1.62874};
			return value;
		}
		private double[] getlulna_Coord_7_19_point_9()
		{
			double[] value = {7.49688,30.17873,1.12736,7.13896,29.47207,1.57491,7.41616,29.59785,1.67014,7.28904,29.38159,1.85456,7.38489,34.81916,-1.27063,7.40085,34.32121,-1.01376,7.2869,34.30056,-1.02621,7.36343,35.29045,-1.51227,7.49812,36.51451,-1.24886,7.21797,37.08132,-1.54744,7.21323,36.72062,-2.07478,7.41756,36.88807,-2.09157,7.43198,37.28963,-2.0092};
			return value;
		}

		/** Large attribute array: IndexedFaceSet DEF='lradius_Geo' coordIndex field, scene-graph level=6, element #14, 4704 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlradius_Geo_6_14_coordIndex()
		{
			MFInt32 lradius_Geo_6_14_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlradius_Geo_6_14_coordIndex_1()))
				.append(new MFInt32(getlradius_Geo_6_14_coordIndex_2()))
				.append(new MFInt32(getlradius_Geo_6_14_coordIndex_3()))
				.append(new MFInt32(getlradius_Geo_6_14_coordIndex_4()))
				.append(new MFInt32(getlradius_Geo_6_14_coordIndex_5()));
			return lradius_Geo_6_14_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lradius_Coord' point field, scene-graph level=7, element #14, 1770 total numbers made up of 590 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlradius_Coord_7_14_point()
		{
			MFVec3f lradius_Coord_7_14_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlradius_Coord_7_14_point_1()))
				.append(new MFVec3f(getlradius_Coord_7_14_point_2()))
				.append(new MFVec3f(getlradius_Coord_7_14_point_3()))
				.append(new MFVec3f(getlradius_Coord_7_14_point_4()))
				.append(new MFVec3f(getlradius_Coord_7_14_point_5()))
				.append(new MFVec3f(getlradius_Coord_7_14_point_6()));
			return lradius_Coord_7_14_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lulna_Geo' coordIndex field, scene-graph level=6, element #19, 6488 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlulna_Geo_6_19_coordIndex()
		{
			MFInt32 lulna_Geo_6_19_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_1()))
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_2()))
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_3()))
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_4()))
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_5()))
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_6()))
				.append(new MFInt32(getlulna_Geo_6_19_coordIndex_7()));
			return lulna_Geo_6_19_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lulna_Coord' point field, scene-graph level=7, element #19, 2439 total numbers made up of 813 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlulna_Coord_7_19_point()
		{
			MFVec3f lulna_Coord_7_19_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlulna_Coord_7_19_point_1()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_2()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_3()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_4()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_5()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_6()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_7()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_8()))
				.append(new MFVec3f(getlulna_Coord_7_19_point_9()));
			return lulna_Coord_7_19_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return BonesLeftRadiusUlna model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new BonesLeftRadiusUlna().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Medical.BonesLeftRadiusUlna\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Medical.BonesLeftRadiusUlna self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Medical/BonesLeftRadiusUlna_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Medical/BonesLeftRadiusUlna_JavaExport.x3d"; 
                String filenameX3DV = "Medical/BonesLeftRadiusUlna_JavaExport.x3dv"; 
                String filenameJSON = "Medical/BonesLeftRadiusUlna_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
