####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesLeftHumerus.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesLeftHumerus.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Left Humerus',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftHumerus.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesLeftHumerus.x3d'),
    Transform(DEF='DSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Group(DEF='LeftArm',
        #  lhumrus 
        children=[
        Shape(DEF='lhumrus',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(1,1,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='lhumrus_Geo',coordIndex=[0,1,2,-1,1,3,4,-1,5,6,0,-1,7,8,3,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,21,12,22,-1,21,24,12,-1,24,25,12,-1,26,27,28,-1,28,18,26,-1,14,29,30,-1,31,32,33,-1,34,35,31,-1,36,37,38,-1,39,40,41,-1,39,41,42,-1,43,35,44,-1,45,46,47,-1,37,48,38,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,56,58,57,-1,53,59,60,-1,60,61,62,-1,60,63,61,-1,64,65,66,-1,67,68,69,-1,67,70,68,-1,71,70,72,-1,72,73,71,-1,74,75,76,-1,74,77,75,-1,78,42,61,-1,79,80,81,-1,82,83,84,-1,85,86,87,-1,88,89,90,-1,91,92,93,-1,92,91,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,104,105,106,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,116,117,118,-1,119,120,121,-1,122,123,124,-1,125,126,127,-1,128,129,130,-1,131,104,106,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,139,141,140,-1,142,143,144,-1,145,146,109,-1,147,148,133,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,155,158,156,-1,154,159,160,-1,154,153,159,-1,161,162,163,-1,164,161,165,-1,166,167,96,-1,168,169,170,-1,168,170,165,-1,171,167,172,-1,124,173,174,-1,175,176,177,-1,177,178,175,-1,179,177,180,-1,179,181,177,-1,182,183,184,-1,182,185,183,-1,186,187,188,-1,186,189,187,-1,190,191,192,-1,190,193,191,-1,194,191,195,-1,194,196,191,-1,180,176,197,-1,180,177,176,-1,198,199,200,-1,83,201,84,-1,202,203,204,-1,205,206,207,-1,208,209,210,-1,211,212,116,-1,118,213,214,-1,214,116,118,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,224,225,226,-1,227,228,229,-1,230,227,231,-1,4,2,1,-1,232,233,234,-1,235,236,237,-1,238,233,239,-1,240,241,235,-1,242,236,243,-1,244,245,246,-1,247,248,205,-1,248,249,205,-1,250,251,252,-1,251,253,252,-1,254,255,256,-1,41,33,257,-1,258,259,260,-1,260,261,258,-1,262,260,263,-1,262,264,265,-1,262,266,267,-1,262,268,269,-1,262,270,271,-1,260,259,272,-1,264,263,273,-1,273,274,264,-1,267,266,275,-1,275,276,267,-1,277,269,268,-1,268,278,277,-1,270,279,280,-1,281,251,282,-1,283,284,285,-1,285,286,283,-1,287,288,289,-1,290,291,292,-1,293,294,295,-1,296,297,298,-1,285,298,297,-1,299,292,291,-1,300,301,295,-1,302,303,304,-1,305,306,307,-1,307,308,305,-1,219,309,310,-1,219,311,309,-1,312,313,302,-1,314,315,316,-1,317,249,248,-1,318,319,71,-1,320,321,70,-1,322,323,324,-1,325,326,327,-1,327,81,325,-1,209,328,329,-1,329,210,209,-1,330,331,332,-1,333,334,335,-1,332,336,330,-1,332,337,336,-1,338,339,330,-1,339,331,330,-1,340,341,342,-1,343,344,185,-1,344,345,185,-1,346,347,345,-1,348,99,349,-1,141,139,350,-1,343,351,344,-1,341,346,342,-1,347,346,99,-1,352,353,354,-1,355,356,357,-1,141,358,140,-1,359,232,360,-1,361,362,363,-1,361,364,362,-1,365,200,366,-1,365,367,200,-1,335,368,369,-1,370,371,372,-1,370,333,371,-1,373,374,372,-1,373,375,374,-1,376,377,378,-1,379,380,377,-1,381,382,352,-1,381,383,382,-1,384,385,386,-1,387,388,389,-1,390,332,331,-1,390,391,332,-1,352,140,392,-1,393,394,395,-1,107,396,108,-1,397,398,399,-1,400,401,402,-1,400,403,401,-1,404,405,406,-1,407,340,408,-1,408,409,407,-1,410,150,411,-1,412,410,411,-1,413,414,415,-1,413,416,414,-1,99,98,347,-1,407,341,340,-1,388,387,404,-1,417,418,419,-1,420,421,422,-1,161,96,162,-1,423,424,425,-1,165,161,168,-1,426,427,428,-1,429,430,431,-1,168,163,422,-1,421,168,422,-1,432,429,431,-1,94,91,433,-1,434,435,107,-1,434,436,435,-1,437,438,439,-1,440,441,395,-1,442,443,444,-1,445,439,446,-1,447,448,449,-1,447,450,448,-1,451,150,410,-1,452,453,454,-1,452,455,453,-1,96,95,162,-1,456,457,458,-1,459,460,461,-1,460,462,461,-1,463,464,465,-1,463,466,464,-1,467,468,469,-1,469,470,467,-1,188,471,472,-1,472,186,188,-1,458,473,474,-1,465,111,463,-1,475,476,477,-1,478,479,480,-1,481,482,64,-1,483,484,485,-1,486,487,488,-1,487,489,490,-1,491,492,493,-1,494,492,491,-1,495,496,497,-1,495,498,496,-1,499,496,500,-1,496,498,500,-1,501,502,503,-1,488,487,490,-1,504,505,493,-1,494,506,507,-1,508,506,509,-1,508,507,506,-1,510,505,511,-1,505,512,511,-1,513,514,515,-1,514,516,515,-1,517,518,68,-1,519,520,521,-1,492,519,521,-1,522,523,519,-1,524,525,526,-1,526,527,524,-1,517,528,529,-1,65,482,530,-1,529,528,530,-1,531,518,530,-1,72,532,523,-1,72,67,532,-1,57,78,55,-1,533,534,535,-1,536,537,538,-1,536,539,537,-1,540,541,542,-1,543,544,545,-1,546,547,548,-1,45,48,549,-1,549,550,45,-1,551,552,37,-1,550,90,553,-1,554,555,556,-1,557,558,559,-1,560,561,562,-1,563,5,562,-1,558,557,564,-1,565,566,567,-1,568,569,570,-1,571,572,573,-1,89,574,575,-1,47,576,577,-1,577,576,578,-1,568,579,576,-1,483,66,527,-1,580,581,582,-1,583,580,584,-1,585,586,587,-1,585,588,586,-1,589,590,591,-1,591,592,589,-1,583,593,594,-1,595,596,597,-1,598,580,582,-1,599,600,601,-1,602,603,604,-1,475,605,476,-1,606,607,608,-1,609,610,611,-1,528,517,612,-1,613,608,614,-1,615,616,617,-1,615,618,616,-1,619,620,281,-1,281,621,619,-1,622,623,624,-1,625,626,627,-1,625,628,626,-1,629,630,631,-1,629,632,630,-1,633,634,635,-1,633,636,634,-1,637,638,639,-1,640,641,642,-1,640,643,641,-1,644,645,646,-1,647,648,649,-1,650,651,652,-1,650,653,651,-1,652,654,655,-1,656,657,658,-1,658,659,656,-1,660,661,662,-1,660,663,661,-1,664,665,666,-1,664,667,665,-1,661,663,668,-1,668,669,661,-1,667,670,671,-1,671,672,667,-1,673,674,675,-1,676,677,678,-1,676,527,526,-1,676,679,527,-1,120,484,121,-1,680,681,682,-1,488,683,502,-1,684,685,686,-1,687,688,689,-1,690,691,692,-1,690,693,691,-1,634,694,635,-1,695,636,696,-1,695,697,636,-1,698,699,675,-1,700,701,600,-1,702,703,704,-1,702,705,703,-1,637,640,642,-1,642,638,637,-1,706,707,708,-1,709,710,711,-1,709,712,710,-1,710,713,711,-1,714,611,715,-1,716,717,706,-1,718,221,223,-1,719,720,721,-1,719,722,720,-1,541,540,723,-1,723,724,541,-1,541,725,726,-1,541,724,725,-1,727,728,597,-1,555,554,729,-1,570,730,579,-1,731,732,733,-1,733,732,734,-1,734,512,733,-1,735,51,58,-1,58,736,735,-1,737,738,87,-1,739,740,741,-1,591,742,743,-1,744,745,547,-1,547,746,744,-1,745,747,547,-1,747,548,547,-1,748,749,750,-1,749,751,750,-1,752,753,754,-1,755,753,756,-1,755,30,753,-1,757,758,759,-1,757,760,758,-1,533,756,753,-1,753,534,533,-1,761,11,533,-1,533,762,761,-1,763,764,765,-1,764,766,765,-1,767,768,759,-1,759,758,767,-1,769,770,771,-1,770,536,771,-1,539,772,773,-1,773,535,539,-1,566,774,13,-1,775,776,14,-1,502,777,778,-1,778,779,502,-1,780,781,782,-1,782,783,780,-1,784,785,786,-1,787,788,789,-1,768,706,717,-1,790,791,792,-1,793,794,795,-1,796,797,798,-1,6,799,800,-1,6,801,799,-1,802,803,804,-1,805,806,807,-1,808,746,547,-1,547,546,808,-1,809,810,811,-1,811,743,809,-1,611,708,609,-1,812,813,610,-1,814,815,816,-1,817,818,5,-1,819,820,821,-1,819,822,820,-1,823,824,825,-1,823,791,824,-1,826,824,790,-1,826,827,824,-1,781,828,829,-1,829,782,781,-1,830,651,831,-1,651,653,831,-1,495,479,489,-1,119,832,490,-1,833,721,720,-1,833,834,721,-1,826,835,836,-1,837,783,838,-1,837,839,783,-1,840,786,789,-1,840,841,786,-1,684,689,649,-1,649,842,684,-1,843,844,845,-1,843,846,844,-1,152,847,174,-1,145,105,104,-1,848,131,106,-1,109,105,145,-1,194,108,197,-1,422,473,420,-1,377,380,849,-1,850,406,405,-1,850,851,406,-1,852,428,853,-1,345,183,185,-1,854,389,428,-1,854,387,389,-1,855,380,850,-1,850,856,855,-1,126,857,858,-1,126,858,127,-1,343,185,124,-1,126,859,860,-1,859,861,156,-1,862,159,157,-1,862,160,159,-1,149,863,150,-1,864,865,866,-1,455,867,453,-1,425,868,869,-1,870,871,465,-1,872,873,868,-1,874,875,876,-1,877,878,868,-1,879,880,877,-1,879,881,880,-1,882,879,868,-1,883,884,868,-1,885,886,887,-1,885,888,886,-1,889,868,890,-1,891,892,886,-1,886,893,891,-1,892,894,467,-1,467,470,892,-1,895,868,896,-1,897,898,138,-1,897,899,898,-1,900,210,329,-1,900,901,210,-1,902,903,904,-1,902,905,903,-1,906,907,132,-1,908,390,909,-1,908,910,390,-1,210,911,208,-1,210,904,911,-1,335,903,368,-1,362,912,367,-1,362,913,912,-1,914,915,337,-1,914,916,915,-1,328,917,329,-1,918,334,919,-1,918,335,334,-1,367,912,200,-1,130,920,921,-1,130,922,920,-1,923,924,325,-1,921,925,926,-1,921,920,925,-1,927,80,928,-1,927,929,80,-1,81,930,923,-1,214,327,931,-1,932,933,934,-1,932,928,933,-1,79,81,935,-1,936,114,113,-1,937,938,939,-1,938,940,939,-1,941,79,323,-1,304,940,942,-1,322,941,323,-1,943,944,945,-1,255,312,946,-1,255,947,312,-1,948,949,950,-1,949,951,950,-1,216,952,217,-1,216,953,952,-1,954,955,303,-1,302,304,956,-1,309,957,310,-1,958,959,960,-1,324,960,959,-1,324,961,960,-1,249,317,252,-1,256,962,963,-1,964,965,966,-1,964,257,965,-1,42,41,967,-1,319,318,968,-1,482,481,969,-1,321,517,70,-1,970,971,321,-1,531,972,973,-1,974,975,976,-1,974,624,975,-1,977,978,968,-1,979,684,842,-1,980,981,646,-1,981,644,646,-1,982,983,639,-1,984,316,985,-1,229,244,231,-1,556,561,560,-1,73,522,62,-1,32,577,578,-1,32,986,33,-1,31,41,34,-1,44,551,43,-1,38,987,43,-1,54,522,492,-1,988,989,820,-1,988,559,989,-1,2,990,991,-1,568,553,992,-1,993,579,994,-1,562,5,995,-1,6,996,801,-1,997,998,299,-1,7,3,800,-1,23,16,21,-1,999,17,16,-1,23,1000,16,-1,4,3,1001,-1,1002,27,1003,-1,1003,1004,1002,-1,1005,20,726,-1,1006,1007,1008,-1,1009,1010,224,-1,224,226,1009,-1,617,619,601,-1,601,701,1011,-1,601,600,701,-1,696,636,633,-1,1012,693,690,-1,837,1013,1014,-1,837,838,1013,-1,840,788,1015,-1,840,789,788,-1,787,1016,1017,-1,611,719,715,-1,752,534,753,-1,752,537,534,-1,1018,1019,1020,-1,1018,1021,1019,-1,1022,1023,1024,-1,313,1025,1026,-1,619,621,599,-1,583,581,580,-1,1027,285,1028,-1,997,291,1029,-1,997,299,291,-1,1030,1031,1032,-1,287,1033,288,-1,1034,1035,595,-1,289,288,1036,-1,1037,289,1036,-1,1037,293,289,-1,591,1038,1039,-1,813,583,1034,-1,1028,285,297,-1,1040,597,596,-1,1041,611,1034,-1,725,288,726,-1,288,1005,726,-1,723,540,1042,-1,540,1043,1042,-1,291,300,296,-1,583,1044,593,-1,599,621,580,-1,1045,282,251,-1,251,1046,1045,-1,281,1047,251,-1,599,1048,600,-1,1049,312,947,-1,1050,1051,1052,-1,1052,1053,1050,-1,610,609,812,-1,767,706,768,-1,845,785,784,-1,845,1054,785,-1,699,671,675,-1,660,662,696,-1,617,1011,615,-1,617,601,1011,-1,251,1047,1055,-1,1055,253,251,-1,245,244,228,-1,226,225,1008,-1,1001,1056,4,-1,1001,3,8,-1,1004,1056,1001,-1,999,16,1000,-1,15,17,8,-1,2,991,0,-1,566,565,774,-1,565,1057,774,-1,5,1058,817,-1,1059,995,5,-1,562,994,560,-1,993,223,222,-1,779,1060,1061,-1,1061,502,779,-1,62,53,60,-1,551,36,43,-1,987,35,43,-1,75,551,76,-1,33,41,31,-1,986,32,578,-1,578,1062,986,-1,46,553,576,-1,1063,10,1064,-1,1063,755,10,-1,1065,1066,1067,-1,231,244,578,-1,316,1068,314,-1,1069,984,985,-1,831,1070,704,-1,831,653,1070,-1,637,1071,1072,-1,502,1073,486,-1,731,492,521,-1,970,321,320,-1,482,969,1074,-1,973,532,1075,-1,517,68,70,-1,65,64,482,-1,967,71,42,-1,967,318,71,-1,1076,1077,1078,-1,1076,1079,1077,-1,218,1080,1081,-1,962,1082,1083,-1,250,317,1084,-1,250,252,317,-1,950,961,324,-1,950,951,961,-1,322,324,959,-1,959,957,322,-1,959,310,957,-1,303,955,304,-1,952,949,948,-1,952,953,949,-1,310,959,958,-1,1085,943,308,-1,1085,944,943,-1,324,323,950,-1,323,1086,950,-1,957,941,322,-1,955,936,940,-1,114,944,84,-1,944,1085,84,-1,1087,1088,117,-1,1088,217,117,-1,935,1086,79,-1,1086,323,79,-1,82,84,1087,-1,327,214,935,-1,356,921,1089,-1,356,130,921,-1,1090,1091,1092,-1,1090,1093,1091,-1,334,370,366,-1,334,333,370,-1,369,333,335,-1,369,371,333,-1,339,909,331,-1,909,390,331,-1,364,913,362,-1,364,144,913,-1,1094,897,1095,-1,1095,1096,1094,-1,138,1095,897,-1,425,896,868,-1,459,467,894,-1,894,1097,459,-1,895,890,868,-1,892,887,886,-1,892,470,887,-1,889,415,868,-1,98,345,347,-1,883,868,414,-1,882,868,884,-1,879,877,868,-1,878,877,880,-1,880,1098,878,-1,874,868,878,-1,111,110,463,-1,1099,1100,866,-1,866,1101,1099,-1,410,412,1102,-1,847,152,154,-1,860,158,1103,-1,860,859,158,-1,1104,402,1105,-1,402,1106,1105,-1,1107,403,1108,-1,1107,401,403,-1,160,124,847,-1,343,124,123,-1,427,127,858,-1,427,854,428,-1,351,1109,344,-1,1110,392,140,-1,101,189,1111,-1,101,187,189,-1,348,1112,1111,-1,1113,432,431,-1,456,458,1114,-1,1115,180,437,-1,197,396,437,-1,146,1116,109,-1,102,101,350,-1,598,1048,599,-1,707,706,767,-1,640,637,1072,-1,833,1117,1118,-1,833,1119,1117,-1,1120,1121,792,-1,1121,790,792,-1,1122,1123,1124,-1,611,610,1034,-1,596,595,1035,-1,498,495,489,-1,1035,1034,583,-1,791,790,824,-1,781,778,828,-1,563,561,1058,-1,610,813,1034,-1,591,811,592,-1,591,743,811,-1,1125,5,818,-1,1126,1127,1128,-1,1128,1129,1126,-1,842,1130,979,-1,1130,1131,979,-1,800,3,6,-1,845,784,843,-1,1058,5,563,-1,717,759,768,-1,717,1132,759,-1,1133,1134,846,-1,782,838,783,-1,780,778,781,-1,780,779,778,-1,1135,1136,1137,-1,1137,1138,1135,-1,775,14,13,-1,774,775,13,-1,774,1139,775,-1,1140,1137,1136,-1,1140,1141,1137,-1,53,1142,59,-1,759,1143,757,-1,759,1132,1143,-1,756,11,10,-1,756,533,11,-1,1016,785,1054,-1,1016,787,785,-1,1144,1145,1146,-1,1146,1147,1144,-1,755,756,10,-1,1148,742,591,-1,86,1149,1150,-1,1151,1152,740,-1,56,736,58,-1,56,1153,736,-1,504,731,733,-1,1154,1155,1156,-1,508,1157,507,-1,735,1158,1159,-1,735,1160,1158,-1,86,1150,87,-1,729,554,1161,-1,13,25,566,-1,13,12,25,-1,726,19,1162,-1,726,20,19,-1,1163,1007,1006,-1,1163,1164,1007,-1,26,1003,27,-1,26,1164,1003,-1,1165,723,1166,-1,1165,724,723,-1,708,611,714,-1,567,25,1167,-1,567,566,25,-1,716,715,721,-1,715,719,721,-1,708,714,706,-1,1168,643,1169,-1,1168,641,643,-1,830,637,1170,-1,1171,1172,603,-1,1171,1173,1172,-1,984,705,702,-1,984,1069,705,-1,697,1174,636,-1,700,1175,1176,-1,1174,1177,1178,-1,1179,631,687,-1,687,689,1179,-1,1180,1181,694,-1,694,634,1180,-1,689,688,649,-1,1182,982,639,-1,1183,1068,1184,-1,683,1185,502,-1,985,316,315,-1,120,1186,1187,-1,679,483,527,-1,120,119,1188,-1,666,665,1189,-1,667,664,691,-1,657,1190,658,-1,1068,1191,1184,-1,316,1192,1068,-1,641,686,642,-1,1193,643,1194,-1,1069,985,1195,-1,1196,1197,1198,-1,638,685,639,-1,1071,637,830,-1,606,1199,1200,-1,1201,1202,1203,-1,1201,1204,1202,-1,698,631,630,-1,698,687,631,-1,660,696,633,-1,1205,622,624,-1,1206,1207,974,-1,608,1208,606,-1,1055,616,206,-1,616,618,206,-1,281,620,1047,-1,1209,612,517,-1,613,663,660,-1,1210,1199,1211,-1,635,1212,1213,-1,635,1214,1212,-1,607,618,608,-1,619,599,601,-1,1214,635,1215,-1,1061,503,502,-1,1172,583,813,-1,813,812,604,-1,580,598,599,-1,597,728,595,-1,1034,595,1041,-1,587,586,1216,-1,1216,1217,587,-1,297,296,300,-1,583,584,1044,-1,581,1173,582,-1,51,50,543,-1,1218,731,520,-1,731,521,520,-1,1219,481,1220,-1,1219,969,481,-1,523,520,519,-1,579,568,570,-1,553,568,576,-1,551,75,1221,-1,571,90,89,-1,992,573,569,-1,992,571,573,-1,569,568,992,-1,1222,567,1223,-1,1222,565,567,-1,1150,558,555,-1,737,87,729,-1,561,563,562,-1,555,558,564,-1,729,1161,737,-1,552,551,1221,-1,45,550,553,-1,553,46,45,-1,85,1224,1225,-1,1225,86,85,-1,820,989,1226,-1,50,1227,1228,-1,543,50,544,-1,50,1228,544,-1,77,545,75,-1,77,543,545,-1,535,534,537,-1,537,539,535,-1,62,522,54,-1,245,228,225,-1,518,529,530,-1,528,65,530,-1,530,482,531,-1,519,492,522,-1,518,517,529,-1,973,1075,531,-1,509,510,1229,-1,1229,1230,509,-1,494,491,506,-1,505,491,493,-1,505,510,491,-1,731,504,493,-1,501,503,475,-1,475,499,501,-1,1229,511,1231,-1,511,1232,1231,-1,510,511,1229,-1,502,501,1073,-1,52,54,492,-1,62,54,53,-1,731,493,492,-1,502,486,488,-1,873,869,868,-1,474,1233,179,-1,874,872,868,-1,1234,1235,876,-1,1235,1236,876,-1,197,437,180,-1,459,468,467,-1,459,461,468,-1,110,466,463,-1,110,178,466,-1,1237,1238,1239,-1,1238,190,1239,-1,1240,172,1241,-1,453,431,454,-1,1242,1243,430,-1,1243,431,430,-1,1241,172,92,-1,473,458,457,-1,1244,1245,150,-1,1245,411,150,-1,1246,395,441,-1,444,443,1247,-1,107,109,434,-1,1243,454,431,-1,458,1115,1114,-1,1248,91,93,-1,1249,1250,444,-1,441,1251,1252,-1,441,1253,1251,-1,1247,443,1254,-1,1255,1256,1257,-1,1255,169,1256,-1,870,1258,871,-1,422,474,473,-1,428,852,426,-1,427,426,123,-1,123,127,427,-1,1259,1103,410,-1,1103,451,410,-1,1260,1100,902,-1,163,168,161,-1,169,1255,170,-1,1261,341,407,-1,1262,1263,885,-1,885,1264,1262,-1,868,415,414,-1,866,865,1101,-1,409,1261,407,-1,1265,1266,1267,-1,1266,388,1267,-1,397,1268,398,-1,397,399,1113,-1,399,1269,1113,-1,1270,393,395,-1,432,1271,429,-1,1271,1272,429,-1,910,391,390,-1,910,1273,391,-1,1274,1275,1276,-1,1267,406,851,-1,404,387,1277,-1,381,1278,383,-1,354,1095,140,-1,380,379,850,-1,1279,369,368,-1,1279,1280,369,-1,1281,109,1116,-1,365,374,363,-1,938,1282,1283,-1,938,1284,1282,-1,1285,1286,1083,-1,1095,138,140,-1,358,349,140,-1,356,200,912,-1,912,357,356,-1,352,354,140,-1,376,379,377,-1,1266,1265,340,-1,1265,408,340,-1,852,1109,351,-1,852,853,1109,-1,852,351,343,-1,1287,1261,349,-1,1261,1110,349,-1,346,345,342,-1,345,344,342,-1,1110,140,349,-1,173,124,185,-1,342,1288,340,-1,84,201,114,-1,201,1289,114,-1,366,370,365,-1,923,325,81,-1,326,1290,1291,-1,327,935,81,-1,955,940,304,-1,321,971,1292,-1,248,1204,1293,-1,248,1202,1204,-1,1294,315,314,-1,639,1170,637,-1,983,654,1295,-1,303,317,954,-1,307,1296,215,-1,307,306,1296,-1,1005,288,1033,-1,1084,317,303,-1,1216,1028,1217,-1,1216,1027,1028,-1,294,300,295,-1,294,297,300,-1,301,291,290,-1,301,300,291,-1,299,1005,292,-1,1022,998,1297,-1,1023,1022,284,-1,1297,998,997,-1,292,1005,1033,-1,1029,291,296,-1,1023,1298,1024,-1,285,1027,1299,-1,285,1299,286,-1,268,267,276,-1,276,278,268,-1,266,1300,275,-1,1301,265,264,-1,264,274,1301,-1,273,263,272,-1,263,260,272,-1,262,271,261,-1,262,269,270,-1,262,267,268,-1,262,265,266,-1,262,263,264,-1,262,261,260,-1,232,1302,1286,-1,1286,233,232,-1,251,250,1026,-1,240,235,237,-1,360,232,234,-1,242,237,236,-1,238,234,233,-1,228,244,229,-1,231,576,230,-1,226,1008,1007,-1,229,231,227,-1,1303,683,677,-1,1304,974,976,-1,578,576,231,-1,1305,1200,1199,-1,1305,247,1200,-1,1090,1290,1306,-1,931,1307,214,-1,918,911,904,-1,248,1293,317,-1,1308,1309,366,-1,1289,115,114,-1,95,1310,163,-1,163,162,95,-1,196,1311,191,-1,1311,192,191,-1,193,195,191,-1,193,105,195,-1,469,182,1312,-1,182,184,1312,-1,461,1313,468,-1,1313,1314,468,-1,97,1315,1316,-1,1316,1317,97,-1,1318,95,97,-1,97,1317,1318,-1,1112,350,101,-1,124,174,847,-1,1319,152,1320,-1,166,96,164,-1,172,1321,93,-1,1321,167,166,-1,96,161,164,-1,167,1321,172,-1,151,1319,149,-1,154,160,847,-1,156,158,859,-1,152,1319,153,-1,174,1315,152,-1,899,897,135,-1,146,145,104,-1,104,1322,146,-1,1323,897,1094,-1,1324,898,1325,-1,1326,906,1327,-1,1328,1322,1329,-1,1326,1327,1330,-1,1330,355,1326,-1,102,848,103,-1,355,1330,356,-1,120,1187,484,-1,944,114,204,-1,111,465,871,-1,396,197,108,-1,105,109,195,-1,848,106,103,-1,1111,1112,101,-1,345,98,183,-1,474,179,458,-1,172,93,92,-1,326,924,1331,-1,326,325,924,-1,85,87,738,-1,558,1150,1149,-1,941,933,79,-1,57,77,74,-1,74,78,57,-1,62,71,73,-1,72,70,67,-1,69,68,518,-1,66,65,1332,-1,78,61,1333,-1,1333,55,78,-1,63,1333,61,-1,60,59,63,-1,57,58,51,-1,43,36,38,-1,48,45,47,-1,47,38,48,-1,47,46,576,-1,34,41,40,-1,551,37,36,-1,31,577,32,-1,22,12,14,-1,1334,1000,23,-1,19,28,1335,-1,19,18,28,-1,1162,541,726,-1,14,30,22,-1,8,17,1001,-1,991,223,1059,-1,995,994,562,-1,0,3,1,-1,6,3,0,-1,994,223,993,-1,995,223,994,-1,1059,223,995,-1,1064,28,1336,-1,1335,28,1064,-1,1002,1334,1336,-1,1002,1000,1334,-1,1337,1005,1009,-1,1005,1337,20,-1,1333,59,1338,-1,63,59,1333,-1,679,484,483,-1,679,121,484,-1,148,1329,1339,-1,148,1328,1329,-1,906,134,1327,-1,906,132,134,-1,128,1340,129,-1,128,1341,1340,-1,1342,135,137,-1,899,135,1342,-1,848,1324,1325,-1,102,1324,848,-1,1342,134,1339,-1,1342,137,134,-1,907,142,147,-1,907,143,142,-1,848,1329,131,-1,1329,848,1325,-1,153,151,159,-1,151,153,1319,-1,165,166,164,-1,1321,166,165,-1,1320,96,167,-1,1320,152,96,-1,149,1320,863,-1,149,1319,1320,-1,466,1343,464,-1,466,181,1343,-1,464,1344,1345,-1,464,1343,1344,-1,1346,1345,1344,-1,1345,1346,1347,-1,1347,1318,1348,-1,1347,1346,1318,-1,1348,1317,1349,-1,1348,1318,1317,-1,1316,1349,1317,-1,1349,1316,462,-1,173,1313,174,-1,1313,173,1314,-1,1314,469,468,-1,182,469,1314,-1,1350,183,98,-1,184,183,1350,-1,1351,98,100,-1,1350,98,1351,-1,100,189,1351,-1,100,1111,189,-1,188,1352,1353,-1,188,187,1352,-1,1353,1354,1238,-1,1353,1352,1354,-1,1238,193,190,-1,1238,1354,193,-1,194,176,196,-1,197,176,194,-1,1355,199,198,-1,1356,199,1355,-1,1308,1357,1309,-1,1308,1358,1357,-1,202,1204,203,-1,202,1293,1204,-1,1092,1290,1090,-1,1291,1290,1092,-1,918,1093,911,-1,1093,918,919,-1,1091,212,211,-1,1091,1359,212,-1,211,1092,1091,-1,211,1307,1092,-1,1360,1305,1199,-1,1361,1305,1360,-1,1361,1202,1305,-1,1361,1203,1202,-1,33,965,257,-1,33,986,965,-1,1296,1362,1363,-1,1296,1364,1362,-1,1365,1366,1367,-1,1365,1368,1366,-1,1369,1370,1371,-1,1369,1372,1370,-1,1373,1366,977,-1,1373,1367,1366,-1,1374,2,4,-1,2,1374,990,-1,1375,718,1376,-1,718,1375,221,-1,232,1377,1302,-1,359,1377,232,-1,239,1286,1285,-1,239,233,1286,-1,1079,968,318,-1,1076,968,1079,-1,311,1285,1378,-1,1285,311,1081,-1,968,1362,977,-1,1362,968,1076,-1,1379,975,1380,-1,1379,976,975,-1,1026,1046,251,-1,1025,1046,1026,-1,1381,947,1024,-1,947,1381,1049,-1,1286,1382,963,-1,1286,1302,1382,-1,237,238,240,-1,237,234,238,-1,242,234,237,-1,234,242,360,-1,1080,1062,246,-1,1383,1062,1080,-1,273,1044,584,-1,273,272,1044,-1,278,286,1299,-1,278,276,286,-1,1300,265,1301,-1,1300,266,265,-1,261,1384,258,-1,261,271,1384,-1,1381,1045,1046,-1,1381,1385,1045,-1,1386,1385,1387,-1,1386,1045,1385,-1,1388,580,621,-1,1389,580,1388,-1,1033,290,292,-1,287,290,1033,-1,293,301,289,-1,293,295,301,-1,1390,997,1029,-1,1390,1297,997,-1,1022,1390,284,-1,1390,1022,1297,-1,294,1028,297,-1,1217,1028,294,-1,1216,277,1027,-1,277,1216,279,-1,1025,312,1049,-1,1025,313,312,-1,1391,946,956,-1,946,1391,962,-1,958,966,220,-1,960,966,958,-1,961,1392,964,-1,951,1392,961,-1,1077,953,1078,-1,953,1077,949,-1,1393,945,1201,-1,945,1393,943,-1,1078,216,1363,-1,216,1078,953,-1,309,1378,1394,-1,309,311,1378,-1,317,202,954,-1,202,317,1293,-1,983,1170,639,-1,1170,983,1295,-1,1395,1396,1397,-1,1395,1206,1396,-1,1398,315,1294,-1,315,1398,1399,-1,314,1183,1294,-1,1068,1183,314,-1,712,1400,710,-1,712,1401,1400,-1,1402,1403,1404,-1,1402,1405,1403,-1,1406,1407,1408,-1,1409,1407,1406,-1,1292,978,1410,-1,1292,971,978,-1,207,247,205,-1,1200,247,207,-1,1331,1290,326,-1,1290,1331,1306,-1,336,930,929,-1,1411,930,336,-1,341,99,346,-1,341,1261,99,-1,1278,386,383,-1,1278,384,386,-1,1412,340,1288,-1,340,1412,1266,-1,1265,1278,408,-1,1265,384,1278,-1,376,850,379,-1,850,376,851,-1,913,357,912,-1,1413,357,913,-1,138,1324,139,-1,138,898,1324,-1,1414,1282,1394,-1,1283,1282,1414,-1,938,934,1284,-1,937,934,938,-1,920,932,925,-1,920,1415,932,-1,338,1275,339,-1,1275,338,922,-1,1308,1356,1358,-1,1308,199,1356,-1,1281,434,109,-1,1281,1416,434,-1,143,913,144,-1,1413,913,143,-1,147,1281,1116,-1,1281,147,142,-1,364,1417,1418,-1,1417,364,361,-1,452,1279,455,-1,1280,1279,452,-1,1419,914,1420,-1,1419,916,914,-1,378,383,386,-1,378,382,383,-1,404,1267,388,-1,404,406,1267,-1,851,385,1267,-1,385,851,376,-1,1274,1323,1094,-1,1274,1276,1323,-1,1421,849,1422,-1,849,1421,377,-1,1422,1094,1096,-1,1422,908,1094,-1,429,1423,430,-1,429,1272,1423,-1,1243,1250,1424,-1,1250,1243,1242,-1,1246,1270,395,-1,1270,1246,1249,-1,1425,435,1426,-1,1427,435,1425,-1,1428,1311,1429,-1,1428,192,1311,-1,1430,1431,1432,-1,1433,1431,1430,-1,1434,1098,1435,-1,875,1098,1434,-1,1113,1271,432,-1,1113,1269,1271,-1,865,398,1268,-1,865,412,398,-1,1436,864,1106,-1,1436,1102,864,-1,1437,1438,1277,-1,1438,1437,1439,-1,1440,855,856,-1,1440,1441,855,-1,1277,1442,1437,-1,387,1442,1277,-1,858,854,427,-1,858,857,854,-1,1443,1444,1445,-1,1443,1446,1444,-1,1447,885,1263,-1,885,1447,888,-1,1257,448,1254,-1,1257,449,448,-1,420,1256,421,-1,420,1448,1256,-1,1449,1450,1451,-1,1449,1452,1450,-1,419,1453,417,-1,460,1453,419,-1,97,152,1315,-1,152,97,96,-1,1260,866,1100,-1,866,1260,1105,-1,1102,1259,410,-1,1102,1436,1259,-1,451,158,155,-1,451,1103,158,-1,862,125,122,-1,861,125,862,-1,426,343,123,-1,426,852,343,-1,1272,1454,1423,-1,1272,433,1454,-1,1258,1345,1347,-1,1258,870,1345,-1,1257,443,1255,-1,443,1257,1254,-1,1253,1455,1251,-1,1253,373,1455,-1,1252,1246,441,-1,1246,1252,1424,-1,180,458,179,-1,180,1115,458,-1,454,1424,1252,-1,1424,454,1243,-1,1426,436,1456,-1,1426,435,436,-1,1252,452,454,-1,1252,1251,452,-1,1249,1247,1270,-1,1249,444,1247,-1,1457,92,94,-1,92,1457,1241,-1,1245,1240,1458,-1,1240,1245,1244,-1,860,1108,126,-1,860,1107,1108,-1,363,375,361,-1,375,363,374,-1,440,1417,1459,-1,1456,1417,440,-1,446,1460,450,-1,1460,446,1461,-1,361,1459,1417,-1,375,1459,361,-1,1423,443,442,-1,1423,1454,443,-1,1258,417,871,-1,1258,418,417,-1,1099,867,455,-1,1101,867,1099,-1,398,1458,399,-1,398,1245,1458,-1,399,1457,1269,-1,399,1458,1457,-1,1462,732,731,-1,1462,1463,732,-1,1239,192,1428,-1,1239,190,192,-1,1464,1238,1237,-1,1464,1353,1238,-1,1262,472,1263,-1,1262,186,472,-1,1345,465,464,-1,1345,870,465,-1,1465,110,112,-1,1466,110,1465,-1,1467,1234,1468,-1,1467,1235,1234,-1,1236,874,876,-1,1236,872,874,-1,1469,1470,1471,-1,1470,1469,1472,-1,869,1473,1474,-1,1473,869,873,-1,1218,1074,1475,-1,1074,1218,972,-1,1187,1155,1154,-1,1187,1186,1155,-1,1220,484,1187,-1,1220,485,484,-1,1476,1231,1232,-1,1476,513,1231,-1,514,1477,1478,-1,1479,1477,514,-1,499,1073,501,-1,500,1073,499,-1,1480,1481,1482,-1,1480,1230,1481,-1,516,1483,1053,-1,1483,516,1484,-1,1485,477,476,-1,477,1485,1486,-1,1486,496,477,-1,497,496,1486,-1,1230,1231,1481,-1,1230,1229,1231,-1,497,1484,1478,-1,1484,497,1486,-1,518,1075,69,-1,1075,518,531,-1,978,970,968,-1,978,971,970,-1,1487,761,762,-1,761,1487,1043,-1,772,1488,773,-1,772,1489,1488,-1,769,1490,770,-1,769,1491,1490,-1,1492,1493,1494,-1,1495,1493,1492,-1,1496,1497,1498,-1,1496,1499,1497,-1,1500,1501,1502,-1,1501,1500,1503,-1,1504,1505,1506,-1,1504,1507,1505,-1,1508,1509,1510,-1,1509,1508,1511,-1,1512,1499,1496,-1,1512,1513,1499,-1,1514,1515,1516,-1,1514,1517,1515,-1,1518,1519,1520,-1,1521,1519,1518,-1,1522,1523,1524,-1,1523,1522,1525,-1,1526,1527,1528,-1,1526,1529,1527,-1,1530,1531,1532,-1,1533,1531,1530,-1,771,1529,1526,-1,1529,771,1534,-1,50,1535,1227,-1,50,49,1535,-1,1159,1536,1537,-1,1159,1158,1536,-1,1538,1539,1540,-1,1538,1541,1539,-1,1542,1543,1544,-1,1542,1545,1543,-1,1129,808,546,-1,808,1129,1128,-1,1224,738,1546,-1,1224,85,738,-1,86,1547,1149,-1,86,1225,1547,-1,89,1065,574,-1,89,88,1065,-1,1548,1221,1549,-1,1548,552,1221,-1,1550,90,1551,-1,90,1550,88,-1,1548,1552,1553,-1,1549,1552,1548,-1,729,1150,555,-1,87,1150,729,-1,1554,988,1555,-1,988,1554,1556,-1,1557,1558,1559,-1,1557,1560,1558,-1,1561,1223,1562,-1,1561,1222,1223,-1,1550,1563,1066,-1,1550,1564,1563,-1,1565,1566,1567,-1,1568,1566,1565,-1,1566,544,1228,-1,1566,1552,544,-1,1551,1564,1550,-1,1551,1569,1564,-1,571,553,90,-1,553,571,992,-1,532,520,523,-1,973,520,532,-1,1475,969,1219,-1,1475,1074,969,-1,973,1218,520,-1,972,1218,973,-1,549,1569,1551,-1,549,1570,1569,-1,1462,1219,1154,-1,1462,1475,1219,-1,1570,1553,1569,-1,1548,1553,1570,-1,587,294,1571,-1,294,587,1217,-1,590,588,585,-1,588,590,1572,-1,593,1573,589,-1,1573,593,1044,-1,813,603,1172,-1,813,604,603,-1,1215,694,1574,-1,1215,635,694,-1,1575,1199,1210,-1,1360,1199,1575,-1,1576,1212,1214,-1,1577,1212,1576,-1,1212,1211,1213,-1,1212,1210,1211,-1,613,1208,608,-1,1208,613,1578,-1,663,614,668,-1,663,613,614,-1,1209,1332,612,-1,1332,1209,524,-1,623,1371,1365,-1,1371,623,1579,-1,1580,1205,1581,-1,1580,622,1205,-1,1582,1206,1395,-1,1582,1207,1206,-1,1583,1575,1577,-1,1584,1575,1583,-1,620,1055,1047,-1,620,616,1055,-1,606,207,607,-1,207,606,1200,-1,606,1211,1199,-1,606,1208,1211,-1,1585,1396,1304,-1,1585,1584,1396,-1,974,1205,624,-1,974,1207,1205,-1,1366,1586,1410,-1,1366,1368,1586,-1,1587,1588,1589,-1,1590,1588,1587,-1,1180,1178,1591,-1,1180,1174,1178,-1,204,945,944,-1,204,203,945,-1,247,1202,248,-1,247,1305,1202,-1,636,1180,634,-1,1180,636,1174,-1,639,684,979,-1,639,685,684,-1,703,1197,1196,-1,1197,703,1592,-1,705,1195,1593,-1,705,1069,1195,-1,1576,1215,1594,-1,1576,1214,1215,-1,1595,1596,1574,-1,1596,1595,1597,-1,1598,1599,1600,-1,1598,1601,1599,-1,1602,1193,1194,-1,1602,1603,1193,-1,1169,1193,1604,-1,1169,643,1193,-1,1605,1599,1606,-1,1605,1603,1599,-1,1595,1607,1601,-1,1607,1595,1181,-1,1608,675,674,-1,675,1608,688,-1,1192,1191,1068,-1,1192,1070,1191,-1,654,982,656,-1,654,983,982,-1,1131,657,1182,-1,657,1131,1190,-1,1609,648,981,-1,1609,1130,648,-1,1184,650,1610,-1,1184,1191,650,-1,1609,658,1190,-1,658,1609,1611,-1,1612,673,1012,-1,1612,674,673,-1,667,693,670,-1,693,667,691,-1,1189,1613,666,-1,1189,1614,1613,-1,1615,1616,1617,-1,1615,1618,1616,-1,1619,1620,1621,-1,1622,1620,1619,-1,1620,1408,1407,-1,1620,1618,1408,-1,1614,1405,1615,-1,1405,1614,1403,-1,1401,665,1400,-1,1401,1189,665,-1,1623,1582,1624,-1,1623,1581,1582,-1,1183,1625,1626,-1,1184,1625,1183,-1,1627,1398,1294,-1,1627,1624,1398,-1,1628,1629,1630,-1,1628,1631,1629,-1,1188,1186,120,-1,478,1186,1188,-1,832,121,679,-1,119,121,832,-1,1632,315,1399,-1,1632,985,315,-1,1624,1628,1623,-1,1624,1627,1628,-1,1185,777,502,-1,1185,1633,777,-1,1626,1634,1631,-1,1634,1626,1625,-1,979,1182,639,-1,979,1131,1182,-1,658,1635,659,-1,658,1636,1635,-1,1637,1638,1639,-1,1640,1638,1637,-1,1013,1134,1133,-1,1641,1134,1013,-1,1608,644,647,-1,1608,645,644,-1,1605,1590,1587,-1,1605,1606,1590,-1,1169,625,627,-1,1169,1604,625,-1,1179,629,631,-1,1179,1168,629,-1,1180,1607,1181,-1,1180,1591,1607,-1,1178,1642,1588,-1,1178,1177,1642,-1,1589,1643,628,-1,1589,1644,1643,-1,709,632,626,-1,709,711,632,-1,828,1645,829,-1,828,1646,1645,-1,1639,1647,844,-1,1639,1638,1647,-1,845,1648,1054,-1,845,1649,1648,-1,1650,760,1016,-1,1650,1651,760,-1,767,1652,1653,-1,758,1652,767,-1,708,1654,815,-1,707,1654,708,-1,701,668,1011,-1,668,701,669,-1,602,1176,1175,-1,1176,602,1655,-1,1656,1657,814,-1,1658,1657,1656,-1,816,1659,1660,-1,816,1661,1659,-1,1662,1663,1664,-1,1663,1662,692,-1,690,1665,1666,-1,690,1667,1665,-1,1668,646,1669,-1,646,1668,980,-1,1636,1611,1670,-1,1611,1636,658,-1,1671,655,1672,-1,655,1671,1610,-1,669,700,1176,-1,669,701,700,-1,1173,600,1048,-1,1173,1171,600,-1,662,695,696,-1,662,1621,695,-1,1597,1195,1596,-1,1195,1597,1593,-1,984,1192,316,-1,984,702,1192,-1,1174,1409,1177,-1,1174,697,1409,-1,1175,603,602,-1,1171,603,1175,-1,1173,583,1172,-1,1173,581,583,-1,1664,1654,1653,-1,1664,1661,1654,-1,706,715,716,-1,706,714,715,-1,1167,24,7,-1,1167,25,24,-1,1163,1374,1673,-1,1163,1376,1374,-1,727,1674,728,-1,727,1675,1674,-1,1676,1677,1678,-1,1676,1679,1677,-1,1680,1681,1682,-1,1681,1680,1683,-1,1165,1684,1685,-1,1165,1166,1684,-1,19,9,1162,-1,19,1335,9,-1,1673,1164,1163,-1,1164,1673,1003,-1,1164,1337,1007,-1,1164,26,1337,-1,1685,1031,1165,-1,1685,1032,1031,-1,1682,809,1686,-1,1682,1681,809,-1,810,1676,1040,-1,1679,1676,810,-1,722,611,1041,-1,722,719,611,-1,737,573,572,-1,573,737,1161,-1,1167,1223,567,-1,1167,799,1223,-1,801,1558,1562,-1,801,996,1558,-1,1125,1554,1559,-1,1125,818,1554,-1,557,561,564,-1,557,1058,561,-1,1058,1556,817,-1,557,1556,1058,-1,556,730,554,-1,556,560,730,-1,736,1687,1688,-1,1153,1687,736,-1,1689,1224,1690,-1,1689,1225,1224,-1,1691,1692,1693,-1,1694,1692,1691,-1,1695,1537,1536,-1,1537,1695,1696,-1,1153,1516,1687,-1,1514,1516,1153,-1,1503,507,1157,-1,507,1503,1500,-1,1697,1155,480,-1,1155,1697,1156,-1,1462,1156,1463,-1,1462,1154,1156,-1,494,1500,1698,-1,1500,494,507,-1,56,1514,1153,-1,56,1338,1514,-1,1699,1696,1694,-1,1699,1700,1696,-1,1691,1067,1701,-1,1690,1067,1691,-1,1702,806,819,-1,1702,1703,806,-1,1704,1547,1705,-1,1704,1226,1547,-1,1706,1707,807,-1,741,1707,1706,-1,1227,1700,1567,-1,1535,1700,1227,-1,1708,1709,1710,-1,1708,1711,1709,-1,1712,1713,1714,-1,1127,1713,1712,-1,1701,1565,1699,-1,1563,1565,1701,-1,1151,739,1715,-1,1151,740,739,-1,1713,1706,1703,-1,1713,1716,1706,-1,1693,1717,1718,-1,1692,1717,1693,-1,1719,1708,1720,-1,1708,1719,1711,-1,572,738,737,-1,572,575,738,-1,1482,1051,1721,-1,1052,1051,1482,-1,1722,1051,1723,-1,1722,1721,1051,-1,1722,1724,1725,-1,1722,1726,1724,-1,1727,1728,1729,-1,1727,1726,1728,-1,1730,1731,1732,-1,1727,1731,1730,-1,1733,1731,1734,-1,1735,1731,1733,-1,1736,1735,1733,-1,1737,1735,1736,-1,1738,1739,1737,-1,1738,1740,1739,-1,1738,1741,1742,-1,1738,1743,1741,-1,1742,1744,1745,-1,1742,1741,1744,-1,1746,1137,1745,-1,1746,1138,1137,-1,1747,1746,1748,-1,1749,1746,1747,-1,766,1749,1747,-1,1750,1749,766,-1,1751,1752,1753,-1,1750,1752,1751,-1,1683,1752,764,-1,1683,1680,1752,-1,1482,1754,1480,-1,1482,1721,1754,-1,1232,1755,1476,-1,1755,1232,734,-1,1389,274,580,-1,274,1389,1301,-1,751,1756,1757,-1,751,749,1756,-1,1146,1758,1759,-1,1146,1145,1758,-1,1760,1145,1144,-1,1761,1145,1760,-1,1761,1762,1763,-1,1761,1764,1762,-1,744,1765,1766,-1,744,1764,1765,-1,1767,747,1768,-1,748,747,1767,-1,752,1769,1770,-1,752,754,1769,-1,1688,1147,1146,-1,1687,1147,1688,-1,1771,749,1772,-1,1756,749,1771,-1,1665,1648,1669,-1,1665,1650,1648,-1,692,664,1663,-1,692,691,664,-1,1773,1774,1775,-1,1774,1773,765,-1,1776,1777,1778,-1,1776,1751,1777,-1,1487,1779,1780,-1,1488,1779,1487,-1,1780,1781,1042,-1,1781,1780,1777,-1,1782,1773,1783,-1,1782,1784,1773,-1,1118,1785,1786,-1,1118,1117,1785,-1,1143,1787,1788,-1,1132,1787,1143,-1,492,1698,52,-1,492,494,1698,-1,9,761,542,-1,9,11,761,-1,1493,1531,1498,-1,1493,1528,1531,-1,1519,1507,1504,-1,1507,1519,1521,-1,1510,1524,1523,-1,1510,1509,1524,-1,1496,1789,1512,-1,1496,1533,1789,-1,1790,1020,1019,-1,1020,1790,1791,-1,1741,1792,1744,-1,1741,1793,1792,-1,1794,1136,1795,-1,1794,1140,1136,-1,1771,538,1770,-1,1771,1534,538,-1,1796,775,1139,-1,1796,776,775,-1,537,1770,538,-1,537,752,1770,-1,1795,1135,1797,-1,1135,1795,1136,-1,1744,1798,1748,-1,1798,1744,1792,-1,1799,1791,1790,-1,1799,1800,1791,-1,1641,838,782,-1,1013,838,1641,-1,1133,843,793,-1,1133,846,843,-1,1017,1143,1801,-1,1143,1017,757,-1,1802,1803,1804,-1,1803,1802,1805,-1,1806,1123,1807,-1,1124,1123,1806,-1,1736,1808,1809,-1,1733,1808,1736,-1,1527,1768,1532,-1,1768,1527,1767,-1,1715,1810,1151,-1,1715,1811,1810,-1,797,1812,1813,-1,1812,797,796,-1,1779,1135,1778,-1,1797,1135,1779,-1,725,1030,288,-1,725,1031,1030,-1,1037,1814,1039,-1,1037,1036,1814,-1,588,280,586,-1,280,588,1384,-1,802,1815,803,-1,802,1816,1815,-1,1014,1133,1817,-1,1133,1014,1013,-1,1638,1670,1647,-1,1638,1636,1670,-1,1125,6,5,-1,996,6,1125,-1,1513,1818,1499,-1,1818,1513,1819,-1,1734,1820,1821,-1,1734,1729,1820,-1,1822,1823,1824,-1,1825,1823,1822,-1,1820,836,1824,-1,1826,836,1820,-1,1827,1730,1819,-1,1827,1724,1730,-1,1765,1828,1766,-1,1765,1522,1828,-1,1543,1127,1712,-1,1543,1128,1127,-1,822,1557,1555,-1,822,805,1557,-1,733,505,504,-1,505,733,512,-1,1748,1774,1747,-1,1748,1798,1774,-1,1829,1806,1018,-1,1806,1829,1809,-1,1826,1830,836,-1,1830,1826,1831,-1,1053,1832,1050,-1,1483,1832,1053,-1,704,1196,831,-1,703,1196,704,-1,1402,1643,1644,-1,1402,1404,1643,-1,1655,1616,1622,-1,1658,1616,1655,-1,1592,1600,1197,-1,1592,1598,1600,-1,989,558,1149,-1,989,559,558,-1,1060,780,1833,-1,779,780,1060,-1,1830,1834,827,-1,1834,1830,1832,-1,1754,1835,1836,-1,1754,1725,1835,-1,1760,1520,1525,-1,1520,1760,1144,-1,1710,1539,1544,-1,1539,1710,1709,-1,1542,1762,1545,-1,1542,1763,1762,-1,1835,1511,1508,-1,1511,1835,1827,-1,1728,1831,1826,-1,1728,1723,1831,-1,791,839,792,-1,791,1833,839,-1,1834,476,825,-1,476,1834,1485,-1,1121,1822,835,-1,1121,1816,1822,-1,1837,1807,1805,-1,1807,1837,1021,-1,1838,1019,1839,-1,1019,1838,1790,-1,1785,1799,1840,-1,1799,1785,1841,-1,1674,1782,1119,-1,1782,1674,1675,-1,1061,823,605,-1,1061,1060,823,-1,1120,1014,1815,-1,1120,837,1014,-1,1802,841,1842,-1,1802,794,841,-1,1843,1015,1844,-1,1843,840,1015,-1,1845,1786,1846,-1,1845,1788,1786,-1,1804,804,803,-1,1804,1803,804,-1,1846,1838,1844,-1,1846,1840,1838,-1,1132,834,1787,-1,834,1132,717,-1,1130,649,648,-1,649,1130,842,-1,1456,1418,1417,-1,1418,1456,436,-1,439,1461,446,-1,439,438,1461,-1,445,1114,439,-1,456,1114,445,-1,94,1269,1457,-1,1269,94,1271,-1,441,1459,1253,-1,1459,441,440,-1,450,1847,448,-1,1847,450,1460,-1,99,1111,100,-1,99,348,1111,-1,408,381,409,-1,408,1278,381,-1,342,1109,1288,-1,342,344,1109,-1,1440,400,1848,-1,1440,1439,400,-1,124,862,122,-1,160,862,124,-1,1104,400,402,-1,1104,1848,400,-1,1105,1849,1104,-1,1849,1105,1260,-1,1107,1436,401,-1,1107,1259,1436,-1,412,1245,398,-1,412,411,1245,-1,1450,871,417,-1,1450,1471,871,-1,423,1469,1452,-1,423,1474,1469,-1,111,1467,112,-1,1470,1467,111,-1,1472,1236,1235,-1,1473,1236,1472,-1,1434,1468,1234,-1,1434,1433,1468,-1,1466,1430,1429,-1,1430,1466,1465,-1,1850,1432,1431,-1,1432,1850,1851,-1,880,1435,1098,-1,1435,880,1852,-1,1853,1852,1854,-1,1853,1850,1852,-1,1855,1239,1851,-1,1855,1237,1239,-1,1853,1856,1855,-1,1853,1857,1856,-1,881,1858,1854,-1,881,1859,1858,-1,882,1860,1859,-1,884,1860,882,-1,1858,1861,1857,-1,1862,1861,1858,-1,471,1856,1863,-1,471,1464,1856,-1,1861,1864,1863,-1,1861,1865,1864,-1,1860,1866,1862,-1,1860,1867,1866,-1,1867,414,416,-1,414,1867,883,-1,1865,1446,1443,-1,1446,1865,1866,-1,1864,1263,472,-1,1447,1263,1864,-1,1445,1868,893,-1,1445,1444,1868,-1,413,889,1869,-1,413,415,889,-1,1868,1870,1871,-1,1870,1868,1869,-1,1871,1872,891,-1,1871,1873,1872,-1,890,1874,1870,-1,890,895,1874,-1,1874,1875,1873,-1,1876,1875,1874,-1,1097,1872,1877,-1,1097,894,1872,-1,460,1097,1453,-1,459,1097,460,-1,1451,1875,1449,-1,1877,1875,1451,-1,896,424,1876,-1,896,425,424,-1,144,1418,1416,-1,1418,144,364,-1,1339,1325,1342,-1,1329,1325,1339,-1,1273,849,380,-1,849,1273,910,-1,1878,1419,1441,-1,1878,900,1419,-1,1260,901,1849,-1,1260,902,901,-1,1251,1280,452,-1,1455,1280,1251,-1,1280,371,369,-1,1280,1455,371,-1,1340,1323,1276,-1,136,1323,1340,-1,900,916,1419,-1,900,329,916,-1,129,1276,1275,-1,1340,1276,129,-1,130,1275,922,-1,129,1275,130,-1,924,328,1331,-1,328,924,917,-1,919,1879,1359,-1,919,334,1879,-1,200,1089,198,-1,200,356,1089,-1,1359,1880,212,-1,1359,1879,1880,-1,1881,198,1089,-1,198,1881,1355,-1,1357,82,1880,-1,1357,83,82,-1,926,113,1881,-1,926,939,113,-1,116,1087,117,-1,82,1087,116,-1,118,948,213,-1,118,952,948,-1,1088,84,1085,-1,84,1088,1087,-1,204,936,955,-1,936,204,114,-1,941,1282,1284,-1,941,957,1282,-1,950,213,948,-1,213,950,1086,-1,1085,307,1088,-1,1085,308,307,-1,1391,1283,1414,-1,1283,1391,942,-1,1026,1084,313,-1,1026,250,1084,-1,1379,1393,1882,-1,1379,305,1393,-1,306,1364,1296,-1,1380,1364,306,-1,1081,239,1285,-1,239,1081,241,-1,1383,218,220,-1,1383,1080,218,-1,1392,1079,1883,-1,1077,1079,1392,-1,65,612,1332,-1,65,528,612,-1,69,532,67,-1,532,69,1075,-1,1627,1631,1628,-1,1631,1627,1626,-1,681,683,1303,-1,681,1185,683,-1,682,1580,1884,-1,682,1579,1580,-1,683,678,677,-1,678,683,488,-1,490,678,488,-1,490,832,678,-1,498,487,500,-1,498,489,487,-1,698,688,687,-1,675,688,698,-1,1635,1645,1672,-1,1640,1645,1635,-1,1602,1197,1600,-1,1602,1198,1197,-1,831,1071,830,-1,1071,831,1196,-1,1632,1594,985,-1,1632,1576,1594,-1,1577,1632,1583,-1,1577,1576,1632,-1,1885,1304,976,-1,1885,1585,1304,-1,246,578,244,-1,1062,578,246,-1,1066,1701,1067,-1,1066,1563,1701,-1,807,1561,1560,-1,1707,1561,807,-1,1159,51,735,-1,51,1159,49,-1,71,61,42,-1,71,62,61,-1,1886,508,1480,-1,1886,1157,508,-1,1687,1518,1147,-1,1516,1518,1687,-1,1695,1717,1692,-1,1695,1887,1717,-1,1129,548,1811,-1,546,548,1129,-1,741,1888,1707,-1,740,1888,741,-1,1709,1540,1539,-1,1540,1709,1887,-1,574,1067,1546,-1,574,1065,1067,-1,993,227,230,-1,993,222,227,-1,1888,565,1222,-1,565,1888,1057,-1,1889,1757,1796,-1,1889,751,1757,-1,740,1057,1888,-1,1152,1057,740,-1,1152,774,1057,-1,1139,774,1152,-1,999,1002,1004,-1,1002,999,1000,-1,17,1004,1001,-1,1004,17,999,-1,1673,4,1056,-1,4,1673,1374,-1,1890,225,228,-1,1890,1008,225,-1,998,1010,299,-1,998,1891,1010,-1,1377,225,224,-1,1377,245,225,-1,243,246,245,-1,243,236,246,-1,1891,1302,1377,-1,1891,1382,1302,-1,254,1022,1024,-1,1022,254,998,-1,206,253,1055,-1,253,206,205,-1,712,1643,1404,-1,712,709,1643,-1,814,812,609,-1,812,814,1657,-1,1660,666,1613,-1,666,1660,1659,-1,1637,782,829,-1,1637,1641,782,-1,1016,757,1017,-1,1016,760,757,-1,1529,1767,1527,-1,1772,1767,1529,-1,1147,1520,1144,-1,1518,1520,1147,-1,1480,1836,1886,-1,1836,1480,1754,-1,1832,1485,1834,-1,1832,1483,1485,-1,1120,1816,1121,-1,1815,1816,1120,-1,1733,1821,1808,-1,1733,1734,1821,-1,1499,798,1497,-1,798,1499,1818,-1,1740,796,1739,-1,1740,1812,796,-1,1018,1807,1021,-1,1806,1807,1018,-1,1812,1141,1140,-1,1740,1141,1812,-1,1839,1844,1838,-1,1844,1839,1843,-1,1841,1800,1799,-1,1841,1775,1800,-1,1138,1778,1135,-1,1138,1776,1778,-1,282,1386,1388,-1,282,1045,1386,-1,1298,1381,1024,-1,1385,1381,1298,-1,272,1573,1044,-1,272,259,1573,-1,258,588,1572,-1,1384,588,258,-1,276,1892,286,-1,275,1892,276,-1,1893,1301,1389,-1,1301,1893,1300,-1,283,1023,284,-1,1298,1023,283,-1,1675,1784,1782,-1,1675,1678,1784,-1,1753,1166,1781,-1,1684,1166,1753,-1,811,1040,596,-1,1040,811,810,-1,596,592,811,-1,596,594,592,-1,594,1035,583,-1,594,596,1035,-1,1039,1148,591,-1,1814,1148,1039,-1,293,1571,294,-1,293,1037,1571,-1,1814,1032,1148,-1,1032,1814,1030,-1,1678,763,1784,-1,1678,1677,763,-1,1119,720,1674,-1,720,1119,833,-1,283,1892,1387,-1,286,1892,283,-1,1388,1893,1389,-1,1388,1386,1893,-1,1892,1300,1893,-1,1300,1892,275,-1,280,1216,586,-1,279,1216,280,-1,259,1572,1573,-1,258,1572,259,-1,1489,1779,1488,-1,1489,1797,1779,-1,1775,1798,1800,-1,1798,1775,1774,-1,1786,1840,1846,-1,1786,1785,1840,-1,1794,1492,1813,-1,1794,1491,1492,-1,1829,1020,1793,-1,1018,1020,1829,-1,1842,1805,1802,-1,1842,1837,1805,-1,1736,1829,1743,-1,1736,1809,1829,-1,1813,1494,797,-1,1494,1813,1492,-1,1818,1894,798,-1,1894,1818,1732,-1,1825,1124,1823,-1,1122,1124,1825,-1,605,825,476,-1,605,823,825,-1,1886,1506,1505,-1,1886,1836,1506,-1,1532,1895,1530,-1,1532,1768,1895,-1,1534,1772,1529,-1,1534,1771,1772,-1,1788,1801,1143,-1,1845,1801,1788,-1,828,777,1896,-1,828,778,777,-1,786,794,793,-1,794,786,841,-1,1661,815,1654,-1,1661,816,815,-1,1658,1617,1616,-1,1656,1617,1658,-1,1667,1650,1665,-1,1667,1651,1650,-1,1644,1406,1402,-1,1406,1644,1642,-1,1578,660,633,-1,1578,613,660,-1,254,1891,998,-1,1891,254,1382,-1,359,245,1377,-1,243,245,359,-1,1891,224,1010,-1,1891,1377,224,-1,299,1009,1005,-1,299,1010,1009,-1,1375,1008,1890,-1,1008,1375,1006,-1,1007,1009,226,-1,1009,1007,1337,-1,10,1335,1064,-1,10,9,1335,-1,1056,1003,1673,-1,1056,1004,1003,-1,30,1063,22,-1,30,755,1063,-1,799,7,800,-1,7,799,1167,-1,1796,1152,1889,-1,1139,1152,1796,-1,1151,1889,1152,-1,1889,1151,1810,-1,751,1810,750,-1,1810,751,1889,-1,579,230,576,-1,579,993,230,-1,1161,569,573,-1,569,1161,570,-1,0,1059,5,-1,0,991,1059,-1,1541,1759,1758,-1,1759,1541,1538,-1,1720,1704,1719,-1,1704,1720,821,-1,1126,1811,1715,-1,1811,1126,1129,-1,1718,1689,1693,-1,1718,1705,1689,-1,1538,1160,1759,-1,1160,1538,1158,-1,1157,1505,1503,-1,1157,1886,1505,-1,76,44,40,-1,76,551,44,-1,1567,1699,1565,-1,1567,1700,1699,-1,37,549,48,-1,37,1570,549,-1,1705,1225,1689,-1,1705,1547,1225,-1,1203,1885,1882,-1,1361,1885,1203,-1,1583,1399,1397,-1,1399,1583,1632,-1,1596,985,1594,-1,985,1596,1195,-1,1634,1671,1646,-1,1625,1671,1634,-1,1649,1669,1648,-1,1649,1668,1669,-1,1170,651,830,-1,1170,1295,651,-1,643,1072,1194,-1,643,640,1072,-1,489,119,490,-1,489,1188,119,-1,1697,1476,1755,-1,1697,1479,1476,-1,1370,526,525,-1,1370,1372,526,-1,1367,975,624,-1,1367,1373,975,-1,1884,1581,1623,-1,1884,1580,1581,-1,1579,1369,1371,-1,1369,1579,682,-1,680,1629,1633,-1,1630,1629,680,-1,517,1292,1209,-1,1292,517,321,-1,964,1883,257,-1,1392,1883,964,-1,965,220,966,-1,965,1383,220,-1,1076,1363,1362,-1,1076,1078,1363,-1,1380,305,1379,-1,1380,306,305,-1,1201,1882,1393,-1,1203,1882,1201,-1,1394,957,309,-1,957,1394,1282,-1,956,942,1391,-1,942,956,304,-1,955,202,204,-1,955,954,202,-1,1088,215,217,-1,1088,307,215,-1,962,255,946,-1,256,255,962,-1,938,942,940,-1,938,1283,942,-1,933,1284,934,-1,933,941,1284,-1,113,940,936,-1,939,940,113,-1,214,1086,935,-1,214,213,1086,-1,80,933,928,-1,80,79,933,-1,937,926,925,-1,926,937,939,-1,113,1355,1881,-1,1355,113,115,-1,116,1880,82,-1,212,1880,116,-1,929,81,80,-1,929,930,81,-1,932,927,928,-1,932,1415,927,-1,1881,921,926,-1,1089,921,1881,-1,1880,1309,1357,-1,1879,1309,1880,-1,1291,327,326,-1,1291,931,327,-1,923,1411,924,-1,1411,923,930,-1,1309,334,366,-1,334,1309,1879,-1,917,1411,915,-1,917,924,1411,-1,1330,130,356,-1,1330,128,130,-1,911,1090,208,-1,911,1093,1090,-1,915,329,917,-1,915,916,329,-1,339,1274,909,-1,339,1275,1274,-1,1341,1330,1327,-1,1341,128,1330,-1,918,903,335,-1,904,903,918,-1,1420,391,1273,-1,1420,914,391,-1,909,1094,908,-1,1094,909,1274,-1,1327,137,1341,-1,134,137,1327,-1,1279,903,905,-1,1279,368,903,-1,901,904,210,-1,901,902,904,-1,455,905,1099,-1,455,1279,905,-1,1099,902,1100,-1,1099,905,902,-1,1849,900,1878,-1,1849,901,900,-1,1273,855,1420,-1,380,855,1273,-1,148,1116,1328,-1,148,147,1116,-1,1876,1449,1875,-1,1876,424,1449,-1,1877,1453,1097,-1,1877,1451,1453,-1,1873,1877,1872,-1,1875,1877,1873,-1,1876,895,896,-1,1876,1874,895,-1,1873,1870,1874,-1,1871,1870,1873,-1,894,891,1872,-1,892,891,894,-1,1868,891,893,-1,1871,891,1868,-1,1869,890,1870,-1,890,1869,889,-1,1444,1869,1868,-1,1444,413,1869,-1,888,893,886,-1,888,1445,893,-1,1865,1447,1864,-1,1443,1447,1865,-1,1866,416,1446,-1,416,1866,1867,-1,884,1867,1860,-1,884,883,1867,-1,1862,1865,1861,-1,1862,1866,1865,-1,1863,472,471,-1,1863,1864,472,-1,1857,1863,1856,-1,1861,1863,1857,-1,1859,1862,1858,-1,1860,1862,1859,-1,879,1859,881,-1,879,882,1859,-1,1854,1857,1853,-1,1854,1858,1857,-1,1855,1464,1237,-1,1855,1856,1464,-1,1853,1851,1850,-1,1853,1855,1851,-1,880,1854,1852,-1,881,1854,880,-1,1431,1852,1850,-1,1431,1435,1852,-1,1851,1428,1432,-1,1428,1851,1239,-1,1465,1433,1430,-1,1433,1465,1468,-1,875,1234,876,-1,875,1434,1234,-1,1473,872,1236,-1,873,872,1473,-1,1470,1235,1467,-1,1472,1235,1470,-1,422,1233,474,-1,1897,1233,422,-1,425,1474,423,-1,1474,425,869,-1,1452,1471,1450,-1,1452,1469,1471,-1,150,171,1244,-1,863,171,150,-1,867,397,453,-1,867,1268,397,-1,451,151,150,-1,451,155,151,-1,1878,1104,1849,-1,1104,1878,1848,-1,125,859,126,-1,861,859,125,-1,126,1442,857,-1,1442,126,1108,-1,1441,1848,1878,-1,1441,1440,1848,-1,850,1438,856,-1,1438,850,405,-1,1412,428,389,-1,1412,853,428,-1,384,1267,385,-1,1267,384,1265,-1,382,377,1421,-1,378,377,382,-1,169,421,1256,-1,421,169,168,-1,1460,393,1847,-1,393,1460,394,-1,438,1425,1461,-1,1425,438,1427,-1,436,1416,1418,-1,1416,436,434,-1,146,1328,1116,-1,146,1322,1328,-1,1668,1647,1670,-1,1668,1649,1647,-1,1817,793,795,-1,1817,1133,793,-1,788,1845,1015,-1,1845,788,1801,-1,1837,1843,1839,-1,1843,1837,1842,-1,486,500,487,-1,500,486,1073,-1,1787,833,1118,-1,1787,834,833,-1,1846,1015,1845,-1,1846,1844,1015,-1,840,1842,841,-1,1842,840,1843,-1,795,803,1817,-1,803,795,1804,-1,792,837,1120,-1,837,792,839,-1,1119,1783,1117,-1,1783,1119,1782,-1,1840,1790,1838,-1,1790,1840,1799,-1,1021,1839,1019,-1,1021,1837,1839,-1,1803,1122,804,-1,1122,1803,1123,-1,835,790,1121,-1,826,790,835,-1,1646,1672,1645,-1,1646,1671,1672,-1,1833,783,839,-1,1833,780,783,-1,836,827,826,-1,836,1830,827,-1,1725,1827,1835,-1,1827,1725,1724,-1,1765,1525,1522,-1,1765,1760,1525,-1,1544,1712,1710,-1,1712,1544,1543,-1,1758,1542,1541,-1,1758,1763,1542,-1,1836,1508,1506,-1,1836,1835,1508,-1,1723,1050,1831,-1,1050,1723,1051,-1,827,825,824,-1,825,827,1834,-1,823,1833,791,-1,1060,1833,823,-1,1555,820,822,-1,1555,988,820,-1,1705,1719,1704,-1,1718,1719,1705,-1,1642,1409,1406,-1,1409,1642,1177,-1,1657,604,812,-1,604,1657,602,-1,1613,1656,1660,-1,1613,1617,1656,-1,1198,1194,1072,-1,1198,1602,1194,-1,1196,1072,1071,-1,1196,1198,1072,-1,1479,480,1477,-1,480,1479,1697,-1,1831,1832,1830,-1,1832,1831,1050,-1,1808,1823,1124,-1,1808,1821,1823,-1,1677,764,763,-1,1677,1683,764,-1,1743,1793,1741,-1,1743,1829,1793,-1,819,805,822,-1,819,806,805,-1,746,1545,1762,-1,1545,746,808,-1,1819,1511,1827,-1,1511,1819,1513,-1,1729,1826,1820,-1,1728,1826,1729,-1,1824,835,1822,-1,836,835,1824,-1,1821,1824,1823,-1,1821,1820,1824,-1,1819,1732,1818,-1,1732,1819,1730,-1,1530,1766,1828,-1,1530,1895,1766,-1,805,1560,1557,-1,1560,805,807,-1,844,1134,1639,-1,844,846,1134,-1,1815,1817,803,-1,1817,1815,1014,-1,1822,802,1825,-1,802,1822,1816,-1,1825,804,1122,-1,804,1825,802,-1,1039,1571,1037,-1,1571,1039,1038,-1,1814,288,1030,-1,1036,288,1814,-1,723,1781,1166,-1,723,1042,1781,-1,1813,1140,1794,-1,1813,1812,1140,-1,1222,1707,1888,-1,1561,1707,1222,-1,1811,750,1810,-1,548,750,1811,-1,797,1497,798,-1,1497,797,1494,-1,1739,798,1894,-1,798,1739,796,-1,1809,1124,1806,-1,1808,1124,1809,-1,1803,1807,1123,-1,1803,1805,1807,-1,1804,794,1802,-1,1804,795,794,-1,787,1801,788,-1,1801,787,1017,-1,786,787,789,-1,786,785,787,-1,793,784,786,-1,793,843,784,-1,681,1633,1185,-1,681,680,1633,-1,1800,1792,1791,-1,1800,1798,1792,-1,1490,1797,1489,-1,1797,1490,1795,-1,776,29,14,-1,1898,29,776,-1,1898,1796,1757,-1,1898,776,1796,-1,1795,1491,1794,-1,1491,1795,1490,-1,1793,1791,1792,-1,1793,1020,1791,-1,769,1526,1495,-1,1526,769,771,-1,772,536,770,-1,772,539,536,-1,1533,1498,1531,-1,1496,1498,1533,-1,1509,1789,1524,-1,1509,1512,1789,-1,1523,1504,1510,-1,1523,1519,1504,-1,1515,1507,1521,-1,1515,1501,1507,-1,1528,1495,1526,-1,1493,1495,1528,-1,1664,1652,1662,-1,1664,1653,1652,-1,1788,1118,1786,-1,1787,1118,1788,-1,1117,1841,1785,-1,1117,1783,1841,-1,1784,765,1773,-1,1784,763,765,-1,1781,1751,1753,-1,1781,1777,1751,-1,1487,1042,1043,-1,1042,1487,1780,-1,762,535,773,-1,535,762,533,-1,1780,1778,1777,-1,1779,1778,1780,-1,1747,765,766,-1,1747,1774,765,-1,1783,1775,1841,-1,1775,1783,1773,-1,1662,1651,1667,-1,1651,1662,1652,-1,645,674,1612,-1,674,645,1608,-1,1757,1769,1898,-1,1756,1769,1757,-1,1759,1688,1146,-1,1759,1160,1688,-1,30,754,753,-1,754,30,29,-1,1898,754,29,-1,1769,754,1898,-1,1770,1756,1771,-1,1769,1756,1770,-1,1772,748,1767,-1,1772,749,748,-1,548,748,750,-1,548,747,748,-1,747,1895,1768,-1,1895,747,745,-1,745,1766,1895,-1,1766,745,744,-1,1762,744,746,-1,1762,1764,744,-1,1764,1760,1765,-1,1760,1764,1761,-1,1145,1763,1758,-1,1763,1145,1761,-1,1686,1148,1032,-1,1686,742,1148,-1,734,511,512,-1,511,734,1232,-1,809,742,1686,-1,742,809,743,-1,1684,1752,1680,-1,1684,1753,1752,-1,764,1750,766,-1,764,1752,1750,-1,1776,1750,1751,-1,1776,1749,1750,-1,1749,1138,1746,-1,1776,1138,1749,-1,1745,1748,1746,-1,1744,1748,1745,-1,1141,1745,1137,-1,1141,1742,1745,-1,1740,1742,1141,-1,1740,1738,1742,-1,1743,1737,1736,-1,1743,1738,1737,-1,1737,1894,1735,-1,1739,1894,1737,-1,1732,1735,1894,-1,1732,1731,1735,-1,1729,1731,1727,-1,1729,1734,1731,-1,1724,1727,1730,-1,1724,1726,1727,-1,1726,1723,1728,-1,1723,1726,1722,-1,1725,1721,1722,-1,1725,1754,1721,-1,1702,1708,1714,-1,1720,1708,1702,-1,1717,1719,1718,-1,1717,1711,1719,-1,1714,1703,1702,-1,1713,1703,1714,-1,1715,1716,1126,-1,739,1716,1715,-1,1713,1126,1716,-1,1126,1713,1127,-1,1710,1714,1708,-1,1712,1714,1710,-1,1711,1887,1709,-1,1711,1717,1887,-1,1887,1536,1540,-1,1536,1887,1695,-1,1226,821,820,-1,821,1226,1704,-1,1716,741,1706,-1,1716,739,741,-1,1720,819,821,-1,1720,1702,819,-1,807,1703,1706,-1,806,1703,807,-1,1690,1546,1067,-1,1224,1546,1690,-1,1701,1694,1691,-1,1701,1699,1694,-1,1696,1535,1537,-1,1696,1700,1535,-1,1517,1142,1502,-1,1517,59,1142,-1,734,1463,1755,-1,734,732,1463,-1,1517,1501,1515,-1,1502,1501,1517,-1,1692,1696,1695,-1,1696,1692,1694,-1,1690,1693,1689,-1,1691,1693,1690,-1,1160,736,1688,-1,736,1160,735,-1,1755,1156,1697,-1,1156,1755,1463,-1,570,554,730,-1,570,1161,554,-1,579,560,994,-1,730,560,579,-1,556,564,561,-1,564,556,555,-1,996,1559,1558,-1,1125,1559,996,-1,1554,817,1556,-1,817,1554,818,-1,1562,799,801,-1,1223,799,1562,-1,15,7,24,-1,15,8,7,-1,728,1041,595,-1,728,722,1041,-1,1040,727,597,-1,1676,727,1040,-1,810,1681,1679,-1,1681,810,809,-1,1682,1032,1685,-1,1682,1686,1032,-1,725,1165,1031,-1,724,1165,725,-1,542,1162,9,-1,541,1162,542,-1,1680,1685,1684,-1,1682,1685,1680,-1,1679,1683,1677,-1,1679,1681,1683,-1,727,1678,1675,-1,727,1676,1678,-1,1674,722,728,-1,722,1674,720,-1,1006,1376,1163,-1,1006,1375,1376,-1,991,718,223,-1,718,991,990,-1,717,721,834,-1,716,721,717,-1,666,1663,664,-1,1663,666,1659,-1,686,1168,1179,-1,686,641,1168,-1,686,638,642,-1,686,685,638,-1,1622,1176,1655,-1,1622,1619,1176,-1,1598,1593,1597,-1,1593,1598,1592,-1,702,1070,1192,-1,1070,702,704,-1,1171,700,600,-1,1171,1175,700,-1,1048,582,1173,-1,598,582,1048,-1,1625,1610,1671,-1,1610,1625,1184,-1,659,1672,655,-1,659,1635,1672,-1,980,1670,1611,-1,980,1668,1670,-1,1666,1669,646,-1,1666,1665,1669,-1,692,1667,690,-1,692,1662,1667,-1,1659,1664,1663,-1,1659,1661,1664,-1,1660,814,816,-1,1656,814,1660,-1,602,1658,1655,-1,602,1657,1658,-1,1011,614,615,-1,668,614,1011,-1,609,815,814,-1,708,815,609,-1,707,1653,1654,-1,707,767,1653,-1,1651,758,760,-1,1651,1652,758,-1,1054,1650,1016,-1,1054,1648,1650,-1,1649,844,1647,-1,844,1649,845,-1,1640,829,1645,-1,829,1640,1637,-1,1896,1646,828,-1,1896,1634,1646,-1,630,711,713,-1,632,711,630,-1,626,1643,709,-1,628,1643,626,-1,1642,1589,1588,-1,1642,1644,1589,-1,627,1168,1169,-1,629,1168,627,-1,1604,1587,625,-1,1604,1605,1587,-1,1607,1590,1606,-1,1591,1590,1607,-1,672,699,713,-1,699,672,671,-1,1666,1012,690,-1,1666,1612,1012,-1,713,698,630,-1,713,699,698,-1,1641,1639,1134,-1,1637,1639,1641,-1,1640,1636,1638,-1,1635,1636,1640,-1,1179,684,686,-1,1179,689,684,-1,1633,1896,777,-1,1633,1629,1896,-1,682,1303,1369,-1,682,681,1303,-1,1884,680,682,-1,1884,1630,680,-1,1372,676,526,-1,1372,677,676,-1,679,678,832,-1,679,676,678,-1,1631,1896,1629,-1,1631,1634,1896,-1,1623,1630,1884,-1,1623,1628,1630,-1,1294,1626,1627,-1,1183,1626,1294,-1,1624,1395,1398,-1,1624,1582,1395,-1,981,647,644,-1,647,981,648,-1,671,673,675,-1,671,670,673,-1,667,1400,665,-1,1400,667,672,-1,1189,1403,1614,-1,1403,1189,1401,-1,1618,1405,1408,-1,1618,1615,1405,-1,1621,1407,695,-1,1621,1620,1407,-1,669,1619,661,-1,1176,1619,669,-1,1618,1622,1616,-1,1618,1620,1622,-1,1613,1615,1617,-1,1613,1614,1615,-1,670,1012,673,-1,1012,670,693,-1,661,1621,662,-1,661,1619,1621,-1,1611,981,980,-1,1611,1609,981,-1,655,656,659,-1,655,654,656,-1,1610,652,655,-1,1610,650,652,-1,1130,1190,1131,-1,1190,1130,1609,-1,656,1182,657,-1,656,982,1182,-1,1295,652,651,-1,652,1295,654,-1,1191,653,650,-1,1191,1070,653,-1,688,647,649,-1,688,1608,647,-1,646,1612,1666,-1,646,645,1612,-1,1181,1574,694,-1,1181,1595,1574,-1,1601,1606,1599,-1,1606,1601,1607,-1,1604,1603,1605,-1,1604,1193,1603,-1,1603,1600,1599,-1,1600,1603,1602,-1,1601,1597,1595,-1,1597,1601,1598,-1,1574,1594,1215,-1,1594,1574,1596,-1,703,1593,1592,-1,703,705,1593,-1,1578,635,1213,-1,635,1578,633,-1,1591,1588,1590,-1,1591,1178,1588,-1,626,629,627,-1,626,632,629,-1,625,1589,628,-1,1587,1589,625,-1,624,1365,1367,-1,624,623,1365,-1,1360,1584,1585,-1,1360,1575,1584,-1,619,616,620,-1,617,616,619,-1,615,608,618,-1,614,608,615,-1,1208,1213,1211,-1,1213,1208,1578,-1,1584,1397,1396,-1,1584,1583,1397,-1,1207,1581,1205,-1,1581,1207,1582,-1,1579,622,1580,-1,1579,623,622,-1,1368,525,1586,-1,525,1368,1370,-1,66,524,527,-1,524,66,1332,-1,1210,1577,1575,-1,1210,1212,1577,-1,605,503,1061,-1,605,475,503,-1,590,1038,591,-1,590,585,1038,-1,594,589,592,-1,589,594,593,-1,589,1572,590,-1,589,1573,1572,-1,585,1571,1038,-1,585,587,1571,-1,1219,1187,1154,-1,1219,1220,1187,-1,1549,75,545,-1,1549,1221,75,-1,987,47,577,-1,38,47,987,-1,1569,1568,1564,-1,1568,1569,1553,-1,1567,1228,1227,-1,1566,1228,1567,-1,1564,1565,1563,-1,1564,1568,1565,-1,1066,88,1550,-1,88,1066,1065,-1,571,575,572,-1,571,89,575,-1,1562,1560,1561,-1,1560,1562,1558,-1,1559,1555,1557,-1,1555,1559,1554,-1,988,557,559,-1,988,1556,557,-1,1549,544,1552,-1,1549,545,544,-1,1553,1566,1568,-1,1552,1566,1553,-1,1551,550,549,-1,90,550,1551,-1,552,1570,37,-1,552,1548,1570,-1,575,1546,738,-1,575,574,1546,-1,1226,1149,1547,-1,1226,989,1149,-1,808,1543,1545,-1,808,1128,1543,-1,1541,1544,1539,-1,1541,1542,1544,-1,1158,1540,1536,-1,1158,1538,1540,-1,1537,49,1159,-1,49,1537,1535,-1,1533,1828,1789,-1,1533,1530,1828,-1,1528,1532,1531,-1,1528,1527,1532,-1,1828,1524,1789,-1,1524,1828,1522,-1,1520,1523,1525,-1,1519,1523,1520,-1,1521,1516,1515,-1,1521,1518,1516,-1,1517,1338,59,-1,1517,1514,1338,-1,1509,1513,1512,-1,1509,1511,1513,-1,1506,1510,1504,-1,1510,1506,1508,-1,1507,1503,1505,-1,1507,1501,1503,-1,1698,1502,1142,-1,1698,1500,1502,-1,1498,1494,1493,-1,1498,1497,1494,-1,1495,1491,769,-1,1495,1492,1491,-1,1489,770,1490,-1,772,770,1489,-1,1488,762,773,-1,1488,1487,762,-1,1043,542,761,-1,542,1043,540,-1,536,1534,771,-1,536,538,1534,-1,52,1142,53,-1,52,1698,1142,-1,1586,524,1209,-1,1586,525,524,-1,1410,1209,1292,-1,1410,1586,1209,-1,970,319,968,-1,320,319,970,-1,522,72,523,-1,72,522,73,-1,506,510,509,-1,506,491,510,-1,513,1481,1231,-1,515,1481,513,-1,516,1478,1484,-1,516,514,1478,-1,479,1188,489,-1,479,478,1188,-1,1483,1486,1485,-1,1484,1486,1483,-1,1053,515,516,-1,1053,1052,515,-1,508,1230,1480,-1,508,509,1230,-1,1481,1052,1482,-1,1052,1481,515,-1,477,499,475,-1,477,496,499,-1,1478,495,497,-1,1478,1477,495,-1,1479,513,1476,-1,1479,514,513,-1,483,64,66,-1,485,64,483,-1,1220,64,485,-1,1220,481,64,-1,1477,479,495,-1,479,1477,480,-1,478,1155,1186,-1,478,480,1155,-1,1475,731,1218,-1,1475,1462,731,-1,972,482,1074,-1,482,972,531,-1,1474,1472,1469,-1,1472,1474,1473,-1,1471,111,871,-1,111,1471,1470,-1,112,1468,1465,-1,112,1467,1468,-1,887,469,1312,-1,469,887,470,-1,178,1466,175,-1,1466,178,110,-1,188,1464,471,-1,188,1353,1464,-1,885,1312,1264,-1,887,1312,885,-1,1429,175,1466,-1,175,1429,1311,-1,397,431,453,-1,397,1113,431,-1,171,1240,1244,-1,1240,171,172,-1,1268,1101,865,-1,1268,867,1101,-1,1448,473,457,-1,1448,420,473,-1,1347,418,1258,-1,1347,1348,418,-1,456,447,457,-1,456,445,447,-1,394,1461,1425,-1,1460,1461,394,-1,457,449,1448,-1,449,457,447,-1,1103,1107,860,-1,1103,1259,1107,-1,1458,1241,1457,-1,1241,1458,1240,-1,1255,1454,1248,-1,1255,443,1454,-1,445,450,447,-1,445,446,450,-1,1242,444,1250,-1,1242,442,444,-1,1456,395,1426,-1,1456,440,395,-1,439,1115,437,-1,439,1114,1115,-1,438,396,1427,-1,438,437,396,-1,1271,433,1272,-1,1271,94,433,-1,1897,163,1310,-1,163,1897,422,-1,1248,433,91,-1,433,1248,1454,-1,156,862,157,-1,862,156,861,-1,866,1106,864,-1,866,1105,1106,-1,170,1248,93,-1,170,1255,1248,-1,1349,460,419,-1,462,460,1349,-1,417,1451,1450,-1,1453,1451,417,-1,424,1452,1449,-1,424,423,1452,-1,1847,1270,1247,-1,1270,1847,393,-1,1448,1257,1256,-1,1257,1448,449,-1,1247,448,1847,-1,1247,1254,448,-1,419,1348,1349,-1,1348,419,418,-1,1442,403,1437,-1,1108,403,1442,-1,1266,389,388,-1,389,1266,1412,-1,1447,1445,888,-1,1447,1443,1445,-1,1446,413,1444,-1,1446,416,413,-1,387,857,1442,-1,854,857,387,-1,1439,856,1438,-1,1439,1440,856,-1,1420,1441,1419,-1,855,1441,1420,-1,405,1277,1438,-1,405,404,1277,-1,400,1437,403,-1,1439,1437,400,-1,402,1436,1106,-1,402,401,1436,-1,412,864,1102,-1,864,412,865,-1,878,875,874,-1,878,1098,875,-1,1433,1435,1431,-1,1434,1435,1433,-1,1429,1432,1428,-1,1430,1432,1429,-1,108,195,109,-1,194,195,108,-1,1427,107,435,-1,396,107,1427,-1,394,1426,395,-1,1425,1426,394,-1,1424,1249,1246,-1,1249,1424,1250,-1,442,430,1423,-1,430,442,1242,-1,1421,1096,353,-1,1421,1422,1096,-1,910,1422,849,-1,910,908,1422,-1,409,1110,1261,-1,409,392,1110,-1,352,409,381,-1,352,392,409,-1,386,376,378,-1,376,386,385,-1,354,1096,1095,-1,354,353,1096,-1,914,332,391,-1,337,332,914,-1,365,372,374,-1,372,365,370,-1,1455,372,371,-1,1455,373,372,-1,1253,375,373,-1,1253,1459,375,-1,907,1413,143,-1,906,1413,907,-1,1413,906,1326,-1,142,1416,1281,-1,142,144,1416,-1,199,366,200,-1,366,199,1308,-1,1358,1289,201,-1,1358,1356,1289,-1,363,367,365,-1,363,362,367,-1,922,1415,920,-1,922,338,1415,-1,934,925,932,-1,925,934,937,-1,1413,355,357,-1,1413,1326,355,-1,382,353,352,-1,1421,353,382,-1,1288,853,1412,-1,1288,1109,853,-1,348,358,1112,-1,348,349,358,-1,99,1287,349,-1,99,1261,1287,-1,927,338,330,-1,1415,338,927,-1,915,336,337,-1,915,1411,336,-1,927,336,929,-1,927,330,336,-1,1331,209,1306,-1,209,1331,328,-1,1410,977,1366,-1,1410,978,977,-1,320,71,319,-1,70,71,320,-1,695,1409,697,-1,695,1407,1409,-1,1408,1402,1406,-1,1408,1405,1402,-1,1401,1404,1403,-1,1404,1401,712,-1,672,710,1400,-1,710,672,713,-1,1397,1398,1395,-1,1399,1398,1397,-1,1206,1304,1396,-1,1206,974,1304,-1,1414,962,1391,-1,1414,1082,962,-1,313,303,302,-1,313,1084,303,-1,1082,1394,1378,-1,1082,1414,1394,-1,305,943,1393,-1,943,305,308,-1,1204,945,203,-1,1204,1201,945,-1,951,1077,1392,-1,949,1077,951,-1,960,964,966,-1,961,964,960,-1,220,310,958,-1,220,219,310,-1,312,956,946,-1,312,302,956,-1,1390,285,284,-1,298,285,1390,-1,296,1390,1029,-1,296,298,1390,-1,290,289,301,-1,289,290,287,-1,281,1388,621,-1,1388,281,282,-1,1387,1298,283,-1,1387,1385,1298,-1,1387,1893,1386,-1,1387,1892,1893,-1,1384,270,280,-1,1384,271,270,-1,279,269,277,-1,279,270,269,-1,1027,278,1299,-1,1027,277,278,-1,580,273,584,-1,580,274,273,-1,257,967,41,-1,1883,967,257,-1,1062,965,986,-1,965,1062,1383,-1,246,235,1080,-1,235,246,236,-1,254,963,1382,-1,963,254,256,-1,1024,255,254,-1,255,1024,947,-1,1046,1049,1381,-1,1049,1046,1025,-1,249,253,205,-1,252,253,249,-1,976,1882,1885,-1,1882,976,1379,-1,1380,1373,1364,-1,1380,975,1373,-1,1378,1083,1082,-1,1083,1378,1285,-1,311,218,1081,-1,311,219,218,-1,1883,318,967,-1,1079,318,1883,-1,1080,241,1081,-1,1080,235,241,-1,360,243,359,-1,360,242,243,-1,241,238,239,-1,241,240,238,-1,227,1890,228,-1,227,222,1890,-1,1376,990,1374,-1,1376,718,990,-1,1890,221,1375,-1,221,1890,222,-1,1083,963,962,-1,1083,1286,963,-1,1372,1303,677,-1,1372,1369,1303,-1,1371,1368,1365,-1,1370,1368,1371,-1,1364,977,1362,-1,977,1364,1373,-1,1363,215,1296,-1,215,1363,216,-1,1585,1361,1360,-1,1885,1361,1585,-1,214,211,116,-1,214,1307,211,-1,1093,1359,1091,-1,1093,919,1359,-1,1306,208,1090,-1,1306,209,208,-1,1092,931,1291,-1,931,1092,1307,-1,607,206,618,-1,607,207,206,-1,1357,201,83,-1,1358,201,1357,-1,1356,115,1289,-1,1356,1355,115,-1,1316,174,1313,-1,174,1316,1315,-1,196,175,1311,-1,196,176,175,-1,1354,105,193,-1,1354,106,105,-1,1352,106,1354,-1,1352,103,106,-1,187,103,1352,-1,187,101,103,-1,1351,186,1262,-1,1351,189,186,-1,1350,1262,1264,-1,1350,1351,1262,-1,184,1264,1312,-1,184,1350,1264,-1,173,182,1314,-1,185,182,173,-1,462,1313,461,-1,462,1316,1313,-1,1346,95,1318,-1,1346,1310,95,-1,1344,1310,1346,-1,1344,1897,1310,-1,1897,1343,1233,-1,1343,1897,1344,-1,181,1233,1343,-1,181,179,1233,-1,178,181,466,-1,181,178,177,-1,863,167,171,-1,863,1320,167,-1,170,1321,165,-1,93,1321,170,-1,155,159,151,-1,155,157,159,-1,139,102,350,-1,1324,102,139,-1,133,907,147,-1,133,132,907,-1,1323,135,897,-1,1323,136,135,-1,141,1112,358,-1,141,350,1112,-1,1342,898,899,-1,1342,1325,898,-1,1341,136,1340,-1,1341,137,136,-1,133,1339,134,-1,133,148,1339,-1,1322,131,1329,-1,131,1322,104,-1,125,123,122,-1,123,125,127,-1,117,952,118,-1,117,217,952,-1,78,39,42,-1,78,74,39,-1,55,1338,56,-1,1333,1338,55,-1,51,77,57,-1,51,543,77,-1,74,40,39,-1,74,76,40,-1,44,34,40,-1,44,35,34,-1,35,577,31,-1,35,987,577,-1,1337,18,20,-1,1337,26,18,-1,27,1336,28,-1,27,1002,1336,-1,22,1334,23,-1,22,1063,1334,-1,1064,1334,1063,-1,1064,1336,1334,-1,24,16,15,-1,24,21,16,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lhumrus_Coord',point=[(8.24568,37.20182,-1.22764),(8.26605,37.19452,-1.28062),(8.28979,37.25941,-1.29361),(8.17304,37.04512,-1.27069),(8.27957,37.20227,-1.34542),(8.13767,37.22376,-1.11403),(8.11423,37.06327,-1.15854),(8.07574,36.93948,-1.25595),(8.07489,36.94933,-1.35047),(7.71339,37.11368,-1.76322),(7.72837,37.064,-1.70881),(7.7078,37.06627,-1.71016),(7.92567,36.89024,-1.41761),(7.89051,36.88034,-1.41647),(7.84563,36.89001,-1.47923),(8.00425,36.92723,-1.37929),(7.95678,36.93676,-1.44477),(8.05806,36.97136,-1.44418),(7.74727,37.18606,-1.77515),(7.73924,37.17737,-1.78897),(7.72826,37.24629,-1.81958),(7.93686,36.92615,-1.42522),(7.83797,36.94631,-1.55021),(7.87154,36.96069,-1.52634),(7.97439,36.91555,-1.36878),(7.95694,36.88404,-1.36055),(7.88841,37.19833,-1.73323),(7.89147,37.13726,-1.68298),(7.77172,37.12866,-1.73472),(7.78341,36.89143,-1.49801),(7.77752,36.9472,-1.56821),(7.83929,38.0945,-1.41762),(7.90384,38.14701,-1.46297),(7.80736,38.2122,-1.43751),(7.77369,38.04312,-1.39668),(7.78957,37.98633,-1.39627),(7.81656,37.79977,-1.33817),(7.82134,37.7594,-1.28661),(7.87923,37.84619,-1.35532),(7.59999,38.05856,-1.30961),(7.66062,38.00124,-1.34787),(7.71112,38.21477,-1.41059),(7.52402,38.10839,-1.29187),(7.81314,37.88639,-1.36779),(7.72953,37.93439,-1.36751),(7.90034,37.76975,-1.27569),(7.94509,37.75092,-1.27124),(7.95417,37.83209,-1.34296),(7.86231,37.76607,-1.28926),(7.65188,37.62489,-1.15013),(7.65243,37.64042,-1.18175),(7.61461,37.61602,-1.18301),(7.42325,37.6457,-1.1646),(7.46091,37.66712,-1.16953),(7.43225,37.66891,-1.22151),(7.56582,37.67058,-1.19278),(7.56783,37.6086,-1.17616),(7.58341,37.66834,-1.19899),(7.59239,37.61326,-1.17667),(7.48024,37.62423,-1.13508),(7.48069,37.67713,-1.16264),(7.51312,37.78278,-1.21906),(7.48302,37.7719,-1.20802),(7.49195,37.67977,-1.16249),(6.98953,37.67431,-1.39713),(7.11321,37.76995,-1.37445),(6.95564,37.78376,-1.30231),(7.33257,37.85118,-1.30368),(7.29149,37.92756,-1.32936),(7.27688,37.80985,-1.34986),(7.33579,38.03992,-1.264),(7.39353,38.06021,-1.24527),(7.35318,37.83901,-1.28257),(7.40817,37.83427,-1.25709),(7.59834,37.82042,-1.25016),(7.70676,37.70367,-1.25563),(7.65787,37.81465,-1.30254),(7.64497,37.66839,-1.21557),(7.5629,37.80755,-1.22952),(7.44186,41.89093,-1.50733),(7.41375,42.86201,-1.49119),(7.45875,42.87302,-1.32654),(6.87394,41.79499,-1.18647),(6.73123,41.80698,-1.2851),(6.77072,40.70023,-1.42097),(8.05002,37.61856,-.96087),(8.0676,37.56403,-.91995),(8.09036,37.59383,-.96379),(7.91822,37.72916,-1.16143),(7.95515,37.71957,-1.16432),(7.90211,37.72917,-1.23615),(6.77725,49.10752,-.24538),(6.7652,49.11062,-.28103),(6.73823,49.24988,-.29359),(6.80257,48.92218,-.24839),(6.62578,49.44117,-.3328),(6.71138,49.40003,-.36958),(6.66799,49.46774,-.36569),(6.98109,49.29105,-1.54403),(6.91274,49.09912,-1.62892),(6.90225,49.14591,-1.67788),(6.36934,48.60668,-1.84119),(6.24895,48.38095,-1.67201),(6.114,48.42898,-1.66711),(6.01139,48.27978,-1.29509),(5.85303,48.35445,-1.05594),(5.92809,48.33841,-1.39228),(6.26657,48.36071,-.50377),(6.06652,48.55995,-.55916),(6.10998,48.4224,-.71531),(6.11772,49.00833,-.33863),(6.23469,49.37483,-.38332),(6.04148,49.16079,-.45927),(6.71733,41.83492,-1.68246),(6.68286,40.69256,-1.53362),(6.65608,41.8172,-1.39583),(7.13401,41.80881,-1.08653),(7.13077,40.69483,-1.17931),(7.18011,40.70153,-1.19783),(6.8507,37.53043,-1.17819),(6.92206,37.55646,-1.24371),(6.88038,37.59324,-1.22589),(7.01602,49.5513,-.76381),(7.02009,49.54969,-.8083),(6.92737,49.5468,-.81754),(7.05079,49.51971,-.75063),(7.16468,49.28961,-.74064),(7.06216,49.51601,-.79391),(6.60623,46.26836,-1.53089),(6.6976,46.26335,-1.60663),(6.71235,45.18973,-1.66015),(6.04909,48.28688,-1.40779),(6.29413,47.64648,-1.23974),(6.28271,47.693,-1.23702),(6.33121,47.64569,-1.34299),(6.50378,47.71474,-1.54139),(6.51517,47.66792,-1.53906),(6.42284,47.65121,-1.46289),(6.49422,48.26073,-1.65535),(6.45165,48.37562,-1.7157),(6.77724,48.64913,-1.6418),(6.4885,48.49458,-1.74161),(6.30689,47.79631,-.93324),(6.32906,47.68344,-.96205),(6.38496,47.73351,-.75002),(5.99635,48.30434,-1.05739),(6.11427,48.22533,-1.03705),(6.25508,47.82063,-1.09146),(6.24417,47.8197,-1.25361),(6.81658,49.31099,-.39919),(6.86819,49.14863,-.38166),(6.87089,49.35737,-.40077),(6.74103,49.41925,-.38312),(6.82904,49.40506,-.43771),(6.82238,49.45415,-.48901),(6.92798,49.35923,-.40573),(6.9883,49.39442,-.44613),(6.9244,49.42225,-.44271),(6.9791,49.32675,-.41234),(6.87828,49.4189,-.44257),(6.89939,49.487,-.58992),(6.67553,49.35135,-.3424),(6.65974,49.3727,-.35365),(6.60511,49.34273,-.33775),(6.69775,49.34739,-.34778),(6.7095,49.32297,-.33611),(6.7167,49.33923,-.35859),(6.73498,49.32983,-.36396),(6.64076,49.30888,-.30426),(6.68672,49.21889,-.2497),(6.72866,49.24114,-.27061),(6.75787,49.2576,-.37245),(6.74049,49.25465,-.36009),(6.92525,49.57444,-.8084),(6.85038,49.5486,-.61069),(6.03812,48.73945,-.44542),(6.05685,48.72468,-.44472),(6.17037,48.97409,-.3178),(6.16309,48.97903,-.31996),(6.34868,49.2155,-.30408),(6.20537,48.95415,-.33582),(6.3327,49.23424,-.29823),(6.99461,49.55999,-1.07502),(7.01748,49.39109,-1.4169),(7.01265,49.41302,-1.42937),(6.98931,49.52233,-1.05658),(6.63337,48.91552,-1.89558),(6.35451,48.62935,-1.86459),(6.34008,48.64999,-1.87966),(6.64461,48.89636,-1.87055),(5.79734,48.37112,-1.06404),(5.89637,48.47178,-.74681),(5.87724,48.48313,-.75369),(5.82363,48.36086,-1.06022),(5.99231,48.57094,-.5759),(5.9169,48.46196,-.73511),(5.96585,48.57502,-.57921),(6.09786,48.70128,-.4531),(6.60427,43.95601,-1.29101),(6.60572,43.95285,-1.25118),(6.555,45.11221,-1.16946),(6.68857,41.80871,-1.29836),(6.67766,38.79673,-1.76372),(6.66347,38.80121,-1.71118),(6.76713,39.51747,-1.7047),(6.56016,38.23921,-1.78873),(6.52885,38.05551,-1.82796),(6.47615,38.06884,-1.81011),(7.23777,46.25168,-.73359),(7.26384,46.25867,-.76672),(7.25178,47.27617,-.71516),(7.20082,42.88547,-.95123),(7.15557,42.88829,-.96561),(7.22027,40.71609,-1.22101),(7.21266,41.82134,-1.10189),(7.04264,38.8113,-1.27681),(7.10904,38.81955,-1.25205),(7.14863,39.55246,-1.24083),(8.07668,38.53226,-1.72681),(8.0283,38.65968,-1.76683),(7.9539,38.64758,-1.69375),(8.30935,37.38673,-1.34594),(8.31909,37.53659,-1.37161),(8.29064,37.39793,-1.26355),(8.07175,37.59886,-1.79779),(8.18298,37.66312,-1.64932),(8.06123,37.44016,-1.71688),(8.31753,37.66862,-1.42801),(8.28703,37.74145,-1.53213),(8.29702,37.75351,-1.46529),(8.29727,37.6805,-1.37904),(8.28602,37.76237,-1.41328),(8.07797,38.15985,-1.91546),(8.01691,38.33542,-1.93968),(8.10299,38.20508,-1.91111),(8.12947,38.36841,-1.75881),(8.17572,38.20228,-1.7246),(8.17796,38.23315,-1.80272),(8.0923,38.29259,-1.90471),(8.03707,38.40857,-1.91808),(8.14185,38.31244,-1.83349),(8.09933,38.42318,-1.83371),(8.18583,38.14342,-1.81182),(8.18702,38.04225,-1.77378),(8.23269,38.0072,-1.54603),(8.1792,37.95738,-1.74514),(8.15795,38.27744,-1.64677),(6.51092,38.24073,-1.76299),(6.55639,38.34911,-1.7598),(6.59135,38.35014,-1.78652),(6.82175,38.35911,-1.8706),(6.81374,38.25748,-1.85571),(6.68031,38.35299,-1.82531),(6.67933,38.23492,-1.8261),(7.73388,38.19339,-1.9779),(7.62998,38.33346,-1.95799),(7.70715,38.33724,-1.98854),(7.69017,38.35558,-1.43611),(7.14739,37.65794,-1.43779),(7.06757,37.66443,-1.45996),(7.11574,37.7357,-1.47853),(7.16776,37.72153,-1.47053),(7.18619,37.78206,-1.50109),(7.06609,37.77539,-1.50195),(7.10551,37.80874,-1.52951),(7.14099,37.83061,-1.54658),(7.18238,37.84541,-1.55864),(7.2328,37.83693,-1.55432),(7.26692,37.81566,-1.53844),(7.25913,37.7704,-1.50847),(7.23875,37.74498,-1.48987),(7.20476,37.7273,-1.47609),(7.01819,37.68408,-1.47742),(6.95088,37.73942,-1.53975),(7.01982,37.82174,-1.57971),(7.19283,37.9118,-1.61885),(7.28184,37.87915,-1.6296),(7.33542,37.75487,-1.51965),(7.3554,37.81992,-1.62184),(7.30577,37.71924,-1.49092),(7.28076,37.68938,-1.46684),(6.84645,38.0616,-1.84942),(7.00915,38.07598,-1.78983),(7.34307,38.00302,-1.80322),(7.46217,37.93678,-1.86948),(7.47639,37.83289,-1.72923),(7.32915,37.91984,-1.70373),(7.54704,37.43565,-1.77068),(7.46973,37.35926,-1.70423),(7.46663,37.51958,-1.64369),(7.58731,37.50529,-1.80538),(7.62958,37.5554,-1.88219),(7.63479,37.46505,-1.8564),(7.43894,37.58088,-1.59833),(7.40497,37.6554,-1.53944),(7.48692,37.60801,-1.64296),(7.53087,37.71341,-1.70165),(7.44954,37.71759,-1.57421),(7.50985,37.77548,-1.71028),(7.71811,37.51076,-1.92996),(7.53728,37.64419,-1.70476),(7.50704,37.59371,-1.67042),(7.15912,38.82006,-1.91489),(6.8441,38.80103,-1.90489),(7.16253,39.51011,-1.9466),(6.72045,38.60255,-1.51608),(6.851,38.60335,-1.40469),(6.87245,38.80427,-1.37916),(6.75829,38.79768,-1.53426),(7.92967,38.86212,-1.8444),(7.93612,38.86728,-1.76818),(8.00105,38.64526,-1.84745),(7.18384,38.60475,-1.90715),(7.11237,38.60661,-1.90099),(6.32452,37.64226,-1.4852),(6.32089,37.69102,-1.51786),(6.28588,37.63103,-1.52269),(6.68233,38.58913,-1.82374),(7.34679,38.23922,-1.26111),(7.29952,38.17495,-1.25621),(7.28262,38.12707,-1.26927),(7.19346,38.07106,-1.31073),(7.61498,39.61135,-1.69437),(7.44239,40.72896,-1.55153),(7.49414,39.60172,-1.54931),(7.44883,43.98577,-1.09237),(7.44573,43.98182,-1.02347),(7.35197,42.88125,-1.03122),(7.32462,46.27354,-.95787),(7.36343,47.29469,-.89772),(7.23929,45.17547,-1.66241),(7.18474,46.28153,-1.59733),(7.26372,46.28982,-1.54707),(6.82303,46.2089,-.7935),(6.89615,45.11292,-.87625),(6.92788,46.21043,-.75394),(7.33904,45.18325,-1.53973),(7.30509,46.29001,-1.43661),(7.04746,45.15497,-1.74038),(7.05904,46.26834,-1.67733),(7.24088,49.05898,-1.54058),(7.08226,49.18996,-1.53634),(7.09807,49.22678,-1.47096),(6.99238,49.5012,-.99818),(7.0712,49.32398,-1.35844),(7.02847,49.37062,-1.40714),(7.04816,49.25547,-1.4939),(6.99637,49.2567,-1.52459),(6.67673,48.82124,-1.74949),(6.73223,48.79162,-1.70124),(6.40801,48.49487,-1.78238),(7.02931,49.43695,-1.11589),(7.01594,48.71899,-1.64285),(6.96081,48.44226,-1.62481),(6.87527,48.51923,-1.6392),(6.49886,46.27889,-1.3128),(6.56341,45.1451,-1.4258),(6.50631,46.26743,-1.24854),(6.60697,48.64659,-1.73516),(8.1118,38.03212,-1.89527),(8.1405,38.128,-1.87764),(6.45294,47.73122,-.61542),(6.47026,47.31897,-.76023),(6.49123,47.31977,-.73627),(6.42717,47.73388,-.66415),(6.5825,46.20539,-.88425),(6.61061,45.10514,-1.06407),(6.54269,46.2115,-.93483),(6.89487,47.31995,-.64912),(6.8192,47.31627,-.63896),(6.64593,46.20631,-.86032),(6.71276,47.31606,-.65759),(6.59959,47.31619,-.67734),(6.55357,47.73529,-.57887),(6.51605,47.32156,-.71589),(6.47809,47.72944,-.59609),(7.36911,48.68452,-1.39438),(7.3169,48.3886,-1.44111),(7.30916,48.62515,-1.53441),(7.39077,48.4518,-1.32176),(7.38061,48.20952,-1.24143),(7.09226,48.75629,-1.63792),(7.23487,48.6263,-1.59863),(7.2483,48.69317,-1.59628),(7.3297,48.77175,-1.52813),(7.3603,48.74771,-1.42486),(7.32425,48.69937,-1.53036),(7.24174,49.1152,-1.05903),(7.29872,49.01165,-1.22529),(7.23077,49.13129,-1.16466),(7.17503,47.30081,-1.45711),(7.27893,47.29504,-1.34214),(6.92859,48.85114,-1.64406),(6.49483,48.4767,-.19433),(6.43367,48.47471,-.20799),(6.41811,48.31238,-.28358),(6.25645,48.49438,-.45061),(6.85611,48.5847,-.36741),(6.86674,48.81877,-.3846),(6.83316,48.79295,-.34544),(7.33991,48.74621,-.71724),(7.17845,48.93934,-.48031),(7.22043,48.73136,-.52131),(7.27533,48.94348,-.696),(7.31848,48.95985,-1.19887),(7.36007,48.81851,-1.22561),(7.37259,48.82117,-1.27885),(7.09274,49.10562,-1.62209),(7.25513,48.86863,-1.57419),(6.99356,48.8984,-1.62929),(6.95783,49.047,-.37998),(6.89903,49.00746,-.40048),(6.94312,48.86946,-.41621),(6.4174,49.64977,-1.57866),(6.23302,49.6178,-1.54529),(6.25839,49.64576,-1.50458),(6.37512,49.57998,-1.64871),(6.52006,49.59997,-.45275),(6.59724,49.50661,-.34495),(6.6265,49.5273,-.35961),(6.54345,49.23881,-.26251),(6.59917,49.26368,-.26738),(6.54542,49.32162,-.31414),(6.19276,49.72548,-.99471),(6.22198,49.74773,-1.002),(6.14046,49.6895,-1.17396),(7.03786,49.47717,-.98336),(7.07813,49.46899,-.93697),(7.14677,49.31442,-1.10487),(6.83155,48.5729,-.27338),(6.83155,48.56505,-.25457),(6.82823,48.39772,-.32322),(6.82856,48.57757,-.28611),(6.81833,48.92236,-.21743),(6.27437,48.2692,-.53559),(6.30987,48.34009,-.4076),(6.32819,48.23289,-.4643),(6.24634,48.62805,-.39746),(6.32102,48.6405,-.28725),(6.32735,48.73427,-.26953),(6.42417,48.18707,-.35962),(6.4634,48.19493,-.353),(6.81112,48.71726,-.13987),(6.78412,48.90447,-.11682),(6.67881,48.68951,-.14165),(6.40712,48.88918,-.18154),(6.40243,48.76705,-.18265),(6.46599,48.93879,-.14466),(6.59433,48.86126,-.094),(6.58643,49.01764,-.13605),(6.4878,48.80684,-.12438),(6.93293,49.2002,-.38683),(6.7804,47.90633,-.51235),(6.85825,48.36131,-.3703),(6.81289,48.29657,-.34887),(6.86223,47.9408,-.54993),(6.40142,48.98019,-.21719),(6.44558,49.04477,-.1983),(6.37021,49.17639,-.31811),(6.83034,49.64968,-.61792),(6.67901,49.55734,-.39545),(6.8413,49.60445,-.61124),(6.70118,49.51793,-.38142),(6.30579,49.26654,-.29936),(6.46713,49.37357,-.28231),(6.45878,49.40689,-.29),(6.3263,49.24088,-.2998),(6.90932,49.66907,-.81647),(6.92327,49.63419,-.80442),(6.99529,49.59272,-1.08832),(6.98067,49.61988,-1.11993),(6.31045,48.70751,-1.88823),(6.60362,48.94938,-1.9125),(6.47471,49.23597,-.28991),(6.48705,49.27384,-.30059),(6.73852,37.42273,-1.00924),(6.8201,37.39913,-.99447),(6.84291,37.43483,-1.03625),(6.94045,37.47914,-1.16586),(6.92184,37.4572,-1.14227),(6.97971,37.45269,-1.16218),(7.03456,37.63403,-1.3882),(7.13342,37.72547,-1.38786),(6.92076,37.72837,-1.33386),(6.9434,37.64265,-1.35715),(6.96307,37.66246,-1.40042),(6.77666,37.46701,-1.11967),(6.81352,37.46433,-1.12844),(6.78384,37.48093,-1.12545),(6.87282,37.4608,-1.12954),(6.81736,37.48605,-1.13412),(7.23738,37.5171,-1.16545),(7.28749,37.55573,-1.15849),(7.23898,37.52095,-1.1755),(7.2869,37.5484,-1.15038),(6.91501,37.45854,-1.12414),(6.86413,37.46193,-1.08681),(6.9069,37.45392,-1.10195),(6.86714,37.4621,-1.10765),(6.78771,37.46109,-1.07682),(6.79846,37.4666,-1.09863),(6.74747,37.46375,-1.0741),(6.63841,37.38707,-1.09635),(6.71087,37.43183,-1.02908),(7.19405,37.49003,-1.20608),(7.18981,37.48672,-1.19102),(7.25439,37.51175,-1.14529),(7.27923,37.51326,-1.1327),(7.22156,37.43966,-1.11603),(7.20169,37.45254,-1.14137),(7.19218,37.48044,-1.17879),(7.16005,37.47183,-1.17833),(7.16522,37.46626,-1.20527),(7.09741,37.45042,-1.16499),(7.03067,37.44745,-1.15247),(7.09307,37.39892,-1.12807),(7.02296,37.40796,-1.10672),(7.20491,37.99337,-1.3371),(7.19491,37.79857,-1.37224),(7.35136,37.62193,-1.30098),(7.26087,37.57989,-1.38753),(7.26819,37.57252,-1.3254),(7.38945,37.65624,-1.28079),(7.34447,37.64423,-1.31157),(6.92242,37.87414,-1.26532),(6.90023,37.88716,-1.26064),(6.8554,37.79759,-1.25876),(6.87464,37.79188,-1.2692),(7.1409,37.80143,-1.37317),(7.17389,37.82345,-1.36807),(7.15346,37.76683,-1.37931),(7.18584,37.72087,-1.38688),(7.30507,37.66775,-1.33275),(7.70394,36.99297,-1.62792),(7.69873,36.92635,-1.56824),(7.6874,36.9198,-1.56977),(7.62959,36.832,-1.42655),(7.6787,36.85769,-1.48764),(7.65723,36.8396,-1.41759),(7.65805,36.85549,-1.49174),(7.63968,37.12775,-1.74821),(7.66728,37.17908,-1.79727),(7.67798,37.12036,-1.765),(7.65862,37.63617,-1.20427),(7.71728,37.68264,-1.22131),(7.71968,37.67449,-1.23726),(7.72403,36.99379,-1.03962),(7.71266,36.9918,-1.05296),(7.72666,36.946,-1.11588),(7.86169,37.72939,-1.26663),(7.89877,37.71769,-1.25522),(7.70849,37.82625,-1.33139),(7.77492,37.74235,-1.28007),(7.93468,37.70895,-1.24228),(8.13376,37.56287,-1.01686),(8.13422,37.51079,-.94815),(8.15048,37.50216,-.99745),(8.17452,37.385,-.90839),(8.12115,37.47953,-.90409),(8.13061,37.40326,-.87801),(8.17257,37.46585,-1.0585),(8.17097,37.43722,-.97464),(8.17977,37.40996,-1.04013),(8.18163,37.3914,-.99449),(8.15663,37.45521,-.93351),(8.00441,36.85719,-1.21776),(7.93912,36.87292,-1.35433),(8.02918,36.86392,-1.21263),(8.1135,37.63495,-1.22977),(8.08045,37.63241,-1.14051),(8.13502,37.57944,-1.10273),(7.98792,37.69663,-1.17465),(8.03753,37.67935,-1.08022),(8.0636,37.6563,-1.10621),(7.97907,37.70132,-1.06927),(8.00373,37.69275,-1.07042),(8.14782,37.75272,-1.30254),(7.93988,37.95354,-1.4103),(8.09701,37.9887,-1.44874),(8.1975,37.52581,-1.25446),(6.9369,37.83373,-1.6289),(6.73812,37.68776,-1.63569),(6.7328,37.73913,-1.68356),(6.73683,37.66768,-1.61563),(6.84255,37.70355,-1.57769),(7.24813,37.58731,-1.42877),(7.32689,37.63519,-1.45959),(7.33107,37.62146,-1.46053),(7.2432,37.60443,-1.43451),(7.00563,37.58246,-1.4473),(7.12828,37.57342,-1.41264),(7.13086,37.54766,-1.44172),(7.009,37.5556,-1.4692),(6.92999,37.61494,-1.47365),(6.93115,37.58451,-1.49757),(6.85448,37.32027,-1.81076),(6.91978,37.40084,-1.64498),(6.89881,37.28883,-1.78124),(6.73719,37.79869,-1.75416),(6.74604,37.85092,-1.82872),(6.63891,37.73047,-1.83247),(6.65921,37.82256,-1.85731),(6.51074,37.54257,-1.84342),(6.61104,37.56964,-1.81012),(6.60705,37.52608,-1.81001),(6.70222,37.37246,-.97006),(6.41376,38.027,-1.7962),(6.45033,38.0029,-1.81732),(6.40646,37.95188,-1.82692),(6.61618,37.36818,-1.8329),(6.66962,37.44781,-1.80172),(6.77622,37.30248,-1.80473),(7.09574,37.92542,-1.30644),(6.35194,37.87648,-1.83612),(6.41927,37.86984,-1.85086),(6.51968,37.88548,-1.85294),(6.65537,37.95527,-1.86439),(6.65726,37.88892,-1.86085),(6.52308,37.9703,-1.83976),(6.68821,37.89721,-1.85812),(6.71791,37.97186,-1.85894),(6.85078,37.968,-1.80789),(6.62486,37.9619,-1.35739),(6.64676,37.96119,-1.34121),(6.65687,38.04273,-1.36307),(6.06804,37.30112,-1.81785),(6.10021,37.23682,-1.81526),(6.08211,37.23969,-1.7904),(6.08907,37.29982,-1.83723),(6.1044,37.17027,-1.76283),(6.14609,37.11093,-1.75304),(6.13086,37.11028,-1.73931),(6.12066,37.1693,-1.7838),(6.23722,37.79216,-1.83363),(6.15912,37.71593,-1.8258),(6.22451,37.79544,-1.80415),(6.16194,37.69724,-1.84758),(6.13838,37.2394,-1.58603),(6.13734,37.16523,-1.59215),(6.18073,37.14289,-1.51612),(6.09353,37.24412,-1.6437),(6.09544,37.18145,-1.70337),(6.10229,37.18641,-1.66045),(6.06651,37.24515,-1.71145),(6.31028,36.99769,-1.59642),(6.31595,36.9926,-1.61484),(6.36827,36.9925,-1.57942),(6.26243,37.00195,-1.61035),(6.2539,36.98618,-1.58443),(6.21543,37.00609,-1.62394),(6.26981,37.33144,-1.40172),(6.22733,37.23131,-1.4626),(6.26667,37.21867,-1.42283),(6.22614,37.33845,-1.43371),(6.26114,37.18695,-1.41897),(6.31304,37.20559,-1.38687),(6.26787,37.10376,-1.44963),(6.27446,37.06852,-1.47186),(6.3236,37.03446,-1.45259),(6.31984,37.09101,-1.42828),(6.28537,37.80704,-1.84665),(6.36521,37.71107,-1.87708),(6.29841,37.71607,-1.87452),(6.35961,37.79441,-1.86239),(6.36554,37.13515,-1.78589),(6.31704,37.22081,-1.84803),(6.37885,37.23564,-1.84858),(6.30355,37.12411,-1.77635),(6.42692,37.787,-1.87318),(6.43133,37.70793,-1.8724),(6.29418,37.0748,-1.72756),(6.23931,37.07833,-1.74436),(6.24418,37.12227,-1.77529),(6.28921,37.04393,-1.70424),(6.28458,37.02998,-1.6895),(6.23502,37.03211,-1.70839),(6.82251,37.63917,-1.19043),(6.72356,37.64789,-1.18825),(6.8062,37.56566,-1.15949),(6.85186,37.63166,-1.18943),(6.61362,37.66342,-1.26511),(6.63259,37.66109,-1.23044),(6.62717,37.79811,-1.29748),(6.66054,37.52768,-1.14523),(6.16067,37.07605,-1.64676),(6.14482,37.13882,-1.60799),(6.11923,37.138,-1.67941),(6.15699,37.07621,-1.71715),(6.22747,37.00466,-1.66602),(6.15109,37.07641,-1.70657),(6.40083,37.0737,-1.68736),(6.35586,37.11472,-1.7496),(6.41161,37.10958,-1.7339),(6.34554,37.07329,-1.70947),(6.15802,37.71759,-1.79409),(6.21374,37.61844,-1.88335),(6.20109,37.72289,-1.86048),(6.15967,37.61729,-1.87493),(6.17713,37.07876,-1.73065),(6.20667,37.0805,-1.74029),(6.51599,37.67596,-1.85719),(6.51695,37.71721,-1.85595),(6.20368,37.54118,-1.50469),(6.1271,37.4735,-1.51607),(6.17434,37.45141,-1.45411),(6.16344,37.56271,-1.54449),(6.67556,37.16888,-1.76633),(6.63126,37.18889,-1.78356),(6.61493,37.28193,-1.82805),(6.14778,37.24516,-1.83865),(6.1969,37.1916,-1.81411),(6.16427,37.18015,-1.80706),(6.19411,37.24837,-1.85372),(6.19074,37.11385,-1.76588),(6.72184,37.23395,-1.80186),(6.7527,37.21282,-1.80889),(6.73702,37.12661,-1.78038),(6.71922,37.04078,-1.7597),(8.30932,37.36035,-1.33596),(6.76436,37.19818,-1.83807),(6.78197,37.08388,-1.85612),(6.75467,37.09061,-1.84858),(6.791,37.19692,-1.84073),(7.46708,37.14638,-1.6767),(7.46652,37.21112,-1.6778),(7.46904,37.28276,-1.67185),(7.6761,37.24298,-1.83666),(6.89163,37.185,-1.79863),(6.84639,37.20414,-1.84871),(8.11015,37.57215,-.97168),(8.15336,37.52264,-1.08062),(7.18124,37.54312,-1.34488),(7.14465,37.47012,-1.23246),(7.16793,37.47039,-1.22808),(7.13501,37.4521,-1.21263),(7.62253,37.5472,-1.12169),(7.60105,37.53204,-1.14532),(8.08588,37.63516,-1.00302),(8.03636,37.6595,-.99676),(7.93073,36.93244,-1.00202),(7.9409,36.8769,-1.10783),(7.95963,36.93187,-1.00245),(7.148,37.40683,-1.57861),(7.12194,37.40169,-1.58178),(7.67103,37.05787,-1.03655),(7.6832,36.99567,-1.07391),(7.69791,37.055,-1.00791),(7.69711,36.94826,-1.12988),(7.71066,36.90473,-1.19974),(7.71767,36.89509,-1.25743),(7.74333,36.90208,-1.18975),(7.7519,36.89926,-1.25224),(7.71711,36.87504,-1.49767),(7.72652,36.944,-1.56983),(7.73741,36.88632,-1.50261),(7.75543,37.00148,-1.63314),(7.72587,37.00283,-1.63021),(6.67691,37.00171,-1.62883),(6.64455,37.07984,-1.66736),(6.68239,37.04521,-1.68737),(6.64383,37.04184,-1.59888),(7.67972,37.06936,-1.71199),(7.6736,36.98119,-1.63178),(7.08775,37.04805,-1.64111),(7.17827,37.1037,-1.61359),(7.0871,36.99305,-1.59304),(7.17929,37.04402,-1.57325),(6.64471,37.10825,-1.71856),(6.69151,37.07756,-1.72559),(7.55723,36.81879,-1.34707),(7.58914,36.82275,-1.40803),(7.60008,36.8202,-1.36603),(7.62003,36.84234,-1.48003),(7.65086,36.90705,-1.57082),(7.91228,36.87604,-1.34449),(7.86461,36.88454,-1.4036),(7.84264,36.89152,-1.40997),(6.5824,37.39405,-1.20036),(6.57838,37.2883,-1.22185),(6.6125,37.29333,-1.10699),(6.59745,37.22079,-1.11705),(6.57815,37.252,-1.22895),(6.58407,37.11742,-1.26334),(6.57925,37.10338,-1.13572),(6.63759,36.91618,-1.43646),(6.6545,36.92962,-1.46881),(6.66037,36.8331,-1.43635),(6.66493,36.93264,-1.52083),(6.66954,36.83051,-1.54011),(6.66797,36.82618,-1.50422),(6.66883,37.07095,-.91716),(6.62242,37.18291,-.93892),(6.59158,37.06037,-.94377),(6.64292,36.86835,-1.35523),(6.59486,36.64782,-1.2964),(6.57748,36.67456,-1.23916),(7.29396,36.89609,-1.20833),(7.31376,36.89458,-1.20657),(7.28035,36.93491,-1.13572),(8.09251,36.91647,-1.15242),(8.10929,36.98996,-1.20688),(8.12669,36.96171,-1.07356),(6.66861,36.78497,-1.04553),(6.57782,36.75649,-1.10298),(6.67737,36.73696,-1.08874),(8.06785,37.09308,-.88752),(8.04696,37.09337,-.87929),(8.04672,37.00643,-.93947),(7.71695,37.05471,-.98071),(7.15459,37.27411,-1.63921),(7.06971,37.26707,-1.67214),(7.04304,37.386,-1.59145),(6.61355,37.45371,-1.82643),(6.62272,37.52716,-1.80116),(6.51344,37.39341,-1.86318),(6.53509,37.30499,-1.84642),(6.51124,37.31149,-1.85183),(8.20258,37.2856,-.93022),(8.20038,37.21674,-.92527),(8.05047,37.19716,-.83084),(8.09039,37.31611,-.83551),(8.04241,37.31022,-.82739),(8.08784,37.20215,-.84315),(6.66507,37.29851,-.95071),(6.72673,37.19314,-.93162),(6.78305,37.31323,-.96725),(6.76667,37.05942,-.93191),(6.82149,37.18317,-.96546),(6.52048,37.28997,-1.31231),(6.55176,37.1596,-1.34753),(6.19211,37.24635,-1.51396),(6.18124,37.34744,-1.47762),(6.83461,37.55331,-1.15772),(6.77538,36.96758,-1.84868),(6.74736,36.97977,-1.83626),(6.75181,36.97178,-.93673),(6.89722,37.04733,-.98309),(6.54991,36.95059,-1.00733),(6.58905,37.05464,-1.17235),(6.56976,37.07279,-.96851),(6.64613,36.62327,-1.4788),(6.61709,36.63115,-1.37257),(6.20929,37.01354,-1.59973),(6.62958,36.93239,-1.39914),(6.59384,36.97744,-1.42072),(6.60262,36.96796,-1.4386),(6.61695,36.96366,-1.35813),(6.86775,49.52557,-.60313),(6.17005,48.33516,-1.58986),(7.28069,48.19168,-1.41213),(7.39811,48.63956,-1.2313),(7.37461,48.77424,-1.31338),(7.01751,49.48273,-1.01428),(7.13345,49.32934,-1.19844),(7.17393,49.31108,-1.02976),(7.41779,48.20297,-1.08425),(7.4057,48.60583,-1.08293),(7.19104,49.31266,-.94612),(7.1133,49.45211,-.88423),(7.0689,49.34313,-.50013),(7.08968,49.24821,-.48961),(7.01274,49.45717,-.52981),(6.96882,49.48658,-.54408),(6.80094,49.28147,-.38355),(7.03071,48.68699,-.42114),(6.992,48.66547,-.45108),(7.06888,48.4667,-.4894),(6.90409,48.39784,-.43422),(6.09034,49.6071,-1.35968),(6.09985,49.65006,-1.16909),(6.49587,49.43186,-.30226),(6.42197,49.52089,-.40702),(6.02105,49.57131,-1.18945),(6.05947,49.61065,-1.16426),(5.98263,49.53197,-1.21463),(5.88276,49.41863,-1.13853),(5.90491,49.45545,-1.09438),(5.94793,49.46346,-1.31445),(5.94942,49.49695,-1.25975),(5.95323,49.46162,-1.37932),(5.8385,49.32798,-1.28753),(5.86444,49.29993,-1.39791),(5.98525,49.46066,-1.43879),(6.16351,49.55161,-1.55966),(6.08436,49.50481,-1.53934),(6.95029,49.37596,-1.594),(6.90996,49.58943,-1.49585),(6.99194,49.472,-1.45309),(6.83261,49.48236,-1.62231),(6.28376,49.67371,-1.46386),(6.28178,49.71772,-1.36445),(6.83732,49.7843,-1.22327),(6.9279,49.72752,-1.17519),(6.79706,49.64234,-1.51994),(6.84116,49.75776,-.87558),(6.22742,49.73412,-1.26787),(6.18235,49.70967,-1.20525),(6.59636,47.84608,-1.60373),(6.34665,48.22657,-1.61942),(6.47145,47.83562,-1.55231),(7.40506,47.79105,-.82544),(7.26547,47.80435,-.67446),(7.16462,47.79919,-.63615),(7.02983,47.32136,-.67133),(7.15102,47.31735,-.65634),(7.07663,47.80082,-.62973),(6.3432,47.40851,-1.19469),(6.29553,47.65261,-1.13207),(7.09005,47.80949,-1.55737),(7.0722,47.30418,-1.58723),(7.22821,47.81445,-1.43974),(7.13808,46.2302,-.70532),(6.53099,46.22949,-1.03574),(6.44394,47.31106,-.85233),(7.33424,47.28892,-1.23633),(7.35548,46.28916,-1.26595),(7.34537,47.29112,-1.10713),(7.36585,46.28447,-1.09987),(7.09146,46.22357,-.71075),(7.10609,45.10607,-.77084),(6.88923,43.9979,-1.80621),(6.79283,43.99664,-1.72165),(6.9092,45.15469,-1.75002),(7.45549,43.99423,-1.24006),(7.40569,45.18686,-1.20095),(6.93255,42.87493,-1.84165),(6.84054,42.84453,-1.7889),(7.30291,44.00948,-1.6784),(7.30822,42.88574,-1.7017),(7.4004,43.98809,-1.54256),(7.44123,43.99748,-1.39315),(7.27626,42.88304,-.97633),(7.06678,42.89278,-1.8333),(7.32316,41.88232,-1.74675),(7.15963,41.89787,-1.92232),(7.41142,41.88357,-1.3199),(6.79872,40.68303,-1.78345),(7.04195,41.88402,-1.939),(7.22889,40.74259,-2.01113),(6.93377,41.85625,-1.87671),(7.02229,40.72517,-2.00679),(7.48763,40.74846,-1.80231),(7.39681,39.52938,-2.00068),(6.68059,38.79917,-1.63489),(6.76896,39.5254,-1.63669),(6.66041,38.80102,-1.67858),(7.41646,38.61361,-1.91816),(7.34308,38.3479,-1.90903),(7.26382,39.54396,-1.29106),(7.29875,38.83314,-1.29291),(7.38118,39.5811,-1.42592),(7.45157,38.84903,-1.39982),(7.20456,39.55018,-1.26047),(7.16861,38.82471,-1.2603),(6.71303,38.79753,-1.82653),(6.837,39.48647,-1.85641),(7.32622,38.83149,-1.92735),(7.71055,39.63236,-1.80504),(7.85659,38.86388,-1.70453),(7.67211,39.24334,-1.6778),(7.74822,38.86629,-1.63622),(7.60174,38.8531,-1.50727),(7.64824,38.62494,-2.00981),(7.79271,38.35284,-1.99996),(7.63677,38.63721,-1.48715),(7.85951,38.36259,-1.51633),(7.79787,38.63671,-1.6009),(7.51064,38.2259,-1.32682),(7.1781,38.25477,-1.27338),(7.08338,37.60667,-1.38029),(7.1836,38.17158,-1.29152),(7.09247,38.11863,-1.27703),(7.18105,37.60498,-1.37893),(7.24042,37.61814,-1.38593),(6.53042,38.07829,-1.51801),(6.73527,38.25118,-1.39278),(6.5862,38.25943,-1.51855),(6.96152,38.24435,-1.25546),(7.05216,38.16853,-1.26532),(6.19405,37.07673,-1.55522),(6.34851,36.97141,-1.50828),(6.29564,36.97466,-1.54659),(6.22119,37.12207,-1.4806),(6.21815,37.16346,-1.46423),(6.23241,37.63104,-1.55646),(6.25205,37.72129,-1.61226),(7.88383,38.22552,-1.47404),(7.89702,37.92878,-1.4015),(8.13998,37.30922,-.86043),(8.091,37.4153,-.85119),(8.29551,37.28827,-1.30857),(8.26403,37.31784,-1.23049),(8.00921,37.68036,-1.19082),(8.30429,37.54307,-1.3341),(8.23221,37.45926,-1.18596),(8.19052,37.36172,-1.15735),(8.15389,37.03614,-1.00665),(7.6519,37.74279,-1.93005),(7.72816,37.91536,-1.99174),(8.00833,37.0106,-1.51198),(7.89298,37.01906,-1.57972),(8.17628,37.06546,-1.4143),(7.88304,37.08281,-1.62077),(8.06093,37.17025,-1.59499),(8.05068,37.11213,-1.54857),(7.69622,37.362,-1.87867),(8.21147,37.33718,-1.55156),(8.0644,37.29849,-1.65258),(8.19319,37.48578,-1.59293),(7.8857,37.38789,-1.83511),(7.88377,37.55745,-1.88914),(6.51864,37.80105,-1.86691),(6.34162,37.05678,-1.69749),(6.6068,36.99073,-1.22816),(6.55016,36.85749,-1.05976),(6.67231,36.65486,-1.57404),(6.64279,37.00865,-1.53905),(6.67037,36.95344,-1.56388),(6.95183,36.74064,-1.3309),(6.80651,36.65387,-1.43015),(6.95374,36.7559,-1.4044),(6.79621,36.64726,-1.34539),(7.5714,37.95526,-1.95193),(7.4429,38.06079,-1.87108),(7.4227,38.21947,-1.90996),(7.11756,38.38869,-1.86814),(6.89547,38.36803,-1.87032),(7.40729,37.73343,-1.53882),(7.42866,37.72652,-1.54215),(7.593,37.69826,-1.86211),(7.3211,37.30984,-1.66331),(7.32011,37.28022,-1.65226),(7.22846,37.28303,-1.64171),(7.56533,37.41978,-1.79041),(6.74863,37.43642,-1.73378),(6.8377,37.43719,-1.70002),(7.43296,37.49786,-1.62622),(7.4008,37.55964,-1.56311),(7.25073,37.56386,-1.45576),(7.26281,37.54489,-1.48768),(6.96383,37.27465,-1.73996),(6.8022,37.30669,-1.80251),(7.47184,37.1036,-1.66221),(7.63826,37.0801,-1.70066),(6.93565,37.62725,-1.47546),(7.14285,38.07988,-1.7675),(7.12016,38.27972,-1.85171),(6.74858,38.04651,-1.85976),(6.69177,37.75244,-1.80846),(7.18412,38.38282,-1.87422),(7.02371,37.28239,-1.07316),(7.08777,37.28918,-1.08637),(7.09107,37.3653,-1.10753),(7.02395,37.37466,-1.08743),(6.62328,36.97637,-1.49335),(6.65366,38.02162,-1.86794),(8.19349,37.15114,-1.45843),(7.9673,36.85424,-1.2176),(8.18977,37.37302,-.94993),(8.23872,37.33233,-1.20278),(6.63783,37.30801,-.97405),(6.67269,37.38023,-.99273),(8.04593,38.26523,-1.56692),(7.8059,37.00586,-1.6245),(7.77936,37.06542,-1.68618),(7.93325,37.71352,-1.07037),(7.91753,37.71466,-1.07165),(7.9447,37.68377,-1.00373),(6.30821,37.53832,-1.44129),(6.20485,37.64595,-1.57512),(6.22225,37.44804,-1.41805),(6.13479,37.26964,-1.57394),(6.08786,37.29209,-1.63079),(6.76463,37.46879,-1.09795),(7.12734,37.59808,-1.37914),(7.2624,37.69214,-1.37036),(7.17446,38.37641,-1.27025),(7.30889,38.62801,-1.29333),(7.16719,38.61969,-1.26399),(7.33415,38.36882,-1.27185),(8.11919,38.40485,-1.68679),(8.0563,38.51439,-1.83661),(7.81394,38.63642,-1.99759),(7.88465,38.49649,-1.98173),(6.8402,38.59302,-1.90486),(6.8289,39.52712,-1.49641),(7.3622,40.71693,-1.35557),(6.89306,40.71471,-1.26799),(6.95723,39.5433,-1.35589),(6.60091,43.97821,-1.52963),(7.2842,45.12996,-.82081),(7.1943,43.96178,-.87638),(7.25619,43.95859,-.89043),(7.14952,45.10842,-.76377),(6.91203,47.79111,-1.60132),(6.68369,48.24717,-1.63422),(6.91236,48.21278,-1.5971),(6.7492,49.72597,-.69123),(5.86062,49.3818,-1.18267),(7.07728,48.02054,-.58617),(7.1402,48.0423,-.5882),(7.02104,48.43598,-.47291),(6.99634,48.90353,-.36365),(6.98156,49.19481,-.40162),(7.26858,48.51808,-.56371),(7.12833,48.47609,-.5033),(7.08926,48.69264,-.42789),(7.13458,49.08075,-.47729),(7.20737,49.09439,-.71866),(7.10754,49.34534,-1.28235),(6.86397,48.85788,-1.66689),(6.65258,48.87983,-1.83952),(6.51606,48.64523,-1.785),(6.82402,48.58373,-.30866),(6.33547,48.85537,-.27473),(6.30184,48.91419,-.36541),(6.18436,48.12523,-.99469),(6.79941,36.85452,-1.80862),(6.75828,36.8542,-1.81556),(6.81254,36.95877,-1.84851),(6.5709,36.93359,-.98358),(6.64658,36.94943,-.93537),(6.78431,36.74473,-1.09989),(6.79132,36.69404,-1.1743),(6.94066,36.79371,-1.16128),(8.17881,37.12456,-.95648),(7.83722,37.00413,-.95216),(7.8279,37.072,-.90491),(7.76087,37.06083,-.94085),(7.77376,37.00327,-.99505),(6.24637,36.99492,-1.55991),(6.23624,37.06273,-1.52131),(6.7073,36.99078,-1.7251),(6.62406,36.92682,-1.28397),(6.61262,36.98263,-1.34536),(7.33285,36.92365,-1.45956),(7.32786,36.90112,-1.39928),(7.24583,36.91329,-1.40326),(7.25011,36.94219,-1.45309),(7.88624,36.87328,-1.33308),(7.31823,36.88793,-1.36071),(7.24124,36.9063,-1.36244),(7.449,37.62078,-1.13112),(6.6932,36.92866,-1.66715),(7.59493,37.30967,-1.01896),(7.6313,37.30932,-1.02831),(7.6189,37.39268,-1.06244),(7.58746,37.39852,-1.05073),(7.17397,37.41373,-1.58078),(8.08363,37.49973,-.87542),(8.10445,37.53793,-.93213),(7.88698,36.8857,-1.11794),(7.9213,36.85538,-1.22111),(7.57302,37.53749,-1.13372),(7.06174,37.55217,-1.3446),(7.01219,37.50105,-1.23736),(7.04539,37.48691,-1.23971),(7.27146,37.45988,-1.10773),(7.66732,37.48904,-1.03575),(7.65997,37.5586,-1.09143),(7.63375,37.47921,-1.07762),(8.12019,37.61075,-1.03574),(7.69264,37.17736,-1.79696),(8.21855,37.2809,-1.53621),(8.06455,37.23612,-1.62977),(7.3255,37.20713,-1.65453),(7.33204,37.15265,-1.64403),(8.05613,36.89407,-1.23174),(6.09374,37.1733,-1.736),(6.06869,37.24699,-1.76073),(6.18431,37.2057,-1.5121),(6.6217,37.63579,-1.81624),(6.62343,37.5756,-1.79712),(6.64583,37.64831,-1.80176),(6.1038,37.61189,-1.85377),(6.51306,37.631,-1.848),(6.4335,37.62751,-1.87113),(6.10778,37.52928,-1.87711),(6.06722,37.52339,-1.85604),(6.12017,37.1162,-1.72211),(6.09422,37.61787,-1.83715),(6.09247,37.62973,-1.80142),(6.22543,37.10485,-1.49164),(6.35741,37.55281,-1.39293),(6.32748,37.4423,-1.36437),(6.6363,37.52408,-1.1634),(6.96694,37.52875,-1.24053),(6.99738,37.58376,-1.34815),(6.90149,37.50559,-1.16954),(6.31965,37.24738,-1.86205),(6.2792,37.04836,-1.48651),(6.27473,37.44516,-1.38796),(6.2556,37.53836,-1.47498),(6.05311,37.30307,-1.73584),(6.05888,37.30123,-1.69661),(6.18116,37.65578,-1.60033),(6.12631,37.36861,-1.53955),(6.07527,37.40816,-1.59864),(6.07803,37.37322,-1.60879),(6.41599,38.07274,-1.75041),(6.43965,38.07643,-1.79179),(6.62597,38.5979,-1.67944),(6.53066,38.34029,-1.72833),(6.52508,38.34278,-1.69659),(6.62787,38.59759,-1.72241),(6.61099,37.95924,-1.3666),(6.48954,37.97901,-1.503),(6.51426,37.98027,-1.47911),(6.36347,37.95005,-1.8065),(6.9718,37.96148,-1.26667),(6.36661,37.98561,-1.74201),(6.36212,37.97949,-1.76355),(6.30965,37.90185,-1.74106),(6.30294,37.89253,-1.78124),(6.25549,37.81454,-1.74302),(6.23514,37.78056,-1.74328),(7.36368,37.67998,-1.49571),(7.38379,37.67315,-1.50547),(7.18372,37.56358,-1.37943),(7.06806,37.57117,-1.37729),(7.0104,37.60752,-1.39267),(7.74385,37.7237,-1.26881),(8.037,36.87585,-1.12214),(8.06553,36.88793,-1.12149),(8.02475,37.61586,-.95543),(8.04209,37.56491,-.9104),(8.07658,37.41634,-.84625),(7.71562,37.66525,-1.13964),(7.71655,37.67818,-1.1794),(7.15923,37.46306,-1.17125),(7.16232,37.41152,-1.13355),(7.1302,37.45436,-1.17023),(7.13212,37.45471,-1.18791),(6.48156,49.344,-.2869),(5.81916,49.24372,-.82902),(5.93859,49.39563,-.72583),(5.98162,49.52628,-1.0477),(5.8372,48.41458,-1.41932),(5.87836,48.35802,-1.40382),(5.75102,48.40524,-1.07848),(6.77793,49.11249,-.34909),(6.76254,49.10735,-.29611),(6.81079,48.55256,-.21091),(6.80993,48.39784,-.2989),(6.81193,49.1187,-.37416),(6.83431,48.96866,-.38095),(6.50559,48.33699,-.29813),(6.63392,48.69142,-.12321),(6.77443,49.10022,-.21481),(6.59849,48.50802,-.21031),(6.67203,48.52357,-.21055),(6.66576,47.88154,-.52347),(6.65918,48.25536,-.35671),(6.53223,47.85303,-.53632),(6.66484,48.8537,-.09397),(6.7571,49.08701,-.16226),(6.63008,49.15359,-.19538),(6.65279,49.02714,-.13251),(6.53542,49.46258,-.31576),(7.02033,49.04941,-.38486),(7.20424,48.06562,-.60313),(6.95734,49.0429,-1.66006),(6.89064,49.1887,-1.72434),(6.8549,49.23142,-1.74494),(6.97048,49.33369,-1.57365),(7.32238,48.85032,-1.51456),(7.29566,49.01551,-1.47618),(7.36076,48.84934,-1.32811),(6.88507,48.61021,-.41018),(6.81889,48.76972,-.29439),(6.53437,48.49606,-.19395),(6.82929,48.75743,-.24888),(6.84583,48.74666,-.22557),(7.33993,47.82124,-1.2624),(6.89795,47.29938,-1.61815),(6.91323,46.26234,-1.68521),(6.71863,47.28414,-1.60128),(7.32043,48.95885,-1.08209),(7.25856,48.78249,-1.59126),(6.87561,47.77789,-.59878),(6.78255,47.758,-.55686),(6.25251,48.0527,-.86515),(7.62405,39.60504,-1.95902),(7.54223,39.57814,-2.0061),(7.36348,40.75175,-1.98021),(7.99006,38.50286,-1.92266),(7.95138,38.35656,-1.96586),(6.90264,48.98626,-1.66724),(7.17029,49.21317,-1.39806),(6.65884,41.81431,-1.35661),(7.32068,44.99683,-.85784),(7.29631,43.96071,-.91684),(7.01594,38.04762,-1.26678),(6.64827,38.59429,-1.7772),(6.38761,37.66076,-1.42346),(6.21873,37.19339,-1.46081),(7.00322,38.60868,-1.27313),(7.61534,37.85738,-1.93423),(7.34455,38.07095,-1.80989),(7.4161,37.82641,-1.67554),(7.16561,37.91297,-1.61301),(7.09346,37.88135,-1.59241),(8.01281,38.21663,-1.95),(6.66496,37.66589,-1.20621),(6.49649,38.08116,-1.56564),(6.48452,38.23927,-1.73526),(7.30871,45.13706,-.85686),(7.23453,42.8841,-.95426),(6.62358,43.95157,-1.20604),(6.66325,43.95331,-1.18792),(6.57568,49.40829,-.30817),(5.94515,48.58279,-.58134),(7.00515,49.43968,-1.44213),(6.84393,49.59678,-.6096),(6.9236,49.60012,-.80715),(6.70799,49.49253,-.37925),(6.70485,49.51059,-.37916),(6.66689,49.48788,-.35434),(6.62162,49.45863,-.33008),(6.82685,49.3763,-.41548),(6.77393,49.35152,-.37686),(6.7274,49.31618,-.34822),(6.1079,48.16528,-1.27518),(6.63378,47.6993,-1.59721),(6.32952,48.25463,-1.63341),(6.25316,48.20098,-1.55417),(6.37757,47.28992,-1.16953),(6.39896,47.27773,-1.27881),(6.12045,48.14551,-1.27388),(6.14046,48.16186,-1.38657),(6.52797,46.27981,-1.39989),(7.3602,45.16233,-1.0303),(6.98115,37.86314,-1.28959),(7.51231,37.67695,-1.1722),(7.82881,37.01899,-1.60636),(7.75381,37.12113,-1.7534),(7.80149,37.07575,-1.66276),(7.88526,37.25639,-1.76738),(7.51158,37.61852,-1.14942),(6.27935,47.82194,-1.36387),(6.59561,47.26816,-1.54159),(6.50753,47.26115,-1.46091),(6.37469,47.82822,-1.48053),(6.47102,49.36557,-.2807),(6.51725,49.39346,-.28937),(6.51356,49.40119,-.29172),(6.57056,49.42508,-.3045),(6.56677,49.43254,-.30701),(6.61791,49.46604,-.33239),(6.66343,49.49533,-.35675),(6.97727,49.31115,-1.55929),(6.89827,49.16735,-1.70405),(6.09327,48.44172,-1.68324),(6.07421,48.45779,-1.69501),(5.90611,48.34471,-1.3972),(6.62906,42.82897,-1.32497),(6.63148,42.82661,-1.28557),(6.69145,42.82525,-1.23138),(6.65013,42.82476,-1.24683),(7.14936,43.9641,-.88705),(6.41596,38.08392,-1.7126),(6.48173,38.24761,-1.70451),(7.00306,38.35889,-1.25373),(7.08439,38.61558,-1.24756),(6.90453,38.36399,-1.2837),(6.72246,37.98729,-1.29251),(6.83331,38.03385,-1.26932),(6.75514,38.0774,-1.30275),(6.80455,37.95601,-1.26002),(6.67619,37.80529,-1.26114),(6.77488,37.87243,-1.25351),(6.69386,37.90393,-1.28367),(6.74813,37.79393,-1.24405),(6.86337,38.24971,-1.2871),(8.29074,37.25714,-1.38231),(8.29233,37.3705,-1.42692),(8.29403,37.32688,-1.41187),(8.0822,37.96117,-1.90962),(7.9281,38.63998,-1.93728),(6.62495,38.35682,-1.51768),(6.77008,38.35883,-1.39536),(7.18426,38.27185,-1.85776),(7.86014,38.21679,-1.99504),(8.01939,38.39268,-1.6092),(7.22455,37.66887,-1.45012),(7.18929,38.07919,-1.77028),(7.14242,38.06118,-1.7616),(7.19142,38.05689,-1.76609),(7.01149,38.03232,-1.77266),(7.04662,37.92314,-1.64795),(7.54542,37.81743,-1.85688),(7.59329,38.84706,-2.01433),(7.4724,38.6328,-1.39001),(6.6437,38.60018,-1.62661),(7.85288,38.85585,-1.94636),(6.45369,37.88058,-1.48367),(6.44423,37.98627,-1.56527),(6.39774,37.89302,-1.55931),(6.42001,37.78205,-1.46003),(6.36089,37.79827,-1.53914),(6.25037,37.20715,-1.83582),(6.252,37.25467,-1.86221),(6.18745,37.39204,-1.90188),(6.24977,37.32752,-1.8956),(6.19301,37.31692,-1.88593),(6.24386,37.39757,-1.90861),(6.17849,37.45983,-1.90375),(6.22291,37.53724,-1.89363),(6.23585,37.46388,-1.90895),(6.16825,37.53453,-1.89084),(6.98142,38.04636,-1.26295),(7.40027,45.18423,-1.35641),(7.22353,49.15543,-1.34772),(6.39867,47.29681,-1.05658),(7.75981,38.85185,-1.99723),(7.0408,44.00134,-1.79498),(6.35163,47.95393,-.68769),(6.43034,47.87387,-.56222),(6.39932,47.91104,-.60984),(7.3994,47.80526,-1.0072),(7.38326,47.81232,-1.14087),(7.17023,48.38067,-1.55905),(7.1268,48.17458,-1.55316),(6.84197,48.73558,-.19645),(6.66189,48.36749,-.29724),(6.37418,48.47526,-.25208),(6.36128,48.3244,-.32263),(6.3118,48.4782,-.34901),(5.8187,48.52239,-.75965),(5.8745,48.62986,-.5884),(5.77425,48.84063,-.72168),(5.69701,48.94,-.94122),(5.71854,48.73334,-.86182),(5.73446,49.01317,-.81259),(5.76635,49.17465,-.92999),(5.72287,49.10383,-1.0342),(7.05035,48.90821,-.37054),(7.32779,48.93935,-.9461),(7.36921,48.78359,-1.0865),(7.38592,48.75993,-.93669),(7.4299,48.57709,-.92711),(7.43345,48.19644,-.91829),(7.25349,49.10812,-.94912),(6.63072,49.44745,-1.73255),(6.57714,49.61646,-1.62601),(6.72033,49.55335,-1.63162),(6.5049,49.52258,-1.71791),(6.73455,49.35476,-1.73804),(6.56651,49.13631,-.19569),(6.37819,49.76212,-.74729),(6.40282,49.68074,-.58234),(6.4897,49.73548,-.61992),(6.31611,49.7245,-.72311),(6.5957,49.65155,-.49782),(6.81518,48.91825,-.18374),(6.67253,47.74703,-.56745),(6.37104,48.1971,-.39923),(6.78867,48.94106,-.30506),(6.8012,48.95345,-.34889),(6.46757,47.85116,-.54061),(6.45406,48.63832,-.14045),(6.39418,48.64954,-.17918),(7.12142,37.54256,-1.34547),(7.11655,37.4743,-1.23359),(6.03384,48.51306,-1.69883),(5.85503,48.94962,-.5954),(5.97384,48.78811,-.46224),(5.97501,49.29341,-.57797),(5.79755,49.08568,-.69621),(6.23731,49.66044,-.69939),(6.1482,49.46719,-.51243),(6.31887,49.61386,-.55205),(6.08522,49.53726,-.6718),(6.05263,49.60194,-1.00049),(6.13904,49.68313,-.98203),(7.12389,37.56213,-1.37925),(7.10127,37.45136,-1.18286),(6.97498,37.45421,-1.14218),(6.96956,37.45093,-1.12484),(7.03162,37.44999,-1.17133),(7.17171,37.38219,-1.10643),(7.12809,37.39663,-1.13251),(7.12848,37.36372,-1.11138),(6.95014,37.38971,-1.05854),(6.95839,37.4244,-1.08624),(6.8895,37.39418,-1.02925),(6.89925,37.42982,-1.06137),(7.62167,36.9963,-1.62269),(7.60548,36.92549,-1.5646),(7.5777,36.86301,-1.48573),(7.54309,36.84067,-1.42011),(7.5139,36.83095,-1.36395),(7.47453,36.82867,-1.27598),(7.47875,36.8425,-1.16424),(7.43948,36.8528,-1.1742),(7.50777,36.81783,-1.25952),(7.42684,36.9499,-1.00761),(7.4093,36.90221,-1.08314),(7.44511,36.89502,-1.07033),(7.39026,36.95384,-1.02261),(7.4149,37.5454,-1.10034),(7.44958,37.48641,-1.05551),(7.44773,37.5523,-1.09404),(7.41253,37.48241,-1.06555),(7.42743,37.31938,-.97265),(7.40561,37.41848,-1.03065),(7.38618,37.3158,-.98821),(7.44627,37.42103,-1.01711),(7.36941,37.21537,-.95943),(7.40059,37.10447,-.93141),(7.40709,37.21819,-.94229),(7.36213,37.10244,-.94997),(7.40866,37.02549,-.95549),(7.3702,37.02638,-.97279),(7.5159,37.54876,-1.10892),(7.48578,37.48508,-1.05643),(7.51844,37.47975,-1.06738),(7.48443,37.55369,-1.0972),(7.51129,37.41225,-1.02388),(7.46568,37.31766,-.97101),(7.50238,37.31168,-.98168),(7.48291,37.41698,-1.01584),(7.49047,37.11393,-.94734),(7.44698,37.22575,-.94118),(7.43911,37.10832,-.92868),(7.49108,37.2174,-.95526),(7.55653,36.81948,-1.27659),(7.55717,36.85913,-1.15893),(7.51488,36.84467,-1.15573),(7.59634,36.83594,-1.2658),(7.51117,36.96686,-1.01273),(7.48212,36.89654,-1.06553),(7.52987,36.90955,-1.0748),(7.46596,36.95616,-1.00148),(7.63406,36.83131,-1.35655),(7.71571,37.64065,-1.10149),(7.72539,37.50875,-.98312),(7.71977,37.58147,-1.0457),(7.67696,37.41965,-.98715),(7.73282,37.35166,-.90815),(7.73017,37.43719,-.93378),(7.68495,37.33377,-.95772),(7.69349,37.23704,-.94168),(7.74886,37.14024,-.8972),(7.7376,37.24927,-.89305),(7.7059,37.13484,-.94364),(8.00854,37.66911,-.99757),(8.06207,37.50385,-.86852),(7.78804,37.71712,-1.264),(7.75346,37.69694,-1.25234),(7.88932,37.73477,-1.16248),(7.86545,37.73823,-1.24798),(7.75195,37.70512,-1.23464),(7.7895,37.72618,-1.24537),(8.18437,37.22006,-.88268),(8.13689,37.21115,-.86116),(8.18804,37.29902,-.88887),(8.11434,37.10051,-.90119),(8.1317,37.01349,-.97244),(8.15998,37.11151,-.91703),(8.08921,37.00662,-.95577),(8.062,36.9236,-1.03158),(8.10196,36.93375,-1.04398),(7.8628,37.71257,-1.08339),(7.84452,37.73687,-1.16951),(7.80881,37.69796,-1.10135),(7.75439,37.69649,-1.17775),(7.75544,37.67947,-1.12489),(7.80171,37.71994,-1.17418),(7.8297,37.73967,-1.24863),(7.82737,37.73036,-1.26861),(7.34147,37.59872,-1.48657),(7.12753,37.58802,-1.41603),(7.00828,37.59775,-1.44928),(6.16041,37.70314,-1.72885),(6.37104,37.9933,-1.69986),(6.27575,37.81556,-1.68471),(6.32639,37.9025,-1.69116),(6.31065,37.87525,-1.81638),(6.63694,37.87965,-1.31934),(6.5937,37.88108,-1.35171),(6.56639,37.87574,-1.37014),(6.4984,37.88225,-1.44021),(6.34399,37.9032,-1.63751),(6.38457,37.99415,-1.65421),(6.42597,38.0851,-1.67091),(6.94252,37.9701,-1.26201),(6.05732,37.37844,-1.83555),(6.06689,37.45078,-1.86222),(6.07593,37.37966,-1.85656),(6.04937,37.44851,-1.84183),(6.05401,37.5234,-1.83687),(6.07969,37.48978,-1.58212),(6.12565,37.57771,-1.5888),(6.24092,37.75538,-1.68158),(6.09523,37.61846,-1.7331),(6.16685,37.68307,-1.66562),(6.10385,37.60137,-1.66277),(6.05559,37.50518,-1.6626),(6.03871,37.44103,-1.74623),(6.04842,37.42889,-1.67205),(6.04742,37.51536,-1.73799),(6.05207,37.37485,-1.68337),(6.04466,37.37557,-1.7481),(6.05495,37.30585,-1.79074),(6.04616,37.381,-1.80494),(6.03944,37.44566,-1.81146),(6.04704,37.52125,-1.8074),(6.27151,36.9972,-1.64164),(6.28673,36.98469,-1.52176),(6.32043,37.32361,-1.37191),(6.3304,36.98285,-1.48527),(6.33353,37.03088,-1.6688),(6.38385,37.33076,-1.8864),(6.32467,37.33227,-1.89721),(6.32476,37.40439,-1.90925),(6.37999,37.47532,-1.89883),(6.38583,37.40593,-1.89918),(6.31994,37.47155,-1.90859),(6.36989,37.62552,-1.88185),(6.31293,37.54297,-1.894),(6.30735,37.62312,-1.88601),(6.3718,37.54697,-1.88548),(6.5317,37.79404,-1.36746),(6.47595,37.78296,-1.40566),(6.39456,37.43418,-1.3345),(6.42082,37.55193,-1.35827),(6.4495,37.66819,-1.38114),(6.49948,37.67136,-1.3518),(6.52177,37.54796,-1.30657),(6.54296,37.67411,-1.3263),(6.47488,37.5498,-1.33058),(6.30365,37.81224,-1.62082),(6.59886,37.52873,-1.23274),(6.45726,37.4268,-1.30569),(6.40288,37.08208,-1.41138),(6.40851,37.02907,-1.43356),(6.56589,37.06446,-1.37802),(6.49387,37.02362,-1.41433),(6.57876,37.01822,-1.39519),(6.48618,37.07308,-1.39434),(6.60093,37.03303,-1.31147),(6.11439,37.4544,-1.88703),(6.13451,37.30933,-1.86624),(6.12271,37.38704,-1.883),(6.47478,37.17447,-1.36026),(6.46486,37.29935,-1.32894),(6.5062,36.97924,-1.44224),(6.53834,36.98175,-1.52204),(6.51544,36.96915,-1.46254),(6.55422,37.0189,-1.57488),(6.55889,37.053,-1.62985),(6.55979,37.09062,-1.69161),(6.55955,37.12221,-1.74226),(6.55002,37.2097,-1.80565),(6.4368,37.54561,-1.86945),(6.44652,37.40204,-1.88118),(6.51288,37.46814,-1.85941),(6.44373,37.47357,-1.88183),(6.43719,37.23207,-1.83199),(6.44516,37.32496,-1.86661),(6.50387,37.22149,-1.81818),(6.48469,37.09993,-1.71254),(6.42098,37.13764,-1.77111),(6.49422,37.13252,-1.7599),(6.46274,37.02949,-1.61193),(6.389,37.03672,-1.64214),(6.47481,37.06403,-1.6605),(6.42826,36.97033,-1.48648),(6.4463,36.98758,-1.55316),(6.41852,36.98105,-1.46376),(6.39243,37.31155,-1.35054),(6.39401,37.19006,-1.37359),(8.21457,37.21158,-1.50395),(6.83187,37.08237,-1.8595),(6.87642,37.0818,-1.80605),(6.96922,37.18352,-1.7422),(7.08755,37.11976,-1.66269),(6.96776,37.09344,-1.73379),(7.08151,37.19277,-1.67303),(7.20779,37.16597,-1.62698),(7.16692,37.21584,-1.64263),(7.20064,37.22328,-1.63576),(7.1749,37.15906,-1.63407),(7.24905,37.16675,-1.63133),(7.23811,37.2233,-1.64327),(7.19211,37.28267,-1.632),(7.5814,37.46774,-1.0928),(7.60975,37.46236,-1.10388),(7.98398,37.56882,-.91435),(7.96314,37.63005,-.96028),(7.89403,37.62214,-.96664),(7.84527,37.54543,-.93589),(7.91527,37.5617,-.91577),(7.82922,37.60708,-.9882),(7.77863,37.52739,-.96298),(7.76685,37.59202,-1.02036),(7.03182,37.4489,-1.18765),(7.41824,37.61,-1.13329),(7.81202,37.66315,-1.03894),(7.75624,37.64843,-1.0724),(7.87531,37.67721,-1.01373),(7.99445,37.18622,-.81478),(7.99222,37.08771,-.86263),(8.02944,37.41088,-.84293),(8.00698,37.50035,-.86886),(7.97906,37.0057,-.92296),(8.0229,36.92285,-1.01705),(7.8939,37.28364,-.83763),(7.80589,37.3674,-.87987),(7.81577,37.26697,-.86275),(7.87822,37.38416,-.85641),(7.82145,37.1549,-.8671),(7.9144,37.08013,-.87376),(7.90354,37.16946,-.8377),(7.85629,36.93764,-1.0229),(7.92019,37.0057,-.92178),(7.86334,37.47103,-.88341),(7.93845,37.49052,-.86575),(7.95886,37.4001,-.83752),(7.98155,37.29866,-.81744),(7.12649,37.28721,-1.08898),(7.12073,37.18379,-1.06625),(7.08607,37.18005,-1.06364),(7.16191,37.09709,-1.0473),(7.15757,37.18988,-1.05479),(7.12273,37.09383,-1.05882),(7.13483,37.02946,-1.07744),(7.08879,37.08925,-1.05698),(7.09845,37.02022,-1.07856),(7.1738,37.03187,-1.06959),(7.14561,36.97997,-1.11191),(7.18692,36.98388,-1.10551),(7.12016,36.93206,-1.1687),(7.10932,36.97119,-1.11286),(7.1558,36.94258,-1.16602),(7.14095,36.89015,-1.23697),(7.17585,36.90117,-1.23143),(7.19401,36.8862,-1.3079),(7.21883,36.91042,-1.22311),(7.23245,36.89406,-1.30066),(7.167,36.89153,-1.37535),(7.20214,36.90025,-1.36889),(7.15947,36.87679,-1.31445),(7.17057,36.8998,-1.41644),(7.20746,36.90946,-1.40885),(7.21127,36.9403,-1.45703),(7.17881,36.97924,-1.5274),(7.17389,36.92998,-1.46616),(7.21485,36.98873,-1.5177),(7.21404,37.05234,-1.56425),(7.25288,37.05389,-1.56231),(7.21355,37.11075,-1.60569),(7.25214,37.11305,-1.60622),(7.16046,37.2879,-1.07981),(7.10715,37.44956,-1.20721),(7.73431,36.87575,-1.3856),(7.76878,36.88611,-1.37258),(7.65359,37.31989,-.99777),(7.64344,37.4098,-1.03576),(7.6058,37.22055,-1.0029),(7.64352,37.22362,-1.01886),(7.68295,37.13615,-.98291),(7.66779,37.23194,-.98509),(7.65739,37.13456,-1.0172),(7.61544,37.12792,-1.00009),(7.62871,37.04902,-1.02101),(7.66622,36.89194,-1.1933),(7.65173,36.93485,-1.11929),(7.7352,36.87845,-1.44498),(7.70516,36.86473,-1.44052),(7.69424,36.85817,-1.37656),(7.67784,36.87509,-1.26044),(6.95857,36.94311,-1.66712),(7.08864,36.93048,-1.55203),(6.95992,36.87424,-1.62657),(7.25394,36.99002,-1.51543),(7.3383,37.04897,-1.57173),(7.33775,36.97934,-1.52113),(7.44859,36.95497,-1.53271),(7.4592,37.03308,-1.59393),(7.3409,37.10089,-1.62125),(6.85321,36.97923,-1.8035),(6.8491,36.89199,-1.76349),(6.95944,37.0044,-1.71473),(6.79334,36.77497,-1.74462),(6.7432,36.76986,-1.7578),(6.72836,36.86825,-1.80591),(6.71475,36.78758,-1.75223),(7.4452,37.02748,-.95271),(6.8273,36.69206,-1.53821),(6.95554,36.7771,-1.48536),(7.08347,36.85212,-1.43875),(7.08052,36.83954,-1.38372),(7.38958,36.87303,-1.35823),(7.4144,36.87953,-1.40329),(7.83994,36.88802,-1.34566),(7.43525,36.89914,-1.46587),(7.0858,36.88307,-1.49691),(6.84093,36.75234,-1.63747),(6.95717,36.82054,-1.57191),(6.68031,36.87354,-1.61573),(6.62045,36.62572,-1.28119),(6.69301,36.66216,-1.182),(6.60205,36.65772,-1.21787),(6.70285,36.62976,-1.25752),(6.94771,36.75331,-1.24848),(6.79265,36.66135,-1.25112),(7.05491,36.8765,-1.17356),(7.06722,36.83789,-1.2436),(7.8107,36.90777,-1.14882),(7.78833,36.95419,-1.06339),(7.30529,36.88303,-1.28908),(7.35162,36.87956,-1.28393),(7.29218,37.44518,-1.59065),(6.57184,36.83997,-1.03709),(6.65709,36.84937,-.99268),(6.55546,36.77455,-1.12458),(7.26482,36.97222,-1.07869),(7.24648,37.03113,-1.0376),(7.03469,36.99046,-1.06871),(7.04567,36.9239,-1.11282),(6.75404,36.87175,-.97895),(6.92598,36.86872,-1.07922),(6.91368,36.93846,-1.02927),(6.7698,36.80257,-1.03094),(7.02374,37.07034,-1.04593),(7.23074,37.09619,-1.01901),(7.4977,37.03675,-.96872),(7.07645,36.82606,-1.31552),(6.91577,37.1716,-1.00321),(7.02188,37.17198,-1.05429),(6.93281,37.29831,-1.03176),(6.59793,37.19387,-.96296),(6.86431,37.30596,-1.00297),(7.23533,37.19724,-1.02682),(7.24593,37.30084,-1.04812),(6.71582,36.61094,-1.3484),(6.76353,36.64851,-1.56226),(6.73507,36.61261,-1.44227),(6.78445,36.71137,-1.67285),(6.84656,36.81335,-1.70432),(6.6436,36.60671,-1.3628),(6.67176,36.60442,-1.46636),(6.70026,36.63569,-1.57464),(6.69815,36.72776,-1.68821),(6.72501,36.70579,-1.68942),(6.55937,48.65278,-.12256),(7.39249,48.54479,-.73738),(7.29959,48.10197,-.64375),(5.67184,48.84288,-1.20422),(5.68036,48.62611,-1.15589),(5.71479,49.03305,-1.24212),(5.72429,48.83079,-1.45905),(5.77564,49.04961,-1.4383),(5.75776,48.62288,-1.45337),(5.92667,48.71073,-1.6829),(5.88592,48.90947,-1.66257),(5.88071,49.11155,-1.60262),(5.91419,49.30962,-1.5127),(6.07791,49.36688,-1.67196),(6.15165,49.04937,-1.83681),(6.09727,49.22269,-1.762),(6.20988,48.90696,-1.87707),(6.46805,49.10505,-1.89692),(6.39031,49.23134,-1.85152),(6.30614,49.35962,-1.79502),(6.24685,49.45532,-1.70432),(6.6468,49.69996,-1.52398),(6.45985,49.71361,-1.50392),(6.45996,49.7974,-1.3513),(6.69062,49.82295,-1.29785),(6.73046,49.81777,-.95632),(6.60965,49.86356,-1.04927),(6.39065,49.82199,-1.17837),(6.52621,49.84208,-.88119),(6.30261,49.79737,-1.06589),(6.641,49.80331,-.78031),(7.42178,48.15423,-.77795),(6.9175,43.9691,-.99823),(6.90872,42.90209,-1.09048),(6.6598,42.8474,-1.60773),(6.53288,38.34167,-1.64814),(7.49899,38.36154,-1.34788),(6.56938,37.80004,-1.34124),(6.48899,38.24505,-1.66592),(7.26328,37.40551,-1.08462),(7.79473,37.45533,-.90755),(7.99569,36.87521,-1.11562),(7.82821,36.89305,-1.23912),(8.29903,37.52547,-1.43681),(7.88758,37.9324,-1.97549),(7.19568,37.96882,-1.68761),(7.15485,37.97057,-1.67885),(7.20023,36.9494,-1.15903),(7.6399,36.98418,-1.06122),(6.49886,37.42181,-1.28684),(6.52282,49.37756,-.2955),(7.77862,36.88473,-1.43683)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesLeftHumerus.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesLeftHumerus.py load and self-test diagnostics complete.")
