package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Human bone model for Left Foot. </p>
 <p> Related links: Catalog page <a href="../../../Medical/BonesLeftFootIndex.html" target="_blank">BonesLeftFoot</a>,  source <a href="../../../Medical/BonesLeftFoot.java">BonesLeftFoot.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/BonesLeftFoot.x3d">BonesLeftFoot.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Damon Hernandez, Joe Williams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Human bone model for Left Foot </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Joe Williams, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 5 December 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftFoot.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftFoot.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Damon Hernandez, Joe Williams
 */

public class BonesLeftFoot
{
	/** Default constructor to create this object. */
	public BonesLeftFoot ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("BonesLeftFoot.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Damon Hernandez, Joe Williams"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Human bone model for Left Foot"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Joe Williams, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("5 December 2013"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftFoot.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("BonesLeftFoot.x3d"))
    .addChild(new Transform("LeftFootSkeletonParts").setScale(0.029,0.029,0.029)
      .addChild(new Viewpoint("feet").setDescription("LeftFoot").setFieldOfView(0.785).setPosition(3.0,3.0,15.0))
      .addChild(new Group("LeftFoot")
        .addComments(" ltalus lcalc lcuboid llcun lmcun lnaviclr [missingsomething] lfmet lmet2 lmet3 lmet4 lmet5 lfpprox2 lfpprox3 lfpprox4 lfpprox5 lfmphal lfmphal2 lfmphal3 lfmphal4 lfdphal lfdphal2 lfdphal3 lfdphal4 [lfdphal5 missing] ")
        .addChild(new Shape("ltalus")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("ltalus_Geo").setDEF("ltalus_Geo").setCreaseAngle(1.571).setCoordIndex(getltalus_Geo_6_15_coordIndex())
            .setCoord(new Coordinate("ltalus_Coord").setPoint(getltalus_Coord_7_15_point()))))
        .addChild(new Shape("lcalc")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lcalc_Geo").setDEF("lcalc_Geo").setCreaseAngle(1.571).setCoordIndex(getlcalc_Geo_6_20_coordIndex())
            .setCoord(new Coordinate("lcalc_Coord").setPoint(getlcalc_Coord_7_20_point()))))
        .addChild(new Shape("lcuboid")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.98).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lcuboid_Geo").setDEF("lcuboid_Geo").setCreaseAngle(1.571).setCoordIndex(getlcuboid_Geo_6_25_coordIndex())
            .setCoord(new Coordinate("lcuboid_Coord").setPoint(getlcuboid_Coord_7_25_point()))))
        .addChild(new Shape("llcun")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("llcun_Geo").setDEF("llcun_Geo").setCreaseAngle(1.571).setCoordIndex(getllcun_Geo_6_30_coordIndex())
            .setCoord(new Coordinate("llcun_Coord").setPoint(getllcun_Coord_7_30_point()))))
        .addChild(new Shape("lmcun")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lmcun_Geo").setDEF("lmcun_Geo").setCreaseAngle(1.571).setCoordIndex(getlmcun_Geo_6_35_coordIndex())
            .setCoord(new Coordinate("lmcun_Coord").setPoint(getlmcun_Coord_7_35_point()))))
        .addChild(new Shape("lnaviclr")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lnaviclr_Geo").setDEF("lnaviclr_Geo").setCreaseAngle(1.571).setCoordIndex(getlnaviclr_Geo_6_40_coordIndex())
            .setCoord(new Coordinate("lnaviclr_Coord").setPoint(getlnaviclr_Coord_7_40_point()))))
        .addChild(new Shape("lfmphal")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfmphal_Geo").setDEF("lfmphal_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal_Geo_6_45_coordIndex())
            .setCoord(new Coordinate("lfmphal_Coord").setPoint(getlfmphal_Coord_7_45_point()))))
        .addChild(new Shape("lfmphal2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfmphal2_Geo").setDEF("lfmphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal2_Geo_6_50_coordIndex())
            .setCoord(new Coordinate("lfmphal2_Coord").setPoint(getlfmphal2_Coord_7_50_point()))))
        .addChild(new Shape("lfmphal3")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfmphal3_Geo").setDEF("lfmphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal3_Geo_6_55_coordIndex())
            .setCoord(new Coordinate("lfmphal3_Coord").setPoint(getlfmphal3_Coord_7_55_point()))))
        .addChild(new Shape("lfmphal4")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfmphal4_Geo").setDEF("lfmphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmphal4_Geo_6_60_coordIndex())
            .setCoord(new Coordinate("lfmphal4_Coord").setPoint(getlfmphal4_Coord_7_60_point()))))
        .addChild(new Shape("lfpprox")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfpprox_Geo").setDEF("lfpprox_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox_Geo_6_65_coordIndex())
            .setCoord(new Coordinate("lfpprox_Coord").setPoint(getlfpprox_Coord_7_65_point()))))
        .addChild(new Shape("lfpprox2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfpprox2_Geo").setDEF("lfpprox2_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox2_Geo_6_70_coordIndex())
            .setCoord(new Coordinate("lfpprox2_Coord").setPoint(getlfpprox2_Coord_7_70_point()))))
        .addChild(new Shape("lfpprox3")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfpprox3_Geo").setDEF("lfpprox3_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox3_Geo_6_75_coordIndex())
            .setCoord(new Coordinate("lfpprox3_Coord").setPoint(getlfpprox3_Coord_7_75_point()))))
        .addChild(new Shape("lfpprox4")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfpprox4_Geo").setDEF("lfpprox4_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox4_Geo_6_80_coordIndex())
            .setCoord(new Coordinate("lfpprox4_Coord").setPoint(getlfpprox4_Coord_7_80_point()))))
        .addChild(new Shape("lfpprox5")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfpprox5_Geo").setDEF("lfpprox5_Geo").setCreaseAngle(1.571).setCoordIndex(getlfpprox5_Geo_6_85_coordIndex())
            .setCoord(new Coordinate("lfpprox5_Coord").setPoint(getlfpprox5_Coord_7_85_point()))))
        .addChild(new Shape("lfmet")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfmet_Geo").setDEF("lfmet_Geo").setCreaseAngle(1.571).setCoordIndex(getlfmet_Geo_6_90_coordIndex())
            .setCoord(new Coordinate("lfmet_Coord").setPoint(getlfmet_Coord_7_90_point()))))
        .addChild(new Shape("lmet2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lmet2_Geo").setDEF("lmet2_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet2_Geo_6_95_coordIndex())
            .setCoord(new Coordinate("lmet2_Coord").setPoint(getlmet2_Coord_7_95_point()))))
        .addChild(new Shape("lmet3")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lmet3_Geo").setDEF("lmet3_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet3_Geo_6_100_coordIndex())
            .setCoord(new Coordinate("lmet3_Coord").setPoint(getlmet3_Coord_7_100_point()))))
        .addChild(new Shape("lmet4")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lmet4_Geo").setDEF("lmet4_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet4_Geo_6_105_coordIndex())
            .setCoord(new Coordinate("lmet4_Coord").setPoint(getlmet4_Coord_7_105_point()))))
        .addChild(new Shape("lmet5")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lmet5_Geo").setDEF("lmet5_Geo").setCreaseAngle(1.571).setCoordIndex(getlmet5_Geo_6_110_coordIndex())
            .setCoord(new Coordinate("lmet5_Coord").setPoint(getlmet5_Coord_7_110_point()))))
        .addChild(new Shape("lfdphal")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfdphal_Geo").setDEF("lfdphal_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal_Geo_6_115_coordIndex())
            .setCoord(new Coordinate("lfdphal_Coord").setPoint(getlfdphal_Coord_7_115_point()))))
        .addChild(new Shape("lfdphal2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfdphal2_Geo").setDEF("lfdphal2_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal2_Geo_6_120_coordIndex())
            .setCoord(new Coordinate("lfdphal2_Coord").setPoint(getlfdphal2_Coord_7_120_point()))))
        .addChild(new Shape("lfdphal3")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfdphal3_Geo").setDEF("lfdphal3_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal3_Geo_6_125_coordIndex())
            .setCoord(new Coordinate("lfdphal3_Coord").setPoint(getlfdphal3_Coord_7_125_point()))))
        .addChild(new Shape("lfdphal4")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.5,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lfdphal4_Geo").setDEF("lfdphal4_Geo").setCreaseAngle(1.571).setCoordIndex(getlfdphal4_Geo_6_130_coordIndex())
            .setCoord(new Coordinate("lfdphal4_Coord").setPoint(getlfdphal4_Coord_7_130_point())))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getltalus_Geo_6_15_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,7,8,9,-1,10,11,7,-1,12,13,14,-1,15,16,17,-1,18,19,16,-1,20,21,22,-1,23,24,25,-1,8,26,13,-1,13,26,27,-1,27,14,13,-1,28,29,30,-1,31,32,33,-1,32,34,33,-1,28,35,36,-1,4,32,2,-1,32,37,2,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,45,47,46,-1,48,49,50,-1,50,51,48,-1,52,53,54,-1,55,56,57,-1,56,58,57,-1,59,60,61,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,68,71,69,-1,65,67,72,-1,72,73,65,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,77,83,84,-1,77,79,83,-1,85,86,80,-1,80,87,85,-1,88,89,90,-1,91,57,92,-1,93,94,95,-1,94,96,95,-1,97,90,98,-1,97,99,90,-1,100,93,95,-1,100,101,93,-1,102,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,113,114,111,-1,115,112,111,-1,115,116,112,-1,117,118,119,-1,117,120,118,-1,121,122,123,-1,123,124,125,-1,123,126,124,-1,127,128,129,-1,130,131,132,-1,130,133,131,-1,134,135,136,-1,136,137,134,-1,112,116,138,-1,139,140,141,-1,142,143,144,-1,142,145,143,-1,146,147,145,-1,148,149,150,-1,151,152,153,-1,152,154,153,-1,155,156,157,-1,155,158,156,-1,146,154,56,-1,159,160,161,-1,159,162,160,-1,163,164,165,-1,30,166,167,-1,168,89,169,-1,58,152,170,-1,171,91,94,-1,172,129,128,-1,128,173,172,-1,41,174,42,-1,41,175,174,-1,175,176,177,-1,175,178,176,-1,179,180,181,-1,59,182,183,-1,156,61,184,-1,185,186,171,-1,187,188,189,-1,187,55,188,-1,190,191,60,-1,190,192,191,-1,144,143,192,-1,140,193,190,-1,182,140,183,-1,182,141,140,-1,146,194,154,-1,195,196,197,-1,196,198,197,-1,162,199,148,-1,162,200,199,-1,201,202,203,-1,201,204,202,-1,205,206,207,-1,207,208,205,-1,209,210,211,-1,210,212,211,-1,213,214,215,-1,213,216,214,-1,217,218,219,-1,218,220,219,-1,46,174,221,-1,46,42,174,-1,222,223,224,-1,223,225,224,-1,174,175,226,-1,44,221,227,-1,44,46,221,-1,228,109,108,-1,141,202,139,-1,141,203,202,-1,229,230,231,-1,232,233,234,-1,113,235,236,-1,235,237,236,-1,103,238,239,-1,228,239,240,-1,241,236,104,-1,236,237,104,-1,112,242,113,-1,242,235,113,-1,243,244,245,-1,246,247,138,-1,138,116,246,-1,248,105,107,-1,249,115,111,-1,249,250,158,-1,158,244,249,-1,186,248,107,-1,186,251,248,-1,162,150,160,-1,162,148,150,-1,150,252,160,-1,253,252,150,-1,150,229,253,-1,254,231,255,-1,254,256,231,-1,257,258,259,-1,259,260,257,-1,164,261,262,-1,262,165,164,-1,263,264,165,-1,64,265,62,-1,266,260,259,-1,266,64,260,-1,267,268,269,-1,270,271,272,-1,273,274,275,-1,275,276,277,-1,15,273,275,-1,278,279,280,-1,278,281,279,-1,282,283,284,-1,273,15,17,-1,17,285,273,-1,286,287,288,-1,286,289,287,-1,286,290,289,-1,280,291,292,-1,280,279,291,-1,133,293,294,-1,133,130,293,-1,295,296,297,-1,296,298,297,-1,299,1,3,-1,3,300,299,-1,2,37,0,-1,301,302,0,-1,0,37,301,-1,303,304,305,-1,305,306,303,-1,307,308,305,-1,307,309,308,-1,308,125,310,-1,308,311,125,-1,312,313,314,-1,315,118,316,-1,118,317,316,-1,318,319,320,-1,318,321,319,-1,322,323,324,-1,322,325,323,-1,323,326,327,-1,326,328,75,-1,326,329,328,-1,330,331,332,-1,333,169,334,-1,333,168,169,-1,335,77,336,-1,335,337,77,-1,66,338,339,-1,66,340,338,-1,341,342,50,-1,50,52,341,-1,343,344,345,-1,346,347,348,-1,346,349,347,-1,350,345,351,-1,350,343,345,-1,351,352,350,-1,351,353,352,-1,348,354,346,-1,348,355,354,-1,356,357,358,-1,359,360,361,-1,359,362,360,-1,354,362,353,-1,354,360,362,-1,363,364,87,-1,365,366,367,-1,365,85,366,-1,367,97,368,-1,368,369,367,-1,100,169,88,-1,100,320,169,-1,28,370,371,-1,28,372,370,-1,28,36,39,-1,6,373,374,-1,6,375,373,-1,376,377,167,-1,377,30,167,-1,378,377,376,-1,378,379,377,-1,337,380,381,-1,337,335,380,-1,381,378,382,-1,382,337,381,-1,383,379,384,-1,385,53,386,-1,385,54,53,-1,387,70,69,-1,69,388,387,-1};
			return value;
		}
		private int[] getltalus_Geo_6_15_coordIndex_2()
		{
			int[] value = {40,389,38,-1,390,391,392,-1,175,41,178,-1,51,393,394,-1,57,91,188,-1,91,171,189,-1,189,188,91,-1,51,394,48,-1,248,395,396,-1,396,397,248,-1,398,38,389,-1,398,399,38,-1,400,401,385,-1,401,54,385,-1,34,32,4,-1,301,31,33,-1,381,301,384,-1,381,380,301,-1,402,403,404,-1,402,405,403,-1,9,406,10,-1,407,373,375,-1,371,35,28,-1,372,408,370,-1,30,372,28,-1,90,168,98,-1,90,89,168,-1,85,365,86,-1,366,409,99,-1,366,410,409,-1,251,411,395,-1,251,410,411,-1,87,80,363,-1,80,82,363,-1,412,362,359,-1,412,413,362,-1,361,358,357,-1,361,360,358,-1,81,352,82,-1,350,414,343,-1,415,48,394,-1,65,416,340,-1,340,66,65,-1,386,417,418,-1,386,53,417,-1,338,78,339,-1,78,382,339,-1,347,419,418,-1,418,417,347,-1,420,421,329,-1,420,422,421,-1,328,423,424,-1,328,425,423,-1,426,329,326,-1,426,420,329,-1,75,327,326,-1,75,74,327,-1,326,325,426,-1,326,323,325,-1,303,427,180,-1,303,428,427,-1,22,21,429,-1,430,302,431,-1,432,433,434,-1,316,435,124,-1,316,433,435,-1,436,437,312,-1,437,313,312,-1,428,303,306,-1,306,438,428,-1,439,133,294,-1,439,127,133,-1,440,441,442,-1,440,443,441,-1,444,445,446,-1,445,447,446,-1,130,136,293,-1,136,448,293,-1,293,292,449,-1,449,294,293,-1,280,292,293,-1,293,448,280,-1,448,450,280,-1,290,451,289,-1,290,452,451,-1,18,275,453,-1,274,273,454,-1,454,268,274,-1,268,288,269,-1,268,454,288,-1,265,287,62,-1,287,455,62,-1,21,456,457,-1,21,20,456,-1,64,269,265,-1,165,262,257,-1,257,263,165,-1,458,163,165,-1,264,459,458,-1,460,461,456,-1,461,457,456,-1,254,462,256,-1,254,463,462,-1,231,256,253,-1,253,229,231,-1,464,462,465,-1,462,463,465,-1,160,252,161,-1,252,466,161,-1,244,158,155,-1,227,138,44,-1,138,247,44,-1,138,227,112,-1,227,242,112,-1,467,114,468,-1,468,469,467,-1,108,239,228,-1,108,103,239,-1,470,240,238,-1,240,239,238,-1,471,472,232,-1,472,233,232,-1,230,229,473,-1,468,474,469,-1,475,227,221,-1,195,197,218,-1,218,476,195,-1,477,478,479,-1,479,220,477,-1,480,218,217,-1,480,476,218,-1,219,220,481,-1,220,479,481,-1,207,213,204,-1,207,482,213,-1,483,208,201,-1,195,458,459,-1,459,196,195,-1,142,214,484,-1,484,145,142,-1,143,485,486,-1,155,189,245,-1,183,60,59,-1,93,185,171,-1,171,94,93,-1,181,173,179,-1,27,457,461,-1,27,487,457,-1,114,467,111,-1,41,223,488,-1,41,43,223,-1,248,397,489,-1,395,248,251,-1,224,490,491,-1,492,493,494,-1,120,317,118,-1,89,88,169,-1,495,166,30,-1,30,29,495,-1,108,474,241,-1,201,203,483,-1,496,55,187,-1,496,56,55,-1,141,182,110,-1,182,469,110,-1,58,56,154,-1,154,152,58,-1,240,497,483,-1,483,228,240,-1,187,189,155,-1,498,148,199,-1,498,149,148,-1,455,196,62,-1,196,459,62,-1,260,263,257,-1,499,149,498,-1,146,56,147,-1,244,155,245,-1,500,501,135,-1,135,134,500,-1,136,132,137,-1,136,130,132,-1,131,133,127,-1,127,129,131,-1,492,494,279,-1,494,291,279,-1,270,272,19,-1,272,16,19,-1,126,316,124,-1,502,503,504,-1,330,117,505,-1,330,120,117,-1,506,315,314,-1,105,116,243,-1,116,115,243,-1,103,241,104,-1,103,108,241,-1,474,110,469,-1,474,108,110,-1,245,189,106,-1,189,171,106,-1,88,99,409,-1,88,90,99,-1,507,91,92,-1,101,185,93,-1,412,411,364,-1,412,395,411,-1,491,415,508,-1,491,356,415,-1,78,338,418,-1,338,386,418,-1,412,359,395,-1,359,396,395,-1,416,509,400,-1,509,401,400,-1,81,414,350,-1,350,352,81,-1,510,414,81,-1,77,84,336,-1,511,512,513,-1,120,434,317,-1,120,514,434,-1,264,458,165,-1,63,260,64,-1,188,55,57,-1,187,155,157,-1,387,512,70,-1,515,516,68,-1,68,511,515,-1,393,50,342,-1,393,51,50,-1,81,80,510,-1,248,489,246,-1,40,39,406,-1,39,36,406,-1,299,517,5,-1,5,1,299,-1,39,177,28,-1,301,37,31,-1,377,373,407,-1,377,379,373,-1,37,32,31,-1,461,518,14,-1,14,27,461,-1,258,464,519,-1,520,521,19,-1,456,23,25,-1,25,460,456,-1,465,460,25,-1,520,453,22,-1};
			return value;
		}
		private int[] getltalus_Geo_6_15_coordIndex_3()
		{
			int[] value = {275,18,16,-1,16,15,275,-1,7,9,10,-1,390,26,391,-1,390,27,26,-1,33,383,384,-1,384,301,33,-1,6,374,34,-1,4,6,34,-1,33,374,383,-1,34,374,33,-1,26,7,391,-1,26,8,7,-1,20,23,456,-1,20,522,23,-1,522,22,277,-1,522,20,22,-1,24,522,523,-1,522,24,23,-1,461,465,518,-1,460,465,461,-1,524,221,174,-1,524,475,221,-1,373,383,374,-1,379,383,373,-1,406,12,40,-1,406,9,12,-1,403,392,11,-1,392,403,295,-1,405,299,296,-1,405,517,299,-1,247,489,525,-1,247,246,489,-1,515,342,516,-1,515,393,342,-1,70,511,68,-1,512,511,70,-1,401,526,341,-1,526,401,509,-1,514,527,434,-1,514,528,527,-1,76,83,529,-1,76,84,83,-1,323,530,324,-1,323,327,530,-1,415,531,508,-1,531,415,394,-1,532,359,361,-1,359,532,396,-1,85,364,411,-1,87,364,85,-1,510,86,324,-1,86,510,80,-1,79,418,419,-1,418,79,78,-1,340,386,338,-1,340,385,386,-1,531,393,515,-1,531,394,393,-1,361,490,532,-1,357,490,361,-1,344,533,529,-1,344,343,533,-1,534,97,98,-1,368,97,534,-1,241,468,236,-1,474,468,241,-1,331,535,536,-1,331,537,535,-1,537,330,505,-1,537,331,330,-1,447,437,446,-1,447,313,437,-1,504,538,539,-1,538,504,540,-1,541,19,521,-1,19,541,270,-1,16,284,17,-1,272,284,16,-1,281,492,279,-1,281,283,492,-1,494,542,291,-1,494,543,542,-1,544,545,546,-1,545,544,547,-1,502,539,548,-1,502,504,539,-1,145,485,143,-1,147,485,145,-1,196,451,198,-1,451,196,455,-1,459,63,62,-1,459,264,63,-1,264,260,63,-1,260,264,263,-1,549,550,551,-1,550,549,452,-1,552,151,153,-1,151,552,553,-1,250,59,61,-1,467,59,250,-1,240,554,497,-1,470,554,240,-1,469,59,467,-1,182,59,469,-1,110,203,141,-1,110,109,203,-1,470,555,554,-1,555,470,556,-1,501,290,286,-1,500,290,501,-1,471,473,557,-1,471,230,473,-1,102,499,558,-1,102,557,499,-1,559,280,450,-1,278,280,559,-1,560,561,562,-1,561,560,563,-1,564,503,502,-1,564,565,503,-1,563,271,561,-1,563,282,271,-1,546,566,567,-1,546,545,566,-1,543,493,568,-1,543,494,493,-1,126,315,316,-1,126,314,315,-1,126,312,314,-1,433,317,434,-1,317,433,316,-1,222,491,508,-1,224,491,222,-1,525,397,569,-1,525,489,397,-1,389,12,14,-1,12,389,40,-1,226,254,255,-1,399,254,226,-1,412,363,413,-1,412,364,363,-1,186,101,251,-1,185,101,186,-1,156,570,157,-1,184,570,156,-1,496,486,485,-1,496,570,486,-1,215,142,571,-1,215,214,142,-1,194,145,484,-1,194,146,145,-1,153,572,552,-1,572,153,573,-1,477,551,478,-1,477,549,551,-1,163,195,476,-1,458,195,163,-1,574,159,261,-1,574,575,159,-1,576,554,555,-1,576,577,554,-1,205,483,497,-1,208,483,205,-1,577,209,211,-1,576,209,577,-1,213,202,204,-1,213,215,202,-1,578,207,206,-1,578,482,207,-1,481,482,578,-1,481,579,482,-1,212,217,219,-1,210,217,212,-1,216,484,214,-1,216,580,484,-1,481,581,579,-1,481,479,581,-1,194,580,573,-1,580,194,484,-1,572,479,478,-1,479,572,581,-1,220,197,477,-1,218,197,220,-1,227,234,242,-1,227,475,234,-1,490,225,582,-1,225,490,224,-1,558,103,102,-1,558,238,103,-1,569,45,525,-1,45,569,582,-1,466,262,161,-1,466,257,262,-1,462,258,583,-1,258,462,464,-1,558,498,556,-1,558,499,498,-1,102,237,472,-1,104,237,102,-1,583,256,462,-1,583,253,256,-1,175,399,226,-1,175,38,399,-1,519,24,584,-1,25,24,519,-1,268,585,274,-1,585,268,267,-1,276,586,523,-1,586,276,585,-1,523,584,24,-1,523,586,584,-1,269,287,265,-1,269,288,287,-1,500,452,290,-1,452,500,550,-1,134,550,500,-1,550,134,553,-1,135,448,136,-1,135,450,448,-1,501,450,135,-1,501,559,450,-1,449,291,542,-1,292,291,449,-1,152,137,132,-1,137,152,151,-1,538,520,587,-1,520,538,521,-1,429,588,22,-1,429,589,588,-1,590,27,390,-1,590,487,27,-1,588,591,587,-1,588,592,591,-1,593,590,594,-1,590,593,589,-1,392,297,390,-1,392,295,297,-1,592,595,591,-1,592,596,595,-1,594,597,593,-1,594,598,597,-1,595,599,444,-1,596,599,595,-1,597,600,601,-1,598,600,597,-1,298,299,300,-1,296,299,298,-1,599,445,444,-1,599,442,445,-1};
			return value;
		}
		private int[] getltalus_Geo_6_15_coordIndex_4()
		{
			int[] value = {602,601,600,-1,602,440,601,-1,442,603,445,-1,442,441,603,-1,604,440,602,-1,604,443,440,-1,605,441,606,-1,441,605,603,-1,430,443,604,-1,430,607,443,-1,128,439,307,-1,128,127,439,-1,432,428,438,-1,432,608,428,-1,435,306,310,-1,306,435,438,-1,439,449,609,-1,294,449,439,-1,547,309,609,-1,547,544,309,-1,565,122,567,-1,565,564,122,-1,568,282,563,-1,568,493,282,-1,540,503,562,-1,504,503,540,-1,436,502,437,-1,436,564,502,-1,608,434,527,-1,432,434,608,-1,380,423,431,-1,380,335,423,-1,425,431,423,-1,425,430,431,-1,606,421,422,-1,606,607,421,-1,429,457,487,-1,429,21,457,-1,181,427,610,-1,181,180,427,-1,180,304,303,-1,180,179,304,-1,608,427,428,-1,608,321,427,-1,369,535,611,-1,369,368,535,-1,332,536,612,-1,332,331,536,-1,325,613,426,-1,325,611,613,-1,84,424,336,-1,76,424,84,-1,426,614,420,-1,613,614,426,-1,528,319,527,-1,528,334,319,-1,335,424,423,-1,424,335,336,-1,329,425,328,-1,329,421,425,-1,420,615,422,-1,614,615,420,-1,117,614,505,-1,615,614,117,-1,77,382,78,-1,382,77,337,-1,416,73,509,-1,65,73,416,-1,531,511,513,-1,515,511,531,-1,616,415,356,-1,48,415,616,-1,617,48,616,-1,617,49,48,-1,417,49,617,-1,417,53,49,-1,86,322,324,-1,322,86,365,-1,358,354,355,-1,358,360,354,-1,82,413,363,-1,82,352,413,-1,409,251,101,-1,409,410,251,-1,411,366,85,-1,366,411,410,-1,98,333,534,-1,98,168,333,-1,318,96,610,-1,95,96,318,-1,172,92,57,-1,172,173,92,-1,72,388,69,-1,495,388,72,-1,495,67,166,-1,67,495,72,-1,377,372,30,-1,377,407,372,-1,407,408,372,-1,408,407,375,-1,10,371,404,-1,371,10,35,-1,370,618,402,-1,408,618,370,-1,404,11,10,-1,404,403,11,-1,402,517,405,-1,618,517,402,-1,618,5,517,-1,618,6,5,-1,431,301,380,-1,431,302,301,-1,518,463,398,-1,465,463,518,-1,561,270,541,-1,561,271,270,-1,396,569,397,-1,532,569,396,-1,178,488,387,-1,488,178,41,-1,398,14,518,-1,398,389,14,-1,177,38,175,-1,177,39,38,-1,387,176,178,-1,176,387,388,-1,513,387,488,-1,512,387,513,-1,381,379,378,-1,384,379,381,-1,382,376,339,-1,382,378,376,-1,339,167,66,-1,339,376,167,-1,408,6,618,-1,375,6,408,-1,371,402,404,-1,370,402,371,-1,406,35,10,-1,35,406,36,-1,166,66,167,-1,66,166,67,-1,495,176,388,-1,495,29,176,-1,170,57,58,-1,172,57,170,-1,610,507,181,-1,96,507,610,-1,320,95,318,-1,100,95,320,-1,365,369,322,-1,365,367,369,-1,97,366,99,-1,97,367,366,-1,352,362,413,-1,353,362,352,-1,356,355,616,-1,356,358,355,-1,616,348,617,-1,616,355,348,-1,351,354,353,-1,346,354,351,-1,346,345,349,-1,351,345,346,-1,347,617,348,-1,347,417,617,-1,53,50,49,-1,53,52,50,-1,619,347,349,-1,419,347,619,-1,349,344,619,-1,344,349,345,-1,68,526,71,-1,68,516,526,-1,509,71,526,-1,509,73,71,-1,330,514,120,-1,330,332,514,-1,332,528,514,-1,528,332,612,-1,334,320,319,-1,334,169,320,-1,528,333,334,-1,333,528,612,-1,613,505,614,-1,613,537,505,-1,424,75,328,-1,75,424,76,-1,611,537,613,-1,611,535,537,-1,612,534,333,-1,612,536,534,-1,322,611,325,-1,369,611,322,-1,527,321,608,-1,527,319,321,-1,179,128,304,-1,179,173,128,-1,610,321,318,-1,610,427,321,-1,606,615,605,-1,615,606,422,-1,425,607,430,-1,421,607,425,-1,605,117,119,-1,605,615,117,-1,123,564,436,-1,122,564,123,-1,541,562,561,-1,541,540,562,-1,567,560,565,-1,566,560,567,-1,609,542,547,-1,449,542,609,-1,544,308,309,-1,544,311,308,-1,435,125,124,-1,310,125,435,-1,307,609,309,-1,439,609,307,-1,306,308,310,-1,305,308,306,-1,433,438,435,-1,438,433,432,-1,307,304,128,-1,305,304,307,-1,604,302,430,-1,0,302,604,-1,606,443,607,-1,443,606,441,-1,605,506,603,-1,605,119,506,-1,0,602,3,-1,0,604,602,-1,603,447,445,-1,603,506,447,-1,600,3,602,-1,300,3,600,-1,440,599,601,-1,440,442,599,-1,598,300,600,-1,298,300,598,-1,601,596,597,-1,601,599,596,-1,444,548,595,-1,444,446,548,-1,594,298,598,-1,297,298,594,-1,596,593,597,-1,593,596,592,-1};
			return value;
		}
		private int[] getltalus_Geo_6_15_coordIndex_5()
		{
			int[] value = {591,548,539,-1,591,595,548,-1,390,594,590,-1,390,297,594,-1,589,592,588,-1,589,593,592,-1,539,587,591,-1,587,539,538,-1,589,487,590,-1,487,589,429,-1,22,587,520,-1,22,588,587,-1,170,132,131,-1,170,152,132,-1,493,283,282,-1,492,283,493,-1,553,137,151,-1,134,137,553,-1,286,559,501,-1,286,620,559,-1,454,286,288,-1,620,286,454,-1,273,620,454,-1,620,273,285,-1,282,272,271,-1,284,272,282,-1,287,451,455,-1,289,451,287,-1,285,281,278,-1,17,281,285,-1,274,276,275,-1,585,276,274,-1,266,269,64,-1,267,269,266,-1,586,259,584,-1,266,259,586,-1,585,266,586,-1,585,267,266,-1,258,584,259,-1,258,519,584,-1,253,466,252,-1,466,253,583,-1,231,524,255,-1,231,232,524,-1,472,557,102,-1,471,557,472,-1,257,583,258,-1,257,466,583,-1,150,473,229,-1,473,150,149,-1,261,161,262,-1,261,159,161,-1,243,249,244,-1,243,115,249,-1,186,106,171,-1,107,106,186,-1,250,111,467,-1,249,111,250,-1,116,248,246,-1,116,105,248,-1,238,556,470,-1,556,238,558,-1,235,472,237,-1,472,235,233,-1,233,242,234,-1,235,242,233,-1,582,532,490,-1,582,569,532,-1,47,582,225,-1,582,47,45,-1,255,174,226,-1,174,255,524,-1,488,222,513,-1,488,223,222,-1,43,225,223,-1,47,225,43,-1,573,581,572,-1,581,573,580,-1,581,216,579,-1,581,580,216,-1,574,217,210,-1,574,480,217,-1,578,219,481,-1,212,219,578,-1,213,579,216,-1,482,579,213,-1,209,574,210,-1,575,574,209,-1,206,212,578,-1,211,212,206,-1,209,200,575,-1,200,209,576,-1,205,211,206,-1,577,211,205,-1,207,201,208,-1,207,204,201,-1,497,577,205,-1,577,497,554,-1,555,200,576,-1,200,555,199,-1,575,162,159,-1,575,200,162,-1,480,261,164,-1,480,574,261,-1,197,549,477,-1,197,198,549,-1,478,552,572,-1,478,551,552,-1,573,154,194,-1,573,153,154,-1,56,485,147,-1,485,56,496,-1,571,202,215,-1,571,139,202,-1,140,60,183,-1,140,190,60,-1,192,193,144,-1,192,190,193,-1,486,192,143,-1,191,192,486,-1,191,570,184,-1,191,486,570,-1,187,570,496,-1,570,187,157,-1,184,60,191,-1,60,184,61,-1,463,399,398,-1,463,254,399,-1,177,29,28,-1,177,176,29,-1,131,172,170,-1,131,129,172,-1,181,92,173,-1,92,181,507,-1,513,508,531,-1,222,508,513,-1,436,126,123,-1,312,126,436,-1,568,545,543,-1,566,545,568,-1,567,121,546,-1,122,121,567,-1,562,565,560,-1,503,565,562,-1,566,563,560,-1,563,566,568,-1,620,278,559,-1,285,278,620,-1,164,476,480,-1,164,163,476,-1,230,232,231,-1,471,232,230,-1,557,149,499,-1,557,473,149,-1,109,483,203,-1,109,228,483,-1,61,158,250,-1,158,61,156,-1,198,452,549,-1,451,452,198,-1,551,553,552,-1,553,551,550,-1,556,199,555,-1,498,199,556,-1,139,193,140,-1,193,139,571,-1,144,571,142,-1,144,193,571,-1,125,121,123,-1,125,311,121,-1,315,119,118,-1,315,506,119,-1,311,546,121,-1,546,311,544,-1,543,547,542,-1,543,545,547,-1,17,283,281,-1,17,284,283,-1,540,521,538,-1,521,540,541,-1,437,548,446,-1,548,437,502,-1,314,447,506,-1,314,313,447,-1,105,245,106,-1,105,243,245,-1,114,236,468,-1,113,236,114,-1,368,536,535,-1,368,534,536,-1,88,101,100,-1,409,101,88,-1,91,96,94,-1,91,507,96,-1,419,83,79,-1,419,619,83,-1,533,414,530,-1,533,343,414,-1,341,516,342,-1,341,526,516,-1,529,619,344,-1,529,83,619,-1,416,385,340,-1,416,400,385,-1,490,356,491,-1,490,357,356,-1,529,74,76,-1,529,533,74,-1,533,327,74,-1,327,533,530,-1,324,414,510,-1,530,414,324,-1,69,73,72,-1,71,73,69,-1,52,401,341,-1,52,54,401,-1,525,44,247,-1,45,44,525,-1,46,43,42,-1,46,47,43,-1,405,295,403,-1,295,405,296,-1,391,11,392,-1,11,391,7,-1,232,475,524,-1,232,234,475,-1,25,464,465,-1,25,519,464,-1,277,523,522,-1,277,276,523,-1,453,277,22,-1,453,275,277,-1,18,520,19,-1,453,520,18,-1,8,12,9,-1,8,13,12,-1,1,4,2,-1,1,5,4,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getltalus_Coord_7_15_point_1()
		{
			double[] value = {2.84739,2.63438,-2.96794,3.03912,2.77029,-2.76724,2.96706,2.68782,-2.89604,2.92474,2.8024,-2.74663,3.0221,2.69259,-2.86979,3.07362,2.75422,-2.76949,3.13459,2.64733,-2.72555,3.04704,2.69662,-2.00971,3.03105,2.66388,-1.96595,3.06228,2.59994,-1.98561,3.13643,2.64567,-2.15571,3.05597,2.71937,-2.05696,3.03251,2.59711,-1.96622,3.00743,2.64912,-1.95045,2.88771,2.62457,-1.93139,1.83473,2.42496,-1.75739,1.79858,2.43466,-1.78068,1.75201,2.32913,-1.77376,1.92989,2.51337,-1.80691,1.83136,2.54116,-1.82949,2.39881,2.57177,-1.85265,2.4058,2.58431,-1.86909,2.23471,2.57908,-1.8617,2.56179,2.5006,-1.77745,2.55291,2.48736,-1.76601,2.61035,2.48289,-1.75864,3.00581,2.67767,-1.95975,2.8667,2.64855,-1.92802,3.17864,2.34986,-2.39722,3.16848,2.27465,-2.4082,3.20512,2.31495,-2.52186,2.98952,2.6028,-2.95841,3.00515,2.62581,-2.93943,3.02764,2.58124,-2.93629,3.04396,2.59925,-2.91049,3.16577,2.50486,-2.26742,3.11276,2.4399,-2.17802,2.94693,2.62145,-2.95275,2.89445,2.37125,-2.0678,3.09558,2.41942,-2.16443,3.05619,2.52219,-2.01093,2.91518,2.08033,-2.18725,2.73626,2.05618,-2.19511,2.74501,2.0281,-2.21825,2.47061,2.0029,-2.29102,2.48366,1.98484,-2.31837,2.62979,2.01408,-2.23912,2.64042,1.98995,-2.26306,2.99884,1.79121,-2.49689,3.12639,1.93152,-2.62774,3.28527,1.8457,-2.55399,3.2158,1.78588,-2.46499,3.3336,1.91915,-2.63536,3.24072,2.05406,-2.76748,3.36155,1.96215,-2.68309,1.78115,1.93352,-2.43678,1.75119,1.84401,-2.32633,1.76829,1.97557,-2.44828,1.74602,1.88397,-2.32323,2.28117,1.758,-2.30097,2.10914,1.70057,-2.26215,2.14817,1.8074,-2.41824,2.29882,2.34508,-1.18772,2.37547,2.3629,-1.2731,2.34206,2.36061,-1.31296,3.41989,2.05559,-2.66783,3.34996,2.1047,-2.72241,3.39668,2.08699,-2.64048,3.33538,1.87954,-2.41885,3.37771,1.97859,-2.47702,3.29603,1.91026,-2.38565,3.3994,1.94304,-2.51108,3.39525,2.03554,-2.55894,3.41332,1.99494,-2.58455,2.66621,2.1661,-3.29518,2.65672,2.21689,-3.28579,2.85525,2.25235,-3.23994,3.0509,2.27142,-3.0325,3.16391,2.22302,-2.92854,3.04656,2.24932,-3.03703,2.22059,1.88147,-3.15909,2.32734,1.9489,-3.17283,2.2532,1.94742,-3.10882,2.94258,2.2519,-3.16398,2.93819,2.27176,-3.16115,2.08534,1.8509,-3.10302,2.20855,1.8983,-3.18656,2.10927,1.86381,-3.08496,1.78944,1.8739,-2.98576,1.81038,1.88264,-3.05032,1.83492,1.86429,-3.05481,1.74263,2.02475,-2.56541,1.72479,2.06266,-2.54239,1.7399,1.97447,-2.71963,1.74396,2.00198,-2.6256,1.71424,1.99718,-2.7337,1.718,2.03799,-2.64425,1.93391,1.89192,-3.12897,1.87488,1.90805,-3.11463,1.86888,1.84771,-3.03902};
			return value;
		}
		private double[] getltalus_Coord_7_15_point_2()
		{
			double[] value = {1.74018,1.92934,-2.85171,1.77669,1.91588,-2.83604,2.50929,1.87417,-1.74034,2.42902,1.74754,-1.79899,2.43394,1.7718,-1.82478,2.04835,2.01221,-2.50994,1.9077,1.99614,-2.55523,1.93747,2.01016,-2.59923,2.33077,1.65373,-1.91466,2.29248,1.52893,-1.95101,2.26503,1.54955,-2.02842,2.28274,1.93462,-2.2761,2.3015,1.95855,-2.26409,2.34459,1.8862,-2.18735,2.33161,1.86121,-2.20849,2.18743,1.99711,-2.3937,2.20821,2.01663,-2.39713,1.98802,2.38857,-3.11466,1.9249,2.48246,-3.00755,1.95019,2.49753,-3.01645,1.95361,2.38019,-3.10414,1.81631,2.59703,-2.37178,1.82664,2.63436,-2.37772,1.84454,2.65898,-2.48736,1.84981,2.63913,-2.62586,1.84672,2.61848,-2.49524,1.86065,2.67879,-2.63302,1.79286,2.12697,-2.32844,1.80344,2.21294,-2.45738,1.77469,2.09099,-2.35194,1.78148,1.92753,-2.06134,1.76984,2.00856,-2.26231,1.7688,1.87973,-2.08114,1.7742,2.04869,-2.2392,1.73115,1.91622,-1.75501,1.74821,1.95973,-1.77666,1.77106,1.90171,-1.86978,1.74644,1.85891,-1.8628,2.31203,2.01351,-2.33599,2.16194,1.56347,-2.04181,2.16761,1.57613,-2.0587,2.23288,1.53685,-2.04849,1.94025,1.55822,-2.08176,1.84588,1.61471,-2.1595,1.9512,1.57211,-2.10199,1.81871,1.61632,-2.14981,1.75573,1.67576,-2.17073,1.77308,1.69085,-2.21975,2.61828,2.01308,-1.49785,2.61543,2.01448,-1.52738,2.63326,2.09261,-1.51117,1.71141,1.78766,-1.90042,1.7352,1.80217,-2.12083,1.70342,1.75797,-1.89707,1.73449,1.76711,-2.12651,1.87805,1.94181,-2.47484,2.02362,1.85664,-2.46051,1.8765,1.91224,-2.4514,2.03696,1.88491,-2.47652,2.56394,2.1045,-1.32143,2.61351,2.13181,-1.44883,2.60898,2.1716,-1.3815,2.60904,2.02828,-1.42444,2.41295,2.266,-1.19452,2.45651,2.22572,-1.20712,2.46735,2.31762,-1.26346,3.26933,2.19991,-2.56164,3.23456,2.22006,-2.63851,1.82298,1.91538,-3.09791,1.74717,1.9371,-3.04755,1.74315,1.93652,-2.30574,1.80051,1.9707,-2.59994,1.74972,2.03896,-2.39029,1.7235,2.11905,-2.51019,2.71757,2.16161,-2.10336,2.88823,2.24443,-2.11563,3.1115,2.21412,-2.28743,3.10333,2.28063,-2.25389,3.00177,2.12355,-2.20942,1.72698,2.17386,-2.603,1.72904,2.1831,-2.65011,1.70495,2.11017,-2.64408,2.27907,1.65963,-2.17431,2.22775,1.66474,-2.19069,2.00814,1.82735,-2.42086,1.77905,1.9749,-2.71505,1.85671,2.00135,-2.66956,1.82108,1.93251,-2.44689,1.77413,1.95973,-2.4753,1.78688,1.93984,-2.49522,2.07072,1.60373,-2.11142,1.96448,1.72511,-2.28639,1.95455,1.61483,-2.14818,2.06776,1.56834,-2.07508,1.74431,1.66361,-2.0781,2.24348,2.21951,-1.12226,2.17888,2.24969,-1.14195,2.07126,2.05442,-1.16666,2.04219,2.1023,-1.20199,2.59352,1.89761,-1.50041};
			return value;
		}
		private double[] getltalus_Coord_7_15_point_3()
		{
			double[] value = {2.53705,1.9216,-1.392,2.23255,1.51439,-1.87777,2.13623,1.50853,-1.92915,2.26249,1.50103,-1.94826,2.14851,1.49229,-1.85326,2.32031,1.55436,-1.6,2.21479,1.54768,-1.51955,2.15766,1.48935,-1.68449,2.2724,1.52272,-1.73014,2.36379,1.80368,-1.31554,2.28286,1.83466,-1.24401,2.2792,1.65136,-1.41537,2.15324,1.69465,-1.34845,2.02951,1.47451,-1.84704,1.91876,1.50988,-2.0018,2.03317,1.50419,-1.94345,1.89412,1.50009,-1.85793,2.19867,1.90475,-1.19601,2.14311,1.96399,-1.16337,2.04745,1.72393,-1.3158,1.95292,1.77667,-1.31016,2.58729,2.09366,-2.14789,2.86029,1.81145,-2.36263,2.79592,1.91609,-2.30491,2.69228,1.828,-2.42973,2.67012,1.90792,-2.33384,2.78373,2.23632,-2.03617,2.45896,2.04762,-2.18864,2.37821,1.5932,-1.83498,2.60243,2.15671,-1.65135,2.57678,2.09645,-1.71274,2.62548,2.18644,-1.7961,2.60003,2.13459,-1.89112,2.52609,2.05087,-1.98062,2.52826,2.07156,-2.00665,2.41487,1.9646,-2.09525,2.30858,1.79772,-2.04831,2.42043,1.87106,-1.96455,2.47395,1.71858,-1.67395,2.42042,1.66262,-1.75788,2.43744,1.60579,-1.70487,2.33491,1.69299,-1.93394,2.40915,2.00267,-2.14429,2.05019,1.99235,-2.48287,2.00059,1.94098,-2.49162,1.93081,1.97418,-2.51083,2.21871,2.03481,-2.47225,2.32242,2.01153,-2.40601,2.04295,2.02649,-2.65196,2.15181,1.91714,-2.40582,2.17501,1.82751,-2.42061,1.9262,1.96023,-2.82094,2.62941,2.18928,-1.50059,2.63792,2.24456,-1.60955,2.72078,2.35265,-1.91523,2.67895,2.22821,-1.95669,2.64593,2.2977,-1.77052,2.56504,2.30953,-1.40616,2.57542,2.37111,-1.54808,2.48015,2.36628,-1.53327,2.48208,2.35155,-1.38049,2.51306,2.15191,-1.25309,2.55551,2.25223,-1.31795,2.47778,2.33929,-1.32556,2.39113,2.35323,-1.25426,2.25956,2.33393,-1.27149,2.3246,2.33127,-1.52384,2.20761,2.33964,-1.52028,2.11473,2.32825,-1.5192,2.2137,2.35549,-1.32911,1.80666,2.53871,-1.85081,1.79485,2.51416,-1.87144,1.77776,2.43617,-1.81113,1.90754,2.40537,-1.71043,2.01002,2.39024,-1.67666,1.96955,2.49795,-1.80391,2.19276,2.48059,-1.78779,2.21711,2.54465,-1.84892,1.75107,2.18546,-1.76379,1.68922,2.20115,-1.90654,1.7378,2.10859,-1.89226,1.72199,2.26982,-1.81185,1.75251,2.42175,-1.93739,1.72023,2.30232,-1.83479,1.73951,2.34222,-1.80791,1.8093,2.29848,-1.70472,1.96254,2.20369,-1.37636,2.12897,2.23313,-1.26363,2.08813,2.30165,-1.35015,2.00479,2.12385,-1.31473,1.90273,2.06284,-1.37217,1.67691,2.19777,-2.03319,1.72286,2.14427,-2.05293,1.78715,2.00654,-2.03902,1.76451,2.1183,-2.19938,3.05681,2.80902,-2.24445,3.05625,2.85658,-2.4702,2.93987,2.83567,-2.22875,2.94277,2.86683,-2.47394,3.05787,2.83345,-2.63163};
			return value;
		}
		private double[] getltalus_Coord_7_15_point_4()
		{
			double[] value = {2.93566,2.83698,-2.61353,2.95916,2.51124,-2.9892,2.82659,2.49558,-3.05674,1.81417,2.30367,-2.61992,1.80427,2.27727,-2.54101,1.86141,2.3664,-2.48562,1.84449,2.3982,-2.60095,1.86564,2.3106,-2.38234,1.86754,2.51109,-2.418,1.84984,2.42542,-2.31303,1.8637,2.53489,-2.54204,1.82454,2.56469,-2.39039,1.89256,2.72631,-2.65691,1.91896,2.74293,-2.66543,1.91532,2.66217,-2.79089,1.91446,2.61574,-2.84914,1.86911,2.56254,-2.81679,1.9184,2.45091,-3.00944,1.70052,2.04405,-2.83384,1.74595,2.10165,-2.97611,1.71521,1.99072,-2.92764,1.74123,2.15962,-2.85923,2.18115,1.98459,-3.19255,2.40587,2.08004,-3.25531,2.36474,2.01954,-3.23705,2.21895,2.08976,-3.19719,2.44311,2.21592,-3.22614,2.47481,2.089,-3.2759,2.64599,2.29047,-3.20835,2.46021,2.30682,-3.19217,1.96766,2.26555,-3.17607,1.9663,2.21604,-3.19705,1.90858,2.22187,-3.17489,1.82751,2.01909,-3.16051,1.76713,2.03279,-3.10297,2.9675,2.32496,-3.07225,2.95956,2.28857,-3.1142,3.04854,2.30076,-3.01994,3.30806,2.13071,-2.83358,3.25727,2.19029,-2.83182,3.40726,2.05892,-2.74469,3.40067,1.86059,-2.57733,3.36448,1.82145,-2.50582,2.67781,2.11979,-3.28962,2.84095,2.20485,-3.24651,2.73076,2.16251,-3.21232,2.65265,2.08946,-2.95692,2.95722,2.19365,-2.98524,2.79734,2.07072,-2.81884,2.81033,2.1739,-3.12754,2.5098,2.06155,-3.17135,2.57205,2.08359,-3.04676,2.31804,2.00572,-3.02434,2.40061,2.00929,-2.91982,2.50161,2.00985,-2.80749,2.65813,1.94807,-2.67163,2.68285,1.7826,-2.50645,2.52875,1.81877,-2.55618,2.55035,1.87559,-2.60246,2.22478,1.91067,-2.67857,2.41038,1.93747,-2.70621,2.37509,1.86609,-2.60313,2.29093,1.96504,-2.79831,2.1221,1.91399,-3.01484,2.04046,1.90713,-2.96246,2.11211,1.87785,-3.16009,2.01971,1.8352,-3.07475,2.04431,1.88848,-3.16605,1.98918,2.00567,-3.20669,2.06496,1.99972,-3.20657,3.1683,2.53456,-2.4837,3.18169,2.5393,-2.3757,3.18663,2.3769,-2.50753,3.13014,2.50021,-2.78534,3.07223,2.57853,-2.8848,3.15188,2.51283,-2.66526,3.16684,2.27444,-2.74703,3.1761,2.39099,-2.65324,3.08339,2.32565,-2.84732,3.11128,2.47553,-2.80919,2.9672,2.4283,-3.01615,3.01876,2.4004,-2.97211,3.14245,2.26012,-2.92855,3.05859,2.55492,-2.90793,3.04189,2.50505,-2.94124,3.39655,2.03652,-2.75353,3.29651,2.10638,-2.83878,3.15175,2.00624,-2.32159,3.24343,2.08992,-2.38642,2.93494,2.52675,-1.9859,2.92794,2.73245,-2.00052,3.0214,2.7139,-2.00569,3.02992,2.74012,-2.0551,3.27956,1.75392,-2.44714,3.16623,1.74351,-2.40196,2.0151,1.95274,-2.81101,2.20289,1.92164,-2.64318,2.2171,1.98848,-2.56029,2.81636,2.49699,-1.92338,2.80775,2.36195,-1.99152};
			return value;
		}
		private double[] getltalus_Coord_7_15_point_5()
		{
			double[] value = {3.41428,2.00633,-2.71738,3.412,1.92059,-2.6432,3.14192,2.7003,-2.46546,3.08336,2.78942,-2.25036,3.14335,2.70352,-2.32316,3.08172,2.83821,-2.46915,3.07932,2.54281,-2.02179,3.1743,2.41607,-2.64233,3.15885,2.52185,-2.57362,1.82663,1.8616,-2.95895,1.93771,1.87246,-2.95462,1.99634,1.89137,-2.9673,2.04509,1.94758,-2.83506,2.18863,1.96882,-2.90564,2.4985,2.04655,-3.26928,2.92781,1.72307,-2.43696,3.4294,2.02557,-2.69963,3.09576,2.14097,-2.88069,3.15189,2.19383,-2.92761,3.03588,2.23001,-3.03544,2.30215,2.30889,-3.1815,2.45357,2.36951,-3.14451,2.31969,2.38915,-3.14336,2.83947,2.34464,-3.13923,2.84531,2.30708,-3.18403,2.63754,2.35659,-3.16287,2.26794,2.20939,-3.1966,1.7309,2.17953,-2.72348,1.79232,2.29927,-2.717,2.40818,2.60377,-1.88758,2.64695,2.47071,-3.09348,2.82259,2.45464,-3.07084,1.8359,2.37273,-2.83196,1.8483,2.45285,-2.83022,1.87925,2.33705,-2.99432,1.86023,2.52192,-2.63909,1.85589,2.73489,-2.47829,1.92313,2.81211,-2.49812,1.83977,2.39371,-2.691,1.83485,2.21135,-2.27764,2.44807,2.77199,-2.69562,2.33773,2.63231,-2.91858,2.34448,2.77305,-2.71534,2.45566,2.63413,-2.93315,2.1222,2.83942,-2.54637,2.12867,2.79238,-2.7016,1.95798,2.83081,-2.50236,1.95242,2.7555,-2.67299,1.76445,1.99289,-1.89543,1.73703,2.19573,-2.14175,1.74706,2.01011,-1.79933,2.03667,2.12132,-1.22366,1.83744,1.98175,-1.3351,1.98242,2.54278,-1.82582,2.01217,2.31951,-1.53271,2.16987,2.26461,-1.16185,2.5744,2.5194,-1.79371,2.60808,2.56982,-1.83731,2.35088,2.32302,-1.17708,2.31743,2.34016,-1.18023,2.62697,2.50299,-1.78362,2.68506,2.563,-1.85543,2.63813,2.38065,-1.74356,2.72818,2.44944,-1.8434,2.60324,2.41664,-1.70244,2.65083,2.48321,-1.78696,2.61056,2.26334,-1.45836,2.30272,1.78115,-2.29914,2.29706,1.77452,-2.06779,2.3053,1.66832,-2.13905,2.47608,1.66181,-1.60944,2.55114,2.03618,-1.7741,2.52361,1.97148,-1.84,2.57271,2.06536,-1.68447,2.3149,1.68306,-1.97488,2.57575,2.114,-2.07039,2.31113,2.14424,-1.1447,1.85102,1.87168,-1.30375,1.70713,1.80505,-1.5238,1.81944,1.67567,-1.51317,2.36387,2.08786,-1.16054,1.93852,1.60897,-1.47802,2.04054,1.4935,-1.67452,2.35485,1.56765,-1.83414,1.81012,1.57462,-2.03317,1.79095,1.70111,-2.24026,1.85875,1.72852,-2.28497,2.65808,2.63107,-1.90815,3.00035,1.9457,-2.25934,2.22044,2.02826,-2.50691,2.5279,1.81578,-2.51892,2.69401,1.77647,-2.46662,1.68598,2.23881,-1.91727,1.71082,2.32754,-1.99123,1.6714,2.23157,-2.02172,3.27709,2.15622,-2.47766,1.79718,1.85005,-2.37622,2.41548,1.58624,-1.69113,2.59732,1.89876,-1.52628,2.5859,1.91409,-1.57421};
			return value;
		}
		private double[] getltalus_Coord_7_15_point_6()
		{
			double[] value = {1.76234,2.01455,-1.60218,1.76971,2.05626,-1.63379,1.91789,2.80476,-2.39,1.87353,2.74114,-2.179,1.89783,2.7791,-2.16982,2.00414,2.26971,-3.18268,1.9468,2.63214,-2.86504,1.71981,2.05903,-2.57936,2.92289,1.72621,-2.40691,3.43597,1.93772,-2.62229,2.31952,1.96289,-3.20077,3.23721,1.86441,-2.37773,3.2238,1.88649,-2.36116,3.08605,1.84121,-2.31441,1.8821,2.25515,-3.13791,3.28808,1.76757,-2.41372,3.37966,1.83791,-2.48113,3.08259,2.81604,-2.63258,2.7176,2.54762,-1.86968,2.5712,2.42585,-1.6852,1.99847,2.59225,-1.86314,1.86884,2.624,-1.88696,2.38515,2.53022,-1.8371,2.35684,2.4777,-1.78132,2.64214,2.1694,-2.00298,2.34032,1.99683,-2.43058,3.4202,1.87737,-2.55453,1.80247,2.20991,-2.99101,1.81441,2.13065,-3.12875,2.8568,2.22959,-3.24559,2.4823,2.06548,-3.27852,3.16834,1.75446,-2.35982,2.36025,1.87101,-2.56781,2.67189,2.14389,-3.29888,1.93664,2.01811,-3.19983,1.99775,2.09553,-3.22598,1.94521,2.09079,-3.21367,2.00188,2.21129,-3.20419,1.90974,2.71529,-2.0073,1.93009,2.79681,-2.16344,1.87927,2.69976,-2.01918,1.84123,2.61452,-1.90426,1.6825,2.2579,-2.10949,1.67603,2.28564,-2.08755,1.7838,2.48797,-2.27846,1.73489,2.39988,-2.16368,1.77384,2.51605,-2.25708,1.74649,2.37625,-2.18523,1.95169,2.82348,-2.39195,1.83387,1.95884,-1.32623,1.71062,1.9328,-1.55211,1.70326,1.90352,-1.54133,1.67691,1.83012,-1.74353,1.68586,1.85806,-1.75004,2.45864,1.65065,-1.58419,2.53452,1.77106,-1.52248,2.54719,1.77633,-1.54899,2.53848,1.97797,-1.71648,2.52545,1.80913,-1.62167,1.76389,2.09737,-1.67515,1.79259,2.5564,-2.07127,1.8154,2.56162,-1.92707,1.84953,2.65027,-2.03425,1.76511,2.46551,-1.97873,1.84669,2.71144,-2.37081,1.8176,2.64947,-2.20305,1.7615,2.47247,-2.12563,1.79182,2.56987,-2.23961,1.72286,2.37784,-2.03567,2.37346,1.93443,-2.48292,1.8699,1.84155,-2.38706,2.06375,1.55379,-2.05383,1.68952,1.70936,-1.71221,1.71013,1.67646,-1.88688,2.4203,2.03569,-1.20227,2.48376,1.99209,-1.27973,2.43425,1.76156,-1.42379,2.37253,1.63449,-1.50634,2.08712,1.5596,-1.48634,1.91124,1.50382,-1.691,1.78878,1.55944,-1.88627,1.78596,1.58929,-1.70375,2.51078,1.91624,-2.39917,2.62455,2.31496,-1.59394,2.51156,2.4215,-1.67154,2.20075,2.40174,-1.67642,2.3448,2.40154,-1.66536,2.05991,2.71739,-1.99709,2.29652,2.70136,-2.02211,2.43727,2.69725,-2.0181,2.68979,2.71097,-2.00215,2.10894,2.81452,-2.20965,2.33934,2.78744,-2.20907,2.46322,2.78021,-2.20582,2.7271,2.82214,-2.22336,2.12839,2.8458,-2.42271,2.34126,2.81942,-2.43336,2.47956,2.83335,-2.45264,2.70287,2.86258,-2.46532,2.34194,2.81071,-2.55254};
			return value;
		}
		private double[] getltalus_Coord_7_15_point_7()
		{
			double[] value = {2.69089,2.84363,-2.60032,2.46571,2.81755,-2.56333,2.67036,2.7918,-2.73827,2.12085,2.64976,-2.92725,2.66647,2.63981,-2.95636,2.1153,2.4978,-3.06487,2.33886,2.47381,-3.07753,2.46204,2.46142,-3.08483,1.79483,2.28666,-2.85173,1.8181,2.30575,-2.21911,1.70708,2.09164,-2.71844,2.08366,2.11717,-3.2272,1.86043,2.09893,-3.17239,2.11541,2.21644,-3.22051,2.12442,2.30262,-3.20228,2.11817,2.40248,-3.15496,2.80345,1.87896,-2.58167,2.9489,2.0089,-2.7205,3.13471,2.68449,-2.61909,2.93898,2.23444,-3.15957,1.90498,2.24273,-1.53618};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlcalc_Geo_6_20_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,13,16,14,-1,17,18,19,-1,20,21,22,-1,20,23,21,-1,24,25,26,-1,26,27,24,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,35,37,36,-1,35,38,37,-1,39,40,41,-1,41,42,39,-1,43,44,45,-1,44,46,45,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,55,56,53,-1,57,58,59,-1,57,60,58,-1,61,47,62,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,69,72,70,-1,62,47,73,-1,73,74,62,-1,75,76,77,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,86,87,84,-1,77,88,89,-1,89,90,77,-1,91,92,93,-1,91,94,92,-1,95,96,83,-1,83,82,95,-1,97,98,99,-1,100,101,102,-1,103,104,105,-1,106,107,108,-1,107,109,108,-1,110,111,112,-1,112,113,110,-1,114,115,116,-1,116,117,114,-1,118,119,120,-1,121,19,122,-1,121,21,19,-1,123,124,125,-1,16,13,126,-1,126,127,16,-1,128,129,130,-1,29,28,131,-1,132,133,134,-1,135,136,137,-1,135,138,136,-1,139,14,1,-1,14,140,1,-1,129,141,142,-1,141,143,142,-1,144,145,146,-1,145,147,146,-1,148,149,127,-1,149,16,127,-1,150,24,151,-1,150,152,24,-1,153,154,155,-1,156,157,158,-1,157,159,158,-1,160,161,162,-1,160,163,161,-1,164,41,120,-1,165,166,167,-1,74,64,63,-1,168,169,170,-1,171,172,173,-1,171,174,172,-1,175,176,177,-1,175,178,176,-1,175,179,178,-1,118,38,52,-1,118,40,38,-1,62,180,181,-1,181,182,62,-1,183,184,185,-1,186,187,188,-1,189,188,190,-1,87,191,192,-1,192,193,87,-1,184,194,195,-1,90,196,197,-1,197,77,90,-1,51,61,52,-1,51,47,61,-1,198,199,200,-1,201,104,202,-1,104,103,202,-1,203,204,205,-1,206,207,208,-1,209,210,211,-1,209,212,210,-1,26,213,30,-1,26,214,213,-1,107,215,113,-1,107,216,215,-1,217,218,219,-1,220,221,222,-1,222,223,220,-1,224,43,45,-1,45,225,224,-1,226,227,228,-1,228,221,226,-1,229,230,231,-1,231,232,229,-1,233,234,235,-1,236,99,237,-1,237,238,236,-1,239,240,241,-1,239,242,240,-1,242,237,243,-1,237,244,243,-1,245,246,247,-1,245,248,246,-1,249,250,251,-1,252,250,253,-1,244,237,99,-1,7,9,97,-1,97,78,7,-1,254,255,256,-1,256,257,254,-1,258,259,260,-1,258,261,259,-1,262,263,264,-1,264,265,262,-1,262,265,266,-1,266,267,262,-1,268,269,270,-1,270,271,268,-1,45,272,273,-1,273,225,45,-1,274,275,276,-1,275,277,276,-1,260,188,258,-1,260,186,188,-1,278,273,279,-1,273,274,279,-1,280,187,281,-1,280,282,187,-1,283,279,284,-1,279,285,284,-1,8,7,191,-1,7,192,191,-1,286,287,288,-1,286,289,287,-1,290,291,218,-1,218,292,290,-1,293,89,294,-1,293,295,89,-1,296,288,287,-1,297,298,193,-1,185,288,183,-1,185,299,288,-1,300,301,302,-1,300,303,301,-1,304,305,306,-1,304,307,305,-1,184,308,309,-1,310,100,311,-1,312,313,314,-1,313,205,314,-1,315,316,317,-1,317,318,319,-1,317,316,318,-1,171,320,321,-1,174,171,322,-1,323,162,161,-1,324,325,124,-1,124,0,324,-1,326,327,125,-1,328,329,327,-1,329,330,327,-1,331,0,123,-1,331,332,0,-1,333,334,335,-1,336,337,338,-1,336,339,337,-1,0,2,340,-1,340,324,0,-1,19,15,122,-1,341,342,343,-1,344,345,156,-1,346,158,347,-1,347,348,346,-1,349,350,351,-1,352,213,353,-1,353,354,352,-1,355,24,27,-1,355,151,24,-1,214,199,198,-1,214,356,199,-1,357,109,112,-1,357,358,109,-1,358,359,360,-1,358,361,359,-1,347,362,363,-1,363,359,347,-1,364,365,360,-1,365,108,360,-1,366,367,368,-1,367,177,368,-1,369,370,371,-1,372,55,373,-1,372,371,55,-1,374,375,376,-1,374,377,375,-1,378,379,380,-1,378,252,379,-1,373,55,54,-1,105,381,382,-1,381,383,382,-1,73,49,384,-1,385,386,387,-1,200,388,198,-1,200,389,388,-1,390,391,392,-1,392,393,390,-1,394,395,396,-1,396,136,394,-1,397,398,399,-1,400,401,402,-1,228,403,404,-1,404,405,228,-1,141,129,406,-1,32,407,33,-1,61,62,182,-1,134,393,132,-1,393,392,132,-1,408,409,132,-1,408,410,409,-1,72,48,47,-1,47,51,72,-1};
			return value;
		}
		private int[] getlcalc_Geo_6_20_coordIndex_2()
		{
			int[] value = {411,410,167,-1,411,409,410,-1,412,413,414,-1,415,416,417,-1,415,418,416,-1,67,416,412,-1,412,414,67,-1,66,165,419,-1,66,68,165,-1,420,421,422,-1,421,423,422,-1,424,425,110,-1,426,169,427,-1,426,170,169,-1,428,429,430,-1,431,432,433,-1,431,178,432,-1,179,434,435,-1,179,175,434,-1,436,437,438,-1,439,440,441,-1,439,442,440,-1,443,444,441,-1,179,445,446,-1,445,447,446,-1,434,448,449,-1,449,435,434,-1,433,450,106,-1,433,432,450,-1,451,452,453,-1,427,430,429,-1,427,169,430,-1,170,454,168,-1,423,408,455,-1,408,456,455,-1,419,457,421,-1,419,165,457,-1,458,420,201,-1,420,116,201,-1,116,420,117,-1,420,422,117,-1,202,458,201,-1,416,66,459,-1,416,67,66,-1,410,457,167,-1,457,165,167,-1,460,418,415,-1,415,461,460,-1,462,463,464,-1,392,456,408,-1,408,132,392,-1,395,394,465,-1,394,466,465,-1,467,468,42,-1,467,469,468,-1,467,143,469,-1,467,46,143,-1,401,470,471,-1,471,402,401,-1,472,397,473,-1,398,474,475,-1,354,476,135,-1,354,353,476,-1,477,137,136,-1,136,396,477,-1,394,390,393,-1,394,138,390,-1,388,391,390,-1,390,476,388,-1,385,387,389,-1,389,200,385,-1,478,387,386,-1,478,479,387,-1,111,478,386,-1,73,480,481,-1,73,384,480,-1,63,482,483,-1,484,485,482,-1,484,486,485,-1,63,65,487,-1,487,482,63,-1,382,59,488,-1,382,383,59,-1,489,490,252,-1,252,378,489,-1,491,376,492,-1,376,375,492,-1,175,493,434,-1,175,494,493,-1,363,364,359,-1,364,360,359,-1,112,386,357,-1,112,111,386,-1,385,357,386,-1,385,495,357,-1,496,347,359,-1,359,361,496,-1,26,25,214,-1,25,356,214,-1,352,28,30,-1,30,213,352,-1,497,351,498,-1,497,349,351,-1,126,350,127,-1,350,349,127,-1,496,348,347,-1,348,25,346,-1,348,356,25,-1,499,343,342,-1,23,151,355,-1,355,17,23,-1,14,139,15,-1,139,122,15,-1,332,122,139,-1,139,0,332,-1,500,501,502,-1,500,337,501,-1,333,335,157,-1,503,362,159,-1,159,102,503,-1,0,124,123,-1,504,505,506,-1,506,507,504,-1,508,321,509,-1,321,310,509,-1,510,511,318,-1,510,512,511,-1,205,513,314,-1,205,204,513,-1,514,316,315,-1,515,173,172,-1,172,516,515,-1,366,517,173,-1,173,515,366,-1,518,519,307,-1,518,520,519,-1,75,77,197,-1,197,521,75,-1,296,297,522,-1,522,308,296,-1,523,79,94,-1,523,303,79,-1,296,287,297,-1,287,298,297,-1,524,525,526,-1,524,527,525,-1,528,529,530,-1,529,531,530,-1,218,291,219,-1,291,529,219,-1,288,299,286,-1,299,532,286,-1,266,191,86,-1,266,265,191,-1,271,533,267,-1,271,534,533,-1,535,279,283,-1,535,278,279,-1,266,86,85,-1,85,268,266,-1,536,537,485,-1,277,182,538,-1,277,61,182,-1,533,262,267,-1,533,539,262,-1,186,540,541,-1,186,260,540,-1,260,542,540,-1,260,259,542,-1,256,261,258,-1,258,536,256,-1,248,543,246,-1,248,544,543,-1,249,253,250,-1,249,545,253,-1,247,246,545,-1,546,248,245,-1,245,243,546,-1,241,547,93,-1,241,548,547,-1,234,549,548,-1,548,251,234,-1,252,235,250,-1,252,490,235,-1,550,511,551,-1,551,511,512,-1,211,210,552,-1,224,553,554,-1,224,225,553,-1,219,555,217,-1,219,556,555,-1,190,181,537,-1,537,189,190,-1,557,558,559,-1,98,560,561,-1,562,97,9,-1,562,98,97,-1,563,564,565,-1,565,88,563,-1,238,566,236,-1,312,314,567,-1,521,568,569,-1,561,243,244,-1,561,546,243,-1,468,570,42,-1,570,39,42,-1,90,571,196,-1,90,572,571,-1,573,574,95,-1,574,96,95,-1,183,288,296,-1,188,189,536,-1,536,258,188,-1,35,50,52,-1,52,38,35,-1,451,442,447,-1,320,171,517,-1,171,173,517,-1,322,575,174,-1,576,551,512,-1,512,577,576,-1,434,369,448,-1,578,579,580,-1,579,581,580,-1,408,457,410,-1,156,346,344,-1,156,158,346,-1,582,160,583,-1,583,121,582,-1,161,154,323,-1,154,153,323,-1,472,584,397,-1,465,144,146,-1,585,130,142,-1,130,129,142,-1,586,587,578,-1,586,325,587,-1,497,588,349,-1,588,589,349,-1,13,131,126,-1,13,18,131,-1,570,590,147,-1,147,145,570,-1,468,469,33,-1,469,31,33,-1,148,127,349,-1,349,589,148,-1,5,477,396,-1,396,3,5,-1,395,465,591,-1};
			return value;
		}
		private int[] getlcalc_Geo_6_20_coordIndex_3()
		{
			int[] value = {394,136,138,-1,32,31,141,-1,128,130,592,-1,0,139,1,-1,11,401,340,-1,111,110,425,-1,425,593,111,-1,503,102,368,-1,368,362,503,-1,102,101,368,-1,112,109,113,-1,109,107,113,-1,436,438,594,-1,179,435,445,-1,347,159,362,-1,347,158,159,-1,88,77,76,-1,76,563,88,-1,527,232,231,-1,527,524,232,-1,76,231,563,-1,76,527,231,-1,530,595,596,-1,595,209,596,-1,191,87,86,-1,208,91,206,-1,166,464,167,-1,166,414,464,-1,481,65,64,-1,481,461,65,-1,73,481,74,-1,481,64,74,-1,105,382,597,-1,73,47,49,-1,74,180,62,-1,56,55,371,-1,371,370,56,-1,418,412,416,-1,165,68,166,-1,598,43,599,-1,598,44,43,-1,403,581,600,-1,600,404,403,-1,39,38,40,-1,39,37,38,-1,580,581,403,-1,146,591,465,-1,537,536,189,-1,152,346,25,-1,25,24,152,-1,341,20,601,-1,20,22,601,-1,18,15,19,-1,18,13,15,-1,16,140,14,-1,16,149,140,-1,125,327,123,-1,256,255,261,-1,591,6,3,-1,602,589,588,-1,602,603,589,-1,10,148,604,-1,148,10,149,-1,140,2,1,-1,140,12,2,-1,542,605,606,-1,542,259,605,-1,263,607,608,-1,263,609,607,-1,562,8,264,-1,562,9,8,-1,601,342,341,-1,342,601,501,-1,344,152,499,-1,152,344,346,-1,45,467,164,-1,46,467,45,-1,600,599,404,-1,600,598,599,-1,460,412,418,-1,460,413,412,-1,610,49,48,-1,610,384,49,-1,463,167,464,-1,463,411,167,-1,597,488,417,-1,597,382,488,-1,166,67,414,-1,68,67,166,-1,528,596,611,-1,528,530,596,-1,555,612,613,-1,612,555,556,-1,286,614,289,-1,286,615,614,-1,82,532,95,-1,532,82,616,-1,295,617,572,-1,617,295,212,-1,99,78,97,-1,78,99,236,-1,232,618,619,-1,524,618,232,-1,78,566,79,-1,566,78,236,-1,433,364,431,-1,433,365,364,-1,452,435,449,-1,452,445,435,-1,620,374,376,-1,620,453,374,-1,429,491,381,-1,429,428,491,-1,116,621,201,-1,116,115,621,-1,622,362,368,-1,363,362,622,-1,201,426,104,-1,426,201,621,-1,623,624,11,-1,399,624,623,-1,498,352,354,-1,352,498,351,-1,3,395,591,-1,3,396,395,-1,5,497,477,-1,5,588,497,-1,587,579,578,-1,579,587,625,-1,590,468,33,-1,570,468,590,-1,626,134,133,-1,626,466,134,-1,126,28,350,-1,126,131,28,-1,592,585,627,-1,585,592,130,-1,143,31,469,-1,143,141,31,-1,584,602,4,-1,584,472,602,-1,121,22,21,-1,583,22,121,-1,628,501,601,-1,628,502,501,-1,629,336,630,-1,334,336,629,-1,338,631,632,-1,338,633,631,-1,154,163,634,-1,163,154,161,-1,20,343,150,-1,20,341,343,-1,335,629,311,-1,335,334,629,-1,224,599,43,-1,599,224,635,-1,600,579,627,-1,579,600,581,-1,377,369,371,-1,377,448,369,-1,551,636,550,-1,576,636,551,-1,321,322,171,-1,321,508,322,-1,637,441,440,-1,637,443,441,-1,454,638,168,-1,454,639,638,-1,629,310,311,-1,629,509,310,-1,100,517,101,-1,100,320,517,-1,447,439,446,-1,442,439,447,-1,561,99,98,-1,99,561,244,-1,521,640,568,-1,640,521,197,-1,309,194,184,-1,309,641,194,-1,582,331,642,-1,331,582,332,-1,494,643,493,-1,643,494,567,-1,566,239,92,-1,566,238,239,-1,550,564,230,-1,564,550,636,-1,8,265,264,-1,265,8,191,-1,548,240,644,-1,241,240,548,-1,79,300,80,-1,303,300,79,-1,523,207,645,-1,208,207,523,-1,559,646,647,-1,558,646,559,-1,388,353,198,-1,353,388,476,-1,230,233,550,-1,229,233,230,-1,211,596,209,-1,596,211,648,-1,649,405,635,-1,405,649,222,-1,223,650,648,-1,223,651,650,-1,650,612,611,-1,612,650,652,-1,649,653,651,-1,554,653,649,-1,554,654,653,-1,554,553,654,-1,652,613,612,-1,652,655,613,-1,646,293,294,-1,646,656,293,-1,559,577,557,-1,559,576,577,-1,558,656,646,-1,656,558,657,-1,658,659,660,-1,658,557,659,-1,657,552,656,-1,552,657,661,-1,660,226,658,-1,226,660,227,-1,661,211,552,-1,211,661,220,-1,230,563,231,-1,563,230,564,-1,619,229,232,-1,549,229,619,-1,235,251,250,-1,235,234,251,-1,547,549,619,-1,549,547,548,-1,545,644,247,-1,545,249,644,-1,546,544,248,-1,546,662,544,-1,246,254,545,-1,246,543,254,-1,662,608,607,-1,560,608,662,-1,544,605,543,-1,544,606,605,-1,486,536,485,-1};
			return value;
		}
		private int[] getlcalc_Geo_6_20_coordIndex_4()
		{
			int[] value = {486,256,536,-1,539,542,609,-1,540,542,539,-1,533,540,539,-1,541,540,533,-1,275,61,277,-1,119,61,275,-1,538,181,190,-1,182,181,538,-1,292,217,574,-1,218,217,292,-1,573,532,299,-1,573,95,532,-1,655,83,613,-1,655,663,83,-1,81,664,665,-1,666,664,81,-1,665,667,668,-1,664,667,665,-1,668,614,615,-1,668,269,614,-1,267,268,271,-1,267,266,268,-1,190,669,538,-1,669,190,282,-1,669,285,276,-1,285,669,670,-1,535,553,278,-1,654,553,535,-1,671,280,672,-1,671,670,280,-1,534,541,533,-1,534,281,541,-1,535,666,663,-1,535,283,666,-1,664,671,667,-1,664,284,671,-1,270,534,271,-1,270,672,534,-1,193,84,87,-1,193,298,84,-1,291,306,305,-1,306,291,290,-1,299,673,573,-1,299,185,673,-1,531,291,305,-1,291,531,529,-1,531,595,530,-1,531,519,595,-1,572,520,571,-1,572,617,520,-1,564,647,565,-1,636,647,564,-1,569,674,675,-1,569,568,674,-1,76,525,527,-1,75,525,76,-1,676,524,526,-1,618,524,676,-1,78,677,7,-1,78,80,677,-1,678,80,300,-1,677,80,678,-1,522,679,680,-1,297,679,522,-1,645,676,681,-1,645,207,676,-1,682,678,683,-1,678,682,680,-1,309,522,684,-1,522,309,308,-1,197,685,640,-1,685,197,196,-1,571,518,686,-1,571,520,518,-1,519,305,307,-1,519,531,305,-1,687,640,685,-1,688,640,687,-1,686,689,690,-1,686,518,689,-1,691,674,688,-1,692,674,691,-1,693,690,694,-1,693,687,690,-1,641,689,304,-1,695,689,641,-1,301,681,692,-1,645,681,301,-1,693,302,691,-1,302,693,683,-1,694,684,682,-1,694,695,684,-1,313,515,516,-1,312,515,313,-1,696,643,513,-1,696,697,643,-1,512,204,203,-1,510,204,512,-1,510,513,204,-1,510,696,513,-1,318,696,510,-1,316,696,318,-1,320,310,321,-1,320,100,310,-1,698,329,699,-1,329,698,700,-1,630,701,702,-1,630,632,701,-1,631,700,698,-1,700,631,703,-1,704,516,705,-1,516,704,313,-1,706,702,701,-1,707,702,706,-1,708,706,699,-1,708,709,706,-1,506,710,507,-1,710,506,711,-1,705,712,704,-1,705,713,712,-1,330,642,331,-1,642,330,714,-1,700,330,329,-1,714,330,700,-1,504,708,328,-1,708,504,507,-1,715,506,505,-1,506,715,713,-1,712,659,716,-1,712,717,659,-1,718,715,719,-1,715,718,717,-1,326,586,720,-1,326,125,586,-1,720,578,719,-1,578,720,586,-1,580,719,578,-1,719,580,718,-1,101,366,368,-1,517,366,101,-1,157,345,333,-1,157,156,345,-1,342,333,345,-1,339,333,342,-1,323,500,502,-1,153,500,323,-1,162,502,628,-1,162,323,502,-1,121,332,582,-1,121,122,332,-1,12,340,2,-1,340,12,11,-1,356,496,199,-1,356,348,496,-1,200,495,385,-1,200,199,495,-1,358,495,361,-1,358,357,495,-1,176,431,622,-1,431,176,178,-1,697,493,643,-1,493,697,721,-1,722,315,723,-1,315,722,514,-1,434,721,369,-1,434,493,721,-1,375,57,492,-1,375,372,57,-1,490,319,724,-1,319,490,489,-1,725,319,489,-1,317,319,725,-1,380,53,378,-1,53,380,54,-1,723,317,725,-1,315,317,723,-1,381,492,383,-1,381,491,492,-1,58,488,59,-1,58,726,488,-1,60,487,58,-1,60,727,487,-1,727,482,487,-1,727,484,482,-1,482,537,483,-1,482,485,537,-1,481,460,461,-1,460,481,480,-1,180,63,483,-1,180,74,63,-1,728,392,391,-1,728,456,392,-1,387,728,389,-1,728,387,479,-1,729,479,478,-1,729,455,479,-1,138,476,390,-1,138,135,476,-1,603,623,604,-1,603,473,623,-1,470,11,624,-1,470,401,11,-1,399,475,624,-1,399,398,475,-1,32,474,407,-1,32,730,474,-1,407,731,732,-1,407,474,731,-1,731,584,733,-1,731,397,584,-1,6,734,733,-1,591,734,6,-1,472,603,602,-1,473,603,472,-1,470,735,471,-1,470,736,735,-1,141,730,32,-1,141,406,730,-1,128,471,735,-1,128,592,471,-1,44,585,142,-1,44,598,585,-1,33,732,590,-1,407,732,33,-1,590,734,147,-1,590,732,734,-1,591,147,734,-1,147,591,146,-1,39,145,37,-1,39,570,145,-1,36,626,34,-1,36,144,626,-1,70,737,71,-1,737,70,34,-1,610,463,462,-1,610,69,463,-1,597,103,105,-1,597,459,103,-1,103,66,202,-1,459,66,103,-1,117,729,593,-1,729,117,422,-1,437,115,114,-1,437,639,115,-1,421,408,423,-1,421,457,408,-1,419,202,66,-1,202,419,458,-1,594,424,110,-1};
			return value;
		}
		private int[] getlcalc_Geo_6_20_coordIndex_5()
		{
			int[] value = {594,438,424,-1,436,639,437,-1,436,638,639,-1,738,453,620,-1,453,738,451,-1,107,450,216,-1,106,450,107,-1,440,451,738,-1,442,451,440,-1,169,637,430,-1,637,169,168,-1,444,638,436,-1,444,443,638,-1,216,439,441,-1,450,439,216,-1,436,215,444,-1,215,436,594,-1,216,444,215,-1,216,441,444,-1,446,450,432,-1,446,439,450,-1,440,430,637,-1,440,738,430,-1,215,110,113,-1,110,215,594,-1,432,179,446,-1,432,178,179,-1,738,428,430,-1,428,738,620,-1,425,437,114,-1,425,438,437,-1,424,438,425,-1,422,455,729,-1,422,423,455,-1,458,421,420,-1,458,419,421,-1,597,416,459,-1,417,416,597,-1,71,409,411,-1,71,737,409,-1,69,48,72,-1,610,48,69,-1,50,34,70,-1,35,34,50,-1,737,132,409,-1,133,132,737,-1,133,34,626,-1,34,133,737,-1,37,144,36,-1,37,145,144,-1,394,134,466,-1,394,393,134,-1,118,61,119,-1,61,118,52,-1,120,275,272,-1,275,120,119,-1,142,46,44,-1,143,46,142,-1,627,598,600,-1,598,627,585,-1,228,580,403,-1,228,227,580,-1,402,592,625,-1,471,592,402,-1,129,735,406,-1,735,129,128,-1,406,736,730,-1,735,736,406,-1,4,733,584,-1,6,733,4,-1,732,733,734,-1,732,731,733,-1,474,397,731,-1,474,398,397,-1,475,730,736,-1,730,475,474,-1,624,736,470,-1,475,736,624,-1,11,604,623,-1,10,604,11,-1,728,455,456,-1,455,728,479,-1,389,391,388,-1,391,389,728,-1,483,181,180,-1,483,537,181,-1,65,58,487,-1,65,726,58,-1,59,492,57,-1,59,383,492,-1,373,727,60,-1,373,54,727,-1,725,56,723,-1,725,53,56,-1,484,54,380,-1,54,484,727,-1,489,53,725,-1,489,378,53,-1,486,380,379,-1,380,486,484,-1,60,372,373,-1,57,372,60,-1,371,375,377,-1,371,372,375,-1,723,370,722,-1,370,723,56,-1,377,449,448,-1,374,449,377,-1,369,722,370,-1,722,369,721,-1,514,721,697,-1,514,722,721,-1,367,175,177,-1,367,494,175,-1,567,367,312,-1,367,567,494,-1,108,358,360,-1,358,108,109,-1,199,361,495,-1,199,496,361,-1,340,400,324,-1,401,400,340,-1,153,633,500,-1,633,153,155,-1,500,338,337,-1,338,500,633,-1,501,339,342,-1,501,337,339,-1,339,334,333,-1,336,334,339,-1,718,227,660,-1,227,718,580,-1,324,587,325,-1,324,400,587,-1,400,625,587,-1,400,402,625,-1,331,327,330,-1,327,331,123,-1,327,504,328,-1,327,326,504,-1,504,720,505,-1,504,326,720,-1,717,660,659,-1,717,718,660,-1,505,719,715,-1,505,720,719,-1,713,717,712,-1,713,715,717,-1,699,328,708,-1,699,329,328,-1,703,714,700,-1,703,634,714,-1,634,642,714,-1,642,634,163,-1,704,716,203,-1,704,712,716,-1,711,713,705,-1,711,506,713,-1,507,709,708,-1,710,709,507,-1,701,699,706,-1,701,698,699,-1,711,174,710,-1,172,174,711,-1,705,172,711,-1,172,705,516,-1,632,698,701,-1,698,632,631,-1,630,509,629,-1,509,630,702,-1,509,707,508,-1,707,509,702,-1,709,707,706,-1,709,575,707,-1,511,319,318,-1,319,511,724,-1,514,696,316,-1,514,697,696,-1,203,313,704,-1,205,313,203,-1,314,643,567,-1,643,314,513,-1,710,575,709,-1,710,174,575,-1,684,641,309,-1,684,695,641,-1,694,683,693,-1,683,694,682,-1,302,692,691,-1,301,692,302,-1,304,194,641,-1,304,306,194,-1,689,694,690,-1,694,689,695,-1,691,687,693,-1,691,688,687,-1,692,675,674,-1,681,675,692,-1,304,518,307,-1,689,518,304,-1,690,685,686,-1,687,685,690,-1,688,568,640,-1,674,568,688,-1,686,196,571,-1,685,196,686,-1,684,680,682,-1,680,684,522,-1,300,683,678,-1,300,302,683,-1,523,301,303,-1,523,645,301,-1,526,681,676,-1,526,675,681,-1,680,677,678,-1,679,677,680,-1,679,7,677,-1,192,7,679,-1,207,618,676,-1,206,618,207,-1,525,675,526,-1,525,569,675,-1,521,525,75,-1,525,521,569,-1,565,89,88,-1,294,89,565,-1,293,212,295,-1,293,210,212,-1,519,617,595,-1,519,520,617,-1,292,195,290,-1,673,195,292,-1,290,194,306,-1,195,194,290,-1,298,289,84,-1,289,298,287,-1,672,667,671,-1,667,672,270,-1,666,284,664,-1,666,283,284,-1,663,654,535,-1,655,654,663,-1,281,672,280,-1,672,281,534,-1,284,670,671,-1,284,285,670,-1,281,186,541,-1,281,187,186,-1,670,282,280,-1,670,669,282,-1};
			return value;
		}
		private int[] getlcalc_Geo_6_20_coordIndex_6()
		{
			int[] value = {279,276,285,-1,279,274,276,-1,225,278,553,-1,225,273,278,-1,188,282,190,-1,282,188,187,-1,538,276,277,-1,276,538,669,-1,272,274,273,-1,272,275,274,-1,614,268,85,-1,614,269,268,-1,668,270,269,-1,667,270,668,-1,615,665,668,-1,665,615,616,-1,616,81,665,-1,82,81,616,-1,81,663,666,-1,83,663,81,-1,555,574,217,-1,555,96,574,-1,573,292,574,-1,292,573,673,-1,164,272,45,-1,164,120,272,-1,539,263,262,-1,539,609,263,-1,486,257,256,-1,379,257,486,-1,255,543,605,-1,543,255,254,-1,607,544,662,-1,607,606,544,-1,560,562,608,-1,98,562,560,-1,257,545,254,-1,545,257,253,-1,546,560,662,-1,561,560,546,-1,253,379,252,-1,379,253,257,-1,644,251,548,-1,644,249,251,-1,242,245,240,-1,242,243,245,-1,247,240,245,-1,247,644,240,-1,229,234,233,-1,234,229,549,-1,233,490,724,-1,490,233,235,-1,226,220,661,-1,220,226,221,-1,658,661,657,-1,661,658,226,-1,656,210,293,-1,210,656,552,-1,557,657,558,-1,657,557,658,-1,716,557,577,-1,557,716,659,-1,647,576,559,-1,647,636,576,-1,577,203,716,-1,203,577,512,-1,655,653,654,-1,653,655,652,-1,554,635,224,-1,635,554,649,-1,651,652,650,-1,652,651,653,-1,611,648,650,-1,596,648,611,-1,651,222,649,-1,222,651,223,-1,228,222,221,-1,222,228,405,-1,220,648,211,-1,648,220,223,-1,724,550,233,-1,724,511,550,-1,498,477,497,-1,498,137,477,-1,198,213,214,-1,198,353,213,-1,27,131,355,-1,27,29,131,-1,294,647,646,-1,294,565,647,-1,91,523,94,-1,91,208,523,-1,238,242,239,-1,242,238,237,-1,92,241,93,-1,92,239,241,-1,642,160,582,-1,642,163,160,-1,528,219,529,-1,528,556,219,-1,447,452,451,-1,447,445,452,-1,593,478,111,-1,593,729,478,-1,193,679,297,-1,192,679,193,-1,185,195,673,-1,184,195,185,-1,308,183,296,-1,308,184,183,-1,621,170,426,-1,621,454,170,-1,177,622,368,-1,177,176,622,-1,366,312,367,-1,366,515,312,-1,102,311,100,-1,311,102,159,-1,575,508,707,-1,322,508,575,-1,621,639,454,-1,621,115,639,-1,168,443,637,-1,168,638,443,-1,414,462,464,-1,414,413,462,-1,635,404,599,-1,404,635,405,-1,41,118,120,-1,41,40,118,-1,628,160,162,-1,160,628,583,-1,583,601,22,-1,583,628,601,-1,155,634,703,-1,155,154,634,-1,633,703,631,-1,633,155,703,-1,336,632,630,-1,336,338,632,-1,159,335,311,-1,157,335,159,-1,150,499,152,-1,343,499,150,-1,23,150,151,-1,23,20,150,-1,144,466,626,-1,144,465,466,-1,625,627,579,-1,627,625,592,-1,125,325,586,-1,125,124,325,-1,137,354,135,-1,354,137,498,-1,352,350,28,-1,352,351,350,-1,18,355,131,-1,355,18,17,-1,399,473,397,-1,623,473,399,-1,426,105,104,-1,426,427,105,-1,593,114,117,-1,425,114,593,-1,429,105,427,-1,429,381,105,-1,428,376,491,-1,428,620,376,-1,453,449,374,-1,453,452,449,-1,363,431,364,-1,622,431,363,-1,106,365,433,-1,106,108,365,-1,547,91,93,-1,547,206,91,-1,92,79,566,-1,92,94,79,-1,206,619,618,-1,206,547,619,-1,572,89,295,-1,572,90,89,-1,212,595,617,-1,595,212,209,-1,532,615,286,-1,532,616,615,-1,289,85,84,-1,289,614,85,-1,96,613,83,-1,613,96,555,-1,556,611,612,-1,611,556,528,-1,415,65,461,-1,65,415,726,-1,70,51,50,-1,72,51,70,-1,411,69,71,-1,411,463,69,-1,488,415,417,-1,415,488,726,-1,480,413,460,-1,413,480,462,-1,462,384,610,-1,462,480,384,-1,42,164,467,-1,42,41,164,-1,26,29,27,-1,29,26,30,-1,345,499,342,-1,499,345,344,-1,19,23,17,-1,23,19,21,-1,608,264,263,-1,562,264,608,-1,606,609,542,-1,607,609,606,-1,259,255,605,-1,259,261,255,-1,149,12,140,-1,12,149,10,-1,604,589,603,-1,589,604,148,-1,5,602,588,-1,5,4,602,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlcalc_Coord_7_20_point_1()
		{
			double[] value = {1.98442,1.88319,-2.84942,2.07396,1.88827,-2.78853,2.09102,1.89711,-2.79458,3.03793,1.78553,-2.55444,2.86794,1.74036,-2.52682,2.8727,1.72273,-2.51747,3.02853,1.80011,-2.56592,3.20134,.54496,-4.04602,3.29905,.54913,-3.9918,3.28185,.51416,-3.97546,2.34207,1.87973,-2.69229,2.34165,1.91876,-2.76841,2.24724,1.88676,-2.72034,2.2334,1.81984,-2.61341,2.22731,1.86357,-2.69545,2.12896,1.86211,-2.62675,2.32176,1.85057,-2.67306,2.20959,1.8222,-2.55625,2.22576,1.81674,-2.59158,2.12244,1.86631,-2.60707,2.18843,1.87956,-2.4455,2.11738,1.88281,-2.55447,2.11167,1.90114,-2.49546,2.19923,1.8503,-2.50251,2.33419,1.78278,-2.37724,2.37994,1.74502,-2.30706,2.4215,1.7236,-2.38475,2.3594,1.75029,-2.44424,2.48683,1.70543,-2.54181,2.39495,1.73174,-2.52977,2.46049,1.69812,-2.48304,2.95696,2.19014,-3.18836,2.92021,2.18362,-3.16891,3.07244,2.1696,-3.03469,3.38205,1.68438,-2.614,3.36756,1.76997,-2.74006,3.36076,1.78618,-2.72795,3.34161,1.87981,-2.82752,3.34452,1.86566,-2.84289,3.24636,2.05782,-3.00207,3.24586,2.04302,-3.01753,3.11215,2.13254,-3.12765,3.11939,2.14616,-3.09079,2.70441,2.05578,-3.44622,2.69367,2.06869,-3.43125,2.89371,2.11002,-3.33146,2.88329,2.12468,-3.32067,3.44914,1.59303,-2.84124,3.49102,1.50705,-2.68811,3.49473,1.47761,-2.69448,3.39207,1.71156,-2.77358,3.41039,1.67223,-2.79639,3.33172,1.85222,-2.96346,2.99521,.80222,-2.30127,3.10825,.86293,-2.32149,3.06625,.87108,-2.15573,2.96777,.8334,-2.16214,3.20545,.97673,-2.03119,3.30451,1.09191,-2.16375,3.2929,1.09747,-2.0445,3.19736,.97661,-2.1583,3.31871,1.83934,-3.07636,3.44041,1.54661,-2.8758,3.3941,1.19911,-2.59392,3.41972,1.27958,-2.55046,3.39789,1.18235,-2.34381,3.37558,1.42422,-1.94146,3.40186,1.35864,-2.13977,3.40161,1.37941,-2.14649,3.47264,1.49835,-2.50995,3.42316,1.61476,-2.64844,3.46507,1.53003,-2.49686,3.44201,1.57935,-2.66585,3.43738,1.36959,-2.7085,3.42996,1.35638,-2.72397,2.22684,.36532,-3.62421,2.28584,.45506,-3.48629,2.19469,.46692,-3.77759,3.12456,.41173,-3.91554,2.97704,.28169,-3.75105,3.02264,.37709,-3.96195,2.97539,1.8018,-4.07439,2.95667,1.79088,-4.11785,2.84957,1.88236,-4.09343,3.25048,.89126,-4.13553,3.27576,.9147,-4.08286,3.29992,.73911,-4.00523,3.25861,.75719,-4.07111,2.20027,.49683,-3.75621,2.15467,.67402,-3.93913,2.15407,.65424,-3.96821,2.86649,.25861,-3.53481,2.93059,.28805,-3.61104,2.87688,.27671,-3.52758,2.91923,.27143,-3.62495,2.94165,1.78865,-4.13532,2.84092,1.87118,-4.10982,3.19021,.43982,-3.88956,3.26371,.40599,-3.77563,3.17688,.43349,-3.8734};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_2()
		{
			double[] value = {2.11054,1.50649,-2.09439,2.20679,1.52627,-2.10568,2.2048,1.5463,-2.09692,3.33848,1.35153,-1.77261,3.33154,1.35919,-1.74187,3.28163,1.23643,-1.75661,2.58362,1.61129,-1.73508,2.69227,1.70233,-1.71403,2.57324,1.63842,-1.75203,2.68736,1.71309,-1.72497,2.95535,1.90614,-1.65704,2.96025,1.92742,-1.68448,2.81316,1.80544,-1.70683,2.81655,1.79757,-1.69495,3.25095,1.8441,-1.70286,3.31635,1.68337,-1.72053,3.32828,1.68879,-1.73379,3.27219,1.86285,-1.74108,3.23156,2.02266,-3.08536,3.2155,2.02423,-3.17307,3.08694,2.11201,-3.20291,2.00307,1.90121,-2.62481,2.00918,1.8936,-2.67241,1.88494,1.86512,-2.87473,1.96232,1.8568,-2.90633,1.9613,1.83138,-2.90983,2.33795,1.77654,-2.60032,2.41621,1.83758,-2.65068,2.55484,2.0446,-3.34109,2.68862,2.12056,-3.36598,2.5557,2.0378,-3.367,2.32928,1.76532,-2.57649,3.39477,1.71486,-2.32776,3.39924,1.71341,-2.41796,3.3784,1.72784,-2.40695,2.90866,1.66164,-2.46156,3.0673,1.69004,-2.50461,2.90526,1.67136,-2.48072,3.0759,1.67393,-2.48612,2.06549,1.87805,-2.7857,2.24033,1.87475,-2.70604,2.8549,2.1709,-3.27956,2.68921,2.10569,-3.39997,2.869,2.1567,-3.2998,3.34536,1.85582,-2.65851,3.32468,1.93641,-2.75797,3.31115,1.87102,-2.64307,3.28889,1.95338,-2.71978,2.42981,1.8575,-2.65325,2.33654,1.86554,-2.67846,2.25526,1.83849,-2.39269,2.2709,1.80069,-2.44711,2.30652,1.80636,-2.3059,1.78366,1.91751,-2.47058,1.74282,1.94428,-2.51303,1.71274,1.90803,-2.46171,2.26928,1.68523,-2.1019,2.18646,1.64467,-2.05839,2.27976,1.66915,-2.10138,2.19261,1.62334,-2.06207,1.88893,1.94962,-2.57919,1.80187,1.97579,-2.53699,1.86856,1.96726,-2.53722,1.7817,1.97397,-2.57768,3.03633,2.12677,-3.21015,3.41336,1.47301,-2.17249,3.45166,1.38403,-2.28628,3.46595,1.44937,-2.37904,3.18601,1.50165,-1.7146,3.25335,1.31616,-1.70541,3.26969,1.42309,-1.71005,2.08544,1.35515,-2.23975,2.13753,1.39336,-2.33095,2.15883,1.3538,-2.24012,2.06454,1.40886,-2.33499,2.50585,1.37476,-1.95497,2.45265,1.49425,-1.92457,2.43404,1.46148,-1.99733,2.49882,1.51912,-1.80764,2.57891,1.40234,-1.83771,3.44672,1.33687,-2.824,3.45186,1.27272,-3.00027,3.40749,1.50586,-3.05263,3.02739,1.345,-4.26124,2.90514,1.34284,-4.28338,2.9662,1.47461,-4.22741,3.43806,.87297,-3.34383,3.37355,.9935,-3.34651,3.42068,1.01411,-3.20251,3.42929,1.02471,-3.12314,3.39419,1.22804,-3.20772,3.30677,.63459,-4.0013,3.20861,.66121,-4.08779,3.20323,.79167,-4.14909,2.72282,1.33724,-4.29357,2.79827,1.4998,-4.23794,2.17079,.61416,-4.01099,2.18918,.42184,-3.84309,2.66531,1.63557,-2.30563,2.60926,1.66446,-2.15372};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_3()
		{
			double[] value = {2.80492,1.69148,-2.19357,3.35887,1.59126,-1.73178,3.3522,1.51065,-1.7977,2.35219,1.20124,-2.69039,2.40896,1.1036,-2.49818,2.34966,1.16852,-2.44749,2.81441,.25669,-3.47353,2.78582,.1966,-3.55006,2.83973,.22432,-3.53823,2.25597,1.45063,-3.99484,2.24194,1.26974,-3.83507,2.31411,1.5109,-3.83324,2.20666,1.18832,-3.99558,2.58461,1.70576,-2.43373,2.55152,1.70033,-2.33841,2.88629,1.77449,-1.67306,2.74285,1.65985,-1.70607,2.66672,1.83494,-4.14184,2.59538,1.73518,-4.15766,2.57748,1.75859,-4.11889,2.3467,1.56079,-3.63451,2.32743,1.6413,-3.44708,2.43273,1.74314,-3.51493,2.41043,1.66567,-3.68605,2.68378,1.99217,-3.51116,2.82876,2.02944,-3.45185,2.29662,1.5003,-3.35694,2.2636,1.64349,-3.21155,2.31628,1.72147,-3.30411,2.64322,.49128,-3.18128,2.51321,.56217,-3.25132,2.43712,.38496,-3.32656,2.56294,.30966,-3.29665,2.68446,.60097,-3.06026,2.81291,.55087,-3.10843,2.83095,.5996,-3.01063,3.11973,.40847,-3.89569,3.09455,.43767,-3.74267,3.03734,.36188,-3.74016,2.98968,.37898,-3.6218,3.02129,.49951,-3.48833,2.93035,.39723,-3.49213,3.04592,.46426,-3.62192,3.14309,.46219,-3.58753,3.15915,.42561,-3.71413,3.13335,.50732,-3.4557,3.16817,.53827,-3.314,3.11805,.559,-3.33165,3.21214,.48066,-3.45165,3.01205,.59063,-3.19904,2.97554,.64181,-3.02179,2.94034,.54268,-3.17987,2.97375,.7242,-2.85189,3.03778,.66806,-3.01681,3.21947,.62202,-3.16883,3.35319,.65388,-3.16345,3.30863,.75684,-3.03648,3.16888,.67794,-3.01256,3.41842,.77918,-3.17514,3.45406,.5961,-3.30849,3.46452,.67148,-3.31734,3.38382,.68129,-3.16484,3.48746,.59064,-3.77241,3.49417,.48912,-3.72952,3.41199,.51794,-3.89167,3.39774,.60729,-3.91069,3.34076,.7316,-3.93004,3.37781,.75321,-3.79211,3.28986,.9264,-3.9695,3.25499,1.10928,-4.0106,3.25489,1.11821,-3.84891,3.31496,.94461,-3.82527,3.05424,2.08887,-3.29867,3.00193,2.03195,-3.42411,3.14359,1.92789,-3.41439,3.19464,2.00045,-3.27425,3.26391,1.75967,-3.39673,3.30086,1.80714,-3.22424,2.98513,1.98474,-3.56733,3.08263,1.88634,-3.56177,3.30138,1.15766,-3.50997,3.35411,.97581,-3.50428,3.34605,1.19884,-3.34414,3.06013,1.85533,-3.74602,3.13831,1.68564,-3.71192,3.19413,1.70794,-3.55091,3.1402,1.34116,-4.17844,3.17072,1.09367,-4.26074,3.08334,1.34333,-4.2404,3.22266,1.09233,-4.1828,2.67481,1.55253,-4.22917,2.54492,1.62377,-4.1799,2.73868,1.68609,-4.16882,2.20304,.94504,-3.85287,2.21654,.76386,-3.7538,2.18717,.88398,-3.99295,3.10194,1.10271,-4.31228,3.09563,.90392,-4.31652,3.19285,.9022,-4.20553,3.00497,1.54606,-4.21182};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_4()
		{
			double[] value = {2.90755,.33462,-3.99802,2.74356,.2001,-3.81196,2.73479,.29686,-4.0,2.87732,.24019,-3.78026,2.51075,1.20638,-4.33281,2.45159,1.4392,-4.23513,2.57874,1.38291,-4.28136,2.39089,1.27086,-4.26276,2.97228,1.11458,-4.33883,2.84658,1.12842,-4.34346,2.02836,1.50824,-2.11897,2.09368,1.59845,-2.05035,2.27452,1.25809,-2.23976,2.27977,1.28478,-2.36614,2.35315,1.19517,-2.26915,2.68431,.80868,-2.23919,2.62916,.82781,-2.34814,2.72473,.78316,-2.34745,2.63853,.82211,-2.58756,2.74288,.74109,-2.59265,2.1094,1.41062,-2.16105,1.99497,1.40463,-2.20805,1.99253,1.3981,-2.29761,1.85117,1.9432,-2.506,2.06662,1.85569,-2.93589,2.04188,1.83686,-2.95378,1.96734,1.77114,-2.89503,1.83748,1.8201,-2.87135,1.79911,1.73452,-2.80642,1.7079,1.80407,-2.73103,1.76116,1.8815,-2.77164,1.83927,1.93881,-2.77015,1.94642,1.93023,-2.71811,2.08062,1.67834,-2.13065,1.97537,1.64589,-2.10152,2.09091,1.61831,-2.04603,1.87862,1.67652,-2.18425,1.89079,1.7753,-2.34598,1.78466,1.74646,-2.29396,1.98154,1.72237,-2.22624,2.18693,1.92483,-2.82931,2.18079,1.89003,-2.43078,2.08596,1.76313,-2.27607,2.24668,1.84905,-2.37843,2.32733,1.76363,-2.20597,2.18886,1.71756,-2.16755,2.34007,1.7544,-2.21883,2.35581,1.62055,-2.07942,2.41769,1.67261,-2.13935,2.55405,1.77966,-2.59097,2.49929,1.71721,-2.56146,2.5933,1.70858,-2.5352,2.59454,1.69857,-2.51195,2.70743,1.64902,-2.40063,2.74152,1.66709,-2.47908,2.29625,1.78243,-2.5029,2.49275,1.69766,-2.21382,2.77015,1.75837,-1.84521,2.63627,1.70263,-1.83211,2.45226,1.61178,-1.9239,2.53612,1.62615,-1.81455,2.57524,1.667,-1.97002,2.31474,1.56799,-2.08636,2.42511,1.57865,-1.90871,2.48953,1.59643,-1.8023,2.52531,1.60551,-1.7707,2.27393,1.44292,-2.13468,2.38698,1.40633,-2.09147,2.30952,1.54583,-2.08721,2.84112,1.02745,-1.97687,2.92025,.90207,-2.06624,3.02023,.88844,-2.06391,3.10997,.88202,-2.05044,3.0999,.88137,-2.15209,3.00784,.93216,-1.79661,3.11532,.91424,-1.86506,3.14663,.94481,-1.772,3.0009,.91803,-1.88027,2.99479,.74627,-2.58056,3.12993,.74574,-2.8681,3.10947,.81057,-2.59264,3.2739,1.06888,-1.74524,3.31456,1.21882,-1.90453,3.2788,1.10209,-1.87314,3.51253,1.42562,-2.57237,2.92697,1.73474,-2.02558,2.97562,1.81854,-1.85673,2.97314,1.73099,-2.04052,2.97683,1.58114,-2.31151,2.97045,1.63461,-2.20722,3.13229,1.61303,-2.42289,3.14499,1.62606,-2.32426,3.2857,1.67903,-2.34114,3.28285,1.68613,-2.42609,3.25234,1.73913,-2.54105,3.22057,1.80728,-2.61462,3.05256,1.7499,-2.54022,2.73474,1.9114,-2.73141,2.66536,2.00375,-2.85973,2.56493,1.95147,-2.78491};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_5()
		{
			double[] value = {2.18958,1.87685,-2.99985,2.28396,1.94418,-2.88507,2.26913,1.91876,-3.06296,2.30043,1.77923,-3.24188,2.42711,1.85659,-3.36957,2.42979,1.80311,-3.43807,2.70018,2.1378,-3.26056,2.97527,2.14018,-2.98971,3.36259,1.72458,-2.23917,3.4221,1.59016,-2.36367,3.43075,1.59476,-2.28093,3.46371,1.48542,-2.41912,3.44247,1.27872,-2.24149,3.49543,1.29457,-2.33666,3.46219,1.3292,-2.29959,3.39309,1.20413,-2.21169,3.4123,1.2735,-2.10891,3.37692,1.2167,-2.07807,3.43611,1.24945,-2.24417,3.41104,1.53471,-1.97976,3.37899,1.68914,-1.8401,3.41649,1.6451,-1.99209,3.29851,1.83747,-1.87807,3.317,1.77669,-2.05342,3.10007,1.89005,-1.66651,3.11251,1.92247,-1.67745,3.31981,1.36112,-1.72795,3.2699,1.23963,-1.74221,3.2269,1.01946,-1.73781,3.26391,1.07064,-1.7325,3.18006,1.17781,-1.71496,2.4823,1.55996,-1.79708,2.53825,1.53799,-1.78097,2.52927,1.57201,-1.75909,2.69904,1.17593,-1.92958,2.72689,1.20043,-1.84758,3.10668,1.73904,-1.67621,3.19362,1.80089,-1.67925,3.0972,1.86887,-1.66158,2.7096,1.46506,-1.76318,2.94946,1.32766,-1.74666,2.84687,1.53349,-1.74379,2.82132,1.27264,-1.78926,2.98529,1.587,-1.71389,2.95804,1.63173,-1.7134,2.73465,1.20689,-1.83275,2.6368,1.42653,-1.79343,2.78005,1.24118,-1.81161,2.84911,1.02975,-1.91572,2.85899,1.02745,-1.8352,2.62027,1.58081,-1.7338,2.9286,1.09525,-1.76965,2.8699,1.04217,-1.81081,3.00707,.94832,-1.78058,3.2621,1.53839,-1.70592,3.22488,1.81225,-2.06854,3.26151,1.7277,-2.26406,3.43959,1.59973,-2.19002,3.37039,1.57303,-1.8085,3.37381,1.32731,-1.93063,3.49216,1.27089,-2.34643,3.41263,1.19777,-2.34301,3.51355,1.38121,-2.46594,3.46562,1.46539,-2.42936,3.46632,1.43254,-2.39399,3.31181,1.86104,-2.63446,3.32659,1.81288,-2.57101,3.02351,2.13973,-3.19947,3.10255,2.16781,-3.05843,2.98297,2.1745,-3.20886,2.42132,1.99889,-3.00349,2.38938,1.99696,-3.14288,2.70865,1.82684,-2.63518,2.61073,1.85543,-2.66707,2.80599,2.0818,-2.95115,2.64085,2.03585,-2.91943,2.94995,1.60569,-2.39361,2.88331,1.68431,-2.51292,3.06437,1.86744,-1.87134,3.10248,1.76875,-2.05372,3.51088,1.36091,-2.48334,3.43056,1.29508,-2.54279,3.31555,1.03061,-2.64397,3.40474,1.16612,-2.75133,3.21866,.90197,-2.60327,3.35571,.94155,-2.92056,3.25357,.84012,-2.87878,3.29788,1.07208,-2.35248,3.36521,1.19776,-2.07103,2.87787,.72914,-2.57255,2.82925,.66428,-2.83277,3.23494,1.0135,-1.74929,3.21982,1.01481,-1.86055,2.59977,1.12145,-2.00885,2.44224,1.32507,-2.04881,2.73062,1.72646,-2.01361,2.52112,1.62761,-2.0816,2.69211,1.69231,-2.54187,2.73888,1.67624,-2.49863,2.29586,1.81627,-2.29234};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_6()
		{
			double[] value = {1.8363,1.85153,-2.41126,1.99289,1.83582,-2.39661,1.92767,1.88537,-2.45535,2.21524,1.54888,-2.09994,1.97059,1.70334,-2.83065,2.07154,1.65026,-2.85858,2.11881,1.54465,-2.67903,2.0211,1.57161,-2.67344,1.93439,1.42598,-2.2596,1.92918,1.52934,-2.17055,2.50301,.96335,-2.54988,2.59959,.75069,-2.89229,2.45861,1.00059,-2.75933,2.4311,1.07638,-2.28285,2.64193,.85881,-2.18258,2.21423,1.32907,-2.22634,2.20666,1.35848,-2.33582,2.19953,1.43401,-2.15467,2.31587,1.04442,-4.26062,2.3004,1.37021,-4.15114,2.23892,1.12386,-4.13436,2.23725,.30363,-3.68026,3.00013,.89538,-4.35119,2.8741,.21321,-3.65622,2.55451,.28844,-3.31911,2.35968,.27506,-3.47761,2.5278,.20545,-3.46594,2.43018,.35802,-3.34443,2.41967,1.74841,-4.0521,2.4777,1.65268,-4.12742,2.34245,1.6173,-4.02783,2.39606,1.52232,-4.1446,3.03776,1.61262,-4.16266,3.41337,.77825,-3.63687,3.33076,.9542,-3.66104,2.93037,1.93485,-3.74853,3.39756,.85867,-3.07003,3.43378,1.07038,-2.97141,3.35479,1.48983,-3.21652,3.50174,.58142,-3.59379,3.48495,.62515,-3.4331,3.42884,.8022,-3.46852,3.48595,.55808,-3.40258,3.28124,.53878,-3.30804,3.34119,.46375,-3.42177,3.08837,.60933,-3.18173,3.24285,.42106,-3.54374,2.82365,.27647,-3.45769,2.89207,.42363,-3.35745,2.7712,.44153,-3.22183,2.57796,.68209,-3.07625,2.55245,.79278,-2.95322,2.26367,1.31617,-3.73976,2.78971,1.97313,-3.59322,2.66382,1.92643,-3.58696,2.69991,1.88565,-4.09635,2.55184,1.83485,-4.06874,2.35837,1.23786,-3.16174,2.34551,1.09281,-3.3381,2.38868,1.00805,-3.25358,3.3102,.38262,-3.67687,3.24504,.41063,-3.69244,3.3719,.46897,-3.87825,2.29769,.48851,-3.46998,2.38262,.64466,-3.37933,2.28023,.65706,-3.55292,2.99118,.29505,-3.74337,2.35566,1.23144,-2.1612,2.26227,.24764,-3.73164,2.32872,.23541,-3.59883,3.23603,2.10395,-2.93043,2.19475,.81666,-4.09141,2.18555,.87253,-4.02653,2.90287,1.73763,-4.17506,2.81171,1.82867,-4.15345,1.96157,1.4122,-2.31694,2.45901,.85804,-3.10628,2.40224,1.07996,-2.96568,2.17028,1.80803,-3.06612,2.26811,1.84497,-3.17727,2.24381,1.67619,-3.1443,2.29427,1.79493,-3.22617,1.91888,1.94698,-2.63626,2.00183,1.92403,-2.55485,2.79781,1.81203,-2.6189,2.56346,2.01776,-3.39249,2.04011,1.80505,-2.95727,2.16866,1.83131,-3.05041,2.69032,1.71081,-2.54312,2.55681,1.80014,-2.60318,3.20627,2.10465,-2.89168,3.20469,1.85846,-2.62985,2.39053,1.95468,-3.26346,3.11622,1.94091,-1.71682,3.01111,1.8628,-1.64512,2.25191,1.44635,-4.01892,2.33992,1.62417,-4.01341,3.32321,1.23832,-1.90953,2.57312,1.98426,-3.42354,2.57707,1.9708,-3.43947};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_7()
		{
			double[] value = {2.42563,1.872,-3.35492,2.10224,1.90831,-2.4785,2.69793,1.72936,-2.55209,2.56843,1.81453,-2.61263,2.43949,1.87198,-2.6643,3.41916,.56176,-3.304,3.44552,.50426,-3.39561,3.46423,.43774,-3.54497,3.45205,.43356,-3.71944,3.50443,.49026,-3.56049,3.51352,1.44847,-2.55748,2.41926,1.75589,-4.03827,2.5519,1.84276,-4.05488,2.70428,1.89278,-4.08182,3.23166,1.10184,-4.15799,3.15007,1.34596,-4.15667,3.05008,1.61654,-4.14326,2.20514,1.18234,-4.02054,2.70472,.25676,-3.37472,2.71524,.27694,-3.35744,3.1389,.95472,-1.76025,3.34721,1.59218,-1.71907,2.42287,1.56092,-1.90757,2.48686,1.90994,-2.72506,2.48432,1.97276,-2.85043,2.26249,1.87502,-3.15545,3.35597,1.79933,-2.58341,2.40023,1.93016,-3.28752,2.00048,1.934,-2.51566,1.97034,1.62755,-2.10841,1.87179,1.65925,-2.19191,1.72406,1.80618,-2.39924,1.76547,1.71866,-2.30877,1.7442,1.83167,-2.38513,1.72418,1.94162,-2.54773,2.56887,1.91465,-3.50121,2.4345,.75503,-3.25446,3.08814,1.4143,-1.72276,3.1373,1.64852,-1.6907,3.22853,1.67057,-1.69258,2.20243,.36927,-3.9261,2.67705,1.14026,-4.34654,1.777,1.97068,-2.63888,2.4597,1.07317,-2.13162,3.02198,.54397,-3.34991,2.74929,.16407,-3.66176,2.29197,.92258,-3.54595,2.34566,.8084,-3.41926,2.37086,1.62899,-3.86829,2.55952,1.85282,-3.57187,2.47157,1.78073,-3.90059,2.52015,1.78978,-3.73075,2.58375,1.85901,-3.92316,2.62806,1.86741,-3.75193,2.77245,1.94053,-3.74972,2.74437,1.92174,-3.94314,2.25105,1.06241,-3.64737,2.30375,1.23109,-3.46497,2.30842,1.37493,-3.2674,2.29932,1.41183,-3.02771,2.25883,1.53232,-3.12864,2.30855,1.39662,-3.55363,3.34026,.397,-3.54111,2.88647,1.91628,-3.93471,3.1063,1.66462,-3.89868,3.08347,1.62833,-4.04421,3.01937,1.83186,-3.92754,3.18319,1.38336,-3.88335,3.17899,1.35505,-4.03773,3.31008,1.45576,-3.35478,3.25007,1.42368,-3.54455,3.21159,1.40456,-3.69306,3.28122,1.12917,-3.66752,2.85532,1.63575,-4.18744,2.38513,.19413,-3.81143,2.47675,.15941,-3.60291,2.68732,.16887,-3.52011,3.05088,.53197,-4.12489,2.95161,.51345,-4.15939,3.0701,.68395,-4.21658,2.98205,.67022,-4.2542,2.62647,.14058,-3.65409,2.78302,.65826,-4.29958,2.75512,.4901,-4.18856,2.79574,.90454,-4.37205,2.18923,.56495,-4.06541,2.22664,.73624,-4.15807,2.35885,.51092,-4.15124,2.34569,.31288,-4.00362,2.45038,.98898,-4.3489,2.39567,.66998,-4.26063,2.53795,.2926,-4.01563,2.55346,.18322,-3.82684,2.56904,.48872,-4.17969,2.59313,.6818,-4.30701,2.61853,.92717,-4.37456,2.53964,.93635,-2.32156,2.56212,.94503,-2.14182,1.68705,1.73346,-2.49698,1.73417,1.64522,-2.57431};
			return value;
		}
		private double[] getlcalc_Coord_7_20_point_8()
		{
			double[] value = {1.66222,1.85794,-2.58927,1.73768,1.61586,-2.36929,1.84768,1.55518,-2.25352,1.68981,1.89305,-2.48042,2.28183,1.33198,-2.62842,2.19037,1.4342,-2.54261,1.77232,1.52603,-2.42908,1.87131,1.46175,-2.31255,1.83948,1.57529,-2.63223,1.87284,1.47087,-2.4717,2.03831,1.49268,-2.51779,2.1189,1.48126,-2.53272,2.26405,1.40142,-2.7688,2.18588,1.50526,-2.72883,1.71086,1.9338,-2.62816,2.17062,1.5988,-2.90348,2.32521,1.28007,-2.83266,2.23921,1.52168,-2.96582,2.22006,1.6037,-3.06294,2.14868,1.69321,-2.99675,2.0489,1.73839,-2.93565,2.69416,.97831,-2.05047,2.73845,.87362,-2.11991,2.78929,.8037,-2.21146,2.68849,.68216,-2.87383,2.84028,.76147,-2.32565,3.37936,1.1871,-2.20375,3.19072,.94695,-2.34091,3.13766,1.67949,-2.22003,3.19679,1.89057,-1.89873,2.75857,2.12657,-3.12555,2.89299,1.95962,-2.77358,3.09096,2.04657,-2.82458,2.97034,1.85394,-2.64728,3.17119,1.92592,-2.70295,2.56077,2.07738,-3.21868,2.58983,2.06602,-3.07803,3.42502,1.61472,-2.46271,3.06211,1.11313,-1.741};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlcuboid_Geo_6_25_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,1,0,-1,4,5,6,-1,7,8,9,-1,9,10,7,-1,2,1,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,22,24,23,-1,25,26,27,-1,27,28,25,-1,29,30,31,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,8,46,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,64,65,62,-1,66,67,68,-1,69,70,71,-1,25,72,73,-1,25,28,72,-1,43,74,75,-1,76,77,78,-1,76,40,77,-1,79,80,81,-1,79,82,80,-1,83,80,84,-1,84,85,83,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,91,93,92,-1,94,95,2,-1,94,96,95,-1,97,98,99,-1,99,100,97,-1,101,102,103,-1,103,104,101,-1,105,106,107,-1,108,109,110,-1,111,48,47,-1,112,69,71,-1,113,96,114,-1,115,116,117,-1,70,69,118,-1,119,117,116,-1,119,120,117,-1,121,122,123,-1,124,125,126,-1,125,48,126,-1,127,128,129,-1,129,130,127,-1,131,132,133,-1,134,135,121,-1,136,137,138,-1,138,139,136,-1,137,136,140,-1,141,142,143,-1,142,144,143,-1,145,146,147,-1,145,148,146,-1,38,51,149,-1,38,52,51,-1,150,151,1,-1,152,153,154,-1,118,123,153,-1,155,156,157,-1,156,158,157,-1,18,159,160,-1,161,162,163,-1,163,164,161,-1,165,163,16,-1,16,15,165,-1,166,160,167,-1,167,168,166,-1,169,170,32,-1,170,171,32,-1,41,172,39,-1,173,174,175,-1,176,177,169,-1,177,170,169,-1,178,175,179,-1,178,180,175,-1,181,182,183,-1,182,184,183,-1,185,186,187,-1,0,2,85,-1,2,83,85,-1,188,189,190,-1,188,191,189,-1,192,193,194,-1,194,195,192,-1,196,197,198,-1,197,199,198,-1,200,201,202,-1,15,17,203,-1,204,205,206,-1,207,148,208,-1,207,146,148,-1,145,209,143,-1,145,210,209,-1,114,211,212,-1,114,213,211,-1,214,215,216,-1,215,217,216,-1,79,117,218,-1,11,219,213,-1,213,94,11,-1,220,80,83,-1,220,81,80,-1,3,221,222,-1,222,223,3,-1,224,225,226,-1,225,227,226,-1,228,229,230,-1,231,232,233,-1,233,234,231,-1,235,236,76,-1,235,237,236,-1,40,39,77,-1,238,45,46,-1,46,239,238,-1,240,241,10,-1,122,130,242,-1,122,121,130,-1,125,127,135,-1,135,243,125,-1,38,58,57,-1,38,37,52,-1,184,244,183,-1,65,245,62,-1,246,247,248,-1,248,249,246,-1,184,182,246,-1,244,184,171,-1,250,251,174,-1,174,169,250,-1,252,176,173,-1,252,228,176,-1,177,253,254,-1,255,256,257,-1,152,258,153,-1,152,158,258,-1,69,259,260,-1,69,112,259,-1,118,153,258,-1,258,70,118,-1,261,262,263,-1,262,110,263,-1,264,265,266,-1,259,136,260,-1,267,268,269,-1,267,270,268,-1,133,271,244,-1,244,254,133,-1,224,226,272,-1,35,32,273,-1,273,184,246,-1,246,249,273,-1,248,274,249,-1,275,276,277,-1,277,245,275,-1,62,277,278,-1,62,245,277,-1,62,279,63,-1,280,281,282,-1,283,284,285,-1,284,286,285,-1,280,282,54,-1,111,287,149,-1,49,125,243,-1,49,48,125,-1,288,129,289,-1,55,256,255,-1,255,290,55,-1,291,154,292,-1,154,122,292,-1,45,293,240,-1,240,9,45,-1,40,76,236,-1,237,235,263,-1,263,110,237,-1,294,231,234,-1,234,295,294,-1,296,297,298,-1,90,299,142,-1,299,144,142,-1,300,301,188,-1,191,302,189,-1,303,304,305,-1,303,306,304,-1,307,308,309,-1,221,3,0,-1,11,1,310,-1,1,151,310,-1,311,81,220,-1,311,115,81,-1,312,313,116,-1,314,145,147,-1,315,316,317,-1,315,318,316,-1,14,319,12,-1,201,320,321,-1,322,200,202,-1,323,324,22,-1,160,325,19,-1,326,92,327,-1,16,328,17,-1,104,329,330,-1,330,101,104,-1,331,194,332,-1,331,195,194,-1,333,334,335,-1,333,336,334,-1,102,337,338,-1,339,275,340,-1,339,276,275,-1,277,341,278,-1,332,342,343,-1,344,266,119,-1,266,120,119,-1,173,176,174,-1,176,169,174,-1,233,257,132,-1,233,345,257,-1,250,68,251,-1,250,34,68,-1,175,174,251,-1,167,93,168,-1,93,91,168,-1,98,24,324,-1,24,22,324,-1,320,201,346,-1,201,347,346,-1,167,160,348,-1,349,319,14,-1,156,106,158,-1,350,4,351,-1,351,352,350,-1,242,292,122,-1};
			return value;
		}
		private int[] getlcuboid_Geo_6_25_coordIndex_2()
		{
			int[] value = {4,350,232,-1,353,303,354,-1,353,355,303,-1,356,216,217,-1,248,247,357,-1,358,37,357,-1,357,247,358,-1,215,359,217,-1,171,170,244,-1,143,144,145,-1,144,148,145,-1,346,347,329,-1,347,330,329,-1,47,49,360,-1,47,360,138,-1,360,139,138,-1,219,310,361,-1,219,11,310,-1,301,191,188,-1,301,304,191,-1,129,288,130,-1,288,242,130,-1,256,271,133,-1,133,257,256,-1,133,132,257,-1,362,117,120,-1,314,210,145,-1,363,364,365,-1,365,218,363,-1,265,137,140,-1,265,366,137,-1,333,367,368,-1,367,369,368,-1,370,371,372,-1,372,373,370,-1,374,99,166,-1,374,100,99,-1,335,334,375,-1,334,376,375,-1,11,94,2,-1,93,327,92,-1,93,377,327,-1,315,378,379,-1,379,318,315,-1,143,212,141,-1,220,2,95,-1,220,83,2,-1,117,81,115,-1,117,79,81,-1,263,380,381,-1,381,261,263,-1,235,76,382,-1,76,78,382,-1,355,353,383,-1,217,359,384,-1,385,386,387,-1,388,53,389,-1,390,283,285,-1,391,64,178,-1,391,65,64,-1,65,391,275,-1,275,245,65,-1,283,126,48,-1,256,282,271,-1,183,286,181,-1,282,256,55,-1,55,54,282,-1,283,48,284,-1,48,51,284,-1,392,42,172,-1,42,39,172,-1,240,10,9,-1,77,39,307,-1,39,44,307,-1,51,50,284,-1,31,27,393,-1,394,395,396,-1,342,332,397,-1,30,27,31,-1,30,28,27,-1,398,300,369,-1,369,367,398,-1,399,22,21,-1,400,401,15,-1,19,18,160,-1,188,369,300,-1,45,9,8,-1,0,85,221,-1,1,3,150,-1,44,39,42,-1,399,323,22,-1,402,323,399,-1,367,403,398,-1,404,403,367,-1,405,187,394,-1,185,187,405,-1,342,396,395,-1,342,397,396,-1,406,394,396,-1,405,394,406,-1,26,393,27,-1,26,407,393,-1,274,29,249,-1,274,30,29,-1,183,281,286,-1,183,244,281,-1,54,388,390,-1,53,388,54,-1,271,281,244,-1,281,271,282,-1,408,409,410,-1,408,411,409,-1,264,366,265,-1,264,412,366,-1,226,297,296,-1,297,226,227,-1,297,413,414,-1,413,297,415,-1,416,417,418,-1,239,417,416,-1,419,238,420,-1,421,238,419,-1,178,422,391,-1,422,178,179,-1,390,280,54,-1,390,285,280,-1,389,290,423,-1,389,55,290,-1,389,53,55,-1,289,267,288,-1,289,270,267,-1,340,424,339,-1,425,424,340,-1,426,427,428,-1,426,429,427,-1,430,73,429,-1,186,73,430,-1,431,107,108,-1,105,107,431,-1,355,432,433,-1,355,383,432,-1,434,43,435,-1,43,434,74,-1,235,380,263,-1,235,382,380,-1,84,261,381,-1,436,261,84,-1,380,221,381,-1,222,221,380,-1,437,78,309,-1,437,382,78,-1,438,394,187,-1,394,438,395,-1,439,89,440,-1,89,439,87,-1,95,311,220,-1,311,95,441,-1,409,442,443,-1,444,442,409,-1,141,211,411,-1,212,211,141,-1,378,203,17,-1,315,203,378,-1,377,379,327,-1,377,318,379,-1,210,445,446,-1,445,210,314,-1,338,447,448,-1,338,337,447,-1,449,450,451,-1,450,449,452,-1,453,454,455,-1,454,453,456,-1,343,395,438,-1,342,395,343,-1,88,204,457,-1,204,88,87,-1,439,359,205,-1,359,439,458,-1,384,459,460,-1,384,461,459,-1,462,113,463,-1,113,462,441,-1,334,347,376,-1,334,330,347,-1,404,375,23,-1,404,335,375,-1,443,371,370,-1,443,442,371,-1,373,300,398,-1,373,372,300,-1,368,336,333,-1,336,368,337,-1,364,464,465,-1,466,464,364,-1,467,431,262,-1,465,431,467,-1,138,366,287,-1,366,138,137,-1,265,468,362,-1,265,140,468,-1,82,467,436,-1,82,365,467,-1,363,117,362,-1,363,218,117,-1,469,470,313,-1,469,471,470,-1,269,345,350,-1,269,268,345,-1,267,350,352,-1,267,269,350,-1,304,472,305,-1,304,301,472,-1,473,361,310,-1,361,473,474,-1,243,360,49,-1,243,475,360,-1,468,112,476,-1,468,259,112,-1,195,477,198,-1,195,331,477,-1,478,199,479,-1,478,192,199,-1,161,480,481,-1,161,164,480,-1,411,142,141,-1,411,408,142,-1,209,212,143,-1,114,212,209,-1,205,215,206,-1,205,359,215,-1,37,50,52,-1,50,37,358,-1,58,149,412,-1,58,38,149,-1,482,429,426,-1,482,430,429,-1,384,356,217,-1,356,384,460,-1,386,344,387,-1,386,266,344,-1,457,206,483,-1,457,204,206,-1,484,387,344,-1,485,387,484,-1,383,308,432,-1,383,486,308,-1,44,75,307,-1,43,75,44,-1,242,351,292,-1};
			return value;
		}
		private int[] getlcuboid_Geo_6_25_coordIndex_3()
		{
			int[] value = {352,351,242,-1,110,487,237,-1,110,109,487,-1,41,236,488,-1,236,41,40,-1,489,319,349,-1,489,490,319,-1,491,14,13,-1,491,197,14,-1,346,13,320,-1,346,491,13,-1,375,21,23,-1,375,322,21,-1,160,99,325,-1,99,160,166,-1,207,492,493,-1,208,492,207,-1,328,163,162,-1,328,16,163,-1,200,375,376,-1,200,322,375,-1,299,492,208,-1,299,326,492,-1,68,175,251,-1,68,179,175,-1,417,46,494,-1,46,417,239,-1,495,7,294,-1,7,495,8,-1,350,233,232,-1,345,233,350,-1,496,63,272,-1,496,64,63,-1,5,294,7,-1,231,294,5,-1,497,302,435,-1,497,225,302,-1,471,484,470,-1,471,459,484,-1,498,461,458,-1,498,485,461,-1,57,386,385,-1,56,386,57,-1,481,483,214,-1,480,483,481,-1,214,147,481,-1,147,214,216,-1,499,277,276,-1,499,341,277,-1,500,339,424,-1,500,501,339,-1,456,501,500,-1,501,456,453,-1,499,453,452,-1,499,501,453,-1,279,278,502,-1,62,278,279,-1,194,455,454,-1,455,194,193,-1,451,503,103,-1,451,450,503,-1,278,449,448,-1,341,449,278,-1,337,190,447,-1,337,368,190,-1,336,330,334,-1,336,101,330,-1,478,103,503,-1,478,104,103,-1,477,163,165,-1,163,477,164,-1,329,491,346,-1,479,491,329,-1,328,378,17,-1,328,493,378,-1,326,379,492,-1,379,326,327,-1,377,167,348,-1,167,377,93,-1,159,348,160,-1,159,316,348,-1,19,324,323,-1,325,324,19,-1,399,322,202,-1,399,21,322,-1,12,320,13,-1,320,12,321,-1,504,201,321,-1,201,504,202,-1,490,12,319,-1,12,490,505,-1,315,506,203,-1,315,317,506,-1,20,504,505,-1,504,20,402,-1,316,489,317,-1,489,316,159,-1,86,186,430,-1,86,187,186,-1,161,207,162,-1,207,161,146,-1,313,462,469,-1,313,312,462,-1,114,94,213,-1,114,96,94,-1,168,374,166,-1,410,374,168,-1,354,310,151,-1,354,473,310,-1,370,374,443,-1,370,100,374,-1,472,371,474,-1,371,472,372,-1,309,486,437,-1,308,486,309,-1,191,435,302,-1,191,434,435,-1,303,433,306,-1,433,303,355,-1,372,301,300,-1,372,472,301,-1,304,434,191,-1,306,434,304,-1,368,188,190,-1,368,369,188,-1,335,367,333,-1,367,335,404,-1,507,42,392,-1,497,42,507,-1,227,415,297,-1,227,507,415,-1,508,509,252,-1,508,414,509,-1,494,413,417,-1,413,494,510,-1,509,511,229,-1,509,510,511,-1,511,294,295,-1,511,495,294,-1,230,234,131,-1,230,295,234,-1,512,513,241,-1,513,512,291,-1,512,158,152,-1,512,157,158,-1,109,61,487,-1,61,109,59,-1,60,293,421,-1,60,155,293,-1,488,420,41,-1,420,488,419,-1,513,292,351,-1,291,292,513,-1,268,290,255,-1,290,268,270,-1,289,128,423,-1,129,128,289,-1,514,121,123,-1,514,134,121,-1,475,139,360,-1,139,475,515,-1,48,149,51,-1,48,111,149,-1,388,124,126,-1,388,389,124,-1,286,280,285,-1,286,281,280,-1,502,448,447,-1,502,278,448,-1,391,340,275,-1,391,422,340,-1,67,393,425,-1,67,66,393,-1,516,426,517,-1,426,516,482,-1,427,274,248,-1,427,72,274,-1,186,25,73,-1,185,25,186,-1,30,72,28,-1,72,30,274,-1,29,273,249,-1,29,35,273,-1,496,298,180,-1,296,298,496,-1,6,351,4,-1,6,513,351,-1,139,260,136,-1,139,515,260,-1,287,412,149,-1,287,366,412,-1,120,265,362,-1,265,120,266,-1,112,466,476,-1,466,112,71,-1,436,262,261,-1,467,262,436,-1,485,385,387,-1,498,385,485,-1,344,470,484,-1,344,119,470,-1,447,189,502,-1,189,447,190,-1,158,105,258,-1,158,106,105,-1,258,464,70,-1,464,258,105,-1,123,69,514,-1,118,69,123,-1,476,362,468,-1,476,363,362,-1,514,260,515,-1,260,514,69,-1,154,123,122,-1,154,153,123,-1,132,234,233,-1,132,131,234,-1,228,177,176,-1,177,228,253,-1,180,508,175,-1,180,298,508,-1,171,273,32,-1,273,171,184,-1,247,182,358,-1,247,246,182,-1,407,425,393,-1,407,424,425,-1,500,396,456,-1,500,406,396,-1,36,357,37,-1,36,428,357,-1,66,31,393,-1,66,33,31,-1,181,358,182,-1,358,181,50,-1,36,57,517,-1,36,38,57,-1,134,515,475,-1,134,514,515,-1,130,135,127,-1,130,121,135,-1,124,423,128,-1,389,423,124,-1,241,6,10,-1,241,513,6,-1,41,416,172,-1,41,420,416,-1,421,45,238,-1,45,421,293,-1,487,419,488,-1};
			return value;
		}
		private int[] getlcuboid_Geo_6_25_coordIndex_4()
		{
			int[] value = {487,61,419,-1,59,155,60,-1,156,155,59,-1,152,291,512,-1,154,291,152,-1,241,157,512,-1,157,241,240,-1,131,254,253,-1,254,131,133,-1,295,229,511,-1,229,295,230,-1,510,495,511,-1,510,494,495,-1,229,252,509,-1,252,229,228,-1,414,510,509,-1,414,413,510,-1,507,418,415,-1,507,392,418,-1,225,507,227,-1,225,497,507,-1,398,97,373,-1,403,97,398,-1,306,74,434,-1,306,433,74,-1,437,223,222,-1,486,223,437,-1,473,303,305,-1,354,303,473,-1,373,100,370,-1,373,97,100,-1,474,442,361,-1,474,371,442,-1,444,361,442,-1,361,444,219,-1,211,219,444,-1,211,213,219,-1,82,218,365,-1,82,79,218,-1,446,209,210,-1,463,209,446,-1,498,516,385,-1,498,440,516,-1,147,356,314,-1,147,216,356,-1,299,148,144,-1,208,148,299,-1,440,482,516,-1,89,482,440,-1,343,483,332,-1,343,457,483,-1,20,490,18,-1,505,490,20,-1,202,402,399,-1,202,504,402,-1,349,317,489,-1,349,506,317,-1,321,505,504,-1,321,12,505,-1,506,14,400,-1,506,349,14,-1,348,318,377,-1,348,316,318,-1,378,492,379,-1,493,492,378,-1,197,479,199,-1,197,491,479,-1,198,165,196,-1,165,198,477,-1,192,503,193,-1,192,478,503,-1,338,103,102,-1,103,338,451,-1,341,452,449,-1,341,499,452,-1,454,332,194,-1,397,332,454,-1,279,189,302,-1,279,502,189,-1,193,450,455,-1,193,503,450,-1,424,406,500,-1,407,406,424,-1,276,501,499,-1,339,501,276,-1,214,206,215,-1,206,214,483,-1,480,332,483,-1,480,331,332,-1,508,173,175,-1,173,508,252,-1,385,517,57,-1,385,516,517,-1,445,459,471,-1,445,460,459,-1,250,32,34,-1,250,169,32,-1,302,224,279,-1,225,224,302,-1,177,244,170,-1,177,254,244,-1,279,272,63,-1,272,279,224,-1,180,64,496,-1,180,178,64,-1,231,4,232,-1,4,231,5,-1,46,495,494,-1,8,495,46,-1,172,418,392,-1,416,418,172,-1,435,42,497,-1,435,43,42,-1,162,493,328,-1,207,493,162,-1,90,326,299,-1,90,92,326,-1,325,98,324,-1,98,325,99,-1,201,376,347,-1,200,376,201,-1,197,400,14,-1,197,196,400,-1,15,196,165,-1,401,196,15,-1,400,196,401,-1,159,490,489,-1,159,18,490,-1,155,240,293,-1,157,240,155,-1,237,488,236,-1,488,237,487,-1,486,353,223,-1,383,353,486,-1,307,432,308,-1,432,307,75,-1,223,150,3,-1,223,353,150,-1,386,264,266,-1,386,56,264,-1,461,484,459,-1,461,485,484,-1,89,430,482,-1,89,86,430,-1,248,428,427,-1,248,357,428,-1,331,164,477,-1,331,480,164,-1,410,91,408,-1,410,168,91,-1,161,147,146,-1,147,161,481,-1,479,104,478,-1,329,104,479,-1,192,198,199,-1,192,195,198,-1,140,259,468,-1,140,136,259,-1,475,135,134,-1,475,243,135,-1,474,305,472,-1,305,474,473,-1,128,125,124,-1,125,128,127,-1,288,352,242,-1,288,267,352,-1,255,345,268,-1,345,255,257,-1,312,115,311,-1,115,312,116,-1,313,119,116,-1,313,470,119,-1,446,471,469,-1,471,446,445,-1,463,114,209,-1,114,463,113,-1,70,466,71,-1,464,466,70,-1,230,253,228,-1,230,131,253,-1,287,47,138,-1,287,111,47,-1,365,465,467,-1,364,465,365,-1,262,108,110,-1,431,108,262,-1,476,364,363,-1,476,466,364,-1,465,105,431,-1,464,105,465,-1,107,156,59,-1,106,156,107,-1,337,101,336,-1,101,337,102,-1,98,403,24,-1,97,403,98,-1,95,113,441,-1,96,113,95,-1,469,463,446,-1,463,469,462,-1,384,458,461,-1,384,359,458,-1,205,87,439,-1,205,204,87,-1,438,457,343,-1,457,438,88,-1,456,397,454,-1,397,456,396,-1,452,455,450,-1,455,452,453,-1,448,451,338,-1,451,448,449,-1,460,314,356,-1,460,445,314,-1,408,90,142,-1,408,91,90,-1,444,411,211,-1,444,409,411,-1,441,312,311,-1,312,441,462,-1,458,440,498,-1,440,458,439,-1,88,187,86,-1,187,88,438,-1,309,77,307,-1,309,78,77,-1,222,382,437,-1,222,380,382,-1,85,381,221,-1,85,84,381,-1,80,436,84,-1,82,436,80,-1,353,151,150,-1,354,151,353,-1,433,75,74,-1,433,432,75,-1,108,59,109,-1,107,59,108,-1,428,517,426,-1,517,428,36,-1,72,429,73,-1,72,427,429,-1,425,422,67,-1,425,340,422,-1,270,423,290,-1,289,423,270,-1,33,68,34,-1,33,66,68,-1,67,179,68,-1,67,422,179,-1};
			return value;
		}
		private int[] getlcuboid_Geo_6_25_coordIndex_5()
		{
			int[] value = {61,421,419,-1,60,421,61,-1,420,239,416,-1,238,239,420,-1,417,415,418,-1,417,413,415,-1,298,414,508,-1,414,298,297,-1,272,296,496,-1,296,272,226,-1,412,56,58,-1,264,56,412,-1,410,443,374,-1,410,409,443,-1,126,390,388,-1,126,283,390,-1,286,50,181,-1,50,286,284,-1,405,407,26,-1,405,406,407,-1,33,29,31,-1,35,29,33,-1,26,185,405,-1,25,185,26,-1,24,404,23,-1,24,403,404,-1,323,20,19,-1,20,323,402,-1,203,400,15,-1,203,506,400,-1,10,5,7,-1,6,5,10,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlcuboid_Coord_7_25_point_1()
		{
			double[] value = {2.83428,1.11477,-1.06577,2.87665,1.11985,-1.04572,2.83242,1.18208,-1.00275,2.8988,1.04008,-1.1347,2.45166,1.40327,-1.78537,2.56146,1.36201,-1.80786,2.54798,1.31775,-1.78071,2.68266,1.32082,-1.76021,2.74289,1.29889,-1.74924,2.73631,1.26714,-1.70509,2.66302,1.27774,-1.73724,2.92753,1.15188,-1.01249,3.48612,1.38837,-1.06449,3.53857,1.46692,-1.07894,3.48766,1.52568,-.97862,3.31964,1.7109,-.79232,3.22033,1.70248,-.74986,3.2247,1.6515,-.73916,3.29277,1.183,-.94094,3.29766,1.12148,-1.03411,3.34436,1.18451,-1.04868,3.49672,1.04452,-1.32081,3.44646,1.02221,-1.26623,3.48966,1.0386,-1.34895,3.43494,1.00925,-1.29056,2.97966,1.92043,-1.23203,3.05327,1.89355,-1.27954,3.02257,1.91239,-1.38359,2.93026,1.9253,-1.32325,2.89641,1.92868,-1.40108,2.90631,1.92812,-1.38074,3.01517,1.90716,-1.41973,2.86201,1.91631,-1.61957,2.98549,1.89297,-1.5358,2.96143,1.92778,-1.62069,2.86779,1.90323,-1.5364,2.71161,1.80657,-1.25493,2.60225,1.84263,-1.36427,2.63175,1.67375,-1.28548,3.18774,1.03846,-1.70822,3.059,1.02548,-1.61028,3.01294,1.08729,-1.63376,3.20962,1.04808,-1.7131,3.22563,1.03855,-1.6969,3.20479,1.03397,-1.70596,2.81075,1.23732,-1.67954,2.8507,1.2555,-1.73744,2.58051,1.57181,-1.34834,2.53036,1.64893,-1.45568,2.56513,1.56807,-1.37223,2.58042,1.77346,-1.43442,2.57747,1.74402,-1.43277,2.57551,1.7641,-1.42413,2.467,1.5892,-1.53829,2.47945,1.59809,-1.5516,2.46244,1.58416,-1.5581,2.71494,1.50168,-1.17761,2.71223,1.65365,-1.19522,2.69957,1.58513,-1.20822,2.71883,1.15616,-1.38401,2.77784,1.17062,-1.51933,2.80346,1.14957,-1.50129,3.3729,1.50338,-1.64628,3.3412,1.52433,-1.68678,3.25715,1.67461,-1.68815,3.28257,1.65588,-1.63603,3.12371,1.85457,-1.56037,3.13774,1.84248,-1.56712,3.13123,1.88087,-1.63408,2.50371,1.31269,-1.25402,2.56885,1.22539,-1.25407,2.58702,1.27457,-1.24451,2.86513,1.93429,-1.28088,2.94044,1.93465,-1.20684,3.23928,1.02494,-1.60828,3.20015,.98137,-1.62857,3.00377,.99264,-1.53072,3.1004,.9767,-1.61803,3.03788,.95247,-1.52165,2.73005,1.23245,-1.14759,2.75161,1.18407,-1.10203,2.75669,1.22187,-1.09867,2.71984,1.19332,-1.14474,2.79976,1.18026,-1.0412,2.75219,1.13065,-1.1226,2.80424,1.11969,-1.08496,3.02563,1.89196,-1.05082,3.03917,1.86332,-1.00486,3.05393,1.87433,-1.01512,3.0068,1.8822,-1.03728,2.95683,1.20808,-.80404,2.99029,1.15635,-.84449,2.97776,1.21081,-.78446,3.00543,1.15685,-.82574,2.87117,1.18554,-.96793,2.82527,1.21521,-.99121,2.85804,1.22551,-.94687,3.29419,1.03931,-1.15696,3.30952,1.01418,-1.1494,3.23217,1.06208,-1.02308};
			return value;
		}
		private double[] getlcuboid_Coord_7_25_point_2()
		{
			double[] value = {3.21122,1.07308,-1.03674,3.52623,1.35006,-1.33825,3.50574,1.38882,-1.40697,3.47043,1.5098,-1.26823,3.5078,1.46962,-1.22026,2.62073,1.16187,-1.25697,2.6532,1.16407,-1.36562,2.68656,1.13873,-1.34789,2.73498,1.10693,-1.32904,2.76935,1.12104,-1.37008,2.76323,1.08782,-1.31945,2.60059,1.61547,-1.32758,2.59627,1.2924,-1.24849,2.85779,1.24968,-.94141,2.89096,1.23585,-.90253,2.77321,1.27983,-1.09169,2.78667,1.33151,-1.0965,2.75028,1.2985,-1.16291,2.48945,1.24723,-1.29098,2.79755,1.40502,-1.10569,2.75333,1.35912,-1.16467,2.40826,1.27669,-1.45246,2.423,1.25077,-1.51246,2.46058,1.25773,-1.32006,2.45945,1.53621,-1.45642,2.47029,1.51946,-1.44321,2.51358,1.64216,-1.46683,2.41501,1.40661,-1.4443,2.40204,1.41729,-1.4582,2.37347,1.32305,-1.51482,2.38071,1.30615,-1.50385,2.57874,1.63004,-1.67488,2.48034,1.60344,-1.69203,2.51637,1.65152,-1.63326,2.4363,1.35048,-1.38083,2.42671,1.37266,-1.41642,2.62934,1.45802,-1.2515,2.66223,1.48732,-1.24327,2.59544,1.558,-1.32617,2.55893,1.51659,-1.31304,2.68341,1.45212,-1.23178,2.92785,1.22751,-.84914,2.94597,1.22165,-.82546,2.93763,1.30469,-.84901,2.95228,1.29979,-.80035,3.01392,1.44729,-.83473,3.08108,1.53303,-.78459,3.07146,1.54262,-.83097,3.01459,1.44421,-.78456,2.6344,1.66333,-1.29969,2.93449,1.06138,-1.1132,2.9606,1.08408,-1.09887,2.52962,1.18496,-1.44539,2.49187,1.21582,-1.32771,2.45943,1.21422,-1.50952,2.73759,1.20355,-1.5476,2.68058,1.19024,-1.41515,2.69853,1.2164,-1.56509,2.62389,1.18719,-1.39251,3.27567,1.193,-.91408,3.19372,1.08174,-.92333,3.13306,1.63749,-.7888,3.14818,1.65488,-.73944,3.20949,1.71809,-.76396,3.19678,1.71834,-.80554,3.31852,1.73037,-.8071,3.16646,1.07014,-.94134,3.04743,1.12767,-.8543,3.03118,1.12155,-.87199,2.88482,1.90624,-1.65011,2.76427,1.87223,-1.62859,2.76008,1.87665,-1.60368,3.08206,1.0714,-1.71701,3.05454,1.83991,-1.67226,3.0836,1.86552,-1.67214,3.186,1.78995,-1.68216,2.87881,1.8737,-1.67375,2.75258,1.84808,-1.65391,3.22586,1.73905,-1.67998,3.19509,1.79752,-1.66209,3.2138,1.73355,-1.69202,2.58416,1.77715,-1.50088,2.60722,1.86182,-1.43956,2.58841,1.77784,-1.52088,2.74473,1.87561,-1.54876,3.02967,1.90501,-1.14621,3.01681,1.9114,-1.13508,3.06534,1.89502,-1.07917,3.3726,1.16766,-1.52928,3.38529,1.24539,-1.62295,3.41608,1.23818,-1.57598,3.34029,1.14757,-1.5624,3.42485,1.57958,-1.06708,3.39803,1.62215,-1.13001,3.32184,1.69555,-1.03094,3.34534,1.67282,-.97263,3.40147,1.65427,-.88785,3.48684,1.54258,-.99044,3.36797,1.6592,-.93045,3.4535,1.56271,-1.0284};
			return value;
		}
		private double[] getlcuboid_Coord_7_25_point_3()
		{
			double[] value = {3.56096,1.18627,-1.29948,3.56418,1.29649,-1.24899,3.51224,1.1711,-1.2647,3.2916,1.61291,-.78479,3.08535,1.8137,-.94126,3.05072,1.76074,-.93934,3.12386,1.76537,-.88348,3.08879,1.52042,-.73308,3.00408,1.44886,-.73184,2.91062,1.30702,-.89472,2.98316,1.4368,-.90352,2.94133,1.18634,-.90295,2.91683,1.23065,-.86809,2.91098,1.1892,-.93181,3.07591,1.64092,-.86957,3.05602,1.64031,-.87326,3.03842,1.57835,-.89059,3.02819,1.58105,-.89568,2.70904,1.24081,-1.18625,2.95752,1.14966,-.98041,2.80038,1.21479,-1.02765,2.82999,1.04129,-1.14781,2.90771,.99525,-1.23518,2.97118,1.00689,-1.21938,3.36469,1.40096,-1.66856,3.32949,1.23629,-1.69448,3.29994,1.46203,-1.70519,3.22094,1.32055,-1.70995,2.84599,1.74683,-1.69131,2.80628,1.56306,-1.70724,2.704,1.60113,-1.69608,2.56527,1.38499,-1.80725,2.44741,1.42455,-1.7857,2.42832,1.47678,-1.76195,2.5682,1.49061,-1.73643,2.91457,1.01078,-1.43109,2.98205,1.04298,-1.52799,2.88949,1.0647,-1.44218,2.86903,1.20256,-1.65888,2.91305,1.19962,-1.73267,2.72146,1.23967,-1.64683,2.64343,1.23471,-1.71429,2.40869,1.2835,-1.60799,2.47476,1.46631,-1.38875,2.61145,1.7679,-1.5895,3.30582,1.63532,-1.58558,2.70043,1.95249,-1.39157,2.69456,1.94904,-1.3298,2.71767,1.95633,-1.3156,2.77593,1.94996,-1.38233,2.94885,1.92106,-1.63787,3.12598,1.87847,-1.64641,2.98816,1.70126,-1.71086,2.70206,1.75354,-1.65765,2.61066,1.76209,-1.60192,2.43674,1.58978,-1.67155,2.49186,1.6442,-1.62574,2.45191,1.5949,-1.69097,2.56733,1.19161,-1.27984,2.62773,1.37104,-1.25826,2.54803,1.38886,-1.24421,2.72546,1.09096,-1.20654,2.68277,1.11674,-1.23964,2.80458,1.04846,-1.28936,2.71973,1.48433,-1.18762,2.71233,1.44547,-1.19218,2.74677,1.46529,-1.15427,2.40693,1.35773,-1.70764,2.40343,1.45974,-1.74121,2.41423,1.42651,-1.75911,2.40635,1.41085,-1.66317,2.5098,1.65033,-1.62518,3.33156,1.51602,-1.69842,2.82316,1.90702,-1.53661,2.79647,1.94886,-1.34173,3.26676,1.70315,-1.55763,3.30122,1.68354,-1.4421,3.35177,1.62842,-1.48189,3.42879,1.5011,-1.57354,3.37782,1.41009,-1.65609,2.55751,1.66544,-1.55697,2.59248,1.74152,-1.57335,2.51048,1.64852,-1.60787,2.52935,1.65565,-1.47907,2.56894,1.74156,-1.44994,2.5385,1.66099,-1.50093,2.57297,1.74279,-1.5131,2.61087,1.60595,-1.31229,2.39433,1.2981,-1.61251,2.39001,1.36703,-1.58921,2.42969,1.50674,-1.59794,2.49505,1.22325,-1.64749,2.43731,1.25347,-1.63071,2.77278,1.22038,-1.61458,2.68158,1.34656,-1.76593,2.6789,1.46391,-1.74015,3.19635,1.56986,-1.70922,3.08688,1.41545,-1.71704,3.16685,1.59875,-1.71034,2.94909,1.30163,-.75482};
			return value;
		}
		private double[] getlcuboid_Coord_7_25_point_4()
		{
			double[] value = {3.35136,1.08124,-1.34696,3.28782,1.10542,-1.38812,3.34235,1.2286,-1.68264,3.12803,1.05561,-1.31452,3.25498,1.09325,-1.41284,3.16247,1.08957,-1.28913,3.22497,1.04596,-1.44213,3.17279,.97174,-1.6379,3.13439,.94701,-1.48633,3.0856,.93954,-1.50173,2.9982,1.1166,-1.0781,2.80499,1.2668,-1.01735,2.8161,1.31831,-1.02221,2.84534,1.38276,-1.03525,3.00042,1.46727,-.90219,3.19783,1.45277,-.77875,3.17415,1.2842,-.81193,3.25416,1.41689,-.82047,3.11477,1.32442,-.78104,3.45891,1.43745,-.96538,3.56657,1.41428,-1.16248,3.52142,1.35008,-1.16416,3.5216,1.09033,-1.33516,3.38333,1.08586,-1.17004,3.33431,1.01967,-1.14257,3.25828,1.07194,-1.01184,2.96787,1.2981,-.73964,2.99115,1.26941,-.75821,3.16628,1.65686,-.72879,3.53191,1.4544,-1.1958,3.5422,1.32827,-1.30025,3.28177,1.739,-.88514,3.25659,1.77425,-.91377,3.47605,1.14364,-1.40212,3.53969,1.22288,-1.35878,3.49344,1.11731,-1.37935,3.52074,1.24992,-1.39267,3.4953,1.30275,-1.46019,3.49309,1.41176,-1.4371,3.25003,1.73785,-1.40231,3.22407,1.76787,-1.52937,3.36876,1.61737,-1.45573,3.19658,1.81494,-1.01263,3.17219,1.83075,-.9793,2.81584,1.532,-1.09892,2.41684,1.46938,-1.75419,3.56506,1.43854,-1.17938,3.56724,1.30857,-1.26675,3.11084,1.1992,-.8145,3.44511,1.45587,-.94019,2.43245,1.42429,-1.77626,2.44742,1.32131,-1.73694,2.42504,1.34623,-1.71653,3.00502,1.03189,-1.19416,3.03261,1.05963,-1.17383,3.09973,1.01364,-1.32385,3.02891,1.56997,-.90219,2.69968,1.94613,-1.30597,2.60217,1.85684,-1.38469,2.99594,1.64523,-.92936,2.56473,1.53949,-1.34765,3.03451,1.1274,-1.04769,2.73081,1.32643,-1.2008,2.69467,1.24825,-1.20634,2.67016,1.21343,-1.19972,2.68808,1.20256,-1.18746,2.67904,1.52039,-1.23006,3.44666,1.08435,-1.37655,3.4513,1.19842,-1.45853,3.40671,1.14368,-1.41993,3.19032,1.08408,-1.05041,3.1472,1.09541,-1.07872,3.23153,1.08186,-1.19308,3.27221,1.0524,-1.16975,3.14416,1.09117,-.9568,3.51891,1.09134,-1.3671,3.56765,1.1979,-1.32939,3.05174,1.235,-.78636,3.1396,1.48681,-.73704,3.05362,1.36286,-.75012,2.84595,1.00911,-1.25926,2.76807,1.06517,-1.17343,2.95372,.97501,-1.40988,3.08223,.98761,-1.32962,2.98406,1.5704,-.93667,2.83645,1.64617,-1.08609,2.73716,1.48521,-1.14966,2.81318,1.55039,-1.09192,2.48882,1.61718,-1.49553,2.4627,1.56613,-1.50378,2.51354,1.63918,-1.49929,3.23489,1.71195,-1.61585,3.10059,1.08453,-1.72741,3.13581,1.85477,-1.48429,3.12595,1.85953,-1.12867,3.13897,1.85396,-1.11421,3.18619,1.82378,-1.17817,3.22065,1.79867,-1.04594,3.39355,1.05408,-1.31347,3.46989,1.07668,-1.26566};
			return value;
		}
		private double[] getlcuboid_Coord_7_25_point_5()
		{
			double[] value = {3.40133,1.63997,-.87356,3.36108,1.67601,-.83295,3.40947,1.13532,-1.16725,3.41449,1.0361,-1.29937,3.46664,1.06498,-1.35948,3.09051,1.87468,-1.19906,3.16389,1.83786,-1.26301,3.15184,1.84047,-1.34572,2.98189,1.17454,-.85584,3.01646,1.13987,-.90402,3.02657,1.13511,-.88711,2.96676,1.17695,-.87593,2.70423,1.56805,-1.21778,2.96569,1.31923,-1.73632,3.00379,1.45438,-1.71768,3.04816,1.28777,-1.72837,2.97528,1.14372,-1.72791,2.9262,1.21536,-1.74323,2.98973,1.15647,-1.739,2.86771,1.14832,-1.5784,2.92967,1.15283,-1.64831,2.82272,1.18237,-1.5939,3.1977,1.77351,-1.59219,2.41592,1.46197,-1.52799,3.20533,1.79973,-1.37198,3.16373,1.83051,-1.49778,2.86509,1.92392,-1.16193,2.80478,1.93177,-1.24777,2.78173,1.92218,-1.2373,2.88593,1.93366,-1.17433,2.97099,1.91328,-1.09912,2.65179,1.13931,-1.2483,3.16386,.96089,-1.47435,3.19443,1.00357,-1.45825,3.29508,1.08659,-1.57915,3.28569,1.12279,-1.68737,2.71585,1.14624,-1.16322,3.00157,.95965,-1.37637,3.09157,1.88392,-1.05027,2.98366,1.75614,-.99384,2.94605,1.76676,-1.02922,2.82474,1.26354,-.98029,3.07551,1.11532,-1.00408,3.11909,1.10209,-.97388,2.99295,1.1461,-.93727,2.95992,1.46621,-.94513,2.94277,1.42699,-.9445,3.45195,1.36197,-1.56706,3.45682,1.47939,-1.52542,3.3993,1.59723,-1.40854,3.39097,1.6091,-1.27584,3.43455,1.55338,-1.33838,3.34861,1.65249,-1.35258,3.29771,1.70728,-1.29663,3.28633,1.73425,-1.14258,3.34759,1.66468,-1.21332,3.24515,1.76516,-1.2545,3.10504,1.82135,-.94801,2.94638,1.65108,-.9826,2.93544,1.56473,-.98714,2.98854,1.55738,-.94145,2.93155,1.57677,-.98141,2.83739,1.31356,-.98001,2.87394,1.31027,-.93736,2.63135,1.19141,-1.22761,2.65544,1.17662,-1.21573,2.64668,1.22764,-1.21576,2.67948,1.1618,-1.20384,2.69665,1.34568,-1.23572,2.90254,1.41725,-.9855,2.86223,1.43932,-1.03956,2.91959,1.4652,-.98806,3.20161,1.09973,-1.25895,3.06525,1.09227,-1.14972,3.10425,1.10962,-1.11769,2.4857,1.44783,-1.35132,2.66996,1.2642,-1.22898,3.30547,1.72758,-.84549,3.4783,1.51743,-1.14339,3.50661,1.49748,-1.11492,3.1818,1.72974,-.84131,3.11484,1.64444,-.83503,2.95222,1.90416,-1.08499,3.1491,1.76522,-.87747,2.88319,1.56637,-1.03623,2.88108,1.58048,-1.02979,3.05716,.973,-1.34197,2.85641,1.10352,-1.46489,2.93025,1.09456,-1.54051,3.35434,1.31442,-.91404,3.36845,1.29857,-.93974,3.53705,1.48198,-1.08844,3.01697,1.43785,-.71904,3.10089,1.51115,-.72452,2.86258,1.27423,-1.74746,2.75082,1.32023,-1.75658,3.24591,1.66589,-1.70027,3.27685,1.13443,-1.69973,2.89882,1.65044,-1.02737,3.32493,1.66808,-1.39734};
			return value;
		}
		private double[] getlcuboid_Coord_7_25_point_6()
		{
			double[] value = {3.22401,1.78358,-1.31689,3.27387,1.72263,-1.34946,3.42133,1.38626,-1.61313,3.43396,1.56591,-1.19912,3.45173,1.21315,-1.16293,3.40119,1.26306,-1.05864,3.34997,1.55761,-.84531,3.17608,1.21124,-1.71934,3.08995,1.64325,-1.71058,2.92019,1.49315,-1.71829,2.88275,1.35058,-1.74424,2.76902,1.40067,-1.74224,2.59851,1.20278,-1.60963,2.53095,1.26176,-1.74636,2.4618,1.33055,-1.29478,2.49412,1.42628,-1.29338,2.88827,1.78309,-1.08362,2.79392,1.80129,-1.17414};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getllcun_Geo_6_30_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,0,6,1,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,13,16,14,-1,12,17,18,-1,19,20,21,-1,21,22,19,-1,2,23,0,-1,24,25,26,-1,27,28,29,-1,27,30,28,-1,27,31,30,-1,32,33,34,-1,34,35,32,-1,36,37,38,-1,39,40,41,-1,40,42,41,-1,43,44,45,-1,43,46,44,-1,47,48,38,-1,38,37,47,-1,49,50,51,-1,49,52,50,-1,52,53,50,-1,54,55,56,-1,57,56,58,-1,56,59,58,-1,60,61,62,-1,62,40,60,-1,57,54,56,-1,63,64,65,-1,66,67,68,-1,68,69,66,-1,70,71,72,-1,73,74,75,-1,73,76,74,-1,77,78,79,-1,79,80,77,-1,81,82,83,-1,84,85,86,-1,87,88,89,-1,87,90,88,-1,47,37,91,-1,92,93,94,-1,92,95,93,-1,67,96,97,-1,50,98,51,-1,99,10,20,-1,100,101,102,-1,103,33,104,-1,105,106,32,-1,107,108,14,-1,109,110,27,-1,111,105,32,-1,111,112,105,-1,28,35,113,-1,28,111,35,-1,114,115,116,-1,117,69,118,-1,69,119,118,-1,97,68,67,-1,120,121,17,-1,120,122,121,-1,123,124,51,-1,125,84,86,-1,125,126,84,-1,127,43,45,-1,128,129,130,-1,131,104,132,-1,106,105,133,-1,133,134,106,-1,134,135,136,-1,134,137,135,-1,138,139,140,-1,9,135,7,-1,141,142,143,-1,143,144,141,-1,145,146,60,-1,82,81,147,-1,81,53,147,-1,81,148,53,-1,58,149,150,-1,151,60,146,-1,51,59,49,-1,152,153,55,-1,154,155,149,-1,155,150,149,-1,55,54,156,-1,91,157,158,-1,92,94,44,-1,44,46,92,-1,159,160,161,-1,159,162,160,-1,163,164,165,-1,161,160,166,-1,95,162,93,-1,95,160,162,-1,91,167,157,-1,167,168,157,-1,138,169,170,-1,138,143,169,-1,156,54,57,-1,56,49,59,-1,59,51,171,-1,57,58,150,-1,83,122,81,-1,146,172,151,-1,3,5,173,-1,5,174,173,-1,2,1,175,-1,9,8,176,-1,9,138,135,-1,138,136,135,-1,139,170,177,-1,139,138,170,-1,178,106,136,-1,106,134,136,-1,134,133,179,-1,179,137,134,-1,104,131,103,-1,180,181,140,-1,140,139,180,-1,182,125,41,-1,182,126,125,-1,85,183,184,-1,19,101,185,-1,124,123,186,-1,66,51,124,-1,117,66,69,-1,33,187,34,-1,28,30,188,-1,189,15,190,-1,189,13,15,-1,191,190,22,-1,22,192,191,-1,193,80,79,-1,79,194,193,-1,195,196,31,-1,195,197,196,-1,35,111,32,-1,198,130,129,-1,199,200,201,-1,199,202,200,-1,27,29,203,-1,148,50,53,-1,148,98,50,-1,204,52,49,-1,205,206,61,-1,69,207,119,-1,208,108,209,-1,108,107,209,-1,123,210,186,-1,123,211,210,-1,212,197,213,-1,46,214,92,-1,182,42,215,-1,182,41,42,-1,49,56,204,-1,65,76,73,-1,73,63,65,-1,19,22,190,-1,190,101,19,-1,193,216,80,-1,216,77,80,-1,65,64,207,-1,210,217,70,-1,210,70,186,-1,70,72,186,-1,171,218,149,-1,218,154,149,-1,59,149,58,-1,59,171,149,-1,151,205,61,-1,61,60,151,-1,88,219,36,-1,36,38,88,-1,62,220,215,-1,215,42,62,-1,37,36,155,-1,155,221,37,-1,66,171,51,-1,145,39,222,-1,222,142,145,-1,53,172,147,-1,53,52,172,-1,184,177,170,-1,170,85,184,-1,62,42,40,-1,35,34,223,-1,223,114,35,-1,159,224,163,-1,163,162,159,-1,225,114,223,-1,225,115,114,-1,178,140,128,-1,128,132,178,-1,28,113,29,-1,113,202,29,-1,202,113,200,-1,113,226,200,-1,79,78,227,-1,228,201,229,-1,228,199,201,-1,27,203,109,-1,230,1,6,-1,230,231,1,-1,22,21,192,-1,23,2,232,-1,232,176,23,-1,102,15,14,-1,12,11,17,-1,14,16,107,-1,190,191,189,-1,233,191,234,-1,189,191,233,-1,235,236,237,-1,238,236,235,-1,239,240,241,-1,242,240,239,-1,243,173,7,-1,243,244,173,-1,174,176,8,-1,174,23,176,-1,2,245,232,-1,175,245,2,-1,246,247,248,-1,246,121,247,-1,249,166,168,-1,166,249,250,-1,251,252,253,-1,251,254,252,-1,255,256,257,-1,255,258,256,-1,259,213,260,-1,259,261,213,-1,262,263,212,-1,262,264,263,-1,265,266,267,-1,268,266,265,-1,185,269,99,-1,270,269,185,-1,21,271,192,-1,21,272,271,-1,230,273,231,-1,274,273,230,-1,203,228,109,-1,203,199,228,-1};
			return value;
		}
		private int[] getllcun_Geo_6_30_coordIndex_2()
		{
			int[] value = {25,201,26,-1,25,229,201,-1,275,226,276,-1,200,226,275,-1,24,275,276,-1,24,26,275,-1,132,106,178,-1,104,106,132,-1,224,115,225,-1,224,159,115,-1,165,181,93,-1,165,129,181,-1,162,165,93,-1,162,163,165,-1,169,85,170,-1,85,169,86,-1,125,39,41,-1,222,39,125,-1,277,45,44,-1,278,45,277,-1,146,142,82,-1,142,146,145,-1,150,156,57,-1,150,219,156,-1,219,90,156,-1,90,219,88,-1,279,215,220,-1,215,279,280,-1,204,205,151,-1,204,153,205,-1,221,154,218,-1,221,155,154,-1,65,69,68,-1,69,65,207,-1,124,72,96,-1,124,186,72,-1,281,70,217,-1,281,71,70,-1,282,283,284,-1,283,282,285,-1,286,11,10,-1,11,286,287,-1,15,101,190,-1,15,102,101,-1,108,288,289,-1,108,208,288,-1,193,110,216,-1,195,110,193,-1,63,258,64,-1,256,258,63,-1,27,195,31,-1,27,110,195,-1,290,291,278,-1,290,292,291,-1,290,183,292,-1,280,182,215,-1,182,280,293,-1,292,294,291,-1,292,295,294,-1,296,127,297,-1,127,296,43,-1,262,75,281,-1,75,262,261,-1,98,123,51,-1,98,211,123,-1,264,281,217,-1,281,264,262,-1,286,267,285,-1,267,286,269,-1,239,189,233,-1,239,13,189,-1,298,107,299,-1,107,298,209,-1,112,28,188,-1,112,111,28,-1,300,263,268,-1,300,196,263,-1,210,301,284,-1,210,211,301,-1,116,251,276,-1,116,250,251,-1,252,64,258,-1,119,64,252,-1,119,207,64,-1,181,94,93,-1,94,181,180,-1,172,204,151,-1,172,52,204,-1,148,211,98,-1,301,211,148,-1,120,282,302,-1,287,282,120,-1,78,229,25,-1,78,77,229,-1,29,199,203,-1,29,202,199,-1,300,31,196,-1,288,31,300,-1,195,194,197,-1,194,195,193,-1,257,194,79,-1,257,260,194,-1,75,259,73,-1,261,259,75,-1,289,300,303,-1,289,288,300,-1,273,18,246,-1,18,273,272,-1,271,236,234,-1,271,274,236,-1,233,242,239,-1,233,238,242,-1,240,299,241,-1,299,240,179,-1,133,112,298,-1,133,105,112,-1,113,114,226,-1,114,113,35,-1,276,253,24,-1,253,276,251,-1,249,118,254,-1,304,118,249,-1,218,66,117,-1,171,66,218,-1,284,302,282,-1,301,302,284,-1,303,102,289,-1,100,102,303,-1,101,270,185,-1,101,100,270,-1,126,293,295,-1,126,182,293,-1,87,295,293,-1,87,294,295,-1,127,278,291,-1,127,45,278,-1,277,94,180,-1,94,277,44,-1,7,137,243,-1,137,7,135,-1,305,33,103,-1,305,187,33,-1,164,129,165,-1,164,198,129,-1,140,136,138,-1,140,178,136,-1,9,143,138,-1,143,9,144,-1,0,174,5,-1,174,0,23,-1,244,3,173,-1,244,235,3,-1,274,237,236,-1,230,237,274,-1,83,245,247,-1,83,141,245,-1,246,231,273,-1,248,231,246,-1,221,91,37,-1,221,167,91,-1,155,219,150,-1,155,36,219,-1,62,206,220,-1,62,61,206,-1,169,142,222,-1,143,142,169,-1,168,304,249,-1,167,304,168,-1,161,250,116,-1,250,161,166,-1,225,305,224,-1,225,187,305,-1,116,159,161,-1,115,159,116,-1,305,163,224,-1,164,163,305,-1,157,95,158,-1,160,95,157,-1,60,39,145,-1,60,40,39,-1,152,220,206,-1,220,152,279,-1,214,91,158,-1,214,47,91,-1,218,167,221,-1,218,304,167,-1,153,206,205,-1,153,152,206,-1,82,141,83,-1,82,142,141,-1,247,122,83,-1,247,121,122,-1,248,1,231,-1,248,175,1,-1,230,4,237,-1,6,4,230,-1,244,238,235,-1,244,242,238,-1,141,232,245,-1,141,144,232,-1,131,128,130,-1,131,132,128,-1,177,180,139,-1,177,277,180,-1,130,103,131,-1,198,103,130,-1,198,305,103,-1,305,198,164,-1,243,179,240,-1,137,179,243,-1,294,89,297,-1,294,87,89,-1,184,290,278,-1,184,183,290,-1,48,297,89,-1,48,296,297,-1,81,301,148,-1,81,302,301,-1,17,287,120,-1,287,17,11,-1,68,76,65,-1,76,68,97,-1,117,304,218,-1,118,304,117,-1,254,119,252,-1,118,119,254,-1,26,200,275,-1,201,200,26,-1,223,187,225,-1,223,34,187,-1,77,228,229,-1,77,216,228,-1,109,216,110,-1,109,228,216,-1,30,209,188,-1,30,208,209,-1,133,299,179,-1,298,299,133,-1,272,12,18,-1,12,272,21,-1,260,197,194,-1,213,197,260,-1,283,267,266,-1,267,283,285,-1,63,259,256,-1,259,63,73,-1,122,302,81,-1,120,302,122,-1,265,100,303,-1,100,265,270,-1};
			return value;
		}
		private int[] getllcun_Geo_6_30_coordIndex_3()
		{
			int[] value = {24,255,227,-1,255,24,253,-1,276,114,116,-1,226,114,276,-1,217,266,264,-1,266,217,283,-1,188,298,112,-1,209,298,188,-1,299,16,241,-1,16,299,107,-1,234,192,271,-1,234,191,192,-1,10,269,286,-1,269,10,99,-1,303,268,265,-1,300,268,303,-1,212,196,197,-1,263,196,212,-1,97,74,76,-1,97,96,74,-1,297,291,294,-1,291,297,127,-1,84,295,292,-1,84,126,295,-1,92,158,95,-1,214,158,92,-1,89,38,48,-1,89,88,38,-1,90,293,280,-1,293,90,87,-1,85,292,183,-1,292,85,84,-1,227,257,79,-1,227,255,257,-1,288,30,31,-1,288,208,30,-1,14,289,102,-1,108,289,14,-1,20,12,21,-1,20,10,12,-1,287,285,282,-1,287,286,285,-1,210,283,217,-1,210,284,283,-1,281,74,71,-1,75,74,281,-1,72,74,96,-1,72,71,74,-1,96,66,124,-1,66,96,67,-1,55,204,56,-1,204,55,153,-1,156,280,279,-1,280,156,90,-1,279,55,156,-1,279,152,55,-1,147,146,82,-1,147,172,146,-1,43,214,46,-1,214,43,296,-1,47,296,48,-1,47,214,296,-1,184,277,177,-1,278,277,184,-1,222,86,169,-1,86,222,125,-1,129,140,181,-1,129,128,140,-1,104,32,106,-1,104,33,32,-1,227,25,24,-1,25,227,78,-1,176,144,9,-1,176,232,144,-1,274,272,273,-1,271,272,274,-1,99,19,185,-1,99,20,19,-1,267,270,265,-1,267,269,270,-1,268,264,266,-1,263,264,268,-1,212,261,262,-1,213,261,212,-1,256,260,257,-1,256,259,260,-1,258,253,252,-1,253,258,255,-1,250,254,251,-1,250,249,254,-1,168,160,157,-1,160,168,166,-1,17,246,18,-1,17,121,246,-1,175,247,245,-1,175,248,247,-1,7,174,8,-1,7,173,174,-1,244,240,242,-1,240,244,243,-1,13,241,16,-1,239,241,13,-1,6,5,4,-1,5,6,0,-1,237,3,235,-1,237,4,3,-1,238,234,236,-1,233,234,238,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getllcun_Coord_7_30_point_1()
		{
			double[] value = {2.6132,1.26612,-1.04874,2.59245,1.26986,-.99651,2.58259,1.31685,-1.05489,2.69732,1.24112,-1.04071,2.65608,1.22369,-1.01661,2.65128,1.25688,-1.06146,2.61956,1.23706,-1.0071,2.73922,1.29678,-1.05588,2.66404,1.33465,-1.08392,2.65262,1.42812,-1.11263,2.69673,1.24717,-.56028,2.67956,1.26323,-.56471,2.68222,1.24229,-.57705,2.86481,1.20845,-.68114,2.9163,1.2391,-.60768,2.89629,1.22072,-.61287,2.87385,1.22731,-.68551,2.66622,1.27936,-.64751,2.65841,1.25736,-.6495,2.76924,1.18014,-.59957,2.7095,1.20211,-.59093,2.69401,1.19277,-.6112,2.76196,1.17348,-.61984,2.61786,1.31493,-1.0683,3.15772,1.8713,-.54007,3.19411,1.85994,-.5476,3.18301,1.87143,-.56833,3.04193,1.48497,-.5628,3.07726,1.60579,-.67299,3.099,1.59547,-.65187,3.01988,1.46012,-.56792,3.0201,1.48002,-.54557,3.03076,1.61535,-.83186,3.04821,1.63274,-.8522,3.15552,1.70865,-.80139,3.13412,1.72638,-.76902,2.59521,2.10891,-.85465,2.61793,2.10655,-.86412,2.61067,2.09973,-.87768,2.52047,1.61001,-1.07518,2.48886,1.6098,-1.0343,2.51793,1.62918,-1.0789,2.48431,1.62755,-1.03984,2.77495,2.04048,-1.09887,2.82264,1.9855,-1.16869,2.80387,1.98195,-1.16724,2.79545,2.05328,-1.09626,2.67359,2.10769,-.93587,2.66054,2.09509,-.94413,2.63942,1.77786,-.80026,2.64544,1.75686,-.78057,2.66788,1.79041,-.61631,2.61467,1.68096,-.82761,2.62723,1.66901,-.8102,2.54077,1.83959,-.84315,2.53496,1.81794,-.8478,2.55195,1.83197,-.83751,2.54496,1.85318,-.83435,2.58799,1.86518,-.72329,2.62399,1.85967,-.72925,2.51079,1.56051,-.97287,2.497,1.57374,-.95603,2.47565,1.61805,-1.02693,2.87389,1.9274,-.25486,2.87118,1.94197,-.25917,2.84573,1.93573,-.25367,2.70903,1.8877,-.4627,2.69675,1.88755,-.43853,2.75583,1.94705,-.33837,2.77104,1.96189,-.35902,2.70644,1.59684,-.39154,2.73563,1.67013,-.37124,2.70446,1.685,-.41264,2.84253,1.85009,-.29607,2.76388,1.73877,-.35102,2.79134,1.72751,-.35319,2.82154,1.86034,-.29891,3.29853,1.77159,-.52621,3.23231,1.80788,-.47286,3.22114,1.78324,-.44404,3.27813,1.74507,-.50383,2.65195,1.4978,-.74132,2.58603,1.52203,-.88471,2.6158,1.39691,-.8678,2.60409,1.67897,-1.13478,2.64567,1.65679,-1.17956,2.56651,1.62309,-1.14278,2.58151,1.8886,-1.0037,2.57514,2.01726,-.9133,2.62205,2.01199,-.96692,2.5282,1.89985,-.95756,2.70417,2.13192,-.86204,2.81069,2.06242,-1.08327,2.87143,1.97924,-1.13598,2.83763,1.97496,-1.14398,2.85347,2.07161,-1.04406,2.69923,1.78041,-.42906,2.73042,1.87594,-.38635,2.64923,1.68395,-.64616,2.72264,1.22966,-.57353};
			return value;
		}
		private double[] getllcun_Coord_7_30_point_2()
		{
			double[] value = {2.86114,1.24239,-.58068,2.84143,1.20198,-.60503,2.89996,1.23319,-.59256,2.978,1.67815,-.92989,2.92908,1.55056,-.94125,2.95381,1.53591,-.83615,2.9148,1.53659,-.92157,2.91132,1.30657,-.66749,2.96645,1.31039,-.59223,3.14152,1.53275,-.61318,3.1313,1.52933,-.54902,3.05496,1.62789,-.755,2.98275,1.52173,-.7427,3.14245,1.71087,-.68799,3.20374,1.81186,-.7828,3.16983,1.84977,-.8278,3.06677,1.92636,-.70417,2.76942,1.97551,-.44612,2.80655,1.99768,-.44053,2.83002,1.97606,-.36317,2.66644,1.33925,-.6097,2.63318,1.30195,-.76541,2.64151,1.36521,-.75902,2.70128,1.68821,-.46037,2.70917,1.76762,-.44481,2.52639,1.62783,-1.08904,2.55297,1.69759,-1.08246,2.75314,1.99544,-1.1098,2.7904,1.62982,-1.14939,2.83632,1.82042,-1.16108,2.86949,1.71524,-1.08656,2.91858,1.60187,-.97281,2.85314,1.56336,-1.04094,2.90294,1.44582,-.84235,2.843,1.4608,-.93142,2.75432,1.37075,-1.03932,2.77594,1.49353,-1.01995,2.78755,1.33184,-.95135,2.65869,1.56514,-1.13979,2.75009,1.71918,-1.17678,2.76503,1.63327,-1.14776,2.59589,1.42791,-.99234,2.57061,1.54633,-1.03196,2.59623,1.54518,-1.09578,2.60414,1.42948,-1.09823,2.55389,1.56532,-1.02861,2.57119,1.54179,-.89358,2.60867,1.57293,-.84017,2.65054,1.59088,-.69374,2.63124,1.92278,-.59762,2.59403,1.97809,-.7763,2.54031,1.57362,-.84663,2.50987,1.73391,-.87372,2.5394,1.70359,-.82038,2.68186,2.01043,-.57759,2.63957,2.06892,-.72241,2.52039,1.89544,-.93774,2.79083,2.10939,-.87505,2.77558,2.11633,-.94088,3.11662,1.90196,-.89818,2.90887,2.05552,-.92645,2.98766,1.98463,-.81857,3.00105,1.95323,-1.00462,3.00991,1.93171,-1.02197,2.9789,1.86759,-1.0252,2.89027,1.95856,-1.14227,2.93563,2.00672,-.79161,2.74149,2.08957,-.7136,2.83662,2.04786,-.74091,2.57008,1.60435,-1.14263,2.65656,1.64212,-1.18247,2.65713,1.90478,-.58822,2.59331,1.58635,-.85297,2.7318,1.27714,-1.05573,2.65749,1.30984,-1.08425,2.57761,1.31905,-.98857,2.62148,1.33889,-1.0692,2.75399,1.76466,-1.20811,2.83011,1.54899,-1.03035,2.81744,1.31328,-.86207,2.79206,1.85355,-1.16793,2.81049,1.83465,-1.16286,2.52616,1.70084,-1.05952,2.72258,1.7715,-1.19187,2.73975,1.7725,-1.20673,2.78274,1.21338,-.58473,2.71669,1.67722,-.43033,3.12104,1.74225,-.85018,3.00576,1.49783,-.64784,2.84033,1.18336,-.67289,2.83441,1.18399,-.6269,2.80787,1.16709,-.66267,2.74786,1.17042,-.63821,3.21373,1.63964,-.51787,3.12796,1.69934,-.46265,3.12586,1.53404,-.53056,2.97819,1.50702,-.51166,3.03785,1.58963,-.49014,2.90294,1.76807,-1.05282,3.21119,1.65059,-.64301};
			return value;
		}
		private double[] getllcun_Coord_7_30_point_3()
		{
			double[] value = {3.25242,1.82147,-.65546,3.29854,1.79688,-.60913,3.15644,1.69706,-.66401,3.13383,1.54786,-.63538,2.55863,1.70598,-.81005,2.52374,1.58895,-.84912,2.4955,1.62971,-.91252,2.85237,1.95257,-.27886,2.99499,1.39247,-.57862,2.96646,1.40916,-.65786,2.70193,1.5573,-.41258,2.69029,1.59552,-.48618,2.96713,1.6129,-.45615,2.9742,1.62818,-.44973,2.73644,2.08857,-1.01059,2.47494,1.69799,-1.01931,3.21967,1.63684,-.5359,2.71831,1.56353,-.39916,2.70717,2.00132,-.562,2.56741,2.01484,-.89067,2.46661,1.6922,-.99858,2.66316,2.06954,-.72922,2.52861,1.61004,-1.08574,3.19775,1.80143,-.81037,3.13049,1.88926,-.9173,3.18272,1.83785,-.84767,3.22968,1.81506,-.68039,3.2121,1.80567,-.44273,3.22526,1.63739,-.61504,3.30733,1.78633,-.58106,2.644,1.20953,-.92097,2.60767,1.23929,-.90358,2.59413,1.34143,-1.05503,2.80336,1.17709,-.75583,2.77,1.16384,-.74003,2.72953,1.20881,-.95595,2.73056,1.17685,-.83422,2.68964,1.19917,-.93727,2.76435,1.18811,-.85126,2.83115,1.19967,-.76684,2.7996,1.23294,-.86644,2.8403,1.21755,-.76823,2.79137,1.21419,-.86411,2.77114,1.25556,-.96535,2.76268,1.23704,-.96554,2.58917,1.33902,-.98888,2.62357,1.2807,-.7681,2.60116,1.31512,-.87352,2.58997,1.29525,-.87369,2.89506,1.99549,-.58299,2.98164,1.96111,-.6436,3.03404,1.92884,-.54752,2.96666,1.93892,-.42653,3.06297,1.90532,-.48333,2.93869,1.96227,-.48638,3.11604,1.85079,-.38019,3.01733,1.88002,-.31205,3.12022,1.8319,-.37808,3.01818,1.89544,-.3176,2.96401,1.78309,-.36027,3.04663,1.74138,-.41148,2.90976,1.6665,-.40928,2.89567,1.63596,-.42213,2.91845,1.52587,-.48399,2.8582,1.54458,-.45631,2.84126,1.33452,-.54329,2.8196,1.44735,-.48875,2.782,1.34738,-.52635,2.87895,1.4302,-.50893,2.75635,1.28338,-.54701,2.80896,1.26279,-.56393,2.718,1.17267,-.71255,2.67439,1.19582,-.68626,2.64261,1.21609,-.79875,2.68335,1.18889,-.8164,3.16405,1.88603,-.60226,3.12778,1.89496,-.60859,2.78392,1.87109,-1.18725,2.76918,1.87482,-1.18584,2.48651,1.78106,-.96927,2.49424,1.78648,-.98933,2.762,1.66171,-.37164,2.67676,1.3876,-.50302,2.7039,1.47077,-.44727,2.6901,1.47838,-.45472,2.69052,1.38185,-.49383,2.69352,1.3149,-.52703,2.67825,1.31726,-.53773,2.98864,1.39398,-.56013,2.95877,1.31149,-.5756,2.72777,1.78125,-1.1921,2.7107,1.87498,-1.12605,2.65927,1.77809,-1.13241,2.54266,1.78542,-1.02942,2.641,1.87711,-1.06211,2.60099,1.784,-1.07815,2.72443,2.07581,-1.02048,2.69567,2.00315,-1.04982,2.93412,1.4285,-.74906,2.86207,1.30324,-.75887};
			return value;
		}
		private double[] getllcun_Coord_7_30_point_4()
		{
			double[] value = {2.93641,1.4149,-.53368,2.68209,1.51121,-.53088,2.67407,1.4269,-.57558,2.90013,1.32155,-.56021,2.774,2.02524,-.54125,3.06762,1.79003,-.91973};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlmcun_Geo_6_35_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,5,-1,8,9,5,-1,1,10,2,-1,11,12,13,-1,11,14,12,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,27,44,-1,43,28,27,-1,45,46,6,-1,46,4,6,-1,47,48,49,-1,47,50,48,-1,51,52,53,-1,53,52,54,-1,52,55,54,-1,56,57,26,-1,58,59,60,-1,61,62,63,-1,63,25,61,-1,64,65,66,-1,65,67,66,-1,68,69,70,-1,71,72,73,-1,71,74,72,-1,75,76,77,-1,77,78,75,-1,77,79,78,-1,80,81,82,-1,83,84,85,-1,86,85,84,-1,86,87,85,-1,81,37,88,-1,37,89,88,-1,90,91,92,-1,23,93,21,-1,32,94,30,-1,95,45,96,-1,97,94,29,-1,98,99,100,-1,100,101,98,-1,102,46,103,-1,102,104,46,-1,105,106,107,-1,105,108,106,-1,109,110,111,-1,112,110,113,-1,114,110,115,-1,116,110,117,-1,118,119,120,-1,118,121,119,-1,122,123,120,-1,120,119,122,-1,15,124,125,-1,126,71,127,-1,128,129,130,-1,130,131,128,-1,25,132,26,-1,114,133,134,-1,114,115,133,-1,135,136,137,-1,135,138,136,-1,139,125,140,-1,141,136,138,-1,141,16,136,-1,142,143,144,-1,144,145,142,-1,120,146,118,-1,120,147,146,-1,148,149,150,-1,148,151,149,-1,152,153,154,-1,154,48,152,-1,25,24,61,-1,155,156,157,-1,158,37,159,-1,160,124,161,-1,160,125,124,-1,130,162,163,-1,131,130,163,-1,163,143,131,-1,72,74,164,-1,75,165,76,-1,166,167,140,-1,168,169,170,-1,169,171,172,-1,160,161,173,-1,173,174,160,-1,153,175,176,-1,153,152,175,-1,118,146,167,-1,177,80,82,-1,177,178,80,-1,179,82,180,-1,179,177,82,-1,181,182,183,-1,181,184,182,-1,185,186,187,-1,187,188,185,-1,15,17,189,-1,190,19,18,-1,190,191,19,-1,18,192,193,-1,18,194,192,-1,195,111,196,-1,197,198,199,-1,197,200,198,-1,60,65,64,-1,201,202,41,-1,21,40,22,-1,35,141,203,-1,141,138,203,-1,7,204,205,-1,7,206,204,-1,207,143,163,-1,207,144,143,-1,208,207,209,-1,207,210,209,-1,208,144,207,-1,211,8,212,-1,211,9,8,-1,206,5,4,-1,206,7,5,-1,100,99,213,-1,213,214,100,-1,215,216,217,-1,103,218,102,-1,103,219,218,-1,217,220,221,-1,217,216,220,-1,9,211,222,-1,222,223,9,-1,205,224,225,-1,205,204,224,-1,226,227,228,-1,226,229,227,-1,230,225,224,-1,231,34,36,-1,232,21,231,-1,233,35,34,-1,233,141,35,-1,22,40,42,-1,234,60,235,-1,236,43,237,-1,238,239,240,-1,239,241,240,-1,196,111,242,-1,111,110,243,-1,20,244,194,-1,185,245,186,-1,177,246,178,-1,123,14,247,-1,14,248,247,-1,84,167,166,-1,84,83,167,-1,171,169,168,-1,170,169,249,-1,70,69,78,-1,78,79,70,-1,73,250,71,-1,251,16,15,-1,251,136,16,-1,157,252,253,-1,254,159,255,-1,254,158,159,-1,26,132,56,-1,57,254,150,-1,256,257,258,-1,257,259,258,-1,37,252,38,-1,149,26,57,-1,57,150,149,-1,180,260,179,-1,12,123,122,-1,12,14,123,-1,89,39,261,-1,262,75,263,-1,263,264,262,-1,135,137,265,-1,140,125,166,-1,125,160,166,-1,266,203,138,-1,138,135,266,-1,86,267,87,-1,86,268,267,-1,26,149,24,-1,269,270,63,-1,269,155,270,-1,271,47,272,-1,47,55,272,-1,243,110,116,-1,117,110,114,-1,115,110,112,-1,113,110,109,-1,273,274,275,-1,42,65,276,-1,92,277,202,-1,92,91,277,-1,223,5,9,-1,223,3,5,-1,278,1,0,-1,21,232,40,-1,81,88,279,-1,279,82,81,-1,280,121,281,-1,280,119,121,-1,282,260,283,-1,37,39,89,-1,167,146,169,-1,146,249,169,-1,72,248,73,-1,164,247,72,-1,247,248,72,-1,284,285,286,-1,252,37,158,-1,25,270,132,-1,25,63,270,-1,67,42,41,-1,67,65,42,-1,62,61,64,-1,64,66,62,-1,254,257,150,-1,200,237,240,-1,237,287,240,-1,288,272,55,-1,55,52,288,-1,43,287,237,-1,289,209,238,-1,289,290,209,-1,224,291,292,-1,292,230,224,-1,201,41,40,-1,194,18,20,-1,293,294,230,-1,32,31,295,-1,94,32,29,-1,58,61,24,-1,21,93,296,-1,125,251,15,-1};
			return value;
		}
		private int[] getlmcun_Geo_6_35_coordIndex_2()
		{
			int[] value = {297,227,229,-1,229,265,297,-1,298,73,286,-1,298,250,73,-1,167,83,118,-1,234,23,276,-1,299,194,300,-1,2,301,0,-1,230,226,225,-1,230,294,226,-1,225,228,205,-1,225,226,228,-1,302,188,187,-1,303,188,302,-1,299,192,194,-1,304,192,299,-1,244,300,194,-1,300,244,305,-1,306,307,308,-1,307,306,309,-1,23,235,310,-1,235,23,234,-1,276,22,42,-1,276,23,22,-1,311,145,312,-1,311,313,145,-1,73,284,286,-1,73,248,284,-1,314,283,315,-1,283,314,282,-1,316,181,246,-1,316,317,181,-1,265,165,297,-1,137,165,265,-1,296,318,319,-1,318,296,93,-1,320,321,322,-1,321,320,323,-1,64,58,60,-1,64,61,58,-1,295,1,324,-1,295,31,1,-1,99,40,232,-1,99,98,40,-1,204,291,224,-1,204,325,291,-1,104,4,46,-1,4,104,206,-1,1,33,10,-1,1,31,33,-1,326,274,327,-1,274,326,328,-1,329,99,232,-1,329,213,99,-1,330,331,332,-1,331,330,271,-1,210,238,209,-1,238,210,239,-1,290,44,324,-1,44,290,289,-1,241,200,240,-1,241,198,200,-1,333,272,288,-1,333,334,272,-1,39,53,54,-1,53,39,38,-1,335,62,66,-1,335,336,62,-1,318,306,322,-1,310,306,318,-1,270,56,132,-1,253,56,270,-1,337,247,164,-1,337,147,247,-1,172,76,338,-1,172,77,76,-1,249,147,337,-1,147,249,146,-1,74,126,68,-1,71,126,74,-1,119,339,122,-1,339,119,280,-1,281,85,87,-1,85,281,121,-1,268,173,340,-1,173,268,174,-1,186,341,193,-1,245,341,186,-1,258,183,182,-1,259,183,258,-1,80,255,159,-1,80,178,255,-1,342,82,279,-1,342,180,82,-1,283,343,13,-1,343,283,260,-1,324,278,290,-1,324,1,278,-1,301,3,223,-1,3,301,2,-1,197,237,200,-1,237,197,236,-1,67,202,277,-1,202,67,41,-1,214,344,100,-1,214,345,344,-1,327,273,97,-1,327,274,273,-1,346,275,274,-1,275,346,347,-1,325,217,291,-1,217,325,215,-1,348,196,349,-1,196,348,195,-1,345,350,344,-1,350,345,133,-1,351,220,216,-1,134,220,351,-1,352,218,219,-1,353,218,352,-1,354,355,356,-1,354,357,355,-1,358,164,74,-1,337,164,358,-1,338,359,139,-1,359,338,76,-1,79,168,70,-1,79,171,168,-1,360,298,361,-1,360,250,298,-1,330,362,50,-1,162,362,330,-1,52,363,288,-1,52,51,363,-1,156,269,364,-1,156,155,269,-1,149,365,24,-1,149,151,365,-1,320,244,20,-1,308,244,320,-1,174,166,160,-1,166,174,84,-1,266,293,203,-1,294,293,266,-1,34,319,233,-1,34,296,319,-1,75,297,165,-1,297,75,262,-1,366,264,263,-1,264,366,367,-1,175,128,285,-1,129,128,175,-1,238,287,289,-1,238,240,287,-1,261,54,49,-1,54,261,39,-1,342,368,343,-1,176,368,342,-1,316,260,282,-1,179,260,316,-1,356,369,370,-1,355,369,356,-1,371,268,340,-1,371,267,268,-1,269,62,336,-1,63,62,269,-1,53,156,51,-1,53,157,156,-1,372,373,199,-1,372,374,373,-1,257,255,259,-1,257,254,255,-1,256,304,299,-1,256,258,304,-1,256,300,148,-1,300,256,299,-1,59,24,365,-1,58,24,59,-1,254,56,158,-1,56,254,57,-1,38,157,53,-1,252,157,38,-1,271,334,331,-1,271,272,334,-1,152,50,362,-1,48,50,152,-1,298,285,128,-1,286,285,298,-1,360,366,127,-1,360,375,366,-1,358,68,70,-1,68,358,74,-1,176,279,153,-1,342,279,176,-1,284,368,285,-1,11,368,284,-1,281,355,280,-1,355,281,369,-1,370,303,356,-1,370,188,303,-1,340,185,371,-1,185,340,245,-1,161,341,173,-1,161,190,341,-1,308,322,306,-1,322,308,320,-1,113,105,107,-1,113,109,105,-1,133,112,350,-1,112,133,115,-1,116,351,353,-1,116,117,351,-1,242,243,352,-1,242,111,243,-1,241,331,334,-1,239,331,241,-1,44,287,43,-1,44,289,287,-1,326,236,90,-1,326,43,236,-1,328,202,201,-1,202,328,92,-1,310,93,23,-1,318,93,310,-1,233,321,17,-1,319,321,233,-1,329,231,36,-1,329,232,231,-1,35,293,36,-1,293,35,203,-1,266,265,229,-1,266,135,265,-1,294,229,226,-1,294,266,229,-1,262,227,297,-1,262,212,227,-1,367,211,264,-1,222,211,367,-1,142,313,375,-1,313,142,145,-1,106,347,101,-1,106,108,347,-1,295,29,32,-1,295,27,29,-1,376,96,349,-1,376,95,96,-1,273,348,349,-1,273,275,348,-1,94,273,349,-1,94,97,273,-1};
			return value;
		}
		private int[] getlmcun_Geo_6_35_coordIndex_3()
		{
			int[] value = {30,349,96,-1,30,94,349,-1,376,103,95,-1,376,219,103,-1,215,218,216,-1,102,218,215,-1,344,101,100,-1,344,106,101,-1,347,348,275,-1,347,108,348,-1,311,223,222,-1,223,311,301,-1,208,290,278,-1,208,209,290,-1,210,163,332,-1,207,163,210,-1,144,312,145,-1,144,208,312,-1,313,222,367,-1,313,311,222,-1,264,212,262,-1,264,211,212,-1,212,228,227,-1,212,8,228,-1,230,36,293,-1,36,230,329,-1,231,296,34,-1,231,21,296,-1,364,336,374,-1,364,269,336,-1,91,199,373,-1,91,197,199,-1,333,199,198,-1,199,333,372,-1,105,111,195,-1,111,105,109,-1,243,353,352,-1,243,116,353,-1,117,134,351,-1,134,117,114,-1,350,113,107,-1,350,112,113,-1,193,190,18,-1,193,341,190,-1,17,323,189,-1,17,321,323,-1,191,161,124,-1,161,191,190,-1,182,303,302,-1,182,184,303,-1,188,371,185,-1,371,188,370,-1,184,317,354,-1,184,181,317,-1,246,179,316,-1,177,179,246,-1,357,315,339,-1,314,315,357,-1,87,369,281,-1,369,87,267,-1,11,343,368,-1,11,13,343,-1,176,285,368,-1,176,175,285,-1,154,279,88,-1,154,153,279,-1,139,167,338,-1,140,167,139,-1,249,358,170,-1,358,249,337,-1,126,366,263,-1,127,366,126,-1,361,375,360,-1,361,142,375,-1,362,175,152,-1,175,362,129,-1,76,137,359,-1,165,137,76,-1,332,162,330,-1,332,163,162,-1,55,49,54,-1,49,55,47,-1,372,288,363,-1,288,372,333,-1,309,365,307,-1,309,59,365,-1,148,257,256,-1,148,150,257,-1,305,148,300,-1,305,151,148,-1,363,374,372,-1,364,374,363,-1,277,66,67,-1,66,277,335,-1,270,157,253,-1,157,270,155,-1,370,267,371,-1,370,369,267,-1,354,314,357,-1,317,314,354,-1,83,121,118,-1,121,83,85,-1,373,277,91,-1,335,277,373,-1,131,142,361,-1,143,142,131,-1,375,367,366,-1,367,375,313,-1,233,16,141,-1,233,17,16,-1,359,136,251,-1,137,136,359,-1,221,213,292,-1,214,213,221,-1,189,19,191,-1,323,19,189,-1,307,151,305,-1,365,151,307,-1,51,364,363,-1,51,156,364,-1,162,129,362,-1,130,129,162,-1,128,361,298,-1,361,128,131,-1,250,127,71,-1,127,250,360,-1,70,170,358,-1,70,168,170,-1,77,171,79,-1,77,172,171,-1,139,251,125,-1,251,139,359,-1,124,189,191,-1,189,124,15,-1,147,123,247,-1,120,123,147,-1,357,280,355,-1,357,339,280,-1,184,356,303,-1,184,354,356,-1,242,219,376,-1,352,219,242,-1,353,216,218,-1,351,216,353,-1,220,133,345,-1,133,220,134,-1,350,106,344,-1,107,106,350,-1,108,195,348,-1,195,108,105,-1,349,242,376,-1,242,349,196,-1,325,102,215,-1,325,104,102,-1,217,292,291,-1,221,292,217,-1,101,346,98,-1,347,346,101,-1,96,33,30,-1,96,45,33,-1,95,46,45,-1,103,46,95,-1,278,312,208,-1,312,278,0,-1,90,328,326,-1,92,328,90,-1,221,345,214,-1,221,220,345,-1,90,197,91,-1,236,197,90,-1,302,258,182,-1,302,304,258,-1,260,342,343,-1,260,180,342,-1,81,159,37,-1,81,80,159,-1,259,178,183,-1,255,178,259,-1,187,193,192,-1,186,193,187,-1,341,340,173,-1,340,341,245,-1,174,86,84,-1,174,268,86,-1,122,315,12,-1,315,122,339,-1,75,69,263,-1,75,78,69,-1,169,338,167,-1,169,172,338,-1,263,68,126,-1,263,69,68,-1,158,253,252,-1,56,253,158,-1,235,59,309,-1,60,59,235,-1,374,335,373,-1,374,336,335,-1,198,334,333,-1,334,198,241,-1,49,154,261,-1,49,48,154,-1,332,239,210,-1,239,332,331,-1,271,50,47,-1,271,330,50,-1,88,261,154,-1,88,89,261,-1,292,329,230,-1,329,292,213,-1,98,201,40,-1,98,346,201,-1,326,28,43,-1,326,327,28,-1,45,10,33,-1,10,45,6,-1,206,325,204,-1,206,104,325,-1,346,328,201,-1,346,274,328,-1,324,27,295,-1,324,44,27,-1,28,97,29,-1,28,327,97,-1,60,276,65,-1,276,60,234,-1,20,323,320,-1,323,20,19,-1,322,319,318,-1,322,321,319,-1,246,183,178,-1,246,181,183,-1,317,282,314,-1,282,317,316,-1,315,13,12,-1,13,315,283,-1,14,284,248,-1,284,14,11,-1,312,301,311,-1,0,301,312,-1,310,309,306,-1,309,310,235,-1,308,305,244,-1,305,308,307,-1,187,304,302,-1,187,192,304,-1,8,205,228,-1,205,8,7,-1,2,6,3,-1,2,10,6,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlmcun_Coord_7_35_point_1()
		{
			double[] value = {1.75356,1.90911,-.58533,1.74755,1.91917,-.66086,1.72093,1.84346,-.64375,1.68729,1.77337,-.66707,1.6146,1.66807,-.76958,1.6273,1.64624,-.74603,1.6831,1.79125,-.692,1.6086,1.49126,-.83255,1.59201,1.46286,-.81035,1.61897,1.6272,-.7174,1.7145,1.85543,-.67725,1.80357,1.63243,.15961,1.7261,1.56378,.20453,1.81186,1.60105,.21779,1.73296,1.5869,.14232,1.99357,1.01729,-.54026,1.98425,1.06078,-.66542,2.09014,1.09416,-.67541,2.28095,1.07339,-.28531,2.24678,1.07966,-.41161,2.26907,1.12768,-.37972,2.08075,1.35568,-.89886,2.09817,1.46753,-.78685,2.11703,1.43557,-.72119,2.14751,1.58123,-.28696,2.13198,1.65505,-.2583,2.14635,1.60682,-.17405,1.86916,1.94567,-.69176,1.92666,1.91077,-.69218,1.86714,1.91501,-.69112,1.78379,1.84655,-.69548,1.76163,1.90953,-.67846,1.82032,1.91467,-.68723,1.72963,1.8512,-.69337,2.04775,1.23059,-.89194,1.91437,1.15502,-.90639,1.90624,1.22715,-.99531,2.21769,1.74465,.23464,2.22381,1.77076,.15198,2.1957,1.78965,.16254,2.09542,1.50787,-.85614,2.10797,1.57084,-.72071,2.08303,1.54083,-.72755,1.94131,1.92559,-.67945,1.86721,1.96444,-.67802,1.69738,1.78684,-.7073,1.62811,1.67539,-.77865,2.09173,1.95392,-.10263,2.11523,1.9068,.05303,2.14086,1.90113,.03408,2.06252,1.9547,-.08518,2.16735,1.86513,-.15421,2.14812,1.91394,-.13724,2.20747,1.81199,.0183,2.18016,1.83209,.02793,2.11079,1.91763,-.11499,2.18699,1.65304,-.01838,2.16785,1.57199,-.04737,2.11716,1.57416,-.40972,2.12895,1.498,-.44948,2.10386,1.52607,-.52529,2.10563,1.64735,-.37005,2.11608,1.66495,-.37181,2.15007,1.67211,-.28071,2.08561,1.60025,-.4933,2.07832,1.57044,-.60018,2.1136,1.63294,-.49295,2.11079,1.59527,-.61273,1.60404,1.47263,-.32901,1.59324,1.42521,-.41289,1.59162,1.32296,-.33923,1.63924,1.57004,-.18202,1.64386,1.64397,.05925,1.66957,1.66178,.0612,1.6193,1.55821,-.15804,1.58089,1.26111,-.52647,1.66582,1.11256,-.47235,1.64665,1.10868,-.4592,1.57048,1.25647,-.50518,1.5955,1.21236,-.43195,2.19121,1.6671,.21599,2.18634,1.73307,.25974,2.08292,1.7044,.2552,1.75577,1.11306,-.09249,1.81288,1.03733,-.13579,1.76599,1.10735,-.07907,1.82678,1.043,-.10695,1.79525,1.10757,-.06566,2.18453,1.76666,.25439,2.20046,1.77652,.22313,1.99062,1.84803,-.62509,2.02634,1.82242,-.54582,1.9984,1.82266,-.63116,2.12025,1.33722,-.80219,1.83843,1.8417,-.69639,1.71535,1.76112,-.71279,1.73584,1.78436,-.70492,1.88939,1.85334,-.70135,2.07553,1.51678,-.85387,1.99775,1.39396,-.94597};
			return value;
		}
		private double[] getlmcun_Coord_7_35_point_2()
		{
			double[] value = {1.98554,1.4129,-.92362,2.04711,1.5234,-.84584,1.65273,1.53829,-.85537,1.65943,1.66475,-.77545,1.62027,1.53,-.8622,1.94353,1.60585,-.77407,2.00188,1.53273,-.82877,1.96554,1.53694,-.80542,1.98469,1.62563,-.78103,1.90661,1.58213,-.76823,1.85496,1.55015,-.7894,1.85519,1.6082,-.7473,1.89506,1.51249,-.81483,1.91791,1.5458,-.78655,1.84594,1.50495,-.82613,1.86276,1.50561,-.83041,1.80536,1.54717,-.8023,1.82853,1.51616,-.81814,1.67287,1.28202,-.02016,1.66341,1.36966,.07821,1.64368,1.40561,.03613,1.70548,1.2435,.00818,1.64731,1.438,.11848,1.64207,1.47164,.05703,1.99921,.98176,-.42153,1.88935,1.04357,-.36816,1.62292,1.49659,-.33326,1.65591,1.59729,-.28172,1.84333,1.87001,-.06192,1.92913,1.90695,-.06065,1.9105,1.93496,-.13183,1.83949,1.8843,-.14396,2.13663,1.65897,-.15911,1.86602,1.4586,-.88801,1.82988,1.46943,-.87082,1.72549,1.12656,-.72905,1.83496,1.07382,-.61489,1.73373,1.08865,-.59098,1.80587,1.1009,-.75518,1.77835,1.05198,-.38289,1.79143,1.05489,-.27172,1.94689,1.1079,-.78591,1.76877,1.82321,-.25464,1.8352,1.90047,-.2253,1.81633,1.93639,-.33439,1.76058,1.84984,-.37101,1.63923,1.26197,-.06915,1.61642,1.42399,-.01299,2.1748,1.35426,-.14518,2.16831,1.53685,-.19754,2.17545,1.47097,-.08939,2.19316,1.40242,-.2538,2.03111,1.86745,.09612,2.07005,1.79535,.18322,2.15521,1.83913,.17075,2.17905,1.72872,-.17304,2.17773,1.76596,-.1672,2.21899,1.7352,-.01732,2.21532,1.70102,.14809,2.21083,1.67405,.19851,1.89285,.96318,-.26841,2.03014,.92773,-.32767,1.92611,1.94148,-.13248,1.89148,1.96483,-.20222,1.59026,1.51769,-.01862,1.65239,1.14156,-.56205,1.79863,1.0248,-.22015,1.70886,1.092,-.17754,1.61494,1.21207,-.26819,1.67854,1.09309,-.18415,1.61581,1.25389,-.18427,1.62284,1.15198,-.339,1.66567,1.08543,-.36821,2.01602,.93055,-.24991,1.89178,.98638,-.18566,1.94783,1.83206,.1115,1.99143,1.75049,.17179,2.03899,1.58837,.18713,2.17281,1.54178,.1055,1.97449,1.60843,.21085,2.01597,1.67536,.24121,1.98389,1.47769,.13624,2.11052,1.32766,-.01124,2.12758,1.43146,.03747,1.97128,1.35868,.06062,2.08573,1.06402,-.13899,2.25359,1.05956,-.2324,2.22165,1.18524,-.14089,2.01969,1.2022,-.05692,2.11375,1.03573,-.55906,2.15816,.9315,-.34209,2.1373,.98291,-.44259,2.24143,1.19094,-.16131,2.27114,1.06311,-.25013,2.24243,1.18733,-.21471,1.88875,1.68632,-.72968,1.84411,1.69574,-.71665,1.9987,1.92444,-.51348,2.01571,1.99841,-.35537,2.04272,1.92952,-.38624};
			return value;
		}
		private double[] getlmcun_Coord_7_35_point_3()
		{
			double[] value = {1.98446,2.00224,-.48455,2.07813,1.64882,-.78021,2.0669,1.68341,-.68034,1.80137,1.13164,-.89696,1.62976,1.41854,-.90439,1.64094,1.40088,-.87714,1.60414,1.52245,-.85032,1.84449,1.98032,-.31465,1.80528,1.95935,-.47149,1.89574,2.01061,-.45794,1.9324,2.01644,-.32928,1.62013,1.57954,-.65168,1.57823,1.405,-.73116,1.87267,1.33745,-1.00122,1.87056,1.37027,-.97306,1.69815,1.44525,-.90895,1.76079,1.45889,-.89745,1.73382,1.40212,-.93905,1.69907,1.54545,-.84765,1.70414,1.64945,-.77026,1.81308,1.43026,-.91191,1.80248,1.3862,-.95621,1.6571,1.72872,-.57463,1.67214,1.76468,-.6405,1.70051,1.32827,-.96953,1.70588,1.31105,-.94372,1.68622,1.28277,-.92884,1.61685,1.29707,-.78729,1.62709,1.37212,-.85975,1.68854,1.20364,-.84113,1.78269,1.29856,-1.00276,2.03144,1.30736,-.95029,2.01472,1.37531,-.95132,2.07439,1.15866,-.78845,2.10965,1.48642,-.61959,2.12022,1.45988,-.56888,1.97392,1.92769,-.60264,1.9624,1.96332,-.59167,1.92281,2.01488,-.46641,1.9685,2.02131,-.33657,1.95102,1.99894,-.47394,1.98282,1.9957,-.34182,1.80084,1.67654,-.72672,1.81162,1.58867,-.77831,2.2596,1.23584,-.33522,2.15352,.94908,-.25147,2.0189,1.54507,.16487,1.61829,1.50418,.00377,1.67668,1.64498,.10223,1.60914,1.26643,-.09808,1.68946,1.72152,-.11663,1.85804,1.05036,-.51016,2.2347,1.72458,.13497,2.22361,1.67222,-.03521,2.17362,1.54819,.02768,2.18968,1.5403,.08719,2.14609,1.33092,-.09851,2.1333,1.45018,-.0314,2.13309,1.33413,-.02852,2.15115,1.43368,.01551,1.92959,1.62844,.22993,2.17948,1.82835,.16064,1.56625,1.33887,-.62718,1.61099,1.44632,-.42653,1.61639,1.51076,-.5371,1.70516,1.14485,-.71834,1.72355,1.1711,-.86688,1.8298,1.10589,-.06442,1.89504,.99697,-.16018,2.13602,1.72794,-.25702,2.18315,1.67991,-.1886,2.05606,1.98209,-.16591,2.07878,1.95362,-.17861,1.92539,1.79919,-.71368,1.96024,1.80766,-.71886,1.94778,1.78165,-.72255,2.09715,1.50654,-.65792,2.06774,1.7014,-.57438,1.7772,1.94383,-.57268,2.08743,1.74259,.25547,1.69046,1.36258,.09559,1.7338,1.24379,.0255,1.87765,1.5653,.20634,1.84417,1.57393,.21698,1.76332,1.70092,.11219,1.85312,1.77091,.11574,1.76269,1.71336,.0933,1.93138,1.97142,-.57666,2.11117,1.9506,-.18541,1.8953,1.98997,-.57606,1.86338,1.99044,-.56927,1.70985,1.35302,-.9714,1.78894,1.33321,-.99576,1.79503,1.19832,-.97977,1.74266,1.2363,-.95997,1.82559,1.94588,-.6883,2.10282,1.28438,-.84772,1.62482,1.21648,-.67642,1.76008,1.80329,-.08879,2.19465,1.26031,-.15791};
			return value;
		}
		private double[] getlmcun_Coord_7_35_point_4()
		{
			double[] value = {2.20872,1.27281,-.18005,1.70816,1.84061,-.6084,2.16649,1.25713,-.07774,1.99106,1.29252,.0094,2.18769,1.26338,-.09662,2.22642,1.32109,-.29391,2.1751,1.34593,-.52719,2.18389,1.37084,-.38869,2.20951,1.2884,-.43,2.15187,1.42378,-.48615,2.13741,1.38778,-.61764,1.70094,1.82113,-.52458,1.7528,1.89105,-.49903,1.71729,1.77253,-.40509,1.82615,1.51574,.18819,1.76009,1.53589,.2068,1.94316,1.5515,.18409,1.90488,1.49388,.1609,2.15122,1.29026,-.72083,2.13683,1.22958,-.74579,2.2321,1.17929,-.49657,2.17521,1.16798,-.62987,2.19338,1.22619,-.60629,2.21427,1.12138,-.51693,1.8306,1.96374,-.67407,1.64676,1.43159,-.91493,1.96092,1.86586,-.69341,1.94049,1.86509,-.70502,1.97752,1.81099,-.70671,1.87558,1.3136,-1.01009,2.02628,1.97747,-.14692,2.01944,2.00725,-.22591,1.98874,2.0033,-.20816,2.07065,1.96731,-.25146,2.03777,1.96914,-.23905,2.08611,1.71664,-.4622,2.10362,1.72939,-.34584,1.58566,1.43226,-.03841,1.69149,1.08754,-.37364,1.68541,1.41863,.12583,2.02336,.94271,-.22766,2.15899,.93768,-.27566,2.01062,1.71071,.24083,1.89984,1.65494,.22964,1.96232,1.43969,-.89429,1.867,1.41443,-.93644,2.05857,1.64985,-.79099,2.02975,1.64032,-.78633,1.91782,1.7365,-.72635,1.83386,1.76571,-.69988,1.92939,1.47635,-.85295,1.7949,1.4893,-.85979,1.74824,1.62672,-.77124,1.74864,1.55072,-.82306,1.86285,1.3796,.09085,1.7677,1.33551,.08585,1.87875,1.31454,.04833,1.75595,1.39538,.11728,1.59881,1.41894,-.1643,1.75478,1.0626,-.49294,1.70784,1.7321,-.21468,1.76578,1.81194,-.17458,1.96057,1.91942,-.06282,2.12657,1.88796,-.21697,2.13067,1.78523,-.24282,2.1584,1.44974,-.351,1.66894,1.62394,-.36198,1.66527,1.66565,-.4569,1.89152,1.6894,.16622,1.79147,1.22937,.02483,1.9072,1.21252,-.01707,1.95773,1.09107,-.1021,2.0856,1.91271,-.27982,2.06077,1.81513,-.43687,2.09417,1.80741,-.32337,1.72329,1.74527,-.30718,1.74609,1.72866,-.71846};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlnaviclr_Geo_6_40_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,21,22,23,-1,24,25,26,-1,27,28,19,-1,29,30,31,-1,32,33,7,-1,33,34,7,-1,35,36,24,-1,24,26,35,-1,6,32,7,-1,37,38,39,-1,39,27,37,-1,40,41,42,-1,40,42,43,-1,43,44,40,-1,45,46,47,-1,47,48,45,-1,49,33,50,-1,51,52,53,-1,51,54,52,-1,55,56,57,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,62,60,63,-1,65,66,67,-1,68,69,70,-1,70,71,68,-1,72,73,74,-1,74,75,72,-1,76,77,78,-1,77,79,78,-1,80,81,82,-1,81,83,82,-1,4,84,5,-1,85,86,87,-1,88,89,90,-1,66,65,91,-1,92,93,94,-1,92,94,95,-1,67,96,97,-1,67,66,96,-1,98,99,100,-1,101,102,103,-1,104,98,100,-1,104,105,98,-1,106,107,108,-1,109,110,111,-1,109,112,110,-1,111,113,114,-1,111,110,113,-1,115,116,117,-1,116,118,117,-1,107,102,101,-1,119,120,121,-1,121,122,119,-1,123,124,125,-1,124,126,125,-1,127,128,129,-1,128,130,129,-1,131,132,133,-1,134,135,136,-1,137,21,31,-1,21,20,31,-1,138,137,30,-1,137,31,30,-1,139,30,140,-1,141,142,143,-1,141,144,142,-1,141,145,144,-1,146,147,148,-1,146,149,147,-1,150,151,152,-1,153,154,155,-1,133,156,157,-1,156,158,157,-1,159,153,160,-1,153,155,160,-1,151,150,161,-1,158,156,162,-1,162,163,158,-1,164,151,161,-1,165,166,167,-1,168,169,170,-1,168,171,172,-1,171,173,172,-1,174,175,176,-1,175,177,176,-1,165,178,166,-1,165,179,178,-1,173,171,180,-1,181,145,182,-1,181,183,145,-1,184,185,186,-1,186,187,184,-1,188,167,189,-1,167,166,189,-1,190,191,192,-1,193,194,195,-1,196,197,198,-1,22,137,138,-1,138,199,22,-1,200,201,199,-1,199,138,200,-1,159,202,153,-1,121,203,204,-1,204,205,121,-1,206,207,208,-1,209,210,211,-1,209,212,210,-1,213,214,125,-1,215,216,127,-1,215,217,216,-1,218,132,219,-1,219,220,218,-1,221,222,223,-1,18,122,16,-1,119,224,225,-1,226,144,227,-1,226,142,144,-1,36,228,64,-1,229,230,231,-1,231,232,229,-1,233,234,235,-1,233,236,234,-1,237,238,94,-1,237,239,238,-1,240,241,242,-1,240,243,241,-1,244,245,181,-1,244,246,245,-1,247,248,249,-1,248,250,249,-1,165,167,194,-1,167,251,194,-1,252,188,253,-1,188,189,253,-1,251,169,254,-1,251,170,169,-1,255,256,257,-1,258,83,259,-1,259,260,258,-1,261,259,262,-1,262,263,261,-1,264,265,266,-1,267,268,255,-1,269,270,255,-1,146,255,271,-1,272,273,255,-1,274,275,255,-1,276,273,277,-1,278,279,280,-1,281,190,96,-1,281,282,190,-1,283,284,285,-1,284,88,285,-1,286,287,288,-1,91,289,66,-1,290,74,291,-1,263,187,186,-1,254,195,194,-1,194,251,254,-1,292,256,275,-1,292,293,256,-1,294,295,296,-1,296,276,294,-1,297,69,298,-1,297,70,69,-1,76,299,77,-1,247,193,176,-1,193,195,176,-1,196,250,197,-1,196,249,250,-1,300,301,302,-1,268,267,303,-1,303,304,268,-1,305,269,219,-1,306,146,271,-1,306,149,146,-1,142,307,308,-1,142,226,307,-1,156,309,310,-1,156,311,309,-1,242,312,313,-1,134,27,19,-1,38,314,39,-1,314,315,39,-1,314,316,315,-1,21,137,22,-1,317,318,50,-1,317,319,318,-1,54,320,321,-1,54,46,320,-1,322,24,36,-1,36,64,322,-1,323,265,324,-1,325,326,327,-1,325,328,326,-1,59,329,330,-1,59,331,329,-1,332,331,333,-1,265,334,206,-1,113,110,335,-1,110,207,335,-1,336,237,93,-1,336,337,237,-1,338,339,340,-1,92,17,93,-1,16,205,341,-1,341,17,16,-1,342,222,55,-1,342,223,222,-1,37,343,344,-1,343,345,344,-1,346,123,103,-1,346,216,123,-1,347,348,349,-1,348,117,349,-1,214,350,125,-1,214,351,350,-1,352,107,101,-1,352,108,107,-1,353,344,354,-1,344,345,354,-1,355,354,356,-1,356,357,355,-1,206,266,265,-1,256,255,275,-1,358,359,297,-1,359,70,297,-1,252,171,168,-1,360,351,13,-1,351,214,13,-1,115,348,11,-1,115,117,348,-1,361,209,211,-1,361,14,209,-1,124,217,235,-1,235,362,124,-1,102,346,103,-1,136,128,102,-1,128,346,102,-1,134,343,27,-1};
			return value;
		}
		private int[] getlnaviclr_Geo_6_40_coordIndex_2()
		{
			int[] value = {363,364,184,-1,364,365,184,-1,366,105,361,-1,366,98,105,-1,212,18,210,-1,367,112,0,-1,367,208,112,-1,56,368,369,-1,332,333,368,-1,370,371,325,-1,327,326,6,-1,318,49,50,-1,318,372,49,-1,373,25,52,-1,373,26,25,-1,321,320,372,-1,314,374,316,-1,314,375,374,-1,375,38,376,-1,375,314,38,-1,32,317,50,-1,29,315,377,-1,315,316,377,-1,19,28,20,-1,378,22,199,-1,243,135,241,-1,379,312,242,-1,242,241,379,-1,243,240,131,-1,218,156,133,-1,218,311,156,-1,156,310,162,-1,152,153,380,-1,380,150,152,-1,380,381,173,-1,382,383,384,-1,385,270,386,-1,269,268,304,-1,304,220,269,-1,387,21,379,-1,177,248,247,-1,247,176,177,-1,249,388,389,-1,249,196,388,-1,5,390,3,-1,258,391,392,-1,258,393,391,-1,78,391,394,-1,78,79,391,-1,42,244,395,-1,42,41,244,-1,44,47,51,-1,51,396,44,-1,183,294,397,-1,183,398,294,-1,399,296,400,-1,296,295,400,-1,257,401,402,-1,292,275,399,-1,184,187,363,-1,263,186,178,-1,178,261,263,-1,291,73,403,-1,291,74,73,-1,2,404,264,-1,2,405,404,-1,2,367,0,-1,232,406,229,-1,232,407,406,-1,283,285,282,-1,282,281,283,-1,363,67,408,-1,363,187,67,-1,402,382,257,-1,409,399,400,-1,273,274,255,-1,148,272,255,-1,270,271,255,-1,268,269,255,-1,257,267,255,-1,261,260,259,-1,392,82,83,-1,83,258,392,-1,410,411,412,-1,171,252,253,-1,167,188,251,-1,188,170,251,-1,193,249,389,-1,193,247,249,-1,172,173,383,-1,270,306,271,-1,270,385,306,-1,134,102,343,-1,93,237,94,-1,364,413,238,-1,238,239,364,-1,180,414,185,-1,185,415,180,-1,416,324,265,-1,417,418,324,-1,406,419,420,-1,420,229,406,-1,421,339,95,-1,339,338,95,-1,10,422,423,-1,10,104,422,-1,269,220,219,-1,218,133,132,-1,340,339,424,-1,425,426,427,-1,428,92,429,-1,428,17,92,-1,155,430,160,-1,431,378,199,-1,199,201,431,-1,31,20,28,-1,201,200,432,-1,432,433,201,-1,165,193,389,-1,165,194,193,-1,190,97,96,-1,89,88,434,-1,88,284,434,-1,18,17,428,-1,414,180,253,-1,180,171,253,-1,186,185,414,-1,165,389,179,-1,181,182,435,-1,154,153,152,-1,133,129,131,-1,133,157,129,-1,153,202,380,-1,255,146,148,-1,23,378,436,-1,23,22,378,-1,437,145,141,-1,143,308,436,-1,143,142,308,-1,200,138,139,-1,138,30,139,-1,438,181,435,-1,21,387,19,-1,102,134,136,-1,128,136,130,-1,120,119,225,-1,225,362,120,-1,16,122,205,-1,122,121,205,-1,116,115,423,-1,423,439,116,-1,56,55,222,-1,107,106,356,-1,101,350,352,-1,348,347,360,-1,347,351,360,-1,125,350,101,-1,1,434,419,-1,192,408,97,-1,408,67,97,-1,440,434,1,-1,1,0,440,-1,284,283,420,-1,283,441,420,-1,192,97,190,-1,421,442,339,-1,442,424,339,-1,285,90,443,-1,285,88,90,-1,89,444,90,-1,421,445,442,-1,85,99,86,-1,340,429,338,-1,340,427,429,-1,288,446,286,-1,64,63,322,-1,55,58,342,-1,55,57,58,-1,342,60,62,-1,342,58,60,-1,57,56,369,-1,64,228,62,-1,5,447,390,-1,35,318,319,-1,448,372,320,-1,317,32,326,-1,32,6,326,-1,50,33,32,-1,39,315,28,-1,28,27,39,-1,27,343,37,-1,21,23,379,-1,95,429,92,-1,95,338,429,-1,125,126,213,-1,361,105,12,-1,15,12,9,-1,325,327,370,-1,3,449,4,-1,299,450,77,-1,451,288,287,-1,451,231,288,-1,11,423,115,-1,11,10,423,-1,36,319,328,-1,35,319,36,-1,448,374,372,-1,374,448,452,-1,453,396,454,-1,453,455,396,-1,455,456,457,-1,455,453,456,-1,373,372,318,-1,321,372,373,-1,60,330,63,-1,330,60,59,-1,61,57,369,-1,57,61,58,-1,458,459,359,-1,458,460,459,-1,461,5,84,-1,461,462,5,-1,446,450,286,-1,450,446,463,-1,71,359,459,-1,71,70,359,-1,81,259,83,-1,280,259,81,-1,464,427,340,-1,464,465,427,-1,464,99,465,-1,86,99,464,-1,87,444,85,-1,444,87,90,-1,285,466,282,-1,285,443,466,-1,442,466,424,-1,442,191,466,-1,192,413,408,-1,192,445,413,-1,281,441,283,-1,281,289,441,-1,434,420,419,-1,434,284,420,-1,360,11,348,-1,11,360,9,-1,347,350,351,-1,350,347,352,-1,439,113,56,-1,114,113,439,-1};
			return value;
		}
		private int[] getlnaviclr_Geo_6_40_coordIndex_3()
		{
			int[] value = {356,467,357,-1,356,106,467,-1,109,0,112,-1,109,440,0,-1,56,116,439,-1,222,116,56,-1,103,125,101,-1,123,125,103,-1,215,158,233,-1,215,157,158,-1,236,160,430,-1,236,163,160,-1,135,19,387,-1,135,134,19,-1,435,468,438,-1,468,435,432,-1,431,436,378,-1,431,143,436,-1,189,178,186,-1,178,189,166,-1,469,245,470,-1,469,398,245,-1,412,254,169,-1,412,411,254,-1,164,471,154,-1,471,164,472,-1,341,93,17,-1,341,336,93,-1,196,393,388,-1,196,198,393,-1,197,447,473,-1,197,301,447,-1,198,391,393,-1,198,394,391,-1,182,432,435,-1,182,433,432,-1,236,203,234,-1,236,430,203,-1,427,428,429,-1,426,428,427,-1,425,465,366,-1,425,427,465,-1,100,85,474,-1,100,99,85,-1,210,425,211,-1,210,426,425,-1,475,340,424,-1,464,340,475,-1,238,445,421,-1,445,238,413,-1,1,406,2,-1,1,419,406,-1,417,416,476,-1,417,324,416,-1,287,477,290,-1,287,299,477,-1,127,346,128,-1,216,346,127,-1,164,478,472,-1,478,164,161,-1,150,415,479,-1,415,150,180,-1,408,364,363,-1,364,408,413,-1,102,345,343,-1,102,107,345,-1,386,480,313,-1,305,480,386,-1,436,481,23,-1,308,481,436,-1,306,482,307,-1,385,482,306,-1,483,300,302,-1,483,246,300,-1,293,412,401,-1,293,410,412,-1,82,463,446,-1,392,463,82,-1,383,402,172,-1,383,382,402,-1,397,145,183,-1,484,145,397,-1,277,272,485,-1,272,277,273,-1,175,295,469,-1,175,400,295,-1,71,476,486,-1,459,476,71,-1,487,230,229,-1,487,488,230,-1,441,229,420,-1,487,229,441,-1,444,434,440,-1,444,89,434,-1,406,405,2,-1,407,405,406,-1,71,489,68,-1,489,71,486,-1,476,404,486,-1,416,404,476,-1,403,68,489,-1,403,73,68,-1,451,403,407,-1,451,291,403,-1,80,488,81,-1,230,488,80,-1,179,388,260,-1,388,179,389,-1,485,148,147,-1,485,272,148,-1,274,399,275,-1,399,274,296,-1,172,401,412,-1,401,172,402,-1,410,292,490,-1,292,410,293,-1,490,399,409,-1,399,490,292,-1,174,400,175,-1,400,174,409,-1,298,454,297,-1,453,454,298,-1,455,44,396,-1,455,40,44,-1,43,395,491,-1,395,43,42,-1,484,144,145,-1,227,144,484,-1,395,181,438,-1,395,244,181,-1,40,457,41,-1,455,457,40,-1,76,477,299,-1,76,461,477,-1,473,78,394,-1,462,78,473,-1,463,391,79,-1,463,392,391,-1,75,492,72,-1,75,449,492,-1,41,390,300,-1,457,390,41,-1,449,493,4,-1,493,449,75,-1,470,248,177,-1,470,483,248,-1,379,481,312,-1,379,23,481,-1,385,313,482,-1,386,313,385,-1,220,311,218,-1,304,311,220,-1,303,384,309,-1,303,382,384,-1,381,309,384,-1,309,381,310,-1,384,173,381,-1,384,383,173,-1,202,381,380,-1,202,310,381,-1,131,480,132,-1,240,480,131,-1,387,241,135,-1,379,241,387,-1,49,376,33,-1,49,375,376,-1,45,452,448,-1,45,494,452,-1,139,494,495,-1,140,494,139,-1,452,316,374,-1,316,452,377,-1,375,372,374,-1,372,375,49,-1,358,52,25,-1,52,358,53,-1,318,26,373,-1,318,35,26,-1,359,25,458,-1,25,359,358,-1,329,496,330,-1,329,418,496,-1,325,62,228,-1,325,371,62,-1,265,332,334,-1,265,323,332,-1,369,333,61,-1,369,368,333,-1,335,56,113,-1,335,368,56,-1,266,208,367,-1,266,206,208,-1,264,367,2,-1,367,264,266,-1,478,497,337,-1,478,479,497,-1,120,203,121,-1,120,234,203,-1,119,209,224,-1,209,119,212,-1,364,497,365,-1,497,364,239,-1,191,445,192,-1,191,442,445,-1,90,475,443,-1,90,87,475,-1,474,104,100,-1,474,422,104,-1,62,223,342,-1,62,371,223,-1,224,14,213,-1,14,224,209,-1,13,9,360,-1,15,9,13,-1,34,353,498,-1,499,353,34,-1,370,6,8,-1,370,327,6,-1,221,500,222,-1,500,221,501,-1,8,355,501,-1,8,498,355,-1,460,476,459,-1,460,417,476,-1,501,357,500,-1,501,355,357,-1,370,501,221,-1,8,501,370,-1,7,498,8,-1,7,34,498,-1,354,498,353,-1,354,355,498,-1,344,499,37,-1,353,499,344,-1,356,345,107,-1,354,345,356,-1,352,349,108,-1,352,347,349,-1,371,221,223,-1,221,371,370,-1,87,464,475,-1,86,464,87,-1,440,85,444,-1,109,85,440,-1,443,424,466,-1,443,475,424,-1,235,120,362,-1,120,235,234,-1,205,471,341,-1,205,204,471,-1};
			return value;
		}
		private int[] getlnaviclr_Geo_6_40_coordIndex_4()
		{
			int[] value = {122,212,119,-1,122,18,212,-1,337,239,237,-1,337,497,239,-1,472,337,336,-1,337,472,478,-1,479,365,497,-1,479,415,365,-1,264,416,265,-1,264,404,416,-1,334,207,206,-1,207,334,335,-1,368,334,332,-1,368,335,334,-1,61,331,59,-1,61,333,331,-1,331,323,329,-1,323,331,332,-1,328,228,36,-1,325,228,328,-1,418,323,324,-1,323,418,329,-1,496,417,460,-1,496,418,417,-1,24,458,25,-1,458,24,322,-1,51,46,54,-1,51,47,46,-1,494,377,452,-1,377,494,140,-1,48,494,45,-1,48,495,494,-1,140,29,377,-1,140,30,29,-1,304,309,311,-1,304,303,309,-1,305,132,480,-1,219,132,305,-1,149,307,226,-1,306,307,149,-1,312,482,313,-1,481,482,312,-1,301,250,302,-1,250,301,197,-1,245,483,470,-1,246,483,245,-1,456,449,3,-1,492,449,456,-1,244,300,246,-1,41,300,244,-1,462,447,5,-1,462,473,447,-1,84,477,461,-1,477,84,502,-1,492,453,298,-1,492,456,453,-1,182,437,433,-1,182,145,437,-1,491,438,468,-1,438,491,395,-1,43,495,48,-1,43,491,495,-1,53,297,454,-1,358,297,53,-1,295,398,469,-1,294,398,295,-1,503,409,174,-1,503,490,409,-1,411,490,503,-1,411,410,490,-1,274,276,296,-1,273,276,274,-1,484,147,227,-1,484,485,147,-1,488,280,81,-1,280,488,278,-1,290,451,287,-1,290,291,451,-1,407,489,405,-1,407,403,489,-1,298,72,492,-1,69,72,298,-1,486,405,489,-1,405,486,404,-1,289,487,441,-1,487,289,91,-1,91,488,487,-1,91,278,488,-1,288,230,80,-1,288,231,230,-1,65,278,91,-1,65,279,278,-1,276,397,294,-1,276,277,397,-1,260,178,179,-1,260,261,178,-1,277,484,397,-1,485,484,277,-1,267,382,303,-1,267,257,382,-1,187,262,67,-1,187,263,262,-1,286,299,287,-1,450,299,286,-1,401,256,293,-1,256,401,257,-1,483,250,248,-1,483,302,250,-1,481,307,482,-1,481,308,307,-1,305,270,269,-1,305,386,270,-1,313,240,242,-1,480,240,313,-1,161,479,478,-1,479,161,150,-1,154,204,155,-1,471,204,154,-1,235,215,233,-1,217,215,235,-1,232,451,407,-1,232,231,451,-1,290,502,74,-1,290,477,502,-1,227,149,226,-1,149,227,147,-1,495,468,139,-1,495,491,468,-1,213,225,224,-1,213,126,225,-1,124,216,217,-1,124,123,216,-1,13,213,14,-1,213,13,214,-1,211,366,361,-1,211,425,366,-1,426,18,428,-1,210,18,426,-1,208,110,112,-1,207,110,208,-1,98,465,99,-1,98,366,465,-1,310,159,162,-1,310,202,159,-1,431,433,437,-1,433,431,201,-1,473,198,197,-1,198,473,394,-1,300,447,301,-1,300,390,447,-1,388,258,260,-1,388,393,258,-1,471,336,341,-1,471,472,336,-1,168,188,252,-1,168,170,188,-1,184,415,185,-1,184,365,415,-1,411,195,254,-1,503,195,411,-1,169,172,412,-1,168,172,169,-1,253,186,414,-1,186,253,189,-1,398,181,245,-1,398,183,181,-1,175,470,177,-1,175,469,470,-1,503,176,195,-1,176,503,174,-1,154,151,164,-1,152,151,154,-1,162,160,163,-1,162,159,160,-1,380,180,150,-1,380,173,180,-1,143,437,141,-1,437,143,431,-1,468,200,139,-1,200,468,432,-1,136,243,130,-1,243,136,135,-1,130,131,129,-1,243,131,130,-1,233,163,236,-1,233,158,163,-1,129,215,127,-1,215,129,157,-1,225,124,362,-1,124,225,126,-1,357,118,500,-1,118,357,467,-1,118,222,500,-1,116,222,118,-1,106,349,467,-1,106,108,349,-1,467,117,118,-1,467,349,117,-1,423,114,439,-1,422,114,423,-1,111,422,474,-1,111,114,422,-1,12,104,10,-1,12,105,104,-1,96,289,281,-1,96,66,289,-1,474,109,111,-1,474,85,109,-1,282,191,190,-1,191,282,466,-1,203,155,204,-1,430,155,203,-1,493,74,502,-1,75,74,493,-1,280,262,259,-1,280,279,262,-1,80,446,288,-1,80,82,446,-1,79,450,463,-1,79,77,450,-1,78,461,76,-1,461,78,462,-1,4,502,84,-1,502,4,493,-1,69,73,72,-1,69,68,73,-1,279,67,262,-1,279,65,67,-1,496,63,330,-1,496,322,63,-1,322,460,458,-1,322,496,460,-1,52,321,373,-1,54,321,52,-1,454,51,53,-1,454,396,51,-1,457,3,390,-1,457,456,3,-1,46,448,320,-1,45,448,46,-1,44,48,47,-1,44,43,48,-1,29,28,315,-1,31,28,29,-1,499,33,376,-1,34,33,499,-1,376,37,499,-1,376,38,37,-1,317,328,319,-1,317,326,328,-1};
			return value;
		}
		private int[] getlnaviclr_Geo_6_40_coordIndex_5()
		{
			int[] value = {421,94,238,-1,421,95,94,-1,12,14,361,-1,14,12,15,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlnaviclr_Coord_7_40_point_1()
		{
			double[] value = {2.20212,1.5382,-.90956,2.2132,1.6703,-.85899,2.14178,1.67348,-.80687,2.20145,2.2104,-.84069,2.31264,2.22972,-.79869,2.33457,2.23632,-.81162,1.514,1.37444,-1.21574,1.51783,1.36128,-1.23143,1.56768,1.29842,-1.24418,1.86339,1.39357,-1.27196,1.9221,1.38452,-1.18293,1.83369,1.38934,-1.24717,1.95273,1.38276,-1.22338,1.85274,1.39332,-1.30955,1.92247,1.37355,-1.35383,1.87808,1.39055,-1.28791,2.23121,1.26187,-1.5908,2.26856,1.23581,-1.57432,2.1858,1.26376,-1.52033,1.56441,1.76866,-1.59812,1.58714,1.82037,-1.53482,1.60414,1.82497,-1.53936,1.66338,1.87187,-1.43494,1.68406,1.86182,-1.4529,1.58352,1.65482,-.87709,1.68096,1.83462,-.76019,1.58258,1.66715,-.89901,1.52638,1.69188,-1.61554,1.5556,1.80775,-1.51017,1.61316,1.87602,-1.40544,1.69456,1.9682,-1.25928,1.61479,1.87722,-1.43123,1.50478,1.38746,-1.2346,1.49103,1.43202,-1.32809,1.49555,1.41725,-1.34599,1.51545,1.56319,-.99523,1.51774,1.54451,-.98268,1.49241,1.53465,-1.55143,1.48987,1.54967,-1.53638,1.51618,1.68908,-1.59694,1.98632,2.12732,-.92918,2.09903,2.19296,-.96205,1.98144,2.13621,-.96417,1.87011,2.0679,-.96445,1.87713,2.06493,-.91674,1.74172,1.90142,-1.01597,1.73089,1.89437,-.97285,1.79181,1.98463,-.93877,1.79261,1.98964,-.98696,1.52909,1.50922,-1.25553,1.51344,1.47848,-1.21507,1.77131,1.99585,-.86369,1.68057,1.88842,-.85773,1.77133,1.98816,-.80761,1.69604,1.89949,-.9117,1.8177,1.32893,-1.13697,1.89698,1.34108,-1.12974,1.8247,1.33094,-1.11809,1.72567,1.33349,-1.093,1.63562,1.36343,-1.00592,1.62796,1.36753,-1.02881,1.73034,1.32715,-1.07179,1.62076,1.36552,-1.04845,1.58636,1.51872,-.91443,1.5706,1.52202,-.9272,2.65506,1.68603,-1.17185,2.57497,1.60721,-1.15615,2.65839,1.67725,-1.19435,2.05985,2.0154,-.71315,2.04942,2.02941,-.70609,1.92235,1.97229,-.69304,1.94236,1.94324,-.69098,2.13605,2.07777,-.72506,2.14106,2.05784,-.73014,2.23667,2.15249,-.75607,2.22608,2.1622,-.75894,2.49131,2.13762,-.82824,2.52382,2.09109,-.8354,2.49452,2.14695,-.83814,2.52998,2.09417,-.85083,2.55338,1.97126,-.90622,2.61966,1.93588,-.9847,2.55641,1.98743,-.90885,2.62201,1.95095,-.99141,2.32951,2.22812,-.80073,2.13696,1.44429,-1.03692,2.17237,1.42461,-1.10866,2.18904,1.45848,-1.08688,2.29548,1.62055,-.97642,2.22389,1.63829,-.9255,2.25151,1.55869,-1.00979,2.5734,1.68443,-1.10821,2.29021,1.23692,-1.54243,2.30986,1.2459,-1.58294,2.30966,1.24551,-1.54083,2.29632,1.2583,-1.48814,2.57241,1.59704,-1.16821,2.6202,1.64837,-1.19487,2.07972,1.38844,-1.15505,2.14772,1.40682,-1.12141};
			return value;
		}
		private double[] getlnaviclr_Coord_7_40_point_2()
		{
			double[] value = {2.07654,1.39495,-1.13493,1.67393,1.54139,-1.57224,1.62052,1.61865,-1.63796,1.69185,1.55838,-1.57755,1.99326,1.38239,-1.15842,1.99512,1.37893,-1.20082,1.66754,1.45228,-1.49452,1.65176,1.52689,-1.57106,1.67973,1.47744,-1.47225,2.13748,1.42746,-1.01366,2.04723,1.38314,-1.06477,2.05305,1.39169,-1.0766,2.12739,1.42662,-1.00258,1.98086,1.36664,-1.09693,1.98681,1.3729,-1.11141,1.81065,1.37754,-1.22621,1.80318,1.33519,-1.21736,1.769,1.38016,-1.27873,1.76653,1.33973,-1.29076,2.09106,1.33779,-1.52016,2.0976,1.36928,-1.53983,2.17277,1.32315,-1.58731,2.17387,1.2877,-1.55907,1.80591,1.50505,-1.52132,1.90425,1.4664,-1.51693,1.78908,1.48199,-1.49817,1.8881,1.43347,-1.49771,1.83088,1.56242,-1.53671,1.70903,1.60193,-1.59703,1.83874,1.57488,-1.5591,1.71158,1.62526,-1.60702,1.83548,1.59411,-1.5579,1.93793,1.58394,-1.44429,1.96077,1.54492,-1.53774,1.5688,1.68465,-1.64591,1.59915,1.69497,-1.63951,1.59618,1.66792,-1.64871,1.64621,1.88389,-1.43154,1.71541,1.97297,-1.27654,1.74063,2.01714,-1.1702,1.70971,1.96614,-1.1991,1.84749,2.0698,-1.20142,1.80741,1.98431,-1.25941,1.79482,1.99467,-1.26267,1.85823,2.06361,-1.20684,1.93609,2.1397,-1.16688,2.08724,1.81369,-1.19613,2.0172,1.91996,-1.17707,2.09299,1.83738,-1.19285,1.98093,1.87171,-1.19768,2.40068,1.46583,-1.63932,2.36205,1.39724,-1.71518,2.33642,1.41563,-1.72503,2.30489,1.42598,-1.7132,2.31348,1.38542,-1.72716,2.28414,1.40617,-1.71428,2.0563,1.5066,-1.55728,1.94772,1.53537,-1.54647,2.05092,1.49618,-1.56019,2.21476,1.46258,-1.6597,2.20567,1.45082,-1.66602,2.36195,1.37384,-1.70264,2.15056,1.48462,-1.60293,2.14069,1.47218,-1.60977,2.35242,1.3568,-1.7142,2.66844,1.96948,-1.23179,2.65813,1.88489,-1.26031,2.63232,1.88397,-1.25733,2.47504,1.67291,-1.44664,2.5342,1.81625,-1.36105,2.54369,1.80481,-1.34657,2.46141,1.58859,-1.5357,2.45938,1.6768,-1.4496,2.44322,1.59018,-1.553,2.50832,2.17439,-1.20982,2.46478,2.24756,-1.16866,2.52133,2.17849,-1.20429,2.47302,2.25316,-1.1602,2.67413,1.87958,-1.25125,2.67908,1.95955,-1.21291,2.46665,1.57122,-1.55639,2.10301,2.23343,-1.09642,1.93148,2.15239,-1.14349,2.11017,2.22358,-1.10986,2.55253,1.59332,-1.35061,2.5535,1.6154,-1.3985,2.6325,1.74829,-1.29916,2.65054,1.70506,-1.24405,2.56665,1.77699,-1.31149,2.61618,1.75744,-1.3101,2.54031,1.61071,-1.20352,2.47063,1.5835,-1.22198,2.5151,1.55727,-1.24154,2.61526,2.02557,-1.24566,2.61647,1.98999,-1.2612,2.58213,2.00651,-1.31011,2.54178,2.15687,-1.02633,2.43479,2.2207,-.95813,2.53534,2.15078,-.9931,1.72784,1.9392,-1.30164};
			return value;
		}
		private double[] getlnaviclr_Coord_7_40_point_3()
		{
			double[] value = {1.76203,2.03252,-1.19214,1.77543,2.00766,-1.20038,2.26902,1.44783,-1.64657,2.18442,1.37776,-1.6081,2.26251,1.33663,-1.6866,2.24607,1.27285,-1.62134,1.98783,1.47196,-.90245,2.01076,1.40805,-.98949,2.06829,1.44179,-.95668,2.01078,1.34768,-1.40735,2.12615,1.29348,-1.42415,2.07264,1.32241,-1.35643,2.11091,1.31046,-1.46583,1.88396,1.39645,-1.43373,1.81947,1.42215,-1.40008,1.94175,1.52438,-1.52228,1.82271,1.53766,-1.52811,1.92072,1.49575,-1.52043,2.00889,1.5473,-1.45253,2.01228,1.64703,-1.32001,2.06597,1.6269,-1.3365,1.6749,1.27835,-1.20141,1.78592,1.31949,-1.20998,1.70036,1.31263,-1.14599,1.98027,1.37375,-1.47456,1.97648,1.3849,-1.49716,1.84982,1.96204,-1.2442,1.90274,2.0202,-1.21147,1.55143,1.44283,-1.00133,2.38656,1.73721,-.93481,2.49014,1.87724,-.92246,2.41851,1.92007,-.8089,2.2828,1.78914,-.83245,2.04667,1.47688,-1.52847,2.11713,1.41091,-1.55766,2.0173,1.44686,-1.53098,2.13798,1.44482,-1.57389,2.33006,1.26456,-1.57424,2.36887,1.34133,-1.39974,2.37924,1.36261,-1.4636,1.80571,1.6344,-1.53663,1.67402,1.70696,-1.56673,1.74532,1.70726,-1.484,1.71068,1.63673,-1.60436,2.10405,2.21463,-1.0622,2.22489,2.28648,-1.11407,2.21902,2.25879,-1.05112,2.52172,2.15959,-1.14637,2.45041,2.23481,-1.08421,2.5463,2.15959,-1.08645,2.44397,2.23705,-1.02645,2.5881,1.88772,-1.29634,2.49506,1.64519,-1.42011,2.54563,1.63539,-1.42741,2.57504,1.92329,-1.34951,2.14852,1.79357,-1.21258,2.22891,1.79073,-1.22214,2.22723,1.76833,-1.23343,2.63427,1.99224,-1.01033,2.6982,1.86875,-1.12079,2.69393,1.93382,-1.14798,2.6937,1.87329,-1.18173,2.68711,1.74225,-1.17883,2.66736,1.73997,-1.23569,2.02377,1.62181,-.8152,1.86672,1.55494,-.80113,2.0053,1.5323,-.86314,2.19373,1.73245,-1.24497,2.15815,1.721,-1.24591,2.12512,1.73898,-1.23725,2.09629,1.75821,-1.22392,2.08172,1.78983,-1.20003,2.11462,1.85055,-1.18831,2.13643,1.86357,-1.18433,2.17451,1.85445,-1.1884,2.22458,1.81168,-1.21127,2.16784,1.96751,-1.14544,2.11894,1.96619,-1.15222,2.63625,1.77563,-1.10385,2.68211,1.73859,-1.166,2.69215,1.85936,-1.11134,2.51908,1.58988,-1.13827,2.48168,1.61005,-1.16416,2.41352,1.59541,-1.06073,2.32051,1.622,-.9696,2.38464,1.59901,-1.07526,2.49446,2.00347,-.82306,2.42661,2.04742,-.79434,2.48291,1.98031,-.81703,2.52703,1.5997,-1.12663,2.34059,2.09951,-.77055,2.2962,2.04966,-.75808,2.34804,1.85163,-1.21907,2.35763,1.8173,-1.24563,2.20378,2.14525,-1.12122,2.30156,2.14115,-1.13022,2.2187,1.95364,-1.14376,1.89692,2.00468,-.7039,2.0153,2.06748,-.73496,2.46313,2.09446,-.80253};
			return value;
		}
		private double[] getlnaviclr_Coord_7_40_point_4()
		{
			double[] value = {2.2102,2.24247,-.96052,2.35542,2.2581,-.9408,2.35666,2.27137,-.99713,2.2303,1.62674,-1.33812,2.12947,1.61684,-1.3453,1.97516,1.68103,-1.29972,1.94829,1.82212,-1.22277,1.81804,1.88163,-1.28322,1.76694,1.91015,-1.32119,2.24019,1.51522,-1.47828,2.24837,1.47258,-1.56078,2.08756,1.52853,-1.4697,1.73074,1.75726,-1.45506,1.82754,1.71219,-1.37229,1.51354,1.62492,-1.43186,1.54852,1.79614,-1.49146,1.55847,1.70079,-1.36547,1.48305,1.43808,-1.18679,1.53457,1.57778,-1.10596,1.49968,1.48544,-1.10356,1.63558,1.73317,-1.06589,1.62043,1.72393,-1.03058,1.59438,1.63609,-.84723,1.76239,1.51675,-.85029,1.77907,1.61975,-.76544,1.5311,1.3909,-1.09729,1.48318,1.41999,-1.17289,1.51971,1.3798,-1.16643,1.50054,1.46392,-1.09482,1.65602,1.50699,-.87045,1.59587,1.50373,-.89756,1.69856,1.38751,-.97505,1.81647,1.41991,-.93881,1.77038,1.34974,-1.02572,1.91599,1.42411,-.92818,1.95539,1.37358,-1.02278,2.3249,1.26464,-1.64251,2.34606,1.30395,-1.62463,2.27692,1.30579,-1.40236,2.31323,1.35875,-1.34877,2.2437,1.36258,-1.29659,2.28664,1.2524,-1.63881,1.71859,1.3271,-1.11252,1.53391,1.62833,-1.63657,1.50249,1.51915,-1.56137,1.57933,1.51743,-1.57235,1.70562,1.57789,-1.58699,1.74267,1.44958,-1.38049,1.79378,1.39875,-1.28336,1.71676,1.4309,-1.38816,1.73448,1.48505,-1.46791,1.77645,1.45123,-1.37825,1.71372,1.48526,-1.46652,1.51199,1.46347,-1.47344,1.59643,1.4337,-1.49228,1.61309,1.35899,-1.421,1.65454,1.444,-1.49788,1.68773,1.38425,-1.4193,1.79438,1.94387,-.70786,1.80333,1.90536,-.68083,1.82036,1.39885,-1.29529,2.01692,1.35635,-1.26976,1.99755,1.42262,-1.51814,2.55154,1.57125,-1.30272,2.46241,1.48084,-1.37437,2.4739,1.50387,-1.44009,2.09161,1.35211,-1.22783,2.12162,1.53978,-.89743,1.87116,1.35847,-1.03424,1.83323,1.32297,-1.09868,1.58149,1.30934,-1.16105,1.60356,1.34148,-1.10678,1.56397,1.62566,-1.13131,1.60344,1.70672,-.982,1.56824,1.64785,-1.25502,1.53534,1.54853,-1.33899,1.48919,1.49614,-1.42938,1.61206,1.82212,-1.2819,1.73785,1.92394,-1.30915,1.66585,1.78938,-1.52891,2.39244,1.49284,-1.62555,2.37142,1.51661,-1.55784,2.29904,1.6739,-1.32273,2.40601,1.61453,-1.45843,2.36347,1.57118,-1.46052,1.94169,1.77198,-1.24903,1.95071,1.72106,-1.2731,1.59932,1.78209,-1.58807,2.66232,2.027,-1.1074,2.65543,2.02716,-1.19196,2.2019,2.22167,-.87883,2.58203,2.06034,-.9185,2.57506,2.01997,-.91383,2.63209,2.04489,-1.01876,2.51726,2.13382,-.90016,1.95689,2.16952,-1.05329,1.87655,2.06261,-.85194,2.1244,2.13337,-1.13281,2.22519,2.27742,-1.12564,2.27918,1.91606,-1.17293};
			return value;
		}
		private double[] getlnaviclr_Coord_7_40_point_5()
		{
			double[] value = {2.38691,2.09317,-1.15424,2.3579,1.78031,-1.27186,2.33849,1.71831,-1.30858,2.18654,1.95776,-.74685,2.02893,1.75551,-.74843,2.13494,1.79313,-.77018,2.23057,1.73885,-.84165,2.22273,1.85276,-.78895,2.52432,1.55673,-1.25187,2.42146,2.05886,-1.18525,2.51617,1.87989,-1.32253,2.55915,1.92704,-1.34898,2.52129,1.83005,-1.35748,2.43218,1.46891,-1.30073,2.55386,1.61942,-1.42413,2.47179,1.53649,-1.49892,1.88584,1.70169,-.74054,1.73935,1.70433,-.72985,1.66679,1.61062,-.80196,2.22567,1.68396,-.86185,2.32926,1.63325,-.96471,2.35464,1.34049,-1.3857,1.9907,1.39118,-1.12378,1.91422,1.37704,-1.15656,2.35953,1.4882,-1.25223,2.13672,1.31884,-1.32885,2.15912,1.30315,-1.37088,2.1871,1.32245,-1.31845,2.2203,1.26389,-1.47376,2.23828,1.2702,-1.45189,2.20332,1.41713,-1.62683,1.7849,2.00045,-1.2302,1.81402,2.09079,-1.16102,1.82702,2.07505,-1.16006,2.22355,1.66086,-.88423,1.92185,2.17264,-1.14661,1.75186,1.92634,-1.33065,1.84041,2.07081,-1.18612,1.92623,2.18605,-1.11825,1.90935,1.35136,-1.14426,2.21239,1.53812,-.91968,2.42146,1.60439,-1.05375,2.38539,1.48926,-1.27895,2.33914,1.56826,-1.09938,2.21389,1.55633,-.95128,2.42277,1.46954,-1.29046,2.5046,2.00549,-.84687,2.34242,2.23282,-.85306,1.63971,1.74039,-1.08877,2.20642,2.19047,-.7839,2.5275,2.05017,-.83016,2.36583,1.975,-.78313,1.6384,1.77131,-1.17388,1.99466,2.10059,-.80568,1.88114,2.04844,-.79211,1.98744,2.11668,-.86309,2.10292,2.16549,-.83169,2.09768,2.18004,-.88708,1.68377,1.79797,-.73064,1.81297,1.87397,-.67419,1.69525,1.76944,-.72178,2.41974,2.18248,-.80973,2.42438,2.1904,-.8203,2.53403,2.04358,-.85393,2.20032,1.39831,-1.18253,2.15312,1.36628,-1.20105,2.44155,1.5875,-1.19167,1.70627,1.4012,-1.41756,1.80704,2.09431,-1.13056,2.35023,2.31045,-1.13621,2.35307,2.3175,-1.12671,2.29855,1.31941,-1.69664,2.33969,1.31521,-1.6883,2.42285,2.1893,-.87512,2.06483,1.40904,-1.08631,2.25639,1.47695,-1.15102,1.84127,1.7962,-.68752,2.39536,2.14135,-.78425,2.3578,1.34287,-1.67342,2.40058,1.43667,-1.58582,1.88205,1.64343,-1.4071,1.73459,1.83994,-1.40028,1.81148,1.80436,-1.33134,2.34773,2.2781,-1.05403,1.98381,2.07714,-1.18146,2.0558,1.94426,-1.16511,1.99187,1.86083,-.7042,2.46844,1.70844,-1.02344,2.5496,1.83705,-.98962,2.10929,1.89875,-.73132,2.49293,1.93684,-1.26886,1.84267,2.07932,-1.04683,2.11813,2.13862,-.76185,2.29481,2.20518,-.78553,1.73662,1.93184,-1.08557,1.78696,2.00641,-1.05553,1.6155,1.62361,-.82591,2.38898,1.39378,-1.52513,1.53924,1.36682,-1.37501,1.49197,1.4761,-1.43948};
			return value;
		}
		private double[] getlnaviclr_Coord_7_40_point_6()
		{
			double[] value = {1.74904,1.31646,-1.28214,1.6476,1.27926,-1.27542,2.30709,2.1953,-.78142,2.5659,2.0061,-1.3117};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfmphal_Geo_6_45_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,13,16,14,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,21,24,22,-1,25,26,27,-1,28,29,30,-1,28,31,29,-1,32,33,34,-1,33,35,34,-1,36,37,38,-1,38,39,36,-1,40,25,41,-1,25,42,41,-1,43,42,4,-1,42,44,4,-1,15,45,46,-1,47,17,19,-1,46,29,48,-1,29,49,48,-1,50,51,52,-1,53,54,55,-1,54,56,55,-1,57,9,50,-1,58,16,59,-1,58,14,16,-1,60,61,62,-1,63,13,64,-1,63,10,13,-1,65,66,67,-1,68,69,1,-1,1,3,68,-1,70,71,72,-1,73,74,75,-1,38,76,39,-1,76,77,39,-1,78,79,38,-1,79,76,38,-1,80,61,60,-1,80,8,61,-1,81,82,83,-1,83,84,81,-1,0,85,86,-1,85,87,86,-1,88,89,90,-1,88,91,89,-1,19,21,47,-1,92,93,28,-1,94,95,96,-1,15,46,48,-1,97,31,55,-1,55,56,97,-1,10,63,11,-1,98,25,99,-1,98,26,25,-1,89,100,90,-1,101,102,103,-1,66,65,104,-1,9,57,7,-1,87,85,105,-1,106,102,107,-1,106,108,102,-1,81,109,110,-1,81,84,109,-1,51,50,9,-1,111,112,113,-1,111,114,112,-1,115,74,116,-1,117,118,70,-1,119,120,121,-1,122,123,114,-1,114,111,122,-1,124,125,69,-1,61,126,127,-1,127,62,61,-1,128,129,130,-1,128,131,129,-1,132,59,16,-1,132,133,59,-1,48,64,15,-1,64,13,15,-1,60,62,5,-1,87,105,6,-1,134,24,128,-1,134,22,24,-1,135,136,58,-1,135,27,136,-1,63,20,11,-1,63,137,20,-1,106,138,139,-1,106,140,138,-1,90,47,88,-1,28,30,92,-1,96,141,94,-1,69,125,1,-1,12,132,10,-1,41,42,43,-1,142,25,40,-1,68,143,144,-1,68,145,143,-1,146,124,69,-1,147,148,149,-1,16,10,132,-1,16,13,10,-1,15,14,45,-1,104,150,70,-1,150,71,70,-1,118,104,70,-1,118,66,104,-1,2,1,151,-1,1,125,151,-1,103,151,101,-1,152,150,153,-1,71,150,152,-1,73,154,83,-1,73,155,154,-1,116,156,146,-1,116,157,156,-1,125,101,151,-1,124,101,125,-1,158,127,122,-1,158,86,127,-1,7,123,126,-1,123,7,119,-1,74,83,82,-1,74,73,83,-1,57,119,7,-1,57,120,119,-1,159,33,32,-1,159,160,33,-1,161,33,160,-1,162,33,161,-1,91,12,89,-1,91,163,12,-1,17,11,20,-1,11,17,100,-1,55,164,53,-1,164,55,93,-1,95,45,136,-1,94,45,95,-1,94,46,45,-1,46,94,141,-1,145,3,158,-1,3,145,68,-1,144,165,75,-1,144,143,165,-1,165,152,155,-1,152,165,166,-1,113,145,111,-1,113,143,145,-1,167,168,78,-1,167,169,168,-1,170,171,172,-1,170,173,171,-1,149,138,147,-1,149,174,138,-1,99,142,139,-1,99,25,142,-1,160,175,176,-1,175,160,159,-1,2,103,177,-1,2,151,103,-1,178,41,179,-1,178,40,41,-1,129,137,180,-1,131,137,129,-1,31,49,29,-1,97,49,31,-1,47,100,17,-1,100,47,90,-1,47,181,88,-1,47,182,181,-1,52,39,77,-1,39,52,34,-1,141,92,30,-1,96,92,141,-1,140,107,183,-1,107,140,106,-1,99,184,98,-1,99,174,184,-1,64,137,63,-1,64,180,137,-1,26,96,95,-1,26,98,96,-1,135,59,185,-1,135,58,59,-1,163,186,133,-1,161,186,163,-1,23,47,21,-1,23,182,47,-1,128,187,134,-1,187,128,130,-1,188,83,154,-1,84,83,188,-1,109,172,171,-1,109,189,172,-1,56,129,97,-1,56,130,129,-1,186,44,185,-1,186,176,44,-1,134,170,169,-1,134,187,170,-1,188,190,189,-1,191,190,188,-1,2,85,0,-1,2,177,85,-1,179,43,105,-1,41,43,179,-1,123,121,114,-1,121,123,119,-1,118,121,120,-1,118,117,121,-1,115,146,69,-1,146,115,116,-1,75,115,144,-1,74,115,75,-1,114,117,112,-1,114,121,117,-1,113,72,166,-1,113,112,72,-1,51,34,52,-1,34,51,32,-1,78,190,79,-1,78,168,190,-1,110,171,147,-1,109,171,110,-1,147,140,110,-1,138,140,147,-1,108,40,178,-1,142,40,108,-1,108,139,142,-1,139,108,106,-1,4,105,43,-1,4,6,105,-1,57,67,66,-1,57,50,67,-1,104,192,150,-1,65,192,104,-1,156,102,101,-1,107,102,156,-1,8,126,61,-1,7,126,8,-1,54,148,173,-1,54,53,148,-1};
			return value;
		}
		private int[] getlfmphal_Geo_6_45_coordIndex_2()
		{
			int[] value = {161,176,186,-1,176,161,160,-1,14,136,45,-1,136,14,58,-1,128,18,131,-1,24,18,128,-1,23,36,182,-1,23,37,36,-1,12,133,132,-1,133,12,163,-1,25,135,42,-1,27,135,25,-1,174,164,184,-1,164,174,149,-1,22,169,167,-1,22,134,169,-1,33,181,35,-1,162,181,33,-1,86,62,127,-1,86,87,62,-1,82,183,157,-1,81,183,82,-1,150,191,153,-1,150,192,191,-1,60,159,80,-1,60,175,159,-1,102,178,103,-1,178,102,108,-1,183,110,140,-1,183,81,110,-1,79,191,192,-1,79,190,191,-1,76,192,65,-1,76,79,192,-1,67,76,65,-1,76,67,77,-1,112,70,72,-1,70,112,117,-1,144,69,68,-1,69,144,115,-1,166,71,152,-1,166,72,71,-1,105,177,179,-1,105,85,177,-1,188,153,191,-1,153,188,154,-1,189,168,172,-1,190,168,189,-1,175,5,4,-1,175,60,5,-1,42,185,44,-1,135,185,42,-1,173,187,54,-1,173,170,187,-1,189,84,188,-1,109,84,189,-1,54,130,56,-1,54,187,130,-1,88,162,91,-1,181,162,88,-1,133,185,59,-1,186,185,133,-1,184,93,92,-1,184,164,93,-1,180,48,49,-1,48,180,64,-1,98,92,96,-1,98,184,92,-1,107,157,183,-1,156,157,107,-1,52,67,50,-1,52,77,67,-1,35,182,36,-1,181,182,35,-1,97,180,49,-1,129,180,97,-1,137,18,20,-1,18,137,131,-1,103,179,177,-1,103,178,179,-1,4,176,175,-1,4,44,176,-1,139,174,99,-1,138,174,139,-1,173,147,171,-1,173,148,147,-1,172,169,170,-1,168,169,172,-1,38,167,78,-1,38,37,167,-1,34,36,39,-1,34,35,36,-1,158,111,145,-1,111,158,122,-1,143,166,165,-1,166,143,113,-1,155,75,165,-1,75,155,73,-1,136,26,95,-1,136,27,26,-1,141,29,46,-1,30,29,141,-1,93,31,28,-1,93,55,31,-1,149,53,164,-1,53,149,148,-1,167,23,22,-1,167,37,23,-1,21,18,24,-1,19,18,21,-1,11,89,12,-1,89,11,100,-1,91,161,163,-1,91,162,161,-1,8,51,9,-1,51,8,80,-1,32,80,159,-1,51,80,32,-1,5,87,6,-1,87,5,62,-1,66,120,57,-1,66,118,120,-1,123,127,126,-1,123,122,127,-1,0,158,3,-1,0,86,158,-1,124,156,101,-1,146,156,124,-1,82,116,74,-1,82,157,116,-1,155,153,154,-1,155,152,153,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfmphal_Coord_7_45_point_1()
		{
			double[] value = {3.23268,.06231,2.90156,3.27522,.07408,2.89682,3.27552,.06173,2.90712,3.23465,.07753,2.89508,3.25787,.07651,3.19916,3.21913,.07219,3.11887,3.22933,.07117,3.11541,3.07476,.06806,2.94363,3.10166,.05942,3.01539,3.08816,.07618,3.02188,3.25987,.068,3.45844,3.22146,.09662,3.48283,3.2073,.07203,3.45617,3.32487,.05951,3.44121,3.37895,.05111,3.4045,3.38643,.0519,3.41879,3.31998,.06306,3.4287,3.22263,.14487,3.47941,3.24436,.18436,3.45889,3.22209,.17369,3.45392,3.24354,.1418,3.48874,3.22039,.1847,3.41079,3.22616,.19707,3.34597,3.20772,.18052,3.34727,3.24105,.19847,3.40937,3.37795,.07995,3.25044,3.39642,.0761,3.29926,3.38668,.06769,3.30055,3.45324,.16813,3.40059,3.45978,.13091,3.4304,3.46666,.13163,3.41523,3.44521,.17566,3.41543,3.17964,.08749,3.22006,3.18876,.0904,3.29431,3.17552,.11811,3.21919,3.1887,.11064,3.29165,3.18864,.15186,3.28626,3.19753,.18398,3.28447,3.17877,.19754,3.21607,3.17553,.15942,3.21559,3.35317,.07737,3.16881,3.32341,.06477,3.18028,3.34319,.07127,3.26148,3.3025,.06235,3.18483,3.28882,.07731,3.28199,3.42727,.04538,3.38633,3.44751,.0753,3.41798,3.19782,.13927,3.40741,3.40301,.08879,3.43836,3.41584,.14221,3.43803,3.07539,.12685,3.04093,3.15198,.08338,3.14834,3.14865,.12535,3.14872,3.39679,.19907,3.32368,3.36813,.20968,3.32892,3.42018,.20132,3.37803,3.38796,.2033,3.38269,3.05214,.12744,2.99462,3.36164,.05289,3.36237,3.30982,.06953,3.38509,3.19693,.06652,3.12881,3.14108,.03953,3.0075,3.17935,.0763,2.99911,3.27893,.10056,3.47439,3.34222,.10372,3.45128,3.09892,.25664,3.06705,3.06569,.21938,2.99438,3.10129,.19136,3.06432,3.23769,.12717,2.9258,3.27569,.13166,2.92522,3.08944,.28464,2.96082,3.15068,.32204,2.94542,3.14804,.284,2.94786,3.31004,.31713,2.93851,3.33426,.277,2.94338,3.30061,.28237,2.94599,3.1434,.22666,3.15259,3.14932,.16753,3.14746,3.19668,.22937,3.21256,3.17711,.25747,3.14647,3.16455,.06893,3.14332,3.34594,.26214,3.02322,3.34796,.27466,2.956,3.31966,.32516,2.9485,3.30757,.29974,3.03029,3.2452,.03761,2.98606,3.19249,.0647,2.89713,3.19704,.07648,2.99537,3.19292,.10519,3.40619,3.19265,.08812,3.44597,3.19133,.10583,3.43396,3.18985,.08249,3.40538,3.43378,.13387,3.36787,3.43332,.18597,3.37112,3.43676,.05944,3.37521,3.41747,.05984,3.34384,3.4242,.0905,3.35379,3.4065,.18458,3.42045,3.40434,.10258,3.30431,3.38099,.11465,3.25484};
			return value;
		}
		private double[] getlfmphal_Coord_7_45_point_2()
		{
			double[] value = {3.20578,.10941,3.47667,3.33421,.10273,2.93903,3.33263,.10929,2.97015,3.3129,.05543,2.97433,3.07711,.28068,2.97919,3.26065,.05884,3.10777,3.34793,.14076,3.09149,3.346,.14894,2.98111,3.34421,.10812,3.09108,3.31051,.26127,3.12012,3.34567,.24167,3.10793,3.16422,.12819,2.93253,3.14313,.21785,2.94542,3.18181,.21162,2.94424,3.12803,.13403,2.94338,3.30159,.18916,2.94662,3.34257,.18827,2.94846,3.08728,.21775,2.96558,3.07102,.21888,2.97408,3.07605,.08439,2.93193,3.05753,.13018,2.97365,3.08251,.13574,2.95745,3.16085,.07608,2.8957,3.10954,.07159,2.91437,3.31771,.11611,2.92393,3.29922,.0905,2.90855,3.11039,.05575,2.92195,3.1623,.0653,2.90139,3.28533,.20296,3.40198,3.3522,.19056,3.42592,3.34337,.20804,3.39142,3.29235,.18951,3.4454,3.25495,.06647,3.44378,3.24927,.06489,3.39499,3.27115,.20955,3.34115,3.35362,.06208,3.31192,3.40194,.04852,3.34516,3.29487,.14959,3.47063,3.37274,.16251,3.17542,3.36616,.12771,3.17316,3.35897,.17386,3.09268,3.45605,.08586,3.40558,3.3607,.09291,3.17092,3.22075,.20546,2.94411,3.26045,.19664,2.94885,3.20297,.12717,2.92787,3.33028,.14904,2.93529,3.36752,.21677,3.18891,3.37776,.20252,3.27135,3.38732,.18906,3.26795,3.14947,.33239,2.95971,3.30684,.07232,2.91958,3.21438,.34147,2.9391,3.21753,.35242,2.95264,3.26353,.3513,2.94841,3.26015,.33999,2.93595,3.3505,.14769,2.95417,3.35729,.18596,2.96464,3.19423,.07516,2.89112,3.19434,.07262,3.21679,3.20278,.07837,3.29392,3.20253,.07858,3.34851,3.19192,.08826,3.34979,3.2028,.06967,3.40264,3.41061,.18075,3.31922,3.24188,.2825,2.94237,3.19684,.28357,2.94345,3.21456,.2017,3.28293,3.24398,.24378,3.20969,3.2571,.21614,3.28031,3.311,.22772,3.27731,3.33051,.23865,3.19763,3.29416,.25429,3.20481,3.34803,.21605,3.27516,3.38883,.15162,3.25893,3.2205,.06996,3.20916,3.23892,.07336,3.28952,3.2815,.03596,2.982,3.32927,.07701,3.0869,3.29976,.05825,3.09907,3.35582,.15076,3.44526,3.1918,.10792,3.34891,3.19431,.14557,3.34684,3.35702,.19053,2.99203,3.41274,.14273,3.3134,3.29924,.07344,3.33377,3.24405,.06912,3.34226,3.32714,.21786,3.33437,3.25948,.32598,3.04196,3.27548,.28086,3.13231,3.22864,.27137,3.13884,3.21277,.31666,3.04582,3.15226,.2962,3.05515};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfmphal2_Geo_6_50_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,4,6,5,-1,7,8,9,-1,10,11,12,-1,10,13,11,-1,14,15,16,-1,16,17,14,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,25,27,16,-1,25,28,27,-1,17,16,27,-1,29,30,18,-1,31,30,32,-1,30,29,32,-1,33,34,35,-1,35,29,33,-1,36,37,38,-1,36,39,37,-1,40,39,41,-1,39,36,41,-1,20,42,43,-1,20,19,42,-1,44,36,45,-1,46,47,48,-1,49,27,21,-1,15,25,16,-1,50,51,4,-1,52,53,3,-1,27,54,21,-1,25,55,26,-1,25,15,55,-1,56,48,57,-1,58,9,46,-1,58,10,9,-1,59,60,61,-1,60,62,61,-1,63,64,65,-1,65,58,63,-1,66,67,68,-1,69,70,71,-1,0,2,40,-1,41,36,72,-1,35,73,32,-1,45,36,74,-1,75,30,76,-1,74,77,45,-1,73,78,79,-1,79,32,73,-1,32,29,35,-1,80,66,81,-1,66,68,81,-1,65,64,13,-1,82,61,83,-1,82,59,61,-1,62,84,61,-1,62,85,84,-1,48,56,46,-1,63,56,24,-1,56,57,24,-1,54,27,28,-1,86,87,88,-1,86,89,87,-1,17,90,14,-1,90,6,14,-1,17,27,49,-1,22,91,69,-1,8,2,70,-1,92,13,64,-1,31,76,30,-1,43,42,38,-1,78,40,41,-1,78,0,40,-1,93,79,72,-1,72,44,93,-1,44,72,36,-1,69,48,47,-1,47,70,69,-1,70,47,8,-1,91,54,28,-1,30,19,18,-1,30,75,19,-1,94,95,96,-1,94,97,95,-1,5,6,87,-1,6,90,87,-1,90,98,87,-1,98,88,87,-1,98,99,88,-1,11,13,67,-1,24,28,25,-1,8,100,2,-1,11,66,60,-1,11,67,66,-1,85,52,101,-1,102,52,85,-1,60,80,62,-1,60,66,80,-1,103,104,105,-1,103,81,104,-1,3,50,4,-1,50,3,53,-1,92,67,13,-1,67,92,68,-1,50,55,51,-1,50,105,55,-1,85,89,84,-1,89,85,101,-1,106,96,95,-1,96,106,86,-1,97,107,108,-1,107,97,94,-1,54,22,21,-1,22,54,91,-1,0,73,109,-1,73,0,78,-1,20,110,108,-1,110,20,43,-1,77,31,93,-1,77,76,31,-1,1,70,2,-1,70,1,71,-1,111,8,112,-1,111,100,8,-1,113,97,114,-1,95,97,113,-1,115,116,99,-1,115,117,116,-1,91,24,57,-1,91,28,24,-1,14,4,51,-1,14,6,4,-1,58,56,63,-1,56,58,46,-1,60,12,11,-1,12,60,59,-1,84,83,61,-1,84,106,83,-1,105,26,55,-1,105,104,26,-1,104,64,26,-1,64,104,92,-1,99,49,115,-1,49,99,98,-1,33,117,34,-1,117,33,116,-1,47,9,8,-1,47,46,9,-1,110,111,114,-1,37,111,110,-1,83,95,113,-1,83,106,95,-1,96,88,99,-1,86,88,96,-1,41,79,78,-1,41,72,79,-1,19,74,42,-1,19,75,74,-1,76,74,75,-1,74,76,77,-1,7,112,8,-1,7,82,112,-1,38,74,36,-1,38,42,74,-1,107,116,33,-1,94,116,107,-1,114,108,110,-1,114,97,108,-1,82,113,112,-1,82,83,113,-1,37,100,111,-1,39,100,37,-1,2,39,40,-1,2,100,39,-1,23,69,71,-1,23,22,69,-1,1,109,118,-1,109,1,0,-1,118,34,117,-1,118,109,34,-1,115,21,23,-1,21,115,49,-1,63,26,64,-1,24,26,63,-1,81,102,80,-1,102,81,103,-1,7,59,82,-1,7,12,59,-1,58,13,10,-1,13,58,65,-1,87,101,5,-1,87,89,101,-1,90,49,98,-1,90,17,49,-1,117,23,118,-1,23,117,115,-1,94,99,116,-1,99,94,96,-1,112,114,111,-1,113,114,112,-1,118,71,1,-1,71,118,23,-1,45,93,44,-1,45,77,93,-1,33,18,107,-1,33,29,18,-1,43,37,110,-1,38,37,43,-1,109,35,34,-1,35,109,73,-1,79,31,32,-1,93,31,79,-1,57,69,91,-1,57,48,69,-1,18,108,107,-1,18,20,108,-1,86,84,89,-1,86,106,84,-1,103,52,102,-1,52,103,53,-1,15,51,55,-1,51,15,14,-1,53,105,50,-1,105,53,103,-1,92,81,68,-1,81,92,104,-1,9,12,7,-1,9,10,12,-1,102,62,80,-1,85,62,102,-1,52,5,101,-1,52,3,5,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfmphal2_Coord_7_50_point_1()
		{
			double[] value = {3.65712,.12989,2.67248,3.69666,.14495,2.74097,3.6427,.19123,2.75659,3.89484,.13675,3.00609,3.89886,.12035,2.99778,3.90921,.13904,2.98841,3.90964,.12454,2.98062,3.71902,.23469,2.87895,3.69396,.24383,2.82898,3.71131,.22103,2.87622,3.70651,.20867,2.9496,3.69848,.19183,3.04011,3.71413,.22195,2.95519,3.69419,.17038,3.04794,3.90304,.0792,2.95178,3.85646,.08116,2.95292,3.85819,.09252,2.91778,3.89765,.10971,2.90662,3.86055,.21925,2.63866,3.80796,.25273,2.63917,3.82332,.26639,2.62677,3.82862,.12046,2.85261,3.81604,.12382,2.85305,3.81782,.11258,2.8036,3.79235,.09764,2.96447,3.81296,.09338,2.96101,3.78912,.09359,3.02676,3.85784,.10136,2.9021,3.80932,.10617,2.94821,3.85903,.14898,2.63867,3.83954,.16045,2.6359,3.73534,.14715,2.62615,3.73976,.129,2.62355,3.86898,.14534,2.6438,3.82309,.09053,2.64253,3.81189,.10038,2.62861,3.66204,.26104,2.70536,3.70002,.32206,2.69427,3.69785,.31201,2.68362,3.65585,.26438,2.71984,3.62291,.19584,2.71156,3.62714,.19679,2.69706,3.77523,.27842,2.6434,3.7854,.30834,2.6363,3.66713,.20032,2.66939,3.7001,.20202,2.67413,3.71084,.17644,2.86718,3.6993,.18045,2.8369,3.74373,.1512,2.86087,3.88819,.11502,2.8475,3.86781,.12188,3.02457,3.88497,.0719,2.99405,3.883,.17553,3.01868,3.86963,.13922,3.02507,3.82167,.12119,2.91338,3.83458,.07571,3.00529,3.73677,.12964,2.89718,3.78028,.12346,2.90778,3.69833,.15841,2.92947,3.75684,.25983,2.97065,3.75325,.25314,3.04901,3.82396,.24519,2.96658,3.82199,.22772,3.03704,3.73027,.11521,2.94904,3.72432,.1114,3.02332,3.69119,.14126,2.99471,3.74985,.23422,3.06458,3.70928,.18374,3.05763,3.73188,.17862,3.06844,3.75764,.15215,2.85005,3.68572,.18357,2.81452,3.73615,.14974,2.81233,3.64983,.19856,2.67484,3.73409,.0994,2.62853,3.74194,.21866,2.66731,3.77013,.20263,2.65559,3.74166,.17212,2.64809,3.71558,.18642,2.6588,3.65626,.13467,2.65758,3.67366,.1601,2.64136,3.81371,.21382,3.05085,3.79504,.16081,3.06387,3.76938,.27483,2.8875,3.8386,.27457,2.87736,3.86643,.23121,2.96004,3.8556,.21227,3.02153,3.91377,.22014,2.86013,3.91835,.1597,2.93165,3.91311,.17148,2.85258,3.90425,.19754,2.95174,3.9161,.14377,2.92222,3.80787,.12388,2.91233,3.7307,.16208,3.06649,3.68319,.16915,2.64114,3.89921,.22526,2.70615,3.89019,.26981,2.79746,3.9197,.22905,2.78064,3.86948,.2764,2.70842,3.90896,.15461,2.85058,3.91523,.16065,2.77869};
			return value;
		}
		private double[] getlfmphal2_Coord_7_50_point_2()
		{
			double[] value = {3.67004,.25694,2.76647,3.89563,.18749,3.0067,3.84869,.19789,3.03263,3.82928,.14802,3.04565,3.79191,.14523,3.06211,3.82705,.13248,3.04494,3.88042,.25632,2.87091,3.8756,.22298,2.64539,3.84002,.27803,2.63317,3.74111,.09126,2.64157,3.79295,.31469,2.64123,3.72389,.30796,2.75818,3.75807,.29234,2.83263,3.84221,.29145,2.81582,3.818,.30605,2.71489,3.88548,.10614,2.79204,3.89471,.15165,2.70636,3.85907,.09774,2.71366,3.7806,.10208,2.71686};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfmphal3_Geo_6_55_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,10,12,11,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,10,23,-1,22,24,10,-1,25,26,27,-1,26,28,27,-1,29,30,31,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,37,39,38,-1,40,41,42,-1,43,44,45,-1,45,46,43,-1,11,47,9,-1,48,24,49,-1,50,51,52,-1,50,6,51,-1,53,45,54,-1,45,55,54,-1,15,56,13,-1,57,58,59,-1,59,60,57,-1,61,62,57,-1,57,60,61,-1,63,64,65,-1,63,66,64,-1,67,68,69,-1,67,70,68,-1,13,71,72,-1,13,56,71,-1,73,0,2,-1,19,74,20,-1,75,76,4,-1,4,3,75,-1,18,77,16,-1,36,38,33,-1,30,78,35,-1,40,42,79,-1,29,31,80,-1,81,82,83,-1,58,84,85,-1,58,86,84,-1,18,87,88,-1,89,90,91,-1,91,92,89,-1,3,5,93,-1,75,21,76,-1,75,19,21,-1,49,74,48,-1,74,19,48,-1,0,73,70,-1,94,95,96,-1,94,97,95,-1,92,98,99,-1,99,89,92,-1,59,52,100,-1,100,60,59,-1,86,58,57,-1,57,101,86,-1,56,15,8,-1,52,51,102,-1,102,100,52,-1,22,23,103,-1,103,104,22,-1,12,24,48,-1,12,10,24,-1,105,47,11,-1,83,37,81,-1,83,39,37,-1,30,35,106,-1,35,32,106,-1,107,41,91,-1,107,42,41,-1,34,38,108,-1,34,33,38,-1,82,88,109,-1,103,96,104,-1,110,26,25,-1,110,111,26,-1,73,112,70,-1,73,113,112,-1,18,17,87,-1,15,6,8,-1,11,114,105,-1,13,115,14,-1,103,116,96,-1,93,117,3,-1,70,67,0,-1,105,118,63,-1,105,114,118,-1,28,66,27,-1,66,28,72,-1,116,8,7,-1,8,116,119,-1,120,23,121,-1,120,103,23,-1,122,21,20,-1,122,1,21,-1,76,67,4,-1,67,76,0,-1,123,5,69,-1,123,93,5,-1,124,125,126,-1,124,117,125,-1,65,105,63,-1,65,47,105,-1,127,49,128,-1,127,74,49,-1,70,129,68,-1,70,112,129,-1,130,111,110,-1,130,131,111,-1,71,120,64,-1,71,119,120,-1,132,96,95,-1,104,96,132,-1,133,134,135,-1,133,136,134,-1,2,113,73,-1,2,137,113,-1,101,88,87,-1,101,109,88,-1,84,138,139,-1,84,86,138,-1,137,140,141,-1,140,137,136,-1,142,98,106,-1,98,142,99,-1,143,14,144,-1,143,145,14,-1,146,28,26,-1,146,115,28,-1,109,83,82,-1,62,83,109,-1,108,39,61,-1,108,38,39,-1,92,41,80,-1,91,41,92,-1,77,42,107,-1,77,79,42,-1,147,88,82,-1,88,147,18,-1,30,148,78,-1,30,29,148,-1,81,148,149,-1,81,37,148,-1,53,129,150,-1,53,131,129,-1,90,107,91,-1,90,151,107,-1,7,96,116,-1,96,7,94,-1,100,34,108,-1,100,102,34,-1,152,84,140,-1,152,85,84,-1,153,154,155,-1,153,156,154,-1,50,97,94,-1,50,157,97,-1,99,158,89,-1,143,158,99,-1,43,16,151,-1,43,159,16,-1,17,138,87,-1,17,160,138,-1,161,51,162,-1,102,51,161,-1,95,152,133,-1,95,97,152,-1,53,111,131,-1,54,111,53,-1,64,121,65,-1,121,64,120,-1,128,104,132,-1,22,104,128,-1,135,122,127,-1,135,134,122,-1,141,113,137,-1,153,113,141,-1,48,75,12,-1,48,19,75,-1,117,11,3,-1,124,11,117,-1,11,124,114,-1,158,144,55,-1,158,143,144,-1,43,154,159,-1,43,46,154,-1,44,55,45,-1,44,158,55,-1,139,160,156,-1,139,138,160,-1,109,57,62,-1,57,109,101,-1,52,157,50,-1,52,59,157,-1,162,6,15,-1,162,51,6,-1,106,161,142,-1,32,161,106,-1,80,40,29,-1,41,40,80,-1,40,147,149,-1,40,79,147,-1,149,82,81,-1,149,147,82,-1,33,78,36,-1,78,33,35,-1,15,145,162,-1,15,14,145,-1,102,32,34,-1,161,32,102,-1,108,60,100,-1,108,61,60,-1,156,159,154,-1,156,160,159,-1,151,77,107,-1,16,77,151,-1,75,11,12,-1,75,3,11,-1,113,155,112,-1,113,153,155,-1,133,140,136,-1,152,140,133,-1,125,25,126,-1,25,125,110,-1,56,119,71,-1,119,56,8,-1,111,146,26,-1,146,111,54,-1,110,123,130,-1,110,125,123,-1,112,150,129,-1,112,155,150,-1,132,127,128,-1,132,135,127,-1,157,58,85,-1,157,59,58,-1,16,160,17,-1,16,159,160,-1,44,89,158,-1,89,44,90,-1};
			return value;
		}
		private int[] getlfmphal3_Geo_6_55_coordIndex_2()
		{
			int[] value = {162,142,161,-1,162,145,142,-1,54,144,146,-1,54,55,144,-1,155,46,150,-1,155,154,46,-1,141,156,153,-1,141,139,156,-1,97,85,152,-1,97,157,85,-1,6,94,7,-1,94,6,50,-1,151,44,43,-1,44,151,90,-1,45,150,46,-1,45,53,150,-1,69,130,123,-1,130,69,68,-1,149,29,40,-1,149,148,29,-1,148,36,78,-1,148,37,36,-1,79,18,147,-1,18,79,77,-1,80,98,92,-1,80,31,98,-1,61,83,62,-1,61,39,83,-1,25,118,126,-1,27,118,25,-1,115,144,14,-1,144,115,146,-1,142,143,99,-1,142,145,143,-1,31,106,98,-1,31,30,106,-1,1,134,2,-1,1,122,134,-1,139,140,84,-1,139,141,140,-1,87,86,101,-1,138,86,87,-1,2,136,137,-1,134,136,2,-1,95,135,132,-1,95,133,135,-1,72,64,66,-1,72,71,64,-1,68,131,130,-1,68,129,131,-1,128,24,22,-1,128,49,24,-1,121,47,65,-1,9,47,121,-1,114,126,118,-1,114,124,126,-1,125,93,123,-1,125,117,93,-1,69,4,67,-1,69,5,4,-1,0,21,1,-1,0,76,21,-1,20,127,122,-1,20,74,127,-1,10,121,23,-1,121,10,9,-1,119,103,120,-1,119,116,103,-1,72,115,13,-1,72,28,115,-1,27,63,118,-1,63,27,66,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfmphal3_Coord_7_55_point_1()
		{
			double[] value = {4.07984,.19119,2.01008,4.16998,.13669,2.01746,4.16408,.14424,2.04131,4.07245,.30679,2.02478,4.01339,.25341,2.02174,3.98154,.29286,2.04412,4.22792,.28826,2.17589,4.22433,.30785,2.12555,4.18779,.34038,2.1383,4.20486,.38987,1.99669,4.24016,.36062,1.98602,4.13096,.37789,2.01778,4.20162,.31894,2.00876,4.14283,.36394,2.1486,4.11633,.34488,2.20771,4.17838,.33648,2.19485,4.07816,.22057,2.3173,4.16815,.19894,2.30067,4.16073,.17237,2.32457,4.20549,.18572,2.00491,4.19236,.14505,2.00582,4.17235,.14694,2.00469,4.29857,.26137,2.01227,4.24602,.36406,2.00066,4.28919,.26255,2.00192,4.05494,.3836,2.07882,4.06539,.36639,2.12193,4.09047,.4022,2.06983,4.09863,.37793,2.11123,4.1165,.28072,2.37622,4.13267,.31334,2.36879,4.08859,.31364,2.37115,4.23838,.30535,2.31238,4.31297,.2547,2.31587,4.2996,.26168,2.29595,4.24579,.29496,2.33355,4.31246,.2428,2.32173,4.29718,.20838,2.32789,4.32545,.23103,2.31272,4.3156,.2023,2.3085,4.08166,.24058,2.37088,4.02562,.27115,2.36791,4.03311,.2431,2.36514,4.05947,.25125,2.28374,4.04839,.27441,2.28312,4.03753,.27708,2.22131,4.04355,.25124,2.21513,4.16566,.41525,2.00222,4.25867,.24147,2.00281,4.27526,.21485,1.99858,4.25405,.25518,2.16856,4.24751,.27499,2.22723,4.26288,.2468,2.22419,4.01173,.28,2.16868,4.04598,.32277,2.16392,4.05722,.31299,2.22306,4.16086,.35674,2.14434,4.26393,.1814,2.27307,4.24072,.18973,2.23136,4.25321,.21778,2.2259,4.29356,.20783,2.2693,4.3163,.20178,2.29514,4.29156,.16761,2.30004,4.12176,.43169,2.03447,4.16125,.40447,2.04685,4.16752,.42139,2.01576,4.12439,.40582,2.05996,4.00823,.24134,2.03307,3.97858,.27347,2.08555,3.97071,.28356,2.05872,4.0183,.23488,2.05668,4.15625,.37859,2.10703,4.13021,.3811,2.11037,4.09053,.19474,2.03774,4.23662,.15813,2.01008,4.13595,.25208,2.01236,4.08503,.20061,1.99765,4.05645,.20659,2.34772,4.24127,.27877,2.34402,4.05996,.20915,2.3582,4.05279,.29652,2.3719,4.26864,.17614,2.32713,4.2392,.15591,2.32169,4.2901,.16949,2.31305,4.20051,.17933,2.17042,4.22824,.18827,2.17272,4.21849,.18614,2.23563,4.2108,.17185,2.28192,4.22625,.15587,2.3116,4.05265,.30431,2.32796,4.03805,.27235,2.32598,4.02095,.27576,2.35716,4.04,.30167,2.35799,3.98107,.31398,2.04805,4.26352,.26114,2.1129,4.25652,.21364,2.07497,4.27731,.26467,2.07204,4.25132,.21549,2.11537,4.08392,.32382,2.35668,4.08206,.32575,2.32847};
			return value;
		}
		private double[] getlfmphal3_Coord_7_55_point_2()
		{
			double[] value = {4.29656,.23664,2.26649,4.23752,.17136,2.27588,4.27635,.26202,2.27036,4.23783,.35174,2.0305,4.28911,.26466,2.03654,4.12114,.42384,2.01848,4.13406,.32574,2.34725,4.02687,.24197,2.35455,4.32209,.2319,2.29451,4.24531,.15564,2.30792,4.01751,.35746,2.08349,4.03182,.33785,2.12291,4.03302,.22559,2.09221,4.10338,.19382,2.08166,4.07931,.41815,2.03198,4.10499,.36298,2.15103,4.22586,.32807,2.08627,4.01183,.36699,2.04638,4.07876,.42434,2.04841,4.19244,.35416,2.10124,4.19953,.37988,2.03501,4.20799,.3947,2.00782,4.18829,.13525,2.01804,3.97191,.31506,2.06475,4.04537,.39985,2.03694,4.00697,.37046,2.05986,4.04276,.40642,2.05403,4.24249,.15232,2.02259,4.28455,.21233,2.00959,3.9943,.26013,2.12242,3.9778,.29963,2.09177,3.99286,.28391,2.12965,4.26957,.21363,2.03664,4.22769,.1655,2.07657,4.18441,.14215,2.04159,4.23367,.15837,2.04454,4.18454,.15083,2.07614,4.16341,.15308,2.07705,4.19469,.18917,2.24382,4.17297,.18319,2.17538,4.1875,.16257,2.12032,4.16279,.16752,2.12837,4.12859,.32653,2.31755,4.09164,.3284,2.2757,4.08308,.33829,2.21887,4.12401,.33248,2.26993,4.07316,.352,2.16076,4.16634,.17413,2.33503,4.22356,.24102,2.35517,4.19276,.20222,2.34829,4.01562,.25504,2.16387,4.04589,.24699,2.3258,4.22724,.1755,2.11815,4.11751,.20305,2.13625,4.07333,.23194,2.20434,4.05379,.22873,2.14833,4.13243,.21301,2.19073,4.24636,.21839,2.17186,4.06297,.31025,2.2778,4.08938,.23014,2.27847,4.16019,.21299,2.26095,4.22246,.30652,2.28834,4.20097,.32014,2.24865};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfmphal4_Geo_6_60_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,1,21,22,-1,21,23,22,-1,24,7,6,-1,25,26,27,-1,28,29,30,-1,30,18,28,-1,31,32,33,-1,31,34,32,-1,35,36,37,-1,36,38,37,-1,39,40,41,-1,41,42,39,-1,13,12,43,-1,44,45,46,-1,46,47,44,-1,15,48,16,-1,49,50,51,-1,51,52,49,-1,20,53,54,-1,53,55,54,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,62,63,60,-1,64,65,57,-1,64,66,65,-1,67,68,69,-1,69,70,67,-1,1,0,21,-1,71,72,73,-1,74,73,75,-1,74,76,73,-1,4,3,77,-1,63,78,35,-1,35,60,63,-1,27,19,18,-1,79,53,36,-1,53,80,36,-1,81,54,55,-1,81,82,54,-1,39,42,26,-1,83,84,85,-1,86,87,38,-1,88,89,90,-1,32,91,33,-1,53,19,80,-1,92,93,94,-1,94,95,92,-1,94,96,97,-1,94,93,96,-1,14,13,3,-1,98,73,72,-1,99,21,0,-1,100,101,102,-1,100,103,101,-1,10,48,104,-1,104,105,10,-1,106,107,108,-1,108,109,106,-1,110,111,112,-1,110,59,111,-1,18,20,54,-1,54,28,18,-1,79,113,55,-1,55,53,79,-1,62,96,63,-1,96,93,63,-1,10,16,48,-1,114,95,94,-1,114,115,95,-1,116,6,117,-1,6,8,117,-1,71,47,46,-1,118,13,43,-1,35,78,36,-1,78,79,36,-1,38,87,37,-1,60,35,37,-1,37,83,60,-1,119,88,32,-1,32,34,119,-1,112,39,26,-1,26,25,112,-1,85,84,89,-1,103,120,121,-1,121,101,103,-1,122,67,123,-1,67,124,123,-1,125,126,45,-1,126,46,45,-1,75,73,98,-1,19,53,20,-1,127,128,125,-1,128,7,125,-1,16,10,9,-1,118,45,44,-1,44,13,118,-1,15,17,117,-1,77,3,129,-1,99,0,130,-1,73,47,71,-1,131,132,133,-1,134,135,136,-1,137,131,138,-1,139,140,141,-1,142,143,135,-1,143,144,135,-1,142,135,145,-1,146,147,148,-1,147,149,148,-1,150,151,152,-1,151,153,152,-1,154,155,156,-1,155,157,156,-1,158,154,156,-1,158,159,154,-1,160,161,162,-1,162,163,160,-1,151,164,165,-1,166,167,168,-1,169,170,171,-1,159,172,173,-1,174,175,170,-1,176,168,167,-1,177,178,179,-1,178,134,179,-1,180,181,146,-1,180,182,181,-1,170,169,162,-1,183,184,140,-1,184,141,140,-1,185,133,145,-1,186,187,143,-1,188,189,155,-1,155,190,188,-1,191,192,193,-1,194,195,196,-1,196,197,194,-1,198,199,196,-1,199,197,196,-1,200,201,202,-1,200,203,201,-1,204,205,206,-1,206,207,204,-1,208,187,205,-1,205,204,208,-1,133,209,131,-1,142,210,211,-1,212,184,183,-1,212,213,184,-1,214,215,216,-1,215,217,216,-1,166,218,167,-1,150,189,164,-1,172,219,169,-1,164,188,220,-1,221,222,223,-1,221,224,222,-1,225,226,227,-1,227,228,225,-1,156,229,158,-1,156,230,229,-1,231,232,233,-1,231,199,232,-1,234,235,236,-1,234,237,235,-1,207,206,237,-1,237,234,207,-1,231,238,239,-1,231,233,238,-1,240,199,231,-1,240,197,199,-1,148,160,163,-1,148,149,160,-1,241,242,243,-1,222,158,229,-1,229,223,222,-1,197,240,244,-1,245,164,220,-1,245,165,164,-1,161,170,162,-1,159,219,172,-1,151,150,164,-1,139,246,140,-1,142,211,186,-1,133,185,209,-1,211,210,202,-1,210,200,202,-1,247,246,204,-1,246,208,204,-1,132,131,137,-1,137,203,132,-1,181,194,197,-1,197,244,181,-1,248,249,250,-1,249,251,250,-1,218,151,167,-1,190,252,188,-1,241,206,253,-1,241,237,206,-1,191,136,135,-1,184,213,254,-1,184,254,141,-1,178,145,134,-1,145,135,134,-1,217,168,255,-1,245,256,257,-1,245,220,256,-1,216,258,174,-1,259,173,172,-1,173,260,261,-1,175,258,262,-1,175,174,258,-1,172,169,171,-1,170,161,174,-1,167,151,165,-1,164,189,188,-1,224,219,222,-1,224,169,219,-1,219,159,158,-1,158,222,219,-1,263,238,250,-1,263,264,238,-1,147,265,149,-1,265,266,149,-1,267,141,254,-1,267,139,141,-1,132,203,200,-1,131,177,138,-1,131,209,177,-1,185,145,178,-1,195,194,268,-1,143,142,186,-1,122,107,269,-1,108,107,122,-1,105,11,10,-1,105,123,11,-1,270,7,128,-1,270,8,7,-1,45,127,125,-1,118,127,45,-1,98,100,102,-1,100,98,72,-1};
			return value;
		}
		private int[] getlfmphal4_Geo_6_60_coordIndex_2()
		{
			int[] value = {0,75,130,-1,0,74,75,-1,271,129,2,-1,271,77,129,-1,69,4,272,-1,69,5,4,-1,269,273,68,-1,269,14,273,-1,118,106,127,-1,118,43,106,-1,71,126,274,-1,126,71,46,-1,275,276,277,-1,275,278,276,-1,279,67,70,-1,67,279,124,-1,105,109,108,-1,105,104,109,-1,280,120,103,-1,280,281,120,-1,101,282,99,-1,101,121,282,-1,283,284,285,-1,283,286,284,-1,130,101,99,-1,101,130,102,-1,85,287,61,-1,85,89,287,-1,52,96,62,-1,96,52,51,-1,97,11,288,-1,97,9,11,-1,67,269,68,-1,67,122,269,-1,40,112,111,-1,112,40,39,-1,83,61,60,-1,61,83,85,-1,86,19,289,-1,80,19,86,-1,119,89,88,-1,287,89,119,-1,290,91,90,-1,91,290,41,-1,84,291,290,-1,87,291,84,-1,271,277,272,-1,275,277,271,-1,95,292,293,-1,292,95,115,-1,79,92,113,-1,78,92,79,-1,125,24,126,-1,24,125,7,-1,17,116,117,-1,294,116,17,-1,295,58,296,-1,56,58,295,-1,297,66,298,-1,297,65,66,-1,82,285,284,-1,299,285,82,-1,300,293,292,-1,300,81,293,-1,114,97,288,-1,114,94,97,-1,92,63,93,-1,78,63,92,-1,30,64,110,-1,30,29,64,-1,274,103,100,-1,274,280,103,-1,22,292,278,-1,22,300,292,-1,70,272,277,-1,272,70,69,-1,114,124,279,-1,114,288,124,-1,48,270,104,-1,15,270,48,-1,281,116,297,-1,6,116,281,-1,120,283,121,-1,120,298,283,-1,23,300,22,-1,23,299,300,-1,44,3,13,-1,44,76,3,-1,59,31,111,-1,56,31,59,-1,66,29,286,-1,66,64,29,-1,119,295,49,-1,295,119,34,-1,16,51,50,-1,51,16,9,-1,32,90,91,-1,88,90,32,-1,291,26,42,-1,291,289,26,-1,87,289,291,-1,289,87,86,-1,83,87,84,-1,83,37,87,-1,49,287,119,-1,287,49,52,-1,50,17,16,-1,17,50,296,-1,58,65,294,-1,58,57,65,-1,25,110,112,-1,30,110,25,-1,284,54,82,-1,284,28,54,-1,113,81,55,-1,113,293,81,-1,5,14,3,-1,14,5,273,-1,3,74,129,-1,3,76,74,-1,76,47,73,-1,44,47,76,-1,282,299,23,-1,285,299,282,-1,280,126,24,-1,274,126,280,-1,109,127,106,-1,128,127,109,-1,276,114,279,-1,115,114,276,-1,2,275,271,-1,2,1,275,-1,297,120,281,-1,298,120,297,-1,49,296,50,-1,49,295,296,-1,110,57,59,-1,110,64,57,-1,294,297,116,-1,294,65,297,-1,299,81,300,-1,299,82,81,-1,298,286,283,-1,298,66,286,-1,56,34,31,-1,56,295,34,-1,296,294,17,-1,58,294,296,-1,92,293,113,-1,293,92,95,-1,115,278,292,-1,278,115,276,-1,290,42,41,-1,291,42,290,-1,41,33,91,-1,33,41,40,-1,89,290,90,-1,89,84,290,-1,289,27,26,-1,19,27,289,-1,80,38,36,-1,80,86,38,-1,111,33,40,-1,111,31,33,-1,288,123,124,-1,288,11,123,-1,97,51,9,-1,97,96,51,-1,52,61,287,-1,62,61,52,-1,285,121,283,-1,121,285,282,-1,286,28,284,-1,28,286,29,-1,30,27,18,-1,27,30,25,-1,99,23,21,-1,99,282,23,-1,6,280,24,-1,280,6,281,-1,104,128,109,-1,128,104,270,-1,277,279,70,-1,277,276,279,-1,1,278,275,-1,1,22,278,-1,72,274,100,-1,274,72,71,-1,43,107,106,-1,107,43,12,-1,68,5,69,-1,68,273,5,-1,272,77,271,-1,272,4,77,-1,74,2,129,-1,0,2,74,-1,102,75,98,-1,75,102,130,-1,8,15,117,-1,270,15,8,-1,123,108,122,-1,105,108,123,-1,12,269,107,-1,12,14,269,-1,179,136,301,-1,179,134,136,-1,209,178,177,-1,209,185,178,-1,145,210,142,-1,145,133,210,-1,223,180,221,-1,225,180,223,-1,230,226,229,-1,230,242,226,-1,235,302,303,-1,235,243,302,-1,251,304,305,-1,304,251,236,-1,239,264,306,-1,239,238,264,-1,250,305,263,-1,305,250,251,-1,215,307,308,-1,215,214,307,-1,162,224,163,-1,162,169,224,-1,153,218,309,-1,153,151,218,-1,310,175,262,-1,311,175,310,-1,260,259,312,-1,173,259,260,-1,176,255,168,-1,255,176,313,-1,259,171,311,-1,259,172,171,-1,188,256,220,-1,188,252,256,-1,245,313,176,-1,245,257,313,-1,313,258,255,-1,262,258,313,-1,137,268,194,-1,137,138,268,-1,144,191,135,-1,192,191,144,-1,206,314,253,-1,206,205,314,-1,235,241,243,-1,235,237,241,-1};
			return value;
		}
		private int[] getlfmphal4_Geo_6_60_coordIndex_3()
		{
			int[] value = {153,263,305,-1,263,153,309,-1,248,315,249,-1,316,315,248,-1,214,174,161,-1,214,216,174,-1,317,316,232,-1,316,317,318,-1,247,140,246,-1,247,318,140,-1,314,211,202,-1,186,211,314,-1,267,187,208,-1,267,143,187,-1,208,139,267,-1,208,246,139,-1,198,193,212,-1,196,193,198,-1,173,154,159,-1,154,173,261,-1,245,167,165,-1,245,176,167,-1,312,252,260,-1,252,312,256,-1,257,262,313,-1,310,262,257,-1,240,239,265,-1,239,240,231,-1,181,147,146,-1,244,147,181,-1,241,201,227,-1,201,241,253,-1,157,230,156,-1,230,157,302,-1,149,307,160,-1,149,266,307,-1,137,228,203,-1,137,182,228,-1,306,319,308,-1,306,264,319,-1,238,248,250,-1,238,233,248,-1,152,305,304,-1,152,153,305,-1,249,207,234,-1,249,315,207,-1,152,303,320,-1,303,152,304,-1,249,236,251,-1,236,249,234,-1,232,248,233,-1,232,316,248,-1,309,264,263,-1,319,264,309,-1,308,266,306,-1,266,308,307,-1,227,242,241,-1,242,227,226,-1,227,203,228,-1,203,227,201,-1,182,225,228,-1,182,180,225,-1,244,265,147,-1,244,240,265,-1,310,256,312,-1,310,257,256,-1,260,190,261,-1,252,190,260,-1,261,155,154,-1,155,261,190,-1,168,215,166,-1,215,168,217,-1,193,213,212,-1,192,213,193,-1,317,212,183,-1,317,198,212,-1,301,191,193,-1,301,136,191,-1,193,195,301,-1,195,193,196,-1,318,183,140,-1,318,317,183,-1,247,207,315,-1,207,247,204,-1,253,202,201,-1,202,253,314,-1,198,232,199,-1,317,232,198,-1,318,315,316,-1,318,247,315,-1,320,302,157,-1,320,303,302,-1,314,187,186,-1,314,205,187,-1,192,254,213,-1,192,144,254,-1,221,163,224,-1,221,148,163,-1,194,182,137,-1,182,194,181,-1,179,138,177,-1,138,179,268,-1,255,216,217,-1,255,258,216,-1,170,311,171,-1,175,311,170,-1,311,312,259,-1,311,310,312,-1,320,150,152,-1,320,189,150,-1,166,308,319,-1,166,215,308,-1,189,157,155,-1,320,157,189,-1,218,319,309,-1,218,166,319,-1,214,160,307,-1,214,161,160,-1,265,306,266,-1,265,239,306,-1,236,303,304,-1,236,235,303,-1,302,242,230,-1,243,242,302,-1,229,225,223,-1,226,225,229,-1,180,148,221,-1,180,146,148,-1,144,267,254,-1,267,144,143,-1,200,133,132,-1,210,133,200,-1,301,268,179,-1,301,195,268,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfmphal4_Coord_7_60_point_1()
		{
			double[] value = {4.46683,.26569,1.545,4.4147,.30696,1.58041,4.40469,.31423,1.55955,4.46948,.37325,1.5604,4.37645,.38339,1.57707,4.40475,.43208,1.5786,4.62903,.33463,1.58113,4.62727,.40359,1.56806,4.61997,.38473,1.6045,4.51334,.39725,1.70659,4.54541,.41485,1.66833,4.50788,.41556,1.67051,4.52781,.47273,1.57434,4.53418,.4332,1.56046,4.48346,.47063,1.58515,4.58515,.39299,1.65618,4.57072,.38857,1.69517,4.61561,.34713,1.67681,4.57308,.24149,1.72121,4.53595,.24341,1.75012,4.54192,.26661,1.73886,4.47863,.26783,1.56732,4.42941,.29605,1.61168,4.49127,.26535,1.60163,4.63159,.33929,1.54279,4.59581,.22591,1.73596,4.59647,.22544,1.74728,4.58491,.22652,1.73817,4.56442,.25127,1.70403,4.58236,.24873,1.69743,4.59018,.24051,1.71724,4.67204,.28976,1.7355,4.66622,.3095,1.75547,4.67046,.28834,1.75007,4.65552,.31774,1.73785,4.43407,.33688,1.79189,4.44029,.30854,1.77918,4.43901,.33187,1.80137,4.44596,.30866,1.78875,4.64156,.23389,1.74945,4.66488,.26252,1.74681,4.65055,.2678,1.76431,4.62457,.24017,1.76219,4.56845,.46292,1.55905,4.57256,.36354,1.53091,4.62359,.40865,1.53682,4.6232,.33899,1.50978,4.60323,.31801,1.50992,4.562,.40807,1.66388,4.59274,.36229,1.7324,4.58041,.37459,1.7155,4.51158,.38711,1.73456,4.5127,.38201,1.75882,4.47633,.28828,1.75419,4.53724,.27849,1.72197,4.47947,.29196,1.7376,4.65129,.29716,1.71049,4.62609,.27791,1.68737,4.63747,.30397,1.68708,4.64623,.27099,1.71183,4.44615,.35955,1.79371,4.47849,.37834,1.79358,4.4752,.38198,1.76834,4.45343,.36358,1.76692,4.60361,.25207,1.69406,4.61836,.28025,1.67028,4.5987,.2534,1.66969,4.45246,.4424,1.61374,4.44092,.46362,1.59583,4.39988,.4348,1.59084,4.41116,.42142,1.61136,4.61792,.28987,1.50323,4.59415,.23616,1.51675,4.56545,.26985,1.52324,4.47238,.27454,1.53505,4.52687,.23084,1.53382,4.52722,.31952,1.54156,4.3781,.36345,1.57227,4.44459,.33542,1.76386,4.45227,.31245,1.76273,4.46324,.27647,1.77178,4.46832,.29676,1.6988,4.51756,.27859,1.68621,4.45767,.35362,1.80604,4.50879,.33741,1.80956,4.48403,.36811,1.80619,4.46706,.27797,1.7813,4.48445,.30277,1.80307,4.61142,.34794,1.77252,4.51888,.3667,1.80424,4.60687,.33296,1.78122,4.66518,.29845,1.76025,4.45072,.33603,1.7437,4.46062,.36828,1.74041,4.4581,.36919,1.71869,4.4407,.33743,1.7156,4.48396,.38399,1.73938,4.48159,.39157,1.71611,4.54918,.22557,1.53118,4.51955,.22851,1.56782};
			return value;
		}
		private double[] getlfmphal4_Coord_7_60_point_2()
		{
			double[] value = {4.59711,.22818,1.5262,4.54296,.22293,1.56522,4.54415,.21688,1.54344,4.59711,.22835,1.55921,4.55878,.43016,1.6285,4.53382,.43352,1.63427,4.57101,.46795,1.57099,4.52913,.47891,1.58992,4.53075,.45604,1.60649,4.56614,.45288,1.59291,4.61902,.24821,1.71398,4.66505,.26279,1.73484,4.64206,.23283,1.73773,4.45646,.31149,1.74302,4.44714,.38076,1.68026,4.42003,.34097,1.67992,4.62855,.32602,1.63105,4.61402,.36316,1.64149,4.59952,.43957,1.54474,4.60577,.35896,1.75394,4.59482,.23639,1.58942,4.54993,.22747,1.59599,4.49367,.45566,1.61207,4.5009,.43254,1.63745,4.46485,.42372,1.64535,4.6284,.4121,1.54909,4.63133,.33701,1.51859,4.60405,.44286,1.5585,4.59832,.42956,1.57966,4.40964,.32586,1.55008,4.52337,.22146,1.54561,4.52426,.28047,1.92155,4.52599,.26075,1.91635,4.51647,.24134,1.94018,4.51392,.25993,1.97336,4.54126,.23193,1.97632,4.52249,.26742,1.97795,4.51923,.28508,1.90961,4.52294,.28546,1.92279,4.65326,.25768,1.93095,4.67067,.27818,1.9056,4.65049,.26873,1.94305,4.54078,.221,1.9673,4.57594,.22935,1.96424,4.57278,.24113,1.97115,4.53718,.22612,1.97163,4.44225,.3205,1.87855,4.48571,.37626,1.88211,4.42238,.32377,1.86494,4.47164,.3862,1.86263,4.64131,.24218,1.77109,4.66113,.2588,1.7692,4.65283,.22492,1.77847,4.67581,.24688,1.77871,4.48048,.23214,1.77673,4.53424,.23078,1.76391,4.48125,.22141,1.78523,4.53688,.21335,1.77019,4.4421,.24438,1.80977,4.43973,.25133,1.80396,4.44818,.38031,1.84388,4.44579,.36686,1.8285,4.41516,.32053,1.84265,4.41551,.32323,1.8545,4.62172,.25577,1.77567,4.63088,.26834,1.77678,4.6517,.31828,1.76671,4.63284,.29164,1.77877,4.61275,.31661,1.78159,4.40932,.30191,1.84122,4.47879,.31971,1.82262,4.46993,.29679,1.82678,4.46562,.28006,1.81891,4.47857,.26546,1.80259,4.49938,.33776,1.81418,4.4966,.31751,1.81888,4.6041,.29861,1.78957,4.5073,.26761,1.94415,4.5105,.24889,1.95652,4.50574,.29014,1.95079,4.43779,.29934,1.87477,4.495,.31483,1.8983,4.49219,.2918,1.89062,4.66275,.31048,1.9133,4.65013,.29095,1.95115,4.51365,.24775,1.95115,4.55353,.20275,1.91971,4.59519,.20215,1.91279,4.58436,.25159,1.77377,4.59864,.22924,1.76594,4.54687,.24803,1.77398,4.54887,.28337,1.9766,4.56954,.28846,1.97328,4.55903,.33105,1.94343,4.52141,.3095,1.9147,4.52974,.30657,1.92615,4.56266,.32782,1.91865,4.55791,.33723,1.90923,4.61551,.3341,1.91128,4.61402,.34008,1.89786};
			return value;
		}
		private double[] getlfmphal4_Coord_7_60_point_3()
		{
			double[] value = {4.52793,.25396,1.9141,4.52987,.24133,1.8901,4.53657,.23623,1.90265,4.52455,.26368,1.90148,4.62532,.23936,1.89389,4.59707,.22041,1.88849,4.59606,.22581,1.87114,4.62441,.24307,1.86767,4.63087,.2194,1.91256,4.51133,.26324,1.94085,4.52103,.23414,1.9352,4.53448,.21947,1.92897,4.62763,.33675,1.93017,4.6214,.29953,1.96336,4.52492,.37296,1.79555,4.5913,.36518,1.77481,4.53832,.34823,1.79652,4.58168,.34293,1.78726,4.67345,.28182,1.76871,4.40373,.28257,1.83882,4.58884,.2659,1.78449,4.41635,.30194,1.86295,4.40351,.28031,1.84708,4.41627,.27945,1.85538,4.4074,.30084,1.85104,4.43788,.27749,1.86575,4.46451,.23974,1.83348,4.50476,.2459,1.86571,4.49378,.2729,1.88122,4.44952,.23875,1.81878,4.49199,.221,1.79545,4.61193,.35164,1.8771,4.64843,.31568,1.88131,4.6566,.32505,1.85798,4.6355,.23317,1.83994,4.60126,.21128,1.80906,4.65006,.22281,1.81431,4.59746,.22247,1.84261,4.67492,.3275,1.83647,4.6189,.37709,1.85437,4.55555,.35479,1.89088,4.55277,.22581,1.84315,4.5032,.22281,1.81313,4.54476,.21243,1.80243,4.52616,.34951,1.89724,4.59557,.27946,1.78991,4.66235,.24675,1.90591,4.64278,.26066,1.89263,4.66216,.28704,1.85385,4.65239,.256,1.84776,4.68678,.27223,1.82346,4.67237,.24515,1.81824,4.55052,.25998,1.78224,4.56091,.22344,1.8745,4.6124,.25534,1.96157,4.57491,.32634,1.79429,4.55474,.27365,1.79225,4.55908,.28795,1.80303,4.53489,.3318,1.80293,4.48612,.27974,1.81286,4.51042,.26313,1.79314,4.50255,.2523,1.78737,4.5314,.31258,1.81137,4.69334,.2745,1.80081,4.67549,.33464,1.81258,4.55166,.38839,1.86825,4.54501,.39609,1.84647,4.60926,.24047,1.95523,4.52478,.30069,1.92645,4.4828,.47569,1.59852,4.59218,.41063,1.61848,4.36865,.35414,1.58466,4.36803,.38375,1.59196,4.44366,.45827,1.58094,4.6266,.2865,1.51299,4.38197,.34487,1.60668,4.39771,.34846,1.64562,4.38023,.36648,1.61292,4.39904,.32946,1.63878,4.42926,.39942,1.6451,4.62394,.28557,1.54198,4.61803,.2831,1.58406,4.52633,.23281,1.59924,4.56267,.23912,1.63503,4.54935,.25124,1.6721,4.53611,.24476,1.64267,4.57341,.24655,1.66712,4.51831,.37915,1.78542,4.47513,.40645,1.67878,4.54163,.24424,1.75959,4.59124,.29916,1.78963,4.56567,.26593,1.78179,4.4227,.32126,1.67511,4.44489,.31437,1.70907,4.62983,.31372,1.66887,4.6365,.32087,1.71484,4.62272,.33602,1.69502,4.61794,.28198,1.63144,4.59497,.24456,1.6341,4.50625,.27054,1.65061};
			return value;
		}
		private double[] getlfmphal4_Coord_7_60_point_4()
		{
			double[] value = {4.45057,.29506,1.66204,4.51248,.30156,1.95426,4.54041,.21098,1.78326,4.60218,.21099,1.78834,4.65381,.22207,1.79388,4.67709,.24429,1.79681,4.61623,.3842,1.83109,4.5293,.38894,1.80832,4.60137,.37859,1.78469,4.69175,.27669,1.78002,4.52467,.29285,1.81256,4.49169,.29553,1.82123,4.51985,.27812,1.80258,4.56674,.30752,1.80277,4.56306,.21881,1.89067,4.6426,.26211,1.87088,4.6534,.28751,1.87554,4.64786,.31311,1.89897,4.65274,.28691,1.89281,4.67066,.32882,1.77621,4.59809,.21417,1.77302};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfpprox_Geo_6_65_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,4,-1,0,5,3,-1,6,7,8,-1,9,10,2,-1,11,7,12,-1,11,10,7,-1,6,13,7,-1,14,15,16,-1,17,18,19,-1,19,20,17,-1,19,21,22,-1,23,24,25,-1,24,18,25,-1,26,15,14,-1,27,28,29,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,34,37,35,-1,29,28,35,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,42,51,-1,12,52,11,-1,52,53,11,-1,0,2,5,-1,13,54,55,-1,13,56,54,-1,57,58,59,-1,58,60,59,-1,59,61,62,-1,59,60,61,-1,63,64,65,-1,65,66,63,-1,67,68,69,-1,70,50,71,-1,72,67,69,-1,50,68,42,-1,12,73,52,-1,73,55,74,-1,75,76,77,-1,76,78,77,-1,79,80,81,-1,79,82,80,-1,83,71,84,-1,41,43,85,-1,86,87,88,-1,74,52,73,-1,74,89,52,-1,3,90,91,-1,4,75,92,-1,8,92,6,-1,66,93,63,-1,47,94,66,-1,94,95,66,-1,96,57,97,-1,57,59,97,-1,98,99,100,-1,100,101,98,-1,102,100,99,-1,102,103,100,-1,104,105,54,-1,54,45,104,-1,46,56,106,-1,107,65,64,-1,108,48,109,-1,70,71,110,-1,58,111,112,-1,112,60,58,-1,113,114,115,-1,116,30,32,-1,117,32,34,-1,118,119,36,-1,120,121,122,-1,123,124,22,-1,22,21,123,-1,20,125,17,-1,125,126,17,-1,127,16,15,-1,39,38,128,-1,23,14,129,-1,129,130,131,-1,129,132,130,-1,133,130,132,-1,132,134,133,-1,135,136,137,-1,138,139,140,-1,139,67,140,-1,141,37,142,-1,141,35,37,-1,143,144,141,-1,27,29,145,-1,146,147,148,-1,149,150,147,-1,150,148,147,-1,61,151,152,-1,152,153,61,-1,154,155,156,-1,157,153,158,-1,153,152,158,-1,159,160,72,-1,160,161,72,-1,162,141,144,-1,143,141,142,-1,137,163,135,-1,136,31,33,-1,33,164,136,-1,132,14,16,-1,132,129,14,-1,165,166,167,-1,128,17,126,-1,21,24,168,-1,168,123,21,-1,124,27,22,-1,169,158,170,-1,156,155,167,-1,171,172,173,-1,173,174,171,-1,175,176,177,-1,121,120,118,-1,119,34,36,-1,119,117,34,-1,32,117,116,-1,30,174,178,-1,30,116,174,-1,173,179,180,-1,181,110,71,-1,49,182,183,-1,184,107,64,-1,64,185,184,-1,56,46,45,-1,41,85,186,-1,186,187,41,-1,66,188,93,-1,66,95,188,-1,77,94,75,-1,94,92,75,-1,9,2,1,-1,189,147,76,-1,147,190,76,-1,2,11,53,-1,191,192,91,-1,191,193,192,-1,194,71,50,-1,62,195,97,-1,81,80,112,-1,80,151,112,-1,195,196,83,-1,197,198,51,-1,197,199,198,-1,159,72,200,-1,200,196,159,-1,71,83,181,-1,61,196,62,-1,196,195,62,-1,193,191,43,-1,191,85,43,-1,115,64,63,-1,115,185,64,-1,66,65,48,-1,48,47,66,-1,6,106,13,-1,106,56,13,-1,89,85,191,-1,89,186,85,-1,201,5,2,-1,202,195,83,-1,103,203,100,-1,103,184,203,-1,48,65,109,-1,65,107,109,-1,44,46,183,-1,51,41,197,-1,51,42,41,-1,71,194,84,-1,45,54,56,-1,97,59,62,-1,164,137,136,-1,118,36,28,-1,36,35,28,-1,118,27,121,-1,118,28,27,-1,118,120,204,-1,155,154,127,-1,38,165,26,-1,19,22,20,-1,19,18,21,-1,18,24,21,-1,16,127,154,-1,12,7,73,-1,2,10,11,-1,8,7,9,-1,7,10,9,-1,4,3,75,-1,90,52,91,-1,2,53,201,-1,90,53,52,-1,201,53,90,-1,205,206,134,-1,205,207,206,-1,167,208,156,-1,167,166,208,-1,26,23,25,-1,26,14,23,-1,155,15,26,-1,127,15,155,-1,168,23,209,-1,23,168,24,-1,204,210,211,-1,204,120,210,-1,130,212,131,-1,212,130,213,-1,178,214,215,-1,180,214,178,-1,123,122,124,-1,122,123,216,-1,180,133,214,-1,133,180,179,-1,122,27,124,-1,27,122,121,-1,207,217,206,-1,207,218,217,-1,219,220,221,-1,220,219,222,-1,223,224,225,-1,224,223,226,-1,227,141,162,-1,227,228,141,-1,229,108,102,-1,229,182,108,-1,99,230,231,-1,98,230,99,-1,194,232,84,-1,198,232,194,-1,233,41,187,-1,197,41,233,-1,45,234,104,-1,234,45,44,-1,183,106,49,-1,183,46,106,-1,103,107,184,-1,109,107,103,-1,101,203,96,-1,100,203,101,-1,195,235,97,-1,235,195,202,-1,1,4,92,-1};
			return value;
		}
		private int[] getlfpprox_Geo_6_65_coordIndex_2()
		{
			int[] value = {4,1,0,-1,83,232,202,-1,83,84,232,-1,43,68,193,-1,42,68,43,-1,89,105,186,-1,74,105,89,-1,47,106,6,-1,47,49,106,-1,185,114,236,-1,185,115,114,-1,200,83,196,-1,181,83,200,-1,202,237,235,-1,232,237,202,-1,72,181,200,-1,72,110,181,-1,112,61,60,-1,112,151,61,-1,149,189,192,-1,147,189,149,-1,78,238,82,-1,78,239,238,-1,88,82,238,-1,82,88,80,-1,79,94,77,-1,94,79,95,-1,188,112,111,-1,188,81,112,-1,113,188,111,-1,188,113,93,-1,230,197,233,-1,199,197,230,-1,104,186,105,-1,104,187,186,-1,183,229,44,-1,182,229,183,-1,68,139,193,-1,68,67,139,-1,174,180,178,-1,174,173,180,-1,216,175,210,-1,175,216,176,-1,240,177,212,-1,240,175,177,-1,213,173,172,-1,213,179,173,-1,117,241,116,-1,241,117,119,-1,171,240,172,-1,171,211,240,-1,116,171,174,-1,171,116,241,-1,239,208,238,-1,239,156,208,-1,158,88,87,-1,158,152,88,-1,224,170,222,-1,224,169,170,-1,125,22,242,-1,22,125,20,-1,222,243,220,-1,243,222,170,-1,244,208,166,-1,86,208,244,-1,220,244,40,-1,220,243,244,-1,126,39,128,-1,126,221,39,-1,245,163,137,-1,245,246,163,-1,144,246,247,-1,163,246,144,-1,136,143,142,-1,136,135,143,-1,140,248,247,-1,140,161,248,-1,29,141,228,-1,29,35,141,-1,249,161,160,-1,249,248,161,-1,153,160,159,-1,160,153,157,-1,249,157,250,-1,157,249,160,-1,227,250,226,-1,250,227,249,-1,29,223,145,-1,223,29,228,-1,217,33,215,-1,164,33,217,-1,251,218,207,-1,251,252,218,-1,134,214,133,-1,134,206,214,-1,253,251,254,-1,146,251,253,-1,253,239,190,-1,156,239,253,-1,138,149,139,-1,149,138,150,-1,61,159,196,-1,61,153,159,-1,148,245,252,-1,148,150,245,-1,146,190,147,-1,190,146,253,-1,254,207,205,-1,251,207,254,-1,206,215,214,-1,206,217,215,-1,146,252,251,-1,146,148,252,-1,252,137,218,-1,252,245,137,-1,242,27,145,-1,27,242,22,-1,145,225,242,-1,145,223,225,-1,226,169,224,-1,226,250,169,-1,250,158,169,-1,250,157,158,-1,249,162,248,-1,249,227,162,-1,72,140,67,-1,140,72,161,-1,136,37,31,-1,37,136,142,-1,143,163,144,-1,135,163,143,-1,138,247,246,-1,138,140,247,-1,150,246,245,-1,150,138,246,-1,129,209,23,-1,129,131,209,-1,166,40,244,-1,166,38,40,-1,165,38,166,-1,154,205,16,-1,154,254,205,-1,243,86,244,-1,243,87,86,-1,87,170,158,-1,87,243,170,-1,221,125,219,-1,221,126,125,-1,219,242,225,-1,242,219,125,-1,238,86,88,-1,238,208,86,-1,241,211,171,-1,211,241,204,-1,118,241,119,-1,204,241,118,-1,172,212,213,-1,172,240,212,-1,122,210,120,-1,210,122,216,-1,114,111,58,-1,114,113,111,-1,191,52,89,-1,91,52,191,-1,149,193,139,-1,193,149,192,-1,102,109,103,-1,108,109,102,-1,44,231,234,-1,44,229,231,-1,185,203,184,-1,203,185,236,-1,231,233,234,-1,231,230,233,-1,236,96,203,-1,236,57,96,-1,235,98,101,-1,98,235,237,-1,92,47,6,-1,47,92,94,-1,63,113,115,-1,113,63,93,-1,95,81,188,-1,81,95,79,-1,152,80,88,-1,152,151,80,-1,78,190,239,-1,76,190,78,-1,192,3,91,-1,189,3,192,-1,247,162,144,-1,247,248,162,-1,82,77,78,-1,77,82,79,-1,189,75,3,-1,189,76,75,-1,73,13,55,-1,7,13,73,-1,70,72,69,-1,110,72,70,-1,50,69,68,-1,69,50,70,-1,236,58,57,-1,236,114,58,-1,74,54,105,-1,55,54,74,-1,198,50,51,-1,198,194,50,-1,3,201,90,-1,3,5,201,-1,8,1,92,-1,8,9,1,-1,97,101,96,-1,101,97,235,-1,234,187,104,-1,233,187,234,-1,198,237,232,-1,198,199,237,-1,98,199,230,-1,98,237,199,-1,102,231,229,-1,99,231,102,-1,48,182,49,-1,108,182,48,-1,228,226,223,-1,226,228,227,-1,225,222,219,-1,222,225,224,-1,221,40,39,-1,40,221,220,-1,218,164,217,-1,218,137,164,-1,209,176,168,-1,209,177,176,-1,216,168,176,-1,216,123,168,-1,37,32,31,-1,32,37,34,-1,30,215,33,-1,178,215,30,-1,133,213,130,-1,213,133,179,-1,131,177,209,-1,177,131,212,-1,240,210,175,-1,211,210,240,-1,25,38,26,-1,128,38,25,-1,26,167,155,-1,26,165,167,-1};
			return value;
		}
		private int[] getlfpprox_Geo_6_65_coordIndex_3()
		{
			int[] value = {128,18,17,-1,128,25,18,-1,254,156,253,-1,156,254,154,-1,16,134,132,-1,16,205,134,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfpprox_Coord_7_65_point_1()
		{
			double[] value = {2.51073,.39016,2.93257,2.48823,.41219,2.97327,2.57836,.3523,2.96568,2.54168,.34527,2.87137,2.4885,.39182,2.91872,2.55568,.34992,2.89982,2.46019,.44112,3.04757,2.55893,.32162,3.03881,2.49402,.39264,3.02007,2.51586,.39435,3.00638,2.57417,.33302,3.0148,2.58705,.27636,2.98523,2.57647,.25094,2.99011,2.56402,.32785,3.08097,2.20875,.62594,2.23445,2.24838,.62725,2.27257,2.32788,.62446,2.26746,1.99433,.51401,2.04858,1.99139,.527,2.04038,1.97773,.44421,1.9877,1.96825,.43523,2.00712,1.98358,.44431,1.978,1.98561,.32758,1.96402,2.08546,.60485,2.11196,2.0029,.52721,2.02947,2.07487,.60347,2.12843,2.20696,.62552,2.27584,2.04085,.28469,1.92861,2.17913,.23712,1.96656,2.16529,.19315,1.97853,2.59631,.35884,2.03123,2.52939,.25196,1.99628,2.51847,.258,1.99185,2.60483,.35388,2.03665,2.43128,.20545,1.98607,2.29846,.20375,1.96867,2.3,.21391,1.9672,2.43343,.19446,1.99111,2.18853,.60052,2.26979,2.08555,.55788,2.19722,2.1058,.51998,2.24746,2.46794,.15777,2.80606,2.44454,.18514,2.76997,2.50908,.20684,2.7738,2.41273,.24405,3.07392,2.50096,.23063,3.0694,2.4774,.34359,3.09829,2.33474,.42636,3.01127,2.32202,.40734,3.03808,2.34684,.41482,3.03476,2.37062,.21341,2.7902,2.38626,.18159,2.84645,2.5748,.22471,2.92619,2.58261,.26419,2.94307,2.58376,.21151,3.0593,2.59314,.21836,3.05049,2.55417,.3231,3.08727,2.08446,.0962,2.89059,2.07007,.11002,2.89271,2.09689,.12932,2.84385,2.08219,.14572,2.85083,2.09631,.17888,2.79864,2.10721,.15923,2.80947,2.12744,.29723,3.09029,2.14193,.28864,3.10117,2.21539,.3696,3.07056,2.20915,.37509,3.05353,2.4293,.20921,2.63753,2.43771,.20059,2.76448,2.38814,.20285,2.68807,2.34256,.21534,2.74993,2.29727,.22783,2.81179,2.29208,.21775,2.66216,2.58717,.2238,2.9978,2.5884,.14726,2.95605,2.46428,.41165,2.91007,2.45425,.40196,2.84569,2.34524,.41551,2.90942,2.3514,.41941,2.84784,2.22414,.36851,2.90412,2.12841,.31165,2.83612,2.11308,.31541,2.89716,2.22582,.37127,2.84313,2.23436,.19185,2.80949,2.29243,.21162,2.84499,2.52574,.17129,2.81303,2.14259,.40071,2.49524,2.11918,.36722,2.48405,2.14057,.34694,2.66671,2.55577,.1548,2.87129,2.55636,.27253,2.88434,2.55416,.25695,2.86631,2.45786,.42016,2.97401,2.11191,.30576,3.05799,2.33926,.41162,2.97099,2.22261,.36579,2.9651,2.15946,.09803,2.9007,2.16633,.11842,2.8503,2.30952,.18238,2.94145,2.31147,.18794,3.00608};
			return value;
		}
		private double[] getlfpprox_Coord_7_65_point_2()
		{
			double[] value = {2.2446,.1612,3.0036,2.24077,.13871,2.92033,2.31855,.25392,3.07499,2.25581,.21492,3.08852,2.50269,.13742,2.96891,2.5768,.13669,2.96117,2.45312,.43175,3.06061,2.1925,.32066,3.09695,2.3239,.35405,3.07046,2.25795,.3386,3.09578,2.29454,.22279,2.73698,2.05466,.19192,2.93859,2.06528,.20853,2.88088,2.05764,.20523,3.0342,2.06862,.11638,2.99771,2.0687,.1831,3.06979,2.41813,.33725,2.07219,2.40989,.26463,2.02103,2.17876,.2537,1.97009,2.28237,.24418,2.00675,2.14831,.32511,2.02693,2.05275,.29129,1.92977,2.02354,.34384,1.93996,1.99531,.44446,1.95861,2.00798,.34162,1.93965,1.94937,.41723,2.04596,1.99964,.50471,2.08955,2.33308,.59674,2.33817,2.08325,.58399,2.15046,2.21074,.6346,2.15707,2.29927,.64936,2.14054,2.20915,.65023,2.11183,2.30994,.64746,2.1694,2.43609,.64029,2.16065,2.43495,.62841,2.1938,2.5451,.19532,2.14511,2.53907,.22574,2.07484,2.59497,.35988,2.18717,2.49208,.23398,2.44816,2.49376,.22611,2.63438,2.41918,.19571,2.42898,2.2936,.16439,2.05598,2.4433,.1765,2.06351,2.46685,.1527,2.12432,2.45247,.16843,2.16794,2.02005,.23403,1.98538,2.48824,.41699,2.4989,2.51139,.35099,2.68984,2.51552,.37786,2.48788,2.52703,.28602,2.6702,2.51867,.30657,2.46745,2.08098,.22497,2.82333,2.09488,.23913,2.6348,2.10095,.19519,2.6264,2.365,.56637,2.37115,2.32436,.56911,2.38833,2.34663,.50093,2.51832,2.09383,.20781,2.43814,2.06843,.2577,2.44854,2.1692,.16982,2.64299,2.15471,.19101,2.44037,2.29485,.1973,2.43497,2.29494,.17211,2.14394,2.53231,.20972,2.19531,2.60022,.35831,2.10724,2.2155,.59496,2.30555,2.23106,.54167,2.37039,2.29514,.55706,2.38279,2.00073,.52963,2.00387,2.01762,.26775,2.2521,2.02604,.29738,2.27402,2.26828,.44777,2.11408,2.27575,.54845,2.12466,2.42836,.54792,2.14615,2.4276,.46417,2.11946,2.11546,.54247,2.08196,2.01194,.5332,2.00363,2.0964,.6153,2.0744,2.60377,.47992,2.05905,2.43292,.63343,2.1491,2.56074,.55612,2.10437,2.2551,.2015,2.76231,2.34717,.35135,3.07113,2.401,.34523,3.07856,2.16918,.18343,3.08378,2.08332,.17544,3.0767,2.5423,.14221,2.8707,2.49001,.14117,2.87683,2.10507,.3124,2.95836,2.52861,.34178,2.82055,2.45662,.42109,2.69682,2.53738,.19555,2.826,2.54282,.2714,2.79772,2.51695,.23297,2.76897,2.31488,.21531,2.84238,2.17566,.15007,2.81241,2.17691,.15946,2.80151,2.38742,.17425,2.85634,2.3228,.19922,2.89035,2.32449,.19545,2.90074};
			return value;
		}
		private double[] getlfpprox_Coord_7_65_point_3()
		{
			double[] value = {2.21317,.17521,2.71282,2.56728,.29457,2.90701,2.23895,.16713,2.86446,2.16911,.11126,2.99847,2.19142,.32609,2.04346,2.43264,.6025,2.26596,2.55616,.53612,2.16834,2.54439,.50894,2.23219,2.23733,.47184,2.51693,2.09211,.62047,2.08171,2.12532,.43533,2.05932,2.19666,.44155,2.08669,2.21246,.64366,2.10375,2.3022,.64093,2.13101,2.56868,.55741,2.11237,2.61231,.4788,2.06565,2.00997,.44637,1.95906,2.59865,.46509,2.13605,2.58401,.44726,2.21537,1.95814,.36877,2.12589,2.04846,.43477,2.22526,2.01384,.47267,2.16195,1.98952,.337,2.19661,2.01326,.20212,2.08342,1.98716,.26503,2.17024,1.95706,.26924,2.09922,2.03072,.20734,2.15896,2.15644,.17102,2.14499,2.15566,.16095,2.06184,2.34421,.25586,3.07317,2.33189,.18434,2.93986,2.33579,.1893,3.00431,2.30113,.19684,2.89248,2.40308,.1604,2.90912,2.40829,.15761,2.98093,2.2401,.15867,2.87914,2.08302,.10529,3.00143,2.30342,.19304,2.90378,2.23994,.41053,2.68969,2.35591,.44419,2.69693,2.19545,.54547,2.10331,2.26819,.32781,2.07284,1.95675,.29953,2.01823,2.08443,.38851,2.31058,2.13426,.4609,2.3367,2.54757,.33405,2.32266,2.51967,.22258,2.29396,2.43843,.17654,2.27062,2.29661,.17983,2.23188,2.15752,.1811,2.22812,2.04844,.21257,2.2345,2.51348,.46146,2.35664,2.54149,.40585,2.34712,2.43131,.47907,2.50928,2.42537,.54741,2.3704};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfpprox2_Geo_6_70_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,22,23,24,-1,23,25,26,-1,23,22,25,-1,27,23,28,-1,29,30,31,-1,32,33,34,-1,35,36,9,-1,37,0,2,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,46,-1,49,50,51,-1,52,50,53,-1,54,50,55,-1,56,57,51,-1,56,58,57,-1,3,59,60,-1,3,61,59,-1,4,62,5,-1,63,64,65,-1,63,66,64,-1,67,68,69,-1,67,70,68,-1,71,72,73,-1,73,74,71,-1,2,41,43,-1,75,76,77,-1,75,37,76,-1,78,79,80,-1,80,14,78,-1,81,82,24,-1,83,84,85,-1,85,86,83,-1,87,88,89,-1,87,12,88,-1,90,91,92,-1,91,93,92,-1,21,94,95,-1,94,96,95,-1,97,76,43,-1,97,78,76,-1,75,98,99,-1,98,100,99,-1,101,31,102,-1,103,39,38,-1,104,0,105,-1,104,106,0,-1,56,54,58,-1,54,107,58,-1,108,45,109,-1,66,45,64,-1,44,46,48,-1,110,45,111,-1,112,113,114,-1,113,115,114,-1,8,116,117,-1,69,118,67,-1,71,119,120,-1,72,11,121,-1,121,122,72,-1,11,10,121,-1,123,36,124,-1,125,126,127,-1,128,96,129,-1,128,130,96,-1,36,123,9,-1,21,20,15,-1,20,131,15,-1,74,119,71,-1,71,125,127,-1,132,74,133,-1,132,119,74,-1,67,133,74,-1,134,69,135,-1,83,8,84,-1,83,116,8,-1,136,137,68,-1,68,138,136,-1,138,139,136,-1,138,140,139,-1,141,142,73,-1,143,142,144,-1,142,141,144,-1,111,45,44,-1,46,66,47,-1,64,45,108,-1,109,45,110,-1,24,82,65,-1,65,22,24,-1,145,3,5,-1,145,146,3,-1,102,30,34,-1,38,40,1,-1,147,4,105,-1,147,62,4,-1,37,43,76,-1,37,2,43,-1,82,63,65,-1,82,148,63,-1,47,78,48,-1,47,79,78,-1,15,17,21,-1,17,94,21,-1,149,150,13,-1,151,98,152,-1,98,153,152,-1,133,67,118,-1,80,148,82,-1,82,81,80,-1,99,147,75,-1,147,37,75,-1,62,154,28,-1,155,97,43,-1,127,126,9,-1,9,11,127,-1,63,47,66,-1,51,50,56,-1,148,79,47,-1,47,63,148,-1,48,101,102,-1,102,44,48,-1,4,3,60,-1,56,50,54,-1,55,50,52,-1,53,50,49,-1,80,79,148,-1,106,49,156,-1,46,45,66,-1,102,31,30,-1,43,42,155,-1,97,48,78,-1,125,71,120,-1,117,116,157,-1,29,40,39,-1,32,103,158,-1,26,145,23,-1,26,146,145,-1,27,24,23,-1,145,28,23,-1,123,10,9,-1,159,93,152,-1,70,73,142,-1,97,101,48,-1,92,159,113,-1,92,93,159,-1,112,160,161,-1,112,162,160,-1,149,12,87,-1,149,13,12,-1,163,164,165,-1,166,164,163,-1,24,167,81,-1,167,24,27,-1,146,166,168,-1,166,146,26,-1,169,32,158,-1,32,169,163,-1,39,32,29,-1,39,103,32,-1,170,125,120,-1,86,125,170,-1,171,116,83,-1,171,157,116,-1,158,38,172,-1,38,158,103,-1,155,29,31,-1,42,29,155,-1,53,106,104,-1,53,49,106,-1,60,173,4,-1,60,174,173,-1,58,59,175,-1,59,58,107,-1,57,176,156,-1,177,176,57,-1,177,178,172,-1,178,177,175,-1,40,2,1,-1,40,41,2,-1,179,44,102,-1,111,44,179,-1,109,180,181,-1,109,110,180,-1,182,64,108,-1,64,182,65,-1,176,172,38,-1,177,172,176,-1,72,127,11,-1,72,71,127,-1,9,85,35,-1,126,85,9,-1,8,183,84,-1,8,7,183,-1,117,137,184,-1,117,135,137,-1,99,62,147,-1,154,62,99,-1,133,185,132,-1,133,118,185,-1,100,151,186,-1,100,98,151,-1,152,13,150,-1,152,153,13,-1,128,187,188,-1,129,187,128,-1,189,190,191,-1,192,190,189,-1,115,16,18,-1,115,193,16,-1,130,192,194,-1,130,190,192,-1,90,161,195,-1,92,161,90,-1,12,80,88,-1,80,12,14,-1,88,81,187,-1,81,88,80,-1,188,81,167,-1,188,187,81,-1,196,167,154,-1,196,188,167,-1,37,105,0,-1,37,147,105,-1,173,55,52,-1,55,173,174,-1,178,158,172,-1,169,158,178,-1,3,168,61,-1,146,168,3,-1,62,145,5,-1,28,145,62,-1,25,65,182,-1,22,65,25,-1,165,181,180,-1,164,181,165,-1,114,18,124,-1,18,114,115,-1,7,197,183,-1,7,162,197,-1,144,194,143,-1,194,144,95,-1};
			return value;
		}
		private int[] getlfpprox2_Geo_6_70_coordIndex_2()
		{
			int[] value = {198,191,190,-1,198,186,191,-1,194,140,143,-1,194,192,140,-1,189,195,139,-1,189,90,195,-1,143,138,142,-1,143,140,138,-1,195,160,199,-1,195,161,160,-1,139,199,136,-1,139,195,199,-1,184,136,199,-1,137,136,184,-1,134,117,157,-1,134,135,117,-1,118,134,185,-1,134,118,69,-1,170,119,132,-1,170,120,119,-1,197,124,36,-1,124,197,114,-1,94,129,96,-1,94,89,129,-1,122,144,141,-1,122,19,144,-1,17,89,94,-1,17,87,89,-1,77,98,75,-1,77,153,98,-1,126,86,85,-1,126,125,86,-1,10,20,121,-1,131,20,10,-1,19,95,144,-1,19,21,95,-1,122,73,72,-1,122,141,73,-1,36,183,197,-1,36,35,183,-1,157,185,134,-1,185,157,171,-1,6,199,160,-1,184,199,6,-1,142,68,70,-1,142,138,68,-1,139,192,189,-1,140,192,139,-1,186,91,191,-1,151,91,186,-1,190,128,198,-1,190,130,128,-1,162,114,197,-1,162,112,114,-1,159,150,193,-1,159,152,150,-1,33,180,179,-1,165,180,33,-1,181,25,182,-1,164,25,181,-1,169,61,168,-1,169,178,61,-1,51,156,49,-1,156,51,57,-1,107,55,174,-1,54,55,107,-1,173,105,4,-1,173,104,105,-1,0,156,176,-1,156,0,106,-1,154,100,196,-1,154,99,100,-1,14,153,77,-1,14,13,153,-1,193,149,16,-1,149,193,150,-1,152,91,151,-1,152,93,91,-1,95,130,194,-1,95,96,130,-1,113,193,115,-1,113,159,193,-1,191,90,189,-1,191,91,90,-1,198,188,196,-1,128,188,198,-1,89,187,129,-1,89,88,187,-1,196,186,198,-1,196,100,186,-1,171,132,185,-1,132,171,170,-1,78,77,76,-1,77,78,14,-1,70,74,73,-1,74,70,67,-1,135,68,137,-1,135,69,68,-1,117,6,8,-1,117,184,6,-1,35,84,183,-1,35,85,84,-1,97,31,101,-1,97,155,31,-1,108,181,182,-1,108,109,181,-1,180,111,179,-1,180,110,111,-1,176,1,0,-1,176,38,1,-1,175,61,178,-1,61,175,59,-1,57,175,177,-1,175,57,58,-1,59,174,60,-1,59,107,174,-1,52,104,173,-1,52,53,104,-1,29,41,40,-1,29,42,41,-1,102,33,179,-1,33,102,34,-1,86,171,83,-1,86,170,171,-1,32,165,33,-1,163,165,32,-1,32,30,29,-1,32,34,30,-1,163,168,166,-1,163,169,168,-1,27,154,167,-1,27,28,154,-1,164,26,25,-1,26,164,166,-1,20,122,121,-1,122,20,19,-1,124,15,131,-1,15,124,18,-1,131,123,124,-1,131,10,123,-1,16,87,17,-1,16,149,87,-1,6,162,7,-1,160,162,6,-1,113,161,92,-1,112,161,113,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfpprox2_Coord_7_70_point_1()
		{
			double[] value = {3.28237,.17695,2.75895,3.26667,.15636,2.77787,3.25653,.17135,2.76181,3.29615,.27851,2.89454,3.28949,.27866,2.78615,3.28236,.30402,2.79473,3.12671,.34304,1.9217,3.09176,.33292,1.94167,3.10365,.35413,1.91383,2.85763,.4324,2.0237,2.86627,.41346,2.12782,2.80901,.49828,2.02536,3.08728,.31527,2.53902,3.09656,.30283,2.53541,3.09573,.286,2.61283,2.98266,.37968,2.2998,3.04002,.33432,2.35462,3.024,.35889,2.36579,3.00352,.35708,2.27361,2.95218,.47253,2.26014,2.93389,.43117,2.24535,2.98857,.44237,2.32833,3.1228,.32785,2.81141,3.18655,.33306,2.8045,3.09971,.35733,2.70444,3.1226,.30602,2.87982,3.18419,.29485,2.88265,3.17357,.37192,2.70713,3.23015,.34561,2.70253,3.17162,.18484,2.83168,3.11733,.1637,2.83381,3.12897,.1819,2.81812,3.17595,.15232,2.90504,3.11083,.13911,2.91765,3.12058,.14389,2.87447,2.9146,.39253,2.00536,2.91935,.38745,2.07567,3.24862,.22945,2.67911,3.27157,.10891,2.82921,3.22001,.14689,2.83045,3.21721,.16491,2.81649,3.21378,.17772,2.79468,3.1736,.19547,2.80416,3.16823,.21444,2.77444,3.04516,.15421,2.83458,3.02313,.2466,2.85376,3.0438,.21589,2.77386,3.03491,.28804,2.75068,3.06799,.2141,2.7609,3.31557,.18906,2.84949,3.32337,.20205,2.86041,3.31922,.18301,2.86439,3.31974,.21493,2.8496,3.31844,.20672,2.84362,3.32254,.21128,2.87861,3.32061,.22031,2.86366,3.32445,.19521,2.87872,3.31276,.14904,2.87738,3.31874,.18673,2.90257,3.32582,.22746,2.9313,3.31389,.26709,2.88275,3.30936,.23099,2.94572,3.25885,.33204,2.70015,3.03584,.3148,2.75048,3.0391,.30947,2.81904,3.05705,.32266,2.8183,3.02821,.29232,2.76542,3.12201,.66421,2.12916,3.22973,.62151,2.0755,3.21712,.61948,2.06565,3.12507,.66637,2.14057,2.82546,.59367,2.02166,2.82224,.59015,2.03936,2.97647,.68514,2.12593,2.98016,.68117,2.11436,3.22465,.26909,2.60293,3.17389,.24614,2.69039,3.16761,.26535,2.60648,3.1003,.27204,2.68991,3.06265,.3116,2.6902,3.06498,.34589,2.62294,3.08059,.39477,2.63723,3.07175,.35179,2.70341,2.98235,.41941,1.97433,2.98456,.39215,1.98872,2.91534,.40194,1.99493,2.91463,.45582,1.98365,3.05527,.33953,2.45546,3.05313,.36537,2.55279,3.04409,.38681,2.47378,3.1808,.36918,2.20732,3.1843,.34218,2.32408,3.14073,.33812,2.21045,3.13997,.32419,2.32639,3.02038,.41041,2.39829,3.04704,.52306,2.34548,3.06606,.49456,2.41534,3.09803,.20229,2.7647,3.21141,.29235,2.52169,3.25594,.3073,2.61227};
			return value;
		}
		private double[] getlfpprox2_Coord_7_70_point_2()
		{
			double[] value = {3.23356,.33293,2.53097,3.08095,.19034,2.78113,3.06119,.14254,2.83593,3.22033,.12708,2.87111,3.30847,.21627,2.80382,3.30292,.22788,2.75576,3.3009,.18521,2.80562,3.32525,.21819,2.90144,3.03648,.29966,2.87236,3.0333,.26683,2.91699,3.02587,.19117,2.95018,3.02749,.14342,2.91615,3.11075,.33519,2.10808,3.11198,.33458,2.21813,3.0229,.37587,2.16607,3.03865,.35799,2.24625,3.11512,.38989,1.91464,3.16127,.41716,1.88725,3.10987,.62605,2.09725,2.8905,.57431,2.0198,2.86928,.5207,1.99592,2.86366,.45074,2.1572,2.89968,.51505,2.17997,2.88652,.39274,2.09987,2.96364,.37839,2.20311,2.86402,.49896,1.99415,2.85995,.44385,2.01207,2.8122,.50441,2.00981,3.15171,.48244,2.48634,3.07936,.46695,2.4925,3.14229,.53029,2.408,2.93351,.40399,2.22657,2.96943,.54462,2.02837,3.06288,.64992,2.10532,3.16994,.52368,1.98557,3.20798,.51714,1.95306,3.23557,.49589,2.06104,3.22299,.5088,1.95765,3.21033,.60045,2.1397,3.218,.46848,2.13798,3.20486,.56889,2.22191,3.00277,.60996,2.20567,3.12635,.64378,2.19301,3.12267,.60564,2.27095,3.0265,.55941,2.27964,3.23331,.31908,2.80054,3.2401,.28901,2.88994,3.27036,.2721,2.69092,3.05467,.33333,2.69477,3.07131,.31591,2.44256,3.08468,.31538,2.44006,3.1993,.31757,2.42292,3.14702,.30127,2.42412,3.16102,.28457,2.52255,3.23949,.37187,2.62655,3.13785,.19317,2.79614,3.30438,.15656,2.84232,3.11915,.41915,1.91997,3.23144,.12326,2.9064,3.12163,.32238,2.32971,3.13004,.32259,1.98978,3.13797,.33964,2.10893,3.10378,.31842,1.99245,3.1778,.19735,2.9384,3.12007,.26825,2.93247,3.10898,.1897,2.95931,3.17987,.26099,2.92657,3.16578,.40105,2.63439,3.24328,.24714,2.94123,3.23198,.18376,2.9502,2.92691,.47633,1.98583,2.99271,.44115,1.97564,3.29282,.10125,2.89983,3.30693,.24484,2.81925,3.31802,.24047,2.87213,3.31517,.17579,2.93301,3.28992,.11966,2.83236,3.30816,.111,2.89124,3.29875,.17287,2.94564,3.04111,.13295,2.92232,3.04347,.18477,2.96385,3.05495,.27317,2.92818,3.05489,.31253,2.8743,2.98443,.38097,2.00014,3.17955,.40561,1.89294,3.04753,.52476,2.02443,3.22183,.36541,2.43172,3.0809,.43084,2.569,3.15981,.43467,2.56445,3.21413,.43763,2.22299,3.19332,.50404,2.37827,3.20776,.39789,2.33246,3.19959,.53646,2.30009,3.05821,.33507,2.34916,3.13181,.57574,2.32997,3.18092,.37858,2.1106,3.21982,.41173,2.55293,2.99315,.37236,2.04676,3.20757,.45787,2.46561,3.1926,.38603,1.98234};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfpprox3_Geo_6_75_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,7,8,9,-1,10,11,12,-1,11,13,12,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,36,39,37,-1,23,40,34,-1,40,41,42,-1,43,44,19,-1,44,17,19,-1,45,46,38,-1,47,48,49,-1,49,50,47,-1,51,52,53,-1,53,54,51,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,58,64,65,-1,66,67,57,-1,68,69,70,-1,69,71,70,-1,72,73,74,-1,72,75,73,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,83,74,84,-1,85,86,83,-1,87,88,89,-1,90,91,92,-1,91,93,92,-1,54,94,95,-1,96,97,57,-1,24,98,99,-1,100,101,102,-1,103,104,105,-1,106,107,108,-1,109,110,111,-1,110,112,111,-1,113,110,114,-1,110,115,114,-1,116,110,113,-1,117,118,119,-1,120,121,22,-1,98,33,122,-1,123,124,125,-1,29,26,1,-1,1,3,29,-1,50,126,58,-1,60,127,58,-1,58,128,129,-1,57,130,131,-1,56,96,57,-1,132,131,130,-1,130,133,132,-1,134,14,135,-1,134,136,14,-1,49,137,135,-1,53,94,54,-1,52,51,138,-1,51,139,138,-1,140,92,93,-1,93,4,140,-1,141,142,92,-1,72,74,83,-1,5,143,144,-1,5,87,143,-1,145,146,147,-1,145,62,146,-1,148,48,149,-1,149,61,148,-1,84,150,151,-1,150,7,151,-1,84,151,85,-1,85,83,84,-1,57,97,66,-1,55,57,131,-1,152,128,58,-1,58,65,59,-1,127,47,58,-1,152,58,126,-1,15,153,3,-1,153,29,3,-1,79,154,77,-1,22,155,120,-1,22,21,155,-1,155,21,156,-1,21,157,156,-1,114,115,158,-1,115,89,158,-1,159,160,161,-1,162,88,160,-1,88,161,160,-1,161,88,163,-1,88,87,163,-1,143,89,115,-1,143,87,89,-1,164,165,166,-1,164,39,165,-1,28,167,26,-1,135,137,134,-1,109,115,110,-1,109,143,115,-1,129,64,58,-1,57,67,168,-1,142,90,92,-1,169,170,75,-1,61,171,148,-1,61,63,171,-1,92,170,141,-1,92,140,170,-1,63,69,68,-1,68,139,63,-1,172,173,12,-1,173,95,12,-1,174,79,175,-1,174,154,79,-1,176,86,177,-1,177,70,176,-1,178,179,180,-1,180,181,178,-1,69,145,181,-1,181,71,69,-1,182,111,166,-1,182,8,111,-1,127,48,47,-1,127,149,48,-1,86,85,67,-1,85,168,67,-1,168,85,183,-1,85,151,183,-1,58,47,50,-1,184,118,37,-1,118,117,37,-1,114,185,113,-1,25,107,23,-1,33,35,122,-1,186,31,187,-1,165,39,36,-1,107,25,108,-1,34,33,23,-1,12,188,172,-1,12,13,188,-1,132,11,10,-1,2,1,91,-1,189,91,1,-1,91,189,93,-1,144,150,190,-1,144,191,150,-1,182,132,133,-1,182,11,132,-1,172,192,136,-1,172,188,192,-1,98,156,99,-1,98,155,156,-1,124,193,125,-1,193,124,194,-1,102,82,81,-1,101,82,102,-1,31,45,117,-1,31,186,45,-1,43,195,44,-1,195,43,104,-1,196,105,197,-1,105,196,198,-1,199,35,34,-1,200,35,199,-1,81,201,102,-1,81,202,201,-1,117,32,31,-1,117,119,32,-1,203,159,121,-1,203,160,159,-1,204,114,205,-1,114,204,185,-1,205,158,206,-1,114,158,205,-1,156,123,125,-1,157,123,156,-1,100,106,108,-1,100,207,106,-1,208,209,187,-1,210,209,208,-1,154,46,202,-1,154,174,46,-1,211,208,30,-1,211,212,208,-1,105,213,103,-1,213,105,198,-1,106,41,107,-1,210,41,106,-1,25,99,193,-1,99,25,24,-1,104,211,195,-1,103,211,104,-1,18,113,185,-1,113,18,116,-1,17,184,214,-1,17,118,184,-1,132,94,131,-1,132,10,94,-1,215,96,138,-1,96,215,97,-1,67,177,86,-1,66,177,67,-1,53,131,94,-1,53,55,131,-1,135,16,126,-1,14,16,135,-1,90,129,128,-1,90,142,129,-1,147,65,178,-1,65,147,59,-1,127,146,149,-1,60,146,127,-1,64,142,179,-1,142,64,129,-1,130,9,133,-1,130,183,9,-1,166,112,164,-1,166,111,112,-1,71,176,70,-1,71,169,176,-1,188,175,79,-1,175,188,13,-1,216,95,173,-1,95,216,54,-1,51,63,139,-1,51,171,63,-1,180,170,169,-1,141,170,180,-1,69,62,145,-1,69,63,62,-1,148,216,137,-1,148,171,216,-1,172,134,173,-1,134,172,136,-1,140,6,73,-1,4,6,140,-1};
			return value;
		}
		private int[] getlfpprox3_Geo_6_75_coordIndex_2()
		{
			int[] value = {73,170,140,-1,73,75,170,-1,179,141,180,-1,179,142,141,-1,158,88,162,-1,158,89,88,-1,109,144,143,-1,191,144,109,-1,26,161,163,-1,167,161,26,-1,217,187,209,-1,217,186,187,-1,42,198,218,-1,42,213,198,-1,184,39,164,-1,184,37,39,-1,20,28,21,-1,20,167,28,-1,159,167,20,-1,159,161,167,-1,196,206,219,-1,205,206,196,-1,200,121,120,-1,203,121,200,-1,21,27,157,-1,21,28,27,-1,175,36,174,-1,36,175,165,-1,80,124,123,-1,80,82,124,-1,174,38,46,-1,38,174,36,-1,152,2,128,-1,152,0,2,-1,183,57,168,-1,183,130,57,-1,8,109,111,-1,191,109,8,-1,15,76,153,-1,15,192,76,-1,87,189,163,-1,87,5,189,-1,181,147,178,-1,181,145,147,-1,68,177,215,-1,70,177,68,-1,190,73,6,-1,73,190,74,-1,62,149,146,-1,62,61,149,-1,10,95,94,-1,12,95,10,-1,13,165,175,-1,13,11,165,-1,11,166,165,-1,11,182,166,-1,0,126,16,-1,126,0,152,-1,77,202,81,-1,202,77,154,-1,153,27,29,-1,220,27,153,-1,78,153,76,-1,78,220,153,-1,19,197,43,-1,19,204,197,-1,116,112,110,-1,214,112,116,-1,197,205,196,-1,205,197,204,-1,33,24,23,-1,33,98,24,-1,212,210,208,-1,212,41,210,-1,30,195,211,-1,32,195,30,-1,207,102,201,-1,207,100,102,-1,25,194,108,-1,194,25,193,-1,138,68,215,-1,68,138,139,-1,163,1,26,-1,163,189,1,-1,74,150,84,-1,74,190,150,-1,221,219,206,-1,221,199,219,-1,176,83,86,-1,83,176,72,-1,220,80,123,-1,220,78,80,-1,78,81,80,-1,78,77,81,-1,192,79,76,-1,192,188,79,-1,137,173,134,-1,137,216,173,-1,169,181,180,-1,169,71,181,-1,169,72,176,-1,169,75,72,-1,54,171,51,-1,54,216,171,-1,44,118,17,-1,118,44,119,-1,214,164,112,-1,164,214,184,-1,146,59,147,-1,59,146,60,-1,178,64,179,-1,64,178,65,-1,50,135,126,-1,49,135,50,-1,128,91,90,-1,2,91,128,-1,66,215,177,-1,97,215,66,-1,138,56,52,-1,56,138,96,-1,7,183,151,-1,7,9,183,-1,55,52,56,-1,53,52,55,-1,137,48,148,-1,49,48,137,-1,214,18,17,-1,116,18,214,-1,40,218,34,-1,40,42,218,-1,213,41,212,-1,42,41,213,-1,107,40,23,-1,107,41,40,-1,209,201,217,-1,201,209,207,-1,103,212,211,-1,212,103,213,-1,38,117,45,-1,38,37,117,-1,203,199,221,-1,200,199,203,-1,187,30,208,-1,187,31,30,-1,207,210,106,-1,207,209,210,-1,101,108,194,-1,101,100,108,-1,220,157,27,-1,220,123,157,-1,221,160,203,-1,221,162,160,-1,18,204,19,-1,18,185,204,-1,162,206,158,-1,162,221,206,-1,20,121,159,-1,121,20,22,-1,218,199,34,-1,218,219,199,-1,186,46,45,-1,46,186,217,-1,155,122,120,-1,98,122,155,-1,198,219,218,-1,198,196,219,-1,105,43,197,-1,104,43,105,-1,195,119,44,-1,32,119,195,-1,217,202,46,-1,201,202,217,-1,82,194,124,-1,194,82,101,-1,125,99,156,-1,99,125,193,-1,120,35,200,-1,120,122,35,-1,136,15,14,-1,136,192,15,-1,133,8,182,-1,9,8,133,-1,7,191,8,-1,150,191,7,-1,144,6,5,-1,6,144,190,-1,5,93,189,-1,93,5,4,-1,3,16,15,-1,16,3,0,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfpprox3_Coord_7_75_point_1()
		{
			double[] value = {3.59902,.29066,2.45417,3.60085,.2924,2.36526,3.59958,.26349,2.43702,3.60535,.31622,2.37978,3.66004,.2447,2.41734,3.66251,.27162,2.34211,3.67393,.24228,2.41261,3.7646,.24268,2.36716,3.75561,.27798,2.30619,3.76588,.25192,2.3715,3.75466,.32738,2.43751,3.74202,.34277,2.34734,3.72483,.33526,2.44835,3.71331,.35738,2.36351,3.61519,.32679,2.4629,3.617,.35354,2.38158,3.61028,.32291,2.46061,3.72706,.40603,1.73794,3.67692,.31395,1.73894,3.67628,.32288,1.7187,3.36919,.34642,1.8404,3.34805,.41808,1.84871,3.35487,.35135,1.80925,3.4396,.45905,1.77125,3.37494,.49276,1.78491,3.41882,.52724,1.81032,3.55612,.32573,2.15478,3.46689,.44439,1.98512,3.45834,.38969,1.9771,3.54756,.37885,2.15417,3.68979,.49224,1.75192,3.71261,.54798,1.79463,3.72276,.48877,1.72029,3.38754,.41265,1.74118,3.46781,.39393,1.72083,3.40003,.37777,1.7188,3.71364,.52132,1.97028,3.7362,.5251,1.87655,3.70777,.57487,1.88861,3.7452,.49051,1.96542,3.50679,.42769,1.75287,3.54319,.46025,1.78242,3.52253,.42228,1.74496,3.67513,.37059,1.65685,3.72171,.41988,1.67254,3.7001,.59763,1.86751,3.64883,.62389,1.90576,3.61232,.29297,2.63642,3.62019,.30186,2.63985,3.61779,.30491,2.59526,3.6082,.29637,2.59602,3.78937,.29448,2.61899,3.84444,.27519,2.59468,3.81634,.30199,2.5604,3.76278,.30922,2.58125,3.82257,.29466,2.5494,3.85028,.26842,2.58256,3.80534,.24184,2.50345,3.60243,.22978,2.60992,3.61787,.1902,2.67901,3.62179,.22673,2.69229,3.68721,.26451,2.67238,3.68914,.24135,2.6836,3.73825,.2534,2.65468,3.60151,.15411,2.58807,3.60763,.15855,2.64002,3.85519,.14917,2.57077,3.83563,.14869,2.52481,3.80312,.19519,2.64695,3.73534,.20503,2.65397,3.78127,.15306,2.60512,3.72238,.18333,2.62224,3.73516,.15445,2.50248,3.69154,.21293,2.48311,3.72508,.18479,2.45898,3.7042,.18665,2.53409,3.60234,.45447,2.15311,3.57976,.56907,1.98965,3.5243,.53212,1.99615,3.65134,.47281,2.14907,3.46069,.60058,1.90337,3.54106,.63267,1.90888,3.45604,.63035,1.87384,3.78147,.16415,2.47543,3.76315,.19829,2.43416,3.79522,.17683,2.4614,3.82755,.13919,2.52593,3.63334,.30183,2.12925,3.54,.32348,1.93526,3.57597,.32012,1.92695,3.60885,.22274,2.50078,3.60316,.25756,2.43303,3.62894,.21345,2.4933,3.62082,.2453,2.42489,3.78033,.31197,2.5277,3.74796,.31852,2.53392,3.86711,.23884,2.60415,3.87637,.19692,2.60962,3.34295,.42644,1.7517,3.34858,.52198,1.79553};
			return value;
		}
		private double[] getlfpprox3_Coord_7_75_point_2()
		{
			double[] value = {3.50682,.60991,1.87471,3.46018,.62674,1.86202,3.53674,.62859,1.89246,3.62502,.3875,1.68106,3.66335,.38232,1.65514,3.604,.35546,1.66611,3.51835,.53728,1.84036,3.47969,.48773,1.80502,3.46221,.56851,1.84251,3.71549,.29816,2.10848,3.67312,.29133,1.91307,3.74542,.32942,2.10955,3.7182,.35781,1.93058,3.6366,.28392,1.80277,3.58837,.29238,1.79673,3.62932,.29253,1.91578,3.67517,.3039,1.81628,3.73113,.54099,1.7975,3.74308,.48024,1.76238,3.73772,.48319,1.72387,3.35445,.36166,1.73185,3.38918,.3121,1.79304,3.36135,.37896,1.72543,3.39716,.54739,1.89403,3.40261,.60404,1.85006,3.36569,.56998,1.82936,3.60801,.28912,2.5478,3.62028,.25934,2.67855,3.60236,.23459,2.50875,3.59942,.17576,2.5519,3.78661,.25744,2.46447,3.79308,.29667,2.50852,3.76218,.31972,2.42792,3.76902,.28457,2.39511,3.65808,.31787,2.55221,3.61894,.29769,2.55285,3.65156,.33577,2.46385,3.67255,.31468,2.59855,3.86347,.24147,2.61659,3.79974,.249,2.63958,3.66531,.21773,2.49258,3.63916,.16708,2.53436,3.60545,.16927,2.54356,3.68317,.28936,2.11391,3.70896,.24695,2.31041,3.68316,.18965,2.67854,3.63119,.22663,2.6989,3.62696,.18664,2.68503,3.68316,.30709,2.63934,3.62922,.26249,2.68371,3.74533,.22774,2.3699,3.77899,.20739,2.42815,3.59718,.26508,2.52853,3.55395,.43614,2.15714,3.61446,.57462,1.98495,3.33077,.42522,1.76697,3.33855,.51999,1.807,3.3702,.49954,1.87673,3.53998,.30889,1.80926,3.40424,.30368,1.82433,3.43772,.29975,1.81141,3.49458,.30786,1.94672,3.50282,.31165,1.81363,3.57778,.30609,2.14844,3.74452,.42225,1.94764,3.74314,.41108,2.12562,3.75675,.37156,2.11658,3.47057,.33682,1.95925,3.80382,.1879,2.46709,3.71074,.17249,2.58901,3.67817,.18963,2.54289,3.73203,.30407,2.63446,3.69213,.34527,2.46442,3.70632,.31858,2.54916,3.66446,.57035,1.97799,3.69176,.44536,2.13865,3.75981,.1293,2.55199,3.85162,.14344,2.57854,3.6154,.15063,2.64289,3.60824,.14456,2.58555,3.65429,.1391,2.58532,3.67176,.15328,2.6382,3.75876,.31167,2.32577,3.78204,.22585,2.43681,3.74061,.45199,1.85506,3.62795,.28325,1.76324,3.68398,.59951,1.85607,3.67083,.56378,1.82691,3.68569,.37198,2.37967,3.6169,.27715,2.35647,3.71287,.21588,2.38469,3.7338,.25253,2.3029,3.65166,.36247,2.38224,3.37279,.56826,1.81722,3.41011,.60207,1.83905,3.70905,.4272,1.66909,3.55613,.35889,1.69609,3.60817,.3341,1.66851,3.55821,.37701,1.69296,3.46941,.37581,1.72264};
			return value;
		}
		private double[] getlfpprox3_Coord_7_75_point_3()
		{
			double[] value = {3.40731,.35838,1.72183,3.59137,.62001,1.89633,3.59534,.62418,1.91421,3.42658,.30984,1.78143,3.61993,.2978,1.72845,3.5783,.30327,1.76621,3.52968,.31831,1.77899,3.55818,.58691,1.87571,3.63348,.50393,1.78601,3.61125,.57586,1.85944,3.57662,.51802,1.82092,3.6528,.42822,1.7078,3.59733,.44422,1.74511,3.57322,.40489,1.71301,3.71942,.38266,1.83431,3.87244,.19393,2.62051,3.72127,.31509,2.59593,3.64004,.62155,1.8886,3.50499,.38906,1.71221,3.50425,.37193,1.71356,3.48809,.50014,2.00013,3.49277,.3216,1.78377};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfpprox4_Geo_6_80_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,5,9,10,-1,11,12,13,-1,11,14,12,-1,11,15,14,-1,16,17,18,-1,16,19,17,-1,19,16,20,-1,13,21,20,-1,14,22,12,-1,23,24,25,-1,26,27,28,-1,28,29,26,-1,30,31,32,-1,1,33,34,-1,1,0,33,-1,35,36,37,-1,37,38,35,-1,39,40,41,-1,41,42,39,-1,43,44,45,-1,43,45,46,-1,46,47,43,-1,48,49,47,-1,50,51,52,-1,53,54,50,-1,55,56,57,-1,58,59,60,-1,60,61,58,-1,30,32,62,-1,32,63,62,-1,64,65,66,-1,65,67,66,-1,68,65,69,-1,20,21,19,-1,70,39,42,-1,70,38,39,-1,71,72,73,-1,22,74,75,-1,22,76,74,-1,77,78,79,-1,79,74,77,-1,80,48,47,-1,80,81,48,-1,82,83,84,-1,83,85,84,-1,86,87,50,-1,88,50,89,-1,53,50,90,-1,91,50,92,-1,93,94,95,-1,95,96,93,-1,97,46,98,-1,99,100,101,-1,99,102,100,-1,103,104,105,-1,106,107,108,-1,109,110,111,-1,7,109,112,-1,7,6,109,-1,23,113,114,-1,113,115,114,-1,116,27,117,-1,118,119,120,-1,119,121,120,-1,9,5,122,-1,2,4,123,-1,113,23,124,-1,23,125,124,-1,25,15,126,-1,15,11,126,-1,36,77,127,-1,127,37,36,-1,34,35,128,-1,35,70,128,-1,35,38,70,-1,129,130,110,-1,129,131,130,-1,8,24,6,-1,106,132,107,-1,100,102,133,-1,104,134,135,-1,104,103,134,-1,136,93,137,-1,93,96,137,-1,51,50,54,-1,138,90,50,-1,89,50,87,-1,91,139,50,-1,140,43,85,-1,52,92,50,-1,120,121,141,-1,121,142,141,-1,143,144,145,-1,143,124,144,-1,20,146,11,-1,146,126,11,-1,3,147,31,-1,28,106,108,-1,18,33,0,-1,18,78,33,-1,11,13,20,-1,57,148,55,-1,145,149,143,-1,149,150,143,-1,151,152,153,-1,151,154,152,-1,55,155,156,-1,156,56,55,-1,121,110,142,-1,153,152,105,-1,152,157,105,-1,69,158,68,-1,98,159,97,-1,50,88,138,-1,49,43,47,-1,50,139,86,-1,85,83,140,-1,144,158,145,-1,39,160,40,-1,42,161,10,-1,42,41,161,-1,160,39,38,-1,38,37,160,-1,162,163,123,-1,110,130,111,-1,79,78,17,-1,22,75,12,-1,78,18,17,-1,21,75,79,-1,16,18,0,-1,12,75,21,-1,21,13,12,-1,74,79,75,-1,1,122,5,-1,111,112,109,-1,161,147,10,-1,164,4,3,-1,4,1,5,-1,2,1,4,-1,19,79,17,-1,21,79,19,-1,111,165,132,-1,111,130,165,-1,166,107,167,-1,166,108,107,-1,8,168,15,-1,117,168,8,-1,70,122,128,-1,122,70,9,-1,31,161,32,-1,147,161,31,-1,149,158,69,-1,145,158,149,-1,169,44,170,-1,169,45,44,-1,171,72,95,-1,172,72,171,-1,173,174,94,-1,174,173,175,-1,83,176,177,-1,82,176,83,-1,178,83,177,-1,83,178,140,-1,102,179,133,-1,179,102,180,-1,181,80,97,-1,181,81,80,-1,172,73,72,-1,73,172,182,-1,86,43,49,-1,86,139,43,-1,175,183,174,-1,184,183,175,-1,172,185,186,-1,172,171,185,-1,187,88,188,-1,138,88,187,-1,84,52,184,-1,84,92,52,-1,139,85,43,-1,91,85,139,-1,188,89,189,-1,89,188,88,-1,53,190,186,-1,90,190,53,-1,87,49,48,-1,49,87,86,-1,164,31,30,-1,164,3,31,-1,157,99,101,-1,157,152,99,-1,103,157,191,-1,105,157,103,-1,61,192,58,-1,193,192,61,-1,194,110,109,-1,142,110,194,-1,195,154,196,-1,197,154,195,-1,59,137,198,-1,59,58,137,-1,192,199,136,-1,192,155,199,-1,151,196,154,-1,200,196,151,-1,119,201,129,-1,202,201,119,-1,109,114,194,-1,109,6,114,-1,203,148,204,-1,203,55,148,-1,205,149,206,-1,205,150,149,-1,67,103,191,-1,103,67,134,-1,148,143,150,-1,143,148,57,-1,24,114,6,-1,114,24,23,-1,125,146,207,-1,125,126,146,-1,163,208,209,-1,208,163,162,-1,210,161,41,-1,161,210,211,-1,7,106,116,-1,112,106,7,-1,22,15,168,-1,15,22,14,-1,128,1,34,-1,1,128,122,-1,131,212,213,-1,214,212,131,-1,112,132,106,-1,111,132,112,-1,160,127,215,-1,37,127,160,-1,29,216,217,-1,29,166,216,-1,218,60,200,-1,118,60,218,-1,214,129,201,-1,131,129,214,-1,219,216,220,-1,216,219,221,-1,124,207,144,-1,124,125,207,-1};
			return value;
		}
		private int[] getlfpprox4_Geo_6_80_coordIndex_2()
		{
			int[] value = {206,222,205,-1,222,206,170,-1,98,45,169,-1,45,98,46,-1,158,223,68,-1,223,158,144,-1,219,215,221,-1,224,215,219,-1,201,211,214,-1,63,211,201,-1,225,200,151,-1,225,218,200,-1,224,160,215,-1,224,40,160,-1,26,217,76,-1,26,29,217,-1,118,61,60,-1,118,120,61,-1,82,184,175,-1,84,184,82,-1,156,115,56,-1,156,226,115,-1,68,135,134,-1,68,223,135,-1,180,189,179,-1,180,188,189,-1,186,182,172,-1,182,186,190,-1,95,71,96,-1,95,72,71,-1,120,193,61,-1,141,193,120,-1,156,141,226,-1,156,193,141,-1,227,173,228,-1,227,176,173,-1,227,204,229,-1,204,227,203,-1,177,222,178,-1,177,229,222,-1,57,124,143,-1,113,124,57,-1,159,230,231,-1,230,159,66,-1,100,181,231,-1,181,100,133,-1,224,41,40,-1,224,210,41,-1,211,32,161,-1,211,63,32,-1,135,164,104,-1,162,164,135,-1,33,77,36,-1,77,33,78,-1,76,168,26,-1,76,22,168,-1,0,209,16,-1,209,0,163,-1,162,223,208,-1,223,162,135,-1,30,225,232,-1,225,30,62,-1,165,220,167,-1,165,213,220,-1,141,194,226,-1,194,141,142,-1,114,226,194,-1,114,115,226,-1,28,116,106,-1,28,27,116,-1,231,97,159,-1,97,231,181,-1,230,100,231,-1,230,101,100,-1,104,153,105,-1,104,232,153,-1,66,98,64,-1,66,159,98,-1,229,205,222,-1,229,204,205,-1,56,113,57,-1,56,115,113,-1,176,229,177,-1,176,227,229,-1,136,228,93,-1,199,228,136,-1,232,151,153,-1,225,151,232,-1,233,99,197,-1,233,102,99,-1,96,198,137,-1,96,71,198,-1,174,185,171,-1,174,183,185,-1,190,234,182,-1,234,190,187,-1,179,48,81,-1,179,189,48,-1,164,232,104,-1,164,30,232,-1,228,203,227,-1,199,203,228,-1,216,167,220,-1,216,166,167,-1,73,197,195,-1,233,197,73,-1,62,218,225,-1,62,202,218,-1,210,219,212,-1,210,224,219,-1,74,127,77,-1,127,74,235,-1,144,208,223,-1,208,144,207,-1,169,64,98,-1,64,169,236,-1,170,178,222,-1,178,170,44,-1,76,235,74,-1,217,235,76,-1,220,212,219,-1,220,213,212,-1,118,202,119,-1,118,218,202,-1,195,71,73,-1,198,71,195,-1,217,221,235,-1,217,216,221,-1,235,215,127,-1,235,221,215,-1,130,213,165,-1,131,213,130,-1,42,9,70,-1,9,42,10,-1,7,117,8,-1,7,116,117,-1,214,210,212,-1,211,210,214,-1,162,4,164,-1,162,123,4,-1,207,209,208,-1,207,146,209,-1,23,126,125,-1,23,25,126,-1,65,134,67,-1,134,65,68,-1,66,191,230,-1,66,67,191,-1,236,65,64,-1,236,69,65,-1,204,150,205,-1,204,148,150,-1,199,55,203,-1,199,155,55,-1,129,121,119,-1,129,110,121,-1,63,202,62,-1,63,201,202,-1,200,59,196,-1,60,59,200,-1,58,136,137,-1,58,192,136,-1,196,198,195,-1,196,59,198,-1,197,152,154,-1,99,152,197,-1,193,155,192,-1,156,155,193,-1,191,101,230,-1,191,157,101,-1,183,54,185,-1,54,183,51,-1,90,187,190,-1,187,90,138,-1,189,87,48,-1,87,189,89,-1,85,92,84,-1,92,85,91,-1,187,180,234,-1,187,188,180,-1,54,186,185,-1,186,54,53,-1,173,93,228,-1,173,94,93,-1,184,51,183,-1,52,51,184,-1,234,102,233,-1,102,234,180,-1,140,44,43,-1,140,178,44,-1,182,233,73,-1,182,234,233,-1,133,81,181,-1,81,133,179,-1,80,46,97,-1,47,46,80,-1,176,175,173,-1,175,176,82,-1,174,95,94,-1,171,95,174,-1,206,69,236,-1,69,206,149,-1,236,170,206,-1,236,169,170,-1,36,34,33,-1,34,36,35,-1,2,163,0,-1,123,163,2,-1,25,8,15,-1,8,25,24,-1,117,26,168,-1,27,26,117,-1,28,166,29,-1,108,166,28,-1,167,132,165,-1,132,167,107,-1,16,146,20,-1,146,16,209,-1,3,10,147,-1,3,5,10,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfpprox4_Coord_7_80_point_1()
		{
			double[] value = {4.00601,.32414,1.90401,4.00441,.34313,1.90954,4.00544,.34058,1.88945,4.03435,.39114,1.84475,4.0211,.37484,1.84521,4.02222,.38183,1.86315,4.18808,.25143,1.78631,4.20344,.23195,1.83343,4.16399,.20801,1.84468,4.01939,.38158,1.90916,4.05709,.40535,1.90836,4.11122,.2276,1.87909,4.09954,.21978,1.92812,4.09521,.23415,1.91888,4.12021,.21654,1.88611,4.14715,.20604,1.85345,4.03655,.27864,1.90191,4.04694,.25625,1.94432,4.02599,.28168,1.91371,4.06392,.25496,1.92771,4.08657,.25843,1.8935,4.08832,.24753,1.94347,4.12282,.20356,1.94259,4.15003,.25035,1.71627,4.16031,.23716,1.80171,4.14406,.23546,1.808,4.20712,.20272,1.97148,4.21702,.20329,1.95662,4.23539,.22705,1.97795,4.22349,.2269,1.98889,4.07179,.44723,1.75656,4.07496,.41938,1.83947,4.09111,.42414,1.83675,3.99387,.31273,1.95856,3.99166,.32626,1.95873,4.00406,.34804,2.00493,4.00757,.33863,2.00832,4.03206,.35686,2.01878,4.02546,.36383,2.0116,4.0463,.38526,2.00774,4.05654,.38897,2.00552,4.07317,.40934,1.95771,4.058,.40152,1.95898,3.8915,.41269,1.27623,3.89394,.38754,1.27199,3.86575,.40506,1.28085,3.79495,.42256,1.28111,3.80581,.43902,1.27845,3.81101,.52758,1.33254,3.83332,.4476,1.2877,3.98768,.4898,1.32759,4.05366,.46675,1.29177,4.03274,.44966,1.28379,4.03715,.51093,1.33426,4.05476,.49966,1.31907,4.14872,.27602,1.44059,4.14478,.27813,1.52668,4.11877,.26287,1.54023,4.20523,.46392,1.44228,4.17995,.51013,1.45936,4.19716,.47241,1.54025,4.21178,.4305,1.52078,4.12873,.44517,1.74392,4.13641,.41407,1.82827,3.85238,.35525,1.41726,3.91119,.34059,1.5083,3.78708,.42084,1.44016,3.85901,.40927,1.52755,3.97113,.34669,1.57586,3.96946,.34403,1.49402,4.01822,.37782,1.96016,4.16589,.55717,1.35086,4.16438,.56415,1.32846,4.10393,.59958,1.37882,4.11165,.24639,1.98823,4.09294,.24072,1.95275,4.16383,.21538,1.98213,4.05079,.28727,2.01091,4.03402,.26185,1.96117,4.08154,.24798,1.9546,3.73687,.49175,1.29213,3.73959,.57667,1.32441,4.0767,.35188,1.17625,3.99079,.31794,1.19937,4.0525,.39917,1.22709,3.9916,.38239,1.23883,3.90356,.47081,1.31565,3.90152,.5054,1.33398,3.97876,.52946,1.35431,3.93293,.5297,1.34626,4.01946,.52217,1.34946,3.99074,.43207,1.28624,4.02225,.44065,1.27994,4.21808,.41276,1.26682,4.18543,.4416,1.21038,4.19565,.51712,1.28549,4.19838,.50425,1.32948,3.72225,.48113,1.29642,3.77301,.387,1.32623,3.97483,.59245,1.45107};
			return value;
		}
		private double[] getlfpprox4_Coord_7_80_point_2()
		{
			double[] value = {3.84821,.60769,1.40987,3.87452,.56627,1.46688,3.96928,.61755,1.40196,3.92653,.45165,1.59953,3.9898,.43417,1.67512,3.95083,.47087,1.59565,4.25291,.26047,1.87976,4.27006,.28404,1.96506,4.2482,.25506,1.98885,4.22401,.28671,1.76959,4.26188,.33976,1.78454,4.26989,.32638,1.83747,4.23695,.27598,1.82494,4.1393,.25827,1.62323,4.17561,.26136,1.69873,4.1577,.2718,1.61103,4.21332,.2143,1.8853,4.17714,.18849,1.89813,4.21346,.43391,1.6212,4.22676,.39803,1.70982,4.2294,.39993,1.6006,4.25428,.3697,1.69318,4.01051,.369,1.90904,4.00857,.34508,1.84305,4.09417,.2803,1.6329,4.10803,.2627,1.72347,4.11583,.2439,1.81411,4.07884,.31322,2.02935,4.00025,.35408,1.96084,4.23887,.36647,1.80012,4.26659,.33584,1.84146,4.23781,.35527,1.85337,4.28212,.31633,1.88877,3.83432,.61872,1.37523,3.92532,.39695,1.59014,3.96419,.38132,1.66663,4.21831,.39347,1.34469,4.2068,.48166,1.38475,3.99907,.52581,1.35189,3.93188,.44218,1.30111,3.92623,.36048,1.23576,4.23472,.3612,1.59329,4.25314,.34931,1.68906,4.06777,.28782,1.55247,4.04947,.30767,1.64268,4.03222,.31804,1.56237,4.0813,.27294,1.82337,4.06469,.41095,1.89184,4.08919,.25307,1.45883,3.9997,.33106,1.48559,4.03397,.28629,1.4737,4.09253,.51526,1.57547,3.99354,.5611,1.50881,4.01783,.50995,1.58863,4.07148,.5563,1.49208,4.18863,.31864,1.43212,4.19844,.31288,1.51713,3.90617,.52635,1.52469,4.01182,.33027,1.56727,3.71968,.43909,1.34782,4.05104,.37993,2.01501,4.07797,.41237,1.90095,3.9933,.36008,1.75251,4.0093,.33089,1.84091,4.0156,.40482,1.76136,4.27617,.32885,1.89366,4.23857,.25988,2.00029,4.26401,.29545,1.9731,4.1603,.18411,1.91068,3.87832,.38477,1.31202,3.90745,.37089,1.30359,4.17788,.52103,1.27972,4.14855,.56345,1.32031,4.13975,.37003,1.17137,4.16831,.44909,1.20804,4.12603,.38122,1.17097,4.08617,.3356,1.17603,3.99224,.29828,1.20154,3.91731,.34978,1.24548,3.84226,.61266,1.3621,3.96797,.61124,1.38668,3.72825,.578,1.33333,4.0933,.59429,1.36531,4.11426,.45329,1.24932,4.07656,.41375,1.23005,4.12231,.51584,1.30211,4.08667,.53882,1.33313,4.00889,.56926,1.36911,3.96753,.57671,1.37407,3.87437,.57719,1.3576,4.05348,.55996,1.36169,3.84603,.47893,1.5349,4.21489,.38008,1.43033,4.22534,.36876,1.51246,4.21608,.29906,1.68634,4.11901,.57584,1.42317,4.13858,.54639,1.47818,4.05213,.58525,1.43584,4.16987,.53254,1.40446,4.18107,.32893,1.3241};
			return value;
		}
		private double[] getlfpprox4_Coord_7_80_point_3()
		{
			double[] value = {4.1567,.49972,1.55847,4.18808,.38883,1.81695,4.18551,.42205,1.72822,4.12931,.28729,1.32809,4.04983,.25421,1.3504,3.98493,.29228,1.37737,3.94992,.35274,1.39254,4.06841,.29089,1.733,4.02512,.3138,1.74222,4.0407,.2949,1.83269,4.12716,.3947,1.94144,4.12958,.39929,1.88465,4.19258,.36444,1.92187,4.24117,.34765,1.90727,4.19038,.37657,1.86943,4.10509,.34392,2.02887,4.20706,.27741,2.01076,4.18644,.24385,2.00231,4.17609,.45761,1.64044,4.1778,.33971,1.98375,4.22868,.31757,1.98168,4.16132,.30439,2.01133,3.94813,.31491,1.27928,4.00476,.33186,1.65182,4.11714,.37413,2.00082,4.11553,.47881,1.66053,4.20313,.30311,1.60126,4.11129,.29855,1.21561,4.16843,.34215,1.21623,4.01949,.26447,1.24075,3.77989,.50278,1.46991,3.73228,.5322,1.40265,4.04934,.47205,1.67352,4.03982,.61345,1.39142,4.03489,.60796,1.37767,4.13707,.27256,2.0066,3.9226,.36504,1.40063};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfpprox5_Geo_6_85_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,15,21,22,-1,12,14,23,-1,24,25,26,-1,27,28,29,-1,24,30,31,-1,30,32,31,-1,33,34,35,-1,35,36,33,-1,28,37,38,-1,36,35,39,-1,39,40,36,-1,41,42,43,-1,44,45,46,-1,0,47,1,-1,48,49,40,-1,50,51,52,-1,52,53,50,-1,54,55,56,-1,28,38,29,-1,57,15,17,-1,55,58,59,-1,55,54,58,-1,60,61,62,-1,37,28,63,-1,28,8,63,-1,64,21,65,-1,66,67,57,-1,66,68,67,-1,69,70,71,-1,72,73,13,-1,73,74,13,-1,13,74,14,-1,75,76,14,-1,77,9,14,-1,78,79,80,-1,81,79,78,-1,81,82,79,-1,83,84,85,-1,85,86,83,-1,20,57,67,-1,87,88,89,-1,87,90,88,-1,91,92,93,-1,94,95,91,-1,91,93,94,-1,96,97,98,-1,96,99,97,-1,96,98,54,-1,98,100,54,-1,25,24,31,-1,101,26,25,-1,102,103,60,-1,60,27,102,-1,104,105,5,-1,5,106,104,-1,95,107,108,-1,91,109,92,-1,88,110,89,-1,64,111,21,-1,111,112,21,-1,67,18,20,-1,113,81,114,-1,113,115,81,-1,116,78,80,-1,116,117,78,-1,118,69,14,-1,14,76,77,-1,14,74,75,-1,119,70,118,-1,70,69,118,-1,73,120,75,-1,75,74,73,-1,112,22,21,-1,9,118,14,-1,116,80,110,-1,110,121,116,-1,122,123,100,-1,124,64,65,-1,33,7,125,-1,33,126,7,-1,27,62,28,-1,127,58,128,-1,127,59,58,-1,129,125,99,-1,129,130,125,-1,22,16,15,-1,131,132,30,-1,127,128,133,-1,50,134,51,-1,135,136,137,-1,136,138,137,-1,139,140,141,-1,139,35,140,-1,34,125,130,-1,142,36,40,-1,39,35,143,-1,44,130,45,-1,130,129,45,-1,56,42,41,-1,41,144,56,-1,107,95,94,-1,47,40,39,-1,125,34,33,-1,48,40,0,-1,40,47,0,-1,39,145,47,-1,146,147,31,-1,31,32,146,-1,26,101,148,-1,148,149,26,-1,133,128,61,-1,62,27,60,-1,62,61,128,-1,150,151,152,-1,151,153,152,-1,71,70,86,-1,70,83,86,-1,153,154,155,-1,153,151,154,-1,86,85,156,-1,156,157,86,-1,14,69,23,-1,69,158,23,-1,69,71,158,-1,57,20,15,-1,23,158,154,-1,150,72,13,-1,10,82,159,-1,159,11,10,-1,21,160,65,-1,40,49,142,-1,53,161,50,-1,35,139,143,-1,5,132,106,-1,132,5,4,-1,135,162,163,-1,134,162,135,-1,131,164,165,-1,166,164,131,-1,1,166,2,-1,1,164,166,-1,126,49,63,-1,126,142,49,-1,154,157,155,-1,154,158,157,-1,167,156,168,-1,169,156,167,-1,12,154,151,-1,23,154,12,-1,71,157,158,-1,71,86,157,-1,169,153,155,-1,169,170,153,-1,70,171,83,-1,70,119,171,-1,110,73,89,-1,120,73,110,-1,87,150,152,-1,72,150,87,-1,119,159,171,-1,11,159,119,-1,172,110,80,-1,120,110,172,-1,24,149,30,-1,24,26,149,-1,173,101,102,-1,101,173,148,-1,133,147,146,-1,133,61,147,-1,0,37,48,-1,0,38,37,-1,108,141,140,-1,108,107,141,-1,144,45,129,-1,144,41,45,-1,51,109,52,-1,92,109,51,-1,138,107,94,-1,107,138,141,-1,52,42,56,-1,42,52,109,-1,130,35,34,-1,35,130,140,-1,136,141,138,-1,136,139,141,-1,134,137,51,-1,134,135,137,-1,127,146,3,-1,127,133,146,-1,4,30,132,-1,4,32,30,-1,30,166,131,-1,166,30,149,-1,0,148,173,-1,0,2,148,-1,167,22,174,-1,22,167,16,-1,85,168,156,-1,85,66,168,-1,5,175,3,-1,5,105,175,-1,101,103,102,-1,101,25,103,-1,144,99,96,-1,144,129,99,-1,106,176,104,-1,165,176,106,-1,65,177,124,-1,177,65,178,-1,20,6,15,-1,20,179,6,-1,180,123,181,-1,123,180,100,-1,182,100,98,-1,182,122,100,-1,183,111,184,-1,183,112,111,-1,185,121,186,-1,121,185,187,-1,188,117,116,-1,117,188,189,-1,113,190,191,-1,113,114,190,-1,18,68,192,-1,68,18,67,-1,177,188,187,-1,181,188,177,-1,11,118,9,-1,11,119,118,-1,113,193,115,-1,113,192,193,-1,178,62,128,-1,62,178,65,-1,76,120,172,-1,120,76,75,-1,9,194,10,-1,194,9,77,-1,123,190,189,-1,123,122,190,-1,190,182,191,-1,182,190,122,-1,81,159,82,-1,81,115,159,-1};
			return value;
		}
		private int[] getlfpprox5_Geo_6_85_coordIndex_2()
		{
			int[] value = {192,84,193,-1,84,192,68,-1,153,195,152,-1,195,153,170,-1,88,121,110,-1,121,88,186,-1,64,185,111,-1,185,64,124,-1,195,184,90,-1,184,195,183,-1,104,163,162,-1,163,104,176,-1,108,46,95,-1,44,46,108,-1,104,161,105,-1,162,161,104,-1,55,175,53,-1,55,59,175,-1,128,180,178,-1,180,128,58,-1,6,28,160,-1,8,28,6,-1,165,145,176,-1,165,164,145,-1,63,48,37,-1,48,63,49,-1,145,143,196,-1,143,145,39,-1,196,176,145,-1,196,163,176,-1,33,142,126,-1,33,36,142,-1,47,164,1,-1,164,47,145,-1,179,7,6,-1,179,125,7,-1,62,160,28,-1,62,65,160,-1,147,60,103,-1,61,60,147,-1,3,59,127,-1,3,175,59,-1,58,100,180,-1,100,58,54,-1,125,97,99,-1,125,179,97,-1,95,43,91,-1,95,46,43,-1,91,42,109,-1,43,42,91,-1,90,152,195,-1,152,90,87,-1,184,88,90,-1,184,186,88,-1,124,187,185,-1,187,124,177,-1,170,183,195,-1,170,174,183,-1,84,66,85,-1,68,66,84,-1,193,83,171,-1,83,193,84,-1,181,189,188,-1,123,189,181,-1,117,81,78,-1,117,114,81,-1,77,172,194,-1,172,77,76,-1,13,151,150,-1,13,12,151,-1,191,19,18,-1,182,19,191,-1,171,115,193,-1,115,171,159,-1,191,192,113,-1,192,191,18,-1,189,114,117,-1,114,189,190,-1,187,116,121,-1,116,187,188,-1,111,186,184,-1,186,111,185,-1,174,112,183,-1,174,22,112,-1,182,97,19,-1,182,98,97,-1,178,181,177,-1,181,178,180,-1,15,160,21,-1,15,6,160,-1,19,179,20,-1,19,97,179,-1,144,54,56,-1,144,96,54,-1,103,31,147,-1,25,31,103,-1,105,53,175,-1,161,53,105,-1,66,17,168,-1,66,57,17,-1,174,169,167,-1,174,170,169,-1,173,38,0,-1,38,173,29,-1,2,149,148,-1,2,166,149,-1,32,3,146,-1,4,3,32,-1,53,56,55,-1,53,52,56,-1,46,41,43,-1,45,41,46,-1,137,92,51,-1,92,137,93,-1,94,137,138,-1,94,93,137,-1,44,140,130,-1,44,108,140,-1,102,29,173,-1,102,27,29,-1,194,80,79,-1,172,80,194,-1,89,72,87,-1,73,72,89,-1,10,79,82,-1,10,194,79,-1,168,16,167,-1,168,17,16,-1,169,157,156,-1,155,157,169,-1,63,7,126,-1,8,7,63,-1,196,139,136,-1,196,143,139,-1,136,163,196,-1,135,163,136,-1,131,106,132,-1,131,165,106,-1,50,162,134,-1,50,161,162,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfpprox5_Coord_7_85_point_1()
		{
			double[] value = {4.35619,.31989,1.47441,4.38517,.31582,1.5225,4.36503,.32697,1.52252,4.46096,.46571,1.47051,4.46251,.44661,1.5334,4.48313,.4396,1.53036,4.34377,.38435,1.20664,4.38309,.34829,1.31307,4.36906,.35939,1.31786,4.43747,.48152,.82529,4.51618,.46367,.78517,4.47705,.42102,.77273,4.21901,.51809,.84829,4.17506,.57922,.86798,4.32058,.54946,.88643,4.3144,.39447,1.12101,4.27258,.40766,1.03797,4.28524,.40062,1.03513,4.43058,.34646,1.01314,4.4271,.36253,1.09779,4.37559,.36195,1.10722,4.26664,.44511,1.13443,4.22574,.42203,1.04866,4.25009,.47438,.83423,4.40055,.43665,1.56906,4.33303,.41338,1.53113,4.35217,.39142,1.56764,4.29328,.37466,1.43223,4.33242,.3998,1.33071,4.29879,.36371,1.43103,4.41196,.43751,1.57221,4.39243,.4598,1.54149,4.41548,.45483,1.53913,4.41778,.29404,1.39687,4.4288,.28346,1.39465,4.4345,.2742,1.43511,4.42561,.28558,1.43823,4.36027,.33309,1.42314,4.34247,.33422,1.42521,4.44062,.29882,1.52115,4.42264,.30487,1.50887,4.53247,.34725,1.31609,4.59113,.39751,1.38366,4.55607,.33898,1.365,4.47952,.26756,1.37694,4.50256,.31363,1.32124,4.51356,.29473,1.36996,4.42385,.31056,1.52728,4.37737,.32126,1.46985,4.40076,.31981,1.46076,4.59159,.3891,1.51503,4.611,.36683,1.50994,4.60032,.40874,1.43395,4.56394,.42927,1.44431,4.51679,.4159,1.29171,4.54529,.43609,1.39414,4.57927,.41313,1.38382,4.32635,.36415,1.0261,4.47027,.46942,1.31343,4.50329,.45129,1.40506,4.3199,.44174,1.43794,4.3752,.48375,1.43534,4.33503,.45059,1.33789,4.38818,.33326,1.42092,4.25601,.49717,1.14369,4.31576,.47708,1.22716,4.29594,.35351,.94149,4.37857,.33035,1.01521,4.3657,.32223,.92217,4.33784,.43547,.81765,4.34006,.35877,.78195,4.28323,.39238,.79658,4.10321,.63092,.83848,4.20125,.67837,.90248,4.23884,.62841,.8991,4.29837,.6314,.9231,4.36337,.61113,.9239,4.43612,.57063,.88431,4.50762,.56207,.91661,4.51406,.57455,.87818,4.41919,.66281,.94786,4.53074,.44048,.84569,4.52215,.45731,.79214,4.34258,.34317,.78593,4.35458,.31413,.82904,4.26685,.34341,.85257,4.27361,.37964,.80193,4.09264,.63029,.84293,4.18467,.66474,.94508,4.19492,.68196,.91142,4.07722,.57276,.90976,4.57337,.32956,1.41572,4.61832,.35612,1.49723,4.59884,.32243,1.50224,4.55934,.26986,1.48195,4.52712,.28544,1.41349,4.51088,.3641,1.28013,4.43688,.35621,1.18031,4.47368,.38201,1.1756,4.4805,.32565,1.28296};
			return value;
		}
		private double[] getlfpprox5_Coord_7_85_point_2()
		{
			double[] value = {4.4967,.43252,1.18379,4.31549,.37354,1.52527,4.29157,.37012,1.48017,4.32214,.43103,1.48275,4.5313,.39666,1.53983,4.53402,.41224,1.51935,4.48583,.42009,1.56095,4.49855,.25289,1.44218,4.48276,.25637,1.41635,4.61023,.39467,1.42885,4.29964,.69894,.94551,4.18562,.53344,1.06183,4.18947,.4636,1.05347,4.4834,.38784,.9189,4.51403,.45298,.93797,4.49616,.39137,.82469,4.42699,.64069,.99377,4.50151,.53231,.96772,4.39525,.44799,.81398,4.42827,.39317,.77312,4.29808,.69479,.93571,4.30356,.6551,1.00261,4.49221,.44587,1.09982,4.49076,.469,1.10233,4.27538,.52409,1.1454,4.42736,.32293,1.29825,4.40632,.32052,1.41647,4.44083,.47276,1.42093,4.38829,.4758,1.33141,4.48706,.31997,1.30712,4.45851,.2707,1.37882,4.45657,.4077,1.57604,4.46549,.4305,1.5629,4.39874,.48321,1.43129,4.58928,.37571,1.52778,4.56476,.34254,1.54027,4.5133,.27692,1.53118,4.58975,.32815,1.51843,4.54739,.26889,1.49752,4.46183,.26118,1.47974,4.46396,.25903,1.42144,4.48642,.25451,1.45658,4.41257,.31239,1.45378,4.44989,.2694,1.49354,4.51849,.35573,1.30154,4.44844,.31755,1.54933,4.40874,.47798,1.48125,4.38483,.47752,1.48372,4.31993,.3601,1.52432,4.36528,.38189,1.5731,4.10303,.53149,.80837,4.15684,.4811,.80941,4.09063,.52057,.80907,4.14351,.46466,.81404,4.23618,.46663,.82443,4.22263,.45724,.82864,4.21903,.40435,.87105,4.23692,.44978,.82781,4.24312,.46077,.82339,4.48339,.40919,.77631,4.31095,.42931,1.2195,4.5741,.40032,1.51742,4.57221,.38754,1.53288,4.5487,.35228,1.54776,4.41683,.3371,1.56757,4.474,.39685,1.57306,4.40086,.34942,1.57196,4.23335,.41147,.9576,4.25141,.40109,.9527,4.20133,.41536,.87366,4.134,.42131,.86392,4.43479,.37896,.7756,4.40978,.65958,.93644,4.29728,.35851,1.47924,4.17767,.41969,.95935,4.51862,.44151,1.45457,4.51149,.37548,1.55232,4.3396,.55046,1.14118,4.36018,.50374,1.22422,4.39281,.35532,1.19216,4.44354,.50351,1.21169,4.43023,.54533,1.12809,4.47138,.39244,1.09504,4.12879,.46804,.95802,4.13098,.55233,.9874,4.22875,.5777,1.06638,4.20373,.62327,1.00679,4.31413,.61628,1.05672,4.42698,.6031,1.04239,4.49603,.50244,1.02195,4.50071,.45108,1.01172,4.47195,.38429,1.01305,4.43594,.34796,.91991,4.44258,.34939,.82662,4.50283,.57626,.86974,4.08099,.47178,.87714,4.49776,.28441,1.54008};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfmet_Geo_6_90_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,4,6,5,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,12,-1,30,31,32,-1,33,31,30,-1,28,32,29,-1,34,35,36,-1,31,37,32,-1,31,38,37,-1,39,40,41,-1,42,43,44,-1,42,45,43,-1,46,47,48,-1,49,50,51,-1,51,52,49,-1,53,54,55,-1,53,56,54,-1,25,57,58,-1,58,26,25,-1,59,60,61,-1,16,62,63,-1,64,65,66,-1,66,67,64,-1,68,69,19,-1,70,71,72,-1,72,73,70,-1,19,74,68,-1,75,76,77,-1,78,79,34,-1,77,80,75,-1,81,78,82,-1,40,44,70,-1,83,84,85,-1,57,86,87,-1,75,88,89,-1,90,91,92,-1,93,94,95,-1,95,7,93,-1,96,97,98,-1,96,99,97,-1,100,101,102,-1,103,104,105,-1,104,106,105,-1,107,108,109,-1,109,110,107,-1,111,112,113,-1,111,114,112,-1,115,116,117,-1,115,118,116,-1,119,120,121,-1,119,122,120,-1,123,124,125,-1,124,126,125,-1,127,128,9,-1,9,129,127,-1,130,131,132,-1,133,134,135,-1,136,137,138,-1,136,139,137,-1,140,141,142,-1,143,144,133,-1,145,146,147,-1,147,148,145,-1,149,150,151,-1,151,152,149,-1,148,153,154,-1,148,147,153,-1,155,156,157,-1,158,159,135,-1,158,160,159,-1,161,162,163,-1,163,164,161,-1,135,134,158,-1,107,160,139,-1,107,165,160,-1,166,145,167,-1,168,169,170,-1,168,171,169,-1,172,173,101,-1,173,174,101,-1,175,6,76,-1,176,177,68,-1,178,7,9,-1,179,180,93,-1,180,181,93,-1,15,60,13,-1,182,183,33,-1,33,184,182,-1,12,29,185,-1,186,28,187,-1,28,186,32,-1,188,189,190,-1,191,192,25,-1,193,194,195,-1,196,188,37,-1,197,198,199,-1,197,200,198,-1,201,202,203,-1,203,199,201,-1,204,51,53,-1,205,196,206,-1,206,207,205,-1,206,48,207,-1,206,46,48,-1,208,209,210,-1,208,211,209,-1,212,34,36,-1,213,214,63,-1,79,213,35,-1,62,16,18,-1,17,215,18,-1,17,216,215,-1,217,45,218,-1,218,215,217,-1,50,218,45,-1,45,56,50,-1,41,87,86,-1,49,218,50,-1,49,219,218,-1,39,86,54,-1,220,221,222,-1,220,223,221,-1,40,70,73,-1,73,21,40,-1,224,176,68,-1,224,225,176,-1,85,226,4,-1,85,84,226,-1,175,105,106,-1,106,227,175,-1,89,88,228,-1,228,229,89,-1,230,80,231,-1,232,233,66,-1,225,234,235,-1,225,224,234,-1,236,87,41,-1,237,184,12,-1,60,59,238,-1,239,240,241,-1,239,242,240,-1,243,14,13,-1,244,87,243,-1,87,236,243,-1,156,245,246,-1,156,247,245,-1,248,133,144,-1,249,247,250,-1,251,252,253,-1,252,141,253,-1,100,2,254,-1,2,1,254,-1,255,256,248,-1,257,258,259,-1,257,260,258,-1,111,261,262,-1,111,263,261,-1,154,264,112,-1,264,113,112,-1,265,266,267,-1,167,109,108,-1,167,114,109,-1,268,269,163,-1,269,270,163,-1,160,161,159,-1,271,272,138,-1,138,273,271,-1,137,158,134,-1,134,274,137,-1,149,152,275,-1,275,276,149,-1,277,102,101,-1,97,278,173,-1,279,172,280,-1,281,282,283,-1,281,284,282,-1,285,286,287,-1,285,288,286,-1,168,155,157,-1,157,289,168,-1,91,90,270,-1,270,269,91,-1,290,264,291,-1,290,292,264,-1,293,294,295,-1,293,296,294,-1,297,157,298,-1,297,289,157,-1,127,91,269,-1,127,129,91,-1,92,171,90,-1,171,168,90,-1,279,280,281,-1,280,284,281,-1,97,172,279,-1,97,173,172,-1,97,99,278,-1,299,169,300,-1,299,170,169,-1,126,174,301,-1,301,302,126,-1,303,304,305,-1,303,306,304,-1,119,307,308,-1,119,309,307,-1,121,120,310,-1,311,151,115,-1,312,313,314,-1,312,153,313,-1,315,149,276,-1,170,299,316,-1,161,317,159,-1,161,164,317,-1,298,164,297,-1,298,317,164,-1,265,318,266,-1,154,112,148,-1,114,262,109,-1,114,111,262,-1,259,258,142,-1,258,319,142,-1,320,256,319,-1,319,258,320,-1,321,322,323,-1,322,324,323,-1,325,326,327,-1,325,328,326,-1,254,329,330,-1,254,1,329,-1,249,250,331,-1,143,140,332,-1,143,333,140,-1,255,248,144,-1,133,135,143,-1,15,223,334,-1,10,185,243,-1,185,244,243,-1,335,336,337,-1,335,59,336,-1,238,335,237,-1,238,59,335,-1,181,61,60,-1};
			return value;
		}
		private int[] getlfmet_Geo_6_90_coordIndex_2()
		{
			int[] value = {181,180,61,-1,11,238,237,-1,12,185,10,-1,12,184,33,-1,338,80,230,-1,339,68,340,-1,339,69,68,-1,224,72,234,-1,224,74,72,-1,68,74,224,-1,19,21,73,-1,42,39,54,-1,341,219,49,-1,341,62,219,-1,39,41,86,-1,217,43,45,-1,219,18,215,-1,215,218,219,-1,62,18,219,-1,63,62,213,-1,79,214,213,-1,210,209,212,-1,212,36,210,-1,228,88,209,-1,88,212,209,-1,63,214,342,-1,342,67,63,-1,48,343,207,-1,48,344,343,-1,204,52,51,-1,199,198,201,-1,38,345,346,-1,191,25,27,-1,189,26,190,-1,345,193,346,-1,186,30,32,-1,186,187,30,-1,57,244,58,-1,57,87,244,-1,343,204,347,-1,343,344,204,-1,60,15,334,-1,177,295,340,-1,295,294,340,-1,155,348,250,-1,155,316,348,-1,348,286,327,-1,327,250,348,-1,276,349,315,-1,350,351,352,-1,352,353,350,-1,352,354,353,-1,355,356,357,-1,160,162,161,-1,270,297,164,-1,164,163,270,-1,168,289,90,-1,159,317,358,-1,358,135,159,-1,298,157,246,-1,157,156,246,-1,275,314,359,-1,314,318,359,-1,100,102,2,-1,150,149,315,-1,315,309,150,-1,312,151,311,-1,312,152,151,-1,101,307,277,-1,360,361,362,-1,363,364,365,-1,364,366,365,-1,146,145,166,-1,166,272,146,-1,107,110,165,-1,367,368,267,-1,368,322,267,-1,24,369,22,-1,131,365,132,-1,131,370,365,-1,9,22,369,-1,9,8,22,-1,112,114,148,-1,263,113,371,-1,263,111,113,-1,139,136,108,-1,108,107,139,-1,372,103,373,-1,103,105,373,-1,24,23,96,-1,23,99,96,-1,129,369,92,-1,92,91,129,-1,308,122,119,-1,95,94,306,-1,94,304,306,-1,75,89,76,-1,89,373,76,-1,68,177,340,-1,78,374,82,-1,79,35,34,-1,375,215,216,-1,73,72,74,-1,74,19,73,-1,243,13,10,-1,13,60,238,-1,57,25,192,-1,192,86,57,-1,55,86,192,-1,55,54,86,-1,376,344,48,-1,32,190,29,-1,32,188,190,-1,37,188,32,-1,345,183,240,-1,240,193,345,-1,213,377,35,-1,378,196,37,-1,12,33,30,-1,12,187,28,-1,38,31,33,-1,30,187,12,-1,334,181,60,-1,101,174,379,-1,66,65,232,-1,85,380,83,-1,15,221,223,-1,12,11,237,-1,369,129,9,-1,326,381,331,-1,382,328,329,-1,328,382,383,-1,124,174,126,-1,124,379,174,-1,37,346,378,-1,346,37,38,-1,201,208,210,-1,198,208,201,-1,200,242,384,-1,194,242,200,-1,183,38,33,-1,183,345,38,-1,377,376,48,-1,377,341,376,-1,29,26,58,-1,29,190,26,-1,47,377,48,-1,47,35,377,-1,375,385,235,-1,375,216,385,-1,225,380,176,-1,386,380,225,-1,291,293,290,-1,291,117,293,-1,177,387,295,-1,387,177,85,-1,214,231,342,-1,214,81,231,-1,88,374,212,-1,374,88,338,-1,93,334,94,-1,93,181,334,-1,261,363,262,-1,364,363,261,-1,263,5,227,-1,263,371,5,-1,22,388,302,-1,22,8,388,-1,306,388,95,-1,388,306,125,-1,368,324,322,-1,368,271,324,-1,133,274,134,-1,248,274,133,-1,166,138,272,-1,166,136,138,-1,110,389,165,-1,110,370,389,-1,363,370,110,-1,363,365,370,-1,104,366,364,-1,104,390,366,-1,141,259,142,-1,259,141,252,-1,391,392,393,-1,391,257,392,-1,307,315,277,-1,307,309,315,-1,266,314,313,-1,314,266,318,-1,394,276,360,-1,349,276,394,-1,360,275,359,-1,275,360,276,-1,246,317,298,-1,317,246,358,-1,289,270,90,-1,289,297,270,-1,310,116,121,-1,296,116,310,-1,152,314,275,-1,314,152,312,-1,330,284,254,-1,282,284,330,-1,327,288,325,-1,286,288,327,-1,301,99,23,-1,278,99,301,-1,100,172,101,-1,100,280,172,-1,395,132,396,-1,132,395,130,-1,397,398,399,-1,400,398,397,-1,401,229,402,-1,372,229,401,-1,53,347,204,-1,53,55,347,-1,205,26,189,-1,27,26,205,-1,403,196,378,-1,206,196,403,-1,197,194,200,-1,195,194,197,-1,204,376,52,-1,344,376,204,-1,343,191,27,-1,347,191,343,-1,235,404,375,-1,235,234,404,-1,17,66,233,-1,17,16,66,-1,230,81,82,-1,231,81,230,-1,405,406,407,-1,239,406,405,-1,209,408,228,-1,408,209,211,-1,384,239,405,-1,242,239,384,-1,39,44,40,-1,42,44,39,-1,409,21,20,-1,409,236,21,-1,19,222,20,-1,69,222,19,-1,339,305,220,-1,305,339,410,-1,71,234,72,-1,234,71,404,-1};
			return value;
		}
		private int[] getlfmet_Geo_6_90_coordIndex_3()
		{
			int[] value = {83,386,232,-1,83,380,386,-1,372,89,229,-1,89,372,373,-1,398,401,411,-1,412,401,398,-1,184,335,182,-1,335,184,237,-1,180,413,414,-1,179,413,180,-1,59,415,336,-1,59,61,415,-1,337,182,335,-1,337,241,182,-1,414,397,399,-1,413,397,414,-1,416,415,417,-1,415,416,336,-1,399,411,417,-1,399,398,411,-1,417,418,416,-1,417,411,418,-1,409,15,14,-1,409,221,15,-1,223,94,334,-1,223,304,94,-1,135,333,143,-1,135,358,333,-1,332,144,143,-1,332,255,144,-1,245,140,333,-1,245,419,140,-1,419,331,253,-1,249,331,419,-1,362,394,360,-1,394,362,420,-1,421,392,422,-1,421,393,392,-1,420,382,0,-1,420,421,382,-1,381,422,251,-1,383,422,381,-1,329,325,330,-1,329,328,325,-1,327,331,250,-1,327,326,331,-1,324,320,323,-1,324,423,320,-1,424,265,321,-1,425,265,424,-1,323,258,260,-1,323,320,258,-1,319,255,332,-1,319,256,255,-1,361,424,391,-1,361,425,424,-1,142,332,140,-1,142,319,332,-1,390,396,366,-1,390,400,396,-1,366,132,365,-1,366,396,132,-1,367,153,147,-1,153,367,313,-1,147,368,367,-1,146,368,147,-1,370,268,389,-1,370,131,268,-1,165,162,160,-1,162,165,389,-1,277,349,102,-1,277,315,349,-1,291,154,311,-1,291,264,154,-1,115,291,311,-1,291,115,117,-1,150,115,151,-1,115,150,118,-1,123,310,120,-1,303,310,123,-1,124,308,379,-1,122,308,124,-1,125,303,123,-1,125,306,303,-1,357,283,354,-1,281,283,357,-1,426,97,279,-1,97,426,427,-1,98,355,300,-1,98,356,355,-1,352,428,299,-1,428,352,351,-1,285,354,283,-1,354,285,353,-1,299,348,316,-1,299,428,348,-1,300,96,98,-1,169,96,300,-1,8,95,388,-1,8,7,95,-1,369,171,92,-1,369,24,171,-1,128,178,9,-1,429,178,128,-1,3,371,292,-1,3,5,371,-1,85,3,387,-1,85,4,3,-1,339,294,410,-1,339,340,294,-1,387,292,290,-1,292,387,3,-1,410,296,310,-1,410,294,296,-1,292,113,264,-1,292,371,113,-1,179,429,413,-1,179,178,429,-1,23,302,301,-1,23,22,302,-1,428,286,348,-1,428,287,286,-1,283,288,285,-1,283,282,288,-1,287,353,285,-1,287,350,353,-1,351,287,428,-1,287,351,350,-1,300,352,299,-1,300,355,352,-1,97,356,98,-1,97,427,356,-1,357,279,281,-1,426,279,357,-1,410,303,305,-1,410,310,303,-1,296,117,116,-1,296,293,117,-1,138,274,273,-1,137,274,138,-1,136,167,108,-1,166,167,136,-1,268,162,389,-1,268,163,162,-1,127,268,131,-1,127,269,268,-1,167,148,114,-1,167,145,148,-1,321,267,322,-1,265,267,321,-1,130,429,128,-1,395,429,130,-1,429,397,413,-1,397,429,395,-1,261,227,106,-1,263,227,261,-1,424,257,391,-1,424,260,257,-1,425,360,359,-1,360,425,361,-1,323,424,321,-1,424,323,260,-1,359,265,425,-1,359,318,265,-1,423,256,320,-1,423,248,256,-1,381,253,331,-1,381,251,253,-1,421,383,382,-1,421,422,383,-1,394,0,2,-1,394,420,0,-1,252,422,392,-1,422,252,251,-1,421,362,393,-1,420,362,421,-1,419,141,140,-1,419,253,141,-1,247,419,245,-1,419,247,249,-1,245,358,246,-1,245,333,358,-1,247,155,250,-1,155,247,156,-1,14,236,409,-1,243,236,14,-1,416,407,406,-1,416,418,407,-1,418,408,407,-1,402,408,418,-1,416,337,336,-1,416,406,337,-1,399,415,414,-1,399,417,415,-1,241,406,239,-1,406,241,337,-1,241,183,182,-1,241,240,183,-1,61,414,415,-1,180,414,61,-1,232,385,233,-1,232,386,385,-1,67,77,64,-1,77,67,342,-1,411,402,418,-1,411,401,402,-1,400,412,398,-1,390,412,400,-1,105,76,373,-1,175,76,105,-1,64,76,226,-1,76,64,77,-1,84,232,65,-1,232,84,83,-1,220,69,339,-1,222,69,220,-1,41,21,236,-1,21,41,40,-1,221,20,222,-1,221,409,20,-1,220,304,223,-1,305,304,220,-1,375,217,215,-1,375,404,217,-1,213,341,377,-1,62,341,213,-1,208,405,211,-1,405,208,384,-1,407,211,405,-1,407,408,211,-1,338,82,374,-1,230,82,338,-1,233,216,17,-1,385,216,233,-1,203,206,403,-1,203,46,206,-1,207,27,205,-1,343,27,207,-1,347,192,191,-1,55,192,347,-1,47,203,202,-1,203,47,46,-1,403,199,203,-1,199,403,197,-1,195,403,378,-1,197,403,195,-1,346,195,378,-1,193,195,346,-1,189,196,205,-1,189,188,196,-1};
			return value;
		}
		private int[] getlfmet_Geo_6_90_coordIndex_4()
		{
			int[] value = {244,29,58,-1,244,185,29,-1,93,178,179,-1,178,93,7,-1,6,227,5,-1,175,227,6,-1,408,229,228,-1,229,408,402,-1,412,372,401,-1,103,372,412,-1,395,400,397,-1,396,400,395,-1,174,278,301,-1,278,174,173,-1,325,282,330,-1,288,282,325,-1,100,284,280,-1,284,100,254,-1,169,24,96,-1,171,24,169,-1,170,155,168,-1,155,170,316,-1,119,150,309,-1,118,150,119,-1,146,271,368,-1,146,272,271,-1,355,354,352,-1,357,354,355,-1,427,357,356,-1,427,426,357,-1,102,394,2,-1,349,394,102,-1,267,313,367,-1,267,266,313,-1,153,311,154,-1,153,312,311,-1,361,393,362,-1,361,391,393,-1,257,252,392,-1,257,259,252,-1,390,103,412,-1,104,103,390,-1,158,139,160,-1,158,137,139,-1,273,248,423,-1,273,274,248,-1,271,423,324,-1,271,273,423,-1,130,127,131,-1,127,130,128,-1,302,125,126,-1,388,125,302,-1,120,124,123,-1,122,124,120,-1,121,118,119,-1,118,121,116,-1,262,110,109,-1,363,110,262,-1,364,106,104,-1,364,261,106,-1,379,307,101,-1,307,379,308,-1,10,238,11,-1,10,13,238,-1,43,404,71,-1,43,217,404,-1,75,338,88,-1,338,75,80,-1,79,81,214,-1,81,79,78,-1,342,80,77,-1,231,80,342,-1,374,34,212,-1,34,374,78,-1,85,176,380,-1,176,85,177,-1,295,290,293,-1,295,387,290,-1,386,235,385,-1,386,225,235,-1,71,44,43,-1,71,70,44,-1,16,67,66,-1,16,63,67,-1,226,65,64,-1,84,65,226,-1,202,35,47,-1,202,36,35,-1,56,51,50,-1,51,56,53,-1,52,341,49,-1,376,341,52,-1,56,42,54,-1,56,45,42,-1,242,193,240,-1,193,242,194,-1,198,384,208,-1,200,384,198,-1,202,210,36,-1,201,210,202,-1,6,226,76,-1,4,226,6,-1,0,329,1,-1,329,0,382,-1,381,328,383,-1,326,328,381,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfmet_Coord_7_90_point_1()
		{
			double[] value = {2.18437,.18829,1.64413,2.13054,.18156,1.65225,2.14398,.21765,1.52179,2.42141,.8553,.94298,2.3966,.94577,.69491,2.42954,.92853,.96513,2.37978,1.04387,.74266,2.0013,.75956,1.15628,1.97842,.68491,1.3443,1.99243,.76162,1.36363,1.71392,1.0554,.14316,1.65053,1.12509,.21876,1.62249,1.15186,.12749,1.76778,1.05212,.33515,1.82073,1.0289,.27821,1.84815,.99892,.47999,2.50253,1.14638,-.01573,2.49739,1.09482,-.04363,2.49154,1.11167,-.12638,2.22393,.91855,.20422,2.10606,.93266,.19604,2.09364,.93742,.04098,1.95212,.63466,1.46113,1.94213,.59973,1.51293,1.9263,.6475,1.58343,1.9716,.99313,-.14923,1.85486,1.06478,-.0966,1.96393,1.09581,-.09769,1.7144,1.16593,.03612,1.72845,1.13189,-.00721,1.67836,1.25086,.12335,1.65534,1.32412,.13704,1.74916,1.23492,.07444,1.6415,1.32502,.15236,2.35035,1.38807,.01611,2.32771,1.35237,-.01601,2.34957,1.47885,.05659,1.75441,1.27107,.1028,1.66103,1.35509,.14091,2.09546,.8952,-.18012,2.07638,.90152,-.10539,1.99908,.91974,-.12613,2.20094,.88234,-.19938,2.30468,.87653,-.16479,2.21412,.87597,-.14604,2.35221,.9132,-.22514,2.25078,1.33503,.01072,2.30112,1.35065,-.01582,2.26029,1.25848,-.06865,2.4393,1.05955,-.17399,2.42647,.99083,-.22392,2.40822,1.00454,-.2165,2.41375,1.05919,-.16956,2.33878,.94922,-.2243,2.17771,.91555,-.23785,2.17603,.93844,-.23216,2.34737,.93159,-.2316,1.94185,.98244,-.14041,1.84749,1.04356,-.10192,1.74471,1.17481,.46567,1.80092,1.02757,.5384,1.81344,1.10914,.61203,2.45641,1.16326,-.11556,2.49842,1.19268,.00603,2.39414,1.12916,.30429,2.40244,1.07977,.28921,2.47957,1.11338,.11733,2.48204,1.16064,.1279,2.30656,.8976,.37205,2.22209,.90333,.36009,2.21611,.87687,-.10862,2.28487,.87396,-.10256,2.26751,.87781,.03241,2.2007,.89062,.03716,2.26828,.90144,.20008,2.39142,1.27089,.36717,2.3554,1.16884,.51665,2.39555,1.2012,.32885,2.39024,1.37219,.02943,2.35587,1.36247,.00458,2.42367,1.26049,.3081,2.48718,1.27032,.04129,2.47636,1.37412,.0633,2.38941,.95932,.41455,2.37685,1.01001,.44011,2.37008,.89235,.65408,2.02459,.93778,-.19516,1.89233,.96432,-.10909,2.44688,1.40568,.28567,2.3676,1.3452,.42258,2.02611,.75245,1.83313,2.02081,.72751,1.69105,2.00118,.7071,1.70359,1.97003,.82804,.99458,2.00393,.77326,.97544,2.0211,.69422,1.14712,1.91602,.62652,1.59874,1.99016,.46715,1.67934,1.9542,.50814,1.73765,1.9367,.57962,1.53229};
			return value;
		}
		private double[] getlfmet_Coord_7_90_point_2()
		{
			double[] value = {2.04582,.2282,1.60156,2.09882,.32609,1.50216,2.14677,.2325,1.51002,2.34275,1.23679,.82877,2.36088,1.11448,1.03145,2.37354,1.16487,.79645,2.4061,1.06587,1.01154,2.55003,.84977,1.62981,2.58671,.80452,1.60477,2.5099,.87566,1.45907,2.45503,.91392,1.48774,2.48931,.86372,1.32568,2.58639,.72613,1.39804,2.50636,.78289,1.29008,2.54871,.82247,1.43345,2.45843,.47831,1.40239,2.3221,.52854,1.28994,2.40957,.57786,1.26965,2.33758,.44168,1.42125,2.24989,.40867,1.42853,2.20268,.48924,1.30346,2.23368,.50096,1.30088,2.18175,.41186,1.41478,2.12724,.52035,1.29462,2.11401,.43568,1.41098,2.07645,.55201,1.29513,2.06947,.47718,1.41389,2.08979,.84728,1.49168,2.07793,.8941,1.382,1.99117,.73195,1.48787,2.22344,.97897,1.39164,2.25953,.94526,1.50251,2.26045,.99457,1.39134,2.54549,.8889,1.83875,2.54997,.89181,1.81823,2.4282,.93465,1.81469,2.60686,.7465,1.70038,2.5793,.79232,1.7512,2.59979,.72261,1.7356,2.58379,.8074,1.71248,2.331,.78534,2.04917,2.34094,.64775,2.10523,2.37234,.65941,2.09511,2.45975,.89978,1.9105,2.55606,.831,1.90712,2.62763,.71218,1.57727,2.63436,.67559,1.58319,2.61845,.67499,1.46612,2.61794,.71045,1.44724,2.36132,.38099,1.52054,2.35137,.4033,1.51164,2.47102,.45213,1.46443,2.49703,.43299,1.4786,2.60741,.59356,1.40253,2.59747,.6207,1.37829,1.98712,.66708,1.9737,2.04505,.79005,1.95519,2.03876,.79334,1.93343,2.52435,.86852,1.73843,2.41072,.93995,1.79692,2.51664,.87497,1.70999,2.39524,.92814,1.75688,2.3899,.93405,1.72429,2.2777,.91917,1.74591,2.285,.92531,1.78036,2.49933,.88379,1.64086,2.62007,.70968,1.6405,2.59782,.75389,1.58184,2.01021,.68475,1.91669,1.94303,.6301,1.75009,2.00254,.65956,1.91028,1.952,.65313,1.74416,2.07773,.32796,1.51876,2.03893,.42876,1.49219,2.05163,.43628,1.46867,2.37256,1.08873,.76454,2.34921,.90081,.41267,2.34316,.86499,.63841,1.99355,.82666,1.20306,1.9639,.90564,1.01139,1.89634,.99347,.82391,1.90583,.93551,.76356,1.6174,1.36366,.24564,1.6357,1.4188,.1884,1.60891,1.26003,.20838,1.69918,1.0654,.01925,1.69374,1.19612,.05667,1.65937,1.17623,.07749,1.76244,1.23737,.07645,1.78787,1.18137,.01386,1.74054,1.14655,-.00666,2.00617,.99664,-.15174,2.03267,.95428,-.19881,1.7297,1.53935,.21679,1.84909,1.6009,.24821,1.84753,1.5368,.21562,1.88427,1.29211,.07403,2.0027,1.5661,.2117,2.19456,1.64918,.21948,2.19514,1.58215,.17802};
			return value;
		}
		private double[] getlfmet_Coord_7_90_point_3()
		{
			double[] value = {2.00824,1.67063,.23743,2.30976,1.59962,.17201,2.32819,1.48894,.06158,2.23084,1.44894,.10916,2.33517,1.04059,-.15102,1.91498,1.2071,-.01768,2.06331,1.31173,.03845,2.10405,1.21376,-.03289,2.20618,1.66239,.2428,2.365,1.61059,.26938,2.33763,1.60772,.18974,2.23349,1.6478,.32498,2.40716,1.48385,.14202,2.39453,1.26814,-.0465,2.48522,1.2369,.02243,2.46972,.99788,-.13438,2.45734,.99353,-.06608,2.34695,.89083,-.15849,2.46262,.99099,-.20193,2.49631,1.08294,-.16958,2.14556,.85135,.61111,1.97289,.95229,.41118,2.12308,.90625,.35272,2.01055,.8629,.67033,2.32579,.90134,.22164,2.37392,.91603,.20964,2.36827,1.05676,.46762,2.42252,1.00143,.98933,2.37191,1.50734,.40131,2.34599,1.45205,.50098,2.4996,1.3247,.20146,2.49526,1.25379,.15369,2.43005,1.00773,.24451,2.47972,1.06147,.08981,2.33011,.88965,.04568,2.40075,.93092,.06201,1.9586,.98737,.04677,1.63796,1.18697,.30505,1.72508,1.09435,.39118,1.8639,1.59041,.36309,1.71348,1.54781,.23884,1.73418,1.49175,.34498,1.8415,1.60885,.27057,1.81145,1.04612,.08859,1.78895,1.03763,-.05893,2.1516,.81025,2.00063,2.1259,.86971,1.91075,2.08195,.73176,2.01746,2.5946,.77442,1.9014,2.10143,.68076,2.06381,1.99617,.57533,2.03942,2.27306,.46388,2.07691,2.38585,.47068,2.07351,2.25527,.62109,2.11873,2.05128,.17757,1.68066,2.54616,.79071,1.94644,2.55375,.72854,1.99023,2.46282,.28234,1.95711,2.4848,.50324,2.06166,2.4169,.48056,2.06449,2.51055,.35544,1.93063,2.43006,.9705,1.21169,2.45974,.92136,1.35119,2.44678,.91492,1.1847,2.49593,.69282,1.2706,2.62559,.42515,1.55159,2.63816,.51046,1.46384,2.67899,.55612,1.56822,2.27552,.90482,1.64192,2.10672,.81069,1.65641,2.12396,.81501,1.7992,2.63461,.59447,1.808,2.616,.68239,1.67129,2.63176,.65964,1.88269,2.59793,.77559,1.8827,2.49993,.38419,1.51208,2.40217,.29711,1.50782,2.16067,.32202,1.48664,1.9725,.50694,1.49014,2.01795,.34584,1.66013,2.02922,.24531,1.6098,2.00401,.28753,1.75212,2.02774,.20576,1.86643,2.01234,.28658,1.82539,2.03493,.19342,1.68536,2.03004,.34471,1.89113,2.03904,.43444,2.02332,2.00979,.44013,1.923,2.05572,.26686,1.96067,2.03078,.76165,1.8597,2.40917,.67051,1.14494,2.44818,.60852,1.25684,2.43723,.75515,1.15577,2.3813,.63816,1.14409,2.32154,.71103,.93194,2.3645,.75143,.91867,2.3122,.60215,1.15044,2.12219,.82549,1.83179,2.1189,.86705,1.89009,1.97745,.55361,1.88675};
			return value;
		}
		private double[] getlfmet_Coord_7_90_point_4()
		{
			double[] value = {1.96155,.54313,1.79725,1.97895,.52253,1.46706,1.98567,.5537,1.41753,2.13452,.58946,1.18864,2.07179,.73533,.96402,2.14906,.71012,.95704,2.083,.61883,1.19316,2.16533,.34223,1.47782,2.17617,.39862,1.43054,2.25627,.37296,1.49708,2.22305,.57998,1.16505,2.52549,.50647,1.39173,2.5543,.50238,1.4125,2.63629,.52912,1.44553,2.57206,.47051,1.42735,2.25594,.34342,1.51214,1.98048,.64728,1.95735,2.29508,.9295,1.82711,2.58391,.4587,1.44651,2.45768,.69519,2.05437,2.57418,.54783,2.02439,2.63816,.42236,1.70887,2.68175,.56273,1.65602,2.60733,.44131,1.89085,2.63547,.57761,1.81864,2.07275,.25573,1.97072,2.14325,.42366,2.06124,2.05526,.43513,2.03987,2.15738,.24727,1.97766,2.14158,.16702,1.84077,2.04195,.18899,1.86727,2.13209,.59621,2.09935,2.43066,.79369,2.00531,2.3184,.87676,1.95505,1.92341,.90231,.73434,1.6712,1.27576,.36943,1.81563,1.34898,.5742,1.76611,1.42162,.46066,2.47103,1.38298,.24667,2.24297,.83806,.62655,2.30153,.84526,.64001,2.37315,1.15531,-.1246,2.48873,1.20037,.13933,2.14452,1.09343,-.10819,2.31324,1.12475,-.12535,1.65525,1.42534,.17095,1.71748,1.42262,.16654,2.17878,1.00779,-.16406,1.98573,.55741,2.027,2.29332,.25699,1.55514,2.01134,.45045,1.85153,2.00386,.46761,1.8512,2.00133,.48552,1.83916,2.01728,.42216,1.84041,2.01176,.40485,1.81973,1.99669,.48168,1.81341,1.9947,.47012,1.79737,2.00947,.40414,1.79964,2.30011,.92788,1.85086,2.5177,.37355,1.52601,2.41793,.28441,1.51842,2.44624,.24241,1.63959,2.41657,.2259,1.64626,2.41411,.96392,1.37914,2.38433,1.01024,1.23637,2.34807,.98781,1.39892,2.33215,1.03709,1.26056,2.68163,.57651,1.55908,2.68094,.58036,1.65339,1.98102,.69569,1.49592,2.36157,.96194,1.50871,2.45342,.84372,1.1703,2.33713,1.35443,.64861,2.36144,1.26375,.58235,2.43639,1.4545,.13906,2.43327,.96029,-.07329,2.35057,1.14753,-.12608,2.29189,1.26025,-.07042,1.84911,1.40215,.15565,2.10348,.40921,1.44558,2.37989,.93275,.39817,2.19557,.43108,2.06929,2.19603,.17077,1.83514,2.21161,.2469,1.97673,2.00936,1.68371,.25915,2.42862,.96081,.07022,2.40408,.94458,.21274,2.39266,.78302,.92594,1.9978,.61315,1.31945,2.3959,.93051,1.63785,2.30156,1.13347,1.0578,2.4612,.22847,1.79329,2.43572,.2672,1.96268,2.43296,.21149,1.79852,2.29985,.24101,1.57231,2.18778,1.01267,1.28077,2.26177,1.04387,1.28017,2.13829,1.10376,1.07146,2.19254,1.25913,.88553,2.08428,1.22409,.8991};
			return value;
		}
		private double[] getlfmet_Coord_7_90_point_5()
		{
			double[] value = {2.23512,1.13462,1.0741,2.2409,1.39355,.68984,2.22147,1.48629,.56769,2.0277,1.41895,.138,2.33806,.88543,-.09702,2.05029,1.65929,.35298,1.89109,1.51112,.50356,2.08954,1.56143,.50911,2.22981,1.5434,.47777,1.96334,.98616,.22828,2.23197,.6961,.94978,2.14824,1.40453,.71098,2.2622,1.25791,.86593,2.01204,1.03322,1.05199,1.96519,1.13187,.87525,1.87698,1.26011,.70085,1.94204,1.44287,.61231,2.00982,1.34687,.73074,2.11683,1.49518,.60213,2.20209,.72998,2.08192,2.31679,.2146,1.65143,2.32469,.20327,1.81478,2.3057,.25711,1.96171,2.63075,.6495,1.90001,2.52849,.33025,1.73503,2.52053,.33688,1.60218,2.01425,.4197,1.77631,2.00586,.45662,1.78191,1.98543,.49585,1.92363,2.06648,.94091,1.27234};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlmet2_Geo_6_95_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,0,-1,4,5,6,-1,4,7,5,-1,8,9,10,-1,8,11,9,-1,4,12,13,-1,13,14,4,-1,7,15,5,-1,15,16,5,-1,12,17,18,-1,19,20,21,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,26,29,27,-1,30,19,21,-1,30,31,19,-1,32,33,34,-1,35,36,37,-1,38,39,40,-1,39,41,40,-1,42,33,43,-1,37,44,45,-1,37,46,44,-1,47,48,49,-1,47,50,48,-1,1,51,2,-1,1,52,51,-1,53,54,55,-1,56,57,52,-1,57,51,52,-1,10,58,59,-1,60,61,8,-1,8,62,60,-1,63,64,65,-1,64,66,65,-1,67,68,69,-1,69,70,67,-1,71,72,73,-1,74,75,76,-1,77,78,79,-1,78,80,81,-1,82,83,84,-1,85,84,83,-1,85,86,84,-1,87,88,89,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,63,97,98,-1,96,95,99,-1,95,100,99,-1,101,95,94,-1,101,102,95,-1,103,104,105,-1,105,106,103,-1,107,108,103,-1,103,109,107,-1,110,111,112,-1,104,103,108,-1,113,114,115,-1,68,67,116,-1,117,118,119,-1,119,120,117,-1,38,121,42,-1,122,123,124,-1,124,125,122,-1,126,28,27,-1,126,127,128,-1,126,27,127,-1,129,130,131,-1,132,133,119,-1,134,135,136,-1,135,137,136,-1,138,139,140,-1,141,142,143,-1,141,132,142,-1,144,145,146,-1,146,147,144,-1,148,149,137,-1,149,150,137,-1,151,152,153,-1,153,154,151,-1,155,121,40,-1,121,38,40,-1,129,156,157,-1,157,130,129,-1,32,43,33,-1,32,158,43,-1,159,160,161,-1,162,139,121,-1,113,163,114,-1,113,164,163,-1,165,166,167,-1,167,168,165,-1,169,170,171,-1,171,172,169,-1,173,174,175,-1,176,177,178,-1,176,179,177,-1,66,180,181,-1,66,64,180,-1,182,183,184,-1,185,186,112,-1,187,188,189,-1,190,191,192,-1,192,193,190,-1,194,195,186,-1,196,197,198,-1,196,199,197,-1,200,197,201,-1,200,202,197,-1,203,204,205,-1,204,206,205,-1,203,207,208,-1,203,205,207,-1,209,210,211,-1,209,212,210,-1,213,214,215,-1,214,216,215,-1,78,81,217,-1,217,79,78,-1,218,137,150,-1,218,136,137,-1,219,220,221,-1,65,222,63,-1,223,175,224,-1,223,225,175,-1,187,226,227,-1,187,189,226,-1,187,228,188,-1,228,82,188,-1,68,177,69,-1,177,179,69,-1,229,230,231,-1,232,233,234,-1,60,235,234,-1,61,231,236,-1,237,238,184,-1,239,240,84,-1,240,82,84,-1,239,241,242,-1,243,244,245,-1,246,247,93,-1,229,174,195,-1,195,230,229,-1,174,186,195,-1,87,99,248,-1,99,249,248,-1,174,173,250,-1,97,63,222,-1,106,110,109,-1,105,104,251,-1,100,252,253,-1,186,254,255,-1,256,255,257,-1,256,112,255,-1,100,95,102,-1,102,257,100,-1,107,258,108,-1,107,259,258,-1,108,258,260,-1,260,261,108,-1,89,216,94,-1,262,196,216,-1,262,90,196,-1,263,264,265,-1,77,266,78,-1,267,213,215,-1,268,269,270,-1,268,263,77,-1,167,115,271,-1,167,113,115,-1,272,273,274,-1,273,275,274,-1,220,276,277,-1,220,278,276,-1,279,280,277,-1,279,277,281,-1,277,276,281,-1,282,46,37,-1,20,283,284,-1,20,285,283,-1,43,286,39,-1,43,158,286,-1,287,42,121,-1,47,288,29,-1,29,26,47,-1,289,128,122,-1,165,168,54,-1,290,291,292,-1,292,293,290,-1,294,272,295,-1,272,274,295,-1,18,294,13,-1,294,295,13,-1,296,297,34,-1,296,298,297,-1,151,299,152,-1,299,300,152,-1,301,302,118,-1,301,303,302,-1,120,119,133,-1,133,304,120,-1,302,142,132,-1,132,119,302,-1,134,136,305,-1,306,137,135,-1,306,148,137,-1,120,147,307,-1,307,117,120,-1,143,282,36,-1,282,37,36,-1,32,34,297,-1,161,308,309,-1,310,290,293,-1,310,311,290,-1,28,57,312,-1,313,156,314,-1,156,129,314,-1,125,165,315,-1,125,166,165,-1,26,50,47,-1,316,45,317,-1,45,318,317,-1,319,303,301,-1,301,320,319,-1,41,39,286,-1,286,31,41,-1,23,321,24,-1,23,322,321,-1,285,323,283,-1,323,281,283,-1,309,308,279,-1,226,324,325,-1,226,189,324,-1,326,327,328,-1,326,325,327,-1,268,77,329,-1,201,263,268,-1,268,200,201,-1,268,270,330,-1,268,329,269,-1,267,215,198,-1,206,213,267,-1,267,202,206,-1,263,265,266,-1,263,201,264,-1,216,89,262,-1};
			return value;
		}
		private int[] getlmet2_Geo_6_95_coordIndex_2()
		{
			int[] value = {208,331,203,-1,208,332,331,-1,332,208,333,-1,333,334,332,-1,257,252,100,-1,112,186,255,-1,105,251,111,-1,106,109,103,-1,335,336,337,-1,98,338,63,-1,75,74,339,-1,339,340,75,-1,224,175,341,-1,175,174,341,-1,93,247,342,-1,342,91,93,-1,343,199,92,-1,179,76,69,-1,84,86,239,-1,86,241,239,-1,182,344,345,-1,346,347,182,-1,346,348,347,-1,349,210,212,-1,212,58,349,-1,231,230,236,-1,235,232,234,-1,350,229,231,-1,236,8,61,-1,236,11,8,-1,69,76,70,-1,76,75,70,-1,219,82,240,-1,219,188,82,-1,221,188,219,-1,221,189,188,-1,351,225,223,-1,351,352,225,-1,353,180,64,-1,278,220,219,-1,219,178,278,-1,266,77,263,-1,343,201,197,-1,197,199,343,-1,354,92,91,-1,354,355,92,-1,353,63,173,-1,353,64,63,-1,217,81,356,-1,356,357,217,-1,192,191,358,-1,343,92,359,-1,92,355,359,-1,237,360,232,-1,91,361,354,-1,91,342,361,-1,339,74,362,-1,362,74,363,-1,225,173,175,-1,225,353,173,-1,72,179,176,-1,72,71,179,-1,364,280,275,-1,364,277,280,-1,22,25,365,-1,319,366,303,-1,319,367,366,-1,317,288,316,-1,317,29,288,-1,368,369,305,-1,370,371,20,-1,371,21,20,-1,365,25,21,-1,21,371,365,-1,372,161,160,-1,160,14,372,-1,279,323,309,-1,279,281,323,-1,312,373,374,-1,373,17,374,-1,375,301,376,-1,375,320,301,-1,146,377,147,-1,377,307,147,-1,153,291,154,-1,153,292,291,-1,35,37,316,-1,37,45,316,-1,378,305,136,-1,304,218,150,-1,304,133,218,-1,379,328,380,-1,379,326,328,-1,55,314,129,-1,131,130,56,-1,381,126,128,-1,128,289,381,-1,166,124,164,-1,166,125,124,-1,302,119,118,-1,53,129,131,-1,53,55,129,-1,223,382,351,-1,223,383,382,-1,384,341,385,-1,384,224,341,-1,371,163,386,-1,386,365,371,-1,370,163,371,-1,370,114,163,-1,370,20,284,-1,387,185,251,-1,109,256,107,-1,110,256,109,-1,110,112,256,-1,258,332,260,-1,258,331,332,-1,58,388,349,-1,96,99,87,-1,255,252,257,-1,338,389,250,-1,390,85,83,-1,193,79,217,-1,83,391,390,-1,355,354,243,-1,76,179,71,-1,234,61,60,-1,234,231,61,-1,57,392,51,-1,57,381,392,-1,165,54,53,-1,2,51,393,-1,51,392,393,-1,366,367,394,-1,316,288,395,-1,395,35,316,-1,320,396,322,-1,396,321,322,-1,35,368,36,-1,22,172,23,-1,374,290,311,-1,311,312,374,-1,32,323,158,-1,32,309,323,-1,30,25,24,-1,30,21,25,-1,312,311,28,-1,311,26,28,-1,20,19,285,-1,397,15,7,-1,397,398,15,-1,18,13,12,-1,4,6,12,-1,399,400,397,-1,399,401,400,-1,355,245,402,-1,245,355,243,-1,348,191,190,-1,346,191,348,-1,403,58,358,-1,59,58,403,-1,356,404,405,-1,356,406,404,-1,402,407,408,-1,407,402,245,-1,12,374,17,-1,6,374,12,-1,401,160,159,-1,399,160,401,-1,398,400,409,-1,400,398,397,-1,127,29,317,-1,27,29,127,-1,410,124,411,-1,410,386,124,-1,158,285,286,-1,285,158,323,-1,16,154,291,-1,15,154,16,-1,151,409,299,-1,409,151,398,-1,291,374,16,-1,374,291,290,-1,386,169,365,-1,386,410,169,-1,159,297,298,-1,159,161,297,-1,377,300,412,-1,300,377,152,-1,292,146,145,-1,153,146,292,-1,413,310,293,-1,413,414,310,-1,412,296,138,-1,412,300,296,-1,396,415,321,-1,155,415,396,-1,319,170,367,-1,319,171,170,-1,46,416,44,-1,394,416,46,-1,34,42,287,-1,42,34,33,-1,417,392,418,-1,393,392,417,-1,419,420,421,-1,420,419,422,-1,423,3,424,-1,3,423,0,-1,418,381,289,-1,418,392,381,-1,424,131,423,-1,131,424,53,-1,315,418,289,-1,315,421,418,-1,354,73,243,-1,354,361,73,-1,193,357,190,-1,193,217,357,-1,348,425,347,-1,426,425,348,-1,405,427,428,-1,405,404,427,-1,338,173,63,-1,173,338,250,-1,389,254,250,-1,429,254,389,-1,89,246,262,-1,246,89,88,-1,334,260,332,-1,260,334,430,-1,258,431,331,-1,258,259,431,-1,432,336,335,-1,432,433,336,-1,111,185,112,-1,111,251,185,-1,340,248,337,-1,434,248,340,-1,284,435,115,-1,284,436,435,-1,169,416,170,-1,169,410,416,-1,70,222,65,-1,70,75,222,-1,370,115,114,-1,370,284,115,-1,385,350,233,-1,341,350,385,-1,383,224,384,-1};
			return value;
		}
		private int[] getlmet2_Geo_6_95_coordIndex_3()
		{
			int[] value = {224,383,223,-1,379,351,382,-1,351,379,437,-1,438,55,54,-1,55,438,380,-1,380,314,55,-1,380,328,314,-1,372,308,161,-1,439,308,372,-1,378,218,141,-1,378,136,218,-1,117,440,376,-1,307,440,117,-1,24,415,30,-1,24,321,415,-1,31,415,41,-1,30,415,31,-1,369,35,395,-1,369,368,35,-1,366,302,303,-1,366,142,302,-1,372,13,295,-1,372,14,13,-1,274,280,439,-1,275,280,274,-1,441,276,278,-1,441,442,276,-1,443,444,445,-1,444,443,271,-1,352,353,225,-1,353,352,180,-1,342,363,361,-1,362,363,342,-1,247,362,342,-1,339,362,247,-1,184,344,182,-1,184,238,344,-1,86,446,241,-1,446,86,427,-1,242,243,73,-1,243,242,244,-1,447,360,237,-1,447,448,360,-1,449,226,450,-1,226,449,227,-1,402,359,355,-1,359,402,451,-1,358,212,192,-1,358,58,212,-1,406,452,408,-1,452,406,80,-1,186,387,194,-1,186,185,387,-1,207,333,208,-1,453,333,207,-1,266,80,78,-1,266,452,80,-1,451,264,359,-1,265,264,451,-1,196,215,216,-1,198,215,196,-1,68,441,177,-1,116,441,68,-1,384,449,383,-1,449,384,448,-1,176,219,240,-1,176,178,219,-1,454,236,230,-1,454,11,236,-1,388,10,9,-1,58,10,388,-1,448,385,360,-1,448,384,385,-1,235,237,232,-1,237,235,238,-1,345,59,403,-1,345,62,59,-1,403,182,345,-1,403,346,182,-1,228,237,455,-1,447,237,228,-1,451,408,452,-1,408,451,402,-1,407,427,404,-1,407,446,427,-1,72,240,239,-1,176,240,72,-1,201,359,264,-1,201,343,359,-1,9,430,388,-1,430,9,456,-1,339,434,340,-1,339,247,434,-1,389,98,433,-1,389,338,98,-1,429,433,432,-1,429,389,433,-1,430,261,260,-1,456,261,430,-1,207,330,453,-1,330,207,205,-1,431,214,204,-1,431,101,214,-1,269,457,209,-1,329,457,269,-1,453,270,211,-1,330,270,453,-1,267,197,202,-1,267,198,197,-1,268,205,200,-1,330,205,268,-1,444,181,180,-1,444,435,181,-1,438,445,437,-1,445,438,443,-1,382,326,379,-1,382,450,326,-1,328,313,314,-1,328,327,313,-1,325,273,327,-1,325,324,273,-1,324,221,364,-1,189,221,324,-1,289,125,315,-1,122,125,289,-1,410,44,416,-1,44,410,411,-1,386,164,124,-1,386,163,164,-1,396,375,162,-1,375,396,320,-1,440,375,376,-1,140,375,440,-1,28,381,57,-1,126,381,28,-1,56,312,57,-1,56,373,312,-1,311,50,26,-1,311,310,50,-1,156,18,157,-1,156,294,18,-1,458,395,49,-1,369,395,458,-1,148,48,414,-1,48,148,306,-1,145,149,413,-1,145,144,149,-1,376,118,117,-1,118,376,301,-1,144,150,149,-1,144,304,150,-1,135,458,306,-1,458,135,134,-1,368,378,36,-1,305,378,368,-1,134,369,458,-1,369,134,305,-1,282,142,366,-1,282,143,142,-1,412,307,377,-1,307,412,440,-1,149,414,413,-1,148,414,149,-1,49,306,458,-1,49,48,306,-1,300,298,296,-1,298,300,299,-1,313,294,156,-1,313,272,294,-1,17,157,18,-1,17,373,157,-1,393,420,422,-1,393,417,420,-1,140,162,375,-1,140,139,162,-1,23,171,322,-1,23,172,171,-1,46,366,394,-1,282,366,46,-1,44,318,45,-1,44,411,318,-1,436,283,442,-1,283,436,284,-1,116,442,441,-1,116,436,442,-1,220,364,221,-1,277,364,220,-1,364,273,324,-1,364,275,273,-1,327,272,313,-1,327,273,272,-1,443,54,168,-1,443,438,54,-1,437,352,351,-1,352,437,445,-1,435,271,115,-1,435,444,271,-1,211,269,209,-1,269,211,270,-1,79,329,77,-1,79,457,329,-1,214,94,216,-1,214,101,94,-1,456,194,261,-1,454,194,456,-1,261,387,108,-1,194,387,261,-1,256,259,107,-1,257,259,256,-1,257,102,259,-1,252,432,253,-1,252,429,432,-1,250,186,174,-1,250,254,186,-1,222,336,97,-1,222,337,336,-1,249,337,248,-1,249,335,337,-1,247,88,434,-1,247,246,88,-1,210,334,333,-1,210,349,334,-1,194,230,195,-1,194,454,230,-1,239,73,72,-1,239,242,73,-1,245,446,407,-1,446,245,244,-1,183,83,455,-1,183,391,83,-1,455,82,228,-1,455,83,82,-1,184,455,237,-1,184,183,455,-1,238,60,344,-1,238,235,60,-1,360,233,232,-1,385,233,360,-1,62,10,59,-1,10,62,8,-1,229,341,174,-1,341,229,350,-1,447,187,227,-1,447,228,187,-1,383,450,382,-1,450,383,449,-1,218,132,141,-1,218,133,132,-1,266,451,452,-1,266,265,451,-1};
			return value;
		}
		private int[] getlmet2_Geo_6_95_coordIndex_4()
		{
			int[] value = {209,192,212,-1,209,457,192,-1,457,193,192,-1,79,193,457,-1,333,211,210,-1,211,333,453,-1,214,206,204,-1,214,213,206,-1,331,204,203,-1,331,431,204,-1,206,200,205,-1,206,202,200,-1,92,196,90,-1,92,199,196,-1,11,456,9,-1,11,454,456,-1,428,426,405,-1,428,425,426,-1,325,450,226,-1,325,326,450,-1,448,227,449,-1,227,448,447,-1,244,241,446,-1,244,242,241,-1,85,425,428,-1,85,390,425,-1,182,391,183,-1,347,391,182,-1,445,180,352,-1,180,445,444,-1,271,168,167,-1,271,443,168,-1,177,278,178,-1,177,441,278,-1,442,281,276,-1,442,283,281,-1,439,295,274,-1,439,372,295,-1,113,166,164,-1,167,166,113,-1,155,162,121,-1,155,396,162,-1,373,130,157,-1,56,130,373,-1,147,304,144,-1,147,120,304,-1,121,138,287,-1,121,139,138,-1,412,140,440,-1,138,140,412,-1,36,141,143,-1,36,378,141,-1,279,439,280,-1,279,308,439,-1,122,127,123,-1,122,128,127,-1,437,380,438,-1,380,437,379,-1,66,116,67,-1,116,66,181,-1,337,75,340,-1,337,222,75,-1,181,436,116,-1,435,436,181,-1,434,87,248,-1,88,87,434,-1,251,108,387,-1,104,108,251,-1,111,106,105,-1,106,111,110,-1,100,249,99,-1,100,253,249,-1,433,97,336,-1,433,98,97,-1,335,253,432,-1,249,253,335,-1,101,259,102,-1,101,431,259,-1,334,388,430,-1,349,388,334,-1,96,89,94,-1,89,96,87,-1,93,262,246,-1,93,90,262,-1,255,429,252,-1,255,254,429,-1,81,406,356,-1,81,80,406,-1,86,428,427,-1,428,86,85,-1,390,347,425,-1,347,390,391,-1,363,76,71,-1,363,74,76,-1,361,71,73,-1,361,363,71,-1,65,67,70,-1,65,66,67,-1,231,233,350,-1,234,233,231,-1,53,419,165,-1,53,424,419,-1,423,56,52,-1,56,423,131,-1,165,421,315,-1,165,419,421,-1,52,0,423,-1,0,52,1,-1,3,419,424,-1,422,419,3,-1,421,417,418,-1,417,421,420,-1,49,288,47,-1,49,395,288,-1,416,367,170,-1,416,394,367,-1,320,171,319,-1,171,320,322,-1,155,41,415,-1,40,41,155,-1,39,42,43,-1,42,39,38,-1,50,414,48,-1,310,414,50,-1,145,293,292,-1,145,413,293,-1,146,152,377,-1,146,153,152,-1,296,287,138,-1,296,34,287,-1,32,161,309,-1,161,32,297,-1,19,286,285,-1,19,31,286,-1,318,124,123,-1,124,318,411,-1,298,409,159,-1,298,299,409,-1,154,398,151,-1,154,15,398,-1,22,169,172,-1,22,365,169,-1,123,317,318,-1,127,317,123,-1,400,159,409,-1,401,159,400,-1,399,14,160,-1,4,14,399,-1,6,16,374,-1,5,16,6,-1,62,344,60,-1,62,345,344,-1,408,404,406,-1,404,408,407,-1,405,357,356,-1,426,357,405,-1,190,426,348,-1,190,357,426,-1,358,346,403,-1,358,191,346,-1,399,7,4,-1,399,397,7,-1,2,422,3,-1,422,2,393,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlmet2_Coord_7_95_point_1()
		{
			double[] value = {3.09887,.76525,1.65676,3.09979,.75606,1.67754,3.10515,.73732,1.68843,3.09561,.76628,1.64286,2.79508,.78196,1.76054,2.81505,.77842,1.80549,2.8199,.78586,1.79982,2.81009,.76824,1.80699,2.76274,1.90545,-.15432,2.77938,1.8761,-.24139,2.72252,1.92593,-.21307,2.80963,1.84611,-.15632,2.81792,.79871,1.77787,2.81875,.84409,1.68003,2.79455,.79719,1.66508,2.83977,.74981,1.85915,2.87841,.78223,1.85514,2.88944,.84554,1.78553,2.86702,.89397,1.70586,2.8264,.64991,1.41571,2.8567,.65924,1.41895,2.87224,.56733,1.47834,2.89071,.44033,1.58368,2.86532,.41413,1.6201,2.85773,.48605,1.55121,2.87836,.4856,1.54885,3.14017,.7058,1.83685,3.12525,.60765,1.84634,3.12787,.69681,1.81799,3.14115,.60069,1.8647,2.851,.5621,1.48113,2.80642,.63609,1.4161,2.74982,.75426,1.41196,2.71463,.71578,1.39832,2.71638,.67873,1.55155,3.17042,.5184,1.87823,3.11316,.45842,1.91816,3.09055,.43338,1.71279,2.73621,.67465,1.38462,2.74476,.68119,1.37636,2.76041,.62561,1.40114,2.77149,.62888,1.39672,2.71016,.70475,1.40261,2.71683,.71337,1.39627,3.02742,.42362,1.52735,3.08914,.44156,1.70323,3.02474,.41407,1.53762,3.16508,.68312,1.87203,3.14521,.73766,1.89128,3.16921,.67158,1.88677,3.14275,.73913,1.8788,3.11178,.71363,1.7466,3.08127,.79026,1.7036,3.0595,.83783,1.54993,3.01632,.87787,1.46821,3.01501,.89344,1.47805,3.06616,.81171,1.70217,3.11087,.7157,1.78261,2.67428,1.95054,-.26562,2.7049,1.9348,-.19425,2.77615,1.89484,-.06431,2.80357,1.86905,-.09646,2.74103,1.91606,-.13114,2.74616,1.36971,.21626,2.78666,1.30784,.44067,2.66325,1.29581,.20296,2.73628,1.27824,.43849,2.70921,1.27384,.44208,2.68124,1.27113,.46153,2.59126,1.317,.22196,2.63916,1.29311,.20887,2.44667,1.49193,.17805,2.43594,1.5235,.19833,2.3612,1.60284,.11419,2.56152,1.32605,.17634,2.63265,1.28998,.18279,2.58422,1.32351,.21368,2.32438,1.881,-.15238,2.21424,2.00802,-.0956,2.34768,1.99783,-.14509,2.21124,2.00454,-.08398,2.22776,2.01398,-.09071,2.54853,1.62959,.38955,2.50632,1.71771,.26531,2.4713,1.69414,.27658,2.4337,1.79758,.18957,2.39248,1.77627,.21036,2.46536,1.22088,-.35306,2.45405,1.21846,-.34106,2.44858,1.23182,-.36285,2.32372,1.37597,-.20215,2.31521,1.50888,-.09472,2.30829,1.52339,-.11548,2.33421,1.36014,-.18435,2.47101,1.28754,-.4029,2.50222,1.29119,-.397,2.49064,1.2713,-.39031,2.73494,1.34524,.15647,2.74269,1.36377,.1399,2.51073,1.25205,-.35726};
			return value;
		}
		private double[] getlmet2_Coord_7_95_point_2()
		{
			double[] value = {2.52865,1.2755,-.35066,2.54165,1.41192,-.4215,2.55752,1.40365,-.40861,2.67326,1.58038,-.26737,2.68456,1.58954,-.25191,2.67166,1.5849,-.19813,2.66148,1.57368,-.20602,2.62928,1.52055,-.29219,2.68411,1.59598,-.27569,2.63016,1.52449,-.27916,2.68383,1.54122,-.17847,2.69379,1.55093,-.16742,2.69053,1.53152,-.16213,2.95859,.6663,1.41398,2.92085,.64904,1.39827,2.85658,.83638,1.25193,2.74837,1.11256,.7903,2.86894,.50764,1.96284,2.90466,.44635,1.94995,2.93462,.54383,2.04807,2.92565,.61455,2.07002,2.71666,.57019,1.51712,3.05879,.54427,1.67946,3.06826,.4981,1.67748,3.01618,.48074,1.50381,3.03209,.56739,1.54476,3.10287,.63027,1.81291,3.09482,.56614,1.81041,3.07786,.58374,1.75742,3.02188,.87825,1.56596,3.05279,.84991,1.63532,3.06608,.84687,1.62319,2.99201,.46972,2.00469,2.97675,.54021,2.05379,3.1302,.58249,1.99955,3.10654,.62703,2.02691,3.08445,.56213,2.03226,3.06264,.65343,2.05351,2.744,.60117,1.67329,2.73053,.54241,1.61106,2.74471,.53579,1.66669,3.05401,.461,1.98602,2.99295,.40603,1.9373,3.05201,.41721,1.92354,2.91716,.75677,2.02069,2.89667,.81727,1.9393,2.85811,.76034,1.95837,2.88421,.69942,2.02305,3.04445,.76429,1.98753,2.9712,.78007,2.00832,3.00578,.65033,2.06624,2.8272,.67953,1.85574,2.81949,.66387,1.91097,2.85487,.76242,1.94504,2.84252,.74531,1.88304,2.80077,.53395,1.47898,2.97928,.91992,1.57719,2.99606,.87241,1.67298,2.75764,.7313,1.38701,2.78787,.691,1.7038,2.77942,.74839,1.66906,2.77778,.76282,1.5585,2.7388,.512,1.57367,2.93829,.56147,1.46023,2.98676,.56741,1.45934,3.02817,.7465,1.52962,3.01236,.65828,1.49033,2.97493,.74563,1.44439,3.00138,.80876,1.46853,2.93892,.44208,1.52839,2.93711,.40778,1.54883,2.87868,.38094,1.65107,2.87773,.4029,1.63301,2.78028,1.49427,.23031,2.82929,1.59025,.07802,2.79781,1.55808,.24306,2.49324,1.45874,.32959,2.627,1.313,.49524,2.57291,1.35487,.52895,2.54212,1.38787,.27577,2.8185,1.17597,.78529,2.7706,1.11552,.78547,2.50998,1.87688,.03664,2.55239,1.81179,.13983,2.60716,1.82363,.11331,2.73939,1.60467,-.14274,2.76735,1.56594,-.04562,2.68294,1.58528,.53308,2.60928,1.52872,.56236,2.7351,1.36251,.88758,2.41448,1.95062,-.09343,2.46763,1.95783,-.11121,2.47718,1.99375,-.1999,2.3621,2.01172,-.14652,2.77412,1.66425,-.16492,2.82869,1.61512,-.04982,2.29656,1.44559,-.27556,2.29014,1.54523,-.23504,2.30222,1.45845,-.28699,2.28841,1.54026,-.21709};
			return value;
		}
		private double[] getlmet2_Coord_7_95_point_3()
		{
			double[] value = {2.4226,1.63669,-.27678,2.3064,1.63387,-.20407,2.40561,1.55294,-.32131,2.53268,1.6698,-.37796,2.52521,1.57219,-.41918,2.52716,1.68296,-.37165,2.51016,1.57418,-.41257,2.58472,1.6967,-.41886,2.59257,1.68334,-.42405,2.58123,1.98669,-.30866,2.66004,1.91909,-.39033,2.64377,1.90949,-.38934,2.59326,1.99498,-.3032,2.45191,1.45485,-.41261,2.47224,1.44853,-.42266,2.37764,1.37272,-.40202,2.37951,1.35533,-.40107,2.34172,2.0134,-.13776,3.0368,.54623,2.05103,2.56921,1.44873,.55031,2.62667,1.21968,.87712,2.64863,1.29718,.87987,2.65744,1.29326,.18022,2.8535,1.48244,.47308,2.81588,1.60538,.24537,2.84956,1.4287,.4633,2.82692,1.39009,.88583,2.76447,1.58314,.52306,2.6435,1.67606,.35884,2.85318,1.69873,.03614,2.83749,1.72879,-.06479,2.83874,1.79929,-.01417,2.80365,1.79879,.09656,2.82167,1.74667,.11397,2.82585,1.82187,.03017,2.76526,1.85809,.02317,2.82981,1.81952,-.09954,2.7047,1.77016,.1904,2.6895,1.85046,.08193,2.42464,1.63827,.29686,2.48201,1.5601,.38595,2.34881,1.72812,.20737,2.34462,1.69842,.19245,2.28179,1.67666,.01392,2.26481,1.75859,.08804,2.24213,1.77734,.04911,2.37724,1.26093,-.28002,2.42824,1.26756,-.07088,2.5612,1.21471,-.16089,2.59508,1.25576,-.17848,2.72706,1.47263,.0564,2.73059,1.60533,-.15504,2.59406,1.39531,-.20981,2.6087,1.29314,-.18957,2.67503,1.46976,-.06694,2.61186,1.42547,-.1919,2.62765,1.51202,-.28708,2.57974,1.39293,-.32471,2.61622,1.60651,-.35675,2.6056,1.51802,-.39708,2.66466,1.65873,-.3766,2.71833,1.66081,-.28855,2.36733,1.27618,-.29833,2.26177,1.79118,-.1607,2.24076,1.7266,-.15872,2.18545,1.83894,-.08675,2.17264,1.93542,-.08516,2.38885,1.46916,-.36572,2.43884,1.75109,-.2324,2.52293,1.88395,-.276,2.55585,1.85117,-.32789,2.91603,.8935,1.25438,2.86545,.99033,1.47899,2.84269,1.06486,1.36775,2.80583,.96022,1.46645,2.78601,1.02653,1.34544,2.70507,1.02922,1.11511,2.70935,1.06672,1.1519,2.64443,1.17503,.85494,2.73413,.90152,1.31716,2.75983,.96403,1.3313,2.75729,.87092,1.29083,3.03476,.37812,1.74414,2.80173,.8486,1.27116,2.83427,.83221,1.25673,2.78208,.71828,1.35878,2.76758,.70031,1.36717,2.71205,.6665,1.54831,3.1711,.58393,1.88876,3.05766,.60403,1.68607,2.91101,.81968,1.85269,2.88639,.78749,1.87634,2.89193,.81788,1.92685,2.95125,.84133,1.91352,2.86462,.95556,1.56325,2.81334,.92086,1.54594,2.74832,.61377,1.67685,2.77222,.74334,1.56373,2.78097,.6643,1.7014,2.80223,.65926,1.79269};
			return value;
		}
		private double[] getlmet2_Coord_7_95_point_4()
		{
			double[] value = {2.78044,.61152,1.80173,2.85056,.39779,1.7916,2.95209,.4117,1.94028,2.9122,.3685,1.77157,2.95503,.63693,2.07652,3.13576,.53423,1.98496,3.13456,.70073,1.96217,2.84785,.57696,1.96587,2.756,.83065,1.42795,2.75587,.777,1.40159,3.04757,.80475,1.89317,3.01642,.77024,1.83768,3.02499,.76174,1.81711,2.94989,.98697,1.47274,2.98516,.93713,1.47215,3.03339,.64478,1.57492,3.17301,.52634,1.86769,3.1144,.54081,1.84193,3.07833,.46067,1.68072,2.88078,.37503,1.66225,2.82783,.41294,1.61738,2.82532,.46949,1.5454,2.83628,.41471,1.61073,2.77074,.74362,1.37472,2.80636,1.19875,1.18949,2.88294,1.20674,1.1755,2.93399,1.17518,1.15125,2.92523,1.06048,1.35299,2.95341,1.02242,1.34117,2.45817,1.90807,-.20905,2.5542,1.77814,-.35631,2.59927,1.61849,-.37034,2.64678,1.66276,-.39384,2.63868,1.78974,-.41289,2.68716,1.79318,-.37114,2.66018,1.27584,-.05664,2.70397,1.30311,.07254,2.6424,1.24752,.0158,2.72531,1.4195,.11377,2.48667,1.28435,.07098,2.58566,1.23673,.03453,2.81216,1.6612,.16686,2.38068,1.4113,.03034,2.29966,1.62503,-.19058,2.66602,1.90332,-.00312,2.63754,1.92379,-.05574,2.48866,1.91777,-.03812,2.47691,1.86072,.05054,2.44556,1.90603,-.02217,2.71701,1.91768,-.33172,2.84297,1.70281,.09012,2.89943,1.29396,.84063,2.86464,1.24338,.8169,2.82137,1.3697,.45516,2.28626,1.65436,-.00364,2.25745,1.68453,-.04912,2.294,1.97097,-.021,2.38665,1.95128,-.08068,2.54843,1.97138,-.15126,2.23636,1.71638,-.14567,2.76799,1.73513,.19404,2.36201,1.57077,.08616,2.45927,1.37896,.12391,2.44476,1.4594,.14996,2.72741,1.12998,1.17543,2.92469,.47316,1.51917,2.97502,.3624,1.75819,2.94557,.40068,1.55471,3.1647,.51148,1.91318,3.17241,.56384,1.92606,2.89719,.6474,1.39942,2.91181,.56168,1.46491,2.78312,.85247,1.53718,3.0115,.83405,1.75038,2.89868,.81372,1.83114,2.76118,.46836,1.63516,2.81067,.45746,1.80304,2.81997,.65324,1.92022,3.09691,.48955,1.98402,2.94676,1.14563,1.13478,2.9763,.99117,1.33557,3.08368,.64052,1.77538,2.90064,1.31146,.84846,2.8514,1.50085,.48081,2.8085,1.6358,.26764,2.79696,1.6924,.18689,2.95423,.47137,1.50634,2.7421,1.61499,-.15201,2.73327,1.91246,-.31188,2.70926,1.42231,.05477,2.46104,1.7855,.17028,2.48935,1.78761,.15733,3.08341,.66178,1.75432,3.10097,.72506,1.68637,2.96427,.40563,1.54209,3.1758,.58288,1.90047,2.81337,.46978,1.54649,2.80362,.75627,1.80338,2.82788,.69841,1.83886,2.79149,.77041,1.76148};
			return value;
		}
		private double[] getlmet2_Coord_7_95_point_5()
		{
			double[] value = {2.79816,.752,1.79021,2.79342,.75307,1.76954,2.21946,1.7961,.01017,2.59303,1.94742,-.10316,2.28568,1.90498,.06228,2.33295,1.91918,.04717,2.24954,1.95368,-.00523,2.24634,1.85473,.06949,2.21949,1.89154,.02108,2.80756,.68332,1.78976,2.95799,.44324,1.51982,3.02247,.449,1.51427,2.77847,.59784,1.80315,2.954,.84044,1.92572,3.0502,.80503,1.90487,2.81245,.53527,1.47687,2.95972,.41329,1.53278,3.09427,.71672,1.6706,3.05969,.6293,1.67524,3.03869,.74899,1.55055,3.08995,.72544,1.65047,3.04211,.66499,1.59293,3.08904,.74597,1.64012,3.07821,.82781,1.61863,3.06592,.83203,1.56177,2.44761,1.86149,.05996,2.41699,1.90674,-.01111,2.32183,1.85629,.12978,2.37191,1.86738,.11534,2.66194,1.4206,-.05902,2.70327,1.78769,-.35196,2.58857,1.5263,-.41139,2.67745,1.32103,-.06639,2.72008,1.33921,.0615,2.50798,1.20668,-.13633,2.82398,.9879,1.03888,2.80214,.98353,1.0449,2.9449,1.12951,1.12455,2.97682,.97564,1.32525,2.77297,.89172,1.44736,2.78791,.52993,1.80496,2.70192,1.14045,.81915,2.75916,1.00378,1.07601,2.9486,.93895,1.29187,2.86166,1.02137,1.04571,2.90599,1.0791,1.0878,2.27319,1.81794,.11787,2.72641,1.69013,.33738,2.78048,1.66754,.3003,2.81999,1.55317,.50221,2.87842,1.35553,.86732,2.18239,1.83515,-.07101,2.17024,1.944,-.0704,2.62162,1.79338,-.40921,2.80236,1.76356,-.16467,2.59493,1.74648,.24347,2.75602,1.77855,-.2637,2.46765,1.98658,-.20443,3.16962,.61622,1.9411};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlmet3_Geo_6_100_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,31,32,33,-1,32,34,33,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,42,39,43,-1,44,35,45,-1,44,36,35,-1,42,41,46,-1,46,47,42,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,60,63,61,-1,64,65,66,-1,66,67,64,-1,66,57,67,-1,68,69,70,-1,68,71,69,-1,72,73,74,-1,74,75,72,-1,76,77,30,-1,77,78,30,-1,79,80,81,-1,79,82,80,-1,83,4,3,-1,83,84,4,-1,85,86,87,-1,85,88,86,-1,89,90,91,-1,92,93,94,-1,93,95,94,-1,21,96,22,-1,21,97,96,-1,98,99,100,-1,98,101,99,-1,102,103,104,-1,102,105,103,-1,106,107,108,-1,108,109,106,-1,110,111,112,-1,113,114,115,-1,113,116,114,-1,117,114,116,-1,118,119,90,-1,120,121,122,-1,123,124,14,-1,14,125,123,-1,126,127,128,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,135,136,133,-1,137,134,133,-1,138,139,140,-1,141,142,143,-1,141,11,142,-1,144,145,146,-1,145,147,146,-1,147,148,146,-1,149,150,151,-1,152,153,50,-1,154,155,156,-1,157,158,8,-1,8,159,157,-1,7,6,160,-1,160,161,7,-1,106,109,162,-1,163,137,164,-1,102,165,166,-1,166,23,102,-1,21,23,167,-1,23,166,167,-1,30,78,28,-1,30,29,168,-1,29,169,168,-1,170,171,172,-1,173,174,175,-1,39,42,176,-1,35,37,177,-1,177,178,35,-1,37,179,180,-1,180,177,37,-1,181,170,174,-1,181,66,170,-1,182,183,184,-1,115,114,185,-1,186,187,188,-1,187,189,188,-1,190,165,191,-1,190,192,165,-1,193,194,109,-1,109,108,193,-1,195,140,196,-1,126,128,197,-1,198,199,200,-1,198,118,199,-1,17,111,110,-1,201,202,203,-1,101,152,204,-1,101,98,152,-1,205,194,193,-1,206,207,208,-1,206,209,207,-1,116,210,211,-1,212,213,214,-1,213,215,214,-1,216,217,218,-1,218,219,216,-1,189,220,221,-1,107,106,100,-1,153,98,222,-1,153,152,98,-1,223,191,224,-1,191,104,224,-1,18,20,225,-1,226,227,228,-1,16,229,17,-1,229,230,17,-1,118,90,199,-1,231,232,233,-1,233,162,231,-1,234,207,235,-1,207,52,235,-1,167,166,236,-1,53,207,209,-1,53,52,207,-1,237,238,148,-1,237,234,238,-1,239,240,241,-1,239,242,240,-1,138,243,244,-1,244,245,138,-1,246,247,248,-1,246,164,247,-1,11,141,249,-1,249,250,11,-1,126,197,141,-1,90,119,95,-1,92,251,93,-1,92,136,251,-1,249,121,252,-1,249,197,121,-1,253,254,120,-1,255,164,137,-1,255,256,247,-1,247,164,255,-1,257,258,184,-1,259,260,160,-1,260,161,160,-1,261,262,263,-1,261,264,262,-1,32,265,266,-1,267,268,269,-1,270,271,272,-1,273,82,71,-1,82,274,71,-1,275,82,276,-1,82,79,276,-1,171,170,66,-1,277,67,57,-1,278,176,213,-1,176,279,213,-1,280,76,281,-1,41,282,46,-1,283,76,280,-1,283,77,76,-1,41,43,180,-1,284,40,285,-1,284,38,40,-1,286,287,288,-1,286,84,287,-1,45,87,86,-1,0,289,1,-1,288,290,284,-1,178,177,43,-1,45,291,292,-1,73,293,294,-1,294,295,73,-1,296,297,270,-1,270,272,296,-1,298,34,75,-1,34,72,75,-1,34,266,72,-1,34,32,266,-1,45,86,291,-1,292,44,45,-1,284,290,38,-1,87,290,288,-1,87,45,290,-1,87,288,287,-1,299,300,284,-1,301,302,303,-1,303,26,301,-1,177,180,43,-1,77,294,293,-1,77,283,294,-1,179,304,282,-1,304,305,282,-1,306,280,281,-1,306,307,280,-1,308,309,310,-1,310,169,308,-1,311,312,313,-1,58,314,315,-1,58,316,314,-1,66,65,171,-1,65,317,171,-1,82,275,274,-1,318,319,69,-1,68,3,71,-1,320,310,309,-1,321,322,323,-1,323,48,321,-1,6,8,261,-1,256,324,160,-1,256,255,324,-1,255,133,324,-1,255,137,133,-1,121,120,254,-1,254,252,121,-1,133,136,92,-1,92,324,133,-1,93,251,91,-1,251,129,91,-1,95,119,325,-1,325,94,95,-1,118,198,326,-1,198,327,326,-1,11,250,9,-1,140,195,246,-1,246,138,140,-1,246,243,138,-1,246,248,243,-1,145,328,147,-1,145,186,328,-1,240,329,241,-1};
			return value;
		}
		private int[] getlmet3_Geo_6_100_coordIndex_2()
		{
			int[] value = {329,330,241,-1,148,96,146,-1,148,238,96,-1,102,191,165,-1,102,104,191,-1,159,185,157,-1,159,331,185,-1,264,332,262,-1,158,264,261,-1,261,8,158,-1,226,333,334,-1,333,335,334,-1,116,113,210,-1,336,113,337,-1,336,210,113,-1,161,338,159,-1,338,331,159,-1,339,112,211,-1,228,340,49,-1,49,226,228,-1,222,98,100,-1,219,214,216,-1,219,341,214,-1,342,343,344,-1,217,216,345,-1,345,315,217,-1,303,346,347,-1,347,348,303,-1,349,300,299,-1,299,302,349,-1,322,350,323,-1,351,204,50,-1,204,152,50,-1,190,191,223,-1,193,108,352,-1,107,100,99,-1,99,51,107,-1,17,110,15,-1,337,353,336,-1,337,199,353,-1,198,115,327,-1,198,200,115,-1,131,197,128,-1,131,121,197,-1,352,209,354,-1,209,206,354,-1,209,108,53,-1,209,352,108,-1,150,149,236,-1,149,167,236,-1,261,263,6,-1,258,182,184,-1,355,63,313,-1,356,84,286,-1,181,57,66,-1,45,178,290,-1,45,35,178,-1,320,357,310,-1,62,61,358,-1,317,172,171,-1,317,80,172,-1,47,359,42,-1,47,312,359,-1,306,360,307,-1,360,361,307,-1,97,144,146,-1,146,96,97,-1,165,202,236,-1,236,166,165,-1,362,132,363,-1,132,127,363,-1,10,123,137,-1,12,14,124,-1,124,364,12,-1,9,250,364,-1,10,137,163,-1,365,233,156,-1,244,366,194,-1,366,231,194,-1,367,368,256,-1,368,247,256,-1,333,323,350,-1,333,226,323,-1,156,155,222,-1,155,153,222,-1,222,365,156,-1,369,227,229,-1,227,334,229,-1,370,16,15,-1,15,201,370,-1,226,334,227,-1,242,206,208,-1,208,240,242,-1,194,205,371,-1,141,143,126,-1,143,372,126,-1,189,373,188,-1,161,260,338,-1,374,116,211,-1,374,117,116,-1,375,114,117,-1,199,337,200,-1,51,53,108,-1,108,107,51,-1,102,23,22,-1,22,105,102,-1,106,365,222,-1,222,100,106,-1,376,105,22,-1,95,91,90,-1,95,93,91,-1,160,324,259,-1,287,0,87,-1,0,85,87,-1,305,283,280,-1,305,304,283,-1,377,81,355,-1,377,79,81,-1,3,5,172,-1,172,273,3,-1,2,85,0,-1,378,2,1,-1,269,379,267,-1,269,276,379,-1,281,76,30,-1,30,168,281,-1,72,293,73,-1,72,266,293,-1,54,60,62,-1,64,380,65,-1,64,381,380,-1,55,358,382,-1,317,65,380,-1,201,203,19,-1,19,370,201,-1,20,192,225,-1,192,190,225,-1,383,384,385,-1,59,56,57,-1,38,43,39,-1,36,44,294,-1,386,387,307,-1,388,289,0,-1,26,173,301,-1,26,25,173,-1,24,26,348,-1,26,303,348,-1,389,25,27,-1,24,144,97,-1,24,348,144,-1,321,48,155,-1,9,364,124,-1,197,249,141,-1,10,163,11,-1,3,273,71,-1,309,267,320,-1,175,390,391,-1,392,390,175,-1,21,24,97,-1,27,24,21,-1,393,167,149,-1,393,389,167,-1,314,389,393,-1,25,389,314,-1,388,394,289,-1,388,395,394,-1,396,397,398,-1,396,298,397,-1,28,399,29,-1,265,399,28,-1,318,270,319,-1,318,271,270,-1,385,59,383,-1,385,56,59,-1,340,50,49,-1,340,351,50,-1,203,20,19,-1,203,192,20,-1,381,63,380,-1,381,61,63,-1,306,320,360,-1,357,320,306,-1,275,269,271,-1,275,276,269,-1,395,400,401,-1,395,388,400,-1,378,402,2,-1,378,403,402,-1,168,306,281,-1,306,168,357,-1,274,69,71,-1,274,318,69,-1,77,266,78,-1,77,293,266,-1,84,0,287,-1,83,0,84,-1,313,307,361,-1,313,386,307,-1,295,291,404,-1,295,292,291,-1,387,280,307,-1,387,305,280,-1,294,292,295,-1,292,294,44,-1,324,94,259,-1,92,94,324,-1,104,405,224,-1,103,405,104,-1,200,113,115,-1,200,337,113,-1,326,119,118,-1,326,325,119,-1,13,406,407,-1,13,253,406,-1,142,196,408,-1,196,142,11,-1,329,208,237,-1,329,240,208,-1,242,354,206,-1,242,409,354,-1,151,201,15,-1,151,150,201,-1,16,369,229,-1,16,370,369,-1,162,365,106,-1,162,233,365,-1,350,375,333,-1,350,410,375,-1,247,411,248,-1,368,411,247,-1,243,366,244,-1,412,366,243,-1,48,153,155,-1,48,50,153,-1,160,367,256,-1,367,160,6,-1,252,250,249,-1,364,250,252,-1,130,121,131,-1,121,130,122,-1,407,413,135,-1,406,413,407,-1,137,125,134,-1,125,137,123,-1,90,414,199,-1,414,90,89,-1,132,415,129,-1,415,132,362,-1,126,363,127,-1,363,126,373,-1};
			return value;
		}
		private int[] getlmet3_Geo_6_100_coordIndex_3()
		{
			int[] value = {150,202,201,-1,236,202,150,-1,110,416,417,-1,110,418,416,-1,414,353,199,-1,419,353,414,-1,312,386,313,-1,386,312,47,-1,317,81,80,-1,380,81,317,-1,312,384,359,-1,312,311,384,-1,349,286,300,-1,356,286,349,-1,380,355,81,-1,355,380,63,-1,154,233,232,-1,154,156,233,-1,6,420,367,-1,420,6,263,-1,239,409,242,-1,409,239,421,-1,339,353,418,-1,336,353,339,-1,192,202,165,-1,192,203,202,-1,351,223,204,-1,190,223,351,-1,230,334,335,-1,230,229,334,-1,303,299,346,-1,303,302,299,-1,144,347,187,-1,144,348,347,-1,416,341,219,-1,416,419,341,-1,59,315,345,-1,58,315,59,-1,344,422,423,-1,344,343,422,-1,423,212,424,-1,212,423,422,-1,89,424,414,-1,424,89,423,-1,111,230,374,-1,17,230,111,-1,417,219,218,-1,416,219,417,-1,327,185,331,-1,327,115,185,-1,374,335,117,-1,335,374,230,-1,333,117,335,-1,333,375,117,-1,410,264,158,-1,332,264,410,-1,185,375,157,-1,375,185,114,-1,105,235,103,-1,105,376,235,-1,238,235,376,-1,234,235,238,-1,329,328,330,-1,329,147,328,-1,187,145,144,-1,187,186,145,-1,241,143,142,-1,241,330,143,-1,195,11,163,-1,195,196,11,-1,246,163,164,-1,195,163,246,-1,362,344,415,-1,362,342,344,-1,326,331,338,-1,326,327,331,-1,325,259,94,-1,260,259,325,-1,412,257,366,-1,412,258,257,-1,368,182,411,-1,368,183,182,-1,410,322,332,-1,322,410,350,-1,367,183,368,-1,420,183,367,-1,155,262,321,-1,155,425,262,-1,181,173,316,-1,174,173,181,-1,426,267,309,-1,268,267,426,-1,427,381,64,-1,427,382,381,-1,393,315,314,-1,217,315,393,-1,382,61,381,-1,382,358,61,-1,215,216,214,-1,215,345,216,-1,359,383,279,-1,383,359,384,-1,279,42,359,-1,42,279,176,-1,309,428,426,-1,308,428,309,-1,169,399,308,-1,399,169,29,-1,265,78,266,-1,28,78,265,-1,304,37,36,-1,304,179,37,-1,343,278,422,-1,343,40,278,-1,346,284,285,-1,299,284,346,-1,349,301,391,-1,349,302,301,-1,300,288,284,-1,300,286,288,-1,3,400,83,-1,400,3,68,-1,73,404,74,-1,73,295,404,-1,74,88,402,-1,88,74,404,-1,88,2,402,-1,2,88,85,-1,401,398,395,-1,401,429,398,-1,396,429,430,-1,429,396,398,-1,33,428,31,-1,33,431,428,-1,431,297,296,-1,431,430,297,-1,296,428,431,-1,428,296,426,-1,396,431,33,-1,396,430,431,-1,268,296,272,-1,426,296,268,-1,430,432,297,-1,432,430,429,-1,70,429,401,-1,432,429,70,-1,403,394,397,-1,394,403,378,-1,298,403,397,-1,75,403,298,-1,388,83,400,-1,388,0,83,-1,84,390,4,-1,84,356,390,-1,356,391,390,-1,356,349,391,-1,347,285,220,-1,346,285,347,-1,220,40,343,-1,285,40,220,-1,176,40,39,-1,40,176,278,-1,46,305,387,-1,305,46,282,-1,308,31,428,-1,399,31,308,-1,377,360,379,-1,361,360,377,-1,213,422,278,-1,213,212,422,-1,345,383,59,-1,383,345,215,-1,60,313,63,-1,60,311,313,-1,316,57,181,-1,57,316,58,-1,67,427,64,-1,67,277,427,-1,316,25,314,-1,316,173,25,-1,79,379,276,-1,79,377,379,-1,271,268,272,-1,268,271,269,-1,263,425,420,-1,263,262,425,-1,332,321,262,-1,322,321,332,-1,184,155,154,-1,155,184,425,-1,411,258,412,-1,258,411,182,-1,154,257,184,-1,154,232,257,-1,257,231,366,-1,257,232,231,-1,253,12,254,-1,12,253,13,-1,415,423,89,-1,423,415,344,-1,363,342,362,-1,221,342,363,-1,373,221,363,-1,373,189,221,-1,245,139,138,-1,139,245,421,-1,142,239,241,-1,408,239,142,-1,330,372,143,-1,330,328,372,-1,207,237,208,-1,207,234,237,-1,371,421,245,-1,409,421,371,-1,376,96,238,-1,376,22,96,-1,52,103,235,-1,52,405,103,-1,194,245,244,-1,194,371,245,-1,424,419,414,-1,341,419,424,-1,151,218,149,-1,417,218,151,-1,228,369,18,-1,369,228,227,-1,18,340,228,-1,225,340,18,-1,204,224,101,-1,204,223,224,-1,51,405,52,-1,405,51,99,-1,217,149,218,-1,393,149,217,-1,212,341,424,-1,212,214,341,-1,215,279,383,-1,213,279,215,-1,211,336,339,-1,211,210,336,-1,18,370,19,-1,18,369,370,-1,354,193,352,-1,205,193,354,-1,112,418,110,-1,339,418,112,-1,343,221,220,-1,342,221,343,-1,408,421,239,-1,421,408,139,-1};
			return value;
		}
		private int[] getlmet3_Geo_6_100_coordIndex_4()
		{
			int[] value = {187,220,189,-1,187,347,220,-1,420,184,183,-1,420,425,184,-1,432,69,319,-1,432,70,69,-1,282,180,179,-1,180,282,41,-1,170,175,174,-1,170,392,175,-1,5,170,172,-1,5,392,170,-1,169,357,168,-1,169,310,357,-1,418,419,416,-1,418,353,419,-1,15,417,151,-1,15,110,417,-1,188,328,186,-1,188,372,328,-1,89,129,415,-1,89,91,129,-1,134,407,135,-1,407,134,125,-1,406,130,413,-1,122,130,406,-1,323,49,48,-1,323,226,49,-1,412,248,411,-1,412,243,248,-1,8,161,159,-1,8,7,161,-1,157,410,158,-1,157,375,410,-1,231,109,194,-1,231,162,109,-1,409,205,354,-1,409,371,205,-1,237,147,329,-1,147,237,148,-1,196,139,408,-1,140,139,196,-1,372,373,126,-1,372,188,373,-1,413,129,251,-1,413,130,129,-1,135,251,136,-1,251,135,413,-1,132,128,127,-1,131,128,132,-1,10,124,123,-1,124,10,9,-1,14,407,125,-1,407,14,13,-1,253,122,406,-1,253,120,122,-1,254,364,252,-1,254,12,364,-1,325,338,260,-1,325,326,338,-1,374,112,111,-1,112,374,211,-1,405,101,224,-1,101,405,99,-1,283,36,294,-1,36,283,304,-1,361,355,313,-1,377,355,361,-1,86,404,291,-1,88,404,86,-1,82,172,80,-1,273,172,82,-1,75,402,403,-1,75,74,402,-1,378,289,394,-1,378,1,289,-1,68,401,400,-1,70,401,68,-1,274,271,318,-1,274,275,271,-1,379,320,267,-1,379,360,320,-1,382,277,55,-1,427,277,382,-1,62,55,54,-1,55,62,358,-1,60,56,385,-1,60,54,56,-1,385,311,60,-1,385,384,311,-1,351,225,190,-1,340,225,351,-1,47,387,386,-1,387,47,46,-1,178,38,290,-1,43,38,178,-1,319,297,432,-1,319,270,297,-1,399,32,31,-1,399,265,32,-1,33,298,396,-1,33,34,298,-1,397,395,398,-1,397,394,395,-1,389,21,167,-1,389,27,21,-1,175,301,173,-1,175,391,301,-1,55,57,56,-1,57,55,277,-1,4,392,5,-1,4,390,392,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlmet3_Coord_7_100_point_1()
		{
			double[] value = {3.34681,.47148,1.35864,3.32426,.42322,1.42283,3.31978,.44026,1.44742,3.55356,.43358,1.28458,3.53486,.45584,1.26697,3.55429,.45788,1.27791,2.82305,1.79789,-.22691,2.81549,1.91692,-.16785,2.90881,1.94815,-.21784,2.81986,1.47302,-.13704,2.8099,1.48452,-.17159,2.79587,1.31,-.14174,2.85061,1.54825,-.04357,2.84518,1.58458,-.02305,2.83129,1.58763,-.0633,3.29545,1.55242,.01868,3.30983,1.63152,-.05671,3.28005,1.67878,-.01444,3.29477,1.61286,-.1765,3.29234,1.53612,-.09468,3.27765,1.51687,-.11918,3.26204,1.21495,.26131,3.22018,1.24443,.12173,3.23597,1.27249,.12013,3.32581,1.05556,.56926,3.41715,.92162,.87438,3.38322,.90875,.88066,3.34965,1.06832,.56784,3.33043,.68227,1.76773,3.34354,.69246,1.77479,3.32723,.75887,1.72644,3.40502,.53982,1.82157,3.38425,.54071,1.81434,3.40754,.42921,1.74551,3.39018,.43745,1.73951,3.30162,.60359,1.53954,3.33766,.59713,1.67533,3.25112,.66534,1.54345,3.26049,.83369,1.2974,3.2645,.85563,1.30713,3.18346,1.04248,1.01302,3.31465,.8662,1.45274,3.32296,.88025,1.43392,3.25541,.83458,1.31973,3.34367,.5766,1.67053,3.32106,.57179,1.53152,3.38205,.83672,1.55484,3.40241,.84125,1.54639,3.15165,1.62866,-.45424,3.18699,1.62386,-.43512,3.15496,1.5878,-.44069,3.05633,1.3338,-.36204,3.08681,1.28451,-.29005,3.03969,1.30242,-.36914,3.52543,.80647,1.49124,3.57977,.73957,1.44934,3.48581,.85138,1.37089,3.51488,.76654,1.28683,3.48602,.83981,1.21822,3.47427,.88309,1.26901,3.497,.81698,1.51942,3.56447,.75556,1.54541,3.53576,.79573,1.51507,3.5551,.75364,1.57006,3.62385,.60749,1.46397,3.61312,.57965,1.47114,3.5433,.62707,1.34787,3.57058,.6489,1.38249,3.56547,.38195,1.31573,3.66045,.3853,1.36114,3.56984,.36288,1.34362,3.65027,.41327,1.34913,3.38126,.44836,1.72155,3.38464,.46484,1.70758,3.37361,.41713,1.62129,3.37999,.39811,1.62774,3.32748,.7692,1.69855,3.31737,.66463,1.72971,3.3252,.67411,1.75853,3.6487,.58931,1.61854,3.63175,.50571,1.49657,3.63392,.60202,1.58702,3.66004,.46801,1.51198,3.41267,.46103,1.31889,3.40556,.49227,1.30208,3.32219,.45902,1.46317,3.3526,.45054,1.54064,3.32521,.48119,1.46196,3.35278,.43383,1.53811,3.04829,1.60736,.26519,3.00849,1.68466,.15575,2.99195,1.65395,.15619,2.89114,1.68869,-.03374,2.93192,1.67649,.05954,2.89515,1.71654,-.02536,2.94055,1.71181,.05906,3.20493,1.2212,.12164,3.23533,1.20255,.26334,2.96007,1.44489,-.43462,3.07908,1.39025,-.34519};
			return value;
		}
		private double[] getlmet3_Coord_7_100_point_2()
		{
			double[] value = {2.96684,1.41222,-.43495,3.08613,1.42667,-.34744,3.20245,1.33767,-.03312,3.14495,1.38183,-.21054,3.15632,1.41614,-.20478,3.19631,1.3032,-.04347,2.97352,1.38054,-.47346,3.00244,1.38424,-.4148,2.99311,1.35241,-.42574,2.96606,1.35992,-.47637,3.28867,1.61129,.05989,3.24185,1.68809,.00164,3.21878,1.69296,.00898,3.08388,1.8245,-.00464,3.09666,1.85692,-.18514,3.06736,1.83649,-.01167,3.11215,1.83552,-.15329,3.11511,1.84824,-.19519,2.99834,1.78708,.101,2.97208,1.78109,.08671,2.86485,1.53467,.05455,2.88071,1.48922,.10199,2.87671,1.55412,.07905,2.80124,1.56753,-.11816,2.81251,1.54654,-.09406,2.83162,1.61975,-.07777,2.96056,1.32516,.10168,2.93576,1.36746,.15439,2.92428,1.37271,.13793,2.93168,1.55697,.14253,2.91847,1.54981,.1292,2.9224,1.46939,.16276,2.93397,1.47166,.18124,2.84357,1.67774,-.13584,2.84251,1.65798,-.1276,2.87415,1.65473,-.03441,2.88446,1.67393,-.03567,2.79515,1.57477,-.20394,2.6751,1.25529,-.42978,2.74334,1.27153,-.37875,2.73691,1.29927,-.36541,2.85518,1.30909,-.02788,2.80669,1.28081,-.14067,2.8683,1.27871,-.03712,3.20083,1.19348,.27471,3.15138,1.20767,.13226,3.18006,1.20868,.12404,3.09258,1.19088,.01532,3.12036,1.18343,-.0035,3.34882,1.34098,.2866,3.31421,1.42454,.14196,3.31919,1.45616,.15445,3.01929,1.51865,-.43157,2.97819,1.53417,-.4572,2.9002,1.42419,-.48001,2.95733,1.55214,-.46011,2.91638,1.40831,-.49323,3.01035,1.93392,-.25372,3.00145,1.92801,-.26558,2.91878,1.94884,-.19497,2.80762,1.7903,-.19234,2.81365,1.91956,-.12168,2.95563,1.37242,-.48374,2.79178,1.42054,-.2676,2.72096,1.50133,-.27651,3.21549,1.3938,-.01757,3.26626,1.33342,.11397,3.32111,1.25512,.27289,3.34837,.77935,1.72659,3.39614,.71994,1.7724,3.52396,.59401,1.28897,3.58539,.54213,1.35778,3.61407,.47894,1.34911,3.44264,.74733,1.13402,3.4799,.68244,1.22238,3.46065,.65829,1.19536,3.30699,.92861,1.3295,3.24424,.77134,1.40057,3.27733,.72608,1.38067,3.25311,.73901,1.55564,3.24109,.79962,1.4168,3.5064,.7141,1.25842,2.69568,1.45882,-.38106,2.72113,1.52005,-.35646,2.82129,1.50061,-.41611,3.04257,1.89777,-.15196,3.06447,1.23547,.16961,3.11242,1.21453,.27421,3.03049,1.28563,.19373,3.0551,1.27624,.30396,3.21736,1.4941,-.21918,3.17635,1.46466,-.20096,3.25772,1.4851,-.09015,2.88017,1.22381,-.48645,2.84823,1.21248,-.51653,2.76108,1.35848,-.3402,2.76589,1.29252,-.3028,2.88723,1.37297,.11591,3.02636,1.79257,.09078,3.08288,1.72201,.1457};
			return value;
		}
		private double[] getlmet3_Coord_7_100_point_3()
		{
			double[] value = {3.06897,1.77971,.07533,3.28981,1.51801,.00847,3.26396,1.45967,-.00664,3.27358,1.49495,-.04358,3.12301,1.46981,-.32191,2.86033,1.20867,-.47993,2.93476,1.21103,-.3583,3.05875,1.21622,-.2945,2.97672,1.18478,-.25043,2.99577,1.24734,-.38079,3.13358,1.78812,-.03325,3.16795,1.75791,-.03992,3.22046,1.34498,.70752,3.27465,1.14842,1.01932,3.27635,1.33384,.68373,3.336,1.14834,1.00163,3.33596,1.2992,.65917,3.38006,1.231,.63672,3.32041,1.44208,.30838,3.26125,1.50888,.32099,3.14316,1.14686,.65222,3.03351,1.30548,.31641,2.94088,1.42307,-.47643,3.17321,1.47216,-.22368,3.14223,1.42501,-.24044,3.23079,1.51391,-.2174,3.24393,1.78268,-.39893,3.28779,1.7533,-.30896,3.26002,1.69279,-.32559,3.32789,1.71317,-.13512,3.26568,1.74846,-.0895,2.84167,1.23883,-.52373,2.84345,1.33033,-.49756,2.91511,1.39322,-.49918,3.09371,1.195,-.1801,3.12306,1.25271,-.21393,3.28106,1.37109,.12231,3.03645,1.16284,-.12468,3.15949,1.18893,-.03224,2.82549,1.2166,-.32648,2.94711,1.18551,-.23406,2.86306,1.22245,-.18631,2.90437,1.2054,-.34477,2.64471,1.2816,-.44611,2.70632,1.21361,-.49094,2.74649,1.20701,-.46367,2.69744,1.41978,-.34156,2.68307,1.51398,-.30397,2.65316,1.4345,-.35486,2.84635,1.41316,-.01343,2.83006,1.43614,-.08605,2.9089,1.655,.05902,2.86167,1.51284,.00113,2.85486,1.57495,.02195,2.86167,1.5337,.00649,2.72659,1.64487,-.23956,2.71731,1.66166,-.2534,2.75258,1.33129,-.47998,2.69404,1.34783,-.45216,2.81789,1.7841,-.14678,2.81171,1.88985,-.08313,2.90195,1.8119,-.26388,2.92578,1.68892,-.36927,2.86931,1.74362,-.29,2.98206,1.83243,-.32712,3.36513,.5895,1.81556,3.3443,.55197,1.7875,3.62399,.64778,1.74729,3.67199,.5234,1.73123,3.69961,.53833,1.66873,3.6986,.40814,1.61118,3.72443,.45593,1.59019,3.69258,.43141,1.64719,3.63478,.44559,1.35254,3.71024,.42444,1.47951,3.72033,.4708,1.58013,3.69521,.54856,1.65281,3.59209,.7166,1.44609,3.23275,1.11421,1.03343,3.35429,.93849,1.32537,3.34673,.76821,1.66554,3.34086,.78492,1.7001,3.33072,.82879,1.56146,3.32074,.66338,1.6984,3.27978,.7587,1.25283,3.21683,.97229,.97137,3.37739,.58197,1.25358,3.3434,.51123,1.34011,3.32301,.62792,1.31094,3.33515,.40832,1.41524,3.29016,.69888,1.36108,3.36469,.46155,1.58562,3.36719,.48983,1.62271,3.33591,.55472,1.75837,3.34568,.57699,1.70474,3.37203,.47669,1.63985,3.62726,.42165,1.72393,3.59861,.35618,1.61968,3.39834,.38554,1.64922,3.33785,.73457,1.1789};
			return value;
		}
		private double[] getlmet3_Coord_7_100_point_4()
		{
			double[] value = {3.35748,.66405,1.20779,3.42626,.73702,1.13097,3.38253,.7234,1.14187,3.34138,.90943,.89792,3.3118,.68013,1.66929,3.34351,.77156,1.64116,3.41806,.80202,1.6974,3.4331,.77391,1.65836,3.46425,.6404,1.82885,3.56086,.66483,1.79565,3.46158,.75634,1.75726,3.46691,.8366,1.5332,3.45134,.83829,1.53621,3.4985,.7771,1.61676,3.44217,.97495,.89485,3.42166,1.05387,.93737,3.47925,.79145,1.16987,3.62094,.55339,1.48275,3.71237,.40844,1.48323,3.67583,.36599,1.49545,3.51683,.78726,1.73465,3.04996,1.63664,-.4438,3.11662,1.76847,-.39335,3.20395,1.79021,-.41685,2.81477,1.74292,-.15831,2.89565,1.82632,.01671,2.91845,1.8555,.01148,2.98753,1.84024,.01677,3.01096,1.2491,.06544,3.00706,1.1665,-.10952,2.91774,1.22543,-.06606,2.93734,1.91336,-.12546,3.02127,1.81459,-.35031,3.16877,1.85689,-.35058,3.28353,1.78233,-.2939,3.21149,1.82834,-.24147,3.14904,1.74019,.04513,3.08836,1.77183,.06816,2.83925,1.91594,-.08024,3.19171,1.71082,.02295,3.19493,1.55217,-.32953,3.21563,1.55619,.33463,3.00779,1.38439,.34554,3.11328,1.227,.69779,3.02082,1.44303,.35592,3.4013,1.11398,.97157,3.27719,.92965,.93401,3.2131,1.08351,.6119,3.28184,1.07145,.59468,3.39495,.65865,1.19944,3.15804,1.85079,-.36249,3.18072,1.53193,-.33114,2.9376,1.26265,-.41261,3.16431,1.69221,.12353,2.89659,1.23063,-.42108,3.5692,.70601,1.61006,3.40206,.57738,1.24653,3.41831,.79509,1.72549,3.58836,.73222,1.47512,3.39185,.89306,1.41709,3.52083,.79541,1.70629,3.50385,.77426,1.6438,2.9684,1.42746,.25851,2.9887,1.34332,.23015,2.84986,1.52849,-.05265,2.92401,1.40307,-.49235,2.70883,1.23346,-.50418,2.72421,1.6669,-.27045,2.6889,1.52397,-.33294,3.32462,1.67545,-.15224,3.31344,1.6099,-.0793,2.83172,1.20217,-.47433,2.98146,1.29787,.09168,3.01133,1.3127,.20933,3.18067,1.76546,-.0559,3.07517,1.88974,-.31442,3.18934,1.24724,-.06154,3.56931,.70555,1.64335,3.32566,.41282,1.43968,3.61809,.68097,1.70904,3.62285,.62725,1.56838,3.62316,.64891,1.54781,3.59843,.71729,1.46504,3.4001,.92862,1.31212,3.43139,.88541,1.40646,3.43936,.88053,1.40269,3.42809,.77786,1.62351,3.41469,.77744,1.62558,3.35343,.39833,1.40593,3.37794,1.08759,.57369,3.47218,.5595,1.22999,3.43876,.65243,1.18976,3.49181,.56752,1.23395,3.40158,1.15702,.60588,3.3376,.3957,1.43096,3.35609,.38621,1.42178,3.41659,.37445,1.65291,3.38559,.35312,1.55699,3.40521,.34129,1.55323,3.38119,.59847,1.82444};
			return value;
		}
		private double[] getlmet3_Coord_7_100_point_5()
		{
			double[] value = {3.43673,.37137,1.36229,3.44397,.35914,1.37629,3.3585,.39505,1.54912,3.36485,.37417,1.54783,3.36851,.44295,1.59504,3.13122,1.38999,-.24043,2.86358,1.60428,.03473,2.85072,1.6174,-.02401,2.77688,1.26197,-.30556,2.86813,1.2217,-.40527,3.06695,1.88392,-.32702,2.65529,1.44277,-.37204,2.64992,1.2948,-.46206,2.89499,1.63858,.05247,3.10717,1.64703,.25037,2.97322,1.4992,.24549,3.23811,1.58451,.20952,3.30119,1.52484,.18327,3.21438,1.65997,.09806,3.19001,1.62424,.22908,2.76904,1.65035,-.30371,2.79611,1.2294,-.4028,3.16887,1.31581,.72234,3.08792,1.54329,.37352,3.13158,1.57206,.35503,2.87326,1.59472,-.39269,3.61861,.51567,1.7789,3.59756,.71228,1.45607,3.51492,.51586,1.80651,3.47547,.32414,1.54014,3.49274,.35358,1.6407,3.51463,.4166,1.74805,3.58011,.33352,1.51979};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlmet4_Geo_6_105_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,16,18,17,-1,19,16,20,-1,16,15,20,-1,21,22,23,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,34,37,35,-1,38,39,28,-1,38,40,39,-1,41,42,43,-1,43,42,44,-1,42,45,44,-1,46,47,48,-1,48,49,46,-1,50,51,52,-1,51,25,52,-1,53,54,55,-1,56,33,57,-1,56,58,33,-1,59,60,61,-1,61,62,59,-1,63,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,74,75,72,-1,76,77,78,-1,79,80,81,-1,82,83,84,-1,85,86,76,-1,76,78,85,-1,87,88,89,-1,90,91,89,-1,91,92,89,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,102,105,103,-1,106,107,108,-1,109,110,111,-1,110,112,111,-1,113,88,114,-1,113,115,88,-1,116,117,118,-1,119,120,121,-1,107,122,108,-1,107,123,122,-1,81,113,124,-1,113,103,124,-1,125,126,127,-1,128,129,125,-1,130,131,132,-1,70,133,134,-1,133,135,134,-1,136,137,138,-1,138,119,139,-1,93,140,141,-1,142,143,144,-1,144,145,142,-1,146,63,147,-1,146,64,63,-1,94,148,95,-1,148,149,95,-1,150,94,93,-1,150,151,94,-1,100,109,101,-1,152,153,154,-1,86,155,90,-1,42,41,156,-1,41,43,157,-1,11,158,9,-1,158,159,9,-1,160,158,161,-1,161,162,160,-1,163,164,165,-1,164,166,165,-1,167,24,168,-1,169,170,171,-1,171,172,169,-1,173,174,175,-1,54,53,176,-1,24,26,177,-1,125,178,179,-1,179,126,125,-1,118,180,181,-1,118,117,180,-1,182,183,184,-1,182,185,183,-1,182,184,186,-1,187,188,189,-1,187,190,188,-1,187,191,192,-1,191,193,192,-1,154,153,194,-1,195,196,197,-1,131,135,133,-1,198,199,200,-1,198,201,199,-1,202,203,204,-1,204,205,202,-1,111,122,206,-1,111,108,122,-1,207,208,110,-1,209,210,211,-1,212,213,214,-1,76,215,216,-1,217,218,219,-1,218,115,219,-1,220,216,221,-1,216,215,221,-1,155,86,85,-1,87,222,223,-1,224,225,213,-1,226,227,228,-1,229,200,230,-1,229,198,200,-1,82,77,231,-1,82,78,77,-1,229,232,233,-1,77,76,216,-1,234,235,236,-1,237,238,95,-1,95,149,237,-1,239,240,241,-1,64,242,142,-1,243,244,97,-1,243,245,244,-1,246,247,248,-1,46,249,250,-1,46,251,249,-1,55,252,53,-1,253,163,254,-1,255,249,251,-1,255,256,249,-1,257,255,258,-1,257,259,255,-1,165,260,261,-1,177,260,262,-1,36,263,264,-1,264,34,36,-1,265,266,267,-1,267,268,265,-1,269,56,29,-1,269,270,56,-1,271,272,273,-1,271,162,272,-1,274,1,275,-1,1,276,275,-1,35,37,159,-1,37,277,159,-1,10,278,279,-1,10,9,278,-1,280,281,282,-1,281,283,282,-1,284,285,286,-1,285,287,286,-1,12,284,288,-1,288,13,12,-1,289,5,290,-1,291,3,292,-1,293,4,294,-1,6,295,48,-1,6,19,295,-1,8,16,6,-1,16,19,6,-1,175,174,296,-1,296,60,175,-1,297,61,298,-1,31,299,32,-1,300,301,302,-1,303,304,305,-1,305,306,303,-1,58,31,33,-1,307,308,61,-1,61,297,307,-1,298,60,296,-1,298,61,60,-1,309,174,310,-1,309,296,174,-1,311,312,313,-1,311,314,312,-1,315,46,250,-1,315,47,46,-1,316,317,318,-1,316,319,317,-1,293,20,320,-1,293,321,20,-1,290,5,320,-1,2,18,16,-1,16,8,2,-1,322,3,291,-1,292,3,323,-1,12,324,281,-1,12,14,324,-1,281,278,283,-1,278,9,283,-1,291,279,322,-1,160,325,35,-1,35,159,160,-1,162,325,160,-1,162,271,325,-1,40,38,326,-1,327,50,267,-1,50,268,267,-1,328,25,27,-1,328,52,25,-1,168,24,177,-1,177,262,168,-1,329,257,258,-1,258,41,329,-1,259,256,255,-1,163,165,261,-1,261,254,163,-1,330,191,331,-1,191,332,331,-1,333,312,314,-1,301,252,302,-1,301,53,252,-1,334,193,330,-1,193,191,330,-1,335,240,336,-1,335,337,240,-1,243,97,248,-1,248,247,243,-1,244,245,151,-1,146,242,64,-1,142,242,143,-1,336,239,338,-1,336,240,239,-1,241,240,339,-1,340,341,234,-1,235,342,236,-1,136,343,233,-1,233,137,136,-1,137,233,232,-1,82,231,83,-1,232,230,83,-1,344,345,230,-1,344,346,345,-1,345,346,347,-1};
			return value;
		}
		private int[] getlmet4_Geo_6_105_coordIndex_2()
		{
			int[] value = {230,345,83,-1,68,348,349,-1,350,66,351,-1,350,67,66,-1,352,227,226,-1,352,91,227,-1,353,354,224,-1,353,224,213,-1,87,223,88,-1,91,352,92,-1,90,89,218,-1,141,150,93,-1,115,218,88,-1,113,104,103,-1,113,114,104,-1,355,356,357,-1,212,214,209,-1,214,210,209,-1,109,206,101,-1,109,111,206,-1,183,185,110,-1,110,208,183,-1,181,180,106,-1,106,112,181,-1,204,358,359,-1,358,360,359,-1,361,201,198,-1,361,359,201,-1,199,362,363,-1,363,200,199,-1,199,201,69,-1,201,70,69,-1,359,360,70,-1,70,201,359,-1,131,130,135,-1,71,364,365,-1,154,194,195,-1,195,197,154,-1,191,187,332,-1,187,189,332,-1,184,183,188,-1,183,211,188,-1,118,181,185,-1,185,182,118,-1,179,117,126,-1,117,366,126,-1,116,196,117,-1,196,366,117,-1,34,264,367,-1,367,368,34,-1,157,329,41,-1,369,50,327,-1,310,370,311,-1,72,371,372,-1,372,373,72,-1,374,292,375,-1,292,323,375,-1,160,159,158,-1,10,376,11,-1,377,293,294,-1,364,378,192,-1,229,230,232,-1,88,218,89,-1,153,364,379,-1,153,378,364,-1,154,197,152,-1,144,338,380,-1,144,143,338,-1,97,244,98,-1,244,381,98,-1,148,146,149,-1,146,147,149,-1,338,239,380,-1,239,202,380,-1,382,383,380,-1,139,119,145,-1,125,127,384,-1,384,128,125,-1,70,360,133,-1,360,385,133,-1,134,379,70,-1,131,133,385,-1,203,241,386,-1,203,358,204,-1,81,115,113,-1,366,127,126,-1,114,223,356,-1,114,88,223,-1,105,124,103,-1,105,387,124,-1,355,357,388,-1,381,244,389,-1,342,77,236,-1,342,231,77,-1,77,234,236,-1,77,216,234,-1,347,346,349,-1,217,219,215,-1,219,221,215,-1,79,151,150,-1,92,87,89,-1,92,352,87,-1,352,222,87,-1,390,391,365,-1,74,392,75,-1,392,393,75,-1,349,66,68,-1,115,80,219,-1,115,81,80,-1,235,394,342,-1,73,72,373,-1,395,50,52,-1,395,268,50,-1,46,253,251,-1,46,49,253,-1,396,48,47,-1,396,6,48,-1,0,269,397,-1,0,398,269,-1,28,39,29,-1,40,273,39,-1,40,265,273,-1,40,326,266,-1,266,265,40,-1,31,399,299,-1,24,167,23,-1,8,7,0,-1,0,2,8,-1,14,319,400,-1,14,13,319,-1,10,401,376,-1,397,161,0,-1,402,395,403,-1,281,324,278,-1,322,4,3,-1,322,294,4,-1,17,323,289,-1,323,17,375,-1,274,2,1,-1,274,18,2,-1,316,400,319,-1,400,316,321,-1,376,374,275,-1,374,376,401,-1,158,276,161,-1,158,11,276,-1,404,405,406,-1,404,44,405,-1,407,408,51,-1,408,407,45,-1,402,273,265,-1,273,402,271,-1,409,399,410,-1,299,399,409,-1,30,411,412,-1,57,411,30,-1,413,410,414,-1,409,410,413,-1,266,415,267,-1,415,266,414,-1,416,327,417,-1,416,369,327,-1,29,397,269,-1,397,29,272,-1,7,396,418,-1,7,6,396,-1,268,402,265,-1,402,268,395,-1,156,260,177,-1,41,260,156,-1,39,272,29,-1,39,273,272,-1,258,260,41,-1,258,261,260,-1,55,329,157,-1,55,54,329,-1,419,259,420,-1,419,256,259,-1,421,250,249,-1,421,370,250,-1,175,59,422,-1,175,60,59,-1,300,423,304,-1,423,300,424,-1,399,425,410,-1,399,305,425,-1,315,370,173,-1,370,315,250,-1,270,61,308,-1,61,270,62,-1,391,426,287,-1,390,426,391,-1,393,286,427,-1,392,286,393,-1,34,428,37,-1,428,34,368,-1,368,350,428,-1,368,429,350,-1,228,225,224,-1,225,228,67,-1,354,352,226,-1,222,352,354,-1,215,86,217,-1,76,86,215,-1,141,219,80,-1,141,221,219,-1,220,238,340,-1,220,140,238,-1,231,394,430,-1,231,342,394,-1,121,431,432,-1,431,121,120,-1,340,216,220,-1,234,216,340,-1,433,101,206,-1,101,433,99,-1,122,434,435,-1,122,123,434,-1,389,387,381,-1,387,389,124,-1,207,357,353,-1,357,207,100,-1,436,237,437,-1,237,436,341,-1,221,140,220,-1,141,140,221,-1,438,117,179,-1,438,180,117,-1,358,385,360,-1,439,385,358,-1,127,132,384,-1,127,195,132,-1,194,132,195,-1,132,194,130,-1,440,97,96,-1,248,97,440,-1,178,246,441,-1,442,246,178,-1,339,386,241,-1,339,443,386,-1,442,125,129,-1,125,442,178,-1,396,315,422,-1,315,396,47,-1,378,152,190,-1,152,378,153,-1,388,100,99,-1,357,100,388,-1,153,134,194,-1,134,153,379,-1};
			return value;
		}
		private int[] getlmet4_Geo_6_105_coordIndex_3()
		{
			int[] value = {409,412,411,-1,412,409,413,-1,423,415,425,-1,415,423,417,-1,424,405,416,-1,424,406,405,-1,291,10,279,-1,10,291,401,-1,283,444,282,-1,283,277,444,-1,291,374,401,-1,291,292,374,-1,289,15,17,-1,289,290,15,-1,445,446,171,-1,447,446,445,-1,392,284,286,-1,392,288,284,-1,72,445,371,-1,445,72,75,-1,418,422,59,-1,396,422,418,-1,301,304,303,-1,300,304,301,-1,131,439,448,-1,385,439,131,-1,184,190,152,-1,184,188,190,-1,189,211,210,-1,211,189,188,-1,197,116,186,-1,197,196,116,-1,186,118,182,-1,118,186,116,-1,132,448,384,-1,132,131,448,-1,192,426,390,-1,192,193,426,-1,379,71,70,-1,379,364,71,-1,448,386,443,-1,439,386,448,-1,199,391,362,-1,199,69,391,-1,285,363,362,-1,285,449,363,-1,205,359,361,-1,359,205,204,-1,229,343,450,-1,229,233,343,-1,361,382,205,-1,450,382,361,-1,107,96,123,-1,107,440,96,-1,185,112,110,-1,185,181,112,-1,207,209,208,-1,209,207,212,-1,102,99,433,-1,102,388,99,-1,381,434,98,-1,387,434,381,-1,355,114,356,-1,104,114,355,-1,79,124,389,-1,79,81,124,-1,353,222,354,-1,223,222,353,-1,68,91,348,-1,227,91,68,-1,225,214,213,-1,214,225,429,-1,349,351,66,-1,349,346,351,-1,347,85,84,-1,347,155,85,-1,84,345,347,-1,345,84,83,-1,444,350,351,-1,444,428,350,-1,346,280,282,-1,346,344,280,-1,449,344,363,-1,344,449,280,-1,231,232,83,-1,231,137,232,-1,343,451,383,-1,136,451,343,-1,139,136,138,-1,139,451,136,-1,430,137,231,-1,430,138,137,-1,341,235,234,-1,235,341,436,-1,119,65,145,-1,65,119,121,-1,337,339,240,-1,337,129,339,-1,336,143,242,-1,336,338,143,-1,146,452,242,-1,452,146,148,-1,151,453,94,-1,151,245,453,-1,453,243,454,-1,453,245,243,-1,442,337,455,-1,337,442,129,-1,335,242,452,-1,335,336,242,-1,335,455,337,-1,335,454,455,-1,333,420,456,-1,419,420,333,-1,457,456,420,-1,458,456,457,-1,176,301,459,-1,176,53,301,-1,456,460,461,-1,456,458,460,-1,312,456,461,-1,312,333,456,-1,331,446,330,-1,446,331,462,-1,169,164,170,-1,164,169,166,-1,172,23,167,-1,172,462,23,-1,21,462,331,-1,23,462,21,-1,369,51,50,-1,369,407,51,-1,263,27,22,-1,263,328,27,-1,21,367,264,-1,21,463,367,-1,376,276,11,-1,275,276,376,-1,280,12,281,-1,449,12,280,-1,15,320,20,-1,290,320,15,-1,320,4,293,-1,320,5,4,-1,377,321,293,-1,321,377,400,-1,447,75,393,-1,75,447,445,-1,317,73,318,-1,317,74,73,-1,318,373,295,-1,318,73,373,-1,314,370,421,-1,370,314,311,-1,313,310,311,-1,310,313,309,-1,297,464,465,-1,464,297,298,-1,465,466,467,-1,466,465,464,-1,465,307,297,-1,307,465,468,-1,58,307,31,-1,58,308,307,-1,306,469,303,-1,306,468,469,-1,469,460,459,-1,460,469,467,-1,461,313,312,-1,466,313,461,-1,313,464,309,-1,466,464,313,-1,467,461,460,-1,461,467,466,-1,303,459,301,-1,459,303,469,-1,306,399,31,-1,306,305,399,-1,31,468,306,-1,307,468,31,-1,467,468,465,-1,467,469,468,-1,298,309,464,-1,298,296,309,-1,295,316,318,-1,295,19,316,-1,295,49,48,-1,295,373,49,-1,49,372,253,-1,49,373,372,-1,13,317,319,-1,317,13,288,-1,324,400,377,-1,400,324,14,-1,393,334,447,-1,427,334,393,-1,449,284,12,-1,285,284,449,-1,277,428,444,-1,37,428,277,-1,398,270,269,-1,62,270,398,-1,328,36,403,-1,36,328,263,-1,264,22,21,-1,264,263,22,-1,42,408,45,-1,156,408,42,-1,331,463,21,-1,331,332,463,-1,168,166,169,-1,168,262,166,-1,372,170,164,-1,372,371,170,-1,171,462,172,-1,171,446,462,-1,459,458,176,-1,458,459,460,-1,176,457,54,-1,176,458,457,-1,314,419,333,-1,314,421,419,-1,427,193,334,-1,426,193,427,-1,452,454,335,-1,452,453,454,-1,455,246,442,-1,455,247,246,-1,454,247,455,-1,243,247,454,-1,453,148,94,-1,452,148,453,-1,437,63,432,-1,147,63,437,-1,235,431,394,-1,436,431,235,-1,437,149,147,-1,237,149,437,-1,138,120,119,-1,430,120,138,-1,451,145,144,-1,451,139,145,-1,383,144,380,-1,451,144,383,-1,363,230,200,-1,230,363,344,-1,282,351,346,-1,282,444,351,-1,227,67,228,-1,67,227,68,-1};
			return value;
		}
		private int[] getlmet4_Geo_6_105_coordIndex_4()
		{
			int[] value = {367,429,368,-1,429,367,214,-1,105,433,435,-1,105,102,433,-1,212,353,213,-1,207,353,212,-1,214,463,210,-1,214,367,463,-1,208,211,183,-1,208,209,211,-1,205,380,202,-1,380,205,382,-1,450,198,229,-1,450,361,198,-1,383,450,343,-1,383,382,450,-1,287,362,391,-1,287,285,362,-1,448,128,384,-1,128,448,443,-1,366,195,127,-1,366,196,195,-1,190,192,378,-1,190,187,192,-1,152,186,184,-1,152,197,186,-1,440,438,441,-1,440,107,438,-1,441,179,178,-1,441,438,179,-1,210,332,189,-1,210,463,332,-1,403,52,328,-1,395,52,403,-1,398,59,62,-1,418,59,398,-1,371,171,170,-1,171,371,445,-1,169,167,168,-1,167,169,172,-1,262,165,166,-1,165,262,260,-1,164,253,372,-1,253,164,163,-1,288,74,317,-1,74,288,392,-1,447,330,446,-1,334,330,447,-1,272,161,397,-1,162,161,272,-1,9,277,283,-1,9,159,277,-1,157,44,404,-1,44,157,43,-1,424,417,423,-1,417,424,416,-1,415,410,425,-1,414,410,415,-1,57,29,56,-1,29,57,30,-1,192,365,364,-1,192,390,365,-1,310,173,370,-1,310,174,173,-1,203,239,241,-1,202,239,203,-1,151,389,244,-1,389,151,79,-1,128,339,129,-1,339,128,443,-1,441,248,440,-1,246,248,441,-1,64,145,65,-1,64,142,145,-1,134,130,194,-1,130,134,135,-1,358,386,439,-1,203,386,358,-1,107,180,438,-1,107,106,180,-1,435,387,105,-1,435,434,387,-1,237,340,238,-1,341,340,237,-1,436,432,431,-1,436,437,432,-1,356,353,357,-1,356,223,353,-1,110,100,207,-1,100,110,109,-1,108,112,106,-1,112,108,111,-1,104,388,102,-1,388,104,355,-1,123,98,434,-1,123,96,98,-1,435,206,122,-1,206,435,433,-1,432,65,121,-1,65,432,63,-1,120,394,431,-1,120,430,394,-1,140,95,238,-1,140,93,95,-1,349,155,347,-1,349,348,155,-1,90,348,91,-1,90,155,348,-1,80,150,141,-1,79,150,80,-1,78,84,85,-1,84,78,82,-1,218,86,90,-1,218,217,86,-1,429,67,350,-1,429,225,67,-1,226,224,354,-1,224,226,228,-1,287,427,286,-1,426,427,287,-1,69,365,391,-1,71,365,69,-1,404,55,157,-1,252,55,404,-1,257,54,457,-1,54,257,329,-1,58,270,308,-1,270,58,56,-1,411,299,409,-1,411,32,299,-1,304,425,305,-1,425,304,423,-1,424,302,406,-1,424,300,302,-1,422,173,175,-1,315,173,422,-1,256,421,249,-1,421,256,419,-1,420,257,457,-1,420,259,257,-1,251,254,255,-1,253,254,251,-1,177,408,156,-1,177,26,408,-1,0,418,398,-1,0,7,418,-1,255,261,258,-1,261,255,254,-1,416,407,369,-1,405,407,416,-1,417,267,415,-1,417,327,267,-1,412,28,30,-1,38,28,412,-1,325,402,403,-1,325,271,402,-1,326,414,266,-1,326,413,414,-1,33,411,57,-1,33,32,411,-1,325,36,35,-1,36,325,403,-1,326,412,413,-1,412,326,38,-1,22,24,23,-1,24,22,27,-1,25,408,26,-1,25,51,408,-1,407,44,45,-1,407,405,44,-1,252,406,302,-1,404,406,252,-1,161,1,0,-1,161,276,1,-1,374,274,275,-1,375,274,374,-1,19,321,316,-1,321,19,20,-1,279,294,322,-1,377,294,279,-1,18,375,17,-1,375,18,274,-1,3,289,323,-1,289,3,5,-1,377,278,324,-1,278,377,279,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlmet4_Coord_7_105_point_1()
		{
			double[] value = {4.02259,.47319,1.05369,4.01407,.49552,1.03658,4.01941,.49798,1.04426,4.01971,.61383,.96384,4.02171,.6307,.97534,4.02729,.61824,.98247,4.00524,.64796,1.20291,4.06853,.55228,1.12865,4.05661,.56133,1.11132,3.87233,.72279,.78487,3.91182,.63626,.88123,3.89033,.59577,.8709,3.80261,1.02496,.57907,3.84747,.86311,.86362,3.86353,.84089,.85076,4.04376,.57419,1.07616,4.05014,.5601,1.09839,4.03285,.5359,1.03163,4.02398,.5047,1.03894,3.97971,.67727,1.13842,3.98804,.6738,1.1124,3.636,.84294,.54698,3.70226,.6752,.80556,3.6973,.68526,.81885,3.69059,.57519,.89307,3.70568,.51029,.92327,3.69289,.51484,.93702,3.69781,.5693,.8778,3.87997,.41936,.84409,3.92138,.42715,.91389,3.89979,.40658,.84668,3.94984,.33004,.92344,3.91406,.36086,.85074,3.92586,.36489,.85582,3.72675,.78367,.48393,3.79814,.63055,.73752,3.77745,.62482,.73704,3.74743,.79299,.48639,3.86817,.41571,.83866,3.86853,.4313,.84146,3.86044,.42514,.84157,3.69523,.46997,1.0721,3.66768,.46852,.98403,3.66704,.44875,1.00552,3.67745,.41487,.95561,3.68137,.44415,.94807,3.89876,.67823,1.28599,3.97053,.67409,1.26045,3.96119,.68315,1.24044,3.88823,.69167,1.26671,3.75866,.47536,.89041,3.70707,.48372,.93155,3.75709,.50263,.87572,3.70983,.33522,1.08316,3.70161,.38369,1.15322,3.66993,.40015,1.03104,3.95268,.39257,.89851,3.91744,.39081,.84686,3.95892,.37087,.89733,4.10507,.53746,1.16121,4.11806,.52869,1.17964,4.10557,.42302,1.10681,4.09093,.44047,1.09718,3.48581,1.40989,-.92073,3.47131,1.43831,-.9333,3.49516,1.42893,-.91602,3.52325,1.04446,-.31328,3.48588,1.00305,-.30298,3.496,1.0424,-.39242,3.44763,1.5662,-.13118,3.3821,1.6517,-.23991,3.41546,1.54806,-.12121,3.7866,.80936,1.14119,3.82444,.81823,1.13605,3.79612,.84303,1.03313,3.76911,.84053,1.0388,3.42294,1.20091,-.57101,3.47483,1.26162,-.57281,3.48324,1.24828,-.53268,3.17506,1.09963,-.87011,3.23985,1.12827,-.77725,3.19278,1.09087,-.77997,3.53802,1.2967,-.4603,3.55375,1.33206,-.38741,3.53715,1.28096,-.43963,3.47994,1.2174,-.4983,3.40076,1.17412,-.55989,3.32106,1.02733,-.61518,3.2482,1.05688,-.68989,3.32605,1.04447,-.6351,3.40894,1.10621,-.57024,3.41054,1.07994,-.56067,3.34246,1.03352,-.60697,3.25371,1.12889,-.87727,3.24408,1.14607,-.89553,3.26425,1.13848,-.88707,2.98963,1.17421,-.78541,3.00302,1.19126,-.81565,3.00823,1.15089,-.79863,3.13079,1.01587,-.57369};
			return value;
		}
		private double[] getlmet4_Coord_7_105_point_2()
		{
			double[] value = {3.21525,1.01706,-.45195,3.11614,1.03736,-.55677,3.11795,1.03489,-.65701,3.15584,1.0569,-.70751,3.14511,1.02632,-.66368,3.12618,1.06985,-.69696,3.03902,1.22027,-.61493,3.02173,1.22034,-.65278,3.04622,1.19149,-.62855,3.10142,1.09675,-.5107,3.10545,1.11425,-.48411,3.07317,1.16336,-.58863,3.06686,1.18939,-.57015,3.20792,1.07441,-.74686,3.21874,1.05093,-.69678,3.22932,1.08407,-.73738,3.08717,1.3895,-.4811,3.08582,1.39469,-.54141,3.06881,1.34526,-.48832,3.55007,1.4869,-.80418,3.5457,1.42343,-.80252,3.5291,1.43158,-.84462,3.074,1.12324,-.65307,3.07254,1.13911,-.69227,3.14149,1.08209,-.74283,3.11927,1.55354,-.64459,3.12516,1.49248,-.57257,3.10907,1.53692,-.53346,3.13935,1.57464,-.64468,3.13164,1.55904,-.66213,3.26086,1.53165,-.23092,3.24795,1.64294,-.42149,3.15822,1.54276,-.40637,3.36313,1.65756,-.24374,3.33346,1.5691,-.17427,3.32059,1.57924,-.20055,3.57637,1.53056,-.67607,3.59516,1.45283,-.5696,3.59323,1.48027,-.71482,3.55955,1.51773,-.79439,3.29714,1.14897,-.82564,3.27164,1.13691,-.81655,3.47993,1.54291,-.89112,3.46007,1.58855,-.85794,3.47906,1.6038,-.84962,3.51497,1.5431,-.86544,3.43676,1.39751,-.92837,3.44561,1.38194,-.90908,3.334,1.27224,-.90998,3.3508,1.25123,-.90536,3.20343,1.10768,-.8765,3.17348,1.12077,-.88672,3.21275,1.37519,-.23833,3.32059,1.47649,-.17485,3.25237,1.43662,-.24272,3.46923,1.16549,-.47602,3.67289,.48417,.97862,3.66732,.42326,1.02957,3.87197,.58894,.85696,3.83731,.66298,.75653,3.85022,.56644,.83727,3.90704,.5007,.91906,3.88059,.48588,.88093,3.74993,.58322,1.20151,3.71359,.64463,1.15946,3.74473,.53389,1.13912,3.7296,.58529,1.08836,3.69353,.63075,.9172,3.69224,.61192,.95745,3.71291,.65837,1.01855,3.70802,.71061,1.08537,3.7187,.7534,1.00374,3.70669,.69738,.96274,3.9947,.66341,1.28872,4.05688,.6138,1.27093,4.05308,.63141,1.2572,3.74306,.32782,1.15578,3.6775,.51778,.96545,3.02679,1.46457,-.63807,3.0757,1.41031,-.57443,3.04225,1.28788,-.58015,3.0497,1.2574,-.52875,3.10944,1.27524,-.4238,3.14844,1.17023,-.30731,3.1616,1.2479,-.24911,3.0727,1.19213,-.46789,3.12327,1.35904,-.41913,3.37674,1.24205,.0461,3.24586,1.19636,-.12866,3.36659,1.14612,.02677,3.28644,1.31627,-.10688,3.48184,1.16325,.25206,3.43157,1.36011,.06799,3.50606,1.23588,.27843,3.25814,1.50988,-.21687,3.14637,1.5178,-.40776,3.15145,1.46844,-.44226,3.16625,1.45165,-.40681,3.48036,1.5859,-.38843,3.49836,1.56476,-.14806};
			return value;
		}
		private double[] getlmet4_Coord_7_105_point_3()
		{
			double[] value = {3.52576,1.48812,-.21496,3.44071,1.63145,-.29328,3.38301,1.7298,-.6944,3.31609,1.74184,-.66789,3.34706,1.72997,-.58462,3.40689,1.70576,-.64309,3.08297,1.07612,-.62564,3.23942,1.02764,-.39939,3.18324,1.08448,-.37967,3.30446,1.07751,-.17958,3.40329,1.06128,.00252,3.27173,1.12373,-.16231,3.35734,1.00626,-.20125,3.40918,.98224,-.25855,3.49232,.96238,-.05013,3.34329,1.18485,-.63331,3.37546,1.18172,-.67431,3.32728,1.17146,-.61312,3.31196,1.1149,-.64488,3.26867,1.13864,-.73267,3.31521,1.15665,-.78497,3.2945,1.14841,-.76327,3.33692,.99804,-.56775,3.28481,1.01992,-.58536,3.39623,.97171,-.44411,3.46609,.98569,-.29704,3.37542,.99552,-.54224,3.4352,1.01486,-.47937,3.41705,.98591,-.45283,3.49923,1.54868,-.4385,3.54767,1.40078,-.25612,3.57288,1.37884,-.57595,3.58067,1.43925,-.41509,3.57031,1.51627,-.51454,3.3787,1.18895,-.69336,3.46606,1.31919,-.70008,3.47324,1.26977,-.59047,3.35418,1.24446,-.83362,3.30726,1.15746,-.83651,3.37243,1.72369,-.7045,3.28493,1.62876,-.70762,3.30235,1.73449,-.67745,3.40246,1.49933,-.86902,3.05768,1.23492,-.79334,3.08707,1.12819,-.85705,3.13883,1.16405,-.84938,2.9654,1.33936,-.69995,2.99936,1.29286,-.73652,2.96774,1.25553,-.74334,3.81532,.62421,1.33765,3.92482,.67753,1.30002,3.80891,.63423,1.29696,3.67743,.35552,.97409,3.79671,.63784,1.26842,3.78416,.53571,1.23218,3.79263,.51831,1.2536,3.79814,.53522,1.33622,3.76845,.39823,1.2461,3.75986,.46724,1.19674,3.7834,.44923,1.297,3.70913,.49733,1.08584,3.75992,.4987,1.18496,3.70191,.544,1.03067,3.74674,.63392,.75167,3.67887,.79253,.4877,3.84861,.43051,.84339,3.84623,.40979,.84698,3.82754,.41053,.87461,3.80241,.45559,.8692,3.96124,.43162,.97222,4.0261,.39809,.9765,3.84769,.47013,.83586,3.90957,.45596,.91945,3.86143,.44452,.84086,4.01941,.50262,1.03226,3.9419,.5332,.93087,3.92605,.52084,.92445,3.77102,.83872,.50009,3.90937,.7806,.80876,3.96867,.69942,.90235,3.68262,1.15948,.17668,3.81676,.94519,.54995,3.68111,1.08224,.17079,3.7982,.89332,.52449,3.7549,1.06447,.60787,3.62462,1.27255,.25045,3.70851,1.0818,.62631,3.5747,1.27501,.27549,3.81844,.89723,.88349,4.03208,.57192,1.00747,4.03702,.59692,1.03532,3.98063,.61025,.92342,3.98887,.56795,.94548,3.9977,.679,.99642,4.00093,.68005,.94455,3.91676,.74771,1.18771,4.12849,.50043,1.22888,4.10601,.36233,1.12005,4.13451,.39655,1.17148,3.89101,.35067,.85386};
			return value;
		}
		private double[] getlmet4_Coord_7_105_point_4()
		{
			double[] value = {3.71639,.33974,.93132,3.73397,.30055,1.03899,3.68581,.34797,.96003,3.81589,.28251,.9825,3.77326,.31941,.94093,3.86771,.31938,.90392,3.89867,.30464,.94745,4.0304,.3249,1.01465,4.03396,.37661,.97688,4.09182,.47806,1.29017,4.02379,.57964,1.30964,3.95657,.57232,1.35325,3.93852,.46475,1.35554,4.01015,.45089,1.33143,3.86833,.59012,1.36454,3.97928,.67707,1.27584,3.92,.74247,1.08333,3.83616,.8334,1.02137,3.87649,.80684,1.11996,3.89102,.7846,.99146,4.01302,.63904,1.03324,3.93914,.72749,1.06431,3.99904,.66693,.93119,4.02288,.56047,.99345,3.90736,.7987,.81888,3.81267,.53709,.80064,3.85988,.40938,.8396,3.76963,.42219,.90265,3.74095,.55349,.82605,3.70095,.40664,1.1594,3.62834,.99102,.63488,3.61472,.9162,.60341,3.48542,1.08605,.22053,3.84806,.49782,1.36226,3.65565,1.04193,.64067,3.2247,1.42229,-.77663,3.35835,1.58536,-.78481,3.16398,1.50631,-.71545,3.4093,1.64968,-.79147,3.21986,1.65779,-.6561,3.32565,1.16549,-.79426,3.36021,1.23226,-.79203,3.55987,1.36064,-.59368,3.53444,1.57781,-.63094,3.61836,1.26203,-.0169,3.56538,1.29214,-.29045,3.60583,1.17866,-.0403,3.55425,1.19136,-.32436,3.47208,1.1486,-.46355,3.55184,1.17606,-.31819,3.54371,.98237,-.06011,3.58974,1.06159,-.05653,3.36161,1.00306,-.56189,3.28528,.99511,-.45448,3.35099,.98761,-.54012,3.17713,.99649,-.5913,3.25628,1.01744,-.5841,3.23483,.9999,-.47704,3.30361,1.74567,-.54273,3.37232,1.69645,-.47543,3.33551,1.73078,-.43335,3.43522,1.66073,-.55062,3.55064,1.39393,.05918,3.59963,1.3517,.01516,3.38881,1.51076,-.11374,3.45243,1.44107,.00754,3.13116,1.47557,-.53414,3.55788,.93692,.14655,3.5943,.92624,.13014,3.74222,.43113,.90028,3.93835,.66505,1.31364,3.75081,.78032,1.13811,3.76288,.71892,1.22155,3.85319,.75531,1.22718,3.9638,.55468,.93412,4.02227,.52636,1.01717,3.91899,.59824,.89147,3.9708,.7113,.91522,3.35254,1.45255,-.10493,3.36416,1.53551,-.15701,3.42456,1.66186,-.78045,3.07362,1.10126,-.81912,3.44057,1.65548,-.68996,3.48879,1.61709,-.71361,3.11913,1.56175,-.53115,3.30598,1.71923,-.42717,3.29259,1.73368,-.66,3.11886,1.09251,-.72632,3.14996,1.00104,-.58564,3.09916,1.09305,-.82992,3.4689,1.39274,.06812,3.50343,1.40495,.06164,3.78044,.89617,.92211,3.74625,.88703,.92684,3.57111,1.40364,-.73696,3.79945,.48023,.84915,4.02198,.63936,1.22375,3.94739,.45998,.97501,4.04,.45781,1.06715,3.88029,.34286,.86219};
			return value;
		}
		private double[] getlmet4_Coord_7_105_point_5()
		{
			double[] value = {3.91187,.76595,.97806,3.94641,.60361,.90579,3.831,.46225,.83741,3.78959,.53428,.79741,3.67612,.3716,.95705,3.6871,.41199,.94113,3.68458,.36452,.94393,3.69333,.44053,.93431,3.69354,.4871,.94521,3.87062,.36367,.84778,3.85748,.35981,.85628,3.90202,.37873,.83934,3.88441,.39663,.83729,3.86556,.38405,.84235,3.85023,.38217,.8516,3.83447,.38263,.88231,3.7331,.40411,.90637,3.7694,.3928,.90985,4.08158,.54026,1.14026,3.8125,.52792,1.35262,3.79645,.43536,1.31101,3.83094,.61621,1.35381,4.04133,.63994,1.24137,3.77224,.33684,.9259,3.71842,.35575,.91737,3.84944,.33606,.8953,3.54041,1.2632,.28266,3.67618,1.0754,.63147,3.62213,.94664,.12883,3.52246,.96743,-.05735,3.5821,1.42065,-.73326,3.53407,1.40721,-.80683,3.51579,1.41333,-.85373,3.09673,1.05668,-.64837,3.09097,1.11724,-.70602,3.0932,1.10022,-.67274,3.45156,1.35451,-.80905,3.44653,1.3654,-.85156,3.02404,1.29285,-.61863,3.27986,1.73669,-.5418,2.96386,1.24926,-.73373,2.96171,1.33552,-.6888,3.02667,1.46196,-.65201,3.21648,1.66295,-.6396,3.65758,1.01044,.15026,3.755,.82586,1.03836,3.70979,.80003,.92597,3.7418,.87514,.93344,3.21666,1.66603,-.54387,3.66896,1.24228,.2065,3.46087,1.6225,-.57118,3.54049,1.56436,-.75339,3.28726,1.32203,-.8577,3.19936,1.21942,-.84232,3.13223,1.31181,-.77574,3.07435,1.38712,-.71553,3.84209,.39832,1.31439,3.77592,.37516,1.2506,3.80244,.34397,1.24688,3.82156,.2647,1.13343,3.87302,.28276,1.21398,3.92855,.36011,1.29845,3.69996,.74359,.89662,3.50537,1.01421,.1905,4.0972,.36593,1.2304,4.05987,.31537,1.16347,3.997,.35559,1.28326,3.95245,.27263,1.19659,3.98665,.28761,1.05924,3.90941,.2558,1.11075};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlmet5_Geo_6_110_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,21,24,22,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,36,37,34,-1,38,35,39,-1,38,40,35,-1,41,42,43,-1,43,44,41,-1,45,46,47,-1,47,48,45,-1,49,50,45,-1,45,51,49,-1,52,53,54,-1,52,55,53,-1,56,57,12,-1,57,13,12,-1,58,59,60,-1,7,61,62,-1,62,63,7,-1,59,64,60,-1,65,66,67,-1,65,68,66,-1,69,64,70,-1,64,71,70,-1,72,73,74,-1,73,75,74,-1,76,77,78,-1,79,80,78,-1,81,82,78,-1,83,84,78,-1,85,86,87,-1,87,88,85,-1,89,33,90,-1,91,92,93,-1,94,69,95,-1,70,96,97,-1,98,99,100,-1,98,101,99,-1,102,103,73,-1,104,105,106,-1,104,107,105,-1,108,34,109,-1,110,111,112,-1,63,113,114,-1,70,115,96,-1,24,21,32,-1,116,11,117,-1,116,118,11,-1,119,116,120,-1,116,117,120,-1,118,121,122,-1,118,116,121,-1,123,124,125,-1,5,4,126,-1,127,128,129,-1,130,131,132,-1,133,134,135,-1,134,136,135,-1,137,138,139,-1,138,140,139,-1,141,142,143,-1,16,144,145,-1,146,147,148,-1,147,149,148,-1,150,151,152,-1,151,153,152,-1,154,155,156,-1,155,157,156,-1,158,159,160,-1,161,162,163,-1,163,164,161,-1,165,166,167,-1,165,168,166,-1,169,170,171,-1,172,173,174,-1,175,176,177,-1,131,178,179,-1,180,181,182,-1,182,181,183,-1,183,184,182,-1,185,186,187,-1,184,188,189,-1,184,183,188,-1,167,190,162,-1,158,160,173,-1,191,192,193,-1,194,155,195,-1,171,196,197,-1,198,199,200,-1,201,202,203,-1,201,197,202,-1,151,204,154,-1,151,205,204,-1,202,197,196,-1,206,207,175,-1,207,176,175,-1,208,194,195,-1,208,209,194,-1,142,138,210,-1,211,212,213,-1,214,215,3,-1,132,216,217,-1,218,219,220,-1,218,221,219,-1,132,131,179,-1,5,189,3,-1,222,223,202,-1,224,200,225,-1,200,226,225,-1,208,204,227,-1,208,195,204,-1,228,229,230,-1,230,231,228,-1,232,188,233,-1,188,234,233,-1,235,236,237,-1,237,238,235,-1,1,239,240,-1,241,242,2,-1,243,244,234,-1,234,245,243,-1,230,175,231,-1,210,246,142,-1,210,129,246,-1,247,248,249,-1,247,250,248,-1,251,252,253,-1,251,125,252,-1,254,124,242,-1,125,255,123,-1,256,257,258,-1,239,161,240,-1,161,164,240,-1,1,259,260,-1,177,231,175,-1,261,253,252,-1,252,192,261,-1,125,251,255,-1,219,262,263,-1,219,264,262,-1,265,133,129,-1,213,266,211,-1,152,267,268,-1,269,270,205,-1,271,207,272,-1,271,273,207,-1,274,275,276,-1,277,278,194,-1,157,279,280,-1,15,281,16,-1,15,282,281,-1,126,184,5,-1,283,284,140,-1,284,139,140,-1,285,286,287,-1,285,288,286,-1,289,290,291,-1,289,292,290,-1,293,294,295,-1,293,291,294,-1,296,297,143,-1,129,210,127,-1,3,215,298,-1,299,262,132,-1,132,300,216,-1,109,34,301,-1,302,23,303,-1,23,22,303,-1,304,305,306,-1,306,307,304,-1,110,308,111,-1,111,31,309,-1,310,110,112,-1,85,83,82,-1,85,9,83,-1,62,93,92,-1,62,75,93,-1,84,83,9,-1,9,11,84,-1,311,59,121,-1,311,68,59,-1,66,312,313,-1,313,314,66,-1,315,316,317,-1,315,67,316,-1,51,105,107,-1,51,45,105,-1,318,106,319,-1,318,320,106,-1,292,321,322,-1,292,289,321,-1,35,40,323,-1,36,324,325,-1,36,323,324,-1,326,325,327,-1,301,34,37,-1,55,328,329,-1,52,54,50,-1,330,56,331,-1,56,330,49,-1,49,57,56,-1,332,333,334,-1,333,335,334,-1,336,43,42,-1,337,338,339,-1,340,341,342,-1,304,307,37,-1,307,301,37,-1,36,35,323,-1,38,39,343,-1,344,345,346,-1,346,347,344,-1,348,349,350,-1,349,351,350,-1,352,322,353,-1,322,321,353,-1,349,354,351,-1,354,355,351,-1,319,106,105,-1,315,101,98,-1,105,48,319,-1,105,45,48,-1,356,357,358,-1,315,98,67,-1,98,65,67,-1,359,313,360,-1,359,282,313,-1,361,362,71,-1,361,363,362,-1,58,121,59,-1,364,119,120,-1,364,365,119,-1,366,367,368,-1,366,369,367,-1,370,371,372,-1,370,373,371,-1,373,326,371,-1,374,20,19,-1,374,375,20,-1,376,299,132,-1};
			return value;
		}
		private int[] getlmet5_Geo_6_110_coordIndex_2()
		{
			int[] value = {179,300,132,-1,295,377,378,-1,295,294,377,-1,292,379,290,-1,292,380,379,-1,381,126,4,-1,381,284,126,-1,182,184,126,-1,126,382,182,-1,383,384,385,-1,386,387,388,-1,386,389,387,-1,157,390,156,-1,157,280,390,-1,237,391,243,-1,243,245,237,-1,277,392,278,-1,277,393,392,-1,271,276,394,-1,394,395,271,-1,206,272,207,-1,204,205,227,-1,205,270,227,-1,281,268,267,-1,281,396,268,-1,223,397,202,-1,397,203,202,-1,193,159,191,-1,398,346,399,-1,399,400,398,-1,263,220,219,-1,263,401,220,-1,172,158,173,-1,172,398,158,-1,187,218,249,-1,176,402,177,-1,402,403,177,-1,404,0,225,-1,256,258,197,-1,258,171,197,-1,171,174,169,-1,351,355,405,-1,355,399,405,-1,346,172,347,-1,346,398,172,-1,166,190,167,-1,124,2,242,-1,124,406,2,-1,182,407,180,-1,182,382,407,-1,408,409,410,-1,411,175,233,-1,175,230,233,-1,163,162,190,-1,235,412,236,-1,412,413,236,-1,245,238,237,-1,229,232,233,-1,233,230,229,-1,148,156,390,-1,148,153,156,-1,203,397,269,-1,414,214,3,-1,220,401,247,-1,415,381,416,-1,416,417,415,-1,418,266,213,-1,132,217,376,-1,213,419,418,-1,133,265,134,-1,198,420,199,-1,198,421,420,-1,202,196,170,-1,170,222,202,-1,404,422,222,-1,222,170,404,-1,269,150,268,-1,268,203,269,-1,171,170,196,-1,396,201,268,-1,158,191,159,-1,168,259,170,-1,259,404,170,-1,190,160,163,-1,190,173,160,-1,193,241,159,-1,161,239,165,-1,239,260,165,-1,1,260,239,-1,232,423,189,-1,189,188,232,-1,262,299,263,-1,225,226,404,-1,168,169,166,-1,168,170,169,-1,424,279,157,-1,157,155,424,-1,268,150,152,-1,278,425,424,-1,426,427,130,-1,130,262,426,-1,428,133,135,-1,132,262,130,-1,129,128,265,-1,184,189,5,-1,3,298,4,-1,114,118,8,-1,118,122,8,-1,429,80,79,-1,79,113,429,-1,430,26,25,-1,95,69,431,-1,369,432,367,-1,369,433,432,-1,434,12,14,-1,19,18,32,-1,108,343,39,-1,435,73,72,-1,435,102,73,-1,436,437,93,-1,438,358,320,-1,358,352,320,-1,438,320,318,-1,8,439,6,-1,93,86,91,-1,10,9,440,-1,86,437,87,-1,86,93,437,-1,82,83,78,-1,80,81,78,-1,77,79,78,-1,84,76,78,-1,92,91,429,-1,429,113,92,-1,75,73,93,-1,70,97,441,-1,6,439,95,-1,439,94,95,-1,62,92,63,-1,57,442,443,-1,443,13,57,-1,363,98,100,-1,330,52,50,-1,50,49,330,-1,101,444,445,-1,55,52,330,-1,306,25,307,-1,306,430,25,-1,446,443,43,-1,32,31,111,-1,39,35,34,-1,304,373,305,-1,304,326,373,-1,34,108,39,-1,112,111,309,-1,18,24,32,-1,444,101,315,-1,325,326,36,-1,121,58,122,-1,85,447,86,-1,63,92,113,-1,448,449,257,-1,120,450,364,-1,120,451,450,-1,201,203,268,-1,173,190,174,-1,449,364,450,-1,364,449,448,-1,316,66,314,-1,316,67,66,-1,21,452,90,-1,21,23,452,-1,453,315,317,-1,453,444,315,-1,454,455,456,-1,455,454,457,-1,22,375,303,-1,20,375,22,-1,458,459,460,-1,459,458,461,-1,462,463,464,-1,462,465,463,-1,41,107,104,-1,107,41,44,-1,112,305,373,-1,305,112,309,-1,304,36,326,-1,37,36,304,-1,308,437,19,-1,308,87,437,-1,31,430,306,-1,31,33,430,-1,342,109,301,-1,109,342,341,-1,301,25,342,-1,301,307,25,-1,343,337,339,-1,343,108,337,-1,46,53,466,-1,53,46,54,-1,467,468,47,-1,467,99,468,-1,442,43,443,-1,442,44,43,-1,432,331,29,-1,432,328,331,-1,469,433,96,-1,433,469,329,-1,362,100,470,-1,362,363,100,-1,94,58,60,-1,439,58,94,-1,441,69,70,-1,441,431,69,-1,447,91,86,-1,447,429,91,-1,440,85,88,-1,85,440,9,-1,370,440,310,-1,370,10,440,-1,438,471,472,-1,438,318,471,-1,472,358,438,-1,472,356,358,-1,14,473,474,-1,446,473,14,-1,442,49,51,-1,57,49,442,-1,336,475,473,-1,336,338,475,-1,103,93,73,-1,103,436,93,-1,72,366,435,-1,366,72,441,-1,341,476,477,-1,341,340,476,-1,12,30,29,-1,30,12,434,-1,51,44,442,-1,51,107,44,-1,478,479,327,-1,478,480,479,-1,345,399,346,-1,405,399,345,-1,26,33,89,-1,430,33,26,-1,81,429,447,-1,81,80,429,-1,63,8,7,-1,63,114,8,-1};
			return value;
		}
		private int[] getlmet5_Geo_6_110_coordIndex_3()
		{
			int[] value = {119,312,311,-1,119,365,312,-1,264,426,262,-1,481,426,264,-1,481,482,483,-1,481,264,482,-1,484,130,427,-1,484,131,130,-1,415,485,486,-1,485,415,417,-1,413,390,280,-1,413,487,390,-1,280,236,413,-1,280,279,236,-1,376,488,401,-1,376,217,488,-1,488,216,214,-1,488,217,216,-1,187,228,185,-1,228,187,249,-1,241,164,159,-1,241,240,164,-1,166,174,190,-1,166,169,174,-1,240,2,1,-1,2,240,241,-1,489,200,199,-1,489,226,200,-1,226,422,404,-1,422,226,489,-1,420,490,491,-1,421,490,420,-1,392,425,278,-1,391,425,392,-1,409,244,243,-1,244,409,408,-1,224,273,492,-1,273,224,402,-1,411,206,175,-1,411,493,206,-1,137,494,127,-1,494,137,486,-1,418,485,484,-1,485,418,419,-1,483,212,481,-1,495,212,483,-1,427,418,484,-1,266,418,427,-1,178,417,416,-1,178,131,417,-1,496,212,495,-1,496,213,212,-1,488,247,401,-1,247,488,250,-1,384,497,386,-1,497,384,383,-1,146,498,388,-1,146,487,498,-1,420,499,500,-1,420,491,499,-1,501,177,403,-1,501,185,177,-1,409,393,410,-1,409,392,393,-1,238,180,235,-1,238,181,180,-1,502,382,283,-1,382,502,407,-1,124,186,406,-1,124,123,186,-1,487,412,498,-1,412,487,413,-1,387,145,147,-1,387,503,145,-1,17,457,454,-1,457,17,16,-1,479,372,371,-1,479,504,372,-1,345,505,480,-1,345,344,505,-1,378,297,296,-1,378,377,297,-1,285,506,288,-1,285,497,506,-1,191,261,192,-1,261,191,507,-1,508,399,355,-1,508,400,399,-1,509,510,511,-1,509,507,510,-1,394,275,512,-1,394,276,275,-1,349,289,354,-1,289,349,321,-1,244,233,234,-1,233,244,411,-1,258,174,171,-1,172,174,258,-1,193,252,254,-1,193,192,252,-1,187,123,218,-1,186,123,187,-1,255,218,123,-1,255,221,218,-1,398,510,158,-1,398,400,510,-1,513,507,509,-1,507,513,261,-1,135,255,251,-1,255,135,136,-1,295,508,293,-1,508,295,511,-1,509,296,513,-1,509,378,296,-1,201,256,197,-1,201,396,256,-1,359,281,282,-1,359,396,281,-1,397,514,515,-1,397,223,514,-1,514,489,500,-1,514,422,489,-1,270,499,227,-1,270,515,499,-1,395,198,492,-1,421,198,395,-1,248,414,423,-1,250,414,248,-1,393,512,275,-1,512,393,277,-1,410,275,274,-1,410,393,275,-1,234,183,245,-1,234,188,183,-1,245,181,238,-1,181,245,183,-1,385,498,412,-1,385,384,498,-1,153,149,152,-1,148,149,153,-1,503,389,516,-1,387,389,503,-1,287,455,516,-1,455,287,379,-1,497,389,386,-1,497,285,389,-1,383,180,407,-1,383,385,180,-1,284,415,139,-1,415,284,381,-1,517,407,502,-1,517,383,407,-1,143,506,517,-1,143,297,506,-1,290,294,291,-1,290,286,294,-1,419,496,494,-1,496,419,213,-1,27,342,25,-1,27,340,342,-1,449,347,257,-1,344,347,449,-1,505,451,504,-1,505,450,451,-1,371,327,479,-1,371,326,327,-1,436,518,374,-1,436,103,518,-1,519,102,435,-1,102,519,520,-1,61,75,62,-1,74,75,61,-1,448,365,364,-1,448,360,365,-1,451,117,521,-1,451,120,117,-1,77,118,114,-1,77,76,118,-1,58,8,122,-1,58,439,8,-1,98,361,65,-1,98,363,361,-1,362,70,71,-1,362,115,70,-1,100,467,470,-1,100,99,467,-1,453,380,357,-1,456,380,453,-1,318,48,471,-1,318,319,48,-1,45,54,46,-1,54,45,50,-1,322,358,357,-1,322,352,358,-1,104,343,41,-1,104,38,343,-1,348,321,349,-1,353,321,348,-1,351,478,350,-1,405,478,351,-1,353,320,352,-1,320,353,522,-1,324,353,348,-1,522,353,324,-1,106,522,40,-1,106,320,522,-1,477,337,341,-1,477,523,337,-1,336,339,338,-1,42,339,336,-1,524,477,476,-1,524,525,477,-1,335,475,523,-1,335,333,475,-1,43,473,446,-1,43,336,473,-1,332,474,333,-1,526,474,332,-1,335,527,334,-1,335,525,527,-1,375,518,458,-1,518,375,374,-1,334,460,459,-1,334,527,460,-1,465,526,332,-1,462,526,465,-1,368,28,464,-1,367,28,368,-1,463,520,519,-1,463,461,520,-1,518,461,458,-1,461,518,520,-1,519,464,463,-1,368,464,519,-1,328,330,331,-1,328,55,330,-1,329,53,55,-1,53,329,469,-1,434,462,30,-1,434,526,462,-1,459,332,334,-1,465,332,459,-1,302,460,527,-1,460,302,303,-1,302,525,524,-1,527,525,302,-1,474,434,14,-1,434,474,526,-1,475,474,473,-1,475,333,474,-1};
			return value;
		}
		private int[] getlmet5_Geo_6_110_coordIndex_4()
		{
			int[] value = {523,525,335,-1,477,525,523,-1,350,327,325,-1,478,327,350,-1,324,40,522,-1,324,323,40,-1,348,325,324,-1,350,325,348,-1,357,292,322,-1,380,292,357,-1,47,471,48,-1,468,471,47,-1,466,470,467,-1,470,466,528,-1,15,313,282,-1,313,15,314,-1,60,69,94,-1,60,64,69,-1,66,311,312,-1,66,68,311,-1,113,77,114,-1,113,79,77,-1,11,521,117,-1,10,521,11,-1,359,448,257,-1,359,360,448,-1,95,74,61,-1,95,431,74,-1,368,435,366,-1,435,368,519,-1,103,520,518,-1,103,102,520,-1,310,88,110,-1,440,88,310,-1,309,306,305,-1,309,31,306,-1,110,87,308,-1,88,87,110,-1,521,504,451,-1,521,372,504,-1,344,450,505,-1,344,449,450,-1,10,372,521,-1,10,370,372,-1,524,23,302,-1,524,452,23,-1,19,436,374,-1,19,437,436,-1,215,416,298,-1,215,178,416,-1,494,128,127,-1,128,494,496,-1,296,142,246,-1,296,143,142,-1,293,289,291,-1,354,289,293,-1,379,286,290,-1,379,287,286,-1,286,377,294,-1,377,286,288,-1,497,517,506,-1,497,383,517,-1,502,143,517,-1,502,141,143,-1,382,284,283,-1,382,126,284,-1,285,516,389,-1,516,285,287,-1,456,379,380,-1,456,455,379,-1,144,281,267,-1,281,144,16,-1,152,144,267,-1,144,152,149,-1,385,235,180,-1,385,412,235,-1,274,408,410,-1,274,493,408,-1,194,512,277,-1,194,209,512,-1,272,493,274,-1,206,493,272,-1,273,395,492,-1,395,273,271,-1,490,395,394,-1,490,421,395,-1,500,515,514,-1,515,500,499,-1,223,422,514,-1,222,422,223,-1,269,515,270,-1,269,397,515,-1,257,396,359,-1,257,256,396,-1,496,265,128,-1,265,496,495,-1,428,296,246,-1,513,296,428,-1,511,378,509,-1,511,295,378,-1,355,293,508,-1,355,354,293,-1,482,255,136,-1,221,255,482,-1,253,513,428,-1,261,513,253,-1,220,249,218,-1,220,247,249,-1,402,225,403,-1,225,402,224,-1,172,257,347,-1,172,258,257,-1,189,414,3,-1,414,189,423,-1,271,274,276,-1,271,272,274,-1,394,209,490,-1,394,512,209,-1,400,511,510,-1,508,511,400,-1,507,158,510,-1,158,507,191,-1,297,288,506,-1,377,288,297,-1,480,504,479,-1,480,505,504,-1,454,316,17,-1,454,317,316,-1,503,16,145,-1,503,457,16,-1,388,147,146,-1,388,387,147,-1,254,241,193,-1,254,242,241,-1,124,252,125,-1,124,254,252,-1,135,253,428,-1,135,251,253,-1,428,129,133,-1,129,428,246,-1,283,141,502,-1,283,140,141,-1,391,236,425,-1,391,237,236,-1,260,168,165,-1,259,168,260,-1,177,228,231,-1,185,228,177,-1,403,0,501,-1,0,403,225,-1,227,491,208,-1,491,227,499,-1,500,199,420,-1,199,500,489,-1,386,498,384,-1,386,388,498,-1,298,381,4,-1,381,298,416,-1,264,221,482,-1,221,264,219,-1,414,488,214,-1,414,250,488,-1,211,427,426,-1,266,427,211,-1,134,495,483,-1,265,495,134,-1,481,211,426,-1,212,211,481,-1,486,419,494,-1,486,485,419,-1,137,210,138,-1,127,210,137,-1,278,155,194,-1,155,278,424,-1,200,492,198,-1,200,224,492,-1,207,402,176,-1,207,273,402,-1,408,411,244,-1,408,493,411,-1,243,392,409,-1,243,391,392,-1,209,491,490,-1,209,208,491,-1,150,205,151,-1,205,150,269,-1,195,154,204,-1,195,155,154,-1,259,0,404,-1,1,0,259,-1,248,228,249,-1,248,229,228,-1,232,248,423,-1,232,229,248,-1,406,185,501,-1,406,186,185,-1,263,376,401,-1,263,299,376,-1,214,300,215,-1,214,216,300,-1,300,178,215,-1,300,179,178,-1,2,501,0,-1,406,501,2,-1,167,161,165,-1,161,167,162,-1,163,159,164,-1,159,163,160,-1,156,151,154,-1,151,156,153,-1,147,144,149,-1,147,145,144,-1,148,487,146,-1,487,148,390,-1,279,425,236,-1,425,279,424,-1,142,140,138,-1,142,141,140,-1,139,486,137,-1,486,139,415,-1,484,417,131,-1,484,485,417,-1,483,136,134,-1,483,482,136,-1,365,313,312,-1,365,360,313,-1,116,311,121,-1,116,119,311,-1,82,447,85,-1,82,81,447,-1,118,84,11,-1,118,76,84,-1,32,90,33,-1,21,90,32,-1,405,480,478,-1,405,345,480,-1,53,528,466,-1,53,469,528,-1,367,29,28,-1,367,432,29,-1,357,444,453,-1,444,357,356,-1,529,340,27,-1,340,529,476,-1,369,441,97,-1,369,366,441,-1,96,369,97,-1,433,369,96,-1,338,523,475,-1,338,337,523,-1};
			return value;
		}
		private int[] getlmet5_Geo_6_110_coordIndex_5()
		{
			int[] value = {13,446,14,-1,443,446,13,-1,445,356,472,-1,445,444,356,-1,472,468,445,-1,472,471,468,-1,452,476,529,-1,476,452,524,-1,310,373,370,-1,373,310,112,-1,361,64,59,-1,361,71,64,-1,72,431,441,-1,72,74,431,-1,65,59,68,-1,59,65,361,-1,61,6,95,-1,6,61,7,-1,96,528,469,-1,96,115,528,-1,115,470,528,-1,115,362,470,-1,329,432,433,-1,432,329,328,-1,29,56,12,-1,29,331,56,-1,445,99,101,-1,99,445,468,-1,466,47,46,-1,466,467,47,-1,337,109,341,-1,109,337,108,-1,339,41,343,-1,41,339,42,-1,111,19,32,-1,111,308,19,-1,38,106,40,-1,38,104,106,-1,30,464,28,-1,30,462,464,-1,461,465,459,-1,465,461,463,-1,458,303,375,-1,458,460,303,-1,516,457,503,-1,516,455,457,-1,317,456,453,-1,456,317,454,-1,27,89,529,-1,26,89,27,-1,24,20,22,-1,24,18,20,-1,90,529,89,-1,90,452,529,-1,17,314,15,-1,17,316,314,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlmet5_Coord_7_110_point_1()
		{
			double[] value = {3.63578,1.39327,-.99779,3.64656,1.38915,-.98041,3.65503,1.37954,-.9894,3.69247,.99047,-1.49846,3.68517,.92042,-1.42685,3.65686,.96514,-1.39993,4.14009,.49654,.7242,4.17802,.52102,.75165,4.13521,.54764,.71516,4.17196,.76518,.72517,4.15141,.79738,.65478,4.10658,.73866,.69559,4.29227,.33366,.66491,4.29228,.35905,.55881,4.31653,.35115,.55026,3.66636,.89421,-.13398,3.59843,.93659,-.33266,3.6772,.86964,-.14147,4.40073,.75554,.77183,4.33938,.73298,.82415,4.4063,.72747,.80235,4.43429,.76884,.72271,4.43422,.72968,.7786,4.46442,.74633,.70675,4.41488,.75465,.75887,4.40571,.81624,.46475,4.40639,.82217,.53293,4.42873,.8006,.5214,4.27938,.33948,.73512,4.25301,.32238,.69564,4.30824,.339,.71134,4.3607,.80738,.65626,4.39286,.77245,.73511,4.38519,.80148,.64935,4.39908,.61387,.41346,4.38013,.61543,.39161,4.35915,.72704,.37375,4.37954,.72923,.3884,4.32362,.57598,.34694,4.39317,.59597,.40536,4.3199,.59205,.33556,4.30974,.46521,.36977,4.32162,.44288,.38728,4.30075,.40935,.4192,4.28312,.42018,.42025,4.2027,.45227,.51827,4.16106,.45348,.56412,4.12755,.50959,.52097,4.16217,.50489,.45218,4.22682,.4132,.57054,4.20997,.42068,.57666,4.21717,.44056,.51631,4.20218,.39668,.63356,4.16261,.41902,.61535,4.18125,.42304,.60685,4.21028,.37475,.67041,4.26949,.33831,.66174,4.26972,.36964,.56199,4.06284,.53313,.6437,3.95486,.56392,.56744,4.05135,.51409,.63779,4.18194,.50888,.76777,4.21034,.58111,.79183,4.19964,.58617,.77362,4.0268,.48708,.63556,3.89005,.61147,.45393,3.82068,.71162,.35256,3.82651,.69577,.34027,3.88628,.64107,.47256,4.07226,.4413,.69935,4.06426,.4158,.68412,4.02604,.46154,.61747,4.17408,.46881,.83961,4.22044,.55668,.87656,4.16928,.4863,.8209,4.20292,.56186,.85691,4.12891,.67803,.76611,4.13882,.67175,.77463,4.14395,.68663,.77749,4.14848,.67177,.7824,4.1576,.6815,.78892,4.15745,.68987,.78808,4.14936,.70131,.78058,4.1404,.70215,.77329,4.13067,.69665,.76592,4.20051,.75505,.77306,4.21593,.70176,.81854,4.24302,.72189,.81507,4.22271,.76314,.77064,4.42423,.79348,.62713,4.42954,.78998,.64305,4.19865,.6648,.81785,4.20059,.62794,.79174,4.20718,.65346,.84721,4.10493,.48385,.69645,4.13372,.48052,.7277,4.10432,.3821,.67175,4.08672,.40061,.7188,3.9197,.58812,.42377,4.05823,.56206,.48177};
			return value;
		}
		private double[] getlmet5_Coord_7_110_point_2()
		{
			double[] value = {4.00458,.52293,.50683,3.99032,.61041,.39967,4.28937,.53954,.88845,4.29606,.57241,.8916,4.27406,.53133,.3508,4.22465,.48752,.40899,4.25825,.53794,.33879,4.24206,.47799,.40825,4.44992,.57937,.42972,4.4659,.63723,.45054,4.27267,.77565,.75417,4.369,.76815,.72177,4.30128,.79154,.6656,4.18045,.64165,.78213,4.15297,.59881,.73745,4.07588,.41198,.63274,3.99785,.71632,.57945,4.02878,.78406,.58689,4.09705,.64373,.70026,3.93769,.76339,.5096,3.97307,.81958,.51151,3.98728,.63436,.56525,4.08303,.58039,.66482,3.82291,1.23745,-1.25049,3.77697,1.30069,-1.09582,3.84512,1.25615,-1.09712,3.69967,.92057,-1.33301,3.91713,.86781,-1.34313,3.96851,.95082,-1.30221,3.97356,.94251,-1.12545,3.8694,1.02921,-1.60483,3.84307,.97991,-1.58068,3.82811,1.03249,-1.61378,4.00643,1.06206,-1.11336,4.02013,1.08519,-1.28956,3.98923,1.08785,-1.10822,3.9952,1.10012,-1.28099,3.90595,.86342,-1.34456,3.87625,.85737,-1.15949,3.88759,.87483,-1.34662,3.85958,.85951,-1.16665,3.8341,.87611,-1.05039,3.84869,.87516,-1.04516,3.8186,.897,-.93378,3.52597,.98671,-.50291,3.53616,.95851,-.51546,3.40836,.97705,-.82253,3.46327,.96977,-.67031,3.38886,1.00504,-.81434,3.45053,.99808,-.66067,3.4535,1.10264,-.59178,3.36083,1.07414,-.78809,3.46222,1.06317,-.62363,3.38981,1.05007,-.80496,3.32908,1.07153,-.90164,3.30271,1.06928,-1.00736,3.36468,1.04656,-.90218,3.34555,1.03212,-.99547,3.83249,1.18988,-.52894,3.79075,1.26786,-.67802,3.79645,1.23905,-.59109,3.76263,1.31184,-.655,3.7615,1.27045,-.57673,3.78245,1.25514,-.589,3.77831,1.28442,-.67137,3.7216,1.3251,-.64225,3.70937,1.27241,-.56787,3.73927,1.2773,-.5699,3.67011,1.30463,-.64424,3.69778,1.2649,-.55435,3.65371,1.31058,-.63914,3.68156,1.22936,-.47458,3.81076,1.1623,-.29939,3.76984,1.2194,-.49482,3.74969,1.22466,-.48758,3.65085,1.2144,-1.42092,3.6704,1.31583,-1.33301,3.69797,1.28326,-1.30929,3.79978,.9635,-1.57163,3.80485,.98053,-1.58538,3.58774,.94049,-1.08544,3.58169,.9546,-1.19377,3.62285,.94378,-1.19881,3.59342,.98637,-1.30243,3.63145,.96682,-1.30729,3.73638,1.27865,-1.29874,3.76944,1.26183,-1.28072,3.76933,1.2564,-1.32564,3.60596,1.02351,-1.36164,3.63379,1.00689,-1.37948,3.75936,1.22954,-.49803,3.83141,1.22279,-.7031,3.82481,1.25355,-.88089,3.77476,1.28516,-.88659,3.29915,1.09124,-1.01458,3.30196,1.09619,-.99306,3.65045,1.24221,-.45276,3.64387,1.21406,-.4168,3.51844,1.42959,-.99392,3.52242,1.42631,-.96895};
			return value;
		}
		private double[] getlmet5_Coord_7_110_point_3()
		{
			double[] value = {3.54215,1.43807,-.99329,3.58669,1.13549,-.4355,3.60815,1.24366,-.45635,3.55911,1.16925,-.46087,3.32848,1.10211,-.89478,3.36278,1.10445,-.79048,3.62913,1.22076,-1.40916,3.64841,1.31403,-1.33385,3.31631,1.14505,-.99137,3.31904,1.14411,-1.01628,3.888,.86053,-1.15499,3.92052,1.07248,-1.59791,3.96659,1.07951,-1.5241,3.9361,.98341,-1.51996,3.73256,1.05087,-1.55841,3.74121,.98375,-1.55721,3.76317,1.0498,-1.58463,3.79021,1.09082,-1.57645,3.82731,1.21701,-1.43348,3.90816,1.15091,-1.49792,3.81709,1.18872,-1.50041,3.93647,1.16374,-1.41343,3.61125,1.3173,-.63099,3.56411,1.28064,-.61029,3.56805,1.43404,-1.06717,3.5895,1.3916,-1.0316,3.56653,1.40963,-.92466,3.34812,1.13879,-.89694,3.72671,1.20458,-1.40922,3.69653,1.17215,-1.42512,3.67633,1.19548,-1.42393,3.68981,1.20601,-1.41589,3.65401,1.10777,-1.41635,3.63356,1.12433,-1.40916,3.57258,1.03384,-1.36105,3.44402,.96133,-1.08147,3.38388,.98928,-1.10942,3.42392,.97635,-1.20618,3.48793,.96271,-1.18526,3.69904,1.37802,-.85094,3.71822,1.32686,-.87043,3.72755,1.31433,-.88191,3.73786,1.31415,-.98158,3.48223,1.0194,-1.30825,3.5436,1.06224,-1.37242,3.53268,1.00752,-1.3067,3.94991,.94605,-1.00729,3.77021,1.17344,-1.49478,3.71579,1.15398,-1.44595,3.75547,1.19282,-1.4244,3.74144,1.13685,-1.50104,3.92442,1.1958,-1.08753,3.82807,1.25907,-.99083,3.9027,1.18096,-.98844,3.76847,1.29561,-.99186,3.94096,1.18163,-1.25599,3.70835,1.14075,-.24164,3.76331,1.08382,-.07922,3.73293,1.15365,-.24887,3.61913,1.36999,-.81647,3.67073,1.39324,-.83463,3.88419,1.16853,-.88939,3.89846,1.0915,-1.58952,3.87644,1.12479,-1.56498,3.94567,1.10123,-1.51389,4.02234,1.07307,-1.29201,3.89484,1.02149,-1.61376,3.53799,1.07435,-.47665,3.56562,1.12747,-.46281,3.4517,1.14012,-.59578,3.38554,1.13098,-.79112,3.52856,1.29813,-1.20455,3.58434,1.25654,-1.32853,3.59347,1.39224,-1.19678,3.53808,1.15942,-1.32621,3.43479,1.12184,-1.19675,3.46498,1.19307,-1.19584,3.33743,1.05022,-1.10419,3.34453,1.01414,-1.12494,3.36824,1.00909,-1.06791,3.36429,1.00215,-.97818,3.60982,1.00812,-.30461,3.66161,.9477,-.12104,3.78747,.87023,-1.19842,3.78823,.87468,-1.36343,3.68014,.89959,-.74806,3.76028,.86432,-.58905,3.69698,.88733,-.57165,3.75696,.88551,-.7387,3.96552,.81234,-.22914,3.80496,.83771,-.41912,3.87806,.85494,-.45962,3.89037,.78503,-.20938,3.93626,.94318,-.43517,3.83874,.86789,-.60532,3.92007,.96188,-.59042,3.92104,.95842,-.88919,3.81894,.89354,-.88519,3.7135,.95175,-1.5035,3.86535,1.10923,-1.58184};
			return value;
		}
		private double[] getlmet5_Coord_7_110_point_4()
		{
			double[] value = {3.76956,.99783,-1.58326,4.42609,.73212,.41167,4.51864,.67104,.69416,4.478,.6594,.8065,4.32895,.7898,.43412,4.30109,.81092,.55469,4.34905,.83544,.54135,4.39173,.81583,.45154,4.32003,.73385,.80363,4.32905,.79205,.65891,4.23627,.78714,.68458,3.91055,.68898,.48513,3.84421,.76058,.36318,3.72841,.86803,.12019,3.72692,.81916,.09564,3.87671,.68363,.3006,3.73581,.79749,.08195,3.7788,.75694,.04862,4.13492,.55435,.33864,4.19582,.50126,.38231,4.22064,.57463,.28557,4.05327,.76244,-.05992,3.98311,.70668,-.04648,4.35668,.63755,.35284,4.31262,.67737,.2944,4.31429,.75191,.3349,4.29761,.79487,.42001,4.24906,.81688,.37561,4.20028,.33448,.69672,4.15568,.35648,.68122,4.2255,.37504,.66053,4.24057,.32994,.68174,4.46639,.42959,.68064,4.45938,.44075,.55495,4.51559,.51108,.68701,4.50346,.52955,.58142,4.33719,.42464,.40797,4.46158,.57102,.44162,4.41401,.49161,.39992,4.3942,.51146,.37571,4.46384,.71908,.48591,4.47854,.64386,.46284,4.44108,.73118,.42869,4.38116,.53742,.3585,3.9433,.9814,.11855,3.99316,.97272,.08336,3.91948,1.07267,-.13073,3.85396,1.07732,-.10916,4.20647,.76015,.1697,4.08639,.83869,-.03816,4.2133,.80825,.19424,4.08109,.90731,-.00747,4.11193,.63775,.14992,4.16498,.69363,.14499,4.0032,.90128,-.22817,4.01359,.97632,-.20162,3.99821,.64444,.2253,3.89926,.71372,-.0069,4.03388,.63227,.20453,3.68825,1.00786,-.08099,3.77443,.91657,.15746,3.95836,.53445,.55259,4.0342,.4557,.58681,3.98264,.52166,.52488,3.91912,.8605,.37752,3.8741,.82249,.37662,4.15928,.39935,.82436,4.20171,.34712,.76426,4.24262,.39095,.82256,4.13558,.36327,.76029,4.20101,.80273,.6205,4.2313,.81786,.48147,4.15748,.8303,.52941,4.27089,.80777,.56268,4.37301,.68248,.86219,4.45086,.66081,.83003,3.8097,1.12715,-1.56767,3.82215,.88443,-.73982,3.90734,.95579,-.72476,3.73732,.86181,-.39468,3.81358,.79343,-.18639,3.78677,.88548,-1.45786,3.6939,.91301,-1.20975,3.68521,.91381,-.95589,3.57461,.93024,-.92296,3.57533,.93102,-.97482,3.56629,.93095,-.85995,3.50359,.93533,-.69585,3.45821,.93325,-.84315,3.58602,.91895,-.71004,3.37507,1.00734,-.89864,3.40572,.97737,-1.22257,3.39722,.99266,-1.22464,3.39967,1.03978,-1.20237,3.41716,1.228,-1.11191,3.48631,1.32865,-1.09453,3.64118,1.06611,-.25678,3.49747,1.2028,-.59837,3.8575,1.15435,-.34095,3.97751,1.05356,-.15758};
			return value;
		}
		private double[] getlmet5_Coord_7_110_point_5()
		{
			double[] value = {3.90774,1.10312,-.38615,3.80272,1.15576,-1.54156,3.61096,1.3987,-1.18765,3.63641,1.35471,-1.15583,3.59969,1.37104,-.81135,4.04293,.96404,.04817,3.71498,1.33788,-1.11049,3.68712,.91159,-1.08278,3.53137,1.08182,-1.36609,3.47202,1.03824,-1.30693,3.48973,1.06185,-1.31793,3.60731,1.14412,-1.41146,3.44428,.94185,-.97123,3.38696,.97671,-.97717,3.69798,1.08176,-1.50196,3.88194,.88936,-1.47305,3.7916,.91525,-1.52223,3.86093,.92477,-1.52786,3.86858,.97071,-1.59176,3.88867,.91985,-1.54084,3.45532,1.35281,-.95798,3.45436,1.35282,-.98368,3.5737,1.36098,-.80165,3.67099,1.08838,-1.43987,3.3408,1.00702,-1.09576,3.3549,.99449,-1.12516,3.915,1.08289,-1.59983,3.88575,1.02769,-1.61907,3.9668,1.05677,-.99691,4.18556,.67449,.80418,4.37451,.82892,.54223,4.12078,.45431,.77561,4.19881,.32843,.71499,4.1399,.35394,.6986,4.32655,.34252,.67565,4.22096,.46579,.87211,4.28263,.66407,.87052,4.24934,.71114,.83346,4.11831,.56744,.31624,4.11609,.50318,.69976,4.18562,.78083,.70301,4.12216,.43568,.79318,4.27111,.3813,.51096,4.28825,.36973,.50828,3.93754,.66405,.26295,4.00342,.61071,.39316,4.30912,.36513,.50022,4.19895,.69612,.80566,3.81646,.95077,.1631,3.85949,.98115,.16686,3.96515,.89467,.37656,4.03226,.85344,.48829,4.46298,.75957,.63318,3.839,.73533,.02086,3.71407,.82956,-.15713,3.68563,.87935,-.38026,3.76375,.81147,-.17176,3.63408,.89685,-.36585,4.48093,.59287,.83761,4.48043,.5045,.80206,4.50392,.59333,.81303,4.45904,.50697,.8276,4.37484,.37603,.74591,4.41424,.43854,.80898,4.35269,.38001,.77314,4.43412,.43198,.782,4.14393,.45205,.57378,4.10932,.50736,.53282,4.07303,.56495,.47072,4.13962,.37838,.64926,4.06507,.4568,.56231,4.1065,.56437,.39292,4.07555,.58786,.34409,4.35776,.39321,.4853,4.37663,.3757,.55806,4.44067,.46074,.4819,4.49468,.69594,.5587,4.51074,.61871,.52548,4.15719,.86841,.24163,4.18402,.83398,.41409,4.10329,.88126,.28318,3.96302,1.0916,-1.52368,3.97798,1.10616,-1.4313,3.99953,1.09694,-1.43811,3.85754,.96922,-1.59429,3.87805,.91485,-1.541,3.89987,.87845,-1.47655,3.39391,.97992,-.89904,3.76606,1.11051,-1.54895,3.54671,1.39698,-.89781,3.38584,1.25428,-1.01258,3.38516,1.25419,-.98677,3.54951,1.42819,-1.07497,3.5913,1.1595,-1.401,3.91067,.88308,-1.47632,4.00261,1.0848,-1.43913,3.95848,.9629,-1.45197,3.68252,.90791,-.87533,3.44962,.94082,-.90681,3.4118,1.23822,-.90179};
			return value;
		}
		private double[] getlmet5_Coord_7_110_point_6()
		{
			double[] value = {3.48291,1.33657,-.88413,3.69318,1.3515,-1.11576,3.76615,.88155,-1.07525,3.57489,.9258,-.53787,4.11761,.85084,.44956,4.04918,.89403,.32473,3.75114,.89262,-.88564,3.88364,1.14759,-.72684,3.94824,1.03701,-.43119,3.93216,1.05259,-.72773,3.89198,1.12436,-.55659,3.9353,1.04723,-.5889,3.36847,1.12116,-1.10728,3.9318,1.05497,-.88053,3.51729,1.31892,-.79762,3.44348,1.21919,-.80525,3.63575,.90652,-.55475,3.74964,.89648,-.95216,4.37527,.59118,.88396,4.29203,.45147,.86219,4.35265,.52858,.88253,4.09085,.82791,.56153,4.26807,.614,.28271,4.49145,.55091,.50844,4.50875,.68335,.61226,4.5325,.6042,.59376,4.38243,.36698,.67648,4.54462,.59461,.69143,4.10907,.40998,.60842,4.4537,.77066,.60269};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfdphal_Geo_6_115_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,8,9,6,-1,10,3,5,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,22,23,20,-1,24,25,26,-1,27,17,24,-1,28,29,30,-1,31,32,33,-1,32,34,33,-1,31,33,35,-1,36,37,38,-1,39,36,38,-1,40,36,41,-1,42,43,44,-1,45,46,44,-1,47,48,49,-1,50,51,52,-1,53,54,55,-1,53,56,54,-1,57,58,59,-1,60,61,62,-1,61,63,62,-1,64,58,65,-1,7,66,64,-1,64,65,7,-1,67,68,1,-1,47,56,69,-1,48,70,71,-1,72,73,74,-1,75,76,77,-1,75,78,63,-1,79,26,25,-1,79,80,26,-1,29,81,82,-1,83,84,85,-1,81,86,87,-1,81,88,86,-1,47,89,48,-1,12,8,90,-1,55,51,50,-1,50,91,55,-1,48,92,49,-1,48,87,92,-1,93,52,94,-1,93,50,52,-1,95,35,29,-1,35,33,29,-1,96,97,98,-1,98,99,96,-1,68,100,101,-1,100,68,102,-1,36,40,37,-1,7,77,76,-1,58,57,103,-1,39,58,104,-1,41,2,105,-1,41,104,2,-1,103,106,107,-1,103,78,106,-1,89,69,108,-1,89,47,69,-1,106,109,107,-1,109,110,107,-1,110,0,2,-1,67,111,112,-1,113,112,111,-1,113,114,112,-1,115,116,117,-1,117,118,115,-1,119,120,121,-1,11,13,14,-1,122,123,124,-1,13,90,85,-1,85,125,13,-1,125,126,127,-1,125,128,126,-1,129,130,21,-1,131,132,133,-1,131,134,132,-1,24,133,27,-1,5,131,10,-1,5,134,131,-1,7,135,77,-1,7,6,135,-1,135,136,137,-1,135,6,136,-1,138,139,140,-1,138,141,139,-1,18,142,138,-1,138,143,18,-1,144,122,145,-1,142,146,138,-1,146,141,138,-1,136,6,9,-1,4,147,148,-1,147,149,148,-1,8,12,9,-1,3,150,71,-1,3,10,150,-1,142,151,146,-1,82,10,80,-1,82,150,10,-1,83,90,8,-1,83,85,90,-1,152,153,16,-1,121,154,155,-1,121,120,154,-1,118,156,115,-1,118,121,156,-1,111,67,157,-1,158,159,160,-1,160,109,158,-1,72,161,73,-1,69,162,72,-1,72,108,69,-1,163,164,162,-1,162,91,163,-1,104,58,107,-1,58,103,107,-1,41,36,104,-1,77,165,75,-1,77,70,165,-1,8,65,58,-1,58,64,59,-1,166,167,37,-1,166,100,167,-1,100,102,167,-1,40,100,166,-1,166,37,40,-1,40,101,100,-1,2,1,105,-1,97,168,98,-1,31,44,32,-1,33,94,169,-1,88,81,169,-1,88,52,170,-1,53,69,56,-1,132,27,133,-1,58,39,8,-1,86,88,170,-1,130,171,21,-1,172,167,173,-1,75,61,174,-1,62,103,57,-1,7,65,8,-1,89,165,48,-1,165,70,48,-1,30,29,82,-1,13,12,90,-1,120,175,154,-1,120,176,175,-1,157,160,177,-1,157,0,160,-1,66,7,76,-1,76,174,66,-1,76,75,174,-1,59,62,57,-1,59,60,62,-1,61,75,63,-1,54,56,47,-1,47,49,54,-1,92,87,86,-1,55,91,53,-1,46,42,44,-1,43,32,44,-1,39,104,36,-1,38,8,39,-1,22,21,126,-1,24,178,25,-1,17,178,24,-1,143,144,129,-1,171,130,145,-1,11,153,179,-1,179,12,11,-1,144,140,122,-1,137,4,3,-1,137,147,4,-1,12,179,9,-1,99,102,112,-1,121,118,119,-1,132,148,151,-1,134,148,132,-1,147,136,180,-1,136,147,137,-1,123,140,139,-1,122,140,123,-1,11,16,153,-1,14,16,11,-1,143,19,18,-1,19,143,129,-1,140,143,138,-1,144,143,140,-1,18,27,142,-1,18,17,27,-1,181,25,23,-1,79,25,181,-1,45,31,182,-1,44,31,45,-1,183,184,128,-1,185,184,183,-1,95,186,35,-1,95,187,186,-1,98,173,167,-1,168,173,98,-1,92,170,188,-1,92,86,170,-1,68,105,1,-1,68,101,105,-1,159,177,160,-1,159,189,177,-1,114,175,96,-1,175,114,154,-1,190,191,192,-1,190,119,191,-1,163,116,164,-1,163,117,116,-1,156,161,115,-1,73,161,156,-1,114,99,112,-1,114,96,99,-1,34,43,176,-1,32,43,34,-1,92,54,49,-1,92,188,54,-1,193,89,108,-1,193,165,89,-1,60,64,66,-1,60,59,64,-1,145,124,171,-1,124,145,122,-1,88,94,52,-1,169,94,88,-1,55,188,51,-1,188,55,54,-1,93,176,190,-1,176,93,34,-1,81,33,169,-1,81,29,33,-1,45,96,46,-1,96,45,97,-1,187,173,186,-1,84,173,187,-1,172,8,38,-1,172,83,8,-1};
			return value;
		}
		private int[] getlfdphal_Geo_6_115_coordIndex_2()
		{
			int[] value = {66,61,60,-1,66,174,61,-1,162,53,91,-1,53,162,69,-1,158,193,74,-1,194,193,158,-1,162,161,72,-1,162,164,161,-1,159,74,73,-1,74,159,158,-1,114,155,154,-1,155,114,113,-1,189,121,155,-1,189,156,121,-1,195,14,13,-1,15,14,195,-1,28,95,29,-1,28,185,95,-1,195,171,124,-1,171,195,127,-1,84,183,85,-1,84,187,183,-1,10,26,80,-1,10,131,26,-1,150,48,71,-1,150,87,48,-1,3,135,137,-1,71,135,3,-1,149,151,148,-1,151,149,146,-1,152,179,153,-1,180,179,152,-1,152,146,149,-1,152,141,146,-1,16,141,152,-1,16,139,141,-1,149,180,152,-1,149,147,180,-1,77,71,70,-1,77,135,71,-1,131,24,26,-1,131,133,24,-1,150,81,87,-1,81,150,82,-1,21,127,126,-1,21,171,127,-1,128,85,183,-1,85,128,125,-1,127,13,125,-1,127,195,13,-1,181,185,28,-1,181,184,185,-1,184,23,22,-1,184,181,23,-1,124,15,195,-1,15,124,123,-1,191,118,117,-1,191,119,118,-1,177,155,113,-1,177,189,155,-1,113,157,177,-1,111,157,113,-1,0,109,160,-1,0,110,109,-1,107,2,104,-1,107,110,2,-1,109,194,158,-1,194,109,106,-1,194,165,193,-1,75,165,194,-1,63,103,62,-1,63,78,103,-1,37,172,38,-1,37,167,172,-1,43,175,176,-1,43,42,175,-1,94,34,93,-1,33,34,94,-1,190,50,93,-1,190,192,50,-1,163,50,192,-1,163,91,50,-1,84,172,173,-1,172,84,83,-1,30,80,79,-1,30,82,80,-1,106,75,194,-1,106,78,75,-1,74,108,72,-1,74,193,108,-1,175,46,96,-1,42,46,175,-1,67,102,68,-1,112,102,67,-1,116,161,164,-1,161,116,115,-1,192,117,163,-1,192,191,117,-1,120,190,176,-1,190,120,119,-1,157,1,0,-1,1,157,67,-1,189,73,156,-1,159,73,189,-1,170,51,188,-1,51,170,52,-1,102,98,167,-1,98,102,99,-1,186,168,182,-1,168,186,173,-1,105,40,41,-1,105,101,40,-1,182,35,186,-1,182,31,35,-1,185,187,95,-1,185,183,187,-1,22,128,184,-1,22,126,128,-1,182,97,45,-1,182,168,97,-1,28,79,181,-1,30,79,28,-1,178,19,20,-1,19,178,17,-1,178,23,25,-1,178,20,23,-1,20,129,21,-1,19,129,20,-1,144,130,129,-1,144,145,130,-1,16,123,139,-1,123,16,15,-1,180,9,179,-1,9,180,136,-1,27,151,142,-1,132,151,27,-1,134,4,148,-1,5,4,134,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfdphal_Coord_7_115_point_1()
		{
			double[] value = {2.4465,.13079,2.94363,2.52526,.16426,2.92459,2.53596,.13913,2.94032,2.45414,.06955,3.51491,2.46685,.06674,3.52491,2.45779,.07478,3.52595,2.5312,.10615,3.43581,2.52337,.08654,3.35936,2.55579,.14555,3.32535,2.56889,.13841,3.41763,2.44151,.10878,3.53116,2.63751,.14234,3.43596,2.58789,.15399,3.40478,2.57881,.1823,3.42706,2.64783,.15543,3.46553,2.65122,.16277,3.48915,2.64822,.1455,3.48394,2.57109,.12903,3.69759,2.58827,.12655,3.70263,2.58491,.14889,3.70553,2.54977,.20077,3.67328,2.58419,.2246,3.6628,2.53021,.23511,3.59837,2.49873,.2059,3.60397,2.53134,.13184,3.63553,2.4857,.1807,3.5991,2.48438,.14767,3.58781,2.56325,.09187,3.66041,2.42498,.19947,3.45432,2.36238,.18883,3.35147,2.41386,.17568,3.46569,2.37029,.30994,3.18348,2.34825,.35231,3.14136,2.28028,.23236,3.22792,2.21928,.26876,3.15304,2.3844,.29125,3.21306,2.59851,.13796,3.16624,2.5896,.18051,3.07695,2.57729,.14642,3.20446,2.58681,.12779,3.21568,2.61979,.14937,3.07273,2.61911,.13974,3.07454,2.35043,.3577,3.12896,2.34439,.35417,3.13747,2.35628,.35353,3.13797,2.36803,.35363,3.13683,2.36258,.35574,3.13246,2.21861,.01094,3.29466,2.33067,.04584,3.37943,2.22599,.02529,3.31862,2.0571,.11536,3.15527,2.11347,.07753,3.23301,2.12907,.0924,3.24631,2.1239,.03909,3.21688,2.12974,.02879,3.27993,2.11377,.05388,3.22277,2.14004,.0198,3.26655,2.57292,.05799,3.28304,2.59874,.0651,3.22042,2.57495,.06346,3.28982,2.53305,.05199,3.33193,2.464,.0363,3.30839,2.53478,.04596,3.32297,2.46543,.0323,3.29946,2.57175,.07164,3.29348,2.56605,.09293,3.30284,2.52583,.07086,3.34035,2.51809,.17851,2.92499,2.53208,.17778,2.9265,2.17028,.00166,3.19256,2.38802,.04367,3.3669,2.42689,.07651,3.47943,2.20121,.07017,3.06231,2.22126,.11682,2.98664,2.25931,.0763,3.05011,2.41174,.02953,3.23328,2.45477,.04776,3.32784,2.44736,.04205,3.3539,2.46366,.03297,3.22623,2.45071,.18673,3.53672,2.44606,.15504,3.53459,2.32179,.12811,3.38112,2.40968,.14701,3.47329,2.50849,.21576,3.30293,2.47733,.23551,3.30588,2.52319,.21185,3.4042,2.21719,.07229,3.32184,2.31224,.0761,3.39613,2.1936,.09595,3.28248,2.3053,.01687,3.26677,2.57223,.17363,3.40488,2.06243,.06677,3.12442,2.22597,.04965,3.33055,2.13339,.19604,3.16119,2.20641,.16587,3.23301,2.42312,.25287,3.318,2.42022,.32861,3.04347,2.43411,.32531,3.11393,2.49972,.25687,3.07591,2.50502,.26207,2.9912};
			return value;
		}
		private double[] getlfdphal_Coord_7_115_point_2()
		{
			double[] value = {2.55461,.20224,2.94443,2.55371,.17002,2.9305,2.51714,.24762,2.97921,2.52652,.04014,3.21914,2.57342,.11403,3.07783,2.55016,.15681,2.92969,2.43873,.05247,3.122,2.49889,.0887,3.11571,2.26188,.02655,3.1604,2.39745,.09114,3.01803,2.47225,.12106,2.9972,2.4764,.19801,2.96287,2.50598,.24637,2.97697,2.39584,.21776,3.00587,2.41076,.31577,3.02726,2.1267,.09745,2.99618,2.08826,.06765,3.0154,2.04387,.08464,3.05485,2.11431,.14801,3.0497,2.10024,.20792,3.10079,2.17483,.29636,3.08172,2.19495,.21106,3.04136,2.67184,.16278,3.63413,2.66823,.15716,3.572,2.65315,.17645,3.59553,2.53862,.22016,3.46363,2.54579,.2398,3.59159,2.58411,.23069,3.57003,2.5031,.24638,3.50135,2.60946,.17039,3.69323,2.62646,.2124,3.67308,2.4749,.09986,3.57505,2.50763,.05953,3.62128,2.52252,.08604,3.62849,2.47617,.05365,3.56038,2.48462,.06416,3.45478,2.54085,.11311,3.48407,2.49964,.06179,3.50868,2.63466,.10591,3.64908,2.66515,.13738,3.5726,2.66804,.14225,3.63103,2.60722,.0984,3.58255,2.58475,.08692,3.66293,2.62445,.1534,3.68834,2.63576,.16747,3.68325,2.64646,.19901,3.66764,2.53612,.05324,3.60885,2.5043,.05699,3.52458,2.48611,.04326,3.55601,2.51307,.05193,3.55225,2.40472,.10429,3.48442,2.51841,.04776,3.61532,2.58305,.10131,3.52894,2.6335,.1236,3.44906,2.30374,.33969,3.04211,2.30017,.242,3.02733,2.21211,.13517,2.98421,2.44327,.14856,2.94215,2.31757,.0824,3.03791,2.2851,.12046,2.96849,2.36216,.10982,2.95697,2.13518,.08313,2.99835,2.11568,.01515,3.08325,2.04188,.06749,3.06551,2.09012,.05131,3.01885,2.35801,.02305,3.25013,2.58708,.18385,3.0621,2.52345,.23039,3.09635,2.43792,.29322,3.15965,2.2306,.15851,3.25874,2.13979,.06804,3.29059,2.61929,.22117,3.63366,2.51554,.22077,3.18729,2.44526,.27394,3.19693,2.46087,.0445,3.31204,2.30823,.35461,3.05843,2.17951,.30265,3.0984,2.35885,.12822,2.95234,2.53773,.17394,3.66517,2.58514,.14321,3.41786,2.55243,.11583,3.49475,2.46145,.21274,3.53111,2.39446,.31321,3.1738,2.47705,.23469,3.42125,2.48362,.24121,3.51413,2.45464,.23028,3.42963,2.40866,.29333,3.20405,2.44642,.25564,3.30992,2.12888,.04715,3.29107,2.28182,.13906,2.96433,2.10137,.21113,3.12136,2.04152,.13235,3.09614,2.03583,.12371,3.1181,2.31537,.03804,3.14842,2.36896,.04951,3.13645,2.61904,.19558,3.53644};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfdphal2_Geo_6_120_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,11,2,9,-1,12,13,14,-1,1,15,6,-1,15,16,6,-1,17,18,19,-1,3,6,16,-1,20,21,22,-1,20,23,21,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,30,37,-1,28,27,38,-1,39,40,22,-1,22,41,39,-1,32,42,30,-1,43,17,44,-1,43,18,17,-1,1,6,8,-1,45,16,46,-1,45,47,16,-1,48,49,50,-1,48,51,49,-1,52,53,54,-1,2,11,0,-1,15,55,16,-1,43,44,56,-1,56,57,43,-1,58,59,60,-1,58,61,59,-1,62,27,29,-1,51,24,63,-1,64,32,33,-1,48,65,24,-1,66,67,68,-1,67,69,68,-1,70,71,12,-1,70,72,71,-1,73,74,75,-1,75,76,73,-1,75,77,78,-1,78,76,75,-1,79,80,81,-1,80,82,81,-1,83,84,85,-1,85,86,83,-1,87,88,21,-1,21,23,87,-1,89,90,91,-1,74,73,67,-1,73,69,67,-1,92,93,94,-1,30,42,95,-1,64,33,35,-1,63,24,26,-1,57,56,53,-1,53,52,57,-1,96,17,19,-1,55,46,16,-1,8,2,1,-1,96,97,98,-1,96,99,97,-1,11,100,14,-1,40,94,93,-1,40,101,94,-1,102,103,104,-1,102,105,103,-1,26,27,62,-1,106,48,50,-1,107,108,57,-1,57,52,107,-1,4,3,54,-1,57,108,43,-1,108,18,43,-1,109,110,10,-1,10,9,109,-1,6,5,7,-1,6,3,5,-1,28,111,61,-1,65,112,113,-1,65,114,112,-1,115,37,59,-1,34,33,116,-1,117,118,34,-1,32,31,33,-1,95,37,30,-1,26,25,27,-1,51,48,24,-1,64,67,66,-1,66,32,64,-1,51,63,119,-1,63,120,119,-1,29,121,62,-1,29,122,121,-1,123,83,124,-1,83,103,124,-1,70,69,72,-1,69,73,72,-1,19,18,125,-1,18,108,125,-1,1,0,15,-1,0,126,15,-1,10,127,100,-1,100,11,10,-1,39,100,127,-1,110,109,128,-1,128,129,110,-1,101,110,129,-1,14,0,11,-1,109,4,128,-1,5,4,109,-1,47,3,16,-1,47,107,3,-1,69,41,68,-1,41,69,70,-1,76,72,73,-1,76,89,72,-1,130,90,78,-1,90,130,131,-1,105,132,133,-1,105,134,132,-1,84,123,135,-1,83,123,84,-1,103,133,124,-1,103,105,133,-1,58,136,137,-1,60,136,58,-1,63,138,120,-1,26,138,63,-1,75,49,77,-1,49,75,139,-1,42,66,88,-1,32,66,42,-1,138,62,121,-1,26,62,138,-1,139,74,35,-1,139,75,74,-1,95,88,87,-1,95,42,88,-1,140,36,141,-1,36,140,142,-1,117,116,143,-1,116,117,34,-1,38,111,28,-1,38,144,111,-1,116,31,142,-1,116,33,31,-1,48,114,65,-1,48,106,114,-1,113,144,38,-1,113,112,144,-1,144,115,111,-1,115,144,141,-1,9,5,109,-1,7,5,9,-1,127,110,101,-1,10,110,127,-1,107,54,3,-1,54,107,52,-1,79,145,146,-1,79,147,145,-1,131,91,90,-1,131,80,91,-1,138,124,133,-1,138,121,124,-1,148,102,104,-1,149,102,148,-1,129,94,101,-1,129,150,94,-1,60,37,95,-1,59,37,60,-1,150,151,94,-1,151,150,152,-1,153,126,13,-1,153,154,126,-1,79,97,147,-1,79,81,97,-1,155,148,156,-1,155,157,148,-1,98,17,96,-1,157,17,98,-1,147,99,45,-1,99,147,97,-1,145,55,154,-1,55,145,46,-1,125,45,99,-1,125,47,45,-1,99,19,125,-1,96,19,99,-1,152,53,56,-1,53,152,150,-1,34,139,35,-1,34,118,139,-1,38,25,113,-1,38,27,25,-1,143,106,117,-1,143,114,106,-1,112,141,144,-1,141,112,140,-1,92,84,158,-1,92,85,84,-1,40,20,22,-1,20,40,93,-1,91,153,71,-1,91,146,153,-1,23,136,87,-1,23,159,136,-1,12,100,39,-1,12,14,100,-1,151,86,85,-1,151,156,86,-1,135,122,137,-1,135,123,122,-1,83,104,103,-1,83,86,104,-1,120,133,132,-1,138,133,120,-1,149,82,102,-1,149,81,82,-1,82,131,134,-1,80,131,82,-1,120,130,119,-1,120,132,130,-1,102,134,105,-1,102,82,134,-1,156,104,86,-1,148,104,156,-1,121,123,124,-1,123,121,122,-1,85,94,151,-1,94,85,92,-1,137,159,135,-1,137,136,159,-1,71,89,91,-1,71,72,89,-1,71,13,12,-1,71,153,13,-1,39,70,12,-1,41,70,39,-1,93,158,20,-1,92,158,93,-1,140,114,143,-1,140,112,114,-1,117,50,118,-1,50,117,106,-1};
			return value;
		}
		private int[] getlfdphal2_Geo_6_120_coordIndex_2()
		{
			int[] value = {24,113,25,-1,24,65,113,-1,118,49,139,-1,118,50,49,-1,28,58,29,-1,28,61,58,-1,155,56,44,-1,155,152,56,-1,128,54,53,-1,128,4,54,-1,154,15,126,-1,15,154,55,-1,53,129,128,-1,53,150,129,-1,157,44,17,-1,155,44,157,-1,98,81,149,-1,98,97,81,-1,146,154,153,-1,146,145,154,-1,152,156,151,-1,156,152,155,-1,157,149,148,-1,98,149,157,-1,78,119,130,-1,119,78,77,-1,80,146,91,-1,80,79,146,-1,46,147,45,-1,147,46,145,-1,68,88,66,-1,68,21,88,-1,39,101,40,-1,127,101,39,-1,111,59,61,-1,115,59,111,-1,30,142,31,-1,142,30,36,-1,142,143,116,-1,142,140,143,-1,115,36,37,-1,115,141,36,-1,29,137,122,-1,29,58,137,-1,67,35,74,-1,35,67,64,-1,119,49,51,-1,77,49,119,-1,60,87,136,-1,95,87,60,-1,158,135,159,-1,84,135,158,-1,134,130,132,-1,131,130,134,-1,78,89,76,-1,89,78,90,-1,41,21,68,-1,22,21,41,-1,20,159,23,-1,158,159,20,-1,107,125,108,-1,107,47,125,-1,0,13,126,-1,14,13,0,-1,2,7,9,-1,8,7,2,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfdphal2_Coord_7_120_point_1()
		{
			double[] value = {3.32998,.08492,3.67423,3.33807,.04825,3.73894,3.30483,.05964,3.73979,3.36532,.0312,3.7946,3.32435,.06516,3.78822,3.31503,.05541,3.78266,3.36104,.02388,3.78908,3.31034,.04179,3.7632,3.31334,.04067,3.75713,3.2999,.06437,3.74339,3.31487,.10605,3.67922,3.31757,.09875,3.67754,3.27403,.10057,3.56963,3.31535,.08232,3.61959,3.31196,.09139,3.62315,3.34775,.03997,3.73356,3.36645,.01746,3.78768,3.50283,.10696,3.70555,3.48196,.09116,3.75316,3.48632,.07885,3.73946,3.25655,.22853,3.54973,3.19082,.16076,3.53123,3.21099,.15896,3.54791,3.24211,.23854,3.52456,3.42552,.09188,3.43961,3.43426,.11208,3.44093,3.47118,.11018,3.43395,3.43309,.14369,3.44185,3.40601,.17142,3.44017,3.4519,.18125,3.42862,3.25548,.15809,3.47837,3.24802,.12703,3.48688,3.18129,.13279,3.50431,3.24628,.10293,3.47995,3.26388,.08008,3.46303,3.224,.06356,3.46425,3.27516,.15599,3.474,3.27648,.18287,3.46537,3.39825,.14518,3.45018,3.26928,.1252,3.58,3.27006,.15326,3.58835,3.20805,.13339,3.5446,3.18587,.15573,3.5046,3.47914,.11689,3.76219,3.48934,.14289,3.71363,3.42378,.00573,3.71141,3.37555,0.0,3.71753,3.40353,.0324,3.78216,3.38344,.0723,3.43566,3.33076,.03296,3.42239,3.34194,.05726,3.4343,3.40324,.04841,3.4277,3.38688,.10018,3.77997,3.36576,.15165,3.74365,3.36408,.0918,3.78301,3.35065,.01777,3.72723,3.44526,.16761,3.73115,3.44482,.12222,3.77489,3.37575,.22723,3.42578,3.31785,.19994,3.44435,3.30141,.22792,3.44108,3.36659,.19938,3.43926,3.4824,.14192,3.43365,3.45042,.08196,3.43544,3.17759,.10847,3.50253,3.38596,.09403,3.44714,3.17814,.13187,3.51603,3.17654,.10628,3.51224,3.18611,.13438,3.53017,3.18914,.10636,3.52229,3.21139,.10563,3.5351,3.29197,.06345,3.55252,3.24963,.05157,3.4996,3.23497,.04854,3.48195,3.227,.05505,3.47116,3.27412,.02076,3.44475,3.28536,.02072,3.45702,3.33609,.01227,3.42998,3.33992,.01052,3.44526,3.40548,.04707,3.58988,3.40332,.04504,3.53021,3.43622,.07521,3.58694,3.44632,.07038,3.52876,3.47802,.19569,3.51123,3.40676,.24474,3.52484,3.40416,.21,3.56768,3.4577,.18831,3.55003,3.21832,.22892,3.50162,3.18472,.15923,3.51872,3.2964,.02556,3.47793,3.34385,.01508,3.46756,3.35175,.03772,3.52878,3.33804,.20657,3.58006,3.30407,.19718,3.58668,3.34603,.17855,3.63083,3.21724,.21265,3.48299,3.4971,.06929,3.70594,3.44421,.06424,3.65045,3.46216,.09239,3.64953,3.46326,.03234,3.71253};
			return value;
		}
		private double[] getlfdphal2_Coord_7_120_point_2()
		{
			double[] value = {3.30506,.10899,3.62928,3.30453,.14192,3.636,3.46285,.10407,3.53825,3.49932,.13388,3.49758,3.4703,.14302,3.5453,3.48602,.09852,3.49124,3.3439,.07489,3.44308,3.3989,.04568,3.78988,3.44013,.0688,3.7757,3.29566,.09079,3.75075,3.31609,.12266,3.68296,3.36071,.17672,3.44815,3.34838,.1194,3.46323,3.39134,.11573,3.45224,3.3461,.09628,3.45299,3.3158,.17823,3.45364,3.26909,.10152,3.47323,3.29936,.07561,3.4535,3.29271,.05981,3.44752,3.40482,.02989,3.43605,3.46658,.0653,3.44469,3.50485,.13962,3.44762,3.47293,.19636,3.44112,3.47791,.20404,3.48339,3.507,.13752,3.47171,3.43807,.05109,3.76842,3.3365,.07102,3.66911,3.3037,.11675,3.63133,3.30253,.10495,3.75491,3.32141,.13009,3.68277,3.40962,.0284,3.45394,3.40788,.03067,3.4778,3.46797,.06288,3.46258,3.49206,.09802,3.46675,3.46301,.06386,3.48597,3.40279,.25275,3.49588,3.30514,.24715,3.45662,3.38602,.24417,3.43852,3.4903,.10028,3.44576,3.2721,.03355,3.43476,3.3093,.12252,3.47158,3.31403,.15173,3.46666,3.27225,.1253,3.48054,3.30681,.09906,3.46251,3.35395,.14936,3.46001,3.37378,.02614,3.6442,3.36451,.03692,3.59222,3.41377,.03481,3.64318,3.46485,.13447,3.59677,3.45518,.10288,3.59123,3.35875,.15879,3.67519,3.41272,.18917,3.62006,3.42163,.17321,3.66884,3.32405,.05786,3.60869,3.33895,.04546,3.6567,3.45994,.15688,3.65733,3.45364,.16917,3.60382,3.47081,.12445,3.64984,3.32999,.24947,3.53437,3.32219,.25763,3.50579};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfdphal3_Geo_6_125_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,0,7,-1,8,9,10,-1,11,4,12,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,24,-1,31,22,21,-1,24,23,32,-1,33,34,9,-1,34,10,9,-1,35,2,12,-1,36,37,38,-1,39,40,14,-1,14,41,39,-1,42,43,44,-1,45,46,47,-1,46,48,47,-1,49,37,50,-1,49,51,37,-1,2,52,0,-1,11,53,54,-1,51,55,8,-1,8,56,51,-1,57,34,33,-1,57,58,34,-1,20,59,21,-1,60,40,18,-1,27,61,23,-1,18,39,62,-1,63,64,65,-1,64,66,65,-1,67,68,69,-1,67,70,68,-1,15,71,72,-1,15,73,71,-1,74,75,76,-1,76,77,74,-1,75,78,79,-1,79,76,75,-1,80,81,82,-1,81,83,82,-1,84,85,86,-1,84,87,85,-1,88,46,84,-1,88,48,46,-1,89,90,91,-1,68,71,69,-1,68,72,71,-1,48,88,63,-1,92,24,32,-1,26,61,27,-1,17,60,18,-1,8,55,9,-1,11,54,36,-1,2,35,52,-1,54,53,93,-1,53,94,93,-1,55,51,49,-1,49,95,55,-1,65,96,48,-1,48,63,65,-1,59,17,21,-1,41,97,39,-1,89,78,98,-1,89,79,78,-1,58,99,100,-1,58,43,99,-1,42,5,4,-1,34,58,100,-1,34,100,10,-1,101,12,3,-1,12,4,3,-1,102,22,103,-1,104,105,29,-1,106,28,27,-1,28,107,108,-1,29,105,109,-1,109,30,29,-1,27,23,25,-1,24,92,29,-1,21,17,19,-1,18,40,39,-1,16,14,40,-1,40,110,16,-1,59,20,82,-1,20,80,82,-1,92,111,112,-1,112,113,92,-1,83,85,114,-1,83,81,85,-1,56,8,10,-1,10,100,56,-1,53,2,94,-1,2,1,94,-1,1,115,94,-1,0,52,116,-1,116,7,0,-1,35,12,101,-1,117,96,118,-1,38,11,36,-1,119,5,120,-1,119,3,5,-1,101,52,35,-1,52,101,116,-1,12,53,11,-1,12,2,53,-1,38,4,11,-1,38,99,4,-1,66,121,122,-1,66,64,121,-1,69,123,67,-1,124,123,69,-1,73,125,71,-1,73,90,125,-1,126,127,128,-1,126,91,127,-1,129,130,131,-1,130,129,132,-1,86,81,133,-1,86,85,81,-1,114,131,83,-1,131,114,129,-1,134,112,135,-1,134,113,112,-1,60,136,137,-1,60,17,136,-1,138,23,70,-1,32,23,138,-1,17,82,136,-1,17,59,82,-1,13,72,26,-1,72,13,15,-1,138,92,32,-1,111,92,138,-1,109,139,30,-1,139,109,140,-1,28,141,107,-1,28,106,141,-1,31,103,22,-1,103,31,142,-1,139,27,25,-1,139,106,27,-1,97,62,39,-1,62,97,143,-1,144,142,31,-1,144,145,142,-1,142,105,103,-1,109,105,142,-1,116,3,119,-1,116,101,3,-1,6,118,96,-1,6,7,118,-1,65,123,146,-1,123,65,66,-1,99,42,4,-1,43,42,99,-1,147,78,50,-1,98,78,147,-1,126,89,91,-1,126,79,89,-1,136,83,131,-1,83,136,82,-1,148,74,77,-1,149,74,148,-1,117,48,96,-1,48,117,47,-1,113,29,92,-1,113,104,29,-1,150,94,115,-1,94,150,93,-1,50,75,49,-1,50,78,75,-1,151,149,152,-1,149,151,153,-1,95,9,55,-1,95,153,9,-1,147,54,93,-1,36,54,147,-1,51,38,37,-1,51,56,38,-1,45,44,57,-1,47,44,45,-1,102,113,134,-1,113,102,104,-1,26,108,13,-1,26,28,108,-1,144,21,19,-1,144,31,21,-1,107,143,97,-1,107,141,143,-1,140,142,145,-1,140,109,142,-1,88,86,154,-1,86,88,84,-1,125,155,124,-1,155,125,156,-1,89,150,156,-1,150,89,98,-1,16,73,15,-1,73,16,127,-1,121,112,111,-1,121,157,112,-1,6,155,115,-1,6,146,155,-1,46,87,84,-1,46,152,87,-1,135,81,80,-1,135,133,81,-1,85,148,114,-1,85,87,148,-1,137,131,130,-1,137,136,131,-1,76,126,132,-1,76,79,126,-1,130,110,137,-1,128,110,130,-1,77,132,129,-1,132,77,76,-1,152,148,87,-1,152,149,148,-1,157,135,112,-1,157,133,135,-1,111,122,121,-1,122,111,138,-1,156,90,89,-1,90,156,125,-1,156,115,155,-1,115,156,150,-1,124,146,123,-1,146,124,155,-1,63,154,64,-1,63,88,154,-1,141,145,143,-1,141,140,145,-1,108,97,41,-1,97,108,107,-1,18,144,19,-1,144,18,62,-1,108,14,13,-1,14,108,41,-1,22,134,20,-1,134,22,102,-1,43,57,44,-1,43,58,57,-1};
			return value;
		}
		private int[] getlfdphal3_Geo_6_125_coordIndex_2()
		{
			int[] value = {151,57,33,-1,151,45,57,-1,120,42,44,-1,120,5,42,-1,44,117,120,-1,117,44,47,-1,153,33,9,-1,153,151,33,-1,74,49,75,-1,74,95,49,-1,98,93,150,-1,93,98,147,-1,115,0,6,-1,115,1,0,-1,45,152,46,-1,151,152,45,-1,74,153,95,-1,153,74,149,-1,77,114,148,-1,77,129,114,-1,127,110,128,-1,16,110,127,-1,36,50,37,-1,147,50,36,-1,67,138,70,-1,67,122,138,-1,96,146,6,-1,146,96,65,-1,7,119,118,-1,7,116,119,-1,103,104,102,-1,103,105,104,-1,144,143,145,-1,144,62,143,-1,25,30,139,-1,30,25,24,-1,106,140,141,-1,106,139,140,-1,61,70,23,-1,70,61,68,-1,40,137,110,-1,40,60,137,-1,20,135,80,-1,20,134,135,-1,68,26,72,-1,61,26,68,-1,154,133,157,-1,154,86,133,-1,132,128,130,-1,132,126,128,-1,127,90,73,-1,91,90,127,-1,71,124,69,-1,125,124,71,-1,123,122,67,-1,123,66,122,-1,64,157,121,-1,64,154,157,-1,99,56,100,-1,56,99,38,-1,120,118,119,-1,120,117,118,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfdphal3_Coord_7_125_point_1()
		{
			double[] value = {3.81096,.14349,3.23897,3.8113,.12021,3.23268,3.82482,.09214,3.27808,3.82816,.10595,3.32179,3.86882,.07822,3.3334,3.83677,.11491,3.32766,3.79628,.15294,3.21001,3.81038,.14925,3.24043,3.95122,.11639,3.28023,3.95152,.14308,3.24714,3.95329,.12876,3.2942,3.8679,.06455,3.32615,3.86392,.07134,3.32767,3.75828,.07177,3.02946,3.80026,.06751,3.01662,3.76036,.05876,3.03926,3.80642,.04641,3.02387,3.89803,.13561,3.01995,3.85866,.12057,3.02325,3.86442,.13988,3.02692,3.89012,.20685,3.02767,3.86456,.17073,3.03624,3.84829,.19958,3.04249,3.69881,.17731,3.07098,3.74787,.19679,3.0674,3.74016,.16684,3.06887,3.72231,.10511,3.04883,3.73744,.14303,3.06203,3.74835,.11876,3.05282,3.76436,.21929,3.06717,3.75934,.19303,3.06989,3.83692,.17405,3.04991,3.70504,.1996,3.07415,3.94539,.17967,3.25603,3.95571,.15427,3.30386,3.82036,.0918,3.29591,3.85492,.04738,3.25566,3.89063,.04933,3.24997,3.89652,.07674,3.32122,3.82946,.10333,3.02674,3.84945,.07844,3.01656,3.80255,.09086,3.02866,3.86779,.14058,3.32768,3.88474,.14724,3.32499,3.85909,.19796,3.28552,3.88476,.20948,3.23272,3.87149,.22077,3.20228,3.841,.19984,3.23835,3.82823,.21492,3.21239,3.88976,.10018,3.21175,3.86622,.07338,3.20355,3.92167,.07251,3.25201,3.81059,.11134,3.27901,3.82741,.08387,3.27244,3.83842,.06689,3.26566,3.94666,.10629,3.24655,3.9207,.09271,3.30816,3.91729,.2076,3.27389,3.93035,.16239,3.31646,3.90961,.16587,3.02754,3.88129,.10924,3.01634,3.69385,.15326,3.07028,3.82736,.12456,3.03959,3.79982,.23071,3.18779,3.77004,.26451,3.15231,3.77423,.18955,3.1868,3.729,.1999,3.12986,3.7066,.17804,3.09962,3.69454,.15099,3.08026,3.70479,.15017,3.09165,3.6984,.17638,3.08282,3.7313,.08908,3.0689,3.72496,.09626,3.0568,3.7672,.05788,3.05157,3.88533,.1324,3.17116,3.87023,.10651,3.16591,3.87369,.09594,3.12366,3.88567,.12808,3.13452,3.85099,.08093,3.16821,3.84485,.07393,3.12477,3.91023,.22025,3.04045,3.91108,.22655,3.08331,3.9279,.16157,3.0434,3.92528,.15878,3.06818,3.86177,.23693,3.16901,3.90841,.21785,3.11091,3.86887,.27102,3.12969,3.8939,.21169,3.14975,3.82038,.23789,3.18201,3.80982,.07028,3.12364,3.7732,.06182,3.07255,3.80722,.04832,3.06143,3.73372,.25294,3.07444,3.81751,.08938,3.2169,3.81256,.11199,3.23005,3.90297,.12655,3.21163,3.80038,.1815,3.21643,3.80074,.10815,3.03848,3.82435,.07379,3.17031,3.89489,.09024,3.32924};
			return value;
		}
		private double[] getlfdphal3_Coord_7_125_point_2()
		{
			double[] value = {3.92497,.11002,3.31589,3.81973,.09301,3.30197,3.8269,.22949,3.04907,3.81656,.20735,3.05614,3.79427,.23304,3.05662,3.78776,.21171,3.06305,3.75155,.13972,3.06271,3.77109,.11167,3.04947,3.76836,.09647,3.04258,3.78205,.18563,3.07195,3.85264,.05953,3.02674,3.73918,.26832,3.0975,3.79815,.28053,3.07006,3.79111,.26194,3.05441,3.91538,.15527,3.09431,3.7981,.12671,3.20047,3.80845,.1163,3.28271,3.81713,.17405,3.24499,3.81334,.16706,3.24498,3.80896,.14254,3.29072,3.81557,.15603,3.29526,3.75914,.27562,3.12628,3.71335,.20354,3.1054,3.72346,.17518,3.12138,3.72164,.14772,3.11026,3.74194,.091,3.08762,3.84959,.05951,3.07031,3.80744,.04422,3.03905,3.85377,.05745,3.04487,3.90251,.12138,3.08458,3.89331,.08813,3.04812,3.91049,.12104,3.05685,3.88638,.08883,3.07581,3.86765,.27944,3.10279,3.84396,.25689,3.03603,3.85559,.27285,3.04836,3.91309,.12402,3.03359,3.89534,.09118,3.02762,3.70693,.20279,3.0897,3.75461,.16303,3.07125,3.77645,.15724,3.07216,3.77454,.13431,3.06062,3.80658,.18074,3.06474,3.79974,.12906,3.05058,3.8299,.14553,3.04737,3.80035,.15159,3.06385,3.76879,.16207,3.17654,3.83843,.06777,3.20411,3.89495,.16602,3.14327,3.89655,.16285,3.17782,3.80123,.09732,3.18712,3.90872,.19035,3.22105,3.89439,.19794,3.18578,3.9114,.15751,3.21281,3.81846,.28059,3.14218,3.76748,.13755,3.16477,3.77455,.09964,3.14773,3.8132,.28928,3.11632};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfdphal4_Geo_6_130_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,0,7,-1,8,9,10,-1,11,12,4,-1,12,13,4,-1,11,4,14,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,20,22,21,-1,23,24,25,-1,24,26,25,-1,27,28,29,-1,29,30,27,-1,20,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,42,43,37,-1,44,35,34,-1,45,46,18,-1,45,47,46,-1,37,36,29,-1,48,49,9,-1,49,10,9,-1,50,2,14,-1,51,52,12,-1,53,54,24,-1,24,55,53,-1,56,57,58,-1,59,60,61,-1,61,62,59,-1,63,62,61,-1,63,64,62,-1,65,66,67,-1,66,68,67,-1,69,52,70,-1,70,71,69,-1,2,72,0,-1,11,73,74,-1,69,75,8,-1,8,76,69,-1,77,49,48,-1,77,78,49,-1,79,80,81,-1,80,82,81,-1,33,83,34,-1,19,54,31,-1,40,84,36,-1,31,53,85,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,92,93,90,-1,25,94,95,-1,25,96,94,-1,25,26,97,-1,97,96,25,-1,98,99,100,-1,100,101,98,-1,102,103,104,-1,103,105,104,-1,106,107,108,-1,106,109,107,-1,110,64,106,-1,110,62,64,-1,17,27,30,-1,17,16,27,-1,111,112,113,-1,87,95,94,-1,94,88,87,-1,62,110,114,-1,115,31,85,-1,115,32,31,-1,28,37,29,-1,39,84,40,-1,20,19,31,-1,8,75,9,-1,11,74,51,-1,2,50,72,-1,74,73,67,-1,73,65,67,-1,116,75,71,-1,75,69,71,-1,1,0,6,-1,6,66,1,-1,117,118,63,-1,118,64,63,-1,46,59,62,-1,62,114,46,-1,119,120,121,-1,120,122,121,-1,83,20,34,-1,55,123,53,-1,111,99,124,-1,111,100,99,-1,56,5,4,-1,49,78,125,-1,49,125,10,-1,126,14,3,-1,14,4,3,-1,82,35,127,-1,115,128,129,-1,115,85,128,-1,81,130,42,-1,131,41,40,-1,41,132,133,-1,43,130,134,-1,43,42,130,-1,40,36,38,-1,37,28,42,-1,34,20,32,-1,31,54,53,-1,89,84,87,-1,89,36,84,-1,84,39,95,-1,95,87,84,-1,28,27,135,-1,135,79,28,-1,105,107,121,-1,105,103,107,-1,91,88,94,-1,91,90,88,-1,15,136,16,-1,136,137,16,-1,76,10,125,-1,76,8,10,-1,73,2,65,-1,2,1,65,-1,1,66,65,-1,0,138,7,-1,0,72,138,-1,50,14,126,-1,60,59,139,-1,12,11,51,-1,140,5,141,-1,140,3,5,-1,72,126,138,-1,72,50,126,-1,14,73,11,-1,14,2,73,-1,90,86,88,-1,90,45,86,-1,96,91,94,-1,96,112,91,-1,142,97,143,-1,142,113,97,-1,122,144,145,-1,144,122,146,-1,108,103,147,-1,108,107,103,-1,121,145,105,-1,145,121,122,-1,80,135,148,-1,80,79,135,-1,29,89,30,-1,29,36,89,-1,22,83,104,-1,22,20,83,-1,23,95,39,-1,95,23,25,-1,149,43,134,-1,150,43,149,-1,132,131,151,-1,41,131,132,-1,127,44,152,-1,127,35,44,-1,131,38,150,-1,131,40,38,-1,128,53,123,-1,85,53,128,-1,152,115,129,-1,44,115,152,-1,152,130,127,-1,134,130,152,-1,138,3,140,-1,138,126,3,-1,6,139,59,-1,6,7,139,-1,13,56,4,-1,57,56,13,-1,99,153,124,-1,99,70,153,-1,100,113,142,-1,113,100,111,-1,22,105,145,-1,105,22,104,-1,154,120,119,-1,154,155,120,-1,79,42,28,-1,79,81,42,-1,99,71,70,-1,71,99,98,-1,118,156,154,-1,118,117,156,-1,116,9,75,-1,116,156,9,-1,51,67,153,-1,51,74,67,-1,76,52,69,-1,76,12,52,-1,63,58,77,-1,61,58,63,-1,41,23,39,-1,23,41,133,-1,44,32,115,-1,44,34,32,-1,151,123,132,-1,123,151,128,-1,134,129,149,-1,134,152,129,-1,136,106,108,-1,136,110,106,-1,46,15,18,-1,114,15,46,-1,111,68,92,-1,68,111,124,-1,16,135,27,-1,16,137,135,-1,6,93,66,-1,6,47,93,-1,106,118,109,-1,106,64,118,-1,148,103,102,-1,148,147,103,-1,107,119,121,-1,107,109,119,-1,21,145,144,-1,21,22,145,-1,120,98,101,-1,120,155,98,-1,101,142,146,-1,101,100,142,-1,144,157,21,-1,143,157,144,-1,120,146,122,-1,146,120,101,-1,118,119,109,-1,118,154,119,-1,137,148,135,-1,137,147,148,-1,92,112,111,-1,112,92,91,-1,92,66,93,-1,66,92,68,-1,93,45,90,-1,47,45,93,-1,114,136,15,-1,114,110,136,-1};
			return value;
		}
		private int[] getlfdphal4_Geo_6_130_coordIndex_2()
		{
			int[] value = {149,128,151,-1,149,129,128,-1,132,55,133,-1,123,55,132,-1,133,24,23,-1,24,133,55,-1,35,80,33,-1,80,35,82,-1,58,78,77,-1,57,78,58,-1,117,77,48,-1,117,63,77,-1,141,56,58,-1,141,5,56,-1,58,60,141,-1,60,58,61,-1,156,48,9,-1,156,117,48,-1,116,98,155,-1,98,116,71,-1,124,67,68,-1,67,124,153,-1,156,155,154,-1,156,116,155,-1,97,157,143,-1,26,157,97,-1,153,52,51,-1,153,70,52,-1,57,125,78,-1,57,13,125,-1,86,30,89,-1,86,17,30,-1,6,46,47,-1,6,59,46,-1,140,7,138,-1,7,140,139,-1,127,81,82,-1,127,130,81,-1,37,150,38,-1,43,150,37,-1,150,151,131,-1,150,149,151,-1,54,21,157,-1,54,19,21,-1,33,148,102,-1,33,80,148,-1,157,24,54,-1,157,26,24,-1,83,102,104,-1,83,33,102,-1,136,147,137,-1,136,108,147,-1,146,143,144,-1,146,142,143,-1,97,112,96,-1,113,112,97,-1,45,17,86,-1,45,18,17,-1,13,76,125,-1,76,13,12,-1,141,139,140,-1,141,60,139,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfdphal4_Coord_7_130_point_1()
		{
			double[] value = {4.14042,.25129,2.50128,4.1366,.23021,2.49753,4.11977,.21303,2.52748,4.1235,.23438,2.56469,4.14737,.20309,2.57154,4.1354,.2415,2.56937,4.13661,.25532,2.48835,4.14041,.25663,2.5021,4.28009,.21351,2.53052,4.30446,.23131,2.49947,4.27739,.22607,2.54188,4.14409,.19116,2.56309,4.18686,.19564,2.56159,4.18551,.20862,2.56758,4.14116,.19717,2.5669,4.1318,.35193,2.43491,4.12167,.36143,2.41328,4.04486,.30362,2.41736,4.06464,.29971,2.43278,4.28553,.18079,2.3419,4.31072,.2008,2.3397,4.2948,.16404,2.35151,4.32409,.18951,2.35132,4.09034,.17429,2.3385,4.15894,.1613,2.32929,4.08619,.16368,2.3481,4.15709,.14304,2.33731,4.09653,.3559,2.39306,4.09074,.34096,2.37812,4.03742,.29869,2.39425,4.03782,.30265,2.40627,4.2649,.19455,2.34432,4.2771,.21023,2.34488,4.30891,.26488,2.33171,4.28283,.23756,2.34502,4.26459,.26642,2.34453,4.02294,.27984,2.39383,4.11059,.28692,2.37772,4.09067,.26225,2.38332,4.04182,.21096,2.36176,4.07989,.24153,2.37643,4.09196,.21769,2.36196,4.1413,.30351,2.3689,4.13033,.2813,2.37522,4.25121,.2464,2.35371,4.05108,.27814,2.43019,4.11983,.28886,2.4645,4.10876,.26445,2.45818,4.29959,.26554,2.5043,4.27934,.24937,2.54844,4.11896,.21995,2.54278,4.15545,.16663,2.51181,4.20721,.16141,2.50755,4.22152,.18574,2.34068,4.23581,.16072,2.33537,4.17525,.18094,2.33897,4.16868,.25475,2.56844,4.19229,.25736,2.56597,4.1921,.30001,2.52676,4.14658,.28047,2.49189,4.15438,.27769,2.50438,4.19644,.29499,2.49715,4.19448,.30415,2.48647,4.2537,.29508,2.49253,4.25462,.30005,2.47822,4.13692,.22255,2.49587,4.1362,.23091,2.48201,4.14246,.20047,2.48612,4.13602,.20338,2.47255,4.25224,.1762,2.50837,4.21406,.1761,2.47683,4.2506,.19581,2.48268,4.12028,.23601,2.52621,4.12318,.20471,2.52318,4.1356,.18737,2.51878,4.29116,.20028,2.50162,4.22731,.20265,2.55371,4.26461,.29725,2.51716,4.2496,.26216,2.55834,4.18023,.33551,2.34869,4.24962,.31879,2.33234,4.18889,.30858,2.35243,4.23507,.29799,2.34617,4.32779,.22576,2.33808,4.00832,.25963,2.39249,4.22785,.20482,2.3506,4.02887,.2818,2.41657,4.00616,.25848,2.40111,4.0194,.25695,2.41049,4.01933,.28024,2.40386,4.04232,.25335,2.42265,4.0613,.19844,2.39457,4.10793,.20596,2.4373,4.10389,.24192,2.45016,4.0458,.1973,2.37861,4.04088,.2036,2.36843,4.09621,.16245,2.35934,4.15727,.14201,2.35108,4.25303,.19503,2.45558,4.21527,.17737,2.45874};
			return value;
		}
		private double[] getlfdphal4_Coord_7_130_point_2()
		{
			double[] value = {4.21961,.1674,2.42167,4.26755,.18039,2.42035,4.32991,.27488,2.34192,4.33117,.28398,2.37908,4.34578,.22057,2.35131,4.34382,.2202,2.37289,4.2568,.31181,2.44737,4.3257,.27903,2.40407,4.27131,.33634,2.41479,4.30137,.28101,2.43337,4.19793,.32217,2.45763,4.16351,.17119,2.41922,4.10618,.1661,2.37798,4.15808,.14699,2.37075,4.16503,.32055,2.46272,4.23777,.22277,2.35528,4.27346,.21612,2.48092,4.28437,.27238,2.48438,4.28765,.27335,2.46611,4.30329,.23926,2.43192,4.2889,.20679,2.42749,4.3326,.22063,2.39582,4.3136,.1924,2.39167,4.18065,.19639,2.34657,4.17047,.17679,2.46014,4.23291,.21802,2.55928,4.1158,.22195,2.54801,4.22405,.28061,2.3543,4.18739,.21516,2.35576,4.19481,.23536,2.36568,4.18013,.29123,2.36014,4.10429,.23575,2.3717,4.13059,.20656,2.35475,4.11918,.19383,2.34928,4.16916,.26993,2.3702,4.18712,.3526,2.36087,4.2039,.35591,2.4238,4.20111,.36225,2.40044,4.11705,.2412,2.52903,4.14708,.27228,2.50481,4.12259,.26493,2.53408,4.13368,.27616,2.5372,4.22768,.14857,2.38096,4.23251,.1443,2.35994,4.29294,.16306,2.36756,4.32212,.18882,2.37013,4.28576,.16678,2.38812,4.27314,.34159,2.39022,4.2615,.33247,2.34213,4.15428,.2462,2.37278,4.11577,.25601,2.37921,4.14501,.22591,2.36364,4.2093,.25962,2.36412,4.17129,.17656,2.47702,4.29088,.24081,2.46206,4.27618,.21526,2.4585,4.28784,.24179,2.47977,4.23121,.14512,2.34384};
			return value;
		}

		/** Large attribute array: IndexedFaceSet DEF='ltalus_Geo' coordIndex field, scene-graph level=6, element #15, 4952 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getltalus_Geo_6_15_coordIndex()
		{
			MFInt32 ltalus_Geo_6_15_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getltalus_Geo_6_15_coordIndex_1()))
				.append(new MFInt32(getltalus_Geo_6_15_coordIndex_2()))
				.append(new MFInt32(getltalus_Geo_6_15_coordIndex_3()))
				.append(new MFInt32(getltalus_Geo_6_15_coordIndex_4()))
				.append(new MFInt32(getltalus_Geo_6_15_coordIndex_5()));
			return ltalus_Geo_6_15_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='ltalus_Coord' point field, scene-graph level=7, element #15, 1863 total numbers made up of 621 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getltalus_Coord_7_15_point()
		{
			MFVec3f ltalus_Coord_7_15_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getltalus_Coord_7_15_point_1()))
				.append(new MFVec3f(getltalus_Coord_7_15_point_2()))
				.append(new MFVec3f(getltalus_Coord_7_15_point_3()))
				.append(new MFVec3f(getltalus_Coord_7_15_point_4()))
				.append(new MFVec3f(getltalus_Coord_7_15_point_5()))
				.append(new MFVec3f(getltalus_Coord_7_15_point_6()))
				.append(new MFVec3f(getltalus_Coord_7_15_point_7()));
			return ltalus_Coord_7_15_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lcalc_Geo' coordIndex field, scene-graph level=6, element #20, 5896 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlcalc_Geo_6_20_coordIndex()
		{
			MFInt32 lcalc_Geo_6_20_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlcalc_Geo_6_20_coordIndex_1()))
				.append(new MFInt32(getlcalc_Geo_6_20_coordIndex_2()))
				.append(new MFInt32(getlcalc_Geo_6_20_coordIndex_3()))
				.append(new MFInt32(getlcalc_Geo_6_20_coordIndex_4()))
				.append(new MFInt32(getlcalc_Geo_6_20_coordIndex_5()))
				.append(new MFInt32(getlcalc_Geo_6_20_coordIndex_6()));
			return lcalc_Geo_6_20_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lcalc_Coord' point field, scene-graph level=7, element #20, 2217 total numbers made up of 739 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlcalc_Coord_7_20_point()
		{
			MFVec3f lcalc_Coord_7_20_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlcalc_Coord_7_20_point_1()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_2()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_3()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_4()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_5()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_6()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_7()))
				.append(new MFVec3f(getlcalc_Coord_7_20_point_8()));
			return lcalc_Coord_7_20_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lcuboid_Geo' coordIndex field, scene-graph level=6, element #25, 4128 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlcuboid_Geo_6_25_coordIndex()
		{
			MFInt32 lcuboid_Geo_6_25_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlcuboid_Geo_6_25_coordIndex_1()))
				.append(new MFInt32(getlcuboid_Geo_6_25_coordIndex_2()))
				.append(new MFInt32(getlcuboid_Geo_6_25_coordIndex_3()))
				.append(new MFInt32(getlcuboid_Geo_6_25_coordIndex_4()))
				.append(new MFInt32(getlcuboid_Geo_6_25_coordIndex_5()));
			return lcuboid_Geo_6_25_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lcuboid_Coord' point field, scene-graph level=7, element #25, 1554 total numbers made up of 518 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlcuboid_Coord_7_25_point()
		{
			MFVec3f lcuboid_Coord_7_25_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlcuboid_Coord_7_25_point_1()))
				.append(new MFVec3f(getlcuboid_Coord_7_25_point_2()))
				.append(new MFVec3f(getlcuboid_Coord_7_25_point_3()))
				.append(new MFVec3f(getlcuboid_Coord_7_25_point_4()))
				.append(new MFVec3f(getlcuboid_Coord_7_25_point_5()))
				.append(new MFVec3f(getlcuboid_Coord_7_25_point_6()));
			return lcuboid_Coord_7_25_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='llcun_Geo' coordIndex field, scene-graph level=6, element #30, 2432 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getllcun_Geo_6_30_coordIndex()
		{
			MFInt32 llcun_Geo_6_30_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getllcun_Geo_6_30_coordIndex_1()))
				.append(new MFInt32(getllcun_Geo_6_30_coordIndex_2()))
				.append(new MFInt32(getllcun_Geo_6_30_coordIndex_3()));
			return llcun_Geo_6_30_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='llcun_Coord' point field, scene-graph level=7, element #30, 918 total numbers made up of 306 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getllcun_Coord_7_30_point()
		{
			MFVec3f llcun_Coord_7_30_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getllcun_Coord_7_30_point_1()))
				.append(new MFVec3f(getllcun_Coord_7_30_point_2()))
				.append(new MFVec3f(getllcun_Coord_7_30_point_3()))
				.append(new MFVec3f(getllcun_Coord_7_30_point_4()));
			return llcun_Coord_7_30_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lmcun_Geo' coordIndex field, scene-graph level=6, element #35, 3000 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlmcun_Geo_6_35_coordIndex()
		{
			MFInt32 lmcun_Geo_6_35_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlmcun_Geo_6_35_coordIndex_1()))
				.append(new MFInt32(getlmcun_Geo_6_35_coordIndex_2()))
				.append(new MFInt32(getlmcun_Geo_6_35_coordIndex_3()));
			return lmcun_Geo_6_35_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lmcun_Coord' point field, scene-graph level=7, element #35, 1131 total numbers made up of 377 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlmcun_Coord_7_35_point()
		{
			MFVec3f lmcun_Coord_7_35_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlmcun_Coord_7_35_point_1()))
				.append(new MFVec3f(getlmcun_Coord_7_35_point_2()))
				.append(new MFVec3f(getlmcun_Coord_7_35_point_3()))
				.append(new MFVec3f(getlmcun_Coord_7_35_point_4()));
			return lmcun_Coord_7_35_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lnaviclr_Geo' coordIndex field, scene-graph level=6, element #40, 4016 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlnaviclr_Geo_6_40_coordIndex()
		{
			MFInt32 lnaviclr_Geo_6_40_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlnaviclr_Geo_6_40_coordIndex_1()))
				.append(new MFInt32(getlnaviclr_Geo_6_40_coordIndex_2()))
				.append(new MFInt32(getlnaviclr_Geo_6_40_coordIndex_3()))
				.append(new MFInt32(getlnaviclr_Geo_6_40_coordIndex_4()))
				.append(new MFInt32(getlnaviclr_Geo_6_40_coordIndex_5()));
			return lnaviclr_Geo_6_40_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lnaviclr_Coord' point field, scene-graph level=7, element #40, 1512 total numbers made up of 504 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlnaviclr_Coord_7_40_point()
		{
			MFVec3f lnaviclr_Coord_7_40_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlnaviclr_Coord_7_40_point_1()))
				.append(new MFVec3f(getlnaviclr_Coord_7_40_point_2()))
				.append(new MFVec3f(getlnaviclr_Coord_7_40_point_3()))
				.append(new MFVec3f(getlnaviclr_Coord_7_40_point_4()))
				.append(new MFVec3f(getlnaviclr_Coord_7_40_point_5()))
				.append(new MFVec3f(getlnaviclr_Coord_7_40_point_6()));
			return lnaviclr_Coord_7_40_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfmphal_Geo' coordIndex field, scene-graph level=6, element #45, 1528 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfmphal_Geo_6_45_coordIndex()
		{
			MFInt32 lfmphal_Geo_6_45_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfmphal_Geo_6_45_coordIndex_1()))
				.append(new MFInt32(getlfmphal_Geo_6_45_coordIndex_2()));
			return lfmphal_Geo_6_45_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfmphal_Coord' point field, scene-graph level=7, element #45, 579 total numbers made up of 193 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfmphal_Coord_7_45_point()
		{
			MFVec3f lfmphal_Coord_7_45_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfmphal_Coord_7_45_point_1()))
				.append(new MFVec3f(getlfmphal_Coord_7_45_point_2()));
			return lfmphal_Coord_7_45_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfmphal2_Geo' coordIndex field, scene-graph level=6, element #50, 936 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfmphal2_Geo_6_50_coordIndex()
		{
			MFInt32 lfmphal2_Geo_6_50_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfmphal2_Geo_6_50_coordIndex_1()));
			return lfmphal2_Geo_6_50_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfmphal2_Coord' point field, scene-graph level=7, element #50, 357 total numbers made up of 119 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfmphal2_Coord_7_50_point()
		{
			MFVec3f lfmphal2_Coord_7_50_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfmphal2_Coord_7_50_point_1()))
				.append(new MFVec3f(getlfmphal2_Coord_7_50_point_2()));
			return lfmphal2_Coord_7_50_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfmphal3_Geo' coordIndex field, scene-graph level=6, element #55, 1288 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfmphal3_Geo_6_55_coordIndex()
		{
			MFInt32 lfmphal3_Geo_6_55_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfmphal3_Geo_6_55_coordIndex_1()))
				.append(new MFInt32(getlfmphal3_Geo_6_55_coordIndex_2()));
			return lfmphal3_Geo_6_55_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfmphal3_Coord' point field, scene-graph level=7, element #55, 489 total numbers made up of 163 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfmphal3_Coord_7_55_point()
		{
			MFVec3f lfmphal3_Coord_7_55_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfmphal3_Coord_7_55_point_1()))
				.append(new MFVec3f(getlfmphal3_Coord_7_55_point_2()));
			return lfmphal3_Coord_7_55_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfmphal4_Geo' coordIndex field, scene-graph level=6, element #60, 2536 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfmphal4_Geo_6_60_coordIndex()
		{
			MFInt32 lfmphal4_Geo_6_60_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfmphal4_Geo_6_60_coordIndex_1()))
				.append(new MFInt32(getlfmphal4_Geo_6_60_coordIndex_2()))
				.append(new MFInt32(getlfmphal4_Geo_6_60_coordIndex_3()));
			return lfmphal4_Geo_6_60_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfmphal4_Coord' point field, scene-graph level=7, element #60, 963 total numbers made up of 321 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfmphal4_Coord_7_60_point()
		{
			MFVec3f lfmphal4_Coord_7_60_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfmphal4_Coord_7_60_point_1()))
				.append(new MFVec3f(getlfmphal4_Coord_7_60_point_2()))
				.append(new MFVec3f(getlfmphal4_Coord_7_60_point_3()))
				.append(new MFVec3f(getlfmphal4_Coord_7_60_point_4()));
			return lfmphal4_Coord_7_60_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfpprox_Geo' coordIndex field, scene-graph level=6, element #65, 2024 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfpprox_Geo_6_65_coordIndex()
		{
			MFInt32 lfpprox_Geo_6_65_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfpprox_Geo_6_65_coordIndex_1()))
				.append(new MFInt32(getlfpprox_Geo_6_65_coordIndex_2()))
				.append(new MFInt32(getlfpprox_Geo_6_65_coordIndex_3()));
			return lfpprox_Geo_6_65_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfpprox_Coord' point field, scene-graph level=7, element #65, 765 total numbers made up of 255 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfpprox_Coord_7_65_point()
		{
			MFVec3f lfpprox_Coord_7_65_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfpprox_Coord_7_65_point_1()))
				.append(new MFVec3f(getlfpprox_Coord_7_65_point_2()))
				.append(new MFVec3f(getlfpprox_Coord_7_65_point_3()));
			return lfpprox_Coord_7_65_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfpprox2_Geo' coordIndex field, scene-graph level=6, element #70, 1584 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfpprox2_Geo_6_70_coordIndex()
		{
			MFInt32 lfpprox2_Geo_6_70_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfpprox2_Geo_6_70_coordIndex_1()))
				.append(new MFInt32(getlfpprox2_Geo_6_70_coordIndex_2()));
			return lfpprox2_Geo_6_70_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfpprox2_Coord' point field, scene-graph level=7, element #70, 600 total numbers made up of 200 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfpprox2_Coord_7_70_point()
		{
			MFVec3f lfpprox2_Coord_7_70_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfpprox2_Coord_7_70_point_1()))
				.append(new MFVec3f(getlfpprox2_Coord_7_70_point_2()));
			return lfpprox2_Coord_7_70_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfpprox3_Geo' coordIndex field, scene-graph level=6, element #75, 1760 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfpprox3_Geo_6_75_coordIndex()
		{
			MFInt32 lfpprox3_Geo_6_75_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfpprox3_Geo_6_75_coordIndex_1()))
				.append(new MFInt32(getlfpprox3_Geo_6_75_coordIndex_2()));
			return lfpprox3_Geo_6_75_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfpprox3_Coord' point field, scene-graph level=7, element #75, 666 total numbers made up of 222 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfpprox3_Coord_7_75_point()
		{
			MFVec3f lfpprox3_Coord_7_75_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfpprox3_Coord_7_75_point_1()))
				.append(new MFVec3f(getlfpprox3_Coord_7_75_point_2()))
				.append(new MFVec3f(getlfpprox3_Coord_7_75_point_3()));
			return lfpprox3_Coord_7_75_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfpprox4_Geo' coordIndex field, scene-graph level=6, element #80, 1880 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfpprox4_Geo_6_80_coordIndex()
		{
			MFInt32 lfpprox4_Geo_6_80_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfpprox4_Geo_6_80_coordIndex_1()))
				.append(new MFInt32(getlfpprox4_Geo_6_80_coordIndex_2()));
			return lfpprox4_Geo_6_80_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfpprox4_Coord' point field, scene-graph level=7, element #80, 711 total numbers made up of 237 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfpprox4_Coord_7_80_point()
		{
			MFVec3f lfpprox4_Coord_7_80_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfpprox4_Coord_7_80_point_1()))
				.append(new MFVec3f(getlfpprox4_Coord_7_80_point_2()))
				.append(new MFVec3f(getlfpprox4_Coord_7_80_point_3()));
			return lfpprox4_Coord_7_80_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfpprox5_Geo' coordIndex field, scene-graph level=6, element #85, 1560 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfpprox5_Geo_6_85_coordIndex()
		{
			MFInt32 lfpprox5_Geo_6_85_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfpprox5_Geo_6_85_coordIndex_1()))
				.append(new MFInt32(getlfpprox5_Geo_6_85_coordIndex_2()));
			return lfpprox5_Geo_6_85_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfpprox5_Coord' point field, scene-graph level=7, element #85, 591 total numbers made up of 197 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfpprox5_Coord_7_85_point()
		{
			MFVec3f lfpprox5_Coord_7_85_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfpprox5_Coord_7_85_point_1()))
				.append(new MFVec3f(getlfpprox5_Coord_7_85_point_2()));
			return lfpprox5_Coord_7_85_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfmet_Geo' coordIndex field, scene-graph level=6, element #90, 3424 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfmet_Geo_6_90_coordIndex()
		{
			MFInt32 lfmet_Geo_6_90_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfmet_Geo_6_90_coordIndex_1()))
				.append(new MFInt32(getlfmet_Geo_6_90_coordIndex_2()))
				.append(new MFInt32(getlfmet_Geo_6_90_coordIndex_3()))
				.append(new MFInt32(getlfmet_Geo_6_90_coordIndex_4()));
			return lfmet_Geo_6_90_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfmet_Coord' point field, scene-graph level=7, element #90, 1290 total numbers made up of 430 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfmet_Coord_7_90_point()
		{
			MFVec3f lfmet_Coord_7_90_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfmet_Coord_7_90_point_1()))
				.append(new MFVec3f(getlfmet_Coord_7_90_point_2()))
				.append(new MFVec3f(getlfmet_Coord_7_90_point_3()))
				.append(new MFVec3f(getlfmet_Coord_7_90_point_4()))
				.append(new MFVec3f(getlfmet_Coord_7_90_point_5()));
			return lfmet_Coord_7_90_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lmet2_Geo' coordIndex field, scene-graph level=6, element #95, 3656 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlmet2_Geo_6_95_coordIndex()
		{
			MFInt32 lmet2_Geo_6_95_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlmet2_Geo_6_95_coordIndex_1()))
				.append(new MFInt32(getlmet2_Geo_6_95_coordIndex_2()))
				.append(new MFInt32(getlmet2_Geo_6_95_coordIndex_3()))
				.append(new MFInt32(getlmet2_Geo_6_95_coordIndex_4()));
			return lmet2_Geo_6_95_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lmet2_Coord' point field, scene-graph level=7, element #95, 1377 total numbers made up of 459 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlmet2_Coord_7_95_point()
		{
			MFVec3f lmet2_Coord_7_95_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlmet2_Coord_7_95_point_1()))
				.append(new MFVec3f(getlmet2_Coord_7_95_point_2()))
				.append(new MFVec3f(getlmet2_Coord_7_95_point_3()))
				.append(new MFVec3f(getlmet2_Coord_7_95_point_4()))
				.append(new MFVec3f(getlmet2_Coord_7_95_point_5()));
			return lmet2_Coord_7_95_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lmet3_Geo' coordIndex field, scene-graph level=6, element #100, 3448 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlmet3_Geo_6_100_coordIndex()
		{
			MFInt32 lmet3_Geo_6_100_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlmet3_Geo_6_100_coordIndex_1()))
				.append(new MFInt32(getlmet3_Geo_6_100_coordIndex_2()))
				.append(new MFInt32(getlmet3_Geo_6_100_coordIndex_3()))
				.append(new MFInt32(getlmet3_Geo_6_100_coordIndex_4()));
			return lmet3_Geo_6_100_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lmet3_Coord' point field, scene-graph level=7, element #100, 1299 total numbers made up of 433 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlmet3_Coord_7_100_point()
		{
			MFVec3f lmet3_Coord_7_100_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlmet3_Coord_7_100_point_1()))
				.append(new MFVec3f(getlmet3_Coord_7_100_point_2()))
				.append(new MFVec3f(getlmet3_Coord_7_100_point_3()))
				.append(new MFVec3f(getlmet3_Coord_7_100_point_4()))
				.append(new MFVec3f(getlmet3_Coord_7_100_point_5()));
			return lmet3_Coord_7_100_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lmet4_Geo' coordIndex field, scene-graph level=6, element #105, 3744 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlmet4_Geo_6_105_coordIndex()
		{
			MFInt32 lmet4_Geo_6_105_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlmet4_Geo_6_105_coordIndex_1()))
				.append(new MFInt32(getlmet4_Geo_6_105_coordIndex_2()))
				.append(new MFInt32(getlmet4_Geo_6_105_coordIndex_3()))
				.append(new MFInt32(getlmet4_Geo_6_105_coordIndex_4()));
			return lmet4_Geo_6_105_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lmet4_Coord' point field, scene-graph level=7, element #105, 1410 total numbers made up of 470 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlmet4_Coord_7_105_point()
		{
			MFVec3f lmet4_Coord_7_105_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlmet4_Coord_7_105_point_1()))
				.append(new MFVec3f(getlmet4_Coord_7_105_point_2()))
				.append(new MFVec3f(getlmet4_Coord_7_105_point_3()))
				.append(new MFVec3f(getlmet4_Coord_7_105_point_4()))
				.append(new MFVec3f(getlmet4_Coord_7_105_point_5()));
			return lmet4_Coord_7_105_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lmet5_Geo' coordIndex field, scene-graph level=6, element #110, 4224 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlmet5_Geo_6_110_coordIndex()
		{
			MFInt32 lmet5_Geo_6_110_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlmet5_Geo_6_110_coordIndex_1()))
				.append(new MFInt32(getlmet5_Geo_6_110_coordIndex_2()))
				.append(new MFInt32(getlmet5_Geo_6_110_coordIndex_3()))
				.append(new MFInt32(getlmet5_Geo_6_110_coordIndex_4()))
				.append(new MFInt32(getlmet5_Geo_6_110_coordIndex_5()));
			return lmet5_Geo_6_110_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lmet5_Coord' point field, scene-graph level=7, element #110, 1590 total numbers made up of 530 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlmet5_Coord_7_110_point()
		{
			MFVec3f lmet5_Coord_7_110_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlmet5_Coord_7_110_point_1()))
				.append(new MFVec3f(getlmet5_Coord_7_110_point_2()))
				.append(new MFVec3f(getlmet5_Coord_7_110_point_3()))
				.append(new MFVec3f(getlmet5_Coord_7_110_point_4()))
				.append(new MFVec3f(getlmet5_Coord_7_110_point_5()))
				.append(new MFVec3f(getlmet5_Coord_7_110_point_6()));
			return lmet5_Coord_7_110_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfdphal_Geo' coordIndex field, scene-graph level=6, element #115, 1552 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfdphal_Geo_6_115_coordIndex()
		{
			MFInt32 lfdphal_Geo_6_115_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfdphal_Geo_6_115_coordIndex_1()))
				.append(new MFInt32(getlfdphal_Geo_6_115_coordIndex_2()));
			return lfdphal_Geo_6_115_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfdphal_Coord' point field, scene-graph level=7, element #115, 588 total numbers made up of 196 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfdphal_Coord_7_115_point()
		{
			MFVec3f lfdphal_Coord_7_115_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfdphal_Coord_7_115_point_1()))
				.append(new MFVec3f(getlfdphal_Coord_7_115_point_2()));
			return lfdphal_Coord_7_115_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfdphal2_Geo' coordIndex field, scene-graph level=6, element #120, 1264 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfdphal2_Geo_6_120_coordIndex()
		{
			MFInt32 lfdphal2_Geo_6_120_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfdphal2_Geo_6_120_coordIndex_1()))
				.append(new MFInt32(getlfdphal2_Geo_6_120_coordIndex_2()));
			return lfdphal2_Geo_6_120_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfdphal2_Coord' point field, scene-graph level=7, element #120, 480 total numbers made up of 160 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfdphal2_Coord_7_120_point()
		{
			MFVec3f lfdphal2_Coord_7_120_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfdphal2_Coord_7_120_point_1()))
				.append(new MFVec3f(getlfdphal2_Coord_7_120_point_2()));
			return lfdphal2_Coord_7_120_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfdphal3_Geo' coordIndex field, scene-graph level=6, element #125, 1248 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfdphal3_Geo_6_125_coordIndex()
		{
			MFInt32 lfdphal3_Geo_6_125_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfdphal3_Geo_6_125_coordIndex_1()))
				.append(new MFInt32(getlfdphal3_Geo_6_125_coordIndex_2()));
			return lfdphal3_Geo_6_125_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfdphal3_Coord' point field, scene-graph level=7, element #125, 474 total numbers made up of 158 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfdphal3_Coord_7_125_point()
		{
			MFVec3f lfdphal3_Coord_7_125_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfdphal3_Coord_7_125_point_1()))
				.append(new MFVec3f(getlfdphal3_Coord_7_125_point_2()));
			return lfdphal3_Coord_7_125_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='lfdphal4_Geo' coordIndex field, scene-graph level=6, element #130, 1248 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getlfdphal4_Geo_6_130_coordIndex()
		{
			MFInt32 lfdphal4_Geo_6_130_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getlfdphal4_Geo_6_130_coordIndex_1()))
				.append(new MFInt32(getlfdphal4_Geo_6_130_coordIndex_2()));
			return lfdphal4_Geo_6_130_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='lfdphal4_Coord' point field, scene-graph level=7, element #130, 474 total numbers made up of 158 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getlfdphal4_Coord_7_130_point()
		{
			MFVec3f lfdphal4_Coord_7_130_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getlfdphal4_Coord_7_130_point_1()))
				.append(new MFVec3f(getlfdphal4_Coord_7_130_point_2()));
			return lfdphal4_Coord_7_130_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return BonesLeftFoot model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new BonesLeftFoot().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Medical.BonesLeftFoot\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Medical.BonesLeftFoot self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Medical/BonesLeftFoot_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Medical/BonesLeftFoot_JavaExport.x3d"; 
                String filenameX3DV = "Medical/BonesLeftFoot_JavaExport.x3dv"; 
                String filenameJSON = "Medical/BonesLeftFoot_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
