####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesLeftFemur.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesLeftFemur.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Left Femur',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesLeftFemur.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesLeftFemur.x3d'),
    Transform(DEF='DSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Group(DEF='HeadC4',
        children=[
        Shape(DEF='lfemur',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(1,0,0),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='lfemur_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,12,15,13,-1,16,17,18,-1,18,8,16,-1,19,20,21,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,38,39,26,-1,26,40,38,-1,41,42,43,-1,43,44,41,-1,45,46,47,-1,48,49,50,-1,49,51,52,-1,53,54,55,-1,53,56,54,-1,57,58,59,-1,60,53,55,-1,61,62,63,-1,61,64,62,-1,65,66,67,-1,68,69,70,-1,71,70,69,-1,72,73,74,-1,73,66,75,-1,75,76,73,-1,68,77,69,-1,68,78,77,-1,74,79,72,-1,78,80,81,-1,82,65,67,-1,83,84,85,-1,83,86,84,-1,87,88,89,-1,87,90,88,-1,84,91,85,-1,88,92,93,-1,93,89,88,-1,94,95,96,-1,97,98,99,-1,53,60,100,-1,101,102,103,-1,104,105,106,-1,101,107,102,-1,107,108,102,-1,82,109,110,-1,110,65,82,-1,111,112,113,-1,111,114,112,-1,115,108,107,-1,115,116,108,-1,117,118,104,-1,117,119,118,-1,120,121,99,-1,120,122,121,-1,123,124,125,-1,123,126,124,-1,127,128,129,-1,130,131,132,-1,131,126,133,-1,133,134,131,-1,135,136,137,-1,136,138,137,-1,139,140,141,-1,142,143,144,-1,142,145,143,-1,146,147,148,-1,149,150,151,-1,151,152,149,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,161,162,159,-1,163,164,165,-1,163,166,164,-1,160,167,168,-1,160,159,167,-1,169,40,26,-1,26,170,169,-1,171,40,169,-1,170,28,172,-1,170,26,28,-1,29,173,174,-1,175,47,46,-1,46,176,175,-1,177,175,176,-1,177,178,175,-1,45,47,179,-1,43,180,181,-1,182,183,184,-1,185,186,187,-1,185,188,186,-1,189,3,190,-1,189,191,3,-1,192,193,194,-1,2,195,196,-1,17,197,198,-1,198,18,17,-1,199,200,201,-1,199,202,200,-1,203,204,205,-1,204,206,205,-1,207,208,209,-1,210,211,212,-1,210,213,211,-1,214,215,216,-1,103,217,101,-1,103,218,217,-1,219,220,221,-1,219,222,220,-1,223,224,225,-1,223,122,224,-1,226,142,227,-1,142,148,227,-1,228,229,230,-1,231,232,233,-1,234,232,235,-1,236,237,238,-1,239,240,241,-1,241,242,239,-1,243,244,245,-1,245,211,243,-1,9,246,247,-1,9,248,246,-1,249,193,192,-1,151,205,206,-1,206,152,151,-1,145,142,226,-1,250,251,252,-1,253,254,255,-1,256,253,255,-1,256,257,253,-1,258,259,260,-1,258,153,259,-1,62,64,261,-1,262,263,264,-1,263,265,264,-1,266,267,268,-1,268,269,266,-1,270,271,272,-1,272,250,270,-1,273,274,275,-1,273,276,274,-1,277,278,279,-1,277,31,278,-1,280,281,282,-1,280,283,281,-1,284,285,286,-1,285,287,286,-1,288,289,290,-1,288,291,289,-1,274,268,275,-1,268,267,275,-1,292,293,294,-1,292,295,293,-1,296,297,298,-1,299,300,301,-1,301,302,299,-1,303,304,305,-1,303,306,304,-1,307,308,309,-1,308,310,309,-1,311,312,313,-1,313,309,311,-1,314,315,316,-1,314,317,315,-1,318,319,320,-1,318,312,319,-1,321,322,323,-1,322,324,323,-1,288,325,326,-1,327,328,329,-1,327,330,328,-1,331,332,333,-1,332,334,333,-1,335,336,337,-1,335,338,336,-1,339,340,341,-1,339,342,340,-1,343,344,345,-1,346,347,244,-1,244,243,346,-1,348,349,350,-1,348,351,349,-1,352,353,354,-1,352,355,353,-1,356,324,357,-1,324,322,357,-1,358,359,360,-1,360,361,358,-1,362,363,364,-1,362,365,363,-1,366,367,368,-1,368,369,366,-1,370,371,149,-1,149,372,370,-1,148,150,227,-1,373,226,227,-1,374,375,235,-1,376,377,378,-1,376,379,377,-1,380,381,382,-1,382,383,380,-1,384,385,386,-1,387,384,388,-1,379,385,389,-1,379,386,385,-1,377,379,390,-1,379,389,390,-1,391,392,143,-1,392,144,143,-1,393,394,395,-1,393,396,394,-1,397,398,399,-1,397,400,398,-1,401,402,403,-1,403,404,401,-1,405,406,407,-1,406,408,407,-1,409,410,411,-1,409,412,410,-1,413,410,414,-1,410,415,414,-1,416,417,418,-1,416,419,417,-1,24,420,421,-1,24,23,420,-1,422,423,424,-1,425,426,427,-1,425,428,426,-1,429,430,431,-1,429,432,430,-1,134,433,132,-1,132,131,134,-1,434,435,436,-1,434,437,435,-1,125,438,123,-1,125,434,438,-1,131,130,439,-1,384,440,441,-1,384,386,440,-1,383,386,380,-1,383,440,386,-1,442,443,441,-1,442,444,443,-1,124,439,445,-1,445,446,124,-1,434,447,448,-1,448,437,434,-1,224,445,225,-1,224,446,445,-1,449,450,451,-1,452,453,454,-1,455,456,121,-1,455,457,456,-1,97,100,458,-1,459,460,461,-1,459,462,460,-1,460,463,461,-1,464,465,466,-1,464,467,465,-1,302,468,469,-1,302,470,468,-1,305,471,299,-1,305,472,471,-1,473,474,46,-1,46,45,473,-1,475,472,476,-1,472,477,476,-1,471,472,478,-1,478,479,471,-1,480,178,481,-1,480,175,178,-1,178,482,483,-1,483,481,178,-1,484,485,486,-1,485,487,486,-1,488,489,320,-1,313,490,307,-1,313,491,490,-1,492,493,494,-1,495,362,358,-1,34,365,496,-1,496,497,34,-1,498,497,496,-1,496,499,498,-1,500,174,361,-1,361,501,500,-1,27,26,502,-1,298,35,38,-1,38,503,298,-1,504,505,506,-1,505,507,506,-1,283,154,153,-1,508,493,509,-1,509,369,508,-1,510,511,512,-1,510,366,511,-1,157,156,513,-1,513,514,157,-1,515,516,517,-1,515,518,516,-1,515,517,519,-1,519,520,515,-1,521,297,296,-1,296,519,521,-1,522,523,171,-1,523,503,171,-1,524,525,526,-1,526,527,524,-1,526,525,259,-1,259,153,526,-1,528,529,530,-1,530,531,528,-1,532,533,534,-1,534,535,532,-1,536,534,537,-1,534,520,537,-1,538,539,529,-1,538,540,539,-1,541,542,260,-1,542,528,260,-1,543,544,545,-1,546,518,547,-1,547,545,546,-1,548,549,550,-1,548,551,549,-1,552,553,554,-1,554,555,552,-1,556,557,544,-1,556,558,557,-1,559,560,561,-1,560,556,561,-1,560,559,188,-1,188,562,560,-1,563,542,564,-1,563,538,542,-1,565,183,566,-1,183,182,566,-1,567,568,566,-1,566,569,567,-1,504,570,571,-1,570,572,571,-1,573,567,569,-1,573,574,567,-1,575,576,577,-1,577,578,575,-1,576,579,580,-1,580,577,576,-1,581,582,295,-1,583,584,573,-1,584,585,586,-1,584,583,585,-1,587,294,293,-1,293,588,587,-1,589,590,591,-1,591,592,589,-1,593,594,595,-1,593,596,594,-1,597,598,599,-1,599,600,597,-1,601,590,589,-1,601,602,590,-1,603,580,579,-1,604,588,605,-1,604,606,588,-1,607,608,609,-1,607,603,610,-1,607,611,612,-1,607,613,614,-1,607,605,615,-1,607,616,604,-1,617,618,619,-1,619,339,617,-1,339,345,342,-1,339,619,345,-1,620,621,343,-1,620,622,621,-1,623,624,625,-1,626,627,628,-1,626,629,627,-1,630,631,197,-1,18,6,8,-1,18,632,6,-1,633,634,635,-1,633,636,634,-1,637,638,639,-1,638,640,639,-1,641,642,643,-1,642,644,643,-1,645,646,647,-1,645,648,646,-1,645,649,648,-1,648,650,643,-1,651,652,649,-1,653,194,654,-1,654,655,653,-1,21,20,656,-1,20,657,656,-1,337,21,335,-1,337,19,21,-1,336,351,658,-1,351,348,658,-1,659,660,661,-1,661,662,659,-1,663,659,218,-1,659,662,218,-1,5,207,3,-1,662,664,218,-1,664,217,218,-1,650,209,665,-1,650,652,209,-1,666,641,667,-1,666,668,641,-1,669,670,671,-1,669,672,670,-1,673,674,675,-1,676,670,672,-1,676,677,670,-1,217,664,678,-1,658,348,679,-1,679,680,658,-1,681,682,683,-1,683,684,681,-1,685,686,687,-1,685,688,686,-1,106,689,104,-1,106,690,689,-1,685,222,688,-1,222,219,688,-1,691,692,693,-1,691,694,692,-1,695,696,697,-1,221,692,219,-1,221,698,692,-1,699,700,701,-1,699,702,700,-1,703,54,56,-1,704,82,705,-1,704,59,82,-1,702,706,707,-1,702,699,706,-1,708,709,710,-1,708,711,709,-1,712,713,714,-1,712,715,713,-1,716,717,718,-1,716,719,717,-1,720,721,722,-1,720,723,721,-1,724,725,726,-1,726,727,724,-1,91,93,468,-1,468,470,91,-1,728,162,291,-1,728,159,162,-1,61,63,729,-1,729,730,61,-1,731,732,733,-1,731,508,732,-1,272,271,263,-1,734,252,735,-1,734,736,252,-1,737,738,739,-1,739,33,737,-1,740,741,742,-1,743,744,745,-1,83,746,86,-1,83,747,746,-1,748,749,750,-1,750,751,748,-1,752,753,754,-1,52,755,756,-1,52,51,755,-1,757,322,321,-1,757,758,322,-1,759,760,761,-1,761,762,759,-1,763,764,765,-1,765,766,763,-1,767,768,769,-1,769,770,767,-1,771,364,772,-1,364,363,772,-1,773,739,738,-1,773,766,739,-1,740,763,741,-1,740,762,763,-1,774,775,256,-1,768,776,757,-1,776,758,757,-1,761,777,778,-1,778,764,761,-1,760,777,761,-1,760,779,777,-1,776,777,779,-1,756,780,781,-1,756,755,780,-1,266,253,782,-1,253,257,782,-1,271,738,737,-1,783,784,274,-1,250,252,736,-1,736,270,250,-1,272,731,250,-1,729,63,783,-1,783,785,729,-1,786,787,788,-1,64,789,261,-1,725,790,791,-1,725,724,790,-1,792,793,794,-1,792,795,793,-1,717,795,718,-1,717,90,795,-1,796,797,798,-1,796,799,797,-1,723,718,721,-1,723,716,718,-1,800,801,94,-1,94,802,800,-1,723,714,713,-1,723,720,714,-1,797,803,804,-1,797,805,803,-1,113,112,110,-1,112,806,110,-1,56,807,109,-1,56,53,807,-1,222,118,119,-1,119,220,222,-1,692,698,693,-1,808,687,116,-1,808,685,687,-1,809,108,116,-1,116,687,809,-1,810,811,658,-1,658,680,810,-1,812,672,813,-1,812,676,672,-1,353,814,815,-1,815,816,353,-1,817,14,818,-1,818,819,817,-1,820,821,822,-1,820,823,821,-1,824,822,825,-1,824,675,822,-1,666,667,813,-1,667,826,813,-1,667,827,826,-1,826,827,103,-1,103,102,826,-1,103,208,218,-1,103,665,208,-1,208,663,218,-1,19,661,660,-1,19,337,661,-1,335,21,341,-1,21,656,341,-1,651,649,645,-1,645,828,651,-1,646,829,647,-1,646,644,829,-1,830,831,832,-1,830,833,831,-1,834,831,829,-1,834,835,831,-1,836,837,835,-1,835,838,836,-1,638,839,640,-1,638,840,839,-1,633,841,842,-1,633,635,841,-1,634,636,6,-1,6,632,634,-1,843,844,7,-1,845,846,847,-1,845,848,846,-1,847,849,850,-1,849,851,852,-1,851,627,852,-1,853,239,854,-1,625,855,856,-1,856,623,625,-1,857,856,629,-1,857,623,856,-1,858,859,249,-1,858,860,859,-1,861,858,249,-1,249,192,861,-1,607,604,605,-1,607,615,613,-1,607,614,611,-1,607,612,603,-1,607,610,608,-1,607,609,616,-1,611,862,863,-1,864,580,612,-1,580,603,612,-1,606,865,866,-1,598,602,601,-1,598,597,602,-1,595,594,599,-1,594,600,599,-1,592,591,596,-1,596,593,592,-1,584,587,588,-1,584,586,587,-1,581,867,868,-1,869,870,862,-1,870,863,862,-1,871,870,571,-1,571,572,871,-1,871,578,577,-1,871,572,578,-1,563,540,538,-1,563,872,540,-1,873,188,185,-1,873,562,188,-1,186,874,875,-1,186,876,874,-1,543,556,544,-1,557,546,545,-1,545,544,557,-1,877,551,548,-1,877,878,551,-1,538,529,528,-1,528,542,538,-1,525,524,560,-1,560,562,525,-1,539,530,529,-1,518,533,547,-1,518,515,533,-1,533,515,520,-1,520,534,533,-1,528,531,260,-1,531,258,260,-1,513,524,527,-1,513,558,524,-1,158,879,880,-1,880,156,158,-1,881,537,523,-1,537,296,523,-1,879,158,512,-1,512,511,879,-1,882,511,509,-1,882,879,511,-1,307,309,313,-1,171,38,40,-1,171,503,38,-1,278,31,883,-1,883,884,278,-1,885,886,170,-1,170,172,885,-1,496,495,173,-1,173,499,496,-1,886,887,310,-1,310,169,886,-1,319,888,889,-1,888,331,889,-1,356,890,891,-1,489,892,320,-1,892,486,320,-1,312,483,313,-1,312,318,483,-1,893,181,894,-1,300,895,488,-1,895,489,488,-1,299,471,895,-1,895,300,299,-1,302,301,896,-1,154,897,898,-1,154,283,897,-1,305,469,303,-1,305,299,469,-1,899,306,900,-1,899,304,306,-1,306,901,902,-1,306,303,901,-1,903,904,905,-1,903,906,904,-1,907,908,909,-1,910,911,912,-1,910,111,911,-1,913,914,915,-1,913,916,914,-1,915,917,918,-1,915,914,917,-1,917,919,920,-1,917,921,919,-1,317,456,457,-1,317,314,456,-1,922,100,60,-1,922,458,100,-1,923,924,925,-1,450,926,927,-1,450,453,926,-1,928,929,930,-1,931,932,933,-1,934,452,454,-1,934,935,452,-1,934,936,937,-1,934,938,936,-1,434,939,447,-1,434,125,939,-1,940,941,942,-1,438,434,436,-1,943,944,945,-1,943,946,944,-1,947,948,435,-1,948,436,435,-1,949,431,950,-1,425,951,952,-1,425,427,951,-1,953,954,955,-1,956,426,957,-1,958,423,422,-1,958,959,423,-1,423,960,961,-1,423,962,960,-1,413,411,410,-1,415,401,408,-1,415,963,401,-1,138,964,965,-1,964,966,967,-1,964,968,966,-1,400,195,2,-1,400,397,195,-1,398,969,970,-1,394,396,971,-1,236,972,973,-1,973,974,236,-1,975,391,143,-1,976,389,385,-1,976,977,389,-1,380,386,379,-1,379,376,380,-1,978,381,979,-1,978,980,381,-1,199,981,377,-1,981,378,377,-1,982,234,983,-1,982,984,234,-1,985,986,987,-1,987,417,985,-1,243,373,346,-1,243,226,373,-1,144,988,146,-1,144,392,988,-1,371,227,150,-1,150,149,371,-1,989,987,370,-1,990,290,289,-1,289,285,990,-1,369,511,366,-1,369,509,511,-1,368,367,729,-1,367,730,729,-1,265,737,33,-1,33,32,265,-1,360,991,361,-1,991,501,361,-1,992,679,993,-1,994,995,996,-1,994,997,995,-1,14,978,12,-1,14,817,978,-1,998,999,1000,-1,998,1001,999,-1,1002,1003,1004,-1,1004,1005,1002,-1,928,1003,1006,-1,928,1007,1003,-1,619,343,345,-1,619,620,343,-1,853,854,1008,-1,1,400,2,-1,333,889,331,-1,333,1009,889,-1,1010,161,160,-1,160,1011,1010,-1,262,493,1012,-1,262,494,493,-1,767,770,1013,-1,301,488,1014,-1,301,300,488,-1,896,1014,751,-1,896,301,1014,-1,307,530,308,-1,530,1015,308,-1,888,332,331,-1,888,1016,332,-1,305,304,477,-1,477,472,305,-1,473,1017,474,-1,275,267,1018,-1,1018,251,275,-1,475,478,472,-1,285,1019,990,-1,285,284,1019,-1,278,27,502,-1,502,279,278,-1,262,264,494,-1,738,271,270,-1,502,26,39,-1,744,742,734,-1,744,740,742,-1,273,733,276,-1,731,272,1012,-1,254,253,266,-1,266,269,254,-1,272,263,262,-1,262,1012,272,-1,1020,1021,1022,-1,1020,1023,1021,-1,166,1024,164,-1,277,37,36,-1,277,279,37,-1,1020,790,1023,-1,735,252,251,-1,251,1018,735,-1,736,734,742,-1,147,205,151,-1,147,1025,205,-1,1026,1027,1028,-1,1028,1029,1026,-1,1030,1031,1032,-1,398,400,1033,-1,1034,193,249,-1,249,859,1034,-1,618,620,619,-1,628,1035,240,-1,240,239,628,-1,975,145,213,-1,984,238,233,-1,1036,1037,374,-1,447,932,448,-1,447,933,932,-1,1038,455,122,-1,122,223,1038,-1,827,665,103,-1,101,678,107,-1,101,217,678,-1,1039,940,444,-1,975,195,391,-1,975,196,195,-1,981,1037,1036,-1,1036,1040,981,-1,3,209,190,-1,3,207,209,-1,621,1041,1008,-1,1008,1042,621,-1,1043,1044,20,-1,20,19,1043,-1,630,197,17,-1,17,10,630,-1,1045,1046,988,-1,1046,1025,988,-1,195,1047,392,-1,392,391,195,-1,216,1048,214,-1,1048,1049,214,-1,1050,1051,409,-1,1051,1052,409,-1,1053,1054,972,-1,1054,973,972,-1,1055,1056,200,-1,200,202,1055,-1,832,1057,1058,-1,1058,830,832,-1,632,850,1059,-1,1059,634,632,-1,145,211,213,-1,1060,652,651,-1,665,209,208,-1,561,506,507,-1,561,1061,506,-1,1062,554,1063,-1,893,894,1064,-1,479,1065,1066,-1,479,478,1065,-1,883,500,1067,-1,883,30,500,-1,174,500,30,-1,30,29,174,-1,883,1067,1068,-1,1068,884,883,-1,886,169,170,-1,768,757,769,-1,1069,1070,287,-1,287,1071,1069,-1,161,1069,1071,-1,1071,162,161,-1,167,510,168,-1,510,1072,168,-1,512,158,1073,-1,158,157,1073,-1,513,1074,514,-1,283,280,897,-1,150,147,151,-1,150,148,147,-1,975,143,145,-1,1050,1075,421,-1,1075,960,421,-1,136,968,138,-1,968,964,138,-1,133,428,425,-1,425,134,133,-1,123,426,428,-1,595,586,585,-1,595,599,586,-1,950,1076,439,-1,439,130,950,-1,956,958,1077,-1,956,959,958,-1,1078,1079,1080,-1,1079,1081,1080,-1,1082,1083,1084,-1,456,99,121,-1,456,97,99,-1,104,808,105,-1,104,118,808,-1,911,113,807,-1,911,111,113,-1,800,802,719,-1,802,717,719,-1,99,931,120,-1,115,107,678,-1,121,122,455,-1,117,104,689,-1,299,302,469,-1,88,802,92,-1,88,717,802,-1,89,93,91,-1,91,84,89,-1,717,88,90,-1,86,89,84,-1,86,87,89,-1,75,65,1085,-1,73,76,1086,-1,1086,74,73,-1,1087,1088,1089,-1,1087,81,1088,-1,72,67,66,-1,66,73,72,-1,77,1090,69,-1,77,1091,1090,-1,77,78,81,-1,1090,75,1085,-1,82,67,68,-1,75,66,65,-1,789,64,61,-1,61,1092,789,-1,788,787,1093,-1,1093,1094,788,-1,49,48,747,-1,722,798,720,-1,722,796,798,-1,898,165,164,-1,164,1095,898,-1,482,178,1096,-1,44,181,893,-1,44,43,181,-1,35,498,36,-1,29,31,277,-1,30,883,31,-1,1016,885,891,-1,14,13,1097,-1,1097,818,14,-1,11,17,16,-1,11,10,17,-1,8,844,16,-1,8,7,844,-1,853,628,239,-1,853,626,628,-1,247,1097,1098,-1,818,1097,247,-1,990,899,1099,-1,899,990,1019,-1,905,306,902,-1,905,900,306,-1,891,172,356,-1,891,885,172,-1,418,1100,416,-1,418,1029,1100,-1,372,989,370,-1,372,1026,989,-1,1101,498,35,-1,1101,497,498,-1,1064,480,485,-1,179,480,1064,-1,485,481,487,-1,485,480,481,-1,482,282,491,-1,482,1096,282,-1,1095,1024,1102,-1,1095,164,1024,-1,727,1103,724,-1,1103,727,1104,-1,796,1105,1106,-1,1105,796,722,-1,781,1107,756,-1,781,774,1107,-1,50,52,1108,-1,52,50,49,-1,165,897,1070,-1,165,898,897,-1,67,78,68,-1,67,72,78,-1,80,1088,81,-1,80,1109,1088,-1,1089,1086,1087,-1,1086,1089,1110,-1,74,1111,79,-1,74,1112,1111,-1,1087,76,1091,-1,76,1087,1086,-1,1088,1110,1089,-1,1112,1109,1111,-1,1109,1110,1088,-1,1109,1112,1110,-1,58,117,703,-1,117,58,119,-1,800,1085,806,-1,719,1085,800,-1,94,1113,1114,-1,1113,94,801,-1,316,807,53,-1,316,911,807,-1,224,939,446,-1,1115,939,224,-1,1114,95,94,-1,1114,901,95,-1,314,97,456,-1,100,97,314,-1,1116,1084,230,-1,1116,1082,1084,-1,1081,229,1080,-1,1081,1117,229,-1,1078,958,1079,-1,1077,958,1078,-1,433,425,952,-1,433,134,425,-1,432,955,954,-1,432,429,955,-1,950,132,949,-1,132,950,130,-1,593,585,1118,-1,593,595,585,-1,586,598,587,-1,599,598,586,-1,601,292,294,-1,601,589,292,-1,428,126,123,-1,126,428,133,-1,1119,1120,1121,-1,1120,1119,1122,-1,1123,960,1075,-1,1123,961,960,-1,1050,420,1051,-1,1050,421,420,-1,1028,215,1124,-1,216,215,1028,-1,1026,1125,1027,-1,1026,372,1125,-1,510,1073,1072,-1,510,512,1073,-1,1070,280,287,-1,1070,897,280,-1,1093,1011,1126,-1,1093,787,1011,-1,1011,786,1010,-1,786,1011,787,-1,172,884,1068,-1,28,884,172,-1,769,321,991,-1,769,757,321,-1,500,323,1067,-1,500,501,323,-1,484,1064,485,-1,893,1064,484,-1,1127,1017,1065,-1,1127,474,1017,-1,180,42,1066,-1,180,43,42,-1,475,1065,478,-1,475,1127,1065,-1,565,564,183,-1,565,563,564,-1,559,507,876,-1,507,559,561,-1,506,1128,1129,-1,506,1061,1128,-1,878,532,551,-1,1130,532,878,-1,328,1131,1063,-1,1131,328,330,-1,1132,549,535,-1,553,549,1132,-1,183,1133,184,-1,183,564,1133,-1,1040,378,981,-1,1040,1134,378,-1,1098,630,10,-1,1135,630,1098,-1,13,1136,1097,-1,13,1137,1136,-1,663,1138,659,-1,663,5,1138,-1,660,1043,19,-1,660,1139,1043,-1,211,1140,212,-1,211,245,1140,-1,1034,621,622,-1,1034,1041,621,-1,654,20,1044,-1,657,20,654,-1,191,1141,1142,-1,191,189,1141,-1,855,634,1059,-1,635,634,855,-1,624,841,625,-1,836,841,624,-1,1057,837,1143,-1,832,837,1057,-1,1142,830,1058,-1,1142,1141,830,-1,1055,972,1056,-1,1055,1053,972,-1,966,973,1054,-1,1144,973,966,-1,968,1145,1146,-1,1145,968,136,-1,135,1147,1148,-1,1147,135,1121,-1,1120,406,405,-1,1120,140,406,-1,1123,414,139,-1,1123,413,414,-1,1050,411,1075,-1,1050,409,411,-1,1052,215,214,-1,1051,215,1052,-1,1149,1048,1150,-1,1149,1049,1048,-1,1045,392,1047,-1,1045,988,392,-1,203,1025,1046,-1,203,205,1025,-1,1151,194,193,-1,1151,1152,194,-1,632,198,850,-1,18,198,632,-1,833,829,831,-1,833,647,829,-1,1153,220,57,-1,221,220,1153,-1,455,919,457,-1,1038,919,455,-1,210,1154,0,-1,210,212,1154,-1,1134,376,378,-1,1134,979,376,-1,234,233,232,-1,233,234,984,-1,1155,212,1140,-1,1155,1154,212,-1,620,1151,622,-1,620,618,1151,-1,400,1156,1033,-1,1156,400,1,-1,1157,1031,970,-1,1157,1032,1031,-1,216,1027,1048,-1,216,1028,1027,-1,1150,1027,1125,-1,1150,1048,1027,-1,1023,724,1103,-1,724,1023,790,-1,1158,1022,1159,-1,1158,1020,1022,-1,286,280,282,-1,286,287,280,-1,1102,155,1095,-1,1102,1160,155,-1,276,732,785,-1,732,276,733,-1,740,743,775,-1,743,740,744,-1,772,33,739,-1,363,33,772,-1,737,263,271,-1,265,263,737,-1,1161,1162,923,-1,1162,1161,918,-1,463,1163,994,-1,460,1163,463,-1,735,744,734,-1,744,735,745,-1,895,892,489,-1,895,1164,892,-1,888,887,1016,-1,311,887,888,-1,1165,1166,1167,-1,1168,1166,1165,-1,1169,749,748,-1,749,1169,1170,-1,1009,751,1014,-1,751,1009,748,-1,1014,889,1009,-1,1014,488,889,-1,324,1067,323,-1,1068,1067,324,-1,33,365,34,-1,365,33,363,-1,728,1092,1171,-1,326,1092,728,-1,1172,1173,1174,-1,1172,1175,1173,-1,785,368,729,-1,785,732,368,-1,159,1171,167,-1,159,728,1171,-1,168,1011,160,-1,1072,1011,168,-1,730,167,1171,-1,367,167,730,-1,1071,291,162,-1,291,1071,289,-1,332,1176,334,-1,332,890,1176,-1,244,1042,245,-1,244,344,1042,-1,346,1177,347,-1,1177,346,1178,-1,1179,1180,1181,-1,1180,1179,1182,-1,929,1006,1183,-1,929,928,1006,-1,689,1005,117,-1,1005,689,1002,-1,1184,1185,1186,-1,1187,1185,1184,-1,1188,1001,998,-1,1188,1189,1001,-1,1190,999,1137,-1,1000,999,1190,-1,817,980,978,-1,817,1191,980,-1,816,1192,1193,-1,816,1194,1192,-1,1163,997,994,-1,1163,1195,997,-1,995,909,996,-1,995,1196,909,-1,1197,1198,907,-1,1197,1199,1198,-1,1200,1172,1201,-1,1200,1175,1172,-1,1186,1202,1184,-1,1186,1203,1202,-1,1155,239,242,-1,854,239,1155,-1,369,732,508,-1,368,732,369,-1,367,510,167,-1,367,366,510,-1,568,1131,1204,-1,568,1205,1131,-1,408,414,415,-1,408,406,414,-1,987,418,417,-1,418,987,989,-1,370,1206,371,-1,1206,370,1207,-1,226,211,145,-1,226,243,211,-1,1206,346,373,-1,1206,1178,346,-1,1179,986,1182,-1,1179,1207,986,-1,985,1182,986,-1,1182,985,349,-1,374,998,1000,-1,998,374,235,-1,201,983,375,-1,201,200,983,-1,979,12,978,-1,12,979,1134,-1,380,979,381,-1,380,376,979,-1,242,1154,1155,-1,242,1208,1154,-1,1,231,1156,-1,1208,231,1,-1,1156,233,238,-1,1156,231,233,-1,969,236,974,-1,236,969,237,-1,982,200,1056,-1,982,983,200,-1,1056,236,982,-1,1056,972,236,-1,1209,1053,1210,-1,1209,1054,1053,-1,1211,1212,977,-1,1210,1212,1211,-1,393,1211,1213,-1,393,1214,1211,-1,387,1215,1216,-1,387,388,1215,-1,1216,1217,396,-1,1216,1215,1217,-1,1213,396,393,-1,1213,1216,396,-1,967,1054,1209,-1,1054,967,966,-1,970,974,1157,-1,970,969,974,-1,398,237,969,-1,1033,237,398,-1,1157,1146,1032,-1,1144,1146,1157,-1,1083,967,1218,-1,1083,964,967,-1,1218,954,1083,-1,1218,395,954,-1,1082,964,1083,-1,1082,965,964,-1,1032,1145,1030,-1,1146,1145,1032,-1,399,1219,397,-1,399,1220,1219,-1,1221,1047,1219,-1,1221,1045,1047,-1,1220,1222,1223,-1,1222,1220,1030,-1,965,137,138,-1,965,1224,137,-1,953,230,1084,-1,228,230,953,-1,1045,1225,1046,-1,1225,1045,1221,-1,404,1225,1226,-1,404,403,1225,-1,1226,407,404,-1,1226,1227,407,-1,1224,1119,137,-1,1224,1228,1119,-1,1229,1230,1122,-1,1231,1230,1229,-1,1229,1117,1081,-1,1117,1229,1228,-1,401,1232,402,-1,401,963,1232,-1,412,415,410,-1,415,412,963,-1,1049,1232,1233,-1,1049,1149,1232,-1,1079,422,1231,-1,958,422,1079,-1,962,25,24,-1,1234,25,962,-1,959,957,1234,-1,956,957,959,-1,947,25,948,-1,25,947,22,-1,1234,423,959,-1,962,423,1234,-1,951,1077,1078,-1,427,1077,951,-1,1080,228,1235,-1,229,228,1080,-1,395,432,954,-1,395,394,432,-1,228,955,129,-1,228,953,955,-1,951,128,952,-1,951,1235,128,-1,431,1236,950,-1,1236,431,430,-1,438,948,957,-1,948,438,436,-1,947,1237,419,-1,947,435,1237,-1,945,985,417,-1,985,945,944,-1,993,944,946,-1,993,350,944,-1,945,1238,943,-1,1238,945,1237,-1,1236,1239,1240,-1,1241,1239,1236,-1,941,1215,942,-1,941,1217,1215,-1,382,937,383,-1,1242,937,382,-1,442,440,936,-1,440,442,441,-1,1243,941,940,-1,1239,941,1243,-1,1076,1244,1245,-1,1076,1240,1244,-1,1246,943,1238,-1,943,1246,1247,-1,1248,993,946,-1,993,1248,992,-1,1248,1249,930,-1,1249,1248,1247,-1,1246,932,1250,-1,932,1246,448,-1,1245,1251,1252,-1,1251,1245,1244,-1,1243,1039,1253,-1,1039,1243,940,-1,1254,936,938,-1,1254,442,936,-1,1242,934,937,-1,935,934,1242,-1,452,1193,1192,-1,935,1193,452,-1,938,454,449,-1,938,934,454,-1,451,1039,1254,-1,1039,451,1255,-1,1251,1256,1257,-1,1251,1253,1256,-1,1258,225,1252,-1,223,225,1258,-1,931,1250,932,-1,1250,931,1259,-1,930,1260,928,-1,930,1249,1260,-1,1261,928,1260,-1,1261,1007,928,-1,99,1259,931,-1,99,98,1259,-1,1262,1258,1257,-1,1263,1258,1262,-1,925,1256,1255,-1,925,924,1256,-1,1184,453,1187,-1,453,1184,926,-1,927,925,450,-1,925,927,923,-1,1263,1162,920,-1,1263,1262,1162,-1,458,1007,1261,-1,1007,458,922,-1,921,457,919,-1,921,317,457,-1,920,918,917,-1,918,920,1162,-1,927,462,459,-1,462,927,926,-1,1264,918,1161,-1,1264,915,918,-1,914,921,917,-1,914,1265,921,-1,315,911,316,-1,912,911,315,-1,916,1265,914,-1,916,1266,1265,-1,915,1267,913,-1,1267,915,1264,-1,1268,1267,463,-1,1267,1268,1269,-1,466,913,1270,-1,913,466,916,-1,910,1266,465,-1,912,1266,910,-1,114,910,1271,-1,114,111,910,-1,1272,1270,1269,-1,1272,1273,1270,-1,908,996,909,-1,908,1268,996,-1,1274,908,907,-1,1272,908,1274,-1,1273,1275,464,-1,1273,1276,1275,-1,1277,467,1278,-1,1271,467,1277,-1,1114,1277,1279,-1,1114,1113,1277,-1,1275,903,1278,-1,906,903,1275,-1,1276,1280,1281,-1,1280,1276,1274,-1,1198,1282,1280,-1,1198,1201,1282,-1,1281,904,906,-1,1281,1283,904,-1,1279,901,1114,-1,902,901,1279,-1,469,901,303,-1,901,469,95,-1,905,1284,900,-1,1284,905,904,-1,1285,1282,1286,-1,1285,1283,1282,-1,1286,1174,1287,-1,1172,1174,1286,-1,1288,1284,1285,-1,1284,1288,1099,-1,1099,290,990,-1,1288,290,1099,-1,290,1287,288,-1,1287,290,1288,-1,1094,1160,1102,-1,1094,1289,1160,-1,163,161,1010,-1,1069,161,163,-1,282,1290,286,-1,282,1096,1290,-1,479,42,1164,-1,479,1066,42,-1,42,892,1164,-1,42,41,892,-1,41,486,892,-1,41,484,486,-1,486,318,320,-1,487,318,486,-1,508,1012,493,-1,508,731,1012,-1,1073,514,1126,-1,1073,157,514,-1,281,491,282,-1,491,281,490,-1,319,311,888,-1,319,312,311,-1,890,1016,891,-1,890,332,1016,-1,297,264,1101,-1,297,521,264,-1,28,278,884,-1,28,27,278,-1,531,307,490,-1,531,530,307,-1,308,169,310,-1,308,171,169,-1,523,298,503,-1,298,523,296,-1,523,1291,881,-1,1291,523,522,-1,882,880,879,-1,882,516,880,-1,880,557,156,-1,880,546,557,-1,535,536,1132,-1,535,534,536,-1,1292,328,1293,-1,328,1292,329,-1,1291,327,329,-1,1291,1294,327,-1,539,1015,530,-1,539,1294,1015,-1,524,556,560,-1,524,558,556,-1,259,562,873,-1,259,525,562,-1,1130,533,532,-1,547,533,1130,-1,504,1129,570,-1,506,1129,504,-1,1295,186,875,-1,1295,187,186,-1,873,1133,541,-1,873,185,1133,-1,1205,1063,1131,-1,1063,1205,1062,-1,1296,1062,1205,-1,1296,1297,1062,-1,182,1298,1299,-1,1298,182,184,-1,578,548,575,-1,578,877,548,-1,1300,505,1301,-1,505,1300,874,-1,875,868,1295,-1,875,1302,868,-1,575,550,1303,-1,575,548,550,-1,555,1304,552,-1,1304,555,1305,-1,1306,1297,1296,-1,1307,1297,1306,-1,583,569,1299,-1,573,569,583,-1,1308,1304,1309,-1,1308,1303,1304,-1,1307,1310,1305,-1,1310,1307,1311,-1,1309,1312,1308,-1,1312,1309,1313,-1,863,871,864,-1,870,871,863,-1,571,869,1301,-1,869,571,870,-1,869,1314,1315,-1,869,862,1314,-1,1300,582,1302,-1,582,1300,1315,-1,581,1302,582,-1,1302,581,868,-1,581,1118,867,-1,581,1316,1118,-1,1317,596,591,-1,1318,596,1317,-1,594,1319,600,-1,1319,594,1320,-1,597,1321,602,-1,1321,597,1322,-1,865,1307,1306,-1,1311,1307,865,-1,1323,865,606,-1,1323,1311,865,-1,1311,1324,1310,-1,1323,1324,1311,-1,610,1313,608,-1,1312,1313,610,-1,864,611,863,-1,864,612,611,-1,862,614,1314,-1,862,611,614,-1,615,295,613,-1,293,295,615,-1,1323,609,1324,-1,609,1323,616,-1,657,617,656,-1,657,1152,617,-1,1181,342,1177,-1,340,342,1181,-1,1057,1325,1058,-1,1057,1326,1325,-1,192,653,861,-1,653,192,194,-1,858,1327,1328,-1,1327,858,861,-1,1329,859,860,-1,859,1329,1330,-1,1331,858,1328,-1,858,1331,860,-1,1331,623,857,-1,1331,1332,623,-1,1329,629,626,-1,857,629,1329,-1,1328,1332,1331,-1,1332,1328,1326,-1,856,1059,852,-1,856,855,1059,-1,628,851,1035,-1,851,628,627,-1,849,1059,850,-1,852,1059,849,-1,851,847,846,-1,849,847,851,-1,240,1333,1189,-1,240,1035,1333,-1,848,1333,846,-1,848,1334,1333,-1,847,198,845,-1,198,847,850,-1,848,631,1335,-1,631,848,845,-1,1001,1336,999,-1,1001,1334,1336,-1,1135,1336,1335,-1,1135,1136,1336,-1,1337,844,843,-1,1338,844,1337,-1,1339,1340,840,-1,1339,1341,1340,-1,1340,7,1342,-1,7,1340,843,-1,1342,6,636,-1,1342,7,6,-1,838,841,836,-1,842,841,838,-1,640,633,842,-1,633,640,839,-1,835,639,838,-1,639,835,834,-1,832,835,837,-1,835,832,831,-1,829,642,834,-1,642,829,644,-1,668,638,637,-1,1343,638,668,-1,828,647,833,-1,828,645,647,-1,1141,833,830,-1,828,833,1141,-1,1344,1058,1325,-1,1058,1344,1142,-1,1345,1346,1344,-1,1345,1347,1346,-1,653,1347,1345,-1,1347,653,655,-1,1347,1348,1349,-1,1348,1347,655,-1,1180,340,1181,-1,1180,338,340,-1,1349,5,4,-1,5,1349,1138,-1,811,661,337,-1,811,1350,661,-1,667,643,827,-1,667,641,643,-1,672,666,813,-1,672,669,666,-1,671,1341,1339,-1,823,1341,671,-1,822,1351,825,-1,822,821,1351,-1,823,1337,1341,-1,1337,823,820,-1,674,248,1338,-1,673,248,674,-1,246,818,247,-1,246,819,818,-1,819,1191,817,-1,1352,1191,819,-1,673,246,248,-1,1353,246,673,-1,1354,1352,1353,-1,1354,1355,1352,-1,353,1355,814,-1,353,355,1355,-1,824,1354,675,-1,824,1356,1354,-1,826,812,813,-1,826,809,812,-1,810,1350,811,-1,810,1357,1350,-1,1358,810,680,-1,810,1358,1359,-1,1360,678,1357,-1,1360,115,678,-1,809,686,812,-1,809,687,686,-1,1361,676,1362,-1,677,676,1361,-1,1363,1351,1364,-1,825,1351,1363,-1,683,1356,824,-1,1356,683,682,-1,815,1194,816,-1,1365,1194,815,-1,1364,1366,1363,-1,1367,1366,1364,-1,1362,691,1361,-1,694,691,1362,-1,1360,105,115,-1,106,105,1360,-1,690,1358,1368,-1,690,1359,1358,-1,1003,1368,1006,-1,1368,1003,1002,-1,1369,1367,1370,-1,1366,1367,1369,-1,684,695,681,-1,684,1371,695,-1,1185,1365,697,-1,1194,1365,1185,-1,1372,1369,1373,-1,1372,1371,1369,-1,1374,693,698,-1,1374,1370,693,-1,54,117,1005,-1,117,54,703,-1,701,221,1153,-1,698,221,701,-1,1374,1375,1373,-1,1374,700,1375,-1,1372,1376,696,-1,1372,1377,1376,-1,1203,1378,1195,-1,1378,1203,1376,-1,1375,708,1377,-1,711,708,1375,-1,1379,1195,1378,-1,1195,1379,997,-1,1380,710,1381,-1,1380,1379,710,-1,712,709,707,-1,712,1382,709,-1,705,715,706,-1,70,715,705,-1,113,109,807,-1,110,109,113,-1,1090,71,69,-1,1090,1085,71,-1,1381,1383,804,-1,1382,1383,1381,-1,803,995,1380,-1,1196,995,803,-1,1196,805,1197,-1,805,1196,803,-1,798,804,1383,-1,798,797,804,-1,713,716,723,-1,716,713,71,-1,800,112,801,-1,800,806,112,-1,799,805,797,-1,805,799,1384,-1,1200,1384,1385,-1,1200,1199,1384,-1,799,1106,1386,-1,1106,799,796,-1,795,721,718,-1,795,792,721,-1,92,94,96,-1,92,802,94,-1,90,793,795,-1,90,87,793,-1,794,1105,792,-1,794,1104,1105,-1,1385,726,1387,-1,1385,1386,726,-1,1173,1387,1388,-1,1173,1175,1387,-1,1389,793,746,-1,1389,794,793,-1,261,725,791,-1,1388,725,261,-1,791,1020,1158,-1,1020,791,790,-1,273,251,250,-1,273,275,251,-1,784,63,62,-1,63,784,783,-1,254,1022,1021,-1,254,269,1022,-1,270,773,738,-1,736,773,270,-1,1023,1389,48,-1,1023,1103,1389,-1,1023,50,1021,-1,50,1023,48,-1,750,85,1390,-1,752,85,750,-1,749,51,753,-1,749,1170,51,-1,1107,254,1108,-1,255,254,1107,-1,759,780,760,-1,759,781,780,-1,780,1168,1165,-1,780,755,1168,-1,333,1166,1169,-1,1166,333,334,-1,1176,1391,1167,-1,1391,1176,357,-1,1391,776,779,-1,758,776,1391,-1,776,778,777,-1,778,776,768,-1,778,765,764,-1,765,778,1392,-1,770,359,1013,-1,770,360,359,-1,772,1392,771,-1,765,1392,772,-1,759,740,775,-1,759,762,740,-1,773,763,766,-1,763,773,741,-1,739,765,772,-1,766,765,739,-1,767,771,1392,-1,767,1013,771,-1,364,1013,359,-1,364,771,1013,-1,991,770,769,-1,770,991,360,-1,1392,768,767,-1,778,768,1392,-1,763,761,764,-1,763,762,761,-1,357,758,1391,-1,758,357,322,-1,1167,334,1176,-1,1167,1166,334,-1,755,1170,1168,-1,755,51,1170,-1,760,1165,779,-1,760,780,1165,-1,774,255,1107,-1,256,255,774,-1,1108,1021,50,-1,254,1021,1108,-1,749,752,750,-1,752,749,753,-1,1169,1009,333,-1,748,1009,1169,-1,751,1390,896,-1,1390,751,750,-1,1390,91,470,-1,85,91,1390,-1,747,754,49,-1,747,83,754,-1,48,746,747,-1,48,1389,746,-1,743,782,257,-1,782,743,745,-1,736,741,773,-1,741,736,742,-1,782,267,266,-1,782,1018,267,-1,1159,62,1158,-1,784,62,1159,-1,731,273,250,-1,731,733,273,-1,261,1158,62,-1,791,1158,261,-1,789,1388,261,-1,1173,1388,789,-1,746,87,86,-1,746,793,87,-1,1103,794,1389,-1,1103,1104,794,-1,725,1387,726,-1,725,1388,1387,-1,1387,1200,1385,-1,1200,1387,1175,-1,727,1386,1106,-1,726,1386,727,-1,96,93,92,-1,96,468,93,-1,792,722,721,-1,792,1105,722,-1,1384,1386,1385,-1,1386,1384,799,-1,1384,1197,805,-1,1197,1384,1199,-1,71,719,716,-1,71,1085,719,-1,720,1383,714,-1,720,798,1383,-1,1381,803,1380,-1,803,1381,804,-1,1382,714,1383,-1,1382,712,714,-1,70,713,715,-1,70,71,713,-1,705,68,70,-1,82,68,705,-1,707,715,712,-1,715,707,706,-1,710,1382,1381,-1,1382,710,709,-1,1380,997,1379,-1,1380,995,997,-1,710,1378,708,-1,1378,710,1379,-1,711,707,709,-1,711,702,707,-1,706,704,705,-1,699,704,706,-1,1153,699,701,-1,704,699,1153,-1,711,700,702,-1,711,1375,700,-1,1377,1378,1376,-1,708,1378,1377,-1,696,1203,1186,-1,696,1376,1203,-1,1373,1377,1372,-1,1373,1375,1377,-1,698,700,1374,-1,698,701,700,-1,57,119,58,-1,220,119,57,-1,1370,1373,1369,-1,1374,1373,1370,-1,696,1371,1372,-1,696,695,1371,-1,1186,697,696,-1,1186,1185,697,-1,681,697,1365,-1,681,695,697,-1,1366,1371,684,-1,1366,1369,1371,-1,691,1370,1367,-1,691,693,1370,-1,692,688,219,-1,692,694,688,-1,808,222,685,-1,808,118,222,-1,690,1002,689,-1,690,1368,1002,-1,1358,1006,1368,-1,1358,1183,1006,-1,1360,690,106,-1,690,1360,1359,-1,686,694,1362,-1,688,694,686,-1,1367,1361,691,-1,1367,1364,1361,-1,1363,684,683,-1,1366,684,1363,-1,682,1365,815,-1,681,1365,682,-1,815,1356,682,-1,814,1356,815,-1,683,825,1363,-1,824,825,683,-1,1364,677,1361,-1,1351,677,1364,-1,1362,812,686,-1,676,812,1362,-1,1357,1359,1360,-1,1357,810,1359,-1,1183,680,679,-1,680,1183,1358,-1,1357,664,1350,-1,664,1357,678,-1,809,102,108,-1,809,826,102,-1,670,1351,821,-1,677,1351,670,-1,1354,814,1355,-1,1356,814,1354,-1,1354,673,675,-1,1353,673,1354,-1,819,1353,1352,-1,1353,819,246,-1,355,1352,1355,-1,355,1191,1352,-1,674,822,675,-1,674,820,822,-1,821,671,670,-1,823,671,821,-1,1339,669,671,-1,1343,669,1339,-1,666,1343,668,-1,1343,666,669,-1,650,827,643,-1,665,827,650,-1,661,664,662,-1,661,1350,664,-1,337,658,811,-1,337,336,658,-1,1138,1348,1139,-1,1138,1349,1348,-1,1348,1043,1139,-1,1348,1044,1043,-1,1180,336,338,-1,1180,351,336,-1,655,1044,1348,-1,655,654,1044,-1,1346,3,191,-1,4,3,1346,-1,861,1345,1327,-1,1345,861,653,-1,1347,4,1346,-1,1347,1349,4,-1,191,1344,1346,-1,191,1142,1344,-1,1325,1345,1344,-1,1325,1327,1345,-1,189,828,1141,-1,189,651,828,-1,650,649,652,-1,650,648,649,-1,646,643,644,-1,646,648,643,-1,642,668,637,-1,668,642,641,-1,840,1343,1339,-1,840,638,1343,-1,637,834,642,-1,637,639,834,-1,838,640,842,-1,838,639,640,-1,839,636,633,-1,839,1342,636,-1,1340,1337,843,-1,1341,1337,1340,-1,840,1342,839,-1,1340,1342,840,-1,16,1338,11,-1,1338,16,844,-1,1335,630,1135,-1,1335,631,630,-1,1136,999,1336,-1,1136,1137,999,-1,1335,1334,848,-1,1335,1336,1334,-1,197,845,198,-1,197,631,845,-1,1334,1189,1333,-1,1001,1189,1334,-1,846,1035,851,-1,846,1333,1035,-1,852,629,856,-1,629,852,627,-1,1332,624,623,-1,624,1332,1143,-1,1143,1326,1057,-1,1143,1332,1326,-1,860,857,1329,-1,860,1331,857,-1,1330,626,853,-1,626,1330,1329,-1,1326,1327,1325,-1,1326,1328,1327,-1,1034,1330,1041,-1,1330,1034,859,-1,1041,853,1008,-1,853,1041,1330,-1,347,342,345,-1,347,1177,342,-1,618,1152,1151,-1,617,1152,618,-1,339,656,617,-1,341,656,339,-1,343,1042,344,-1,343,621,1042,-1,606,616,1323,-1,616,606,604,-1,615,588,293,-1,605,588,615,-1,613,1314,614,-1,295,1314,613,-1,610,579,1312,-1,579,610,603,-1,608,1324,609,-1,1313,1324,608,-1,866,1306,574,-1,865,1306,866,-1,588,866,584,-1,606,866,588,-1,590,1321,1393,-1,602,1321,590,-1,600,1322,597,-1,1322,600,1319,-1,594,1318,1320,-1,594,596,1318,-1,1393,591,590,-1,1317,591,1393,-1,1118,583,867,-1,583,1118,585,-1,584,574,573,-1,866,574,584,-1,295,1316,581,-1,295,292,1316,-1,1315,295,582,-1,1315,1314,295,-1,1301,1315,1300,-1,1301,869,1315,-1,577,864,871,-1,577,580,864,-1,1312,576,1308,-1,576,1312,579,-1,1310,1313,1309,-1,1313,1310,1324,-1,1305,1309,1304,-1,1309,1305,1310,-1,575,1308,576,-1,1308,575,1303,-1,867,1299,1298,-1,867,583,1299,-1,574,1296,567,-1,574,1306,1296,-1,1307,555,1297,-1,1305,555,1307,-1,550,1304,1303,-1,550,552,1304,-1,868,1298,1295,-1,868,867,1298,-1,874,1302,875,-1,874,1300,1302,-1,504,1301,505,-1,504,571,1301,-1,877,572,570,-1,877,578,572,-1,184,1295,1298,-1,184,187,1295,-1,566,1299,569,-1,1299,566,182,-1,1205,567,1296,-1,567,1205,568,-1,1297,554,1062,-1,1297,555,554,-1,1204,566,568,-1,1204,565,566,-1,564,541,1133,-1,542,541,564,-1,874,507,505,-1,876,507,874,-1,543,561,556,-1,543,1061,561,-1,553,550,549,-1,550,553,552,-1,570,878,877,-1,1129,878,570,-1,547,1128,545,-1,1128,547,1130,-1,1061,545,1128,-1,543,545,1061,-1,541,259,873,-1,259,541,260,-1,540,1294,539,-1,327,1294,540,-1,881,329,1292,-1,329,881,1291,-1,537,1292,536,-1,1292,537,881,-1,1293,536,1292,-1,1293,1132,536,-1,156,558,513,-1,156,557,558,-1,1294,522,1015,-1,1294,1291,522,-1,1015,171,308,-1,171,1015,522,-1,296,520,519,-1,537,520,296,-1,492,519,517,-1,519,492,521,-1,516,546,880,-1,518,546,516,-1,492,516,882,-1,516,492,517,-1,882,493,492,-1,493,882,509,-1,258,490,281,-1,258,531,490,-1,1074,527,1289,-1,513,527,1074,-1,279,39,37,-1,279,502,39,-1,35,297,1101,-1,298,297,35,-1,265,1101,264,-1,1101,265,32,-1,495,365,362,-1,496,365,495,-1,361,495,358,-1,361,173,495,-1,361,174,173,-1,521,494,264,-1,521,492,494,-1,483,491,313,-1,483,482,491,-1,1093,1289,1094,-1,1093,1074,1289,-1,1072,1126,1011,-1,1126,1072,1073,-1,487,483,318,-1,487,481,483,-1,1290,178,177,-1,178,1290,1096,-1,1017,181,180,-1,473,181,1017,-1,476,177,475,-1,476,1290,177,-1,476,286,1290,-1,286,476,284,-1,1019,304,899,-1,1019,477,304,-1,163,1070,1069,-1,163,165,1070,-1,1024,786,788,-1,166,786,1024,-1,288,1174,325,-1,288,1287,1174,-1,1286,1288,1285,-1,1288,1286,1287,-1,1201,1286,1282,-1,1286,1201,1172,-1,904,1285,1284,-1,1285,904,1283,-1,468,95,469,-1,468,96,95,-1,1282,1281,1280,-1,1281,1282,1283,-1,1280,907,1198,-1,1280,1274,907,-1,1276,906,1275,-1,1281,906,1276,-1,1278,1279,1277,-1,903,1279,1278,-1,1271,1113,114,-1,1277,1113,1271,-1,1278,464,1275,-1,467,464,1278,-1,1276,1272,1274,-1,1273,1272,1276,-1,908,1269,1268,-1,908,1272,1269,-1,464,1270,1273,-1,464,466,1270,-1,465,1271,910,-1,467,1271,465,-1,1266,466,465,-1,1266,916,466,-1,1269,913,1267,-1,913,1269,1270,-1,994,1268,463,-1,994,996,1268,-1,463,1264,461,-1,463,1267,1264,-1,1266,315,1265,-1,1266,912,315,-1,317,1265,315,-1,1265,317,921,-1,1161,461,1264,-1,1161,459,461,-1,926,1202,462,-1,1202,926,1184,-1,923,459,1161,-1,459,923,927,-1,1261,97,458,-1,1261,98,97,-1,920,1038,1263,-1,919,1038,920,-1,1192,453,452,-1,453,1192,1187,-1,453,449,454,-1,453,450,449,-1,1255,450,925,-1,450,1255,451,-1,924,1257,1256,-1,924,1262,1257,-1,1263,223,1258,-1,223,1263,1038,-1,98,1260,1259,-1,98,1261,1260,-1,1259,1249,1250,-1,1249,1259,1260,-1,1257,1252,1251,-1,1252,1257,1258,-1,1255,1253,1039,-1,1253,1255,1256,-1,938,451,1254,-1,938,449,451,-1,354,935,1242,-1,1193,935,354,-1,444,1254,1039,-1,1254,444,442,-1,1253,1244,1243,-1,1253,1251,1244,-1,1252,445,1245,-1,225,445,1252,-1,1115,447,939,-1,447,1115,933,-1,1247,1250,1249,-1,1250,1247,1246,-1,1248,929,992,-1,930,929,1248,-1,1247,946,943,-1,946,1247,1248,-1,1238,448,1246,-1,1238,437,448,-1,1245,439,1076,-1,1245,445,439,-1,1243,1240,1239,-1,1240,1243,1244,-1,443,940,942,-1,940,443,444,-1,383,936,440,-1,383,937,936,-1,1242,352,354,-1,352,1242,382,-1,443,384,441,-1,388,384,443,-1,942,388,443,-1,942,1215,388,-1,1241,941,1239,-1,941,1241,1217,-1,950,1240,1076,-1,1240,950,1236,-1,439,126,131,-1,439,124,126,-1,435,1238,1237,-1,437,1238,435,-1,944,349,985,-1,944,350,349,-1,419,945,417,-1,419,1237,945,-1,957,123,438,-1,957,426,123,-1,1241,430,971,-1,1241,1236,430,-1,431,127,429,-1,431,949,127,-1,432,971,430,-1,432,394,971,-1,1235,1078,1080,-1,1235,951,1078,-1,427,956,1077,-1,427,426,956,-1,948,1234,957,-1,948,25,1234,-1,24,960,962,-1,24,421,960,-1,420,1100,1124,-1,23,1100,420,-1,419,22,947,-1,22,419,416,-1,1081,1231,1229,-1,1081,1079,1231,-1,412,1052,1233,-1,409,1052,412,-1,1233,963,412,-1,1233,1232,963,-1,1149,402,1232,-1,1149,204,402,-1,1228,1116,1117,-1,1228,1224,1116,-1,1228,1122,1119,-1,1122,1228,1229,-1,1148,1227,1222,-1,1227,1148,1147,-1,405,1227,1147,-1,405,407,1227,-1,408,404,407,-1,408,401,404,-1,1223,1227,1226,-1,1223,1222,1227,-1,402,203,403,-1,402,204,203,-1,403,1046,1225,-1,403,203,1046,-1,1226,1221,1223,-1,1226,1225,1221,-1,1224,1082,1116,-1,1224,965,1082,-1,1145,1222,1030,-1,1148,1222,1145,-1,1223,1219,1220,-1,1223,1221,1219,-1,1047,397,1219,-1,1047,195,397,-1,1220,1031,1030,-1,1031,1220,399,-1,954,1084,1083,-1,954,953,1084,-1,1209,1218,967,-1,1218,1209,1214,-1,970,399,398,-1,970,1031,399,-1,973,1157,974,-1,973,1144,1157,-1,1214,395,1218,-1,1214,393,395,-1,976,1216,1213,-1,976,387,1216,-1,1217,971,396,-1,1241,971,1217,-1,977,1213,1211,-1,976,1213,977,-1,1210,1214,1209,-1,1210,1211,1214,-1,1210,1055,1212,-1,1053,1055,1210,-1,1212,202,390,-1,202,1212,1055,-1,238,1033,1156,-1,238,237,1033,-1,238,982,236,-1,984,982,238,-1,231,1188,232,-1,231,241,1188,-1,196,0,2,-1,210,0,196,-1,199,390,202,-1,199,377,390,-1,390,977,1212,-1,977,390,389,-1,387,385,384,-1,976,385,387,-1,980,382,381,-1,382,980,352,-1,375,1037,201,-1,374,1037,375,-1,1036,1000,1190,-1,1036,374,1000,-1,998,232,1188,-1,232,998,235,-1,1207,1178,1206,-1,1178,1207,1179,-1,987,1207,370,-1,1207,987,986,-1,373,371,1206,-1,371,373,227,-1,1004,1007,922,-1,1004,1003,1007,-1,1338,820,674,-1,1338,1337,820,-1,359,362,364,-1,359,358,362,-1,1176,356,357,-1,890,356,1176,-1,1203,1163,1202,-1,1203,1195,1163,-1,1201,1199,1200,-1,1198,1199,1201,-1,907,1196,1197,-1,909,1196,907,-1,1187,1194,1185,-1,1192,1194,1187,-1,353,1193,354,-1,353,816,1193,-1,1191,352,980,-1,1191,355,352,-1,1189,241,240,-1,241,1189,1188,-1,992,1183,679,-1,992,929,1183,-1,348,993,679,-1,350,993,348,-1,1182,351,1180,-1,1182,349,351,-1,1178,1181,1177,-1,1178,1179,1181,-1,347,344,244,-1,347,345,344,-1,340,335,341,-1,340,338,335,-1,872,327,540,-1,872,330,327,-1,477,284,476,-1,284,477,1019,-1,1171,61,730,-1,1171,1092,61,-1,291,326,728,-1,288,326,291,-1,1289,526,1160,-1,1289,527,526,-1,785,274,276,-1,783,274,785,-1,1174,789,325,-1,1173,789,1174,-1,326,789,1092,-1,789,326,325,-1,356,1068,324,-1,356,172,1068,-1,886,1016,887,-1,1016,886,885,-1,896,470,302,-1,470,896,1390,-1,1168,1169,1166,-1,1170,1169,1168,-1,779,1167,1391,-1,1165,1167,779,-1,488,319,889,-1,319,488,320,-1,310,311,309,-1,310,887,311,-1,471,1164,895,-1,471,479,1164,-1,1317,1320,1318,-1,1393,1320,1317,-1,1393,1319,1320,-1,1393,1322,1319,-1,1322,1393,1321,-1,745,1018,782,-1,745,735,1018,-1,460,1202,1163,-1,462,1202,460,-1,1262,923,1162,-1,1262,924,923,-1,285,1071,287,-1,285,289,1071,-1,1160,153,155,-1,1160,526,153,-1,153,281,283,-1,281,153,258,-1,1159,269,268,-1,1159,1022,269,-1,257,775,743,-1,257,256,775,-1,1125,206,1150,-1,152,206,1125,-1,214,1233,1052,-1,214,1049,1233,-1,248,11,1338,-1,248,9,11,-1,1208,241,231,-1,1208,242,241,-1,1140,854,1155,-1,854,1140,1008,-1,234,375,983,-1,375,234,235,-1,1025,146,988,-1,1025,147,146,-1,129,1235,228,-1,1235,129,128,-1,424,1231,422,-1,424,1230,1231,-1,704,57,59,-1,1153,57,704,-1,1150,204,1149,-1,204,1150,206,-1,1075,413,1123,-1,1075,411,413,-1,406,139,414,-1,406,140,139,-1,1121,405,1147,-1,1121,1120,405,-1,136,1148,1145,-1,136,135,1148,-1,968,1144,966,-1,968,1146,1144,-1,199,1037,981,-1,201,1037,199,-1,836,1143,837,-1,836,624,1143,-1,841,855,625,-1,841,635,855,-1,194,657,654,-1,194,1152,657,-1,622,193,1034,-1,193,622,1151,-1,1008,245,1042,-1,245,1008,1140,-1,975,210,196,-1,210,975,213,-1,659,1139,660,-1,659,1138,1139,-1,5,208,207,-1,5,663,208,-1,15,1137,13,-1,15,1190,1137,-1,1135,1097,1136,-1,1098,1097,1135,-1,1040,1190,15,-1,1040,1036,1190,-1,190,651,189,-1,190,1060,651,-1,1293,1063,554,-1,1293,328,1063,-1,1132,554,553,-1,554,1132,1293,-1,551,535,549,-1,551,532,535,-1,1204,330,872,-1,1204,1131,330,-1,1129,1130,878,-1,1129,1128,1130,-1,188,876,186,-1,876,188,559,-1,1133,187,184,-1,187,1133,185,-1,1204,563,565,-1,1204,872,563,-1,177,1127,475,-1,177,176,1127,-1,41,893,484,-1,44,893,41,-1,1065,180,1066,-1,1065,1017,180,-1,176,474,1127,-1,176,46,474,-1,179,175,480,-1,179,47,175,-1,499,29,277,-1,499,173,29,-1,321,501,991,-1,501,321,323,-1,498,277,36,-1,498,499,277,-1,1126,1074,1093,-1,1074,1126,514,-1,1010,166,163,-1,1010,786,166,-1,1095,154,898,-1,154,1095,155,-1,372,152,1125,-1,372,149,152,-1,142,146,148,-1,142,144,146,-1,1051,1124,215,-1,1051,420,1124,-1,139,961,1123,-1,139,141,961,-1,1122,140,1120,-1,140,1122,1230,-1,137,1121,135,-1,1121,137,1119,-1,589,1316,292,-1,589,592,1316,-1,294,598,601,-1,598,294,587,-1,1316,593,1118,-1,592,593,1316,-1,949,433,127,-1,433,949,132,-1,129,429,127,-1,955,429,129,-1,952,127,433,-1,128,127,952,-1,230,1117,1116,-1,229,1117,230,-1,933,120,931,-1,933,1115,120,-1,316,100,314,-1,316,53,100,-1,703,59,58,-1,56,59,703,-1,446,125,124,-1,446,939,125,-1,1115,122,120,-1,224,122,1115,-1,114,801,112,-1,114,1113,801,-1,65,806,1085,-1,110,806,65,-1,59,109,82,-1,56,109,59,-1,115,808,116,-1,808,115,105,-1,83,752,754,-1,83,85,752,-1,81,1091,77,-1,1091,81,1087,-1,72,80,78,-1,72,79,80,-1,74,1110,1112,-1,74,1086,1110,-1,79,1109,80,-1,79,1111,1109,-1,1091,75,1090,-1,1091,76,75,-1,268,784,1159,-1,268,274,784,-1,922,55,1004,-1,922,60,55,-1,55,1005,1004,-1,55,54,1005,-1,49,753,51,-1,49,754,753,-1,1108,756,1107,-1,756,1108,52,-1,775,781,759,-1,775,774,781,-1,1104,1106,1105,-1,1104,727,1106,-1,788,1102,1024,-1,1094,1102,788,-1,1064,45,179,-1,1064,894,45,-1,473,894,181,-1,473,45,894,-1,38,37,39,-1,38,35,37,-1,497,32,34,-1,1101,32,497,-1,1029,1124,1100,-1,1028,1124,1029,-1,1026,418,989,-1,1026,1029,418,-1,416,23,22,-1,416,1100,23,-1,903,902,1279,-1,903,905,902,-1,900,1099,899,-1,900,1284,1099,-1,1230,141,140,-1,1230,424,141,-1,652,190,209,-1,652,1060,190,-1,1134,15,12,-1,1134,1040,15,-1,1098,9,247,-1,1098,10,9,-1,424,961,141,-1,423,961,424,-1,0,1208,1,-1,1154,1208,0,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lfemur_Coord',point=[(2.47444,15.93905,-1.3421),(2.46394,15.93483,-1.25226),(2.40079,15.87257,-1.49738),(4.23845,16.93095,-1.84263),(4.10047,16.93686,-1.94174),(3.98351,17.14044,-1.71109),(3.69758,16.1514,-.15255),(3.72484,16.28852,-.13205),(3.65704,16.27415,-.06206),(3.45132,16.71548,.13267),(3.42844,16.60096,.12581),(3.52276,16.66232,.11868),(2.61747,16.73661,-.31207),(2.83952,16.69649,-.21121),(2.8311,16.77455,-.21137),(2.60947,16.67926,-.30501),(3.61065,16.43909,.05593),(3.53817,16.42257,.08351),(3.61489,16.25247,.03046),(3.42967,17.01308,-1.7169),(3.51058,16.8358,-1.92342),(3.41747,16.87574,-1.79708),(2.1918,17.18051,-1.9187),(2.21158,17.15411,-2.04013),(2.08841,17.14471,-2.09324),(2.04795,17.19862,-1.95704),(4.29151,30.86767,-1.18238),(4.38865,30.89803,-1.20111),(4.34173,30.91048,-1.21096),(4.4132,31.37626,-1.11832),(4.40866,31.26413,-1.17211),(4.44645,31.26442,-1.14545),(4.52705,31.44613,-.59891),(4.71033,31.4897,-.57654),(4.55838,31.46111,-.66611),(4.23409,31.17318,-.79101),(4.37391,31.2248,-.89934),(4.38519,31.12278,-.91855),(4.19685,30.95083,-.83591),(4.364,30.88667,-.9757),(4.06247,30.83775,-.98798),(3.4403,29.50512,-1.53629),(3.42318,29.39365,-1.51882),(3.39821,29.41559,-1.51215),(3.40561,29.50325,-1.51682),(3.28469,29.63737,-1.37803),(3.20492,29.65829,-1.26079),(3.22584,29.70377,-1.28409),(4.7382,29.13469,-.56539),(4.80054,29.50106,-.82676),(4.82643,29.49536,-.57109),(4.7124,29.85436,-1.24667),(4.93437,29.78141,-.84447),(3.57058,21.33717,-.98562),(3.55793,20.29949,-1.01766),(3.41041,20.30532,-1.0023),(3.68721,21.28558,-.96876),(3.708,20.28365,-.96892),(3.68673,20.29296,-1.02321),(3.71876,21.28262,-.95551),(3.31804,20.32557,-.98928),(4.12322,29.90651,-.14964),(4.47921,29.91637,-.2078),(4.36728,30.27741,-.15151),(4.18186,29.52204,-.1347),(3.88716,23.54708,-.95804),(3.90736,23.55214,-.92713),(3.90733,23.42002,-.92091),(3.93339,23.42051,-.88143),(3.95044,23.54832,-.85991),(4.13003,23.55182,-.57935),(4.21755,24.56781,-.56715),(3.91179,23.44299,-.90992),(3.90306,23.54849,-.91102),(3.89924,23.56125,-.90448),(3.92063,23.57701,-.90964),(3.92039,23.56578,-.90313),(3.93752,23.55291,-.86863),(3.92653,23.44326,-.88748),(3.89468,23.55644,-.88845),(3.90654,23.55679,-.87059),(3.92387,23.56234,-.86713),(3.81777,22.41068,-.97678),(4.646,29.17633,-.92876),(4.49361,28.89203,-1.03879),(4.51213,29.19822,-1.11047),(4.6184,28.85547,-.91226),(4.59517,28.19548,-.93677),(4.38058,27.30395,-1.0089),(4.45288,28.20847,-1.04386),(4.46514,27.28918,-.96267),(4.43916,28.90815,-1.08667),(4.30898,27.31785,-1.03294),(4.3608,28.21902,-1.09524),(4.08582,26.34668,-.98992),(4.03158,27.35048,-.97647),(4.16024,27.34042,-1.0079),(2.87539,19.50655,-1.11389),(2.66094,18.74891,-1.2397),(2.5533,18.7611,-1.24528),(3.22339,20.3478,-.9869),(3.96967,17.37842,-1.33191),(3.9895,17.37914,-1.3041),(4.03398,17.24943,-1.34983),(3.64258,18.66659,-1.1544),(3.74088,18.12683,-1.19466),(3.63427,18.13467,-1.20989),(3.89886,17.56028,-1.29787),(3.92109,17.56412,-1.27393),(3.78848,22.41252,-.99078),(3.8683,23.54792,-.98254),(3.77778,23.56122,-.95237),(3.9068,24.61684,-.97899),(3.80261,23.55691,-.97874),(3.87971,24.62191,-.96027),(3.81303,17.83699,-1.23642),(3.84372,17.834,-1.21683),(3.64045,19.44532,-1.09505),(3.67719,18.66606,-1.14425),(3.67086,19.44758,-1.07916),(2.28459,18.29061,-1.36938),(2.51807,18.76214,-1.22942),(2.25908,18.29123,-1.34604),(1.67582,17.45985,-1.92494),(1.89005,17.64824,-1.64827),(1.91976,17.64882,-1.66685),(1.66419,17.4757,-1.90504),(1.3505,17.09776,-1.82343),(1.36198,17.00903,-1.94797),(1.33371,16.90018,-1.89545),(1.5552,17.39529,-1.69416),(1.58169,17.43872,-1.81863),(1.47686,17.3474,-1.7714),(1.61895,17.46515,-1.91432),(1.50673,17.38799,-1.8879),(1.58462,15.96476,-2.24399),(1.57631,15.83846,-1.97721),(1.5901,16.05878,-2.21874),(1.55972,15.94328,-1.94259),(1.84376,16.88942,-2.7145),(1.80483,16.65331,-2.77727),(1.8315,16.90037,-2.67099),(2.39124,16.07006,-1.74585),(2.39951,15.93008,-1.60474),(2.36556,15.97022,-1.81026),(2.45295,16.02463,-1.56378),(2.34677,16.08175,-2.06926),(2.37734,16.15345,-2.17826),(2.38734,16.20758,-1.99492),(2.35528,16.6119,-2.18423),(2.33255,16.37736,-2.04842),(2.36935,16.32576,-2.30235),(2.4213,16.60372,-2.35624),(3.13296,30.52859,-.64466),(3.25971,30.23281,-.57842),(3.28315,30.24746,-.55606),(3.46243,30.84218,-.20056),(3.57508,30.61352,-.21952),(3.59629,30.64246,-.21297),(3.68139,29.84614,-.20181),(3.66752,29.87987,-.18346),(3.49726,29.49685,-.25241),(3.51096,29.46309,-.26005),(3.39624,29.62055,-.43685),(3.3761,29.73826,-.52212),(3.35516,29.72369,-.52931),(3.41563,29.66737,-.44095),(3.80495,30.29007,-.14234),(3.77697,30.27134,-.13577),(4.0398,30.8263,-1.01511),(4.27328,30.85037,-1.19684),(3.84712,31.02327,-.98606),(4.3341,30.9186,-1.23563),(4.39393,31.40945,-1.10027),(4.3957,31.40587,-1.1295),(3.22183,29.72977,-1.2486),(3.20056,29.65758,-1.22044),(3.26674,29.6686,-1.07691),(3.27691,29.82824,-1.08831),(3.29538,29.74215,-1.35392),(3.32958,29.30222,-1.44084),(3.33657,29.4697,-1.46256),(2.69723,31.10501,-1.30323),(2.77182,31.02029,-1.31173),(2.59855,31.00044,-1.09295),(2.63288,30.95996,-.61532),(2.67242,31.02941,-.30442),(2.60276,30.95761,-.61314),(2.69984,31.02277,-.31764),(4.32463,16.69736,-1.90434),(4.25305,16.91006,-1.82344),(4.33223,16.70236,-1.93306),(3.47686,16.15822,-1.85237),(3.37357,16.17595,-1.78251),(3.53366,16.40237,-1.99),(2.34846,15.79997,-1.64407),(2.42902,15.90532,-1.51962),(3.51916,16.40613,.11064),(3.59059,16.23594,.03751),(1.99712,16.33369,-.5063),(1.9226,16.02841,-.65048),(2.00086,16.28897,-.4937),(1.90194,16.05331,-.66921),(2.44381,16.27819,-2.51606),(2.51834,16.59432,-2.54306),(2.43388,16.28843,-2.48648),(2.52032,16.59515,-2.50939),(4.19422,17.03625,-1.60334),(4.17364,17.03631,-1.56374),(4.21116,17.0244,-1.56979),(2.48586,15.94348,-1.43672),(2.68462,16.05045,-1.31181),(2.67354,16.02622,-1.29333),(2.49372,15.95932,-1.47379),(2.4299,17.10672,-2.1099),(2.41234,17.10286,-2.07589),(2.42968,17.08843,-2.08188),(3.82866,17.34931,-1.40692),(3.92886,17.23101,-1.46773),(3.88448,18.62498,-.80584),(3.72021,19.44725,-.97527),(3.86814,19.45301,-.75654),(3.80058,18.64618,-1.01586),(2.20644,18.25502,-1.24793),(2.11668,17.9911,-1.44327),(2.06222,17.97485,-1.38366),(2.51512,16.24993,-1.52765),(2.37648,16.4471,-1.69076),(1.35993,16.69931,-1.95562),(1.37656,16.60763,-2.08601),(1.36035,16.53028,-2.0276),(2.54687,15.98887,-.91478),(2.51457,16.07499,-.67967),(2.41545,15.98472,-.81373),(2.35418,16.04296,-.63552),(2.47177,16.25123,-.48542),(1.91299,15.85161,-1.03869),(2.04294,15.78219,-1.11102),(2.18902,15.89847,-.98875),(3.0403,16.02935,-.95976),(2.96466,16.02255,-.77523),(2.72374,16.04232,-.81671),(2.7765,16.01998,-1.03343),(2.71044,16.21381,-1.33091),(2.91583,16.25084,-1.24809),(2.85143,16.08649,-1.18466),(3.17392,16.87202,.03468),(3.17645,16.77529,.02752),(3.46307,16.806,.11554),(3.46067,16.0897,-1.80387),(4.76706,31.20227,-.15402),(4.8191,30.80812,-.17237),(4.91344,30.93512,-.22782),(5.10905,30.02101,-.24381),(4.99299,29.79119,-.35456),(5.14703,29.95334,-.35363),(5.19645,30.14417,-.40344),(5.13199,30.22354,-.3764),(3.16995,30.55,-.79106),(2.99119,30.82209,-.61675),(3.00413,30.87493,-.94744),(4.23459,29.15905,-.11875),(4.31604,31.33217,-.17605),(4.52107,31.46325,-.1924),(4.25497,31.35178,-.43866),(4.5222,31.43272,-.40029),(5.0167,30.14944,-.12427),(4.90064,30.45152,-.11717),(4.80548,30.36218,-.11042),(4.92891,29.94338,-.19132),(4.87633,31.32088,-.22176),(4.74737,31.47378,-.23668),(4.64574,31.35985,-.12459),(4.63981,31.02516,-.06072),(4.69776,30.66618,-.15837),(4.75823,30.72282,-.13513),(4.57718,30.94972,-.04509),(4.48047,31.27117,-.98209),(4.46307,31.11021,-1.1769),(4.46883,31.09616,-1.03148),(3.31727,29.88545,-.70807),(3.2786,30.25526,-.75129),(3.31549,29.91069,-.76041),(3.24611,30.22194,-.61442),(3.3808,29.53534,-.79286),(3.35836,29.41519,-.71712),(3.33527,29.68102,-.79214),(3.32743,29.62861,-.65837),(3.60291,29.11969,-.32708),(3.42806,29.24303,-.48042),(3.47221,29.06097,-.47669),(3.54739,29.27039,-.30813),(2.46244,31.9814,-.69561),(2.51068,32.10051,-.82581),(2.50299,32.06405,-.86438),(2.51232,32.08409,-.59592),(3.86356,31.45372,-.67815),(4.01285,31.37365,-.62355),(3.99224,31.30764,-.70829),(3.61999,28.96221,-1.18085),(3.73772,29.26572,-1.38112),(3.87946,29.24111,-1.28925),(3.87528,28.97036,-1.22874),(3.79139,28.28539,-1.0022),(3.54648,28.94604,-.91732),(3.57564,28.95638,-1.04596),(3.70198,28.29487,-.9215),(3.44284,30.43884,-.9945),(3.65877,30.74936,-1.04844),(3.63017,30.31047,-1.07316),(3.77293,30.5505,-1.067),(3.87353,30.23778,-1.20846),(3.72821,30.05559,-1.23713),(3.49297,30.07045,-1.08085),(3.18788,20.35646,-.97645),(3.30777,21.41869,-.86035),(3.53576,21.34911,-.97813),(3.00237,20.3544,-.92602),(3.58127,29.92397,-1.26911),(3.83346,29.99436,-1.38865),(3.6843,29.83794,-1.38574),(4.59077,31.39928,-1.43127),(4.60895,31.25145,-1.42199),(4.46548,31.32253,-1.31988),(4.45925,31.18241,-1.35257),(3.78965,29.15911,-.21647),(3.76437,29.40047,-.23359),(3.29811,31.28807,-1.366),(3.40587,31.63291,-1.49285),(3.43951,31.55697,-1.2985),(3.2434,31.31622,-1.4801),(4.16286,30.11826,-1.42853),(4.25745,30.37097,-1.45305),(4.3208,30.08408,-1.43791),(4.38953,30.32251,-1.49182),(3.34146,16.88646,-1.66082),(3.21844,17.03707,-1.56034),(3.36927,17.07373,-1.62378),(3.21184,16.89821,-1.55303),(3.32465,16.52053,-1.61018),(3.19705,16.72534,-1.53963),(3.3475,16.70118,-1.67539),(3.18637,16.60465,-1.46969),(3.1916,16.21989,-1.34512),(3.145,16.27332,-1.24392),(3.17744,16.41712,-1.34593),(2.76286,16.4925,-1.44948),(2.94911,16.44863,-1.36227),(3.04732,17.18619,-1.49068),(2.85697,17.06737,-1.63962),(2.87169,17.2315,-1.55569),(3.03555,17.05797,-1.5798),(2.64273,17.21549,-.35322),(2.87923,17.4475,-.24276),(2.66725,17.4236,-.32298),(2.85006,17.22593,-.23144),(4.40086,30.92361,-1.43193),(4.54263,30.90691,-1.4789),(4.47175,31.68217,-1.13104),(4.60439,31.72515,-1.20816),(4.59677,31.61715,-1.36756),(4.43354,31.50612,-1.28871),(4.55887,31.6777,-.89592),(4.74946,31.60515,-.75368),(4.68966,31.72653,-.96588),(4.6032,31.51485,-.76905),(3.93961,30.5471,-.11969),(3.98066,30.51444,-.12025),(4.17195,30.77695,-.00265),(4.1425,30.87985,-.0318),(2.43144,16.79668,-1.86914),(2.35992,16.61899,-1.81041),(2.37088,16.84447,-2.16578),(2.54802,16.44356,-1.57426),(2.41508,16.43779,-.38584),(2.27307,16.27241,-.45484),(2.21985,16.73372,-.45985),(1.9817,16.54411,-.48596),(2.19157,16.61625,-.42828),(1.9973,16.69621,-.49282),(2.25881,16.98409,-.50488),(2.46458,17.0008,-.43345),(2.49326,17.21409,-.42569),(2.29243,17.23395,-.46437),(1.92974,17.02144,-.56084),(1.8901,16.85477,-.54636),(2.09001,16.98909,-.50871),(1.7323,16.918,-.68158),(1.79086,17.05983,-.71343),(1.79201,16.60683,-.61241),(1.81397,16.40123,-.6278),(2.35428,15.83454,-1.64563),(2.33853,15.86586,-1.86979),(1.47888,16.67679,-1.03802),(1.39992,16.84346,-1.22528),(1.38816,16.61513,-1.28638),(1.55027,16.87981,-.95924),(2.23541,15.74632,-1.67054),(2.10825,15.71594,-1.37286),(2.01815,15.70892,-1.68632),(2.33163,15.79787,-1.47179),(2.2612,16.622,-2.74335),(2.38678,16.60721,-2.67026),(2.33334,16.2551,-2.6093),(2.18797,16.27602,-2.66106),(1.75273,16.35306,-2.71429),(1.8346,16.65059,-2.79217),(1.91664,16.29115,-2.71664),(2.01023,16.64789,-2.77711),(2.17003,17.19071,-2.2622),(2.03282,17.13394,-2.54092),(1.98736,17.15038,-2.43601),(2.24427,17.11592,-2.46041),(1.91728,17.10072,-2.5356),(1.87013,16.90507,-2.73378),(2.06454,16.9239,-2.70771),(2.35585,17.12452,-1.86717),(2.52659,17.07465,-1.72816),(2.43606,17.05974,-1.86051),(2.36603,17.1673,-1.75835),(2.25147,17.15202,-2.12011),(2.13078,17.16243,-2.19106),(1.68263,17.04281,-2.42266),(1.77418,17.08548,-2.39673),(1.77395,16.92748,-2.58211),(1.5022,17.31969,-2.00515),(1.64767,17.33995,-1.98226),(1.53498,17.26741,-2.08244),(1.6296,17.43803,-1.95764),(1.31931,16.9319,-1.65632),(1.40196,17.02862,-1.3953),(1.40672,17.11162,-1.58467),(1.34157,16.83818,-1.46896),(1.41869,17.29145,-1.86154),(2.03822,17.62429,-1.69051),(2.21833,17.32951,-1.73755),(2.03081,17.37936,-1.79982),(2.25839,17.60611,-1.63773),(1.88742,17.42037,-1.86837),(1.839,17.62803,-1.58038),(2.17697,17.2494,-.4922),(2.04072,17.28717,-.56223),(2.11484,17.49241,-.54381),(1.92281,17.29024,-.67091),(2.01622,17.53246,-.6975),(1.95047,17.79713,-1.48627),(2.00297,17.79574,-1.53529),(2.13054,17.79578,-1.57909),(2.29137,17.79135,-1.57885),(2.37067,18.04715,-.41932),(2.42904,18.59653,-.37112),(2.25821,18.04765,-.48792),(2.57919,17.98552,-.29587),(2.64928,18.5525,-.24264),(2.48509,17.99782,-.34235),(2.43941,18.7561,-1.13665),(2.83905,19.51216,-1.1062),(2.69771,19.48952,-1.00953),(3.00312,19.49346,-1.09829),(2.70857,20.23679,-.25938),(3.03416,21.31686,-.09115),(2.97674,21.33324,-.16744),(2.84159,20.17556,-.12604),(3.23039,22.41985,-.0529),(3.36664,24.72098,-.52362),(3.39974,23.66182,-.6336),(3.28104,23.6653,-.46322),(3.49951,24.69988,-.66125),(4.14793,28.22308,-1.08183),(3.88961,28.26543,-1.05193),(4.14161,28.93117,-1.18464),(3.54149,29.09547,-1.26716),(3.48283,29.21143,-1.07746),(3.28029,29.48694,-1.38885),(3.2411,29.47469,-1.30069),(3.35021,29.48335,-1.08533),(3.40187,29.57294,-.93303),(3.49429,29.25182,-.91489),(3.3871,29.23864,-1.19898),(3.44693,29.15969,-1.35453),(3.31711,29.78728,-1.34136),(3.36672,29.83471,-1.25221),(3.30819,29.91525,-1.02366),(3.46321,29.97653,-1.12074),(3.39785,29.67213,-1.4698),(3.37531,29.75631,-1.40865),(3.49582,29.7,-1.45117),(3.42607,29.77648,-1.347),(3.89993,29.65167,-1.36734),(3.7525,29.61485,-1.4413),(3.31335,30.28858,-.8882),(3.3307,30.01832,-.98183),(3.98467,31.30814,-.18686),(4.18109,31.12418,-.10743),(4.128,31.29364,-.17726),(4.42371,31.54967,-.97564),(4.45111,31.41878,-.84787),(4.41253,31.39373,-.78503),(4.37348,31.24579,-.90244),(4.46609,31.29252,-.97417),(4.39813,31.28437,-1.19401),(4.45289,31.35699,-1.31118),(4.43399,30.86054,-1.06993),(3.93923,31.17475,-.91025),(3.02913,31.53651,.11846),(2.83359,31.37007,.07316),(3.11692,31.40665,.0755),(2.95076,31.24882,-.01346),(4.29953,31.03135,.00026),(4.03446,30.96615,-.09864),(3.76982,30.33303,-.14165),(3.85405,30.65282,-.13618),(3.69953,30.4225,-.17492),(3.32024,30.66313,-.31491),(3.41828,30.41359,-.29619),(3.71509,31.55713,-.27023),(3.69178,31.2305,-.19961),(3.83799,31.40714,-.23604),(3.58516,31.39045,-.16482),(3.88028,31.43891,-.45875),(3.71307,31.60115,-.55476),(4.0154,31.34431,-.44644),(3.71808,31.22227,-1.0303),(3.78897,31.31526,-.92687),(3.11204,30.87258,-.31926),(3.01882,30.81678,-.43367),(3.19772,30.55883,-.50124),(3.2529,30.58081,-.40321),(3.04972,30.9363,-1.05061),(3.12672,30.98792,-1.14949),(3.28782,30.68423,-1.02021),(3.20931,30.57141,-.93745),(3.60835,31.92196,-.22319),(3.65079,31.72304,-.25827),(3.67444,31.82756,-.54352),(3.71039,32.0622,-.50804),(3.64471,31.83597,-.75386),(3.70736,31.62833,-.6835),(3.02678,31.02384,-1.2909),(3.18083,31.01909,-1.17318),(3.12957,31.09858,-1.30206),(2.87241,30.97972,-1.04869),(2.93881,31.00405,-1.19979),(3.18944,31.29072,.00752),(3.22677,31.24904,-.08604),(3.35661,31.36216,-.03836),(3.44367,31.20856,-.14588),(3.51138,31.54134,-.10352),(3.54829,32.10204,-.1502),(3.71346,32.09727,-.50397),(3.61878,32.2495,-.52233),(3.60865,31.95775,-.20756),(3.63889,32.27239,-.97601),(3.70834,32.1516,-.90728),(3.59505,32.05794,-1.31069),(3.51542,32.1404,-1.35045),(3.06988,31.09551,-.13532),(3.32402,31.06495,-.1801),(3.19266,30.94189,-.26684),(2.83252,31.10338,-.15947),(2.94501,30.9667,-.22889),(2.97036,31.23443,-.03846),(2.85647,30.91511,-.39486),(2.89962,31.06277,-1.36705),(2.78872,31.01552,-1.28571),(2.88665,31.06963,-1.39769),(2.82862,31.16926,-1.46016),(2.93307,31.50248,-1.61287),(3.02964,31.32873,-1.5649),(2.71684,31.32433,-1.45514),(3.19095,31.69506,.12544),(2.90214,31.84136,.07626),(3.04079,31.95213,.05079),(2.60513,31.60669,-1.42308),(2.81397,31.84148,-1.52278),(3.35681,32.28433,-.17201),(3.14344,32.40591,-.30176),(3.0416,32.25465,-.12653),(3.17102,32.05677,.01135),(2.95457,32.41098,-.44348),(2.9025,32.3851,-.38933),(2.36999,31.64926,-.62693),(2.43218,31.71496,-.3722),(2.46287,31.52231,-1.23344),(2.54238,31.91419,-1.23571),(2.44418,31.65086,-1.14265),(2.50981,31.87358,-1.15094),(2.5101,32.07122,-.99003),(2.57469,32.14812,-1.05636),(2.4675,31.95706,-.73045),(2.48257,31.93113,-.73245),(2.47744,31.7251,-.79245),(2.4004,31.72369,-.7627),(2.39924,31.6259,-.95689),(2.48706,31.72859,-.98118),(2.44567,31.67315,-1.1101),(2.48924,31.70517,-.90123),(2.54467,31.93562,-.93866),(2.50392,32.04246,-.96984),(2.50483,31.85684,-1.11849),(2.51171,31.80319,-1.02124),(2.49951,32.0246,-.86535),(2.53274,31.95556,-.82987),(2.83825,32.38556,-.54983),(2.67177,32.28753,-.939),(2.61859,32.2316,-.85694),(2.66915,32.22703,-1.10391),(2.69415,32.29939,-.71231),(2.8761,32.4334,-.84916),(2.83026,32.40527,-.91465),(2.8825,32.43987,-.6977),(2.68069,32.2752,-.50156),(2.75398,32.32884,-.48108),(2.60045,32.21554,-.67325),(2.63013,32.23548,-.54955),(2.5665,32.19357,-.76324),(2.75964,32.35542,-.94789),(3.45533,16.42112,-1.83511),(3.35004,16.26033,-1.7026),(3.27344,16.37616,-1.50698),(3.26905,16.21856,-1.53998),(3.21142,16.07696,-1.34103),(3.27931,16.09106,-1.57923),(3.9237,15.74336,-1.10065),(4.09924,15.79892,-1.07763),(4.00339,15.81855,-.93053),(3.4182,15.88097,-1.09434),(3.46844,15.81507,-.71554),(3.25157,15.88435,-.89514),(3.60631,15.77626,-.96547),(3.40461,16.56493,.13336),(3.36795,16.38213,.06229),(3.67464,16.06163,-.1749),(3.88013,16.0262,-.64524),(3.75133,15.9537,-.40539),(3.84609,15.91844,-.68173),(3.76824,16.08859,-.38857),(4.16464,16.42036,-.91477),(4.06404,16.43358,-.79379),(4.10346,16.17946,-.99344),(4.01178,16.18169,-.83936),(4.26568,16.6776,-1.0388),(4.25391,16.44234,-1.05549),(4.31095,16.68656,-1.17416),(4.27496,16.44695,-1.18997),(4.2572,16.48285,-1.54744),(4.25354,16.50426,-1.41242),(4.24007,16.33788,-1.42509),(4.2755,16.68606,-1.41695),(4.2539,16.70299,-1.6697),(4.26797,16.79068,-1.41395),(4.27132,16.71232,-1.80516),(4.22041,16.86761,-1.68491),(3.74043,16.35928,-2.08454),(3.5687,16.63729,-2.0398),(3.72794,16.66969,-2.07644),(3.47457,16.66784,-1.84037),(3.55941,16.62914,-2.00647),(3.2086,17.15528,-1.45226),(3.84561,17.15716,-1.6911),(3.61382,17.12811,-1.71209),(3.5741,17.18642,-1.56369),(3.81718,17.25337,-1.54587),(3.96453,17.14,-1.67169),(3.78675,17.34273,-1.43678),(4.18724,17.02972,-1.40038),(4.12992,16.9607,-.91238),(4.20072,16.97347,-1.04404),(4.17622,16.66283,-.91917),(4.02868,16.94648,-.77663),(3.87625,17.24706,-.57303),(3.88822,16.95642,-.5878),(3.98868,17.27966,-.79661),(3.47808,16.99829,.08401),(3.58114,16.95959,.055),(3.5012,17.22374,.03388),(3.95417,17.48465,-.78643),(3.87053,17.45221,-.57016),(3.78398,17.54802,-1.29795),(3.12093,17.53075,-1.35763),(3.26989,17.52733,-1.3525),(3.25231,17.97965,.00437),(3.22083,17.71184,-.02659),(3.4568,17.68487,-.0031),(3.49709,17.98082,-.02449),(3.89403,18.10067,-1.04173),(3.95245,17.79486,-.91375),(3.95014,17.81568,-1.04106),(3.93042,18.05441,-.85681),(3.56847,18.65985,-1.13155),(3.495,18.13726,-1.21205),(3.88669,18.03892,-.55348),(3.88619,18.613,-.62198),(3.89134,18.58223,-.50176),(3.94522,18.04026,-.72049),(3.27457,18.5243,.01254),(3.31735,19.29066,.0235),(3.20708,18.53009,-.01029),(3.94367,19.42404,-.47074),(4.05534,21.2277,-.33186),(3.96182,20.13338,-.24154),(3.98848,20.15734,-.43258),(4.06485,21.20779,-.1854),(3.65543,20.2966,-1.03651),(3.98901,21.22879,-.64631),(4.06832,22.36663,-.5759),(4.1647,22.33004,-.17994),(4.14705,22.3199,-.10282),(3.81942,21.21358,.08055),(4.11241,22.33591,.00035),(3.92287,22.34478,.10921),(4.00359,21.20803,-.06766),(4.25388,23.5524,-.11453),(4.35497,24.54952,-.24723),(4.35356,24.55632,-.12255),(4.26585,23.52945,-.18099),(4.31975,25.41673,-.61909),(4.23963,26.32904,-.97084),(4.51177,26.31753,-.7303),(4.06141,25.41499,-.93545),(4.40064,25.48072,-.13387),(4.54716,26.34342,-.39274),(4.53785,26.36089,-.1852),(4.43049,25.42499,-.28645),(4.53779,28.84698,-.17923),(4.45189,28.8503,-.1543),(4.45328,28.26668,-.10471),(4.53267,28.23608,-.21009),(3.72878,29.61677,-.21689),(4.29942,30.5643,-.09208),(4.0706,30.29848,-.13402),(4.46971,31.14024,.01006),(4.34753,30.90742,.03663),(4.54043,31.028,.00428),(5.10777,30.85251,-.37952),(5.0066,30.73047,-.33504),(5.05365,31.05634,-.25647),(4.71012,31.43687,-.40738),(4.902,31.4518,-.30901),(4.96479,31.4655,-.46166),(5.28209,30.68751,-.48464),(5.1853,30.95575,-.41312),(5.16011,30.9027,-.38015),(5.16775,30.46822,-.47814),(5.21947,30.65051,-.46285),(5.10152,30.55487,-.42642),(4.75032,28.81829,-.7831),(4.76447,29.15797,-.77592),(4.42016,29.79949,-1.34865),(4.5274,29.75667,-1.29138),(4.38634,29.52998,-1.26559),(4.21908,29.58166,-1.30592),(4.59749,29.49545,-1.15566),(4.65281,29.67491,-1.20056),(4.69606,29.49826,-.99137),(4.83055,30.10035,-1.2609),(5.04125,29.93732,-.87284),(4.811,31.38319,-1.38496),(4.78008,31.21453,-1.41063),(5.19287,30.47075,-.90443),(5.0317,30.59978,-1.2391),(5.10222,30.88222,-1.13183),(5.19869,30.75934,-.81103),(5.16032,31.09178,-.68618),(5.09693,31.21425,-.95388),(5.06392,31.41593,-.91074),(5.05851,31.30951,-.58359),(4.91252,31.51207,-1.23194),(4.96467,31.32319,-1.25752),(4.81243,31.42205,-1.38846),(4.75182,31.59912,-1.33531),(4.86869,31.70373,-.96468),(4.91153,31.65849,-.79121),(5.11769,31.14387,-.34321),(5.17571,30.13469,-.59295),(5.24042,30.37834,-.53236),(4.98267,31.11716,-1.29976),(5.04013,31.00106,-1.2402),(5.0456,31.27108,-1.1634),(4.96791,30.66512,-1.31236),(4.91681,30.2677,-1.28206),(5.10722,30.13934,-.88945),(5.03211,30.37498,-.31639),(4.56603,30.54136,-.15471),(4.63318,30.30284,-.1767),(4.43875,30.75564,-.0558),(3.51095,29.72282,-.296),(3.59581,30.00193,-.24085),(3.5052,29.84825,-.32319),(3.94472,29.14729,-.13334),(4.57877,29.13648,-.20535),(4.49994,29.14692,-.16433),(4.67267,27.25196,-.52327),(4.74099,28.18248,-.82902),(4.69534,28.19305,-.58824),(4.64159,27.25872,-.86642),(4.44755,26.39569,-.07029),(4.23308,25.53061,.05974),(4.35325,25.49914,-.03028),(4.35797,26.43049,.04531),(4.04139,25.41722,-.96618),(3.99869,25.42868,-.98002),(4.20324,26.33178,-.99628),(3.92623,24.6626,.14929),(4.1209,24.65702,.11295),(4.04472,25.57734,.13652),(3.94539,24.61656,-.96965),(3.72165,22.41283,-.98569),(3.77318,18.13158,-1.17437),(3.97027,17.52004,-1.07543),(3.43211,17.52947,-1.33561),(3.39145,17.20582,-1.48758),(3.9709,17.49403,-.94903),(4.03299,17.30902,-.9399),(3.03212,17.45549,-.12455),(3.06231,17.69422,-.10249),(2.8774,17.6928,-.18941),(2.8229,16.85263,-.21166),(3.00024,16.7781,-.08533),(2.99996,16.86862,-.09566),(3.70854,16.94216,-.13209),(3.79076,17.20976,-.3715),(3.67287,17.21807,-.17569),(3.80501,16.93888,-.39886),(3.48722,17.44425,.0032),(3.6816,17.46003,-.16527),(4.02458,17.35448,-1.1211),(4.22658,16.9963,-1.20301),(4.31823,16.43616,-1.72797),(4.21554,16.18934,-1.22866),(4.39446,16.12065,-1.71774),(4.24428,16.06038,-1.31004),(4.28767,15.91072,-1.42043),(4.29413,16.22032,-1.55645),(4.19077,16.16773,-1.14345),(4.17725,16.01308,-1.16773),(4.10316,15.82723,-1.0663),(4.20473,15.84243,-1.19471),(4.09781,15.9731,-1.02506),(3.90764,16.21013,-.61445),(3.93663,16.43388,-.60408),(4.01213,15.84843,-.92551),(4.00767,15.96733,-.87667),(3.7387,16.44271,-.10647),(3.69046,16.45358,.00708),(3.38667,16.21972,-.04711),(3.28808,16.00267,-.304),(3.46795,16.02209,-.21464),(3.21286,16.23119,-.13741),(3.5254,15.88989,-.37117),(3.65935,16.02964,-.18167),(3.37765,15.86742,-.48853),(3.61193,15.8158,-.54298),(3.23986,16.0049,-1.12512),(3.06961,16.06332,-1.0301),(3.83613,15.88776,-.6891),(3.77649,15.78753,-.81965),(3.72782,15.76808,-1.18107),(3.68545,15.95637,-1.80445),(3.37316,15.97618,-1.54197),(3.6165,15.84586,-1.49165),(3.73102,16.11408,-1.97185),(2.645,32.1342,-.30357),(2.7414,32.19448,-.26305),(2.81167,32.28959,-.31053),(2.83795,32.15454,-1.34531),(2.70313,32.0579,-1.32487),(2.38475,31.44418,-1.00754),(2.37327,31.37791,-.63198),(2.68386,31.93474,-.09914),(2.79232,32.06374,-.0743),(2.93308,32.13945,-.04918),(3.09961,31.14408,-1.43758),(2.81335,30.94615,-.62607),(2.69683,31.22258,-.05988),(2.59743,31.1018,-.27457),(2.80935,31.11546,-.13838),(3.35448,31.87917,.03535),(3.44049,31.7192,.00637),(3.67247,30.79705,-.15789),(3.54874,31.00786,-.17691),(3.62269,31.57277,-1.01392),(3.86707,31.10253,-.16905),(4.40904,31.24156,-1.18385),(4.4005,31.13636,-1.19692),(4.25772,30.67333,-1.33482),(4.18332,30.71405,-1.22549),(4.00353,30.44875,-1.18716),(3.99415,30.17939,-1.36882),(4.05787,29.90295,-1.4004),(4.33653,30.62544,-1.46036),(4.27902,30.66035,-1.40788),(3.58579,29.5435,-1.51874),(3.36151,29.64331,-1.45564),(3.33091,29.64095,-1.42486),(3.68861,29.28201,-1.42221),(4.01168,29.24507,-1.24576),(3.31037,29.88075,-.67254),(3.3287,29.89383,-.59641),(3.52208,28.93485,-.80729),(3.63143,28.30491,-.80466),(3.99483,27.35495,-.9538),(3.84599,27.36776,-.87974),(3.64953,26.45868,-.7457),(3.57121,27.39431,-.56419),(3.68598,27.38189,-.78184),(3.49237,26.49284,-.57352),(3.69812,25.57755,.06202),(3.55079,24.68581,.00099),(3.62534,24.70078,.05635),(3.66561,23.58531,-.8448),(3.6877,22.41792,-.9745),(3.49526,22.48124,-.85024),(3.10834,22.51603,-.36617),(2.90076,21.41965,-.48085),(2.89904,21.40567,-.40575),(3.13012,22.51828,-.45611),(2.65891,20.3637,-.59693),(2.63132,20.33369,-.51368),(2.52556,19.47716,-.86141),(2.4357,19.47244,-.76306),(2.75267,20.37807,-.73528),(3.16167,19.46875,-1.07349),(2.41205,19.40627,-.54704),(2.23026,18.70342,-.7217),(2.26346,18.67781,-.60858),(2.73885,19.28352,-.16588),(2.52847,19.34182,-.34674),(3.01201,18.21312,-1.27085),(2.96403,17.92462,-1.32603),(2.86077,17.9276,-1.3616),(2.40953,18.28377,-1.37363),(2.33233,17.97334,-1.50199),(2.22344,17.98115,-1.47633),(2.40051,17.64603,-.39404),(2.54694,17.64565,-.35097),(2.26363,17.46698,-.46387),(2.33712,17.42904,-.4476),(2.32765,17.66462,-.44276),(2.03307,17.7962,-1.55597),(1.97514,17.54928,-.76199),(1.80749,17.33331,-.8469),(1.8643,17.30524,-.76062),(2.60331,17.58305,-1.54425),(2.72366,17.25074,-1.60647),(2.55636,17.2613,-1.64228),(2.76039,17.57064,-1.46981),(2.18615,17.24255,-1.80634),(2.02517,17.28303,-1.83769),(1.44139,17.23948,-1.72705),(1.57775,17.30395,-1.59329),(1.4506,17.13565,-2.0806),(1.41419,17.21731,-2.00427),(1.32283,16.62421,-1.76519),(1.3156,16.58661,-1.53936),(1.3027,16.73889,-1.72607),(1.66323,17.31318,-2.04293),(1.84969,17.31221,-1.90809),(1.57732,17.17969,-2.28179),(1.67459,17.21242,-2.19408),(1.94414,17.13252,-2.34783),(1.85008,17.07124,-2.46897),(1.90938,17.12856,-2.20235),(2.28229,16.91928,-2.63279),(1.49053,16.02131,-1.66098),(1.47678,16.07264,-1.92206),(1.53765,15.849,-1.41043),(1.50222,16.0491,-1.38971),(1.56196,15.81439,-1.69186),(1.93402,15.72136,-1.26247),(1.90315,15.69675,-1.36754),(1.45473,16.95473,-1.1735),(1.71682,15.88881,-.96368),(1.61749,15.89048,-1.14008),(1.79233,15.80325,-1.21885),(2.44311,15.92912,-1.54491),(1.68861,16.76774,-.69947),(1.67111,16.53373,-.75639),(2.6256,16.79398,-.31922),(2.42182,16.73916,-.38677),(2.63567,17.02521,-.34146),(2.17963,16.53387,-.41161),(2.08318,15.94608,-.75639),(2.13784,16.0346,-.62457),(2.29643,15.97942,-.76672),(2.69641,17.08371,-1.69269),(2.66197,16.9676,-1.71123),(2.5044,16.95888,-1.79471),(2.3366,15.95003,-2.14131),(2.43928,16.96886,-1.87143),(3.45815,29.23466,-.71834),(4.58838,31.43576,-1.43547),(2.92183,17.66541,-1.38887),(2.90788,17.54932,-1.42714),(3.43662,22.46737,.07408),(3.59099,23.64664,.08243),(3.51138,23.60444,.05062),(3.51037,22.41447,.0882),(2.62647,16.2978,-.4591),(2.82359,16.50273,-.27572),(2.60048,16.50029,-.34044),(2.87951,16.31619,-.42904),(3.36873,18.65948,-1.14194),(3.22193,18.65927,-1.16071),(3.29708,19.41152,-1.07679),(3.45355,19.42632,-1.08028),(3.1775,18.16223,-1.2177),(3.05958,18.71608,-1.16765),(3.11091,16.08449,-1.12817),(4.25289,29.87429,-1.37052),(3.50273,29.68706,-.2793),(3.6093,30.0267,-.20818),(4.38127,31.23348,-.08418),(4.81157,31.68439,-1.17637),(4.05381,29.62375,-1.33094),(3.52675,30.97223,-1.11467),(4.15701,30.40847,-1.3558),(3.28011,29.34035,-1.3738),(4.93605,30.56457,-.2415),(3.47565,29.24324,-.81666),(4.63624,29.37629,-.22486),(4.83184,29.50442,-.38712),(4.76626,29.706,-.23301),(4.71902,29.1114,-.35431),(3.41463,29.76741,-.45637),(2.40749,16.10394,-2.34821),(2.39971,16.99389,-2.06593),(2.42869,17.01897,-2.18018),(2.40204,17.07087,-2.06421),(2.40743,17.05415,-2.00985),(1.79694,15.74794,-2.00262),(1.82979,15.71015,-1.69435),(1.76355,15.73782,-1.69595),(2.18762,15.77911,-1.19117),(3.27245,16.06031,-1.59115),(3.14466,15.94621,-.66129),(2.40858,16.59691,-.34286),(2.17638,16.48391,-.39993),(2.35214,18.75017,-1.05886),(2.0575,17.74138,-.72561),(2.40943,16.62918,-.3625),(3.20578,16.04641,-1.34379),(3.12076,16.10498,-1.15468),(3.45153,17.0189,-1.75456),(3.52004,16.85669,-1.95161),(2.34299,15.91928,-2.15407),(2.41158,16.07943,-2.37246),(2.34517,15.83233,-1.88077),(2.50297,17.02361,-2.28025),(2.5021,17.04959,-2.2958),(2.15362,17.19065,-2.2289),(2.27386,17.1747,-2.15421),(2.29168,17.17938,-2.18329),(1.69497,15.9109,-.95536),(1.59704,15.91759,-1.13357),(1.78733,15.93704,-.82449),(1.81196,15.91437,-.83037),(4.2984,15.88022,-1.43433),(4.40132,16.10115,-1.74079),(3.73884,15.92308,-.40516),(4.23554,16.88704,-1.74831),(3.13246,31.38595,.05423),(3.37005,31.73147,-1.55157),(3.39911,31.64764,-1.52442),(3.34643,29.71829,-1.40863),(3.28381,29.30083,-1.3532),(3.34505,29.25647,-1.43489),(4.40911,31.24843,-1.20204),(4.3939,31.14362,-1.21898),(3.38278,29.45625,-.43364),(3.32024,29.64022,-.62337),(3.38607,29.41886,-.43722),(3.75769,30.31669,-.14106),(3.68404,30.40857,-.17646),(3.40705,30.38696,-.32425),(1.97765,17.14918,-2.39497),(1.75617,17.515,-1.3943),(1.548,17.22914,-2.18533),(1.46086,17.06068,-2.20883),(1.48791,16.97452,-2.33067),(1.42002,16.83395,-2.1649),(1.4699,16.72643,-2.28697),(1.38243,16.24597,-1.87062),(1.3629,16.28053,-1.61176),(1.34155,16.41576,-1.82439),(3.9645,24.61587,-.94014),(3.91533,23.56623,-.89986),(3.93061,23.56648,-.87696),(3.90057,23.62178,-.86273),(3.90471,23.625,-.87568),(3.94181,23.57733,-.87813),(3.93567,23.56603,-.88023),(3.97914,29.68069,-.17733),(3.5587,30.15085,-.24482),(3.47778,30.03728,-.35391),(3.34693,29.92504,-.57821),(3.3088,29.85014,-.97458),(3.00078,16.68757,-.07521),(3.1746,16.67914,.03266),(3.49906,28.92366,-.69712),(2.35755,17.09703,-1.98706),(4.31665,31.36106,-.66095),(3.39916,29.96327,-.48917),(4.67868,28.806,-.35604),(4.61418,28.20548,-.31514),(4.62398,27.30234,-.23457),(4.53267,27.35008,-.12874),(5.10647,29.93769,-.61741),(4.96974,29.77864,-.60109),(3.88643,23.61725,-.86554),(3.89495,23.62484,-.89032),(3.87675,23.61696,-.88012),(3.88047,23.62089,-.89321),(3.96935,25.43385,-.96305),(4.05314,26.3532,-.96973),(2.14313,17.98887,-1.46279),(1.40323,16.35795,-2.08769),(1.43521,16.51266,-2.2045),(2.38244,31.59345,-.95697),(1.63245,16.20959,-2.41476),(1.72802,16.36963,-2.69897),(1.63233,16.11037,-2.48507),(1.69357,16.44357,-2.5771),(1.88931,17.08777,-2.50852),(2.37595,17.09191,-2.05398),(2.42481,16.85886,-2.30053),(3.56571,30.18111,-.21861),(3.23844,29.46308,-1.26624),(3.25508,31.53524,.06725),(3.24521,31.56152,.08894),(3.44743,31.68859,-.01166),(3.23185,31.32436,-1.50947),(3.70221,32.11751,-.90369),(2.62665,31.00085,-1.09618),(2.41556,16.68417,-.37459),(3.16665,16.64219,.04334),(2.98981,16.65151,-.06594),(2.83474,16.65942,-.20012),(3.85714,17.15504,-1.7304),(3.61976,17.12823,-1.75245),(2.8424,16.06491,-1.16013),(4.37604,16.40823,-1.87259),(4.38316,16.40265,-1.9021),(4.20002,15.81606,-1.20525),(1.56059,15.8237,-1.40669),(1.60041,15.81464,-1.98438),(1.58671,15.7907,-1.6947),(1.65396,16.0913,-2.49735),(1.60686,15.94217,-2.25338),(2.51584,16.88422,-2.48089),(2.51681,16.86969,-2.45133),(3.37362,16.20318,-1.75796),(3.52515,16.41523,-1.95654),(3.93267,20.233,-.69658),(2.63742,16.00417,-1.2206),(2.81292,16.05329,-1.10392),(2.35317,15.93036,-1.04479),(1.71645,15.76765,-1.40061),(4.57294,29.56614,-.188),(4.69413,29.98634,-.18195),(3.31087,30.26954,-.50232),(2.64726,20.28371,-.387),(2.41113,19.45136,-.6898),(3.28022,21.3173,.06528),(3.59578,29.33877,-1.48151),(4.80225,30.34298,-1.39907),(4.60382,30.22444,-1.47528),(4.66815,30.45476,-1.50334),(4.71483,30.1624,-1.36803),(4.523,29.96915,-1.39401),(4.6214,29.90894,-1.31924),(3.91793,29.9993,-.15705),(3.85417,28.3135,-.12311),(3.9499,28.87317,-.10408),(3.79933,28.86599,-.18591),(3.95986,28.31332,-.07783),(4.45414,30.59969,-1.49712),(2.97589,16.6195,-1.49233),(2.79279,16.66191,-1.57593),(2.82091,16.80559,-1.65079),(3.02842,16.92336,-1.58831),(2.9937,16.75481,-1.57207),(2.84966,16.95671,-1.65404),(3.16128,17.86793,-1.27253),(2.92313,19.24086,-.08438),(2.97302,18.56234,-.09161),(3.05442,19.30288,-.03531),(2.79617,18.50924,-.1737),(2.70627,16.1075,-.65697),(2.91099,16.12272,-.59777),(2.6088,16.64501,-.28783),(2.84514,17.05288,-.22115),(2.70777,18.00552,-.24402),(2.6839,17.661,-.28431),(2.9027,18.00472,-.15492),(3.37708,21.30667,.08103),(3.67881,24.70018,.07314),(3.78626,25.64031,.09108),(3.77532,26.47472,.01849),(3.90745,26.49142,.07348),(3.97525,27.44859,-.0063),(3.86455,27.4098,-.06609),(3.07944,20.12825,-.01556),(3.20072,20.16875,.01334),(3.09322,31.15542,-1.46961),(3.18954,31.48379,-1.57168),(2.59777,16.63646,-1.67177),(2.64164,16.81509,-1.72783),(2.61062,15.98159,-1.11955),(1.56554,16.14144,-1.09498),(1.63015,16.19077,-.93102),(1.57981,16.46212,-.8882),(1.70781,16.25114,-.78268),(1.58101,16.72365,-.84783),(1.4799,16.42368,-1.08342),(1.7273,17.09606,-.82687),(1.63612,16.89956,-.8211),(1.6728,17.12811,-.92561),(1.39759,16.35399,-1.34786),(2.20576,15.76778,-1.93807),(2.02882,15.73712,-1.96789),(2.22463,15.87187,-2.20444),(1.80388,15.88372,-2.26116),(2.05965,15.84407,-2.2458),(1.52613,16.17756,-2.19627),(2.26887,16.03563,-2.4582),(2.124,16.02214,-2.48723),(1.8425,16.05802,-2.51429),(1.56097,16.32692,-2.33945),(1.58838,16.52717,-2.44999),(1.73729,16.72034,-2.63363),(1.60584,16.7879,-2.50237),(2.40868,16.90731,-2.56429),(2.38515,17.0878,-2.39383),(1.87047,17.20382,-2.04982),(1.41151,16.9367,-2.02885),(1.56646,17.23368,-1.34508),(2.37357,17.27884,-1.69657),(2.42573,17.58485,-1.603),(1.72695,17.38836,-1.06049),(1.73153,17.47236,-1.23978),(1.60356,17.17815,-1.13514),(2.51821,17.40821,-.39348),(1.87852,17.60081,-.99647),(1.86732,17.66457,-1.16563),(1.9003,17.71173,-1.31771),(2.45892,17.77932,-1.55587),(2.63205,17.76079,-1.4905),(2.8058,17.71935,-1.42725),(2.68748,17.95775,-1.42921),(2.49072,17.97245,-1.49055),(1.96946,17.85421,-1.09468),(2.00988,17.91113,-1.23434),(1.98272,17.82228,-.94259),(2.17948,17.67992,-.53874),(2.13167,18.08112,-.67835),(2.0867,18.12389,-.86433),(2.09064,18.1652,-.97286),(2.13442,18.20072,-1.10846),(2.55271,18.27442,-1.38081),(2.74273,18.24028,-1.34048),(2.82213,18.724,-1.20555),(2.22132,18.71889,-.85304),(2.25341,18.74002,-.95674),(2.92119,21.39131,-.28403),(3.03254,21.42712,-.6677),(3.24763,22.50599,-.62162),(3.14907,22.47779,-.21902),(3.41202,23.61705,-.02131),(3.31407,23.65596,-.20771),(3.27289,23.68248,-.39488),(3.76648,24.66727,-.8739),(3.43533,24.71652,-.16755),(3.36377,24.73018,-.42812),(3.54179,25.58742,-.17173),(3.42835,25.58212,-.55853),(3.43501,25.59049,-.4617),(3.8412,25.44074,-.8829),(3.57415,25.5398,-.71325),(3.89239,26.40976,-.88),(3.6318,26.46498,-.18026),(3.50581,26.50538,-.45304),(3.71743,27.40553,-.21943),(3.56954,27.39347,-.46623),(3.55843,28.28595,-.59991),(3.55768,28.27919,-.48942),(3.70432,28.31002,-.26088),(3.6423,28.87663,-.3058),(3.51897,28.87891,-.47375),(3.36946,30.31405,-.38882),(3.32171,29.74574,-.93104),(3.51763,31.44943,-1.16065),(3.55705,31.73919,-1.11621),(3.59327,32.0305,-1.29611),(3.37335,31.22427,-1.2599),(2.53015,31.02496,-.60611),(3.10821,31.67336,-1.63028),(3.27044,31.86191,-1.60072),(2.52126,31.09637,-1.0448),(2.6121,31.20844,-1.2665),(2.57477,31.51356,-.08098),(2.72248,31.67563,.04892),(2.46584,31.40332,-.27979),(3.42683,32.43856,-.59439),(3.44047,32.4472,-.97043),(3.31758,32.31094,-1.32997),(2.97266,31.96984,-1.56275),(3.12963,32.11957,-1.52255),(3.25192,32.49264,-.60559),(3.21441,32.49161,-.93944),(3.11368,32.41843,-1.18313),(2.95829,32.2597,-1.3171),(3.04311,32.4874,-.65493),(3.02528,32.49687,-.88253),(2.56476,32.08226,-.40281),(2.51888,31.79532,-.22252),(2.38257,31.71047,-.73658),(2.51708,31.73342,-.83217),(2.51853,31.72103,-.8885),(2.54264,31.76098,-.91864),(2.52985,31.73667,-.91407),(2.55103,31.79328,-.86176),(2.55373,31.79127,-.88894),(2.8279,32.34236,-1.14375),(2.9735,32.44763,-1.04694),(4.18934,16.0496,-1.88994),(4.1201,15.84595,-1.6448),(3.98152,16.05641,-1.952),(3.94865,15.85524,-1.7225),(3.51145,15.86536,-1.2471),(3.32916,15.97194,-1.31729),(3.82438,15.77646,-1.43185),(4.03345,15.77955,-1.33528),(3.09345,16.05335,-.45807),(3.02532,16.27782,-.28772),(3.18414,16.41801,-.03551),(3.00186,16.46908,-.15585),(3.73615,16.69151,-.12838),(3.63549,16.69057,.06014),(3.9094,16.66447,-.57539),(3.81642,16.46624,-.34322),(3.81566,16.6779,-.38392),(3.80016,16.24618,-.35824),(4.06827,16.66908,-.79523),(4.21154,16.35961,-2.04064),(3.98118,16.36369,-2.08394),(4.16315,16.70034,-2.04864),(3.93823,16.68422,-2.07997),(3.70599,16.89987,-1.98156),(3.92608,16.91955,-1.98926),(3.55489,17.24815,-1.49539),(3.79671,17.44566,-.37299),(3.00385,17.04381,-.11461),(3.18762,17.02467,.02511),(3.18714,17.23152,-.01016),(3.0157,17.22277,-.11587),(3.19917,17.45031,-.03967),(3.5449,17.52818,-1.33994),(3.28707,17.85992,-1.26683),(3.45955,17.85259,-1.26775),(3.58974,17.85049,-1.26896),(3.88798,17.7406,-.5477),(3.95195,17.77297,-.73838),(3.69822,17.69747,-.17766),(3.79313,17.71491,-.34141),(3.09425,17.99171,-.06276),(3.71594,17.99731,-.19302),(3.80677,17.99716,-.3351),(3.30541,18.16786,-1.21425),(3.70539,18.52178,-.13452),(3.81343,18.57234,-.31018),(3.543,18.50775,-.00511),(3.58931,19.31105,.00714),(3.78003,19.33264,-.14341),(3.8901,19.34929,-.30497),(3.85677,20.1441,-.08327),(3.45527,20.13709,.08135),(3.64747,20.1316,.06667),(3.61225,21.25302,.12693),(3.73303,22.36542,.135),(3.84096,23.60709,.14594),(4.01359,23.60946,.11747),(4.21596,23.55924,-.03284),(4.31956,24.58598,-.02041),(4.14273,26.47191,.10527),(4.21539,27.44028,.03445),(4.44299,27.39782,-.02239),(4.20026,28.31302,-.05261),(4.20444,28.87752,-.09103),(4.72902,28.80965,-.58252),(4.25313,29.22845,-1.21937),(4.72672,30.83117,-1.49002),(5.00415,31.45363,-1.11188),(2.54189,31.77989,-.84381)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BonesLeftFemur.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BonesLeftFemur.py load and self-test diagnostics complete.")
