####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BonesHead.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interchange',version='3.3',
  head=head(
    children=[
    meta(content='BonesHead.x3d',name='title'),
    meta(content='Damon Hernandez, Joe Williams',name='creator'),
    meta(content='Human bone model for Head',name='description'),
    meta(content='Joe Williams, Don Brutzman',name='translator'),
    meta(content='5 December 2013',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesHead.x3d',name='identifier'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BonesHead.x3d'),
    Transform(DEF='HeadSkeletonParts',scale=(0.029,0.029,0.029),
      children=[
      Viewpoint(DEF='Head',description='Head',position=(0,55,25)),
      Viewpoint(DEF='Head2',description='Head Forward',fieldOfView=1.5,orientation=(0,-1,0,3.14),position=(0,55,0)),
      Group(DEF='HeadC4',
        #  lacl lacr frontal ethmoid ethmoid2 inconl inconr mand maxl maxr nasall nasalr occip palatl palatr parietl parietr sphenoid templ tempr vom zygol zygor 
        #  atlas axis c2disc c3 c3disc c4 
        children=[
        Shape(DEF='lacl',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='lacl_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,21,24,25,-1,26,25,24,-1,27,6,28,-1,0,29,1,-1,6,30,7,-1,31,32,30,-1,33,34,35,-1,36,37,38,-1,39,3,5,-1,40,41,42,-1,43,25,44,-1,45,43,46,-1,15,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,61,62,13,-1,62,63,64,-1,65,66,67,-1,13,64,68,-1,69,28,70,-1,71,72,73,-1,74,15,75,-1,76,77,78,-1,79,80,27,-1,81,32,82,-1,80,83,84,-1,85,86,87,-1,21,88,48,-1,32,81,89,-1,90,3,91,-1,58,89,81,-1,92,91,93,-1,13,12,85,-1,48,88,15,-1,41,40,94,-1,95,29,0,-1,96,54,97,-1,77,98,99,-1,98,77,100,-1,101,102,103,-1,102,104,103,-1,105,74,102,-1,74,75,102,-1,106,107,108,-1,109,20,40,-1,20,26,24,-1,8,110,6,-1,24,106,18,-1,16,105,111,-1,112,113,102,-1,86,114,115,-1,116,99,114,-1,117,67,99,-1,118,115,119,-1,51,120,49,-1,121,22,21,-1,76,78,122,-1,123,13,124,-1,125,126,50,-1,2,127,92,-1,128,126,129,-1,130,131,84,-1,132,133,134,-1,135,133,136,-1,137,138,139,-1,27,80,140,-1,12,78,77,-1,100,76,16,-1,141,38,72,-1,37,142,143,-1,66,119,67,-1,62,61,119,-1,82,32,31,-1,71,144,145,-1,146,147,58,-1,148,149,150,-1,151,152,153,-1,41,154,155,-1,156,157,104,-1,156,158,157,-1,34,46,35,-1,45,159,112,-1,66,65,63,-1,50,160,161,-1,154,11,10,-1,162,94,19,-1,144,71,57,-1,40,163,44,-1,7,1,8,-1,28,6,70,-1,20,19,40,-1,23,22,164,-1,165,162,166,-1,142,69,167,-1,83,168,169,-1,47,15,17,-1,12,122,78,-1,145,141,72,-1,127,30,170,-1,92,89,4,-1,1,7,2,-1,4,90,92,-1,120,171,172,-1,25,43,173,-1,75,15,174,-1,16,76,17,-1,167,143,142,-1,108,166,106,-1,165,175,162,-1,23,164,110,-1,24,21,107,-1,25,109,44,-1,140,6,27,-1,32,170,30,-1,44,109,40,-1,166,162,19,-1,10,155,154,-1,176,37,143,-1,12,14,122,-1,50,126,160,-1,66,63,62,-1,112,156,113,-1,112,177,45,-1,46,178,35,-1,104,113,156,-1,41,155,178,-1,47,179,48,-1,151,153,125,-1,139,148,150,-1,58,60,146,-1,71,145,72,-1,62,119,66,-1,119,61,118,-1,124,68,71,-1,180,130,169,-1,38,73,72,-1,16,15,74,-1,116,12,77,-1,141,145,132,-1,83,169,130,-1,136,181,135,-1,130,84,83,-1,144,57,56,-1,28,79,27,-1,2,92,93,-1,76,122,182,-1,37,176,38,-1,182,47,76,-1,94,11,154,-1,51,10,120,-1,153,152,183,-1,67,114,99,-1,116,114,86,-1,87,86,115,-1,183,184,111,-1,75,112,102,-1,16,74,105,-1,108,107,185,-1,24,107,106,-1,20,24,18,-1,109,26,20,-1,111,105,186,-1,187,104,157,-1,102,113,104,-1,111,184,16,-1,96,98,100,-1,99,116,77,-1,98,96,97,-1,61,115,118,-1,41,94,154,-1,173,174,88,-1,92,90,91,-1,58,4,89,-1,32,89,170,-1,21,48,121,-1,71,68,188,-1,31,189,82,-1,80,84,189,-1,82,190,81,-1,76,100,77,-1,36,180,37,-1,69,70,167,-1,191,157,158,-1,13,68,124,-1,65,67,117,-1,62,64,13,-1,61,13,192,-1,55,138,56,-1,152,151,52,-1,52,151,53,-1,49,193,50,-1,43,42,46,-1,42,163,40,-1,194,39,5,-1,38,141,36,-1,112,159,156,-1,94,40,19,-1,6,140,30,-1,30,140,31,-1,29,8,1,-1,25,26,109,-1,23,107,21,-1,29,195,8,-1,76,47,17,-1,15,88,174,-1,13,123,14,-1,174,173,177,-1,171,95,172,-1,171,175,95,-1,3,90,4,-1,79,83,80,-1,79,168,83,-1,169,69,142,-1,168,69,169,-1,166,185,165,-1,185,166,108,-1,171,162,175,-1,9,162,171,-1,34,191,158,-1,34,33,191,-1,41,46,42,-1,178,46,41,-1,196,63,65,-1,196,197,63,-1,147,68,58,-1,188,68,147,-1,148,188,147,-1,148,55,188,-1,97,65,117,-1,97,196,65,-1,141,134,36,-1,141,132,134,-1,198,59,131,-1,198,60,59,-1,131,134,198,-1,131,130,134,-1,198,133,135,-1,134,133,198,-1,144,136,145,-1,137,136,144,-1,193,53,151,-1,193,199,53,-1,143,122,176,-1,182,122,143,-1,179,182,143,-1,179,47,182,-1,9,120,10,-1,9,171,120,-1,67,115,114,-1,115,67,119,-1,129,103,128,-1,129,101,103,-1,99,97,117,-1,99,98,97,-1,186,183,111,-1,183,186,153,-1,102,186,105,-1,186,102,101,-1,192,115,61,-1,192,87,115,-1,101,153,186,-1,129,153,101,-1,172,3,120,-1,3,172,91,-1,200,178,155,-1,178,200,35,-1,88,25,173,-1,88,21,25,-1,95,91,172,-1,93,91,95,-1,197,39,194,-1,39,197,199,-1,179,121,48,-1,121,179,201,-1,135,60,198,-1,135,146,60,-1,130,36,134,-1,130,180,36,-1,75,177,112,-1,177,75,174,-1,196,54,53,-1,196,97,54,-1,55,71,188,-1,55,57,71,-1,193,125,50,-1,193,151,125,-1,44,42,43,-1,163,42,44,-1,155,51,200,-1,155,10,51,-1,14,176,122,-1,14,123,176,-1,34,156,159,-1,34,158,156,-1,110,195,23,-1,195,110,8,-1,165,195,29,-1,165,185,195,-1,162,11,94,-1,162,9,11,-1,0,93,95,-1,0,2,93,-1,168,28,69,-1,79,28,168,-1,19,106,166,-1,19,18,106,-1,129,125,153,-1,129,126,125,-1,164,167,70,-1,201,167,164,-1,81,59,58,-1,59,81,190,-1,191,187,157,-1,191,160,187,-1,84,59,190,-1,131,59,84,-1,139,149,181,-1,139,150,149,-1,56,137,144,-1,137,56,138,-1,13,87,192,-1,13,85,87,-1,5,58,68,-1,58,5,4,-1,49,199,193,-1,49,39,199,-1,33,160,191,-1,33,161,160,-1,201,22,121,-1,201,164,22,-1,64,5,68,-1,64,194,5,-1,184,54,96,-1,54,184,52,-1,104,128,103,-1,128,104,187,-1,23,185,107,-1,23,195,185,-1,100,184,96,-1,184,100,16,-1,52,183,152,-1,183,52,184,-1,39,120,3,-1,39,49,120,-1,63,194,64,-1,63,197,194,-1,37,169,142,-1,169,37,180,-1,73,124,71,-1,73,123,124,-1,200,50,161,-1,50,200,51,-1,35,161,33,-1,35,200,161,-1,133,145,136,-1,133,132,145,-1,137,181,136,-1,137,139,181,-1,181,146,135,-1,181,149,146,-1,190,189,84,-1,190,82,189,-1,140,189,31,-1,189,140,80,-1,116,85,12,-1,116,86,85,-1,196,199,197,-1,53,199,196,-1,55,139,138,-1,55,148,139,-1,149,147,146,-1,148,147,149,-1,46,159,45,-1,46,34,159,-1,43,177,173,-1,45,177,43,-1,128,160,126,-1,128,187,160,-1,38,123,73,-1,123,38,176,-1,2,30,127,-1,30,2,7,-1,164,6,110,-1,70,6,164,-1,95,165,29,-1,175,165,95,-1,167,179,143,-1,167,201,179,-1,127,89,92,-1,127,170,89,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lacl_Coord',point=[(.32689,56.97821,2.51086),(.33768,56.96651,2.49797),(.33038,56.9346,2.51208),(.25094,56.95825,2.64517),(.28025,56.85741,2.56384),(.27299,56.85383,2.63408),(.34777,56.93536,2.37383),(.36142,56.93358,2.45307),(.3422,56.98799,2.4739),(.25927,57.14455,2.58541),(.23091,57.19687,2.65341),(.25766,57.18758,2.58709),(.30259,56.85033,2.76057),(.28113,56.76022,2.70576),(.27918,56.83451,2.67866),(.30555,57.11606,2.70372),(.27138,57.08861,2.83372),(.29899,57.03974,2.7338),(.31316,57.1917,2.4815),(.29558,57.18491,2.5182),(.30912,57.23237,2.45784),(.32529,57.16964,2.52001),(.36431,57.03464,2.51495),(.34806,57.08331,2.46309),(.33333,57.20211,2.45861),(.31611,57.24106,2.51666),(.32534,57.2388,2.42881),(.40195,56.87979,2.39657),(.39325,56.89443,2.44834),(.32341,57.02181,2.50949),(.35185,56.88302,2.38456),(.38314,56.78876,2.34429),(.33688,56.79315,2.36755),(.23737,57.35927,2.77432),(.26883,57.39899,2.74606),(.24473,57.3257,2.71247),(.35951,56.85322,2.62212),(.33443,56.88416,2.60219),(.33024,56.87009,2.60571),(.25081,56.96261,2.74233),(.30261,57.26971,2.43634),(.27144,57.28937,2.5618),(.3458,57.35411,2.49552),(.34897,57.35486,2.49716),(.32546,57.33981,2.37063),(.32433,57.35102,2.62196),(.31546,57.35048,2.61841),(.31922,56.99012,2.654),(.32255,57.08282,2.61438),(.22876,57.10458,2.74484),(.20757,57.21959,2.79568),(.21555,57.2083,2.73329),(.25908,57.08178,2.89209),(.27038,56.96674,2.83467),(.29303,56.96853,2.89824),(.41609,56.69986,2.63675),(.43544,56.62145,2.67869),(.40459,56.69378,2.659),(.29243,56.81842,2.5656),(.41133,56.78534,2.5566),(.40877,56.77167,2.5792),(.34471,56.66268,2.7672),(.30532,56.75857,2.76781),(.28094,56.79538,2.77322),(.26935,56.78545,2.70761),(.31237,56.7949,2.83082),(.3295,56.75693,2.82972),(.35369,56.75528,2.89146),(.2894,56.7893,2.625),(.3588,56.89795,2.51515),(.38403,56.90802,2.45672),(.39303,56.72088,2.65149),(.36288,56.81037,2.65474),(.35259,56.80223,2.63791),(.28108,57.15234,2.82442),(.28931,57.21606,2.81479),(.29302,56.96207,2.74033),(.34428,56.88928,2.8023),(.28684,56.9207,2.74446),(.40494,56.88075,2.44165),(.43788,56.8549,2.43254),(.3408,56.81546,2.43215),(.41985,56.78025,2.39982),(.41478,56.84334,2.49239),(.40411,56.80743,2.47637),(.32172,56.77996,2.77623),(.35456,56.78034,2.80477),(.35504,56.70029,2.79304),(.31555,57.18428,2.5877),(.29862,56.86359,2.46255),(.27659,56.90308,2.57081),(.27293,56.94875,2.57759),(.30672,56.89973,2.4937),(.29236,56.94241,2.54171),(.29507,57.19905,2.55364),(.2953,57.03647,2.53172),(.30134,56.95729,2.8242),(.32311,56.86811,2.89281),(.33378,56.87875,2.8168),(.34747,56.82572,2.82103),(.31425,56.96901,2.81373),(.24606,57.21869,2.84844),(.26463,57.2195,2.81985),(.23571,57.248,2.86334),(.23184,57.34206,2.85595),(.26307,57.15007,2.82157),(.31454,57.1551,2.49612),(.33722,57.16026,2.48336),(.31425,57.1504,2.49882),(.31206,57.27482,2.39698),(.35881,57.00636,2.44232),(.25949,57.11405,2.83541),(.29453,57.31079,2.7867),(.26717,57.32361,2.81662),(.35049,56.76897,2.82121),(.34786,56.70099,2.79912),(.36346,56.84685,2.80441),(.3438,56.79442,2.88823),(.34789,56.67612,2.8038),(.35587,56.70922,2.89544),(.22832,57.07948,2.65557),(.3527,57.04489,2.54918),(.27996,56.91308,2.65954),(.28833,56.80813,2.62957),(.32146,56.7313,2.64895),(.22009,57.19233,2.83631),(.21319,57.23192,2.83567),(.32962,56.87626,2.4306),(.22334,57.25802,2.88692),(.22742,57.21789,2.87698),(.38777,56.83438,2.56205),(.39229,56.80023,2.56276),(.38836,56.82023,2.66795),(.39342,56.80538,2.64959),(.38572,56.82229,2.64194),(.40463,56.75145,2.60775),(.40775,56.75287,2.6574),(.42744,56.68657,2.64972),(.44052,56.63623,2.63223),(.44342,56.65932,2.59991),(.40605,56.87381,2.30103),(.3608,56.8522,2.63513),(.33269,56.89603,2.56622),(.31084,56.92426,2.60167),(.41736,56.7164,2.69567),(.3948,56.80435,2.69198),(.42146,56.74741,2.59083),(.41198,56.73857,2.61106),(.4276,56.70594,2.61449),(.43911,56.71201,2.59222),(.45892,56.66173,2.58318),(.24259,57.12501,2.84965),(.25039,57.13355,2.89188),(.23348,57.16336,2.87765),(.25299,57.23386,2.5873),(.23595,57.25484,2.65052),(.23924,57.45193,2.89152),(.22229,57.431,2.87256),(.22229,57.44751,2.87275),(.28176,57.40148,2.75727),(.19798,57.32322,2.83377),(.2118,57.29978,2.78896),(.29654,57.14486,2.54658),(.32514,57.34121,2.38437),(.38671,56.94145,2.47821),(.31919,57.08708,2.52284),(.30609,57.14316,2.52464),(.36034,56.91758,2.52649),(.38539,56.87317,2.49672),(.37161,56.86446,2.5468),(.32919,56.84327,2.38441),(.2573,57.10152,2.58357),(.26067,57.05849,2.58162),(.31104,57.25281,2.55417),(.30275,57.19792,2.69),(.29672,57.09066,2.53927),(.28853,56.8864,2.60175),(.30254,57.27118,2.65913),(.26545,57.30949,2.64133),(.32716,56.97374,2.60848),(.36639,56.85958,2.57952),(.42307,56.71222,2.6093),(.29904,56.94665,2.66786),(.25012,57.12068,2.8586),(.25597,57.08356,2.84704),(.32247,57.10241,2.503),(.24827,57.15672,2.84964),(.21104,57.34259,2.89313),(.40251,56.72973,2.63128),(.40082,56.79518,2.39819),(.42323,56.79211,2.47607),(.21945,57.40089,2.84279),(.34946,56.6647,2.76546),(.23033,57.11302,2.79482),(.26061,56.85048,2.72138),(.32922,57.0452,2.48858),(.29581,56.86097,2.83669),(.27447,56.85495,2.77757),(.39054,56.78255,2.59346),(.25761,56.96424,2.78566),(.22545,57.27804,2.724),(.36975,56.95203,2.53349)]))),
        Shape(DEF='lacr',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='lacr_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,23,-1,25,24,26,-1,27,8,28,-1,1,29,2,-1,7,30,31,-1,32,33,31,-1,31,33,8,-1,19,34,35,-1,36,37,38,-1,39,40,41,-1,5,42,43,-1,44,45,46,-1,34,47,48,-1,49,24,50,-1,51,48,52,-1,53,54,17,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,64,65,63,-1,66,13,67,-1,13,68,44,-1,69,70,46,-1,71,72,73,-1,74,75,76,-1,77,17,78,-1,79,80,81,-1,28,82,83,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,93,53,94,-1,95,85,84,-1,96,5,4,-1,97,96,4,-1,94,98,99,-1,100,35,101,-1,102,103,67,-1,104,105,106,-1,105,104,107,-1,108,109,110,-1,111,112,109,-1,109,77,78,-1,113,114,115,-1,18,26,116,-1,25,26,18,-1,117,118,25,-1,119,118,120,-1,121,115,122,-1,115,114,16,-1,109,112,38,-1,103,123,91,-1,91,123,124,-1,124,125,69,-1,126,103,102,-1,127,10,55,-1,23,22,93,-1,81,128,129,-1,130,13,131,-1,56,132,133,-1,134,30,0,-1,53,93,135,-1,62,61,136,-1,89,137,138,-1,139,140,141,-1,138,142,89,-1,143,144,40,-1,105,79,106,-1,78,17,16,-1,75,74,41,-1,142,138,145,-1,146,147,148,-1,125,126,70,-1,75,144,136,-1,149,150,151,-1,53,152,54,-1,153,154,101,-1,36,112,111,-1,111,146,36,-1,38,37,52,-1,112,36,38,-1,155,46,70,-1,56,156,148,-1,129,12,14,-1,157,158,159,-1,100,10,9,-1,19,160,161,-1,34,116,49,-1,31,162,84,-1,28,8,33,-1,49,116,24,-1,118,23,25,-1,160,163,164,-1,157,72,71,-1,142,165,89,-1,15,17,54,-1,79,129,14,-1,75,40,144,-1,162,31,30,-1,3,95,4,-1,0,7,1,-1,95,134,4,-1,166,167,127,-1,99,50,24,-1,98,17,77,-1,15,81,16,-1,168,157,71,-1,117,161,120,-1,164,161,160,-1,34,19,18,-1,73,8,27,-1,6,1,7,-1,49,47,34,-1,61,76,136,-1,19,35,160,-1,100,154,10,-1,148,132,56,-1,155,44,46,-1,38,52,169,-1,146,170,36,-1,154,100,101,-1,150,171,151,-1,136,76,75,-1,32,84,172,-1,102,67,126,-1,76,173,130,-1,146,148,174,-1,157,168,158,-1,75,41,40,-1,16,81,80,-1,79,14,106,-1,33,82,28,-1,65,64,175,-1,140,176,141,-1,177,141,143,-1,89,88,137,-1,178,132,179,-1,135,152,53,-1,28,83,27,-1,97,134,0,-1,129,79,81,-1,41,159,158,-1,81,54,128,-1,100,9,35,-1,55,57,127,-1,122,180,121,-1,124,123,125,-1,91,124,106,-1,103,91,90,-1,115,181,122,-1,109,38,77,-1,114,78,16,-1,121,113,115,-1,20,117,25,-1,8,182,6,-1,18,20,25,-1,34,18,116,-1,120,118,117,-1,109,78,114,-1,146,111,147,-1,109,108,111,-1,16,181,115,-1,80,105,107,-1,104,106,124,-1,2,29,183,-1,35,34,101,-1,17,94,53,-1,92,14,13,-1,97,4,134,-1,85,95,3,-1,3,171,85,-1,162,95,84,-1,93,94,23,-1,184,173,76,-1,172,87,32,-1,87,89,82,-1,86,172,84,-1,79,105,80,-1,158,145,39,-1,73,27,71,-1,170,146,174,-1,69,125,70,-1,44,155,13,-1,13,155,67,-1,150,185,171,-1,65,186,63,-1,62,64,63,-1,60,59,180,-1,58,187,59,-1,56,188,57,-1,48,50,52,-1,34,48,101,-1,44,189,45,-1,43,190,5,-1,41,158,39,-1,191,192,193,-1,31,84,32,-1,7,31,8,-1,7,0,30,-1,1,6,29,-1,116,26,24,-1,23,118,21,-1,6,194,29,-1,15,54,81,-1,98,94,17,-1,12,131,13,-1,169,99,98,-1,5,190,3,-1,89,83,82,-1,89,165,83,-1,71,142,168,-1,142,71,165,-1,119,161,164,-1,120,161,119,-1,131,41,74,-1,159,41,131,-1,148,179,132,-1,148,147,179,-1,173,151,171,-1,151,173,184,-1,184,186,151,-1,184,63,186,-1,195,45,189,-1,45,195,187,-1,46,196,69,-1,46,45,196,-1,177,40,39,-1,177,143,40,-1,185,197,137,-1,185,150,197,-1,177,137,197,-1,177,138,137,-1,141,197,139,-1,197,141,177,-1,176,136,144,-1,136,176,175,-1,156,191,193,-1,156,198,191,-1,56,198,156,-1,55,198,56,-1,130,74,76,-1,130,131,74,-1,142,158,168,-1,145,158,142,-1,43,44,68,-1,43,189,44,-1,127,42,5,-1,127,57,42,-1,122,60,180,-1,181,60,122,-1,108,178,179,-1,108,110,178,-1,196,124,69,-1,196,104,124,-1,119,21,118,-1,119,194,21,-1,113,109,114,-1,110,109,113,-1,103,66,67,-1,103,90,66,-1,121,110,113,-1,110,121,178,-1,5,166,127,-1,96,166,5,-1,153,198,154,-1,191,198,153,-1,24,94,99,-1,24,23,94,-1,96,183,166,-1,183,96,97,-1,42,189,43,-1,195,189,42,-1,90,13,66,-1,90,92,13,-1,175,62,136,-1,64,62,175,-1,199,65,140,-1,199,200,65,-1,185,88,86,-1,88,185,137,-1,58,45,187,-1,58,196,45,-1,155,126,67,-1,70,126,155,-1,185,85,171,-1,86,85,185,-1,76,63,184,-1,76,61,63,-1,121,59,133,-1,121,180,59,-1,133,178,121,-1,133,132,178,-1,194,182,21,-1,6,182,194,-1,194,164,29,-1,194,119,164,-1,9,160,35,-1,9,11,160,-1,97,2,183,-1,97,0,2,-1,27,165,71,-1,165,27,83,-1,117,19,161,-1,117,20,19,-1,22,182,201,-1,182,22,21,-1,36,192,37,-1,36,170,192,-1,159,12,129,-1,159,131,12,-1,55,154,198,-1,55,10,154,-1,191,51,192,-1,191,153,51,-1,48,49,50,-1,49,48,47,-1,133,188,56,-1,133,59,188,-1,72,201,73,-1,201,72,135,-1,199,65,200,-1,199,186,65,-1,169,77,38,-1,98,77,169,-1,39,138,177,-1,39,145,138,-1,150,139,197,-1,150,149,139,-1,171,190,173,-1,3,190,171,-1,195,57,188,-1,195,42,57,-1,148,193,174,-1,148,156,193,-1,22,135,93,-1,22,201,135,-1,190,68,173,-1,190,43,68,-1,58,181,107,-1,60,181,58,-1,179,111,108,-1,147,111,179,-1,181,80,107,-1,16,80,181,-1,107,196,58,-1,196,107,104,-1,103,125,123,-1,126,125,103,-1,127,11,10,-1,127,167,11,-1,128,152,157,-1,128,54,152,-1,129,157,159,-1,157,129,128,-1,187,188,59,-1,187,195,188,-1,144,141,176,-1,144,143,141,-1,140,175,176,-1,140,65,175,-1,149,140,139,-1,149,199,140,-1,87,86,88,-1,87,172,86,-1,87,33,32,-1,82,33,87,-1,92,106,14,-1,92,91,106,-1,173,13,130,-1,173,68,13,-1,151,199,149,-1,199,151,186,-1,37,51,52,-1,37,192,51,-1,169,50,99,-1,50,169,52,-1,51,101,48,-1,101,51,153,-1,174,192,170,-1,174,193,192,-1,160,167,163,-1,167,160,11,-1,8,201,182,-1,201,8,73,-1,164,183,29,-1,183,164,163,-1,152,72,157,-1,152,135,72,-1,163,166,183,-1,166,163,167,-1,95,30,134,-1,95,162,30,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='lacr_Coord',point=[(-.33038,56.9346,2.49775),(-.33768,56.96651,2.48365),(-.32689,56.97821,2.49685),(-.28025,56.85741,2.55075),(-.27659,56.90308,2.55793),(-.25094,56.95825,2.63293),(-.3422,56.98799,2.4598),(-.36142,56.93358,2.43831),(-.34777,56.93536,2.36053),(-.25766,57.18758,2.5761),(-.23091,57.19687,2.64308),(-.25927,57.14455,2.57414),(-.27918,56.83451,2.66444),(-.28113,56.76022,2.69104),(-.30259,56.85033,2.74449),(-.29899,57.03974,2.71898),(-.27138,57.08861,2.81963),(-.30555,57.11606,2.68935),(-.30912,57.23237,2.44641),(-.29558,57.18491,2.50636),(-.31316,57.1917,2.46944),(-.34806,57.08331,2.44938),(-.36431,57.03464,2.4998),(-.32529,57.16964,2.507),(-.31611,57.24106,2.50448),(-.33333,57.20211,2.44618),(-.32534,57.2388,2.4172),(-.39325,56.89443,2.4324),(-.40195,56.87979,2.38102),(-.32341,57.02181,2.49582),(-.32962,56.87626,2.41706),(-.35185,56.88302,2.37082),(-.38314,56.78876,2.32983),(-.40605,56.87381,2.2867),(-.30261,57.26971,2.42557),(-.29507,57.19905,2.54158),(-.23924,57.45193,2.88122),(-.28176,57.40148,2.74563),(-.29453,57.31079,2.77358),(-.35951,56.85322,2.60506),(-.3608,56.8522,2.61786),(-.33024,56.87009,2.5901),(-.25081,56.96261,2.72931),(-.26061,56.85048,2.70768),(-.28094,56.79538,2.75793),(-.29581,56.86097,2.82025),(-.31237,56.7949,2.81342),(-.32514,57.34121,2.37394),(-.3458,57.35411,2.48348),(-.32546,57.33981,2.36032),(-.34897,57.35486,2.48501),(-.31546,57.35048,2.60616),(-.32433,57.35102,2.60939),(-.32255,57.08282,2.59997),(-.31922,56.99012,2.63881),(-.21555,57.2083,2.72316),(-.20757,57.21959,2.78563),(-.22876,57.10458,2.73349),(-.29303,56.96853,2.88189),(-.24259,57.12501,2.83706),(-.25908,57.08178,2.87815),(-.40459,56.69378,2.63934),(-.43544,56.62145,2.65756),(-.41609,56.69986,2.61694),(-.44052,56.63623,2.61156),(-.44342,56.65932,2.57959),(-.34946,56.6647,2.74683),(-.34471,56.66268,2.74877),(-.26935,56.78545,2.69348),(-.3438,56.79442,2.8687),(-.3295,56.75693,2.81141),(-.3588,56.89795,2.49958),(-.36034,56.91758,2.51079),(-.38403,56.90802,2.44102),(-.35259,56.80223,2.6208),(-.36288,56.81037,2.63703),(-.39303,56.72088,2.63241),(-.28931,57.21606,2.80092),(-.28108,57.15234,2.81037),(-.28684,56.9207,2.72953),(-.31425,56.96901,2.79709),(-.29302,56.96207,2.72533),(-.43788,56.8549,2.41524),(-.40494,56.88075,2.42537),(-.33688,56.79315,2.35432),(-.3408,56.81546,2.41803),(-.42323,56.79211,2.45844),(-.40082,56.79518,2.38242),(-.40411,56.80743,2.45941),(-.41478,56.84334,2.47493),(-.35504,56.70029,2.77385),(-.35456,56.78034,2.78559),(-.32172,56.77996,2.7589),(-.3527,57.04489,2.5341),(-.31555,57.18428,2.57447),(-.29862,56.86359,2.44977),(-.27293,56.94875,2.56495),(-.29236,56.94241,2.52859),(-.30275,57.19792,2.67643),(-.31104,57.25281,2.54189),(-.25299,57.23386,2.57676),(-.27144,57.28937,2.55112),(-.34789,56.67612,2.78482),(-.34786,56.70099,2.7802),(-.33378,56.87875,2.79879),(-.34428,56.88928,2.78398),(-.36346,56.84685,2.78503),(-.30134,56.95729,2.80801),(-.23571,57.248,2.85178),(-.26463,57.2195,2.80705),(-.24606,57.21869,2.8363),(-.23184,57.34206,2.84528),(-.26717,57.32361,2.80452),(-.24827,57.15672,2.83697),(-.26307,57.15007,2.80836),(-.25949,57.11405,2.82203),(-.31206,57.27482,2.38634),(-.31454,57.1551,2.48364),(-.33722,57.16026,2.47026),(-.32247,57.10241,2.48986),(-.31425,57.1504,2.4863),(-.23348,57.16336,2.86557),(-.25012,57.12068,2.84556),(-.35049,56.76897,2.80202),(-.34747,56.82572,2.80213),(-.35369,56.75528,2.87133),(-.35587,56.70922,2.87509),(-.22832,57.07948,2.64475),(-.29904,56.94665,2.65321),(-.27996,56.91308,2.64569),(-.32146,56.7313,2.63294),(-.28833,56.80813,2.61536),(-.21319,57.23192,2.82521),(-.22009,57.19233,2.82529),(-.30672,56.89973,2.48037),(-.36975,56.95203,2.5175),(-.41736,56.7164,2.67502),(-.39229,56.80023,2.54502),(-.38777,56.83438,2.54458),(-.40463,56.75145,2.58884),(-.42307,56.71222,2.58962),(-.39342,56.80538,2.63068),(-.37161,56.86446,2.53023),(-.38836,56.82023,2.64905),(-.3948,56.80435,2.67247),(-.36639,56.85958,2.56273),(-.22229,57.431,2.86286),(-.21104,57.34259,2.88319),(-.19798,57.32322,2.82457),(-.42146,56.74741,2.57151),(-.40877,56.77167,2.56056),(-.41198,56.73857,2.5918),(-.32716,56.97374,2.59337),(-.26545,57.30949,2.6304),(-.23595,57.25484,2.64033),(-.30532,56.75857,2.75131),(-.2118,57.29978,2.77922),(-.31084,56.92426,2.5871),(-.33443,56.88416,2.58649),(-.28853,56.8864,2.588),(-.29654,57.14486,2.5342),(-.30609,57.14316,2.51211),(-.32919,56.84327,2.37134),(-.29672,57.09066,2.52666),(-.31919,57.08708,2.50953),(-.38539,56.87317,2.48032),(-.26067,57.05849,2.5699),(-.2573,57.10152,2.57217),(-.33269,56.89603,2.55104),(-.30254,57.27118,2.64637),(-.22229,57.44751,2.86318),(-.29243,56.81842,2.55188),(-.41985,56.78025,2.38339),(-.2894,56.7893,2.61075),(-.21945,57.40089,2.83313),(-.42744,56.68657,2.62929),(-.40775,56.75287,2.6377),(-.38572,56.82229,2.62348),(-.22742,57.21789,2.86554),(-.22334,57.25802,2.87588),(-.25039,57.13355,2.8787),(-.25597,57.08356,2.83357),(-.35881,57.00636,2.4281),(-.2953,57.03647,2.51897),(-.40251,56.72973,2.6121),(-.41133,56.78534,2.53822),(-.4276,56.70594,2.59456),(-.27038,56.96674,2.81996),(-.23033,57.11302,2.78311),(-.27447,56.85495,2.76271),(-.27299,56.85383,2.62061),(-.24473,57.3257,2.70197),(-.26883,57.39899,2.73496),(-.23737,57.35927,2.76398),(-.32922,57.0452,2.47504),(-.25761,56.96424,2.77196),(-.32311,56.86811,2.87452),(-.39054,56.78255,2.57535),(-.22545,57.27804,2.71391),(-.43911,56.71201,2.57219),(-.45892,56.66173,2.56258),(-.38671,56.94145,2.46227)]))),
        Shape(DEF='frontal',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='frontal_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,14,15,12,-1,16,17,18,-1,19,20,21,-1,22,12,15,-1,17,23,18,-1,24,21,25,-1,26,27,28,-1,29,30,31,-1,27,26,32,-1,33,34,35,-1,35,36,37,-1,38,39,40,-1,6,41,42,-1,43,44,45,-1,46,47,31,-1,48,49,50,-1,51,52,48,-1,53,54,55,-1,56,57,58,-1,59,60,61,-1,62,63,64,-1,58,65,66,-1,59,67,68,-1,69,70,71,-1,51,72,73,-1,74,75,76,-1,77,49,52,-1,78,79,80,-1,81,82,83,-1,84,85,86,-1,87,84,88,-1,89,82,90,-1,91,92,86,-1,93,94,95,-1,96,97,98,-1,99,80,100,-1,64,101,102,-1,103,104,99,-1,98,105,106,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,90,82,116,-1,117,108,118,-1,119,120,121,-1,122,107,109,-1,123,124,114,-1,108,125,111,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,136,138,139,-1,140,141,142,-1,143,144,145,-1,143,146,147,-1,148,140,149,-1,150,151,152,-1,153,154,155,-1,131,156,157,-1,132,158,159,-1,160,161,162,-1,163,164,165,-1,166,167,168,-1,161,164,163,-1,169,170,153,-1,171,172,173,-1,174,175,176,-1,177,178,179,-1,180,181,182,-1,183,184,185,-1,172,186,159,-1,187,188,189,-1,186,188,190,-1,191,192,193,-1,194,195,196,-1,197,198,199,-1,200,201,202,-1,203,204,205,-1,206,207,208,-1,209,210,211,-1,212,213,210,-1,214,213,215,-1,216,217,218,-1,219,220,221,-1,222,193,223,-1,224,225,226,-1,227,175,228,-1,229,230,231,-1,175,232,233,-1,227,234,232,-1,235,236,237,-1,238,236,235,-1,239,240,241,-1,242,243,241,-1,193,192,244,-1,245,246,247,-1,248,195,249,-1,250,251,252,-1,253,254,255,-1,199,256,257,-1,205,258,259,-1,260,211,261,-1,262,209,263,-1,264,265,266,-1,267,268,269,-1,270,271,272,-1,273,274,272,-1,273,275,276,-1,274,277,278,-1,279,280,281,-1,282,283,284,-1,285,286,287,-1,288,289,290,-1,291,292,293,-1,294,295,296,-1,297,298,299,-1,300,301,296,-1,284,295,294,-1,185,297,299,-1,302,255,303,-1,256,304,305,-1,306,307,308,-1,242,309,310,-1,311,312,313,-1,237,314,315,-1,235,237,316,-1,317,318,319,-1,232,320,321,-1,322,323,324,-1,325,232,321,-1,326,231,327,-1,230,328,329,-1,187,326,330,-1,331,332,333,-1,334,335,336,-1,337,338,339,-1,340,341,342,-1,343,344,345,-1,344,346,347,-1,348,349,350,-1,351,352,353,-1,353,354,355,-1,356,357,358,-1,359,360,361,-1,362,363,364,-1,365,366,367,-1,368,369,370,-1,371,372,373,-1,374,375,376,-1,371,377,374,-1,378,379,380,-1,381,382,383,-1,384,381,383,-1,385,386,387,-1,388,389,390,-1,389,391,392,-1,393,394,395,-1,396,397,398,-1,385,399,400,-1,401,402,395,-1,403,404,341,-1,405,406,407,-1,408,409,410,-1,341,340,411,-1,412,413,414,-1,415,416,417,-1,393,418,419,-1,417,420,421,-1,422,423,424,-1,425,426,422,-1,427,428,429,-1,430,431,432,-1,433,434,435,-1,436,437,438,-1,439,440,441,-1,442,443,444,-1,334,445,446,-1,447,448,449,-1,330,326,450,-1,451,311,452,-1,453,311,451,-1,454,455,456,-1,457,458,459,-1,302,460,255,-1,461,462,463,-1,371,464,465,-1,466,467,126,-1,468,469,470,-1,469,471,472,-1,473,474,475,-1,476,474,473,-1,477,478,479,-1,480,481,482,-1,483,484,485,-1,486,487,488,-1,489,490,491,-1,492,493,494,-1,495,496,497,-1,498,499,500,-1,501,482,502,-1,503,504,505,-1,506,507,508,-1,509,510,511,-1,512,513,514,-1,515,516,517,-1,518,516,519,-1,520,461,521,-1,522,523,524,-1,525,523,526,-1,527,528,529,-1,530,467,466,-1,531,532,533,-1,534,535,536,-1,177,537,538,-1,539,537,540,-1,541,542,543,-1,544,545,546,-1,547,548,549,-1,550,547,551,-1,552,550,553,-1,554,552,555,-1,57,556,554,-1,557,558,559,-1,560,561,562,-1,563,564,565,-1,566,567,556,-1,505,504,510,-1,565,568,569,-1,570,571,531,-1,572,540,573,-1,574,575,576,-1,577,578,579,-1,580,581,582,-1,583,584,585,-1,586,587,588,-1,530,589,590,-1,591,592,593,-1,594,595,596,-1,597,531,598,-1,599,600,601,-1,602,603,177,-1,604,605,606,-1,187,607,190,-1,608,609,610,-1,229,611,612,-1,613,326,611,-1,612,614,615,-1,616,617,618,-1,185,619,620,-1,225,621,496,-1,622,623,624,-1,625,626,203,-1,482,481,502,-1,627,628,500,-1,476,629,474,-1,630,631,632,-1,633,634,635,-1,636,637,238,-1,638,639,640,-1,641,642,643,-1,644,137,645,-1,646,640,647,-1,648,649,650,-1,651,652,653,-1,654,655,656,-1,472,657,658,-1,659,660,661,-1,468,661,662,-1,663,664,144,-1,144,665,663,-1,666,150,152,-1,667,586,588,-1,668,669,670,-1,668,671,581,-1,672,673,674,-1,675,141,676,-1,677,678,675,-1,678,679,680,-1,677,681,682,-1,180,182,683,-1,684,685,686,-1,687,688,579,-1,689,688,687,-1,578,690,679,-1,578,650,649,-1,527,691,692,-1,693,525,694,-1,695,696,697,-1,698,522,524,-1,698,524,699,-1,18,700,701,-1,702,703,704,-1,705,706,707,-1,708,709,710,-1,704,711,25,-1,23,712,18,-1,713,463,462,-1,714,62,58,-1,715,562,561,-1,716,717,511,-1,462,718,508,-1,719,707,692,-1,720,721,722,-1,723,724,725,-1,590,694,525,-1,592,726,694,-1,459,727,728,-1,354,729,730,-1,328,731,614,-1,732,439,733,-1,734,735,736,-1,737,401,738,-1,739,740,741,-1,742,703,743,-1,744,745,746,-1,747,748,749,-1,634,639,750,-1,751,752,753,-1,754,755,756,-1,757,758,759,-1,760,761,762,-1,763,764,765,-1,766,767,768,-1,752,751,769,-1,770,771,772,-1,773,774,775,-1,776,777,778,-1,779,780,763,-1,781,782,783,-1,766,784,785,-1,756,786,754,-1,787,788,783,-1,789,790,791,-1,792,793,794,-1,795,796,797,-1,798,799,786,-1,798,753,752,-1,798,797,796,-1,800,801,802,-1,803,804,805,-1,806,807,808,-1,790,809,810,-1,811,812,813,-1,814,815,816,-1,817,818,819,-1,820,821,822,-1,823,824,825,-1,826,818,827,-1,828,829,830,-1,804,808,831,-1,832,833,834,-1,835,836,837,-1,838,839,840,-1,841,842,843,-1,844,845,846,-1,847,848,849,-1,850,851,852,-1,853,854,855,-1,856,857,858,-1,859,860,861,-1,862,863,864,-1,865,866,867,-1,868,869,870,-1,871,872,873,-1,874,875,876,-1,842,877,878,-1,879,880,881,-1,880,879,882,-1,883,884,885,-1,886,844,846,-1,887,844,886,-1,887,888,889,-1,890,891,892,-1,893,894,895,-1,896,897,898,-1,899,900,901,-1,902,899,901,-1,903,896,898,-1,904,905,906,-1,907,908,909,-1,910,911,912,-1,910,912,913,-1,914,915,916,-1,916,917,918,-1,919,920,921,-1,922,921,923,-1,924,925,926,-1,927,925,928,-1,925,924,929,-1,930,931,932,-1,933,871,934,-1,933,935,871,-1,936,937,938,-1,939,940,941,-1,939,942,943,-1,944,945,946,-1,947,948,949,-1,950,951,952,-1,953,867,954,-1,955,954,956,-1,957,958,959,-1,960,961,962,-1,963,964,965,-1,966,967,968,-1,969,970,971,-1,972,973,974,-1,975,976,977,-1,978,979,980,-1,981,982,983,-1,984,985,986,-1,987,986,985,-1,988,989,990,-1,991,992,993,-1,994,995,996,-1,997,992,998,-1,999,1000,1001,-1,1002,1003,1004,-1,1005,1006,1007,-1,1007,1008,1004,-1,966,1009,1010,-1,967,966,1011,-1,1012,1013,1014,-1,1015,1016,1017,-1,1014,1018,1012,-1,1019,1020,1021,-1,1022,1023,1024,-1,1025,1026,1027,-1,1028,1025,1027,-1,1029,1030,1024,-1,1031,1032,1033,-1,1034,1035,1036,-1,1037,1038,1039,-1,1040,1041,1042,-1,1043,1044,1045,-1,1043,1046,1047,-1,1048,1049,1050,-1,1049,1048,1051,-1,1052,1053,1054,-1,1047,1055,1056,-1,1047,1056,1057,-1,1058,1051,1048,-1,1048,1059,1060,-1,1061,1062,964,-1,1063,961,1064,-1,1063,1065,1066,-1,1067,1068,1069,-1,1068,1070,1069,-1,1071,958,1072,-1,958,1073,1074,-1,1074,1075,958,-1,1076,1077,1052,-1,1078,937,1079,-1,1080,1081,1082,-1,1083,1084,1085,-1,1031,1086,1032,-1,1087,1088,1089,-1,1090,1091,1092,-1,1093,1094,1095,-1,1096,1093,1095,-1,1097,1002,999,-1,1089,1098,1099,-1,1100,1101,1102,-1,1103,1104,1105,-1,1106,1107,1108,-1,1109,1110,1111,-1,850,1112,1113,-1,1114,1115,1116,-1,1117,1105,1118,-1,1119,1120,1121,-1,1122,1123,1124,-1,1125,1126,1127,-1,863,1128,1129,-1,1130,1131,1132,-1,768,1133,1134,-1,1135,1136,1137,-1,1138,1087,1139,-1,815,1140,1087,-1,1141,1142,1143,-1,1144,1145,1137,-1,1146,1099,1147,-1,1148,1149,1150,-1,1151,1152,1153,-1,1154,1155,1156,-1,1157,1150,1149,-1,1158,1156,1159,-1,1149,1160,1161,-1,1152,1155,1162,-1,1156,1155,1163,-1,1089,1099,1146,-1,1164,1165,1166,-1,1167,1168,1169,-1,1170,1171,1172,-1,1173,1169,1174,-1,1175,1176,1177,-1,1178,1179,1180,-1,1181,1182,822,-1,1183,1184,1185,-1,1186,1187,1188,-1,1189,1190,1191,-1,1192,71,1193,-1,1194,1195,1196,-1,1197,1198,1199,-1,1199,1200,1192,-1,60,71,1200,-1,1201,1193,1202,-1,1203,1204,1205,-1,1140,1185,1206,-1,67,567,1207,-1,816,1144,1136,-1,1208,1206,1185,-1,1209,1210,1190,-1,1211,1198,1212,-1,1183,1213,1184,-1,1214,1215,1216,-1,1217,1218,1219,-1,1220,1221,1222,-1,771,1223,1220,-1,1224,1225,1226,-1,1227,959,1228,-1,1229,1230,1231,-1,1230,1229,1232,-1,1233,1234,1231,-1,1235,1210,1209,-1,827,825,826,-1,1181,822,821,-1,1236,1237,1238,-1,1239,1240,1241,-1,1242,783,782,-1,1243,1244,1245,-1,1246,1247,1244,-1,1090,1092,1243,-1,1248,1225,1224,-1,1249,1250,1251,-1,1252,1253,1254,-1,1255,1256,1257,-1,891,1258,1259,-1,1130,1260,1261,-1,1262,1106,1129,-1,1263,1264,1265,-1,1266,1267,635,-1,1108,1268,1269,-1,1270,1271,1272,-1,1273,1274,1275,-1,1276,1277,1278,-1,1279,1280,650,-1,1281,1282,1283,-1,1284,1285,1286,-1,1117,1287,1288,-1,1289,1290,805,-1,805,834,1244,-1,1291,1101,1292,-1,1292,1293,1291,-1,1294,1127,1295,-1,772,1296,1297,-1,1298,1299,1300,-1,1300,770,1301,-1,1302,1303,1304,-1,773,1305,1306,-1,1307,1143,1308,-1,1309,810,1310,-1,1311,1312,1313,-1,1314,1309,1315,-1,1311,1313,1316,-1,1317,1318,1319,-1,1320,1319,1321,-1,1322,1323,1324,-1,1325,1219,1218,-1,764,763,780,-1,1326,1327,1328,-1,1329,1238,1330,-1,1327,1218,1217,-1,650,1331,1332,-1,1333,1176,1334,-1,1234,1335,1336,-1,1177,1337,1338,-1,1175,1177,1170,-1,1180,1179,1339,-1,1340,1341,1342,-1,1343,1344,1345,-1,1346,1347,1348,-1,37,1349,1350,-1,1351,1352,755,-1,1340,1353,1354,-1,1355,1356,1357,-1,1358,1359,1088,-1,1360,1361,1098,-1,1208,1184,1362,-1,1363,1211,1364,-1,1188,1187,1184,-1,1365,1203,1366,-1,1136,1135,1099,-1,1367,1368,1369,-1,1233,1370,1234,-1,1371,1372,1335,-1,1168,1167,1373,-1,1374,1375,1010,-1,1376,1240,1239,-1,964,963,1061,-1,1377,1378,1067,-1,1379,963,1380,-1,1381,1382,1383,-1,1384,1385,1386,-1,1387,1388,1389,-1,1390,1389,1391,-1,1392,1393,1394,-1,51,48,747,-1,1395,1396,747,-1,1280,1397,650,-1,1393,1392,1398,-1,1399,1400,1401,-1,1341,1402,1403,-1,1404,1405,1406,-1,1407,1408,1409,-1,1410,1381,1411,-1,1409,1412,1413,-1,1367,1414,1415,-1,960,965,1416,-1,1091,1417,1092,-1,982,981,1418,-1,1419,1086,1031,-1,1420,1421,1422,-1,1336,1335,1421,-1,1371,1335,1234,-1,1367,1233,1423,-1,1424,1423,1425,-1,1333,1344,1426,-1,1098,1361,1427,-1,1358,1088,1087,-1,1204,1428,1429,-1,1430,1431,71,-1,1432,1433,557,-1,1434,1435,72,-1,1436,1098,1359,-1,1437,1438,1350,-1,1439,1440,1441,-1,1349,1440,1350,-1,35,1342,36,-1,1442,1443,1444,-1,1342,1423,1445,-1,1446,1445,1423,-1,36,1349,37,-1,1169,1168,1447,-1,1337,1448,1449,-1,1450,1426,1343,-1,1451,1452,1453,-1,820,1329,1216,-1,650,1214,1331,-1,1217,1281,1331,-1,1454,1242,1133,-1,1455,1456,1316,-1,1324,1323,1218,-1,1457,1458,1320,-1,1318,1317,1459,-1,1311,1456,1460,-1,1309,1461,1462,-1,1311,1314,1315,-1,1312,1142,1141,-1,1463,1464,1309,-1,1306,1305,1222,-1,1465,1466,1308,-1,1467,1299,1468,-1,1469,1470,1465,-1,770,772,1297,-1,1127,1126,1298,-1,1101,1100,1294,-1,1292,1295,1297,-1,834,833,1471,-1,1472,1473,1290,-1,1474,1475,1476,-1,1477,1478,1282,-1,1332,1281,1283,-1,1272,1271,1280,-1,1476,1479,1480,-1,1272,1481,634,-1,1482,1483,1277,-1,1264,1484,1485,-1,1486,1479,1119,-1,1111,1110,1487,-1,1488,1489,1490,-1,1487,1491,1111,-1,863,1108,1492,-1,1123,1493,1494,-1,1495,1257,1496,-1,1257,1495,1255,-1,1497,1132,1498,-1,1499,841,1500,-1,1501,1250,1502,-1,1502,1503,1504,-1,1504,1503,1505,-1,824,823,780,-1,1506,1084,1086,-1,834,1246,1244,-1,956,1290,1243,-1,1507,768,1134,-1,783,1242,1508,-1,833,1509,1471,-1,1443,1510,1511,-1,1433,1512,1513,-1,1403,1402,1514,-1,1201,1202,1515,-1,61,1200,1516,-1,1211,1363,1199,-1,1208,1517,1518,-1,1423,1230,1446,-1,1240,1376,1420,-1,1173,1519,1520,-1,1521,1522,1523,-1,1142,1524,1525,-1,1308,1466,1526,-1,1315,1464,1524,-1,1527,863,835,-1,1423,1424,1368,-1,1211,1528,557,-1,819,1213,1183,-1,1139,1140,1529,-1,1431,1202,1193,-1,1530,1531,1365,-1,1435,70,72,-1,1363,1364,1532,-1,178,544,1533,-1,1193,1201,1192,-1,1534,1535,1536,-1,1533,544,1537,-1,1538,1186,1539,-1,1518,1189,1530,-1,1362,1186,1540,-1,1515,1202,1531,-1,1210,1235,1541,-1,1172,1175,1170,-1,1520,1167,1169,-1,1542,1174,1336,-1,1171,1170,1338,-1,1174,1447,1179,-1,1158,1159,1089,-1,1543,1157,1544,-1,1545,1546,1547,-1,1548,1549,1163,-1,1155,1154,1550,-1,1548,1135,1549,-1,1326,1551,1552,-1,815,1087,1144,-1,1429,1138,1139,-1,1427,761,1553,-1,1145,1144,1159,-1,817,1136,1166,-1,1554,1555,1495,-1,1556,1557,1558,-1,1103,1252,1559,-1,1474,1560,1561,-1,1562,1475,1563,-1,1484,1564,1565,-1,1566,1567,1568,-1,1556,1494,1557,-1,1491,1265,1121,-1,1569,1570,1571,-1,1261,1572,848,-1,1573,1109,1120,-1,1567,1125,1285,-1,1479,1476,1475,-1,918,917,1574,-1,1241,831,1575,-1,999,1004,1576,-1,1359,1089,1088,-1,1577,884,1578,-1,1084,1083,1579,-1,936,1580,937,-1,869,946,1581,-1,1582,1583,1584,-1,1585,1586,1587,-1,1588,1589,1585,-1,1069,1377,1067,-1,961,1590,1591,-1,1592,1055,1047,-1,1052,1593,1053,-1,1050,1049,1412,-1,1594,1044,1595,-1,1407,1596,1597,-1,1408,1598,1599,-1,1600,1601,1602,-1,1598,1603,1604,-1,1032,1605,1033,-1,1606,1603,1600,-1,1607,1608,1609,-1,1596,1610,1611,-1,1612,1035,1613,-1,1039,1038,1614,-1,1615,1616,1610,-1,1617,1026,1618,-1,1522,1619,1620,-1,1621,1622,1023,-1,1033,1036,1618,-1,1623,1624,1017,-1,1012,1018,1623,-1,1625,1619,1626,-1,1627,1628,1629,-1,1630,1627,1629,-1,1631,1632,1008,-1,1007,1004,1005,-1,1633,1634,1005,-1,1394,1004,1632,-1,1000,995,1001,-1,1635,994,996,-1,1636,1637,991,-1,1638,1639,1640,-1,988,990,985,-1,981,983,980,-1,1641,983,1642,-1,1643,979,1644,-1,1645,1646,969,-1,1647,971,1648,-1,1619,1649,1626,-1,1416,965,964,-1,1063,1068,1650,-1,1650,1651,1652,-1,1586,959,958,-1,1653,1246,1654,-1,954,955,1655,-1,1656,1657,951,-1,1658,954,1655,-1,947,949,1659,-1,1660,1661,944,-1,945,944,1661,-1,943,942,1583,-1,940,939,1662,-1,872,935,1663,-1,926,927,1251,-1,1664,1665,1666,-1,1666,922,1667,-1,1668,924,1669,-1,1670,1664,1671,-1,922,1666,1665,-1,917,916,1672,-1,917,1672,1673,-1,915,914,1674,-1,1675,1676,919,-1,1677,911,908,-1,908,910,855,-1,854,1678,909,-1,1679,1680,1681,-1,1682,1683,1684,-1,1685,905,904,-1,1686,1687,1688,-1,1689,1690,1691,-1,1692,1693,1694,-1,891,890,1258,-1,887,889,894,-1,1695,1084,1506,-1,880,882,1696,-1,1697,1698,1577,-1,1699,875,1700,-1,1701,1702,930,-1,1703,934,871,-1,1704,1080,1078,-1,1705,1706,942,-1,864,1706,1705,-1,869,868,1269,-1,869,1707,944,-1,867,866,1708,-1,954,1708,1290,-1,1653,1245,1247,-1,1290,1708,1709,-1,1254,1710,1110,-1,1078,863,862,-1,1711,1712,1713,-1,857,856,1714,-1,1715,1716,1686,-1,1715,1113,1717,-1,1717,1718,1719,-1,847,1720,896,-1,849,891,1694,-1,845,844,887,-1,885,840,882,-1,1701,1721,873,-1,836,835,1078,-1,1509,832,831,-1,1509,1240,1471,-1,1575,808,807,-1,973,972,1251,-1,823,1165,1164,-1,178,1188,821,-1,1290,1473,1722,-1,803,1723,804,-1,1724,1725,1726,-1,1727,794,793,-1,789,797,1728,-1,787,793,796,-1,1729,794,1508,-1,1239,1575,1728,-1,767,785,1730,-1,792,759,754,-1,781,1314,782,-1,766,1731,784,-1,773,775,1732,-1,1222,778,1526,-1,1304,1733,1467,-1,1734,1299,1467,-1,1732,1457,1321,-1,1735,1733,1306,-1,1307,1736,1143,-1,1519,752,1520,-1,1737,768,767,-1,757,802,762,-1,756,755,769,-1,544,178,545,-1,1397,1738,650,-1,745,744,372,-1,1739,1740,1741,-1,1742,740,1739,-1,741,1743,1744,-1,1745,1746,407,-1,1747,1748,736,-1,1749,332,336,-1,1750,331,333,-1,190,188,187,-1,1751,324,1752,-1,1753,1754,441,-1,1755,1756,1757,-1,728,1758,1759,-1,1760,1761,593,-1,694,590,1760,-1,725,722,721,-1,1762,561,1763,-1,541,560,1764,-1,1764,1765,541,-1,1765,714,1766,-1,576,53,1364,-1,569,1767,540,-1,1768,462,1769,-1,1770,463,1771,-1,1772,1773,1774,-1,1775,711,704,-1,1776,1777,127,-1,14,13,1778,-1,1779,1780,700,-1,1781,1782,702,-1,720,1783,1784,-1,1785,1786,749,-1,1778,701,1787,-1,709,698,1788,-1,1789,523,1790,-1,696,1791,697,-1,1792,749,748,-1,1793,1216,689,-1,577,650,578,-1,578,1794,690,-1,1795,130,608,-1,1796,1797,686,-1,679,678,677,-1,138,141,675,-1,1798,1799,585,-1,1796,674,1800,-1,1801,668,1802,-1,1803,671,1804,-1,580,669,668,-1,666,149,150,-1,1805,588,1806,-1,663,1807,1808,-1,1809,665,485,-1,468,662,1810,-1,1811,661,660,-1,174,472,658,-1,497,1812,489,-1,654,1813,1814,-1,654,1815,494,-1,490,1814,1816,-1,1817,1818,655,-1,1819,1820,1794,-1,648,646,649,-1,648,638,640,-1,227,228,1821,-1,640,639,634,-1,630,632,1822,-1,1823,1824,1825,-1,226,225,1826,-1,1827,1828,1829,-1,629,476,631,-1,240,1830,637,-1,1831,1832,1833,-1,627,1834,1835,-1,1836,624,501,-1,196,246,1837,-1,1838,1839,1840,-1,1841,1842,1843,-1,1844,1845,1846,-1,1846,1847,1501,-1,1848,684,1849,-1,458,727,459,-1,326,1850,611,-1,175,233,612,-1,1797,1851,1852,-1,160,1795,610,-1,188,1853,189,-1,1854,1779,1855,-1,1856,1433,1513,-1,742,1857,1858,-1,536,535,1859,-1,569,568,1860,-1,720,1784,1861,-1,697,1862,1863,-1,466,134,589,-1,399,1864,1865,-1,400,1866,1867,-1,598,1868,1869,-1,559,576,1364,-1,1870,1871,1872,-1,563,1873,1763,-1,1874,1764,562,-1,1874,714,1764,-1,534,1875,541,-1,569,572,1876,-1,1364,53,1532,-1,552,554,54,-1,1877,548,547,-1,554,555,58,-1,570,542,541,-1,1860,542,1878,-1,573,537,177,-1,1876,572,1870,-1,1879,603,602,-1,1789,530,526,-1,529,528,595,-1,1880,1881,1862,-1,1790,467,1789,-1,503,505,181,-1,1882,1883,718,-1,1884,1885,1886,-1,1887,514,1886,-1,1888,1889,1890,-1,1884,1891,521,-1,1892,519,1890,-1,513,1891,1884,-1,1893,1894,1886,-1,1889,1895,1892,-1,718,1883,1896,-1,1897,1898,510,-1,584,1899,1900,-1,511,1873,563,-1,511,717,1873,-1,1901,1885,1897,-1,1851,1797,608,-1,1838,1902,1903,-1,1904,222,1905,-1,485,1906,1907,-1,480,1908,1835,-1,1909,1910,1911,-1,1812,657,1912,-1,1905,637,1913,-1,1914,1906,641,-1,498,1915,630,-1,196,1916,194,-1,1917,1918,1919,-1,174,469,472,-1,1920,1921,1909,-1,497,1922,657,-1,1923,164,1924,-1,1925,1756,1755,-1,1926,1927,1928,-1,1928,1929,620,-1,731,615,614,-1,511,521,461,-1,419,457,459,-1,458,1930,1931,-1,1932,244,1933,-1,1934,193,454,-1,435,1935,433,-1,1936,1937,1938,-1,449,448,1936,-1,443,1939,338,-1,1940,339,338,-1,1940,1941,339,-1,1942,1943,1944,-1,1945,436,438,-1,431,1946,1947,-1,1948,429,428,-1,432,435,430,-1,437,1949,1943,-1,1942,1950,1951,-1,1952,1953,1954,-1,1947,1955,432,-1,1956,1944,1943,-1,1957,421,420,-1,1958,1959,1960,-1,1959,1961,1960,-1,1746,405,407,-1,403,407,404,-1,401,737,402,-1,1759,419,1962,-1,1963,1964,1965,-1,1966,1758,1967,-1,401,1759,1966,-1,398,1968,1965,-1,1969,1867,1866,-1,1970,388,1971,-1,1972,1973,1974,-1,1975,1972,1976,-1,371,373,379,-1,1977,375,374,-1,464,371,1978,-1,1979,369,464,-1,1980,1981,1982,-1,368,365,367,-1,1980,364,1983,-1,1984,1985,1925,-1,362,1986,359,-1,1987,358,357,-1,353,729,354,-1,352,1988,353,-1,1989,354,345,-1,1990,1991,347,-1,349,354,1989,-1,1992,744,746,-1,1993,337,1994,-1,337,732,1994,-1,333,591,1750,-1,234,1995,1996,-1,232,234,1996,-1,1997,1998,1999,-1,310,312,242,-1,2000,309,2001,-1,2001,1934,2000,-1,245,247,2002,-1,247,306,2002,-1,2003,249,2004,-1,2005,2006,460,-1,2007,2008,2009,-1,298,297,2010,-1,299,298,2011,-1,2012,293,2013,-1,2014,282,292,-1,286,2015,2016,-1,2015,2017,2016,-1,2018,276,2019,-1,277,274,276,-1,274,2020,272,-1,2021,2022,268,-1,2023,266,2024,-1,2025,2026,1843,-1,2027,1841,2026,-1,265,208,266,-1,2028,2029,2030,-1,2031,2032,2033,-1,2034,200,202,-1,2034,202,2035,-1,2036,2034,2037,-1,198,2038,2006,-1,199,198,2039,-1,256,2039,2040,-1,2041,2042,2007,-1,250,2043,2044,-1,246,196,247,-1,236,2045,1998,-1,323,1821,2046,-1,222,223,240,-1,2047,859,861,-1,217,216,2048,-1,273,2049,275,-1,2050,2051,2052,-1,2053,207,204,-1,201,200,2036,-1,477,2054,201,-1,2042,2055,2056,-1,2057,2058,197,-1,192,191,1837,-1,1853,2059,1850,-1,171,2059,186,-1,2060,2061,2062,-1,2063,601,600,-1,1848,600,599,-1,605,602,179,-1,505,1872,2064,-1,2065,2066,509,-1,2067,2068,2069,-1,2070,670,2071,-1,2072,2073,173,-1,2074,171,176,-1,2075,2076,155,-1,2077,167,2078,-1,158,132,2079,-1,2079,2080,166,-1,2071,168,167,-1,161,610,1924,-1,2081,162,2082,-1,2079,128,2083,-1,129,157,2084,-1,1924,609,2085,-1,1852,683,182,-1,149,140,142,-1,145,144,2086,-1,2087,2088,676,-1,135,152,151,-1,587,1808,1807,-1,132,466,126,-1,131,130,1795,-1,1851,129,2089,-1,2076,2075,2090,-1,2091,2092,2090,-1,128,127,1777,-1,132,2093,2079,-1,125,123,2094,-1,2095,2096,122,-1,2097,77,95,-1,73,120,119,-1,2098,117,68,-1,125,117,116,-1,2099,124,123,-1,113,2094,114,-1,109,108,110,-1,2100,2101,96,-1,2102,65,2103,-1,2102,2104,2105,-1,74,101,64,-1,2102,2105,2106,-1,103,2107,105,-1,104,103,95,-1,91,2108,2109,-1,95,103,105,-1,86,2110,104,-1,2098,2111,89,-1,2109,2112,91,-1,87,2111,2113,-1,81,88,2114,-1,100,80,79,-1,51,2115,52,-1,73,72,70,-1,67,1207,2098,-1,56,58,66,-1,74,63,62,-1,64,58,62,-1,566,1207,567,-1,556,57,56,-1,1532,55,1516,-1,76,48,50,-1,1192,1200,71,-1,3,2116,2117,-1,2118,1436,2119,-1,38,2120,2121,-1,1355,29,2122,-1,2123,2124,2120,-1,35,34,40,-1,1,2125,2,-1,4,1355,2126,-1,47,2122,29,-1,2127,2128,2122,-1,2121,2129,6,-1,2130,2116,5,-1,2131,26,28,-1,27,44,43,-1,2132,9,23,-1,2133,21,20,-1,2132,2134,24,-1,22,2132,17,-1,12,22,16,-1,701,1778,18,-1,704,25,21,-1,2135,1,0,-1,2136,0,2,-1,37,1438,2123,-1,14,2137,15,-1,702,704,2133,-1,16,13,12,-1,16,22,17,-1,24,9,2132,-1,1778,13,16,-1,2133,704,21,-1,23,17,2132,-1,43,28,27,-1,2130,5,45,-1,6,2138,2121,-1,46,28,2139,-1,2122,47,2127,-1,29,31,47,-1,1355,30,29,-1,2120,33,2123,-1,2122,2126,1355,-1,43,2139,28,-1,2117,2140,2141,-1,50,94,76,-1,94,50,2097,-1,1516,1363,1532,-1,566,2113,2111,-1,64,2103,58,-1,62,75,74,-1,66,79,56,-1,67,2098,68,-1,70,69,73,-1,2106,2105,2101,-1,104,2110,99,-1,81,83,88,-1,87,89,2111,-1,2112,2142,91,-1,2098,89,90,-1,104,2108,86,-1,105,93,95,-1,78,2143,85,-1,2108,2144,2109,-1,95,2145,104,-1,105,2107,106,-1,64,63,74,-1,2104,2102,2103,-1,102,98,2146,-1,96,106,2100,-1,2099,2147,124,-1,122,121,120,-1,125,108,117,-1,2098,90,117,-1,73,69,120,-1,77,2148,95,-1,2096,2095,112,-1,2096,121,122,-1,114,2149,115,-1,2094,111,125,-1,128,1777,2083,-1,2091,2090,2081,-1,2090,507,2076,-1,2150,2151,506,-1,2089,1852,1851,-1,131,1795,160,-1,2093,128,2079,-1,126,2093,132,-1,2152,2153,644,-1,2087,676,140,-1,144,664,2086,-1,149,142,150,-1,182,1849,1852,-1,1924,610,609,-1,129,2084,2089,-1,2083,2080,2079,-1,132,607,133,-1,2082,2091,2081,-1,164,161,1924,-1,167,2070,2071,-1,163,2082,162,-1,2077,165,2070,-1,2070,167,2077,-1,2080,2078,166,-1,2079,166,158,-1,167,166,2078,-1,155,2154,2075,-1,2154,2155,2075,-1,171,2156,176,-1,173,172,2072,-1,2070,1802,670,-1,178,177,545,-1,2064,181,505,-1,179,2157,605,-1,599,684,1848,-1,600,2064,2063,-1,1845,1928,1846,-1,186,172,171,-1,187,189,326,-1,188,2059,1853,-1,1902,2158,2159,-1,1904,2160,194,-1,2161,2160,2162,-1,2038,2058,253,-1,1931,2163,2164,-1,204,2165,258,-1,1842,212,210,-1,2049,217,2048,-1,2166,2167,271,-1,2168,2048,2015,-1,220,219,2169,-1,295,220,296,-1,2170,861,1501,-1,637,2045,238,-1,621,225,228,-1,613,231,326,-1,323,234,1821,-1,453,2171,1830,-1,246,245,2067,-1,196,307,247,-1,249,2172,248,-1,2041,2173,2174,-1,199,2039,256,-1,198,2006,2005,-1,2036,200,2034,-1,202,2175,2035,-1,2031,203,2032,-1,2030,2176,2028,-1,2177,265,264,-1,2025,1843,2178,-1,2026,1841,1843,-1,266,208,2024,-1,2179,215,279,-1,2021,2180,2181,-1,2018,277,276,-1,283,288,290,-1,2015,2182,2017,-1,2183,2184,2185,-1,293,292,2013,-1,301,2186,2187,-1,298,300,2011,-1,2188,296,301,-1,460,2189,2005,-1,2003,2172,249,-1,1934,456,2000,-1,309,242,2001,-1,312,243,242,-1,2190,318,317,-1,322,324,1751,-1,1996,320,232,-1,232,325,233,-1,1938,1750,591,-1,337,339,732,-1,441,1754,733,-1,1973,1972,2191,-1,2192,2193,2194,-1,184,183,2195,-1,345,2196,343,-1,348,2197,355,-1,353,1988,729,-1,357,2198,1987,-1,1987,2199,358,-1,1985,356,2200,-1,1985,2200,1925,-1,362,359,363,-1,1982,2201,1980,-1,1979,370,369,-1,371,2202,1978,-1,618,380,744,-1,377,1977,374,-1,371,379,377,-1,617,378,618,-1,2203,2204,1975,-1,1975,2204,2205,-1,1867,389,386,-1,2206,2207,1975,-1,2208,1971,388,-1,398,738,1968,-1,1966,1759,1758,-1,1759,394,419,-1,2209,2210,406,-1,2211,2212,2213,-1,2214,1955,1954,-1,429,1955,1947,-1,438,1943,2215,-1,437,1943,438,-1,2216,435,434,-1,2217,1947,1946,-1,431,1947,432,-1,1949,1956,1943,-1,1942,1944,2218,-1,440,1753,441,-1,1939,1940,338,-1,443,338,444,-1,447,330,2219,-1,1936,1938,449,-1,326,2220,450,-1,435,1950,1935,-1,1752,2221,1751,-1,311,313,452,-1,419,459,1962,-1,245,2002,2067,-1,461,1770,511,-1,1928,620,1926,-1,1929,2222,620,-1,1925,1755,1984,-1,1978,1979,464,-1,1923,165,164,-1,2223,2224,2225,-1,462,461,718,-1,468,1810,469,-1,657,1812,497,-1,475,1913,637,-1,226,1921,1920,-1,479,2051,212,-1,2226,2227,2228,-1,1905,222,637,-1,2229,1810,2230,-1,2231,491,1816,-1,1835,481,480,-1,1809,485,1907,-1,2232,2233,2234,-1,608,130,1851,-1,1897,504,1901,-1,1898,1884,521,-1,511,563,2065,-1,510,521,511,-1,1899,2235,1900,-1,510,504,1897,-1,1892,1890,1889,-1,1893,1886,2236,-1,1884,514,513,-1,1893,518,1894,-1,515,1888,1890,-1,1887,1886,1894,-1,1886,514,1884,-1,718,461,1882,-1,503,181,180,-1,562,715,1874,-1,1862,1791,1880,-1,595,695,529,-1,1789,526,523,-1,691,2237,2238,-1,1863,2238,697,-1,545,2239,546,-1,1870,2240,1876,-1,1767,1860,1878,-1,1875,570,541,-1,58,57,554,-1,574,1877,547,-1,54,2241,552,-1,552,553,1859,-1,1765,534,541,-1,1763,564,563,-1,1872,2066,1870,-1,559,1364,557,-1,2242,598,1869,-1,2243,720,2244,-1,222,1916,191,-1,581,671,582,-1,667,1805,148,-1,582,2235,2245,-1,2246,399,1865,-1,466,589,530,-1,133,187,1761,-1,1861,721,720,-1,1860,1767,569,-1,2241,576,575,-1,2241,53,576,-1,1859,553,536,-1,1860,568,543,-1,179,178,1793,-1,610,161,160,-1,1797,1852,1849,-1,242,241,2001,-1,229,613,611,-1,614,612,233,-1,1849,182,1848,-1,1501,1844,1846,-1,1847,619,1501,-1,2055,2247,2163,-1,1903,474,629,-1,501,624,623,-1,1836,2248,624,-1,627,1835,628,-1,637,222,240,-1,476,473,1920,-1,1827,2249,1828,-1,226,1920,473,-1,1823,1910,1824,-1,1822,488,630,-1,2233,2250,2251,-1,634,647,640,-1,1824,1814,1813,-1,648,1738,638,-1,646,1794,649,-1,1819,2252,1820,-1,1817,1906,1818,-1,654,1814,1815,-1,174,2253,175,-1,1853,1850,189,-1,1811,662,661,-1,662,2254,1810,-1,1809,662,665,-1,663,1811,1807,-1,2255,1806,588,-1,144,143,2256,-1,1805,667,588,-1,666,2257,149,-1,668,581,580,-1,1803,1804,674,-1,1802,1923,1801,-1,1804,1800,674,-1,673,672,2258,-1,583,1899,584,-1,1798,2259,1799,-1,677,2260,679,-1,686,672,1796,-1,577,579,688,-1,578,649,1794,-1,2157,1793,689,-1,1792,748,2261,-1,1791,1862,697,-1,523,522,1790,-1,2262,1778,1787,-1,1792,1785,749,-1,720,1781,1783,-1,1781,720,1782,-1,14,1778,2262,-1,1776,127,2263,-1,11,23,9,-1,704,703,1775,-1,1772,2264,1773,-1,1770,1771,716,-1,1769,2265,1768,-1,540,572,569,-1,1765,1764,714,-1,1901,504,718,-1,2244,722,2266,-1,725,724,722,-1,726,723,694,-1,467,1790,2267,-1,2268,2269,1976,-1,187,133,607,-1,1753,2270,1754,-1,334,2271,335,-1,1754,425,422,-1,2272,734,1993,-1,1745,407,403,-1,2273,1395,747,-1,2274,350,2275,-1,2274,2276,350,-1,756,769,751,-1,1737,1454,768,-1,1376,752,1519,-1,2277,774,2278,-1,1458,2277,1325,-1,1321,776,1732,-1,1734,1467,1735,-1,1733,1735,1467,-1,1222,776,778,-1,1732,1305,773,-1,2279,1726,801,-1,754,786,792,-1,767,1730,1737,-1,1508,1737,1730,-1,1728,752,1239,-1,1730,2280,1508,-1,794,1727,1508,-1,795,787,796,-1,799,792,786,-1,797,798,1728,-1,793,787,1727,-1,1724,785,784,-1,1290,1722,805,-1,1723,808,804,-1,820,1793,821,-1,780,823,1164,-1,1102,2281,1473,-1,1575,831,808,-1,1241,1509,831,-1,835,863,1078,-1,2282,1260,2283,-1,839,2284,840,-1,2285,1572,845,-1,2285,2286,892,-1,849,1694,1693,-1,2287,903,899,-1,1717,1719,2288,-1,1712,2289,1713,-1,856,915,2290,-1,1713,1675,1665,-1,1492,1108,868,-1,1103,1253,1252,-1,2291,1254,865,-1,1653,2292,1245,-1,956,954,1290,-1,954,867,1708,-1,1707,869,1269,-1,2293,1492,2294,-1,1705,942,939,-1,1704,1078,1079,-1,1080,836,1078,-1,2295,2296,876,-1,882,2297,1696,-1,935,872,871,-1,885,879,883,-1,1085,2298,1083,-1,1695,1085,1084,-1,1694,1259,1692,-1,1719,2299,2300,-1,1718,2301,2302,-1,897,2303,898,-1,906,2288,2304,-1,1678,2305,909,-1,909,908,854,-1,908,855,854,-1,1677,908,907,-1,2306,1682,1684,-1,1675,919,1665,-1,1673,1574,917,-1,2307,1676,2308,-1,921,2309,923,-1,1671,2310,1670,-1,925,927,926,-1,1669,1670,1668,-1,1666,1671,1664,-1,2311,926,1251,-1,1577,2312,2313,-1,2297,2314,2315,-1,1663,1702,872,-1,1079,1580,2316,-1,2317,943,1583,-1,1707,2318,1660,-1,1660,944,1707,-1,2319,1488,2320,-1,1657,1656,2321,-1,950,1656,951,-1,1653,1654,2322,-1,1246,2323,1654,-1,1246,1240,1585,-1,2324,1072,2325,-1,1067,1378,1651,-1,1063,962,961,-1,1610,1596,2326,-1,1646,977,976,-1,2327,2328,1645,-1,1641,2329,983,-1,987,1644,979,-1,985,984,988,-1,1637,2330,998,-1,996,995,993,-1,998,2330,2331,-1,2332,2333,2334,-1,1003,1005,1004,-1,1005,1003,1633,-1,1631,1008,2335,-1,1224,1631,2335,-1,2336,1628,2337,-1,1623,1017,1012,-1,1624,1015,1017,-1,2338,1027,1026,-1,2338,2339,2340,-1,1025,1419,1031,-1,1022,1026,2341,-1,2342,1039,2343,-1,2344,1039,1614,-1,1612,2345,1035,-1,2346,2342,2343,-1,1042,2347,1616,-1,2348,2349,1608,-1,1606,1604,1603,-1,1605,1036,1033,-1,1600,1602,1606,-1,1413,1380,1409,-1,2350,1379,1380,-1,2351,2352,1046,-1,1057,1593,2353,-1,1054,2354,1052,-1,2355,2356,1049,-1,1062,1416,964,-1,1066,1070,1068,-1,2357,1378,2358,-1,1075,1587,1586,-1,1589,1246,1585,-1,1583,1582,2359,-1,1584,2293,1582,-1,1581,870,869,-1,1580,1079,937,-1,1086,1084,1579,-1,2296,2360,876,-1,1577,1578,2312,-1,927,973,1251,-1,1093,1503,1094,-1,1359,1098,1089,-1,1645,969,2361,-1,1099,1427,1136,-1,1575,1239,1241,-1,1167,1520,769,-1,1102,1101,1291,-1,2362,1102,1287,-1,1497,1487,1107,-1,1497,1491,1487,-1,2363,1261,1112,-1,1122,2364,1555,-1,2365,1302,1126,-1,1484,1565,1485,-1,1475,2366,1563,-1,1474,1561,2367,-1,1559,1104,1103,-1,2368,1554,1495,-1,1136,1427,1166,-1,1553,1166,1427,-1,2369,1429,1139,-1,1144,816,815,-1,815,2370,1140,-1,1326,2371,1551,-1,1155,1550,1162,-1,1163,1151,1548,-1,1543,1162,1550,-1,2372,2373,1089,-1,1157,1545,1544,-1,1158,1089,2373,-1,1426,1176,1333,-1,1338,1229,1171,-1,1174,1179,1336,-1,2374,1334,1172,-1,1169,1173,1520,-1,2375,1210,1541,-1,1531,2376,1515,-1,1186,1188,1539,-1,1362,1187,1186,-1,1530,2377,1518,-1,2378,1533,1537,-1,1535,1197,1536,-1,1201,1536,1192,-1,1534,1536,1201,-1,1435,1430,70,-1,1184,1208,1185,-1,1530,1191,1531,-1,1193,71,1431,-1,1139,1529,2369,-1,1183,814,819,-1,557,1364,1211,-1,1021,1620,2379,-1,1521,2380,1522,-1,1173,2381,1519,-1,1448,1337,2382,-1,1423,1233,1230,-1,1518,2383,1208,-1,1199,1198,1211,-1,1515,1534,1201,-1,2383,1518,2377,-1,178,821,1793,-1,1508,1727,783,-1,779,1507,1134,-1,1705,939,938,-1,1247,1245,1244,-1,1243,1092,956,-1,824,780,779,-1,2384,2385,2386,-1,1504,2387,1502,-1,2387,1501,1502,-1,2287,899,902,-1,2388,1131,2389,-1,1703,873,837,-1,1495,1496,2368,-1,1494,2390,1123,-1,2391,1267,2392,-1,1492,864,863,-1,1491,1498,1265,-1,1488,1490,2393,-1,1254,1110,2394,-1,1486,1119,2395,-1,1264,1263,1484,-1,634,1270,1272,-1,1709,1708,866,-1,1272,1280,1279,-1,1332,1283,1279,-1,1281,1477,1282,-1,1476,1480,1286,-1,1563,1105,1104,-1,1287,1473,1288,-1,1296,1292,1297,-1,1294,1295,1101,-1,1298,1295,1127,-1,770,1297,1301,-1,1469,1465,1308,-1,1222,1221,1306,-1,1309,1310,1463,-1,1141,1313,1312,-1,1311,1315,1312,-1,1462,810,1309,-1,1460,1314,1311,-1,1313,2371,1316,-1,1143,1736,2396,-1,1459,2397,1318,-1,1218,2398,1324,-1,1455,1134,1456,-1,1327,1214,1328,-1,1281,1332,1331,-1,1216,1793,820,-1,1451,1453,2131,-1,1450,1343,2399,-1,1337,1449,1338,-1,1447,1174,1169,-1,1339,1346,2400,-1,36,2401,1349,-1,1446,2399,1445,-1,1342,1425,1423,-1,35,1340,1342,-1,1349,2402,1440,-1,1441,2403,1439,-1,1437,2404,1438,-1,1436,2405,1098,-1,72,1451,1434,-1,70,1430,71,-1,1429,1205,1204,-1,1358,1087,1138,-1,1427,1099,1098,-1,1344,1343,1426,-1,1367,1423,1368,-1,1371,1234,1370,-1,1542,1336,1421,-1,1372,1227,1335,-1,1420,2381,1421,-1,1419,1506,1086,-1,955,956,2406,-1,1072,958,957,-1,2324,2357,1072,-1,1416,1590,960,-1,1367,1415,1370,-1,1410,2407,1381,-1,1026,1404,2341,-1,1387,2408,1385,-1,1341,1354,1402,-1,1399,2409,1400,-1,2330,1637,2410,-1,1453,1452,747,-1,747,1396,1453,-1,1270,634,750,-1,747,1452,51,-1,1399,2125,2411,-1,2412,2413,1410,-1,2324,1652,1651,-1,1072,957,2325,-1,1509,1241,1240,-1,950,952,2414,-1,963,2415,1061,-1,2330,2416,2417,-1,1028,1419,1025,-1,1420,1422,1228,-1,1421,1335,1422,-1,1233,1367,1370,-1,1205,1429,2369,-1,1366,1530,1365,-1,1184,1181,1188,-1,1362,1517,1208,-1,1098,2405,1360,-1,1358,2418,1359,-1,1355,1357,30,-1,2131,28,2419,-1,1353,2,1354,-1,2420,2403,1441,-1,755,2421,1351,-1,37,1350,1438,-1,1345,2422,1343,-1,1341,1425,1342,-1,1340,1354,1341,-1,1339,1333,1180,-1,1179,1447,1339,-1,1177,1338,1170,-1,1234,1336,1178,-1,1178,1231,1234,-1,1334,1180,1333,-1,1215,1214,650,-1,1327,1217,1331,-1,1330,1328,1329,-1,1326,1328,1330,-1,764,780,1164,-1,1324,2423,1322,-1,1218,1323,1325,-1,1322,1320,1323,-1,1321,1457,1320,-1,1319,2423,1317,-1,1143,1142,1525,-1,1316,1456,1311,-1,781,1461,1314,-1,1314,1461,1309,-1,1315,1309,1464,-1,810,809,1310,-1,1220,1466,1465,-1,1306,1733,773,-1,1300,1301,1298,-1,1298,1468,1299,-1,1292,1101,1295,-1,1292,1296,1293,-1,1244,1289,805,-1,1472,1288,1473,-1,1103,1472,1290,-1,1286,2424,1284,-1,650,1332,1279,-1,1278,2278,1276,-1,2425,2426,1557,-1,635,634,1266,-1,1498,1491,1497,-1,2390,1494,1556,-1,1122,1555,1554,-1,1261,2363,1130,-1,1259,1694,891,-1,1254,2394,1252,-1,1251,972,1249,-1,818,2427,2428,-1,2314,2297,2429,-1,1243,2430,1090,-1,1245,2430,1243,-1,2291,950,2414,-1,1242,782,1133,-1,834,1471,1246,-1,821,1188,1181,-1,1539,1188,2431,-1,2370,1185,1140,-1,1199,1363,1200,-1,2432,1235,1209,-1,1233,1231,1230,-1,1232,1446,1230,-1,1229,1231,1171,-1,1465,771,1220,-1,2396,1736,2397,-1,1464,1463,1524,-1,1331,1214,1327,-1,1528,1211,1212,-1,1362,1184,1187,-1,1210,2376,1190,-1,1208,2383,1206,-1,1136,817,816,-1,67,61,567,-1,1206,1529,1140,-1,1205,1366,1203,-1,1432,557,1528,-1,60,1200,61,-1,1192,1536,1199,-1,1536,1197,1199,-1,1196,1212,1194,-1,1530,1189,1191,-1,1183,1185,2370,-1,2433,1533,2378,-1,1177,2382,1337,-1,1178,1336,1179,-1,1174,1542,1173,-1,1171,2374,1172,-1,1428,1204,1435,-1,1165,817,1166,-1,1146,2372,1089,-1,1163,1549,1156,-1,1152,1163,1155,-1,1161,1546,1149,-1,1544,1153,1152,-1,1156,1158,1154,-1,1151,1163,1152,-1,1148,1160,1149,-1,1144,1137,1136,-1,1141,1143,2396,-1,1159,1144,1087,-1,1140,1139,1087,-1,1156,1145,1159,-1,1137,1549,1135,-1,768,1454,1133,-1,1483,2434,2426,-1,1125,1567,1126,-1,1124,2364,1122,-1,1562,2435,1475,-1,1100,2436,2437,-1,1567,1566,1274,-1,2438,2439,1263,-1,1527,873,1721,-1,2440,2441,1570,-1,1102,1473,1287,-1,1109,1111,1120,-1,1105,1117,1103,-1,1095,2442,1096,-1,2442,2443,1096,-1,1089,1159,1087,-1,933,934,812,-1,1086,1579,1032,-1,2317,1583,2359,-1,2444,2414,952,-1,2354,1076,1052,-1,2323,1246,1589,-1,1075,1586,958,-1,1585,1587,1588,-1,1071,1073,958,-1,1068,1063,1066,-1,1063,1064,1065,-1,1591,1064,961,-1,1060,2445,1048,-1,2356,2446,1049,-1,2353,1047,1057,-1,1046,2447,2351,-1,1052,2353,1593,-1,1049,1051,2355,-1,1077,1059,1595,-1,1408,1599,1045,-1,1043,1047,2353,-1,2445,1058,1048,-1,1604,2448,1598,-1,2449,2450,2451,-1,2452,2449,2451,-1,1614,2453,2344,-1,2344,1616,1615,-1,1404,1026,1617,-1,1031,1033,1025,-1,2454,1028,1027,-1,2341,1023,1022,-1,1020,1620,1021,-1,2379,2455,1021,-1,1016,2379,1017,-1,2456,2457,1009,-1,1017,2379,1625,-1,2458,1009,2459,-1,2458,2336,1009,-1,2335,1248,1224,-1,1008,1632,1004,-1,1005,1634,1006,-1,1631,1224,1392,-1,1002,1004,999,-1,999,1001,1097,-1,2331,997,998,-1,1639,1637,1636,-1,2460,1637,1639,-1,986,2461,984,-1,982,2462,983,-1,2462,1642,983,-1,981,2463,976,-1,2361,2327,1645,-1,981,1643,2463,-1,1392,2464,1398,-1,962,1383,960,-1,960,1590,961,-1,959,2325,957,-1,2465,867,953,-1,954,1658,953,-1,870,1581,2294,-1,946,869,944,-1,939,943,1662,-1,938,939,941,-1,941,936,938,-1,2466,930,932,-1,1578,884,883,-1,883,2467,1578,-1,2468,878,2469,-1,925,929,928,-1,1670,2310,1668,-1,1669,924,926,-1,2470,1668,2471,-1,922,923,1667,-1,2472,2473,2474,-1,918,914,916,-1,1676,1675,2308,-1,910,908,911,-1,2475,905,1685,-1,1686,1688,1682,-1,903,898,2476,-1,902,901,2477,-1,902,2477,2478,-1,897,2479,2303,-1,2480,893,895,-1,2481,890,892,-1,887,886,888,-1,2482,886,846,-1,884,2483,885,-1,879,885,882,-1,2484,877,2485,-1,931,930,1702,-1,871,873,1703,-1,934,1703,812,-1,2293,1584,1492,-1,865,867,1656,-1,1653,1247,1246,-1,1254,1253,1709,-1,868,1108,1269,-1,861,2311,1501,-1,1711,1664,1670,-1,1712,1711,2486,-1,858,2487,916,-1,2488,1680,1678,-1,857,853,858,-1,1113,2287,1717,-1,2489,849,1693,-1,2282,845,1572,-1,1500,1085,1695,-1,838,2483,1698,-1,2490,2491,2295,-1,2490,1128,1721,-1,1260,1130,2283,-1,832,1509,833,-1,1471,1240,1246,-1,831,832,804,-1,1093,1505,1503,-1,826,2427,818,-1,825,827,823,-1,822,1236,820,-1,817,1165,818,-1,1188,178,1533,-1,790,810,791,-1,1723,806,808,-1,1722,803,805,-1,1729,800,802,-1,801,760,802,-1,799,798,796,-1,798,752,1728,-1,798,786,753,-1,791,795,797,-1,791,797,789,-1,783,1727,787,-1,1239,752,1376,-1,756,753,786,-1,785,767,766,-1,781,783,788,-1,779,763,1507,-1,1526,1307,1308,-1,1526,778,1307,-1,776,1321,777,-1,2492,1303,1276,-1,769,1520,752,-1,756,751,753,-1,768,1507,766,-1,1731,763,765,-1,2493,2494,1553,-1,762,802,760,-1,757,762,758,-1,754,2421,755,-1,749,2273,747,-1,362,1756,1925,-1,743,1857,742,-1,2495,737,2496,-1,1953,2497,424,-1,736,2498,734,-1,2499,424,423,-1,733,1994,732,-1,445,332,331,-1,1938,331,1750,-1,233,325,2500,-1,1962,459,728,-1,590,525,526,-1,725,694,723,-1,2244,720,722,-1,720,2243,1782,-1,719,2501,707,-1,462,508,1769,-1,511,1770,716,-1,561,1762,715,-1,58,1766,714,-1,1433,558,557,-1,462,1768,713,-1,2502,711,1775,-1,23,11,712,-1,2501,705,707,-1,1782,743,702,-1,702,743,703,-1,18,712,700,-1,699,692,698,-1,694,596,693,-1,694,725,596,-1,692,699,527,-1,577,1215,650,-1,578,679,579,-1,689,687,606,-1,687,579,2503,-1,684,599,685,-1,683,2504,180,-1,680,139,678,-1,677,675,681,-1,676,2505,675,-1,2235,1899,2245,-1,674,1796,672,-1,1801,2085,1804,-1,1803,674,673,-1,670,1802,668,-1,1899,2506,1805,-1,666,152,146,-1,2152,483,147,-1,1808,664,663,-1,144,2256,665,-1,660,1807,1811,-1,1809,2254,662,-1,470,659,661,-1,468,470,661,-1,2074,611,1850,-1,658,2253,174,-1,2253,1922,175,-1,654,1817,655,-1,651,2507,652,-1,1819,1794,646,-1,650,1738,648,-1,646,648,640,-1,644,645,2251,-1,2234,2508,499,-1,633,635,1832,-1,1913,2509,1905,-1,203,205,625,-1,496,1826,225,-1,620,183,185,-1,2063,2064,2510,-1,2511,2512,2513,-1,615,2514,612,-1,612,2514,229,-1,324,2515,1752,-1,608,610,1795,-1,189,1850,326,-1,177,179,602,-1,177,538,2516,-1,1876,2240,563,-1,53,2241,54,-1,597,598,2242,-1,596,1861,594,-1,530,590,526,-1,616,618,2517,-1,586,2086,587,-1,586,149,2257,-1,679,690,680,-1,1215,577,1216,-1,1871,1870,572,-1,576,559,574,-1,570,531,597,-1,1876,565,569,-1,510,509,505,-1,566,556,56,-1,565,1876,563,-1,560,562,1764,-1,555,1859,535,-1,556,54,554,-1,552,1859,555,-1,550,551,553,-1,547,549,551,-1,548,2518,549,-1,2519,544,546,-1,537,1869,538,-1,542,1860,543,-1,537,573,540,-1,536,571,534,-1,533,598,531,-1,2237,529,695,-1,530,1789,467,-1,525,524,523,-1,691,719,692,-1,521,1891,520,-1,518,519,2520,-1,520,1882,461,-1,1887,2520,512,-1,1887,512,514,-1,1901,2521,1885,-1,2240,2065,563,-1,511,2065,509,-1,508,503,506,-1,510,1898,521,-1,503,508,504,-1,501,502,1836,-1,496,1922,497,-1,492,494,1815,-1,490,1816,491,-1,1822,486,488,-1,1906,1914,1818,-1,627,500,499,-1,631,476,1911,-1,1919,2522,2523,-1,2054,477,2053,-1,1921,2524,1909,-1,1907,1906,1817,-1,1814,1824,1816,-1,286,2016,287,-1,508,718,504,-1,2193,347,1991,-1,1770,461,463,-1,1846,1928,1927,-1,184,297,185,-1,460,2006,255,-1,2525,2526,2044,-1,457,1930,458,-1,1934,454,456,-1,451,2171,453,-1,449,330,447,-1,450,2219,330,-1,2271,2527,335,-1,732,339,1941,-1,2217,2528,1947,-1,430,435,2216,-1,438,2215,2499,-1,2214,2529,1951,-1,340,2497,2530,-1,420,1953,1952,-1,394,393,419,-1,417,421,415,-1,2531,2532,412,-1,2533,2213,403,-1,2534,2535,2536,-1,2537,408,410,-1,405,2209,406,-1,406,2534,2536,-1,401,1968,738,-1,728,1759,1962,-1,2538,2539,2540,-1,1966,2539,401,-1,389,392,390,-1,390,2208,388,-1,384,2203,2541,-1,380,618,378,-1,379,373,380,-1,374,376,2202,-1,374,2202,371,-1,2542,2543,2544,-1,1756,2201,1982,-1,368,367,1983,-1,1756,362,2201,-1,358,2200,356,-1,350,2199,348,-1,353,2545,351,-1,346,1990,347,-1,344,343,346,-1,344,347,2193,-1,2194,2546,2547,-1,2548,385,387,-1,733,439,441,-1,444,338,2549,-1,336,2549,1749,-1,591,449,1938,-1,230,329,2550,-1,326,327,2551,-1,2551,2220,326,-1,322,2552,323,-1,323,2552,2553,-1,1829,2554,2555,-1,237,315,316,-1,2556,235,316,-1,311,243,312,-1,455,454,2557,-1,248,308,307,-1,2512,2511,2558,-1,256,2040,304,-1,185,299,2170,-1,284,294,2559,-1,2013,2559,2012,-1,296,2011,300,-1,296,2188,294,-1,2559,2013,284,-1,2015,286,285,-1,285,287,2560,-1,2017,2182,2561,-1,288,283,282,-1,2020,274,278,-1,273,276,274,-1,273,272,271,-1,2166,2562,2563,-1,2564,279,281,-1,2021,2181,2022,-1,2565,215,2179,-1,2566,2567,2568,-1,259,625,205,-1,2032,203,626,-1,2175,202,2029,-1,2569,1931,1930,-1,2039,198,2005,-1,307,306,247,-1,2511,199,257,-1,2526,2162,2044,-1,193,244,2570,-1,193,2570,454,-1,243,239,241,-1,1830,2171,1999,-1,238,2045,236,-1,227,1821,234,-1,175,227,232,-1,613,229,231,-1,225,2515,2046,-1,621,1922,496,-1,637,1830,2045,-1,283,221,284,-1,2182,216,2571,-1,2572,219,221,-1,211,210,267,-1,2024,1842,1841,-1,205,204,258,-1,2573,2574,2031,-1,2054,2574,201,-1,2575,2057,197,-1,2158,2576,2159,-1,222,191,193,-1,186,2059,188,-1,2072,172,159,-1,2577,469,174,-1,181,1848,182,-1,1793,2157,179,-1,171,173,2156,-1,176,175,2074,-1,157,170,2084,-1,163,162,161,-1,158,166,168,-1,2082,2078,2080,-1,165,2077,163,-1,160,162,2155,-1,2578,156,160,-1,159,607,132,-1,131,160,156,-1,157,129,131,-1,1804,2085,609,-1,2579,2089,2084,-1,150,142,151,-1,148,2087,140,-1,143,2580,146,-1,2580,143,145,-1,140,676,141,-1,146,2580,666,-1,583,2506,1899,-1,132,134,466,-1,129,1851,130,-1,2075,2081,2090,-1,2093,126,128,-1,111,110,108,-1,123,114,2094,-1,2145,2581,2144,-1,109,2095,122,-1,119,121,2149,-1,68,117,118,-1,116,117,90,-1,120,69,122,-1,2109,2144,2581,-1,2581,2112,2109,-1,107,118,108,-1,106,96,98,-1,99,2107,103,-1,102,2103,64,-1,100,2100,99,-1,98,97,2146,-1,94,2097,95,-1,86,2108,91,-1,89,83,82,-1,87,2582,84,-1,2110,2143,99,-1,86,92,84,-1,87,2113,2582,-1,76,2583,74,-1,73,2115,51,-1,122,69,71,-1,68,118,59,-1,2583,76,94,-1,58,2103,65,-1,59,61,67,-1,53,55,1532,-1,1363,1516,1200,-1,52,49,48,-1,6,42,2138,-1,33,37,2123,-1,40,34,38,-1,35,37,33,-1,2116,3,5,-1,24,2134,21,-1,22,15,19,-1,19,21,2134,-1,18,1778,16,-1,2262,2137,14,-1,6,8,41,-1,4,2126,5,-1,2136,2584,42,-1,2262,20,2137,-1,20,2262,2133,-1,5,43,45,-1,5,2128,43,-1,2585,45,44,-1,45,2585,2130,-1,2135,32,26,-1,8,32,2135,-1,2117,1439,2140,-1,2117,1437,1439,-1,2140,2119,2141,-1,2140,2118,2119,-1,2135,2586,2411,-1,2135,26,2586,-1,82,2587,2147,-1,82,81,2587,-1,2114,91,2142,-1,91,2114,92,-1,2145,2108,104,-1,2108,2145,2144,-1,79,2582,2113,-1,2582,79,78,-1,2588,102,101,-1,2588,98,102,-1,65,2106,66,-1,2106,65,2102,-1,100,2101,2100,-1,2101,100,2106,-1,112,2094,113,-1,112,111,2094,-1,2589,124,2590,-1,2589,114,124,-1,2145,2148,2581,-1,95,2148,2145,-1,121,115,2149,-1,115,121,2096,-1,2092,2083,1777,-1,2083,2092,2091,-1,2151,507,506,-1,2076,507,2151,-1,2089,683,1852,-1,2579,683,2089,-1,2088,2506,583,-1,2087,2506,2088,-1,165,1802,2070,-1,165,1923,1802,-1,2091,2080,2083,-1,2091,2082,2080,-1,153,2150,169,-1,2150,153,2151,-1,2073,168,2071,-1,2072,168,2073,-1,156,154,157,-1,154,156,2578,-1,2077,2082,163,-1,2078,2082,2077,-1,2062,2071,670,-1,2073,2071,2062,-1,505,2066,1872,-1,2066,505,509,-1,1879,601,2063,-1,604,601,1879,-1,2247,2058,2057,-1,2247,2055,2058,-1,2042,2058,2055,-1,2058,2042,253,-1,2166,2052,2167,-1,2052,2166,2591,-1,2592,218,2572,-1,2592,2593,218,-1,295,221,220,-1,221,295,284,-1,328,229,731,-1,229,328,230,-1,2004,2525,2003,-1,2004,2526,2525,-1,2038,255,2006,-1,255,2038,253,-1,1931,727,458,-1,727,1931,2164,-1,2573,2033,2030,-1,2033,2573,2031,-1,2165,2566,2568,-1,2165,206,2566,-1,2177,2566,265,-1,2566,2177,2567,-1,2565,214,215,-1,214,2565,2021,-1,2179,2564,2594,-1,2564,2179,279,-1,211,269,261,-1,211,267,269,-1,2185,2571,2593,-1,2185,2184,2571,-1,2595,2561,2596,-1,2597,2561,2595,-1,2598,1930,457,-1,2598,2569,1930,-1,2599,250,252,-1,2599,2043,250,-1,734,422,424,-1,734,2272,422,-1,1989,2192,349,-1,1989,2193,2192,-1,2195,620,2600,-1,2195,183,620,-1,2193,2546,2194,-1,2193,1991,2546,-1,2198,351,2545,-1,351,2198,2601,-1,1925,1986,362,-1,1986,1925,2200,-1,366,1981,367,-1,366,2602,1981,-1,372,465,745,-1,372,371,465,-1,388,2268,1976,-1,1970,2268,388,-1,1992,618,744,-1,2517,618,1992,-1,2224,385,2548,-1,2224,399,385,-1,1867,2603,2604,-1,1867,1969,2603,-1,399,2605,400,-1,2246,2605,399,-1,738,387,737,-1,2548,387,738,-1,2538,1965,2539,-1,2538,1963,1965,-1,408,395,409,-1,395,408,393,-1,2606,2534,2607,-1,2535,2534,2606,-1,413,1960,1961,-1,413,2608,1960,-1,412,2609,2610,-1,412,2532,2609,-1,1942,1935,1950,-1,2218,1935,1942,-1,1954,429,2611,-1,1954,1955,429,-1,2612,2613,2611,-1,2612,2614,2613,-1,1951,435,2214,-1,1950,435,1951,-1,422,2615,423,-1,422,426,2615,-1,327,448,2551,-1,327,1936,448,-1,2552,1940,2553,-1,2552,1941,1940,-1,2553,1939,1995,-1,1939,2553,1940,-1,1937,329,2616,-1,329,1937,2550,-1,436,316,437,-1,436,2556,316,-1,2218,1999,1935,-1,2218,1997,1999,-1,2617,2190,317,-1,2617,2618,2190,-1,2619,2270,1753,-1,2619,2555,2270,-1,313,431,430,-1,431,313,312,-1,2528,456,427,-1,2528,2000,456,-1,2620,2068,415,-1,1933,2068,2620,-1,2511,251,199,-1,2511,252,251,-1,2609,308,248,-1,2532,308,2609,-1,2044,1959,1958,-1,2044,2043,1959,-1,2621,2622,2623,-1,2621,2008,2622,-1,2039,2607,2210,-1,2005,2607,2039,-1,410,302,303,-1,410,2624,302,-1,2569,2622,2625,-1,2569,2598,2622,-1,2035,1967,2034,-1,1967,2035,2540,-1,2005,2606,2607,-1,2005,2189,2606,-1,1960,2003,2525,-1,2608,2003,1960,-1,1864,625,1865,-1,1864,626,625,-1,2030,396,2176,-1,396,2030,397,-1,2026,390,392,-1,2026,2025,390,-1,2207,2626,2627,-1,2207,261,2626,-1,2268,263,2269,-1,2268,262,263,-1,390,2178,2208,-1,390,2025,2178,-1,2605,2567,2628,-1,2567,2605,2568,-1,2563,379,2629,-1,379,2563,377,-1,2594,616,2630,-1,2594,2564,616,-1,2541,268,384,-1,2541,269,268,-1,1978,2020,1979,-1,272,2020,1978,-1,287,2602,366,-1,2631,2602,287,-1,1982,2597,2632,-1,2597,1982,2561,-1,270,1978,2202,-1,272,1978,270,-1,294,343,2196,-1,294,2188,343,-1,351,2633,2634,-1,2633,351,2601,-1,2547,2635,2010,-1,2635,2547,2546,-1,620,1847,1926,-1,619,1847,620,-1,1929,1845,1844,-1,1845,1929,1928,-1,614,2500,2636,-1,2500,614,233,-1,186,607,159,-1,186,190,607,-1,652,656,655,-1,652,2637,656,-1,2638,1914,2639,-1,2638,651,1914,-1,2254,2230,1810,-1,2254,2640,2230,-1,632,1911,1910,-1,632,631,1911,-1,2228,2234,2233,-1,2228,2508,2234,-1,1904,1916,222,-1,194,1916,1904,-1,2037,2164,2036,-1,2037,727,2164,-1,1838,478,1902,-1,1840,478,1838,-1,1810,471,469,-1,2229,471,1810,-1,1911,1920,1909,-1,1911,476,1920,-1,1906,484,641,-1,485,484,1906,-1,474,1913,475,-1,474,2509,1913,-1,1918,622,2641,-1,1917,622,1918,-1,1763,717,1762,-1,1873,717,1763,-1,2642,2258,2503,-1,2642,2643,2258,-1,519,515,1890,-1,516,515,519,-1,515,2644,1888,-1,515,517,2644,-1,1889,520,1895,-1,1889,1882,520,-1,512,1895,513,-1,1892,1895,512,-1,1896,2236,2521,-1,2236,1896,2644,-1,1884,1897,1885,-1,1897,1884,1898,-1,1880,696,594,-1,696,1880,1791,-1,693,527,699,-1,693,528,527,-1,177,2239,545,-1,2516,2239,177,-1,1878,570,597,-1,1878,542,570,-1,546,548,2519,-1,548,546,2518,-1,541,568,565,-1,541,543,568,-1,2243,2266,1857,-1,2266,2243,2244,-1,667,149,586,-1,667,148,149,-1,2645,1866,2628,-1,1969,1866,2645,-1,1861,1880,594,-1,1861,1784,1880,-1,558,1856,1877,-1,558,1433,1856,-1,570,534,571,-1,1875,534,570,-1,2646,1857,2266,-1,1858,1857,2646,-1,708,698,709,-1,708,522,698,-1,1934,223,193,-1,223,1934,2001,-1,2217,2000,2528,-1,309,2000,2217,-1,2183,1985,1984,-1,2183,2185,1985,-1,346,2187,1990,-1,346,301,2187,-1,1757,2597,2595,-1,1757,2632,2597,-1,2168,2049,2048,-1,2168,275,2049,-1,2647,859,219,-1,859,2647,2648,-1,2050,215,213,-1,2649,215,2050,-1,212,207,2053,-1,207,212,1842,-1,2574,2053,204,-1,2574,2054,2053,-1,478,2158,1902,-1,478,477,2158,-1,1916,1837,191,-1,196,1837,1916,-1,1903,2650,2651,-1,629,2650,1903,-1,2650,629,1915,-1,635,1833,1832,-1,635,2652,1833,-1,475,226,473,-1,226,475,224,-1,1910,1822,632,-1,1910,1823,1822,-1,642,630,643,-1,2232,630,642,-1,2232,498,630,-1,2653,645,2654,-1,645,2653,2226,-1,497,2655,495,-1,2656,2655,497,-1,1824,2657,1825,-1,1824,1813,2657,-1,2658,2252,1819,-1,2252,2658,2654,-1,2252,136,1820,-1,2252,137,136,-1,2656,2659,2655,-1,2656,2660,2659,-1,1912,492,490,-1,493,492,1912,-1,175,611,2074,-1,175,2661,611,-1,469,2061,2060,-1,2061,469,2577,-1,1811,665,662,-1,1811,663,665,-1,2255,2662,1806,-1,659,2662,2255,-1,2257,2580,145,-1,2257,666,2580,-1,582,1806,2662,-1,582,2245,1806,-1,1801,671,668,-1,671,1801,1804,-1,609,1800,1804,-1,1800,609,608,-1,1799,583,585,-1,583,1799,2088,-1,2153,152,135,-1,152,2153,146,-1,1796,608,1797,-1,1800,608,1796,-1,76,2261,748,-1,76,75,2261,-1,1785,2663,1786,-1,1785,1775,2663,-1,701,1780,706,-1,700,1780,701,-1,1776,710,2664,-1,1776,2263,710,-1,2664,713,1768,-1,2664,2665,713,-1,10,24,2666,-1,10,9,24,-1,1792,2667,1785,-1,2668,2667,1792,-1,1773,2666,1774,-1,1773,10,2666,-1,1771,2264,716,-1,1771,1773,2264,-1,1769,2092,2265,-1,2090,2092,1769,-1,551,536,553,-1,532,536,551,-1,564,541,565,-1,541,564,560,-1,2090,508,507,-1,2090,1769,508,-1,432,2214,435,-1,1955,2214,432,-1,1971,2669,1970,-1,2669,1971,2670,-1,426,2617,2615,-1,426,2618,2617,-1,726,591,333,-1,592,591,726,-1,2671,332,1749,-1,333,332,2671,-1,2672,1749,2673,-1,2672,2671,1749,-1,2498,1993,734,-1,2673,1993,2498,-1,2674,2266,722,-1,2674,1748,2266,-1,416,2531,412,-1,416,2675,2531,-1,2497,2676,735,-1,2497,2677,2676,-1,2678,2676,2679,-1,2678,2680,2676,-1,1748,2646,2266,-1,2646,1748,1747,-1,2681,2682,2683,-1,2684,2682,2681,-1,2191,1992,746,-1,1992,2191,2205,-1,2681,2685,2686,-1,2687,2685,2681,-1,1742,741,740,-1,1742,2688,741,-1,1741,1742,1739,-1,1741,2689,1742,-1,2690,2687,2691,-1,2685,2687,2690,-1,359,2692,360,-1,350,2692,359,-1,2693,2691,2694,-1,2693,2690,2691,-1,2695,2689,1741,-1,2695,2696,2689,-1,2273,1786,2697,-1,2273,749,1786,-1,2696,2698,2699,-1,2696,2695,2698,-1,2700,2694,2701,-1,2693,2694,2700,-1,2702,350,2276,-1,2692,350,2702,-1,1508,1454,1737,-1,1508,1242,1454,-1,1223,1299,1734,-1,1223,1300,1299,-1,1458,774,2277,-1,774,1458,775,-1,776,1305,1732,-1,1305,776,1222,-1,760,1726,2493,-1,760,801,1726,-1,759,794,757,-1,759,792,794,-1,1728,807,789,-1,807,1728,1575,-1,2279,800,2280,-1,2279,801,800,-1,1726,785,1724,-1,2279,785,1726,-1,1473,803,1722,-1,1473,2281,803,-1,2283,1499,2282,-1,839,1499,2283,-1,2284,882,840,-1,2284,1699,882,-1,1260,1572,1261,-1,1572,1260,2282,-1,849,1720,847,-1,2489,1720,849,-1,2287,1718,1717,-1,902,1718,2287,-1,1717,1716,1715,-1,2288,1716,1717,-1,856,2703,1714,-1,2290,2703,856,-1,2486,926,860,-1,2486,1669,926,-1,1710,1489,1107,-1,1489,1710,1490,-1,1709,865,1254,-1,865,1709,866,-1,1091,2430,1245,-1,1091,1090,2430,-1,2291,2393,1490,-1,2414,2393,2291,-1,864,938,862,-1,1705,938,864,-1,942,1584,1583,-1,942,1706,1584,-1,1082,813,1080,-1,1082,811,813,-1,872,1701,873,-1,872,1702,1701,-1,2295,875,1699,-1,876,875,2295,-1,2299,1718,2302,-1,2299,1719,1718,-1,2478,2704,2301,-1,2704,2478,2705,-1,2288,905,1716,-1,906,905,2288,-1,1687,2706,1688,-1,2707,2706,1687,-1,2708,2709,2710,-1,2708,2306,2709,-1,855,913,2487,-1,855,910,913,-1,2703,2711,2712,-1,2474,2711,2703,-1,2713,2472,1674,-1,2713,2473,2472,-1,919,922,1665,-1,919,921,922,-1,1668,929,924,-1,2470,929,1668,-1,2484,878,877,-1,878,2484,2469,-1,1696,2315,2714,-1,1696,2297,2315,-1,1659,1707,947,-1,1659,2318,1707,-1,1417,2715,1092,-1,1417,2716,2715,-1,2324,1378,2357,-1,1651,1378,2324,-1,1063,1652,962,-1,1063,1650,1652,-1,1406,2326,1596,-1,1406,1405,2326,-1,1646,2463,969,-1,976,2463,1646,-1,978,983,2329,-1,978,980,983,-1,1636,1640,1639,-1,1640,1636,2717,-1,1638,1393,1398,-1,1638,1640,1393,-1,1009,2337,2456,-1,1009,2336,2337,-1,2457,1010,1009,-1,1010,2457,1374,-1,2332,1097,1001,-1,2332,2334,1097,-1,1226,2459,2464,-1,1226,2718,2459,-1,2719,2718,1226,-1,2718,2719,2720,-1,1625,1620,1619,-1,2379,1620,1625,-1,1022,2338,1026,-1,2338,1022,1024,-1,2343,1405,2721,-1,2326,1405,2343,-1,1617,2345,2721,-1,1617,1618,2345,-1,2343,2344,1615,-1,1039,2344,2343,-1,2722,2346,2723,-1,2346,2722,2724,-1,1597,1603,1598,-1,1609,1603,1597,-1,1607,1611,2452,-1,1609,1611,1607,-1,1040,1616,2725,-1,1616,1040,1042,-1,1609,1600,1603,-1,1600,1609,1608,-1,1604,2726,2448,-1,1606,2726,1604,-1,1594,1409,1408,-1,1409,1594,1412,-1,2448,2727,2728,-1,2448,2726,2727,-1,2729,1379,2350,-1,2729,2730,1379,-1,1654,1587,1075,-1,1654,2323,1587,-1,1069,1658,1655,-1,1070,1658,1069,-1,2465,1066,1065,-1,953,1066,2465,-1,2358,2406,2715,-1,1378,2406,2358,-1,2317,1053,1593,-1,2359,1053,2317,-1,1581,2445,1060,-1,1581,946,2445,-1,1659,2356,2318,-1,1659,2446,2356,-1,1661,2355,1051,-1,1661,1660,2355,-1,2444,1061,2731,-1,2444,1062,1061,-1,2352,1580,936,-1,2352,2351,1580,-1,1082,2727,2726,-1,1082,1081,2727,-1,1040,2314,1041,-1,1040,2315,2314,-1,2468,2732,878,-1,2732,2468,2733,-1,2468,1035,1034,-1,2468,2469,1035,-1,881,1614,1038,-1,881,2734,1614,-1,2467,2722,1578,-1,2722,2467,2724,-1,2735,1577,2313,-1,2735,1697,1577,-1,2339,894,889,-1,2339,1030,894,-1,2723,1578,2722,-1,2723,2312,1578,-1,876,2451,2450,-1,876,2360,2451,-1,2736,2737,2738,-1,2736,2739,2737,-1,2481,1621,2740,-1,893,1621,2481,-1,2741,1258,890,-1,2380,1258,2741,-1,2742,2303,2743,-1,2742,898,2303,-1,2739,1374,2737,-1,2739,2302,1374,-1,2705,1018,1014,-1,2705,2478,1018,-1,2479,1019,2744,-1,1689,1019,2479,-1,2745,1007,1006,-1,2745,1681,1007,-1,1683,1248,1684,-1,1248,1683,1225,-1,904,1628,1627,-1,904,906,1628,-1,1677,1097,2334,-1,1677,907,1097,-1,1673,1635,1574,-1,1673,994,1635,-1,2746,914,2747,-1,2746,997,914,-1,1677,2333,911,-1,1677,2334,2333,-1,975,1666,1418,-1,975,1671,1666,-1,2748,2461,2749,-1,2461,2748,2307,-1,2470,1647,929,-1,2361,1647,2470,-1,973,928,1648,-1,973,927,928,-1,1096,2385,2384,-1,2385,1096,2443,-1,2442,2750,2443,-1,2442,2751,2750,-1,2311,1250,1501,-1,2311,1251,1250,-1,1493,1122,1114,-1,1123,1122,1493,-1,2752,2753,2424,-1,2753,2752,2754,-1,1565,2395,1485,-1,2755,2395,1565,-1,2756,1568,1284,-1,2756,2757,1568,-1,1117,2362,1287,-1,1117,1118,2362,-1,2435,1479,1475,-1,1573,1479,2435,-1,1124,2758,2759,-1,2760,2758,1124,-1,2439,2426,2434,-1,2426,2439,1557,-1,1500,846,845,-1,1695,846,1500,-1,1132,1262,1130,-1,1497,1262,1132,-1,2757,1566,1568,-1,2761,1566,2757,-1,2364,2759,1255,-1,2364,1124,2759,-1,1150,1543,1550,-1,1543,1150,1157,-1,1548,1099,1135,-1,1548,1147,1099,-1,1449,1450,1232,-1,1448,1450,1449,-1,1235,2762,1541,-1,1235,2763,2762,-1,2764,1362,1540,-1,2764,1517,1362,-1,1195,1512,1196,-1,1195,1537,1512,-1,1535,1541,2765,-1,2375,1541,1535,-1,1531,1431,1365,-1,1531,1202,1431,-1,1480,2424,1286,-1,2752,2424,1480,-1,2740,1023,2766,-1,2740,1621,1023,-1,1512,1432,1196,-1,1512,1433,1432,-1,1531,1190,2376,-1,1190,1531,1191,-1,1403,2767,1369,-1,2767,1403,1514,-1,1339,1347,1346,-1,1339,1447,1347,-1,862,937,1078,-1,938,937,862,-1,941,1055,1592,-1,1055,941,940,-1,989,2473,2768,-1,989,2474,2473,-1,2471,2328,2327,-1,2471,1668,2328,-1,2769,2417,2770,-1,2769,2771,2417,-1,853,2487,858,-1,853,855,2487,-1,859,2772,1712,-1,2648,2772,859,-1,1686,851,1715,-1,851,1686,2708,-1,847,1113,848,-1,2287,1113,847,-1,848,2285,849,-1,848,1572,2285,-1,2490,1699,2284,-1,1699,2490,2295,-1,2283,1262,1129,-1,2283,1130,1262,-1,2390,1124,1123,-1,2390,2760,1124,-1,2391,1496,2773,-1,1496,2391,2368,-1,2392,1122,1554,-1,1122,2392,1114,-1,1263,1498,2438,-1,1265,1498,1263,-1,1110,1107,1487,-1,1710,1107,1110,-1,1485,1119,1264,-1,1485,2395,1119,-1,1263,1273,1275,-1,1263,2434,1273,-1,2439,2434,1263,-1,1278,2774,2775,-1,1115,2774,1278,-1,2776,1104,1559,-1,1104,2776,2777,-1,2752,1479,1486,-1,2752,1480,1479,-1,1478,2778,1282,-1,2775,2778,1478,-1,2779,2757,2756,-1,2757,2779,2761,-1,2780,2777,2776,-1,2780,2781,2777,-1,2367,1118,2366,-1,1118,2367,1561,-1,1470,771,1465,-1,772,771,1470,-1,2782,1310,829,-1,2782,1463,1310,-1,1460,782,1314,-1,1133,782,1460,-1,1736,1318,2397,-1,777,1318,1736,-1,1324,1552,2423,-1,2398,1552,1324,-1,2398,2783,1552,-1,2784,1316,2371,-1,2784,1455,1316,-1,1455,825,824,-1,1455,2784,825,-1,1451,51,1452,-1,1451,72,51,-1,1444,1349,2401,-1,1444,2402,1349,-1,1,2411,2125,-1,2135,2411,1,-1,1442,2401,1345,-1,2401,1442,1444,-1,1440,1511,1441,-1,2402,1511,1440,-1,1351,2405,2785,-1,1360,2405,1351,-1,1350,1439,1437,-1,1439,1350,1440,-1,31,1434,2419,-1,31,30,1434,-1,2418,2141,2119,-1,2141,2418,1356,-1,2428,1184,1213,-1,1184,2428,1181,-1,1339,1344,1333,-1,2400,1344,1339,-1,2786,931,2787,-1,931,2786,932,-1,1240,1228,959,-1,1240,1420,1228,-1,2325,1371,2788,-1,1371,2325,1372,-1,1370,2788,1371,-1,2788,1370,1415,-1,1411,2412,1410,-1,2412,1411,1414,-1,1596,1609,1597,-1,1596,1611,1609,-1,2407,2789,2790,-1,2789,2407,1410,-1,2344,2725,1616,-1,2344,2453,2725,-1,2791,2792,2793,-1,2791,2790,2792,-1,1386,2413,2767,-1,2794,2413,1386,-1,2793,2795,2796,-1,2795,2793,2792,-1,1011,1017,1625,-1,1017,1011,1012,-1,2797,2798,2799,-1,2797,2796,2798,-1,2125,1401,1402,-1,2125,1399,1401,-1,2800,2799,2798,-1,2800,2801,2799,-1,1638,2802,2803,-1,1638,2804,2802,-1,2805,2806,2807,-1,2805,2808,2806,-1,2409,2809,2810,-1,2409,2811,2809,-1,2812,2698,2813,-1,2698,2812,2814,-1,2815,2701,2816,-1,2701,2815,2817,-1,970,1644,2276,-1,970,1643,1644,-1,1280,2818,1397,-1,1280,1271,2818,-1,974,2274,2600,-1,2274,974,2819,-1,2802,2816,2820,-1,2816,2802,2815,-1,2806,2813,2821,-1,2813,2806,2812,-1,2811,1396,1395,-1,1396,2811,2822,-1,2586,1396,2822,-1,2586,1453,1396,-1,2810,2814,1391,-1,2810,2809,2814,-1,2800,2807,2817,-1,2800,2805,2807,-1,2803,1639,1638,-1,1639,2803,1644,-1,2798,2805,2800,-1,2805,2798,2823,-1,1388,1391,1389,-1,1388,2810,1391,-1,2824,1389,2825,-1,2824,1387,1389,-1,2799,967,2797,-1,967,2799,2826,-1,967,1625,1626,-1,967,1011,1625,-1,2792,2824,2795,-1,2824,2792,2827,-1,1384,2767,1514,-1,1384,1386,2767,-1,1385,2794,1386,-1,2408,2794,1385,-1,1406,2793,2828,-1,1406,2791,2793,-1,1410,2794,2789,-1,2794,1410,2413,-1,1652,1415,2829,-1,1652,2788,1415,-1,2324,2788,1652,-1,2788,2324,2325,-1,959,1372,2325,-1,1372,959,1227,-1,2830,2350,2831,-1,2830,2729,2350,-1,2704,1014,1013,-1,2705,1014,2704,-1,1044,2353,1052,-1,2353,1044,1043,-1,2428,819,818,-1,2428,1213,819,-1,758,1361,1360,-1,1361,758,762,-1,1357,2418,1358,-1,1357,1356,2418,-1,1356,4,2141,-1,4,1356,1355,-1,2419,1451,2131,-1,1451,2419,1434,-1,2421,1360,1351,-1,758,1360,2421,-1,1511,2420,1441,-1,1511,1510,2420,-1,1345,36,2422,-1,1345,2401,36,-1,26,1453,2586,-1,1453,26,2131,-1,1238,820,1236,-1,1238,1329,820,-1,1330,825,2784,-1,825,1330,1238,-1,1477,1325,2277,-1,1477,1219,1325,-1,777,1319,1318,-1,777,1321,1319,-1,1313,1459,2371,-1,1313,1141,1459,-1,1142,1315,1524,-1,1312,1315,1142,-1,1463,2832,1524,-1,2782,2832,1463,-1,1304,1468,1302,-1,1468,1304,1467,-1,1293,2782,1291,-1,2832,2782,1293,-1,1118,2436,2362,-1,2436,1118,1561,-1,2777,1563,1104,-1,2781,1563,2777,-1,1286,1474,1476,-1,1286,1560,1474,-1,2753,2779,2756,-1,2779,2753,2754,-1,1282,1481,1283,-1,2778,1481,1282,-1,2784,1326,1330,-1,2784,2371,1326,-1,2833,1274,1566,-1,2833,1275,1274,-1,1290,1253,1103,-1,1709,1253,1290,-1,2778,2774,1266,-1,2774,2778,2775,-1,2294,868,870,-1,2294,1492,868,-1,2425,1494,1493,-1,2425,1557,1494,-1,2392,2368,2391,-1,2368,2392,1554,-1,2490,839,1128,-1,839,2490,2284,-1,2285,891,849,-1,2285,892,891,-1,1496,1256,2834,-1,1496,1257,1256,-1,1112,848,1113,-1,1112,1261,848,-1,2487,1672,916,-1,2487,913,1672,-1,1712,2440,857,-1,1712,2834,2440,-1,2834,1712,2772,-1,1569,853,857,-1,1569,2488,853,-1,1505,2386,1504,-1,1505,2384,2386,-1,2751,2387,1504,-1,2751,2442,2387,-1,2337,2835,2836,-1,2337,2304,2835,-1,982,923,2462,-1,982,1667,923,-1,2768,2713,2416,-1,2713,2768,2473,-1,1167,1352,1373,-1,769,1352,1167,-1,1352,769,755,-1,2433,2837,2762,-1,2378,2837,2433,-1,1178,1171,1231,-1,1171,1178,2374,-1,2765,2762,2837,-1,2762,2765,1541,-1,1203,1435,1204,-1,1203,1430,1435,-1,2369,1366,1205,-1,2369,1529,1366,-1,2837,1194,2765,-1,2837,1195,1194,-1,1209,1540,2432,-1,1209,2764,1540,-1,2763,2433,2762,-1,2763,2431,2433,-1,2382,1176,1426,-1,1176,2382,1177,-1,1338,1232,1229,-1,1449,1232,1338,-1,1137,1156,1549,-1,1145,1156,1137,-1,1151,1147,1548,-1,2838,1147,1151,-1,1148,1550,1154,-1,1550,1148,1150,-1,2373,1160,1148,-1,2373,2372,1160,-1,1543,1152,1162,-1,1544,1152,1543,-1,2389,1112,1571,-1,2363,1112,2389,-1,2282,1500,845,-1,1499,1500,2282,-1,1116,1493,1114,-1,1493,1116,2425,-1,1120,1479,1573,-1,1479,1120,1119,-1,2441,1255,2759,-1,1255,2441,1256,-1,1268,1107,1489,-1,1268,1108,1107,-1,1128,2283,1129,-1,1128,839,2283,-1,2434,1482,1273,-1,1482,2434,1483,-1,2760,2388,2758,-1,2839,2388,2760,-1,2435,1559,1252,-1,2435,1562,1559,-1,1561,2437,2436,-1,1561,1560,2437,-1,2755,1486,2395,-1,2840,1486,2755,-1,2406,1092,2715,-1,956,1092,2406,-1,1505,1096,2384,-1,1093,1096,1505,-1,1502,1249,1095,-1,1249,1502,1250,-1,929,1648,928,-1,1647,1648,929,-1,2748,1641,2841,-1,2749,1641,2748,-1,977,1671,975,-1,977,2310,1671,-1,1002,2305,1003,-1,2305,1002,909,-1,2769,2331,2771,-1,1674,2331,2769,-1,2746,1574,1635,-1,1574,2746,2747,-1,907,1002,1097,-1,1002,907,909,-1,906,2337,1628,-1,906,2304,2337,-1,1225,2706,2842,-1,1225,1683,2706,-1,1008,1681,2709,-1,1007,1681,1008,-1,1689,1020,1019,-1,1691,1020,1689,-1,2478,1623,1018,-1,2478,2477,1623,-1,2302,1375,1374,-1,2302,2301,1375,-1,2843,2456,2844,-1,2843,2300,2456,-1,1623,901,1624,-1,1623,2477,901,-1,1622,893,2480,-1,1621,893,1622,-1,1259,2380,1521,-1,1259,1258,2380,-1,932,2451,2360,-1,2451,932,2786,-1,2724,883,2845,-1,2724,2467,883,-1,2454,888,886,-1,2340,888,2454,-1,2733,2298,2732,-1,2733,2846,2298,-1,2312,1612,2313,-1,2312,2723,1612,-1,2845,879,1037,-1,879,2845,883,-1,2733,1034,2847,-1,2733,2468,1034,-1,2449,876,2450,-1,2449,874,876,-1,1663,2848,1702,-1,2848,1663,2348,-1,1699,2297,882,-1,1699,1700,2297,-1,811,2726,1606,-1,2726,811,1082,-1,936,1592,2352,-1,936,941,1592,-1,1057,2317,1593,-1,943,2317,1057,-1,2319,2729,948,-1,2730,2729,2319,-1,949,2446,1659,-1,949,2830,2446,-1,945,2445,946,-1,945,1058,2445,-1,1076,2293,2294,-1,2293,1076,2354,-1,1074,2849,2322,-1,1074,1073,2849,-1,1070,953,1658,-1,1066,953,1070,-1,952,1590,1416,-1,952,951,1590,-1,955,1378,1377,-1,955,2406,1378,-1,1072,2358,1071,-1,1072,2357,2358,-1,2730,963,1379,-1,963,2730,2415,-1,1413,1049,2831,-1,1413,1412,1049,-1,2352,1047,1046,-1,1047,2352,1592,-1,2831,2446,2830,-1,2831,1049,2446,-1,1045,1594,1408,-1,1045,1044,1594,-1,2848,1608,2787,-1,2848,2348,1608,-1,2451,1607,2452,-1,2451,2786,1607,-1,2342,2724,2845,-1,2724,2342,2346,-1,1618,1035,2345,-1,1036,1035,1618,-1,1024,2339,2338,-1,1024,1030,2339,-1,1626,2341,1404,-1,2341,1626,1649,-1,1020,1522,1620,-1,1522,1020,1523,-1,2742,2379,1016,-1,2742,2455,2379,-1,1619,2766,1649,-1,1619,1522,2766,-1,1224,2464,1392,-1,2464,1224,1226,-1,1375,1012,1010,-1,1012,1375,1013,-1,1576,1394,1393,-1,1576,1004,1394,-1,997,1635,996,-1,997,2746,1635,-1,2460,2410,1637,-1,990,2410,2460,-1,1641,2461,2329,-1,2749,2461,1641,-1,1646,2328,977,-1,1645,2328,1646,-1,2819,971,970,-1,2819,974,971,-1,968,1009,966,-1,1009,968,2459,-1,2292,2716,1417,-1,2849,2716,2292,-1,875,2850,1700,-1,875,874,2850,-1,2851,881,880,-1,2851,2734,881,-1,877,2735,2485,-1,2735,877,1697,-1,1676,920,919,-1,2307,920,1676,-1,2712,2308,1675,-1,2712,2711,2308,-1,1680,2305,1678,-1,1680,1679,2305,-1,2302,2736,2299,-1,2736,2302,2739,-1,897,1720,1690,-1,897,896,1720,-1,2300,2835,2304,-1,2835,2300,2843,-1,903,900,899,-1,2476,900,903,-1,1577,2483,884,-1,1698,2483,1577,-1,2360,2466,932,-1,2360,2296,2466,-1,1245,1417,1091,-1,2292,1417,1245,-1,1713,1664,1711,-1,1665,1664,1713,-1,1714,2712,2289,-1,1714,2703,2712,-1,852,1680,2488,-1,2710,1680,852,-1,838,842,841,-1,1698,842,838,-1,838,1499,839,-1,838,841,1499,-1,826,1182,2427,-1,1182,826,1237,-1,814,817,819,-1,816,817,814,-1,790,830,809,-1,830,790,806,-1,792,796,793,-1,796,792,799,-1,2279,1730,785,-1,2280,1730,2279,-1,789,806,790,-1,806,789,807,-1,2494,1726,1725,-1,2493,1726,2494,-1,1462,781,788,-1,1461,781,1462,-1,771,1300,1223,-1,1300,771,770,-1,764,2494,765,-1,764,1553,2494,-1,350,2192,2275,-1,350,349,2192,-1,2820,2692,2702,-1,2852,2692,2820,-1,2821,2693,2700,-1,2853,2693,2821,-1,2854,2699,1395,-1,2854,2696,2699,-1,48,748,747,-1,76,748,48,-1,2696,2855,2689,-1,2696,2854,2855,-1,2853,2690,2693,-1,2853,2856,2690,-1,2852,360,2692,-1,2852,2857,360,-1,2858,2691,2687,-1,2858,2859,2691,-1,2860,2663,742,-1,2860,2861,2663,-1,2687,2683,2858,-1,2687,2681,2683,-1,389,1974,386,-1,388,1974,389,-1,2686,2684,2681,-1,2679,2684,2686,-1,1747,1744,2646,-1,1744,1747,2862,-1,2679,2677,2684,-1,2679,2676,2677,-1,2677,340,2496,-1,2497,340,2677,-1,735,424,2497,-1,734,424,735,-1,1952,2611,2613,-1,1954,2611,1952,-1,2674,2673,2498,-1,2672,2673,2674,-1,2673,337,1993,-1,2673,1749,337,-1,1948,2611,429,-1,2611,1948,2612,-1,1781,2501,1783,-1,2501,1781,705,-1,506,180,2504,-1,506,503,180,-1,10,1771,2863,-1,1773,1771,10,-1,2864,1774,2668,-1,2864,1772,1774,-1,2261,2668,1792,-1,2864,2668,2261,-1,713,2865,2863,-1,2665,2865,713,-1,2664,1854,2665,-1,2664,710,1854,-1,2133,1787,702,-1,2133,2262,1787,-1,1787,706,705,-1,1787,701,706,-1,2157,606,605,-1,2157,689,606,-1,599,687,685,-1,606,687,599,-1,139,1820,136,-1,139,680,1820,-1,2505,2088,1799,-1,2505,676,2088,-1,1798,673,2258,-1,1798,1900,673,-1,1803,1900,2235,-1,1803,673,1900,-1,2245,1805,1806,-1,1899,1805,2245,-1,2060,670,669,-1,670,2060,2062,-1,586,145,2086,-1,586,2257,145,-1,665,483,485,-1,665,2256,483,-1,1807,659,2255,-1,660,659,1807,-1,2060,470,469,-1,470,2060,2866,-1,2253,657,1922,-1,2253,658,657,-1,484,2152,644,-1,2152,484,483,-1,137,2654,645,-1,137,2252,2654,-1,644,2250,484,-1,644,2251,2250,-1,2507,2867,2868,-1,2507,2869,2867,-1,2655,491,495,-1,491,2655,2659,-1,2228,645,2226,-1,2233,645,2228,-1,645,2233,2251,-1,2870,2869,486,-1,2869,2870,2867,-1,1831,633,1832,-1,2653,633,1831,-1,2871,2652,2872,-1,1833,2652,2871,-1,2651,628,2873,-1,2651,500,628,-1,2651,2650,500,-1,256,2874,257,-1,256,305,2874,-1,2647,2872,2648,-1,2871,2872,2647,-1,2523,1917,1919,-1,2523,2875,1917,-1,2876,2875,2523,-1,2051,213,212,-1,2051,2050,213,-1,859,2169,219,-1,859,2047,2169,-1,283,2572,221,-1,283,2592,2572,-1,2877,1844,1501,-1,2877,2878,1844,-1,2387,2222,2879,-1,2387,2442,2222,-1,2880,2541,2881,-1,2880,269,2541,-1,293,729,1988,-1,293,2012,729,-1,2596,1984,1755,-1,2183,1984,2596,-1,2263,467,2267,-1,2263,126,467,-1,2263,127,126,-1,2518,2239,2882,-1,2239,2518,546,-1,556,55,54,-1,567,55,556,-1,593,694,1760,-1,593,592,694,-1,1900,585,584,-1,585,1900,1798,-1,1820,690,1794,-1,680,690,1820,-1,2074,2059,171,-1,1850,2059,2074,-1,577,689,1216,-1,689,577,688,-1,2882,549,2518,-1,533,549,2882,-1,75,714,1874,-1,75,62,714,-1,2241,550,552,-1,2241,575,550,-1,1856,548,1877,-1,1856,2519,548,-1,540,1878,539,-1,540,1767,1878,-1,2882,598,533,-1,2882,1868,598,-1,525,699,524,-1,699,525,693,-1,529,691,527,-1,2237,691,529,-1,718,2521,1901,-1,718,1896,2521,-1,2520,1892,512,-1,519,1892,2520,-1,2875,480,623,-1,2875,1908,480,-1,1914,653,1818,-1,653,1914,651,-1,2509,1903,1902,-1,1903,2509,474,-1,2036,2163,201,-1,2163,2036,2164,-1,2250,641,484,-1,2250,642,641,-1,2651,1838,1903,-1,2651,1839,1838,-1,490,1812,1912,-1,490,489,1812,-1,2254,1907,2640,-1,1809,1907,2254,-1,487,2639,488,-1,2638,2639,487,-1,2868,1825,2657,-1,2867,1825,2868,-1,491,2660,489,-1,491,2659,2660,-1,2223,399,2224,-1,2223,1864,399,-1,619,2170,1501,-1,619,185,2170,-1,2222,2600,620,-1,2222,2442,2600,-1,2878,1929,1844,-1,2883,1929,2878,-1,2010,184,2547,-1,2010,297,184,-1,2546,2186,2635,-1,2186,2546,1991,-1,2198,2633,2601,-1,289,2633,2198,-1,2559,2196,730,-1,2559,294,2196,-1,2542,278,277,-1,2542,2544,278,-1,2017,2602,2631,-1,2017,1981,2602,-1,366,2560,287,-1,366,365,2560,-1,1979,278,2544,-1,1979,2020,278,-1,384,2022,381,-1,384,268,2022,-1,617,2564,281,-1,616,2564,617,-1,377,2884,1977,-1,377,2563,2884,-1,2628,2177,2645,-1,2177,2628,2567,-1,2208,2670,1971,-1,2208,2178,2670,-1,2269,2885,2886,-1,2269,263,2885,-1,264,2603,2887,-1,264,266,2603,-1,626,2223,2032,-1,2223,626,1864,-1,397,2033,2225,-1,2033,397,2030,-1,2886,2888,2889,-1,2886,2885,2888,-1,1960,2044,1958,-1,1960,2525,2044,-1,460,2624,2890,-1,460,302,2624,-1,2029,2538,2175,-1,2029,1963,2538,-1,255,2891,303,-1,255,254,2891,-1,2890,2189,460,-1,2606,2189,2890,-1,405,2040,2209,-1,405,304,2040,-1,408,2008,2621,-1,408,2009,2008,-1,2625,2008,2007,-1,2622,2008,2625,-1,2512,2212,2211,-1,2512,2558,2212,-1,2614,1933,2620,-1,2614,1932,1933,-1,455,427,456,-1,455,428,427,-1,1753,2221,2619,-1,1753,440,2221,-1,437,315,1949,-1,437,316,315,-1,436,319,2556,-1,436,1945,319,-1,1944,1997,2218,-1,1944,2892,1997,-1,2216,313,430,-1,313,2216,452,-1,2500,446,2636,-1,446,2500,334,-1,443,1995,1939,-1,1995,443,1996,-1,320,2527,321,-1,2527,320,442,-1,447,2551,448,-1,447,2220,2551,-1,1938,2616,331,-1,1938,1937,2616,-1,2215,1942,1951,-1,2215,1943,1942,-1,1951,2499,2215,-1,1951,2529,2499,-1,2613,420,1952,-1,2613,1957,420,-1,1961,2533,403,-1,1959,2533,1961,-1,341,1961,403,-1,1961,341,411,-1,2893,737,2495,-1,2893,402,737,-1,2894,2537,410,-1,2894,2895,2537,-1,398,2548,738,-1,2224,2548,398,-1,2621,393,408,-1,2621,418,393,-1,418,2621,2623,-1,400,2628,1866,-1,400,2605,2628,-1,400,386,385,-1,386,400,1867,-1,2896,2897,2517,-1,2898,2897,2896,-1,2205,2517,1992,-1,2205,2896,2517,-1,1979,2543,370,-1,1979,2544,2543,-1,1976,2206,1975,-1,2269,2206,1976,-1,2541,1975,2207,-1,2541,2203,1975,-1,745,360,746,-1,745,361,360,-1,361,363,359,-1,2899,363,361,-1,2545,1987,2198,-1,1987,2545,2197,-1,354,2196,345,-1,354,730,2196,-1,2194,184,2195,-1,2194,2547,184,-1,2272,1754,422,-1,2272,733,1754,-1,444,336,335,-1,336,444,2549,-1,330,591,187,-1,330,449,591,-1,230,327,231,-1,2550,327,230,-1,2555,1827,1829,-1,1827,2555,2619,-1,235,319,318,-1,235,2556,319,-1,2558,257,2874,-1,2558,2511,257,-1,300,2010,2635,-1,2010,300,298,-1,2013,282,284,-1,2013,292,282,-1,2184,2596,2561,-1,2184,2183,2596,-1,2900,2593,2592,-1,2593,2900,2185,-1,2019,275,2168,-1,2019,276,275,-1,2629,2649,2591,-1,2629,280,2649,-1,2594,2565,2179,-1,2565,2594,2901,-1,2021,267,214,-1,267,2021,268,-1,2669,2178,262,-1,2670,2178,2669,-1,209,260,263,-1,209,211,260,-1,250,2162,251,-1,2162,250,2044,-1,195,307,196,-1,195,248,307,-1,2069,1933,244,-1,2069,2068,1933,-1,453,243,311,-1,453,239,243,-1,2001,240,223,-1,240,2001,241,-1,1827,2515,2249,-1,2515,1827,1752,-1,2514,731,229,-1,2514,615,731,-1,2046,228,225,-1,1821,228,2046,-1,1828,224,475,-1,2249,224,1828,-1,299,2169,2047,-1,299,2011,2169,-1,2593,216,218,-1,216,2593,2571,-1,214,210,213,-1,210,214,267,-1,209,1842,210,-1,1842,209,1843,-1,206,204,207,-1,204,206,2165,-1,199,2575,197,-1,199,251,2575,-1,2247,2159,2576,-1,2159,2247,2057,-1,2156,174,176,-1,2156,2577,174,-1,157,153,170,-1,153,157,154,-1,2154,154,2578,-1,2154,155,154,-1,2155,2578,160,-1,2578,2155,2154,-1,2084,2902,2579,-1,2084,2903,2902,-1,169,2902,2903,-1,2902,169,2150,-1,153,2076,2151,-1,153,155,2076,-1,2506,148,1805,-1,2506,2087,148,-1,2153,147,146,-1,2153,2152,147,-1,2504,2579,2902,-1,2504,683,2579,-1,2147,2581,124,-1,2112,2581,2147,-1,2099,125,116,-1,123,125,2099,-1,2590,2115,2589,-1,52,2115,2590,-1,2096,113,115,-1,2096,112,113,-1,2583,93,2588,-1,2583,94,93,-1,97,2104,2146,-1,2104,97,2105,-1,81,2142,2587,-1,81,2114,2142,-1,84,2114,88,-1,2114,84,92,-1,79,566,56,-1,79,2113,566,-1,50,77,2097,-1,49,77,50,-1,2136,41,0,-1,42,41,2136,-1,2124,2121,2120,-1,2121,2124,2129,-1,7,2130,2585,-1,2904,2130,7,-1,2667,1775,1785,-1,1775,2667,2502,-1,2904,6,2129,-1,7,6,2904,-1,2141,3,2117,-1,2141,4,3,-1,0,8,2135,-1,0,41,8,-1,2124,1438,2404,-1,2124,2123,1438,-1,32,44,27,-1,32,2585,44,-1,2128,2126,2122,-1,2128,5,2126,-1,8,2585,32,-1,7,2585,8,-1,1353,35,40,-1,35,1353,1340,-1,2118,1439,2403,-1,2118,2140,1439,-1,2584,40,39,-1,1353,40,2584,-1,567,1516,55,-1,61,1516,567,-1,107,59,118,-1,60,59,107,-1,122,60,107,-1,60,122,71,-1,86,2143,2110,-1,86,85,2143,-1,80,2143,78,-1,80,99,2143,-1,2583,101,74,-1,2583,2588,101,-1,2100,2107,99,-1,2100,106,2107,-1,110,2095,109,-1,112,2095,110,-1,119,2115,73,-1,2115,119,2589,-1,2148,52,2590,-1,77,52,2148,-1,151,141,138,-1,142,141,151,-1,135,138,136,-1,151,138,135,-1,2153,137,644,-1,2153,135,137,-1,2072,158,168,-1,159,158,2072,-1,2084,169,2903,-1,169,2084,170,-1,2073,2061,173,-1,2073,2062,2061,-1,201,2158,477,-1,201,2576,2158,-1,2573,201,2574,-1,201,2573,202,-1,2024,207,1842,-1,207,2024,208,-1,2182,2048,216,-1,2048,2182,2015,-1,2661,612,611,-1,612,2661,175,-1,235,636,238,-1,636,235,318,-1,239,1830,240,-1,1830,239,453,-1,2069,192,1837,-1,2069,244,192,-1,2161,249,195,-1,2161,2004,249,-1,2625,2042,2056,-1,2042,2625,2007,-1,2041,253,2042,-1,253,2041,254,-1,202,2030,2029,-1,202,2573,2030,-1,1843,262,2178,-1,1843,209,262,-1,2649,279,215,-1,280,279,2649,-1,2021,2901,2180,-1,2021,2565,2901,-1,2905,2563,2562,-1,2563,2905,2884,-1,2563,2591,2166,-1,2591,2563,2629,-1,2906,2562,270,-1,2906,2905,2562,-1,2182,2184,2561,-1,2182,2571,2184,-1,287,2017,2631,-1,287,2016,2017,-1,2634,289,2014,-1,289,2634,2633,-1,2635,301,300,-1,301,2635,2186,-1,2007,2173,2041,-1,2009,2173,2007,-1,2513,252,2511,-1,252,2513,2599,-1,244,2907,2570,-1,244,1932,2907,-1,236,314,237,-1,2892,314,236,-1,2636,328,614,-1,2636,329,328,-1,334,332,445,-1,332,334,336,-1,1749,338,337,-1,1749,2549,338,-1,342,2496,340,-1,342,2495,2496,-1,1989,344,2193,-1,344,1989,345,-1,353,2197,2545,-1,353,355,2197,-1,369,1983,364,-1,369,368,1983,-1,1756,2632,1757,-1,1982,2632,1756,-1,745,2899,361,-1,465,2899,745,-1,2207,2881,2541,-1,2207,2627,2881,-1,383,2205,2204,-1,383,2896,2205,-1,2604,389,1867,-1,389,2604,391,-1,2893,410,409,-1,2624,410,2893,-1,394,401,395,-1,394,1759,401,-1,1967,2539,1966,-1,2539,1967,2540,-1,2539,1968,401,-1,1965,1968,2539,-1,2495,2536,2893,-1,2536,2495,342,-1,409,402,2893,-1,409,395,402,-1,407,2536,404,-1,2536,407,406,-1,2535,2890,2624,-1,2606,2890,2535,-1,417,2530,420,-1,2530,417,414,-1,411,413,1961,-1,413,411,414,-1,403,2212,1745,-1,2213,2212,403,-1,416,414,417,-1,412,414,416,-1,2620,421,1957,-1,421,2620,415,-1,424,2529,1953,-1,2499,2529,424,-1,2614,1957,2613,-1,2614,2620,1957,-1,425,2618,426,-1,425,2908,2618,-1,335,442,444,-1,2527,442,335,-1,2220,2219,450,-1,2220,447,2219,-1,322,1941,2552,-1,322,732,1941,-1,2271,321,2527,-1,321,2271,325,-1,2616,2636,446,-1,2616,329,2636,-1,452,434,451,-1,434,452,2216,-1,1949,314,1956,-1,315,314,1949,-1,451,433,2171,-1,451,434,433,-1,2908,2555,2554,-1,2908,2270,2555,-1,2217,310,309,-1,310,2217,1946,-1,2909,2068,2067,-1,2909,415,2068,-1,2570,2557,454,-1,2907,2557,2570,-1,248,2610,2609,-1,248,2172,2610,-1,2043,2533,1959,-1,2043,2599,2533,-1,2598,2623,2622,-1,2623,2598,418,-1,410,2891,2894,-1,410,303,2891,-1,1746,2874,305,-1,1745,2874,1746,-1,1758,2034,1967,-1,1758,2037,2034,-1,457,418,2598,-1,418,457,419,-1,1746,304,405,-1,1746,305,304,-1,2558,1745,2212,-1,2874,1745,2558,-1,1963,2028,1964,-1,1963,2029,2028,-1,2225,2032,2223,-1,2225,2033,2032,-1,391,2026,392,-1,391,2027,2026,-1,2206,261,2207,-1,2206,260,261,-1,262,1970,2669,-1,1970,262,2268,-1,266,2604,2603,-1,2023,2604,266,-1,382,2180,2898,-1,382,2181,2180,-1,280,379,378,-1,280,2629,379,-1,2901,2630,2897,-1,2901,2594,2630,-1,2905,376,375,-1,2905,2906,376,-1,370,2018,2019,-1,370,2543,2018,-1,285,365,368,-1,285,2560,365,-1,368,2019,285,-1,368,370,2019,-1,1977,2905,375,-1,1977,2884,2905,-1,2188,346,343,-1,2188,301,346,-1,1988,291,293,-1,1988,352,291,-1,2187,1991,1990,-1,2187,2186,1991,-1,1847,1927,1926,-1,1847,1846,1927,-1,2877,2883,2878,-1,2877,2910,2883,-1,1929,2910,2222,-1,1929,2883,2910,-1,481,1834,2227,-1,1834,481,1835,-1,2637,2657,656,-1,2868,2657,2637,-1,1823,486,1822,-1,486,1823,2870,-1,1818,652,655,-1,1818,653,652,-1,471,657,472,-1,471,1912,657,-1,1824,2231,1816,-1,2231,1824,2524,-1,2876,1908,2875,-1,1908,2876,2873,-1,2234,498,2232,-1,499,498,2234,-1,1828,318,1829,-1,1828,636,318,-1,482,623,480,-1,623,482,501,-1,318,2554,1829,-1,2190,2554,318,-1,2523,2051,479,-1,2523,2522,2051,-1,1893,516,518,-1,1893,517,516,-1,1896,1888,2644,-1,1888,1896,1883,-1,1883,1889,1888,-1,1883,1882,1889,-1,1863,1881,719,-1,1863,1862,1881,-1,536,531,571,-1,532,531,536,-1,1869,539,2242,-1,1869,537,539,-1,2519,1513,544,-1,1856,1513,2519,-1,547,575,574,-1,575,547,550,-1,559,1877,574,-1,559,558,1877,-1,560,1763,561,-1,560,564,1763,-1,555,1766,58,-1,555,535,1766,-1,2516,1869,1868,-1,2516,538,1869,-1,595,693,596,-1,528,693,595,-1,2860,1858,1743,-1,2860,742,1858,-1,1848,2064,600,-1,1848,181,2064,-1,708,1790,522,-1,2267,1790,708,-1,488,643,630,-1,643,488,2639,-1,2557,428,455,-1,2557,1948,428,-1,356,2185,2900,-1,2185,356,1985,-1,603,2063,2510,-1,603,1879,2063,-1,259,1865,625,-1,259,2246,1865,-1,291,2014,292,-1,291,2634,2014,-1,2387,2877,1501,-1,2387,2879,2877,-1,2049,2522,217,-1,2049,2167,2522,-1,1918,219,217,-1,2641,219,1918,-1,2641,2647,219,-1,285,2168,2015,-1,285,2019,2168,-1,2053,479,212,-1,2053,477,479,-1,622,2248,2641,-1,622,624,2248,-1,203,2574,204,-1,203,2031,2574,-1,2057,2160,1904,-1,2575,2160,2057,-1,1836,1831,1833,-1,1836,502,1831,-1,627,2508,1834,-1,627,499,2508,-1,2045,1999,1998,-1,2045,1830,1999,-1,2653,2658,633,-1,2654,2658,2653,-1,621,175,1922,-1,175,621,228,-1,641,2639,1914,-1,641,643,2639,-1,2503,685,687,-1,2503,2258,685,-1,647,1819,646,-1,1819,647,2658,-1,2507,2637,652,-1,2868,2637,2507,-1,490,1815,1814,-1,490,492,1815,-1,489,2656,497,-1,489,2660,2656,-1,2229,1912,471,-1,493,1912,2229,-1,2866,659,470,-1,659,2866,2662,-1,2256,147,483,-1,143,147,2256,-1,2662,580,582,-1,580,2662,2866,-1,671,2235,582,-1,2235,671,1803,-1,682,675,2505,-1,682,681,675,-1,675,139,138,-1,675,678,139,-1,682,2643,2642,-1,682,2259,2643,-1,686,1849,684,-1,1849,686,1797,-1,2911,2503,579,-1,2642,2503,2911,-1,719,1783,2501,-1,1783,719,1881,-1,1775,742,2663,-1,1775,703,742,-1,706,1788,707,-1,1780,1788,706,-1,1779,710,709,-1,1779,1854,710,-1,1855,11,2865,-1,11,1855,712,-1,1768,1776,2664,-1,1776,1768,2265,-1,25,2502,24,-1,25,711,2502,-1,2264,715,1762,-1,2264,1772,715,-1,715,2864,1874,-1,1772,2864,715,-1,177,572,573,-1,572,177,603,-1,572,2510,1871,-1,603,2510,572,-1,707,698,692,-1,698,707,1788,-1,2172,2608,2610,-1,2003,2608,2172,-1,593,187,591,-1,593,1761,187,-1,723,333,2671,-1,726,333,723,-1,2671,724,723,-1,2672,724,2671,-1,1748,2498,736,-1,2674,2498,1748,-1,414,340,2530,-1,414,411,340,-1,2680,735,2676,-1,736,735,2680,-1,2682,737,387,-1,2682,2496,737,-1,2680,739,2862,-1,2678,739,2680,-1,743,2243,1857,-1,2243,743,1782,-1,740,2678,2912,-1,739,2678,740,-1,2683,387,1973,-1,2682,387,2683,-1,2191,2913,1973,-1,746,2913,2191,-1,2914,2686,2685,-1,2914,2912,2686,-1,1743,2688,2860,-1,2688,1743,741,-1,2689,2688,1742,-1,2688,2689,2855,-1,2856,2685,2690,-1,2914,2685,2856,-1,2857,746,360,-1,2913,746,2857,-1,1986,350,359,-1,1986,2199,350,-1,2694,2859,2915,-1,2694,2691,2859,-1,1741,2916,2695,-1,2916,1741,1740,-1,1786,2861,2697,-1,1786,2663,2861,-1,2698,2916,2813,-1,2695,2916,2698,-1,2701,2915,2816,-1,2694,2915,2701,-1,639,2818,750,-1,639,638,2818,-1,754,758,2421,-1,759,758,754,-1,761,2493,1553,-1,2493,761,760,-1,763,766,1507,-1,766,763,1731,-1,1307,777,1736,-1,777,1307,778,-1,810,795,791,-1,810,1462,795,-1,1729,757,794,-1,757,1729,802,-1,2281,1723,803,-1,2281,828,1723,-1,813,1703,837,-1,813,812,1703,-1,1237,822,1182,-1,1237,1236,822,-1,1226,2842,2719,-1,1226,1225,2842,-1,1721,2491,2490,-1,1701,2491,1721,-1,840,2483,838,-1,885,2483,840,-1,1569,852,2488,-1,852,1569,850,-1,851,2710,852,-1,851,2708,2710,-1,2488,854,853,-1,1678,854,2488,-1,1670,2486,1711,-1,1670,1669,2486,-1,2444,2393,2414,-1,2444,2731,2393,-1,2491,2296,2295,-1,2466,2296,2491,-1,843,2298,1085,-1,843,2732,2298,-1,2481,2286,893,-1,892,2286,2481,-1,1690,2489,1691,-1,1690,1720,2489,-1,1690,2479,897,-1,1689,2479,1690,-1,1716,1687,1686,-1,905,1687,1716,-1,1683,1688,2706,-1,1682,1688,1683,-1,2304,1719,2300,-1,2304,2288,1719,-1,2290,2474,2703,-1,2290,2472,2474,-1,1674,2770,2713,-1,2770,1674,2769,-1,1083,2846,1579,-1,1083,2298,2846,-1,2465,1656,867,-1,1656,2465,2321,-1,1380,1381,1409,-1,1380,1382,1381,-1,970,2463,1643,-1,970,969,2463,-1,1249,974,2600,-1,1249,972,974,-1,1647,969,971,-1,1647,2361,969,-1,1643,980,979,-1,1643,981,980,-1,978,987,979,-1,978,986,987,-1,985,2460,987,-1,2460,985,990,-1,991,2717,1636,-1,2717,991,1000,-1,999,2717,1000,-1,1576,2717,999,-1,2738,1374,2457,-1,2738,2737,1374,-1,1628,2458,1629,-1,2458,1628,2336,-1,2720,1629,2718,-1,1629,2720,1630,-1,1392,1632,1631,-1,1392,1394,1632,-1,966,1012,1011,-1,966,1010,1012,-1,2455,2743,2744,-1,2455,2742,2743,-1,2721,2346,2343,-1,2721,2723,2346,-1,1023,1029,1024,-1,1023,1622,1029,-1,2326,1615,1610,-1,2343,1615,2326,-1,1039,2845,1037,-1,1039,2342,2845,-1,1598,1407,1597,-1,1598,1408,1407,-1,1607,2787,1608,-1,1607,2786,2787,-1,1076,1059,1077,-1,1059,1076,1060,-1,1046,1045,2917,-1,1046,1043,1045,-1,2728,2918,2917,-1,2728,2727,2918,-1,1052,1595,1044,-1,1595,1052,1077,-1,2831,1380,1413,-1,2831,2350,1380,-1,1075,2322,1654,-1,1075,1074,2322,-1,1064,1657,2321,-1,1064,1591,1657,-1,1065,2321,2465,-1,1064,2321,1065,-1,2716,1073,1071,-1,2849,1073,2716,-1,1660,2356,2355,-1,1660,2318,2356,-1,2294,1060,1076,-1,2294,1581,1060,-1,948,2830,949,-1,948,2729,2830,-1,2415,2731,1061,-1,2415,2320,2731,-1,1662,1057,1056,-1,1662,943,1057,-1,1601,812,1602,-1,1601,933,812,-1,2919,2447,2918,-1,2919,2316,2447,-1,935,2348,1663,-1,935,2349,2348,-1,2314,1042,1041,-1,2314,2429,1042,-1,2485,2920,2921,-1,2485,2735,2920,-1,2469,1613,1035,-1,2484,1613,2469,-1,881,1037,879,-1,881,1038,1037,-1,2482,1419,1028,-1,2482,1506,1419,-1,1613,2485,2921,-1,2485,1613,2484,-1,2850,1042,2429,-1,1042,2850,2347,-1,2349,933,1601,-1,2349,935,933,-1,1029,2480,895,-1,1622,2480,1029,-1,2339,888,2340,-1,2339,889,888,-1,900,1016,1015,-1,900,2476,1016,-1,2738,2299,2736,-1,2457,2299,2738,-1,2835,2844,2836,-1,2843,2844,2835,-1,2303,2744,2743,-1,2303,2479,2744,-1,1685,1627,1630,-1,1685,904,1627,-1,2335,1684,1248,-1,2335,2306,1684,-1,2475,2719,2707,-1,2719,2475,2720,-1,1003,2922,1633,-1,1003,2305,2922,-1,996,992,997,-1,996,993,992,-1,914,2331,1674,-1,2331,914,997,-1,911,2332,912,-1,911,2333,2332,-1,1418,1667,982,-1,1418,1666,1667,-1,2461,2308,984,-1,2461,2307,2308,-1,1642,2841,1641,-1,1642,2309,2841,-1,2750,1504,2386,-1,2750,2751,1504,-1,2424,2756,1284,-1,2424,2753,2756,-1,1566,2923,2833,-1,1566,2761,2923,-1,2437,1294,1100,-1,2437,2924,1294,-1,1121,1264,1119,-1,1121,1265,1264,-1,2426,1116,1483,-1,2426,2425,1116,-1,1527,1128,863,-1,1128,1527,1721,-1,1695,2482,846,-1,1695,1506,2482,-1,2363,1131,1130,-1,1131,2363,2389,-1,2362,1100,1102,-1,1100,2362,2436,-1,1111,1121,1120,-1,1111,1491,1121,-1,2365,1567,1274,-1,1567,2365,1126,-1,1557,2438,1558,-1,1557,2439,2438,-1,1106,1497,1107,-1,1106,1262,1497,-1,1256,2440,2834,-1,2440,1256,2441,-1,1546,1157,1149,-1,1157,1546,1545,-1,2838,1546,1161,-1,2838,1547,1546,-1,1153,2838,1151,-1,1547,2838,1153,-1,2373,1154,1158,-1,1154,2373,1148,-1,2370,814,1183,-1,814,2370,815,-1,1334,1178,1180,-1,1334,2374,1178,-1,2433,1188,1533,-1,1188,2433,2431,-1,1190,2764,1209,-1,1190,1189,2764,-1,1195,2378,1537,-1,2837,2378,1195,-1,1535,1194,1197,-1,1535,2765,1194,-1,1196,1528,1212,-1,1196,1432,1528,-1,1538,2431,2763,-1,1538,1539,2431,-1,2432,2763,1235,-1,1538,2763,2432,-1,1329,1214,1216,-1,1328,1214,1329,-1,832,805,804,-1,805,832,834,-1,1217,1477,1281,-1,1477,1217,1219,-1,2397,1141,2396,-1,1459,1141,2397,-1,1335,1228,1422,-1,1335,1227,1228,-1,1514,1401,1384,-1,1514,1402,1401,-1,818,823,827,-1,818,1165,823,-1,1168,1347,1447,-1,1347,1168,1373,-1,1275,1484,1263,-1,2833,1484,1275,-1,2351,2316,1580,-1,2351,2447,2316,-1,2474,988,2711,-1,989,988,2474,-1,2427,1181,2428,-1,2427,1182,1181,-1,1521,1692,1259,-1,1521,1523,1692,-1,920,2309,921,-1,920,2841,2309,-1,2289,1675,1713,-1,2289,2712,1675,-1,2486,859,1712,-1,2486,860,859,-1,1715,850,1113,-1,1715,851,850,-1,2441,1571,1570,-1,2759,1571,2441,-1,2759,2758,1571,-1,2872,2772,2648,-1,2772,2872,2773,-1,2714,880,1696,-1,2714,2851,880,-1,2390,2839,2760,-1,1556,2839,2390,-1,2839,1556,1558,-1,2652,2773,2872,-1,2773,2652,2391,-1,1266,2392,1267,-1,2392,1266,2774,-1,2925,2755,1565,-1,2840,2755,2925,-1,1278,1116,1115,-1,1278,1483,1116,-1,1278,1277,1483,-1,1562,2776,1559,-1,2780,2776,1562,-1,2840,2779,2754,-1,2840,2925,2779,-1,1482,1276,2365,-1,1482,1277,1276,-1,2775,2278,1278,-1,2775,1478,2278,-1,1303,2365,1276,-1,1302,2365,1303,-1,1567,1284,1568,-1,1284,1567,1285,-1,1474,2366,1475,-1,1474,2367,2366,-1,1117,1472,1103,-1,1117,1288,1472,-1,1291,829,1102,-1,2782,829,1291,-1,1293,772,1470,-1,772,1293,1296,-1,1302,1298,1126,-1,1302,1468,1298,-1,1734,1220,1223,-1,1734,1221,1220,-1,809,829,1310,-1,830,829,809,-1,1308,1525,1469,-1,1525,1308,1143,-1,1320,2423,1319,-1,1320,1322,2423,-1,1325,1320,1458,-1,1325,1323,1320,-1,1551,2423,1552,-1,1551,1317,2423,-1,779,1455,824,-1,1134,1455,779,-1,1326,2783,1327,-1,2783,1326,1552,-1,1402,2,2125,-1,1402,1354,2,-1,2400,1345,1344,-1,1345,2400,1442,-1,1348,1443,1346,-1,1348,1510,1443,-1,1348,1351,2785,-1,1348,1352,1351,-1,1436,2785,2405,-1,1436,2420,2785,-1,2117,2404,1437,-1,2404,2117,2116,-1,1358,1429,1357,-1,1429,1358,1138,-1,2418,1436,1359,-1,2119,1436,2418,-1,1515,1535,1534,-1,1535,1515,2375,-1,1530,1529,1206,-1,1366,1529,1530,-1,1427,762,761,-1,1427,1361,762,-1,1081,2918,2727,-1,1081,2919,2918,-1,998,991,1637,-1,998,992,991,-1,1062,952,1416,-1,1062,2444,952,-1,965,1383,1382,-1,965,960,1383,-1,1383,1411,1381,-1,1411,1383,2829,-1,1369,1414,1367,-1,1369,2412,1414,-1,2349,1600,1608,-1,2349,1601,1600,-1,2790,1407,2407,-1,2790,2791,1407,-1,2790,2827,2792,-1,2790,2789,2827,-1,2767,2412,1369,-1,2413,2412,2767,-1,2828,2796,2797,-1,2796,2828,2793,-1,2464,968,1398,-1,2459,968,2464,-1,2823,2796,2795,-1,2796,2823,2798,-1,1385,1388,1387,-1,1385,1400,1388,-1,2825,1390,2808,-1,1390,2825,1389,-1,2801,2826,2799,-1,2801,2804,2826,-1,2804,2815,2802,-1,2804,2801,2815,-1,2808,2812,2806,-1,2808,1390,2812,-1,2822,2409,1399,-1,2409,2822,2811,-1,2698,2809,2699,-1,2698,2814,2809,-1,2817,2700,2701,-1,2700,2817,2807,-1,1644,2702,2276,-1,2702,1644,2803,-1,1271,750,2818,-1,1271,1270,750,-1,2276,2819,970,-1,2276,2274,2819,-1,2803,2820,2702,-1,2820,2803,2802,-1,2807,2821,2700,-1,2821,2807,2806,-1,2699,2811,1395,-1,2699,2809,2811,-1,2812,1391,2814,-1,1390,1391,2812,-1,2801,2817,2815,-1,2801,2800,2817,-1,1644,2460,1639,-1,1644,987,2460,-1,1398,2804,1638,-1,2804,1398,2826,-1,2823,2808,2805,-1,2808,2823,2825,-1,1400,2810,1388,-1,2409,2810,1400,-1,1400,1384,1401,-1,1385,1384,1400,-1,2795,2825,2823,-1,2795,2824,2825,-1,2826,968,967,-1,968,2826,1398,-1,1626,2797,967,-1,2797,1626,2828,-1,2827,1387,2824,-1,1387,2827,2408,-1,1424,1341,1403,-1,1425,1341,1424,-1,2408,2789,2794,-1,2789,2408,2827,-1,1404,2828,1626,-1,1404,1406,2828,-1,1596,2791,1406,-1,2791,1596,1407,-1,1409,2407,1407,-1,2407,1409,1381,-1,2917,1599,2728,-1,1599,2917,1045,-1,2829,1414,1411,-1,1414,2829,1415,-1,962,2829,1383,-1,962,1652,2829,-1,2917,2447,1046,-1,2918,2447,2917,-1,1343,1445,2399,-1,2422,1445,1343,-1,1164,1553,764,-1,1164,1166,1553,-1,1365,1430,1203,-1,1431,1430,1365,-1,1434,1428,1435,-1,1428,1434,30,-1,1428,1357,1429,-1,1428,30,1357,-1,1510,2785,2420,-1,1510,1348,2785,-1,1443,2402,1444,-1,1511,2402,1443,-1,1346,1442,2400,-1,1346,1443,1442,-1,2422,1342,1445,-1,2422,36,1342,-1,2783,1218,1327,-1,2398,1218,2783,-1,1133,1456,1134,-1,1456,1133,1460,-1,773,2492,774,-1,1733,2492,773,-1,1469,1524,2832,-1,1469,1525,1524,-1,1735,1221,1734,-1,1735,1306,1221,-1,2832,1470,1469,-1,1470,2832,1293,-1,1298,1297,1295,-1,1298,1301,1297,-1,828,1102,829,-1,2281,1102,828,-1,2924,1560,1286,-1,2924,2437,1560,-1,1285,2924,1286,-1,1125,2924,1285,-1,2277,1478,1477,-1,2277,2278,1478,-1,1272,1283,1481,-1,1272,1279,1283,-1,1459,1551,2371,-1,1459,1317,1551,-1,2925,2761,2779,-1,2925,2923,2761,-1,1252,1573,2435,-1,1573,1252,2394,-1,865,950,2291,-1,865,1656,950,-1,1481,1266,634,-1,1266,1481,2778,-1,1564,2925,1565,-1,2925,1564,2923,-1,1110,1573,2394,-1,1110,1109,1573,-1,1254,1490,1710,-1,1490,1254,2291,-1,2774,1114,2392,-1,1114,2774,1115,-1,2391,635,1267,-1,2391,2652,635,-1,1558,1132,2839,-1,1558,1498,1132,-1,1558,2438,1498,-1,837,1527,835,-1,1527,837,873,-1,841,1085,1500,-1,841,843,1085,-1,2773,2834,2772,-1,2834,2773,1496,-1,2758,2389,1571,-1,2758,2388,2389,-1,1693,1691,2489,-1,1692,1691,1693,-1,2440,1569,857,-1,2440,1570,1569,-1,1714,1712,857,-1,1714,2289,1712,-1,860,2311,861,-1,860,926,2311,-1,1691,1523,1020,-1,1523,1691,1692,-1,984,2711,988,-1,984,2308,2711,-1,2770,2416,2713,-1,2416,2770,2417,-1,1373,1348,1347,-1,1352,1348,1373,-1,2381,1376,1519,-1,1420,1376,2381,-1,1237,825,1238,-1,1237,826,825,-1,1232,2399,1446,-1,2399,1232,1450,-1,2381,1542,1421,-1,1542,2381,1173,-1,1021,2744,1019,-1,2744,1021,2455,-1,1222,1466,1220,-1,1222,1526,1466,-1,1369,1424,1403,-1,1368,1424,1369,-1,2383,1530,1206,-1,2383,2377,1530,-1,1198,1194,1212,-1,1197,1194,1198,-1,1513,1537,544,-1,1537,1513,1512,-1,1517,1189,1518,-1,2764,1189,1517,-1,1540,1538,2432,-1,1540,1186,1538,-1,1210,1515,2376,-1,1515,1210,2375,-1,1176,1172,1334,-1,1172,1176,1175,-1,1450,2382,1426,-1,1450,1448,2382,-1,1160,1146,1161,-1,1160,2372,1146,-1,1161,1147,2838,-1,1146,1147,1161,-1,1545,1153,1544,-1,1545,1547,1153,-1,850,1571,1112,-1,850,1569,1571,-1,2319,947,1488,-1,947,2319,948,-1,1255,1555,2364,-1,1495,1555,1255,-1,947,1489,1488,-1,947,1268,1489,-1,863,1106,1108,-1,1106,863,1129,-1,1274,1482,2365,-1,1274,1273,1482,-1,1131,2839,1132,-1,1131,2388,2839,-1,1105,2366,1118,-1,1105,1563,2366,-1,1125,1294,2924,-1,1294,1125,1127,-1,2833,1564,1484,-1,1564,2833,2923,-1,1486,2754,2752,-1,2754,1486,2840,-1,2781,1562,1563,-1,2781,2780,1562,-1,2766,2741,2740,-1,1522,2741,2766,-1,1522,2380,2741,-1,1462,787,795,-1,788,787,1462,-1,2410,2416,2330,-1,2768,2416,2410,-1,1249,2442,1095,-1,1249,2600,2442,-1,2443,2386,2385,-1,2443,2750,2386,-1,1094,1502,1095,-1,1094,1503,1502,-1,2361,2471,2327,-1,2361,2470,2471,-1,2309,2462,923,-1,2309,1642,2462,-1,2328,2310,977,-1,2328,1668,2310,-1,2926,1006,1634,-1,2926,2745,1006,-1,913,995,1672,-1,913,1001,995,-1,994,1672,995,-1,994,1673,1672,-1,912,1001,913,-1,912,2332,1001,-1,1633,2926,1634,-1,1633,2922,2926,-1,2842,2707,2719,-1,2842,2706,2707,-1,1008,2306,2335,-1,1008,2709,2306,-1,2475,1630,2720,-1,2475,1685,1630,-1,1016,898,2742,-1,898,1016,2476,-1,1013,2301,2704,-1,1375,2301,1013,-1,2300,2457,2456,-1,2300,2299,2457,-1,901,1015,1624,-1,901,900,1015,-1,890,2740,2741,-1,890,2481,2740,-1,895,1030,1029,-1,895,894,1030,-1,2725,2315,1040,-1,2315,2725,2714,-1,2734,2453,1614,-1,2734,2851,2453,-1,1605,1579,2846,-1,1032,1579,1605,-1,886,1028,2454,-1,886,2482,1028,-1,2714,2453,2851,-1,2453,2714,2725,-1,2735,1612,2920,-1,2735,2313,1612,-1,2847,2846,2733,-1,1605,2846,2847,-1,2347,874,2449,-1,2347,2850,874,-1,2787,1702,2848,-1,2787,931,1702,-1,2316,1704,1079,-1,1704,2316,2919,-1,811,1602,812,-1,811,1606,1602,-1,1662,1055,940,-1,1056,1055,1662,-1,2320,2730,2319,-1,2320,2415,2730,-1,2354,1582,2293,-1,2354,1054,1582,-1,945,1051,1058,-1,1051,945,1661,-1,1054,2359,1582,-1,1053,2359,1054,-1,2715,1071,2358,-1,2715,2716,1071,-1,1655,1377,1069,-1,955,1377,1655,-1,1591,951,1657,-1,1591,1590,951,-1,1588,2323,1589,-1,1588,1587,2323,-1,1059,1050,1595,-1,1059,1048,1050,-1,1412,1595,1050,-1,1412,1594,1595,-1,1598,2728,1599,-1,1598,2448,2728,-1,2347,2452,1616,-1,2452,2347,2449,-1,2452,1610,1616,-1,1611,1610,2452,-1,1404,2721,1405,-1,1404,1617,2721,-1,1613,2920,1612,-1,1613,2921,2920,-1,1649,1023,2341,-1,1023,1649,2766,-1,1605,1034,1036,-1,1605,2847,1034,-1,2338,2454,1027,-1,2340,2454,2338,-1,1026,1033,1618,-1,1026,1025,1033,-1,1612,2721,2345,-1,2721,1612,2723,-1,2459,1629,2458,-1,2459,2718,1629,-1,2836,2456,2337,-1,2836,2844,2456,-1,2717,1393,1640,-1,1393,2717,1576,-1,2771,2330,2417,-1,2330,2771,2331,-1,993,1000,991,-1,993,995,1000,-1,990,2768,2410,-1,990,989,2768,-1,986,2329,2461,-1,978,2329,986,-1,975,981,976,-1,975,1418,981,-1,973,971,974,-1,973,1648,971,-1,963,1382,1380,-1,963,965,1382,-1,1651,1068,1067,-1,1650,1068,1651,-1,959,1585,1240,-1,959,1586,1585,-1,2322,2292,1653,-1,2292,2322,2849,-1,2393,2320,1488,-1,2731,2320,2393,-1,2919,1080,1704,-1,2919,1081,1080,-1,1700,2429,2297,-1,2850,2429,1700,-1,2307,2841,920,-1,2748,2841,2307,-1,914,1574,2747,-1,914,918,1574,-1,2472,915,1674,-1,2472,2290,915,-1,1679,2922,2305,-1,1679,2926,2922,-1,2710,1681,1680,-1,2709,1681,2710,-1,1681,2926,1679,-1,2745,2926,1681,-1,2707,905,2475,-1,2707,1687,905,-1,1682,2708,1686,-1,2708,1682,2306,-1,2301,902,2478,-1,2301,1718,902,-1,893,887,894,-1,893,2286,887,-1,1698,877,842,-1,1697,877,1698,-1,842,2732,843,-1,878,2732,842,-1,930,2491,1701,-1,930,2466,2491,-1,836,813,837,-1,836,1080,813,-1,1492,1706,864,-1,1584,1706,1492,-1,1268,1707,1269,-1,947,1707,1268,-1,1243,1289,1244,-1,1290,1289,1243,-1,858,915,856,-1,916,915,858,-1,847,903,2287,-1,896,903,847,-1,845,2286,2285,-1,887,2286,845,-1,828,806,1723,-1,828,830,806,-1,1725,784,2927,-1,1724,784,1725,-1,2280,1729,1508,-1,800,1729,2280,-1,765,784,1731,-1,765,2927,784,-1,765,1725,2927,-1,2494,1725,765,-1,2278,2492,1276,-1,2278,774,2492,-1,1304,2492,1733,-1,1304,1303,2492,-1,1457,775,1458,-1,775,1457,1732,-1,638,1397,2818,-1,638,1738,1397,-1,2274,2195,2600,-1,2275,2195,2274,-1,2816,2852,2820,-1,2915,2852,2816,-1,2813,2853,2821,-1,2916,2853,2813,-1,2273,2854,1395,-1,2697,2854,2273,-1,2855,2697,2861,-1,2854,2697,2855,-1,2916,2856,2853,-1,2916,1740,2856,-1,2915,2857,2852,-1,2915,2859,2857,-1,2913,2859,2858,-1,2913,2857,2859,-1,1740,2914,2856,-1,1739,2914,1740,-1,2855,2860,2688,-1,2860,2855,2861,-1,1739,2912,2914,-1,1739,740,2912,-1,1973,2858,2683,-1,2913,2858,1973,-1,386,1973,387,-1,386,1974,1973,-1,2912,2679,2686,-1,2678,2679,2912,-1,2646,1743,1858,-1,2646,1744,1743,-1,2862,741,1744,-1,741,2862,739,-1,2684,2496,2682,-1,2684,2677,2496,-1,2862,736,2680,-1,1747,736,2862,-1,722,2672,2674,-1,724,2672,722,-1,1993,733,2272,-1,1993,1994,733,-1,1751,440,439,-1,1751,2221,440,-1,364,2201,362,-1,364,1980,2201,-1,2612,1932,2614,-1,2612,2907,1932,-1,1761,590,589,-1,1760,590,1761,-1,1872,2510,2064,-1,1872,1871,2510,-1,75,2864,2261,-1,2864,75,1874,-1,713,1771,463,-1,1771,713,2863,-1,1762,716,2264,-1,717,716,1762,-1,2668,2666,2667,-1,2668,1774,2666,-1,10,2865,11,-1,2865,10,2863,-1,2265,1777,1776,-1,1777,2265,2092,-1,2665,1855,2865,-1,2665,1854,1855,-1,712,1779,700,-1,1779,712,1855,-1,1780,709,1788,-1,1780,1779,709,-1,702,705,1781,-1,702,1787,705,-1,697,2237,695,-1,697,2238,2237,-1,679,2911,579,-1,2911,679,2260,-1,672,685,2258,-1,672,686,685,-1,2642,677,682,-1,2642,2260,677,-1,2642,2911,2260,-1,682,1799,2259,-1,682,2505,1799,-1,669,2866,2060,-1,669,580,2866,-1,587,2255,588,-1,2255,587,1807,-1,494,2640,654,-1,494,2230,2640,-1,2640,1817,654,-1,1817,2640,1907,-1,2643,1798,2258,-1,2643,2259,1798,-1,651,2869,2507,-1,651,2638,2869,-1,2524,496,2231,-1,1826,496,2524,-1,324,2046,2515,-1,324,323,2046,-1,633,647,634,-1,2658,647,633,-1,2869,487,486,-1,2638,487,2869,-1,2524,226,1826,-1,2524,1921,226,-1,2249,225,224,-1,2515,225,2249,-1,2227,2653,1831,-1,2226,2653,2227,-1,629,630,1915,-1,630,629,631,-1,481,1831,502,-1,2227,1831,481,-1,2248,1833,2871,-1,1836,1833,2248,-1,1908,628,1835,-1,1908,2873,628,-1,2509,2159,1905,-1,2509,1902,2159,-1,251,2160,2575,-1,2162,2160,251,-1,1931,2055,2163,-1,1931,2056,2055,-1,2641,2871,2647,-1,2248,2871,2641,-1,1840,2876,2523,-1,1840,1839,2876,-1,2568,258,2165,-1,258,2568,259,-1,2522,1918,217,-1,2522,1919,1918,-1,219,218,217,-1,219,2572,218,-1,2170,2047,861,-1,2170,299,2047,-1,2246,2568,2605,-1,259,2568,2246,-1,2900,357,356,-1,2900,290,357,-1,1755,2595,2596,-1,1757,2595,1755,-1,710,2267,708,-1,2267,710,2263,-1,133,589,134,-1,589,133,1761,-1,599,604,606,-1,599,601,604,-1,1861,725,721,-1,1861,596,725,-1,1783,1880,1784,-1,1881,1880,1783,-1,398,2225,2224,-1,398,397,2225,-1,656,1813,654,-1,1813,656,2657,-1,1766,534,1765,-1,1766,535,534,-1,533,551,549,-1,551,533,532,-1,539,597,2242,-1,539,1878,597,-1,2239,1868,2882,-1,2239,2516,1868,-1,691,1863,719,-1,2238,1863,691,-1,595,696,695,-1,595,594,696,-1,2066,2240,1870,-1,2065,2240,2066,-1,513,520,1891,-1,1895,520,513,-1,2644,1893,2236,-1,1893,2644,517,-1,1886,2521,2236,-1,1886,1885,2521,-1,1894,2520,1887,-1,2520,1894,518,-1,479,1840,2523,-1,1840,479,478,-1,2163,2576,201,-1,2576,2163,2247,-1,500,1915,498,-1,500,2650,1915,-1,1834,2228,2227,-1,2508,2228,1834,-1,1824,1909,2524,-1,1910,1909,1824,-1,623,1917,2875,-1,622,1917,623,-1,475,636,1828,-1,475,637,636,-1,2159,1904,1905,-1,2159,2057,1904,-1,2250,2232,642,-1,2233,2232,2250,-1,1839,2873,2876,-1,2873,1839,2651,-1,495,2231,496,-1,495,491,2231,-1,2230,493,2229,-1,2230,494,493,-1,1825,2870,1823,-1,2870,1825,2867,-1,2879,2910,2877,-1,2879,2222,2910,-1,2634,352,351,-1,2634,291,352,-1,290,2198,357,-1,290,289,2198,-1,2012,730,729,-1,2012,2559,730,-1,2543,277,2018,-1,2543,2542,277,-1,1982,2017,2561,-1,1981,2017,1982,-1,1980,367,1981,-1,1980,1983,367,-1,2906,2202,376,-1,2906,270,2202,-1,2897,2180,2901,-1,2898,2180,2897,-1,281,378,617,-1,281,280,378,-1,381,2181,382,-1,381,2022,2181,-1,2645,264,2887,-1,2645,2177,264,-1,2627,2880,2881,-1,2880,2627,2626,-1,260,2889,2888,-1,2889,260,2206,-1,2604,2027,391,-1,2604,2023,2027,-1,2035,2538,2540,-1,2035,2175,2538,-1,2176,1964,2028,-1,1964,2176,396,-1,2002,2531,2675,-1,2002,306,2531,-1,2213,2599,2513,-1,2533,2599,2213,-1,2174,2537,2895,-1,2173,2537,2174,-1,728,2037,1758,-1,728,727,2037,-1,2210,2040,2039,-1,2210,2209,2040,-1,2537,2009,408,-1,2009,2537,2173,-1,2894,2174,2895,-1,2894,2891,2174,-1,2213,2512,2211,-1,2213,2513,2512,-1,2532,306,308,-1,2532,2531,306,-1,1948,2907,2612,-1,1948,2557,2907,-1,2067,2675,2909,-1,2067,2002,2675,-1,431,310,1946,-1,431,312,310,-1,1998,2892,236,-1,1997,2892,1998,-1,2618,2554,2190,-1,2554,2618,2908,-1,1945,317,319,-1,1945,2617,317,-1,1944,314,2892,-1,1944,1956,314,-1,2171,1935,1999,-1,433,1935,2171,-1,2550,1936,327,-1,2550,1937,1936,-1,1996,442,320,-1,442,1996,443,-1,732,1751,439,-1,732,322,1751,-1,334,325,2271,-1,334,2500,325,-1,446,331,2616,-1,446,445,331,-1,1754,2908,425,-1,2270,2908,1754,-1,438,423,2615,-1,438,2499,423,-1,1947,427,429,-1,2528,427,1947,-1,1945,2615,2617,-1,1945,438,2615,-1,2529,1954,1953,-1,2529,2214,1954,-1,2909,416,415,-1,2909,2675,416,-1,2610,413,412,-1,2610,2608,413,-1,2497,420,2530,-1,2497,1953,420,-1,2607,406,2210,-1,2607,2534,406,-1,404,342,341,-1,342,404,2536,-1,1964,398,1965,-1,1964,396,398,-1,2535,2893,2536,-1,2535,2624,2893,-1,2887,1969,2645,-1,2887,2603,1969,-1,388,1972,1974,-1,388,1976,1972,-1,373,744,380,-1,373,372,744,-1,383,2898,2896,-1,382,2898,383,-1,2204,384,383,-1,2203,384,2204,-1,2269,2889,2206,-1,2269,2886,2889,-1,2899,464,369,-1,464,2899,465,-1,2899,364,363,-1,369,364,2899,-1,1986,358,2199,-1,2200,358,1986,-1,2199,2197,348,-1,2199,1987,2197,-1,355,349,348,-1,355,354,349,-1,2194,2275,2192,-1,2194,2195,2275,-1,1975,2191,1972,-1,2205,2191,1975,-1,323,1995,234,-1,2553,1995,323,-1,2891,2041,2174,-1,254,2041,2891,-1,2014,288,282,-1,288,2014,289,-1,290,2592,283,-1,290,2900,2592,-1,270,2166,271,-1,270,2562,2166,-1,2888,263,260,-1,2885,263,2888,-1,206,265,2566,-1,206,208,265,-1,2880,261,269,-1,2626,261,2880,-1,2027,2024,1841,-1,2024,2027,2023,-1,2569,2056,1931,-1,2569,2625,2056,-1,2526,2161,2162,-1,2161,2526,2004,-1,1827,2221,1752,-1,1827,2619,2221,-1,2169,296,220,-1,2169,2011,296,-1,273,2167,2049,-1,2167,273,271,-1,2591,2050,2052,-1,2591,2649,2050,-1,2052,2522,2167,-1,2051,2522,2052,-1,2038,197,2058,-1,197,2038,198,-1,2161,194,2160,-1,194,2161,195,-1,2630,2517,2897,-1,2630,616,2517,-1,602,604,1879,-1,602,605,604,-1,246,2069,1837,-1,246,2067,2069,-1,173,2577,2156,-1,173,2061,2577,-1,2081,2155,162,-1,2075,2155,2081,-1,2085,1923,1924,-1,1923,2085,1801,-1,664,587,2086,-1,1808,587,664,-1,2150,2504,2902,-1,2150,506,2504,-1,82,2099,116,-1,2099,82,2147,-1,2590,2581,2148,-1,2590,124,2581,-1,2149,2589,119,-1,2589,2149,114,-1,2146,2103,102,-1,2146,2104,2103,-1,105,2588,93,-1,2588,105,98,-1,96,2105,97,-1,2105,96,2101,-1,66,100,79,-1,66,2106,100,-1,78,84,2582,-1,85,84,78,-1,89,88,83,-1,87,88,89,-1,2587,2112,2147,-1,2112,2587,2142,-1,2111,1207,566,-1,1207,2111,2098,-1,2127,46,2139,-1,47,46,2127,-1,2411,2822,1399,-1,2586,2822,2411,-1,1436,2403,2420,-1,1436,2118,2403,-1,38,33,2120,-1,33,38,34,-1,42,39,2138,-1,2584,39,42,-1,38,2138,39,-1,38,2121,2138,-1,1353,2136,2,-1,2584,2136,1353,-1,2128,2139,43,-1,2127,2139,2128,-1,46,2419,28,-1,31,2419,46,-1,2116,2904,2404,-1,2904,2116,2130,-1,19,2132,22,-1,2132,19,2134,-1,19,2137,20,-1,15,2137,19,-1,2667,24,2502,-1,2667,2666,24,-1,2129,2404,2904,-1,2129,2124,2404,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='frontal_Coord',point=[(-.73343,57.98217,3.00093),(-.74383,58.02005,3.0232),(-.79722,58.01823,3.01247),(-.58177,57.82446,2.81154),(-.51511,57.7903,2.80396),(-.58246,57.82203,2.81319),(-.64859,57.86269,2.87623),(-.63982,57.86361,2.87421),(-.6471,57.90777,2.95201),(.75828,57.88402,2.78827),(.5494,57.82753,2.73206),(.7542,57.88829,2.71161),(.75784,57.85031,2.78508),(.77737,57.84407,2.77956),(.78251,57.8536,2.86801),(.74581,57.85941,2.87718),(.77515,57.86185,2.77584),(.77317,57.88061,2.76306),(.97265,57.84997,2.71272),(.74208,57.86836,2.88062),(.80359,57.8777,2.90315),(.80653,57.90045,2.91411),(.75282,57.85991,2.7793),(.76933,57.88345,2.75501),(.74991,57.88931,2.88961),(.80662,57.90333,2.91723),(-.45326,57.9758,3.09186),(-.52133,57.87911,2.97361),(-.47558,57.8567,2.98126),(-.41347,57.71588,2.82385),(-.36134,57.62736,2.78219),(-.41203,57.71831,2.83289),(-.54316,57.88791,2.96877),(-.77248,57.86045,2.83389),(-.77416,57.86355,2.86209),(-.98023,57.84973,2.8308),(-1.22649,57.71782,2.72001),(-.97816,57.83925,2.80178),(-.67861,57.83717,2.86754),(-.68536,57.84616,2.88863),(-.77522,57.86534,2.88039),(-.66283,57.90817,2.95017),(-.67896,57.90024,2.94873),(-.59327,57.81018,2.85493),(-.58135,57.84137,2.86686),(-.58856,57.83722,2.85082),(-.51103,57.78531,2.85613),(-.51546,57.77826,2.83492),(0,57.68008,2.99049),(-.00009,57.57549,2.96967),(.02167,57.57812,2.96015),(-.12349,57.60491,2.9965),(-.07243,57.57054,2.99355),(.09799,57.77934,2.90741),(.08967,57.58672,2.81528),(-.00407,57.61228,2.81279),(.04846,57.46949,2.89623),(.07827,57.5603,2.8096),(.10345,57.5476,2.80775),(-.06285,57.4631,2.86436),(-.08676,57.48649,2.88048),(-.06704,57.57166,2.84152),(.18712,57.46919,2.92658),(.16224,57.50062,2.94453),(.16535,57.51255,2.94341),(.11331,57.49719,2.93631),(.082,57.48068,2.93426),(-.05454,57.46332,2.86523),(-.05058,57.44698,2.9002),(-.16224,57.50062,2.93754),(-.2054,57.47642,2.93886),(-.11068,57.50989,2.89654),(-.2166,57.49198,2.96131),(-.18453,57.48942,2.97622),(.18453,57.48942,2.98433),(.20776,57.48621,2.97641),(.11873,57.63669,3.00354),(.00199,57.58369,2.9447),(.03303,57.55707,2.87882),(.04016,57.45882,2.93883),(.04741,57.55342,2.89521),(-.06206,57.64779,2.85593),(-.06595,57.64534,2.85397),(-.05975,57.63961,2.85248),(.00939,57.62005,2.85527),(.01982,57.62469,2.85604),(.01942,57.63285,2.85885),(-.0153,57.54541,2.864),(-.01116,57.62078,2.85472),(-.0395,57.54411,2.86172),(-.04128,57.54489,2.86586),(.00785,57.62597,2.87247),(.00834,57.6254,2.86847),(.07605,57.58241,2.9924),(.07243,57.57054,2.99657),(.06006,57.60492,2.91928),(.12687,57.5896,2.90487),(.13635,57.5769,2.91273),(.13414,57.56043,2.96363),(.07832,57.62734,2.87708),(.06087,57.55863,2.90119),(.19305,57.51129,2.97295),(.17511,57.52314,2.95648),(.07084,57.64732,2.86809),(.06595,57.64534,2.85639),(.0772,57.58191,2.9764),(.09693,57.63061,2.89382),(-.08462,57.47363,2.9191),(-.07141,57.5494,2.87274),(-.0882,57.56133,2.89607),(-.09437,57.56931,2.89249),(-.11408,57.5903,2.88452),(-.1225,57.57753,2.89307),(-.13635,57.5769,2.90728),(-.13414,57.56043,2.95808),(-.16051,57.56395,2.90335),(-.07832,57.62734,2.87412),(-.05153,57.5417,2.86469),(-.05891,57.44843,2.902),(-.19305,57.51129,2.96468),(-.16535,57.51255,2.93637),(-.15693,57.52532,2.92788),(-.11331,57.49719,2.9314),(-.09693,57.63061,2.89015),(-.0772,57.58191,2.97323),(-.09539,57.62523,2.87729),(1.0946,57.45297,1.56035),(.93831,57.44597,1.52519),(.92636,57.39944,1.29677),(.3217,57.24648,1.38578),(.44559,57.31911,1.40662),(.4247,57.29751,1.33588),(1.12298,57.56506,1.28791),(1.25002,57.56872,1.45629),(1.13746,57.47706,1.5409),(.74694,58.16614,2.82898),(.71675,58.1647,2.83634),(.74144,58.42936,2.86338),(.7617,58.03511,2.69315),(.65622,58.01306,2.72571),(.83481,57.97578,2.35294),(.79269,58.02465,2.51355),(.81871,58.02745,2.51915),(1.04135,57.98259,2.60122),(1.0653,57.96024,2.45159),(1.0334,57.9615,2.44361),(.95744,58.04301,2.70824),(.98807,58.0488,2.70673),(.87293,57.87515,2.20135),(.88861,57.95013,2.35648),(.87816,57.99236,2.5477),(.79214,58.0421,2.69576),(.83603,58.03659,2.70172),(.32761,57.17135,1.48002),(.35122,57.1902,1.4444),(.36291,57.17763,1.44817),(.41293,57.28534,1.29607),(.30548,57.22279,1.34485),(1.12301,57.56724,1.29369),(1.31407,57.65435,1.30903),(.49849,57.3085,1.30646),(.55025,57.32448,1.29003),(.55444,57.28766,1.29068),(.64741,57.29535,1.29502),(.63414,57.31311,1.30386),(.78344,57.36684,1.32109),(.91203,57.414,1.27556),(.89793,57.41441,1.32533),(1.11961,57.55429,1.33987),(.28008,57.14981,1.49567),(.28009,57.16018,1.47195),(1.48782,57.75498,1.3816),(1.39715,57.70826,1.35367),(1.39139,57.71106,1.37431),(1.55028,57.78194,1.54407),(1.75765,58.03276,1.52572),(1.57459,57.83311,1.41377),(.09663,57.63386,2.38718),(0,57.6313,2.40808),(.08939,57.6245,2.38834),(.21972,57.38065,1.70931),(.17459,57.45885,1.90708),(.21824,57.38549,1.70827),(.16385,60.81882,.59488),(.20329,60.80796,.6193),(.09139,60.62889,.74574),(1.41246,57.70809,1.32028),(1.55579,57.687,1.57806),(1.48565,57.72929,1.29766),(1.54094,57.79857,1.3102),(1.45243,57.68502,1.31115),(1.80358,59.15946,1.30024),(1.82971,59.11559,1.25567),(1.84957,59.04005,1.26932),(1.74865,59.29786,1.3367),(1.78065,59.2952,1.22755),(1.78998,59.26668,1.22838),(1.67007,59.43705,1.38234),(1.71441,59.4764,1.21653),(1.73399,59.4378,1.22344),(1.59734,59.70002,1.17333),(1.51776,59.67084,1.43103),(1.58878,59.71267,1.16919),(1.5374,59.78858,1.14434),(1.44254,59.77458,1.40481),(1.52028,59.81389,1.13606),(1.4578,59.88272,1.11359),(1.37054,59.84293,1.38382),(1.43099,59.90845,1.10521),(1.32276,60.01235,1.07136),(1.22654,59.97962,1.34186),(1.30472,60.02966,1.06571),(1.20329,59.93166,1.48533),(1.15505,60.03356,1.32211),(1.2345,60.08299,1.04831),(1.18231,60.119,1.03654),(.62781,60.34278,1.23407),(.66547,60.22722,1.54839),(.53724,60.37707,1.22684),(.31551,60.34313,1.58319),(.26384,60.45932,1.19686),(.35611,60.44565,1.21238),(1.73098,59.13884,1.55288),(1.85002,58.98947,1.28611),(1.80926,58.64912,1.73159),(1.82149,58.4755,1.77741),(1.7214,58.68442,1.91356),(1.77889,58.12785,1.50934),(1.78957,58.25413,1.65222),(1.67295,57.91754,1.26498),(1.67964,57.92461,1.31221),(1.65828,57.8848,1.32498),(1.81531,58.13341,1.26431),(1.76786,58.0833,1.28787),(1.84248,58.18386,1.2703),(1.92241,58.61514,1.16235),(1.90777,58.64349,1.14166),(1.91578,58.62223,1.16046),(1.85153,58.70751,1.37424),(1.95223,58.83752,1.04642),(1.8509,58.89045,1.319),(1.94672,58.88767,1.0447),(1.95453,58.88433,1.03493),(1.96395,58.83057,1.02537),(1.92082,59.12103,1.01437),(1.8853,59.2667,1.00167),(1.84224,59.26244,1.117),(1.87587,59.28279,.99665),(1.86517,59.32126,.98663),(1.85525,59.33648,.98894),(1.83514,59.40029,.9728),(1.74799,59.39502,1.22468),(1.82512,59.42699,.96638),(1.67524,59.55359,1.2027),(1.7524,59.56547,.94292),(1.76251,59.54983,.94357),(1.81273,59.45853,.95859),(1.81731,59.4476,.96193),(1.50315,59.83919,1.12778),(1.56959,59.83124,.91332),(1.3415,60.03698,.88288),(1.33318,60.04369,.87861),(1.36972,60.01248,.90644),(1.36153,60.01951,.90179),(1.4921,59.89802,.80565),(1.49629,59.90068,.89423),(1.46637,59.92894,.89209),(1.28668,60.04698,1.06007),(1.3026,60.07031,.89373),(1.31266,60.06163,.89313),(1.04015,60.2656,.81073),(.97709,60.24743,.97801),(1.01566,60.28278,.80982),(.92666,60.27564,.96051),(.96142,60.30545,.77735),(.87623,60.30384,.94301),(.92083,60.32241,.75305),(.9783,60.31394,.63934),(.9981,60.29856,.6909),(1.18252,60.16128,.89011),(1.14249,60.1916,.8889),(1.16218,60.17868,.85852),(.43639,60.51548,.79475),(.45629,60.49845,.84954),(.39247,60.52609,.83784),(.86537,60.34803,.72998),(.84386,60.3645,.72826),(.81958,60.37859,.65201),(.48031,60.50487,.75165),(.5031,60.50258,.69085),(.52422,60.49426,.70856),(.46533,60.52695,.57539),(.44017,60.53026,.65921),(.44226,60.52894,.59722),(.36634,60.58429,.63651),(.3244,60.53208,.82607),(.25633,60.53807,.8143),(.12573,60.62434,.69416),(.14612,60.59541,.6944),(.12019,60.55006,.79076),(.20504,60.5842,.69063),(.30348,60.61608,.67199),(1.77174,59.57544,1.07883),(1.76018,59.59265,1.07176),(1.81094,59.47322,.98218),(1.81446,59.46773,1.00333),(1.87937,59.28872,1.02251),(1.87148,59.30092,.98641),(1.87273,59.30324,1.00244),(1.94631,58.90733,1.0763),(1.95462,58.87036,1.07272),(1.97336,58.77681,1.0158),(1.95021,58.83697,1.07964),(1.94023,58.82048,1.09929),(1.9262,58.66028,1.17067),(1.92621,58.65922,1.19226),(1.92611,58.65318,1.19867),(1.92606,58.64036,1.23378),(1.92018,58.59335,1.17206),(1.92639,58.65098,1.22171),(1.8272,58.15992,1.37018),(1.81196,58.13852,1.35845),(1.91701,58.35498,1.39816),(1.86717,58.23809,1.26987),(1.90477,58.33254,1.22615),(1.79994,58.12,1.37033),(1.63692,57.84499,1.33766),(1.67423,57.89196,1.35202),(1.701,57.96442,1.29934),(1.70242,57.94416,1.35495),(1.67221,57.86831,1.37718),(1.77808,57.93826,1.49579),(1.82551,58.10231,1.6706),(1.76096,57.89979,1.84481),(1.81361,58.0773,1.36474),(1.83296,58.13636,1.40642),(1.84089,58.15303,1.61044),(1.89379,58.43953,1.65732),(1.87166,58.25448,1.48952),(1.90342,58.3057,1.44552),(1.83218,59.2394,1.59841),(1.86065,59.37914,1.34469),(1.82383,59.44577,1.37336),(.41824,60.7437,.60088),(.40397,60.76735,.62099),(.42836,60.7579,.66259),(.39175,60.75778,.58224),(.38752,60.77372,.59295),(.53001,60.67012,.96884),(.45657,60.6962,.97525),(.46813,60.63813,1.24433),(.63271,60.69901,.50995),(.60062,60.70888,.51243),(.52142,60.71476,.70988),(.4692,60.74208,.73223),(.52316,60.72153,.72545),(.7325,60.63118,.61766),(.66061,60.6457,.68187),(.66735,60.66663,.70735),(.8878,60.4872,1.19774),(.87888,60.40712,1.4661),(.97727,60.43746,1.18178),(.88418,60.54437,.93791),(.94725,60.51332,.92863),(.95431,60.51633,.87478),(.99186,60.52109,.60993),(.97332,60.53262,.605),(.98466,60.51946,.68707),(1.02049,60.49684,.70135),(1.02444,60.4883,.81165),(1.04667,60.48075,.70579),(1.18007,60.39871,.89437),(1.16951,60.37183,1.00742),(1.20475,60.36684,.90746),(1.19385,60.37976,.80326),(1.20127,60.37022,.74603),(1.17645,60.38236,.73998),(1.18205,60.35483,.85115),(1.25822,60.30893,.88392),(1.20608,60.33854,.85881),(1.22943,60.33496,.92056),(1.39677,60.22092,.8725),(1.39463,60.22546,.85023),(1.38055,60.2248,.90817),(1.40583,60.20914,.90308),(1.60277,59.89501,1.2934),(1.5342,59.96459,1.31771),(1.59018,59.79255,1.52324),(1.46741,60.11752,1.10149),(1.50454,60.07959,1.08952),(1.51531,60.09235,.93528),(1.53971,60.08387,.93866),(1.52975,60.09399,.92918),(1.78784,59.66681,1.02248),(1.78098,59.68643,1.03324),(1.78848,59.64616,1.16551),(1.7388,59.81207,.89123),(1.71993,59.81717,.93063),(1.72734,59.78822,1.02281),(1.64959,59.8962,1.03447),(1.61136,59.97043,1.05507),(1.78,59.67459,1.21218),(1.79708,59.63621,1.19978),(1.88246,59.44432,1.13778),(1.86539,59.4827,1.15018),(1.89892,59.49457,1.00147),(1.84822,59.50876,1.10861),(1.85678,59.49265,1.1159),(1.79471,59.64719,1.01172),(1.79695,59.61774,1.11883),(1.79562,59.61183,1.06374),(1.88729,59.33376,1.32497),(1.93931,59.3117,1.14059),(1.92036,59.35591,1.13965),(1.91394,59.28838,1.30525),(1.9806,59.20477,1.12611),(1.95826,59.26749,1.14153),(1.94058,59.243,1.28554),(1.80285,59.68888,.9256),(1.78072,59.70809,.95537),(1.89047,59.109,1.53415),(1.946,59.20083,1.27834),(1.91324,58.78315,1.64142),(1.92738,58.82634,1.56239),(1.86072,58.95428,1.77208),(1.96628,58.66613,1.38888),(1.97176,58.69232,1.36777),(2.00663,58.97086,1.06888),(2.00254,58.99977,1.08784),(1.9731,58.98995,1.24237),(1.99951,58.8205,1.11759),(1.99015,58.83141,1.09923),(1.9763,58.90821,1.27014),(1.99305,58.72317,1.1072),(1.99595,58.72027,1.09502),(1.97791,58.86734,1.28403),(1.96934,58.65111,1.22139),(1.97071,58.64547,1.20783),(1.98272,58.74472,1.32536),(1.95693,58.38218,1.37372),(1.9412,58.46663,1.35855),(1.95318,58.48388,1.41374),(1.87495,58.15598,1.3777),(1.88437,58.18183,1.38684),(1.85231,58.19542,1.44801),(1.78719,57.97393,1.4623),(1.75549,57.98665,1.36634),(1.6925,57.8898,1.36451),(1.70281,57.90429,1.363),(1.7075,57.89163,1.41671),(1.65238,57.85151,1.34978),(1.92642,58.72045,1.07813),(1.9454,58.8036,1.08224),(1.95775,58.78736,1.04815),(1.9389,58.98799,1.01894),(1.94009,58.98853,1.0642),(1.94002,58.96209,1.0454),(1.71031,59.65136,.97344),(1.70672,59.64852,.95582),(1.70071,59.65213,.97664),(1.78438,59.55662,1.04089),(.33996,57.47754,2.01503),(.45376,57.57075,1.98968),(.45055,57.64142,2.21316),(1.13169,60.43212,.86527),(1.12721,60.42473,.90215),(1.10801,57.46144,1.55044),(1.11123,57.45914,1.57673),(1.40321,57.80423,2.11775),(1.43857,57.70551,1.86149),(1.25029,57.72323,2.02079),(1.4566,57.72636,1.87862),(1.45894,57.72001,1.85713),(1.70087,58.88466,1.90463),(1.58672,59.21507,1.87769),(1.79703,58.82274,1.68429),(1.62345,58.902,2.03668),(1.37758,59.69393,1.66657),(1.37144,59.66863,1.76309),(1.17303,59.84714,1.72174),(.98904,59.76738,2.11998),(.83966,59.65344,2.44476),(.87002,59.79556,2.1953),(1.15509,58.10396,2.68142),(1.17313,58.38304,2.72894),(1.29501,58.0771,2.571),(1.43454,58.75308,2.47165),(1.40304,58.72588,2.50245),(1.38776,58.7404,2.51103),(1.6768,58.03773,1.99606),(1.66249,58.02411,2.0101),(1.68842,58.17401,2.04664),(1.599,57.9573,2.08217),(1.59395,57.94798,2.07814),(1.59129,57.95627,2.09888),(1.74895,58.31228,1.95008),(1.74837,58.34771,1.94805),(1.72402,58.02808,1.78514),(1.04668,59.10528,2.70392),(1.02884,59.11406,2.71169),(1.2442,59.36014,2.29434),(.87184,59.80835,2.16998),(.57309,59.7218,2.46006),(.26931,57.38784,1.7197),(.29509,57.45306,1.95559),(.29089,57.44942,1.95652),(.27255,57.27919,1.60902),(.33131,57.2989,1.58447),(.32718,57.40296,1.7306),(.29713,57.43651,2.00624),(.30082,57.43522,2.00162),(.3134,57.40258,2.12065),(.31054,57.48716,2.02416),(.3173,57.4722,2.01066),(.30717,57.46642,2.00142),(.3206,57.49567,2.006),(.31772,57.49532,2.00622),(.31836,57.49414,2.00131),(.30934,57.48996,2.00439),(.31916,57.49774,2.02543),(.33545,57.4707,2.00427),(.30709,57.44463,2.00197),(1.36917,57.65398,2.08013),(1.44388,57.49079,2.00603),(1.47224,57.60258,2.1029),(1.49531,57.61378,2.10527),(1.4555,57.49442,1.99719),(1.53375,57.55772,2.17313),(1.54144,57.56411,2.16952),(1.56108,57.56356,2.20611),(1.37679,57.49151,1.83301),(.40515,57.77473,2.62883),(.43715,57.87339,2.75915),(.42925,57.8875,2.72266),(.31985,57.48639,2.6473),(.24623,57.5508,2.81866),(.41807,57.78197,2.80606),(.28304,57.6945,2.46518),(.27885,57.7154,2.46712),(.32041,57.67876,2.47893),(.33093,57.67419,2.44838),(.32073,57.4596,2.48791),(.33688,57.5951,2.49297),(.32958,57.4927,2.46986),(0,57.61189,2.43235),(.00396,57.63494,2.41059),(.1575,57.78126,2.57136),(.31151,57.85845,2.76062),(.24434,57.82065,2.70024),(.33907,57.8883,2.76931),(.31773,57.83367,2.78199),(.35029,57.87245,2.79901),(.29385,57.72197,2.83361),(.33274,57.74811,2.84896),(.09583,57.5735,2.80675),(.12266,57.56547,2.81465),(.06295,57.56922,2.81421),(0,57.94362,2.8265),(.09268,57.86717,2.73439),(.12779,57.90175,2.8079),(.3458,57.35411,2.49552),(.34897,57.35486,2.49716),(.32428,57.35102,2.62196),(.31694,57.36444,2.23171),(.3221,57.33931,2.36806),(.2983,57.46637,2.34358),(-.02691,57.46405,2.86811),(-.00572,57.57687,2.81268),(.31993,57.50052,2.38531),(.32369,57.5597,2.32318),(.35661,57.59428,2.50633),(.38695,57.67605,2.65836),(.23075,57.5818,2.26987),(.25747,57.66807,2.38677),(.31645,57.90895,2.79918),(.31801,57.87933,2.80658),(.12211,57.87918,2.82926),(.12409,57.81384,2.538),(.19405,57.87613,2.66976),(.29029,57.82855,2.55657),(.983,57.57938,1.77753),(.84441,57.58935,1.71331),(.83098,57.71324,1.86819),(.78678,57.88606,2.08391),(.72244,57.82138,2.061),(.70086,57.82094,2.11454),(.98215,57.86534,2.27123),(1.08394,57.84512,2.29777),(1.00543,57.82579,2.18428),(1.3706,57.52531,1.82492),(1.44782,57.56559,1.95589),(1.67538,57.74565,1.68162),(1.59319,57.68318,1.91034),(1.5435,57.64952,1.85739),(1.62639,57.65956,2.4181),(1.60446,57.61331,2.27473),(1.57903,57.70076,2.29813),(.35061,57.67726,2.49564),(.39256,57.80511,2.60593),(.2053,57.57721,2.10573),(.15379,57.48423,2.02762),(.16253,57.50871,2.1069),(.11172,57.56503,2.27489),(.13383,57.5675,2.2584),(.11406,57.55135,2.22828),(.10801,57.5684,2.2708),(.15256,57.62784,2.24011),(1.34782,57.64092,1.30759),(.48427,57.38856,1.55952),(.56876,57.40561,1.49837),(.5537,57.33563,1.35425),(1.64266,57.90574,1.32249),(1.70834,57.99069,1.29934),(1.64399,57.90193,1.26436),(1.72236,58.00423,1.28637),(1.70162,57.98727,1.26463),(1.2991,60.28655,.84212),(1.2792,60.30469,.85883),(1.25411,60.30308,.93365),(.07232,60.62945,.73977),(.14019,60.82422,.58895),(1.77309,58.25197,1.77002),(.90384,59.91695,1.94014),(.98764,59.78478,2.09172),(.88056,59.83354,2.11541),(1.57738,59.81358,.89294),(1.58623,59.80496,.90233),(1.06275,59.40035,2.49646),(1.07932,59.5175,2.36399),(1.37657,59.21909,2.22912),(1.24044,59.05649,2.56018),(1.39508,58.98439,2.36211),(1.38968,58.97296,2.38026),(.25541,59.20981,2.82973),(0,59.23591,2.72042),(0,59.5624,2.60563),(1.85129,58.67881,1.38125),(1.80362,58.82265,1.63919),(.01688,58.72089,2.69267),(.01688,59.05448,2.74922),(.02903,58.7379,2.8045),(1.18853,58.3971,2.7194),(1.15279,58.75011,2.73277),(1.21821,58.72895,2.688),(.98396,58.427,2.8292),(.77638,58.80602,2.88815),(.08212,58.32721,2.88584),(.02797,58.75811,2.86653),(.0476,58.2801,2.74466),(.11099,57.96454,2.73138),(0,57.94286,2.62555),(1.39457,58.34404,2.53317),(1.43877,58.17429,2.47024),(1.40388,58.23232,2.50788),(1.56264,58.02571,2.24562),(1.43388,58.14842,2.46639),(1.47621,58.21764,2.41429),(1.60846,57.87706,1.86341),(1.62302,57.83403,1.72813),(1.16006,57.78548,2.0579),(1.17799,57.82675,2.20105),(1.27783,57.79748,2.13965),(1.31123,57.88553,2.31085),(1.12622,57.86353,2.35735),(1.08574,57.88408,2.35895),(1.20365,57.94098,2.45804),(.95139,57.96757,2.57112),(.92385,57.8541,2.19727),(.86312,57.47074,1.53229),(1.051,57.51823,1.62351),(1.08555,57.55132,1.48317),(.73268,57.59722,1.76206),(.49548,57.58031,1.90345),(.57352,57.64729,1.89022),(.57149,57.5254,1.76039),(.6875,57.9416,2.51852),(.80846,57.97131,2.35626),(.5685,57.89883,2.47194),(.58848,57.93002,2.60185),(.43683,57.92029,2.61676),(.46064,57.97401,2.78764),(.61551,57.88306,2.4461),(.62473,57.86501,2.38257),(.19677,57.27921,1.58892),(.195,57.46419,1.90479),(.36589,57.61841,2.13345),(.36494,57.51614,1.90901),(.27816,57.68028,2.32482),(.17493,57.75138,2.46218),(.09681,57.66618,2.37793),(.36748,57.94014,2.76652),(1.55008,57.58595,2.30366),(1.50523,57.60333,2.32937),(1.49607,57.60126,2.12365),(1.53266,57.67555,2.10371),(1.59817,57.59459,2.28145),(1.62157,57.63756,2.42276),(1.57262,57.58131,2.45291),(1.39726,57.73215,2.26676),(1.48842,57.59699,2.12642),(1.21366,57.82861,2.56197),(1.22296,57.75919,2.66409),(1.27421,57.77525,2.76647),(1.00754,57.99944,2.92392),(.98588,57.88769,2.89147),(1.3291,57.65908,2.6708),(1.32588,57.7126,2.6021),(1.4467,57.64625,2.47974),(1.19959,57.70507,2.05851),(1.20939,57.77964,2.19964),(.96322,57.73911,2.03648),(.80151,57.92721,2.96765),(.96757,57.87095,2.66042),(.60175,57.77199,2.22974),(.23075,57.43594,2.8853),(.32954,57.50783,2.7247),(.37499,57.58954,2.43641),(.3325,57.42164,2.29122),(.3375,57.48022,1.9648),(1.52442,57.50892,2.46956),(1.51526,57.82762,2.60274),(1.57312,57.83221,2.46762),(1.56718,58.03481,2.47468),(1.64769,57.84665,2.08685),(1.62279,57.96348,2.28105),(1.5756,57.79438,2.30707),(1.64177,57.76166,1.98435),(1.69606,59.65559,.97852),(1.77117,59.72178,.95991),(.53281,60.72617,.53015),(.51408,60.72473,.55676),(1.7027,57.96973,1.2779),(1.93518,58.35692,1.40126),(1.93089,58.5369,1.52165),(1.80861,58.78089,1.98376),(1.75038,58.87902,2.05827),(1.68998,58.63089,2.29497),(1.75019,59.57902,1.4307),(1.749,59.71314,1.22639),(1.3423,58.7308,2.71085),(1.22205,58.916,2.82494),(1.24779,58.62984,2.79646),(1.01924,58.13908,2.95566),(1.2819,57.91969,2.76803),(1.15621,60.33798,1.14985),(1.10437,60.3668,1.1591),(1.15631,60.26052,1.40971),(0,57.98171,3.0815),(.07321,57.88398,3.07917),(.20638,58.09589,3.13046),(0,59.05448,2.74922),(-.94345,57.41307,1.29563),(-1.12298,57.56506,1.28791),(-.91833,57.40713,1.26295),(-.81717,57.33546,1.30873),(-.93831,57.44597,1.52519),(-.92636,57.39944,1.29677),(-.54283,57.29775,1.35389),(-.6497,57.39658,1.51764),(-.66195,57.30061,1.32538),(-.35104,57.22319,1.49847),(-.33131,57.2989,1.58295),(-.4985,57.36042,1.54254),(-.19677,57.27921,1.58775),(-.19145,57.27549,1.59963),(-.16959,57.1865,1.51829),(-.17653,57.20231,1.4982),(-.3217,57.24648,1.38578),(-.35675,57.29765,1.47435),(-1.0946,57.45297,1.56035),(-1.1043,57.85253,2.3238),(-1.08394,57.84512,2.29484),(-1.12618,57.84547,2.23142),(-.83603,58.03659,2.69401),(-.74694,58.16614,2.82288),(-.79214,58.0421,2.68791),(-.83481,57.97578,2.34878),(-.79419,57.92361,2.18723),(-.81904,57.92215,2.1843),(-.23968,57.38073,1.68862),(-.21824,57.38549,1.70637),(-.62661,57.41242,1.473),(-.56876,57.40561,1.49835),(-.5537,57.33563,1.35425),(-.16066,57.15615,1.45842),(-.30548,57.22279,1.34485),(-.80936,57.33199,1.25199),(-.63414,57.31311,1.30386),(-.62422,57.3409,1.36393),(-1.11961,57.55429,1.33987),(-1.09171,57.56132,1.35055),(-.90388,57.43521,1.32282),(-.66298,57.28475,1.27047),(-.64741,57.29535,1.29502),(-.55444,57.28766,1.29068),(-.78344,57.36684,1.32109),(-.78496,57.3533,1.31854),(-.89793,57.41441,1.32533),(-.91203,57.414,1.27556),(-.79988,57.33812,1.28274),(-.44682,57.2359,1.37297),(-.36291,57.17763,1.44784),(-.50853,57.28878,1.37224),(-1.48254,57.77083,1.39963),(-1.48782,57.75498,1.3816),(-1.56814,57.8235,1.39657),(-1.2985,57.64574,1.37157),(-1.31289,57.63586,1.35818),(-1.39715,57.70826,1.35367),(-1.08555,57.55132,1.48317),(-.88189,57.4475,1.41622),(-1.91046,59.19107,1.10893),(-1.8945,59.2582,1.00563),(-1.90932,59.18096,1.01055),(-.29977,57.47693,2.06502),(-.30759,57.39981,2.11374),(-.29713,57.43651,2.00093),(-.29089,57.44942,1.95188),(-.15535,57.47786,2.01913),(-.29452,57.4939,2.05176),(-.08636,57.62662,2.36149),(-.08939,57.6245,2.38597),(-.11172,57.56503,2.27212),(-.17447,57.46472,1.90136),(-.195,57.46419,1.90196),(-.2053,57.57721,2.10189),(-.16253,57.50871,2.10354),(-.15379,57.48423,2.02476),(-1.37349,57.67129,1.52694),(-1.26394,57.5761,1.72428),(-1.2851,57.61597,1.51819),(-1.41246,57.70809,1.32028),(-1.4908,57.76801,1.33489),(-1.5135,57.77566,1.32772),(-1.57039,57.838,1.3512),(-1.80358,59.15946,1.30024),(-1.82971,59.11559,1.25567),(-1.80985,59.19114,1.24202),(-1.62383,59.50917,1.39723),(-1.6147,59.42695,1.54376),(-1.67007,59.43705,1.38234),(-1.57758,59.58129,1.41213),(-1.65565,59.59218,1.19579),(-1.64586,59.61148,1.19233),(-1.59734,59.70002,1.17333),(-1.51776,59.67084,1.43103),(-1.6059,59.68736,1.17747),(-1.37054,59.84293,1.38382),(-1.4223,59.75534,1.45924),(-1.44254,59.77458,1.40481),(-.97195,60.08257,1.51499),(-1.08355,60.0875,1.30236),(-1.01206,60.14144,1.28261),(-.81627,60.2528,1.25507),(-.92666,60.27564,.96051),(-.87623,60.30384,.94301),(-.62781,60.34278,1.23407),(-.66547,60.22722,1.54839),(-.71837,60.30848,1.2413),(0,60.3782,1.5591),(-.0793,60.48666,1.16583),(0,60.50032,1.15032),(-1.85002,58.98947,1.28611),(-1.73098,59.13884,1.55288),(-1.8509,58.89045,1.319),(-1.82139,58.31804,1.47524),(-1.80014,58.22294,1.49252),(-1.84248,58.18386,1.2703),(-1.85177,58.73621,1.36719),(-1.90777,58.64349,1.14166),(-1.90775,58.65789,1.13616),(-1.87587,59.28279,.99665),(-1.87148,59.30092,.98641),(-1.78998,59.26668,1.22838),(-1.83732,59.40419,1.00764),(-1.83514,59.40029,.9728),(-1.84208,59.38386,.97475),(-1.74636,59.5752,.94239),(-1.73219,59.60057,.93565),(-1.7987,59.47873,.95062),(-1.81273,59.45853,.95859),(-1.80651,59.47388,.95871),(-1.73399,59.4378,1.22344),(-1.78696,59.49607,.95392),(-1.78237,59.52191,.94557),(-1.71441,59.4764,1.21653),(-1.67791,59.67333,.95),(-1.58878,59.71267,1.16919),(-1.67139,59.68506,.95543),(-1.67016,59.68711,.95791),(-1.59318,59.79405,.89803),(-1.5374,59.78858,1.14434),(-1.55453,59.76328,1.15263),(-1.64522,59.735,.92983),(-1.66518,59.69548,.95733),(-1.65224,59.70544,.90479),(-1.43099,59.90845,1.10521),(-1.49629,59.90068,.89423),(-1.46637,59.92894,.89209),(-1.37688,59.9604,1.08828),(-1.43278,59.95818,.91999),(-1.42368,59.96596,.91272),(-1.35884,59.97771,1.08264),(-1.39491,59.94308,1.09393),(-1.28958,60.08126,.86015),(-1.26257,60.10063,.89252),(-1.3026,60.07031,.89373),(-.99484,60.29887,.75886),(-.96142,60.30545,.77735),(-1.01566,60.28278,.80982),(-.92083,60.32241,.75305),(-.9783,60.31394,.63934),(-.93146,60.3204,.66974),(-.889,60.33572,.73399),(-.80086,60.39743,.72479),(-.71155,60.38789,.89631),(-.77537,60.36025,.908),(-.84386,60.3645,.72826),(-.82236,60.38097,.72652),(-.43639,60.51548,.79475),(-.47163,60.51642,.67503),(-.44017,60.53026,.65921),(-.4087,60.5441,.64338),(-.44226,60.52894,.59722),(-.20504,60.5842,.69063),(-.14612,60.59541,.6944),(-.12019,60.55006,.79076),(-.12573,60.62434,.69416),(-.16006,60.61978,.64259),(-.22075,60.62179,.58581),(-1.85525,59.33648,.98894),(-1.86471,59.33426,1.04258),(-1.85896,59.35344,1.05673),(-1.88478,59.27344,1.02227),(-1.8853,59.2667,1.00167),(-1.87937,59.28872,1.02251),(-1.94002,58.96209,1.0454),(-1.94254,58.95881,1.03388),(-1.9412,58.93782,1.04298),(-1.95453,58.88433,1.03493),(-1.94631,58.90733,1.0763),(-1.94147,58.93872,1.04888),(-1.96395,58.83057,1.02537),(-1.95021,58.83697,1.07964),(-1.91578,58.62223,1.16046),(-1.9262,58.66028,1.17067),(-1.9079,58.65836,1.14233),(-1.92018,58.59335,1.17206),(-1.92622,58.63117,1.25968),(-1.92606,58.64036,1.23378),(-1.90477,58.33254,1.22615),(-1.91701,58.35498,1.39816),(-1.90599,58.37847,1.36202),(-1.84132,58.17732,1.37732),(-1.81531,58.13341,1.26431),(-1.79994,58.12,1.37033),(-1.76786,58.0833,1.28787),(-1.75924,57.90292,1.53009),(-1.74279,57.91495,1.45624),(-1.67538,57.74565,1.68162),(-1.91234,58.48821,1.5896),(-1.90342,58.3057,1.44552),(-1.89379,58.43953,1.65732),(-1.94945,58.58558,1.45345),(-1.95318,58.48388,1.41374),(-1.93089,58.5369,1.52165),(-1.39707,60.10375,1.36633),(-1.3767,60.00363,1.61482),(-1.31681,60.156,1.38079),(-.33401,60.76515,.73184),(-.30128,60.72073,.97045),(-.24783,60.77985,.7316),(-.16385,60.81882,.59488),(-.20329,60.80796,.6193),(-.16165,60.79456,.73135),(-.47123,60.74065,.55053),(-.42836,60.7579,.66259),(-.41824,60.7437,.60088),(-.57713,60.70098,.71868),(-.53001,60.67012,.96884),(-.52316,60.72153,.72545),(-.4692,60.74208,.73223),(-.53281,60.72617,.53015),(-.52142,60.71476,.70988),(-.66061,60.6457,.68187),(-.66735,60.66663,.70735),(-.63109,60.68044,.7119),(-.60345,60.64405,.96242),(-.7325,60.63118,.61766),(-.7588,60.61982,.63327),(-.77328,60.6263,.69405),(-.95431,60.51633,.87478),(-.95175,60.54377,.68745),(-.98612,60.52031,.6944),(-.99186,60.52109,.60993),(-1.02049,60.49684,.70135),(-.98466,60.51946,.68707),(-.94883,60.54208,.67279),(-.93222,60.55711,.6835),(-1.13169,60.43212,.86527),(-1.02444,60.4883,.81165),(-1.04667,60.48075,.70579),(-1.13137,60.40163,.77762),(-1.15519,60.38678,.77928),(-1.18007,60.39871,.89437),(-1.19385,60.37976,.80326),(-1.2082,60.35404,.78337),(-1.18205,60.35483,.85115),(-1.20608,60.33854,.85881),(-1.39771,60.18876,1.12397),(-1.43869,60.14688,1.11075),(-1.46563,60.03417,1.34202),(-1.46741,60.11752,1.10149),(-1.49241,60.13338,.88132),(-1.50795,60.11716,.89967),(-1.53971,60.08387,.93866),(-1.54782,60.07594,.94371),(-1.50454,60.07959,1.08952),(-1.50937,60.11323,.9223),(-1.64899,59.95629,.86139),(-1.64722,59.93615,.8976),(-1.60081,59.99715,1.00799),(-1.75367,59.73141,1.1175),(-1.72734,59.78822,1.02281),(-1.74293,59.76083,1.02988),(-1.77412,59.70605,1.044),(-1.78,59.67459,1.21218),(-1.7672,59.7182,1.04087),(-1.76739,59.73172,.95474),(-1.74395,59.79945,.90122),(-1.74313,59.77709,.94465),(-1.77735,59.71431,.95483),(-1.78072,59.70809,.95537),(-1.78098,59.68643,1.03324),(-1.80883,59.6673,.94281),(-1.79471,59.64719,1.01172),(-1.78784,59.66681,1.02248),(-1.90069,59.50535,.94587),(-1.90586,59.49834,.95767),(-1.84822,59.50876,1.10861),(-1.89758,59.46858,1.03222),(-1.90809,59.46364,1.00171),(-1.90403,59.45004,1.03678),(-1.96438,58.95133,1.323),(-1.95567,58.91271,1.40362),(-1.93393,58.97814,1.44713),(-1.9731,58.98995,1.24237),(-1.9747,58.94908,1.25626),(-1.98139,58.77844,1.31408),(-1.98272,58.74472,1.32536),(-1.9737,58.80072,1.35154),(-1.97284,58.65455,1.19949),(-1.97791,58.86734,1.28403),(-1.98935,58.80279,1.09494),(-1.99595,58.72027,1.09502),(-1.9965,58.90617,1.09929),(-1.99612,58.86965,1.09221),(-1.99015,58.83141,1.09923),(-1.97826,58.65492,1.18286),(-1.98031,58.80603,1.3048),(-1.98503,58.65942,1.14904),(-1.94192,58.51019,1.36433),(-1.9412,58.46663,1.35855),(-1.87166,58.25448,1.48952),(-1.90801,58.26955,1.37646),(-1.89735,58.22793,1.38784),(-1.88437,58.18183,1.38684),(-1.83296,58.13636,1.40642),(-1.85231,58.19542,1.44801),(-1.86582,58.12821,1.36458),(-1.87495,58.15598,1.3777),(-1.73443,57.95597,1.356),(-1.77808,57.93826,1.49579),(-1.72228,57.9297,1.34852),(-1.71014,57.9041,1.35146),(-1.70281,57.90429,1.363),(-1.99075,58.70762,1.11285),(-1.97951,58.82647,1.2979),(-1.84957,59.04005,1.26932),(-1.9389,58.98799,1.01894),(-1.92082,59.12103,1.01437),(-1.9237,59.1172,1.111),(-1.91879,59.15201,1.10295),(-1.71112,59.63775,.93905),(-1.70672,59.64852,.95582),(-1.63607,59.63077,1.18887),(-1.70071,59.65213,.97664),(-.3134,57.40258,2.11366),(-.37453,57.54261,2.19095),(-.33996,57.47754,2.00928),(-1.70162,57.98727,1.26463),(-1.7027,57.96973,1.2779),(-1.72236,58.00423,1.28637),(-.06973,60.846,.55787),(-.12066,60.82214,.54994),(-.14388,60.82908,.55767),(-.06911,60.85102,.52729),(-1.11704,60.4208,.72943),(-.45376,57.57075,1.98392),(-.3375,57.48022,1.95968),(-1.48284,57.86411,2.11863),(-1.40321,57.80423,2.11775),(-1.43857,57.70551,1.86149),(-1.72468,58.02844,1.76041),(-1.72402,58.02808,1.78514),(-1.61852,57.89614,1.87668),(-1.78533,58.86236,1.6833),(-1.79703,58.82274,1.68429),(-1.80362,58.82265,1.63919),(-1.61406,58.74584,2.10469),(-1.7214,58.68442,1.91356),(-1.62973,58.8919,2.03217),(-1.17303,59.84714,1.72174),(-1.20329,59.93166,1.48533),(-.80554,59.45415,2.61202),(-.79936,59.16303,2.79776),(-.92127,59.13431,2.75613),(-1.60846,57.87706,1.86341),(-1.60289,57.87962,1.88478),(-1.48933,58.81127,2.33048),(-1.50151,58.81025,2.30533),(-1.49121,58.82851,2.31419),(-.83966,59.65344,2.44476),(-.85499,59.65052,2.43785),(-1.01888,59.76339,2.09333),(-1.37929,58.00409,2.44764),(-1.29501,58.0771,2.57076),(-1.36462,57.98993,2.44528),(-1.71468,59.17053,1.5717),(-1.71319,59.15537,1.59399),(-1.5122,59.38276,1.86362),(-1.48391,59.41423,1.87856),(-1.50526,59.37691,1.88372),(-.48427,57.38856,1.55893),(-.37439,57.43004,1.71558),(-.29906,57.45024,1.95297),(-.29509,57.45306,1.95092),(-.30054,57.44922,1.96096),(-.3325,57.42164,2.28217),(-.31979,57.37195,2.23369),(-.31694,57.36444,2.22322),(-.63447,57.7186,2.00846),(-.73682,57.71485,1.91763),(-.81396,57.81294,2.01407),(-.30082,57.43522,1.99629),(-.30456,57.4464,1.98282),(-.33515,57.47688,1.97241),(-.32885,57.47419,1.96136),(-.32708,57.48495,2.01114),(-.32226,57.4977,2.01823),(-.32055,57.49618,2.0213),(-.3118,57.47861,1.98012),(-.3084,57.48633,1.99681),(-.31034,57.48893,1.99433),(-.3173,57.4722,2.00523),(-.30717,57.46642,1.9962),(-.30554,57.44829,1.98196),(-.31916,57.49774,2.02),(-.31428,57.45282,1.99361),(-.30709,57.44463,1.9966),(-.32996,57.48396,2.00095),(-.3282,57.48615,1.98834),(-.30897,57.48567,2.01496),(-.30972,57.47401,1.98517),(-.21972,57.38065,1.70736),(-.17459,57.45885,1.90449),(-.26931,57.38784,1.71733),(-1.11123,57.45914,1.57673),(-1.25267,57.51809,1.82154),(-1.36354,57.48378,1.84352),(-1.59035,57.59459,2.28119),(-1.59762,57.61331,2.27454),(-1.55938,57.56356,2.20601),(-1.37679,57.49151,1.83301),(-1.44388,57.49079,2.00601),(-1.56282,57.58117,2.29634),(-1.54439,57.58595,2.30312),(-1.55038,57.57573,2.3267),(-1.49607,57.60126,2.12364),(-1.47224,57.60258,2.10289),(-1.48842,57.59699,2.1264),(-.13383,57.5675,2.25517),(-.11776,57.54722,2.22836),(-.30351,57.53417,2.15577),(-.23075,57.5818,2.26445),(-.27332,57.52434,2.28751),(-.28304,57.6945,2.45806),(-.25747,57.66807,2.38055),(-.09663,57.63386,2.38466),(-.33688,57.5951,2.48344),(-.35661,57.59428,2.4962),(-.33027,57.49081,2.49029),(-.14082,57.56629,2.80829),(-.14945,57.56229,2.80981),(-.31151,57.85845,2.75269),(-.24434,57.82065,2.69379),(-.23179,57.85102,2.68912),(-.31773,57.83367,2.77352),(-.31801,57.87933,2.79853),(-.29917,57.74216,2.85605),(-.09708,57.58937,2.8318),(-.30041,57.69542,2.85167),(-.24623,57.5508,2.80925),(-.31536,57.35048,2.60617),(-.32428,57.35102,2.60939),(-.34897,57.35486,2.48501),(-.2983,57.46637,2.3352),(-.03522,57.46383,2.86725),(-.32369,57.5597,2.31516),(-.35061,57.67726,2.48663),(-.40515,57.77473,2.61877),(-.12211,57.87918,2.82594),(-.31645,57.90895,2.79155),(-.29816,57.53838,2.15185),(-.12409,57.81384,2.53502),(0,57.79915,2.50487),(0,57.66772,2.39165),(-.36748,57.94014,2.75848),(-.43683,57.92029,2.6084),(-.46064,57.97401,2.77856),(-.98215,57.86534,2.26779),(-.96292,57.94639,2.36682),(-.88861,57.95013,2.35229),(-1.05721,57.88519,2.34071),(-1.25411,60.30308,.93365),(-1.2991,60.28655,.84212),(-1.30469,60.27177,.92346),(-1.59319,57.68318,1.91034),(-1.5435,57.64952,1.85739),(-1.62066,57.65956,2.41786),(-1.57782,57.73749,2.44735),(-1.57408,57.70076,2.298),(-1.61024,57.656,2.50969),(-1.5666,57.83221,2.46746),(-1.57205,57.79438,2.30698),(-.39256,57.80511,2.59671),(-.10801,57.5684,2.26815),(-.11406,57.55135,2.22557),(-.15256,57.62784,2.23678),(-1.34782,57.64092,1.30759),(-1.55579,57.687,1.57806),(-1.45243,57.68502,1.31115),(-.49727,57.32742,1.36174),(-1.70834,57.99069,1.29934),(-1.64266,57.90574,1.32249),(-1.67295,57.91754,1.26498),(-1.63692,57.84499,1.33766),(-1.64399,57.90193,1.26436),(-1.2792,60.30469,.85883),(-.14019,60.82422,.58895),(-.07232,60.62945,.73977),(-.09139,60.62889,.74574),(-1.74837,58.34771,1.94805),(-1.77309,58.25197,1.77002),(-1.82149,58.4755,1.77741),(-.98764,59.78478,2.09172),(-.90384,59.91695,1.94014),(-.88056,59.83354,2.11541),(-1.58623,59.80496,.90233),(-1.57738,59.81358,.89294),(-1.52058,59.52669,1.60338),(-1.37758,59.69393,1.66657),(-1.59491,59.21872,1.85734),(-1.24044,59.05649,2.56018),(-1.38968,58.97296,2.38026),(-1.39508,58.98439,2.36211),(-.25541,59.20981,2.82973),(-.25056,59.51413,2.65527),(-1.85129,58.67881,1.38125),(-1.85153,58.70751,1.37424),(-.01688,59.05448,2.74922),(-.01688,58.72089,2.69267),(-.02903,58.7379,2.8045),(-1.15279,58.75011,2.73277),(-1.18853,58.3971,2.7194),(-1.21821,58.72895,2.688),(-.98396,58.427,2.8292),(-1.0147,58.77795,2.79552),(-.77638,58.80602,2.88815),(-.0476,58.2801,2.74417),(-.01688,58.25076,2.64246),(-.25081,58.00415,2.83973),(-.25106,58.38717,2.94982),(-.08212,58.32721,2.88503),(-1.43388,58.14842,2.46639),(-1.4029,58.07082,2.46156),(-1.56264,58.02571,2.24562),(-1.45894,57.72001,1.85713),(-1.62302,57.83403,1.72813),(-1.70015,57.96925,1.42408),(-1.75765,58.03276,1.52572),(-1.25029,57.72323,2.02072),(-1.27783,57.79748,2.13949),(-1.16006,57.78548,2.05757),(-1.44741,57.9244,2.28694),(-1.31123,57.88553,2.31053),(-1.17799,57.82675,2.20006),(-1.19134,57.84852,2.27751),(-1.20365,57.94098,2.45628),(-1.0653,57.96024,2.44849),(-1.08574,57.88408,2.35588),(-1.12622,57.86353,2.35449),(-1.15509,58.10396,2.67984),(-.99305,58.13246,2.76999),(-.98807,58.0488,2.70143),(-.87816,57.99236,2.54132),(-.95139,57.96757,2.56475),(-.81175,57.88831,2.08848),(-.89293,57.83225,2.10239),(-.86312,57.47074,1.53229),(-1.051,57.51823,1.62351),(-.57149,57.5254,1.7579),(-.66723,57.64068,1.83762),(-.57352,57.64729,1.88675),(-.62004,57.49912,1.66726),(-.73268,57.59722,1.761),(-.49548,57.58031,1.89894),(-.59377,57.82593,2.28248),(-.7086,57.86203,2.22805),(-.72672,57.89388,2.37833),(-.6875,57.9416,2.51),(-.80846,57.97131,2.35166),(-.61551,57.88306,2.43741),(-.58848,57.93002,2.59233),(-.5685,57.89883,2.46343),(-.65622,58.01306,2.71644),(-.42293,57.77881,2.34232),(-.29029,57.82855,2.54995),(-.17493,57.75138,2.45797),(-.09681,57.66618,2.37552),(-.27816,57.68028,2.31873),(-.19405,57.87613,2.66507),(-.11099,57.96454,2.7289),(-1.50101,57.60333,2.32841),(-1.53366,57.55772,2.17306),(-1.53266,57.67555,2.10371),(-1.49531,57.61378,2.10527),(-1.56187,57.58136,2.45145),(-1.61589,57.63756,2.42241),(-1.398,57.73215,2.26629),(-.98588,57.88769,2.87894),(-1.2819,57.91969,2.76409),(-1.27449,57.77525,2.75875),(-1.45152,57.56617,2.53486),(-1.44549,57.64625,2.47702),(-1.33214,57.7126,2.59656),(-1.20939,57.77964,2.19847),(-1.19959,57.70507,2.05789),(-.96322,57.73911,2.03449),(-.97566,57.83756,2.73126),(-.75927,57.88487,2.7645),(-.8049,57.5515,1.7153),(-.94888,57.55018,1.75156),(-.78837,57.91712,2.94687),(-1.00754,57.99944,2.91504),(-.41605,57.71198,2.80189),(-.41684,57.72178,2.65699),(-.38011,57.60996,2.60373),(-.37499,57.58954,2.42647),(-.45055,57.64142,2.20512),(-.64648,57.50157,1.71893),(-.47689,57.45701,1.72138),(-.33093,57.67419,2.44016),(-.09799,57.77934,2.90424),(0,57.9329,2.85226),(-.30044,57.45413,2.63087),(-.3458,57.35411,2.48348),(-1.56718,58.03481,2.47468),(-1.48226,57.98814,2.6064),(-1.48673,58.13454,2.59937),(-1.62279,57.96348,2.28105),(-1.64769,57.84665,2.08685),(-1.64177,57.76166,1.98435),(-1.15318,57.54604,1.79732),(-1.46008,60.16047,.89969),(-1.47314,60.14763,.90844),(-1.25002,57.56872,1.45629),(-1.83279,58.11156,1.37572),(-1.81361,58.0773,1.36474),(-1.96628,58.66613,1.38888),(-1.91324,58.78315,1.64142),(-1.80861,58.78089,1.98376),(-1.88746,58.70305,1.74157),(-1.86169,58.62295,1.84112),(-1.25109,58.39408,2.77234),(-1.24779,58.62984,2.79646),(-1.31388,58.43676,2.71395),(-1.22205,58.916,2.82494),(-1.05296,58.78639,2.93208),(-1.05262,59.07273,2.90774),(-.78591,59.18311,2.99152),(-.77917,59.00653,3.03222),(-1.15621,60.33798,1.14985),(-1.10437,60.3668,1.1591),(-1.16951,60.37183,1.00742),(0,58.4365,3.08687),(-.15791,58.18691,3.10883),(0,58.25076,2.64255),(-1.15631,60.26052,1.40971),(-.77961,58.29703,3.02981),(-1.02911,58.53055,2.93594),(-1.01233,58.30587,2.93098),(-1.01924,58.13908,2.95117),(-1.27847,58.06539,2.7635),(-1.75019,59.57902,1.4307),(-1.78701,59.51239,1.40203),(-1.72934,59.42111,1.71845),(-1.80422,59.06731,1.8546),(-1.87559,59.03164,1.65318),(-1.86072,58.95428,1.77208),(-1.68998,58.63089,2.29497),(-1.72095,58.54707,2.21683),(-1.93917,58.86234,1.49633),(-1.92738,58.82634,1.56239),(-1.6307,58.28554,2.39089),(-1.70155,58.17061,2.22231),(-1.95693,58.38218,1.37372),(-1.701,57.96442,1.29934),(-.51408,60.72473,.55676),(-1.77117,59.72178,.95991),(-1.42708,57.5975,1.7525),(-1.44782,57.56559,1.95589),(-1.47858,57.63098,1.91276),(-1.51212,57.82762,2.60203),(-1.42235,57.9477,2.66493),(-1.36785,57.88772,2.70582),(-1.50229,57.5107,2.46611),(-.32718,57.40296,1.72784),(-.32954,57.50783,2.71262),(-.34095,57.48083,2.52314),(-.22229,57.44751,2.86318),(-.23281,57.52519,2.80099),(-.09268,57.86717,2.73196),(0,57.8106,2.61223),(-.32226,57.65984,2.8989),(-.23924,57.45193,2.88122),(-.60175,57.77199,2.22226),(-.6791,57.87558,2.7553),(-.77119,57.87412,2.82737),(-.68619,57.88149,2.70151),(-.75224,57.88891,2.69388),(-.74518,57.88917,2.4956),(-1.28324,57.79939,2.50139),(-1.12881,57.84261,2.3551),(-1.21377,57.82861,2.55699),(-1.40422,57.73084,2.70059),(-1.55954,57.71743,2.55387),(-1.36917,57.65398,2.08003),(-1.59739,57.58491,2.52314),(-1.60699,57.63614,2.49474),(-1.59564,57.59005,2.5477),(-.25266,57.71142,3.00561),(-.07321,57.88398,3.07696),(-.20638,58.09589,3.12614),(-.44559,57.31911,1.40662),(-.36494,57.51614,1.90455),(-.47842,57.47622,1.74295),(-.79269,58.02465,2.50763),(-.7617,58.03511,2.68494),(-.61979,57.7569,2.11864),(-.52542,57.45438,1.65271),(-.74348,57.43464,1.49686),(-.77366,57.38768,1.38763),(-.983,57.57938,1.77726),(-.84441,57.58935,1.71309),(-1.00543,57.82579,2.18176),(-.92385,57.8541,2.19414),(-1.04135,57.98259,2.59632),(-1.10361,57.97175,2.54553),(-.97548,57.76809,2.05131),(-1.07148,57.82114,2.12293),(-1.54094,57.79857,1.3102),(-1.66641,57.88928,1.66891),(-1.55028,57.78194,1.54407),(-1.59437,57.9622,2.09058),(-1.67163,58.18885,2.06837),(-1.62253,58.2304,2.13281),(-.48198,58.10921,2.8944),(-.50195,58.42716,2.94605),(-1.59644,58.58866,2.19616),(-1.57208,58.26481,2.2434),(-.02797,58.75811,2.86653),(-1.13249,58.75413,2.7429),(-1.01632,59.0215,2.74478),(-1.38776,58.7404,2.51103),(-1.43073,58.7731,2.46484),(-1.49871,58.65515,2.38212),(-1.70087,58.88466,1.90463),(-1.91844,58.55877,1.18945),(-1.84993,58.6587,1.38897),(-1.84667,58.54883,1.42001),(-1.62345,58.902,2.03668),(-1.85202,58.7649,1.3601),(-.82884,59.45808,2.59811),(-1.06275,59.40035,2.49646),(-.87184,59.80835,2.16998),(-.58986,59.93678,2.16245),(-1.58672,59.21507,1.87769),(-1.37657,59.21909,2.22912),(-1.56076,59.57348,1.46822),(-1.53134,59.6534,1.42702),(0,60.56205,.76722),(-.0736,60.62713,.69411),(-.04939,60.63355,.67396),(-.01459,60.69548,.48385),(-.0693,60.6564,.59171),(-1.69606,59.65559,.97852),(-.20491,57.28491,1.56957),(-.49849,57.3085,1.30646),(-1.48565,57.72929,1.29766),(-.95305,57.84294,2.26258),(-.94969,57.88583,2.47092),(-.13697,57.79118,2.58432),(0,57.6549,2.43607),(-1.26912,58.1774,2.76301),(-.41807,57.78197,2.79451),(-.06923,57.60646,2.83912),(-.3387,57.65467,2.44387),(-.34852,57.59064,2.46424),(-1.13746,57.47706,1.5409),(-1.10801,57.46144,1.55044),(-1.66786,59.90837,.89694),(-1.64959,59.8962,1.03447),(-1.65542,59.91683,.91351),(-.83098,57.71324,1.86726),(-.83368,57.75664,1.95764),(-.87293,57.87515,2.198),(-1.75758,59.27888,1.33116),(-.12779,57.90175,2.80458),(-.3221,57.33931,2.35787),(-.32073,57.4596,2.47758),(-.31985,57.48639,2.63591),(0,57.69976,2.8129),(-.00396,57.63494,2.41049),(-.33274,57.74811,2.83874),(-.35029,57.87245,2.79022),(-.29385,57.72197,2.82425),(-.14879,57.76199,2.5939),(-.28805,57.71556,2.46018),(-.27885,57.7154,2.46028),(-.32041,57.67876,2.47073),(-.42925,57.8875,2.71309),(-1.4555,57.49442,1.99719),(-.31,57.48931,2.01762),(-.30934,57.48996,1.99927),(-.31772,57.49532,2.001),(-.3206,57.49567,2.00074),(-.31836,57.49414,1.99612),(-.30756,57.45747,1.95785),(-.30385,57.45237,1.96428),(-.31054,57.48716,2.01879),(-.57204,57.82027,2.28619),(-.51924,57.82235,2.36381),(-.27255,57.27919,1.60731),(-.57309,59.7218,2.46006),(-.87002,59.79556,2.1953),(-1.2442,59.36014,2.29434),(-1.02884,59.11406,2.71169),(-1.25353,59.35939,2.28229),(-1.74895,58.31228,1.95008),(-1.59129,57.95627,2.09888),(-1.59395,57.94798,2.07814),(-1.68842,58.17401,2.04664),(-1.6768,58.03773,1.99606),(-1.40304,58.72588,2.50245),(-1.43454,58.75308,2.47165),(-1.37767,58.34474,2.54625),(-1.30965,58.08844,2.56144),(-1.38755,58.22249,2.51846),(-.96074,60.08438,1.52642),(-.92245,59.98599,1.79062),(-1.15898,59.84935,1.73814),(-1.47003,59.71309,1.44513),(-1.61041,58.58041,2.16957),(-.81958,60.37859,.65201),(-1.31407,57.65435,1.30903),(-1.12721,60.42473,.90215),(-1.76251,59.54983,.94357),(-1.78438,59.55662,1.04089),(-1.71031,59.65136,.97344),(-1.94009,58.98853,1.0642),(-1.90756,58.66023,1.13888),(-1.92642,58.72045,1.07813),(-1.97336,58.77681,1.0158),(-1.95775,58.78736,1.04815),(-1.67221,57.86831,1.37718),(-1.7075,57.89163,1.41671),(-1.6925,57.8898,1.36451),(-1.68636,57.87136,1.3555),(-1.65238,57.85151,1.34978),(-1.93518,58.35692,1.40126),(-1.92276,58.31985,1.39437),(-2.00474,58.94306,1.0733),(-1.99951,58.8205,1.11759),(-1.94859,58.89112,1.4434),(-1.96468,58.85672,1.37763),(-1.83218,59.2394,1.59841),(-1.86132,59.1742,1.56628),(-1.89047,59.109,1.53415),(-1.9122,59.04357,1.49064),(-1.95826,59.26749,1.14153),(-1.96893,59.28226,1.0547),(-1.98007,59.26734,1.03608),(-1.94058,59.243,1.28554),(-1.946,59.20083,1.27834),(-1.80285,59.68888,.9256),(-1.9806,59.20477,1.12611),(-1.92036,59.35591,1.13965),(-1.93931,59.3117,1.14059),(-1.91394,59.28838,1.30525),(-1.86065,59.37914,1.34469),(-1.88729,59.33376,1.32497),(-1.79562,59.61183,1.06374),(-1.80334,59.63067,1.01402),(-1.89892,59.49457,1.00147),(-1.86539,59.4827,1.15018),(-1.88246,59.44432,1.13778),(-1.79708,59.63621,1.19978),(-1.78848,59.64616,1.16551),(-1.60277,59.89501,1.2934),(-1.61136,59.97043,1.05507),(-1.71993,59.81717,.93063),(-1.7388,59.81207,.89123),(-1.51531,60.09235,.93528),(-1.52975,60.09399,.92918),(-1.5342,59.96459,1.31771),(-1.59018,59.79255,1.52324),(-1.39677,60.22092,.8725),(-1.40583,60.20914,.90308),(-1.38055,60.2248,.90817),(-1.39463,60.22546,.85023),(-1.22943,60.33496,.92056),(-1.20475,60.36684,.90746),(-1.17645,60.38236,.73998),(-1.20127,60.37022,.74603),(-.97332,60.53262,.605),(-.94725,60.51332,.92863),(-.88418,60.54437,.93791),(-.87888,60.40712,1.4661),(-.8878,60.4872,1.19774),(-.97727,60.43746,1.18178),(-.63271,60.69901,.50995),(-.60062,60.70888,.51243),(-.45657,60.6962,.97525),(-.46813,60.63813,1.24433),(-.38752,60.77372,.59295),(-.40397,60.76735,.62099),(-.28728,60.80324,.52026),(-.24432,60.81323,.56034),(-1.67588,59.80408,1.2599),(-1.85628,58.20376,1.55008),(-1.84089,58.15303,1.61044),(-1.83382,58.25946,1.86265),(-1.65828,57.8848,1.32498),(-1.67045,57.8916,1.35623),(-1.81196,58.13852,1.35845),(-1.86717,58.23809,1.26987),(-1.89552,58.32044,1.38935),(-1.8272,58.15992,1.37018),(-1.92639,58.65098,1.22171),(-1.92611,58.65318,1.19867),(-1.92621,58.65922,1.19226),(-1.95462,58.87036,1.07272),(-1.87273,59.30324,1.00244),(-.3244,60.53208,.82607),(-.39247,60.52609,.83784),(-.38984,60.5726,.64233),(-.41289,60.54875,.59314),(-.30348,60.61608,.67199),(-.18826,60.54407,.80253),(-.25633,60.53807,.8143),(-.36634,60.58429,.63651),(-.86537,60.34803,.72998),(-.84226,60.36657,.65795),(-.78053,60.40646,.72249),(-.45629,60.49845,.84954),(-.48031,60.50487,.75165),(-.9981,60.29856,.6909),(-.97709,60.24743,.97801),(-1.0644,60.24778,.839),(-1.02752,60.21922,.99551),(-1.08865,60.22995,.86728),(-1.18252,60.16128,.89011),(-1.18738,60.16159,.83905),(-1.16218,60.17868,.85852),(-1.28408,60.08578,.83468),(-1.18231,60.119,1.03654),(-1.22255,60.13096,.89131),(-1.19866,60.14905,.89059),(-1.54139,59.84996,.85823),(-1.52622,59.87242,.89636),(-1.55615,59.84416,.8985),(-1.56959,59.83124,.91332),(-1.50315,59.83919,1.12778),(-1.52028,59.81389,1.13606),(-1.61648,59.66937,1.18196),(-1.81731,59.4476,.96193),(-1.7524,59.56547,.94292),(-1.67524,59.55359,1.2027),(-1.74799,59.39502,1.22468),(-1.82512,59.42699,.96638),(-1.78065,59.2952,1.22755),(-1.86517,59.32126,.98663),(-1.84224,59.26244,1.117),(-1.9348,59.02246,1.02078),(-1.94672,58.88767,1.0447),(-1.95223,58.83752,1.04642),(-1.92241,58.61514,1.16235),(-1.77889,58.12785,1.50934),(-1.78957,58.25413,1.65222),(-1.80926,58.64912,1.73159),(-.26384,60.45932,1.19686),(-.31551,60.34313,1.58319),(-.35611,60.44565,1.21238),(-.53724,60.37707,1.22684),(-1.15505,60.03356,1.32211),(-1.2345,60.08299,1.04831),(-1.22654,59.97962,1.34186),(-1.32276,60.01235,1.07136),(-1.30472,60.02966,1.06571),(-1.4578,59.88272,1.11359),(-1.74865,59.29786,1.3367),(-1.57459,57.83311,1.41377),(-1.39139,57.71106,1.37431),(-.28009,57.16018,1.4713),(-.28008,57.14981,1.49472),(-.32761,57.17135,1.47931),(-.55025,57.32448,1.29003),(-1.12301,57.56724,1.29369),(-.5055,57.27665,1.3206),(-.41293,57.28534,1.29607),(-.17361,57.20027,1.50466),(-.81871,58.02745,2.51347),(-.95744,58.04301,2.70226),(-1.0334,57.9615,2.44022),(-1.01126,57.97599,2.58657),(-.78678,57.88606,2.08189),(-.4247,57.29751,1.33588),(.01688,58.25076,2.64263),(1.05262,59.07273,2.90774),(.78591,59.18311,2.99152),(.77917,59.00653,3.03222),(1.05296,58.78639,2.93208),(1.25109,58.39408,2.77234),(1.31388,58.43676,2.71395),(1.89295,59.47567,1.03828),(1.89062,59.48363,1.03359),(1.5298,58.4185,2.5089),(1.58241,58.36012,2.48059),(1.83382,58.25946,1.86265),(1.75924,57.90292,1.53009),(1.90599,58.37847,1.36202),(1.91128,58.43498,1.18207),(1.94192,58.51019,1.36433),(1.94945,58.58558,1.45345),(.85969,60.59616,.56438),(.90353,60.5767,.6777),(.90038,60.58063,.55114),(1.76739,59.73172,.95474),(1.77412,59.70605,1.044),(1.47858,57.63098,1.91276),(1.42708,57.5975,1.7525),(.34095,57.48083,2.53427),(.32546,57.33981,2.37063),(.31536,57.35048,2.61841),(.30044,57.45413,2.6419),(.23281,57.52519,2.81008),(.3387,57.65467,2.45249),(.62298,57.6662,1.99501),(.47689,57.45701,1.72407),(.37453,57.54261,2.19879),(.43003,57.70543,2.4909),(.36134,57.62736,2.79436),(.42235,57.71451,2.66852),(.41634,57.71028,2.82816),(.7797,58.02278,3.03836),(.8049,57.5515,1.71585),(.80836,57.42999,1.51544),(.97317,57.82736,2.74572),(1.12881,57.84261,2.35832),(1.28143,57.79939,2.50487),(1.40041,57.73084,2.70531),(1.36782,57.88772,2.70833),(1.53249,57.64555,2.59847),(1.56077,57.71743,2.55472),(.46893,58.01998,3.1216),(.40658,58.19237,3.13504),(1.22577,57.71782,2.73026),(1.37244,57.74303,2.36242),(1.36354,57.48378,1.84352),(1.25267,57.51809,1.82154),(1.6054,57.63614,2.49533),(.31934,57.86563,3.084),(0,57.62582,2.39977),(.25081,58.00415,2.84517),(.49727,57.32742,1.36174),(.47842,57.47622,1.74585),(.37439,57.43004,1.71823),(.61979,57.7569,2.12464),(.7086,57.86203,2.23378),(.52542,57.45438,1.6541),(.74348,57.43464,1.49686),(.88189,57.4475,1.41622),(.66723,57.64068,1.83978),(.62004,57.49912,1.66824),(.89293,57.83225,2.10471),(.97548,57.76809,2.05305),(1.12618,57.84547,2.23301),(1.1043,57.85253,2.32674),(1.36462,57.98993,2.44534),(1.48284,57.86411,2.11863),(1.19134,57.84852,2.27889),(1.61852,57.89614,1.87668),(1.57208,58.26481,2.2434),(1.62253,58.2304,2.13281),(1.59437,57.9622,2.09058),(1.67163,58.18885,2.06837),(1.4029,58.07082,2.46156),(1.38755,58.22249,2.51846),(.25106,58.38717,2.95163),(.48198,58.10921,2.90195),(1.80014,58.22294,1.49252),(1.43073,58.7731,2.46484),(1.48855,58.71985,2.39317),(1.59644,58.58866,2.19616),(1.49871,58.65515,2.38212),(1.74127,58.5119,1.9226),(1.91696,58.5193,1.18127),(1.84993,58.6587,1.38897),(1.91844,58.55877,1.18945),(1.85202,58.7649,1.3601),(.5515,59.49257,2.65522),(.25056,59.51413,2.65527),(.24912,59.83421,2.46986),(.82884,59.45808,2.59811),(.85499,59.65052,2.43785),(.56401,59.73332,2.45345),(1.80985,59.19114,1.24202),(1.48391,59.41423,1.87856),(1.32477,59.57985,1.96315),(1.3623,59.66688,1.78342),(1.37688,59.9604,1.08828),(1.29854,59.91128,1.36284),(1.35884,59.97771,1.08264),(.06322,60.621,.55912),(.0693,60.6564,.59171),(.04939,60.63355,.67396),(.0736,60.62713,.69411),(.17447,57.46472,1.90391),(.23968,57.38073,1.69055),(1.57039,57.838,1.3512),(.35675,57.29765,1.47459),(.20491,57.28491,1.57062),(1.5135,57.77566,1.32772),(.95305,57.84294,2.26679),(.94969,57.88583,2.47807),(.13697,57.79118,2.58787),(1.27847,58.06539,2.76482),(1.26912,58.1774,2.76325),(.30041,57.69542,2.86165),(.34852,57.59064,2.47392),(1.58486,57.73749,2.44763),(1.59753,57.58487,2.52447),(1.54023,57.51635,2.45511),(1.67153,59.90012,.9027),(1.66786,59.90837,.89694),(1.60081,59.99715,1.00799),(1.55795,60.02501,1.07229),(.32144,57.77193,2.54554),(.28805,57.71556,2.46723),(.30351,57.53417,2.16207),(.29816,57.53838,2.15798),(.29452,57.4939,2.05718),(.31979,57.37195,2.24231),(.25873,57.44738,2.90787),(.33027,57.49081,2.50072),(.27332,57.52434,2.29445),(.23179,57.85102,2.69499),(.33062,57.65817,2.48473),(.11776,57.54722,2.23117),(1.60737,57.656,2.51017),(1.59229,57.59002,2.54914),(.33643,57.47441,1.99357),(.33515,57.47688,1.97768),(.30554,57.44829,1.98713),(.30385,57.45237,1.96921),(.30972,57.47401,1.99026),(.30897,57.48567,2.02027),(.3282,57.48615,1.99363),(.32996,57.48396,2.00642),(.32226,57.4977,2.02369),(.31428,57.45282,1.999),(.32055,57.49618,2.02677),(.31034,57.48893,1.99943),(.3084,57.48633,2.00192),(.32708,57.48495,2.01668),(.32885,57.47419,1.96643),(.30054,57.44922,1.96583),(.30456,57.4464,1.98799),(.81396,57.81294,2.01595),(.63447,57.7186,2.01302),(.29906,57.45024,1.95773),(1.5122,59.38276,1.86362),(1.50526,59.37691,1.88372),(1.71468,59.17053,1.5717),(1.71319,59.15537,1.59399),(1.30965,58.08844,2.56154),(1.37929,58.00409,2.44765),(1.01888,59.76339,2.09333),(1.50151,58.81025,2.30533),(1.48933,58.81127,2.33048),(1.49121,58.82851,2.31419),(1.60289,57.87962,1.88478),(1.78533,58.86236,1.6833),(1.37767,58.34474,2.54625),(1.2584,59.34577,2.28783),(1.75758,59.27888,1.33116),(.91214,59.93915,1.89315),(.62792,60.12687,1.82347),(.92245,59.98599,1.79062),(1.62973,58.8919,2.03217),(1.61406,58.74584,2.10469),(1.72468,58.02844,1.76041),(.77366,57.38768,1.38763),(.62422,57.3409,1.36393),(.83576,60.60251,.68621),(.14388,60.82908,.55767),(.12066,60.82214,.54994),(.06973,60.846,.55787),(.06911,60.85102,.52729),(1.71112,59.63775,.93905),(1.63607,59.63077,1.18887),(1.9237,59.1172,1.111),(1.91879,59.15201,1.10295),(1.94254,58.95881,1.03388),(1.99075,58.70762,1.11285),(1.71014,57.9041,1.35146),(1.72228,57.9297,1.34852),(1.74279,57.91495,1.45624),(1.89735,58.22793,1.38784),(1.90801,58.26955,1.37646),(1.92276,58.31985,1.39437),(1.98031,58.80603,1.3048),(1.98139,58.77844,1.31408),(1.98281,58.65082,1.16209),(1.96663,58.64159,1.22895),(1.99612,58.86965,1.09221),(1.9747,58.94908,1.25626),(1.99881,59.02783,1.12543),(1.97284,58.65455,1.19949),(1.97951,58.82647,1.2979),(1.96468,58.85672,1.37763),(1.9122,59.04357,1.49064),(1.87559,59.03164,1.65318),(1.93393,58.97814,1.44713),(1.96438,58.95133,1.323),(1.97826,58.65492,1.18286),(1.95142,59.15865,1.27115),(1.93233,59.4032,1.00506),(1.91615,59.41981,1.03845),(1.92199,59.37851,1.07944),(1.90141,59.40011,1.13872),(1.77735,59.71431,.95483),(1.74313,59.77709,.94465),(1.74395,59.79945,.90122),(1.74293,59.76083,1.02988),(1.7672,59.7182,1.04087),(1.76539,59.75142,.92976),(1.75367,59.73141,1.1175),(1.59026,60.02387,.96092),(1.49241,60.13338,.88132),(1.50795,60.11716,.89967),(1.39707,60.10375,1.36633),(1.3767,60.00363,1.61482),(1.46563,60.03417,1.34202),(1.39771,60.18876,1.12397),(1.43869,60.14688,1.11075),(1.2082,60.35404,.78337),(1.13137,60.40163,.77762),(1.11704,60.4208,.72943),(.95175,60.54377,.68745),(.94883,60.54208,.67279),(.93117,60.55712,.66492),(.98612,60.52031,.6944),(.82084,60.60496,.62452),(.7588,60.61982,.63327),(.75034,60.59189,.94959),(.63109,60.68044,.7119),(.57472,60.71168,.53248),(.4016,60.75361,.73203),(.40674,60.77274,.51278),(.34709,60.7903,.5167),(1.26757,60.26917,1.13791),(1.86169,58.62295,1.84112),(1.91234,58.48821,1.5896),(1.85309,58.22268,1.37774),(1.84132,58.17732,1.37732),(1.90756,58.66023,1.13888),(1.90775,58.65789,1.13616),(1.90927,58.70931,1.10121),(1.94147,58.93872,1.04888),(1.9412,58.93782,1.04298),(1.88478,59.27344,1.02227),(1.85896,59.35344,1.05673),(1.85204,59.35396,.98305),(1.78696,59.49607,.95392),(1.78237,59.52191,.94557),(1.73219,59.60057,.93565),(1.73312,59.60996,.96384),(1.74216,59.60602,1.0272),(.16006,60.61978,.64259),(.18826,60.54407,.80253),(.41289,60.54875,.59314),(.4087,60.5441,.64338),(.47163,60.51642,.67503),(.77537,60.36025,.908),(.82236,60.38097,.72652),(.80086,60.39743,.72479),(.93146,60.3204,.66974),(.889,60.33572,.73399),(.99484,60.29887,.75886),(1.26257,60.10063,.89252),(1.28958,60.08126,.86015),(1.43975,59.95219,.92292),(1.39491,59.94308,1.09393),(1.4144,59.97404,.92108),(1.42368,59.96596,.91272),(1.43278,59.95818,.91999),(1.65224,59.70544,.90479),(1.66518,59.69548,.95733),(1.64522,59.735,.92983),(1.55453,59.76328,1.15263),(1.59318,59.79405,.89803),(1.62491,59.76183,.92823),(1.67791,59.67333,.95),(1.67139,59.68506,.95543),(1.6059,59.68736,1.17747),(1.69184,59.66231,.97445),(1.69482,59.51499,1.20962),(1.7987,59.47873,.95062),(1.80651,59.47388,.95871),(1.74636,59.5752,.94239),(1.65565,59.59218,1.19579),(1.83732,59.40419,1.00764),(1.84208,59.38386,.97475),(1.85177,58.73621,1.36719),(1.82139,58.31804,1.47524),(.0793,60.48666,1.16583),(.71837,60.30848,1.2413),(.81627,60.2528,1.25507),(1.08355,60.0875,1.30236),(.97195,60.08257,1.51499),(1.01206,60.14144,1.28261),(1.4223,59.75534,1.45924),(1.47003,59.71309,1.44513),(1.57758,59.58129,1.41213),(1.64586,59.61148,1.19233),(1.6147,59.42695,1.54376),(1.62383,59.50917,1.39723),(1.4908,57.76801,1.33489),(1.26394,57.5761,1.72428),(1.37349,57.67129,1.52694),(1.2851,57.61597,1.51819),(.16659,57.50478,2.10686),(.15535,57.47786,2.02201),(.30759,57.39981,2.12064),(.29977,57.47693,2.07077),(1.8945,59.2582,1.00563),(1.91046,59.19107,1.10893),(1.90932,59.18096,1.01055),(.90388,57.43521,1.32282),(1.09171,57.56132,1.35055),(1.31289,57.63586,1.35818),(1.2985,57.64574,1.37157),(1.56814,57.8235,1.39657),(.50853,57.28878,1.37224),(.35104,57.22319,1.49921),(.78496,57.3533,1.31854),(.79988,57.33812,1.28274),(.91833,57.40713,1.26295),(.80936,57.33199,1.25199),(.54283,57.29775,1.35389),(.66298,57.28475,1.27047),(.81717,57.33546,1.30873),(.16066,57.15615,1.45882),(.62661,57.41242,1.473),(1.05721,57.88519,2.34392),(.81904,57.92215,2.18704),(.79419,57.92361,2.19021),(.17653,57.20231,1.49882),(.4985,57.36042,1.54306),(.66195,57.30061,1.32538),(.6497,57.39658,1.51768),(.94345,57.41307,1.29563),(-.12687,57.5896,2.89987),(-.12123,57.56637,2.8984),(-.14394,57.56471,2.88635),(.04552,57.58895,2.92561),(-.04208,57.44786,2.90482),(-.08172,57.63311,2.89012),(.09539,57.62523,2.88089),(.11408,57.5903,2.88898),(.12123,57.56637,2.90327),(.15693,57.52532,2.93448),(.14394,57.56471,2.8921),(.1225,57.57753,2.89793),(.0882,57.56133,2.89964),(.08172,57.63311,2.8932),(.01737,57.63712,2.87146),(.00854,57.62301,2.8729),(.06596,57.64224,2.85462),(-.03605,57.44786,2.90497),(-.00404,57.624,2.87293),(-.01951,57.4536,2.91394),(-.00484,57.62684,2.86593),(-.13157,57.55073,2.97781),(-.60143,57.83126,2.8167),(-.61623,57.86197,2.74621),(-.60117,57.82929,2.50625),(-.56761,57.81534,2.50897),(-.66325,57.82572,2.83839),(-.6553,57.8372,2.86165),(-.51627,57.77798,2.82461),(-.77195,57.87058,2.83131),(-.65791,57.84368,2.82645),(-.79394,58.18973,3.0495),(-.51531,57.78706,2.81033),(-.57912,57.79671,2.83219),(-.58872,57.80068,2.82699),(-.65239,57.85345,2.85297),(-.60071,57.84658,2.84801),(-.31934,57.86563,3.07472),(.7603,57.88122,2.79052),(.98273,57.86648,2.865),(.75018,57.88584,2.88819),(-.68831,58.022,3.02732),(-.72694,57.95854,2.98705),(.79306,57.86248,2.89026),(-.65326,57.85002,2.88433),(-.58286,57.80427,2.856),(-.61254,57.85985,2.71037),(-.52782,57.82013,2.71672),(-.00609,57.62774,2.87164),(.06476,57.63446,2.85322),(.01754,57.63541,2.87367),(.04942,57.60525,2.90735),(.16051,57.56395,2.90979),(-.07084,57.64732,2.86548),(-.00126,57.59536,2.94136),(-.17511,57.52314,2.94907),(.27788,57.18768,1.52879),(.30818,57.20941,1.52541),(.99305,58.13246,2.77367),(.96281,58.13702,2.7852),(.44682,57.2359,1.37297),(.5055,57.27665,1.3206),(1.48254,57.77083,1.39963),(.08636,57.62662,2.36371),(1.52058,59.52669,1.60338),(1.6077,59.4248,1.56489),(1.72246,59.34426,1.35191),(1.77132,59.32372,1.22673),(1.76014,59.35788,1.22575),(1.53134,59.6534,1.42702),(1.61648,59.66937,1.18196),(1.4846,59.85699,1.12198),(1.02752,60.21922,.99551),(.91416,60.19712,1.26884),(.8258,60.33205,.92551),(.17157,60.47299,1.18135),(.08153,60.55347,.78407),(1.92027,58.72504,1.09676),(1.86471,59.33426,1.04258),(1.74831,59.5964,1.02872),(1.74803,59.58502,.97879),(1.67016,59.68711,.95791),(1.64917,59.71774,.89584),(1.51315,59.8751,.82128),(1.40731,59.98009,.91216),(1.19866,60.14905,.89059),(1.27216,60.09594,.81974),(1.28408,60.08578,.83468),(.71155,60.38789,.89631),(.65822,60.45025,.66833),(.67336,60.44386,.69788),(.61716,60.46139,.6746),(.2782,60.63609,.57449),(.31258,60.61734,.57611),(.31779,60.60748,.68512),(1.79811,59.53535,1.04513),(1.92622,58.63117,1.25968),(1.31681,60.156,1.38079),(.30128,60.72073,.97045),(.33401,60.76515,.73184),(.24783,60.77985,.7316),(.16165,60.79456,.73135),(.47123,60.74065,.55053),(.57713,60.70098,.71868),(.63249,60.65348,.66072),(.60345,60.64405,.96242),(.77328,60.6263,.69405),(.93222,60.55711,.6835),(1.15519,60.38678,.77928),(1.40312,60.20235,.97671),(1.38932,60.20637,1.01848),(1.33908,60.22498,1.13025),(1.44153,60.17924,.8827),(1.43584,60.18472,.87978),(1.50937,60.11323,.9223),(1.90586,59.49834,.95767),(1.90069,59.50535,.94587),(1.90809,59.46364,1.00171),(1.89758,59.46858,1.03222),(1.90403,59.45004,1.03678),(1.95567,58.91271,1.40362),(1.9737,58.80072,1.35154),(1.98935,58.80279,1.09494),(1.9965,58.90617,1.09929),(1.98503,58.65942,1.14904),(1.68636,57.87136,1.3555),(1.66491,57.8747,1.3603),(1.90811,58.47039,1.35061),(.01399,60.85028,.46456),(1.68227,59.88824,.89683),(1.66826,59.8617,1.04989),(1.70101,59.84504,.92813),(.79936,59.16303,2.79776),(.80554,59.45415,2.61202),(.92127,59.13431,2.75613),(1.4982,57.86977,2.10457),(1.4975,57.87971,2.12479),(1.68085,58.20557,2.05448),(1.0339,59.02467,2.73373),(1.01632,59.0215,2.74478),(1.01993,59.05519,2.7341),(.73682,57.71485,1.91983),(.3118,57.47861,1.98515),(1.5698,57.58117,2.29678),(1.5603,57.57573,2.32746),(.25348,57.76571,2.53777),(.31055,57.44931,2.19689),(.29917,57.74216,2.8655),(.3399,57.70326,2.48882),(1.42235,57.9477,2.66567),(1.48226,57.98814,2.60642),(.83368,57.75664,1.95928),(1.65542,59.91683,.91351),(1.56076,59.57348,1.46822),(.58986,59.93678,2.16245),(1.84667,58.54883,1.42001),(1.13249,58.75413,2.7429),(1.0147,58.77795,2.79552),(.50195,58.42716,2.94762),(1.66641,57.88928,1.66891),(1.44741,57.9244,2.28694),(1.07148,57.82114,2.1241),(1.10361,57.97175,2.54906),(.96292,57.94639,2.3704),(.51312,57.70664,2.12141),(.59377,57.82593,2.28995),(.49982,57.86918,2.46795),(.25266,57.71142,3.01451),(.9762,57.81804,2.805),(.94888,57.55018,1.75189),(.38011,57.60996,2.61523),(.64648,57.50157,1.72059),(1.48673,58.13454,2.59937),(1.15318,57.54604,1.79734),(1.47314,60.14763,.90844),(1.46008,60.16047,.89969),(1.94584,58.54944,1.35665),(1.83279,58.11156,1.37572),(1.88746,58.70305,1.74157),(.15791,58.18691,3.11155),(0,60.76978,.96086),(.146,60.74525,.96565),(0,60.70563,1.23778),(-.71675,58.1647,2.82997),(-.74144,58.42936,2.86288),(-.35122,57.1902,1.44413),(-.43855,57.26035,1.36251),(-1.46189,57.72662,1.53558),(-1.55391,59.57195,1.48483),(-1.6077,59.4248,1.56489),(-1.69626,59.39065,1.36712),(-1.48015,59.72271,1.41792),(-1.57165,59.73797,1.16091),(-1.29854,59.91128,1.36284),(-1.28668,60.04698,1.06007),(-.44667,60.41136,1.21961),(-.64774,60.41553,.88462),(-1.84263,58.41314,1.45747),(-1.67964,57.92461,1.31221),(-1.92027,58.72504,1.09676),(-1.90927,58.70931,1.10121),(-1.76014,59.35788,1.22575),(-1.84867,59.36594,.98065),(-1.82026,59.44166,.96357),(-1.72141,59.6225,.9329),(-1.3415,60.03698,.88288),(-1.33318,60.04369,.87861),(-1.36972,60.01248,.90644),(-1.36153,60.01951,.90179),(-1.4921,59.89802,.80565),(-1.31266,60.06163,.89313),(-1.04015,60.2656,.81073),(-1.14249,60.1916,.8889),(-.5031,60.50258,.69085),(-.52422,60.49426,.70856),(-.46533,60.52695,.57539),(-.31779,60.60748,.68512),(-.08153,60.55347,.78407),(-1.77174,59.57544,1.07883),(-1.76018,59.59265,1.07176),(-1.82083,59.4432,.97197),(-1.82012,59.45163,1.00222),(-1.9385,59.01836,1.10475),(-1.94023,58.82048,1.09929),(-1.92677,58.65911,1.2151),(-1.92664,58.62674,1.28332),(-1.91742,58.55513,1.34934),(-1.86836,58.26673,1.36712),(-1.67423,57.89196,1.35202),(-1.66491,57.8747,1.3603),(-1.82551,58.10231,1.6706),(-1.76096,57.89979,1.84481),(-1.82383,59.44577,1.37336),(-.40674,60.77274,.51278),(-.39175,60.75778,.58224),(-.57364,60.68744,.68754),(-.90353,60.5767,.6777),(-.93117,60.55712,.66492),(-1.08742,60.46117,.64161),(-1.114,60.44659,.61915),(-1.12836,60.42753,.66668),(-1.25822,60.30893,.88392),(-1.40312,60.20235,.97671),(-1.4154,60.20061,.90201),(-1.75852,59.73344,1.03694),(-1.75057,59.76613,.94561),(-1.75752,59.76196,.93534),(-1.749,59.71314,1.22639),(-1.83966,59.52487,1.10132),(-1.84831,59.52108,1.16258),(-1.85678,59.49265,1.1159),(-1.79695,59.61774,1.11883),(-1.8311,59.54098,1.09403),(-1.90614,59.43784,1.0475),(-1.96047,59.31614,1.03432),(-1.96216,59.29835,1.05496),(-1.97176,58.69232,1.36777),(-2.00254,58.99977,1.08784),(-2.00663,58.97086,1.06888),(-1.9763,58.90821,1.27014),(-1.99305,58.72317,1.1072),(-1.97071,58.64547,1.20783),(-1.96934,58.65111,1.22139),(-1.78719,57.97393,1.4623),(-1.75549,57.98665,1.36634),(-1.9454,58.8036,1.08224),(-1.85301,59.36821,1.04709),(-.34709,60.7903,.5167),(-1.4566,57.72636,1.87862),(-1.37144,59.66863,1.76309),(-.98904,59.76738,2.11998),(-1.17313,58.38304,2.72894),(-1.66249,58.02411,2.0101),(-1.599,57.9573,2.08217),(-.56401,59.73332,2.45345),(-.32546,57.33981,2.36032),(-.31055,57.44931,2.18949),(-.51312,57.70664,2.11496),(-.33643,57.47441,1.9881),(-.33545,57.4707,1.99866),(-1.54133,57.56411,2.16949),(-.43715,57.87339,2.74896),(-.38695,57.67605,2.64714),(-.32958,57.4927,2.45974),(-.1575,57.78126,2.5673),(-1.55795,60.02501,1.07229),(-1.67153,59.90012,.9027),(-1.3706,57.52531,1.82492),(-1.51722,57.51774,2.45217),(-.31993,57.50052,2.37629),(-.06322,60.621,.55912),(-.05817,60.63662,.52307),(-.03354,60.65013,.5061),(0,60.69989,.51174),(-1.32477,59.57985,1.96315),(-1.3623,59.66688,1.78342),(-1.07932,59.5175,2.36399),(-.24912,59.83421,2.46986),(-.5515,59.49257,2.65522),(-1.91696,58.5193,1.18127),(-1.74127,58.5119,1.9226),(-1.48855,58.71985,2.39317),(-.72244,57.82138,2.05782),(-.70086,57.82094,2.11016),(-.49982,57.86918,2.4595),(-1.53785,57.64555,2.59628),(-1.37499,57.74303,2.3611),(-1.2238,57.75919,2.65603),(-.96622,57.8765,2.63659),(-.71162,57.87522,2.49792),(-.65107,57.84453,2.82362),(-.62298,57.6662,1.98994),(-1.78413,58.09164,1.35965),(-1.75038,58.87902,2.05827),(-1.3423,58.7308,2.71085),(-.7679,58.50375,3.01009),(-.83576,60.60251,.68621),(-.73533,58.19013,3.06108),(-1.58241,58.36012,2.48059),(-1.5298,58.4185,2.5089),(-1.91128,58.43498,1.18207),(-1.94584,58.54944,1.35665),(-.85969,60.59616,.56438),(-.90038,60.58063,.55114),(-.43003,57.70543,2.48072),(-.38424,57.77007,2.94495),(-.75444,57.83744,2.22613),(-.80836,57.42999,1.51544),(-1.33581,57.65908,2.66308),(-.62473,57.86501,2.37439),(-1.47621,58.21764,2.41429),(-.93901,59.13931,2.74491),(-1.01993,59.05519,2.7341),(-.16659,57.50478,2.10341),(-.18755,57.52207,2.11162),(-1.82669,59.43386,1.00625),(-1.67719,57.94604,1.24977),(-.26624,57.74056,2.4959),(-.3399,57.70326,2.48038),(-.25348,57.76571,2.53148),(-1.0339,59.02467,2.73373),(-1.68085,58.20557,2.05448),(-1.4982,57.86977,2.10457),(-1.4975,57.87971,2.12479),(-1.2584,59.34577,2.28783),(-1.04668,59.10528,2.70392),(-.62792,60.12687,1.82347),(-.91214,59.93915,1.89315),(0,60.84756,.49208),(-.06476,60.84694,.4995),(-1.90811,58.47039,1.35061),(-1.98281,58.65082,1.16209),(-1.96663,58.64159,1.22895),(-1.99881,59.02783,1.12543),(-1.95142,59.15865,1.27115),(-1.91615,59.41981,1.03845),(-1.93233,59.4032,1.00506),(-1.92199,59.37851,1.07944),(-1.90141,59.40011,1.13872),(-1.89062,59.48363,1.03359),(-1.76539,59.75142,.92976),(-1.59026,60.02387,.96092),(-1.43584,60.18472,.87978),(-1.44153,60.17924,.8827),(-1.38932,60.20637,1.01848),(-1.33908,60.22498,1.13025),(-.75034,60.59189,.94959),(-.63249,60.65348,.66072),(-.57472,60.71168,.53248),(-.4016,60.75361,.73203),(-1.26757,60.26917,1.13791),(-1.85309,58.22268,1.37774),(-1.85204,59.35396,.98305),(-1.79811,59.53535,1.04513),(-1.73312,59.60996,.96384),(-1.74216,59.60602,1.0272),(-.2782,60.63609,.57449),(-.31258,60.61734,.57611),(-.67336,60.44386,.69788),(-.65822,60.45025,.66833),(-.61716,60.46139,.6746),(-1.27216,60.09594,.81974),(-1.43975,59.95219,.92292),(-1.4144,59.97404,.92108),(-1.40731,59.98009,.91216),(-1.51315,59.8751,.82128),(-1.64917,59.71774,.89584),(-1.62491,59.76183,.92823),(-1.69184,59.66231,.97445),(-1.69482,59.51499,1.20962),(-1.74831,59.5964,1.02872),(-1.74803,59.58502,.97879),(-.17157,60.47299,1.18135),(-.8258,60.33205,.92551),(-.91416,60.19712,1.26884),(-1.4846,59.85699,1.12198),(-1.72246,59.34426,1.35191),(-1.77132,59.32372,1.22673),(-.96281,58.13702,2.78114),(-.30818,57.20941,1.52428),(-.27788,57.18768,1.52759),(1.78701,59.51239,1.40203),(1.72934,59.42111,1.71845),(1.80422,59.06731,1.8546),(1.72095,58.54707,2.21683),(1.93917,58.86234,1.49633),(1.78413,58.09164,1.35965),(1.45696,57.56558,2.53946),(.76797,57.93081,2.97361),(.42293,57.77881,2.34995),(.19145,57.27549,1.60088),(.72672,57.89388,2.38587),(.81175,57.88831,2.09039),(1.45238,58.32145,2.46619),(.93901,59.13931,2.74491),(1.59491,59.21872,1.85734),(.18755,57.52207,2.11546),(1.82026,59.44166,.96357),(1.82083,59.4432,.97197),(1.82669,59.43386,1.00625),(1.67719,57.94604,1.24977),(1.84263,58.41314,1.45747),(.26624,57.74056,2.50249),(1.30469,60.27177,.92346),(.25162,57.84279,2.67671),(.14879,57.76199,2.59793),(.31,57.48931,2.02295),(.30756,57.45747,1.96273),(.96074,60.08438,1.52642),(1.15898,59.84935,1.73814),(1.61041,58.58041,2.16957),(1.85301,59.36821,1.04709),(1.84867,59.36594,.98065),(1.86582,58.12821,1.36458),(2.00474,58.94306,1.0733),(1.94859,58.89112,1.4434),(1.86132,59.1742,1.56628),(1.96216,59.29835,1.05496),(1.96047,59.31614,1.03432),(1.90614,59.43784,1.0475),(1.83966,59.52487,1.10132),(1.8311,59.54098,1.09403),(1.84831,59.52108,1.16258),(1.80334,59.63067,1.01402),(1.75057,59.76613,.94561),(1.75852,59.73344,1.03694),(1.75752,59.76196,.93534),(1.4154,60.20061,.90201),(1.114,60.44659,.61915),(1.08742,60.46117,.64161),(1.12836,60.42753,.66668),(.57364,60.68744,.68754),(.28728,60.80324,.52026),(.24432,60.81323,.56034),(1.67588,59.80408,1.2599),(1.85628,58.20376,1.55008),(1.69007,57.9213,1.34706),(1.67045,57.8916,1.35623),(1.89552,58.32044,1.38935),(1.86836,58.26673,1.36712),(1.92664,58.62674,1.28332),(1.91742,58.55513,1.34934),(1.92677,58.65911,1.2151),(1.9385,59.01836,1.10475),(1.82012,59.45163,1.00222),(.38984,60.5726,.64233),(.84226,60.36657,.65795),(.78053,60.40646,.72249),(1.0644,60.24778,.839),(1.08865,60.22995,.86728),(1.18738,60.16159,.83905),(1.22255,60.13096,.89131),(1.52622,59.87242,.89636),(1.54139,59.84996,.85823),(1.55615,59.84416,.8985),(1.72141,59.6225,.9329),(1.9348,59.02246,1.02078),(.64774,60.41553,.88462),(.44667,60.41136,1.21961),(1.57165,59.73797,1.16091),(1.48015,59.72271,1.41792),(1.69626,59.39065,1.36712),(1.55391,59.57195,1.48483),(1.46189,57.72662,1.53558),(.43855,57.26035,1.36251),(.17361,57.20027,1.50532),(1.01126,57.97599,2.59202),(-.00721,57.59533,2.92714),(-.0001,57.5484,2.87247),(.13157,57.55073,2.98334),(-.71008,57.89709,2.95105),(-.59518,57.853,2.86928),(-.40658,58.19237,3.12893),(-.06513,57.64923,2.86454),(.13666,57.56104,2.97896),(-.13666,57.56104,2.97329),(-.07605,57.58241,2.98926),(1.07795,60.19102,1.01301),(.5201,60.47081,.86123),(.58392,60.44317,.87292),(1.20785,60.14881,.78551),(.73264,60.42799,.59739),(.69529,60.44032,.60954),(.77539,60.40638,.66208),(1.72267,59.62637,.94868),(1.83131,59.42304,1.01676),(0,60.82397,.73087),(.65996,60.66584,.55586),(.95357,60.54357,.61701),(1.57861,60.05337,.90895),(1.54782,60.07594,.94371),(1.64722,59.93615,.8976),(1.83904,59.55,1.04253),(1.88338,59.53232,.95077),(1.92581,59.36223,1.09008),(1.95638,59.33683,1.01799),(1.93753,59.34399,1.07521),(1.96802,59.02947,1.24912),(1.99772,59.05806,1.11367),(1.95684,59.11648,1.26396),(1.98937,59.13278,1.13084),(1.97724,58.71852,1.3466),(1.73443,57.95597,1.356),(1.96474,58.63107,1.24111),(1.9614,58.62184,1.26856),(1.91267,58.51615,1.35721),(1.98504,59.16864,1.12194),(1.80883,59.6673,.94281),(1.72537,59.6191,.94739),(1.80711,59.68231,.92429),(1.80542,59.58931,1.07215),(1.72577,59.61244,.93283),(1.33026,60.04606,.84907),(1.43449,60.18868,.85652),(1.64899,59.95629,.86139),(1.12212,60.20533,.87787),(1.31924,60.28532,.80658),(.79851,60.39615,.66569),(.93242,60.55747,.60176),(.51917,60.50262,.59299),(.49273,60.51305,.57085),(.22075,60.62179,.58581),(1.71745,57.97198,1.36292),(1.46991,58.23209,2.43028),(1.3937,58.67446,2.52058),(1.37704,58.67856,2.53335),(1.46304,57.93812,2.28893),(.61667,60.12622,1.83506),(.51924,57.82235,2.37207),(.57204,57.82027,2.29373),(.32287,57.48532,1.98683),(1.63735,59.98527,.83385),(1.40826,58.25121,2.64873),(.28246,60.23373,1.87372),(0,60.27061,1.84404),(1.13013,60.15501,1.02478),(1.25353,59.35939,2.28229),(1.32048,59.56906,1.98204),(0,59.85636,2.40782),(.54568,59.18458,2.84121),(.53082,58.80335,2.94901),(1.71581,58.15256,1.9334),(1.7106,58.09383,1.88808),(1.50616,58.30053,2.37887),(.26328,58.79258,2.96992),(1.69866,58.13755,1.96694),(1.69494,58.08701,1.94097),(1.70015,57.96925,1.42408),(1.06974,57.71921,1.96898),(.79394,58.18973,3.05604),(.77978,57.73931,1.98484),(.75444,57.83744,2.23205),(.54338,57.82378,2.86973),(.52205,57.89566,2.99778),(.38424,57.77007,2.95674),(1.39037,59.99439,.87531),(1.40489,59.98199,.89086),(1.75747,58.04431,2.01953),(1.70155,58.17061,2.22231),(1.79539,58.41815,2.04776),(1.6307,58.28554,2.39089),(1.96893,59.28226,1.0547),(1.64466,59.05877,2.19082),(1.69548,59.2417,1.96475),(1.46328,58.95231,2.54287),(1.53119,59.23734,2.30398),(1.56048,58.79146,2.43095),(1.35228,59.64432,2.19293),(1.57762,59.63261,1.82897),(1.36334,59.84108,1.92643),(1.55166,59.44405,2.09389),(1.12488,59.62427,2.50931),(1.35076,59.44381,2.41998),(1.13331,59.81182,2.27637),(1.02911,58.53055,2.93594),(.76924,58.7398,3.0216),(.81969,59.75563,2.58804),(.8292,59.95883,2.34153),(.45159,60.56042,1.52222),(.40459,59.85809,2.65326),(.4234,60.07731,2.41657),(.3733,58.969,3.08653),(.37688,58.71066,3.07838),(.38697,58.30763,3.09968),(0,58.96955,3.07872),(0,58.69169,3.08319),(0,59.89058,2.68546),(0,60.10385,2.4576),(0,60.62247,1.52561),(-.58392,60.44317,.87292),(-1.39037,59.99439,.87531),(-1.40489,59.98199,.89086),(-1.20785,60.14881,.78551),(-1.22938,60.13258,.78574),(-1.13013,60.15501,1.02478),(-1.12212,60.20533,.87787),(-1.07795,60.19102,1.01301),(-.58411,60.47676,.65265),(-.5201,60.47081,.86123),(-.69529,60.44032,.60954),(-1.81783,59.45929,1.00841),(-1.71745,57.97198,1.36292),(-1.70242,57.94416,1.35495),(-1.02034,60.47734,.91788),(-1.35526,60.24046,.91327),(-1.34852,60.26828,.80783),(-1.38758,60.23407,.83963),(-1.81416,59.59783,1.18738),(-1.82605,59.57642,1.03666),(-1.80542,59.58931,1.07215),(-1.83904,59.55,1.04253),(-1.89295,59.47567,1.03828),(-1.98504,59.16864,1.12194),(-1.98937,59.13278,1.13084),(-1.95684,59.11648,1.26396),(-1.9614,58.62184,1.26856),(-1.95872,58.61754,1.29408),(-1.91267,58.51615,1.35721),(-1.72577,59.61244,.93283),(-1.72537,59.6191,.94739),(-1.81094,59.47322,.98218),(-1.75618,59.57222,.98049),(-1.35821,60.02203,.86102),(-1.46549,60.15915,.86918),(-1.45801,60.16668,.86267),(-1.36577,60.01556,.86769),(-1.70101,59.84504,.92813),(-1.68227,59.88824,.89683),(-1.57861,60.05337,.90895),(-1.61499,60.02542,.81224),(-1.63735,59.98527,.83385),(-1.10424,60.22054,.8158),(-.95357,60.54357,.61701),(-.79851,60.39615,.66569),(-.51917,60.50262,.59299),(-.65996,60.66584,.55586),(-.03358,60.85056,.48146),(-.01399,60.85028,.46456),(-1.50616,58.30053,2.37887),(-1.46991,58.23209,2.43028),(-1.49758,58.30619,2.39858),(-1.48236,58.70681,2.41223),(-1.43877,58.17429,2.47024),(-1.40388,58.23232,2.50788),(-1.12434,59.71272,2.03909),(-1.01625,59.77675,2.07529),(-1.12146,59.70264,2.05875),(-1.39457,58.34404,2.53317),(-.35383,57.82831,2.61512),(-.32144,57.77193,2.53777),(-.33062,57.65817,2.47605),(-.33907,57.8883,2.76111),(-1.66826,59.8617,1.04989),(-1.40826,58.25121,2.64873),(-.82084,60.60496,.62452),(-.77539,60.40638,.66208),(-.73264,60.42799,.59739),(-.93242,60.55747,.60176),(-.28246,60.23373,1.87372),(-.25484,60.03792,2.20081),(-.54568,59.18458,2.84121),(-.53082,58.80335,2.94901),(-1.71581,58.15256,1.9334),(-1.7106,58.09383,1.88808),(-.26328,58.79258,2.96992),(-1.45238,58.32145,2.46619),(-1.69866,58.13755,1.96694),(-1.69494,58.08701,1.94097),(-1.14423,57.64039,1.90821),(-.49216,57.85683,2.44316),(-.36589,57.61841,2.12719),(-.77978,57.73931,1.98215),(-1.92581,59.36223,1.09008),(-1.93753,59.34399,1.07521),(-1.75747,58.04431,2.01953),(-1.56048,58.79146,2.43095),(-1.64466,59.05877,2.19082),(-1.69548,59.2417,1.96475),(-1.53119,59.23734,2.30398),(-1.55166,59.44405,2.09389),(-1.43101,58.5714,2.59729),(-1.35076,59.44381,2.41998),(-1.35228,59.64432,2.19293),(-1.36334,59.84108,1.92643),(-1.13331,59.81182,2.27637),(-1.13274,60.00409,1.99524),(-.8292,59.95883,2.34153),(-.84521,60.14157,2.053),(-.44644,60.44698,1.81167),(-.45159,60.56042,1.52222),(-.86923,60.29706,1.74208),(-.81969,59.75563,2.58804),(-.38481,59.52412,2.90764),(-.40459,59.85809,2.65326),(-.79904,59.4529,2.84661),(-.37688,58.71066,3.07838),(-.76924,58.7398,3.0216),(-.37905,58.49764,3.07639),(-.37863,59.22052,3.04307),(0,59.24678,3.04057),(-.3733,58.969,3.08653),(-.43376,60.28192,2.12815),(0,60.32194,2.16028),(-.4234,60.07731,2.41657),(0,58.72089,2.69267),(-.146,60.74525,.96565),(0,60.49448,1.83307),(0,59.54668,2.9213),(-.38697,58.30763,3.09568),(-1.12488,59.62427,2.50931),(-1.30819,59.14887,2.66068),(-1.09856,59.32087,2.77066),(-1.14437,60.15924,1.67974),(-1.46328,58.95231,2.54287),(-1.57762,59.63261,1.82897),(-1.79539,58.41815,2.04776),(-1.96474,58.63107,1.24111),(-1.97724,58.71852,1.3466),(-1.06974,57.71921,1.9684),(-1.37704,58.67856,2.53335),(-.61667,60.12622,1.83506),(-1.32322,60.05213,.84817),(-1.42798,60.19459,.85623),(-.25162,57.84279,2.67039),(-.32287,57.48532,1.98167),(-1.32048,59.56906,1.98204),(-1.48991,58.65517,2.40248),(-.49273,60.51305,.57085),(-1.31924,60.28532,.80658),(-1.33026,60.04606,.84907),(-1.43449,60.18868,.85652),(-1.88338,59.53232,.95077),(-1.72267,59.62637,.94868),(-1.80711,59.68231,.92429),(-1.95638,59.33683,1.01799),(-1.69007,57.9213,1.34706),(-1.83131,59.42304,1.01676),(-1.81446,59.46773,1.00333),(.44644,60.44698,1.81167),(.38481,59.52412,2.90764),(.37905,58.49764,3.07729),(.7679,58.50375,3.01017),(.79904,59.4529,2.84661),(.86923,60.29706,1.74208),(1.13274,60.00409,1.99524),(.84521,60.14157,2.053),(1.01233,58.30587,2.93192),(.77961,58.29703,3.03324),(1.43101,58.5714,2.59729),(.56761,57.81534,2.51958),(.32226,57.65984,2.91018),(.74518,57.88917,2.50503),(1.14423,57.64039,1.90843),(1.48991,58.65517,2.40248),(1.49758,58.30619,2.39858),(1.43638,58.66344,2.47935),(1.48236,58.70681,2.41223),(.25484,60.03792,2.20081),(0,60.07776,2.1709),(1.12146,59.70264,2.05875),(1.81783,59.45929,1.00841),(1.01625,59.77675,2.07529),(1.12434,59.71272,2.03909),(.03354,60.65013,.5061),(.05817,60.63662,.52307),(.01459,60.69548,.48385),(1.32322,60.05213,.84817),(1.42798,60.19459,.85623),(.35383,57.82831,2.62345),(.06476,60.84694,.4995),(1.10424,60.22054,.8158),(1.36577,60.01556,.86769),(1.46549,60.15915,.86918),(1.61499,60.02542,.81224),(1.35821,60.02203,.86102),(1.45801,60.16668,.86267),(1.82605,59.57642,1.03666),(1.75618,59.57222,.98049),(1.9079,58.65836,1.14233),(1.81416,59.59783,1.18738),(1.82878,59.61485,.9701),(1.82088,59.62989,.96813),(1.35526,60.24046,.91327),(1.34852,60.26828,.80783),(1.38758,60.23407,.83963),(1.02034,60.47734,.91788),(.58411,60.47676,.65265),(1.22938,60.13258,.78574),(.16959,57.1865,1.51906),(.15931,57.14467,1.48074),(-.64355,57.85477,2.85079),(1.08709,60.23403,.76504),(1.06383,60.25054,.75809),(1.93448,59.04191,1.09432),(1.95872,58.61754,1.29408),(1.98007,59.26734,1.03608),(.03358,60.85056,.48146),(.49216,57.85683,2.45156),(1.30819,59.14887,2.66068),(1.14437,60.15924,1.67974),(1.09856,59.32087,2.77066),(.43376,60.28192,2.12815),(.37863,59.22052,3.04307),(-1.96802,59.02947,1.24912),(-1.99772,59.05806,1.11367),(-1.93448,59.04191,1.09432),(-1.82878,59.61485,.9701),(-1.82088,59.62989,.96813),(-1.06383,60.25054,.75809),(-1.3937,58.67446,2.52058),(-1.46304,57.93812,2.28893),(-1.43638,58.66344,2.47935),(-1.08709,60.23403,.76504),(-.15931,57.14467,1.48018)]))),
        Shape(DEF='ethmoid',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='ethmoid_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,37,-1,41,42,43,-1,44,45,46,-1,47,30,48,-1,27,34,33,-1,29,49,50,-1,20,51,50,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,25,61,15,-1,62,39,36,-1,63,64,65,-1,65,66,63,-1,41,67,65,-1,37,68,38,-1,69,70,71,-1,72,73,17,-1,74,75,76,-1,77,78,79,-1,64,63,80,-1,64,80,70,-1,81,82,83,-1,84,67,41,-1,85,86,87,-1,88,89,90,-1,91,88,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,107,106,108,-1,12,109,110,-1,111,112,113,-1,114,115,116,-1,117,118,99,-1,116,115,12,-1,98,119,111,-1,120,121,122,-1,123,124,125,-1,126,95,94,-1,127,128,129,-1,130,131,132,-1,133,134,135,-1,136,137,138,-1,139,140,141,-1,142,143,144,-1,130,145,131,-1,146,147,148,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,164,165,88,-1,166,167,168,-1,169,170,155,-1,171,172,147,-1,173,174,146,-1,175,136,176,-1,177,178,179,-1,180,181,119,-1,182,183,184,-1,185,186,187,-1,188,150,152,-1,189,117,190,-1,191,192,193,-1,147,172,191,-1,194,195,196,-1,197,198,199,-1,200,201,202,-1,197,203,204,-1,123,130,205,-1,206,207,208,-1,209,210,211,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,221,135,134,-1,222,223,224,-1,225,226,227,-1,228,229,230,-1,231,232,124,-1,233,234,235,-1,236,237,233,-1,220,219,238,-1,239,240,159,-1,241,242,243,-1,172,224,223,-1,244,245,196,-1,246,247,248,-1,249,191,250,-1,251,252,253,-1,254,255,256,-1,257,258,246,-1,259,260,261,-1,262,263,264,-1,265,266,263,-1,267,268,269,-1,93,270,271,-1,272,273,184,-1,10,274,275,-1,276,277,278,-1,279,280,24,-1,281,282,283,-1,218,284,285,-1,286,287,145,-1,288,289,128,-1,214,290,144,-1,291,214,143,-1,292,262,293,-1,110,98,294,-1,295,296,262,-1,274,297,277,-1,298,299,300,-1,301,302,303,-1,304,305,306,-1,307,308,309,-1,310,311,312,-1,313,314,315,-1,316,317,318,-1,314,305,304,-1,319,320,321,-1,300,299,322,-1,323,324,325,-1,326,327,328,-1,329,321,320,-1,329,330,321,-1,331,332,333,-1,334,335,336,-1,337,338,339,-1,340,339,341,-1,342,332,330,-1,343,318,344,-1,345,346,347,-1,348,349,350,-1,351,352,195,-1,194,196,245,-1,353,163,162,-1,354,355,356,-1,357,358,359,-1,360,254,361,-1,362,363,364,-1,225,250,226,-1,365,244,366,-1,367,368,139,-1,369,370,371,-1,372,373,374,-1,375,376,377,-1,378,379,380,-1,381,256,382,-1,253,383,249,-1,313,384,385,-1,386,387,252,-1,388,389,390,-1,391,390,392,-1,393,394,356,-1,395,396,397,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,407,408,409,-1,410,411,412,-1,413,414,415,-1,416,417,418,-1,419,420,421,-1,422,423,424,-1,86,425,426,-1,427,428,429,-1,430,414,418,-1,431,413,432,-1,433,434,435,-1,96,436,97,-1,433,435,437,-1,438,439,114,-1,440,85,87,-1,441,442,443,-1,444,86,445,-1,98,438,294,-1,446,447,440,-1,448,433,449,-1,450,451,452,-1,451,453,454,-1,454,452,451,-1,455,456,457,-1,458,459,460,-1,457,461,462,-1,463,452,464,-1,465,466,467,-1,468,469,470,-1,471,472,465,-1,473,474,475,-1,476,477,470,-1,478,479,480,-1,481,477,482,-1,483,484,485,-1,474,486,487,-1,488,489,490,-1,491,492,489,-1,493,494,495,-1,496,497,498,-1,499,500,501,-1,502,479,503,-1,504,505,506,-1,507,508,509,-1,510,487,507,-1,506,505,511,-1,512,513,488,-1,514,515,516,-1,517,518,519,-1,519,520,521,-1,522,523,521,-1,524,525,526,-1,527,515,528,-1,529,530,531,-1,517,532,533,-1,534,535,531,-1,536,537,538,-1,539,540,541,-1,542,543,544,-1,545,546,547,-1,548,549,550,-1,551,552,553,-1,554,555,556,-1,557,547,546,-1,558,559,560,-1,561,562,552,-1,549,563,561,-1,564,565,566,-1,567,568,569,-1,567,569,570,-1,571,572,573,-1,574,575,576,-1,572,577,573,-1,578,579,580,-1,581,577,582,-1,583,584,585,-1,586,587,588,-1,589,586,588,-1,590,591,592,-1,593,594,595,-1,596,597,595,-1,598,599,600,-1,601,602,603,-1,604,605,606,-1,607,606,608,-1,609,496,610,-1,611,612,613,-1,613,614,611,-1,615,616,617,-1,618,619,620,-1,621,622,623,-1,615,624,625,-1,626,627,628,-1,629,630,631,-1,632,628,627,-1,631,633,634,-1,635,636,616,-1,637,638,639,-1,640,641,642,-1,643,644,645,-1,642,641,646,-1,647,645,648,-1,649,650,651,-1,652,653,654,-1,655,656,657,-1,658,659,660,-1,661,662,663,-1,654,664,665,-1,657,666,667,-1,659,668,669,-1,662,670,671,-1,665,672,637,-1,673,669,668,-1,674,675,676,-1,677,623,622,-1,678,679,680,-1,616,615,625,-1,622,681,682,-1,682,683,684,-1,685,686,687,-1,688,635,689,-1,690,691,684,-1,692,693,687,-1,688,694,695,-1,696,697,698,-1,699,700,701,-1,702,703,704,-1,705,706,707,-1,708,709,710,-1,711,712,713,-1,714,715,716,-1,717,718,719,-1,720,721,722,-1,723,724,725,-1,726,727,728,-1,729,730,731,-1,732,714,726,-1,731,722,733,-1,725,734,735,-1,736,728,727,-1,709,730,729,-1,737,738,739,-1,740,741,742,-1,701,700,743,-1,698,697,744,-1,745,743,746,-1,707,747,748,-1,749,750,744,-1,751,752,753,-1,754,755,756,-1,757,758,759,-1,760,761,762,-1,763,764,765,-1,766,767,768,-1,769,770,771,-1,772,773,767,-1,774,752,751,-1,772,775,773,-1,776,777,778,-1,779,751,753,-1,759,779,753,-1,740,780,781,-1,782,783,784,-1,785,782,786,-1,787,782,785,-1,788,789,790,-1,791,792,793,-1,794,795,796,-1,797,798,799,-1,800,801,802,-1,803,804,805,-1,806,807,808,-1,809,810,811,-1,812,813,814,-1,815,816,817,-1,818,819,820,-1,821,822,823,-1,824,825,826,-1,827,828,829,-1,830,831,832,-1,833,834,835,-1,836,837,838,-1,839,840,841,-1,842,843,844,-1,845,846,847,-1,848,840,849,-1,839,850,830,-1,851,852,833,-1,844,853,854,-1,847,855,856,-1,857,858,859,-1,841,860,861,-1,862,863,846,-1,864,857,865,-1,866,867,843,-1,868,869,870,-1,871,872,873,-1,874,875,876,-1,877,878,879,-1,880,881,882,-1,883,884,878,-1,885,886,887,-1,888,889,890,-1,891,892,893,-1,894,895,896,-1,897,898,899,-1,900,901,902,-1,903,904,905,-1,906,907,908,-1,907,909,908,-1,910,911,912,-1,913,914,912,-1,915,916,917,-1,918,919,920,-1,921,922,923,-1,924,925,926,-1,927,928,929,-1,930,931,932,-1,933,934,935,-1,936,937,938,-1,939,940,916,-1,941,942,920,-1,943,944,945,-1,946,947,948,-1,948,949,950,-1,951,904,952,-1,953,954,955,-1,956,957,958,-1,954,932,959,-1,960,961,962,-1,790,789,963,-1,964,965,966,-1,816,967,968,-1,969,970,971,-1,972,973,541,-1,492,491,974,-1,975,976,977,-1,978,979,980,-1,981,982,983,-1,981,984,982,-1,985,986,987,-1,988,989,990,-1,991,992,993,-1,994,995,996,-1,997,998,999,-1,1000,1001,1002,-1,1003,1004,1005,-1,1006,1007,1008,-1,1007,1009,1008,-1,1010,292,293,-1,1011,1012,1013,-1,1014,1015,1016,-1,1017,1018,1019,-1,1020,1017,1019,-1,1021,1022,1023,-1,964,1024,1025,-1,1026,1027,1028,-1,1029,1030,1031,-1,1032,1033,1034,-1,1035,1036,1037,-1,790,1038,1039,-1,1040,1041,1042,-1,977,1043,975,-1,1044,980,1045,-1,1046,1047,1048,-1,1049,1050,1051,-1,1052,1053,1054,-1,1054,1055,991,-1,1056,1057,1058,-1,991,1059,1054,-1,1060,1061,1062,-1,1063,1064,1065,-1,1066,1067,1068,-1,1069,1070,1071,-1,1072,1073,1074,-1,1075,1076,1077,-1,1078,1079,1080,-1,1081,1082,1083,-1,1084,1085,1086,-1,1005,513,1087,-1,1088,1089,1090,-1,1091,1092,1093,-1,1094,1095,1096,-1,1097,1098,1099,-1,1100,1101,1102,-1,1103,1104,1105,-1,783,1106,784,-1,1107,1108,1109,-1,1110,1109,1111,-1,1112,1113,1114,-1,1112,1115,1116,-1,1110,1117,1118,-1,1108,1119,1120,-1,1121,1122,1123,-1,1123,1122,1124,-1,1125,1126,1127,-1,1128,520,1129,-1,1130,1131,1132,-1,1133,1134,1135,-1,1136,1135,1137,-1,1138,1139,1140,-1,1050,1049,990,-1,1141,1142,1143,-1,1144,1145,1146,-1,1078,1147,1148,-1,1149,1150,1151,-1,1152,1153,1154,-1,1155,1156,1132,-1,1157,1149,1158,-1,1159,1160,966,-1,1161,1162,1163,-1,1099,1164,1097,-1,1101,1100,1165,-1,1166,780,742,-1,1167,784,1168,-1,1169,1170,1171,-1,1172,1171,1056,-1,968,967,1173,-1,1165,1100,1035,-1,1174,1175,1176,-1,1177,1178,1179,-1,1148,1147,281,-1,1180,1181,1182,-1,1183,1184,1185,-1,1186,1096,1095,-1,1187,1188,1189,-1,1187,1190,813,-1,1191,814,813,-1,1192,443,966,-1,1193,1194,1195,-1,1196,1197,1198,-1,1199,1200,1201,-1,1202,1203,1204,-1,1205,1206,1207,-1,1208,1209,1210,-1,1211,1082,1003,-1,1212,1213,1214,-1,1215,1216,1217,-1,283,1218,1184,-1,1219,1220,1221,-1,1222,1223,1177,-1,1224,1225,1206,-1,1194,1226,1227,-1,1195,1228,1199,-1,1069,1071,1229,-1,1230,1231,1232,-1,1233,1234,1235,-1,1236,1066,1204,-1,1228,1237,1238,-1,1239,1240,1241,-1,1242,1243,1244,-1,1245,1246,1247,-1,1235,1234,1248,-1,1249,1250,1245,-1,1251,1252,1247,-1,1251,1253,1252,-1,1254,1255,1146,-1,1256,1257,1258,-1,1259,1258,1257,-1,1260,1261,1262,-1,1263,1264,790,-1,1265,1266,1040,-1,1267,1179,1178,-1,1268,1269,1270,-1,1271,1272,1002,-1,1273,1274,1005,-1,1275,1276,1277,-1,289,1278,1279,-1,1280,1021,1281,-1,1282,1011,1283,-1,1014,1011,1282,-1,1284,1285,1122,-1,1286,1287,1157,-1,1152,1288,1114,-1,1113,1289,1290,-1,1151,1158,1149,-1,1291,1292,1293,-1,1294,1295,1296,-1,1297,1298,1299,-1,1300,1301,1302,-1,1303,1129,543,-1,1304,1305,1306,-1,1307,1308,1309,-1,1310,1311,1294,-1,1312,1127,1313,-1,1310,1314,1315,-1,1316,1317,1318,-1,1319,1320,1321,-1,1322,1321,1323,-1,1324,1325,1326,-1,1327,1328,1329,-1,1330,1331,540,-1,1332,1333,1334,-1,1306,1335,538,-1,1325,971,1336,-1,1337,1338,1339,-1,1340,1341,1342,-1,1343,1344,1345,-1,1346,1347,1348,-1,1349,1350,1351,-1,1352,1353,1354,-1,1355,1356,1357,-1,1358,1359,1360,-1,1361,1362,1363,-1,1364,1365,1366,-1,1367,1352,1368,-1,1343,1369,1368,-1,1370,1371,1372,-1,1373,1341,1371,-1,1374,1375,1376,-1,1377,1378,1379,-1,970,1336,971,-1,534,1380,1362,-1,1381,1360,1359,-1,1382,1201,1383,-1,1202,1384,1231,-1,1317,1385,1309,-1,1386,448,1387,-1,1388,1389,1390,-1,1391,1392,1388,-1,1393,1394,1395,-1,1018,1396,1397,-1,1377,1398,1399,-1,1351,1400,1401,-1,1402,1403,1404,-1,1288,1152,1154,-1,1117,1405,1406,-1,1407,1134,1408,-1,1134,1409,1410,-1,1138,1140,1411,-1,1412,1143,1138,-1,1018,1413,1396,-1,1414,1116,1413,-1,1415,1190,1187,-1,1416,1417,1418,-1,1289,1419,1420,-1,1049,1421,1422,-1,1205,1194,1206,-1,1183,1423,1184,-1,1182,1181,1424,-1,1222,1425,1426,-1,1427,1428,1429,-1,1430,1431,1432,-1,1433,1434,1234,-1,1435,964,1436,-1,1437,1438,1439,-1,1166,1440,1102,-1,1441,1442,792,-1,1032,1029,1164,-1,1098,1443,1444,-1,1445,1443,1446,-1,1254,1447,974,-1,974,1447,1448,-1,1449,1450,1451,-1,1452,1453,1454,-1,1455,1456,1457,-1,1458,1459,1460,-1,1461,1462,1463,-1,1449,1464,1465,-1,1466,1467,1468,-1,1469,1470,1471,-1,1465,1464,1472,-1,1473,1474,1475,-1,1476,1473,1472,-1,1477,1478,1479,-1,1479,1480,1477,-1,1481,1482,1483,-1,1484,1481,1485,-1,1486,1487,1488,-1,1474,1489,1475,-1,1490,1491,1492,-1,1460,1493,1456,-1,1494,1495,1496,-1,1491,1497,1492,-1,1498,1499,1494,-1,1499,1495,1494,-1,1500,1501,1502,-1,1503,1504,1505,-1,1506,1507,1501,-1,1505,1506,1508,-1,1508,1509,1510,-1,1511,1512,1513,-1,1514,1515,1516,-1,1517,1518,1519,-1,1520,1521,1522,-1,1523,1524,1525,-1,1526,1527,1528,-1,1529,1530,1531,-1,1532,1533,1534,-1,1535,1536,1537,-1,1538,1539,1540,-1,1541,1542,1537,-1,1537,1538,1543,-1,1531,1544,1545,-1,1546,1526,1528,-1,1534,1547,1540,-1,1528,1548,1546,-1,1549,1550,1551,-1,1552,1528,1527,-1,1537,1536,1553,-1,1554,1555,1556,-1,926,1557,944,-1,1558,1559,926,-1,1560,534,1545,-1,1540,1561,1538,-1,1545,534,530,-1,530,1562,1545,-1,1547,514,1540,-1,901,1558,904,-1,1563,944,1564,-1,1565,1566,936,-1,1567,1568,1569,-1,1570,1571,1572,-1,1532,1573,1533,-1,1530,1529,1574,-1,1575,1576,1577,-1,1549,1569,1578,-1,1532,1579,1573,-1,1539,1580,1540,-1,1581,1582,1545,-1,1526,1583,1582,-1,1537,1584,1535,-1,1585,1586,1587,-1,1588,1547,1534,-1,1589,1590,1579,-1,1582,1527,1526,-1,1544,1591,1581,-1,1525,1524,1592,-1,1593,1594,1595,-1,1596,1597,1598,-1,1599,1519,1600,-1,1601,1602,1603,-1,495,1604,1512,-1,1601,1605,1602,-1,1506,1501,1509,-1,1507,1606,1607,-1,1504,1608,1609,-1,1610,1611,1609,-1,1612,1515,1456,-1,1492,1497,1612,-1,1613,1614,1615,-1,1615,1491,1613,-1,1494,1496,1454,-1,1616,1457,1498,-1,1459,1492,1493,-1,1617,1491,1490,-1,1485,1618,1619,-1,1481,1620,1621,-1,1622,1623,1477,-1,1624,1625,1473,-1,1465,1472,1475,-1,1462,1471,1626,-1,1449,1627,1628,-1,1629,1630,1464,-1,1450,1449,1631,-1,1460,1456,1632,-1,1453,1633,1454,-1,1450,1452,1634,-1,1464,1635,1617,-1,974,491,1636,-1,1637,1258,1259,-1,1445,1446,1259,-1,1443,1445,792,-1,1164,1638,1032,-1,1035,1639,1165,-1,1441,1440,1640,-1,1641,793,792,-1,1642,1437,1643,-1,1263,1644,1433,-1,1645,1433,792,-1,1044,1263,978,-1,1046,1430,1432,-1,1646,1427,1429,-1,1161,443,1647,-1,1178,1648,1267,-1,1081,1083,1086,-1,1009,1144,1649,-1,1650,1235,1246,-1,1228,1227,1237,-1,1150,1416,1186,-1,967,1415,1017,-1,967,1017,1651,-1,1053,1412,1652,-1,1138,1653,1139,-1,1654,1655,1656,-1,1655,1657,1658,-1,1659,1406,1653,-1,1399,1660,1661,-1,1402,1010,1403,-1,1662,1353,1352,-1,1115,1399,1398,-1,1663,1281,1016,-1,1664,1665,1666,-1,1282,1667,1668,-1,1669,1651,1022,-1,1392,1386,1670,-1,1049,1051,1671,-1,1672,971,1673,-1,1674,1363,1675,-1,1651,1017,1676,-1,1364,1677,1365,-1,1352,1678,1679,-1,1340,1680,1681,-1,1340,1372,1371,-1,1367,1368,1369,-1,1375,1369,1682,-1,1376,1677,1119,-1,1348,1366,1365,-1,1683,1362,1381,-1,1684,1685,1561,-1,1367,1010,1662,-1,1349,1354,1350,-1,1686,1346,1687,-1,1688,1689,1690,-1,1691,1338,1344,-1,1340,1342,1680,-1,1692,1693,1373,-1,973,972,1694,-1,1338,1337,1695,-1,1357,971,1325,-1,1696,1697,1321,-1,1327,1326,1325,-1,1321,1697,1323,-1,1322,1291,1698,-1,1318,1317,1699,-1,1127,1156,1700,-1,1308,1699,1309,-1,1309,1385,1701,-1,1305,1702,1697,-1,1301,1300,1292,-1,1301,1703,1704,-1,1705,1704,1286,-1,1697,1706,1707,-1,1292,1291,1323,-1,1708,1709,1703,-1,1708,1703,1710,-1,1285,1711,1154,-1,1419,1149,1420,-1,1712,1713,1714,-1,1021,1715,1022,-1,1716,1717,1718,-1,1719,264,266,-1,1720,1400,1721,-1,1024,964,966,-1,1722,1723,1724,-1,1725,1726,1727,-1,1728,1726,1725,-1,1729,1179,1267,-1,1730,978,1433,-1,1642,1731,1732,-1,999,1732,1733,-1,1264,1263,1044,-1,1441,1260,1440,-1,1639,1035,1734,-1,1041,1266,1038,-1,1412,1138,1735,-1,1433,1645,1434,-1,1736,1256,1254,-1,1257,1736,1737,-1,1738,1146,1739,-1,1740,1245,1250,-1,1253,1741,1252,-1,1242,1181,1243,-1,1742,1743,1744,-1,1238,1237,1745,-1,1746,1747,1231,-1,1748,1198,1744,-1,1236,1204,1198,-1,1200,1383,1201,-1,1200,1749,1383,-1,1750,1751,1752,-1,1753,1754,1755,-1,1086,1756,1084,-1,1757,1758,1759,-1,1760,1278,1761,-1,1762,1082,1211,-1,1197,1241,1198,-1,1197,1763,1239,-1,1219,1764,1765,-1,1206,1194,1193,-1,965,1766,1767,-1,1093,1092,1768,-1,1769,1427,1646,-1,1770,1771,1085,-1,448,1386,1174,-1,1772,1031,1773,-1,444,1026,1774,-1,1775,1140,1776,-1,1056,1655,1777,-1,1640,1440,1166,-1,1166,742,1640,-1,1168,780,1778,-1,1440,1100,1102,-1,1099,1779,1164,-1,1780,1781,780,-1,1782,443,1161,-1,964,1783,965,-1,1124,1122,1784,-1,997,1318,1785,-1,1154,1153,1786,-1,1787,1788,1789,-1,1790,1791,1792,-1,1210,1147,1078,-1,1793,1741,1739,-1,1144,1146,1255,-1,1794,1795,1636,-1,1278,1796,1797,-1,1052,1141,1143,-1,1054,1798,1055,-1,1194,1205,1226,-1,1799,1800,1801,-1,1802,1799,1803,-1,1804,1805,1806,-1,1046,1807,1047,-1,1808,1809,1810,-1,1811,1139,1653,-1,1137,1135,1410,-1,1134,1809,1656,-1,1812,1813,1130,-1,997,1814,1812,-1,1815,1646,997,-1,1129,1303,1126,-1,1816,542,1301,-1,543,542,1816,-1,1122,1121,1284,-1,1817,1115,1818,-1,1417,1150,1819,-1,1109,1110,1118,-1,1419,1113,1820,-1,1121,1821,1822,-1,1418,1417,1823,-1,1824,1638,1167,-1,1105,1825,1103,-1,1164,1779,1638,-1,1189,1826,1769,-1,1151,1150,1186,-1,1827,1828,1829,-1,1097,492,1448,-1,1830,1831,1005,-1,1832,1086,1085,-1,1210,1833,1208,-1,1007,1834,1835,-1,1183,1836,1837,-1,1838,1839,1840,-1,1202,1841,1842,-1,1843,1751,1746,-1,1193,1382,1224,-1,1207,1844,1845,-1,1846,995,1847,-1,1847,1140,1846,-1,1653,1138,1143,-1,1848,989,988,-1,1227,985,987,-1,1799,1801,1803,-1,1807,1805,1849,-1,1046,1805,1807,-1,1802,1849,1804,-1,1850,1428,1437,-1,790,1041,1038,-1,1040,1731,1439,-1,1438,1851,1265,-1,1435,1436,1852,-1,443,1782,1159,-1,1853,1028,1854,-1,1772,1773,1855,-1,1856,1857,1858,-1,1859,1217,1216,-1,1860,1209,1208,-1,1770,1861,1862,-1,1179,1729,1863,-1,1395,1713,1712,-1,1663,1389,1669,-1,1391,1668,1395,-1,1015,1663,1016,-1,1864,1865,1866,-1,1395,1712,1867,-1,1435,1868,1783,-1,1868,1869,1783,-1,1380,1583,1360,-1,1081,1870,1004,-1,1773,1854,1871,-1,1310,1777,1654,-1,1226,1872,985,-1,1051,1050,1873,-1,1874,1875,1876,-1,975,1877,1730,-1,1805,1878,1806,-1,1879,1043,977,-1,970,1880,1881,-1,534,1560,1380,-1,1882,1433,1644,-1,1883,927,961,-1,1884,932,954,-1,1885,1883,960,-1,1886,1884,953,-1,1887,1888,952,-1,1887,952,1889,-1,901,1890,1891,-1,901,1892,1890,-1,1893,1894,901,-1,1895,1896,1897,-1,1898,1565,1899,-1,932,931,921,-1,959,923,955,-1,923,1900,955,-1,910,1901,1902,-1,1903,1904,918,-1,935,934,1905,-1,910,912,1906,-1,941,920,919,-1,919,1907,941,-1,1908,917,916,-1,1909,1910,934,-1,1911,1912,1913,-1,1914,907,906,-1,1915,1912,797,-1,879,878,884,-1,1916,1917,1918,-1,1919,1920,902,-1,899,898,1921,-1,893,1922,1923,-1,1578,889,896,-1,1924,1925,1926,-1,1927,1926,1925,-1,1928,1590,1929,-1,1930,1931,1932,-1,1933,1934,1935,-1,1935,883,1936,-1,1937,1938,1916,-1,1917,1939,878,-1,884,883,880,-1,884,1940,1941,-1,1942,1943,1944,-1,875,1945,876,-1,1946,1947,1948,-1,1949,1950,1951,-1,1952,871,1947,-1,842,1953,1954,-1,1955,1956,1957,-1,1958,863,862,-1,864,1959,863,-1,1960,1961,1962,-1,1963,841,1964,-1,860,859,858,-1,829,856,855,-1,853,847,838,-1,1965,833,852,-1,835,830,850,-1,840,839,832,-1,1966,848,1967,-1,843,845,853,-1,854,838,837,-1,1968,834,833,-1,832,1969,849,-1,1967,1970,1971,-1,1972,1973,1974,-1,821,824,806,-1,1975,1976,809,-1,806,808,1977,-1,803,805,1978,-1,1979,801,800,-1,1980,802,1981,-1,797,796,798,-1,1982,1983,795,-1,1441,1984,1261,-1,1882,1644,963,-1,1168,784,1106,-1,753,756,1985,-1,756,753,752,-1,751,1986,1987,-1,772,1988,1989,-1,752,773,754,-1,767,773,774,-1,771,770,1990,-1,768,767,1991,-1,753,1992,759,-1,1993,1994,1995,-1,747,707,706,-1,750,745,746,-1,746,700,698,-1,1996,1997,1998,-1,1999,744,697,-1,741,2000,1640,-1,2001,699,2002,-1,2003,2004,2005,-1,2006,724,2007,-1,2008,730,709,-1,728,2009,729,-1,726,716,2010,-1,2011,2007,723,-1,731,2008,2012,-1,719,2013,714,-1,2014,2015,2016,-1,2016,2017,2014,-1,2018,2019,2020,-1,2021,708,2022,-1,2023,2024,2025,-1,2026,2027,706,-1,2028,707,2029,-1,2030,745,721,-1,737,2031,1998,-1,692,2032,2033,-1,2034,2035,2036,-1,686,2037,2032,-1,689,684,694,-1,684,689,682,-1,677,682,628,-1,2038,2039,2040,-1,675,2041,679,-1,634,2042,638,-1,634,638,637,-1,663,671,668,-1,664,2043,657,-1,654,665,2044,-1,659,658,2045,-1,646,650,649,-1,2046,2047,655,-1,2048,642,2046,-1,2049,2050,2051,-1,2052,2053,641,-1,695,2049,2054,-1,635,616,2055,-1,636,688,695,-1,636,2056,639,-1,619,618,2057,-1,619,630,629,-1,2058,632,627,-1,626,615,2059,-1,2060,2059,615,-1,677,628,632,-1,2061,618,623,-1,630,2057,2062,-1,2063,2064,2065,-1,2066,613,612,-1,2067,2068,2069,-1,610,2070,2071,-1,344,496,609,-1,605,2072,608,-1,603,602,595,-1,2073,2074,2075,-1,2076,612,599,-1,2077,600,597,-1,2078,2070,610,-1,2079,2080,585,-1,585,2081,2079,-1,2080,2082,2083,-1,583,2084,578,-1,2085,2083,2082,-1,2086,2087,2088,-1,2084,2089,579,-1,2087,2090,2091,-1,336,333,575,-1,2092,576,2093,-1,333,332,2094,-1,2095,568,567,-1,545,547,556,-1,2096,341,560,-1,2097,2098,562,-1,559,558,2099,-1,341,2100,589,-1,555,2101,2102,-1,2087,582,577,-1,2103,551,553,-1,552,2104,545,-1,2105,572,571,-1,543,1129,520,-1,1325,1336,1328,-1,539,525,1334,-1,537,522,2106,-1,530,529,2107,-1,526,525,2108,-1,531,544,2109,-1,521,520,522,-1,2110,2111,529,-1,523,2112,532,-1,1772,512,488,-1,1831,489,488,-1,507,487,508,-1,2113,2114,2115,-1,2115,504,1625,-1,2114,480,479,-1,2116,498,497,-1,2117,501,500,-1,496,498,610,-1,2118,2119,1483,-1,1097,1164,490,-1,489,492,490,-1,486,2120,487,-1,2121,485,484,-1,477,480,482,-1,472,466,465,-1,471,2122,2123,-1,2124,2125,2126,-1,2122,2127,2128,-1,2128,2127,462,-1,464,452,2129,-1,2130,2131,2132,-1,455,457,2133,-1,462,461,2134,-1,460,459,2135,-1,2136,2137,2138,-1,2139,2140,458,-1,2141,2142,2143,-1,461,457,2144,-1,463,2137,2145,-1,2146,2147,2145,-1,449,2148,2149,-1,439,1174,1176,-1,448,449,1387,-1,393,1797,2150,-1,2151,2152,2153,-1,968,2149,2151,-1,96,98,2154,-1,438,97,439,-1,2155,440,447,-1,2156,86,426,-1,437,435,2157,-1,2157,427,429,-1,1026,444,2158,-1,2159,416,2160,-1,432,2161,425,-1,434,2162,2163,-1,431,425,2164,-1,2165,2166,2161,-1,2167,417,2168,-1,2169,2170,411,-1,2171,2172,400,-1,2172,2173,2174,-1,2172,2174,400,-1,2175,2176,2177,-1,2178,2179,2180,-1,2180,395,2178,-1,396,2173,2172,-1,499,497,2072,-1,2181,500,2182,-1,355,354,165,-1,85,165,86,-1,2183,2184,392,-1,2185,2186,2187,-1,386,252,2188,-1,2187,252,387,-1,313,2189,384,-1,2190,2191,2192,-1,2193,2194,381,-1,2191,2195,2196,-1,255,254,2197,-1,2198,2199,2200,-1,2201,2202,2203,-1,380,2204,2205,-1,2206,2207,2208,-1,2209,2210,2211,-1,377,2212,2213,-1,362,2214,2215,-1,374,2216,369,-1,225,2217,2218,-1,2219,2220,2221,-1,2222,138,166,-1,2223,362,364,-1,374,2224,2225,-1,377,2226,2227,-1,2197,2228,2229,-1,2230,2231,2232,-1,2233,2234,2193,-1,165,163,353,-1,347,2065,2235,-1,2236,2063,347,-1,352,310,312,-1,2237,2189,343,-1,313,2234,312,-1,349,2237,2238,-1,345,2239,2240,-1,2069,351,2240,-1,2241,310,352,-1,2242,2243,2244,-1,335,334,322,-1,330,2245,321,-1,2246,2100,341,-1,2247,2248,328,-1,2246,339,338,-1,308,2249,315,-1,2250,310,2251,-1,2252,2189,2249,-1,2253,2254,259,-1,115,114,1176,-1,2255,2256,2257,-1,16,120,14,-1,2258,2259,2260,-1,212,291,2261,-1,114,116,294,-1,2262,2259,2258,-1,275,277,11,-1,276,11,277,-1,1142,2263,1143,-1,2258,1143,2263,-1,1664,2264,2265,-1,295,262,264,-1,292,2266,262,-1,1,2267,4,-1,259,2268,2269,-1,2270,2269,2268,-1,383,253,252,-1,247,246,129,-1,151,2271,2272,-1,194,245,353,-1,194,353,162,-1,228,126,2273,-1,215,238,219,-1,282,2274,283,-1,169,2275,170,-1,135,206,2276,-1,2277,2278,2279,-1,2280,209,200,-1,211,210,231,-1,2281,2282,231,-1,211,2283,123,-1,2284,258,2285,-1,139,368,2286,-1,2287,2288,2289,-1,135,221,207,-1,2290,2278,2277,-1,2276,204,133,-1,205,130,2291,-1,200,2292,201,-1,2293,2294,368,-1,2295,171,2296,-1,2297,186,185,-1,187,183,182,-1,2298,177,2299,-1,178,2300,179,-1,176,2301,2302,-1,179,2300,2293,-1,167,166,2303,-1,2304,146,2305,-1,2304,2305,169,-1,2306,168,162,-1,2293,368,2307,-1,2302,2308,2309,-1,2310,2311,2303,-1,141,174,173,-1,161,164,2312,-1,2312,164,2302,-1,2308,2313,2314,-1,160,132,131,-1,2315,2316,243,-1,2304,155,157,-1,167,151,2272,-1,147,2304,2296,-1,133,204,2317,-1,368,367,2307,-1,282,2318,246,-1,271,125,124,-1,2319,95,2320,-1,271,232,2273,-1,2313,2299,2314,-1,2321,123,125,-1,2155,92,85,-1,180,119,109,-1,2322,112,111,-1,2323,2324,107,-1,181,180,2325,-1,2325,180,122,-1,2326,2327,2328,-1,2325,100,181,-1,89,2329,2308,-1,91,2330,88,-1,89,2308,90,-1,88,2331,89,-1,68,37,40,-1,2332,2333,2334,-1,2335,81,83,-1,29,31,2336,-1,2337,2338,2339,-1,62,2340,2341,-1,2342,20,19,-1,2343,38,80,-1,2344,2345,2346,-1,44,84,41,-1,2347,2348,2337,-1,276,2257,2349,-1,2335,2350,2344,-1,2351,2257,2256,-1,2352,2353,2354,-1,2350,2335,78,-1,42,2355,2356,-1,36,38,2340,-1,17,73,75,-1,2357,2358,2340,-1,2340,2358,2359,-1,64,70,2355,-1,2360,2361,58,-1,51,2362,50,-1,29,2336,49,-1,2363,50,49,-1,27,2364,34,-1,2349,2257,2351,-1,2365,2366,2334,-1,2367,2368,2332,-1,2356,70,69,-1,2369,2338,2337,-1,82,2370,2352,-1,74,25,75,-1,22,60,23,-1,51,20,2342,-1,2371,17,16,-1,14,72,2372,-1,45,2373,2374,-1,2343,2340,38,-1,5,4,6,-1,2,1,2375,-1,2270,2266,1,-1,259,2254,2268,-1,2270,1,2376,-1,2377,1,0,-1,2378,4,3,-1,7,6,4,-1,45,2374,46,-1,2379,10,9,-1,2380,13,115,-1,14,2371,16,-1,11,276,2381,-1,2342,2382,51,-1,60,59,23,-1,25,74,2359,-1,31,30,2336,-1,68,71,80,-1,2356,2355,70,-1,84,46,67,-1,2383,2365,2334,-1,2349,2351,2384,-1,18,2363,2256,-1,27,29,2364,-1,2360,58,2385,-1,79,78,2386,-1,2355,2387,64,-1,2340,2343,2357,-1,73,76,75,-1,2340,62,36,-1,65,64,2387,-1,42,2388,2355,-1,2389,2332,2390,-1,2335,2386,78,-1,2354,83,2352,-1,2336,2351,2256,-1,2335,2344,81,-1,2349,2381,276,-1,2347,2337,2370,-1,2350,2390,2344,-1,43,44,41,-1,2344,2346,81,-1,2372,72,2371,-1,80,2391,2343,-1,19,21,2342,-1,2340,74,2341,-1,25,15,75,-1,29,28,31,-1,2334,2367,2332,-1,68,40,2392,-1,88,90,2393,-1,2393,2302,164,-1,2330,2331,88,-1,89,113,2329,-1,104,103,2327,-1,105,2394,106,-1,2325,122,121,-1,102,2395,103,-1,2299,2313,2298,-1,2324,105,107,-1,2396,280,2397,-1,2397,2325,121,-1,2155,97,436,-1,85,440,2155,-1,124,123,2283,-1,2273,94,271,-1,95,126,2320,-1,232,271,124,-1,217,2398,2399,-1,2317,2400,133,-1,130,2401,2291,-1,146,148,193,-1,147,146,2304,-1,157,2296,2304,-1,2315,243,2402,-1,160,159,132,-1,2308,2329,2313,-1,161,163,164,-1,2403,141,173,-1,137,2310,2303,-1,2302,2309,176,-1,2307,2404,2293,-1,173,146,154,-1,169,155,2304,-1,146,174,2305,-1,2303,149,167,-1,2405,2309,2314,-1,2293,2404,179,-1,178,2406,2300,-1,383,2407,2408,-1,182,2409,187,-1,185,2410,2297,-1,2296,157,2295,-1,2294,134,368,-1,2411,199,198,-1,2291,2292,200,-1,199,203,197,-1,205,211,123,-1,2277,229,2290,-1,206,135,207,-1,2289,208,2287,-1,2294,2293,2300,-1,217,287,2398,-1,2284,246,258,-1,2412,257,2221,-1,231,210,2281,-1,211,231,2283,-1,123,2321,184,-1,209,2291,200,-1,2278,202,2279,-1,2276,133,135,-1,2413,134,133,-1,2221,257,248,-1,215,2414,238,-1,246,2284,282,-1,228,2273,2282,-1,349,2189,2237,-1,162,2189,348,-1,151,2415,2271,-1,191,249,192,-1,2217,255,2191,-1,2416,381,2194,-1,2253,2264,263,-1,4,2267,7,-1,2380,1394,1393,-1,1664,265,2264,-1,2417,2418,93,-1,2419,2294,2300,-1,10,275,11,-1,2262,278,2259,-1,2258,2255,2262,-1,130,132,240,-1,116,110,294,-1,2260,1143,2258,-1,120,12,14,-1,2257,2262,2255,-1,1391,115,1392,-1,2376,2269,2270,-1,2420,310,2250,-1,313,315,2249,-1,312,314,313,-1,304,308,315,-1,2246,338,2421,-1,2247,328,2422,-1,341,339,2246,-1,2096,329,340,-1,2096,342,329,-1,330,331,2245,-1,322,2423,335,-1,2243,325,2244,-1,352,592,2241,-1,2239,2069,2240,-1,2424,349,2238,-1,2236,2425,2424,-1,2189,349,348,-1,2240,351,195,-1,312,195,352,-1,347,2235,2067,-1,195,2233,196,-1,2193,381,366,-1,2426,2427,361,-1,2428,2429,359,-1,375,377,2227,-1,372,374,2225,-1,364,2430,2223,-1,2218,250,225,-1,222,2431,227,-1,374,2432,2216,-1,362,2215,363,-1,377,2213,2223,-1,2433,2434,375,-1,2434,376,375,-1,2209,2435,2210,-1,2207,2436,2208,-1,380,379,2204,-1,2202,378,2203,-1,2198,2437,2199,-1,381,2416,2438,-1,2191,2196,2192,-1,313,2249,2189,-1,386,2188,2439,-1,2187,387,2185,-1,392,2426,2183,-1,164,163,165,-1,354,86,165,-1,2182,2440,2181,-1,2072,2441,499,-1,2172,397,396,-1,2177,2442,2175,-1,2174,2443,400,-1,400,399,2171,-1,2169,2444,2170,-1,417,416,2168,-1,2164,2445,431,-1,434,2446,2162,-1,2157,2447,2448,-1,2159,2160,2445,-1,2446,2156,2449,-1,2157,2448,427,-1,435,2447,2157,-1,433,448,440,-1,447,97,2155,-1,97,447,439,-1,968,2151,2450,-1,2451,2151,2153,-1,2150,394,393,-1,1176,114,439,-1,438,98,97,-1,2146,2145,2137,-1,2145,450,463,-1,2144,2139,461,-1,2143,2131,2141,-1,458,461,2139,-1,2137,463,2138,-1,459,2146,2135,-1,461,458,2134,-1,2133,2452,455,-1,2131,2143,2132,-1,452,454,2129,-1,2128,462,2134,-1,2122,465,2127,-1,2123,2453,471,-1,472,2454,466,-1,477,2455,480,-1,484,2456,2121,-1,2120,2457,487,-1,490,492,1097,-1,490,1164,1029,-1,2118,1483,1482,-1,500,2181,2117,-1,497,499,2116,-1,479,502,2114,-1,1625,1624,2115,-1,2115,1622,2113,-1,487,2457,508,-1,488,1029,1772,-1,523,532,521,-1,2110,2458,2111,-1,2459,1562,515,-1,519,544,520,-1,2109,2110,531,-1,526,2108,527,-1,2107,1562,530,-1,525,541,2108,-1,1332,536,538,-1,543,520,544,-1,2460,1358,1546,-1,573,577,581,-1,2105,2090,572,-1,545,550,552,-1,2103,553,2461,-1,2087,2086,582,-1,555,2102,2462,-1,341,589,560,-1,559,2099,2463,-1,2097,562,561,-1,546,545,2104,-1,560,565,2096,-1,556,548,545,-1,566,2095,567,-1,333,2094,575,-1,2093,2464,2092,-1,336,575,574,-1,2087,2091,2088,-1,579,578,2084,-1,2086,2088,2465,-1,2082,2466,2085,-1,583,578,2467,-1,2080,2083,585,-1,594,596,595,-1,2077,598,600,-1,2073,2075,2468,-1,605,608,606,-1,2469,2470,2078,-1,2470,2471,2078,-1,609,2472,344,-1,344,608,496,-1,2069,2239,2067,-1,612,2076,2066,-1,347,2063,2065,-1,630,2062,2473,-1,2474,619,629,-1,618,620,623,-1,2474,621,620,-1,615,617,2060,-1,626,624,615,-1,2058,2061,632,-1,2057,630,619,-1,636,639,638,-1,616,636,638,-1,695,2475,2049,-1,2476,2052,641,-1,2051,2054,2049,-1,642,2047,2046,-1,2046,655,653,-1,646,649,2477,-1,2045,663,659,-1,2056,654,2044,-1,657,667,664,-1,668,659,663,-1,679,676,675,-1,2038,2478,2039,-1,684,691,694,-1,686,2032,692,-1,2036,2479,2034,-1,692,2033,2052,-1,1998,1997,737,-1,2480,2030,721,-1,2028,2029,2481,-1,2026,706,705,-1,2025,2482,2023,-1,2022,2483,2021,-1,2019,2484,2020,-1,719,718,2013,-1,731,730,2008,-1,2007,724,723,-1,726,714,716,-1,708,2008,709,-1,2006,2007,2021,-1,699,2485,2002,-1,742,741,1640,-1,697,2486,1999,-1,1996,1998,1994,-1,746,743,700,-1,746,744,750,-1,706,2487,747,-1,1993,2488,1994,-1,752,774,773,-1,756,752,754,-1,2489,757,2490,-1,768,1991,2491,-1,771,1990,766,-1,767,774,1991,-1,1989,775,772,-1,751,779,1986,-1,2492,781,780,-1,2493,1640,2000,-1,1441,1261,1260,-1,1882,1641,792,-1,795,2494,1982,-1,797,794,796,-1,1981,2495,1980,-1,1979,800,2496,-1,1978,807,803,-1,1977,810,806,-1,1191,2497,814,-1,809,2498,1975,-1,806,810,821,-1,2499,2500,826,-1,1972,2501,1973,-1,1970,827,1971,-1,1969,2502,849,-1,1965,1968,833,-1,837,2503,854,-1,853,844,843,-1,1967,1971,1966,-1,832,849,840,-1,851,835,850,-1,844,1965,852,-1,838,854,853,-1,2504,829,855,-1,861,860,858,-1,2505,1963,1964,-1,1962,2506,1960,-1,843,862,845,-1,1959,846,863,-1,1953,842,1961,-1,862,2507,1958,-1,2508,2509,2510,-1,1957,2511,1955,-1,1954,866,842,-1,871,1948,1947,-1,1951,2512,1949,-1,1946,1948,2513,-1,1945,2514,876,-1,2515,1942,1944,-1,883,881,880,-1,1939,1936,878,-1,1937,2516,1938,-1,885,1935,1936,-1,1935,885,1933,-1,2517,1930,1932,-1,1928,1929,1927,-1,1925,1928,1927,-1,1924,1926,2518,-1,896,1550,1578,-1,2519,2520,2521,-1,2519,888,2520,-1,1923,2522,893,-1,899,1921,2523,-1,1919,902,903,-1,1917,877,1918,-1,884,1941,879,-1,1912,1911,797,-1,2524,1914,906,-1,2525,1911,1913,-1,2526,913,912,-1,2527,1903,920,-1,1901,910,1906,-1,2528,935,1905,-1,1903,939,1904,-1,1902,1910,910,-1,923,2529,1900,-1,924,949,2530,-1,932,921,959,-1,1899,2531,1898,-1,1895,1897,1898,-1,901,1891,1893,-1,2532,1887,1889,-1,1941,1886,953,-1,1887,1885,1888,-1,958,2533,1900,-1,1884,954,953,-1,960,1888,1885,-1,1884,962,932,-1,961,960,1883,-1,1882,792,1433,-1,972,970,1694,-1,2108,973,1684,-1,1433,2534,1730,-1,1730,2534,975,-1,1874,1876,1043,-1,1800,2535,1848,-1,1205,1845,2536,-1,1845,2537,2536,-1,1138,1411,1735,-1,2538,964,1025,-1,1773,1031,1854,-1,1003,1081,1004,-1,1360,1381,1380,-1,1869,1768,1783,-1,1864,2539,1865,-1,1651,1676,1022,-1,1280,1669,1715,-1,1389,2540,1390,-1,1282,1390,2540,-1,1770,1079,1861,-1,1860,1208,1762,-1,1216,2541,1859,-1,1425,1725,1426,-1,1856,1858,2542,-1,2164,1774,1162,-1,1853,2543,1028,-1,1032,2544,2545,-1,1165,1639,2546,-1,2547,2548,788,-1,1437,1439,1643,-1,1731,1643,1439,-1,1429,1642,998,-1,1879,2549,1874,-1,1432,2550,981,-1,1805,1804,1849,-1,1422,988,990,-1,1800,1848,988,-1,1047,2551,1048,-1,1140,1847,1411,-1,1846,2552,996,-1,1056,2553,2554,-1,1205,1207,1845,-1,2555,2556,2557,-1,1765,2558,2559,-1,1758,1757,2560,-1,1244,2561,2562,-1,1181,2563,2564,-1,1215,1217,1861,-1,1003,1274,1211,-1,1005,1004,1830,-1,1097,1448,1637,-1,2565,2566,2567,-1,813,1093,2568,-1,2568,1188,813,-1,1769,1096,1189,-1,792,1442,1443,-1,1105,1275,1825,-1,1638,1779,1167,-1,1821,1111,1822,-1,1113,1112,1820,-1,1823,1417,1819,-1,1820,1116,1819,-1,1117,1107,1118,-1,1816,2569,543,-1,1126,1125,1129,-1,1812,2570,997,-1,997,2570,1815,-1,1812,1130,2571,-1,1656,1658,1134,-1,2572,1136,1137,-1,1811,1653,2573,-1,2574,1133,2575,-1,1804,1806,2576,-1,1056,1058,2553,-1,1797,1279,1278,-1,2577,297,1659,-1,1424,1252,1182,-1,1255,1649,1144,-1,1145,1793,1146,-1,1784,2578,1789,-1,1789,2578,1787,-1,1786,2579,1154,-1,1785,1814,997,-1,1784,1789,1124,-1,816,1191,967,-1,1168,2492,780,-1,1099,2580,1779,-1,1104,1778,780,-1,1780,780,1166,-1,1056,1657,1655,-1,2581,1140,1775,-1,1868,1435,1852,-1,1161,2582,1782,-1,1774,2164,444,-1,448,1174,446,-1,1215,1078,2583,-1,1770,1862,1771,-1,1094,1769,1646,-1,1092,1783,1768,-1,1219,1765,1063,-1,1763,2584,1239,-1,976,975,2534,-1,1194,1227,1195,-1,1860,1762,1211,-1,1760,1761,2585,-1,1757,1759,2586,-1,1086,1083,1756,-1,2587,1753,1755,-1,1750,1752,2588,-1,1231,1749,1232,-1,1204,2589,1198,-1,1198,1748,1236,-1,1746,1231,1384,-1,1206,1059,1207,-1,2584,1238,2590,-1,1743,1242,1744,-1,1650,1246,1245,-1,1740,2591,1245,-1,1249,1245,1247,-1,2592,1007,1180,-1,1738,2593,1146,-1,1233,1240,1239,-1,1257,1256,1736,-1,1256,1447,1254,-1,1652,1412,1735,-1,1041,1040,1266,-1,1035,1037,1734,-1,1264,1044,1733,-1,1733,1432,999,-1,1733,1732,1731,-1,1642,1643,1731,-1,2594,1000,2595,-1,1725,1425,1728,-1,1727,1857,1725,-1,1722,1724,2596,-1,1831,513,1005,-1,1721,1397,1720,-1,2597,1717,2598,-1,1714,2599,1712,-1,1419,1150,1149,-1,1285,1154,2579,-1,1710,2600,1708,-1,1709,1704,1703,-1,534,1293,535,-1,1705,1301,1704,-1,1301,1292,1703,-1,1302,1301,542,-1,1697,1306,1305,-1,1702,1706,1697,-1,1307,1309,1701,-1,1700,1313,1127,-1,1385,1317,1316,-1,1785,1318,1699,-1,1319,1321,1322,-1,1322,1323,1291,-1,2601,1355,1324,-1,2601,2602,1355,-1,1325,1328,1327,-1,1696,1321,1320,-1,1325,1324,1357,-1,1338,1695,1345,-1,1357,1324,1355,-1,1691,1681,1680,-1,1692,2603,1693,-1,1342,1339,1680,-1,1338,1345,1344,-1,1682,1688,1690,-1,2604,1686,1687,-1,1692,2605,2603,-1,1349,2606,1354,-1,1010,293,1662,-1,1381,2607,1683,-1,1365,1687,1348,-1,1677,1120,1119,-1,1369,2608,1682,-1,1369,1010,1367,-1,1371,1341,1340,-1,1681,1372,1340,-1,1681,1691,1678,-1,1379,1378,1692,-1,1352,2606,1678,-1,1364,1120,1677,-1,1017,1020,1676,-1,971,1357,1673,-1,1143,2260,1653,-1,1246,1235,1248,-1,1386,1392,1175,-1,1388,1670,2609,-1,1022,1715,1669,-1,1282,1668,1390,-1,1664,1666,265,-1,1663,1280,1281,-1,1720,1401,1400,-1,1352,1367,1662,-1,1821,1123,1110,-1,2573,1653,1409,-1,1406,1405,1653,-1,1656,1655,1658,-1,2610,1054,1059,-1,1651,1669,967,-1,1415,1413,1017,-1,1150,1417,1416,-1,1315,1049,1777,-1,1206,1193,1224,-1,1244,2611,1744,-1,1424,1181,1743,-1,1086,1832,1081,-1,1648,2612,1267,-1,964,1435,1783,-1,1646,1429,997,-1,998,997,1429,-1,2549,1879,2613,-1,1874,1043,1879,-1,2534,1433,976,-1,1264,1041,790,-1,1441,1640,1442,-1,1033,1032,2545,-1,1772,1029,1031,-1,1097,1443,1098,-1,1259,1645,1445,-1,1259,1446,1637,-1,1254,974,1255,-1,2614,1522,1521,-1,1464,1449,1635,-1,1634,1451,1450,-1,1453,2615,1633,-1,1632,1458,1460,-1,1631,1449,1628,-1,1463,1462,1630,-1,1449,1465,1627,-1,1462,1626,1630,-1,1627,1465,1466,-1,1471,1470,1626,-1,1475,1466,1465,-1,1624,1473,1476,-1,1477,2616,1622,-1,1481,1621,1618,-1,1485,1481,1618,-1,1617,1613,1491,-1,1493,1460,1459,-1,1633,1494,1454,-1,1492,1612,1493,-1,1498,1457,1499,-1,1610,2617,1611,-1,1609,2618,1504,-1,1507,1607,1502,-1,1505,1504,1506,-1,1504,1507,1506,-1,1508,1506,1509,-1,1601,2619,1605,-1,495,2620,1604,-1,1516,1601,1603,-1,1599,1517,1519,-1,1596,1598,2621,-1,2622,1593,1595,-1,1525,1592,2623,-1,1579,1539,1537,-1,1582,1581,1527,-1,2624,897,2625,-1,2624,1548,1528,-1,1585,1584,1586,-1,1530,1574,1591,-1,1583,1526,1546,-1,1545,1544,1581,-1,1578,1550,1549,-1,1552,2626,1933,-1,1933,887,1552,-1,1934,1933,1581,-1,1573,1579,1590,-1,1570,2627,1571,-1,1567,1569,1549,-1,1577,1556,1575,-1,1565,936,1899,-1,1564,2628,1563,-1,1558,2629,904,-1,2459,514,1545,-1,1540,516,1561,-1,1583,1560,1545,-1,1545,1562,2459,-1,1558,926,1563,-1,944,1563,926,-1,1556,1577,1554,-1,2626,1527,1581,-1,2626,1552,1527,-1,1933,2626,1581,-1,1581,1591,1574,-1,1541,1537,2630,-1,1540,1580,1534,-1,1545,1582,1583,-1,1543,2630,1537,-1,1537,1539,1538,-1,2631,1586,1584,-1,1545,514,1547,-1,2624,2625,1585,-1,1534,1580,1532,-1,1588,1529,1531,-1,1523,2632,1524,-1,1517,2633,1518,-1,1516,1603,1514,-1,1511,495,1512,-1,2634,1508,1510,-1,1508,2635,1505,-1,1507,1502,1501,-1,1503,1608,1504,-1,2636,2617,1610,-1,2636,2623,2617,-1,1502,1607,1500,-1,1499,1457,2632,-1,1493,1612,1456,-1,1491,1615,1497,-1,1495,2637,1496,-1,1490,1492,1459,-1,1474,2638,1489,-1,2639,2640,2641,-1,2639,2642,2640,-1,1488,2643,1486,-1,1484,1482,1481,-1,1483,1620,1481,-1,1476,1472,1464,-1,1473,1475,1472,-1,2644,1469,1471,-1,1627,1466,1468,-1,1630,1626,1464,-1,2645,1461,1463,-1,2646,1629,1464,-1,1458,2647,1459,-1,1455,1632,1456,-1,1452,1454,1634,-1,1449,1451,1635,-1,1636,1255,974,-1,792,1445,1645,-1,1032,1638,1825,-1,1441,792,791,-1,2493,2648,1443,-1,1102,1780,1166,-1,1042,1264,1733,-1,1438,1265,1439,-1,1433,978,1263,-1,1234,976,1433,-1,978,980,1044,-1,983,1432,981,-1,1850,1642,1429,-1,1428,1850,1429,-1,443,1159,966,-1,1274,1003,1005,-1,1245,2591,1650,-1,1198,2589,1196,-1,1183,2649,1423,-1,985,1227,1226,-1,1049,1315,1421,-1,1289,1113,1419,-1,1414,1415,1187,-1,1415,1414,1413,-1,1115,1112,1818,-1,1059,991,993,-1,2572,1405,1123,-1,1135,1134,1410,-1,1809,1134,1133,-1,1288,1154,1711,-1,292,1010,1402,-1,1401,1370,1351,-1,1018,1397,1718,-1,1663,1015,2540,-1,2650,1393,1395,-1,2540,1389,1663,-1,1388,1392,1670,-1,2651,1669,1389,-1,1309,1699,1317,-1,1846,1140,2581,-1,1231,1203,1202,-1,1049,1671,1777,-1,1382,1193,1201,-1,1359,2607,1381,-1,969,1880,970,-1,1380,1381,1362,-1,1377,1379,2652,-1,1374,1376,1119,-1,1373,1371,1379,-1,1370,1401,1371,-1,1343,2608,1369,-1,1352,1679,1368,-1,2653,1364,1366,-1,1675,2654,2655,-1,2656,2657,1683,-1,1360,1546,1358,-1,1354,2606,1352,-1,1370,1349,1351,-1,1687,1346,1348,-1,1345,2658,1343,-1,1339,1338,1691,-1,1691,1680,1339,-1,1379,1692,1373,-1,1336,970,972,-1,1339,2659,1337,-1,1320,2660,1696,-1,538,537,1306,-1,1330,540,539,-1,2661,1327,1329,-1,1326,2601,1324,-1,1318,999,1316,-1,1431,2662,1432,-1,1313,1304,1312,-1,1310,1294,1314,-1,1316,1701,1385,-1,1316,2662,1701,-1,1314,1294,1308,-1,543,2569,1303,-1,1323,1703,1292,-1,1298,2663,1299,-1,1294,1296,1308,-1,531,530,534,-1,1292,1300,1293,-1,1114,1113,1290,-1,1290,1152,1114,-1,1157,1705,1286,-1,1285,2579,1122,-1,1283,1667,1282,-1,1280,1715,1021,-1,1666,266,265,-1,1672,969,971,-1,289,1761,1278,-1,1005,2664,1273,-1,1002,1863,1271,-1,964,2538,2665,-1,1439,1265,1040,-1,1044,1432,1733,-1,790,1644,1263,-1,1731,1042,1733,-1,2666,1234,1434,-1,2666,1248,1234,-1,1258,1447,1256,-1,2593,1254,1146,-1,1251,1247,1246,-1,1424,1247,1252,-1,1743,1181,1242,-1,1244,1744,1242,-1,2611,1748,1744,-1,1228,1238,1199,-1,1072,2611,1244,-1,1236,1748,2611,-1,1235,1240,1233,-1,1230,1203,1231,-1,1197,1239,1241,-1,1199,1238,2667,-1,1227,1799,1237,-1,1223,2668,1177,-1,283,1184,1423,-1,1229,234,2555,-1,1210,1209,1761,-1,1082,1081,1003,-1,1227,1228,1195,-1,1066,1202,1204,-1,1879,1799,1802,-1,1199,1201,1195,-1,1195,1201,1193,-1,2669,1192,966,-1,1190,1191,813,-1,1187,813,1188,-1,1418,1187,1189,-1,1186,1416,1096,-1,1075,1183,1185,-1,1177,1179,1425,-1,1425,1222,1177,-1,1174,1386,1175,-1,1032,1030,1029,-1,2670,1852,2671,-1,1852,1036,2671,-1,1132,1131,1155,-1,1658,1408,1134,-1,1655,1654,1777,-1,1171,1657,1056,-1,1171,2672,1169,-1,1168,1778,1167,-1,780,1781,1104,-1,1034,1030,1032,-1,1777,1310,1315,-1,1155,1700,1156,-1,1152,2600,1153,-1,2583,1078,1148,-1,288,1147,1210,-1,1793,1739,1146,-1,1180,1182,2592,-1,1846,996,995,-1,1777,1671,2673,-1,1049,1422,990,-1,1653,1410,1409,-1,1410,2572,1137,-1,1132,2571,1130,-1,1812,1814,1813,-1,1129,1125,1128,-1,973,2108,541,-1,1720,2652,1401,-1,1123,1821,1121,-1,1120,1109,1108,-1,2674,1406,2675,-1,1112,1116,1820,-1,1661,1285,1284,-1,1818,1112,1114,-1,1821,1110,1111,-1,1118,1107,1109,-1,742,780,740,-1,1167,1778,1824,-1,2676,1781,1101,-1,1032,1825,1275,-1,2677,1260,1262,-1,1096,1769,1094,-1,1301,2678,1791,-1,2679,2680,2681,-1,2682,1005,1087,-1,512,1087,513,-1,1761,1209,2585,-1,1084,1770,1085,-1,1006,1771,2683,-1,1180,2684,2685,-1,2649,2686,1216,-1,1243,2687,2688,-1,1759,2689,2586,-1,1384,2690,2691,-1,2588,1224,1382,-1,1062,1061,1752,-1,1061,1225,1752,-1,1383,1747,1750,-1,1059,993,2692,-1,1054,2693,1798,-1,1801,2694,1803,-1,1799,2535,1800,-1,1432,983,1878,-1,1879,2695,2613,-1,1642,1850,1437,-1,1040,1042,1731,-1,1264,1042,1041,-1,1869,2670,2696,-1,964,2665,1734,-1,1277,2697,1275,-1,966,1160,1024,-1,1161,1163,2582,-1,1028,1774,1026,-1,1076,2698,1077,-1,2650,1395,1867,-1,1669,1280,1663,-1,1676,2699,1022,-1,1397,1396,1720,-1,1017,1413,1018,-1,1013,1283,1011,-1,1583,1546,1360,-1,1182,2700,2592,-1,1000,1002,2595,-1,999,1318,997,-1,994,996,2701,-1,2554,2702,2552,-1,1804,2576,2695,-1,492,974,1448,-1,1684,1561,516,-1,1560,1583,1380,-1,2450,2703,817,-1,790,963,1644,-1,960,962,1884,-1,954,959,955,-1,958,2704,956,-1,953,955,2705,-1,904,1889,952,-1,948,2706,946,-1,943,1564,944,-1,936,1566,937,-1,932,962,930,-1,927,1883,928,-1,1559,924,926,-1,921,923,959,-1,1903,918,920,-1,917,2707,915,-1,914,1906,912,-1,905,1919,903,-1,902,1920,900,-1,897,2708,898,-1,894,896,2709,-1,893,2520,891,-1,885,887,1933,-1,890,889,1578,-1,2710,2711,892,-1,878,1936,883,-1,880,882,905,-1,877,1917,878,-1,876,2712,874,-1,871,1952,872,-1,868,870,2713,-1,843,842,866,-1,2714,2715,2716,-1,843,2507,862,-1,865,1959,864,-1,846,845,862,-1,1961,842,1962,-1,1964,841,861,-1,859,865,857,-1,856,838,847,-1,854,1965,844,-1,833,835,851,-1,830,832,839,-1,849,1967,848,-1,847,853,845,-1,844,852,842,-1,841,1963,839,-1,856,836,838,-1,834,2717,835,-1,831,1969,832,-1,1971,827,829,-1,1973,2501,2718,-1,826,2500,824,-1,821,1976,822,-1,818,820,2719,-1,2720,2721,1972,-1,2721,2501,1972,-1,2722,2669,1767,-1,2723,1783,1092,-1,810,1977,811,-1,807,1978,808,-1,804,2724,805,-1,802,1980,800,-1,799,1915,797,-1,794,2494,795,-1,1262,2725,2677,-1,791,1984,1441,-1,787,783,782,-1,782,1444,2726,-1,2727,776,778,-1,775,754,773,-1,751,2728,774,-1,767,1990,772,-1,771,2729,769,-1,766,1990,767,-1,764,2730,765,-1,761,2731,762,-1,759,1992,757,-1,1985,1992,753,-1,749,744,1999,-1,748,2029,707,-1,745,2030,743,-1,744,746,698,-1,743,748,701,-1,739,2031,737,-1,2002,2485,2732,-1,2732,2733,2002,-1,2734,2735,2736,-1,709,729,2009,-1,736,727,2737,-1,725,735,723,-1,722,717,733,-1,732,719,714,-1,731,733,729,-1,728,732,726,-1,724,2738,725,-1,720,2480,721,-1,717,2739,718,-1,714,2013,715,-1,712,2740,713,-1,710,2022,708,-1,707,2028,705,-1,704,2732,702,-1,701,2485,699,-1,698,2741,696,-1,694,2475,695,-1,687,686,692,-1,684,683,690,-1,689,694,688,-1,685,2742,686,-1,682,681,683,-1,677,622,682,-1,616,625,2055,-1,678,676,679,-1,676,673,674,-1,2474,629,672,-1,668,674,673,-1,665,664,672,-1,671,663,662,-1,669,660,659,-1,657,656,666,-1,654,2043,664,-1,663,2045,661,-1,660,649,658,-1,655,2477,656,-1,653,2043,654,-1,651,658,649,-1,647,648,2743,-1,646,2047,642,-1,643,645,647,-1,640,2476,641,-1,639,2056,2044,-1,688,636,635,-1,689,625,682,-1,634,2744,631,-1,629,631,2744,-1,628,624,626,-1,634,637,2744,-1,620,621,623,-1,619,2474,620,-1,2473,2745,630,-1,2746,2747,627,-1,610,2071,609,-1,608,344,607,-1,604,606,591,-1,2748,601,603,-1,612,611,599,-1,598,2076,599,-1,596,2077,597,-1,590,604,591,-1,589,588,558,-1,586,2081,587,-1,585,2083,583,-1,2467,578,2749,-1,578,2750,2749,-1,582,2751,581,-1,580,2750,578,-1,576,2089,574,-1,573,2752,571,-1,2464,567,570,-1,568,2753,569,-1,565,2095,566,-1,561,550,549,-1,552,550,561,-1,560,589,558,-1,546,2754,557,-1,555,2462,556,-1,551,2104,552,-1,550,545,548,-1,607,2755,2251,-1,542,544,531,-1,2106,522,1128,-1,541,525,539,-1,536,522,537,-1,515,514,2459,-1,2756,2757,2758,-1,2756,2759,2757,-1,532,2760,533,-1,531,2110,529,-1,2761,1562,2107,-1,527,2108,515,-1,524,536,525,-1,519,2109,544,-1,520,1128,522,-1,518,2109,519,-1,1540,514,516,-1,2762,6,8,-1,1831,488,513,-1,1830,489,1831,-1,505,2763,511,-1,510,503,487,-1,509,2763,507,-1,1625,504,506,-1,502,503,510,-1,499,501,2116,-1,493,495,1511,-1,490,1029,488,-1,474,487,503,-1,485,2764,483,-1,481,482,2765,-1,2455,478,480,-1,476,2455,477,-1,474,478,475,-1,469,476,470,-1,471,465,2122,-1,2123,2766,2453,-1,465,467,2127,-1,2767,2128,2134,-1,2134,460,2767,-1,464,2138,463,-1,2143,455,2452,-1,2452,2132,2143,-1,462,2133,457,-1,460,2134,458,-1,456,2144,457,-1,463,450,452,-1,2149,968,449,-1,92,2155,436,-1,294,438,114,-1,440,448,446,-1,2164,428,2159,-1,425,431,432,-1,430,418,2768,-1,2769,2447,435,-1,2164,2159,2445,-1,421,2770,419,-1,418,2160,416,-1,415,432,413,-1,410,2169,411,-1,407,2771,408,-1,404,2772,405,-1,401,2773,402,-1,398,400,2774,-1,2179,2775,442,-1,395,2180,396,-1,2776,1279,1797,-1,2777,2778,2428,-1,2184,391,392,-1,391,388,390,-1,2779,313,385,-1,225,255,2217,-1,382,366,381,-1,2437,2198,2780,-1,2203,378,380,-1,2210,2781,2211,-1,376,2212,377,-1,373,2432,374,-1,369,2216,370,-1,355,165,353,-1,366,382,365,-1,196,2233,244,-1,363,2782,364,-1,2783,2784,2229,-1,2785,392,2232,-1,366,2233,2193,-1,366,244,2233,-1,2234,2233,312,-1,344,2472,343,-1,2425,346,350,-1,2241,592,591,-1,342,330,329,-1,341,2096,340,-1,339,340,337,-1,336,2466,334,-1,331,330,332,-1,326,328,2421,-1,323,325,2422,-1,300,322,2244,-1,319,306,320,-1,304,315,314,-1,343,2786,318,-1,317,344,318,-1,310,2420,311,-1,308,2787,309,-1,306,319,304,-1,303,2788,301,-1,300,316,298,-1,2267,1,2266,-1,263,266,264,-1,1392,115,1175,-1,262,296,293,-1,214,144,143,-1,2255,18,2256,-1,115,1176,1175,-1,286,145,2789,-1,285,158,218,-1,1147,127,2318,-1,280,61,24,-1,275,274,277,-1,258,156,2790,-1,184,2321,272,-1,93,271,94,-1,269,2791,267,-1,265,263,2264,-1,2380,115,1394,-1,2267,1402,7,-1,2269,260,259,-1,259,261,2253,-1,262,2266,2254,-1,246,248,257,-1,257,2412,2295,-1,2792,247,129,-1,2271,2793,2272,-1,2233,195,312,-1,223,191,172,-1,242,2794,243,-1,240,132,159,-1,238,2795,220,-1,233,2796,236,-1,213,212,234,-1,231,124,2283,-1,2291,209,205,-1,228,2290,229,-1,2797,2412,2221,-1,224,2220,222,-1,134,2294,221,-1,220,284,218,-1,2399,215,217,-1,212,214,291,-1,211,205,209,-1,208,2289,206,-1,2400,169,2798,-1,198,2279,2411,-1,130,240,2401,-1,239,2799,2800,-1,204,2276,197,-1,191,148,147,-1,148,191,193,-1,383,192,249,-1,189,118,117,-1,152,2801,188,-1,185,187,2409,-1,182,184,273,-1,103,189,2802,-1,2803,2300,2406,-1,179,2299,177,-1,175,2804,136,-1,257,2295,258,-1,147,2296,171,-1,168,2306,166,-1,2312,2302,2301,-1,2805,2306,2806,-1,2314,2309,2308,-1,158,2807,159,-1,152,154,2407,-1,151,167,149,-1,146,193,2408,-1,2401,2800,2291,-1,139,2286,140,-1,2301,136,138,-1,2222,2805,2312,-1,2301,176,136,-1,94,2273,126,-1,2298,2313,2808,-1,2428,2778,2784,-1,2809,92,436,-1,122,12,120,-1,119,2322,111,-1,12,110,116,-1,279,117,99,-1,2810,112,2323,-1,112,2810,113,-1,2405,2314,2299,-1,2325,101,100,-1,2323,107,2810,-1,105,2811,2394,-1,2329,113,2313,-1,2330,2154,98,-1,95,2417,93,-1,2809,91,92,-1,88,2393,164,-1,2156,2446,86,-1,82,2352,83,-1,74,2340,2359,-1,80,71,70,-1,63,2391,80,-1,2341,74,76,-1,17,2371,72,-1,2812,69,71,-1,68,80,38,-1,30,47,2336,-1,2353,2352,2339,-1,2355,2388,2387,-1,65,2387,41,-1,61,25,24,-1,77,2389,78,-1,60,2385,58,-1,55,57,2813,-1,54,2814,52,-1,50,2363,20,-1,50,2364,29,-1,33,2815,27,-1,48,2816,47,-1,46,84,44,-1,2383,2334,2333,-1,41,2388,42,-1,37,36,39,-1,2388,41,2387,-1,33,35,2817,-1,35,34,2364,-1,32,48,30,-1,47,2351,2336,-1,25,2359,26,-1,21,23,2342,-1,18,20,2363,-1,17,75,15,-1,14,2372,2371,-1,12,115,13,-1,2818,2819,2374,-1,2376,1,2377,-1,6,2762,5,-1,2268,2266,2270,-1,2268,2254,2266,-1,2383,2820,2365,-1,2820,2383,2818,-1,2269,2377,2821,-1,2269,2376,2377,-1,2822,58,2823,-1,2822,59,58,-1,2824,2825,2826,-1,2824,2827,2825,-1,2357,52,2358,-1,2357,53,52,-1,2828,2370,82,-1,2828,2347,2370,-1,2368,2829,2830,-1,2368,2367,2829,-1,2364,2362,2338,-1,2364,50,2362,-1,2354,2822,2386,-1,2354,2831,2822,-1,2832,2361,2360,-1,2832,2833,2361,-1,2834,63,2835,-1,63,2834,2391,-1,2826,2836,2824,-1,2836,2826,66,-1,2332,2837,2333,-1,2837,2332,2389,-1,2386,83,2354,-1,2335,83,2386,-1,2363,2336,2256,-1,2336,2363,49,-1,2386,2823,79,-1,2386,2822,2823,-1,2838,31,28,-1,2838,32,31,-1,2382,23,2831,-1,2342,23,2382,-1,2339,2370,2337,-1,2339,2352,2370,-1,2319,2839,2840,-1,2319,2841,2839,-1,111,89,2331,-1,111,113,89,-1,181,2842,2843,-1,2842,181,100,-1,2808,113,2810,-1,2808,2313,113,-1,99,280,279,-1,99,101,280,-1,91,2154,2330,-1,2154,91,2809,-1,108,178,177,-1,108,106,178,-1,2326,2844,2845,-1,2844,2326,2328,-1,2320,2841,2319,-1,2841,2320,2846,-1,2310,367,2403,-1,2804,367,2310,-1,203,2317,204,-1,203,2847,2317,-1,2292,2848,201,-1,2292,2799,2848,-1,285,243,2794,-1,2402,243,285,-1,2306,2222,166,-1,2805,2222,2306,-1,174,140,2305,-1,141,140,174,-1,166,137,2303,-1,138,137,166,-1,2404,2299,179,-1,2405,2299,2404,-1,2185,2849,2850,-1,2849,2185,2851,-1,2852,2418,2853,-1,2854,2418,2852,-1,2410,1142,2297,-1,2263,1142,2410,-1,2799,2855,2848,-1,239,2855,2799,-1,2275,2847,2856,-1,2275,2317,2847,-1,2277,2287,229,-1,2277,2288,2287,-1,2857,237,236,-1,237,2857,290,-1,2858,2285,2859,-1,2858,2284,2285,-1,207,2860,2791,-1,207,221,2860,-1,2287,269,2861,-1,2287,208,269,-1,2280,202,2278,-1,2280,200,202,-1,2276,2289,197,-1,206,2289,2276,-1,2295,2797,171,-1,2797,2295,2412,-1,2862,1221,2863,-1,2864,1221,2862,-1,1218,2274,2795,-1,1218,283,2274,-1,2865,2398,2866,-1,2865,2864,2398,-1,2274,2284,2858,-1,2274,282,2284,-1,2867,190,2868,-1,189,190,2867,-1,2794,2855,2807,-1,242,2855,2794,-1,194,348,195,-1,194,162,348,-1,2869,2,2375,-1,2870,2,2869,-1,262,2253,263,-1,2253,262,2254,-1,1664,2380,1393,-1,2265,2380,1664,-1,2297,2261,291,-1,1142,2261,2297,-1,142,183,187,-1,183,142,2871,-1,189,2839,2802,-1,189,2867,2839,-1,2790,2285,258,-1,2315,2285,2790,-1,24,117,279,-1,24,2814,117,-1,2852,2872,2854,-1,2813,2872,2852,-1,2360,273,272,-1,2360,2385,273,-1,185,19,2410,-1,185,21,19,-1,2396,61,280,-1,61,2396,15,-1,327,2873,2874,-1,2873,327,326,-1,2875,317,316,-1,2755,317,2875,-1,2876,2250,2251,-1,2250,2876,2874,-1,338,303,302,-1,303,338,337,-1,2248,2421,328,-1,2248,2246,2421,-1,335,2245,331,-1,335,2423,2245,-1,2243,2079,2247,-1,2080,2079,2243,-1,310,607,2251,-1,2241,607,310,-1,2238,343,2472,-1,2238,2237,343,-1,2877,2070,2878,-1,2070,2877,2071,-1,2067,345,347,-1,345,2067,2239,-1,371,2879,2880,-1,371,2881,2879,-1,2882,2225,2883,-1,2882,372,2225,-1,2884,2792,2776,-1,2884,2885,2792,-1,355,245,2884,-1,355,353,245,-1,2415,2886,385,-1,2886,2415,188,-1,2887,2888,2889,-1,2890,2888,2887,-1,2891,2892,2893,-1,2891,2894,2892,-1,2890,2895,2896,-1,2890,2887,2895,-1,2889,2897,2887,-1,2898,2897,2889,-1,2899,2893,2892,-1,2899,2900,2893,-1,2901,2433,2881,-1,2901,2434,2433,-1,2214,2223,2213,-1,2223,2214,362,-1,2435,2902,2210,-1,2435,373,2902,-1,2901,2204,379,-1,2901,370,2204,-1,2212,2437,2213,-1,2437,2212,2199,-1,2436,2209,2208,-1,2436,2435,2209,-1,2200,2202,2201,-1,2200,2199,2202,-1,2781,2903,2211,-1,2903,2781,2062,-1,2205,2904,2905,-1,2205,2206,2904,-1,2906,2201,2907,-1,2906,2200,2201,-1,2880,360,361,-1,360,2880,2879,-1,364,357,359,-1,357,364,2782,-1,2429,364,359,-1,2430,364,2429,-1,2416,2908,2183,-1,2909,2908,2416,-1,2229,2195,2197,-1,2784,2195,2229,-1,2899,2416,2194,-1,2899,2909,2416,-1,2191,2197,2195,-1,255,2197,2191,-1,2900,2194,2193,-1,2900,2899,2194,-1,2192,2910,2190,-1,2192,2911,2910,-1,2190,2912,251,-1,2190,2910,2912,-1,389,2779,385,-1,388,2779,389,-1,386,2185,387,-1,2185,386,2851,-1,358,2913,2186,-1,2230,2913,358,-1,357,2230,358,-1,357,2231,2230,-1,392,2427,2426,-1,2427,392,2785,-1,2914,2915,2916,-1,2914,2917,2915,-1,393,2776,1797,-1,393,2918,2776,-1,497,608,2072,-1,497,496,608,-1,2182,2919,2440,-1,2919,2182,2920,-1,500,2441,2182,-1,500,499,2441,-1,2921,2177,2922,-1,2442,2177,2921,-1,2774,2443,2923,-1,400,2443,2774,-1,2924,2925,2926,-1,2924,2927,2925,-1,2173,2928,2174,-1,1192,2928,2173,-1,2172,2929,397,-1,2171,2929,2172,-1,2930,2931,2921,-1,2932,2931,2930,-1,2931,2773,401,-1,2931,2932,2773,-1,407,2171,2771,-1,2929,2171,407,-1,2933,2934,2444,-1,2933,2935,2934,-1,402,2924,403,-1,402,2927,2924,-1,2936,408,2937,-1,409,408,2936,-1,2170,2938,2939,-1,2170,2940,2938,-1,2153,2923,2451,-1,2153,2176,2923,-1,2451,2443,2151,-1,2923,2443,2451,-1,433,2148,449,-1,437,2148,433,-1,2941,2167,2168,-1,2942,2167,2941,-1,2943,420,2944,-1,2945,420,2943,-1,2167,2946,417,-1,2946,2167,2947,-1,2445,413,431,-1,2445,2160,413,-1,2448,2941,427,-1,2448,2948,2941,-1,2948,2447,423,-1,2448,2447,2948,-1,440,434,433,-1,87,434,440,-1,2949,2947,2147,-1,2949,2946,2947,-1,456,2950,2144,-1,456,2951,2950,-1,2952,453,451,-1,2952,2953,453,-1,458,2949,459,-1,458,2140,2949,-1,2146,2136,2135,-1,2146,2137,2136,-1,454,2130,2129,-1,454,2131,2130,-1,462,467,2133,-1,2127,467,462,-1,2129,2954,2124,-1,2954,2129,2130,-1,2955,2136,468,-1,2955,2135,2136,-1,2956,2957,2958,-1,2956,2959,2957,-1,466,2960,2958,-1,2454,2960,466,-1,475,2125,473,-1,475,2126,2125,-1,2456,472,471,-1,2456,484,472,-1,486,2961,2120,-1,2961,486,2962,-1,2456,2963,2121,-1,2456,2964,2963,-1,2965,2966,2967,-1,2965,2968,2966,-1,2115,502,504,-1,2115,2114,502,-1,1624,1622,2115,-1,1623,1622,1624,-1,2969,2616,2970,-1,2969,2971,2616,-1,2119,2972,2973,-1,2118,2972,2119,-1,508,1488,509,-1,508,2643,1488,-1,494,1603,1602,-1,494,493,1603,-1,2112,524,2974,-1,524,2112,523,-1,2111,2107,529,-1,2111,2975,2107,-1,2976,527,2977,-1,527,2976,526,-1,2978,2979,2980,-1,2981,2979,2978,-1,2982,2974,2983,-1,2112,2974,2982,-1,2984,2111,2985,-1,2975,2111,2984,-1,2986,2987,2988,-1,2986,2989,2987,-1,2757,2990,2991,-1,2759,2990,2757,-1,2992,2993,2994,-1,2993,2992,2995,-1,2996,2997,2998,-1,2999,2997,2996,-1,3000,2758,3001,-1,3000,2756,2758,-1,3002,3003,3004,-1,3002,3005,3003,-1,3006,3007,3008,-1,3009,3007,3006,-1,3010,3011,3012,-1,3010,3013,3011,-1,3014,3015,3016,-1,3014,3017,3015,-1,3018,3019,3020,-1,3021,3019,3018,-1,3022,3023,3024,-1,3025,3023,3022,-1,3026,3027,3028,-1,3026,3029,3027,-1,3030,3031,3032,-1,3033,3031,3030,-1,3034,3035,3036,-1,3034,3037,3035,-1,3038,3039,3040,-1,3039,3038,3041,-1,3042,3043,3044,-1,3042,3045,3043,-1,3046,3047,3048,-1,3046,3049,3047,-1,3050,3051,3052,-1,3051,3050,3053,-1,1329,1336,972,-1,1336,1329,1328,-1,1300,535,1293,-1,1300,1302,535,-1,3054,2105,571,-1,3055,2105,3054,-1,582,3056,3057,-1,2086,3056,582,-1,3058,3059,3060,-1,3058,3061,3059,-1,2102,3062,2091,-1,2101,3062,2102,-1,2463,2098,2097,-1,2463,2099,2098,-1,560,2095,565,-1,560,559,2095,-1,3063,554,557,-1,554,3063,3064,-1,3064,555,554,-1,555,3064,3065,-1,3066,571,2752,-1,3066,3054,571,-1,2093,575,2094,-1,575,2093,576,-1,2101,3067,3062,-1,2101,3068,3067,-1,2084,574,2089,-1,2085,574,2084,-1,2083,2084,583,-1,2083,2085,2084,-1,3057,2751,582,-1,3069,2751,3057,-1,3070,2467,2749,-1,3071,2467,3070,-1,3072,3061,3058,-1,3061,3072,3073,-1,3070,3074,3071,-1,3074,3070,3075,-1,3073,3076,3061,-1,3076,3073,3077,-1,3078,2461,553,-1,3078,3079,2461,-1,2099,3080,2098,-1,2099,3081,3080,-1,3082,2754,3083,-1,2754,3082,3084,-1,2075,3085,3086,-1,2074,3085,2075,-1,2066,3087,3088,-1,3087,2066,3089,-1,3090,2468,3091,-1,3090,2073,2468,-1,2078,498,2469,-1,498,2078,610,-1,3092,2078,2471,-1,2078,3092,2070,-1,3092,2878,2070,-1,3092,3093,2878,-1,2235,2068,2067,-1,2068,2235,3094,-1,3088,3095,3096,-1,3088,3087,3095,-1,3097,3098,3099,-1,3097,3095,3098,-1,3100,3099,3098,-1,3099,3100,3101,-1,3102,3101,3100,-1,3101,3102,3103,-1,3102,2469,3103,-1,3102,2470,2469,-1,2937,3104,2936,-1,3104,2937,3105,-1,2058,2062,2057,-1,2058,2903,2062,-1,2905,626,2059,-1,626,2905,2904,-1,2906,633,631,-1,633,2906,2907,-1,633,2042,634,-1,3106,2042,633,-1,695,2051,636,-1,695,2054,2051,-1,3107,2049,2475,-1,3107,2048,2049,-1,2046,2049,2048,-1,2049,2046,2050,-1,653,2050,2046,-1,2050,653,652,-1,2743,661,2045,-1,2743,648,661,-1,671,3108,3109,-1,671,670,3108,-1,678,3110,3111,-1,3110,678,621,-1,679,685,680,-1,679,2742,685,-1,689,2055,625,-1,2055,689,635,-1,2037,2034,2032,-1,2037,2035,2034,-1,2476,692,2052,-1,693,692,2476,-1,2428,358,2850,-1,2428,359,358,-1,3112,2031,3113,-1,1998,2031,3112,-1,3114,3115,3116,-1,3114,3117,3115,-1,749,2013,718,-1,749,3118,2013,-1,2480,2029,2030,-1,2481,2029,2480,-1,2006,2482,2025,-1,2482,2006,3119,-1,736,2009,728,-1,3120,2009,736,-1,2014,3121,3122,-1,3123,3121,2014,-1,3124,3125,3126,-1,3124,3127,3125,-1,3128,3129,3130,-1,3128,3131,3129,-1,1987,2019,2018,-1,1987,3132,2019,-1,2015,3133,2016,-1,2015,3134,3133,-1,3135,3136,3137,-1,3135,3130,3136,-1,734,2026,705,-1,3138,2026,734,-1,3139,3140,2003,-1,3140,3139,2010,-1,2010,711,3140,-1,2010,716,711,-1,3141,713,3138,-1,3142,713,3141,-1,2007,708,2021,-1,2007,2008,708,-1,2005,3143,2024,-1,2005,2004,3143,-1,736,3144,3127,-1,736,2737,3144,-1,3145,2483,2022,-1,3122,2483,3145,-1,3131,2023,3129,-1,3131,3146,2023,-1,3147,786,3148,-1,3147,3149,786,-1,3150,2734,2736,-1,3150,2733,2734,-1,3151,3152,3153,-1,3151,3154,3152,-1,782,3148,786,-1,782,2726,3148,-1,3155,704,3117,-1,2734,704,3155,-1,3156,696,3154,-1,3156,3157,696,-1,1994,3112,1995,-1,1994,1998,3112,-1,703,747,2487,-1,703,702,747,-1,1993,3158,3159,-1,3158,1993,1995,-1,778,3160,3161,-1,777,3160,778,-1,3162,3163,3164,-1,3163,3162,3165,-1,3166,3167,762,-1,3166,3168,3167,-1,3169,3170,3171,-1,3169,3172,3170,-1,3173,3172,3169,-1,3173,2727,3172,-1,761,2727,3173,-1,761,776,2727,-1,760,776,761,-1,760,3174,776,-1,3175,3174,760,-1,3175,3176,3174,-1,3177,3178,3179,-1,3177,3180,3178,-1,757,3181,758,-1,757,2489,3181,-1,3180,3182,3178,-1,3180,3183,3182,-1,3184,3181,2489,-1,3184,3185,3181,-1,3183,3186,3182,-1,3183,3187,3186,-1,3188,3189,3190,-1,3189,3188,3191,-1,2731,3173,3192,-1,761,3173,2731,-1,3193,3190,3194,-1,3190,3193,3188,-1,3192,3169,3165,-1,3173,3169,3192,-1,3195,3193,3194,-1,3195,3196,3193,-1,2491,3197,3198,-1,2491,3199,3197,-1,2729,2730,764,-1,2729,771,2730,-1,3199,1991,3200,-1,2491,1991,3199,-1,774,3200,1991,-1,774,2728,3200,-1,3172,778,3201,-1,3172,2727,778,-1,3202,3203,1989,-1,3202,3204,3203,-1,3204,3179,3203,-1,3204,3177,3179,-1,740,3205,3206,-1,781,3205,740,-1,1982,3207,1983,-1,1982,3208,3207,-1,3209,1979,2496,-1,3210,1979,3209,-1,3211,2720,3212,-1,2721,2720,3211,-1,3213,819,818,-1,3213,3214,819,-1,1976,810,809,-1,810,1976,821,-1,803,2718,804,-1,803,2499,2718,-1,1975,3215,3216,-1,1975,3217,3215,-1,2503,2499,1968,-1,2718,2499,2503,-1,3216,1970,2502,-1,3216,3215,1970,-1,834,825,2717,-1,826,825,834,-1,2502,1967,849,-1,2502,1970,1967,-1,865,855,1959,-1,855,865,2504,-1,851,2506,1962,-1,850,2506,851,-1,1960,1963,2505,-1,1960,2506,1963,-1,2508,858,2715,-1,2508,861,858,-1,1955,1961,1960,-1,1953,1961,1955,-1,864,1958,3218,-1,864,863,1958,-1,2510,1957,1956,-1,1957,2510,2509,-1,3219,1958,2507,-1,3220,1958,3219,-1,3221,2715,3222,-1,3221,2508,2715,-1,1954,3223,3224,-1,1954,2511,3223,-1,3219,3225,3220,-1,3225,3219,3226,-1,1947,3227,1952,-1,3227,1947,1943,-1,3228,3229,3230,-1,3228,3231,3229,-1,3232,3233,3234,-1,869,3233,3232,-1,3235,3236,3237,-1,3235,3222,3236,-1,3238,3239,3240,-1,3238,3241,3239,-1,3242,3243,3244,-1,3242,3245,3243,-1,3241,3246,3247,-1,3246,3241,3238,-1,3248,3245,3242,-1,3248,3249,3245,-1,3246,3250,3247,-1,3251,3250,3246,-1,3252,3249,3248,-1,3252,3253,3249,-1,3250,3254,3255,-1,3254,3250,3251,-1,3256,3252,3257,-1,3256,3253,3252,-1,3255,3258,3259,-1,3258,3255,3254,-1,3260,3257,3261,-1,3260,3256,3257,-1,3259,3262,3263,-1,3262,3259,3258,-1,3264,3261,3265,-1,3264,3260,3261,-1,3263,3266,3267,-1,3266,3263,3262,-1,1951,3265,3268,-1,1951,3264,3265,-1,3266,2513,3267,-1,3269,2513,3266,-1,2512,3268,3270,-1,2512,1951,3268,-1,3225,1949,2514,-1,3225,3226,1949,-1,1952,3271,872,-1,1952,3227,3271,-1,3272,2514,1945,-1,3272,3225,2514,-1,1944,3273,2515,-1,3273,1944,3274,-1,3275,875,874,-1,3275,3276,875,-1,2515,3240,3239,-1,3240,2515,3273,-1,900,3277,3278,-1,900,3279,3277,-1,1938,1917,1916,-1,1938,1939,1917,-1,886,1936,1939,-1,886,885,1936,-1,882,3280,3281,-1,2517,3280,882,-1,3282,3277,3283,-1,3282,3284,3277,-1,891,3285,3286,-1,891,890,3285,-1,3287,3288,3289,-1,3288,3287,3290,-1,1931,1935,1934,-1,1930,1935,1931,-1,1573,1928,3291,-1,1573,1590,1928,-1,3292,1571,2627,-1,1571,3292,3293,-1,1927,3294,1926,-1,1927,3295,3294,-1,3296,1924,3297,-1,3296,1925,1924,-1,1568,3285,1569,-1,1568,3298,3285,-1,2518,3299,2711,-1,2518,3300,3299,-1,889,2519,3301,-1,889,888,2519,-1,1922,3302,1923,-1,1922,3303,3302,-1,3301,2708,1575,-1,3301,2519,2708,-1,1923,3304,3305,-1,1923,3302,3304,-1,886,1554,887,-1,886,3306,1554,-1,904,880,905,-1,904,951,880,-1,1916,1891,1937,-1,1916,1918,1891,-1,3208,907,3210,-1,3208,909,907,-1,1981,3307,3308,-1,802,3307,1981,-1,3309,797,1911,-1,797,3309,794,-1,3308,3310,3311,-1,3308,3307,3310,-1,1911,3312,3309,-1,3312,1911,2525,-1,935,1908,933,-1,917,1908,935,-1,919,3313,1907,-1,919,3314,3313,-1,3315,915,2707,-1,915,3315,2524,-1,1901,3316,1902,-1,1901,1913,3316,-1,3317,3318,3319,-1,3317,3320,3318,-1,3321,3320,3317,-1,2528,917,935,-1,917,2528,2707,-1,3322,938,937,-1,3322,3323,938,-1,2705,1900,2533,-1,955,1900,2705,-1,3324,3322,1909,-1,3322,3324,3323,-1,925,2530,3325,-1,924,2530,925,-1,1883,2532,928,-1,1883,1887,2532,-1,1883,1885,1887,-1,929,3326,927,-1,929,1896,3326,-1,929,3327,1896,-1,2704,3328,3329,-1,2704,2529,3328,-1,1908,3330,3331,-1,1908,3332,3330,-1,3333,1899,930,-1,3333,2531,1899,-1,1565,1897,943,-1,1898,1897,1565,-1,3334,2526,3335,-1,2526,3334,942,-1,946,3335,947,-1,3335,946,3334,-1,3336,2532,1889,-1,928,2532,3336,-1,3337,3338,3339,-1,3338,3337,3340,-1,1893,953,2705,-1,1891,953,1893,-1,3317,3339,3341,-1,3339,3317,3337,-1,1886,960,1884,-1,1888,960,1886,-1,791,795,1983,-1,793,795,791,-1,788,1980,2495,-1,2548,1980,788,-1,1984,3209,1261,-1,1984,3207,3209,-1,1766,3211,1767,-1,1766,2724,3211,-1,3342,814,2497,-1,3342,811,814,-1,812,808,1091,-1,812,1977,808,-1,3343,1874,2549,-1,1875,1874,3343,-1,3344,1845,1844,-1,2537,1845,3344,-1,1847,1735,1411,-1,1847,3345,1735,-1,3346,2544,2596,-1,3346,2545,2544,-1,1727,2565,3347,-1,1727,2566,2565,-1,1855,3348,1089,-1,1855,3349,3348,-1,1030,1854,1031,-1,1030,1853,1854,-1,2681,1272,1753,-1,2681,2680,1272,-1,1865,1712,2599,-1,1865,1867,1712,-1,2539,3350,3351,-1,3350,2539,1864,-1,1015,1282,2540,-1,1015,1014,1282,-1,1668,1713,1395,-1,1667,1713,1668,-1,2698,1836,1077,-1,2698,3352,1836,-1,2664,3353,1760,-1,3354,3353,2664,-1,3355,3356,3357,-1,1755,3356,3355,-1,1080,1770,1084,-1,1079,1770,1080,-1,1760,1273,2664,-1,1760,2585,1273,-1,2542,3358,3359,-1,3358,2542,1858,-1,1163,3360,2582,-1,1163,3361,3360,-1,1723,1159,1724,-1,1160,1159,1723,-1,1723,2538,1025,-1,1722,2538,1723,-1,1852,1037,1036,-1,1037,1852,1436,-1,2677,3362,2671,-1,2677,2547,3362,-1,1044,2550,1432,-1,2550,1044,1045,-1,979,1876,3363,-1,979,1877,1876,-1,985,1873,986,-1,1051,1873,985,-1,1412,1052,1143,-1,1052,1412,1053,-1,2693,994,1798,-1,3345,994,2693,-1,1746,1750,1747,-1,1746,1751,1750,-1,2562,2586,2689,-1,2586,2562,2561,-1,2564,2698,1076,-1,2564,2563,2698,-1,1860,1274,1273,-1,1274,1860,1211,-1,3358,3348,3364,-1,3358,3365,3348,-1,3366,1213,2150,-1,3366,1214,1213,-1,2668,3367,3368,-1,2668,1223,3367,-1,3369,2612,1212,-1,3369,3370,2612,-1,1791,3371,1792,-1,1791,2678,3371,-1,1099,1444,2580,-1,1099,1098,1444,-1,1404,7,1402,-1,1404,8,7,-1,1121,1661,1284,-1,1121,1822,1661,-1,1419,1819,1150,-1,1820,1819,1419,-1,1115,1660,1399,-1,1660,1115,1817,-1,1398,2652,1720,-1,2652,1398,1377,-1,1808,1656,1809,-1,1654,1656,1808,-1,2662,1421,1701,-1,1421,2662,1431,-1,1432,1805,1046,-1,1805,1432,1878,-1,1802,2694,1849,-1,2694,1802,1803,-1,2551,1800,988,-1,2551,1801,1800,-1,2673,1872,2536,-1,1671,1872,2673,-1,2692,1207,1059,-1,2692,1844,1207,-1,297,3372,1659,-1,297,274,3372,-1,3373,1636,491,-1,1636,3373,1794,-1,1739,1253,3374,-1,1739,1741,1253,-1,1810,3375,3376,-1,2574,3375,1810,-1,1122,1786,1784,-1,1122,2579,1786,-1,1157,1420,1149,-1,1287,1420,1157,-1,3377,2571,3378,-1,2571,3377,1812,-1,3379,1814,1785,-1,1814,3379,1813,-1,1314,1307,1315,-1,1307,1314,1308,-1,1105,1781,2676,-1,1105,1104,1781,-1,3380,3381,1172,-1,3381,3380,3382,-1,3382,3383,1169,-1,3382,3384,3383,-1,1846,1172,1056,-1,3380,1172,1846,-1,1815,1792,3385,-1,1790,1792,1815,-1,1027,1854,1028,-1,1027,1871,1854,-1,1085,1006,1832,-1,1085,1771,1006,-1,1186,3386,1151,-1,1186,1095,3386,-1,2559,1063,1765,-1,1063,2559,1064,-1,1196,1230,3387,-1,2589,1230,1196,-1,977,1234,3388,-1,1234,977,976,-1,212,2610,1060,-1,2261,2610,212,-1,1764,1071,1765,-1,235,1071,1764,-1,1834,1859,2541,-1,1834,2683,1859,-1,3389,3368,3390,-1,3389,3391,3368,-1,1829,2681,1827,-1,1829,2679,2681,-1,1073,2689,1840,-1,2562,2689,1073,-1,2584,2667,1238,-1,2584,1763,2667,-1,1206,1061,1059,-1,1206,1225,1061,-1,2561,1243,2688,-1,1244,1243,2561,-1,1741,1182,1252,-1,1741,1793,1182,-1,1737,1248,2666,-1,1737,1736,1248,-1,1737,1434,1645,-1,1737,2666,1434,-1,991,2554,992,-1,2702,2554,991,-1,2547,3392,3362,-1,2547,1039,3392,-1,1642,999,998,-1,1732,999,1642,-1,1875,3363,1876,-1,3393,3363,1875,-1,3346,3360,3394,-1,3395,3360,3346,-1,1719,1880,264,-1,1881,1880,1719,-1,1665,1393,3351,-1,1393,1665,1664,-1,2597,3396,2699,-1,2597,2598,3396,-1,1023,1587,1021,-1,1548,1587,1023,-1,3378,1303,3377,-1,1126,1303,3378,-1,537,3397,1306,-1,537,2106,3397,-1,3398,1785,1699,-1,3398,3379,1785,-1,1298,3379,3398,-1,1298,3399,3379,-1,2678,1705,1157,-1,2678,1301,1705,-1,1701,1315,1307,-1,1421,1315,1701,-1,1695,2602,2601,-1,1337,2602,1695,-1,3400,2661,1331,-1,3401,2661,3400,-1,1306,3402,1335,-1,3402,1306,3403,-1,1345,3404,2658,-1,1345,1695,3404,-1,1686,3400,3405,-1,1689,3400,1686,-1,3403,1693,2603,-1,3403,3406,1693,-1,1373,1342,1341,-1,1373,1693,1342,-1,2608,1688,1682,-1,2608,3407,1688,-1,1561,3350,1864,-1,1561,1685,3350,-1,1683,1721,1400,-1,1721,1683,2607,-1,3408,1350,1354,-1,1350,3408,3409,-1,293,3410,1662,-1,293,1673,3410,-1,1348,3411,1366,-1,1348,2605,3411,-1,1369,1374,1010,-1,1374,1369,1375,-1,1378,1399,3411,-1,1377,1399,1378,-1,2604,1365,1677,-1,1365,2604,1687,-1,2657,1675,1363,-1,2654,1675,2657,-1,3412,3410,1356,-1,3410,3412,3413,-1,1662,3413,1353,-1,1662,3410,3413,-1,1016,1542,1012,-1,1016,2631,1542,-1,1347,2605,1348,-1,2603,2605,1347,-1,2651,1387,1173,-1,2651,2609,1387,-1,2650,3351,1393,-1,2650,2539,3351,-1,1405,1410,1653,-1,2572,1410,1405,-1,1788,1133,1135,-1,1788,2575,1133,-1,1229,2557,1069,-1,2557,1229,2555,-1,1236,1072,1066,-1,1236,2611,1072,-1,1073,1244,2562,-1,1073,1072,1244,-1,2583,1423,2649,-1,1423,2583,1148,-1,1772,1089,1088,-1,1772,1855,1089,-1,1768,1438,3414,-1,1768,1869,1438,-1,1799,1745,1237,-1,1799,1879,1745,-1,1879,3388,1745,-1,1879,977,3388,-1,788,1039,2547,-1,790,1039,788,-1,1032,2697,2544,-1,1032,1275,2697,-1,2615,1616,1633,-1,2615,3415,1616,-1,3415,3416,3417,-1,2615,3416,3415,-1,3418,1458,3419,-1,1458,3418,2647,-1,1452,1631,3420,-1,1450,1631,1452,-1,3416,3421,3422,-1,3423,3421,3416,-1,2645,3424,3425,-1,3424,2645,3419,-1,3422,3426,3427,-1,3421,3426,3422,-1,3428,2645,3425,-1,3428,1461,2645,-1,2644,1462,1461,-1,2644,1471,1462,-1,3427,3429,3430,-1,3426,3429,3427,-1,2640,3431,3430,-1,2640,1619,3431,-1,1464,3432,1476,-1,3432,1464,1626,-1,2118,1486,2972,-1,1486,2118,1487,-1,1488,3433,509,-1,1488,3434,3433,-1,2639,1489,2638,-1,2639,2641,1489,-1,1634,1496,3435,-1,1454,1496,1634,-1,1614,3436,3437,-1,3436,1614,1613,-1,1516,1612,1497,-1,1516,1515,1612,-1,1495,3438,2637,-1,1495,1523,3438,-1,1509,1595,1510,-1,1501,1595,1509,-1,1500,1595,1501,-1,1523,3439,3438,-1,1523,1525,3439,-1,1611,2618,1609,-1,1611,3440,2618,-1,3441,3439,2636,-1,3442,3439,3441,-1,2618,1507,1504,-1,2618,1606,1507,-1,3443,3441,3444,-1,3445,3441,3443,-1,1503,3446,3443,-1,3446,1503,3447,-1,3448,3446,2620,-1,3448,3449,3446,-1,1602,3448,494,-1,1602,1605,3448,-1,2634,3450,3451,-1,2634,1510,3450,-1,1522,3452,3453,-1,1522,1513,3452,-1,3454,1456,3455,-1,1457,1456,3454,-1,3456,1597,1520,-1,1597,3456,1598,-1,1592,3454,3457,-1,1524,3454,1592,-1,1598,2622,2621,-1,1598,1593,2622,-1,1596,3440,1611,-1,1596,2621,3440,-1,1588,1545,1547,-1,1588,1531,1545,-1,1931,1581,1574,-1,1934,1581,1931,-1,3292,1529,1533,-1,1529,3292,2627,-1,1567,3458,1572,-1,3458,1567,3459,-1,1575,897,1576,-1,1575,2708,897,-1,899,2625,897,-1,899,1535,2625,-1,3460,944,1557,-1,944,3460,945,-1,2628,3336,2629,-1,3336,2628,3461,-1,2629,1889,904,-1,1889,2629,3336,-1,3461,928,3336,-1,928,3461,929,-1,3462,929,3461,-1,929,3462,3327,-1,1535,2523,1536,-1,899,2523,1535,-1,1577,887,1554,-1,1577,1552,887,-1,1568,1572,1571,-1,1572,1568,1567,-1,1553,1579,1537,-1,1553,1589,1579,-1,1535,1585,2625,-1,1535,1584,1585,-1,1579,1580,1539,-1,1532,1580,1579,-1,2621,3463,3440,-1,2621,2622,3463,-1,3464,3457,3465,-1,1592,3457,3464,-1,3456,1593,1598,-1,3456,1599,1593,-1,3457,3455,3466,-1,3454,3455,3457,-1,3466,2614,1521,-1,3466,3467,2614,-1,2633,3453,3452,-1,3453,2633,1517,-1,3450,2633,3451,-1,2633,3450,1518,-1,2634,3468,3469,-1,3468,2634,3451,-1,2620,3447,1604,-1,2620,3446,3447,-1,1505,3447,1503,-1,3447,1505,2635,-1,3470,3471,3472,-1,3470,3473,3471,-1,3443,1608,1503,-1,3443,3444,1608,-1,3444,2636,1610,-1,3441,2636,3444,-1,3440,1606,2618,-1,3440,3463,1606,-1,1594,1510,1595,-1,1600,1510,1594,-1,1519,1510,1600,-1,1519,3450,1510,-1,1519,1518,3450,-1,2637,3474,3475,-1,2637,3438,3474,-1,2619,3437,3470,-1,3437,2619,1614,-1,3435,2637,3475,-1,1496,2637,3435,-1,511,1474,506,-1,511,2638,1474,-1,2642,3433,3434,-1,3433,2642,2639,-1,1484,1488,1487,-1,1488,1484,3434,-1,1479,1621,1620,-1,1479,1469,1621,-1,1626,1478,3432,-1,1478,1626,1470,-1,506,1473,1625,-1,506,1474,1473,-1,1621,2644,3476,-1,1621,1469,2644,-1,3430,2641,2640,-1,3429,2641,3430,-1,1468,3429,3426,-1,1468,1467,3429,-1,3476,1461,3428,-1,3476,2644,1461,-1,3477,3425,3478,-1,3477,3428,3425,-1,3421,1468,3426,-1,3479,1468,3421,-1,3425,3480,3478,-1,3480,3425,3424,-1,3423,3479,3421,-1,3420,3479,3423,-1,3419,1632,3424,-1,1632,3419,1458,-1,2615,3423,3416,-1,1453,3423,2615,-1,3415,1457,1616,-1,3415,1455,1457,-1,1795,3481,1008,-1,3481,1795,1794,-1,1437,3414,1438,-1,1428,3414,1437,-1,1268,2567,2566,-1,1268,1270,2567,-1,1198,1742,1744,-1,1198,1241,1742,-1,1059,1060,2610,-1,1059,1061,1060,-1,3482,1838,1759,-1,1838,3482,1220,-1,3371,1151,3386,-1,1151,3371,1158,-1,1190,967,1191,-1,1415,967,1190,-1,1396,1116,1115,-1,1396,1413,1116,-1,1171,1658,1657,-1,1658,1171,1170,-1,2674,1117,1406,-1,1107,1117,2674,-1,1388,1668,1391,-1,1390,1668,1388,-1,2651,1388,2609,-1,2651,1389,1388,-1,1170,1408,1658,-1,3483,1408,1170,-1,3370,1267,2612,-1,1267,3370,1729,-1,1021,1586,1281,-1,1587,1586,1021,-1,1672,295,969,-1,295,1672,296,-1,2654,2656,3409,-1,2654,2657,2656,-1,2699,1023,1022,-1,3396,1023,2699,-1,1375,1690,1376,-1,1375,1682,1690,-1,1378,2605,1692,-1,1378,3411,2605,-1,1343,1679,1344,-1,1368,1679,1343,-1,3484,1881,1719,-1,3484,3485,1881,-1,1353,3408,1354,-1,3413,3408,1353,-1,1319,1675,2655,-1,1674,1675,1319,-1,2656,1400,1351,-1,2656,1683,1400,-1,1881,1694,970,-1,1694,1881,3485,-1,3407,1343,2658,-1,1343,3407,2608,-1,3402,2603,1347,-1,3402,3403,2603,-1,1689,3401,3400,-1,1688,3401,1689,-1,2659,1342,3486,-1,1342,2659,1339,-1,1333,3402,3487,-1,1333,1335,3402,-1,3401,1327,2661,-1,3488,1327,3401,-1,2659,2602,1337,-1,2659,2660,2602,-1,1335,1332,538,-1,1332,1335,1333,-1,1331,1329,540,-1,1331,2661,1329,-1,1674,1322,1698,-1,1319,1322,1674,-1,999,2662,1316,-1,2662,999,1432,-1,1706,2578,1784,-1,1706,1702,2578,-1,1304,3489,1305,-1,1304,1299,3489,-1,3397,1127,1312,-1,3397,1125,1127,-1,1298,1296,2663,-1,1296,1298,3398,-1,1297,3399,1298,-1,3490,3399,1297,-1,3490,1313,1700,-1,1297,1313,3490,-1,1125,2106,1128,-1,2106,1125,3397,-1,1816,3491,2569,-1,1790,3491,1816,-1,1013,2630,3492,-1,1013,1541,2630,-1,1281,2631,1016,-1,1281,1586,2631,-1,3366,3353,3357,-1,3366,1796,3353,-1,2682,3355,3354,-1,3493,3355,2682,-1,3362,1851,2696,-1,3392,1851,3362,-1,1258,1448,1447,-1,1448,1258,1637,-1,1254,3494,1736,-1,3494,1254,2593,-1,1248,3494,1246,-1,1736,3494,1248,-1,3495,1250,3496,-1,1740,1250,3495,-1,2700,1144,1009,-1,2700,1145,1144,-1,1181,2687,1243,-1,2564,2687,1181,-1,1650,1240,1235,-1,1650,1241,1240,-1,1749,3497,1232,-1,1749,1200,3497,-1,1840,1759,1838,-1,2689,1759,1840,-1,1839,1067,1074,-1,1839,1065,1067,-1,1062,2555,1060,-1,2555,1062,2556,-1,1747,1749,1231,-1,1749,1747,1383,-1,3365,1858,3347,-1,3358,1858,3365,-1,3390,3367,3498,-1,3368,3367,3390,-1,1185,1758,1075,-1,1185,3499,1758,-1,3499,3500,3501,-1,3500,3499,1185,-1,1229,235,234,-1,1229,1071,235,-1,2649,1837,2686,-1,2649,1183,1837,-1,1796,2150,1797,-1,1796,3366,2150,-1,1215,2649,1216,-1,1215,2583,2649,-1,1233,3388,1234,-1,1233,2590,3388,-1,1066,1841,1202,-1,1068,1841,1066,-1,1200,2667,3497,-1,2667,1200,1199,-1,1826,3414,1428,-1,1826,2568,3414,-1,1218,1185,1184,-1,1185,1218,3500,-1,1180,2563,1181,-1,1180,2685,2563,-1,3482,3501,2863,-1,3501,3482,3499,-1,1008,1649,1795,-1,1649,1008,1009,-1,2671,1035,2677,-1,2671,1036,1035,-1,1301,1790,1816,-1,1791,1790,1301,-1,1775,1407,1408,-1,1775,1776,1407,-1,1169,3381,3382,-1,1169,2672,3381,-1,1172,2672,1171,-1,1172,3381,2672,-1,2676,1275,1105,-1,1275,2676,1276,-1,1311,1295,1294,-1,1311,3376,1295,-1,1155,3490,1700,-1,1131,3490,1155,-1,1812,3491,2570,-1,1812,3377,3491,-1,1287,1289,1420,-1,1287,1709,1289,-1,2574,3502,3375,-1,2575,3502,2574,-1,274,2379,3372,-1,274,10,2379,-1,1135,1789,1788,-1,1136,1789,1135,-1,1720,1115,1398,-1,1720,1396,1115,-1,1374,1108,3503,-1,1374,1119,1108,-1,1660,1285,1661,-1,1660,1711,1285,-1,1403,2674,2675,-1,2674,1403,3503,-1,782,2580,1444,-1,784,2580,782,-1,1440,3504,1100,-1,1260,3504,1440,-1,1094,3386,1095,-1,1094,3385,3386,-1,2151,2669,2450,-1,2151,1192,2669,-1,2151,2928,1192,-1,1753,1271,1754,-1,1753,1272,1271,-1,1223,2542,3367,-1,2542,1223,1856,-1,2150,3389,394,-1,2150,1213,3389,-1,1005,3354,2664,-1,1005,2682,3354,-1,1756,1082,1762,-1,1083,1082,1756,-1,1074,1840,1839,-1,1074,1073,1840,-1,1065,1068,1067,-1,1065,1064,1068,-1,1225,2588,1752,-1,1225,1224,2588,-1,1057,3344,1058,-1,2537,3344,1057,-1,1052,2610,1141,-1,2610,1052,1054,-1,1039,1266,3392,-1,1039,1038,1266,-1,1734,2546,1639,-1,1734,2665,2546,-1,3361,3394,3360,-1,3361,3505,3394,-1,1025,1160,1723,-1,1160,1025,1024,-1,2158,1027,1026,-1,2158,3506,1027,-1,1774,2543,1162,-1,1774,1028,2543,-1,1084,1833,1080,-1,1756,1833,1084,-1,3369,1755,1754,-1,3369,3356,1755,-1,2541,2686,3507,-1,2686,2541,1216,-1,2597,1019,1717,-1,2597,1020,1019,-1,1013,1714,1283,-1,3492,1714,1013,-1,1666,1719,266,-1,1719,1666,3484,-1,1009,2592,2700,-1,2592,1009,1007,-1,2680,1002,1272,-1,2595,1002,2680,-1,3505,1033,3394,-1,3505,1034,1033,-1,3365,1089,3348,-1,1089,3365,1090,-1,1269,1726,1728,-1,1269,1268,1726,-1,2596,2697,1722,-1,2697,2596,2544,-1,995,3345,1847,-1,3345,995,994,-1,2692,3344,1844,-1,3344,2692,3508,-1,980,3363,1045,-1,3363,980,979,-1,1806,983,982,-1,1806,1878,983,-1,1088,512,1772,-1,512,1088,1829,-1,965,2669,966,-1,965,1767,2669,-1,1766,805,2724,-1,1766,2723,805,-1,3509,815,817,-1,3510,815,3509,-1,1978,2723,1092,-1,805,2723,1978,-1,2725,1980,2548,-1,2725,800,1980,-1,800,1262,2496,-1,800,2725,1262,-1,796,1882,798,-1,796,1641,1882,-1,956,3341,957,-1,956,3511,3341,-1,957,3339,3512,-1,957,3341,3339,-1,2533,1893,2705,-1,1893,2533,950,-1,3338,3513,3514,-1,3338,3340,3513,-1,2706,3515,946,-1,2706,3514,3515,-1,3515,3334,946,-1,3334,3515,3516,-1,3516,942,3334,-1,942,3516,3517,-1,911,2526,912,-1,911,3518,2526,-1,1566,943,945,-1,1565,943,1566,-1,3519,940,2527,-1,940,3519,3520,-1,916,3332,1908,-1,916,940,3332,-1,938,931,936,-1,931,938,921,-1,3332,3320,3330,-1,3332,3318,3320,-1,3329,956,2704,-1,3329,3331,956,-1,3319,3519,3521,-1,3319,3520,3519,-1,3318,3520,3319,-1,3522,3325,3518,-1,925,3325,3522,-1,3328,3323,3324,-1,3323,3328,922,-1,949,1559,1894,-1,949,924,1559,-1,937,3523,3322,-1,3460,3523,937,-1,1906,1913,1901,-1,1906,2525,1913,-1,3310,2707,2528,-1,2707,3310,3315,-1,918,3314,919,-1,918,908,3314,-1,3309,3313,3524,-1,3312,3313,3309,-1,3315,3307,3525,-1,3310,3307,3315,-1,3309,2494,794,-1,3309,3524,2494,-1,802,3525,3307,-1,801,3525,802,-1,1982,909,3208,-1,1982,3526,909,-1,900,1892,901,-1,900,3278,1892,-1,1536,3527,3289,-1,1536,2523,3527,-1,3306,1555,1554,-1,3306,3528,1555,-1,2519,898,2708,-1,2519,2521,898,-1,3528,894,1555,-1,3528,3282,894,-1,889,2709,896,-1,2709,889,3301,-1,892,1922,893,-1,892,2711,1922,-1,895,3529,1551,-1,3283,3529,895,-1,3286,3298,3297,-1,3285,3298,3286,-1,3293,3297,3298,-1,3293,3296,3297,-1,3291,3293,3292,-1,3293,3291,3296,-1,3530,1590,1589,-1,1590,3530,1929,-1,1553,3289,3288,-1,1553,1536,3289,-1,890,1569,3285,-1,890,1578,1569,-1,2516,3282,3528,-1,3282,2516,3284,-1,3531,3281,3280,-1,3531,3532,3281,-1,1939,3306,886,-1,3306,1939,1938,-1,1920,3279,900,-1,1920,3532,3279,-1,3239,1942,2515,-1,3239,2713,1942,-1,3276,1945,875,-1,3276,3237,1945,-1,3271,874,2712,-1,3533,874,3271,-1,1946,1943,1947,-1,1944,1943,1946,-1,2514,2512,876,-1,2514,1949,2512,-1,3270,873,872,-1,3270,3268,873,-1,1948,3267,2513,-1,1948,3534,3267,-1,1950,3264,1951,-1,1950,3535,3264,-1,3263,3534,3536,-1,3267,3534,3263,-1,3535,3260,3264,-1,3535,3537,3260,-1,3538,3263,3536,-1,3263,3538,3259,-1,3537,3256,3260,-1,3537,3539,3256,-1,3540,3259,3538,-1,3259,3540,3255,-1,3539,3253,3256,-1,3539,3541,3253,-1,3542,3255,3540,-1,3255,3542,3250,-1,3253,3543,3249,-1,3253,3541,3543,-1,3544,3250,3542,-1,3250,3544,3247,-1,3249,3545,3245,-1,3249,3543,3545,-1,868,3247,3544,-1,3247,868,3241,-1,3245,3235,3243,-1,3245,3545,3235,-1,3241,2713,3239,-1,3241,868,2713,-1,3243,3237,3276,-1,3243,3235,3237,-1,3546,869,3232,-1,870,869,3546,-1,3547,3228,3230,-1,3548,3228,3547,-1,3549,1943,1942,-1,3549,3227,1943,-1,3219,3550,3226,-1,3219,867,3550,-1,2511,3551,3223,-1,2511,1957,3551,-1,3222,2714,3236,-1,3222,2715,2714,-1,867,2507,843,-1,3219,2507,867,-1,857,3218,2716,-1,857,864,3218,-1,1955,2505,1956,-1,1955,1960,2505,-1,857,2715,858,-1,2715,857,2716,-1,847,1959,855,-1,847,846,1959,-1,1963,850,839,-1,1963,2506,850,-1,859,2504,865,-1,2504,859,1966,-1,835,831,830,-1,835,2717,831,-1,1968,826,834,-1,2499,826,1968,-1,2502,822,3216,-1,822,2502,1969,-1,820,836,828,-1,820,1974,836,-1,825,821,823,-1,824,821,825,-1,3217,2719,3215,-1,3217,818,2719,-1,2501,804,2718,-1,2721,804,2501,-1,3552,818,3217,-1,3552,3213,818,-1,2669,2703,2450,-1,2722,2703,2669,-1,1766,1783,2723,-1,965,1783,1766,-1,2498,811,3342,-1,2498,809,811,-1,3212,3214,3553,-1,2720,3214,3212,-1,3554,1915,799,-1,3555,1915,3554,-1,2725,2547,2677,-1,2548,2547,2725,-1,2000,2735,2493,-1,2736,2735,2000,-1,787,1106,783,-1,3556,1106,787,-1,2648,1444,1443,-1,2726,1444,2648,-1,3177,3557,3558,-1,3557,3177,3204,-1,3160,3204,3202,-1,3160,3557,3204,-1,3161,769,3559,-1,3161,3560,769,-1,2728,2020,3200,-1,2728,2018,2020,-1,3561,3200,2020,-1,3199,3200,3561,-1,771,3195,2730,-1,771,766,3195,-1,3199,3135,3197,-1,3199,3561,3135,-1,2730,3194,765,-1,2730,3195,3194,-1,3135,3562,3197,-1,3562,3135,3137,-1,3190,765,3194,-1,3563,765,3190,-1,3137,3564,3562,-1,3564,3137,3565,-1,3190,3186,3563,-1,3186,3190,3189,-1,3565,3185,3564,-1,3185,3565,2017,-1,3189,3182,3186,-1,3182,3189,3566,-1,2017,3181,3185,-1,3181,2017,2016,-1,3178,3566,3567,-1,3178,3182,3566,-1,2016,758,3181,-1,758,2016,3133,-1,3567,3179,3178,-1,3179,3567,3568,-1,3133,759,758,-1,759,3133,3569,-1,1985,755,3570,-1,1985,756,755,-1,3571,3168,3558,-1,3167,3168,3571,-1,3572,3165,3162,-1,3165,3572,3192,-1,3559,778,3161,-1,778,3559,3201,-1,1999,3118,749,-1,3118,1999,1996,-1,2029,743,2030,-1,2029,748,743,-1,3115,2487,3573,-1,3115,703,2487,-1,2741,3154,696,-1,3154,2741,3152,-1,2031,3149,3113,-1,3149,2031,739,-1,2734,2732,704,-1,2733,2732,2734,-1,3556,3154,3151,-1,3556,3156,3154,-1,2002,3150,3206,-1,2002,2733,3150,-1,3149,785,786,-1,3149,739,785,-1,3574,3146,3131,-1,3574,3575,3146,-1,3122,3119,2483,-1,3121,3119,3122,-1,3120,3127,3124,-1,3120,736,3127,-1,3140,713,3142,-1,3140,711,713,-1,2011,735,3576,-1,723,735,2011,-1,719,733,717,-1,733,719,732,-1,2010,727,726,-1,2010,3139,727,-1,2738,3141,725,-1,2738,3143,3141,-1,735,705,2028,-1,734,705,735,-1,717,721,2739,-1,722,721,717,-1,3561,3130,3135,-1,3561,3128,3130,-1,3125,1987,1986,-1,3125,3132,1987,-1,3131,2484,3574,-1,2484,3131,3128,-1,3577,3126,3134,-1,3577,3124,3126,-1,3136,3121,3123,-1,3136,3578,3121,-1,2005,3575,2003,-1,3575,2005,3146,-1,750,718,2739,-1,750,749,718,-1,3159,712,1993,-1,712,3159,2740,-1,2732,701,702,-1,2732,2485,701,-1,697,3157,2486,-1,697,696,3157,-1,2850,2777,2428,-1,2777,2850,2849,-1,693,640,690,-1,693,2476,640,-1,687,690,683,-1,687,693,690,-1,2037,2742,3579,-1,2742,2037,686,-1,679,3579,2742,-1,679,2041,3579,-1,676,3111,673,-1,3111,676,678,-1,666,673,3111,-1,666,669,673,-1,639,665,637,-1,2044,665,639,-1,649,656,2477,-1,649,660,656,-1,654,3580,652,-1,3580,654,2056,-1,652,2051,2050,-1,2051,652,3580,-1,646,2053,650,-1,641,2053,646,-1,2048,640,642,-1,3107,640,2048,-1,682,624,628,-1,682,625,624,-1,2042,616,638,-1,617,616,2042,-1,2907,3106,633,-1,3106,2907,3581,-1,626,2746,627,-1,626,2904,2746,-1,2936,2894,3582,-1,2894,2936,3104,-1,2074,3102,3085,-1,3102,2074,2470,-1,3100,3085,3102,-1,3100,3583,3085,-1,3098,3583,3100,-1,3098,3584,3583,-1,3087,3098,3095,-1,3087,3584,3098,-1,3089,2076,598,-1,2076,3089,2066,-1,3093,3585,3586,-1,3093,3587,3585,-1,3588,2071,2877,-1,609,2071,3588,-1,593,2468,2075,-1,593,601,2468,-1,3587,3091,614,-1,3587,3090,3091,-1,3089,3584,3087,-1,3584,3089,3589,-1,601,595,602,-1,601,593,595,-1,352,2069,592,-1,351,2069,352,-1,2098,3078,562,-1,2098,3080,3078,-1,586,2100,3590,-1,2100,586,589,-1,3079,3080,3075,-1,3080,3079,3078,-1,2081,3590,2079,-1,3590,2081,586,-1,3591,3075,3070,-1,3075,3591,3079,-1,2749,3591,3070,-1,2749,3069,3591,-1,2086,3060,3056,-1,2086,2465,3060,-1,2751,580,581,-1,2750,580,2751,-1,3592,581,580,-1,3592,573,581,-1,2091,2105,2102,-1,2090,2105,2091,-1,2102,3055,2462,-1,2105,3055,2102,-1,2464,566,567,-1,2093,566,2464,-1,556,3055,548,-1,3055,556,2462,-1,342,565,564,-1,342,2096,565,-1,568,559,2463,-1,2095,559,568,-1,3083,546,3593,-1,3083,2754,546,-1,2091,3594,2088,-1,3062,3594,2091,-1,3061,3595,3059,-1,3061,3076,3595,-1,3054,548,3055,-1,548,3054,549,-1,317,607,344,-1,607,317,2755,-1,1548,2460,1546,-1,1548,3596,2460,-1,2985,3053,3050,-1,3053,2985,3597,-1,3042,3048,3047,-1,3048,3042,2989,-1,3044,3039,3052,-1,3044,3043,3039,-1,3038,2984,3041,-1,3038,2980,2984,-1,3036,3033,3045,-1,3036,3035,3033,-1,3040,3032,3028,-1,3030,3032,3040,-1,3029,2978,3027,-1,3029,3598,2978,-1,3031,3024,3021,-1,3022,3024,3031,-1,3026,3020,3016,-1,3018,3020,3026,-1,3017,3599,3015,-1,3017,2983,3599,-1,3011,3019,3012,-1,3011,3009,3019,-1,3014,3008,3004,-1,3006,3008,3014,-1,3005,2982,3003,-1,3005,2760,2982,-1,3007,2758,2999,-1,3001,2758,3007,-1,2996,2993,3002,-1,2996,2998,2993,-1,3600,2995,2992,-1,2995,3600,533,-1,2997,2991,2986,-1,2757,2991,2997,-1,2988,3051,2994,-1,2988,2987,3051,-1,2990,3049,3046,-1,2990,3034,3049,-1,2759,3034,2990,-1,2759,3037,3034,-1,2756,3037,2759,-1,2756,3025,3037,-1,3000,3025,2756,-1,3000,3023,3025,-1,3013,3023,3000,-1,3013,3010,3023,-1,518,533,3600,-1,518,517,533,-1,2983,2976,3599,-1,2974,2976,2983,-1,2980,2975,2984,-1,2979,2975,2980,-1,524,522,536,-1,523,522,524,-1,532,519,521,-1,532,517,519,-1,2761,2975,2979,-1,2107,2975,2761,-1,9,8,2379,-1,9,2762,8,-1,494,2620,495,-1,3448,2620,494,-1,509,511,2763,-1,511,509,3433,-1,2972,2764,485,-1,1486,2764,2972,-1,2121,2969,2973,-1,2121,2963,2969,-1,2971,482,2113,-1,2971,2765,482,-1,1477,2970,2616,-1,2970,1477,1480,-1,2878,3586,2968,-1,2878,3093,3586,-1,2964,2765,2963,-1,2964,481,2765,-1,481,470,477,-1,470,481,2766,-1,473,486,474,-1,2962,486,473,-1,2454,484,483,-1,472,484,2454,-1,476,2126,475,-1,476,469,2126,-1,2958,2961,2956,-1,2960,2961,2958,-1,2958,467,466,-1,2958,2957,467,-1,468,2138,469,-1,2138,468,2136,-1,2954,2132,2959,-1,2954,2130,2132,-1,460,2955,2767,-1,2955,460,2135,-1,3601,451,450,-1,3601,2952,451,-1,2943,456,2142,-1,2943,2951,456,-1,2140,2946,2949,-1,2140,2768,2946,-1,3602,356,394,-1,356,3602,354,-1,419,2446,2449,-1,419,2162,2446,-1,2168,2159,428,-1,2159,2168,416,-1,2161,426,425,-1,426,2161,2166,-1,2942,2947,2167,-1,2947,2942,3603,-1,2950,414,430,-1,2950,415,414,-1,421,2945,2953,-1,421,420,2945,-1,2948,2942,2941,-1,3604,2942,2948,-1,415,2161,432,-1,415,2165,2161,-1,437,2152,2148,-1,2157,2152,437,-1,2152,2922,2177,-1,2152,3605,2922,-1,2177,2153,2152,-1,2176,2153,2177,-1,411,2939,3606,-1,411,2170,2939,-1,3582,409,2936,-1,405,409,3582,-1,2940,2924,2938,-1,2940,403,2924,-1,405,407,409,-1,2772,407,405,-1,2934,403,2940,-1,2934,401,403,-1,2771,399,410,-1,2171,399,2771,-1,3607,2773,2932,-1,3607,404,2773,-1,2931,2442,2921,-1,2931,2935,2442,-1,397,3608,395,-1,2929,3608,397,-1,441,396,2180,-1,396,441,3609,-1,2926,2938,2924,-1,2888,2938,2926,-1,2182,3610,2920,-1,2182,2441,3610,-1,2440,2235,2065,-1,2235,2440,2919,-1,2784,2429,2428,-1,2784,2783,2429,-1,2232,390,2230,-1,392,390,2232,-1,2850,2186,2185,-1,358,2186,2850,-1,3611,388,391,-1,3611,2897,388,-1,2913,385,2886,-1,389,385,2913,-1,252,2912,2188,-1,252,251,2912,-1,250,253,249,-1,2218,253,250,-1,2915,3612,2916,-1,3612,2915,3613,-1,360,2197,254,-1,2228,2197,360,-1,3614,3615,3616,-1,3614,3617,3615,-1,3618,3617,3614,-1,3618,3619,3617,-1,3613,3619,3618,-1,3613,3620,3619,-1,2915,3620,3613,-1,3620,2915,2917,-1,2883,2232,2231,-1,2883,2225,2232,-1,2782,2231,357,-1,2782,2883,2231,-1,2879,2228,360,-1,2879,3621,2228,-1,3581,2201,2203,-1,2907,2201,3581,-1,2206,2746,2904,-1,2206,2208,2746,-1,2780,2062,2781,-1,2062,2780,2473,-1,2212,2202,2199,-1,2212,376,2202,-1,2207,370,2216,-1,2204,370,2207,-1,2215,2210,2902,-1,2210,2215,2781,-1,372,2902,373,-1,2882,2902,372,-1,3622,3623,2908,-1,3623,3622,3624,-1,3625,2893,2900,-1,3625,3626,2893,-1,2895,2897,3611,-1,2897,2895,2887,-1,2896,3624,3627,-1,2896,2895,3624,-1,2893,2925,2891,-1,2925,2893,3626,-1,365,245,244,-1,3628,245,365,-1,384,162,2271,-1,384,2189,162,-1,2187,188,2801,-1,188,2187,2886,-1,2776,355,2884,-1,2776,2918,355,-1,3629,371,2880,-1,369,371,3629,-1,2878,2965,2877,-1,2878,2968,2965,-1,2238,609,3588,-1,609,2238,2472,-1,2247,3590,2248,-1,2079,3590,2247,-1,2242,2080,2243,-1,2242,2082,2080,-1,336,331,333,-1,335,331,336,-1,302,2421,338,-1,302,326,2421,-1,300,325,324,-1,300,2244,325,-1,2245,319,321,-1,2787,319,2245,-1,2788,314,312,-1,2788,305,314,-1,2249,307,2252,-1,307,2249,308,-1,2755,2876,2251,-1,2876,2755,2875,-1,2250,2873,2420,-1,2874,2873,2250,-1,304,2787,308,-1,304,319,2787,-1,326,301,2873,-1,301,326,302,-1,307,299,298,-1,307,309,299,-1,2378,2869,2375,-1,2869,2378,3630,-1,2789,2857,286,-1,2857,2789,3631,-1,158,216,218,-1,160,216,158,-1,281,2318,282,-1,281,1147,2318,-1,22,185,2409,-1,22,21,185,-1,2360,3632,2832,-1,2360,272,3632,-1,2813,2868,55,-1,2813,2852,2868,-1,2577,277,297,-1,2577,278,277,-1,2859,2315,2402,-1,2285,2315,2859,-1,2867,2840,2839,-1,2867,2853,2840,-1,2871,184,183,-1,184,2871,123,-1,2860,2845,2844,-1,2860,2419,2845,-1,2217,2190,2218,-1,2217,2191,2190,-1,2431,2220,2219,-1,2431,222,2220,-1,230,2846,2320,-1,2861,2846,230,-1,2273,231,2282,-1,2273,232,231,-1,2856,170,2275,-1,2856,2316,170,-1,2858,2795,2274,-1,220,2795,2858,-1,2866,2796,2865,-1,236,2796,2866,-1,2863,2414,2862,-1,2863,3501,2414,-1,2796,235,1764,-1,233,235,2796,-1,197,2288,198,-1,2289,2288,197,-1,229,2861,230,-1,229,2287,2861,-1,226,222,227,-1,223,222,226,-1,248,2219,2221,-1,248,247,2219,-1,215,218,216,-1,215,219,218,-1,286,236,2866,-1,236,286,2857,-1,210,2280,2281,-1,209,2280,210,-1,202,2411,2279,-1,201,2411,202,-1,2848,242,3633,-1,2855,242,2848,-1,169,2317,2275,-1,169,2400,2317,-1,2791,2844,267,-1,2791,2860,2844,-1,385,2271,2415,-1,384,2271,385,-1,93,2854,3634,-1,93,2418,2854,-1,103,118,189,-1,103,2395,118,-1,2303,153,149,-1,153,2303,2311,-1,2798,2305,140,-1,2798,169,2305,-1,2790,155,170,-1,156,155,2790,-1,2408,154,146,-1,2407,154,2408,-1,290,3631,144,-1,290,2857,3631,-1,2291,2799,2292,-1,2291,2800,2799,-1,199,2847,203,-1,199,3635,2847,-1,2403,139,141,-1,367,139,2403,-1,2301,2222,2312,-1,2301,138,2222,-1,2846,3636,2841,-1,3636,2846,268,-1,2811,2845,2803,-1,2845,2811,2326,-1,92,165,85,-1,165,92,88,-1,2397,120,2396,-1,121,120,2397,-1,101,2397,280,-1,101,2325,2397,-1,2842,2323,2843,-1,2324,2323,2842,-1,100,102,2842,-1,102,100,2395,-1,2326,105,2327,-1,2326,2811,105,-1,2331,98,111,-1,2330,98,2331,-1,95,2840,2417,-1,95,2319,2840,-1,2831,59,2822,-1,2831,23,59,-1,2344,2830,2345,-1,2830,2344,2368,-1,2353,2338,2362,-1,2339,2338,2353,-1,65,2819,3637,-1,67,2819,65,-1,2837,2836,3637,-1,2837,3638,2836,-1,2824,3638,3639,-1,2824,2836,3638,-1,3640,2833,2832,-1,3640,2827,2833,-1,2353,2831,2354,-1,2353,2382,2831,-1,2812,68,2392,-1,2812,71,68,-1,2816,2351,47,-1,2384,2351,2816,-1,26,2358,52,-1,2359,2358,26,-1,2826,57,2835,-1,2826,2825,57,-1,2823,2361,3641,-1,2823,58,2361,-1,2821,0,3642,-1,2821,2377,0,-1,2819,2383,2333,-1,2819,2818,2383,-1,46,2819,67,-1,2819,46,2374,-1,2827,3639,2833,-1,2824,3639,2827,-1,53,2834,56,-1,2357,2834,53,-1,2815,28,27,-1,2815,2838,28,-1,2369,2348,3643,-1,2369,2337,2348,-1,24,52,2814,-1,24,26,52,-1,2338,35,2364,-1,2369,35,2338,-1,56,54,53,-1,54,56,55,-1,2825,2813,57,-1,2813,2825,2872,-1,2357,2391,2834,-1,2391,2357,2343,-1,2835,66,2826,-1,66,2835,63,-1,2389,3638,2837,-1,2389,77,3638,-1,1391,1394,115,-1,1394,1391,1395,-1,2841,2802,2839,-1,2841,3636,2802,-1,96,2809,436,-1,2154,2809,96,-1,2324,2327,105,-1,2327,2324,104,-1,108,2810,107,-1,108,2808,2810,-1,112,2843,2323,-1,112,2322,2843,-1,110,119,98,-1,110,109,119,-1,2406,106,2394,-1,106,2406,178,-1,2328,267,2844,-1,267,2328,3644,-1,2318,129,246,-1,129,2318,127,-1,2806,2312,2805,-1,161,2312,2806,-1,137,2804,2310,-1,136,2804,137,-1,140,2413,2798,-1,2286,2413,140,-1,201,3633,2411,-1,201,2848,3633,-1,123,145,130,-1,145,123,2789,-1,152,149,153,-1,150,149,152,-1,2794,158,285,-1,2794,2807,158,-1,162,2806,2306,-1,162,161,2806,-1,2307,2405,2404,-1,175,2405,2307,-1,2851,3645,2849,-1,3645,2851,3646,-1,2852,2867,2868,-1,2852,2853,2867,-1,125,270,2321,-1,271,270,125,-1,188,151,150,-1,151,188,2415,-1,192,2408,193,-1,192,383,2408,-1,2401,239,2800,-1,240,239,2401,-1,2856,3635,241,-1,2856,2847,3635,-1,213,290,214,-1,213,237,290,-1,220,2859,284,-1,220,2858,2859,-1,171,224,172,-1,224,171,2797,-1,2791,208,207,-1,269,208,2791,-1,1219,2864,2865,-1,1219,1221,2864,-1,2795,3500,1218,-1,238,3500,2795,-1,234,237,213,-1,234,233,237,-1,2399,2864,2862,-1,2398,2864,2399,-1,131,287,217,-1,131,145,287,-1,2320,228,230,-1,2320,126,228,-1,268,2861,269,-1,268,2846,2861,-1,250,223,226,-1,191,223,250,-1,3,3630,2378,-1,3630,3,3647,-1,383,152,2407,-1,383,2801,152,-1,18,2410,19,-1,18,2263,2410,-1,143,187,186,-1,187,143,142,-1,3632,2321,270,-1,3632,272,2321,-1,2286,134,2413,-1,134,2286,368,-1,2814,190,117,-1,2814,54,190,-1,3640,2854,2872,-1,3640,3634,2854,-1,2385,182,273,-1,2385,60,182,-1,2255,2263,18,-1,2255,2258,2263,-1,2402,284,2859,-1,285,284,2402,-1,120,15,2396,-1,15,120,16,-1,2871,144,3631,-1,2871,142,144,-1,288,127,1147,-1,288,128,127,-1,323,2874,2876,-1,2874,323,327,-1,2788,306,305,-1,2788,303,306,-1,300,2875,316,-1,300,324,2875,-1,318,298,316,-1,318,2786,298,-1,2420,301,311,-1,2873,301,2420,-1,337,306,303,-1,306,337,320,-1,309,322,299,-1,309,2423,322,-1,327,2422,328,-1,327,323,2422,-1,340,320,337,-1,340,329,320,-1,325,2247,2422,-1,2243,2247,325,-1,2424,350,349,-1,2424,2425,350,-1,2424,3588,2236,-1,2238,3588,2424,-1,347,2425,2236,-1,346,2425,347,-1,2881,3621,2879,-1,2881,2433,3621,-1,363,2883,2782,-1,363,2882,2883,-1,2885,247,2792,-1,2885,2219,247,-1,2884,3628,2885,-1,245,3628,2884,-1,382,227,365,-1,227,382,225,-1,252,2801,383,-1,2187,2801,252,-1,2889,2926,3648,-1,2888,2926,2889,-1,2894,3649,2892,-1,2894,3104,3649,-1,3627,3622,3105,-1,3627,3624,3622,-1,2898,3648,3650,-1,2898,2889,3648,-1,2909,2892,3649,-1,2909,2899,2892,-1,371,2901,2881,-1,371,370,2901,-1,373,2436,2432,-1,2436,373,2435,-1,379,2434,2901,-1,378,2434,379,-1,2213,2780,2214,-1,2780,2213,2437,-1,2209,2903,2747,-1,2209,2211,2903,-1,380,2905,3651,-1,380,2205,2905,-1,2745,2200,2906,-1,2745,2198,2200,-1,2783,2430,2429,-1,2226,2430,2783,-1,2785,3629,2427,-1,2224,3629,2785,-1,3621,2229,2228,-1,3621,2227,2229,-1,2416,2426,2438,-1,2416,2183,2426,-1,2784,2196,2195,-1,2784,2778,2196,-1,3613,2911,3612,-1,2911,3613,3618,-1,256,225,382,-1,256,255,225,-1,2911,3614,2910,-1,2911,3618,3614,-1,2910,3616,2912,-1,2910,3614,3616,-1,2779,3650,313,-1,2898,3650,2779,-1,2897,2779,388,-1,2897,2898,2779,-1,2439,2851,386,-1,2851,2439,3646,-1,2230,389,2913,-1,390,389,2230,-1,3623,391,2184,-1,3623,3611,391,-1,3645,2917,2914,-1,3645,3620,2917,-1,2777,2916,2778,-1,2777,2914,2916,-1,2920,3652,2919,-1,3652,2920,3653,-1,605,3654,3610,-1,3654,605,604,-1,2775,2921,2922,-1,2921,2775,2930,-1,3655,2925,2927,-1,2925,3655,2891,-1,2890,3606,2939,-1,2896,3606,2890,-1,2774,2933,398,-1,2933,2774,2175,-1,2178,2932,2930,-1,3607,2932,2178,-1,2935,401,2934,-1,2935,2931,401,-1,2772,2929,407,-1,3608,2929,2772,-1,398,2444,2169,-1,398,2933,2444,-1,404,402,2773,-1,404,406,402,-1,412,2771,410,-1,2771,412,408,-1,406,2927,402,-1,406,3655,2927,-1,3656,408,412,-1,408,3656,2937,-1,2775,3605,442,-1,2775,2922,3605,-1,2443,2928,2151,-1,2443,2174,2928,-1,442,1647,443,-1,1647,442,429,-1,2944,419,2449,-1,2944,420,419,-1,2160,414,413,-1,418,414,2160,-1,421,424,2770,-1,421,422,424,-1,2951,2944,2165,-1,2943,2944,2951,-1,417,2768,418,-1,2768,417,2946,-1,2952,3604,422,-1,3601,3604,2952,-1,419,2163,2162,-1,419,2770,2163,-1,427,2168,428,-1,2941,2168,427,-1,434,2769,435,-1,2769,434,2163,-1,86,2164,425,-1,2164,86,444,-1,2151,2148,2152,-1,2151,2149,2148,-1,968,1387,449,-1,968,1173,1387,-1,2147,3603,2145,-1,2147,2947,3603,-1,2144,430,2139,-1,2144,2950,430,-1,2953,2141,453,-1,2953,2945,2141,-1,2141,454,453,-1,454,2141,2131,-1,2957,2133,467,-1,2957,2452,2133,-1,464,2124,2126,-1,2124,464,2129,-1,2767,2766,2123,-1,2766,2767,2955,-1,3657,2959,2956,-1,3657,2954,2959,-1,2955,470,2766,-1,470,2955,468,-1,473,3657,2962,-1,473,2125,3657,-1,471,2964,2456,-1,2453,2964,471,-1,2961,3658,2120,-1,2960,3658,2961,-1,2455,475,478,-1,475,2455,476,-1,479,474,503,-1,478,474,479,-1,2764,3658,483,-1,3658,2764,3659,-1,2968,3096,2966,-1,2968,3586,3096,-1,3467,1511,2614,-1,3467,493,1511,-1,510,504,502,-1,504,510,505,-1,2963,2971,2969,-1,2963,2765,2971,-1,485,2973,2972,-1,485,2121,2973,-1,3659,508,2457,-1,508,3659,2643,-1,507,505,510,-1,505,507,2763,-1,489,3373,491,-1,489,1830,3373,-1,3467,1603,493,-1,1603,3467,1514,-1,526,2974,524,-1,526,2976,2974,-1,528,2977,527,-1,528,2981,2977,-1,1562,528,515,-1,1562,2761,528,-1,3598,2981,2978,-1,2977,2981,3598,-1,532,2982,2760,-1,532,2112,2982,-1,2111,3597,2985,-1,2111,2458,3597,-1,2991,2989,2986,-1,2991,3048,2989,-1,3597,2992,3053,-1,2992,3597,3600,-1,2998,2994,2993,-1,2998,2988,2994,-1,2758,2997,2999,-1,2758,2757,2997,-1,533,3005,2995,-1,3005,533,2760,-1,3004,2996,3002,-1,3008,2996,3004,-1,3009,3001,3007,-1,3011,3001,3009,-1,3003,2983,3017,-1,3003,2982,2983,-1,3006,3016,3020,-1,3006,3014,3016,-1,3021,3012,3019,-1,3024,3012,3021,-1,3015,3598,3029,-1,3015,3599,3598,-1,3028,3018,3026,-1,3032,3018,3028,-1,3033,3022,3031,-1,3035,3022,3033,-1,3027,2980,3038,-1,3027,2978,2980,-1,3043,3040,3039,-1,3043,3030,3040,-1,3047,3045,3042,-1,3047,3036,3045,-1,2984,3050,3041,-1,3050,2984,2985,-1,3052,2987,3044,-1,2987,3052,3051,-1,540,972,541,-1,972,540,1329,-1,535,542,531,-1,1302,542,535,-1,3056,3660,3057,-1,3056,3661,3660,-1,3662,3060,2465,-1,3662,3058,3060,-1,556,557,554,-1,557,556,547,-1,2753,561,563,-1,2753,2097,561,-1,563,569,2753,-1,569,563,3066,-1,332,564,2094,-1,332,342,564,-1,570,3066,2752,-1,570,569,3066,-1,570,573,3592,-1,570,2752,573,-1,579,576,2092,-1,2089,576,579,-1,336,2085,2466,-1,336,574,2085,-1,3069,2750,2751,-1,2749,2750,3069,-1,3071,583,2467,-1,584,583,3071,-1,3661,3060,3059,-1,3661,3056,3060,-1,587,3071,3074,-1,587,584,3071,-1,2103,3059,3595,-1,2103,3661,3059,-1,588,3074,3081,-1,588,587,3074,-1,3595,551,2103,-1,551,3595,3593,-1,558,3081,2099,-1,558,588,3081,-1,3593,2104,551,-1,2104,3593,546,-1,3653,604,590,-1,3654,604,3653,-1,603,611,2748,-1,611,603,599,-1,3086,3583,3663,-1,3085,3583,3086,-1,3585,2066,3088,-1,3585,613,2066,-1,597,603,595,-1,603,600,599,-1,597,600,603,-1,2073,3092,2471,-1,2073,3090,3092,-1,3092,3587,3093,-1,3092,3090,3587,-1,2967,3097,3664,-1,2967,2966,3097,-1,3664,3099,2117,-1,3664,3097,3099,-1,501,3099,3101,-1,2117,3099,501,-1,2116,3101,3103,-1,501,3101,2116,-1,498,3103,2469,-1,2116,3103,498,-1,3105,3656,3627,-1,3105,2937,3656,-1,627,2903,2058,-1,627,2747,2903,-1,3651,2059,2060,-1,2059,3651,2905,-1,2745,631,630,-1,631,2745,2906,-1,629,637,672,-1,629,2744,637,-1,3106,617,2042,-1,617,3106,2060,-1,2051,2056,636,-1,3580,2056,2051,-1,643,3665,2033,-1,643,647,3665,-1,647,651,3665,-1,647,2743,651,-1,2743,658,651,-1,2743,2045,658,-1,2043,655,657,-1,653,655,2043,-1,660,666,656,-1,660,669,666,-1,664,3110,672,-1,664,667,3110,-1,668,3109,674,-1,668,671,3109,-1,621,672,3110,-1,672,621,2474,-1,675,3109,2038,-1,674,3109,675,-1,680,621,678,-1,621,680,622,-1,622,685,681,-1,622,680,685,-1,2039,3666,2040,-1,2039,3667,3666,-1,681,687,683,-1,681,685,687,-1,3667,2035,3666,-1,3667,2036,2035,-1,691,2475,694,-1,691,3107,2475,-1,2034,644,643,-1,2034,2479,644,-1,3116,3113,3114,-1,3112,3113,3116,-1,700,2741,698,-1,700,699,2741,-1,3117,703,3115,-1,3117,704,703,-1,2013,2488,715,-1,2013,3118,2488,-1,2483,2006,2021,-1,3119,2006,2483,-1,3120,709,2009,-1,710,709,3120,-1,2015,3122,3145,-1,2014,3122,2015,-1,3127,3132,3125,-1,3127,3144,3132,-1,3574,2019,3668,-1,2019,3574,2484,-1,3134,3569,3133,-1,3134,3126,3569,-1,3136,3565,3137,-1,3136,3123,3565,-1,712,716,715,-1,716,712,711,-1,2481,720,3576,-1,2481,2480,720,-1,2740,3138,713,-1,2740,2026,3138,-1,3142,2003,3140,-1,2004,2003,3142,-1,732,729,733,-1,732,728,729,-1,731,720,722,-1,2012,720,731,-1,725,3138,734,-1,3141,3138,725,-1,3139,2737,727,-1,2737,3139,3669,-1,2024,2738,2025,-1,2024,3143,2738,-1,3669,3144,2737,-1,3144,3669,3668,-1,2022,3577,3145,-1,2022,710,3577,-1,3129,2482,3578,-1,3129,2023,2482,-1,3670,3147,3148,-1,3670,3155,3147,-1,787,3156,3556,-1,787,738,3156,-1,3205,3152,2001,-1,3153,3152,3205,-1,3670,2726,2648,-1,3670,3148,2726,-1,3147,3117,3114,-1,3155,3117,3147,-1,3157,738,737,-1,738,3157,3156,-1,3112,3158,1995,-1,3112,3116,3158,-1,747,701,748,-1,747,702,701,-1,2027,3158,3573,-1,2027,3159,3158,-1,777,3557,3160,-1,3671,3557,777,-1,3164,3672,3673,-1,3672,3164,3163,-1,762,3674,3166,-1,2731,3674,762,-1,2490,3675,2489,-1,3675,2490,3676,-1,2490,1992,1985,-1,1992,2490,757,-1,3180,3558,3168,-1,3558,3180,3177,-1,3168,3183,3180,-1,3168,3166,3183,-1,3191,2489,3675,-1,3191,3184,2489,-1,3166,3187,3183,-1,3166,3674,3187,-1,3677,3191,3188,-1,3191,3677,3184,-1,3674,3678,3187,-1,3674,3572,3678,-1,3193,3677,3188,-1,3193,3679,3677,-1,3162,3678,3572,-1,3162,763,3678,-1,3196,3679,3193,-1,3196,3198,3679,-1,3164,763,3162,-1,3164,764,763,-1,768,3198,3196,-1,768,2491,3198,-1,3673,764,3164,-1,3673,2729,764,-1,3559,2729,3673,-1,3559,769,2729,-1,1988,1990,770,-1,1988,772,1990,-1,751,2018,2728,-1,751,1987,2018,-1,3202,3161,3160,-1,3161,3202,3560,-1,3680,1989,3203,-1,1989,3680,775,-1,3569,779,759,-1,779,3569,1986,-1,3568,3203,3179,-1,3203,3568,3680,-1,781,3153,3205,-1,781,2492,3153,-1,3670,2493,2735,-1,3670,2648,2493,-1,3153,1168,3151,-1,3153,2492,1168,-1,3208,3209,3207,-1,3208,3210,3209,-1,3213,3510,3509,-1,3213,3552,3510,-1,2721,2724,804,-1,2721,3211,2724,-1,813,1091,1093,-1,812,1091,813,-1,2720,819,3214,-1,2720,1972,819,-1,803,2500,2499,-1,803,807,2500,-1,819,1974,820,-1,819,1972,1974,-1,3216,1976,1975,-1,1976,3216,822,-1,3215,827,1970,-1,3215,2719,827,-1,2717,823,831,-1,825,823,2717,-1,1973,836,1974,-1,1973,837,836,-1,828,856,829,-1,828,836,856,-1,860,840,848,-1,860,841,840,-1,852,1962,842,-1,851,1962,852,-1,2510,861,2508,-1,2510,1964,861,-1,3220,3218,1958,-1,3681,3218,3220,-1,2508,3682,2509,-1,3682,2508,3221,-1,866,3224,3683,-1,866,1954,3224,-1,3272,3220,3225,-1,3272,3681,3220,-1,3231,3684,3229,-1,3231,3685,3684,-1,3234,3686,3687,-1,3233,3686,3234,-1,3688,3689,3690,-1,3691,3689,3688,-1,3691,3692,3689,-1,3693,3692,3691,-1,3693,3694,3692,-1,3695,3694,3693,-1,3695,3696,3694,-1,3697,3696,3695,-1,3697,3698,3696,-1,3697,3699,3698,-1,3275,3232,3244,-1,3232,3275,3546,-1,3240,3699,3238,-1,3699,3240,3698,-1,3234,3244,3232,-1,3234,3242,3244,-1,3699,3246,3238,-1,3697,3246,3699,-1,3687,3242,3234,-1,3687,3248,3242,-1,3697,3251,3246,-1,3695,3251,3697,-1,3547,3248,3687,-1,3547,3252,3248,-1,3251,3693,3254,-1,3693,3251,3695,-1,3230,3252,3547,-1,3230,3257,3252,-1,3254,3691,3258,-1,3691,3254,3693,-1,3261,3230,3229,-1,3261,3257,3230,-1,3258,3688,3262,-1,3688,3258,3691,-1,3265,3229,3684,-1,3265,3261,3229,-1,3262,3690,3266,-1,3690,3262,3688,-1,3268,3684,873,-1,3268,3265,3684,-1,3690,3269,3266,-1,3689,3269,3690,-1,3689,3700,3269,-1,3692,3700,3689,-1,872,2712,3270,-1,3271,2712,872,-1,3692,3274,3700,-1,3694,3274,3692,-1,3274,3696,3273,-1,3696,3274,3694,-1,3546,874,3533,-1,3546,3275,874,-1,3273,3698,3240,-1,3698,3273,3696,-1,3278,3284,3701,-1,3278,3277,3284,-1,905,3281,1919,-1,905,882,3281,-1,2517,881,1930,-1,2517,882,881,-1,3283,3279,3529,-1,3283,3277,3279,-1,892,3286,2710,-1,892,891,3286,-1,3702,3290,3287,-1,3304,3290,3702,-1,3304,3703,3290,-1,3302,3703,3304,-1,3302,3704,3703,-1,3303,3704,3302,-1,3303,3295,3704,-1,3299,3295,3303,-1,3299,3294,3295,-1,3299,3300,3294,-1,3290,3530,3288,-1,3530,3290,3703,-1,3280,1932,3458,-1,3280,2517,1932,-1,3280,3459,3531,-1,3280,3458,3459,-1,1551,3531,3459,-1,3529,3531,1551,-1,1924,2711,2710,-1,1924,2518,2711,-1,890,2520,888,-1,890,891,2520,-1,894,3283,895,-1,3282,3283,894,-1,1575,2709,3301,-1,1556,2709,1575,-1,2522,3305,1921,-1,2522,1923,3305,-1,3304,3527,3305,-1,3527,3304,3702,-1,880,1940,884,-1,880,951,1940,-1,3278,1890,1892,-1,3701,1890,3278,-1,1979,907,1914,-1,3210,907,1979,-1,3705,1981,3308,-1,1981,3705,3555,-1,3705,3311,3316,-1,3705,3308,3311,-1,908,3526,3314,-1,908,909,3526,-1,3312,1907,3313,-1,914,1907,3312,-1,2524,1904,915,-1,1904,2524,906,-1,3316,1905,1902,-1,1905,3316,3311,-1,3319,3337,3317,-1,3340,3319,3513,-1,3340,3337,3319,-1,939,915,1904,-1,939,916,915,-1,3323,921,938,-1,3323,922,921,-1,1557,925,3522,-1,926,925,1557,-1,911,3322,3523,-1,911,1909,3322,-1,3330,3321,3511,-1,3330,3320,3321,-1,961,930,962,-1,961,3333,930,-1,933,3331,3329,-1,933,1908,3331,-1,3326,2531,3333,-1,3326,3706,2531,-1,933,1909,934,-1,933,3324,1909,-1,910,1909,911,-1,1910,1909,910,-1,3517,920,942,-1,920,3517,2527,-1,943,3462,1564,-1,1897,3462,943,-1,3518,3335,2526,-1,3518,3325,3335,-1,3325,947,3335,-1,3325,2530,947,-1,2530,948,947,-1,2530,949,948,-1,3707,948,950,-1,948,3707,2706,-1,3339,3707,3512,-1,3707,3339,3338,-1,1891,1941,953,-1,1891,879,1941,-1,1891,877,879,-1,877,1891,1918,-1,958,2529,2704,-1,1900,2529,958,-1,2495,789,788,-1,3554,789,2495,-1,1983,1984,791,-1,3207,1984,1983,-1,796,793,1641,-1,793,796,795,-1,814,1977,812,-1,1977,814,811,-1,1767,3212,2722,-1,3212,1767,3211,-1,2497,3510,3342,-1,2497,815,3510,-1,968,817,816,-1,817,968,2450,-1,2567,1829,1088,-1,1829,2567,2679,-1,3708,2549,2613,-1,3708,3343,2549,-1,984,2550,3393,-1,984,981,2550,-1,990,1873,1050,-1,1873,990,989,-1,2552,2701,996,-1,2701,2552,2702,-1,3394,2545,3346,-1,2545,3394,1033,-1,1726,2566,1727,-1,2566,1726,1268,-1,1773,3349,1855,-1,3349,1773,1871,-1,2587,1828,1827,-1,2587,3493,1828,-1,1753,1827,2681,-1,1753,2587,1827,-1,1832,1008,3481,-1,1832,1006,1008,-1,2599,1866,1865,-1,3709,1866,2599,-1,3351,3710,1665,-1,3710,3351,3350,-1,1011,1016,1012,-1,1011,1014,1016,-1,1718,1019,1018,-1,1019,1718,1717,-1,1837,3352,3711,-1,1836,3352,1837,-1,1271,1729,3370,-1,1271,1863,1729,-1,3357,3354,3355,-1,3353,3354,3357,-1,3364,3359,3358,-1,3359,3364,3712,-1,3395,2582,3360,-1,3395,1782,2582,-1,1782,1724,1159,-1,1782,3395,1724,-1,3395,2596,1724,-1,2596,3395,3346,-1,2671,2696,2670,-1,2696,2671,3362,-1,3393,3343,984,-1,1875,3343,3393,-1,1054,1652,2693,-1,1054,1053,1652,-1,2701,991,1055,-1,2702,991,2701,-1,2556,1843,2557,-1,1751,1843,2556,-1,1070,2691,2690,-1,1070,1069,2691,-1,2688,2560,1757,-1,2688,2687,2560,-1,3711,2685,2684,-1,3711,3352,2685,-1,1771,1859,2683,-1,1771,1862,1859,-1,3602,3498,445,-1,3390,3498,3602,-1,3357,1214,3366,-1,3356,1214,3357,-1,3391,2668,3368,-1,1648,2668,3391,-1,3498,3712,445,-1,3498,3359,3712,-1,1792,3386,3385,-1,1792,3371,3386,-1,1276,2546,1277,-1,1165,2546,1276,-1,2676,1165,1276,-1,1101,1165,2676,-1,1442,2493,1443,-1,2493,1442,1640,-1,2379,1404,3372,-1,2379,8,1404,-1,2674,1108,1107,-1,2674,3503,1108,-1,1288,1818,1114,-1,1817,1818,1288,-1,1111,2653,1822,-1,1111,1364,2653,-1,1399,1822,2653,-1,1399,1661,1822,-1,515,1684,516,-1,515,2108,1684,-1,1139,1776,1140,-1,1776,1139,1811,-1,1431,1422,1421,-1,1422,1431,1430,-1,2694,1807,1849,-1,2694,1047,1807,-1,1848,1873,989,-1,986,1873,1848,-1,2551,1422,1048,-1,2551,988,1422,-1,1058,3508,2553,-1,1058,3344,3508,-1,1251,3374,1253,-1,3713,3374,1251,-1,1808,3376,1311,-1,1810,3376,1808,-1,1708,1152,1290,-1,1708,2600,1152,-1,1158,2678,1157,-1,3371,2678,1158,-1,3378,1132,1156,-1,1132,3378,2571,-1,1130,3379,3399,-1,1813,3379,1130,-1,3376,3714,1295,-1,3376,3375,3714,-1,2543,3505,3361,-1,1853,3505,2543,-1,1781,1102,1101,-1,1781,1780,1102,-1,1170,3383,3483,-1,3383,1170,1169,-1,3384,3380,3715,-1,3382,3380,3384,-1,3715,1846,2581,-1,3380,1846,3715,-1,1815,1094,1646,-1,1094,1815,3385,-1,1869,1852,2670,-1,1868,1852,1869,-1,1648,1177,2668,-1,1648,1178,1177,-1,1182,1145,2700,-1,1793,1145,1182,-1,1183,1077,1836,-1,1077,1183,1075,-1,1427,1826,1428,-1,1769,1826,1427,-1,1093,3414,2568,-1,1093,1768,3414,-1,816,2497,1191,-1,2497,816,815,-1,3387,1197,1196,-1,1197,3387,1763,-1,2559,1068,1064,-1,2559,1841,1068,-1,1230,1204,1203,-1,1204,1230,2589,-1,1870,1830,1004,-1,1870,3373,1830,-1,1080,1210,1078,-1,1833,1210,1080,-1,1060,234,212,-1,1060,2555,234,-1,1220,1063,1838,-1,1219,1063,1220,-1,1423,281,283,-1,281,1423,1148,-1,3507,2684,1835,-1,3507,3711,2684,-1,3367,3359,3498,-1,3367,2542,3359,-1,2565,1088,1090,-1,2565,2567,1088,-1,1069,1843,2691,-1,2557,1843,1069,-1,1750,1382,1383,-1,1750,2588,1382,-1,2561,1757,2586,-1,1757,2561,2688,-1,3387,1232,3497,-1,3387,1230,1232,-1,1238,3388,2590,-1,3388,1238,1745,-1,2591,1241,1650,-1,2591,1742,1241,-1,1743,1247,1424,-1,1247,1743,1249,-1,3496,1249,1743,-1,1250,1249,3496,-1,1246,3713,1251,-1,1246,3494,3713,-1,2536,1057,2673,-1,1057,2536,2537,-1,985,1671,1051,-1,1872,1671,985,-1,1222,1856,1223,-1,1222,1426,1856,-1,1001,1425,1179,-1,1001,1728,1425,-1,296,1673,293,-1,296,1672,1673,-1,1867,2539,2650,-1,1865,2539,1867,-1,2460,1717,1358,-1,2460,2598,1717,-1,1012,1541,1013,-1,1542,1541,1012,-1,1707,1784,1786,-1,1784,1707,1706,-1,1787,1702,1305,-1,1702,1787,2578,-1,1126,1156,1127,-1,1126,3378,1156,-1,1308,3398,1699,-1,1308,1296,3398,-1,1299,3714,3489,-1,1299,2663,3714,-1,1707,1710,1697,-1,3716,1710,1707,-1,1710,1323,1697,-1,1710,1703,1323,-1,3502,1305,3489,-1,1305,3502,1787,-1,1286,1709,1287,-1,1704,1709,1286,-1,1362,1293,534,-1,1361,1293,1362,-1,1333,539,1334,-1,539,1333,1330,-1,1696,3406,1697,-1,3406,1696,3486,-1,3404,2601,1326,-1,1695,2601,3404,-1,3405,1331,1330,-1,3400,1331,3405,-1,1697,3403,1306,-1,3403,1697,3406,-1,2658,3488,3407,-1,2658,3404,3488,-1,3405,1346,1686,-1,3405,3487,1346,-1,1356,1320,3412,-1,1355,1320,1356,-1,1359,1717,1716,-1,1359,1358,1717,-1,1683,1363,1362,-1,1363,1683,2657,-1,2655,3409,3408,-1,3409,2655,2654,-1,1356,1673,1357,-1,3410,1673,1356,-1,2653,3411,1399,-1,1366,3411,2653,-1,1401,1379,1371,-1,1379,1401,2652,-1,3396,1548,1023,-1,3396,3596,1548,-1,3717,1684,973,-1,1684,3717,1685,-1,1685,3710,3350,-1,1685,3717,3710,-1,3409,1351,1350,-1,3409,2656,1351,-1,3412,1319,2655,-1,1320,1319,3412,-1,2651,967,1669,-1,2651,1173,967,-1,1283,1713,1667,-1,1283,1714,1713,-1,1010,3503,1403,-1,3503,1010,1374,-1,1407,1409,1134,-1,2573,1409,1407,-1,1124,2572,1123,-1,1124,1136,2572,-1,1136,1124,1789,-1,1777,1057,1056,-1,1777,2673,1057,-1,1116,1823,1819,-1,1414,1823,1116,-1,1823,1187,1418,-1,1823,1414,1187,-1,1070,1765,1071,-1,1070,2558,1765,-1,1072,1067,1066,-1,1074,1067,1072,-1,1007,2683,1834,-1,1007,1006,2683,-1,1829,1087,512,-1,1829,1828,1087,-1,1438,2696,1851,-1,1438,1869,2696,-1,1778,1103,1824,-1,1104,1103,1778,-1,1459,2646,1490,-1,2647,2646,1459,-1,1455,3417,3480,-1,3415,3417,1455,-1,2647,1629,2646,-1,2647,3418,1629,-1,3417,3422,3718,-1,3416,3422,3417,-1,1463,3419,2645,-1,3419,1463,3418,-1,3427,3718,3422,-1,3427,3719,3718,-1,3477,3431,3720,-1,3719,3431,3477,-1,3719,3430,3431,-1,3427,3430,3719,-1,3720,1619,1618,-1,3431,1619,3720,-1,1476,1623,1624,-1,1623,1476,3432,-1,1478,1469,1479,-1,1478,1470,1469,-1,1482,1487,2118,-1,1487,1482,1484,-1,1619,2642,1485,-1,2642,1619,2640,-1,3433,2638,511,-1,3433,2639,2638,-1,3436,1451,3721,-1,1451,3436,1635,-1,1451,3435,3721,-1,1634,3435,1451,-1,3437,3721,3722,-1,3721,3437,3436,-1,1601,1497,1615,-1,1601,1516,1497,-1,1495,2632,1523,-1,1499,2632,1495,-1,3470,3722,3473,-1,3722,3470,3437,-1,2636,1525,2623,-1,3439,1525,2636,-1,3438,3442,3474,-1,3438,3439,3442,-1,3445,3442,3441,-1,3471,3442,3445,-1,3449,3443,3446,-1,3449,3445,3443,-1,1605,3449,3448,-1,1605,3472,3449,-1,2635,2634,3469,-1,2635,1508,2634,-1,1513,3468,3452,-1,1513,1512,3468,-1,2614,1513,1522,-1,2614,1511,1513,-1,3455,1515,1514,-1,1456,1515,3455,-1,1520,3453,3456,-1,1520,1522,3453,-1,3465,1520,1597,-1,3465,1521,1520,-1,2632,3454,1524,-1,2632,1457,3454,-1,1611,3464,1596,-1,2617,3464,1611,-1,1544,1530,1591,-1,1544,1531,1530,-1,1585,1548,2624,-1,1585,1587,1548,-1,1537,2631,1584,-1,1537,1542,2631,-1,1529,1570,1574,-1,1529,2627,1570,-1,3292,1573,3291,-1,1573,3292,1533,-1,1528,897,2624,-1,1576,897,1528,-1,1897,3327,3462,-1,3327,1897,1896,-1,1563,2629,1558,-1,2629,1563,2628,-1,903,901,904,-1,903,902,901,-1,1558,1894,1559,-1,901,1894,1558,-1,1564,3461,2628,-1,3461,1564,3462,-1,930,936,931,-1,1899,936,930,-1,1576,1552,1577,-1,1576,1528,1552,-1,3459,1549,1551,-1,3459,1567,1549,-1,3458,1570,1572,-1,1932,1570,3458,-1,1932,1574,1570,-1,1931,1574,1932,-1,1588,1533,1529,-1,1533,1588,1534,-1,2622,1500,3463,-1,2622,1595,1500,-1,2617,1592,3464,-1,2623,1592,2617,-1,1596,3465,1597,-1,3464,3465,1596,-1,1599,1594,1593,-1,1599,1600,1594,-1,3465,3466,1521,-1,3457,3466,3465,-1,1517,3456,3453,-1,3456,1517,1599,-1,3466,1514,3467,-1,3455,1514,3466,-1,3451,3452,3468,-1,3452,3451,2633,-1,3469,1512,1604,-1,1512,3469,3468,-1,2635,1604,3447,-1,1604,2635,3469,-1,2619,3472,1605,-1,2619,3470,3472,-1,3472,3445,3449,-1,3472,3471,3445,-1,3471,3474,3442,-1,3473,3474,3471,-1,1608,1610,1609,-1,3444,1610,1608,-1,3463,1607,1606,-1,3463,1500,1607,-1,3473,3475,3474,-1,3475,3473,3722,-1,2619,1615,1614,-1,2619,1601,1615,-1,3721,3475,3722,-1,3435,3475,3721,-1,1498,1633,1616,-1,1498,1494,1633,-1,1613,1635,3436,-1,1635,1613,1617,-1,1485,3434,1484,-1,3434,1485,2642,-1,1620,1480,1479,-1,1483,1480,1620,-1,1623,1478,1477,-1,1623,3432,1478,-1,1489,1466,1475,-1,1466,1489,1467,-1,3476,1618,1621,-1,3720,1618,3476,-1,2641,1467,1489,-1,1467,2641,3429,-1,3720,3428,3477,-1,3720,3476,3428,-1,3719,3478,3718,-1,3719,3477,3478,-1,1468,1628,1627,-1,1628,1468,3479,-1,1630,3418,1463,-1,3418,1630,1629,-1,3480,3718,3478,-1,3417,3718,3480,-1,3420,1628,3479,-1,1631,1628,3420,-1,3424,1455,3480,-1,1455,3424,1632,-1,1453,3420,3423,-1,1452,3420,1453,-1,1490,1464,1617,-1,2646,1464,1490,-1,1097,1446,1443,-1,1097,1637,1446,-1,1870,1794,3373,-1,1794,1870,3481,-1,2679,2595,2680,-1,2679,2594,2595,-1,1007,2684,1180,-1,1835,2684,1007,-1,1202,2690,1384,-1,2690,1202,1842,-1,1065,1838,1063,-1,1065,1839,1838,-1,1056,2552,1846,-1,2552,1056,2554,-1,2260,1659,1653,-1,2260,2577,1659,-1,2675,1659,3372,-1,2675,1406,1659,-1,1109,1364,1111,-1,1109,1120,1364,-1,2609,1386,1387,-1,1386,2609,1670,-1,2607,1716,1721,-1,2607,1359,1716,-1,3484,3717,3485,-1,3484,3710,3717,-1,2699,1020,2597,-1,2699,1676,1020,-1,1349,1678,2606,-1,1681,1678,1349,-1,1344,1678,1691,-1,1679,1678,1344,-1,1372,1349,1370,-1,1349,1372,1681,-1,1376,2604,1677,-1,1690,2604,1376,-1,264,969,295,-1,1880,969,264,-1,2655,3413,3412,-1,2655,3408,3413,-1,3485,973,1694,-1,3485,3717,973,-1,1538,1864,1866,-1,1864,1538,1561,-1,1690,1686,2604,-1,1690,1689,1686,-1,3487,1347,1346,-1,3487,3402,1347,-1,1688,3488,3401,-1,3407,3488,1688,-1,3486,1693,3406,-1,1693,3486,1342,-1,1330,3487,3405,-1,1330,1333,3487,-1,3488,1326,1327,-1,3404,1326,3488,-1,3486,2660,2659,-1,3486,1696,2660,-1,1355,2660,1320,-1,2602,2660,1355,-1,1361,1291,1293,-1,1698,1291,1361,-1,1674,1361,1363,-1,1674,1698,1361,-1,1710,1153,2600,-1,3716,1153,1710,-1,3397,1304,1306,-1,3397,1312,1304,-1,2663,1295,3714,-1,1295,2663,1296,-1,1313,1299,1304,-1,1299,1313,1297,-1,3716,1786,1153,-1,1786,3716,1707,-1,3377,2569,3491,-1,1303,2569,3377,-1,2630,3709,3492,-1,3709,2630,1543,-1,2598,3596,3396,-1,2598,2460,3596,-1,1716,1397,1721,-1,1718,1397,1716,-1,3349,3364,3348,-1,3349,3506,3364,-1,1002,1179,1863,-1,1179,1002,1001,-1,1734,1436,964,-1,1734,1037,1436,-1,984,3708,982,-1,3708,984,3343,-1,2538,2546,2665,-1,1277,2546,2538,-1,1259,1737,1645,-1,1257,1737,1259,-1,2593,3713,3494,-1,3713,2593,1738,-1,3374,1738,1739,-1,3374,3713,1738,-1,1740,1742,2591,-1,3495,1742,1740,-1,1742,3496,1743,-1,3496,1742,3495,-1,1062,1751,2556,-1,1062,1752,1751,-1,1842,1070,2690,-1,1842,2558,1070,-1,2691,1746,1384,-1,1843,1746,2691,-1,1269,2594,1270,-1,1269,1000,2594,-1,3356,1212,1214,-1,3356,3369,1212,-1,3391,1213,1212,-1,3389,1213,3391,-1,1076,2687,2564,-1,2560,2687,1076,-1,1220,2863,1221,-1,2863,1220,3482,-1,2560,1075,1758,-1,1076,1075,2560,-1,289,1210,1761,-1,289,288,1210,-1,978,1877,979,-1,1730,1877,978,-1,2584,1233,1239,-1,2584,2590,1233,-1,1763,3497,2667,-1,1763,3387,3497,-1,1418,1096,1416,-1,1418,1189,1096,-1,3352,2563,2685,-1,2563,3352,2698,-1,1759,3499,3482,-1,3499,1759,1758,-1,1215,1079,1078,-1,1215,1861,1079,-1,1408,2581,1775,-1,1408,3715,2581,-1,3715,1408,3483,-1,3483,3384,3715,-1,3384,3483,3383,-1,1638,1103,1825,-1,1638,1824,1103,-1,2677,3504,1260,-1,2677,1100,3504,-1,1035,1100,2677,-1,784,1779,2580,-1,784,1167,1779,-1,1161,2164,1162,-1,1647,2164,1161,-1,3375,3489,3714,-1,3489,3375,3502,-1,1131,3399,3490,-1,1130,3399,1131,-1,2570,1790,1815,-1,2570,3491,1790,-1,1709,1290,1289,-1,1708,1290,1709,-1,2575,1787,3502,-1,1788,1787,2575,-1,1311,1654,1808,-1,1311,1310,1654,-1,1255,1795,1649,-1,1255,1636,1795,-1,1760,1796,1278,-1,1796,1760,3353,-1,1055,994,2701,-1,1055,1798,994,-1,987,1799,1227,-1,987,2535,1799,-1,1804,1879,1802,-1,1804,2695,1879,-1,1430,1048,1422,-1,1048,1430,1046,-1,2574,1809,1133,-1,1810,1809,2574,-1,1407,1811,2573,-1,1776,1811,1407,-1,1117,1123,1405,-1,1110,1123,1117,-1,1711,1817,1288,-1,1711,1660,1817,-1,2675,1404,1403,-1,2675,3372,1404,-1,1189,2568,1826,-1,1189,1188,2568,-1,1648,1212,2612,-1,1212,1648,3391,-1,1857,3347,1858,-1,3347,1857,1727,-1,1755,3493,2587,-1,1755,3355,3493,-1,3390,394,3389,-1,3390,3602,394,-1,2541,1835,1834,-1,2541,3507,1835,-1,2558,1841,2559,-1,1842,1841,2558,-1,992,2553,3508,-1,2554,2553,992,-1,1652,3345,2693,-1,1652,1735,3345,-1,1141,2261,1142,-1,2261,1141,2610,-1,2551,2694,1801,-1,2551,1047,2694,-1,2576,982,3708,-1,2576,1806,982,-1,3392,1265,1851,-1,1265,3392,1266,-1,1871,3506,3349,-1,1871,1027,3506,-1,3361,1162,2543,-1,1163,1162,3361,-1,3506,3712,3364,-1,3712,3506,2158,-1,1426,1857,1856,-1,1857,1426,1725,-1,2585,1860,1273,-1,2585,1209,1860,-1,1756,1208,1833,-1,1756,1762,1208,-1,1861,1859,1862,-1,1217,1859,1861,-1,1754,3370,3369,-1,1754,1271,3370,-1,2686,3711,3507,-1,2686,1837,3711,-1,3492,2599,1714,-1,3709,2599,3492,-1,3710,1666,1665,-1,3484,1666,3710,-1,3709,1538,1866,-1,3709,1543,1538,-1,1081,3481,1870,-1,1081,1832,3481,-1,1087,3493,2682,-1,1828,3493,1087,-1,1853,1034,3505,-1,1853,1030,1034,-1,3347,1090,3365,-1,1090,3347,2565,-1,1728,1000,1269,-1,1728,1001,1000,-1,1277,1722,2697,-1,1277,2538,1722,-1,3508,993,992,-1,3508,2692,993,-1,2536,1226,1205,-1,1872,1226,2536,-1,986,2535,987,-1,986,1848,2535,-1,3393,1045,3363,-1,3393,2550,1045,-1,3708,2695,2576,-1,3708,2613,2695,-1,1876,975,1043,-1,1877,975,1876,-1,1270,2679,2567,-1,2679,1270,2594,-1,2722,3553,2703,-1,2722,3212,3553,-1,2703,3509,817,-1,2703,3553,3509,-1,1091,1978,1092,-1,1091,808,1978,-1,789,799,963,-1,789,3554,799,-1,1261,2496,1262,-1,1261,3209,2496,-1,963,798,1882,-1,963,799,798,-1,3511,3317,3341,-1,3511,3321,3317,-1,958,3512,2533,-1,958,957,3512,-1,1941,1888,1886,-1,952,1888,1941,-1,3512,950,2533,-1,950,3512,3707,-1,1941,951,952,-1,1941,1940,951,-1,3338,2706,3707,-1,2706,3338,3514,-1,3514,3723,3515,-1,3514,3513,3723,-1,3723,3516,3515,-1,3516,3723,3724,-1,3724,3517,3516,-1,3517,3724,3521,-1,3521,2527,3517,-1,2527,3521,3519,-1,937,945,3460,-1,1566,945,937,-1,3706,1898,2531,-1,3706,1895,1898,-1,3520,3332,940,-1,3332,3520,3318,-1,3329,3324,933,-1,3329,3328,3324,-1,927,3333,961,-1,927,3326,3333,-1,3331,3511,956,-1,3331,3330,3511,-1,1896,3706,3326,-1,1896,1895,3706,-1,949,1893,950,-1,1893,949,1894,-1,3523,3518,911,-1,3522,3518,3523,-1,2529,922,3328,-1,922,2529,923,-1,3460,3522,3523,-1,1557,3522,3460,-1,941,914,913,-1,941,1907,914,-1,1905,1910,1902,-1,1910,1905,934,-1,3521,3513,3319,-1,3521,3723,3513,-1,3724,3723,3521,-1,3311,2528,1905,-1,2528,3311,3310,-1,906,918,1904,-1,918,906,908,-1,2525,914,3312,-1,1906,914,2525,-1,939,2527,940,-1,1903,2527,939,-1,942,913,2526,-1,942,941,913,-1,3314,3524,3313,-1,3314,3526,3524,-1,2524,3525,1914,-1,3315,3525,2524,-1,3705,1913,1912,-1,1913,3705,3316,-1,1912,3555,3705,-1,3555,1912,1915,-1,801,1914,3525,-1,1979,1914,801,-1,3526,2494,3524,-1,2494,3526,1982,-1,1890,1937,1891,-1,1890,3701,1937,-1,3702,3289,3527,-1,3289,3702,3287,-1,3305,2523,1921,-1,2523,3305,3527,-1,2522,898,2521,-1,898,2522,1921,-1,1555,2709,1556,-1,1555,894,2709,-1,893,2521,2520,-1,2521,893,2522,-1,3299,1922,2711,-1,1922,3299,3303,-1,896,1551,1550,-1,895,1551,896,-1,3297,2710,3286,-1,3297,1924,2710,-1,1926,3300,2518,-1,1926,3294,3300,-1,1571,3298,1568,-1,1571,3293,3298,-1,3291,1925,3296,-1,3291,1928,1925,-1,1929,3295,1927,-1,1929,3704,3295,-1,3703,1929,3530,-1,1929,3703,3704,-1,3288,1589,1553,-1,1589,3288,3530,-1,3532,3529,3279,-1,3531,3529,3532,-1,881,1935,1930,-1,1935,881,883,-1,3528,1938,2516,-1,3528,3306,1938,-1,1919,3532,1920,-1,1919,3281,3532,-1,2516,3701,3284,-1,3701,2516,1937,-1,3549,2713,870,-1,3549,1942,2713,-1,3237,3272,1945,-1,3237,3236,3272,-1,3227,3533,3271,-1,3227,3549,3533,-1,3700,1944,1946,-1,3274,1944,3700,-1,876,3270,2712,-1,876,2512,3270,-1,3269,1946,2513,-1,3700,1946,3269,-1,3226,1950,1949,-1,3226,3550,1950,-1,3534,871,3685,-1,1948,871,3534,-1,3550,3535,1950,-1,3550,3683,3535,-1,3536,3685,3231,-1,3534,3685,3536,-1,3683,3537,3535,-1,3683,3224,3537,-1,3538,3231,3228,-1,3536,3231,3538,-1,3224,3539,3537,-1,3224,3223,3539,-1,3538,3548,3540,-1,3538,3228,3548,-1,3223,3541,3539,-1,3223,3551,3541,-1,3686,3540,3548,-1,3540,3686,3542,-1,3541,3682,3543,-1,3541,3551,3682,-1,3233,3542,3686,-1,3542,3233,3544,-1,3543,3221,3545,-1,3543,3682,3221,-1,869,3544,3233,-1,3544,869,868,-1,3545,3222,3235,-1,3545,3221,3222,-1,3244,3276,3275,-1,3244,3243,3276,-1,3533,870,3546,-1,3549,870,3533,-1,3687,3548,3547,-1,3686,3548,3687,-1,3685,873,3684,-1,3685,871,873,-1,3236,3681,3272,-1,3236,2714,3681,-1,867,3683,3550,-1,867,866,3683,-1,1957,3682,3551,-1,1957,2509,3682,-1,2714,3218,3681,-1,2714,2716,3218,-1,1953,2511,1954,-1,1953,1955,2511,-1,1956,1964,2510,-1,1956,2505,1964,-1,2504,1971,829,-1,1966,1971,2504,-1,859,848,1966,-1,859,860,848,-1,854,1968,1965,-1,854,2503,1968,-1,2718,837,1973,-1,2718,2503,837,-1,1969,823,822,-1,823,1969,831,-1,2719,828,827,-1,2719,820,828,-1,824,807,806,-1,807,824,2500,-1,2498,3217,1975,-1,2498,3552,3217,-1,3342,3552,2498,-1,3552,3342,3510,-1,3553,3213,3509,-1,3214,3213,3553,-1,1981,3554,2495,-1,1981,3555,3554,-1,3206,741,740,-1,3150,741,3206,-1,3556,1168,1106,-1,3556,3151,1168,-1,741,2736,2000,-1,2736,741,3150,-1,3671,3176,3571,-1,3174,3176,3671,-1,3570,3680,3568,-1,3680,3570,755,-1,777,3174,3671,-1,776,3174,777,-1,755,775,3680,-1,775,755,754,-1,1988,3202,1989,-1,3560,3202,1988,-1,770,3560,1988,-1,769,3560,770,-1,3170,3201,3672,-1,3170,3172,3201,-1,3171,3672,3163,-1,3171,3170,3672,-1,766,3196,3195,-1,766,768,3196,-1,3165,3171,3163,-1,3169,3171,3165,-1,3198,3562,3679,-1,3198,3197,3562,-1,3563,763,765,-1,3678,763,3563,-1,3562,3677,3679,-1,3677,3562,3564,-1,3186,3678,3563,-1,3187,3678,3186,-1,3564,3184,3677,-1,3184,3564,3185,-1,3191,3566,3189,-1,3566,3191,3675,-1,3175,762,3167,-1,3175,760,762,-1,3675,3567,3566,-1,3567,3675,3676,-1,3176,3167,3571,-1,3176,3175,3167,-1,3676,3568,3567,-1,3568,3676,3570,-1,2490,3570,3676,-1,2490,1985,3570,-1,3671,3558,3557,-1,3571,3558,3671,-1,3674,3192,3572,-1,3192,3674,2731,-1,3673,3201,3559,-1,3201,3673,3672,-1,3118,1994,2488,-1,3118,1996,1994,-1,3573,706,2027,-1,706,3573,2487,-1,3573,3116,3115,-1,3158,3116,3573,-1,1999,1997,1996,-1,1999,2486,1997,-1,699,3152,2741,-1,3152,699,2001,-1,3149,3114,3113,-1,3147,3114,3149,-1,2001,3206,3205,-1,2001,2002,3206,-1,739,787,785,-1,739,738,787,-1,2735,3155,3670,-1,2735,2734,3155,-1,3121,2482,3119,-1,3578,2482,3121,-1,710,3124,3577,-1,710,3120,3124,-1,3575,3668,3669,-1,3668,3575,3574,-1,2006,2738,724,-1,2025,2738,2006,-1,2003,3669,3139,-1,3669,2003,3575,-1,2012,3576,720,-1,2011,3576,2012,-1,2008,2011,2012,-1,2008,2007,2011,-1,2004,3141,3143,-1,3141,2004,3142,-1,2028,3576,735,-1,2028,2481,3576,-1,3123,2017,3565,-1,3123,2014,2017,-1,3126,1986,3569,-1,3126,3125,1986,-1,2020,3128,3561,-1,2020,2484,3128,-1,3668,3132,3144,-1,3132,3668,2019,-1,3134,3145,3577,-1,2015,3145,3134,-1,3130,3578,3136,-1,3130,3129,3578,-1,2024,3146,2005,-1,3146,2024,2023,-1,2026,3159,2027,-1,2740,3159,2026,-1,2739,745,750,-1,721,745,2739,-1,715,1993,712,-1,715,2488,1993,-1,737,2486,3157,-1,2486,737,1997,-1,2849,2914,2777,-1,2914,2849,3645,-1,2034,2033,2032,-1,2034,643,2033,-1,690,3107,691,-1,690,640,3107,-1,3666,2037,3579,-1,3666,2035,2037,-1,2040,3579,2041,-1,2040,3666,3579,-1,2038,2041,675,-1,2038,2040,2041,-1,3108,2038,3109,-1,3108,2478,2038,-1,667,3111,3110,-1,667,666,3111,-1,646,655,2047,-1,646,2477,655,-1,650,3665,651,-1,2053,3665,650,-1,2053,2033,3665,-1,2052,2033,2053,-1,644,648,645,-1,644,661,648,-1,2479,661,644,-1,2479,662,661,-1,2036,662,2479,-1,2036,670,662,-1,3667,670,2036,-1,3667,3108,670,-1,2039,3108,3667,-1,2478,3108,2039,-1,2061,2057,618,-1,2061,2058,2057,-1,677,2061,623,-1,632,2061,677,-1,3581,2060,3106,-1,2060,3581,3651,-1,3582,2891,3655,-1,2891,3582,2894,-1,2075,594,593,-1,3086,594,2075,-1,3663,594,3086,-1,596,594,3663,-1,2077,3663,3589,-1,2077,596,3663,-1,598,3589,3089,-1,598,2077,3589,-1,2919,3094,2235,-1,3094,2919,3652,-1,2063,3664,2064,-1,2063,2967,3664,-1,3586,3088,3096,-1,3586,3585,3088,-1,2748,614,3091,-1,2748,611,614,-1,601,3091,2468,-1,601,2748,3091,-1,2074,2471,2470,-1,2074,2073,2471,-1,590,3652,3653,-1,590,3094,3652,-1,2068,3094,590,-1,3587,613,3585,-1,3587,614,613,-1,3589,3583,3584,-1,3583,3589,3663,-1,592,2068,590,-1,2069,2068,592,-1,562,553,552,-1,562,3078,553,-1,3077,3083,3076,-1,3083,3077,3082,-1,3081,3075,3080,-1,3081,3074,3075,-1,3079,3660,2461,-1,3079,3591,3660,-1,2081,584,587,-1,2081,585,584,-1,3660,3069,3057,-1,3591,3069,3660,-1,3662,3072,3058,-1,3662,3725,3072,-1,3594,3725,3662,-1,3594,3726,3725,-1,3062,3726,3594,-1,3062,3067,3726,-1,580,2092,3592,-1,579,2092,580,-1,2464,3592,2092,-1,2464,570,3592,-1,555,3068,2101,-1,555,3065,3068,-1,2093,564,566,-1,2094,564,2093,-1,549,3066,563,-1,3066,549,3054,-1,568,2097,2753,-1,568,2463,2097,-1,2754,3063,557,-1,2754,3084,3063,-1,3063,3065,3064,-1,3084,3065,3063,-1,3084,3068,3065,-1,3082,3068,3084,-1,3082,3067,3068,-1,3077,3067,3082,-1,3077,3726,3067,-1,3073,3726,3077,-1,3073,3725,3726,-1,3072,3725,3073,-1,2088,3662,2465,-1,3594,3662,2088,-1,3595,3083,3593,-1,3076,3083,3595,-1,3660,2103,2461,-1,3661,2103,3660,-1,572,2087,577,-1,2090,2087,572,-1,525,1332,1334,-1,525,536,1332,-1,3044,2989,3042,-1,2989,3044,2987,-1,3041,3052,3039,-1,3052,3041,3050,-1,3049,3036,3047,-1,3049,3034,3036,-1,3045,3030,3043,-1,3045,3033,3030,-1,3027,3040,3028,-1,3040,3027,3038,-1,3035,3025,3022,-1,3037,3025,3035,-1,3032,3021,3018,-1,3031,3021,3032,-1,3016,3029,3026,-1,3016,3015,3029,-1,3024,3010,3012,-1,3023,3010,3024,-1,3020,3009,3006,-1,3019,3009,3020,-1,3004,3017,3014,-1,3004,3003,3017,-1,3013,3001,3011,-1,3013,3000,3001,-1,3007,2996,3008,-1,3007,2999,2996,-1,2995,3002,2993,-1,3002,2995,3005,-1,2998,2986,2988,-1,2997,2986,2998,-1,2994,3053,2992,-1,2994,3051,3053,-1,2991,3046,3048,-1,2990,3046,2991,-1,3600,2458,518,-1,2458,3600,3597,-1,3599,2977,3598,-1,2976,2977,3599,-1,2761,2981,528,-1,2761,2979,2981,-1,518,2110,2109,-1,518,2458,2110,-1,2643,2764,1486,-1,2643,3659,2764,-1,2970,2973,2969,-1,2119,2973,2970,-1,2971,1622,2616,-1,2971,2113,1622,-1,2113,480,2114,-1,2113,482,480,-1,2064,2117,2181,-1,2064,3664,2117,-1,1480,2119,2970,-1,2119,1480,1483,-1,2966,3095,3097,-1,2966,3096,3095,-1,2457,3658,3659,-1,2120,3658,2457,-1,2964,2766,481,-1,2766,2964,2453,-1,2960,483,3658,-1,2454,483,2960,-1,2956,2962,3657,-1,2961,2962,2956,-1,3657,2124,2954,-1,3657,2125,2124,-1,2767,2122,2128,-1,2123,2122,2767,-1,2126,2138,464,-1,2126,469,2138,-1,2959,2452,2957,-1,2959,2132,2452,-1,2146,2949,2147,-1,459,2949,2146,-1,2143,456,455,-1,2143,2142,456,-1,2145,3601,450,-1,2145,3603,3601,-1,2945,2142,2141,-1,2945,2943,2142,-1,2139,2768,2140,-1,2139,430,2768,-1,445,2158,444,-1,445,3712,2158,-1,439,446,1174,-1,447,446,439,-1,354,445,86,-1,445,354,3602,-1,1192,441,443,-1,3609,441,1192,-1,1647,428,2164,-1,429,428,1647,-1,2446,87,86,-1,434,87,2446,-1,426,2449,2156,-1,426,2166,2449,-1,2769,423,2447,-1,2769,424,423,-1,2770,2769,2163,-1,2769,2770,424,-1,3604,3603,2942,-1,3603,3604,3601,-1,2165,2950,2951,-1,2165,415,2950,-1,2953,422,421,-1,2952,422,2953,-1,423,3604,2948,-1,422,3604,423,-1,2944,2166,2165,-1,2944,2449,2166,-1,429,2152,2157,-1,442,2152,429,-1,2152,442,3605,-1,441,2179,442,-1,2179,441,2180,-1,2173,3609,1192,-1,3609,2173,396,-1,3606,412,411,-1,412,3606,3656,-1,3655,405,3582,-1,406,405,3655,-1,2444,2940,2170,-1,2444,2934,2940,-1,2169,399,398,-1,399,2169,410,-1,404,3608,2772,-1,3607,3608,404,-1,2935,2175,2442,-1,2935,2933,2175,-1,395,3607,2178,-1,3608,3607,395,-1,2888,2939,2938,-1,2890,2939,2888,-1,3627,3606,2896,-1,3627,3656,3606,-1,2175,2923,2176,-1,2774,2923,2175,-1,2179,2930,2775,-1,2930,2179,2178,-1,605,2441,2072,-1,3610,2441,605,-1,3610,3653,2920,-1,3653,3610,3654,-1,2065,2181,2440,-1,2065,2064,2181,-1,289,2776,2792,-1,289,1279,2776,-1,2183,3623,2184,-1,2908,3623,2183,-1,3646,3620,3645,-1,3646,3619,3620,-1,3617,3646,2439,-1,3646,3617,3619,-1,2186,2886,2187,-1,2913,2886,2186,-1,3615,2439,2188,-1,2439,3615,3617,-1,3616,2188,2912,-1,2188,3616,3615,-1,313,3625,2234,-1,3650,3625,313,-1,2234,2900,2193,-1,3625,2900,2234,-1,3612,2192,2196,-1,2192,3612,2911,-1,256,2438,254,-1,381,2438,256,-1,2916,2196,2778,-1,2196,2916,3612,-1,254,2426,361,-1,2438,2426,254,-1,2427,2880,361,-1,3629,2880,2427,-1,2232,2224,2785,-1,2232,2225,2224,-1,2227,2783,2229,-1,2783,2227,2226,-1,2198,2473,2780,-1,2473,2198,2745,-1,3651,2203,380,-1,3581,2203,3651,-1,2747,2208,2209,-1,2746,2208,2747,-1,2204,2206,2205,-1,2204,2207,2206,-1,376,378,2202,-1,376,2434,378,-1,2216,2436,2207,-1,2216,2432,2436,-1,2214,2781,2215,-1,2781,2214,2780,-1,2882,2215,2902,-1,363,2215,2882,-1,3649,2908,2909,-1,2908,3649,3622,-1,3650,3626,3625,-1,3650,3648,3626,-1,3624,3611,3623,-1,3611,3624,2895,-1,3105,3649,3104,-1,3105,3622,3649,-1,3626,2926,2925,-1,2926,3626,3648,-1,3628,227,2431,-1,365,227,3628,-1,2431,2885,3628,-1,2431,2219,2885,-1,2918,356,355,-1,2918,393,356,-1,377,2430,2226,-1,377,2223,2430,-1,2224,369,3629,-1,374,369,2224,-1,2433,2227,3621,-1,2433,375,2227,-1,2236,2967,2063,-1,2965,2967,2236,-1,2236,2877,2965,-1,2877,2236,3588,-1,606,2241,591,-1,2241,606,607,-1,348,2240,195,-1,348,350,2240,-1,346,2240,350,-1,346,345,2240,-1,322,2242,2244,-1,334,2242,322,-1,2246,3590,2100,-1,3590,2246,2248,-1,334,2082,2242,-1,334,2466,2082,-1,2787,2423,309,-1,2787,2245,2423,-1,311,2788,312,-1,301,2788,311,-1,2786,307,298,-1,2786,2252,307,-1,2252,343,2189,-1,2252,2786,343,-1,2875,323,2876,-1,2875,324,323,-1,160,217,216,-1,217,160,131,-1,2409,60,22,-1,60,2409,182,-1,3634,2832,3632,-1,3640,2832,3634,-1,54,2868,190,-1,54,55,2868,-1,2259,2577,2260,-1,2577,2259,278,-1,122,109,12,-1,109,122,180,-1,2853,2417,2840,-1,2853,2418,2417,-1,186,291,143,-1,186,2297,291,-1,2262,276,278,-1,276,2262,2257,-1,1402,2266,292,-1,2266,1402,2267,-1,2218,251,253,-1,2190,251,2218,-1,243,2856,241,-1,2856,243,2316,-1,2807,239,159,-1,2855,239,2807,-1,258,157,156,-1,258,2295,157,-1,215,2862,2414,-1,2399,2862,215,-1,3501,238,2414,-1,3501,3500,238,-1,2865,1764,1219,-1,2796,1764,2865,-1,99,2395,100,-1,118,2395,99,-1,221,2419,2860,-1,2294,2419,221,-1,198,2277,2279,-1,2288,2277,198,-1,228,2281,2290,-1,2282,2281,228,-1,2220,2797,2221,-1,224,2797,2220,-1,2866,287,286,-1,2866,2398,287,-1,2803,2419,2300,-1,2419,2803,2845,-1,2280,2290,2281,-1,2280,2278,2290,-1,3633,241,3635,-1,242,241,3633,-1,270,3634,3632,-1,270,93,3634,-1,2307,2804,175,-1,2307,367,2804,-1,154,2311,173,-1,154,153,2311,-1,2793,162,168,-1,162,2793,2271,-1,175,2309,2405,-1,176,2309,175,-1,2311,2403,173,-1,2310,2403,2311,-1,2315,170,2316,-1,2790,170,2315,-1,2272,168,167,-1,2793,168,2272,-1,123,3631,2789,-1,123,2871,3631,-1,3635,2411,3633,-1,199,2411,3635,-1,2798,133,2400,-1,2413,133,2798,-1,2792,128,289,-1,2792,129,128,-1,177,2808,108,-1,177,2298,2808,-1,3644,268,267,-1,268,3644,3636,-1,2803,2394,2811,-1,2803,2406,2394,-1,2843,119,181,-1,119,2843,2322,-1,2327,3644,2328,-1,103,3644,2327,-1,102,2324,2842,-1,104,2324,102,-1,103,3636,3644,-1,3636,103,2802,-1,2302,90,2308,-1,2302,2393,90,-1,2390,2368,2344,-1,2368,2390,2332,-1,3637,66,65,-1,3637,2836,66,-1,2366,2367,2334,-1,2366,2829,2367,-1,82,2346,2828,-1,2346,82,81,-1,2390,78,2389,-1,2390,2350,78,-1,2333,3637,2819,-1,2333,2837,3637,-1,79,3641,77,-1,79,2823,3641,-1,77,3639,3638,-1,77,3641,3639,-1,2872,2827,3640,-1,2872,2825,2827,-1,2362,2382,2353,-1,2362,51,2382,-1,3643,35,2369,-1,3643,2817,35,-1,2835,56,2834,-1,2835,57,56,-1,2833,3641,2361,-1,3639,3641,2833,-1,3642,2,2870,-1,2,3642,0,-1,2818,2373,2820,-1,2373,2818,2374,-1,2762,3,5,-1,3,2762,3647,-1,4,2375,1,-1,2375,4,2378,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='ethmoid_Coord',point=[(-.0199,57.69641,2.13369),(-.02442,57.62037,2.20924),(-.01983,57.71733,2.15678),(-.01888,57.71954,2.27586),(-.02461,57.66131,2.2896),(-.02015,57.70207,2.34669),(-.0208,57.69128,2.3564),(-.03973,57.5934,2.35544),(-.05901,57.66414,2.35145),(0,57.75625,2.34451),(-.0463,57.65886,2.36689),(0,57.67272,2.39451),(-.04171,57.11411,1.48368),(0,57.14092,1.46941),(0,57.08708,1.48796),(-.03168,57.16834,1.55817),(-.01428,57.14836,1.52292),(-.02587,56.94582,1.52121),(-.06251,57.43324,2.37314),(-.05405,57.42175,2.3205),(-.06287,57.32239,2.36508),(-.04502,57.42101,2.27129),(-.06374,57.40889,2.19412),(-.04132,57.24239,2.2589),(-.05695,57.21581,1.6361),(-.03346,56.91948,1.63225),(-.03745,57.04562,1.71386),(-.02318,57.26692,2.52738),(-.0223,57.27656,2.52958),(-.0197,57.3008,2.49809),(-.02248,57.33775,2.54074),(-.01577,57.32851,2.54134),(-.00001,57.40783,2.57173),(-.00025,57.29659,2.56307),(-.02444,57.21639,2.51583),(-.02455,57.20434,2.51305),(-.01924,56.64882,1.91725),(-.01697,56.65013,1.92852),(-.01771,56.65684,1.92211),(0,56.65876,2.0164),(0,56.66293,2.03317),(-.01593,56.67606,2.0752),(0,56.66929,2.16308),(0,56.66967,2.17252),(0,56.66725,2.18799),(0,56.66637,2.20648),(-.01112,56.66807,2.10412),(-.03718,57.42103,2.51388),(-0,57.42062,2.56911),(-.03839,57.31701,2.47664),(-.02753,57.27431,2.45094),(-.03077,57.21722,2.41457),(-.03765,57.05517,1.72782),(-.0284,57.08876,1.79226),(-.06888,57.299,1.72556),(-.06759,57.30529,1.79916),(-.02902,57.10318,1.86239),(-.03291,57.10956,1.9119),(-.03602,57.19686,2.19538),(-.03933,57.21613,2.23033),(-.07539,57.39728,2.15953),(-.05532,57.2048,1.62182),(0,56.63954,1.9497),(-.02284,56.71743,2.04068),(-.01664,56.69307,2.05577),(-.02416,56.6929,2.10307),(-.03024,56.72931,2.10201),(-.01656,56.67954,2.10024),(-.01066,56.6601,1.98485),(0,56.66736,2.13084),(-.01338,56.68185,2.04114),(-.01039,56.66324,1.99592),(0,57.01745,1.48688),(0,56.91409,1.52561),(-.0202,56.72813,1.63992),(-.02596,56.85004,1.54332),(0,56.80812,1.60823),(-.03137,56.75181,2.28921),(-.02698,56.76727,2.35292),(-.02722,56.77561,2.34477),(-.02052,56.6685,1.98965),(-.02587,56.84056,2.4022),(-.01879,56.94858,2.4161),(-.02952,56.8526,2.40628),(-.0125,56.67092,2.09087),(-.26838,56.74474,1.52579),(-.28641,56.74586,1.55268),(-.28975,56.74744,1.55214),(-.25629,56.76331,1.55762),(-.20414,56.8469,1.55788),(-.20205,56.8577,1.58612),(-.24449,56.77708,1.52824),(-.26641,56.74847,1.5211),(-.1064,57.20578,2.01006),(-.0958,57.13634,2.03494),(-.0852,57.08418,1.98715),(-.21761,56.84235,1.52073),(-.27062,56.86664,1.45735),(-.16775,56.88808,1.54675),(-.11527,57.08257,1.65516),(-.10595,56.98103,1.67921),(-.10868,57.06747,1.63482),(-.10908,57.02388,1.7131),(-.10054,57.0376,1.75511),(-.11079,57.03589,1.70885),(-.12471,57.00281,1.6721),(-.11789,56.94642,1.65835),(-.14214,56.98169,1.62402),(-.12803,56.93133,1.6362),(-.09028,57.0061,1.54846),(-.10014,57.00352,1.50985),(-.16919,56.89735,1.56789),(-.15482,56.95006,1.58479),(-.17558,56.89744,1.57831),(-.19086,57.01526,1.43689),(-.04266,57.13423,1.46312),(-.09491,57.02657,1.48846),(-.12873,57.23124,1.66066),(-.1107,57.1086,1.6895),(-.14063,56.92741,1.58877),(-.05009,57.13646,1.52337),(-.05637,57.11642,1.52423),(-.04663,57.10797,1.51679),(-.11271,57.17927,2.19382),(-.11329,57.17825,2.13399),(-.11307,57.18592,2.13065),(-.08531,57.08184,1.99057),(-.09811,56.74814,1.7635),(-.10947,56.74169,1.72942),(-.11544,56.79982,1.70587),(-.13178,57.23657,2.1023),(-.12915,57.08171,2.0985),(-.14576,57.25026,2.04951),(-.1224,56.92861,1.73044),(-.1301,56.92052,1.71572),(-.12889,56.91918,1.74442),(-.17283,56.91511,1.61653),(-.16769,56.98955,1.58994),(-.18416,56.97953,1.58215),(-.135,56.92911,1.68259),(-.12967,57.02033,1.66274),(-.12916,57.01765,1.6532),(-.11621,57.18372,2.2725),(-.10332,57.20197,2.35114),(-.10699,57.13316,2.28999),(-.11312,57.0959,2.15271),(-.13106,57.08228,1.62785),(-.15779,57.00179,1.67255),(-.15708,56.9984,1.66568),(-.16566,57.04067,1.56509),(-.17996,56.96514,1.60162),(-.19139,56.95857,1.59779),(-.16747,56.97426,1.6114),(-.15124,57.05165,1.58102),(-.13506,57.0662,1.6006),(-.13639,57.10703,1.6565),(-.1421,57.01172,1.70879),(-.14736,57.00531,1.6877),(-.14627,57.06919,1.98014),(-.13949,57.26008,1.992),(-.14177,57.07502,2.04621),(-.19684,56.8824,1.59029),(-.21732,56.85749,1.59246),(-.21351,56.85027,1.58513),(-.20563,56.85979,1.58367),(-.25815,56.76112,1.5623),(-.19333,57.02605,1.56217),(-.19543,57.02715,1.56344),(-.20585,57.0107,1.55767),(-.13326,57.10853,1.65839),(-.13822,57.1449,1.69046),(-.15743,56.88319,1.71022),(-.15995,56.88388,1.7063),(-.13404,57.06564,1.6001),(-.13041,57.08163,1.62583),(-.15865,56.90471,1.63573),(-.17337,56.89621,1.61695),(-.12925,56.92592,1.63794),(-.11905,56.94078,1.65964),(-.13531,56.91523,1.65488),(-.08907,57.01656,1.57177),(-.11694,56.94724,1.63209),(-.10299,57.39706,2.15943),(-.11342,57.27232,2.20216),(-.11501,57.26594,2.16398),(-.07404,57.42216,2.27657),(-.10395,57.31061,2.31235),(-.11539,57.28506,2.23521),(-.18299,56.90016,1.61917),(-.10414,57.14022,1.74965),(-.10601,57.29484,1.72513),(-.17597,56.88571,1.69495),(-.1699,56.89629,1.68633),(-.15796,56.99791,1.66033),(-.22646,56.83316,1.60496),(-.25771,56.83272,1.61078),(-.27264,56.82094,1.62017),(-.11316,56.96558,1.78749),(-.11178,56.99791,1.86748),(-.09871,57.03173,1.85584),(-.11361,57.12653,2.03609),(-.10852,57.10021,1.973),(-.11121,57.07974,1.98544),(-.10904,56.97231,1.77848),(-.12027,56.94332,1.75074),(-.11991,57.16606,2.13765),(-.12404,56.9224,1.76536),(-.12372,56.92196,1.76325),(-.10979,56.93561,1.79815),(-.12384,57.14591,2.08707),(-.12229,57.14627,2.08717),(-.11662,57.16492,2.13866),(-.10306,57.12686,2.42915),(-.08846,57.0792,2.39042),(-.10569,57.1543,2.36951),(-.08326,56.89305,2.10752),(-.12054,56.98787,2.07245),(-.10866,57.00353,2.12385),(-.12255,56.95733,2.00992),(-.098,56.87926,2.04022),(-.10082,56.87383,1.97236),(-.12477,56.91764,1.74391),(-.17819,56.86055,1.68834),(-.17734,56.874,1.69399),(-.15139,56.86468,1.6983),(-.23106,56.89386,1.7032),(-.22862,56.88791,1.7235),(-.2555,56.85677,1.72866),(-.09223,57.06508,1.99676),(-.10108,56.98988,1.93508),(-.09096,57.00585,1.932),(-.11118,57.1526,2.0844),(-.11071,57.16099,2.08001),(-.09413,56.94306,2.35464),(-.09563,57.00475,2.41341),(-.10744,56.87665,2.37312),(-.08023,56.97689,2.30264),(-.07982,57.00939,2.33078),(-.09163,56.81144,2.06256),(-.12724,57.26089,1.99319),(-.1322,57.2493,2.04925),(-.12041,57.23824,1.80207),(-.12299,57.2498,1.85843),(-.12778,57.2365,1.80117),(-.30072,56.81021,1.65838),(-.23081,56.81325,1.62471),(-.10199,56.81167,1.7592),(-.1194,56.82511,1.68801),(-.11927,56.83906,1.71632),(-.18441,56.90577,1.71345),(-.20865,56.90794,1.71642),(-.19373,56.91833,1.68412),(-.19095,56.92035,1.68009),(-.18886,56.9118,1.68366),(-.2551,56.90584,1.65906),(-.24265,56.90881,1.67276),(-.2547,56.89214,1.65569),(-.13697,56.8582,1.73902),(-.1402,56.86852,1.76587),(-.02207,57.57765,2.12945),(0,57.60484,2.11457),(0,57.5037,2.06132),(-.04645,57.41229,2.18542),(-.02522,57.39305,2.08111),(-.15507,57.42746,2.15616),(-.15239,57.34872,2.0176),(-.1531,57.38956,2.09021),(-.09743,56.96145,1.76088),(-.0895,56.97684,1.78795),(-.09943,56.94936,1.79849),(-.11393,57.23756,2.05743),(-.10943,57.16538,2.07812),(-.12746,57.36666,2.06772),(-.11028,57.38785,2.12215),(-.07209,57.61761,2.36325),(-.04663,57.59828,2.39251),(-.03212,57.51677,2.44855),(-.05693,57.54219,2.41667),(-.07098,57.52746,2.43493),(-.12418,57.19827,1.63284),(-.11664,57.16313,1.6011),(-.08828,56.71211,1.89741),(-.08812,56.77537,1.86363),(-.08958,56.73039,1.96744),(-.1385,56.93318,1.94738),(-.14731,57.04794,1.91562),(-.09022,57.04156,2.23788),(-.09027,57.02055,2.18383),(-.10641,56.71457,1.74039),(-.13143,56.71823,1.65713),(-.09511,57.0826,2.30746),(-.10402,57.21925,2.39809),(-.06172,57.4238,2.26322),(-.17704,57.44678,2.19606),(-.18749,57.00776,1.44161),(-.15328,57.42887,2.16396),(-.1561,57.43184,2.17056),(-.09371,57.56284,2.39854),(-.26858,56.86079,1.59349),(-.26937,56.8609,1.59363),(-.27078,56.85766,1.59249),(-.27806,56.85652,1.60165),(-.27776,56.8571,1.60079),(-.27691,56.85955,1.60158),(-.27337,56.86438,1.60232),(-.27491,56.86262,1.60269),(-.27517,56.86257,1.60192),(-.2693,56.86378,1.59693),(-.2712,56.86527,1.60049),(-.26987,56.86388,1.59704),(-.27082,56.83958,1.5871),(-.28332,56.85507,1.6076),(-.28719,56.85674,1.61402),(-.28774,56.88597,1.62425),(-.27856,56.86184,1.60684),(-.2742,56.86407,1.60338),(-.26961,56.85768,1.59216),(-.26802,56.85616,1.58932),(-.26443,56.86178,1.5897),(-.27395,56.86442,1.60202),(-.27686,56.86743,1.6012),(-.27423,56.86763,1.60127),(-.27014,56.86479,1.59408),(-.2737,56.85476,1.59384),(-.27286,56.85523,1.59314),(-.27662,56.86337,1.59184),(-.27691,56.85603,1.59902),(-.27563,56.8555,1.59696),(-.28167,56.86408,1.59463),(-.2734,56.88605,1.60343),(-.26981,56.88596,1.60293),(-.26695,56.88534,1.60116),(-.2556,56.91071,1.60348),(-.24967,56.90818,1.60082),(-.26672,56.88329,1.59558),(-.26579,56.88436,1.59845),(-.24728,56.90605,1.59636),(-.28014,56.86682,1.6004),(-.28256,56.86595,1.59902),(-.27886,56.88481,1.60094),(-.27668,56.88562,1.60269),(-.26624,56.91349,1.59952),(-.26149,56.91238,1.60328),(-.25413,56.8632,1.58777),(-.2619,56.85918,1.58517),(-.24288,56.84006,1.58103),(-.23588,56.85,1.58136),(-.228,56.83962,1.56949),(-.23572,56.85838,1.59612),(-.2388,56.86165,1.59012),(-.23588,56.8535,1.584),(-.26078,56.83157,1.58497),(-.26545,56.83357,1.58536),(-.24566,56.79702,1.60154),(-.25511,56.74052,1.54057),(-.20439,56.77121,1.57081),(-.21414,56.72894,1.5548),(-.26214,56.95043,1.67002),(-.24785,56.95776,1.66584),(-.26088,56.95522,1.67622),(-.2623,56.92905,1.66797),(-.26374,56.92502,1.66208),(-.26267,56.94829,1.6727),(-.26315,56.94747,1.66973),(-.26138,56.95011,1.67337),(-.27608,56.82921,1.68398),(-.27619,56.86082,1.65427),(-.14201,56.92593,1.65642),(-.13525,56.91754,1.68544),(-.2675,56.93587,1.66678),(-.27606,56.94046,1.67373),(-.26729,56.93512,1.66831),(-.26573,56.94192,1.66488),(-.2704,56.94342,1.66763),(-.26632,56.93946,1.66472),(-.26421,56.93926,1.67508),(-.27283,56.94513,1.67927),(-.26408,56.94244,1.67621),(-.27578,56.94605,1.67944),(-.27657,56.94439,1.67741),(-.28412,56.95723,1.6797),(-.266,56.88873,1.64698),(-.25649,56.86833,1.66386),(-.15551,56.89619,1.66288),(-.23568,56.88362,1.60027),(-.23701,56.8991,1.60672),(-.19073,56.93829,1.67479),(-.19164,56.93088,1.65554),(-.29379,56.90378,1.6306),(-.25182,56.91497,1.61784),(-.2683,56.92691,1.635),(-.29378,56.91063,1.63962),(-.27715,56.92711,1.64849),(-.20273,56.72348,1.55912),(-.21157,56.64184,1.49014),(-.39409,56.83804,1.65355),(-.3961,56.83921,1.65585),(-.39626,56.83916,1.65565),(-.39966,56.83792,1.65337),(-.39954,56.83921,1.65435),(-.39902,56.8373,1.65754),(-.39676,56.83807,1.64783),(-.3956,56.84141,1.64637),(-.39665,56.84198,1.64526),(-.39522,56.83899,1.64922),(-.39555,56.84289,1.64955),(-.39518,56.84177,1.648),(-.39775,56.84144,1.65252),(-.39784,56.8456,1.6503),(-.39656,56.84435,1.65044),(-.40085,56.84207,1.65316),(-.39931,56.84586,1.64754),(-.39889,56.84618,1.6492),(-.31173,56.77728,1.57837),(-.31204,56.77721,1.57821),(-.31174,56.77655,1.57784),(-.31293,56.77862,1.5796),(-.31321,56.77841,1.57938),(-.31237,56.77785,1.57859),(-.31498,56.77438,1.57948),(-.31506,56.77479,1.57934),(-.31705,56.77535,1.58079),(-.31813,56.77663,1.58191),(-.31826,56.77679,1.58239),(-.31808,56.77645,1.58214),(-.30937,56.77589,1.57692),(-.31066,56.77457,1.57723),(-.31729,56.78112,1.58315),(-.31571,56.78265,1.58264),(-.34582,56.8041,1.60614),(-.31288,56.77738,1.57724),(-.31111,56.77702,1.57787),(-.31132,56.7766,1.57793),(-.35169,56.80898,1.54602),(-.31668,56.77235,1.57569),(-.3237,56.77856,1.58194),(-.26726,56.79662,1.49492),(-.34927,56.79815,1.60465),(-.23891,56.96874,1.43864),(-.24836,56.97421,1.43565),(-.2898,56.76427,1.48794),(-.39395,56.83812,1.65375),(-.38404,56.8315,1.64379),(-.40197,56.81842,1.67569),(-.29284,56.7353,1.56239),(-.27988,56.6798,1.49167),(-.32475,56.88175,1.4702),(-.27844,56.8751,1.45171),(-.33348,56.88523,1.47823),(-.41264,56.85368,1.60433),(-.31966,56.77827,1.58063),(-.31977,56.77686,1.58021),(-.31564,56.7841,1.56281),(-.3186,56.7755,1.57901),(-.31488,56.78171,1.56176),(-.30761,56.7825,1.56126),(-.3131,56.77613,1.57577),(-.30695,56.78363,1.56162),(-.30694,56.78642,1.56271),(-.30777,56.78743,1.5632),(-.30457,56.79254,1.54754),(-.30676,56.78515,1.56219),(-.3018,56.78989,1.54609),(-.31463,56.78657,1.5637),(-.31588,56.79023,1.54841),(-.29977,56.80559,1.5318),(-.30043,56.8046,1.52968),(-.29911,56.79168,1.53492),(-.31228,56.79939,1.54072),(-.31817,56.79836,1.53932),(-.31194,56.80146,1.5398),(-.29992,56.80794,1.53384),(-.30016,56.80883,1.53202),(-.32238,56.80262,1.53284),(-.32922,56.80719,1.53636),(-.32257,56.80045,1.53704),(-.31852,56.8,1.53961),(-.31691,56.80293,1.54459),(-.32902,56.80277,1.54091),(-.33879,56.81513,1.55322),(-.33388,56.80896,1.5561),(-.30824,56.80636,1.54174),(-.32427,56.80704,1.55645),(-.30238,56.81766,1.53327),(-.30003,56.8133,1.53414),(-.28686,56.85627,1.53883),(-.32265,56.81267,1.53276),(-.3346,56.84347,1.54087),(-.20999,56.79067,1.61846),(-.15115,56.79698,1.66336),(-.20256,56.83364,1.67987),(-.1552,56.81455,1.73121),(-.19048,56.85251,1.76962),(-.30072,56.94593,1.68784),(-.30921,56.94284,1.69865),(-.2838,56.9636,1.72368),(-.25818,56.87026,1.56196),(-.25512,56.86209,1.53868),(-.2705,56.88665,1.54017),(-.25944,56.85683,1.52153),(-.25435,56.8529,1.5146),(-.25906,56.87769,1.51027),(-.35422,56.82533,1.57514),(-.34303,56.82614,1.54961),(-.36853,56.85733,1.60966),(-.36345,56.87471,1.6049),(-.36122,56.91778,1.63374),(-.34088,56.87791,1.5742),(-.31733,56.89433,1.56888),(-.32563,56.91693,1.5837),(-.35557,56.84016,1.57309),(-.35081,56.9281,1.61556),(-.23351,56.66749,1.57688),(-.18271,56.59812,1.5994),(-.16176,57.19217,1.99309),(-.15721,57.19567,2.02833),(-.2096,57.38171,1.98927),(-.21104,57.1818,2.14582),(-.2201,57.17882,2.13566),(-.21116,57.18255,2.14525),(-.20845,57.19722,2.16463),(-.19926,57.18404,2.14669),(-.18514,57.20034,2.14852),(-.18793,57.18356,2.14088),(-.1797,57.1812,2.12967),(-.16236,57.20256,2.11844),(-.17688,57.17767,2.11579),(-.18074,57.17369,2.10193),(-.19016,57.17063,2.09207),(-.22251,57.17176,2.1032),(-.23966,57.17602,2.07343),(-.24566,57.17337,2.13636),(-.19942,57.18293,2.14729),(-.2457,57.16032,2.23289),(-.26,57.17186,2.10306),(-.26177,57.17158,2.16121),(-.17433,57.20164,2.13364),(-.18988,57.22347,2.17269),(-.18125,57.23344,2.17265),(-.17015,57.2499,2.17777),(-.16167,57.26908,2.18174),(-.14358,57.20488,2.09759),(-.26549,57.17323,2.28808),(-.24612,57.19281,2.28672),(-.2266,57.18572,2.14892),(-.27206,57.10501,1.59627),(-.27148,57.10645,1.58068),(-.2652,57.12076,1.5996),(-.25959,57.10704,1.60332),(-.25855,57.09511,1.60053),(-.27288,57.0939,1.59508),(-.26685,57.07551,1.54672),(-.28001,57.08825,1.57895),(-.27348,57.06837,1.54771),(-.24994,57.12803,1.60286),(-.24304,57.12898,1.60748),(-.25596,57.1248,1.60816),(-.25982,57.12452,1.59592),(-.29731,56.98507,1.59741),(-.29005,56.9841,1.59994),(-.26753,56.93634,1.59857),(-.27964,57.06798,1.57972),(-.28643,57.06435,1.56953),(-.2643,57.0687,1.58824),(-.24909,56.93542,1.60678),(-.26299,56.93431,1.60099),(-.24934,56.97793,1.62211),(-.25399,56.99547,1.62046),(-.28064,57.00191,1.61367),(-.24456,57.0495,1.61259),(-.21804,57.0496,1.62054),(-.21376,57.0981,1.61838),(-.19967,57.09615,1.61389),(-.202,57.06674,1.60273),(-.22891,56.93136,1.59926),(-.23414,56.935,1.60492),(-.22059,56.96786,1.6152),(-.18588,57.07611,1.58801),(-.22799,56.96872,1.55917),(-.20587,56.97271,1.59396),(-.1972,57.02713,1.57916),(-.1921,57.05022,1.57226),(-.20266,57.05391,1.5408),(-.24999,56.95837,1.55352),(-.26363,56.9618,1.55011),(-.25547,56.93399,1.57571),(-.26607,56.93711,1.58784),(-.2785,56.96791,1.55851),(-.29109,56.97648,1.57677),(-.26857,56.93794,1.59594),(-.26756,56.82889,1.57794),(-.27051,56.83279,1.57977),(-.26631,56.83302,1.58241),(-.23596,56.98591,1.52914),(-.23465,56.98525,1.52172),(-.22967,56.99281,1.52516),(-.22695,56.9843,1.51913),(-.21866,56.99188,1.52553),(-.20451,56.98395,1.53012),(-.20524,56.99418,1.54058),(-.20811,56.99254,1.53211),(-.23024,56.9857,1.53842),(-.22362,56.99335,1.53081),(-.21596,56.99402,1.5371),(-.27333,56.82956,1.57727),(-.27392,56.83154,1.57032),(-.27126,56.8428,1.57939),(-.26999,56.84811,1.58491),(-.26576,56.85409,1.57571),(-.24958,56.87378,1.57901),(-.25998,56.88836,1.56177),(-.20639,56.98504,1.5489),(-.19915,56.98486,1.54651),(-.19662,56.96691,1.54938),(-.20645,56.96645,1.55451),(-.29141,56.96507,1.67271),(-.29117,56.98677,1.68638),(-.28712,56.96943,1.67998),(-.23922,56.96771,1.65531),(-.23288,56.97196,1.66011),(-.22476,56.98266,1.65389),(-.19342,57.02441,1.65753),(-.2292,57.01264,1.63504),(-.23686,56.97523,1.64547),(-.27797,56.96507,1.6607),(-.30034,56.96958,1.67019),(-.27897,56.96172,1.67099),(-.27055,56.95726,1.66415),(-.2631,56.96449,1.6473),(-.23192,56.97872,1.66732),(-.25814,56.95952,1.67081),(-.26943,56.96524,1.67792),(-.25525,56.96546,1.64946),(-.27774,56.96805,1.6815),(-.27535,56.9749,1.68741),(-.31039,56.99955,1.6914),(-.30347,57.0027,1.70131),(-.24597,57.00084,1.7027),(-.2838,56.99138,1.69381),(-.28218,57.00585,1.70614),(-.35074,57.07805,1.68317),(-.3219,57.10161,1.67624),(-.33535,57.08729,1.69583),(-.28115,57.18441,1.64295),(-.26102,57.18201,1.64161),(-.26001,57.18574,1.64575),(-.3008,57.10189,1.68701),(-.27397,57.18993,1.65149),(-.25706,57.18772,1.64874),(-.25455,57.13668,1.69172),(-.28378,57.13601,1.68019),(-.2722,57.18411,1.66311),(-.29311,57.04955,1.74984),(-.28824,57.05882,1.72661),(-.27286,57.03138,1.74111),(-.27777,57.07901,1.70934),(-.23426,57.09335,1.69959),(-.23532,57.07302,1.71077),(-.24244,57.18159,1.66989),(-.20838,57.17609,1.67195),(-.21945,57.13397,1.69915),(-.25294,57.18741,1.64972),(-.2488,57.18498,1.64856),(-.21944,57.18427,1.66131),(-.22531,57.04008,1.71619),(-.2549,57.0151,1.72433),(-.19627,57.0909,1.70313),(-.20354,57.0648,1.7117),(-.18566,57.16894,1.66742),(-.19012,57.13703,1.70042),(-.24571,57.181,1.64545),(-.20586,57.17729,1.65661),(-.2077,57.01672,1.69541),(-.17222,57.12429,1.68032),(-.17838,57.15934,1.65792),(-.1863,57.14853,1.6463),(-.18239,57.09553,1.64666),(-.25038,56.9729,1.63986),(-.18396,57.05437,1.65001),(-.22175,57.07507,1.61492),(-.22219,57.04137,1.62565),(-.28929,57.01459,1.62499),(-.30456,56.98533,1.63818),(-.32969,57.0278,1.63402),(-.33406,57.00442,1.65052),(-.27364,57.04669,1.6141),(-.29835,57.09068,1.60461),(-.30993,57.06335,1.62352),(-.32065,57.00678,1.69885),(-.32524,56.99728,1.67307),(-.35144,57.05781,1.66118),(-.34758,57.0353,1.67645),(-.31484,57.11637,1.62826),(-.33589,57.08789,1.64777),(-.34246,57.00702,1.6879),(-.32119,57.01519,1.70915),(-.32223,56.86971,1.87668),(-.31981,56.87743,1.87792),(-.32107,56.87766,1.88111),(-.32308,56.86823,1.88328),(-.32131,56.87627,1.88399),(-.32053,56.87612,1.88688),(-.31823,56.87655,1.88567),(-.3162,56.87706,1.88213),(-.31818,56.86874,1.88071),(-.29608,56.91476,1.93898),(-.30315,56.89457,1.93585),(-.33134,56.91738,1.99266),(-.296,56.98323,1.84964),(-.30951,56.97727,1.85364),(-.28549,56.98514,1.82135),(-.27099,56.93455,1.77546),(-.27463,56.92157,1.78676),(-.25984,56.93617,1.80134),(-.30616,56.9325,1.78163),(-.29317,56.91781,1.77984),(-.28833,56.93242,1.76873),(-.35315,56.93254,1.8904),(-.34244,56.91293,1.86038),(-.32998,56.93227,1.82359),(-.35492,56.9642,1.97642),(-.37159,56.94385,1.98012),(-.36241,56.95054,1.94984),(-.30449,56.94842,1.94941),(-.29877,56.95156,1.92985),(-.27493,56.93949,1.89369),(-.30281,56.94013,1.77719),(-.29884,56.94707,1.7764),(-.31957,56.95059,1.80962),(-.33832,56.95139,1.86223),(-.34632,56.95488,1.91503),(-.35527,56.9522,1.93336),(-.32485,56.94147,1.81375),(-.34619,56.94272,1.87427),(-.2813,56.92969,1.90896),(-.3115,56.94614,1.96675),(-.28225,56.98288,1.80977),(-.31803,56.8713,1.86921),(-.32245,56.86168,1.87093),(-.32094,56.86138,1.86997),(-.3341,56.86111,1.90271),(-.32397,56.85909,1.89806),(-.34295,56.8574,1.90983),(-.3274,56.8825,1.90634),(-.32484,56.88215,1.88711),(-.37315,56.92505,1.98094),(-.32713,56.88207,1.89781),(-.32061,56.88384,1.90517),(-.32509,56.8832,1.90941),(-.3382,56.89354,1.86406),(-.36339,56.89836,1.93349),(-.26484,57.02158,1.7702),(-.27248,57.04375,1.75361),(-.29803,57.06458,1.781),(-.29418,57.06773,1.73679),(-.33154,57.08053,1.76161),(-.32851,57.07183,1.76363),(-.30317,57.08646,1.84691),(-.28798,57.04661,1.83422),(-.28624,57.04204,1.81277),(-.22257,57.25912,1.73675),(-.21448,57.26038,1.73915),(-.26214,57.28482,1.75936),(-.1592,57.202,1.79717),(-.1511,57.18426,1.7688),(-.15385,57.16854,1.8224),(-.17389,57.09858,1.75366),(-.20095,57.05179,1.72774),(-.19405,57.07052,1.75708),(-.18161,57.14505,1.71599),(-.18094,57.11064,1.72368),(-.16294,57.13067,1.75212),(-.22396,57.07538,1.71973),(-.2278,57.05121,1.72933),(-.23291,57.02687,1.7369),(-.29544,57.09006,1.71609),(-.22162,57.23738,1.71319),(-.25943,57.21677,1.68448),(-.20071,57.19743,1.68877),(-.27728,57.03244,1.78959),(-.35455,56.86273,1.90076),(-.33383,56.86157,1.89532),(-.3125,56.8608,1.85422),(-.32137,56.86248,1.85853),(-.31432,56.86243,1.83537),(-.31763,56.86169,1.85738),(-.31446,56.86074,1.86016),(-.32175,56.86245,1.85979),(-.35587,56.79975,2.04532),(-.35172,56.79852,2.04491),(-.35063,56.78377,2.165),(-.3432,56.80048,2.02445),(-.31221,56.79359,2.02532),(-.34327,56.79901,2.03101),(-.34356,56.79802,2.03759),(-.34353,56.79906,2.03114),(-.34359,56.79763,2.03749),(-.34556,56.79786,2.04081),(-.34539,56.79732,2.04105),(-.34798,56.7979,2.04222),(-.3548,56.80184,2.03207),(-.35458,56.80218,2.03223),(-.35487,56.8011,2.03849),(-.42357,56.92091,1.84254),(-.42386,56.92044,1.84097),(-.42357,56.92061,1.84256),(-.42534,56.92091,1.8456),(-.42417,56.92103,1.84418),(-.4251,56.92065,1.84586),(-.42683,56.92032,1.84575),(-.42625,56.92061,1.84591),(-.42697,56.91997,1.84635),(-.42581,56.92145,1.85126),(-.39852,56.96321,2.08395),(-.42733,56.92092,1.85182),(-.4286,56.91866,1.84323),(-.43386,56.9197,1.84018),(-.42986,56.91634,1.83457),(-.42724,56.92169,1.83982),(-.42642,56.92112,1.83922),(-.42625,56.92268,1.83914),(-.42513,56.92354,1.84504),(-.426,56.92505,1.84375),(-.42486,56.925,1.84403),(-.42405,56.92323,1.8445),(-.42365,56.9246,1.84361),(-.42271,56.92395,1.84262),(-.42597,56.9287,1.83744),(-.42511,56.92782,1.83658),(-.40733,56.98276,1.81626),(-.40577,56.98667,1.82379),(-.42376,56.93041,1.84149),(-.40681,56.98684,1.82302),(-.4041,56.98476,1.82239),(-.42149,56.92876,1.84011),(-.40476,56.98593,1.82357),(-.42386,56.92715,1.83624),(-.42252,56.92687,1.83652),(-.40538,56.98192,1.81701),(-.40265,57.00548,1.81677),(-.40453,57.0055,1.81501),(-.39917,57.02161,1.80846),(-.39192,57.0205,1.80544),(-.39251,57.02103,1.80185),(-.39905,57.00362,1.81083),(-.39448,57.02163,1.80012),(-.39677,57.0223,1.79839),(-.40243,57.0034,1.80654),(-.40586,57.00525,1.81246),(-.40757,56.9864,1.82147),(-.40073,57.00519,1.81712),(-.39926,57.00469,1.816),(-.39861,57.00411,1.8137),(-.40048,57.00337,1.80822),(-.40447,56.98246,1.81861),(-.40434,57.0037,1.8062),(-.40644,56.98202,1.81616),(-.39131,57.04492,1.80161),(-.39169,57.04411,1.80569),(-.40133,57.02275,1.80216),(-.40083,57.02228,1.8054),(-.39145,57.04055,1.80976),(-.38857,57.03428,1.7979),(-.38959,57.03954,1.7973),(-.39059,57.0434,1.79872),(-.40065,57.02292,1.79954),(-.37127,57.03565,1.8105),(-.37152,57.03928,1.80658),(-.36925,57.16848,1.86058),(-.37215,57.14743,1.85415),(-.36675,57.15453,1.83637),(-.31321,57.12302,1.8687),(-.33187,57.12303,1.84743),(-.31412,57.10229,1.8605),(-.37008,57.1263,1.80978),(-.36958,57.10285,1.80209),(-.35718,57.09676,1.80719),(-.26861,57.15636,1.92298),(-.2673,57.16074,1.92796),(-.26843,57.15995,1.92847),(-.25532,57.16659,1.93512),(-.25519,57.1671,1.93456),(-.24715,57.16645,1.93131),(-.26303,57.16494,1.93254),(-.26343,57.1645,1.93314),(-.26692,57.16288,1.92705),(-.26666,57.16005,1.92156),(-.2938,57.16764,1.92161),(-.22151,57.22329,1.8274),(-.22481,57.19677,1.84964),(-.16966,57.22781,1.83337),(-.17222,57.25581,1.81768),(-.20153,57.29264,1.81493),(-.2194,57.28444,1.8006),(-.25639,57.15874,1.89332),(-.23831,57.16205,1.89609),(-.22701,57.16739,1.87166),(-.30317,57.23224,1.86127),(-.26876,57.2562,1.81907),(-.28655,57.26544,1.84336),(-.24328,57.15544,1.92088),(-.23677,57.15391,1.91882),(-.23972,57.1585,1.92433),(-.24241,57.16273,1.92938),(-.24792,57.17142,1.93978),(-.24717,57.16532,1.93345),(-.30868,56.88253,1.99509),(-.3438,56.8147,2.02288),(-.30478,56.88056,1.99439),(-.34118,56.81253,2.02315),(-.26191,56.96934,1.99278),(-.24406,57.01164,2.01091),(-.25291,56.96646,1.97809),(-.24644,56.96265,1.96396),(-.26493,56.93158,1.97625),(-.29334,56.94014,1.96299),(-.30071,56.95942,1.9509),(-.30919,56.96237,1.966),(-.2799,56.9326,1.95485),(-.27369,56.93089,1.9581),(-.2652,56.95808,1.93564),(-.34233,57.15561,2.01116),(-.35097,57.12142,2.00469),(-.36355,57.12034,1.96716),(-.19398,57.09899,1.92844),(-.18299,57.10005,1.96731),(-.17751,57.13655,1.97619),(-.2667,57.2177,1.97425),(-.2582,57.21617,1.97058),(-.25626,57.21797,1.97539),(-.28772,57.20404,1.99687),(-.29863,57.1955,2.00722),(-.32263,57.18317,1.98043),(-.33646,57.00529,1.98892),(-.29641,56.97132,1.99398),(-.30705,56.96852,1.98689),(-.27753,57.2032,2.02022),(-.26522,57.15001,2.05478),(-.30763,57.15397,2.04252),(-.29374,56.95609,1.93688),(-.30191,56.96822,1.90809),(-.25252,56.959,1.94264),(-.23636,56.97849,1.91032),(-.23785,57.20981,2.00597),(-.21985,57.1946,2.00514),(-.23589,57.1991,2.01548),(-.22657,57.02944,1.8679),(-.20589,57.05182,1.89739),(-.23387,57.08886,1.8728),(-.22776,57.10533,1.89398),(-.27412,57.10724,1.87615),(-.25464,57.17007,1.9398),(-.26753,57.19724,1.95801),(-.30248,57.15361,1.92237),(-.32195,57.16255,1.9419),(-.34219,57.15015,1.92786),(-.35931,57.04424,1.91731),(-.34563,57.06484,1.89449),(-.35265,57.10367,1.9045),(-.35192,57.14704,1.97462),(-.27946,57.20164,1.9638),(-.27911,57.20742,1.9727),(-.30161,57.19387,1.97114),(-.34755,56.7973,2.04452),(-.42832,56.82991,1.88543),(-.43127,56.89396,1.84956),(-.44273,56.86973,1.7627),(-.43127,56.99709,1.86017),(-.44698,56.89671,1.75328),(-.15399,57.42207,2.16132),(-.15066,57.36159,2.14282),(-.15502,57.34388,2.18049),(-.13072,57.25404,2.1046),(-.18408,57.37716,2.0677),(-.11028,56.84292,1.94425),(-.25724,56.83941,2.43614),(-.26096,56.84985,2.35295),(-.24349,56.8734,2.42601),(-.28633,56.81525,2.39895),(-.27074,56.84761,2.44918),(-.27417,56.85139,2.45228),(-.2741,56.87246,2.47491),(-.26183,56.89288,2.49601),(-.26569,56.89498,2.49695),(-.26658,56.86797,2.47093),(-.24011,57.02273,2.54516),(-.24421,57.01138,2.54328),(-.23854,57.01061,2.54076),(-.25242,56.98916,2.53553),(-.25542,56.99777,2.53943),(-.26014,57.00245,2.53766),(-.13805,57.19548,2.64665),(-.15601,57.14603,2.63933),(-.15008,57.14159,2.63392),(-.141,57.21571,2.64943),(-.15589,57.22178,2.64119),(-.15711,57.21405,2.64341),(-.30311,57.05817,2.50245),(-.329,56.93822,2.48964),(-.32514,56.93254,2.48986),(-.2584,56.56911,1.42736),(-.25808,56.56808,1.42296),(-.24535,56.56411,1.4347),(-.1563,56.64374,1.67381),(-.15706,56.65119,1.67285),(-.18033,56.59491,1.60112),(-.15241,56.64172,1.91195),(-.1501,56.62887,1.97368),(-.15465,56.64667,1.91138),(-.15135,56.63332,1.97074),(-.22626,57.50691,2.25815),(-.32769,57.36944,1.8464),(-.31088,57.40868,1.93146),(-.29441,57.42092,1.92977),(-.3356,57.36399,1.85153),(-.34312,57.35726,1.8557),(-.32452,57.40021,1.93924),(-.39237,57.13636,1.96628),(-.31882,57.27617,2.08658),(-.33658,57.28182,2.02873),(-.34379,57.28556,2.00807),(-.33796,57.37947,1.9683),(-.35856,57.29305,1.96687),(-.34229,57.36896,1.98426),(-.42525,56.81025,1.8061),(-.42288,56.80808,1.80853),(-.32074,56.69969,1.58063),(-.32031,56.69708,1.58221),(-.32951,56.71995,1.6082),(-.22158,56.79633,1.62021),(-.32895,56.72574,1.62061),(-.32178,56.71761,1.60847),(-.3473,56.78329,1.69439),(-.35954,56.73896,1.66064),(-.35427,56.73606,1.65284),(-.40196,56.83292,1.93164),(-.40934,56.83293,1.94682),(-.41322,56.83373,1.92138),(-.36092,56.79359,2.19521),(-.37024,56.78987,2.15823),(-.33104,56.83075,2.34577),(-.32519,56.83007,2.34392),(-.32244,56.83799,2.36936),(-.25414,56.84612,2.44397),(-.30144,56.89923,2.4786),(-.27817,56.86202,2.46472),(-.27981,56.94394,2.50911),(-.26071,56.96353,2.51987),(-.25893,56.97208,2.51863),(-.22906,57.09753,2.49684),(-.25274,57.01957,2.54243),(-.24401,57.02423,2.54582),(-.1154,57.32371,2.4927),(-.13253,57.3064,2.54836),(-.12725,57.24757,2.54325),(-.13409,57.20707,2.64801),(-.20674,57.18616,2.55996),(-.17194,57.12528,2.62687),(-.1694,57.13517,2.63612),(-.13953,57.13021,2.54171),(-.11562,57.08872,2.46741),(-.12945,57.0556,2.50758),(-.12734,57.04412,2.50196),(-.09614,56.77031,2.34079),(-.11063,56.77284,2.3608),(-.10877,56.75681,2.34564),(-.16276,56.76246,2.35944),(-.12551,56.75255,2.35212),(-.1273,56.76854,2.36733),(-.13392,56.86944,2.43217),(-.13385,56.85056,2.42363),(-.11638,56.86422,2.40696),(-.15611,56.68877,2.27857),(-.12951,56.67945,2.27161),(-.13121,56.69553,2.28841),(-.10115,56.65056,2.10485),(-.1101,56.63137,2.12585),(-.10917,56.63079,2.10127),(-.10321,56.66685,1.82953),(-.12808,56.65289,1.85656),(-.13067,56.65679,1.82638),(-.15593,56.66265,1.75014),(-.14442,56.64651,1.73655),(-.14305,56.65175,1.76547),(-.13499,56.65611,1.82704),(-.13797,56.65161,1.85774),(-.13989,56.65675,1.8274),(-.18599,56.59335,1.5896),(-.25675,56.61928,1.50921),(-.30577,56.64566,1.52442),(-.30433,56.63762,1.51267),(-.42427,56.92195,1.85069),(-.42274,56.92244,1.85011),(-.39324,56.96486,2.0808),(-.30613,57.10629,2.48544),(-.30989,57.10221,2.48863),(-.33625,56.98476,2.45861),(-.19491,56.85374,1.77135),(-.28378,56.85919,1.82928),(-.28284,56.86331,1.78334),(-.37525,56.83235,1.91209),(-.37225,56.85195,1.86632),(-.36266,56.84853,1.90193),(-.34936,56.85146,1.81977),(-.35299,56.86213,1.86119),(-.35921,56.85071,1.83087),(-.32544,56.86297,1.86128),(-.27382,57.52359,2.33247),(-.27365,57.5257,2.32299),(-.30146,57.50363,2.32219),(-.29528,57.49369,2.32661),(-.29931,57.4688,2.32246),(-.32765,57.23931,2.40451),(-.32521,57.2388,2.4172),(-.31206,57.27482,2.38634),(-.30348,57.2772,2.32263),(-.34356,57.16126,2.37937),(-.25601,57.51381,2.35629),(-.29278,57.50526,2.33184),(-.27621,57.51163,2.29861),(-.30229,57.50656,2.31232),(-.29402,57.41134,2.34166),(-.27428,57.33585,2.3867),(-.2333,57.40491,2.35238),(-.27127,57.33644,2.38672),(-.21055,57.23077,2.28641),(-.2505,57.25143,2.41629),(-.24526,57.25973,2.41574),(-.19151,57.20895,2.18581),(-.22778,57.2117,2.28545),(-.2506,57.24033,2.45384),(-.25176,57.25284,2.4419),(-.25291,57.25374,2.42962),(-.20178,57.29149,2.41137),(-.19536,57.29226,2.43269),(-.19905,57.3235,2.37852),(-.21035,57.33408,2.37349),(-.19971,57.33527,2.37264),(-.1383,57.35113,2.55317),(-.15848,57.35339,2.52199),(-.15756,57.30844,2.57815),(-.11377,57.33476,2.46574),(-.10664,57.34628,2.43945),(-.10985,57.40104,2.43816),(-.15651,56.66906,1.99498),(-.16401,56.67458,2.01861),(-.15288,56.69859,2.01202),(-.08531,56.69695,1.82331),(-.08364,56.69029,1.89957),(-.31101,57.1551,2.48355),(-.33703,57.16026,2.4701),(-.31045,57.1504,2.4862),(-.29216,57.29239,2.40806),(-.28063,57.31356,2.39444),(-.2839,57.31424,2.39579),(-.25401,57.25779,2.43457),(-.25149,57.25706,2.4243),(-.30707,57.15617,2.48169),(-.30941,57.15326,2.4849),(-.3952,56.76169,1.70074),(-.42335,56.80599,1.79434),(-.3607,56.76362,1.63597),(-.33854,56.72856,1.6165),(-.36826,56.7409,1.6454),(-.27992,56.83638,1.70526),(-.3837,56.84139,1.86614),(-.35054,56.85508,1.91336),(-.32473,56.86024,1.81532),(-.33243,56.86367,1.86651),(-.20499,57.25678,2.53625),(-.20421,57.25452,2.53281),(-.20706,57.24598,2.54239),(-.20363,57.25536,2.5526),(-.4174,56.99184,1.77841),(-.30595,56.99521,1.45147),(-.192,57.06982,1.43045),(-.18715,57.06657,1.42441),(-.26359,56.58683,1.42444),(-.24137,56.57267,1.42751),(-.25565,56.56896,1.42017),(-.15316,56.63403,2.03149),(-.15514,56.64549,2.10661),(-.18057,56.67481,2.04753),(-.09984,56.64489,2.04297),(-.09079,56.68919,2.03275),(-.10042,56.70063,2.09318),(-.31575,57.10241,2.48962),(-.35453,56.95113,2.2607),(-.34967,56.94776,2.25682),(-.34155,56.93225,2.36055),(-.40192,56.96825,2.08024),(-.43012,56.92477,1.86147),(-.40352,56.84466,1.66344),(-.1336,57.05807,2.48846),(-.13192,57.06597,2.47326),(-.11905,56.96901,2.41312),(-.14863,56.76848,2.33545),(-.15547,56.77797,2.33328),(-.18417,56.74375,2.27107),(-.14464,56.89275,2.39248),(-.13183,56.8853,2.40562),(-.11425,56.95486,2.42741),(-.16743,56.80954,2.39859),(-.17672,56.8123,2.39498),(-.17229,56.76627,2.35402),(-.19588,57.06949,2.55013),(-.14232,57.1194,2.53907),(-.14299,57.12382,2.54372),(-.13628,56.64442,1.73629),(-.13973,56.62662,1.68144),(-.10846,56.65933,1.74787),(-.14701,56.62808,1.68019),(-.21967,56.59416,1.4631),(-.2079,56.62614,1.49355),(-.20366,56.60408,1.49521),(-.10976,56.64214,1.90816),(-.11469,56.62455,1.9622),(-.12013,56.63329,1.92616),(-.08974,56.73186,2.02182),(-.0959,56.78728,2.31977),(-.10538,56.72077,2.26678),(-.10258,56.76206,2.26584),(-.26821,56.58785,1.42533),(-.27673,56.62389,1.44945),(-.13578,57.05596,2.50685),(-.13194,57.05445,2.50858),(-.20599,57.05594,2.5402),(-.17931,57.03503,2.46592),(-.171,56.9765,2.42382),(-.11481,56.92967,2.42676),(-.14047,56.80786,2.37277),(-.17217,56.85698,2.43622),(-.13891,56.85307,2.40315),(-.174,56.83985,2.31845),(-.24481,56.86683,2.31591),(-.21637,56.83394,2.24744),(-.17033,56.75745,2.34498),(-.20089,56.99062,2.41182),(-.1569,56.90146,2.38463),(-.16475,56.78497,2.32527),(-.17958,56.79854,2.29992),(-.19423,56.74814,2.25855),(-.17873,56.66712,2.172),(-.15979,56.65742,2.17262),(-.16394,56.66987,2.24176),(-.24051,56.73587,2.1507),(-.21708,56.77165,2.10868),(-.21994,56.70029,2.10284),(-.21099,56.8718,2.17399),(-.22252,56.70106,2.14553),(-.22616,56.70956,2.1721),(-.20019,56.73038,2.07535),(-.20886,56.69052,2.0768),(-.19795,56.70889,2.06218),(-.11783,56.81937,2.09918),(-.14409,56.71708,1.96401),(-.16059,56.87741,2.06493),(-.16596,56.87759,2.06128),(-.16279,56.89194,1.97416),(-.19885,56.82967,1.99309),(-.34763,56.82346,1.94427),(-.35082,56.80217,2.02504),(-.35462,56.80302,2.02534),(-.29179,56.83098,2.31727),(-.30932,56.85376,2.38252),(-.37247,56.8019,2.20112),(-.36891,56.79663,2.19803),(-.23972,56.5714,1.42887),(-.27521,56.58032,1.43583),(-.2628,56.57136,1.42722),(-.26418,56.57562,1.43319),(-.22671,56.56613,1.46342),(-.23081,56.56692,1.46345),(-.14615,56.62097,1.67029),(-.14944,56.62405,1.67044),(-.37553,56.82456,1.81733),(-.38021,56.83219,1.84108),(-.40205,56.80682,1.81971),(-.16361,56.63435,1.60134),(-.16797,56.70408,1.59807),(-.36865,57.29962,1.92615),(-.33327,57.39084,1.95263),(-.32603,57.31249,1.77191),(-.30109,57.38273,1.84598),(-.29722,57.3679,2.36032),(-.29728,57.36709,2.36149),(-.30153,57.19461,2.46023),(-.30688,57.1926,2.46789),(-.30415,57.30827,2.37276),(-.30815,57.23237,2.44644),(-.30256,57.26971,2.42558),(-.22476,57.24075,2.1529),(-.24994,57.25678,2.28974),(-.24332,57.21157,2.12779),(-.24447,57.21959,2.47707),(-.24853,57.2336,2.46922),(-.23343,57.23178,2.45633),(-.24046,57.25682,2.43151),(-.23764,57.24204,2.44443),(-.24055,57.25751,2.43452),(-.27007,57.1933,2.30386),(-.30005,57.15202,2.47803),(-.27981,57.17103,2.31832),(-.26786,57.22032,2.43783),(-.24399,57.26998,2.42253),(-.25987,57.2726,2.43819),(-.21502,57.32402,2.27733),(-.20861,57.19861,2.4587),(-.22889,57.21932,2.46777),(-.22399,57.20199,2.4517),(-.24258,57.20635,2.49668),(-.24812,57.22621,2.48418),(-.24043,57.26647,2.40982),(-.24277,57.26464,2.42038),(-.24021,57.21328,2.47802),(-.21684,57.17889,2.4696),(-.27259,56.98474,2.46714),(-.26448,57.05255,2.4667),(-.30002,57.05425,2.50136),(-.21479,57.32114,2.18034),(-.19583,57.31777,2.17651),(-.20669,57.2876,2.18101),(-.20958,57.28236,2.17882),(-.22696,57.2499,2.25951),(-.16231,57.33479,2.18671),(-.15344,57.33016,2.17795),(-.18792,57.35412,2.25698),(-.18313,57.35146,2.26438),(-.15434,57.3207,2.1784),(-.15416,57.29834,2.18212),(-.18921,57.33407,2.28762),(-.18409,57.34081,2.28121),(-.17875,57.23531,2.17447),(-.19742,57.32823,2.28911),(-.17309,57.24661,2.17612),(-.20607,57.32371,2.28695),(-.14528,57.30988,2.15003),(-.20392,57.35508,2.25298),(-.20905,57.36394,2.25292),(-.21414,57.35591,2.25048),(-.24562,57.38916,2.23096),(-.24721,57.38529,2.2356),(-.22136,57.34674,2.25619),(-.21046,57.42856,2.24778),(-.22105,57.4175,2.23508),(-.20478,57.37187,2.25935),(-.22159,57.36759,2.30477),(-.22626,57.35749,2.30071),(-.25333,57.38916,2.30214),(-.27675,57.45409,2.19957),(-.28065,57.44682,2.16158),(-.29742,57.42259,2.13704),(-.25643,57.4824,2.22521),(-.23723,57.4664,2.19064),(-.26486,57.46654,2.18401),(-.17853,57.33399,2.18399),(-.18779,57.37431,2.18937),(-.16065,57.35002,2.19239),(-.3443,57.35432,2.03722),(-.3344,57.3646,2.06491),(-.30727,57.30762,2.06322),(-.24974,57.27244,2.13157),(-.27697,57.26857,2.10677),(-.25724,57.31988,2.1332),(-.29952,57.47181,2.31067),(-.29833,57.47171,2.30784),(-.29194,57.44605,2.29469),(-.24175,57.49466,2.24167),(-.24331,57.49235,2.24317),(-.23693,57.49745,2.26055),(-.28285,57.43803,2.19036),(-.28617,57.42974,2.20339),(-.2838,57.4407,2.19986),(-.25128,57.37649,2.24586),(-.25043,57.51094,2.28017),(-.25166,57.50844,2.27979),(-.27648,57.50988,2.29671),(-.29361,57.415,2.25167),(-.28759,57.42249,2.24958),(-.28835,57.42205,2.21786),(-.31504,57.17052,2.04037),(-.29085,57.28798,2.08401),(-.13463,57.04484,2.50075),(-.12139,56.94507,2.44445),(-.16202,56.85587,2.4384),(-.24865,57.05112,2.44917),(-.30821,56.9986,1.462),(-.36689,56.99661,1.57611),(-.33515,57.15147,1.5515),(-.38119,57.1724,1.76096),(-.33025,57.28979,1.73576),(-.2253,57.10908,1.50452),(-.22712,57.05255,1.46554),(-.16715,57.31131,1.87941),(-.14951,57.30128,1.72695),(-.21473,57.29719,1.73464),(-.30672,57.27152,2.15316),(-.3253,57.36111,2.10317),(-.29839,57.39934,2.2509),(-.29807,57.41759,2.28888),(-.31794,57.39666,2.11182),(-.28982,57.42198,2.1812),(-.06716,57.48771,2.33726),(-.21099,57.56385,2.3216),(-.10683,57.62331,2.34073),(-.20032,57.41635,2.37084),(-.19969,57.51929,2.38472),(-.18402,57.32765,2.49691),(-.18502,57.26455,2.52343),(-.18355,57.36678,2.4191),(-.19227,57.34213,2.37455),(-.14907,57.29831,2.59017),(-.13611,57.34839,2.55203),(-.34943,57.16108,2.14996),(-.36666,57.02223,2.34277),(-.39926,57.02994,2.12815),(-.34116,56.98798,2.45891),(-.35795,57.00636,2.42735),(-.34701,56.93535,2.35987),(-.3323,57.20211,2.44618),(-.3107,57.1917,2.46945),(-.23695,57.03491,2.4606),(-.25064,57.01602,2.48249),(-.08007,56.68308,1.97282),(-.18379,56.66958,2.10498),(-.26005,56.57167,1.42071),(-.27906,56.583,1.43184),(-.33822,56.97445,2.47193),(-.34034,56.91964,2.37302),(-.33658,56.9665,2.48269),(-.27528,56.96072,2.4926),(-.27112,56.96508,2.48664),(-.30227,56.91005,2.48536),(-.32101,56.76231,2.15891),(-.25197,56.83069,2.1683),(-.42437,56.85037,1.93418),(-.41941,56.83664,1.92294),(-.35106,56.88302,2.37019),(-.38434,56.8646,2.20472),(-.3321,56.83302,2.34202),(-.34394,56.84197,1.91892),(-.33982,56.82319,1.94716),(-.3124,56.82941,1.93147),(-.28436,56.85291,1.87786),(-.29188,56.85734,1.83614),(-.25842,56.80332,1.96416),(-.21787,56.84711,1.92491),(-.13463,56.88503,1.96579),(-.18816,56.85254,1.77742),(-.35465,56.96402,1.66167),(-.36096,56.96861,1.66709),(-.37204,56.91917,1.65528),(-.36438,56.97297,1.67379),(-.36369,56.97714,1.68287),(-.39075,56.92778,1.67097),(-.34019,56.97668,1.69392),(-.35051,56.92832,1.6784),(-.36552,56.92983,1.68209),(-.33719,56.97334,1.68805),(-.34032,56.92571,1.67008),(-.34247,56.9269,1.67328),(-.32421,56.98447,1.66799),(-.3305,56.97655,1.66653),(-.33233,56.97783,1.66847),(-.34807,56.96218,1.66146),(-.35433,56.96242,1.65835),(-.35749,56.96781,1.65252),(-.35464,56.97546,1.64707),(-.35688,56.9791,1.65355),(-.31512,56.97163,1.65583),(-.32506,56.96867,1.65986),(-.32619,56.97087,1.66039),(-.35508,56.96042,1.65793),(-.36569,56.94299,1.65695),(-.36435,56.9434,1.64818),(-.3571,56.96363,1.64927),(-.35941,56.94863,1.66107),(-.30441,56.92977,1.64743),(-.3191,56.95822,1.65893),(-.30206,56.9627,1.65029),(-.28208,56.93366,1.63008),(-.29446,56.96571,1.63164),(-.273,56.93753,1.60417),(-.27267,56.94249,1.61694),(-.28921,56.94142,1.59449),(-.30498,56.96077,1.62062),(-.28052,56.90207,1.56207),(-.28038,56.92117,1.57776),(-.30243,56.9229,1.57614),(-.35344,56.97096,1.64229),(-.34179,56.92286,1.66396),(-.34172,56.91851,1.66488),(-.33937,56.92406,1.67062),(-.34188,56.92674,1.67437),(-.39156,56.92763,1.6801),(-.39333,56.92677,1.68376),(-.39365,56.9225,1.67379),(-.33838,56.92296,1.67183),(-.3812,56.92946,1.68289),(-.3817,56.93014,1.68493),(-.34159,57.04736,1.81615),(-.33243,57.03487,1.82721),(-.33849,57.03778,1.825),(-.36576,56.96642,1.81558),(-.37748,56.9985,1.83452),(-.35744,56.98762,1.84321),(-.34543,57.01503,1.84238),(-.35822,57.02007,1.83361),(-.32412,57.01243,1.83928),(-.32538,57.03455,1.82714),(-.31912,57.03672,1.82466),(-.27553,56.9695,1.70781),(-.27441,56.98573,1.75745),(-.27127,56.99986,1.73775),(-.32285,56.94241,1.68039),(-.34128,56.92754,1.67648),(-.33887,56.9238,1.67673),(-.30193,57.05331,1.79097),(-.31499,57.04557,1.8157),(-.31807,57.04959,1.8112),(-.31834,57.035,1.72674),(-.32592,57.00387,1.70733),(-.28808,57.01806,1.72695),(-.39383,56.92728,1.68961),(-.38458,56.95101,1.69849),(-.40036,56.94726,1.70857),(-.31439,57.20916,1.94159),(-.31271,57.20465,1.93731),(-.32104,57.21014,1.90768),(-.22452,57.24591,1.9585),(-.23314,57.23467,1.95912),(-.2337,57.23906,1.96331),(-.23577,57.28678,1.93045),(-.23227,57.27948,1.9352),(-.23464,57.28191,1.93691),(-.29239,57.27649,1.87044),(-.27943,57.30454,1.85962),(-.28849,57.31465,1.88118),(-.2467,57.43035,1.96225),(-.25584,57.32904,1.90709),(-.22203,57.38438,1.94997),(-.29257,57.41553,1.93064),(-.30852,57.40311,1.93249),(-.24976,57.42958,1.95891),(-.25224,57.22243,1.96928),(-.24635,57.23474,1.98187),(-.3266,57.32726,2.04255),(-.23215,57.30956,1.966),(-.33942,57.36403,1.98447),(-.20698,57.18501,1.8983),(-.2062,57.1739,1.88397),(-.22576,57.16747,1.90488),(-.30941,57.18805,1.91842),(-.27192,57.31399,1.88103),(-.2894,57.16186,1.9088),(-.27519,57.15873,1.8979),(-.28312,57.17205,1.87836),(-.19009,57.13997,2.01655),(-.21475,57.16998,1.94769),(-.1933,57.13176,1.93948),(-.27985,57.20875,2.01441),(-.22961,57.42679,1.98469),(-.2109,57.18254,2.04116),(-.21281,57.18511,1.98588),(-.22808,57.20226,1.99757),(-.25479,57.2124,2.01057),(-.25667,57.20225,2.021),(-.20347,57.19071,1.91462),(-.16842,57.22425,1.90226),(-.17011,57.21152,1.87538),(-.2202,57.21087,1.95874),(-.17182,57.24329,1.9493),(-.2052,57.2052,1.94054),(-.23451,57.3023,1.92478),(-.24387,57.20733,1.95616),(-.28228,57.19599,1.85707),(-.3108,57.2007,1.87966),(-.30174,57.17978,1.89666),(-.17656,57.1986,1.84926),(-.25442,57.32357,1.90325),(-.23522,57.28698,1.93456),(-.27733,57.20424,1.95396),(-.27869,57.20544,1.95743),(-.34441,57.17016,2.01185),(-.30545,57.28361,1.88168),(-.31057,57.26149,1.88807),(-.33032,57.38534,1.95349),(-.33504,57.37426,1.96884),(-.22716,57.2502,1.95879),(-.25534,57.32157,1.89786),(-.23505,57.32532,1.90574),(-.25181,57.21688,1.96408),(-.38186,56.96793,1.70611),(-.3379,57.06478,1.78822),(-.33108,57.05264,1.80867),(-.33751,57.0509,1.81144),(-.37865,57.03574,1.74988),(-.35169,57.04188,1.73439),(-.34448,57.06348,1.76074),(-.32016,57.06313,1.7866),(-.32394,57.05215,1.8086),(-.3429,56.91696,1.67956),(-.32333,56.93284,1.69219),(-.31638,56.93648,1.68334),(-.29668,56.97245,1.78112),(-.3383,56.92643,1.70548),(-.36347,57.03062,1.82026),(-.34185,57.04249,1.82111),(-.39109,56.9808,1.81225),(-.40125,56.99962,1.79612),(-.40657,56.97428,1.76477),(-.39705,57.01998,1.77263),(-.34117,56.92734,1.67534),(-.34923,56.91169,1.65901),(-.35047,56.90561,1.66472),(-.34175,56.91499,1.66788),(-.3804,56.92986,1.68077),(-.34813,56.91927,1.65687),(-.3116,56.97739,1.64676),(-.31997,56.98145,1.64403),(-.29319,56.96449,1.6405),(-.31017,56.97465,1.65109),(-.33663,56.85038,1.61856),(-.33335,56.92566,1.65447),(-.35654,56.91973,1.65269),(-.3625,56.91556,1.64768),(-.33736,56.9653,1.66219),(-.35759,56.96994,1.65519),(-.36022,56.97111,1.66359),(-.34103,56.96705,1.66751),(-.33925,56.9682,1.6642),(-.36063,56.97018,1.66579),(-.33825,56.97571,1.69257),(-.38958,56.92985,1.67729),(-.38467,56.92379,1.66301),(-.35869,56.91749,1.6531),(-.14696,56.78189,1.84954),(-.19367,56.85316,1.77876),(-.3294,56.85213,1.78158),(-.41133,56.82873,1.88673),(-.3273,56.85086,1.91267),(-.34334,56.79754,2.03757),(-.32719,56.9278,2.48418),(-.32849,56.84327,2.37074),(-.33765,56.7775,2.1606),(-.24971,56.79164,2.04848),(-.30612,57.0977,2.49491),(-.3545,56.78504,1.62337),(-.227,56.60319,1.45033),(-.14799,56.67372,1.96853),(-.22365,56.78324,2.22148),(-.39282,57.12035,1.91118),(-.1368,57.29166,2.59488),(-.15881,57.42631,2.42569),(-.24105,57.20711,2.49736),(-.21279,57.18873,2.50245),(-.21019,57.20473,2.49056),(-.20008,57.20062,2.53605),(-.19343,57.21513,2.51062),(-.12351,57.5523,2.40429),(-.30219,57.34201,2.35325),(-.30053,57.37287,2.35002),(-.20912,57.46028,2.1943),(-.36106,57.33208,1.90557),(-.1468,57.30788,1.94513),(-.17802,57.37464,2.00029),(-.17003,57.39456,2.05239),(-.29522,57.32536,1.77702),(-.2728,57.29151,1.73506),(-.39148,57.10433,1.85629),(-.30848,57.05745,1.50195),(-.22162,57.06393,2.54491),(-.15634,57.4253,2.16747),(-.17622,57.44036,2.19263),(-.23378,57.31998,2.15716),(-.24635,57.37103,2.15799),(-.35119,57.28931,1.98744),(-.30147,57.50556,2.3089),(-.27326,57.46958,2.21466),(-.25854,57.48049,2.22946),(-.2391,57.39801,2.22853),(-.27819,57.45424,2.20535),(-.21679,57.44225,2.28164),(-.31508,57.39201,2.11008),(-.19808,57.37881,2.03068),(-.21126,57.42192,2.01995),(-.21579,57.37666,2.30489),(-.2549,57.40883,2.3136),(-.20491,57.38437,2.28997),(-.20983,57.38212,2.2988),(-.23432,57.44206,2.29713),(-.23146,57.40861,2.22479),(-.25255,57.37266,2.26491),(-.22692,57.34236,2.26934),(-.1682,57.36692,2.09788),(-.1968,57.35844,2.25702),(-.21718,57.33879,2.25551),(-.21987,57.3293,2.26524),(-.22814,57.2771,2.15564),(-.23378,57.20774,2.45809),(-.25062,57.26223,2.42992),(-.23165,57.039,2.44695),(-.26601,57.32862,2.37865),(-.29102,57.27069,2.41823),(-.29938,57.23421,2.43786),(-.30117,57.15442,2.47705),(-.26842,57.33115,2.37634),(-.27029,57.33026,2.37721),(-.29419,57.26754,2.42577),(-.30461,57.23246,2.44567),(-.28414,57.29272,2.39984),(-.29964,57.3414,2.36534),(-.22978,57.34264,1.79155),(-.26154,57.33425,1.7845),(-.27289,57.39198,1.85412),(-.36569,57.2968,1.94633),(-.33745,57.36936,2.06591),(-.34755,57.35913,2.03785),(-.33463,57.36131,2.07571),(-.16725,57.42653,2.12752),(-.31114,57.36096,2.16793),(-.32765,57.38244,2.09093),(-.40487,56.80134,1.80684),(-.4209,56.80346,1.79591),(-.39275,56.75827,1.70117),(-.27986,56.58133,1.43337),(-.27766,56.58013,1.43347),(-.29473,56.60581,1.46347),(-.26142,56.57005,1.42306),(-.23983,56.56694,1.43209),(-.28235,56.81276,2.39546),(-.32474,56.84044,2.37319),(-.32258,56.92555,2.48643),(-.30565,56.89971,2.47939),(-.42033,56.82862,1.88979),(-.13967,57.29203,2.59642),(-.19289,56.87302,2.11989),(-.19479,56.87438,2.11845),(-.16609,56.74025,2.06398),(-.17048,56.71322,2.033),(-.22588,56.72052,2.19151),(-.18885,56.70008,2.05397),(-.20525,56.72011,2.22938),(-.1993,56.68095,2.15804),(-.19182,56.70606,2.24075),(-.21514,56.91781,2.37857),(-.12102,56.96338,2.46819),(-.13134,56.95032,2.46126),(-.18253,56.73459,2.26984),(-.14296,56.88088,2.42287),(-.12575,56.97022,2.46783),(-.11708,56.97619,2.47246),(-.13107,57.04295,2.50296),(-.22711,56.56946,1.47423),(-.22092,56.56766,1.47475),(-.20033,56.57258,1.52553),(-.13883,56.65017,1.76531),(-.11407,56.64425,2.18521),(-.10245,56.66305,2.1686),(-.10662,56.67359,2.22537),(-.16837,56.59474,1.5974),(-.13483,56.65845,1.66459),(-.14038,56.64446,1.73661),(-.14111,56.82886,2.35793),(-.10106,56.83158,2.34643),(-.10659,56.81727,2.37398),(-.42336,56.92027,1.84053),(-.424,56.91803,1.83062),(-.40419,56.9449,2.08514),(-.33292,56.98487,2.45538),(-.13243,56.65195,1.85709),(-.13445,56.63546,1.90249),(-.24429,56.67754,1.57637),(-.31295,56.69516,1.58483),(-.33053,56.72263,1.60645),(-.1668,57.29361,2.55817),(-.17669,57.33431,2.5197),(-.22019,57.13999,2.53187),(-.34314,56.86616,1.84987),(-.31403,56.85605,1.79312),(-.35909,56.8564,1.9028),(-.36306,56.86153,1.88459),(-.38889,56.75578,1.68822),(-.42923,56.90026,1.87095),(-.27171,57.33308,2.38496),(-.24435,57.21022,2.46564),(-.27393,57.33174,2.3855),(-.2624,57.2768,2.44363),(-.26064,57.27898,2.44417),(-.26865,57.33329,2.38759),(-.30261,57.15217,2.48443),(-.3028,57.15091,2.48058),(-.30302,57.14846,2.48107),(-.17708,56.68183,2.04301),(-.14679,56.7164,1.84848),(-.14584,56.70417,1.88481),(-.17797,56.62223,1.56517),(-.19008,56.69958,1.56752),(-.13264,57.21351,2.64753),(-.23428,56.95023,2.47112),(-.25328,56.9885,2.53383),(-.25181,56.97267,2.52129),(-.25141,56.93502,2.4952),(-.2559,56.96506,2.51689),(-.25818,56.91431,2.50677),(-.26232,56.91719,2.51038),(-.26124,56.90162,2.50204),(-.26509,56.92802,2.51372),(-.24617,57.22869,2.48421),(-.20497,57.24967,2.45351),(-.24964,57.24156,2.47541),(-.17641,57.34735,2.50646),(-.27336,57.21738,2.45076),(-.2496,57.2293,2.46016),(-.24903,57.21121,2.46654),(-.30303,57.15095,2.486),(-.29827,57.15319,2.47828),(-.30543,57.30904,2.3585),(-.31218,57.27594,2.37233),(-.34185,57.16349,2.45911),(-.33695,57.20159,2.43587),(-.29456,57.46883,2.32759),(-.29768,57.41066,2.33484),(-.35993,57.01035,2.41453),(-.33415,56.86126,1.80852),(-.34996,56.83591,1.78916),(-.33257,56.93621,2.35425),(-.20853,56.5763,1.52785),(-.20445,56.57963,1.54143),(-.24551,56.61114,1.50912),(-.14191,56.72295,1.66073),(-.15523,56.68956,1.6356),(-.15472,56.6627,1.84545),(-.13469,56.65026,1.76438),(-.12727,56.61836,1.96526),(-.12435,56.61543,1.99349),(-.11059,56.62542,2.05977),(-.11149,56.62309,2.0331),(-.10749,56.70097,2.27344),(-.11411,56.70135,2.28363),(-.11434,56.68485,2.26718),(-.13599,56.79843,2.39102),(-.14087,56.81709,2.40605),(-.11805,56.96505,2.46839),(-.1536,57.12539,2.6273),(-.16154,57.11894,2.61982),(-.18501,57.25845,2.57999),(-.15509,57.2341,2.63589),(-.25136,56.99652,2.53861),(-.25826,56.92558,2.51089),(-.34185,56.91794,2.42968),(-.38274,56.79836,2.16346),(-.41519,56.83627,1.94818),(-.33123,56.72357,1.61702),(-.32603,56.71788,1.60805),(-.31064,56.68589,1.57445),(-.29567,56.60851,1.46055),(-.29609,56.60638,1.46211),(-.30005,56.61426,1.47277),(-.12425,56.6315,1.9269),(-.1431,56.62513,1.67989),(-.12322,56.64008,1.90104),(-.12742,56.63857,1.90111),(-.24207,56.56452,1.4343),(-.23029,57.43185,1.9845),(-.24421,57.39574,1.8729),(-.24764,57.43554,1.96177),(-.22646,57.3427,1.79425),(-.42211,56.86447,1.98416),(-.41942,56.87906,2.03859),(-.15761,56.66923,1.74911),(-.31715,56.69564,1.58349),(-.21448,57.05981,2.54371),(-.24835,57.01295,2.54404),(-.25488,56.85469,2.453),(-.25795,56.85417,2.45533),(-.25997,56.84806,2.4493),(-.26294,56.84143,2.44154),(-.2651,56.90295,2.5024),(-.24207,56.88098,2.44026),(-.15556,57.4209,2.15388),(-.16725,57.4201,2.12568),(-.34339,56.79607,2.04414),(-.26694,57.21612,1.97075),(-.30137,57.17813,1.95253),(-.26565,57.215,1.96848),(-.28769,57.16992,1.94431),(-.26344,57.21455,1.96727),(-.27469,57.19818,1.95984),(-.25975,57.19887,1.95894),(-.2545,57.15181,1.91584),(-.26889,57.15011,1.91342),(-.24751,57.15264,1.91702),(-.26904,57.14163,1.894),(-.2296,57.13792,1.90517),(-.25789,57.2219,1.98719),(-.2561,57.22127,1.98493),(-.24907,57.21744,2.00068),(-.25564,57.21853,2.00276),(-.27211,57.21036,2.00785),(-.35019,57.12068,1.92299),(-.27266,56.93901,1.99014),(-.28347,56.94493,1.99231),(-.27616,56.95585,1.92905),(-.28871,56.93664,1.95711),(-.29092,56.94751,1.98925),(-.26681,56.93455,1.98425),(-.26802,56.93005,1.96445),(-.33343,56.9866,1.95044),(-.28889,57.01754,2.02556),(-.28343,56.972,2.00039),(-.336,56.81354,2.03512),(-.33803,56.81587,2.03636),(-.30152,56.88379,2.00911),(-.3456,56.81667,2.02376),(-.34801,56.79838,2.04179),(-.26436,57.15482,1.91988),(-.26626,57.15719,1.92311),(-.26875,57.15324,1.91821),(-.24258,57.16129,1.92979),(-.24172,57.15771,1.92467),(-.26322,57.28278,1.80752),(-.22425,57.31325,1.82262),(-.23931,57.3102,1.81608),(-.19648,57.31384,1.86381),(-.19834,57.32977,1.9006),(-.21423,57.33475,1.87283),(-.22302,57.33842,1.88156),(-.21236,57.33056,1.9034),(-.23588,57.33913,1.88364),(-.25525,57.16805,1.93408),(-.2531,57.18644,1.94416),(-.23541,57.18432,1.94247),(-.2894,57.1741,1.9328),(-.27441,57.1823,1.9402),(-.26309,57.16589,1.93207),(-.26684,57.16174,1.92727),(-.26085,57.1529,1.91728),(-.26471,57.15616,1.91837),(-.26654,57.15816,1.9225),(-.26134,57.16872,1.93982),(-.268,57.16738,1.93984),(-.35331,57.16594,1.83243),(-.34003,57.15994,1.8387),(-.33007,57.18105,1.84454),(-.36778,57.08062,1.80171),(-.31591,57.17331,1.85959),(-.32199,57.15123,1.85343),(-.30562,57.14235,1.87514),(-.34857,57.0676,1.81064),(-.34238,57.05644,1.82026),(-.32991,57.0669,1.82987),(-.3281,57.13726,1.85235),(-.38725,57.02473,1.809),(-.37293,57.03325,1.81383),(-.3864,57.02643,1.81169),(-.38557,57.03048,1.81277),(-.37979,57.03422,1.81548),(-.38711,57.0397,1.79676),(-.39902,57.02277,1.79819),(-.38883,57.02654,1.81197),(-.38821,57.02501,1.80916),(-.39301,57.02034,1.80886),(-.39696,57.02098,1.81023),(-.39066,57.0354,1.81231),(-.40399,56.9835,1.82057),(-.40634,57.00475,1.8095),(-.4079,56.9854,1.81942),(-.42107,56.92776,1.83873),(-.42503,56.93064,1.8411),(-.42623,56.9296,1.83867),(-.40783,56.98401,1.81742),(-.42526,56.92085,1.83881),(-.42375,56.92227,1.83914),(-.42502,56.9223,1.83886),(-.42718,56.92292,1.84371),(-.42621,56.92334,1.84463),(-.4261,56.92034,1.84639),(-.42396,56.92079,1.84427),(-.35262,56.80225,2.02881),(-.3552,56.80079,2.0385),(-.35328,56.80009,2.04136),(-.34529,56.80057,2.02811),(-.34527,56.80028,2.02789),(-.34701,56.80133,2.02475),(-.33962,57.08608,1.79938),(-.27184,57.01577,1.80128),(-.26619,57.01407,1.79445),(-.21976,57.10551,1.71498),(-.28791,57.11807,1.70426),(-.18766,57.07916,1.72414),(-.21247,57.03272,1.74111),(-.31109,57.07198,1.81461),(-.28861,56.90384,1.80183),(-.31215,56.88676,1.85931),(-.3099,56.88751,1.86085),(-.31568,56.88522,1.86457),(-.31619,56.87867,1.87199),(-.31575,56.87825,1.87146),(-.32031,56.88352,1.87448),(-.31736,56.85828,1.89399),(-.3265,56.86125,1.8836),(-.32535,56.86085,1.88474),(-.26688,56.94823,1.77398),(-.2563,56.94954,1.79556),(-.25974,56.96481,1.80125),(-.27586,56.98395,1.83928),(-.3221,56.96159,1.94714),(-.33933,56.96273,1.94126),(-.32362,56.96528,1.84771),(-.28573,56.93926,1.76636),(-.32943,56.96326,1.96688),(-.34764,56.96403,1.96008),(-.31591,56.91651,1.80367),(-.26953,57.01147,1.81867),(-.27281,57.01201,1.81768),(-.27294,57.0246,1.82185),(-.26666,57.02588,1.82346),(-.26066,57.01408,1.79081),(-.26575,57.00583,1.79939),(-.25514,57.01549,1.79193),(-.28514,56.98487,1.84534),(-.28374,56.98557,1.82557),(-.26909,56.98227,1.8141),(-.26195,56.97508,1.81992),(-.26777,56.9808,1.831),(-.27346,56.91582,1.8715),(-.28488,56.89769,1.87057),(-.32803,56.94058,1.99334),(-.35407,56.93386,2.01691),(-.36904,56.93578,2.00818),(-.3173,56.87027,1.86891),(-.29708,57.16454,1.6325),(-.30197,57.17521,1.64139),(-.27713,57.17493,1.63484),(-.26553,57.16652,1.63068),(-.25675,57.17344,1.63434),(-.2762,57.1499,1.62641),(-.21047,57.16211,1.64049),(-.24844,57.1706,1.63401),(-.22735,57.15822,1.63324),(-.21013,57.14016,1.63498),(-.28164,56.97289,1.68562),(-.25573,57.05584,1.72345),(-.28379,57.01133,1.71502),(-.23898,57.18929,1.66191),(-.3154,57.06779,1.72928),(-.30989,57.08359,1.70413),(-.33138,57.06703,1.71185),(-.32602,57.05411,1.73462),(-.31221,57.05781,1.74863),(-.30258,57.0272,1.72156),(-.31456,57.13036,1.65293),(-.3074,57.13595,1.66896),(-.31016,57.02334,1.71604),(-.30139,56.98653,1.686),(-.28731,57.01962,1.72039),(-.25815,56.95662,1.66603),(-.26325,56.95591,1.6635),(-.28309,56.96462,1.67608),(-.28403,56.96668,1.67943),(-.2469,56.96547,1.65166),(-.26663,56.9546,1.67045),(-.20864,56.85713,1.55445),(-.21927,56.85098,1.53557),(-.23815,56.82907,1.55636),(-.19402,56.96673,1.53953),(-.24729,56.83048,1.57611),(-.26179,56.82821,1.57857),(-.26101,56.83087,1.58149),(-.24145,56.90238,1.57629),(-.2457,56.88765,1.5793),(-.26496,56.84071,1.55889),(-.24162,56.95573,1.55059),(-.24808,56.95862,1.53976),(-.24285,56.96641,1.5354),(-.19852,56.98445,1.53944),(-.21497,56.98377,1.52222),(-.26757,56.91051,1.56403),(-.26026,56.90813,1.58709),(-.25586,56.90619,1.58529),(-.26038,56.93574,1.58047),(-.25278,56.90502,1.58616),(-.24915,56.93098,1.57618),(-.23058,56.95507,1.56986),(-.23717,56.92851,1.58491),(-.20757,57.06426,1.54232),(-.19028,57.08427,1.58371),(-.20333,57.09835,1.58047),(-.21556,56.9627,1.60262),(-.2036,57.1043,1.61188),(-.21066,57.11707,1.61013),(-.21604,56.9839,1.61738),(-.2281,56.97253,1.623),(-.23927,56.93506,1.60817),(-.27662,56.98182,1.60701),(-.26475,56.91334,1.6018),(-.28813,57.04905,1.5929),(-.29439,57.04399,1.57943),(-.30224,57.00184,1.59749),(-.26587,56.9122,1.59528),(-.23179,57.12735,1.60903),(-.22342,57.125,1.61756),(-.2503,57.06297,1.52542),(-.27333,57.09571,1.57496),(-.2163,57.10946,1.61975),(-.19091,57.2101,2.18594),(-.21461,57.16959,2.09228),(-.1531,57.19904,2.06443),(-.22007,57.17944,2.13565),(-.2244,57.17528,2.11961),(-.22251,57.171,2.1035),(-.18803,57.18209,2.1413),(-.33459,56.81878,1.57912),(-.35058,56.81847,1.57567),(-.361,56.84035,1.61542),(-.27266,56.8837,1.52009),(-.23415,56.87032,1.51478),(-.26823,56.91014,1.5763),(-.26881,56.89449,1.58308),(-.31295,56.82168,1.5337),(-.28916,56.82825,1.5376),(-.29988,56.80606,1.53366),(-.30132,56.80572,1.53538),(-.31955,56.79317,1.53308),(-.32006,56.79549,1.53193),(-.32127,56.79618,1.5365),(-.29881,56.79332,1.53683),(-.2994,56.7948,1.53843),(-.31492,56.78847,1.54757),(-.31165,56.78708,1.54654),(-.31256,56.78055,1.56104),(-.30774,56.78679,1.54584),(-.30244,56.78848,1.54566),(-.3025,56.79132,1.54674),(-.30784,56.79327,1.54835),(-.31161,56.79315,1.5489),(-.31234,56.7883,1.56412),(-.31468,56.79204,1.54894),(-.31315,56.77758,1.5763),(-.31361,56.77824,1.57681),(-.31646,56.77488,1.57745),(-.3141,56.77535,1.57614),(-.30937,56.7812,1.56095),(-.3129,56.77676,1.57586),(-.31831,56.77917,1.58008),(-.30962,56.7883,1.56378),(-.31613,56.7792,1.57872),(-.38863,56.82717,1.64218),(-.40897,56.84253,1.66221),(-.20476,56.63483,1.50397),(-.40856,56.84254,1.6672),(-.38796,56.82677,1.64612),(-.39761,56.83406,1.65597),(-.2065,56.83328,1.53625),(-.28215,56.76319,1.48804),(-.31207,56.77325,1.57754),(-.34842,56.79804,1.60744),(-.31858,56.6912,1.57055),(-.31287,56.77918,1.57968),(-.31209,56.7779,1.57877),(-.31144,56.77594,1.57772),(-.31528,56.77333,1.57927),(-.31701,56.77491,1.58089),(-.32199,56.75549,1.59711),(-.31192,56.77606,1.57768),(-.31167,56.7756,1.57775),(-.31475,56.77882,1.58049),(-.31447,56.77922,1.58078),(-.40111,56.84125,1.65195),(-.39894,56.84474,1.64598),(-.39846,56.84003,1.65422),(-.3981,56.83888,1.65712),(-.39818,56.8391,1.6576),(-.39814,56.83895,1.65753),(-.39762,56.83435,1.65574),(-.39757,56.83417,1.65596),(-.39545,56.83308,1.6539),(-.39291,56.83635,1.65214),(-.3926,56.83645,1.65222),(-.39396,56.83798,1.65373),(-.24086,56.85047,1.52047),(-.26307,56.82322,1.5413),(-.28768,56.90781,1.65227),(-.29147,56.9122,1.64814),(-.21328,56.9523,1.6665),(-.22085,56.9437,1.64916),(-.19044,56.92157,1.63507),(-.19387,56.93505,1.69291),(-.24045,56.86656,1.59216),(-.20796,56.9179,1.6931),(-.23311,56.91661,1.69239),(-.2293,56.9253,1.70282),(-.28165,56.88403,1.63715),(-.28165,56.89083,1.64587),(-.24842,56.92957,1.69635),(-.24562,56.94102,1.71271),(-.25024,56.91692,1.67674),(-.26721,56.95388,1.67595),(-.27088,56.95042,1.67917),(-.27407,56.95698,1.67997),(-.27981,56.95837,1.68152),(-.27431,56.94791,1.68022),(-.28262,56.95823,1.68131),(-.27754,56.94322,1.67467),(-.28348,56.95587,1.67748),(-.28067,56.95403,1.6742),(-.27567,56.94402,1.67135),(-.27574,56.95147,1.67019),(-.2742,56.95096,1.66921),(-.26853,56.94821,1.66823),(-.27,56.95053,1.66952),(-.2694,56.94759,1.6782),(-.26521,56.94956,1.67481),(-.26423,56.94965,1.67316),(-.26501,56.94828,1.6706),(-.27404,56.94128,1.6703),(-.2338,56.9078,1.69127),(-.2055,56.91138,1.69488),(-.13349,56.84018,1.68036),(-.14455,56.85555,1.69099),(-.13885,56.85294,1.6958),(-.18599,56.97574,1.57707),(-.26328,56.94711,1.67509),(-.26383,56.93717,1.66159),(-.26383,56.94119,1.66168),(-.26052,56.94226,1.67609),(-.26045,56.93863,1.67593),(-.26086,56.93325,1.674),(-.25943,56.93759,1.68018),(-.2539,56.94338,1.64907),(-.26341,56.94578,1.66395),(-.26469,56.94131,1.65801),(-.28965,56.86042,1.63322),(-.28398,56.8821,1.62897),(-.25495,56.82077,1.56866),(-.21376,56.86476,1.57132),(-.2416,56.86357,1.59031),(-.24029,56.86461,1.58835),(-.24743,56.83767,1.58185),(-.24613,56.83989,1.58524),(-.26927,56.83823,1.58347),(-.26934,56.88244,1.59349),(-.27276,56.88204,1.59283),(-.27281,56.8636,1.59167),(-.27168,56.86544,1.59997),(-.27955,56.88381,1.59855),(-.27607,56.88222,1.59382),(-.27831,56.88278,1.59567),(-.26986,56.86616,1.6),(-.27618,56.85198,1.59619),(-.2716,56.85002,1.58903),(-.26714,56.86395,1.59482),(0,57.50186,2.06363),(-.03513,57.50466,2.16097),(-.08786,57.45068,2.42126),(-.07088,57.39835,2.43738),(-.03285,57.51345,2.44964),(-.09757,57.45122,2.42289),(-.08118,57.48485,2.44254),(-.1192,57.45521,2.43425),(-.10715,57.24002,2.4387),(-.06585,57.51285,2.44156),(-.08966,57.43382,2.37538),(0,57.38284,2.00514),(0,57.30939,1.93922),(-.03678,57.51582,2.24089),(-.03851,57.56985,2.3208),(-.0207,57.59117,2.14392),(0,57.63047,2.13033),(-.01839,57.61111,2.1496),(-.21189,56.88589,1.60717),(-.2007,56.95261,1.59163),(-.09661,57.13479,2.03883),(-.08387,56.79657,1.93824),(-.13565,57.14374,1.68874),(-.12338,56.93419,1.76015),(-.1049,56.99045,1.93435),(-.10384,57.04969,2.00005),(-.10744,57.02607,1.92269),(-.10703,57.10608,2.04803),(-.10261,57.10719,2.04887),(-.09578,57.11863,2.04518),(-.11173,57.17441,2.13604),(-.09697,56.8396,1.83664),(-.1256,56.89106,1.82086),(-.1315,56.92993,1.6903),(-.10765,56.9633,1.8797),(-.11139,56.96407,1.87894),(-.11239,56.93521,1.7981),(-.0994,57.05013,2.00074),(-.12432,57.15303,2.08123),(-.11191,57.13018,2.03149),(-.13395,56.91604,1.68512),(-.12624,56.91825,1.71503),(-.15349,56.87887,1.71545),(-.15132,57.00341,1.67705),(-.10271,57.32379,2.35878),(-.14072,56.91879,1.62114),(-.14882,56.9071,1.63111),(-.12486,56.91619,1.68125),(-.18037,56.90834,1.60646),(-.18324,56.88679,1.60625),(-.16386,57.04016,1.56464),(-.12885,57.08962,1.63622),(-.13066,57.08915,1.63415),(-.20473,57.01013,1.55642),(-.14587,56.91156,1.6599),(-.18171,56.88597,1.60564),(-.17225,56.89504,1.61637),(-.15117,56.99843,1.60467),(-.15052,57.05112,1.58037),(-.18415,56.89484,1.59431),(-.16786,56.8993,1.58729),(-.17111,56.89524,1.60936),(-.13344,57.01015,1.78137),(-.13125,57.18557,1.7214),(-.13137,57.05259,1.7232),(-.09009,56.75431,1.79054),(-.08008,57.03623,1.92601),(-.0807,57.03105,1.92732),(-.11558,57.25325,2.1092),(-.15027,56.92634,1.5953),(-.13504,56.99209,1.61448),(-.121,57.01833,1.66139),(-.09313,57.04199,1.60171),(-.1048,56.9535,1.70578),(-.11255,57.02684,1.71342),(-.10102,56.95866,1.7333),(-.17283,56.89147,1.58349),(-.20302,56.83739,1.53829),(-.20377,56.84243,1.54975),(-.02536,56.70184,2.29775),(-.02207,56.68923,2.24034),(-.02038,56.67617,2.25059),(-.0285,56.82986,2.39435),(-.0292,57.3665,2.50667),(-.0271,57.08197,2.48277),(-.02973,57.10414,2.47009),(-.02878,57.04249,2.46514),(-.01449,56.64401,1.85514),(0,56.69532,1.72027),(-.03997,57.29209,2.32159),(-.02068,56.67134,1.92345),(-.02118,56.74377,2.35268),(0,56.76722,2.45921),(0,56.90367,2.49596),(0,57.03234,2.4976),(.00003,57.16073,2.54898),(0,57.59347,2.47459),(-.02377,56.75827,2.35597),(-.03684,57.43122,2.5099),(-.02595,56.97495,2.43115),(-.03169,56.99862,2.43226),(-.03113,56.86664,2.39704),(-.01546,56.68413,2.05295),(0,56.66927,2.15048),(-.01985,56.87642,1.85808),(-.02746,56.84626,1.79355),(-.02783,56.84229,1.7895),(-.0944,57.36747,2.06931),(-.04131,57.17539,2.14194),(-.03006,57.14704,2.443),(-.05151,57.33794,2.45404),(-.02975,57.23525,2.48891),(0,56.68522,2.34126),(0,56.69236,2.35714),(-.01704,56.68738,2.2908),(-.01878,56.70186,2.3127),(-.02715,57.09725,2.48781),(-.01872,56.96764,2.42206),(-.01646,57.04218,1.4963),(-.01451,57.05812,1.48775),(0,56.67726,2.28278),(-.01324,56.66535,2.18018),(-.0208,57.70917,2.19029),(-.01975,57.62471,2.15243),(-.01985,57.65533,2.13848),(-.01919,57.71466,2.2504),(-.05951,57.66294,2.36515),(0,57.31377,1.7437),(0,57.59781,2.47217),(-.03321,57.15317,2.37888),(-.01756,56.67196,2.23762),(0,57.50433,2.52583),(-.07962,57.38785,2.12159),(-.02918,56.82114,2.37319),(-.01432,56.68783,2.06322),(-.01515,56.67765,2.06673),(-.03047,56.71412,2.29383),(-.0254,56.72895,2.32325),(-.01767,56.70405,1.98811),(0,56.64289,2.08638),(-.20319,56.85831,1.58657),(-.11251,56.94847,1.67912),(-.10731,57.02422,1.71213),(-.08022,57.14875,1.55203),(-.08452,57.12139,1.54951),(-.07995,56.92073,2.21565),(-.0784,56.90456,2.16523),(-.12889,57.0353,1.69603),(-.12884,57.2157,2.06052),(-.14185,57.02876,1.85872),(-.13688,57.00787,1.62733),(-.14476,56.91062,1.65957),(-.15754,56.90375,1.63531),(-.11359,56.94266,1.67973),(-.15464,56.98834,1.63613),(-.15274,56.99378,1.64965),(-.09453,57.40867,2.1918),(-.08364,57.42257,2.32377),(-.10155,57.05868,1.91128),(-.14711,56.86362,1.70508),(-.12694,56.93463,1.712),(-.08899,56.82126,2.13015),(-.19268,56.89764,1.61565),(-.28391,56.89957,1.65112),(-.10052,57.14381,1.97318),(-.10942,57.1806,1.96453),(-.11794,56.92961,1.71299),(-.2794,56.85337,1.6013),(-.28183,56.86501,1.59677),(-.27984,56.86329,1.5924),(-.27013,56.865,1.59676),(-.23728,56.86184,1.58764),(-.23398,56.85429,1.5817),(-.27494,56.91564,1.65235),(-.26405,56.93013,1.66064),(-.25792,56.96501,1.69646),(-.26039,56.94898,1.67744),(-.2609,56.9471,1.675),(-.18207,56.85067,1.68082),(-.27183,56.94236,1.66871),(-.26568,56.93806,1.67411),(-.2743,56.9433,1.67848),(-.27189,56.94631,1.66858),(-.27317,56.94529,1.66956),(-.26672,56.9524,1.67564),(-.26748,56.90172,1.6495),(-.19709,56.94561,1.69369),(-.25554,56.82402,1.54629),(-.2669,56.82929,1.54607),(-.39548,56.8335,1.65373),(-.39918,56.83733,1.65805),(-.40024,56.83999,1.65024),(-.31203,56.77815,1.57882),(-.31351,56.77193,1.57785),(-.32046,56.77805,1.58415),(-.31888,56.77959,1.58365),(-.31268,56.77484,1.57814),(-.44175,56.8938,1.75196),(-.39892,56.83506,1.65731),(-.30444,56.78735,1.54555),(-.30122,56.80655,1.53556),(-.3014,56.80948,1.53006),(-.32355,56.80287,1.54422),(-.29948,56.81182,1.53616),(-.31532,56.8657,1.54922),(-.22431,57.17487,2.11989),(-.19319,57.18619,2.02263),(-.345,57.35729,2.01929),(-.25757,57.05435,1.52256),(-.24523,57.125,1.61368),(-.29571,57.00414,1.60746),(-.22608,56.98914,1.62381),(-.20923,57.08118,1.55103),(-.24992,56.90465,1.58976),(-.24377,56.96953,1.54077),(-.23687,56.9665,1.5471),(-.27825,56.9127,1.54224),(-.26835,56.94187,1.54144),(-.25774,56.93858,1.55786),(-.2555,56.86405,1.58597),(-.26586,56.95589,1.67289),(-.21433,56.99478,1.66555),(-.34188,57.03623,1.71185),(-.33771,57.10123,1.66725),(-.27258,57.09784,1.69299),(-.24551,57.17271,1.63707),(-.25983,57.17751,1.63744),(-.36224,56.95186,2.00327),(-.35181,56.95003,2.00905),(-.27105,56.98336,1.82013),(-.28002,56.98531,1.82709),(-.26305,57.00552,1.80038),(-.32224,56.86867,1.8844),(-.31787,56.87844,1.87445),(-.31522,56.88476,1.89417),(-.29643,56.90636,1.79143),(-.28644,57.09765,1.86622),(-.33047,57.10249,1.83402),(-.20228,57.04572,1.76472),(-.33354,56.86209,1.88724),(-.30854,56.85753,1.88809),(-.34342,56.79937,2.03125),(-.35363,56.79976,2.04179),(-.35281,56.80195,2.02845),(-.42835,56.91911,1.84494),(-.42769,56.91968,1.8445),(-.42237,56.92321,1.84124),(-.42293,56.92329,1.84289),(-.42419,56.92117,1.83921),(-.42589,56.93033,1.84004),(-.42146,56.92708,1.83741),(-.40575,57.00419,1.80727),(-.38966,57.03027,1.81304),(-.39472,57.02052,1.81037),(-.38761,57.03423,1.7975),(-.38498,57.04115,1.80942),(-.38305,57.0373,1.81318),(-.38513,57.03585,1.81201),(-.37604,57.03272,1.81568),(-.34303,57.083,1.81901),(-.30477,57.16519,1.88218),(-.35801,57.07662,1.8037),(-.3434,57.18665,1.84081),(-.26026,57.15489,1.91525),(-.24721,57.16739,1.93084),(-.20964,57.32847,1.85818),(-.24672,57.2235,1.82614),(-.2176,57.25101,1.80932),(-.24471,57.25312,1.81032),(-.24357,57.28022,1.80096),(-.27575,57.29465,1.83621),(-.31072,56.88421,1.99739),(-.29894,56.88175,2.00669),(-.21764,56.99054,1.94863),(-.27868,56.96799,1.89728),(-.29536,56.9474,1.98289),(-.36591,57.09609,1.96155),(-.1986,57.07512,1.9198),(-.26403,57.21703,1.99873),(-.26061,57.21503,1.96826),(-.31755,57.11274,1.88657),(-.2796,56.81289,2.39242),(-.24695,56.99357,2.53534),(-.20517,57.07273,2.55307),(-.16689,57.122,2.62483),(-.40637,56.80539,1.81775),(-.22373,57.38909,1.90963),(-.34151,57.29942,1.78022),(-.11821,56.6219,1.96359),(-.30016,56.61655,1.47065),(-.33675,56.72552,1.61767),(-.38487,56.75755,1.70358),(-.38085,56.75359,1.69384),(-.41174,56.82574,1.87453),(-.39179,56.8087,2.04525),(-.35546,56.80084,2.03863),(-.25389,56.86293,2.46168),(-.27727,56.86613,2.46868),(-.2587,56.97284,2.52319),(-.15744,57.20668,2.64454),(-.16731,57.14014,2.63871),(-.16299,57.15102,2.6422),(-.10372,56.98732,2.44036),(-.11296,56.97623,2.47029),(-.11295,56.96406,2.4653),(-.1249,56.8214,2.39909),(-.1198,56.80268,2.38416),(-.11265,56.63866,2.16303),(-.12417,56.65173,2.22423),(-.12666,56.66186,2.24523),(-.11617,56.62556,2.10221),(-.11603,56.62861,2.12168),(-.29377,56.61085,1.47449),(-.29147,56.60526,1.46526),(-.26147,56.59383,1.46467),(-.3433,56.95007,2.25739),(-.28333,57.1876,2.4602),(-.28889,57.1842,2.47184),(-.2565,57.24834,2.4292),(-.19962,57.35199,2.36406),(-.17933,57.3579,2.48364),(-.25316,57.25427,2.46572),(-.25686,57.26677,2.45524),(-.25971,56.89911,2.49913),(-.09593,57.53936,2.42),(-.26923,57.33139,2.38646),(-.27655,57.33424,2.38717),(-.29888,56.85843,1.81153),(-.17415,57.29613,2.56376),(-.37508,56.74451,1.65548),(-.0993,56.65257,1.90489),(-.15937,56.84362,2.35402),(-.14408,56.62237,1.66924),(-.1172,56.65518,2.22144),(-.20464,56.57341,1.52669),(-.13461,57.04453,2.50121),(-.15492,56.76462,2.34402),(-.16495,56.87101,2.35309),(-.22512,56.74223,2.20226),(-.16651,56.64658,2.02323),(-.15198,56.75791,2.07219),(-.25659,56.57206,1.43338),(-.24789,56.5665,1.43701),(-.38921,56.75672,1.70302),(-.3516,57.33874,2.01442),(-.34813,57.36214,2.01964),(-.24798,57.39643,1.87171),(-.28893,57.29162,2.40761),(-.19485,57.35439,2.25187),(-.20258,57.35224,2.24944),(-.22829,57.3473,2.28671),(-.25295,57.4386,2.30967),(-.2529,57.37605,2.28736),(-.27122,57.47015,2.20875),(-.32472,57.37773,2.08956),(-.20853,57.43288,2.26524),(-.3446,57.06965,1.58576),(-.12602,57.25696,2.4971),(-.16865,56.69115,2.27487),(-.22526,56.58703,1.45243),(-.25587,56.88971,2.4896),(-.29318,56.98717,1.69768),(-.35893,56.97942,1.69063),(-.30796,56.86397,1.61105),(-.39993,56.9891,1.74668),(-.38444,57.01454,1.81416),(-.35237,56.90878,1.68434),(-.31017,56.95699,1.74442),(-.36585,57.0528,1.7719),(-.35182,57.05647,1.79384),(-.39811,56.96036,1.71815),(-.31277,57.24254,1.89024),(-.30581,57.25425,1.88341),(-.30866,57.18163,1.94159),(-.20863,57.24185,1.95965),(-.2248,57.19352,1.98246),(-.23143,57.18419,1.95621),(-.27079,57.425,1.9395),(-.32159,57.39444,1.94042),(-.3818,56.93029,1.68615),(-.29176,57.03953,1.80009),(-.30474,57.01677,1.82822),(-.3229,56.98282,1.83304),(-.40581,56.95222,1.72972),(-.39653,56.91848,1.67914),(-.35642,56.95122,1.63367),(-.33898,56.95982,1.62398),(-.3314,56.98068,1.63639),(-.34392,56.97799,1.63775),(-.32148,56.9633,1.61862),(-.29664,56.90316,1.56467),(-.3175,56.97574,1.658),(-.32742,56.98597,1.67217),(-.34264,56.96496,1.6693),(-.33921,56.96949,1.67958),(-.31009,56.85849,1.87738),(-.09792,56.64317,1.97322),(-.2012,57.33144,1.84273),(-.38416,57.09849,1.77645),(-.29049,57.4164,2.21525),(-.29801,57.44147,2.3035),(-.26428,57.41212,2.15835),(-.24484,57.42218,2.18247),(-.29434,57.41725,2.13484),(-.2874,57.40206,2.13423),(-.20225,57.37856,2.26863),(-.21082,57.35001,2.25223),(-.20987,57.34795,2.24973),(-.18175,57.34685,2.27298),(-.26337,56.96598,2.46495),(-.23689,57.24476,2.44585),(-.17079,56.59258,1.5983),(-.41992,56.82531,1.87748),(-.21313,56.8732,2.17342),(-.13985,56.88195,2.38644),(-.26249,56.6286,1.44814),(-.43457,56.89567,1.74625),(-.40688,56.82178,2.0234),(-.40214,56.81704,2.02172),(-.20636,57.25135,2.54231),(-.2128,57.07649,2.55437),(-.23916,57.54964,2.33825),(-.20903,57.56391,2.3307),(-.36826,56.84926,1.8527),(-.39293,56.81357,2.01981),(-.30416,57.15251,2.48202),(-.25108,56.5877,1.46493),(-.23452,56.56951,1.46423),(-.23147,56.57268,1.47574),(-.1814,56.58999,1.58913),(-.1319,56.62771,1.92818),(-.12121,56.61743,2.03162),(-.11917,56.62003,2.05906),(-.11321,56.62147,1.99189),(-.11839,56.63651,2.16451),(-.12015,56.64177,2.18685),(-.11743,56.66608,2.2419),(-.15004,56.84616,2.4306),(-.14968,56.86541,2.44074),(-.15193,57.12996,2.6296),(-.13245,57.22442,2.64372),(-.25674,56.9635,2.51865),(-.25641,56.89699,2.49503),(-.40504,56.81729,2.04963),(-.39996,56.80209,1.80658),(-.11272,56.62707,2.1017),(-.35499,57.31589,1.99065),(-.168,56.65156,2.02159),(-.14269,57.20846,2.64987),(-.14585,57.19834,2.6494),(-.42791,56.9169,1.83327),(-.36826,57.07223,1.94448),(-.31506,57.14696,1.90305),(-.24853,57.05306,1.85964),(-.29644,56.94397,1.9712),(-.2769,57.22566,1.83711),(-.25527,57.17234,1.87116),(-.19796,57.30328,1.83919),(-.21254,57.31994,1.83811),(-.3566,57.11801,1.81838),(-.36259,57.16866,1.83926),(-.38369,57.04724,1.80204),(-.38522,57.04479,1.80532),(-.38576,57.04557,1.80114),(-.42252,56.92974,1.84112),(-.42275,56.92263,1.84003),(-.4271,56.92331,1.84004),(-.42583,56.91945,1.83949),(-.4249,56.9198,1.83961),(-.42596,56.91746,1.83196),(-.42324,56.9207,1.84239),(-.42381,56.92017,1.84091),(-.35505,56.80193,2.03198),(-.31137,56.85963,1.86594),(-.21338,57.23538,1.71195),(-.24645,57.0207,1.76051),(-.15944,57.16267,1.73811),(-.15286,57.15252,1.79005),(-.20396,57.27341,1.77507),(-.32048,56.86855,1.88359),(-.32327,56.86056,1.88335),(-.32091,56.86042,1.88048),(-.3174,56.85899,1.8855),(-.31767,56.85899,1.88604),(-.27867,56.9817,1.80533),(-.27183,56.94803,1.88045),(-.36561,56.92077,1.93232),(-.2671,56.92081,1.81936),(-.32313,56.86933,1.88024),(-.2685,57.08071,1.60146),(-.25851,57.1914,1.65841),(-.25488,56.97664,1.67934),(-.26735,56.95722,1.67473),(-.27577,56.95519,1.66961),(-.27424,56.95468,1.66865),(-.21852,56.98529,1.54588),(-.23205,57.00986,1.51854),(-.21697,57.01448,1.54009),(-.21217,57.03499,1.53272),(-.20987,57.07084,1.60848),(-.27223,57.04913,1.60046),(-.25876,57.11364,1.57842),(-.26981,56.85316,1.58917),(-.21067,56.95216,2.2259),(-.22681,56.96638,2.26871),(-.21064,56.96894,2.26134),(-.21651,56.95161,2.22744),(-.21987,57.16163,2.22456),(-.20287,57.16916,2.08848),(0,57.75634,2.33962),(-.34697,56.90489,1.59837),(-.29042,56.87941,1.55264),(-.30815,56.81325,1.55488),(-.30517,56.80428,1.53766),(-.3015,56.79622,1.53979),(-.3133,56.77799,1.57771),(-.31836,56.77615,1.58217),(-.31693,56.77522,1.581),(-.39957,56.84214,1.65337),(-.39609,56.84025,1.65094),(-.39548,56.83816,1.64804),(-.39859,56.83539,1.6568),(-.39243,56.83433,1.65161),(-.16977,56.77333,1.5933),(-.24767,56.96953,1.70958),(-.25246,56.95745,1.71519),(-.29148,56.89429,1.62478),(-.26575,56.95249,1.67395),(-.26653,56.95113,1.6714),(-.26219,56.94817,1.66953),(-.25991,56.94312,1.67876),(-.25693,56.94937,1.69953),(-.26437,56.93554,1.65929),(-.26579,56.86286,1.59225),(-.27166,56.86511,1.60034),(-.27679,56.85952,1.60244),(-.10229,57.11041,2.21609),(-.14348,57.00794,1.73162),(-.11014,56.94137,1.76529),(-.13894,56.79614,1.63924),(-.20643,56.9429,1.58687),(-.13053,57.24969,1.85847),(-.08369,56.80381,1.99817),(-.08639,56.9042,2.32701),(-.14848,56.8642,1.70245),(-.13079,57.03078,1.68865),(-.11927,57.19701,2.0112),(-.1249,57.20709,2.03742),(-.17224,56.9088,1.63127),(-.09551,57.04324,1.77237),(-.11054,56.94368,1.68903),(-.15452,56.91903,1.63291),(-.19279,56.96923,1.57237),(-.19667,56.96281,1.57114),(-.13494,57.252,1.92574),(-.13964,56.92365,1.61902),(-.24482,56.77848,1.52577),(-.15635,56.9533,1.59186),(-.10933,56.94949,1.68836),(0,56.65,2.0996),(-.07633,57.2998,1.84828),(-.05767,57.23924,1.66019),(-.00015,57.34559,2.56703),(0,57.49354,2.53174),(-.00026,57.28433,2.56206),(-.01324,56.66613,2.18981),(-.01714,56.67663,2.18306),(0,56.67837,2.29489),(0,57.66686,2.10881),(-.03101,57.03284,2.3015),(-.0278,57.00584,2.26783),(-.02965,56.95762,2.09962),(-.03519,57.11595,1.98568),(-.02837,56.93986,2.03273),(-.03802,57.136,2.03515),(0,57.01782,2.4949),(0,56.70785,2.39591),(0,56.72064,2.42226),(-.03331,57.07002,2.32709),(-.09068,57.34882,2.01631),(-.03826,57.15956,2.08684),(-.02128,56.90106,1.9247),(-.02562,56.91932,1.97458),(-.03424,56.73702,2.17196),(-.02995,56.70754,2.23652),(-.00013,57.35539,2.5678),(-.09264,57.07752,1.85629),(-.09043,57.10063,1.90679),(-.08378,57.00874,1.87304),(-.10949,56.98034,1.68115),(-.12401,56.94587,1.63594),(-.10219,56.95333,1.73517),(-.10619,56.94802,1.70687),(-.08469,57.00308,1.87415),(-.12153,57.07762,1.75504),(-.11855,57.17444,1.95042),(-.23139,56.97032,1.69769),(-.24003,56.96722,1.6828),(-.20933,56.95735,1.6843),(-.10537,57.29974,1.84836),(-.09821,57.15552,1.89036),(-.11933,57.29262,1.9393),(-.12543,57.2533,1.9278),(-.12698,57.18432,1.71939),(-.09499,57.05946,2.27192),(-.10229,56.86177,1.90859),(-.13665,56.91367,1.89061),(-.11397,56.93305,1.74438),(-.09638,56.97861,1.87771),(-.08667,56.82982,2.18779),(-.10282,56.7557,2.20886),(-.08732,56.84085,2.24088),(-.0814,56.86516,2.29578),(-.07675,56.94396,2.27035),(-.10008,57.1463,1.83945),(-.10482,57.30501,1.79893),(0,57.74616,2.16395),(0,57.74635,2.12249),(-.11224,57.18037,2.23421),(-.08032,57.29204,1.93739),(-.27706,56.85493,1.59921),(-.27563,56.85439,1.59699),(-.27193,56.8545,1.59249),(-.27324,56.85354,1.59337),(-.22637,56.88439,1.58225),(-.22081,56.89745,1.57869),(-.26226,56.93161,1.66819),(-.26321,56.93046,1.66431),(-.26653,56.9358,1.67097),(-.26434,56.9446,1.66618),(-.26313,56.94475,1.66506),(-.17911,56.79243,1.59655),(-.14839,56.81305,1.6396),(-.20084,56.91192,1.61973),(-.31111,56.89427,1.63745),(-.33995,56.87712,1.64132),(-.30963,56.89153,1.63557),(-.34088,56.8789,1.64246),(-.339,56.87421,1.64425),(-.30925,56.88961,1.64256),(-.30813,56.88777,1.63977),(-.3397,56.87531,1.64602),(-.31221,56.89605,1.64029),(-.34156,56.87995,1.64426),(-.29802,56.89851,1.6344),(-.29701,56.89435,1.63186),(-.29273,56.89272,1.64118),(-.29273,56.8897,1.63735),(-.27509,56.94162,1.67641),(-.26703,56.94531,1.66733),(-.27008,56.9541,1.66871),(-.28068,56.95786,1.6738),(-.28346,56.9598,1.67725),(-.27421,56.96037,1.67872),(-.27985,56.96211,1.68089),(-.29537,56.90045,1.64412),(-.29374,56.89681,1.64378),(-.20807,56.92966,1.70336),(-.22162,56.9372,1.71191),(-.19751,56.92881,1.69623),(-.22853,56.93151,1.63341),(-.23361,56.96695,1.71609),(-.22076,56.95558,1.71733),(-.23736,56.95958,1.71998),(-.21945,56.95797,1.71602),(-.19473,56.7588,1.5707),(-.26626,56.81563,1.56271),(-.27305,56.81533,1.56011),(-.39354,56.83367,1.6521),(-.39336,56.83326,1.65216),(-.39867,56.83521,1.65713),(-.38524,56.85063,1.64559),(-.33878,56.8742,1.64245),(-.33914,56.8753,1.64132),(-.38467,56.84962,1.64667),(-.40604,56.84359,1.66533),(-.39685,56.84008,1.65302),(-.39275,56.83453,1.65163),(-.39565,56.83597,1.64868),(-.39458,56.8368,1.64855),(-.3988,56.83667,1.65166),(-.39858,56.83877,1.64867),(-.39726,56.83592,1.64987),(-.38466,56.85265,1.6506),(-.38523,56.85437,1.65046),(-.38581,56.85237,1.64544),(-.38616,56.85416,1.64627),(-.39793,56.84326,1.64511),(-.3166,56.77918,1.58213),(-.31677,56.77879,1.58176),(-.31376,56.77531,1.5771),(-.3129,56.77524,1.57806),(-.31595,56.77486,1.57832),(-.31411,56.77847,1.57838),(-.31564,56.77889,1.57949),(-.31823,56.77815,1.58277),(-.31448,56.77875,1.57752),(-.31264,56.77662,1.57684),(-.31283,56.77603,1.57675),(-.31903,56.7767,1.58089),(-.31794,56.77543,1.57977),(-.3134,56.79068,1.53121),(-.30588,56.79792,1.54097),(-.30638,56.80086,1.52737),(-.30065,56.79066,1.53352),(-.30211,56.8033,1.52832),(-.30502,56.78992,1.53192),(-.30361,56.80944,1.52885),(-.30848,56.80844,1.52816),(-.31696,56.8057,1.52944),(-.29853,56.81637,1.54941),(-.30105,56.80971,1.53819),(-.20554,56.87781,1.57053),(-.19726,56.88743,1.55024),(-.20108,56.87176,1.55255),(-.20158,56.89167,1.56779),(-.28912,56.83252,1.56299),(-.28454,56.8718,1.5965),(-.30979,56.8288,1.57559),(-.26966,56.88739,1.55302),(-.27376,56.85914,1.54758),(-.17984,57.17958,2.13001),(-.21465,57.16857,2.09264),(-.17721,57.17615,2.11627),(-.1811,57.17239,2.1025),(-.19693,57.12973,2.07894),(-.20283,57.16803,2.08897),(-.22555,57.12658,2.07145),(-.19044,57.16944,2.09265),(-.19406,57.15836,2.19659),(-.17471,57.15208,2.16261),(-.25247,57.128,2.08326),(-.26962,57.13429,2.1172),(-.25212,56.99298,2.27845),(-.28581,57.02898,2.24521),(-.27401,57.03598,2.30949),(-.26038,56.98773,2.23744),(-.22101,56.95023,2.22333),(-.23904,56.96236,2.25724),(-.28105,57.12321,2.25916),(-.26026,57.10573,2.31723),(-.28686,57.09699,2.29151),(-.25699,57.13092,2.28335),(-.21833,57.05059,2.30887),(-.23588,56.99869,2.29389),(-.25098,57.04417,2.33188),(-.2139,57.00292,2.28071),(-.20497,56.95159,2.21948),(-.19395,56.96814,2.24026),(-.22189,57.11039,2.2938),(-.18739,57.12864,2.224),(-.18177,57.10586,2.24226),(-.22184,57.1334,2.266),(-.15554,57.04018,2.20433),(-.19031,57.00212,2.24819),(-.1818,57.04903,2.25803),(-.17329,56.99588,2.21039),(-.20022,56.9479,2.19991),(-.18225,56.9637,2.21347),(-.1787,56.95798,2.18618),(-.20116,56.94997,2.21),(-.15388,57.09646,2.18876),(-.15332,57.11082,2.13751),(-.14376,57.08563,2.14298),(-.16238,57.12045,2.17803),(-.15676,57.01923,2.11695),(-.1672,56.98816,2.17454),(-.14624,57.02987,2.15734),(-.17455,56.9806,2.14474),(-.19824,56.94826,2.15089),(-.20239,56.94591,2.1917),(-.18435,56.95238,2.16371),(-.20708,56.94451,2.18743),(-.1549,57.07452,2.10189),(-.18954,57.09294,2.07441),(-.18438,57.06558,2.0721),(-.16324,57.10091,2.10095),(-.22179,57.00683,2.0851),(-.19364,56.97499,2.12683),(-.18443,57.01063,2.08976),(-.21936,56.97294,2.12661),(-.21846,56.9448,2.19427),(-.21636,56.94683,2.15168),(-.23283,56.94869,2.1676),(-.213,56.9441,2.18828),(-.22509,57.08918,2.06604),(-.26366,57.06396,2.08453),(-.22422,57.06143,2.06329),(-.26027,57.09125,2.08338),(-.25801,56.98176,2.18692),(-.25871,57.00981,2.11024),(-.28256,57.01962,2.16665),(-.24352,56.97536,2.14727),(-.22306,56.94839,2.21464),(-.24303,56.95334,2.19574),(-.24506,56.95806,2.22947),(-.22211,56.94643,2.20394),(-.28385,57.09954,2.12998),(-.29859,57.08694,2.22122),(-.29172,57.07358,2.13959),(-.29031,57.11231,2.19855),(-.23628,57.09766,1.61161),(-.23539,57.11416,1.61575),(-.22194,57.05709,1.52237),(-.21911,57.04694,1.51836),(-.22717,57.08512,1.54253),(-.23704,57.07543,1.52951),(-.22053,57.0747,1.53406),(-.23657,57.08865,1.54391),(-.22188,57.11943,1.59997),(-.24773,57.11826,1.58106),(-.24553,57.12085,1.58571),(-.24177,57.12097,1.5871),(-.23744,57.06958,1.60026),(-.23379,57.1144,1.57957),(-.2374,57.11866,1.58499),(-.2279,57.03044,1.51225),(-.24903,57.01064,1.5127),(-.25971,56.97243,1.5356),(-.23431,57.10287,1.56081),(-.23802,57.1028,1.55951),(-.27796,56.97912,1.5457),(-.26845,57.01688,1.52333),(-.24504,57.09035,1.5456),(-.24224,57.10503,1.56188),(-.2777,57.04877,1.53968),(-.26213,57.03724,1.51677),(-.28505,57.02853,1.54769),(-.29361,56.98955,1.56862),(-.24583,57.10908,1.5673),(-.25329,57.10101,1.55992),(-.24784,57.11392,1.57432),(-.24362,56.95637,1.52671),(-.23923,56.9656,1.52341),(-.20043,56.94347,1.53006),(-.19491,56.94207,1.54257),(-.19945,56.9659,1.52783),(-.22647,56.95044,1.55828),(-.2221,56.96614,1.55384),(-.23352,56.92904,1.56807),(-.21369,56.92237,1.5713),(-.26459,56.8248,1.57603),(-.19952,56.91797,1.5279),(-.19137,56.91513,1.54571),(-.20786,56.88662,1.53009),(-.21818,56.92421,1.51447),(-.22837,56.89166,1.51369),(-.24879,56.93242,1.51357),(-.26012,56.90291,1.51096),(-.26672,56.93754,1.52357),(-.27803,56.91046,1.52152),(-.3406,56.87704,1.6471),(-.34138,56.87877,1.6471),(-.28182,56.9681,1.68167),(-.34332,57.06026,1.69927),(-.24451,57.17652,1.64125),(-.20257,57.16934,1.64901),(-.18517,57.04548,1.69051),(-.17738,57.07701,1.6842),(-.31494,56.8782,1.8725),(-.31638,56.86999,1.87023),(-.31615,56.86953,1.87357),(-.31508,56.87757,1.87846),(-.31478,56.87811,1.87511),(-.31672,56.8691,1.87729),(-.31195,56.89969,1.81212),(-.2753,56.9845,1.82511),(-.28498,56.98415,1.81556),(-.27189,56.99214,1.82314),(-.27678,56.99353,1.825),(-.2656,57.01014,1.81714),(-.28236,56.99213,1.81408),(-.27172,57.00854,1.80515),(-.2741,57.01031,1.80996),(-.27949,56.99026,1.80814),(-.26116,57.00594,1.80384),(-.26575,56.98876,1.81237),(-.26067,57.00696,1.80857),(-.26639,56.98768,1.80645),(-.26858,57.00687,1.80121),(-.2762,57.02193,1.81671),(-.27447,57.0116,1.81454),(-.24984,57.02062,1.80569),(-.26219,57.00844,1.81337),(-.25264,57.02327,1.81415),(-.2617,56.93413,1.84587),(-.28415,56.94551,1.76764),(-.26837,56.94122,1.77309),(-.2569,56.94296,1.8367),(-.25633,56.94352,1.79649),(-.25612,56.94988,1.83151),(-.27567,56.98853,1.8033),(-.2808,56.99405,1.82372),(-.26973,56.9814,1.80842),(-.31934,56.86065,1.87422),(-.31313,56.85976,1.86832),(-.31983,56.86101,1.87117),(-.32388,56.85952,1.89344),(-.33088,56.86251,1.87697),(-.32672,56.86148,1.88101),(-.33306,56.86206,1.8867),(-.32583,56.86169,1.87732),(-.31976,56.86044,1.87773),(-.32402,56.86179,1.87322),(-.32042,56.86973,1.87226),(-.30951,56.88721,1.86887),(-.27946,56.90507,1.82411),(-.26373,57.20096,1.67923),(-.20221,57.18078,1.68504),(-.15113,57.25052,1.76716),(-.1491,57.23937,1.7363),(-.14256,57.23115,1.74183),(-.15644,57.25598,1.75668),(-.26739,57.28363,1.77213),(-.28339,57.27537,1.74154),(-.29287,57.27408,1.75045),(-.20005,57.25405,1.73339),(-.1995,57.24167,1.71979),(-.19759,57.24792,1.72676),(-.20528,57.237,1.71437),(-.20624,57.25854,1.73792),(-.2278,57.2424,1.71776),(-.22834,57.25499,1.73135),(-.23026,57.2489,1.7244),(-.31892,57.20382,1.74919),(-.33057,57.19263,1.80475),(-.34136,57.17275,1.76543),(-.31002,57.22455,1.78127),(-.28056,57.05522,1.84703),(-.29355,57.20231,1.83413),(-.27921,57.23321,1.80541),(-.26147,57.09086,1.868),(-.26513,57.05911,1.85086),(-.22507,57.19108,1.85127),(-.21863,57.2211,1.82096),(-.21803,57.1195,1.85907),(-.24149,57.16114,1.86516),(-.19759,57.15156,1.8542),(-.25599,57.1268,1.87075),(-.17585,57.26816,1.77096),(-.19082,57.10515,1.83288),(-.16797,57.13605,1.82936),(-.16348,57.11948,1.79686),(-.18677,57.08991,1.80023),(-.21926,57.04004,1.8025),(-.19789,57.06026,1.8012),(-.22281,57.03172,1.77886),(-.23149,57.02445,1.76331),(-.17343,57.20458,1.69647),(-.27472,57.15216,1.69897),(-.3273,57.14513,1.72759),(-.30742,57.17719,1.71802),(-.33265,56.86157,1.89404),(-.3295,56.86055,1.89701),(-.34757,56.80098,2.02714),(-.34759,56.80127,2.02738),(-.35044,56.80161,2.02735),(-.35036,56.8019,2.02765),(-.42472,56.9195,1.83949),(-.42573,56.91903,1.83926),(-.42756,56.919,1.84072),(-.42707,56.91908,1.84016),(-.42733,56.92406,1.84138),(-.42691,56.92471,1.84279),(-.42777,56.92226,1.84183),(-.38642,57.04385,1.79813),(-.37361,57.04318,1.80306),(-.37696,57.0463,1.8008),(-.37703,57.04789,1.81541),(-.37726,57.05153,1.81133),(-.36809,57.03946,1.82159),(-.36497,57.03998,1.81973),(-.369,57.05303,1.80677),(-.36564,57.04991,1.80899),(-.345,57.14928,1.83845),(-.33161,57.10465,1.91957),(-.32015,57.06613,1.90224),(-.33798,57.06307,1.91215),(-.31732,57.10435,1.91063),(-.38196,57.13037,1.84489),(-.37102,57.13592,1.87813),(-.38238,57.10986,1.86783),(-.37999,57.07167,1.81533),(-.37573,57.05397,1.80805),(-.37534,57.07864,1.80577),(-.34345,57.19695,1.87918),(-.35326,57.18879,1.84973),(-.34055,57.19808,1.8666),(-.35843,57.1873,1.86921),(-.38514,57.09051,1.85205),(-.38344,57.0893,1.81907),(-.3864,57.11019,1.82923),(-.38235,57.0732,1.83769),(-.34086,57.19327,1.89493),(-.35487,57.18175,1.89339),(-.37623,57.07019,1.87432),(-.37637,57.05709,1.85614),(-.34401,57.17392,1.91608),(-.33444,57.18846,1.90996),(-.3633,57.05517,1.89028),(-.36563,57.04479,1.86849),(-.32742,57.18425,1.92055),(-.33359,57.16758,1.9324),(-.34911,57.03818,1.86948),(-.34307,57.04703,1.89256),(-.31893,57.18065,1.92304),(-.31812,57.16114,1.93555),(-.33536,57.04049,1.86079),(-.32625,57.04986,1.88238),(-.31147,57.17877,1.91685),(-.30617,57.15816,1.92599),(-.32808,57.05108,1.84586),(-.31733,57.06285,1.86399),(-.3084,57.17974,1.9041),(-.30116,57.15964,1.90644),(-.32022,57.08208,1.84465),(-.31069,57.18334,1.88825),(-.33885,57.10114,1.83293),(-.3494,57.13927,1.83472),(-.37272,57.05453,1.80641),(-.3342,57.19678,1.86084),(-.32594,57.19331,1.86339),(-.37934,57.12285,1.81319),(-.37786,57.10005,1.8055),(-.2477,57.15599,1.91453),(-.24808,57.15321,1.91779),(-.24356,57.1579,1.91737),(-.24278,57.16491,1.92543),(-.24267,57.16302,1.92637),(-.25406,57.15672,1.91287),(-.24782,57.15788,1.91358),(-.25394,57.15483,1.91382),(-.16245,57.2417,1.86165),(-.16337,57.27097,1.84782),(-.24673,57.33736,1.85143),(-.2598,57.33172,1.86756),(-.26446,57.32545,1.85331),(-.24511,57.33954,1.85639),(-.20245,57.30397,1.92547),(-.20493,57.27359,1.93839),(-.17192,57.27442,1.9336),(-.22928,57.34059,1.85821),(-.23233,57.34187,1.86124),(-.17216,57.30448,1.92196),(-.16498,57.28572,1.87956),(-.16455,57.25524,1.89135),(-.23008,57.33631,1.84833),(-.22845,57.33857,1.85353),(-.24988,57.19619,1.8489),(-.23839,57.33357,1.84229),(-.23371,57.33447,1.8442),(-.24285,57.33384,1.84309),(-.25371,57.31143,1.81967),(-.26483,57.15805,1.91743),(-.34621,56.821,2.03204),(-.34415,56.82064,2.03522),(-.33536,56.81167,2.0323),(-.31159,56.8875,2.00574),(-.30962,56.88754,2.00859),(-.29812,56.88032,2.00344),(-.2995,56.87945,1.99857),(-.30202,56.87977,1.99586),(-.31209,56.88598,2.00071),(-.30631,56.88641,2.00999),(-.3103,57.00725,1.86484),(-.30753,56.99136,1.87566),(-.29786,56.99917,1.86483),(-.31244,56.997,1.87403),(-.31345,57.00274,1.87008),(-.27705,57.1005,2.04721),(-.31984,57.11039,2.03644),(-.33085,57.04248,2.01712),(-.19175,57.04782,1.94933),(-.26462,57.21953,1.97921),(-.25548,57.21985,1.98071),(-.35909,57.06876,1.99211),(-.36272,57.04047,1.97002),(-.33735,57.00306,1.90357),(-.35481,57.01859,1.93722),(-.32332,56.98298,1.90984),(-.27291,57.21293,1.98709),(-.22209,57.00562,1.88536),(-.20034,57.02085,1.91929),(-.25218,57.2038,1.96676),(-.30381,57.00956,1.85964),(-.28935,57.03621,1.85302),(-.31264,57.03897,1.86315),(-.2957,57.00913,1.85582),(-.33127,57.03305,1.87697),(-.42795,56.91924,1.84471),(-.25708,56.86183,2.4634),(-.16248,57.12922,2.63249),(-.13983,57.22642,2.64545),(-.38487,56.75229,1.6929),(-.29751,56.61199,1.47301),(-.3103,56.64716,1.52292),(-.31496,56.68704,1.57359),(-.21178,57.42705,2.02016),(-.19861,57.38057,1.94649),(-.11364,56.62246,2.05975),(-.17255,56.59102,1.58625),(-.17492,56.58878,1.58718),(-.19663,56.57564,1.53876),(-.1979,56.5745,1.52464),(-.19428,56.57755,1.53761),(-.31174,56.64079,1.50949),(-.31208,56.64344,1.50784),(-.37409,56.74148,1.65691),(-.36738,56.73801,1.64733),(-.40052,56.81229,2.04748),(-.26845,56.85572,2.45843),(-.31396,56.64906,1.52088),(-.30858,56.639,1.51114),(-.1997,56.60918,1.50488),(-.27954,56.63507,1.45829),(-.26222,56.64048,1.45592),(-.21861,56.56933,1.47347),(-.22434,56.568,1.46202),(-.30623,57.15018,2.48459),(-.10781,57.62162,2.36084),(-.1449,56.73178,1.73385),(-.19025,56.73107,2.05075),(-.25508,57.25191,2.46555),(-.2516,57.23915,2.47534),(-.27358,57.21755,2.44685),(-.25603,57.24978,2.42389),(-.24478,57.22984,2.45863),(-.19869,57.267,2.55537),(-.20353,57.25851,2.54932),(-.19972,57.26765,2.55157),(-.20005,57.26829,2.53731),(-.1972,57.27672,2.54742),(-.30397,57.14401,2.48341),(-.30683,57.14749,2.48579),(-.12934,56.81774,2.36551),(-.21966,56.90644,2.36803),(-.21296,56.63075,1.48062),(-.26412,56.66335,1.47277),(-.22045,56.60932,1.45964),(-.37872,56.79315,2.16111),(-.26757,56.85987,2.46249),(-.36347,56.73729,1.65862),(-.38824,56.75351,1.69163),(-.34518,57.36493,2.00184),(-.2081,57.23396,2.2834),(-.23539,57.22873,2.45135),(-.24583,57.24181,2.45179),(-.18905,57.3502,2.2918),(-.18613,57.35531,2.28286),(-.21018,57.33147,2.29593),(-.2178,57.32942,2.28391),(-.19062,57.35964,2.26393),(-.19442,57.3438,2.29841),(-.22142,57.33245,2.26923),(-.20219,57.38299,2.27936),(-.26137,57.45982,2.18089),(-.27731,57.44078,2.15893),(-.20727,57.45371,2.19102),(-.288,57.42715,2.27989),(-.2147,57.39826,2.18608),(-.23455,57.45975,2.18745),(-.3587,56.9352,2.2468),(-.34721,56.97774,1.6933),(-.35514,56.98906,1.68557),(-.34277,56.98804,1.68787),(-.33605,56.97469,1.67594),(-.33275,56.98114,1.68298),(-.3632,56.97693,1.6714),(-.3579,56.98938,1.67037),(-.35025,56.99626,1.67395),(-.36118,56.98417,1.67898),(-.33324,56.98529,1.68705),(-.32705,56.99163,1.67455),(-.35126,56.98911,1.65441),(-.34268,56.99607,1.65752),(-.32238,56.9905,1.66792),(-.34625,56.98325,1.6438),(-.33515,56.98779,1.64368),(-.32272,56.9854,1.64876),(-.34099,56.95431,1.66314),(-.32815,56.9385,1.60275),(-.30799,56.94366,1.59382),(-.38764,56.91543,1.66619),(-.36094,56.90742,1.65629),(-.36333,56.89932,1.6642),(-.3977,56.9196,1.69253),(-.40686,56.94093,1.71778),(-.38305,57.03587,1.79109),(-.39892,56.94167,1.73738),(-.39953,56.93115,1.72433),(-.38013,56.94922,1.78032),(-.39995,56.96164,1.7753),(-.38041,56.93155,1.74033),(-.34336,56.94711,1.76748),(-.33042,56.96389,1.80338),(-.32821,56.93716,1.71465),(-.35294,56.93014,1.73124),(-.31531,57.04073,1.82044),(-.29271,57.02638,1.81335),(-.27169,57.02192,1.76866),(-.28811,57.04145,1.75759),(-.36418,56.95165,1.69141),(-.34149,56.94886,1.68462),(-.31777,57.05926,1.75573),(-.36128,56.97036,1.69853),(-.22418,57.18023,1.93206),(-.2212,57.17385,1.9171),(-.22337,57.14488,2.04527),(-.24669,57.20932,1.98152),(-.24558,57.2142,1.99369),(-.36286,57.04472,1.80559),(-.38016,57.00393,1.72502),(-.35614,57.00909,1.71593),(-.33525,56.96653,1.69096),(-.31122,56.95598,1.68337),(-.27311,57.00422,1.78838),(-.29192,56.98995,1.8121),(-.36573,56.90299,1.68955),(-.38086,56.92189,1.72612),(-.35845,56.9208,1.71887),(-.38043,56.9034,1.69319),(-.39252,56.91059,1.69396),(-.39069,56.90859,1.67333),(-.31376,56.97998,1.65496),(-.32421,56.99385,1.66668),(-.32926,56.99437,1.67546),(-.36164,56.97977,1.66644),(-.33537,56.98705,1.6884),(-.1568,56.66788,1.84527),(-.10463,56.71478,2.21709),(-.19742,57.26957,2.53408),(-.18018,57.42551,2.09518),(-.18001,57.4197,2.09395),(-.21814,57.34085,2.25803),(-.20225,57.33726,2.29921),(-.18668,57.35853,2.27299),(-.25628,57.26023,2.44974),(-.24713,57.25485,2.43968),(-.28911,57.18441,2.46852),(-.27212,57.43019,1.93877),(-.20074,56.57655,1.54026),(-.20516,56.78785,2.08251),(-.21732,56.71075,2.20218),(-.21517,56.69866,2.17927),(-.1278,56.86677,2.39377),(-.27895,56.66908,1.48156),(-.10328,56.7078,2.15931),(-.10102,56.7424,2.0827),(-.10348,56.74971,2.1505),(-.25871,57.26448,2.45492),(-.24001,57.5503,2.3285),(-.36148,56.8281,1.92794),(-.35715,56.73405,1.64961),(-.31818,56.68863,1.5722),(-.11657,56.61869,1.99184),(-.16061,57.13396,2.63524),(-.42778,56.91843,1.84047),(-.42828,56.91878,1.84313),(-.3403,57.01999,1.89164),(-.31724,57.07397,1.87583),(-.28817,57.00622,1.85439),(-.26764,57.02656,1.84922),(-.25339,57.01296,1.85329),(-.25049,56.9975,1.86457),(-.25981,56.98056,1.88076),(-.20837,57.02651,1.98258),(-.29195,56.98775,1.87056),(-.30004,56.98781,1.87444),(-.28542,56.99087,1.86512),(-.19718,57.09443,2.00645),(-.23174,57.09449,2.03483),(-.3369,56.81063,2.02713),(-.34687,56.81905,2.02649),(-.33912,56.81129,2.02435),(-.2628,57.31792,1.83555),(-.26038,57.15678,1.91431),(-.24367,57.15979,1.91642),(-.24932,57.33668,1.87851),(-.24225,57.16203,1.92022),(-.24214,57.16014,1.92116),(-.36219,57.14619,1.82609),(-.29997,57.13613,1.90476),(-.34166,57.04598,1.83126),(-.30536,57.1344,1.92924),(-.34643,57.03906,1.84092),(-.32046,57.13807,1.94104),(-.35542,57.03756,1.84657),(-.34041,57.14623,1.93735),(-.3662,57.04186,1.84618),(-.35494,57.15473,1.91782),(-.37445,57.05033,1.83898),(-.36628,57.16334,1.88945),(-.37861,57.06092,1.82731),(-.37233,57.14275,1.8289),(-.35947,57.07175,1.90846),(-.3496,57.11193,1.9163),(-.35774,57.1555,1.83117),(-.36356,57.04602,1.81249),(-.37183,57.04096,1.82141),(-.42808,56.91924,1.84303),(-.427,56.91861,1.8398),(-.35112,56.79883,2.04249),(-.35094,56.79923,2.04201),(-.32603,56.86269,1.86596),(-.29077,57.22611,1.69596),(-.30056,57.25279,1.72271),(-.17131,57.18886,1.69373),(-.21432,57.13915,1.70763),(-.25108,57.01789,1.79752),(-.22616,57.04852,1.8262),(-.18109,57.18294,1.84495),(-.24365,57.05611,1.84416),(-.25913,57.02537,1.82079),(-.30166,57.16873,1.85464),(-.34088,57.15737,1.82376),(-.35228,57.13723,1.78188),(-.27583,57.01868,1.80925),(-.34526,57.1006,1.79903),(-.2899,57.25794,1.71975),(-.17426,57.26386,1.78431),(-.31124,56.88603,1.88094),(-.2688,56.98719,1.80218),(-.27212,56.98091,1.80433),(-.33695,56.96221,1.98462),(-.28279,56.99354,1.81978),(-.26765,56.99034,1.81841),(-.24401,57.14002,1.62731),(-.29407,57.02583,1.72284),(-.2826,56.96213,1.68101),(-.38431,56.85087,1.64976),(-.23163,56.95226,1.51991),(-.21326,56.94688,1.52102),(-.19883,56.94306,1.55404),(-.19663,56.91686,1.56164),(-.21046,56.94636,1.56071),(-.23403,56.87189,1.58272),(-.21122,56.96506,1.51869),(-.26416,56.91036,1.59097),(-.24388,57.03118,1.50677),(-.20777,57.04465,1.61373),(-.2662,57.09242,1.55775),(-.21882,57.10423,1.57617),(-.25271,57.08281,1.53977),(-.34219,57.36004,2.00177),(-.27341,57.14405,2.16669),(-.17551,57.13623,2.10054),(-.16744,57.1443,2.13029),(-.26487,57.1539,2.21184),(-.31892,56.77802,1.58127),(-.2594,56.6732,1.48222),(-.31766,56.77886,1.58076),(-.3181,56.77795,1.58228),(-.386,56.82914,1.64496),(-.38616,56.8553,1.64778),(-.39445,56.83809,1.64951),(-.39532,56.83934,1.65122),(-.39587,56.83942,1.65569),(-.27598,56.82125,1.56297),(-.29802,56.90153,1.63829),(-.2328,56.94838,1.71838),(-.21916,56.95156,1.7168),(-.21058,56.94465,1.71171),(-.20556,56.94655,1.70789),(-.20687,56.9443,1.70914),(-.20716,56.9506,1.70841),(-.21528,56.94742,1.71464),(-.21105,56.95491,1.7105),(-.21575,56.95775,1.7134),(-.2612,56.93472,1.67264),(-.31194,56.89476,1.64452),(-.29701,56.90226,1.64201),(-.31252,56.89622,1.64298),(-.29374,56.88889,1.63371),(-.30777,56.88748,1.63704),(-.34175,56.87989,1.64603),(-.21367,56.82966,1.6516),(-.26356,56.93245,1.66276),(0,57.75577,2.20549),(-.10471,57.11991,2.25311),(-.12606,57.34884,2.01688),(-.11454,57.15243,1.88501),(-.1198,57.31433,1.96925),(-.11119,57.12729,1.83084),(-.08887,56.98245,1.78626),(-.02827,56.70095,2.17937),(-.03302,56.74434,2.23065),(-.02892,56.9703,2.1561),(-.08834,57.31438,1.96955),(-.03177,56.98331,2.21317),(0,57.71725,2.09642),(-.00006,57.17936,2.55295),(-.09652,56.96671,1.7586),(-.22297,56.96686,1.70843),(-.20931,56.95857,1.70004),(0,57.76556,2.24702),(-.30834,56.88891,1.63542),(-.3107,56.89226,1.64436),(-.29538,56.89066,1.63161),(-.28409,56.96118,1.67951),(-.26873,56.82302,1.57422),(-.27188,56.82323,1.57353),(-.2735,56.82568,1.57468),(-.38431,56.84971,1.64826),(-.3858,56.85538,1.64938),(-.3143,56.79725,1.52834),(-.3063,56.8218,1.53384),(-.29983,56.87892,1.55318),(-.23752,57.04735,1.51116),(-.23454,57.05727,1.51798),(-.22106,57.09131,1.55488),(-.22795,56.96491,1.51718),(-.21239,56.86807,1.53188),(-.29348,57.18229,1.65274),(-.24754,57.15987,1.62978),(-.25258,57.1709,1.63308),(-.27218,56.98747,1.801),(-.27534,56.98101,1.80324),(-.31427,56.85912,1.87802),(-.28179,57.23671,1.69868),(-.15562,57.22102,1.71457),(-.15016,57.2085,1.7148),(-.20634,57.26992,1.78896),(-.30169,57.13061,1.86578),(-.33495,57.11894,1.83729),(-.22978,57.08684,1.86033),(-.18256,57.21427,1.81584),(-.20639,57.07492,1.83613),(-.33731,57.11357,1.74188),(-.38068,57.04779,1.80041),(-.37509,57.04404,1.81914),(-.36331,57.04239,1.8164),(-.31124,57.08076,1.8827),(-.3105,57.11111,1.8919),(-.36376,57.12328,1.90104),(-.37405,57.0881,1.89159),(-.31949,57.19321,1.90261),(-.31932,57.1948,1.89269),(-.31861,57.1936,1.89823),(-.3216,57.19367,1.90462),(-.32147,57.19649,1.88749),(-.32433,57.19482,1.90369),(-.32446,57.1982,1.884),(-.32703,57.1964,1.90011),(-.3274,57.19943,1.88313),(-.32912,57.19803,1.89486),(-.32943,57.19982,1.88509),(-.33003,57.19929,1.88937),(-.31768,57.18852,1.8735),(-.25475,57.15242,1.91667),(-.2459,57.33526,1.84651),(-.24147,57.34126,1.86019),(-.2368,57.34211,1.86197),(-.34141,56.81883,2.03647),(-.26131,57.2211,1.98415),(-.28171,57.06967,1.86342),(-.259,56.88842,2.49117),(-.25059,57.43465,1.95839),(-.1946,57.42652,2.06339),(-.11467,56.6202,2.03242),(-.31425,56.65123,1.5187),(-.19478,56.74717,2.06725),(-.25245,57.24721,2.46014),(-.19452,57.28118,2.5489),(-.27674,57.31263,2.38653),(-.19422,57.42132,2.06278),(-.33709,56.99583,1.67528),(-.33111,56.99547,1.66338),(-.3153,56.98308,1.65203),(-.37499,56.90875,1.6589),(-.37807,56.90029,1.66737),(-.28323,57.0016,1.85577),(-.28222,56.99605,1.85968),(-.23211,57.10525,1.56543),(-.23196,57.1094,1.57224)]))),
        Shape(DEF='ethmoid2',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='ethmoid2_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,3,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,30,28,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,14,50,-1,51,52,53,-1,54,55,52,-1,54,56,57,-1,55,58,59,-1,60,61,62,-1,63,64,47,-1,65,66,12,-1,67,12,66,-1,37,68,69,-1,70,71,12,-1,47,72,73,-1,74,75,76,-1,77,78,79,-1,51,80,56,-1,81,82,76,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,50,93,-1,33,32,94,-1,95,12,71,-1,37,96,38,-1,56,97,40,-1,98,99,45,-1,100,101,102,-1,103,104,100,-1,102,101,105,-1,104,106,100,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,116,117,109,-1,118,119,120,-1,121,122,123,-1,113,124,125,-1,126,127,128,-1,129,109,126,-1,130,131,132,-1,133,102,134,-1,135,136,137,-1,138,134,137,-1,139,140,141,-1,142,143,144,-1,145,146,147,-1,141,148,143,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,158,164,165,-1,166,167,168,-1,122,106,104,-1,169,170,171,-1,172,173,174,-1,175,176,177,-1,178,179,104,-1,180,181,182,-1,183,160,172,-1,165,184,159,-1,185,160,159,-1,186,163,187,-1,188,179,189,-1,182,190,191,-1,123,192,121,-1,193,194,195,-1,196,197,198,-1,199,164,158,-1,200,201,182,-1,202,203,204,-1,205,206,207,-1,208,157,209,-1,210,211,212,-1,213,214,215,-1,216,217,218,-1,219,181,220,-1,221,222,223,-1,224,225,226,-1,227,228,229,-1,230,231,232,-1,233,139,234,-1,235,236,140,-1,204,237,238,-1,239,240,211,-1,241,208,209,-1,208,200,154,-1,242,228,227,-1,243,244,245,-1,246,223,222,-1,230,247,146,-1,248,249,250,-1,251,249,252,-1,161,253,162,-1,254,255,256,-1,257,258,259,-1,260,261,259,-1,262,263,264,-1,0,265,5,-1,265,0,2,-1,9,266,3,-1,267,4,268,-1,269,264,270,-1,271,272,273,-1,274,275,276,-1,277,278,279,-1,190,201,280,-1,281,282,21,-1,283,284,285,-1,286,283,285,-1,287,166,206,-1,288,289,290,-1,291,283,286,-1,28,292,29,-1,85,51,293,-1,294,295,296,-1,5,265,297,-1,298,299,300,-1,301,302,303,-1,304,305,306,-1,307,249,308,-1,309,310,311,-1,312,307,313,-1,302,314,315,-1,316,317,318,-1,319,320,321,-1,316,322,323,-1,324,325,326,-1,327,315,314,-1,328,329,330,-1,331,332,333,-1,334,335,310,-1,336,337,338,-1,336,338,339,-1,340,250,341,-1,342,343,344,-1,345,249,248,-1,340,341,346,-1,347,348,349,-1,350,351,352,-1,353,354,355,-1,356,357,358,-1,359,360,361,-1,362,363,364,-1,365,366,367,-1,368,369,370,-1,186,371,372,-1,227,373,374,-1,259,375,376,-1,377,378,363,-1,364,379,366,-1,367,380,381,-1,382,383,384,-1,368,385,361,-1,386,387,388,-1,389,390,391,-1,392,393,394,-1,395,396,397,-1,398,399,351,-1,400,401,257,-1,402,249,344,-1,403,404,405,-1,406,355,407,-1,408,133,138,-1,133,409,410,-1,411,412,413,-1,414,415,416,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,428,-1,429,430,431,-1,431,432,425,-1,429,425,433,-1,434,435,436,-1,437,438,439,-1,440,441,442,-1,443,444,445,-1,446,447,448,-1,449,450,451,-1,452,453,454,-1,450,446,455,-1,456,457,458,-1,458,459,460,-1,461,462,463,-1,136,464,137,-1,465,464,466,-1,467,468,469,-1,470,471,472,-1,473,474,475,-1,476,477,465,-1,136,132,466,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,487,488,489,-1,490,491,485,-1,492,482,493,-1,494,480,495,-1,496,490,497,-1,498,499,500,-1,501,502,503,-1,494,495,504,-1,496,497,505,-1,506,507,508,-1,509,508,510,-1,511,512,513,-1,514,515,516,-1,511,517,518,-1,519,520,521,-1,522,523,524,-1,525,526,527,-1,528,526,525,-1,529,530,531,-1,532,533,534,-1,535,416,415,-1,533,420,536,-1,537,538,539,-1,540,541,542,-1,543,539,544,-1,545,523,546,-1,546,522,547,-1,548,549,550,-1,551,552,553,-1,554,555,556,-1,557,558,559,-1,560,561,562,-1,563,561,564,-1,565,566,567,-1,568,554,569,-1,570,571,551,-1,572,573,574,-1,575,566,576,-1,577,578,579,-1,561,560,580,-1,581,582,583,-1,584,585,586,-1,587,588,589,-1,590,591,592,-1,593,594,595,-1,596,597,598,-1,599,600,601,-1,602,603,323,-1,604,605,606,-1,607,608,609,-1,589,610,611,-1,612,613,614,-1,615,616,617,-1,618,619,620,-1,621,617,622,-1,623,624,595,-1,625,626,627,-1,628,629,595,-1,630,631,632,-1,633,625,634,-1,635,630,632,-1,636,637,635,-1,638,639,640,-1,641,642,643,-1,644,645,646,-1,647,648,422,-1,649,650,651,-1,649,534,648,-1,337,652,653,-1,413,654,655,-1,656,657,658,-1,659,660,661,-1,662,663,664,-1,665,666,667,-1,665,668,669,-1,662,670,671,-1,672,673,674,-1,673,658,661,-1,675,676,677,-1,678,679,677,-1,680,681,682,-1,683,684,685,-1,686,687,688,-1,689,690,684,-1,691,692,693,-1,694,692,691,-1,695,696,697,-1,698,699,700,-1,701,702,676,-1,703,704,705,-1,706,707,699,-1,708,709,710,-1,709,711,710,-1,712,713,714,-1,715,716,717,-1,663,718,664,-1,718,719,720,-1,721,722,720,-1,723,724,725,-1,726,727,728,-1,685,729,721,-1,730,724,723,-1,731,732,733,-1,734,735,736,-1,737,738,739,-1,740,741,742,-1,743,744,745,-1,746,742,747,-1,748,749,750,-1,751,752,753,-1,754,755,756,-1,757,749,758,-1,759,760,761,-1,762,763,764,-1,765,766,767,-1,768,769,770,-1,735,771,772,-1,773,774,775,-1,770,776,777,-1,778,779,780,-1,781,778,782,-1,783,784,785,-1,786,787,788,-1,789,790,791,-1,792,793,794,-1,795,796,797,-1,798,799,800,-1,798,801,799,-1,802,803,804,-1,803,782,778,-1,805,806,780,-1,807,808,809,-1,810,811,812,-1,813,814,815,-1,816,817,818,-1,819,820,821,-1,822,823,824,-1,825,826,827,-1,828,829,830,-1,831,832,833,-1,834,835,836,-1,837,838,839,-1,840,841,842,-1,842,843,840,-1,844,845,846,-1,841,847,842,-1,848,849,850,-1,851,852,853,-1,854,855,856,-1,857,858,859,-1,860,861,862,-1,850,863,864,-1,865,866,851,-1,867,868,869,-1,870,856,862,-1,871,860,858,-1,872,873,874,-1,875,876,877,-1,878,879,880,-1,881,882,883,-1,884,885,861,-1,886,887,888,-1,882,889,890,-1,891,886,892,-1,893,894,895,-1,889,896,897,-1,898,899,900,-1,901,902,903,-1,904,905,906,-1,899,898,907,-1,908,909,910,-1,911,912,913,-1,914,915,916,-1,917,918,919,-1,920,921,922,-1,923,916,924,-1,925,924,926,-1,927,928,929,-1,930,931,932,-1,930,932,933,-1,934,933,935,-1,936,937,938,-1,939,940,941,-1,942,939,943,-1,944,945,946,-1,947,948,949,-1,950,918,951,-1,911,919,952,-1,821,953,954,-1,955,956,957,-1,958,953,959,-1,960,961,962,-1,963,964,965,-1,966,960,967,-1,968,969,970,-1,971,972,964,-1,973,974,967,-1,975,976,977,-1,978,979,980,-1,981,982,983,-1,981,984,985,-1,986,987,988,-1,989,990,991,-1,992,993,994,-1,995,996,997,-1,993,998,999,-1,997,980,1000,-1,1001,1002,999,-1,1003,1004,812,-1,1005,1006,1007,-1,1008,1009,1010,-1,1011,1012,1013,-1,1014,1015,1016,-1,1017,1018,1019,-1,1012,1020,1021,-1,1022,1023,1024,-1,1025,1026,1027,-1,1028,1029,1030,-1,1031,1032,1033,-1,1034,1035,1036,-1,1037,1038,1039,-1,1040,1041,1042,-1,1041,1043,1042,-1,1044,1045,1046,-1,1047,1005,1048,-1,1049,1050,1051,-1,1052,1053,1054,-1,1055,1056,1057,-1,1058,1059,1060,-1,1059,1058,1061,-1,1062,1063,1064,-1,1065,1066,1067,-1,1068,1069,1070,-1,1071,1072,1073,-1,1074,1075,1076,-1,1077,1078,449,-1,1079,1080,1081,-1,1082,1083,1084,-1,1085,1086,1087,-1,1088,1089,1090,-1,1091,1092,1093,-1,1094,1095,1096,-1,1097,1098,1099,-1,1100,1016,1101,-1,1102,1103,1104,-1,1105,1106,1107,-1,1108,1109,1110,-1,1032,1111,1112,-1,1113,1114,1115,-1,1116,1112,1111,-1,1111,1117,1116,-1,1029,1118,1119,-1,1120,1121,1122,-1,1123,1124,1125,-1,1126,1127,1128,-1,1129,1130,1131,-1,1132,1133,1134,-1,1135,1136,1137,-1,1066,1138,1139,-1,1140,1141,1142,-1,1143,1144,1145,-1,1145,1146,1143,-1,1147,1148,526,-1,1149,1150,1151,-1,1152,1153,1154,-1,1154,1155,1152,-1,1156,1157,1158,-1,1159,1160,1004,-1,1161,1162,1163,-1,1164,1165,1166,-1,1167,1168,1169,-1,1170,1171,1172,-1,1173,1174,1175,-1,1173,1176,1177,-1,1178,1179,1180,-1,1181,1182,1183,-1,1184,1169,1185,-1,1186,1187,1188,-1,1189,580,1190,-1,1191,1192,1193,-1,1194,1195,1196,-1,1196,1197,1198,-1,1194,1199,1200,-1,1201,1202,1203,-1,1204,1205,1206,-1,1206,1112,1207,-1,1208,1209,1210,-1,1211,1212,1099,-1,1213,1107,1212,-1,1108,1103,1109,-1,1214,1215,1216,-1,1217,1218,1219,-1,1220,1221,1222,-1,1223,1224,1225,-1,1226,1227,1228,-1,1229,1230,1231,-1,1232,1233,1234,-1,1235,1236,1233,-1,1237,1238,1239,-1,1195,1240,1196,-1,1234,1185,1241,-1,1242,833,1243,-1,1244,1245,809,-1,1246,1164,1247,-1,1244,1248,1249,-1,1250,1244,1251,-1,1252,1253,1216,-1,1254,1112,1255,-1,1256,1257,1082,-1,1078,1258,1259,-1,1042,1043,549,-1,1260,477,462,-1,1261,1062,1064,-1,1262,1263,1264,-1,1265,1266,1152,-1,1267,1268,1269,-1,1122,1270,1271,-1,1272,1273,1274,-1,1018,1275,1276,-1,1277,1278,1270,-1,1279,1065,1280,-1,1281,1282,1218,-1,1283,1284,1285,-1,1286,1287,1141,-1,1288,1289,1290,-1,1291,1292,1124,-1,1293,1294,1295,-1,1296,1297,1298,-1,1299,1298,1297,-1,1300,1301,1302,-1,1303,1304,1305,-1,1306,1299,1307,-1,1308,1309,1307,-1,1224,1310,1311,-1,1312,1313,1314,-1,1315,1316,1229,-1,1317,1318,1319,-1,1320,1317,1321,-1,1322,1323,1003,-1,1031,1033,1324,-1,1091,1325,1326,-1,1327,1328,1329,-1,1330,813,815,-1,1331,1332,1333,-1,1090,1333,1332,-1,1333,1089,1334,-1,1335,1336,1337,-1,1072,1037,1039,-1,1076,1338,1037,-1,1339,1340,1341,-1,1143,1342,1144,-1,1343,1344,1345,-1,1346,1347,1348,-1,1349,1350,1351,-1,1352,1353,1354,-1,1238,1171,1170,-1,1355,1356,1357,-1,1358,1359,1360,-1,1361,1362,1007,-1,1363,1364,1365,-1,1366,1367,1365,-1,1368,1369,1370,-1,1370,1371,1358,-1,1358,1368,1370,-1,1363,1372,1373,-1,1374,1375,1376,-1,1375,1377,1378,-1,1234,1233,1372,-1,1377,1240,1379,-1,1380,1365,1381,-1,1365,1364,1382,-1,1383,1384,1385,-1,577,1386,1387,-1,1388,1389,1390,-1,1391,1382,1392,-1,1393,1394,579,-1,1395,1396,1397,-1,1398,1399,1400,-1,1401,1402,1403,-1,1404,1397,1405,-1,1406,1407,1408,-1,1409,1410,1411,-1,1402,1412,1403,-1,1413,1414,1415,-1,1416,1417,1418,-1,1048,1419,1420,-1,1421,1422,1423,-1,1406,1424,1425,-1,1417,1425,1426,-1,1427,1428,1429,-1,1427,1430,1431,-1,1432,1433,1434,-1,1435,1436,1423,-1,1437,1054,1053,-1,1438,1439,1440,-1,1393,1441,1442,-1,1443,1024,1444,-1,1445,1446,1447,-1,1448,1449,1450,-1,1451,1452,294,-1,1054,1055,1052,-1,1058,1453,1061,-1,1454,1455,1456,-1,1344,1457,1458,-1,1418,1434,1459,-1,1460,1461,1462,-1,1463,1205,1204,-1,1205,1464,1220,-1,1253,1465,1466,-1,1467,1113,1115,-1,1437,1468,1242,-1,1469,1175,1174,-1,1304,1278,1470,-1,1471,1472,1473,-1,1227,1226,1474,-1,1447,1475,1476,-1,1265,1084,1035,-1,1262,1196,1477,-1,1477,1196,1478,-1,1479,1013,1480,-1,1013,1012,1021,-1,1276,1003,1018,-1,1093,1092,1481,-1,815,1160,762,-1,1482,1483,1484,-1,1043,550,549,-1,1485,1159,528,-1,1486,1487,1488,-1,1486,1489,1147,-1,1228,1490,1320,-1,1491,1492,1493,-1,1494,1495,1496,-1,1497,1498,1499,-1,1500,1501,1502,-1,1503,1504,1505,-1,1500,1506,1501,-1,1507,1508,1509,-1,1510,543,1511,-1,1512,1513,1514,-1,1514,1515,1512,-1,1516,1517,1518,-1,1519,1520,1521,-1,1522,1519,1523,-1,1524,1525,1526,-1,1527,1528,1529,-1,1530,1531,1525,-1,1532,1533,1534,-1,1535,1536,1537,-1,1538,1539,1540,-1,1541,1535,1542,-1,1543,1544,1541,-1,1545,1546,1547,-1,1548,1549,1550,-1,1551,1552,1545,-1,1553,1554,1555,-1,1556,1557,1558,-1,1559,1560,1561,-1,1562,1563,1564,-1,1565,1566,1562,-1,1562,1567,1565,-1,1568,1569,1570,-1,1571,582,1570,-1,1572,1573,1574,-1,1563,1575,1576,-1,583,1565,1047,-1,1577,1567,1562,-1,936,1578,1579,-1,1580,1581,1582,-1,1582,1583,1580,-1,1562,1580,925,-1,1584,1585,1586,-1,1575,1587,1576,-1,1588,1589,1590,-1,1579,1578,1591,-1,1592,1593,1594,-1,1595,983,1596,-1,1597,984,1598,-1,984,1599,1598,-1,1600,1601,1602,-1,1602,1601,1603,-1,1604,1603,986,-1,1604,947,1605,-1,1577,1606,559,-1,1607,1608,1609,-1,1577,1006,1047,-1,559,558,1577,-1,1603,1610,1611,-1,1612,1613,1614,-1,1615,1594,1593,-1,1562,1566,1581,-1,1566,1582,1581,-1,1562,1581,1580,-1,1575,1563,1562,-1,1616,1617,1618,-1,1609,1619,1620,-1,1047,1567,1577,-1,1621,1622,1617,-1,1621,1617,1623,-1,1624,1573,1625,-1,1619,1606,1577,-1,1574,1568,1570,-1,1577,1626,1619,-1,1627,1620,1628,-1,1626,1587,1629,-1,1571,1566,1565,-1,1630,1631,1559,-1,1561,1560,1632,-1,1633,1634,1635,-1,1636,1552,1551,-1,1637,1550,1638,-1,1639,1543,1640,-1,1544,1538,1540,-1,1537,1641,1542,-1,1642,1559,1643,-1,1644,1533,1532,-1,1528,1532,1534,-1,1531,1645,1646,-1,1527,1647,1648,-1,1529,1528,1534,-1,1525,1646,1649,-1,1650,1651,1652,-1,1523,1521,529,-1,1651,531,1653,-1,1521,1518,530,-1,1517,1512,1654,-1,1496,1655,1656,-1,1655,1509,1510,-1,1655,1496,1507,-1,1657,1658,1659,-1,1660,1508,1506,-1,1507,1496,1501,-1,1505,1661,1662,-1,1526,1663,1499,-1,1664,1533,1497,-1,1529,1665,1666,-1,1666,1667,1529,-1,1668,1669,1670,-1,1495,1671,1501,-1,1148,1672,1490,-1,1490,1672,1320,-1,1487,1159,1488,-1,1673,1159,1485,-1,1246,550,1483,-1,1674,1160,815,-1,1251,1675,1330,-1,1085,1087,1094,-1,1083,1035,1084,-1,1676,1322,1003,-1,1331,1677,1678,-1,1256,1679,1680,-1,1071,1073,1681,-1,1225,1309,1223,-1,1134,1682,1683,-1,1271,1270,1030,-1,1684,1685,1444,-1,1686,1352,1354,-1,1687,1175,1469,-1,1688,1468,1689,-1,1176,1689,1468,-1,1188,1690,1691,-1,1033,1692,1693,-1,1032,1112,1033,-1,1201,1463,1202,-1,1694,1695,1696,-1,1464,1697,1180,-1,1238,1698,1699,-1,1700,1701,1702,-1,1703,1345,1188,-1,1059,1704,1456,-1,1705,1706,272,-1,1456,1060,1059,-1,1451,294,1707,-1,1708,462,1452,-1,1060,1056,1709,-1,1710,1711,1377,-1,1255,1112,1116,-1,1128,1712,1301,-1,1252,1443,1444,-1,1294,1293,1121,-1,1713,1048,1420,-1,1010,1009,1714,-1,1715,1048,1007,-1,1421,1716,1717,-1,1718,1411,1423,-1,1429,1428,1719,-1,1430,1429,1720,-1,1426,1425,1721,-1,1426,1722,1418,-1,1436,1435,1723,-1,1449,1724,1438,-1,1419,1725,1726,-1,1393,1727,1383,-1,1434,1433,1414,-1,1728,1415,1720,-1,1404,1729,1721,-1,1730,1405,1397,-1,1731,1428,1427,-1,1719,1428,1731,-1,1399,1010,578,-1,1732,1397,1396,-1,1392,1733,1391,-1,574,1734,1735,-1,576,1388,1390,-1,1736,577,1387,-1,1385,1386,579,-1,1240,1711,1737,-1,1331,1738,1677,-1,1739,1740,1741,-1,1742,1743,1744,-1,1710,1374,1738,-1,1738,1737,1710,-1,1378,1742,1745,-1,1746,1741,1373,-1,1191,1190,580,-1,1747,1370,1369,-1,1748,1749,1750,-1,1378,1751,1742,-1,1369,1368,1380,-1,1353,1752,1753,-1,1754,1755,1756,-1,1756,1698,1754,-1,1371,1757,1758,-1,1185,1239,1170,-1,1061,1759,1760,-1,1061,1453,1761,-1,1762,1055,1057,-1,1346,1348,1763,-1,275,1764,1765,-1,1441,1714,1442,-1,1219,1282,1766,-1,1767,1768,1769,-1,1770,1771,1772,-1,1773,1036,1035,-1,1325,1085,1088,-1,1332,1331,1774,-1,1093,1481,811,-1,1332,1775,1090,-1,1322,1676,1776,-1,1676,1777,1776,-1,1318,1317,1672,-1,1778,1229,1228,-1,1312,1779,1780,-1,1777,1676,1472,-1,1781,1471,1312,-1,1307,1299,1782,-1,1783,1784,1272,-1,1782,1785,1786,-1,1785,1297,1296,-1,1787,1784,1472,-1,1301,1712,1788,-1,1783,1272,1274,-1,1789,1305,1790,-1,1304,1212,1278,-1,1791,1792,1681,-1,1683,1682,1793,-1,1794,1795,1796,-1,1282,1067,1139,-1,1139,1067,1066,-1,1119,1271,1030,-1,1797,1712,1798,-1,1270,1122,1293,-1,1799,1800,1801,-1,1799,1081,1800,-1,831,833,1688,-1,1154,1153,1802,-1,1157,1154,1687,-1,1803,1804,1158,-1,1682,1134,1805,-1,1223,1309,1806,-1,1807,1808,1809,-1,1810,1476,1791,-1,1811,1452,477,-1,1329,1812,1813,-1,1814,1082,1257,-1,1815,1816,1817,-1,1695,1694,1818,-1,1252,1819,1465,-1,1216,1820,1821,-1,1820,1822,1823,-1,808,1824,1248,-1,1249,1825,1244,-1,1483,1826,1827,-1,1685,1744,1252,-1,1817,1828,1815,-1,1238,1355,1698,-1,1808,1829,1830,-1,1139,1808,1831,-1,1229,1316,1230,-1,1832,1223,1806,-1,1117,1833,1116,-1,1834,1443,1252,-1,1103,1107,1109,-1,1444,1023,1102,-1,1101,1104,1108,-1,1463,1201,1205,-1,1203,1835,1201,-1,1200,1199,1817,-1,1836,1195,1194,-1,560,1837,1193,-1,1838,565,1400,-1,1457,1839,1458,-1,1461,1185,1169,-1,1422,1421,1181,-1,1840,1464,1841,-1,1178,1461,1460,-1,1842,1843,1844,-1,1177,1187,1845,-1,1756,1755,1846,-1,1847,1181,1179,-1,1848,1244,1849,-1,1166,1248,1824,-1,1850,1825,1851,-1,1162,1852,1483,-1,1853,813,1854,-1,1804,1264,1855,-1,1856,1857,1370,-1,1858,1859,1860,-1,1861,1342,1143,-1,1342,1861,1862,-1,1281,1067,1282,-1,1141,1140,1286,-1,1863,1261,1864,-1,1865,1866,1806,-1,1867,1868,1869,-1,1870,1871,1308,-1,1283,1872,1284,-1,1873,1874,1300,-1,1121,1120,1291,-1,1292,1875,1876,-1,1875,1877,1876,-1,1878,1302,1294,-1,1879,1880,1467,-1,1881,1882,1113,-1,1883,1692,1114,-1,1024,1023,1444,-1,1108,1110,1101,-1,1884,1885,1774,-1,1275,1012,1011,-1,1774,1331,1886,-1,1092,1326,1090,-1,1092,1775,1481,-1,1887,1257,1256,-1,1327,1773,1035,-1,1162,1888,1889,-1,1890,1891,1799,-1,1892,1893,1894,-1,1895,1258,1078,-1,1280,1067,1281,-1,1896,1052,1762,-1,1897,1437,1898,-1,1691,1690,1437,-1,1454,1704,1760,-1,1759,1761,1899,-1,1900,268,1417,-1,1474,1137,1864,-1,1832,1901,1223,-1,1335,1902,1903,-1,1904,1478,1196,-1,1905,1906,1833,-1,1907,1908,1909,-1,1910,1911,1912,-1,1885,1913,1914,-1,1011,1276,1275,-1,1608,1607,1915,-1,1005,1047,1006,-1,1916,1917,1918,-1,811,810,1919,-1,1920,1000,1001,-1,975,977,980,-1,1921,997,996,-1,1922,1923,1924,-1,1612,1600,1925,-1,1926,1927,1596,-1,1614,1928,1929,-1,976,1930,978,-1,964,963,1931,-1,1932,1933,1934,-1,960,966,961,-1,1935,1604,1605,-1,1935,914,1604,-1,1936,948,947,-1,1569,944,1937,-1,938,1938,1939,-1,1940,1941,943,-1,1942,1943,1944,-1,1945,1946,1591,-1,1946,1947,1588,-1,1580,1583,924,-1,913,923,919,-1,1935,1948,914,-1,918,950,952,-1,1949,1950,1951,-1,900,1952,1953,-1,890,1954,883,-1,888,887,1955,-1,885,884,1956,-1,881,889,882,-1,877,878,1957,-1,876,875,1958,-1,1959,871,857,-1,858,860,862,-1,868,870,1960,-1,1961,865,853,-1,851,866,863,-1,871,1956,860,-1,861,889,1960,-1,866,865,879,-1,872,857,1962,-1,868,1963,870,-1,853,1964,867,-1,1965,849,848,-1,1966,847,1967,-1,844,837,845,-1,1968,834,838,-1,1969,843,1970,-1,1969,840,843,-1,1916,1243,1971,-1,831,1153,1972,-1,1973,1974,1975,-1,1976,1977,1978,-1,1979,1980,1981,-1,1982,1983,1984,-1,1985,1986,1987,-1,1988,821,954,-1,819,818,820,-1,1854,1989,1853,-1,815,814,1674,-1,1990,1991,1992,-1,808,1993,1991,-1,1994,1244,1848,-1,780,1995,778,-1,780,804,1995,-1,1996,1997,1998,-1,793,1999,796,-1,792,2000,804,-1,794,793,795,-1,2001,2002,2003,-1,791,794,2004,-1,2005,2006,2007,-1,2008,2009,2010,-1,778,781,784,-1,806,2011,1999,-1,780,2012,804,-1,765,771,2013,-1,775,741,2014,-1,2015,738,2016,-1,771,767,2017,-1,769,768,766,-1,1849,764,1848,-1,733,732,2018,-1,751,2019,2020,-1,755,754,2021,-1,2022,2023,2024,-1,746,2025,2026,-1,2027,2028,750,-1,750,2021,2027,-1,2021,754,2027,-1,2029,2024,2030,-1,2026,751,2031,-1,2025,2032,2033,-1,2034,740,742,-1,737,739,2035,-1,2036,2037,2038,-1,2039,2040,2041,-1,2042,2043,2044,-1,2045,757,2046,-1,775,774,747,-1,736,735,2016,-1,2013,734,2037,-1,2047,2048,2049,-1,2050,2051,2052,-1,2017,767,2053,-1,678,721,679,-1,2054,2055,723,-1,720,722,2056,-1,725,2057,2058,-1,2059,2060,718,-1,718,2061,664,-1,680,665,681,-1,714,713,2062,-1,2061,659,664,-1,2063,2064,713,-1,708,2065,2066,-1,707,2067,699,-1,2068,698,2069,-1,704,2070,2071,-1,703,2072,702,-1,699,2073,700,-1,2069,2074,695,-1,705,2075,2076,-1,702,694,2077,-1,695,2074,2078,-1,2079,2080,2081,-1,697,686,693,-1,693,686,688,-1,684,2082,729,-1,701,676,675,-1,682,677,679,-1,718,2083,719,-1,710,2084,2085,-1,2086,2085,673,-1,663,669,668,-1,2086,708,710,-1,659,2061,2087,-1,670,662,664,-1,660,2088,674,-1,2089,681,665,-1,2090,2091,2092,-1,2093,2094,640,-1,2095,639,2096,-1,2097,2098,2099,-1,651,532,534,-1,2100,649,647,-1,2101,647,417,-1,2102,2103,2104,-1,2105,641,643,-1,643,2106,2105,-1,638,2107,639,-1,335,2101,2108,-1,2109,2110,602,-1,2109,2111,2110,-1,2112,634,630,-1,2113,2114,626,-1,2115,2116,593,-1,2114,2117,627,-1,2118,2119,586,-1,2120,620,615,-1,586,2121,2118,-1,2122,612,2123,-1,2124,2125,2126,-1,614,613,608,-1,588,2127,2128,-1,2129,604,2130,-1,606,602,609,-1,2131,2132,2133,-1,2134,590,592,-1,2135,587,2136,-1,588,2137,610,-1,2138,2133,589,-1,564,561,2139,-1,1734,573,2140,-1,559,1606,557,-1,2141,2142,2143,-1,2144,570,2145,-1,554,2146,564,-1,2147,2148,557,-1,2149,567,566,-1,553,552,573,-1,553,560,562,-1,563,2150,2151,-1,1608,1606,1609,-1,548,1342,1862,-1,2152,2153,537,-1,538,547,522,-1,2154,546,547,-1,537,539,543,-1,538,2155,2156,-1,2157,415,420,-1,533,536,534,-1,1638,1550,2158,-1,527,526,2159,-1,525,527,548,-1,517,511,521,-1,541,2160,515,-1,516,515,2161,-1,2160,2162,2163,-1,2164,2165,513,-1,2166,2161,2167,-1,508,507,512,-1,2168,2169,509,-1,495,506,504,-1,2170,2171,492,-1,501,500,499,-1,484,498,2172,-1,496,495,2173,-1,498,486,2174,-1,2175,2176,2177,-1,2171,2177,483,-1,2178,469,468,-1,2179,1800,1081,-1,135,137,134,-1,290,465,466,-1,1260,462,461,-1,2180,2181,449,-1,455,2182,451,-1,2183,2184,2185,-1,2186,459,2187,-1,2188,2180,449,-1,2189,2190,2191,-1,2192,2193,2194,-1,2184,2182,455,-1,2195,2196,2197,-1,2198,2199,2200,-1,2201,429,2202,-1,2203,2204,426,-1,2201,2205,2206,-1,2207,428,424,-1,2208,473,475,-1,2209,2210,2211,-1,412,416,2212,-1,407,2213,2214,-1,2215,2216,2213,-1,2217,2218,2219,-1,2218,402,344,-1,259,258,375,-1,2220,2221,351,-1,2222,395,2223,-1,2224,2225,2226,-1,2227,386,2228,-1,366,2229,380,-1,378,379,364,-1,220,181,2230,-1,2231,2220,350,-1,225,376,375,-1,2232,374,2233,-1,2234,359,388,-1,2235,2236,2237,-1,2238,407,2239,-1,352,348,350,-1,348,2240,350,-1,342,348,343,-1,649,2241,345,-1,2242,2243,2244,-1,2101,335,334,-1,325,327,616,-1,322,324,607,-1,2245,317,316,-1,318,324,322,-1,631,622,2246,-1,617,616,327,-1,327,325,2247,-1,2245,2248,299,-1,321,332,305,-1,331,2249,306,-1,331,329,2249,-1,2247,2250,303,-1,2241,2251,345,-1,2241,649,2252,-1,2253,2254,310,-1,345,2251,308,-1,2255,302,2256,-1,302,301,2256,-1,2250,2257,313,-1,2258,304,2259,-1,2249,2260,2261,-1,4,3,266,-1,2262,1764,2263,-1,1811,295,294,-1,1900,267,268,-1,2264,2265,2266,-1,51,53,293,-1,1811,476,295,-1,2267,2268,2269,-1,2270,2271,2272,-1,2273,2274,1808,-1,2275,127,2276,-1,2277,2278,282,-1,2279,2280,221,-1,235,2281,236,-1,144,143,2282,-1,2283,2284,2285,-1,2286,2287,2288,-1,274,2263,1764,-1,2262,2263,267,-1,1,2263,2289,-1,1,267,2263,-1,2,2289,2290,-1,1,4,267,-1,228,242,222,-1,199,229,228,-1,2291,2292,2293,-1,161,2294,253,-1,342,349,348,-1,224,2295,2296,-1,2297,2298,2299,-1,167,166,2300,-1,243,2301,2302,-1,2303,2304,2305,-1,1795,2306,2307,-1,141,142,234,-1,207,237,205,-1,226,225,375,-1,2308,373,2295,-1,2301,243,2271,-1,151,2309,245,-1,2306,2286,2266,-1,207,232,237,-1,216,213,217,-1,153,184,155,-1,2310,239,2311,-1,2312,287,206,-1,2313,2314,2300,-1,2315,209,157,-1,256,2296,2316,-1,2317,254,256,-1,255,254,264,-1,2318,2319,2320,-1,269,2321,2322,-1,198,2288,2323,-1,193,2324,235,-1,2325,2320,118,-1,2326,190,2327,-1,191,2328,192,-1,2329,2330,2331,-1,221,199,228,-1,2296,2332,158,-1,163,186,2333,-1,2294,2334,252,-1,102,133,170,-1,2335,371,186,-1,2336,2337,169,-1,2338,2333,2339,-1,104,179,188,-1,167,2340,2272,-1,183,2341,269,-1,2342,2316,160,-1,2343,2268,206,-1,2264,2344,2345,-1,174,152,219,-1,371,2329,2336,-1,241,200,208,-1,166,2343,206,-1,2291,2346,2274,-1,146,144,2347,-1,148,141,140,-1,292,2348,116,-1,2349,2350,132,-1,289,131,2348,-1,2351,2319,2276,-1,289,295,290,-1,114,2352,2353,-1,131,130,2348,-1,115,2354,113,-1,113,2354,124,-1,2355,118,120,-1,2356,108,2351,-1,132,136,2357,-1,277,2347,144,-1,134,2358,2359,-1,103,100,102,-1,2360,408,138,-1,92,49,50,-1,2361,90,89,-1,77,2362,81,-1,65,12,39,-1,68,37,39,-1,2363,69,27,-1,44,46,2364,-1,2365,2366,2367,-1,2368,11,43,-1,56,54,52,-1,2369,2362,79,-1,64,72,47,-1,2370,92,64,-1,2275,38,2371,-1,74,2372,2373,-1,35,2374,60,-1,2375,2376,2377,-1,2378,2379,2380,-1,57,2381,55,-1,2382,2383,2384,-1,93,50,14,-1,19,2385,2386,-1,2387,73,92,-1,2368,2388,70,-1,64,92,72,-1,2389,2390,2391,-1,2381,2392,2391,-1,2393,97,2383,-1,56,80,2384,-1,2394,65,38,-1,34,2395,94,-1,53,52,33,-1,96,37,2363,-1,30,26,28,-1,2396,295,2348,-1,15,18,17,-1,24,3,297,-1,10,2397,8,-1,7,3,23,-1,10,9,2398,-1,2399,2400,8,-1,281,21,20,-1,2348,28,2396,-1,96,2363,29,-1,33,2401,53,-1,32,34,94,-1,2394,38,2275,-1,57,40,42,-1,2383,2382,2393,-1,2391,2392,2389,-1,11,2368,70,-1,2368,99,2388,-1,73,72,92,-1,93,14,16,-1,2384,2402,2382,-1,55,54,57,-1,2380,2403,2378,-1,2375,2377,2404,-1,60,36,35,-1,96,2371,38,-1,70,2388,71,-1,2370,49,92,-1,52,51,56,-1,56,2384,2383,-1,43,45,2368,-1,2385,2365,2367,-1,44,2364,2405,-1,27,30,2363,-1,68,39,95,-1,2406,74,2373,-1,2362,2407,81,-1,2361,2408,90,-1,408,2409,2410,-1,170,2411,102,-1,134,102,2358,-1,277,279,2347,-1,132,2412,105,-1,122,2413,106,-1,2414,2415,124,-1,114,113,125,-1,108,2356,109,-1,123,188,189,-1,2413,114,2353,-1,125,2352,114,-1,2351,2416,2319,-1,2348,295,289,-1,2353,2349,132,-1,116,129,292,-1,135,134,2359,-1,2236,2417,358,-1,2418,122,121,-1,146,247,144,-1,2329,178,2336,-1,169,2339,372,-1,371,2335,2329,-1,174,219,220,-1,205,2313,2312,-1,2419,2317,160,-1,270,183,269,-1,164,2280,165,-1,2272,168,167,-1,2420,252,171,-1,186,175,2335,-1,253,2294,252,-1,163,2333,2334,-1,165,2421,184,-1,158,2316,2296,-1,160,173,172,-1,2331,178,2329,-1,192,123,191,-1,2350,107,117,-1,235,194,193,-1,2323,2422,198,-1,2322,2423,269,-1,2319,2416,2320,-1,2317,256,2342,-1,2316,2342,256,-1,347,349,2424,-1,2425,2311,2315,-1,240,202,204,-1,157,2426,2315,-1,207,206,140,-1,213,215,217,-1,207,233,232,-1,2266,2307,2306,-1,151,245,149,-1,2271,2270,2301,-1,2295,224,2308,-1,227,229,2427,-1,139,141,234,-1,2428,1795,2305,-1,2303,2305,2429,-1,2302,2430,243,-1,166,287,2300,-1,2298,2431,2299,-1,2296,256,224,-1,347,2432,2240,-1,242,2292,222,-1,376,256,255,-1,263,262,2433,-1,2221,258,2434,-1,222,221,228,-1,2290,2435,2,-1,2,2435,265,-1,2400,1702,266,-1,272,295,273,-1,1764,275,274,-1,2288,198,2286,-1,2285,2436,2283,-1,144,2282,277,-1,235,2324,2281,-1,282,2278,21,-1,284,2277,2437,-1,2275,2371,127,-1,2438,246,1807,-1,2272,2439,2270,-1,2267,2269,2440,-1,2346,1766,1831,-1,2344,2264,2266,-1,2344,2266,2286,-1,1900,2441,267,-1,288,132,131,-1,267,2441,2442,-1,2277,1221,2278,-1,2261,306,2249,-1,2258,305,304,-1,313,303,2250,-1,249,345,308,-1,342,2253,310,-1,312,2443,344,-1,2241,2252,2261,-1,315,2247,303,-1,321,305,2258,-1,317,2245,299,-1,2247,315,327,-1,617,327,2444,-1,631,2246,330,-1,318,2445,324,-1,316,319,2245,-1,322,607,323,-1,325,616,326,-1,345,650,649,-1,655,2243,339,-1,2242,250,251,-1,349,2446,2447,-1,2432,347,2424,-1,252,2420,2448,-1,2208,410,409,-1,356,2449,2450,-1,353,2434,2451,-1,359,2228,388,-1,374,2452,2233,-1,2240,348,347,-1,350,2240,2231,-1,2448,133,410,-1,363,378,364,-1,366,380,367,-1,361,2227,2228,-1,389,2453,390,-1,2225,2454,2226,-1,2455,397,2456,-1,2222,2457,395,-1,351,350,2220,-1,255,264,263,-1,2218,344,2219,-1,262,404,2458,-1,2217,2219,2216,-1,2215,2217,2216,-1,407,2215,2213,-1,358,2417,2459,-1,474,1219,2460,-1,412,2212,413,-1,2209,419,2210,-1,424,423,2207,-1,2206,2461,2201,-1,2201,2202,2462,-1,2463,2198,2200,-1,2196,442,2197,-1,455,2464,2184,-1,2194,2183,2192,-1,2191,445,2189,-1,443,2465,444,-1,2466,450,408,-1,456,2181,2467,-1,2468,2183,2185,-1,455,451,450,-1,2186,454,463,-1,136,135,2357,-1,460,2186,463,-1,290,466,288,-1,2360,138,461,-1,2469,408,1259,-1,288,466,132,-1,461,464,1260,-1,2178,463,462,-1,2171,483,482,-1,2175,2177,2171,-1,498,2174,499,-1,2173,490,496,-1,497,484,2172,-1,499,502,501,-1,2171,482,492,-1,495,496,506,-1,2166,2167,2470,-1,508,512,510,-1,2165,521,513,-1,2471,2160,2163,-1,2166,516,2161,-1,541,540,2160,-1,521,520,517,-1,548,550,525,-1,2158,2472,1638,-1,2157,2473,415,-1,2155,540,2156,-1,543,2474,537,-1,2154,547,2153,-1,522,2155,538,-1,2152,537,2474,-1,1144,527,1145,-1,1342,548,1144,-1,2399,8,2397,-1,1608,557,1606,-1,562,563,2151,-1,573,1837,560,-1,561,563,562,-1,566,2140,2149,-1,557,565,2147,-1,568,558,2475,-1,564,569,554,-1,2144,2145,2151,-1,2476,2141,2143,-1,564,1361,1007,-1,1734,574,573,-1,1837,573,572,-1,561,580,2139,-1,309,2477,2100,-1,588,610,589,-1,2135,2136,591,-1,2134,592,2478,-1,2133,2138,2131,-1,606,605,602,-1,2129,2479,604,-1,588,587,2127,-1,614,608,2480,-1,2124,2126,612,-1,2122,2124,612,-1,586,585,2121,-1,2120,615,621,-1,2114,627,626,-1,593,2119,2115,-1,2113,626,633,-1,2112,630,635,-1,2111,637,2110,-1,605,2109,602,-1,2101,417,2108,-1,638,640,2481,-1,2107,2096,639,-1,641,2099,642,-1,2102,2482,2103,-1,647,418,417,-1,649,648,647,-1,651,2483,532,-1,2097,2099,2104,-1,2095,2093,639,-1,2093,640,639,-1,2484,2090,2092,-1,2485,2486,2487,-1,673,2488,656,-1,660,674,661,-1,664,659,670,-1,659,2087,660,-1,2083,668,665,-1,663,2485,669,-1,2086,673,672,-1,2485,663,662,-1,2085,2086,710,-1,681,677,682,-1,675,709,708,-1,684,729,685,-1,693,688,2489,-1,690,691,2082,-1,2082,684,690,-1,693,692,697,-1,2081,2490,2079,-1,695,2078,696,-1,702,2072,694,-1,705,2071,2075,-1,2069,698,2074,-1,699,2067,2073,-1,702,2066,703,-1,2071,705,704,-1,2068,706,698,-1,707,2491,2067,-1,2065,703,2066,-1,2065,672,2088,-1,713,712,2063,-1,2492,714,2062,-1,680,2083,665,-1,718,2060,2061,-1,720,2059,718,-1,2054,725,2058,-1,2056,2059,720,-1,723,725,2054,-1,678,685,721,-1,2053,2493,2017,-1,2052,760,2050,-1,2494,2047,2049,-1,2037,2495,2013,-1,736,2016,737,-1,747,742,775,-1,757,758,2046,-1,2042,2044,2496,-1,2039,2041,2497,-1,2498,2036,2038,-1,2035,2028,737,-1,742,746,2034,-1,2025,747,2032,-1,2026,2019,751,-1,2029,756,2024,-1,2027,2499,2028,-1,2031,746,2026,-1,2024,756,2022,-1,755,2021,757,-1,2020,2500,751,-1,2501,2502,2503,-1,2018,2504,733,-1,769,766,765,-1,771,2017,772,-1,772,2015,2016,-1,2014,773,775,-1,771,735,2013,-1,780,779,805,-1,778,784,779,-1,2008,2010,2505,-1,2005,2007,2506,-1,791,2004,2507,-1,2003,2508,2001,-1,794,795,2004,-1,804,2012,792,-1,793,796,795,-1,1996,2509,1997,-1,2510,1673,1991,-1,1093,1919,2511,-1,2512,1004,1674,-1,818,817,820,-1,954,2513,1988,-1,1987,822,1985,-1,1984,826,1982,-1,1981,830,1979,-1,2514,1976,1978,-1,1974,836,1975,-1,1266,1265,2515,-1,1267,1801,2516,-1,842,829,827,-1,842,847,829,-1,1968,2517,834,-1,844,2518,837,-1,873,1965,848,-1,1964,2519,867,-1,1963,854,870,-1,1962,2520,872,-1,879,878,866,-1,1960,862,861,-1,1956,884,860,-1,863,850,851,-1,853,867,1961,-1,869,868,1960,-1,862,856,858,-1,857,872,1959,-1,1958,1955,876,-1,2521,877,1957,-1,879,2522,883,-1,883,880,879,-1,885,1956,886,-1,888,1955,1958,-1,883,882,890,-1,885,891,861,-1,2523,2524,2525,-1,1953,2526,900,-1,1951,910,1949,-1,952,919,918,-1,1948,915,914,-1,913,916,923,-1,941,940,2527,-1,936,1943,1942,-1,1583,2528,924,-1,933,932,2529,-1,932,2530,2529,-1,1946,1588,1591,-1,1945,1591,1578,-1,943,941,1940,-1,1939,2531,938,-1,1937,2532,1569,-1,947,986,1936,-1,914,2533,1604,-1,1605,949,1935,-1,2534,2535,2536,-1,2535,955,2536,-1,960,2537,967,-1,966,2538,961,-1,1934,2539,1932,-1,1931,971,964,-1,977,976,978,-1,1614,1929,1610,-1,980,2540,1000,-1,980,979,2540,-1,970,969,2541,-1,1927,2542,1596,-1,1933,2543,972,-1,963,2544,2545,-1,1925,2546,1612,-1,1922,1924,2547,-1,2548,2549,1924,-1,1921,975,997,-1,975,980,997,-1,1920,1001,998,-1,811,1919,1093,-1,1799,1269,1035,-1,469,1242,1243,-1,1441,1010,1714,-1,1838,1400,1399,-1,2550,2551,1097,-1,1910,2552,1911,-1,2553,2554,1025,-1,1102,1105,1103,-1,1880,2555,2556,-1,1833,1117,1905,-1,1196,1240,1904,-1,1335,1903,1336,-1,1143,1146,1046,-1,2557,1474,1864,-1,1713,583,1047,-1,1899,2558,1759,-1,1897,1691,1437,-1,1458,1188,1345,-1,1052,1763,1053,-1,1456,1057,1056,-1,2559,1706,1705,-1,2560,2561,2562,-1,1768,1280,1281,-1,1034,1890,1035,-1,1895,1078,2563,-1,1043,1826,550,-1,1827,1484,1483,-1,1328,2564,1329,-1,2565,1091,1093,-1,1090,1775,1092,-1,1884,1774,1886,-1,1094,1096,1334,-1,1479,2550,1013,-1,1015,1910,1331,-1,1107,2566,1212,-1,1211,2567,1213,-1,1883,1693,1692,-1,1113,1883,1114,-1,2556,2568,1113,-1,1215,2569,1216,-1,1113,1467,2556,-1,1876,1877,2570,-1,2571,2572,2573,-1,2574,2575,1798,-1,2576,2577,2578,-1,2579,2580,1786,-1,2560,2562,1805,-1,2581,1063,1829,-1,2582,1279,1045,-1,1140,1064,1286,-1,1861,1143,2583,-1,2584,2585,2586,-1,1152,1266,2587,-1,1855,1158,1804,-1,1247,1485,528,-1,1675,1850,1812,-1,1163,1249,1161,-1,808,807,1993,-1,1847,1179,1178,-1,1755,1845,1846,-1,1184,1170,1172,-1,1177,1176,1187,-1,1842,1187,1843,-1,1181,1847,1422,-1,1169,1462,1461,-1,1241,1185,1461,-1,1740,2588,1193,-1,1193,1192,560,-1,1200,1817,1816,-1,1202,1695,1209,-1,1203,1202,2589,-1,1112,2590,1033,-1,1101,1678,1104,-1,1102,1104,1444,-1,1107,1213,1109,-1,1692,2288,2591,-1,1229,1231,1226,-1,1809,1808,1830,-1,1753,1174,1353,-1,1238,1237,1355,-1,1828,2592,1815,-1,1752,1353,1757,-1,1799,1891,1079,-1,1893,1077,1894,-1,528,1246,1247,-1,1813,1812,1850,-1,1849,1244,1250,-1,1248,809,808,-1,1823,2593,1820,-1,1216,1253,1820,-1,2594,1242,469,-1,1814,2564,1082,-1,550,1826,1483,-1,476,1811,477,-1,1791,1681,1073,-1,1791,1073,1810,-1,1805,2595,1682,-1,1158,1469,1803,-1,1154,1802,1687,-1,1153,1688,1802,-1,1688,1153,831,-1,1270,1293,1277,-1,1298,1274,2596,-1,1099,1212,1013,-1,1712,1128,1798,-1,1277,1470,1278,-1,2597,2598,2599,-1,1068,1867,2600,-1,1683,1793,2438,-1,2601,2602,2603,-1,1792,2604,1681,-1,1271,1875,1120,-1,1278,1027,1270,-1,1790,1470,1277,-1,1796,2576,2578,-1,1788,2605,1301,-1,1472,1676,1787,-1,1797,1798,1296,-1,1299,1297,1785,-1,1782,1308,1307,-1,1307,1309,2606,-1,1224,1781,1225,-1,1224,1311,2607,-1,1228,1320,1778,-1,1318,1672,1489,-1,1318,1489,1486,-1,1853,2608,813,-1,1481,2609,811,-1,1334,1478,1904,-1,1904,1333,1334,-1,1326,1325,1088,-1,1476,1810,1447,-1,2610,1038,2611,-1,1772,1902,1770,-1,1769,1143,1767,-1,1889,2612,1162,-1,1219,1218,1282,-1,2613,1346,1763,-1,1455,1762,1057,-1,1761,1759,1061,-1,1185,1170,1184,-1,1758,2614,1371,-1,1756,1699,1698,-1,1754,1686,1755,-1,1362,1369,1380,-1,1007,569,564,-1,1751,2615,1742,-1,2616,1748,1750,-1,1368,1357,1365,-1,580,1192,1191,-1,1373,2617,1746,-1,1741,2618,1373,-1,1375,1378,1376,-1,1745,1742,1744,-1,1741,1746,1739,-1,1685,1745,1744,-1,1737,1904,1240,-1,1382,1391,1450,-1,1365,1382,1381,-1,579,1394,1385,-1,1736,1387,1389,-1,576,1390,2619,-1,575,2620,2621,-1,1735,1373,574,-1,578,1441,579,-1,1396,2622,1732,-1,1731,1401,1719,-1,1719,1403,2623,-1,1397,1732,1730,-1,1721,2624,1404,-1,1728,1413,1415,-1,1414,1459,1434,-1,1439,1715,2625,-1,2626,1436,1723,-1,1722,1434,1418,-1,1425,1424,1721,-1,1429,1457,1720,-1,2623,1429,1719,-1,1718,1423,1436,-1,1717,1182,1421,-1,1441,578,1010,-1,1048,1005,1007,-1,1420,2627,1713,-1,1293,1122,1121,-1,1128,1301,1300,-1,1377,1375,1710,-1,1058,1060,1707,-1,1707,294,296,-1,272,271,1705,-1,1703,1188,1691,-1,1843,1186,2628,-1,1702,1417,268,-1,1699,1171,1238,-1,1209,1695,2629,-1,1463,1695,1202,-1,1461,1697,1835,-1,1880,2556,1467,-1,1846,1845,1187,-1,1468,1690,1176,-1,1689,1802,1688,-1,1354,1755,1686,-1,1104,1684,1444,-1,1027,1278,1025,-1,1683,1869,1134,-1,2596,2630,1298,-1,1473,1313,1312,-1,1143,1046,1767,-1,1799,1079,1081,-1,1680,1087,1256,-1,1477,1334,1096,-1,1912,1331,1910,-1,1774,1885,1914,-1,1676,1003,1276,-1,2609,1914,1003,-1,1088,1085,1094,-1,1332,1481,1775,-1,1330,1250,1251,-1,1159,2631,2632,-1,1674,1004,1160,-1,1852,1165,1483,-1,1323,1488,1004,-1,1490,1228,2633,-1,1671,2634,1501,-1,1670,2635,1668,-1,1497,2636,1664,-1,1498,1526,1499,-1,1496,2637,2638,-1,1505,1504,1661,-1,1496,2639,1503,-1,1660,2640,1508,-1,1657,2641,1658,-1,1509,2642,1510,-1,1655,1510,1656,-1,1517,2643,1512,-1,1521,530,529,-1,1651,1653,1652,-1,1523,529,2644,-1,1650,1652,545,-1,2645,2646,2647,-1,2645,1522,2646,-1,1526,1525,1649,-1,1497,1524,1498,-1,1534,1665,1529,-1,1527,1648,1528,-1,1525,1531,1646,-1,1497,1530,1524,-1,1528,1648,1532,-1,1642,1630,1559,-1,1542,1535,1537,-1,1544,1540,1541,-1,1640,1541,1542,-1,1542,2648,1640,-1,1639,1640,2649,-1,1638,2650,1637,-1,1636,1551,2651,-1,1634,2652,1635,-1,1492,1491,2653,-1,1560,1644,1632,-1,1630,2654,1631,-1,1626,1576,1587,-1,1628,2655,1627,-1,1626,1629,1619,-1,1617,2656,2657,-1,1609,1622,1621,-1,1617,2658,1618,-1,1617,1616,1623,-1,1577,1564,1626,-1,1571,1565,583,-1,1620,1627,1609,-1,583,582,1571,-1,2659,937,1579,-1,1566,1571,1582,-1,2660,2656,1617,-1,1615,1593,2661,-1,1614,1601,1612,-1,1614,1610,1603,-1,1603,1601,1614,-1,1603,1611,986,-1,1577,1007,1006,-1,1621,1607,1609,-1,1609,1606,1619,-1,1604,986,947,-1,1604,2662,1603,-1,1602,1603,2662,-1,1600,1612,1601,-1,1596,2542,1595,-1,1579,1591,2663,-1,1590,2664,1588,-1,2655,1628,2665,-1,1594,2666,1592,-1,1579,937,936,-1,1586,1585,2655,-1,1609,1627,1622,-1,1562,1564,1577,-1,1567,1047,1565,-1,2657,1624,1617,-1,1573,1624,1574,-1,1620,1619,1629,-1,1585,1584,2667,-1,1617,1622,1585,-1,1559,1631,1560,-1,1556,2668,1557,-1,1554,2669,1555,-1,2670,1633,2671,-1,1633,1635,2671,-1,1545,1547,1551,-1,1550,1637,1548,-1,1545,2672,1546,-1,1543,1541,1640,-1,1541,1540,1535,-1,1539,2673,1540,-1,1535,2674,1536,-1,1497,2651,1530,-1,1524,1530,1525,-1,1669,1527,1529,-1,1534,1533,1665,-1,1526,1498,1524,-1,1522,1523,2646,-1,1521,1523,1519,-1,1520,1516,1518,-1,1518,1521,1520,-1,1516,1658,1517,-1,1511,1656,1510,-1,1509,1655,1507,-1,2639,2641,1657,-1,1508,1507,1506,-1,1506,1507,1501,-1,1496,1503,2637,-1,1502,1501,2634,-1,1497,1499,2636,-1,1495,1501,1496,-1,2633,2159,1490,-1,1147,1487,1486,-1,1488,1323,1486,-1,1004,1488,1159,-1,1483,1165,1246,-1,1813,2675,1329,-1,762,1330,815,-1,1004,2512,2676,-1,1089,1094,1334,-1,1003,811,2609,-1,1004,1003,1323,-1,1914,2609,1774,-1,1331,1678,1101,-1,1477,1263,1262,-1,2677,1081,1894,-1,1447,1446,1475,-1,2606,1309,1225,-1,1299,1785,1782,-1,1120,1122,1271,-1,1252,1444,1685,-1,1803,1469,1174,-1,1437,1690,1468,-1,1324,1693,1883,-1,2590,1205,1033,-1,1466,1465,1819,-1,1818,1253,1466,-1,1205,1697,1464,-1,1841,1464,1180,-1,1180,1179,1841,-1,1172,1844,1843,-1,1701,1417,1702,-1,1459,1416,1418,-1,1186,1843,1187,-1,1455,1057,1456,-1,1058,2678,1453,-1,1054,1056,1055,-1,2679,1451,1707,-1,1811,294,1452,-1,1448,1450,1391,-1,2680,1445,1447,-1,1777,1472,1471,-1,1205,291,1692,-1,2681,1393,1442,-1,1053,1898,1437,-1,1423,1422,1435,-1,1722,1432,1434,-1,1403,2682,2623,-1,1432,1405,1431,-1,1431,1730,1427,-1,1429,1430,1427,-1,1426,1418,1417,-1,1406,1425,1717,-1,1421,1423,1716,-1,1048,1715,1419,-1,1607,2683,1915,-1,1416,1900,1417,-1,1414,1433,1415,-1,1718,1409,1411,-1,1408,2684,1406,-1,1405,1729,1404,-1,1719,1401,1403,-1,1730,1431,1405,-1,1383,1394,1393,-1,1397,1404,1395,-1,579,1441,1393,-1,1382,1364,1392,-1,1388,1736,1389,-1,577,579,1386,-1,1385,1394,1383,-1,2685,1380,1381,-1,1381,1382,1450,-1,1377,1711,1240,-1,1737,1711,1710,-1,1372,1363,1234,-1,1374,1710,1375,-1,1373,1364,1363,-1,1372,2617,1373,-1,2139,1370,1747,-1,1358,1357,1368,-1,1371,2614,1358,-1,1367,1363,1365,-1,1365,1380,1368,-1,1360,1357,1358,-1,1360,1355,1357,-1,1239,1238,1170,-1,1353,1174,1354,-1,1349,1351,2686,-1,1052,1055,1762,-1,1703,1347,2687,-1,1764,2262,2688,-1,1344,1458,1345,-1,1799,1035,1890,-1,1339,1341,2689,-1,1072,1076,1037,-1,1039,1073,1072,-1,1447,1810,2680,-1,1003,1914,1019,-1,1333,1090,1089,-1,1904,1331,1333,-1,1327,1329,2675,-1,1091,1326,1092,-1,1033,1693,1324,-1,1320,1672,1317,-1,1319,1321,1317,-1,1272,1784,1787,-1,1229,1778,1315,-1,1806,1137,1832,-1,1781,1312,1780,-1,1779,1312,1314,-1,1312,1471,1473,-1,1307,2606,1306,-1,2690,1305,1273,-1,1119,1467,1271,-1,1302,1123,1300,-1,1298,1797,1296,-1,1298,2630,1797,-1,2605,1295,1301,-1,1295,2691,1293,-1,1291,1124,1878,-1,2692,1288,1290,-1,1287,2582,1141,-1,1283,1285,2693,-1,1281,1218,2694,-1,2695,1279,1280,-1,1298,1783,1274,-1,1273,2696,1274,-1,1679,1265,1152,-1,1263,1855,1264,-1,1140,1261,1064,-1,1830,1829,2600,-1,477,1452,462,-1,1078,1259,449,-1,1080,1892,1894,-1,1207,1112,1254,-1,1252,1465,1253,-1,1248,1244,809,-1,1675,1812,1330,-1,1164,2697,1247,-1,1244,1825,1251,-1,1894,1081,1080,-1,1269,1265,1035,-1,1241,1232,1234,-1,1195,1379,1240,-1,1237,1239,2698,-1,1235,1233,1232,-1,2699,1856,2700,-1,1829,1808,1139,-1,1316,1310,1230,-1,1226,1228,1229,-1,2633,2701,2702,-1,1219,474,1217,-1,1692,2591,1114,-1,2568,1881,1113,-1,1027,1030,1270,-1,1108,1104,1103,-1,1110,1100,1101,-1,1202,1232,2589,-1,1202,1235,1232,-1,2703,2629,2704,-1,1206,2590,1112,-1,1205,2590,1206,-1,1203,2589,1835,-1,1200,1836,1194,-1,1196,1198,1194,-1,1196,1262,1197,-1,1191,1193,2588,-1,1370,2139,1189,-1,1189,2139,580,-1,1186,1188,1458,-1,1181,1421,1182,-1,1846,1187,1842,-1,1173,1175,2705,-1,1178,1460,1847,-1,1171,1844,1172,-1,1168,1462,1169,-1,2705,1175,1687,-1,1166,1824,1164,-1,1161,1852,1162,-1,1165,1164,1246,-1,1158,1855,1156,-1,1803,1174,1753,-1,2706,2707,2708,-1,1147,526,528,-1,2695,1767,1046,-1,2709,1068,2600,-1,2710,2711,1309,-1,2712,2713,1782,-1,2714,2693,1285,-1,2715,2716,2717,-1,2718,2719,1794,-1,1029,1119,1030,-1,1909,1214,1216,-1,1833,1907,1116,-1,1114,2591,1115,-1,1692,1033,1205,-1,1103,1105,1107,-1,2553,1025,1278,-1,1211,1213,1212,-1,1912,1886,1331,-1,1021,1480,1013,-1,1478,1334,1477,-1,1088,1090,1326,-1,1089,1088,1094,-1,2511,2720,2721,-1,2722,2675,1813,-1,1482,2723,1483,-1,2724,1042,549,-1,1074,1076,2725,-1,1070,1867,1068,-1,1065,1067,1280,-1,1062,2709,1063,-1,1772,2680,1810,-1,1349,2686,1706,-1,1056,1060,1456,-1,1706,2678,296,-1,1454,1456,1704,-1,1050,2726,1051,-1,2559,1349,1706,-1,1084,1265,1679,-1,1048,1713,1047,-1,1146,1044,1046,-1,1037,2611,1038,-1,1819,1252,1744,-1,1030,2727,1028,-1,1106,2566,1107,-1,1012,2728,1020,-1,1017,1275,1018,-1,1019,1018,1003,-1,1915,1400,565,-1,1398,1010,1399,-1,811,1003,812,-1,998,1001,999,-1,997,1000,1920,-1,993,999,994,-1,997,1920,995,-1,2729,2730,2731,-1,992,994,990,-1,950,2732,995,-1,989,992,990,-1,986,1611,987,-1,984,1597,985,-1,983,1595,981,-1,980,977,978,-1,2733,2549,1929,-1,2729,2734,976,-1,975,2729,976,-1,967,2735,973,-1,971,2736,972,-1,968,970,2737,-1,966,967,974,-1,1933,1932,2738,-1,969,2735,2739,-1,2740,958,959,-1,2536,955,957,-1,953,958,954,-1,911,913,919,-1,951,2732,950,-1,1605,947,949,-1,946,1937,944,-1,943,2741,942,-1,2742,938,2531,-1,2742,1943,938,-1,939,941,943,-1,938,1943,936,-1,934,2743,933,-1,933,2743,930,-1,931,1584,932,-1,927,2744,928,-1,925,1580,924,-1,916,926,924,-1,951,920,922,-1,919,923,917,-1,914,916,913,-1,910,1951,908,-1,2745,899,907,-1,906,2746,904,-1,903,2747,901,-1,898,900,2526,-1,897,890,889,-1,891,885,886,-1,886,1956,887,-1,883,2522,881,-1,1957,878,880,-1,875,877,2521,-1,1959,872,874,-1,858,857,871,-1,1960,870,862,-1,1961,867,869,-1,851,853,865,-1,864,848,850,-1,860,884,861,-1,859,1962,857,-1,870,854,856,-1,852,1964,853,-1,849,2748,850,-1,841,1967,847,-1,837,839,1978,-1,834,836,2749,-1,830,1981,828,-1,826,1984,827,-1,2750,1987,2751,-1,1987,1986,2751,-1,824,1985,822,-1,1988,819,821,-1,818,2752,816,-1,1004,2676,812,-1,813,2608,814,-1,763,762,2632,-1,1244,1994,1245,-1,803,778,1995,-1,2012,780,806,-1,803,1995,804,-1,795,797,2753,-1,1999,793,2012,-1,790,792,794,-1,790,794,791,-1,786,2754,787,-1,782,2042,781,-1,1999,2012,806,-1,793,792,2012,-1,2755,770,777,-1,773,2756,774,-1,772,2016,735,-1,770,731,768,-1,765,767,771,-1,762,764,1849,-1,2018,732,2757,-1,732,2758,2757,-1,760,2052,761,-1,2759,2760,2761,-1,2762,752,2500,-1,752,751,2500,-1,757,2021,749,-1,753,2031,751,-1,749,2021,750,-1,746,747,2025,-1,2496,2044,2763,-1,2763,2764,2496,-1,745,2765,743,-1,741,775,742,-1,737,2016,738,-1,734,2013,735,-1,733,768,731,-1,687,730,723,-1,729,722,721,-1,726,2766,727,-1,724,2767,725,-1,721,720,719,-1,717,2768,715,-1,714,2769,712,-1,2063,707,706,-1,2063,2770,707,-1,706,699,698,-1,705,2072,703,-1,701,2066,702,-1,700,2074,698,-1,697,2075,695,-1,694,2076,692,-1,691,693,2082,-1,689,684,683,-1,686,2771,687,-1,683,685,678,-1,709,677,681,-1,709,675,677,-1,673,661,674,-1,2485,662,671,-1,666,665,669,-1,665,667,2089,-1,660,2087,2088,-1,659,661,670,-1,672,674,2088,-1,658,673,656,-1,2092,2772,2473,-1,2473,2157,2092,-1,413,2212,654,-1,653,338,337,-1,2483,2773,532,-1,649,651,534,-1,647,422,418,-1,638,2482,2102,-1,646,2774,644,-1,532,2773,2775,-1,635,2776,636,-1,632,2776,635,-1,633,626,625,-1,630,2777,631,-1,595,594,628,-1,627,2120,625,-1,595,629,623,-1,621,615,617,-1,618,2123,619,-1,615,2778,616,-1,612,2126,613,-1,611,2138,589,-1,609,323,607,-1,2136,589,2133,-1,2130,604,606,-1,609,602,323,-1,601,2779,599,-1,596,598,2780,-1,2119,593,595,-1,590,2135,591,-1,589,2136,587,-1,586,624,584,-1,2115,2119,2118,-1,2781,583,2782,-1,2781,581,583,-1,560,1192,580,-1,1734,2140,2621,-1,565,1838,566,-1,570,551,2145,-1,569,558,568,-1,2147,565,567,-1,564,2146,563,-1,573,560,553,-1,556,2146,554,-1,553,2145,551,-1,548,1862,549,-1,548,527,1144,-1,546,523,522,-1,545,519,523,-1,544,1511,543,-1,542,2156,540,-1,538,2156,539,-1,533,2157,420,-1,415,2473,535,-1,530,2783,531,-1,550,1246,525,-1,525,1246,528,-1,522,524,2784,-1,519,521,2165,-1,518,2785,511,-1,514,541,515,-1,513,521,511,-1,510,2168,509,-1,2786,2787,2788,-1,506,505,507,-1,496,505,506,-1,494,504,2789,-1,502,489,503,-1,500,2172,498,-1,490,484,497,-1,480,2173,495,-1,482,481,493,-1,485,484,490,-1,489,502,487,-1,484,486,498,-1,483,478,481,-1,481,478,480,-1,468,2790,2178,-1,465,290,476,-1,1708,2178,462,-1,473,2791,474,-1,471,467,472,-1,1918,467,469,-1,2412,132,2357,-1,464,136,466,-1,464,461,137,-1,2466,408,2410,-1,459,2186,460,-1,456,2467,457,-1,2792,1259,1258,-1,2793,453,2190,-1,457,459,458,-1,453,2409,454,-1,451,2188,449,-1,2191,443,445,-1,2196,440,442,-1,2199,437,439,-1,436,2200,434,-1,429,433,2202,-1,429,431,425,-1,428,2207,426,-1,425,432,423,-1,422,536,420,-1,417,419,2209,-1,416,412,414,-1,411,413,2794,-1,133,408,409,-1,133,2420,170,-1,407,2214,406,-1,405,2795,403,-1,404,262,405,-1,249,307,344,-1,2796,257,261,-1,351,2797,352,-1,2796,400,257,-1,2798,2434,258,-1,2226,2457,2222,-1,2222,2799,2226,-1,396,2456,397,-1,2800,2801,2224,-1,2801,2225,2224,-1,392,2802,393,-1,390,2803,391,-1,388,2228,386,-1,385,2227,361,-1,383,2804,384,-1,380,2805,381,-1,379,2229,366,-1,377,2806,378,-1,226,2452,2308,-1,260,259,376,-1,370,384,368,-1,365,2807,366,-1,364,2808,362,-1,359,361,2228,-1,2235,2809,2798,-1,2238,2810,2811,-1,352,343,348,-1,2448,2420,133,-1,655,654,346,-1,346,2812,340,-1,349,2447,336,-1,251,250,249,-1,341,2244,346,-1,340,248,250,-1,336,2447,337,-1,335,2446,310,-1,331,333,2813,-1,328,330,2246,-1,314,2444,327,-1,324,326,607,-1,316,323,603,-1,321,2245,319,-1,318,322,316,-1,315,303,302,-1,307,301,313,-1,344,2443,342,-1,307,312,344,-1,311,310,2254,-1,304,306,2261,-1,303,313,301,-1,299,2814,300,-1,2,1,2289,-1,476,290,295,-1,293,285,85,-1,28,2348,292,-1,286,1692,291,-1,2287,2286,2306,-1,288,131,289,-1,285,293,286,-1,281,2277,282,-1,2277,281,2437,-1,1692,2323,2288,-1,2323,1692,286,-1,276,2815,274,-1,2262,267,2442,-1,269,2423,264,-1,2400,266,9,-1,2263,274,2289,-1,2797,351,399,-1,261,257,259,-1,2291,222,2292,-1,253,2816,162,-1,2448,2432,2424,-1,252,2448,2424,-1,230,146,2817,-1,243,2430,244,-1,2438,2818,246,-1,2421,2819,184,-1,241,209,215,-1,240,212,211,-1,204,205,237,-1,234,232,233,-1,230,232,234,-1,140,139,233,-1,226,2308,224,-1,2820,221,223,-1,150,2269,151,-1,190,182,201,-1,218,2821,216,-1,214,241,215,-1,212,2822,210,-1,140,233,207,-1,2315,2426,2425,-1,204,203,205,-1,2311,2425,2310,-1,181,200,182,-1,158,2332,199,-1,196,198,2422,-1,193,195,2823,-1,2419,270,264,-1,2337,2336,178,-1,191,180,182,-1,186,187,175,-1,185,173,160,-1,184,185,159,-1,252,2334,2333,-1,180,2824,181,-1,178,104,2337,-1,175,177,2335,-1,172,174,2825,-1,170,2420,171,-1,2337,170,169,-1,104,188,122,-1,168,2343,166,-1,165,159,158,-1,158,160,2316,-1,2317,2342,160,-1,205,2312,206,-1,155,157,208,-1,152,154,219,-1,2824,2230,181,-1,222,2273,246,-1,141,143,142,-1,146,2347,147,-1,144,247,142,-1,188,123,122,-1,148,140,236,-1,137,461,138,-1,134,138,133,-1,132,2350,130,-1,130,2350,117,-1,2353,2352,2349,-1,124,2826,125,-1,109,117,107,-1,129,116,109,-1,114,2418,115,-1,2354,2414,124,-1,111,118,2355,-1,106,2413,100,-1,102,105,2358,-1,170,2337,2411,-1,2411,103,102,-1,99,2368,45,-1,77,81,76,-1,40,57,56,-1,2369,2827,87,-1,95,39,12,-1,94,2401,33,-1,30,27,26,-1,92,93,2387,-1,89,91,2828,-1,90,2408,82,-1,87,2829,88,-1,85,2437,83,-1,81,90,82,-1,51,85,80,-1,79,2362,77,-1,74,76,82,-1,2408,2361,2372,-1,48,47,73,-1,64,63,2370,-1,12,11,70,-1,37,69,2363,-1,67,13,12,-1,47,46,63,-1,75,74,2406,-1,60,2374,61,-1,2361,89,2365,-1,48,2364,46,-1,87,2827,2830,-1,2362,86,2407,-1,40,2831,41,-1,56,2383,97,-1,65,39,38,-1,34,36,2395,-1,33,59,31,-1,83,2437,281,-1,29,2363,30,-1,295,2396,273,-1,24,2832,25,-1,2386,17,19,-1,15,2833,16,-1,9,8,2400,-1,2398,9,2834,-1,23,3,24,-1,5,297,3,-1,61,2835,2836,-1,61,2374,2835,-1,2376,2837,2838,-1,2376,2839,2837,-1,66,2394,2379,-1,2394,66,65,-1,80,2402,2384,-1,2402,80,2840,-1,2829,2830,2841,-1,2829,87,2830,-1,2842,2385,2367,-1,2385,2842,2386,-1,2843,79,78,-1,2843,31,79,-1,2844,2845,2846,-1,2844,2847,2845,-1,2848,2849,2850,-1,2848,2851,2849,-1,2851,2852,2853,-1,2851,2848,2852,-1,18,2370,2853,-1,2370,18,49,-1,2827,79,58,-1,79,2827,2369,-1,91,81,2854,-1,81,91,90,-1,35,2843,2855,-1,35,34,2843,-1,43,13,2856,-1,43,11,13,-1,19,2365,2385,-1,2361,2365,19,-1,2857,2347,279,-1,2857,147,2347,-1,132,101,2353,-1,101,132,105,-1,124,112,111,-1,124,2415,112,-1,120,108,2858,-1,119,108,120,-1,2859,2352,125,-1,2859,2349,2352,-1,2354,2326,2414,-1,2328,2326,2354,-1,2284,110,2860,-1,2861,110,2284,-1,2291,2273,222,-1,2274,2273,2291,-1,169,2338,2339,-1,2338,169,171,-1,2330,2335,177,-1,2335,2330,2329,-1,2862,2425,2426,-1,2862,2863,2425,-1,2314,205,203,-1,2314,2313,205,-1,2864,2265,2264,-1,2864,2865,2265,-1,183,2419,160,-1,2419,183,270,-1,165,2279,2421,-1,2279,165,2280,-1,2272,2298,2439,-1,2272,2340,2298,-1,2338,252,2333,-1,2338,171,252,-1,189,2824,180,-1,2824,189,2331,-1,2866,2867,2868,-1,2869,2867,2866,-1,2416,118,2320,-1,2416,119,118,-1,2870,277,2871,-1,2870,278,277,-1,253,2218,2816,-1,2218,253,402,-1,2860,2285,2284,-1,2860,2872,2285,-1,156,184,2819,-1,156,155,184,-1,2431,2873,2874,-1,2873,2431,2875,-1,2310,240,239,-1,240,2310,202,-1,238,232,231,-1,232,238,237,-1,2303,2440,2876,-1,2865,2440,2303,-1,2271,245,2309,-1,2271,243,245,-1,374,242,227,-1,374,2292,242,-1,216,2285,213,-1,2285,216,2436,-1,2877,2603,2878,-1,2877,2601,2603,-1,2879,2302,1793,-1,2302,2879,2430,-1,2429,1795,2307,-1,2429,2305,1795,-1,2877,149,2880,-1,149,2877,150,-1,2269,2343,151,-1,2269,2268,2343,-1,2817,145,2881,-1,2817,146,145,-1,2882,2283,2436,-1,2882,2883,2283,-1,2422,53,2401,-1,2422,2323,53,-1,195,2344,197,-1,2345,2344,195,-1,236,2884,2282,-1,236,2281,2884,-1,200,219,154,-1,181,219,200,-1,2318,2380,2319,-1,2318,2403,2380,-1,2870,2845,2885,-1,2870,2871,2845,-1,193,60,2324,-1,193,36,60,-1,2323,293,53,-1,2323,286,293,-1,2270,2886,2887,-1,2886,2270,2439,-1,96,292,128,-1,29,292,96,-1,2264,2888,2864,-1,2264,2345,2888,-1,2274,1831,1808,-1,2274,2346,1831,-1,2889,2258,2259,-1,2248,2258,2889,-1,2814,311,2254,-1,311,2814,2889,-1,2259,2477,309,-1,304,2477,2259,-1,2256,307,308,-1,301,307,2256,-1,2443,2890,342,-1,2443,2257,2890,-1,329,2255,2249,-1,329,328,2255,-1,321,2248,2245,-1,321,2258,2248,-1,2247,324,2445,-1,2247,325,324,-1,320,332,321,-1,332,320,333,-1,2891,320,319,-1,320,2891,636,-1,310,349,342,-1,349,310,2446,-1,2892,2893,2894,-1,2892,2895,2893,-1,2244,655,346,-1,655,2244,2243,-1,2234,377,2896,-1,2234,388,377,-1,410,2460,2897,-1,410,2898,2460,-1,2322,405,2423,-1,2899,405,2322,-1,252,402,253,-1,252,249,402,-1,2432,2231,2240,-1,2231,2432,2233,-1,2900,2901,2902,-1,2903,2901,2900,-1,2904,2905,2906,-1,2904,2907,2905,-1,2908,2907,2909,-1,2910,2907,2908,-1,2901,2911,2912,-1,2901,2903,2911,-1,2913,2914,2915,-1,2904,2914,2913,-1,2802,380,2229,-1,2803,380,2802,-1,387,2225,2806,-1,2225,387,2454,-1,2455,385,2804,-1,2456,385,2455,-1,2454,2457,2226,-1,2454,2916,2457,-1,2917,391,2486,-1,2917,389,391,-1,2918,2224,2919,-1,2918,2800,2224,-1,395,2488,2223,-1,395,397,2488,-1,369,2237,357,-1,2237,369,360,-1,2808,2239,354,-1,2239,2808,2807,-1,2235,2234,2809,-1,2235,359,2234,-1,355,399,398,-1,355,406,399,-1,400,2236,401,-1,400,2417,2236,-1,2920,2921,2922,-1,2923,2921,2920,-1,375,2221,2220,-1,375,258,2221,-1,2924,2920,2925,-1,2924,2923,2920,-1,2926,2925,2927,-1,2926,2924,2925,-1,2928,2219,344,-1,2219,2928,2929,-1,2458,2930,262,-1,2931,2930,2458,-1,2218,2932,2899,-1,2932,2218,2217,-1,2216,2909,2213,-1,2216,2908,2909,-1,2795,2933,403,-1,2933,2795,2449,-1,2215,2238,2811,-1,2238,2215,407,-1,357,2236,358,-1,357,2237,2236,-1,2934,2210,411,-1,2211,2210,2934,-1,2935,2204,2936,-1,2937,2204,2935,-1,2938,2939,2940,-1,2939,2938,2941,-1,423,2942,2207,-1,2179,2942,423,-1,439,424,428,-1,424,439,438,-1,2943,2944,2935,-1,2943,2945,2944,-1,2202,2946,2197,-1,2946,2202,433,-1,2947,2948,2949,-1,2947,2950,2948,-1,437,2198,2951,-1,2198,437,2199,-1,2940,2949,2938,-1,2940,2947,2949,-1,2951,2952,2953,-1,2952,2951,2198,-1,2954,2196,2955,-1,2954,440,2196,-1,470,2956,471,-1,2956,470,2206,-1,2936,471,2956,-1,2936,2957,471,-1,471,460,2790,-1,460,471,458,-1,446,2464,455,-1,446,448,2464,-1,2192,2958,2193,-1,2958,2192,2959,-1,2960,445,2961,-1,2960,2189,445,-1,2184,2962,2185,-1,2184,2464,2962,-1,2963,2964,2959,-1,2965,2964,2963,-1,2466,446,450,-1,447,446,2466,-1,2180,2958,2181,-1,2193,2958,2180,-1,2793,2409,453,-1,2793,2410,2409,-1,2187,454,2186,-1,452,454,2187,-1,449,408,450,-1,1259,408,449,-1,2790,467,471,-1,2790,468,467,-1,1708,469,2178,-1,1708,2594,469,-1,2965,479,478,-1,2965,2963,479,-1,2185,486,485,-1,2185,2962,486,-1,488,2961,2176,-1,488,2960,2961,-1,2175,488,2176,-1,489,488,2175,-1,2172,2966,2967,-1,2172,500,2966,-1,2788,2170,2786,-1,2968,2170,2788,-1,2169,504,509,-1,2789,504,2169,-1,2969,2970,2971,-1,2969,2972,2970,-1,2166,2789,2169,-1,2470,2789,2166,-1,2973,2974,2971,-1,2974,2973,2164,-1,2786,2161,2471,-1,2786,2167,2161,-1,2165,2973,524,-1,2973,2165,2164,-1,2471,515,2160,-1,2161,515,2471,-1,2162,540,2155,-1,540,2162,2160,-1,2975,2893,2895,-1,2975,2976,2893,-1,2977,1512,1515,-1,1654,1512,2977,-1,514,2978,2979,-1,514,2980,2978,-1,2981,518,2982,-1,2981,2983,518,-1,520,1653,517,-1,1653,520,1652,-1,537,547,538,-1,2153,547,537,-1,2984,527,2159,-1,2984,1145,527,-1,1552,2985,2472,-1,1636,2985,1552,-1,2986,567,2149,-1,2986,2987,567,-1,2988,2148,2147,-1,2988,2989,2148,-1,2148,558,557,-1,2148,2475,558,-1,2989,2990,2991,-1,2990,2989,2988,-1,2144,2150,2992,-1,2144,2151,2150,-1,2993,2994,2995,-1,2996,2994,2993,-1,2996,2142,2994,-1,2997,2142,2996,-1,2997,2143,2142,-1,2998,2143,2997,-1,2998,2999,2143,-1,3000,2999,2998,-1,3000,3001,2999,-1,3000,3002,3001,-1,3003,3004,3005,-1,3003,3006,3004,-1,3007,3008,3009,-1,3008,3007,2141,-1,3010,2992,3011,-1,2144,2992,3010,-1,3012,3013,3014,-1,3012,3015,3013,-1,2476,3016,3017,-1,3016,2476,3018,-1,571,3019,3020,-1,571,570,3019,-1,3021,3022,3023,-1,3022,3021,3024,-1,3025,3026,3027,-1,3025,3028,3026,-1,3029,3030,3031,-1,3029,3032,3030,-1,3033,3034,3035,-1,3034,3033,3036,-1,3037,3038,3039,-1,3038,3037,3040,-1,2991,3041,3042,-1,2991,2990,3041,-1,3043,3044,3045,-1,3044,3043,3046,-1,3047,3048,3049,-1,3047,3050,3048,-1,3051,3052,3053,-1,3051,3054,3052,-1,3055,3056,3057,-1,3055,3058,3056,-1,3059,3060,3061,-1,3062,3060,3059,-1,3063,3064,3065,-1,3066,3064,3063,-1,2100,2252,649,-1,2477,2252,2100,-1,610,3067,3068,-1,2137,3067,610,-1,3069,3070,628,-1,3069,3071,3070,-1,2131,611,3072,-1,2138,611,2131,-1,2129,2127,2479,-1,2128,2127,2129,-1,606,2126,2130,-1,2126,606,613,-1,608,326,2480,-1,608,607,326,-1,3068,611,610,-1,600,611,3068,-1,614,2123,612,-1,2123,614,619,-1,3068,601,600,-1,601,3068,584,-1,584,623,601,-1,623,584,624,-1,2115,3073,2117,-1,2115,2118,3073,-1,2117,2116,2115,-1,2116,2117,2114,-1,3069,594,3074,-1,3069,628,594,-1,3075,2113,3076,-1,3075,3077,2113,-1,3078,2111,3079,-1,3078,2112,2111,-1,596,592,597,-1,596,2478,592,-1,3079,2109,3080,-1,3079,2111,2109,-1,591,597,592,-1,3081,597,591,-1,3080,605,604,-1,3080,2109,605,-1,2136,3081,591,-1,2133,3081,2136,-1,417,2211,2108,-1,2211,417,2209,-1,638,2103,2482,-1,638,2481,2103,-1,3082,3083,3084,-1,2095,3083,3082,-1,2097,3085,2098,-1,2097,3086,3085,-1,2775,2090,2484,-1,2775,3087,2090,-1,3088,646,3087,-1,3088,3086,646,-1,3085,3088,2976,-1,3085,3086,3088,-1,3089,643,642,-1,3089,3090,643,-1,643,3083,2106,-1,3090,3083,643,-1,3091,3084,3092,-1,3091,3082,3084,-1,3093,3091,3094,-1,3093,3082,3091,-1,3095,3094,2091,-1,3095,3093,3094,-1,2091,645,3095,-1,2090,645,2091,-1,3096,2953,2952,-1,3097,2953,3096,-1,2487,669,2485,-1,2487,3098,669,-1,3099,2222,2084,-1,2799,2222,3099,-1,681,711,709,-1,711,681,2089,-1,668,718,663,-1,668,2083,718,-1,2489,2082,693,-1,2082,2489,729,-1,2771,697,696,-1,697,2771,686,-1,689,2077,690,-1,3100,2077,689,-1,3100,702,2077,-1,676,702,3100,-1,2071,695,2075,-1,2071,2069,695,-1,2066,675,708,-1,675,2066,701,-1,2064,2070,3101,-1,2064,2068,2070,-1,3101,713,2064,-1,2062,713,3101,-1,3102,714,2057,-1,3102,2769,714,-1,2057,2767,3102,-1,725,2767,2057,-1,2056,2054,2059,-1,2056,2055,2054,-1,3103,726,3104,-1,3103,2766,726,-1,2758,3105,3106,-1,3105,2758,3107,-1,2493,2051,2017,-1,2493,2052,2051,-1,2049,3108,3109,-1,2049,2048,3108,-1,776,2037,2036,-1,776,2495,2037,-1,2500,3110,2762,-1,3110,2500,3111,-1,3112,2759,2761,-1,3113,2759,3112,-1,2762,2046,758,-1,2046,2762,3110,-1,3114,2044,3115,-1,2044,3114,2763,-1,3116,3117,3118,-1,3116,3119,3117,-1,744,3120,3121,-1,743,3120,744,-1,782,2043,2042,-1,782,3122,2043,-1,3123,3124,3125,-1,3123,3126,3124,-1,2498,2041,2036,-1,2497,2041,2498,-1,737,2499,736,-1,2499,737,2028,-1,2033,2040,2039,-1,2033,2032,2040,-1,2761,3127,3128,-1,3127,2761,2760,-1,754,2029,2027,-1,754,756,2029,-1,2027,3129,2499,-1,2029,3129,2027,-1,746,753,2034,-1,753,746,2031,-1,2039,3128,3127,-1,2039,2497,3128,-1,2019,3130,2020,-1,2019,3131,3130,-1,3119,3132,2023,-1,3121,3132,3119,-1,3133,2046,3115,-1,3133,2045,2046,-1,3134,3135,3136,-1,3134,3137,3135,-1,3138,3139,3140,-1,3138,3141,3139,-1,3142,3143,3144,-1,3142,2504,3143,-1,3145,3146,761,-1,3146,3145,3147,-1,2510,3139,2631,-1,2510,3140,3139,-1,3108,3138,3106,-1,3138,3108,3141,-1,2504,3148,733,-1,3142,3148,2504,-1,3149,3107,2755,-1,3149,3105,3107,-1,2050,773,2014,-1,2050,2494,773,-1,2015,741,738,-1,2015,2014,741,-1,2495,765,2013,-1,769,765,2495,-1,1996,3150,800,-1,3151,3150,1996,-1,3152,3153,3154,-1,3155,3153,3152,-1,3156,3157,3158,-1,3157,3156,3159,-1,2011,805,3160,-1,2011,806,805,-1,779,783,805,-1,784,783,779,-1,3158,3161,3156,-1,3162,3161,3158,-1,3163,3156,3161,-1,3163,3164,3156,-1,785,3165,3166,-1,785,3167,3165,-1,3168,3164,3163,-1,3168,3169,3164,-1,3165,3170,3171,-1,3167,3170,3165,-1,3172,3125,3173,-1,3123,3125,3172,-1,2005,2754,3174,-1,2754,2005,787,-1,3173,3175,3176,-1,3125,3175,3173,-1,3174,2006,2005,-1,3174,3177,2006,-1,3175,3178,3176,-1,3175,3179,3178,-1,3177,2002,2006,-1,3177,2507,2002,-1,3180,3179,2765,-1,3179,3180,3178,-1,2001,3150,3181,-1,2001,2508,3150,-1,2004,2753,2003,-1,2004,795,2753,-1,745,804,2000,-1,745,802,804,-1,797,3182,3183,-1,796,3182,797,-1,3184,3162,3158,-1,3185,3162,3184,-1,1673,2631,1159,-1,2631,1673,2510,-1,807,3143,1993,-1,3143,807,3144,-1,2502,763,2632,-1,763,2502,2501,-1,2721,1989,1854,-1,1989,2721,2720,-1,954,3186,2513,-1,3186,954,3187,-1,1973,1983,1982,-1,1973,1975,1983,-1,1978,3188,2514,-1,3188,1978,839,-1,2587,1153,1152,-1,1153,2587,1972,-1,843,827,1984,-1,843,842,827,-1,845,1979,846,-1,845,1977,1979,-1,834,3189,835,-1,2517,3189,834,-1,849,3190,2748,-1,849,1969,3190,-1,1968,1963,2519,-1,1963,1968,2518,-1,2520,1967,841,-1,2520,1962,1967,-1,872,1965,873,-1,872,2520,1965,-1,866,877,863,-1,866,878,877,-1,881,1960,889,-1,1960,881,869,-1,2521,893,895,-1,2521,1957,893,-1,891,3191,861,-1,3191,891,3192,-1,2525,3193,3194,-1,2525,2524,3193,-1,3195,3196,3197,-1,3195,3198,3196,-1,3199,3192,3200,-1,3199,3191,3192,-1,3201,3202,3203,-1,3201,3204,3202,-1,3205,3206,3207,-1,3206,3205,3208,-1,3209,2747,903,-1,2747,3209,3210,-1,3211,3212,3213,-1,3211,3214,3212,-1,3215,3216,3217,-1,3218,3216,3215,-1,902,3219,903,-1,902,3220,3219,-1,3221,3215,3217,-1,3215,3221,3222,-1,3220,3223,3219,-1,3220,3224,3223,-1,3225,3222,3221,-1,3222,3225,3226,-1,3224,3206,3223,-1,3224,3227,3206,-1,3228,3225,3229,-1,3226,3225,3228,-1,3227,3207,3206,-1,3227,3230,3207,-1,3231,3229,3232,-1,3228,3229,3231,-1,3207,3233,3234,-1,3207,3230,3233,-1,3235,3232,3236,-1,3231,3232,3235,-1,3234,3237,3238,-1,3234,3233,3237,-1,3239,3236,3240,-1,3235,3236,3239,-1,3238,3241,1952,-1,3238,3237,3241,-1,3242,3239,3240,-1,3239,3242,3243,-1,3244,3243,3242,-1,3243,3244,3245,-1,1950,1953,3246,-1,1953,1950,3247,-1,3248,3245,3244,-1,3245,3248,3249,-1,3201,3250,3251,-1,3201,3203,3250,-1,909,3213,910,-1,909,3211,3213,-1,3203,3252,3250,-1,3203,3253,3252,-1,3254,948,1936,-1,3254,3255,948,-1,3256,917,2528,-1,920,917,3256,-1,3257,3258,3259,-1,3257,3255,3258,-1,3260,921,3261,-1,3262,921,3260,-1,1578,1942,1945,-1,1578,936,1942,-1,3263,2660,3264,-1,3263,2656,2660,-1,1584,3265,2667,-1,931,3265,1584,-1,1947,2530,2665,-1,2529,2530,1947,-1,3266,1947,1946,-1,3266,2529,1947,-1,1946,3267,3266,-1,3267,1946,1945,-1,3268,1938,2659,-1,1938,3268,3269,-1,3269,1939,1938,-1,1939,3269,3260,-1,1944,3270,1941,-1,3270,1944,3271,-1,2531,1592,2742,-1,1592,2531,1593,-1,3272,2741,946,-1,3272,942,2741,-1,3273,3274,3272,-1,3275,3274,3273,-1,912,914,913,-1,912,2533,914,-1,3276,3277,3278,-1,3277,3276,3279,-1,955,2751,956,-1,2751,955,3280,-1,824,3281,3282,-1,3187,3281,824,-1,3283,3281,3284,-1,3283,3282,3281,-1,3285,2534,3286,-1,3285,2535,2534,-1,3287,3288,3289,-1,3288,3287,2538,-1,2736,957,1934,-1,2536,957,2736,-1,968,3284,973,-1,3283,3284,968,-1,3290,3291,3292,-1,3291,3293,3294,-1,3291,3290,3293,-1,1934,972,2736,-1,1934,1933,972,-1,3295,1927,3296,-1,1927,3295,3297,-1,1610,2549,1611,-1,1610,1929,2549,-1,3298,3299,3300,-1,1930,3299,3298,-1,3301,3302,3303,-1,3302,3301,1928,-1,3304,3291,3305,-1,3306,3291,3304,-1,3291,3306,3307,-1,3308,3309,3310,-1,3308,3311,3309,-1,3312,3313,3314,-1,3312,3307,3313,-1,979,1926,1596,-1,978,1926,979,-1,3313,1933,2738,-1,3313,2543,1933,-1,2543,3304,965,-1,3306,3304,2543,-1,1925,2542,2546,-1,2542,1925,1595,-1,962,2537,960,-1,962,3303,2537,-1,2544,3315,3316,-1,3317,3315,2544,-1,3316,3318,1922,-1,3315,3318,3316,-1,3318,1923,1922,-1,3318,3319,1923,-1,3294,3320,3319,-1,3294,3293,3320,-1,3276,986,988,-1,3276,3278,986,-1,987,2730,1921,-1,2548,2730,987,-1,3321,3322,3323,-1,3321,3324,3322,-1,3324,3308,3322,-1,3324,3325,3308,-1,812,819,1988,-1,812,2676,819,-1,1853,1987,2750,-1,1853,1989,1987,-1,822,1989,2720,-1,822,1987,1989,-1,2515,1976,1266,-1,1976,2515,1980,-1,1971,1982,1916,-1,1982,1971,1973,-1,1980,1268,1981,-1,1980,2515,1268,-1,1801,1269,1799,-1,1801,1267,1269,-1,1862,2586,549,-1,2706,2586,1862,-1,1910,1014,2552,-1,1910,1015,1014,-1,3326,1885,1884,-1,1913,1885,3326,-1,1906,1907,1833,-1,1908,1907,1906,-1,1482,3327,3328,-1,1484,3327,1482,-1,2585,3329,3330,-1,2584,3329,2585,-1,2707,1290,2708,-1,2707,3331,1290,-1,2708,1289,1858,-1,2708,1290,1289,-1,2557,1142,3332,-1,2557,1864,1142,-1,1256,1084,1679,-1,1256,3333,1084,-1,1049,1350,1050,-1,1350,1049,3334,-1,3335,3336,3337,-1,3338,3336,3335,-1,1454,1759,2558,-1,1454,1760,1759,-1,1897,1703,1691,-1,1347,1703,1897,-1,3339,1132,3340,-1,1132,3339,1133,-1,2680,1771,1445,-1,2680,1772,1771,-1,3341,3342,3343,-1,3342,3341,3344,-1,3345,3346,3347,-1,3348,3346,3345,-1,1892,3349,3350,-1,1892,1080,3349,-1,1340,1080,1079,-1,1340,3349,1080,-1,3327,3351,3350,-1,3327,3352,3351,-1,2722,1327,2675,-1,2722,1773,1327,-1,1325,2565,3353,-1,1325,1091,2565,-1,1016,1098,1097,-1,1098,1016,1100,-1,3354,2569,1215,-1,2569,3354,1028,-1,1291,1875,1292,-1,1291,1120,1875,-1,2574,2571,2575,-1,2574,2572,2571,-1,1129,2579,1130,-1,1129,2580,2579,-1,1279,1287,1065,-1,1287,1279,2582,-1,3355,3356,2469,-1,3356,3355,3357,-1,2597,3342,3358,-1,3342,2597,3359,-1,1792,3360,3361,-1,3360,1792,1475,-1,3348,3355,2469,-1,3348,3345,3355,-1,3362,2699,3363,-1,3362,3364,2699,-1,2722,2612,1889,-1,2612,2722,1813,-1,1813,1851,2612,-1,1851,1813,1850,-1,2632,1160,1159,-1,762,1160,2632,-1,1700,22,3365,-1,1700,2399,22,-1,1181,1841,1179,-1,1181,1183,1841,-1,1845,1354,1177,-1,1845,1755,1354,-1,1915,557,1608,-1,1915,565,557,-1,1818,2629,1695,-1,2629,1818,1466,-1,1104,1677,1684,-1,1678,1677,1104,-1,1014,1097,2551,-1,1014,1016,1097,-1,3366,1215,1214,-1,3366,3354,1215,-1,3367,2607,1311,-1,2607,3367,3368,-1,3369,2704,1743,-1,2704,3369,2703,-1,1698,1360,1754,-1,1698,1355,1360,-1,1857,1752,1757,-1,1752,1857,3364,-1,1817,3370,1828,-1,1199,3370,1817,-1,3371,1200,3372,-1,1200,3371,1836,-1,3373,3369,2615,-1,3373,3374,3369,-1,3352,3375,3351,-1,3375,3352,3376,-1,1675,1825,1850,-1,1675,1251,1825,-1,3377,1822,3378,-1,1823,1822,3377,-1,3379,3380,3381,-1,3380,3379,3382,-1,1116,3381,1255,-1,3381,1116,3379,-1,1264,1197,1262,-1,3363,1197,1264,-1,1329,1814,1854,-1,1329,2564,1814,-1,1227,2557,2701,-1,1474,2557,1227,-1,3383,3384,3385,-1,3386,3384,3383,-1,2711,1806,1309,-1,2711,1865,1806,-1,2595,1793,1682,-1,2879,1793,2595,-1,1680,1156,1095,-1,1680,1155,1156,-1,1789,2691,3387,-1,1790,2691,1789,-1,2574,2715,2572,-1,2574,1127,2715,-1,1797,1788,1712,-1,2630,1788,1797,-1,1145,1044,1146,-1,1145,2984,1044,-1,1139,2581,1829,-1,2581,1139,1138,-1,1795,2570,2306,-1,1795,1794,2570,-1,2573,2602,1131,-1,2602,2573,2603,-1,1807,1683,2438,-1,1809,1683,1807,-1,1866,3388,1135,-1,1866,3340,3388,-1,3345,3389,3355,-1,3345,1074,3389,-1,2586,1151,2584,-1,2586,1149,1151,-1,1125,2578,1873,-1,2578,1125,2718,-1,1121,1878,1294,-1,1121,1291,1878,-1,2575,1130,2579,-1,2575,2571,1130,-1,1284,1129,1131,-1,1129,1284,1872,-1,3387,1295,2605,-1,3387,2691,1295,-1,1784,1473,1472,-1,1784,1783,1473,-1,1871,1309,1308,-1,1309,1871,2710,-1,1226,1901,1474,-1,1226,1231,1901,-1,1779,3390,3391,-1,3390,1779,1314,-1,3392,1777,1471,-1,1777,3392,1321,-1,3392,1320,1321,-1,1778,1320,3392,-1,1148,1489,1672,-1,1147,1489,1148,-1,1443,1025,1024,-1,1025,1443,1026,-1,2725,1681,2604,-1,2725,1071,1681,-1,1073,1903,1810,-1,1073,1039,1903,-1,2681,2441,1900,-1,2681,1442,2441,-1,2726,2559,1705,-1,2559,2726,1050,-1,1347,2781,2782,-1,1347,1346,2781,-1,1618,2558,1899,-1,2558,1618,2658,-1,1234,1367,2698,-1,1363,1367,1234,-1,1372,1236,2617,-1,1233,1236,1372,-1,1828,2588,1740,-1,1828,3370,2588,-1,3393,1378,1377,-1,3393,1751,1378,-1,3373,2616,3394,-1,3373,1748,2616,-1,1740,2618,1741,-1,1740,1193,2618,-1,3394,1746,2617,-1,3394,2616,1746,-1,1359,2614,1758,-1,2614,1359,1358,-1,1738,1904,1737,-1,1331,1904,1738,-1,1381,1440,2685,-1,1440,1381,1450,-1,2621,1735,1734,-1,2620,1735,2621,-1,1384,2622,1396,-1,1384,1733,2622,-1,1387,3395,1389,-1,3395,1387,3396,-1,3397,2620,3398,-1,3397,1735,2620,-1,1731,2622,3399,-1,1732,2622,1731,-1,3395,1408,3400,-1,1408,3395,2684,-1,1402,3397,3401,-1,1402,3402,3397,-1,1732,1427,1730,-1,1732,1731,1427,-1,1391,1727,1448,-1,1727,1391,1383,-1,1347,2627,2687,-1,1347,2782,2627,-1,1439,1419,1715,-1,1725,1419,1439,-1,3403,1449,3404,-1,1724,1449,3403,-1,2681,1727,1393,-1,1727,2681,3405,-1,2626,1718,1436,-1,3406,1718,2626,-1,1722,1721,1729,-1,1721,1722,1426,-1,1412,2682,1403,-1,1412,3407,2682,-1,1407,1717,1716,-1,1407,1406,1717,-1,1896,1763,1052,-1,1763,1896,2613,-1,1726,1724,3403,-1,1726,1725,1724,-1,2442,1442,1714,-1,2441,1442,2442,-1,1573,1762,1455,-1,1762,1573,1572,-1,1694,1822,1818,-1,1822,1694,3378,-1,1707,1709,2679,-1,1707,1060,1709,-1,2678,1707,296,-1,1707,2678,1058,-1,2686,1761,1453,-1,2686,1351,1761,-1,1183,1417,1701,-1,1182,1417,1183,-1,1463,1696,1695,-1,1696,1463,1204,-1,1835,1241,1461,-1,2589,1241,1835,-1,1232,1241,2589,-1,2569,1252,1216,-1,2569,1834,1252,-1,1176,1188,1187,-1,1176,1690,1188,-1,1242,1688,833,-1,1688,1242,1468,-1,1753,3364,3362,-1,1752,3364,1753,-1,1131,3384,1284,-1,2602,3384,1131,-1,2570,1467,1115,-1,2570,1877,1467,-1,1306,1298,1299,-1,1306,1783,1298,-1,1142,2582,1045,-1,1142,1141,2582,-1,1861,2706,1862,-1,1861,2707,2706,-1,1887,1087,1086,-1,1887,1256,1087,-1,1161,1248,1166,-1,1248,1161,1249,-1,1529,1670,1669,-1,1529,1667,1670,-1,2638,1526,1649,-1,1526,2638,1663,-1,3408,1664,3409,-1,1664,3408,1666,-1,2637,1663,2638,-1,2637,3410,1663,-1,3411,3408,3412,-1,3408,3411,3413,-1,3414,1505,1662,-1,3410,1505,3414,-1,3412,3415,3411,-1,3412,3416,3415,-1,3417,3418,3419,-1,3418,3417,3416,-1,1504,2639,1657,-1,1503,2639,1504,-1,3420,1660,3421,-1,3420,2640,1660,-1,2645,3422,1522,-1,3422,2645,3420,-1,1659,1516,3423,-1,1659,1658,1516,-1,1510,2474,543,-1,1510,2642,2474,-1,1658,2643,1517,-1,1658,2641,2643,-1,1651,529,531,-1,2644,529,1651,-1,3424,2646,3425,-1,2647,2646,3424,-1,2642,2152,2474,-1,2642,3426,2152,-1,1494,1646,3427,-1,1649,1646,1494,-1,3428,1671,3429,-1,1671,3428,1668,-1,3429,3430,3431,-1,3432,3430,3429,-1,1531,1547,1645,-1,1531,1551,1547,-1,1644,1648,1632,-1,1648,1644,1532,-1,3431,3433,3434,-1,3430,3433,3431,-1,1561,1643,1559,-1,1643,1561,3435,-1,2673,3436,2674,-1,2673,3437,3436,-1,1643,3438,1642,-1,3438,1643,3439,-1,1537,3440,1641,-1,1537,3438,3440,-1,3440,3441,3442,-1,3440,3443,3441,-1,3441,2672,3444,-1,3441,3445,2672,-1,2649,2648,3446,-1,2649,1640,2648,-1,3447,2650,3448,-1,3447,1637,2650,-1,2650,1493,1492,-1,2650,1638,1493,-1,2651,3449,1636,-1,3449,2651,1497,-1,3450,2653,3451,-1,3450,1492,2653,-1,3449,3452,3453,-1,3452,3449,3454,-1,1557,3451,1554,-1,1557,2671,3451,-1,3452,2654,3455,-1,2654,3452,1631,-1,3437,1553,3436,-1,3437,1558,1553,-1,582,1574,1570,-1,582,1572,1574,-1,1625,1617,1624,-1,1625,2658,1617,-1,2530,2655,2665,-1,2530,1586,2655,-1,1569,1571,1570,-1,1571,1569,2666,-1,3456,3457,3458,-1,3459,3457,3456,-1,3458,1602,2662,-1,3457,1602,3458,-1,3457,1600,1602,-1,1599,1600,3457,-1,1596,2540,979,-1,2540,1596,983,-1,1582,2666,1594,-1,1582,1571,2666,-1,1579,3460,2659,-1,1579,2663,3460,-1,1590,3461,2664,-1,3461,1590,927,-1,1575,927,1590,-1,927,1575,2744,-1,3436,1555,3462,-1,3436,1553,1555,-1,3455,1555,2669,-1,1555,3455,2654,-1,2668,2671,1557,-1,2668,2670,2671,-1,3453,3455,1491,-1,3455,3453,3452,-1,3451,1635,3450,-1,2671,1635,3451,-1,1636,3453,2985,-1,3453,1636,3449,-1,3448,3463,3447,-1,2652,3463,3448,-1,1637,3446,1548,-1,3447,3446,1637,-1,1548,2648,3464,-1,3446,2648,1548,-1,3445,1546,2672,-1,3445,3433,1546,-1,3442,1641,3440,-1,3464,1641,3442,-1,3439,3440,3438,-1,3440,3439,3443,-1,1540,2674,1535,-1,1540,2673,2674,-1,3435,3439,1643,-1,3439,3435,3465,-1,2674,3462,1536,-1,2674,3436,3462,-1,1538,1639,1556,-1,1538,1543,1639,-1,1538,1544,1543,-1,3466,3434,3467,-1,3431,3434,3466,-1,1645,1546,3468,-1,1645,1547,1546,-1,3432,3468,3430,-1,3427,3468,3432,-1,1527,1668,3428,-1,1668,1527,1669,-1,1495,3427,3432,-1,1494,3427,1495,-1,3469,2647,3426,-1,3469,2645,2647,-1,3424,1650,2154,-1,3424,3425,1650,-1,1654,1518,1517,-1,1518,1654,530,-1,3470,1496,1656,-1,2639,1496,3470,-1,3417,1522,3422,-1,3417,1519,1522,-1,3420,3415,3422,-1,3415,3420,3421,-1,1504,1659,1661,-1,1504,1657,1659,-1,1662,3471,3472,-1,1662,1661,3471,-1,3421,3411,3415,-1,3411,3421,3473,-1,3474,1662,3472,-1,3414,1662,3474,-1,3473,3413,3411,-1,3413,3473,3475,-1,1502,2635,3476,-1,2635,1502,2634,-1,1499,3410,3414,-1,1663,3410,1499,-1,3413,1666,3408,-1,1666,3413,1667,-1,1888,1483,2723,-1,1888,1162,1483,-1,2565,2511,2721,-1,2511,2565,1093,-1,3477,1013,1303,-1,3477,1011,1013,-1,1303,1212,1304,-1,1303,1013,1212,-1,1477,1095,1263,-1,1477,1096,1095,-1,2585,549,2586,-1,2585,2724,549,-1,1683,1830,1869,-1,1809,1830,1683,-1,1782,2580,2712,-1,1782,1786,2580,-1,1786,1296,1798,-1,1786,1785,1296,-1,2718,1796,2578,-1,1794,1796,2718,-1,1209,1235,1202,-1,1209,1208,1235,-1,1201,1697,1205,-1,1697,1201,1835,-1,1728,1457,1344,-1,1720,1457,1728,-1,2687,1420,1343,-1,2687,2627,1420,-1,3478,3479,3480,-1,3478,3335,3479,-1,1898,1763,1348,-1,1898,1053,1763,-1,2628,2623,2682,-1,1839,2623,2628,-1,1432,1729,1405,-1,1729,1432,1722,-1,1415,1430,1720,-1,1431,1430,1415,-1,1411,1716,1423,-1,1716,1411,1407,-1,1714,2262,2442,-1,2262,1714,1009,-1,3481,1449,1448,-1,3481,3404,1449,-1,2627,583,1713,-1,2627,2782,583,-1,3338,1607,1051,-1,3338,2683,1607,-1,1410,1407,1411,-1,1410,1408,1407,-1,3401,3398,1409,-1,3401,3397,3398,-1,3396,2684,3395,-1,2684,3396,3482,-1,1401,3399,3483,-1,1731,3399,1401,-1,3398,2619,3484,-1,3398,2620,2619,-1,1386,3396,1387,-1,3396,1386,3485,-1,1733,3399,2622,-1,1733,1392,3399,-1,1733,1383,1391,-1,1383,1733,1384,-1,1380,2625,1362,-1,2625,1380,2685,-1,2625,1440,1439,-1,2625,2685,1440,-1,1237,1356,1355,-1,1356,1237,1366,-1,3371,1749,3393,-1,3371,3372,1749,-1,1379,3393,1377,-1,1379,3371,3393,-1,2618,574,1373,-1,2618,572,574,-1,1191,3370,3486,-1,3370,1191,2588,-1,1572,1896,1762,-1,1896,1572,582,-1,1345,2687,1343,-1,2687,1345,1703,-1,3346,3487,3330,-1,3346,3488,3487,-1,1810,1902,1772,-1,1903,1902,1810,-1,1083,1327,1035,-1,1083,1328,1327,-1,3489,1911,2552,-1,3490,1911,3489,-1,2722,1036,1773,-1,1036,2722,1889,-1,1319,1486,1323,-1,1486,1319,1318,-1,3368,1778,3392,-1,1315,1778,3368,-1,1315,3367,1316,-1,1315,3368,3367,-1,1781,2607,1471,-1,1781,1224,2607,-1,1308,2713,1870,-1,2713,1308,1782,-1,1124,1876,2719,-1,1124,1292,1876,-1,2577,1126,1874,-1,2577,2716,1126,-1,1123,1873,1300,-1,1873,1123,1125,-1,1337,1038,2610,-1,1337,1336,1038,-1,2599,3359,2597,-1,2599,3491,3359,-1,2598,3360,2599,-1,3360,2598,3492,-1,1871,2562,2710,-1,2562,1871,2714,-1,3385,2602,2601,-1,3384,2602,3385,-1,1805,2714,1285,-1,2714,1805,2562,-1,1139,1766,1282,-1,1139,1831,1766,-1,1676,1011,3477,-1,1276,1011,1676,-1,1788,2596,3493,-1,2596,1788,2630,-1,2573,2715,2717,-1,2572,2715,2573,-1,3387,2696,1789,-1,3387,3493,2696,-1,3362,1803,1753,-1,3362,1804,1803,-1,1864,1140,1142,-1,1864,1261,1140,-1,1041,1895,2563,-1,1041,1040,1895,-1,1255,1694,1254,-1,3381,1694,1255,-1,3378,1694,3381,-1,3380,3378,3381,-1,3377,3378,3380,-1,1161,1165,1852,-1,1161,1166,1165,-1,3494,1854,813,-1,1812,1854,3494,-1,1854,1812,1329,-1,1164,808,2697,-1,1164,1824,808,-1,449,1894,1077,-1,1894,449,2677,-1,3394,3374,3373,-1,3495,3374,3394,-1,3372,1816,3496,-1,1816,3372,1200,-1,2700,1198,1197,-1,2700,3497,1198,-1,1754,1359,1686,-1,1359,1754,1360,-1,1236,1208,3495,-1,1208,1236,1235,-1,1819,1743,2704,-1,1819,1744,1743,-1,2701,1228,1227,-1,2701,2633,1228,-1,1217,2694,1218,-1,3344,2694,1217,-1,1905,2568,1906,-1,1905,1881,2568,-1,2567,1099,1098,-1,1211,1099,2567,-1,1016,1331,1101,-1,1015,1331,1016,-1,2629,1210,1209,-1,1210,2629,2703,-1,1206,1696,1204,-1,1696,1206,1207,-1,1173,1354,1174,-1,1354,1173,1177,-1,1172,1169,1184,-1,1172,1167,1169,-1,1700,1840,1701,-1,1700,3365,1840,-1,1155,1157,1156,-1,1155,1154,1157,-1,2599,1475,1446,-1,3360,1475,2599,-1,3498,1076,1075,-1,1338,1076,3498,-1,3331,2692,1290,-1,3331,3343,2692,-1,473,3357,3492,-1,473,3356,3357,-1,1135,1070,1136,-1,1135,3388,1070,-1,1127,2716,2715,-1,2716,1127,1126,-1,1214,2555,3366,-1,2555,1214,1909,-1,3499,1324,1882,-1,3499,1031,1324,-1,2287,2591,2288,-1,1115,2591,2287,-1,1022,1025,2554,-1,1025,1022,1024,-1,2728,1913,3326,-1,2728,1017,1913,-1,1085,3353,1086,-1,1325,3353,1085,-1,3488,1040,3487,-1,3488,1895,1040,-1,1077,3351,3375,-1,3351,1077,1893,-1,3348,3488,3346,-1,2792,3488,3348,-1,1076,1071,2725,-1,1072,1071,1076,-1,1768,2694,1769,-1,1768,1281,2694,-1,1064,2581,1286,-1,2581,1064,1063,-1,3359,3343,3342,-1,3343,3359,2692,-1,3344,1769,2694,-1,1769,3344,3341,-1,1133,2561,2560,-1,1133,3339,2561,-1,2686,2678,1706,-1,2678,2686,1453,-1,1061,1704,1059,-1,1061,1760,1704,-1,3338,2726,3336,-1,1051,2726,3338,-1,1349,1050,1350,-1,1349,2559,1050,-1,3332,1045,1044,-1,3332,1142,1045,-1,3331,1861,2583,-1,1861,3331,2707,-1,1827,3376,3352,-1,1827,1826,3376,-1,2584,3498,3329,-1,1151,3498,2584,-1,1336,1039,1038,-1,1336,1903,1039,-1,2689,1889,1888,-1,2689,1036,1889,-1,1880,3366,2555,-1,1880,1879,3366,-1,1027,2727,1030,-1,2727,1027,1026,-1,2566,2554,2553,-1,2566,1106,2554,-1,1884,3500,3326,-1,1884,1886,3500,-1,1021,3490,1480,-1,3490,1021,1020,-1,1860,2610,1149,-1,1337,2610,1860,-1,826,2516,1917,-1,826,825,2516,-1,1982,1917,1916,-1,1982,826,1917,-1,1976,2587,1266,-1,1976,2514,2587,-1,2513,1919,810,-1,2513,3186,1919,-1,2750,2608,1853,-1,2750,3501,2608,-1,1988,810,812,-1,1988,2513,810,-1,3322,3310,2731,-1,3322,3308,3310,-1,998,995,1920,-1,995,998,993,-1,3321,3292,3324,-1,3290,3292,3321,-1,996,987,1921,-1,987,996,988,-1,3320,3290,3321,-1,3293,3290,3320,-1,1604,912,989,-1,1604,2533,912,-1,1923,3320,3502,-1,3319,3320,1923,-1,3503,3319,3318,-1,3503,3294,3319,-1,3315,3503,3318,-1,3504,3503,3315,-1,3317,3504,3315,-1,3305,3504,3317,-1,965,3305,3317,-1,3304,3305,965,-1,2546,1927,3297,-1,1927,2546,2542,-1,981,3505,982,-1,981,985,3505,-1,3313,3306,2543,-1,3307,3306,3313,-1,3300,3309,2541,-1,3300,3299,3309,-1,3506,1002,1001,-1,3506,3507,1002,-1,3299,3310,3309,-1,3299,2734,3310,-1,991,999,3456,-1,990,999,991,-1,990,994,999,-1,3505,1597,3507,-1,3505,985,1597,-1,987,2549,2548,-1,1611,2549,987,-1,3303,3295,2537,-1,3295,3303,3302,-1,1930,2734,3299,-1,976,2734,1930,-1,3302,3297,3295,-1,3297,3302,1613,-1,2538,2545,961,-1,2538,3287,2545,-1,2735,968,973,-1,969,968,2735,-1,3294,3305,3291,-1,3503,3305,3294,-1,3305,3503,3504,-1,2737,3283,968,-1,3508,3283,2737,-1,971,2536,2736,-1,2534,2536,971,-1,2538,959,3288,-1,959,2538,966,-1,965,972,2543,-1,972,965,964,-1,961,2544,962,-1,961,2545,2544,-1,3509,3286,3289,-1,3509,3285,3286,-1,3510,957,956,-1,957,3510,3511,-1,2740,3281,958,-1,3284,3281,2740,-1,3187,958,3281,-1,954,958,3187,-1,956,1986,3510,-1,1986,956,2751,-1,817,3285,3509,-1,816,3285,817,-1,922,3276,988,-1,922,3279,3276,-1,1615,2528,1583,-1,1615,3256,2528,-1,3274,942,3272,-1,3274,3512,942,-1,2532,2742,1592,-1,2532,3271,2742,-1,3512,939,942,-1,3512,3513,939,-1,3271,1943,2742,-1,3271,1944,1943,-1,3514,934,940,-1,3514,3515,934,-1,3515,2743,934,-1,3515,3516,2743,-1,3516,930,2743,-1,3516,3517,930,-1,1588,2665,1589,-1,1947,2665,1588,-1,932,1586,2530,-1,932,1584,1586,-1,926,2744,925,-1,2744,926,928,-1,3264,3518,3263,-1,3519,3518,3264,-1,1945,1940,3267,-1,1945,1942,1940,-1,3520,3260,3269,-1,3520,3262,3260,-1,3259,1948,3257,-1,1948,3259,929,-1,923,2528,917,-1,923,924,2528,-1,918,920,951,-1,918,917,920,-1,3520,1936,3277,-1,3520,3254,1936,-1,3216,3250,3252,-1,3521,3250,3216,-1,910,901,1949,-1,910,3213,901,-1,3521,3251,3250,-1,3248,3251,3521,-1,908,3522,909,-1,908,3523,3522,-1,3247,2526,1953,-1,3247,3204,2526,-1,906,3523,908,-1,906,3200,3523,-1,3241,2746,3246,-1,3241,904,2746,-1,2745,3240,3524,-1,3240,2745,3242,-1,3237,904,3241,-1,3237,3525,904,-1,3240,3526,3524,-1,3236,3526,3240,-1,3233,3525,3237,-1,3233,3527,3525,-1,3236,3528,3526,-1,3232,3528,3236,-1,3230,3527,3233,-1,3230,3529,3527,-1,3232,3530,3528,-1,3229,3530,3232,-1,3227,3529,3230,-1,3227,3531,3529,-1,3229,3532,3530,-1,3225,3532,3229,-1,3533,3227,3224,-1,3533,3531,3227,-1,3532,3221,3534,-1,3221,3532,3225,-1,3535,3224,3220,-1,3535,3533,3224,-1,3221,3536,3534,-1,3217,3536,3221,-1,3212,3220,902,-1,3212,3535,3220,-1,3252,3217,3216,-1,3252,3536,3217,-1,3213,902,901,-1,3213,3212,902,-1,3210,3537,2747,-1,3537,3210,3202,-1,3208,3223,3206,-1,3223,3208,3538,-1,1952,3539,3238,-1,1952,900,3539,-1,3540,3194,3522,-1,3540,2525,3194,-1,3541,3191,3199,-1,3541,896,3191,-1,3542,3198,3195,-1,3542,894,3198,-1,3543,2525,3540,-1,3543,2523,2525,-1,896,861,3191,-1,896,889,861,-1,3198,893,3544,-1,894,893,3198,-1,892,888,3543,-1,892,886,888,-1,1957,3544,893,-1,1957,880,3544,-1,848,874,873,-1,874,848,864,-1,863,876,864,-1,863,877,876,-1,855,858,856,-1,855,859,858,-1,1962,1966,1967,-1,1962,859,1966,-1,1968,1964,2517,-1,2519,1964,1968,-1,1965,1969,849,-1,1965,840,1969,-1,1966,1979,830,-1,1966,846,1979,-1,839,834,2749,-1,838,834,839,-1,843,1983,1970,-1,843,1984,1983,-1,827,828,825,-1,828,827,829,-1,3186,824,823,-1,3186,3187,824,-1,764,3545,1848,-1,3545,764,3546,-1,3146,1848,3545,-1,1848,3146,1994,-1,3547,3185,3183,-1,3547,3162,3185,-1,3183,801,797,-1,3183,3185,801,-1,1996,3548,3151,-1,1996,1998,3548,-1,3180,792,790,-1,3180,2000,792,-1,790,3178,3180,-1,3178,790,789,-1,2006,2001,2007,-1,2006,2002,2001,-1,3176,789,3549,-1,3176,3178,789,-1,3550,3177,3174,-1,3550,3551,3177,-1,3552,3155,3152,-1,3155,3552,3553,-1,2754,3550,3174,-1,3171,3550,2754,-1,3553,2009,3155,-1,2009,3553,2010,-1,786,3171,2754,-1,3165,3171,786,-1,788,3163,3554,-1,788,3168,3163,-1,3555,3167,785,-1,3555,3556,3167,-1,3554,3161,3557,-1,3554,3163,3161,-1,3555,784,781,-1,3555,785,784,-1,3557,3162,3547,-1,3557,3161,3162,-1,3558,3552,3559,-1,3548,3552,3558,-1,3548,3553,3552,-1,1998,3553,3548,-1,1998,2010,3553,-1,1997,2010,1998,-1,1997,2505,2010,-1,3560,2505,1997,-1,3560,3561,2505,-1,3560,3562,3561,-1,3159,3164,2008,-1,3159,3156,3164,-1,3563,3154,3564,-1,3152,3154,3563,-1,799,1996,800,-1,1996,799,2509,-1,3149,777,3565,-1,2755,777,3149,-1,2014,2051,2050,-1,2015,2051,2014,-1,3105,3566,3109,-1,3566,3105,3149,-1,2053,3142,3567,-1,2053,3148,3142,-1,2048,3141,3108,-1,3141,2048,2503,-1,3140,1991,1990,-1,3140,2510,1991,-1,3145,3568,3147,-1,3145,3567,3568,-1,2503,3546,2501,-1,2503,3569,3546,-1,1990,3138,3140,-1,1990,2757,3138,-1,3137,3570,3135,-1,3137,3113,3570,-1,3110,3115,2046,-1,3115,3110,3114,-1,3119,2022,3117,-1,3119,2023,2022,-1,3131,2759,3130,-1,3131,2760,2759,-1,3132,2761,3571,-1,3112,2761,3132,-1,2034,748,2035,-1,748,2034,753,-1,2497,3572,3128,-1,2497,2498,3572,-1,3573,2760,3131,-1,3127,2760,3573,-1,3124,3175,3125,-1,3124,3574,3175,-1,803,3122,782,-1,803,3118,3122,-1,3575,2765,3179,-1,3575,743,2765,-1,3116,3121,3119,-1,744,3121,3116,-1,3115,2043,3133,-1,2043,3115,2044,-1,3136,3574,3124,-1,3136,3135,3574,-1,3113,3130,2759,-1,3137,3130,3113,-1,3565,2032,3576,-1,2032,3565,2040,-1,777,2036,2041,-1,777,776,2036,-1,766,733,3148,-1,768,733,766,-1,3577,2868,2459,-1,2866,2868,3577,-1,730,726,724,-1,730,3104,726,-1,729,2056,722,-1,729,2489,2056,-1,719,679,721,-1,679,719,682,-1,680,719,2083,-1,682,719,680,-1,2058,714,2492,-1,2058,2057,714,-1,3578,2062,3101,-1,2087,2062,3578,-1,3579,707,2770,-1,3579,2491,707,-1,3101,704,3578,-1,3101,2070,704,-1,2076,697,692,-1,2076,2075,697,-1,3580,696,2078,-1,696,3580,2771,-1,2079,3103,3104,-1,2079,2490,3103,-1,2081,3103,2490,-1,2073,3103,2081,-1,2073,2766,3103,-1,2067,2766,2073,-1,2067,727,2766,-1,2491,727,2067,-1,2491,3581,727,-1,3579,3581,2491,-1,3579,717,3581,-1,717,3579,2768,-1,658,670,661,-1,658,671,670,-1,2084,2223,2085,-1,2222,2223,2084,-1,669,2918,666,-1,3098,2918,669,-1,657,671,658,-1,657,2917,671,-1,3097,3582,2953,-1,3583,3582,3097,-1,2772,2091,3094,-1,2092,2091,2772,-1,2095,2106,3083,-1,2095,2096,2106,-1,3584,411,2794,-1,2934,411,3584,-1,3585,654,2212,-1,3585,3586,654,-1,3587,2975,3588,-1,3587,3589,2975,-1,2893,3088,2773,-1,2893,2976,3088,-1,2775,3088,3087,-1,2773,3088,2775,-1,533,2775,2484,-1,532,2775,533,-1,2774,3086,2097,-1,2774,646,3086,-1,3084,3090,3587,-1,3083,3090,3084,-1,3095,644,2094,-1,644,3095,645,-1,652,335,2108,-1,335,652,337,-1,2135,2127,587,-1,2135,3590,2127,-1,3591,3592,598,-1,3593,3592,3591,-1,3594,3080,3595,-1,3594,3079,3080,-1,2134,3596,590,-1,2134,3075,3596,-1,2112,637,2111,-1,2112,635,637,-1,3077,2134,3597,-1,2134,3077,3075,-1,3598,3070,3071,-1,3598,3599,3070,-1,625,630,634,-1,625,2777,630,-1,621,625,2120,-1,625,621,2777,-1,3600,2779,3601,-1,3600,3602,2779,-1,615,619,2778,-1,620,619,615,-1,585,3603,2121,-1,585,3067,3603,-1,599,3604,3072,-1,3605,3604,599,-1,3072,3606,2131,-1,3604,3606,3072,-1,2129,2126,2125,-1,2129,2130,2126,-1,3606,2132,2131,-1,3606,3607,2132,-1,600,3072,611,-1,600,599,3072,-1,3070,629,628,-1,629,3070,3608,-1,3591,597,3081,-1,597,3591,598,-1,584,3067,585,-1,3067,584,3068,-1,1361,1369,1362,-1,1361,1747,1369,-1,578,1736,1399,-1,577,1736,578,-1,2621,566,575,-1,2621,2140,566,-1,3062,3056,3060,-1,3006,3056,3062,-1,3057,3053,3055,-1,3065,3053,3057,-1,3048,2993,3061,-1,3048,2996,2993,-1,3046,3049,3058,-1,3046,3047,3049,-1,3044,3042,3045,-1,3052,3042,3044,-1,2998,3050,3040,-1,3050,2998,2997,-1,3039,3043,3036,-1,3043,3039,3038,-1,3041,3035,3034,-1,3041,3031,3035,-1,3002,3037,3027,-1,3037,3002,3000,-1,3028,3033,3024,-1,3033,3028,3025,-1,3030,3023,3022,-1,3030,3020,3023,-1,3018,3001,3026,-1,3018,2999,3001,-1,3013,3016,3021,-1,3013,3017,3016,-1,3014,3010,3012,-1,3019,3010,3014,-1,3012,3011,3005,-1,3010,3011,3012,-1,2994,2141,3007,-1,2141,2994,2142,-1,3006,3009,3004,-1,3006,3062,3009,-1,555,3051,3064,-1,3051,555,3609,-1,2986,571,3032,-1,571,2986,551,-1,3610,2991,3054,-1,2991,3610,2989,-1,2147,2987,2988,-1,567,2987,2147,-1,568,555,554,-1,568,3609,555,-1,2149,551,2986,-1,552,551,2149,-1,1552,2158,1545,-1,1552,2472,2158,-1,1650,546,2154,-1,1650,545,546,-1,1653,2783,2982,-1,2783,1653,531,-1,1515,2981,2977,-1,1515,2978,2981,-1,1514,1511,544,-1,1511,1514,1513,-1,2156,544,539,-1,2156,542,544,-1,3611,2892,3586,-1,3611,2895,2892,-1,2165,523,519,-1,523,2165,524,-1,516,2980,514,-1,2980,516,3612,-1,2973,2784,524,-1,3613,2784,2973,-1,3613,2971,2970,-1,2971,3613,2973,-1,2788,2970,2972,-1,2788,2787,2970,-1,3614,505,2967,-1,505,3614,507,-1,493,2789,2470,-1,493,494,2789,-1,2972,2968,2788,-1,503,2968,2972,-1,2967,497,2172,-1,497,2967,505,-1,493,480,494,-1,493,481,480,-1,2174,502,499,-1,2174,487,502,-1,3615,478,483,-1,3615,2965,478,-1,487,2960,488,-1,487,3616,2960,-1,2468,485,491,-1,2468,2185,485,-1,2792,2469,1259,-1,2792,3348,2469,-1,1260,465,477,-1,465,1260,464,-1,2469,409,408,-1,3356,409,2469,-1,2181,2677,449,-1,2677,2181,456,-1,2360,2409,408,-1,2409,2360,454,-1,2793,2466,2410,-1,2793,447,2466,-1,2465,2187,459,-1,2465,443,2187,-1,2187,2191,452,-1,443,2191,2187,-1,2965,3617,2964,-1,3615,3617,2965,-1,2962,448,3618,-1,2962,2464,448,-1,444,2961,445,-1,2961,444,3619,-1,3617,2465,3620,-1,2465,3617,444,-1,447,3621,448,-1,447,2793,3621,-1,471,456,458,-1,471,2203,456,-1,2957,2203,471,-1,426,2942,2203,-1,2207,2942,426,-1,2179,432,1800,-1,423,432,2179,-1,2195,2955,2196,-1,3622,2955,2195,-1,2198,3623,2952,-1,3623,2198,2463,-1,2949,441,440,-1,2949,2948,441,-1,3624,2950,2947,-1,3624,436,2950,-1,2202,442,2462,-1,2197,442,2202,-1,439,2200,2199,-1,2200,439,434,-1,2205,2945,2943,-1,2205,3625,2945,-1,434,428,427,-1,428,434,439,-1,2954,2941,2938,-1,2941,2954,3626,-1,2955,2906,2905,-1,2955,3622,2906,-1,2956,2935,2936,-1,2935,2956,2943,-1,421,415,414,-1,421,420,415,-1,648,536,422,-1,648,534,536,-1,2460,475,474,-1,2460,2898,475,-1,3627,3577,3628,-1,3627,3629,3577,-1,354,407,355,-1,2239,407,354,-1,2811,2450,2449,-1,2811,2810,2450,-1,2932,2449,2795,-1,2449,2932,2811,-1,403,2458,404,-1,2867,2458,403,-1,2931,3630,2930,-1,3631,3630,2931,-1,2930,2926,2927,-1,3630,2926,2930,-1,2911,344,343,-1,344,2911,2928,-1,2912,343,352,-1,343,2912,2911,-1,2796,2922,400,-1,2920,2922,2796,-1,398,2221,2434,-1,2221,398,351,-1,400,3628,2417,-1,2922,3628,400,-1,355,2434,353,-1,2434,355,398,-1,362,354,353,-1,354,362,2808,-1,2807,2238,2239,-1,2807,365,2238,-1,2237,359,2235,-1,360,359,2237,-1,656,397,2455,-1,2488,397,656,-1,3098,2800,2918,-1,3098,394,2800,-1,2917,2453,389,-1,657,2453,2917,-1,2916,395,2457,-1,2916,396,395,-1,391,2802,392,-1,391,2803,2802,-1,2456,2227,385,-1,396,2227,2456,-1,2801,2806,2225,-1,2801,378,2806,-1,2805,2803,390,-1,2805,380,2803,-1,368,2804,385,-1,384,2804,368,-1,388,2806,377,-1,388,387,2806,-1,2901,3632,3633,-1,2901,2912,3632,-1,2908,3634,2910,-1,3634,2908,2929,-1,2907,3626,2905,-1,2907,2910,3626,-1,3633,2902,2901,-1,3633,3096,2902,-1,2941,2910,3634,-1,2910,2941,3626,-1,2899,2816,2218,-1,2322,2816,2899,-1,2208,2898,410,-1,2208,475,2898,-1,369,361,360,-1,369,368,361,-1,365,381,3635,-1,365,367,381,-1,2896,363,362,-1,2896,377,363,-1,3586,346,654,-1,346,3586,2892,-1,2894,346,2892,-1,2812,346,2894,-1,334,647,2101,-1,2100,647,334,-1,336,251,349,-1,336,2242,251,-1,336,2243,2242,-1,336,339,2243,-1,2813,329,331,-1,329,2813,330,-1,2891,316,603,-1,319,316,2891,-1,3636,318,298,-1,2445,318,3636,-1,2890,2253,342,-1,2253,2890,300,-1,2256,2251,2260,-1,2256,308,2251,-1,2814,2248,2889,-1,299,2248,2814,-1,151,168,2309,-1,2343,168,151,-1,36,2823,2395,-1,193,2823,36,-1,2846,2871,2884,-1,2871,2846,2845,-1,3637,2403,2318,-1,3637,2404,2403,-1,1222,283,291,-1,284,283,1222,-1,130,116,2348,-1,117,116,130,-1,279,3638,2857,-1,279,278,3638,-1,2286,197,2344,-1,2286,198,197,-1,273,276,271,-1,276,273,2815,-1,7,3639,6,-1,3639,7,3640,-1,2433,260,263,-1,260,2433,261,-1,3641,2297,2299,-1,3642,2297,3641,-1,2300,2340,167,-1,2340,2300,2875,-1,164,221,2280,-1,164,199,221,-1,2880,245,244,-1,245,2880,149,-1,2430,3383,244,-1,2430,2879,3383,-1,3643,2878,2603,-1,2878,3643,2304,-1,119,2351,108,-1,2351,119,2416,-1,280,214,2872,-1,214,280,201,-1,211,2311,239,-1,2311,211,218,-1,2436,2821,2882,-1,2436,216,2821,-1,2872,213,2285,-1,2872,214,213,-1,201,241,214,-1,200,241,201,-1,2269,2876,2440,-1,2269,150,2876,-1,280,2327,190,-1,3644,2327,280,-1,2822,238,231,-1,2822,212,238,-1,2299,2874,2863,-1,2874,2299,2431,-1,2871,2282,2884,-1,2871,277,2282,-1,2330,2824,2331,-1,2330,2230,2824,-1,176,183,172,-1,176,2341,183,-1,2825,176,172,-1,176,2825,177,-1,2421,3645,3642,-1,3645,2421,2279,-1,163,2321,187,-1,2321,163,162,-1,2873,203,202,-1,2873,2314,203,-1,156,2426,157,-1,156,2862,2426,-1,2230,177,2825,-1,177,2230,2330,-1,3646,145,147,-1,2883,145,3646,-1,2860,112,3644,-1,110,112,2860,-1,2328,115,192,-1,2328,2354,115,-1,2412,2358,105,-1,2359,2358,2412,-1,127,2351,2276,-1,127,2356,2351,-1,2413,2418,114,-1,2413,122,2418,-1,2858,107,2859,-1,108,107,2858,-1,100,2353,101,-1,100,2413,2353,-1,3647,147,2857,-1,3647,3646,147,-1,2856,63,43,-1,2856,3648,63,-1,3649,2853,2370,-1,3649,2851,2853,-1,97,2831,40,-1,97,2393,2831,-1,2835,75,2406,-1,2835,2855,75,-1,74,2408,2372,-1,74,82,2408,-1,2853,19,18,-1,2853,2852,19,-1,2836,2406,2373,-1,2836,2835,2406,-1,2850,2373,2848,-1,2850,2836,2373,-1,2847,2885,2845,-1,2847,2839,2885,-1,31,58,79,-1,31,59,58,-1,2391,2841,2830,-1,2391,2390,2841,-1,42,2389,2392,-1,2389,42,41,-1,2377,2838,3650,-1,2377,2376,2838,-1,2836,2844,61,-1,2844,2836,2850,-1,7,25,3640,-1,23,25,7,-1,2833,17,3651,-1,15,17,2833,-1,2398,2397,10,-1,3652,2397,2398,-1,6,9,3,-1,2834,9,6,-1,4,0,5,-1,4,1,0,-1,2386,3651,17,-1,2386,2842,3651,-1,24,265,2832,-1,24,297,265,-1,2374,2855,2835,-1,2374,35,2855,-1,2839,2849,2837,-1,2839,2847,2849,-1,2379,67,66,-1,2379,2378,67,-1,86,3653,2407,-1,86,88,3653,-1,2366,89,2828,-1,2366,2365,89,-1,33,55,59,-1,55,33,52,-1,58,2381,2827,-1,58,55,2381,-1,2855,78,75,-1,2855,2843,78,-1,61,2846,62,-1,61,2844,2846,-1,3648,3650,2838,-1,2856,3650,3648,-1,2851,2837,2849,-1,3649,2837,2851,-1,2370,3648,3649,-1,2370,63,3648,-1,2852,2361,19,-1,2372,2361,2852,-1,77,75,78,-1,75,77,76,-1,2854,2407,3653,-1,81,2407,2854,-1,34,31,2843,-1,31,34,32,-1,46,43,63,-1,46,44,43,-1,86,2369,87,-1,86,2362,2369,-1,103,2337,104,-1,103,2411,2337,-1,3654,118,2861,-1,2325,118,3654,-1,2826,120,2858,-1,120,2826,2355,-1,2861,111,110,-1,111,2861,118,-1,2350,2859,107,-1,2349,2859,2350,-1,2414,2327,2415,-1,2414,2326,2327,-1,2283,2861,2284,-1,3654,2861,2283,-1,2418,192,115,-1,2418,121,192,-1,2346,2293,1766,-1,2346,2291,2293,-1,208,153,155,-1,153,208,154,-1,2310,2863,2874,-1,2863,2310,2425,-1,2864,140,2267,-1,2864,2888,140,-1,2334,161,163,-1,161,2334,2294,-1,2297,2439,2298,-1,2439,2297,2886,-1,372,2333,186,-1,2333,372,2339,-1,152,173,185,-1,173,152,174,-1,179,2331,189,-1,2331,179,178,-1,123,180,191,-1,180,123,189,-1,2868,403,2933,-1,2867,403,2868,-1,278,3655,3638,-1,3655,278,2870,-1,197,2823,195,-1,2823,197,196,-1,2875,2314,2873,-1,2314,2875,2300,-1,2862,2819,3641,-1,2862,156,2819,-1,2821,211,210,-1,2821,218,211,-1,2429,2865,2303,-1,2265,2865,2429,-1,2820,3656,2887,-1,2820,223,3656,-1,2427,373,227,-1,373,2427,2295,-1,231,2817,2822,-1,2817,231,230,-1,2881,2822,2817,-1,2881,210,2822,-1,240,238,212,-1,240,204,238,-1,217,209,2315,-1,209,217,215,-1,2427,199,2332,-1,229,199,2427,-1,2601,2880,3385,-1,2880,2601,2877,-1,2818,1793,2302,-1,2818,2438,1793,-1,150,2878,2876,-1,150,2877,2878,-1,223,2818,3656,-1,223,246,2818,-1,2318,3657,3637,-1,3657,2318,2320,-1,2875,2298,2340,-1,2298,2875,2431,-1,251,2424,349,-1,251,252,2424,-1,4,1702,268,-1,266,1702,4,-1,2437,285,284,-1,85,285,2437,-1,194,2345,195,-1,2888,2345,194,-1,3647,2320,2325,-1,3647,3657,2320,-1,2820,2279,221,-1,2279,2820,3645,-1,2319,2275,2276,-1,2319,2380,2275,-1,2885,3655,2870,-1,3655,2885,2375,-1,2324,62,2281,-1,2324,60,62,-1,2401,196,2422,-1,2401,94,196,-1,2371,128,127,-1,96,128,2371,-1,2890,298,300,-1,3636,298,2890,-1,2252,304,2261,-1,304,2252,2477,-1,311,2259,309,-1,2889,2259,311,-1,312,2257,2443,-1,312,313,2257,-1,328,302,2255,-1,328,314,302,-1,632,330,2813,-1,632,631,330,-1,314,2246,2444,-1,314,328,2246,-1,636,333,320,-1,333,636,2776,-1,2100,310,309,-1,310,2100,334,-1,345,340,650,-1,345,248,340,-1,2773,2894,2893,-1,2483,2894,2773,-1,339,653,655,-1,338,653,339,-1,364,2807,2808,-1,2807,364,366,-1,3658,384,370,-1,3658,382,384,-1,2293,2897,2460,-1,2293,2232,2897,-1,2432,410,2897,-1,2432,2448,410,-1,226,2233,2452,-1,2233,226,2231,-1,2939,2903,2900,-1,3659,2903,2939,-1,3660,3583,3097,-1,3660,2914,3583,-1,2909,2904,2913,-1,2907,2904,2909,-1,2903,2928,2911,-1,2903,3659,2928,-1,2915,3660,3661,-1,2914,3660,2915,-1,383,381,2805,-1,381,383,382,-1,2453,2804,383,-1,2455,2804,2453,-1,2802,379,393,-1,2802,2229,379,-1,2454,386,2916,-1,2454,387,386,-1,394,2801,2800,-1,394,393,2801,-1,392,2486,391,-1,2486,392,2487,-1,2226,2919,2224,-1,2919,2226,2799,-1,2451,362,353,-1,2896,362,2451,-1,2450,370,356,-1,3658,370,2450,-1,370,357,356,-1,357,370,369,-1,2915,399,406,-1,399,2915,3661,-1,401,2235,2798,-1,2235,401,2236,-1,399,3632,2797,-1,399,3661,3632,-1,2798,257,401,-1,257,2798,258,-1,2797,2912,352,-1,2797,3632,2912,-1,2925,2796,261,-1,2925,2920,2796,-1,2927,261,2433,-1,2927,2925,261,-1,2899,2795,405,-1,2795,2899,2932,-1,2869,3631,2931,-1,3662,3631,2869,-1,3663,2869,2866,-1,3663,3662,2869,-1,2913,406,2214,-1,406,2913,2915,-1,2460,1766,2293,-1,2460,1219,1766,-1,411,414,412,-1,2210,414,411,-1,421,418,422,-1,418,421,419,-1,2937,426,2204,-1,427,426,2937,-1,430,2201,2461,-1,2201,430,429,-1,2900,2940,2939,-1,2900,3664,2940,-1,3665,432,431,-1,432,3665,1800,-1,438,425,424,-1,425,438,433,-1,2944,2937,2935,-1,2937,2944,435,-1,436,2944,2950,-1,436,435,2944,-1,433,437,2946,-1,437,433,438,-1,2948,3625,441,-1,2948,2945,3625,-1,2946,2951,3666,-1,2951,2946,437,-1,2940,3624,2947,-1,2940,3664,3624,-1,3666,2953,3582,-1,2953,3666,2951,-1,2938,440,2954,-1,2938,2949,440,-1,2461,470,472,-1,2461,2206,470,-1,430,472,467,-1,472,430,2461,-1,2790,463,2178,-1,463,2790,460,-1,2959,3667,2958,-1,3667,2959,2964,-1,2189,3616,3621,-1,3616,2189,2960,-1,3668,2959,2192,-1,2963,2959,3668,-1,2182,2188,451,-1,2182,2194,2188,-1,3667,457,2467,-1,3667,3620,457,-1,459,3620,2465,-1,3620,459,457,-1,454,461,463,-1,461,454,2360,-1,2203,2179,1081,-1,2203,2942,2179,-1,2963,3669,479,-1,2963,3668,3669,-1,2962,2174,486,-1,2962,3618,2174,-1,2176,3619,2177,-1,2176,2961,3619,-1,3669,490,2173,-1,3669,491,490,-1,3669,480,479,-1,480,3669,2173,-1,503,2175,2968,-1,503,489,2175,-1,500,2969,2966,-1,500,501,2969,-1,492,2786,2170,-1,492,2167,2786,-1,508,504,506,-1,504,508,509,-1,2966,2971,2974,-1,2966,2969,2971,-1,2164,3614,2974,-1,3614,2164,513,-1,2787,2471,2163,-1,2787,2786,2471,-1,512,2785,510,-1,512,511,2785,-1,2169,3670,3612,-1,2168,3670,2169,-1,2983,2785,518,-1,2983,3670,2785,-1,2784,2155,522,-1,2155,2784,2162,-1,3092,3611,3671,-1,3092,3588,3611,-1,2783,1654,2977,-1,530,1654,2783,-1,535,2212,416,-1,535,3585,2212,-1,541,2979,542,-1,541,514,2979,-1,1514,2978,1515,-1,1514,2979,2978,-1,2982,2977,2981,-1,2977,2982,2783,-1,520,545,1652,-1,520,519,545,-1,2146,2150,563,-1,2146,556,2150,-1,2989,2475,2148,-1,2989,3610,2475,-1,2988,3029,2990,-1,3029,2988,2987,-1,556,2992,2150,-1,3066,2992,556,-1,2995,3007,3059,-1,3007,2995,2994,-1,3063,3005,3011,-1,3063,3003,3005,-1,3009,3015,3004,-1,3015,3009,3008,-1,3008,3013,3015,-1,3013,3008,3017,-1,2476,2999,3018,-1,2476,2143,2999,-1,3020,3014,3023,-1,3020,3019,3014,-1,3016,3024,3021,-1,3024,3016,3028,-1,3026,3002,3027,-1,3026,3001,3002,-1,3031,3022,3035,-1,3031,3030,3022,-1,3025,3036,3033,-1,3036,3025,3039,-1,3000,3040,3037,-1,3040,3000,2998,-1,3042,3034,3045,-1,3042,3041,3034,-1,3038,3046,3043,-1,3046,3038,3047,-1,3050,2996,3048,-1,3050,2997,2996,-1,3055,3052,3044,-1,3053,3052,3055,-1,3058,3060,3056,-1,3058,3049,3060,-1,3061,2995,3059,-1,3061,2993,2995,-1,3003,3065,3057,-1,3063,3065,3003,-1,576,1838,1388,-1,576,566,1838,-1,595,586,2119,-1,586,595,624,-1,3074,593,3597,-1,593,3074,594,-1,596,3071,3069,-1,596,2780,3071,-1,3601,601,623,-1,601,3601,2779,-1,3605,3606,3604,-1,3605,3607,3606,-1,3602,3607,3605,-1,3602,3593,3607,-1,3600,3593,3602,-1,3600,3592,3593,-1,3672,3592,3600,-1,3672,3673,3592,-1,3599,3673,3672,-1,3673,3599,3598,-1,613,609,608,-1,613,606,609,-1,3674,588,2128,-1,2137,588,3674,-1,3603,2137,3674,-1,3067,2137,3603,-1,2480,619,614,-1,619,2480,2778,-1,3602,599,2779,-1,3602,3605,599,-1,3073,2123,618,-1,3073,2122,2123,-1,618,2117,3073,-1,2117,618,627,-1,3672,3601,3608,-1,3672,3600,3601,-1,3599,3608,3070,-1,3599,3672,3608,-1,2116,3597,593,-1,3597,2116,3077,-1,633,3076,2113,-1,3076,633,3078,-1,2780,3598,3071,-1,3673,3598,2780,-1,3079,3076,3078,-1,3594,3076,3079,-1,598,3673,2780,-1,3592,3673,598,-1,590,3590,2135,-1,590,3596,3590,-1,3595,604,2479,-1,3595,3080,604,-1,2132,3593,3591,-1,3607,3593,2132,-1,3093,2095,3082,-1,2093,2095,3093,-1,3089,3085,3589,-1,3089,2098,3085,-1,2934,2108,2211,-1,3584,2108,2934,-1,2108,3584,652,-1,3087,645,2090,-1,3087,646,645,-1,2097,2103,2774,-1,2097,2104,2103,-1,642,2098,3089,-1,2098,642,2099,-1,652,2794,653,-1,3584,2794,652,-1,3092,3587,3588,-1,3092,3084,3587,-1,3091,3671,3675,-1,3091,3092,3671,-1,3675,3094,3091,-1,2772,3094,3675,-1,640,644,2481,-1,644,640,2094,-1,2902,2952,3623,-1,3096,2952,2902,-1,667,2799,3099,-1,2919,2799,667,-1,711,2084,710,-1,2084,711,3099,-1,689,678,677,-1,689,683,678,-1,730,2771,3580,-1,2771,730,687,-1,690,694,691,-1,2077,694,690,-1,2073,2080,700,-1,2073,2081,2080,-1,2063,2068,2064,-1,2063,706,2068,-1,715,3579,2770,-1,715,2768,3579,-1,2769,715,712,-1,2769,716,715,-1,3102,716,2769,-1,3102,3676,716,-1,2767,3676,3102,-1,2767,728,3676,-1,726,2767,724,-1,726,728,2767,-1,723,688,687,-1,688,723,2055,-1,2449,358,2933,-1,2449,356,358,-1,732,3107,2758,-1,3107,732,731,-1,3109,3106,3105,-1,3109,3108,3106,-1,741,739,738,-1,739,741,740,-1,3134,2500,2020,-1,3111,2500,3134,-1,755,2022,756,-1,2022,755,3677,-1,3678,2763,3114,-1,2763,3678,3126,-1,3118,3679,3122,-1,3118,3117,3679,-1,3135,3575,3574,-1,3135,3570,3575,-1,744,802,745,-1,744,3116,802,-1,2764,3126,3123,-1,2764,2763,3126,-1,734,2499,3129,-1,734,736,2499,-1,3128,3571,2761,-1,3572,3571,3128,-1,753,749,748,-1,753,752,749,-1,2029,2038,3129,-1,2030,2038,2029,-1,2039,3573,2033,-1,3573,2039,3127,-1,758,752,2762,-1,758,749,752,-1,3121,3112,3132,-1,3120,3112,3121,-1,3679,2045,3133,-1,3679,3677,2045,-1,3134,3678,3111,-1,3678,3134,3136,-1,3141,2502,3139,-1,3141,2503,2502,-1,3143,2018,1992,-1,3143,2504,2018,-1,3545,761,3146,-1,3545,759,761,-1,760,3569,2047,-1,3569,760,759,-1,3106,2757,2758,-1,2757,3106,3138,-1,3145,2052,2493,-1,761,2052,3145,-1,3107,770,2755,-1,3107,731,770,-1,773,2049,2756,-1,773,2494,2049,-1,774,3566,3576,-1,2756,3566,774,-1,770,2495,776,-1,770,769,2495,-1,3151,3181,3150,-1,3680,3181,3151,-1,3155,3169,3153,-1,2009,3169,3155,-1,3158,3681,3184,-1,3681,3158,3157,-1,3160,783,3682,-1,3160,805,783,-1,3683,3682,3684,-1,3160,3682,3683,-1,3159,3562,3157,-1,3159,3561,3562,-1,3684,3166,3685,-1,3682,3166,3684,-1,2008,3561,3159,-1,2008,2505,3561,-1,3685,3165,786,-1,3166,3165,3685,-1,3167,3172,3170,-1,3556,3172,3167,-1,3686,788,787,-1,788,3686,3168,-1,3170,3173,3687,-1,3172,3173,3170,-1,2506,787,2005,-1,787,2506,3686,-1,3173,3549,3687,-1,3173,3176,3549,-1,3559,3152,3563,-1,3152,3559,3552,-1,3551,2507,3177,-1,3551,791,2507,-1,3680,3559,3563,-1,3680,3558,3559,-1,3151,3558,3680,-1,3151,3548,3558,-1,798,2003,2753,-1,2003,798,2508,-1,801,2753,797,-1,2753,801,798,-1,796,2011,3182,-1,1999,2011,796,-1,3560,2509,3681,-1,2509,3560,1997,-1,3182,3160,3683,-1,2011,3160,3182,-1,3562,3681,3157,-1,3681,3562,3560,-1,2501,764,763,-1,3546,764,2501,-1,809,3144,807,-1,809,3568,3144,-1,1993,1992,1991,-1,1992,1993,3143,-1,3688,816,2752,-1,3688,3689,816,-1,2751,3501,2750,-1,3501,2751,3280,-1,3188,2749,3690,-1,3188,839,2749,-1,3691,836,835,-1,3691,1975,836,-1,1977,837,1978,-1,845,837,1977,-1,3190,835,3189,-1,3190,3691,835,-1,846,859,855,-1,859,846,1966,-1,2748,3189,852,-1,2748,3190,3189,-1,2518,854,1963,-1,854,2518,844,-1,850,852,851,-1,850,2748,852,-1,1959,1955,887,-1,874,1955,1959,-1,2522,869,881,-1,869,2522,1961,-1,875,895,2524,-1,875,2521,895,-1,3196,890,897,-1,3196,1954,890,-1,892,3192,891,-1,3192,892,3692,-1,2524,3693,3193,-1,2524,895,3693,-1,3197,897,3694,-1,3197,3196,897,-1,3523,3192,3692,-1,3200,3192,3523,-1,3204,898,2526,-1,3201,898,3204,-1,3234,3205,3207,-1,3234,3695,3205,-1,3696,903,3219,-1,903,3696,3209,-1,3194,3214,3211,-1,3194,3193,3214,-1,3697,3210,3209,-1,3253,3210,3697,-1,3193,3698,3214,-1,3193,3693,3698,-1,3699,3209,3696,-1,3697,3209,3699,-1,3693,3700,3698,-1,3693,3542,3700,-1,3701,3696,3538,-1,3699,3696,3701,-1,3542,3702,3700,-1,3542,3195,3702,-1,3703,3538,3208,-1,3701,3538,3703,-1,3702,3197,3704,-1,3702,3195,3197,-1,3208,3705,3703,-1,3208,3205,3705,-1,3704,3694,3706,-1,3704,3197,3694,-1,3695,3705,3205,-1,3705,3695,3707,-1,3706,3541,3708,-1,3706,3694,3541,-1,3539,3707,3695,-1,3707,3539,3709,-1,3708,3199,905,-1,3708,3541,3199,-1,900,3709,3539,-1,3709,900,899,-1,905,3200,906,-1,905,3199,3200,-1,907,3242,2745,-1,3242,907,3244,-1,3246,1951,1950,-1,3246,2746,1951,-1,3251,3244,907,-1,3244,3251,3248,-1,3537,3204,3247,-1,3537,3202,3204,-1,3522,3211,909,-1,3522,3194,3211,-1,3253,3202,3210,-1,3253,3203,3202,-1,3279,921,3262,-1,922,921,3279,-1,3255,949,948,-1,3255,3257,949,-1,920,3261,921,-1,920,3256,3261,-1,915,926,916,-1,915,928,926,-1,3268,3255,3254,-1,3255,3268,3258,-1,2667,3264,2660,-1,3265,3264,2667,-1,931,3710,3265,-1,3711,3710,931,-1,3517,931,930,-1,3517,3711,931,-1,935,2529,3266,-1,935,933,2529,-1,2527,3266,3267,-1,2527,935,3266,-1,2659,938,937,-1,938,2659,1938,-1,939,3514,940,-1,3513,3514,939,-1,3270,943,1941,-1,2741,943,3270,-1,2531,2661,1593,-1,2531,1939,2661,-1,1937,2741,3270,-1,946,2741,1937,-1,945,3272,946,-1,3273,3272,945,-1,3263,3275,3273,-1,3518,3275,3263,-1,988,951,922,-1,988,2732,951,-1,955,3689,3280,-1,955,2535,3689,-1,3712,824,3282,-1,824,3712,1985,-1,821,3713,953,-1,820,3713,821,-1,3508,3282,3283,-1,3508,3712,3282,-1,3288,953,3713,-1,959,953,3288,-1,2738,970,2541,-1,970,2738,1932,-1,3289,1931,3287,-1,3289,3286,1931,-1,1934,3511,2539,-1,957,3511,1934,-1,3284,974,973,-1,3284,2740,974,-1,3307,3292,3291,-1,3312,3292,3307,-1,3292,3312,3714,-1,1932,2737,970,-1,2539,2737,1932,-1,1926,3296,1927,-1,1926,3298,3296,-1,2729,1921,2730,-1,1921,2729,975,-1,3296,3300,2739,-1,3298,3300,3296,-1,2733,1928,3301,-1,1928,2733,1929,-1,1597,3456,3507,-1,1597,3459,3456,-1,1597,1598,3459,-1,999,3507,3456,-1,999,1002,3507,-1,3325,3311,3308,-1,3325,3314,3311,-1,3314,2738,3311,-1,3314,3313,2738,-1,983,3506,2540,-1,983,982,3506,-1,984,1595,1925,-1,1595,984,981,-1,962,3316,3715,-1,2544,3316,962,-1,3715,1922,2547,-1,3316,1922,3715,-1,991,3458,989,-1,3458,991,3456,-1,912,992,989,-1,912,911,992,-1,2548,3323,2730,-1,3502,3323,2548,-1,993,911,995,-1,911,993,992,-1,3323,2731,2730,-1,3323,3322,2731,-1,3292,3325,3324,-1,3292,3714,3325,-1,818,1674,2752,-1,1674,818,2512,-1,822,2511,823,-1,2511,822,2720,-1,3501,814,2608,-1,3501,3688,814,-1,828,1268,1267,-1,828,1981,1268,-1,831,1974,832,-1,831,3690,1974,-1,2514,1972,2587,-1,2514,3188,1972,-1,2159,1148,1490,-1,1148,2159,526,-1,1275,2728,1012,-1,2728,1275,1017,-1,2550,3489,2551,-1,2550,1479,3489,-1,1029,3354,1118,-1,3354,1029,1028,-1,1031,1111,1032,-1,1031,3499,1111,-1,2723,3328,1339,-1,2723,1482,3328,-1,1151,1338,3498,-1,1151,1150,1338,-1,3330,2724,2585,-1,3330,3487,2724,-1,1041,1826,1043,-1,1041,3376,1826,-1,1770,1858,1289,-1,1770,1859,1858,-1,1621,3334,1049,-1,1621,1623,3334,-1,1765,3335,3337,-1,3335,1765,3479,-1,1350,3716,1351,-1,3716,1350,3334,-1,3340,1868,3388,-1,3340,1132,1868,-1,1445,1288,3491,-1,1445,1771,1288,-1,1069,2709,1062,-1,2709,1069,1068,-1,1066,1287,1138,-1,1066,1065,1287,-1,3347,1074,3345,-1,1075,1074,3347,-1,3350,1893,1892,-1,3350,3351,1893,-1,1079,1341,1340,-1,1341,1079,1891,-1,1036,1341,1034,-1,1341,1036,2689,-1,1328,1082,2564,-1,1083,1082,1328,-1,3717,1854,1814,-1,3717,2721,1854,-1,2552,2551,3489,-1,2552,1014,2551,-1,2567,1109,1213,-1,2567,1110,1109,-1,1905,1882,1881,-1,1882,1905,3499,-1,1878,1123,1302,-1,1878,1124,1123,-1,1283,2712,1872,-1,2713,2712,1283,-1,2561,2710,2562,-1,2561,2711,2710,-1,1767,1280,1768,-1,2695,1280,1767,-1,3330,3347,3346,-1,3330,3329,3347,-1,2598,3358,2791,-1,2598,2597,3358,-1,3389,1792,3361,-1,3389,2604,1792,-1,1446,3491,2599,-1,1446,1445,3491,-1,3364,1856,2699,-1,3364,1857,1856,-1,1673,1247,2697,-1,1673,1485,1247,-1,2400,1700,1702,-1,2400,2399,1700,-1,1460,1168,1847,-1,1168,1460,1462,-1,1842,1171,1699,-1,1842,1844,1171,-1,1180,1461,1178,-1,1180,1697,1461,-1,1839,1186,1458,-1,2628,1186,1839,-1,1466,2704,2629,-1,2704,1466,1819,-1,1684,1738,1374,-1,1677,1738,1684,-1,1013,1097,1099,-1,1013,2550,1097,-1,1212,2553,1278,-1,1212,2566,2553,-1,1026,1834,2727,-1,1834,1026,1443,-1,1119,1879,1467,-1,1119,1118,1879,-1,3365,1221,1220,-1,3365,2278,1221,-1,2633,2984,2159,-1,2702,2984,2633,-1,1311,1316,3367,-1,1311,1310,1316,-1,3374,2703,3369,-1,2703,3374,1210,-1,2698,1185,1234,-1,2698,1239,1185,-1,1352,1757,1353,-1,1757,1352,1758,-1,1199,3486,3370,-1,1194,3486,1199,-1,1195,3371,1379,-1,1836,3371,1195,-1,1376,1745,1685,-1,1378,1745,1376,-1,1825,1163,1851,-1,1825,1249,1163,-1,3718,3379,1821,-1,3382,3379,3718,-1,3377,3382,1823,-1,3377,3380,3382,-1,1821,1116,1216,-1,1116,1821,3379,-1,2699,1197,3363,-1,1197,2699,2700,-1,1063,2600,1829,-1,1063,2709,2600,-1,3386,1284,3384,-1,1285,1284,3386,-1,2711,3339,1865,-1,2561,3339,2711,-1,1158,1687,1469,-1,1158,1157,1687,-1,1293,1790,1277,-1,1293,2691,1790,-1,1787,1273,1272,-1,1787,2690,1273,-1,1017,1914,1913,-1,1914,1017,1019,-1,1279,1046,1045,-1,1046,1279,2695,-1,1115,2306,2570,-1,2306,1115,2287,-1,2576,3643,2717,-1,3643,2576,2428,-1,1069,1136,1070,-1,1069,1863,1136,-1,3361,3492,3357,-1,3361,3360,3492,-1,1858,2706,2708,-1,1858,1860,2706,-1,1872,2580,1129,-1,2580,1872,2712,-1,1789,1273,1305,-1,1789,2696,1273,-1,1877,1271,1467,-1,1877,1875,1271,-1,1305,1470,1790,-1,1305,1304,1470,-1,3391,1306,2606,-1,3390,1306,3391,-1,1306,1314,1313,-1,1314,1306,3390,-1,1223,1310,1224,-1,1223,1230,1310,-1,1777,1319,1776,-1,1777,1321,1319,-1,1322,1319,1323,-1,1322,1776,1319,-1,1909,2556,2555,-1,2556,1909,1908,-1,3353,2721,3717,-1,3353,2565,2721,-1,3326,1020,2728,-1,1020,3326,3500,-1,3350,3328,3327,-1,3328,3350,3349,-1,1009,2688,2262,-1,2688,1009,1008,-1,271,3337,3336,-1,276,3337,271,-1,581,1346,2613,-1,581,2781,1346,-1,3334,1616,3716,-1,1623,1616,3334,-1,1190,3486,3497,-1,3486,1190,1191,-1,2698,1366,1237,-1,1367,1366,2698,-1,2616,1739,1746,-1,1750,1739,2616,-1,2615,1748,3373,-1,1751,1748,2615,-1,1371,1857,1757,-1,1371,1370,1857,-1,1685,1374,1376,-1,1374,1685,1684,-1,1384,1395,1385,-1,1395,1384,1396,-1,1389,3400,1390,-1,3400,1389,3395,-1,3397,1373,1735,-1,3402,1373,3397,-1,3485,1404,2624,-1,3485,1395,1404,-1,3400,1410,3484,-1,1410,3400,1408,-1,1401,3402,1402,-1,1401,3483,3402,-1,2684,1424,1406,-1,2684,3482,1424,-1,3406,1409,1718,-1,3406,3401,1409,-1,1051,1621,1049,-1,1607,1621,1051,-1,1400,3480,1398,-1,1400,3478,3480,-1,1343,1419,1344,-1,1420,1419,1343,-1,1413,3404,1414,-1,3403,3404,1413,-1,3405,1900,1416,-1,3405,2681,1900,-1,3407,3406,2626,-1,3407,1412,3406,-1,1182,1425,1417,-1,1717,1425,1182,-1,1843,2682,3407,-1,2682,1843,2628,-1,1432,1415,1433,-1,1415,1432,1431,-1,1438,1725,1439,-1,1725,1438,1724,-1,3405,1448,1727,-1,3481,1448,3405,-1,3481,1416,1459,-1,3481,3405,1416,-1,2658,1454,2558,-1,2658,1625,1454,-1,1412,3401,3406,-1,3401,1412,1402,-1,1708,1709,2594,-1,1708,2679,1709,-1,1452,2679,1708,-1,1451,2679,1452,-1,3336,1705,271,-1,3336,2726,1705,-1,1435,1847,1168,-1,1435,1422,1847,-1,1220,1840,3365,-1,1220,1464,1840,-1,1220,291,1205,-1,1220,1222,291,-1,1907,1216,1116,-1,1909,1216,1907,-1,1131,2571,2573,-1,1131,1130,2571,-1,1874,1128,1300,-1,1126,1128,1874,-1,1866,1137,1806,-1,1137,1866,1135,-1,1335,1860,1859,-1,1335,1337,1860,-1,2702,1044,2984,-1,3332,1044,2702,-1,1487,528,1159,-1,1487,1147,528,-1,1496,1649,1494,-1,1649,1496,2638,-1,3476,1670,3475,-1,1670,3476,2635,-1,1664,3474,3409,-1,2636,3474,1664,-1,1500,3476,3719,-1,3476,1500,1502,-1,3412,3409,3720,-1,3409,3412,3408,-1,3410,1503,1505,-1,2637,1503,3410,-1,1500,1660,1506,-1,3719,1660,1500,-1,3720,3416,3412,-1,3720,3418,3416,-1,3471,3419,3418,-1,3471,3423,3419,-1,2640,2645,3469,-1,3420,2645,2640,-1,1520,3423,1516,-1,3423,1520,3419,-1,1508,3469,1509,-1,2640,3469,1508,-1,2643,1513,1512,-1,2643,3470,1513,-1,3425,1523,2644,-1,2646,1523,3425,-1,3426,1509,3469,-1,1509,3426,2642,-1,3466,3429,3431,-1,3429,3466,3428,-1,1530,1551,1531,-1,1530,2651,1551,-1,3721,1648,1647,-1,3721,1632,1648,-1,1556,1539,1538,-1,1556,3722,1539,-1,3435,1632,3721,-1,3435,1561,1632,-1,1539,3437,2673,-1,1539,3722,3437,-1,1642,1537,1536,-1,1537,1642,3438,-1,3467,3723,3465,-1,3723,3467,3434,-1,3443,3445,3441,-1,3443,3723,3445,-1,3442,3444,1549,-1,3442,3441,3444,-1,3444,1545,2158,-1,3444,2672,1545,-1,3724,2649,3463,-1,3724,1639,2649,-1,3448,1492,3450,-1,3448,2650,1492,-1,1497,3454,3449,-1,3454,1497,1533,-1,2669,3451,2653,-1,1554,3451,2669,-1,3454,1631,3452,-1,1631,3454,1560,-1,1558,1554,1553,-1,1558,1557,1554,-1,3722,1558,3437,-1,3722,1556,1558,-1,1628,1629,1587,-1,1620,1629,1628,-1,1562,2744,1575,-1,2744,1562,925,-1,1587,2665,1628,-1,1589,2665,1587,-1,3461,2663,2664,-1,3460,2663,3461,-1,1569,1592,2666,-1,1569,2532,1592,-1,1568,944,1569,-1,1568,2657,944,-1,1612,3297,1613,-1,2546,3297,1612,-1,989,2662,1604,-1,3458,2662,989,-1,558,1007,1577,-1,569,1007,558,-1,3459,1599,3457,-1,1598,1599,3459,-1,945,2657,2656,-1,2657,945,944,-1,1583,1594,1615,-1,1583,1582,1594,-1,2664,1591,1588,-1,2663,1591,2664,-1,1590,1587,1575,-1,1590,1589,1587,-1,1585,2660,1617,-1,1585,2667,2660,-1,1574,2657,1568,-1,1574,1624,2657,-1,1627,1585,1622,-1,1585,1627,2655,-1,1576,1564,1563,-1,1576,1626,1564,-1,2654,3462,1555,-1,3462,2654,1630,-1,3454,1644,1560,-1,3454,1533,1644,-1,2653,3455,2669,-1,2653,1491,3455,-1,1493,3453,1491,-1,1493,2985,3453,-1,3450,2652,3448,-1,1635,2652,3450,-1,2652,3724,3463,-1,1634,3724,2652,-1,3447,2649,3446,-1,3463,2649,3447,-1,3464,1549,1548,-1,3464,3442,1549,-1,3464,1542,1641,-1,2648,1542,3464,-1,3723,3433,3445,-1,3723,3434,3433,-1,3465,3443,3439,-1,3443,3465,3723,-1,3465,3721,3467,-1,3465,3435,3721,-1,1630,1536,3462,-1,1536,1630,1642,-1,1639,2668,1556,-1,1639,2670,2668,-1,1639,1633,2670,-1,3724,1633,1639,-1,3724,1634,1633,-1,3467,1647,3466,-1,3467,3721,1647,-1,3430,1546,3433,-1,3468,1546,3430,-1,3427,1645,3468,-1,1646,1645,3427,-1,1647,3428,3466,-1,3428,1647,1527,-1,1671,3432,3429,-1,1495,3432,1671,-1,3426,3424,2152,-1,3426,2647,3424,-1,1650,2644,1651,-1,3425,2644,1650,-1,2643,2639,3470,-1,2641,2639,2643,-1,1513,1656,1511,-1,3470,1656,1513,-1,1519,3419,1520,-1,3419,1519,3417,-1,3422,3416,3417,-1,3416,3422,3415,-1,1661,3423,3471,-1,1661,1659,3423,-1,3472,3418,3720,-1,3472,3471,3418,-1,1660,3473,3421,-1,3473,1660,3719,-1,3409,3472,3720,-1,3474,3472,3409,-1,3719,3475,3473,-1,3475,3719,3476,-1,2636,3414,3474,-1,1499,3414,2636,-1,3475,1667,3413,-1,1667,3475,1670,-1,1533,1666,1665,-1,1533,1664,1666,-1,2634,1668,2635,-1,1671,1668,2634,-1,3332,2701,2557,-1,2702,2701,3332,-1,1680,1094,1087,-1,1094,1680,1095,-1,1149,2611,1150,-1,1149,2610,2611,-1,1863,1137,1136,-1,1863,1864,1137,-1,2575,1786,1798,-1,1786,2575,2579,-1,2717,2577,2576,-1,2717,2716,2577,-1,1802,2705,1687,-1,1802,1689,2705,-1,2705,1176,1173,-1,1176,2705,1689,-1,1056,1437,1242,-1,1054,1437,1056,-1,1818,1820,1253,-1,1822,1820,1818,-1,275,3337,276,-1,275,1765,3337,-1,1242,1709,1056,-1,1242,2594,1709,-1,1728,3403,1413,-1,1728,1726,3403,-1,3335,2683,3338,-1,3335,3478,2683,-1,1915,3478,1400,-1,2683,3478,1915,-1,582,2613,1896,-1,582,581,2613,-1,2623,1457,1429,-1,1839,1457,2623,-1,3407,1723,1843,-1,1723,3407,2626,-1,1008,3479,2688,-1,1008,3480,3479,-1,3404,1459,1414,-1,1459,3404,3481,-1,1438,1450,1449,-1,1450,1438,1440,-1,1344,1726,1728,-1,1344,1419,1726,-1,1398,1008,1010,-1,3480,1008,1398,-1,1721,3482,2624,-1,1424,3482,1721,-1,1409,3484,1410,-1,1409,3398,3484,-1,3396,2624,3482,-1,3396,3485,2624,-1,3402,1364,1373,-1,3483,1364,3402,-1,1390,3484,2619,-1,3484,1390,3400,-1,1385,3485,1386,-1,3485,1385,1395,-1,3483,1392,1364,-1,3399,1392,3483,-1,576,2620,575,-1,2619,2620,576,-1,1362,1715,1007,-1,1715,1362,2625,-1,2592,1740,1739,-1,1740,2592,1828,-1,2617,3495,3394,-1,1236,3495,2617,-1,1357,1366,1365,-1,1357,1356,1366,-1,1751,1749,1748,-1,3393,1749,1751,-1,3372,1750,1749,-1,1750,3372,3496,-1,1739,3496,2592,-1,3496,1739,1750,-1,572,1193,1837,-1,2618,1193,572,-1,3497,1189,1190,-1,1189,3497,2700,-1,1616,1899,3716,-1,1616,1618,1899,-1,1625,1455,1454,-1,1625,1573,1455,-1,3344,3358,3342,-1,3344,1217,3358,-1,3343,2583,3341,-1,2583,3343,3331,-1,1086,3717,1887,-1,3717,1086,3353,-1,1481,1774,2609,-1,1332,1774,1481,-1,2569,2727,1834,-1,1028,2727,2569,-1,3368,1471,2607,-1,3368,3392,1471,-1,1780,3391,2606,-1,3391,1780,1779,-1,1781,2606,1225,-1,1780,2606,1781,-1,1783,1313,1473,-1,1783,1306,1313,-1,3477,1305,2690,-1,1303,1305,3477,-1,2605,3493,3387,-1,2605,1788,3493,-1,2693,2713,1283,-1,1870,2713,2693,-1,1794,1876,2570,-1,2719,1876,1794,-1,1295,1302,1301,-1,1294,1302,1295,-1,1075,3329,3498,-1,3329,1075,3347,-1,3389,3357,3355,-1,3357,3389,3361,-1,1285,2595,1805,-1,1285,3386,2595,-1,2879,3386,3383,-1,2595,3386,2879,-1,2428,1796,1795,-1,2428,2576,1796,-1,1132,1869,1868,-1,1132,1134,1869,-1,2791,1217,474,-1,2791,3358,1217,-1,1869,2600,1867,-1,1869,1830,2600,-1,3477,1787,1676,-1,3477,2690,1787,-1,1127,1798,1128,-1,1798,1127,2574,-1,2717,2603,2573,-1,2717,3643,2603,-1,1274,3493,2596,-1,2696,3493,1274,-1,832,1243,833,-1,1971,1243,832,-1,1680,1152,1155,-1,1680,1679,1152,-1,1156,1263,1095,-1,1263,1156,1855,-1,2560,1134,1133,-1,1805,1134,2560,-1,1231,1223,1901,-1,1223,1231,1230,-1,1791,1475,1792,-1,1791,1476,1475,-1,1082,3333,1256,-1,1082,1084,3333,-1,2700,1370,1189,-1,1370,2700,1856,-1,1696,1254,1694,-1,1696,1207,1254,-1,3718,1823,3382,-1,3718,2593,1823,-1,2593,1821,1820,-1,2593,3718,1821,-1,1849,1330,762,-1,1250,1330,1849,-1,1162,1851,1163,-1,2612,1851,1162,-1,2615,1743,1742,-1,2615,3369,1743,-1,3496,1815,2592,-1,1815,3496,1816,-1,3497,1194,1198,-1,3497,3486,1194,-1,1686,1758,1352,-1,1686,1359,1758,-1,3495,1210,3374,-1,1210,3495,1208,-1,22,2278,3365,-1,22,21,2278,-1,1022,1106,1105,-1,1106,1022,2554,-1,1100,2567,1098,-1,1100,1110,2567,-1,1167,1843,1723,-1,1167,1172,1843,-1,1723,1168,1167,-1,1723,1435,1168,-1,1846,1699,1756,-1,1699,1846,1842,-1,1841,1701,1840,-1,1183,1701,1841,-1,2697,1991,1673,-1,1991,2697,808,-1,3494,1330,1812,-1,1330,3494,813,-1,3362,1264,1804,-1,3362,3363,1264,-1,1801,467,1918,-1,1800,467,1801,-1,1800,3665,467,-1,1771,1289,1288,-1,1771,1770,1289,-1,1074,2604,3389,-1,2725,2604,1074,-1,3492,2791,473,-1,3492,2598,2791,-1,3341,1143,1769,-1,3341,2583,1143,-1,1069,1261,1863,-1,1069,1062,1261,-1,1865,3340,1866,-1,1865,3339,3340,-1,2714,1870,2693,-1,2714,1871,1870,-1,1873,2577,1874,-1,1873,2578,2577,-1,1125,2719,2718,-1,2719,1125,1124,-1,2556,1906,2568,-1,1906,2556,1908,-1,1324,1113,1882,-1,1324,1883,1113,-1,3490,3500,1911,-1,3500,3490,1020,-1,1887,1814,1257,-1,3717,1814,1887,-1,1339,3349,1340,-1,3328,3349,1339,-1,2563,3376,1041,-1,2563,3375,3376,-1,1891,1034,1341,-1,1890,1034,1891,-1,1895,2792,1258,-1,1895,3488,2792,-1,3375,1078,1077,-1,3375,2563,1078,-1,1138,1286,2581,-1,1286,1138,1287,-1,2692,3491,1288,-1,2692,3359,3491,-1,1868,1070,3388,-1,1867,1070,1868,-1,1897,1348,1347,-1,1897,1898,1348,-1,1351,1899,1761,-1,1899,1351,3716,-1,2688,1765,1764,-1,3479,1765,2688,-1,1832,1474,1901,-1,1137,1474,1832,-1,1902,1859,1770,-1,1859,1902,1335,-1,1484,3352,3327,-1,1484,1827,3352,-1,3487,1042,2724,-1,1040,1042,3487,-1,1150,1037,1338,-1,2611,1037,1150,-1,1888,1339,2689,-1,2723,1339,1888,-1,3499,1117,1111,-1,1905,1117,3499,-1,3354,1879,1118,-1,3366,1879,3354,-1,1022,1102,1023,-1,1105,1102,1022,-1,1886,1911,3500,-1,1886,1912,1911,-1,1480,3489,1479,-1,1480,3490,3489,-1,2706,1149,2586,-1,1860,1149,2706,-1,1916,469,1243,-1,1918,469,1916,-1,1973,832,1974,-1,1973,1971,832,-1,825,1267,2516,-1,828,1267,825,-1,3188,831,1972,-1,3690,831,3188,-1,2512,819,2676,-1,818,819,2512,-1,814,2752,1674,-1,2752,814,3688,-1,1919,823,2511,-1,823,1919,3186,-1,2734,2731,3310,-1,2731,2734,2729,-1,911,950,995,-1,911,952,950,-1,995,988,996,-1,2732,988,995,-1,3502,3321,3323,-1,3320,3321,3502,-1,1924,3502,2548,-1,1923,3502,1924,-1,1924,2733,2547,-1,1924,2549,2733,-1,2547,3301,3715,-1,2547,2733,3301,-1,3715,3303,962,-1,3715,3301,3303,-1,1599,1925,1600,-1,1925,1599,984,-1,963,3317,2544,-1,965,3317,963,-1,2739,967,2537,-1,967,2739,2735,-1,2739,2541,969,-1,2739,3300,2541,-1,982,3507,3506,-1,982,3505,3507,-1,3311,2541,3309,-1,3311,2738,2541,-1,2540,1001,1000,-1,2540,3506,1001,-1,3714,3314,3325,-1,3714,3312,3314,-1,3296,2537,3295,-1,3296,2739,2537,-1,1928,1613,3302,-1,1613,1928,1614,-1,978,3298,1926,-1,978,1930,3298,-1,3287,963,2545,-1,1931,963,3287,-1,2740,966,974,-1,2740,959,966,-1,2539,3508,2737,-1,3511,3508,2539,-1,3286,971,1931,-1,3286,2534,971,-1,3289,3713,3509,-1,3713,3289,3288,-1,3712,3511,3510,-1,3511,3712,3508,-1,817,3713,820,-1,817,3509,3713,-1,3510,1985,3712,-1,1985,3510,1986,-1,2535,816,3689,-1,2535,3285,816,-1,3278,1936,986,-1,3278,3277,1936,-1,3273,2656,3263,-1,3273,945,2656,-1,2661,3256,1615,-1,2661,3261,3256,-1,1937,3271,2532,-1,1937,3270,3271,-1,1939,3261,2661,-1,1939,3260,3261,-1,1941,1942,1944,-1,1941,1940,1942,-1,940,935,2527,-1,940,934,935,-1,3258,2659,3460,-1,2659,3258,3268,-1,3460,3259,3258,-1,3460,3461,3259,-1,927,3259,3461,-1,927,929,3259,-1,3265,3519,3264,-1,3710,3519,3265,-1,3519,3275,3518,-1,3519,3274,3275,-1,3710,3274,3519,-1,3710,3512,3274,-1,3711,3512,3710,-1,3711,3513,3512,-1,3517,3513,3711,-1,3517,3514,3513,-1,3516,3514,3517,-1,3516,3515,3514,-1,3267,941,2527,-1,3267,1940,941,-1,3254,3269,3268,-1,3254,3520,3269,-1,915,929,928,-1,915,1948,929,-1,3257,1935,949,-1,3257,1948,1935,-1,3262,3277,3279,-1,3262,3520,3277,-1,3218,3521,3216,-1,3725,3521,3218,-1,1949,2747,3537,-1,1949,901,2747,-1,3725,3248,3521,-1,3249,3248,3725,-1,1949,3247,1950,-1,3247,1949,3537,-1,3201,907,898,-1,907,3201,3251,-1,2746,908,1951,-1,2746,906,908,-1,1952,3246,1953,-1,1952,3241,3246,-1,3524,899,2745,-1,3524,3709,899,-1,3525,905,904,-1,3525,3708,905,-1,3709,3526,3707,-1,3526,3709,3524,-1,3527,3708,3525,-1,3527,3706,3708,-1,3526,3705,3707,-1,3528,3705,3526,-1,3529,3706,3527,-1,3529,3704,3706,-1,3528,3703,3705,-1,3530,3703,3528,-1,3531,3704,3529,-1,3531,3702,3704,-1,3530,3701,3703,-1,3532,3701,3530,-1,3700,3531,3533,-1,3700,3702,3531,-1,3532,3699,3701,-1,3534,3699,3532,-1,3698,3533,3535,-1,3698,3700,3533,-1,3534,3697,3699,-1,3536,3697,3534,-1,3214,3535,3212,-1,3214,3698,3535,-1,3253,3536,3252,-1,3253,3697,3536,-1,3243,3235,3239,-1,3243,3231,3235,-1,3245,3231,3243,-1,3245,3228,3231,-1,3249,3228,3245,-1,3249,3226,3228,-1,3725,3226,3249,-1,3725,3222,3226,-1,3218,3222,3725,-1,3218,3215,3222,-1,3538,3219,3223,-1,3219,3538,3696,-1,3238,3695,3234,-1,3238,3539,3695,-1,3692,3522,3523,-1,3692,3540,3522,-1,3694,896,3541,-1,3694,897,896,-1,3542,895,894,-1,3693,895,3542,-1,3543,3692,892,-1,3692,3543,3540,-1,3196,3544,1954,-1,3198,3544,3196,-1,3543,1958,2523,-1,3543,888,1958,-1,880,1954,3544,-1,880,883,1954,-1,2524,1958,875,-1,2523,1958,2524,-1,887,871,1959,-1,887,1956,871,-1,1961,879,865,-1,1961,2522,879,-1,874,876,1955,-1,864,876,874,-1,2519,868,867,-1,2519,1963,868,-1,844,855,854,-1,855,844,846,-1,2517,852,3189,-1,1964,852,2517,-1,2520,840,1965,-1,2520,841,840,-1,838,2518,1968,-1,2518,838,837,-1,1969,3691,3190,-1,1969,1970,3691,-1,830,847,1966,-1,847,830,829,-1,1970,1975,3691,-1,1970,1983,1975,-1,1917,1801,1918,-1,1801,1917,2516,-1,1265,1268,2515,-1,1268,1265,1269,-1,3690,836,1974,-1,3690,2749,836,-1,1976,1979,1977,-1,1976,1980,1979,-1,3501,3689,3688,-1,3501,3280,3689,-1,809,3147,3568,-1,809,1245,3147,-1,2632,3139,2502,-1,2632,2631,3139,-1,3147,1994,3146,-1,3147,1245,1994,-1,3183,3683,3547,-1,3182,3683,3183,-1,3185,799,801,-1,3185,3184,799,-1,2508,800,3150,-1,2508,798,800,-1,2765,2000,3180,-1,2765,745,2000,-1,2507,2003,2002,-1,2507,2004,2003,-1,2007,3181,3564,-1,2007,2001,3181,-1,3549,791,3551,-1,3549,789,791,-1,2506,3564,3154,-1,2506,2007,3564,-1,3687,3551,3550,-1,3687,3549,3551,-1,3686,3154,3153,-1,3686,2506,3154,-1,3170,3550,3171,-1,3170,3687,3550,-1,3686,3169,3168,-1,3686,3153,3169,-1,3556,3123,3172,-1,2764,3123,3556,-1,3554,786,788,-1,3685,786,3554,-1,3555,2764,3556,-1,2496,2764,3555,-1,3685,3557,3684,-1,3685,3554,3557,-1,781,2496,3555,-1,2042,2496,781,-1,3547,3684,3557,-1,3683,3684,3547,-1,3166,783,785,-1,3682,783,3166,-1,3169,2008,3164,-1,2008,3169,2009,-1,3680,3564,3181,-1,3563,3564,3680,-1,3184,2509,799,-1,2509,3184,3681,-1,3149,3576,3566,-1,3149,3565,3576,-1,772,2051,2015,-1,2017,2051,772,-1,2756,3109,3566,-1,2756,2049,3109,-1,3567,2493,2053,-1,3145,2493,3567,-1,2047,2503,2048,-1,2503,2047,3569,-1,3567,3144,3568,-1,3567,3142,3144,-1,3546,759,3545,-1,3546,3569,759,-1,1992,2757,1990,-1,1992,2018,2757,-1,3113,3120,3570,-1,3113,3112,3120,-1,3111,3114,3110,-1,3114,3111,3678,-1,3117,3677,3679,-1,3117,2022,3677,-1,2023,3571,2024,-1,3132,3571,2023,-1,2033,2026,2025,-1,2026,2033,3573,-1,2035,750,2028,-1,750,2035,748,-1,2030,2498,2038,-1,3572,2498,2030,-1,2024,3572,2030,-1,2024,3571,3572,-1,3573,2019,2026,-1,3573,3131,2019,-1,2035,740,2034,-1,2035,739,740,-1,3129,2037,734,-1,2038,2037,3129,-1,3574,3179,3175,-1,3574,3575,3179,-1,802,3118,803,-1,802,3116,3118,-1,743,3570,3120,-1,3575,3570,743,-1,3122,3133,2043,-1,3122,3679,3133,-1,3678,3124,3126,-1,3678,3136,3124,-1,757,3677,755,-1,3677,757,2045,-1,3137,2020,3130,-1,3134,2020,3137,-1,747,3576,2032,-1,747,774,3576,-1,2041,3565,777,-1,2040,3565,2041,-1,2050,2047,2494,-1,2050,760,2047,-1,3148,767,766,-1,3148,2053,767,-1,2459,2933,358,-1,2868,2933,2459,-1,2489,2055,2056,-1,2489,688,2055,-1,728,3581,3676,-1,728,727,3581,-1,2054,2060,2059,-1,2054,2058,2060,-1,3676,717,716,-1,3676,3581,717,-1,2058,2061,2060,-1,2058,2492,2061,-1,2087,2492,2062,-1,2061,2492,2087,-1,2770,712,715,-1,712,2770,2063,-1,2065,2087,3578,-1,2088,2087,2065,-1,3578,703,2065,-1,3578,704,703,-1,2070,2069,2071,-1,2070,2068,2069,-1,2076,2072,705,-1,2072,2076,694,-1,2074,2080,2078,-1,2074,700,2080,-1,2078,2079,3580,-1,2078,2080,2079,-1,3580,3104,730,-1,3580,2079,3104,-1,676,689,677,-1,689,676,3100,-1,2089,3099,711,-1,667,3099,2089,-1,708,672,2065,-1,708,2086,672,-1,2085,2488,673,-1,2223,2488,2085,-1,666,2919,667,-1,2918,2919,666,-1,2917,2485,671,-1,2917,2486,2485,-1,3622,3583,2906,-1,3622,3582,3583,-1,2092,533,2484,-1,533,2092,2157,-1,3675,2473,2772,-1,2473,3675,535,-1,3675,3585,535,-1,3675,3671,3585,-1,3671,3586,3585,-1,3671,3611,3586,-1,3589,2976,2975,-1,3589,3085,2976,-1,2483,2812,2894,-1,2812,2483,651,-1,2774,2481,644,-1,2774,2103,2481,-1,2102,2107,638,-1,2105,2102,641,-1,2102,2105,2107,-1,3090,3589,3587,-1,3090,3089,3589,-1,3093,2094,2093,-1,2094,3093,3095,-1,2099,2102,2104,-1,641,2102,2099,-1,2096,2105,2106,-1,2107,2105,2096,-1,337,2446,335,-1,2446,337,2447,-1,3590,2479,2127,-1,3590,3595,2479,-1,603,2110,2891,-1,602,2110,603,-1,3595,3596,3594,-1,3590,3596,3595,-1,2891,637,636,-1,2110,637,2891,-1,3594,3075,3076,-1,3596,3075,3594,-1,3069,2478,596,-1,3069,3074,2478,-1,634,3078,633,-1,3078,634,2112,-1,2114,3077,2116,-1,3077,2114,2113,-1,2777,622,631,-1,2777,621,622,-1,620,627,618,-1,627,620,2120,-1,2118,2122,3073,-1,2118,2121,2122,-1,3603,2122,2121,-1,3603,2124,2122,-1,2480,616,2778,-1,2480,326,616,-1,2124,3674,2125,-1,3603,3674,2124,-1,2128,2125,3674,-1,2128,2129,2125,-1,2133,3591,3081,-1,2133,2132,3591,-1,3608,623,629,-1,623,3608,3601,-1,2134,3074,3597,-1,2134,2478,3074,-1,2139,1361,564,-1,1361,2139,1747,-1,1399,1388,1838,-1,1736,1388,1399,-1,3006,3057,3056,-1,3003,3057,3006,-1,3065,3051,3053,-1,3064,3051,3065,-1,3049,3061,3060,-1,3049,3048,3061,-1,3044,3058,3055,-1,3044,3046,3058,-1,3054,3042,3052,-1,3054,2991,3042,-1,3040,3047,3038,-1,3047,3040,3050,-1,3036,3045,3034,-1,3045,3036,3043,-1,2990,3031,3041,-1,2990,3029,3031,-1,3027,3039,3025,-1,3039,3027,3037,-1,3035,3024,3033,-1,3035,3022,3024,-1,3032,3020,3030,-1,3032,571,3020,-1,3018,3028,3016,-1,3028,3018,3026,-1,3013,3023,3014,-1,3023,3013,3021,-1,3019,2144,3010,-1,570,2144,3019,-1,3008,2476,3017,-1,3008,2141,2476,-1,3005,3015,3012,-1,3005,3004,3015,-1,3011,3066,3063,-1,2992,3066,3011,-1,3062,3007,3009,-1,3062,3059,3007,-1,3066,555,3064,-1,3066,556,555,-1,2987,3032,3029,-1,3032,2987,2986,-1,3609,3054,3051,-1,3054,3609,3610,-1,573,2149,2140,-1,2149,573,552,-1,562,2145,553,-1,562,2151,2145,-1,3609,2475,3610,-1,2475,3609,568,-1,2399,20,22,-1,2399,2397,20,-1,1549,2158,1550,-1,2158,1549,3444,-1,2152,2154,2153,-1,3424,2154,2152,-1,2982,517,1653,-1,2982,518,517,-1,2978,2983,2981,-1,2978,2980,2983,-1,544,2979,1514,-1,544,542,2979,-1,1638,2985,1493,-1,1638,2472,2985,-1,3588,2895,3611,-1,3588,2975,2895,-1,2980,3670,2983,-1,2980,3612,3670,-1,2166,3612,516,-1,2169,3612,2166,-1,2784,2163,2162,-1,2163,2784,3613,-1,3670,510,2785,-1,510,3670,2168,-1,2970,2163,3613,-1,2970,2787,2163,-1,513,507,3614,-1,507,513,512,-1,2967,2974,3614,-1,2967,2966,2974,-1,492,2470,2167,-1,493,2470,492,-1,501,2972,2969,-1,501,503,2972,-1,2171,2968,2175,-1,2968,2171,2170,-1,2177,3615,483,-1,2177,3619,3615,-1,2174,3616,487,-1,2174,3618,3616,-1,3668,491,3669,-1,3668,2468,491,-1,2208,3356,473,-1,409,3356,2208,-1,2188,2193,2180,-1,2188,2194,2193,-1,2958,2467,2181,-1,2467,2958,3667,-1,452,2190,453,-1,452,2191,2190,-1,3617,3619,444,-1,3619,3617,3615,-1,2468,2192,2183,-1,3668,2192,2468,-1,3621,3618,448,-1,3618,3621,3616,-1,2964,3620,3667,-1,3620,2964,3617,-1,2184,2194,2182,-1,2194,2184,2183,-1,2190,3621,2793,-1,2190,2189,3621,-1,2677,2203,1081,-1,456,2203,2677,-1,3665,430,467,-1,3665,431,430,-1,2957,2204,2203,-1,2957,2936,2204,-1,3666,3622,2195,-1,3582,3622,3666,-1,3664,2463,3624,-1,3664,3623,2463,-1,2946,2195,2197,-1,3666,2195,2946,-1,3624,2200,436,-1,3624,2463,2200,-1,441,2462,442,-1,441,3625,2462,-1,2950,2945,2948,-1,2950,2944,2945,-1,435,427,2937,-1,427,435,434,-1,3625,2201,2462,-1,2205,2201,3625,-1,2955,3626,2954,-1,3626,2955,2905,-1,2900,3623,3664,-1,2902,3623,2900,-1,2943,2206,2205,-1,2943,2956,2206,-1,419,414,2210,-1,419,421,414,-1,3628,2459,2417,-1,3628,3577,2459,-1,3629,2866,3577,-1,3629,3663,2866,-1,2213,2913,2214,-1,2213,2909,2913,-1,2217,2811,2932,-1,2811,2217,2215,-1,2867,2931,2458,-1,2869,2931,2867,-1,2219,2908,2216,-1,2219,2929,2908,-1,2927,262,2930,-1,2927,2433,262,-1,263,376,255,-1,376,263,260,-1,2922,3627,3628,-1,2921,3627,2922,-1,2798,2451,2434,-1,2451,2798,2809,-1,3630,2924,2926,-1,3631,2924,3630,-1,3631,2923,2924,-1,3662,2923,3631,-1,3662,2921,2923,-1,3663,2921,3662,-1,3663,3627,2921,-1,3629,3627,3663,-1,2238,3635,2810,-1,2238,365,3635,-1,2810,3658,2450,-1,2810,3635,3658,-1,2809,2896,2451,-1,2809,2234,2896,-1,2487,394,3098,-1,2487,392,394,-1,657,2455,2453,-1,656,2455,657,-1,2916,2227,396,-1,2916,386,2227,-1,378,393,379,-1,393,378,2801,-1,390,383,2805,-1,2453,383,390,-1,3633,3661,3660,-1,3633,3632,3661,-1,3659,2929,2928,-1,3659,3634,2929,-1,2914,2906,3583,-1,2914,2904,2906,-1,3660,3096,3633,-1,3660,3097,3096,-1,2939,3634,3659,-1,3634,2939,2941,-1,2423,262,264,-1,262,2423,405,-1,226,2220,2231,-1,375,2220,226,-1,2233,2897,2232,-1,2897,2233,2432,-1,2292,2232,2293,-1,2292,374,2232,-1,3635,382,3658,-1,3635,381,382,-1,653,413,655,-1,653,2794,413,-1,651,340,2812,-1,650,340,651,-1,2242,341,250,-1,2242,2244,341,-1,2776,2813,333,-1,2776,632,2813,-1,2444,622,617,-1,622,2444,2246,-1,317,298,318,-1,317,299,298,-1,332,306,305,-1,332,331,306,-1,2250,2445,3636,-1,2247,2445,2250,-1,300,2254,2253,-1,2254,300,2814,-1,2260,2241,2261,-1,2260,2251,2241,-1,2250,2890,2257,-1,2250,3636,2890,-1,2249,2256,2260,-1,2249,2255,2256,-1,3639,2834,6,-1,3726,2834,3639,-1,2865,2267,2440,-1,2864,2267,2865,-1,2309,2272,2271,-1,2272,2309,168,-1,2273,1807,246,-1,2273,1808,1807,-1,196,2395,2823,-1,196,94,2395,-1,2884,62,2846,-1,2884,2281,62,-1,3637,2375,2404,-1,3637,3655,2375,-1,2277,1222,1221,-1,2277,284,1222,-1,3645,2887,2886,-1,2887,3645,2820,-1,2857,3657,3647,-1,2857,3638,3657,-1,235,2888,194,-1,140,2888,235,-1,3644,2872,2860,-1,3644,280,2872,-1,3726,2398,2834,-1,3652,2398,3726,-1,224,376,225,-1,376,224,256,-1,373,2452,374,-1,373,2308,2452,-1,2883,2881,145,-1,2881,2883,2882,-1,234,247,230,-1,234,142,247,-1,2421,3641,2819,-1,2421,3642,3641,-1,2302,3656,2818,-1,3656,2302,2301,-1,2304,2876,2878,-1,2876,2304,2303,-1,244,3385,2880,-1,244,3383,3385,-1,2428,2304,3643,-1,2304,2428,2305,-1,218,2315,2311,-1,2315,218,217,-1,2882,210,2881,-1,2882,2821,210,-1,2295,2332,2296,-1,2427,2332,2295,-1,2887,2301,2270,-1,2887,3656,2301,-1,2265,2307,2266,-1,2265,2429,2307,-1,2863,3641,2299,-1,2863,2862,3641,-1,2300,2312,2313,-1,2312,2300,287,-1,2419,254,2317,-1,2419,264,254,-1,162,2322,2321,-1,2816,2322,162,-1,2282,148,236,-1,148,2282,143,-1,3657,3655,3637,-1,3657,3638,3655,-1,2328,190,2326,-1,191,190,2328,-1,2341,175,187,-1,176,175,2341,-1,185,153,152,-1,185,184,153,-1,3642,2886,2297,-1,2886,3642,3645,-1,187,269,2341,-1,269,187,2321,-1,2268,140,206,-1,2267,140,2268,-1,2874,202,2310,-1,2874,2873,202,-1,220,2825,174,-1,2825,220,2230,-1,372,2336,169,-1,372,371,2336,-1,3654,2883,3646,-1,2283,2883,3654,-1,3644,2415,2327,-1,112,2415,3644,-1,292,126,128,-1,126,292,129,-1,126,2356,127,-1,126,109,2356,-1,125,2858,2859,-1,2858,125,2826,-1,111,2826,124,-1,2355,2826,111,-1,2359,2357,135,-1,2357,2359,2412,-1,2325,3646,3647,-1,2325,3654,3646,-1,272,296,295,-1,1706,296,272,-1,2848,2372,2852,-1,2848,2373,2372,-1,3649,2838,2837,-1,3648,2838,3649,-1,2856,67,3650,-1,13,67,2856,-1,2375,2839,2376,-1,2885,2839,2375,-1,2403,2377,2378,-1,2404,2377,2403,-1,2391,2827,2381,-1,2827,2391,2830,-1,2379,2275,2380,-1,2379,2394,2275,-1,42,2381,57,-1,2392,2381,42,-1,2840,85,84,-1,2840,80,85,-1,45,2405,98,-1,45,44,2405,-1,3650,2378,2377,-1,2378,3650,67,-1,2850,2847,2844,-1,2847,2850,2849,-1,18,14,49,-1,15,14,18,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='ethmoid2_Coord',point=[(.0207,57.59117,2.14434),(.03513,57.50466,2.16178),(.02207,57.57765,2.1299),(.02442,57.62037,2.20977),(.03678,57.51582,2.24182),(.01839,57.61111,2.14997),(.0208,57.70917,2.19067),(.01983,57.71733,2.15712),(.0208,57.69128,2.35689),(.02461,57.66131,2.29016),(.02015,57.70207,2.34716),(.01771,56.65684,1.92255),(.01449,56.64401,1.85546),(.02068,56.67134,1.92396),(.01112,56.66807,2.10447),(.01324,56.66535,2.18064),(0,56.66637,2.20648),(.01324,56.66613,2.19028),(.01714,56.67663,2.18366),(.02207,56.68923,2.24116),(0,57.75625,2.34451),(.0463,57.65886,2.36805),(.05951,57.66294,2.36662),(.0199,57.69641,2.13403),(.01985,57.65533,2.13884),(0,57.71725,2.09642),(.01451,57.05812,1.48782),(0,57.01745,1.48688),(0,57.08708,1.48796),(.01428,57.14836,1.523),(.01646,57.04218,1.49639),(.03321,57.15317,2.38015),(.03997,57.29209,2.32292),(.06196,57.32239,2.3672),(.04132,57.24239,2.26022),(.03933,57.21613,2.23157),(.07539,57.39728,2.16144),(.02596,56.85004,1.54355),(.03346,56.91948,1.63265),(.0202,56.72813,1.64018),(.02453,57.27656,2.53052),(-.00015,57.34559,2.56703),(.0245,57.26692,2.52835),(.01254,56.6685,1.99011),(.01039,56.66324,1.9962),(.01066,56.6601,1.98514),(.01338,56.68185,2.04153),(.01546,56.68413,2.05342),(0,56.66927,2.15048),(.01656,56.67954,2.10077),(.0125,56.67092,2.09126),(.06399,57.39835,2.43972),(.03808,57.33794,2.45569),(.06251,57.43324,2.37511),(.03772,57.31701,2.47808),(.03144,57.27431,2.45205),(.02831,57.3665,2.50775),(.02703,57.3008,2.49899),(.03006,57.14704,2.44421),(.03077,57.21722,2.41574),(.07962,57.38785,2.12352),(.04131,57.17539,2.14315),(.0944,57.36747,2.07147),(.01664,56.69307,2.05627),(.01432,56.68783,2.06365),(.02783,56.84229,1.79002),(.02746,56.84626,1.79408),(.01985,56.87642,1.85851),(0,56.80812,1.60823),(0,56.91409,1.52561),(.01176,56.64882,1.91762),(0,56.63954,1.9497),(.01515,56.67765,2.06719),(0,56.66929,2.16308),(.02698,56.76727,2.35404),(.02918,56.82114,2.37442),(.0285,56.82986,2.39557),(.02952,56.8526,2.40755),(.03113,56.86664,2.39837),(.03169,56.99862,2.4336),(.03684,57.43122,2.51122),(.02587,56.84056,2.40331),(.02377,56.75827,2.35696),(0,57.59781,2.47217),(0,57.59347,2.47459),(.03285,57.51345,2.45068),(.01872,56.96764,2.42286),(.0271,57.08197,2.48393),(0,57.03234,2.4976),(.01878,56.70186,2.31345),(.02118,56.74377,2.35356),(0,56.76722,2.45921),(.01593,56.67606,2.07569),(0,56.66725,2.18799),(.04502,57.42101,2.27258),(0,56.69532,1.72027),(.03168,57.16834,1.55839),(.01808,57.32851,2.542),(0,56.64289,2.08638),(0,56.66293,2.03317),(.20414,56.8469,1.55969),(.20377,56.84243,1.55149),(.25629,56.76331,1.55988),(.20205,56.8577,1.58814),(.18171,56.88597,1.60759),(.20302,56.83739,1.53993),(.17283,56.89147,1.58519),(.11694,56.94724,1.63345),(.10595,56.98103,1.68063),(.09313,57.04199,1.60261),(.10102,56.95866,1.73489),(.11255,57.02684,1.71503),(.1048,56.9535,1.70732),(.14214,56.98169,1.62558),(.15635,56.9533,1.59339),(.12803,56.93133,1.63773),(.04663,57.10797,1.51706),(.08907,57.01656,1.57255),(.10054,57.0376,1.75671),(.10731,57.02422,1.71367),(.10908,57.02388,1.71466),(.14072,56.91879,1.62274),(.16786,56.8993,1.58896),(.14882,56.9071,1.63286),(.12471,57.00281,1.6737),(.13504,56.99209,1.61591),(.08452,57.12139,1.55009),(.11664,57.16313,1.60207),(.08022,57.14875,1.55257),(.05637,57.11642,1.52456),(.09028,57.0061,1.54917),(.10014,57.00352,1.51047),(.16775,56.88808,1.54815),(.25815,56.76112,1.56463),(.26641,56.74847,1.52303),(.26726,56.79662,1.49653),(.27062,56.86664,1.45848),(.28215,56.76319,1.48966),(.26838,56.74474,1.52778),(.11173,57.17441,2.13925),(.11271,57.17927,2.19729),(.11329,57.17825,2.13723),(.11071,57.16099,2.08299),(.10943,57.16538,2.08105),(.0958,57.13634,2.0374),(.0807,57.03105,1.92916),(.08531,57.08184,1.99268),(.08008,57.03623,1.92783),(.11307,57.18592,2.13385),(.0784,56.90456,2.16784),(.07995,56.92073,2.21845),(.10866,57.00353,2.12718),(.12967,57.02033,1.66433),(.13079,57.03078,1.69038),(.12694,56.93463,1.7139),(.12889,57.0353,1.69777),(.13137,57.05259,1.7251),(.12027,56.94332,1.75273),(.15132,57.00341,1.67901),(.12885,57.08962,1.63758),(.13106,57.08228,1.62919),(.2007,56.95261,1.59357),(.19139,56.95857,1.59968),(.19543,57.02715,1.56499),(.14736,57.00531,1.68967),(.13639,57.10703,1.65802),(.14576,57.25026,2.05304),(.13949,57.26008,1.99506),(.14177,57.07502,2.04999),(.18415,56.89484,1.59618),(.20563,56.85979,1.5857),(.19684,56.8824,1.59227),(.13404,57.06564,1.60135),(.13041,57.08163,1.62717),(.12916,57.01765,1.65474),(.16386,57.04016,1.56595),(.15052,57.05112,1.58167),(.15117,56.99843,1.60619),(.17337,56.89621,1.61888),(.17225,56.89504,1.6183),(.14476,56.91062,1.66144),(.13525,56.91754,1.68733),(.13395,56.91604,1.68699),(.13506,57.0662,1.60186),(.13326,57.10853,1.65989),(.13066,57.08915,1.63552),(.19333,57.02605,1.5637),(.16566,57.04067,1.56642),(.17111,56.89524,1.61122),(.15754,56.90375,1.63719),(.12486,56.91619,1.68298),(.13531,56.91523,1.65661),(.12925,56.92592,1.6395),(.10299,57.39706,2.16203),(.11342,57.27232,2.20549),(.11539,57.28506,2.2387),(.07404,57.42216,2.27869),(.10395,57.31061,2.31572),(.10271,57.32379,2.36224),(.15349,56.87887,1.71781),(.1301,56.92052,1.7177),(.12624,56.91825,1.71696),(.10852,57.10021,1.97557),(.11191,57.13018,2.03435),(.11361,57.12653,2.03902),(.12432,57.15303,2.08459),(.13178,57.23657,2.10578),(.11991,57.16606,2.14111),(.1224,56.92861,1.73238),(.12338,56.93419,1.76224),(.10108,56.98988,1.93745),(.1049,56.99045,1.93681),(.10384,57.04969,2.00268),(.12372,56.92196,1.76537),(.12477,56.91764,1.74595),(.12404,56.9224,1.7675),(.10979,56.93561,1.80018),(.11239,56.93521,1.80018),(.11139,56.96407,1.88134),(.1315,56.92993,1.69216),(.135,56.92911,1.68445),(.1402,56.86852,1.76833),(.10199,56.81167,1.761),(.09697,56.8396,1.83865),(.17734,56.874,1.69655),(.22862,56.88791,1.72699),(.2555,56.85677,1.73262),(.13885,56.85294,1.69785),(.13697,56.8582,1.74129),(.14711,56.86362,1.7073),(.09578,57.11863,2.0477),(.10261,57.10719,2.05159),(.12229,57.14627,2.09051),(.11662,57.16492,2.14204),(.11118,57.1526,2.08743),(.11501,57.26594,2.16722),(.11558,57.25325,2.11225),(.12384,57.14591,2.09046),(.10703,57.10608,2.05087),(.10744,57.02607,1.92512),(.11121,57.07974,1.98816),(.12889,56.91918,1.74653),(.11927,56.83906,1.7182),(.098,56.87926,2.04302),(.08899,56.82126,2.13304),(.08326,56.89305,2.11011),(.08812,56.77537,1.86557),(.09661,57.13479,2.04132),(.2416,56.86357,1.5927),(.24045,56.86656,1.59455),(.2388,56.86165,1.59249),(.23572,56.85838,1.59853),(.21732,56.85749,1.59466),(.21189,56.88589,1.60942),(.1699,56.89629,1.68871),(.18441,56.90577,1.71622),(.17597,56.88571,1.69749),(.23311,56.91661,1.69561),(.24265,56.90881,1.67591),(.2338,56.9078,1.6945),(.2055,56.91138,1.69778),(.20796,56.9179,1.69601),(.19095,56.92035,1.68267),(.18886,56.9118,1.68625),(.15551,56.89619,1.66492),(0,57.63047,2.13033),(.03851,57.56985,2.32181),(.04645,57.41229,2.18663),(.06172,57.4238,2.26497),(.16747,56.97426,1.61315),(.15464,56.98834,1.63789),(.16715,57.31131,1.88222),(.14951,57.30128,1.72864),(0,57.31377,1.7437),(0,57.38284,2.00514),(.15239,57.34872,2.02083),(.1468,57.30788,1.94797),(.1064,57.20578,2.01258),(.10942,57.1806,1.96697),(.10052,57.14381,1.97551),(.11794,56.92961,1.71477),(0,57.67272,2.39451),(.04663,57.59828,2.39379),(.08118,57.48485,2.44515),(.07098,57.52746,2.43711),(.06585,57.51285,2.44363),(.09757,57.45122,2.42605),(.1322,57.2493,2.05246),(.18749,57.00776,1.4422),(.09491,57.02657,1.48896),(.19086,57.01526,1.43743),(.1192,57.45521,2.43814),(.05009,57.13646,1.52365),(.08786,57.45068,2.42411),(.22712,57.05255,1.46634),(.04266,57.13423,1.46325),(.2253,57.10908,1.50555),(.01975,57.62471,2.15282),(.27776,56.8571,1.6036),(.27691,56.85603,1.60181),(.27806,56.85652,1.60447),(.2712,56.86527,1.60323),(.27166,56.86511,1.60308),(.27395,56.86442,1.6048),(.27193,56.8545,1.59516),(.27286,56.85523,1.59582),(.27078,56.85766,1.59515),(.26986,56.86616,1.60272),(.26714,56.86395,1.59746),(.2716,56.85002,1.59166),(.27082,56.83958,1.58972),(.27618,56.85198,1.59894),(.2742,56.86407,1.60617),(.27337,56.86438,1.6051),(.27168,56.86544,1.60271),(.27423,56.86763,1.60404),(.27955,56.88381,1.60131),(.28183,56.86501,1.59955),(.28256,56.86595,1.60184),(.27831,56.88278,1.59839),(.27607,56.88222,1.5965),(.27984,56.86329,1.59512),(.27886,56.88481,1.60372),(.26624,56.91349,1.60214),(.27668,56.88562,1.60547),(.2734,56.88605,1.60619),(.26149,56.91238,1.6059),(.26981,56.88596,1.60566),(.27013,56.865,1.59945),(.27014,56.86479,1.59674),(.26672,56.88329,1.59821),(.27281,56.8636,1.59433),(.27662,56.86337,1.59453),(.27276,56.88204,1.59547),(.26927,56.83823,1.58604),(.26631,56.83302,1.58495),(.24613,56.83989,1.58764),(.26101,56.83087,1.58398),(.24743,56.83767,1.58423),(.24288,56.84006,1.58336),(.24029,56.86461,1.59071),(.23728,56.86184,1.58997),(.28719,56.85674,1.61705),(.28398,56.8821,1.63212),(.28774,56.88597,1.62737),(.25413,56.8632,1.59024),(.21376,56.86476,1.5733),(.27264,56.82094,1.62319),(.28965,56.86042,1.63651),(.25771,56.83272,1.61356),(.27619,56.86082,1.65766),(.266,56.88873,1.65015),(.28165,56.88403,1.64037),(.26374,56.92502,1.66533),(.26405,56.93013,1.66387),(.27494,56.91564,1.65562),(.26088,56.95522,1.67953),(.26039,56.94898,1.68077),(.25792,56.96501,1.69993),(.26045,56.93863,1.67927),(.26052,56.94226,1.67942),(.26408,56.94244,1.67958),(.26321,56.93046,1.66757),(.26729,56.93512,1.67165),(.2675,56.93587,1.6701),(.26383,56.94119,1.6649),(.26632,56.93946,1.668),(.26573,56.94192,1.66815),(.26328,56.94711,1.67843),(.2609,56.9471,1.67832),(.26138,56.95011,1.67667),(.18416,56.97953,1.58383),(.18599,56.97574,1.57873),(.14455,56.85555,1.69309),(.13349,56.84018,1.68226),(.23106,56.89386,1.70653),(.20865,56.90794,1.71955),(.26653,56.9358,1.67433),(.27606,56.94046,1.67721),(.27404,56.94128,1.67372),(.2704,56.94342,1.67097),(.26434,56.9446,1.66944),(.26315,56.94747,1.67301),(.26501,56.94828,1.67391),(.26267,56.94829,1.67601),(.26521,56.94956,1.67817),(.27283,56.94513,1.68276),(.2743,56.9433,1.68199),(.26568,56.93806,1.67748),(.27,56.95053,1.67286),(.26853,56.94821,1.67155),(.2742,56.95096,1.6726),(.27574,56.95147,1.6736),(.27567,56.94402,1.67479),(.28067,56.95403,1.6777),(.27407,56.95698,1.68346),(.27088,56.95042,1.68263),(.26721,56.95388,1.67933),(.26748,56.90172,1.65269),(.28391,56.89957,1.6545),(.24562,56.94102,1.71625),(.24842,56.92957,1.69977),(.23568,56.88362,1.60268),(.21328,56.9523,1.66919),(.19164,56.93088,1.65793),(.19044,56.92157,1.63729),(.28768,56.90781,1.65568),(.27715,56.92711,1.65172),(.28641,56.74586,1.55509),(.25511,56.74052,1.54265),(.20439,56.77121,1.57278),(.26626,56.81563,1.56505),(.25554,56.82402,1.54838),(.23815,56.82907,1.55843),(.26307,56.82322,1.54338),(.25435,56.8529,1.51631),(.24086,56.85047,1.52218),(.27333,56.82956,1.5798),(.27392,56.83154,1.57278),(.27598,56.82125,1.56537),(.25944,56.85683,1.52334),(.2669,56.82929,1.54822),(.26496,56.84071,1.56116),(.3961,56.83921,1.66035),(.39626,56.83916,1.66015),(.3981,56.83888,1.66166),(.3926,56.83645,1.65665),(.39291,56.83635,1.65656),(.39409,56.83804,1.65801),(.39902,56.8373,1.66209),(.39918,56.83733,1.66261),(.39814,56.83895,1.66207),(.39818,56.8391,1.66215),(.39846,56.84003,1.65871),(.39445,56.83809,1.6539),(.39458,56.8368,1.65292),(.39548,56.83816,1.65242),(.39775,56.84144,1.65698),(.39685,56.84008,1.65748),(.39532,56.83934,1.65564),(.39894,56.84474,1.65033),(.40024,56.83999,1.65468),(.40111,56.84125,1.65643),(.31808,56.77645,1.58511),(.31813,56.77663,1.58487),(.31705,56.77535,1.58373),(.31144,56.77594,1.58059),(.31167,56.7756,1.58062),(.31192,56.77606,1.58055),(.32199,56.75549,1.60032),(.30937,56.77589,1.57976),(.31111,56.77702,1.58073),(.31701,56.77491,1.58384),(.31528,56.77333,1.58218),(.31668,56.77235,1.57857),(.31132,56.7766,1.5808),(.34582,56.8041,1.60959),(.31888,56.77959,1.58664),(.34842,56.79804,1.61094),(.32046,56.77805,1.58716),(.34927,56.79815,1.60811),(.2898,56.76427,1.48958),(.33348,56.88523,1.47972),(.35169,56.80898,1.54864),(.27844,56.8751,1.45278),(.24836,56.97421,1.43634),(.23891,56.96874,1.43936),(.40856,56.84254,1.67197),(.40897,56.84253,1.6669),(.44698,56.89671,1.7597),(.39761,56.83406,1.66049),(.38796,56.82677,1.65043),(.39892,56.83506,1.66186),(.21157,56.64184,1.49149),(.19008,56.69958,1.56937),(.20273,56.72348,1.561),(.18715,57.06657,1.42476),(.30595,56.99521,1.45236),(.31831,56.77917,1.58302),(.31613,56.7792,1.58162),(.30962,56.7883,1.56644),(.31234,56.7883,1.5668),(.31463,56.78657,1.5664),(.31966,56.77827,1.58359),(.30676,56.78515,1.56482),(.31315,56.77758,1.57915),(.3129,56.77676,1.57871),(.3141,56.77535,1.579),(.31646,56.77488,1.58035),(.31256,56.78055,1.56369),(.30694,56.78642,1.56534),(.31361,56.77824,1.57967),(.31468,56.79204,1.55144),(.31161,56.79315,1.55138),(.30784,56.79327,1.5508),(.30457,56.79254,1.54996),(.3025,56.79132,1.54914),(.3018,56.78989,1.54848),(.30695,56.78363,1.56425),(.30761,56.7825,1.56389),(.30444,56.78735,1.54796),(.30774,56.78679,1.54827),(.30937,56.7812,1.56359),(.31165,56.78708,1.54899),(.3015,56.79622,1.5421),(.29881,56.79332,1.53908),(.2994,56.7948,1.54071),(.29977,56.80559,1.53399),(.29988,56.80606,1.53588),(.30132,56.80572,1.53762),(.29992,56.80794,1.53606),(.30003,56.8133,1.53635),(.30016,56.80883,1.53422),(.3014,56.80948,1.53223),(.32427,56.80704,1.55908),(.32355,56.80287,1.54669),(.31691,56.80293,1.54704),(.28686,56.85627,1.54098),(.28916,56.82825,1.53979),(.29983,56.87892,1.55554),(.29042,56.87941,1.55494),(.30238,56.81766,1.53548),(.3346,56.84347,1.5433),(.31532,56.8657,1.55163),(.31295,56.82168,1.53596),(.20256,56.83364,1.6827),(.19048,56.85251,1.77296),(.15115,56.79698,1.66542),(.19491,56.85374,1.77478),(.273,56.93753,1.60685),(.27267,56.94249,1.61975),(.26823,56.91014,1.57868),(.25998,56.88836,1.56397),(.2705,56.88665,1.5422),(.25818,56.87026,1.56417),(.23415,56.87032,1.51637),(.25512,56.86209,1.54064),(.36345,56.87471,1.60834),(.35557,56.84016,1.57608),(.36853,56.85733,1.61323),(.33879,56.81513,1.55588),(.33388,56.80896,1.55878),(.35058,56.81847,1.57869),(.3625,56.91556,1.65166),(.361,56.84035,1.61906),(.29664,56.90316,1.56712),(.31733,56.89433,1.57151),(.34088,56.87791,1.57706),(.20999,56.79067,1.62088),(.24429,56.67754,1.57876),(.22158,56.79633,1.62276),(.18803,57.18209,2.14666),(.18793,57.18356,2.14622),(.19926,57.18404,2.15239),(.22251,57.17176,2.10922),(.22251,57.171,2.10952),(.22431,57.17487,2.12607),(.15721,57.19567,2.03214),(.2109,57.18254,2.04636),(.19319,57.18619,2.02727),(.20845,57.19722,2.17066),(.2266,57.18572,2.15536),(.21116,57.18255,2.15126),(.22007,57.17944,2.14183),(.24566,57.17337,2.14325),(.1531,57.19904,2.06835),(.16236,57.20256,2.1229),(.17688,57.17767,2.12068),(.21461,57.16959,2.09801),(.23966,57.17602,2.0796),(.21987,57.16163,2.2315),(.19406,57.15836,2.20257),(.19091,57.2101,2.19159),(.18514,57.20034,2.15379),(.18988,57.22347,2.17817),(.17309,57.24661,2.18108),(.17015,57.2499,2.18265),(.15434,57.3207,2.18262),(.14528,57.30988,2.15391),(.15344,57.33016,2.18213),(.24612,57.19281,2.29485),(.34219,57.36004,2.00829),(.33942,57.36403,1.99072),(.3266,57.32726,2.04949),(.2163,57.10946,1.62176),(.21376,57.0981,1.62038),(.19967,57.09615,1.61575),(.28001,57.08825,1.58105),(.27288,57.0939,1.59729),(.27206,57.10501,1.59846),(.25757,57.05435,1.52401),(.26685,57.07551,1.54842),(.2503,57.06297,1.52686),(.20266,57.05391,1.54216),(.20757,57.06426,1.5437),(.19028,57.08427,1.58528),(.23704,57.07543,1.53091),(.25271,57.08281,1.54132),(.24504,57.09035,1.54716),(.24304,57.12898,1.60953),(.24523,57.125,1.61581),(.22342,57.125,1.61957),(.26857,56.93794,1.59849),(.26587,56.9122,1.59785),(.30224,57.00184,1.60016),(.29731,56.98507,1.6001),(.29005,56.9841,1.60261),(.26475,56.91334,1.60444),(.26299,56.93431,1.60356),(.26753,56.93634,1.60115),(.25959,57.10704,1.6055),(.25596,57.1248,1.61032),(.25399,56.99547,1.62304),(.27662,56.98182,1.60966),(.24934,56.97793,1.62471),(.23414,56.935,1.60729),(.2556,56.91071,1.60605),(.24967,56.90818,1.60332),(.21604,56.9839,1.61962),(.2281,56.97253,1.62542),(.22059,56.96786,1.61749),(.22891,56.93136,1.60154),(.24728,56.90605,1.59881),(.21066,57.11707,1.612),(.2036,57.1043,1.61373),(.23058,56.95507,1.57183),(.22799,56.96872,1.561),(.20587,56.97271,1.59593),(.20923,57.08118,1.55246),(.20333,57.09835,1.58207),(.24915,56.93098,1.5784),(.24992,56.90465,1.59216),(.25278,56.90502,1.58854),(.24377,56.96953,1.54253),(.24999,56.95837,1.55546),(.25547,56.93399,1.57796),(.26026,56.90813,1.58953),(.26038,56.93574,1.5828),(.22967,56.99281,1.52664),(.22695,56.9843,1.52056),(.23465,56.98525,1.52321),(.20524,56.99418,1.54206),(.19915,56.98486,1.54802),(.19852,56.98445,1.54089),(.24285,56.96641,1.53711),(.24808,56.95862,1.54154),(.24162,56.95573,1.55246),(.27126,56.8428,1.58192),(.26576,56.85409,1.57815),(.2619,56.85918,1.58768),(.2555,56.86405,1.58843),(.24958,56.87378,1.58134),(.26179,56.82821,1.58104),(.24729,56.83048,1.57844),(.20864,56.85713,1.55625),(.228,56.83962,1.57159),(.26586,56.95589,1.67622),(.26663,56.9546,1.67376),(.25815,56.95662,1.6692),(.23686,56.97523,1.64819),(.22476,56.98266,1.65655),(.23922,56.96771,1.65816),(.25525,56.96546,1.65242),(.2631,56.96449,1.65031),(.25038,56.9729,1.64266),(.29141,56.96507,1.67629),(.28309,56.96462,1.67961),(.28403,56.96668,1.683),(.27797,56.96507,1.664),(.27897,56.96172,1.67442),(.2469,56.96547,1.65456),(.26325,56.95591,1.6667),(.23192,56.97872,1.67018),(.25814,56.95952,1.67403),(.23288,56.97196,1.66293),(.28218,57.00585,1.7099),(.28731,57.01962,1.72433),(.30347,57.0027,1.70526),(.32119,57.01519,1.71335),(.32065,57.00678,1.70293),(.30139,56.98653,1.68978),(.29117,56.98677,1.69006),(.31039,56.99955,1.6953),(.31016,57.02334,1.72018),(.32602,57.05411,1.73907),(.34188,57.03623,1.71622),(.3219,57.10161,1.67974),(.31456,57.13036,1.65598),(.33771,57.10123,1.67076),(.30258,57.0272,1.72568),(.31221,57.05781,1.75309),(.3154,57.06779,1.73351),(.30989,57.08359,1.70794),(.33535,57.08729,1.69975),(.28824,57.05882,1.73054),(.25455,57.13668,1.69468),(.28378,57.13601,1.6833),(.3008,57.10189,1.69046),(.20838,57.17609,1.67416),(.21944,57.18427,1.66351),(.23898,57.18929,1.66427),(.28379,57.01133,1.71889),(.27286,57.03138,1.74509),(.22531,57.04008,1.7193),(.20354,57.0648,1.71445),(.23532,57.07302,1.71387),(.18566,57.16894,1.6694),(.20586,57.17729,1.65867),(.24597,57.00084,1.70602),(.2838,56.99138,1.69748),(.27535,56.9749,1.69097),(.28164,56.97289,1.68923),(.1863,57.14853,1.64817),(.18239,57.09553,1.64861),(.22175,57.07507,1.61701),(.21047,57.16211,1.6425),(.22735,57.15822,1.63533),(.24844,57.1706,1.63623),(.30456,56.98533,1.64141),(.32524,56.99728,1.67688),(.33406,57.00442,1.65409),(.34246,57.00702,1.69204),(.34758,57.0353,1.68039),(.31484,57.11637,1.63106),(.29708,57.16454,1.63506),(.29835,57.09068,1.6071),(.27713,57.17493,1.63727),(.25675,57.17344,1.63662),(.26553,57.16652,1.63301),(.34332,57.06026,1.7034),(.30197,57.17521,1.64406),(.31575,56.87825,1.87795),(.3173,56.87027,1.87541),(.31803,56.8713,1.87572),(.34244,56.91293,1.86711),(.36339,56.89836,1.94162),(.36561,56.92077,1.94042),(.37159,56.94385,1.98895),(.36904,56.93578,2.01737),(.36224,56.95186,2.01221),(.35181,56.95003,2.01785),(.35407,56.93386,2.02591),(.32803,56.94058,2.00145),(.26305,57.00552,1.80492),(.26575,57.00583,1.80395),(.26066,57.01408,1.79519),(.3115,56.94614,1.97418),(.29608,56.91476,1.94583),(.34764,56.96403,1.96809),(.33933,56.96273,1.94888),(.35527,56.9522,1.9412),(.29877,56.95156,1.93657),(.3221,56.96159,1.9545),(.32943,56.96326,1.97462),(.33832,56.95139,1.86881),(.32362,56.96528,1.85384),(.31957,56.95059,1.81524),(.30951,56.97727,1.85958),(.296,56.98323,1.85529),(.32535,56.86085,1.8916),(.32224,56.86867,1.89118),(.3265,56.86125,1.89047),(.3273,56.85086,1.91994),(.31736,56.85828,1.90083),(.32397,56.85909,1.90507),(.32031,56.88352,1.88108),(.31787,56.87844,1.88101),(.31981,56.87743,1.88457),(.31619,56.87867,1.8785),(.31568,56.88522,1.87096),(.31215,56.88676,1.86558),(.32484,56.88215,1.89396),(.32713,56.88207,1.90483),(.32061,56.88384,1.91216),(.30315,56.89457,1.94285),(.33134,56.91738,2.0009),(.29643,56.90636,1.79658),(.28861,56.90384,1.80699),(.28624,57.04204,1.81769),(.31109,57.07198,1.81981),(.29803,57.06458,1.78565),(.28798,57.04661,1.8394),(.27583,57.01868,1.81403),(.33047,57.10249,1.83963),(.30317,57.08646,1.85233),(.28644,57.09765,1.87156),(.24149,57.16114,1.86954),(.18109,57.18294,1.8481),(.22507,57.19108,1.85516),(.20228,57.04572,1.76792),(.21247,57.03272,1.74429),(.19405,57.07052,1.76005),(.23291,57.02687,1.74033),(.2278,57.05121,1.73257),(.20095,57.05179,1.73061),(.22396,57.07538,1.72278),(.29544,57.09006,1.71987),(.28791,57.11807,1.70775),(.21432,57.13915,1.7103),(.26373,57.20096,1.68194),(.20221,57.18078,1.68729),(.27472,57.15216,1.70215),(.26619,57.01407,1.79894),(.27184,57.01577,1.80593),(.26484,57.02158,1.77441),(.33962,57.08608,1.80472),(.32851,57.07183,1.76842),(.32544,56.86297,1.86784),(.31432,56.86243,1.84142),(.33243,56.86367,1.87325),(.34755,56.7973,2.05404),(.33765,56.7775,2.17143),(.34339,56.79607,2.05356),(.34763,56.82346,1.9524),(.34701,56.80133,2.03399),(.33982,56.82319,1.95518),(.34529,56.80057,2.03735),(.34342,56.79937,2.04049),(.34353,56.79906,2.04039),(.34359,56.79763,2.04682),(.34356,56.79802,2.04692),(.34556,56.79786,2.05024),(.3552,56.80079,2.04811),(.35363,56.79976,2.05141),(.35328,56.80009,2.05097),(.42573,56.91903,1.84686),(.427,56.91861,1.84743),(.42583,56.91945,1.84709),(.42472,56.9195,1.84708),(.4249,56.9198,1.8472),(.42386,56.92044,1.84857),(.42733,56.92092,1.85964),(.42835,56.91911,1.85266),(.43012,56.92477,1.86948),(.42621,56.92334,1.85231),(.42718,56.92292,1.85139),(.42769,56.91968,1.85221),(.42405,56.92323,1.85215),(.42513,56.92354,1.85271),(.42625,56.92061,1.85362),(.42625,56.92268,1.84673),(.42502,56.9223,1.84643),(.42526,56.92085,1.84639),(.42642,56.92112,1.84681),(.42271,56.92395,1.85022),(.42293,56.92329,1.8505),(.42237,56.92321,1.84882),(.42419,56.92117,1.84678),(.40783,56.98401,1.82423),(.42597,56.9287,1.84498),(.4079,56.9854,1.82626),(.40757,56.9864,1.82833),(.42589,56.93033,1.84762),(.40681,56.98684,1.8299),(.42149,56.92876,1.84764),(.42107,56.92776,1.84623),(.40399,56.9835,1.82739),(.40538,56.98192,1.8238),(.40447,56.98246,1.8254),(.42146,56.92708,1.8449),(.40048,57.00337,1.81474),(.39251,57.02103,1.80811),(.39905,57.00362,1.81737),(.40586,57.00525,1.8191),(.40634,57.00475,1.8161),(.40265,57.00548,1.82343),(.40453,57.0055,1.82167),(.40577,56.98667,1.83067),(.40476,56.98593,1.83043),(.39926,57.00469,1.82262),(.4041,56.98476,1.82923),(.40243,57.0034,1.81305),(.40644,56.98202,1.82295),(.40733,56.98276,1.82306),(.40575,57.00419,1.81382),(.39169,57.04411,1.81191),(.40133,57.02275,1.80852),(.40083,57.02228,1.81181),(.39917,57.02161,1.8149),(.39696,57.02098,1.81667),(.38966,57.03027,1.8194),(.39301,57.02034,1.81523),(.38821,57.02501,1.81547),(.38883,57.02654,1.81831),(.39448,57.02163,1.80637),(.38857,57.03428,1.804),(.38959,57.03954,1.80339),(.39902,57.02277,1.80446),(.39059,57.0434,1.80483),(.39192,57.0205,1.81174),(.38725,57.02473,1.8153),(.38761,57.03423,1.80359),(.38711,57.0397,1.80281),(.38513,57.03585,1.81828),(.38305,57.0373,1.81943),(.38498,57.04115,1.81563),(.37127,57.03565,1.81658),(.37293,57.03325,1.81999),(.32199,57.15123,1.85895),(.30562,57.14235,1.88073),(.31321,57.12302,1.8744),(.37934,57.12285,1.81904),(.3864,57.11019,1.83546),(.38196,57.13037,1.8512),(.32991,57.0669,1.83555),(.34238,57.05644,1.82603),(.34857,57.0676,1.81631),(.31591,57.17331,1.86501),(.35801,57.07662,1.80937),(.36778,57.08062,1.80744),(.36958,57.10285,1.80777),(.268,57.16738,1.94538),(.26134,57.16872,1.94523),(.26343,57.1645,1.93855),(.25532,57.16659,1.94039),(.25519,57.1671,1.93981),(.26303,57.16494,1.93793),(.26654,57.15816,1.92788),(.26626,57.15719,1.9285),(.2673,57.16074,1.93339),(.26471,57.15616,1.92368),(.26026,57.15489,1.92046),(.26085,57.1529,1.92252),(.26684,57.16174,1.93269),(.26692,57.16288,1.93246),(.27441,57.1823,1.94581),(.26309,57.16589,1.93745),(.23541,57.18432,1.94737),(.25525,57.16805,1.93933),(.24721,57.16739,1.93591),(.22302,57.33842,1.88515),(.23588,57.33913,1.88743),(.21236,57.33056,1.90703),(.19834,57.32977,1.90399),(.20964,57.32847,1.86142),(.19648,57.31384,1.86696),(.17656,57.1986,1.85233),(.2062,57.1739,1.88787),(.22701,57.16739,1.87583),(.22425,57.31325,1.82584),(.21254,57.31994,1.84126),(.20153,57.29264,1.81786),(.23931,57.3102,1.81943),(.2194,57.28444,1.80367),(.28655,57.26544,1.84778),(.27575,57.29465,1.84029),(.26322,57.28278,1.81121),(.23972,57.1585,1.92922),(.24172,57.15771,1.92962),(.24258,57.16129,1.93478),(.26861,57.15636,1.92841),(.26436,57.15482,1.9252),(.26843,57.15995,1.93393),(.336,56.81354,2.04423),(.34801,56.79838,2.05128),(.3438,56.8147,2.032),(.3456,56.81667,2.03293),(.31072,56.88421,2.00531),(.33803,56.81587,2.04552),(.29894,56.88175,2.01446),(.25291,56.96646,1.98431),(.24644,56.96265,1.96991),(.21764,56.99054,1.95374),(.2652,56.95808,1.94172),(.27616,56.95585,1.9353),(.27868,56.96799,1.9032),(.26681,56.93455,1.99092),(.26191,56.96934,1.99935),(.29092,56.94751,1.99649),(.29641,56.97132,2.00133),(.30705,56.96852,1.9944),(.2799,56.9326,1.96151),(.29374,56.95609,1.94357),(.28347,56.94493,1.99942),(.27266,56.93901,1.99699),(.34219,57.15015,1.93464),(.36355,57.12034,1.97496),(.35192,57.14704,1.98219),(.34233,57.15561,2.01898),(.29863,57.1955,2.01394),(.32263,57.18317,1.98737),(.25564,57.21853,2.00847),(.26403,57.21703,2.00458),(.27211,57.21036,2.01399),(.24907,57.21744,2.00624),(.25789,57.2219,1.99279),(.23677,57.15391,1.92363),(.26904,57.14163,1.89919),(.26889,57.15011,1.91878),(.25975,57.19887,1.9644),(.26344,57.21455,1.97281),(.26061,57.21503,1.97375),(.26753,57.19724,1.96362),(.27469,57.19818,1.96558),(.26565,57.215,1.97407),(.28769,57.16992,1.95025),(.30248,57.15361,1.9284),(.32195,57.16255,1.94846),(.27946,57.20164,1.96966),(.26694,57.21612,1.97639),(.30161,57.19387,1.97753),(.27911,57.20742,1.97862),(.2667,57.2177,1.97991),(.32101,56.76231,2.16925),(.31221,56.79359,2.03376),(.31504,57.17052,2.04792),(.27985,57.20875,2.02077),(.26,57.17186,2.11001),(.16725,57.4201,2.1296),(.15556,57.4209,2.15768),(.15066,57.36159,2.14664),(.24349,56.8734,2.43635),(.25414,56.84612,2.45497),(.24207,56.88098,2.45066),(.26124,56.90162,2.51374),(.2651,56.90295,2.51427),(.26232,56.91719,2.52216),(.26294,56.84143,2.45287),(.2796,56.81289,2.40396),(.28235,56.81276,2.40714),(.25795,56.85417,2.46656),(.25488,56.85469,2.46409),(.24835,57.01295,2.55521),(.25274,57.01957,2.55374),(.24401,57.02423,2.55678),(.24011,57.02273,2.55595),(.21448,57.05981,2.55326),(.20599,57.05594,2.54938),(.16689,57.122,2.63258),(.16154,57.11894,2.62731),(.19588,57.06949,2.55889),(.13967,57.29203,2.60224),(.14907,57.29831,2.59633),(.1383,57.35113,2.55854),(.42288,56.80808,1.81583),(.42832,56.82991,1.89405),(.40637,56.80539,1.825),(.27766,56.58013,1.43444),(.2628,56.57136,1.42809),(.26142,56.57005,1.42389),(.31715,56.69564,1.58651),(.32603,56.71788,1.61145),(.31295,56.69516,1.58784),(.32178,56.71761,1.61184),(.15761,56.66923,1.75184),(.15593,56.66265,1.75285),(.1563,56.64374,1.67604),(.34441,57.17016,2.01965),(.29085,57.28798,2.09093),(.24764,57.43554,1.96596),(.24421,57.39574,1.87645),(.23029,57.43185,1.98863),(.35856,57.29305,1.97363),(.35119,57.28931,1.99438),(.39282,57.12035,1.91866),(.36569,57.2968,1.95291),(.39148,57.10433,1.86301),(.36865,57.29962,1.93248),(.33025,57.28979,1.73927),(.34151,57.29942,1.78434),(.38119,57.1724,1.76584),(.32603,57.31249,1.77571),(.12742,56.63857,1.90411),(.12808,56.65289,1.85936),(.13243,56.65195,1.85998),(.14038,56.64446,1.73898),(.13628,56.64442,1.73859),(.13973,56.62662,1.68348),(.12013,56.63329,1.92912),(.12425,56.6315,1.92996),(.11821,56.6219,1.96668),(.27906,56.583,1.4328),(.27986,56.58133,1.43435),(.26005,56.57167,1.42151),(.30016,56.61655,1.47214),(.30005,56.61426,1.47428),(.29609,56.60638,1.46348),(.33854,56.72856,1.62011),(.33053,56.72263,1.60986),(.3952,56.76169,1.70606),(.38889,56.75578,1.69328),(.40197,56.81842,1.68059),(.41519,56.83627,1.9576),(.41941,56.83664,1.93202),(.42437,56.85037,1.9435),(.37247,56.8019,2.21343),(.38274,56.79836,2.17551),(.38434,56.8646,2.21727),(.3321,56.83302,2.35486),(.32849,56.84327,2.38378),(.32474,56.84044,2.38613),(.36092,56.79359,2.20712),(.32519,56.83007,2.35655),(.35063,56.78377,2.17623),(.35106,56.88302,2.3839),(.34034,56.91964,2.38628),(.34185,56.91794,2.4437),(.25818,56.91431,2.51836),(.25826,56.92558,2.52248),(.25141,56.93502,2.50633),(.26509,56.92802,2.52562),(.27981,56.94394,2.52152),(.26014,57.00245,2.54931),(.25242,56.98916,2.54688),(.25064,57.01602,2.49321),(.25542,56.99777,2.55091),(.25136,56.99652,2.54992),(.25328,56.9885,2.54521),(.25893,56.97208,2.53016),(.2587,56.97284,2.53475),(.26071,56.96353,2.53152),(.15509,57.2341,2.64275),(.15756,57.30844,2.58455),(.12725,57.24757,2.5485),(.11468,57.32371,2.49706),(.12602,57.25696,2.50209),(.18501,57.25845,2.58771),(.15589,57.22178,2.64817),(.1536,57.12539,2.63444),(.14299,57.12382,2.54999),(.13578,57.05596,2.51281),(.13463,57.04484,2.50665),(.1336,57.05807,2.49424),(.12102,56.96338,2.47351),(.11708,56.97619,2.4776),(.11805,56.96505,2.47358),(.14087,56.81709,2.41211),(.13599,56.79843,2.3968),(.16743,56.80954,2.40572),(.11434,56.68485,2.27154),(.11411,56.70135,2.28806),(.10749,56.70097,2.27757),(.11149,56.62309,2.03633),(.11059,56.62542,2.06309),(.09984,56.64489,2.04591),(.12435,56.61543,1.99688),(.12727,56.61836,1.96859),(.1501,56.62887,1.97765),(.13469,56.65026,1.76681),(.10846,56.65933,1.74976),(.13797,56.65161,1.86075),(.13989,56.65675,1.83028),(.15472,56.6627,1.84874),(.18033,56.59491,1.60311),(.15523,56.68956,1.63756),(.14191,56.72295,1.66268),(.15706,56.65119,1.67508),(.19367,56.85316,1.78222),(.18816,56.85254,1.78078),(.26147,56.59383,1.46596),(.29147,56.60526,1.46666),(.29377,56.61085,1.47601),(.39324,56.96486,2.09146),(.39852,56.96321,2.09477),(.34967,56.94776,2.26883),(.3433,56.95007,2.26921),(.33257,56.93621,2.36697),(.34155,56.93225,2.37366),(.33625,56.98476,2.4725),(.28436,56.85291,1.8839),(.3124,56.82941,1.93872),(.34936,56.85146,1.82617),(.37553,56.82456,1.82412),(.35921,56.85071,1.83758),(.31403,56.85605,1.79865),(.3294,56.85213,1.78718),(.33415,56.86126,1.81453),(.29768,57.41066,2.34362),(.29931,57.4688,2.33074),(.29402,57.41134,2.3504),(.29728,57.36709,2.37081),(.29964,57.3414,2.37495),(.30053,57.37287,2.35929),(.34185,57.16349,2.47222),(.33703,57.16026,2.48319),(.35795,57.00636,2.44154),(.34356,57.16126,2.39165),(.33695,57.20159,2.44831),(.29278,57.50526,2.33976),(.27382,57.52359,2.3398),(.25601,57.51381,2.36343),(.27365,57.5257,2.33022),(.25043,57.51094,2.2866),(.24001,57.5503,2.33479),(.29722,57.3679,2.36963),(.27428,57.33585,2.39579),(.29839,57.39934,2.25898),(.30348,57.2772,2.33236),(.30672,57.27152,2.16126),(.29827,57.15319,2.49014),(.28333,57.1876,2.47114),(.26786,57.22032,2.44785),(.22778,57.2117,2.29292),(.21055,57.23077,2.29327),(.27336,57.21738,2.4611),(.24903,57.21121,2.47618),(.30311,57.05817,2.51524),(.30303,57.15095,2.49811),(.28889,57.1842,2.48312),(.2565,57.24834,2.4386),(.2506,57.24033,2.46327),(.19227,57.34213,2.38095),(.19905,57.3235,2.38525),(.19971,57.33527,2.37929),(.17933,57.3579,2.49016),(.15881,57.42631,2.43093),(.17641,57.34735,2.51306),(.17669,57.33431,2.52643),(.25686,57.26677,2.46475),(.20178,57.29149,2.41855),(.25316,57.25427,2.47526),(.2559,56.96506,2.52831),(.23428,56.95023,2.48129),(.25181,56.97267,2.53255),(.16731,57.14014,2.64649),(.1694,57.13517,2.644),(.20674,57.18616,2.56878),(.17797,56.62223,1.56688),(.16361,56.63435,1.60318),(.16797,56.70408,1.59993),(.12351,57.5523,2.40787),(.09371,57.56284,2.40122),(.09593,57.53936,2.42288),(.18057,56.67481,2.0528),(.20886,56.69052,2.08311),(.18379,56.66958,2.11076),(.15651,56.66906,1.99924),(.14799,56.67372,1.97241),(.14409,56.71708,1.96776),(.15288,56.69859,2.01629),(.17708,56.68183,2.04815),(.16401,56.67458,2.02323),(.26865,57.33329,2.39653),(.26923,57.33139,2.39542),(.27171,57.33308,2.39398),(.26064,57.27898,2.45366),(.2624,57.2768,2.45318),(.28063,57.31356,2.40394),(.2839,57.31424,2.40539),(.27655,57.33424,2.39634),(.30002,57.05425,2.51403),(.27127,57.33644,2.39571),(.43127,56.99709,1.86792),(.43386,56.9197,1.8479),(.35455,56.86273,1.90835),(.33354,56.86209,1.89427),(.27992,56.83638,1.7093),(.28284,56.86331,1.78827),(.34314,56.86616,1.85657),(.35299,56.86213,1.86821),(.35054,56.85508,1.92107),(.35909,56.8564,1.91051),(.22019,57.13999,2.54125),(.20008,57.20062,2.54437),(.1668,57.29361,2.5649),(.17415,57.29613,2.5708),(.41942,56.87906,2.04943),(.40688,56.82178,2.03389),(.32074,56.69969,1.58364),(.29284,56.7353,1.56497),(.32475,56.88175,1.47157),(.13445,56.63546,1.90566),(.30612,57.0977,2.50752),(.33822,56.97445,2.48609),(.30613,57.10629,2.49791),(.42923,56.90026,1.87918),(.42274,56.92244,1.85784),(.424,56.91803,1.83805),(.42336,56.92027,1.84811),(.43127,56.89396,1.85748),(.13192,57.06597,2.47888),(.14232,57.1194,2.5453),(.16475,56.78497,2.33184),(.15937,56.84362,2.3605),(.15547,56.77797,2.33955),(.25724,56.83941,2.44719),(.26096,56.84985,2.36333),(.11905,56.96901,2.4181),(.17931,57.03503,2.47355),(.14442,56.64651,1.73899),(.1431,56.62513,1.68197),(.14408,56.62237,1.67127),(.13483,56.65845,1.66647),(.1172,56.65518,2.2257),(.10662,56.67359,2.22927),(.10245,56.66305,2.17212),(.13499,56.65611,1.82982),(.13883,56.65017,1.76782),(.22092,56.56766,1.47598),(.22711,56.56946,1.47548),(.20464,56.57341,1.5283),(.13461,57.04453,2.50712),(.13107,57.04295,2.50873),(.11425,56.95486,2.43228),(.12139,56.94507,2.44971),(.14296,56.88088,2.42903),(.17033,56.75745,2.35192),(.18253,56.73459,2.27674),(.18417,56.74375,2.27804),(.19182,56.70606,2.24779),(.16202,56.85587,2.44549),(.17217,56.85698,2.44373),(.13134,56.95032,2.46701),(.21514,56.91781,2.38729),(.20089,56.99062,2.42007),(.1569,56.90146,2.39112),(.20525,56.72011,2.23679),(.17873,56.66712,2.1781),(.15979,56.65742,2.17809),(.15514,56.64549,2.11152),(.18885,56.70008,2.05952),(.19795,56.70889,2.06805),(.24051,56.73587,2.15858),(.22512,56.74223,2.21011),(.22588,56.72052,2.1993),(.16609,56.74025,2.06894),(.17048,56.71322,2.03789),(.16059,56.87741,2.06963),(.16596,56.87759,2.06611),(.19479,56.87438,2.12453),(.11783,56.81937,2.10286),(.19289,56.87302,2.12592),(.25197,56.83069,2.17661),(.24971,56.79164,2.0556),(.1368,57.29166,2.60059),(.36891,56.79663,2.2102),(.33104,56.83075,2.35862),(.42033,56.82862,1.89836),(.41322,56.83373,1.93035),(.40196,56.83292,1.94058),(.34394,56.84197,1.92661),(.30227,56.91005,2.49854),(.30565,56.89971,2.49267),(.32258,56.92555,2.50036),(.32719,56.9278,2.49826),(.24789,56.5665,1.43795),(.2584,56.56911,1.42822),(.25659,56.57206,1.43431),(.29473,56.60581,1.46485),(.38921,56.75672,1.70832),(.39275,56.75827,1.70647),(.4209,56.80346,1.80299),(.18271,56.59812,1.60141),(.32765,57.38244,2.09809),(.31794,57.39666,2.11893),(.3253,57.36111,2.11056),(.34813,57.36214,2.02646),(.34755,57.35913,2.0449),(.3516,57.33874,2.02138),(.22978,57.34264,1.79445),(.24798,57.39643,1.87531),(.27289,57.39198,1.85787),(.3107,57.1917,2.48142),(.31101,57.1551,2.4959),(.3323,57.20211,2.45857),(.28893,57.29162,2.41763),(.28414,57.29272,2.40962),(.29102,57.27069,2.42855),(.29938,57.23421,2.44887),(.30461,57.23246,2.45694),(.29419,57.26754,2.43627),(.26177,57.17158,2.16876),(.24332,57.21157,2.13439),(.26842,57.33115,2.38518),(.21987,57.3293,2.27179),(.22696,57.2499,2.26658),(.27674,57.31263,2.39584),(.27029,57.33026,2.38613),(.24994,57.25678,2.29771),(.27007,57.1933,2.31288),(.30005,57.15202,2.48995),(.30117,57.15442,2.48899),(.26601,57.32862,2.38746),(.21502,57.32402,2.28386),(.23165,57.039,2.45653),(.22399,57.20199,2.46036),(.20861,57.19861,2.46685),(.23378,57.20774,2.46713),(.22889,57.21932,2.47665),(.24435,57.21022,2.47511),(.22476,57.24075,2.15912),(.20958,57.28236,2.18466),(.20669,57.2876,2.18677),(.17853,57.33399,2.18885),(.20258,57.35224,2.25529),(.19485,57.35439,2.25751),(.18792,57.35412,2.26247),(.18313,57.35146,2.26979),(.16167,57.26908,2.18635),(.18175,57.34685,2.27842),(.18409,57.34081,2.28679),(.19583,57.31777,2.18183),(.21718,57.33879,2.26186),(.16065,57.35002,2.19677),(.16231,57.33479,2.19115),(.1968,57.35844,2.26273),(.20392,57.35508,2.25888),(.20905,57.36394,2.25892),(.1682,57.36692,2.10185),(.13072,57.25404,2.10803),(.18408,57.37716,2.0718),(.22692,57.34236,2.27605),(.22829,57.3473,2.29357),(.25255,57.37266,2.27212),(.20478,57.37187,2.26523),(.23146,57.40861,2.23095),(.21679,57.44225,2.28765),(.23432,57.44206,2.30372),(.20983,57.38212,2.30505),(.22159,57.36759,2.31147),(.21579,57.37666,2.31137),(.25295,57.4386,2.31686),(.2529,57.37605,2.29475),(.28065,57.44682,2.1681),(.26486,57.46654,2.19027),(.27675,57.45409,2.20631),(.20912,57.46028,2.19943),(.22626,57.50691,2.26387),(.24175,57.49466,2.24771),(.31508,57.39201,2.11715),(.32472,57.37773,2.09668),(.27621,57.51163,2.3058),(.30229,57.50656,2.32028),(.30147,57.50556,2.31682),(.20853,57.43288,2.27098),(.23693,57.49745,2.2666),(.24331,57.49235,2.24927),(.24562,57.38916,2.23762),(.24721,57.38529,2.24236),(.28617,57.42974,2.21053),(.2838,57.4407,2.20684),(.27819,57.45424,2.21217),(.27326,57.46958,2.22136),(.27122,57.47015,2.21534),(.25643,57.4824,2.23154),(.29952,57.47181,2.31882),(.29833,57.47171,2.31593),(.39237,57.13636,1.97447),(.24635,57.37103,2.16417),(.25724,57.31988,2.13968),(.23378,57.31998,2.16329),(.15502,57.34388,2.18467),(.15634,57.4253,2.17135),(.22162,57.06393,2.55476),(.22906,57.09753,2.50649),(.22434,56.568,1.46315),(.22526,56.58703,1.45348),(.23972,56.5714,1.42972),(.2147,57.39826,2.19159),(.24484,57.42218,2.18854),(.21479,57.32114,2.18617),(.30848,57.05745,1.50331),(.30821,56.9986,1.46301),(.29522,57.32536,1.78053),(.32452,57.40021,1.9445),(.33327,57.39084,1.95823),(.36106,57.33208,1.91132),(.28982,57.42198,2.18826),(.31114,57.36096,2.17573),(.23723,57.4664,2.19635),(.29528,57.49369,2.33463),(.2333,57.40491,2.35955),(.29456,57.46883,2.33579),(.18355,57.36678,2.42537),(.19969,57.51929,2.39051),(.21279,57.18873,2.51111),(.21019,57.20473,2.49896),(.13953,57.13021,2.54781),(.39926,57.02994,2.13937),(.34116,56.98798,2.47297),(.171,56.9765,2.43099),(.21708,56.77165,2.11546),(.21637,56.83394,2.25529),(.22365,56.78324,2.22942),(.15135,56.63332,1.97472),(.227,56.60319,1.45137),(.24137,56.57267,1.42835),(.33658,56.9665,2.49696),(.329,56.93822,2.50381),(.25587,56.88971,2.50099),(.25389,56.86293,2.47279),(.30932,56.85376,2.39498),(.38085,56.75359,1.69892),(.3473,56.78329,1.69912),(.35954,56.73896,1.66504),(.28378,56.85919,1.83475),(.19885,56.82967,1.99836),(.21787,56.84711,1.93005),(.25842,56.80332,1.97065),(.16279,56.89194,1.97833),(.11028,56.84292,1.947),(.32592,57.00387,1.71158),(.28808,57.01806,1.73098),(.29318,56.98717,1.70151),(.34813,56.91927,1.66085),(.35869,56.91749,1.65712),(.34807,56.96218,1.66541),(.35051,56.92832,1.68269),(.34247,56.9269,1.67743),(.33719,56.97334,1.69224),(.36022,56.97111,1.66764),(.35465,56.96402,1.66567),(.36063,56.97018,1.66988),(.33925,56.9682,1.66809),(.3305,56.97655,1.67036),(.33233,56.97783,1.67234),(.35759,56.96994,1.6591),(.35433,56.96242,1.6623),(.35749,56.96781,1.6564),(.3571,56.96363,1.65311),(.36569,56.94299,1.66102),(.35654,56.91973,1.65669),(.30441,56.92977,1.65089),(.33335,56.92566,1.65829),(.33663,56.85038,1.62205),(.30796,56.86397,1.61421),(.31017,56.97465,1.65455),(.30206,56.9627,1.6537),(.29319,56.96449,1.64371),(.31997,56.98145,1.64747),(.3116,56.97739,1.65017),(.29446,56.96571,1.63475),(.3314,56.98068,1.63982),(.30498,56.96077,1.62369),(.34188,56.92674,1.67852),(.33937,56.92406,1.67471),(.34032,56.92571,1.67417),(.39365,56.9225,1.67838),(.39156,56.92763,1.68476),(.38958,56.92985,1.68189),(.34117,56.92734,1.67951),(.33838,56.92296,1.67594),(.3817,56.93014,1.68958),(.36552,56.92983,1.68656),(.3812,56.92946,1.68751),(.37748,56.9985,1.84116),(.40125,56.99962,1.80246),(.39109,56.9808,1.8188),(.33849,57.03778,1.83083),(.34185,57.04249,1.82692),(.35822,57.02007,1.8399),(.34543,57.01503,1.84862),(.35744,56.98762,1.84973),(.32538,57.03455,1.83282),(.33243,57.03487,1.833),(.32333,56.93284,1.6964),(.35237,56.90878,1.68877),(.3429,56.91696,1.68382),(.29668,56.97245,1.78601),(.31017,56.95699,1.74908),(.2838,56.9636,1.72776),(.33887,56.9238,1.68091),(.31638,56.93648,1.68735),(.36585,57.0528,1.7773),(.34448,57.06348,1.76571),(.37865,57.03574,1.75515),(.33751,57.0509,1.81704),(.3379,57.06478,1.79347),(.35182,57.05647,1.79937),(.39811,56.96036,1.72337),(.38458,56.95101,1.70331),(.40036,56.94726,1.7137),(.27733,57.20424,1.95967),(.25181,57.21688,1.96936),(.25224,57.22243,1.9746),(.31439,57.20916,1.9478),(.31271,57.20465,1.94346),(.27869,57.20544,1.9632),(.30581,57.25425,1.88859),(.30317,57.23224,1.86627),(.31277,57.24254,1.89566),(.32104,57.21014,1.91359),(.33504,57.37426,1.97477),(.33032,57.38534,1.9591),(.31057,57.26149,1.89334),(.24387,57.20733,1.96126),(.23314,57.23467,1.96393),(.24635,57.23474,1.98714),(.17011,57.21152,1.87848),(.20698,57.18501,1.90229),(.2894,57.1741,1.93864),(.30866,57.18163,1.94782),(.30941,57.18805,1.92437),(.2938,57.16764,1.92742),(.23505,57.32532,1.90977),(.25442,57.32357,1.90756),(.23451,57.3023,1.92906),(.22452,57.24591,1.96311),(.17182,57.24329,1.95282),(.20863,57.24185,1.96397),(.2202,57.21087,1.96338),(.16842,57.22425,1.90547),(.28228,57.19599,1.86188),(.28312,57.17205,1.8835),(.30174,57.17978,1.90228),(.25479,57.2124,2.01637),(.27753,57.2032,2.02663),(.2561,57.22127,1.99047),(.25548,57.21985,1.98621),(.24558,57.2142,1.99913),(.22808,57.20226,2.00272),(.21281,57.18511,1.99068),(.2248,57.19352,1.98746),(.21475,57.16998,1.95227),(.24792,57.17142,1.94493),(.24241,57.16273,1.93436),(.16176,57.19217,1.9968),(.22961,57.42679,1.98883),(.2096,57.38171,1.9933),(.22203,57.38438,1.9539),(.1933,57.13176,1.94367),(.2296,57.13792,1.90977),(.21985,57.1946,2.01021),(.19009,57.13997,2.02121),(.17751,57.13655,1.98029),(.2894,57.16186,1.91442),(.27079,57.425,1.94388),(.28849,57.31465,1.88581),(.29257,57.41553,1.9353),(.23215,57.30956,1.97055),(.23464,57.28191,1.94137),(.2467,57.43035,1.96646),(.25584,57.32904,1.91143),(.24976,57.42958,1.96314),(.30545,57.28361,1.88669),(.32159,57.39444,1.94569),(.2337,57.23906,1.96815),(.23522,57.28698,1.939),(.23227,57.27948,1.93962),(.22716,57.2502,1.96343),(.39993,56.9891,1.75228),(.38186,56.96793,1.71098),(.39383,56.92728,1.69443),(.31807,57.04959,1.81654),(.31499,57.04557,1.82106),(.30193,57.05331,1.79583),(.32285,56.94241,1.68441),(.27441,56.98573,1.76174),(.27553,56.9695,1.7116),(.31912,57.03672,1.83022),(.32412,57.01243,1.84518),(.36576,56.96642,1.82189),(.40657,56.97428,1.77076),(.40581,56.95222,1.73522),(.3818,56.93029,1.69081),(.34175,56.91499,1.67198),(.34172,56.91851,1.66893),(.39653,56.91848,1.68385),(.39333,56.92677,1.68849),(.34179,56.92286,1.66799),(.30243,56.9229,1.57873),(.28038,56.92117,1.58023),(.28052,56.90207,1.56439),(.26966,56.88739,1.55519),(.28208,56.93366,1.63314),(.35508,56.96042,1.66189),(.35941,56.94863,1.66514),(.32619,56.97087,1.66411),(.31512,56.97163,1.6594),(.3175,56.97574,1.66161),(.35688,56.9791,1.65741),(.32421,56.98447,1.67176),(.32742,56.98597,1.67603),(.33921,56.96949,1.68369),(.34019,56.97668,1.69821),(.3804,56.92986,1.68535),(.34721,56.97774,1.69764),(.35893,56.97942,1.69504),(.38467,56.92379,1.66736),(.39075,56.92778,1.67548),(.36369,56.97714,1.68721),(.37204,56.91917,1.65943),(.13463,56.88503,1.96921),(.29188,56.85734,1.84183),(.3432,56.80048,2.0336),(.36266,56.84853,1.90971),(.24481,56.86683,2.32531),(.27112,56.96508,2.49841),(.27528,56.96072,2.5046),(.40419,56.9449,2.09617),(.3587,56.9352,2.25899),(.26821,56.58785,1.4262),(.09079,56.68919,2.03539),(.08007,56.68308,1.97495),(.23695,57.03491,2.47052),(.21684,57.17889,2.47823),(.30815,57.23237,2.45783),(.34701,56.93535,2.37314),(.40192,56.96825,2.09107),(.36666,57.02223,2.35609),(.34943,57.16108,2.15965),(.31882,57.27617,2.09418),(.10822,57.40104,2.44189),(.13611,57.34839,2.55733),(.18502,57.26455,2.5308),(.19536,57.29226,2.43977),(.18402,57.32765,2.50381),(.20032,57.41635,2.37711),(.29216,57.29239,2.41817),(.30415,57.30827,2.3828),(.10683,57.62331,2.34342),(.21099,57.56385,2.32705),(.06716,57.48771,2.33921),(.33463,57.36131,2.08297),(.34312,57.35726,1.86046),(.2012,57.33144,1.84572),(.21473,57.29719,1.73707),(.33515,57.15147,1.55325),(.36689,56.99661,1.57885),(.38416,57.09849,1.78192),(.24865,57.05112,2.45938),(.26448,57.05255,2.47768),(.17672,56.8123,2.40246),(.30727,57.30762,2.07015),(.15399,57.42207,2.16512),(.27697,57.26857,2.11372),(.27648,57.50988,2.30391),(.25166,57.50844,2.28627),(.2549,57.40883,2.32106),(.25128,57.37649,2.25287),(.28285,57.43803,2.19725),(.21046,57.42856,2.25346),(.25854,57.48049,2.23587),(.29801,57.44147,2.31177),(.26428,57.41212,2.16471),(.2874,57.40206,2.14091),(.29434,57.41725,2.14158),(.18779,57.37431,2.19434),(.29742,57.42259,2.14383),(.22105,57.4175,2.241),(.2391,57.39801,2.23497),(.22136,57.34674,2.26264),(.21414,57.35591,2.25664),(.20987,57.34795,2.25581),(.18125,57.23344,2.17786),(.20607,57.32371,2.29329),(.15416,57.29834,2.18644),(.27259,56.98474,2.4787),(.26337,56.96598,2.47619),(.24277,57.26464,2.42915),(.24526,57.25973,2.42458),(.24043,57.26647,2.41842),(.24447,57.21959,2.48659),(.24812,57.22621,2.49385),(.24258,57.20635,2.50635),(.24021,57.21328,2.48741),(.24399,57.26998,2.43133),(.27981,57.17103,2.32789),(.23689,57.24476,2.45472),(.23764,57.24204,2.45333),(.24046,57.25682,2.44033),(.23343,57.23178,2.46522),(.30941,57.15326,2.49722),(.31045,57.1504,2.49858),(.30256,57.26971,2.43634),(.32521,57.2388,2.42881),(.31206,57.27482,2.39698),(.30707,57.15617,2.49387),(.30688,57.1926,2.4797),(.32769,57.36944,1.8508),(.3356,57.36399,1.85611),(.30109,57.38273,1.85002),(.33796,57.37947,1.97423),(.35499,57.31589,1.99751),(.1531,57.38956,2.09372),(.17003,57.39456,2.05604),(.13143,56.71823,1.65892),(.14944,56.62405,1.67255),(.14615,56.62097,1.67236),(.17079,56.59258,1.60018),(.23081,56.56692,1.46461),(.22671,56.56613,1.46456),(.24207,56.56452,1.43521),(.41992,56.82531,1.88585),(.30144,56.89923,2.49171),(.32244,56.83799,2.38218),(.21313,56.8732,2.1805),(.21099,56.8718,2.18101),(.15198,56.75791,2.07678),(.22616,56.70956,2.17973),(.22252,56.70106,2.15282),(.21994,56.70029,2.10969),(.16394,56.66987,2.24782),(.19423,56.74814,2.26579),(.17958,56.79854,2.30688),(.16865,56.69115,2.28131),(.15611,56.68877,2.28456),(.174,56.83985,2.32529),(.14047,56.80786,2.37863),(.13985,56.88195,2.39227),(.14464,56.89275,2.39853),(.26359,56.58683,1.42529),(.26249,56.6286,1.44927),(.08974,56.73186,2.02437),(.10372,56.98732,2.44479),(.09563,57.00475,2.41738),(.11481,56.92967,2.43168),(.17229,56.76627,2.36109),(.16276,56.76246,2.36616),(.44273,56.86973,1.76932),(.40352,56.84466,1.66811),(.43457,56.89567,1.75244),(.35453,56.95113,2.27289),(.31575,57.10241,2.50251),(.30989,57.10221,2.5013),(.10115,56.65056,2.10806),(.15316,56.63403,2.03588),(.08828,56.71211,1.89949),(.08531,56.69695,1.82507),(.08364,56.69029,1.90155),(.25565,56.56896,1.42096),(.192,57.06982,1.43085),(.37525,56.83235,1.92027),(.3837,56.84139,1.87376),(.40214,56.81704,2.03209),(.25401,57.25779,2.44387),(.25176,57.25284,2.45121),(.25291,57.25374,2.43887),(.19343,57.21513,2.51846),(.24105,57.20711,2.50697),(.20706,57.24598,2.55082),(.20363,57.25536,2.56092),(.20421,57.25452,2.54103),(.20499,57.25678,2.54451),(.32473,56.86024,1.82128),(.36306,56.86153,1.89211),(.32895,56.72574,1.6242),(.35427,56.73606,1.65708),(.25149,57.25706,2.43344),(.10321,56.66685,1.83168),(.0993,56.65257,1.90725),(.10641,56.71457,1.74221),(.16651,56.64658,2.02794),(.15711,57.21405,2.65048),(.2128,57.07649,2.56387),(.19962,57.35199,2.37058),(.2496,57.2293,2.46967),(.19151,57.20895,2.19148),(.14358,57.20488,2.10143),(.29049,57.4164,2.22269),(.20903,57.56391,2.33616),(.23916,57.54964,2.34459),(.30543,57.30904,2.36843),(.29807,57.41759,2.29719),(.30219,57.34201,2.36281),(.32765,57.23931,2.41606),(.31218,57.27594,2.38282),(.30146,57.50363,2.33024),(.3341,56.86111,1.90996),(.34295,56.8574,1.91735),(.37225,56.85195,1.87374),(.36826,56.84926,1.85987),(.34996,56.83591,1.79518),(.35462,56.80302,2.03476),(.39293,56.81357,2.02996),(.33292,56.98487,2.46911),(.3028,57.15091,2.49263),(.30416,57.15251,2.49413),(.23147,56.57268,1.47703),(.23452,56.56951,1.46541),(.25108,56.5877,1.46619),(.18599,56.59335,1.59157),(.23351,56.66749,1.57919),(.1319,56.62771,1.93143),(.15241,56.64172,1.91559),(.11917,56.62003,2.06263),(.12121,56.61743,2.03511),(.11469,56.62455,1.96519),(.11321,56.62147,1.99498),(.09792,56.64317,1.97583),(.12015,56.64177,2.19106),(.11839,56.63651,2.16854),(.11743,56.66608,2.24627),(.14968,56.86541,2.4473),(.15004,56.84616,2.43714),(.13194,57.05445,2.51439),(.12734,57.04412,2.50756),(.12945,57.0556,2.51327),(.12575,56.97022,2.47334),(.15193,57.12996,2.63667),(.15008,57.14159,2.64088),(.13264,57.21351,2.65353),(.13245,57.22442,2.64967),(.13253,57.3064,2.55365),(.27817,56.86202,2.47685),(.27417,56.85139,2.46415),(.27727,56.86613,2.48081),(.40504,56.81729,2.06049),(.39996,56.80209,1.81357),(.40205,56.80682,1.82693),(.42525,56.81025,1.81339),(.42335,56.80599,1.80142),(.37508,56.74451,1.65993),(.36826,56.7409,1.64965),(.3607,56.76362,1.64),(.32031,56.69708,1.58524),(.34229,57.36896,1.99051),(.33658,57.28182,2.03597),(.34379,57.28556,2.01516),(.29441,57.42092,1.9344),(.17704,57.44678,2.2005),(.168,56.65156,2.02633),(.24535,56.56411,1.43562),(.25808,56.56808,1.42377),(.32514,56.93254,2.50391),(.141,57.21571,2.65581),(.14269,57.20846,2.65635),(.15744,57.20668,2.65165),(.14585,57.19834,2.65605),(.16299,57.15102,2.64976),(.26569,56.89498,2.50881),(.26658,56.86797,2.48265),(.2741,56.87246,2.48695),(.27074,56.84761,2.46089),(.28633,56.81525,2.41081),(.19808,57.37881,2.03481),(.42986,56.91634,1.84215),(.42791,56.9169,1.8408),(.44175,56.8938,1.75832),(.35172,56.79852,2.05454),(.30137,57.17813,1.95878),(.31506,57.14696,1.90909),(.22657,57.02944,1.87241),(.24853,57.05306,1.8644),(.23387,57.08886,1.87734),(.23785,57.20981,2.01138),(.30763,57.15397,2.05001),(.26522,57.15001,2.06148),(.18299,57.10005,1.97156),(.19398,57.09899,1.93264),(.35097,57.12142,2.01275),(.27369,56.93089,1.96466),(.30919,56.96237,1.97332),(.30071,56.95942,1.95788),(.29334,56.94014,1.97001),(.24717,57.16532,1.93855),(.24328,57.15544,1.92583),(.26876,57.2562,1.82305),(.23831,57.16205,1.9007),(.25639,57.15874,1.89823),(.17222,57.25581,1.82032),(.2176,57.25101,1.81256),(.16966,57.22781,1.83615),(.22481,57.19677,1.8535),(.22151,57.22329,1.83093),(.16245,57.2417,1.86445),(.16455,57.25524,1.89434),(.17192,57.27442,1.93694),(.24715,57.16645,1.93639),(.37008,57.1263,1.81546),(.3566,57.11801,1.82406),(.35718,57.09676,1.81281),(.31412,57.10229,1.86619),(.33187,57.12303,1.85314),(.3864,57.02643,1.81801),(.40065,57.02292,1.80585),(.39677,57.0223,1.80464),(.39066,57.0354,1.81866),(.39131,57.04492,1.80776),(.40434,57.0037,1.81273),(.39861,57.00411,1.82027),(.40073,57.00519,1.82377),(.42252,56.92687,1.84401),(.42252,56.92974,1.84868),(.42503,56.93064,1.84869),(.42511,56.92782,1.8441),(.42275,56.92263,1.84759),(.42375,56.92227,1.8467),(.42486,56.925,1.85167),(.4271,56.92331,1.84765),(.42724,56.92169,1.84744),(.4286,56.91866,1.85094),(.42581,56.92145,1.85905),(.42828,56.91878,1.85083),(.42795,56.91924,1.85242),(.42808,56.91924,1.85072),(.42396,56.92079,1.85192),(.42417,56.92103,1.85183),(.42534,56.92091,1.8533),(.42357,56.92091,1.85016),(.42357,56.92061,1.85018),(.42381,56.92017,1.84851),(.42778,56.91843,1.84812),(.42756,56.919,1.84836),(.42707,56.91908,1.84779),(.35487,56.8011,2.0481),(.35458,56.80218,2.04174),(.3548,56.80184,2.04159),(.34539,56.79732,2.05048),(.35505,56.80193,2.0415),(.31446,56.86074,1.86652),(.3125,56.8608,1.86047),(.31763,56.86169,1.86376),(.32137,56.86248,1.86498),(.33383,56.86157,1.90247),(.27728,57.03244,1.79415),(.20071,57.19743,1.69099),(.22162,57.23738,1.71571),(.21338,57.23538,1.71438),(.29418,57.06773,1.74087),(.24645,57.0207,1.76437),(.15944,57.16267,1.74029),(.16294,57.13067,1.7545),(.18094,57.11064,1.72614),(.18766,57.07916,1.72676),(.15385,57.16854,1.82499),(.15286,57.15252,1.79246),(.1511,57.18426,1.771),(.26214,57.28482,1.76255),(.20396,57.27341,1.77778),(.21448,57.26038,1.74173),(.33154,57.08053,1.76638),(.27248,57.04375,1.75768),(.3382,56.89354,1.87081),(.32509,56.8832,1.91654),(.3274,56.8825,1.91348),(.37315,56.92505,1.98986),(.32107,56.87766,1.88782),(.32094,56.86138,1.87656),(.27183,56.94803,1.88611),(.26777,56.9808,1.83598),(.34632,56.95488,1.92245),(.28225,56.98288,1.81475),(.27867,56.9817,1.81021),(.29884,56.94707,1.78132),(.2813,56.92969,1.91514),(.27493,56.93949,1.89956),(.34619,56.94272,1.88117),(.36241,56.95054,1.95804),(.32485,56.94147,1.81953),(.30281,56.94013,1.78219),(.30449,56.94842,1.95648),(.27346,56.91582,1.87715),(.2617,56.93413,1.85101),(.33695,56.96221,1.99275),(.35492,56.9642,1.9848),(.29317,56.91781,1.78479),(.31591,56.91651,1.80924),(.30616,56.9325,1.78675),(.25984,56.93617,1.80598),(.2671,56.92081,1.82434),(.27463,56.92157,1.7915),(.2762,57.02193,1.82158),(.27447,57.0116,1.81939),(.27281,57.01201,1.82253),(.28549,56.98514,1.82651),(.28374,56.98557,1.83074),(.32048,56.86855,1.89033),(.31818,56.86874,1.88738),(.3162,56.87706,1.88877),(.32053,56.87612,1.89366),(.32131,56.87627,1.89074),(.32308,56.86823,1.89007),(.32223,56.86971,1.88337),(.30993,57.06335,1.6264),(.33589,57.08789,1.65106),(.35144,57.05781,1.66487),(.2685,57.08071,1.60376),(.27364,57.04669,1.61665),(.32969,57.0278,1.63728),(.28929,57.01459,1.62787),(.2292,57.01264,1.63751),(.18396,57.05437,1.65208),(.17838,57.15934,1.65978),(.17222,57.12429,1.68235),(.2077,57.01672,1.69817),(.2549,57.0151,1.72795),(.2488,57.18498,1.65088),(.19012,57.13703,1.70277),(.21945,57.13397,1.70182),(.19627,57.0909,1.70567),(.23426,57.09335,1.70253),(.25573,57.05584,1.72696),(.25294,57.18741,1.65208),(.24244,57.18159,1.67238),(.27258,57.09784,1.69626),(.27777,57.07901,1.71289),(.29311,57.04955,1.75411),(.2722,57.18411,1.66577),(.27397,57.18993,1.65402),(.25851,57.1914,1.6609),(.25706,57.18772,1.65112),(.33138,57.06703,1.71602),(.30034,56.96958,1.67381),(.27774,56.96805,1.68503),(.26943,56.96524,1.68133),(.25488,56.97664,1.68258),(.19342,57.02441,1.65981),(.21433,56.99478,1.66817),(.28712,56.96943,1.68358),(.26835,56.94187,1.54339),(.26672,56.93754,1.52532),(.27803,56.91046,1.52334),(.22795,56.96491,1.51863),(.23923,56.9656,1.52498),(.21122,56.96506,1.52006),(.21497,56.98377,1.52361),(.2221,56.96614,1.55559),(.20645,56.96645,1.55617),(.20639,56.98504,1.55047),(.26999,56.84811,1.58749),(.27051,56.83279,1.58231),(.21596,56.99402,1.53862),(.23024,56.9857,1.54005),(.21852,56.98529,1.5475),(.20811,56.99254,1.53355),(.20451,56.98395,1.53153),(.21866,56.99188,1.52696),(.26756,56.82889,1.58044),(.29109,56.97648,1.57918),(.26607,56.93711,1.59029),(.2785,56.96791,1.56066),(.26363,56.9618,1.55209),(.23205,57.00986,1.51994),(.21697,57.01448,1.5416),(.1921,57.05022,1.57381),(.21217,57.03499,1.5341),(.1972,57.02713,1.58085),(.202,57.06674,1.60458),(.18588,57.07611,1.58959),(.21556,56.9627,1.60477),(.20987,57.07084,1.61043),(.21804,57.0496,1.6227),(.22608,56.98914,1.6262),(.24456,57.0495,1.6149),(.27223,57.04913,1.60285),(.28064,57.00191,1.61639),(.28643,57.06435,1.57161),(.27964,57.06798,1.58187),(.28813,57.04905,1.59531),(.29571,57.00414,1.61021),(.25982,57.12452,1.59797),(.25876,57.11364,1.58031),(.27148,57.10645,1.58269),(.23752,57.04735,1.51244),(.27348,57.06837,1.54947),(.27333,57.09571,1.57695),(.25855,57.09511,1.60271),(.2652,57.12076,1.60174),(.26549,57.17323,2.29692),(.17433,57.20164,2.13851),(.22681,56.96638,2.27685),(.21651,56.95161,2.23492),(.21067,56.95216,2.23318),(.2457,57.16032,2.24068),(.19942,57.18293,2.153),(.2244,57.17528,2.1258),(.18074,57.17369,2.10685),(.19016,57.17063,2.09718),(.1797,57.1812,2.13472),(.2201,57.17882,2.14185),(.21104,57.1818,2.15183),(.35081,56.9281,1.61896),(.34697,56.90489,1.60155),(.32563,56.91693,1.58653),(.34303,56.82614,1.55222),(.35422,56.82533,1.57817),(.27266,56.8837,1.52191),(.30921,56.94284,1.70277),(.1552,56.81455,1.73375),(.32902,56.80277,1.54336),(.31852,56.8,1.542),(.32922,56.80719,1.53874),(.32238,56.80262,1.53516),(.30361,56.80944,1.53102),(.3063,56.8218,1.53607),(.31194,56.80146,1.54215),(.31817,56.79836,1.54171),(.30122,56.80655,1.53781),(.30517,56.80428,1.53995),(.31588,56.79023,1.55091),(.31564,56.7841,1.5655),(.30244,56.78848,1.54805),(.30777,56.78743,1.56585),(.3131,56.77613,1.57862),(.31488,56.78171,1.56443),(.3186,56.7755,1.58194),(.31977,56.77686,1.58316),(.41264,56.85368,1.60806),(.39587,56.83942,1.66019),(.31287,56.77918,1.58258),(.31571,56.78265,1.58559),(.31173,56.77728,1.58124),(.31237,56.77785,1.58147),(.31204,56.77721,1.58108),(.31288,56.77738,1.5801),(.3237,56.77856,1.58494),(.31836,56.77615,1.58513),(.31203,56.77815,1.5817),(.31506,56.77479,1.58225),(.31498,56.77438,1.5824),(.31693,56.77522,1.58395),(.31321,56.77841,1.58228),(.31293,56.77862,1.5825),(.31209,56.7779,1.58165),(.39889,56.84618,1.6536),(.39931,56.84586,1.65192),(.40085,56.84207,1.65764),(.39555,56.84289,1.65395),(.39609,56.84025,1.65536),(.39522,56.83899,1.65362),(.39859,56.83539,1.66134),(.39954,56.83921,1.65885),(.38404,56.8315,1.64803),(.39243,56.83433,1.65602),(.39762,56.83435,1.66026),(.39757,56.83417,1.66048),(.39396,56.83798,1.65819),(.21414,56.72894,1.55673),(.2735,56.82568,1.5772),(.27305,56.81533,1.56248),(.27188,56.82323,1.57603),(.21927,56.85098,1.53728),(.29378,56.91063,1.64294),(.29147,56.9122,1.65153),(.2683,56.92691,1.638),(.29379,56.90378,1.63382),(.25182,56.91497,1.62053),(.23701,56.8991,1.60919),(.29148,56.89429,1.62793),(.25649,56.86833,1.66714),(.2547,56.89214,1.65883),(.27985,56.96211,1.68444),(.27421,56.96037,1.68219),(.28412,56.95723,1.68329),(.27657,56.94439,1.68092),(.28262,56.95823,1.68491),(.2694,56.94759,1.68164),(.26421,56.93926,1.67845),(.27183,56.94236,1.67209),(.14201,56.92593,1.65823),(.27608,56.82921,1.68774),(.14839,56.81305,1.64147),(.21367,56.82966,1.65432),(.2612,56.93472,1.67596),(.25943,56.93759,1.68355),(.25693,56.94937,1.70306),(.25991,56.94312,1.68211),(.26469,56.94131,1.6612),(.26437,56.93554,1.66249),(.30072,56.81021,1.66213),(.26443,56.86178,1.59227),(.23588,56.8535,1.58629),(.23588,56.85,1.58363),(.23398,56.85429,1.58395),(.28167,56.86408,1.59739),(.26579,56.88436,1.6011),(.27686,56.86743,1.60399),(.27563,56.8555,1.59971),(.26937,56.8609,1.59629),(.27517,56.86257,1.60471),(.26579,56.86286,1.59486),(.26802,56.85616,1.59193),(.28332,56.85507,1.61053),(.2794,56.85337,1.60414),(.26987,56.86388,1.59973),(.2693,56.86378,1.59961),(.27491,56.86262,1.60549),(.2737,56.85476,1.59654),(.27324,56.85354,1.59606),(.26858,56.86079,1.59614),(.26961,56.85768,1.59481),(.15507,57.42746,2.15993),(.02522,57.39305,2.08168),(.10699,57.13316,2.29374),(.09511,57.0826,2.31094),(.10569,57.1543,2.37348),(.10229,57.11041,2.21944),(.11312,57.0959,2.15617),(.09027,57.02055,2.18679),(.1385,56.93318,1.95075),(.12255,56.95733,2.01319),(.14627,57.06919,1.98368),(.09009,56.75431,1.79226),(.09811,56.74814,1.76527),(.05695,57.21581,1.63662),(.12418,57.19827,1.63397),(.05693,57.54219,2.41837),(.07209,57.61761,2.36513),(.14348,57.00794,1.73379),(.1421,57.01172,1.7108),(.12746,57.36666,2.07061),(.11393,57.23756,2.06026),(.0895,56.97684,1.78955),(.09743,56.96145,1.76252),(.11014,56.94137,1.76718),(.10402,57.21925,2.40196),(.10715,57.24002,2.44279),(.09613,57.34628,2.4431),(0,57.50186,2.06363),(0,57.5037,2.06132),(.11544,56.79982,1.70766),(.1194,56.82511,1.68975),(.13894,56.79614,1.64101),(.20643,56.9429,1.58883),(.15139,56.86468,1.70053),(.15995,56.88388,1.70869),(.12778,57.2365,1.80311),(.13053,57.24969,1.86071),(.12041,57.23824,1.8039),(.12724,57.26089,1.99599),(.10082,56.87383,1.97497),(.08369,56.80381,2.00046),(.08023,56.97689,2.30568),(.08639,56.9042,2.33043),(.09413,56.94306,2.35841),(.10306,57.12686,2.43328),(.08846,57.0792,2.39392),(.17819,56.86055,1.69088),(.12054,56.98787,2.07593),(.10155,57.05868,1.9135),(.11178,56.99791,1.8698),(.12884,57.2157,2.06377),(.1249,57.20709,2.04049),(.11927,57.19701,2.01403),(.11316,56.96558,1.78951),(.15779,57.00179,1.67456),(.15796,56.99791,1.66227),(.10601,57.29484,1.72634),(.12873,57.23124,1.66192),(.10414,57.14022,1.75117),(.17996,56.96514,1.60344),(.18299,56.90016,1.62122),(.08966,57.43382,2.37821),(.11028,57.38785,2.12483),(.09551,57.04324,1.77396),(.11359,56.94266,1.68128),(.11054,56.94368,1.69058),(.11905,56.94078,1.66117),(.17283,56.91511,1.61844),(.15452,56.91903,1.63473),(.15865,56.90471,1.63763),(.15743,56.88319,1.7126),(.20473,57.01013,1.558),(.20585,57.0107,1.55927),(.16769,56.98955,1.59153),(.18037,56.90834,1.60838),(.18324,56.88679,1.60822),(.19667,56.96281,1.57286),(.19279,56.96923,1.57406),(.13494,57.252,1.92839),(.15124,57.05165,1.58232),(.15708,56.9984,1.66765),(.12915,57.08171,2.1022),(.10332,57.20197,2.35485),(.11621,57.18372,2.27639),(.10947,56.74169,1.73124),(.0852,57.08418,1.98924),(.04171,57.11411,1.48387),(.15027,56.92634,1.59683),(.14063,56.92741,1.59017),(.11527,57.08257,1.65648),(.15482,56.95006,1.58627),(.16919,56.89735,1.56944),(.11789,56.94642,1.65985),(.11079,57.03589,1.71041),(.10868,57.06747,1.63599),(.21761,56.84235,1.52231),(.24449,56.77708,1.5301),(.24482,56.77848,1.52761),(.28975,56.74744,1.55457),(.02536,56.70184,2.29875),(.02595,56.97495,2.43226),(.02587,56.94582,1.5214),(0,56.66736,2.13084),(.01704,56.68738,2.29147),(0,56.70785,2.39591),(0,56.69236,2.35714),(.01037,56.65013,1.92886),(.02878,57.04249,2.46638),(.02416,56.6929,2.10384),(.05532,57.2048,1.62231),(.03047,56.71412,2.29502),(.03137,56.75181,2.29044),(.03602,57.19686,2.19648),(.07633,57.2998,1.84951),(.03291,57.10956,1.91261),(.02902,57.10318,1.86296),(.0284,57.08876,1.79275),(.03765,57.05517,1.72837),(.05767,57.23924,1.66076),(.02989,57.23525,2.49011),(-0,57.42062,2.56911),(.02344,57.33775,2.54164),(.03718,57.42103,2.51522),(.01246,56.67617,2.25121),(.01073,56.67196,2.23815),(0,56.66967,2.17252),(0,56.65876,2.0164),(-.00025,57.29659,2.56307),(-.00026,57.28433,2.56206),(.02455,57.20434,2.51407),(.02444,57.21639,2.51684),(-.00001,57.40783,2.57173),(.03745,57.04562,1.71439),(.06374,57.40889,2.1958),(0,57.14092,1.46941),(0,57.75634,2.33962),(.01888,57.71954,2.27625),(.05901,57.66414,2.35289),(.03973,57.5934,2.3565),(.05405,57.42175,2.32213),(0,57.49354,2.53174),(.06888,57.299,1.72635),(.06759,57.30529,1.80012),(0,56.65,2.0996),(.02722,56.77561,2.34589),(.01879,56.94858,2.41689),(.0254,56.72895,2.32428),(.31351,56.77193,1.58074),(.31207,56.77325,1.58041),(.20319,56.85831,1.5886),(.2065,56.83328,1.5379),(.17558,56.89744,1.57999),(.11251,56.94847,1.68065),(.10933,56.94949,1.68988),(.1107,57.1086,1.69089),(.25246,56.95745,1.7188),(.13964,56.92365,1.62059),(.15274,56.99378,1.65147),(.21351,56.85027,1.58724),(.13822,57.1449,1.69212),(.08364,57.42257,2.3263),(.17224,56.9088,1.63328),(.22646,56.83316,1.60739),(.09871,57.03173,1.85782),(.10904,56.97231,1.78038),(.14848,56.8642,1.70467),(.10744,56.87665,2.37757),(.07982,57.00939,2.33384),(.09163,56.81144,2.0653),(.12299,57.2498,1.86054),(.23081,56.81325,1.62738),(.19373,56.91833,1.68677),(.2551,56.90584,1.66222),(0,57.60484,2.11457),(.09943,56.94936,1.80032),(.03212,57.51677,2.44956),(.08958,56.73039,1.9698),(.14731,57.04794,1.91885),(.09022,57.04156,2.24099),(.1561,57.43184,2.17442),(.15328,57.42887,2.16772),(.27856,56.86184,1.60971),(.26695,56.88534,1.60384),(.28014,56.86682,1.60321),(.26545,56.83357,1.58792),(.26078,56.83157,1.58749),(.24566,56.79702,1.60415),(.24785,56.95776,1.6689),(.26214,56.95043,1.6733),(.2623,56.92905,1.67126),(.18207,56.85067,1.68337),(.26653,56.95113,1.67473),(.27578,56.94605,1.68296),(.26575,56.95249,1.67729),(.26672,56.9524,1.67901),(.27981,56.95837,1.68509),(.19073,56.93829,1.67731),(.24767,56.96953,1.71305),(.16977,56.77333,1.59512),(.39867,56.83521,1.66168),(.39966,56.83792,1.65786),(.39518,56.84177,1.65237),(.31174,56.77655,1.58071),(.31826,56.77679,1.58536),(.31066,56.77457,1.58009),(.31729,56.78112,1.58612),(.3133,56.77799,1.58059),(.27988,56.6798,1.49335),(.31228,56.79939,1.54309),(.32257,56.80045,1.53941),(.30072,56.94593,1.69173),(.25906,56.87769,1.51193),(.36122,56.91778,1.6375),(.20287,57.16916,2.09389),(.21064,56.96894,2.26886),(.26981,56.85316,1.59179),(.23454,57.05727,1.51929),(.29439,57.04399,1.58172),(.24909,56.93542,1.60929),(.23596,56.98591,1.53071),(.22362,56.99335,1.53232),(.2457,56.88765,1.58158),(.27825,56.9127,1.5443),(.27055,56.95726,1.66743),(.27424,56.95468,1.67202),(.27577,56.95519,1.67301),(.26735,56.95722,1.67809),(.35074,57.07805,1.68708),(.26001,57.18574,1.64814),(.24571,57.181,1.64773),(.22219,57.04137,1.62792),(.32313,56.86933,1.88699),(.31823,56.87655,1.89239),(.31195,56.89969,1.81777),(.27294,57.0246,1.82671),(.27099,56.93455,1.78001),(.28833,56.93242,1.77345),(.35315,56.93254,1.89766),(.27586,56.98395,1.84448),(.31767,56.85899,1.89278),(.3174,56.85899,1.89223),(.32091,56.86042,1.88721),(.32245,56.86168,1.87756),(.22257,57.25912,1.7394),(.1592,57.202,1.79962),(.17389,57.09858,1.75626),(.18161,57.14505,1.71833),(.25943,57.21677,1.68715),(.31137,56.85963,1.87232),(.35587,56.79975,2.05504),(.34327,56.79901,2.04025),(.34798,56.7979,2.05172),(.4251,56.92065,1.85355),(.42324,56.9207,1.85),(.42596,56.91746,1.83944),(.426,56.92505,1.85141),(.42365,56.9246,1.85124),(.42376,56.93041,1.84907),(.42386,56.92715,1.84374),(.39145,57.04055,1.81605),(.39472,57.02052,1.81679),(.38576,57.04557,1.80722),(.38522,57.04479,1.81146),(.38369,57.04724,1.8081),(.3281,57.13726,1.85801),(.19796,57.30328,1.84221),(.26666,57.16005,1.92692),(.17216,57.30448,1.92513),(.20245,57.30397,1.9292),(.25527,57.17234,1.87578),(.2769,57.22566,1.84151),(.25464,57.17007,1.94508),(.30478,56.88056,2.00215),(.34118,56.81253,2.03222),(.30868,56.88253,2.00294),(.24406,57.01164,2.01713),(.26493,56.93158,1.9828),(.29644,56.94397,1.97836),(.28772,57.20404,2.00323),(.33646,57.00529,1.99696),(.25667,57.20225,2.02698),(.30191,56.96822,1.91457),(.23636,56.97849,1.91552),(.25252,56.959,1.94852),(.23589,57.1991,2.02097),(.20589,57.05182,1.9017),(.27412,57.10724,1.88136),(.22776,57.10533,1.89855),(.25641,56.89699,2.50648),(.25971,56.89911,2.51075),(.26183,56.89288,2.5077),(.23854,57.01061,2.55149),(.24421,57.01138,2.55427),(.15601,57.14603,2.64657),(.13805,57.19548,2.65295),(.15465,56.64667,1.91507),(.31088,57.40868,1.9364),(.22646,57.3427,1.79714),(.10917,56.63079,2.10473),(.11272,56.62707,2.10526),(.1101,56.63137,2.12944),(.32951,56.71995,1.61163),(.40934,56.83293,1.95612),(.37024,56.78987,2.16989),(.24695,56.99357,2.54645),(.25674,56.9635,2.53012),(.13409,57.20707,2.6541),(.17194,57.12528,2.63484),(.11562,57.08872,2.47227),(.10877,56.75681,2.35011),(.11063,56.77284,2.3654),(.09614,56.77031,2.34472),(.1273,56.76854,2.37265),(.12551,56.75255,2.3573),(.11638,56.86422,2.41194),(.13385,56.85056,2.42945),(.13392,56.86944,2.438),(.13121,56.69553,2.29352),(.12951,56.67945,2.27656),(.13067,56.65679,1.82907),(.14305,56.65175,1.76805),(.1814,56.58999,1.59105),(.30433,56.63762,1.5147),(.30577,56.64566,1.52661),(.25675,56.61928,1.51098),(.42427,56.92195,1.85845),(.2505,57.25143,2.42536),(.21035,57.33408,2.3805),(.15848,57.35339,2.52797),(.10792,57.33476,2.46984),(.25062,57.26223,2.43905),(.20636,57.25135,2.55069),(.4174,56.99184,1.78467),(.10042,56.70063,2.09633),(.14863,56.76848,2.34146),(.20366,56.60408,1.49655),(.2079,56.62614,1.4949),(.21967,56.59416,1.46423),(.10976,56.64214,1.91079),(.10258,56.76206,2.26974),(.10538,56.72077,2.27079),(.0959,56.78728,2.3236),(.27673,56.62389,1.45063),(.13891,56.85307,2.40907),(.1993,56.68095,2.16471),(.20019,56.73038,2.08138),(.35082,56.80217,2.03437),(.29179,56.83098,2.32842),(.26418,56.57562,1.43413),(.27521,56.58032,1.43683),(.38021,56.83219,1.84829),(.34518,57.36493,2.00837),(.30153,57.19461,2.47178),(.24853,57.2336,2.47874),(.24055,57.25751,2.44336),(.25987,57.2726,2.44764),(.2081,57.23396,2.29015),(.18921,57.33407,2.29342),(.19742,57.32823,2.29519),(.17875,57.23531,2.17961),(.21082,57.35001,2.25833),(.28835,57.42205,2.22523),(.20225,57.37856,2.27448),(.24974,57.27244,2.13809),(.29194,57.44605,2.3027),(.3344,57.3646,2.07201),(.29361,57.415,2.25953),(.20497,57.24967,2.46127),(.15492,56.76462,2.35033),(.31009,56.85849,1.88388),(.30854,56.85753,1.8947),(.14696,56.78189,1.85266),(.36096,56.96861,1.6712),(.36438,56.97297,1.67802),(.33825,56.97571,1.69683),(.34103,56.96705,1.67147),(.34264,56.96496,1.6733),(.33736,56.9653,1.66606),(.35464,56.97546,1.65083),(.32506,56.96867,1.66358),(.36435,56.9434,1.65211),(.3191,56.95822,1.66261),(.28921,56.94142,1.59718),(.34392,56.97799,1.64129),(.32148,56.9633,1.62179),(.33898,56.95982,1.62735),(.3229,56.98282,1.83892),(.30474,57.01677,1.83367),(.27127,56.99986,1.74175),(.34128,56.92754,1.68066),(.29176,57.03953,1.80495),(.31834,57.035,1.73107),(.38016,57.00393,1.73005),(.23577,57.28678,1.93486),(.27943,57.30454,1.86394),(.29239,57.27649,1.87518),(.30852,57.40311,1.93745),(.22576,57.16747,1.90932),(.27192,57.31399,1.88543),(.27519,57.15873,1.90317),(.23143,57.18419,1.96114),(.20347,57.19071,1.91865),(.2052,57.2052,1.94477),(.20493,57.27359,1.94237),(.3108,57.2007,1.88513),(.25534,57.32157,1.90213),(.33108,57.05264,1.81414),(.35169,57.04188,1.73915),(.32394,57.05215,1.81398),(.32016,57.06313,1.79161),(.3383,56.92643,1.71003),(.36347,57.03062,1.8264),(.38444,57.01454,1.82054),(.41133,56.82873,1.89512),(.34334,56.79754,2.04691),(.3545,56.78504,1.62715),(.2728,57.29151,1.73807),(.3446,57.06965,1.58831),(.23983,56.56694,1.43297),(.17622,57.44036,2.19706),(.28759,57.42249,2.25723),(.21126,57.42192,2.02406),(.20491,57.38437,2.29601),(.22814,57.2771,2.1618),(.26154,57.33425,1.78772),(.33745,57.36936,2.07305),(.16725,57.42653,2.13142),(.40487,56.80134,1.81391),(.16495,56.87101,2.35976),(.13183,56.8853,2.41122),(.20033,56.57258,1.5271),(.11407,56.64425,2.1892),(.16837,56.59474,1.59925),(.14701,56.62808,1.68233),(.14111,56.82886,2.36372),(.29888,56.85843,1.81704),(.27393,57.33174,2.39459),(.30302,57.14846,2.49315),(.30261,57.15217,2.4965),(.14584,56.70417,1.88815),(.14679,56.7164,1.85161),(.24964,57.24156,2.48498),(.24617,57.22869,2.4938),(.35993,57.01035,2.42861),(.24551,56.61114,1.51083),(.20445,56.57963,1.54316),(.20853,56.5763,1.5295),(.12322,56.64008,1.90395),(.11603,56.62861,2.12544),(.11617,56.62556,2.10589),(.12666,56.66186,2.24995),(.12417,56.65173,2.22875),(.11265,56.63866,2.16687),(.1198,56.80268,2.38923),(.1249,56.8214,2.40443),(.10659,56.81727,2.37845),(.11295,56.96406,2.47026),(.11296,56.97623,2.47525),(.35546,56.80084,2.04825),(.39179,56.8087,2.05577),(.41174,56.82574,1.88273),(.38487,56.75755,1.70884),(.31064,56.68589,1.57731),(.29567,56.60851,1.46189),(.22373,57.38909,1.91324),(.20517,57.07273,2.56224),(.25997,56.84806,2.46058),(.35019,57.12068,1.92998),(.31755,57.11274,1.89259),(.35265,57.10367,1.91134),(.26875,57.15324,1.9236),(.1986,57.07512,1.92409),(.36591,57.09609,1.96943),(.28343,56.972,2.00752),(.28871,56.93664,1.96397),(.29536,56.9474,1.99016),(.33343,56.9866,1.95799),(.28889,57.01754,2.03297),(.30152,56.88379,2.01696),(.24357,57.28022,1.80435),(.24988,57.19619,1.85314),(.21423,57.33475,1.87623),(.2531,57.18644,1.9494),(.30477,57.16519,1.88773),(.34303,57.083,1.82466),(.37233,57.14275,1.83481),(.42623,56.9296,1.84623),(.42683,56.92032,1.85347),(.35281,56.80195,2.03787),(.35262,56.80225,2.03822),(.34527,56.80028,2.03713),(.21976,57.10551,1.71787),(.19759,57.15156,1.85778),(.3099,56.88751,1.86709),(.31522,56.88476,1.90092),(.31983,56.86101,1.87776),(.31638,56.86999,1.87673),(.25974,56.96481,1.80583),(.2563,56.94954,1.80006),(.26688,56.94823,1.77842),(.28514,56.98487,1.85076),(.26953,57.01147,1.82348),(.26666,57.02588,1.82824),(.25514,57.01549,1.79623),(.25983,57.17751,1.63976),(.2762,57.1499,1.62881),(.24551,57.17271,1.6393),(.21013,57.14016,1.637),(.20257,57.16934,1.65101),(.3074,57.13595,1.67214),(.26012,56.90291,1.51259),(.24145,56.90238,1.57849),(.23687,56.9665,1.54888),(.26757,56.91051,1.56627),(.25586,56.90619,1.58768),(.23717,56.92851,1.58713),(.23927,56.93506,1.61062),(.23179,57.12735,1.61102),(.23657,57.08865,1.54541),(.345,57.35729,2.02609),(.3443,57.35432,2.04424),(.26881,56.89449,1.58557),(.32265,56.81267,1.53507),(.29948,56.81182,1.53839),(.32127,56.79618,1.53886),(.32006,56.79549,1.53423),(.31955,56.79317,1.53539),(.30588,56.79792,1.54332),(.38863,56.82717,1.64643),(.20476,56.63483,1.5054),(.31858,56.6912,1.57342),(.31268,56.77484,1.58101),(.25495,56.82077,1.57098),(.22085,56.9437,1.6518),(.2293,56.9253,1.70607),(.28165,56.89083,1.64918),(.25024,56.91692,1.68001),(.2826,56.96213,1.68459),(.28348,56.95587,1.68104),(.27754,56.94322,1.67817),(.27317,56.94529,1.67295),(.27189,56.94631,1.67195),(.26423,56.94965,1.67649),(.26703,56.94531,1.67064),(.27509,56.94162,1.6799),(.26383,56.93717,1.66482),(.26356,56.93245,1.666),(.26086,56.93325,1.67734),(.26341,56.94578,1.66718),(.2539,56.94338,1.65205),(.23403,56.87189,1.58497),(.26934,56.88244,1.59611),(.27706,56.85493,1.60199),(0,57.30939,1.93922),(.19268,56.89764,1.61777),(.09223,57.06508,1.99908),(.08387,56.79657,1.94033),(.13565,57.14374,1.69037),(.1256,56.89106,1.82333),(.10765,56.9633,1.88202),(.0994,57.05013,2.00326),(.09453,57.40867,2.19428),(.14587,56.91156,1.66179),(.13688,57.00787,1.62883),(.121,57.01833,1.66288),(.02973,57.10414,2.47134),(0,56.72064,2.42226),(.00003,57.16073,2.54898),(.02715,57.09725,2.48898),(-.00013,57.35539,2.5678),(0,57.66686,2.10881),(0,56.67726,2.28278),(.01919,57.71466,2.25078),(.0278,57.00584,2.26884),(.03177,56.98331,2.21426),(.02837,56.93986,2.03353),(.02562,56.91932,1.97524),(.03519,57.11595,1.98653),(0,57.50433,2.52583),(-.00006,57.17936,2.55295),(0,56.68522,2.34126),(.03331,57.07002,2.32834),(.03826,57.15956,2.08789),(.08834,57.31438,1.97135),(.09068,57.34882,2.01825),(.03802,57.136,2.03612),(.03302,56.74434,2.23186),(.02965,56.95762,2.10051),(.02892,56.9703,2.15703),(.03424,56.73702,2.17315),(.02995,56.70754,2.23764),(.02827,56.70095,2.18035),(0,56.90367,2.49596),(.03101,57.03284,2.30265),(.01767,56.70405,1.98859),(.09043,57.10063,1.90871),(.10949,56.98034,1.68262),(.12401,56.94587,1.63741),(.10219,56.95333,1.73679),(.09652,56.96671,1.76021),(.12153,57.07762,1.75692),(.11119,57.12729,1.83283),(.10471,57.11991,2.25666),(.09499,57.05946,2.2753),(.22297,56.96686,1.71159),(.20933,56.95735,1.68709),(.23139,56.97032,1.70085),(.20931,56.95857,1.70296),(.11933,57.29262,1.94163),(.1198,57.31433,1.97167),(.11397,56.93305,1.74624),(.11855,57.17444,1.953),(.11454,57.15243,1.88726),(.12543,57.2533,1.93028),(.07675,56.94396,2.27319),(.08732,56.84085,2.24408),(.0814,56.86516,2.29893),(.10102,56.7424,2.08582),(.08667,56.82982,2.1908),(.09096,57.00585,1.93411),(.09638,56.97861,1.87977),(.08469,57.00308,1.87593),(.12606,57.34884,2.01957),(.08032,57.29204,1.93896),(.14185,57.02876,1.86156),(.13665,56.91367,1.89365),(.11224,57.18037,2.23782),(.27563,56.85439,1.59975),(.27679,56.85952,1.60526),(.26416,56.91036,1.59349),(.20554,56.87781,1.57242),(.22081,56.89745,1.58075),(.22637,56.88439,1.58441),(.20158,56.89167,1.56961),(.26226,56.93161,1.67148),(.17911,56.79243,1.59848),(.19473,56.7588,1.57259),(.20084,56.91192,1.62196),(.33878,56.8742,1.64625),(.30813,56.88777,1.64325),(.339,56.87421,1.64808),(.30777,56.88748,1.64049),(.31252,56.89622,1.64653),(.34156,56.87995,1.6481),(.34175,56.87989,1.64989),(.31221,56.89605,1.6438),(.29802,56.89851,1.63771),(.29802,56.90153,1.64164),(.31111,56.89427,1.64092),(.29374,56.88889,1.63699),(.29273,56.8897,1.64066),(.29701,56.90226,1.6454),(.31194,56.89476,1.64808),(.29537,56.90045,1.64751),(.27431,56.94791,1.68374),(.27008,56.9541,1.67204),(.28346,56.9598,1.68081),(.28409,56.96118,1.6831),(.22162,56.9372,1.71513),(.21916,56.95156,1.72),(.2328,56.94838,1.72179),(.21528,56.94742,1.71778),(.21058,56.94465,1.71477),(.20807,56.92966,1.70633),(.20687,56.9443,1.71213),(.19751,56.92881,1.69901),(.29538,56.89066,1.63488),(.29701,56.89435,1.63514),(.19387,56.93505,1.69561),(.19709,56.94561,1.69642),(.22853,56.93151,1.636),(.24003,56.96722,1.68592),(.26873,56.82302,1.5767),(.39354,56.83367,1.65654),(.39336,56.83326,1.6566),(.39275,56.83453,1.65605),(.38581,56.85237,1.64968),(.33914,56.8753,1.6451),(.38524,56.85063,1.64983),(.33995,56.87712,1.64511),(.39395,56.83812,1.65821),(.39548,56.8335,1.6582),(.39565,56.83597,1.65307),(.39726,56.83592,1.65429),(.39957,56.84214,1.65786),(.39665,56.84198,1.64959),(.39858,56.83877,1.65307),(.39793,56.84326,1.64944),(.39676,56.83807,1.65221),(.39656,56.84435,1.65484),(.38431,56.85087,1.65406),(.38466,56.85265,1.65491),(.38616,56.85416,1.65053),(.38616,56.8553,1.65206),(.39545,56.83308,1.65838),(.386,56.82914,1.64923),(.31447,56.77922,1.5837),(.31475,56.77882,1.58341),(.31595,56.77486,1.58122),(.31794,56.77543,1.58271),(.31264,56.77662,1.5797),(.31564,56.77889,1.5824),(.31677,56.77879,1.58471),(.31766,56.77886,1.5837),(.30065,56.79066,1.53575),(.29911,56.79168,1.53716),(.31492,56.78847,1.55005),(.30502,56.78992,1.53415),(.3143,56.79725,1.53056),(.30638,56.80086,1.52954),(.3134,56.79068,1.53347),(.30848,56.80844,1.53034),(.30211,56.8033,1.53048),(.19663,56.91686,1.56335),(.21369,56.92237,1.57321),(.28454,56.8718,1.59929),(.30979,56.8288,1.57836),(.33459,56.81878,1.58211),(.30815,56.81325,1.5574),(.28912,56.83252,1.56547),(.27376,56.85914,1.54975),(.29853,56.81637,1.5518),(.1449,56.73178,1.73626),(.31122,56.95598,1.68728),(.17984,57.17958,2.13508),(.17721,57.17615,2.12118),(.1811,57.17239,2.10743),(.19044,57.16944,2.09777),(.17551,57.13623,2.10542),(.19693,57.12973,2.08424),(.26487,57.1539,2.22003),(.22211,56.94643,2.21142),(.22101,56.95023,2.23093),(.22306,56.94839,2.22224),(.21846,56.9448,2.20156),(.213,56.9441,2.19535),(.20708,56.94451,2.1943),(.20497,56.95159,2.22652),(.20239,56.94591,2.19846),(.20116,56.94997,2.21684),(.20022,56.9479,2.20665),(.29859,57.08694,2.23076),(.27401,57.03598,2.31938),(.28686,57.09699,2.30139),(.28581,57.02898,2.25485),(.23904,56.96236,2.2657),(.23588,56.99869,2.30246),(.25212,56.99298,2.28746),(.25699,57.13092,2.29206),(.28105,57.12321,2.26841),(.26026,57.10573,2.32646),(.21833,57.05059,2.31681),(.22189,57.11039,2.30154),(.25098,57.04417,2.34117),(.19031,57.00212,2.25485),(.2139,57.00292,2.28841),(.19395,56.96814,2.24705),(.22184,57.1334,2.27343),(.18739,57.12864,2.23006),(.1818,57.04903,2.26435),(.15388,57.09646,2.19364),(.18177,57.10586,2.24833),(.15554,57.04018,2.20947),(.1672,56.98816,2.17997),(.18225,56.9637,2.21969),(.1787,56.95798,2.19211),(.17329,56.99588,2.21624),(.16744,57.1443,2.13511),(.16238,57.12045,2.18305),(.15332,57.11082,2.14205),(.17471,57.15208,2.16782),(.14624,57.02987,2.16194),(.1549,57.07452,2.10635),(.14376,57.08563,2.14733),(.15676,57.01923,2.12166),(.18435,56.95238,2.16967),(.19364,56.97499,2.13277),(.17455,56.9806,2.15022),(.19824,56.94826,2.1572),(.16324,57.10091,2.10558),(.18954,57.09294,2.07958),(.18443,57.01063,2.09509),(.22422,57.06143,2.06937),(.18438,57.06558,2.07719),(.22179,57.00683,2.09143),(.21936,56.97294,2.1333),(.23283,56.94869,2.1751),(.24352,56.97536,2.15483),(.21636,56.94683,2.15855),(.25247,57.128,2.09001),(.22509,57.08918,2.07208),(.26027,57.09125,2.09045),(.22555,57.12658,2.07742),(.26366,57.06396,2.0918),(.28256,57.01962,2.1754),(.29172,57.07358,2.14812),(.25871,57.00981,2.1178),(.24506,56.95806,2.23788),(.25801,56.98176,2.19528),(.24303,56.95334,2.20379),(.26038,56.98773,2.24634),(.29031,57.11231,2.2075),(.26962,57.13429,2.12469),(.28385,57.09954,2.1381),(.27341,57.14405,2.17472),(.23628,57.09766,1.61373),(.23539,57.11416,1.61786),(.22053,57.0747,1.53542),(.22106,57.09131,1.55639),(.22717,57.08512,1.54397),(.24994,57.12803,1.60491),(.20777,57.04465,1.61576),(.22194,57.05709,1.52367),(.24388,57.03118,1.50807),(.24903,57.01064,1.51412),(.2279,57.03044,1.51354),(.25971,56.97243,1.53738),(.27796,56.97912,1.54767),(.29361,56.98955,1.57092),(.2662,57.09242,1.55953),(.21326,56.94688,1.52245),(.19945,56.9659,1.52921),(.20043,56.94347,1.5315),(.21046,56.94636,1.56248),(.22647,56.95044,1.56013),(.25774,56.93858,1.55993),(.23352,56.92904,1.57009),(.19662,56.96691,1.55092),(.19402,56.96673,1.54097),(.21818,56.92421,1.5159),(.19952,56.91797,1.52935),(.23163,56.95226,1.52142),(.24879,56.93242,1.51514),(.24362,56.95637,1.52835),(.3397,56.87531,1.64988),(.3406,56.87704,1.65098),(.28068,56.95786,1.67729),(.28182,56.9681,1.68524),(.29407,57.02583,1.72688),(.17738,57.07701,1.6864),(.24401,57.14002,1.62953),(.26102,57.18201,1.64397),(.28115,57.18441,1.64546),(.31478,56.87811,1.88163),(.31615,56.86953,1.88012),(.31494,56.8782,1.87899),(.31672,56.8691,1.88389),(.31508,56.87757,1.88503),(.28002,56.98531,1.83222),(.2753,56.9845,1.83015),(.27212,56.98091,1.8091),(.26973,56.9814,1.81319),(.27678,56.99353,1.83004),(.2808,56.99405,1.82881),(.26858,57.00687,1.80584),(.27949,56.99026,1.81305),(.27172,57.00854,1.80985),(.27567,56.98853,1.80809),(.2688,56.98719,1.80686),(.27218,56.98747,1.80572),(.2741,57.01031,1.81475),(.25913,57.02537,1.82542),(.26219,57.00844,1.81801),(.25264,57.02327,1.81861),(.2656,57.01014,1.82188),(.25633,56.94352,1.80101),(.26837,56.94122,1.77756),(.32998,56.93227,1.82959),(.26195,56.97508,1.8247),(.25612,56.94988,1.83637),(.27534,56.98101,1.80805),(.28279,56.99354,1.82486),(.27105,56.98336,1.82505),(.26575,56.98876,1.81711),(.26765,56.99034,1.82324),(.26909,56.98227,1.81892),(.31934,56.86065,1.88084),(.31427,56.85912,1.8846),(.31313,56.85976,1.87476),(.31976,56.86044,1.8844),(.32402,56.86179,1.87991),(.32175,56.86245,1.86627),(.32603,56.86269,1.87259),(.32672,56.86148,1.88785),(.33265,56.86157,1.90115),(.33306,56.86206,1.89373),(.32042,56.86973,1.87885),(.30951,56.88721,1.8752),(.17131,57.18886,1.69571),(.17343,57.20458,1.69845),(.15644,57.25598,1.75873),(.17426,57.26386,1.78673),(.15113,57.25052,1.76921),(.17585,57.26816,1.77331),(.29287,57.27408,1.75389),(.2899,57.25794,1.72289),(.30056,57.25279,1.726),(.28339,57.27537,1.74479),(.34526,57.1006,1.80438),(.31002,57.22455,1.78547),(.31892,57.20382,1.75318),(.27921,57.23321,1.80948),(.26739,57.28363,1.7755),(.25599,57.1268,1.87553),(.30169,57.13061,1.87124),(.26147,57.09086,1.87297),(.21863,57.2211,1.8244),(.20634,57.26992,1.79182),(.22978,57.08684,1.86468),(.21803,57.1195,1.86312),(.24365,57.05611,1.84869),(.22616,57.04852,1.83028),(.16797,57.13605,1.8323),(.24984,57.02062,1.81003),(.21926,57.04004,1.80629),(.16348,57.11948,1.79955),(.22281,57.03172,1.78252),(.25108,57.01789,1.80181),(.23149,57.02445,1.76697),(.15016,57.2085,1.71663),(.33731,57.11357,1.74634),(.3273,57.14513,1.73163),(.29077,57.22611,1.69898),(.30742,57.17719,1.72163),(.35112,56.79883,2.05207),(.35094,56.79923,2.05158),(.4261,56.92034,1.8541),(.42691,56.92471,1.85044),(.42733,56.92406,1.84902),(.37152,57.03928,1.81259),(.37361,57.04318,1.80903),(.37726,57.05153,1.81744),(.37573,57.05397,1.81408),(.37183,57.04096,1.82763),(.37604,57.03272,1.82191),(.36809,57.03946,1.82777),(.37979,57.03422,1.82174),(.36356,57.04602,1.81846),(.36564,57.04991,1.81493),(.34003,57.15994,1.84426),(.35774,57.1555,1.83687),(.35331,57.16594,1.83804),(.345,57.14928,1.84411),(.33161,57.10465,1.92626),(.35947,57.07175,1.9156),(.33798,57.06307,1.91902),(.3496,57.11193,1.92322),(.37215,57.14743,1.86038),(.36675,57.15453,1.84225),(.37534,57.07864,1.81167),(.38344,57.0893,1.8252),(.37786,57.10005,1.81133),(.37999,57.07167,1.82144),(.33003,57.19929,1.89524),(.34055,57.19808,1.87234),(.34345,57.19695,1.88513),(.32943,57.19982,1.8909),(.38238,57.10986,1.87458),(.38514,57.09051,1.85868),(.34086,57.19327,1.90107),(.32912,57.19803,1.90079),(.37405,57.0881,1.89866),(.37623,57.07019,1.88125),(.33444,57.18846,1.91621),(.32703,57.1964,1.90608),(.3633,57.05517,1.8973),(.32433,57.19482,1.90968),(.32742,57.18425,1.92684),(.34307,57.04703,1.89932),(.3216,57.19367,1.91058),(.31893,57.18065,1.92924),(.32625,57.04986,1.88873),(.32015,57.06613,1.90867),(.31949,57.19321,1.90852),(.31147,57.17877,1.92286),(.31733,57.06285,1.86992),(.31124,57.08076,1.88869),(.31861,57.1936,1.90407),(.3084,57.17974,1.9099),(.32022,57.08208,1.85032),(.31069,57.18334,1.8939),(.31932,57.1948,1.89847),(.31768,57.18852,1.87905),(.32147,57.19649,1.89323),(.33885,57.10114,1.83864),(.3494,57.13927,1.84044),(.32594,57.19331,1.86891),(.32446,57.1982,1.88973),(.3434,57.18665,1.84631),(.33007,57.18105,1.84994),(.35326,57.18879,1.85546),(.36259,57.16866,1.84506),(.24356,57.1579,1.92228),(.24214,57.16014,1.92607),(.26483,57.15805,1.92273),(.24267,57.16302,1.93133),(.24225,57.16203,1.92511),(.24278,57.16491,1.93037),(.25406,57.15672,1.91793),(.26038,57.15678,1.9195),(.25394,57.15483,1.91889),(.26446,57.32545,1.85727),(.2598,57.33172,1.87156),(.24932,57.33668,1.88246),(.16498,57.28572,1.8824),(.16337,57.27097,1.85048),(.24367,57.15979,1.92132),(.24782,57.15788,1.91853),(.24471,57.25312,1.81392),(.24672,57.2235,1.83002),(.25371,57.31143,1.82323),(.2628,57.31792,1.83935),(.24285,57.33384,1.84663),(.2459,57.33526,1.85013),(.2545,57.15181,1.92096),(.24808,57.15321,1.9228),(.24751,57.15264,1.92202),(.25475,57.15242,1.92179),(.35036,56.8019,2.037),(.34141,56.81883,2.04571),(.34415,56.82064,2.04451),(.30962,56.88754,2.01661),(.30631,56.88641,2.01796),(.33912,56.81129,2.03339),(.30202,56.87977,2.00358),(.26802,56.93005,1.97095),(.29812,56.88032,2.01115),(.2995,56.87945,2.00626),(.30381,57.00956,1.86546),(.29786,56.99917,1.87065),(.3103,57.00725,1.87084),(.2957,57.00913,1.86147),(.28817,57.00622,1.85991),(.23174,57.09449,2.04074),(.27705,57.1005,2.05429),(.22337,57.14488,2.05091),(.31984,57.11039,2.04432),(.35909,57.06876,2.0004),(.33085,57.04248,2.02527),(.19175,57.04782,1.95376),(.19718,57.09443,2.01132),(.20837,57.02651,1.98769),(.29195,56.98775,1.87637),(.28542,56.99087,1.87076),(.30004,56.98781,1.88044),(.30753,56.99136,1.8818),(.35931,57.04424,1.92469),(.36272,57.04047,1.97819),(.36826,57.07223,1.95227),(.35481,57.01859,1.94488),(.31244,56.997,1.88021),(.32332,56.98298,1.9167),(.33735,57.00306,1.91053),(.25049,56.9975,1.86956),(.22209,57.00562,1.88999),(.25981,56.98056,1.88612),(.25339,57.01296,1.85818),(.26764,57.02656,1.85428),(.28935,57.03621,1.85845),(.31264,57.03897,1.86907),(.34563,57.06484,1.90125),(.31724,57.07397,1.88187),(.33127,57.03305,1.88339),(.3403,57.01999,1.89844),(.26845,56.85572,2.47012),(.36347,56.73729,1.66303),(.38487,56.75229,1.698),(.30858,56.639,1.51318),(.3103,56.64716,1.52512),(.20074,56.57655,1.54196),(.1568,56.66788,1.8486),(.42211,56.86447,1.99422),(.25059,57.43465,1.9626),(.1946,57.42652,2.06748),(.19861,57.38057,1.95002),(.17802,57.37464,2.00384),(.21178,57.42705,2.02427),(.11364,56.62246,2.06315),(.11467,56.6202,2.03573),(.17492,56.58878,1.58902),(.19428,56.57755,1.53923),(.19663,56.57564,1.54041),(.17255,56.59102,1.58806),(.31208,56.64344,1.50985),(.31396,56.64906,1.52307),(.31174,56.64079,1.51151),(.31425,56.65123,1.52087),(.38824,56.75351,1.69675),(.37409,56.74148,1.66138),(.36738,56.73801,1.6516),(.35715,56.73405,1.65383),(.37872,56.79315,2.17304),(.16248,57.12922,2.64005),(.27895,56.66908,1.48312),(.2594,56.6732,1.48372),(.26412,56.66335,1.47418),(.1997,56.60918,1.50628),(.1979,56.5745,1.52618),(.22045,56.60932,1.46074),(.26222,56.64048,1.45713),(.30683,57.14749,2.49805),(.30397,57.14401,2.49558),(.30623,57.15018,2.49681),(.10781,57.62162,2.36362),(.16061,57.13396,2.64272),(.19025,56.73107,2.0563),(.19478,56.74717,2.07306),(.2516,57.23915,2.48499),(.25603,57.24978,2.43322),(.24478,57.22984,2.46796),(.24583,57.24181,2.46104),(.25245,57.24721,2.46965),(.25508,57.25191,2.47518),(.33675,56.72552,1.62129),(.33123,56.72357,1.62058),(.20005,57.26829,2.54533),(.19742,57.26957,2.54197),(.19869,57.267,2.56345),(.1972,57.27672,2.55535),(.19452,57.28118,2.55672),(.19972,57.26765,2.55967),(.10348,56.74971,2.15397),(.10463,56.71478,2.22088),(.10282,56.7557,2.21253),(.10328,56.7078,2.16282),(.1278,56.86677,2.39916),(.11657,56.61869,1.99501),(.27954,56.63507,1.45957),(.21732,56.71075,2.20978),(.21517,56.69866,2.18661),(.20516,56.78785,2.08871),(.23539,57.22873,2.46029),(.25628,57.26023,2.45924),(.18613,57.35531,2.28844),(.18668,57.35853,2.27852),(.21018,57.33147,2.30241),(.20225,57.33726,2.30545),(.21814,57.34085,2.26442),(.18905,57.3502,2.29755),(.22626,57.35749,2.30756),(.2178,57.32942,2.29054),(.27731,57.44078,2.16539),(.26137,57.45982,2.18709),(.20727,57.45371,2.19612),(.25333,57.38916,2.30958),(.288,57.42715,2.2878),(.34277,56.98804,1.69207),(.33537,56.98705,1.69254),(.33605,56.97469,1.67995),(.35025,56.99626,1.67799),(.33709,56.99583,1.67923),(.35514,56.98906,1.68985),(.33275,56.98114,1.68704),(.34268,56.99607,1.66128),(.33111,56.99547,1.66713),(.32272,56.9854,1.65227),(.32421,56.99385,1.67042),(.3153,56.98308,1.65553),(.34625,56.98325,1.64743),(.35126,56.98911,1.65821),(.33515,56.98779,1.64722),(.31376,56.97998,1.65849),(.32815,56.9385,1.60581),(.30799,56.94366,1.59661),(.35642,56.95122,1.63732),(.34923,56.91169,1.66305),(.38764,56.91543,1.67063),(.37499,56.90875,1.66315),(.36333,56.89932,1.66846),(.37807,56.90029,1.67179),(.36094,56.90742,1.6604),(.36573,56.90299,1.6942),(.38043,56.9034,1.69802),(.40686,56.94093,1.72313),(.38305,57.03587,1.79702),(.36286,57.04472,1.81146),(.39995,56.96164,1.78143),(.39892,56.94167,1.74297),(.38013,56.94922,1.78634),(.35294,56.93014,1.73629),(.34336,56.94711,1.77288),(.38041,56.93155,1.7458),(.32821,56.93716,1.71919),(.35845,56.9208,1.72383),(.29192,56.98995,1.81724),(.27311,57.00422,1.79294),(.27169,57.02192,1.77294),(.34149,56.94886,1.68887),(.28811,57.04145,1.76191),(.31777,57.05926,1.76034),(.36128,56.97036,1.70309),(.33525,56.96653,1.69519),(.36418,56.95165,1.69595),(.35614,57.00909,1.72058),(.2582,57.21617,1.97605),(.24669,57.20932,1.98689),(.25218,57.2038,1.97212),(.25626,57.21797,1.98086),(.2212,57.17385,1.92154),(.22418,57.18023,1.93666),(.39705,57.01998,1.77849),(.29271,57.02638,1.81842),(.33042,56.96389,1.80904),(.39953,56.93115,1.72975),(.39069,56.90859,1.67792),(.39252,56.91059,1.69889),(.35047,56.90561,1.66887),(.35344,56.97096,1.64598),(.34099,56.95431,1.66707),(.32238,56.9905,1.67167),(.32705,56.99163,1.67841),(.3579,56.98938,1.67445),(.33324,56.98529,1.69116),(.36118,56.98417,1.68323),(.3632,56.97693,1.67557),(.21966,56.90644,2.37687),(.19422,57.42132,2.06688),(.18018,57.42551,2.09918),(.18001,57.4197,2.09796),(.23455,57.45975,2.19311),(.20219,57.38299,2.28526),(.22142,57.33245,2.27584),(.19442,57.3438,2.30439),(.19062,57.35964,2.26951),(.27358,57.21755,2.45716),(.31496,56.68704,1.57647),(.31818,56.68863,1.57508),(.259,56.88842,2.50271),(.25708,56.86183,2.47466),(.21861,56.56933,1.47468),(.21296,56.63075,1.48189),(.12934,56.81774,2.37087),(.36148,56.8281,1.93611),(.25871,57.26448,2.46452),(.24713,57.25485,2.44881),(.28911,57.18441,2.47977),(.29751,56.61199,1.47452),(.13983,57.22642,2.65172),(.26757,56.85987,2.47418),(.35044,56.80161,2.0367),(.28171,57.06967,1.86875),(.28323,57.0016,1.86123),(.28222,56.99605,1.86519),(.26131,57.2211,1.98979),(.27291,57.21293,1.99302),(.26462,57.21953,1.98487),(.31159,56.8875,2.01377),(.3369,56.81063,2.03615),(.34687,56.81905,2.03572),(.31209,56.88598,2.0087),(.23839,57.33357,1.84577),(.23371,57.33447,1.84764),(.23008,57.33631,1.85174),(.22845,57.33857,1.85696),(.22928,57.34059,1.86169),(.23233,57.34187,1.86478),(.24673,57.33736,1.85509),(.24511,57.33954,1.86007),(.2477,57.15599,1.91949),(.3342,57.19678,1.86643),(.37272,57.05453,1.81237),(.369,57.05303,1.8127),(.30116,57.15964,1.91224),(.32808,57.05108,1.85176),(.30617,57.15816,1.93211),(.33536,57.04049,1.86704),(.31812,57.16114,1.94198),(.34911,57.03818,1.87606),(.33359,57.16758,1.93901),(.36563,57.04479,1.87528),(.34401,57.17392,1.92263),(.37637,57.05709,1.86287),(.35487,57.18175,1.89976),(.38235,57.0732,1.84415),(.35843,57.1873,1.87528),(.36219,57.14619,1.83182),(.36376,57.12328,1.90793),(.3105,57.11111,1.89788),(.38068,57.04779,1.80641),(.36331,57.04239,1.82244),(.37509,57.04404,1.82536),(.38642,57.04385,1.80418),(.38557,57.03048,1.81907),(.3295,56.86055,1.90411),(.32388,56.85952,1.90038),(.34136,57.17275,1.76998),(.20528,57.237,1.71673),(.19789,57.06026,1.80459),(.19082,57.10515,1.8363),(.18677,57.08991,1.80338),(.20005,57.25405,1.73579),(.20624,57.25854,1.74041),(.29355,57.20231,1.83882),(.28056,57.05522,1.8522),(.26513,57.05911,1.85581),(.33057,57.19263,1.8096),(.1995,57.24167,1.72212),(.19759,57.24792,1.7291),(.2278,57.2424,1.72036),(.22834,57.25499,1.73404),(.23026,57.2489,1.72707),(.1491,57.23937,1.73817),(.14256,57.23115,1.74367),(.27946,56.90507,1.82937),(.31124,56.88603,1.88746),(.32583,56.86169,1.88409),(.33088,56.86251,1.88383),(.32327,56.86056,1.89016),(.26639,56.98768,1.81114),(.28415,56.94551,1.77226),(.28573,56.93926,1.771),(.2569,56.94296,1.84164),(.26067,57.00696,1.81314),(.26116,57.00594,1.80837),(.28488,56.89769,1.87646),(.23361,56.96695,1.71945),(.18517,57.04548,1.69291),(.24451,57.17652,1.6435),(.29348,57.18229,1.65545),(.25258,57.1709,1.63532),(.38523,56.85437,1.65477),(.34138,56.87877,1.65098),(.26459,56.8248,1.5785),(.21239,56.86807,1.5335),(.20108,56.87176,1.55427),(.19491,56.94207,1.54408),(.19137,56.91513,1.54726),(.19883,56.94306,1.55567),(.2777,57.04877,1.54142),(.25329,57.10101,1.56163),(.24224,57.10503,1.56355),(.24583,57.10908,1.56903),(.26845,57.01688,1.52493),(.28505,57.02853,1.54961),(.26213,57.03724,1.51822),(.21911,57.04694,1.51963),(.23431,57.10287,1.56242),(.23211,57.10525,1.56708),(.23379,57.1144,1.58133),(.22188,57.11943,1.60182),(.2374,57.11866,1.58681),(.23744,57.06958,1.60235),(.24553,57.12085,1.58758),(.24177,57.12097,1.58896),(.24773,57.11826,1.58291),(.24784,57.11392,1.57611),(.21882,57.10423,1.57783),(.21465,57.16857,2.09838),(.20283,57.16803,2.09438),(.19726,56.88743,1.55189),(.30824,56.80636,1.5441),(.31696,56.8057,1.53168),(.30043,56.8046,1.53185),(.31892,56.77802,1.58423),(.31376,56.77531,1.57997),(.3181,56.77795,1.58524),(.31283,56.77603,1.57962),(.31903,56.7767,1.58384),(.31823,56.77815,1.58575),(.3129,56.77524,1.58094),(.3858,56.85538,1.65368),(.38431,56.84971,1.65254),(.3956,56.84141,1.65071),(.3988,56.83667,1.65612),(.34088,56.8789,1.64627),(.22076,56.95558,1.72055),(.23736,56.95958,1.72344),(.21945,56.95797,1.71921),(.20556,56.94655,1.71085),(.20716,56.9506,1.71139),(.29273,56.89272,1.64454),(.30925,56.88961,1.64608),(.30963,56.89153,1.63901),(.26313,56.94475,1.66829),(.27691,56.85955,1.60439),(.10482,57.30501,1.80041),(.09821,57.15552,1.89231),(0,57.74616,2.16395),(0,57.74635,2.12249),(.12698,57.18432,1.72101),(.13125,57.18557,1.72308),(.10106,56.83158,2.35055),(.10619,56.94802,1.70844),(.13344,57.01015,1.78366),(.08378,57.00874,1.8748),(.09264,57.07752,1.8581),(.02284,56.71743,2.04135),(.03024,56.72931,2.10297),(.02128,56.90106,1.92521),(0,56.67837,2.29489),(0,57.76556,2.24702),(0,57.01782,2.4949),(.08887,56.98245,1.78783),(.10537,57.29974,1.85005),(.10229,56.86177,1.91098),(.10008,57.1463,1.84125),(.26219,56.94817,1.67281),(.30834,56.88891,1.63885),(.3107,56.89226,1.64791),(.29374,56.89681,1.64717),(.21105,56.95491,1.71354),(.21575,56.95775,1.71653),(.38467,56.84962,1.65093),(.40604,56.84359,1.67005),(.39784,56.8456,1.65471),(.3166,56.77918,1.58508),(.31411,56.77847,1.58127),(.31448,56.77875,1.58041),(.30105,56.80971,1.54046),(.20786,56.88662,1.53165),(.23196,57.1094,1.57393),(.23802,57.1028,1.56113),(.2643,57.0687,1.5904),(.22837,56.89166,1.51521),(.24754,57.15987,1.63199),(.28498,56.98415,1.82065),(.27189,56.99214,1.82808),(.28236,56.99213,1.81909),(.15562,57.22102,1.71643),(.28179,57.23671,1.70161),(.33495,57.11894,1.84293),(.35228,57.13723,1.78693),(.34088,57.15737,1.82914),(.30166,57.16873,1.85981),(.18256,57.21427,1.81874),(.20639,57.07492,1.83991),(.34757,56.80098,2.03642),(.34759,56.80127,2.03667),(.42697,56.91997,1.85407),(.42777,56.92226,1.84948),(.37696,57.0463,1.80677),(.37703,57.04789,1.82159),(.36497,57.03998,1.82584),(.31732,57.10435,1.91698),(.37102,57.13592,1.88474),(.36925,57.16848,1.86677),(.37861,57.06092,1.83362),(.36628,57.16334,1.89602),(.37445,57.05033,1.84546),(.35494,57.15473,1.92464),(.3662,57.04186,1.85267),(.34041,57.14623,1.94423),(.35542,57.03756,1.85293),(.32046,57.13807,1.94766),(.34643,57.03906,1.84708),(.30536,57.1344,1.93547),(.34166,57.04598,1.83719),(.29997,57.13613,1.91062),(.24147,57.34126,1.86384),(.2368,57.34211,1.86557),(.34621,56.821,2.04132),(.33536,56.81167,2.04135),(.31345,57.00274,1.87621),(.20034,57.02085,1.92373),(.27212,57.43019,1.94313),(.40052,56.81229,2.05821),(.20353,57.25851,2.5576),(.36164,56.97977,1.67052),(.32926,56.99437,1.67935),(.3977,56.9196,1.69745),(.34159,57.04736,1.82188),(.38086,56.92189,1.73141),(.31531,57.04073,1.82588),(.3274,57.19943,1.88889),(0,57.75577,2.20549)]))),
        Shape(DEF='inconl',
          appearance=Appearance(
            material=Material(ambientIntensity=0.965,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='inconl_Geo',coordIndex=[0,1,2,-1,1,3,4,-1,5,6,7,-1,8,9,10,-1,11,5,7,-1,12,10,13,-1,10,7,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,29,14,30,-1,31,32,33,-1,34,35,4,-1,4,36,34,-1,37,31,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,16,57,58,-1,59,57,2,-1,60,61,62,-1,63,28,64,-1,65,66,40,-1,6,33,67,-1,27,68,69,-1,70,29,71,-1,72,36,4,-1,73,65,40,-1,64,74,75,-1,76,77,78,-1,44,45,79,-1,80,81,82,-1,63,83,26,-1,84,85,86,-1,87,46,88,-1,42,88,43,-1,87,49,48,-1,18,89,90,-1,91,92,81,-1,48,47,87,-1,71,51,53,-1,26,50,93,-1,79,94,63,-1,39,95,78,-1,74,96,75,-1,97,62,98,-1,99,100,93,-1,71,101,102,-1,103,104,70,-1,28,27,76,-1,2,32,59,-1,105,106,72,-1,6,5,31,-1,107,72,108,-1,66,41,40,-1,31,59,32,-1,109,15,110,-1,56,75,96,-1,111,112,113,-1,50,49,114,-1,48,83,94,-1,115,37,38,-1,116,97,117,-1,34,36,118,-1,78,77,58,-1,119,57,59,-1,120,87,121,-1,116,122,123,-1,110,14,124,-1,12,13,35,-1,9,11,10,-1,7,6,125,-1,0,109,126,-1,62,127,98,-1,41,66,37,-1,3,1,0,-1,62,128,127,-1,125,13,7,-1,34,8,12,-1,12,35,34,-1,110,15,14,-1,129,69,68,-1,130,56,55,-1,119,65,57,-1,58,73,78,-1,8,34,118,-1,117,131,116,-1,31,66,119,-1,94,47,48,-1,50,114,132,-1,111,113,51,-1,55,54,80,-1,110,126,109,-1,133,4,67,-1,31,119,59,-1,107,108,61,-1,6,31,33,-1,72,107,105,-1,115,41,37,-1,2,133,32,-1,27,69,76,-1,103,134,104,-1,71,29,101,-1,99,135,100,-1,128,62,108,-1,74,41,96,-1,79,45,94,-1,26,83,50,-1,71,53,70,-1,46,43,88,-1,91,81,136,-1,18,137,89,-1,17,137,18,-1,138,139,140,-1,87,120,49,-1,42,141,88,-1,87,47,46,-1,63,94,83,-1,80,82,55,-1,107,140,136,-1,136,105,107,-1,75,44,79,-1,78,95,76,-1,75,79,64,-1,4,3,72,-1,70,104,29,-1,27,100,68,-1,67,125,6,-1,65,119,66,-1,79,63,64,-1,56,130,75,-1,61,108,62,-1,57,109,2,-1,3,108,72,-1,58,142,16,-1,56,96,54,-1,51,113,52,-1,83,48,50,-1,45,47,94,-1,143,42,44,-1,41,74,39,-1,52,89,53,-1,37,66,31,-1,30,101,29,-1,28,63,26,-1,23,25,144,-1,90,20,22,-1,17,19,131,-1,97,60,62,-1,16,30,14,-1,7,10,11,-1,8,10,12,-1,125,35,13,-1,108,3,0,-1,2,109,0,-1,145,146,147,-1,145,92,146,-1,129,148,142,-1,129,68,148,-1,120,149,150,-1,120,121,149,-1,124,134,151,-1,104,134,124,-1,31,11,38,-1,5,11,31,-1,86,17,84,-1,137,17,86,-1,64,39,74,-1,64,95,39,-1,111,114,112,-1,132,114,111,-1,33,133,67,-1,33,32,133,-1,80,106,105,-1,106,80,152,-1,152,38,153,-1,38,152,115,-1,154,97,98,-1,154,117,97,-1,60,138,61,-1,60,123,138,-1,143,75,130,-1,143,44,75,-1,71,111,51,-1,102,111,71,-1,92,82,81,-1,145,82,92,-1,146,144,25,-1,144,146,155,-1,23,52,113,-1,23,20,52,-1,123,156,138,-1,123,122,156,-1,116,19,122,-1,116,131,19,-1,52,90,89,-1,90,52,20,-1,24,113,112,-1,113,24,23,-1,145,141,42,-1,141,145,147,-1,141,87,88,-1,141,121,87,-1,111,99,132,-1,99,111,102,-1,80,136,81,-1,105,136,80,-1,123,97,116,-1,123,60,97,-1,15,57,16,-1,109,57,15,-1,106,153,118,-1,106,152,153,-1,45,43,46,-1,44,43,45,-1,41,54,96,-1,41,115,54,-1,122,22,156,-1,19,22,122,-1,11,153,38,-1,11,9,153,-1,101,148,135,-1,30,148,101,-1,134,154,151,-1,154,134,85,-1,144,20,23,-1,20,144,21,-1,30,142,148,-1,16,142,30,-1,138,157,139,-1,138,156,157,-1,4,2,1,-1,4,133,2,-1,155,92,91,-1,92,155,146,-1,151,98,127,-1,98,151,154,-1,19,90,22,-1,18,90,19,-1,24,149,25,-1,24,150,149,-1,100,26,93,-1,100,27,26,-1,104,14,29,-1,124,14,104,-1,84,131,117,-1,84,17,131,-1,76,64,28,-1,64,76,95,-1,145,143,82,-1,145,42,143,-1,80,115,152,-1,80,54,115,-1,142,77,129,-1,142,58,77,-1,129,76,69,-1,77,76,129,-1,140,61,138,-1,61,140,107,-1,130,82,143,-1,55,82,130,-1,86,134,103,-1,86,85,134,-1,150,49,120,-1,114,49,150,-1,147,25,149,-1,146,25,147,-1,157,144,155,-1,157,21,144,-1,156,21,157,-1,21,156,22,-1,140,91,136,-1,140,139,91,-1,150,112,114,-1,150,24,112,-1,141,149,121,-1,149,141,147,-1,70,89,103,-1,70,53,89,-1,93,132,99,-1,93,50,132,-1,39,73,40,-1,39,78,73,-1,110,128,126,-1,110,127,128,-1,135,102,101,-1,102,135,99,-1,36,106,118,-1,36,72,106,-1,137,103,89,-1,86,103,137,-1,85,117,154,-1,117,85,84,-1,118,9,8,-1,9,118,153,-1,57,73,58,-1,65,73,57,-1,100,148,68,-1,100,135,148,-1,35,67,4,-1,35,125,67,-1,151,110,124,-1,127,110,151,-1,139,155,91,-1,139,157,155,-1,126,108,0,-1,108,126,128,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='inconl_Coord',point=[(.42235,56.33624,1.88087),(.47516,56.30084,1.95051),(.49391,56.21315,2.04642),(.44439,56.39764,1.87293),(.53336,56.22789,1.92959),(.5424,56.24189,2.32345),(.55552,56.20578,2.23952),(.56173,56.17849,2.23602),(.58162,56.11879,1.9921),(.57735,56.20334,2.22077),(.57514,56.1756,2.22561),(.54984,56.24838,2.3243),(.56994,56.09318,2.01322),(.55705,56.09668,2.01946),(.33545,56.14303,2.10948),(.405,56.19285,2.08135),(.33862,56.19479,2.28159),(.33358,56.11829,1.39776),(.31323,56.13799,1.51745),(.3235,56.16858,1.5027),(.2699,56.14727,1.85508),(.28227,56.21021,1.84357),(.30467,56.19185,1.65986),(.2528,56.12195,2.04221),(.24719,56.08975,2.20903),(.24669,56.1797,2.18588),(.25297,56.04465,2.84816),(.26222,56.07936,2.81111),(.28007,56.19622,2.89184),(.30046,56.07226,2.10681),(.29999,56.11274,2.28143),(.51593,56.33333,2.39112),(.53007,56.23981,2.2486),(.53949,56.2322,2.24628),(.57082,56.10754,1.88659),(.561,56.1054,1.88822),(.54164,56.24881,1.94199),(.46646,56.49872,2.5351),(.52104,56.34015,2.39319),(.39235,56.46359,2.7203),(.45668,56.49404,2.54516),(.46112,56.51102,2.54263),(.35449,56.42941,2.48305),(.30789,56.42126,2.72416),(.31744,56.47115,2.72368),(.30055,56.36662,2.80494),(.29949,56.35752,2.78352),(.24696,56.1702,2.88574),(.22185,56.07289,2.82806),(.23778,55.99465,2.6112),(.23826,55.95622,2.64279),(.27937,56.02875,2.09096),(.27371,56.11401,1.8648),(.2739,56.09284,1.8681),(.44613,56.48224,2.3981),(.43423,56.47848,2.39161),(.43644,56.52054,2.54722),(.39594,56.26447,2.27766),(.33984,56.27008,2.5166),(.42996,56.27173,2.27651),(.40817,56.264,1.51659),(.40838,56.34929,1.6843),(.40994,56.24277,1.51913),(.26168,56.17642,2.91406),(.32152,56.38363,2.86671),(.41565,56.39012,2.41799),(.46314,56.49318,2.53999),(.56215,56.14298,2.01287),(.27112,56.11141,2.68278),(.27718,56.12961,2.76508),(.2857,56.08848,1.87238),(.29575,56.02601,2.09598),(.44205,56.42517,1.85985),(.39585,56.38686,2.5354),(.38578,56.47876,2.72541),(.35053,56.49132,2.73343),(.29744,56.20899,2.87148),(.30718,56.2306,2.75133),(.35595,56.38003,2.70886),(.30665,56.37987,2.8702),(.46215,56.48446,2.22464),(.43104,56.46758,2.21757),(.39956,56.45047,2.36672),(.23876,56.0515,2.84338),(.34541,56.11665,1.39412),(.3236,56.13573,1.55458),(.32048,56.10313,1.54122),(.2438,56.15033,2.81856),(.2957,56.37104,2.7401),(.28729,56.09882,1.67979),(.28614,56.14488,1.66963),(.40147,56.42407,2.04803),(.38503,56.41828,2.2011),(.25245,55.95637,2.65317),(.24873,56.17342,2.89824),(.33074,56.37415,2.8506),(.44498,56.52562,2.54962),(.37086,56.14799,1.38976),(.37313,56.20534,1.53709),(.27059,55.9508,2.51441),(.2603,56.00527,2.66252),(.2871,56.03247,2.27161),(.29252,55.9672,2.25626),(.30396,56.09255,1.68395),(.30449,56.13443,1.88385),(.45921,56.48839,2.06027),(.48437,56.47273,2.06102),(.4357,56.43958,1.86062),(.41524,56.32491,1.68947),(.45294,56.242,2.05618),(.36696,56.23956,1.89009),(.27641,55.96741,2.25541),(.25845,56.02436,2.23089),(.25901,56.07009,2.07145),(.24081,55.99227,2.46862),(.4557,56.47701,2.40944),(.3548,56.14954,1.38961),(.35347,56.12639,1.38731),(.58608,56.23055,2.00669),(.4425,56.37466,2.41101),(.23392,56.08166,2.5709),(.24129,56.15027,2.5354),(.35149,56.22493,1.51003),(.38949,56.26651,1.51742),(.32632,56.18001,1.88761),(.56064,56.12121,2.01846),(.39418,56.28823,1.88436),(.36341,56.23707,1.69172),(.38974,56.28364,1.68699),(.28076,56.14914,2.70768),(.41024,56.47916,2.51436),(.34143,56.12754,1.38946),(.24838,55.95147,2.49811),(.55162,56.15138,2.01804),(.31235,56.1452,1.69355),(.26905,56.00167,2.50319),(.43639,56.47597,2.0544),(.30675,56.10894,1.53014),(.39236,56.34646,1.67389),(.39414,56.39349,1.85461),(.42112,56.43909,1.85831),(.29869,56.34224,2.49034),(.30589,56.18588,2.50347),(.37534,56.45074,2.48518),(.27161,56.20879,2.02418),(.36397,56.41985,2.35168),(.31931,56.34035,2.19632),(.30315,56.33989,2.34162),(.27703,56.09703,2.49606),(.24074,56.16233,2.36398),(.22968,56.06087,2.41568),(.32957,56.18516,1.69921),(.48567,56.47107,2.22821),(.57077,56.28708,2.22249),(.34039,56.16602,1.55295),(.34058,56.34499,2.03565),(.34594,56.28086,1.65696),(.33469,56.32485,1.84089)]))),
        Shape(DEF='inconr',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='inconr_Geo',coordIndex=[0,1,2,-1,3,4,1,-1,5,6,7,-1,8,9,10,-1,7,11,8,-1,5,8,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,40,3,30,-1,41,39,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,43,-1,60,61,62,-1,63,64,65,-1,66,67,4,-1,0,68,65,-1,67,69,17,-1,70,71,61,-1,72,73,40,-1,74,75,76,-1,37,6,29,-1,77,78,79,-1,3,40,66,-1,76,75,80,-1,70,81,82,-1,83,84,85,-1,82,54,49,-1,86,87,88,-1,62,89,90,-1,57,52,33,-1,91,92,93,-1,91,53,92,-1,94,91,95,-1,56,96,93,-1,24,97,20,-1,89,98,99,-1,100,101,102,-1,91,94,53,-1,79,43,59,-1,55,57,32,-1,52,54,82,-1,60,48,47,-1,67,16,103,-1,104,105,106,-1,107,36,35,-1,79,78,108,-1,109,110,31,-1,111,38,112,-1,113,48,114,-1,73,88,66,-1,37,39,6,-1,69,66,88,-1,38,111,74,-1,28,3,112,-1,68,115,15,-1,90,116,62,-1,59,117,118,-1,52,57,56,-1,41,113,114,-1,72,119,10,-1,64,85,84,-1,120,93,96,-1,121,122,123,-1,13,15,115,-1,12,119,30,-1,8,11,9,-1,124,125,103,-1,2,1,4,-1,113,42,48,-1,124,103,16,-1,126,68,2,-1,12,10,119,-1,30,127,12,-1,115,128,13,-1,129,110,130,-1,62,61,71,-1,64,84,80,-1,72,40,119,-1,74,42,39,-1,56,92,52,-1,59,58,117,-1,60,70,61,-1,68,126,115,-1,38,74,39,-1,76,48,42,-1,69,67,66,-1,39,7,6,-1,73,86,88,-1,111,112,0,-1,109,31,131,-1,79,108,132,-1,107,35,77,-1,104,106,133,-1,124,16,18,-1,70,60,47,-1,84,83,46,-1,33,52,82,-1,104,55,32,-1,59,77,79,-1,93,92,56,-1,100,96,101,-1,134,89,99,-1,24,44,97,-1,20,97,21,-1,87,135,136,-1,56,101,96,-1,95,50,94,-1,137,138,139,-1,32,57,33,-1,62,140,89,-1,86,134,87,-1,82,49,70,-1,109,83,85,-1,70,47,81,-1,66,4,3,-1,77,35,78,-1,28,37,29,-1,76,42,74,-1,73,66,40,-1,131,33,82,-1,82,81,131,-1,16,67,17,-1,0,65,111,-1,65,14,63,-1,60,62,116,-1,43,45,58,-1,55,101,56,-1,52,92,53,-1,49,94,50,-1,48,76,46,-1,41,42,113,-1,40,30,119,-1,34,13,35,-1,33,131,31,-1,3,28,30,-1,26,141,27,-1,24,142,22,-1,21,143,19,-1,13,34,14,-1,127,5,12,-1,7,8,5,-1,12,8,10,-1,127,30,29,-1,2,4,67,-1,2,68,0,-1,144,145,146,-1,144,98,145,-1,115,147,128,-1,147,115,125,-1,108,128,147,-1,128,108,78,-1,11,39,41,-1,39,11,7,-1,148,138,149,-1,139,138,148,-1,132,97,44,-1,97,132,137,-1,73,90,86,-1,150,90,73,-1,129,31,110,-1,129,105,31,-1,18,149,124,-1,18,148,149,-1,136,17,69,-1,136,121,17,-1,151,104,133,-1,151,55,104,-1,44,79,132,-1,44,43,79,-1,140,98,89,-1,98,140,145,-1,25,144,26,-1,152,144,25,-1,45,27,58,-1,45,23,27,-1,153,121,136,-1,153,122,121,-1,19,123,122,-1,19,143,123,-1,24,45,44,-1,23,45,24,-1,58,141,117,-1,27,141,58,-1,95,145,50,-1,146,145,95,-1,108,137,132,-1,108,138,137,-1,140,71,51,-1,71,140,62,-1,69,87,136,-1,88,87,69,-1,109,130,110,-1,130,109,85,-1,85,63,130,-1,85,64,63,-1,114,90,150,-1,114,116,90,-1,94,54,53,-1,54,94,49,-1,116,48,60,-1,116,114,48,-1,142,122,153,-1,122,142,19,-1,143,139,148,-1,143,21,139,-1,74,65,75,-1,111,65,74,-1,154,36,106,-1,36,154,34,-1,149,108,147,-1,138,108,149,-1,23,25,27,-1,22,25,23,-1,63,34,154,-1,34,63,14,-1,29,5,127,-1,5,29,6,-1,98,152,99,-1,144,152,98,-1,0,3,1,-1,0,112,3,-1,155,136,135,-1,155,153,136,-1,124,147,125,-1,149,147,124,-1,24,19,142,-1,19,24,20,-1,156,141,26,-1,156,100,141,-1,32,105,104,-1,32,31,105,-1,13,78,35,-1,78,13,128,-1,157,11,41,-1,157,9,11,-1,123,148,18,-1,143,148,123,-1,81,109,131,-1,83,109,81,-1,51,145,140,-1,51,50,145,-1,55,102,101,-1,151,102,55,-1,157,73,72,-1,157,150,73,-1,65,15,14,-1,15,65,68,-1,18,121,123,-1,18,17,121,-1,134,90,89,-1,90,134,86,-1,133,118,151,-1,107,118,133,-1,93,95,91,-1,93,120,95,-1,26,146,156,-1,146,26,144,-1,25,155,152,-1,25,22,155,-1,22,153,155,-1,142,153,22,-1,99,87,134,-1,99,135,87,-1,117,100,102,-1,117,141,100,-1,156,95,120,-1,146,95,156,-1,118,77,59,-1,77,118,107,-1,70,51,71,-1,70,49,51,-1,80,46,76,-1,80,84,46,-1,103,115,126,-1,103,125,115,-1,107,106,36,-1,133,106,107,-1,41,150,157,-1,114,150,41,-1,112,37,28,-1,112,38,37,-1,102,118,117,-1,118,102,151,-1,46,81,47,-1,46,83,81,-1,21,137,139,-1,137,21,97,-1,9,72,10,-1,157,72,9,-1,80,65,64,-1,65,80,75,-1,154,105,129,-1,154,106,105,-1,156,96,100,-1,156,120,96,-1,154,130,63,-1,154,129,130,-1,152,135,99,-1,152,155,135,-1,67,126,2,-1,103,126,67,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='inconr_Coord',point=[(-.49391,56.21315,2.03542),(-.47516,56.30084,1.94096),(-.42235,56.33624,1.87302),(-.53336,56.22789,1.92018),(-.44439,56.39764,1.86471),(-.56173,56.17849,2.22082),(-.55552,56.20578,2.22413),(-.5424,56.24189,2.30651),(-.57514,56.1756,2.21042),(-.57735,56.20334,2.2054),(-.58162,56.11879,1.98186),(-.54984,56.24838,2.30714),(-.56994,56.09318,2.00288),(-.33545,56.14303,2.10088),(-.33862,56.19479,2.27059),(-.405,56.19285,2.07142),(-.40994,56.24277,1.51756),(-.40817,56.264,1.51498),(-.37086,56.14799,1.38975),(-.3235,56.16858,1.50167),(-.31323,56.13799,1.51635),(-.33358,56.11829,1.39775),(-.28227,56.21021,1.83868),(-.2699,56.14727,1.85049),(-.28614,56.14488,1.66683),(-.27161,56.20879,2.01761),(-.24669,56.1797,2.17851),(-.2528,56.12195,2.03622),(-.56215,56.14298,2.00218),(-.56064,56.12121,2.00786),(-.561,56.1054,1.8803),(-.26222,56.07936,2.79873),(-.25297,56.04465,2.83621),(-.26168,56.17642,2.90034),(-.29999,56.11274,2.27198),(-.30046,56.07226,2.09938),(-.2871,56.03247,2.26307),(-.53949,56.2322,2.23085),(-.53007,56.23981,2.23325),(-.51593,56.33333,2.37297),(-.54164,56.24881,1.93213),(-.52104,56.34015,2.37485),(-.46314,56.49318,2.5202),(-.2739,56.09284,1.86353),(-.28729,56.09882,1.67705),(-.27371,56.11401,1.86018),(-.39235,56.46359,2.70075),(-.38578,56.47876,2.706),(-.46112,56.51102,2.52281),(-.31744,56.47115,2.70732),(-.35449,56.42941,2.46806),(-.37534,56.45074,2.46933),(-.24873,56.17342,2.88527),(-.29949,56.35752,2.76788),(-.30055,56.36662,2.78901),(-.23826,55.95622,2.63333),(-.22185,56.07289,2.81742),(-.23876,56.0515,2.83204),(-.25901,56.07009,2.06527),(-.27937,56.02875,2.08437),(-.44498,56.52562,2.5302),(-.43644,56.52054,2.52814),(-.43423,56.47848,2.37504),(-.30589,56.18588,2.49118),(-.33984,56.27008,2.50246),(-.39594,56.26447,2.26477),(-.44205,56.42517,1.8518),(-.41524,56.32491,1.68481),(-.45294,56.242,2.04549),(-.40838,56.34929,1.67969),(-.35053,56.49132,2.71541),(-.41024,56.47916,2.49678),(-.58608,56.23055,1.99524),(-.48437,56.47273,2.04871),(-.4425,56.37466,2.39431),(-.41565,56.39012,2.40193),(-.45668,56.49404,2.5255),(-.29575,56.02601,2.089),(-.30449,56.13443,1.87849),(-.2857,56.08848,1.86761),(-.39585,56.38686,2.51841),(-.32152,56.38363,2.84913),(-.30665,56.37987,2.85333),(-.33074,56.37415,2.83278),(-.35595,56.38003,2.69135),(-.30718,56.2306,2.73638),(-.45921,56.48839,2.0484),(-.42112,56.43909,1.85052),(-.4357,56.43958,1.8526),(-.43104,56.46758,2.20381),(-.46215,56.48446,2.20995),(-.2957,56.37104,2.72497),(-.24696,56.1702,2.87295),(-.2438,56.15033,2.80647),(-.30789,56.42126,2.70842),(-.29869,56.34224,2.47767),(-.23392,56.08166,2.56132),(-.30675,56.10894,1.52901),(-.38503,56.41828,2.1889),(-.40147,56.42407,2.03766),(-.22968,56.06087,2.4075),(-.23778,55.99465,2.60171),(-.24081,55.99227,2.46004),(-.38974,56.28364,1.68268),(-.25245,55.95637,2.64312),(-.2603,56.00527,2.65177),(-.26905,56.00167,2.49335),(-.29252,55.9672,2.24812),(-.31235,56.1452,1.69028),(-.29744,56.20899,2.85613),(-.27718,56.12961,2.75201),(-.42996,56.27173,2.26271),(-.55162,56.15138,2.00729),(-.46646,56.49872,2.51525),(-.4557,56.47701,2.39196),(-.36696,56.23956,1.88327),(-.44613,56.48224,2.38107),(-.25845,56.02436,2.22352),(-.27641,55.96741,2.24769),(-.57082,56.10754,1.87863),(-.24129,56.15027,2.52543),(-.38949,56.26651,1.51578),(-.35149,56.22493,1.50868),(-.3548,56.14954,1.38959),(-.37313,56.20534,1.53541),(-.36341,56.23707,1.68771),(-.39418,56.28823,1.87704),(-.55705,56.09668,2.00908),(-.32632,56.18001,1.88168),(-.27112,56.11141,2.67072),(-.28076,56.14914,2.69477),(-.28007,56.19622,2.87725),(-.30396,56.09255,1.68107),(-.27059,55.9508,2.50477),(-.43639,56.47597,2.04309),(-.39414,56.39349,1.84737),(-.39236,56.34646,1.66956),(-.32048,56.10313,1.53996),(-.3236,56.13573,1.55301),(-.34541,56.11665,1.39411),(-.39956,56.45047,2.35167),(-.24719,56.08975,2.20182),(-.30467,56.19185,1.65687),(-.34143,56.12754,1.38946),(-.31931,56.34035,2.18622),(-.36397,56.41985,2.33805),(-.30315,56.33989,2.33038),(-.32957,56.18516,1.69557),(-.35347,56.12639,1.38731),(-.34039,56.16602,1.55125),(-.48567,56.47107,2.21296),(-.24838,55.95147,2.48933),(-.34058,56.34499,2.02697),(-.34594,56.28086,1.6534),(-.27703,56.09703,2.48539),(-.33469,56.32485,1.83489),(-.24074,56.16233,2.35534),(-.57077,56.28708,2.20656)]))),
        Shape(DEF='maxl',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='maxl_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,28,29,-1,28,30,31,-1,32,33,34,-1,35,36,37,-1,38,35,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,52,53,54,-1,47,49,51,-1,55,13,56,-1,23,57,58,-1,59,37,60,-1,61,62,63,-1,63,64,65,-1,66,36,67,-1,38,67,35,-1,68,69,38,-1,70,71,72,-1,73,70,72,-1,74,75,76,-1,23,70,73,-1,77,78,79,-1,80,81,82,-1,83,62,61,-1,84,85,86,-1,87,88,89,-1,90,91,92,-1,93,94,95,-1,96,97,98,-1,99,100,101,-1,102,94,103,-1,104,105,106,-1,107,108,109,-1,110,111,112,-1,112,111,113,-1,114,115,116,-1,117,118,119,-1,120,121,122,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,147,148,149,-1,150,151,152,-1,107,153,154,-1,155,156,157,-1,158,159,160,-1,161,162,163,-1,164,165,166,-1,167,168,169,-1,170,171,172,-1,173,161,174,-1,175,176,177,-1,178,179,180,-1,181,182,183,-1,184,185,186,-1,187,188,189,-1,188,187,190,-1,191,192,193,-1,190,194,195,-1,196,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,209,210,-1,211,212,213,-1,214,215,216,-1,217,218,219,-1,220,221,222,-1,223,224,225,-1,226,227,228,-1,229,230,231,-1,127,232,233,-1,234,235,236,-1,237,238,239,-1,238,240,239,-1,232,241,242,-1,243,244,245,-1,246,146,247,-1,248,249,250,-1,251,247,252,-1,253,254,247,-1,172,255,256,-1,257,258,259,-1,260,261,262,-1,263,264,265,-1,266,260,267,-1,268,257,269,-1,270,271,272,-1,273,274,275,-1,276,277,278,-1,231,279,280,-1,281,282,283,-1,284,285,286,-1,287,288,289,-1,290,291,137,-1,292,293,294,-1,138,295,296,-1,297,177,298,-1,299,179,178,-1,300,295,301,-1,302,303,304,-1,297,305,177,-1,306,307,308,-1,309,310,311,-1,312,313,314,-1,257,315,316,-1,317,318,228,-1,319,145,144,-1,320,321,322,-1,323,248,324,-1,254,325,326,-1,327,328,329,-1,330,331,332,-1,256,333,259,-1,334,335,336,-1,170,172,337,-1,172,338,337,-1,339,222,221,-1,340,341,342,-1,343,344,191,-1,345,346,347,-1,197,196,348,-1,349,350,351,-1,352,353,289,-1,199,354,355,-1,356,290,357,-1,358,359,360,-1,358,174,359,-1,361,362,363,-1,364,365,366,-1,367,368,369,-1,363,370,361,-1,371,372,373,-1,374,299,178,-1,375,371,373,-1,376,377,378,-1,379,380,381,-1,382,383,384,-1,385,386,387,-1,388,389,390,-1,345,191,344,-1,307,357,353,-1,391,392,204,-1,393,394,395,-1,396,397,398,-1,399,400,401,-1,402,403,404,-1,405,400,406,-1,407,408,409,-1,410,411,412,-1,410,413,411,-1,414,415,416,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,211,-1,215,428,429,-1,430,431,432,-1,433,233,232,-1,285,434,435,-1,436,284,286,-1,323,437,438,-1,336,335,337,-1,334,439,440,-1,440,441,334,-1,439,442,440,-1,443,227,444,-1,247,149,148,-1,445,446,154,-1,261,266,447,-1,448,449,450,-1,451,452,453,-1,454,455,456,-1,457,458,459,-1,454,460,455,-1,461,462,463,-1,464,465,466,-1,457,467,468,-1,469,470,471,-1,472,473,474,-1,475,476,477,-1,478,479,480,-1,481,480,479,-1,475,482,483,-1,484,485,486,-1,481,483,480,-1,487,488,489,-1,488,490,489,-1,491,490,492,-1,493,494,495,-1,496,497,498,-1,495,491,493,-1,499,500,501,-1,502,503,122,-1,504,505,506,-1,507,508,509,-1,510,511,512,-1,510,513,514,-1,515,509,508,-1,516,517,502,-1,518,519,520,-1,521,158,522,-1,523,524,525,-1,162,522,158,-1,526,527,528,-1,529,530,531,-1,532,533,534,-1,535,536,537,-1,538,539,540,-1,541,542,543,-1,544,545,546,-1,547,531,548,-1,521,549,550,-1,551,552,553,-1,554,555,556,-1,557,558,559,-1,560,561,562,-1,562,563,560,-1,564,565,566,-1,563,567,568,-1,569,570,571,-1,572,573,574,-1,575,576,577,-1,578,579,580,-1,581,582,583,-1,584,514,585,-1,586,587,588,-1,589,590,591,-1,592,593,594,-1,595,596,597,-1,598,599,600,-1,601,602,596,-1,603,604,600,-1,605,606,607,-1,577,608,609,-1,610,611,612,-1,613,614,615,-1,616,617,618,-1,619,620,587,-1,620,588,587,-1,603,621,622,-1,623,624,625,-1,626,613,627,-1,621,628,629,-1,630,631,632,-1,633,634,635,-1,18,636,637,-1,638,639,640,-1,638,641,642,-1,643,644,645,-1,646,647,25,-1,642,648,649,-1,596,650,651,-1,652,653,654,-1,9,11,648,-1,633,635,648,-1,655,656,624,-1,657,658,659,-1,637,660,661,-1,662,661,658,-1,663,664,52,-1,665,593,666,-1,667,668,669,-1,670,671,672,-1,673,674,675,-1,676,677,678,-1,679,680,681,-1,682,683,684,-1,678,685,686,-1,687,688,689,-1,690,691,692,-1,693,673,694,-1,679,695,696,-1,697,698,699,-1,700,701,702,-1,672,703,704,-1,705,706,707,-1,708,709,710,-1,711,707,712,-1,713,402,714,-1,713,715,402,-1,716,717,407,-1,718,704,719,-1,712,707,716,-1,542,720,721,-1,671,722,703,-1,723,724,725,-1,726,727,728,-1,412,729,705,-1,730,395,724,-1,731,413,732,-1,733,734,735,-1,736,737,421,-1,738,739,423,-1,413,731,740,-1,741,742,743,-1,744,736,745,-1,746,747,748,-1,749,750,751,-1,750,752,753,-1,754,755,756,-1,739,757,415,-1,396,758,419,-1,422,414,759,-1,760,761,762,-1,704,703,730,-1,763,756,764,-1,727,393,765,-1,766,767,768,-1,769,770,771,-1,741,744,772,-1,773,774,770,-1,775,776,777,-1,778,700,779,-1,780,781,782,-1,783,784,781,-1,785,786,787,-1,788,789,790,-1,791,787,792,-1,793,794,795,-1,796,797,749,-1,672,798,544,-1,799,771,770,-1,768,799,800,-1,801,802,803,-1,761,767,762,-1,804,805,806,-1,807,292,294,-1,808,809,810,-1,811,812,813,-1,622,814,815,-1,816,817,818,-1,819,820,821,-1,822,823,824,-1,825,822,820,-1,826,827,828,-1,829,111,100,-1,830,831,828,-1,101,100,832,-1,833,834,835,-1,836,117,110,-1,114,319,144,-1,837,823,822,-1,837,838,830,-1,605,568,839,-1,840,841,842,-1,843,844,845,-1,846,813,847,-1,95,848,93,-1,849,551,850,-1,841,840,851,-1,839,852,853,-1,854,813,812,-1,705,729,749,-1,855,781,780,-1,752,751,753,-1,856,857,858,-1,859,102,808,-1,85,860,861,-1,862,863,864,-1,865,866,863,-1,865,807,867,-1,868,869,870,-1,871,54,46,-1,54,872,818,-1,679,873,682,-1,758,414,874,-1,875,876,721,-1,414,877,878,-1,879,880,667,-1,684,683,881,-1,549,882,883,-1,884,826,885,-1,58,886,14,-1,12,887,888,-1,889,647,890,-1,631,891,892,-1,893,10,654,-1,547,894,895,-1,896,619,897,-1,505,585,506,-1,496,898,899,-1,900,901,902,-1,539,477,476,-1,275,903,904,-1,905,906,907,-1,908,909,907,-1,910,518,905,-1,911,520,525,-1,912,913,914,-1,915,916,277,-1,917,918,919,-1,920,921,922,-1,923,924,193,-1,925,926,927,-1,928,929,930,-1,931,932,933,-1,934,935,201,-1,210,936,937,-1,938,939,940,-1,941,942,943,-1,944,945,946,-1,947,241,948,-1,949,950,951,-1,952,953,954,-1,955,956,957,-1,958,959,960,-1,961,962,963,-1,964,965,966,-1,967,968,969,-1,970,971,972,-1,973,974,975,-1,976,977,978,-1,979,980,981,-1,982,983,984,-1,985,986,987,-1,988,989,990,-1,991,992,993,-1,963,994,995,-1,996,969,997,-1,998,999,1000,-1,1001,1002,1003,-1,1004,1005,1006,-1,1007,1008,1009,-1,1010,978,952,-1,1011,1012,1013,-1,1014,1015,1016,-1,1017,1018,1019,-1,1020,1021,1022,-1,1023,1024,998,-1,972,971,1025,-1,1026,1027,1028,-1,1029,1030,1031,-1,1032,1033,1034,-1,1021,1020,1035,-1,1036,1037,1038,-1,986,1039,1040,-1,1041,1042,1043,-1,1044,1045,1046,-1,1037,1047,1048,-1,1049,1050,1051,-1,1052,1053,1054,-1,1055,1056,1039,-1,1057,1058,1059,-1,1060,1061,1062,-1,1063,1001,1003,-1,1064,1065,1066,-1,1067,1068,1013,-1,1045,1069,1070,-1,1071,1072,1047,-1,1073,1074,1075,-1,959,961,1076,-1,1077,1078,1079,-1,1080,1081,1058,-1,1082,1083,1084,-1,1006,1085,1086,-1,1087,1088,1089,-1,1090,1091,1092,-1,1078,1093,1094,-1,1095,1096,1097,-1,1089,1098,1099,-1,1100,1101,1102,-1,1103,1104,1105,-1,1106,1107,1108,-1,1109,1110,1111,-1,1112,1113,1114,-1,1115,1116,1117,-1,1118,928,1119,-1,1120,1121,1122,-1,1123,1124,1125,-1,1126,1127,1128,-1,1129,1130,1131,-1,1132,1133,1134,-1,1135,1136,1137,-1,1138,1139,1135,-1,1140,1141,1142,-1,1143,1144,1145,-1,1136,1146,1128,-1,1147,1148,1149,-1,1150,1151,1152,-1,1153,1154,1155,-1,1156,1157,1158,-1,1159,1160,1161,-1,1162,1163,1164,-1,1165,1166,1167,-1,1168,1169,1170,-1,1171,1172,1173,-1,1174,1175,1172,-1,1176,1177,1178,-1,1179,1180,1181,-1,1182,1183,1184,-1,1185,1158,1153,-1,1186,1187,1188,-1,1189,1190,1177,-1,1170,1191,1192,-1,1162,1193,1194,-1,1195,1132,1196,-1,1197,1198,1130,-1,1199,1200,1201,-1,1202,1203,1204,-1,1205,1206,1207,-1,1208,1209,1210,-1,1211,1212,1213,-1,1214,1165,1215,-1,1164,1193,1162,-1,1146,1139,1124,-1,1216,1203,1202,-1,1217,1218,1208,-1,1219,1220,1126,-1,1221,1190,1222,-1,1223,1224,1225,-1,1226,1227,1228,-1,1229,1230,1231,-1,1232,1233,1234,-1,1235,1198,1180,-1,1236,1237,1238,-1,1239,1199,1201,-1,1137,1128,1240,-1,1241,1242,1243,-1,1208,1244,1209,-1,1245,1246,1247,-1,1248,1249,1250,-1,1251,1252,1253,-1,1254,1255,1256,-1,1257,1258,1259,-1,1260,1261,1262,-1,1263,1264,1265,-1,1266,1267,1268,-1,1269,1270,1271,-1,1272,1273,1274,-1,1275,1276,1277,-1,1278,1279,1280,-1,1281,1282,1283,-1,1284,1285,1286,-1,1287,1288,1289,-1,1290,1291,1292,-1,1293,1294,1295,-1,1296,1297,1298,-1,1299,1265,1300,-1,1301,1302,1303,-1,1304,1305,1306,-1,1307,1308,1309,-1,1310,1248,1250,-1,1260,1311,1312,-1,1310,1313,1314,-1,1315,1316,1317,-1,1318,1319,1320,-1,1321,1322,1323,-1,1324,1325,1326,-1,1315,1327,1328,-1,1329,1330,1331,-1,1292,1332,1333,-1,1334,1335,1336,-1,1337,1338,1339,-1,1340,1310,1341,-1,1342,1281,1286,-1,1343,1344,1282,-1,1286,1285,1345,-1,1346,1347,1348,-1,1294,1349,1350,-1,1351,1352,1353,-1,1283,1354,1246,-1,1355,1356,1357,-1,1358,1359,1360,-1,1321,1361,1322,-1,1362,1363,1364,-1,1365,1366,1367,-1,1368,1369,1370,-1,1371,1372,1373,-1,1374,1375,1376,-1,1377,1378,1379,-1,1380,1381,1382,-1,1383,1384,1385,-1,1386,1387,1388,-1,1389,1390,1391,-1,1392,1393,1394,-1,1395,1396,1397,-1,1398,1399,1400,-1,1401,1402,1403,-1,1404,1405,1406,-1,1407,1408,1409,-1,1410,1411,1412,-1,1413,1414,1415,-1,1403,1402,1416,-1,1417,1418,1419,-1,1416,1402,1420,-1,1421,1422,1423,-1,1424,1425,1416,-1,1426,1427,1428,-1,1429,1430,1431,-1,1428,1432,1433,-1,1434,1435,1424,-1,1436,1437,1438,-1,1439,1440,1441,-1,1442,1443,1414,-1,1444,1445,1446,-1,1447,1448,1449,-1,1450,1451,1452,-1,1453,1454,1455,-1,1456,1457,1458,-1,1459,1460,1461,-1,1462,1461,1463,-1,1464,1465,1466,-1,1467,1468,1469,-1,1470,1471,1472,-1,1473,1474,1475,-1,1476,1477,1478,-1,1479,1480,1481,-1,1482,1483,1484,-1,1471,1485,1486,-1,1487,1488,1489,-1,1490,1491,1492,-1,1493,1494,1495,-1,1496,1497,1498,-1,1499,1500,1501,-1,1500,1502,1501,-1,1467,1503,1504,-1,1505,1506,1507,-1,1508,1505,1509,-1,1510,1511,1512,-1,1513,1514,1515,-1,1516,1498,1469,-1,1517,1518,1519,-1,1477,1520,1478,-1,1521,1522,1523,-1,1467,1524,1495,-1,1525,1526,1507,-1,1527,1482,1528,-1,1529,1472,1530,-1,1531,1532,1533,-1,1534,1535,1536,-1,1537,1538,1490,-1,1539,1540,1541,-1,1542,1543,1544,-1,1545,1542,1546,-1,1547,1548,1549,-1,1550,1551,1552,-1,1553,1554,1555,-1,1543,1545,1556,-1,1557,1558,1559,-1,1560,1561,1562,-1,1563,1564,1565,-1,1566,1567,1568,-1,1569,1570,1571,-1,1572,1573,1574,-1,1574,1575,1576,-1,1577,1571,1578,-1,1579,1580,1581,-1,1582,1583,1584,-1,1585,1586,1587,-1,1587,1581,1588,-1,1589,1590,1580,-1,1580,1591,1589,-1,1586,1592,1593,-1,1591,1579,1584,-1,1569,1571,1594,-1,1585,1595,1596,-1,1597,1598,1599,-1,1599,1600,1597,-1,1601,1602,1603,-1,1604,1605,1606,-1,1607,1608,1609,-1,1610,1611,1612,-1,1613,1614,1615,-1,1616,1617,1618,-1,1619,1620,1600,-1,1621,1622,1623,-1,1624,1625,1626,-1,1627,1628,1629,-1,1600,1620,1630,-1,1631,1632,1633,-1,1634,1635,1636,-1,1637,1638,1639,-1,1640,1641,1642,-1,1643,1644,1645,-1,1626,1625,1646,-1,1647,1648,1624,-1,1649,1650,1651,-1,1652,1653,1654,-1,1655,1656,1657,-1,1658,1659,1660,-1,1661,1662,1663,-1,1663,1664,1661,-1,1665,1666,1667,-1,1668,1669,1614,-1,1614,1613,1668,-1,1670,1671,1672,-1,1673,1674,1675,-1,1676,1677,1678,-1,1679,1680,1681,-1,1682,1683,1684,-1,1685,1686,1687,-1,1685,1688,1686,-1,1689,1690,1691,-1,1692,1693,1694,-1,1695,1696,1697,-1,1698,1610,1699,-1,1700,1701,1702,-1,1703,1704,1705,-1,1706,1703,1705,-1,1707,1708,1709,-1,1710,1711,1706,-1,1597,1712,1713,-1,1709,1714,1715,-1,1716,1657,1656,-1,1717,1718,1672,-1,1719,1720,1721,-1,1722,1723,1724,-1,1725,1726,1727,-1,1728,1729,1730,-1,1663,1731,1732,-1,1658,1733,1734,-1,1735,1736,1737,-1,1738,1739,1740,-1,1741,1742,1743,-1,1744,1745,1743,-1,1746,1742,1741,-1,1747,1740,1748,-1,1749,1750,1751,-1,1752,1753,1754,-1,1755,1756,1731,-1,1725,1751,1750,-1,1753,1757,1758,-1,1759,1760,1761,-1,1759,1762,1760,-1,1763,1764,1765,-1,1736,1766,1767,-1,1732,1768,1769,-1,1770,1771,1772,-1,1773,1774,1775,-1,1776,1777,1767,-1,1778,1737,1779,-1,1778,1779,1780,-1,1737,1736,1781,-1,1717,1782,1783,-1,1784,1785,1758,-1,1786,1787,1780,-1,1788,1789,1790,-1,1775,1791,1792,-1,1793,1785,1794,-1,1795,1796,1632,-1,1636,1797,1798,-1,1763,1765,1799,-1,1800,1801,1802,-1,1803,1804,1805,-1,1607,1806,1807,-1,1808,1809,1810,-1,1810,1800,1811,-1,1618,1617,1812,-1,1630,1813,1814,-1,1815,1816,1813,-1,1817,1818,1819,-1,1820,1821,1822,-1,1823,1824,1825,-1,1677,1826,1678,-1,1827,1828,1829,-1,1682,1830,1831,-1,1832,1833,1834,-1,1835,1836,1837,-1,1838,1839,1840,-1,1679,1841,1842,-1,1707,1843,1844,-1,1677,1845,1846,-1,1847,1848,1849,-1,1850,1851,1852,-1,1853,1825,1854,-1,1855,1856,1857,-1,1577,1858,1859,-1,1860,1861,1848,-1,1565,1862,1863,-1,1560,1864,1863,-1,1865,1866,1867,-1,1868,1559,1869,-1,1870,1871,1872,-1,1648,1873,1874,-1,1875,1872,1876,-1,1877,1712,1597,-1,1878,1879,1880,-1,1872,1704,1876,-1,1558,1881,1559,-1,1858,1577,1882,-1,1883,1884,1629,-1,1562,1561,1566,-1,1885,1623,1886,-1,1887,1622,1621,-1,1887,1674,1888,-1,1825,1853,1889,-1,1803,1890,1889,-1,1891,1892,1893,-1,1805,1894,1803,-1,1763,1799,1895,-1,1896,1841,1897,-1,1898,1899,1759,-1,1898,1900,1901,-1,1902,1801,1903,-1,1685,1904,1691,-1,1685,1702,1904,-1,1905,1786,1906,-1,1905,1644,1643,-1,1787,1907,1739,-1,1747,1748,1908,-1,1909,1694,1691,-1,1642,1641,1910,-1,1692,1694,1910,-1,1910,1747,1642,-1,1740,1739,1907,-1,1905,1911,1912,-1,1634,1913,1906,-1,1914,1915,1916,-1,1741,1917,1746,-1,1719,1918,1723,-1,1919,1920,1701,-1,1921,1922,1923,-1,1838,1924,1925,-1,1924,1926,1841,-1,1927,1838,1925,-1,1805,1928,1894,-1,1893,1892,1637,-1,1888,1929,1887,-1,1930,1847,1931,-1,1932,1711,1933,-1,1599,1598,1879,-1,1875,1876,1934,-1,1870,1875,1647,-1,1874,1873,1866,-1,1648,1875,1873,-1,1935,1936,1710,-1,1765,1764,1653,-1,1784,1895,1799,-1,1937,1900,1761,-1,1900,1898,1761,-1,1868,1883,1865,-1,1938,1562,1568,-1,1856,1848,1847,-1,1857,1939,1940,-1,1931,1847,1849,-1,1856,1930,1852,-1,1924,1896,1941,-1,1924,1942,1925,-1,1943,1834,1944,-1,1830,1850,1931,-1,1830,1945,1850,-1,1832,1834,1943,-1,1682,1831,1946,-1,1947,1948,1949,-1,1950,1817,1819,-1,1951,1952,1630,-1,1818,1602,1953,-1,1954,1813,1630,-1,1818,1618,1955,-1,1956,1814,1813,-1,1957,1808,1810,-1,1957,1958,1959,-1,1951,1960,1961,-1,1810,1809,1962,-1,1963,1928,1697,-1,1610,1964,1965,-1,1805,1804,1697,-1,1801,1800,1962,-1,1966,1967,1937,-1,1968,1652,1969,-1,1730,1755,1970,-1,1633,1971,1651,-1,1730,1750,1752,-1,1793,1794,1792,-1,1911,1906,1796,-1,1797,1772,1771,-1,1792,1770,1972,-1,1973,1798,1797,-1,1797,1635,1974,-1,1787,1786,1905,-1,1895,1758,1975,-1,1778,1780,1739,-1,1756,1791,1774,-1,1781,1976,1779,-1,1737,1778,1739,-1,1769,1977,1734,-1,1736,1734,1766,-1,1976,1767,1777,-1,1790,1784,1788,-1,1754,1756,1755,-1,1978,1918,1760,-1,1918,1979,1760,-1,1717,1742,1746,-1,1980,1904,1981,-1,1979,1982,1718,-1,1910,1694,1909,-1,1745,1983,1741,-1,1984,1716,1745,-1,1985,1740,1986,-1,1987,1739,1738,-1,1988,1725,1989,-1,1720,1723,1722,-1,1990,1742,1717,-1,1991,1744,1743,-1,1657,1716,1984,-1,1992,1993,1909,-1,1704,1598,1557,-1,1994,1995,1996,-1,1705,1935,1706,-1,1997,1709,1996,-1,1998,1999,1853,-1,1804,1999,1998,-1,1686,2000,2001,-1,2002,1689,2003,-1,1688,2004,1916,-1,1914,2000,1686,-1,1702,1685,1687,-1,1684,1683,2005,-1,1941,1896,2006,-1,1828,1827,1897,-1,2007,1826,1846,-1,1826,2008,1695,-1,1948,2009,2010,-1,1738,580,579,-1,1727,1729,2011,-1,1570,1569,1592,-1,1665,1667,2012,-1,1728,2013,2014,-1,2015,2016,1991,-1,580,1738,1985,-1,2017,2018,1639,-1,1673,2019,2020,-1,1628,1627,1912,-1,1626,1646,1870,-1,2021,1653,1652,-1,1969,2022,1649,-1,1871,2023,1650,-1,1692,2024,2020,-1,1627,2025,1644,-1,1912,1911,2026,-1,2020,1637,1639,-1,1780,1974,1634,-1,2023,1631,1651,-1,1648,1629,1628,-1,1616,2027,1822,-1,2012,2028,1676,-1,1665,1676,1678,-1,1614,1667,2029,-1,1964,1610,1612,-1,1608,2030,1957,-1,1806,1607,1963,-1,2031,1695,2008,-1,1605,2031,2007,-1,2032,2033,2034,-1,2035,1838,2036,-1,2037,2038,1582,-1,1583,2039,1589,-1,1574,1576,1588,-1,2040,2041,1585,-1,1587,1593,1579,-1,2042,1681,1680,-1,1583,1589,1591,-1,1586,1585,1596,-1,1595,2009,1564,-1,2009,1595,2041,-1,2043,2044,1576,-1,2038,1940,2039,-1,1571,2045,2046,-1,1882,1577,1578,-1,1886,1862,2009,-1,1567,1882,1938,-1,1938,1568,1567,-1,1564,1596,1595,-1,2047,1565,1864,-1,2048,2049,1881,-1,1557,2048,1558,-1,2050,2051,1555,-1,1542,1544,1552,-1,2052,2053,2054,-1,2055,2056,2057,-1,2058,2059,2060,-1,1487,2061,2062,-1,2063,2064,1494,-1,1519,2065,2066,-1,2067,1536,2068,-1,2069,2070,1466,-1,2071,2072,2073,-1,1472,1471,2074,-1,2075,1496,1498,-1,2072,1518,2076,-1,2069,1503,2077,-1,2066,2065,2078,-1,1501,1502,2079,-1,1497,1493,1524,-1,2080,2081,2064,-1,2082,2083,2084,-1,2085,2086,2087,-1,2079,2088,1501,-1,1484,1483,2089,-1,1491,2090,1482,-1,1516,2091,2092,-1,2093,1523,2094,-1,2060,2095,2058,-1,1453,1473,2096,-1,1496,2075,2078,-1,2069,2097,2098,-1,2097,2099,2098,-1,2100,2101,2102,-1,1508,1465,1464,-1,1534,2103,2104,-1,2105,1463,2106,-1,2107,2108,1458,-1,2109,2110,2111,-1,1462,2112,2113,-1,2114,2115,2104,-1,1477,1476,2116,-1,2117,2118,2119,-1,1411,1410,1432,-1,1404,1406,2120,-1,2121,2122,2123,-1,1409,2124,1407,-1,1403,1427,2125,-1,2126,2127,1442,-1,2128,2129,2130,-1,1429,2131,2132,-1,2133,2134,1422,-1,2135,1437,2136,-1,1428,1424,2137,-1,2138,2139,2140,-1,2141,1420,2142,-1,1426,2143,2125,-1,2125,1427,1426,-1,2144,1408,1407,-1,2145,1405,1404,-1,2146,2147,2148,-1,2149,2139,1403,-1,2150,2122,2151,-1,2152,1394,1393,-1,2153,2154,2155,-1,2156,2157,2158,-1,1376,2155,2159,-1,2160,2161,1370,-1,1367,2162,2163,-1,2164,1361,1321,-1,2165,2166,2167,-1,2168,2169,2170,-1,1353,1352,2171,-1,2172,1264,2173,-1,2174,2175,2176,-1,2177,2178,2179,-1,2180,1246,2181,-1,2181,2182,2180,-1,2183,1341,2177,-1,2184,2185,1276,-1,2186,2187,2188,-1,2168,2170,1324,-1,2189,2190,2191,-1,2192,2193,2191,-1,1328,2194,1315,-1,1254,1320,2195,-1,2196,2197,2198,-1,1261,1348,1347,-1,2199,1317,1316,-1,1314,1313,2199,-1,2200,1257,2178,-1,1318,1256,2201,-1,2178,1257,1311,-1,2202,2192,2191,-1,2203,1333,1331,-1,1295,2204,2205,-1,1282,1344,2206,-1,1280,1279,1275,-1,2207,2208,2209,-1,1291,2210,1292,-1,2211,2212,2213,-1,2214,2215,2216,-1,2217,2211,1307,-1,2218,1346,2219,-1,2220,2221,2222,-1,2221,2223,2222,-1,1303,2224,2225,-1,2226,2227,2198,-1,1340,2228,2198,-1,1259,2229,2230,-1,2181,2231,1284,-1,1302,1301,2232,-1,2233,2234,2235,-1,1156,1158,1185,-1,1120,2236,1144,-1,1188,2237,1200,-1,1188,2238,2237,-1,2239,2240,2241,-1,2242,2243,1230,-1,1226,2244,1229,-1,1227,1231,2245,-1,2246,1221,1222,-1,1191,1225,1224,-1,1210,1153,1217,-1,1118,1126,1220,-1,2247,1192,1191,-1,2243,2248,1230,-1,2249,1211,1218,-1,2250,1207,2251,-1,1186,1216,2252,-1,1130,1198,1235,-1,2253,2254,2255,-1,1135,2256,2257,-1,2258,2259,2260,-1,1169,1223,1225,-1,1148,1147,1152,-1,1180,1179,2261,-1,1174,1214,1215,-1,1192,2262,1170,-1,2263,1154,1162,-1,2264,2265,2266,-1,1164,1157,2267,-1,1157,1163,1153,-1,2268,1150,1147,-1,1152,1151,2269,-1,2270,1151,1150,-1,2271,2272,2273,-1,1125,1138,1142,-1,2274,2275,1143,-1,1139,1136,1135,-1,2255,1133,1132,-1,1126,1146,1123,-1,2276,2277,2278,-1,2279,2280,2281,-1,2282,1203,1216,-1,2283,2284,2285,-1,1117,2286,2287,-1,2288,2289,2290,-1,2291,2292,2285,-1,2293,2291,1097,-1,1077,1100,1078,-1,2294,2295,2296,-1,2297,1098,1089,-1,2298,1095,1083,-1,1058,2299,2300,-1,2301,2302,2303,-1,1078,1094,2304,-1,1069,2305,1071,-1,1055,2306,1056,-1,1075,1074,1064,-1,1059,1061,1060,-1,2307,1060,1062,-1,2308,2309,1057,-1,2310,1064,1055,-1,1052,2311,1075,-1,1049,2312,1054,-1,1048,1051,1050,-1,2313,2314,1014,-1,1043,989,988,-1,2315,2310,2316,-1,2317,1052,2318,-1,2319,1038,1037,-1,993,992,1016,-1,2320,1009,969,-1,2321,2289,2322,-1,993,2323,2324,-1,2325,1043,2326,-1,1046,992,991,-1,958,1067,2327,-1,1000,999,1001,-1,2328,2329,2330,-1,962,994,963,-1,2331,1044,1046,-1,981,2332,2333,-1,2334,2335,2336,-1,2334,2337,2335,-1,2338,1022,973,-1,2339,989,2325,-1,2340,2289,2321,-1,1002,2341,2342,-1,1009,1008,2343,-1,969,968,2344,-1,2345,966,965,-1,971,970,968,-1,962,1041,2346,-1,960,959,2347,-1,2348,948,2349,-1,2350,245,244,-1,2351,2352,2353,-1,947,242,241,-1,2354,2355,2356,-1,2357,2358,2359,-1,2360,2361,2362,-1,2363,2364,2356,-1,209,427,426,-1,934,1361,2365,-1,2366,2367,2368,-1,2369,2370,2371,-1,2372,2373,2374,-1,2375,2376,2377,-1,2378,919,918,-1,2379,2380,2381,-1,2382,2383,2384,-1,2385,2381,2380,-1,429,2386,2387,-1,168,278,277,-1,2388,2389,2390,-1,912,914,2391,-1,519,525,520,-1,2392,914,2393,-1,907,906,908,-1,2394,2390,903,-1,501,900,2395,-1,523,506,585,-1,514,582,882,-1,896,2396,2397,-1,2398,2399,2400,-1,2401,2402,2403,-1,889,632,631,-1,884,2404,25,-1,2405,458,2406,-1,2407,2408,2409,-1,2404,885,55,-1,2410,2411,2412,-1,2413,2410,2414,-1,2414,2415,2413,-1,2416,2417,581,-1,550,2418,879,-1,2419,877,414,-1,415,757,2420,-1,2421,2422,815,-1,2421,606,2422,-1,816,818,872,-1,2423,48,47,-1,668,2424,870,-1,869,2425,870,-1,869,2426,2427,-1,133,867,807,-1,136,287,137,-1,866,867,2428,-1,719,715,713,-1,102,860,85,-1,800,744,745,-1,2429,806,2430,-1,775,777,2431,-1,789,788,2432,-1,860,103,2433,-1,813,2434,2435,-1,568,567,852,-1,813,846,811,-1,103,2436,2437,-1,2438,2439,123,-1,568,2440,2441,-1,568,607,824,-1,2440,823,837,-1,2442,843,129,-1,835,107,836,-1,2443,106,2444,-1,111,119,2445,-1,468,2446,457,-1,2447,827,2448,-1,2449,113,111,-1,2450,2451,2443,-1,2452,2453,819,-1,822,664,663,-1,824,607,2454,-1,819,2455,21,-1,39,2456,38,-1,2457,16,817,-1,2458,779,2459,-1,2460,2461,2462,-1,812,809,2463,-1,2464,136,2465,-1,865,863,804,-1,2466,856,2467,-1,702,2468,2469,-1,776,803,771,-1,774,742,2470,-1,777,792,2431,-1,2471,2459,797,-1,792,2472,2473,-1,2474,793,2475,-1,786,794,2431,-1,2476,2477,2478,-1,2479,2480,2481,-1,795,796,2475,-1,2432,2482,2460,-1,766,2483,745,-1,769,771,803,-1,766,768,2483,-1,395,394,724,-1,2484,2485,2486,-1,396,2487,758,-1,2488,755,2489,-1,2490,775,2474,-1,2491,740,751,-1,2492,749,751,-1,2493,2494,2495,-1,746,2496,423,-1,2497,420,2498,-1,743,2499,417,-1,733,763,2500,-1,754,735,2501,-1,750,729,412,-1,2502,731,801,-1,725,403,723,-1,2503,705,711,-1,725,724,394,-1,722,395,703,-1,723,2504,719,-1,2505,2506,409,-1,2507,2505,399,-1,403,402,2504,-1,402,715,2504,-1,2508,716,707,-1,707,713,2508,-1,671,393,722,-1,2509,2510,2511,-1,863,2512,789,-1,798,2513,2514,-1,696,2515,2516,-1,2517,720,542,-1,692,693,2518,-1,2519,687,4,-1,692,6,2520,-1,677,2521,684,-1,2522,2523,2524,-1,2525,2526,2527,-1,697,541,698,-1,542,697,2528,-1,674,673,693,-1,683,682,2529,-1,589,591,2530,-1,817,816,2409,-1,607,657,2454,-1,2421,607,606,-1,624,814,622,-1,639,2531,640,-1,2532,27,2407,-1,2533,2534,660,-1,598,651,650,-1,10,9,652,-1,2535,2536,2401,-1,626,2537,629,-1,647,889,25,-1,654,2538,2539,-1,9,641,2540,-1,2541,2542,634,-1,637,640,18,-1,2543,634,633,-1,10,893,2543,-1,631,630,2543,-1,628,2544,626,-1,626,627,616,-1,2545,655,623,-1,2545,588,620,-1,2546,603,622,-1,586,588,2537,-1,2547,2548,614,-1,599,2544,628,-1,2544,2547,614,-1,578,587,586,-1,626,2544,613,-1,608,577,576,-1,618,2549,2550,-1,2551,2552,2553,-1,624,622,625,-1,2547,599,598,-1,2554,594,593,-1,2546,2555,597,-1,2556,883,2557,-1,571,570,2558,-1,2559,583,2560,-1,584,2561,582,-1,578,575,579,-1,610,2562,1662,-1,602,601,2011,-1,2563,2564,2559,-1,2565,2566,2567,-1,2568,879,669,-1,670,680,2569,-1,546,545,681,-1,2570,498,536,-1,536,535,2570,-1,532,2571,533,-1,2572,2573,529,-1,478,526,2574,-1,2570,535,2575,-1,914,2392,2576,-1,159,2577,160,-1,512,2578,2579,-1,2578,516,2579,-1,2580,2415,2414,-1,509,2413,2581,-1,2582,906,905,-1,910,909,2583,-1,2584,122,503,-1,2573,2585,2586,-1,2587,2588,2589,-1,2590,495,2591,-1,915,2389,916,-1,2592,486,485,-1,2593,2594,477,-1,2594,482,477,-1,472,486,2592,-1,2595,487,489,-1,2596,2597,2598,-1,2598,460,453,-1,271,270,156,-1,467,2596,2599,-1,456,2600,2601,-1,2405,528,2602,-1,458,2405,459,-1,466,463,2603,-1,468,2599,2604,-1,2599,2605,2604,-1,2606,2607,2608,-1,2609,2610,2611,-1,446,2612,154,-1,2613,2614,326,-1,317,228,227,-1,2615,2616,2617,-1,438,2618,2619,-1,2620,437,323,-1,2621,286,2622,-1,2623,2624,231,-1,2625,420,422,-1,2626,419,2627,-1,732,2489,755,-1,424,415,878,-1,2487,2628,758,-1,2629,407,409,-1,405,406,408,-1,402,401,400,-1,725,404,403,-1,396,756,755,-1,404,725,2630,-1,327,2631,328,-1,350,289,2632,-1,2633,2634,2635,-1,2636,2637,297,-1,310,450,2638,-1,177,176,298,-1,372,378,2639,-1,381,2640,367,-1,2641,2642,2643,-1,302,2644,2645,-1,2646,2647,303,-1,382,2648,383,-1,366,362,2649,-1,359,2577,304,-1,2650,2651,389,-1,2652,2653,2654,-1,188,2655,2656,-1,2657,341,340,-1,2658,222,2659,-1,2660,339,221,-1,214,2661,428,-1,432,431,2662,-1,235,2663,236,-1,258,2664,338,-1,333,256,2665,-1,259,2666,2667,-1,2668,130,2669,-1,2670,937,936,-1,2671,2672,2673,-1,247,254,2614,-1,323,438,2674,-1,2675,324,322,-1,2676,2677,2678,-1,2614,2613,318,-1,2679,264,2680,-1,2681,2682,269,-1,315,257,259,-1,2683,2684,2685,-1,243,2686,2687,-1,330,244,2688,-1,240,2689,2662,-1,195,355,188,-1,448,309,308,-1,2654,301,295,-1,2690,390,2691,-1,2692,298,176,-1,137,287,357,-1,223,436,2693,-1,232,2694,2695,-1,2696,2623,2697,-1,171,2698,2699,-1,2700,903,2701,-1,2702,273,2703,-1,2390,2394,2704,-1,2700,2394,903,-1,2615,2705,2706,-1,2707,2708,2679,-1,2709,2710,2664,-1,2710,2709,2711,-1,2712,439,334,-1,2713,2615,442,-1,2679,154,153,-1,268,258,257,-1,250,320,324,-1,324,320,322,-1,236,2714,2715,-1,2716,948,2717,-1,2718,2688,244,-1,2689,238,2719,-1,945,2686,243,-1,2720,2721,2668,-1,2722,2620,2723,-1,223,2724,2725,-1,437,2618,438,-1,2726,2727,2728,-1,2729,2730,2731,-1,427,2732,212,-1,212,211,427,-1,209,936,210,-1,932,2606,2733,-1,340,2734,2735,-1,935,2736,2737,-1,930,2738,2739,-1,308,2374,2373,-1,2740,2741,930,-1,2691,927,926,-1,2742,2743,2744,-1,2745,296,181,-1,161,359,174,-1,2746,2747,2748,-1,2749,470,469,-1,2750,281,2388,-1,2386,2702,2703,-1,2751,2752,2753,-1,163,162,160,-1,156,447,157,-1,117,154,2678,-1,118,2678,2677,-1,147,2677,148,-1,143,861,860,-1,2672,329,2754,-1,2465,136,135,-1,137,2755,292,-1,384,2756,2757,-1,369,2757,2758,-1,2759,2760,2761,-1,2762,2635,139,-1,2763,2764,2765,-1,2766,2652,2767,-1,113,105,834,-1,107,2768,108,-1,106,105,2444,-1,2447,99,2769,-1,2447,2770,99,-1,2436,93,848,-1,466,829,2448,-1,99,829,100,-1,2447,2771,827,-1,98,827,96,-1,2772,123,2439,-1,91,90,2773,-1,2774,2754,86,-1,2775,2776,2393,-1,2777,171,2699,-1,2778,2699,2779,-1,2780,2781,2782,-1,2783,2784,65,-1,70,22,71,-1,76,2785,33,-1,80,2786,2787,-1,69,2788,2789,-1,22,21,2787,-1,2789,2788,2790,-1,2791,2792,50,-1,58,57,73,-1,2788,2791,2790,-1,63,2784,2789,-1,2793,2794,2533,-1,2795,78,2796,-1,79,2781,2797,-1,2453,825,820,-1,662,638,640,-1,2798,2423,51,-1,2423,68,44,-1,2454,659,53,-1,16,15,2791,-1,2799,817,49,-1,43,46,48,-1,2800,74,2801,-1,2455,2801,82,-1,2802,2803,2456,-1,72,32,34,-1,2795,30,28,-1,2780,2804,2805,-1,26,2404,56,-1,636,2806,2807,-1,2808,20,887,-1,2809,31,2790,-1,2409,2794,2810,-1,24,26,12,-1,887,20,2811,-1,644,2542,645,-1,7,2,8,-1,2520,2812,2813,-1,4,2813,5,-1,2814,2815,1,-1,2001,2816,2020,-1,2020,2817,2001,-1,2814,3,2815,-1,4,689,2813,-1,2520,6,2812,-1,7,0,2,-1,2811,2531,2818,-1,12,888,2819,-1,24,12,2819,-1,2810,2532,2407,-1,636,2807,2533,-1,2455,81,2787,-1,2780,2805,2781,-1,30,2796,31,-1,28,2782,2795,-1,2820,2782,28,-1,72,80,32,-1,2797,77,79,-1,82,81,2455,-1,2821,2804,40,-1,43,48,44,-1,2799,49,47,-1,16,2791,50,-1,52,2454,53,-1,48,2423,44,-1,2798,51,2792,-1,662,640,637,-1,820,819,2453,-1,23,58,21,-1,2781,2805,2797,-1,2796,30,2795,-1,2796,78,61,-1,2533,2807,2793,-1,63,65,2784,-1,62,64,63,-1,67,2789,2784,-1,2798,68,2423,-1,2791,2788,2792,-1,2790,63,2789,-1,21,2455,2787,-1,2789,67,69,-1,2787,81,80,-1,33,2822,76,-1,70,23,22,-1,2783,66,2784,-1,2781,2795,2782,-1,2778,2823,2699,-1,2775,2393,2752,-1,85,84,102,-1,2773,2824,91,-1,2772,2825,123,-1,114,116,2769,-1,99,2770,829,-1,2436,848,89,-1,107,835,2768,-1,832,111,2445,-1,100,111,832,-1,110,119,111,-1,2763,2765,2464,-1,2826,2827,2763,-1,2759,2761,2828,-1,377,2639,378,-1,2829,134,2830,-1,376,2831,377,-1,369,2832,2757,-1,384,383,2756,-1,2425,133,2833,-1,292,135,137,-1,2767,140,2834,-1,2835,2836,2837,-1,145,149,146,-1,145,2838,149,-1,147,118,2677,-1,118,117,2678,-1,117,836,154,-1,156,270,447,-1,2839,162,161,-1,2840,2841,2842,-1,2843,2844,2845,-1,2703,2387,2386,-1,166,165,2846,-1,2750,2388,2847,-1,2848,916,2849,-1,2850,2851,2852,-1,2749,2853,470,-1,359,163,2577,-1,163,160,2577,-1,161,163,359,-1,176,175,2854,-1,188,2656,189,-1,2690,2691,926,-1,2739,2740,930,-1,306,308,2373,-1,2737,201,935,-1,2734,2855,2735,-1,2736,2656,2737,-1,201,2737,354,-1,2728,2856,2726,-1,436,223,2725,-1,2857,318,2613,-1,2858,280,434,-1,2694,232,127,-1,235,2696,2859,-1,2719,432,2689,-1,243,2718,244,-1,236,2715,234,-1,2688,2718,2860,-1,2861,2862,2681,-1,316,269,257,-1,2713,442,2863,-1,2712,334,2864,-1,2711,336,2710,-1,2707,2679,2865,-1,2706,2616,2615,-1,2841,2866,2576,-1,2703,273,2867,-1,2704,2847,2390,-1,916,2389,2388,-1,2702,274,273,-1,916,168,277,-1,2868,2697,169,-1,2623,235,2624,-1,2695,2717,232,-1,436,2621,2693,-1,2767,294,293,-1,297,298,390,-1,2690,297,390,-1,295,138,2654,-1,297,2637,305,-1,308,307,448,-1,355,2655,188,-1,2662,2869,240,-1,330,332,244,-1,2687,2718,243,-1,2683,2870,2684,-1,2681,269,316,-1,2871,2679,2680,-1,246,2614,318,-1,318,317,246,-1,2612,2676,2678,-1,2674,248,323,-1,2614,246,247,-1,2670,2872,937,-1,2668,131,130,-1,259,2667,315,-1,259,333,2666,-1,149,247,146,-1,256,255,2873,-1,338,256,258,-1,2662,2689,432,-1,428,215,214,-1,2660,429,339,-1,2734,342,2874,-1,2656,343,189,-1,138,2652,2654,-1,296,295,181,-1,2650,389,388,-1,359,304,360,-1,2875,366,2649,-1,382,2644,2648,-1,2647,304,303,-1,2641,2643,375,-1,381,367,378,-1,372,381,378,-1,2876,310,2638,-1,297,2690,2636,-1,2743,2633,2635,-1,350,352,289,-1,327,203,2631,-1,404,2630,2877,-1,396,755,397,-1,398,2628,2487,-1,714,402,400,-1,717,405,408,-1,2629,409,2878,-1,670,2879,671,-1,2628,2419,758,-1,418,764,396,-1,755,754,732,-1,2626,2880,419,-1,2625,422,759,-1,746,423,747,-1,327,2671,2731,-1,2721,2881,2694,-1,2882,2883,2884,-1,323,2675,2620,-1,442,2615,2617,-1,227,146,317,-1,326,2885,2613,-1,2612,2678,154,-1,2679,2871,154,-1,2609,2886,2610,-1,2608,2887,2606,-1,2888,2449,2446,-1,2603,829,466,-1,2602,459,2405,-1,456,2601,540,-1,271,156,2451,-1,2598,453,452,-1,2596,2598,2599,-1,472,2595,489,-1,2395,2889,899,-1,2592,2595,472,-1,485,2890,2592,-1,2891,2892,915,-1,915,277,2891,-1,2893,491,492,-1,2589,2894,2587,-1,2586,2575,2573,-1,122,520,502,-1,507,2895,549,-1,162,2839,2896,-1,509,515,2413,-1,2414,511,2580,-1,2579,513,512,-1,524,2579,516,-1,514,524,523,-1,535,529,2575,-1,526,2897,2574,-1,2573,2575,529,-1,2571,2898,533,-1,546,681,680,-1,545,2426,681,-1,670,546,680,-1,676,678,686,-1,2758,668,2831,-1,2899,2434,2900,-1,563,2441,560,-1,2566,2901,2567,-1,2902,2903,557,-1,2559,2015,2563,-1,601,2904,2011,-1,610,1662,1661,-1,578,576,575,-1,893,631,2543,-1,571,2558,2905,-1,2558,2554,593,-1,597,596,604,-1,2547,2544,599,-1,2906,592,2907,-1,2549,586,2550,-1,897,2908,578,-1,586,2549,578,-1,613,2544,614,-1,897,619,2908,-1,622,815,2546,-1,2909,2402,896,-1,620,2910,2545,-1,2545,2536,655,-1,616,2537,626,-1,2911,2538,2403,-1,626,629,628,-1,11,10,2543,-1,644,2912,2542,-1,2912,635,2542,-1,2543,630,634,-1,640,19,18,-1,2541,634,890,-1,9,2540,652,-1,654,653,2538,-1,2537,2913,629,-1,654,10,652,-1,598,650,2914,-1,2533,660,636,-1,2532,2915,27,-1,2531,19,640,-1,624,656,814,-1,2916,657,607,-1,2409,2457,817,-1,691,693,692,-1,688,2917,689,-1,873,681,2426,-1,697,542,541,-1,2525,690,2526,-1,2524,2918,2522,-1,2521,2919,684,-1,2520,2920,692,-1,3,2519,4,-1,2518,2921,692,-1,691,690,2525,-1,696,2516,698,-1,798,2514,2427,-1,789,864,863,-1,2511,2473,2509,-1,393,395,722,-1,708,2469,709,-1,707,710,713,-1,2922,877,2419,-1,2878,409,2506,-1,2507,2923,2505,-1,409,408,2505,-1,2499,743,742,-1,750,749,729,-1,671,765,393,-1,395,730,703,-1,394,2630,725,-1,2877,2630,2924,-1,711,2629,2503,-1,403,2504,723,-1,2502,740,731,-1,2501,732,754,-1,734,733,2500,-1,417,2880,743,-1,2497,421,420,-1,801,731,2501,-1,2495,2925,2493,-1,748,738,2496,-1,753,751,750,-1,740,2492,751,-1,752,411,413,-1,413,2491,752,-1,2488,397,755,-1,2627,419,758,-1,2926,425,2485,-1,422,2927,414,-1,772,799,2470,-1,745,2928,766,-1,2460,864,2432,-1,796,2490,2475,-1,2479,701,2480,-1,2477,2929,2478,-1,2431,787,786,-1,2474,2475,2490,-1,792,2473,2930,-1,700,702,779,-1,782,784,2461,-1,792,787,2431,-1,2470,770,774,-1,771,792,776,-1,792,771,2472,-1,771,2931,2472,-1,804,863,862,-1,2466,857,856,-1,804,2932,865,-1,133,2933,134,-1,810,811,859,-1,812,810,809,-1,805,2460,2462,-1,779,702,2459,-1,833,113,834,-1,16,49,817,-1,39,2802,2456,-1,664,824,2454,-1,822,663,820,-1,2452,819,21,-1,2443,2444,2450,-1,111,2603,2449,-1,2448,2770,2447,-1,104,106,2443,-1,112,113,833,-1,836,833,835,-1,118,147,119,-1,837,2934,2440,-1,568,605,607,-1,97,2935,98,-1,2437,2837,103,-1,95,846,847,-1,2936,846,94,-1,813,2937,847,-1,852,839,568,-1,813,854,2434,-1,2433,143,860,-1,2492,2938,749,-1,2432,864,789,-1,775,2431,2474,-1,2929,2472,2478,-1,2483,800,745,-1,288,2632,289,-1,713,710,719,-1,863,866,2512,-1,866,865,867,-1,133,2425,867,-1,2427,544,798,-1,869,868,2426,-1,816,872,2534,-1,415,2420,416,-1,2419,414,758,-1,2879,670,543,-1,879,667,669,-1,2418,880,879,-1,550,549,883,-1,883,2418,550,-1,2415,2581,2413,-1,2410,2412,2414,-1,2404,55,56,-1,2810,2407,2409,-1,34,2939,2940,-1,56,12,26,-1,2406,2941,2405,-1,25,889,884,-1,631,892,889,-1,2401,2910,2402,-1,2942,2398,2400,-1,2397,2909,896,-1,2573,2943,2944,-1,2573,2572,2943,-1,514,584,582,-1,523,2945,506,-1,900,902,2395,-1,494,2591,495,-1,904,2946,909,-1,2779,491,2778,-1,2590,904,903,-1,2393,906,2582,-1,2393,2582,2392,-1,2390,2847,2388,-1,429,2387,339,-1,2385,2380,2947,-1,182,2382,2384,-1,2379,2381,2742,-1,2378,918,2948,-1,2375,2949,2376,-1,2372,2950,2373,-1,2371,2951,2369,-1,2368,2952,2366,-1,935,934,2365,-1,2364,2953,218,-1,2954,2955,2956,-1,426,2957,209,-1,2363,2958,2364,-1,2959,2360,2960,-1,2360,2362,2960,-1,2357,2359,2961,-1,2351,2962,2352,-1,2350,244,332,-1,2348,2349,2963,-1,2964,2965,262,-1,1019,2966,2967,-1,960,2347,955,-1,1043,1042,958,-1,962,961,1041,-1,968,967,971,-1,2345,965,2330,-1,969,2344,997,-1,2343,967,1009,-1,1002,2342,2968,-1,1024,2969,999,-1,2340,2290,2289,-1,989,1043,2325,-1,2338,973,2970,-1,981,980,2332,-1,2325,1016,1015,-1,2325,2971,1016,-1,2331,1046,991,-1,962,2972,994,-1,2328,995,2329,-1,999,1002,1001,-1,989,2339,990,-1,2325,2326,2971,-1,993,2324,2973,-1,2322,972,2321,-1,2974,2975,2976,-1,969,996,2320,-1,2971,993,1016,-1,1037,2977,2319,-1,2317,1053,1052,-1,2315,2978,2310,-1,988,2979,1043,-1,1014,1036,2313,-1,2977,1048,1050,-1,1049,1054,1053,-1,1052,1075,2978,-1,2310,1055,2980,-1,1057,1059,2308,-1,2307,1062,2981,-1,1059,2300,1061,-1,1074,1065,1064,-1,1055,1066,2306,-1,1071,1070,1069,-1,1079,1078,2304,-1,2301,2982,2302,-1,2299,2298,2300,-1,2298,1083,1082,-1,2297,1089,1088,-1,2294,2983,2295,-1,1077,1101,1100,-1,1097,1096,2293,-1,2291,2285,2984,-1,2290,2985,2288,-1,2287,2986,1117,-1,2292,2283,2285,-1,2279,2281,2987,-1,2276,1125,2277,-1,1146,1124,1123,-1,2255,2988,1133,-1,1142,1138,1148,-1,2275,1144,1143,-1,1125,1124,1138,-1,2272,2989,2273,-1,2270,1150,1187,-1,1152,2269,1193,-1,1149,2268,1147,-1,1153,1158,1157,-1,1164,2267,2990,-1,1154,1163,1162,-1,2264,2266,2991,-1,2992,2263,1162,-1,1215,1175,1174,-1,2261,1235,1180,-1,1148,1152,1164,-1,1169,1225,1170,-1,2260,2993,2258,-1,2257,1149,1135,-1,2253,2255,1195,-1,1130,1235,1131,-1,1186,2994,1216,-1,2250,2251,2995,-1,1218,1217,2249,-1,2243,2996,2248,-1,1178,1177,1190,-1,1199,2994,1188,-1,2994,1186,1188,-1,1118,1127,1126,-1,1153,1155,1217,-1,1218,2997,2998,-1,1224,2999,1191,-1,2246,3000,1221,-1,1228,1227,2245,-1,1226,1229,1227,-1,1229,2242,1230,-1,3001,3002,3003,-1,3001,3004,3002,-1,2240,1236,2241,-1,2236,1145,1144,-1,1185,3005,1156,-1,2234,2176,2235,-1,2233,1302,2232,-1,2182,2181,1284,-1,1333,2203,1292,-1,2229,3006,2230,-1,1340,2198,3007,-1,3008,3009,1324,-1,2226,2198,2197,-1,1303,2225,3010,-1,1346,3011,2219,-1,3012,3013,3014,-1,1307,2211,2213,-1,2210,1332,1292,-1,1277,3015,3016,-1,1279,1276,1275,-1,1283,1282,2206,-1,3017,1287,3018,-1,3018,3019,3017,-1,2204,3020,2205,-1,3021,2203,1331,-1,3022,3023,1308,-1,2201,1256,1251,-1,1318,2201,1316,-1,2177,2200,2178,-1,1312,1311,3024,-1,1314,2199,2201,-1,1316,2201,2199,-1,3025,1261,1347,-1,2198,2228,2196,-1,1316,2194,1318,-1,1320,3026,2195,-1,2192,3027,2193,-1,2168,1324,3028,-1,2188,1255,2186,-1,1279,2184,1276,-1,2177,2179,2183,-1,3029,1344,1343,-1,2178,1260,2179,-1,2176,2234,2174,-1,1264,3030,2173,-1,1352,3031,2171,-1,2168,3032,2169,-1,3033,2165,2167,-1,2164,3034,1361,-1,3035,3036,3037,-1,1367,1366,2162,-1,1369,2160,1370,-1,3038,3039,3040,-1,3040,1375,3038,-1,1376,3041,2155,-1,2157,3042,2158,-1,2155,3041,2153,-1,1393,3043,2152,-1,2122,2121,2151,-1,1403,2125,2149,-1,1404,2138,2145,-1,2144,1407,3044,-1,3044,3045,2144,-1,1420,1417,2142,-1,2139,2149,2140,-1,3046,3047,3048,-1,3047,3049,3048,-1,2137,1432,1428,-1,1437,1436,2136,-1,2134,3050,1422,-1,1429,2132,1430,-1,2130,3051,2128,-1,1442,3052,2126,-1,1403,1425,1427,-1,2124,3053,1407,-1,3054,1440,1439,-1,2120,3055,1404,-1,3056,3057,3058,-1,3056,1444,3057,-1,2137,1411,1432,-1,3059,3060,3061,-1,3060,3062,3061,-1,2117,3063,2118,-1,2115,3064,3065,-1,2104,2103,2114,-1,1462,2113,1461,-1,3066,1455,1454,-1,2108,1456,1458,-1,2105,1462,1463,-1,1534,2104,3067,-1,1508,3068,1465,-1,2100,2102,3069,-1,1496,2078,3070,-1,2060,1458,2095,-1,1523,1522,2094,-1,1480,1530,1472,-1,2091,1516,1469,-1,1492,1491,1482,-1,1484,2089,3071,-1,2088,3072,1501,-1,2087,3073,2085,-1,3074,2082,2084,-1,2064,2063,2080,-1,1498,1497,1524,-1,1502,3075,2079,-1,2066,2078,2092,-1,2069,2077,2070,-1,2073,2072,2076,-1,2075,1498,1516,-1,1472,2074,1480,-1,3076,2071,2073,-1,1450,3077,1477,-1,2114,3078,3079,-1,2097,2069,1466,-1,2068,3080,2067,-1,2066,3081,1519,-1,1494,1493,2063,-1,3082,1487,2062,-1,3083,2055,2057,-1,3084,3085,3086,-1,1552,3087,1542,-1,2050,1555,3088,-1,2048,1881,1558,-1,3089,1561,1560,-1,1864,1562,2047,-1,1564,1563,1596,-1,2009,1885,1886,-1,1578,1938,1882,-1,1571,1577,2045,-1,1940,3090,2039,-1,1576,1575,2043,-1,2041,2010,2009,-1,1572,3091,2042,-1,1586,1596,1570,-1,1584,1583,1591,-1,1680,1573,2042,-1,1579,1581,1587,-1,2040,2044,2041,-1,1588,1590,1574,-1,2039,1572,1589,-1,1582,3092,2037,-1,2034,1926,2032,-1,1605,1604,2031,-1,1806,1963,1696,-1,1608,1957,1609,-1,1964,1612,1808,-1,1614,2012,1667,-1,1842,3093,3094,-1,1678,1666,1665,-1,3095,3096,1991,-1,1991,2016,3095,-1,1651,1650,2023,-1,1974,1635,1634,-1,2020,2019,1637,-1,2026,1624,1912,-1,1644,1912,1627,-1,1645,3097,1643,-1,1693,1692,2020,-1,1871,1650,3098,-1,1795,1631,2023,-1,1969,1654,2022,-1,2021,1765,1653,-1,1628,1912,1624,-1,1673,2020,2024,-1,1638,2017,1639,-1,580,1985,3099,-1,1991,3100,2015,-1,2014,1729,1728,-1,1613,1615,3093,-1,1592,1586,1570,-1,1729,2014,2011,-1,579,1987,1738,-1,1948,1885,2009,-1,2007,1846,1605,-1,1679,1828,1897,-1,2006,1682,1941,-1,1684,2005,1942,-1,1914,1686,3101,-1,1915,1688,1916,-1,2003,3102,3103,-1,2003,3103,2002,-1,1686,2001,2817,-1,1804,1998,1697,-1,3104,1801,1962,-1,1638,1922,2017,-1,2049,2048,1713,-1,1996,1932,1997,-1,1705,3105,1935,-1,1996,1715,1994,-1,1704,1880,1598,-1,1992,1909,1656,-1,1657,1984,3096,-1,1991,1743,3100,-1,1990,1717,1671,-1,1720,1719,1723,-1,1988,1724,1725,-1,1987,1737,1739,-1,1740,1747,1986,-1,1716,1983,1745,-1,1745,1744,1984,-1,1909,1993,1910,-1,1783,1979,1718,-1,1717,1746,1782,-1,1749,3106,1975,-1,1757,1750,1749,-1,1754,3107,1756,-1,1976,1781,1767,-1,1734,1733,1769,-1,1791,3107,1792,-1,1773,1775,1972,-1,1972,1776,1773,-1,1779,1737,1781,-1,1756,3107,1791,-1,1793,3107,1754,-1,1774,1768,1756,-1,1770,1772,1976,-1,1895,1784,1758,-1,1974,1772,1797,-1,1973,1797,1789,-1,1775,1792,1972,-1,1771,1789,1797,-1,2026,1911,1796,-1,3107,1793,1792,-1,1730,1726,1750,-1,1971,1649,1651,-1,1636,1798,3108,-1,1730,1752,1755,-1,3109,3110,1788,-1,3110,1973,1788,-1,1937,3111,1966,-1,1903,3112,1902,-1,3113,1894,3114,-1,1697,1928,1805,-1,1965,1699,1610,-1,1963,1697,1696,-1,1962,1800,1810,-1,1951,1961,3115,-1,1609,1957,1959,-1,1811,3114,1894,-1,1957,1810,1958,-1,3104,3116,1801,-1,1813,1816,1956,-1,1819,1818,1955,-1,1954,1630,1952,-1,1954,1815,1813,-1,1953,2027,1818,-1,1951,1630,1620,-1,1950,1819,3117,-1,1939,1829,3118,-1,1946,1683,1682,-1,1829,1939,1851,-1,1944,3119,1943,-1,1841,1679,1897,-1,1942,1924,1684,-1,1860,1844,1843,-1,1666,1854,3120,-1,1848,1861,1849,-1,1849,3121,1931,-1,1939,3090,1940,-1,1847,1930,1856,-1,1938,2047,1562,-1,1865,1867,1868,-1,1799,3122,1784,-1,1764,1710,1653,-1,1648,1647,1875,-1,1870,1647,1626,-1,1875,1934,1873,-1,1598,1880,1879,-1,1711,1710,1933,-1,3123,1567,1566,-1,1931,1850,1930,-1,3124,1622,1929,-1,1888,3125,1929,-1,1928,1959,1894,-1,1927,1839,1838,-1,1924,2032,1926,-1,1838,2035,1924,-1,1921,1919,1922,-1,1701,1922,1919,-1,1719,1979,1918,-1,1914,3101,1915,-1,3126,3127,3128,-1,1906,1786,1634,-1,1912,1644,1905,-1,1907,1748,1740,-1,1910,1993,1747,-1,1641,1692,1910,-1,1691,1983,1909,-1,1908,1642,1747,-1,1739,1780,1787,-1,3129,1905,1643,-1,1911,1905,1906,-1,1628,1624,1648,-1,1685,1691,1690,-1,1979,1719,1982,-1,1902,3130,1801,-1,1638,1923,1922,-1,1898,1901,1611,-1,1898,1759,1761,-1,1896,1924,1841,-1,1895,3131,1763,-1,1894,3113,1803,-1,1893,1637,2019,-1,1890,3132,1889,-1,1887,1675,1674,-1,1887,1929,1622,-1,1568,1562,1566,-1,1629,1865,1883,-1,1648,1874,1629,-1,3133,1932,1933,-1,1872,3134,1704,-1,1597,1600,1877,-1,1875,1870,1872,-1,1866,1873,1934,-1,1870,1646,1871,-1,1710,1764,1933,-1,1764,3119,1933,-1,1868,1867,1559,-1,1560,1863,3135,-1,1864,1565,1863,-1,1848,1844,1860,-1,1859,2045,1577,-1,1857,1940,1855,-1,1853,1854,1998,-1,1852,1930,1850,-1,1857,1856,1852,-1,1924,1941,1684,-1,1677,2028,1845,-1,1708,1707,1844,-1,1679,1842,1680,-1,2036,1838,1840,-1,1834,1833,1944,-1,1837,3136,1835,-1,1832,1840,1833,-1,1682,2006,1830,-1,1829,1945,1827,-1,1677,1846,1826,-1,1823,1825,1889,-1,1821,1616,1822,-1,1817,1602,1818,-1,1815,3117,1816,-1,1814,1877,1630,-1,1812,1955,1618,-1,1811,1958,1810,-1,1808,1612,1809,-1,1806,3137,1807,-1,1699,1822,2027,-1,1638,1637,1923,-1,1636,1635,1797,-1,1632,1631,1795,-1,1785,1790,1794,-1,1784,1790,1785,-1,1788,1973,1789,-1,1780,1634,1786,-1,1783,1718,1717,-1,1779,1772,1974,-1,1779,1974,1780,-1,1776,1972,1777,-1,1774,1791,1775,-1,1733,1732,1769,-1,1977,1766,1734,-1,1767,1781,1736,-1,1763,3138,1764,-1,1793,1754,1785,-1,1750,1726,1725,-1,1755,1731,1970,-1,1754,1755,1752,-1,1749,1751,3106,-1,1978,1760,1762,-1,3112,3139,1902,-1,1772,1779,1976,-1,1743,1745,1741,-1,1983,1716,1909,-1,1738,1740,1985,-1,1735,1737,1987,-1,1658,1734,1659,-1,1663,1732,1664,-1,1730,1970,1728,-1,1989,1725,1727,-1,1722,1724,1988,-1,1721,1982,1719,-1,1671,1717,1672,-1,1656,1909,1716,-1,1709,1715,1996,-1,1597,1713,2048,-1,1935,1710,1706,-1,1709,1997,1707,-1,1706,3140,1703,-1,1702,3141,1700,-1,1699,3142,1698,-1,1697,1998,1695,-1,1804,1803,1999,-1,3102,2003,1693,-1,1689,1691,1694,-1,1686,2817,1687,-1,1684,1941,1682,-1,1681,1828,1679,-1,1826,2007,2008,-1,1676,2028,1677,-1,2018,2020,1639,-1,1672,3143,1670,-1,1613,3144,1668,-1,1669,2012,1614,-1,1666,3120,1667,-1,1660,3145,1658,-1,1657,3146,1655,-1,1795,2026,1796,-1,1654,1969,1652,-1,1649,2022,1650,-1,2018,3147,2020,-1,1644,2025,1645,-1,1640,1642,1908,-1,3141,3147,1700,-1,1634,1636,1913,-1,1633,1651,1631,-1,1600,1630,1877,-1,1627,1629,1884,-1,1647,1624,1626,-1,1621,1623,3148,-1,1619,1600,1599,-1,2012,1676,1665,-1,1614,2029,1615,-1,1610,1698,1611,-1,1607,1609,1963,-1,2031,2008,2007,-1,2032,1950,2033,-1,1585,2041,1595,-1,1571,2046,1594,-1,1591,1580,1579,-1,1593,1587,1586,-1,1588,2040,1587,-1,1587,2040,1585,-1,1579,1582,1584,-1,1569,1594,1592,-1,3094,1574,1573,-1,1574,3094,1575,-1,1572,2042,1573,-1,1570,1596,1571,-1,3125,3135,1929,-1,1565,2047,1563,-1,1562,1864,1560,-1,1795,2023,3149,-1,1559,1934,1557,-1,1555,2051,1553,-1,1550,1552,1544,-1,1549,3150,1547,-1,1545,1543,1542,-1,1540,3151,1541,-1,1538,3152,1490,-1,1535,2068,1536,-1,1532,3153,1533,-1,1469,1468,2091,-1,1482,1484,1528,-1,3154,1525,1507,-1,1467,1495,3155,-1,1521,3156,1522,-1,1477,3077,1520,-1,1517,1519,3157,-1,1498,1524,1469,-1,3158,1513,1515,-1,3159,1510,1512,-1,1481,3157,1479,-1,1508,1506,1505,-1,1507,3160,1505,-1,1467,1504,1468,-1,2078,2075,2092,-1,1496,3161,1497,-1,1495,1524,1493,-1,3162,1490,1492,-1,1489,3163,1487,-1,1471,1486,2074,-1,1482,2090,1483,-1,1479,1530,1480,-1,1516,2092,2075,-1,1476,1478,3164,-1,1475,2096,1473,-1,1472,1529,1470,-1,1467,1469,1524,-1,1464,1466,2070,-1,1461,1460,1463,-1,1455,3165,1453,-1,3166,1450,1452,-1,3064,3164,1478,-1,1449,3167,1447,-1,1444,1446,3057,-1,1442,1414,3052,-1,3168,3169,3170,-1,1440,3171,1441,-1,1401,2139,2138,-1,3172,1436,1438,-1,1435,2137,1424,-1,1432,3173,1433,-1,1431,3174,1429,-1,1433,1426,1428,-1,1424,1416,1434,-1,1423,3175,1421,-1,1416,1420,2141,-1,2142,1417,1419,-1,1416,1425,1403,-1,1413,3176,1414,-1,3049,1410,1412,-1,3177,2144,3045,-1,2140,2145,2138,-1,1403,2139,1401,-1,1400,3169,1398,-1,2124,2143,3178,-1,1396,3179,1397,-1,1392,3180,1393,-1,3181,1389,1391,-1,1386,1388,3182,-1,3183,1383,1385,-1,3184,1380,1382,-1,1378,3185,1379,-1,1374,1376,3186,-1,1371,1373,1362,-1,1368,1370,3187,-1,1365,3188,1366,-1,1362,1373,1363,-1,3189,3190,3022,-1,1361,934,1322,-1,3191,1358,1360,-1,3192,1355,1357,-1,1283,1246,2180,-1,1353,3193,1351,-1,1295,1294,1350,-1,1346,2218,1347,-1,1288,1287,3194,-1,1343,1282,3195,-1,1342,1286,1345,-1,1340,1341,2183,-1,2190,2189,3196,-1,1336,1249,1334,-1,1332,3197,1333,-1,1315,3198,1327,-1,3028,1324,1326,-1,3031,1321,1323,-1,1254,1318,1320,-1,1315,2194,1316,-1,3199,1310,1340,-1,1310,3199,1313,-1,1259,3024,1311,-1,1257,1259,1311,-1,1254,1256,1318,-1,1250,1341,1310,-1,1260,2178,1311,-1,3200,2202,2191,-1,1309,3201,1307,-1,3023,3202,3203,-1,1309,1308,3023,-1,1305,3204,1306,-1,3010,1301,1303,-1,1300,3205,1299,-1,1263,1296,1298,-1,1349,1294,2222,-1,2222,3206,1349,-1,2205,1293,1295,-1,1292,2203,1290,-1,3207,2204,1295,-1,1295,1350,3207,-1,3018,1287,1289,-1,1284,1286,2182,-1,2180,1281,1283,-1,1275,1277,3016,-1,3208,3209,3210,-1,1264,3193,1265,-1,1262,2179,1260,-1,1258,2229,1259,-1,1255,2188,1256,-1,1252,3211,1253,-1,1249,1336,1250,-1,1246,1354,1247,-1,1243,3212,1241,-1,1137,1136,1128,-1,1239,3213,1199,-1,2241,1236,1238,-1,1198,3214,1180,-1,1233,3215,1234,-1,1227,1229,1231,-1,1228,3216,1226,-1,1223,3217,1224,-1,1126,1123,1219,-1,1216,1202,2252,-1,1139,1138,1124,-1,1164,1152,1193,-1,1211,2249,1212,-1,1210,1217,1208,-1,1205,1207,2250,-1,1204,3218,1202,-1,1199,1188,1200,-1,1197,3219,1198,-1,1195,2255,1132,-1,1162,1194,2992,-1,1170,1225,1191,-1,1189,1222,1190,-1,1187,2238,1188,-1,1153,1210,1185,-1,1184,3220,1182,-1,1181,3221,1179,-1,1176,3222,1177,-1,1174,1172,1171,-1,1171,1173,3223,-1,1170,2262,1168,-1,1165,1167,3224,-1,1163,1157,1164,-1,1160,3225,1161,-1,1156,2267,1157,-1,1153,1163,1154,-1,1147,1150,1152,-1,1148,1135,1149,-1,1136,1139,1146,-1,1145,3226,1143,-1,1140,1142,1148,-1,1148,1138,1135,-1,1135,1137,2256,-1,1132,1134,3227,-1,1131,3228,1129,-1,1128,1146,1126,-1,1123,1125,2276,-1,3229,1120,1122,-1,1199,3230,2994,-1,1115,1117,2986,-1,1113,3231,1114,-1,1109,3232,1110,-1,3233,1106,1108,-1,3234,1103,1105,-1,1102,3235,1100,-1,1099,3236,1089,-1,1095,1097,1083,-1,1078,1100,1093,-1,1090,1092,3237,-1,1089,3238,1087,-1,3239,1006,1086,-1,1083,2337,1084,-1,1081,2299,1058,-1,1079,3240,1077,-1,1076,2347,959,-1,1075,2311,1073,-1,1071,2305,1072,-1,1045,3241,1069,-1,1068,3242,1013,-1,1064,1066,1055,-1,1003,3243,1063,-1,1061,3244,1062,-1,1058,2300,1059,-1,1039,2980,1055,-1,1054,2311,1052,-1,1051,2312,1049,-1,1037,1048,2977,-1,1044,3245,1045,-1,1043,2979,1041,-1,982,984,3246,-1,986,1040,987,-1,2313,1036,1038,-1,1035,3247,1021,-1,1035,3248,3247,-1,3249,2975,3250,-1,1032,3251,1033,-1,1029,1031,3252,-1,1026,1028,3253,-1,972,1025,3254,-1,3255,1023,998,-1,1022,2338,1020,-1,3256,987,988,-1,1014,1016,3257,-1,3258,2314,3259,-1,2284,1010,952,-1,1007,1009,2320,-1,1006,3239,1004,-1,1002,2968,1003,-1,998,1024,999,-1,997,3260,996,-1,963,995,2328,-1,991,993,2973,-1,3256,988,990,-1,985,987,3256,-1,982,3261,983,-1,979,3262,980,-1,976,978,1010,-1,975,2970,973,-1,2322,970,972,-1,1009,967,969,-1,997,2344,966,-1,966,2345,997,-1,964,966,3263,-1,963,1076,961,-1,1041,2979,2346,-1,958,1042,959,-1,955,2347,956,-1,3264,2324,1011,-1,952,954,3265,-1,949,951,3266,-1,948,2348,947,-1,946,3267,944,-1,941,943,3268,-1,939,3269,940,-1,210,937,3270,-1,201,3271,934,-1,933,1358,931,-1,930,2741,928,-1,193,192,923,-1,996,920,922,-1,919,3272,917,-1,3273,3274,3275,-1,518,910,519,-1,906,2393,908,-1,2892,2891,495,-1,900,3276,901,-1,585,514,523,-1,505,3277,585,-1,897,2396,896,-1,894,3278,895,-1,654,2539,893,-1,631,3279,891,-1,890,632,889,-1,12,14,887,-1,58,14,13,-1,2408,2457,2409,-1,2404,884,885,-1,570,572,2558,-1,2530,678,589,-1,881,677,684,-1,678,3280,589,-1,880,3281,667,-1,721,720,875,-1,758,874,2627,-1,682,695,679,-1,54,53,872,-1,46,43,871,-1,3282,668,870,-1,865,2465,807,-1,288,287,136,-1,861,86,85,-1,102,3283,808,-1,805,2462,3284,-1,752,2491,751,-1,780,3285,855,-1,749,706,705,-1,102,2936,94,-1,2434,854,2900,-1,851,561,841,-1,851,2937,561,-1,3286,3287,557,-1,3287,2902,557,-1,811,846,2936,-1,94,846,95,-1,3288,843,845,-1,842,2934,830,-1,839,747,605,-1,2934,837,830,-1,825,837,822,-1,144,151,114,-1,110,833,836,-1,155,3289,2443,-1,110,112,833,-1,2771,96,827,-1,828,3290,830,-1,829,2603,111,-1,826,464,827,-1,824,664,822,-1,819,821,2800,-1,817,2799,818,-1,814,2421,815,-1,811,810,812,-1,791,792,2930,-1,810,859,808,-1,84,3283,102,-1,804,862,805,-1,761,768,767,-1,801,803,776,-1,768,800,2483,-1,770,2470,799,-1,672,544,546,-1,797,2459,749,-1,795,2475,793,-1,2929,2509,2472,-1,2471,2458,2459,-1,787,791,785,-1,784,782,781,-1,782,2482,780,-1,778,779,3291,-1,775,801,776,-1,770,769,773,-1,744,800,772,-1,777,776,792,-1,772,800,799,-1,2927,874,414,-1,727,726,393,-1,763,733,756,-1,416,759,414,-1,396,419,418,-1,415,424,739,-1,754,756,733,-1,775,2502,801,-1,749,2490,796,-1,2490,749,2938,-1,2496,746,748,-1,744,3292,736,-1,413,740,2491,-1,738,423,2496,-1,736,421,2497,-1,735,754,733,-1,731,732,2501,-1,724,3293,730,-1,705,2503,412,-1,2506,2488,3294,-1,728,2924,726,-1,723,3293,724,-1,703,672,671,-1,721,3295,542,-1,723,719,3293,-1,718,2513,704,-1,407,712,716,-1,408,406,2505,-1,2504,715,719,-1,708,710,707,-1,708,3296,2469,-1,707,711,705,-1,2473,2472,2509,-1,698,2516,699,-1,695,2515,696,-1,693,694,2518,-1,2920,690,692,-1,4,687,689,-1,681,873,679,-1,675,3297,673,-1,542,2528,2517,-1,672,546,670,-1,881,678,677,-1,666,3298,665,-1,664,2454,52,-1,661,659,658,-1,661,662,637,-1,2454,657,659,-1,655,3299,656,-1,649,2912,639,-1,648,11,633,-1,11,2543,633,-1,652,3300,653,-1,596,602,650,-1,25,24,646,-1,643,2818,644,-1,638,3301,641,-1,636,660,637,-1,634,2542,635,-1,629,625,621,-1,621,625,622,-1,623,655,624,-1,619,896,2402,-1,2549,576,578,-1,587,2908,619,-1,587,578,2908,-1,2550,616,618,-1,613,615,627,-1,588,2913,2537,-1,612,2548,610,-1,605,3302,606,-1,621,599,628,-1,596,595,601,-1,600,651,598,-1,597,2555,595,-1,3303,3304,505,-1,581,2564,2416,-1,584,585,3277,-1,3305,2560,583,-1,897,578,580,-1,577,1660,575,-1,3306,572,574,-1,571,3143,569,-1,568,2441,563,-1,3307,564,566,-1,562,3308,563,-1,557,3309,558,-1,555,3310,556,-1,553,3311,551,-1,3312,521,550,-1,547,548,894,-1,674,693,3313,-1,538,540,2601,-1,3314,535,537,-1,3315,2594,526,-1,3316,532,534,-1,531,2572,529,-1,528,2897,526,-1,525,519,523,-1,521,522,120,-1,502,911,516,-1,3317,515,508,-1,882,510,514,-1,512,513,510,-1,120,522,121,-1,911,502,520,-1,506,3318,504,-1,3319,499,501,-1,898,2586,899,-1,491,2779,490,-1,483,3315,480,-1,474,484,486,-1,3320,481,479,-1,477,482,475,-1,474,486,472,-1,469,471,473,-1,467,2599,468,-1,462,2446,463,-1,2888,2604,105,-1,460,2598,455,-1,459,467,457,-1,455,2600,456,-1,2598,2597,455,-1,451,2450,452,-1,448,450,310,-1,261,447,3321,-1,109,3322,2865,-1,445,154,2871,-1,252,247,148,-1,317,146,246,-1,443,146,227,-1,442,2617,440,-1,337,2710,336,-1,286,2621,436,-1,285,3323,434,-1,432,3324,430,-1,215,429,2660,-1,3325,426,211,-1,423,739,424,-1,421,2927,422,-1,2880,417,419,-1,764,756,396,-1,414,878,415,-1,2879,3295,671,-1,410,3326,413,-1,407,717,408,-1,405,714,400,-1,404,401,402,-1,2487,396,398,-1,393,726,394,-1,181,295,300,-1,345,344,346,-1,388,390,3327,-1,387,3328,385,-1,384,385,382,-1,379,381,372,-1,378,367,376,-1,375,373,2641,-1,178,3329,374,-1,372,2639,373,-1,367,369,376,-1,177,370,175,-1,365,363,366,-1,362,366,363,-1,3330,174,358,-1,2745,2744,296,-1,357,306,356,-1,354,2655,355,-1,353,357,289,-1,350,2632,351,-1,196,3331,348,-1,347,3332,345,-1,343,191,189,-1,2656,2736,3333,-1,2734,340,342,-1,339,2659,222,-1,334,441,335,-1,330,3334,331,-1,326,2614,254,-1,323,324,2675,-1,319,101,145,-1,259,258,256,-1,314,3335,312,-1,309,448,310,-1,306,357,307,-1,305,3336,177,-1,3337,3338,2645,-1,3337,3339,3338,-1,3340,2640,299,-1,301,3341,300,-1,299,2640,179,-1,2762,138,296,-1,292,2755,293,-1,291,2755,137,-1,287,289,357,-1,284,3323,285,-1,2696,235,2623,-1,2668,127,131,-1,281,2750,282,-1,231,2624,279,-1,2701,903,3342,-1,2389,903,2390,-1,2844,2752,2393,-1,2844,2393,3343,-1,3344,3345,3320,-1,3346,268,269,-1,267,2610,266,-1,263,2682,264,-1,260,266,261,-1,157,447,266,-1,256,338,172,-1,247,251,253,-1,252,3347,251,-1,250,324,248,-1,243,245,945,-1,240,238,2689,-1,232,242,433,-1,233,128,127,-1,225,224,2881,-1,3348,2618,437,-1,225,2724,223,-1,3349,3350,3351,-1,213,2671,2673,-1,215,3352,216,-1,2673,211,213,-1,210,207,208,-1,207,210,205,-1,933,3353,2657,-1,201,354,199,-1,197,3354,198,-1,3355,301,2654,-1,189,191,193,-1,195,188,190,-1,189,193,187,-1,3356,3327,2692,-1,2745,181,183,-1,179,917,180,-1,173,174,2649,-1,2873,2851,2850,-1,3357,278,3358,-1,2868,916,2848,-1,3359,2841,2840,-1,3360,3273,173,-1,160,162,158,-1,155,157,2886,-1,154,836,107,-1,150,152,2882,-1,2838,147,149,-1,144,146,443,-1,103,2837,2433,-1,807,294,3361,-1,138,2762,139,-1,2634,3362,3363,-1,132,2833,133,-1,384,2757,2832,-1,129,3364,130,-1,126,2442,127,-1,123,2825,124,-1,120,122,2584,-1,357,290,137,-1,119,110,117,-1,2445,101,832,-1,104,2768,105,-1,109,153,107,-1,116,115,3365,-1,102,103,860,-1,2448,829,2770,-1,101,319,99,-1,2937,851,847,-1,86,2754,84,-1,908,2393,2776,-1,77,83,61,-1,82,32,80,-1,77,61,78,-1,23,73,57,-1,2784,66,67,-1,72,58,73,-1,72,886,58,-1,2792,51,50,-1,68,2798,69,-1,38,69,67,-1,66,2783,36,-1,36,35,67,-1,63,2796,61,-1,60,83,59,-1,2423,47,51,-1,54,871,52,-1,49,16,50,-1,46,2799,47,-1,2786,80,72,-1,71,2786,72,-1,31,29,28,-1,27,3366,28,-1,25,2404,26,-1,20,2808,18,-1,816,2794,2409,-1,3367,643,645,-1,12,56,13,-1,2818,2531,644,-1,6,8,2812,-1,2520,2813,689,-1,5,2815,3,-1,0,2814,1,-1,1727,2904,1989,-1,2011,2904,1727,-1,2531,20,19,-1,2531,2811,20,-1,3367,2542,2541,-1,2542,3367,645,-1,3368,888,3369,-1,3368,2819,888,-1,2810,2793,2532,-1,2810,2794,2793,-1,887,3369,888,-1,887,2811,3369,-1,2407,17,2408,-1,3370,17,2407,-1,3366,2820,28,-1,2820,3366,3371,-1,818,46,54,-1,2799,46,818,-1,40,75,74,-1,42,75,40,-1,2794,2534,2533,-1,2794,816,2534,-1,2800,3372,2821,-1,3372,2800,821,-1,2792,69,2798,-1,2792,2788,69,-1,2786,22,2787,-1,71,22,2786,-1,41,2782,2820,-1,2780,2782,41,-1,3373,76,75,-1,76,3373,2785,-1,348,3374,2466,-1,348,3331,3374,-1,172,2777,255,-1,2777,172,171,-1,126,2772,844,-1,2825,2772,126,-1,2447,116,2771,-1,2447,2769,116,-1,2824,848,91,-1,848,2824,89,-1,3364,843,3375,-1,3364,129,843,-1,2764,2827,3374,-1,2764,2763,2827,-1,2896,3273,3275,-1,2896,2839,3273,-1,142,426,3376,-1,142,2957,426,-1,2836,331,3334,-1,2836,2835,331,-1,3377,2760,2438,-1,2760,3377,2761,-1,2834,294,2767,-1,2834,3361,294,-1,134,3378,132,-1,2829,3378,134,-1,2758,376,369,-1,376,2758,2831,-1,2425,3282,870,-1,2425,2833,3282,-1,3379,140,139,-1,3379,2834,140,-1,3376,143,142,-1,143,3376,861,-1,151,443,152,-1,151,144,443,-1,447,272,3321,-1,270,272,447,-1,2841,3380,2842,-1,3380,2841,3274,-1,2866,3381,2391,-1,3382,3381,2866,-1,2844,3383,2845,-1,3383,2844,3343,-1,2751,2775,2752,-1,2751,3384,2775,-1,2386,3385,2702,-1,2386,3386,3385,-1,2388,2849,916,-1,281,2849,2388,-1,2852,276,3387,-1,2852,2851,276,-1,470,2748,2747,-1,2853,2748,470,-1,3388,3389,3390,-1,3391,3389,3388,-1,3392,364,3393,-1,365,364,3392,-1,922,3394,3395,-1,3394,922,921,-1,2948,380,379,-1,380,2948,918,-1,2385,3396,3397,-1,3396,2385,3398,-1,3399,3400,2382,-1,3399,2650,3400,-1,3401,3332,3402,-1,345,3332,3401,-1,2690,3403,2636,-1,2690,926,3403,-1,2740,3404,2741,-1,2740,3405,3404,-1,3406,2653,3407,-1,2653,3406,3408,-1,306,3409,356,-1,306,2373,3409,-1,353,448,307,-1,353,449,448,-1,3410,349,3411,-1,349,3410,3412,-1,2952,392,3413,-1,392,2952,2368,-1,2657,2735,933,-1,2657,340,2735,-1,2736,2365,3414,-1,2736,935,2365,-1,3415,449,353,-1,449,3415,3416,-1,218,3417,219,-1,3417,218,2953,-1,2732,209,208,-1,427,209,2732,-1,3418,2728,3419,-1,3418,2856,2728,-1,226,444,227,-1,444,226,3420,-1,437,2722,3348,-1,437,2620,2722,-1,230,3421,3422,-1,230,229,3421,-1,2725,284,436,-1,284,2725,3423,-1,2884,3424,3425,-1,2884,3426,3424,-1,286,3427,2622,-1,286,285,3427,-1,313,3428,3429,-1,3430,3428,313,-1,2716,2349,948,-1,2349,2716,2622,-1,3431,3432,2663,-1,3433,3432,3431,-1,3434,2718,3435,-1,2718,3434,2860,-1,3436,2622,3427,-1,2622,3436,2349,-1,3437,445,3438,-1,3439,445,3437,-1,2667,3440,3441,-1,3440,2667,3442,-1,3443,2674,3444,-1,3445,2674,3443,-1,2964,261,2705,-1,262,261,2964,-1,439,2863,442,-1,2863,439,2712,-1,2664,268,2709,-1,2664,258,268,-1,2746,2617,2616,-1,2746,2748,2617,-1,476,451,453,-1,451,476,3446,-1,3320,3447,3344,-1,3447,3320,3448,-1,3344,2890,3345,-1,2890,3344,3449,-1,2576,2391,914,-1,2576,2866,2391,-1,346,3383,3450,-1,346,344,3383,-1,3451,3384,2751,-1,3451,342,3384,-1,341,2387,3452,-1,341,339,2387,-1,2704,2700,165,-1,2704,2394,2700,-1,428,2386,429,-1,3386,2386,428,-1,2668,2694,127,-1,2668,2721,2694,-1,435,234,3453,-1,234,435,279,-1,224,2693,2695,-1,224,223,2693,-1,2765,3454,351,-1,3454,2765,2764,-1,2651,3405,2740,-1,2651,3455,3405,-1,3328,374,3456,-1,387,374,3328,-1,204,327,391,-1,203,327,204,-1,2670,209,2957,-1,209,2670,936,-1,2683,2350,2870,-1,2683,245,2350,-1,438,3444,2674,-1,2619,3444,438,-1,3377,314,3457,-1,125,314,3377,-1,130,3425,2669,-1,3458,3425,130,-1,147,2445,119,-1,2838,2445,147,-1,3459,3322,109,-1,3322,3459,3460,-1,3461,169,2697,-1,3461,167,169,-1,3461,3462,3463,-1,3462,3461,3422,-1,3431,430,3324,-1,430,3431,282,-1,3464,214,2727,-1,2661,214,3464,-1,3465,2608,3466,-1,2608,3465,219,-1,3451,2874,342,-1,3451,3414,2874,-1,3467,2637,2636,-1,3468,2637,3467,-1,300,3399,181,-1,300,3455,3399,-1,298,3327,390,-1,298,2692,3327,-1,3469,304,2647,-1,360,304,3469,-1,3275,2841,2576,-1,3274,2841,3275,-1,3312,2756,3470,-1,2756,3312,2568,-1,3394,303,3338,-1,3394,2646,303,-1,377,373,2639,-1,373,377,3471,-1,185,1010,2284,-1,1010,185,184,-1,3396,3362,3397,-1,2643,3362,3396,-1,3466,2607,3413,-1,2608,2607,3466,-1,765,876,727,-1,765,721,876,-1,759,2420,2625,-1,2420,759,416,-1,737,2627,874,-1,737,2626,2627,-1,239,3472,3473,-1,239,3474,3472,-1,3334,937,2872,-1,3334,330,937,-1,2680,2862,3438,-1,2862,2680,2681,-1,3475,3473,3472,-1,3475,3476,3473,-1,157,2610,2886,-1,2610,157,266,-1,2446,2603,463,-1,2446,2449,2603,-1,2602,2597,2596,-1,2597,2602,3477,-1,2601,3477,527,-1,2600,3477,2601,-1,2451,451,271,-1,451,2451,2450,-1,2395,3478,2889,-1,2395,902,3478,-1,3479,3449,3344,-1,488,3449,3479,-1,471,2747,3480,-1,470,2747,471,-1,475,481,3481,-1,481,475,483,-1,170,335,3482,-1,337,335,170,-1,3483,3484,494,-1,3483,3276,3484,-1,2590,3485,904,-1,2591,3485,2590,-1,2944,2589,3486,-1,2944,2894,2589,-1,513,524,514,-1,513,2579,524,-1,522,2896,121,-1,2896,522,162,-1,2410,515,3487,-1,515,2410,2413,-1,3317,502,517,-1,3317,503,502,-1,508,549,521,-1,508,507,549,-1,530,535,3314,-1,535,530,529,-1,2574,3316,478,-1,3316,2574,3488,-1,3489,3488,2574,-1,3489,2398,3488,-1,2571,537,2898,-1,2571,3314,537,-1,477,538,2593,-1,477,539,538,-1,3490,537,3491,-1,2898,537,3490,-1,674,3492,675,-1,674,3313,3492,-1,3493,2941,2406,-1,3493,3489,2941,-1,3282,2831,668,-1,3282,3494,2831,-1,553,2,3310,-1,553,8,2,-1,3495,5,2813,-1,3495,559,5,-1,761,2900,854,-1,2900,761,565,-1,2899,2902,2434,-1,2899,2903,2902,-1,2435,849,561,-1,3287,849,2435,-1,1655,3277,3496,-1,584,3277,1655,-1,2559,2016,2015,-1,2559,2560,2016,-1,601,3497,2904,-1,601,3498,3497,-1,2013,2562,2914,-1,2562,2013,1662,-1,505,3099,3499,-1,505,3304,3099,-1,591,3500,3501,-1,2416,3500,591,-1,3502,594,2554,-1,3503,594,3502,-1,592,666,593,-1,592,2906,666,-1,2551,2422,3504,-1,2553,2422,2551,-1,2548,2562,610,-1,2547,2562,2548,-1,609,618,617,-1,609,608,618,-1,2910,619,2402,-1,2910,620,619,-1,2401,2538,653,-1,2401,2403,2538,-1,2531,2912,644,-1,2912,2531,639,-1,625,2913,623,-1,629,2913,625,-1,2907,2555,2552,-1,2907,3503,2555,-1,3505,641,3301,-1,2540,641,3505,-1,658,638,662,-1,3301,638,658,-1,2421,2916,607,-1,2916,2421,814,-1,3506,3507,3280,-1,3507,3506,3508,-1,3313,691,2525,-1,3313,693,691,-1,680,696,2569,-1,680,679,696,-1,2527,2516,2523,-1,2527,699,2516,-1,2525,2523,2522,-1,2525,2527,2523,-1,2519,2814,3509,-1,2814,2519,3,-1,2519,2528,687,-1,2519,2517,2528,-1,2528,699,3510,-1,2528,697,699,-1,875,2486,877,-1,875,3511,2486,-1,2468,2512,2469,-1,2512,2468,789,-1,2924,2628,2507,-1,728,2628,2924,-1,400,2505,406,-1,2505,400,399,-1,413,2489,732,-1,3326,2489,413,-1,2508,714,405,-1,2508,713,714,-1,763,2499,2500,-1,763,417,2499,-1,420,3512,2498,-1,420,2625,3512,-1,2501,802,801,-1,2501,735,802,-1,3513,2495,2494,-1,3513,3512,2495,-1,2492,2502,2938,-1,2492,740,2502,-1,425,878,2485,-1,878,425,424,-1,766,3514,767,-1,2928,3514,766,-1,796,3515,797,-1,796,795,3515,-1,2479,3516,790,-1,2479,2481,3516,-1,2431,793,2474,-1,2431,794,793,-1,784,2472,2461,-1,2472,784,2478,-1,3517,3518,785,-1,3517,3519,3518,-1,2462,3520,3284,-1,2931,3520,2462,-1,2469,866,3521,-1,2469,2512,866,-1,858,84,856,-1,3283,84,858,-1,2463,2430,3284,-1,2463,809,2430,-1,2931,2461,2472,-1,2931,2462,2461,-1,3326,2488,2489,-1,2488,3326,3294,-1,2923,2506,2505,-1,2923,2488,2506,-1,820,3522,821,-1,820,663,3522,-1,2451,155,2443,-1,155,2451,156,-1,3523,885,831,-1,3523,55,885,-1,113,2888,105,-1,2888,113,2449,-1,824,2440,568,-1,2440,824,823,-1,3524,2837,2437,-1,2835,2837,3524,-1,2566,554,2901,-1,2566,555,554,-1,141,2433,3525,-1,141,143,2433,-1,809,2429,2430,-1,808,2429,809,-1,768,3520,799,-1,768,3526,3520,-1,288,2464,2765,-1,2464,288,136,-1,2830,139,3363,-1,2830,3379,139,-1,718,2514,2513,-1,3521,2514,718,-1,2829,3363,2642,-1,3363,2829,2830,-1,2529,873,2426,-1,2529,682,873,-1,3297,2551,2484,-1,3297,2906,2551,-1,3493,2398,3489,-1,2398,3493,2399,-1,2529,3508,3506,-1,2529,3527,3508,-1,880,3528,3507,-1,2418,3528,880,-1,3529,3530,3298,-1,3529,685,3530,-1,883,3528,2418,-1,3528,883,2556,-1,3498,595,3502,-1,3498,601,595,-1,2939,2915,2940,-1,3531,2915,2939,-1,2806,18,2808,-1,18,2806,636,-1,889,465,884,-1,465,889,892,-1,3279,3532,3533,-1,3279,631,3532,-1,3534,3535,3278,-1,3535,3534,3536,-1,2397,3303,3537,-1,3303,2397,2396,-1,547,2572,531,-1,2572,547,2943,-1,504,3538,3537,-1,3538,504,2587,-1,3539,2588,3318,-1,3540,2588,3539,-1,3485,494,3484,-1,494,3485,2591,-1,495,2778,491,-1,495,2891,2778,-1,2873,2665,256,-1,2873,2850,2665,-1,342,3452,3384,-1,341,3452,342,-1,3541,3395,3542,-1,3541,922,3395,-1,3543,2320,3541,-1,3543,3544,2320,-1,3545,2742,183,-1,2742,3545,2379,-1,1116,3400,3546,-1,3547,3400,1116,-1,3548,2284,2283,-1,2284,3548,185,-1,3549,3550,3551,-1,3549,3552,3550,-1,3388,3553,3554,-1,3555,3553,3388,-1,3556,3557,3402,-1,3557,3556,3558,-1,1244,190,187,-1,1244,2998,190,-1,3559,3560,3409,-1,3561,3560,3559,-1,3406,2282,3230,-1,2282,3406,3562,-1,2369,3563,200,-1,2369,2951,3563,-1,3564,3565,3415,-1,3564,3566,3565,-1,3410,3567,3568,-1,198,3567,3410,-1,3569,2368,2367,-1,2368,3569,202,-1,2855,1359,2735,-1,2855,3570,1359,-1,2869,3418,3474,-1,3418,2869,2856,-1,2359,3571,3572,-1,2359,2358,3571,-1,3573,208,207,-1,208,3573,3574,-1,206,2360,2959,-1,3575,2360,206,-1,2361,3575,3576,-1,2361,2360,3575,-1,3577,3474,3418,-1,3577,3472,3474,-1,216,3572,3578,-1,216,3352,3572,-1,3574,2732,208,-1,3574,3579,2732,-1,2356,217,2354,-1,2364,217,2356,-1,2364,218,217,-1,2956,2357,2961,-1,2956,3580,2357,-1,1388,2724,3581,-1,2725,2724,1388,-1,2720,3582,225,-1,3582,2720,3583,-1,3584,3585,3426,-1,3585,3584,3586,-1,3587,226,2857,-1,3179,226,3587,-1,3588,3589,2722,-1,3589,3588,3180,-1,1389,229,2858,-1,3590,229,1389,-1,3591,3592,242,-1,3593,3592,3591,-1,3594,3595,2080,-1,3594,2963,3595,-1,3596,2351,3597,-1,3596,2962,2351,-1,3598,3599,3600,-1,3601,3599,3598,-1,2686,3602,2687,-1,3602,2686,3603,-1,2718,3604,3435,-1,2718,2687,3604,-1,2715,3605,3606,-1,3605,2715,3607,-1,3433,3608,2352,-1,3433,3609,3608,-1,3600,237,3610,-1,3599,237,3600,-1,3611,3437,3612,-1,3613,3437,3611,-1,3442,3614,3615,-1,3442,3616,3614,-1,3617,3445,3618,-1,3617,249,3445,-1,251,3619,253,-1,3619,251,3620,-1,3621,3346,3622,-1,3621,268,3346,-1,2707,3623,2708,-1,3623,2707,3624,-1,3625,3626,267,-1,3627,3626,3625,-1,2713,3628,3629,-1,2713,2863,3628,-1,3630,2711,2709,-1,3631,2711,3630,-1,3632,3251,1032,-1,3633,3251,3632,-1,3634,1034,3635,-1,3634,1032,1034,-1,3636,3637,3638,-1,974,3637,3636,-1,3639,954,3640,-1,3639,3641,954,-1,3642,3643,3644,-1,3643,3642,3645,-1,3646,3647,977,-1,3646,3648,3647,-1,3649,3650,3651,-1,3650,3649,3652,-1,3262,3653,980,-1,3262,3654,3653,-1,3251,1035,1033,-1,3248,1035,3251,-1,3655,2981,3656,-1,2981,3655,2307,-1,2343,971,967,-1,971,2343,1025,-1,965,2328,2330,-1,965,3657,2328,-1,2975,2969,1024,-1,3249,2969,2975,-1,3658,3659,3660,-1,3659,3658,3661,-1,1008,3662,2343,-1,3663,3662,1008,-1,2968,3658,1004,-1,2968,2342,3658,-1,2318,3246,2317,-1,3246,2318,3664,-1,3643,2985,3665,-1,3643,1104,2985,-1,3237,3652,3242,-1,3652,3237,3650,-1,974,2301,975,-1,974,3636,2301,-1,3666,3667,3668,-1,3667,3666,3669,-1,2981,3635,1034,-1,2981,1062,3635,-1,3244,3670,3671,-1,3244,1084,3670,-1,2333,3646,3672,-1,2333,2332,3646,-1,960,1067,958,-1,1067,960,1068,-1,957,1090,955,-1,1090,957,1091,-1,2322,2288,3673,-1,2288,2322,2289,-1,3674,2314,2313,-1,3259,2314,3674,-1,3675,1017,3676,-1,1018,1017,3675,-1,3677,3678,3679,-1,3678,3677,3680,-1,1016,1046,3257,-1,1016,992,1046,-1,988,1040,2979,-1,988,987,1040,-1,2330,3681,2345,-1,2330,2329,3681,-1,3682,3683,3684,-1,3685,3683,3682,-1,3686,3687,3250,-1,3686,3688,3687,-1,2976,2338,2974,-1,1020,2338,2976,-1,3689,3655,3690,-1,3689,3691,3655,-1,3544,1007,2320,-1,3692,1007,3544,-1,1020,3693,1035,-1,1020,3255,3693,-1,1020,1023,3255,-1,1020,2976,1023,-1,1050,2319,2977,-1,2319,1050,3261,-1,2318,2978,2315,-1,2318,1052,2978,-1,1015,2339,2325,-1,2339,1015,3258,-1,3259,3256,990,-1,3259,985,3256,-1,3259,3694,985,-1,982,3695,3696,-1,3246,3695,982,-1,3246,3674,3695,-1,3664,3674,3246,-1,3697,3674,3664,-1,3698,3674,3697,-1,3694,3674,3698,-1,3694,3259,3674,-1,3676,3699,3700,-1,3676,3701,3699,-1,3702,3677,3703,-1,3677,3702,3704,-1,1064,2978,1075,-1,2978,1064,2310,-1,3637,1032,3634,-1,1032,3637,3632,-1,1028,1063,3705,-1,1027,1063,1028,-1,3706,3707,1080,-1,3705,3707,3706,-1,2972,1056,2306,-1,1056,2972,3708,-1,3699,2304,3709,-1,3699,1079,2304,-1,3710,3702,3711,-1,3702,3710,3245,-1,2312,3712,1054,-1,2312,3713,3712,-1,3714,1074,1087,-1,1074,3714,1065,-1,3715,3651,3654,-1,3649,3651,3715,-1,3716,3717,3718,-1,3717,3716,3711,-1,2305,3719,3720,-1,1069,3719,2305,-1,3721,3722,3723,-1,3722,3721,3713,-1,3707,1086,3724,-1,3243,1086,3707,-1,3725,3671,3670,-1,3725,3726,3671,-1,1081,3727,3728,-1,3724,3727,1081,-1,3729,3730,3731,-1,3730,3729,3723,-1,2983,3714,3732,-1,3714,2983,2294,-1,1077,981,1101,-1,979,981,1077,-1,3733,3716,3734,-1,3716,3733,3735,-1,3736,3737,3720,-1,3736,3738,3737,-1,3739,3740,3741,-1,3740,3739,951,-1,3727,3742,3743,-1,1085,3742,3727,-1,3731,3744,3745,-1,3738,3744,3731,-1,3746,3238,3747,-1,3238,3746,3732,-1,964,957,956,-1,957,964,3748,-1,3749,1093,3750,-1,1093,3749,3751,-1,3752,3733,3753,-1,3733,3752,3754,-1,3755,3756,3233,-1,3743,3756,3755,-1,2984,1097,2291,-1,1097,2984,2335,-1,1109,3757,3758,-1,3757,1109,3753,-1,3744,3759,3760,-1,3761,3759,3744,-1,3762,3763,3764,-1,3763,3762,1099,-1,1114,3765,3746,-1,1114,3766,3765,-1,3672,1102,2333,-1,3672,3767,1102,-1,3768,3749,3769,-1,3749,3768,3770,-1,1025,3771,3254,-1,1025,3772,3771,-1,2292,2293,3773,-1,2293,2292,2291,-1,3758,3774,3775,-1,3768,3774,3758,-1,3776,2287,3777,-1,3760,2287,3776,-1,3778,3762,3779,-1,3762,3778,3780,-1,3673,3263,3781,-1,3782,3263,3673,-1,3783,3784,3785,-1,3767,3784,3783,-1,2973,2331,991,-1,1018,2331,2973,-1,1018,3786,2331,-1,1018,3680,3786,-1,1018,3678,3680,-1,1018,3787,3678,-1,3675,3787,1018,-1,3787,3675,3788,-1,2287,3789,3777,-1,2287,2286,3789,-1,3778,3555,3790,-1,3779,3555,3778,-1,3791,3792,3793,-1,3791,920,3792,-1,1106,919,1107,-1,1106,3272,919,-1,3784,1010,3794,-1,976,1010,3784,-1,3545,3795,2379,-1,3795,3545,3774,-1,2236,3796,3797,-1,3796,2236,3798,-1,1240,2250,3799,-1,2250,1240,1205,-1,2988,2254,3800,-1,2254,2988,2255,-1,3801,3802,3803,-1,3802,3801,3804,-1,3805,3806,3807,-1,3806,3805,3808,-1,2268,1187,1150,-1,1187,2268,2238,-1,2257,2268,1149,-1,2257,3809,2268,-1,1195,3805,2253,-1,1195,3810,3805,-1,3811,3812,3813,-1,3811,1160,3812,-1,2267,3814,2990,-1,2267,3815,3814,-1,3002,3816,3003,-1,3002,3817,3816,-1,3818,3217,3817,-1,3818,3819,3217,-1,3820,3821,3822,-1,3821,3820,3823,-1,2258,3820,3824,-1,2258,3825,3820,-1,2262,1190,1221,-1,2262,1192,1190,-1,3826,2264,3827,-1,3826,2265,2264,-1,3828,1154,2263,-1,1155,1154,3828,-1,3829,3826,3830,-1,3831,3826,3829,-1,3832,3833,3834,-1,3835,3833,3832,-1,3836,1181,3837,-1,3221,1181,3836,-1,1134,3228,3838,-1,1134,1133,3228,-1,3839,3840,3841,-1,3839,3842,3840,-1,2274,1159,1161,-1,2274,1143,1159,-1,3001,3843,3831,-1,3001,3003,3843,-1,3844,3845,3846,-1,3844,3847,3845,-1,1238,3848,2280,-1,1238,3849,3848,-1,1201,3850,3851,-1,1201,1200,3850,-1,3852,2253,3853,-1,3852,2254,2253,-1,3854,3229,1183,-1,3854,3798,3229,-1,3855,2278,3856,-1,3855,2276,2278,-1,3857,3858,3859,-1,3005,3858,3857,-1,2248,1231,1230,-1,2248,3860,1231,-1,1122,1183,3229,-1,1122,1184,1183,-1,3834,3861,3862,-1,3833,3861,3834,-1,3863,1172,3864,-1,1172,3863,1173,-1,3861,3865,3866,-1,3863,3865,3861,-1,1228,1189,3867,-1,1228,2245,1189,-1,3868,3847,1232,-1,3845,3847,3868,-1,3869,3870,3871,-1,3866,3870,3869,-1,3872,3817,3002,-1,3817,3872,3818,-1,3873,3874,3875,-1,3215,3874,3873,-1,1229,3876,2242,-1,2244,3876,1229,-1,1233,2260,3877,-1,3878,2260,1233,-1,3874,3879,3880,-1,3877,3879,3874,-1,3876,3881,3882,-1,3883,3881,3876,-1,3884,3885,3886,-1,3882,3885,3884,-1,3887,3879,2259,-1,3887,3888,3879,-1,3881,3889,3890,-1,3891,3889,3881,-1,3892,3890,3893,-1,3890,3892,3885,-1,3821,3894,1194,-1,3821,3823,3894,-1,1203,3895,1204,-1,1203,3896,3895,-1,3893,3897,3898,-1,3899,3897,3893,-1,2269,1194,1193,-1,2269,3821,1194,-1,2239,2279,3900,-1,2239,2241,2279,-1,1129,3800,3901,-1,2988,3800,1129,-1,2239,3902,2240,-1,3903,3902,2239,-1,3904,1236,2240,-1,3904,3905,1236,-1,3906,3219,2251,-1,3219,3906,3907,-1,3908,3906,3909,-1,3906,3908,3910,-1,3911,3912,3905,-1,3911,3851,3912,-1,3913,1200,2237,-1,1200,3913,3850,-1,3914,3915,3916,-1,3908,3915,3914,-1,3917,3918,3919,-1,3916,3918,3917,-1,3920,3842,3921,-1,3920,3922,3842,-1,3923,3924,3925,-1,3924,3923,3926,-1,3226,1159,1143,-1,3226,3927,1159,-1,3928,3929,3813,-1,3929,3928,3930,-1,3931,3922,3932,-1,3922,3931,3933,-1,3934,3923,1243,-1,3923,3934,3935,-1,3804,3936,3802,-1,3804,3814,3936,-1,3937,3938,3932,-1,3937,3939,3938,-1,3938,3940,3941,-1,3938,3942,3940,-1,3943,3944,3945,-1,1242,3944,3943,-1,3005,3946,1156,-1,3857,3946,3005,-1,3858,3947,3948,-1,3858,3949,3947,-1,3940,3950,3951,-1,3940,3952,3950,-1,3856,3953,3855,-1,3945,3953,3856,-1,2281,3954,2987,-1,2281,3836,3954,-1,3955,3836,2281,-1,3955,3221,3836,-1,2273,3221,3955,-1,2273,1179,3221,-1,2989,1179,2273,-1,3956,1179,2989,-1,3956,2261,1179,-1,3227,2261,3956,-1,1134,2261,3227,-1,3838,2261,1134,-1,3957,2261,3838,-1,3918,3958,3959,-1,3960,3958,3918,-1,3230,1216,2994,-1,3230,2282,1216,-1,2950,3897,3961,-1,2950,2372,3897,-1,3962,3557,3952,-1,3962,3963,3557,-1,925,3964,3965,-1,3964,925,3953,-1,3966,3967,3968,-1,3966,3969,3967,-1,3970,3971,3972,-1,3970,3973,3971,-1,2184,3969,3974,-1,3967,3969,2184,-1,3975,3976,3977,-1,3975,3978,3976,-1,3979,3980,3981,-1,3979,3982,3980,-1,3983,3984,3981,-1,3983,3985,3984,-1,3986,3987,3988,-1,3986,3989,3987,-1,3990,1247,3991,-1,3990,3992,1247,-1,2166,3993,3994,-1,2166,2165,3993,-1,1301,3993,2232,-1,1301,3995,3993,-1,3996,3018,3997,-1,3018,3996,3019,-1,1306,3025,1347,-1,1306,3998,3025,-1,3999,4000,4001,-1,3999,4002,4000,-1,4003,3006,4004,-1,2230,3006,4003,-1,2183,2228,1340,-1,2183,4005,2228,-1,4006,4007,4008,-1,4006,4009,4007,-1,3008,2170,3198,-1,2170,3008,1324,-1,4010,1353,2171,-1,1300,1353,4010,-1,1298,1264,1263,-1,1298,3030,1264,-1,2224,3999,4011,-1,3999,2224,1303,-1,3012,2216,2215,-1,2216,3012,3014,-1,4012,1332,4013,-1,4012,3197,1332,-1,2208,1291,2209,-1,2208,2210,1291,-1,1338,4014,3033,-1,1338,1337,4014,-1,2175,3017,3019,-1,2175,1266,3017,-1,1335,4015,4016,-1,1335,4017,4015,-1,4018,4019,3973,-1,4018,4020,4019,-1,4021,3977,4022,-1,4021,3975,3977,-1,3020,4023,2205,-1,3020,4024,4023,-1,4025,4026,4027,-1,4025,4028,4026,-1,4029,4030,4031,-1,4029,4032,4030,-1,4033,4034,4035,-1,4036,4034,4033,-1,4037,3016,2209,-1,4037,4038,3016,-1,4039,4040,4041,-1,4040,4039,4023,-1,2168,4042,3032,-1,4042,2168,4043,-1,4044,4010,4045,-1,4044,4046,4010,-1,4047,2226,2197,-1,4047,3995,2226,-1,4048,3025,3998,-1,3025,4048,4049,-1,3203,1309,3023,-1,3203,4050,1309,-1,4051,1356,4052,-1,4051,4053,1356,-1,1268,4053,4054,-1,4053,1268,4055,-1,1343,1357,1339,-1,3192,1357,1343,-1,3203,1274,3210,-1,3203,3202,1274,-1,3201,4050,1271,-1,1309,4050,3201,-1,4056,2194,1328,-1,4057,2194,4056,-1,4005,2196,2228,-1,2196,4005,4058,-1,1251,1314,2201,-1,1251,1253,1314,-1,1258,4059,2229,-1,4059,1258,4060,-1,3025,1262,1261,-1,4049,1262,3025,-1,3970,2188,2187,-1,3970,1252,2188,-1,4061,4062,4063,-1,4064,4062,4061,-1,3024,4065,1312,-1,3024,4066,4065,-1,4067,1352,1351,-1,4067,2164,1352,-1,2193,2189,2191,-1,2193,4068,2189,-1,4069,2191,2190,-1,3200,2191,4069,-1,4070,2199,1313,-1,4070,3009,2199,-1,4071,3208,4034,-1,3208,4071,3209,-1,3032,4045,2169,-1,4044,4045,3032,-1,4019,3966,4072,-1,3966,4019,3969,-1,4073,4020,4074,-1,3974,4020,4073,-1,4075,2207,3015,-1,4075,4076,2207,-1,4077,3024,1259,-1,4077,4066,3024,-1,3015,4078,4075,-1,1277,4078,3015,-1,4079,4080,4081,-1,4080,4079,4013,-1,1279,3967,2184,-1,1278,3967,1279,-1,4007,3199,4082,-1,4007,4009,3199,-1,3029,1339,1338,-1,1339,3029,1343,-1,2206,2166,4083,-1,2206,2167,2166,-1,4084,4046,4031,-1,4046,4084,3205,-1,2214,4085,2215,-1,2214,4086,4085,-1,2176,4087,2235,-1,3996,4087,2176,-1,2224,4061,2192,-1,2224,4011,4061,-1,4088,3207,2217,-1,4088,2204,3207,-1,1297,4027,4026,-1,1297,1296,4027,-1,2220,4039,4008,-1,4039,2220,1293,-1,1266,4054,3017,-1,4054,1266,1268,-1,3566,4089,4090,-1,3566,4091,4089,-1,4092,3567,4093,-1,4065,3567,4092,-1,2367,3027,4063,-1,2367,2366,3027,-1,4067,3034,2164,-1,4067,3570,3034,-1,1319,2371,1320,-1,1319,2951,2371,-1,3190,3023,3022,-1,4094,3023,3190,-1,4094,3202,3023,-1,4095,1368,3187,-1,4096,1368,4095,-1,4097,1371,2163,-1,4097,4098,1371,-1,4097,4099,4098,-1,4096,4097,1368,-1,4096,4099,4097,-1,4100,4101,4102,-1,4101,4100,4103,-1,4104,4105,4106,-1,4105,4104,3035,-1,4107,4095,4108,-1,4095,4107,4096,-1,4109,4110,4111,-1,4110,4109,1372,-1,4112,4113,4114,-1,1363,4113,4112,-1,4115,4100,4116,-1,4100,4115,4117,-1,3186,4104,1374,-1,4104,3186,3188,-1,1369,4118,2160,-1,4119,4118,1369,-1,4120,4121,4122,-1,4121,4120,4111,-1,4114,4123,4124,-1,4113,4123,4114,-1,4116,1379,4115,-1,4116,1377,1379,-1,4125,2159,4126,-1,4127,2159,4125,-1,2161,4128,4129,-1,2161,4130,4128,-1,4128,2156,4131,-1,4128,4132,2156,-1,4133,4134,4135,-1,4134,4133,4136,-1,4137,3183,1385,-1,4138,3183,4137,-1,1376,3040,3041,-1,1375,3040,1376,-1,4139,4140,3184,-1,4141,4140,4139,-1,2157,4132,4142,-1,4132,2157,2156,-1,4143,4135,4144,-1,4135,4143,4133,-1,4145,1378,4146,-1,1378,4145,3185,-1,4147,3041,3040,-1,4147,2153,3041,-1,4148,2153,4149,-1,2153,4148,2154,-1,4150,1381,1380,-1,4150,4151,1381,-1,4152,3042,4153,-1,3042,4152,4154,-1,4155,4156,4157,-1,4158,4156,4155,-1,4159,4146,4160,-1,4146,4159,4145,-1,4161,4159,4162,-1,4159,4161,4163,-1,4164,4149,4165,-1,4149,4164,4148,-1,4151,4166,4167,-1,4150,4166,4151,-1,4152,4168,4169,-1,4153,4168,4152,-1,4157,4170,4171,-1,4156,4170,4157,-1,4162,4160,4172,-1,4160,4162,4159,-1,2358,4161,4162,-1,2358,2357,4161,-1,4173,4164,4165,-1,4173,2355,4164,-1,4174,4167,4166,-1,4174,4175,4167,-1,4169,3574,3573,-1,4168,3574,4169,-1,4170,3269,4171,-1,4170,2362,3269,-1,4176,4177,4178,-1,4176,3583,4177,-1,3043,4179,2152,-1,3043,3590,4179,-1,3587,4180,4181,-1,3587,4182,4180,-1,4183,3585,4184,-1,4183,4185,3585,-1,4186,3054,4187,-1,4186,1440,3054,-1,3053,4188,4189,-1,4188,3053,4190,-1,2151,4191,4192,-1,2151,2121,4191,-1,4193,4194,1418,-1,4193,4195,4194,-1,2147,3170,2148,-1,2147,4196,3170,-1,4197,2123,4198,-1,4199,2123,4197,-1,4200,3059,3061,-1,4200,4201,3059,-1,2136,3056,3058,-1,2136,4202,3056,-1,4203,4204,3047,-1,4203,1443,4204,-1,4205,4206,4207,-1,4205,4208,4206,-1,4209,4210,4211,-1,4209,4212,4210,-1,1398,4213,1421,-1,1398,4214,4213,-1,4215,2143,1426,-1,4215,3178,2143,-1,4216,4217,4218,-1,4217,4216,4219,-1,3174,2150,4220,-1,3174,4187,2150,-1,1419,4221,4222,-1,1419,4223,4221,-1,4215,2126,4224,-1,2126,4215,2127,-1,4225,4217,4226,-1,4225,4227,4217,-1,4228,1448,1447,-1,4228,4229,1448,-1,4230,3047,3046,-1,4230,4203,3047,-1,4231,4232,4233,-1,4231,4234,4232,-1,4231,4222,4221,-1,4231,4235,4222,-1,4236,4208,4237,-1,4236,4206,4208,-1,2131,4238,4239,-1,4238,2131,1429,-1,4236,2128,3051,-1,2128,4236,4226,-1,4240,4203,4230,-1,4240,1415,4203,-1,4201,4241,4242,-1,4241,4201,2134,-1,4243,4244,4245,-1,4244,4243,4239,-1,2124,2140,2149,-1,2140,2124,1409,-1,4246,3045,4247,-1,3045,4246,3177,-1,2123,3054,1439,-1,2123,2122,3054,-1,2146,1400,4195,-1,2148,1400,2146,-1,1401,1404,3055,-1,1404,1401,2138,-1,1435,1411,2137,-1,1435,4248,1411,-1,4249,2130,3176,-1,2130,4249,3051,-1,4250,4251,4252,-1,4250,4253,4251,-1,3060,4254,4255,-1,4254,3060,3059,-1,3056,4256,1444,-1,4257,4256,3056,-1,4258,4259,3048,-1,4258,4260,4259,-1,4261,4240,4262,-1,4240,4261,4263,-1,4264,4265,4266,-1,4265,4264,4253,-1,2119,4267,4255,-1,2119,2118,4267,-1,4267,1395,4268,-1,4267,4269,1395,-1,4180,1445,4270,-1,4180,4271,1445,-1,4260,1394,2152,-1,3167,1394,4260,-1,4272,1386,4262,-1,4272,1391,1386,-1,4176,4273,4274,-1,4273,4176,4266,-1,3063,4275,2118,-1,3063,4184,4275,-1,1523,4276,1521,-1,4277,4276,1523,-1,4278,4279,4280,-1,4278,4281,4279,-1,4282,3077,4283,-1,4282,1520,3077,-1,3078,2103,4284,-1,3078,2114,2103,-1,4285,1462,2105,-1,4285,2112,1462,-1,2111,3066,1454,-1,2111,2110,3066,-1,2108,4286,2099,-1,2108,4287,4286,-1,1457,2097,1466,-1,1456,2097,1457,-1,4288,4280,4289,-1,4288,4278,4280,-1,4290,1452,4291,-1,4290,3166,1452,-1,4292,3067,2104,-1,3067,4292,4293,-1,1509,3068,1508,-1,1509,4294,3068,-1,3158,2101,2100,-1,3158,4295,2101,-1,4296,1512,4297,-1,4296,4298,1512,-1,4299,4300,4301,-1,4299,3164,4300,-1,4302,3164,4299,-1,4302,1476,3164,-1,4302,4303,1476,-1,2095,4304,2058,-1,2095,2111,4304,-1,2093,4277,1523,-1,4301,4277,2093,-1,4305,4306,4307,-1,4308,4306,4305,-1,2066,4309,3081,-1,2066,4310,4309,-1,4311,2353,4312,-1,4311,4313,2353,-1,4314,2089,4315,-1,3071,2089,4314,-1,4316,3601,3598,-1,4316,4317,3601,-1,2087,2088,2079,-1,2087,2086,2088,-1,4318,2084,2083,-1,2084,4318,4319,-1,4320,944,4321,-1,944,4320,3603,-1,4322,4323,4324,-1,4322,4325,4323,-1,4326,4327,4328,-1,4327,4326,4329,-1,4330,2064,2081,-1,4330,4331,2064,-1,1526,4332,1537,-1,1525,4332,1526,-1,4333,4334,4335,-1,4334,4333,4293,-1,1531,4336,4337,-1,4336,1531,4291,-1,4338,3073,4339,-1,3073,4338,4340,-1,1509,4341,4342,-1,1509,1505,4341,-1,4309,1529,1530,-1,4309,4343,1529,-1,2078,2072,2071,-1,2078,2065,2072,-1,3154,2077,3155,-1,3154,4344,2077,-1,2069,1504,1503,-1,2098,1504,2069,-1,3074,4345,4346,-1,3074,4347,4345,-1,2076,1517,4289,-1,2076,1518,1517,-1,1513,1528,4348,-1,1513,4349,1528,-1,3069,4349,2100,-1,3069,4350,4349,-1,4351,4352,4353,-1,4343,4352,4351,-1,1450,2116,1451,-1,2116,1450,1477,-1,4277,3078,4276,-1,3079,3078,4277,-1,4354,1451,2116,-1,4354,4355,1451,-1,4295,3165,2101,-1,3165,4295,4356,-1,1456,2099,2097,-1,2108,2099,1456,-1,4357,3162,1492,-1,3160,3162,4357,-1,4337,4345,4347,-1,4358,4345,4337,-1,3075,4333,4359,-1,4333,3075,4360,-1,4361,3157,4362,-1,1517,3157,4361,-1,4328,4363,4326,-1,4363,4328,3161,-1,2064,4332,1494,-1,2064,4331,4332,-1,2089,4364,4365,-1,1483,4364,2089,-1,1486,1487,3082,-1,1486,1488,1487,-1,2083,4366,4318,-1,2083,4321,4366,-1,4367,2086,4325,-1,2086,4367,2088,-1,4368,4369,4370,-1,4371,4369,4368,-1,4372,4373,4374,-1,4373,4372,4375,-1,4376,4377,4378,-1,4377,4376,4379,-1,4380,4381,4382,-1,4381,4380,4383,-1,4384,4385,4386,-1,4387,4385,4384,-1,4388,4389,4390,-1,4389,4388,4382,-1,4391,4392,4393,-1,4392,4391,4378,-1,4394,4395,4374,-1,4394,4396,4395,-1,4369,2057,4397,-1,4398,2057,4369,-1,4399,4400,4401,-1,4397,4400,4399,-1,4402,4403,4404,-1,4402,4405,4403,-1,4406,4407,4408,-1,4407,4406,4409,-1,4410,4411,4412,-1,4411,4410,4413,-1,4414,2055,3083,-1,4414,4415,2055,-1,2056,1539,1541,-1,2055,1539,2056,-1,4416,4417,4418,-1,4419,4417,4416,-1,4420,4421,4422,-1,4421,4420,4423,-1,4424,4425,4426,-1,4425,4424,4427,-1,4428,4429,4430,-1,4429,4428,4431,-1,4432,4428,4433,-1,4428,4432,4434,-1,4418,4435,4436,-1,4417,4435,4418,-1,4437,4422,4438,-1,4422,4437,4420,-1,4439,4426,4440,-1,4426,4439,4424,-1,4441,4439,4442,-1,4439,4441,4443,-1,4444,4433,4445,-1,4433,4444,4432,-1,4446,4447,4448,-1,4449,4447,4446,-1,4450,4451,4452,-1,4450,4453,4451,-1,4454,4455,4456,-1,4455,4454,4457,-1,4458,4454,4459,-1,4454,4458,4460,-1,4461,4462,4463,-1,4462,4461,4464,-1,4465,4466,4467,-1,4468,4466,4465,-1,4469,4470,4471,-1,4472,4470,4469,-1,4473,4474,4475,-1,4476,4474,4473,-1,4477,4475,4478,-1,4475,4477,4479,-1,4480,4481,4482,-1,4481,4480,4483,-1,4484,4485,4486,-1,4485,4484,4487,-1,4488,4489,4490,-1,4491,4489,4488,-1,4492,3613,3611,-1,4490,3613,4492,-1,4493,3615,3614,-1,4494,3615,4493,-1,3618,4495,3617,-1,4495,3618,4496,-1,3620,4497,3619,-1,4497,3620,4498,-1,4499,4500,4501,-1,4502,4500,4499,-1,4503,4504,4505,-1,4506,4504,4503,-1,3085,4507,3086,-1,3085,4508,4507,-1,4509,1556,4510,-1,1556,4509,4511,-1,2053,4512,4513,-1,2052,4512,2053,-1,4514,4515,4508,-1,4514,4516,4515,-1,4517,1548,4518,-1,1548,4517,4504,-1,4519,1542,3087,-1,1542,4519,1546,-1,4520,4519,4521,-1,4519,4520,4522,-1,4523,2050,3088,-1,4513,2050,4523,-1,4524,4525,4526,-1,4516,4525,4524,-1,4527,4517,4528,-1,4517,4527,4529,-1,4530,4527,4531,-1,4527,4530,4532,-1,4533,4534,4535,-1,4534,4533,4521,-1,2050,4536,2051,-1,4537,4536,2050,-1,4538,4525,4539,-1,4538,4540,4525,-1,4541,4542,4543,-1,4542,4541,4528,-1,4544,4541,4545,-1,4541,4544,4531,-1,4546,4547,4548,-1,4547,4546,4535,-1,4536,4549,4550,-1,4551,4549,4536,-1,4552,4553,4554,-1,4540,4553,4552,-1,4555,4556,4557,-1,4554,4556,4555,-1,4558,4544,4559,-1,4544,4558,4560,-1,4561,4546,4562,-1,4546,4561,4563,-1,1553,4564,4565,-1,4550,4564,1553,-1,4566,4567,4568,-1,4565,4567,4566,-1,4556,4569,4570,-1,4571,4569,4556,-1,4572,4573,4574,-1,4573,4572,4559,-1,4575,4576,4577,-1,4576,4575,4562,-1,4564,4578,4579,-1,4580,4578,4564,-1,4567,4581,4582,-1,4579,4581,4567,-1,4569,4583,4584,-1,4585,4583,4569,-1,4586,4587,4588,-1,4587,4586,4574,-1,4589,4590,4591,-1,4590,4589,4577,-1,4589,3623,4592,-1,4589,4593,3623,-1,4581,4594,3627,-1,4595,4594,4581,-1,2965,4583,4596,-1,2965,3629,4583,-1,4588,4597,3631,-1,4598,4597,4588,-1,4599,4600,3622,-1,4600,4599,4591,-1,4601,4602,4603,-1,4601,1601,4602,-1,3124,1862,1886,-1,3124,1863,1862,-1,2038,1855,1940,-1,2037,1855,2038,-1,1589,1574,1590,-1,1589,1572,1574,-1,1668,1926,2034,-1,3144,1926,1668,-1,1957,1964,1808,-1,2030,1964,1957,-1,2042,3118,1681,-1,2042,3091,3118,-1,1625,2026,1795,-1,2026,1625,1624,-1,1692,4604,2024,-1,1692,1641,4604,-1,3098,3105,3134,-1,3105,3098,4605,-1,3125,4606,3097,-1,3125,1888,4606,-1,4604,1888,1674,-1,1888,4604,4606,-1,3496,1656,1655,-1,1656,3496,1992,-1,2015,1990,2563,-1,2015,3100,1990,-1,569,1720,573,-1,569,1721,1720,-1,1949,2010,2043,-1,1949,1948,2010,-1,1672,569,3143,-1,1672,1721,569,-1,1606,1846,1845,-1,1605,1846,1606,-1,1897,2006,1896,-1,1897,1827,2006,-1,1764,4607,3119,-1,4607,1764,3138,-1,3127,2002,3103,-1,3126,2002,3127,-1,1688,3101,1686,-1,3101,1688,1915,-1,3103,2816,4608,-1,3102,2816,3103,-1,3137,4609,1954,-1,1604,4609,3137,-1,2049,1844,1881,-1,1844,2049,1708,-1,1598,2048,1557,-1,1598,1597,2048,-1,3096,1744,1991,-1,3096,1984,1744,-1,1986,1993,1992,-1,1986,1747,1993,-1,3139,1980,1981,-1,1980,3139,1917,-1,1979,3111,1760,-1,1979,1783,3111,-1,3131,4602,4610,-1,3131,4611,4602,-1,1796,1913,1632,-1,1906,1913,1796,-1,1971,1636,3108,-1,1636,1971,1633,-1,3106,4612,4613,-1,4614,4612,3106,-1,1652,3110,3109,-1,1652,1968,3110,-1,1903,1966,3112,-1,1967,1966,1903,-1,1826,1998,1854,-1,1826,1695,1998,-1,1951,1619,1960,-1,1951,1620,1619,-1,1959,1811,1894,-1,1959,1958,1811,-1,1961,1964,2030,-1,1961,1965,1964,-1,1616,1818,2027,-1,1818,1616,1618,-1,1950,4615,1817,-1,4615,1950,2035,-1,1667,1824,4616,-1,3120,1824,1667,-1,1669,2028,2012,-1,1845,2028,1669,-1,3136,1927,1835,-1,1839,1927,3136,-1,1850,1829,1851,-1,1945,1829,1850,-1,4617,1946,4618,-1,4619,1946,4617,-1,4620,2035,2036,-1,4620,4615,2035,-1,1843,1997,4621,-1,1707,1997,1843,-1,3133,3119,1944,-1,3133,1933,3119,-1,4618,1849,1861,-1,4618,3121,1849,-1,1603,1817,4615,-1,1603,1602,1817,-1,1867,1934,1559,-1,1867,1866,1934,-1,1936,1653,1710,-1,1653,1936,1654,-1,4605,1650,2022,-1,1650,4605,3098,-1,4617,1861,1860,-1,4617,4618,1861,-1,3138,1603,4607,-1,4610,1603,3138,-1,4622,1921,1892,-1,1921,4622,4623,-1,4624,1919,4625,-1,4624,1920,1919,-1,1802,1811,1800,-1,1802,3114,1811,-1,1751,1724,4626,-1,1751,1725,1724,-1,1983,1917,1741,-1,1983,1980,1917,-1,3129,1748,1907,-1,3129,1908,1748,-1,1907,1905,3129,-1,1907,1787,1905,-1,1916,3128,1914,-1,1916,3126,3128,-1,4624,3139,1981,-1,4624,1902,3139,-1,1900,3104,1901,-1,3104,1900,3116,-1,1902,4625,3130,-1,1902,4624,4625,-1,1698,4627,1899,-1,1698,3142,4627,-1,4611,1895,1975,-1,1895,4611,3131,-1,1803,1853,1999,-1,1803,1889,1853,-1,1621,1675,1887,-1,1621,4628,1675,-1,1947,4629,1948,-1,4629,1947,4616,-1,1881,1869,1559,-1,1869,1881,4630,-1,4630,1858,1869,-1,1858,4630,1859,-1,1874,1865,1629,-1,1874,1866,1865,-1,1876,1557,1934,-1,1876,1704,1557,-1,1855,1859,1856,-1,1855,2045,1859,-1,1560,3125,3089,-1,1560,3135,3125,-1,1881,1848,4630,-1,1848,1881,1844,-1,1939,1852,1851,-1,1939,1857,1852,-1,4621,1836,1843,-1,4621,1837,1836,-1,3133,1997,1932,-1,4621,1997,3133,-1,3144,1841,1926,-1,1842,1841,3144,-1,1835,4617,1836,-1,1835,4619,4617,-1,2005,1835,1927,-1,2005,4619,1835,-1,1829,1681,3118,-1,1828,1681,1829,-1,4609,1815,1954,-1,4609,2033,1815,-1,1952,3115,1807,-1,3115,1952,1951,-1,1819,1816,3117,-1,1819,1955,1816,-1,1879,1619,1599,-1,1619,1879,1821,-1,1961,1820,1965,-1,1960,1820,1961,-1,1919,4623,4625,-1,4623,1919,1921,-1,1892,1923,1637,-1,1923,1892,1921,-1,2021,1799,1765,-1,1799,2021,3122,-1,4614,1762,4612,-1,4614,1978,1762,-1,1770,1794,1771,-1,1770,1792,1794,-1,1777,1770,1976,-1,1770,1777,1972,-1,1768,1773,1769,-1,1774,1773,1768,-1,4603,4611,4613,-1,4602,4611,4603,-1,1758,1749,1975,-1,1757,1749,1758,-1,1750,1753,1752,-1,1753,1750,1757,-1,1966,1783,1782,-1,3111,1783,1966,-1,1658,1732,1733,-1,1664,1732,1658,-1,1727,1730,1729,-1,1727,1726,1730,-1,1995,4631,3140,-1,1995,1994,4631,-1,4631,1879,1878,-1,1617,1879,4631,-1,1995,1706,1711,-1,1995,3140,1706,-1,1996,1711,1932,-1,1995,1711,1996,-1,1809,1611,1901,-1,1809,1612,1611,-1,1702,2817,3141,-1,1687,2817,1702,-1,2004,1685,1690,-1,2004,1688,1685,-1,4608,3127,3103,-1,3127,4608,3128,-1,1927,1942,2005,-1,1942,1927,1925,-1,2019,1675,1893,-1,2019,1673,1675,-1,1575,3093,1615,-1,3094,3093,1575,-1,2904,1988,1989,-1,2904,3497,1988,-1,1664,3145,1661,-1,1664,1658,3145,-1,2563,1671,1670,-1,1671,2563,1990,-1,1645,4632,3089,-1,4632,1645,2025,-1,1935,4605,1936,-1,1935,3105,4605,-1,4606,1641,1640,-1,1641,4606,4604,-1,1795,1646,1625,-1,1795,3149,1646,-1,1622,1886,1623,-1,1622,3124,1886,-1,1842,1573,1680,-1,3094,1573,1842,-1,1601,4610,4602,-1,1603,4610,1601,-1,3092,2046,2037,-1,1594,2046,3092,-1,1593,1594,3092,-1,1592,1594,1593,-1,2046,1855,2037,-1,2046,2045,1855,-1,1892,1890,4622,-1,1890,1892,1891,-1,3622,4633,3621,-1,4633,3622,4600,-1,4598,4634,4597,-1,4635,4634,4598,-1,4596,4636,2965,-1,4637,4636,4596,-1,4594,4638,4639,-1,4638,4594,4595,-1,4638,4640,4641,-1,4640,4638,4642,-1,4591,4643,4600,-1,4643,4591,4590,-1,4587,4598,4588,-1,4644,4598,4587,-1,4585,4596,4583,-1,4645,4596,4585,-1,4595,4579,4578,-1,4595,4581,4579,-1,4578,4646,4642,-1,4646,4578,4580,-1,4647,4577,4576,-1,4647,4590,4577,-1,4574,4648,4587,-1,4648,4574,4573,-1,4571,4585,4569,-1,4649,4585,4571,-1,4650,4651,4652,-1,4650,4649,4651,-1,4550,4580,4564,-1,4549,4580,4550,-1,4548,4562,4546,-1,4548,4576,4562,-1,4559,4545,4573,-1,4545,4559,4544,-1,4554,4571,4556,-1,4553,4571,4554,-1,4540,4651,4553,-1,4538,4651,4540,-1,2051,4550,1553,-1,4536,4550,2051,-1,4563,4535,4546,-1,4535,4563,4533,-1,4560,4531,4544,-1,4531,4560,4530,-1,4531,4528,4541,-1,4528,4531,4527,-1,4526,4540,4552,-1,4525,4540,4526,-1,4537,4551,4536,-1,4653,4551,4537,-1,4654,4535,4534,-1,4654,4547,4535,-1,4654,1551,4655,-1,1551,4654,1552,-1,4528,4518,4542,-1,4518,4528,4517,-1,4539,4516,4514,-1,4539,4525,4516,-1,4513,4537,2050,-1,4512,4537,4513,-1,4521,3087,4534,-1,3087,4521,4519,-1,1551,4656,4657,-1,4656,1551,1550,-1,1548,4658,4518,-1,1547,4658,1548,-1,4508,4659,4514,-1,3085,4659,4508,-1,2052,4660,4512,-1,4509,4660,2052,-1,4515,4507,4508,-1,4507,4515,4661,-1,4504,1549,1548,-1,1549,4504,4506,-1,1544,4662,1550,-1,4662,1544,1543,-1,4373,4663,4664,-1,4665,4387,4384,-1,4665,4666,4387,-1,4381,4666,4665,-1,4381,4667,4666,-1,4383,4667,4381,-1,4383,4368,4667,-1,4668,4368,4383,-1,4668,4371,4368,-1,4669,4371,4668,-1,4669,4670,4371,-1,4377,4670,4669,-1,4377,4671,4670,-1,4377,4375,4671,-1,4379,4375,4377,-1,4663,4375,4379,-1,4663,4373,4375,-1,4500,4484,4672,-1,4484,4500,4502,-1,3619,4480,4673,-1,4480,3619,4497,-1,3617,4477,4674,-1,4477,3617,4495,-1,4494,4675,3615,-1,4676,4675,4494,-1,4677,4678,4676,-1,4471,4678,4677,-1,4491,4499,4489,-1,4467,4499,4491,-1,4486,4461,4498,-1,4461,4486,4485,-1,4482,4458,4496,-1,4458,4482,4481,-1,4475,4493,4478,-1,4474,4493,4475,-1,4476,4679,4474,-1,4453,4679,4476,-1,4472,4488,4470,-1,4448,4488,4472,-1,4466,4444,4487,-1,4444,4466,4468,-1,4463,4441,4483,-1,4441,4463,4462,-1,4459,4456,4479,-1,4456,4459,4454,-1,4456,4437,4473,-1,4437,4456,4455,-1,4452,4469,4450,-1,4436,4469,4452,-1,4449,4465,4447,-1,3151,4465,4449,-1,4445,4680,4464,-1,4680,4445,4433,-1,4442,4440,4460,-1,4440,4442,4439,-1,4440,4681,4457,-1,4681,4440,4426,-1,4451,4422,4682,-1,4451,4438,4422,-1,4417,4446,4435,-1,4683,4446,4417,-1,1540,4434,4432,-1,4434,1540,1539,-1,4434,4431,4428,-1,4431,4434,4415,-1,4684,4427,4424,-1,4427,4684,4412,-1,4685,4423,4420,-1,4423,4685,4408,-1,4402,4418,4686,-1,4416,4418,4402,-1,4400,1541,4687,-1,2056,1541,4400,-1,4415,4395,4431,-1,4395,4415,4414,-1,4412,4391,4427,-1,4391,4412,4411,-1,4408,4388,4423,-1,4388,4408,4407,-1,4404,4416,4402,-1,4688,4416,4404,-1,4689,4690,4688,-1,4691,4690,4689,-1,4398,3083,2057,-1,4692,3083,4398,-1,4693,4396,4394,-1,4693,4413,4396,-1,4393,4694,4409,-1,4694,4393,4392,-1,4390,4386,4403,-1,4386,4390,4389,-1,4689,4387,4666,-1,4689,4385,4387,-1,4668,4380,4694,-1,4383,4380,4668,-1,4693,4379,4376,-1,4379,4693,4663,-1,4692,4375,4372,-1,4375,4692,4671,-1,4667,4370,4691,-1,4368,4370,4667,-1,4318,4695,4696,-1,4318,4366,4695,-1,4316,1486,1485,-1,4316,1488,1486,-1,4311,1483,2090,-1,4311,4364,1483,-1,4332,1538,1537,-1,4332,4331,1538,-1,3072,4326,4363,-1,3072,4697,4326,-1,1502,4360,3075,-1,4360,1502,1535,-1,4338,1533,3153,-1,1533,4338,4698,-1,4358,4362,4345,-1,4361,4362,4358,-1,4314,1470,4699,-1,4314,1471,1470,-1,1527,1492,1482,-1,4357,1492,1527,-1,1525,3155,1495,-1,3155,1525,3154,-1,2106,1460,4700,-1,2106,1463,1460,-1,2101,1455,2102,-1,1455,2101,3165,-1,4701,4354,4702,-1,4701,4355,4354,-1,1521,4703,4704,-1,4276,4703,1521,-1,1478,3065,3064,-1,1478,1520,3065,-1,4279,4705,4706,-1,4705,4279,4306,-1,4350,4342,4341,-1,4342,4350,3069,-1,1510,1515,1514,-1,1515,1510,3159,-1,1514,4348,4699,-1,1514,1513,4348,-1,4288,1517,4361,-1,4289,1517,4288,-1,4345,4707,4346,-1,4345,4362,4707,-1,1464,1506,1508,-1,1464,4344,1506,-1,4344,1507,1506,-1,1507,4344,3154,-1,3070,1499,1496,-1,3070,1500,1499,-1,3070,2071,3080,-1,3070,2078,2071,-1,4343,4310,4352,-1,4310,4343,4309,-1,4343,1511,1529,-1,4343,4351,1511,-1,3153,4340,4338,-1,4340,3153,4319,-1,1533,4291,1531,-1,4291,1533,4290,-1,4360,4293,4333,-1,4293,4360,3067,-1,1494,1525,1495,-1,1494,4332,1525,-1,4313,2351,2353,-1,4313,3152,2351,-1,3594,4328,4327,-1,3594,4708,4328,-1,3593,4325,4322,-1,3593,4367,4325,-1,4321,3267,4366,-1,3267,4321,944,-1,4696,4319,4318,-1,4319,4696,4340,-1,3598,1488,4316,-1,1489,1488,3598,-1,1471,4315,1485,-1,4314,4315,1471,-1,4364,4312,941,-1,4364,4311,4312,-1,4310,2092,2091,-1,2092,4310,2066,-1,2116,4303,4354,-1,4303,2116,1476,-1,4306,4709,4705,-1,4709,4306,4308,-1,1454,4304,2111,-1,4304,1454,4710,-1,4301,4709,4299,-1,2094,4301,2093,-1,4709,4301,2094,-1,1512,4711,3159,-1,1512,4298,4711,-1,4342,4294,1509,-1,4342,4712,4294,-1,4293,4282,4334,-1,4293,4292,4282,-1,4291,4713,4336,-1,4291,1452,4713,-1,4289,4714,2076,-1,4289,4280,4714,-1,4704,2067,3076,-1,4704,4703,2067,-1,4298,2113,2112,-1,4296,2113,4298,-1,1453,4710,1454,-1,1453,2096,4710,-1,1453,4356,1473,-1,1453,3165,4356,-1,4276,4284,4703,-1,4276,3078,4284,-1,4283,1450,3166,-1,4283,3077,1450,-1,4701,4278,4715,-1,4701,4281,4278,-1,4716,1521,4704,-1,4716,3156,1521,-1,4266,4178,4264,-1,4266,4176,4178,-1,3182,4262,1386,-1,4262,3182,4261,-1,4259,2152,4179,-1,4260,2152,4259,-1,1446,4271,4717,-1,1445,4271,1446,-1,1397,4268,1395,-1,4268,1397,4718,-1,4268,4255,4267,-1,4255,4268,3060,-1,4266,4719,4273,-1,4719,4266,4265,-1,4262,4230,4272,-1,4230,4262,4240,-1,3167,4258,1447,-1,3167,4260,4258,-1,1444,4270,1445,-1,4256,4270,1444,-1,4257,4720,4256,-1,4721,4720,4257,-1,4209,4255,4254,-1,4209,2119,4255,-1,4205,4253,4250,-1,4205,4265,4253,-1,3176,3052,1414,-1,3052,3176,2130,-1,1435,2135,4248,-1,1437,2135,1435,-1,4722,4195,4193,-1,2146,4195,4722,-1,3170,3171,3168,-1,1441,3171,3170,-1,4247,3044,4189,-1,3044,4247,3045,-1,4210,4239,4243,-1,4239,4210,2131,-1,4723,4719,4207,-1,4719,4723,4724,-1,4226,4237,4225,-1,4226,4236,4237,-1,2134,4725,4241,-1,4725,2134,2133,-1,4235,3172,4222,-1,4235,1436,3172,-1,4234,4200,4232,-1,4234,3050,4200,-1,1442,1433,3173,-1,1433,1442,2127,-1,1412,1447,4258,-1,1412,4228,1447,-1,1429,4220,4238,-1,1429,3174,4220,-1,4226,4219,2128,-1,4226,4217,4219,-1,2127,1426,1433,-1,2127,4215,1426,-1,1416,1438,1434,-1,1416,2141,1438,-1,4223,1423,4221,-1,4223,3175,1423,-1,1431,4187,3174,-1,1431,4186,4187,-1,4218,4227,4192,-1,4227,4218,4217,-1,3178,4224,4190,-1,4224,3178,4215,-1,1399,1421,3175,-1,1399,1398,1421,-1,4243,4211,4210,-1,4211,4243,4252,-1,4207,4249,4723,-1,4207,4206,4249,-1,1443,1415,1414,-1,1415,1443,4203,-1,4228,1411,4248,-1,1412,1411,4228,-1,4202,4257,3056,-1,4202,4233,4257,-1,4196,1441,3170,-1,4196,4726,1441,-1,3177,4197,2144,-1,4199,4197,3177,-1,2145,1409,1408,-1,1409,2145,2140,-1,2120,1418,1417,-1,2120,4193,1418,-1,3169,4214,1398,-1,3169,3168,4214,-1,4216,4189,4188,-1,4216,4247,4189,-1,4727,1440,4186,-1,4727,3171,1440,-1,4178,4185,4183,-1,4178,4177,4185,-1,1396,4269,4728,-1,4269,1396,1395,-1,4182,4271,4180,-1,4182,4729,4271,-1,1389,4179,3590,-1,4179,1389,3181,-1,3182,3581,4730,-1,3182,1388,3581,-1,2145,4731,1405,-1,2145,2147,4731,-1,4198,2144,4197,-1,4732,2144,4198,-1,4732,1408,2144,-1,4726,1408,4732,-1,4196,1408,4726,-1,4196,2145,1408,-1,2145,4196,2147,-1,4733,2362,4170,-1,4733,2960,2362,-1,4168,3579,3574,-1,4734,3579,4168,-1,4735,4166,4736,-1,4735,4174,4166,-1,4737,4165,4738,-1,4737,4173,4165,-1,2358,4172,3571,-1,4172,2358,4162,-1,4172,4739,4740,-1,4739,4172,4160,-1,4741,4170,4156,-1,4741,4733,4170,-1,4153,4734,4168,-1,4742,4734,4153,-1,4166,4743,4736,-1,4743,4166,4150,-1,4165,4744,4738,-1,4744,4165,4149,-1,4744,4745,4746,-1,4745,4744,4147,-1,1384,4160,4146,-1,1384,4739,4160,-1,4158,4741,4156,-1,4143,4741,4158,-1,4153,2157,4742,-1,2157,4153,3042,-1,4743,1380,4747,-1,4743,4150,1380,-1,4149,4147,4744,-1,4147,4149,2153,-1,4145,4748,3185,-1,4145,4749,4748,-1,3183,4155,1383,-1,4750,4155,3183,-1,4144,4751,4154,-1,4751,4144,4135,-1,4747,3184,4140,-1,4747,1380,3184,-1,4141,4752,4140,-1,4126,4752,4141,-1,4753,3185,4748,-1,1379,3185,4753,-1,4138,4750,3183,-1,4124,4750,4138,-1,4135,4120,4751,-1,4120,4135,4134,-1,4128,1382,4132,-1,4130,1382,4128,-1,2161,4139,4130,-1,2160,4139,2161,-1,2159,3186,1376,-1,3186,2159,4127,-1,4115,4753,4754,-1,4115,1379,4753,-1,4124,4755,4114,-1,4124,4138,4755,-1,4134,4111,4120,-1,4111,4134,4109,-1,4119,4125,4118,-1,2162,4125,4119,-1,1374,4106,4756,-1,4106,1374,4104,-1,4116,4102,4757,-1,4102,4116,4100,-1,1363,4758,4113,-1,1373,4758,1363,-1,4121,4107,4759,-1,4107,4121,4760,-1,4760,4096,4107,-1,4096,4760,4099,-1,1368,4119,1369,-1,4097,4119,1368,-1,4106,4761,4762,-1,4761,4106,4105,-1,4763,4101,3037,-1,4763,4102,4101,-1,3035,1364,3036,-1,3035,1365,1364,-1,3037,4764,3035,-1,3037,4103,4764,-1,3037,4101,4103,-1,1365,1362,1364,-1,1362,1365,1367,-1,4765,1320,2371,-1,1320,4765,3026,-1,3271,1322,934,-1,1322,3271,4056,-1,931,3191,4068,-1,931,1358,3191,-1,4063,3569,2367,-1,4062,3569,4063,-1,4065,3568,3567,-1,4066,3568,4065,-1,3021,4766,4038,-1,3021,4767,4766,-1,3021,4768,4767,-1,1267,2175,2174,-1,1266,2175,1267,-1,1305,2231,3204,-1,2231,1305,4769,-1,4026,1349,1297,-1,1350,1349,4026,-1,2211,3207,4028,-1,2217,3207,2211,-1,4770,4061,4011,-1,4061,4770,4064,-1,2214,4025,4086,-1,2212,4025,2214,-1,4044,4031,4046,-1,4044,4029,4031,-1,1346,4771,3011,-1,4771,1346,4772,-1,4088,3020,2204,-1,1270,3020,4088,-1,1342,1282,1281,-1,3195,1282,1342,-1,4069,4007,4082,-1,4069,2221,4007,-1,2220,1294,1293,-1,2222,1294,2220,-1,4773,3989,3986,-1,3989,4773,4774,-1,4080,3983,4081,-1,4775,3983,4080,-1,1277,2185,4078,-1,1276,2185,1277,-1,1335,4776,1336,-1,1335,4016,4776,-1,4022,4777,4004,-1,4022,3977,4777,-1,2210,4013,1332,-1,2210,4080,4013,-1,4777,3976,4778,-1,4777,3977,3976,-1,3972,1252,3970,-1,1252,3972,3211,-1,4072,4774,4773,-1,4774,4072,3966,-1,4779,1272,4780,-1,4779,4781,1272,-1,3008,1315,1317,-1,3198,1315,3008,-1,4041,1325,4006,-1,1326,1325,4041,-1,2172,4067,1351,-1,2172,1360,4067,-1,1322,1328,1323,-1,1322,4056,1328,-1,1312,4092,4772,-1,1312,4065,4092,-1,2194,1319,1318,-1,1319,2194,4057,-1,4776,4060,1258,-1,4060,4776,4016,-1,1310,1253,1248,-1,1314,1253,1310,-1,2177,1250,2200,-1,1341,1250,2177,-1,4782,3190,3014,-1,4094,3190,4782,-1,3022,2216,3189,-1,3022,2213,2216,-1,3195,3192,1343,-1,1355,3192,3195,-1,4783,3195,1342,-1,1355,3195,4783,-1,1356,4783,4052,-1,1356,1355,4783,-1,4784,1305,1304,-1,4784,4785,1305,-1,4058,4048,3992,-1,4049,4048,4058,-1,3010,3995,1301,-1,2226,3995,3010,-1,4000,4785,4784,-1,4000,4087,4785,-1,1296,1265,1299,-1,1265,1296,1263,-1,4044,4042,4029,-1,4044,3032,4042,-1,4040,1326,4041,-1,4036,1326,4040,-1,1275,4767,1280,-1,4766,4767,1275,-1,4038,1275,3016,-1,4766,1275,4038,-1,4033,4781,4043,-1,4033,4035,4781,-1,4031,4085,4084,-1,4031,4030,4085,-1,4026,3207,1350,-1,4026,4028,3207,-1,3979,4022,4786,-1,3979,4021,4022,-1,4074,4018,4787,-1,4074,4020,4018,-1,4788,3986,4017,-1,4788,4773,3986,-1,4786,3982,3979,-1,4059,3982,4786,-1,1289,1285,1284,-1,1289,1288,1285,-1,3033,3029,1338,-1,2167,3029,3033,-1,4789,1278,1280,-1,4789,4790,1278,-1,4780,1274,4782,-1,4780,1272,1274,-1,1269,3210,3209,-1,3210,1269,1271,-1,1353,1265,3193,-1,1265,1353,1300,-1,2170,1327,3198,-1,2169,1327,2170,-1,4006,4070,4009,-1,1325,4070,4006,-1,1348,1260,1312,-1,1348,1261,1260,-1,2200,1258,1257,-1,2200,4776,1258,-1,2195,1255,1254,-1,2195,4778,1255,-1,3211,1248,1253,-1,3211,1249,1248,-1,4001,4784,2219,-1,4001,4000,4784,-1,3997,1289,4769,-1,1289,3997,3018,-1,3994,3995,4047,-1,3993,3995,3994,-1,2165,2232,3993,-1,2165,4791,2232,-1,4792,1246,1245,-1,4792,2181,1246,-1,3988,4079,4793,-1,3988,3987,4079,-1,3985,4794,3984,-1,3985,4795,4794,-1,3980,4796,4793,-1,3980,3982,4796,-1,2186,3978,4787,-1,3976,3978,2186,-1,2185,3974,4073,-1,2184,3974,2185,-1,3972,4788,1334,-1,3972,3971,4788,-1,1334,4017,1335,-1,1334,4788,4017,-1,3965,4797,4798,-1,4797,3965,3964,-1,3963,4799,923,-1,4799,3963,3962,-1,2997,2377,2998,-1,4800,2377,2997,-1,3961,3559,2950,-1,4801,3559,3961,-1,4802,1199,3213,-1,4802,3230,1199,-1,3958,1119,928,-1,1119,3958,3960,-1,1121,4803,4804,-1,1121,4805,4803,-1,1121,3225,4805,-1,1121,1161,3225,-1,2275,1161,1121,-1,2275,2274,1161,-1,1125,1141,2277,-1,1125,1142,1141,-1,4797,3951,3950,-1,3951,4797,4806,-1,3948,4799,4807,-1,3948,3947,4799,-1,2990,3804,1140,-1,3804,2990,3814,-1,4806,1242,1241,-1,4806,3944,1242,-1,3939,3942,3938,-1,3939,4807,3942,-1,4808,3939,3937,-1,4808,4809,3939,-1,3803,4810,3801,-1,3797,4810,3803,-1,1241,4811,4812,-1,4811,1241,3212,-1,3933,4811,4813,-1,3933,3931,4811,-1,4814,4815,4808,-1,4816,4815,4814,-1,4817,3935,3934,-1,3935,4817,3854,-1,3925,4818,4813,-1,4818,3925,3924,-1,4819,3920,3921,-1,4819,4814,3920,-1,3918,3915,3960,-1,3915,3918,3916,-1,3915,3909,4820,-1,3909,3915,3908,-1,1239,3851,3911,-1,1239,1201,3851,-1,4821,3905,3904,-1,4821,3911,3905,-1,3909,2251,1207,-1,2251,3909,3906,-1,3901,4822,4823,-1,3800,4822,3901,-1,3904,3902,4824,-1,3902,3904,2240,-1,3903,4825,3902,-1,4826,4825,3903,-1,4827,4828,3808,-1,4828,4827,3849,-1,3903,3900,3837,-1,3903,2239,3900,-1,1133,1129,3228,-1,1133,2988,1129,-1,3892,3898,4800,-1,3893,3898,3892,-1,4801,3895,3896,-1,3895,4801,4829,-1,1204,3888,3887,-1,1204,3895,3888,-1,3886,3892,4830,-1,3885,3892,3886,-1,3882,3890,3885,-1,3881,3890,3882,-1,3880,3888,4831,-1,3879,3888,3880,-1,4832,3886,1213,-1,3884,3886,4832,-1,2242,3882,3884,-1,3876,3882,2242,-1,3875,3880,4833,-1,3874,3880,3875,-1,3215,3877,3874,-1,1233,3877,3215,-1,2244,3883,3876,-1,4834,3883,2244,-1,3871,4835,4834,-1,3870,4835,3871,-1,1232,3878,1233,-1,3847,3878,1232,-1,3216,3871,1226,-1,3869,3871,3216,-1,1232,4836,3868,-1,1232,1234,4836,-1,3845,4837,4838,-1,3845,3868,4837,-1,3862,3866,3869,-1,3861,3866,3862,-1,3861,1173,3863,-1,1173,3861,3833,-1,1177,3867,1189,-1,3222,3867,1177,-1,929,1219,4839,-1,929,1220,1219,-1,2998,1208,1218,-1,1244,1208,2998,-1,1123,3855,1219,-1,1123,2276,3855,-1,3227,1196,1132,-1,1196,3227,3956,-1,1231,2246,2245,-1,1231,3860,2246,-1,3858,1185,3949,-1,1185,3858,3005,-1,4840,3929,4816,-1,3929,4840,4841,-1,4817,3798,3854,-1,4817,3796,3798,-1,3887,3218,1204,-1,3218,3887,3824,-1,3853,4842,3852,-1,4843,4842,3853,-1,1237,3849,1238,-1,1237,4828,3849,-1,3846,4838,3224,-1,3846,3845,4838,-1,3831,4844,3001,-1,3829,4844,3831,-1,1215,3224,4838,-1,3224,1215,1165,-1,1182,4845,3926,-1,4845,1182,3220,-1,4846,4840,4819,-1,4804,4840,4846,-1,3841,4818,4847,-1,3841,3840,4818,-1,2271,3955,3848,-1,2271,2273,3955,-1,1191,4848,2247,-1,1191,2999,4848,-1,3834,4849,3832,-1,3834,4850,4849,-1,2265,3831,3843,-1,2265,3826,3831,-1,4851,2263,4852,-1,3828,2263,4851,-1,1168,1221,3000,-1,1168,2262,1221,-1,3846,1167,3819,-1,3224,1167,3846,-1,3824,3822,3218,-1,3824,3820,3822,-1,3825,3823,3820,-1,3823,3825,4853,-1,3819,1224,3217,-1,3819,1167,1224,-1,3817,1223,3816,-1,3817,3217,1223,-1,3815,3936,3814,-1,3815,4854,3936,-1,3811,3225,1160,-1,4805,3225,3811,-1,1156,3815,2267,-1,3946,3815,1156,-1,2253,3807,3853,-1,2253,3805,3807,-1,3809,2238,2268,-1,2238,3809,2237,-1,3810,3808,3805,-1,3808,3810,4827,-1,1141,3804,3801,-1,3804,1141,1140,-1,3800,3852,4822,-1,3852,3800,2254,-1,1129,1197,1130,-1,1129,3901,1197,-1,1127,1240,1128,-1,1205,1240,1127,-1,1120,3798,2236,-1,3798,1120,3229,-1,2379,4855,2380,-1,4855,2379,3795,-1,1107,2378,3773,-1,1107,919,2378,-1,3673,970,2322,-1,3673,3781,970,-1,1113,3790,3549,-1,3778,3790,1113,-1,3777,4856,4857,-1,3777,3789,4856,-1,2383,3775,2384,-1,3775,2383,3232,-1,976,3767,3672,-1,976,3784,3767,-1,3792,3681,4858,-1,3792,3260,3681,-1,1113,3780,3778,-1,3780,1113,1112,-1,4857,3776,3777,-1,3776,4857,4859,-1,1115,1111,1110,-1,1111,1115,4860,-1,3774,3769,3795,-1,3769,3774,3768,-1,3773,1108,1107,-1,1108,3773,2293,-1,4861,3692,4862,-1,4861,1007,3692,-1,3769,3750,4863,-1,3750,3769,3749,-1,4864,3644,3648,-1,3642,3644,4864,-1,4865,3766,4858,-1,3765,3766,4865,-1,3780,1099,3762,-1,1099,3780,3236,-1,3760,3745,3744,-1,3760,3776,3745,-1,1111,3753,1109,-1,3753,1111,3752,-1,3666,3739,3639,-1,3668,3739,3666,-1,3742,3756,3743,-1,3742,4862,3756,-1,3753,3734,3757,-1,3734,3753,3733,-1,3750,1100,3235,-1,1100,3750,1093,-1,1092,3234,1105,-1,1091,3234,1092,-1,3746,2983,3732,-1,3746,3765,2983,-1,1099,4866,3763,-1,4866,1099,1098,-1,3761,3738,3736,-1,3761,3744,3738,-1,1085,4867,3742,-1,1006,4867,1085,-1,1083,2335,2337,-1,1083,1097,2335,-1,3728,3743,3755,-1,3727,3743,3728,-1,3754,3735,3733,-1,3735,3754,4868,-1,1094,3751,4869,-1,1094,1093,3751,-1,2347,3657,956,-1,1076,3657,2347,-1,4866,3723,3729,-1,3723,4866,3721,-1,2299,3728,4870,-1,1081,3728,2299,-1,3685,3661,4871,-1,3685,3659,3661,-1,1084,1061,1082,-1,1061,1084,3244,-1,3243,3239,1086,-1,1003,3239,3243,-1,3720,1072,2305,-1,3720,3737,1072,-1,3735,3711,3716,-1,3711,3735,3710,-1,4872,1077,3240,-1,4872,979,1077,-1,2306,994,2972,-1,2306,2296,994,-1,1087,1073,1088,-1,1073,1087,1074,-1,1073,1054,3712,-1,1054,1073,2311,-1,1072,1048,1047,-1,1072,4873,1048,-1,3711,3703,3717,-1,3703,3711,3702,-1,3701,1079,3699,-1,3701,3240,1079,-1,961,1042,1041,-1,961,959,1042,-1,3638,3634,3726,-1,3634,3638,3637,-1,3705,3243,3707,-1,1063,3243,3705,-1,1027,1001,1063,-1,1000,1001,1027,-1,1037,1071,1047,-1,1036,1071,1037,-1,3245,3704,3702,-1,3704,3245,1044,-1,3700,3709,4874,-1,3700,3699,3709,-1,2326,1012,2323,-1,2326,2327,1012,-1,1039,4875,2980,-1,4875,1039,986,-1,3260,920,996,-1,920,3260,3792,-1,2974,2970,3686,-1,2338,2970,2974,-1,3689,1031,3691,-1,3252,1031,3689,-1,4876,2340,2321,-1,4877,2340,4876,-1,3663,1007,4861,-1,3663,1008,1007,-1,1003,1004,3239,-1,1003,2968,1004,-1,4878,1026,3253,-1,3693,1026,4878,-1,3688,4879,3687,-1,3688,2303,4879,-1,3682,4880,3771,-1,4880,3682,3684,-1,3260,2345,3681,-1,2345,3260,997,-1,1026,3255,998,-1,3255,1026,3693,-1,3704,3680,3677,-1,3680,3704,3786,-1,3700,3675,3676,-1,3675,3700,3788,-1,2316,3697,2315,-1,3697,2316,3698,-1,990,3258,3259,-1,990,2339,3258,-1,4875,3698,2316,-1,3698,4875,3694,-1,3696,3261,982,-1,3696,2319,3261,-1,3748,1091,957,-1,1091,3748,3234,-1,2327,1043,958,-1,2326,1043,2327,-1,4881,979,4872,-1,4881,3262,979,-1,952,2285,2284,-1,952,3265,2285,-1,1033,4882,3656,-1,4882,1033,1035,-1,3667,3266,3668,-1,4883,3266,3667,-1,4884,4885,4886,-1,4885,4884,4887,-1,4888,3237,1092,-1,3650,3237,4888,-1,3665,2290,4887,-1,2290,3665,2985,-1,1004,3660,1005,-1,1004,3658,3660,-1,2343,3772,1025,-1,2343,3662,3772,-1,2342,3661,3658,-1,3661,2342,4889,-1,965,956,3657,-1,956,965,964,-1,2328,1076,963,-1,2328,3657,1076,-1,1034,3656,2981,-1,1034,1033,3656,-1,4890,1031,1030,-1,2309,1031,4890,-1,4881,3654,3262,-1,4881,3715,3654,-1,3651,4888,4891,-1,4888,3651,3650,-1,2332,3648,3646,-1,2332,4864,3648,-1,3644,3665,4892,-1,3665,3644,3643,-1,3641,3265,954,-1,3265,3641,4893,-1,4886,954,953,-1,3640,954,4886,-1,949,3638,950,-1,3636,3638,949,-1,3726,3635,3671,-1,3726,3634,3635,-1,3633,3248,3251,-1,3247,3248,3633,-1,3621,2709,268,-1,3630,2709,3621,-1,2863,4634,3628,-1,2863,2712,4634,-1,4636,267,260,-1,3625,267,4636,-1,4894,3624,2707,-1,3624,4894,4639,-1,3622,263,4599,-1,3622,3346,263,-1,3347,3620,251,-1,3620,3347,4895,-1,3618,3443,4896,-1,3618,3445,3443,-1,4897,3616,4898,-1,3614,3616,4897,-1,3612,4899,3611,-1,3612,4900,4899,-1,4501,4901,4902,-1,4500,4901,4501,-1,942,3609,2719,-1,942,3608,3609,-1,2714,3607,2715,-1,3607,2714,3596,-1,3435,4903,4904,-1,3604,4903,3435,-1,945,3603,2686,-1,3603,945,944,-1,3600,1489,3598,-1,3600,4903,1489,-1,3608,941,4312,-1,3608,942,941,-1,2080,3605,2081,-1,2080,3595,3605,-1,3428,4905,4906,-1,4905,3428,4324,-1,4907,3180,3588,-1,3180,4907,1393,-1,4182,2857,4908,-1,3587,2857,4182,-1,4728,3584,4909,-1,3586,3584,4728,-1,4910,3583,2720,-1,3583,4910,4177,-1,1389,4911,1390,-1,1389,2858,4911,-1,2955,4173,4737,-1,4173,2955,2363,-1,212,3579,4912,-1,212,2732,3579,-1,4913,3572,3571,-1,4913,3578,3572,-1,2728,940,3419,-1,2728,938,940,-1,4914,3472,3577,-1,3472,4914,3475,-1,2959,207,206,-1,207,2959,3573,-1,3572,4915,2359,-1,3352,4915,3572,-1,4916,2954,2956,-1,4917,2954,4916,-1,4918,3570,2855,-1,4918,3034,3570,-1,4919,932,931,-1,932,4919,4920,-1,198,4093,3567,-1,3354,4093,198,-1,4921,3566,3564,-1,4921,4091,3566,-1,200,3271,201,-1,200,3563,3271,-1,3408,3230,4802,-1,3230,3408,3406,-1,3560,2282,3562,-1,2282,3560,3561,-1,3402,3963,3401,-1,3963,3402,3557,-1,3355,4802,4922,-1,3355,3408,4802,-1,3959,3404,4923,-1,3404,3959,3958,-1,3393,3789,3392,-1,3393,4856,3789,-1,4924,3551,3550,-1,3791,3551,4924,-1,3546,1117,1116,-1,3546,3356,1117,-1,2947,3398,2385,-1,3398,2947,3794,-1,921,3791,4924,-1,921,920,3791,-1,612,617,615,-1,609,617,612,-1,2697,2848,2696,-1,2697,2868,2848,-1,275,3342,903,-1,275,274,3342,-1,2893,3479,4925,-1,3479,2893,492,-1,4926,3484,4927,-1,3484,4926,3485,-1,4928,3276,3483,-1,3276,4928,901,-1,4929,2588,3540,-1,4929,2589,2588,-1,3538,2894,4930,-1,3538,2587,2894,-1,547,4930,2943,-1,4930,547,895,-1,3304,2396,897,-1,3303,2396,3304,-1,3535,2911,2909,-1,3535,3536,2911,-1,4931,3533,4932,-1,4931,3279,3533,-1,892,461,465,-1,461,892,891,-1,886,887,14,-1,886,4933,887,-1,2644,159,2648,-1,2577,159,2644,-1,590,3528,2556,-1,589,3528,590,-1,686,3529,4934,-1,3529,686,685,-1,3507,589,3280,-1,3528,589,3507,-1,3281,3527,2424,-1,3527,3281,3508,-1,2906,4935,666,-1,2906,3297,4935,-1,3330,2649,174,-1,3330,2875,2649,-1,3504,2484,2551,-1,2484,3504,2485,-1,3521,2428,2514,-1,866,2428,3521,-1,806,2932,804,-1,2429,2932,806,-1,2932,858,2826,-1,858,2932,2429,-1,808,858,2429,-1,808,3283,858,-1,2469,2459,702,-1,2469,3296,2459,-1,859,2936,102,-1,811,2936,859,-1,2435,2937,813,-1,561,2937,2435,-1,564,2903,2899,-1,2903,564,4936,-1,91,95,92,-1,91,848,95,-1,3290,842,830,-1,3290,840,842,-1,3290,851,840,-1,3290,827,98,-1,828,827,3290,-1,464,2448,827,-1,464,466,2448,-1,661,53,659,-1,53,661,872,-1,3529,666,4935,-1,3529,3298,666,-1,2486,694,2484,-1,3511,694,2486,-1,3284,806,805,-1,3284,2430,806,-1,329,2467,2754,-1,329,328,2467,-1,768,854,3526,-1,854,768,761,-1,2511,3519,3517,-1,2511,3291,3519,-1,749,3296,706,-1,2459,3296,749,-1,3515,785,3518,-1,3515,786,785,-1,783,855,3516,-1,855,783,781,-1,785,2930,3517,-1,2930,785,791,-1,788,3285,2432,-1,788,855,3285,-1,3518,797,3515,-1,3518,2471,797,-1,772,742,741,-1,772,2470,742,-1,397,2923,398,-1,2488,2923,397,-1,762,2494,760,-1,762,3513,2494,-1,566,761,760,-1,566,565,761,-1,2938,775,2490,-1,2938,2502,775,-1,2498,3513,3514,-1,2498,3512,3513,-1,743,744,741,-1,743,3292,744,-1,735,773,802,-1,735,734,773,-1,2495,2625,2420,-1,3512,2625,2495,-1,877,876,875,-1,2922,876,877,-1,719,730,3293,-1,719,704,730,-1,410,3294,3326,-1,3294,410,4937,-1,2507,2877,2924,-1,2507,399,2877,-1,706,708,707,-1,706,3296,708,-1,2480,2510,2477,-1,2480,778,2510,-1,877,2485,878,-1,877,2486,2485,-1,3511,2518,694,-1,2518,3511,4938,-1,3510,687,2528,-1,687,3510,688,-1,7,4939,0,-1,7,2921,4939,-1,695,684,2919,-1,684,695,682,-1,2527,3510,699,-1,2527,2526,3510,-1,696,541,2569,-1,541,696,698,-1,3280,881,3506,-1,3280,678,881,-1,657,4940,3505,-1,4940,657,2916,-1,3299,4940,656,-1,3299,4941,4940,-1,2535,4941,3299,-1,3300,4941,2535,-1,648,641,9,-1,642,641,648,-1,4932,3536,3534,-1,3533,3536,4932,-1,588,623,2913,-1,623,588,2545,-1,627,617,616,-1,627,615,617,-1,597,603,2546,-1,597,604,603,-1,600,596,651,-1,596,600,604,-1,2905,3501,3500,-1,2905,665,3501,-1,897,3099,3304,-1,897,580,3099,-1,2014,2914,650,-1,2914,2014,2013,-1,573,570,569,-1,572,570,573,-1,2560,3095,2016,-1,2560,3305,3095,-1,2567,4936,564,-1,2901,4936,2567,-1,2434,3287,2435,-1,2902,3287,2434,-1,551,4942,850,-1,551,3311,4942,-1,3311,2566,4942,-1,555,2566,3311,-1,3308,567,563,-1,3308,2565,567,-1,567,2567,852,-1,567,2565,2567,-1,554,558,3309,-1,554,556,558,-1,2813,552,3495,-1,552,2813,2812,-1,3310,1,556,-1,3310,2,1,-1,458,4943,2406,-1,4943,458,462,-1,548,2400,894,-1,548,2942,2400,-1,4944,675,3492,-1,4944,4945,675,-1,3295,543,542,-1,3295,2879,543,-1,4946,498,497,-1,536,498,4946,-1,2898,4947,533,-1,2898,3490,4947,-1,527,538,2601,-1,527,526,538,-1,4948,2398,2942,-1,2398,4948,3488,-1,3319,3486,499,-1,3319,2585,3486,-1,3314,4949,530,-1,3314,2571,4949,-1,523,910,2945,-1,523,519,910,-1,122,2576,520,-1,122,3275,2576,-1,517,515,3317,-1,515,517,3487,-1,508,503,3317,-1,503,508,2584,-1,2412,511,2414,-1,512,511,2412,-1,499,4950,500,-1,499,4929,4950,-1,3318,2587,504,-1,3318,2588,2587,-1,3319,2395,899,-1,3319,501,2395,-1,2585,899,2586,-1,899,2585,3319,-1,3483,493,4951,-1,493,3483,494,-1,2698,489,2699,-1,2698,469,489,-1,2699,490,2779,-1,489,490,2699,-1,2749,440,2853,-1,440,2749,441,-1,3446,475,484,-1,476,475,3446,-1,3481,3320,3345,-1,3481,481,3320,-1,3480,473,471,-1,3480,474,473,-1,3344,4925,3479,-1,3344,3447,4925,-1,4928,4952,901,-1,4952,4928,4953,-1,457,462,458,-1,457,2446,462,-1,2596,459,2602,-1,459,2596,467,-1,3441,2681,316,-1,2681,3441,2861,-1,2650,3455,2651,-1,3399,3455,2650,-1,2871,3438,445,-1,3438,2871,2680,-1,2665,2666,333,-1,2665,4954,2666,-1,2684,2828,2761,-1,2828,2684,2870,-1,2726,2869,2662,-1,2869,2726,2856,-1,3414,3333,2736,-1,3414,3451,3333,-1,425,747,423,-1,425,2926,747,-1,421,874,2927,-1,421,737,874,-1,721,671,3295,-1,765,671,721,-1,752,412,411,-1,750,412,752,-1,394,2924,2630,-1,726,2924,394,-1,3353,3349,2659,-1,3349,3353,2733,-1,3337,2644,382,-1,2644,3337,2645,-1,3471,2641,373,-1,2641,3471,3378,-1,380,2640,381,-1,380,179,2640,-1,3378,2642,2641,-1,3378,2829,2642,-1,368,2832,369,-1,368,386,2832,-1,361,2842,3380,-1,361,3336,2842,-1,2875,364,366,-1,2875,4955,364,-1,3330,4955,2875,-1,3391,4955,3330,-1,3397,2634,2633,-1,3397,3362,2634,-1,290,4956,291,-1,356,4956,290,-1,355,2638,199,-1,355,2876,2638,-1,3454,196,3411,-1,3454,3331,196,-1,4957,3332,347,-1,4958,3332,4957,-1,3465,391,2730,-1,3466,391,3465,-1,231,2697,2623,-1,230,2697,231,-1,4959,3358,3463,-1,4959,3357,3358,-1,2443,4960,104,-1,4960,2443,3289,-1,4954,321,320,-1,4954,2665,321,-1,152,2883,2882,-1,2883,152,4961,-1,2761,3457,2684,-1,2761,3377,3457,-1,4962,2870,2350,-1,2828,2870,4962,-1,114,150,115,-1,151,150,114,-1,233,312,3335,-1,312,233,433,-1,2655,2737,2656,-1,2655,354,2737,-1,3338,302,2645,-1,3338,303,302,-1,387,299,374,-1,3340,299,387,-1,2740,389,2651,-1,2739,389,2740,-1,2442,844,843,-1,2442,126,844,-1,288,351,2632,-1,351,288,2765,-1,3453,285,435,-1,3453,3427,285,-1,431,166,2662,-1,166,431,164,-1,4963,3342,3385,-1,3342,4963,2701,-1,2751,3333,3451,-1,2751,2753,3333,-1,346,4964,347,-1,346,3450,4964,-1,3382,4957,3381,-1,3382,3468,4957,-1,2393,913,3343,-1,914,913,2393,-1,4946,2889,3478,-1,2889,4946,497,-1,4946,4952,3491,-1,4946,3478,4952,-1,272,3480,4965,-1,272,271,3480,-1,265,2679,2708,-1,265,264,2679,-1,2611,267,3626,-1,2611,2610,267,-1,254,4966,325,-1,4966,254,253,-1,4898,320,250,-1,4898,4954,320,-1,3440,2861,3441,-1,4900,2861,3440,-1,4902,2612,446,-1,4901,2612,4902,-1,3435,3476,3434,-1,3435,4904,3476,-1,3324,3433,3431,-1,3609,3433,3324,-1,3606,3427,3453,-1,3606,3436,3427,-1,4906,3429,3428,-1,4906,2685,3429,-1,2848,2859,2696,-1,2849,2859,2848,-1,4961,3420,4909,-1,4961,444,3420,-1,3425,4910,2669,-1,3425,3424,4910,-1,3423,3323,284,-1,3323,3423,4911,-1,3422,4907,3462,-1,3422,3421,4907,-1,2885,3348,4908,-1,2885,2618,3348,-1,2660,3352,215,-1,2660,4915,3352,-1,3419,3577,3418,-1,3419,3576,3577,-1,4967,219,3465,-1,219,4967,217,-1,4917,2658,3351,-1,2658,4917,4916,-1,2369,199,2638,-1,199,2369,200,-1,3414,4918,2874,-1,3414,2365,4918,-1,4920,3413,2607,-1,3413,4920,2952,-1,2631,3354,197,-1,2631,4968,3354,-1,350,3412,4921,-1,350,349,3412,-1,356,3560,4956,-1,356,3409,3560,-1,3408,2654,2653,-1,2654,3408,3355,-1,2636,4969,3467,-1,2636,3403,4969,-1,191,3401,192,-1,191,345,3401,-1,311,190,2376,-1,311,194,190,-1,3546,2650,388,-1,2650,3546,3400,-1,2742,2745,183,-1,2744,2745,2742,-1,3398,186,3396,-1,186,3398,184,-1,918,179,380,-1,179,918,917,-1,2646,921,4924,-1,2646,3394,921,-1,175,3392,2854,-1,175,365,3392,-1,3469,3390,3389,-1,3469,3552,3390,-1,2873,2777,2851,-1,255,2777,2873,-1,3387,278,3357,-1,3387,276,278,-1,916,169,168,-1,2868,169,916,-1,164,2704,165,-1,164,4970,2704,-1,4963,3386,4971,-1,3386,4963,3385,-1,3450,3343,913,-1,3450,3383,3343,-1,2841,3382,2866,-1,3359,3382,2841,-1,3274,3360,3380,-1,3360,3274,3273,-1,4965,3321,272,-1,4965,2706,3321,-1,109,4960,3459,-1,108,4960,109,-1,4972,3375,3365,-1,4972,3364,3375,-1,2652,140,2767,-1,138,140,2652,-1,3494,2833,132,-1,2833,3494,3282,-1,132,3471,3494,-1,3378,3471,132,-1,2834,2933,3361,-1,2834,3379,2933,-1,3458,3364,4972,-1,3364,3458,130,-1,126,124,2825,-1,126,128,124,-1,2835,4962,331,-1,2835,3524,4962,-1,141,2957,142,-1,141,2670,2957,-1,161,3273,2839,-1,161,173,3273,-1,2838,101,2445,-1,2838,145,101,-1,108,104,4960,-1,104,108,2768,-1,2759,2437,88,-1,2759,3524,2437,-1,2773,844,2772,-1,2773,845,844,-1,75,3371,3373,-1,42,3371,75,-1,78,2781,79,-1,78,2795,2781,-1,2804,41,40,-1,2804,2780,41,-1,2796,2790,31,-1,2796,63,2790,-1,37,2783,60,-1,36,2783,37,-1,59,77,2797,-1,59,83,77,-1,39,2797,2802,-1,39,59,2797,-1,3372,44,2456,-1,3372,45,44,-1,72,2940,4973,-1,72,34,2940,-1,3531,27,2915,-1,3366,27,3531,-1,27,3370,2407,-1,27,29,3370,-1,2532,2940,2915,-1,2532,2793,2940,-1,3368,2541,646,-1,2541,3368,3367,-1,2020,3141,2817,-1,2020,3147,3141,-1,2816,1693,2020,-1,2816,3102,1693,-1,643,3368,3369,-1,3367,3368,643,-1,2408,16,2457,-1,2408,17,16,-1,4933,2808,887,-1,2806,2808,4933,-1,15,3370,2809,-1,3370,15,17,-1,35,59,39,-1,59,35,37,-1,13,3523,2452,-1,55,3523,13,-1,33,2939,34,-1,33,2785,2939,-1,42,2820,3371,-1,41,2820,42,-1,64,83,60,-1,64,62,83,-1,2827,2466,3374,-1,857,2466,2827,-1,88,2760,2759,-1,87,2760,88,-1,2935,92,98,-1,90,92,2935,-1,2436,94,93,-1,2436,103,94,-1,4974,97,96,-1,4974,3288,97,-1,845,97,3288,-1,845,2935,97,-1,150,3365,115,-1,4972,3365,150,-1,109,2679,153,-1,2679,109,2865,-1,121,3275,122,-1,121,2896,3275,-1,3376,3325,2774,-1,3376,426,3325,-1,2872,2836,3334,-1,3525,2836,2872,-1,3377,123,125,-1,2438,123,3377,-1,2442,131,127,-1,2442,129,131,-1,807,2933,133,-1,807,3361,2933,-1,2837,3525,2433,-1,2836,3525,2837,-1,2609,155,2886,-1,3289,155,2609,-1,2648,158,3470,-1,2648,159,158,-1,2391,4964,912,-1,3381,4964,2391,-1,2867,3384,3452,-1,3384,2867,2775,-1,168,3358,278,-1,167,3358,168,-1,171,3482,2698,-1,170,3482,171,-1,3542,3339,3456,-1,3542,3395,3339,-1,3391,3554,4955,-1,3391,3388,3554,-1,2647,3552,3469,-1,2647,3550,3552,-1,3542,3543,3541,-1,3542,3329,3543,-1,3548,379,4975,-1,379,3548,2948,-1,2633,2385,3397,-1,2633,2381,2385,-1,2382,181,3399,-1,181,2382,182,-1,3356,176,2854,-1,2692,176,3356,-1,4958,3402,3332,-1,4958,3556,3402,-1,4923,3405,3341,-1,3405,4923,3404,-1,4976,3406,3407,-1,4976,3562,3406,-1,309,2376,2949,-1,309,311,2376,-1,3564,353,352,-1,353,3564,3415,-1,3410,196,198,-1,3411,196,3410,-1,204,2368,202,-1,204,392,2368,-1,933,2733,3353,-1,2733,933,932,-1,450,3416,2370,-1,450,449,3416,-1,205,3270,4977,-1,205,210,3270,-1,2953,3350,3417,-1,3350,2953,4978,-1,2729,2671,213,-1,2731,2671,2729,-1,3575,205,4914,-1,3575,206,205,-1,2727,216,2728,-1,2727,214,216,-1,222,4916,220,-1,222,2658,4916,-1,3349,2658,2659,-1,3349,3351,2658,-1,228,2857,226,-1,228,318,2857,-1,2722,4979,3588,-1,2723,4979,2722,-1,231,2858,229,-1,231,280,2858,-1,2881,2720,225,-1,2881,2721,2720,-1,2883,3426,2884,-1,2883,3584,3426,-1,232,948,241,-1,948,232,2717,-1,433,3592,312,-1,242,3592,433,-1,2714,2663,3432,-1,2714,236,2663,-1,3610,239,3473,-1,3610,237,239,-1,2685,946,2683,-1,4906,946,2685,-1,4966,3444,325,-1,3443,3444,4966,-1,3612,3438,2862,-1,3437,3438,3612,-1,2666,3442,2667,-1,3442,2666,3616,-1,3445,248,2674,-1,249,248,3445,-1,2676,3347,252,-1,3347,2676,4980,-1,2705,2713,2964,-1,2705,2615,2713,-1,2682,3346,269,-1,3346,2682,263,-1,3460,4894,3322,-1,4894,3460,4981,-1,2706,2746,2616,-1,2706,4965,2746,-1,476,540,539,-1,476,460,540,-1,460,476,453,-1,2890,4982,2592,-1,2890,3449,4982,-1,4953,3491,4952,-1,4953,3490,3491,-1,2637,2840,305,-1,2840,2637,3359,-1,2843,3333,2753,-1,2843,2656,3333,-1,3464,4971,2661,-1,4971,3464,2846,-1,4970,282,2750,-1,4970,430,282,-1,3374,3454,2764,-1,3331,3454,3374,-1,2755,4983,293,-1,2755,291,4983,-1,2762,2743,2635,-1,296,2743,2762,-1,296,2744,2743,-1,3341,3455,300,-1,3405,3455,3341,-1,3456,3337,3328,-1,3456,3339,3337,-1,194,310,2876,-1,311,310,194,-1,3429,314,313,-1,3429,3457,314,-1,2723,2675,322,-1,2723,2620,2675,-1,325,2619,326,-1,325,3444,2619,-1,2671,329,2672,-1,2671,327,329,-1,2881,2695,2694,-1,224,2695,2881,-1,3335,125,124,-1,314,125,3335,-1,441,3482,335,-1,2749,3482,441,-1,167,3463,3358,-1,167,3461,3463,-1,3463,4979,4959,-1,3463,3462,4979,-1,235,283,2663,-1,235,2859,283,-1,2608,3417,2887,-1,2608,219,3417,-1,2659,2657,3353,-1,2657,339,341,-1,2659,339,2657,-1,3468,4958,4957,-1,3467,4958,3468,-1,351,3411,349,-1,351,3454,3411,-1,2766,4976,3407,-1,4976,2766,4983,-1,3336,370,177,-1,370,3336,361,-1,358,3391,3330,-1,3389,3391,358,-1,370,365,175,-1,370,363,365,-1,550,2568,3312,-1,2568,550,879,-1,3380,362,361,-1,3380,3360,362,-1,3394,3339,3395,-1,3394,3338,3339,-1,3340,386,368,-1,386,3340,387,-1,2643,186,375,-1,2643,3396,186,-1,186,371,375,-1,186,4975,371,-1,2644,304,2577,-1,2644,302,304,-1,2766,2653,2652,-1,3407,2653,2766,-1,391,3413,392,-1,3466,3413,391,-1,412,4937,410,-1,412,2503,4937,-1,2922,727,876,-1,728,727,2922,-1,2869,239,240,-1,2869,3474,239,-1,279,235,234,-1,279,2624,235,-1,3270,3434,4977,-1,2860,3434,3270,-1,2667,316,315,-1,2667,3441,316,-1,261,2706,2705,-1,261,3321,2706,-1,2716,2695,2693,-1,2716,2717,2695,-1,452,2599,2598,-1,2599,452,2605,-1,455,3477,2600,-1,455,2597,3477,-1,2602,527,3477,-1,2602,528,527,-1,461,466,465,-1,461,463,466,-1,901,3478,902,-1,3478,901,4952,-1,4982,488,487,-1,4982,3449,488,-1,2853,2617,2748,-1,440,2617,2853,-1,526,480,3315,-1,526,478,480,-1,483,2594,3315,-1,2594,483,482,-1,484,3481,485,-1,3481,484,475,-1,4947,3447,3448,-1,4947,4984,3447,-1,2892,2590,903,-1,2892,495,2590,-1,4951,4928,3483,-1,4928,4951,4985,-1,3276,4927,3484,-1,3276,900,4927,-1,898,498,2570,-1,498,898,496,-1,3485,2946,904,-1,3485,4926,2946,-1,3540,2583,4986,-1,2583,3540,3539,-1,2573,3486,2585,-1,2573,2944,3486,-1,3487,2411,2410,-1,3487,2578,2411,-1,2895,511,510,-1,2580,511,2895,-1,517,2578,3487,-1,517,516,2578,-1,2945,3318,506,-1,2945,3539,3318,-1,521,2584,508,-1,120,2584,521,-1,2583,2945,910,-1,2945,2583,3539,-1,532,3488,4948,-1,532,3316,3488,-1,2574,2941,3489,-1,2941,2574,2897,-1,548,530,4949,-1,548,531,530,-1,534,478,3316,-1,478,534,479,-1,3320,534,3448,-1,479,534,3320,-1,536,3491,537,-1,536,4946,3491,-1,4934,676,686,-1,4987,676,4934,-1,3278,2400,3534,-1,894,2400,3278,-1,2812,553,552,-1,553,2812,8,-1,558,5,559,-1,558,2815,5,-1,3311,3310,555,-1,3311,553,3310,-1,559,3286,557,-1,3286,559,3495,-1,3307,2567,564,-1,3307,852,2567,-1,849,562,561,-1,849,850,562,-1,1655,2561,584,-1,2561,1655,3146,-1,4988,3143,571,-1,4988,1670,3143,-1,574,3498,3306,-1,3498,574,3497,-1,3145,577,611,-1,577,3145,1660,-1,3499,3277,505,-1,3277,3499,3496,-1,581,2559,2564,-1,583,2559,581,-1,590,2416,591,-1,590,2417,2416,-1,2416,4988,3500,-1,2416,2564,4988,-1,3503,595,2555,-1,3503,3502,595,-1,600,621,603,-1,600,599,621,-1,606,3504,2422,-1,606,3302,3504,-1,611,609,612,-1,611,577,609,-1,615,2548,612,-1,615,614,2548,-1,2537,2550,586,-1,2537,616,2550,-1,3532,2538,2911,-1,2539,2538,3532,-1,646,890,647,-1,890,646,2541,-1,649,635,2912,-1,635,649,648,-1,2401,3300,2535,-1,3300,2401,653,-1,3503,592,594,-1,3503,2907,592,-1,3505,658,657,-1,3505,3301,658,-1,52,3522,663,-1,3522,52,871,-1,3501,3298,3530,-1,3501,665,3298,-1,667,2424,668,-1,2424,667,3281,-1,3508,880,3507,-1,880,3508,3281,-1,4944,2521,4987,-1,4944,2918,2521,-1,2523,2515,2524,-1,2523,2516,2515,-1,2917,2520,689,-1,2920,2520,2917,-1,3509,0,4939,-1,0,3509,2814,-1,2517,3509,4989,-1,3509,2517,2519,-1,4989,3511,875,-1,4938,3511,4989,-1,2468,790,789,-1,2468,2479,790,-1,2929,2510,2509,-1,2929,2477,2510,-1,405,716,2508,-1,405,717,716,-1,2626,736,3292,-1,2626,737,736,-1,738,757,739,-1,2925,757,738,-1,2500,742,774,-1,2500,2499,742,-1,736,2928,745,-1,736,2497,2928,-1,3307,760,4990,-1,3307,566,760,-1,747,853,748,-1,839,853,747,-1,764,417,763,-1,764,418,417,-1,853,2493,748,-1,853,4990,2493,-1,769,802,773,-1,769,803,802,-1,2458,3291,779,-1,2458,3519,3291,-1,855,790,3516,-1,855,788,790,-1,2510,3291,2511,-1,778,3291,2510,-1,795,786,3515,-1,794,786,795,-1,798,704,2513,-1,704,798,672,-1,3516,2476,783,-1,2476,3516,2481,-1,799,2931,771,-1,3520,2931,799,-1,2522,3313,2525,-1,2522,3492,3313,-1,821,45,3372,-1,821,3522,45,-1,2444,452,2450,-1,2444,2605,452,-1,831,826,828,-1,826,831,885,-1,114,99,319,-1,114,2769,99,-1,3523,830,838,-1,3523,831,830,-1,2934,2441,2440,-1,2934,841,2441,-1,2934,842,841,-1,849,3286,551,-1,849,3287,3286,-1,841,560,2441,-1,561,560,841,-1,3284,3526,2463,-1,3526,3284,3520,-1,2463,854,812,-1,854,2463,3526,-1,2774,861,3376,-1,2774,86,861,-1,2634,139,2635,-1,139,2634,3363,-1,3362,2642,3363,-1,3362,2643,2642,-1,2426,3527,2529,-1,3527,2426,868,-1,660,872,661,-1,2534,872,660,-1,2552,2546,2553,-1,2546,2552,2555,-1,4932,3493,4931,-1,2399,3493,4932,-1,4934,4935,4945,-1,4934,3529,4935,-1,3506,683,2529,-1,3506,881,683,-1,685,2530,3530,-1,685,678,2530,-1,3306,2558,572,-1,2554,2558,3306,-1,2557,882,582,-1,2557,883,882,-1,4943,3279,4931,-1,3279,4943,891,-1,3532,893,2539,-1,3532,631,893,-1,3278,4991,895,-1,3278,3535,4991,-1,3537,4991,2397,-1,3537,3538,4991,-1,504,3303,505,-1,3303,504,3537,-1,499,2589,4929,-1,499,3486,2589,-1,2776,275,908,-1,273,275,2776,-1,362,173,2649,-1,362,3360,173,-1,273,2775,2867,-1,273,2776,2775,-1,473,489,469,-1,489,473,472,-1,344,2845,3383,-1,2845,344,343,-1,3554,4856,3393,-1,3554,3553,4856,-1,2283,2948,3548,-1,2948,2283,2378,-1,2382,3547,2383,-1,2382,3400,3547,-1,3544,180,4992,-1,3544,3543,180,-1,3552,3790,3390,-1,3549,3790,3552,-1,2738,929,4839,-1,930,929,2738,-1,3558,4969,4798,-1,3556,4969,3558,-1,4798,3403,3965,-1,3403,4798,4969,-1,187,924,1244,-1,187,193,924,-1,4839,927,2738,-1,927,4839,925,-1,2741,3958,928,-1,2741,3404,3958,-1,3565,3416,3415,-1,3565,4765,3416,-1,3410,4993,3412,-1,3410,3568,4993,-1,3569,4968,202,-1,3569,4994,4968,-1,933,1359,1358,-1,2735,1359,933,-1,2953,2958,4978,-1,2953,2364,2958,-1,3576,940,2361,-1,3576,3419,940,-1,216,938,2728,-1,216,3578,938,-1,212,4175,213,-1,212,4912,4175,-1,2729,4735,4967,-1,4735,2729,4174,-1,2961,4916,2956,-1,4916,2961,220,-1,3423,1390,4911,-1,3423,1387,1390,-1,3581,225,3582,-1,3581,2724,225,-1,3426,4185,3424,-1,4185,3426,3585,-1,3179,3420,226,-1,1396,3420,3179,-1,3348,3589,4729,-1,3348,2722,3589,-1,3590,3421,229,-1,3043,3421,3590,-1,3593,3430,3592,-1,4322,3430,3593,-1,3594,2348,2963,-1,4327,2348,3594,-1,3596,4330,3607,-1,4330,3596,3597,-1,943,3601,3268,-1,943,3599,3601,-1,2687,3163,3604,-1,3163,2687,3602,-1,4906,3267,946,-1,3267,4906,4905,-1,3595,3606,3605,-1,3595,3436,3606,-1,3432,2352,2962,-1,3432,3433,2352,-1,3599,238,237,-1,3599,943,238,-1,3613,3439,3437,-1,4995,3439,3613,-1,3440,3615,4675,-1,3440,3442,3615,-1,4674,249,3617,-1,4674,250,249,-1,4673,253,3619,-1,4673,4966,253,-1,4901,4672,4980,-1,4672,4901,4500,-1,2708,4593,265,-1,4593,2708,3623,-1,3627,4981,3626,-1,4594,4981,3627,-1,2711,4597,2864,-1,4597,2711,3631,-1,1021,3633,1022,-1,1021,3247,3633,-1,950,3726,3725,-1,3638,3726,950,-1,951,3668,3266,-1,951,3739,3668,-1,974,3632,3637,-1,973,3632,974,-1,3639,3741,3641,-1,3739,3741,3639,-1,953,978,4996,-1,978,953,952,-1,977,4996,978,-1,977,3647,4996,-1,3649,1011,3652,-1,3649,3264,1011,-1,980,4864,2332,-1,980,3653,4864,-1,3655,2308,2307,-1,3655,3691,2308,-1,966,3781,3263,-1,966,2344,3781,-1,2969,4997,2341,-1,4997,2969,3249,-1,4998,3660,3659,-1,4998,4999,3660,-1,4999,3663,5000,-1,4999,3662,3663,-1,3645,1104,3643,-1,3645,1105,1104,-1,1013,3652,1011,-1,1013,3242,3652,-1,3636,2982,2301,-1,949,2982,3636,-1,4877,4885,2340,-1,4877,5001,4885,-1,1062,3671,3635,-1,1062,3244,3671,-1,2334,1084,2337,-1,3670,1084,2334,-1,3672,977,976,-1,3672,3646,977,-1,2967,1017,1019,-1,1017,2967,5002,-1,955,1068,960,-1,1068,955,1090,-1,1103,3673,2288,-1,1103,3782,3673,-1,984,2317,3246,-1,984,983,2317,-1,985,4875,986,-1,3694,4875,985,-1,3695,2313,1038,-1,3674,2313,3695,-1,3679,3787,4874,-1,3787,3679,3678,-1,2326,993,2971,-1,2323,993,2326,-1,1040,2346,2979,-1,1040,3708,2346,-1,2321,3254,4876,-1,3254,2321,972,-1,2302,3685,4871,-1,2302,3683,3685,-1,2974,3250,2975,-1,2974,3686,3250,-1,1024,2976,2975,-1,2976,1024,1023,-1,1005,4867,1006,-1,1005,5000,4867,-1,2340,4887,2290,-1,4887,2340,4885,-1,1030,1028,4890,-1,3253,1028,1030,-1,3690,3656,4882,-1,3690,3655,3656,-1,1026,1000,1027,-1,998,1000,1026,-1,1049,3261,1050,-1,3261,1049,983,-1,3708,1039,1056,-1,1039,3708,1040,-1,3701,1017,5002,-1,1017,3701,3676,-1,3703,3679,5003,-1,3679,3703,3677,-1,3257,1045,1070,-1,1046,1045,3257,-1,3686,975,3688,-1,2970,975,3686,-1,4890,3705,3706,-1,1028,3705,4890,-1,1080,1057,3706,-1,1080,1058,1057,-1,3687,4889,4997,-1,4879,4889,3687,-1,2966,3649,3715,-1,3264,3649,2966,-1,3709,5004,5003,-1,3709,2304,5004,-1,1045,3710,3241,-1,3245,3710,1045,-1,1051,3713,2312,-1,1051,3722,3713,-1,2297,3713,3721,-1,3713,2297,3712,-1,1065,2294,1066,-1,1065,3714,2294,-1,3242,1090,3237,-1,1068,1090,3242,-1,3718,5004,4869,-1,5004,3718,3717,-1,3719,3241,4868,-1,3241,3719,1069,-1,4873,3723,3722,-1,4873,3730,3723,-1,1080,3724,1081,-1,3707,3724,1080,-1,3740,3670,2334,-1,3740,3725,3670,-1,3724,1085,3727,-1,1086,1085,3724,-1,3730,3738,3731,-1,3737,3738,3730,-1,3732,1087,3238,-1,1087,3732,3714,-1,3654,4891,3653,-1,3651,4891,3654,-1,3734,3718,5005,-1,3718,3734,3716,-1,3720,5006,3736,-1,3719,5006,3720,-1,5007,1095,4870,-1,5007,1096,1095,-1,3684,4883,3667,-1,4883,3684,3683,-1,5008,3754,3752,-1,3754,5008,5006,-1,3731,5009,3729,-1,3731,3745,5009,-1,3747,1089,3236,-1,1089,3747,3238,-1,995,4865,2329,-1,2295,4865,995,-1,1101,2333,1102,-1,981,2333,1101,-1,3770,3751,3749,-1,3751,3770,5005,-1,3682,3772,4998,-1,3771,3772,3682,-1,5007,3233,1108,-1,3755,3233,5007,-1,3758,3770,3768,-1,3770,3758,3757,-1,3759,5008,4860,-1,5008,3759,3761,-1,3764,5009,4859,-1,5009,3764,3763,-1,3746,1112,1114,-1,3747,1112,3746,-1,3782,964,3263,-1,3748,964,3782,-1,3235,3767,3783,-1,1102,3767,3235,-1,4880,4877,4876,-1,3669,4877,4880,-1,3756,1106,3233,-1,3756,5010,1106,-1,4855,3783,3785,-1,3783,4855,4863,-1,3232,3758,3775,-1,3758,3232,1109,-1,3760,2986,2287,-1,3759,2986,3760,-1,3779,3764,5011,-1,3764,3779,3762,-1,3766,3231,3793,-1,1114,3231,3766,-1,1104,2288,2985,-1,1103,2288,1104,-1,3647,4884,4996,-1,4884,3647,4892,-1,1110,1116,1115,-1,1110,3547,1116,-1,3779,3553,3555,-1,5011,3553,3779,-1,3793,3551,3791,-1,3231,3551,3793,-1,3272,5010,4992,-1,5010,3272,1106,-1,3785,3794,2947,-1,3784,3794,3785,-1,2384,3774,3545,-1,3774,2384,3775,-1,4841,4805,3811,-1,4841,4803,4805,-1,3797,5012,4810,-1,5012,3797,3796,-1,3799,2995,4823,-1,2995,3799,2250,-1,1131,3838,3228,-1,3957,3838,1131,-1,2256,5013,4842,-1,2256,1137,5013,-1,3226,3803,3802,-1,3226,1145,3803,-1,3807,3913,5014,-1,3913,3807,3806,-1,4843,3809,2257,-1,4843,5014,3809,-1,1195,2272,3810,-1,1196,2272,1195,-1,3813,4854,3928,-1,3813,3812,4854,-1,1160,3927,3812,-1,3927,1160,1159,-1,5015,2999,1166,-1,2999,5015,4848,-1,5016,3818,3872,-1,3844,3818,5016,-1,3822,2269,5017,-1,2269,3822,3821,-1,2258,5018,3825,-1,2993,5018,2258,-1,1214,1166,1165,-1,1214,5015,1166,-1,3830,3827,5019,-1,3830,3826,3827,-1,5020,3830,4852,-1,3829,3830,5020,-1,5021,1168,2266,-1,1169,1168,5021,-1,3833,3223,1173,-1,3223,3833,3835,-1,1176,4850,3222,-1,4849,4850,1176,-1,3954,3837,3900,-1,3836,3837,3954,-1,5022,3926,4845,-1,5022,3924,3926,-1,3839,3921,3842,-1,5023,3921,3839,-1,1120,2275,1121,-1,1120,1144,2275,-1,1202,2270,2252,-1,1202,5017,2270,-1,3003,5021,3843,-1,3003,3816,5021,-1,5020,1194,3894,-1,2992,1194,5020,-1,3847,5016,3878,-1,5016,3847,3844,-1,3851,5024,3912,-1,3851,3850,5024,-1,2251,1197,2995,-1,2251,3219,1197,-1,1205,1118,1206,-1,1127,1118,1205,-1,5012,3856,2278,-1,3856,5012,5025,-1,4815,3857,3859,-1,3857,4815,3930,-1,1212,4832,1213,-1,1212,5026,4832,-1,3955,2280,3848,-1,2280,3955,2281,-1,3949,1210,1209,-1,3949,1185,1210,-1,4850,3862,5027,-1,3834,3862,4850,-1,3864,1175,4837,-1,1175,3864,1172,-1,3863,4836,3865,-1,3864,4836,3863,-1,3867,3216,1228,-1,5027,3216,3867,-1,3844,3819,3818,-1,3846,3819,3844,-1,3866,5028,3870,-1,3865,5028,3866,-1,2264,3860,2248,-1,2264,2991,3860,-1,5028,3215,3873,-1,1234,3215,5028,-1,3875,4835,3873,-1,3875,5029,4835,-1,3877,2259,3879,-1,2260,2259,3877,-1,3883,3891,3881,-1,5029,3891,3883,-1,5019,2996,5026,-1,5019,3827,2996,-1,3823,4844,3894,-1,3823,4853,4844,-1,3889,4833,5030,-1,4833,3889,3891,-1,3893,3889,3899,-1,3889,3893,3890,-1,1212,3828,4851,-1,2249,3828,1212,-1,5031,4831,4829,-1,4831,5031,5030,-1,3897,5031,3961,-1,5031,3897,3899,-1,2249,1155,3828,-1,1217,1155,2249,-1,1181,3214,4826,-1,1180,3214,1181,-1,2280,2241,1238,-1,2279,2241,2280,-1,3907,1198,3219,-1,1198,3907,3214,-1,3910,3907,3906,-1,3907,3910,4825,-1,3905,1237,1236,-1,3905,3912,1237,-1,3806,3850,3913,-1,3850,3806,5024,-1,3910,3914,4824,-1,3910,3908,3914,-1,4821,3916,3917,-1,3914,3916,4821,-1,1137,3799,5013,-1,1137,1240,3799,-1,1119,1206,1118,-1,1206,1119,4820,-1,1239,3919,3213,-1,3917,3919,1239,-1,4841,3813,3929,-1,4841,3811,3813,-1,3933,3842,3922,-1,3842,3933,3840,-1,3935,3926,3923,-1,3926,3935,1182,-1,3802,3927,3226,-1,3802,3936,3927,-1,3932,3920,3937,-1,3920,3932,3922,-1,1243,3925,3212,-1,3925,1243,3923,-1,3943,1243,1242,-1,1243,3943,3934,-1,3946,3930,3928,-1,3930,3946,3857,-1,3932,3941,3931,-1,3932,3938,3941,-1,3941,3951,4812,-1,3941,3940,3951,-1,5025,3945,3856,-1,3943,3945,5025,-1,3859,3948,4809,-1,3859,3858,3948,-1,3942,3952,3940,-1,3942,3962,3952,-1,3964,3945,3944,-1,3964,3953,3945,-1,4804,1122,1121,-1,4804,1184,1122,-1,4804,3220,1184,-1,4804,4845,3220,-1,4804,5022,4845,-1,4804,4847,5022,-1,4804,3841,4847,-1,4846,3841,4804,-1,4846,3839,3841,-1,4846,5023,3839,-1,1171,1214,1174,-1,1178,4849,1176,-1,2247,4849,1178,-1,2247,3832,4849,-1,4848,3832,2247,-1,4848,3835,3832,-1,5015,3835,4848,-1,1214,3835,5015,-1,1214,3223,3835,-1,1214,1171,3223,-1,3919,3959,4922,-1,3918,3959,3919,-1,2282,3896,1203,-1,2282,3561,3896,-1,3898,2372,2375,-1,3897,2372,3898,-1,3947,1244,924,-1,3947,1209,1244,-1,3947,3949,1209,-1,3952,3558,3950,-1,3952,3557,3558,-1,925,3855,3953,-1,925,1219,3855,-1,925,4839,1219,-1,3966,5032,4774,-1,5032,3966,3968,-1,4075,5033,4795,-1,4078,5033,4075,-1,2187,3973,3970,-1,2187,4018,3973,-1,4017,3988,4015,-1,3988,4017,3986,-1,3981,4021,3979,-1,3984,4021,3981,-1,4081,3981,3980,-1,4081,3983,3981,-1,1354,3991,1247,-1,1354,4083,3991,-1,3992,1245,1247,-1,3992,4048,1245,-1,4083,3994,3991,-1,4083,2166,3994,-1,2175,3996,2176,-1,3019,3996,2175,-1,1306,2218,1304,-1,2218,1306,1347,-1,1252,1256,2188,-1,1256,1252,1251,-1,4003,4777,5034,-1,4003,4004,4777,-1,2179,4005,2183,-1,2179,1262,4005,-1,2221,4008,4007,-1,4008,2221,2220,-1,2171,4045,4010,-1,2171,5035,4045,-1,3030,3206,5036,-1,3206,3030,1298,-1,4001,4011,3999,-1,4001,4770,4011,-1,3201,1270,4088,-1,1271,1270,3201,-1,1273,3210,1274,-1,1273,3208,3210,-1,5037,3197,4012,-1,5037,1329,3197,-1,1337,2174,4014,-1,1337,1267,2174,-1,1286,2180,2182,-1,1286,1281,2180,-1,4016,4796,4060,-1,4016,4015,4796,-1,3973,4072,3971,-1,3973,4019,4072,-1,4794,3978,3975,-1,4794,5038,3978,-1,4071,4023,4024,-1,4023,4071,4040,-1,4027,4086,4025,-1,5039,4086,4027,-1,4042,4032,4029,-1,4042,4779,4032,-1,4038,2203,3021,-1,4037,2203,4038,-1,4037,1290,2203,-1,1290,2209,1291,-1,1290,4037,2209,-1,2205,4039,1293,-1,4023,4039,2205,-1,3028,4043,2168,-1,4043,3028,4033,-1,1298,1349,3206,-1,1298,1297,1349,-1,4046,1300,4010,-1,4046,3205,1300,-1,1302,3999,1303,-1,1302,4002,3999,-1,3990,2197,2196,-1,3990,4047,2197,-1,3204,3998,1306,-1,3204,4792,3998,-1,1356,4055,1357,-1,1356,4053,4055,-1,4054,4051,3194,-1,4053,4051,4054,-1,1357,1268,1339,-1,1357,4055,1268,-1,3203,1271,4050,-1,3203,3210,1271,-1,3022,1307,2213,-1,3022,1308,1307,-1,2199,3008,1317,-1,2199,3009,3008,-1,1262,4058,4005,-1,4058,1262,4049,-1,5040,4003,5034,-1,5040,4090,4003,-1,4771,4062,4064,-1,4771,5041,4062,-1,4089,1259,2230,-1,4089,4077,1259,-1,2164,3031,1352,-1,2164,1321,3031,-1,3196,3191,2173,-1,2189,3191,3196,-1,4068,3191,2189,-1,2227,2202,3200,-1,2227,2225,2202,-1,1313,4009,4070,-1,3199,4009,1313,-1,1327,1323,1328,-1,1327,5035,1323,-1,4035,3208,1273,-1,4035,4034,3208,-1,3974,4019,4020,-1,3969,4019,3974,-1,5033,4074,5038,-1,4073,4074,5033,-1,1333,1329,1331,-1,1333,3197,1329,-1,2208,4076,4775,-1,2207,4076,2208,-1,4059,3006,2229,-1,4059,4786,3006,-1,5032,4790,1330,-1,5032,3968,4790,-1,4076,4795,3985,-1,4075,4795,4076,-1,3987,4013,4079,-1,4013,3987,4012,-1,3033,4791,2165,-1,3033,4014,4791,-1,3209,4024,1269,-1,3209,4071,4024,-1,3199,3007,4082,-1,3199,1340,3007,-1,4008,4041,4006,-1,4008,4039,4041,-1,1288,1345,1285,-1,1345,1288,3194,-1,3205,5039,1299,-1,3205,4084,5039,-1,2215,4030,3012,-1,2215,4085,4030,-1,4087,3997,4785,-1,3997,4087,3996,-1,2202,2224,2192,-1,2202,2225,2224,-1,2221,2190,2223,-1,2190,2221,4069,-1,1264,1351,3193,-1,1264,2172,1351,-1,3017,3194,1287,-1,3194,3017,4054,-1,2181,3204,2231,-1,2181,4792,3204,-1,4077,4091,4993,-1,4089,4091,4077,-1,4092,4994,5041,-1,4092,4093,4994,-1,2366,2193,3027,-1,2366,4919,2193,-1,4067,1359,3570,-1,1360,1359,4067,-1,4057,2951,1319,-1,4057,3563,2951,-1,3565,4090,5040,-1,3565,3566,4090,-1,4764,4105,3035,-1,4764,4761,4105,-1,3036,1363,4112,-1,1364,1363,3036,-1,4117,4103,4100,-1,4103,4117,4764,-1,3188,3035,4104,-1,3035,3188,1365,-1,3187,4108,4095,-1,3187,1370,4108,-1,1372,4098,4110,-1,4098,1372,1371,-1,4111,4760,4121,-1,4760,4111,4110,-1,4763,4114,4755,-1,4112,4114,4763,-1,4754,4117,4115,-1,4117,4754,4762,-1,4127,3188,3186,-1,3188,4127,1366,-1,4759,4108,4129,-1,4108,4759,4107,-1,4113,4136,4123,-1,4758,4136,4113,-1,1377,4757,4137,-1,4757,1377,4116,-1,4756,1375,1374,-1,4756,3038,1375,-1,4118,4126,4141,-1,4125,4126,4118,-1,4131,4129,4128,-1,4129,4131,4759,-1,2158,4131,2156,-1,4131,2158,4122,-1,5042,4136,4133,-1,4136,5042,4123,-1,4137,1378,1377,-1,4137,1385,1378,-1,4130,3184,1382,-1,4139,3184,4130,-1,4132,1381,4142,-1,1382,1381,4132,-1,5042,4143,4158,-1,4133,4143,5042,-1,1385,4146,1378,-1,1385,1384,4146,-1,4147,3039,4745,-1,3039,4147,3040,-1,5043,4148,5044,-1,2154,4148,5043,-1,4151,4142,1381,-1,4151,5045,4142,-1,4154,5046,4144,-1,4154,4152,5046,-1,1383,4157,5047,-1,4155,4157,1383,-1,4163,4145,4159,-1,4145,4163,4749,-1,5048,4163,4161,-1,4163,5048,4746,-1,5049,4148,4164,-1,4148,5049,5044,-1,4167,5045,4151,-1,4167,5050,5045,-1,5046,4169,5051,-1,4152,4169,5046,-1,5047,4171,5052,-1,4157,4171,5047,-1,939,4740,5052,-1,939,4913,4740,-1,2357,5048,4161,-1,2357,3580,5048,-1,2355,5049,4164,-1,2355,2354,5049,-1,4175,5050,4167,-1,4175,4912,5050,-1,5051,3573,2959,-1,4169,3573,5051,-1,939,4171,3269,-1,4171,939,5052,-1,4274,3583,4176,-1,4274,3582,3583,-1,1387,1391,1390,-1,1391,1387,1386,-1,3589,1392,4717,-1,3589,3180,1392,-1,4181,3179,3587,-1,1397,3179,4181,-1,4184,3586,4275,-1,4184,3585,3586,-1,2122,4187,3054,-1,4187,2122,2150,-1,4190,2124,3178,-1,4190,3053,2124,-1,4192,4246,4218,-1,4192,4191,4246,-1,1399,4195,1400,-1,4194,4195,1399,-1,1401,1420,1402,-1,1401,3055,1420,-1,4722,1405,4731,-1,1406,1405,4722,-1,1439,4198,2123,-1,4198,1439,4732,-1,3061,4232,4200,-1,4721,4232,3061,-1,2135,3058,4229,-1,2135,2136,3058,-1,3047,1410,3049,-1,3047,4204,1410,-1,4201,4254,3059,-1,4201,4242,4254,-1,4250,4208,4205,-1,4250,4245,4208,-1,4254,4212,4209,-1,4254,4242,4212,-1,4213,4725,2133,-1,4213,5053,4725,-1,4223,1418,4194,-1,1419,1418,4223,-1,4188,4219,4216,-1,4219,4188,5054,-1,4220,2151,5055,-1,4220,2150,2151,-1,1421,2133,1422,-1,1421,4213,2133,-1,2142,4222,3172,-1,2142,1419,4222,-1,1428,1425,1424,-1,1428,1427,1425,-1,2129,4224,2126,-1,2129,5054,4224,-1,4227,5056,5055,-1,5056,4227,4225,-1,4725,1431,1430,-1,4725,5053,1431,-1,1434,1437,1435,-1,1438,1437,1434,-1,4235,4233,4202,-1,4235,4231,4233,-1,4221,4234,4231,-1,1423,4234,4221,-1,5056,4239,4238,-1,5056,4244,4239,-1,4263,1415,4240,-1,4263,1413,1415,-1,4242,2132,4212,-1,2132,4242,4241,-1,4245,4237,4208,-1,4237,4245,4244,-1,4191,3177,4246,-1,3177,4191,4199,-1,2148,3169,1400,-1,3170,3169,2148,-1,1443,3173,4204,-1,3173,1443,1442,-1,4206,3051,4249,-1,3051,4206,4236,-1,2117,4252,4251,-1,4252,2117,4211,-1,4720,4718,5057,-1,3062,4718,4720,-1,1448,1446,1449,-1,3057,1446,1448,-1,3048,5058,3046,-1,3048,4259,5058,-1,5059,4263,4261,-1,4263,5059,4724,-1,4253,5060,4251,-1,4253,4264,5060,-1,4269,2118,4275,-1,2118,4269,4267,-1,4181,4270,5057,-1,4181,4180,4270,-1,1392,3167,1449,-1,1392,1394,3167,-1,5058,1391,4272,-1,5058,3181,1391,-1,5059,4274,4273,-1,5059,4730,4274,-1,5060,4184,3063,-1,5060,4183,4184,-1,4280,4706,4714,-1,4280,4279,4706,-1,1452,4355,4713,-1,1452,1451,4355,-1,4292,1520,4282,-1,4292,3065,1520,-1,4285,1474,5061,-1,1474,4285,2105,-1,2095,1457,5062,-1,1458,1457,2095,-1,3068,2110,2109,-1,4294,2110,3068,-1,2059,1459,2107,-1,2059,1460,1459,-1,4704,2073,4716,-1,2073,4704,3076,-1,4288,4715,4278,-1,5063,4715,4288,-1,5064,3166,4290,-1,5064,4283,3166,-1,4703,1536,2067,-1,4703,4284,1536,-1,1515,4295,3158,-1,1515,5065,4295,-1,5066,4296,4297,-1,5066,4286,4296,-1,1481,4362,3157,-1,4362,1481,4707,-1,2058,4710,4700,-1,4710,2058,4304,-1,2106,1474,2105,-1,1475,1474,2106,-1,4301,3079,4277,-1,4300,3079,4301,-1,4302,4307,4702,-1,4305,4307,4302,-1,3081,1530,1479,-1,3081,4309,1530,-1,2074,3082,4707,-1,2074,1486,3082,-1,4317,3268,3601,-1,4317,4365,3268,-1,3163,2061,1487,-1,3602,2061,3163,-1,4320,3602,3603,-1,4320,2061,3602,-1,4324,4695,4905,-1,4324,4323,4695,-1,4329,4697,3591,-1,4329,4326,4697,-1,3597,4331,4330,-1,3597,1538,4331,-1,1537,3162,1526,-1,1537,1490,3162,-1,3161,1499,4363,-1,1499,3161,1496,-1,5064,4335,4334,-1,5064,4698,4335,-1,2084,4347,3074,-1,2084,1532,4347,-1,4339,2087,4359,-1,2087,4339,3073,-1,4297,4353,5066,-1,4297,4351,4353,-1,2072,1519,1518,-1,2072,2065,1519,-1,1502,2068,1535,-1,1502,1500,2068,-1,3155,1503,1467,-1,3155,2077,1503,-1,1505,4357,4341,-1,1505,3160,4357,-1,1519,1479,3157,-1,1479,1519,3081,-1,4358,4336,5063,-1,4358,4337,4336,-1,4349,1527,1528,-1,4349,4350,1527,-1,1470,1511,1510,-1,1529,1511,1470,-1,1513,2100,4349,-1,2100,1513,3158,-1,1468,4353,4352,-1,1504,4353,1468,-1,4281,4306,4279,-1,4306,4281,4307,-1,2110,4712,3066,-1,2110,4294,4712,-1,5065,4356,4295,-1,4356,5065,5061,-1,2109,1465,3068,-1,5062,1465,2109,-1,3162,1507,1526,-1,1507,3162,3160,-1,4348,1484,3071,-1,1528,1484,4348,-1,1511,4297,1512,-1,1511,4351,4297,-1,4337,1532,1531,-1,4337,4347,1532,-1,4359,4335,4339,-1,4335,4359,4333,-1,4308,4299,4709,-1,4299,4305,4302,-1,4299,4308,4305,-1,4328,1497,3161,-1,4328,4708,1497,-1,3152,1491,1490,-1,3152,4313,1491,-1,4315,4365,4317,-1,2089,4365,4315,-1,2082,4321,2083,-1,2082,4320,4321,-1,4325,2085,4323,-1,2085,4325,2086,-1,4700,2059,2058,-1,4700,1460,2059,-1,4371,4398,4369,-1,4670,4398,4371,-1,4374,4664,4394,-1,4664,4374,4373,-1,4377,4392,4378,-1,4669,4392,4377,-1,4382,4665,4389,-1,4665,4382,4381,-1,4688,4385,4689,-1,4688,4404,4385,-1,4407,4382,4388,-1,4382,4407,4380,-1,4411,4378,4391,-1,4378,4411,4376,-1,4414,4374,4395,-1,4374,4414,4372,-1,4370,4397,4399,-1,4369,4397,4370,-1,4690,4401,4419,-1,4399,4401,4690,-1,4390,4405,4421,-1,4403,4405,4390,-1,4425,4409,4406,-1,4409,4425,4393,-1,4429,4413,4410,-1,4413,4429,4396,-1,1539,4415,4434,-1,4415,1539,2055,-1,4419,4683,4417,-1,4401,4683,4419,-1,4421,4682,4422,-1,4405,4682,4421,-1,4426,4406,4681,-1,4406,4426,4425,-1,4410,4430,4429,-1,4410,5067,4430,-1,4430,4433,4428,-1,4430,4680,4433,-1,3151,4687,1541,-1,3151,4449,4687,-1,4436,4686,4418,-1,4436,4452,4686,-1,4455,4420,4437,-1,4420,4455,4685,-1,4443,4424,4439,-1,4424,4443,4684,-1,4462,4443,4441,-1,4443,4462,5068,-1,4468,4432,4444,-1,4432,4468,1540,-1,4435,4448,4472,-1,4446,4448,4435,-1,4438,4453,4476,-1,4451,4453,4438,-1,4460,4457,4454,-1,4457,4460,4440,-1,4481,4460,4458,-1,4460,4481,4442,-1,4485,4464,4461,-1,4464,4485,4445,-1,4447,4467,4491,-1,4465,4467,4447,-1,4450,4471,4677,-1,4469,4471,4450,-1,4679,4676,4494,-1,4677,4676,4679,-1,4495,4479,4477,-1,4479,4495,4459,-1,4497,4483,4480,-1,4483,4497,4463,-1,4502,4487,4484,-1,4487,4502,4466,-1,4470,4490,4492,-1,4488,4490,4470,-1,4678,3611,4899,-1,4492,3611,4678,-1,4478,3614,4897,-1,4493,3614,4478,-1,4896,4496,3618,-1,4496,4896,4482,-1,4895,4498,3620,-1,4498,4895,4486,-1,4489,4501,4995,-1,4499,4501,4489,-1,4510,1545,1546,-1,1545,4510,1556,-1,5069,4505,4656,-1,4503,4505,5069,-1,1547,5070,5071,-1,5070,1547,3150,-1,2052,4511,4509,-1,4511,2052,2054,-1,3084,4513,4523,-1,2053,4513,3084,-1,5071,4516,4524,-1,4515,4516,5071,-1,4529,4504,4517,-1,4504,4529,4505,-1,4522,1546,4519,-1,1546,4522,4510,-1,4653,4522,4520,-1,4522,4653,4660,-1,4659,3088,5072,-1,4523,3088,4659,-1,4658,4526,5073,-1,4524,4526,4658,-1,4532,4529,4527,-1,4529,4532,4657,-1,5074,4532,4530,-1,4532,5074,4655,-1,5075,4521,4533,-1,4521,5075,4520,-1,5076,4539,5072,-1,5076,4538,4539,-1,4542,5077,4543,-1,5073,5077,4542,-1,4545,4543,5078,-1,4543,4545,4541,-1,5074,4548,4547,-1,5074,5079,4548,-1,4549,5075,5080,-1,5075,4549,4551,-1,5076,1554,4652,-1,1555,1554,5076,-1,4554,5077,4552,-1,4554,4555,5077,-1,5078,4557,4648,-1,4555,4557,5078,-1,4647,4560,4558,-1,4560,4647,5079,-1,4646,4563,4561,-1,4563,4646,5080,-1,1554,4565,4566,-1,1553,4565,1554,-1,4650,4568,4645,-1,4566,4568,4650,-1,4570,4557,4556,-1,4570,4644,4557,-1,4643,4559,4572,-1,4559,4643,4558,-1,4640,4562,4575,-1,4562,4640,4561,-1,4565,4579,4567,-1,4564,4579,4565,-1,4568,4582,4637,-1,4567,4582,4568,-1,4570,4584,4635,-1,4569,4584,4570,-1,4633,4574,4586,-1,4574,4633,4572,-1,4577,4592,4575,-1,4577,4589,4592,-1,4592,3624,4641,-1,4592,3623,3624,-1,4582,3627,3625,-1,4581,3627,4582,-1,4584,3629,3628,-1,4583,3629,4584,-1,3630,4588,3631,-1,4588,3630,4586,-1,4593,4591,4599,-1,4591,4593,4589,-1,1953,1601,4601,-1,1953,1602,1601,-1,1863,1929,3135,-1,1929,1863,3124,-1,1579,3092,1582,-1,1593,3092,1579,-1,1581,1590,1588,-1,1580,1590,1581,-1,1571,1563,1578,-1,1571,1596,1563,-1,2035,2032,1924,-1,2032,2035,1950,-1,1899,5081,1759,-1,4627,5081,1899,-1,1611,1899,1898,-1,1698,1899,1611,-1,1821,1617,1616,-1,1617,1821,1879,-1,3148,4628,1621,-1,4628,3148,3132,-1,1632,1636,1633,-1,1913,1636,1632,-1,2018,1700,3147,-1,1700,2018,2017,-1,3097,3089,3125,-1,3089,3097,1645,-1,3499,1992,3496,-1,3499,1986,1992,-1,1659,575,1660,-1,1659,1735,575,-1,1728,1662,2013,-1,1728,1663,1662,-1,573,1722,574,-1,573,1720,1722,-1,2043,1615,1949,-1,1615,2043,1575,-1,2017,1701,1700,-1,1701,2017,1922,-1,1845,5082,1606,-1,1845,1669,5082,-1,4620,3119,4607,-1,1832,3119,4620,-1,1943,3119,1832,-1,2004,3126,1916,-1,2004,2002,3126,-1,2000,2816,2001,-1,2816,2000,4608,-1,1806,1604,3137,-1,1604,1806,2031,-1,1994,1617,4631,-1,1994,1812,1617,-1,1714,1877,1814,-1,1712,1877,1714,-1,1982,1672,1718,-1,1672,1982,1721,-1,1728,1731,1663,-1,1728,1970,1731,-1,1734,1735,1659,-1,1734,1736,1735,-1,1746,3139,3112,-1,1746,1917,3139,-1,1751,4614,3106,-1,4626,4614,1751,-1,1785,1753,1758,-1,1785,1754,1753,-1,4612,1759,5081,-1,4612,1762,1759,-1,1763,4610,3138,-1,1763,3131,4610,-1,1968,3108,3110,-1,1968,1971,3108,-1,3109,2021,1652,-1,2021,3109,3122,-1,1802,3130,5083,-1,1802,1801,3130,-1,1963,1959,1928,-1,1609,1959,1963,-1,3132,1823,1889,-1,3148,1823,3132,-1,1854,1678,1826,-1,1666,1678,1854,-1,1830,1827,1945,-1,2006,1827,1830,-1,3136,1840,1839,-1,1840,3136,1833,-1,4618,1831,3121,-1,1946,1831,4618,-1,1833,1837,1944,-1,1833,3136,1837,-1,1837,3133,1944,-1,1837,4621,3133,-1,3120,1825,1824,-1,1825,3120,1854,-1,1623,1948,4629,-1,1623,1885,1948,-1,3123,1869,1858,-1,3123,1868,1869,-1,3142,4601,4627,-1,1953,4601,3142,-1,1871,3149,2023,-1,3149,1871,1646,-1,3134,1871,3098,-1,1872,1871,3134,-1,1712,1709,1713,-1,1709,1712,1714,-1,3105,1704,3134,-1,3105,1705,1704,-1,1884,1566,4632,-1,1884,1883,1566,-1,4632,1561,3089,-1,1561,4632,1566,-1,4616,1823,4629,-1,1824,1823,4616,-1,4628,1893,1675,-1,1891,1893,4628,-1,1803,4622,1890,-1,1803,3113,4622,-1,4627,4603,5081,-1,4627,4601,4603,-1,3113,4623,4622,-1,4623,3113,5083,-1,3114,5083,3113,-1,3114,1802,5083,-1,1903,3116,1967,-1,1903,1801,3116,-1,1920,1702,1701,-1,1702,1920,1904,-1,1691,1980,1983,-1,1904,1980,1691,-1,1640,3129,1643,-1,1640,1908,3129,-1,1776,1769,1773,-1,1776,1977,1769,-1,4624,1904,1920,-1,1904,4624,1981,-1,1967,1900,1937,-1,1967,3116,1900,-1,1975,4613,4611,-1,4613,1975,3106,-1,4609,1606,5082,-1,1604,1606,4609,-1,3148,4629,1823,-1,3148,1623,4629,-1,1859,1848,1856,-1,4630,1848,1859,-1,1566,1868,3123,-1,1566,1883,1868,-1,1715,1812,1994,-1,1956,1812,1715,-1,1715,1814,1956,-1,1715,1714,1814,-1,1822,1965,1820,-1,1699,1965,1822,-1,1567,1858,1882,-1,1567,3123,1858,-1,2029,4616,1947,-1,4616,2029,1667,-1,1836,1860,1843,-1,4617,1860,1836,-1,4615,4607,1603,-1,4607,4615,4620,-1,3121,1830,1931,-1,1831,1830,3121,-1,1939,3091,3090,-1,3118,3091,1939,-1,4619,1683,1946,-1,2005,1683,4619,-1,1615,1947,1949,-1,2029,1947,1615,-1,1807,1608,1607,-1,3115,1608,1807,-1,1950,1815,2033,-1,1950,3117,1815,-1,1956,1955,1812,-1,1816,1955,1956,-1,1821,1960,1619,-1,1820,1960,1821,-1,3115,2030,1608,-1,3115,1961,2030,-1,1807,1954,1952,-1,3137,1954,1807,-1,5083,4625,4623,-1,5083,3130,4625,-1,3111,1761,1760,-1,1761,3111,1937,-1,1788,3122,3109,-1,3122,1788,1784,-1,4626,1723,1918,-1,1724,1723,4626,-1,1771,1790,1789,-1,1771,1794,1790,-1,1649,1968,1969,-1,1968,1649,1971,-1,3110,1798,1973,-1,3110,3108,1798,-1,1767,1977,1776,-1,1767,1766,1977,-1,1756,1732,1731,-1,1732,1756,1768,-1,4613,5081,4603,-1,4613,4612,5081,-1,1978,4626,1918,-1,1978,4614,4626,-1,1782,3112,1966,-1,1782,1746,3112,-1,1742,3100,1743,-1,3100,1742,1990,-1,1703,1880,1704,-1,1703,1878,1880,-1,3140,1878,1703,-1,4631,1878,3140,-1,1713,1708,2049,-1,1713,1709,1708,-1,1962,1901,3104,-1,1962,1809,1901,-1,2002,1690,1689,-1,2002,2004,1690,-1,3128,2000,1914,-1,3128,4608,2000,-1,1693,1689,1694,-1,2003,1689,1693,-1,2036,1832,4620,-1,2036,1840,1832,-1,1669,2034,5082,-1,1669,1668,2034,-1,1564,1862,1565,-1,2009,1862,1564,-1,2047,1578,1563,-1,1578,2047,1938,-1,1722,3497,574,-1,1722,1988,3497,-1,1735,579,575,-1,1987,579,1735,-1,3146,3096,3095,-1,1657,3096,3146,-1,3499,1985,1986,-1,3499,3099,1985,-1,1674,2024,4604,-1,1674,1673,2024,-1,2025,1884,4632,-1,1884,2025,1627,-1,1936,2022,1654,-1,1936,4605,2022,-1,1643,4606,1640,-1,1643,3097,4606,-1,2027,3142,1699,-1,2027,1953,3142,-1,1613,1842,3144,-1,1613,3093,1842,-1,2031,1696,1695,-1,2031,1806,1696,-1,5082,2033,4609,-1,2034,2033,5082,-1,2038,1583,1582,-1,2038,2039,1583,-1,2044,1588,1576,-1,1588,2044,2040,-1,2043,2041,2044,-1,2043,2010,2041,-1,1572,3090,3091,-1,2039,3090,1572,-1,1891,3132,1890,-1,3132,1891,4628,-1,1556,4662,1543,-1,1556,5069,4662,-1,1556,4503,5069,-1,4511,4503,1556,-1,4511,4506,4503,-1,2054,4506,4511,-1,2054,1549,4506,-1,2054,3150,1549,-1,2054,5070,3150,-1,2054,4661,5070,-1,3086,4661,2054,-1,3086,4507,4661,-1,3621,4586,3630,-1,4586,3621,4633,-1,4635,3628,4634,-1,4584,3628,4635,-1,4637,3625,4636,-1,4582,3625,4637,-1,4639,4641,3624,-1,4641,4639,4638,-1,4641,4575,4592,-1,4575,4641,4640,-1,4600,4572,4633,-1,4572,4600,4643,-1,4644,4635,4598,-1,4570,4635,4644,-1,4645,4637,4596,-1,4568,4637,4645,-1,4595,4642,4638,-1,4642,4595,4578,-1,4642,4561,4640,-1,4561,4642,4646,-1,4590,4558,4643,-1,4558,4590,4647,-1,4648,4644,4587,-1,4557,4644,4648,-1,4649,4645,4585,-1,4650,4645,4649,-1,4652,4566,4650,-1,1554,4566,4652,-1,4580,5080,4646,-1,5080,4580,4549,-1,4576,5079,4647,-1,5079,4576,4548,-1,4573,5078,4648,-1,5078,4573,4545,-1,4649,4553,4651,-1,4649,4571,4553,-1,4538,4652,4651,-1,5076,4652,4538,-1,4533,5080,5075,-1,4533,4563,5080,-1,5079,4530,4560,-1,4530,5079,5074,-1,4543,4555,5078,-1,5077,4555,4543,-1,5073,4552,5077,-1,4526,4552,5073,-1,5072,1555,5076,-1,3088,1555,5072,-1,4520,4551,4653,-1,4520,5075,4551,-1,4547,4655,5074,-1,4655,4547,4654,-1,4655,4657,4532,-1,4657,4655,1551,-1,4518,5073,4542,-1,4658,5073,4518,-1,5072,4514,4659,-1,5072,4539,4514,-1,4512,4653,4537,-1,4660,4653,4512,-1,4534,1552,4654,-1,1552,4534,3087,-1,4657,4505,4529,-1,4505,4657,4656,-1,1547,4524,4658,-1,5071,4524,1547,-1,4523,3085,3084,-1,4523,4659,3085,-1,4660,4510,4522,-1,4510,4660,4509,-1,3086,2053,3084,-1,2054,2053,3086,-1,5071,4661,4515,-1,4661,5071,5070,-1,4662,4656,1550,-1,5069,4656,4662,-1,4490,4995,3613,-1,4489,4995,4490,-1,4672,4486,4895,-1,4486,4672,4484,-1,4673,4482,4896,-1,4482,4673,4480,-1,4674,4478,4897,-1,4478,4674,4477,-1,4676,4899,4675,-1,4678,4899,4676,-1,4471,4492,4678,-1,4470,4492,4471,-1,4467,4502,4499,-1,4466,4502,4467,-1,4498,4463,4497,-1,4463,4498,4461,-1,4496,4459,4495,-1,4459,4496,4458,-1,4474,4494,4493,-1,4679,4494,4474,-1,4453,4677,4679,-1,4450,4677,4453,-1,4448,4491,4488,-1,4447,4491,4448,-1,4487,4445,4485,-1,4445,4487,4444,-1,4483,4442,4481,-1,4442,4483,4441,-1,4479,4473,4475,-1,4473,4479,4456,-1,4437,4476,4473,-1,4438,4476,4437,-1,4436,4472,4469,-1,4435,4472,4436,-1,3151,4468,4465,-1,1540,4468,3151,-1,4464,5068,4462,-1,5068,4464,4680,-1,5068,4684,4443,-1,4684,5068,5067,-1,4457,4685,4455,-1,4685,4457,4681,-1,4682,4452,4451,-1,4686,4452,4682,-1,4683,4449,4446,-1,4687,4449,4683,-1,5067,4680,4430,-1,5067,5068,4680,-1,5067,4412,4684,-1,4412,5067,4410,-1,4681,4408,4685,-1,4408,4681,4406,-1,4405,4686,4682,-1,4402,4686,4405,-1,4401,4687,4683,-1,4400,4687,4401,-1,4397,2056,4400,-1,2057,2056,4397,-1,4431,4396,4429,-1,4396,4431,4395,-1,4427,4393,4425,-1,4393,4427,4391,-1,4423,4390,4421,-1,4390,4423,4388,-1,4688,4419,4416,-1,4690,4419,4688,-1,4691,4399,4690,-1,4370,4399,4691,-1,4692,4414,3083,-1,4372,4414,4692,-1,4413,4376,4411,-1,4376,4413,4693,-1,4409,4380,4407,-1,4380,4409,4694,-1,4386,4404,4403,-1,4385,4404,4386,-1,4389,4384,4386,-1,4384,4389,4665,-1,4669,4694,4392,-1,4668,4694,4669,-1,4394,4663,4693,-1,4663,4394,4664,-1,4670,4692,4398,-1,4671,4692,4670,-1,4666,4691,4689,-1,4667,4691,4666,-1,4323,4696,4695,-1,4696,4323,2085,-1,2061,2082,2062,-1,2061,4320,2082,-1,1485,4317,4316,-1,4315,4317,1485,-1,4313,2090,1491,-1,4313,4311,2090,-1,1497,2063,1493,-1,1497,4708,2063,-1,4697,2088,4367,-1,2088,4697,3072,-1,3080,3076,2067,-1,3080,2071,3076,-1,4339,4698,4338,-1,4698,4339,4335,-1,4699,3071,4314,-1,4348,3071,4699,-1,5062,1466,1465,-1,1457,1466,5062,-1,4711,5061,5065,-1,5061,4711,4285,-1,2102,3066,4712,-1,3066,2102,1455,-1,4702,4281,4701,-1,4307,4281,4702,-1,3064,2114,3079,-1,3064,2115,2114,-1,4706,1522,3156,-1,1522,4706,4705,-1,1481,2074,4707,-1,1480,2074,1481,-1,1510,4699,1470,-1,1510,1514,4699,-1,4357,4350,4341,-1,4357,1527,4350,-1,5063,4361,4358,-1,4288,4361,5063,-1,1464,2077,4344,-1,2070,2077,1464,-1,3080,1500,3070,-1,2068,1500,3080,-1,4352,2091,1468,-1,2091,4352,4310,-1,2098,4353,1504,-1,5066,4353,2098,-1,2079,4359,2087,-1,2079,3075,4359,-1,1532,4319,3153,-1,4319,1532,2084,-1,4698,4290,1533,-1,4290,4698,5064,-1,4360,1534,3067,-1,4360,1535,1534,-1,3152,3597,2351,-1,3152,1538,3597,-1,4708,2080,2063,-1,2080,4708,3594,-1,3591,4367,3593,-1,3591,4697,4367,-1,4905,4366,3267,-1,4905,4695,4366,-1,3074,2062,2082,-1,4346,2062,3074,-1,4340,2085,3073,-1,4340,4696,2085,-1,4363,1501,3072,-1,1501,4363,1499,-1,4365,941,3268,-1,4365,4364,941,-1,3082,4346,4707,-1,3082,2062,4346,-1,4303,4702,4354,-1,4302,4702,4303,-1,4705,2094,1522,-1,2094,4705,4709,-1,3079,3164,3064,-1,3164,3079,4300,-1,2060,2107,1458,-1,2060,2059,2107,-1,4700,1475,2106,-1,4700,2096,1475,-1,4700,4710,2096,-1,2099,5066,2098,-1,2099,4286,5066,-1,3159,5065,1515,-1,3159,4711,5065,-1,3069,4712,4342,-1,3069,2102,4712,-1,4284,1534,1536,-1,4284,2103,1534,-1,4334,4283,5064,-1,4334,4282,4283,-1,4713,5063,4336,-1,4713,4715,5063,-1,2076,4716,2073,-1,2076,4714,4716,-1,4286,2113,4296,-1,4286,4287,2113,-1,4298,4285,4711,-1,4298,2112,4285,-1,2107,4287,2108,-1,1459,4287,2107,-1,2111,5062,2109,-1,2095,5062,2111,-1,5061,1473,4356,-1,1473,5061,1474,-1,4287,1461,2113,-1,1461,4287,1459,-1,2115,4292,2104,-1,2115,3065,4292,-1,4355,4715,4713,-1,4355,4701,4715,-1,4714,3156,4716,-1,4714,4706,3156,-1,4183,4264,4178,-1,4264,4183,5060,-1,4730,4261,3182,-1,4261,4730,5059,-1,3181,4259,4179,-1,4259,3181,5058,-1,4717,1449,1446,-1,4717,1392,1449,-1,5057,1397,4181,-1,4718,1397,5057,-1,4268,3062,3060,-1,4268,4718,3062,-1,3063,4251,5060,-1,4251,3063,2117,-1,4273,4724,5059,-1,4724,4273,4719,-1,4272,3046,5058,-1,3046,4272,4230,-1,4256,5057,4270,-1,4720,5057,4256,-1,4721,3062,4720,-1,3061,3062,4721,-1,2119,4211,2117,-1,4211,2119,4209,-1,4207,4265,4205,-1,4207,4719,4265,-1,1432,4204,3173,-1,1432,1410,4204,-1,3057,4229,3058,-1,3057,1448,4229,-1,4722,2120,1406,-1,4722,4193,2120,-1,2121,4199,4191,-1,4199,2121,2123,-1,4189,1407,3053,-1,1407,4189,3044,-1,2131,4212,2132,-1,2131,4210,4212,-1,4724,1413,4263,-1,4724,4723,1413,-1,2126,2130,2129,-1,2126,3052,2130,-1,4225,4244,5056,-1,4225,4237,4244,-1,1430,4241,4725,-1,1430,2132,4241,-1,1423,3050,4234,-1,1422,3050,1423,-1,1436,4202,2136,-1,1436,4235,4202,-1,4201,3050,2134,-1,4200,3050,4201,-1,3048,1412,4258,-1,3048,3049,1412,-1,4238,5055,5056,-1,4238,4220,5055,-1,5054,2128,4219,-1,2128,5054,2129,-1,3172,2141,2142,-1,1438,2141,3172,-1,5053,4186,1431,-1,5053,4727,4186,-1,4192,5055,2151,-1,5055,4192,4227,-1,5054,4190,4224,-1,5054,4188,4190,-1,4194,3175,4223,-1,4194,1399,3175,-1,4214,5053,4213,-1,4214,4727,5053,-1,4252,4245,4250,-1,4252,4243,4245,-1,4723,3176,1413,-1,4723,4249,3176,-1,4248,4229,4228,-1,4248,2135,4229,-1,4233,4721,4257,-1,4233,4232,4721,-1,1441,4732,1439,-1,1441,4726,4732,-1,4731,2146,4722,-1,4731,2147,2146,-1,1417,3055,2120,-1,1420,3055,1417,-1,3168,4727,4214,-1,3168,3171,4727,-1,4218,4247,4216,-1,4218,4246,4247,-1,2143,2149,2125,-1,2143,2124,2149,-1,4275,4728,4269,-1,4275,3586,4728,-1,4729,4717,4271,-1,4729,3589,4717,-1,4730,3582,4274,-1,4730,3581,3582,-1,1367,1371,1362,-1,1371,1367,2163,-1,5051,2960,4733,-1,5051,2959,2960,-1,4734,4912,3579,-1,5050,4912,4734,-1,2354,4736,5049,-1,2354,4735,4736,-1,3580,4738,5048,-1,3580,4737,4738,-1,3571,4740,4913,-1,4740,3571,4172,-1,4739,5052,4740,-1,5047,5052,4739,-1,5046,4733,4741,-1,5046,5051,4733,-1,5050,4742,5045,-1,5050,4734,4742,-1,4736,5044,5049,-1,5044,4736,4743,-1,4738,4746,5048,-1,4746,4738,4744,-1,4746,4749,4163,-1,4749,4746,4745,-1,1384,5047,4739,-1,1383,5047,1384,-1,4143,5046,4741,-1,4144,5046,4143,-1,2157,5045,4742,-1,4142,5045,2157,-1,4747,5044,4743,-1,5043,5044,4747,-1,4752,2154,5043,-1,2155,2154,4752,-1,4745,4748,4749,-1,4748,4745,3039,-1,4750,4158,4155,-1,5042,4158,4750,-1,2158,4154,4751,-1,2158,3042,4154,-1,4140,5043,4747,-1,4752,5043,4140,-1,4126,2155,4752,-1,2159,2155,4126,-1,3038,4748,3039,-1,4753,4748,3038,-1,4750,4123,5042,-1,4123,4750,4124,-1,4751,4122,2158,-1,4122,4751,4120,-1,4122,4759,4131,-1,4759,4122,4121,-1,2160,4141,4139,-1,4118,4141,2160,-1,3038,4754,4753,-1,4754,3038,4756,-1,4138,4757,4755,-1,4138,4137,4757,-1,4758,4134,4136,-1,4109,4134,4758,-1,4129,1370,2161,-1,1370,4129,4108,-1,2162,4127,4125,-1,1366,4127,2162,-1,4762,4756,4106,-1,4762,4754,4756,-1,4102,4755,4757,-1,4763,4755,4102,-1,1373,4109,4758,-1,1372,4109,1373,-1,4110,4099,4760,-1,4099,4110,4098,-1,4097,2162,4119,-1,2163,2162,4097,-1,4762,4764,4117,-1,4764,4762,4761,-1,3037,4112,4763,-1,3036,4112,3037,-1,3565,3026,4765,-1,3026,3565,5040,-1,4056,3563,4057,-1,4056,3271,3563,-1,4919,4068,2193,-1,4919,931,4068,-1,4062,4994,3569,-1,5041,4994,4062,-1,4993,4066,4077,-1,4993,3568,4066,-1,1339,1267,1337,-1,1268,1267,1339,-1,4785,4769,1305,-1,4769,4785,3997,-1,3031,5035,2171,-1,3031,1323,5035,-1,2173,5036,3196,-1,2173,3030,5036,-1,2212,4028,4025,-1,2211,4028,2212,-1,4064,3011,4771,-1,4064,4770,3011,-1,2234,4014,2174,-1,2234,4791,4014,-1,3012,4032,3013,-1,3012,4030,4032,-1,1299,4027,1296,-1,1299,5039,4027,-1,2206,1354,1283,-1,2206,4083,1354,-1,3200,4082,3007,-1,4082,3200,4069,-1,1270,4024,3020,-1,1269,4024,1270,-1,3989,4012,3987,-1,4012,3989,5037,-1,4775,3985,3983,-1,4076,3985,4775,-1,4790,3967,1278,-1,4790,3968,3967,-1,4004,4786,4022,-1,3006,4786,4004,-1,4775,2210,2208,-1,4775,4080,2210,-1,4778,2186,1255,-1,4778,3976,2186,-1,4795,5038,4794,-1,5033,5038,4795,-1,3972,1249,3211,-1,3972,1334,1249,-1,4779,3013,4032,-1,3013,4779,4780,-1,4035,1272,4781,-1,1272,4035,1273,-1,3196,2223,2190,-1,3196,5036,2223,-1,4063,2192,4061,-1,4063,3027,2192,-1,2173,1360,2172,-1,2173,3191,1360,-1,2230,4090,4089,-1,4003,4090,2230,-1,4772,5041,4771,-1,4772,4092,5041,-1,3026,5034,2195,-1,3026,5040,5034,-1,2198,3200,3007,-1,2227,3200,2198,-1,3014,3189,2216,-1,3190,3189,3014,-1,3202,4782,1274,-1,4094,4782,3202,-1,4052,3194,4051,-1,4052,1345,3194,-1,4052,1342,1345,-1,4783,1342,4052,-1,2196,3992,3990,-1,4058,3992,2196,-1,2235,4000,4002,-1,2235,4087,4000,-1,1326,4033,3028,-1,4033,1326,4036,-1,4768,1331,4789,-1,4768,3021,1331,-1,1280,4768,4789,-1,4768,1280,4767,-1,4043,4779,4042,-1,4043,4781,4779,-1,4084,4086,5039,-1,4084,4085,4086,-1,4040,4034,4036,-1,4040,4071,4034,-1,4787,5038,4074,-1,3978,5038,4787,-1,3971,4773,4788,-1,3971,4072,4773,-1,4796,4059,4060,-1,4796,3982,4059,-1,1344,2167,2206,-1,1344,3029,2167,-1,1330,4789,1331,-1,1330,4790,4789,-1,2209,3015,2207,-1,3016,3015,2209,-1,5032,1329,5037,-1,5032,1330,1329,-1,2216,2212,2214,-1,2213,2212,2216,-1,4780,3014,3013,-1,3014,4780,4782,-1,3201,2217,1307,-1,3201,4088,2217,-1,4770,2219,3011,-1,2219,4770,4001,-1,2222,5036,3206,-1,2222,2223,5036,-1,2226,2225,2227,-1,3010,2225,2226,-1,2169,5035,1327,-1,4045,5035,2169,-1,1325,3009,4070,-1,1324,3009,1325,-1,1348,4772,1346,-1,4772,1348,1312,-1,1336,2200,1250,-1,1336,4776,2200,-1,5034,4778,2195,-1,5034,4777,4778,-1,2219,1304,2218,-1,2219,4784,1304,-1,4769,1284,2231,-1,1284,4769,1289,-1,2233,4002,1302,-1,2235,4002,2233,-1,3991,4047,3990,-1,3994,4047,3991,-1,2233,4791,2234,-1,2232,4791,2233,-1,1245,3998,4792,-1,1245,4048,3998,-1,4793,4081,3980,-1,4793,4079,4081,-1,3984,3975,4021,-1,4794,3975,3984,-1,4015,4793,4796,-1,4793,4015,3988,-1,4787,2187,2186,-1,4787,4018,2187,-1,4078,4073,5033,-1,2185,4073,4078,-1,4774,5037,3989,-1,5037,4774,5032,-1,2270,1186,2252,-1,2270,1187,1186,-1,3950,4798,4797,-1,3950,3558,4798,-1,923,3947,924,-1,3947,923,4799,-1,4800,2375,2377,-1,3898,2375,4800,-1,3561,4801,3896,-1,3561,3559,4801,-1,3213,4922,4802,-1,3919,4922,3213,-1,1220,928,1118,-1,1220,929,928,-1,1164,1140,1148,-1,1140,1164,2990,-1,4797,3944,4806,-1,4797,3964,3944,-1,4807,3962,3942,-1,4807,4799,3962,-1,4809,4807,3939,-1,4809,3948,4807,-1,2277,3801,4810,-1,2277,1141,3801,-1,3951,1241,4812,-1,3951,4806,1241,-1,4812,3931,3941,-1,3931,4812,4811,-1,4809,4815,3859,-1,4815,4809,4808,-1,4817,3943,5025,-1,3934,3943,4817,-1,4813,3212,3925,-1,4813,4811,3212,-1,3937,4814,4808,-1,4814,3937,3920,-1,1145,3797,3803,-1,2236,3797,1145,-1,3854,1182,3935,-1,1182,3854,1183,-1,4813,3840,3933,-1,3840,4813,4818,-1,4816,4819,4840,-1,4816,4814,4819,-1,3960,4820,1119,-1,4820,3960,3915,-1,4820,1207,1206,-1,1207,4820,3909,-1,3911,3917,1239,-1,4821,3917,3911,-1,3904,3914,4821,-1,4824,3914,3904,-1,5013,4823,4822,-1,5013,3799,4823,-1,3808,5024,3806,-1,5024,3808,4828,-1,4824,4825,3910,-1,4825,4824,3902,-1,4825,3214,3907,-1,3214,4825,4826,-1,4827,3848,3849,-1,4827,2271,3848,-1,4826,3837,1181,-1,4826,3903,3837,-1,4830,4800,2997,-1,3892,4800,4830,-1,3961,4829,4801,-1,4829,3961,5031,-1,3895,4831,3888,-1,3895,4829,4831,-1,1213,4830,1211,-1,3886,4830,1213,-1,3899,5030,5031,-1,5030,3899,3889,-1,4833,4831,5030,-1,3880,4831,4833,-1,5026,4851,5019,-1,1212,4851,5026,-1,2243,3884,4832,-1,2242,3884,2243,-1,5029,4833,3891,-1,3875,4833,5029,-1,4853,3001,4844,-1,4853,3004,3001,-1,3827,2248,2996,-1,3827,2264,2248,-1,4834,5029,3883,-1,4835,5029,4834,-1,3870,3873,4835,-1,5028,3873,3870,-1,1226,4834,2244,-1,3871,4834,1226,-1,3865,1234,5028,-1,4836,1234,3865,-1,2246,2991,3000,-1,3860,2991,2246,-1,5027,3869,3216,-1,3862,3869,5027,-1,4837,4836,3864,-1,4837,3868,4836,-1,1215,4837,1175,-1,1215,4838,4837,-1,3222,5027,3867,-1,4850,5027,3222,-1,1211,2997,1218,-1,2997,1211,4830,-1,4804,4841,4840,-1,4841,4804,4803,-1,1235,3957,1131,-1,2261,3957,1235,-1,1222,2245,2246,-1,2245,1222,1189,-1,2243,5026,2996,-1,4832,5026,2243,-1,3929,4815,4816,-1,3930,4815,3929,-1,5025,3796,4817,-1,5025,5012,3796,-1,2259,3824,3887,-1,3824,2259,2258,-1,2256,4843,2257,-1,2256,4842,4843,-1,3912,4828,1237,-1,3912,5024,4828,-1,2993,3878,5016,-1,2993,2260,3878,-1,3829,3894,4844,-1,5020,3894,3829,-1,3816,1169,5021,-1,3816,1223,1169,-1,4819,5023,4846,-1,4819,3921,5023,-1,4847,3924,5022,-1,4847,4818,3924,-1,2987,3900,2279,-1,3954,3900,2987,-1,1178,1192,2247,-1,1178,1190,1192,-1,3843,2266,2265,-1,5021,2266,3843,-1,4852,2992,5020,-1,4852,2263,2992,-1,5019,4852,3830,-1,4851,4852,5019,-1,2266,3000,2991,-1,2266,1168,3000,-1,5018,3002,3004,-1,3872,3002,5018,-1,3218,5017,1202,-1,3218,3822,5017,-1,3825,3004,4853,-1,3825,5018,3004,-1,1166,1224,1167,-1,1224,1166,2999,-1,2993,3872,5018,-1,5016,3872,2993,-1,3812,3936,4854,-1,3936,3812,3927,-1,3815,3928,4854,-1,3928,3815,3946,-1,3853,5014,4843,-1,3853,3807,5014,-1,2269,2270,5017,-1,2269,1151,2270,-1,5014,2237,3809,-1,2237,5014,3913,-1,3810,2271,4827,-1,3810,2272,2271,-1,4842,4822,3852,-1,4842,5013,4822,-1,1197,4823,2995,-1,1197,3901,4823,-1,2278,4810,5012,-1,2278,2277,4810,-1,3956,2272,1196,-1,2272,3956,2989,-1,2380,3785,2947,-1,3785,2380,4855,-1,3773,2283,2292,-1,3773,2378,2283,-1,4992,3692,3544,-1,3692,4992,5010,-1,3231,3549,3551,-1,1113,3549,3231,-1,5011,4856,3553,-1,4857,4856,5011,-1,3547,3232,2383,-1,3232,3547,1110,-1,5001,4886,4885,-1,5001,3640,4886,-1,3648,4892,3647,-1,3644,4892,3648,-1,3793,4858,3766,-1,3793,3792,4858,-1,5011,4859,4857,-1,4859,5011,3764,-1,2986,4860,1115,-1,4860,2986,3759,-1,3795,4863,4855,-1,4863,3795,3769,-1,5010,4862,3692,-1,4862,5010,3756,-1,3666,3640,5001,-1,3666,3639,3640,-1,3235,4863,3750,-1,3235,3783,4863,-1,2329,4858,3681,-1,4865,4858,2329,-1,1112,3236,3780,-1,3236,1112,3747,-1,4859,3745,3776,-1,3745,4859,5009,-1,4860,3752,1111,-1,3752,4860,5008,-1,3684,3669,4880,-1,3667,3669,3684,-1,1108,1096,5007,-1,1108,2293,1096,-1,4862,4867,4861,-1,4867,4862,3742,-1,3757,5005,3770,-1,5005,3757,3734,-1,3653,3642,4864,-1,4891,3642,3653,-1,2295,3765,4865,-1,2983,3765,2295,-1,3763,3729,5009,-1,3729,3763,4866,-1,3736,5008,3761,-1,5006,5008,3736,-1,3682,3659,3685,-1,3682,4998,3659,-1,3755,4870,3728,-1,3755,5007,4870,-1,5006,4868,3754,-1,4868,5006,3719,-1,5005,4869,3751,-1,4869,5005,3718,-1,2296,995,994,-1,2296,2295,995,-1,1098,3721,4866,-1,3721,1098,2297,-1,4870,2298,2299,-1,4870,1095,2298,-1,3683,2982,4883,-1,2982,3683,2302,-1,2298,1061,2300,-1,2298,1082,1061,-1,4889,4871,3661,-1,4871,4889,4879,-1,1072,3730,4873,-1,1072,3737,3730,-1,3241,3735,4868,-1,3710,3735,3241,-1,2304,4869,5004,-1,2304,1094,4869,-1,1066,2296,2306,-1,1066,2294,2296,-1,1088,3712,2297,-1,3712,1088,1073,-1,3722,1048,4873,-1,1048,3722,1051,-1,5003,3717,3703,-1,5003,5004,3717,-1,5002,3240,3701,-1,5002,4872,3240,-1,2303,975,2301,-1,975,2303,3688,-1,2309,3706,1057,-1,4890,3706,2309,-1,4997,3250,3687,-1,4997,3249,3250,-1,1059,2307,2308,-1,1059,1060,2307,-1,1036,1070,1071,-1,1014,1070,1036,-1,1070,1014,3257,-1,4874,5003,3679,-1,4874,3709,5003,-1,3264,1019,2324,-1,3264,2966,1019,-1,2980,2316,2310,-1,2316,2980,4875,-1,1053,983,1049,-1,983,1053,2317,-1,4878,1035,3693,-1,1029,1035,4878,-1,1029,4882,1035,-1,3690,3252,3689,-1,1029,3690,4882,-1,1029,3252,3690,-1,5000,4861,4867,-1,5000,3663,4861,-1,1029,3253,1030,-1,4878,3253,1029,-1,2303,4871,4879,-1,2303,2302,4871,-1,4876,3771,4880,-1,3771,4876,3254,-1,2346,2972,962,-1,2346,3708,2972,-1,1019,2973,2324,-1,2973,1019,1018,-1,1044,3786,3704,-1,3786,1044,2331,-1,4874,3788,3700,-1,3788,4874,3787,-1,3696,1038,2319,-1,3695,1038,3696,-1,2315,3664,2318,-1,3664,2315,3697,-1,1103,3748,3782,-1,3234,3748,1103,-1,2327,1013,1012,-1,1013,2327,1067,-1,2967,4872,5002,-1,2967,4881,4872,-1,2984,3265,4893,-1,2984,2285,3265,-1,4893,2335,2984,-1,2336,2335,4893,-1,5001,3669,3666,-1,3669,5001,4877,-1,4883,949,3266,-1,2982,949,4883,-1,2323,1011,2324,-1,2323,1012,1011,-1,4888,1105,3645,-1,4888,1092,1105,-1,2314,1015,1014,-1,2314,3258,1015,-1,999,2341,1002,-1,999,2969,2341,-1,4999,1005,3660,-1,1005,4999,5000,-1,4998,3662,4999,-1,3772,3662,4998,-1,2341,4889,2342,-1,4889,2341,4997,-1,970,2344,968,-1,3781,2344,970,-1,2309,3691,1031,-1,2308,3691,2309,-1,2967,3715,4881,-1,2967,2966,3715,-1,4891,3645,3642,-1,3645,4891,4888,-1,4892,4887,4884,-1,4887,4892,3665,-1,3641,2336,4893,-1,3641,3741,2336,-1,4886,4996,4884,-1,4886,953,4996,-1,3741,2334,2336,-1,3741,3740,2334,-1,951,3725,3740,-1,950,3725,951,-1,973,3633,3632,-1,1022,3633,973,-1,2712,4597,4634,-1,2712,2864,4597,-1,2965,260,262,-1,4636,260,2965,-1,4981,4639,4894,-1,4639,4981,4594,-1,265,4599,263,-1,4599,265,4593,-1,4980,4895,3347,-1,4895,4980,4672,-1,4896,4966,4673,-1,4896,3443,4966,-1,4897,250,4674,-1,4897,4898,250,-1,4900,4675,4899,-1,4900,3440,4675,-1,4995,4902,3439,-1,4501,4902,4995,-1,943,2719,238,-1,943,942,2719,-1,2714,2962,3596,-1,2714,3432,2962,-1,2963,3436,3595,-1,2963,2349,3436,-1,4904,3600,3610,-1,3600,4904,4903,-1,4903,3163,1489,-1,4903,3604,3163,-1,2352,4312,2353,-1,2352,3608,4312,-1,2081,3607,4330,-1,2081,3605,3607,-1,4327,947,2348,-1,4329,947,4327,-1,4324,3430,4322,-1,4324,3428,3430,-1,3043,4907,3421,-1,1393,4907,3043,-1,4729,4908,3348,-1,4182,4908,4729,-1,1396,4909,3420,-1,4728,4909,1396,-1,3424,4177,4910,-1,4177,3424,4185,-1,2725,1387,3423,-1,1388,1387,2725,-1,2955,2958,2363,-1,2955,2954,2958,-1,2354,4967,4735,-1,2354,217,4967,-1,213,4174,2729,-1,4174,213,4175,-1,2961,4915,220,-1,2359,4915,2961,-1,4913,938,3578,-1,938,4913,939,-1,3269,2361,940,-1,2362,2361,3269,-1,4977,4914,205,-1,4977,3475,4914,-1,2363,2355,4173,-1,2363,2356,2355,-1,2956,4737,3580,-1,2956,2955,4737,-1,4978,2954,4917,-1,4978,2958,2954,-1,3034,2365,1361,-1,2365,3034,4918,-1,2952,4919,2366,-1,4920,4919,2952,-1,4994,3354,4968,-1,4994,4093,3354,-1,4921,4993,4091,-1,3412,4993,4921,-1,2371,3416,4765,-1,3416,2371,2370,-1,4922,4923,3355,-1,4922,3959,4923,-1,3965,926,925,-1,3403,926,3965,-1,2375,2374,2949,-1,2372,2374,2375,-1,3963,192,3401,-1,3963,923,192,-1,2998,2376,190,-1,2376,2998,2377,-1,2950,3409,2373,-1,3409,2950,3559,-1,3392,2286,2854,-1,2286,3392,3789,-1,4992,917,3272,-1,4992,180,917,-1,2854,1117,3356,-1,2854,2286,1117,-1,2384,183,182,-1,2384,3545,183,-1,3794,184,3398,-1,3794,1010,184,-1,3390,3555,3388,-1,3390,3790,3555,-1,3381,347,4964,-1,4957,347,3381,-1,431,4970,164,-1,430,4970,431,-1,2823,276,2851,-1,2823,277,276,-1,3385,274,2702,-1,3342,274,3385,-1,907,910,905,-1,907,909,910,-1,904,908,275,-1,908,904,909,-1,488,492,490,-1,492,488,3479,-1,4927,4950,4926,-1,4950,4927,500,-1,2893,4985,4951,-1,4985,2893,4925,-1,909,4986,2583,-1,909,2946,4986,-1,2944,4930,2894,-1,2943,4930,2944,-1,3538,895,4991,-1,3538,4930,895,-1,3535,2397,4991,-1,3535,2909,2397,-1,2403,2909,2911,-1,2402,2909,2403,-1,2406,4931,3493,-1,2406,4943,4931,-1,462,891,4943,-1,462,461,891,-1,2417,582,581,-1,2557,582,2417,-1,3312,158,521,-1,3312,3470,158,-1,384,386,385,-1,384,2832,386,-1,3297,4945,4935,-1,675,4945,3297,-1,3369,2818,643,-1,2811,2818,3369,-1,2553,815,2422,-1,2553,2546,815,-1,3302,2485,3504,-1,3302,2926,2485,-1,2424,868,870,-1,2424,3527,868,-1,544,2426,545,-1,544,2427,2426,-1,2425,2428,867,-1,2425,869,2428,-1,293,2766,2767,-1,2766,293,4983,-1,3521,709,2469,-1,709,3521,718,-1,348,2467,328,-1,348,2466,2467,-1,767,3513,762,-1,3514,3513,767,-1,2482,2461,2460,-1,782,2461,2482,-1,92,847,851,-1,95,847,92,-1,98,851,3290,-1,98,92,851,-1,4974,3365,3375,-1,4974,116,3365,-1,2901,3309,4936,-1,3309,2901,554,-1,58,2452,21,-1,13,2452,58,-1,2821,74,2800,-1,2821,40,74,-1,2456,68,38,-1,2456,44,68,-1,673,2484,694,-1,3297,2484,673,-1,862,2460,805,-1,862,864,2460,-1,2465,2932,2826,-1,865,2932,2465,-1,2754,856,84,-1,2467,856,2754,-1,2479,702,701,-1,2479,2468,702,-1,718,710,709,-1,710,718,719,-1,2481,2477,2476,-1,2477,2481,2480,-1,3285,2482,2432,-1,780,2482,3285,-1,2473,3517,2930,-1,3517,2473,2511,-1,3519,2471,3518,-1,3519,2458,2471,-1,783,2478,784,-1,2476,2478,783,-1,2494,4990,760,-1,2494,2493,4990,-1,4990,852,3307,-1,852,4990,853,-1,2493,738,748,-1,2493,2925,738,-1,2497,3514,2928,-1,2497,2498,3514,-1,2500,773,734,-1,773,2500,774,-1,2420,2925,2495,-1,2420,757,2925,-1,3292,2880,2626,-1,743,2880,3292,-1,712,2629,711,-1,712,407,2629,-1,4937,2506,3294,-1,2506,4937,2878,-1,398,2507,2628,-1,398,2923,2507,-1,2480,700,778,-1,700,2480,701,-1,2514,869,2427,-1,2514,2428,869,-1,2517,875,720,-1,4989,875,2517,-1,3509,4938,4989,-1,4939,4938,3509,-1,4938,2921,2518,-1,2921,4938,4939,-1,7,692,2921,-1,6,692,7,-1,2918,2919,2521,-1,2918,2524,2919,-1,2920,2526,690,-1,2920,2917,2526,-1,2524,695,2919,-1,2524,2515,695,-1,676,2521,677,-1,676,4987,2521,-1,2918,3492,2522,-1,4944,3492,2918,-1,2917,3510,2526,-1,2917,688,3510,-1,3501,2530,591,-1,3501,3530,2530,-1,2916,656,4940,-1,656,2916,814,-1,4941,3505,4940,-1,4941,2540,3505,-1,3306,3502,2554,-1,3306,3498,3502,-1,2910,2536,2545,-1,2910,2401,2536,-1,4941,652,2540,-1,652,4941,3300,-1,642,639,638,-1,642,649,639,-1,632,634,630,-1,890,634,632,-1,3533,2911,3536,-1,3532,2911,3533,-1,2536,3299,655,-1,2535,3299,2536,-1,3500,571,2905,-1,4988,571,3500,-1,576,618,608,-1,576,2549,618,-1,2906,2552,2551,-1,2907,2552,2906,-1,2547,2914,2562,-1,2547,598,2914,-1,665,2558,593,-1,2905,2558,665,-1,2557,590,2556,-1,590,2557,2417,-1,582,3305,583,-1,582,2561,3305,-1,1661,611,610,-1,611,1661,3145,-1,2014,602,2011,-1,650,602,2014,-1,2564,1670,4988,-1,2564,2563,1670,-1,2561,3095,3305,-1,2561,3146,3095,-1,4942,2565,3308,-1,4942,2566,2565,-1,4936,557,2903,-1,3309,557,4936,-1,850,3308,562,-1,850,4942,3308,-1,565,2899,2900,-1,564,2899,565,-1,3286,552,551,-1,3286,3495,552,-1,556,2815,558,-1,556,1,2815,-1,2568,2757,2756,-1,2757,2568,669,-1,4932,2400,2399,-1,2400,4932,3534,-1,4945,4987,4934,-1,4944,4987,4945,-1,543,2569,541,-1,2569,543,670,-1,496,2889,497,-1,496,899,2889,-1,533,3448,534,-1,533,4947,3448,-1,4949,2942,548,-1,2942,4949,4948,-1,528,2941,2897,-1,2405,2941,528,-1,2571,4948,4949,-1,2571,532,4948,-1,2444,2604,2605,-1,2444,105,2604,-1,518,2582,905,-1,518,2392,2582,-1,2392,520,2576,-1,2392,518,520,-1,525,516,911,-1,516,525,524,-1,2580,507,509,-1,2580,2895,507,-1,2581,2580,509,-1,2580,2581,2415,-1,512,2411,2578,-1,512,2412,2411,-1,549,510,882,-1,549,2895,510,-1,4929,4986,4950,-1,4986,4929,3540,-1,4986,4926,4950,-1,4926,4986,2946,-1,2575,898,2570,-1,2575,2586,898,-1,900,500,4927,-1,900,501,500,-1,4951,491,2893,-1,491,4951,493,-1,2891,2823,2778,-1,2891,277,2823,-1,903,915,2892,-1,2389,915,903,-1,3446,474,3480,-1,3446,484,474,-1,485,3345,2890,-1,485,3481,3345,-1,2594,538,526,-1,538,2594,2593,-1,487,2592,4982,-1,2595,2592,487,-1,3447,4985,4925,-1,4984,4985,3447,-1,4953,4985,4984,-1,4953,4928,4985,-1,884,464,826,-1,884,465,464,-1,540,454,456,-1,454,540,460,-1,468,2888,2446,-1,468,2604,2888,-1,326,2618,2885,-1,326,2619,2618,-1,4959,2723,322,-1,4959,4979,2723,-1,2884,3458,2882,-1,2884,3425,3458,-1,3476,4977,3434,-1,3475,4977,3476,-1,434,279,435,-1,280,279,434,-1,2926,605,747,-1,605,2926,3302,-1,728,2419,2628,-1,728,2922,2419,-1,2878,2503,2629,-1,2503,2878,4937,-1,399,404,2877,-1,401,404,399,-1,3349,2606,2887,-1,3349,2733,2606,-1,328,197,348,-1,328,2631,197,-1,4975,372,371,-1,4975,379,372,-1,2640,368,367,-1,368,2640,3340,-1,3456,3329,3542,-1,3456,374,3329,-1,3328,382,385,-1,382,3328,3337,-1,2758,669,668,-1,2758,2757,669,-1,2840,3336,305,-1,2840,2842,3336,-1,360,3389,358,-1,360,3469,3389,-1,291,4976,4983,-1,291,4956,4976,-1,2731,391,327,-1,391,2731,2730,-1,3350,2887,3417,-1,3349,2887,3350,-1,2662,2727,2726,-1,3464,2727,2662,-1,282,2663,283,-1,2663,282,3431,-1,3422,2697,230,-1,3422,3461,2697,-1,322,3357,4959,-1,3357,322,3387,-1,338,2710,337,-1,2710,338,2664,-1,3460,2609,2611,-1,2609,3460,3459,-1,2850,321,2665,-1,321,2850,2852,-1,444,152,443,-1,444,4961,152,-1,3335,128,233,-1,128,3335,124,-1,331,2350,332,-1,331,4962,2350,-1,211,2672,3325,-1,211,2673,2672,-1,321,3387,322,-1,321,2852,3387,-1,2677,252,148,-1,2677,2676,252,-1,2682,2680,264,-1,2680,2682,2681,-1,3457,2685,2684,-1,3457,3429,2685,-1,937,2860,3270,-1,937,2688,2860,-1,330,2688,937,-1,195,2876,355,-1,195,194,2876,-1,2739,390,389,-1,2691,390,2739,-1,2438,87,2439,-1,2438,2760,87,-1,2693,2622,2716,-1,2621,2622,2693,-1,2662,2846,3464,-1,2662,166,2846,-1,4971,428,2661,-1,4971,3386,428,-1,165,2701,4963,-1,2701,165,2700,-1,2656,2845,343,-1,2656,2843,2845,-1,3359,3468,3382,-1,3468,3359,2637,-1,4984,3490,4953,-1,4984,4947,3490,-1,3446,271,451,-1,271,3446,3480,-1,2964,3629,2965,-1,3629,2964,2713,-1,2707,3322,4894,-1,2707,2865,3322,-1,336,2864,334,-1,2864,336,2711,-1,3626,3460,2611,-1,4981,3460,3626,-1,2612,4980,2676,-1,4980,2612,4901,-1,4954,3616,2666,-1,3616,4954,4898,-1,4900,2862,2861,-1,3612,2862,4900,-1,446,3439,4902,-1,446,445,3439,-1,2683,945,245,-1,946,945,2683,-1,4904,3473,3476,-1,4904,3610,3473,-1,432,3609,3324,-1,2719,3609,432,-1,3453,2715,3606,-1,2715,3453,234,-1,312,3430,313,-1,3592,3430,312,-1,947,3591,242,-1,4329,3591,947,-1,281,2859,2849,-1,281,283,2859,-1,4961,3584,2883,-1,4961,4909,3584,-1,2669,2720,2668,-1,2669,4910,2720,-1,434,4911,2858,-1,434,3323,4911,-1,3462,3588,4979,-1,3462,4907,3588,-1,2613,4908,2857,-1,2613,2885,4908,-1,221,4915,2660,-1,221,220,4915,-1,3576,4914,3577,-1,4914,3576,3575,-1,4967,2730,2729,-1,3465,2730,4967,-1,4978,3351,3350,-1,3351,4978,4917,-1,2370,2638,450,-1,2638,2370,2369,-1,2855,2874,4918,-1,2734,2874,2855,-1,4920,2606,932,-1,2607,2606,4920,-1,202,2631,203,-1,2631,202,4968,-1,4921,352,350,-1,352,4921,3564,-1,2949,308,309,-1,308,2949,2374,-1,3562,4956,3560,-1,4976,4956,3562,-1,3341,3355,4923,-1,3341,301,3355,-1,2738,2691,2739,-1,2691,2738,927,-1,3467,3556,4958,-1,3467,4969,3556,-1,388,3356,3546,-1,388,3327,3356,-1,2381,2743,2742,-1,2633,2743,2381,-1,185,4975,186,-1,4975,185,3548,-1,180,3329,178,-1,3329,180,3543,-1,2646,3550,2647,-1,2646,4924,3550,-1,4955,3393,364,-1,4955,3554,3393,-1,922,2320,996,-1,922,3541,2320,-1,4965,2747,2746,-1,4965,3480,2747,-1,2749,2698,3482,-1,2749,469,2698,-1,4970,2847,2704,-1,4970,2750,2847,-1,4971,165,4963,-1,4971,2846,165,-1,2703,3452,2387,-1,3452,2703,2867,-1,2753,2844,2843,-1,2753,2752,2844,-1,4964,913,912,-1,4964,3450,913,-1,383,3470,2756,-1,383,2648,3470,-1,3289,3459,4960,-1,3289,2609,3459,-1,89,2439,87,-1,89,2824,2439,-1,292,2465,135,-1,2465,292,807,-1,2831,3471,377,-1,3471,2831,3494,-1,3379,134,2933,-1,3379,2830,134,-1,2882,4972,150,-1,4972,2882,3458,-1,2828,3524,2759,-1,3524,2828,4962,-1,2670,3525,2872,-1,141,3525,2670,-1,2774,2672,2754,-1,2774,3325,2672,-1,2826,2464,2465,-1,2826,2763,2464,-1,2768,834,105,-1,835,834,2768,-1,96,116,4974,-1,96,2771,116,-1,3288,3375,843,-1,4974,3375,3288,-1,2436,88,2437,-1,89,88,2436,-1,2773,2935,845,-1,2773,90,2935,-1,2824,2772,2439,-1,2824,2773,2772,-1,2699,2851,2777,-1,2823,2851,2699,-1,857,2826,858,-1,857,2827,2826,-1,65,60,2783,-1,65,64,60,-1,2822,32,82,-1,32,2822,33,-1,3531,2785,3373,-1,2939,2785,3531,-1,2791,2809,2790,-1,2809,2791,15,-1,886,4973,4933,-1,72,4973,886,-1,2822,74,76,-1,2822,2801,74,-1,2801,2822,82,-1,838,2452,3523,-1,838,2453,2452,-1,837,2453,838,-1,837,825,2453,-1,43,3522,871,-1,43,45,3522,-1,2821,2456,2803,-1,2821,3372,2456,-1,2800,2455,819,-1,2455,2800,2801,-1,2805,2802,2797,-1,2802,2805,2803,-1,3373,3366,3531,-1,3371,3366,3373,-1,2803,2804,2821,-1,2804,2803,2805,-1,4973,2793,2807,-1,2793,4973,2940,-1,4933,2807,2806,-1,4933,4973,2807,-1,2809,29,31,-1,2809,3370,29,-1,3368,24,2819,-1,646,24,3368,-1],creaseAngle=1.571,
            coord=Coordinate(DEF='maxl_Coord',point=[(.96401,56.70007,2.1581),(.91379,56.53299,2.66067),(.89899,56.53398,2.66647),(1.00199,56.67259,2.09827),(.98389,56.67758,2.07178),(.91266,56.49258,2.64473),(.92863,56.71143,2.10454),(.93791,56.71226,2.14298),(.88539,56.52727,2.66994),(.45072,56.50532,2.84905),(.48123,56.39512,2.83199),(.45658,56.39599,2.83277),(.36308,56.53971,3.18288),(.28006,56.66658,3.37825),(.34051,56.69413,3.19336),(.23421,57.248,2.86332),(.26063,57.2195,2.81981),(.24306,57.21869,2.84841),(.34747,56.82572,2.82103),(.35049,56.76897,2.82121),(.35369,56.75528,2.89146),(.23843,56.93078,3.21375),(.15485,56.9582,3.32722),(.13108,56.90887,3.35665),(.39718,56.43716,3.01456),(.4173,56.40623,3.01332),(.37415,56.51611,3.18934),(.23471,57.18434,2.95697),(.1735,57.25068,3.04546),(.23053,57.23684,2.94671),(.17142,57.30461,3.00698),(.22767,57.27765,2.93619),(.14697,57.06551,3.25777),(.14308,57.0759,3.25433),(.19006,57.06146,3.15961),(.21491,57.39689,2.95116),(.18931,57.40754,2.9816),(.18921,57.39792,2.98306),(.24321,57.37644,2.91237),(.2194,57.37531,2.95633),(.19318,57.20027,3.07898),(.15589,57.23433,3.13176),(.15346,57.21516,3.15836),(.3269,57.16537,2.9073),(.30517,57.2306,2.89626),(.32781,57.16577,2.91181),(.32066,57.16023,2.86945),(.29553,57.22077,2.83435),(.3056,57.22548,2.8539),(.28547,57.21606,2.81476),(.26692,57.32361,2.81662),(.29384,57.3273,2.78704),(.38893,57.00631,2.91941),(.36113,56.99843,2.89299),(.33572,57.09498,2.88467),(.34797,56.54001,3.27954),(.34201,56.53844,3.27942),(.12548,56.89725,3.36353),(.1492,56.86836,3.35767),(.18997,57.37839,2.98792),(.1454,57.39907,2.99833),(.13351,57.34657,2.99777),(.13293,57.3798,2.9801),(.16779,57.37949,2.94478),(.1365,57.39462,2.96285),(.13915,57.4061,2.95894),(.18453,57.48942,2.98433),(.2166,57.49198,2.97068),(.28532,57.33905,2.82924),(.23924,57.45193,2.89152),(.12227,56.90517,3.35434),(.13972,56.95678,3.31079),(.21389,56.97299,3.18281),(.11891,56.89524,3.36267),(.18346,57.12703,3.12945),(.14887,57.18112,3.19661),(.14769,57.12289,3.24807),(.15262,57.35108,3.01992),(.14098,57.33055,3.00894),(.15354,57.33507,3.02936),(.14347,56.97732,3.29742),(.1589,56.97974,3.31753),(.15947,57.06772,3.28645),(.14192,57.38409,3.01245),(.96968,55.6626,2.47238),(.92463,55.70394,2.57904),(.91538,55.5133,2.56156),(.79925,55.56454,2.8942),(.80605,55.55695,2.8738),(.76049,55.78611,2.84884),(.71067,55.89433,2.8897),(.73576,55.90019,2.86352),(.72611,55.99482,2.8507),(.77948,55.87351,2.77211),(.80078,55.84046,2.69456),(.78242,55.98076,2.74847),(.59735,55.89463,3.00409),(.62962,55.87369,2.95746),(.62825,55.98733,2.93373),(.46172,55.77746,3.08724),(.40832,55.75814,3.06934),(.42628,55.58348,3.14948),(.9244,55.8094,2.60648),(.81634,55.72934,2.70854),(.13196,55.61116,3.2783),(.12012,55.73803,3.1725),(.08162,55.67725,3.22585),(.22222,55.48973,3.27637),(.17938,55.50255,3.31191),(.18077,55.38301,3.34238),(.31114,55.58551,3.18433),(.31122,55.74638,3.09678),(.26734,55.67354,3.13325),(.22233,55.73813,3.13413),(.55212,55.62858,3.15625),(.61179,55.64227,3.13682),(.57088,55.80389,3.08616),(.32969,55.48351,3.23051),(.36259,55.48595,3.21813),(.34593,55.59005,3.17845),(.74006,55.59809,1.35824),(.73086,55.54108,1.40779),(.68266,55.57636,1.56871),(.77607,55.48493,2.93179),(.74902,55.38264,2.92277),(.76985,55.38432,2.91195),(.72565,55.48413,2.97218),(.70491,55.38219,2.96791),(.729,55.38161,2.93143),(.6949,55.48627,3.01821),(.6798,55.39115,3.05848),(.69196,55.38641,3.00494),(1.09518,55.63745,1.61804),(1.10572,55.71895,1.68761),(1.09841,55.63199,1.68482),(1.04885,55.61069,2.06457),(1.04538,55.60365,2.11223),(1.03931,55.49934,2.04223),(1.10689,55.36491,1.7903),(1.10872,55.53222,1.74773),(1.09187,55.53883,1.82428),(.87703,55.45168,2.67208),(.88446,55.45675,2.65448),(.8805,55.52152,2.66755),(.51842,55.50247,3.1779),(.44781,55.48866,3.1772),(.46947,55.38843,3.1908),(.38188,55.48876,3.20954),(.40534,55.38059,3.21883),(.43102,55.38724,3.19632),(.62893,55.52417,3.13839),(.57627,55.51306,3.16379),(.59669,55.39588,3.15979),(.23439,55.37931,3.31375),(.28801,55.37561,3.28509),(.04731,55.48313,3.32726),(.00241,55.45589,3.31794),(.00705,55.35137,3.33363),(.76927,55.53557,1.3566),(.79438,55.46563,1.3804),(.77965,55.4621,1.39254),(.75133,55.44816,1.45171),(.7616,55.53246,1.37281),(.7661,55.45455,1.41046),(.54771,55.38695,2.59394),(.55896,55.44773,2.57779),(.56148,55.38317,2.57272),(.4004,55.36372,2.83869),(.37725,55.42566,2.82551),(.41367,55.36276,2.82115),(.10582,55.32618,3.00577),(.1066,55.36614,2.9965),(.11682,55.32524,3.00572),(.73344,55.43893,1.52036),(.76496,55.37466,1.47001),(.7911,55.31842,1.62234),(.79799,55.31358,1.6299),(.77764,55.31994,1.65058),(1.04737,55.36736,1.50681),(1.08211,55.37206,1.5262),(1.04598,55.36968,1.50961),(1.0535,55.32816,1.71454),(1.05321,55.33622,1.7115),(1.07927,55.34504,1.70158),(1.12106,55.38689,1.60675),(1.12077,55.38684,1.60582),(1.12432,55.38652,1.60644),(.76568,55.2733,1.95587),(.76271,55.26893,1.95986),(.73518,55.26949,1.9322),(.80588,55.28032,1.97795),(.72608,55.27143,1.89878),(.7288,55.2719,1.89811),(.73737,55.27048,1.93002),(.80579,55.27406,1.98284),(.8041,55.27405,1.98214),(.98428,55.33487,2.24408),(.97455,55.33555,2.31723),(.97999,55.33732,2.24394),(.75747,55.278,2.0463),(.75711,55.28444,2.05232),(.72278,55.28022,2.05438),(.91971,55.30498,2.3671),(.91975,55.30079,2.37223),(.91746,55.29877,2.3718),(.78523,55.28319,2.61118),(.7856,55.28901,2.60666),(.81665,55.29897,2.61431),(.84738,55.31223,2.60901),(.85147,55.31175,2.61037),(.81637,55.2971,2.62299),(.89298,55.32256,2.54808),(.89178,55.3228,2.54619),(.89847,55.32056,2.51883),(.59297,55.29018,2.47775),(.60323,55.29263,2.4331),(.59616,55.29138,2.47923),(.79775,55.29047,2.43777),(.79047,55.2894,2.43409),(.79788,55.28416,2.43254),(.65542,55.28302,2.3913),(.65319,55.27944,2.38592),(.65837,55.27737,2.38523),(.61174,55.32362,2.93776),(.63522,55.33483,2.95921),(.63348,55.34009,2.9616),(.52504,55.34363,3.13524),(.52402,55.34243,3.1374),(.51691,55.33716,3.13165),(.46634,55.30407,2.87017),(.46605,55.30133,2.86677),(.46892,55.29974,2.86651),(.70845,55.32116,2.91293),(.73308,55.33654,2.91205),(.51964,55.29628,2.78376),(.4982,55.30099,2.77156),(.50574,55.3,2.7387),(.64447,55.28071,2.62254),(.5951,55.29057,2.62689),(.64439,55.27688,2.61913),(.60058,55.28824,2.62324),(.70984,55.32482,2.90994),(.734,55.32828,2.90189),(.8299,55.31794,2.78385),(.83221,55.31796,2.78377),(.82342,55.32845,2.8117),(.45747,55.31662,3.14843),(.40784,55.32038,3.16814),(.3286,55.27754,3.019),(.32662,55.28148,3.02125),(.29125,55.27601,3.00512),(.40595,55.32276,3.16738),(.39592,55.32785,3.19415),(.40221,55.30985,3.13153),(.40567,55.30656,3.13159),(.1557,55.32929,2.98187),(.16774,55.28605,3.00465),(.17315,55.26707,3.07353),(.16742,55.26929,3.06768),(.18741,55.26684,3.0437),(.01806,55.31867,3.32251),(.00413,55.29578,3.2843),(.00618,55.29611,3.28426),(.20742,55.28654,3.17981),(.2078,55.30822,3.22734),(.20499,55.3115,3.22548),(.01658,55.31912,3.32612),(.04088,55.33835,3.3347),(.16674,55.27391,3.07522),(.19819,55.27076,3.12714),(.00063,55.45055,3.30353),(0,55.55347,3.28158),(0,55.43453,3.28281),(.55418,55.65181,2.34596),(.53845,55.64642,2.40564),(.49024,55.7064,2.32305),(.28485,55.41139,2.88174),(.26669,55.58032,2.79149),(.32054,55.4169,2.86002),(.50834,55.27928,2.8203),(.50068,55.29643,2.86215),(.47571,55.37941,2.72242),(.50592,55.32507,2.68168),(.49674,55.32671,2.72325),(.56136,55.31041,2.88346),(.53987,55.28196,2.84456),(.58234,55.28889,2.87258),(1.02638,55.48373,2.08879),(1.02173,55.47785,2.13044),(1.01193,55.32406,2.10626),(1.05142,55.32818,2.04282),(1.07776,55.34505,2.00541),(1.05491,55.62299,1.98175),(1.07315,55.53569,1.93587),(1.06097,55.63528,1.89947),(1.05932,55.30182,1.75622),(1.10113,55.34448,1.72738),(.79287,55.29918,1.68564),(.81046,55.30002,1.66402),(1.05275,55.37627,1.492),(1.0463,55.29486,1.74492),(1.05399,55.29864,1.80505),(.90155,55.36217,1.41841),(.90472,55.35164,1.44904),(.83663,55.35486,1.43846),(.76261,55.33353,1.68357),(1.01446,55.29615,2.03985),(.96823,55.28102,2.07757),(.98546,55.28737,2.03993),(.92033,55.28381,2.0178),(.84671,55.26189,2.03402),(.84617,55.28097,2.001),(.75793,55.33554,2.89702),(.77316,55.33906,2.88147),(.77581,55.35068,2.89619),(.19537,55.26399,3.06592),(.20392,55.25462,3.11436),(.4915,55.32955,3.13068),(.4928,55.32501,3.11061),(.48997,55.60829,3.15708),(.29072,55.2743,3.00285),(.27072,55.29762,2.94897),(.31609,55.30008,2.92503),(.38076,55.26463,3.00614),(.29627,55.2743,3.00363),(.39768,55.29809,3.09976),(.43726,55.28379,3.09032),(.9099,55.30458,2.43106),(.96728,55.34562,2.37399),(.92078,55.35223,2.44023),(.82739,55.3122,2.74234),(.83868,55.35718,2.78036),(.83308,55.32392,2.78247),(.2194,55.27684,3.01014),(.05165,55.27584,3.06527),(.08573,55.28845,3.03469),(.08839,55.27868,3.03931),(.10816,55.28835,3.02104),(.12703,55.28434,3.01504),(.63989,55.2905,2.34128),(.64836,55.28518,2.22642),(.64067,55.29984,2.27886),(.63768,55.30399,2.20776),(.70328,55.32456,1.96339),(.70136,55.32256,1.92298),(.72224,55.27082,1.86621),(.70439,55.32268,1.88344),(.70598,55.32149,1.84339),(.99028,55.36256,2.32971),(.98145,55.31998,2.17064),(.97783,55.31597,2.14292),(1.01422,55.3596,2.1728),(.96793,55.30673,2.12027),(.95042,55.29941,2.10404),(.72321,55.27539,2.04802),(.78385,55.25777,2.01616),(1.03938,55.30661,2.03329),(1.00961,55.30891,2.08344),(.783,55.34905,1.48346),(.78125,55.38182,1.44016),(.79875,55.35203,1.4672),(.73874,55.35492,1.59713),(.74225,55.36915,1.54271),(.75628,55.33308,1.58526),(.78595,55.33171,1.55312),(.78182,55.32335,1.58395),(.75539,55.33873,1.54495),(1.10489,55.46695,1.50615),(1.06435,55.45346,1.45777),(1.06541,55.54773,1.45499),(.76487,55.33101,1.6187),(1.12761,55.40505,1.58216),(1.12047,55.40236,1.56591),(1.12546,55.49459,1.57821),(1.02597,55.37011,1.47777),(1.13181,55.4064,1.59929),(1.09088,55.55696,1.49556),(1.09948,55.56071,1.52559),(1.11673,55.4772,1.53193),(1.1091,55.38415,1.56336),(1.09492,55.37751,1.54328),(1.11077,55.39868,1.54183),(.96641,55.43121,1.39939),(.96808,55.51621,1.36435),(1.02148,55.53562,1.40058),(1.01935,55.44127,1.41379),(1.04304,55.44684,1.4344),(1.03776,55.39304,1.45496),(.90151,55.3149,1.68161),(.89133,55.28227,1.69407),(.83673,55.28014,1.67925),(.88553,55.28202,2.42107),(.88805,55.29147,2.37354),(1.23971,56.66167,1.99873),(1.29672,56.69333,2.02583),(1.27032,56.68474,1.9678),(1.29034,56.61782,2.35561),(1.31624,56.64608,2.34918),(1.30787,56.64194,2.29889),(1.36356,56.7187,2.17431),(1.38745,56.75425,2.16838),(1.38523,56.75271,2.15476),(1.41625,56.81199,2.11913),(1.41282,56.80628,2.08567),(1.36842,56.74541,2.10285),(1.42796,56.79964,2.17987),(1.39915,56.7621,2.22076),(1.45721,56.84263,2.21506),(1.40235,56.76456,2.2332),(1.40982,56.76432,2.26497),(1.42449,56.74629,2.34722),(1.41413,56.73807,2.38538),(1.46116,56.79207,2.33443),(1.37642,56.6801,2.43628),(1.11951,56.62544,2.42636),(1.08458,56.63331,2.5623),(1.10593,56.61698,2.55373),(1.29479,56.62562,2.58119),(1.27981,56.62972,2.46969),(1.22627,56.6193,2.4888),(1.15921,56.60465,2.6617),(1.20051,56.62413,2.64207),(1.13982,56.61371,2.54342),(1.06072,56.6479,2.71094),(1.07935,56.63528,2.56553),(1.00509,56.66945,2.58913),(.89933,55.3759,2.60723),(.87627,55.32201,2.58433),(.58327,55.31773,2.44235),(.60208,55.31424,2.39724),(.52183,55.32467,2.64652),(.54482,55.32806,2.6179),(.54202,55.30057,2.63878),(.73412,55.32762,2.90359),(.50156,55.29624,2.86274),(.51913,55.27809,2.83094),(.59733,55.32014,2.9056),(.42504,55.29706,3.00885),(.39856,55.26704,3.02604),(.03798,55.27246,3.09057),(.00348,55.2916,3.12187),(.04834,55.28954,3.06342),(.01333,55.26737,3.15288),(.54482,55.3913,3.17755),(.55423,55.35608,3.15057),(.31314,55.3141,3.21735),(.32735,55.32474,3.2233),(.00125,55.34763,3.32612),(.90936,55.27092,2.06061),(.8976,55.29685,2.09726),(.84459,55.29014,2.06464),(0,55.71193,3.22288),(.00573,55.85162,3.21598),(0,55.85248,3.214),(0,55.97085,3.25526),(.00282,55.97332,3.25454),(0,55.97774,3.25262),(.12135,55.90873,3.1573),(.11981,55.91522,3.15044),(.05241,55.95974,3.22085),(0,55.93103,3.23028),(.3501,55.93796,3.12276),(.2604,55.90305,3.12851),(.35369,55.93315,3.127),(.41564,56.03801,3.11383),(.41031,56.03825,3.11144),(.41165,56.02921,3.11564),(.05271,55.95348,3.2234),(.12127,55.89777,3.15828),(.04775,55.37709,3.03682),(.00354,55.39343,3.07146),(.00417,55.44978,3.04382),(.01599,55.50619,3.01077),(.01726,55.47618,3.02931),(.01176,55.4821,3.03511),(.01243,55.84861,2.94),(0,55.85205,2.95161),(0,56.0079,2.87432),(.02983,56.00874,2.83149),(.0037,56.01015,2.81982),(.0161,56.01015,2.83635),(.01243,56.00787,2.83756),(.00677,56.00791,2.86919),(.01243,56.00789,2.85609),(.01243,55.68113,2.99141),(.01243,55.67744,2.9809),(.01449,55.51015,3.01777),(.00352,55.5732,2.96562),(.00332,55.6634,2.91101),(.05115,55.56457,2.92985),(.04762,55.6488,2.86849),(.11585,55.74245,2.71848),(.0441,55.73674,2.8075),(.12529,55.74752,2.61535),(.15336,55.75235,2.48613),(.21624,55.74667,2.61886),(.00284,55.81721,1.7247),(0,55.82266,1.7304),(.00285,55.8246,1.73273),(.097,55.7549,1.74006),(.09352,55.74872,1.74611),(.02482,55.75366,1.73021),(.61735,55.71415,1.51718),(.62637,55.70615,1.50642),(.47925,55.90463,1.84372),(.53094,56.09857,1.8646),(.48053,55.90516,1.83134),(.63967,55.75955,1.48285),(.62254,55.71114,1.49414),(.63818,55.75816,1.48535),(.6235,55.78278,1.4886),(.62508,55.7777,1.48889),(.61649,55.77622,1.50303),(.61407,55.77782,1.50474),(.53203,56.01268,1.52844),(.63928,55.75382,1.49693),(.60508,55.72671,1.51483),(.61792,55.7242,1.51454),(.55045,55.72609,1.81671),(.51947,55.79406,1.67711),(.62862,55.63535,1.67569),(.74533,55.60168,1.34963),(.7511,55.53582,1.36121),(.51607,55.80447,1.67609),(.59553,55.73523,1.52617),(.59253,55.72829,1.53497),(.03096,56.01072,3.02303),(.03317,55.97145,3.19537),(.04108,55.96826,3.18621),(.02355,55.81067,1.94386),(.02466,55.86127,2.17618),(.02782,55.83843,2.17446),(.03274,55.97045,2.61901),(.00316,55.97716,2.6142),(.00338,55.97855,2.72308),(.01939,55.82277,1.94464),(.00177,55.83018,1.94295),(.0023,55.87501,2.17517),(.00267,56.00967,3.02262),(0,56.00802,3.0215),(0,55.97018,3.22024),(1.00064,56.69073,1.99901),(1.00239,56.69517,2.01691),(1.00529,56.69207,2.00088),(1.12474,56.61293,1.7548),(1.09843,56.63752,1.70607),(1.07407,56.69763,1.74672),(.09626,55.79614,2.18278),(.02918,55.90531,2.42147),(.72051,55.80279,1.40613),(.85776,55.80356,1.31227),(.87346,56.48769,2.67459),(.882,56.49312,2.66895),(.88877,56.52405,2.68049),(.92207,56.5327,2.67699),(.90345,56.53595,2.68334),(.91717,56.52978,2.67121),(.92485,56.48477,2.65415),(.91973,56.52198,2.6643),(.91605,56.48936,2.65527),(.80522,56.42527,2.78444),(.81134,56.3343,2.73506),(.81229,56.42317,2.77443),(.82653,56.49945,2.81077),(.99239,56.47418,2.7201),(1.002,56.47043,2.72314),(1.00001,56.47847,2.72774),(.9025,56.52851,2.79343),(.77945,56.71962,2.87389),(.40706,56.76582,1.71248),(.39652,56.7882,1.72203),(.4452,56.81731,1.64096),(.35742,56.78634,1.87063),(.36719,56.76258,1.86791),(.36472,56.76419,2.11284),(.46783,56.54342,2.53159),(.46289,56.53925,2.55562),(.44005,56.65847,2.59897),(.47951,56.38654,2.49271),(.49399,56.39393,2.47822),(.55873,56.17318,2.25374),(.47231,56.39731,1.37054),(.4858,56.19645,1.4486),(.47402,56.40502,1.45362),(.49436,56.18091,1.53695),(.52313,55.94515,1.69085),(.46522,56.52778,2.64404),(.4961,56.366,2.50181),(.48273,56.55406,2.61245),(.66934,56.40201,1.25359),(.5518,56.37956,1.29803),(.51705,56.60889,1.31092),(.47985,56.90037,2.05889),(.4269,56.93553,1.85706),(.40126,56.93609,2.08613),(.44282,56.87864,2.34209),(.43788,56.8549,2.43254),(.44676,56.86147,2.43416),(.38777,56.83438,2.56205),(.39292,56.84203,2.56322),(.42202,56.84997,2.49702),(.40178,56.78246,2.31708),(.40082,56.79518,2.39819),(.44984,56.85497,2.50768),(.4424,56.85895,2.4475),(.7998,56.73817,2.83685),(.64376,56.79236,2.7718),(.61405,56.82184,2.8564),(.44052,56.63623,2.63223),(.42744,56.68657,2.64972),(.40144,56.74989,2.60806),(.41983,56.71072,2.60886),(.40775,56.75287,2.6574),(.39671,56.81992,2.67297),(.38836,56.82023,2.66795),(.3948,56.80435,2.69198),(.42687,56.71722,2.69824),(.41736,56.7164,2.69567),(.43544,56.62145,2.67869),(.52161,56.3097,2.48798),(.51433,56.36905,2.52545),(.43074,56.85148,2.5715),(.49318,56.8474,2.64831),(.48186,56.70832,2.65115),(.48419,56.81347,2.65702),(.4536,56.82946,2.64304),(.40792,56.8054,2.67436),(.40202,56.80507,2.69286),(.41071,56.8388,2.60292),(.4244,56.81513,2.65193),(.51275,56.10785,2.88623),(.44871,55.98586,2.87039),(.48916,56.12282,2.92703),(.44843,56.3985,2.83498),(.4369,56.39817,2.84483),(.38687,56.55012,2.76817),(.3335,56.87875,2.8168),(.36346,56.84685,2.80441),(.3678,56.78043,2.83854),(.35504,56.70029,2.79304),(.35456,56.78034,2.80477),(.42834,56.60635,2.86507),(.38858,56.62198,2.81686),(.36187,56.5705,2.82078),(.34471,56.66268,2.7672),(.3693,56.56514,2.77083),(.40545,56.40563,2.92592),(.42723,56.39513,2.93342),(.41723,56.52524,2.81658),(.37596,56.62762,2.79936),(.40411,56.80743,2.47637),(.41478,56.84334,2.49239),(.49812,56.50659,2.8385),(.54212,56.39584,2.75705),(.51582,56.38863,2.8061),(.51583,56.66202,2.67781),(.54052,56.78052,2.74485),(.48562,56.82355,2.88714),(.41181,56.82624,2.88138),(.40553,56.87534,2.88516),(.34374,56.88928,2.80229),(.36331,56.8847,2.83912),(.36692,56.8415,2.84038),(.39299,57.00673,2.93248),(.48775,56.89127,2.93035),(.4684,56.86848,1.62689),(.5246,56.90646,1.84252),(.98955,55.79355,1.40444),(1.06306,55.7357,1.47501),(1.01377,55.67721,1.38063),(1.06937,56.71025,1.76362),(1.20591,56.64953,1.89717),(1.2039,56.64491,1.89725),(.91439,56.75052,2.06333),(.92656,56.73466,2.04268),(.91145,56.73345,2.00454),(.84673,56.77364,1.47714),(.85363,56.75275,1.48122),(.72615,56.64722,1.31659),(1.06363,56.68795,1.737),(1.06937,56.69762,1.74349),(1.09482,56.63893,1.70151),(.98991,56.69146,1.52723),(.94525,56.69641,1.47667),(.93992,56.71895,1.4946),(.70296,56.7893,1.43628),(.84241,56.77681,1.47562),(.98915,56.6903,2.03552),(.97671,56.69474,2.03634),(.96747,56.68824,2.07339),(.94821,56.71057,2.04401),(.93595,56.71845,2.05598),(.93223,56.72516,2.07595),(.92899,56.7351,2.06587),(.92832,56.74485,2.12142),(1.00103,56.71913,1.67413),(1.05694,56.69785,1.752),(.99338,56.68943,2.00773),(.99541,56.68322,1.98834),(.97727,56.69504,2.01482),(1.59161,56.22702,2.31228),(1.59582,56.19896,2.31274),(1.48363,56.22937,2.26923),(1.23694,56.68621,1.91605),(1.23937,56.63009,1.97125),(1.45902,56.79541,2.30685),(1.39469,56.56381,2.28311),(1.3623,56.5669,2.24607),(1.36532,56.41906,2.2142),(1.34994,56.43065,2.16788),(1.35738,56.57972,2.17824),(1.45835,56.8387,2.23474),(1.45791,56.83963,2.2157),(1.41434,56.79051,2.15201),(1.41283,56.7926,2.15371),(1.41694,56.80836,2.11825),(1.44919,56.82567,2.19358),(1.44715,56.82913,2.19421),(1.30203,56.4678,2.04613),(1.32844,56.60134,2.07637),(1.02547,56.68501,2.05412),(1.12425,56.66863,2.03012),(1.23804,56.68984,1.91664),(1.37747,56.72555,2.05158),(1.33038,56.73248,1.99916),(1.37488,56.72901,2.05103),(1.27491,56.6686,2.05256),(1.25312,56.64929,2.06876),(1.27763,56.63156,2.11803),(1.46087,56.79055,2.32864),(1.26891,56.68075,1.96815),(1.37418,56.67423,2.44624),(1.33959,56.63776,2.45364),(1.3284,56.64724,2.52606),(1.33393,56.65279,2.53949),(1.33461,56.64219,2.48731),(1.21912,56.62159,2.63013),(1.21471,56.61937,2.62332),(1.08423,56.64224,2.69299),(1.08107,56.64126,2.68162),(1.42188,56.67992,2.41682),(1.29629,56.62914,2.65904),(1.30063,56.6113,2.62935),(1.26376,56.63849,2.5902),(1.26367,56.61376,2.66069),(1.24256,56.61508,2.67642),(1.06063,56.64891,2.71834),(1.02359,56.6694,2.78816),(1.08141,56.64451,2.75942),(1.44418,56.56018,2.33051),(1.49113,56.7787,2.33853),(1.47375,56.66983,2.34405),(1.45539,56.725,2.40863),(1.489,56.70534,2.34756),(1.32993,56.64373,2.48532),(1.32235,56.64811,2.42536),(1.30889,56.64028,2.44027),(1.08586,56.62987,2.68816),(1.20919,56.61501,2.38392),(1.11295,56.61383,2.54901),(1.07789,56.5924,2.78366),(1.1006,56.41983,2.68943),(1.09575,56.58181,2.77405),(1.30614,56.62904,2.55191),(1.29051,56.63289,2.4544),(1.2307,56.65752,2.00037),(1.22779,56.61323,2.75495),(1.16318,56.58813,2.76113),(1.2154,56.42124,2.63987),(1.33358,56.57464,2.60932),(1.31096,56.56627,2.62192),(1.31945,56.45173,2.58522),(1.2867,56.59307,2.68176),(1.3429,56.62571,2.61143),(1.31662,56.60999,2.61346),(1.39998,56.59448,2.48748),(1.3687,56.54955,2.52259),(1.40785,56.54346,2.5034),(1.60054,56.23209,2.3209),(1.57431,56.28063,2.31454),(1.60878,56.07651,2.33213),(1.59854,56.09949,2.3502),(1.595,56.09381,2.35347),(1.57298,56.13422,2.3542),(1.56868,56.13284,2.35909),(1.56608,56.45398,2.40493),(1.5331,56.47576,2.41007),(1.52848,56.4786,2.41737),(1.60692,56.10514,2.31173),(1.46518,56.08308,2.26301),(1.58231,56.14153,2.30601),(1.56128,56.45434,2.41234),(1.42736,56.47409,2.51094),(1.55075,56.51751,2.37851),(1.52823,56.49486,2.39524),(1.53557,56.4895,2.32679),(1.53213,56.49028,2.32286),(1.54231,56.45386,2.32171),(1.20948,56.54097,1.88022),(1.27312,56.43779,2.61085),(1.25809,56.57827,2.70469),(1.36725,56.60056,2.51271),(1.34859,56.61117,2.55406),(1.34415,56.55996,2.55791),(1.28361,55.91322,2.23572),(1.31119,56.00209,2.38745),(1.23813,55.92671,2.39624),(1.08718,55.72146,1.90018),(1.07186,55.8646,2.50244),(1.1144,55.95849,2.52692),(.96472,55.94225,2.60333),(.82445,55.94825,2.66058),(.99296,56.0444,2.61013),(.83881,56.06188,2.69699),(.54608,56.82915,2.74456),(.5215,56.83994,2.61912),(.26481,57.08861,2.83366),(.27514,57.15234,2.82437),(.30038,57.09106,2.85376),(.31464,56.97987,3.0657),(.34657,56.99261,2.99967),(.31343,57.10193,2.98997),(.44223,56.83189,2.98913),(.53526,56.7068,2.95766),(.61152,56.79671,2.91665),(.42263,56.80924,3.01735),(.44944,56.18258,3.12317),(.54214,56.01827,2.99641),(.53621,56.15543,2.99273),(.42413,55.83756,3.06591),(.51723,56.37369,2.9915),(.48412,56.37836,3.05432),(.38251,55.68379,3.11093),(.23562,55.56475,3.17417),(.18421,55.66376,3.16772),(.20705,55.59242,3.22279),(.26217,55.47489,3.23721),(.46735,56.66696,3.00248),(.43736,56.62913,3.06248),(1.01397,56.66033,2.83956),(.66531,56.25554,2.86906),(.6465,56.3442,2.89854),(.60839,56.33623,2.91406),(.69456,55.58315,3.0136),(.722,55.58259,2.98426),(.67987,55.77607,2.95381),(.79804,55.95674,2.6893),(.78377,56.04026,2.74444),(.76965,55.88874,2.80795),(.85132,56.40341,2.70213),(.84135,56.46156,2.73636),(.73398,56.11058,2.81255),(.98029,56.52864,2.76399),(1.07272,56.63772,2.81067),(1.08684,56.26611,2.62963),(1.60901,56.10691,2.31676),(.99616,55.59551,2.38523),(1.00574,55.59088,2.3234),(1.05335,55.73203,2.39996),(.95127,55.89538,2.60461),(.90866,55.7186,2.61711),(.90016,55.51986,2.62391),(1.36779,55.97126,2.25719),(1.31336,56.02078,2.15406),(1.44314,56.01381,2.27198),(1.17109,55.81732,2.1446),(1.25893,56.09989,2.01195),(1.1419,55.877,1.88601),(1.14628,56.1696,1.59078),(1.17204,56.15002,1.70354),(1.12183,55.9703,1.53502),(.34863,57.10014,2.91799),(.32632,56.98208,2.84969),(1.08563,56.63953,1.69314),(1.16635,56.61461,2.52267),(1.02126,56.70515,2.11198),(1.14589,56.66003,2.09872),(1.0763,56.66945,2.24703),(1.08199,56.63752,2.43477),(.95293,55.80788,1.36242),(.86903,56.08901,1.28077),(.86106,56.68454,1.39617),(.55967,56.02078,1.4545),(.61797,56.0352,1.35716),(.4453,56.18201,3.12172),(.42215,56.3871,3.17122),(.2422,56.88566,3.19741),(.35984,56.72897,3.02597),(.36215,56.56537,3.02245),(.43651,56.15623,3.01792),(.42965,56.40174,2.85608),(.35005,55.93369,3.01872),(.40044,56.03168,3.02049),(.53805,56.09185,2.84242),(.09529,55.84285,2.41036),(.19702,55.78704,2.18873),(.59079,56.05932,2.46096),(.54532,56.16983,2.25338),(.01625,55.81515,1.72445),(.00244,55.76944,1.72641),(.04205,55.74165,1.93506),(.00443,55.75631,2.1828),(.00434,55.74859,1.93095),(.42819,55.7067,2.55773),(.41241,55.78005,2.27909),(.51008,55.70479,1.91813),(.49138,55.67169,2.01551),(.47129,55.73779,1.99214),(.48582,55.70992,2.16951),(.44888,55.77887,1.98553),(.50014,55.80284,1.82368),(.60539,55.71698,1.51937),(.66425,55.5037,1.84943),(.6614,55.49633,1.89826),(.60825,55.67023,1.8222),(.35065,55.599,2.72656),(.44423,55.43599,2.78474),(1.08047,55.3727,1.52719),(1.09281,55.37836,1.54463),(1.08844,55.40878,1.53905),(.93874,55.39634,1.49706),(.94055,55.36617,1.49294),(.97458,55.36701,1.50166),(.73478,55.3135,1.89839),(.73804,55.31216,1.92884),(.81477,55.33422,1.73156),(.81002,55.28139,1.71176),(.83963,55.28021,1.71044),(.92229,55.34687,1.7547),(.87099,55.34075,1.74519),(.87871,55.28138,1.72215),(.73123,55.36169,2.29893),(.7429,55.27447,2.30828),(.67927,55.27685,2.27037),(.68076,55.34937,2.10647),(.68355,55.2933,2.09852),(.84459,55.31124,2.63383),(.83746,55.30378,2.6883),(.60528,55.30763,2.51895),(.60804,55.34789,2.5322),(.63715,55.31467,2.55316),(.54381,55.37087,2.65035),(.54518,55.31745,2.64402),(.59331,55.31607,2.62846),(.82251,55.36257,2.81972),(.82113,55.32913,2.81232),(.81164,55.33561,2.83412),(.71109,55.33308,2.90655),(.65834,55.30827,2.88221),(.97755,55.60741,1.61695),(1.0003,55.60663,1.62241),(1.01317,55.58237,1.61832),(1.10357,55.42159,1.60651),(1.06521,55.42013,1.6105),(1.05628,55.45989,1.60953),(.90789,55.60211,1.62269),(.91927,55.5714,1.60711),(.9145,55.57006,1.62084),(.91704,55.65861,1.62415),(.91801,55.6306,1.62017),(.90966,55.6312,1.62692),(.92138,55.63191,1.61073),(.91907,55.63313,1.60001),(.90951,55.60419,1.59213),(.9242,55.53445,1.60339),(.92305,55.534,1.58707),(.93297,55.49244,1.57636),(.9612,55.41624,1.53191),(.95662,55.41629,1.53398),(.97003,55.40875,1.51143),(.94634,55.41595,1.56025),(.95033,55.41681,1.5586),(.93917,55.40965,1.58326),(.96005,55.66184,1.63303),(.96301,55.64839,1.62817),(.95467,55.64792,1.62482),(1.10087,55.46491,1.63049),(1.09308,55.46497,1.62192),(1.10407,55.42164,1.60697),(1.03143,55.61875,1.65522),(1.04304,55.58604,1.65026),(1.0478,55.58792,1.65894),(.88793,55.69703,1.61723),(.88153,55.69359,1.61231),(.88938,55.69706,1.61558),(.91064,55.69591,1.61284),(.91327,55.69096,1.60534),(.91716,55.69145,1.60763),(.91946,55.69227,1.61277),(.91967,55.69143,1.61746),(.91249,55.69547,1.6173),(.94858,55.68633,1.6571),(.94062,55.68623,1.65238),(.94359,55.6813,1.64078),(.90659,55.60506,1.58297),(.90534,55.57028,1.5728),(.96815,55.3992,1.50042),(.94219,55.44943,1.53052),(.95892,55.67697,1.61216),(.95538,55.66411,1.59569),(.9638,55.66524,1.5946),(.96783,55.65253,1.58285),(.96073,55.64955,1.58487),(.97881,55.62968,1.57134),(.97919,55.60531,1.55089),(.98496,55.57961,1.53692),(.99218,55.58208,1.53286),(.988,55.44954,1.49943),(.98063,55.44955,1.50452),(.97148,55.40829,1.5093),(1.11355,55.4142,1.60798),(.9423,55.65568,1.63887),(.93597,55.66112,1.63627),(.93366,55.65282,1.6373),(.90641,55.68605,1.64249),(.91344,55.68851,1.63561),(.91762,55.68485,1.64085),(.97823,55.68604,1.64241),(.9705,55.68723,1.64349),(.97374,55.68125,1.63848),(.96101,55.67788,1.62761),(.96605,55.67768,1.62857),(.95924,55.67193,1.63274),(.96056,55.67901,1.62188),(.95221,55.67538,1.61425),(.95096,55.45069,1.55074),(.96822,55.67795,1.61219),(.97515,55.66732,1.59571),(.98927,55.67139,1.59859),(.98622,55.67972,1.62283),(.99548,55.67897,1.61841),(1.00025,55.67917,1.6201),(.99002,55.66377,1.63712),(.9928,55.67376,1.63518),(.99834,55.66776,1.63484),(.98258,55.6779,1.63106),(.88584,55.68628,1.63913),(.87044,55.6822,1.62839),(.88467,55.69357,1.6262),(.91417,55.68184,1.601),(.92168,55.68319,1.60392),(.92689,55.66042,1.61403),(.92444,55.65919,1.6208),(.92472,55.6844,1.61971),(.95464,55.68626,1.67044),(.9366,55.66644,1.67711),(.94208,55.68291,1.66251),(.8429,55.65259,1.63662),(.83818,55.6565,1.62219),(.869,55.68249,1.61082),(.8674,55.68154,1.61486),(.83983,55.65609,1.61401),(.87472,55.68283,1.60373),(.87149,55.68265,1.60721),(.84446,55.65607,1.6019),(.88904,55.658,1.5891),(.90638,55.65963,1.59476),(1.02431,55.66156,1.60063),(1.04214,55.64387,1.58268),(1.02579,55.66129,1.60944),(1.02401,55.65812,1.61822),(1.0411,55.63956,1.60799),(1.01905,55.65724,1.62614),(.98271,55.65442,1.58327),(.87461,55.65714,1.59099),(.85679,55.63086,1.57969),(.87667,55.63,1.58427),(.91893,55.6547,1.62925),(.91219,55.63028,1.6313),(.89016,55.6393,1.67754),(.90271,55.66414,1.65962),(.86886,55.66179,1.65384),(.81641,55.62681,1.63975),(.82766,55.62943,1.59083),(.8374,55.62981,1.58583),(.85435,55.65639,1.59432),(.91468,55.60368,1.60315),(1.0373,55.62309,1.67633),(1.03666,55.6237,1.6933),(1.02037,55.64966,1.67929),(1.03536,55.64225,1.57379),(1.05231,55.61788,1.55558),(1.06021,55.61673,1.59749),(1.07694,55.58982,1.58655),(1.05071,55.61524,1.61015),(1.01488,55.58417,1.53116),(1.00549,55.61074,1.54555),(.82583,55.60343,1.57682),(.81571,55.6028,1.5831),(.80048,55.56511,1.56909),(.91148,55.60201,1.62797),(.9181,55.57017,1.62735),(.94369,55.57237,1.6477),(1.05468,55.5913,1.71486),(1.03154,55.62355,1.70463),(1.0758,55.5899,1.57035),(1.08337,55.55465,1.56085),(1.08911,55.55547,1.57791),(.79412,55.56396,1.58214),(.79092,55.52616,1.571),(1.0587,55.59134,1.69763),(1.05477,55.58887,1.68045),(1.07662,55.55289,1.67557),(.92717,55.49271,1.62317),(.96111,55.49628,1.64051),(.95398,55.53701,1.64625),(1.07614,55.45329,1.51483),(1.08178,55.45535,1.53096),(1.08718,55.50671,1.53321),(1.0043,55.49663,1.74163),(.96812,55.44514,1.71056),(.96197,55.49003,1.72515),(.80834,55.48427,1.53339),(.80895,55.43631,1.51572),(.84175,55.48569,1.5283),(.90471,55.44161,1.69429),(.91303,55.3918,1.68223),(.83071,55.38358,1.6527),(.89014,55.40882,1.76435),(.92968,55.41331,1.77041),(.77742,55.66186,1.80309),(.76956,55.66957,1.80544),(.76838,55.66965,1.80269),(.85465,55.39303,1.76438),(.85892,55.40512,1.79742),(.85355,55.40828,1.79657),(.86684,55.39227,1.76621),(.87621,55.41139,1.76882),(.87404,55.41096,1.79966),(.91238,55.64104,1.87684),(.9174,55.64131,1.86132),(.92165,55.66904,1.88591),(.92568,55.66384,1.90614),(.9215,55.66366,1.89956),(.92875,55.67349,1.90297),(.87089,55.41019,1.86017),(.87222,55.41065,1.82967),(.89028,55.45556,1.83597),(.86416,55.40881,1.8304),(.86943,55.40279,1.8277),(.85123,55.45254,1.85155),(.84818,55.45664,1.82177),(.86143,55.40921,1.83037),(.78135,55.663,1.81561),(.78032,55.66177,1.80857),(.78798,55.635,1.81428),(.86808,55.40183,1.79646),(.8803,55.4097,1.86899),(.86853,55.41047,1.86453),(.88805,55.41297,1.86784),(.9276,55.40904,1.88323),(.92671,55.41247,1.89161),(.87206,55.40804,1.87667),(.80062,55.40201,1.92498),(.83207,55.3964,1.90129),(.80984,55.39279,1.93063),(.80151,55.44377,1.92364),(.83686,55.40817,1.90373),(.8009,55.40526,1.92235),(.78017,55.66172,1.82523),(.77501,55.6624,1.83816),(.77097,55.66845,1.82021),(.85835,55.41188,1.88071),(.82965,55.41156,1.90331),(.86543,55.41305,1.88065),(.96077,55.68211,1.97619),(.95296,55.68058,1.97385),(.95672,55.67471,1.96878),(.90811,55.65529,1.96664),(.91895,55.656,1.96165),(.927,55.67247,1.96749),(.95356,55.68508,1.98643),(.95957,55.68205,1.99528),(.95544,55.68204,1.99672),(.955,55.68523,1.98453),(.96299,55.68211,1.98731),(.93304,55.68163,1.98211),(.92552,55.67798,1.98347),(.93327,55.68161,1.98015),(.9359,55.68167,1.89329),(.9388,55.67995,1.8852),(.95846,55.682,1.89453),(.76311,55.66416,1.79127),(.7681,55.66388,1.79272),(.76702,55.66981,1.80026),(.78253,55.39039,1.94861),(1.03107,55.41999,1.90634),(.981,55.41475,1.89518),(1.0255,55.42783,1.89538),(.91575,55.671,1.98885),(.92627,55.6784,1.97767),(.93793,55.67764,1.96965),(.92926,55.67731,1.97248),(.87166,55.41208,1.88341),(.87698,55.44874,1.90981),(.93321,55.63975,1.9066),(.93178,55.66375,1.91189),(.91319,55.61689,1.84776),(.9242,55.64414,1.85737),(1.03768,55.42156,1.88632),(1.00363,55.47082,1.88464),(1.01506,55.47316,1.87981),(1.02821,55.4247,1.93714),(1.0423,55.41967,1.95154),(1.0273,55.45849,1.97568),(.88838,55.45364,1.77988),(.90347,55.45542,1.77622),(.91499,55.51642,1.79695),(.78973,55.376,1.96903),(.7775,55.37548,1.95457),(.78713,55.38683,1.95185),(.80816,55.4226,1.98444),(.81437,55.46982,1.98549),(.81539,55.46731,1.99726),(.95362,55.68489,1.98136),(.96351,55.68244,1.98057),(1.04452,55.40613,1.92962),(.79345,55.38617,1.9648),(.7976,55.38516,1.97431),(.85248,55.37825,1.75156),(.8674,55.3817,1.75468),(.91549,55.66857,1.97607),(.91532,55.66804,1.98199),(.92785,55.65354,1.96242),(.9448,55.67221,1.96627),(.93563,55.67106,1.96732),(.90039,55.62823,2.01019),(.88314,55.62928,2.00385),(.90365,55.6529,1.99838),(.86965,55.59636,2.01305),(.86089,55.59463,2.00177),(.88033,55.62852,1.99408),(.97353,55.64082,2.00461),(.97683,55.61604,2.01329),(.96726,55.63929,2.01923),(.926,55.67263,1.88198),(.99098,55.63112,1.89486),(.98897,55.6289,1.90513),(.98319,55.64853,1.91127),(1.01899,55.47456,1.85997),(.88512,55.45496,1.80892),(.72478,55.50956,1.78627),(.73566,55.50996,1.77025),(.73062,55.57469,1.77725),(.77785,55.31555,1.9604),(.91169,55.66417,2.30317),(.91027,55.70375,2.30632),(.87943,55.66313,2.30603),(.84083,55.54664,2.22011),(.84892,55.5811,2.20594),(.88217,55.54203,2.22687),(.80282,55.54995,2.12121),(.82423,55.58467,2.11836),(.81941,55.54507,2.17619),(.83134,55.53003,2.09259),(.85981,55.58215,2.0977),(.81146,55.54318,2.10223),(.95872,55.53026,2.21388),(.95552,55.57294,2.2044),(.96035,55.52248,2.18714),(.95873,55.52965,2.22694),(.95251,55.5579,2.26865),(.92252,55.55218,2.26117),(.63837,55.57625,2.24338),(.63842,55.53849,2.23877),(.63238,55.57727,2.21059),(.86653,55.76667,2.38505),(.85441,55.76532,2.38415),(.86022,55.79007,2.36153),(.74582,55.79866,2.26122),(.74398,55.79855,2.27068),(.74312,55.82314,2.25805),(.72069,55.80229,2.17885),(.72953,55.80241,2.18466),(.72714,55.82867,2.19978),(.85761,55.7982,2.152),(.86239,55.76796,2.1317),(.88377,55.7703,2.13904),(.83393,55.76473,2.14879),(.84005,55.76536,2.13762),(.83873,55.7946,2.16322),(.89818,55.76747,2.29932),(.86856,55.76416,2.29795),(.87519,55.73948,2.29637),(.93646,55.74825,2.33913),(.92187,55.76701,2.33167),(.92045,55.77222,2.31449),(.90828,55.77184,2.37315),(.91736,55.7668,2.35501),(.92983,55.74827,2.36641),(.89538,55.80877,2.21297),(.90798,55.79901,2.20779),(.90209,55.79683,2.21948),(.74239,55.65104,2.29584),(.72312,55.64201,2.30641),(.72091,55.71768,2.3037),(.62478,55.63986,2.25015),(.6547,55.63383,2.27841),(.6609,55.57438,2.2748),(.62178,55.6443,2.21642),(.63144,55.57583,2.17825),(.82568,55.63564,2.38935),(.83988,55.6394,2.41103),(.83608,55.60449,2.40753),(.9442,55.63674,2.37545),(.93735,55.67366,2.37477),(.94707,55.63094,2.32945),(.69759,55.82514,2.26659),(.70835,55.83622,2.25361),(.7227,55.83699,2.25853),(.83296,55.52179,2.22133),(.95848,55.52241,2.21785),(.96816,55.52088,2.26611),(.80952,55.52873,2.17368),(.81206,55.52846,2.17417),(.74411,55.50526,2.10292),(.78799,55.51768,2.11387),(.77867,55.51895,2.11491),(.80031,55.51793,2.10334),(.78861,55.44283,2.09155),(.83752,55.45379,2.09616),(.66497,55.42738,2.13895),(.67984,55.42884,2.11837),(.67194,55.50439,2.12055),(.75349,55.57484,2.13602),(.76831,55.58405,2.17968),(.75147,55.65277,2.17786),(.70058,55.53577,2.11127),(.70566,55.50175,2.10244),(.86004,55.76753,2.21643),(.84914,55.76609,2.20636),(.85289,55.79657,2.22119),(.91334,55.77359,2.21427),(.89031,55.79559,2.22584),(.85933,55.62044,2.19525),(.88612,55.61977,2.20894),(.8827,55.58085,2.21594),(.83176,55.76213,2.36661),(.83024,55.76152,2.35134),(.84177,55.7873,2.34258),(.8426,55.51555,2.24082),(.87938,55.51289,2.22374),(.8845,55.79049,2.29967),(.84637,55.7851,2.31092),(.84085,55.76088,2.30595),(.89877,55.79515,2.3225),(.9524,55.56069,2.3559),(.94967,55.59106,2.31659),(.95979,55.55401,2.29379),(.6963,55.63425,2.30084),(.69648,55.71443,2.30324),(.64517,55.50622,2.19473),(.6497,55.50643,2.16616),(.63566,55.54039,2.17418),(.87665,55.70138,2.30479),(.86611,55.80098,2.31829),(.86767,55.80127,2.32963),(.85707,55.80016,2.33463),(.68546,55.35599,2.26245),(.658,55.34813,2.22642),(.6574,55.42734,2.22492),(.67139,55.34676,2.13505),(.81013,55.66008,2.61508),(.79634,55.65675,2.61481),(.80155,55.66381,2.61285),(.80581,55.66392,2.59314),(.81551,55.65553,2.58631),(.81382,55.66034,2.59493),(.83708,55.65918,2.60069),(.84423,55.65126,2.59348),(.85313,55.64967,2.60361),(.82258,55.66053,2.61754),(.82738,55.65188,2.62178),(.80948,55.65463,2.61871),(.78905,55.64869,2.56675),(.77612,55.6199,2.5363),(.78823,55.61676,2.5418),(.73919,55.63187,2.55036),(.72726,55.61661,2.5327),(.74469,55.63041,2.54198),(.88203,55.50483,2.51823),(.89166,55.49505,2.54956),(.88243,55.55931,2.56531),(.67521,55.55046,2.56898),(.67082,55.55281,2.53803),(.72171,55.61593,2.56396),(.55224,55.39314,2.88893),(.55589,55.35018,2.89054),(.59106,55.35972,2.9087),(.49647,55.33508,2.86766),(.51908,55.34025,2.87152),(.52017,55.38533,2.86822),(.39973,55.38308,2.93584),(.41506,55.32283,2.9069),(.40954,55.37924,2.90978),(.54136,55.44182,3.14865),(.55217,55.37994,3.15062),(.51394,55.43739,3.14223),(.46797,55.85823,3.00171),(.46159,55.85455,2.98715),(.46375,55.88824,2.96829),(.45817,55.87578,2.90582),(.45682,55.8387,2.91697),(.46442,55.83659,2.91264),(.4606,55.90567,2.90782),(.47323,55.91703,2.92057),(.45904,55.90559,2.91411),(.49585,55.90373,2.90215),(.48904,55.91887,2.9166),(.48755,55.90406,2.89748),(.46061,55.60714,2.89147),(.43709,55.60551,2.90173),(.43285,55.56692,2.89929),(.55102,55.58881,2.92348),(.52472,55.62024,2.91221),(.52754,55.58159,2.90378),(.44584,55.78469,2.93617),(.44519,55.84161,2.93267),(.44722,55.84472,2.95186),(.44561,55.79137,2.97523),(.44876,55.83949,2.92196),(.46877,55.80544,3.03498),(.47303,55.75245,3.05615),(.4577,55.74755,3.04184),(.45245,55.72559,2.92587),(.45387,55.78447,2.92738),(.47789,55.78547,2.91242),(.46293,55.78426,2.91775),(.46075,55.72613,2.91538),(.53995,55.76442,3.06249),(.53087,55.76411,3.06868),(.51995,55.81556,3.04531),(.46214,55.6546,2.89789),(.47743,55.72843,2.9126),(.44177,55.72561,2.94155),(.43176,55.65467,2.92595),(.42253,55.66166,2.97613),(.42278,55.65792,2.95286),(.43551,55.72721,2.95524),(.5038,55.91727,2.96259),(.50492,55.89813,2.9826),(.4924,55.91706,2.96605),(.49581,55.66049,2.90564),(.49944,55.61378,2.89835),(.42088,55.50957,3.02209),(.4235,55.43843,3.02207),(.40084,55.42652,2.97348),(.41019,55.4885,2.91392),(.40626,55.49372,2.94425),(.40115,55.42106,2.94031),(.74577,55.77418,2.84716),(.74724,55.77282,2.84065),(.75357,55.75817,2.8466),(.57393,55.79155,2.73058),(.56853,55.79176,2.73824),(.55872,55.77956,2.73214),(.56802,55.77851,2.77038),(.5629,55.77921,2.76665),(.57531,55.78912,2.76308),(.59446,55.78898,2.76369),(.59508,55.79438,2.75455),(.60098,55.78726,2.75506),(.60268,55.78688,2.74385),(.59811,55.79429,2.74653),(.52587,55.72692,2.7705),(.54445,55.76554,2.76496),(.5482,55.76556,2.77086),(.54432,55.60125,2.80676),(.57378,55.60048,2.80674),(.5827,55.53701,2.82667),(.60527,55.59953,2.70008),(.63162,55.5289,2.69013),(.65662,55.53379,2.71008),(.57941,55.79057,2.72631),(.59172,55.78831,2.72679),(.59077,55.79447,2.7346),(.73468,55.79026,2.83615),(.74028,55.78411,2.84184),(.73752,55.78441,2.84689),(.67914,55.54376,2.74999),(.68638,55.50777,2.72362),(.7063,55.53205,2.74316),(.51421,55.533,2.70166),(.53124,55.47701,2.67624),(.5341,55.53256,2.68678),(.64142,55.47178,2.66983),(.70966,55.44448,2.69737),(.76841,55.4182,2.71503),(.72012,55.40422,2.68279),(.72751,55.36576,2.67154),(.49731,55.4798,2.73169),(.50318,55.47954,2.71192),(.50362,55.53328,2.72156),(.54861,55.47832,2.82634),(.52824,55.47884,2.81501),(.53373,55.53315,2.81581),(.65081,55.5294,2.88214),(.60099,55.44638,2.85158),(.60449,55.48399,2.84147),(.68959,55.52865,2.90689),(.70075,55.60312,2.90305),(.71079,55.52806,2.9096),(.7189,55.60265,2.90805),(.53595,55.66352,2.79082),(.55978,55.6648,2.7966),(.49711,55.66647,2.74983),(.50193,55.66524,2.76159),(.5008,55.60225,2.77023),(.52106,55.72952,2.75839),(.51977,55.73124,2.74746),(.58347,55.66471,2.69878),(.60219,55.66416,2.7351),(.59689,55.72863,2.73979),(.53397,55.66691,2.69003),(.55892,55.66539,2.68959),(.56981,55.72976,2.70757),(.60859,55.50009,2.83536),(.71111,55.66617,2.79644),(.6846,55.66596,2.80766),(.67909,55.61178,2.80703),(.73977,55.77387,2.8551),(.70022,55.77279,2.84526),(.70886,55.78579,2.82942),(.70857,55.78682,2.83882),(.55321,55.53207,2.82091),(.50929,55.53319,2.79587),(.50423,55.53323,2.77324),(.50981,55.60198,2.71478),(.52444,55.60162,2.69685),(.62385,55.5992,2.73278),(.66281,55.54346,2.73575),(.77636,55.66632,2.85628),(.78548,55.59748,2.85302),(.76914,55.66674,2.87008),(.72423,55.72918,2.89004),(.72154,55.66757,2.90429),(.71133,55.72852,2.88875),(.49836,55.47965,2.76425),(.49808,55.42585,2.75338),(.29718,55.60744,3.13868),(.30058,55.54844,3.1651),(.28185,55.60326,3.13867),(.06205,55.76469,3.11124),(.05501,55.76695,3.10496),(.06207,55.76324,3.10594),(.05452,55.7678,3.10862),(.05908,55.76523,3.11534),(.04418,55.75633,3.08855),(.04845,55.75643,3.08573),(.04908,55.76321,3.09253),(.06202,55.76194,3.10072),(.07796,55.73084,3.10485),(.07992,55.73445,3.11553),(.03843,55.58337,3.23708),(.02253,55.57914,3.23014),(.02576,55.63344,3.20427),(.05209,55.76766,3.10973),(.91674,56.38351,2.56824),(.98401,56.33011,2.53651),(.99885,56.06287,2.47739),(1.13728,55.86146,2.18713),(1.12413,55.86921,2.24862),(1.25715,55.914,2.27199),(1.3639,56.07597,2.26927),(1.33312,56.06548,2.23218),(1.32092,55.98901,2.22753),(1.11099,55.87695,2.31042),(1.18476,55.96551,2.28518),(1.23603,55.92611,2.27294),(1.37003,56.11646,2.30245),(1.37273,56.11798,2.29475),(1.34645,56.08608,2.26689),(1.26378,56.5686,2.43021),(1.24356,56.55341,2.32802),(1.26227,56.53468,2.31876),(1.27665,56.51396,2.27906),(1.28616,56.51643,2.30601),(1.28223,56.09126,2.27689),(1.33389,56.06574,2.25887),(1.35829,56.46231,2.41694),(1.34779,56.49363,2.42438),(1.35299,56.45811,2.39161),(1.30131,56.46992,2.38721),(1.33688,56.51224,2.44631),(1.35206,56.49582,2.46323),(1.33069,56.2314,2.2877),(1.36514,56.23815,2.33089),(1.35638,56.39491,2.37161),(1.35368,56.45533,2.34896),(1.31924,56.52928,2.42811),(1.34759,56.4925,2.38496),(1.35306,56.49724,2.45398),(1.36439,56.23635,2.33825),(1.36399,56.39686,2.38838),(1.33737,56.23106,2.30883),(1.34827,56.0904,2.23442),(1.3711,56.09422,2.27351),(.95705,56.46385,2.54501),(.92437,56.45257,2.54188),(.92823,56.51926,2.4797),(.95677,56.52699,2.47805),(.87065,56.70215,2.31693),(.89882,56.68918,2.30619),(.89509,56.68648,2.39491),(1.01699,56.62945,2.08053),(1.10393,56.61446,1.99806),(1.12124,56.60683,2.0551),(1.01848,56.65495,1.94091),(.97771,56.66444,1.96356),(1.00589,56.6745,1.76934),(.91264,56.70011,1.97702),(.91655,56.72481,1.78399),(.91956,56.72121,1.78306),(1.26533,56.55125,2.20402),(1.2622,56.55713,2.1291),(1.29443,56.52451,2.17753),(.91172,56.65606,2.27638),(.89398,56.5878,2.53673),(.9151,56.66136,2.30369),(.93485,56.61381,2.24103),(.95568,56.60797,2.23652),(1.14098,56.03082,1.86761),(1.17656,55.98737,2.0353),(1.21171,56.11219,1.98044),(.71646,55.93062,2.53331),(.73393,56.01215,2.61624),(.79292,55.95273,2.6334),(.84646,55.84476,2.41782),(.84512,55.88804,2.49942),(.94399,55.85533,2.47389),(.98159,56.60714,2.23747),(.63236,56.23289,2.61595),(.64656,56.23481,2.57264),(.63806,56.37318,2.59926),(.6484,56.22147,2.44613),(.6282,56.35721,2.45912),(.64724,56.36694,2.53779),(1.05496,55.79083,1.53108),(1.01551,55.73923,1.4521),(.99282,55.75505,1.508),(.6215,55.83932,1.93589),(.63797,55.85286,1.80984),(.58876,55.9403,1.82966),(.64794,55.83848,2.14029),(.68384,55.85326,2.33033),(.83117,55.7726,2.16827),(.72132,56.01222,2.67701),(.81042,55.91482,2.59919),(.83357,55.88699,2.54574),(.60284,56.47094,2.66763),(.61289,56.40014,2.74519),(.617,56.36679,2.64012),(.63691,56.71043,2.66486),(.69359,56.72713,2.735),(.63257,56.6477,2.76849),(.50638,56.18694,1.54116),(.52209,56.1797,1.5843),(.52931,56.263,1.55932),(.46859,56.69479,2.54115),(.48151,56.63482,2.52517),(.44858,56.65948,2.57546),(.41254,56.74069,2.58359),(.40004,56.76423,2.57252),(.43786,56.74646,2.54163),(.45178,56.72118,2.54549),(1.24533,56.63431,1.99321),(1.22222,56.62596,1.9437),(1.25759,56.55441,2.04083),(1.23371,56.56834,2.13207),(1.22668,56.58167,2.07118),(.4743,56.6812,1.49802),(.50748,56.63846,1.51477),(.45712,56.76626,1.67756),(1.07796,55.78079,1.65039),(1.08909,55.77593,1.70832),(1.10798,55.95124,1.71497),(1.24196,56.63627,1.99469),(1.19633,56.60833,1.97196),(1.22082,56.62872,1.94629),(1.18557,56.57066,2.37956),(1.22842,56.57987,2.36391),(1.24041,56.57619,2.45683),(1.16496,56.57485,2.50713),(1.1319,56.55763,2.52315),(1.11639,56.56569,2.4246),(.71068,55.82786,1.53642),(.71493,55.81066,1.53992),(.71613,55.81189,1.53784),(.70871,55.82616,1.53888),(.69564,55.82801,1.55616),(.70318,55.8324,1.54271),(.6521,56.04261,1.5152),(.64945,55.84651,1.6959),(.6808,55.79038,1.57387),(.62998,56.03541,1.57714),(1.06,56.65135,1.77632),(1.05597,56.65071,1.77495),(1.06001,56.64021,1.75947),(.90117,56.70456,1.9803),(.90495,56.67988,2.11273),(.9116,55.70196,1.37836),(.89066,55.85085,1.39562),(.78082,55.85012,1.474),(.84099,56.48224,2.64979),(.84181,56.40376,2.617),(.83574,56.48408,2.65812),(.85238,56.54959,2.68012),(.99595,56.5311,2.61128),(1.00685,56.5281,2.58549),(.9994,56.53142,2.58293),(.82799,56.65906,2.69895),(.91271,56.57525,2.6659),(.97662,56.50004,2.56178),(.99582,56.47116,2.56294),(.97825,56.55549,2.58622),(.95556,56.57658,2.60855),(.55111,56.2667,1.54786),(.53476,56.64552,1.51891),(.48417,56.77644,1.67686),(.41392,56.74897,1.86831),(.39093,56.74247,1.86786),(.41959,56.74775,1.7297),(.39098,56.73767,2.07999),(.41556,56.75272,2.06951),(.43581,56.75233,2.15248),(.45299,56.74947,2.27049),(.46585,56.76436,2.38285),(.44021,56.7593,2.41051),(.44255,56.75359,2.52651),(.43808,56.75675,2.46599),(.46543,56.76214,2.44393),(.46881,56.73466,2.51299),(.48296,56.71199,2.52293),(.50581,56.67323,2.51565),(.5012,56.62068,2.52454),(.49718,56.53078,2.4875),(.52324,56.51724,2.47882),(.53768,56.38241,2.42474),(.56261,56.18162,2.22315),(.57983,56.1649,2.21764),(.57725,56.08348,2.00704),(.58219,56.37517,1.44643),(.53651,56.52539,1.47248),(.54041,56.43294,1.50793),(.5429,56.39581,1.56284),(.58355,56.38194,1.51618),(.58662,56.54761,1.42054),(.57188,56.104,1.85221),(.62832,56.04999,1.99517),(.56174,56.78456,2.33399),(.55463,56.77876,2.33262),(.50283,56.83607,2.26092),(.53615,56.76852,2.38229),(.54194,56.77437,2.38618),(.51865,56.76733,2.44124),(.51453,56.76057,2.44021),(.51289,56.74985,2.50658),(.55825,56.78233,2.34506),(.5642,56.77878,2.395),(.66326,56.79682,2.01335),(.49008,56.88656,1.85805),(.62404,56.82459,1.84296),(.58822,56.8191,2.02275),(.71939,56.72335,2.61403),(.84427,56.67547,2.66825),(.69562,56.74934,2.68489),(.55674,56.58554,2.49681),(.55268,56.57247,2.53537),(.51905,56.73492,2.51275),(.53052,56.68854,2.51874),(.55205,56.67755,2.53223),(.56422,56.67374,2.51466),(.59053,56.51298,2.47979),(.52015,56.73398,2.54804),(.51501,56.74802,2.5282),(.52593,56.73462,2.54874),(.53821,56.65631,2.55025),(.56023,56.56924,2.53833),(.60125,56.33934,2.37969),(.60123,56.34695,2.38717),(.64718,56.19523,2.36517),(.56855,56.49518,2.50202),(.58539,56.68119,1.52042),(.507,56.81135,1.67157),(.59889,56.77203,2.51177),(.54892,56.77567,2.44807),(.66859,56.08573,2.4325),(.67701,56.07612,2.35276),(.59169,56.74206,2.51872),(.58983,56.6492,2.51296),(.56721,56.75619,2.50731),(.52169,56.74775,2.53233),(.53065,56.73492,2.53331),(.53289,56.76446,2.47416),(.54384,56.74353,2.51467),(.64772,56.099,2.59104),(.65507,56.09645,2.54522),(.60476,56.51669,2.4885),(.62753,56.48133,2.52838),(.65863,56.75708,2.58623),(.88735,56.68903,1.54072),(.78533,56.59591,1.40232),(.8933,56.62883,1.46909),(1.12282,56.35499,1.66351),(1.08037,56.58839,1.72413),(1.07302,56.58893,1.71716),(1.02656,56.6378,1.9576),(.98702,56.63032,2.08972),(.9339,56.71121,1.77926),(.91081,56.72971,1.62634),(.92238,56.71578,1.63687),(.95641,56.65917,1.55167),(.91832,56.59726,2.54615),(1.00048,56.61166,2.27807),(.97973,56.56582,2.50664),(1.01387,56.61732,2.23432),(.99085,56.62868,2.3305),(.96434,56.65224,2.37334),(.90756,56.68445,2.29466),(.9577,56.65894,2.34286),(.90904,56.65525,2.18416),(.90653,56.63611,2.25898),(.89863,56.67372,2.20887),(1.18552,56.31885,1.86132),(1.19837,56.47872,1.92181),(1.17213,56.50179,1.87264),(1.16346,56.59876,1.89033),(1.19638,56.57437,2.47072),(1.21271,56.58273,2.45672),(1.21558,56.58755,2.46429),(1.17985,56.57261,2.49726),(1.16928,56.58248,2.51872),(1.05392,56.5958,2.5639),(1.07224,56.59081,2.54904),(1.05685,56.59747,2.57078),(1.08165,56.55677,2.53178),(1.07408,56.55341,2.58195),(1.07376,56.58051,2.59727),(1.07218,56.58299,2.44017),(1.07375,56.57989,2.54495),(1.06988,56.58995,2.53955),(1.17557,56.56792,2.31559),(1.23685,56.56942,2.2689),(1.06686,56.54675,2.62431),(1.085,56.39439,2.54496),(1.20706,56.59736,2.03023),(1.18912,56.60466,1.97331),(1.19533,56.541,2.57971),(1.17687,56.39566,2.50426),(1.18679,56.56517,2.60135),(1.2155,56.56567,2.5229),(1.24161,56.57926,2.52177),(1.23394,56.54739,2.54045),(1.10432,56.56541,1.76846),(1.16767,56.59358,1.88733),(1.2652,56.40435,2.37652),(1.22307,56.41029,2.48041),(1.24046,56.5294,2.51062),(1.18011,56.05914,2.38135),(1.21836,56.22745,2.42346),(1.08112,56.53741,2.61633),(1.13509,56.54299,2.60598),(1.24973,56.03812,2.17028),(1.21017,55.95908,2.16219),(1.24987,55.91376,2.22158),(.9655,55.93127,2.47248),(.864,55.97793,2.51879),(.97626,55.97266,2.47151),(1.09604,55.98704,2.40833),(1.11508,56.05362,2.42539),(.7853,56.01897,2.6769),(.71213,56.13504,2.71842),(.77483,56.12362,2.65824),(.83122,55.98573,2.5378),(.85933,55.9229,2.51943),(.81873,56.00692,2.58703),(.83605,56.10704,2.57486),(.97352,56.53141,2.47765),(.86104,56.51616,2.61815),(.88402,56.55357,2.52168),(.8711,56.46481,2.58962),(1.07399,56.25867,2.49451),(1.22665,56.04351,2.25834),(1.062,55.90413,2.3877),(1.01988,55.81863,2.37263),(1.27165,56.10512,2.10427),(1.24859,56.04449,2.09963),(1.11805,55.91541,1.87472),(1.07426,55.77803,1.88596),(1.16985,56.34152,1.79241),(1.12156,56.17397,1.62926),(1.10844,56.056,1.59748),(1.05863,56.06947,1.51608),(1.10199,55.99799,1.58197),(.99642,56.63488,1.5788),(.62155,56.76545,2.48736),(1.13762,56.5665,2.40747),(1.17841,56.57002,2.38352),(.78612,56.7934,1.80689),(.82436,56.73949,2.0009),(.76159,56.78647,1.63328),(.90786,56.7332,1.62656),(.73987,56.3794,1.34872),(.69219,56.57985,1.39856),(.69875,56.0554,1.43382),(.66156,55.97535,2.35949),(.6603,56.09482,2.51241),(.64348,56.06399,2.18771),(.59729,55.94329,1.97434),(.54261,56.1769,1.57929),(.62286,55.97569,1.71267),(.63914,55.98394,2.45042),(.69437,55.87588,2.45517),(.65377,56.23088,2.52551),(.71865,55.81672,1.54723),(.7142,55.83467,1.53867),(.70947,55.83908,1.54245),(.61648,56.35598,1.40814),(.46353,56.8839,2.04927),(.89968,56.10296,1.3704),(.81902,56.07324,1.3666),(.98083,56.09116,1.4366),(.96682,55.85464,1.43749),(.99613,55.84196,1.47249),(1.10641,56.58245,2.3505),(1.08927,56.56857,2.43304),(1.16373,56.57289,2.22807),(1.07964,56.55718,2.52425),(1.05298,56.64126,1.75716),(1.14141,55.86256,2.08992),(1.21104,56.53431,2.55935),(1.19861,56.56684,2.53592),(.97738,56.57538,2.64155),(1.01567,56.60672,2.67104),(.87549,56.07827,2.54919),(.79317,56.51654,2.71086),(.73834,56.55839,2.74476),(.63011,56.79371,1.65357),(1.31036,55.99208,2.25952),(1.24508,56.56352,2.49692),(1.25303,56.50356,2.43293),(1.132,56.56726,2.41518),(1.09489,56.56579,2.42912),(1.05372,56.59669,2.57008),(1.06964,56.59279,2.60444),(1.2001,56.57641,2.47666),(1.13278,56.55936,2.53035),(1.28455,56.40422,2.11172),(1.29676,56.23436,2.11599),(1.29685,56.39395,2.15024),(1.02531,56.63218,2.31261),(.94938,56.63216,2.16018),(.97821,56.62389,2.16508),(.88406,56.69314,2.22729),(1.00432,56.62185,2.16471),(.95685,56.64803,2.36204),(.95635,56.58815,2.53233),(.96317,56.69302,1.77442),(.96276,56.67976,1.67752),(1.00244,56.66062,1.7001),(.93038,56.64093,2.16321),(.93652,56.65191,2.09497),(.88183,56.70748,1.53739),(1.04222,56.65384,1.78302),(.93028,56.69486,1.97032),(.91082,56.6687,2.09942),(.6074,56.70425,1.50805),(.67153,56.70776,1.50541),(.63898,56.56,2.65765),(.59448,56.55909,2.69926),(.47311,56.74444,2.49228),(.63586,56.47471,2.6293),(.54582,56.65703,2.55236),(.61701,56.60829,2.53473),(.61582,56.34963,2.40677),(.58303,56.79143,2.32961),(.57651,56.48976,2.50594),(.54627,56.63,2.51175),(.46956,56.88694,2.04863),(.47767,56.86999,1.86045),(.63991,56.18241,1.43609),(.66508,56.18445,1.41173),(.44522,56.7507,1.74445),(.59299,56.19775,1.51103),(.54921,56.30526,1.57359),(.5595,56.08966,2.0169),(.55953,56.10994,1.86808),(.51613,56.39594,2.42907),(.40501,56.7413,2.1694),(.42907,56.73478,2.28433),(.51559,56.53834,1.48534),(.52544,56.41611,1.56721),(.53989,56.1604,1.70867),(.55359,56.15391,1.69894),(.91312,56.58207,2.62701),(.91126,56.57085,2.65889),(.97127,56.57132,2.63524),(.99599,56.53268,2.61211),(1.06377,56.64021,1.76215),(1.08326,56.58715,1.72793),(.71581,55.80682,1.54958),(.70707,55.77244,1.5538),(.69758,55.8266,1.55473),(.69353,55.80433,1.56247),(.70445,55.82791,1.54293),(1.08953,56.54944,2.52471),(1.17632,56.57065,2.49154),(1.08784,56.61778,1.93676),(1.089,56.61641,1.93015),(1.29729,56.09894,2.19874),(1.28363,56.22926,2.23868),(.41568,56.7682,2.40119),(1.25441,56.60185,2.06119),(.40276,56.77694,2.55124),(.41373,56.78377,2.47447),(.48639,56.46526,1.47927),(.48973,56.42215,1.54708),(.96806,55.72031,1.40747),(.92952,55.72525,1.4811),(1.06646,55.78581,1.59068),(.87376,55.78132,1.5842),(.64144,56.75303,2.66502),(.62273,56.52392,2.75752),(.61795,56.21724,2.6848),(.8549,55.79852,1.67309),(.83802,55.8107,2.32042),(.64088,55.99841,2.49786),(.89082,56.68409,2.23034),(1.2245,56.61442,2.01684),(1.28097,56.53114,2.12225),(.95776,56.67791,1.96947),(1.03434,56.63827,1.95699),(1.06653,56.614,2.28652),(1.02747,56.61696,2.22832),(1.15556,56.57886,2.16407),(1.03477,56.62272,2.36089),(1.06803,56.58473,2.44284),(1.28624,56.40762,2.36276),(1.27787,56.50449,2.42006),(1.30752,56.54226,2.46509),(1.34735,56.39109,2.33645),(1.29592,56.22988,2.26016),(1.24761,56.57859,2.44522),(1.28044,56.40677,2.2878),(1.29258,56.40875,2.30995),(1.26936,56.23026,2.31978),(1.2912,56.23075,2.30628),(1.33594,55.98017,2.27015),(.97127,56.40725,2.56953),(1.00228,56.4586,2.56156),(.03913,55.69097,3.17502),(.03929,55.63627,3.207),(.04648,55.76432,3.11958),(.04359,55.76384,3.11912),(.04662,55.76701,3.11066),(.28762,55.65761,3.11871),(.27528,55.65422,3.11852),(.27147,55.70947,3.09944),(.57881,55.79498,2.75295),(.58794,55.79473,2.75819),(.58183,55.79451,2.75702),(.80568,55.41544,2.75826),(.79491,55.46784,2.7708),(.54549,55.42447,2.8288),(.52611,55.42498,2.81307),(.66564,55.60251,2.83375),(.63448,55.55411,2.80076),(.69476,55.72693,2.88183),(.70391,55.66742,2.89801),(.54365,55.72735,2.78762),(.53273,55.72586,2.77639),(.66756,55.66597,2.85937),(.67296,55.65735,2.83266),(.67876,55.72617,2.83373),(.69693,55.48298,2.71458),(.6279,55.53559,2.8546),(.69308,55.7282,2.81326),(.52039,55.66406,2.78399),(.65819,55.60211,2.8566),(.73325,55.52724,2.90287),(.54635,55.3705,2.82528),(.52794,55.37101,2.80517),(.80978,55.46732,2.81195),(.80314,55.4681,2.83307),(.78918,55.52439,2.83854),(.77066,55.4716,2.87821),(.75436,55.47201,2.88869),(.74631,55.5261,2.89239),(.74239,55.47236,2.90149),(.5596,55.4739,2.65621),(.51855,55.47887,2.69196),(.60573,55.54113,2.82038),(.62176,55.54144,2.83266),(.71253,55.79025,2.83656),(.7131,55.79114,2.83076),(.56968,55.79082,2.75667),(.58288,55.79498,2.73618),(.55824,55.76434,2.77804),(.56259,55.7298,2.79152),(.57306,55.76387,2.77964),(.53314,55.73206,2.71419),(.55341,55.7623,2.72127),(.5466,55.76405,2.72719),(.72473,55.75436,2.87542),(.73091,55.75785,2.87457),(.59973,55.78796,2.73224),(.59519,55.79429,2.73887),(.58587,55.79032,2.76581),(.57944,55.77694,2.77284),(.55616,55.78043,2.75109),(.5559,55.78057,2.7469),(.56789,55.79163,2.7485),(.60145,55.77197,2.74165),(.60138,55.77144,2.7547),(.72692,55.77322,2.86336),(.73206,55.77381,2.86141),(.74141,55.78413,2.83669),(.59713,55.55329,3.10617),(.59425,55.48671,3.12644),(.57953,55.55376,3.12136),(.44908,55.88036,2.91932),(.52086,55.89826,2.96693),(.51659,55.89737,2.97194),(.51206,55.91644,2.95423),(.48886,55.87431,2.89826),(.47384,55.8357,2.90802),(.5103,55.73284,2.92794),(.49131,55.73125,2.91919),(.53478,55.74299,2.95329),(.52349,55.73908,2.94188),(.53459,55.67144,2.9374),(.55429,55.70058,3.08086),(.54291,55.70194,3.09446),(.49225,55.75914,3.07365),(.50393,55.69811,3.10218),(.4137,55.61067,2.95434),(.4182,55.61682,2.98558),(.44736,55.65433,2.90915),(.46785,55.90393,2.90221),(.46119,55.87402,2.90083),(.47801,55.90406,2.89722),(.44117,55.78553,2.94472),(.43976,55.7877,2.95821),(.48622,55.83757,2.90861),(.4965,55.92148,2.9256),(.47992,55.91718,2.91472),(.4655,55.9088,2.94303),(.47871,55.92053,2.9378),(.47035,55.91097,2.95158),(.47517,55.87434,2.89728),(.52833,55.86657,2.99316),(.5329,55.86566,2.98445),(.43061,55.37653,2.88429),(.76066,55.52071,2.48168),(.78849,55.51924,2.49009),(.80003,55.57838,2.52527),(.87219,55.55785,2.60119),(.87927,55.49352,2.59687),(.85487,55.56029,2.61409),(.80726,55.6131,2.5453),(.85395,55.63894,2.58223),(.86057,55.63662,2.59713),(.82723,55.65369,2.5892),(.82206,55.66141,2.5972),(.66449,55.42746,2.16216),(.82657,55.70313,2.36232),(.83431,55.70134,2.33456),(.83258,55.73712,2.32506),(.71735,55.64577,2.13414),(.6981,55.57406,2.1183),(.72775,55.57369,2.12622),(.64864,55.53985,2.14614),(.64323,55.50447,2.22912),(.66171,55.50352,2.26916),(.85436,55.74121,2.39471),(.87201,55.74328,2.3961),(.87257,55.71038,2.4118),(.92447,55.51695,2.22037),(.94051,55.52403,2.21921),(.92577,55.52124,2.22716),(.91025,55.74312,2.30232),(.93195,55.70666,2.31412),(.93157,55.74497,2.31608),(.87959,55.51621,2.22562),(.84572,55.73607,2.12079),(.86666,55.7366,2.11831),(.87754,55.63329,2.09341),(.85084,55.63139,2.08901),(.83442,55.58398,2.09952),(.73691,55.4735,2.31181),(.76785,55.52342,2.32119),(.77844,55.52571,2.33918),(.83996,55.53336,2.3932),(.79457,55.44594,2.33834),(.75164,55.48691,2.09973),(.86978,55.53175,2.11239),(.86349,55.587,2.30373),(.84937,55.59182,2.32859),(.84689,55.551,2.30228),(.7871,55.53226,2.12158),(.92783,55.5489,2.2247),(.79545,55.53305,2.11982),(.79764,55.5565,2.34581),(.8858,55.80671,2.21977),(.72589,55.76602,2.30144),(.74053,55.71893,2.28734),(.84347,55.73704,2.30076),(.91875,55.77498,2.16291),(.92426,55.77588,2.17461),(.90214,55.80358,2.18894),(.92652,55.77474,2.19875),(.68409,55.80103,2.27616),(.66163,55.80333,2.24844),(.67424,55.82984,2.24246),(.66167,55.8027,2.21974),(.66266,55.80275,2.21185),(.67459,55.82933,2.22077),(.69661,55.79952,2.28327),(.95153,55.59888,2.36945),(.93466,55.60506,2.40188),(.75844,55.58859,2.30509),(.76644,55.56379,2.31079),(.7362,55.58279,2.31413),(.74547,55.55358,2.31681),(.8397,55.56983,2.40252),(.81278,55.57961,2.37166),(.8315,55.59613,2.35199),(.81292,55.56916,2.34298),(.85399,55.55064,2.27699),(.96139,55.56952,2.18173),(.95229,55.52437,2.15963),(.94098,55.70902,2.33612),(.82597,55.67092,2.39086),(.84432,55.67367,2.40893),(.84867,55.70763,2.40549),(.87019,55.67657,2.41988),(.78349,55.63591,1.80068),(.97477,55.46492,1.88596),(.97903,55.42379,1.8895),(.98155,55.65401,1.89113),(.98833,55.63348,1.87968),(.98629,55.65143,1.90288),(.8544,55.55784,2.0184),(.84263,55.55609,2.00742),(.88776,55.60002,2.02091),(.89904,55.65193,1.99143),(.89855,55.64902,1.9839),(.93589,55.68183,1.97687),(.86186,55.59557,1.99056),(.80556,55.42466,1.97341),(.89818,55.5113,1.79657),(.91694,55.56541,1.81558),(1.03136,55.42169,1.92503),(.93042,55.61647,1.90101),(.92428,55.61729,1.89561),(.92665,55.63984,1.90274),(.90358,55.4552,1.86215),(.90963,55.45318,1.86826),(.97991,55.55685,1.98025),(.98833,55.5564,1.9939),(.98042,55.58951,1.99305),(.92955,55.6793,1.89249),(.9197,55.66918,1.9717),(.8421,55.44262,1.92864),(.86918,55.60073,1.97614),(.8804,55.6039,1.96651),(.89458,55.63439,1.96557),(.82563,55.44919,1.90149),(.92888,55.41817,1.87977),(.92663,55.41617,1.90145),(.98099,55.41734,1.90887),(.95299,55.66831,1.92019),(.9421,55.66577,1.91778),(.95117,55.67617,1.91655),(.77211,55.66903,1.81531),(.7719,55.66939,1.81064),(.84633,55.40737,1.766),(.83948,55.45861,1.79553),(.82543,55.45837,1.7704),(.97338,55.67825,1.91046),(.96965,55.67597,1.91736),(.96365,55.68231,1.91524),(1.05383,55.35399,1.93346),(1.1013,55.41256,1.57428),(1.11144,55.41399,1.60136),(1.09178,55.46182,1.58975),(.7987,55.38044,1.62536),(.79354,55.43328,1.63496),(.93171,55.44783,1.60695),(.94034,55.4101,1.59149),(.97641,55.41337,1.61885),(1.09614,55.5092,1.57052),(1.09177,55.46005,1.56875),(1.09294,55.50774,1.5504),(.86715,55.60342,1.57535),(.8853,55.56896,1.56696),(.88674,55.60359,1.57655),(.80727,55.60248,1.59054),(1.06103,55.61787,1.58089),(1.05695,55.6184,1.56732),(1.04265,55.64157,1.59441),(.96,55.62954,1.6195),(.95081,55.6054,1.60569),(.94894,55.62927,1.61145),(1.0183,55.65008,1.68797),(.85686,55.63353,1.66111),(.89597,55.63075,1.58718),(1.01261,55.67221,1.62676),(1.01276,55.67487,1.62022),(1.0095,55.675,1.61378),(.89189,55.68134,1.5974),(.84942,55.65619,1.59803),(.84214,55.65609,1.60808),(.89772,55.69246,1.63176),(.90611,55.69213,1.63161),(.891,55.69306,1.60399),(.89903,55.69216,1.603),(.8835,55.69352,1.60918),(.88633,55.69363,1.60721),(.87953,55.69336,1.61939),(.97792,55.3995,1.50098),(.94155,55.40994,1.59043),(.93725,55.40929,1.58502),(.9432,55.67606,1.6356),(.95187,55.67548,1.63782),(.91996,55.68859,1.62848),(.92607,55.68038,1.62611),(.92109,55.66294,1.62863),(.9116,55.57096,1.57757),(.91056,55.53285,1.56454),(.91595,55.53231,1.5707),(.95585,55.68938,1.6623),(1.06433,55.55154,1.6474),(1.07125,55.55347,1.65544),(1.062,55.58813,1.60495),(1.08555,55.55563,1.59173),(1.07903,55.555,1.59759),(1.07001,55.5899,1.5994),(.95195,55.67181,1.63012),(.91709,55.69201,1.62457),(.9779,55.41352,1.61759),(.95121,55.6492,1.59139),(.95452,55.62931,1.57505),(.96174,55.45069,1.52576),(.94332,55.45023,1.55614),(.9288,55.4912,1.55432),(.92378,55.66204,1.60567),(.91404,55.60293,1.61387),(.66077,55.32251,2.88203),(.60435,55.30479,2.84995),(.82508,55.33551,2.81331),(.50094,55.37188,2.71908),(.51369,55.31815,2.69151),(.50959,55.37175,2.69642),(.80641,55.34811,2.44618),(.77005,55.34867,2.43506),(.77194,55.33101,2.42829),(.65098,55.34913,2.40616),(.6352,55.34863,2.42179),(.62735,55.30248,2.41568),(.73771,55.33065,2.59375),(.686,55.3257,2.5774),(.69095,55.34538,2.58185),(.73901,55.32256,2.41664),(.76957,55.30079,2.42453),(.66853,55.29784,2.12862),(.84728,55.3713,2.35853),(.87063,55.37415,2.37323),(.88732,55.29692,2.36912),(.79324,55.28894,2.05652),(.84277,55.29736,2.06931),(.83867,55.37474,2.08606),(.97796,55.33752,2.0378),(1.01306,55.29839,2.03531),(.98524,55.29188,2.03545),(.92779,55.3319,2.01868),(.84689,55.28719,1.99651),(.85663,55.32376,1.99638),(1.09485,55.411,1.55492),(1.10285,55.41194,1.68497),(1.11276,55.41326,1.66654),(1.11615,55.36275,1.67672),(1.02385,55.33274,1.70295),(1.01967,55.40229,1.70452),(1.05432,55.40639,1.70792),(1.12543,55.37557,1.66129),(.59244,55.38394,2.40203),(.61431,55.37156,2.34857),(.46437,55.43541,2.72633),(.43575,55.617,2.66152),(.45425,55.62142,2.63613),(.67847,55.50277,1.79165),(.56442,55.72177,1.82447),(.57693,55.65945,2.0185),(.47276,55.62584,2.61074),(.00416,55.76177,1.73019),(.5489,56.04547,2.26199),(.49861,55.92067,2.24138),(.04328,55.9499,2.73472),(.10514,55.9163,2.76221),(.1046,55.88299,2.62083),(.55359,56.38874,2.68318),(.58028,56.07025,2.55703),(.56992,56.0806,2.65321),(.41092,56.37265,3.16964),(.04647,55.95537,3.17701),(.11401,55.92511,3.00945),(.23016,57.16336,2.87761),(.2433,57.15672,2.84959),(.25294,57.11405,2.83534),(.62955,55.76527,1.50799),(.61777,55.76329,1.50768),(.62094,55.78368,1.5013),(.64283,55.76503,1.49406),(.63135,55.79034,1.48824),(.63726,55.78535,1.48373),(.47785,56.59253,1.33871),(.51516,56.37554,1.32505),(.76824,56.05535,1.2764),(1.18876,56.62844,2.22985),(1.09289,56.60415,2.66347),(.56783,56.83053,2.73804),(.62757,56.80227,2.58066),(.28996,57.33264,2.80624),(1.06765,56.05119,1.4556),(1.12574,55.89802,1.69388),(1.14786,56.3746,1.63052),(1.20662,56.35943,1.78501),(1.19919,56.13835,1.86769),(1.13308,55.83377,2.40954),(1.19338,55.94573,2.45038),(1.52517,56.50214,2.40108),(1.60602,56.06831,2.31125),(.85362,55.5282,2.72224),(.97181,56.33821,2.67778),(.90496,56.31134,2.67637),(.78873,55.76017,2.78568),(.82234,55.53809,2.81719),(.78374,55.48599,2.92365),(.78628,55.57359,2.92007),(.66743,56.60565,2.93015),(.73594,56.55825,2.88971),(.70138,55.48415,2.99962),(.05317,55.59499,3.28609),(.0546,55.73498,3.20747),(.38453,55.58775,3.1689),(.25875,55.89611,3.13514),(.5126,55.88858,3.05472),(.47269,55.94272,3.0438),(.24002,55.81696,3.13231),(.0059,55.71355,3.22857),(.0059,55.55616,3.28866),(.35082,56.72414,3.22062),(.3848,56.77655,3.07688),(.46216,56.8838,2.90365),(.22777,56.96884,3.1977),(.27821,57.24043,2.94993),(.25644,57.15007,2.82151),(1.56252,56.35661,2.31643),(1.46264,56.42296,2.3051),(1.41839,56.03695,2.35059),(1.4262,56.10204,2.41137),(1.32188,56.09392,2.44747),(1.13818,56.0339,2.54714),(1.03469,55.5934,2.16801),(1.08218,55.69876,2.13225),(.9969,55.47183,2.32164),(.97324,55.48253,2.38211),(1.48117,56.19436,2.26776),(1.36521,56.23833,2.17411),(1.29486,56.57268,2.6461),(1.57712,56.42535,2.32002),(1.45215,56.21498,2.43971),(1.5575,56.28641,2.4007),(1.54951,56.52517,2.38241),(1.5515,56.52084,2.33063),(1.57216,56.16805,2.36579),(1.5888,56.18873,2.37828),(1.56801,56.16882,2.37137),(1.58303,56.17852,2.30762),(1.60327,56.19709,2.31866),(1.58552,56.17722,2.31313),(1.60553,56.06986,2.33219),(1.23846,56.58586,2.72916),(.85172,56.76995,2.25599),(.95031,56.71093,2.46855),(.96831,56.72775,2.25316),(1.28956,56.62751,2.30963),(1.35094,56.68409,2.33663),(1.34474,56.66526,2.397),(1.548,56.53197,2.32978),(1.42777,56.69157,2.40889),(1.47806,56.65432,2.34313),(1.08652,56.63061,2.7509),(1.08637,56.59991,2.73277),(1.09557,56.60368,2.67248),(1.06475,56.64979,2.71914),(1.20591,56.63279,2.65588),(1.16031,56.60661,2.67031),(1.29877,56.62624,2.5897),(1.30828,56.62967,2.56019),(1.34498,56.63836,2.45831),(1.42206,56.66348,2.44775),(1.45808,56.79796,2.30765),(1.41231,56.80156,2.08674),(1.37646,56.71838,2.25222),(1.37582,56.71395,2.31264),(1.34312,56.68726,2.17955),(1.4282,56.79514,2.17821),(1.57701,56.23077,2.39369),(1.58579,56.22805,2.38805),(1.56159,56.28675,2.39527),(1.33383,56.09197,2.16078),(1.22921,56.52516,1.9161),(1.2262,56.33382,1.86777),(.99469,56.71661,1.75207),(.97539,56.6977,1.99058),(1.01199,56.6918,2.0593),(.93935,56.73667,2.10959),(1.00656,56.69072,2.06186),(.94964,56.70018,2.08098),(.8909,56.7774,1.596),(.92012,56.71193,1.99817),(.9549,56.70584,1.99134),(.95026,56.73476,1.75618),(.93558,56.71023,2.03222),(.96446,56.70144,2.03085),(.95936,56.70305,2.02171),(.99357,56.69084,2.02298),(1.01642,56.43586,1.46556),(.60977,56.62902,1.31226),(.34786,56.70099,2.79912),(.24745,57.13355,2.89185),(.29819,56.95729,2.82418),(.31059,56.96901,2.81371),(.54727,56.51841,2.71645),(.52897,56.51826,2.67122),(.43466,56.74043,2.67385),(.56338,56.08247,2.69267),(.55419,56.08538,2.74773),(.48767,56.60642,2.87568),(.40682,56.41044,2.84482),(.3736,56.5641,2.76448),(.51914,56.10379,2.87517),(.39522,56.8242,2.64682),(.50052,56.55826,2.62295),(.47336,56.86924,2.42887),(.38572,56.82229,2.64194),(.39342,56.80538,2.64959),(.45527,56.53392,2.63927),(.44487,56.6178,2.68231),(.65665,56.8234,2.33149),(.54336,56.84864,2.3204),(.56552,56.84047,2.38516),(.39371,56.93266,2.08691),(.45074,56.88222,2.34223),(.57589,56.18132,1.33018),(.54444,56.17903,1.35935),(.41138,56.91677,1.86004),(.47261,56.45473,1.47174),(.47572,56.41273,1.53769),(.48598,56.26653,1.52042),(.39054,56.78255,2.59346),(.47508,56.56075,1.45005),(.46773,56.55939,1.42884),(.90115,56.52352,2.78504),(.90393,56.5362,2.74679),(.97255,56.52403,2.75647),(.95448,55.65575,1.32723),(1.06433,56.70952,1.76198),(.01968,55.82167,1.73294),(.0216,55.9397,2.42683),(.03532,55.79999,1.94471),(.0348,55.79283,1.73199),(.03579,55.99845,2.83094),(.02609,55.81434,1.73244),(.64053,55.63127,1.68272),(.80223,55.39545,1.41845),(.61421,55.75207,1.51056),(.61143,55.75102,1.51242),(.63041,55.77571,1.48404),(.6401,55.76784,1.48523),(.5249,55.70327,1.92006),(.48808,55.80689,1.8289),(.62209,55.7022,1.49936),(.02867,55.78416,1.72313),(.02084,55.81023,1.72373),(.34343,55.82735,1.81293),(.34636,55.82373,1.80641),(.20575,55.78553,1.74088),(.33838,55.76167,2.52788),(.25593,55.7557,2.51036),(0,55.52465,3.00778),(.00358,56.01012,2.8756),(.00852,56.01014,2.87081),(.00357,55.52069,3.00081),(.04183,55.96982,3.24391),(.03139,55.97381,3.24738),(.00564,55.9277,3.22855),(.04816,55.91757,3.20443),(.00246,55.97824,3.25081),(.00284,55.97043,3.20776),(.04152,55.97641,3.23911),(.32826,55.82129,3.10893),(.12076,55.82727,3.16457),(.04849,55.845,3.19798),(.74526,55.26971,2.31471),(.806,55.27586,2.34334),(.8072,55.26557,2.38165),(.08356,55.37201,3.36112),(.04017,55.33854,3.33934),(.06607,55.34681,3.34295),(.34404,55.33164,3.22681),(.48766,55.32152,3.1044),(.45193,55.29994,3.12208),(.00166,55.27286,3.21098),(0,55.28719,3.19441),(0,55.29368,3.13008),(.42719,55.2972,3.01171),(.41537,55.27228,3.05126),(.39834,55.28637,2.9611),(.59898,55.29067,2.88507),(.60395,55.30094,2.85262),(.48133,55.2942,2.80359),(.49928,55.28074,2.81439),(1.1058,56.59537,2.66398),(1.23978,56.62357,2.59816),(1.21732,56.61859,2.4936),(1.28942,56.62441,2.19238),(1.45782,56.84214,2.23488),(1.33877,56.70229,2.08472),(.95604,55.32393,2.35752),(1.01368,55.34991,2.14515),(1.12015,55.36104,1.67873),(1.13927,55.38491,1.68698),(1.13744,55.37756,1.70762),(.76765,55.28675,1.73178),(.74498,55.32858,1.72982),(.79446,55.28187,2.05104),(1.12176,55.48465,1.55162),(1.09098,55.39332,1.51759),(1.12713,55.50139,1.59669),(1.12746,55.51544,1.63859),(1.13726,55.40366,1.62898),(.9126,55.40528,1.38966),(.94489,55.37303,1.41959),(.90646,55.3557,1.47762),(.85877,55.34825,1.46759),(.90633,55.4891,1.34051),(.75221,55.3675,1.5),(.98125,55.32047,1.69656),(.96076,55.28541,1.71664),(1.10111,55.36718,1.84822),(1.06467,55.30417,1.84068),(1.05704,55.30065,1.80944),(.72659,55.2719,2.00088),(.69843,55.3244,2.00294),(.6749,55.27518,2.27167),(.69701,55.27341,2.38199),(.66695,55.27007,2.32909),(.62476,55.28858,2.40798),(.57186,55.31252,2.47892),(.5744,55.32013,2.57105),(.50627,55.30204,2.71302),(.12634,55.27502,3.03709),(.25189,55.29231,2.96112),(.24261,55.26974,3.01803),(.22577,55.26268,3.05434),(.66203,55.35104,3.01342),(.6643,55.36371,3.05683),(.8799,55.36714,2.66212),(.90021,55.31453,2.5079),(.91448,55.36166,2.51391),(.89965,55.32048,2.51825),(.3627,55.28505,3.04684),(.35775,55.26514,2.97866),(.37899,55.33501,3.2141),(.38219,55.37656,3.23849),(.35234,55.37518,3.25766),(.20709,55.32993,3.26999),(.24318,55.28174,3.22319),(.22772,55.2657,3.17875),(.2097,55.28191,3.18011),(.81355,55.33529,2.83491),(.80512,55.34988,2.86215),(.80198,55.33792,2.85051),(.82815,55.32334,2.78505),(.81138,55.31665,2.73933),(.81319,55.30201,2.73849),(.59362,55.28903,2.62428),(.8087,55.27965,1.70642),(.8401,55.27693,1.70409),(.82854,55.30986,1.6542),(.63498,55.29513,2.91284),(.6771,55.31405,2.94766),(.65699,55.30231,2.92707),(.4759,55.30314,2.80047),(.45609,55.30505,2.82618),(.07718,55.37162,3.01666),(.10583,55.56262,2.89069),(.49127,55.63025,2.58535),(.50699,55.63564,2.52536),(.59288,55.45469,2.41163),(.59907,55.45506,2.35926),(.52157,55.44188,2.62285),(.00456,55.28309,3.25423),(0,55.3022,3.24773),(.17574,55.34837,3.30188),(.20322,55.33475,3.27021),(.12555,55.27827,3.04381),(.12208,55.27581,3.03871),(.08914,55.27976,3.04279),(.04076,55.2738,3.09247),(.00361,55.27297,3.21057),(.50938,55.30328,2.73831),(.52037,55.30076,2.78117),(.65742,55.30602,2.88382),(.65845,55.30636,2.88445),(.80962,55.30278,2.73712),(.54606,55.30191,2.643),(.65959,55.35185,3.01359),(.66116,55.34671,3.00995),(.40052,55.29075,2.96018),(.3978,55.28813,2.95876),(.61467,55.33296,2.93454),(.59544,55.32577,2.90706),(.60538,55.27687,2.51772),(.60412,55.27758,2.51512),(.60761,55.27879,2.51588),(.88622,55.3054,2.47206),(.88661,55.29894,2.46706),(.88962,55.30128,2.46706),(.87437,55.32271,2.58239),(.74347,55.26955,2.31413),(.65632,55.29473,2.18405),(.6525,55.28673,2.22616),(.68072,55.29176,2.09571),(.72043,55.27907,2.05074),(.87726,55.28125,1.7219),(.88112,55.2778,1.71642),(.94082,55.28281,1.74456),(.93812,55.28703,1.74925),(1.10418,55.35393,1.68781),(1.10932,55.35275,1.68924),(1.10509,55.34886,1.69266),(1.08259,55.34082,1.70543),(0,55.35702,3.12086),(0,55.39708,3.07882),(0,55.34538,3.10436),(.04636,55.33229,3.04718),(.49472,55.3807,2.67516),(.63187,55.39346,2.10495),(.61991,55.4766,2.08733),(.63619,55.39594,2.07741),(.92899,55.50367,2.46694),(1.05724,55.51582,1.9969),(.96696,55.60333,1.33414),(1.02361,55.62997,1.38752),(1.06247,55.64191,1.45517),(.80934,55.46938,2.86177),(.79769,55.48116,2.89546),(.79823,55.38928,2.87511),(1.12993,55.37021,1.72801),(1.0196,55.5817,2.22479),(1.01577,55.46612,2.21496),(1.01705,55.47202,2.17252),(1.0999,55.36435,1.89254),(1.07755,55.5507,1.88381),(.17762,55.61123,3.25835),(.51702,55.79187,3.08843),(.46807,55.86421,3.06518),(.55689,55.91158,3.04242),(.75806,55.58129,2.95335),(.72074,55.78776,2.9141),(.91434,55.48201,2.56021),(.5967,55.46376,2.20741),(.56555,55.65563,2.18142),(.14086,55.37588,2.97408),(.19443,55.64964,2.75552),(.11744,55.64753,2.81475),(.16133,57.25403,3.11109),(.15975,57.31448,3.04441),(.15659,57.25105,3.07949),(.1501,57.41013,2.99586),(.16224,57.50062,2.94453),(.14431,57.11581,3.22467),(.14286,56.96604,3.30293),(.1595,56.96785,3.32142),(.22229,57.44751,2.87275),(.2054,57.47642,2.94782),(.21104,57.35909,2.89339),(.23184,57.34206,2.85595),(.26883,57.39899,2.74606),(.25598,57.08178,2.89206),(.24998,57.08356,2.84698),(.14921,57.31044,3.02443),(.17084,57.3199,2.99604),(.19535,57.31437,3.00824),(.28176,57.40148,2.75727),(.29795,57.15591,2.84421),(.27482,57.09617,3.0378),(.19726,57.07776,3.15096),(.23974,57.27754,2.97941),(.24437,57.25528,2.9846),(.19414,57.21275,3.07099),(.19906,57.27716,3.02956),(.32311,56.86811,2.89281),(.29221,56.96853,2.89823),(.3438,56.79442,2.88823),(.22272,57.25802,2.88691),(.24503,57.12068,2.85855),(.35587,56.70922,2.89544),(.87862,56.49634,2.65841),(.89811,56.48696,2.64547),(.99927,56.6856,2.13651),(.91634,56.52519,2.65376),(.69871,55.78065,1.56415),(.70241,55.76913,1.54707),(.34789,56.67612,2.8038),(.37586,56.46565,3.01304),(.15272,57.2316,3.09774),(.25985,57.18095,3.01205),(.15383,57.0801,3.28416),(.22451,55.57568,2.81754),(.74225,55.79127,2.88393),(.75463,55.48471,2.95016),(1.07031,55.68333,2.25028),(1.01531,55.58625,2.26185),(.81575,55.37924,2.8469),(1.11385,55.5704,1.65018),(1.11353,55.57276,1.67729),(1.07687,55.64696,1.48514),(1.03218,55.53883,1.4121),(1.0918,55.72441,1.61809),(1.08612,55.56863,1.82529),(.83394,55.44517,2.77364),(.83586,55.44451,2.75994),(.83178,55.52381,2.76516),(.41265,55.48979,3.19654),(.74204,55.5237,1.43132),(.73102,55.41583,1.67979),(.70692,55.5009,1.67711),(.72597,55.41962,1.6666),(.67343,55.40178,1.99808),(.6557,55.48158,1.99653),(.6757,55.40185,1.97903),(.55894,55.38078,2.55057),(.49297,55.43864,2.67455),(.45611,55.36777,2.78855),(.46219,55.37793,2.77612),(.24565,55.34592,2.9288),(.24329,55.40498,2.90702),(.25502,55.34857,2.92276),(.00351,55.34251,3.09657),(.79568,55.32098,1.62312),(.65937,55.29649,2.18461),(.60673,55.27475,2.52001),(.49274,55.32719,3.10688),(.49978,55.30085,2.86561),(.48913,55.32367,2.77366),(.81037,55.29884,2.73345),(.24157,55.26502,3.13835),(.25753,55.27488,3.17061),(.01622,55.2685,3.15416),(.05411,55.27654,3.06653),(.17974,55.34725,3.30683),(.6927,55.50183,1.73428),(.59638,55.45633,2.29083),(.44699,55.36851,2.80067),(.60097,55.2808,2.57048),(.81663,55.34655,2.83935),(.26062,55.30449,3.25453),(.86186,55.35682,2.7058),(.20354,55.34283,2.95055),(.66048,55.2969,2.1558),(.76749,55.34516,1.51332),(.80213,55.25792,2.01797),(1.33912,56.70772,2.11066),(1.4132,56.76355,2.27738),(1.1056,56.6708,1.9485),(1.26019,56.63302,2.58117),(.63637,55.33563,2.96055),(.63924,55.40334,3.12831),(.62866,55.37704,3.12269),(.64292,55.37484,3.10042),(.46657,55.31364,3.07897),(.04525,55.36532,3.35315),(.7599,55.26765,2.36435),(.18804,55.81629,3.14768),(0,55.76809,1.7302),(0,55.67375,2.97015),(.24463,55.66104,2.70695),(.29783,55.68065,2.67271),(.0441,55.76288,2.71393),(.20642,55.79062,1.74747),(.63286,55.77764,1.48108),(.7395,55.53868,1.42589),(.03814,56.00223,3.02134),(.00279,55.95213,2.43142),(.98757,56.40593,2.69614),(.99678,56.39171,2.69444),(.95271,56.52997,2.72455),(.94515,56.41112,2.67101),(.96315,56.44868,2.6825),(.40602,56.75718,2.31742),(.44803,56.85024,1.63398),(.5693,56.87783,2.03319),(.49364,56.885,2.12777),(.49613,56.35738,2.49283),(.50411,55.94248,2.48291),(.52981,56.37767,2.58851),(.4794,55.94893,2.66188),(.34946,56.6647,2.76546),(.44986,56.7361,2.65284),(.39229,56.80023,2.56276),(.23816,57.14105,2.96529),(.54634,56.82599,2.83254),(.96782,56.70011,2.03999),(.9022,56.76931,1.7664),(.94426,56.74392,1.64298),(.95077,56.70918,2.04893),(.94243,56.73042,2.10626),(1.17647,56.63805,2.17809),(1.35007,56.68881,2.27161),(1.31353,56.67701,2.11308),(1.08813,56.63081,2.69651),(.97978,56.68444,2.59981),(1.15933,56.61548,2.53197),(1.22645,56.62888,2.70676),(1.57918,56.18988,2.38535),(1.54501,56.37651,2.41526),(1.3281,56.22546,2.50891),(1.17289,55.8124,2.2302),(1.08593,55.63309,1.75612),(.55876,56.43917,2.95092),(.66879,55.88398,2.92781),(.81862,55.88594,2.66139),(.79621,56.09284,2.71921),(1.51181,56.62371,2.34263),(.1811,57.10195,3.14663),(.24768,57.08007,2.97448),(.04328,55.98582,3.01909),(.04245,55.93973,2.61404),(.09007,55.77161,1.94872),(.08947,55.78866,1.74571),(.49669,55.81316,1.81841),(.37791,55.7664,1.97363),(1.11792,55.41404,1.64742),(1.10624,55.38489,1.56483),(.92205,55.28935,2.01397),(1.00229,55.34116,2.03266),(.7879,55.36687,2.0839),(.84939,55.28497,2.35523),(.76764,55.28553,2.42178),(.71804,55.30573,2.40283),(.7181,55.31767,2.40601),(.6968,55.3127,2.39526),(.88892,55.37231,2.6403),(.73897,55.30508,2.41202),(.78937,55.34134,2.60761),(.73138,55.34397,2.59626),(.65334,55.30588,2.39804),(.50896,55.31847,2.71601),(.6041,55.31535,2.8516),(.00581,55.28339,3.25456),(.00479,55.35311,3.26258),(.97895,55.65929,1.63592),(.99782,55.66329,1.63972),(.9697,55.62928,1.56799),(.94924,55.66329,1.59942),(.95233,55.66218,1.62786),(.92445,55.68708,1.63028),(.91575,55.63424,1.5938),(.95204,55.68297,1.64291),(.94839,55.67238,1.62565),(.94798,55.67397,1.6184),(.95925,55.67857,1.62398),(.86732,55.68154,1.61995),(.87903,55.6816,1.60063),(.92478,55.68343,1.61094),(.90344,55.68041,1.59921),(1.00725,55.66848,1.63161),(.96896,55.60516,1.61442),(.85659,55.56737,1.55914),(1.09241,55.5107,1.58819),(.96923,55.45119,1.62698),(.83462,55.43683,1.66069),(.9646,55.68363,1.91341),(.91555,55.64048,1.89079),(.93972,55.67361,1.91192),(.84641,55.45229,1.87378),(.88602,55.62913,1.97428),(.86845,55.44834,1.91233),(.97532,55.58953,1.9808),(1.04247,55.41004,1.9033),(.90309,55.55817,1.81687),(.84112,55.55781,1.99604),(.82366,55.38662,1.99295),(.8167,55.31951,1.97909),(.94546,55.67912,1.97174),(.90158,55.65107,1.97383),(.89449,55.57773,1.95334),(.9286,55.61126,1.96106),(.90635,55.6072,1.95931),(.92237,55.58132,1.95888),(.77362,55.43599,1.94306),(.95814,55.57302,2.15729),(.84205,55.51185,2.26558),(.7606,55.54589,2.12831),(.76464,55.55323,2.13129),(.82591,55.59998,2.38151),(.93998,55.56853,2.39503),(.67156,55.80348,2.18382),(.67612,55.80392,2.1804),(.68301,55.83003,2.20019),(.89669,55.77146,2.14356),(.88215,55.80056,2.17052),(.88833,55.76949,2.38487),(.91639,55.74816,2.38691),(.89512,55.74609,2.39567),(.74364,55.76688,2.28023),(.85506,55.80556,2.21311),(.69363,55.8398,2.23763),(.71414,55.83823,2.23423),(.97066,55.49893,2.21807),(.94073,55.59209,2.29404),(.88303,55.4644,2.1104),(.84473,55.45217,2.36692),(.7365,55.65024,2.15205),(.83474,55.76051,2.32003),(.65843,55.53994,2.2695),(.65384,55.50522,2.13569),(.69315,55.64393,2.12158),(.82847,55.73722,2.35356),(.6668,55.34655,2.16342),(.80043,55.66472,2.59096),(.78917,55.66582,2.60858),(.78298,55.66719,2.60458),(.76638,55.62331,2.53284),(.75812,55.59451,2.50631),(.76869,55.59003,2.51195),(.78058,55.58452,2.51621),(.86148,55.4963,2.61468),(.43715,55.32536,2.88977),(.50407,55.90632,2.90858),(.50764,55.90848,2.91656),(.48461,55.49327,2.86806),(.47922,55.57076,2.88365),(.45382,55.48861,2.8713),(.4568,55.56836,2.88288),(.48292,55.69076,3.08946),(.54933,55.67757,2.96028),(.51503,55.66574,2.92089),(.49954,55.878,2.90693),(.51054,55.89784,2.97707),(.45129,55.87656,2.91118),(.41842,55.58392,3.01422),(.4094,55.50105,2.98266),(.41384,55.57834,2.98582),(.51379,55.61631,3.12523),(.5244,55.54815,3.13783),(.49014,55.61208,3.11432),(.5004,55.5427,3.13114),(.61122,55.48598,3.10695),(.73335,55.78508,2.85019),(.7365,55.77374,2.85824),(.55635,55.78058,2.73754),(.7327,55.73175,2.88833),(.54221,55.76565,2.75423),(.52532,55.7316,2.72466),(.67515,55.60311,2.88347),(.55968,55.52975,2.67303),(.71841,55.47304,2.91549),(.7578,55.52559,2.88057),(.79077,55.52222,2.8147),(.73647,55.60134,2.90584),(.67753,55.72429,2.85695),(.74273,55.77393,2.85127),(.72101,55.77286,2.86275),(.72605,55.7859,2.85201),(.6854,55.6669,2.884),(.65238,55.55369,2.77546),(.75857,55.46899,2.73748),(.2781,55.71169,3.10105),(.04049,55.76289,3.11717),(.03827,55.76048,3.1103),(.0443,55.76608,3.10831),(.07824,55.73618,3.12675),(.02964,55.68842,3.17061),(1.06076,55.74417,2.17753),(1.28408,56.5553,2.478),(1.24867,56.57876,2.44758),(1.33539,56.40249,2.36254),(1.26925,56.55102,2.22401),(1.25466,56.54229,2.29332),(.50012,56.30738,1.56212),(.52365,56.30384,1.58211),(.831,55.78333,2.09505),(.69847,56.3576,2.73261),(.5468,56.08847,2.05024),(.52285,56.46403,1.51466),(.71647,55.81921,1.53986),(.68844,55.78286,1.56438),(.69575,55.80526,1.56092),(.87838,56.71028,1.53614),(.77565,56.41744,2.69599),(.50917,56.83924,2.26105),(.52049,56.75153,2.51061),(.64218,56.48144,2.56598),(.63677,56.71291,2.59146),(.63955,56.56246,2.59087),(.52329,56.82746,1.66571),(.61799,56.56207,1.39727),(1.01763,56.40918,1.52595),(.96067,56.63927,1.53654),(.95403,56.64018,2.08891),(.76678,56.72133,1.50332),(1.0136,56.63105,2.30367),(1.24359,56.57673,2.46394),(1.02341,56.61475,2.62825),(1.20468,56.57817,1.94244),(1.18572,56.57901,2.56123),(.64122,56.75586,2.59166),(1.15925,55.97581,2.34475),(1.20298,55.96706,2.09557),(1.07026,55.75786,2.07934),(.70113,55.83319,1.55332),(.6986,55.81517,1.55857),(.70802,55.81692,1.55885),(.60764,55.94243,2.1675),(.83236,56.43405,1.36847),(.70644,56.7322,2.45501),(1.14569,56.15494,1.74556),(1.06269,56.58676,2.64712),(.76464,56.32467,2.6727),(1.14213,55.86037,2.1255),(1.07542,56.58071,2.55193),(1.00653,56.62913,2.08637),(.81972,56.69506,2.54697),(.6458,56.35954,1.38556),(.8556,56.54686,2.67052),(.80068,55.67254,1.42603),(.89203,56.69212,2.12656),(.4543,56.79354,1.64251),(1.234,56.57043,2.21037),(.42986,56.70738,2.58375),(.50241,56.2641,1.52798),(.8661,55.69556,1.45457),(1.1639,56.14623,1.86046),(.64446,56.07896,2.66114),(.04773,55.76333,3.09403),(.28755,55.54387,3.16201),(.50075,55.42588,2.72543),(.77161,55.59817,2.87053),(.51104,55.60211,2.78793),(.52638,55.60176,2.79822),(.6994,55.77272,2.83034),(.70585,55.61038,2.78344),(.54949,55.73224,2.70445),(.58847,55.72905,2.7139),(.49901,55.60226,2.74858),(.64969,55.47507,2.88516),(.50046,55.53336,2.74338),(.77359,55.3643,2.70738),(.73131,55.78986,2.84122),(.56458,55.77822,2.72618),(.75034,55.75804,2.85403),(.41207,55.4171,2.909),(.4816,55.89525,2.98532),(.47184,55.89193,2.97899),(.47893,55.91401,2.96151),(.49611,55.8983,2.98733),(.43292,55.72921,2.96823),(.47821,55.657,2.89947),(.52942,55.8153,3.03569),(.46152,55.80112,3.01778),(.54604,55.62765,2.93616),(.51129,55.91016,2.92466),(.49408,55.83807,2.91205),(.52282,55.37209,3.13779),(.39528,55.32135,2.92902),(.48973,55.37974,2.85668),(.58286,55.40394,2.91387),(.72808,55.61115,2.58763),(.87105,55.56654,2.54111),(.73435,55.61063,2.52203),(.80028,55.64682,2.5691),(.83981,55.65864,2.60639),(.80322,55.65743,2.58312),(.69393,55.8394,2.22467),(.6986,55.83976,2.21348),(.67637,55.43025,2.26533),(.85877,55.79878,2.32265),(.63619,55.53985,2.20669),(.89505,55.79444,2.34919),(.8659,55.78844,2.29936),(.73179,55.51305,2.31163),(.89451,55.77144,2.21901),(.73428,55.53675,2.11703),(.82202,55.52549,2.2301),(.79081,55.54144,2.32149),(.729,55.82196,2.27551),(.72043,55.83905,2.21368),(.73201,55.8359,2.22903),(.94489,55.66985,2.33404),(.62733,55.64457,2.18054),(.70337,55.57368,2.30186),(.69667,55.76653,2.29597),(.74737,55.79807,2.21348),(.74941,55.7982,2.22229),(.74618,55.8227,2.22399),(.82983,55.58327,2.16753),(.72325,55.57233,1.79467),(1.03274,55.42499,1.85566),(.94116,55.64881,1.86014),(.96661,55.61217,2.02991),(.91338,55.65367,2.0036),(.94097,55.65555,1.96314),(1.01638,55.46066,1.95431),(.92324,55.61984,1.84398),(.76329,55.66952,1.79942),(.95464,55.68507,1.90241),(.92674,55.67754,1.98867),(.95185,55.68482,1.9869),(.9655,55.67603,1.97453),(.76769,55.66734,1.82822),(.78684,55.63361,1.82967),(.93288,55.67283,1.9077),(.92012,55.66541,1.89274),(.77275,55.66268,1.79822),(1.05031,55.35691,1.87788),(.85047,55.44096,1.50276),(1.01168,55.45151,1.72064),(1.0802,55.5064,1.51993),(.92307,55.53443,1.62501),(1.07818,55.55339,1.69224),(.799,55.52676,1.56143),(.94115,55.60326,1.6422),(.8097,55.56554,1.56075),(.98809,55.60549,1.55355),(1.0195,55.64869,1.67005),(.93389,55.63687,1.68876),(.93289,55.62953,1.63939),(.99323,55.63381,1.56386),(1.03218,55.6378,1.61845),(.95605,55.67018,1.68501),(.89121,55.6971,1.61355),(.96867,55.67756,1.62942),(.97558,55.67763,1.6303),(.94516,55.66301,1.60629),(.94638,55.66225,1.61597),(.98361,55.67288,1.63513),(.98736,55.67945,1.62457),(.98127,55.67855,1.61379),(.94828,55.44975,1.57957),(.96308,55.67919,1.62117),(.91178,55.69576,1.61414),(.90959,55.68234,1.64565),(.91353,55.69225,1.62843),(.9078,55.69512,1.6235),(.93738,55.45015,1.52413),(.88012,55.69329,1.61546),(1.02456,55.61501,1.64718),(.93119,55.49262,1.59767),(.96036,55.65697,1.63568),(1.08633,55.46182,1.59637),(.98671,55.58265,1.6155),(.80939,55.36294,2.83869),(.57829,55.36993,2.62675),(.63878,55.34598,2.5568),(.81468,55.28587,2.67503),(.72106,55.36147,2.08383),(1.08046,55.4073,1.52269),(.72228,55.51158,1.54326),(.71046,55.50476,1.60912),(.69395,55.57245,1.57833),(.05312,55.75532,2.19517),(.50808,56.15497,1.68031),(.20596,55.81104,2.41009),(.36257,55.92085,2.87407),(.78492,56.46391,1.27683),(.97044,56.0757,1.36015),(1.07743,55.73005,1.54647),(1.01923,55.76777,2.48464),(1.21944,56.04012,2.49397),(1.60871,56.07669,2.31605),(.90219,56.47389,2.65615),(.90768,56.39835,2.66734),(.6436,55.76461,2.97949),(.06791,55.48669,3.33154),(.60703,56.13065,2.925),(1.57636,56.28253,2.31994),(1.24442,56.62588,2.60524),(1.3289,56.72906,2.00073),(1.37655,56.71108,2.32218),(1.10415,56.67235,1.95644),(1.40092,56.42066,2.24714),(.77492,56.81021,2.03322),(.5322,56.87137,1.61545),(.54399,56.61016,2.74573),(.53938,56.51083,2.79256),(.41283,56.7762,2.882),(.76911,56.76028,2.6913),(.52995,56.02949,2.02996),(.534,56.08214,2.04209),(.4836,56.31021,1.55104),(.35946,56.79072,2.11254),(1.00015,56.48026,2.72873),(.83132,56.49636,2.79923),(.92735,56.52089,2.66767),(.90237,56.53076,2.67702),(.88483,56.52786,2.68873),(.88392,55.63496,1.29244),(.92905,56.7298,2.03908),(.02017,55.87409,2.17718),(.01467,56.01014,2.85551),(.03264,55.9775,2.73406),(.62836,55.7149,1.50217),(.47418,55.89517,1.83509),(.02632,55.76226,1.72461),(0,56.00786,2.81874),(0,55.31559,3.28491),(.1469,55.35292,3.32776),(.52348,55.30088,2.86669),(.52775,55.30252,2.66484),(.91052,55.36784,2.55755),(1.37626,56.69692,2.37188),(.83273,55.30835,1.6552),(1.01491,55.39121,1.43918),(1.01154,55.36491,1.50076),(.77373,55.34667,1.49842),(1.01144,55.36664,2.2473),(.73271,55.27705,1.82645),(.66269,55.31826,2.07077),(.84382,55.34649,2.74954),(.75538,55.34759,2.90871),(.75252,55.34078,1.65539),(.96859,55.38139,1.42397),(.94456,55.35869,1.45354),(.97384,55.36343,1.45973),(1.05709,55.39323,1.47767),(1.03233,55.29607,1.78624),(.52272,55.64103,2.46545),(.65855,55.48895,1.9473),(0,55.74344,2.8656),(0,55.84172,2.91595),(.19614,55.27563,3.12752),(.39403,55.32792,3.19289),(.42776,55.30201,3.00925),(.74315,55.26644,2.35548),(.73818,55.27631,2.40122),(.71901,55.2749,2.3923),(.60595,55.29244,2.43487),(.67792,55.27211,2.27566),(.97036,55.33711,2.3159),(1.05215,55.30272,1.81109),(.83213,55.31651,1.65223),(.33515,55.35502,2.87849),(.35068,55.35841,2.86899),(.72243,55.41338,1.70179),(.72841,55.43973,1.54198),(1.07345,55.63418,1.82758),(1.1411,55.39227,1.66636),(1.12557,55.52562,1.67138),(.6733,55.50596,3.0723),(.64212,55.62473,3.10509),(.17546,57.1996,3.08174),(.39496,56.42696,2.85182),(.38952,56.42386,2.92456),(.36091,56.57474,2.90575),(.22549,57.21789,2.87696),(.14984,57.2107,3.12681),(.29582,57.17118,2.97013),(.14497,57.1717,3.17546),(1.01236,55.46041,2.25832),(.66998,55.60543,3.06852),(.89979,55.46979,2.61965),(.78519,55.38644,2.89576),(1.11025,55.56969,1.60741),(1.09939,55.57353,1.75113),(.7207,55.42904,1.60266),(.69475,55.41184,1.78991),(.70991,55.41176,1.74415),(.67612,55.40469,1.9343),(.61204,55.38233,2.20637),(.581,55.4527,2.46651),(.57698,55.38517,2.45239),(.29443,55.35236,2.90061),(.80143,55.34353,1.51317),(.80495,55.34217,1.49806),(.80867,55.34565,1.50114),(.79777,55.34,1.51046),(.78604,55.32639,1.58502),(.79008,55.33538,1.5547),(.94127,55.36121,1.48774),(.97532,55.36251,1.49707),(1.12902,55.38426,1.63235),(1.12945,55.37471,1.66199),(1.12581,55.38466,1.63264),(1.02349,55.32477,1.70577),(.98103,55.32875,1.69427),(.72479,55.27105,1.86607),(.73549,55.27747,1.82658),(.77033,55.28743,1.73459),(1.00355,55.29831,1.77607),(1.00545,55.2936,1.7707),(1.06648,55.3104,1.87294),(1.07152,55.30877,1.87196),(1.05974,55.30606,1.84221),(1.03734,55.30751,2.0296),(.98378,55.32772,2.20202),(.98781,55.32586,2.20202),(.97738,55.32227,2.1717),(.84937,55.27906,2.3596),(.66564,55.29691,2.12762),(.94776,55.30338,2.10626),(.89592,55.30387,2.10135),(.77007,55.27971,2.41713),(.63881,55.27056,2.55066),(.6407,55.27493,2.54713),(.5539,55.35649,3.14873),(.43944,55.30345,2.8885),(.43867,55.30114,2.88544),(.55982,55.3159,2.88575),(.65534,55.37094,3.07819),(.65669,55.37069,3.07909),(.64151,55.37507,3.09987),(.55326,55.29614,2.82023),(.78888,55.34065,2.86528),(.79078,55.34031,2.86628),(.77163,55.33947,2.879),(.51265,55.30387,2.68889),(.51107,55.30348,2.7153),(.51641,55.30462,2.69131),(.77349,55.28478,2.69396),(.77113,55.28839,2.69607),(.55442,55.30062,2.81831),(.28777,55.29572,3.19821),(.28653,55.29303,3.20167),(.3135,55.31556,3.21354),(.2309,55.26216,3.09719),(.22825,55.2587,3.09751),(.22804,55.2655,3.05563),(.38118,55.29697,3.07417),(.38401,55.2926,3.07319),(.3602,55.28928,3.04847),(0,55.68482,3.00169),(0,55.77455,2.73352),(0,55.97631,2.72228),(0,55.66725,2.91859),(.67906,55.40847,1.88995),(.65398,55.31335,2.12587),(.61333,55.37657,2.28425),(.53591,55.29416,2.80109),(1.01399,55.3633,2.20399),(1.01724,55.29224,1.73428),(.99897,55.36732,1.46624),(.79223,55.35102,2.88084),(.65962,55.39802,3.09852),(.12222,55.37808,3.35707),(.1135,55.35498,3.3434),(.42938,55.30763,2.8609),(.41544,55.30067,2.90339),(.39516,55.3071,2.88214),(.56969,55.31462,2.52415),(.83795,55.28454,2.44608),(.84828,55.26825,2.39805),(.75545,55.2859,1.75597),(.73437,55.32402,1.75711),(.81639,55.34373,1.48722),(.89905,55.57736,1.29934),(1.105,55.56852,1.56477),(.68738,55.26291,2.60128),(.69392,55.27228,2.63463),(.64249,55.26869,2.5833),(.73403,55.26508,2.62556),(.73425,55.27489,2.65932),(.03119,55.97839,3.24319),(0,55.75403,1.93105),(.00407,55.73727,2.86051),(0,55.45536,3.0499),(.01243,55.84516,2.92811),(.07983,55.32899,3.0227),(.06677,55.76195,2.46273),(.14811,55.7511,2.21704),(.28589,55.76487,2.2494),(.08604,55.78305,1.73873),(.62599,55.75405,1.51087),(.03884,55.96757,2.73434),(.04014,55.98003,2.82984),(0,55.95081,2.43168),(0,55.87366,2.17482),(.91491,56.7291,2.00316),(.10454,55.93262,2.84861),(1.08908,55.64276,1.55129),(.90149,56.48374,2.65601),(.52104,56.16111,1.69483),(.38897,56.76557,2.21205),(.38477,56.79033,2.21245),(.54385,56.10494,1.8787),(.47631,56.74387,1.45695),(.50382,56.76997,1.44205),(.42072,56.90224,2.22509),(.42789,56.90591,2.22374),(.73843,56.78238,2.54516),(.47997,56.77528,2.88748),(.91108,56.45428,1.35544),(.83179,56.26998,1.2676),(.9554,56.25877,1.34881),(1.00376,56.7041,2.10015),(.97668,56.69535,2.02581),(.96782,56.72671,2.1445),(1.10582,56.59731,2.67275),(1.10259,56.58985,2.7236),(1.16859,56.60055,2.7113),(1.54427,56.45773,2.32659),(1.58405,56.14361,2.31125),(1.54914,56.37423,2.4089),(1.58062,56.42819,2.32478),(1.56535,56.35645,2.32115),(1.26724,56.23072,2.54361),(1.28453,56.28608,2.00488),(.35045,57.10094,2.92703),(.4094,56.5774,3.14235),(.82114,55.45574,2.81867),(.85557,55.44305,2.71816),(1.21121,56.23572,2.5756),(1.04118,56.23503,1.44663),(.71691,56.22396,1.251),(.69648,56.86315,1.5912),(.58395,56.77393,1.43883),(.17715,57.15559,3.11283),(.46406,55.96739,2.76613),(.35897,55.89896,2.7711),(.22162,55.83785,2.62073),(.36473,55.84569,2.45264),(.3564,55.87352,2.64809),(.49118,55.90865,2.00519),(.3556,55.81125,1.9788),(.48874,55.81256,1.82348),(.36142,55.77682,1.79988),(.97737,55.36708,1.50189),(.97991,55.36303,1.49771),(1.01095,55.36858,1.50481),(1.00886,55.40097,1.50197),(1.08321,55.40973,1.69706),(.90149,55.3234,1.67929),(.97597,55.39671,1.69938),(1.11355,55.38635,1.5852),(.81937,55.3838,1.49335),(.85893,55.3523,1.47293),(.8627,55.38855,1.47701),(.81898,55.34712,1.49114),(.79425,55.38064,1.53933),(.79503,55.3401,1.5291),(.7994,55.38139,1.51939),(.74543,55.28486,1.78319),(.74253,55.31856,1.83079),(.74817,55.32152,1.79405),(1.0267,55.34481,2.02738),(1.06113,55.31767,1.99343),(1.04882,55.34957,1.99768),(1.06835,55.31668,1.9308),(.75382,55.36551,2.08203),(.96336,55.31051,2.12235),(.93595,55.40177,2.11098),(.95682,55.40305,2.12887),(.97562,55.39274,2.24531),(.97665,55.39861,2.20317),(.90462,55.37827,2.37082),(.66226,55.34634,2.19158),(.61963,55.34821,2.43754),(.60633,55.29948,2.43573),(.81753,55.34119,2.6121),(.84621,55.34124,2.6081),(.73806,55.28088,2.58931),(.68391,55.27246,2.56652),(.68222,55.26706,2.57002),(.59639,55.3063,2.48472),(.87286,55.34185,2.58434),(.69154,55.34933,2.40436),(.61161,55.36728,2.93691),(.63039,55.37445,2.96404),(.65536,55.38631,3.01911),(.62757,55.3771,3.12173),(.63974,55.39274,3.10125),(.62521,55.39224,3.12268),(.48928,55.36152,3.10937),(.39782,55.2957,2.92844),(.3968,55.32531,2.96201),(.46223,55.3284,2.87115),(.7292,55.36504,2.90898),(.7564,55.33601,2.89453),(.7553,55.36441,2.89537),(.60162,55.36884,2.85749),(.55365,55.31688,2.82068),(.50681,55.3185,2.73911),(.49735,55.37196,2.74278),(.68245,55.36711,2.64685),(.64354,55.3147,2.6243),(.69234,55.31337,2.63995),(.63403,55.36844,2.62395),(.81075,55.36312,2.74719),(.82881,55.36249,2.78722),(.77324,55.31034,2.69749),(.53654,55.31739,2.80215),(.5376,55.29859,2.79956),(.51933,55.31786,2.7834),(.53078,55.31779,2.66855),(.53177,55.30343,2.66777),(.69285,55.2764,2.63778),(.25224,55.32444,3.15693),(.2593,55.27818,3.16778),(.28034,55.34194,3.18689),(.24349,55.27713,3.01853),(.22559,55.2828,3.05102),(.2439,55.27182,3.02001),(.32349,55.29852,3.01801),(.35519,55.31535,3.04329),(.39382,55.35171,3.1221),(.39759,55.36445,3.15754),(.15898,55.33332,3.07306),(.18397,55.34875,3.1217),(.19401,55.38323,3.25966),(.17016,55.38711,3.29173),(.04236,55.37414,3.32507),(.06704,55.34735,3.33721),(.06574,55.37868,3.32787),(.01705,55.32987,3.14607),(.00484,55.33837,3.19982),(.12158,55.32051,3.04357),(.08701,55.31485,3.04265),(.97472,55.66225,1.63675),(.96943,55.67219,1.63387),(.99676,55.64933,1.63458),(1.0113,55.65461,1.62901),(.96848,55.63071,1.62252),(.97982,55.64772,1.63456),(.98775,55.62945,1.62863),(1.02957,55.50908,1.61095),(1.02507,55.45746,1.61575),(1.05836,55.51,1.60607),(.99511,55.54181,1.64457),(.96965,55.49734,1.64239),(1.00585,55.50217,1.63718),(.96209,55.53798,1.64874),(1.08161,55.51212,1.6377),(1.05361,55.46121,1.62064),(1.04308,55.50715,1.63556),(.96401,55.63189,1.63918),(.94956,55.60404,1.6443),(.97399,55.60632,1.64169),(.94139,55.62983,1.64128),(1.01173,55.58041,1.64542),(.99895,55.60993,1.64256),(1.00319,55.67643,1.6294),(.99806,55.67493,1.63312),(.9184,55.57222,1.59229),(.96119,55.60467,1.56192),(.95589,55.57865,1.56913),(.96654,55.57881,1.55068),(.951,55.60457,1.57796),(.97099,55.50267,1.52971),(.98956,55.50124,1.51238),(.89247,55.69707,1.61268),(.97781,55.45202,1.62885),(.99958,55.50824,1.60905),(.98833,55.54741,1.60949),(.99755,55.54808,1.61121),(.99047,55.50773,1.60685),(1.04339,55.6122,1.61433),(1.02468,55.63526,1.62223),(1.08914,55.51259,1.64687),(.92857,55.44865,1.60136),(.90163,55.69541,1.62414),(.97094,55.6887,1.64829),(.97972,55.68746,1.64975),(.97007,55.68978,1.66785),(.96793,55.69075,1.65783),(.97511,55.69003,1.66354),(.96457,55.69086,1.66072),(.92355,55.49263,1.54835),(.95804,55.54445,1.58571),(.95536,55.5798,1.59966),(.96045,55.54455,1.59326),(.95312,55.57929,1.59214),(.94766,55.66098,1.62241),(.94626,55.64807,1.61045),(.94773,55.64684,1.61778),(.98876,55.67894,1.62754),(.98751,55.67856,1.6295),(1.00395,55.67818,1.62462),(1.01485,55.44932,1.49764),(.96799,55.67932,1.62109),(.90659,55.69624,1.61151),(.88953,55.69661,1.62102),(.88777,55.69694,1.61861),(.89456,55.69703,1.61152),(.89975,55.69674,1.61057),(1.00326,55.6742,1.66505),(.97915,55.68859,1.65444),(1.00345,55.67323,1.65808),(.97351,55.673,1.68781),(.98767,55.67476,1.68435),(.96321,55.68865,1.67093),(1.00159,55.65856,1.58475),(1.01925,55.66129,1.59384),(1.01715,55.63972,1.5637),(.92028,55.66244,1.59939),(1.00149,55.67459,1.67186),(.9607,55.64298,1.70284),(.98329,55.646,1.70533),(.81944,55.62935,1.5971),(.81702,55.62944,1.6048),(.84752,55.60459,1.57121),(.98707,55.63505,1.64054),(.99263,55.61815,1.72603),(1.00109,55.64821,1.70121),(1.01242,55.62084,1.72109),(.88671,55.60973,1.69368),(.84498,55.60509,1.67182),(.80503,55.60255,1.60024),(.81462,55.62976,1.61218),(.80269,55.60267,1.60976),(1.03233,55.61502,1.54663),(1.02283,55.60796,1.62139),(1.00709,55.63057,1.62838),(1.04387,55.58703,1.53353),(1.06633,55.58996,1.54425),(.78608,55.56364,1.61083),(.80044,55.60322,1.62274),(.78459,55.5632,1.6281),(.83585,55.56663,1.55506),(.97959,55.57968,1.73767),(1.00898,55.58416,1.74279),(.96669,55.61407,1.72122),(.83604,55.56583,1.67883),(.80463,55.60019,1.64618),(.79716,55.56369,1.65559),(1.02572,55.5495,1.61339),(1.03901,55.58379,1.61457),(1.05299,55.55216,1.60892),(1.01974,55.54928,1.51687),(1.04964,55.55149,1.51913),(.79212,55.52576,1.6559),(.78012,55.52508,1.62118),(.83777,55.52786,1.54716),(.80734,55.52743,1.55184),(.91965,55.53396,1.61861),(1.06823,55.55258,1.72484),(1.07563,55.55378,1.70877),(1.04699,55.58964,1.72753),(.95495,55.53494,1.72494),(.99402,55.54109,1.74122),(.94476,55.57358,1.71979),(1.07332,55.5536,1.53078),(1.05075,55.50441,1.50419),(1.02609,55.54583,1.74531),(1.03866,55.50252,1.74305),(.83215,55.48325,1.67224),(.79283,55.48094,1.65062),(.83053,55.52674,1.67979),(.79065,55.48224,1.55553),(.78746,55.52568,1.58615),(.78667,55.48168,1.57299),(.85775,55.52894,1.55179),(.86236,55.48727,1.53365),(1.09385,55.51209,1.66723),(1.06579,55.50678,1.73263),(1.08344,55.50995,1.72041),(1.05134,55.54979,1.73568),(.95795,55.50361,1.57648),(.96039,55.50336,1.55113),(1.08736,55.45757,1.54835),(1.07395,55.46144,1.71295),(1.04642,55.45646,1.72403),(.77936,55.48065,1.61272),(.77805,55.43209,1.59739),(.79958,55.4351,1.52716),(.79038,55.43397,1.53861),(.7994,55.48316,1.54446),(.93869,55.44985,1.57991),(.92375,55.49207,1.61734),(1.09461,55.51188,1.68506),(1.10501,55.46656,1.64986),(1.10546,55.46639,1.66785),(.96039,55.69052,1.66261),(.96955,55.69026,1.65491),(.97058,55.68957,1.6517),(.78431,55.37923,1.58471),(.80931,55.38258,1.50637),(.90516,55.39293,1.4892),(.91586,55.44795,1.52081),(.88072,55.44408,1.51225),(1.11802,55.41423,1.62675),(1.09241,55.46434,1.70178),(.77807,55.58105,1.77932),(.79037,55.58103,1.7952),(.77361,55.63635,1.78933),(.89385,55.51319,1.82333),(.91244,55.61771,1.88165),(.82203,55.51365,1.81841),(.79856,55.57724,1.83234),(.79722,55.57976,1.81295),(.82534,55.50855,1.84257),(.94723,55.61856,1.91081),(.96525,55.57245,1.8999),(.94367,55.56746,1.89602),(.96477,55.62204,1.91366),(.94192,55.45872,1.88058),(.94695,55.64038,1.91614),(.76629,55.66076,1.8456),(.77459,55.62875,1.86771),(.76126,55.62375,1.88404),(.82005,55.50671,1.86353),(.80228,55.504,1.89086),(.91774,55.63301,1.96044),(.93599,55.6358,1.96266),(.95346,55.63898,1.96841),(.95599,55.65826,1.96758),(.96306,55.5061,1.95436),(.92646,55.45387,1.92196),(.97464,55.45793,1.9375),(.92249,55.50257,1.94161),(.99688,55.50838,1.96822),(.95079,55.55338,1.96711),(.86547,55.57253,1.96433),(.85006,55.56519,1.97806),(.82084,55.43454,1.94937),(.876,55.54382,1.9504),(.8553,55.53901,1.96044),(.88511,55.57532,1.95509),(.94271,55.68335,1.98617),(.95117,55.68203,1.99828),(.9403,55.68111,1.9951),(.9496,55.68451,1.98763),(.95931,55.68548,1.90543),(.96436,55.68195,1.89816),(.92726,55.6756,1.89769),(.75074,55.66563,1.82535),(.74538,55.66169,1.81447),(.75255,55.6666,1.81727),(.74308,55.66122,1.82348),(.89664,55.60809,1.95788),(.97018,55.64275,1.97788),(.97346,55.66145,1.98441),(.96899,55.66134,1.97568),(.97478,55.64312,1.98666),(.96442,55.67157,1.92021),(.9741,55.64477,1.91506),(.99238,55.53161,1.89148),(1.00104,55.53385,1.88678),(.91669,55.56509,1.87959),(.92273,55.56348,1.88509),(.76704,55.63625,1.78296),(.83495,55.40126,1.75331),(.81378,55.45661,1.76168),(.75396,55.49155,1.93404),(.75899,55.43104,1.94372),(.73951,55.48693,1.93502),(.8804,55.62618,1.98503),(.95237,55.67673,2.00669),(.93837,55.67702,2.00202),(.95831,55.67557,2.006),(.96376,55.67555,2.0035),(.95832,55.6586,2.01635),(.95051,55.65721,2.01855),(.92005,55.67248,1.99356),(.97195,55.66072,1.99828),(.93119,55.65737,2.01141),(.94708,55.63679,2.02834),(.92502,55.63542,2.02112),(.95117,55.61543,1.96829),(.95584,55.60945,2.03536),(.9705,55.57736,2.03903),(.95682,55.57485,2.04482),(.87865,55.56128,2.02845),(.98148,55.58297,2.02016),(.97767,55.61801,1.99083),(.99018,55.54816,2.02535),(.97742,55.54081,2.04599),(.91164,55.52349,2.0472),(.87135,55.52078,2.03382),(.91223,55.56508,2.03989),(.84228,55.51796,2.02195),(.86841,55.47282,2.0269),(.83562,55.46989,2.01384),(1.00832,55.5074,1.98605),(1.00815,55.50118,2.02223),(.95417,55.48408,2.05624),(.9169,55.47775,2.04247),(.94433,55.53016,2.05636),(.86811,55.42819,2.01699),(.92465,55.43243,2.03438),(.88083,55.4981,1.93222),(1.02658,55.45184,2.01379),(1.04003,55.41325,2.00534),(.9699,55.40093,2.04559),(.92574,55.39534,2.02697),(.96375,55.43927,2.0503),(.97019,55.68123,1.90335),(.9086,55.61762,1.86563),(.98072,55.6333,1.87096),(.97446,55.65348,1.88223),(.9934,55.58316,1.85787),(.99642,55.58271,1.87542),(.93957,55.57238,1.82056),(.94329,55.62641,1.84809),(.97916,55.53305,1.82202),(.94155,55.52311,1.80121),(.97474,55.57976,1.83996),(1.00482,55.53604,1.86595),(.99363,55.58029,1.89228),(.97017,55.52627,1.89353),(.99051,55.5351,1.83125),(.9869,55.47174,1.80813),(1.00113,55.47375,1.819),(1.01463,55.47505,1.83429),(1.00856,55.424,1.80906),(1.02645,55.42558,1.82665),(.71993,55.62147,1.86751),(.74396,55.66165,1.83128),(.71859,55.6236,1.85203),(.73669,55.63156,1.78875),(.74939,55.66301,1.80094),(.73127,55.62989,1.80067),(.75251,55.66322,1.79524),(.78325,55.63084,1.84641),(.76607,55.56443,1.90361),(.74721,55.61512,1.89532),(.74704,55.55587,1.92047),(.71294,55.56986,1.83701),(.70691,55.56484,1.86201),(.72323,55.6266,1.83259),(.7552,55.57902,1.76791),(.75581,55.63533,1.77967),(.79612,55.5753,1.85463),(.70899,55.56144,1.88122),(.70559,55.49892,1.8649),(.70902,55.4947,1.88912),(.73016,55.44354,1.83525),(.71294,55.50445,1.8361),(.72139,55.43825,1.86758),(.7681,55.51453,1.75919),(.75329,55.45126,1.76487),(.79107,55.4553,1.75378),(.77884,55.49853,1.91506),(.73421,55.37693,1.92227),(.72881,55.43233,1.91882),(.77102,55.383,1.94909),(.74364,55.38531,1.79656),(.73489,55.44825,1.79967),(.73895,55.3823,1.83097),(.80426,55.39811,1.74423),(.9631,55.68531,1.90896),(.95975,55.67961,1.91711),(.93569,55.673,1.9097),(.9279,55.678,1.89364),(.99744,55.35504,1.78875),(1.0173,55.357,1.80194),(.98971,55.42184,1.7964),(.99412,55.40492,2.04043),(.72856,55.37791,1.86736),(.73173,55.31491,1.86829),(.7648,55.39055,1.75759),(.77158,55.32738,1.74891),(.83757,55.70917,2.16707),(.8347,55.73579,2.13932),(.83537,55.73624,2.17186),(.83577,55.70947,2.12924),(.83826,55.62939,2.10929),(.84123,55.65289,2.16197),(.84274,55.62388,2.16169),(.83754,55.65612,2.1142),(.8466,55.70958,2.10971),(.92525,55.65803,2.11272),(.90016,55.63295,2.10386),(.92867,55.63121,2.11203),(.89816,55.65864,2.10461),(.9582,55.65391,2.15238),(.95643,55.68033,2.17713),(.95466,55.68249,2.15332),(.96033,55.65188,2.17638),(.94726,55.7129,2.15971),(.9447,55.68342,2.13198),(.93753,55.71325,2.13945),(.87901,55.68238,2.20941),(.90884,55.71085,2.21121),(.91636,55.67998,2.20838),(.87327,55.71134,2.21172),(.85654,55.62571,2.31204),(.84995,55.66372,2.31165),(.88446,55.62548,2.3063),(.82608,55.66866,2.36379),(.83744,55.66528,2.33681),(.82852,55.63258,2.36155),(.89853,55.71271,2.40872),(.92039,55.71311,2.39742),(.93839,55.63095,2.30715),(.86937,55.60748,2.42409),(.90385,55.64366,2.419),(.90805,55.60807,2.41819),(.86752,55.6423,2.42486),(.94289,55.5264,2.13949),(.94892,55.57613,2.13696),(.88605,55.54932,2.26545),(.7786,55.57905,2.21781),(.78694,55.54889,2.26118),(.7717,55.58181,2.2599),(.7931,55.55234,2.22138),(.64634,55.57612,2.1477),(.87666,55.57331,2.42281),(.90128,55.74168,2.21409),(.92894,55.74198,2.20461),(.8312,55.73823,2.38022),(.92094,55.64917,2.20735),(.92552,55.61846,2.20636),(.88255,55.65101,2.20916),(.84918,55.65709,2.09378),(.83683,55.68312,2.11921),(.84747,55.6829,2.09864),(.94872,55.65626,2.13115),(.9527,55.62905,2.13033),(.74704,55.71985,2.25232),(.74719,55.76737,2.26074),(.65222,55.7697,2.25366),(.66269,55.71876,2.28727),(.63401,55.71749,2.25411),(.67544,55.7691,2.28509),(.66396,55.71553,2.1451),(.66312,55.76974,2.17136),(.6483,55.71774,2.1618),(.67134,55.76915,2.16405),(.73187,55.71777,2.16399),(.74755,55.76653,2.20364),(.73169,55.76903,2.17355),(.74399,55.71894,2.18985),(.892,55.81033,2.20192),(.87742,55.80986,2.19813),(.75281,55.6522,2.25535),(.75119,55.7198,2.22196),(.75883,55.65225,2.21608),(.69716,55.7132,2.13751),(.71691,55.7154,2.14897),(.66167,55.64377,2.13195),(.66523,55.57361,2.1317),(.63993,55.64457,2.14952),(.8432,55.62884,2.33671),(.91463,55.62586,2.30082),(.91798,55.58668,2.28939),(.73002,55.83675,2.25136),(.87706,55.80219,2.33832),(.87824,55.8023,2.32461),(.87103,55.80156,2.34272),(.87881,55.79263,2.36198),(.86397,55.8008,2.3424),(.71573,55.43298,2.09691),(.75152,55.43735,2.09219),(.88993,55.58705,2.29773),(.96423,55.62332,2.17566),(.95803,55.62064,2.19779),(.88238,55.53745,2.41118),(.91642,55.45996,2.38481),(.88231,55.45698,2.38782),(.91708,55.53774,2.40688),(.97208,55.45605,2.25026),(.97322,55.45913,2.20922),(.65996,55.42724,2.19046),(.73155,55.43648,2.30517),(.7881,55.54076,2.31874),(.78253,55.5575,2.17306),(.75126,55.76695,2.22153),(.83976,55.68218,2.16233),(.86938,55.71035,2.10722),(.87211,55.68389,2.09613),(.91111,55.74072,2.13118),(.93034,55.74306,2.14701),(.96789,55.46405,2.18268),(.89057,55.7387,2.12463),(.93756,55.71102,2.20176),(.94041,55.74316,2.18709),(.94843,55.71173,2.18207),(.81688,55.51723,2.26623),(.84603,55.70044,2.3098),(.63635,55.71705,2.1929),(.65399,55.76913,2.20429),(.65203,55.76917,2.22431),(.90019,55.67863,2.41454),(.72767,55.79759,2.29129),(.96382,55.46489,2.15718),(.95427,55.46724,2.13645),(.96676,55.40414,2.14967),(.96031,55.45347,2.32324),(.96108,55.3836,2.31618),(.70643,55.83936,2.20949),(.83939,55.65856,2.60917),(.83689,55.65874,2.61447),(.8332,55.6597,2.59935),(.8283,55.65966,2.6185),(.83312,55.65913,2.61768),(.77004,55.66279,2.58364),(.7817,55.66759,2.5995),(.76757,55.66287,2.59421),(.78322,55.66749,2.59294),(.79548,55.65858,2.5802),(.79544,55.66555,2.58927),(.78823,55.65983,2.5776),(.84865,55.64958,2.61665),(.85252,55.64942,2.6081),(.82555,55.63988,2.62263),(.83564,55.65075,2.62277),(.8352,55.63842,2.62367),(.77867,55.65983,2.60799),(.79235,55.64513,2.61549),(.77306,55.64846,2.60838),(.76485,55.6533,2.56777),(.76005,55.65385,2.57239),(.77311,55.66232,2.58069),(.84516,55.64017,2.57938),(.83969,55.65183,2.5919),(.83551,55.60722,2.62055),(.84509,55.6372,2.62228),(.85012,55.60575,2.6184),(.77929,55.61803,2.6113),(.75539,55.62306,2.60183),(.8274,55.64275,2.57571),(.82461,55.61051,2.54956),(.81306,55.64493,2.57223),(.87221,55.60437,2.59106),(.85864,55.63628,2.60527),(.87296,55.6046,2.57936),(.86333,55.60478,2.60804),(.88048,55.55835,2.57966),(.79368,55.58478,2.61636),(.823,55.6111,2.62012),(.82357,55.57316,2.6186),(.79841,55.61341,2.61632),(.73589,55.63101,2.57411),(.7398,55.62896,2.59194),(.86429,55.60734,2.55969),(.85522,55.57002,2.5343),(.84974,55.60988,2.5555),(.89076,55.49257,2.56812),(.76937,55.53048,2.61324),(.81265,55.50918,2.61597),(.69282,55.54559,2.48407),(.68123,55.55246,2.49779),(.74589,55.52507,2.47432),(.7756,55.45623,2.46573),(.74238,55.45987,2.45533),(.88296,55.44317,2.5003),(.8982,55.44168,2.54),(.83015,55.4424,2.61556),(.85758,55.43877,2.61251),(.83689,55.49964,2.61712),(.69803,55.54406,2.58659),(.70315,55.47514,2.59225),(.65529,55.47979,2.57023),(.73781,55.53639,2.60415),(.65,55.47455,2.45242),(.63616,55.47599,2.4659),(.64922,55.40123,2.42044),(.63409,55.40157,2.43436),(.66495,55.47054,2.43834),(.76836,55.39624,2.45114),(.73192,55.39853,2.43953),(.87899,55.38946,2.48844),(.89517,55.38681,2.53207),(.84886,55.38498,2.61107),(.82106,55.38624,2.6139),(.69383,55.40145,2.58437),(.64026,55.40565,2.55996),(.61931,55.40136,2.44812),(.73384,55.34889,2.42403),(.88169,55.34624,2.47105),(.89656,55.34433,2.51876),(.64333,55.43635,3.02421),(.65979,55.39201,3.05896),(.64221,55.44258,3.06112),(.45642,55.3765,2.86395),(.45763,55.41961,3.08968),(.48564,55.43004,3.12332),(.46446,55.3528,3.07974),(.63374,55.44568,3.0865),(.62125,55.44644,3.10434),(.65283,55.39307,3.0806),(.51393,55.86688,3.00835),(.52146,55.86674,3.00065),(.51666,55.84521,2.92985),(.50939,55.88215,2.91456),(.50628,55.84266,2.92113),(.52419,55.89516,2.95328),(.53422,55.86343,2.97205),(.44975,55.88113,2.93507),(.45537,55.85166,2.97593),(.45804,55.88536,2.95804),(.4856,55.92294,2.94534),(.49913,55.92341,2.9341),(.49795,55.92406,2.9393),(.51567,55.91473,2.94),(.48946,55.64927,3.10568),(.50944,55.65452,3.11619),(.4239,55.62211,3.01072),(.50192,55.57638,2.8916),(.47893,55.60854,2.8908),(.60003,55.61639,3.03442),(.57734,55.64313,2.99635),(.58741,55.60568,2.99051),(.58848,55.65191,3.03427),(.5633,55.62244,3.10968),(.56739,55.6601,3.09035),(.57984,55.62333,3.0937),(.55446,55.65998,3.10528),(.48787,55.81152,3.05093),(.48305,55.86283,3.01338),(.49093,55.78822,2.91825),(.52359,55.84998,2.94011),(.53842,55.80415,2.96825),(.52903,55.85536,2.95299),(.52993,55.79995,2.95216),(.53807,55.81496,3.02623),(.44705,55.74231,3.01968),(.4378,55.73475,2.98997),(.45478,55.79746,3.00288),(.5063,55.79199,2.92707),(.55799,55.7586,3.0164),(.5467,55.74944,2.9767),(.54624,55.81028,2.99464),(.41676,55.56856,2.92384),(.41248,55.57319,2.95633),(.51143,55.49891,2.87749),(.44435,55.6756,3.03944),(.46661,55.64179,3.0851),(.44701,55.63396,3.05876),(.46233,55.68348,3.0679),(.42771,55.66606,2.99827),(.56391,55.68543,2.99164),(.57528,55.69436,3.0304),(.549,55.76354,3.0502),(.56448,55.69921,3.06751),(.5396,55.50647,2.89544),(.52454,55.70015,3.10318),(.53437,55.6588,3.11718),(.57798,55.65844,3.07342),(.57182,55.69755,3.0488),(.58576,55.65675,3.05464),(.51929,55.88906,2.93584),(.51428,55.88541,2.92412),(.41921,55.60793,2.92656),(.56185,55.63449,2.96182),(.59877,55.61982,3.05664),(.60969,55.55208,3.0893),(.5913,55.62281,3.07898),(.61715,55.54929,3.0677),(.53963,55.62157,3.1254),(.55839,55.55347,3.13622),(.45335,55.52607,3.08458),(.44636,55.59763,3.06934),(.42934,55.4864,2.88673),(.45504,55.41671,2.86489),(.43202,55.41604,2.88431),(.5767,55.44417,2.91376),(.54913,55.43494,2.88794),(.565,55.51417,2.91912),(.63218,55.4822,3.06501),(.62044,55.54437,3.03852),(.63386,55.47626,3.03122),(.57249,55.48588,3.14166),(.53381,55.48138,3.14663),(.58039,55.4483,3.14151),(.45731,55.45693,3.08913),(.42436,55.40188,3.02327),(.51681,55.42645,2.86725),(.61588,55.46275,2.98328),(.62364,55.42212,2.97798),(.60629,55.44679,3.12417),(.71049,55.77262,2.85836),(.7158,55.7867,2.84739),(.73566,55.7611,2.80938),(.71969,55.77247,2.81223),(.71637,55.75935,2.8077),(.73417,55.77288,2.81365),(.74179,55.758,2.8652),(.74609,55.75779,2.8597),(.71572,55.75392,2.87466),(.59698,55.77265,2.72653),(.5924,55.75893,2.77089),(.59342,55.7737,2.76735),(.73873,55.73455,2.80599),(.71426,55.73174,2.80429),(.75638,55.73191,2.86267),(.76133,55.73172,2.85358),(.73711,55.75792,2.86974),(.73981,55.73227,2.88215),(.54171,55.76598,2.74601),(.5639,55.76082,2.71321),(.60179,55.7561,2.75441),(.59855,55.72685,2.76202),(.60025,55.75767,2.7396),(.72517,55.79028,2.83524),(.72564,55.7897,2.84489),(.71769,55.78975,2.84232),(.73313,55.79071,2.82794),(.73496,55.7903,2.83253),(.57745,55.79498,2.7488),(.72925,55.7911,2.82348),(.72317,55.78552,2.81681),(.73272,55.78496,2.81805),(.72311,55.79147,2.82255),(.64631,55.55361,2.77047),(.6291,55.5538,2.79506),(.52275,55.42523,2.68259),(.5266,55.37133,2.67337),(.5066,55.42565,2.70403),(.59523,55.52454,2.67107),(.60443,55.47279,2.65119),(.66839,55.42123,2.65312),(.62113,55.42066,2.63331),(.78927,55.4702,2.85258),(.77799,55.52506,2.8555),(.8224,55.41614,2.80092),(.81505,55.41656,2.82411),(.76928,55.36405,2.88068),(.77937,55.41756,2.87315),(.78772,55.36352,2.86827),(.762,55.41803,2.88459),(.70228,55.41959,2.91423),(.66127,55.36699,2.8883),(.65386,55.42108,2.88925),(.7065,55.36562,2.91033),(.50961,55.37178,2.78789),(.50758,55.42551,2.79537),(.50966,55.47933,2.79995),(.74735,55.66763,2.89453),(.74582,55.73228,2.87627),(.75548,55.66741,2.88672),(.76147,55.73152,2.83868),(.77643,55.66601,2.83932),(.76376,55.59883,2.88074),(.75588,55.5996,2.88988),(.76746,55.52535,2.8685),(.49812,55.66756,2.73095),(.51995,55.73258,2.73687),(.61495,55.59934,2.76465),(.50846,55.66445,2.77375),(.77298,55.59769,2.80632),(.77711,55.52018,2.78306),(.78625,55.59732,2.83247),(.5476,55.60106,2.68521),(.5143,55.66709,2.70296),(.50529,55.66701,2.71515),(.59835,55.66388,2.76067),(.59751,55.59988,2.78987),(.58095,55.66557,2.7843),(.74179,55.78393,2.83224),(.74734,55.77288,2.83351),(.57154,55.77543,2.71956),(.50143,55.60227,2.73042),(.76807,55.66607,2.82022),(.74686,55.60045,2.89849),(.73574,55.6676,2.9019),(.74466,55.66638,2.80048),(.74428,55.59842,2.78502),(.69583,55.47364,2.9135),(.53806,55.42484,2.66123),(.57206,55.42392,2.63767),(.79951,55.41707,2.84548),(.74911,55.41838,2.89828),(.27133,55.76176,3.05695),(.27468,55.75849,3.06824),(.269,55.75577,3.06448),(.2759,55.764,3.05993),(.2888,55.762,3.06809),(.28594,55.76597,3.05737),(.29229,55.7613,3.06362),(.28406,55.76627,3.05981),(.29264,55.75447,3.04322),(.28387,55.75982,3.04027),(.29005,55.75209,3.03788),(.28568,55.76154,3.04402),(.27371,55.7435,3.02427),(.26759,55.75196,3.02982),(.2681,55.74219,3.02376),(.27034,55.75265,3.02969),(.26284,55.75252,3.03562),(.25782,55.74617,3.04323),(.2579,55.74358,3.03479),(.26278,55.75418,3.04089),(.24879,55.67605,3.01436),(.26181,55.74224,3.02749),(.2391,55.67546,3.02019),(.2945,55.69626,3.0405),(.28651,55.74962,3.03324),(.28647,55.69094,3.03054),(.29491,55.76,3.0578),(.2987,55.71278,3.08793),(.30364,55.71067,3.07745),(.26547,55.70689,3.09645),(.27776,55.75982,3.06982),(.25432,55.70155,3.08933),(.26212,55.64887,3.11304),(.24907,55.64186,3.10236),(.22308,55.61797,3.04933),(.23161,55.67771,3.03356),(.23179,55.6827,3.04927),(.22396,55.61235,3.03058),(.27395,55.6195,3.01166),(.25906,55.67847,3.01404),(.25771,55.61339,3.00589),(.27339,55.68413,3.02013),(.31451,55.64917,3.07026),(.29933,55.70072,3.05038),(.31023,55.64247,3.05303),(.30218,55.7055,3.06283),(.2921,55.71379,3.09622),(.30005,55.65911,3.11301),(.22781,55.62544,3.06896),(.23457,55.57802,3.10037),(.22248,55.56752,3.07768),(.23705,55.63376,3.08726),(.24095,55.54747,2.99874),(.23075,55.60943,3.01549),(.22594,55.54693,3.00947),(.24264,55.60984,3.00697),(.31525,55.57951,3.03741),(.2892,55.62703,3.02253),(.2999,55.56973,3.01982),(.30165,55.63493,3.03677),(.3245,55.60818,3.11812),(.31421,55.6546,3.08732),(.33071,55.60381,3.09952),(.3091,55.65806,3.10228),(.32788,55.55252,3.15475),(.34053,55.55045,3.13794),(.31198,55.6093,3.13205),(.22927,55.51349,3.11723),(.21671,55.50211,3.0923),(.23975,55.47598,2.99079),(.22108,55.47485,3.00273),(.33101,55.51668,3.04209),(.31436,55.50572,3.02198),(.35226,55.47755,3.06996),(.34158,55.46774,3.0486),(.34111,55.52587,3.06208),(.33833,55.50601,3.16878),(.35177,55.50384,3.15093),(.25274,55.52779,3.14186),(.28235,55.49102,3.16998),(.25814,55.47941,3.1547),(.27539,55.53857,3.15601),(.20907,55.43818,3.0679),(.2064,55.47953,3.02983),(.20682,55.48959,3.06133),(.20855,55.42727,3.03391),(.29555,55.44113,3.00457),(.25966,55.48084,2.98974),(.26537,55.42896,2.99167),(.28787,55.49198,3.00128),(.33577,55.40635,3.02999),(.30579,55.39056,3.00614),(.3239,55.45598,3.02702),(.37603,55.45241,3.13768),(.35862,55.48808,3.09699),(.3724,55.44046,3.10427),(.36207,55.49934,3.12848),(.29522,55.49664,3.17633),(.31972,55.45468,3.19186),(.30506,55.4495,3.18837),(.30906,55.50152,3.17961),(.21969,55.45173,3.10134),(.23921,55.41476,3.13713),(.22515,55.40178,3.10875),(.23303,55.46396,3.12807),(.24419,55.4236,2.99242),(.23032,55.3705,3.00657),(.25148,55.3719,2.99324),(.22427,55.4223,3.00499),(.2821,55.3249,2.99681),(.25867,55.3189,2.99764),(.27388,55.37762,2.99245),(.37803,55.37913,3.08383),(.35445,55.41885,3.05291),(.36628,55.36819,3.0601),(.36572,55.42927,3.07557),(.36223,55.41085,3.19353),(.36506,55.45717,3.16148),(.37719,55.40842,3.17374),(.35079,55.45947,3.1804),(.26576,55.43118,3.16539),(.30006,55.39415,3.1948),(.2732,55.3812,3.17779),(.29142,55.44353,3.18163),(.24545,55.36397,3.1482),(.2365,55.31744,3.0116),(.21892,55.323,3.04365),(.31545,55.3385,3.01114),(.34677,55.35507,3.0361),(.38497,55.39088,3.11388),(.38873,55.40342,3.14885),(.31434,55.40042,3.20185),(.33762,55.36693,3.21497),(.32205,55.36144,3.21127),(.32968,55.40584,3.20551),(.05244,55.7642,3.09464),(.05294,55.75716,3.08585),(.05762,55.75864,3.08941),(.05056,55.76344,3.09257),(.04425,55.76504,3.10378),(.03844,55.75903,3.10408),(.0518,55.76515,3.11962),(.05552,55.76526,3.11787),(.05011,55.76758,3.11066),(.04666,55.7352,3.14343),(.04084,55.73414,3.14277),(.03096,55.72506,3.11191),(.03988,55.75792,3.09786),(.03394,55.72298,3.09909),(.05981,55.72104,3.07487),(.05111,55.71962,3.07463),(.07239,55.73718,3.13469),(.07719,55.69589,3.17021),(.08894,55.69589,3.16238),(.06515,55.73724,3.13976),(.03482,55.73233,3.13914),(.03957,55.72029,3.08577),(.02813,55.6738,3.1064),(.03817,55.66895,3.08326),(.08394,55.67508,3.07791),(.06878,55.67001,3.06629),(.0691,55.72411,3.08196),(.11444,55.62313,3.10089),(.10086,55.6144,3.0727),(.09384,55.68114,3.09719),(.10747,55.64317,3.19004),(.09731,55.69309,3.14929),(.11898,55.63942,3.17259),(.04913,55.63806,3.20786),(.04718,55.69242,3.17582),(.01709,55.61597,3.13868),(.02344,55.6766,3.12602),(.02282,55.6136,3.11459),(.0787,55.60712,3.05639),(.05554,55.66788,3.0661),(.06188,55.60449,3.0565),(.11557,55.55624,3.06975),(.08953,55.54748,3.04974),(.13737,55.58746,3.1929),(.11894,55.63557,3.14847),(.13974,55.58278,3.1641),(.08467,55.59152,3.23982),(.05185,55.58584,3.23832),(.07816,55.64327,3.21007),(.0344,55.60719,3.08463),(.02007,55.5543,3.11931),(.0344,55.5465,3.08153),(.04283,55.54395,3.0665),(.03497,55.48861,3.08015),(.04327,55.4857,3.06302),(.14974,55.51261,3.10585),(.12998,55.50008,3.06574),(.13244,55.56673,3.1032),(.13867,55.54218,3.2377),(.15633,55.53767,3.21188),(.12354,55.59194,3.21538),(.05356,55.53469,3.26416),(.03907,55.53204,3.26298),(.02023,55.52734,3.2562),(.04041,55.48237,3.28537),(.01976,55.47682,3.27645),(.0167,55.44426,3.13072),(.03625,55.43373,3.08084),(.01709,55.4982,3.12515),(.14193,55.44667,3.06542),(.09878,55.48963,3.04199),(.10783,55.43513,3.03911),(.17074,55.48881,3.22802),(.15694,55.53106,3.17721),(.17244,55.48128,3.18974),(.10072,55.49313,3.28899),(.05772,55.4856,3.28695),(.09391,55.54187,3.26662),(.06293,55.43682,3.31081),(.04062,55.4325,3.30815),(.00468,55.3983,3.18862),(.01634,55.39019,3.13739),(.00624,55.45034,3.17508),(.11608,55.38135,3.03999),(.07859,55.43043,3.03876),(.0831,55.37595,3.03908),(.18492,55.43092,3.20361),(.17231,55.47165,3.15093),(.18531,55.42064,3.16019),(.1818,55.43967,3.24429),(.19353,55.37253,3.21531),(.10999,55.38606,3.32815),(.10523,55.44385,3.31113),(.00465,55.41237,3.24847),(.05305,55.31477,3.06549),(.05069,55.37585,3.06077),(.19401,55.36175,3.16978),(.17567,55.40826,3.1144),(.84621,56.71783,2.23898),(.76243,56.73282,2.33692),(.72971,56.75099,2.24832),(.84311,55.80284,1.75936),(.71471,56.43942,2.73798),(.83631,55.7957,1.90848),(.95317,56.64237,2.48723),(.70518,55.80702,1.5612),(1.01982,56.62268,2.15852),(.79516,56.71466,2.42552),(.66775,56.75856,2.32874),(.61211,56.79509,2.13121),(.63905,56.77329,2.23931),(.49088,56.86022,2.16278),(.96977,56.64973,2.38541),(1.2462,56.43709,2.01049),(1.08676,56.54453,2.57434),(1.13941,56.55399,2.56453),(1.08952,56.55115,2.53202),(1.00182,56.61727,2.46747),(1.06694,56.57454,2.63988),(1.03745,56.23183,1.5093),(.96879,56.25285,1.42782),(.77794,56.22216,1.34596),(.86988,56.26279,1.36007),(.48514,56.85697,2.16389),(.83412,56.72942,2.12187),(1.12405,56.04477,1.72167),(1.23219,56.27663,1.97531),(1.17352,56.23185,2.44993),(.87311,56.56215,2.63358),(1.04719,55.7871,2.30216),(.15178,55.39356,3.06808),(.04072,55.31825,3.08884),(.03891,55.37915,3.08297),(.01975,55.36711,3.31123),(.01897,55.42577,3.29497),(.13431,55.44505,3.29642),(.14044,55.38732,3.31271),(.15148,55.49365,3.25694),(.1627,55.44485,3.27644),(.12512,55.49357,3.27428),(.16389,55.46051,3.10947),(.04658,55.43056,3.06117),(.00583,55.46395,3.23194),(.11456,55.54196,3.25306),(.15725,55.52252,3.1428),(.07304,55.48551,3.04183),(.00791,55.50306,3.16367),(.00736,55.51557,3.21548),(.01208,55.55893,3.15297),(.01175,55.56926,3.19613),(.06609,55.69566,3.17658),(.09926,55.69082,3.13233),(.0978,55.68602,3.11536),(.06072,55.76042,3.09514),(.07534,55.72778,3.09353),(.04266,55.71953,3.08018),(.03093,55.72867,3.127),(.05759,55.73696,3.1435),(.04522,55.76427,3.09979),(.05491,55.76608,3.10109),(.28684,55.7635,3.04908),(.28731,55.76535,3.05422),(.26508,55.7518,3.03146),(.26455,55.75666,3.04708),(.26685,55.75889,3.05196),(.27548,55.7548,3.03196),(.2807,55.75764,3.03627),(.27813,55.76499,3.06105),(.27977,55.76559,3.06141),(.37066,55.372,3.20283),(.38682,55.33979,3.09165),(.28973,55.2847,3.00352),(.22582,55.29521,3.08921),(.21925,55.3352,3.08135),(.21402,55.38737,3.07326),(.2308,55.35033,3.11849),(.2136,55.37577,3.03722),(.3502,55.54621,3.11684),(.28029,55.55995,3.00561),(.21714,55.55072,3.02893),(.25039,55.58832,3.11911),(.32548,55.58858,3.05698),(.25959,55.552,2.99774),(.21614,55.558,3.05296),(.26667,55.59695,3.13207),(.2367,55.6889,3.06466),(.26012,55.7493,3.05136),(.2428,55.69448,3.077),(.26316,55.75217,3.05791),(.28134,55.76103,3.07072),(.29416,55.75704,3.04985),(.28043,55.7463,3.02786),(.7895,55.41733,2.85919),(.78001,55.47139,2.86523),(.72334,55.41904,2.91417),(.76237,55.66702,2.87871),(.57683,55.60023,2.68464),(.58689,55.79477,2.747),(.74416,55.77199,2.82395),(.73917,55.78451,2.82478),(.70099,55.75321,2.86867),(.68679,55.7524,2.84972),(.71456,55.78554,2.82061),(.70745,55.77247,2.818),(.74611,55.52506,2.75681),(.59988,55.40685,2.8566),(.7175,55.79167,2.82534),(.57793,55.79501,2.74108),(.59425,55.75803,2.72108),(.542,55.76586,2.73737),(.75344,55.75805,2.835),(.69932,55.75769,2.81502),(.74916,55.75884,2.82311),(.6875,55.75617,2.83173),(.39932,55.38867,2.96924),(.50867,55.47611,3.13914),(.60315,55.53183,2.98641),(.47833,55.53589,3.11429),(.46787,55.60574,3.09648),(.45898,55.90517,2.92444),(.5702,55.59571,2.95236),(.5859,55.52262,2.9487),(.51264,55.76279,3.07703),(.49091,55.92394,2.94592),(.50229,55.86634,3.01545),(.60152,55.38982,3.14462),(.42497,55.33677,3.01261),(.60594,55.41276,2.94352),(.4748,55.91841,2.92802),(.49386,55.92414,2.94414),(.73466,55.39722,2.59835),(.87428,55.38419,2.59036),(.8575,55.3467,2.46092),(.85518,55.39035,2.47836),(.71293,55.34912,2.41426),(.71082,55.39887,2.42976),(.62218,55.47919,2.51132),(.60428,55.40219,2.49631),(.74286,55.46198,2.60274),(.8809,55.43587,2.59307),(.86165,55.44472,2.49047),(.72293,55.46042,2.44663),(.73009,55.53023,2.46811),(.70307,55.46318,2.43766),(.86411,55.50753,2.51122),(.74097,55.60374,2.51126),(.70446,55.53969,2.47108),(.74486,55.60326,2.60006),(.83753,55.56572,2.61783),(.82278,55.57459,2.53008),(.7513,55.62781,2.53471),(.76998,55.65257,2.56338),(.76036,55.65107,2.60182),(.7806,55.65038,2.56325),(.75619,55.65313,2.58924),(.80587,55.64301,2.61938),(.85297,55.63633,2.61607),(.84287,55.65003,2.62168),(.78744,55.66687,2.58929),(.77645,55.66184,2.57775),(.76949,55.66203,2.6021),(.78523,55.66717,2.59114),(.88807,55.39169,2.10485),(.85792,55.80776,2.18543),(.84725,55.80621,2.18632),(.84989,55.80494,2.20373),(.93373,55.71093,2.373),(.91438,55.57314,2.41464),(.94819,55.53338,2.38678),(.96125,55.52572,2.3432),(.85554,55.68206,2.19296),(.85225,55.71003,2.1952),(.93983,55.74334,2.16617),(.92353,55.58308,2.2138),(.924,55.57985,2.11852),(.88701,55.58175,2.11025),(.70076,55.76864,2.15456),(.70093,55.80418,2.17141),(.72072,55.7679,2.16379),(.70251,55.83256,2.19298),(.87378,55.80179,2.3184),(.92862,55.64179,2.40466),(.92313,55.67771,2.40167),(.96173,55.62526,2.15144),(.87486,55.65859,2.09474),(.8574,55.65115,2.19408),(.83971,55.79238,2.19395),(.83452,55.76395,2.17939),(.82791,55.70478,2.38924),(.93638,55.66895,2.31135),(.94614,55.68001,2.199),(.92179,55.68488,2.11346),(.91645,55.71285,2.12229),(.95208,55.65034,2.19837),(.7542,55.38817,1.77653),(.75975,55.3244,1.77156),(.73225,55.37653,1.89491),(.86218,55.39007,2.00804),(1.017,55.40857,2.03311),(1.04337,55.35776,1.84912),(.75693,55.66514,1.83797),(.75445,55.66493,1.83749),(.76195,55.66591,1.83618),(.74427,55.45054,1.78193),(.72509,55.43515,1.89298),(.71128,55.5569,1.90001),(.71294,55.49083,1.91231),(.81342,55.51676,1.79577),(.71622,55.57126,1.81186),(.71641,55.50821,1.8061),(.72595,55.62832,1.81312),(.72145,55.61881,1.88291),(.73188,55.55544,1.92128),(.73121,55.61732,1.89501),(.76974,55.58065,1.77247),(.74672,55.66244,1.80617),(.74451,55.65956,1.83949),(.93355,55.46161,1.78062),(1.0014,55.53629,1.84413),(.90397,55.56329,1.86043),(.89928,55.56096,1.83959),(.98418,55.58205,1.84743),(.97287,55.63227,1.86477),(.96712,55.65269,1.8759),(.96163,55.64225,1.91873),(.97978,55.62609,1.91019),(1.00681,55.44609,2.03893),(.83027,55.42512,2.0021),(.99228,55.49327,2.04533),(.82594,55.5157,2.00896),(.96099,55.53535,2.05126),(.91759,55.60412,2.03139),(.94408,55.60541,2.04009),(.96542,55.65906,2.01211),(.96961,55.67486,1.99319),(.97062,55.67598,1.98249),(.85025,55.3383,1.74144),(.75129,55.66032,1.84602),(.75795,55.65965,1.84658),(.9103,55.51507,1.87178),(.9163,55.51454,1.87764),(.88577,55.5452,1.94942),(.75757,55.66862,1.80204),(.75233,55.66487,1.83527),(.75396,55.66748,1.80968),(.94369,55.68314,1.97792),(.93417,55.68188,1.98394),(.93148,55.67877,1.99126),(.8275,55.4799,1.9652),(.84731,55.48944,1.94739),(.91803,55.54932,1.95635),(.78348,55.57095,1.88164),(1.10125,55.46573,1.68503),(.78921,55.37995,1.55905),(.78189,55.43275,1.57421),(.8971,55.49052,1.54208),(.78285,55.48116,1.59015),(.90002,55.48627,1.70902),(.99696,55.5014,1.50728),(1.02049,55.50285,1.50447),(1.09117,55.51124,1.70262),(1.02911,55.54632,1.64405),(.8894,55.53098,1.56023),(.78952,55.56372,1.5979),(.99817,55.54831,1.5181),(.93655,55.60822,1.70656),(1.02534,55.62248,1.71471),(1.07216,55.58988,1.55544),(.94864,55.60553,1.5987),(1.01633,55.64378,1.65104),(.81233,55.63029,1.6224),(.97768,55.68941,1.65891),(.90623,55.69144,1.60423),(.95063,55.45036,1.58788),(.98312,55.45468,1.61268),(.97963,55.67966,1.62144),(.94721,55.62965,1.60395),(.96012,55.50419,1.58454),(1.01056,55.63969,1.64554),(.98488,55.6782,1.63052),(.97783,55.58122,1.61339),(1.02513,55.41713,1.61567),(.98682,55.41429,1.61976),(1.02608,55.41721,1.6153),(.98548,55.41421,1.62074),(.95153,55.57331,1.65063),(.94701,55.62966,1.58721),(1.00523,55.67399,1.60804),(.98108,55.57628,1.64795),(1.01525,55.4568,1.623),(1.08597,55.51081,1.59429),(.14432,55.35359,3.32228),(.38586,55.36954,3.18277),(.37494,55.32868,3.0676),(.26598,55.27861,3.00438),(.26692,55.27307,3.0054),(.23744,55.31059,3.12683),(.24372,55.2685,3.13629),(.34393,55.33189,3.22383),(.32775,55.32553,3.2201),(.73172,55.31218,2.66571),(.73256,55.2789,2.66228),(.79858,55.36324,2.8534),(.79996,55.33825,2.85002),(.41719,55.30308,2.90575),(.46791,55.31843,3.07735),(.60334,55.37237,3.14326),(.66256,55.36403,3.05594),(.52228,55.30601,2.86937),(.89145,55.34333,2.5449),(.6032,55.34667,2.49032),(.73759,55.27488,2.59339),(.62759,55.29033,2.41147),(.69642,55.2787,2.38792),(.71746,55.28036,2.39768),(.664,55.2984,2.15679),(.80062,55.3655,2.33543),(.80702,55.28157,2.33883),(.97334,55.31871,2.1437),(1.03624,55.3585,1.81999),(1.02903,55.30037,1.79095),(.90555,55.36029,1.48299),(.00437,55.76895,2.73205),(.25237,55.74344,1.95723),(.11555,55.73782,1.94479),(.00443,55.76408,2.44477),(.21772,55.75894,1.74619),(.19408,55.77284,1.95205),(.25609,55.88905,2.87456),(.24253,55.87761,2.78217),(.31544,56.87989,3.00865),(.87925,56.80283,1.58357),(.72714,56.87112,1.79939),(.9664,56.49785,2.70026),(1.42016,56.75847,2.30467),(.96884,56.72328,2.12693),(.96845,56.71863,2.12158),(.54069,56.77776,2.8329),(.54327,56.60742,2.8259),(.8561,56.51366,2.75482),(.25999,55.89774,3.00697),(.89393,56.78929,1.77119),(.89012,56.79343,1.77231),(0,55.82926,1.94263),(0,55.9755,2.61376),(.03844,55.9597,2.61712),(.02623,55.92757,2.425),(.2157,55.75326,1.75219),(.05987,55.76405,2.60082),(0,55.76126,2.18315),(0,55.76899,2.4451),(.26646,55.2716,3.00325),(.79091,55.33662,1.52676),(1.0653,55.31708,1.99493),(.71844,55.32284,1.79114),(.74298,55.28446,1.78171),(.36397,55.30027,2.9012),(.13357,55.49966,3.32588),(.60295,55.37201,3.14473),(.82755,55.3683,2.8149),(.56911,55.45013,2.52185),(.6813,55.41163,1.84526),(0,55.37878,3.14865),(.39435,55.30198,3.09979),(.83645,55.29072,2.45069),(.95198,55.32603,2.3545),(.75789,55.28632,1.75749),(.51741,55.38223,2.63094),(.5652,55.3813,2.49886),(.65597,55.51542,3.1035),(.28346,56.97869,2.99396),(.60814,55.78551,3.04049),(1.1169,55.38582,1.58431),(1.07331,55.31537,1.93173),(.7735,55.27111,2.65177),(.73599,55.28192,2.40621),(.39539,55.2928,2.9264),(.37773,55.33501,3.21203),(.1126,55.35539,3.33732),(0,55.57759,2.97265),(1.09309,55.35735,1.94585),(0,55.77642,2.58939),(.00434,55.77122,2.58974),(.3605,55.77108,1.80522),(.88294,56.79887,1.58334),(.46555,56.69545,1.48371),(1.00883,56.70692,2.10265),(1.07803,56.62388,2.80207),(.35771,55.81062,2.21007),(1.04551,55.40317,1.50329),(.97086,55.40151,2.17597),(.942,55.38242,2.3559),(.30756,55.35509,3.20412),(1.06494,55.42013,1.61099),(.94613,55.64894,1.59951),(.96095,55.5452,1.56041),(.97191,55.54635,1.53937),(.99073,55.54769,1.52274),(.99228,55.45436,1.61513),(1.00251,55.66854,1.64484),(.99716,55.67526,1.67944),(1.01307,55.64999,1.69624),(1.03226,55.58744,1.73604),(.89032,55.57065,1.70882),(1.07904,55.55422,1.54544),(.89628,55.53116,1.71108),(.78398,55.52551,1.60111),(1.04838,55.45085,1.50042),(.78606,55.4333,1.55656),(.79945,55.51788,1.77459),(.89804,55.51449,1.8482),(.94179,55.51984,1.88923),(.9493,55.6841,1.97944),(.97275,55.62005,1.98003),(.98097,55.42077,1.92037),(.94915,55.58522,1.96793),(.83764,55.5288,1.9761),(.87228,55.49721,1.93428),(.90835,55.63451,1.95905),(.75595,55.66811,1.80541),(.75119,55.6651,1.8316),(.98543,55.5779,1.89705),(.78809,55.51541,1.76594),(.82421,55.5169,1.99667),(.92551,55.67343,1.99687),(.95785,55.63843,2.02415),(.94254,55.57122,2.04922),(.97402,55.48688,2.05046),(.98589,55.44211,2.04496),(.84897,55.73808,2.19751),(.89333,55.71164,2.11501),(.91662,55.52918,2.12094),(.66835,55.53772,2.12845),(.71462,55.543,2.30514),(.86753,55.74034,2.21408),(.8961,55.68438,2.10542),(.63311,55.71705,2.22271),(.93061,55.46858,2.11794),(.94728,55.45859,2.36607),(.77459,55.59122,2.611),(.81881,55.51519,2.49842),(.8115,55.45042,2.47633),(.89583,55.43848,2.56117),(.80148,55.44569,2.61091),(.62788,55.48122,2.54804),(.6895,55.39921,2.42002),(.80456,55.39484,2.46276),(.89111,55.3856,2.5555),(.79324,55.38834,2.60932),(.60968,55.40571,2.53564),(.50748,55.81501,3.05268),(.51943,55.79605,2.93923),(.54359,55.81376,3.01532),(.55507,55.76175,3.03556),(.48498,55.46834,3.12218),(.48597,55.41993,2.85747),(.59876,55.45295,2.94511),(.62498,55.48456,3.08592),(.58649,55.77305,2.72114),(.55817,55.78001,2.76049),(.75648,55.73486,2.8245),(.75121,55.73174,2.86953),(.58134,55.75843,2.71581),(.58449,55.72996,2.78188),(.33072,55.59685,3.07815),(.34706,55.53569,3.08737),(.05414,55.7652,3.0978),(.04721,55.76346,3.09497),(.04261,55.75666,3.09138),(.02326,55.68257,3.15083),(.04142,55.66789,3.07592),(.11965,55.62979,3.12573),(.09005,55.64413,3.20258),(.01636,55.62506,3.17537),(.03987,55.60474,3.07256),(.06718,55.54389,3.04948),(.13902,55.57519,3.13468),(.1033,55.59186,3.22873),(.69476,56.7751,2.12452),(1.14572,56.58738,2.12105),(.93333,56.42551,1.43408)]))),
        Shape(DEF='maxr',
          appearance=Appearance(
            material=Material(ambientIntensity=0.098,diffuseColor=(1,.9765,.8667),emissiveColor=(0.8,0.8,0.8),shininess=0.050,specularColor=(.349,.349,.349))),
          geometry=IndexedFaceSet(DEF='maxr_Geo',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,6,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,19,18,29,-1,30,31,32,-1,33,34,22,-1,35,36,37,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,48,50,51,-1,52,53,54,-1,55,56,57,-1,58,59,60,-1,61,62,63,-1,52,64,65,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,36,35,-1,76,77,78,-1,24,79,80,-1,81,82,83,-1,26,59,84,-1,85,86,87,-1,66,84,59,-1,88,83,26,-1,49,89,90,-1,91,92,93,-1,94,95,96,-1,97,98,99,-1,76,35,37,-1,100,101,102,-1,101,103,104,-1,105,106,107,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,117,118,119,-1,118,120,121,-1,122,123,124,-1,125,122,126,-1,127,128,129,-1,130,123,121,-1,130,124,123,-1,131,132,133,-1,134,135,136,-1,137,132,138,-1,139,140,141,-1,142,143,144,-1,145,146,147,-1,148,149,150,-1,151,152,153,-1,154,155,156,-1,157,158,159,-1,156,160,161,-1,162,163,164,-1,165,166,167,-1,166,168,169,-1,109,170,171,-1,172,173,174,-1,175,176,177,-1,178,179,180,-1,179,181,182,-1,181,183,182,-1,184,185,186,-1,187,188,189,-1,190,191,192,-1,193,194,195,-1,196,197,198,-1,199,200,201,-1,202,203,204,-1,205,206,207,-1,208,209,210,-1,211,212,213,-1,214,215,216,-1,217,187,218,-1,219,220,221,-1,222,223,224,-1,225,226,227,-1,228,229,230,-1,231,232,233,-1,230,234,228,-1,235,236,237,-1,238,239,240,-1,241,242,243,-1,244,245,246,-1,247,248,249,-1,249,250,247,-1,251,252,253,-1,254,255,256,-1,257,258,259,-1,260,261,262,-1,263,264,265,-1,266,267,268,-1,269,270,271,-1,272,273,274,-1,275,276,277,-1,278,279,280,-1,281,282,283,-1,284,285,286,-1,287,288,289,-1,289,288,290,-1,291,292,293,-1,294,295,296,-1,297,298,299,-1,300,301,302,-1,303,304,305,-1,306,307,303,-1,296,308,309,-1,298,310,311,-1,312,313,314,-1,315,316,313,-1,196,317,318,-1,319,312,314,-1,101,320,103,-1,321,322,270,-1,267,281,323,-1,324,325,259,-1,326,327,165,-1,328,329,330,-1,331,332,227,-1,333,334,335,-1,336,337,338,-1,339,340,332,-1,341,342,343,-1,344,345,346,-1,347,348,349,-1,278,350,351,-1,352,353,354,-1,355,291,356,-1,357,358,359,-1,360,296,361,-1,261,260,362,-1,181,179,363,-1,364,365,366,-1,367,362,368,-1,369,370,371,-1,372,373,374,-1,375,376,355,-1,377,378,376,-1,274,273,271,-1,348,379,275,-1,253,380,381,-1,382,383,252,-1,384,385,386,-1,240,387,388,-1,389,390,344,-1,391,392,393,-1,333,394,140,-1,219,335,220,-1,395,396,397,-1,398,215,214,-1,399,400,401,-1,402,403,404,-1,405,406,407,-1,154,408,409,-1,154,409,410,-1,329,328,411,-1,412,413,414,-1,415,227,332,-1,146,416,223,-1,417,418,419,-1,420,421,422,-1,423,424,425,-1,426,427,428,-1,429,430,431,-1,432,433,434,-1,435,436,437,-1,438,439,440,-1,441,442,443,-1,422,444,445,-1,420,446,447,-1,448,449,450,-1,451,452,453,-1,454,455,456,-1,457,458,459,-1,458,460,459,-1,268,461,462,-1,463,464,465,-1,365,466,467,-1,468,356,357,-1,469,310,298,-1,470,260,471,-1,295,472,473,-1,295,361,296,-1,474,475,476,-1,477,242,386,-1,478,479,480,-1,481,482,483,-1,484,485,486,-1,186,487,488,-1,489,490,491,-1,492,493,494,-1,495,496,497,-1,498,499,500,-1,501,502,503,-1,504,505,506,-1,507,508,509,-1,509,510,507,-1,511,512,513,-1,514,515,516,-1,517,518,519,-1,520,521,522,-1,523,524,525,-1,526,527,528,-1,529,530,531,-1,532,533,534,-1,535,536,532,-1,216,215,537,-1,538,539,540,-1,541,542,543,-1,544,545,546,-1,541,547,548,-1,549,550,551,-1,542,552,553,-1,554,555,556,-1,556,557,558,-1,559,555,440,-1,560,561,562,-1,160,563,162,-1,564,565,566,-1,567,568,569,-1,570,571,572,-1,573,574,575,-1,576,577,578,-1,579,580,581,-1,582,583,584,-1,585,586,587,-1,588,589,578,-1,590,591,592,-1,593,594,595,-1,596,597,598,-1,599,600,596,-1,601,602,603,-1,604,605,606,-1,607,608,609,-1,582,610,611,-1,612,582,613,-1,603,614,615,-1,610,616,611,-1,617,618,608,-1,598,619,620,-1,621,622,623,-1,624,618,625,-1,626,617,627,-1,625,618,628,-1,629,630,631,-1,626,614,632,-1,633,634,635,-1,636,16,15,-1,637,638,633,-1,639,640,70,-1,641,637,642,-1,643,644,645,-1,646,630,647,-1,648,649,650,-1,643,645,635,-1,601,651,652,-1,32,653,654,-1,655,656,657,-1,70,658,659,-1,660,661,662,-1,663,664,661,-1,665,25,666,-1,667,668,669,-1,670,671,672,-1,673,674,675,-1,676,677,678,-1,679,678,677,-1,680,681,682,-1,683,684,685,-1,686,687,688,-1,689,690,10,-1,8,691,3,-1,692,673,689,-1,678,693,694,-1,695,696,697,-1,698,699,700,-1,701,702,703,-1,704,705,438,-1,706,707,708,-1,709,710,711,-1,712,713,714,-1,715,716,432,-1,717,427,423,-1,718,719,720,-1,429,716,715,-1,721,722,723,-1,724,725,726,-1,425,727,728,-1,434,729,730,-1,723,722,423,-1,731,732,733,-1,437,734,735,-1,447,446,736,-1,737,738,739,-1,740,741,742,-1,736,731,743,-1,744,745,746,-1,747,748,749,-1,735,750,751,-1,750,752,732,-1,753,436,435,-1,435,754,753,-1,755,420,756,-1,441,757,448,-1,758,759,760,-1,761,762,452,-1,763,764,765,-1,766,767,768,-1,769,770,771,-1,772,773,774,-1,775,776,777,-1,778,779,780,-1,770,769,781,-1,782,783,784,-1,785,786,787,-1,780,779,784,-1,788,763,789,-1,790,784,791,-1,707,792,793,-1,794,795,796,-1,797,798,799,-1,169,168,800,-1,801,802,803,-1,804,805,806,-1,807,808,809,-1,56,60,665,-1,810,811,44,-1,89,49,812,-1,663,813,814,-1,89,812,72,-1,815,816,817,-1,818,138,819,-1,125,118,121,-1,815,133,820,-1,821,138,822,-1,134,821,183,-1,823,180,824,-1,825,826,827,-1,813,661,828,-1,119,829,830,-1,831,832,129,-1,833,834,835,-1,836,834,837,-1,833,838,839,-1,840,841,842,-1,174,843,844,-1,703,702,845,-1,781,780,846,-1,847,848,849,-1,850,851,852,-1,766,853,854,-1,417,855,856,-1,721,710,857,-1,858,859,701,-1,860,797,859,-1,861,862,863,-1,700,864,698,-1,698,557,865,-1,666,654,866,-1,619,660,662,-1,867,868,869,-1,870,440,439,-1,871,872,873,-1,873,874,875,-1,876,560,808,-1,877,595,878,-1,879,590,880,-1,881,882,883,-1,884,885,886,-1,33,887,888,-1,25,889,655,-1,890,891,42,-1,22,21,33,-1,483,482,892,-1,648,34,893,-1,894,895,649,-1,629,622,896,-1,897,898,899,-1,898,900,899,-1,623,901,902,-1,903,904,548,-1,585,587,905,-1,906,907,908,-1,909,910,911,-1,912,913,914,-1,312,315,313,-1,915,524,916,-1,105,540,539,-1,917,918,919,-1,920,540,921,-1,203,202,315,-1,509,922,923,-1,497,211,495,-1,924,198,197,-1,925,926,927,-1,928,929,930,-1,926,925,931,-1,932,933,934,-1,935,936,937,-1,232,231,938,-1,939,940,941,-1,942,943,944,-1,945,946,947,-1,948,949,950,-1,951,952,953,-1,248,246,954,-1,955,956,957,-1,958,959,960,-1,958,961,962,-1,963,964,965,-1,966,967,968,-1,969,350,278,-1,970,971,282,-1,972,973,974,-1,975,976,977,-1,978,979,980,-1,981,982,983,-1,984,985,986,-1,987,988,989,-1,990,991,992,-1,993,994,995,-1,996,989,997,-1,998,999,1000,-1,1001,1002,1003,-1,1004,1005,1006,-1,1007,1008,1009,-1,1010,1011,1012,-1,1013,1014,1015,-1,1016,1017,1018,-1,1019,1020,1021,-1,990,1022,1023,-1,1024,1001,1025,-1,1026,1009,1008,-1,1027,983,1007,-1,1028,1029,1030,-1,1031,1004,1032,-1,1033,1034,1035,-1,1036,1028,1018,-1,1037,1038,1039,-1,1040,1041,1042,-1,1043,1044,1045,-1,1046,1047,1048,-1,1046,1049,1047,-1,1050,1051,1038,-1,1052,1053,1054,-1,1044,1055,1042,-1,1056,1057,1043,-1,1058,1059,1060,-1,1061,1062,1063,-1,1064,1065,1059,-1,1066,1067,1056,-1,1068,1069,1070,-1,1071,1072,1073,-1,1074,1075,1076,-1,1077,1078,1079,-1,1080,1081,1077,-1,1082,1083,1084,-1,1085,1086,1087,-1,1088,1089,1090,-1,1091,1073,1092,-1,1093,1094,1080,-1,1094,1095,1096,-1,1097,1098,1095,-1,1005,1031,1099,-1,1100,1101,1102,-1,1097,1103,1104,-1,1105,1106,1107,-1,1108,1109,1110,-1,1111,1112,1113,-1,1114,1115,1116,-1,1117,1118,1119,-1,1120,1121,1122,-1,1119,1118,1109,-1,1123,1124,1125,-1,1126,1127,1128,-1,1129,1124,1130,-1,1131,1132,1133,-1,1134,1135,1136,-1,1137,1138,1139,-1,1140,1141,1142,-1,1143,1138,1144,-1,1145,1146,1147,-1,1148,1149,1150,-1,1136,1128,1117,-1,1151,1152,1153,-1,1154,1155,1156,-1,1157,1158,1159,-1,1160,1161,1162,-1,1163,1164,1165,-1,1166,1167,1168,-1,1169,1170,1171,-1,1172,1173,1174,-1,1165,1132,1175,-1,1176,1177,1178,-1,1179,1180,1181,-1,1168,1182,1183,-1,1184,1185,1186,-1,1187,1188,1189,-1,1189,1190,1187,-1,1191,1192,1193,-1,1194,1131,1195,-1,1196,1197,1198,-1,1199,1200,1201,-1,1202,1203,1204,-1,1205,1206,1207,-1,1208,1209,1210,-1,1211,1212,1213,-1,1214,1215,1216,-1,1217,1218,1212,-1,1219,1220,1221,-1,1222,1223,1204,-1,1224,1225,1226,-1,1227,1228,1229,-1,1230,1231,1232,-1,1233,1234,1235,-1,1236,1237,1238,-1,1233,1239,1240,-1,1241,1242,1243,-1,1244,1245,1246,-1,1246,1245,1247,-1,1246,1248,1249,-1,1248,1246,1250,-1,1202,1251,1252,-1,1253,1212,1218,-1,1254,1255,1256,-1,1257,1258,1259,-1,1260,1261,1262,-1,1260,1263,1264,-1,1265,1214,1266,-1,1267,1268,1235,-1,1269,1270,1271,-1,1272,1273,1274,-1,1275,1276,1277,-1,1272,1278,1273,-1,1279,1280,1281,-1,1282,1283,1284,-1,1285,1286,1287,-1,1288,1289,1266,-1,1290,1291,1292,-1,1293,1294,1295,-1,1296,946,1297,-1,1298,1299,1300,-1,1301,1302,1303,-1,1304,1305,1306,-1,1306,1307,1304,-1,1308,1309,1310,-1,1311,1312,1313,-1,1308,1314,1309,-1,1315,1316,1317,-1,1318,1319,1320,-1,1321,1322,1323,-1,1323,1324,1321,-1,1325,1326,1327,-1,1328,1329,1330,-1,1331,1332,1333,-1,1334,1335,1336,-1,1337,1338,1339,-1,1340,1341,1342,-1,1343,1344,1345,-1,1346,1347,1348,-1,1349,1350,1351,-1,1352,1353,1354,-1,1324,1355,1356,-1,1357,1358,1359,-1,1318,1360,1361,-1,1362,1337,1363,-1,1364,1365,1366,-1,1347,1367,1368,-1,1369,1370,1371,-1,1372,1371,1373,-1,1374,1375,1376,-1,1377,1378,1379,-1,1380,1381,1382,-1,1383,1384,1385,-1,1372,1386,1387,-1,1388,1389,1390,-1,1391,1392,1393,-1,1394,1395,1396,-1,1397,1398,1399,-1,1400,1401,1402,-1,1403,1404,1405,-1,1406,1407,1408,-1,1409,1410,1411,-1,1412,1413,1414,-1,1415,1416,1417,-1,1418,1419,1420,-1,1421,1422,1423,-1,1424,1425,1426,-1,1427,1428,1429,-1,1430,1431,1432,-1,1401,1420,1433,-1,1399,1434,1397,-1,1432,1435,1436,-1,1427,1429,1437,-1,1438,1439,1440,-1,1441,1442,1443,-1,1426,1444,1445,-1,1446,1447,1448,-1,1449,1450,1451,-1,1452,1453,1454,-1,1455,1456,1457,-1,1458,1459,1460,-1,1461,1462,1463,-1,1461,1464,1462,-1,1465,1466,1467,-1,1468,1469,1470,-1,1471,1472,1473,-1,1474,1475,1476,-1,1477,1478,1473,-1,1479,1480,1481,-1,1482,1483,1484,-1,1485,1486,1487,-1,1488,1489,1474,-1,1490,1491,1492,-1,1493,1494,1495,-1,1496,1497,1498,-1,1499,1500,1490,-1,1496,1501,1502,-1,1493,1485,1503,-1,1504,1505,1506,-1,1507,1482,1508,-1,1497,1509,1498,-1,1510,1511,1512,-1,1513,1514,1515,-1,1516,1517,1518,-1,1519,1520,1521,-1,1522,1523,1524,-1,1525,1526,1527,-1,1528,1499,1529,-1,1528,1529,1530,-1,1531,1532,1533,-1,1534,1535,1536,-1,1537,1538,1539,-1,1540,1541,1542,-1,1543,1544,1545,-1,1546,1547,2,-1,1548,1549,1550,-1,1551,1548,1552,-1,1553,1554,1541,-1,1540,1542,1555,-1,1556,1557,1558,-1,1559,1560,1561,-1,1562,1537,1549,-1,1563,2,1547,-1,1564,1565,1566,-1,1567,1568,1569,-1,1536,1535,577,-1,1570,1571,1572,-1,1573,1574,1575,-1,1527,1526,1532,-1,1576,1577,1578,-1,1579,1567,1580,-1,1581,1582,1583,-1,1584,1585,1586,-1,1587,1588,1589,-1,1590,1591,1592,-1,1593,1594,1595,-1,1596,1597,1598,-1,1599,1600,1601,-1,1602,1603,1604,-1,1605,1,1597,-1,1606,1607,1608,-1,1609,1607,1610,-1,1611,1612,1613,-1,1614,1615,1616,-1,1617,1618,1613,-1,1619,1620,1621,-1,1622,1623,1624,-1,1625,1626,1536,-1,1627,1628,1629,-1,1630,1631,1632,-1,1630,1633,1631,-1,1634,1635,1636,-1,1575,1637,1638,-1,1639,1640,1641,-1,1580,1642,1643,-1,1644,1645,1646,-1,1647,1648,1623,-1,1649,1648,1647,-1,1650,1651,1621,-1,1631,1633,1652,-1,1653,1654,1655,-1,1656,1629,1628,-1,1657,1652,1658,-1,1659,1660,1661,-1,1662,1663,1664,-1,1665,1666,1667,-1,1668,1641,1669,-1,1670,1663,1671,-1,1672,1673,1674,-1,1674,1675,1672,-1,1667,1676,1643,-1,1677,1671,1663,-1,1664,1663,1678,-1,1679,1680,1677,-1,1665,1681,1682,-1,1683,1684,1685,-1,1686,1687,1688,-1,1689,1681,1545,-1,1690,1689,1691,-1,1675,1670,1672,-1,1692,1693,1694,-1,1670,1695,1678,-1,1696,1660,1697,-1,1698,1556,1699,-1,1695,1670,1682,-1,1697,1700,1662,-1,1701,1691,1702,-1,1703,1704,1705,-1,1706,1707,1708,-1,1709,1710,1711,-1,1606,1608,1712,-1,1713,1714,1524,-1,1517,1516,1606,-1,1715,1716,1717,-1,1718,1719,1720,-1,1721,1722,1520,-1,1710,1709,1723,-1,1722,1724,1522,-1,1725,1726,1727,-1,1728,1729,1730,-1,1731,1732,1733,-1,1732,1731,1734,-1,1735,1736,1737,-1,1738,1739,1740,-1,1731,1741,1742,-1,1743,1744,1745,-1,1744,1500,1585,-1,1588,1746,1747,-1,1748,1749,1750,-1,1751,1752,1753,-1,1749,1748,1754,-1,1755,1586,1756,-1,1592,1757,1590,-1,1758,1759,1760,-1,1761,1762,1533,-1,1763,1764,1765,-1,1763,1766,1767,-1,1483,1745,1768,-1,1766,1769,1770,-1,1471,1467,1472,-1,1771,1772,1773,-1,1774,1685,1775,-1,1560,1776,1777,-1,1778,1779,1539,-1,1779,1780,1781,-1,1782,1783,1779,-1,1784,1785,1786,-1,1787,1788,1612,-1,1789,1790,1791,-1,1767,1770,1751,-1,1792,1793,1794,-1,1792,1795,1796,-1,1710,1797,1712,-1,1798,1799,1800,-1,1512,1511,1757,-1,1801,1802,1798,-1,1803,1804,1805,-1,1804,1806,1805,-1,1654,1807,1595,-1,1654,1806,1807,-1,1808,1809,1649,-1,1810,1811,1812,-1,1601,1596,1598,-1,1687,1693,1813,-1,1552,1548,1694,-1,1646,1814,1815,-1,1645,1651,1650,-1,1650,1816,1817,-1,1650,1817,1818,-1,1819,1814,1645,-1,1815,1688,1820,-1,1821,1822,1552,-1,1693,1687,1686,-1,1539,1549,1537,-1,1823,1824,1654,-1,1823,1595,1594,-1,1708,1725,1706,-1,1723,1709,1825,-1,1725,1826,1706,-1,1804,1803,1566,-1,1827,1828,1829,-1,1756,1757,1589,-1,1830,1831,1832,-1,1833,1834,1835,-1,1833,1609,1836,-1,1837,1838,1839,-1,1840,1793,1792,-1,1476,1841,1582,-1,1789,1842,1471,-1,1771,1843,1538,-1,1473,1478,1844,-1,1845,1846,1461,-1,1783,1847,1848,-1,1849,1850,1851,-1,1852,1853,1854,-1,1779,1783,1855,-1,1856,1778,1539,-1,1553,1857,1780,-1,1787,1858,1776,-1,1859,1773,1772,-1,1860,1465,1861,-1,1860,1475,1466,-1,1764,1760,1759,-1,1478,1480,1862,-1,1483,1768,1769,-1,1762,1836,1609,-1,1863,1864,1751,-1,1863,1769,1768,-1,1592,1587,1757,-1,1865,1866,1867,-1,1868,1759,1758,-1,1528,1756,1586,-1,1869,1799,1798,-1,1870,1871,1749,-1,1872,1873,1874,-1,1749,1869,1750,-1,1875,1753,1588,-1,1744,1585,1584,-1,1876,1865,1877,-1,1833,1836,1878,-1,1879,1880,1881,-1,1731,1735,1741,-1,1882,1730,1883,-1,1729,1884,1732,-1,1852,1728,1882,-1,1733,1732,1884,-1,1723,1715,1724,-1,1724,1717,1885,-1,1886,1518,1887,-1,1712,1608,1888,-1,1825,1725,1715,-1,1889,1777,1890,-1,1685,1702,1775,-1,1542,1891,1692,-1,1695,1892,1893,-1,1670,1671,1672,-1,1690,1691,1701,-1,1543,1820,1688,-1,1684,1893,1685,-1,1545,1681,1894,-1,1820,1894,1895,-1,1666,1665,1675,-1,1672,1671,1673,-1,1896,1680,1897,-1,1641,1898,1669,-1,1666,1898,1640,-1,1777,1858,1890,-1,1893,1664,1678,-1,1637,1899,1660,-1,1900,1679,1662,-1,1901,1696,1662,-1,1902,1660,1659,-1,1903,1657,1904,-1,1706,1905,1707,-1,1667,1894,1681,-1,1629,1649,1647,-1,1621,1623,1648,-1,1642,1580,1569,-1,1640,1639,1579,-1,1906,1641,1668,-1,1907,1908,1897,-1,1572,1700,1697,-1,1578,1899,1637,-1,1573,1638,1909,-1,1636,1635,1633,-1,1632,1631,1628,-1,1613,1618,1910,-1,1462,1786,1854,-1,1614,1776,1615,-1,1911,1611,1910,-1,1912,1913,1914,-1,1912,1847,1913,-1,1915,1916,1595,-1,1917,1713,1523,-1,1514,1610,1606,-1,1816,1918,1817,-1,1816,1823,1919,-1,1823,1602,1919,-1,1593,1605,1597,-1,1746,1588,1587,-1,1499,1586,1585,-1,1513,1920,1876,-1,1921,1867,1531,-1,1922,2,1564,-1,1627,1923,1924,-1,1925,1926,1927,-1,1927,1928,1925,-1,1929,1930,1906,-1,1639,583,1579,-1,1931,1620,1932,-1,1568,1933,1644,-1,1559,1558,1934,-1,1556,1698,1541,-1,1549,1539,1935,-1,1857,1936,1781,-1,1937,1551,1552,-1,1819,1938,1939,-1,1922,1566,1546,-1,1813,1940,1543,-1,1542,1698,1891,-1,1852,1739,1853,-1,1941,1538,1562,-1,1781,1936,1935,-1,1841,1793,1840,-1,1532,1531,1527,-1,1525,1927,1942,-1,1885,1828,1523,-1,1517,1519,1521,-1,1920,1513,1515,-1,1925,1512,1926,-1,1943,1944,1854,-1,1854,1853,1943,-1,1489,1488,1493,-1,1945,1479,1481,-1,1496,1946,1947,-1,1494,1948,1501,-1,1948,1504,1502,-1,1494,1503,1948,-1,1949,1497,1496,-1,1502,1946,1496,-1,1477,1481,1478,-1,1487,1530,1950,-1,1950,1529,1490,-1,1481,1468,1495,-1,1471,1790,1789,-1,1469,1467,1466,-1,1861,1465,1842,-1,1845,1461,1463,-1,1951,1952,1953,-1,1954,1955,1956,-1,1457,1957,1958,-1,1959,1960,1961,-1,1455,1952,1951,-1,1962,1952,1455,-1,1963,1964,1965,-1,1966,1967,1968,-1,1443,1442,1969,-1,1970,1971,1972,-1,1398,1397,1973,-1,1974,1975,1403,-1,1976,1977,1978,-1,1979,1418,1980,-1,1981,1982,1983,-1,1984,1985,1986,-1,1395,1445,1987,-1,1400,1418,1420,-1,1988,1989,1990,-1,1991,1988,1992,-1,1988,1993,1992,-1,1994,1395,1995,-1,1996,1997,1390,-1,1976,1997,1996,-1,1998,1999,1980,-1,1424,1433,1425,-1,1420,1419,2000,-1,1979,1448,1418,-1,1405,1966,2001,-1,2002,2003,2004,-1,1434,2005,2006,-1,2007,1404,1403,-1,1399,1398,1994,-1,1433,1424,1401,-1,2008,2009,1984,-1,2010,2011,2012,-1,2008,2013,2014,-1,1973,1397,2015,-1,1418,2016,1980,-1,2017,1388,2018,-1,1384,2019,2020,-1,2020,2019,2021,-1,2022,2023,1380,-1,2024,1378,1377,-1,2025,2026,2027,-1,2028,2029,2030,-1,2031,2032,2033,-1,1367,2034,1350,-1,2035,2036,2037,-1,1363,1339,2038,-1,1336,1366,2039,-1,2040,1335,1334,-1,1345,2041,2042,-1,1334,1352,2043,-1,2044,1353,1336,-1,2045,2046,2047,-1,1329,2048,2044,-1,2049,1328,2050,-1,2044,2048,1354,-1,1367,2051,2052,-1,2053,1365,2054,-1,2055,2056,1324,-1,2057,1319,1318,-1,2058,1333,1354,-1,2059,1326,1356,-1,2060,2061,2062,-1,2063,1317,2064,-1,2065,2066,2067,-1,2068,2069,2070,-1,2071,2072,2073,-1,2074,2075,2076,-1,2077,2078,2079,-1,2080,2081,2082,-1,2083,2084,2085,-1,2086,2087,1302,-1,1310,1307,2088,-1,2089,2090,2091,-1,2092,1301,2093,-1,1300,1299,2094,-1,2095,2096,2097,-1,2098,947,1296,-1,2099,2100,2101,-1,2102,2103,2104,-1,1287,1286,2105,-1,2106,2107,2108,-1,1202,1204,1223,-1,2109,2110,2111,-1,2112,1237,2113,-1,2109,2111,2114,-1,2115,1274,2116,-1,2117,2118,2119,-1,2120,2121,2122,-1,2122,2123,2120,-1,1207,1227,1205,-1,1259,2124,1257,-1,1248,1215,2125,-1,2126,1214,1265,-1,2098,1296,2127,-1,1256,1247,2128,-1,1250,1258,1257,-1,2129,1249,1270,-1,2130,2131,2132,-1,2131,1278,2132,-1,1260,2133,2134,-1,2135,1241,2136,-1,2137,2138,2139,-1,1242,1241,2135,-1,1221,1197,2140,-1,2141,2142,2143,-1,2108,2144,2145,-1,2146,2147,2148,-1,1205,1229,2149,-1,2150,2151,2106,-1,2152,2153,2154,-1,1201,2111,1199,-1,2155,1234,1233,-1,2156,2157,2158,-1,2132,1272,2159,-1,1209,2160,2161,-1,1245,2162,2128,-1,2162,2163,2128,-1,2164,2165,1244,-1,2120,2123,2166,-1,2167,2168,2169,-1,2170,2171,2172,-1,2173,2174,2175,-1,2176,2177,2178,-1,2179,2180,2181,-1,2182,2183,2184,-1,2185,2186,2187,-1,1180,1166,2188,-1,2188,2189,2190,-1,2191,1178,2192,-1,2193,1169,1137,-1,2194,1111,1172,-1,2169,2195,1165,-1,2196,2197,2198,-1,2199,2200,1157,-1,1118,2201,1112,-1,1140,1126,1136,-1,2202,1164,1163,-1,1175,2167,2169,-1,2203,1162,2204,-1,2205,2200,2199,-1,2206,2207,1154,-1,2208,1126,1140,-1,2209,2210,2211,-1,1143,1144,1176,-1,1170,1169,2193,-1,1185,1123,1159,-1,1194,1175,1132,-1,2212,2213,2214,-1,2215,2216,2217,-1,2218,1171,1170,-1,2219,2220,2221,-1,2219,2222,2220,-1,1139,1138,1143,-1,2223,2224,2225,-1,1133,1140,1136,-1,2226,2227,2228,-1,1135,1134,2229,-1,2230,1133,1132,-1,1128,1124,1129,-1,1130,2231,1117,-1,2174,1112,2201,-1,1120,2232,2233,-1,1117,2234,2235,-1,2231,2201,1117,-1,2236,2175,2231,-1,2237,2238,1114,-1,2239,2240,2241,-1,1113,1112,1173,-1,1109,2242,1111,-1,2243,1193,2244,-1,2245,2246,1174,-1,2247,2248,2249,-1,2250,2251,2252,-1,2253,2254,2255,-1,1086,2256,2257,-1,1094,2258,1081,-1,2259,1092,1073,-1,2260,2261,2262,-1,2263,1086,1085,-1,2264,2265,2266,-1,2267,2268,2269,-1,1079,1078,2270,-1,2271,1073,2272,-1,985,978,2273,-1,1055,2274,2275,-1,2276,2277,1068,-1,1070,2278,2279,-1,2280,2281,2282,-1,1067,2283,1057,-1,1024,2284,2285,-1,1062,2286,2287,-1,1059,1079,2288,-1,2289,1056,2290,-1,1042,2275,1052,-1,1054,1053,2291,-1,1051,2276,2292,-1,2293,2294,2295,-1,983,982,2296,-1,2297,2298,2299,-1,2300,2289,2301,-1,1039,2292,1049,-1,2302,2303,2304,-1,2305,2306,2307,-1,2308,1034,2309,-1,2310,2311,2312,-1,2313,2314,2315,-1,2316,2317,2318,-1,1032,2319,2320,-1,2321,1003,2322,-1,2323,2305,2304,-1,2324,2325,2326,-1,1017,1016,1047,-1,2327,1048,2328,-1,2329,2330,2331,-1,2332,996,2333,-1,2266,2334,2335,-1,2336,2337,1024,-1,1025,1001,2321,-1,2338,995,2339,-1,2340,1023,1020,-1,2341,1029,1028,-1,1026,1008,2324,-1,2325,2301,2342,-1,2343,2344,2345,-1,1015,2346,2347,-1,2348,2349,2331,-1,2350,1012,1011,-1,988,987,2351,-1,994,989,996,-1,2352,992,993,-1,2353,991,2354,-1,987,993,2355,-1,986,985,2356,-1,984,2357,2296,-1,979,982,981,-1,2358,2273,980,-1,2359,1030,2360,-1,2361,2362,2329,-1,1012,2363,2323,-1,2364,2365,2366,-1,2367,2368,2369,-1,2370,2371,2372,-1,2373,2374,2375,-1,2376,347,2377,-1,235,2378,947,-1,2379,243,2380,-1,2381,941,2382,-1,2246,228,2383,-1,226,225,2384,-1,2385,2386,2387,-1,2388,933,2389,-1,2390,2391,2392,-1,919,522,2393,-1,915,105,524,-1,2394,508,507,-1,912,2395,913,-1,908,905,906,-1,2396,2397,2398,-1,611,616,621,-1,2399,2400,2401,-1,2402,635,634,-1,2403,2404,894,-1,641,650,649,-1,2405,2406,87,-1,888,2407,34,-1,594,2408,2409,-1,669,2410,561,-1,872,2411,873,-1,2412,2413,2414,-1,2415,2416,671,-1,2417,2418,866,-1,2417,2419,54,-1,671,670,557,-1,2420,563,2421,-1,861,169,797,-1,168,327,856,-1,173,2422,108,-1,852,2423,2424,-1,2425,2426,806,-1,751,750,754,-1,2427,2428,2429,-1,2430,734,730,-1,836,837,2423,-1,564,2431,565,-1,2432,2433,2434,-1,128,127,835,-1,833,839,834,-1,2435,2436,2437,-1,2438,2439,2440,-1,2441,842,828,-1,828,2442,2441,-1,2443,2444,825,-1,2445,826,825,-1,2446,2447,2448,-1,821,2449,182,-1,815,2450,2451,-1,821,822,2449,-1,118,117,120,-1,2452,2443,2453,-1,2452,118,2454,-1,186,816,2451,-1,816,815,2451,-1,73,2445,74,-1,2445,814,813,-1,51,73,812,-1,2418,2455,57,-1,620,619,662,-1,2456,803,2457,-1,2457,839,2456,-1,782,784,2458,-1,802,852,2424,-1,2423,851,2459,-1,848,806,799,-1,2460,2461,2462,-1,2463,2464,743,-1,767,854,764,-1,791,764,763,-1,864,700,2465,-1,2466,769,2467,-1,784,779,2458,-1,2468,703,2469,-1,2470,2458,779,-1,2471,2472,2473,-1,2427,2474,2472,-1,2475,2476,2477,-1,2478,790,743,-1,2479,2480,788,-1,765,854,853,-1,791,788,2480,-1,2461,2481,768,-1,2482,705,2483,-1,444,421,738,-1,725,724,2484,-1,2460,2462,2485,-1,451,761,452,-1,445,441,422,-1,2486,2487,869,-1,738,420,447,-1,751,435,735,-1,750,735,2430,-1,749,2488,747,-1,853,766,2489,-1,2490,789,2491,-1,754,732,753,-1,747,2486,748,-1,742,2492,2489,-1,450,449,2490,-1,447,2493,739,-1,446,753,731,-1,2494,726,725,-1,428,857,709,-1,437,2495,730,-1,2483,2496,2497,-1,2498,2494,723,-1,438,2465,724,-1,2494,721,723,-1,721,2484,2499,-1,427,717,857,-1,720,2500,429,-1,721,717,722,-1,710,706,708,-1,707,2501,708,-1,711,2502,730,-1,2503,783,2504,-1,696,695,677,-1,697,2416,2415,-1,692,2505,674,-1,689,2506,682,-1,8,7,2507,-1,685,2508,2509,-1,686,672,671,-1,2510,556,555,-1,561,2511,562,-1,2512,675,674,-1,440,554,2465,-1,871,563,872,-1,2513,2514,807,-1,663,814,2515,-1,69,71,2516,-1,62,2517,664,-1,2518,2519,2520,-1,2520,2519,645,-1,2402,647,2521,-1,652,2522,600,-1,2523,2520,2524,-1,648,650,2525,-1,16,2526,2527,-1,2524,2528,2529,-1,653,32,639,-1,2530,15,637,-1,895,894,638,-1,2531,2532,2533,-1,2534,615,626,-1,582,2535,613,-1,609,2536,607,-1,617,628,618,-1,2537,581,2538,-1,2539,599,2540,-1,2541,600,2522,-1,2542,2539,602,-1,2543,597,596,-1,2544,2545,605,-1,668,877,669,-1,618,612,608,-1,2397,905,587,-1,589,585,881,-1,1567,583,611,-1,584,1930,2546,-1,2547,2548,2549,-1,571,2550,2551,-1,569,568,841,-1,2552,2553,2554,-1,569,2551,2555,-1,2555,2556,567,-1,2557,2558,573,-1,875,2559,2560,-1,2561,2562,2401,-1,554,558,864,-1,870,678,679,-1,484,2563,2564,-1,545,502,2565,-1,2566,2567,550,-1,2568,2569,2570,-1,541,2571,2562,-1,545,544,2572,-1,2573,2574,188,-1,908,919,918,-1,2575,2574,2559,-1,917,919,2393,-1,533,2576,2577,-1,2578,528,2579,-1,905,536,2408,-1,536,535,530,-1,528,2578,2580,-1,2396,2398,2581,-1,518,517,2577,-1,914,2582,2583,-1,2584,512,2394,-1,553,2585,2586,-1,2394,2587,2584,-1,512,511,2588,-1,2588,2589,2590,-1,2590,495,2588,-1,2565,2591,2592,-1,505,2593,2594,-1,2591,501,2595,-1,2596,2597,2592,-1,2597,2596,546,-1,2595,501,2598,-1,497,505,2594,-1,2599,2600,211,-1,2601,2602,2603,-1,126,2604,2454,-1,478,2605,2606,-1,2607,2608,492,-1,2602,481,483,-1,486,485,2608,-1,817,2609,490,-1,2610,475,2611,-1,342,413,2612,-1,2613,2614,185,-1,2615,2616,2617,-1,295,473,2618,-1,2619,175,2620,-1,2621,469,2622,-1,2623,2624,2621,-1,307,2625,2626,-1,2627,259,325,-1,2628,263,2629,-1,275,2630,2631,-1,252,383,2632,-1,757,2633,449,-1,2634,869,2635,-1,753,2636,2637,-1,437,436,2637,-1,716,429,431,-1,2500,426,428,-1,2638,424,423,-1,2638,426,719,-1,2639,422,443,-1,726,728,2483,-1,2640,2641,2642,-1,2643,326,2644,-1,2645,2646,2647,-1,2648,331,396,-1,2649,2650,336,-1,404,2649,402,-1,410,409,2651,-1,161,408,154,-1,2652,2653,2654,-1,337,2655,2656,-1,155,410,2653,-1,2657,2658,2659,-1,161,2660,408,-1,401,2659,2661,-1,401,400,2657,-1,2662,233,326,-1,345,390,2663,-1,417,326,2643,-1,393,855,419,-1,2647,2664,2665,-1,2646,2666,2667,-1,2668,237,389,-1,2669,2670,2671,-1,2671,240,239,-1,2672,924,382,-1,2673,321,2674,-1,2625,2675,2676,-1,2626,2624,2623,-1,355,376,378,-1,350,2677,2678,-1,170,2679,456,-1,470,2680,2681,-1,289,366,365,-1,287,2682,288,-1,378,292,355,-1,2683,2684,2685,-1,343,2686,2687,-1,2688,2644,233,-1,411,339,332,-1,2689,2690,2691,-1,2692,2693,2694,-1,2695,2696,338,-1,329,411,332,-1,220,335,334,-1,167,2697,2698,-1,165,2699,2700,-1,326,856,327,-1,2629,2701,2627,-1,373,266,374,-1,264,2702,2703,-1,2704,312,319,-1,315,312,2705,-1,105,2706,194,-1,2707,105,194,-1,2708,2709,2710,-1,2711,291,293,-1,2712,2611,475,-1,2713,358,2714,-1,972,2613,2611,-1,2611,185,184,-1,2675,2715,378,-1,2681,2716,2717,-1,2718,368,2717,-1,2719,366,289,-1,2368,2720,278,-1,348,277,349,-1,2721,2365,267,-1,2722,349,2723,-1,274,271,284,-1,266,2724,267,-1,2703,2673,2725,-1,2726,2619,2727,-1,258,257,2728,-1,2729,382,2730,-1,384,948,2731,-1,2730,382,252,-1,2732,2733,381,-1,250,249,2734,-1,2735,246,2736,-1,2735,2737,244,-1,388,2738,2379,-1,235,2739,2740,-1,2741,2742,2743,-1,333,2694,2744,-1,2386,2646,2745,-1,2746,344,346,-1,344,2746,2387,-1,330,2648,2747,-1,2748,2749,219,-1,2750,2389,2656,-1,399,218,187,-1,210,209,2751,-1,2752,922,2753,-1,207,206,2754,-1,192,191,2755,-1,2391,190,2756,-1,217,188,187,-1,2573,188,216,-1,2610,184,186,-1,294,135,183,-1,465,2757,2758,-1,176,180,2759,-1,2620,177,2448,-1,174,2760,2761,-1,2762,145,147,-1,165,168,166,-1,863,2763,2764,-1,372,2765,2766,-1,152,266,2767,-1,2768,151,2769,-1,519,518,2575,-1,169,144,2770,-1,823,182,2449,-1,2771,2772,2773,-1,132,2774,820,-1,2617,136,294,-1,2775,2776,2777,-1,172,844,836,-1,123,122,125,-1,2772,2778,2779,-1,833,2780,838,-1,2422,2459,109,-1,106,105,915,-1,2781,2782,2783,-1,93,92,43,-1,2784,2781,2785,-1,47,43,2786,-1,2787,2788,81,-1,85,87,41,-1,811,2789,68,-1,811,2790,2787,-1,2787,2790,2791,-1,82,2792,8