package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Human bone model for Girdle. </p>
 <p> Related links: Catalog page <a href="../../../Medical/BonesGirdleIndex.html" target="_blank">BonesGirdle</a>,  source <a href="../../../Medical/BonesGirdle.java">BonesGirdle.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/BonesGirdle.x3d">BonesGirdle.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Damon Hernandez, Joe Williams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Human bone model for Girdle </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Joe Williams, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 5 December 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesGirdle.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesGirdle.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Damon Hernandez, Joe Williams
 */

public class BonesGirdle
{
	/** Default constructor to create this object. */
	public BonesGirdle ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("BonesGirdle.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Damon Hernandez, Joe Williams"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Human bone model for Girdle"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Joe Williams, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("5 December 2013"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesGirdle.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("BonesGirdle.x3d"))
    .addChild(new Transform("GirdleSkeletonParts").setScale(0.029,0.029,0.029)
      .addChild(new Group("Girdle")
        .addComments(" loscoxae roscoxae sacrum sympubis coccyx ")
        .addChild(new Shape("loscoxae")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.0,1.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("loscoxae_Geo").setDEF("loscoxae_Geo").setCreaseAngle(1.571).setCoordIndex(getloscoxae_Geo_6_14_coordIndex())
            .setCoord(new Coordinate("loscoxae_Coord").setPoint(getloscoxae_Coord_7_14_point()))))
        .addChild(new Shape("roscoxae")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.0,1.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("roscoxae_Geo").setDEF("roscoxae_Geo").setCreaseAngle(1.571).setCoordIndex(getroscoxae_Geo_6_19_coordIndex())
            .setCoord(new Coordinate("roscoxae_Coord").setPoint(getroscoxae_Coord_7_19_point()))))
        .addChild(new Shape("sacrum")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(0.0,0.0,1.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("sacrum_Geo").setDEF("sacrum_Geo").setCreaseAngle(1.571).setCoordIndex(getsacrum_Geo_6_24_coordIndex())
            .setCoord(new Coordinate("sacrum_Coord").setPoint(getsacrum_Coord_7_24_point()))))
        .addChild(new Shape("sympubis")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(0.0,0.0,1.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("sympubis_Geo").setDEF("sympubis_Geo").setCreaseAngle(1.571).setCoordIndex(getsympubis_Geo_6_29_coordIndex())
            .setCoord(new Coordinate("sympubis_Coord").setPoint(getsympubis_Coord_7_29_point()))))
        .addChild(new Shape("coccyx")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("coccyx_Geo").setDEF("coccyx_Geo").setCreaseAngle(1.571).setCoordIndex(getcoccyx_Geo_6_34_coordIndex())
            .setCoord(new Coordinate("coccyx_Coord").setPoint(getcoccyx_Coord_7_34_point())))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getloscoxae_Geo_6_14_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,4,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,19,-1,27,28,19,-1,29,30,31,-1,29,32,30,-1,33,34,32,-1,34,35,32,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,57,58,55,-1,59,60,49,-1,59,61,60,-1,62,63,64,-1,63,65,64,-1,66,67,68,-1,69,70,71,-1,72,73,74,-1,75,76,73,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,85,-1,88,89,90,-1,90,91,88,-1,92,93,94,-1,92,95,93,-1,96,97,98,-1,99,100,101,-1,102,103,104,-1,105,106,107,-1,105,108,106,-1,109,110,111,-1,112,111,113,-1,93,114,115,-1,116,117,118,-1,116,67,117,-1,119,68,67,-1,67,116,119,-1,120,92,121,-1,120,95,92,-1,122,123,124,-1,124,125,122,-1,126,127,128,-1,127,129,128,-1,130,131,132,-1,133,134,135,-1,135,136,133,-1,137,138,139,-1,137,140,138,-1,141,142,143,-1,141,144,142,-1,145,146,147,-1,145,148,146,-1,149,150,151,-1,72,152,153,-1,72,154,152,-1,155,156,157,-1,156,158,157,-1,159,160,161,-1,160,162,161,-1,161,163,159,-1,160,164,162,-1,165,166,167,-1,166,168,167,-1,169,170,171,-1,172,173,40,-1,173,41,40,-1,174,175,176,-1,175,177,176,-1,178,179,180,-1,180,181,178,-1,182,183,184,-1,182,185,183,-1,186,187,188,-1,189,190,191,-1,189,192,190,-1,193,194,195,-1,193,147,194,-1,196,145,197,-1,196,198,145,-1,199,200,201,-1,199,143,200,-1,202,203,141,-1,141,204,202,-1,205,137,206,-1,205,136,137,-1,207,208,209,-1,210,211,212,-1,210,213,211,-1,92,214,121,-1,92,84,214,-1,215,119,216,-1,217,74,218,-1,218,219,217,-1,82,124,123,-1,82,81,124,-1,220,221,68,-1,222,223,224,-1,225,69,226,-1,227,228,229,-1,230,231,232,-1,230,233,231,-1,234,235,236,-1,234,108,235,-1,237,238,12,-1,70,69,239,-1,69,225,239,-1,240,241,242,-1,241,243,242,-1,243,244,242,-1,245,246,247,-1,245,248,246,-1,249,250,251,-1,251,127,249,-1,252,253,254,-1,253,255,254,-1,37,36,29,-1,256,257,258,-1,256,259,257,-1,127,251,260,-1,260,129,127,-1,36,33,29,-1,261,262,65,-1,26,263,31,-1,264,265,25,-1,25,266,264,-1,267,268,269,-1,270,271,55,-1,270,272,271,-1,185,273,183,-1,274,275,276,-1,277,278,279,-1,278,280,279,-1,223,281,282,-1,282,283,223,-1,284,285,286,-1,284,287,285,-1,288,275,274,-1,289,290,291,-1,289,292,290,-1,293,294,229,-1,229,295,293,-1,231,296,297,-1,298,236,299,-1,299,300,298,-1,301,302,303,-1,304,305,207,-1,304,277,305,-1,306,307,308,-1,308,309,306,-1,310,311,306,-1,312,313,314,-1,315,316,4,-1,315,3,317,-1,318,319,320,-1,318,321,319,-1,322,323,324,-1,325,62,326,-1,326,327,325,-1,328,329,330,-1,331,332,333,-1,332,330,334,-1,335,336,337,-1,338,339,327,-1,340,341,342,-1,343,337,336,-1,343,341,337,-1,344,345,346,-1,345,347,346,-1,348,349,350,-1,349,351,350,-1,352,239,353,-1,354,222,355,-1,356,357,353,-1,357,286,353,-1,354,358,15,-1,359,15,14,-1,360,104,71,-1,361,69,71,-1,16,362,14,-1,363,364,358,-1,358,365,363,-1,363,366,367,-1,367,364,363,-1,16,368,369,-1,368,370,369,-1,356,353,371,-1,353,372,371,-1,361,373,226,-1,226,69,361,-1,374,361,375,-1,376,100,301,-1,376,377,100,-1,186,276,275,-1,378,379,380,-1,381,382,383,-1,383,384,381,-1,381,385,382,-1,379,386,387,-1,387,388,379,-1,186,188,389,-1,191,276,390,-1,191,190,276,-1,99,101,391,-1,392,89,393,-1,394,395,396,-1,395,397,396,-1,398,101,373,-1,97,96,395,-1,399,96,400,-1,400,401,399,-1,402,403,404,-1,404,405,402,-1,406,407,403,-1,400,98,93,-1,406,408,409,-1,410,407,411,-1,412,413,387,-1,75,414,405,-1,75,73,414,-1,415,404,410,-1,81,78,213,-1,81,80,78,-1,211,416,417,-1,417,74,211,-1,417,218,74,-1,418,419,420,-1,64,326,62,-1,421,422,62,-1,421,423,422,-1,424,149,425,-1,426,427,144,-1,427,142,144,-1,428,429,140,-1,429,138,140,-1,430,431,432,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_2()
		{
			int[] value = {432,433,430,-1,432,434,433,-1,433,435,436,-1,433,437,435,-1,438,436,435,-1,439,418,219,-1,219,440,439,-1,417,416,441,-1,416,442,441,-1,436,443,430,-1,436,444,443,-1,445,446,447,-1,448,449,450,-1,451,452,453,-1,454,455,456,-1,457,458,459,-1,460,461,462,-1,463,464,344,-1,464,345,344,-1,465,463,466,-1,466,467,465,-1,466,468,467,-1,427,469,470,-1,465,471,463,-1,472,471,473,-1,474,469,427,-1,427,475,474,-1,476,426,477,-1,478,479,480,-1,481,464,482,-1,483,484,485,-1,483,486,487,-1,485,484,488,-1,489,490,491,-1,492,493,494,-1,492,495,493,-1,492,496,497,-1,498,499,497,-1,497,496,500,-1,500,498,497,-1,501,502,503,-1,503,504,501,-1,505,506,507,-1,505,500,506,-1,508,504,500,-1,509,510,499,-1,511,512,513,-1,513,514,511,-1,514,515,516,-1,514,513,515,-1,485,515,421,-1,421,486,485,-1,423,421,513,-1,517,518,513,-1,519,520,521,-1,517,522,523,-1,517,519,522,-1,524,525,523,-1,523,526,524,-1,526,522,521,-1,521,527,526,-1,526,528,529,-1,529,524,526,-1,530,531,532,-1,530,533,531,-1,534,535,536,-1,536,537,534,-1,538,539,540,-1,538,541,539,-1,542,543,544,-1,543,545,544,-1,543,546,541,-1,543,547,546,-1,307,547,542,-1,307,548,547,-1,549,315,317,-1,550,551,317,-1,2,552,3,-1,553,312,2,-1,554,555,556,-1,557,558,556,-1,557,559,558,-1,560,561,562,-1,562,563,560,-1,564,560,565,-1,564,561,560,-1,566,567,564,-1,566,568,567,-1,567,569,561,-1,570,571,113,-1,572,554,556,-1,573,574,575,-1,573,576,574,-1,573,577,578,-1,573,575,577,-1,579,555,578,-1,579,557,555,-1,563,562,580,-1,580,581,563,-1,581,580,582,-1,583,584,572,-1,583,113,585,-1,576,584,586,-1,584,583,586,-1,587,588,589,-1,587,590,588,-1,591,560,563,-1,563,592,591,-1,593,594,592,-1,595,596,581,-1,597,598,593,-1,599,597,596,-1,596,600,599,-1,601,599,602,-1,599,600,602,-1,172,21,603,-1,172,40,21,-1,604,605,606,-1,604,607,605,-1,608,43,604,-1,607,598,597,-1,607,609,598,-1,605,599,601,-1,20,610,611,-1,22,612,610,-1,613,612,614,-1,615,616,617,-1,615,618,616,-1,619,620,621,-1,619,622,620,-1,52,623,624,-1,53,625,626,-1,627,628,629,-1,630,591,631,-1,632,591,594,-1,633,593,598,-1,634,635,618,-1,635,613,618,-1,619,54,636,-1,619,52,54,-1,637,638,639,-1,640,335,334,-1,641,642,643,-1,641,644,642,-1,645,635,634,-1,645,646,635,-1,642,647,643,-1,642,645,647,-1,641,648,644,-1,641,649,648,-1,650,631,633,-1,651,652,650,-1,653,645,642,-1,653,654,645,-1,655,656,657,-1,656,658,657,-1,657,659,660,-1,660,655,657,-1,338,326,661,-1,338,327,326,-1,662,663,664,-1,665,666,650,-1,666,667,650,-1,668,667,669,-1,670,671,672,-1,670,673,671,-1,674,653,675,-1,674,676,653,-1,660,58,655,-1,660,677,58,-1,270,55,58,-1,58,677,270,-1,678,664,663,-1,679,262,680,-1,681,682,683,-1,684,685,686,-1,686,687,684,-1,688,246,689,-1,690,691,692,-1,692,693,690,-1,694,695,696,-1,696,692,694,-1,697,698,699,-1,700,701,702,-1,703,694,704,-1,700,705,706,-1,707,708,709,-1,707,710,708,-1,254,711,712,-1,712,713,252,-1,252,254,712,-1,34,713,714,-1,715,716,717,-1,715,35,716,-1,251,718,260,-1,49,60,719,-1,719,720,49,-1,721,722,723,-1,723,724,721,-1,240,725,250,-1,240,726,725,-1,727,728,729,-1,37,29,263,-1,730,731,732,-1,733,130,132,-1,733,734,130,-1,733,38,735,-1,736,731,737,-1,731,738,737,-1,739,740,630,-1,630,631,739,-1,741,742,743,-1,743,744,741,-1,745,746,18,-1,745,747,746,-1,727,748,31,-1,31,30,727,-1,263,19,18,-1,25,749,750,-1,750,266,25,-1,269,751,267,-1,751,722,267,-1,752,753,548,-1,754,755,550,-1,756,757,745,-1,756,758,757,-1,759,760,761,-1,762,763,764,-1,763,765,764,-1,766,767,768,-1,766,769,767,-1,770,771,772,-1,772,314,770,-1,773,4,774,-1,773,775,4,-1,776,775,777,-1,775,778,777,-1,777,778,779,-1,6,777,7,-1,314,313,770,-1,780,781,782,-1,782,783,780,-1,544,549,542,-1,784,785,544,-1,784,545,786,-1,787,788,789,-1,788,790,789,-1,791,792,165,-1,793,794,163,-1,795,796,601,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_3()
		{
			int[] value = {797,602,798,-1,797,795,602,-1,799,800,167,-1,167,801,799,-1,802,803,109,-1,803,168,109,-1,617,804,805,-1,617,806,804,-1,370,807,369,-1,370,808,807,-1,115,809,94,-1,809,85,94,-1,87,810,811,-1,812,507,506,-1,506,813,812,-1,814,815,811,-1,814,806,816,-1,813,817,818,-1,813,815,817,-1,819,818,817,-1,819,817,820,-1,41,173,821,-1,822,39,823,-1,819,820,823,-1,824,819,825,-1,826,825,823,-1,826,827,828,-1,829,830,824,-1,824,831,829,-1,832,825,833,-1,832,834,825,-1,795,797,835,-1,836,837,838,-1,839,840,841,-1,841,842,839,-1,843,844,845,-1,829,846,847,-1,841,846,848,-1,849,842,848,-1,850,849,846,-1,181,851,852,-1,852,853,181,-1,854,855,180,-1,855,856,180,-1,857,858,8,-1,858,179,8,-1,859,10,860,-1,10,861,860,-1,862,863,864,-1,863,865,864,-1,866,867,864,-1,864,868,866,-1,868,865,869,-1,869,870,868,-1,842,849,871,-1,845,842,872,-1,873,752,874,-1,752,754,874,-1,875,45,47,-1,876,28,877,-1,19,263,26,-1,17,19,878,-1,878,879,17,-1,880,881,882,-1,883,884,885,-1,883,886,884,-1,887,888,889,-1,887,890,888,-1,47,891,892,-1,876,893,894,-1,894,28,876,-1,878,895,896,-1,896,879,878,-1,882,863,862,-1,862,897,882,-1,898,899,853,-1,898,900,899,-1,901,902,176,-1,889,177,843,-1,889,888,177,-1,903,192,904,-1,903,190,192,-1,279,305,277,-1,205,300,905,-1,205,298,300,-1,304,906,907,-1,908,905,906,-1,905,300,906,-1,906,304,908,-1,909,910,911,-1,388,189,191,-1,191,912,388,-1,102,282,281,-1,888,176,177,-1,888,901,176,-1,884,898,852,-1,898,853,852,-1,897,862,913,-1,913,914,897,-1,882,915,863,-1,882,916,915,-1,878,894,895,-1,878,28,894,-1,890,901,888,-1,917,918,914,-1,919,916,882,-1,882,881,919,-1,19,28,878,-1,265,877,28,-1,28,27,265,-1,877,875,876,-1,875,47,876,-1,891,47,46,-1,920,890,887,-1,920,874,890,-1,265,875,877,-1,265,264,875,-1,845,872,843,-1,871,872,842,-1,843,872,892,-1,892,889,843,-1,921,871,849,-1,871,921,893,-1,921,894,893,-1,850,922,923,-1,868,864,865,-1,924,8,10,-1,924,857,8,-1,9,925,861,-1,861,10,9,-1,178,181,899,-1,181,853,899,-1,851,926,852,-1,870,927,928,-1,922,846,831,-1,922,850,846,-1,849,848,846,-1,841,848,842,-1,841,847,846,-1,829,831,846,-1,843,929,844,-1,843,175,929,-1,842,930,839,-1,175,174,931,-1,931,929,175,-1,837,931,838,-1,932,858,857,-1,932,170,858,-1,169,933,854,-1,866,801,803,-1,832,833,835,-1,835,927,832,-1,835,833,795,-1,828,796,826,-1,826,823,827,-1,826,833,825,-1,823,825,819,-1,822,823,820,-1,827,823,39,-1,827,821,934,-1,934,821,173,-1,819,830,818,-1,819,824,830,-1,814,804,806,-1,814,811,804,-1,813,506,503,-1,503,815,813,-1,847,935,507,-1,507,812,847,-1,804,811,810,-1,810,86,936,-1,810,87,86,-1,809,937,86,-1,66,807,808,-1,808,937,66,-1,221,369,807,-1,822,22,39,-1,822,614,22,-1,803,801,168,-1,801,167,168,-1,795,601,602,-1,828,827,605,-1,827,606,605,-1,800,799,159,-1,791,794,793,-1,791,165,794,-1,585,113,110,-1,938,771,171,-1,771,169,171,-1,939,933,770,-1,939,940,933,-1,786,837,784,-1,784,544,545,-1,785,315,549,-1,549,544,785,-1,780,941,781,-1,941,779,781,-1,942,5,7,-1,943,6,5,-1,779,7,777,-1,943,776,6,-1,776,777,6,-1,775,773,778,-1,773,774,781,-1,774,782,781,-1,774,316,782,-1,774,4,316,-1,571,944,761,-1,919,881,567,-1,756,17,945,-1,18,756,745,-1,18,17,756,-1,946,947,948,-1,946,949,947,-1,754,550,552,-1,552,950,754,-1,752,548,755,-1,755,754,752,-1,49,720,50,-1,59,49,51,-1,51,951,59,-1,266,750,751,-1,751,269,266,-1,31,263,29,-1,767,952,768,-1,952,772,768,-1,263,18,746,-1,757,743,953,-1,757,744,743,-1,741,954,740,-1,741,744,954,-1,565,630,740,-1,668,741,740,-1,740,739,668,-1,733,132,38,-1,29,33,32,-1,244,729,242,-1,718,250,725,-1,718,251,250,-1,60,955,719,-1,955,956,719,-1,725,726,709,-1,957,958,959,-1,695,960,712,-1,712,696,695,-1,695,961,960,-1,695,703,961,-1,962,716,714,-1,710,963,708,-1,963,964,708,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_4()
		{
			int[] value = {701,965,966,-1,701,706,965,-1,701,700,706,-1,703,695,694,-1,967,968,969,-1,710,707,702,-1,962,961,702,-1,961,700,702,-1,961,703,700,-1,970,699,971,-1,970,697,699,-1,966,689,246,-1,966,965,689,-1,704,692,691,-1,704,694,692,-1,972,973,696,-1,690,974,691,-1,974,975,691,-1,976,689,977,-1,976,688,689,-1,736,684,687,-1,736,737,684,-1,978,687,686,-1,978,979,687,-1,980,981,982,-1,980,983,981,-1,680,984,985,-1,986,680,262,-1,262,261,986,-1,987,988,661,-1,674,989,990,-1,674,675,989,-1,664,677,660,-1,664,678,677,-1,991,669,992,-1,991,668,669,-1,660,993,664,-1,338,661,663,-1,423,518,422,-1,518,956,422,-1,525,720,719,-1,525,524,720,-1,994,995,660,-1,656,648,658,-1,656,989,648,-1,654,996,646,-1,646,645,654,-1,665,650,652,-1,650,633,651,-1,650,739,631,-1,645,634,647,-1,997,657,658,-1,658,998,997,-1,636,54,994,-1,640,334,330,-1,330,627,640,-1,635,999,613,-1,999,1000,613,-1,652,1001,999,-1,609,1002,1001,-1,1001,598,609,-1,598,651,633,-1,632,594,593,-1,632,631,591,-1,1003,1004,1005,-1,613,616,618,-1,613,614,616,-1,613,1000,612,-1,1006,610,612,-1,1002,609,1006,-1,609,42,1006,-1,44,611,610,-1,20,22,610,-1,43,611,44,-1,608,606,1007,-1,612,22,614,-1,21,39,22,-1,21,40,39,-1,593,596,597,-1,592,581,596,-1,593,592,596,-1,591,592,594,-1,581,592,563,-1,587,589,582,-1,588,793,589,-1,588,791,793,-1,585,1008,583,-1,1008,586,583,-1,590,587,1009,-1,587,582,1009,-1,1009,582,580,-1,580,1010,1009,-1,572,556,570,-1,572,584,554,-1,1011,561,569,-1,1011,1012,561,-1,561,564,567,-1,566,564,565,-1,1012,562,561,-1,556,555,557,-1,944,556,558,-1,944,571,570,-1,570,556,944,-1,2,1,553,-1,550,755,551,-1,308,307,549,-1,307,542,549,-1,530,541,546,-1,530,539,541,-1,543,542,547,-1,534,1013,535,-1,534,527,1013,-1,535,1013,1014,-1,1013,930,1014,-1,1015,529,528,-1,528,526,527,-1,527,534,528,-1,526,523,522,-1,518,523,525,-1,518,517,523,-1,519,521,522,-1,517,513,519,-1,423,513,518,-1,421,515,513,-1,519,513,512,-1,509,498,505,-1,509,499,498,-1,498,500,505,-1,509,507,935,-1,509,505,507,-1,500,503,506,-1,500,504,503,-1,84,83,502,-1,502,501,84,-1,508,500,496,-1,489,497,499,-1,1016,494,493,-1,1017,1018,508,-1,1019,77,1016,-1,495,1020,1021,-1,516,488,1022,-1,1023,1020,491,-1,484,481,1024,-1,483,485,486,-1,481,1025,464,-1,476,461,460,-1,476,477,461,-1,476,427,426,-1,476,475,427,-1,474,1026,472,-1,472,463,471,-1,465,473,471,-1,465,1027,473,-1,1028,470,469,-1,1029,1030,1031,-1,464,343,345,-1,464,1025,343,-1,1032,1033,1034,-1,1035,1036,1037,-1,1038,1039,446,-1,1040,1041,447,-1,1042,459,458,-1,1043,450,449,-1,431,430,443,-1,444,417,443,-1,417,441,443,-1,1035,1044,1021,-1,218,417,1045,-1,1045,440,218,-1,439,419,418,-1,1045,1046,438,-1,438,439,1045,-1,439,440,1045,-1,436,430,433,-1,1047,437,433,-1,433,434,1047,-1,1048,387,413,-1,304,207,908,-1,428,140,135,-1,135,1049,428,-1,429,1050,138,-1,1050,1051,138,-1,1030,148,1052,-1,1052,1028,1030,-1,1029,424,425,-1,425,146,1029,-1,63,62,422,-1,219,418,412,-1,211,213,416,-1,213,78,416,-1,415,410,411,-1,415,1053,404,-1,72,217,154,-1,154,387,1054,-1,154,412,387,-1,406,93,408,-1,402,400,403,-1,402,401,400,-1,399,397,96,-1,397,395,96,-1,394,97,395,-1,394,1055,97,-1,398,1056,101,-1,399,401,1057,-1,402,414,1058,-1,402,405,414,-1,157,396,397,-1,157,158,396,-1,392,1059,89,-1,1059,90,89,-1,1060,391,101,-1,101,1056,1060,-1,912,191,390,-1,390,1061,912,-1,390,389,1061,-1,186,389,390,-1,1060,1062,391,-1,385,391,382,-1,391,1062,382,-1,1063,386,378,-1,386,379,378,-1,378,1064,1063,-1,912,1061,380,-1,380,379,912,-1,379,388,912,-1,275,187,186,-1,187,275,1065,-1,101,226,373,-1,369,221,220,-1,220,16,369,-1,363,805,366,-1,615,617,1066,-1,617,805,1066,-1,364,368,358,-1,368,15,358,-1,16,375,362,-1,71,14,362,-1,353,239,372,-1,14,71,104,-1,359,354,15,-1,354,1067,358,-1,1067,365,358,-1,371,372,1068,-1,103,359,104,-1,223,222,281,-1,354,359,222,-1,360,1069,1070,-1,1071,1072,235,-1,235,1073,1071,-1,1074,347,1075,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_5()
		{
			int[] value = {1074,346,347,-1,1076,346,1077,-1,1078,1079,337,-1,337,1080,1078,-1,1081,327,339,-1,338,1082,339,-1,333,1078,339,-1,1079,335,337,-1,640,1075,335,-1,333,1079,1078,-1,333,332,1079,-1,637,330,329,-1,329,995,637,-1,664,993,662,-1,197,1083,323,-1,323,196,197,-1,195,321,318,-1,315,4,3,-1,952,314,772,-1,952,312,314,-1,312,553,313,-1,1084,551,755,-1,755,310,1084,-1,310,755,548,-1,548,311,310,-1,1085,236,298,-1,1085,234,236,-1,438,444,436,-1,438,1046,444,-1,186,390,276,-1,1072,1071,1086,-1,233,296,231,-1,1087,1088,1089,-1,1087,228,1088,-1,1090,1087,1091,-1,1087,1089,1091,-1,1091,1092,1093,-1,1091,1089,1092,-1,192,1094,904,-1,1094,1095,904,-1,1090,291,1087,-1,291,290,1087,-1,1096,376,301,-1,301,303,1096,-1,38,37,746,-1,183,1097,673,-1,183,273,1097,-1,673,685,671,-1,673,1097,685,-1,735,953,1098,-1,735,747,953,-1,55,271,56,-1,269,264,266,-1,269,268,264,-1,59,267,61,-1,699,257,1099,-1,1099,971,699,-1,33,253,252,-1,33,36,253,-1,974,690,1100,-1,1100,1101,974,-1,1102,688,976,-1,976,1103,1102,-1,973,693,696,-1,693,692,696,-1,23,1104,244,-1,1069,70,352,-1,70,239,352,-1,151,150,468,-1,468,321,151,-1,1105,1106,1107,-1,106,108,234,-1,236,235,1072,-1,1072,299,236,-1,292,229,290,-1,292,295,229,-1,283,228,227,-1,283,1088,228,-1,224,223,227,-1,223,283,227,-1,361,1108,373,-1,67,66,937,-1,937,117,67,-1,217,72,74,-1,374,1109,361,-1,374,1110,1109,-1,117,937,809,-1,809,115,117,-1,121,214,82,-1,82,123,121,-1,305,208,207,-1,305,432,208,-1,136,205,905,-1,905,133,136,-1,1111,203,202,-1,1111,1112,203,-1,204,143,199,-1,204,141,143,-1,201,198,196,-1,201,200,198,-1,145,147,193,-1,193,197,145,-1,1113,301,100,-1,100,99,1113,-1,440,219,218,-1,776,943,553,-1,943,313,553,-1,174,176,926,-1,926,1114,174,-1,181,856,851,-1,181,180,856,-1,783,1115,1116,-1,1116,1117,783,-1,603,20,611,-1,603,21,20,-1,1118,1119,1120,-1,1120,1121,1118,-1,112,1122,760,-1,763,1123,759,-1,763,787,1123,-1,171,932,1124,-1,171,170,932,-1,800,159,794,-1,159,163,794,-1,110,168,166,-1,110,109,168,-1,361,1109,1108,-1,91,155,88,-1,414,153,1125,-1,1125,1058,414,-1,414,72,153,-1,414,73,72,-1,137,136,140,-1,136,135,140,-1,147,425,194,-1,147,146,425,-1,198,148,145,-1,198,1052,148,-1,203,144,141,-1,203,1126,144,-1,139,138,1051,-1,1051,1112,139,-1,133,1127,134,-1,1127,209,134,-1,278,907,1128,-1,278,1128,1129,-1,1129,280,278,-1,376,1096,356,-1,356,371,376,-1,132,253,36,-1,132,131,253,-1,1130,981,983,-1,131,1131,253,-1,1131,255,253,-1,1132,244,243,-1,243,1133,1132,-1,415,122,125,-1,415,411,122,-1,1055,119,116,-1,98,114,93,-1,1123,111,112,-1,1134,111,789,-1,113,111,110,-1,802,109,111,-1,1135,1105,348,-1,1135,1106,1105,-1,281,103,102,-1,104,359,14,-1,376,371,377,-1,394,119,1055,-1,94,93,115,-1,98,400,96,-1,95,408,93,-1,85,87,83,-1,92,94,85,-1,85,84,92,-1,85,809,86,-1,1019,78,77,-1,79,78,80,-1,76,212,73,-1,435,419,439,-1,439,438,435,-1,1068,225,226,-1,955,65,63,-1,955,261,65,-1,619,1136,622,-1,619,636,1136,-1,659,994,660,-1,484,1024,488,-1,43,42,604,-1,608,604,606,-1,491,490,1137,-1,38,132,36,-1,32,1138,30,-1,31,748,26,-1,748,27,26,-1,1104,23,25,-1,24,749,25,-1,746,37,263,-1,368,16,15,-1,238,1139,1140,-1,238,237,1139,-1,177,175,843,-1,312,952,947,-1,775,1,0,-1,4,775,0,-1,3,0,2,-1,1079,334,335,-1,1079,332,334,-1,1136,994,659,-1,1136,636,994,-1,68,215,220,-1,68,119,215,-1,285,353,286,-1,353,285,352,-1,1087,229,228,-1,290,229,1087,-1,1134,1141,111,-1,1142,1141,1134,-1,113,1122,112,-1,571,1122,113,-1,111,787,789,-1,787,111,1123,-1,97,114,98,-1,118,114,97,-1,123,120,121,-1,122,120,123,-1,124,1143,125,-1,1143,124,210,-1,76,210,212,-1,76,1143,210,-1,1132,23,244,-1,1132,24,23,-1,1144,1133,1145,-1,1144,1146,1133,-1,1145,723,1144,-1,723,1145,1147,-1,723,126,724,-1,723,1147,126,-1,724,128,1148,-1,724,126,128,-1,128,1099,1149,-1,128,129,1099,-1,1149,257,259,-1,1149,1099,257,-1,256,245,1150,-1,256,258,245,-1,1150,247,1151,-1,1150,245,247,-1,1151,1102,1152,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_6()
		{
			int[] value = {1151,247,1102,-1,1103,1152,1102,-1,1153,1152,1103,-1,1154,981,1130,-1,1155,981,1154,-1,1154,1156,1155,-1,1156,1154,1157,-1,1158,1156,1157,-1,978,1156,1158,-1,978,1159,979,-1,978,1158,1159,-1,979,1160,1161,-1,979,1159,1160,-1,1160,732,1161,-1,732,1160,1131,-1,130,1131,131,-1,130,732,1131,-1,1130,1162,1101,-1,1163,1162,1130,-1,1162,1103,1101,-1,1162,1153,1103,-1,356,1164,357,-1,1164,356,1096,-1,1165,1166,1093,-1,1166,1165,1167,-1,1168,1091,1169,-1,1168,1090,1091,-1,291,1170,289,-1,1170,291,1171,-1,280,1172,1173,-1,280,1129,1172,-1,1169,1093,1166,-1,1091,1093,1169,-1,1112,1126,203,-1,1112,1051,1126,-1,1174,198,200,-1,1174,1052,198,-1,194,149,151,-1,194,425,149,-1,153,393,1125,-1,153,152,393,-1,1125,89,88,-1,1125,393,89,-1,398,1108,156,-1,1108,398,373,-1,155,398,156,-1,155,91,398,-1,794,167,800,-1,165,167,794,-1,1124,1175,790,-1,1124,932,1175,-1,759,112,760,-1,759,1123,112,-1,787,762,788,-1,762,787,763,-1,1176,768,938,-1,768,1176,766,-1,952,948,947,-1,767,948,952,-1,764,1177,769,-1,1177,764,1178,-1,1121,1179,765,-1,1179,1121,1120,-1,603,43,608,-1,603,611,43,-1,1180,783,1117,-1,783,1180,780,-1,926,856,1114,-1,926,851,856,-1,942,1181,939,-1,941,1181,942,-1,1181,780,1180,-1,941,780,1181,-1,313,5,770,-1,943,5,313,-1,302,1182,1065,-1,302,1183,1182,-1,1113,302,301,-1,1113,1183,302,-1,1184,1112,1111,-1,1184,139,1112,-1,209,908,207,-1,209,1127,908,-1,1094,434,910,-1,434,1094,1047,-1,1127,905,908,-1,1127,133,905,-1,435,420,419,-1,437,420,435,-1,215,374,220,-1,216,374,215,-1,216,1110,374,-1,1076,321,1185,-1,1076,319,321,-1,285,102,1070,-1,287,102,285,-1,283,1186,1088,-1,282,1186,283,-1,297,292,1187,-1,295,292,297,-1,299,1086,1188,-1,299,1072,1086,-1,1107,107,106,-1,1107,1106,107,-1,13,348,1105,-1,13,349,348,-1,1189,1190,324,-1,1189,1191,1190,-1,320,1192,1193,-1,320,1077,1192,-1,750,1194,1146,-1,750,749,1194,-1,974,1103,976,-1,1103,974,1101,-1,257,698,258,-1,257,699,698,-1,1100,693,1195,-1,1100,690,693,-1,1196,972,1197,-1,1196,973,972,-1,987,1198,988,-1,987,1199,1198,-1,56,990,57,-1,56,1200,990,-1,1201,676,674,-1,1201,1202,676,-1,735,746,747,-1,38,746,735,-1,1203,953,743,-1,1098,953,1203,-1,991,738,742,-1,991,737,738,-1,671,684,992,-1,671,685,684,-1,65,679,64,-1,65,262,679,-1,274,190,903,-1,276,190,274,-1,1204,1096,303,-1,1204,1164,1096,-1,274,1167,288,-1,274,1166,1167,-1,294,227,229,-1,227,294,224,-1,1095,1168,904,-1,1095,1171,1168,-1,1169,904,1168,-1,904,1169,903,-1,1170,911,1173,-1,911,1170,909,-1,1092,1088,1186,-1,1089,1088,1092,-1,300,1188,906,-1,1188,300,299,-1,232,1172,1129,-1,232,1187,1172,-1,230,906,1188,-1,1128,906,230,-1,906,1128,907,-1,987,326,64,-1,987,661,326,-1,298,206,1085,-1,206,298,205,-1,955,422,956,-1,955,63,422,-1,306,548,307,-1,306,311,548,-1,306,1084,310,-1,306,309,1084,-1,237,322,324,-1,1205,322,237,-1,193,1083,197,-1,193,1206,1083,-1,201,323,322,-1,201,196,323,-1,199,11,204,-1,199,1205,11,-1,1207,202,1208,-1,1111,202,1207,-1,995,993,660,-1,993,995,329,-1,662,329,328,-1,662,993,329,-1,347,335,1075,-1,335,347,336,-1,333,1082,331,-1,333,339,1082,-1,339,1080,1081,-1,339,1078,1080,-1,1209,1080,340,-1,1209,1081,1080,-1,1206,1189,1083,-1,1206,1193,1189,-1,1205,12,11,-1,1205,237,12,-1,1107,1208,1105,-1,1207,1208,1107,-1,234,1210,106,-1,1085,1210,234,-1,1077,1074,1192,-1,1074,1077,346,-1,1074,629,1211,-1,1074,1075,629,-1,1191,1212,1190,-1,1212,1191,1211,-1,1212,1213,1214,-1,1212,628,1213,-1,1215,626,1216,-1,1215,1217,626,-1,1139,1215,1140,-1,1215,1139,1214,-1,238,351,349,-1,238,1140,351,-1,108,1073,235,-1,105,1073,108,-1,107,1218,105,-1,107,1219,1218,-1,1220,1071,1073,-1,1071,1220,1221,-1,1222,293,296,-1,293,1222,1223,-1,1135,1224,1219,-1,1135,1225,1224,-1,1226,1220,1218,-1,1220,1226,1227,-1,1228,1222,1221,-1,1222,1228,1229,-1,1230,1231,1223,-1,1231,1230,1232,-1,1233,1232,1230,-1,1233,1234,1232,-1,1235,1229,1228,-1,1235,1236,1229,-1,1237,1227,1226,-1,1237,1238,1227,-1,1239,1224,1225,-1,1239,1240,1224,-1,351,1241,350,-1,1241,351,1216,-1,1241,624,1239,-1,1241,625,624,-1,1237,623,621,-1,1237,1240,623,-1,620,1235,1238,-1,1235,620,1242,-1,1005,1233,1236,-1,1233,1005,1004,-1,1243,1244,1234,-1,1244,1243,1245,-1,1244,354,355,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_7()
		{
			int[] value = {1067,354,1244,-1,224,1231,222,-1,294,1231,224,-1,70,360,71,-1,70,1069,360,-1,103,222,359,-1,103,281,222,-1,225,372,239,-1,372,225,1068,-1,1246,365,1067,-1,1246,1066,365,-1,362,361,71,-1,361,362,375,-1,805,365,1066,-1,363,365,805,-1,189,387,1048,-1,388,387,189,-1,378,383,382,-1,380,383,378,-1,382,1064,378,-1,1064,382,1062,-1,1247,1063,392,-1,1247,386,1063,-1,1062,1059,1064,-1,1060,1059,1062,-1,188,1061,389,-1,1061,1182,384,-1,1061,188,1182,-1,385,1183,1113,-1,385,381,1183,-1,1059,1056,90,-1,1059,1060,1056,-1,157,399,1057,-1,157,397,399,-1,402,1057,401,-1,402,1058,1057,-1,91,1056,398,-1,91,90,1056,-1,216,396,1110,-1,216,394,396,-1,394,216,119,-1,154,1247,152,-1,1054,1247,154,-1,413,418,420,-1,413,412,418,-1,1030,146,148,-1,1030,1029,146,-1,470,1052,1174,-1,470,1028,1052,-1,1051,477,1126,-1,1050,477,1051,-1,1248,135,134,-1,1248,1049,135,-1,1248,209,208,-1,1248,134,209,-1,1048,420,1094,-1,1048,413,420,-1,444,1045,417,-1,444,1046,1045,-1,1249,1250,1023,-1,1249,1251,1250,-1,1036,1023,1250,-1,1020,1023,1036,-1,431,1252,1248,-1,431,443,1252,-1,1049,1253,428,-1,1049,1254,1253,-1,1255,1050,429,-1,1050,1255,1256,-1,456,450,1257,-1,456,453,450,-1,1258,447,1257,-1,447,1258,445,-1,1043,1259,450,-1,1043,1260,1259,-1,1042,447,1041,-1,1042,458,447,-1,446,1040,447,-1,1039,1040,446,-1,1038,445,1037,-1,1038,446,445,-1,1261,1262,1033,-1,1261,1258,1262,-1,1033,1263,1264,-1,1033,1262,1263,-1,1265,1043,1266,-1,1265,1260,1043,-1,1267,448,1268,-1,1267,449,448,-1,452,1269,1270,-1,1269,452,451,-1,455,462,1271,-1,462,455,454,-1,457,1272,1273,-1,1272,457,459,-1,1274,1041,1275,-1,1274,1042,1041,-1,1039,1276,1040,-1,1251,1276,1039,-1,1250,1037,1036,-1,1250,1038,1037,-1,1035,1261,1044,-1,1035,1037,1261,-1,1034,1264,1277,-1,1264,1034,1033,-1,1019,1277,442,-1,1019,1034,1277,-1,441,1266,443,-1,441,1265,1266,-1,1252,1268,1254,-1,1252,1267,1268,-1,1269,1256,1255,-1,1256,1269,1271,-1,1273,1278,1279,-1,1278,1273,1272,-1,1280,1275,478,-1,1280,1274,1275,-1,1281,1251,1249,-1,1281,1276,1251,-1,340,487,1209,-1,342,487,340,-1,1027,1030,1028,-1,1027,1031,1030,-1,424,1031,467,-1,424,1029,1031,-1,469,1027,1028,-1,1027,469,473,-1,460,475,476,-1,475,460,1279,-1,1278,1026,474,-1,1026,1278,1280,-1,482,463,472,-1,463,482,464,-1,1025,484,342,-1,484,1025,481,-1,1022,1249,1137,-1,1249,1022,1281,-1,1022,1024,479,-1,1024,1022,488,-1,1137,516,1022,-1,514,516,1137,-1,511,489,499,-1,511,490,489,-1,493,1021,1044,-1,493,495,1021,-1,1032,1019,1016,-1,1032,1034,1019,-1,1016,79,1017,-1,1016,77,79,-1,214,1017,82,-1,1018,1017,214,-1,494,1017,508,-1,1016,1017,494,-1,497,491,1020,-1,489,491,497,-1,84,1018,214,-1,1018,84,501,-1,935,1282,509,-1,1282,935,840,-1,520,509,1282,-1,510,509,520,-1,519,510,520,-1,512,510,519,-1,532,1015,528,-1,532,531,1015,-1,839,1013,1283,-1,1013,839,930,-1,1014,536,535,-1,536,1014,1284,-1,1283,527,521,-1,527,1283,1013,-1,545,1285,786,-1,538,1285,545,-1,753,530,546,-1,753,533,530,-1,317,308,549,-1,317,551,308,-1,1286,944,558,-1,1286,761,944,-1,1287,1011,569,-1,579,1011,1287,-1,590,575,574,-1,590,1009,575,-1,1011,1010,1012,-1,1011,577,1010,-1,574,588,590,-1,588,574,1288,-1,1288,791,588,-1,1288,792,791,-1,582,595,581,-1,595,582,589,-1,591,565,560,-1,591,630,565,-1,595,162,596,-1,595,161,162,-1,172,608,1007,-1,608,172,603,-1,44,1006,42,-1,44,610,1006,-1,1006,1000,1002,-1,1006,612,1000,-1,1289,1246,1245,-1,1289,1290,1246,-1,1003,1243,1004,-1,1003,1291,1243,-1,1005,1292,1003,-1,1292,1005,1242,-1,1213,638,1217,-1,639,638,1213,-1,631,593,633,-1,631,632,593,-1,598,652,651,-1,652,598,1001,-1,1001,1000,999,-1,1001,1002,1000,-1,615,643,647,-1,643,615,1290,-1,1289,649,641,-1,649,1289,1291,-1,997,1003,1292,-1,997,998,1003,-1,54,995,994,-1,637,995,54,-1,997,659,657,-1,997,1136,659,-1,1293,652,999,-1,652,1293,665,-1,996,1293,646,-1,996,1294,1293,-1,644,989,675,-1,989,644,648,-1,525,956,518,-1,525,719,956,-1,662,338,663,-1,662,1082,338,-1,669,666,672,-1,669,667,666,-1,184,1294,996,-1,670,1294,184,-1,182,996,654,-1,182,184,996,-1,57,989,656,-1,57,990,989,-1,986,984,680,-1,986,1148,984,-1,1295,1199,985,-1,1295,1198,1199,-1,1296,985,984,-1,1296,1295,985,-1,1198,682,272,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_8()
		{
			int[] value = {1198,1295,682,-1,271,1297,56,-1,271,681,1297,-1,1298,1299,1297,-1,1300,1299,1298,-1,1299,1201,1200,-1,1299,1301,1201,-1,1302,980,1301,-1,983,980,1302,-1,185,980,982,-1,1202,980,185,-1,1155,982,981,-1,1155,1303,982,-1,1303,1097,273,-1,1303,1304,1097,-1,1304,978,686,-1,978,1304,1156,-1,1161,687,979,-1,1161,736,687,-1,974,977,975,-1,974,976,977,-1,691,705,704,-1,705,691,975,-1,965,977,689,-1,965,706,977,-1,248,966,246,-1,1305,966,248,-1,260,970,971,-1,970,260,964,-1,1306,962,702,-1,1307,962,1306,-1,963,702,969,-1,963,710,702,-1,966,967,701,-1,966,1305,967,-1,697,967,1305,-1,968,967,697,-1,969,964,963,-1,969,970,964,-1,1306,959,1308,-1,1306,1309,959,-1,1307,716,962,-1,1307,717,716,-1,960,962,714,-1,962,960,961,-1,712,714,713,-1,714,712,960,-1,1308,958,1310,-1,1308,959,958,-1,726,959,709,-1,957,959,726,-1,709,718,725,-1,718,709,708,-1,61,986,261,-1,61,721,986,-1,957,240,242,-1,957,726,240,-1,242,958,957,-1,729,958,242,-1,244,727,729,-1,244,1104,727,-1,715,728,1138,-1,715,1310,728,-1,35,1138,32,-1,715,1138,35,-1,730,1098,1203,-1,730,734,1098,-1,954,565,740,-1,566,565,954,-1,757,954,744,-1,757,758,954,-1,745,953,747,-1,745,757,953,-1,524,50,720,-1,524,529,50,-1,50,1015,48,-1,50,529,1015,-1,533,1311,531,-1,873,1311,533,-1,552,883,950,-1,883,552,2,-1,312,949,886,-1,949,312,947,-1,945,758,756,-1,945,568,758,-1,568,919,567,-1,568,945,919,-1,881,569,567,-1,1287,569,881,-1,559,1312,558,-1,559,880,1312,-1,1120,918,917,-1,1120,1286,918,-1,1120,1119,1286,-1,1313,1178,1179,-1,1178,1313,1314,-1,1315,948,1177,-1,946,948,1315,-1,761,1121,759,-1,761,1118,1121,-1,779,773,781,-1,779,778,773,-1,942,779,941,-1,942,7,779,-1,1116,315,785,-1,1116,316,315,-1,1116,1115,316,-1,1180,784,837,-1,1180,1117,784,-1,940,1181,836,-1,940,939,1181,-1,770,169,771,-1,770,933,169,-1,938,1124,1176,-1,938,171,1124,-1,166,585,110,-1,1008,585,166,-1,159,798,160,-1,798,159,799,-1,827,1007,606,-1,827,934,1007,-1,816,614,822,-1,614,816,616,-1,367,810,936,-1,366,810,367,-1,221,66,68,-1,66,221,807,-1,86,808,936,-1,937,808,86,-1,847,840,935,-1,847,841,840,-1,503,811,815,-1,811,503,502,-1,847,830,829,-1,847,812,830,-1,39,821,827,-1,39,41,821,-1,833,796,795,-1,833,826,796,-1,866,797,801,-1,866,928,797,-1,803,867,866,-1,867,803,802,-1,836,855,940,-1,836,838,855,-1,858,169,854,-1,170,169,858,-1,924,932,857,-1,1175,932,924,-1,174,838,931,-1,174,1114,838,-1,786,931,837,-1,931,786,1285,-1,1316,844,929,-1,844,1316,1284,-1,1014,842,845,-1,842,1014,930,-1,834,922,831,-1,1317,922,834,-1,927,1318,832,-1,870,1318,927,-1,868,928,866,-1,868,870,928,-1,9,899,925,-1,9,178,899,-1,913,864,1319,-1,864,913,862,-1,1141,859,1319,-1,1141,1142,859,-1,1320,896,1321,-1,1320,1322,896,-1,870,1320,1318,-1,870,869,1320,-1,1317,923,922,-1,1317,1321,923,-1,923,894,921,-1,895,894,923,-1,850,921,849,-1,850,923,921,-1,871,892,872,-1,871,893,892,-1,264,951,875,-1,264,268,951,-1,46,1311,920,-1,1311,46,48,-1,901,874,754,-1,874,901,890,-1,891,920,887,-1,46,920,891,-1,945,916,919,-1,945,1323,916,-1,1312,914,918,-1,1312,897,914,-1,1324,917,914,-1,1313,917,1324,-1,1325,1315,1314,-1,1315,1325,1326,-1,900,949,946,-1,949,900,898,-1,902,754,950,-1,754,902,901,-1,1322,916,1323,-1,916,1322,915,-1,914,860,1324,-1,914,913,860,-1,861,1326,1325,-1,1326,861,925,-1,852,885,884,-1,885,852,926,-1,1165,286,357,-1,286,1165,284,-1,305,911,910,-1,911,305,279,-1,304,278,277,-1,907,278,304,-1,1095,910,909,-1,1095,1094,910,-1,902,926,176,-1,902,885,926,-1,925,900,1326,-1,900,925,899,-1,1325,860,861,-1,1325,1324,860,-1,896,1323,879,-1,1323,896,1322,-1,893,47,892,-1,876,47,893,-1,892,887,889,-1,891,887,892,-1,950,885,902,-1,950,883,885,-1,898,886,949,-1,886,898,884,-1,1326,946,1315,-1,946,1326,900,-1,1324,1314,1313,-1,1314,1324,1325,-1,880,897,1312,-1,880,882,897,-1,17,1323,945,-1,17,879,1323,-1,875,51,45,-1,951,51,875,-1,920,873,874,-1,1311,873,920,-1,1318,1321,1317,-1,1318,1320,1321,-1,895,1321,896,-1,923,1321,895,-1,869,1322,1320,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_9()
		{
			int[] value = {869,915,1322,-1,863,869,865,-1,863,915,869,-1,1319,867,1141,-1,867,1319,864,-1,10,1142,924,-1,1142,10,859,-1,1319,860,913,-1,1319,859,860,-1,854,179,858,-1,854,180,179,-1,832,1317,834,-1,1318,1317,832,-1,845,1284,1014,-1,845,844,1284,-1,1285,929,931,-1,929,1285,1316,-1,1175,1142,1134,-1,1175,924,1142,-1,940,854,933,-1,940,855,854,-1,1114,855,838,-1,1114,856,855,-1,835,928,927,-1,928,835,797,-1,831,825,834,-1,831,824,825,-1,822,817,816,-1,822,820,817,-1,818,812,813,-1,812,818,830,-1,814,817,815,-1,814,816,817,-1,87,502,83,-1,87,811,502,-1,370,936,808,-1,370,367,936,-1,804,366,805,-1,810,366,804,-1,617,816,806,-1,617,616,816,-1,797,799,801,-1,797,798,799,-1,796,605,601,-1,828,605,796,-1,792,166,165,-1,792,1008,166,-1,1176,790,788,-1,1176,1124,790,-1,836,1180,837,-1,836,1181,1180,-1,1117,785,784,-1,1117,1116,785,-1,316,783,782,-1,1115,783,316,-1,772,938,768,-1,938,772,771,-1,762,769,766,-1,762,764,769,-1,759,765,763,-1,759,1121,765,-1,760,571,761,-1,760,1122,571,-1,1314,1177,1178,-1,1314,1315,1177,-1,917,1179,1120,-1,1179,917,1313,-1,558,918,1286,-1,558,1312,918,-1,1287,880,559,-1,1287,881,880,-1,886,2,312,-1,886,883,2,-1,873,753,752,-1,873,533,753,-1,531,48,1015,-1,1311,48,531,-1,727,25,748,-1,25,727,1104,-1,568,954,758,-1,568,566,954,-1,731,1203,738,-1,731,730,1203,-1,734,735,1098,-1,734,733,735,-1,732,734,730,-1,734,732,130,-1,1161,731,736,-1,1161,732,731,-1,727,1138,728,-1,30,1138,727,-1,729,1310,958,-1,729,728,1310,-1,1146,751,750,-1,1146,1144,751,-1,1144,722,751,-1,1144,723,722,-1,722,61,267,-1,721,61,722,-1,721,1148,986,-1,721,724,1148,-1,718,964,260,-1,708,964,718,-1,1310,717,1308,-1,1310,715,717,-1,716,34,714,-1,35,34,716,-1,34,252,713,-1,34,33,252,-1,972,712,711,-1,972,696,712,-1,1307,1308,717,-1,1307,1306,1308,-1,1309,709,959,-1,1309,707,709,-1,970,968,697,-1,969,968,970,-1,700,704,705,-1,700,703,704,-1,701,969,702,-1,701,967,969,-1,702,1309,1306,-1,707,1309,702,-1,1305,698,697,-1,1305,248,698,-1,705,977,706,-1,705,975,977,-1,742,668,991,-1,742,741,668,-1,1097,686,685,-1,686,1097,1304,-1,1303,1156,1304,-1,1303,1155,1156,-1,982,273,185,-1,1303,273,982,-1,1301,1202,1201,-1,980,1202,1301,-1,1300,1301,1299,-1,1300,1302,1301,-1,1297,1200,56,-1,1299,1200,1297,-1,1298,681,683,-1,681,1298,1297,-1,272,681,271,-1,681,272,682,-1,683,1295,1296,-1,1295,683,682,-1,679,985,1199,-1,679,680,985,-1,678,661,988,-1,678,663,661,-1,988,677,678,-1,988,270,677,-1,656,58,57,-1,656,655,58,-1,676,654,653,-1,676,182,654,-1,184,673,670,-1,673,184,183,-1,1294,672,666,-1,1294,670,672,-1,992,672,671,-1,992,669,672,-1,650,668,739,-1,668,650,667,-1,675,642,644,-1,675,653,642,-1,1294,665,1293,-1,1294,666,665,-1,649,658,648,-1,649,998,658,-1,646,999,635,-1,646,1293,999,-1,627,637,639,-1,330,637,627,-1,54,638,637,-1,54,53,638,-1,1292,1136,997,-1,1136,1292,622,-1,998,1291,1003,-1,998,649,1291,-1,1290,641,643,-1,641,1290,1289,-1,647,618,615,-1,647,634,618,-1,1075,627,629,-1,627,1075,640,-1,628,639,1213,-1,627,639,628,-1,1217,53,626,-1,638,53,1217,-1,624,53,52,-1,53,624,625,-1,52,621,623,-1,52,619,621,-1,622,1242,620,-1,622,1292,1242,-1,1291,1245,1243,-1,1291,1289,1245,-1,1290,1066,1246,-1,1290,615,1066,-1,607,599,605,-1,607,597,599,-1,604,609,607,-1,609,604,42,-1,600,798,602,-1,164,798,600,-1,164,160,798,-1,162,600,596,-1,162,164,600,-1,793,595,589,-1,163,595,793,-1,163,161,595,-1,792,586,1008,-1,1288,586,792,-1,576,1288,574,-1,576,586,1288,-1,583,570,113,-1,583,572,570,-1,580,1012,1010,-1,1012,580,562,-1,579,577,1011,-1,579,578,577,-1,573,555,554,-1,573,578,555,-1,577,1009,1010,-1,575,1009,577,-1,554,576,573,-1,554,584,576,-1,579,559,557,-1,579,1287,559,-1,1286,1118,761,-1,1286,1119,1118,-1,552,317,3,-1,552,550,317,-1,548,546,547,-1,548,753,546,-1,543,538,545,-1,543,541,538,-1,1316,538,540,-1,538,1316,1285,-1,536,539,537,-1,539,536,540,-1,1284,540,536,-1,540,1284,1316,-1,537,530,532,-1,539,530,537,-1,537,528,534,-1,537,532,528,-1,1282,521,520,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_10()
		{
			int[] value = {1282,1283,521,-1,485,516,515,-1,485,488,516,-1,499,512,511,-1,499,510,512,-1,1283,840,839,-1,1283,1282,840,-1,508,501,504,-1,508,1018,501,-1,1020,492,497,-1,495,492,1020,-1,508,492,494,-1,496,492,508,-1,79,82,1017,-1,79,80,82,-1,493,1032,1016,-1,493,1044,1032,-1,514,490,511,-1,514,1137,490,-1,1281,479,478,-1,479,1281,1022,-1,1023,1137,1249,-1,1023,491,1137,-1,342,483,487,-1,484,483,342,-1,481,479,1024,-1,482,479,481,-1,482,480,479,-1,472,480,482,-1,472,1026,480,-1,1026,478,480,-1,1026,1280,478,-1,1279,474,475,-1,474,1279,1278,-1,473,474,472,-1,474,473,469,-1,467,1027,465,-1,467,1031,1027,-1,150,467,468,-1,149,467,150,-1,424,467,149,-1,344,466,463,-1,344,1185,466,-1,486,1209,487,-1,486,325,1209,-1,478,1276,1281,-1,478,1275,1276,-1,1272,1280,1278,-1,1280,1272,1274,-1,462,1279,460,-1,1279,462,1273,-1,1271,461,1256,-1,461,1271,462,-1,1270,1255,1253,-1,1255,1270,1269,-1,1266,1252,443,-1,1252,1266,1267,-1,442,1265,441,-1,442,1277,1265,-1,1044,1033,1032,-1,1044,1261,1033,-1,1251,1038,1250,-1,1251,1039,1038,-1,1275,1040,1276,-1,1275,1041,1040,-1,1272,1042,1274,-1,1272,459,1042,-1,454,1273,462,-1,1273,454,457,-1,451,1271,1269,-1,1271,451,455,-1,1268,452,1270,-1,1268,448,452,-1,1043,1267,1266,-1,1267,1043,449,-1,1277,1260,1265,-1,1277,1264,1260,-1,1263,1260,1264,-1,1259,1260,1263,-1,1037,1258,1261,-1,1037,445,1258,-1,456,457,454,-1,457,456,458,-1,453,455,451,-1,455,453,456,-1,453,448,450,-1,452,448,453,-1,1257,1262,1258,-1,1257,1263,1262,-1,450,1263,1257,-1,1259,1263,450,-1,1257,458,456,-1,458,1257,447,-1,1256,477,1050,-1,477,1256,461,-1,1253,429,428,-1,429,1253,1255,-1,1248,1254,1049,-1,1248,1252,1254,-1,78,442,416,-1,78,1019,442,-1,1036,1021,1020,-1,1035,1021,1036,-1,208,431,1248,-1,208,432,431,-1,477,144,1126,-1,477,426,144,-1,1174,427,470,-1,427,1174,142,-1,486,62,325,-1,486,421,62,-1,1268,1253,1254,-1,1270,1253,1268,-1,154,219,412,-1,154,217,219,-1,405,1053,75,-1,1053,405,404,-1,407,409,411,-1,407,406,409,-1,406,400,93,-1,406,403,400,-1,407,404,403,-1,407,410,404,-1,1110,158,1109,-1,396,158,1110,-1,152,392,393,-1,1247,392,152,-1,391,1113,99,-1,385,1113,391,-1,1183,384,1182,-1,381,384,1183,-1,392,1064,1059,-1,392,1063,1064,-1,386,1054,387,-1,1247,1054,386,-1,384,380,1061,-1,384,383,380,-1,275,1204,1065,-1,275,288,1204,-1,220,375,16,-1,374,375,220,-1,101,377,226,-1,101,100,377,-1,368,367,370,-1,368,364,367,-1,377,1068,226,-1,377,371,1068,-1,104,1070,102,-1,104,360,1070,-1,1234,355,1232,-1,1234,1244,355,-1,1245,1067,1244,-1,1245,1246,1067,-1,1004,1234,1233,-1,1234,1004,1243,-1,1236,1242,1005,-1,1236,1235,1242,-1,621,1238,1237,-1,1238,621,620,-1,624,1240,1239,-1,1240,624,623,-1,1216,625,1241,-1,1216,626,625,-1,1241,1225,350,-1,1241,1239,1225,-1,1240,1226,1224,-1,1240,1237,1226,-1,1238,1228,1227,-1,1238,1235,1228,-1,1236,1230,1229,-1,1236,1233,1230,-1,1232,222,1231,-1,222,1232,355,-1,1229,1223,1222,-1,1223,1229,1230,-1,1221,1227,1228,-1,1221,1220,1227,-1,1219,1226,1218,-1,1219,1224,1226,-1,348,1225,1135,-1,348,350,1225,-1,1223,294,293,-1,294,1223,1231,-1,1221,296,1071,-1,296,1221,1222,-1,1073,1218,1220,-1,1073,105,1218,-1,1106,1219,107,-1,1106,1135,1219,-1,1190,1214,1139,-1,1190,1212,1214,-1,1216,1140,1215,-1,1140,1216,351,-1,1214,1217,1215,-1,1214,1213,1217,-1,1211,628,1212,-1,1211,629,628,-1,1192,1211,1191,-1,1192,1074,1211,-1,1207,106,1210,-1,1207,1107,106,-1,11,1105,1208,-1,11,13,1105,-1,324,1083,1189,-1,323,1083,324,-1,318,1193,1206,-1,318,320,1193,-1,347,343,336,-1,345,343,347,-1,341,1080,337,-1,341,340,1080,-1,1209,327,1081,-1,1209,325,327,-1,328,1082,662,-1,1082,328,331,-1,332,328,330,-1,328,332,331,-1,1210,1111,1207,-1,1111,1210,1184,-1,1208,204,11,-1,202,204,1208,-1,199,322,1205,-1,199,201,322,-1,195,1206,193,-1,195,318,1206,-1,1185,346,1076,-1,1185,344,346,-1,551,309,308,-1,1084,309,551,-1,1085,1184,1210,-1,1085,206,1184,-1,303,1065,1204,-1,303,302,1065,-1,1187,289,1172,-1,1187,292,289,-1,296,1086,1071,-1,1086,296,233,-1,295,296,293,-1,297,296,295,-1,284,1093,1092,-1,1093,284,1165,-1,232,1128,230,-1,232,1129,1128,-1,284,1186,287,-1,284,1092,1186,-1,279,1173,911,-1,279,280,1173,-1,909,1171,1095,-1,909,1170,1171,-1,1166,903,1169,-1};
			return value;
		}
		private int[] getloscoxae_Geo_6_14_coordIndex_11()
		{
			int[] value = {903,1166,274,-1,1164,288,1167,-1,288,1164,1204,-1,737,992,684,-1,992,737,991,-1,738,743,742,-1,1203,743,738,-1,1202,182,676,-1,1202,185,182,-1,1200,674,990,-1,1200,1201,674,-1,988,272,270,-1,988,1198,272,-1,64,1199,987,-1,64,679,1199,-1,265,748,25,-1,265,27,748,-1,60,261,955,-1,261,60,61,-1,711,255,1327,-1,255,711,254,-1,247,688,1102,-1,246,688,247,-1,1197,711,1327,-1,1197,972,711,-1,1195,973,1196,-1,1195,693,973,-1,129,971,1099,-1,129,260,971,-1,258,248,245,-1,258,698,248,-1,240,249,241,-1,250,249,240,-1,468,1185,321,-1,468,466,1185,-1,1193,1191,1189,-1,1193,1192,1191,-1,324,1139,237,-1,324,1190,1139,-1,349,12,238,-1,12,349,13,-1,230,1086,233,-1,230,1188,1086,-1,231,1187,232,-1,297,1187,231,-1,282,287,1186,-1,282,102,287,-1,352,1070,1069,-1,285,1070,352,-1,319,1077,320,-1,319,1076,1077,-1,73,211,74,-1,212,211,73,-1,432,910,434,-1,432,305,910,-1,437,1094,420,-1,437,1047,1094,-1,139,206,137,-1,206,139,1184,-1,151,195,194,-1,195,151,321,-1,1065,188,187,-1,1065,1182,188,-1,192,1048,1094,-1,192,189,1048,-1,5,939,770,-1,5,942,939,-1,776,1,775,-1,1,776,553,-1,178,8,179,-1,9,8,178,-1,934,172,1007,-1,934,173,172,-1,765,1178,764,-1,1178,765,1179,-1,769,948,767,-1,948,769,1177,-1,788,766,1176,-1,766,788,762,-1,790,1134,789,-1,790,1175,1134,-1,1141,802,111,-1,1141,867,802,-1,1057,155,157,-1,88,155,1057,-1,1109,156,1108,-1,1109,158,156,-1,1058,88,1057,-1,1058,1125,88,-1,142,200,143,-1,142,1174,200,-1,1173,289,1170,-1,1173,1172,289,-1,1090,1171,291,-1,1090,1168,1171,-1,1167,357,1164,-1,1167,1165,357,-1,983,1163,1130,-1,983,1162,1163,-1,983,1153,1162,-1,1327,1131,1160,-1,1131,1327,255,-1,1197,1160,1159,-1,1160,1197,1327,-1,1158,1197,1159,-1,1158,1196,1197,-1,1196,1157,1195,-1,1158,1157,1196,-1,1100,1157,1154,-1,1157,1100,1195,-1,1130,1100,1154,-1,1130,1101,1100,-1,1296,256,683,-1,1296,259,256,-1,1152,983,1302,-1,983,1152,1153,-1,1151,1302,1300,-1,1302,1151,1152,-1,1298,1151,1300,-1,1298,1150,1151,-1,1150,683,256,-1,1298,683,1150,-1,984,259,1296,-1,984,1149,259,-1,1149,1148,128,-1,984,1148,1149,-1,1147,127,126,-1,1147,249,127,-1,241,1147,1145,-1,1147,241,249,-1,241,1133,243,-1,1145,1133,241,-1,1146,1132,1133,-1,1146,1194,1132,-1,1132,749,24,-1,1194,749,1132,-1,75,1143,76,-1,75,1053,1143,-1,1053,125,1143,-1,1053,415,125,-1,122,409,120,-1,411,409,122,-1,120,408,95,-1,409,408,120,-1,118,1055,116,-1,97,1055,118,-1,118,115,114,-1,118,117,115,-1,341,1025,342,-1,341,343,1025,-1,268,59,951,-1,268,267,59,-1,45,50,48,-1,51,50,45,-1,81,210,124,-1,210,81,213,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getloscoxae_Coord_7_14_point_1()
		{
			double[] value = {.30369,30.83372,.84481,.30891,30.76361,.80128,.6367,30.76397,.59497,.44362,31.01032,.90038,.24063,31.1353,.98627,.21212,30.36113,-.00127,.24447,30.45493,.2146,.21322,30.63677,.20992,1.0658,30.19741,-.4151,1.08076,30.19905,-.38847,1.20947,30.05999,-.63711,4.6436,35.60154,-.25245,4.70821,35.43933,-.41541,4.70625,35.48832,-.61348,1.92993,34.14859,-3.59594,2.14713,33.87425,-3.36762,1.94386,33.40845,-3.39835,2.38077,30.78798,-1.03746,2.40493,31.00164,-.9298,2.25142,31.08059,-.72121,2.05364,31.68095,-2.55001,2.03656,31.68045,-2.54222,2.18929,31.82512,-2.41143,2.37118,31.32344,-.44421,2.37567,31.32545,-.44273,2.36829,31.3,-.36509,2.28816,31.10892,-.72539,2.26356,31.18189,-.54757,2.24599,31.15729,-.48126,2.43749,31.2806,-1.11917,2.2886,31.20563,-.77736,2.29351,31.15782,-.74743,2.3242,31.3426,-1.1202,2.43399,31.34639,-1.24121,2.3561,31.55872,-1.28522,2.2901,31.56925,-1.14832,2.46824,31.32815,-1.17599,2.46605,31.12529,-.95867,2.48456,31.1016,-.97441,2.11291,31.76984,-2.38291,1.99844,31.64202,-2.47402,1.98834,31.61533,-2.46245,2.3178,31.23505,-2.44698,2.02688,31.14201,-2.56962,2.10205,31.32148,-2.54606,2.23657,31.35607,.17467,2.0385,31.3082,.21755,2.11808,31.31164,.04985,2.09139,31.41354,.40962,2.73005,31.56847,.36498,2.30061,31.48749,.40201,2.4269,31.43607,.22784,3.76109,33.78245,-1.0235,3.83972,33.79082,-.86632,3.75781,33.41021,-.8281,3.90218,32.54655,-.85752,3.87268,32.47247,-1.04476,3.88742,32.49796,-1.05038,3.88226,32.59274,-.85432,2.76384,31.55075,.22838,2.92372,31.93323,.27851,2.91677,31.9339,.21844,3.45193,32.60273,.09794,3.36995,32.40964,.09083,3.50649,32.43138,-.05085,3.38704,32.38189,.04941,1.65033,33.22488,-3.06665,1.6722,33.29182,-3.12577,1.6503,33.3272,-3.37019,1.43815,34.42975,-4.0129,1.5453,34.55302,-4.03285,1.75072,34.2915,-3.77602,2.04324,35.04755,-2.44867,2.05035,35.01794,-2.41669,2.06109,35.07258,-2.39438,2.07096,34.91475,-2.30265,2.07261,34.92012,-2.30034,2.20017,34.63144,-2.06376,2.14923,34.7032,-2.1228,2.17576,34.59762,-2.06471,2.15266,34.56564,-2.07443,2.14805,34.54288,-2.09177,2.12265,34.25923,-2.00015,2.02639,33.57089,-2.18365,1.98504,33.67494,-2.09145,1.86563,33.58988,-2.36147,1.95826,33.47328,-2.5218,2.11178,33.44409,-2.31337,1.68303,34.29115,-2.81214,1.66626,34.32223,-2.8266,1.52913,34.13003,-3.14312,1.63136,33.9999,-3.13702,1.98243,33.72703,-2.12505,1.79618,33.6732,-2.41285,1.8137,33.6206,-2.37162,1.98217,33.73187,-2.12821,1.7213,33.66339,-2.74821,1.77627,33.44988,-2.81492,1.75579,33.58973,-2.55877,1.04606,34.2428,-3.79307};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_2()
		{
			double[] value = {1.04565,34.2363,-3.84047,1.14887,34.12414,-3.84131,1.75678,35.07879,-3.9513,1.9346,34.81064,-3.78498,1.80107,34.52455,-3.77914,3.5246,36.38828,-2.33372,4.06846,36.34829,-1.84392,4.06726,36.27185,-1.84372,3.51649,36.50797,-2.40889,1.65459,29.25279,-1.77646,1.65205,29.24569,-1.7815,1.36326,29.22718,-1.37356,1.60024,28.96942,-1.30273,1.74553,28.97364,-1.58375,1.75633,33.5849,-2.55594,1.75707,33.58008,-2.55315,1.67289,33.29754,-3.12674,1.77822,33.44002,-2.81003,1.77738,33.44495,-2.81251,1.64706,33.3328,-3.37484,2.09224,33.98115,-2.05041,2.09146,33.98041,-2.04485,2.13687,34.29205,-2.0383,2.13592,34.29276,-2.03289,2.13992,34.5224,-2.12057,2.13856,34.52084,-2.12552,2.54329,32.08465,-.25775,2.53644,32.08606,-.26191,2.62669,32.36038,-.51419,2.62181,32.35993,-.51876,2.52041,31.32454,-1.29374,2.51659,31.33124,-1.29437,2.47548,31.32801,-1.17827,2.40858,36.68933,-2.7255,2.41011,36.67928,-2.71006,2.95256,36.79626,-2.52171,2.95758,36.8033,-2.53343,3.42815,36.80946,-2.21687,3.8651,36.6593,-1.64278,3.87708,36.66539,-1.65102,3.41952,36.80275,-2.19853,4.37678,35.72035,-.17474,4.24674,35.34059,.38809,4.26145,35.34007,.39294,4.35995,35.72177,-.17543,4.02894,34.9009,1.00144,3.95177,34.64006,1.1407,3.97015,34.64054,1.15212,4.01186,34.90601,.99814,3.94438,34.19077,1.06915,3.95188,34.14349,1.05171,3.95931,34.14461,1.06311,1.8329,34.68691,-2.67248,1.85863,34.66975,-2.651,1.90398,35.07983,-2.63993,1.65882,33.97587,-3.1246,1.55399,33.7854,-3.47948,1.65889,33.94517,-3.10126,1.55659,33.74534,-3.47446,2.4167,29.90475,-2.46313,2.47053,29.95156,-2.4677,2.4879,29.94439,-2.46868,2.48427,29.95937,-2.47229,2.47511,29.93316,-2.46958,2.47992,29.96032,-2.4715,1.97162,29.50914,-2.25179,1.82439,29.32208,-2.02178,1.97463,29.51936,-2.24432,1.82554,29.33445,-2.01399,.39712,30.30724,-.13314,.49553,30.0697,-.29103,.47069,30.03136,-.26496,1.8734,31.35997,-2.64093,1.86592,31.35901,-2.62423,1.21226,31.10951,.04384,1.46732,31.33672,-.04767,1.22049,31.08942,.06279,1.4836,31.31846,-.03598,1.00509,30.33467,-.28636,.99087,30.34052,-.30385,.97415,30.54962,-.19118,.98404,30.54254,-.17462,3.7016,31.86577,-1.65752,3.62222,31.65342,-1.68375,3.63633,31.64133,-1.73411,3.68004,31.86528,-1.62719,1.11516,35.21452,-3.52287,1.1032,35.11785,-3.59817,1.11657,35.09791,-3.5542,1.34645,35.49915,-3.2373,1.2124,35.39943,-3.43443,1.22392,35.37089,-3.40201,1.33433,35.54817,-3.26111,3.97945,34.61894,1.15471,3.9491,34.45555,1.1895,3.96276,34.43736,1.17925,4.11473,35.02156,.8503,4.03542,34.87395,1.01379,4.10275,35.04348,.83656,4.2749,35.33248,.39175};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_3()
		{
			double[] value = {4.19299,35.19146,.60811,4.20143,35.17419,.63558,4.35362,36.03281,-.67544,4.34307,36.04487,-.66722,4.40563,35.70626,-.18869,2.96609,36.79803,-2.54741,3.44543,36.80604,-2.23388,2.25681,36.51687,-2.73626,2.2703,36.50159,-2.68953,2.40079,36.68038,-2.71434,2.12339,34.69201,-2.16825,2.07789,34.93554,-2.26681,2.07337,34.92234,-2.29552,2.13872,34.68556,-2.12923,2.07329,33.95932,-2.01004,1.65132,33.3302,-3.37731,1.64575,33.3372,-3.37799,2.03539,35.0722,-2.46219,1.97097,35.27891,-2.4468,1.92679,35.31716,-2.48981,1.68384,33.31036,-3.39612,1.67506,33.29157,-3.36129,2.14617,34.7161,-3.50621,2.03754,35.09958,-3.65493,2.06091,35.14464,-3.64694,1.36499,34.42498,-4.05779,1.26251,34.14994,-3.94114,1.78136,35.58542,-3.72453,1.76143,35.61931,-3.77122,1.81927,35.80734,-3.60086,2.25028,36.37543,-3.13616,2.09934,36.24989,-3.31314,2.08669,36.29251,-3.31737,2.25904,36.33572,-3.1453,3.52381,36.58085,-2.41146,3.12971,36.6005,-2.77625,3.11651,36.66937,-2.77269,4.51359,35.1224,.29159,4.69792,35.37728,-.44327,1.4916,34.57172,-4.05265,2.33459,31.76305,-.32702,2.34571,31.74651,-.31964,2.29681,31.61412,-.47973,2.31078,31.62325,-.45522,2.29692,31.47472,-.54867,2.90714,32.43034,-1.09129,2.89952,32.37003,-1.22523,2.92513,32.35923,-1.21964,2.88817,32.43277,-1.09327,2.41169,31.87048,-.25883,2.38971,31.88877,-.27101,2.51191,32.08781,-.27732,2.47988,31.36551,-1.33832,2.51007,31.33453,-1.29692,2.54137,31.40186,-1.40367,2.57436,31.37006,-1.38461,2.87158,32.47455,-.95447,2.80678,32.48565,-.86193,2.86495,32.47524,-.95457,2.81355,32.48626,-.85857,2.60243,32.35546,-.5304,3.18839,32.24486,.08701,3.372,32.38068,.00164,2.42274,31.12075,-.91571,2.41416,31.33723,-.11188,2.33894,31.25471,-.33721,2.42892,31.3927,-.15298,2.7539,31.57489,.16916,2.57941,31.41699,.01838,2.58395,31.46847,-.0105,3.86775,32.56457,-.74551,3.87018,32.54293,-.85678,3.83055,32.55107,-.75376,3.54262,31.68503,-1.68117,1.16491,35.32164,-3.78344,1.16196,35.22022,-3.62651,1.16681,35.31178,-3.48968,1.95442,36.33621,-2.91525,2.01805,36.54031,-2.99632,1.8915,36.27058,-2.94268,1.90519,36.43397,-3.24526,1.95748,34.88867,-3.75983,1.72584,35.21581,-3.95243,1.75012,35.46727,-3.81412,1.20305,35.24978,-4.13191,1.67771,34.85401,-4.01066,1.15718,35.07138,-4.16654,1.72301,35.07646,-4.00452,1.13568,35.22975,-3.82897,1.74968,36.11839,-3.48886,1.69946,35.89381,-3.64066,1.62268,35.94154,-3.64893,1.8935,36.02821,-3.51999,2.19321,35.63371,-3.32391,2.10636,35.37272,-3.47633,1.91206,35.99507,-3.50708,2.41851,35.98575,-3.12,2.01347,36.14612,-3.41078,3.03514,36.81782,-2.69418,2.62328,36.54709,-2.96186};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_4()
		{
			double[] value = {2.4316,36.7108,-2.80276,.95352,34.49685,-3.78703,.98127,34.75395,-3.7285,1.00272,34.76759,-3.86645,2.12755,36.5278,-2.85178,1.92225,36.1392,-2.75971,.85463,31.2841,1.14474,.82551,31.40137,1.11499,.70052,31.34857,1.10249,.82824,31.23027,1.12553,.95864,31.1738,1.06285,.97377,31.25734,1.09034,.41896,30.34903,.44486,.25681,30.34912,.26616,.32877,30.23843,.17113,.34903,31.39516,1.08158,.18968,31.34039,.95295,.55907,31.15709,.95927,4.10623,34.39623,1.18591,4.13864,34.17838,1.03067,4.21341,34.29151,1.05775,3.97391,34.13782,1.05931,4.37257,35.08067,.60108,4.28261,34.93717,.81939,4.31956,34.86818,.69503,3.6101,32.80733,.36431,3.60019,32.55585,.03847,3.79156,32.79687,.24041,3.8918,33.20499,-.4309,3.87516,33.20005,-.52582,3.87859,33.38119,-.35443,3.97103,33.20896,-.12486,3.9778,33.31195,-.0265,4.01865,33.17481,.07931,3.95154,33.48362,-.04512,3.97035,33.52717,.18945,3.90826,33.58935,.43048,4.03128,33.29339,.38045,3.83838,32.82215,.06031,3.94494,32.96069,.16322,3.76166,33.25843,.60016,3.80599,33.3436,.55332,3.54029,33.30292,.58739,3.8025,33.66719,.56735,3.95423,34.04681,.77058,3.8596,33.88239,.61685,4.08731,34.07861,.65604,3.96415,33.82442,.50622,4.62005,35.67875,-.95738,4.69354,35.4308,-.6406,4.42098,35.35965,-1.01615,4.54331,35.27194,-.69645,1.54293,34.63929,-4.07385,1.10956,34.84149,-4.20857,2.31149,34.07401,-3.25281,2.38949,34.39104,-3.12011,1.05786,34.84461,-4.18365,1.09779,35.07793,-4.16302,2.36246,33.68986,-3.06204,2.0231,34.39736,-3.57576,1.71968,34.55375,-3.87459,1.54484,33.83908,-3.72215,1.83766,33.85903,-3.60351,2.42273,33.35808,-2.57919,2.30823,33.36423,-2.833,2.56912,33.57343,-2.70313,2.35742,33.3383,-2.52889,2.23391,33.30092,-2.75251,2.18198,33.31461,-3.08413,1.85316,33.24228,-3.2921,2.0979,33.25135,-3.0143,1.10106,34.52864,-4.04563,1.18012,34.55821,-4.04157,1.50953,33.85219,-3.72825,1.62571,33.51834,-3.5457,1.7503,33.61462,-3.5766,1.08619,34.5263,-4.03589,1.14282,34.29407,-3.96695,1.21106,34.92084,-3.14762,1.2808,35.0743,-3.1318,1.18592,35.01392,-3.23161,1.03463,34.71921,-3.49732,1.14518,34.78254,-3.26333,1.14599,34.88978,-3.28703,1.11408,34.92999,-3.47353,1.0288,34.59115,-3.51072,1.35442,34.95998,-3.02835,1.53833,35.23633,-2.94172,1.37792,35.2848,-3.1622,1.14453,35.1615,-3.46658,1.2011,35.27431,-3.48012,1.08695,34.45069,-3.43154,1.50199,34.62757,-2.9684,1.72894,34.38141,-2.79161,1.67042,33.34102,-3.16885,1.75349,33.48984,-2.89307,1.61161,33.5197,-3.30022,1.622,33.69587,-2.98956,1.52676,33.81913,-3.48851,1.67296,33.9579,-2.75416};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_5()
		{
			double[] value = {1.78144,33.87911,-2.5835,1.74032,34.08305,-2.69304,1.89814,34.20166,-2.62314,1.93852,34.13463,-2.45911,2.0372,34.47251,-2.27755,1.96214,34.56202,-2.45397,2.04318,34.02872,-2.23037,2.08275,34.19967,-2.15876,1.98398,33.7406,-2.1312,2.09077,33.98268,-2.05564,2.1131,34.3666,-2.12447,2.13497,34.29191,-2.0434,1.81239,35.33192,-2.671,1.70424,35.52617,-2.69305,1.87383,34.64897,-2.62273,2.13591,34.51953,-2.12983,2.12357,34.94844,-2.23455,2.03293,35.34096,-2.35235,1.85756,35.37962,-2.50576,1.83978,35.42798,-2.48181,1.72713,35.58029,-2.64516,3.33481,32.70231,.12145,3.2996,32.45637,.14535,3.22251,32.57334,.1949,3.89484,34.45307,1.12171,3.93552,34.45536,1.17524,4.26504,35.69303,-.22757,4.1676,35.32513,.26683,3.41508,36.77814,-2.16438,3.82902,36.59985,-1.62774,1.88405,35.73906,-2.46787,2.06364,36.07445,-2.55202,1.91483,36.11249,-2.71088,1.77506,35.68528,-2.53123,1.7333,35.85246,-2.7706,1.82739,35.45801,-2.46558,1.83387,35.54687,-2.43122,1.72596,35.60384,-2.60278,1.84478,35.44038,-2.3564,1.84739,35.35868,-2.42954,1.90221,35.32425,-2.4271,2.29421,35.21894,-2.28299,2.28884,34.91855,-2.16109,2.32182,35.65142,-2.39142,1.99231,35.45517,-2.33993,3.3603,34.56975,-1.53363,3.43866,34.58451,-1.45866,3.50716,34.66654,-1.4056,3.25507,35.28895,-1.98847,3.16216,35.22147,-2.02889,3.32355,34.94928,-1.81034,3.54546,35.32689,-1.73574,3.4238,35.34961,-1.8824,3.44048,35.02857,-1.72831,3.72111,35.09353,-1.3407,3.69077,35.20013,-1.45355,3.5568,34.9524,-1.51997,3.71977,34.87622,-1.18886,3.5702,34.80108,-1.39565,3.69586,34.77733,-1.15458,4.00683,35.42601,-.74938,3.99019,35.59928,-.92056,3.85585,35.26413,-1.14863,3.89723,34.09709,.77769,3.79275,33.96187,.58788,3.90059,34.34741,.73761,3.95451,34.10814,1.00352,3.87652,34.38905,.96177,3.95015,34.13124,1.02978,3.98311,34.92082,.44726,4.07135,35.16618,.51505,3.87993,34.3382,.61363,3.84877,34.30945,.47833,3.90884,34.59446,.46656,3.9558,34.8523,.09174,4.05638,35.22184,-.10473,4.15439,35.62201,-.37718,4.2117,35.98606,-.67877,3.65524,34.30295,-.40388,3.58523,33.93358,-.00253,3.70534,34.14974,.09124,3.60271,33.73743,.32935,3.74965,34.03369,.42816,3.47135,33.16483,.33674,3.49624,33.39975,.25067,3.44315,33.14045,.17614,3.45384,32.89856,.38471,3.48172,33.06813,.50752,3.4139,33.41022,.02907,2.92566,33.47871,-.7877,3.01533,33.48109,-.666,3.01819,33.67177,-.85446,2.70666,33.70365,-1.24607,2.59536,34.13381,-1.59999,2.55915,34.04545,-1.58508,2.84233,33.96342,-1.31679,2.62705,33.55406,-1.20487,2.74849,33.49108,-1.01993,2.61026,33.24519,-1.01301,2.73452,33.20303,-.7357};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_6()
		{
			double[] value = {2.51286,33.30173,-1.23936,2.23332,33.61422,-1.84607,2.23963,33.46279,-1.90174,2.38429,33.31513,-1.58494,2.39522,33.48778,-1.55283,2.53305,33.14489,-1.03246,2.44204,33.11819,-1.3034,2.40816,32.94663,-1.04132,2.42094,33.73788,-1.53695,2.47386,32.92716,-.73897,2.68039,32.99137,-.51306,2.95701,33.19371,-.45772,2.90562,32.96185,-.25969,3.13662,32.84132,-.00093,3.19897,33.25787,-.24358,3.3064,32.93465,.09349,3.36689,33.36836,-.0277,2.84166,32.61491,.21303,2.96479,32.41972,.34309,2.70084,32.73359,.05321,2.4979,32.72724,-.15357,2.25898,32.37568,.15161,2.47711,32.34816,.36637,2.57154,32.28404,.42452,2.40116,31.845,.53593,2.70631,32.10282,.50399,2.27648,31.99723,.40579,2.06858,32.17918,.20543,2.10933,31.86417,.40939,2.23889,31.72733,.4919,1.53678,31.61207,.61703,1.88588,31.56658,.52672,1.79485,31.69371,.49213,1.59709,31.45765,.63582,1.93913,32.08607,.25722,1.81636,32.12026,.08827,1.58451,31.92329,.26534,1.69836,31.80179,.40649,1.13088,31.69685,.59628,1.4599,31.72648,.54032,1.37651,31.80906,.41842,1.20757,31.65693,.70587,.73481,31.54558,1.07328,.9486,31.61145,.88816,.57725,31.58841,.98265,.84705,31.63067,.79383,1.2796,31.52006,.75809,.95339,31.51793,.97982,1.05059,31.31242,1.00811,.58171,31.48402,1.1097,.86208,31.08805,.79269,.69644,31.22074,1.0436,.76129,30.92097,.69765,.30289,30.57057,.61112,2.20938,28.99787,-1.61887,2.35707,29.19655,-1.53378,2.06124,29.06116,-1.33582,2.36688,29.34924,-1.49476,2.0527,29.32267,-1.34833,2.36453,29.51989,-1.46149,2.80686,30.29435,-1.589,2.71721,30.10148,-1.52108,2.81581,29.87334,-1.71341,2.87178,30.02219,-1.85195,2.69613,30.30163,-1.45965,2.82236,30.47221,-1.49585,2.73754,30.46527,-1.37312,2.5968,30.18627,-1.44717,2.6389,30.49369,-1.29719,2.61141,29.86469,-1.51073,1.85039,28.873,-1.44839,1.73468,28.92876,-1.37797,2.00029,28.87887,-1.54847,2.3814,29.08923,-1.73898,2.34951,29.05749,-1.93411,2.47734,29.16899,-1.81701,2.20931,28.99236,-1.81795,2.60078,29.33803,-1.67035,2.48117,29.26958,-1.6084,2.53135,29.48016,-1.53176,2.78862,29.64946,-1.92817,2.82355,29.85095,-2.12877,2.67333,29.55739,-2.09852,1.97761,28.94919,-1.6783,2.08686,28.93785,-1.62547,1.78735,29.0462,-1.75267,2.07415,29.0369,-1.89942,2.57091,29.29938,-2.13787,2.28326,29.24457,-2.19726,2.55719,29.53964,-2.30225,2.47175,29.18291,-2.06248,2.86078,30.44507,-1.65736,2.8825,30.22411,-2.06491,2.75183,30.63567,-2.24545,2.9389,30.47337,-1.98223,2.65476,29.83729,-2.37909,2.66676,30.34132,-2.44009,2.47926,30.66017,-2.3885,2.71134,31.14032,-2.15523,2.34189,30.56523,-2.35093};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_7()
		{
			double[] value = {2.48546,30.17595,-2.43887,2.26158,30.5456,-2.34148,2.28524,30.2885,-2.31348,1.95972,31.36044,-2.67635,2.19938,30.94046,-2.47299,2.20384,30.75117,-2.40255,2.0646,30.91736,-2.50938,2.31968,30.7761,-2.40395,2.00879,31.12295,-2.56616,2.54098,31.21362,-2.29241,2.1918,31.6179,-2.5217,1.98509,31.36936,-2.6698,2.47168,31.86531,-2.36773,2.65947,32.15417,-2.28193,2.38559,32.16578,-2.28447,2.96319,33.08664,-2.1145,2.60633,32.71487,-2.13592,2.64924,33.03567,-2.15382,2.85429,32.69837,-2.19715,3.69009,33.76491,-1.13388,3.43908,34.2953,-1.61952,3.63873,34.36488,-1.43228,3.55915,33.71151,-1.31946,3.77242,34.40303,-1.26883,3.85658,34.39887,-1.14044,3.94893,34.37261,-.97492,4.00792,34.34046,-.82865,3.91192,33.67605,-.21935,4.02527,34.05448,.00858,4.0303,34.00171,.09341,2.87936,30.54835,-1.58663,2.92597,30.782,-1.86499,2.93465,30.61581,-1.90851,2.83379,30.87667,-2.04502,3.00062,32.5662,-2.06053,2.94088,32.07655,-2.23673,3.70505,33.41169,-.99059,3.83802,33.39478,-.65374,3.87841,33.78322,-.66556,3.90969,33.75284,-.46845,3.94129,33.59622,.0256,3.31433,33.06307,-1.75165,3.48482,32.41218,-1.87519,3.23555,32.93152,-1.9039,3.54153,32.67008,-1.63515,3.22879,32.28145,-1.91569,3.30045,31.85009,-2.05937,3.07326,32.72607,-2.00676,3.5623,32.85107,-1.39067,3.40115,33.17903,-1.56686,3.06036,31.0082,-1.90022,2.90489,31.06288,-2.00875,2.85294,31.39088,-2.13052,3.67867,32.18208,-1.72832,3.61067,31.98362,-1.86565,3.74168,32.79907,-.93939,3.72875,32.69925,-1.1215,3.67156,33.03625,-1.05885,3.61919,32.9567,-1.23669,3.71688,33.07649,-.93674,3.74346,32.86937,-.76187,3.73235,32.64631,-.07376,3.8269,32.95294,-.44711,3.78956,32.74239,-.25913,3.78308,32.80501,-.36687,3.14629,31.24757,-2.01138,3.33658,31.18732,-1.8605,3.23614,30.98236,-1.74104,3.19501,30.81276,-1.52265,3.32404,30.97668,-1.6338,3.54125,31.39558,-1.74092,3.45678,31.22597,-1.67598,3.45106,31.19866,-1.73382,3.53591,31.43696,-1.69402,3.79837,32.24141,-1.42585,3.70198,32.3933,-1.51966,3.74271,32.05321,-1.57492,3.86954,32.62645,-.74222,3.81113,32.71722,-.37913,3.46719,32.42897,-.10021,3.11646,32.5188,-.29241,3.3747,32.58649,-.91678,3.34201,32.60192,-.85196,2.88038,32.47584,-.95474,3.28686,31.06972,-1.55278,3.41275,31.2598,-1.65547,3.09483,31.47001,-1.66972,3.04548,31.31508,-1.5689,2.89626,32.27997,-1.37216,2.84453,32.24696,-1.32929,2.8386,31.92602,-1.60014,2.68718,31.98327,-1.53318,2.61865,31.90486,-1.56411,2.79299,31.81755,-1.60888,2.51184,31.99191,-1.42888,2.46459,31.90678,-1.40097,2.51399,31.78674,-1.56953,2.65731,32.42733,-.95232,2.84394,32.47663,-.95713,2.79147,32.48607,-.86754};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_8()
		{
			double[] value = {2.46682,32.18315,-1.23803,2.49662,32.29086,-1.15332,2.35846,32.20388,-1.0706,2.41857,32.08828,-1.23676,2.54874,32.04668,-1.42529,2.60707,32.15118,-1.40585,2.64057,32.22212,-1.36171,2.29131,32.1732,-.89083,2.31708,32.23343,-.68855,2.27243,32.11356,-.74772,2.32821,32.22708,-.86739,2.60527,31.4568,-1.48532,2.43524,31.65288,-1.46583,2.38398,31.58311,-1.35635,2.34077,31.80536,-1.28826,2.23582,31.61908,-.95305,2.28742,31.7891,-1.19851,2.21661,31.81254,-1.04147,2.36362,32.17671,-.43636,2.84651,31.9877,.38331,2.58529,31.62844,.48302,2.72057,32.02071,.02464,2.59809,31.7189,-.02104,2.42099,31.86306,-.24926,2.54849,32.0849,-.2515,2.31365,31.993,-.46393,2.2993,31.87318,-.47637,2.30078,31.25301,-.59188,2.23884,31.48236,-.72117,2.26595,31.5538,-.58071,2.68992,31.0566,-1.2583,2.77712,31.07081,-1.35291,2.58255,31.35805,-1.37921,2.51738,31.10292,-1.04508,2.60929,31.05919,-1.15334,2.59636,31.0046,-.98464,2.89096,31.15671,-1.4736,3.20273,30.88151,-1.41463,3.10893,30.76,-1.17267,2.96749,30.8668,-1.69841,2.97246,30.66853,-1.38059,3.07646,30.67351,-1.2274,3.12778,30.70601,-1.18362,2.96466,30.72565,-1.04239,2.90479,30.69854,-1.10902,2.56335,30.89813,-.95749,2.44689,31.06329,-.94156,2.57822,30.96773,-.95376,2.28326,31.21933,-.56436,2.37721,31.32903,-.4361,2.41698,31.42195,-.26399,2.44286,31.57997,-.10973,1.3035,31.28178,.76927,1.34122,31.36614,.77671,1.1616,31.09152,.5634,.96581,31.16715,.95306,2.51764,30.74931,-1.09195,2.75844,30.76457,-.96965,2.68512,30.67999,-1.18429,1.50804,29.05604,-1.12615,1.656,28.95994,-1.27096,1.75015,29.05633,-1.17984,1.01608,29.36594,-.64188,1.27537,29.21524,-.8989,1.10177,29.38378,-.56967,1.33927,29.23072,-.88395,.7182,29.6281,-.30835,.70788,29.85677,-.04303,.51774,29.90317,-.11534,.88676,29.61057,-.25863,.23235,30.30808,-.03812,.3011,30.14955,-.07054,.42118,30.0888,.09325,.17572,30.99448,.71196,.15284,31.13412,.81233,.25677,30.83095,.83181,.25922,30.59584,.61806,.2415,30.63841,.52053,.19265,30.82974,.6313,.13359,30.91201,.41984,.13112,31.30626,.53752,.10962,31.23079,.64406,.07829,31.3036,.77842,.15743,31.50468,.79846,.50201,31.51245,.66499,.36589,31.55841,.95398,.69746,31.52888,.58782,1.23693,29.22292,-.944,.97548,29.38292,-.69398,1.10497,29.35284,-1.02605,.84076,29.55735,-.72941,2.13157,29.34912,-2.22992,2.046,29.26543,-2.15287,2.39662,29.64697,-2.40853,2.25718,29.77324,-2.47237,2.10396,30.43631,-2.07335,2.08898,30.59587,-2.11209,2.11453,30.10893,-2.06159,2.26795,29.99317,-2.34737,2.27391,29.8028,-2.44049};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_9()
		{
			double[] value = {2.25917,29.77826,-2.46777,2.00008,29.50423,-2.19394,1.67756,29.2481,-1.75949,1.85392,29.34219,-1.98987,2.42352,33.26089,-2.18301,2.57466,33.24394,-2.24806,2.53702,33.05049,-2.0416,1.73521,33.18813,-3.11835,1.93183,33.25246,-2.89571,1.75965,33.52953,-2.53027,2.23061,33.34955,-2.43173,2.31535,33.33597,-1.99605,2.35445,32.7326,-1.1273,2.43765,32.91392,-1.38333,2.48587,33.0472,-1.92782,2.45364,33.13678,-1.70449,2.53651,32.71355,-2.06079,2.53681,32.69291,-1.97385,2.42755,32.52145,-1.56263,2.33823,32.04247,-1.77494,2.37318,32.14012,-2.07047,1.93056,31.34543,-2.44226,2.34575,32.1548,-2.21697,2.22202,31.65563,-1.99176,2.28729,31.88193,-1.50173,2.23969,31.49324,-1.68515,2.10924,30.96048,-2.0268,1.97663,31.04061,-2.32184,2.06012,30.77131,-2.17354,2.17077,32.14662,-1.06516,2.29396,32.34705,-1.24002,2.21104,31.64975,-1.28926,2.1743,30.84207,-1.65395,2.14533,30.88484,-1.81405,2.20415,31.30042,-1.47369,2.11782,30.38913,-1.92875,.50917,31.05592,.24763,.61119,31.31539,.37825,.95248,30.91114,-.0186,1.90542,32.22866,-.27066,2.14662,32.52682,-.50059,2.07137,32.33083,-.59047,1.85835,31.91557,-.28831,1.63568,31.49402,-.07063,1.52967,31.67074,-.05042,1.72219,31.81125,-.199,2.09061,31.95844,-.86131,2.2212,32.56965,-.87368,2.03904,31.9815,-.63563,2.08245,31.71507,-.64294,2.08766,31.51232,-.84535,.98857,30.69778,-.07642,.93483,30.68295,-.03449,.94067,30.50812,-.10231,.86286,30.54906,-.19989,.90623,30.74298,-.09289,.98445,30.70347,-.09119,.84124,30.07294,-.53337,.83902,30.29771,-.32165,1.39521,29.99805,-.87246,1.42371,29.97465,-.7364,1.25847,30.07335,-.52978,1.81503,29.96449,-1.10439,1.98573,30.08365,-1.23785,1.82865,29.99147,-1.30157,1.92243,30.09231,-1.32951,1.95443,29.82446,-1.8145,1.71662,29.67712,-1.5753,1.91377,30.07637,-1.44127,2.04748,30.37611,-1.3225,2.08041,30.38306,-1.52009,2.05696,31.44335,-.32412,1.9026,31.53074,-.10484,1.61075,31.33515,.59071,1.5279,31.2922,.49608,2.38174,31.29861,-.06027,2.24353,31.23706,-.27033,2.29399,31.22805,-.28601,2.205,31.03553,-.72484,2.25038,30.80608,-1.00885,2.2287,29.7718,-1.35256,2.33842,29.88805,-1.40045,2.0556,30.03563,-1.22989,.81065,30.76573,.40845,.86281,30.59065,.13926,.94127,30.81227,.21169,.69264,30.50074,.27614,1.79897,31.3366,.26143,1.54208,31.26408,.18329,1.75683,31.40524,.10633,1.55771,31.26644,.32409,1.99643,31.34702,.12751,1.96642,31.39804,-.02142,2.1175,31.30817,-.27453,2.1233,31.18328,-.49415,2.10687,30.98936,-.74043,2.11707,30.78368,-1.02861,1.84389,29.8676,-1.12275,.85802,30.43469,.01406,.96679,30.34105,-.17745};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_10()
		{
			double[] value = {.90454,30.23215,-.14099,1.24824,31.07462,.28269,1.12288,30.9931,.26673,1.27918,35.55774,-3.61737,1.41448,35.6563,-3.4296,2.41443,36.69247,-2.75412,2.23334,36.65041,-2.90861,2.0288,36.55326,-2.9966,2.35511,36.68411,-2.74891,1.7257,35.98954,-3.0921,1.74334,35.87663,-2.8358,1.76923,36.07892,-3.05817,1.23478,35.19689,-3.28418,1.67037,29.93845,-.98006,1.6522,29.83429,-.98772,2.08396,30.3718,-1.2629,2.19252,30.33234,-1.27638,1.54251,29.48805,-.99746,1.68489,29.46654,-1.1081,2.40808,30.24556,-1.34918,1.83407,31.31148,.3283,2.10644,31.27464,-.56765,2.11837,31.34434,-1.06377,2.06994,31.02401,-.85922,1.00427,29.85038,-.77791,1.07834,30.17251,-.31864,.98288,30.84869,-.0118,2.12142,30.40883,-1.79389,2.10358,30.26698,-1.81564,1.3197,31.51461,.03841,1.83765,32.11754,-.15633,1.11269,31.24754,.03813,.6464,29.8144,-.50594,.37827,30.32929,-.12272,1.90201,31.10155,-2.50372,2.30677,32.75637,-.78925,2.0962,33.30101,-2.64769,1.79496,33.38626,-2.78537,.47719,29.93789,-.15878,.18636,30.7051,.08686,.42784,30.71234,.05273,.11832,31.0046,.33876,.16615,30.70783,.11365,.21793,30.38139,.26268,1.9165,29.03596,-1.27415,2.45943,30.54619,-1.2255,.78159,30.03493,-.07443,.57574,30.14371,.18196,.74248,29.87842,-.04072,.67537,30.26582,.12382,.98415,30.93176,.48978,2.55318,31.38467,.05366,.53857,30.11888,.17608,2.78507,30.80069,-.96699,2.79578,30.63424,-1.25428,3.19105,32.24882,.13369,3.08699,32.30517,.23432,2.25255,31.8011,-.60974,2.23899,31.74137,-.66029,2.23927,31.99649,-.81181,2.37405,31.85708,-1.36024,2.37389,32.05768,-1.20515,2.35314,32.029,-1.14965,2.38901,32.30274,-.89675,2.46696,32.3457,-.70959,2.68948,32.28779,-1.28592,2.70195,32.35201,-1.20554,2.49683,32.3192,-1.08725,2.49176,32.33275,-1.03639,2.43745,32.32955,-.95011,2.58666,32.42103,-.82937,2.74873,32.46402,-.699,2.69862,31.61234,-1.57799,2.75424,31.70146,-1.59955,2.85828,32.05721,-1.55312,2.73592,32.08644,-1.48949,2.86611,32.1598,-1.47221,2.77088,32.15657,-1.43192,2.79149,31.67917,-1.59367,2.76199,31.57071,-1.5599,3.31177,32.12382,-1.58532,2.89557,32.04745,-1.55286,3.26931,31.94839,-1.67054,2.90083,32.1508,-1.4763,2.7717,32.46905,-.68073,3.20104,32.58338,-.42007,2.90495,32.3688,-.12217,3.70574,32.5092,-.23589,3.80181,32.57764,-.44062,3.71515,32.58401,-1.28079,3.86053,32.42422,-1.18378,3.23825,30.84342,-1.45594,3.33162,31.01785,-1.58032,3.81353,32.95097,-.50824,3.76242,33.11698,-.81463,3.81799,33.16784,-.70516,3.5294,31.71219,-1.92315,3.59496,33.32969,-1.26192,3.49606,33.26793,-1.40845,2.8451,31.71906,-2.24735};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_11()
		{
			double[] value = {2.53162,31.7824,-2.2331,2.74852,31.43584,-2.19213,2.50225,31.45809,-2.19811,3.34598,33.5724,-1.57335,3.09581,34.02759,-1.94568,3.16859,34.10365,-1.86721,2.42162,31.55776,-2.40293,1.90863,31.09113,-2.51461,1.91587,29.14475,-1.946,2.586,29.29051,-1.93628,2.69198,29.46009,-1.76758,2.64298,29.56361,-1.56083,2.74448,29.73575,-1.62818,1.91621,32.17816,.00271,1.73809,32.01664,-.07358,2.12166,31.65282,.49752,2.41131,34.34012,-1.82182,2.31191,34.08329,-1.77846,2.25907,33.86123,-1.78727,2.33144,34.6891,-2.04582,2.96135,33.91402,-1.18793,2.91678,34.06856,-1.37237,3.42267,33.71671,-.22291,3.11418,33.87486,-.94601,3.52012,33.58497,.19673,3.68001,33.6764,.58826,3.8164,34.40546,.15939,3.90456,34.58873,.71573,3.99159,35.02274,.74396,3.90065,34.63927,1.10512,3.92112,34.83111,.97064,3.88561,34.61683,.93511,2.66384,34.51244,-1.88127,2.98639,34.67301,-1.87983,2.60271,34.65766,-1.99941,3.04314,34.18651,-1.40763,3.12953,34.16941,-1.33139,3.25743,34.37243,-1.45906,3.37761,34.37338,-1.32543,3.44045,34.3932,-1.27202,3.53616,34.47166,-1.19231,3.58481,34.55516,-1.17182,3.66601,34.69185,-1.13621,3.07436,35.09166,-2.03706,2.81582,34.32769,-1.66749,1.92693,35.34594,-2.35799,1.92592,35.43102,-2.34768,1.64995,35.73663,-2.80485,1.63027,35.6581,-2.89666,2.96848,36.7383,-2.49581,4.07718,36.29647,-1.11916,4.14144,36.339,-1.1248,4.0865,35.04673,.82958,2.1192,34.68864,-2.17732,1.59706,35.07773,-2.87347,1.673,33.30331,-3.12758,1.39692,34.09381,-3.37263,1.68686,34.25192,-2.79879,1.77156,34.33222,-2.74949,1.34434,34.46845,-3.1252,1.25689,34.41872,-3.26909,1.17026,35.09812,-3.37893,1.19775,34.70766,-3.22754,1.32848,34.8352,-3.07745,1.26089,34.7858,-3.12552,1.0625,34.97482,-3.66484,2.78648,33.39097,-2.3384,2.64812,33.78999,-2.72363,1.2084,34.48886,-4.04876,1.57093,34.61219,-4.02204,1.70631,34.82803,-3.95994,2.76322,36.18053,-2.88014,2.65223,36.48555,-2.97335,3.1598,36.30789,-2.61032,4.11962,34.18594,.55056,4.03878,33.88491,.26416,4.1563,34.14755,.96424,4.22605,34.26512,.99334,4.00241,33.17656,.21248,3.99206,33.33845,.2045,3.95537,33.17471,.43603,3.91357,32.95598,.3728,3.89012,32.97929,-.09047,4.23345,34.81319,.98559,.83,31.17767,1.10242,3.48534,36.8127,-2.37096,2.48625,36.43815,-3.02989,1.54009,35.79607,-3.82932,1.72156,35.50054,-3.85856,1.4224,35.64489,-3.93867,1.47248,35.81596,-3.81685,1.33822,35.67742,-3.95537,1.27654,35.4666,-4.11368,1.21904,35.47058,-4.11148,1.63027,35.72809,-2.90109,1.58494,35.81618,-3.22917,1.04525,34.8467,-4.17255,3.45797,31.47534,-1.67583,2.78876,30.84327,-.97848,2.76092,32.46715,-.68838};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_12()
		{
			double[] value = {2.86326,31.91309,-1.59318,2.88107,32.05127,-1.55122,2.91457,32.27001,-1.36931,2.88603,32.1525,-1.47555,2.36219,31.31942,-.44717,4.63134,35.74026,-.92949,4.38792,36.03899,-1.39147,4.39897,36.10331,-1.3686,1.53086,33.82938,-3.68718,1.53929,33.78555,-3.66212,1.5886,33.52907,-3.51541,4.17143,36.33107,-1.15063,4.15586,36.3407,-1.13262,.98167,34.52149,-3.73068,.97804,30.8845,-.01897,.16498,31.51076,.80817,.17356,31.52223,.80761,.17566,31.52007,.79521,1.65373,29.1133,-1.12299,1.65097,29.14085,-1.12342,1.62536,29.15716,-1.10101,1.60913,29.11119,-1.11563,1.66243,28.93451,-1.31721,1.46392,29.05677,-1.16776,.63522,29.76788,-.48123,1.7525,34.35653,-2.77323,4.32902,36.04636,-.66419,2.39876,36.68761,-2.72049,2.02835,36.54384,-3.00439,1.91829,36.43211,-3.25903,2.88842,32.04935,-1.5506,2.57902,31.36491,-1.38086,2.31046,31.4687,-.53766,2.31607,31.62586,-.44627,1.10636,29.39935,-1.05101,4.34702,35.8876,-1.36102,3.64982,33.3705,-1.12626,3.22512,33.5621,-.4617,2.2533,31.40341,-.88755,4.50196,35.06169,.25517,4.59579,35.19542,-.421,1.45504,29.66053,-1.32632,1.21653,29.75179,-1.01927,2.12182,34.69026,-2.17307,2.35326,31.73646,-.31084,2.3506,31.74162,-.31604,2.31881,31.62106,-.44088,2.41724,31.86652,-.25512,2.63238,32.36195,-.50922,2.76585,32.46762,-.68427,2.91436,32.4293,-1.08923,2.93217,32.35681,-1.21812,2.92166,32.26728,-1.36831,2.89339,32.15075,-1.47481,2.87041,31.91068,-1.59161,2.87763,31.90898,-1.5937,2.82767,31.79852,-1.60441,2.82077,31.80114,-1.60242,2.78454,31.68159,-1.59162,2.75527,31.57412,-1.55841,2.66314,31.4144,-1.46532,2.66871,31.40896,-1.46579,2.88872,32.05543,-1.54606,2.88862,32.0534,-1.54758,1.0867,35.0769,-4.15259,1.15365,35.25428,-4.12409,1.20802,35.47021,-4.10178,1.14342,35.25432,-4.11243,1.45968,35.81674,-3.80547,1.32659,35.67781,-3.94759,1.73632,36.11819,-3.47532,1.60802,35.94211,-3.63647,1.83987,36.27978,-3.38504,1.82788,36.27966,-3.37235,4.17791,35.19261,.60089,.84762,29.60307,-.75511,.67883,29.64858,-.35803,.91855,29.63426,-.25634,1.12943,29.41202,-.5615,1.36694,29.26674,-.8753,.14526,31.31353,.52356,.14483,31.00983,.31304,1.08682,34.95167,-3.61825,1.00259,34.74092,-3.67964,3.88442,36.66461,-1.67281,3.96258,34.10113,1.0031,1.69249,35.22032,-4.01017,1.99447,36.1799,-3.42126,2.45657,36.50025,-3.01459,4.30516,34.66065,.86427,4.31766,34.81432,.64524,4.30788,34.62257,.80248,4.26413,34.39884,.90954,4.25954,34.43795,.96765,2.31338,31.46935,-.5291,2.8138,31.8038,-1.60403,2.77727,31.68343,-1.593,2.74809,31.57653,-1.55967,3.76445,32.55929,-.46752,3.66564,32.49946,-.27815};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_13()
		{
			double[] value = {3.84704,32.40805,-1.16431,3.77979,32.22477,-1.40611,3.71726,32.03779,-1.55048,2.95037,30.77645,-1.04151,1.05799,35.01837,-3.88325,4.47414,35.22594,.39356,4.14402,34.57516,1.1486,4.3563,36.26908,-1.28143,4.56912,35.94653,-.77467,3.6912,32.97765,.49796,4.01299,36.63806,-1.76314,4.14071,34.30193,.3994,4.13375,34.42606,.25413,4.04033,34.18998,-.2901,4.19171,34.58865,-.06,4.26035,34.73412,-.50338,4.23679,34.81526,-.79432,4.03994,34.27796,-.58408,3.57843,36.03848,-2.15364,4.0134,36.01018,-1.77556,3.22662,35.92443,-2.43301,2.8504,35.81576,-2.68184,2.55866,35.6225,-2.88297,2.34139,35.37495,-3.09448,3.94251,35.49049,-1.6673,4.21972,35.44369,-1.34898,3.59328,35.47338,-1.96657,3.31016,35.38572,-2.23819,3.01753,35.24925,-2.44787,2.79116,35.09884,-2.62554,2.61622,34.93026,-2.78409,2.21606,35.1459,-3.27818,2.49276,34.72021,-2.93564,2.87235,34.48397,-2.41545,2.78741,34.30973,-2.51442,3.14763,34.73638,-2.15639,3.0041,34.6332,-2.27877,3.62827,34.92965,-1.72927,3.37219,34.85715,-1.98829,4.01986,34.92282,-1.25327,3.86341,34.93607,-1.47274,4.14135,34.8768,-1.03227,3.2538,34.19101,-1.77702,3.04091,33.92151,-2.04718,2.70108,34.06582,-2.64877,2.98097,33.75218,-2.15915,2.89238,33.56166,-2.27882,1.57601,34.8552,-2.8854,2.48729,36.48658,-2.59456,3.30341,33.94614,-.79131,3.28198,34.16324,-1.18832,3.39968,34.20934,-1.06357,2.73603,35.93799,-2.37426,3.38739,36.16145,-2.0573,3.05862,36.12547,-2.29408,3.69192,36.07554,-1.68455,3.90522,35.80884,-1.25303,3.42418,34.81148,-1.62914,3.25903,34.63943,-1.68675,3.23025,34.84339,-1.83627,2.98583,34.90333,-2.00605,3.08,34.50025,-1.69463,3.23884,34.71662,-1.75895,3.23422,34.78968,-1.80974,2.96797,34.79058,-1.96674,2.60211,35.07145,-2.2026,2.73513,35.31934,-2.24199,2.97406,35.5268,-2.21776,3.18064,35.61395,-2.14057,3.627,35.60555,-1.72989,3.4262,35.64498,-1.98195,3.79111,35.44563,-1.38275,3.80736,34.76545,-.82278,3.86326,34.97341,-.92883,3.72357,34.60351,-.79421,3.64383,34.43128,-.82999,3.51886,34.27945,-.93496,2.58485,34.86267,-2.12186,3.88657,34.80177,-.36455,3.96745,35.09607,-.50569,3.77284,34.52035,-.3711,3.4664,34.05658,-.58433,2.28529,32.61568,-.38188,2.04118,32.32269,-.11946,1.52226,31.84104,.09434,1.07859,31.60241,.37446,1.72723,29.20777,-1.17728,2.49023,29.66123,-1.5011,2.18417,29.12727,-2.05922,3.19499,33.35891,-1.83366,3.09547,33.22907,-1.9824,3.27734,33.47163,-1.68222,3.4376,33.66561,-1.44962,3.21389,31.53501,-2.05607,3.42626,31.40981,-1.91379,3.28132,32.6263,-.63694,2.82002,32.48823,-.85531,3.3769,32.51526,-1.10437,2.92154,32.43113,-1.08851,3.38131,32.4078,-1.28519};
			return value;
		}
		private double[] getloscoxae_Coord_7_14_point_14()
		{
			double[] value = {2.93955,32.3579,-1.21872,3.34761,32.27227,-1.46359,2.9291,32.26752,-1.36988,3.22043,31.78531,-1.7049,3.15363,31.62421,-1.69798,2.69522,32.40291,-1.09367,2.28761,32.06496,-.97358,2.31179,32.01294,-1.06364,2.21562,31.90583,-.92265,2.28658,32.12118,-.92086,2.2238,31.67187,-.8191,1.91847,31.38039,.45755,1.96407,29.58204,-1.25058,1.33028,29.53938,-.7982,1.139,29.66776,-.56129,.93256,29.84784,-.2863,1.31064,31.70028,.2317,2.14789,31.04008,-1.27254,2.1457,30.7137,-1.43084,1.64025,29.96064,-1.1327,2.10962,30.6364,-1.22218,2.10627,30.8035,-1.07995,2.1291,30.61526,-1.15969,2.24828,30.62418,-1.1663,1.3909,29.84672,-.73551,1.20439,29.91321,-.52841,1.04204,30.06006,-.31248,2.65672,31.41845,-1.46712};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getroscoxae_Geo_6_19_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,2,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,26,27,28,-1,28,17,26,-1,29,30,31,-1,31,32,29,-1,31,33,34,-1,31,35,33,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,45,46,47,-1,46,48,47,-1,49,50,51,-1,52,53,54,-1,55,56,57,-1,57,58,55,-1,51,59,60,-1,59,61,60,-1,62,63,64,-1,65,66,67,-1,68,69,70,-1,69,71,72,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,79,82,83,-1,84,85,86,-1,86,87,84,-1,88,89,90,-1,89,91,90,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,101,102,103,-1,103,104,101,-1,105,106,107,-1,108,109,110,-1,108,111,109,-1,108,105,111,-1,112,113,89,-1,114,115,63,-1,63,116,114,-1,62,117,116,-1,116,63,62,-1,118,91,119,-1,118,90,91,-1,120,121,122,-1,122,123,120,-1,124,125,126,-1,124,127,125,-1,128,129,130,-1,131,132,133,-1,131,134,132,-1,135,136,137,-1,137,138,135,-1,139,140,141,-1,139,142,140,-1,143,144,145,-1,143,146,144,-1,147,148,149,-1,150,151,152,-1,152,70,150,-1,153,154,155,-1,155,156,153,-1,157,158,159,-1,157,160,158,-1,159,161,157,-1,160,162,158,-1,163,164,165,-1,164,166,165,-1,167,168,169,-1,40,170,171,-1,40,39,170,-1,172,173,174,-1,173,175,174,-1,176,177,178,-1,176,179,177,-1,180,7,181,-1,181,182,180,-1,183,184,185,-1,183,186,184,-1,187,188,189,-1,190,191,192,-1,190,193,191,-1,194,145,195,-1,195,196,194,-1,197,139,198,-1,197,199,139,-1,200,201,202,-1,200,141,201,-1,203,131,204,-1,203,138,131,-1,205,206,207,-1,208,209,210,-1,208,211,209,-1,118,212,80,-1,80,90,118,-1,213,117,214,-1,215,68,216,-1,216,217,215,-1,120,77,76,-1,120,123,77,-1,62,218,219,-1,220,221,222,-1,223,67,224,-1,225,226,227,-1,228,229,230,-1,228,231,229,-1,232,233,234,-1,233,103,234,-1,12,235,236,-1,237,67,66,-1,237,224,67,-1,238,239,240,-1,241,242,243,-1,241,244,242,-1,245,246,247,-1,247,125,245,-1,248,249,250,-1,248,251,249,-1,32,38,37,-1,252,253,254,-1,254,255,252,-1,256,125,127,-1,256,245,125,-1,32,34,38,-1,257,258,259,-1,29,260,28,-1,23,261,262,-1,23,263,261,-1,264,265,266,-1,186,267,184,-1,193,268,269,-1,269,270,193,-1,269,271,270,-1,272,273,274,-1,272,275,273,-1,276,221,277,-1,277,278,276,-1,271,269,279,-1,280,281,231,-1,282,232,283,-1,282,284,232,-1,285,286,287,-1,206,288,289,-1,288,274,289,-1,290,291,292,-1,292,293,290,-1,294,182,295,-1,3,296,297,-1,298,4,297,-1,236,299,300,-1,301,302,303,-1,303,304,301,-1,305,306,307,-1,308,309,310,-1,311,305,309,-1,312,313,314,-1,304,315,316,-1,317,318,319,-1,313,312,320,-1,312,318,320,-1,321,322,323,-1,321,324,322,-1,325,237,326,-1,327,222,328,-1,329,276,99,-1,329,222,276,-1,15,330,328,-1,16,15,329,-1,65,98,331,-1,65,67,332,-1,16,333,14,-1,330,334,335,-1,335,336,330,-1,337,338,336,-1,336,335,337,-1,339,335,334,-1,334,340,339,-1,341,342,14,-1,341,343,342,-1,344,325,345,-1,344,346,325,-1,223,347,332,-1,332,67,223,-1,348,332,349,-1,96,350,351,-1,351,287,96,-1,269,268,189,-1,352,353,354,-1,355,356,357,-1,357,358,355,-1,355,359,356,-1,360,187,189,-1,361,193,190,-1,361,268,193,-1,362,363,358,-1,364,95,97,-1,365,85,366,-1,367,368,369,-1,367,370,368,-1,347,95,371,-1,368,94,93,-1,372,373,374,-1,372,94,373,-1,375,376,377,-1,377,378,375,-1,375,379,380,-1,89,92,372,-1,381,382,380,-1,383,379,384,-1,385,386,387,-1,377,69,72,-1,377,388,69,-1,384,378,389,-1,209,78,77,-1,209,74,78,-1,390,391,211,-1,211,68,390,-1,68,215,390,-1,386,392,393,-1,302,301,394,-1,302,395,396,-1,395,397,396,-1,398,149,399,-1,140,142,400,-1,142,401,400,-1,137,136,402,-1,136,403,402,-1,404,405,406,-1,406,407,404,-1,407,408,404,-1,409,410,411,-1,412,391,390,-1,390,413,412,-1,414,415,410,-1,410,406,414,-1,416,417,418,-1,419,420,421,-1,422,423,424,-1,425,426,427,-1,428,429,430,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_2()
		{
			int[] value = {431,432,433,-1,323,434,435,-1,323,322,434,-1,436,435,437,-1,437,438,436,-1,438,439,436,-1,440,441,401,-1,435,442,437,-1,443,442,444,-1,401,445,446,-1,401,441,445,-1,447,400,448,-1,449,450,451,-1,452,434,453,-1,454,455,456,-1,457,458,456,-1,459,455,454,-1,460,461,462,-1,463,464,465,-1,463,466,467,-1,468,463,467,-1,468,464,463,-1,469,470,471,-1,471,472,469,-1,473,474,475,-1,474,468,475,-1,468,472,476,-1,466,477,478,-1,479,480,481,-1,480,482,481,-1,483,479,481,-1,481,484,483,-1,396,483,454,-1,454,458,396,-1,479,396,397,-1,479,485,486,-1,487,488,489,-1,490,489,486,-1,486,491,490,-1,491,492,493,-1,493,494,491,-1,487,490,495,-1,490,494,495,-1,496,494,493,-1,496,497,494,-1,498,499,500,-1,498,501,499,-1,502,503,504,-1,502,505,503,-1,506,507,508,-1,506,509,507,-1,507,510,511,-1,507,512,510,-1,513,510,291,-1,510,514,291,-1,298,297,515,-1,298,516,517,-1,4,518,0,-1,0,295,519,-1,520,521,522,-1,520,523,524,-1,520,525,523,-1,526,527,528,-1,526,529,527,-1,530,527,531,-1,527,529,531,-1,529,532,533,-1,108,110,534,-1,520,522,535,-1,536,537,538,-1,538,539,536,-1,540,541,538,-1,541,539,538,-1,540,524,542,-1,540,521,524,-1,543,528,544,-1,543,526,528,-1,545,543,544,-1,535,546,547,-1,548,108,547,-1,549,550,551,-1,550,552,551,-1,527,553,554,-1,527,530,553,-1,528,527,554,-1,554,555,528,-1,555,556,557,-1,544,558,559,-1,557,560,561,-1,562,561,563,-1,562,558,561,-1,564,563,565,-1,564,562,563,-1,21,40,171,-1,171,566,21,-1,567,568,569,-1,568,570,569,-1,569,43,571,-1,560,572,570,-1,570,561,560,-1,565,563,568,-1,573,574,22,-1,574,575,20,-1,576,575,577,-1,578,579,580,-1,579,581,580,-1,582,583,584,-1,582,585,583,-1,586,587,54,-1,588,589,53,-1,590,591,592,-1,593,554,553,-1,556,554,594,-1,560,557,595,-1,581,596,597,-1,581,577,596,-1,598,599,600,-1,598,580,599,-1,601,54,584,-1,601,52,54,-1,602,603,604,-1,311,314,605,-1,597,596,606,-1,596,607,606,-1,599,606,608,-1,608,600,599,-1,609,610,611,-1,609,612,610,-1,595,593,613,-1,613,614,615,-1,616,617,614,-1,616,618,617,-1,608,619,620,-1,608,606,619,-1,621,622,623,-1,621,624,622,-1,625,626,623,-1,626,621,623,-1,627,304,316,-1,627,301,304,-1,628,629,630,-1,631,632,633,-1,634,635,636,-1,634,637,635,-1,620,638,639,-1,639,640,620,-1,58,641,625,-1,625,623,58,-1,58,57,642,-1,642,641,58,-1,629,628,643,-1,644,258,645,-1,646,647,648,-1,649,650,651,-1,649,652,650,-1,653,244,654,-1,655,656,657,-1,657,658,655,-1,655,659,660,-1,655,661,659,-1,662,663,664,-1,662,656,663,-1,665,666,667,-1,668,669,670,-1,663,660,671,-1,672,664,670,-1,673,674,675,-1,673,676,674,-1,677,678,248,-1,250,677,248,-1,250,679,677,-1,680,679,33,-1,681,35,682,-1,681,683,35,-1,256,684,245,-1,685,686,51,-1,686,59,51,-1,687,688,689,-1,687,690,688,-1,691,692,693,-1,693,246,691,-1,694,695,696,-1,260,32,37,-1,697,698,699,-1,128,700,701,-1,128,130,700,-1,702,36,701,-1,703,698,704,-1,703,705,698,-1,553,706,707,-1,707,593,553,-1,706,530,708,-1,708,709,706,-1,18,710,711,-1,711,712,18,-1,30,713,696,-1,30,29,713,-1,18,17,260,-1,714,715,262,-1,715,23,262,-1,266,716,264,-1,266,690,716,-1,514,717,718,-1,517,719,720,-1,712,721,722,-1,721,723,722,-1,724,725,726,-1,727,728,729,-1,728,730,729,-1,731,732,733,-1,731,734,732,-1,735,180,294,-1,294,736,735,-1,737,738,739,-1,737,3,738,-1,740,738,741,-1,741,742,740,-1,743,740,742,-1,5,742,6,-1,180,182,294,-1,743,744,745,-1,743,5,744,-1,746,747,748,-1,746,749,747,-1,513,515,750,-1,750,751,752,-1,753,754,752,-1,755,167,756,-1,167,757,756,-1,758,759,760,-1,759,761,760,-1,165,762,763,-1,161,764,765,-1,565,766,767,-1,768,564,769,-1,564,767,769,-1,770,771,772,-1,772,163,770,-1,107,164,773,-1,164,774,773,-1,579,775,776,-1,776,576,579,-1,337,777,578,-1,777,778,578,-1,341,779,343,-1,779,780,343,-1,779,218,64,-1,218,62,64,-1,88,781,112,-1,88,79,781,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_3()
		{
			int[] value = {782,783,82,-1,474,473,784,-1,473,785,784,-1,470,469,786,-1,786,782,470,-1,782,786,787,-1,775,778,787,-1,788,786,784,-1,784,789,788,-1,788,789,790,-1,791,788,790,-1,792,170,39,-1,793,41,776,-1,793,791,790,-1,794,790,795,-1,793,794,796,-1,797,798,796,-1,799,800,801,-1,801,795,799,-1,794,802,803,-1,803,804,794,-1,805,769,767,-1,806,807,808,-1,809,753,810,-1,753,807,810,-1,811,812,813,-1,811,814,812,-1,815,816,817,-1,818,819,800,-1,820,819,811,-1,820,813,821,-1,819,821,822,-1,823,824,176,-1,176,825,823,-1,179,826,827,-1,826,828,827,-1,829,8,830,-1,829,831,8,-1,832,833,834,-1,832,835,833,-1,832,836,837,-1,837,838,832,-1,839,835,838,-1,838,840,839,-1,841,842,843,-1,841,844,842,-1,845,821,813,-1,846,813,815,-1,847,718,848,-1,847,720,718,-1,45,47,849,-1,850,26,851,-1,28,260,17,-1,852,17,19,-1,19,853,852,-1,854,855,856,-1,857,858,859,-1,859,860,857,-1,861,862,45,-1,842,863,851,-1,851,26,842,-1,864,843,853,-1,843,852,853,-1,834,833,865,-1,833,854,865,-1,172,866,867,-1,817,173,860,-1,173,857,860,-1,191,193,270,-1,270,868,191,-1,272,869,870,-1,272,288,869,-1,274,288,272,-1,871,283,204,-1,871,282,283,-1,872,873,289,-1,873,871,207,-1,873,282,871,-1,207,289,873,-1,870,869,874,-1,190,875,876,-1,190,192,875,-1,276,278,100,-1,173,172,857,-1,172,867,857,-1,823,877,878,-1,823,825,877,-1,879,834,880,-1,834,865,880,-1,833,881,854,-1,881,882,854,-1,843,842,852,-1,842,26,852,-1,857,867,858,-1,880,883,884,-1,854,882,885,-1,885,855,854,-1,852,26,17,-1,26,850,263,-1,263,27,26,-1,851,45,850,-1,45,849,850,-1,46,45,862,-1,859,858,886,-1,858,847,886,-1,850,849,263,-1,849,261,263,-1,817,846,815,-1,813,846,845,-1,861,846,817,-1,817,860,861,-1,821,845,844,-1,841,887,822,-1,888,881,889,-1,881,839,889,-1,835,832,838,-1,830,8,890,-1,8,891,890,-1,8,10,891,-1,10,892,891,-1,831,893,9,-1,9,8,831,-1,894,825,178,-1,825,176,178,-1,823,895,824,-1,896,897,840,-1,819,820,821,-1,813,820,811,-1,819,818,811,-1,819,801,800,-1,816,898,817,-1,898,175,817,-1,812,899,813,-1,810,174,175,-1,175,898,810,-1,806,810,807,-1,892,900,901,-1,900,168,901,-1,827,902,169,-1,774,772,837,-1,805,803,897,-1,805,804,803,-1,767,804,805,-1,796,766,797,-1,798,793,796,-1,794,804,796,-1,790,794,793,-1,791,793,776,-1,41,793,798,-1,903,792,798,-1,170,792,903,-1,789,795,790,-1,789,799,795,-1,469,474,786,-1,474,784,786,-1,473,904,785,-1,904,818,785,-1,783,782,777,-1,83,82,783,-1,783,905,83,-1,83,906,781,-1,780,64,906,-1,780,779,64,-1,779,341,218,-1,164,163,774,-1,163,772,774,-1,564,565,767,-1,568,798,797,-1,568,567,798,-1,159,771,770,-1,764,165,763,-1,763,765,764,-1,106,108,548,-1,759,755,761,-1,755,756,761,-1,167,735,757,-1,167,169,735,-1,180,902,907,-1,902,908,907,-1,752,807,753,-1,754,750,752,-1,749,745,747,-1,749,743,745,-1,5,7,744,-1,7,6,181,-1,742,5,743,-1,6,741,181,-1,6,742,741,-1,740,739,738,-1,749,737,739,-1,749,746,737,-1,746,296,3,-1,3,737,746,-1,728,909,730,-1,909,726,730,-1,724,910,110,-1,533,855,885,-1,911,19,722,-1,722,19,18,-1,18,712,722,-1,912,913,914,-1,913,915,914,-1,719,514,718,-1,718,720,719,-1,50,685,51,-1,916,51,60,-1,916,49,51,-1,716,714,262,-1,262,264,716,-1,32,260,29,-1,731,736,734,-1,736,917,734,-1,710,18,260,-1,918,919,721,-1,919,920,721,-1,706,709,921,-1,709,920,921,-1,709,708,922,-1,922,723,709,-1,706,553,530,-1,706,921,633,-1,633,707,706,-1,36,128,701,-1,31,34,32,-1,238,694,239,-1,690,923,716,-1,690,687,923,-1,246,245,684,-1,684,691,246,-1,686,924,59,-1,686,925,924,-1,926,692,691,-1,676,927,928,-1,661,929,678,-1,678,677,661,-1,930,659,661,-1,661,677,930,-1,930,931,659,-1,931,671,659,-1,680,683,932,-1,676,933,674,-1,676,926,933,-1,934,935,936,-1,934,937,935,-1,938,939,669,-1,939,672,669,-1,672,670,669,-1,660,659,671,-1,940,941,942,-1,668,933,936,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_4()
		{
			int[] value = {668,931,932,-1,665,667,943,-1,943,944,665,-1,666,945,667,-1,666,242,945,-1,244,653,938,-1,653,939,938,-1,655,660,663,-1,663,656,655,-1,661,946,929,-1,653,654,947,-1,947,948,653,-1,651,703,704,-1,704,649,651,-1,652,949,950,-1,652,649,949,-1,951,952,953,-1,952,954,953,-1,955,956,644,-1,258,957,259,-1,258,644,957,-1,627,958,959,-1,960,640,639,-1,960,961,640,-1,625,643,628,-1,625,641,643,-1,628,962,625,-1,629,627,316,-1,395,485,397,-1,395,925,485,-1,685,493,492,-1,492,686,685,-1,625,963,964,-1,624,961,622,-1,624,612,961,-1,606,965,619,-1,606,607,965,-1,616,966,967,-1,967,618,616,-1,614,613,616,-1,615,595,613,-1,593,707,613,-1,599,597,606,-1,621,968,969,-1,969,624,621,-1,964,52,601,-1,311,605,592,-1,592,305,311,-1,603,52,604,-1,603,53,52,-1,583,968,970,-1,583,971,968,-1,577,617,596,-1,577,972,617,-1,617,973,614,-1,974,572,560,-1,560,973,974,-1,595,615,560,-1,557,556,594,-1,554,593,594,-1,975,976,977,-1,575,972,577,-1,575,574,978,-1,978,572,974,-1,978,44,572,-1,574,573,42,-1,574,20,22,-1,44,570,572,-1,44,569,570,-1,42,573,43,-1,979,567,571,-1,576,20,575,-1,20,40,21,-1,20,41,40,-1,561,558,557,-1,558,544,555,-1,558,555,557,-1,556,555,554,-1,528,555,544,-1,545,549,551,-1,549,765,550,-1,765,763,550,-1,547,980,548,-1,980,981,548,-1,982,551,552,-1,982,545,551,-1,543,982,983,-1,543,545,982,-1,534,520,535,-1,522,546,535,-1,532,984,985,-1,532,529,984,-1,533,531,529,-1,530,531,708,-1,529,526,984,-1,524,521,520,-1,525,520,910,-1,534,110,910,-1,910,520,534,-1,519,1,0,-1,516,719,517,-1,515,291,290,-1,515,513,291,-1,512,509,500,-1,512,507,509,-1,510,513,511,-1,505,986,503,-1,986,495,503,-1,987,986,505,-1,987,899,986,-1,497,496,988,-1,495,497,503,-1,495,494,497,-1,490,491,494,-1,492,491,485,-1,491,486,485,-1,490,487,489,-1,489,479,486,-1,485,479,397,-1,479,483,396,-1,480,479,489,-1,475,466,478,-1,475,467,466,-1,475,468,467,-1,904,473,478,-1,473,475,478,-1,474,469,468,-1,469,472,468,-1,470,80,471,-1,470,81,80,-1,464,468,476,-1,466,463,462,-1,989,990,991,-1,476,992,993,-1,991,75,994,-1,995,996,997,-1,998,459,484,-1,460,996,999,-1,1000,453,455,-1,458,454,456,-1,434,1001,453,-1,401,446,448,-1,448,400,401,-1,443,444,1002,-1,442,435,444,-1,443,1003,437,-1,437,442,443,-1,441,440,1004,-1,1005,1006,1007,-1,322,320,434,-1,320,1001,434,-1,1008,1009,1010,-1,1011,1012,1013,-1,418,1014,1015,-1,417,1016,1017,-1,429,428,1018,-1,420,419,1019,-1,1020,1021,1022,-1,1020,1023,1021,-1,414,406,405,-1,414,390,415,-1,414,413,390,-1,995,1024,1013,-1,1025,390,1026,-1,390,215,1026,-1,1027,393,1028,-1,411,1029,1025,-1,1025,1028,411,-1,1025,1026,1028,-1,407,406,410,-1,407,1030,1031,-1,1031,408,407,-1,386,385,1032,-1,405,205,1033,-1,405,404,205,-1,207,206,289,-1,134,137,402,-1,402,1034,134,-1,136,1035,403,-1,1035,1036,403,-1,142,1037,401,-1,1037,440,401,-1,398,399,1007,-1,1007,146,398,-1,395,302,1038,-1,387,1027,217,-1,391,74,211,-1,74,209,211,-1,383,384,389,-1,378,1039,389,-1,152,216,70,-1,382,89,380,-1,372,374,376,-1,376,375,372,-1,94,370,373,-1,94,368,370,-1,368,1040,369,-1,368,93,1040,-1,95,1041,371,-1,1042,374,373,-1,370,153,156,-1,370,367,153,-1,84,1043,366,-1,366,85,84,-1,1041,364,1044,-1,1041,95,364,-1,361,876,363,-1,361,190,876,-1,363,360,361,-1,361,360,189,-1,364,1045,1044,-1,359,364,356,-1,359,1045,364,-1,352,1046,1047,-1,352,354,1046,-1,1047,1048,352,-1,353,363,876,-1,189,188,269,-1,279,269,188,-1,347,223,95,-1,219,218,341,-1,341,14,219,-1,339,337,335,-1,338,578,580,-1,338,337,578,-1,330,342,334,-1,330,15,342,-1,333,348,14,-1,333,16,65,-1,346,237,325,-1,98,65,16,-1,15,328,329,-1,330,336,328,-1,336,1049,328,-1,1050,346,344,-1,98,329,99,-1,276,222,221,-1,222,329,328,-1,1051,1052,331,-1,233,1053,1054,-1,233,1055,1053,-1,1056,1057,1058,-1,1058,1059,1056,-1,324,321,1060,-1,1060,1061,324,-1,1062,321,1063,-1,102,1064,1065,-1,1064,1066,1065,-1,299,1067,300,-1,1067,1068,300,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_5()
		{
			int[] value = {312,1069,1070,-1,312,1071,1069,-1,315,304,1072,-1,315,1073,316,-1,315,1069,308,-1,312,314,1071,-1,314,1061,605,-1,1069,309,308,-1,1069,1071,309,-1,306,604,963,-1,306,305,604,-1,630,962,628,-1,1074,1075,1076,-1,1063,321,1077,-1,321,323,1077,-1,4,3,297,-1,736,294,917,-1,294,295,917,-1,182,519,295,-1,719,516,1078,-1,1078,1079,719,-1,514,719,1079,-1,1079,1080,514,-1,283,232,1081,-1,232,234,1081,-1,410,415,411,-1,415,1029,411,-1,1082,286,285,-1,1082,1083,286,-1,268,361,189,-1,1084,1053,1055,-1,231,281,229,-1,229,1053,1084,-1,229,281,1053,-1,1085,226,1086,-1,1085,1087,226,-1,1088,1086,1089,-1,1088,1085,1086,-1,1090,1091,1088,-1,1091,1085,1088,-1,1092,1093,228,-1,228,230,1092,-1,1094,1095,191,-1,191,868,1094,-1,1086,1096,1089,-1,1086,1097,1096,-1,287,1098,285,-1,287,351,1098,-1,710,37,36,-1,635,267,186,-1,635,1099,267,-1,637,1099,635,-1,637,650,1099,-1,1100,703,651,-1,651,1101,1100,-1,1102,918,711,-1,711,702,1102,-1,56,1103,57,-1,262,261,265,-1,265,264,262,-1,61,266,60,-1,1104,665,944,-1,1104,252,665,-1,250,249,34,-1,249,38,34,-1,1105,657,1106,-1,1106,1107,1105,-1,1108,654,1109,-1,1108,947,654,-1,661,658,946,-1,661,655,658,-1,239,1110,25,-1,326,66,1052,-1,326,237,66,-1,1064,1111,1112,-1,234,103,102,-1,284,233,232,-1,284,1055,233,-1,1097,1113,1114,-1,1097,225,1113,-1,227,1087,277,-1,227,226,1087,-1,227,221,220,-1,227,277,221,-1,347,1115,332,-1,906,64,115,-1,64,63,115,-1,68,70,216,-1,332,1116,349,-1,332,1117,1116,-1,76,212,118,-1,118,120,76,-1,206,404,288,-1,206,205,404,-1,133,204,131,-1,133,871,204,-1,202,201,1118,-1,1118,1119,202,-1,198,141,200,-1,198,139,141,-1,196,199,197,-1,196,195,199,-1,1120,143,194,-1,143,145,194,-1,188,362,1083,-1,188,187,362,-1,97,96,287,-1,287,1121,97,-1,215,217,1026,-1,519,181,741,-1,519,182,181,-1,519,738,1,-1,519,741,738,-1,895,172,174,-1,174,1122,895,-1,824,179,176,-1,824,826,179,-1,1123,1124,748,-1,748,1125,1123,-1,22,21,566,-1,566,573,22,-1,1126,1127,909,-1,909,1128,1126,-1,725,109,111,-1,726,760,730,-1,726,1129,760,-1,755,168,167,-1,755,901,168,-1,764,161,770,-1,161,159,770,-1,166,107,106,-1,166,164,107,-1,1115,1117,332,-1,86,155,87,-1,150,388,1130,-1,1130,1131,150,-1,70,69,388,-1,388,150,70,-1,137,131,138,-1,137,134,131,-1,1132,398,143,-1,398,146,143,-1,145,1133,195,-1,145,144,1133,-1,141,1134,201,-1,141,140,1134,-1,1118,136,135,-1,1118,1035,136,-1,132,1135,133,-1,132,1136,1135,-1,1092,872,273,-1,275,1092,273,-1,275,1093,1092,-1,345,1098,351,-1,351,344,345,-1,38,249,128,-1,249,129,128,-1,1137,1138,1139,-1,249,1140,129,-1,249,251,1140,-1,239,1141,1142,-1,1142,240,239,-1,122,121,389,-1,121,383,389,-1,116,117,1040,-1,89,113,92,-1,111,105,1129,-1,758,105,1143,-1,106,105,108,-1,105,107,773,-1,1144,1112,1111,-1,1111,1145,1144,-1,100,99,276,-1,16,329,98,-1,350,344,351,-1,1040,117,369,-1,112,89,88,-1,94,372,92,-1,89,382,91,-1,81,82,79,-1,79,88,90,-1,90,80,79,-1,83,781,79,-1,75,74,994,-1,78,74,73,-1,69,208,71,-1,1028,393,409,-1,409,411,1028,-1,223,224,1050,-1,1038,259,924,-1,1038,257,259,-1,60,266,265,-1,265,916,60,-1,583,601,584,-1,583,970,601,-1,625,964,626,-1,459,1000,455,-1,569,44,43,-1,567,569,571,-1,1146,461,460,-1,38,128,36,-1,30,1147,31,-1,27,713,29,-1,29,28,27,-1,23,25,1110,-1,23,715,24,-1,260,37,710,-1,15,14,342,-1,1059,236,235,-1,235,1148,1059,-1,817,175,173,-1,913,917,295,-1,2,1,738,-1,2,738,3,-1,0,2,4,-1,311,1071,314,-1,311,309,1071,-1,964,970,626,-1,964,601,970,-1,394,1038,302,-1,394,257,1038,-1,214,62,219,-1,214,117,62,-1,325,1149,1150,-1,326,1149,325,-1,225,1086,226,-1,1086,225,1097,-1,1151,1143,105,-1,1143,1151,890,-1,760,105,758,-1,1129,105,760,-1,113,93,92,-1,93,113,114,-1,119,120,118,-1,120,119,121,-1,1152,123,122,-1,210,123,1152,-1,210,71,208,-1,210,1152,71,-1,25,1141,239,-1,25,24,1141,-1,1142,923,1153,-1,1142,1154,923,-1,687,1153,923,-1,1155,1153,687,-1,126,687,689,-1,126,1155,687,-1,124,689,1156,-1,124,126,689,-1,1104,124,1157,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_6()
		{
			int[] value = {1104,127,124,-1,252,1157,253,-1,252,1104,1157,-1,243,254,1158,-1,243,255,254,-1,241,1158,1159,-1,241,243,1158,-1,1109,1159,1160,-1,1109,241,1159,-1,1160,1108,1109,-1,1108,1160,1161,-1,952,1162,1137,-1,1162,952,1163,-1,1164,1162,1163,-1,1165,1162,1164,-1,1164,1166,1165,-1,1166,1164,950,-1,1167,950,949,-1,1167,1166,950,-1,1168,949,1169,-1,1168,1167,949,-1,697,1168,1169,-1,1140,1168,697,-1,1140,130,129,-1,1140,697,130,-1,1139,1137,1161,-1,1137,1139,1138,-1,1107,1161,1137,-1,1107,1108,1161,-1,1170,345,1171,-1,1098,345,1170,-1,1172,1173,1090,-1,1174,1173,1172,-1,1088,1175,1176,-1,1088,1089,1175,-1,1177,1096,1178,-1,1179,1096,1177,-1,1180,275,1181,-1,1180,1093,275,-1,1090,1176,1172,-1,1176,1090,1088,-1,1134,1118,201,-1,1134,1035,1118,-1,195,1037,199,-1,195,1133,1037,-1,149,1132,147,-1,149,398,1132,-1,365,150,1131,-1,365,151,150,-1,85,1131,86,-1,85,365,1131,-1,1115,371,154,-1,347,371,1115,-1,371,155,154,-1,371,87,155,-1,163,764,770,-1,764,163,165,-1,1182,755,759,-1,1182,901,755,-1,111,726,725,-1,111,1129,726,-1,729,760,761,-1,730,760,729,-1,731,756,757,-1,733,756,731,-1,912,917,913,-1,917,912,734,-1,1183,727,732,-1,1184,727,1183,-1,1185,909,728,-1,1128,909,1185,-1,43,566,571,-1,43,573,566,-1,748,1186,1125,-1,747,1186,748,-1,826,895,1122,-1,826,824,895,-1,1187,744,907,-1,744,1187,745,-1,747,1187,1186,-1,1187,747,745,-1,362,286,1083,-1,362,1188,286,-1,286,1121,287,-1,286,1188,1121,-1,1120,1132,143,-1,1076,1132,1120,-1,1118,1189,1119,-1,1118,135,1189,-1,207,1136,205,-1,207,1135,1136,-1,408,1095,869,-1,1031,1095,408,-1,871,1135,207,-1,871,133,1135,-1,392,409,393,-1,409,392,1030,-1,349,214,219,-1,349,213,214,-1,349,1116,213,-1,1075,1063,1077,-1,1075,1190,1063,-1,100,1149,1051,-1,1149,100,1191,-1,1192,277,1087,-1,277,1192,278,-1,1114,280,1193,-1,280,1114,1113,-1,1084,284,1194,-1,1084,1055,284,-1,101,1064,102,-1,101,1111,1064,-1,1144,11,1112,-1,1144,1195,11,-1,1058,1067,299,-1,1058,1196,1067,-1,1197,1198,1199,-1,1197,1062,1198,-1,240,693,238,-1,240,1200,693,-1,1201,714,1154,-1,1201,715,714,-1,1108,1106,947,-1,1107,1106,1108,-1,666,252,255,-1,666,665,252,-1,658,1105,1202,-1,658,657,1105,-1,929,1203,1204,-1,929,946,1203,-1,1205,959,958,-1,1205,1206,959,-1,642,1103,1207,-1,57,1103,642,-1,960,56,55,-1,960,1208,56,-1,638,1209,639,-1,638,1210,1209,-1,710,702,711,-1,702,710,36,-1,918,1211,919,-1,1211,918,1102,-1,705,1100,1212,-1,705,703,1100,-1,651,637,1101,-1,651,650,637,-1,645,257,394,-1,645,258,257,-1,1098,1082,285,-1,1098,1170,1082,-1,1174,271,279,-1,1174,1172,271,-1,227,1213,225,-1,220,1213,227,-1,1175,1094,868,-1,1175,1179,1094,-1,868,1176,1175,-1,270,1176,868,-1,870,1177,1181,-1,874,1177,870,-1,1191,1150,1149,-1,1150,1191,1214,-1,1087,1091,1192,-1,1091,1087,1085,-1,1178,1097,1114,-1,1096,1097,1178,-1,1215,225,1213,-1,225,1215,1113,-1,1194,282,873,-1,284,282,1194,-1,1180,228,1093,-1,1180,1193,228,-1,873,230,1194,-1,873,1092,230,-1,872,1092,873,-1,301,959,394,-1,301,627,959,-1,203,283,1081,-1,204,283,203,-1,395,924,925,-1,395,1038,924,-1,514,292,291,-1,514,1080,292,-1,1079,292,1080,-1,1078,292,1079,-1,293,292,1078,-1,1074,1190,1075,-1,1198,1190,1074,-1,1216,236,300,-1,236,1216,1217,-1,1068,1120,194,-1,1068,1218,1120,-1,300,197,1216,-1,300,196,197,-1,13,198,200,-1,13,1217,198,-1,202,1066,1219,-1,1066,202,1119,-1,962,963,625,-1,306,963,962,-1,306,630,307,-1,306,962,630,-1,314,324,1061,-1,313,324,314,-1,1073,308,310,-1,1073,315,308,-1,1070,315,1072,-1,1070,1069,315,-1,1070,1220,319,-1,1070,1072,1220,-1,1067,1218,1068,-1,1067,1199,1218,-1,12,1217,13,-1,12,236,1217,-1,1219,1064,1112,-1,1064,1219,1066,-1,1065,234,102,-1,234,1065,1081,-1,1060,1062,1197,-1,321,1062,1060,-1,590,1060,1221,-1,590,1061,1060,-1,1057,1196,1058,-1,1221,1196,1057,-1,1222,1057,1056,-1,1222,591,1057,-1,588,1223,1224,-1,588,1225,1223,-1,1223,1059,1148,-1,1056,1059,1223,-1,1226,235,1195,-1,1226,1148,235,-1,1054,103,233,-1,103,1054,104,-1,1227,101,104,-1,1227,1228,101,-1,1053,1229,1054,-1,1230,1229,1053,-1,1215,1231,281,-1,1232,1231,1215,-1,1233,1195,1144,-1,1233,1226,1195,-1,1234,1145,1228,-1,1234,1235,1145,-1,1229,1236,1227,-1,1237,1236,1229,-1,1231,1238,1230,-1,1239,1238,1231,-1,1240,1241,1232,-1,1242,1241,1240,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_7()
		{
			int[] value = {1242,1243,1241,-1,1242,1244,1243,-1,1239,1245,1238,-1,1239,1246,1245,-1,1237,1247,1236,-1,1237,1248,1247,-1,1234,1249,1235,-1,1234,1250,1249,-1,1251,1226,1233,-1,1224,1226,1251,-1,586,1251,1249,-1,586,589,1251,-1,587,1247,582,-1,587,1250,1247,-1,1245,585,1248,-1,1252,585,1245,-1,1243,975,1246,-1,976,975,1243,-1,1253,1254,1244,-1,1255,1254,1253,-1,328,1253,327,-1,1253,328,1049,-1,1240,220,222,-1,220,1240,1213,-1,331,66,65,-1,331,1052,66,-1,325,1171,345,-1,325,1150,1171,-1,346,224,237,-1,1050,224,346,-1,336,1256,1049,-1,336,338,1256,-1,332,333,65,-1,348,333,332,-1,385,192,1032,-1,192,385,875,-1,355,352,359,-1,352,355,353,-1,1048,359,352,-1,1045,359,1048,-1,354,385,1046,-1,385,354,875,-1,1047,1257,366,-1,1047,1046,1257,-1,1043,1045,1048,-1,1045,1043,1044,-1,187,363,362,-1,187,360,363,-1,1188,356,1121,-1,1188,357,356,-1,1041,1043,84,-1,1041,1044,1043,-1,373,156,1042,-1,373,370,156,-1,1042,376,374,-1,1042,1130,376,-1,1041,87,371,-1,1041,84,87,-1,367,213,1116,-1,369,213,367,-1,117,213,369,-1,1257,152,151,-1,152,1257,1258,-1,393,387,386,-1,393,1027,387,-1,146,1006,144,-1,146,1007,1006,-1,1133,440,1037,-1,1133,1004,440,-1,447,1035,1134,-1,1035,447,1036,-1,134,1033,132,-1,134,1034,1033,-1,1136,1033,205,-1,1136,132,1033,-1,392,1032,1095,-1,392,386,1032,-1,1030,410,409,-1,410,1030,407,-1,1027,1026,217,-1,1027,1028,1026,-1,1025,415,390,-1,1025,1029,415,-1,1259,1260,999,-1,1259,1261,1260,-1,999,1012,1259,-1,1012,999,996,-1,1262,405,1033,-1,1262,414,405,-1,1263,1034,402,-1,1263,1264,1034,-1,1036,1265,403,-1,1266,1265,1036,-1,419,425,416,-1,419,422,425,-1,418,1020,416,-1,418,1267,1020,-1,1022,1019,419,-1,1022,1268,1019,-1,417,1018,1016,-1,417,429,1018,-1,1017,418,417,-1,418,1017,1014,-1,1267,1015,1011,-1,1267,418,1015,-1,1023,1269,1009,-1,1023,1020,1269,-1,1021,1009,1270,-1,1021,1023,1009,-1,1019,1271,1272,-1,1019,1268,1271,-1,421,1273,1274,-1,421,420,1273,-1,1275,423,1276,-1,424,423,1275,-1,431,426,1277,-1,427,426,431,-1,1278,430,1279,-1,428,430,1278,-1,1016,1280,1281,-1,1016,1018,1280,-1,1282,1014,1017,-1,1014,1282,1261,-1,1011,1259,1012,-1,1011,1015,1259,-1,1269,1013,1024,-1,1269,1011,1013,-1,1270,1008,1283,-1,1009,1008,1270,-1,1283,994,412,-1,1283,1008,994,-1,1272,413,414,-1,1272,1271,413,-1,1274,1262,1264,-1,1274,1273,1262,-1,1266,1275,1265,-1,1277,1275,1266,-1,1284,1279,1285,-1,1278,1279,1284,-1,1281,1286,451,-1,1281,1280,1286,-1,1261,1287,1260,-1,1261,1282,1287,-1,457,319,1220,-1,319,457,317,-1,1006,1003,1004,-1,1006,1005,1003,-1,1005,399,438,-1,1005,1007,399,-1,1003,441,1004,-1,443,441,1003,-1,446,433,448,-1,1285,433,446,-1,1002,1284,445,-1,1286,1284,1002,-1,435,452,444,-1,434,452,435,-1,455,1001,317,-1,453,1001,455,-1,1260,998,1146,-1,1287,998,1260,-1,1000,998,450,-1,459,998,1000,-1,484,1146,998,-1,1146,484,481,-1,462,482,466,-1,462,461,482,-1,995,989,1024,-1,995,997,989,-1,994,1010,991,-1,994,1008,1010,-1,73,991,993,-1,73,75,991,-1,993,212,76,-1,212,993,992,-1,993,990,476,-1,990,993,991,-1,990,997,465,-1,990,989,997,-1,460,463,996,-1,463,460,462,-1,992,80,212,-1,471,80,992,-1,1288,904,478,-1,814,904,1288,-1,478,488,1288,-1,488,478,477,-1,477,489,488,-1,489,477,480,-1,988,498,497,-1,988,501,498,-1,986,812,1289,-1,899,812,986,-1,502,987,505,-1,1290,987,502,-1,495,1289,487,-1,986,1289,495,-1,809,754,753,-1,754,809,508,-1,754,513,750,-1,754,511,513,-1,500,717,512,-1,500,499,717,-1,290,298,515,-1,290,516,298,-1,910,1291,525,-1,910,724,1291,-1,922,531,533,-1,531,922,708,-1,985,1292,532,-1,1292,985,542,-1,539,552,536,-1,539,982,552,-1,983,985,984,-1,983,541,985,-1,980,546,537,-1,980,547,546,-1,550,536,552,-1,1293,536,550,-1,763,1293,550,-1,763,762,1293,-1,559,545,544,-1,549,545,559,-1,160,559,558,-1,160,157,559,-1,571,171,979,-1,566,171,571,-1,978,42,44,-1,978,574,42,-1,972,978,974,-1,972,575,978,-1,1256,1294,1255,-1,1256,598,1294,-1,1254,977,976,-1,1254,1295,977,-1,971,975,977,-1,1252,975,971,-1,603,1222,1225,-1,1222,603,602,-1,557,593,595,-1,557,594,593,-1,614,560,615,-1,973,560,614,-1,972,973,617,-1,972,974,973,-1,610,1294,611,-1,1295,1294,610,-1,977,968,971,-1,977,969,968,-1,963,52,964,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_8()
		{
			int[] value = {52,963,604,-1,626,968,621,-1,626,970,968,-1,609,600,608,-1,600,609,611,-1,618,965,607,-1,618,967,965,-1,961,609,640,-1,612,609,961,-1,925,492,485,-1,925,686,492,-1,316,630,629,-1,316,1073,630,-1,632,616,613,-1,632,966,616,-1,966,631,634,-1,966,632,631,-1,967,183,965,-1,183,967,636,-1,965,185,619,-1,965,183,185,-1,961,55,622,-1,961,960,55,-1,956,957,644,-1,956,1156,957,-1,1206,1296,955,-1,1206,1205,1296,-1,955,1297,956,-1,955,1296,1297,-1,647,1205,1207,-1,647,1296,1205,-1,1298,1103,56,-1,1298,648,1103,-1,1299,1300,1298,-1,1300,1299,1301,-1,1209,1299,1208,-1,1209,1302,1299,-1,953,1303,1302,-1,1303,953,954,-1,953,184,951,-1,184,953,1210,-1,951,1163,952,-1,951,1304,1163,-1,1099,1304,267,-1,1099,1305,1304,-1,950,1305,652,-1,1164,1305,950,-1,649,1169,949,-1,649,704,1169,-1,948,1106,662,-1,948,947,1106,-1,948,939,653,-1,948,672,939,-1,938,242,244,-1,242,938,945,-1,943,256,944,-1,937,256,943,-1,932,675,668,-1,675,932,1306,-1,668,935,940,-1,668,936,935,-1,942,938,669,-1,942,945,938,-1,942,667,945,-1,667,942,941,-1,937,940,935,-1,937,943,940,-1,934,933,926,-1,934,936,933,-1,683,1306,932,-1,683,681,1306,-1,932,930,680,-1,931,930,932,-1,680,677,679,-1,930,677,680,-1,927,673,1307,-1,927,676,673,-1,676,692,926,-1,692,676,928,-1,684,926,691,-1,934,926,684,-1,957,61,259,-1,957,688,61,-1,693,928,238,-1,693,692,928,-1,927,238,928,-1,238,927,694,-1,696,239,694,-1,696,1110,239,-1,695,682,1147,-1,695,1307,682,-1,1147,35,31,-1,35,1147,682,-1,1102,699,1211,-1,1102,700,699,-1,709,721,920,-1,709,723,721,-1,919,921,920,-1,919,1212,921,-1,918,712,711,-1,918,721,712,-1,50,493,685,-1,50,496,493,-1,988,50,48,-1,988,496,50,-1,1308,499,501,-1,499,1308,848,-1,1309,518,1310,-1,0,518,1309,-1,915,295,1311,-1,913,295,915,-1,723,911,722,-1,723,922,911,-1,885,922,533,-1,885,911,922,-1,532,855,533,-1,855,532,1292,-1,1312,523,525,-1,1312,856,523,-1,883,1128,884,-1,1291,1128,883,-1,1291,1126,1128,-1,1184,1313,1185,-1,1314,1313,1184,-1,912,1315,1183,-1,1315,912,914,-1,909,724,726,-1,909,1127,724,-1,739,743,749,-1,739,740,743,-1,297,1123,751,-1,296,1123,297,-1,296,1124,1123,-1,752,1186,807,-1,752,1125,1186,-1,1187,908,808,-1,1187,907,908,-1,169,180,735,-1,169,902,180,-1,548,166,106,-1,166,548,981,-1,768,159,158,-1,771,159,768,-1,979,798,567,-1,979,903,798,-1,783,340,905,-1,340,783,339,-1,780,83,905,-1,83,780,906,-1,814,818,904,-1,814,811,818,-1,799,818,800,-1,799,785,818,-1,792,41,798,-1,792,39,41,-1,766,804,767,-1,766,796,804,-1,769,837,772,-1,769,896,837,-1,836,774,837,-1,773,774,836,-1,828,808,908,-1,828,806,808,-1,169,900,827,-1,900,169,168,-1,901,891,892,-1,891,901,1182,-1,806,174,810,-1,806,1122,174,-1,816,1316,898,-1,1290,1316,816,-1,813,987,815,-1,899,987,813,-1,887,802,801,-1,802,887,1317,-1,1318,897,803,-1,897,1318,840,-1,896,838,837,-1,896,840,838,-1,894,9,893,-1,894,178,9,-1,10,900,892,-1,10,177,900,-1,832,879,1319,-1,834,879,832,-1,830,1151,1319,-1,830,890,1151,-1,864,889,1320,-1,864,888,889,-1,889,840,1318,-1,889,839,840,-1,841,1317,887,-1,841,1320,1317,-1,844,822,821,-1,844,841,822,-1,861,845,846,-1,861,863,845,-1,916,261,849,-1,916,265,261,-1,1308,46,886,-1,48,46,1308,-1,847,867,720,-1,858,867,847,-1,886,862,859,-1,862,886,46,-1,882,911,885,-1,882,1321,911,-1,880,1312,883,-1,880,865,1312,-1,884,1322,880,-1,1322,884,1313,-1,1315,1323,1314,-1,1324,1323,1315,-1,915,1325,914,-1,877,1325,915,-1,1309,878,1311,-1,1326,878,1309,-1,720,866,1310,-1,867,866,720,-1,882,888,1321,-1,881,888,882,-1,829,880,1322,-1,829,879,880,-1,1324,831,1323,-1,893,831,1324,-1,877,894,1325,-1,825,894,877,-1,1326,823,878,-1,895,823,1326,-1,1150,1173,1171,-1,1214,1173,1150,-1,273,289,274,-1,289,273,872,-1,869,1094,874,-1,869,1095,1094,-1,895,866,172,-1,895,1326,866,-1,1325,893,1324,-1,894,893,1325,-1,829,1323,831,-1,829,1322,1323,-1,1321,864,853,-1,888,864,1321,-1,45,863,861,-1,863,45,851,-1,859,861,860,-1,861,859,862,-1,1326,1310,866,-1,1326,1309,1310,-1,1311,877,915,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_9()
		{
			int[] value = {878,877,1311,-1,914,1324,1315,-1,1325,1324,914,-1,1314,1322,1313,-1,1323,1322,1314,-1,865,856,1312,-1,865,854,856,-1,1321,19,911,-1,1321,853,19,-1,49,849,47,-1,849,49,916,-1,848,886,847,-1,886,848,1308,-1,863,844,845,-1,863,842,844,-1,1320,1318,1317,-1,1320,889,1318,-1,1320,843,864,-1,843,1320,841,-1,839,833,835,-1,839,881,833,-1,836,1319,1151,-1,832,1319,836,-1,829,1319,879,-1,829,830,1319,-1,177,827,900,-1,177,179,827,-1,1317,803,802,-1,803,1317,1318,-1,822,801,819,-1,801,822,887,-1,1290,815,987,-1,1290,816,815,-1,898,809,810,-1,1316,809,898,-1,890,1182,1143,-1,890,891,1182,-1,827,908,902,-1,827,828,908,-1,828,1122,806,-1,828,826,1122,-1,896,805,897,-1,769,805,896,-1,794,801,802,-1,794,795,801,-1,788,776,775,-1,788,791,776,-1,785,789,784,-1,799,789,785,-1,788,787,786,-1,788,775,787,-1,787,777,782,-1,778,777,787,-1,470,82,81,-1,470,782,82,-1,905,343,780,-1,905,340,343,-1,339,777,337,-1,777,339,783,-1,775,578,778,-1,775,579,578,-1,20,776,41,-1,20,576,776,-1,771,769,772,-1,771,768,769,-1,568,766,565,-1,766,568,797,-1,166,762,165,-1,166,981,762,-1,1186,808,807,-1,1186,1187,808,-1,751,1125,752,-1,751,1123,1125,-1,751,515,297,-1,515,751,750,-1,748,296,746,-1,296,748,1124,-1,757,736,731,-1,735,736,757,-1,732,729,733,-1,732,727,729,-1,110,725,724,-1,110,109,725,-1,1183,1314,1184,-1,1183,1315,1314,-1,1185,884,1128,-1,1313,884,1185,-1,883,525,1291,-1,883,1312,525,-1,856,1292,523,-1,856,855,1292,-1,0,1311,295,-1,0,1309,1311,-1,1310,517,720,-1,518,517,1310,-1,717,848,718,-1,717,499,848,-1,48,501,988,-1,501,48,1308,-1,23,696,713,-1,1110,696,23,-1,1211,698,705,-1,1211,699,698,-1,702,700,1102,-1,702,701,700,-1,700,697,699,-1,130,697,700,-1,698,1169,704,-1,698,697,1169,-1,1147,696,695,-1,696,1147,30,-1,1307,694,927,-1,1307,695,694,-1,716,1154,714,-1,716,923,1154,-1,61,690,266,-1,690,61,688,-1,1156,688,957,-1,1156,689,688,-1,937,684,256,-1,684,937,934,-1,681,1307,673,-1,681,682,1307,-1,33,683,680,-1,683,33,35,-1,250,33,679,-1,250,34,33,-1,673,1306,681,-1,673,675,1306,-1,941,943,667,-1,943,941,940,-1,663,670,664,-1,663,671,670,-1,940,669,668,-1,940,942,669,-1,674,668,675,-1,668,674,933,-1,668,671,931,-1,668,670,671,-1,948,664,672,-1,948,662,664,-1,656,1106,657,-1,656,662,1106,-1,633,1212,1100,-1,633,921,1212,-1,652,1099,650,-1,1305,1099,652,-1,1164,1304,1305,-1,1164,1163,1304,-1,267,951,184,-1,951,267,1304,-1,1210,1302,1209,-1,1302,1210,953,-1,1302,1301,1299,-1,1302,1303,1301,-1,1208,1298,56,-1,1298,1208,1299,-1,648,1300,646,-1,1298,1300,648,-1,648,1207,1103,-1,647,1207,648,-1,1296,646,1297,-1,647,646,1296,-1,955,645,1206,-1,955,644,645,-1,627,643,958,-1,627,629,643,-1,641,958,643,-1,641,642,958,-1,58,622,55,-1,58,623,622,-1,619,638,620,-1,619,185,638,-1,635,183,636,-1,186,183,635,-1,634,967,966,-1,634,636,967,-1,634,1101,637,-1,634,631,1101,-1,1100,631,633,-1,1101,631,1100,-1,633,613,707,-1,632,613,633,-1,608,640,609,-1,608,620,640,-1,624,610,612,-1,624,969,610,-1,617,607,596,-1,617,618,607,-1,604,592,602,-1,592,604,305,-1,1295,969,977,-1,1295,610,969,-1,611,598,600,-1,1294,598,611,-1,581,599,580,-1,581,597,599,-1,592,1061,590,-1,605,1061,592,-1,602,591,1222,-1,591,602,592,-1,53,1225,588,-1,1225,53,603,-1,53,586,54,-1,589,586,53,-1,582,54,587,-1,582,584,54,-1,1252,583,585,-1,1252,971,583,-1,1255,1295,1254,-1,1255,1294,1295,-1,338,598,1256,-1,338,580,598,-1,577,579,576,-1,581,579,577,-1,563,570,568,-1,563,561,570,-1,768,562,564,-1,768,162,562,-1,768,158,162,-1,562,160,558,-1,562,162,160,-1,559,765,549,-1,559,161,765,-1,559,157,161,-1,980,762,981,-1,762,980,1293,-1,1293,537,536,-1,1293,980,537,-1,534,547,108,-1,534,535,547,-1,984,543,983,-1,526,543,984,-1,541,542,985,-1,541,540,542,-1,521,538,522,-1,521,540,538,-1,982,541,983,-1,541,982,539,-1,537,522,538,-1,537,546,522,-1,523,542,524,-1,523,1292,542,-1,1127,1291,724,-1,1127,1126,1291,-1,298,518,4,-1,298,517,518,-1,512,514,510,-1,512,717,514,-1,508,511,754,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_10()
		{
			int[] value = {508,507,511,-1,508,1316,506,-1,809,1316,508,-1,509,502,504,-1,506,502,509,-1,506,1290,502,-1,1316,1290,506,-1,500,504,498,-1,504,500,509,-1,497,504,503,-1,497,498,504,-1,487,1288,488,-1,487,1289,1288,-1,484,454,483,-1,484,459,454,-1,480,466,482,-1,480,477,466,-1,814,1289,812,-1,814,1288,1289,-1,471,476,472,-1,471,992,476,-1,465,996,463,-1,996,465,997,-1,465,476,990,-1,476,465,464,-1,76,73,993,-1,76,78,73,-1,1010,989,991,-1,1010,1024,989,-1,461,481,482,-1,461,1146,481,-1,450,1287,451,-1,998,1287,450,-1,1146,999,1260,-1,1146,460,999,-1,456,317,457,-1,317,456,455,-1,450,453,1000,-1,450,452,453,-1,450,449,452,-1,449,444,452,-1,449,1002,444,-1,451,1002,449,-1,451,1286,1002,-1,445,1285,446,-1,1284,1285,445,-1,448,432,447,-1,433,432,448,-1,445,443,1002,-1,445,441,443,-1,1003,438,437,-1,1003,1005,438,-1,438,148,439,-1,438,149,148,-1,149,438,399,-1,436,323,435,-1,436,1077,323,-1,1220,458,457,-1,1220,303,458,-1,1282,451,1287,-1,1282,1281,451,-1,1286,1278,1284,-1,1280,1278,1286,-1,1285,431,433,-1,1279,431,1285,-1,432,1277,1266,-1,431,1277,432,-1,1265,1276,1263,-1,1275,1276,1265,-1,1262,1272,414,-1,1273,1272,1262,-1,1271,412,413,-1,1271,1283,412,-1,1009,1024,1010,-1,1009,1269,1024,-1,1015,1261,1259,-1,1015,1014,1261,-1,1017,1281,1282,-1,1017,1016,1281,-1,1018,1278,1280,-1,1018,428,1278,-1,1279,427,431,-1,430,427,1279,-1,1277,424,1275,-1,426,424,1277,-1,423,1274,1276,-1,423,421,1274,-1,1273,1019,1272,-1,420,1019,1273,-1,1268,1283,1271,-1,1268,1270,1283,-1,1268,1021,1270,-1,1021,1268,1022,-1,1020,1011,1269,-1,1020,1267,1011,-1,430,425,427,-1,429,425,430,-1,426,422,424,-1,425,422,426,-1,421,422,419,-1,422,421,423,-1,1022,416,1020,-1,1022,419,416,-1,429,416,425,-1,417,416,429,-1,447,1266,1036,-1,432,1266,447,-1,403,1263,402,-1,1265,1263,403,-1,1264,1033,1034,-1,1264,1262,1033,-1,412,74,391,-1,412,994,74,-1,995,1012,996,-1,1012,995,1013,-1,140,447,1134,-1,140,400,447,-1,1004,144,1006,-1,1133,144,1004,-1,302,458,303,-1,302,396,458,-1,1263,1274,1264,-1,1274,1263,1276,-1,217,152,387,-1,217,216,152,-1,1258,387,152,-1,1258,385,387,-1,1039,377,72,-1,378,377,1039,-1,381,379,383,-1,381,380,379,-1,372,380,89,-1,372,375,380,-1,378,379,375,-1,378,384,379,-1,153,1116,1117,-1,1116,153,367,-1,1130,377,376,-1,1130,388,377,-1,366,151,365,-1,151,366,1257,-1,1121,364,97,-1,364,1121,356,-1,358,1188,362,-1,1188,358,357,-1,1048,366,1043,-1,1048,1047,366,-1,1258,1046,385,-1,1046,1258,1257,-1,353,358,363,-1,353,355,358,-1,354,876,875,-1,876,354,353,-1,188,1082,279,-1,188,1083,1082,-1,348,219,14,-1,219,348,349,-1,350,95,223,-1,350,96,95,-1,340,342,343,-1,340,334,342,-1,1050,350,223,-1,1050,344,350,-1,1051,98,100,-1,1051,331,98,-1,327,1244,1242,-1,327,1253,1244,-1,1049,1255,1253,-1,1049,1256,1255,-1,1244,976,1243,-1,1254,976,1244,-1,1252,1246,975,-1,1252,1245,1246,-1,1248,582,1247,-1,585,582,1248,-1,1250,586,1249,-1,587,586,1250,-1,589,1224,1251,-1,589,588,1224,-1,1235,1251,1233,-1,1235,1249,1251,-1,1236,1250,1234,-1,1236,1247,1250,-1,1238,1248,1237,-1,1238,1245,1248,-1,1241,1246,1239,-1,1241,1243,1246,-1,222,1242,1240,-1,327,1242,222,-1,1232,1239,1231,-1,1241,1239,1232,-1,1237,1230,1238,-1,1237,1229,1230,-1,1236,1228,1227,-1,1236,1234,1228,-1,1235,1144,1145,-1,1235,1233,1144,-1,1213,1232,1215,-1,1240,1232,1213,-1,281,1230,1053,-1,1231,1230,281,-1,1227,1054,1229,-1,1227,104,1054,-1,1228,1111,101,-1,1228,1145,1111,-1,1148,1224,1223,-1,1226,1224,1148,-1,1225,1056,1223,-1,1225,1222,1056,-1,591,1221,1057,-1,591,590,1221,-1,1221,1197,1196,-1,1221,1060,1197,-1,1112,13,1219,-1,1112,11,13,-1,1199,1074,1218,-1,1199,1198,1074,-1,320,324,313,-1,324,320,322,-1,1070,318,312,-1,1070,319,318,-1,304,1220,1072,-1,304,303,1220,-1,1073,307,630,-1,310,307,1073,-1,307,309,305,-1,310,309,307,-1,1119,1065,1066,-1,1189,1065,1119,-1,200,1219,13,-1,1219,200,202,-1,1216,198,1217,-1,1216,197,198,-1,196,1068,194,-1,300,1068,196,-1,1218,1076,1120,-1,1218,1074,1076,-1,293,516,290,-1,516,293,1078,-1,1189,1081,1065,-1,1189,203,1081,-1,1178,1193,1180,-1,1178,1114,1193,-1,281,1113,1215,-1,1113,281,280,-1,1090,1214,1091,-1,1173,1214,1090,-1,1192,1214,1191,-1,1192,1091,1214,-1,1181,272,870,-1};
			return value;
		}
		private int[] getroscoxae_Geo_6_19_coordIndex_11()
		{
			int[] value = {1181,275,272,-1,1179,874,1094,-1,1179,1177,874,-1,270,1172,1176,-1,271,1172,270,-1,279,1170,1174,-1,1082,1170,279,-1,919,705,1212,-1,705,919,1211,-1,185,1210,638,-1,185,184,1210,-1,639,1208,960,-1,639,1209,1208,-1,1207,958,642,-1,1207,1205,958,-1,1206,394,959,-1,1206,645,394,-1,713,263,23,-1,713,27,263,-1,259,59,924,-1,61,59,259,-1,251,678,1327,-1,248,678,251,-1,654,241,1109,-1,241,654,244,-1,678,1204,1327,-1,678,929,1204,-1,946,1202,1203,-1,946,658,1202,-1,944,127,1104,-1,944,256,127,-1,242,255,243,-1,242,666,255,-1,247,693,1200,-1,693,247,246,-1,439,147,1075,-1,439,148,147,-1,1077,439,1075,-1,1077,436,439,-1,1196,1199,1067,-1,1196,1197,1199,-1,1059,299,236,-1,1059,1058,299,-1,12,1195,235,-1,11,1195,12,-1,1084,230,229,-1,1084,1194,230,-1,1193,231,228,-1,231,1193,280,-1,1191,278,1192,-1,1191,100,278,-1,1051,326,1052,-1,326,1051,1149,-1,1062,1190,1198,-1,1062,1063,1190,-1,115,781,906,-1,112,781,115,-1,211,69,68,-1,69,211,208,-1,869,404,408,-1,869,288,404,-1,1095,1030,392,-1,1095,1031,1030,-1,203,135,138,-1,1189,135,203,-1,1076,147,1132,-1,1075,147,1076,-1,1032,191,1095,-1,1032,192,191,-1,907,7,180,-1,907,744,7,-1,10,178,177,-1,178,10,9,-1,171,903,979,-1,171,170,903,-1,1184,728,727,-1,1185,728,1184,-1,912,732,734,-1,1183,732,912,-1,733,761,756,-1,729,761,733,-1,1143,759,758,-1,1143,1182,759,-1,773,1151,105,-1,773,836,1151,-1,155,1042,156,-1,1042,155,86,-1,154,1117,1115,-1,154,153,1117,-1,86,1130,1042,-1,86,1131,1130,-1,199,142,139,-1,199,1037,142,-1,1178,1181,1177,-1,1178,1180,1181,-1,1179,1089,1096,-1,1179,1175,1089,-1,1171,1174,1170,-1,1171,1173,1174,-1,1137,954,952,-1,1139,954,1137,-1,1139,1161,954,-1,1140,1327,1168,-1,251,1327,1140,-1,1168,1204,1167,-1,1327,1204,1168,-1,1204,1166,1167,-1,1204,1203,1166,-1,1165,1203,1202,-1,1203,1165,1166,-1,1165,1105,1162,-1,1202,1105,1165,-1,1105,1137,1162,-1,1105,1107,1137,-1,254,1297,646,-1,254,253,1297,-1,954,1160,1303,-1,1161,1160,954,-1,1303,1159,1301,-1,1160,1159,1303,-1,1159,1300,1301,-1,1159,1158,1300,-1,646,1158,254,-1,1158,646,1300,-1,253,956,1297,-1,253,1157,956,-1,1156,1157,124,-1,1157,1156,956,-1,125,1155,126,-1,125,247,1155,-1,1155,1200,1153,-1,247,1200,1155,-1,1142,1200,240,-1,1200,1142,1153,-1,1141,1154,1142,-1,1141,1201,1154,-1,715,1141,24,-1,1141,715,1201,-1,1152,72,71,-1,1152,1039,72,-1,122,1039,1152,-1,122,389,1039,-1,381,121,119,-1,121,381,383,-1,382,119,91,-1,119,382,381,-1,1040,114,116,-1,114,1040,93,-1,112,114,113,-1,112,115,114,-1,1001,318,317,-1,1001,320,318,-1,50,47,48,-1,47,50,49,-1,210,77,123,-1,209,77,210,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getroscoxae_Coord_7_19_point_1()
		{
			double[] value = {-.6367,30.76397,.59497,-.30891,30.76361,.80128,-.30369,30.83372,.84481,-.24063,31.1353,.98627,-.44362,31.01032,.90038,-.21322,30.63677,.20992,-.24447,30.45493,.2146,-.21212,30.36113,-.00127,-1.20947,30.05999,-.63711,-1.08076,30.19905,-.38847,-1.0658,30.19741,-.4151,-4.70625,35.48832,-.61348,-4.70821,35.43933,-.41541,-4.6436,35.60154,-.25245,-1.94386,33.40845,-3.39835,-2.14713,33.87425,-3.36762,-1.92993,34.14859,-3.59594,-2.25142,31.08059,-.72121,-2.40493,31.00164,-.9298,-2.38077,30.78798,-1.03746,-2.18929,31.82512,-2.41143,-2.03656,31.68045,-2.54222,-2.05364,31.68095,-2.55001,-2.36829,31.3,-.36509,-2.37567,31.32545,-.44273,-2.37118,31.32344,-.44421,-2.24599,31.15729,-.48126,-2.26356,31.18189,-.54757,-2.28816,31.10892,-.72539,-2.29351,31.15782,-.74743,-2.2886,31.20563,-.77736,-2.3242,31.3426,-1.1202,-2.43749,31.2806,-1.11917,-2.3561,31.55872,-1.28522,-2.43399,31.34639,-1.24121,-2.2901,31.56925,-1.14832,-2.48456,31.1016,-.97441,-2.46605,31.12529,-.95867,-2.46824,31.32815,-1.17599,-1.98834,31.61533,-2.46245,-1.99844,31.64202,-2.47402,-2.11291,31.76984,-2.38291,-2.10205,31.32148,-2.54606,-2.02688,31.14201,-2.56962,-2.3178,31.23505,-2.44698,-2.11808,31.31164,.04985,-2.0385,31.3082,.21755,-2.23657,31.35607,.17467,-2.09139,31.41354,.40962,-2.4269,31.43607,.22784,-2.30061,31.48749,.40201,-2.73005,31.56847,.36498,-3.75781,33.41021,-.8281,-3.83972,33.79082,-.86632,-3.76109,33.78245,-1.0235,-3.88742,32.49796,-1.05038,-3.87268,32.47247,-1.04476,-3.90218,32.54655,-.85752,-3.88226,32.59274,-.85432,-2.92372,31.93323,.27851,-2.76384,31.55075,.22838,-2.91677,31.9339,.21844,-1.6503,33.3272,-3.37019,-1.6722,33.29182,-3.12577,-1.65033,33.22488,-3.06665,-1.75072,34.2915,-3.77602,-1.5453,34.55302,-4.03285,-1.43815,34.42975,-4.0129,-2.06109,35.07258,-2.39438,-2.05035,35.01794,-2.41669,-2.04324,35.04755,-2.44867,-2.07261,34.92012,-2.30034,-2.07096,34.91475,-2.30265,-2.17576,34.59762,-2.06471,-2.14923,34.7032,-2.1228,-2.20017,34.63144,-2.06376,-2.12265,34.25923,-2.00015,-2.14805,34.54288,-2.09177,-2.15266,34.56564,-2.07443,-1.86563,33.58988,-2.36147,-1.98504,33.67494,-2.09145,-2.02639,33.57089,-2.18365,-2.11178,33.44409,-2.31337,-1.95826,33.47328,-2.5218,-1.52913,34.13003,-3.14312,-1.66626,34.32223,-2.8266,-1.68303,34.29115,-2.81214,-1.63136,33.9999,-3.13702,-1.8137,33.6206,-2.37162,-1.79618,33.6732,-2.41285,-1.98243,33.72703,-2.12505,-1.98217,33.73187,-2.12821,-1.75579,33.58973,-2.55877,-1.77627,33.44988,-2.81492,-1.7213,33.66339,-2.74821,-1.14887,34.12414,-3.84131,-1.04565,34.2363,-3.84047,-1.04606,34.2428,-3.79307,-1.80107,34.52455,-3.77914,-1.9346,34.81064,-3.78498};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_2()
		{
			double[] value = {-1.75678,35.07879,-3.9513,-4.06726,36.27185,-1.84372,-4.06846,36.34829,-1.84392,-3.51649,36.50797,-2.40889,-3.5246,36.38828,-2.33372,-1.36326,29.22718,-1.37356,-1.65205,29.24569,-1.7815,-1.65459,29.25279,-1.77646,-1.74553,28.97364,-1.58375,-1.66243,28.93451,-1.31721,-1.73468,28.92876,-1.37797,-1.60024,28.96942,-1.30273,-1.75707,33.58008,-2.55315,-1.75633,33.5849,-2.55594,-1.77738,33.44495,-2.81251,-1.77822,33.44002,-2.81003,-1.67289,33.29754,-3.12674,-1.64706,33.3328,-3.37484,-2.09146,33.98041,-2.04485,-2.09224,33.98115,-2.05041,-2.13592,34.29276,-2.03289,-2.13687,34.29205,-2.0383,-2.13856,34.52084,-2.12552,-2.13992,34.5224,-2.12057,-2.62669,32.36038,-.51419,-2.53644,32.08606,-.26191,-2.54329,32.08465,-.25775,-2.62181,32.35993,-.51876,-2.47548,31.32801,-1.17827,-2.51659,31.33124,-1.29437,-2.52041,31.32454,-1.29374,-2.95758,36.8033,-2.53343,-2.41011,36.67928,-2.71006,-2.40858,36.68933,-2.7255,-2.95256,36.79626,-2.52171,-3.87708,36.66539,-1.65102,-3.8651,36.6593,-1.64278,-3.41952,36.80275,-2.19853,-3.42815,36.80946,-2.21687,-4.26145,35.34007,.39294,-4.35995,35.72177,-.17543,-4.37678,35.72035,-.17474,-4.24674,35.34059,.38809,-3.97015,34.64054,1.15212,-4.01186,34.90601,.99814,-4.02894,34.9009,1.00144,-3.95177,34.64006,1.1407,-3.95931,34.14461,1.06311,-3.95188,34.14349,1.05171,-3.94438,34.19077,1.06915,-1.85863,34.66975,-2.651,-1.8329,34.68691,-2.67248,-1.90398,35.07983,-2.63993,-1.55659,33.74534,-3.47446,-1.55399,33.7854,-3.47948,-1.65882,33.97587,-3.1246,-1.65889,33.94517,-3.10126,-2.4879,29.94439,-2.46868,-2.47053,29.95156,-2.4677,-2.4167,29.90475,-2.46313,-2.48427,29.95937,-2.47229,-2.47511,29.93316,-2.46958,-2.47992,29.96032,-2.4715,-1.97463,29.51936,-2.24432,-1.82554,29.33445,-2.01399,-1.97162,29.50914,-2.25179,-1.82439,29.32208,-2.02178,-.47069,30.03136,-.26496,-.49553,30.0697,-.29103,-.39712,30.30724,-.13314,-1.86592,31.35901,-2.62423,-1.8734,31.35997,-2.64093,-1.22049,31.08942,.06279,-1.4836,31.31846,-.03598,-1.21226,31.10951,.04384,-1.46732,31.33672,-.04767,-.98404,30.54254,-.17462,-.99087,30.34052,-.30385,-1.00509,30.33467,-.28636,-.97415,30.54962,-.19118,-.23235,30.30808,-.03812,-.21793,30.38139,.26268,-.25681,30.34912,.26616,-3.63633,31.64133,-1.73411,-3.68004,31.86528,-1.62719,-3.7016,31.86577,-1.65752,-3.62222,31.65342,-1.68375,-1.11657,35.09791,-3.5542,-1.1032,35.11785,-3.59817,-1.11516,35.21452,-3.52287,-1.22392,35.37089,-3.40201,-1.33433,35.54817,-3.26111,-1.34645,35.49915,-3.2373,-1.2124,35.39943,-3.43443,-4.03542,34.87395,1.01379,-4.10275,35.04348,.83656,-4.11473,35.02156,.8503,-4.20143,35.17419,.63558,-4.2749,35.33248,.39175,-4.19299,35.19146,.60811};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_3()
		{
			double[] value = {-4.40563,35.70626,-.18869,-4.34307,36.04487,-.66722,-4.35362,36.03281,-.67544,-3.44543,36.80604,-2.23388,-2.96609,36.79803,-2.54741,-2.2703,36.50159,-2.68953,-2.25681,36.51687,-2.73626,-2.35511,36.68411,-2.74891,-2.07337,34.92234,-2.29552,-2.13872,34.68556,-2.12923,-2.12339,34.69201,-2.16825,-2.07789,34.93554,-2.26681,-2.07329,33.95932,-2.01004,-1.64575,33.3372,-3.37799,-1.65132,33.3302,-3.37731,-1.97097,35.27891,-2.4468,-2.03539,35.0722,-2.46219,-1.92679,35.31716,-2.48981,-1.67506,33.29157,-3.36129,-1.68384,33.31036,-3.39612,-2.06091,35.14464,-3.64694,-2.03754,35.09958,-3.65493,-2.14617,34.7161,-3.50621,-1.26251,34.14994,-3.94114,-1.36499,34.42498,-4.05779,-1.81927,35.80734,-3.60086,-1.76143,35.61931,-3.77122,-1.78136,35.58542,-3.72453,-2.08669,36.29251,-3.31737,-2.25904,36.33572,-3.1453,-2.25028,36.37543,-3.13616,-2.09934,36.24989,-3.31314,-3.11651,36.66937,-2.77269,-3.12971,36.6005,-2.77625,-3.52381,36.58085,-2.41146,-4.69792,35.37728,-.44327,-4.51359,35.1224,.29159,-1.4916,34.57172,-4.05265,-2.29681,31.61412,-.47973,-2.29692,31.47472,-.54867,-2.31078,31.62325,-.45522,-2.92513,32.35923,-1.21964,-2.88817,32.43277,-1.09327,-2.90714,32.43034,-1.09129,-2.89952,32.37003,-1.22523,-2.51191,32.08781,-.27732,-2.38971,31.88877,-.27101,-2.41169,31.87048,-.25883,-2.54137,31.40186,-1.40367,-2.51007,31.33453,-1.29692,-2.47988,31.36551,-1.33832,-2.57436,31.37006,-1.38461,-2.80678,32.48565,-.86193,-2.81355,32.48626,-.85857,-2.87158,32.47455,-.95447,-2.86495,32.47524,-.95457,-2.60243,32.35546,-.5304,-3.38704,32.38189,.04941,-3.372,32.38068,.00164,-3.18839,32.24486,.08701,-2.42274,31.12075,-.91571,-2.41416,31.33723,-.11188,-2.42892,31.3927,-.15298,-2.33894,31.25471,-.33721,-2.58395,31.46847,-.0105,-2.57941,31.41699,.01838,-2.7539,31.57489,.16916,-3.54262,31.68503,-1.68117,-1.16681,35.31178,-3.48968,-1.16196,35.22022,-3.62651,-1.27918,35.55774,-3.61737,-1.16491,35.32164,-3.78344,-1.8915,36.27058,-2.94268,-2.01805,36.54031,-2.99632,-1.95442,36.33621,-2.91525,-1.90519,36.43397,-3.24526,-1.95748,34.88867,-3.75983,-1.75012,35.46727,-3.81412,-1.72584,35.21581,-3.95243,-1.13568,35.22975,-3.82897,-2.01347,36.14612,-3.41078,-2.41851,35.98575,-3.12,-2.4316,36.7108,-2.80276,-3.03514,36.81782,-2.69418,-2.62328,36.54709,-2.96186,-1.00272,34.76759,-3.86645,-.98127,34.75395,-3.7285,-.95352,34.49685,-3.78703,-1.92225,36.1392,-2.75971,-2.12755,36.5278,-2.85178,-.70052,31.34857,1.10249,-.82551,31.40137,1.11499,-.85463,31.2841,1.14474,-.82824,31.23027,1.12553,-.32877,30.23843,.17113,-.41896,30.34903,.44486,-.18968,31.34039,.95295,-.34903,31.39516,1.08158,-.55907,31.15709,.95927,-4.31956,34.86818,.69503};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_4()
		{
			double[] value = {-4.28261,34.93717,.81939,-3.60019,32.55585,.03847,-3.45193,32.60273,.09794,-3.6101,32.80733,.36431,-3.79156,32.79687,.24041,-3.87859,33.38119,-.35443,-3.87516,33.20005,-.52582,-3.8918,33.20499,-.4309,-4.01865,33.17481,.07931,-3.9778,33.31195,-.0265,-3.97103,33.20896,-.12486,-3.95154,33.48362,-.04512,-4.03128,33.29339,.38045,-3.90826,33.58935,.43048,-3.97035,33.52717,.18945,-3.94494,32.96069,.16322,-3.83838,32.82215,.06031,-3.54029,33.30292,.58739,-3.80599,33.3436,.55332,-3.76166,33.25843,.60016,-3.8025,33.66719,.56735,-4.08731,34.07861,.65604,-3.8596,33.88239,.61685,-3.95423,34.04681,.77058,-3.96415,33.82442,.50622,-1.10956,34.84149,-4.20857,-1.54293,34.63929,-4.07385,-2.38949,34.39104,-3.12011,-2.31149,34.07401,-3.25281,-2.0231,34.39736,-3.57576,-2.36246,33.68986,-3.06204,-1.71968,34.55375,-3.87459,-1.54484,33.83908,-3.72215,-1.83766,33.85903,-3.60351,-2.30823,33.36423,-2.833,-2.42273,33.35808,-2.57919,-2.56912,33.57343,-2.70313,-2.57466,33.24394,-2.24806,-2.78648,33.39097,-2.3384,-2.35742,33.3383,-2.52889,-2.23391,33.30092,-2.75251,-1.85316,33.24228,-3.2921,-2.18198,33.31461,-3.08413,-2.0979,33.25135,-3.0143,-1.10106,34.52864,-4.04563,-1.05786,34.84461,-4.18365,-1.18012,34.55821,-4.04157,-1.50953,33.85219,-3.72825,-1.7503,33.61462,-3.5766,-1.62571,33.51834,-3.5457,-1.14282,34.29407,-3.96695,-1.08619,34.5263,-4.03589,-1.21106,34.92084,-3.14762,-1.18592,35.01392,-3.23161,-1.2808,35.0743,-3.1318,-1.14599,34.88978,-3.28703,-1.0288,34.59115,-3.51072,-1.03463,34.71921,-3.49732,-1.11408,34.92999,-3.47353,-1.14518,34.78254,-3.26333,-1.14453,35.1615,-3.46658,-1.2011,35.27431,-3.48012,-1.08682,34.95167,-3.61825,-1.17026,35.09812,-3.37893,-1.08695,34.45069,-3.43154,-1.72894,34.38141,-2.79161,-1.50199,34.62757,-2.9684,-1.61161,33.5197,-3.30022,-1.75349,33.48984,-2.89307,-1.67042,33.34102,-3.16885,-1.622,33.69587,-2.98956,-1.52676,33.81913,-3.48851,-1.78144,33.87911,-2.5835,-1.67296,33.9579,-2.75416,-1.74032,34.08305,-2.69304,-1.93852,34.13463,-2.45911,-1.89814,34.20166,-2.62314,-1.96214,34.56202,-2.45397,-2.0372,34.47251,-2.27755,-2.08275,34.19967,-2.15876,-2.04318,34.02872,-2.23037,-2.09077,33.98268,-2.05564,-1.98398,33.7406,-2.1312,-2.13497,34.29191,-2.0434,-2.1131,34.3666,-2.12447,-1.53833,35.23633,-2.94172,-1.70424,35.52617,-2.69305,-1.81239,35.33192,-2.671,-1.87383,34.64897,-2.62273,-2.13591,34.51953,-2.12983,-2.03293,35.34096,-2.35235,-2.12357,34.94844,-2.23455,-1.72713,35.58029,-2.64516,-1.83978,35.42798,-2.48181,-3.50649,32.43138,-.05085,-3.2996,32.45637,.14535,-3.33481,32.70231,.12145,-3.22251,32.57334,.1949,-3.93552,34.45536,1.17524,-3.89484,34.45307,1.12171};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_5()
		{
			double[] value = {-4.26504,35.69303,-.22757,-4.1676,35.32513,.26683,-3.41508,36.77814,-2.16438,-3.82902,36.59985,-1.62774,-1.91483,36.11249,-2.71088,-2.06364,36.07445,-2.55202,-1.88405,35.73906,-2.46787,-1.77506,35.68528,-2.53123,-1.7333,35.85246,-2.7706,-1.82739,35.45801,-2.46558,-1.83387,35.54687,-2.43122,-1.84478,35.44038,-2.3564,-2.28884,34.91855,-2.16109,-2.29421,35.21894,-2.28299,-2.32182,35.65142,-2.39142,-1.99231,35.45517,-2.33993,-3.42418,34.81148,-1.62914,-3.50716,34.66654,-1.4056,-3.43866,34.58451,-1.45866,-3.32355,34.94928,-1.81034,-3.16216,35.22147,-2.02889,-3.25507,35.28895,-1.98847,-3.44048,35.02857,-1.72831,-3.4238,35.34961,-1.8824,-3.54546,35.32689,-1.73574,-3.5568,34.9524,-1.51997,-3.69077,35.20013,-1.45355,-3.72111,35.09353,-1.3407,-3.69586,34.77733,-1.15458,-3.5702,34.80108,-1.39565,-3.71977,34.87622,-1.18886,-3.85585,35.26413,-1.14863,-3.99019,35.59928,-.92056,-4.00683,35.42601,-.74938,-3.79275,33.96187,.58788,-3.89723,34.09709,.77769,-3.95451,34.10814,1.00352,-3.90059,34.34741,.73761,-3.87652,34.38905,.96177,-3.95015,34.13124,1.02978,-4.07135,35.16618,.51505,-3.98311,34.92082,.44726,-3.87993,34.3382,.61363,-3.90884,34.59446,.46656,-3.84877,34.30945,.47833,-3.9558,34.8523,.09174,-4.05638,35.22184,-.10473,-4.2117,35.98606,-.67877,-4.15439,35.62201,-.37718,-3.70534,34.14974,.09124,-3.58523,33.93358,-.00253,-3.65524,34.30295,-.40388,-3.74965,34.03369,.42816,-3.60271,33.73743,.32935,-3.44315,33.14045,.17614,-3.49624,33.39975,.25067,-3.47135,33.16483,.33674,-3.48172,33.06813,.50752,-3.45384,32.89856,.38471,-3.4139,33.41022,.02907,-3.01819,33.67177,-.85446,-3.01533,33.48109,-.666,-2.92566,33.47871,-.7877,-2.74849,33.49108,-1.01993,-2.62705,33.55406,-1.20487,-2.70666,33.70365,-1.24607,-2.73452,33.20303,-.7357,-2.61026,33.24519,-1.01301,-2.51286,33.30173,-1.23936,-2.38429,33.31513,-1.58494,-2.23963,33.46279,-1.90174,-2.23332,33.61422,-1.84607,-2.39522,33.48778,-1.55283,-2.40816,32.94663,-1.04132,-2.44204,33.11819,-1.3034,-2.53305,33.14489,-1.03246,-2.42094,33.73788,-1.53695,-2.68039,32.99137,-.51306,-2.47386,32.92716,-.73897,-3.13662,32.84132,-.00093,-2.90562,32.96185,-.25969,-3.19897,33.25787,-.24358,-2.95701,33.19371,-.45772,-3.3064,32.93465,.09349,-3.36689,33.36836,-.0277,-2.96479,32.41972,.34309,-2.84166,32.61491,.21303,-2.25898,32.37568,.15161,-2.4979,32.72724,-.15357,-2.70084,32.73359,.05321,-2.47711,32.34816,.36637,-2.57154,32.28404,.42452,-2.70631,32.10282,.50399,-2.40116,31.845,.53593,-2.27648,31.99723,.40579,-2.06858,32.17918,.20543,-2.23889,31.72733,.4919,-2.10933,31.86417,.40939,-1.79485,31.69371,.49213,-1.59709,31.45765,.63582};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_6()
		{
			double[] value = {-1.53678,31.61207,.61703,-1.88588,31.56658,.52672,-1.58451,31.92329,.26534,-1.93913,32.08607,.25722,-1.69836,31.80179,.40649,-1.81636,32.12026,.08827,-1.37651,31.80906,.41842,-1.20757,31.65693,.70587,-1.13088,31.69685,.59628,-1.4599,31.72648,.54032,-.95339,31.51793,.97982,-.9486,31.61145,.88816,-1.2796,31.52006,.75809,-.73481,31.54558,1.07328,-1.05059,31.31242,1.00811,-.58171,31.48402,1.1097,-.69644,31.22074,1.0436,-.86208,31.08805,.79269,-.76129,30.92097,.69765,-.30289,30.57057,.61112,-2.06124,29.06116,-1.33582,-2.35707,29.19655,-1.53378,-2.20938,28.99787,-1.61887,-2.36453,29.51989,-1.46149,-2.36688,29.34924,-1.49476,-2.0527,29.32267,-1.34833,-2.81581,29.87334,-1.71341,-2.80686,30.29435,-1.589,-2.87178,30.02219,-1.85195,-2.71721,30.10148,-1.52108,-2.82236,30.47221,-1.49585,-2.69613,30.30163,-1.45965,-2.61141,29.86469,-1.51073,-2.5968,30.18627,-1.44717,-1.85039,28.873,-1.44839,-2.00029,28.87887,-1.54847,-2.34951,29.05749,-1.93411,-2.20931,28.99236,-1.81795,-2.3814,29.08923,-1.73898,-2.47734,29.16899,-1.81701,-2.48117,29.26958,-1.6084,-2.60078,29.33803,-1.67035,-2.53135,29.48016,-1.53176,-2.78862,29.64946,-1.92817,-2.82355,29.85095,-2.12877,-2.67333,29.55739,-2.09852,-2.08686,28.93785,-1.62547,-1.97761,28.94919,-1.6783,-1.78735,29.0462,-1.75267,-2.55719,29.53964,-2.30225,-2.28326,29.24457,-2.19726,-2.57091,29.29938,-2.13787,-2.47175,29.18291,-2.06248,-2.87936,30.54835,-1.58663,-2.86078,30.44507,-1.65736,-2.8825,30.22411,-2.06491,-2.9389,30.47337,-1.98223,-2.75183,30.63567,-2.24545,-2.66676,30.34132,-2.44009,-2.65476,29.83729,-2.37909,-2.71134,31.14032,-2.15523,-2.47926,30.66017,-2.3885,-2.48546,30.17595,-2.43887,-2.34189,30.56523,-2.35093,-2.28524,30.2885,-2.31348,-2.26158,30.5456,-2.34148,-1.95972,31.36044,-2.67635,-2.0646,30.91736,-2.50938,-2.20384,30.75117,-2.40255,-2.19938,30.94046,-2.47299,-2.31968,30.7761,-2.40395,-2.00879,31.12295,-2.56616,-2.54098,31.21362,-2.29241,-1.98509,31.36936,-2.6698,-2.1918,31.6179,-2.5217,-2.47168,31.86531,-2.36773,-2.38559,32.16578,-2.28447,-2.65947,32.15417,-2.28193,-2.64924,33.03567,-2.15382,-2.60633,32.71487,-2.13592,-2.96319,33.08664,-2.1145,-2.85429,32.69837,-2.19715,-3.63873,34.36488,-1.43228,-3.55915,33.71151,-1.31946,-3.69009,33.76491,-1.13388,-3.43908,34.2953,-1.61952,-3.85658,34.39887,-1.14044,-3.77242,34.40303,-1.26883,-4.00792,34.34046,-.82865,-3.94893,34.37261,-.97492,-4.0303,34.00171,.09341,-4.02527,34.05448,.00858,-3.91192,33.67605,-.21935,-2.92597,30.782,-1.86499,-2.93465,30.61581,-1.90851,-2.83379,30.87667,-2.04502,-2.94088,32.07655,-2.23673,-3.00062,32.5662,-2.06053,-3.09547,33.22907,-1.9824,-3.07326,32.72607,-2.00676};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_7()
		{
			double[] value = {-3.23555,32.93152,-1.9039,-3.70505,33.41169,-.99059,-3.90969,33.75284,-.46845,-3.87841,33.78322,-.66556,-3.83802,33.39478,-.65374,-3.94129,33.59622,.0256,-3.22879,32.28145,-1.91569,-3.30045,31.85009,-2.05937,-3.48482,32.41218,-1.87519,-3.54153,32.67008,-1.63515,-3.40115,33.17903,-1.56686,-3.31433,33.06307,-1.75165,-3.5623,32.85107,-1.39067,-3.06036,31.0082,-1.90022,-2.85294,31.39088,-2.13052,-2.90489,31.06288,-2.00875,-3.14629,31.24757,-2.01138,-2.8451,31.71906,-2.24735,-3.21389,31.53501,-2.05607,-3.61067,31.98362,-1.86565,-3.67867,32.18208,-1.72832,-3.67156,33.03625,-1.05885,-3.72875,32.69925,-1.1215,-3.74168,32.79907,-.93939,-3.61919,32.9567,-1.23669,-3.74346,32.86937,-.76187,-3.71688,33.07649,-.93674,-3.73235,32.64631,-.07376,-3.78308,32.80501,-.36687,-3.78956,32.74239,-.25913,-3.8269,32.95294,-.44711,-3.32404,30.97668,-1.6338,-3.23614,30.98236,-1.74104,-3.19501,30.81276,-1.52265,-3.45106,31.19866,-1.73382,-3.53591,31.43696,-1.69402,-3.54125,31.39558,-1.74092,-3.45678,31.22597,-1.67598,-3.74271,32.05321,-1.57492,-3.79837,32.24141,-1.42585,-3.70198,32.3933,-1.51966,-3.86954,32.62645,-.74222,-3.86775,32.56457,-.74551,-3.81113,32.71722,-.37913,-3.11646,32.5188,-.29241,-3.46719,32.42897,-.10021,-2.88038,32.47584,-.95474,-3.34201,32.60192,-.85196,-3.3747,32.58649,-.91678,-3.04548,31.31508,-1.5689,-3.41275,31.2598,-1.65547,-3.28686,31.06972,-1.55278,-3.09483,31.47001,-1.66972,-2.84453,32.24696,-1.32929,-2.89626,32.27997,-1.37216,-2.61865,31.90486,-1.56411,-2.68718,31.98327,-1.53318,-2.8386,31.92602,-1.60014,-2.79299,31.81755,-1.60888,-2.46459,31.90678,-1.40097,-2.51184,31.99191,-1.42888,-2.51399,31.78674,-1.56953,-2.73592,32.08644,-1.48949,-2.54874,32.04668,-1.42529,-2.60707,32.15118,-1.40585,-2.79147,32.48607,-.86754,-2.84394,32.47663,-.95713,-2.65731,32.42733,-.95232,-2.35846,32.20388,-1.0706,-2.49662,32.29086,-1.15332,-2.46682,32.18315,-1.23803,-2.41857,32.08828,-1.23676,-2.64057,32.22212,-1.36171,-2.21562,31.90583,-.92265,-2.28658,32.12118,-.92086,-2.28761,32.06496,-.97358,-2.23927,31.99649,-.81181,-2.43524,31.65288,-1.46583,-2.60527,31.4568,-1.48532,-2.38398,31.58311,-1.35635,-2.34077,31.80536,-1.28826,-2.21661,31.81254,-1.04147,-2.23582,31.61908,-.95305,-2.28742,31.7891,-1.19851,-2.36362,32.17671,-.43636,-2.58529,31.62844,.48302,-2.84651,31.9877,.38331,-2.42099,31.86306,-.24926,-2.72057,32.02071,.02464,-2.54849,32.0849,-.2515,-2.59809,31.7189,-.02104,-2.31365,31.993,-.46393,-2.2993,31.87318,-.47637,-2.33459,31.76305,-.32702,-2.26595,31.5538,-.58071,-2.23884,31.48236,-.72117,-2.30078,31.25301,-.59188,-2.58255,31.35805,-1.37921,-2.77712,31.07081,-1.35291,-2.68992,31.0566,-1.2583};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_8()
		{
			double[] value = {-2.60929,31.05919,-1.15334,-2.51738,31.10292,-1.04508,-2.59636,31.0046,-.98464,-3.20273,30.88151,-1.41463,-2.89096,31.15671,-1.4736,-3.10893,30.76,-1.17267,-2.97246,30.66853,-1.38059,-2.96749,30.8668,-1.69841,-2.73754,30.46527,-1.37312,-2.79578,30.63424,-1.25428,-2.44689,31.06329,-.94156,-2.57822,30.96773,-.95376,-2.56335,30.89813,-.95749,-2.28326,31.21933,-.56436,-2.41698,31.42195,-.26399,-2.37721,31.32903,-.4361,-2.44286,31.57997,-.10973,-1.34122,31.36614,.77671,-1.3035,31.28178,.76927,-.96581,31.16715,.95306,-1.1616,31.09152,.5634,-2.75844,30.76457,-.96965,-2.51764,30.74931,-1.09195,-2.68512,30.67999,-1.18429,-1.75015,29.05633,-1.17984,-1.656,28.95994,-1.27096,-1.50804,29.05604,-1.12615,-1.10177,29.38378,-.56967,-1.33927,29.23072,-.88395,-1.01608,29.36594,-.64188,-1.27537,29.21524,-.8989,-.51774,29.90317,-.11534,-.88676,29.61057,-.25863,-.7182,29.6281,-.30835,-.70788,29.85677,-.04303,-.3011,30.14955,-.07054,-.42118,30.0888,.09325,-.15284,31.13412,.81233,-.25677,30.83095,.83181,-.17572,30.99448,.71196,-.19265,30.82974,.6313,-.25922,30.59584,.61806,-.2415,30.63841,.52053,-.13359,30.91201,.41984,-.16615,30.70783,.11365,-.11832,31.0046,.33876,-.07829,31.3036,.77842,-.13112,31.30626,.53752,-.15743,31.50468,.79846,-.10962,31.23079,.64406,-.57725,31.58841,.98265,-.36589,31.55841,.95398,-.50201,31.51245,.66499,-.69746,31.52888,.58782,-.84705,31.63067,.79383,-.63522,29.76788,-.48123,-.67883,29.64858,-.35803,-.47719,29.93789,-.15878,-1.10497,29.35284,-1.02605,-.84076,29.55735,-.72941,-1.23693,29.22292,-.944,-.97548,29.38292,-.69398,-2.046,29.26543,-2.15287,-2.13157,29.34912,-2.22992,-2.25718,29.77324,-2.47237,-2.39662,29.64697,-2.40853,-2.08898,30.59587,-2.11209,-2.10396,30.43631,-2.07335,-2.26795,29.99317,-2.34737,-2.11453,30.10893,-2.06159,-2.25917,29.77826,-2.46777,-2.27391,29.8028,-2.44049,-2.00008,29.50423,-2.19394,-1.67756,29.2481,-1.75949,-1.85392,29.34219,-1.98987,-2.53651,32.71355,-2.06079,-2.34575,32.1548,-2.21697,-2.42352,33.26089,-2.18301,-2.53702,33.05049,-2.0416,-1.73521,33.18813,-3.11835,-1.93183,33.25246,-2.89571,-1.75965,33.52953,-2.53027,-2.31535,33.33597,-1.99605,-2.23061,33.34955,-2.43173,-2.43765,32.91392,-1.38333,-2.35445,32.7326,-1.1273,-2.45364,33.13678,-1.70449,-2.48587,33.0472,-1.92782,-2.53681,32.69291,-1.97385,-2.42755,32.52145,-1.56263,-2.33823,32.04247,-1.77494,-2.37318,32.14012,-2.07047,-1.93056,31.34543,-2.44226,-2.22202,31.65563,-1.99176,-2.23969,31.49324,-1.68515,-2.28729,31.88193,-1.50173,-2.10924,30.96048,-2.0268,-2.06012,30.77131,-2.17354,-1.97663,31.04061,-2.32184,-2.29396,32.34705,-1.24002};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_9()
		{
			double[] value = {-2.17077,32.14662,-1.06516,-2.21104,31.64975,-1.28926,-2.20415,31.30042,-1.47369,-2.1743,30.84207,-1.65395,-2.14533,30.88484,-1.81405,-2.11782,30.38913,-1.92875,-.95248,30.91114,-.0186,-.61119,31.31539,.37825,-.50917,31.05592,.24763,-1.07859,31.60241,.37446,-1.11269,31.24754,.03813,-2.07137,32.33083,-.59047,-1.90542,32.22866,-.27066,-1.85835,31.91557,-.28831,-2.14662,32.52682,-.50059,-1.72219,31.81125,-.199,-1.52967,31.67074,-.05042,-1.63568,31.49402,-.07063,-2.2212,32.56965,-.87368,-2.09061,31.95844,-.86131,-2.03904,31.9815,-.63563,-2.08245,31.71507,-.64294,-2.08766,31.51232,-.84535,-.93483,30.68295,-.03449,-.98857,30.69778,-.07642,-.94067,30.50812,-.10231,-.98445,30.70347,-.09119,-.86286,30.54906,-.19989,-.90623,30.74298,-.09289,-1.42371,29.97465,-.7364,-1.39521,29.99805,-.87246,-1.25847,30.07335,-.52978,-1.82865,29.99147,-1.30157,-1.98573,30.08365,-1.23785,-1.81503,29.96449,-1.10439,-1.92243,30.09231,-1.32951,-1.71662,29.67712,-1.5753,-1.95443,29.82446,-1.8145,-1.91377,30.07637,-1.44127,-2.04748,30.37611,-1.3225,-2.08041,30.38306,-1.52009,-2.06994,31.02401,-.85922,-2.1233,31.18328,-.49415,-2.10687,30.98936,-.74043,-2.10644,31.27464,-.56765,-2.05696,31.44335,-.32412,-1.9026,31.53074,-.10484,-1.5279,31.2922,.49608,-1.61075,31.33515,.59071,-2.38174,31.29861,-.06027,-2.29399,31.22805,-.28601,-2.24353,31.23706,-.27033,-2.205,31.03553,-.72484,-2.25038,30.80608,-1.00885,-2.0556,30.03563,-1.22989,-2.33842,29.88805,-1.40045,-2.2287,29.7718,-1.35256,-1.54208,31.26408,.18329,-1.55771,31.26644,.32409,-1.79897,31.3366,.26143,-1.75683,31.40524,.10633,-1.96642,31.39804,-.02142,-1.99643,31.34702,.12751,-2.1175,31.30817,-.27453,-2.11707,30.78368,-1.02861,-1.84389,29.8676,-1.12275,-1.12288,30.9931,.26673,-1.24824,31.07462,.28269,-1.41448,35.6563,-3.4296,-1.74334,35.87663,-2.8358,-1.76923,36.07892,-3.05817,-2.41443,36.69247,-2.75412,-2.0288,36.55326,-2.9966,-2.23334,36.65041,-2.90861,-1.7257,35.98954,-3.0921,-1.37792,35.2848,-3.1622,-1.23478,35.19689,-3.28418,-.85802,30.43469,.01406,-.86281,30.59065,.13926,-1.67037,29.93845,-.98006,-1.6522,29.83429,-.98772,-2.08396,30.3718,-1.2629,-2.19252,30.33234,-1.27638,-1.68489,29.46654,-1.1081,-1.54251,29.48805,-.99746,-2.40808,30.24556,-1.34918,-1.83407,31.31148,.3283,-2.11837,31.34434,-1.06377,-2.1291,30.61526,-1.15969,-2.10962,30.6364,-1.22218,-1.21653,29.75179,-1.01927,-1.00427,29.85038,-.77791,-.84124,30.07294,-.53337,-1.07834,30.17251,-.31864,-.96679,30.34105,-.17745,-.98288,30.84869,-.0118,-2.10358,30.26698,-1.81564,-2.12142,30.40883,-1.79389,-1.3197,31.51461,.03841,-1.83765,32.11754,-.15633};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_10()
		{
			double[] value = {-.83902,30.29771,-.32165,-.6464,29.8144,-.50594,-.37827,30.32929,-.12272,-1.90201,31.10155,-2.50372,-2.30677,32.75637,-.78925,-2.0962,33.30101,-2.64769,-1.79496,33.38626,-2.78537,-.18636,30.7051,.08686,-.42784,30.71234,.05273,-1.60913,29.11119,-1.11563,-1.9165,29.03596,-1.27415,-2.45943,30.54619,-1.2255,-.74248,29.87842,-.04072,-.57574,30.14371,.18196,-.78159,30.03493,-.07443,-.67537,30.26582,.12382,-2.55318,31.38467,.05366,-.53857,30.11888,.17608,-2.78507,30.80069,-.96699,-2.96466,30.72565,-1.04239,-2.90479,30.69854,-1.10902,-3.07646,30.67351,-1.2274,-2.6389,30.49369,-1.29719,-2.35326,31.73646,-.31084,-3.19105,32.24882,.13369,-3.08699,32.30517,.23432,-2.27243,32.11356,-.74772,-2.23899,31.74137,-.66029,-2.25255,31.8011,-.60974,-2.69862,31.61234,-1.57799,-2.37405,31.85708,-1.36024,-2.37389,32.05768,-1.20515,-2.35314,32.029,-1.14965,-2.29131,32.1732,-.89083,-2.31708,32.23343,-.68855,-2.38901,32.30274,-.89675,-2.32821,32.22708,-.86739,-2.46696,32.3457,-.70959,-2.70195,32.35201,-1.20554,-2.68948,32.28779,-1.28592,-2.43745,32.32955,-.95011,-2.49176,32.33275,-1.03639,-2.49683,32.3192,-1.08725,-2.58666,32.42103,-.82937,-2.74873,32.46402,-.699,-2.69522,32.40291,-1.09367,-2.75424,31.70146,-1.59955,-2.86611,32.1598,-1.47221,-2.77088,32.15657,-1.43192,-2.76199,31.57071,-1.5599,-2.79149,31.67917,-1.59367,-3.26931,31.94839,-1.67054,-2.89557,32.04745,-1.55286,-3.31177,32.12382,-1.58532,-2.90083,32.1508,-1.4763,-3.20104,32.58338,-.42007,-2.7717,32.46905,-.68073,-2.90495,32.3688,-.12217,-3.80181,32.57764,-.44062,-3.70574,32.5092,-.23589,-3.86053,32.42422,-1.18378,-3.71515,32.58401,-1.28079,-3.81353,32.95097,-.50824,-3.81799,33.16784,-.70516,-3.76242,33.11698,-.81463,-3.5294,31.71219,-1.92315,-3.33658,31.18732,-1.8605,-3.42626,31.40981,-1.91379,-3.59496,33.32969,-1.26192,-3.49606,33.26793,-1.40845,-3.64982,33.3705,-1.12626,-3.4376,33.66561,-1.44962,-2.53162,31.7824,-2.2331,-2.74852,31.43584,-2.19213,-2.50225,31.45809,-2.19811,-3.16859,34.10365,-1.86721,-3.09581,34.02759,-1.94568,-3.34598,33.5724,-1.57335,-2.42162,31.55776,-2.40293,-1.90863,31.09113,-2.51461,-2.07415,29.0369,-1.89942,-1.91587,29.14475,-1.946,-2.586,29.29051,-1.93628,-2.69198,29.46009,-1.76758,-2.74448,29.73575,-1.62818,-2.64298,29.56361,-1.56083,-1.91621,32.17816,.00271,-1.73809,32.01664,-.07358,-2.12166,31.65282,.49752,-2.59536,34.13381,-1.59999,-2.55915,34.04545,-1.58508,-2.41131,34.34012,-1.82182,-2.25907,33.86123,-1.78727,-2.31191,34.08329,-1.77846,-2.33144,34.6891,-2.04582,-2.91678,34.06856,-1.37237,-2.96135,33.91402,-1.18793,-2.84233,33.96342,-1.31679,-3.42267,33.71671,-.22291,-3.11418,33.87486,-.94601};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_11()
		{
			double[] value = {-3.52012,33.58497,.19673,-3.68001,33.6764,.58826,-3.8164,34.40546,.15939,-3.90456,34.58873,.71573,-3.99159,35.02274,.74396,-3.88561,34.61683,.93511,-3.92112,34.83111,.97064,-3.90065,34.63927,1.10512,-2.60271,34.65766,-1.99941,-2.98639,34.67301,-1.87983,-2.66384,34.51244,-1.88127,-3.25743,34.37243,-1.45906,-3.12953,34.16941,-1.33139,-3.04314,34.18651,-1.40763,-3.44045,34.3932,-1.27202,-3.37761,34.37338,-1.32543,-3.58481,34.55516,-1.17182,-3.53616,34.47166,-1.19231,-3.66601,34.69185,-1.13621,-3.07436,35.09166,-2.03706,-3.25903,34.63943,-1.68675,-3.23422,34.78968,-1.80974,-3.23025,34.84339,-1.83627,-3.23884,34.71662,-1.75895,-2.81582,34.32769,-1.66749,-1.92693,35.34594,-2.35799,-1.90221,35.32425,-2.4271,-1.85756,35.37962,-2.50576,-1.84739,35.35868,-2.42954,-1.92592,35.43102,-2.34768,-1.72596,35.60384,-2.60278,-1.64995,35.73663,-2.80485,-1.63027,35.6581,-2.89666,-2.48729,36.48658,-2.59456,-2.96848,36.7383,-2.49581,-4.14144,36.339,-1.1248,-4.07718,36.29647,-1.11916,-4.17791,35.19261,.60089,-3.36995,32.40964,.09083,-2.1192,34.68864,-2.17732,-1.673,33.30331,-3.12758,-1.39692,34.09381,-3.37263,-1.68686,34.25192,-2.79879,-1.34434,34.46845,-3.1252,-1.25689,34.41872,-3.26909,-1.19775,34.70766,-3.22754,-1.35442,34.95998,-3.02835,-1.32848,34.8352,-3.07745,-1.26089,34.7858,-3.12552,-2.64812,33.78999,-2.72363,-1.2084,34.48886,-4.04876,-1.70631,34.82803,-3.95994,-1.57093,34.61219,-4.02204,-2.76322,36.18053,-2.88014,-3.1598,36.30789,-2.61032,-2.65223,36.48555,-2.97335,-4.19171,34.58865,-.06,-4.13375,34.42606,.25413,-4.31766,34.81432,.64524,-4.50196,35.06169,.25517,-4.11962,34.18594,.55056,-4.03878,33.88491,.26416,-4.22605,34.26512,.99334,-4.1563,34.14755,.96424,-4.39897,36.10331,-1.3686,-4.01299,36.63806,-1.76314,-4.3563,36.26908,-1.28143,-4.30516,34.66065,.86427,-4.23345,34.81319,.98559,-4.00241,33.17656,.21248,-3.95537,33.17471,.43603,-3.99206,33.33845,.2045,-3.91357,32.95598,.3728,-3.89012,32.97929,-.09047,-4.10623,34.39623,1.18591,-3.97391,34.13782,1.05931,-3.96276,34.43736,1.17925,-3.96258,34.10113,1.0031,-.83,31.17767,1.10242,-.95864,31.1738,1.06285,-.97377,31.25734,1.09034,-3.48534,36.8127,-2.37096,-1.05799,35.01837,-3.88325,-1.0625,34.97482,-3.66484,-2.48625,36.43815,-3.02989,-1.4224,35.64489,-3.93867,-1.54009,35.79607,-3.82932,-1.72156,35.50054,-3.85856,-1.33822,35.67742,-3.95537,-1.47248,35.81596,-3.81685,-1.21904,35.47058,-4.11148,-1.27654,35.4666,-4.11368,-2.02835,36.54384,-3.00439,-1.91829,36.43211,-3.25903,-1.58494,35.81618,-3.22917,-1.63027,35.72809,-2.90109,-1.62268,35.94154,-3.64893,-1.69946,35.89381,-3.64066,-1.04525,34.8467,-4.17255,-3.45797,31.47534,-1.67583};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_12()
		{
			double[] value = {-3.23825,30.84342,-1.45594,-3.33162,31.01785,-1.58032,-2.78876,30.84327,-.97848,-3.87018,32.54293,-.85678,-2.76092,32.46715,-.68838,-2.86326,31.91309,-1.59318,-2.85828,32.05721,-1.55312,-2.88107,32.05127,-1.55122,-2.88603,32.1525,-1.47555,-2.91457,32.27001,-1.36931,-2.36219,31.31942,-.44717,-4.38792,36.03899,-1.39147,-4.63134,35.74026,-.92949,-1.91206,35.99507,-3.50708,-1.8935,36.02821,-3.51999,-1.53086,33.82938,-3.68718,-1.5886,33.52907,-3.51541,-1.53929,33.78555,-3.66212,-4.15586,36.3407,-1.13262,-4.17143,36.33107,-1.15063,-3.97945,34.61894,1.15471,-.98167,34.52149,-3.73068,-.97804,30.8845,-.01897,-.17356,31.52223,.80761,-.16498,31.51076,.80817,-.17566,31.52007,.79521,-1.65097,29.14085,-1.12342,-1.65373,29.1133,-1.12299,-1.62536,29.15716,-1.10101,-1.46392,29.05677,-1.16776,-1.77156,34.33222,-2.74949,-1.7525,34.35653,-2.77323,-3.9491,34.45555,1.1895,-4.0865,35.04673,.82958,-4.32902,36.04636,-.66419,-2.39876,36.68761,-2.72049,-2.40079,36.68038,-2.71434,-2.88842,32.04935,-1.5506,-2.88862,32.0534,-1.54758,-2.88872,32.05543,-1.54606,-2.57902,31.36491,-1.38086,-2.31046,31.4687,-.53766,-2.31607,31.62586,-.44627,-1.10636,29.39935,-1.05101,-4.62005,35.67875,-.95738,-4.34702,35.8876,-1.36102,-3.22512,33.5621,-.4617,-2.2533,31.40341,-.88755,-4.59579,35.19542,-.421,-1.67771,34.85401,-4.01066,-1.15718,35.07138,-4.16654,-1.45504,29.66053,-1.32632,-2.12182,34.69026,-2.17307,-2.3506,31.74162,-.31604,-2.31881,31.62106,-.44088,-2.41724,31.86652,-.25512,-2.63238,32.36195,-.50922,-2.76585,32.46762,-.68427,-2.91436,32.4293,-1.08923,-2.93217,32.35681,-1.21812,-2.92166,32.26728,-1.36831,-2.89339,32.15075,-1.47481,-2.87041,31.91068,-1.59161,-2.87763,31.90898,-1.5937,-2.82767,31.79852,-1.60441,-2.82077,31.80114,-1.60242,-2.78454,31.68159,-1.59162,-2.75527,31.57412,-1.55841,-2.66314,31.4144,-1.46532,-2.66871,31.40896,-1.46579,-1.0867,35.0769,-4.15259,-1.09779,35.07793,-4.16302,-1.20802,35.47021,-4.10178,-1.15365,35.25428,-4.12409,-1.14342,35.25432,-4.11243,-1.45968,35.81674,-3.80547,-1.32659,35.67781,-3.94759,-1.73632,36.11819,-3.47532,-1.74968,36.11839,-3.48886,-1.60802,35.94211,-3.63647,-1.83987,36.27978,-3.38504,-1.82788,36.27966,-3.37235,-.84762,29.60307,-.75511,-.91855,29.63426,-.25634,-1.12943,29.41202,-.5615,-1.36694,29.26674,-.8753,-.14526,31.31353,.52356,-.14483,31.00983,.31304,-1.00259,34.74092,-3.67964,-3.88442,36.66461,-1.67281,-4.13864,34.17838,1.03067,-1.72301,35.07646,-4.00452,-1.69249,35.22032,-4.01017,-1.99447,36.1799,-3.42126,-2.45657,36.50025,-3.01459,-4.69354,35.4308,-.6406,-4.30788,34.62257,.80248,-4.26413,34.39884,.90954,-4.21341,34.29151,1.05775,-4.25954,34.43795,.96765};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_13()
		{
			double[] value = {-2.34571,31.74651,-.31964,-2.31338,31.46935,-.5291,-2.8138,31.8038,-1.60403,-2.77727,31.68343,-1.593,-2.74809,31.57653,-1.55967,-3.76445,32.55929,-.46752,-3.66564,32.49946,-.27815,-3.83055,32.55107,-.75376,-3.84704,32.40805,-1.16431,-3.77979,32.22477,-1.40611,-3.71726,32.03779,-1.55048,-2.95037,30.77645,-1.04151,-3.12778,30.70601,-1.18362,-2.10636,35.37272,-3.47633,-1.20305,35.24978,-4.13191,-2.19321,35.63371,-3.32391,-4.37257,35.08067,.60108,-4.47414,35.22594,.39356,-4.14402,34.57516,1.1486,-4.56912,35.94653,-.77467,-3.6912,32.97765,.49796,-4.14071,34.30193,.3994,-4.04033,34.18998,-.2901,-4.26035,34.73412,-.50338,-4.23679,34.81526,-.79432,-4.03994,34.27796,-.58408,-4.54331,35.27194,-.69645,-3.57843,36.03848,-2.15364,-4.0134,36.01018,-1.77556,-3.22662,35.92443,-2.43301,-2.8504,35.81576,-2.68184,-2.55866,35.6225,-2.88297,-2.34139,35.37495,-3.09448,-4.42098,35.35965,-1.01615,-3.94251,35.49049,-1.6673,-4.21972,35.44369,-1.34898,-3.59328,35.47338,-1.96657,-3.31016,35.38572,-2.23819,-3.01753,35.24925,-2.44787,-2.79116,35.09884,-2.62554,-2.21606,35.1459,-3.27818,-2.61622,34.93026,-2.78409,-2.49276,34.72021,-2.93564,-2.87235,34.48397,-2.41545,-2.78741,34.30973,-2.51442,-3.14763,34.73638,-2.15639,-3.0041,34.6332,-2.27877,-3.62827,34.92965,-1.72927,-3.37219,34.85715,-1.98829,-4.01986,34.92282,-1.25327,-3.86341,34.93607,-1.47274,-4.14135,34.8768,-1.03227,-3.2538,34.19101,-1.77702,-2.70108,34.06582,-2.64877,-3.04091,33.92151,-2.04718,-2.98097,33.75218,-2.15915,-2.89238,33.56166,-2.27882,-1.57601,34.8552,-2.8854,-1.59706,35.07773,-2.87347,-3.28198,34.16324,-1.18832,-3.30341,33.94614,-.79131,-3.39968,34.20934,-1.06357,-2.73603,35.93799,-2.37426,-3.38739,36.16145,-2.0573,-3.05862,36.12547,-2.29408,-3.69192,36.07554,-1.68455,-3.90522,35.80884,-1.25303,-3.3603,34.56975,-1.53363,-2.98583,34.90333,-2.00605,-3.08,34.50025,-1.69463,-2.96797,34.79058,-1.96674,-2.60211,35.07145,-2.2026,-2.73513,35.31934,-2.24199,-2.97406,35.5268,-2.21776,-3.18064,35.61395,-2.14057,-3.627,35.60555,-1.72989,-3.4262,35.64498,-1.98195,-3.79111,35.44563,-1.38275,-3.80736,34.76545,-.82278,-3.86326,34.97341,-.92883,-3.72357,34.60351,-.79421,-3.64383,34.43128,-.82999,-3.51886,34.27945,-.93496,-2.58485,34.86267,-2.12186,-3.88657,34.80177,-.36455,-3.96745,35.09607,-.50569,-3.77284,34.52035,-.3711,-3.4664,34.05658,-.58433,-2.28529,32.61568,-.38188,-2.04118,32.32269,-.11946,-1.52226,31.84104,.09434,-1.72723,29.20777,-1.17728,-2.49023,29.66123,-1.5011,-2.18417,29.12727,-2.05922,-3.19499,33.35891,-1.83366,-3.27734,33.47163,-1.68222,-3.28132,32.6263,-.63694,-2.82002,32.48823,-.85531,-3.3769,32.51526,-1.10437,-3.38131,32.4078,-1.28519};
			return value;
		}
		private double[] getroscoxae_Coord_7_19_point_14()
		{
			double[] value = {-2.92154,32.43113,-1.08851,-2.93955,32.3579,-1.21872,-3.34761,32.27227,-1.46359,-2.9291,32.26752,-1.36988,-3.22043,31.78531,-1.7049,-3.15363,31.62421,-1.69798,-2.31179,32.01294,-1.06364,-2.2238,31.67187,-.8191,-1.91847,31.38039,.45755,-.81065,30.76573,.40845,-.98415,30.93176,.48978,-.69264,30.50074,.27614,-1.96407,29.58204,-1.25058,-1.33028,29.53938,-.7982,-1.139,29.66776,-.56129,-.93256,29.84784,-.2863,-1.31064,31.70028,.2317,-2.14789,31.04008,-1.27254,-2.1457,30.7137,-1.43084,-1.64025,29.96064,-1.1327,-2.10627,30.8035,-1.07995,-2.24828,30.62418,-1.1663,-1.3909,29.84672,-.73551,-1.20439,29.91321,-.52841,-1.04204,30.06006,-.31248,-.90454,30.23215,-.14099,-.94127,30.81227,.21169,-2.65672,31.41845,-1.46712};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getsacrum_Geo_6_24_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,37,38,39,-1,37,40,38,-1,40,41,42,-1,42,43,40,-1,44,45,46,-1,42,41,47,-1,48,49,50,-1,50,51,52,-1,50,44,51,-1,53,54,55,-1,50,56,47,-1,57,58,37,-1,37,59,60,-1,60,57,37,-1,61,62,58,-1,62,63,64,-1,62,65,63,-1,66,67,68,-1,68,69,66,-1,70,71,72,-1,71,73,72,-1,74,75,76,-1,77,78,79,-1,79,80,77,-1,79,81,82,-1,82,80,79,-1,83,84,81,-1,83,85,84,-1,86,87,88,-1,87,89,88,-1,90,91,92,-1,92,93,90,-1,70,94,95,-1,70,96,94,-1,97,68,98,-1,69,99,100,-1,99,101,100,-1,66,102,103,-1,104,105,106,-1,106,107,104,-1,108,109,110,-1,108,111,109,-1,112,113,114,-1,112,115,113,-1,116,117,118,-1,116,119,117,-1,120,121,122,-1,123,124,125,-1,125,126,123,-1,127,128,122,-1,129,130,131,-1,129,132,130,-1,130,133,134,-1,133,135,134,-1,135,136,137,-1,138,139,136,-1,140,138,133,-1,133,141,140,-1,142,143,144,-1,142,145,143,-1,146,147,148,-1,148,149,146,-1,150,151,152,-1,153,154,155,-1,156,157,158,-1,159,160,161,-1,161,156,159,-1,162,163,164,-1,164,165,162,-1,166,167,168,-1,169,170,171,-1,172,1,0,-1,173,174,175,-1,176,177,178,-1,179,180,181,-1,182,183,184,-1,184,185,182,-1,186,187,188,-1,186,189,187,-1,182,190,191,-1,192,193,194,-1,192,195,193,-1,195,196,193,-1,195,197,196,-1,198,199,200,-1,201,202,203,-1,202,204,203,-1,205,206,207,-1,208,209,210,-1,208,211,209,-1,212,213,214,-1,215,216,217,-1,217,218,215,-1,219,217,220,-1,220,221,222,-1,220,223,221,-1,221,224,225,-1,225,226,221,-1,227,228,229,-1,230,231,232,-1,232,233,230,-1,170,234,235,-1,236,237,238,-1,238,233,236,-1,186,188,239,-1,240,241,242,-1,243,225,237,-1,244,236,245,-1,236,246,245,-1,240,247,248,-1,249,250,251,-1,252,253,254,-1,254,255,252,-1,255,256,252,-1,255,257,258,-1,255,259,260,-1,250,261,262,-1,250,249,261,-1,250,263,264,-1,250,262,263,-1,265,266,267,-1,261,268,269,-1,269,262,261,-1,188,270,271,-1,188,187,270,-1,272,273,274,-1,269,207,263,-1,263,262,269,-1,275,276,277,-1,275,268,276,-1,278,279,280,-1,279,281,280,-1,282,283,284,-1,282,285,283,-1,286,287,288,-1,289,36,35,-1,85,290,84,-1,134,291,292,-1,293,294,295,-1,295,296,293,-1,297,298,299,-1,299,300,297,-1,301,302,303,-1,303,304,301,-1,305,306,307,-1,306,308,307,-1,309,310,311,-1,310,312,311,-1,313,314,315,-1,313,316,314,-1,317,318,319,-1,317,320,318,-1,204,317,321,-1,322,323,324,-1,322,325,323,-1,326,327,328,-1,328,329,326,-1,330,331,332,-1,332,326,330,-1,333,334,335,-1,336,337,338,-1,339,340,341,-1,339,342,340,-1,343,344,345,-1,344,346,345,-1,346,347,348,-1,349,350,351,-1,351,352,349,-1,353,354,355,-1,356,357,358,-1,356,359,357,-1,360,361,362,-1,361,363,362,-1,364,365,366,-1,367,368,369,-1,367,365,368,-1,370,371,372,-1,372,369,370,-1,370,373,371,-1,374,375,376,-1,375,377,376,-1,378,375,379,-1,378,360,375,-1,380,381,382,-1,382,383,380,-1,384,381,385,-1,384,386,381,-1,387,388,389,-1,389,390,387,-1,351,391,392,-1,391,393,392,-1,394,395,396,-1,396,397,394,-1,398,399,400,-1,400,401,398,-1,402,403,404,-1,405,406,407,-1,405,408,406,-1,409,410,411,-1,411,412,409,-1,412,413,414,-1,411,415,354,-1,416,417,418,-1,389,419,420,-1,389,388,419,-1,420,421,422,-1,363,361,423,-1,361,424,423,-1,425,426,427,-1,428,429,430,-1,431,432,433,-1,433,434,431,-1,204,435,203,-1,204,321,435,-1,436,437,438,-1,439,440,441,-1,441,102,439,-1,442,443,444,-1,443,445,444,-1,446,447,448,-1,449,423,424,-1,449,450,423,-1,451,452,453,-1,454,455,423,-1,454,456,455,-1,457,458,459,-1,459,460,457,-1,461,462,463,-1,462,464,463,-1,406,465,466,-1,406,467,465,-1,406,468,467,-1,469,470,460,-1,470,457,460,-1,471,472,473,-1,473,474,471,-1,475,147,146,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_2()
		{
			int[] value = {476,477,478,-1,146,479,480,-1,480,475,146,-1,88,89,481,-1,89,75,481,-1,84,482,483,-1,484,485,477,-1,485,153,477,-1,485,486,154,-1,154,153,485,-1,478,487,488,-1,90,489,490,-1,491,478,492,-1,491,487,478,-1,87,86,493,-1,493,91,87,-1,492,153,155,-1,494,495,496,-1,494,482,495,-1,453,497,82,-1,82,483,453,-1,498,499,80,-1,499,77,80,-1,500,493,86,-1,92,91,493,-1,493,495,92,-1,420,501,421,-1,339,341,502,-1,502,503,339,-1,504,337,336,-1,336,505,504,-1,506,502,343,-1,502,507,343,-1,508,509,510,-1,510,511,508,-1,501,512,513,-1,388,372,371,-1,512,419,337,-1,419,338,337,-1,503,502,514,-1,502,515,514,-1,516,517,518,-1,519,444,520,-1,444,521,520,-1,451,494,522,-1,451,453,494,-1,523,524,525,-1,523,526,524,-1,527,499,498,-1,498,528,527,-1,529,518,499,-1,499,527,529,-1,530,531,532,-1,532,533,530,-1,533,534,535,-1,533,536,534,-1,532,537,538,-1,532,531,537,-1,539,540,541,-1,541,542,539,-1,543,544,545,-1,543,546,544,-1,547,548,549,-1,550,551,535,-1,552,553,554,-1,554,555,552,-1,556,557,558,-1,559,560,561,-1,560,562,561,-1,563,564,565,-1,566,567,568,-1,568,569,566,-1,570,571,140,-1,571,572,140,-1,573,141,565,-1,141,563,565,-1,141,132,563,-1,574,575,576,-1,575,439,576,-1,568,556,577,-1,215,125,124,-1,124,213,215,-1,113,123,119,-1,223,578,579,-1,580,581,582,-1,583,584,585,-1,583,586,584,-1,582,284,580,-1,284,283,580,-1,587,588,585,-1,589,590,591,-1,592,593,594,-1,593,595,594,-1,594,596,597,-1,594,595,596,-1,598,599,600,-1,601,602,231,-1,602,232,231,-1,602,234,232,-1,603,245,246,-1,246,170,603,-1,174,178,598,-1,598,604,174,-1,605,606,607,-1,605,608,606,-1,609,610,611,-1,172,606,608,-1,612,613,614,-1,614,609,612,-1,615,166,600,-1,601,465,616,-1,457,617,618,-1,619,230,228,-1,465,620,616,-1,465,463,620,-1,592,594,621,-1,622,623,335,-1,624,405,625,-1,333,623,626,-1,333,335,623,-1,365,416,368,-1,619,409,407,-1,359,627,357,-1,628,573,565,-1,629,630,631,-1,631,632,629,-1,254,253,633,-1,462,461,634,-1,461,635,634,-1,636,458,462,-1,636,459,458,-1,637,445,586,-1,637,638,445,-1,445,639,586,-1,640,641,642,-1,642,643,640,-1,644,645,646,-1,646,647,644,-1,648,649,650,-1,643,642,634,-1,634,651,643,-1,644,652,653,-1,644,654,652,-1,655,638,637,-1,656,657,655,-1,655,637,656,-1,658,659,646,-1,646,645,658,-1,658,653,660,-1,658,645,653,-1,661,461,463,-1,662,324,663,-1,664,665,666,-1,350,662,663,-1,667,664,668,-1,667,665,664,-1,322,324,662,-1,662,669,322,-1,670,318,671,-1,670,672,318,-1,349,673,350,-1,674,675,663,-1,676,400,677,-1,678,391,675,-1,675,679,678,-1,680,681,682,-1,682,683,680,-1,684,603,685,-1,603,169,685,-1,686,598,687,-1,686,599,598,-1,677,688,689,-1,690,691,692,-1,691,674,692,-1,693,694,695,-1,694,696,695,-1,697,698,699,-1,697,700,698,-1,701,702,703,-1,702,704,703,-1,696,705,706,-1,696,694,705,-1,707,708,709,-1,707,710,708,-1,711,712,713,-1,711,714,712,-1,715,680,699,-1,402,716,717,-1,718,692,719,-1,718,720,692,-1,689,721,717,-1,717,716,689,-1,708,722,588,-1,723,724,725,-1,725,726,723,-1,580,727,713,-1,713,712,580,-1,728,729,705,-1,729,706,705,-1,730,731,258,-1,248,732,258,-1,258,731,248,-1,260,259,733,-1,733,734,260,-1,673,669,350,-1,669,662,350,-1,200,436,198,-1,200,437,436,-1,735,736,433,-1,431,737,738,-1,431,434,737,-1,739,740,741,-1,742,743,744,-1,744,268,742,-1,744,743,741,-1,745,746,747,-1,745,748,746,-1,749,30,29,-1,600,171,750,-1,600,599,171,-1,751,272,752,-1,753,754,286,-1,753,27,755,-1,755,754,753,-1,756,28,757,-1,28,30,757,-1,758,580,283,-1,758,727,580,-1,285,759,760,-1,758,761,762,-1,758,763,761,-1,764,753,765,-1,764,766,753,-1,767,768,751,-1,767,769,768,-1,770,771,772,-1,771,773,772,-1,774,775,776,-1,774,777,775,-1,778,187,189,-1,189,185,778,-1,776,25,766,-1,776,289,25,-1,758,760,763,-1,194,771,770,-1,770,192,194,-1,779,780,781,-1,782,783,779,-1,780,54,784,-1,780,785,54,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_3()
		{
			int[] value = {786,54,785,-1,787,788,789,-1,789,781,787,-1,790,791,792,-1,790,793,791,-1,794,795,796,-1,794,797,795,-1,798,799,800,-1,799,801,802,-1,799,803,801,-1,804,805,806,-1,806,807,804,-1,794,808,809,-1,794,810,808,-1,811,812,813,-1,814,815,816,-1,814,817,815,-1,818,819,820,-1,821,822,823,-1,824,825,826,-1,827,828,829,-1,828,830,831,-1,828,832,830,-1,833,834,831,-1,835,836,837,-1,838,839,840,-1,841,842,843,-1,842,838,843,-1,844,845,833,-1,846,847,848,-1,846,849,847,-1,837,846,835,-1,846,824,835,-1,850,851,852,-1,853,854,847,-1,847,849,853,-1,855,856,473,-1,856,857,858,-1,806,805,859,-1,805,860,859,-1,861,862,863,-1,861,864,862,-1,865,866,867,-1,868,866,869,-1,870,871,872,-1,873,874,875,-1,873,876,874,-1,877,878,879,-1,880,881,882,-1,882,883,880,-1,883,884,885,-1,882,886,887,-1,882,881,886,-1,888,889,890,-1,890,891,888,-1,892,893,894,-1,894,895,892,-1,896,897,898,-1,897,899,900,-1,897,901,899,-1,902,903,904,-1,902,905,903,-1,906,903,907,-1,908,909,910,-1,908,911,909,-1,912,913,914,-1,912,915,913,-1,858,474,856,-1,916,917,918,-1,919,920,921,-1,105,922,923,-1,924,925,926,-1,927,928,929,-1,929,930,927,-1,930,906,907,-1,929,931,932,-1,931,933,934,-1,933,935,934,-1,934,936,937,-1,850,936,851,-1,938,939,940,-1,941,942,943,-1,942,944,943,-1,944,840,839,-1,944,942,840,-1,945,946,947,-1,946,906,947,-1,948,949,950,-1,951,952,953,-1,953,954,951,-1,955,956,957,-1,956,958,959,-1,956,955,958,-1,960,961,962,-1,961,963,962,-1,964,962,965,-1,964,960,962,-1,966,967,968,-1,966,969,967,-1,970,971,972,-1,970,973,971,-1,874,974,875,-1,974,975,875,-1,976,875,975,-1,975,977,976,-1,978,979,980,-1,978,981,979,-1,982,983,984,-1,983,985,984,-1,986,987,988,-1,872,989,990,-1,989,991,990,-1,992,993,994,-1,992,995,993,-1,993,996,997,-1,993,995,996,-1,998,999,1000,-1,998,1001,999,-1,1002,1003,1004,-1,1002,1005,1003,-1,1005,1006,1007,-1,1003,833,1008,-1,1003,1007,833,-1,1009,1010,1011,-1,1011,1012,1009,-1,1011,1013,1012,-1,1014,1015,1016,-1,1017,1018,1019,-1,1020,1003,1021,-1,1020,1004,1003,-1,939,1001,940,-1,1022,1023,1024,-1,1024,1025,1022,-1,1026,1023,1022,-1,1026,1027,1023,-1,1028,1029,1030,-1,1031,1032,823,-1,1033,977,975,-1,1033,1034,1035,-1,1035,1036,1033,-1,1037,1038,1039,-1,1038,1040,1039,-1,347,1041,1042,-1,347,1043,1041,-1,1044,1045,1046,-1,1044,1047,1045,-1,1048,1049,1050,-1,1049,1051,1050,-1,1052,1053,1054,-1,1055,1056,1053,-1,347,1057,1058,-1,1059,1050,1060,-1,1059,1048,1050,-1,1061,1062,1063,-1,1064,1065,1061,-1,383,1066,1067,-1,1067,1068,383,-1,1069,1070,1066,-1,1070,1071,1072,-1,1070,1069,1071,-1,1073,1074,1075,-1,1074,1076,1075,-1,1077,1078,1079,-1,1079,1080,1077,-1,1081,1082,1083,-1,1081,1084,1082,-1,1085,1086,1087,-1,1086,1088,1087,-1,1089,1090,1091,-1,1089,1092,1090,-1,1093,1094,1095,-1,1093,1072,1094,-1,1080,1096,1097,-1,1080,1098,1096,-1,1099,1100,1101,-1,1101,1102,1099,-1,1063,1103,1104,-1,1063,1062,1103,-1,1105,1106,1107,-1,1105,1108,1106,-1,1109,1110,1111,-1,1111,1112,1109,-1,1113,1114,1115,-1,1116,866,1117,-1,1118,1119,1056,-1,1118,1120,1119,-1,1121,1122,1123,-1,1123,1124,1121,-1,1125,1126,1127,-1,1128,1129,1130,-1,1130,1131,1128,-1,1132,1133,1134,-1,1134,1135,1132,-1,1034,1136,1137,-1,1138,1139,1140,-1,1140,1141,1138,-1,1142,1143,1144,-1,1142,1145,1143,-1,1146,1137,1147,-1,1147,1148,1146,-1,1149,1150,1151,-1,1151,1142,1149,-1,1152,1153,1154,-1,1153,1155,1154,-1,1156,1157,1158,-1,1159,56,1160,-1,56,1161,1160,-1,1159,47,56,-1,1162,1163,924,-1,1163,925,924,-1,1164,1165,1166,-1,1164,1167,1165,-1,1162,1168,1169,-1,1169,1170,1162,-1,1171,931,929,-1,1172,1173,1174,-1,1173,1172,1088,-1,1088,1101,1173,-1,1175,1176,1087,-1,1175,1177,1176,-1,1178,1177,1175,-1,1178,1179,1177,-1,1180,1181,1182,-1,1183,1184,1185,-1,1183,1158,1184,-1,928,927,1186,-1,1187,1188,1189,-1,1187,1165,1188,-1,917,916,1190,-1,916,1191,1190,-1,1180,1192,1193,-1,1193,1181,1180,-1,1157,1156,1194,-1,1156,1195,1194,-1,1196,1197,1198,-1,1199,1200,1141,-1,24,23,1201,-1,1202,1203,1204,-1,1204,1205,1202,-1,1206,1194,1195,-1,1206,1207,1194,-1,1208,1209,1210,-1,1209,1211,1210,-1,1212,1191,1213,-1,1214,1215,1190,-1,1215,1216,1190,-1,1217,1218,1219,-1,1219,1220,1217,-1,1221,21,20,-1,1222,1223,1224,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_4()
		{
			int[] value = {1222,1225,1223,-1,1226,1227,1228,-1,1228,1218,1226,-1,1217,1226,1218,-1,1217,1215,1226,-1,1214,1229,1230,-1,1214,1212,1229,-1,1231,1232,1233,-1,1231,1219,1232,-1,1220,1219,1231,-1,1231,1234,1220,-1,1235,1236,1237,-1,1235,1238,1236,-1,1239,1240,1241,-1,1239,1242,1240,-1,1208,1242,1243,-1,1208,1240,1242,-1,1165,1187,1166,-1,1244,1245,1180,-1,22,1246,23,-1,1196,1247,1248,-1,1196,1198,1247,-1,1249,1250,1251,-1,1251,1252,1249,-1,870,1253,1254,-1,870,872,1253,-1,978,1255,976,-1,976,981,978,-1,989,871,1256,-1,1257,1258,993,-1,993,997,1257,-1,1259,1260,1261,-1,999,1001,1262,-1,1263,942,941,-1,941,1264,1263,-1,1129,1265,1266,-1,1129,1267,1265,-1,1129,1128,1267,-1,1128,1268,1267,-1,802,807,1269,-1,1270,1271,1272,-1,1270,1273,1013,-1,1270,1272,1273,-1,810,1274,1275,-1,1276,791,797,-1,797,791,793,-1,793,795,797,-1,1277,1278,829,-1,938,1279,1280,-1,938,1281,1279,-1,1282,1283,1284,-1,939,938,1280,-1,1283,1285,1286,-1,1287,1288,1289,-1,1288,1290,1289,-1,1291,1292,1293,-1,1291,1294,1292,-1,1295,1296,1293,-1,1297,1298,1299,-1,1299,1300,1297,-1,1301,1302,953,-1,1302,954,953,-1,1303,986,971,-1,949,1298,1304,-1,963,961,1296,-1,961,1305,1296,-1,1306,1299,1301,-1,1299,1302,1301,-1,1283,1307,1284,-1,1281,1308,1309,-1,1309,1279,1281,-1,1310,958,955,-1,955,1311,1310,-1,1312,1313,1314,-1,1312,1308,1313,-1,1309,937,1279,-1,957,956,1315,-1,1293,1292,1295,-1,1316,1310,1312,-1,1310,1317,1312,-1,1317,1318,1312,-1,975,1136,1034,-1,1034,1033,975,-1,954,1302,949,-1,1319,946,945,-1,945,1320,1319,-1,1321,1320,1304,-1,1321,1319,1320,-1,1205,1204,1152,-1,1322,1323,1324,-1,1323,1325,1324,-1,1143,1145,1326,-1,1327,892,1328,-1,1327,1329,892,-1,1330,1331,893,-1,1332,899,901,-1,1332,1333,899,-1,899,1334,900,-1,899,1335,1334,-1,1336,921,1337,-1,1334,1338,900,-1,1334,1339,1338,-1,1340,1186,925,-1,858,1341,920,-1,858,857,1341,-1,857,856,1342,-1,1343,1344,1345,-1,1345,1346,1343,-1,1347,918,1348,-1,918,1349,1348,-1,1345,1341,1346,-1,1048,1059,1091,-1,1091,1350,1048,-1,1044,1076,1351,-1,1044,1352,1076,-1,1353,1244,1354,-1,1355,1356,935,-1,1355,1357,1356,-1,1358,1359,1360,-1,1361,1362,1363,-1,1364,1362,1365,-1,1199,1140,1366,-1,1199,1141,1140,-1,1204,1203,1367,-1,1368,1197,1196,-1,1368,1369,1197,-1,1210,1200,1199,-1,1199,1370,1210,-1,1211,1237,1371,-1,1237,1372,1371,-1,1373,21,1367,-1,1367,1203,1373,-1,1372,1205,1371,-1,1205,1374,1371,-1,1099,1375,1092,-1,1376,1099,1092,-1,1092,1089,1376,-1,1377,1378,1085,-1,1265,1267,1379,-1,788,1380,1381,-1,1380,1382,1381,-1,1383,1384,1385,-1,1384,1382,1385,-1,145,1386,1387,-1,437,1388,1389,-1,1388,1390,1389,-1,35,34,1391,-1,1392,1393,1394,-1,1394,1395,1392,-1,1396,1397,1398,-1,1397,1399,1398,-1,1388,277,1400,-1,1401,1402,1399,-1,1402,1398,1399,-1,742,1403,1404,-1,1404,1405,280,-1,1404,1403,1405,-1,1393,1406,1396,-1,1406,281,1396,-1,275,1407,269,-1,1408,1409,1410,-1,1410,1411,1408,-1,1412,1413,1414,-1,1414,1415,1412,-1,1414,1416,1415,-1,1417,1418,1419,-1,1417,1420,1418,-1,1421,1418,1420,-1,1420,1422,1421,-1,1423,1424,1425,-1,1423,1426,1424,-1,1427,1428,1429,-1,1428,1430,1429,-1,1431,1432,1433,-1,1431,1434,1432,-1,1435,1436,1437,-1,1438,1439,1440,-1,1438,1441,1439,-1,1442,1443,1444,-1,1442,1445,1443,-1,1442,1444,1446,-1,1447,1448,1449,-1,17,1450,1451,-1,1452,1453,1454,-1,1454,1455,1452,-1,1456,1457,1458,-1,1457,1459,1458,-1,1460,1461,1448,-1,1448,1462,1460,-1,1453,1463,1454,-1,1464,1465,1466,-1,1467,1468,1469,-1,1470,1471,1469,-1,1472,1467,1469,-1,13,1473,1474,-1,1475,1476,1477,-1,1476,1478,1477,-1,1475,1477,1479,-1,1480,1481,1482,-1,1483,1484,1485,-1,1483,1486,1484,-1,1487,1488,1484,-1,1489,1490,1491,-1,1489,1492,1490,-1,1493,1494,1495,-1,1493,1496,1494,-1,1497,1488,1498,-1,1499,1485,1484,-1,1486,1500,1494,-1,1486,1483,1500,-1,1501,1490,1495,-1,1480,1502,1503,-1,1480,1482,1502,-1,1504,1505,1506,-1,1504,1507,1505,-1,1508,1509,1333,-1,1333,1510,1508,-1,1507,1511,1505,-1,1512,1330,1513,-1,1332,1330,1514,-1,1330,1515,1514,-1,1516,1517,1518,-1,1519,1520,1521,-1,1519,1522,1520,-1,1523,1328,1524,-1,1525,1526,1527,-1,1527,1528,1525,-1,1529,1530,1531,-1,1532,1533,1534,-1,1533,1535,1534,-1,1536,1530,1537,-1,1536,1531,1530,-1,1538,1539,1540,-1,1536,1537,1541,-1,1542,1543,1544,-1,1545,1546,1547,-1,1548,1549,1550,-1,1550,1551,1548,-1,1552,1553,1554,-1,1555,1556,1542,-1,1555,1557,1556,-1,1558,1559,1560,-1,1549,1561,1550,-1,1562,1563,1564,-1,1565,1566,1567,-1,1567,1568,1565,-1,1569,1570,1571,-1,1570,1572,1571,-1,1541,1573,1574,-1,1573,1575,1574,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_5()
		{
			int[] value = {1576,1577,1578,-1,1576,1579,1577,-1,1580,1581,1582,-1,1581,1583,1582,-1,1584,1585,1586,-1,1587,1588,1589,-1,1588,1568,1589,-1,1563,1590,1591,-1,1563,1592,1590,-1,1593,1594,1595,-1,1596,1597,1598,-1,1598,1599,1596,-1,1600,1601,1602,-1,1600,1603,1601,-1,1602,1604,1605,-1,1602,1601,1604,-1,1606,1607,1608,-1,1609,1606,1610,-1,1609,1607,1606,-1,1611,1612,1613,-1,1614,1615,1616,-1,1617,1618,1619,-1,1620,1618,1621,-1,1621,1622,1620,-1,1547,1623,1624,-1,1547,1625,1623,-1,1626,1627,1628,-1,1626,1629,1627,-1,1630,1631,1632,-1,1633,1634,1635,-1,1636,1637,1638,-1,1639,1640,1641,-1,1642,1643,1644,-1,1645,1646,1632,-1,1645,1647,1637,-1,1635,1648,1649,-1,1650,1593,1651,-1,1651,1652,1650,-1,1653,1654,1655,-1,1656,1657,1658,-1,1659,1660,1661,-1,1659,1662,1660,-1,1663,1664,1665,-1,1666,1662,1659,-1,1666,1667,1662,-1,1668,1649,1669,-1,1649,1650,1669,-1,1670,1657,1671,-1,1670,1658,1657,-1,1672,1673,1674,-1,1673,1675,1674,-1,1676,1677,1678,-1,1679,1680,1681,-1,1679,1682,1680,-1,1683,1684,1685,-1,1684,1686,1685,-1,1687,1461,1683,-1,1687,1688,1461,-1,1689,1684,1460,-1,1460,1690,1689,-1,1691,1450,1692,-1,1691,1693,1450,-1,1694,1454,1463,-1,1694,1695,1454,-1,1696,1697,1698,-1,1696,1699,1697,-1,1700,1701,1702,-1,1700,1703,1701,-1,17,16,1704,-1,1704,1450,17,-1,1705,1456,18,-1,1706,1689,1707,-1,1706,1708,1689,-1,1709,1710,1711,-1,1709,1712,1710,-1,1713,1714,1715,-1,1713,1716,1714,-1,1689,1708,1684,-1,1708,1686,1684,-1,1706,1717,1718,-1,1706,1719,1717,-1,1692,1450,1704,-1,1704,1455,1692,-1,1720,1721,1459,-1,1453,1722,1723,-1,1724,1725,1465,-1,1465,1464,1724,-1,1678,1677,1726,-1,1726,1727,1678,-1,1728,1729,1711,-1,1711,13,1728,-1,1730,1731,1732,-1,1730,1733,1731,-1,1732,1734,1735,-1,1732,1731,1734,-1,1736,1737,1738,-1,1739,1435,1740,-1,1740,1741,1739,-1,1742,1743,1734,-1,1742,1744,1743,-1,1473,1745,1746,-1,1473,1747,1745,-1,13,1748,1473,-1,1748,1747,1473,-1,1496,1493,1498,-1,1493,1749,1498,-1,1750,1751,1752,-1,1753,1754,1755,-1,1755,1756,1753,-1,1757,1758,1759,-1,1760,1535,1761,-1,1760,1534,1535,-1,1762,1532,1721,-1,1763,1764,1765,-1,1763,1766,1764,-1,1767,1526,1768,-1,1767,1527,1526,-1,1769,1533,1770,-1,1533,1771,1770,-1,1772,1773,1774,-1,1774,1775,1772,-1,1776,1531,1536,-1,1776,1526,1531,-1,1777,1778,1779,-1,1777,1780,1778,-1,1772,1781,1782,-1,1772,1775,1781,-1,1447,1462,1448,-1,1783,1132,1784,-1,1784,1785,1783,-1,1530,1786,1537,-1,1530,1787,1786,-1,1788,1656,1789,-1,1790,1791,1792,-1,1790,1793,1791,-1,1794,1795,1657,-1,1794,1661,1795,-1,1660,1669,1796,-1,1660,1665,1669,-1,1797,1798,1667,-1,1797,1799,1798,-1,1653,1646,1800,-1,1801,1802,1803,-1,1441,1804,1738,-1,1738,1442,1441,-1,1445,1805,1676,-1,1676,1740,1445,-1,1806,1807,1808,-1,1806,1741,1807,-1,1809,1810,1806,-1,1806,1811,1809,-1,1812,1806,1808,-1,1812,1811,1806,-1,1813,1814,1735,-1,1813,1815,1814,-1,1816,1438,1817,-1,1438,1818,1817,-1,1819,1820,1821,-1,1809,1822,1823,-1,1823,1810,1809,-1,1824,1739,1825,-1,1739,1810,1825,-1,1826,1443,1827,-1,1826,1444,1443,-1,1828,1829,1830,-1,1828,1831,1829,-1,1821,1831,1819,-1,1832,1833,1834,-1,1835,1793,1836,-1,1835,1791,1793,-1,1837,1838,1839,-1,1839,1840,1837,-1,1841,1842,1799,-1,1843,1840,1844,-1,1845,1846,1847,-1,1844,1848,1849,-1,1849,1850,1844,-1,1851,1852,1853,-1,1853,1854,1851,-1,1855,1856,1857,-1,1858,1859,1539,-1,1858,1860,1859,-1,1861,1862,1787,-1,1862,1863,1787,-1,1585,1864,1586,-1,1865,1641,1640,-1,1639,1866,1640,-1,1867,1868,1869,-1,1569,1592,1570,-1,1592,1870,1570,-1,1871,1590,1588,-1,1871,1591,1590,-1,1872,1873,1874,-1,1872,1875,1873,-1,1563,1562,1876,-1,1875,1877,1873,-1,1877,1564,1873,-1,1878,1879,1880,-1,1881,1882,1883,-1,1881,1884,1882,-1,1885,1640,1866,-1,1586,1886,1865,-1,1865,1584,1586,-1,1584,1887,1888,-1,1887,1889,1888,-1,1610,1890,1891,-1,1610,1606,1890,-1,1616,1892,1893,-1,1892,1612,1893,-1,1894,1895,1896,-1,1894,1897,1895,-1,1894,1898,1899,-1,1629,1585,1627,-1,1629,1864,1585,-1,1864,1900,1586,-1,1900,1643,1901,-1,1900,1902,1643,-1,1903,1904,1644,-1,1645,1868,1867,-1,1867,1647,1645,-1,1863,1905,1906,-1,1863,1862,1905,-1,1907,1595,1905,-1,1907,1593,1595,-1,1908,1909,1910,-1,1908,1911,1909,-1,1909,1583,1912,-1,1913,1557,1914,-1,1913,1558,1557,-1,1870,1563,1876,-1,1870,1592,1563,-1,1915,1916,1572,-1,1915,1917,1916,-1,1544,1918,1554,-1,1554,1542,1544,-1,1919,1920,1921,-1,1919,1922,1920,-1,1909,1582,1583,-1,1919,1923,1911,-1,1919,1574,1923,-1,1924,1925,1919,-1,1926,1626,1625,-1,1625,1927,1926,-1,1546,1545,1548,-1,1545,1928,1548,-1,1929,1913,1914,-1,1929,1745,1913,-1,1930,1747,1748,-1,1930,1558,1913,-1,1930,1559,1558,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_6()
		{
			int[] value = {1931,1932,1930,-1,1933,1934,1935,-1,1933,1931,1934,-1,1748,13,15,-1,15,1936,1748,-1,1937,1933,1935,-1,1937,1938,1933,-1,1503,1939,1940,-1,1503,1502,1939,-1,1499,1941,1942,-1,1942,1943,1499,-1,1944,1945,1501,-1,1946,1507,1947,-1,1507,1940,1947,-1,1507,1504,1940,-1,1948,1938,1949,-1,1949,1950,1948,-1,1951,1952,1953,-1,1953,1954,1951,-1,1955,1956,1951,-1,1957,1958,1328,-1,1328,1523,1957,-1,1959,1522,1519,-1,1959,1960,1522,-1,1961,1962,1963,-1,1962,1950,1963,-1,1964,1965,1511,-1,1966,1962,1961,-1,1518,1521,1967,-1,1967,889,1518,-1,1968,1969,1970,-1,1970,1971,1968,-1,1968,1670,1671,-1,1968,1972,1670,-1,1973,1972,1974,-1,1973,1975,1972,-1,1976,1657,1795,-1,1977,1668,1669,-1,1634,1633,1800,-1,1632,1868,1645,-1,1857,1978,1942,-1,1856,1855,1979,-1,1980,1855,1857,-1,1981,1982,1983,-1,1983,1984,1981,-1,1985,1897,1899,-1,1899,1986,1985,-1,1987,1988,1895,-1,1989,1990,1988,-1,1991,1992,1986,-1,1993,1614,1991,-1,1994,1991,1600,-1,1995,1598,1605,-1,1995,1599,1598,-1,1996,1997,1998,-1,1996,1999,1997,-1,2000,2001,2002,-1,2002,2003,2000,-1,2004,2005,2006,-1,2006,2007,2004,-1,1619,2008,2009,-1,1622,2010,1620,-1,2010,2011,1620,-1,2012,2013,1995,-1,2012,2014,2013,-1,2013,1599,1995,-1,2015,2016,2017,-1,2015,2018,2016,-1,2019,2020,2021,-1,2022,2023,2024,-1,1753,2021,1754,-1,1753,2019,2021,-1,2025,2026,2016,-1,2027,1596,2013,-1,2028,1430,2029,-1,1430,1428,2029,-1,2030,2031,2032,-1,2030,2033,2031,-1,1410,1409,2034,-1,2035,12,11,-1,11,2036,2035,-1,2037,2038,2039,-1,2039,2040,2037,-1,2041,2040,2042,-1,2040,2039,2042,-1,2043,2044,2045,-1,2045,2046,2043,-1,2046,2047,4,-1,4,6,2046,-1,2043,6,2048,-1,2043,2046,6,-1,1423,2034,1426,-1,1423,2049,2034,-1,2050,2051,2052,-1,2053,2054,2055,-1,2055,2056,2053,-1,2055,2057,2056,-1,2056,2058,2053,-1,2054,2059,2060,-1,2059,2061,2060,-1,2062,2063,2064,-1,2064,2065,2062,-1,2054,2060,2055,-1,2066,2067,2068,-1,2067,2069,2068,-1,2070,2071,2072,-1,2073,2074,2075,-1,1417,2076,2077,-1,2077,1420,1417,-1,2078,2079,2080,-1,2081,2082,2083,-1,2084,2085,2030,-1,2085,2086,2030,-1,2087,2088,2079,-1,2087,2089,2088,-1,2090,2091,2092,-1,2089,2093,2094,-1,2089,2087,2093,-1,2095,2096,2097,-1,2095,2098,2096,-1,2099,2100,2101,-1,2101,2102,2099,-1,2100,2103,2101,-1,2100,2104,2103,-1,2105,2106,2107,-1,2106,2108,2107,-1,2109,2110,2111,-1,2047,2112,2113,-1,2112,2114,2113,-1,2115,2116,2117,-1,2117,2118,2115,-1,2119,2120,2121,-1,2121,2122,2119,-1,2123,2117,2116,-1,2124,2125,2126,-1,2126,2127,2124,-1,2128,2129,2130,-1,2130,2131,2128,-1,2110,2132,2133,-1,2133,2134,2110,-1,2135,2136,2137,-1,2138,2139,2122,-1,2139,2119,2122,-1,2140,2118,2117,-1,2117,2141,2140,-1,2138,2142,2143,-1,2138,2144,2142,-1,2145,2146,2147,-1,2145,2144,2146,-1,2148,2113,2114,-1,2114,2149,2148,-1,2141,2150,2140,-1,2150,2151,2140,-1,2138,2143,2139,-1,2143,2152,2139,-1,2046,2045,2153,-1,2153,2112,2046,-1,2112,2047,2046,-1,2154,2120,2123,-1,2155,2126,2135,-1,2111,2134,2156,-1,2157,2158,2159,-1,2157,2160,2161,-1,2162,2056,2163,-1,2162,2164,2056,-1,2155,2165,2166,-1,2166,2167,2155,-1,2127,2168,2131,-1,2127,2167,2168,-1,2169,2170,2171,-1,2171,2172,2169,-1,2173,2174,2175,-1,2111,2176,2177,-1,2177,2178,2111,-1,2110,2109,2179,-1,2180,2181,2182,-1,2183,2184,2185,-1,2186,2184,2187,-1,2186,2185,2184,-1,2181,2188,2189,-1,2181,2190,2188,-1,2191,2192,2193,-1,2188,2190,2194,-1,2195,2196,2197,-1,2198,2199,2200,-1,2199,2201,2200,-1,2202,2203,2204,-1,2195,2205,2206,-1,2205,2207,2206,-1,2198,2208,2199,-1,2209,2210,2211,-1,2212,2213,2214,-1,2215,2216,2217,-1,2215,2218,2216,-1,2219,2220,2221,-1,2222,2223,2224,-1,2225,2226,2227,-1,2227,2228,2225,-1,2229,2230,2231,-1,2232,2233,2234,-1,2235,2236,2237,-1,2237,2238,2235,-1,2239,2240,2241,-1,2241,2242,2239,-1,2209,2243,2244,-1,2244,2245,2209,-1,2246,2247,2248,-1,2247,2249,2248,-1,2250,2251,2252,-1,2250,2253,2251,-1,2254,2255,2240,-1,2240,2239,2254,-1,2256,2257,2258,-1,2259,2260,2261,-1,2262,2263,2264,-1,2265,2062,2065,-1,2065,2048,2265,-1,2266,2267,2268,-1,2268,2,2266,-1,2269,2262,2270,-1,2270,2250,2269,-1,2271,2272,2273,-1,2272,2274,2273,-1,2271,2264,2272,-1,2161,2275,2276,-1,2161,2277,2275,-1,2249,2278,2248,-1,589,2279,2280,-1,2279,2281,2280,-1,2251,2282,2252,-1,2251,2283,2282,-1,2280,2284,2285,-1,2280,2286,2284,-1,2287,2288,2289,-1,2287,2290,2288,-1,2291,5,4,-1,2292,2293,2294,-1,2295,2296,2297,-1,2295,2298,2296,-1,2299,2300,2301,-1,2299,2302,2300,-1,2303,2304,2305,-1,2306,2307,2308,-1,2308,2309,2306,-1,2309,2308,2310,-1,2311,2312,2313,-1,2313,2314,2311,-1,2315,2316,2317,-1,2315,2318,2316,-1,2319,2320,2321,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_7()
		{
			int[] value = {2321,2322,2319,-1,2323,2324,2325,-1,2324,2326,2325,-1,2315,2317,2327,-1,2327,2328,2315,-1,2329,2330,2331,-1,2330,2332,2331,-1,1434,2333,1432,-1,1434,2334,2333,-1,2335,2336,2337,-1,2336,2338,2337,-1,2339,2340,2341,-1,2341,2342,2339,-1,2338,2336,2343,-1,2344,2345,2346,-1,2347,2348,2349,-1,2349,2350,2347,-1,2351,2352,2353,-1,2351,2354,2352,-1,2355,2356,2357,-1,2355,2358,2356,-1,2359,2360,2361,-1,2360,2362,2361,-1,2363,2352,2357,-1,2363,2364,2352,-1,2365,2366,2367,-1,2367,2368,2365,-1,2369,2370,2371,-1,2370,2362,2371,-1,2372,2373,2350,-1,2350,2374,2372,-1,2375,2340,2376,-1,2375,2377,2340,-1,2363,2378,2364,-1,2378,2379,2364,-1,2380,2381,2382,-1,2382,2383,2380,-1,2382,2384,2385,-1,2384,2386,2385,-1,2387,2388,2389,-1,2387,2390,2388,-1,2391,2392,2393,-1,2391,2394,2392,-1,2395,2396,2397,-1,2398,2399,2400,-1,2401,2402,2403,-1,2399,2404,2405,-1,2399,2406,2404,-1,2404,2406,2407,-1,2406,2408,2407,-1,2409,2410,2411,-1,2409,508,2410,-1,2412,2413,2414,-1,2413,2415,2414,-1,2416,2417,2401,-1,2401,2403,2416,-1,2418,2419,2420,-1,2389,2421,2422,-1,2423,2424,2425,-1,2424,2426,2425,-1,2427,2428,2426,-1,2429,2430,2431,-1,2430,2432,2431,-1,2433,2434,2435,-1,2436,2437,2438,-1,2439,2435,2440,-1,2435,2434,2440,-1,2441,2437,2442,-1,2441,2438,2437,-1,2439,2440,2443,-1,2437,2444,2445,-1,2445,2442,2437,-1,2446,485,2447,-1,2448,485,2446,-1,2449,2432,2423,-1,2423,2450,2449,-1,2451,2452,2453,-1,2451,2454,2452,-1,480,2455,2436,-1,2455,2456,2457,-1,2457,2444,2455,-1,479,2458,2459,-1,2458,2460,2459,-1,2461,143,2462,-1,2463,2464,2242,-1,2463,2465,2464,-1,2213,2466,2214,-1,2381,2380,2467,-1,33,2204,2203,-1,2468,2469,2470,-1,2468,2471,2469,-1,2472,2473,2474,-1,2472,2475,2473,-1,2470,2469,2476,-1,2476,2477,2470,-1,2359,2478,2360,-1,2479,2360,2480,-1,2360,2478,2480,-1,2480,2481,2479,-1,1774,2482,2483,-1,1774,2484,2482,-1,2475,2472,2296,-1,2485,2486,2354,-1,2354,2351,2485,-1,2351,2487,2485,-1,2486,2355,2354,-1,2488,2097,2489,-1,2490,2491,2492,-1,2491,2493,2492,-1,2490,2494,2491,-1,2104,2495,2088,-1,2104,2100,2495,-1,2091,2496,2497,-1,2091,2498,2496,-1,2499,2500,2501,-1,2501,2502,2499,-1,2503,1792,1791,-1,1791,2504,2503,-1,2505,2506,2322,-1,2322,2324,2505,-1,2507,2508,2509,-1,2509,2510,2507,-1,2511,2413,2395,-1,2395,2512,2511,-1,2513,2514,2515,-1,2516,2513,2515,-1,2515,2517,2516,-1,2518,2405,2404,-1,2238,2237,2212,-1,2237,2519,2212,-1,2520,2521,2522,-1,2521,2523,2522,-1,2524,2466,2525,-1,2524,2214,2466,-1,2524,2526,2527,-1,2229,2231,2528,-1,2528,2529,2229,-1,2231,2530,2528,-1,2531,2532,2464,-1,2464,2533,2531,-1,2234,2534,2535,-1,2234,2465,2534,-1,2535,2536,2234,-1,2181,2155,2190,-1,2537,2507,2538,-1,2539,2540,2507,-1,2540,2538,2507,-1,2541,2542,2543,-1,2544,2545,2542,-1,2546,2547,2235,-1,2546,2548,2547,-1,2526,2549,2545,-1,2550,2551,2549,-1,2552,2553,2490,-1,1843,2554,2555,-1,2416,2414,2556,-1,2416,2403,2414,-1,2418,2557,2558,-1,2418,2559,2557,-1,2560,2561,2236,-1,2562,2232,2563,-1,2563,2564,2562,-1,2565,2230,2566,-1,2565,2552,2230,-1,2567,1843,2568,-1,2568,2569,2567,-1,2570,2416,2556,-1,2556,2571,2570,-1,2418,2558,2572,-1,2572,2573,2418,-1,2574,2575,2576,-1,2574,2577,2575,-1,2578,2579,2580,-1,2580,2581,2578,-1,2582,2581,2583,-1,2583,2584,2582,-1,2585,2586,2587,-1,2587,2588,2585,-1,2589,2282,2283,-1,2589,2590,2282,-1,2591,2106,2592,-1,2591,2593,2106,-1,2594,2595,2596,-1,2594,1408,2595,-1,2597,2598,2153,-1,2597,2040,2598,-1,2599,2600,2028,-1,2596,2595,2601,-1,2595,2602,2601,-1,2603,2042,2039,-1,2031,1427,2082,-1,2604,1422,2605,-1,2605,2606,2604,-1,2077,2607,2608,-1,2070,2072,2609,-1,2489,1417,2610,-1,2611,2612,2078,-1,2612,2613,2078,-1,2611,2614,2612,-1,1414,1417,1416,-1,1414,2610,1417,-1,1414,2615,2610,-1,2162,2616,2615,-1,2617,2618,2306,-1,2306,2309,2617,-1,2619,2620,2621,-1,2622,2108,2623,-1,2623,2619,2622,-1,2624,2625,2626,-1,2627,2619,2310,-1,2624,2628,2629,-1,2624,2630,2628,-1,2105,2629,2628,-1,2105,2107,2629,-1,2157,2631,2158,-1,2632,2633,2591,-1,2591,2592,2632,-1,2105,2634,2592,-1,2105,2635,2634,-1,2636,2616,2162,-1,2162,2637,2636,-1,2164,2058,2056,-1,2247,2277,2261,-1,2638,2639,2640,-1,2255,2641,2638,-1,2638,2240,2255,-1,2641,2642,2638,-1,2593,2591,2643,-1,2644,2645,2646,-1,2644,2647,2645,-1,2648,2649,2650,-1,2650,2651,2648,-1,2652,2653,2654,-1,2655,2656,2657,-1,2655,2658,2656,-1,2095,2078,2080,-1,2095,2488,2078,-1,2081,2659,2660,-1,2660,2661,2081,-1,2030,2662,2033,-1,2663,2664,2665,-1,2665,2666,2663,-1,2667,2668,2298,-1,2667,2669,2668,-1,2670,2671,2672,-1,2054,2672,2673,-1,2054,2053,2672,-1,2674,2675,2676,-1,2675,2677,2676,-1,2066,2678,2675,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_8()
		{
			int[] value = {2675,2067,2066,-1,2679,2268,2273,-1,2268,2267,2273,-1,2680,2057,2055,-1,2680,2160,2057,-1,2681,2260,2682,-1,2682,2263,2681,-1,2278,2257,2248,-1,2681,2683,2278,-1,2684,2683,2681,-1,2681,2263,2684,-1,2286,2280,2685,-1,2280,2281,2685,-1,2686,2687,2688,-1,2689,2690,2691,-1,2690,2441,2691,-1,2692,2693,2694,-1,2325,2692,2695,-1,2696,2697,2698,-1,2698,2699,2696,-1,2693,1434,2694,-1,2693,2334,1434,-1,2697,2700,2701,-1,2700,2702,2701,-1,2327,2703,2701,-1,2701,2320,2327,-1,2704,2705,2706,-1,2706,2303,2704,-1,2707,2315,2328,-1,2707,2708,2315,-1,2307,2706,2308,-1,2706,2709,2308,-1,2710,2711,2712,-1,2710,2713,2711,-1,2714,2715,2716,-1,2715,2717,2716,-1,2708,2318,2315,-1,2708,2718,2318,-1,2719,2720,2721,-1,2719,2722,2720,-1,2723,2724,2243,-1,2724,2725,2243,-1,2330,2329,2314,-1,2726,2727,2728,-1,2729,2730,2731,-1,2729,2732,2730,-1,2733,2332,2734,-1,2733,2735,2332,-1,2735,2331,2332,-1,2314,2736,2737,-1,2737,2330,2314,-1,2738,1939,2739,-1,1939,1943,2739,-1,2740,2741,2742,-1,2743,2744,2741,-1,2745,2746,2747,-1,2745,2724,2746,-1,2748,2725,2749,-1,2312,2750,2313,-1,2312,2751,2750,-1,2752,2751,2753,-1,2754,2755,2756,-1,2449,2450,2757,-1,2450,2758,2757,-1,2759,2760,2431,-1,2431,2761,2759,-1,2762,2763,2764,-1,2762,2765,2766,-1,2452,2767,2768,-1,2768,2769,2452,-1,2768,2770,2769,-1,2771,2772,2769,-1,2772,2453,2769,-1,2773,2771,2770,-1,2771,2769,2770,-1,2774,2775,2776,-1,2776,2777,2774,-1,2776,2778,2779,-1,2780,2762,2764,-1,2781,2782,2774,-1,2783,2784,2764,-1,1856,2020,2785,-1,2786,2787,2788,-1,2787,2789,2788,-1,2790,2791,2792,-1,2790,1751,2791,-1,2793,2791,2794,-1,2791,1751,2794,-1,2795,2792,2796,-1,2797,2798,2795,-1,2786,2020,2019,-1,2788,2784,2786,-1,2788,2782,2784,-1,2799,2730,2800,-1,2799,2018,2730,-1,2784,2785,2020,-1,2020,2786,2784,-1,2786,2019,2787,-1,2019,1753,2787,-1,2796,2801,2802,-1,1753,1756,2787,-1,2789,2792,2795,-1,2792,2791,2793,-1,2793,2796,2792,-1,2794,1751,1750,-1,2792,1756,2790,-1,2781,2784,2782,-1,2774,2782,2775,-1,2775,2803,2778,-1,2803,2804,2805,-1,2803,2806,2804,-1,2775,2778,2776,-1,2779,2750,2752,-1,2750,2751,2752,-1,2777,2807,2771,-1,2807,2772,2771,-1,2769,2453,2452,-1,2766,2763,2762,-1,2766,2808,2763,-1,2809,2810,2739,-1,2809,2811,2810,-1,2812,2759,2761,-1,2812,2810,2759,-1,2813,2814,2454,-1,2813,2428,2814,-1,2815,2816,2450,-1,2816,2817,2450,-1,2453,2772,2818,-1,2818,2819,2453,-1,2820,2821,2756,-1,2820,2807,2821,-1,2753,2754,2752,-1,2750,2804,2822,-1,2749,2724,2745,-1,2749,2725,2724,-1,2445,2742,2744,-1,2742,2741,2744,-1,1940,2823,1947,-1,2823,2824,1947,-1,2825,2698,2733,-1,2825,2699,2698,-1,2746,2724,2723,-1,2723,2258,2746,-1,2243,2826,2244,-1,2243,2725,2826,-1,2827,2755,2828,-1,2755,2829,2828,-1,2830,2722,2719,-1,2831,2715,2714,-1,2714,2832,2831,-1,2716,2713,2710,-1,2716,2717,2713,-1,2303,2305,2833,-1,2317,2834,2703,-1,2703,2327,2317,-1,2701,2703,2697,-1,2703,2835,2697,-1,2697,2696,2700,-1,2700,2334,2693,-1,2700,2696,2334,-1,2702,2700,2836,-1,2702,2321,2701,-1,2321,2320,2701,-1,2837,2462,143,-1,143,145,2837,-1,2459,2460,2456,-1,2460,2838,2456,-1,2457,2445,2444,-1,2689,2433,2839,-1,2686,2435,2439,-1,2840,2688,2590,-1,2840,2686,2688,-1,2841,2446,2447,-1,2841,2842,2446,-1,2260,2278,2249,-1,2260,2681,2278,-1,2843,2272,2264,-1,2160,2844,2161,-1,608,2,1,-1,2845,2268,2679,-1,2067,2846,2069,-1,2677,2675,2678,-1,2678,2847,2677,-1,2061,2068,2060,-1,2044,2673,2671,-1,2673,2672,2671,-1,2058,2848,2849,-1,2849,2053,2058,-1,2673,2059,2054,-1,2036,2029,2662,-1,2662,2035,2036,-1,2035,2662,2030,-1,2030,2086,2035,-1,2850,2081,2661,-1,2660,2659,2096,-1,2096,2578,2660,-1,2079,2078,2613,-1,2656,2851,2852,-1,2852,2657,2656,-1,2654,2653,2853,-1,2854,2855,2648,-1,2855,2649,2648,-1,2651,2856,2648,-1,2857,2647,2644,-1,2857,2856,2647,-1,2644,2646,2858,-1,2646,2643,2858,-1,2240,2638,2241,-1,2859,2640,2860,-1,2640,2275,2860,-1,2161,2259,2261,-1,2261,2277,2161,-1,2161,2844,2259,-1,2861,2639,2633,-1,2861,2640,2639,-1,2058,1415,2848,-1,2058,1412,1415,-1,2058,2164,1412,-1,2592,2634,2632,-1,2591,2633,2643,-1,2861,2862,2631,-1,2631,2276,2861,-1,2592,2106,2105,-1,2105,2628,2616,-1,2628,2615,2616,-1,2628,2863,2615,-1,2625,2627,2864,-1,2218,2865,2866,-1,2865,2867,2866,-1,2619,2623,2620,-1,2619,2621,2310,-1,2615,2863,2610,-1,2863,2868,2610,-1,2863,2614,2611,-1,2611,2868,2863,-1,2217,2869,2215,-1,2610,2488,2489,-1,2610,2868,2488,-1,2848,2870,2871,-1,2871,2849,2848,-1,2872,2071,2051,-1,2488,2611,2078,-1,2488,2868,2611,-1,2097,2606,2605,-1,2605,2489,2097,-1,2073,2075,2873,-1,2873,2874,2073,-1,2041,2875,2598,-1,2598,2040,2041,-1,2876,2052,2070,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_9()
		{
			int[] value = {1411,2600,2595,-1,2812,2761,2743,-1,2835,2877,2878,-1,293,2879,294,-1,293,2880,2879,-1,297,2881,298,-1,297,2882,2881,-1,302,2883,303,-1,2883,2884,303,-1,2085,2084,2885,-1,2084,2886,2885,-1,2887,2888,2889,-1,2888,2890,2889,-1,2573,2572,2891,-1,2891,2892,2573,-1,2580,2193,2893,-1,2580,2579,2193,-1,2578,2099,2579,-1,2192,2189,2188,-1,2188,2894,2192,-1,2565,2184,2552,-1,2565,2187,2184,-1,2895,2566,2896,-1,2895,2565,2566,-1,2897,2561,2560,-1,2420,2408,2898,-1,2899,2401,2417,-1,2417,2900,2899,-1,2556,2414,2415,-1,2415,2567,2556,-1,2567,2554,1843,-1,2182,2101,2180,-1,2101,2901,2180,-1,2231,2223,2530,-1,2902,2539,2903,-1,2902,2904,2539,-1,2550,2549,2526,-1,2526,2548,2546,-1,2526,2545,2548,-1,2547,2400,2405,-1,2547,2548,2400,-1,2405,2518,2547,-1,2905,2906,2540,-1,2905,2541,2906,-1,2907,2544,2905,-1,2905,2904,2907,-1,2538,2908,2537,-1,2538,2909,2908,-1,2910,2911,2912,-1,2912,2537,2910,-1,2399,2398,2422,-1,2398,2913,2422,-1,2171,2914,2172,-1,2171,2180,2914,-1,2175,2915,2173,-1,2175,2916,2915,-1,2177,2183,2178,-1,2183,2185,2178,-1,2109,2917,2179,-1,2234,2464,2465,-1,2234,2533,2464,-1,2532,2528,2918,-1,2532,2529,2528,-1,2529,2919,2229,-1,2528,2530,2920,-1,2527,2238,2524,-1,2519,2536,2535,-1,2519,2237,2536,-1,2422,2421,2406,-1,2406,2399,2422,-1,2421,2389,2388,-1,2902,2903,2467,-1,2467,2921,2902,-1,2545,2922,2542,-1,2545,2549,2922,-1,2923,2499,2502,-1,2501,2500,2220,-1,2924,2094,2925,-1,2924,2089,2094,-1,2578,2096,2098,-1,2098,2099,2578,-1,2032,2031,2082,-1,2926,2927,2928,-1,2926,2822,2927,-1,2297,2471,2208,-1,2471,2468,2208,-1,2347,2929,2348,-1,2930,2921,2467,-1,2467,2380,2930,-1,2931,2429,2346,-1,2245,2466,2209,-1,2245,2521,2466,-1,2932,2534,2465,-1,2254,2523,2521,-1,2521,2245,2254,-1,2933,2809,1978,-1,2809,1942,1978,-1,2455,2459,2456,-1,2438,2441,2690,-1,2459,480,479,-1,480,2459,2455,-1,2454,2814,2452,-1,2814,2767,2452,-1,2761,2431,2432,-1,484,2690,2689,-1,2689,485,484,-1,485,2839,2447,-1,485,2689,2839,-1,2441,2442,2934,-1,2816,2935,2936,-1,2937,2691,2441,-1,2441,2934,2937,-1,2428,2813,2425,-1,2813,2815,2425,-1,2691,2433,2689,-1,2386,2429,2760,-1,2429,2431,2760,-1,2938,2385,2808,-1,2808,2766,2938,-1,2426,2428,2425,-1,2450,2425,2815,-1,2450,2423,2425,-1,2421,2388,2516,-1,2401,2899,2402,-1,2899,2514,2402,-1,2418,2420,2898,-1,2898,2559,2418,-1,2412,2414,2403,-1,2403,2402,2412,-1,508,2939,509,-1,508,2409,2939,-1,2516,2517,2940,-1,2399,2405,2400,-1,2406,2940,2408,-1,2940,2898,2408,-1,2514,2513,2402,-1,2402,2513,2941,-1,2768,2942,2765,-1,2468,2470,2943,-1,2470,2944,2943,-1,2931,2339,2430,-1,2430,2429,2931,-1,2394,2389,2392,-1,2394,2387,2389,-1,2390,2945,2946,-1,2390,2387,2945,-1,2383,2385,2938,-1,2383,2382,2385,-1,2947,2938,2942,-1,2947,2383,2938,-1,2948,2949,2363,-1,2949,2378,2363,-1,2378,2335,2341,-1,2341,2379,2378,-1,2363,2357,2356,-1,2356,2948,2363,-1,2369,2365,2368,-1,2369,2372,2365,-1,2479,2371,2362,-1,2362,2360,2479,-1,2366,2950,2397,-1,2951,2335,2337,-1,2952,2396,2953,-1,2952,2367,2396,-1,2694,1434,1431,-1,2330,2737,2734,-1,2734,2332,2330,-1,2954,2955,2956,-1,2955,2957,2956,-1,2836,2693,2692,-1,2836,2700,2693,-1,2328,2958,2959,-1,2503,2323,2695,-1,2323,2325,2695,-1,2324,2322,2326,-1,2322,2321,2326,-1,2328,2327,2320,-1,2736,2314,2926,-1,2314,2313,2926,-1,2695,2692,2694,-1,2855,2716,2710,-1,2855,2853,2716,-1,2715,2827,2717,-1,2857,2960,2961,-1,2875,2288,2290,-1,2290,2962,2875,-1,2115,2962,2116,-1,2292,2963,2154,-1,2292,2964,2963,-1,2962,2115,2598,-1,2598,2875,2962,-1,2121,2963,2965,-1,2966,2663,2666,-1,2966,2967,2663,-1,589,2280,2285,-1,593,2253,2968,-1,593,592,2253,-1,2968,2253,2270,-1,2253,2250,2270,-1,2969,2274,2272,-1,2246,2860,2275,-1,2275,2247,2246,-1,2275,2277,2247,-1,2157,2276,2631,-1,2157,2161,2276,-1,2679,2274,2846,-1,2679,2273,2274,-1,608,2970,2266,-1,608,605,2970,-1,2971,2252,2282,-1,2,608,2266,-1,2269,2972,2684,-1,2269,2971,2972,-1,2682,2973,2843,-1,2246,2248,2974,-1,2245,2244,2975,-1,2242,2241,2859,-1,2974,2248,2257,-1,2257,2256,2974,-1,592,2251,2253,-1,2536,2561,2563,-1,2228,2227,2533,-1,2897,2564,2563,-1,2563,2561,2897,-1,2526,2546,2527,-1,2242,2464,2532,-1,2224,2976,2222,-1,2977,2958,2978,-1,2496,2979,2980,-1,2980,2491,2496,-1,2869,2613,2612,-1,2869,2217,2613,-1,2627,2981,2864,-1,2210,2982,2983,-1,2983,2984,2210,-1,2204,33,2985,-1,2292,2986,2208,-1,2205,2987,2988,-1,2205,2989,2987,-1,2195,2201,2196,-1,2195,2206,2201,-1,2990,8,2983,-1,2990,9,8,-1,2989,2982,2987,-1,2989,2991,2982,-1,2200,2293,2198,-1,2293,2200,2992,-1,2992,2294,2293,-1,2199,2993,2201,-1,2993,2196,2201,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_10()
		{
			int[] value = {2993,2994,2197,-1,2197,2196,2993,-1,2995,2256,2984,-1,2996,2181,2189,-1,2997,2998,2999,-1,2182,2181,2996,-1,3000,3001,2997,-1,2997,2999,3000,-1,2189,2192,2996,-1,2192,2191,2996,-1,3002,3003,2893,-1,2893,3004,3002,-1,2101,2182,2102,-1,2155,2181,2165,-1,2109,2111,2178,-1,2170,2166,2165,-1,2165,2171,2170,-1,2128,2131,3005,-1,2131,2168,3005,-1,2157,2159,2160,-1,2159,2057,2160,-1,2680,3006,2274,-1,2274,2969,2680,-1,2111,2110,2134,-1,2167,2127,2126,-1,2126,2155,2167,-1,2148,3007,2145,-1,3007,3008,2145,-1,2143,2129,2133,-1,2143,2142,2129,-1,3007,2125,2124,-1,3007,3009,2125,-1,2145,2147,2113,-1,2113,2148,2145,-1,2144,2122,2146,-1,2144,2138,2122,-1,2140,2114,2118,-1,2140,2149,2114,-1,2156,2129,2128,-1,2917,3010,2179,-1,2136,2135,2126,-1,2126,2125,2136,-1,2110,3010,2132,-1,2110,2179,3010,-1,2146,2965,2291,-1,2112,2115,2114,-1,2115,2118,2114,-1,4,2047,2147,-1,2047,2113,2147,-1,3011,2623,2593,-1,2593,2623,2108,-1,2108,2106,2593,-1,2310,2621,2309,-1,2621,2617,2309,-1,2191,2102,2182,-1,2182,2996,2191,-1,3012,2094,2093,-1,2886,2660,2582,-1,2886,2661,2660,-1,1420,2077,2608,-1,1417,2607,2076,-1,1417,2489,2607,-1,2607,2077,2076,-1,2637,2162,2163,-1,2163,3013,2637,-1,2062,2265,30,-1,3014,2062,749,-1,3014,2063,2062,-1,2969,2259,2844,-1,2969,2973,2259,-1,3015,3016,2872,-1,3017,2876,3018,-1,3017,3018,1426,-1,1426,2034,3017,-1,2265,757,30,-1,2265,3,757,-1,2112,2153,2598,-1,2598,2115,2112,-1,2040,2597,2037,-1,3019,2153,3020,-1,2153,2045,3020,-1,3021,2050,3017,-1,3017,3022,3021,-1,3023,3024,3025,-1,3024,3015,3025,-1,2603,2594,2596,-1,2603,3026,2594,-1,2670,2053,2849,-1,2670,2672,2053,-1,2594,3022,1409,-1,1409,1408,2594,-1,2153,3019,2597,-1,2029,2036,2028,-1,2036,2967,2028,-1,3027,3028,3029,-1,3027,3030,3028,-1,2023,2027,2024,-1,2025,2799,1750,-1,1750,3031,2025,-1,1752,3031,1750,-1,2017,2016,3032,-1,2016,2026,3032,-1,3033,3034,3035,-1,3034,3036,3035,-1,1620,2011,2008,-1,2006,3037,3038,-1,2006,2005,3037,-1,2003,2004,2000,-1,2003,3039,2004,-1,3040,1999,1996,-1,3040,3034,1999,-1,3041,2002,2001,-1,3042,3043,3044,-1,3044,3045,3042,-1,1599,2013,1596,-1,1605,1598,1602,-1,1600,1614,3046,-1,1600,1991,1614,-1,3028,3047,3048,-1,3049,3046,1614,-1,1614,1993,3050,-1,3050,1615,1614,-1,1986,1993,1991,-1,3051,1984,3052,-1,1989,1983,1990,-1,1988,1987,3053,-1,3053,1989,1988,-1,1985,1986,1992,-1,3054,1979,1855,-1,3054,3030,1979,-1,3030,3051,3028,-1,3030,1984,3051,-1,1982,1981,3055,-1,3056,1855,1980,-1,3056,3054,1855,-1,1856,1978,1857,-1,1857,1941,3057,-1,3038,3037,3058,-1,3058,3059,3038,-1,1646,1645,1800,-1,1636,1634,1800,-1,1668,1635,1649,-1,1593,1907,3060,-1,3060,1651,1593,-1,1658,1670,3061,-1,1974,1972,1971,-1,1972,1968,1971,-1,1968,3062,1969,-1,1974,1970,3063,-1,1974,1971,1970,-1,889,888,1518,-1,888,1516,1518,-1,1512,1958,3064,-1,1958,1957,3064,-1,1966,1960,1962,-1,1960,3065,1962,-1,1966,1961,1965,-1,1965,1964,1510,-1,1510,1514,1965,-1,1959,1956,1955,-1,1955,3066,1959,-1,1933,1938,1948,-1,1948,3067,1933,-1,1941,1857,1942,-1,3068,1492,1489,-1,1943,3069,1499,-1,1940,1504,1503,-1,1937,1935,3070,-1,1748,1934,1931,-1,1931,1930,1748,-1,1931,3071,1932,-1,1930,1913,1745,-1,1746,1745,1929,-1,1929,3072,1746,-1,1929,1547,1624,-1,1982,3055,1624,-1,3073,3074,1926,-1,1623,1628,1895,-1,1895,3075,1623,-1,1954,3076,1932,-1,1954,3077,3076,-1,1919,1925,1574,-1,1911,1582,1909,-1,1911,1923,1582,-1,1921,1467,1472,-1,1921,1560,1467,-1,1921,3078,1560,-1,3078,3079,1556,-1,1556,1560,3078,-1,1570,1870,1554,-1,1554,1918,1570,-1,1870,1552,1554,-1,1870,1876,1552,-1,1907,1905,3080,-1,1905,1862,3080,-1,1587,3081,3082,-1,1587,3083,3081,-1,1912,1583,1581,-1,1648,1635,1880,-1,1635,1638,1880,-1,3084,1904,1903,-1,3084,3085,1904,-1,1903,1902,1882,-1,1882,3084,1903,-1,1883,1900,1864,-1,1883,1864,1881,-1,1894,3086,1898,-1,1894,1889,3086,-1,1894,1899,1897,-1,1898,3087,1986,-1,1986,1899,1898,-1,3088,1611,1608,-1,1888,1585,1584,-1,1887,1640,1885,-1,3089,3090,1898,-1,1898,3086,3089,-1,1926,3074,1881,-1,1878,3091,3092,-1,1878,1884,3091,-1,1879,1878,3092,-1,3092,3093,1879,-1,1886,1901,3094,-1,1994,1598,1597,-1,1861,3080,1862,-1,1540,1861,1530,-1,1861,1787,1530,-1,1038,3095,1040,-1,3095,3096,1040,-1,2568,1844,1850,-1,2568,1843,1844,-1,3097,3098,3099,-1,3099,3100,3097,-1,1845,3101,1846,-1,1847,1846,3102,-1,1843,2555,1840,-1,1841,3103,1842,-1,3104,1841,1799,-1,2909,1836,1834,-1,2909,1835,1836,-1,1832,1834,3105,-1,1830,3106,3107,-1,1830,1829,3106,-1,3105,1743,1744,-1,1744,1832,3105,-1,3108,1439,1446,-1,1446,3109,3108,-1,1436,1435,1739,-1,1739,1824,1436,-1,1825,1823,3110,-1,1825,1810,1823,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_11()
		{
			int[] value = {1820,1819,3111,-1,3111,3112,1820,-1,1441,1438,1816,-1,1816,1804,1441,-1,1435,1437,3113,-1,3113,3114,1435,-1,1810,1739,1741,-1,1741,1806,1810,-1,1445,1738,1805,-1,1445,1442,1738,-1,3103,3115,3116,-1,3116,1842,3103,-1,3117,3118,3119,-1,3119,3120,3117,-1,3121,3122,3123,-1,3121,3107,3122,-1,3124,1655,3125,-1,3126,1653,1800,-1,1798,1663,1662,-1,1662,1667,1798,-1,1789,3127,1666,-1,1617,1793,1790,-1,1617,3128,1793,-1,3129,3130,3131,-1,1787,1863,1786,-1,1863,3132,1786,-1,1779,1768,3133,-1,1779,1778,1768,-1,3134,3135,3136,-1,3134,3137,3135,-1,1132,3138,1133,-1,1132,1783,3138,-1,1762,3139,1771,-1,1762,3140,3139,-1,1540,1539,1859,-1,1772,1724,1773,-1,1772,1449,1724,-1,1527,1767,1535,-1,1767,1761,1535,-1,1539,1538,3141,-1,1538,3142,3141,-1,3143,1768,1778,-1,3143,1767,1768,-1,1532,1762,1771,-1,1771,1533,1532,-1,1673,1672,1678,-1,2790,1756,1755,-1,1945,1944,1937,-1,1937,3070,1945,-1,1680,1498,3144,-1,3144,1681,1680,-1,1944,1500,3145,-1,1944,1501,1500,-1,1747,1930,1745,-1,1682,1679,1736,-1,1682,1736,1804,-1,1736,1738,1804,-1,3146,1816,1817,-1,3146,3147,1816,-1,1757,3147,3146,-1,1757,3148,3147,-1,1675,1728,1474,-1,1672,1808,1807,-1,1672,3149,1808,-1,1748,1936,1934,-1,3144,1749,3150,-1,1749,3151,3150,-1,3068,1489,1715,-1,1715,1714,3068,-1,13,1711,1710,-1,1710,14,13,-1,1728,1675,1729,-1,1675,3152,1729,-1,1673,1678,1727,-1,1727,3153,1673,-1,3154,1464,1466,-1,3155,1449,1448,-1,1760,3156,3157,-1,1459,1534,1458,-1,1459,1721,1534,-1,1691,1729,3152,-1,1691,3158,1729,-1,1684,1461,1460,-1,1684,1683,1461,-1,3159,3150,3151,-1,3159,3160,3150,-1,1716,3161,1714,-1,1712,1715,1710,-1,1712,1713,1715,-1,1694,1709,1695,-1,1709,3158,1695,-1,1708,3162,3163,-1,3163,1686,1708,-1,1703,1463,1701,-1,1703,1694,1463,-1,1716,1700,1699,-1,1716,1713,1700,-1,1693,3152,3153,-1,1693,1691,3152,-1,1695,1455,1454,-1,1695,1692,1455,-1,3158,1692,1695,-1,3158,1691,1692,-1,3160,3164,1687,-1,3160,3159,3164,-1,1687,1683,1685,-1,1685,3160,1687,-1,3144,1498,1749,-1,1474,1728,13,-1,1760,3157,3165,-1,3154,1723,1722,-1,1722,1464,3154,-1,1795,1661,1796,-1,1661,1660,1796,-1,1668,1977,1633,-1,1633,1635,1668,-1,3166,1905,1595,-1,3166,3167,1905,-1,1648,3168,1649,-1,1646,3169,1632,-1,1646,1653,3169,-1,1643,1903,1644,-1,1643,1902,1903,-1,3170,3171,1868,-1,1867,3172,3173,-1,1867,1869,3172,-1,1634,1638,1635,-1,1634,1636,1638,-1,1631,1868,1632,-1,1631,3170,1868,-1,1864,1629,1881,-1,1625,1628,1623,-1,1625,1626,1628,-1,1621,1792,3174,-1,1621,1790,1792,-1,1617,1790,1618,-1,1790,1621,1618,-1,2004,3039,2005,-1,3175,3176,3177,-1,3175,1608,1607,-1,1607,3176,3175,-1,3040,3178,3179,-1,1995,3033,2012,-1,3033,3180,2012,-1,3033,3035,3180,-1,1600,3046,1603,-1,1551,1927,3181,-1,1551,3073,1927,-1,1877,3182,1564,-1,1926,1927,3073,-1,1564,1563,1591,-1,1590,1565,1568,-1,1568,1588,1590,-1,3183,1917,3184,-1,3184,3185,3183,-1,3186,1917,1915,-1,3187,3188,3189,-1,3189,3132,3187,-1,1537,1573,1541,-1,1537,1786,1573,-1,1575,1580,1923,-1,1580,1582,1923,-1,3190,3191,1912,-1,1541,1574,1925,-1,1570,1918,1572,-1,1918,1915,1572,-1,1573,3189,1575,-1,3189,1580,1575,-1,1564,3182,1562,-1,1548,1551,1546,-1,1551,3181,1546,-1,1557,1560,1556,-1,1557,1558,1560,-1,1928,3192,1549,-1,1549,1548,1928,-1,1546,3181,1547,-1,1921,1920,3078,-1,1917,3186,3184,-1,1557,1555,1928,-1,1928,1914,1557,-1,1928,1545,1914,-1,3080,1540,1859,-1,3080,1861,1540,-1,1923,1574,1575,-1,1953,3077,1954,-1,1953,1924,3077,-1,1953,1536,1924,-1,1953,1776,1536,-1,1721,1532,1534,-1,1529,1531,1526,-1,1526,1525,1529,-1,1535,1528,1527,-1,1327,1328,1958,-1,1958,1329,1327,-1,1330,1512,1515,-1,1333,1332,1510,-1,1332,1514,1510,-1,1508,1964,1946,-1,1508,1510,1964,-1,1502,1482,3069,-1,1946,1964,1511,-1,1511,1507,1946,-1,15,3070,1936,-1,1941,1499,1484,-1,1484,3057,1941,-1,3057,1497,1857,-1,1492,1493,1490,-1,1493,1495,1490,-1,1486,1487,1484,-1,1436,3193,1437,-1,3193,3194,1437,-1,3097,1848,3109,-1,3109,1826,3097,-1,1473,3195,1474,-1,3196,3197,3198,-1,3197,3072,3198,-1,1759,1479,1477,-1,1471,1472,1469,-1,1468,1470,1469,-1,3155,1725,1724,-1,1724,1449,3155,-1,1534,3199,1458,-1,1702,3154,1466,-1,1466,1697,1702,-1,1461,1688,1448,-1,1688,3155,1448,-1,18,1456,3199,-1,1456,1458,3199,-1,1721,1720,1462,-1,1462,1447,1721,-1,1445,3114,1443,-1,1445,1740,3114,-1,1740,1435,3114,-1,1818,1438,1440,-1,3174,1622,1621,-1,2017,3200,3201,-1,3201,2015,2017,-1,2727,2726,3201,-1,2726,3202,3201,-1,145,1387,3203,-1,2083,2082,1427,-1,1427,1429,2083,-1,1411,3204,2600,-1,1421,1422,3205,-1,1422,3206,3205,-1,3207,3208,3209,-1,3209,1425,3207,-1,2083,2604,2606,-1,2049,1423,1425,-1,1425,3209,2049,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_12()
		{
			int[] value = {1417,1419,1416,-1,1419,2075,2074,-1,2074,1416,1419,-1,1418,1421,3208,-1,3208,2873,1418,-1,2097,2488,2095,-1,289,26,25,-1,289,35,26,-1,3210,3211,1403,-1,3211,239,1403,-1,1403,3212,3210,-1,239,1405,1403,-1,239,3213,1405,-1,739,742,1406,-1,742,1404,1406,-1,1406,1393,739,-1,1393,1392,739,-1,755,1401,3214,-1,1401,1399,3214,-1,3215,1389,3216,-1,1389,1390,3216,-1,557,3217,3218,-1,3218,558,557,-1,1089,1091,1059,-1,1102,3219,1375,-1,1375,1099,1102,-1,1102,1075,3219,-1,1374,1141,1200,-1,1207,3220,3221,-1,3222,1201,1232,-1,1201,1233,1232,-1,1373,1203,1202,-1,1202,1236,1373,-1,1210,1211,1200,-1,1211,1371,1200,-1,3222,1232,1228,-1,1198,1197,3223,-1,3224,1362,1364,-1,1365,1362,1361,-1,1363,1362,3224,-1,1245,1244,1353,-1,3225,3226,1359,-1,1359,3227,3225,-1,3226,1360,1359,-1,3228,1337,3229,-1,1345,3230,1341,-1,1345,3231,3230,-1,1346,1341,3232,-1,918,917,1349,-1,917,3233,1349,-1,1342,1166,3232,-1,920,1341,3230,-1,3231,1344,1169,-1,3231,1345,1344,-1,1170,1348,1349,-1,3228,922,1336,-1,1336,1337,3228,-1,923,3234,3235,-1,3235,1339,923,-1,1509,1335,1333,-1,1335,899,1333,-1,1339,3235,1338,-1,893,1513,1330,-1,1330,1332,901,-1,901,1331,1330,-1,891,890,3236,-1,3237,1521,1520,-1,1520,3238,3237,-1,3239,1524,1328,-1,1323,1145,1325,-1,1323,1326,1145,-1,1322,1324,1035,-1,1153,1152,1204,-1,1204,1143,1153,-1,1324,1297,1035,-1,1324,1304,1297,-1,1146,1034,1137,-1,1304,1298,1297,-1,3240,3241,3242,-1,1318,937,1309,-1,1281,3243,1313,-1,1313,1308,1281,-1,965,962,3244,-1,1316,3240,958,-1,958,1310,1316,-1,1311,955,3224,-1,1313,3243,3245,-1,1307,1283,1286,-1,1289,1290,969,-1,1290,967,969,-1,3246,3247,1305,-1,1305,961,3246,-1,1299,1298,1302,-1,1298,949,1302,-1,987,1301,988,-1,1301,953,988,-1,1300,1299,1306,-1,1306,3248,1300,-1,1015,3249,1016,-1,1288,983,1290,-1,983,3250,1290,-1,873,1255,3251,-1,819,823,1032,-1,819,818,823,-1,1278,822,3252,-1,1278,1277,822,-1,3252,821,3253,-1,3252,822,821,-1,1012,1013,1273,-1,3254,3255,1012,-1,1012,1273,3254,-1,1010,3256,3257,-1,828,3258,832,-1,1128,3259,1268,-1,798,1267,1268,-1,798,1379,1267,-1,937,936,942,-1,942,1263,937,-1,1264,941,3260,-1,3260,1262,1264,-1,3261,3262,3263,-1,1253,872,869,-1,868,990,3264,-1,3265,3266,1019,-1,3267,1258,1257,-1,867,3262,865,-1,867,3264,3268,-1,872,871,989,-1,3269,876,873,-1,3269,3270,876,-1,1117,1115,3271,-1,1123,1249,1252,-1,1123,3272,1249,-1,1124,3273,3274,-1,1122,3272,1123,-1,1122,1126,3272,-1,871,870,3275,-1,3275,3269,871,-1,1156,1182,1181,-1,1156,1158,1182,-1,3276,1157,3277,-1,1172,1174,1164,-1,1174,1167,1164,-1,1209,1208,1243,-1,1243,1225,1209,-1,1240,1208,1210,-1,1210,1370,1240,-1,1238,1373,1236,-1,1238,3278,1373,-1,1209,1235,1211,-1,1235,1237,1211,-1,1234,1231,3279,-1,3279,1206,1234,-1,1217,1192,3280,-1,1217,1220,1192,-1,1219,1228,1232,-1,1219,1218,1228,-1,1229,3281,1369,-1,1229,3282,3281,-1,1226,1368,1227,-1,1226,1230,1368,-1,20,3283,1221,-1,20,3279,3283,-1,1373,3278,21,-1,1222,1238,1235,-1,1222,3284,1238,-1,1217,3280,1216,-1,1216,1215,1217,-1,1235,1209,1225,-1,1225,1222,1235,-1,1207,3285,1194,-1,1207,3286,3285,-1,3279,1231,3283,-1,1231,1233,3283,-1,1372,1202,1205,-1,3222,1248,1247,-1,1140,3223,1366,-1,1140,1198,3223,-1,1180,3280,1192,-1,1180,1245,3280,-1,3287,3288,3289,-1,3287,3290,3288,-1,3289,1095,1094,-1,3289,3288,1095,-1,1173,1101,3291,-1,1089,1097,1376,-1,1097,1096,1376,-1,3292,1094,1072,-1,1072,1071,3292,-1,1353,933,931,-1,931,1171,1353,-1,928,1245,1353,-1,1353,1171,928,-1,1340,3293,1245,-1,54,786,55,-1,42,1159,3294,-1,42,47,1159,-1,1179,1358,3295,-1,1154,1205,1152,-1,1145,1151,1325,-1,1145,1142,1151,-1,1153,3296,1155,-1,3296,3297,1155,-1,1138,3298,1139,-1,1138,3299,3298,-1,1321,1304,1324,-1,1324,1325,1321,-1,3300,3301,1150,-1,3300,3302,3301,-1,1138,3303,3304,-1,3304,3299,1138,-1,1374,1200,1371,-1,1132,1135,1784,-1,1135,3305,1784,-1,1374,3306,3303,-1,1374,3307,3306,-1,3303,1141,1374,-1,3303,1138,1141,-1,1036,1035,1300,-1,1035,1297,1300,-1,3308,1125,3309,-1,3310,3311,1250,-1,1250,1249,3310,-1,1252,1251,3275,-1,3275,3273,1252,-1,3312,1122,1121,-1,1121,1065,3312,-1,1117,866,865,-1,3313,3314,3315,-1,1086,1101,1088,-1,1086,1102,1101,-1,1099,1376,1100,-1,1376,3276,1100,-1,1098,1185,1184,-1,1184,1096,1098,-1,3316,1098,1080,-1,3316,3317,1098,-1,3317,3318,1098,-1,3318,1185,1098,-1,1093,1095,3319,-1,3319,3320,1093,-1,1085,1087,1176,-1,1176,1377,1085,-1,1083,3321,1081,-1,3322,3316,1079,-1,3316,1080,1079,-1,1097,1060,1080,-1,1060,1077,1080,-1,1352,3323,1375,-1,1375,3219,1352,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_13()
		{
			int[] value = {3324,3325,3326,-1,3324,3327,3325,-1,3321,1083,3324,-1,1069,1066,3328,-1,3329,3330,3331,-1,3329,1057,3330,-1,1061,1065,1062,-1,347,1042,1057,-1,1052,1055,1053,-1,1042,3332,1351,-1,1042,1041,3332,-1,3333,3334,3335,-1,3334,3336,3335,-1,847,856,855,-1,3337,1137,1136,-1,3337,3338,1137,-1,977,1033,3339,-1,1033,1036,3339,-1,1016,3249,999,-1,3340,1019,3266,-1,3341,1258,3342,-1,3341,994,1258,-1,3265,1019,3343,-1,3344,3345,1260,-1,3346,3246,961,-1,961,960,3346,-1,3347,1288,1287,-1,1287,1285,3347,-1,980,979,3348,-1,3348,3349,980,-1,1286,964,1307,-1,1282,3349,1283,-1,3349,3348,1283,-1,1022,991,1026,-1,1025,998,996,-1,1025,1001,998,-1,1018,3343,1019,-1,3249,3340,1028,-1,3249,1015,3340,-1,1017,1014,1002,-1,1017,1015,1014,-1,3255,3350,1009,-1,1009,1012,3255,-1,1005,1007,1003,-1,999,1262,1016,-1,1262,3260,1016,-1,999,3249,1000,-1,993,1258,994,-1,867,3344,1260,-1,867,3268,3344,-1,977,3339,976,-1,3339,3351,976,-1,875,976,1255,-1,1255,873,875,-1,3352,3353,952,-1,952,951,3352,-1,988,952,972,-1,932,1317,1310,-1,1310,1311,932,-1,960,964,1286,-1,1286,3346,960,-1,3241,962,963,-1,3241,3240,962,-1,948,957,1315,-1,1315,3354,948,-1,952,988,953,-1,948,951,954,-1,954,949,948,-1,950,1320,948,-1,1320,957,948,-1,1320,945,957,-1,943,839,842,-1,943,944,839,-1,939,1263,1264,-1,939,1280,1263,-1,1318,1309,1308,-1,1308,1312,1318,-1,936,850,942,-1,850,840,942,-1,934,1317,932,-1,932,931,934,-1,929,928,1171,-1,3355,929,1311,-1,929,932,1311,-1,930,929,906,-1,930,926,927,-1,930,908,926,-1,928,1340,1245,-1,928,1186,1340,-1,924,926,908,-1,908,910,924,-1,922,105,3356,-1,3356,1336,922,-1,920,474,858,-1,920,919,474,-1,1162,1170,1163,-1,1334,106,1339,-1,923,106,105,-1,923,1339,106,-1,910,915,912,-1,910,909,915,-1,903,3357,904,-1,895,1328,892,-1,895,3239,1328,-1,902,3237,3238,-1,3238,3358,902,-1,3359,898,915,-1,898,913,915,-1,900,1338,897,-1,896,898,3359,-1,1521,890,1967,-1,890,889,1967,-1,3360,3361,3362,-1,3362,3363,3360,-1,883,887,884,-1,883,882,887,-1,883,3364,879,-1,879,880,883,-1,3365,1250,3311,-1,1254,3275,870,-1,869,866,1253,-1,3262,867,1260,-1,856,474,473,-1,853,1358,854,-1,853,1359,1358,-1,855,848,847,-1,854,856,847,-1,852,840,850,-1,852,837,840,-1,1006,833,1007,-1,1006,844,833,-1,841,943,842,-1,838,842,839,-1,834,833,845,-1,831,834,828,-1,1031,1277,834,-1,812,3366,813,-1,3366,3367,813,-1,802,801,807,-1,801,804,807,-1,3259,803,799,-1,3368,1379,800,-1,1379,798,800,-1,796,795,3369,-1,3369,3370,796,-1,820,792,818,-1,1380,788,787,-1,787,3371,1380,-1,43,3372,38,-1,1161,783,782,-1,42,3294,3372,-1,3372,43,42,-1,780,787,781,-1,779,820,819,-1,771,194,3215,-1,3215,3216,771,-1,3373,196,438,-1,196,436,438,-1,1402,27,26,-1,12,3374,10,-1,759,3375,3376,-1,759,285,3375,-1,285,3377,3375,-1,285,282,3377,-1,3378,762,183,-1,3378,3379,762,-1,728,3379,729,-1,3379,3380,729,-1,1401,755,27,-1,27,1402,1401,-1,765,288,273,-1,3381,190,189,-1,189,685,3381,-1,189,3382,685,-1,189,186,3382,-1,191,190,179,-1,190,180,179,-1,29,3383,3384,-1,29,3385,3383,-1,190,3381,180,-1,176,181,177,-1,176,3386,181,-1,287,3387,274,-1,278,280,1405,-1,742,741,743,-1,742,739,741,-1,207,3388,205,-1,200,1388,437,-1,306,305,197,-1,305,196,197,-1,434,205,737,-1,434,3389,205,-1,3390,738,3391,-1,3390,431,738,-1,3392,3393,3394,-1,3389,433,736,-1,3389,434,433,-1,1407,275,203,-1,203,435,1407,-1,3395,349,3391,-1,3391,738,3395,-1,247,3396,248,-1,248,3396,732,-1,676,677,689,-1,727,705,713,-1,727,728,705,-1,726,581,723,-1,720,3397,692,-1,3397,690,692,-1,680,683,699,-1,683,3398,699,-1,689,698,721,-1,689,688,698,-1,719,3399,718,-1,702,709,724,-1,702,707,709,-1,704,723,712,-1,712,714,704,-1,710,700,697,-1,710,707,700,-1,710,706,708,-1,710,696,706,-1,694,713,705,-1,694,711,713,-1,703,704,3400,-1,704,714,3400,-1,700,707,701,-1,707,702,701,-1,762,3379,758,-1,3379,727,758,-1,3379,728,727,-1,584,726,725,-1,674,719,692,-1,677,715,688,-1,603,684,3401,-1,603,170,169,-1,3402,747,3382,-1,3402,745,747,-1,674,679,675,-1,674,691,679,-1,690,683,682,-1,682,691,690,-1,3403,391,678,-1,3403,393,391,-1,395,394,3404,-1,677,400,3405,-1,400,399,3405,-1,689,716,676,-1,351,350,663,-1,398,401,328,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_14()
		{
			int[] value = {3406,663,323,-1,663,324,323,-1,669,319,322,-1,323,3407,3406,-1,644,653,645,-1,638,655,646,-1,646,659,638,-1,656,3408,657,-1,3408,3409,657,-1,3410,31,3411,-1,643,3412,654,-1,643,651,3412,-1,640,654,644,-1,640,643,654,-1,640,644,3413,-1,644,647,3413,-1,638,659,445,-1,458,464,462,-1,3414,3415,636,-1,3416,265,3417,-1,3416,266,265,-1,3418,3419,429,-1,627,359,355,-1,3420,625,3421,-1,3420,624,625,-1,413,353,3422,-1,3423,408,3424,-1,3425,3426,3427,-1,3425,418,3426,-1,3428,619,227,-1,619,228,227,-1,458,457,3429,-1,457,618,3429,-1,601,616,163,-1,163,602,601,-1,597,611,621,-1,621,594,597,-1,3430,470,3428,-1,3428,227,3430,-1,463,111,620,-1,750,235,162,-1,3431,167,3432,-1,29,28,3385,-1,28,3433,3385,-1,606,175,3434,-1,606,172,175,-1,3431,612,596,-1,612,597,596,-1,3435,596,3436,-1,607,3436,596,-1,596,595,607,-1,168,3435,598,-1,3435,604,598,-1,3435,168,167,-1,170,246,232,-1,232,234,170,-1,163,616,164,-1,2279,589,591,-1,591,2281,2279,-1,621,611,610,-1,610,3437,621,-1,591,590,3438,-1,3438,2286,591,-1,3439,3440,3441,-1,3439,3442,3440,-1,756,729,3380,-1,756,3443,729,-1,586,656,637,-1,3444,443,3445,-1,3444,3446,443,-1,3447,2301,3448,-1,3447,2299,2301,-1,127,122,3449,-1,3450,733,3451,-1,733,3452,3451,-1,733,259,3452,-1,3453,574,100,-1,574,576,100,-1,3454,129,3455,-1,3455,101,3454,-1,3456,140,141,-1,3456,570,140,-1,571,566,572,-1,566,569,572,-1,3454,132,129,-1,3454,563,132,-1,560,3457,562,-1,560,3458,3457,-1,3459,535,3460,-1,535,551,3460,-1,522,534,3461,-1,522,3462,534,-1,3460,3463,3459,-1,3464,452,3465,-1,447,446,3466,-1,446,3467,3466,-1,3468,3469,3470,-1,3470,3471,3468,-1,3472,3473,537,-1,3473,538,537,-1,3474,3475,544,-1,544,546,3474,-1,532,538,3470,-1,3470,3476,532,-1,541,555,547,-1,541,540,555,-1,3477,539,545,-1,545,544,3477,-1,542,3467,3478,-1,542,3479,3467,-1,3480,3481,3461,-1,3480,3482,3481,-1,533,532,536,-1,532,3476,536,-1,3483,498,497,-1,3483,528,498,-1,526,422,421,-1,526,523,422,-1,3484,548,554,-1,387,372,388,-1,341,507,502,-1,388,371,3485,-1,3485,419,388,-1,419,3485,3486,-1,3486,338,419,-1,511,3487,2410,-1,2410,508,511,-1,506,343,345,-1,345,3488,506,-1,3489,341,340,-1,3489,507,341,-1,505,336,3490,-1,422,389,420,-1,496,495,493,-1,493,500,496,-1,3491,500,86,-1,494,453,483,-1,483,482,494,-1,155,158,3492,-1,2436,476,3493,-1,158,157,3494,-1,3494,3492,158,-1,478,488,3493,-1,3493,476,478,-1,157,3495,3494,-1,3493,152,151,-1,3493,488,152,-1,3496,486,485,-1,2448,3496,485,-1,3497,495,482,-1,3497,92,495,-1,3498,76,75,-1,75,89,3498,-1,3499,3500,3501,-1,3499,3502,3500,-1,480,2436,475,-1,475,150,147,-1,475,151,150,-1,479,146,149,-1,149,2458,479,-1,2461,144,143,-1,466,619,407,-1,407,406,466,-1,636,3415,459,-1,454,423,450,-1,33,3411,31,-1,442,519,3503,-1,442,444,519,-1,3504,3505,3506,-1,3504,3507,3505,-1,519,3508,3503,-1,519,3509,3508,-1,3509,3474,546,-1,546,3510,3509,-1,3510,3508,3509,-1,3510,543,3511,-1,543,3512,3511,-1,3510,546,543,-1,3513,3514,3515,-1,3513,3298,3514,-1,3504,3445,3507,-1,3516,3517,3518,-1,3516,3471,3473,-1,269,268,275,-1,3519,356,358,-1,3395,737,3520,-1,3395,738,737,-1,3394,3521,630,-1,630,3522,3394,-1,631,630,3519,-1,630,3521,3519,-1,427,428,430,-1,427,426,428,-1,567,3523,1266,-1,567,3524,3523,-1,3525,570,3526,-1,3525,571,570,-1,627,3527,430,-1,3528,3529,425,-1,3528,3530,3529,-1,3531,390,422,-1,390,389,422,-1,3532,3533,3534,-1,3532,3535,3533,-1,514,3536,503,-1,514,501,3536,-1,501,513,3536,-1,373,3485,371,-1,3426,418,3414,-1,3414,3537,3426,-1,460,3538,469,-1,460,3539,3538,-1,417,3540,459,-1,459,3415,417,-1,417,416,365,-1,412,411,354,-1,3541,407,409,-1,3541,405,407,-1,406,622,468,-1,622,3542,468,-1,406,408,622,-1,663,3406,674,-1,3543,378,390,-1,378,387,390,-1,381,380,3535,-1,374,3529,3530,-1,379,3530,367,-1,368,3425,370,-1,370,369,368,-1,365,367,366,-1,364,366,3544,-1,327,356,3545,-1,347,1058,348,-1,345,348,3546,-1,345,346,348,-1,3489,344,343,-1,343,507,3489,-1,504,3547,3548,-1,504,505,3547,-1,334,3427,335,-1,3549,623,3423,-1,3549,626,623,-1,327,326,3422,-1,326,332,3422,-1,3550,326,329,-1,3550,3551,326,-1,346,1043,347,-1,346,3552,1043,-1,3489,3553,344,-1,3489,3554,3553,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_15()
		{
			int[] value = {505,315,3547,-1,505,313,315,-1,3555,3556,3557,-1,3555,3558,3556,-1,322,3559,325,-1,322,672,3559,-1,204,320,317,-1,204,3560,320,-1,3561,3562,3560,-1,3561,3563,3562,-1,3564,2587,3565,-1,3564,2588,2587,-1,3566,3437,610,-1,610,160,3566,-1,776,775,36,-1,36,289,776,-1,760,758,283,-1,283,285,760,-1,773,771,34,-1,36,775,3567,-1,775,3568,3567,-1,777,3375,3377,-1,438,437,1389,-1,1392,1400,276,-1,1400,277,276,-1,741,740,744,-1,287,3569,3387,-1,268,261,742,-1,263,3570,264,-1,261,1403,742,-1,261,3212,1403,-1,261,249,3212,-1,745,249,3571,-1,734,3450,3572,-1,734,733,3450,-1,255,260,257,-1,732,256,258,-1,256,255,258,-1,3573,3574,252,-1,254,259,255,-1,251,264,3575,-1,251,250,264,-1,3396,247,3576,-1,247,251,3576,-1,603,3401,245,-1,247,240,242,-1,242,3577,247,-1,3578,745,3571,-1,3578,748,745,-1,3402,3382,186,-1,602,235,234,-1,233,238,229,-1,3579,3580,229,-1,3580,3581,115,-1,3580,579,3581,-1,221,3579,224,-1,221,223,3579,-1,731,225,243,-1,222,226,3582,-1,222,221,226,-1,3583,212,214,-1,1407,3388,207,-1,207,269,1407,-1,200,202,201,-1,200,199,202,-1,196,3373,193,-1,195,3584,197,-1,195,12,3584,-1,3585,2665,2664,-1,3585,3586,2665,-1,2669,3444,2668,-1,2669,3587,3444,-1,778,185,184,-1,190,182,185,-1,185,189,190,-1,3588,2847,3014,-1,3014,3384,3588,-1,3589,2676,2677,-1,2677,3590,3589,-1,3386,3590,3588,-1,3386,176,3590,-1,175,604,3434,-1,175,174,604,-1,686,3381,685,-1,685,169,686,-1,162,165,615,-1,165,3432,615,-1,164,616,620,-1,165,164,3591,-1,613,165,3591,-1,613,3432,165,-1,591,2286,2685,-1,2685,2281,591,-1,160,159,3566,-1,159,3592,3566,-1,156,161,3593,-1,477,492,478,-1,477,153,492,-1,107,1386,3594,-1,107,106,1386,-1,577,556,3595,-1,569,568,577,-1,137,3596,135,-1,137,3597,3596,-1,3595,556,558,-1,558,3598,3595,-1,136,135,138,-1,135,133,138,-1,130,141,133,-1,130,132,141,-1,3599,3600,3601,-1,3599,127,3600,-1,3602,563,3454,-1,3454,3603,3602,-1,126,3604,3605,-1,126,125,3604,-1,113,3606,123,-1,3606,124,123,-1,99,3603,101,-1,3603,3454,101,-1,120,3607,3608,-1,120,3609,3607,-1,110,109,3429,-1,3429,3610,110,-1,3458,560,574,-1,1383,3611,1384,-1,3612,3613,3614,-1,3612,3615,3613,-1,559,3616,575,-1,3616,3617,575,-1,3618,561,562,-1,562,3619,3618,-1,3619,562,3457,-1,575,574,559,-1,574,560,559,-1,3620,3621,3622,-1,290,3622,3623,-1,3624,3625,108,-1,108,110,3624,-1,3626,3627,3610,-1,66,576,439,-1,439,102,66,-1,100,576,66,-1,66,69,100,-1,68,97,69,-1,98,94,116,-1,89,87,490,-1,490,3498,89,-1,92,3497,3628,-1,3497,3629,3628,-1,81,483,82,-1,81,84,483,-1,81,79,83,-1,79,3630,83,-1,78,59,79,-1,78,77,517,-1,74,516,481,-1,481,75,74,-1,74,3631,516,-1,72,74,76,-1,72,73,74,-1,73,3632,74,-1,3632,3631,74,-1,65,67,63,-1,63,67,3633,-1,3633,64,63,-1,60,59,78,-1,57,61,58,-1,3634,59,37,-1,855,39,38,-1,41,40,48,-1,40,3635,48,-1,56,50,52,-1,52,55,56,-1,52,51,55,-1,51,53,55,-1,49,44,50,-1,3636,3637,45,-1,40,43,38,-1,608,1,172,-1,722,729,3443,-1,3638,650,649,-1,3638,635,650,-1,195,3374,12,-1,195,192,3374,-1,3286,3221,19,-1,3286,1207,3221,-1,20,3220,3279,-1,18,3639,3640,-1,1452,3157,3156,-1,2049,1410,2034,-1,749,2062,30,-1,1408,1411,2595,-1,1693,1451,1450,-1,1693,3639,1451,-1,1693,3641,3639,-1,19,3220,20,-1,19,3221,3220,-1,3371,3642,3614,-1,3371,784,3642,-1,3612,46,441,-1,3612,3643,46,-1,45,103,102,-1,45,3637,103,-1,3636,58,3644,-1,3636,3635,58,-1,3642,51,3643,-1,3642,53,51,-1,49,3635,3636,-1,48,3635,49,-1,39,3634,37,-1,39,472,3634,-1,60,3631,3632,-1,60,78,3631,-1,3644,3633,103,-1,3644,64,3633,-1,65,68,67,-1,65,95,68,-1,73,61,3632,-1,61,73,71,-1,517,3631,78,-1,516,3631,517,-1,59,3630,79,-1,3630,59,3634,-1,3630,3645,83,-1,3630,471,3645,-1,3497,3623,3629,-1,3497,290,3623,-1,489,3624,3627,-1,3646,3624,489,-1,76,3647,72,-1,76,3648,3647,-1,98,118,97,-1,118,98,116,-1,95,98,68,-1,94,98,95,-1,94,114,116,-1,94,96,114,-1,112,3648,3649,-1,112,3647,3648,-1,3624,3610,3627,-1,3610,3624,110,-1,92,3494,93,-1,3494,92,3628,-1,85,3622,290,-1,3622,85,3620,-1,152,3622,3621,-1,152,3623,3622,-1,3356,104,3650,-1,105,104,3356,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_16()
		{
			int[] value = {473,39,855,-1,473,472,39,-1,131,3455,129,-1,3458,3455,131,-1,291,3457,292,-1,3457,291,3619,-1,3619,3596,3618,-1,3619,291,3596,-1,3651,561,3618,-1,561,3651,3652,-1,441,3615,3612,-1,441,440,3615,-1,3614,1380,3371,-1,3614,3613,1380,-1,3611,3653,3654,-1,3611,1383,3653,-1,3655,3652,3651,-1,3652,3655,3654,-1,3655,3218,3656,-1,3218,3655,3657,-1,3597,3618,3596,-1,3597,3651,3618,-1,3649,3429,618,-1,3610,3429,3649,-1,122,3609,120,-1,122,128,3609,-1,3608,3603,99,-1,3608,3607,3603,-1,3581,113,115,-1,113,3581,3606,-1,3604,3449,3605,-1,3604,3658,3449,-1,3659,3600,127,-1,3659,3451,3600,-1,632,3660,629,-1,3601,3660,632,-1,3599,3661,3662,-1,3599,3663,3661,-1,3664,3665,3418,-1,3665,3664,3666,-1,3602,3607,3666,-1,3607,3602,3603,-1,3662,127,3599,-1,127,3662,128,-1,137,3595,3598,-1,137,136,3595,-1,3598,3597,137,-1,3598,3657,3597,-1,1265,556,568,-1,556,1265,557,-1,1386,142,3594,-1,1386,145,142,-1,3667,107,3594,-1,107,3667,3621,-1,3621,150,152,-1,3667,150,3621,-1,3629,491,3628,-1,487,491,3629,-1,3593,3625,156,-1,3625,3593,108,-1,3592,154,486,-1,154,3592,159,-1,3496,3592,486,-1,3668,3592,3496,-1,3438,3437,3566,-1,3437,3438,590,-1,610,161,160,-1,610,614,161,-1,614,610,609,-1,164,108,3593,-1,164,111,108,-1,164,620,111,-1,3590,2847,3588,-1,3590,2677,2847,-1,178,687,598,-1,178,177,687,-1,3669,3440,3670,-1,3671,3440,3669,-1,3672,3673,3674,-1,3673,3672,3675,-1,3676,2665,3586,-1,3676,3677,2665,-1,3416,3678,3679,-1,3416,735,3678,-1,3416,3417,735,-1,3680,629,3660,-1,3680,3681,629,-1,219,3682,3683,-1,219,3684,3682,-1,222,3572,3684,-1,3572,222,3582,-1,578,212,3583,-1,3685,212,578,-1,3686,226,730,-1,3582,226,3686,-1,3579,579,3580,-1,3579,223,579,-1,617,3580,115,-1,3580,617,3430,-1,235,171,170,-1,235,750,171,-1,3211,186,239,-1,3211,3402,186,-1,3401,747,746,-1,747,3401,684,-1,247,3578,3571,-1,3578,247,3577,-1,251,3571,249,-1,251,247,3571,-1,3573,264,3570,-1,3575,264,3573,-1,3687,3452,633,-1,3688,3452,3687,-1,252,3689,253,-1,252,3574,3689,-1,3570,3574,3573,-1,3570,267,3574,-1,3679,3690,3416,-1,3690,3679,3691,-1,3572,3686,734,-1,3572,3582,3686,-1,1405,271,278,-1,1405,3213,271,-1,3387,270,274,-1,3387,271,270,-1,1396,279,1397,-1,1396,281,279,-1,193,3215,194,-1,193,3373,3215,-1,755,3569,754,-1,3214,3569,755,-1,3433,756,3380,-1,3433,28,756,-1,3567,34,36,-1,3567,773,34,-1,3376,777,774,-1,777,3376,3375,-1,3579,238,224,-1,3579,229,238,-1,3692,308,306,-1,3692,3693,308,-1,3694,3695,3696,-1,3562,3695,3694,-1,670,3697,3698,-1,670,3699,3697,-1,310,3700,312,-1,310,3701,3700,-1,3702,3703,3704,-1,3702,3705,3703,-1,316,3706,314,-1,316,3707,3706,-1,3708,3709,3710,-1,3708,3711,3709,-1,3560,3694,320,-1,3560,3562,3694,-1,3698,672,670,-1,672,3698,3559,-1,295,3712,296,-1,3712,295,3713,-1,3714,300,299,-1,3715,300,3714,-1,3716,304,3717,-1,3716,301,304,-1,3704,3558,3702,-1,3558,3704,3556,-1,3554,3708,3553,-1,3554,3718,3708,-1,3719,3552,3710,-1,3552,3719,1043,-1,204,3561,3560,-1,202,3561,204,-1,3720,3721,668,-1,3720,3722,3721,-1,3551,3712,326,-1,3551,311,3712,-1,3713,3421,330,-1,3713,3723,3421,-1,3724,3549,3725,-1,3549,3724,626,-1,3558,334,3717,-1,334,3558,3555,-1,3557,3726,3490,-1,3557,3556,3726,-1,342,3727,340,-1,342,3728,3727,-1,344,3552,346,-1,344,3553,3552,-1,3550,667,3551,-1,665,667,3550,-1,3424,3420,3729,-1,3420,3424,624,-1,3425,3555,370,-1,3425,334,3555,-1,3425,3427,334,-1,3486,373,3557,-1,373,3486,3485,-1,397,3730,392,-1,3730,397,3731,-1,398,327,3545,-1,398,328,327,-1,3544,3732,364,-1,3733,3732,3544,-1,367,378,379,-1,367,387,378,-1,379,374,3530,-1,379,375,374,-1,3734,377,380,-1,377,3734,376,-1,1058,386,348,-1,3735,386,1058,-1,3543,360,378,-1,3543,361,360,-1,3731,396,3736,-1,3731,397,396,-1,404,716,402,-1,404,676,716,-1,3406,719,674,-1,666,719,3406,-1,666,3399,719,-1,3737,3539,3732,-1,3737,3538,3539,-1,3540,365,364,-1,3540,417,365,-1,3540,460,459,-1,3540,3539,460,-1,469,411,410,-1,469,3538,411,-1,622,3537,3542,-1,3426,3537,622,-1,3738,3488,3484,-1,506,3488,3738,-1,3739,3533,455,-1,3739,3534,3533,-1,3535,363,3533,-1,3535,362,363,-1,390,3740,3543,-1,3740,390,3531,-1,3530,366,367,-1,366,3530,3528,-1,3544,3528,425,-1,366,3528,3544,-1,3733,430,3527,-1,3733,427,430,-1,3741,357,3742,-1,357,3741,358,-1,3456,3526,570,-1,3526,3456,3743,-1,3743,426,425,-1,3743,3744,426,-1,566,3525,3745,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_17()
		{
			int[] value = {571,3525,566,-1,374,3745,3525,-1,3745,374,376,-1,567,3745,3524,-1,3745,567,566,-1,3734,3523,3524,-1,3734,1068,3523,-1,3519,3545,356,-1,3519,3736,3545,-1,3521,3736,3519,-1,3521,3731,3736,-1,3392,3522,3746,-1,3392,3394,3522,-1,3391,352,3393,-1,352,3391,349,-1,3518,3747,3748,-1,3518,3517,3747,-1,3507,443,442,-1,3507,3445,443,-1,3513,3749,3750,-1,3513,3515,3749,-1,3751,3304,3752,-1,3751,3299,3304,-1,3753,3754,3755,-1,3753,3487,3754,-1,3749,3756,3757,-1,3749,3758,3756,-1,3514,448,3515,-1,448,3514,3759,-1,3754,3511,3752,-1,3754,3760,3511,-1,3750,3757,3761,-1,3750,3749,3757,-1,3760,3510,3511,-1,3762,3510,3760,-1,3763,510,509,-1,3763,3764,510,-1,3762,3508,3510,-1,3765,3508,3762,-1,3506,3763,3766,-1,3506,3764,3763,-1,3765,3503,3508,-1,3505,3503,3765,-1,3766,3504,3506,-1,3767,3504,3766,-1,442,3505,3507,-1,442,3503,3505,-1,3758,3748,3756,-1,3518,3748,3758,-1,3516,3768,3517,-1,3516,3769,3768,-1,3768,3770,3771,-1,3768,3772,3770,-1,520,3773,3769,-1,520,521,3773,-1,3772,3774,3411,-1,3772,3773,3774,-1,3299,3514,3298,-1,3299,3751,3514,-1,3500,525,3491,-1,3502,525,3500,-1,515,3463,421,-1,3463,515,3775,-1,410,619,3428,-1,409,619,410,-1,2461,149,144,-1,2461,2458,149,-1,3498,3648,76,-1,3498,3626,3648,-1,290,482,84,-1,290,3497,482,-1,151,2436,3493,-1,2436,151,475,-1,93,3495,3646,-1,93,3494,3495,-1,87,90,490,-1,91,90,87,-1,518,481,516,-1,518,3501,481,-1,3501,88,481,-1,3501,3500,88,-1,515,506,3738,-1,515,502,506,-1,3776,3777,3778,-1,3777,3776,3779,-1,340,3554,3489,-1,3554,340,3727,-1,314,3779,3776,-1,3779,314,3706,-1,3728,3547,315,-1,3728,342,3547,-1,3780,313,3726,-1,316,313,3780,-1,3546,3488,345,-1,3739,3488,3546,-1,3534,385,3532,-1,3534,384,385,-1,504,512,337,-1,504,513,512,-1,3509,3472,3474,-1,3509,3781,3472,-1,3516,3472,3781,-1,3516,3473,3472,-1,3484,553,3738,-1,554,553,3484,-1,500,3462,496,-1,500,550,3462,-1,3782,422,523,-1,3782,3531,422,-1,3783,424,3740,-1,3783,449,424,-1,3783,3502,3499,-1,3502,3783,3782,-1,3463,526,421,-1,3460,526,3463,-1,497,3464,3483,-1,453,3464,497,-1,452,3464,453,-1,528,456,454,-1,456,528,3483,-1,3475,3477,544,-1,3784,3477,3475,-1,3461,536,3480,-1,536,3461,534,-1,3481,3785,3465,-1,3482,3785,3481,-1,545,542,3478,-1,539,542,545,-1,540,552,555,-1,540,3786,552,-1,3787,530,3459,-1,3788,530,3787,-1,541,3465,3785,-1,541,547,3465,-1,3789,3466,3790,-1,3789,3469,3466,-1,3480,3476,3789,-1,3476,3480,536,-1,3479,3482,3790,-1,3479,3785,3482,-1,3786,3784,3788,-1,3477,3784,3786,-1,3791,3467,446,-1,3791,3478,3467,-1,537,3474,3472,-1,3474,537,3475,-1,3470,3473,3471,-1,3473,3470,538,-1,3466,3468,447,-1,3468,3466,3469,-1,3465,549,3464,-1,549,3465,547,-1,522,3481,451,-1,522,3461,3481,-1,535,3462,550,-1,535,534,3462,-1,3775,3459,3463,-1,3787,3459,3775,-1,1383,3792,3653,-1,1383,1385,3792,-1,3654,3616,3652,-1,3653,3616,3654,-1,136,577,3595,-1,136,139,577,-1,573,3456,141,-1,3456,573,628,-1,3455,100,101,-1,3455,3453,100,-1,3792,440,3617,-1,3792,3615,440,-1,564,3602,3793,-1,563,3602,564,-1,3583,3606,3581,-1,3583,214,3606,-1,218,3658,3604,-1,218,3683,3658,-1,3451,3682,3450,-1,3682,3451,3659,-1,3605,122,121,-1,3605,3449,122,-1,123,117,119,-1,123,126,117,-1,582,3441,284,-1,582,3439,3441,-1,3794,284,3441,-1,3794,282,284,-1,3445,2668,3444,-1,2668,3445,3795,-1,443,639,445,-1,3446,639,443,-1,583,656,586,-1,583,3408,656,-1,757,3443,756,-1,3796,3443,757,-1,3797,3587,2669,-1,3587,3797,3442,-1,582,3798,3439,-1,582,3799,3798,-1,3796,3447,3443,-1,3796,2299,3447,-1,584,639,3799,-1,584,586,639,-1,3377,3794,3800,-1,3794,3377,282,-1,3568,3801,3567,-1,3802,3801,3568,-1,3586,770,772,-1,770,3586,3585,-1,3673,3801,3802,-1,3801,3673,3676,-1,3674,3794,3671,-1,3800,3794,3674,-1,3668,2286,3438,-1,3803,2286,3668,-1,600,168,598,-1,600,166,168,-1,3593,3591,164,-1,3591,3593,161,-1,3434,3435,3436,-1,3435,3434,604,-1,3436,606,3434,-1,607,606,3436,-1,3589,176,173,-1,3589,3590,176,-1,3384,3386,3588,-1,3384,3383,3386,-1,609,597,612,-1,597,609,611,-1,167,615,3432,-1,167,166,615,-1,235,163,162,-1,235,602,163,-1,109,458,3429,-1,464,458,109,-1,457,3430,617,-1,457,470,3430,-1,619,231,230,-1,619,466,231,-1,299,2588,3564,-1,299,298,2588,-1,335,3426,622,-1,3426,335,3427,-1,405,3424,408,-1,405,624,3424,-1,331,414,332,-1,3541,414,331,-1,353,359,3422,-1,359,353,355,-1,3715,3421,3723,-1,3715,3420,3421,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_18()
		{
			int[] value = {297,3804,3805,-1,297,300,3804,-1,3725,3729,3714,-1,3725,3549,3729,-1,301,3724,3565,-1,301,3716,3724,-1,3664,426,3793,-1,428,426,3664,-1,3661,3419,3418,-1,3742,3419,3661,-1,3741,632,631,-1,3741,3663,632,-1,3746,3681,209,-1,3746,3522,3681,-1,3806,3807,432,-1,3806,211,3807,-1,3807,3678,735,-1,3678,3807,3808,-1,265,3570,206,-1,265,267,3570,-1,3689,3416,3690,-1,3416,3689,266,-1,642,3414,636,-1,3414,642,641,-1,3537,3809,3542,-1,3537,3810,3809,-1,3811,467,468,-1,467,3811,648,-1,32,2301,33,-1,2301,32,3448,-1,647,3812,3413,-1,647,3813,3812,-1,649,3814,3815,-1,3816,3814,649,-1,3817,3410,3412,-1,3817,3818,3410,-1,3413,3809,3810,-1,3413,3812,3809,-1,3816,648,3811,-1,3816,649,648,-1,3638,3815,3817,-1,3815,3638,649,-1,3809,3816,3811,-1,3812,3816,3809,-1,652,3411,3774,-1,3411,652,3410,-1,3818,3408,32,-1,3408,3818,3409,-1,3407,666,3406,-1,666,3407,664,-1,404,3550,329,-1,404,403,3550,-1,3721,310,309,-1,310,3721,3819,-1,3407,325,3720,-1,3407,323,325,-1,3820,3559,3698,-1,3820,3722,3559,-1,663,391,351,-1,663,675,391,-1,244,3405,241,-1,244,677,3405,-1,3404,3577,242,-1,3577,3404,3403,-1,3578,679,748,-1,3578,678,679,-1,682,245,3401,-1,245,682,681,-1,3405,395,3404,-1,3405,399,395,-1,3404,393,3403,-1,3404,394,393,-1,679,746,748,-1,691,746,679,-1,747,685,3382,-1,747,684,685,-1,681,715,677,-1,715,681,680,-1,584,587,585,-1,587,584,725,-1,3821,714,711,-1,3400,714,3821,-1,3821,3397,720,-1,3821,693,3397,-1,695,710,697,-1,696,710,695,-1,702,723,704,-1,702,724,723,-1,701,698,700,-1,701,721,698,-1,703,718,717,-1,703,3400,718,-1,698,715,699,-1,688,715,698,-1,3397,683,690,-1,3397,3398,683,-1,708,729,722,-1,729,708,706,-1,3576,252,256,-1,252,3576,3573,-1,257,734,3686,-1,734,257,260,-1,3691,208,210,-1,3691,3679,208,-1,3680,3688,3687,-1,3688,3680,3660,-1,3390,432,431,-1,3390,3806,432,-1,3395,435,321,-1,435,3395,3520,-1,737,3388,3520,-1,737,205,3388,-1,201,275,277,-1,275,201,203,-1,3393,3390,3391,-1,3392,3390,3393,-1,436,305,198,-1,305,436,196,-1,197,3692,306,-1,3692,197,3584,-1,3561,199,307,-1,199,3561,202,-1,308,3822,3563,-1,308,3693,3822,-1,739,276,740,-1,739,1392,276,-1,187,752,270,-1,187,778,752,-1,3386,179,181,-1,3386,3383,179,-1,749,3384,3014,-1,3384,749,29,-1,179,3385,191,-1,3385,179,3383,-1,687,3381,686,-1,687,180,3381,-1,184,762,761,-1,183,762,184,-1,765,272,751,-1,765,273,272,-1,3378,182,191,-1,3378,183,182,-1,751,764,765,-1,751,768,764,-1,1389,3373,438,-1,3215,3373,1389,-1,768,774,764,-1,3376,774,768,-1,2664,3374,3585,-1,10,3374,2664,-1,781,820,779,-1,781,792,820,-1,781,790,792,-1,784,787,780,-1,787,784,3371,-1,3372,3823,3824,-1,3372,3294,3823,-1,846,3825,824,-1,846,3824,3825,-1,3826,782,779,-1,3826,3825,782,-1,3825,825,824,-1,3826,825,3825,-1,3823,1161,782,-1,1160,1161,3823,-1,56,786,1161,-1,786,56,55,-1,855,3372,848,-1,3372,855,38,-1,1381,3370,3369,-1,3370,1381,3827,-1,557,1379,3368,-1,557,1265,1379,-1,1269,3366,802,-1,1269,3367,3366,-1,3366,814,800,-1,814,3366,812,-1,3828,813,3367,-1,813,3828,1274,-1,3829,3828,3830,-1,3828,3829,3831,-1,3832,3831,3833,-1,3831,3832,1275,-1,3254,808,3832,-1,3834,808,3254,-1,3368,3217,557,-1,3217,3368,816,-1,1384,815,3827,-1,3835,815,1384,-1,811,3370,817,-1,3370,811,796,-1,834,829,828,-1,834,1277,829,-1,3836,1031,834,-1,1031,3836,3837,-1,1032,825,819,-1,825,1032,826,-1,3838,3253,809,-1,3253,3838,3252,-1,845,3836,834,-1,845,843,3836,-1,841,1006,943,-1,841,844,1006,-1,3227,853,851,-1,3227,1359,853,-1,1358,856,854,-1,1358,1342,856,-1,3257,3839,3840,-1,3257,3256,3839,-1,3261,3841,3842,-1,3841,3261,3843,-1,1020,3263,1259,-1,1021,3263,1020,-1,1251,3269,3275,-1,1251,3270,3269,-1,3844,3845,880,-1,3844,3846,3845,-1,3847,3845,3848,-1,3847,3849,3845,-1,885,3364,883,-1,885,3850,3364,-1,3851,3849,3847,-1,3849,3851,3852,-1,3361,3853,3362,-1,3361,3854,3853,-1,3853,3855,3338,-1,3853,3856,3855,-1,3363,3337,3857,-1,3337,3363,3362,-1,896,3858,3358,-1,896,3359,3858,-1,1331,894,893,-1,1331,3859,894,-1,1338,898,897,-1,1338,3235,898,-1,3858,915,909,-1,3359,915,3858,-1,3358,905,902,-1,3858,905,3358,-1,3238,895,3358,-1,3238,3239,895,-1,3860,904,3357,-1,904,3860,3861,-1,946,903,906,-1,946,3357,903,-1,3234,898,3235,-1,3234,913,898,-1,1334,1386,106,-1,1386,1334,1335,-1,1169,3229,3231,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_19()
		{
			int[] value = {1169,1168,3229,-1,3229,914,3228,-1,3229,1168,914,-1,910,1162,924,-1,912,1162,910,-1,929,947,906,-1,929,3355,947,-1,1280,937,1263,-1,937,1280,1279,-1,951,3354,3352,-1,951,948,3354,-1,957,3224,955,-1,957,1363,3224,-1,947,1361,945,-1,1365,1361,947,-1,3354,1294,1291,-1,3354,1315,1294,-1,1314,3245,3862,-1,1313,3245,1314,-1,3863,3353,3352,-1,3863,3864,3353,-1,3865,1305,3247,-1,3865,3866,1305,-1,3353,972,952,-1,972,3353,970,-1,1291,3352,3354,-1,1291,3863,3352,-1,1027,1256,3867,-1,1256,1027,1026,-1,994,3868,992,-1,3341,3868,994,-1,3267,1030,1029,-1,3267,1257,1030,-1,1016,3869,1014,-1,1016,3260,3869,-1,1008,831,830,-1,1008,833,831,-1,832,3841,830,-1,3841,832,3870,-1,3255,3871,3350,-1,3255,3833,3871,-1,943,3260,941,-1,3260,943,3869,-1,1025,995,1022,-1,1025,996,995,-1,3348,1285,1283,-1,3348,3347,1285,-1,985,3348,979,-1,985,3347,3348,-1,983,3347,985,-1,983,1288,3347,-1,1136,974,3872,-1,1136,975,974,-1,3265,1261,3873,-1,1261,3265,3343,-1,3874,1029,3266,-1,3874,3267,1029,-1,1028,3266,1029,-1,3340,3266,1028,-1,1147,3338,3855,-1,3338,1147,1137,-1,3875,3719,3876,-1,3719,3875,3877,-1,3878,3879,3880,-1,3878,3881,3879,-1,3882,3883,3884,-1,3882,3885,3883,-1,1043,3877,1041,-1,1043,3719,3877,-1,1047,1039,1045,-1,1047,1037,1039,-1,3880,1049,3878,-1,1049,3880,1051,-1,1052,3884,1055,-1,1052,3882,3884,-1,1074,1057,1042,-1,1057,1074,3330,-1,1046,1352,1044,-1,1352,1046,3323,-1,1077,1053,1078,-1,1077,1054,1053,-1,3329,1058,1057,-1,1058,3329,3735,-1,3886,3887,1131,-1,3886,3326,3887,-1,382,1066,383,-1,1066,382,3328,-1,3329,1069,3328,-1,3329,3331,1069,-1,3888,3324,3889,-1,3888,3321,3324,-1,3324,1082,3327,-1,3324,1083,1082,-1,3326,1112,3887,-1,3326,3325,1112,-1,3330,1377,3331,-1,3330,1378,1377,-1,1089,1060,1097,-1,1089,1059,1060,-1,1104,3322,1079,-1,1104,1105,3322,-1,1081,3322,1084,-1,1081,3316,3322,-1,1093,3321,3888,-1,3321,1093,3320,-1,3319,3890,3320,-1,3890,3319,3891,-1,3891,3317,3890,-1,3891,3318,3317,-1,3890,3316,1081,-1,3890,3317,3316,-1,1096,3276,1376,-1,1096,1184,3276,-1,1084,3892,1082,-1,1107,3892,1084,-1,3327,3893,3325,-1,3327,3894,3893,-1,3895,3896,3897,-1,3895,3898,3896,-1,3899,3900,3901,-1,3899,3902,3900,-1,1106,3903,3904,-1,1106,1108,3903,-1,3905,1103,1062,-1,1103,3905,3906,-1,1124,3905,1121,-1,3905,1124,3274,-1,3906,3314,3903,-1,3906,3907,3314,-1,3313,3903,3314,-1,3313,3904,3903,-1,3902,1114,3900,-1,3902,3908,1114,-1,3900,3909,3910,-1,3909,3900,1114,-1,3911,3912,3913,-1,3911,3914,3912,-1,3915,3914,3916,-1,3914,3915,3912,-1,1116,1253,866,-1,1116,3917,1253,-1,3918,3275,1254,-1,3918,3273,3275,-1,3919,3894,3901,-1,3894,3919,3893,-1,3313,3271,3908,-1,3313,3315,3271,-1,1065,3920,3312,-1,1064,3920,1065,-1,3921,3922,3923,-1,3921,3924,3922,-1,3925,3926,3927,-1,3925,3928,3926,-1,1111,3887,1112,-1,3887,1111,3929,-1,3930,3846,3931,-1,3930,3932,3846,-1,3922,3933,3923,-1,3934,3933,3922,-1,3931,3935,3933,-1,3936,3935,3931,-1,3844,3937,3936,-1,878,3937,3844,-1,878,3938,3937,-1,3935,3928,3925,-1,3935,3939,3928,-1,3938,877,3309,-1,3938,878,877,-1,907,908,930,-1,911,908,907,-1,1036,3248,3339,-1,1036,1300,3248,-1,3137,3305,3940,-1,1784,3305,3137,-1,1325,3941,1321,-1,1325,1151,3941,-1,1140,3942,1198,-1,1139,3942,1140,-1,1198,3943,3944,-1,1198,3942,3943,-1,1150,3941,1151,-1,1150,3301,3941,-1,3945,1155,3297,-1,3945,3946,1155,-1,3947,3306,3307,-1,3947,3948,3306,-1,3135,3940,3856,-1,3137,3940,3135,-1,3855,3297,1147,-1,3945,3297,3855,-1,3946,1154,1155,-1,3949,1154,3946,-1,3307,1134,3947,-1,3307,3950,1134,-1,1247,3944,3951,-1,1198,3944,1247,-1,3753,3952,3953,-1,3753,3948,3952,-1,3306,3304,3303,-1,3755,3304,3306,-1,1139,3513,3942,-1,3298,3513,1139,-1,3944,3954,3955,-1,3943,3954,3944,-1,3956,1142,1144,-1,1149,1142,3956,-1,1147,3296,1148,-1,3296,1147,3297,-1,3300,3957,3958,-1,3959,3957,3300,-1,3951,24,1247,-1,3960,24,3951,-1,1144,24,3956,-1,22,24,1144,-1,1766,3961,3960,-1,1766,3962,3961,-1,3296,1143,1326,-1,3296,1153,1143,-1,1179,1342,1358,-1,1179,1178,1342,-1,1360,3290,3287,-1,3290,1360,3226,-1,3963,3964,3965,-1,3966,3964,3963,-1,1183,1182,1158,-1,1182,1183,3967,-1,3965,3968,3963,-1,3969,3968,3965,-1,3287,1358,1360,-1,3287,3295,1358,-1,3276,3970,1100,-1,3277,3970,3276,-1,1094,3971,3289,-1,3971,1094,3292,-1,3289,3295,3287,-1,3295,3289,3971,-1,3319,3288,3966,-1,3288,3319,1095,-1,3963,3318,3891,-1,3963,3968,3318,-1,3965,3225,1357,-1,3965,3964,3225,-1,1354,1180,1182,-1,1180,1354,1244,-1,1355,3967,3969,-1,3967,1355,3972,-1,3293,3280,1245,-1,3293,1216,3280,-1,3973,3277,3285,-1,3970,3277,3973,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_20()
		{
			int[] value = {3291,1224,1173,-1,3291,3974,1224,-1,1223,1167,1174,-1,1167,1223,3975,-1,1234,1192,1220,-1,1234,1193,1192,-1,3976,3285,3286,-1,3976,3973,3285,-1,1222,3974,3284,-1,1222,1224,3974,-1,1242,1189,1188,-1,1242,1239,1189,-1,1238,3976,3278,-1,3284,3976,1238,-1,1230,1369,1368,-1,1230,1229,1369,-1,1193,1206,1195,-1,1234,1206,1193,-1,3282,3977,3281,-1,3282,1241,3977,-1,1212,3282,1229,-1,1212,1213,3282,-1,1100,3291,1101,-1,3291,1100,3970,-1,3939,3938,3309,-1,3938,3939,3937,-1,1127,1122,3312,-1,1127,1126,1122,-1,3363,886,3852,-1,3363,3857,886,-1,884,3872,974,-1,3872,884,887,-1,3850,874,876,-1,3850,885,874,-1,3927,3920,1119,-1,3927,3926,3920,-1,1120,3924,3921,-1,3924,1120,3978,-1,1126,3308,3272,-1,1126,1125,3308,-1,3917,3315,3314,-1,3315,3917,1116,-1,3274,3918,3907,-1,3274,3273,3918,-1,1123,3273,1124,-1,1123,1252,3273,-1,3272,3310,1249,-1,3272,3308,3310,-1,3908,1115,1114,-1,3908,3271,1115,-1,3365,876,3270,-1,3365,3850,876,-1,992,990,991,-1,992,3868,990,-1,3979,865,3262,-1,1117,865,3979,-1,3342,3267,3874,-1,3267,3342,1258,-1,3345,3341,3342,-1,3345,3344,3341,-1,3868,3264,990,-1,3268,3264,3868,-1,868,872,990,-1,868,869,872,-1,3266,3873,3874,-1,3265,3873,3266,-1,1259,3262,1260,-1,1259,3263,3262,-1,1017,3340,1015,-1,1017,1019,3340,-1,1004,3343,1018,-1,1004,1020,3343,-1,3842,3980,3261,-1,3842,3916,3980,-1,3909,3914,3911,-1,3914,3909,3981,-1,3919,3898,3895,-1,3898,3919,3910,-1,3916,3982,3915,-1,3916,3842,3982,-1,862,3913,3912,-1,3913,862,864,-1,3897,860,805,-1,3897,3896,860,-1,801,1110,804,-1,1111,1110,801,-1,798,3259,799,-1,798,1268,3259,-1,3840,3982,3870,-1,3982,3840,3839,-1,3915,3839,3983,-1,3839,3915,3982,-1,3984,829,1278,-1,3984,827,829,-1,827,1011,3985,-1,3984,1011,827,-1,1010,3986,3256,-1,1010,1009,3986,-1,861,3350,3871,-1,3350,861,863,-1,859,3830,806,-1,859,3829,3830,-1,788,3369,789,-1,1381,3369,788,-1,1272,3838,3834,-1,3838,1272,1271,-1,824,3837,835,-1,824,826,3837,-1,1281,940,3243,-1,938,940,1281,-1,1027,3349,1023,-1,980,3349,1027,-1,3251,978,3867,-1,3251,1255,978,-1,1282,3245,3243,-1,3245,1282,1284,-1,983,1303,3250,-1,983,982,1303,-1,3987,3248,1306,-1,3988,3248,3987,-1,1304,950,949,-1,1304,1320,950,-1,3242,1294,959,-1,1292,1294,3242,-1,3246,969,3247,-1,3246,1289,969,-1,967,3250,973,-1,1290,3250,967,-1,3987,986,1303,-1,3987,987,986,-1,1316,1314,3244,-1,1316,1312,1314,-1,3240,3244,962,-1,1316,3244,3240,-1,1322,1034,1146,-1,1322,1035,1034,-1,3301,891,3861,-1,3301,3302,891,-1,3236,902,904,-1,3236,3237,902,-1,1520,3239,3238,-1,3239,1520,1524,-1,3237,890,1521,-1,3237,3236,890,-1,3234,922,3228,-1,923,922,3234,-1,921,3230,1337,-1,921,920,3230,-1,1170,3233,1163,-1,1170,1349,3233,-1,1186,926,925,-1,1186,927,926,-1,1341,1342,3232,-1,1342,1341,857,-1,3231,1337,3230,-1,3231,3229,1337,-1,3989,1039,1040,-1,3989,3334,1039,-1,1046,3333,3990,-1,3333,1046,1045,-1,1375,1090,1092,-1,1090,1375,3323,-1,3878,3335,3336,-1,3878,1049,3335,-1,1037,3332,3991,-1,1037,1047,3332,-1,1354,933,1353,-1,1354,3972,933,-1,1357,3227,1356,-1,1357,3225,3227,-1,1228,1248,3222,-1,1228,1227,1248,-1,3223,3977,1366,-1,3281,3977,3223,-1,1236,1372,1237,-1,1236,1202,1372,-1,3283,1201,23,-1,3283,1233,1201,-1,3949,3305,1135,-1,3949,3946,3305,-1,1205,3949,3950,-1,1205,1154,3949,-1,1086,1075,1102,-1,1086,1073,1075,-1,1390,1391,3216,-1,1390,3992,1391,-1,1397,3214,1399,-1,3214,1397,279,-1,1398,26,1394,-1,1398,1402,26,-1,3209,1421,3205,-1,3209,3208,1421,-1,1418,2075,1419,-1,1418,2873,2075,-1,1416,3993,1415,-1,1416,2074,3993,-1,3205,1411,1410,-1,1411,3205,3206,-1,3994,2083,1429,-1,2083,3994,2604,-1,2600,1430,2028,-1,1430,2600,3204,-1,1411,3994,3204,-1,1411,3206,3994,-1,3206,2604,3994,-1,3206,1422,2604,-1,1387,1508,3203,-1,1387,1509,1508,-1,3201,2731,2015,-1,2731,3201,3202,-1,1447,3995,1721,-1,3995,1447,3996,-1,1704,3165,3157,-1,3165,1704,16,-1,16,3199,3165,-1,16,18,3199,-1,1725,1688,3997,-1,1688,1725,3155,-1,1466,1698,1697,-1,1698,1466,1465,-1,3154,1701,1723,-1,3154,1702,1701,-1,3072,3998,1746,-1,3197,3998,3072,-1,1446,1826,3109,-1,1444,1826,1446,-1,3100,1848,3097,-1,3100,1849,1848,-1,1038,3999,3095,-1,1038,4000,3999,-1,4001,3194,3193,-1,4001,1852,3194,-1,1853,3881,4002,-1,4003,3881,1853,-1,4004,1827,3113,-1,4004,3098,1827,-1,1854,3099,1851,-1,1854,3096,3099,-1,1495,1500,1501,-1,1500,1495,1494,-1,1945,15,1491,-1,15,1945,3070,-1,1958,1513,1329,-1,1513,1958,1512,-1,1517,4005,1956,-1,1517,1516,4005,-1,3133,4005,1779,-1,3133,1952,4005,-1,888,1777,1516,-1,4006,1777,888,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_21()
		{
			int[] value = {1914,1547,1929,-1,1914,1545,1547,-1,3184,1544,1543,-1,3186,1544,3184,-1,1468,1560,1559,-1,1468,1467,1560,-1,3182,4007,1562,-1,3182,1561,4007,-1,3188,1580,3189,-1,3188,1581,1580,-1,4008,3190,1589,-1,3190,4008,3191,-1,3186,1918,1544,-1,3186,1915,1918,-1,1920,3079,3078,-1,1920,3185,3079,-1,3132,1573,1786,-1,3132,3189,1573,-1,1556,1543,1542,-1,1556,3079,1543,-1,3083,3188,3187,-1,3083,3190,3188,-1,1590,1569,1565,-1,1590,1592,1569,-1,1562,1552,1876,-1,4007,1552,1562,-1,3091,1881,3074,-1,1881,3091,1884,-1,4009,1872,3166,-1,4009,3093,1872,-1,3092,1877,1875,-1,1877,3092,3091,-1,1550,3091,3074,-1,1550,1877,3091,-1,3179,3041,3040,-1,2002,3041,3179,-1,3177,1601,1603,-1,1997,1601,3177,-1,3032,3035,4010,-1,3035,3032,3180,-1,1604,1995,1605,-1,1604,3033,1995,-1,1609,3176,1607,-1,1998,3176,1609,-1,3039,3037,2005,-1,3039,4011,3037,-1,3058,4012,4013,-1,3058,4014,4012,-1,4015,1890,4016,-1,1891,1890,4015,-1,3088,1612,1611,-1,3088,1893,1612,-1,4017,1616,1615,-1,1892,1616,4017,-1,1617,2009,4018,-1,1617,1619,2009,-1,2007,4018,2009,-1,3122,4018,2007,-1,2006,4019,3123,-1,4019,2006,3038,-1,4020,4021,3059,-1,4022,4021,4020,-1,4023,4024,4025,-1,4023,4026,4024,-1,1613,4024,4016,-1,4024,1613,4027,-1,4028,4029,4030,-1,4028,4031,4029,-1,4032,4033,4034,-1,4035,4033,4032,-1,1866,3170,3089,-1,3170,1866,3171,-1,1887,3086,1889,-1,3086,1887,1885,-1,4036,1869,4037,-1,1869,4036,3172,-1,4038,1867,3173,-1,1647,1867,4038,-1,1868,4037,1869,-1,3171,4037,1868,-1,1649,4009,1594,-1,3168,4009,1649,-1,1657,4039,1671,-1,1657,1976,4039,-1,1788,1657,1656,-1,1788,1794,1657,-1,1803,4040,4041,-1,1803,4042,4040,-1,3126,1654,1653,-1,1802,1654,3126,-1,4043,4044,4045,-1,4046,4044,4043,-1,4047,1797,3127,-1,4047,4048,1797,-1,1652,1795,1796,-1,1652,1976,1795,-1,4049,3062,3060,-1,4049,1969,3062,-1,4050,1970,4051,-1,4050,3063,1970,-1,4052,3360,3851,-1,4053,3360,4052,-1,1722,1452,3156,-1,1722,1453,1452,-1,3164,3161,1696,-1,3159,3161,3164,-1,1688,3164,3997,-1,1687,3164,1688,-1,1705,1457,1456,-1,1705,1707,1457,-1,1711,3158,1709,-1,3158,1711,1729,-1,1700,1712,1703,-1,1713,1712,1700,-1,4054,1686,3163,-1,1685,1686,4054,-1,3640,1705,18,-1,4055,1705,3640,-1,4055,1719,1705,-1,3161,3151,1714,-1,3161,3159,3151,-1,3150,1685,4054,-1,3160,1685,3150,-1,1727,4055,3641,-1,4055,1727,1726,-1,3165,1534,1760,-1,1534,3165,3199,-1,1493,3068,1749,-1,3068,1493,1492,-1,1679,3162,1736,-1,1679,3163,3162,-1,4056,1718,1717,-1,4056,1737,1718,-1,1673,3152,1675,-1,1673,3153,3152,-1,1489,1710,1715,-1,1489,14,1710,-1,1714,1749,3068,-1,1749,1714,3151,-1,3144,4054,1681,-1,3144,3150,4054,-1,1678,1807,1676,-1,1678,1672,1807,-1,1808,4057,1812,-1,3149,4057,1808,-1,3195,4058,1674,-1,4058,3195,3998,-1,1475,4059,1476,-1,1730,4059,1475,-1,4060,3196,4061,-1,4060,3197,3196,-1,4062,4063,4064,-1,4062,1814,4063,-1,4065,1757,3146,-1,1758,1757,4065,-1,1742,3146,1817,-1,4065,3146,1742,-1,1804,3147,1682,-1,3147,1804,1816,-1,1682,3148,1680,-1,3148,1682,3147,-1,3198,1929,1624,-1,3072,1929,3198,-1,14,1491,15,-1,1489,1491,14,-1,4060,3149,4058,-1,4060,4057,3149,-1,1730,4062,4059,-1,1732,4062,1730,-1,1680,1497,1498,-1,1680,3148,1497,-1,3142,1528,1769,-1,3142,1525,1528,-1,4066,1763,3156,-1,1763,4066,4067,-1,1778,4068,3143,-1,4068,1778,1780,-1,1525,1538,1529,-1,1525,3142,1538,-1,3143,4067,4066,-1,3143,4068,4067,-1,4069,4070,4071,-1,4069,2484,4070,-1,4072,4073,4074,-1,4072,4075,4073,-1,3955,1765,1764,-1,3955,4076,1765,-1,4077,1133,3138,-1,4077,4078,1133,-1,3995,1783,3140,-1,3995,3138,1783,-1,4079,3136,4080,-1,4079,3134,3136,-1,3139,3134,4079,-1,3134,3139,1785,-1,3996,1782,4074,-1,3996,1447,1782,-1,1777,3958,1780,-1,3958,1777,4006,-1,4068,3962,4067,-1,4068,3957,3962,-1,3761,4071,3954,-1,4071,3761,4069,-1,1447,1772,1782,-1,1772,1447,1449,-1,4073,4078,4077,-1,4073,3952,4078,-1,1906,3132,1863,-1,3187,3132,1906,-1,1656,4081,1789,-1,4082,4081,1656,-1,4082,3129,4083,-1,3130,3129,4082,-1,3129,4084,4085,-1,3129,4086,4084,-1,4087,4083,4088,-1,4087,4089,4083,-1,4085,3934,4088,-1,4085,3930,3934,-1,3128,4018,3106,-1,4018,3128,1617,-1,3127,4081,4047,-1,4081,3127,1789,-1,4046,4087,4044,-1,4087,4046,4089,-1,4043,3104,4048,-1,4043,3102,3104,-1,3978,4090,4045,-1,3978,4091,4090,-1,4092,4093,4094,-1,4093,4092,4095,-1,4096,4097,3121,-1,4097,4096,4098,-1,1977,4042,1633,-1,4042,1977,4040,-1,3169,1630,1632,-1,3169,4034,1630,-1,4034,3124,4032,-1,3124,4034,3169,-1,4022,4030,4021,-1,4030,4022,4028,-1,4032,3125,4031,-1,3124,3125,4032,-1,1655,3169,1653,-1,1655,3124,3169,-1,4099,4100,4101,-1,1801,4100,4099,-1,4041,4102,4103,-1,1664,4102,4041,-1,1842,1798,1799,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_22()
		{
			int[] value = {1842,4102,1798,-1,4104,3116,3120,-1,3116,4104,4103,-1,4101,3119,4094,-1,3119,4101,4100,-1,4093,4029,4105,-1,4093,4098,4029,-1,4019,3121,3123,-1,3121,4019,4096,-1,1830,3121,4097,-1,1830,3107,3121,-1,3111,4095,4092,-1,3111,1828,4095,-1,4094,3118,4092,-1,3119,3118,4094,-1,3116,3117,3120,-1,3116,3115,3117,-1,1742,1818,1744,-1,1742,1817,1818,-1,1820,1815,1821,-1,1820,4106,1815,-1,4107,1743,3105,-1,4107,1813,1743,-1,3112,3117,1822,-1,3117,3112,3118,-1,3103,1823,3115,-1,3110,1823,3103,-1,1440,3108,1839,-1,3108,1440,1439,-1,1744,1838,1832,-1,1838,1744,1818,-1,4108,1829,1831,-1,4108,4109,1829,-1,4108,3105,1834,-1,3105,4108,4107,-1,1833,4110,2908,-1,1833,1837,4110,-1,3128,1836,1793,-1,3128,4109,1836,-1,4109,1834,1836,-1,1834,4109,4108,-1,3110,1841,1846,-1,3110,3103,1841,-1,1824,3101,4111,-1,1824,1825,3101,-1,3113,3194,4004,-1,3113,1437,3194,-1,3108,1848,1844,-1,1848,3108,3109,-1,1846,3104,3102,-1,1846,1841,3104,-1,1845,4111,3101,-1,4112,4111,1845,-1,1852,4004,3194,-1,1851,4004,1852,-1,4090,1847,3102,-1,4113,1847,4090,-1,4114,4112,1845,-1,4115,4112,4114,-1,1850,3999,4116,-1,1850,1849,3999,-1,4091,4113,4090,-1,3883,4113,4091,-1,3885,4115,4114,-1,3879,4115,3885,-1,1853,3989,1854,-1,3989,1853,4002,-1,4000,4116,3999,-1,3875,4116,4000,-1,4117,1579,1910,-1,1577,1579,4117,-1,3173,1644,1904,-1,3173,3172,1644,-1,1629,1926,1881,-1,1626,1926,1629,-1,1901,1586,1900,-1,1586,1901,1886,-1,3050,4118,4119,-1,3050,3087,4118,-1,4118,1898,3090,-1,3087,1898,4118,-1,1888,1894,1896,-1,1888,1889,1894,-1,1883,1902,1900,-1,1882,1902,1883,-1,1880,3084,1878,-1,1880,3085,3084,-1,1879,1648,1880,-1,3168,1648,1879,-1,3081,3187,1906,-1,3083,3187,3081,-1,3081,1874,3082,-1,3081,3167,1874,-1,1906,3167,3081,-1,1906,1905,3167,-1,1917,4120,1916,-1,4120,1917,3183,-1,1912,4121,1909,-1,1912,3191,4121,-1,1577,4008,1567,-1,1577,4117,4008,-1,1578,1571,1576,-1,1571,1578,1566,-1,1579,1916,4120,-1,1579,1576,1916,-1,1553,4007,3192,-1,1553,1552,4007,-1,1470,1559,3076,-1,1470,1468,1559,-1,1921,1471,3077,-1,1921,1472,1471,-1,1919,3077,1924,-1,1919,1921,3077,-1,1952,1776,1953,-1,1952,3133,1776,-1,1988,3075,1895,-1,3075,1988,1990,-1,1623,1982,1624,-1,1982,1623,1983,-1,3055,3198,1624,-1,3198,3055,1478,-1,3145,1949,1944,-1,3145,4122,1949,-1,1939,3069,1943,-1,1939,1502,3069,-1,1498,1487,1496,-1,1487,1498,1488,-1,1480,1963,4122,-1,1963,1480,1506,-1,1955,3067,3066,-1,1955,3071,3067,-1,3066,1948,3065,-1,1948,3066,3067,-1,1514,4123,1965,-1,1515,4123,1514,-1,4123,1966,1965,-1,3064,1966,4123,-1,3064,1960,1966,-1,3064,1957,1960,-1,4050,1859,1860,-1,4050,4051,1859,-1,1858,4124,1860,-1,1858,4125,4124,-1,3854,3136,3135,-1,3854,4125,3136,-1,4124,3360,4053,-1,3361,3360,4124,-1,4052,1974,3063,-1,1973,1974,4052,-1,4084,3848,3932,-1,4084,1975,3848,-1,1972,3061,1670,-1,3061,1972,4086,-1,1594,1650,1649,-1,1650,1594,1593,-1,1645,1636,1800,-1,1645,1637,1636,-1,4118,1631,1630,-1,4118,3090,1631,-1,4017,4126,4127,-1,4017,4119,4126,-1,4016,4026,4015,-1,4026,4016,4024,-1,4013,3059,3058,-1,3059,4013,4020,-1,1608,4128,3088,-1,1608,3175,4128,-1,1477,1980,1759,-1,1477,3056,1980,-1,3055,3054,3056,-1,3055,1981,3054,-1,3054,1984,3030,-1,3054,1981,1984,-1,1985,3053,1987,-1,1985,1992,3053,-1,1989,1984,1983,-1,3052,1984,1989,-1,3052,3053,4129,-1,3053,3052,1989,-1,1616,3049,1614,-1,3049,1616,1893,-1,3175,1603,4128,-1,3177,1603,3175,-1,1999,3033,1604,-1,3033,1999,3034,-1,1597,4130,1994,-1,3047,4130,1597,-1,3051,4129,4130,-1,4129,3051,3052,-1,1994,1602,1598,-1,1602,1994,1600,-1,3036,3040,3041,-1,3036,3034,3040,-1,4131,3045,3044,-1,4131,4132,3045,-1,3043,4133,3044,-1,1433,4133,3043,-1,3043,2011,2010,-1,3043,3042,2011,-1,3045,2001,3042,-1,3041,2001,3045,-1,4134,1609,1610,-1,4135,1609,4134,-1,1996,3178,3040,-1,1996,4135,3178,-1,4136,4012,4014,-1,4136,4134,4012,-1,3179,4136,4137,-1,3179,3178,4136,-1,2004,2011,2000,-1,2004,2008,2011,-1,4011,2003,4137,-1,4011,3039,2003,-1,3201,4131,2727,-1,3200,4131,3201,-1,4010,3036,4132,-1,3035,3036,4010,-1,2026,3180,3032,-1,2026,4138,3180,-1,4139,1754,4140,-1,4139,1755,1754,-1,2024,1752,2022,-1,2024,3031,1752,-1,3031,2027,2025,-1,2027,3031,2024,-1,4141,1596,2027,-1,4141,3048,1596,-1,2023,3027,3029,-1,3027,2023,4140,-1,3027,1979,3030,-1,3027,2021,1979,-1,2036,2663,2967,-1,2036,11,2663,-1,3023,2597,3019,-1,2037,2597,3023,-1,3021,2594,3026,-1,2594,3021,3022,-1,3023,2038,2037,-1,2038,3023,3025,-1,2603,2601,2042,-1,2603,2596,2601,-1,1409,3017,2034,-1,1409,3022,3017,-1,3024,3019,3020,-1,3024,3023,3019,-1,2052,3017,2050,-1,3017,2052,2876,-1,3015,2670,3016,-1,3015,3024,2670,-1,2670,3020,2671,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_23()
		{
			int[] value = {2670,3024,3020,-1,2844,2680,2969,-1,2680,2844,2160,-1,2048,2059,2043,-1,2048,2065,2059,-1,2608,2489,2605,-1,2489,2608,2607,-1,2886,2584,2885,-1,2886,2582,2584,-1,2924,2103,2104,-1,2924,4142,2103,-1,2081,2606,2659,-1,2083,2606,2081,-1,2098,2080,2495,-1,2098,2095,2080,-1,2706,4143,2709,-1,2705,4143,2706,-1,4144,2851,2867,-1,4144,4145,2851,-1,2866,2658,4146,-1,2866,2656,2658,-1,4147,2623,3011,-1,2620,2623,4147,-1,2629,2108,2622,-1,2108,2629,2107,-1,2122,2965,2146,-1,2122,2121,2965,-1,2137,3010,2917,-1,2136,3010,2137,-1,2125,2151,2136,-1,3009,2151,2125,-1,2150,2132,3010,-1,2150,2152,2132,-1,3007,2130,3008,-1,3007,2124,2130,-1,2149,3007,2148,-1,2149,3009,3007,-1,2142,2130,2129,-1,2142,3008,2130,-1,2162,1412,2164,-1,1413,1412,2162,-1,2168,3013,2158,-1,3013,2168,2167,-1,2170,2635,2636,-1,2635,2170,2169,-1,2634,2176,2632,-1,2634,2174,2176,-1,2111,2631,2862,-1,2631,2111,3005,-1,3003,3699,4148,-1,3002,3699,3003,-1,3004,2193,2192,-1,3004,2893,2193,-1,4149,4150,3697,-1,4151,4150,4149,-1,2894,4152,4153,-1,4154,4152,2894,-1,4155,3701,4156,-1,2887,3701,4155,-1,2888,3001,3000,-1,2888,4157,3001,-1,4158,2999,2998,-1,4158,4159,2999,-1,8,2984,2983,-1,8,2995,2984,-1,2468,2994,2993,-1,2468,2943,2994,-1,2294,4160,4161,-1,2294,2992,4160,-1,4162,2204,2985,-1,4162,2202,2204,-1,4163,2994,4164,-1,2994,4163,2197,-1,4165,2992,2200,-1,4165,4166,2992,-1,2991,4167,4168,-1,2991,2989,4167,-1,4168,2990,2991,-1,4168,4169,2990,-1,2991,2983,2982,-1,2991,2990,2983,-1,2992,4170,4160,-1,4166,4170,2992,-1,2989,2195,4167,-1,2989,2205,2195,-1,2200,2206,4165,-1,2206,2200,2201,-1,4171,2205,2988,-1,2207,2205,4171,-1,4168,4163,2202,-1,4168,4167,4163,-1,4160,4169,4162,-1,4170,4169,4160,-1,4166,4172,4173,-1,4165,4172,4166,-1,2987,2210,2213,-1,2210,2987,2982,-1,2995,7,2932,-1,2995,8,7,-1,4174,2535,2534,-1,2535,4174,4175,-1,2519,2988,2212,-1,2519,4171,2988,-1,2865,2864,2981,-1,4176,2864,2865,-1,2925,3012,2655,-1,2094,3012,2925,-1,3012,2217,2216,-1,3012,2093,2217,-1,4177,2852,4178,-1,4177,2657,2852,-1,2979,2498,4179,-1,2496,2498,2979,-1,4180,4181,4182,-1,4180,2493,4181,-1,4183,2220,2219,-1,2501,2220,4183,-1,2959,2977,4184,-1,2977,2959,2958,-1,4184,4185,2959,-1,4184,2502,4185,-1,2222,4180,2221,-1,2976,4180,2222,-1,302,2586,2883,-1,302,2587,2586,-1,2564,4186,4187,-1,2897,4186,2564,-1,4188,2232,2562,-1,2232,4188,2233,-1,4189,2585,2881,-1,4190,2585,4189,-1,4191,2882,4192,-1,4193,2882,4191,-1,2229,2566,2230,-1,2229,2919,2566,-1,2227,2531,2533,-1,2531,2227,2896,-1,2563,2234,2536,-1,2234,2563,2232,-1,2238,2546,2235,-1,2238,2527,2546,-1,2463,2246,2974,-1,2463,2860,2246,-1,2258,2211,2256,-1,2211,2258,2723,-1,2973,2260,2259,-1,2973,2682,2260,-1,2263,2269,2684,-1,2263,2262,2269,-1,2845,2,2268,-1,2674,2,2845,-1,2262,4194,2270,-1,2262,2271,4194,-1,2262,2264,2271,-1,4194,2968,2270,-1,2970,2968,4194,-1,593,2970,605,-1,593,2968,2970,-1,2683,2972,2688,-1,2683,2684,2972,-1,589,2251,592,-1,2285,2251,589,-1,2285,2283,2251,-1,2448,2842,3803,-1,2448,2446,2842,-1,4195,4196,4197,-1,4195,4198,4196,-1,2666,4199,2966,-1,4199,2666,4200,-1,2966,2602,2599,-1,2966,4199,2602,-1,4195,2042,2601,-1,4195,4197,2042,-1,2287,3670,3797,-1,2287,2289,3670,-1,2986,4201,2295,-1,4202,4201,2986,-1,5,2963,2302,-1,5,2965,2963,-1,5,2291,2965,-1,4202,2116,2962,-1,4202,2123,2116,-1,4202,2154,2123,-1,2287,4201,2290,-1,2287,2667,4201,-1,2300,4161,2985,-1,2300,2964,4161,-1,2964,2302,2963,-1,2964,2300,2302,-1,2288,4203,2289,-1,2288,4204,4203,-1,2295,2667,2298,-1,4201,2667,2295,-1,2627,2308,2981,-1,2310,2308,2627,-1,2652,2960,2832,-1,2960,2652,2961,-1,2830,2713,2828,-1,2711,2713,2830,-1,4205,2650,4206,-1,4207,2650,4205,-1,2712,2855,2710,-1,2649,2855,2712,-1,2716,2653,2714,-1,2853,2653,2716,-1,4208,4185,4183,-1,4208,2707,4185,-1,3202,2729,2731,-1,3202,4209,2729,-1,4210,2926,2928,-1,2926,4210,2736,-1,1792,2695,3174,-1,2503,2695,1792,-1,2325,2836,2692,-1,2326,2836,2325,-1,2702,2326,2321,-1,2836,2326,2702,-1,2737,2956,2734,-1,2737,2954,2956,-1,2366,2396,2367,-1,2366,2397,2396,-1,4211,2953,4212,-1,4211,2952,2953,-1,2345,2931,2346,-1,2931,2345,2376,-1,2373,2479,4213,-1,2479,2373,2371,-1,2948,4214,2949,-1,2948,4215,4214,-1,4216,2369,2368,-1,2370,2369,4216,-1,4217,2372,2374,-1,2372,4217,2365,-1,4218,2377,2375,-1,4218,4219,2377,-1,2352,4219,2353,-1,2364,4219,2352,-1,2350,4218,2374,-1,4218,2350,2349,-1,2949,2335,2378,-1,2949,2336,2335,-1,4214,2952,4211,-1,4214,4216,2952,-1,2356,4215,2948,-1,2356,2361,4215,-1,2380,2947,2930,-1,2383,2947,2380,-1,2344,4220,2950,-1,4220,2344,2384,-1,2946,2338,2390,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_24()
		{
			int[] value = {2338,2946,2337,-1,2930,4221,2391,-1,2947,4221,2930,-1,2387,4222,2945,-1,4222,2387,2394,-1,2426,2337,2946,-1,2426,2951,2337,-1,4212,4223,2941,-1,4212,2953,4223,-1,2347,4224,2929,-1,2347,4213,4224,-1,2993,2208,2468,-1,2208,2993,2199,-1,2477,2944,2470,-1,2477,4225,2944,-1,2481,4213,2479,-1,2481,4224,4213,-1,2515,2899,2557,-1,2899,2515,2514,-1,2517,2557,2559,-1,2517,2515,2557,-1,4226,4227,3777,-1,4226,4228,4227,-1,2511,2911,4229,-1,2511,2509,2911,-1,2900,2557,2899,-1,2900,2558,2557,-1,3707,4230,2892,-1,3707,4231,4230,-1,2573,2419,2418,-1,2573,4232,2419,-1,2572,4233,2891,-1,4234,4233,2572,-1,2570,4226,4235,-1,2570,4228,4226,-1,2513,2388,2941,-1,2388,2513,2516,-1,2421,2940,2406,-1,2421,2516,2940,-1,2938,2765,2942,-1,2938,2766,2765,-1,2760,2385,2386,-1,2385,2760,2808,-1,2428,4236,2814,-1,2428,2427,4236,-1,2691,2434,2433,-1,2691,2937,2434,-1,4237,2816,2936,-1,4237,2817,2816,-1,2748,2826,2725,-1,2748,2819,2826,-1,4236,4221,4238,-1,4222,4221,4236,-1,2438,484,2436,-1,2438,2690,484,-1,2739,1942,2809,-1,2739,1943,1942,-1,2523,2239,2918,-1,2239,2523,2254,-1,2995,2974,2256,-1,2995,2932,2974,-1,2397,2512,2395,-1,2950,2512,2397,-1,2950,4220,2512,-1,2424,2339,2342,-1,2424,2430,2339,-1,2427,2946,2945,-1,2946,2427,2426,-1,2947,4238,4221,-1,2947,2942,4238,-1,4239,4224,2481,-1,4239,2483,4224,-1,2943,4164,2994,-1,2943,4240,4164,-1,2203,3770,33,-1,2203,4241,3770,-1,4241,4242,4243,-1,4242,4241,4240,-1,4225,4242,2944,-1,4225,2486,4242,-1,3771,2485,3747,-1,2485,3771,4243,-1,2487,2929,4244,-1,2487,2348,2929,-1,2487,2351,2348,-1,2474,4245,4246,-1,2474,2473,4245,-1,2359,2476,2478,-1,2359,2477,2476,-1,4246,2939,4247,-1,4246,4245,2939,-1,4247,2409,4248,-1,4247,2939,2409,-1,4248,2411,4249,-1,2411,4248,2409,-1,4250,2481,2480,-1,4250,4239,2481,-1,4244,2482,4251,-1,2482,4244,2929,-1,3953,2411,2410,-1,3953,4075,2411,-1,4250,4072,1781,-1,4072,4250,4249,-1,2296,3767,2475,-1,2296,3795,3767,-1,4177,2090,4142,-1,2090,4177,4178,-1,4252,2092,2091,-1,4252,2901,2092,-1,4253,2091,2497,-1,4253,4252,2091,-1,2496,2494,2497,-1,2496,2491,2494,-1,2504,2906,4254,-1,2906,2504,4255,-1,2923,2506,2543,-1,2923,4256,2506,-1,2977,4256,4184,-1,2319,4256,2977,-1,2543,2505,2541,-1,2543,2506,2505,-1,2221,4257,2222,-1,2221,2500,4257,-1,2500,2221,2220,-1,2551,2499,2923,-1,2551,4258,2499,-1,2543,2922,2923,-1,2542,2922,2543,-1,2422,2392,2389,-1,2913,2392,2422,-1,2393,2902,2921,-1,2902,2393,4259,-1,2467,2510,2512,-1,2903,2510,2467,-1,2238,2214,2524,-1,2212,2214,2238,-1,2550,2520,4260,-1,2520,2550,2525,-1,2522,2920,4261,-1,2528,2920,2522,-1,2531,2529,2532,-1,2531,2919,2529,-1,2998,2917,4158,-1,2917,2998,2137,-1,2186,2178,2185,-1,2178,2186,2109,-1,2177,2915,2183,-1,2173,2915,2177,-1,2914,2175,2172,-1,2914,2916,2175,-1,2224,2552,2490,-1,2224,2230,2552,-1,4259,2398,2907,-1,4259,2913,2398,-1,2508,2537,2912,-1,2537,2508,2507,-1,4229,2910,2554,-1,4229,2911,2910,-1,4110,2537,2908,-1,2537,4110,2910,-1,4255,2909,2538,-1,4255,1835,2909,-1,2540,2904,2905,-1,2540,2539,2904,-1,2398,2548,2545,-1,2400,2548,2398,-1,4257,4260,4261,-1,4257,4258,4260,-1,2222,4261,2920,-1,2222,4257,4261,-1,2920,2223,2222,-1,2530,2223,2920,-1,2183,4262,2553,-1,2915,4262,2183,-1,2901,2914,2180,-1,2901,4252,2914,-1,2415,2554,2567,-1,2415,4229,2554,-1,2407,2419,2575,-1,2407,2420,2419,-1,2407,2408,2420,-1,2575,2547,2518,-1,2577,2547,2575,-1,2895,2227,2226,-1,2895,2896,2227,-1,4263,2187,2565,-1,4263,4159,2187,-1,4154,2997,3001,-1,4154,2194,2997,-1,2191,2099,2102,-1,2191,2579,2099,-1,2579,2191,2193,-1,2897,4264,4186,-1,2897,2560,4264,-1,2225,4189,4193,-1,2225,4188,4189,-1,2895,4265,2565,-1,4265,2895,4266,-1,2890,3000,4263,-1,2888,3000,2890,-1,2192,4153,3004,-1,2192,2894,4153,-1,2886,2850,2661,-1,2886,2084,2850,-1,2571,4267,4268,-1,2571,2569,4267,-1,4234,4226,4233,-1,4234,4235,4226,-1,4230,2576,4232,-1,4269,2576,4230,-1,4270,4264,2574,-1,2884,4264,4270,-1,4190,2586,2585,-1,4190,4187,2586,-1,4266,4192,2879,-1,4266,4191,4192,-1,2880,2890,4265,-1,2889,2890,2880,-1,4155,4152,4157,-1,4151,4152,4155,-1,3003,2580,2893,-1,4271,2580,3003,-1,3876,4267,4272,-1,3709,4267,3876,-1,4228,3711,4227,-1,4228,4268,3711,-1,4269,4231,3703,-1,4269,4230,4231,-1,4270,303,2884,-1,303,4270,3705,-1,3805,2879,4192,-1,294,2879,3805,-1,2889,293,3700,-1,2889,2880,293,-1,4155,4150,4151,-1,4150,4155,4156,-1,3003,3696,4271,-1,3696,3003,4148,-1,2584,3695,3822,-1,2584,2583,3695,-1,2834,2835,2703,-1,2834,2877,2835,-1,4133,2728,2727,-1,4133,4273,2728,-1,3018,2070,2609,-1,2876,2070,3018,-1,2874,2609,2073,-1,2874,1424,2609,-1,2073,2072,2870,-1,2073,2609,2072,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_25()
		{
			int[] value = {2052,2071,2070,-1,2051,2071,2052,-1,2872,2871,2071,-1,3016,2871,2872,-1,2848,3993,2870,-1,1415,3993,2848,-1,2615,1413,2162,-1,2615,1414,1413,-1,2626,2215,2869,-1,2626,4176,2215,-1,2981,2867,2865,-1,2981,4144,2867,-1,2628,2614,2863,-1,2628,2630,2614,-1,2632,2861,2633,-1,2632,2862,2861,-1,2633,2858,2643,-1,2633,2639,2858,-1,2275,2861,2276,-1,2275,2640,2861,-1,2859,2638,2640,-1,2241,2638,2859,-1,2832,2641,2831,-1,2960,2641,2832,-1,2857,2858,2642,-1,2857,2644,2858,-1,3011,2643,2646,-1,2643,3011,2593,-1,4274,2857,2961,-1,4274,2856,2857,-1,4274,2648,2856,-1,4274,2854,2648,-1,4274,2654,2854,-1,2651,2647,2856,-1,4275,2647,2651,-1,2306,4275,4207,-1,4275,2306,2618,-1,2853,2854,2654,-1,2853,2855,2854,-1,2851,4179,2852,-1,2851,4145,4179,-1,2613,2087,2079,-1,2093,2613,2217,-1,2613,2093,2087,-1,3584,2035,2086,-1,12,2035,3584,-1,4200,3675,4198,-1,4200,3677,3675,-1,3669,4196,3672,-1,4203,4196,3669,-1,2678,3014,2847,-1,2678,2063,3014,-1,2060,2069,3006,-1,2069,2060,2068,-1,2845,2846,2067,-1,2845,2679,2846,-1,0,2674,2676,-1,2,2674,0,-1,2842,2589,2284,-1,2842,2841,2589,-1,2589,2840,2590,-1,2840,2589,2841,-1,2686,2443,2747,-1,2686,2439,2443,-1,2840,2435,2686,-1,2839,2435,2840,-1,2839,2433,2435,-1,2434,2758,2440,-1,2434,2937,2758,-1,2744,2442,2445,-1,2757,2442,2744,-1,2757,2934,2442,-1,4276,2456,2838,-1,2456,4276,2457,-1,2837,2460,2462,-1,2837,2838,2460,-1,2838,4277,4276,-1,2837,4277,2838,-1,1947,4277,3203,-1,1947,2824,4277,-1,1433,4273,4133,-1,1433,1432,4273,-1,2697,2878,2698,-1,2697,2835,2878,-1,4278,2833,2719,-1,4279,2833,4278,-1,4208,2719,2721,-1,4278,2719,4208,-1,2219,4279,4278,-1,4182,4279,2219,-1,2705,4181,2980,-1,2705,2704,4181,-1,4206,2303,4205,-1,4206,2304,2303,-1,2828,2722,2830,-1,2828,2829,2722,-1,2755,2715,4280,-1,2715,2755,2827,-1,2831,2826,4281,-1,2831,2244,2826,-1,2244,2831,2975,-1,2329,2311,2314,-1,2329,2316,2311,-1,2825,2333,2699,-1,4282,2333,2825,-1,2957,4273,4282,-1,2957,2728,4273,-1,2955,4210,4209,-1,2955,2954,4210,-1,2736,2954,2737,-1,2954,2736,4210,-1,2329,2877,2834,-1,2329,2331,2877,-1,2742,2823,2740,-1,2824,2823,2742,-1,2740,2738,2812,-1,2740,2823,2738,-1,4280,2818,2820,-1,4280,4281,2818,-1,2822,2313,2750,-1,2822,2926,2313,-1,2718,2753,2751,-1,2753,2718,2720,-1,2720,2829,2753,-1,2829,2720,2722,-1,2772,2820,2818,-1,2772,2807,2820,-1,2748,2935,2451,-1,2749,2935,2748,-1,2749,2936,2935,-1,4237,2747,2443,-1,4237,2745,2747,-1,2813,2451,2935,-1,2454,2451,2813,-1,2810,2738,2739,-1,2810,2812,2738,-1,2783,2809,2933,-1,2783,2811,2809,-1,2763,2810,2811,-1,2763,2759,2810,-1,2776,2807,2777,-1,2776,2821,2807,-1,2779,2804,2750,-1,2805,2804,2779,-1,2778,2805,2779,-1,2778,2803,2805,-1,2806,2775,2782,-1,2775,2806,2803,-1,2773,2781,2774,-1,2773,2780,2781,-1,2789,1756,2792,-1,2787,1756,2789,-1,2796,2797,2795,-1,2796,2802,2797,-1,2801,2793,4283,-1,2793,2801,2796,-1,2799,2794,1750,-1,2799,2800,2794,-1,2806,2797,2804,-1,2797,2806,2798,-1,2802,2927,2822,-1,2801,2927,2802,-1,4283,2730,2732,-1,2800,2730,4283,-1,2801,2732,2927,-1,4283,2732,2801,-1,2804,2802,2822,-1,2802,2804,2797,-1,2782,2798,2806,-1,2798,2782,2788,-1,2793,2800,4283,-1,2794,2800,2793,-1,2788,2795,2798,-1,2788,2789,2795,-1,2783,2785,2784,-1,2933,2785,2783,-1,2781,2764,2784,-1,2764,2781,2780,-1,2770,2780,2773,-1,2762,2780,2770,-1,2752,2776,2779,-1,2776,2752,2821,-1,2774,2771,2773,-1,2774,2777,2771,-1,2770,2765,2762,-1,2770,2768,2765,-1,2763,2760,2759,-1,2763,2808,2760,-1,2811,2764,2763,-1,2811,2783,2764,-1,2744,2449,2757,-1,2743,2449,2744,-1,2745,2936,2749,-1,2745,4237,2936,-1,2829,2754,2753,-1,2829,2755,2754,-1,2754,2821,2752,-1,2754,2756,2821,-1,2312,2718,2751,-1,2718,2312,2318,-1,4280,2756,2755,-1,2756,4280,2820,-1,2819,4281,2826,-1,2818,4281,2819,-1,2440,2450,2817,-1,2440,2758,2450,-1,2741,2812,2743,-1,2741,2740,2812,-1,2823,1939,2738,-1,2823,1940,1939,-1,2785,1978,1856,-1,2933,1978,2785,-1,2316,2834,2317,-1,2316,2329,2834,-1,2331,2878,2877,-1,2331,2735,2878,-1,2698,2735,2733,-1,2878,2735,2698,-1,2734,2825,2733,-1,2734,2956,2825,-1,2729,2927,2732,-1,2928,2927,2729,-1,2015,2730,2018,-1,2731,2730,2015,-1,2955,2728,2957,-1,2726,2728,2955,-1,2956,4282,2825,-1,2956,2957,4282,-1,1432,4282,4273,-1,1432,2333,4282,-1,4281,2715,2831,-1,4281,4280,2715,-1,2833,2830,2719,-1,2830,2833,2305,-1,2708,2720,2718,-1,2721,2720,2708,-1,2304,2712,2711,-1,2712,2304,4206,-1,2706,4205,2303,-1,4205,2706,2307,-1,4143,2980,2979,-1,4143,2705,2980,-1,4182,2704,4279,-1,4181,2704,4182,-1,4278,4183,2219,-1,4278,4208,4183,-1,2721,2707,4208,-1,2721,2708,2707,-1,2303,4279,2704,-1,2303,2833,4279,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_26()
		{
			int[] value = {2699,2334,2696,-1,2333,2334,2699,-1,2694,3174,2695,-1,2694,1431,3174,-1,2837,3203,4277,-1,3203,2837,145,-1,2824,4276,4277,-1,2824,2742,4276,-1,2457,2742,2445,-1,2457,4276,2742,-1,2937,2757,2758,-1,2937,2934,2757,-1,2747,2687,2686,-1,2747,2746,2687,-1,2839,2841,2447,-1,2839,2840,2841,-1,2283,2284,2589,-1,2283,2285,2284,-1,2688,2282,2590,-1,2972,2282,2688,-1,2972,2971,2282,-1,2746,2278,2687,-1,2258,2278,2746,-1,2278,2258,2257,-1,3006,2846,2274,-1,2846,3006,2069,-1,2289,3669,3670,-1,2289,4203,3669,-1,4198,3672,4196,-1,4198,3675,3672,-1,2665,4200,2666,-1,4200,2665,3677,-1,4146,2218,2866,-1,3012,2218,4146,-1,3012,2216,2218,-1,2979,4145,4143,-1,4179,4145,2979,-1,4207,2651,2650,-1,2651,4207,4275,-1,2618,2647,4275,-1,2618,2645,2647,-1,2654,2961,2652,-1,2654,4274,2961,-1,2646,4147,3011,-1,2646,2645,4147,-1,2960,2642,2641,-1,2857,2642,2960,-1,2641,2975,2831,-1,2641,2255,2975,-1,2163,2158,3013,-1,2163,2159,2158,-1,2636,2105,2616,-1,2636,2635,2105,-1,2614,2624,2612,-1,2614,2630,2624,-1,2625,2619,2627,-1,2625,2622,2619,-1,2308,4144,2981,-1,2308,2709,4144,-1,4176,2625,2864,-1,2625,4176,2626,-1,2626,2612,2624,-1,2612,2626,2869,-1,4147,2618,2617,-1,2645,2618,4147,-1,2870,2074,2073,-1,3993,2074,2870,-1,2871,2072,2071,-1,2072,2871,2870,-1,2874,3208,3207,-1,2873,3208,2874,-1,1428,2662,2029,-1,2662,1428,2033,-1,2609,1426,3018,-1,2609,1424,1426,-1,3,2048,6,-1,2048,3,2265,-1,2600,2602,2595,-1,2602,2600,2599,-1,2603,2038,3026,-1,2603,2039,2038,-1,2639,2642,2858,-1,2642,2639,2638,-1,2885,3692,2085,-1,3692,2885,3693,-1,3695,4271,3696,-1,3695,2583,4271,-1,3697,3002,4149,-1,3699,3002,3697,-1,3700,2887,2889,-1,3701,2887,3700,-1,3703,4270,4269,-1,3705,4270,3703,-1,3706,2892,2891,-1,3707,2892,3706,-1,3709,4268,4267,-1,3711,4268,3709,-1,4271,2581,2580,-1,2583,2581,4271,-1,3004,4149,3002,-1,3004,4153,4149,-1,4265,2879,2880,-1,4265,4266,2879,-1,2882,4189,2881,-1,2882,4193,4189,-1,2884,4186,4264,-1,2883,4186,2884,-1,2574,4269,4270,-1,2574,2576,4269,-1,4268,2570,2571,-1,4228,2570,4268,-1,2569,4272,4267,-1,2569,2568,4272,-1,2582,2578,2581,-1,2582,2660,2578,-1,4157,4154,3001,-1,4152,4154,4157,-1,4265,4263,2565,-1,2890,4263,4265,-1,2226,4266,2895,-1,4266,2226,4191,-1,2562,4187,4190,-1,2562,2564,4187,-1,2560,2574,4264,-1,2560,2577,2574,-1,4232,2575,2419,-1,2576,2575,4232,-1,4235,2900,2417,-1,4234,2900,4235,-1,2569,2556,2567,-1,2571,2556,2569,-1,3000,4159,4263,-1,3000,2999,4159,-1,2225,2233,4188,-1,2225,2228,2233,-1,2577,2235,2547,-1,2560,2235,2577,-1,2560,2236,2235,-1,2518,2407,2575,-1,2518,2404,2407,-1,4252,2916,2914,-1,4252,4253,2916,-1,2552,2183,2553,-1,2183,2552,2184,-1,2490,2976,2224,-1,2490,2492,2976,-1,4260,2551,2550,-1,4260,4258,2551,-1,2907,2545,2544,-1,2398,2545,2907,-1,2541,2544,2542,-1,2544,2541,2905,-1,2540,4255,2538,-1,2540,2906,4255,-1,2910,2555,2554,-1,2910,4110,2555,-1,2904,4259,2907,-1,2902,4259,2904,-1,2915,4253,4262,-1,2916,4253,2915,-1,4158,2109,2186,-1,2109,4158,2917,-1,2135,2190,2155,-1,2135,2998,2190,-1,2137,2998,2135,-1,2520,4261,4260,-1,2522,4261,2520,-1,2526,2525,2550,-1,2525,2526,2524,-1,2521,2525,2466,-1,2525,2521,2520,-1,2528,2523,2918,-1,2522,2523,2528,-1,2413,4223,2395,-1,2413,2412,4223,-1,2510,2511,2512,-1,2509,2511,2510,-1,2903,2507,2510,-1,2507,2903,2539,-1,2393,2913,4259,-1,2393,2392,2913,-1,2922,2551,2923,-1,2922,2549,2551,-1,2500,4258,4257,-1,2499,4258,2500,-1,2976,2493,4180,-1,2976,2492,2493,-1,2506,2319,2322,-1,2506,4256,2319,-1,2502,4256,2923,-1,2502,4184,4256,-1,2505,2323,4254,-1,2505,2324,2323,-1,4254,2541,2505,-1,4254,2906,2541,-1,4254,2503,2504,-1,4254,2323,2503,-1,1791,4255,2504,-1,1835,4255,1791,-1,2553,2494,2490,-1,2494,2553,4262,-1,4262,2497,2494,-1,2497,4262,4253,-1,2498,2090,4178,-1,2091,2090,2498,-1,2901,2103,2092,-1,2901,2101,2103,-1,3747,2487,3748,-1,2487,3747,2485,-1,2297,2472,2471,-1,2472,2297,2296,-1,4251,2484,4069,-1,2484,4251,2482,-1,1781,4239,4250,-1,1775,4239,1781,-1,4249,4075,4072,-1,4075,4249,2411,-1,3756,4251,3757,-1,4251,3756,4244,-1,2929,2483,2482,-1,2929,4224,2483,-1,2480,4249,4250,-1,4249,2480,4248,-1,3757,4069,3761,-1,4069,3757,4251,-1,2478,4248,2480,-1,2478,4247,4248,-1,2939,3763,509,-1,4245,3763,2939,-1,2476,4247,2478,-1,2476,4246,4247,-1,3763,2473,3766,-1,2473,3763,4245,-1,2469,4246,2476,-1,2469,2474,4246,-1,2475,3766,2473,-1,2475,3767,3766,-1,2474,2471,2472,-1,2471,2474,2469,-1,3748,4244,3756,-1,3748,2487,4244,-1,4243,2486,2485,-1,2486,4243,4242,-1,3770,4243,3771,-1,4243,3770,4241,-1,4240,2944,4242,-1,2944,4240,2943,-1,4164,4241,2203,-1,4240,4241,4164,-1,2483,1775,1774,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_27()
		{
			int[] value = {4239,1775,2483,-1,2945,4236,2427,-1,2945,4222,4236,-1,2343,2941,2388,-1,2343,4212,2941,-1,2512,2381,2467,-1,4220,2381,2512,-1,2211,2984,2256,-1,2210,2984,2211,-1,2974,2465,2463,-1,2932,2465,2974,-1,2242,2918,2239,-1,2242,2532,2918,-1,2460,2461,2462,-1,2458,2461,2460,-1,2819,2451,2453,-1,2748,2451,2819,-1,2432,2743,2761,-1,2432,2449,2743,-1,2436,2444,2437,-1,2436,2455,2444,-1,2443,2817,4237,-1,2440,2817,2443,-1,2816,2813,2935,-1,2816,2815,2813,-1,2432,2424,2423,-1,2432,2430,2424,-1,2767,2942,2768,-1,2942,2767,4238,-1,2814,4238,2767,-1,4236,4238,2814,-1,2412,2941,4223,-1,2402,2941,2412,-1,3777,4233,4226,-1,3777,3779,4233,-1,2570,2417,2416,-1,2570,4235,2417,-1,3779,2891,4233,-1,3779,3706,2891,-1,2558,4234,2572,-1,2900,4234,2558,-1,2573,4230,4232,-1,2573,2892,4230,-1,2413,4229,2415,-1,2413,2511,4229,-1,2912,2509,2508,-1,2509,2912,2911,-1,2940,2559,2898,-1,2559,2940,2517,-1,2358,2477,2359,-1,2477,2358,4225,-1,2358,2486,4225,-1,2355,2486,2358,-1,2953,2395,4223,-1,2953,2396,2395,-1,2342,2426,2424,-1,2951,2426,2342,-1,2921,2391,2393,-1,2930,2391,2921,-1,4222,2391,4221,-1,4222,2394,2391,-1,2390,2343,2388,-1,2390,2338,2343,-1,2344,2386,2384,-1,2344,2429,2386,-1,2344,2346,2429,-1,4220,2382,2381,-1,4220,2384,2382,-1,2370,2361,2362,-1,2370,4215,2361,-1,2379,2340,2377,-1,2379,2341,2340,-1,4217,2376,2345,-1,4217,2375,2376,-1,2372,2371,2373,-1,2372,2369,2371,-1,2952,2368,2367,-1,4216,2368,2952,-1,2949,4211,2336,-1,2949,4214,4211,-1,2345,2365,4217,-1,2365,2345,2366,-1,2349,4219,4218,-1,4219,2349,2353,-1,2364,2377,4219,-1,2364,2379,2377,-1,2375,2374,4218,-1,2374,2375,4217,-1,4215,4216,4214,-1,4215,2370,4216,-1,2350,4213,2347,-1,4213,2350,2373,-1,2359,2356,2358,-1,2359,2361,2356,-1,2355,2352,2354,-1,2355,2357,2352,-1,2351,2349,2348,-1,2351,2353,2349,-1,2950,2345,2344,-1,2950,2366,2345,-1,2376,2339,2931,-1,2339,2376,2340,-1,2342,2335,2951,-1,2341,2335,2342,-1,2336,4212,2343,-1,2336,4211,4212,-1,4209,2726,2955,-1,2726,4209,3202,-1,2319,2978,2320,-1,2319,2977,2978,-1,2320,2958,2328,-1,2320,2978,2958,-1,2312,2316,2318,-1,2311,2316,2312,-1,2928,4209,4210,-1,4209,2928,2729,-1,2707,2959,4185,-1,2707,2328,2959,-1,2714,2652,2832,-1,2653,2652,2714,-1,4206,2649,2712,-1,2650,2649,4206,-1,4207,2307,2306,-1,4207,4205,2307,-1,2305,2711,2830,-1,2304,2711,2305,-1,2828,2717,2827,-1,2713,2717,2828,-1,2875,4204,2288,-1,4204,2875,2041,-1,2668,2296,2298,-1,2668,3795,2296,-1,2986,2297,2208,-1,2986,2295,2297,-1,2294,2964,2292,-1,2964,2294,4161,-1,5,757,3,-1,5,3796,757,-1,2667,3797,2669,-1,2667,2287,3797,-1,4201,2962,2290,-1,2962,4201,4202,-1,2302,3796,5,-1,3796,2302,2299,-1,2986,2154,4202,-1,2154,2986,2292,-1,4204,2042,4197,-1,4204,2041,2042,-1,4199,2601,2602,-1,4199,4195,2601,-1,4199,4198,4195,-1,4199,4200,4198,-1,4204,4196,4203,-1,4204,4197,4196,-1,2286,2842,2284,-1,2286,3803,2842,-1,2272,2973,2969,-1,2272,2843,2973,-1,2683,2687,2278,-1,2683,2688,2687,-1,2271,2267,4194,-1,2271,2273,2267,-1,2266,4194,2267,-1,2266,2970,4194,-1,2067,2674,2845,-1,2675,2674,2067,-1,2066,2063,2678,-1,2063,2066,2064,-1,2250,2971,2269,-1,2250,2252,2971,-1,2682,2264,2263,-1,2843,2264,2682,-1,2249,2261,2260,-1,2247,2261,2249,-1,2209,2723,2243,-1,2209,2211,2723,-1,2255,2245,2975,-1,2254,2245,2255,-1,2860,2242,2859,-1,2463,2242,2860,-1,2588,2881,2585,-1,298,2881,2588,-1,2237,2561,2536,-1,2237,2236,2561,-1,2233,2533,2234,-1,2533,2233,2228,-1,2919,2896,2566,-1,2919,2531,2896,-1,2224,2231,2230,-1,2224,2223,2231,-1,2226,4193,4191,-1,2225,4193,2226,-1,4192,297,3805,-1,2882,297,4192,-1,4188,4190,4189,-1,2562,4190,4188,-1,4187,2883,2586,-1,4186,2883,4187,-1,2502,4183,4185,-1,2502,2501,4183,-1,2221,4182,2219,-1,2221,4180,4182,-1,2980,2493,2491,-1,2493,2980,4181,-1,4179,4178,2852,-1,2498,4178,4179,-1,2655,4177,2925,-1,4177,2655,2657,-1,4146,2655,3012,-1,4146,2658,2655,-1,2218,4176,2865,-1,2218,2215,4176,-1,2212,2987,2213,-1,2212,2988,2987,-1,4175,2519,2535,-1,2519,4175,4171,-1,2932,4174,2534,-1,2932,7,4174,-1,2213,2209,2466,-1,2213,2210,2209,-1,2208,2293,2292,-1,2208,2198,2293,-1,4172,2206,2207,-1,2206,4172,4165,-1,4166,9,4170,-1,4166,4173,9,-1,2202,4169,4168,-1,4169,2202,4162,-1,4175,2207,4171,-1,4172,2207,4175,-1,7,4173,4174,-1,9,4173,7,-1,4170,2990,4169,-1,4170,9,2990,-1,4167,2197,4163,-1,4167,2195,2197,-1,4173,4175,4174,-1,4173,4172,4175,-1,2203,4163,4164,-1,2203,2202,4163,-1,4161,4162,2985,-1,4161,4160,4162,-1,2998,2194,2190,-1,2998,2997,2194,-1,4159,2186,2187,-1,4158,2186,4159,-1,2887,4157,2888,-1,2887,4155,4157,-1,2894,2194,4154,-1,2194,2894,2188,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_28()
		{
			int[] value = {4153,4151,4149,-1,4152,4151,4153,-1,2171,2181,2180,-1,2165,2181,2171,-1,2176,2862,2632,-1,2862,2176,2111,-1,2635,2174,2634,-1,2635,2169,2174,-1,2166,2636,2637,-1,2636,2166,2170,-1,2631,2168,2158,-1,2631,3005,2168,-1,2173,2176,2174,-1,2177,2176,2173,-1,2172,2174,2169,-1,2175,2174,2172,-1,3013,2166,2637,-1,3013,2167,2166,-1,2057,2163,2056,-1,2163,2057,2159,-1,2156,3005,2111,-1,2156,2128,3005,-1,2121,2154,2963,-1,2121,2120,2154,-1,2141,2152,2150,-1,2139,2152,2141,-1,2140,3009,2149,-1,2140,2151,3009,-1,2144,3008,2142,-1,2144,2145,3008,-1,2117,2139,2141,-1,2139,2117,2119,-1,2133,2152,2143,-1,2152,2133,2132,-1,2136,2150,3010,-1,2151,2150,2136,-1,2156,2133,2129,-1,2156,2134,2133,-1,2131,2124,2127,-1,2130,2124,2131,-1,2123,2119,2117,-1,2119,2123,2120,-1,4,2146,2291,-1,4,2147,2146,-1,2625,2629,2622,-1,2625,2624,2629,-1,2617,2620,4147,-1,2617,2621,2620,-1,2656,2867,2851,-1,2866,2867,2656,-1,2709,4145,4144,-1,2709,4143,4145,-1,2925,4142,2924,-1,4142,2925,4177,-1,2098,2100,2099,-1,2098,2495,2100,-1,2032,2081,2850,-1,2082,2081,2032,-1,2080,2088,2495,-1,2088,2080,2079,-1,2097,2659,2606,-1,2097,2096,2659,-1,4142,2092,2103,-1,4142,2090,2092,-1,2089,2104,2088,-1,2089,2924,2104,-1,2084,2032,2850,-1,2084,2030,2032,-1,3692,2086,2085,-1,3692,3584,2086,-1,3822,2885,2584,-1,3693,2885,3822,-1,2605,1420,2608,-1,2605,1422,1420,-1,3016,2849,2871,-1,2849,3016,2670,-1,2061,2066,2068,-1,2064,2066,2061,-1,2065,2061,2059,-1,2065,2064,2061,-1,2055,3006,2680,-1,2060,3006,2055,-1,2045,2671,3020,-1,2045,2044,2671,-1,2872,2050,3015,-1,2050,2872,2051,-1,2673,2043,2059,-1,2043,2673,2044,-1,3021,3015,2050,-1,3025,3015,3021,-1,2966,2028,2967,-1,2028,2966,2599,-1,2033,1427,2031,-1,2033,1428,1427,-1,3026,3025,3021,-1,3026,2038,3025,-1,11,2664,2663,-1,11,10,2664,-1,4138,2025,2027,-1,4138,2026,2025,-1,2013,4138,2027,-1,2013,2014,4138,-1,2016,2799,2025,-1,2016,2018,2799,-1,4140,2021,3027,-1,1754,2021,4140,-1,2023,4141,2027,-1,2023,3029,4141,-1,3048,3029,3028,-1,3048,4141,3029,-1,2022,4140,2023,-1,2022,4139,4140,-1,1752,2790,2022,-1,1752,1751,2790,-1,2021,1856,1979,-1,2021,2020,1856,-1,4138,2012,3180,-1,4138,2014,2012,-1,4132,3200,4010,-1,4132,4131,3200,-1,1622,1431,2010,-1,3174,1431,1622,-1,2007,2008,2004,-1,2009,2008,2007,-1,3042,2000,2011,-1,3042,2001,2000,-1,2002,4137,2003,-1,2002,3179,4137,-1,4137,4014,4011,-1,4137,4136,4014,-1,4136,4135,4134,-1,4136,3178,4135,-1,1996,1609,4135,-1,1996,1998,1609,-1,1433,2010,1431,-1,1433,3043,2010,-1,3044,2727,4131,-1,3044,4133,2727,-1,4132,3041,3045,-1,4132,3036,3041,-1,1994,4129,1991,-1,1994,4130,4129,-1,3048,1597,1596,-1,3048,3047,1597,-1,1604,1997,1999,-1,1604,1601,1997,-1,4129,1992,1991,-1,1992,4129,3053,-1,1897,1987,1895,-1,1987,1897,1985,-1,3056,1478,3055,-1,1478,3056,1477,-1,1857,1759,1980,-1,1759,1857,1497,-1,4020,4015,4026,-1,4020,4013,4015,-1,4027,1612,1892,-1,1612,4027,1613,-1,4119,1630,4126,-1,4119,4118,1630,-1,1631,3089,3170,-1,1631,3090,3089,-1,1650,1796,1669,-1,1796,1650,1652,-1,1975,4086,1972,-1,4086,1975,4084,-1,1975,3847,3848,-1,3847,1975,1973,-1,1671,3062,1968,-1,1671,4039,3062,-1,1973,3851,3847,-1,1973,4052,3851,-1,4125,3361,4124,-1,3361,4125,3854,-1,4080,4125,1858,-1,3136,4125,4080,-1,1860,4053,4050,-1,1860,4124,4053,-1,3064,1515,1512,-1,1515,3064,4123,-1,1961,1511,1965,-1,1511,1961,1505,-1,1950,3065,1948,-1,1950,1962,3065,-1,3066,1960,1959,-1,3066,3065,1960,-1,1957,1522,1960,-1,1522,1957,1523,-1,1956,1952,1951,-1,1956,4005,1952,-1,1932,1951,1954,-1,1932,1955,1951,-1,1932,3071,1955,-1,1949,1963,1950,-1,1949,4122,1963,-1,1961,1506,1505,-1,1963,1506,1961,-1,3203,1946,1947,-1,3203,1508,1946,-1,1481,1500,1483,-1,3145,1500,1481,-1,4122,1481,1480,-1,1481,4122,3145,-1,1944,1938,1937,-1,1944,1949,1938,-1,3076,1930,1932,-1,1930,3076,1559,-1,1547,1927,1625,-1,1547,3181,1927,-1,3075,1983,1623,-1,3075,1990,1983,-1,1922,1911,1908,-1,1919,1911,1922,-1,1471,3076,3077,-1,1471,1470,3076,-1,3185,1922,3183,-1,1922,3185,1920,-1,1561,3192,4007,-1,1561,1549,3192,-1,1910,4120,1908,-1,4120,1910,1579,-1,1572,1576,1571,-1,1916,1576,1572,-1,1567,1578,1577,-1,1566,1578,1567,-1,4117,3191,4008,-1,4117,4121,3191,-1,4121,1910,1909,-1,4121,4117,1910,-1,1908,3183,1922,-1,4120,3183,1908,-1,3080,3060,1907,-1,4049,3060,3080,-1,3167,1872,1874,-1,3167,3166,1872,-1,3168,3093,4009,-1,3168,1879,3093,-1,4038,1904,3085,-1,4038,3173,1904,-1,1901,1642,3094,-1,1643,1642,1901,-1,1896,1585,1888,-1,1627,1585,1896,-1,1993,3087,3050,-1,3087,1993,1986,-1,4119,1615,3050,-1,4119,4017,1615,-1,1890,1608,1611,-1,1890,1606,1608,-1,4012,1610,1891,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_29()
		{
			int[] value = {4134,1610,4012,-1,1627,1895,1628,-1,1627,1896,1895,-1,3084,1884,1878,-1,1882,1884,3084,-1,1591,1873,1564,-1,1873,1591,1871,-1,1873,3082,1874,-1,1871,3082,1873,-1,1871,1587,3082,-1,1587,1871,1588,-1,4049,1859,4051,-1,1859,4049,3080,-1,3171,1639,4037,-1,3171,1866,1639,-1,3094,4036,1641,-1,1642,4036,3094,-1,1641,1886,3094,-1,1641,1865,1886,-1,1858,3141,4080,-1,1858,1539,3141,-1,4272,3875,3876,-1,4272,4116,3875,-1,3879,4003,4115,-1,3881,4003,3879,-1,3883,4114,4113,-1,3885,4114,3883,-1,4116,2568,1850,-1,4272,2568,4116,-1,3096,3100,3099,-1,3095,3100,3096,-1,4001,4115,4003,-1,4001,4112,4115,-1,4113,1845,1847,-1,4114,1845,4113,-1,4112,3193,4111,-1,4001,3193,4112,-1,1840,3108,1844,-1,1840,1839,3108,-1,1826,3098,3097,-1,1826,1827,3098,-1,4111,1436,1824,-1,3193,1436,4111,-1,1846,1825,3110,-1,3101,1825,1846,-1,2555,1837,1840,-1,2555,4110,1837,-1,3106,4109,3128,-1,4109,3106,1829,-1,1834,2908,2909,-1,1834,1833,2908,-1,1832,1837,1833,-1,1837,1832,1838,-1,1831,4107,4108,-1,4107,1831,1821,-1,3111,1831,1828,-1,1819,1831,3111,-1,1818,1839,1838,-1,1839,1818,1440,-1,1822,3115,1823,-1,3115,1822,3117,-1,1822,1820,3112,-1,1820,1822,1809,-1,1821,1813,4107,-1,1821,1815,1813,-1,4106,1814,1815,-1,4106,4063,1814,-1,1734,1813,1735,-1,1743,1813,1734,-1,1811,4063,4106,-1,4063,1811,1812,-1,1809,4106,1820,-1,4106,1809,1811,-1,1676,1741,1740,-1,1741,1676,1807,-1,4092,3112,3111,-1,4092,3118,3112,-1,4097,1828,1830,-1,4095,1828,4097,-1,4021,4096,4019,-1,4096,4021,4030,-1,4105,4094,4093,-1,4094,4105,4101,-1,4104,3119,4100,-1,3120,3119,4104,-1,3116,4102,1842,-1,3116,4103,4102,-1,4102,1663,1798,-1,4102,1664,1663,-1,1803,4103,4104,-1,4041,4103,1803,-1,4104,1801,1803,-1,4100,1801,4104,-1,3125,4101,4105,-1,4099,4101,3125,-1,4031,4105,4029,-1,4031,3125,4105,-1,4023,4028,4022,-1,4028,4023,4035,-1,4035,4025,4033,-1,4035,4023,4025,-1,1633,3126,1800,-1,3126,1633,4042,-1,1669,4040,1977,-1,1665,4040,1669,-1,4095,4098,4093,-1,4095,4097,4098,-1,1654,1801,4099,-1,1801,1654,1802,-1,4045,3102,4043,-1,4045,4090,3102,-1,4048,1799,1797,-1,4048,3104,1799,-1,3922,4044,4087,-1,3924,4044,3922,-1,4047,4089,4046,-1,4089,4047,4081,-1,3106,3122,3107,-1,3106,4018,3122,-1,4084,3930,4085,-1,3932,3930,4084,-1,4088,3922,4087,-1,4088,3934,3922,-1,4083,4085,4088,-1,4083,3129,4085,-1,3131,4086,3129,-1,3131,3061,4086,-1,4081,4083,4089,-1,4082,4083,4081,-1,1658,3131,1656,-1,3131,1658,3061,-1,1933,3071,1931,-1,1933,3067,3071,-1,1785,3137,3134,-1,1785,1784,3137,-1,3133,1526,1776,-1,1526,3133,1768,-1,4070,1724,1464,-1,4070,1773,1724,-1,4071,1464,4076,-1,1464,4071,4070,-1,1771,4079,1770,-1,4079,1771,3139,-1,4074,4077,3996,-1,4077,4074,4073,-1,1770,4080,3141,-1,1770,4079,4080,-1,3138,3996,4077,-1,3996,3138,3995,-1,4076,1722,1765,-1,4076,1464,1722,-1,3952,4075,3953,-1,4075,3952,4073,-1,1781,4074,1782,-1,1781,4072,4074,-1,2484,1773,4070,-1,2484,1774,1773,-1,3954,4076,3955,-1,3954,4071,4076,-1,1767,4066,1761,-1,1767,3143,4066,-1,1769,3141,3142,-1,1769,1770,3141,-1,3957,1780,3958,-1,3957,4068,1780,-1,3156,1765,1722,-1,3156,1763,1765,-1,3156,1761,4066,-1,3156,1760,1761,-1,4067,1766,1763,-1,1766,4067,3962,-1,1535,1769,1528,-1,1533,1769,1535,-1,1497,1757,1759,-1,3148,1757,1497,-1,1730,1479,1733,-1,1730,1475,1479,-1,4059,4064,4061,-1,4059,4062,4064,-1,1755,2022,2790,-1,1755,4139,2022,-1,1674,3149,1672,-1,1674,4058,3149,-1,4057,4061,4064,-1,4057,4060,4061,-1,1759,1733,1479,-1,1758,1733,1759,-1,4056,1676,1805,-1,4056,1677,1676,-1,4065,1734,1731,-1,4065,1742,1734,-1,1758,1731,1733,-1,1758,4065,1731,-1,1732,1814,4062,-1,1732,1735,1814,-1,1812,4064,4063,-1,4057,4064,1812,-1,1476,4061,3196,-1,4059,4061,1476,-1,1474,1674,1675,-1,1474,3195,1674,-1,4058,3197,4060,-1,4058,3998,3197,-1,1677,1717,1726,-1,1677,4056,1717,-1,3162,1737,1736,-1,1737,3162,1718,-1,1681,3163,1679,-1,1681,4054,3163,-1,3153,3641,1693,-1,3641,3153,1727,-1,1726,1719,4055,-1,1719,1726,1717,-1,1718,1708,1706,-1,1708,1718,3162,-1,1719,1707,1705,-1,1719,1706,1707,-1,3641,3640,3639,-1,3641,4055,3640,-1,1697,1700,1702,-1,1699,1700,1697,-1,1703,1709,1694,-1,1712,1709,1703,-1,1707,1690,1457,-1,1707,1689,1690,-1,3997,1696,1698,-1,3164,1696,3997,-1,1696,1716,1699,-1,3161,1716,1696,-1,1737,1805,1738,-1,1737,4056,1805,-1,3131,4082,1656,-1,3131,3130,4082,-1,1667,3127,1797,-1,3127,1667,1666,-1,3063,4053,4052,-1,4050,4053,3063,-1,4051,1969,4049,-1,4051,1970,1969,-1,3060,4039,1651,-1,3062,4039,3060,-1,4048,4046,4043,-1,4047,4046,4048,-1,3924,4045,4044,-1,3924,3978,4045,-1,1788,1666,1659,-1,1789,1666,1788,-1,1802,4042,1803,-1,1802,3126,4042,-1,4040,1664,4041,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_30()
		{
			int[] value = {1664,4040,1665,-1,1665,1662,1663,-1,1662,1665,1660,-1,1794,1659,1661,-1,1788,1659,1794,-1,1655,4099,3125,-1,1654,4099,1655,-1,1651,1976,1652,-1,1976,1651,4039,-1,1638,3085,1880,-1,4038,3085,1638,-1,1642,3172,4036,-1,1642,1644,3172,-1,1637,4038,1638,-1,1637,1647,4038,-1,4037,1641,4036,-1,4037,1639,1641,-1,1865,1887,1584,-1,1640,1887,1865,-1,1866,3086,1885,-1,3089,3086,1866,-1,4034,4126,1630,-1,4033,4126,4034,-1,4035,4031,4028,-1,4035,4032,4031,-1,4030,4098,4096,-1,4030,4029,4098,-1,4127,4033,4025,-1,4033,4127,4126,-1,4022,4026,4023,-1,4022,4020,4026,-1,3059,4019,3038,-1,4021,4019,3059,-1,3123,2007,2006,-1,3123,3122,2007,-1,1619,1620,2008,-1,1620,1619,1618,-1,4127,1892,4017,-1,4127,4027,1892,-1,4027,4025,4024,-1,4027,4127,4025,-1,3046,4128,1603,-1,3049,4128,3046,-1,3088,3049,1893,-1,3088,4128,3049,-1,4016,1611,1613,-1,1890,1611,4016,-1,1891,4013,4012,-1,1891,4015,4013,-1,4011,3058,3037,-1,3058,4011,4014,-1,4010,2017,3032,-1,4010,3200,2017,-1,1997,3176,1998,-1,1997,3177,3176,-1,4130,3028,3051,-1,3047,3028,4130,-1,3074,1551,1550,-1,3074,3073,1551,-1,1875,3093,3092,-1,1875,1872,3093,-1,3166,1594,4009,-1,1594,3166,1595,-1,1561,1877,1550,-1,1561,3182,1877,-1,3190,1587,1589,-1,3083,1587,3190,-1,1925,1536,1541,-1,1536,1925,1924,-1,3185,1543,3079,-1,3185,3184,1543,-1,1566,1569,1571,-1,1565,1569,1566,-1,1589,1567,4008,-1,1589,1568,1567,-1,1912,3188,3190,-1,3188,1912,1581,-1,3192,1555,1553,-1,1928,1555,3192,-1,1553,1542,1554,-1,1553,1555,1542,-1,1540,1529,1538,-1,1530,1529,1540,-1,1516,1779,4005,-1,1777,1779,1516,-1,1959,1517,1956,-1,1519,1517,1959,-1,1523,1520,1522,-1,1523,1524,1520,-1,1518,1519,1521,-1,1517,1519,1518,-1,1503,1506,1480,-1,1503,1504,1506,-1,1485,3069,1482,-1,1499,3069,1485,-1,1491,1501,1945,-1,1501,1491,1490,-1,1935,1936,3070,-1,1934,1936,1935,-1,1496,1486,1494,-1,1496,1487,1486,-1,1497,1484,1488,-1,1497,3057,1484,-1,1482,1483,1485,-1,1481,1483,1482,-1,3096,3989,1040,-1,1854,3989,3096,-1,1851,3098,4004,-1,1851,3099,3098,-1,3113,1443,3114,-1,3113,1827,1443,-1,1852,4003,1853,-1,4001,4003,1852,-1,1849,3095,3999,-1,3100,3095,1849,-1,1746,3195,1473,-1,3998,3195,1746,-1,1478,3196,3198,-1,1476,3196,1478,-1,1723,1463,1453,-1,1701,1463,1723,-1,3997,1465,1725,-1,3997,1698,1465,-1,1690,1462,1720,-1,1690,1460,1462,-1,1720,1457,1690,-1,1457,1720,1459,-1,1452,1704,3157,-1,1455,1704,1452,-1,1785,3140,1783,-1,3140,1785,3139,-1,3140,1721,3995,-1,1721,3140,1762,-1,1446,1441,1442,-1,1441,1446,1439,-1,3204,1429,1430,-1,1429,3204,3994,-1,1424,3207,1425,-1,1424,2874,3207,-1,1410,3209,3205,-1,2049,3209,1410,-1,1393,1398,1394,-1,1396,1398,1393,-1,280,1406,1404,-1,1406,280,281,-1,35,1394,26,-1,35,1395,1394,-1,1388,3992,1390,-1,1388,1400,3992,-1,3216,34,771,-1,3216,1391,34,-1,3992,35,1391,-1,1395,35,3992,-1,1400,1395,3992,-1,1395,1400,1392,-1,1335,1387,1386,-1,1509,1387,1335,-1,3613,1382,1380,-1,3613,1385,1382,-1,1073,1085,1378,-1,1086,1085,1073,-1,3220,1206,3279,-1,1207,1206,3220,-1,3950,1374,1205,-1,3950,3307,1374,-1,1246,3283,23,-1,1246,1221,3283,-1,1367,1221,1246,-1,21,1221,1367,-1,1370,1366,3977,-1,1370,1199,1366,-1,3281,1197,1369,-1,3281,3223,1197,-1,1227,1196,1248,-1,1196,1227,1368,-1,3972,935,933,-1,3972,1355,935,-1,1352,1075,1076,-1,1352,3219,1075,-1,1351,1047,1044,-1,1047,1351,3332,-1,3991,1038,1037,-1,1038,3991,4000,-1,1350,1049,1048,-1,1049,1350,3335,-1,3881,3336,4002,-1,3881,3878,3336,-1,3323,3990,1090,-1,3990,3323,1046,-1,1045,3334,3333,-1,3334,1045,1039,-1,1344,1347,1348,-1,1343,1347,1344,-1,1169,1348,1170,-1,1169,1344,1348,-1,1340,1163,3233,-1,1340,925,1163,-1,1513,892,1329,-1,1513,893,892,-1,3861,3236,904,-1,891,3236,3861,-1,3861,3941,3301,-1,3941,3861,3860,-1,3302,888,891,-1,3302,4006,888,-1,937,1317,934,-1,1317,937,1318,-1,3241,1292,3242,-1,3241,1295,1292,-1,1311,1364,3355,-1,1364,1311,3224,-1,3862,1284,1307,-1,3245,1284,3862,-1,1301,3987,1306,-1,3987,1301,987,-1,1303,973,3250,-1,1303,971,973,-1,963,1295,3241,-1,1296,1295,963,-1,959,1315,956,-1,1294,1315,959,-1,3865,968,3864,-1,3865,966,968,-1,3242,958,3240,-1,959,958,3242,-1,3987,982,3988,-1,982,3987,1303,-1,3246,1287,1289,-1,3346,1287,3246,-1,1285,3346,1286,-1,3346,1285,1287,-1,965,1307,964,-1,965,3862,1307,-1,1001,1024,940,-1,1001,1025,1024,-1,980,3867,978,-1,1027,3867,980,-1,1282,1023,3349,-1,1282,1024,1023,-1,1024,3243,940,-1,3243,1024,1282,-1,811,1274,810,-1,811,813,1274,-1,3252,1271,1278,-1,3252,3838,1271,-1,795,789,3369,-1,795,793,789,-1,1276,3253,821,-1,797,3253,1276,-1,1272,3254,1273,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_31()
		{
			int[] value = {1272,3834,3254,-1,806,1269,807,-1,3830,1269,806,-1,3871,859,861,-1,859,3871,3829,-1,1009,863,3986,-1,1009,3350,863,-1,3257,1011,1010,-1,1011,3257,3985,-1,3258,3870,832,-1,3258,3840,3870,-1,803,1128,3929,-1,1128,803,3259,-1,3929,801,803,-1,3929,1111,801,-1,3897,804,1110,-1,3897,805,804,-1,3896,864,860,-1,3896,3913,864,-1,3983,3912,3915,-1,3912,3983,862,-1,3983,3256,3986,-1,3983,3839,3256,-1,3910,3911,3898,-1,3911,3910,3909,-1,3916,3981,3980,-1,3916,3914,3981,-1,1259,3343,1020,-1,1259,1261,3343,-1,1004,1017,1002,-1,1004,1018,1017,-1,3345,3874,3873,-1,3345,3342,3874,-1,3344,3868,3341,-1,3344,3268,3868,-1,3873,1260,3345,-1,3873,1261,1260,-1,3867,871,3251,-1,3867,1256,871,-1,3850,3311,3364,-1,3365,3311,3850,-1,877,3308,3309,-1,3311,3308,877,-1,3310,3308,3311,-1,3918,3314,3907,-1,3314,3918,3917,-1,3271,1116,1117,-1,3271,3315,1116,-1,3921,1119,1120,-1,3921,3927,1119,-1,3312,3926,1127,-1,3926,3312,3920,-1,1250,3270,1251,-1,3365,3270,1250,-1,885,974,874,-1,974,885,884,-1,887,3857,3872,-1,3857,887,886,-1,3360,3852,3851,-1,3360,3363,3852,-1,877,3364,3311,-1,877,879,3364,-1,1201,1247,24,-1,3222,1247,1201,-1,1213,1241,3282,-1,1213,1239,1241,-1,1241,1370,3977,-1,1241,1240,1370,-1,1215,1230,1226,-1,1215,1214,1230,-1,1225,3975,1223,-1,1225,1243,3975,-1,3278,19,21,-1,3278,3286,19,-1,3278,3976,3286,-1,1191,1214,1190,-1,1212,1214,1191,-1,1189,1213,1191,-1,1239,1213,1189,-1,1243,1188,3975,-1,1243,1242,1188,-1,3284,3973,3976,-1,3284,3974,3973,-1,1204,1246,22,-1,1204,1367,1246,-1,916,1347,1187,-1,916,918,1347,-1,1224,1174,1173,-1,1174,1224,1223,-1,3974,3970,3973,-1,3291,3970,3974,-1,1157,3285,3277,-1,1157,1194,3285,-1,1193,1156,1181,-1,1156,1193,1195,-1,1216,917,1190,-1,3293,917,1216,-1,1187,1191,916,-1,1187,1189,1191,-1,3975,1165,1167,-1,1165,3975,1188,-1,1184,1157,3276,-1,1158,1157,1184,-1,3968,1185,3318,-1,3968,1183,1185,-1,3967,1354,1182,-1,3967,3972,1354,-1,3964,3226,3225,-1,3964,3290,3226,-1,1357,3969,3965,-1,3969,1357,1355,-1,3891,3966,3963,-1,3966,3891,3319,-1,1179,3971,1177,-1,1179,3295,3971,-1,1177,3292,1176,-1,1177,3971,3292,-1,1175,1088,1172,-1,1175,1087,1088,-1,1178,1172,1164,-1,1178,1175,1172,-1,934,1356,936,-1,934,935,1356,-1,1343,1187,1347,-1,1343,1166,1187,-1,1183,3969,3967,-1,3968,3969,1183,-1,3966,3290,3964,-1,3966,3288,3290,-1,1342,1164,1166,-1,1178,1164,1342,-1,1326,1148,3296,-1,1148,1326,1323,-1,3960,3956,24,-1,3960,3961,3956,-1,22,1143,1204,-1,22,1144,1143,-1,1764,3960,3951,-1,1766,3960,1764,-1,3959,1150,1149,-1,3959,3300,1150,-1,1146,1323,1322,-1,1323,1146,1148,-1,3961,1149,3956,-1,3959,1149,3961,-1,3942,3750,3943,-1,3513,3750,3942,-1,3948,3755,3306,-1,3753,3755,3948,-1,3951,3955,1764,-1,3944,3955,3951,-1,1133,3947,1134,-1,4078,3947,1133,-1,1135,3950,3949,-1,3950,1135,1134,-1,3856,3945,3855,-1,3940,3945,3856,-1,3940,3946,3945,-1,3940,3305,3946,-1,3958,3302,3300,-1,3958,4006,3302,-1,3962,3959,3961,-1,3957,3959,3962,-1,3943,3761,3954,-1,3943,3750,3761,-1,4078,3948,3947,-1,3952,3948,4078,-1,3248,3351,3339,-1,3248,3988,3351,-1,3928,3309,1125,-1,3928,3939,3309,-1,3936,3939,3935,-1,3936,3937,3939,-1,3846,3936,3931,-1,3936,3846,3844,-1,3935,3923,3933,-1,3925,3923,3935,-1,3934,3931,3933,-1,3930,3931,3934,-1,1130,1266,3523,-1,1130,1129,1266,-1,3929,1131,3887,-1,3929,1128,1131,-1,3928,1127,3926,-1,3928,1125,1127,-1,3923,3927,3921,-1,3923,3925,3927,-1,1064,1119,3920,-1,1056,1119,1064,-1,1118,3978,1120,-1,4091,3978,1118,-1,3901,3892,3899,-1,3901,3894,3892,-1,3893,3895,1109,-1,3893,3919,3895,-1,3917,1254,1253,-1,3917,3918,1254,-1,3261,3979,3262,-1,3979,3261,3980,-1,1113,3980,3981,-1,1113,3979,3980,-1,3898,3913,3896,-1,3898,3911,3913,-1,1114,3981,3909,-1,1114,1113,3981,-1,3979,1115,1117,-1,1115,3979,1113,-1,3904,3908,3902,-1,3904,3313,3908,-1,3905,3907,3906,-1,3905,3274,3907,-1,1121,1062,1065,-1,1062,1121,3905,-1,1103,3903,1108,-1,1103,3906,3903,-1,1106,3902,3899,-1,1106,3904,3902,-1,3910,3901,3900,-1,3919,3901,3910,-1,1109,3897,1110,-1,1109,3895,3897,-1,1109,3325,3893,-1,3325,1109,1112,-1,3894,1082,3892,-1,1082,3894,3327,-1,1107,3899,3892,-1,1107,1106,3899,-1,1105,1103,1108,-1,1104,1103,1105,-1,1377,3292,1071,-1,3292,1377,1176,-1,3320,1081,3321,-1,1081,3320,3890,-1,1072,3888,1070,-1,3888,1072,1093,-1,1105,1084,3322,-1,1105,1107,1084,-1,1079,1063,1104,-1,1079,1078,1063,-1,1074,1378,3330,-1,1074,1073,1378,-1,3331,1071,1069,-1,3331,1377,1071,-1,3326,3889,3324,-1,3886,3889,3326,-1,1070,3889,1066,-1,1070,3888,3889,-1,3735,3328,382,-1,3328,3735,3329,-1,1067,1131,1130,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_32()
		{
			int[] value = {3886,1131,1067,-1,1066,3886,1067,-1,1066,3889,3886,-1,1130,1068,1067,-1,3523,1068,1130,-1,1061,1078,1053,-1,1078,1061,1063,-1,1054,1060,1050,-1,1060,1054,1077,-1,1350,1090,3990,-1,1090,1350,1091,-1,1351,1074,1042,-1,1351,1076,1074,-1,1064,1053,1056,-1,1053,1064,1061,-1,1050,1052,1054,-1,1050,1051,1052,-1,3990,3335,1350,-1,3990,3333,3335,-1,1055,1118,1056,-1,1055,3884,1118,-1,1051,3882,1052,-1,1051,3880,3882,-1,3991,1041,3877,-1,1041,3991,3332,-1,3884,4091,1118,-1,3884,3883,4091,-1,3880,3885,3882,-1,3880,3879,3885,-1,3989,3336,3334,-1,3989,4002,3336,-1,3877,4000,3991,-1,3877,3875,4000,-1,3864,970,3353,-1,3864,968,970,-1,939,1262,1001,-1,939,1264,1262,-1,3249,1030,1000,-1,3249,1028,1030,-1,3840,3985,3257,-1,3840,3258,3985,-1,3843,830,3841,-1,830,3843,1008,-1,1003,3843,1021,-1,1003,1008,3843,-1,3869,1006,1005,-1,1006,3869,943,-1,1005,1014,3869,-1,1014,1005,1002,-1,997,998,1000,-1,997,996,998,-1,1000,1257,997,-1,1000,1030,1257,-1,995,991,1022,-1,992,991,995,-1,989,1026,991,-1,989,1256,1026,-1,3988,984,3351,-1,3988,982,984,-1,979,984,985,-1,984,979,981,-1,981,3351,984,-1,3351,981,976,-1,3863,1293,3866,-1,3863,1291,1293,-1,972,986,988,-1,972,971,986,-1,973,968,967,-1,968,973,970,-1,3247,966,3865,-1,3247,969,966,-1,3866,3864,3863,-1,3865,3864,3866,-1,3862,3244,1314,-1,965,3244,3862,-1,1296,3866,1293,-1,1296,1305,3866,-1,3355,1365,947,-1,1364,1365,3355,-1,1361,957,945,-1,957,1361,1363,-1,1321,3860,1319,-1,3860,1321,3941,-1,1356,851,936,-1,1356,3227,851,-1,912,1168,1162,-1,914,1168,912,-1,921,3356,919,-1,1336,3356,921,-1,1346,1166,1343,-1,1346,3232,1166,-1,913,3228,914,-1,913,3234,3228,-1,911,903,905,-1,907,903,911,-1,1319,3357,946,-1,3860,3357,1319,-1,909,905,3858,-1,909,911,905,-1,3859,901,897,-1,3859,1331,901,-1,896,3859,897,-1,896,894,3859,-1,3358,894,896,-1,895,894,3358,-1,1136,3857,3337,-1,3857,1136,3872,-1,3362,3338,3337,-1,3338,3362,3853,-1,3856,3854,3135,-1,3853,3854,3856,-1,881,3852,886,-1,881,3849,3852,-1,3849,880,3845,-1,3849,881,880,-1,3848,3846,3932,-1,3845,3846,3848,-1,878,880,879,-1,878,3844,880,-1,3269,3251,871,-1,3269,873,3251,-1,868,867,866,-1,867,868,3264,-1,3263,3843,3261,-1,3843,3263,1021,-1,3842,3870,3982,-1,3870,3842,3841,-1,862,3986,863,-1,862,3983,3986,-1,860,861,859,-1,860,864,861,-1,3984,1013,1011,-1,1270,1013,3984,-1,849,851,853,-1,852,851,849,-1,837,849,846,-1,849,837,852,-1,843,844,841,-1,845,844,843,-1,837,838,840,-1,837,836,838,-1,843,836,3836,-1,843,838,836,-1,827,3258,828,-1,827,3985,3258,-1,1278,1270,3984,-1,1278,1271,1270,-1,797,809,3253,-1,797,794,809,-1,3837,1032,1031,-1,3837,826,1032,-1,3836,835,3837,-1,3836,836,835,-1,822,1031,823,-1,822,1277,1031,-1,821,818,1276,-1,818,821,823,-1,810,796,811,-1,796,810,794,-1,817,3827,815,-1,3827,817,3370,-1,3835,816,815,-1,3835,3217,816,-1,800,816,3368,-1,814,816,800,-1,812,817,814,-1,812,811,817,-1,3254,3833,3255,-1,3254,3832,3833,-1,809,3834,3838,-1,809,808,3834,-1,1275,808,810,-1,3832,808,1275,-1,3871,3831,3829,-1,3831,3871,3833,-1,3831,1274,3828,-1,1274,3831,1275,-1,800,802,3366,-1,802,800,799,-1,3367,3830,3828,-1,3830,3367,1269,-1,3827,1382,1384,-1,3827,1381,1382,-1,792,1276,818,-1,792,791,1276,-1,793,781,789,-1,781,793,790,-1,3294,1160,3823,-1,1160,3294,1159,-1,786,783,1161,-1,783,786,785,-1,779,785,780,-1,779,783,785,-1,819,3826,779,-1,3826,819,825,-1,3824,782,3825,-1,3824,3823,782,-1,848,3824,846,-1,3372,3824,848,-1,3585,192,770,-1,3374,192,3585,-1,760,769,763,-1,760,759,769,-1,776,764,774,-1,776,766,764,-1,3376,769,759,-1,3376,768,769,-1,3568,777,3377,-1,777,3568,775,-1,753,25,27,-1,766,25,753,-1,763,767,761,-1,769,767,763,-1,3433,3379,3378,-1,3379,3433,3380,-1,753,288,765,-1,753,286,288,-1,778,751,752,-1,767,751,778,-1,761,778,184,-1,767,778,761,-1,686,171,599,-1,686,169,171,-1,191,3433,3378,-1,3385,3433,191,-1,268,740,276,-1,268,744,740,-1,3563,307,308,-1,307,3563,3561,-1,277,200,201,-1,277,1388,200,-1,3388,435,3520,-1,435,3388,1407,-1,673,3395,321,-1,3395,673,349,-1,3660,3600,3688,-1,3660,3601,3600,-1,210,3687,3691,-1,3687,210,3680,-1,3808,3679,3678,-1,208,3679,3808,-1,258,3686,730,-1,258,257,3686,-1,732,3576,256,-1,732,3396,3576,-1,588,709,708,-1,709,588,587,-1,581,712,723,-1,581,580,712,-1,725,709,587,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_33()
		{
			int[] value = {724,709,725,-1,717,3399,402,-1,717,718,3399,-1,3400,720,718,-1,3400,3821,720,-1,721,703,717,-1,701,703,721,-1,3398,693,695,-1,693,3398,3397,-1,693,711,694,-1,3821,711,693,-1,3398,697,699,-1,695,697,3398,-1,3211,745,3402,-1,3211,3210,745,-1,746,682,3401,-1,746,691,682,-1,3577,678,3578,-1,3577,3403,678,-1,3405,242,241,-1,242,3405,3404,-1,245,677,244,-1,245,681,677,-1,3699,671,4148,-1,3699,670,671,-1,319,672,322,-1,672,319,318,-1,4150,3698,3697,-1,4150,3820,3698,-1,3722,325,3559,-1,3722,3720,325,-1,3701,3819,4156,-1,3701,310,3819,-1,668,309,667,-1,309,668,3721,-1,401,329,328,-1,401,404,329,-1,665,403,666,-1,403,665,3550,-1,461,650,635,-1,661,650,461,-1,660,444,658,-1,444,660,521,-1,31,3818,32,-1,3410,3818,31,-1,660,652,3774,-1,660,653,652,-1,657,3813,655,-1,3814,3813,657,-1,3638,3412,651,-1,3817,3412,3638,-1,635,651,634,-1,3638,651,635,-1,3815,657,3409,-1,3815,3814,657,-1,647,655,3813,-1,647,646,655,-1,640,3810,641,-1,640,3413,3810,-1,652,3412,3410,-1,654,3412,652,-1,3817,3409,3818,-1,3817,3815,3409,-1,3812,3814,3816,-1,3812,3813,3814,-1,462,642,636,-1,462,634,642,-1,648,661,467,-1,661,648,650,-1,3542,3811,468,-1,3542,3809,3811,-1,641,3537,3414,-1,3537,641,3810,-1,253,3690,633,-1,253,3689,3690,-1,735,432,3807,-1,735,433,432,-1,265,735,3417,-1,735,265,736,-1,209,3806,3746,-1,3806,209,211,-1,3522,629,3681,-1,3522,630,629,-1,3663,3742,3661,-1,3741,3742,3663,-1,429,3664,3418,-1,429,428,3664,-1,628,564,3744,-1,628,565,564,-1,3793,3744,564,-1,3744,3793,426,-1,3742,627,3419,-1,3742,357,627,-1,3565,302,301,-1,302,3565,2587,-1,3716,626,3724,-1,3716,333,626,-1,3423,3729,3549,-1,3423,3424,3729,-1,3564,3714,299,-1,3564,3725,3714,-1,300,3723,3804,-1,300,3715,3723,-1,332,413,3422,-1,414,413,332,-1,3541,625,405,-1,3541,331,625,-1,408,623,622,-1,408,3423,623,-1,368,418,3425,-1,416,418,368,-1,601,466,465,-1,466,601,231,-1,464,111,463,-1,464,109,111,-1,162,600,750,-1,600,162,615,-1,612,3432,613,-1,3432,612,3431,-1,172,173,175,-1,172,3589,173,-1,3435,3431,596,-1,3435,167,3431,-1,607,593,605,-1,593,607,595,-1,614,3591,161,-1,613,3591,614,-1,621,589,592,-1,621,590,589,-1,590,621,3437,-1,3668,2448,3803,-1,2448,3668,3496,-1,3674,3802,3800,-1,3802,3674,3673,-1,3801,3586,772,-1,3801,3676,3586,-1,3567,772,773,-1,3801,772,3567,-1,3377,3802,3568,-1,3800,3802,3377,-1,3670,3442,3797,-1,3442,3670,3440,-1,3798,639,3446,-1,3798,3799,639,-1,585,3443,3447,-1,588,3443,585,-1,588,722,3443,-1,581,3799,582,-1,726,3799,581,-1,3799,726,584,-1,3798,3442,3439,-1,3442,3798,3587,-1,3408,3448,32,-1,583,3448,3408,-1,3447,583,585,-1,3448,583,3447,-1,3671,3441,3440,-1,3794,3441,3671,-1,3587,3446,3444,-1,3587,3798,3446,-1,3452,254,633,-1,3452,259,254,-1,579,3583,3581,-1,579,578,3583,-1,126,121,117,-1,126,3605,121,-1,3683,3659,3658,-1,3683,3682,3659,-1,215,3604,125,-1,215,218,3604,-1,214,124,3606,-1,214,213,124,-1,3793,3666,3664,-1,3602,3666,3793,-1,3615,1385,3613,-1,3792,1385,3615,-1,439,3617,440,-1,439,575,3617,-1,568,1266,1265,-1,568,567,1266,-1,139,569,577,-1,139,572,569,-1,572,138,140,-1,572,139,138,-1,3652,559,561,-1,3616,559,3652,-1,3657,558,3218,-1,3598,558,3657,-1,554,547,555,-1,547,554,548,-1,553,3787,3775,-1,552,3787,553,-1,451,3465,452,-1,451,3481,3465,-1,543,3478,3791,-1,543,545,3478,-1,3788,531,530,-1,3784,531,3788,-1,539,3786,540,-1,539,3477,3786,-1,542,3785,3479,-1,542,541,3785,-1,3480,3790,3482,-1,3789,3790,3480,-1,3789,3470,3469,-1,3789,3476,3470,-1,3790,3467,3479,-1,3790,3466,3467,-1,535,530,533,-1,530,535,3459,-1,552,3788,3787,-1,3786,3788,552,-1,3784,537,531,-1,3475,537,3784,-1,529,450,449,-1,529,527,450,-1,454,527,528,-1,454,450,527,-1,456,3464,549,-1,456,3483,3464,-1,3460,524,526,-1,3460,551,524,-1,3499,449,3783,-1,3499,529,449,-1,3502,523,525,-1,3502,3782,523,-1,3740,3782,3783,-1,3782,3740,3531,-1,551,500,524,-1,550,500,551,-1,3738,3775,515,-1,553,3775,3738,-1,3759,446,448,-1,446,3759,3791,-1,445,658,444,-1,445,659,658,-1,520,3509,519,-1,3509,520,3781,-1,3791,3512,543,-1,3759,3512,3791,-1,339,3536,3548,-1,339,503,3536,-1,3548,513,504,-1,3536,513,3548,-1,4227,3778,3777,-1,3778,4227,3718,-1,384,3739,3546,-1,3534,3739,384,-1,3548,342,339,-1,342,3548,3547,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_34()
		{
			int[] value = {3780,3707,316,-1,3707,3780,4231,-1,3490,313,505,-1,313,3490,3726,-1,3776,315,314,-1,3776,3728,315,-1,3778,3554,3727,-1,3718,3554,3778,-1,421,514,515,-1,421,501,514,-1,512,420,419,-1,501,420,512,-1,517,499,518,-1,499,517,77,-1,498,82,497,-1,498,80,82,-1,3500,86,88,-1,3491,86,3500,-1,3492,492,155,-1,492,3492,491,-1,90,3646,489,-1,3646,90,93,-1,3649,3626,3610,-1,3626,3649,3648,-1,484,476,2436,-1,476,484,477,-1,474,3645,471,-1,3645,474,919,-1,3428,469,410,-1,3428,470,469,-1,465,661,463,-1,467,661,465,-1,455,548,3484,-1,455,549,548,-1,455,456,549,-1,522,496,3462,-1,496,522,494,-1,524,3491,525,-1,524,500,3491,-1,3501,529,3499,-1,529,3501,518,-1,3759,3751,3512,-1,3751,3759,3514,-1,3774,521,660,-1,3773,521,3774,-1,3770,3411,33,-1,3770,3772,3411,-1,3769,3772,3768,-1,3769,3773,3772,-1,3769,3781,520,-1,3516,3781,3769,-1,3517,3771,3747,-1,3517,3768,3771,-1,448,3518,3758,-1,447,3518,448,-1,447,3468,3518,-1,3764,3505,3765,-1,3506,3505,3764,-1,510,3765,3762,-1,3764,3765,510,-1,511,3762,3760,-1,510,3762,511,-1,3487,3760,3754,-1,3487,511,3760,-1,3512,3752,3511,-1,3751,3752,3512,-1,3515,3758,3749,-1,3515,448,3758,-1,3487,3953,2410,-1,3753,3953,3487,-1,3755,3752,3304,-1,3755,3754,3752,-1,3518,3471,3516,-1,3518,3468,3471,-1,3767,3445,3504,-1,3445,3767,3795,-1,631,358,3741,-1,358,631,3519,-1,3392,3806,3390,-1,3392,3746,3806,-1,3393,3730,3394,-1,3730,3393,352,-1,3394,3731,3521,-1,3731,3394,3730,-1,376,3524,3745,-1,376,3734,3524,-1,3526,425,3529,-1,3743,425,3526,-1,3743,628,3744,-1,3743,3456,628,-1,3525,3529,374,-1,3529,3525,3526,-1,430,3419,627,-1,430,429,3419,-1,427,3544,425,-1,3544,427,3733,-1,361,3740,424,-1,361,3543,3740,-1,3533,423,455,-1,3533,363,423,-1,3739,3484,3488,-1,3739,455,3484,-1,3415,418,417,-1,418,3415,3414,-1,3539,364,3732,-1,3539,3540,364,-1,415,3538,3737,-1,415,411,3538,-1,353,412,354,-1,353,413,412,-1,412,3541,409,-1,3541,412,414,-1,402,666,403,-1,402,3399,666,-1,400,404,401,-1,400,676,404,-1,396,399,398,-1,396,395,399,-1,394,392,393,-1,392,394,397,-1,327,359,356,-1,359,327,3422,-1,381,3532,385,-1,3535,3532,381,-1,386,3546,348,-1,3546,386,384,-1,381,3735,382,-1,381,386,3735,-1,383,3734,380,-1,1068,3734,383,-1,380,362,3535,-1,377,362,380,-1,360,377,375,-1,377,360,362,-1,369,387,367,-1,369,372,387,-1,3732,3527,3737,-1,3527,3732,3733,-1,3737,627,415,-1,627,3737,3527,-1,355,415,627,-1,355,354,415,-1,3736,398,3545,-1,3736,396,398,-1,392,352,351,-1,352,392,3730,-1,3490,3486,3557,-1,336,3486,3490,-1,338,3486,336,-1,370,3557,373,-1,370,3555,3557,-1,625,330,3421,-1,330,625,331,-1,664,3720,668,-1,3720,664,3407,-1,321,669,673,-1,317,669,321,-1,317,319,669,-1,3717,333,3716,-1,333,3717,334,-1,3714,3420,3715,-1,3420,3714,3729,-1,3712,330,326,-1,3712,3713,330,-1,667,311,3551,-1,667,309,311,-1,198,307,199,-1,305,307,198,-1,3710,3553,3708,-1,3553,3710,3552,-1,3778,3728,3776,-1,3728,3778,3727,-1,3556,3780,3726,-1,3556,3704,3780,-1,3717,3702,3558,-1,3717,304,3702,-1,3565,3725,3564,-1,3725,3565,3724,-1,3804,3713,295,-1,3713,3804,3723,-1,311,296,3712,-1,311,312,296,-1,3722,3819,3721,-1,3722,3820,3819,-1,320,671,318,-1,320,3694,671,-1,3710,3876,3719,-1,3710,3709,3876,-1,3711,3718,4227,-1,3718,3711,3708,-1,4231,3704,3703,-1,3704,4231,3780,-1,303,3702,304,-1,303,3705,3702,-1,295,3805,3804,-1,295,294,3805,-1,293,312,3700,-1,312,293,296,-1,4150,3819,3820,-1,4150,4156,3819,-1,3696,671,3694,-1,3696,4148,671,-1,3695,3563,3822,-1,3563,3695,3562,-1,134,131,130,-1,131,134,292,-1,240,731,243,-1,731,240,248,-1,3611,3835,1384,-1,3835,3611,3656,-1,287,754,3569,-1,287,286,754,-1,3569,279,278,-1,3214,279,3569,-1,3387,278,271,-1,278,3387,3569,-1,274,288,287,-1,274,273,288,-1,270,272,274,-1,270,752,272,-1,206,263,207,-1,3570,263,206,-1,3213,188,271,-1,3213,239,188,-1,3210,249,745,-1,3210,3212,249,-1,266,3574,267,-1,3574,266,3689,-1,3691,633,3690,-1,3687,633,3691,-1,3576,3575,3573,-1,3575,3576,251,-1,236,241,237,-1,241,236,244,-1,241,243,237,-1,241,240,243,-1,224,237,225,-1,238,237,224,-1,236,232,246,-1,232,236,233,-1,229,230,233,-1,229,228,230,-1,3580,227,229,-1,3580,3430,227,-1,225,730,226,-1,731,730,225,-1,223,3685,578,-1,3685,223,220,-1,217,3685,220,-1,216,3685,217,-1};
			return value;
		}
		private int[] getsacrum_Geo_6_24_coordIndex_35()
		{
			int[] value = {3685,216,212,-1,222,219,220,-1,222,3684,219,-1,3684,3450,3682,-1,3684,3572,3450,-1,217,3683,218,-1,217,219,3683,-1,216,213,212,-1,213,216,215,-1,3681,210,209,-1,210,3681,3680,-1,211,3808,3807,-1,3808,211,208,-1,3389,206,205,-1,206,736,265,-1,206,3389,736,-1,3675,3676,3673,-1,3676,3675,3677,-1,3674,3669,3672,-1,3674,3671,3669,-1,177,180,687,-1,177,181,180,-1,178,173,176,-1,173,178,174,-1,3589,0,2676,-1,3589,172,0,-1,3566,3668,3438,-1,3668,3566,3592,-1,3495,156,3625,-1,157,156,3495,-1,158,159,156,-1,158,154,159,-1,158,155,154,-1,3628,3492,3494,-1,491,3492,3628,-1,488,3623,152,-1,488,3629,3623,-1,3629,488,487,-1,147,3667,148,-1,147,150,3667,-1,149,142,144,-1,142,149,148,-1,3594,148,3667,-1,3594,142,148,-1,3656,3217,3835,-1,3218,3217,3656,-1,291,135,3596,-1,134,135,291,-1,128,3665,3609,-1,128,3662,3665,-1,3609,3666,3607,-1,3609,3665,3666,-1,3662,3418,3665,-1,3662,3661,3418,-1,3663,3601,632,-1,3601,3663,3599,-1,3452,3600,3451,-1,3600,3452,3688,-1,127,3658,3659,-1,3449,3658,127,-1,120,117,121,-1,118,117,120,-1,113,116,114,-1,113,119,116,-1,3649,115,112,-1,618,115,3649,-1,618,617,115,-1,3453,3458,574,-1,3453,3455,3458,-1,3657,3651,3597,-1,3657,3655,3651,-1,3656,3654,3655,-1,3654,3656,3611,-1,3617,3653,3792,-1,3616,3653,3617,-1,292,3458,131,-1,3458,292,3457,-1,3650,919,3356,-1,3650,3645,919,-1,104,3621,3620,-1,104,107,3621,-1,3650,3620,85,-1,3620,3650,104,-1,3647,114,96,-1,114,3647,112,-1,97,99,69,-1,97,3608,99,-1,118,3608,97,-1,118,120,3608,-1,96,72,3647,-1,72,96,70,-1,490,3626,3498,-1,490,3627,3626,-1,490,489,3627,-1,3625,3646,3495,-1,3646,3625,3624,-1,3650,83,3645,-1,83,3650,85,-1,471,3634,472,-1,3634,471,3630,-1,70,65,71,-1,95,65,70,-1,62,71,65,-1,62,61,71,-1,103,67,66,-1,103,3633,67,-1,62,3644,58,-1,62,64,3644,-1,57,3632,61,-1,60,3632,57,-1,47,48,50,-1,47,41,48,-1,44,3636,45,-1,44,49,3636,-1,51,46,3643,-1,51,44,46,-1,53,784,54,-1,784,53,3642,-1,58,40,37,-1,58,3635,40,-1,3637,3644,103,-1,3637,3636,3644,-1,441,45,102,-1,441,46,45,-1,3614,3643,3612,-1,3614,3642,3643,-1,3233,3293,1340,-1,3233,917,3293,-1,18,1451,3639,-1,18,17,1451,-1,2301,2985,33,-1,2301,2300,2985,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getsacrum_Coord_7_24_point_1()
		{
			double[] value = {.01591,32.62943,-4.21033,.01591,32.68048,-4.16493,.02602,32.63581,-4.21007,.04018,32.18118,-4.03189,.14827,32.35414,-3.97692,.06868,32.41814,-4.01124,.12654,32.12174,-4.02031,.54246,32.9004,-3.79477,.52699,32.98569,-3.79774,.42358,32.95085,-3.80374,.01591,31.21381,-3.64167,.05201,31.21578,-3.63431,.01591,31.27045,-3.44167,.67458,34.96217,-2.73586,.65644,34.94313,-2.80053,.66002,35.04148,-2.83151,.30972,35.04214,-2.67719,.34194,34.99963,-2.64791,.31948,35.01651,-2.64629,-.38789,34.89476,-2.57996,-.31012,34.99963,-2.64791,-.28766,35.01651,-2.64629,-.26648,35.08785,-2.64476,-.23956,35.06214,-2.70156,-.16445,35.09168,-2.77319,-.32387,31.46805,-3.85772,-.29681,31.40356,-3.85549,-.27892,31.43273,-3.94036,.00225,32.18267,-4.04476,.01134,32.20442,-4.06198,.01591,32.20073,-4.04917,-.0419,33.18692,-3.86068,-.03787,33.07858,-3.88689,.01591,33.14902,-3.9156,-.28924,31.28988,-3.66458,-.33028,31.43436,-3.73157,-.33436,31.51206,-3.72535,-.98642,34.24904,-3.51341,-1.03592,34.39874,-3.25925,-.97272,34.3903,-3.47066,-1.08964,34.2219,-3.34179,-1.14193,34.21332,-3.18153,-1.13832,34.28562,-3.12398,-1.11939,34.35461,-3.21959,-1.3778,34.034,-3.15002,-1.45971,33.88511,-3.26555,-1.49513,33.91952,-3.18973,-1.22319,34.22393,-3.06378,-1.1872,34.14705,-3.21666,-1.27789,34.04937,-3.24354,-1.27234,34.17971,-3.07125,-1.4375,34.06665,-3.05,-1.34009,34.134,-3.01162,-1.47669,34.12323,-2.94687,-1.47166,34.16863,-2.91817,-1.39044,34.17875,-2.94626,-1.28693,34.19189,-2.98764,-1.01393,34.08096,-3.63183,-1.13979,34.05352,-3.53907,-.86201,34.16463,-3.55266,-.93902,34.08569,-3.6316,-1.04664,33.95299,-3.73745,-1.1448,33.87656,-3.70677,-1.30451,33.83375,-3.6491,-1.29632,33.8496,-3.56851,-1.2672,33.70055,-3.65488,-1.47962,33.62461,-3.52882,-1.3971,33.68294,-3.58058,-1.31891,33.48755,-3.62922,-1.50483,33.45553,-3.57454,-1.03698,33.61963,-3.79032,-1.0489,33.7646,-3.78361,-.95891,33.63277,-3.7863,-.98158,33.75507,-3.76951,-.86886,33.71412,-3.7236,-.80956,33.70096,-3.74397,-.83704,33.58088,-3.77299,-.79206,33.97807,-3.55087,-.87306,34.05489,-3.59424,-.74569,34.04995,-3.54206,-.74335,33.99222,-3.51408,-.65023,34.05532,-3.53628,-.65871,34.00541,-3.5202,-.5914,34.21151,-3.46591,-.57836,34.05197,-3.53969,-.47521,34.19453,-3.452,-.57079,33.6979,-3.66277,-.59015,33.65474,-3.70888,-.686,33.72142,-3.65208,-.69502,33.68007,-3.73206,-.57683,33.54059,-3.78538,-.57338,33.66052,-3.72221,-.42827,33.68785,-3.7643,-.43848,33.48758,-3.80758,-1.1561,33.41604,-3.77842,-1.19226,33.54354,-3.7117,-1.029,33.43789,-3.8106,-1.37707,33.28507,-3.69487,-1.23631,33.36085,-3.73559,-1.58172,33.27494,-3.57468};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_2()
		{
			double[] value = {-1.6212,33.45797,-3.57426,-1.63773,33.32407,-3.5652,-1.61634,33.7202,-3.33325,-1.44909,33.76538,-3.45077,-.26104,34.34845,-3.38388,-.25197,34.48342,-3.32328,-.16921,34.47957,-3.33468,-.16163,34.34781,-3.44143,-.40772,33.16883,-3.87943,-.56721,33.1187,-3.83809,-.53786,33.21341,-3.84547,-.50091,33.05135,-3.89281,-.90485,33.30182,-3.85751,-1.04745,33.2035,-3.88784,-1.01889,33.30579,-3.84435,-.90434,33.14528,-3.90236,-1.16404,33.23998,-3.82211,-1.23031,33.07744,-3.82931,-1.28961,33.15358,-3.77054,-1.14682,33.18582,-3.86339,-1.42255,33.02987,-3.70335,-1.34992,32.93307,-3.78382,-1.36012,32.79014,-3.763,-1.14441,33.16678,-3.87825,-1.14923,33.11071,-3.91809,-1.22003,33.05806,-3.92119,-1.22365,33.06588,-3.84565,-1.33998,32.65194,-3.74238,-1.41706,32.79344,-3.7227,-1.68259,33.19174,-3.46034,-1.71242,33.15897,-3.30644,-1.67647,33.24383,-3.40227,-1.6954,33.11191,-3.32963,-1.73666,33.24061,-3.14883,-1.68658,33.22377,-3.2983,-1.701,33.30595,-3.12676,-1.74186,33.35222,-3.04858,-1.67617,33.40711,-3.05352,-1.74697,33.26068,-3.05889,-1.76053,33.28677,-2.99492,-1.72044,33.24692,-3.08115,-1.68517,33.13032,-3.26046,.00208,34.45645,-3.71019,.01591,34.61329,-3.7418,-.03193,34.51931,-3.82129,.01591,34.57512,-3.62824,-.01691,34.16199,-3.92298,-.01766,34.11377,-3.81532,-.00614,34.32674,-3.75808,-.03598,34.37088,-3.89792,-.04862,34.08124,-3.70387,-.04197,34.02877,-3.71361,-.14473,34.0202,-3.63572,-.05447,33.68733,-3.85458,-.08146,33.53132,-3.92686,-.17072,33.5727,-3.79166,-.20002,33.33306,-3.90311,-.29362,33.47962,-3.78356,-.17837,33.56182,-3.78889,-.12839,33.35671,-3.9904,-.12594,33.18672,-4.00797,-.17571,33.17307,-3.98435,-.40455,32.70924,-4.0215,-.47007,32.76093,-3.9646,-.43895,32.99962,-3.9681,-.33303,32.94059,-4.02407,-.31047,32.73183,-4.03768,-.19774,32.89061,-4.01579,-.23454,32.76058,-4.05502,-.43904,32.37997,-4.03562,-.45992,32.55359,-3.99046,-.39286,32.5513,-4.04143,.00581,32.63581,-4.21007,-.06477,32.57774,-4.24943,-.17346,32.62731,-4.18958,-.10536,32.66308,-4.20897,-.0478,32.40507,-4.26293,-.2015,32.38699,-4.18167,-.20947,32.5473,-4.18349,-.13112,32.20709,-4.07701,-.23366,32.27398,-4.09688,-.16088,32.28203,-4.16871,-.23156,32.13814,-4.04767,-.16836,32.06442,-4.02837,-.20115,32.01774,-4.03606,-.27418,32.05041,-4.07848,-.40022,31.9883,-4.04031,-.32591,31.85268,-4.05864,-.39987,31.8156,-4.04915,-.31758,32.04696,-4.09192,-.23978,32.25769,-4.08344,-.13842,32.19774,-4.05856,-.0737,31.21853,-3.62703,-.24382,31.27433,-3.49261,-.2219,31.20422,-3.59303,-.12383,31.29379,-3.46526,-.33489,31.34133,-3.38001,-.16231,31.32681,-3.33142,-.42736,31.38484,-3.41372,-.42854,31.44641,-3.4366};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_3()
		{
			double[] value = {-.4864,31.34754,-3.51024,-.51084,31.48034,-3.53357,-.41902,31.52521,-3.46553,-.5653,31.5672,-3.53261,-.45385,31.63099,-3.48732,-.87561,31.63557,-3.42113,-1.00441,31.65911,-3.53746,-.77989,31.57995,-3.58501,-1.27162,31.8767,-3.50676,-1.21303,31.93358,-3.3602,-1.26197,31.99694,-3.54863,-1.21104,31.87315,-3.34882,-1.09263,33.02672,-3.97216,-1.14155,33.0964,-3.93249,-1.08146,33.12324,-3.95396,-1.21242,33.04957,-3.93766,-1.17293,33.01054,-3.96759,-1.26854,32.89099,-3.94082,-1.30942,32.90749,-3.90197,-1.2747,32.76076,-3.9159,-1.12361,32.79138,-3.93836,-1.04184,32.62895,-3.89134,-1.15189,32.6388,-3.89554,-1.03609,32.78263,-3.91874,-.95265,32.63051,-3.84677,-.9533,32.47573,-3.87043,-1.06407,32.48064,-3.8872,-.78722,32.91663,-3.88758,-.67654,32.8183,-3.89355,-.8126,32.77589,-3.89465,-.66898,32.81324,-3.89432,-.61408,32.80727,-3.92442,-.57375,32.66407,-3.94459,-.67517,32.65455,-3.91203,-.47624,32.68626,-3.98945,-.41401,32.69915,-4.01322,-.65077,32.51927,-3.90144,-.78192,32.50725,-3.88772,-.79911,32.64111,-3.87607,-.46392,31.76048,-3.94106,-.83302,32.26367,-3.89315,-.71311,32.35845,-3.86013,-.72855,32.25475,-3.83808,-.89439,32.38799,-3.89674,-.62309,32.38256,-3.86941,-.48182,32.34624,-3.92888,-.52697,32.55589,-3.93951,-.77564,32.06397,-3.86561,-.92821,32.22574,-3.92226,-.6299,31.79686,-3.8598,-.75724,31.81067,-3.78398,-.85008,31.99658,-3.82559,-1.17705,32.00298,-3.76242,-1.29452,32.03809,-3.78038,-1.29649,32.07661,-3.79371,-1.14229,32.15223,-3.87761,-1.11679,32.13719,-3.8763,-1.13684,32.30645,-3.90849,-1.00065,32.3146,-3.92,-1.27832,32.21574,-3.81274,-1.20712,32.28476,-3.8949,-.51496,31.66273,-3.75589,-.66515,31.63937,-3.68993,-.85345,31.64038,-3.65019,-.93224,31.81353,-3.69328,-1.23255,31.71872,-3.53648,-1.26534,31.79858,-3.62922,-1.1883,31.77187,-3.60779,-.43951,31.62177,-3.64713,-.64541,31.54972,-3.6098,-.30236,31.73725,-4.10348,-.37178,31.68123,-4.06879,-.21136,31.80161,-4.09425,-.19655,31.6685,-4.07265,-.2451,31.67459,-4.11073,-.56749,31.56715,-3.54797,-.43697,31.47508,-3.6489,-.51079,31.47838,-3.55342,-.43955,31.55706,-3.93245,-.44179,31.40587,-3.93131,-.44894,31.55824,-3.92241,-.45661,31.43128,-3.85568,-.17837,31.94324,-3.89315,-.19358,32.0536,-3.94608,-.17062,32.04633,-3.90494,-.2429,31.9471,-3.89775,-.27951,31.56353,-3.96888,-.30089,31.55864,-4.05189,-.20022,31.65807,-4.06644,-.33032,31.49651,-3.77401,-.43824,34.03689,-3.55,-1.63367,33.39492,-3.28841,-1.65402,33.30735,-3.36435,.01591,32.44408,-3.4302,.01591,32.54573,-3.39226,-.12229,32.56523,-3.41528,-.13789,32.44931,-3.43935,.01591,32.68029,-3.32182,.01591,32.77651,-3.28934,-.11062,32.78672,-3.29494};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_4()
		{
			double[] value = {-.12088,32.71033,-3.35205,-.12778,32.93955,-3.26897,.01591,32.92234,-3.23034,.01591,33.10638,-3.19541,-.11094,33.10914,-3.21023,-.33304,31.35744,-3.37353,-.1656,31.33954,-3.32425,-.32433,31.40724,-3.38391,-.16366,31.38382,-3.34493,-.31803,32.22496,-3.50179,-.13931,32.20203,-3.46166,-.31832,32.35735,-3.47725,-.15035,32.3416,-3.46011,-.28048,33.45875,-3.06617,-.10563,33.515,-2.97666,-.30552,33.54588,-2.99786,-.10745,33.45349,-3.05313,-.42445,31.80376,-3.4878,-.31676,31.98565,-3.50585,-.42024,32.00506,-3.5133,-.31047,31.82308,-3.5034,-.49387,31.79709,-3.49521,-.42659,32.024,-3.51123,-.45744,32.11874,-3.54966,-.44804,32.04367,-3.57211,-.40141,32.11258,-3.5107,-.67756,32.53508,-3.49712,-.85132,32.56284,-3.51194,-.78029,32.48953,-3.56743,-.64791,32.44758,-3.52915,-.56246,32.64653,-3.44882,-.63775,32.69168,-3.4715,-.73061,32.64463,-3.49104,-.41624,32.98715,-3.30573,-.41741,33.166,-3.22793,-.53461,32.98499,-3.32219,-.42778,33.48685,-3.05565,-.5108,33.55452,-3.03468,-.5698,33.49133,-3.05577,-.48565,33.63338,-2.9993,-.42357,33.65633,-2.95504,-.4889,33.66071,-2.97096,-.41741,33.59684,-2.99313,-.49807,33.70698,-2.92018,-.44194,33.71259,-2.87527,-.5784,33.77469,-2.80171,-.46104,33.82851,-2.7247,-.4457,33.94076,-2.6189,-.65203,33.87627,-2.69518,-.81171,31.88173,-3.48183,-.61206,31.94067,-3.52712,-.68635,32.03124,-3.57315,-.8706,32.00952,-3.49352,-.85622,32.66064,-3.52416,-.9681,32.74018,-3.56278,-1.03068,32.68985,-3.53106,-1.09785,32.58877,-3.53523,-1.21511,32.68526,-3.51626,-1.20148,32.61555,-3.5322,-1.04183,32.6775,-3.52815,-1.07502,33.57494,-3.04632,-.94588,33.64629,-3.09162,-1.0826,33.7067,-2.93958,-.92913,33.79565,-3.04524,-1.12581,33.14508,-3.39822,-.95756,33.17706,-3.2913,-1.22389,33.15619,-3.31577,-.98216,33.29295,-3.18434,-.771,33.18347,-3.27063,-.75552,33.31054,-3.19179,-.56392,33.31432,-3.21362,-.73589,33.40685,-3.14923,-.7485,33.40046,-3.15281,-.55645,33.39975,-3.1402,-1.39122,33.43812,-2.96866,-1.26799,33.48203,-2.97319,-1.40199,33.52214,-2.8276,-1.25806,33.60634,-2.86453,-1.04665,33.47964,-3.10369,-1.16881,33.41794,-3.08469,-1.19136,33.72649,-2.72173,-1.01409,33.81004,-2.68762,-1.05952,33.87363,-2.59387,-1.25076,33.77169,-2.57547,-.83377,33.82225,-2.7769,-.94535,33.80858,-2.78689,-.84109,33.87518,-2.68239,-.96082,33.39335,-3.15215,-.74789,33.41538,-3.14553,-.74755,33.45578,-3.12393,-.81886,33.50609,-3.181,-.58113,32.07892,-3.70402,-.75504,32.14321,-3.58731,-.65424,32.13851,-3.71961,-.71895,32.23198,-3.7276,-.75218,32.31338,-3.6782,-.85451,32.33388,-3.614,-.8155,32.2344,-3.59763,-.85438,32.40873,-3.60844,-.73913,32.39031,-3.68902};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_5()
		{
			double[] value = {-.6656,32.39728,-3.66749,-.76851,32.47881,-3.5772,-.53131,32.31681,-3.6646,-.56715,32.34555,-3.54299,-.65082,32.44022,-3.54137,-.54048,32.80526,-3.42659,-.57128,32.83532,-3.70475,-.62043,32.80081,-3.70833,-.5264,32.87206,-3.38888,-.65789,32.79498,-3.71341,-.74524,32.85582,-3.70566,-.86815,32.83028,-3.65039,-.75507,32.69115,-3.60791,-.8382,32.65455,-3.52571,-.73149,32.65503,-3.49801,-1.03524,32.80126,-3.56888,-.77199,33.17736,-3.28214,-.77536,33.18338,-3.40842,-.61969,33.12002,-3.28218,-.58296,33.49746,-3.05819,-.59028,33.52656,-3.0775,-.52805,33.57556,-3.14495,-.66001,33.5406,-3.16936,-.81253,33.86006,-3.08671,-.8526,33.7273,-3.15347,-1.46902,33.12484,-3.28645,-1.56384,32.98681,-3.39611,-1.44433,33.00907,-3.39375,-1.49694,32.8955,-3.4574,-1.42087,32.80636,-3.46766,-1.43471,32.90028,-3.42963,-1.05287,31.7586,-3.38784,-1.2085,31.78689,-3.36076,-1.20915,31.72625,-3.40981,-1.04444,31.69187,-3.39552,-.61669,31.5908,-3.51247,-.42459,31.36492,-3.4178,-.47577,31.32785,-3.51661,-.39729,31.27608,-3.50632,-1.66835,33.70045,-3.35603,-1.69531,33.74491,-3.23346,-1.65867,33.76857,-3.23342,-.16058,33.23046,-3.61564,-.13468,33.05003,-3.69409,-.20856,33.26726,-3.63752,-.1809,33.09259,-3.69758,-.19257,34.06613,-3.46453,-.1605,34.01922,-3.5102,-.16945,34.15338,-3.45838,-.78238,33.79209,-3.30253,-.7842,33.88598,-3.24371,-.54718,33.96005,-3.52444,-.58375,33.97834,-3.47047,-.58975,33.99107,-3.5453,-.78649,33.91151,-3.22102,-.67149,33.93859,-3.02921,-.66593,33.95825,-3.19038,-.77615,33.08675,-3.872,-.65781,33.15893,-3.83658,-.72654,33.19451,-3.62067,-.78656,33.0921,-3.66172,-.51618,33.04655,-3.80784,-.59451,33.15371,-3.76551,-.50487,33.03237,-3.87634,-.56986,33.11204,-3.83031,-.52629,32.88246,-3.89899,-.61437,32.81455,-3.91506,-.5229,32.88315,-3.80893,-.53935,32.87755,-3.6497,-.80446,32.96608,-3.66957,-.80785,32.97976,-3.8769,-.70861,34.362,-3.42659,-.8574,34.39157,-3.47141,-.82853,34.48289,-3.37971,-.67453,34.48073,-3.36986,.00222,34.04969,-3.81237,-.0294,33.92969,-3.73199,-.01886,33.84656,-3.74742,-.13568,33.85795,-3.70577,.01591,34.17824,-3.95791,.01591,34.04301,-3.88925,-.77465,33.81702,-3.65453,-.50885,33.91379,-3.63551,-.59084,34.00197,-3.55009,.01591,33.85672,-3.82463,.01591,33.67786,-3.96446,-.05812,33.53164,-4.04555,-.1498,33.86196,-3.70069,-.14249,33.86922,-3.69853,-.58872,33.52516,-3.7736,-.59389,33.53219,-3.77273,-.16868,33.70241,-3.77186,-.15079,33.69901,-3.77021,-.56073,33.69559,-3.66666,-.51641,33.90938,-3.62641,-.50833,33.84025,-3.64601,-.51155,33.84246,-3.63471,-.65481,33.99756,-3.51271,-.74378,33.98334,-3.50526,-.78922,33.96887,-3.5429};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_6()
		{
			double[] value = {-.5587,33.69921,-3.65118,-.52405,33.5752,-3.04816,-.50139,33.67352,-2.97342,-.49718,33.63603,-3.00561,-.50136,33.56728,-3.03073,-.41213,33.49023,-3.04931,-.50533,33.71319,-2.92716,-.49618,33.67092,-2.96107,.01591,33.95114,-3.29736,.01591,33.85227,-3.36654,-.06592,33.81368,-3.38567,-.06954,34.00283,-3.29367,-.52037,33.56303,-3.03842,-.51208,33.57501,-3.03505,-.50128,33.63374,-3.0098,-.48054,33.67945,-3.12559,-.81773,33.92652,-3.62715,-.81493,33.93166,-3.62263,-.81198,33.92047,-3.61624,-.22654,33.4718,-3.5608,-.23259,33.49715,-3.61078,-.22638,33.29173,-3.68396,-.51141,33.8953,-3.55824,-.62738,33.60624,-3.32511,-.54848,33.65799,-3.48244,-.59708,33.65945,-3.48557,-.53826,33.61678,-3.31369,-.77704,33.92232,-3.39779,-.76513,33.94742,-3.36314,-.76884,33.85647,-3.45678,-.42251,33.71419,-3.40816,-.33141,33.73333,-3.46399,-.30274,33.77531,-3.51958,-.41144,33.7523,-3.48944,-.49951,33.81899,-3.55762,-.51245,33.72955,-3.45896,-.39192,33.83266,-3.5451,-.2466,33.75116,-3.51596,-.20886,33.8002,-3.54809,-.34226,33.91638,-3.31871,-.43555,33.8989,-3.24401,-.4601,33.97014,-3.34277,-.3545,33.98677,-3.37475,-.2626,33.98407,-3.35522,-.25032,33.87286,-3.38537,-.26914,33.9609,-3.36426,-.24478,33.86735,-3.37528,-.56414,33.95316,-3.3173,-.56967,33.94846,-3.29476,-.57794,33.95243,-3.3068,-.52721,33.72377,-3.49453,-.52756,33.71061,-3.46536,-.47774,33.81954,-3.18154,-.48195,33.81224,-3.15626,-.52471,33.88586,-3.16729,-.51609,33.88381,-3.17951,-1.72815,33.45907,-2.75761,-1.72068,33.54057,-2.60207,-1.70554,33.52886,-2.79314,-1.63653,33.67856,-3.3337,-1.59437,33.56041,-3.45336,-1.62008,33.64455,-3.30892,-1.5957,33.53579,-3.38231,-1.68771,33.09805,-3.332,-1.61109,33.01702,-3.37771,-1.67902,33.11252,-3.2841,-1.71727,33.36295,-2.83894,-1.71698,33.43602,-2.70264,-1.7248,33.4372,-2.71186,-1.73057,33.36524,-2.84013,-1.7064,33.24376,-3.07744,-1.71774,33.29163,-2.97203,-1.7322,33.29078,-2.97362,-1.6787,33.1224,-3.26315,-1.61551,33.56818,-3.51431,-1.67081,33.69328,-3.35256,-1.60982,33.57556,-3.52086,-1.7685,33.36383,-2.85882,-1.00142,32.97668,-3.9536,-.97976,32.98151,-3.94758,-.15983,32.27766,-3.88345,-.16314,32.33394,-3.8615,-.16278,32.32602,-3.85413,-.15862,32.87272,-3.87599,-.17925,32.59281,-3.85444,-.16168,32.63106,-3.91846,-.19072,32.83956,-3.80579,-.14793,32.45604,-3.93046,-.13706,32.42197,-3.9552,.01591,33.03871,-4.17731,-.07045,33.10284,-4.17372,.00264,33.11637,-4.22041,.01591,32.99179,-4.10659,.01591,32.89553,-4.08618,-.01941,32.99491,-4.07046,-.01876,32.89782,-4.07695,-.06258,32.91696,-4.02799,-.09607,33.03894,-4.04035,-.276,32.60996,-4.09513,-.30636,32.59472,-4.08118};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_7()
		{
			double[] value = {-.31893,32.72159,-4.03876,-.52941,32.87145,-3.909,-.47868,32.74935,-3.95732,-.4485,32.37726,-4.0256,-.17919,32.68954,-4.12813,.01591,32.78887,-4.10211,-.04187,32.69915,-4.15414,-.03131,32.79965,-4.08911,.01591,32.68543,-4.15675,-.1739,33.05059,-4.02197,-.11401,33.08108,-4.05279,-.09578,33.05202,-4.05017,-.18051,33.03617,-4.0115,-.19619,33.04253,-4.01371,-.18797,33.05034,-4.01268,-.32736,32.73541,-4.03934,-.52058,32.88514,-3.91226,-.78255,33.08965,-3.88069,-.7757,33.0953,-3.87787,-.66394,32.82075,-3.88768,-.50115,33.03047,-3.90765,-.027,33.01192,-4.07367,-.53827,32.98234,-3.33217,-.53068,32.97182,-3.32574,-.53307,32.80655,-3.41333,-.53897,32.7937,-3.41974,-.41769,32.972,-3.30645,-1.22875,32.75497,-3.50032,-1.67453,33.1197,-3.26236,-1.20886,32.25355,-3.50094,-1.1903,32.251,-3.48566,-1.20122,32.41982,-3.50534,-1.21918,32.4196,-3.51576,-1.30789,32.04818,-3.7707,-.57572,33.15024,-3.75421,-.5065,33.05294,-3.78149,-.62612,33.17377,-3.69163,-.20114,33.00447,-3.74912,-.20021,33.06023,-3.7246,-.18515,32.80985,-3.76234,-.46327,33.16145,-3.61535,-.58033,33.1499,-3.55664,-.60445,33.16847,-3.68708,-.45193,33.20065,-3.72359,-.3444,33.17957,-3.66817,-.23197,33.16691,-3.68837,-.22065,33.11412,-3.71061,-.31996,33.10185,-3.64945,-.51064,32.9004,-3.79477,-.39176,32.95085,-3.80374,-.49517,32.98569,-3.79774,-.4003,33.16307,-3.7778,-.15752,33.2582,-3.77919,-.23796,33.22338,-3.70153,-.29791,33.22424,-3.75788,-.21518,33.03525,-3.72893,-.19955,32.94801,-3.78674,-.21535,32.97808,-3.79182,-.21613,33.18269,-3.68434,-.2016,33.11254,-3.70758,-.22532,33.25653,-3.6965,-.50685,32.98414,-3.8216,-.45801,32.03222,-3.57113,-.45866,32.04193,-3.58982,-.46539,32.19075,-3.54934,-.47051,32.2048,-3.5491,-.47193,32.19652,-3.56099,-.40669,32.23282,-3.50794,-.40246,32.21752,-3.50468,-.44751,32.01796,-3.51802,-.14975,31.96802,-3.47487,-.15071,31.95443,-3.48118,-.31799,31.99961,-3.5023,-.60264,31.9298,-3.523,-.43968,32.08971,-3.67989,-.48324,32.0747,-3.70018,-.59424,32.37792,-3.63493,-.61705,32.37127,-3.85843,-.57299,32.10574,-3.8647,-.47715,32.12026,-3.86902,-.4902,32.34537,-3.89498,-.48759,32.33798,-3.91292,-.42319,32.21952,-3.88678,-.43587,32.22115,-3.87559,-.46432,32.2221,-4.03078,-.45956,32.224,-4.03939,-.2839,32.38946,-4.09937,-.2613,32.38983,-4.11524,-.5157,32.37696,-3.8214,-.53114,32.36751,-3.73588,-.4334,32.15475,-3.82692,-.45017,32.16989,-3.8779,-.43947,32.13181,-3.74824,-.3316,32.20615,-3.86751,-.23256,32.25234,-3.91177,-.33369,32.26722,-3.90138,-.23089,32.31061,-3.93414,-.37208,32.3625,-3.91098,-.4865,32.38069,-3.81422,-.47691,32.3507,-3.88906};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_8()
		{
			double[] value = {-.38389,32.39715,-3.85323,-.3989,32.38082,-3.78753,-.28212,32.39617,-3.84106,-.40595,32.32485,-3.74417,-.28485,32.33631,-3.80927,-.14898,32.3021,-3.95802,-.14295,32.3537,-3.96305,-.26615,32.41654,-3.8902,-.14783,32.38776,-3.95788,-.16255,32.43361,-3.92273,-.25266,32.37595,-3.93596,-.2418,32.23484,-3.87457,-.17104,32.27672,-3.88617,-.14936,32.28032,-3.94039,-.25842,32.2536,-3.81637,-.50715,32.35182,-3.88257,-.53683,32.32278,-3.67264,-.51388,32.31464,-3.68614,-.4478,32.196,-3.67368,-.45616,32.1671,-3.66907,-.42425,32.14772,-3.74739,-.50031,32.36256,-3.73255,-.12085,32.39372,-3.96846,-.17692,32.34653,-3.86729,-.18074,32.41598,-3.89349,-.16882,32.43587,-3.88258,-.16741,32.40471,-3.86801,-.14285,32.26762,-3.93857,-.12815,32.29254,-3.9638,-.11645,32.35414,-3.97692,-.9976,32.33895,-3.91064,-.97911,32.33223,-3.91067,-.95475,32.21415,-3.92262,-1.27834,32.24801,-3.81932,-1.21688,32.31106,-3.88261,-1.23182,31.73041,-3.42549,-1.21061,31.71739,-3.42813,-.87361,31.6569,-3.40577,-.89723,31.73032,-3.41492,-.40908,31.5063,-3.72585,-.41226,31.5152,-3.67366,-.40649,31.5308,-3.7153,-.44568,31.60278,-3.85193,-.43632,31.57882,-3.79058,-.40886,31.59972,-3.67576,-.49836,31.96785,-3.94369,-.44098,32.1628,-3.89066,-.46554,32.21875,-4.02878,-.47042,32.10864,-3.88097,.01591,32.22033,-4.07523,-.40425,32.69413,-4.01832,-.20794,31.81684,-4.08438,-.2129,31.81273,-4.09286,-.27825,31.56911,-3.95502,-.28476,31.56058,-3.96096,-.2848,31.42817,-3.95674,-.00836,32.18118,-4.03189,.01591,32.20331,-4.04232,-.18829,32.05651,-3.99114,-.26857,31.92109,-3.93804,-.24839,31.96843,-3.94061,-.19637,32.01107,-4.02632,-.16308,32.05833,-4.01942,-.23456,31.98877,-3.9815,-.28376,31.71408,-3.95082,-.19159,31.6716,-4.0606,-.31097,31.57589,-3.89372,-.23939,31.88738,-4.05996,-.27381,31.82838,-3.97648,-.26339,31.91844,-3.98043,-.0777,31.22384,-3.64166,-.22009,31.20666,-3.60959,-.09299,31.29194,-3.6724,-.22237,31.28345,-3.66923,-.29758,31.73131,-3.91458,-.33021,31.60936,-3.74663,-.33706,31.59962,-3.8289,-.29735,31.78309,-3.82038,-.24514,31.88639,-4.06726,-1.57792,34.40537,-2.72787,-1.61344,34.24232,-2.75325,-1.78895,34.22918,-2.62658,-1.38551,34.43406,-2.85491,-1.47359,34.35207,-2.84447,-1.6027,34.11897,-2.85621,-1.47682,34.29243,-2.85611,-1.41293,34.26216,-2.89156,-1.70228,34.13198,-2.7526,-1.74891,34.09104,-2.72648,-1.8448,34.1625,-2.62761,-1.82063,34.26471,-2.58051,-1.87006,34.34281,-2.51295,-1.81896,34.34955,-2.55014,-1.88354,34.22617,-2.56518,-1.90443,34.27931,-2.42025,-1.89047,34.21331,-2.54848,-1.86174,34.13493,-2.46156,-1.88135,34.3399,-2.49538,-1.79264,33.65083,-2.31285,-1.83125,33.66668,-2.24386};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_9()
		{
			double[] value = {-1.78933,33.73013,-2.35703,-1.8241,33.76695,-2.02141,-1.90182,33.72588,-2.12641,-1.78717,33.68645,-2.16278,-1.87922,33.88927,-1.88149,-1.94634,34.03214,-1.82922,-1.97278,33.94855,-1.93755,-1.92836,33.84835,-2.01076,-1.95946,34.42818,-2.28866,-1.92146,34.46451,-2.40109,-1.91767,34.24993,-2.31983,-1.86227,34.05087,-2.36544,-1.85454,33.96349,-2.30051,-1.91212,34.04318,-2.2314,-1.78944,33.84425,-2.40879,-1.69835,33.92941,-2.62572,-1.73763,33.78479,-2.54119,-1.78667,33.97715,-2.48605,-1.81897,34.44758,-2.54668,-1.67666,34.5373,-2.64472,-1.79355,34.40824,-2.55396,-1.8926,34.54587,-2.47918,-1.92802,34.71457,-2.49283,-1.84195,34.59344,-2.5327,-1.44132,34.75458,-2.80831,-1.57658,34.62772,-2.73218,-1.61304,34.70335,-2.67362,-2.06165,34.91093,-2.31885,-1.99381,35.07357,-2.37876,-1.95952,34.81224,-2.46514,-1.9324,35.17354,-2.20972,-1.85948,35.14011,-2.33376,-2.02952,35.10525,-2.23147,-1.75565,35.21682,-2.32152,-1.78964,34.98057,-2.45502,-1.4493,34.83829,-2.7915,-1.43316,34.90759,-2.76286,-1.30879,34.90174,-2.87799,-1.3654,34.96196,-2.69499,-1.26782,35.00634,-2.65402,-1.24092,34.99162,-2.76645,-1.4195,35.03774,-2.47433,-1.31447,35.01287,-2.58031,-1.52818,34.97083,-2.50525,-1.51752,35.10007,-2.38403,-1.6141,35.03777,-2.41018,-1.21186,34.72379,-3.03025,-1.06675,34.60818,-3.18935,-1.0869,34.58411,-3.19243,-1.13278,34.79354,-3.006,-1.16768,34.98604,-2.79117,-1.01658,34.91864,-2.8171,-1.17663,34.94185,-2.88154,-.97892,34.75404,-2.94849,-.88878,34.66491,-3.07118,-.99115,34.49927,-3.35349,-.76999,34.59607,-3.1895,-.67347,34.65902,-3.22616,-.67611,34.65191,-3.23754,-2.06155,34.1912,-1.90705,-2.01686,34.30306,-1.83436,-2.10626,34.47417,-1.93259,-2.06365,34.80063,-1.92122,-2.10156,34.66894,-1.99807,-2.06013,34.55678,-1.871,-1.48496,35.32375,-1.88881,-1.30653,35.29337,-1.82251,-1.48689,35.44113,-1.92605,-1.30022,35.42773,-1.85856,-1.22061,35.34099,-1.80409,-1.0132,35.2828,-1.734,-.99013,35.38649,-1.82669,-1.12807,35.37979,-1.81014,-.7838,35.26443,-1.79263,-.69311,35.34083,-1.77498,-.72416,35.31898,-1.84101,-.76392,35.3092,-1.70638,-.59808,35.17744,-1.54628,-.4804,35.14204,-1.56242,-.49301,35.19923,-1.63355,-.32149,35.19015,-1.65911,-.30334,35.26839,-1.72086,-.39495,35.28514,-1.74666,-.48176,35.28628,-1.71509,-.5957,35.37357,-1.80305,-.68513,35.33955,-1.76373,-.33583,35.37859,-1.81599,-.43867,35.39948,-1.82528,.01591,35.43023,-2.58134,.01591,35.40908,-2.67955,-.00153,35.39543,-2.66076,-.05015,35.41099,-2.55691,-.01493,35.33085,-3.23046,-.02733,35.15848,-3.31833,-.03669,35.06791,-3.20697,-.05345,35.22633,-3.10345,-.07008,35.01446,-3.10963,-.00092,34.82945,-3.16671,-.14993,34.8611,-3.07023,-.03072,34.71445,-3.28961};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_10()
		{
			double[] value = {-.05266,34.70802,-3.26924,.00101,34.85843,-3.27718,-.11622,35.3143,-2.75587,-.31593,35.22104,-2.52864,-.16315,35.32732,-2.58283,-.23273,35.20093,-2.70123,-.447,35.23373,-2.42307,-.37954,35.19236,-2.53438,-.44451,35.13769,-2.72649,-.33363,35.10074,-2.83562,-.40839,35.07282,-2.83376,-.35515,35.16208,-2.68447,-.38362,34.94457,-2.98679,-.2752,34.86572,-3.04911,-.37316,34.88017,-3.04855,-.28689,34.98369,-2.95853,-.59706,34.8445,-2.90968,-.61646,34.916,-2.84892,-.5879,34.87242,-2.93923,-.55113,34.48075,-3.35882,-.64918,34.6618,-3.24311,-.4946,34.68347,-3.22355,-.35799,34.75621,-3.10744,-.27585,34.76833,-3.09849,-.53187,35.09111,-2.86958,-.61647,35.05025,-2.84214,-.55888,35.12327,-2.75987,-.56503,35.12284,-2.74505,-.60296,35.09233,-2.69027,-.58862,35.14402,-2.52257,-.48472,35.17285,-2.60007,-.7615,35.11835,-2.56625,-.76991,35.28024,-2.42821,-.76444,35.01025,-2.66001,-.8581,35.15408,-2.58894,-.83389,34.9947,-2.68234,-1.05291,35.05851,-2.70431,-.96818,35.22656,-2.63368,-1.03087,35.31075,-2.46854,-1.07647,35.3144,-2.44371,-1.04822,35.41342,-2.34375,-1.208,35.21913,-2.56343,-1.16883,35.12322,-2.62845,-1.29032,35.14335,-2.49491,-1.21809,35.07867,-2.63607,-.46581,35.36494,-2.25187,-.39713,35.35438,-2.31558,-.48698,35.22262,-2.29162,-.56097,35.49257,-2.16733,-.39989,35.51087,-2.09145,-.40517,35.46933,-2.15148,-.57558,35.58168,-2.07886,-.61729,35.66964,-2.02241,-.56181,35.67791,-1.94468,-.48804,35.60457,-1.9817,-.69246,35.35303,-2.33977,-.65264,35.42492,-2.37171,-.58591,35.36583,-2.25654,-.763,35.40953,-2.46371,-.70939,35.44639,-2.48781,-.87824,35.79097,-2.5881,-.86261,35.8141,-2.60881,-.86888,35.60701,-2.62969,-.8075,35.68488,-2.6265,-.96648,35.75673,-2.48756,-.93964,35.62795,-2.56779,-.85415,35.90783,-2.35313,-.88479,36.03775,-2.20676,-.83373,35.9051,-2.26569,-.89728,36.0301,-2.38705,-.79803,35.8911,-2.13104,-.74814,35.86294,-1.96331,-.73591,35.82051,-2.06218,-.83614,35.98845,-2.08893,-.60089,35.37515,-1.81473,-.62596,35.3434,-1.87979,-.80234,35.42545,-1.90459,-.69009,35.40067,-1.92822,-.92701,35.43549,-1.98083,-.95132,35.64564,-2.10689,-1.00244,35.5144,-2.07272,-.88533,35.55978,-1.99561,-.77152,35.84523,-1.94818,-.86241,35.97,-2.07741,-.81613,35.72599,-1.98125,-.86372,35.83306,-2.08068,-.73689,35.85286,-1.9545,-.65549,35.76008,-1.88298,-.62913,35.73627,-1.93934,-1.07207,35.45932,-1.89645,-1.29153,35.55181,-1.90007,-1.19372,35.56746,-2.00004,-1.28017,35.64887,-2.0351,-1.36081,35.71844,-2.15091,-1.40908,35.7377,-2.07674,-1.26664,35.63189,-2.13133,-1.276,35.61735,-2.28272,-1.38529,35.68984,-2.24191,-1.29001,35.5901,-2.3582,-1.33418,35.51821,-2.47123};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_11()
		{
			double[] value = {-1.43386,35.66989,-2.33226,-1.15809,35.44971,-2.40651,-1.60774,35.40847,-2.3014,-1.68442,35.36666,-2.19819,-1.68904,35.40873,-2.21279,-1.56329,35.33636,-2.28143,-1.47134,35.21528,-2.3392,-1.57034,35.27548,-2.26298,-1.81333,35.25964,-2.19652,-2.11681,34.82972,-2.10949,-2.10689,34.91197,-2.17294,-2.1083,34.91258,-2.20543,-2.08975,34.76852,-2.15042,-2.07661,34.81038,-2.20511,-1.50985,35.41224,-2.41945,-1.59173,35.54794,-2.37223,-1.40495,35.45121,-2.52202,-1.66329,35.51349,-2.30056,-1.71684,35.49831,-2.24326,-1.71177,35.58443,-2.24268,-1.68052,35.41902,-2.10809,-1.68328,35.39615,-2.09374,-1.13366,35.5045,-2.13153,-1.05299,35.50537,-2.17576,-1.05007,35.45279,-2.29816,-1.14302,35.51028,-2.30836,-1.09077,35.5245,-2.03064,-1.0348,35.49848,-2.06252,-1.60856,35.68305,-2.32685,-1.63064,35.76789,-2.26906,-1.54811,35.73689,-2.30366,-1.77964,34.81295,-2.53244,-1.71044,34.64466,-2.5845,-.63182,35.39133,-1.96023,-.50699,35.36951,-2.00608,-.4555,35.44266,-2.04484,-.59119,35.47343,-1.97274,-.1456,34.14133,-2.20301,.01591,34.12458,-2.17161,-.15176,34.15017,-2.11215,.01591,34.14721,-2.10401,-.32608,34.0866,-2.38044,-.44979,34.14055,-2.37263,-.28763,33.9182,-2.6276,-.45332,34.19632,-2.21191,-.35073,34.17098,-2.11483,-.47104,34.23331,-2.13678,-.319,34.16884,-2.21744,-.46602,34.33454,-2.05102,-.33897,34.27864,-2.00744,-.4994,34.41246,-1.90476,-.34746,34.36292,-1.87258,-.3687,34.472,-1.63165,-.64472,34.60779,-1.5305,-.58109,34.5052,-1.74791,-.39727,34.54395,-1.3746,-.44302,34.58024,-1.19682,-.62797,34.05576,-2.50076,-.66073,33.9511,-2.60882,-.55033,34.36725,-2.09008,-.65935,34.43579,-1.96955,-.7004,34.66472,-1.46263,-.81804,34.75833,-1.44949,-.80714,34.65114,-1.58846,-.63347,34.68171,-1.26065,-.75333,34.78155,-1.34958,-1.23222,34.00226,-2.41645,-1.42853,33.8142,-2.39863,-1.43707,33.65248,-2.57211,-1.01404,34.13749,-2.45788,-1.09941,34.19714,-2.39634,-.9265,34.2661,-2.4729,-1.00546,34.30639,-2.44806,-.60142,34.26304,-2.35478,-.57717,34.21699,-2.33736,-.55554,34.31996,-2.30416,-.54378,34.25245,-2.23805,-.70674,34.50111,-1.85482,-.77747,34.59772,-1.66576,-.88071,34.56078,-1.7434,-.78234,34.49467,-1.94917,-1.06363,34.44874,-2.02812,-1.28272,34.35613,-1.90966,-1.19104,34.33982,-2.0476,-1.14142,34.4568,-1.85837,-.69863,34.25575,-2.43413,-.60432,34.27464,-2.36245,-.69015,34.37765,-2.51322,-.59587,34.38322,-2.47066,-.61776,34.39674,-2.12022,-.53706,34.2922,-2.15187,-.54404,34.35821,-2.10063,-.57657,34.35359,-2.20958,-1.05855,34.33209,-2.33814,-.93936,34.44106,-2.47939,-.9727,34.47179,-2.42923,-.68092,34.50813,-2.06384,-.69712,34.45819,-2.0128,-.77299,34.56756,-2.05513,-.57848,34.36169,-2.22157};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_12()
		{
			double[] value = {-.56715,34.43185,-2.25896,-.56181,34.39509,-2.35365,-.55587,34.33215,-2.30783,-.96651,34.73777,-1.59925,-.94227,34.6296,-1.67287,-1.06537,34.58905,-1.75023,-1.23019,34.64173,-1.75353,-1.19194,34.52452,-1.7956,-1.11476,34.68582,-1.68998,-1.77932,34.02954,-1.87288,-1.86129,33.89403,-1.8763,-1.80568,33.77253,-2.01937,-1.69184,33.93739,-1.98667,-1.59964,34.93148,-1.86562,-1.58514,34.78824,-1.83116,-1.51824,34.94886,-1.84449,-1.30147,35.09768,-1.79867,-1.45884,35.11053,-1.86092,-.22451,34.53173,-1.12605,-.45617,34.63407,-1.08285,-.23339,34.59315,-1.04852,-.85964,34.89011,-1.41379,-.81922,34.91354,-1.31681,-.87662,34.99894,-1.38952,-.89613,34.98298,-1.47892,-.71584,35.00614,-1.32532,-.81029,34.9183,-1.30338,-.79543,34.89203,-1.28586,-1.74343,33.61842,-2.24532,-1.73002,33.56742,-2.36227,-1.63965,33.64183,-2.37911,-1.63099,33.73238,-2.29293,.01591,34.83432,-2.57473,.01591,34.75988,-2.659,-.07321,34.80548,-2.66081,-.08844,34.87505,-2.53454,-.47993,35.35577,-1.93088,-.45908,35.29059,-2.01378,-.30874,34.58759,-2.96698,-.27018,34.62005,-3.03509,-.27155,34.7771,-2.89463,-.287,34.75188,-2.84157,-.23548,35.25201,-2.48636,-.2966,35.14543,-2.50402,-.2541,35.15978,-2.59416,-.30084,35.25889,-2.39638,-.49113,35.3242,-2.0853,-.45125,35.14677,-2.15314,-.43032,35.24891,-2.22527,-.13307,35.26254,-2.58838,-.12094,35.35219,-2.49985,-.22498,35.3403,-2.34232,-.31379,34.98455,-2.56275,-.38407,35.08354,-2.46419,-.32526,34.95921,-2.53661,-.36725,35.00898,-2.39608,-.63711,34.74717,-2.43679,-.6284,34.64536,-2.3661,-.67797,34.69827,-2.31655,-1.2204,34.29118,-3.01846,-1.26829,34.3159,-2.95993,-1.31745,34.30687,-2.92388,-.48278,34.97741,-3.00093,-.61254,34.99427,-2.92822,-.59297,34.60564,-2.79405,-.57759,34.6854,-2.85923,-.5752,34.7043,-2.96305,-.57339,34.6188,-2.77077,-.46891,34.86227,-3.10058,-.59713,34.87984,-3.0984,-.60489,34.94,-3.01657,-.68223,35.10534,-2.62826,-.60524,34.49638,-2.63136,-.56654,34.49815,-2.57523,-.5692,34.55219,-2.6823,-.69178,34.47726,-2.66317,-.79878,34.3838,-2.52741,-.79337,34.48948,-2.65707,-.68792,34.56628,-2.81943,-.79091,34.5894,-2.79913,-.65742,34.89617,-2.62854,-.64983,34.83297,-2.52179,-.69075,34.84366,-2.50602,-.75075,34.741,-2.30162,-.6652,34.55288,-2.12708,-.7422,34.61997,-2.11316,-.6162,35.06137,-2.81233,-.5833,34.76457,-2.92909,-.54686,34.70295,-2.82632,-.55867,34.76736,-2.85522,-.58038,34.89245,-2.80915,-.57089,34.80348,-2.85732,-.60755,34.8862,-2.63292,-.6033,34.82783,-2.54973,-.57875,34.69157,-2.43484,-.5991,34.75441,-2.48312,-.19373,34.90301,-2.86478,-.21486,34.86783,-2.86935,-.16945,34.82555,-2.97485,-.28019,34.78721,-2.83293};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_13()
		{
			double[] value = {-.30728,34.75523,-2.78764,-.21859,35.0354,-2.76258,-.30387,34.92574,-2.64431,-.29254,34.98086,-2.6336,-.29235,35.03196,-2.61167,-.29262,34.89917,-2.61924,-.49927,34.82899,-2.55866,-.50244,34.79037,-2.51796,-.37639,34.75546,-2.7716,-.37805,34.75471,-2.72544,-.32446,34.76814,-2.78377,-.34238,34.77998,-2.72021,-.4707,34.8198,-2.8578,-.4767,34.81141,-2.85612,-.47805,34.87537,-2.81161,-.48402,34.90768,-2.7791,-.59731,34.91886,-2.76547,-.48953,34.92466,-2.73556,-.34795,34.95624,-2.76041,-.35934,34.96813,-2.73972,-.49408,34.91558,-2.68552,-.2779,35.04214,-2.67719,-.47775,34.66571,-2.6327,-.5469,34.60016,-2.6836,-.53598,34.57724,-2.60354,-.47666,34.66701,-2.70147,-.3447,34.9276,-2.80533,-.22338,34.9441,-2.82804,-.22307,34.98595,-2.79883,-.34556,34.84641,-2.85711,-.34355,34.89092,-2.83457,-.37656,34.98046,-2.68912,-.23781,35.00084,-2.78725,-.24215,35.01726,-2.76082,-.49951,34.88091,-2.61951,-.3823,34.77765,-2.67425,-.32469,34.92608,-2.64696,-.345,34.85628,-2.66738,-.38324,34.81006,-2.63313,-.47733,34.77739,-2.85135,-.37518,34.7737,-2.81821,-.36689,34.79941,-2.84611,-.47765,34.73147,-2.82305,-.47748,34.69733,-2.76246,-.69792,34.97776,-2.68735,-.64275,34.96217,-2.73586,-.27025,35.05413,-2.66595,-.16945,34.99359,-2.85397,-.1996,34.95302,-2.84053,-.89656,35.09015,-1.45506,-.87296,35.218,-1.56,-.88498,35.21663,-1.56838,-.90702,35.08433,-1.46223,-1.13932,35.25628,-1.74712,-1.0187,35.21287,-1.67602,-.86245,35.3552,-1.88647,-1.02844,35.45048,-1.93224,-1.52492,35.77541,-2.23404,-1.55092,35.80673,-2.14374,-1.6462,35.45735,-2.05209,-1.60912,35.51855,-2.01044,-1.65504,35.50398,-2.07437,-1.2382,35.38598,-2.49153,-1.07974,35.22035,-2.55249,-1.14223,35.26676,-2.50357,-1.71464,33.51799,-2.50686,-1.70584,33.51448,-2.50504,-1.74085,33.56797,-2.37057,-1.75691,33.61643,-2.25214,-1.93104,33.85308,-2.03043,-2.05343,34.79454,-2.28779,-1.99175,34.72605,-2.35817,-2.021,34.7076,-2.27479,-2.06489,34.73237,-2.18932,-1.95206,34.16389,-2.18234,-1.99236,34.26571,-2.17775,-1.87169,34.35475,-2.51133,-1.94875,34.79834,-2.47399,-1.96201,34.79155,-2.46111,-1.00191,35.26736,-2.53616,-1.03873,35.25579,-2.52277,-1.01369,35.3181,-2.47915,-1.02254,35.46907,-2.29784,-.99633,35.66151,-2.30047,-1.04228,35.59779,-2.43386,-.95464,35.87649,-2.35309,-.96009,35.81197,-2.43892,-.92613,36.00639,-2.38589,-.90738,36.01184,-2.19844,-.90326,36.03043,-2.38785,-.89103,36.03707,-2.20442,-.75025,35.57397,-2.44097,-.75294,35.50521,-2.57602,-.78224,35.64699,-2.5143,-.70686,35.4581,-2.48705,-.78274,35.57079,-2.61633,-.79917,35.68784,-2.62006,-.40399,35.4934,-2.07257,-.39412,35.50685,-2.08506,-.47317,35.61283,-1.93445};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_14()
		{
			double[] value = {-.50235,35.57147,-1.93271,-.55705,35.69286,-1.89302,-.4752,35.61943,-1.94291,-.75462,35.86099,-1.95659,-.3926,35.46297,-2.14719,-.8545,35.81463,-2.60604,-.55873,35.68716,-1.885,-1.03225,35.64758,-2.4683,-.93042,35.36832,-2.53472,-.93987,35.31104,-2.55307,-.82191,35.38667,-2.49653,-.7312,35.31558,-2.38362,-.89299,35.42119,-2.53397,-.94257,35.44247,-2.49684,-.92683,35.46413,-2.54697,-.65061,35.438,-2.37115,-.8612,35.44296,-2.55755,-.84246,35.30671,-2.49617,-.87276,35.32877,-2.50496,-.31079,35.40067,-2.23308,-.40098,35.46338,-2.15548,-.30631,35.39285,-2.21453,-.43685,35.40333,-2.11271,-.36852,35.31449,-2.26003,-.41701,35.43226,-2.12273,-.30509,35.36035,-2.24536,-.33006,35.23814,-2.38561,.01591,35.37754,-3.19312,.01591,35.34559,-3.15917,.01591,35.37229,-3.27102,.01591,35.05182,-3.38111,.0072,35.01208,-3.30489,.01591,34.84534,-3.32178,.01591,34.71572,-3.32078,-.05229,34.69089,-3.27178,-.02551,34.69676,-3.29032,-.47971,34.68426,-3.22046,-.49044,34.69681,-3.21481,-.12116,34.74658,-3.16851,-.1313,34.73573,-3.17127,-.62819,35.04148,-2.83151,-.65518,34.67192,-3.2348,-.67854,34.64471,-2.982,-.57621,34.79149,-3.0349,-.60358,34.87494,-3.09388,-.63838,34.77343,-3.16434,-.61356,34.73154,-3.13554,-.57495,34.85114,-2.97222,-.61104,34.93117,-3.01412,-.61131,34.93266,-3.01159,-.46896,34.31847,-2.05775,-.45151,34.20051,-2.22948,-.54102,34.25777,-2.2243,-.70114,35.00207,-2.68795,-.72726,34.98409,-2.67305,-.82705,34.97398,-2.67594,-.90187,34.95766,-2.71999,-.86942,34.93356,-2.71133,-.79106,34.68217,-2.94599,-.90298,34.75534,-2.91099,-.88769,34.74562,-2.89404,-.56424,35.31906,-2.25333,-.59624,35.29448,-2.25152,-.5912,35.32784,-2.25481,-.58265,35.25814,-2.28837,-.55122,35.27189,-2.26899,-.25596,34.81311,-2.85365,-.28173,35.02578,-2.64107,-.2184,34.90345,-2.84814,-.23286,34.88132,-2.85545,-.29324,34.80162,-2.82461,-.32547,34.78011,-2.71591,-.30761,34.87368,-2.65907,-.30611,34.9855,-2.63847,-.30703,34.71799,-2.76844,-.57607,34.34648,-2.21745,-.62435,34.40658,-2.12632,-.84923,34.25069,-2.47916,-.69749,34.24208,-2.42984,-1.74918,33.5966,-2.40772,-1.75134,34.01867,-2.84684,-1.75269,34.0719,-2.71865,-1.7567,34.00514,-2.84257,-1.69982,33.88557,-2.95367,-1.69325,33.91964,-2.80428,-1.74095,33.92047,-2.96869,-.01637,34.53474,-3.4274,.01591,34.56857,-3.43855,-.48707,31.33986,-3.53097,-.38843,31.25235,-3.54508,-.39777,31.29482,-3.55724,-.32084,31.29843,-3.6519,-.43411,31.46681,-3.69577,-.4108,31.42112,-3.81816,-.35037,31.42397,-3.83553,-.38146,31.45064,-3.7136,-.44659,31.33463,-3.81876,-.43838,31.30173,-3.8767,-.37978,31.31158,-3.83385,-.36446,31.28849,-3.89972};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_15()
		{
			double[] value = {-.4742,31.362,-3.60518,-.31377,31.291,-3.90051,-.31583,31.29554,-3.85757,-.46321,31.71709,-3.91183,-.44336,31.58546,-3.88243,-.46166,31.70549,-3.93226,-.44537,31.46122,-3.7885,-.6256,31.57537,-3.52833,.36214,31.49651,-3.77401,.35569,31.46805,-3.85772,.32863,31.40356,-3.85549,.3621,31.43436,-3.73157,.50186,31.76713,-3.93323,.50253,31.76709,-3.9328,.51099,31.7585,-3.9277,.49574,31.76048,-3.94106,.49504,31.71709,-3.91183,.4775,31.60278,-3.85193,.47719,31.46122,-3.7885,.47518,31.58546,-3.88243,.4409,31.5063,-3.72585,.44263,31.42112,-3.81816,.46593,31.46681,-3.69577,.34559,31.291,-3.90051,.40344,31.39807,-3.96452,.39628,31.28849,-3.89972,.31663,31.42817,-3.95674,.42025,31.25235,-3.54508,.34781,31.22205,-3.56538,.42959,31.29482,-3.55724,.34491,31.24978,-3.58351,1.7525,33.54057,-2.60207,1.69589,33.65685,-2.8583,1.73719,33.70678,-2.66432,1.73736,33.52886,-2.79314,.64958,34.39674,-2.12022,.58215,34.36725,-2.09008,.57586,34.35821,-2.10063,.73045,34.25575,-2.43413,.63324,34.26304,-2.35478,.72931,34.24208,-2.42984,.63614,34.27464,-2.36245,.58769,34.33215,-2.30783,.60789,34.34648,-2.21745,.58487,34.32124,-2.29147,.6103,34.36169,-2.22157,.58737,34.31996,-2.30416,.33885,34.71799,-2.76844,.3391,34.75523,-2.78764,.31882,34.75188,-2.84157,.37274,34.99024,-2.65547,.38041,34.95778,-2.62192,.25041,35.0354,-2.76258,.23512,35.00303,-2.80127,.26963,35.00084,-2.78725,.27397,35.01726,-2.76082,.33793,34.9855,-2.63847,.35651,34.92608,-2.64696,.32436,34.98086,-2.6336,.33569,34.92574,-2.64431,.3742,34.77998,-2.72021,.35628,34.76814,-2.78377,.35729,34.78011,-2.71591,.25489,34.98595,-2.79883,.20127,34.82555,-2.97485,.26649,34.84131,-2.8644,.24668,34.86783,-2.86935,.66399,35.3235,-2.2869,.61447,35.25814,-2.28837,.62806,35.29448,-2.25152,.58304,35.27189,-2.26899,.59606,35.31906,-2.25333,.62303,35.32784,-2.25481,.73296,35.00207,-2.68795,.72974,34.97776,-2.68735,.92496,34.75015,-2.88829,.92398,34.86375,-2.78353,.93481,34.75534,-2.91099,.95686,34.88469,-2.79643,.91951,34.74562,-2.89404,.39507,34.77353,-3.10732,.51149,34.77954,-3.1577,.52226,34.69681,-3.21481,.66304,34.77741,-3.16658,.687,34.67192,-3.2348,.67913,34.67498,-3.23476,.6702,34.77343,-3.16434,.64538,34.73154,-3.13554,.64701,34.68811,-3.09892,.64828,34.916,-2.84892,.64313,34.93266,-3.01159,.65106,34.98576,-2.92364,.61972,34.87242,-2.93923,.60677,34.85114,-2.97222,.6354,34.87494,-3.09388,.64286,34.93117,-3.01412,.60803,34.79149,-3.0349,.71037,34.64471,-2.982,.60702,34.7043,-2.96305,.681,34.6618,-3.24311};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_16()
		{
			double[] value = {.62895,34.87984,-3.0984,.63672,34.94,-3.01657,.51153,34.68426,-3.22046,.38981,34.75621,-3.10744,.30767,34.76833,-3.09849,.16056,34.74846,-3.16341,.30807,34.78589,-3.09742,.16312,34.73573,-3.17127,.05733,34.69676,-3.29032,.01591,34.70858,-3.3233,.06254,34.71445,-3.28961,.15298,34.74658,-3.16851,.05915,35.15848,-3.31833,.01591,35.20064,-3.37813,.03081,34.85843,-3.27718,.02462,35.01208,-3.30489,.08197,35.41099,-2.55691,.09143,35.37096,-2.63276,.03335,35.39543,-2.66076,.0827,35.34356,-2.77587,.01591,35.35688,-2.91045,.01591,35.37282,-2.79588,.06857,35.26756,-2.95209,.05028,35.29358,-3.06503,.01591,35.36083,-3.02661,.40034,35.31449,-2.26003,.33691,35.36035,-2.24536,.33266,35.25889,-2.39638,.36188,35.23814,-2.38561,.46867,35.40333,-2.11271,.48733,35.44266,-2.04484,.44883,35.43226,-2.12273,.34562,34.98455,-2.56275,.41589,35.08354,-2.46419,.32417,35.03196,-2.61167,.32842,35.14543,-2.50402,.42443,35.46297,-2.14719,.43581,35.4934,-2.07257,.52296,35.3242,-2.0853,.4909,35.29059,-2.01378,.53882,35.36951,-2.00608,.42594,35.50685,-2.08506,.86123,35.46473,-2.58114,.79106,35.49596,-2.58142,.82104,35.5615,-2.62168,.90458,35.32877,-2.50496,.97169,35.31104,-2.55307,1.0,35.22656,-2.63368,.96224,35.36832,-2.53472,.97439,35.44247,-2.49684,1.04743,35.43311,-2.35063,1.04552,35.3181,-2.47915,.97146,35.62795,-2.56779,.92968,35.53557,-2.58833,.9007,35.60701,-2.62969,.89302,35.44296,-2.55755,.79483,35.40953,-2.46371,.85373,35.38667,-2.49653,.76302,35.31558,-2.38362,.59421,35.17729,-2.34806,.72428,35.35303,-2.33977,1.06153,35.5608,-2.45874,1.06408,35.64758,-2.4683,.99191,35.81197,-2.43892,1.02815,35.66151,-2.30047,.93508,36.03043,-2.38785,.9291,36.0301,-2.38705,.91661,36.03775,-2.20676,.92285,36.03707,-2.20442,.92144,35.9414,-2.52433,.89443,35.8141,-2.60881,.91458,35.94095,-2.52414,.88633,35.81463,-2.60604,.50499,35.61283,-1.93445,.43171,35.51087,-2.09145,.50702,35.61943,-1.94291,.86332,35.84058,-2.44385,.86555,35.9051,-2.26569,.88597,35.90783,-2.35313,.845,35.82582,-2.30823,.58887,35.69286,-1.89302,.68731,35.76008,-1.88298,.59363,35.67791,-1.94468,.66095,35.73627,-1.93934,1.62355,35.54794,-2.37223,1.43677,35.45121,-2.52202,1.54518,35.60156,-2.37225,.89423,35.97,-2.07741,.9392,36.01184,-2.19844,.87518,35.98792,-2.08521,.95795,36.00639,-2.38589,.98646,35.87649,-2.35309,.94169,35.92289,-2.52042,.81563,35.26443,-1.79263,.9119,35.35006,-1.87933,.89427,35.3552,-1.88647,1.70848,34.5373,-2.64472,1.74226,34.64466,-2.5845,1.87377,34.59344,-2.5327,1.85079,34.44758,-2.54668};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_17()
		{
			double[] value = {1.98057,34.79834,-2.47399,1.97058,34.70556,-2.47581,1.95984,34.71457,-2.49283,1.99383,34.79155,-2.46111,1.93462,34.52459,-2.46426,1.92442,34.54587,-2.47918,2.12158,34.76852,-2.15042,2.09671,34.73237,-2.18932,2.10843,34.81038,-2.20511,2.06413,34.5616,-2.14983,2.08135,34.58471,-2.07321,2.13871,34.91197,-2.17294,2.13906,34.9334,-2.16592,2.13935,34.92972,-2.15947,2.02563,35.07357,-2.37876,2.06134,35.10525,-2.23147,2.07476,35.08787,-2.23173,1.77525,33.61842,-2.24532,1.78873,33.61643,-2.25214,1.79373,33.61835,-2.24235,1.82446,33.65083,-2.31285,1.77267,33.56797,-2.37057,1.781,33.5966,-2.40772,1.20065,35.12322,-2.62845,1.08473,35.05851,-2.70431,1.11156,35.22035,-2.55249,1.17405,35.26676,-2.50357,1.34956,35.31257,-2.52917,1.23982,35.21913,-2.56343,1.27003,35.38598,-2.49153,1.82913,35.22361,-2.00734,1.69138,35.37225,-2.02335,1.6579,35.3429,-1.96707,1.17114,35.25628,-1.74712,1.25243,35.34099,-1.80409,1.15989,35.37979,-1.81014,1.33204,35.42773,-1.85856,1.4219,35.50183,-1.91028,1.32335,35.55181,-1.90007,1.74455,35.59892,-2.17559,1.74359,35.58443,-2.24268,1.74805,35.70506,-2.21168,1.63062,35.80105,-2.20017,1.55674,35.77541,-2.23404,1.58274,35.80673,-2.14374,1.51871,35.44113,-1.92605,1.51678,35.32375,-1.88881,1.4579,35.53471,-1.9288,1.10389,35.45932,-1.89645,1.02196,35.38649,-1.82669,.88186,35.25221,-1.71014,.79574,35.3092,-1.70638,.86065,35.2633,-1.63877,1.49066,35.11053,-1.86092,1.47121,34.96452,-1.81811,1.55006,34.94886,-1.84449,.63864,35.06927,-1.40986,.72984,35.21046,-1.53261,.6299,35.17744,-1.54628,.89874,35.00423,-1.37922,.93884,35.08433,-1.46223,.92838,35.09015,-1.45506,.90844,34.99894,-1.38952,.92795,34.98298,-1.47892,.94753,34.9776,-1.5119,.96445,35.07586,-1.54405,.84211,34.9183,-1.30338,.85105,34.91354,-1.31681,1.04502,35.2828,-1.734,.96335,35.19045,-1.59526,.52484,35.19923,-1.63355,.62147,35.25848,-1.62671,.70979,34.69827,-2.31655,.66894,34.74717,-2.43679,.72257,34.84366,-2.50602,.68165,34.83297,-2.52179,.65304,34.48695,-2.18122,.63302,34.57064,-2.35207,.66022,34.64536,-2.3661,.60103,34.55219,-2.6823,.62479,34.60564,-2.79405,.60522,34.6188,-2.77077,.63706,34.49638,-2.63136,.40821,34.75546,-2.7716,.40987,34.75471,-2.72544,.5093,34.69733,-2.76246,.50848,34.66701,-2.70147,.40701,34.7737,-2.81821,.32506,34.80162,-2.82461,.41412,34.77765,-2.67425,.37682,34.85628,-2.66738,.53134,34.88091,-2.61951,.40838,34.98046,-2.68912,.53109,34.82899,-2.55866,.37977,34.95624,-2.76041,.39116,34.96813,-2.73972,.38939,34.82962,-2.85375,.26468,34.88132,-2.85545,.27865,34.85303,-2.85359,.37738,34.84641,-2.85711};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_18()
		{
			double[] value = {.37537,34.89092,-2.83457,.25521,34.9441,-2.82804,.25022,34.90345,-2.84814,.37653,34.9276,-2.80533,.29174,35.04258,-2.71048,.41827,34.8518,-2.59191,.5116,34.68043,-2.58853,.41506,34.81006,-2.63313,.50957,34.66571,-2.6327,.52135,34.92466,-2.73556,.62913,34.91886,-2.76547,.63848,34.91889,-2.71197,.51584,34.90768,-2.7791,.50987,34.87537,-2.81161,.60272,34.80348,-2.85732,.6122,34.89245,-2.80915,.50252,34.8198,-2.8578,.58215,34.61498,-2.4628,.5744,34.57773,-2.54801,.52071,34.72588,-2.52662,.33943,34.87368,-2.65907,.32444,34.89917,-2.61924,.20127,34.99359,-2.85397,.23142,34.95302,-2.84053,.30337,34.7771,-2.89463,.28778,34.81311,-2.85365,.60307,34.66275,-2.43321,.61057,34.69157,-2.43484,.68924,34.89617,-2.62854,.63937,34.8862,-2.63292,.93832,34.67245,-2.72827,.93957,34.54502,-2.6143,.95827,34.57454,-2.56706,.91642,34.64986,-2.75967,.97118,34.44106,-2.47939,1.00452,34.47179,-2.42923,.59836,34.49815,-2.57523,.60268,34.50901,-2.46563,.59363,34.39509,-2.35365,.72894,34.45819,-2.0128,.65617,34.40658,-2.12632,.71274,34.50813,-2.06384,.91119,34.40596,-2.51657,1.03728,34.30639,-2.44806,.95832,34.2661,-2.4729,.79332,35.11835,-2.56625,.79626,35.01025,-2.66001,.71405,35.10534,-2.62826,.63478,35.09233,-2.69027,.61512,34.76457,-2.92909,1.50348,34.16863,-2.91817,1.42226,34.17875,-2.94626,1.44475,34.26216,-2.89156,1.17014,34.28562,-3.12398,1.20587,34.36618,-3.05284,1.25222,34.29118,-3.01846,1.25501,34.22393,-3.06378,.82273,34.5894,-2.79913,.84959,34.59679,-2.79552,.82288,34.68217,-2.94599,.2983,35.08785,-2.64476,.28592,35.15978,-2.59416,.35708,34.95921,-2.53661,.09662,35.11885,-2.81472,.01591,35.05601,-2.95385,.09434,35.01935,-2.89634,.01591,35.13722,-2.86255,.2673,35.25201,-2.48636,.2568,35.3403,-2.34232,.43537,35.16842,-2.34476,.44107,35.0715,-2.26826,.39907,35.00898,-2.39608,.34057,34.58759,-2.96698,.30201,34.62005,-3.03509,.30201,34.45352,-3.15707,.31697,34.42098,-3.08923,.33813,35.39285,-2.21453,.0781,35.40696,-2.55273,.15276,35.35219,-2.49985,.15875,35.37881,-2.49519,.08231,35.3649,-2.55909,.33193,34.38844,-3.02138,.33413,34.55514,-2.89886,.12026,34.87505,-2.53454,.01591,34.88514,-2.40206,.13548,34.94461,-2.40827,.53417,35.57147,-1.93271,.62301,35.47343,-1.97274,.76685,35.0587,-1.36984,.74767,35.00614,-1.32532,1.76185,33.56742,-2.36227,1.62214,33.567,-2.54868,1.73766,33.51448,-2.50504,1.67147,33.64183,-2.37911,.78602,35.11125,-1.41436,.90478,35.218,-1.56,.9168,35.21663,-1.56838,.82986,34.8806,-1.28886,.89146,34.89011,-1.41379,.78515,34.78155,-1.34958};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_19()
		{
			double[] value = {1.33835,35.29337,-1.82251,1.35014,34.92148,-1.76122,1.34381,34.98767,-1.77529,1.18148,34.96935,-1.68993,.62769,34.38322,-2.47066,.59897,34.43185,-2.25896,.80481,34.56756,-2.05513,.69702,34.55288,-2.12708,.77402,34.61997,-2.11316,.97346,34.50689,-1.96572,.81416,34.49467,-1.94917,.92033,34.55591,-2.06973,.86673,34.61014,-2.16156,1.09037,34.33209,-2.33814,1.00955,34.50524,-2.33578,1.11313,34.41673,-2.25026,.72197,34.37765,-2.51322,.8306,34.3838,-2.52741,.88105,34.25069,-2.47916,1.22286,34.33982,-2.0476,1.09545,34.44874,-2.02812,1.19497,34.34632,-2.18381,1.03786,34.5172,-1.81217,.91253,34.56078,-1.7434,.69117,34.43579,-1.96955,.73857,34.50111,-1.85482,.57284,34.25777,-2.2243,.5687,34.28304,-2.16368,1.42531,34.258,-1.94191,1.53018,34.04631,-2.09578,1.58192,34.12848,-1.9656,1.33105,34.24959,-2.07639,1.04586,34.13749,-2.45788,1.09985,34.00002,-2.4995,1.26404,34.00226,-2.41645,1.46889,33.65248,-2.57211,1.46035,33.8142,-2.39863,.88654,34.00266,-2.53697,.88368,34.12114,-2.48379,.70986,34.15218,-2.42774,.65979,34.05576,-2.50076,.73222,34.66472,-1.46263,.84986,34.75833,-1.44949,.47752,33.94076,-2.6189,.48161,34.14055,-2.37263,.40052,34.472,-1.63165,.67654,34.60779,-1.5305,.42909,34.54395,-1.3746,.48333,34.20051,-2.22948,.34947,34.17311,-2.2345,.3579,34.0866,-2.38044,.38252,34.17693,-2.10185,.37408,34.26211,-2.01417,.17122,34.23247,-1.98856,.18341,34.15519,-2.09859,1.09857,34.60818,-3.18935,1.02297,34.49927,-3.35349,.80181,34.59607,-3.1895,.32143,35.25261,-1.9997,.51175,35.35577,-1.93088,.33558,35.33128,-1.92533,.66364,35.39133,-1.96023,.72191,35.40067,-1.92822,.72874,35.5052,-1.93446,1.366,35.51821,-2.47123,1.68433,35.6339,-2.3036,1.73278,35.48941,-2.1383,1.56102,35.60932,-1.97773,1.64094,35.51855,-2.01044,1.64785,35.64044,-2.0421,.91007,35.79097,-2.5881,.94985,35.88768,-2.19913,1.03426,35.5144,-2.07272,1.00856,35.68892,-2.18173,.98314,35.64564,-2.10689,1.05316,35.52485,-2.17695,.9983,35.75673,-2.48756,1.05436,35.46907,-2.29784,1.16549,35.5045,-2.13153,1.12259,35.5245,-2.03064,1.22554,35.56746,-2.00004,1.18991,35.44971,-2.40651,1.30782,35.61735,-2.28272,1.32183,35.5901,-2.3582,1.17484,35.51028,-2.30836,1.74866,35.49831,-2.24326,1.64038,35.68305,-2.32685,1.69511,35.51349,-2.30056,1.54167,35.41224,-2.41945,1.63956,35.40847,-2.3014,2.14863,34.82972,-2.10949,2.13227,34.66076,-2.01679,2.08829,35.09179,-2.13914,2.13844,34.93329,-2.20688,1.59511,35.33636,-2.28143,1.32214,35.14335,-2.49491,1.40875,35.26167,-2.46739,1.50316,35.21528,-2.3392,1.71624,35.36666,-2.19819,1.60216,35.27548,-2.26298};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_20()
		{
			double[] value = {1.46568,35.66989,-2.33226,1.57993,35.73689,-2.30366,1.41711,35.68984,-2.24191,1.39263,35.71844,-2.15091,1.4409,35.7377,-2.07674,.83417,35.42545,-1.90459,.77344,35.57767,-1.91026,.75598,35.31898,-1.84101,.75288,35.62712,-2.24574,.64911,35.66964,-2.02241,.7926,35.78199,-2.17597,.6074,35.58168,-2.07886,.76871,35.85286,-1.9545,.80173,35.28024,-2.42821,.87428,35.30671,-2.49617,.83099,35.68784,-2.62006,.84213,35.75952,-2.47758,.81406,35.64699,-2.5143,.83932,35.68488,-2.6265,.59279,35.49257,-2.16733,.68243,35.438,-2.37115,.61773,35.36583,-2.25654,.70495,35.51587,-2.32724,.51986,35.60457,-1.9817,.4328,35.46338,-2.15548,.43699,35.46933,-2.15148,1.10829,35.3144,-2.44371,1.07055,35.25579,-2.52277,.92481,35.42119,-2.53397,.88992,35.15408,-2.58894,.62044,35.14402,-2.52257,.51654,35.17285,-2.60007,.47882,35.23373,-2.42307,.47633,35.13769,-2.72649,.59686,35.12284,-2.74505,.59071,35.12327,-2.75987,.64802,35.06137,-2.81233,.5637,35.09111,-2.86958,.44022,35.07282,-2.83376,.44731,34.51784,-3.31221,.28379,34.48342,-3.32328,.70793,34.65191,-3.23754,.70635,34.48073,-3.36986,.58295,34.48075,-3.35882,.5146,34.97741,-3.00093,.64436,34.99427,-2.92822,.08411,34.69089,-3.27178,.20103,34.47957,-3.33468,.36545,35.10074,-2.83562,.41544,34.94457,-2.98679,.31871,34.98369,-2.95853,.31834,35.30574,-2.44459,.25839,35.37794,-2.33774,.34261,35.40067,-2.23308,.42895,35.35438,-2.31558,.34775,35.22104,-2.52864,.19498,35.32732,-2.58283,.08528,35.22633,-3.10345,.04675,35.33085,-3.23046,.14805,35.3143,-2.75587,.11773,35.17825,-2.99373,.18175,34.8611,-3.07023,.201,35.00414,-3.00388,.30703,34.86572,-3.04911,.08448,34.70802,-3.26924,.03274,34.82945,-3.16671,.1019,35.01446,-3.10963,.01591,35.3839,-2.77908,.51358,35.28628,-1.71509,.62752,35.37357,-1.80305,.47049,35.39948,-1.82528,.42677,35.28514,-1.74666,.35331,35.19015,-1.65911,.18019,35.23591,-1.72093,.33516,35.26839,-1.72086,.1855,35.15479,-1.63737,.84932,35.26442,-1.63033,1.05052,35.21287,-1.67602,.86035,34.48289,-3.37971,1.11872,34.58411,-3.19243,.9206,34.66491,-3.07118,1.20845,34.94185,-2.88154,1.1995,34.98604,-2.79117,1.27274,34.99162,-2.76645,1.34061,34.90174,-2.87799,1.54934,35.10007,-2.38403,1.78747,35.21682,-2.32152,1.45132,35.03774,-2.47433,1.34629,35.01287,-2.58031,1.39722,34.96196,-2.69499,1.29964,35.00634,-2.65402,1.82146,34.98057,-2.45502,1.64593,35.03777,-2.41018,1.8913,35.14011,-2.33376,1.81146,34.81295,-2.53244,1.90351,34.35475,-2.51133,1.99128,34.42818,-2.28866,2.00215,34.64632,-2.37125,2.01756,34.57308,-2.24862,1.95328,34.46451,-2.40109};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_21()
		{
			double[] value = {1.92753,33.84422,-2.1973,1.88636,33.96349,-2.30051,1.94395,34.04318,-2.2314,1.9466,33.92065,-2.08542,1.93364,33.72588,-2.12641,1.96018,33.84835,-2.01076,1.91104,33.88927,-1.88149,1.85592,33.76695,-2.02141,1.86307,33.66668,-2.24386,1.81899,33.68645,-2.16278,1.79155,33.63286,-2.45478,1.82115,33.73013,-2.35703,1.90188,34.34281,-2.51295,1.82537,34.40824,-2.55396,1.85078,34.34955,-2.55014,1.78316,34.01867,-2.84684,1.7341,34.13198,-2.7526,1.78073,34.09104,-2.72648,1.71639,34.05347,-2.83833,1.15121,34.35461,-3.21959,1.06774,34.39874,-3.25925,1.1508,34.4772,-3.12425,1.34927,34.30687,-2.92388,1.41733,34.43406,-2.85491,1.50541,34.35207,-2.84447,1.64526,34.24232,-2.75325,1.82077,34.22918,-2.62658,1.60974,34.40537,-2.72787,.25191,31.20666,-3.60959,.25372,31.20422,-3.59303,.36671,31.34133,-3.38001,.42911,31.27608,-3.50632,.45641,31.36492,-3.4178,.33712,31.26499,-3.49743,.31074,31.43273,-3.94036,.15565,31.29379,-3.46526,.10552,31.21853,-3.62703,.30039,31.92109,-3.93804,.31615,31.83297,-3.93494,.32384,31.81735,-3.83888,.27472,31.9471,-3.89775,.21019,31.94324,-3.89315,.21414,31.7866,-3.85488,.17247,32.08379,-4.03078,.20018,32.06442,-4.02837,.1949,32.05833,-4.01942,.16564,32.08888,-4.01533,.15997,32.29254,-3.9638,.11483,32.1241,-4.03579,.34765,31.29554,-3.85757,.22341,31.6716,-4.0606,.22837,31.6685,-4.07265,.23205,31.65807,-4.06644,.3494,32.04696,-4.09192,.2716,32.25769,-4.08344,.28328,32.2687,-4.08506,.49474,32.20764,-4.03789,.49138,32.224,-4.03939,.43204,31.9883,-4.04031,.17024,32.19774,-4.05856,.26548,32.27398,-4.09688,.16295,32.20709,-4.07701,.02048,32.20442,-4.06198,.03208,32.21046,-4.08299,.09742,32.20255,-4.06869,.09612,32.1922,-4.04986,.10773,32.29007,-4.18478,.07962,32.40507,-4.26293,.1927,32.28203,-4.16871,.23333,32.38699,-4.18167,.33271,31.55864,-4.05189,.27692,31.67459,-4.11073,.37463,31.62685,-4.06981,.47137,31.55706,-3.93245,.49348,31.70549,-3.93226,.48076,31.55824,-3.92241,.46814,31.57882,-3.79058,.43831,31.5308,-3.7153,.81171,31.57995,-3.58501,.90743,31.63557,-3.42113,.72571,31.61686,-3.50465,.51822,31.34754,-3.51024,.50759,31.32785,-3.51661,.51889,31.33986,-3.53097,.36486,31.35744,-3.37353,.19742,31.33954,-3.32425,.19413,31.32681,-3.33142,1.078,31.68037,-3.41182,.90543,31.6569,-3.40577,1.07626,31.69187,-3.39552,1.0998,31.96984,-3.4111,1.09726,32.11867,-3.47446,1.04523,31.98226,-3.43621,1.24243,31.71739,-3.42813,1.24097,31.72625,-3.40981,.65742,31.57537,-3.52833,.59712,31.5672,-3.53261,.59932,31.56715,-3.54797,.64851,31.5908,-3.51247,.52569,31.79709,-3.49521};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_22()
		{
			double[] value = {.75197,31.69113,-3.46965,.84354,31.88173,-3.48183,.63446,31.9298,-3.523,.97286,31.81843,-3.40236,.92905,31.73032,-3.41492,.80746,32.06397,-3.86561,.96003,32.22574,-3.92226,.97567,32.20633,-3.92161,.98657,32.21415,-3.92262,.62606,32.37792,-3.63493,.56296,32.36751,-3.73588,.64887,32.37127,-3.85843,.17467,32.26762,-3.93857,.1808,32.3021,-3.95802,.18118,32.28032,-3.94039,.19165,32.27766,-3.88345,.19496,32.33394,-3.8615,.20874,32.34653,-3.86729,.20286,32.27672,-3.88617,.21256,32.41598,-3.89349,.20064,32.43587,-3.88258,.17975,32.45604,-3.93046,.19437,32.43361,-3.92273,.19924,32.40471,-3.86801,.44661,32.16145,-3.82196,.45607,32.14772,-3.74739,.4713,32.13181,-3.74824,.46522,32.15475,-3.82692,.52202,32.34537,-3.89498,.50873,32.3507,-3.88906,.45331,32.22654,-3.87207,.46769,32.22115,-3.87559,.53213,32.36256,-3.73255,.51833,32.38069,-3.81422,.54753,32.37696,-3.8214,.48798,32.1671,-3.66907,.47962,32.196,-3.67368,.49361,32.18722,-3.65162,.29797,32.41654,-3.8902,.31394,32.39617,-3.84106,.29024,32.2536,-3.81637,.31667,32.33631,-3.80927,.4039,32.3625,-3.91098,.41571,32.39715,-3.85323,.28448,32.37595,-3.93596,.26271,32.31061,-3.93414,.17965,32.38776,-3.95788,.17477,32.3537,-3.96305,.26438,32.25234,-3.91177,.27362,32.23484,-3.87457,.43777,32.32485,-3.74417,.39109,32.21965,-3.74142,.43072,32.38082,-3.78753,.22011,32.05651,-3.99114,.21107,32.59281,-3.85444,.47151,32.08971,-3.67989,.53897,32.35182,-3.88257,.48033,32.37726,-4.0256,.44336,32.21696,-3.90035,.49614,32.2221,-4.03078,.47086,32.37997,-4.03562,.49174,32.55359,-3.99046,.53018,31.96785,-3.94369,.49737,32.21875,-4.02878,.51754,31.97058,-3.95212,.51506,32.0747,-3.70018,.50897,32.12026,-3.86902,.48199,32.16989,-3.8779,.45501,32.21952,-3.88678,.65974,32.13408,-3.85958,.60481,32.10574,-3.8647,.61295,32.07892,-3.70402,.68606,32.13851,-3.71961,.784,32.31338,-3.6782,.74551,32.25415,-3.82972,.75077,32.23198,-3.7276,.73137,32.34918,-3.84992,.77095,32.39031,-3.68902,.69742,32.39728,-3.66749,.56865,32.32278,-3.67264,.71817,32.03124,-3.57315,.49048,32.04193,-3.58982,.64388,31.94067,-3.52712,.8862,32.40873,-3.60844,.81212,32.48953,-3.56743,.80033,32.47881,-3.5772,.68264,32.44022,-3.54137,.67973,32.44758,-3.52915,.48926,32.11874,-3.54966,.47986,32.04367,-3.57211,.4912,32.12448,-3.56151,.47934,32.01796,-3.51802,.45842,32.024,-3.51123,.45206,32.00506,-3.5133,.48773,32.13488,-3.54993,.37622,33.17957,-3.66817,.26379,33.16691,-3.68837,.26978,33.22338,-3.70153,.23203,33.06023,-3.7246,.23342,33.11254,-3.70758};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_23()
		{
			double[] value = {.247,33.03525,-3.72893,.25247,33.11412,-3.71061,.10177,33.18531,-3.85147,.08699,33.21063,-3.84683,.07372,33.18692,-3.86068,.49509,33.16145,-3.61535,.35178,33.10185,-3.64945,.4638,33.08801,-3.58047,.21272,33.09259,-3.69758,.68963,33.15893,-3.83658,.62633,33.15371,-3.76551,.60168,33.11204,-3.83031,.6314,33.15333,-3.5481,.65794,33.17377,-3.69163,.71683,33.18513,-3.56121,1.29716,31.79858,-3.62922,1.28757,31.73085,-3.52989,1.26437,31.71872,-3.53648,1.31172,31.8053,-3.61387,1.45262,32.78272,-3.49194,1.45269,32.80636,-3.46766,1.42927,32.77967,-3.47972,1.26057,32.75497,-3.50032,1.0625,32.68985,-3.53106,1.07365,32.6775,-3.52815,.49117,32.78535,-3.38291,.49433,32.77309,-3.39318,.57079,32.7937,-3.41974,.56489,32.80655,-3.41333,.87002,32.65455,-3.52571,.87646,32.64453,-3.51928,.88804,32.66064,-3.52416,.5522,32.87547,-3.37738,.55344,32.86114,-3.38251,.55822,32.87206,-3.38888,.64062,33.1233,-3.27251,.63513,33.1181,-3.27295,.64074,33.11576,-3.28286,.65151,33.12002,-3.28218,.8131,32.92334,-3.87995,.81905,32.91663,-3.88758,.70836,32.8183,-3.89355,.69576,32.82075,-3.88768,.68822,33.16521,-3.84321,.80752,33.0953,-3.87787,.80797,33.08675,-3.872,.56123,32.87145,-3.909,.5105,32.74935,-3.95732,.5524,32.88514,-3.91226,.50189,32.76093,-3.9646,.1279,33.03894,-4.04035,.05882,33.01192,-4.07367,.12761,33.05202,-4.05017,.05123,32.99491,-4.07046,.83967,32.97976,-3.8769,.84859,32.98253,-3.88606,.5367,33.03237,-3.87634,.53297,33.03047,-3.90765,.53273,33.05135,-3.89281,.43607,32.69413,-4.01832,.43637,32.70924,-4.0215,.44583,32.69915,-4.01322,.21689,32.91116,-4.01197,.23222,32.91275,-4.01539,.22956,32.89061,-4.01579,.02957,32.18267,-4.04476,.07369,32.69915,-4.15414,.12829,32.70341,-4.12796,.13718,32.66308,-4.20897,.21234,33.03617,-4.0115,.0944,32.91696,-4.02799,.2134,32.79212,-4.05618,.26636,32.76058,-4.05502,.21101,32.68954,-4.12813,.30782,32.60996,-4.09513,.60557,32.66407,-3.94459,.5588,32.55589,-3.93951,.50806,32.68626,-3.98945,.47077,32.99962,-3.9681,.01591,33.04542,-4.18722,.02918,33.11637,-4.22041,.01591,33.12343,-4.23258,.14583,33.08108,-4.05279,.1264,33.08761,-4.10767,.11629,33.17431,-4.17398,.10227,33.10284,-4.17372,.01591,33.20584,-4.21922,.05915,32.34889,-3.84339,.12311,32.07702,-3.88904,.0503,32.09001,-3.88041,.13958,32.32027,-3.8403,.15267,32.39372,-3.96846,.22254,32.83956,-3.80579,.23296,33.00447,-3.74912,.23138,32.94801,-3.78674,.16502,32.82879,-3.73841,.08325,33.0427,-3.7016,.1665,33.05003,-3.69409,.07685,32.86186,-3.75201,.01591,32.67842,-4.0008};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_24()
		{
			double[] value = {.0732,32.89591,-3.92645,.01591,32.91672,-3.96904,.08181,32.65756,-3.9729,1.3718,32.65194,-3.74238,1.38097,32.78854,-3.7806,1.39194,32.79014,-3.763,1.29539,32.44539,-3.83579,1.30378,32.44588,-3.81778,1.31625,32.22395,-3.79776,1.31016,32.24801,-3.81932,1.31014,32.21574,-3.81274,1.66059,33.45677,-3.56659,1.65302,33.45797,-3.57426,1.64164,33.57556,-3.52086,1.64733,33.56818,-3.51431,1.71084,33.18321,-3.47115,1.67676,33.32945,-3.55586,1.71441,33.19174,-3.46034,1.66955,33.32407,-3.5652,1.70449,33.12222,-3.25808,1.71699,33.13032,-3.26046,1.75226,33.24692,-3.08115,1.73822,33.24376,-3.07744,1.7491,33.36295,-2.83894,1.74956,33.29163,-2.97203,1.76239,33.36524,-2.84013,1.76403,33.29078,-2.97362,1.72722,33.11191,-3.32963,1.71953,33.09805,-3.332,1.67931,33.36596,-3.47653,1.62619,33.56041,-3.45336,1.64303,33.41999,-3.40671,1.62752,33.53579,-3.38231,1.6889,33.59501,-2.97205,1.73237,33.51192,-2.89802,.54427,33.72955,-3.45896,.53535,33.69285,-3.35392,.55938,33.71061,-3.46536,.5518,33.67486,-3.34237,.54323,33.8953,-3.55824,.53534,33.89474,-3.54982,.53134,33.81899,-3.55762,.54051,33.82007,-3.5788,.54854,33.66937,-3.30777,.62137,33.97671,-3.45096,.60693,33.97777,-3.45829,.61557,33.97834,-3.47047,.22439,34.06613,-3.46453,.19232,34.01922,-3.5102,.21424,34.00979,-3.51014,.2378,34.03607,-3.47242,.1772,33.94898,-3.54012,.20985,33.86907,-3.55533,.20039,33.94527,-3.53804,.18805,33.86786,-3.56279,.22284,33.7931,-3.55418,.27842,33.75116,-3.51596,.24068,33.8002,-3.54809,.27191,33.74542,-3.52234,.26633,33.76605,-3.44438,.2766,33.86735,-3.37528,.27441,33.76882,-3.44661,.28214,33.87286,-3.38537,.33456,33.77531,-3.51958,.30886,33.84972,-3.54501,.49192,33.97014,-3.34277,.59596,33.95316,-3.3173,.54791,33.88381,-3.17951,.46737,33.8989,-3.24401,.37408,33.91638,-3.31871,.35618,33.85495,-3.31912,.30096,33.9609,-3.36426,.38632,33.98677,-3.37475,.28725,34.03249,-3.42398,.35902,34.01308,-3.46233,.46078,33.96999,-3.51314,.56841,33.9596,-3.51566,.42305,33.90932,-3.53314,.44326,33.7523,-3.48944,.42374,33.83266,-3.5451,.81602,33.88598,-3.24371,.81831,33.91151,-3.22102,.79695,33.94742,-3.36314,.80886,33.92232,-3.39779,.69219,33.97791,-3.35155,.7756,33.98334,-3.50526,.68663,33.99756,-3.51271,.6592,33.60624,-3.32511,.55987,33.57556,-3.14495,.69183,33.5406,-3.16936,.57008,33.61678,-3.31369,.78642,33.6985,-3.35139,.77026,33.57203,-3.2288,.83264,33.61807,-3.21919,.74322,33.64033,-3.35785,.58132,33.90564,-3.04303,.55653,33.88586,-3.16729,.60149,33.94846,-3.29476,.99264,33.39335,-3.15215,.77971,33.41538,-3.14553};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_25()
		{
			double[] value = {.78032,33.40046,-3.15281,.52072,33.66071,-2.97096,.53321,33.67352,-2.97342,.528,33.67092,-2.96107,.60993,33.48585,-3.06107,.76772,33.40685,-3.14923,.61478,33.49746,-3.05819,.60563,33.48741,-3.05739,.60162,33.49133,-3.05577,.10136,34.00283,-3.29367,.01591,34.0524,-3.23685,.10209,34.16336,-3.1671,.53715,33.71319,-2.92716,.61699,33.77727,-2.81137,.5299,33.70698,-2.92018,.61022,33.77469,-2.80171,.45492,33.67017,-2.94774,.45539,33.65633,-2.95504,.44395,33.49023,-3.04931,.44267,33.47895,-3.0614,.4596,33.48685,-3.05565,.6221,33.52656,-3.0775,.77937,33.45578,-3.12393,.54016,33.84025,-3.64601,.54337,33.84246,-3.63471,.59255,33.69559,-3.66666,.59052,33.69921,-3.65118,.60093,33.70021,-3.65074,.60261,33.6979,-3.66277,.62157,33.99107,-3.5453,.54823,33.90938,-3.62641,.62267,34.00197,-3.55009,.54067,33.91379,-3.63551,.20254,33.5727,-3.79166,.22042,33.57864,-3.79047,.21019,33.56182,-3.78889,.01591,33.96907,-3.81092,.06324,33.94564,-3.72903,.06122,33.92969,-3.73199,.32544,33.47962,-3.78356,.33707,33.49446,-3.79034,.1675,33.85795,-3.70577,.17431,33.86922,-3.69853,.33458,33.47787,-3.78031,.07379,34.02877,-3.71361,.17655,34.0202,-3.63572,.0737,33.51058,-4.13104,.08994,33.53164,-4.04555,.01591,33.50266,-4.15687,.49646,33.90062,-3.64555,.46009,33.68785,-3.7643,.74248,33.55811,-3.77935,.84138,33.70096,-3.74397,.86886,33.58088,-3.77299,.72684,33.68007,-3.73206,.0296,34.04969,-3.81237,.04948,34.11377,-3.81532,.08044,34.08124,-3.70387,.01591,34.36886,-3.93785,.04873,34.16199,-3.92298,.06781,34.37088,-3.89792,.01591,34.5126,-3.86592,.06376,34.51931,-3.82129,.64619,32.81455,-3.91506,.65226,32.80081,-3.70833,.6031,32.83532,-3.70475,.75836,33.19451,-3.62067,.84435,33.86006,-3.08671,.24038,33.26726,-3.63752,.22285,33.45356,-3.52333,.25836,33.4718,-3.5608,.1924,33.23046,-3.61564,.10267,33.20571,-3.64119,.09049,33.43059,-3.5523,.13104,33.44027,-3.5403,.0824,33.19967,-3.64285,.24905,33.65794,-3.44386,.25983,33.68026,-3.49073,.27657,33.86058,-3.36044,.29442,33.98407,-3.35522,.29682,34.06646,-3.28125,.29355,34.08831,-3.33414,.20127,34.32142,-3.3375,.28302,34.27993,-3.26926,.20127,34.48947,-3.21662,.09216,33.76148,-3.66778,.18992,33.7362,-3.60285,.09414,33.96419,-3.57263,.67723,31.54972,-3.6098,.47133,31.62177,-3.64713,1.12967,32.58877,-3.53523,1.23304,32.41982,-3.50534,1.2333,32.61555,-3.5322,1.3257,32.62319,-3.51931,1.13744,32.42492,-3.53282,.71634,31.63623,-3.48984,1.22212,32.251,-3.48566,1.13679,32.24126,-3.49346,1.23759,32.11536,-3.41742,1.47615,33.00907,-3.39375};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_26()
		{
			double[] value = {1.46653,32.90028,-3.42963,1.52876,32.8955,-3.4574,1.59566,32.98681,-3.39611,1.7488,33.43602,-2.70264,1.60833,33.49107,-2.6861,1.64964,33.32271,-2.96418,1.64212,33.21425,-3.07336,1.02681,33.79215,-2.83471,1.0009,33.79991,-2.81533,.86474,33.82116,-2.79046,.85972,33.8669,-2.92371,.72591,33.83231,-2.78157,.70331,33.93859,-3.02921,.5331,33.63374,-3.0098,.529,33.63603,-3.00561,.53031,33.62462,-3.0137,.55587,33.5752,-3.04816,.5439,33.57501,-3.03505,.58827,33.39975,-3.1402,.59141,33.07262,-3.49769,.94874,33.07432,-3.5876,.81838,33.0921,-3.66172,.93994,32.96048,-3.63571,.83628,32.96608,-3.66957,.80718,33.18338,-3.40842,.92695,33.16739,-3.518,.98938,33.17706,-3.2913,.80381,33.17736,-3.28214,.89997,32.83028,-3.65039,.78689,32.69115,-3.60791,.99993,32.74018,-3.56278,.67371,32.70063,-3.47921,.68971,32.79498,-3.71341,.5723,32.80526,-3.42659,.57117,32.87755,-3.6497,.55593,32.95542,-3.49969,.57009,32.98234,-3.33217,1.04591,33.81004,-2.68762,1.22318,33.72649,-2.72173,1.11442,33.7067,-2.93958,1.28988,33.60634,-2.86453,1.42304,33.43812,-2.96866,1.39481,33.27193,-3.11371,1.51348,33.26959,-3.08269,1.20063,33.41794,-3.08469,1.01398,33.29295,-3.18434,.80282,33.18347,-3.27063,.59574,33.31432,-3.21362,.78734,33.31054,-3.19179,1.25571,33.15619,-3.31577,1.15763,33.14508,-3.39822,1.30752,33.11957,-3.36301,.88314,32.56284,-3.51194,1.02177,32.4939,-3.56158,.68385,33.87627,-2.69518,.69255,33.9511,-2.60882,.47376,33.71259,-2.87527,.51758,33.61995,-3.00872,.45254,33.58508,-3.00209,.53318,33.56728,-3.03073,.44923,33.166,-3.22793,.56643,32.98499,-3.32219,.47153,32.86869,-3.33923,.5625,32.97182,-3.32574,.44951,32.972,-3.30645,.70938,32.53508,-3.49712,.76243,32.64463,-3.49104,.49287,33.82851,-2.7247,.31945,33.9182,-2.6276,.32017,33.80658,-2.77115,.32745,33.63028,-2.94106,.32931,33.71083,-2.86952,.33734,33.54588,-2.99786,.3123,33.45875,-3.06617,.30265,33.27778,-3.18158,.43729,33.36833,-3.12234,.29944,33.37352,-3.1265,.44162,33.2911,-3.19247,.48567,31.63099,-3.48732,.45627,31.80376,-3.4878,.34229,31.82308,-3.5034,.35143,31.66147,-3.47969,.34779,31.50919,-3.43912,.18762,31.63491,-3.46998,.19526,31.48776,-3.39647,.1426,32.8003,-3.28929,.1593,32.92401,-3.26864,.01591,32.90669,-3.22993,.01591,32.79037,-3.28363,.15873,33.20878,-4.10442,.15776,33.18672,-4.00797,.92621,32.38799,-3.89674,.86484,32.26367,-3.89315,1.01093,32.33223,-3.91067,.36889,31.59962,-3.8289,.36618,31.51206,-3.72535,.36203,31.60936,-3.74663,.28021,31.96843,-3.94061,.2254,32.0536,-3.94608,.25419,31.28345,-3.66923};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_27()
		{
			double[] value = {.32106,31.28988,-3.66458,.25592,31.59502,-3.76636,.25838,31.45231,-3.71715,.32917,31.78309,-3.82038,.50602,31.362,-3.60518,.46879,31.47508,-3.6489,.54261,31.47838,-3.55342,.44068,31.59972,-3.67576,.44408,31.5152,-3.67366,.41275,31.51567,-3.96296,.54678,31.66273,-3.75589,.88527,31.64038,-3.65019,1.09235,31.74743,-3.63526,1.03623,31.65911,-3.53746,.96406,31.81353,-3.69328,.66172,31.79686,-3.8598,.69551,31.93075,-3.88356,1.2487,32.31106,-3.88261,1.24356,32.45816,-3.86057,1.17411,32.15223,-3.87761,1.16866,32.30645,-3.90849,1.23894,32.28476,-3.8949,1.14861,32.13719,-3.8763,1.03247,32.3146,-3.92,1.07123,31.91728,-3.73648,1.20887,32.00298,-3.76242,1.21817,31.89973,-3.69728,1.32831,32.07661,-3.79371,.88191,31.99658,-3.82559,1.00039,32.04974,-3.86869,.95132,31.90142,-3.75231,.51364,32.34624,-3.92888,.74493,32.35845,-3.86013,.81374,32.50725,-3.88772,.76037,32.25475,-3.83808,.66677,32.12372,-3.87066,.60683,32.09279,-3.87626,.50224,32.10864,-3.88097,.84442,32.77589,-3.89465,.83093,32.64111,-3.87607,.70699,32.65455,-3.91203,.91237,33.00447,-3.90411,.95855,32.77974,-3.88115,.98512,32.47573,-3.87043,1.07367,32.62895,-3.89134,1.17851,32.46132,-3.8737,1.0959,32.48064,-3.8872,1.18371,32.6388,-3.89554,1.30036,32.89099,-3.94082,1.34124,32.90749,-3.90197,1.35529,32.77578,-3.88827,1.30652,32.76076,-3.9159,1.0267,33.08285,-3.95532,1.11329,33.12324,-3.95396,1.12445,33.02672,-3.97216,1.26003,31.80109,-3.37103,1.30344,31.8767,-3.50676,1.24286,31.87315,-3.34882,1.29404,31.83408,-3.48448,.54267,31.48034,-3.53357,.45085,31.52521,-3.46553,.46036,31.44641,-3.4366,.27564,31.27433,-3.49261,.05475,31.22288,-3.64837,.01591,31.2217,-3.65503,.01591,31.29857,-3.67203,.06241,31.29525,-3.67222,.06678,32.56995,-3.80401,.01591,32.90442,-3.75485,.01591,32.61448,-3.79301,.27696,31.88639,-4.06726,.23297,32.01774,-4.03606,.306,32.05041,-4.07848,.26338,32.13814,-4.04767,.02206,32.54113,-4.26133,.0301,32.38692,-4.26738,.01591,32.5303,-4.26485,.01591,32.3908,-4.2649,.02275,32.29811,-4.20085,.20528,32.62731,-4.18958,.31572,32.38946,-4.09937,.36485,32.94059,-4.02407,.35918,32.73541,-4.03934,.29931,33.03744,-4.00753,.22801,33.04253,-4.01371,.01591,33.21031,-4.22837,.23184,33.33306,-3.90311,.36257,33.16438,-3.9339,.20753,33.17307,-3.98435,.08629,33.68733,-3.85458,.05068,33.84656,-3.74742,.18261,33.69901,-3.77021,1.80032,33.36383,-2.85882,1.79673,33.43897,-2.87822,1.75997,33.45907,-2.75761,1.75662,33.4372,-2.71186,1.70799,33.40711,-3.05352,1.73282,33.30595,-3.12676,1.66549,33.45174,-3.18205,1.6804,33.51008,-3.10311};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_28()
		{
			double[] value = {1.77368,33.35222,-3.04858,1.76848,33.24061,-3.14883,1.77879,33.26068,-3.05889,1.74424,33.15897,-3.30644,1.3767,32.57805,-3.69685,1.29212,32.42585,-3.68358,1.29673,32.42887,-3.71335,1.67597,33.05527,-3.4574,1.6725,33.15059,-3.51963,1.28706,32.25845,-3.70329,1.25185,33.05806,-3.92119,1.37087,32.92642,-3.80146,1.3516,32.91249,-3.88372,1.25547,33.06588,-3.84565,1.11027,33.14381,-3.94407,1.07927,33.2035,-3.88784,1.18105,33.11071,-3.91809,1.17623,33.16678,-3.87825,1.61354,33.27494,-3.57468,1.5431,32.95504,-3.65902,1.55135,33.15963,-3.64098,1.6167,33.09398,-3.58735,1.45437,33.02987,-3.70335,.59903,33.1187,-3.83809,.56969,33.21341,-3.84547,.69618,33.23642,-3.83906,1.73164,33.88557,-2.95367,1.72507,33.91964,-2.80428,1.70862,33.83263,-2.92695,1.77137,33.84747,-3.08487,1.7044,33.95107,-2.96468,1.7696,33.9287,-2.97072,1.70866,33.88988,-3.07048,1.63221,33.56144,-3.23938,1.65191,33.64455,-3.30892,1.63655,33.47937,-3.30696,1.70263,33.69328,-3.35256,1.66835,33.67856,-3.3337,.46795,34.35515,-3.37496,.62091,34.3766,-3.41731,.33539,34.2032,-3.46704,.34825,34.10632,-3.53566,.18798,34.21335,-3.53943,.47006,34.03689,-3.55,.34395,34.00214,-3.60241,.53238,33.3282,-3.83705,.43954,33.16883,-3.87943,.39387,33.2871,-3.8365,.75108,33.3828,-3.8121,.67449,33.36851,-3.80771,1.51144,33.62461,-3.52882,1.53666,33.45553,-3.57454,1.35074,33.48755,-3.62922,1.4089,33.28507,-3.69487,1.26813,33.36085,-3.73559,1.19586,33.23998,-3.82211,1.18793,33.41604,-3.77842,.33998,33.86958,-3.67926,.3295,33.67863,-3.75454,.68205,34.05532,-3.53628,.69053,34.00541,-3.5202,.61018,34.05197,-3.53969,.90488,34.05489,-3.59424,.77751,34.04995,-3.54206,.89383,34.16463,-3.55266,.84675,33.93166,-3.62263,.82388,33.97807,-3.55087,.80648,33.81702,-3.65453,.84955,33.92652,-3.62715,.90068,33.71412,-3.7236,.91127,33.95166,-3.65319,1.0134,33.75507,-3.76951,.99073,33.63277,-3.7863,1.0112,33.96676,-3.72578,1.07846,33.95299,-3.73745,1.17662,33.87656,-3.70677,1.29902,33.70055,-3.65488,1.08072,33.7646,-3.78361,1.33633,33.83375,-3.6491,1.42892,33.68294,-3.58058,.97084,34.08569,-3.6316,1.04575,34.08096,-3.63183,1.17161,34.05352,-3.53907,.90095,34.2536,-3.52312,1.01825,34.24904,-3.51341,1.00454,34.3903,-3.47066,1.12146,34.2219,-3.34179,1.17375,34.21332,-3.18153,1.1749,34.11234,-3.37343,1.21902,34.14705,-3.21666,1.31875,34.19189,-2.98764,1.37192,34.134,-3.01162,1.30416,34.17971,-3.07125,1.46932,34.06665,-3.05,1.50851,34.12323,-2.94687,1.30971,34.04937,-3.24354,1.40962,34.034,-3.15002,1.41367,33.90175,-3.34346,1.32632,33.97881,-3.36648,1.63452,34.11897,-2.85621};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_29()
		{
			double[] value = {1.60916,34.03143,-2.95338,1.52695,33.91952,-3.18973,1.49153,33.88511,-3.26555,1.32814,33.8496,-3.56851,1.48091,33.76538,-3.45077,1.39799,33.76508,-3.54358,1.33846,33.89081,-3.50466,1.0688,33.61963,-3.79032,.77517,33.99222,-3.51408,.74043,34.362,-3.42659,.62322,34.21151,-3.46591,.77452,34.24327,-3.48332,.50704,34.19453,-3.452,.62197,33.65474,-3.70888,.71783,33.72142,-3.65208,.6052,33.66052,-3.72221,.60865,33.54059,-3.78538,.4703,33.48758,-3.80758,.94854,33.43107,-3.81499,.82767,33.3971,-3.81649,1.06082,33.43789,-3.8106,1.22408,33.54354,-3.7117,1.64817,33.7202,-3.33325,.29286,34.34845,-3.38388,.19345,34.34781,-3.44143,1.67129,33.61835,-3.1361,.80593,33.26942,-3.84566,1.17864,33.18582,-3.86339,1.26213,33.07744,-3.82931,1.32143,33.15358,-3.77054,1.38175,32.93307,-3.78382,.93617,33.14528,-3.90236,1.00888,33.09414,-3.94847,1.44888,32.79344,-3.7227,1.70829,33.24383,-3.40227,1.7184,33.22377,-3.2983,1.79235,33.28677,-2.99492,.02974,34.45645,-3.71019,.03796,34.32674,-3.75808,.11328,33.53132,-3.92686,.16021,33.35671,-3.9904,.14107,33.3507,-4.09153,.1076,33.34687,-4.16023,.34229,32.73183,-4.03768,.42468,32.5513,-4.04143,.0966,32.57774,-4.24943,.24129,32.5473,-4.18349,.01591,32.31877,-4.2061,.43169,31.8156,-4.04915,.35773,31.85268,-4.05864,.45918,31.38484,-3.41372,1.29379,31.99694,-3.54863,1.24485,31.93358,-3.3602,1.17337,33.0964,-3.93249,1.20475,33.01054,-3.96759,1.24424,33.04957,-3.93766,1.15544,32.79138,-3.93836,1.06791,32.78263,-3.91874,.98447,32.63051,-3.84677,.7008,32.81324,-3.89432,.6459,32.80727,-3.92442,.68259,32.51927,-3.90144,.65491,32.38256,-3.86941,.78906,31.81067,-3.78398,1.32635,32.03809,-3.78038,1.32378,31.90711,-3.68632,1.31002,31.86737,-3.53357,1.30086,31.98234,-3.57388,.69697,31.63937,-3.68993,1.22012,31.77187,-3.60779,.40361,31.68123,-4.06879,.33418,31.73725,-4.10348,.24318,31.80161,-4.09425,.48843,31.43128,-3.85568,.47361,31.40587,-3.93131,.20244,32.04633,-3.90494,.31133,31.56353,-3.96888,1.68584,33.30735,-3.36435,1.66549,33.39492,-3.28841,.15411,32.56523,-3.41528,.16971,32.44931,-3.43935,.14244,32.78672,-3.29494,.15271,32.71033,-3.35205,.1596,32.93955,-3.26897,.14276,33.10914,-3.21023,.19548,31.38382,-3.34493,.35615,31.40724,-3.38391,.17113,32.20203,-3.46166,.34985,32.22496,-3.50179,.18217,32.3416,-3.46011,.35014,32.35735,-3.47725,.13745,33.515,-2.97666,.13927,33.45349,-3.05313,.34858,31.98565,-3.50585,.43323,32.11258,-3.5107,.59428,32.64653,-3.44882,.66957,32.69168,-3.4715,.44807,32.98715,-3.30573,.54262,33.55452,-3.03468,.51748,33.63338,-2.9993};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_30()
		{
			double[] value = {.44923,33.59684,-2.99313,.90242,32.00952,-3.49352,.9777,33.64629,-3.09162,.96095,33.79565,-3.04524,1.10684,33.57494,-3.04632,1.29981,33.48203,-2.97319,1.43381,33.52214,-2.8276,1.07848,33.47964,-3.10369,1.09134,33.87363,-2.59387,1.28259,33.77169,-2.57547,.87291,33.87518,-2.68239,.86559,33.82225,-2.7769,.97717,33.80858,-2.78689,.85068,33.50609,-3.181,.78686,32.14321,-3.58731,.88633,32.33388,-3.614,.84732,32.2344,-3.59763,.56313,32.31681,-3.6646,.77706,32.85582,-3.70566,.76331,32.65503,-3.49801,1.06706,32.80126,-3.56888,.88442,33.7273,-3.15347,1.38517,33.20247,-3.1877,1.50084,33.12484,-3.28645,1.08469,31.7586,-3.38784,1.24032,31.78689,-3.36076,1.70017,33.70045,-3.35603,1.6905,33.76857,-3.23342,1.72713,33.74491,-3.23346,.20127,34.15338,-3.45838,.8142,33.79209,-3.30253,.579,33.96005,-3.52444,.55472,32.88315,-3.80893,.88923,34.39157,-3.47141,.18163,33.86196,-3.70069,.62572,33.53219,-3.77273,.62054,33.52516,-3.7736,.2005,33.70241,-3.77186,.82104,33.96887,-3.5429,.09774,33.81368,-3.38567,.55219,33.56303,-3.03842,.51236,33.67945,-3.12559,.8438,33.92047,-3.61624,.25821,33.29173,-3.68396,.26441,33.49715,-3.61078,.6289,33.65945,-3.48557,.5803,33.65799,-3.48244,.80066,33.85647,-3.45678,.36323,33.73333,-3.46399,.45434,33.71419,-3.40816,.60976,33.95243,-3.3068,.55904,33.72377,-3.49453,.50956,33.81954,-3.18154,.51377,33.81224,-3.15626,1.70579,33.72255,-3.20295,1.73248,33.80267,-3.06934,1.70019,33.68877,-3.17075,1.7094,33.74758,-3.04841,1.71084,33.11252,-3.2841,1.64291,33.01702,-3.37771,1.01158,32.98151,-3.94758,1.03324,32.97668,-3.9536,.1946,32.32602,-3.85413,.1935,32.63106,-3.91846,.19044,32.87272,-3.87599,.16889,32.42197,-3.9552,.12482,31.29194,-3.6724,.10952,31.22384,-3.64166,.05058,32.89782,-4.07695,.33818,32.59472,-4.08118,.06313,32.79965,-4.08911,.20572,33.05059,-4.02197,.21979,33.05034,-4.01268,.35075,32.72159,-4.03876,.55812,32.88246,-3.89899,.81437,33.08965,-3.88069,1.24693,32.68526,-3.51626,1.70635,33.1197,-3.26236,1.71052,33.1224,-3.26315,1.24069,32.25355,-3.50094,1.251,32.4196,-3.51576,1.33971,32.04818,-3.7707,.60755,33.15024,-3.75421,.53832,33.05294,-3.78149,.548,33.04655,-3.80784,.06969,33.07858,-3.88689,.21697,32.80985,-3.76234,.63627,33.16847,-3.68708,.61215,33.1499,-3.55664,.48375,33.20065,-3.72359,.38477,33.06179,-3.80506,.43212,33.16307,-3.7778,.24717,32.97808,-3.79182,.24795,33.18269,-3.68434,.25714,33.25653,-3.6965,.53867,32.98414,-3.8216,.48983,32.03222,-3.57113,.49721,32.19075,-3.54934,.50375,32.19652,-3.56099,.50233,32.2048,-3.5491};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_31()
		{
			double[] value = {.43851,32.23282,-3.50794,.43428,32.21752,-3.50468,.18157,31.96802,-3.47487,.18254,31.95443,-3.48118,.34981,31.99961,-3.5023,.51941,32.33798,-3.91292,.29312,32.38983,-4.11524,.36342,32.20615,-3.86751,.36551,32.26722,-3.90138,.37177,32.18712,-3.81173,.5457,32.31464,-3.68614,1.02942,32.33895,-3.91064,1.26365,31.73041,-3.42549,.4728,32.1628,-3.89066,.01591,32.23944,-4.10063,.23976,31.81684,-4.08438,.24472,31.81273,-4.09286,.31007,31.56911,-3.95502,.31659,31.56058,-3.96096,.26638,31.98877,-3.9815,.22819,32.01107,-4.02632,.31558,31.71408,-3.95082,.34279,31.57589,-3.89372,.29521,31.91844,-3.98043,.27121,31.88738,-4.05996,.30563,31.82838,-3.97648,.3294,31.73131,-3.91458,1.25309,34.58502,-3.00877,1.47314,34.75458,-2.80831,1.46905,34.55951,-2.84496,1.24368,34.72379,-3.03025,1.50864,34.29243,-2.85611,1.87662,34.1625,-2.62761,1.91317,34.3399,-2.49538,1.93625,34.27931,-2.42025,1.9223,34.21331,-2.54848,1.89356,34.13493,-2.46156,2.0046,33.94855,-1.93755,1.97817,34.03214,-1.82922,1.96287,33.85308,-2.03043,1.94949,34.24993,-2.31983,1.89409,34.05087,-2.36544,1.82126,33.84425,-2.40879,1.76945,33.78479,-2.54119,1.73017,33.92941,-2.62572,1.8185,33.97715,-2.48605,1.99134,34.81224,-2.46514,1.64486,34.70335,-2.67362,1.6084,34.62772,-2.73218,2.09347,34.91093,-2.31885,1.96422,35.17354,-2.20972,1.48112,34.83829,-2.7915,1.46498,34.90759,-2.76286,1.56,34.97083,-2.50525,1.1646,34.79354,-3.006,1.04841,34.91864,-2.8171,1.01074,34.75404,-2.94849,.70529,34.65902,-3.22616,2.09337,34.1912,-1.90705,2.04868,34.30306,-1.83436,.72494,35.34083,-1.77498,.51223,35.14204,-1.56242,.71695,35.33955,-1.76373,.36766,35.37859,-1.81599,.06851,35.06791,-3.20697,.20243,35.12878,-2.88742,.26455,35.20093,-2.70123,.38697,35.16208,-2.68447,.62888,34.8445,-2.90968,.52642,34.68347,-3.22355,.64829,35.05025,-2.84214,.41136,35.19236,-2.53438,.86571,34.9947,-2.68234,1.06269,35.31075,-2.46854,1.08004,35.41342,-2.34375,1.24991,35.07867,-2.63607,.5188,35.22262,-2.29162,.49763,35.36494,-2.25187,.68446,35.42492,-2.37171,.74121,35.44639,-2.48781,.65778,35.3434,-1.87979,.84795,35.72599,-1.98125,.89554,35.83306,-2.08068,.80334,35.84523,-1.94818,1.29847,35.63189,-2.13133,1.31199,35.64887,-2.0351,1.72086,35.40873,-2.21279,1.84515,35.25964,-2.19652,2.14012,34.91258,-2.20543,1.71235,35.41902,-2.10809,1.7151,35.39615,-2.09374,1.08189,35.45279,-2.29816,1.08481,35.50537,-2.17576,1.06662,35.49848,-2.06252,1.66246,35.76789,-2.26906,.17743,34.14133,-2.20301,.18359,34.15017,-2.11215,.48514,34.19632,-2.21191,.50286,34.23331,-2.13678,.38255,34.17098,-2.11483};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_32()
		{
			double[] value = {.35083,34.16884,-2.21744,.61291,34.5052,-1.74791,.47484,34.58024,-1.19682,.83896,34.65114,-1.58846,.66529,34.68171,-1.26065,1.13123,34.19714,-2.39634,1.69389,33.84402,-2.14698,1.72366,33.93739,-1.98667,.60899,34.21699,-2.33736,.57561,34.25245,-2.23805,.80929,34.59772,-1.66576,1.31454,34.35613,-1.90966,1.17324,34.4568,-1.85837,.56888,34.2922,-2.15187,.6084,34.35359,-2.20958,.97409,34.6296,-1.67287,.99833,34.73777,-1.59925,1.09719,34.58905,-1.75023,1.22376,34.52452,-1.7956,1.26201,34.64173,-1.75353,1.14658,34.68582,-1.68998,1.81115,34.02954,-1.87288,1.8375,33.77253,-2.01937,1.89311,33.89403,-1.8763,1.63146,34.93148,-1.86562,1.61696,34.78824,-1.83116,1.33329,35.09768,-1.79867,.82725,34.89203,-1.28586,1.66281,33.73238,-2.29293,.3807,35.01639,-1.43739,.47806,35.06622,-1.46302,.52385,35.09716,-1.49214,.61251,35.66361,-1.88912,.255,35.37078,-2.32001,.15071,35.01417,-2.282,.01591,35.06013,-2.12975,.16595,35.08374,-2.15573,.01591,34.96785,-2.26115,.10503,34.80548,-2.66081,.24717,34.98043,-2.38862,.23582,34.9182,-2.52624,.48307,35.14677,-2.15314,.46214,35.24891,-2.22527,.16489,35.26254,-2.58838,.60941,34.6854,-2.85923,.50073,34.86227,-3.10058,.82519,34.48948,-2.65707,.72361,34.47726,-2.66317,.71974,34.56628,-2.81943,.78257,34.741,-2.30162,.57868,34.70295,-2.82632,.59049,34.76736,-2.85522,.63512,34.82783,-2.54973,.63092,34.75441,-2.48312,.22555,34.90301,-2.86478,.31201,34.78721,-2.83293,.19627,35.09168,-2.77319,.27138,35.06214,-2.70156,.5259,34.91558,-2.68552,.50915,34.77739,-2.85135,.50947,34.73147,-2.82305,.50852,34.81141,-2.85612,.56781,34.57724,-2.60354,.57872,34.60016,-2.6836,.39871,34.79941,-2.84611,.30207,35.05413,-2.66595,.95883,35.43549,-1.98083,.91715,35.55978,-1.99561,1.06026,35.45048,-1.93224,1.65026,35.11095,-1.92002,1.67802,35.45735,-2.05209,1.68686,35.50398,-2.07437,1.65052,35.75629,-2.07894,1.50471,35.70607,-1.99653,1.74646,33.51799,-2.50686,2.08525,34.79454,-2.28779,2.05282,34.7076,-2.27479,2.02357,34.72605,-2.35817,2.02418,34.26571,-2.17775,1.98388,34.16389,-2.18234,1.91536,34.22617,-2.56518,1.03373,35.26736,-2.53616,1.0741,35.59779,-2.43386,.78207,35.57397,-2.44097,.78476,35.50521,-2.57602,.73868,35.4581,-2.48705,.81456,35.57079,-2.61633,.7058,35.7416,-1.86834,.69268,35.7556,-1.87437,.59055,35.68716,-1.885,.78644,35.86099,-1.95659,.77996,35.86294,-1.96331,.95866,35.46413,-2.54697,.49784,34.33454,-2.05102,.50078,34.31847,-2.05775,.75908,34.98409,-2.67305,.90124,34.93356,-2.71133,.85887,34.97398,-2.67594,.93369,34.95766,-2.71999,.31355,35.02578,-2.64107};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_33()
		{
			double[] value = {1.78451,34.0719,-2.71865,1.78852,34.00514,-2.84257,1.77277,33.92047,-2.96869,.04819,34.53474,-3.4274,.35266,31.29843,-3.6519,.3822,31.42397,-3.83553,.41328,31.45064,-3.7136,.4702,31.30173,-3.8767,.47841,31.33463,-3.81876,.41161,31.31158,-3.83385,-.47071,31.76709,-3.9328,-.47004,31.76713,-3.93323,-.47917,31.7585,-3.9277,-.46321,31.75138,-3.94056,-.37162,31.39807,-3.96452,-.31599,31.22205,-3.56538,-.31309,31.24978,-3.58351,-1.70537,33.70678,-2.66432,-1.66407,33.65685,-2.8583,-.55305,34.32124,-2.29147,-.34858,34.95778,-2.62192,-.38705,34.91593,-2.59593,-.2033,35.00303,-2.80127,-.23467,34.84131,-2.8644,-.63217,35.3235,-2.2869,-.89216,34.86375,-2.78353,-.89314,34.75015,-2.88829,-.92504,34.88469,-2.79643,-.36324,34.77353,-3.10732,-.47967,34.77954,-3.1577,-.64731,34.67498,-3.23476,-.63122,34.77741,-3.16658,-.61519,34.68811,-3.09892,-.61924,34.98576,-2.92364,-.27625,34.78589,-3.09742,-.12874,34.74846,-3.16341,-.05961,35.37096,-2.63276,-.05088,35.34356,-2.77587,-.03675,35.26756,-2.95209,-.01846,35.29358,-3.06503,-.82941,35.46473,-2.58114,-.78922,35.5615,-2.62168,-.75924,35.49596,-2.58142,-1.01561,35.43311,-2.35063,-.89786,35.53557,-2.58833,-1.02971,35.5608,-2.45874,-.88962,35.9414,-2.52433,-.88276,35.94095,-2.52414,-.58069,35.66361,-1.88912,-1.51336,35.60156,-2.37225,-.84336,35.98792,-2.08521,-.88008,35.35006,-1.87933,-1.93876,34.70556,-2.47581,-1.9028,34.52459,-2.46426,-2.03231,34.5616,-2.14983,-2.04953,34.58471,-2.07321,-2.10753,34.92972,-2.15947,-2.10724,34.9334,-2.16592,-2.04294,35.08787,-2.23173,-1.76191,33.61835,-2.24235,-1.31774,35.31257,-2.52917,-1.79731,35.22361,-2.00734,-1.62608,35.3429,-1.96707,-1.65956,35.37225,-2.02335,-1.39008,35.50183,-1.91028,-1.71273,35.59892,-2.17559,-1.71623,35.70506,-2.21168,-1.5988,35.80105,-2.20017,-1.42608,35.53471,-1.9288,-.85004,35.25221,-1.71014,-.82883,35.2633,-1.63877,-1.43939,34.96452,-1.81811,-.86692,35.00423,-1.37922,-.93262,35.07586,-1.54405,-.91571,34.9776,-1.5119,-.93153,35.19045,-1.59526,-.62122,34.48695,-2.18122,-.6012,34.57064,-2.35207,-.38645,34.8518,-2.59191,-.34092,34.99024,-2.65547,-.60666,34.91889,-2.71197,-.24682,34.85303,-2.85359,-.35757,34.82962,-2.85375,-.25991,35.04258,-2.71048,-.47978,34.68043,-2.58853,-.57125,34.66275,-2.43321,-.49691,34.76233,-2.50781,-.8846,34.64986,-2.75967,-.92645,34.57454,-2.56706,-.90775,34.54502,-2.6143,-.9065,34.67245,-2.72827,-.57086,34.50901,-2.46563,-.87937,34.40596,-2.51657,-.62462,34.94313,-2.80053,-1.17405,34.36618,-3.05284,-.81777,34.59679,-2.79552,-.40355,35.16842,-2.34476,-.40925,35.0715,-2.26826,-.27018,34.45352,-3.15707,-.28514,34.42098,-3.08923};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_34()
		{
			double[] value = {-.05049,35.3649,-2.55909,-.12692,35.37881,-2.49519,-.04628,35.40696,-2.55273,-.3023,34.55514,-2.89886,-.30011,34.38844,-3.02138,-.10366,34.94461,-2.40827,-.17795,34.51574,-2.90126,-.17702,34.71612,-2.76536,-.73503,35.0587,-1.36984,-.60682,35.06927,-1.40986,-.75421,35.11125,-1.41436,-.69802,35.21046,-1.53261,-.79804,34.8806,-1.28886,-1.31832,34.92148,-1.76122,-1.14966,34.96935,-1.68993,-1.31199,34.98767,-1.77529,-.94164,34.50689,-1.96572,-.88851,34.55591,-2.06973,-.83491,34.61014,-2.16156,-.97773,34.50524,-2.33578,-1.08131,34.41673,-2.25026,-1.16315,34.34632,-2.18381,-1.00604,34.5172,-1.81217,-.53688,34.28304,-2.16368,-1.29923,34.24959,-2.07639,-1.5501,34.12848,-1.9656,-1.49836,34.04631,-2.09578,-1.39349,34.258,-1.94191,-1.06803,34.00002,-2.4995,-.85472,34.00266,-2.53697,-.67804,34.15218,-2.42774,-.85186,34.12114,-2.48379,-.31765,34.17311,-2.2345,-.3507,34.17693,-2.10185,-.15159,34.15519,-2.09859,-.34226,34.26211,-2.01417,-.13939,34.23247,-1.98856,-.30376,35.33128,-1.92533,-.28961,35.25261,-1.9997,-.69692,35.5052,-1.93446,-1.65251,35.6339,-2.3036,-1.47289,35.70607,-1.99653,-1.6187,35.75629,-2.07894,-1.70096,35.48941,-2.1383,-1.5292,35.60932,-1.97773,-1.61603,35.64044,-2.0421,-.90987,35.92289,-2.52042,-.91803,35.88768,-2.19913,-.97674,35.68892,-2.18173,-1.02134,35.52485,-2.17695,-2.10045,34.66076,-2.01679,-.74162,35.57767,-1.91026,-.72105,35.62712,-2.24574,-.76077,35.78199,-2.17597,-.67313,35.51587,-2.32724,-.56239,35.17729,-2.34806,-.41549,34.51784,-3.31221,-.28652,35.30574,-2.44459,-.08591,35.17825,-2.99373,-.16918,35.00414,-3.00388,.01591,35.30372,-1.82067,.01591,35.27271,-1.88948,-.11512,35.3017,-1.92397,-.1362,35.33233,-1.83557,-.58965,35.25848,-1.62671,-.8175,35.26442,-1.63033,-1.89571,33.84422,-2.1973,-1.91477,33.92065,-2.08542,-1.75973,33.63286,-2.45478,-1.84755,34.14542,-2.62182,-1.79664,34.06767,-2.56184,-1.68456,34.05347,-2.83833,-1.11898,34.4772,-3.12425,-.3053,31.26499,-3.49743,-.02018,31.21578,-3.63431,-.29202,31.81735,-3.83888,-.28432,31.83297,-3.93494,-.18232,31.7866,-3.85488,-.14065,32.08379,-4.03078,-.13382,32.08888,-4.01533,-.09472,32.12174,-4.02031,-.25145,32.2687,-4.08506,-.46292,32.20764,-4.03789,-.0656,32.20255,-4.06869,-.00026,32.21046,-4.08299,-.0643,32.1922,-4.04986,-.07591,32.29007,-4.18478,-.34281,31.62685,-4.06981,-.69388,31.61686,-3.50465,-1.04618,31.68037,-3.41182,-1.04505,31.84063,-3.37492,-.94104,31.81843,-3.40236,-1.06798,31.96984,-3.4111,-1.01341,31.98226,-3.43621,-1.06544,32.11867,-3.47446,-.72015,31.69113,-3.46965,-.94385,32.20633,-3.92161,-.41479,32.16145,-3.82196,-.42149,32.22654,-3.87207,-.46179,32.18722,-3.65162};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_35()
		{
			double[] value = {-.35927,32.21965,-3.74142,-.41153,32.21696,-3.90035,-.48572,31.97058,-3.95212,-.62792,32.13408,-3.85958,-.71369,32.25415,-3.82972,-.69955,32.34918,-3.84992,-.45937,32.12448,-3.56151,-.45591,32.13488,-3.54993,-.15114,32.9661,-3.86007,-.16799,32.99501,-3.84823,-.06995,33.18531,-3.85147,-.05516,33.21063,-3.84683,-.22672,33.17754,-3.81004,-.43198,33.08801,-3.58047,-.59958,33.15333,-3.5481,-.685,33.18513,-3.56121,-1.2799,31.8053,-3.61387,-1.25575,31.73085,-3.52989,-1.4208,32.78272,-3.49194,-1.39745,32.77967,-3.47972,-.45935,32.78535,-3.38291,-.46251,32.77309,-3.39318,-.84464,32.64453,-3.51928,-.52038,32.87547,-3.37738,-.52162,32.86114,-3.38251,-.60879,33.1233,-3.27251,-.60892,33.11576,-3.28286,-.60331,33.1181,-3.27295,-.78128,32.92334,-3.87995,-.65639,33.16521,-3.84321,-.81677,32.98253,-3.88606,-.18507,32.91116,-4.01197,-.2004,32.91275,-4.01539,-.08301,32.1241,-4.03579,-.09647,32.70341,-4.12796,-.18158,32.79212,-4.05618,-.07676,32.80266,-4.06203,-.09458,33.08761,-4.10767,-.08446,33.17431,-4.17398,-.10776,32.32027,-3.8403,-.01848,32.09001,-3.88041,-.09129,32.07702,-3.88904,-.02733,32.34889,-3.84339,-.03686,32.41814,-4.01124,-.04503,32.86186,-3.75201,-.05143,33.0427,-3.7016,-.1332,32.82879,-3.73841,-.04999,32.65756,-3.9729,-.04138,32.89591,-3.92645,-1.34915,32.78854,-3.7806,-1.26357,32.44539,-3.83579,-1.27196,32.44588,-3.81778,-1.28443,32.22395,-3.79776,-1.62877,33.45677,-3.56659,-1.67902,33.18321,-3.47115,-1.64494,33.32945,-3.55586,-1.67267,33.12222,-3.25808,-1.61121,33.41999,-3.40671,-1.64749,33.36596,-3.47653,-.50353,33.69285,-3.35392,-.51998,33.67486,-3.34237,-.50351,33.89474,-3.54982,-.50869,33.82007,-3.5788,-.51672,33.66937,-3.30777,-.58955,33.97671,-3.45096,-.57511,33.97777,-3.45829,-.18242,34.00979,-3.51014,-.20598,34.03607,-3.47242,-.14538,33.94898,-3.54012,-.16857,33.94527,-3.53804,-.17803,33.86907,-3.55533,-.15623,33.86786,-3.56279,-.24009,33.74542,-3.52234,-.19102,33.7931,-3.55418,-.23451,33.76605,-3.44438,-.24259,33.76882,-3.44661,-.27704,33.84972,-3.54501,-.32436,33.85495,-3.31912,-.25543,34.03249,-3.42398,-.3272,34.01308,-3.46233,-.39123,33.90932,-3.53314,-.53659,33.9596,-3.51566,-.42896,33.96999,-3.51314,-.66037,33.97791,-3.35155,-.5495,33.90564,-3.04303,-.5781,33.48585,-3.06107,-.57381,33.48741,-3.05739,-.07027,34.16336,-3.1671,-.58517,33.77727,-2.81137,-.4231,33.67017,-2.94774,-.41085,33.47895,-3.0614,-.56911,33.70021,-3.65074,-.1886,33.57864,-3.79047,-.03142,33.94564,-3.72903,-.30525,33.49446,-3.79034,-.30276,33.47787,-3.78031,-.04188,33.51058,-4.13104,-.46464,33.90062,-3.64555,-.71066,33.55811,-3.77935,-.74447,33.76525,-3.49258};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_36()
		{
			double[] value = {-.68356,33.72297,-3.63907,-.77046,33.81831,-3.64276,-.6931,33.69064,-3.49461,-.19103,33.45356,-3.52333,-.05058,33.19967,-3.64285,-.09922,33.44027,-3.5403,-.05867,33.43059,-3.5523,-.07085,33.20571,-3.64119,-.21723,33.65794,-3.44386,-.22801,33.68026,-3.49073,-.24474,33.86058,-3.36044,-.265,34.06646,-3.28125,-.26173,34.08831,-3.33414,-.16945,34.48947,-3.21662,-.2512,34.27993,-3.26926,-.16945,34.32142,-3.3375,-.15809,33.7362,-3.60285,-.06034,33.76148,-3.66778,-.06232,33.96419,-3.57263,-1.10562,32.42492,-3.53282,-.68452,31.63623,-3.48984,-1.10497,32.24126,-3.49346,-1.20577,32.11536,-3.41742,-1.59031,33.567,-2.54868,-1.5765,33.49107,-2.6861,-1.61782,33.32271,-2.96418,-1.6103,33.21425,-3.07336,-1.28656,32.89944,-3.45412,-1.35335,33.20247,-3.1877,-1.48166,33.26959,-3.08269,-1.36299,33.27193,-3.11371,-.73844,33.57203,-3.2288,-.96908,33.79991,-2.81533,-.8279,33.8669,-2.92371,-.83292,33.82116,-2.79046,-.99499,33.79215,-2.83471,-.49849,33.62462,-3.0137,-.55959,33.07262,-3.49769,-.90812,32.96048,-3.63571,-.91692,33.07432,-3.5876,-.89513,33.16739,-3.518,-.64188,32.70063,-3.47921,-.52411,32.95542,-3.49969,-.89276,33.55796,-3.161,-1.2757,33.11957,-3.36301,-.98995,32.4939,-3.56158,-.69321,33.83306,-2.76861,-.42072,33.58508,-3.00209,-.48576,33.61995,-3.00872,-.43971,32.86869,-3.33923,-.56142,32.34859,-3.53203,-.48935,32.39355,-3.48798,-.28835,33.80658,-2.77115,-.29748,33.71083,-2.86952,-.29563,33.63028,-2.94106,-.4098,33.2911,-3.19247,-.26762,33.37352,-3.1265,-.40547,33.36833,-3.12234,-.27083,33.27778,-3.18158,-.32847,32.09789,-3.4956,-.31961,31.66147,-3.47969,-.31597,31.50919,-3.43912,-.1558,31.63491,-3.46998,-.16344,31.48776,-3.39647,-.11078,32.8003,-3.28929,-.12748,32.92401,-3.26864,-.1269,33.20878,-4.10442,-.22656,31.45231,-3.71715,-.22409,31.59502,-3.76636,-.38093,31.51567,-3.96296,-1.06053,31.74743,-3.63526,-.66369,31.93075,-3.88356,-1.21174,32.45816,-3.86057,-1.03941,31.91728,-3.73648,-1.18635,31.89973,-3.69728,-.9195,31.90142,-3.75231,-.96857,32.04974,-3.86869,-.63495,32.12372,-3.87066,-.575,32.09279,-3.87626,-.92673,32.77974,-3.88115,-.88055,33.00447,-3.90411,-.97706,33.09414,-3.94847,-1.14669,32.46132,-3.8737,-.99488,33.08285,-3.95532,.01591,31.32397,-3.30253,-.02293,31.22288,-3.64837,-.03059,31.29525,-3.67222,-.03496,32.56995,-3.80401,.00907,32.29811,-4.20085,.00976,32.54113,-4.26133,.00172,32.38692,-4.26738,-.26749,33.03744,-4.00753,-.10925,33.3507,-4.09153,-.33075,33.16438,-3.9339,-.02981,34.39715,-3.55189,-1.76491,33.43897,-2.87822,-1.63366,33.45174,-3.18205,-1.64858,33.51008,-3.10311,-1.70055,33.51192,-2.89802,-1.34488,32.57805,-3.69685};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_37()
		{
			double[] value = {-1.2649,32.42887,-3.71335,-1.2603,32.42585,-3.68358,-1.64415,33.05527,-3.4574,-1.64068,33.15059,-3.51963,-1.31978,32.91249,-3.88372,-1.33905,32.92642,-3.80146,-1.07845,33.14381,-3.94407,-1.58488,33.09398,-3.58735,-1.51953,33.15963,-3.64098,-1.51127,32.95504,-3.65902,-.66436,33.23642,-3.83906,-1.6768,33.83263,-2.92695,-1.67684,33.88988,-3.07048,-1.73778,33.9287,-2.97072,-1.67258,33.95107,-2.96468,-1.73955,33.84747,-3.08487,-1.67397,33.72255,-3.20295,-1.69762,33.73558,-3.22977,-1.60039,33.56144,-3.23938,-1.60473,33.47937,-3.30696,-.30357,34.2032,-3.46704,-.15616,34.21335,-3.53943,-.31643,34.10632,-3.53566,-.31213,34.00214,-3.60241,-.50055,33.3282,-3.83705,-.36205,33.2871,-3.8365,-.71926,33.3828,-3.8121,-.64267,33.36851,-3.80771,-.29768,33.67863,-3.75454,-.30816,33.86958,-3.67926,-.7427,34.24327,-3.48332,-.87945,33.95166,-3.65319,-.97937,33.96676,-3.72578,-1.36616,33.76508,-3.54358,-.86913,34.2536,-3.52312,-1.14308,34.11234,-3.37343,-1.2945,33.97881,-3.36648,-1.38185,33.90175,-3.34346,-.35295,33.06179,-3.80506,.41887,34.91593,-2.59593,.41971,34.89476,-2.57996,.53426,34.79037,-2.51796,-1.57733,34.03143,-2.95338,-1.56258,33.96088,-3.07842,-1.30664,33.89081,-3.50466,-.58909,34.3766,-3.41731,-.44148,33.4714,-3.79723,-.91672,33.43107,-3.81499,-.79585,33.3971,-3.81649,-.77411,33.26942,-3.84566,-.43613,34.35515,-3.37496,-1.63947,33.61835,-3.1361,-1.66837,33.68877,-3.17075,-1.70066,33.80267,-3.06934,-1.67758,33.74758,-3.04841,-1.65266,33.6637,-3.02978,-1.65815,33.75883,-2.89366,-1.65708,33.59501,-2.97205,-1.33468,32.77976,-3.87186,-1.33052,32.62909,-3.83117,-1.2475,32.26602,-3.67521,-1.36724,32.69924,-3.51165,-1.46025,32.76203,-3.641,-1.31006,32.61272,-3.53213,-1.51316,32.89091,-3.47828,-1.52428,32.89,-3.60223,-1.603,32.98467,-3.5233,-.05402,34.24949,-3.6209,-.07578,33.34687,-4.16023,.01591,31.93996,-3.86363,.01591,32.103,-3.87178,-.0213,31.94079,-3.87109,.01591,31.77802,-3.84006,-.03433,31.60121,-3.77912,-.03656,31.78084,-3.84514,.01591,31.60025,-3.78242,-.03218,31.45992,-3.73543,.01591,31.46018,-3.73904,-1.26265,31.82842,-3.4894,-1.2782,31.86737,-3.53357,-1.26843,32.11055,-3.62401,-1.22373,32.10918,-3.42506,-1.3201,32.6287,-3.84791,-1.32347,32.77578,-3.88827,-1.26593,32.64277,-3.88238,-1.09182,32.95724,-3.96534,-1.13888,32.33449,-3.89842,-1.27608,32.09866,-3.65067,-1.25524,32.25845,-3.70329,-1.27725,31.89894,-3.69852,-1.29196,31.90711,-3.68632,-1.26904,31.98234,-3.57388,.01591,31.33839,-3.29635,.01591,31.37742,-3.31416,-.14858,31.79116,-3.49354,.01591,31.63928,-3.46066,.01591,31.81311,-3.48156,.01591,32.06286,-3.43962,-.15938,32.06943,-3.45357,.01591,31.95858,-3.4539};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_38()
		{
			double[] value = {.01591,32.30701,-3.43573,.01591,32.18773,-3.4449,-.09698,33.25014,-3.1671,.01591,33.33437,-3.12043,-.10883,33.3559,-3.12264,.01591,33.23849,-3.16166,.01591,33.50032,-2.95204,.01591,33.44434,-3.03701,-.10004,33.6919,-2.84585,.01591,33.77846,-2.73742,-.1085,33.79499,-2.74905,.01591,33.67127,-2.83099,-.31577,32.48679,-3.47228,-.30896,32.58333,-3.4471,-.28827,32.80104,-3.32508,-.29775,32.73018,-3.37072,-.27684,32.95121,-3.29325,-.27363,33.13601,-3.23232,-.1082,33.61211,-2.9098,-.11015,33.92675,-2.59901,-.39848,32.12805,-3.50969,-.31871,32.20893,-3.49861,-.32738,32.11267,-3.49602,-.2991,32.71809,-3.38187,-.27753,32.93566,-3.29322,-.28685,32.81486,-3.3196,-.28214,33.44902,-3.07854,-.29726,33.61602,-2.94752,-.30287,33.55725,-2.98841,-.44273,32.85523,-3.34496,-.91845,32.11292,-3.51122,-.963,32.22413,-3.52489,-1.14833,33.04707,-3.4804,-1.29667,33.03155,-3.42038,-1.40193,33.57034,-2.73771,-.84435,33.93814,-2.59839,-.98945,32.37255,-3.56291,-1.10008,32.92418,-3.54235,-.4766,33.79716,-3.08327,-.69409,33.83231,-2.78157,-.80082,33.61807,-3.21919,-1.29387,32.62319,-3.51931,-1.34966,32.70741,-3.49737,-1.59955,33.09484,-3.25843,-1.58427,33.00932,-3.36476,-1.59628,33.41211,-2.81284,-1.19508,31.94092,-3.35263,.01591,33.78602,-3.71626,.01591,33.99034,-3.6209,-.06252,34.34114,-3.37546,-.06252,34.51069,-3.25568,-.26283,34.25492,-3.21189,-.2672,34.23315,-3.15873,-.07366,34.31577,-3.03007,-.17237,34.19664,-3.16081,-.17648,34.35213,-3.02581,.01591,34.20067,-3.54723,.01591,34.37174,-3.42855,-.06252,34.17158,-3.49523,-.2512,34.1134,-3.39124,-.1709,34.03302,-3.28535,.01591,34.54281,-3.30987,-.14701,33.83544,-3.37034,.01591,33.64158,-3.46245,-.0623,33.62214,-3.46899,-.12311,33.63785,-3.45532,.01591,33.38175,-3.58073,.01591,33.15687,-3.67472,-.05846,33.55276,-3.7412,-.16183,33.53153,-3.68718,.01591,33.36535,-3.86361,.01591,33.57569,-3.78993,-.05658,33.34403,-3.81461,-.15543,33.32224,-3.75735,-.14229,33.28413,-3.77675,-.48628,33.70155,-3.20682,-.10578,33.52584,-2.96633,.01591,33.58073,-2.88928,-.10943,33.59774,-2.91556,.01591,33.51045,-2.94102,-.10715,33.44481,-3.06648,-.23879,33.70257,-3.5376,-.7114,33.64033,-3.35785,-.7546,33.6985,-3.35139,-.31966,33.75335,-3.37873,-.45477,33.99288,-3.46022,-.40391,33.83572,-3.24795,-.48041,33.71833,-3.24089,-.40351,33.73434,-3.30817,-.27169,33.9273,-3.52865,-.2973,33.99005,-3.50956,-.25033,34.05702,-3.4097,-1.74263,33.83984,-3.0799,-1.58932,32.99449,-3.40551,-.10329,31.94207,-3.8826,.01591,33.03776,-3.71778,.01591,32.44012,-4.03256,.01591,32.3866,-3.82835,-.12423,32.56353,-3.79156,-.1799,32.55691,-3.81033};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_39()
		{
			double[] value = {-.10495,31.78365,-3.85023,-.09617,31.45967,-3.73182,-.10048,31.60218,-3.77582,.01591,33.32387,-4.20756,-.12174,32.69828,-3.36324,.01591,32.66757,-3.33189,-1.19078,31.8698,-3.33884,-1.22821,31.80109,-3.37103,-1.26222,31.83408,-3.48448,-.51174,32.96766,-3.5133,-.54399,33.07417,-3.51148,-.5256,32.89531,-3.65007,-.40891,32.9911,-3.58807,-.30608,33.01454,-3.66284,-.30851,32.96133,-3.7405,-.27273,32.97768,-3.82398,-.41706,32.93699,-3.69288,-.20124,33.07228,-3.83729,-.06665,33.09116,-3.87456,-.14197,32.18609,-3.45751,-.15874,32.08415,-3.45242,-.33995,32.18712,-3.81173,.01591,31.47592,-3.37155,-1.2351,34.4404,-2.96963,-1.22127,34.58502,-3.00877,-1.43723,34.55951,-2.84496,-1.52421,34.49511,-2.77602,-1.72578,34.02752,-2.70304,-1.95508,34.05766,-2.03731,-2.06279,34.19115,-1.926,-1.97621,33.95455,-1.95606,-2.02644,34.23896,-2.01233,-2.01441,34.40816,-2.14456,-2.04143,34.43849,-2.04982,-1.98574,34.57308,-2.24862,-1.67866,33.84159,-2.7658,-1.62905,34.90603,-2.59563,-1.64315,34.78821,-2.64085,-1.97032,34.64632,-2.37125,-2.06232,35.03083,-2.04065,-2.05647,35.09179,-2.13914,-1.94268,35.16351,-2.10465,-1.94457,35.11142,-2.01918,-1.81453,35.27084,-2.09411,-.32512,35.12091,-1.57196,-.15368,35.15479,-1.63737,-.16701,35.08192,-1.54861,.01591,35.22367,-1.70678,.01591,35.13326,-1.61856,-.14837,35.23591,-1.72093,-.75327,35.31008,-1.69788,.01591,35.30213,-1.80782,-.13648,35.32982,-1.82301,-.1109,35.22279,-2.01755,.01591,35.2131,-1.97219,-.26025,35.11726,-2.12195,-.13412,35.08374,-2.15573,-.33496,35.38113,-1.82781,-.17061,35.12878,-2.88742,.00263,34.96656,-3.24926,-.22657,35.37794,-2.33774,-.13039,35.38227,-2.49862,-1.01351,35.5934,-2.50658,-.7859,35.68249,-2.38877,-.81317,35.82582,-2.30823,-.8315,35.84058,-2.44385,-.81031,35.75952,-2.47758,-.96056,35.42082,-1.96643,-1.36294,35.62608,-1.93995,-1.37693,35.26167,-2.46739,-2.04355,35.10764,-2.13453,-2.10597,34.46895,-1.95127,-.4389,35.40217,-1.83721,-1.67174,35.62031,-2.10371,-1.68075,35.73981,-2.1399,.01591,34.06892,-2.3242,.01591,33.90163,-2.59902,-.12092,34.08227,-2.3705,-.13802,34.24803,-1.98088,.01591,34.33083,-1.80243,-.15593,34.34005,-1.81008,.01591,34.23247,-1.96911,-.16438,34.42327,-1.59583,.01591,34.48738,-1.28464,-.18364,34.4965,-1.32527,.01591,34.41655,-1.56935,-1.44804,33.95357,-2.25054,-1.66207,33.84402,-2.14698,-1.13002,34.25007,-2.29228,-1.29872,34.08439,-2.24875,-1.01034,34.49139,-2.13263,-.92263,34.56228,-2.23914,-1.3261,34.44572,-1.82709,-1.60579,34.21393,-1.88767,-1.46419,34.33017,-1.87215,-1.83532,34.14447,-1.83273,-1.99939,34.3076,-1.82506,-1.92908,34.0371,-1.82142,-1.88694,34.40072,-1.82206,-1.36365,34.56536,-1.79463};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_40()
		{
			double[] value = {-1.56212,34.62801,-1.81337,-1.51632,34.43972,-1.82656,-1.41401,34.71439,-1.78623,-1.1446,34.81504,-1.67018,-1.27886,34.77526,-1.73992,-.8988,34.87934,-1.47975,-1.01492,34.84844,-1.58341,-1.0171,34.95938,-1.60727,-1.44194,34.86492,-1.8026,-1.79476,34.68482,-1.84345,-1.76347,34.49623,-1.81876,-1.92462,34.6219,-1.85247,-2.04815,34.80497,-1.90939,-2.04333,34.56026,-1.86024,-1.93819,34.85356,-1.91019,-2.0485,34.9709,-1.99393,-1.93679,35.04188,-1.991,-1.14811,35.07684,-1.72236,-1.01928,35.07031,-1.63113,-1.67504,34.3075,-1.84152,-.64974,34.73495,-1.15974,-.23368,34.60429,-1.04638,.01591,34.70336,-1.1098,-.2258,34.74225,-1.12507,.01591,34.58059,-1.03731,-.4133,34.78772,-1.15074,-.64576,34.74374,-1.1552,-.45507,34.64376,-1.07933,-.57888,34.88827,-1.22739,-1.77248,33.69914,-2.14863,.01591,34.96225,-1.39647,-.18316,34.97409,-1.42017,.01591,35.0586,-1.52063,-.19166,34.83564,-1.24914,.01591,34.83067,-1.24476,-.38471,34.88826,-1.29123,-.34888,35.01639,-1.43739,-.44623,35.06622,-1.46302,-.49202,35.09716,-1.49214,-.51548,34.98329,-1.34363,-.11889,35.01417,-2.282,-.22318,35.37078,-2.32001,-.16945,34.65751,-3.09574,-.06252,34.68025,-3.1359,-.06252,34.8498,-3.01612,-.24277,35.04644,-2.25246,-.21535,34.98043,-2.38862,-.07273,34.67359,-2.76558,-.07439,34.4763,-2.9035,-.204,34.9182,-2.52624,-.17505,34.83514,-2.65247,-.06252,35.01935,-2.89634,.01591,34.4652,-2.87069,.01591,34.25114,-3.04553,.01591,34.71388,-3.1912,.01591,34.88494,-3.07252,-.15233,35.18133,-2.68466,.01591,35.29963,-2.67996,.01591,35.38083,-2.58867,-.05112,35.2916,-2.62659,-.0648,35.11885,-2.81472,-.061,35.20959,-2.7248,.01591,35.21842,-2.77126,-.88843,34.67906,-2.40563,-.90307,34.7461,-2.64253,-.87173,34.80944,-2.56493,-.93087,34.61997,-2.49144,-.75811,34.87298,-2.48226,-.82516,34.72968,-2.34021,-.82247,34.85385,-2.51575,-.57852,34.53832,-2.39037,-.8471,34.50425,-2.64985,-.7643,34.99056,-2.65739,-.55033,34.61498,-2.4628,-.54258,34.57773,-2.54801,-.54607,34.65091,-2.75721,-.48889,34.72588,-2.52662,-.26557,34.8268,-2.84643,.01591,34.56965,-1.03951,-1.61844,35.11095,-1.92002,-1.81437,35.09388,-1.97443,-1.81718,34.89443,-1.90613,-2.04869,35.0411,-2.0285,-2.06343,34.95535,-2.00144,-2.06582,34.89036,-2.31313,-2.10662,34.93329,-2.20688,-2.11745,34.84127,-2.09175,-.66085,35.7556,-1.87437,-.67398,35.7416,-1.86834,.01591,34.15328,-2.09036,-.47096,34.24128,-2.12451,-.14274,34.14652,-2.22021,-.39229,31.33022,-3.62854,.49503,31.75138,-3.94056,.42411,31.33022,-3.62854,.20687,34.83514,-2.65247,.20884,34.71612,-2.76536,.29739,34.8268,-2.84643,.79612,34.99056,-2.65739,.17456,34.14652,-2.22021};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_41()
		{
			double[] value = {.01591,34.12806,-2.18856,.37079,34.27864,-2.00744,.01591,34.21708,-1.97719,.16984,34.24803,-1.98088,.50278,34.24128,-2.12451,.16221,35.38227,-2.49862,.01591,35.42474,-2.57428,1.04533,35.5934,-2.50658,.86796,35.98845,-2.08893,.99238,35.42082,-1.96643,1.87937,34.14542,-2.62182,2.00803,33.95455,-1.95606,2.13779,34.46895,-1.95127,2.13808,34.47417,-1.93259,2.09461,34.19115,-1.926,2.13338,34.66894,-1.99807,2.14927,34.84127,-2.09175,2.07537,35.10764,-2.13453,1.8043,33.69914,-2.14863,1.9609,34.0371,-1.82142,2.09195,34.55678,-1.871,2.03122,34.3076,-1.82506,2.07515,34.56026,-1.86024,2.07998,34.80497,-1.90939,2.09525,34.95535,-2.00144,2.08032,34.9709,-1.99393,2.09548,34.80063,-1.92122,2.09414,35.03083,-2.04065,1.95644,34.6219,-1.85247,1.79529,34.49623,-1.81876,1.91876,34.40072,-1.82206,1.82658,34.68482,-1.84345,1.849,34.89443,-1.90613,1.96861,35.04188,-1.991,1.84619,35.09388,-1.97443,1.97001,34.85356,-1.91019,1.71258,35.73981,-2.1399,1.70356,35.62031,-2.10371,1.39476,35.62608,-1.93995,.78509,35.31008,-1.69788,1.0511,35.07031,-1.63113,1.04892,34.95938,-1.60727,1.17993,35.07684,-1.72236,.488,34.63407,-1.08285,.2655,34.60429,-1.04638,.26521,34.59315,-1.04852,.48689,34.64376,-1.07933,.67758,34.74374,-1.1552,.68156,34.73495,-1.15974,.63271,35.37515,-1.81473,.36678,35.38113,-1.82781,.47072,35.40217,-1.83721,.16831,35.32982,-1.82301,.16802,35.33233,-1.83557,.57789,34.65091,-2.75721,.52873,34.76233,-2.50781,.61034,34.53832,-2.39037,.85698,34.72968,-2.34021,.78993,34.87298,-2.48226,.9349,34.7461,-2.64253,.8543,34.85385,-2.51575,.90355,34.80944,-2.56493,.96269,34.61997,-2.49144,.95445,34.56228,-2.23914,.92026,34.67906,-2.40563,.87892,34.50425,-2.64985,.18415,35.18133,-2.68466,.09282,35.20959,-2.7248,.08295,35.2916,-2.62659,.09434,34.51069,-3.25568,.20127,34.65751,-3.09574,.09434,34.68025,-3.1359,.2083,34.35213,-3.02581,.10621,34.4763,-2.9035,.20977,34.51574,-2.90126,.10548,34.31577,-3.03007,.09434,34.8498,-3.01612,.10455,34.67359,-2.76558,.01591,34.66126,-2.73534,.27459,35.04644,-2.25246,.29207,35.11726,-2.12195,.6107,34.88827,-1.22739,.5473,34.98329,-1.34363,.41653,34.88826,-1.29123,.19883,35.08192,-1.54861,.21498,34.97409,-1.42017,.35694,35.12091,-1.57196,.25762,34.74225,-1.12507,.22348,34.83564,-1.24914,.44512,34.78772,-1.15074,.25633,34.53173,-1.12605,.01591,34.51577,-1.11241,1.35792,34.44572,-1.82709,1.54815,34.43972,-1.82656,1.39548,34.56536,-1.79463,1.49601,34.33017,-1.87215,1.86714,34.14447,-1.83273,1.63761,34.21393,-1.88767,1.70686,34.3075,-1.84152,1.47376,34.86492,-1.8026};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_42()
		{
			double[] value = {1.31068,34.77526,-1.73992,1.44584,34.71439,-1.78623,.93062,34.87934,-1.47975,1.04674,34.84844,-1.58341,1.17642,34.81504,-1.67018,1.59394,34.62801,-1.81337,1.04216,34.49139,-2.13263,1.16184,34.25007,-2.29228,1.33054,34.08439,-2.24875,1.47986,33.95357,-2.25054,.87617,33.93814,-2.59839,.53122,34.41246,-1.90476,.37928,34.36292,-1.87258,.21546,34.4965,-1.32527,.1962,34.42327,-1.59583,.18775,34.34005,-1.81008,.15274,34.08227,-2.3705,.82985,35.8911,-2.13104,1.84635,35.27084,-2.09411,1.9745,35.16351,-2.10465,.81772,35.68249,-2.38877,.76773,35.82051,-2.06218,.40498,34.88017,-3.04855,.02919,34.96656,-3.24926,.14694,35.3017,-1.92397,.14272,35.22279,-2.01755,1.97639,35.11142,-2.01918,2.08051,35.0411,-2.0285,2.09764,34.89036,-2.31313,1.66088,34.90603,-2.59563,1.67498,34.78821,-2.64085,1.7576,34.02752,-2.70304,1.82846,34.06767,-2.56184,1.71048,33.84159,-2.7658,2.07325,34.43849,-2.04982,2.04623,34.40816,-2.14456,2.05826,34.23896,-2.01233,1.9869,34.05766,-2.03731,1.85245,34.26471,-2.58051,1.30011,34.3159,-2.95993,1.26693,34.4404,-2.96963,1.55603,34.49511,-2.77602,1.07687,31.84063,-3.37492,1.27932,32.26602,-3.67521,1.3079,32.09866,-3.65067,1.30025,32.11055,-3.62401,1.29447,31.82842,-3.4894,1.1707,32.33449,-3.89842,.01591,31.94471,-3.45952,.1912,32.06943,-3.45357,.01591,32.07792,-3.43872,.19056,32.08415,-3.45242,.3592,32.11267,-3.49602,.36029,32.09789,-3.4956,.4303,32.12805,-3.50969,.17379,32.18609,-3.45751,.01591,32.17131,-3.4413,.35053,32.20893,-3.49861,.59897,32.34555,-3.54299,.59324,32.34859,-3.53203,.19981,32.99501,-3.84823,.18296,32.9661,-3.86007,.09847,33.09116,-3.87456,.18934,33.2582,-3.77919,.17411,33.28413,-3.77675,.3379,33.01454,-3.66284,.34033,32.96133,-3.7405,.32973,33.22424,-3.75788,.25854,33.17754,-3.81004,.23306,33.07228,-3.83729,.30455,32.97768,-3.82398,.57581,33.07417,-3.51148,.44073,32.9911,-3.58807,.44888,32.93699,-3.69288,.55742,32.89531,-3.65007,.54356,32.96766,-3.5133,1.30907,31.89894,-3.69852,1.2226,31.8698,-3.33884,1.2269,31.94092,-3.35263,1.25555,32.10918,-3.42506,1.38148,32.70741,-3.49737,1.34188,32.61272,-3.53213,1.39907,32.69924,-3.51165,1.54498,32.89091,-3.47828,1.61609,33.00932,-3.36476,1.62114,32.99449,-3.40551,.30866,32.95121,-3.29325,.30935,32.93566,-3.29322,.47455,32.85523,-3.34496,.32009,32.80104,-3.32508,.31867,32.81486,-3.3196,.33092,32.71809,-3.38187,.15356,32.69828,-3.36324,.32957,32.73018,-3.37072,.10858,32.80266,-4.06203,.1323,31.60218,-3.77582,.06838,31.78084,-3.84514,.13677,31.78365,-3.85023,.06615,31.60121,-3.77912,.12799,31.45967,-3.73182};
			return value;
		}
		private double[] getsacrum_Coord_7_24_point_43()
		{
			double[] value = {.064,31.45992,-3.73543,.15605,32.56353,-3.79156,.21172,32.55691,-3.81033,.05312,31.94079,-3.87109,.13511,31.94207,-3.8826,1.36234,32.62909,-3.83117,1.3665,32.77976,-3.87186,1.35192,32.6287,-3.84791,1.63482,32.98467,-3.5233,1.77445,33.83984,-3.0799,1.72944,33.73558,-3.22977,.51223,33.71833,-3.24089,.5181,33.70155,-3.20682,.28215,34.05702,-3.4097,.43533,33.73434,-3.30817,.35148,33.75335,-3.37873,.43573,33.83572,-3.24795,.48659,33.99288,-3.46022,.32912,33.99005,-3.50956,.30351,33.9273,-3.52865,.69775,33.95825,-3.19038,.77629,33.76525,-3.49258,.72492,33.69064,-3.49461,.50842,33.79716,-3.08327,.28302,34.1134,-3.39124,.27061,33.70257,-3.5376,.14125,33.59774,-2.91556,.01591,33.59347,-2.88425,.14002,33.61211,-2.9098,.72503,33.83306,-2.76861,.13897,33.44481,-3.06648,.01591,33.43569,-3.05003,.31397,33.44902,-3.07854,.1376,33.52584,-2.96633,.33469,33.55725,-2.98841,.32908,33.61602,-2.94752,.71538,33.72297,-3.63907,.4733,33.4714,-3.79723,.80228,33.81831,-3.64276,.29465,34.25492,-3.21189,.18725,33.32224,-3.75735,.0884,33.34403,-3.81461,.19365,33.53153,-3.68718,.09028,33.55276,-3.7412,.09434,34.17158,-3.49523,.09412,33.62214,-3.46899,.15493,33.63785,-3.45532,.17883,33.83544,-3.37034,.20272,34.03302,-3.28535,.20419,34.19664,-3.16081,.29902,34.23315,-3.15873,.09434,34.34114,-3.37546,.95027,32.11292,-3.51122,.99482,32.22413,-3.52489,1.6281,33.41211,-2.81284,1.43376,33.57034,-2.73771,1.63137,33.09484,-3.25843,1.31838,32.89944,-3.45412,1.32849,33.03155,-3.42038,.92458,33.55796,-3.161,1.18015,33.04707,-3.4804,1.1319,32.92418,-3.54235,1.02127,32.37255,-3.56291,.52117,32.39355,-3.48798,.30545,33.13601,-3.23232,.3476,32.48679,-3.47228,.34078,32.58333,-3.4471,.14032,33.79499,-2.74905,.13186,33.6919,-2.84585,.14065,33.3559,-3.12264,.1288,33.25014,-3.1671,.18041,31.79116,-3.49354,.14197,33.92675,-2.59901,1.68997,33.75883,-2.89366,1.12364,32.95724,-3.96534,1.29775,32.64277,-3.88238,.08584,34.24949,-3.6209,.06163,34.39715,-3.55189,1.5561,32.89,-3.60223,1.49207,32.76203,-3.641,1.05071,33.30579,-3.84435,.93667,33.30182,-3.85751,1.68448,33.6637,-3.02978,1.59441,33.96088,-3.07842};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getsympubis_Geo_6_29_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,0,-1,4,5,6,-1,7,8,9,-1,7,10,8,-1,11,12,2,-1,12,4,2,-1,13,14,0,-1,13,15,14,-1,16,17,18,-1,1,19,20,-1,21,22,5,-1,21,23,22,-1,12,24,5,-1,5,4,12,-1,25,21,5,-1,25,26,21,-1,25,27,26,-1,26,17,16,-1,18,17,28,-1,29,30,31,-1,31,27,29,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,39,40,41,-1,39,42,40,-1,43,44,45,-1,45,34,43,-1,46,47,48,-1,49,50,33,-1,37,51,52,-1,37,53,51,-1,54,52,55,-1,52,51,55,-1,56,57,38,-1,38,37,56,-1,58,59,60,-1,48,47,58,-1,61,47,46,-1,62,63,59,-1,63,64,59,-1,63,65,64,-1,63,49,65,-1,54,46,48,-1,59,58,47,-1,52,54,58,-1,54,48,58,-1,37,60,56,-1,56,64,57,-1,57,64,65,-1,46,54,66,-1,54,55,66,-1,37,36,53,-1,67,68,69,-1,68,70,69,-1,35,71,38,-1,35,32,71,-1,33,50,43,-1,43,34,33,-1,38,72,36,-1,38,71,72,-1,29,11,30,-1,11,20,30,-1,27,31,28,-1,28,17,27,-1,16,18,73,-1,17,26,27,-1,16,73,21,-1,21,26,16,-1,24,25,5,-1,12,29,24,-1,11,29,12,-1,74,73,18,-1,18,75,74,-1,22,6,5,-1,76,77,78,-1,76,79,77,-1,4,80,3,-1,3,2,4,-1,14,19,1,-1,1,0,14,-1,6,80,4,-1,6,81,80,-1,82,74,83,-1,82,23,74,-1,23,84,22,-1,84,23,82,-1,75,78,77,-1,75,85,78,-1,77,86,83,-1,79,86,77,-1,87,15,88,-1,89,15,87,-1,76,7,90,-1,76,78,7,-1,86,91,92,-1,86,93,91,-1,94,95,96,-1,95,94,97,-1,98,99,100,-1,99,98,101,-1,83,92,82,-1,86,92,83,-1,96,82,92,-1,96,84,82,-1,76,102,103,-1,102,76,90,-1,89,14,15,-1,89,9,14,-1,3,100,99,-1,100,3,80,-1,18,85,75,-1,85,18,28,-1,23,73,74,-1,23,21,73,-1,27,24,29,-1,25,24,27,-1,2,20,11,-1,2,1,20,-1,55,104,105,-1,55,51,104,-1,106,51,53,-1,104,51,106,-1,67,66,68,-1,67,107,66,-1,108,68,105,-1,68,108,70,-1,44,87,88,-1,87,44,109,-1,41,69,110,-1,41,67,69,-1,91,108,111,-1,91,93,108,-1,112,94,113,-1,97,94,112,-1,114,98,115,-1,101,98,114,-1,57,35,38,-1,35,57,65,-1,111,105,104,-1,105,111,108,-1,104,113,111,-1,104,106,113,-1,102,69,103,-1,110,69,102,-1,43,109,44,-1,43,39,109,-1,115,32,114,-1,71,32,115,-1,107,46,66,-1,61,46,107,-1,56,59,64,-1,59,56,60,-1,58,37,52,-1,37,58,60,-1,49,35,65,-1,49,33,35,-1,59,61,62,-1,61,59,47,-1,63,40,42,-1,63,62,40,-1,40,61,107,-1,40,62,61,-1,49,42,50,-1,49,63,42,-1,106,112,113,-1,106,72,112,-1,87,110,102,-1,109,110,87,-1,71,112,72,-1,115,112,71,-1,70,103,69,-1,70,116,103,-1,93,70,108,-1,70,93,116,-1,114,34,45,-1,32,34,114,-1,45,101,114,-1,117,101,45,-1,97,115,98,-1,97,112,115,-1,91,113,94,-1,91,111,113,-1,39,110,109,-1,39,41,110,-1,88,45,44,-1,88,117,45,-1,50,39,43,-1,50,42,39,-1,40,67,41,-1,40,107,67,-1,105,66,55,-1,68,66,105,-1,53,72,106,-1,53,36,72,-1,10,30,8,-1,10,31,30,-1,28,10,85,-1,28,31,10,-1,8,20,19,-1,8,30,20,-1,95,84,96,-1,95,81,84,-1,90,87,102,-1,87,90,89,-1,95,80,81,-1,80,95,100,-1,103,79,76,-1,103,116,79,-1,79,93,86,-1,116,93,79,-1,0,99,13,-1,99,0,3,-1,101,13,99,-1,13,101,117,-1,100,97,98,-1,100,95,97,-1,96,91,94,-1,96,92,91,-1,90,9,89,-1,90,7,9,-1,13,88,15,-1,13,117,88,-1,9,19,14,-1,9,8,19,-1,78,10,7,-1,78,85,10,-1,75,83,74,-1,83,75,77,-1,81,22,84,-1,81,6,22,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getsympubis_Coord_7_29_point_1()
		{
			double[] value = {-.15728,31.51432,.80751,-.16247,31.50874,.80494,-.18422,31.33514,.94405,-.17889,31.34173,.95583,-.23541,31.13523,.97592,-.25677,30.83095,.83181,-.29286,30.83308,.84181,-.13433,31.01219,.30976,-.14055,31.31111,.52821,-.13477,31.31632,.52063,-.13684,31.00485,.31924,-.07829,31.3036,.77842,-.15284,31.13412,.81233,-.0874,31.53004,.82643,-.1578,31.52513,.79519,-.093,31.54658,.79512,-.24447,30.45493,.2146,-.21322,30.63677,.20992,-.21212,30.36113,-.00127,-.16325,31.50993,.79279,-.15743,31.50468,.79846,-.25922,30.59584,.61806,-.29802,30.76537,.79867,-.29263,30.5747,.60866,-.17572,30.99448,.71196,-.19265,30.82974,.6313,-.2415,30.63841,.52053,-.13359,30.91201,.41984,-.16615,30.70783,.11365,-.10962,31.23079,.64406,-.13112,31.30626,.53752,-.11832,31.0046,.33876,.17889,31.34173,.95583,.16247,31.50874,.80494,.15728,31.51432,.80751,.18422,31.33514,.94405,.29286,30.83308,.84181,.25677,30.83095,.83181,.23541,31.13523,.97592,.13477,31.31632,.52063,.13684,31.00485,.31924,.13433,31.01219,.30976,.14055,31.31111,.52821,.1578,31.52513,.79519,.093,31.54658,.79512,.0874,31.53004,.82643,.21212,30.36113,-.00127,.21322,30.63677,.20992,.24447,30.45493,.2146,.15743,31.50468,.79846,.16325,31.50993,.79279,.29263,30.5747,.60866,.25922,30.59584,.61806,.29802,30.76537,.79867,.21793,30.38139,.26268,.24817,30.35629,.26539,.17572,30.99448,.71196,.15284,31.13412,.81233,.2415,30.63841,.52053,.13359,30.91201,.41984,.19265,30.82974,.6313,.16615,30.70783,.11365,.11832,31.0046,.33876,.13112,31.30626,.53752,.10962,31.23079,.64406,.07829,31.3036,.77842,.22417,30.31926,-.02266,.17557,30.70657,.08401,.22141,30.30641,-.04012,.09587,30.71738,.06296,.12208,30.29121,-.05835,.22966,31.13462,.98867,.29262,30.83317,.84672,-.21793,30.38139,.26268,-.24817,30.35629,.26539,-.22417,30.31926,-.02266,-.09587,30.71738,.06296,-.22141,30.30641,-.04012,-.17557,30.70657,.08401,-.12208,30.29121,-.05835,-.22966,31.13462,.98867,-.29262,30.83317,.84672,-.29182,30.56902,.61237,-.24581,30.34691,.26697,-.29783,30.7624,.80281,-.17919,30.70048,.09415,-.13117,30.3239,.27539,0.0,31.33512,.52028,0.0,31.55382,.80792,-.07561,31.33205,.50415,-.07498,31.02552,.29122,0.0,30.54844,.61299,-.15314,30.54963,.62808,0.0,30.31395,.24774,0.0,30.75284,.81434,-.15405,30.82632,.87068,-.15594,30.74694,.82247,0.0,30.82707,.86043,0.0,31.1464,1.01022,-.09888,31.3517,.97713};
			return value;
		}
		private double[] getsympubis_Coord_7_29_point_2()
		{
			double[] value = {-.12252,31.1279,1.01214,0.0,31.36356,.97494,0.0,31.01355,.29738,0.0,30.69089,.05788,.29182,30.56902,.61237,.24581,30.34691,.26697,.29783,30.7624,.80281,.17919,30.70048,.09415,.13117,30.3239,.27539,.07561,31.33205,.50415,.07498,31.02552,.29122,.15314,30.54963,.62808,.15405,30.82632,.87068,.15594,30.74694,.82247,.09888,31.3517,.97713,.12252,31.1279,1.01214,0.0,30.2705,-.07445,0.0,31.54396,.82164};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getcoccyx_Geo_6_34_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,9,13,-1,13,14,12,-1,15,16,17,-1,16,18,17,-1,19,20,21,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,30,33,31,-1,34,33,30,-1,34,35,33,-1,36,37,38,-1,36,39,37,-1,40,41,42,-1,41,43,42,-1,44,41,40,-1,44,45,41,-1,46,47,48,-1,46,49,47,-1,50,51,52,-1,52,53,50,-1,54,55,56,-1,56,57,54,-1,58,54,57,-1,58,59,54,-1,60,61,62,-1,60,63,61,-1,62,64,65,-1,62,61,64,-1,65,66,67,-1,65,64,66,-1,68,69,70,-1,70,71,68,-1,72,73,74,-1,72,75,73,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,80,83,81,-1,84,85,86,-1,84,87,85,-1,86,85,88,-1,88,89,86,-1,89,90,91,-1,89,88,90,-1,92,93,94,-1,92,95,93,-1,80,77,83,-1,80,78,77,-1,96,97,98,-1,97,99,98,-1,100,101,102,-1,102,103,100,-1,104,105,106,-1,107,108,109,-1,108,110,109,-1,111,112,113,-1,113,114,111,-1,115,116,117,-1,117,118,115,-1,119,120,121,-1,119,122,120,-1,123,124,125,-1,123,126,124,-1,27,127,128,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,133,17,134,-1,136,137,138,-1,139,140,141,-1,139,142,140,-1,143,144,145,-1,144,146,145,-1,59,147,148,-1,59,149,147,-1,150,151,66,-1,66,152,150,-1,153,154,155,-1,153,156,154,-1,157,158,159,-1,159,160,157,-1,114,161,162,-1,114,163,161,-1,164,165,166,-1,166,99,164,-1,167,168,169,-1,168,170,169,-1,171,160,172,-1,160,159,172,-1,173,174,175,-1,176,177,178,-1,178,179,176,-1,180,181,182,-1,180,15,181,-1,183,184,185,-1,183,186,184,-1,187,188,189,-1,187,190,188,-1,191,192,187,-1,187,189,191,-1,157,193,192,-1,192,194,157,-1,195,196,197,-1,197,198,195,-1,199,200,201,-1,201,202,199,-1,203,204,205,-1,205,124,203,-1,120,206,207,-1,120,125,206,-1,208,28,209,-1,208,26,28,-1,210,126,211,-1,210,212,126,-1,123,122,213,-1,213,214,123,-1,214,215,211,-1,214,216,215,-1,217,218,219,-1,220,221,222,-1,222,141,220,-1,223,224,225,-1,175,174,226,-1,226,227,175,-1,228,174,173,-1,173,229,228,-1,230,228,231,-1,228,232,231,-1,233,234,30,-1,234,34,30,-1,144,235,236,-1,144,143,235,-1,237,49,51,-1,51,238,237,-1,239,237,240,-1,237,241,240,-1,242,243,244,-1,244,245,242,-1,246,247,248,-1,248,249,246,-1,247,250,251,-1,251,252,247,-1,253,254,255,-1,255,256,253,-1,11,257,258,-1,11,116,257,-1,259,260,261,-1,259,118,260,-1,162,262,263,-1,263,264,162,-1,265,259,137,-1,259,138,137,-1,266,267,268,-1,266,269,267,-1,270,271,272,-1,273,274,275,-1,102,276,103,-1,102,277,276,-1,278,279,280,-1,279,281,280,-1,282,170,283,-1,283,284,282,-1,270,272,285,-1,285,286,270,-1,278,287,288,-1,287,219,288,-1,289,290,291,-1,290,292,291,-1,293,294,295,-1,295,296,293,-1,297,298,299,-1,297,300,298,-1,301,302,303,-1,304,268,305,-1,305,306,304,-1,307,100,165,-1,307,308,100,-1,256,309,302,-1,269,310,311,-1,312,167,98,-1,313,276,277,-1,277,5,313,-1,314,315,302,-1,302,309,314,-1,294,316,258,-1,294,315,316,-1,96,98,169,-1,98,167,169,-1,168,167,313,-1,317,318,319,-1,317,320,318,-1,321,136,322,-1,323,83,77,-1,77,324,323,-1,325,326,327,-1,327,328,325,-1,329,68,206,-1,68,207,206,-1,74,198,197,-1,197,72,74,-1,330,331,201,-1,331,332,201,-1,76,333,334,-1,76,78,333,-1,82,159,158,-1,158,80,82,-1,84,86,251,-1,86,252,251,-1,91,335,336,-1,336,89,91,-1,92,337,338,-1,92,94,337,-1,10,339,340,-1,341,55,20,-1,342,343,344,-1,344,345,342,-1,8,346,347,-1,8,7,346,-1,348,58,349,-1,57,350,349,-1,349,58,57,-1,65,67,351,-1,67,352,351,-1,60,62,353,-1,62,354,353,-1,355,356,357,-1,355,358,356,-1,359,360,361,-1,359,362,360,-1,363,364,365,-1,364,366,365,-1,367,368,369,-1,369,370,367,-1,48,371,372,-1,371,373,372,-1,374,375,376,-1,376,377,374,-1,378,379,380,-1,378,381,379,-1,382,383,384,-1,385,386,93,-1,386,387,93,-1,388,389,390,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_2()
		{
			int[] value = {389,391,390,-1,392,393,394,-1,393,395,394,-1,396,397,398,-1,397,399,398,-1,400,401,402,-1,400,403,401,-1,404,405,406,-1,405,407,406,-1,408,409,410,-1,409,411,410,-1,412,413,414,-1,415,416,417,-1,418,419,420,-1,421,422,423,-1,424,425,426,-1,427,428,429,-1,430,431,432,-1,430,433,431,-1,434,435,436,-1,436,437,434,-1,438,439,440,-1,440,441,438,-1,442,443,444,-1,444,445,442,-1,446,447,428,-1,428,427,446,-1,448,449,450,-1,451,452,422,-1,422,421,451,-1,416,415,453,-1,453,454,416,-1,455,424,456,-1,455,457,424,-1,458,442,459,-1,458,450,442,-1,460,459,461,-1,459,445,461,-1,462,463,464,-1,463,430,464,-1,465,466,467,-1,468,469,470,-1,469,446,470,-1,439,471,472,-1,472,440,439,-1,467,473,465,-1,467,474,473,-1,475,429,476,-1,475,427,429,-1,477,478,479,-1,477,480,478,-1,481,482,483,-1,482,484,480,-1,482,485,484,-1,486,487,488,-1,486,489,487,-1,490,491,492,-1,490,493,491,-1,494,495,496,-1,437,450,458,-1,497,412,498,-1,499,406,407,-1,499,500,406,-1,449,501,502,-1,449,503,501,-1,504,505,506,-1,504,507,505,-1,398,399,508,-1,399,509,508,-1,510,511,512,-1,511,513,512,-1,514,515,516,-1,515,517,516,-1,518,519,520,-1,518,521,519,-1,522,523,524,-1,522,525,523,-1,526,527,528,-1,527,529,528,-1,530,527,531,-1,531,532,530,-1,533,467,466,-1,466,534,533,-1,534,535,533,-1,534,536,535,-1,537,538,539,-1,537,540,538,-1,541,356,542,-1,541,536,356,-1,543,535,544,-1,543,545,535,-1,546,547,548,-1,549,550,551,-1,550,552,551,-1,553,554,555,-1,553,556,554,-1,557,558,559,-1,559,560,557,-1,561,562,563,-1,561,564,562,-1,565,566,567,-1,547,546,496,-1,546,494,496,-1,568,399,569,-1,568,509,399,-1,570,571,572,-1,571,573,572,-1,574,575,576,-1,530,577,578,-1,577,579,578,-1,555,580,581,-1,555,582,580,-1,583,584,585,-1,583,586,584,-1,587,588,501,-1,501,503,587,-1,553,555,589,-1,555,581,589,-1,515,514,590,-1,514,591,590,-1,511,592,593,-1,511,510,592,-1,594,432,431,-1,594,595,432,-1,539,596,597,-1,539,598,596,-1,599,600,492,-1,492,601,599,-1,342,108,602,-1,602,603,342,-1,107,604,605,-1,107,606,604,-1,456,417,416,-1,607,495,608,-1,396,609,397,-1,610,611,612,-1,610,613,611,-1,405,385,328,-1,405,386,385,-1,404,386,405,-1,404,614,386,-1,615,616,617,-1,617,618,615,-1,397,609,619,-1,619,620,397,-1,619,621,622,-1,622,620,619,-1,623,624,625,-1,623,626,624,-1,627,408,628,-1,627,409,408,-1,629,410,400,-1,629,630,410,-1,361,631,632,-1,632,366,361,-1,366,633,365,-1,366,632,633,-1,360,631,361,-1,360,634,631,-1,635,634,360,-1,635,636,634,-1,637,636,635,-1,637,638,636,-1,639,640,641,-1,639,642,640,-1,643,644,645,-1,178,646,647,-1,647,648,178,-1,649,650,651,-1,649,644,650,-1,645,652,653,-1,645,644,652,-1,652,654,523,-1,523,653,652,-1,380,655,656,-1,657,658,659,-1,658,660,659,-1,661,662,645,-1,519,662,661,-1,519,521,662,-1,663,664,665,-1,663,666,664,-1,667,500,499,-1,448,503,449,-1,448,414,503,-1,384,668,669,-1,384,383,668,-1,541,542,382,-1,670,671,672,-1,673,674,675,-1,676,537,677,-1,678,566,565,-1,679,674,673,-1,680,670,681,-1,414,498,412,-1,414,413,587,-1,587,503,414,-1,666,682,664,-1,666,683,682,-1,657,659,684,-1,685,686,687,-1,685,688,686,-1,689,541,382,-1,689,544,541,-1,690,32,31,-1,690,691,32,-1,654,691,690,-1,654,692,691,-1,644,693,650,-1,644,643,693,-1,694,651,650,-1,694,695,651,-1,696,562,695,-1,695,694,696,-1,697,562,696,-1,697,563,562,-1,646,698,699,-1,699,647,646,-1,700,48,47,-1,700,371,48,-1,701,367,702,-1,701,368,367,-1,703,704,368,-1,368,701,703,-1,705,704,703,-1,705,706,704,-1,707,706,705,-1,705,708,707,-1,63,709,580,-1,63,60,709,-1,580,710,581,-1,580,709,710,-1,581,362,589,-1,581,710,362,-1,711,363,712,-1,711,364,363,-1,712,707,708,-1,712,363,707,-1,411,403,410,-1,403,400,410,-1,713,714,715,-1,713,716,714,-1,717,718,719,-1,719,720,717,-1,721,622,621,-1,621,722,721,-1,609,393,723,-1,609,396,393,-1,723,392,724,-1,723,393,392,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_3()
		{
			int[] value = {724,389,725,-1,724,392,389,-1,387,94,93,-1,387,388,94,-1,721,722,719,-1,719,718,721,-1,441,570,572,-1,572,726,441,-1,452,727,728,-1,452,451,727,-1,557,577,558,-1,108,107,605,-1,605,602,108,-1,729,496,495,-1,729,730,496,-1,486,731,732,-1,732,489,486,-1,733,734,460,-1,733,735,734,-1,736,737,596,-1,596,598,736,-1,539,597,738,-1,738,537,539,-1,382,542,383,-1,129,638,130,-1,129,739,638,-1,682,740,741,-1,682,742,740,-1,594,743,595,-1,510,744,592,-1,744,745,592,-1,514,511,591,-1,511,593,591,-1,712,708,379,-1,708,746,379,-1,747,589,748,-1,747,553,589,-1,749,750,751,-1,749,752,750,-1,753,754,755,-1,753,756,754,-1,757,573,758,-1,757,572,573,-1,759,440,472,-1,759,760,440,-1,756,569,754,-1,756,568,569,-1,761,531,762,-1,559,561,560,-1,559,564,561,-1,763,178,648,-1,763,179,178,-1,764,765,766,-1,766,683,764,-1,656,767,768,-1,656,769,767,-1,770,769,771,-1,770,767,769,-1,772,753,771,-1,753,773,771,-1,774,549,775,-1,549,551,775,-1,199,585,200,-1,199,583,585,-1,776,777,778,-1,776,738,777,-1,596,401,779,-1,779,597,596,-1,544,536,541,-1,544,535,536,-1,539,780,598,-1,539,538,780,-1,534,466,357,-1,518,520,781,-1,520,745,781,-1,782,529,578,-1,762,531,526,-1,531,527,526,-1,762,783,761,-1,783,784,761,-1,783,785,786,-1,786,649,783,-1,787,788,692,-1,788,691,692,-1,789,590,591,-1,789,790,590,-1,514,516,513,-1,513,511,514,-1,791,792,700,-1,792,702,700,-1,791,239,793,-1,239,240,793,-1,794,795,796,-1,794,797,795,-1,798,799,504,-1,799,507,504,-1,508,798,398,-1,798,395,398,-1,444,667,490,-1,444,443,667,-1,498,436,435,-1,435,732,498,-1,486,800,801,-1,486,488,800,-1,481,802,485,-1,485,482,481,-1,488,595,743,-1,488,487,595,-1,483,482,480,-1,480,477,483,-1,457,455,803,-1,803,804,457,-1,805,469,806,-1,476,429,479,-1,807,727,808,-1,807,728,727,-1,809,810,671,-1,810,811,671,-1,471,812,472,-1,471,813,812,-1,469,805,446,-1,805,447,446,-1,465,810,466,-1,810,814,466,-1,735,462,815,-1,462,464,815,-1,734,434,437,-1,437,458,734,-1,733,460,816,-1,460,461,816,-1,445,459,442,-1,456,454,455,-1,456,416,454,-1,418,758,451,-1,451,421,418,-1,443,442,817,-1,804,431,433,-1,571,570,760,-1,808,675,807,-1,675,674,807,-1,449,442,450,-1,449,817,442,-1,437,436,448,-1,448,450,437,-1,464,430,432,-1,432,818,464,-1,570,441,440,-1,440,760,570,-1,759,675,760,-1,470,475,594,-1,405,328,407,-1,328,327,407,-1,623,779,401,-1,401,403,623,-1,714,716,551,-1,716,775,551,-1,628,585,584,-1,584,627,628,-1,717,552,819,-1,819,718,717,-1,622,755,754,-1,622,721,755,-1,393,396,395,-1,396,398,395,-1,389,392,391,-1,392,394,391,-1,94,388,337,-1,388,390,337,-1,617,609,723,-1,617,616,609,-1,412,820,821,-1,822,684,703,-1,342,603,343,-1,603,823,343,-1,670,672,824,-1,824,681,670,-1,363,365,707,-1,706,707,639,-1,707,365,639,-1,362,710,360,-1,710,635,360,-1,60,353,637,-1,637,709,60,-1,210,218,825,-1,210,826,218,-1,827,828,352,-1,352,67,827,-1,829,348,830,-1,348,349,830,-1,53,52,831,-1,52,832,831,-1,46,48,833,-1,48,372,833,-1,834,835,147,-1,147,836,834,-1,27,837,127,-1,385,93,95,-1,95,838,385,-1,91,92,335,-1,92,338,335,-1,86,89,252,-1,89,336,252,-1,71,839,207,-1,207,68,71,-1,325,840,326,-1,840,841,326,-1,842,843,844,-1,843,845,844,-1,846,847,69,-1,847,70,69,-1,10,9,12,-1,320,317,306,-1,307,848,849,-1,308,319,318,-1,850,851,852,-1,853,275,854,-1,855,856,311,-1,311,310,855,-1,294,258,257,-1,257,295,294,-1,857,169,858,-1,857,96,169,-1,302,301,256,-1,301,253,256,-1,285,854,286,-1,285,853,854,-1,316,315,314,-1,101,100,318,-1,100,308,318,-1,320,306,859,-1,306,305,859,-1,268,304,850,-1,850,266,268,-1,293,303,302,-1,302,315,293,-1,300,860,298,-1,860,857,298,-1,303,297,301,-1,297,299,301,-1,287,861,219,-1,272,862,285,-1,862,321,285,-1,858,170,282,-1,858,169,170,-1,861,287,863,-1,863,864,861,-1,322,273,275,-1,275,853,322,-1,262,865,263,-1,263,866,867,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_4()
		{
			int[] value = {867,264,263,-1,264,111,162,-1,111,114,162,-1,115,259,265,-1,115,118,259,-1,254,868,869,-1,869,870,254,-1,871,113,112,-1,294,293,315,-1,872,11,10,-1,873,326,841,-1,841,874,873,-1,314,875,844,-1,844,13,314,-1,249,876,877,-1,249,248,876,-1,878,251,250,-1,250,879,878,-1,143,142,880,-1,880,235,143,-1,515,144,517,-1,144,236,517,-1,221,220,881,-1,881,882,221,-1,883,884,885,-1,883,886,884,-1,887,888,889,-1,889,890,887,-1,227,226,891,-1,891,225,227,-1,227,892,175,-1,892,893,175,-1,894,219,861,-1,894,217,219,-1,211,123,214,-1,211,126,123,-1,28,128,825,-1,825,209,28,-1,895,26,208,-1,895,896,26,-1,897,898,899,-1,900,198,334,-1,900,195,198,-1,182,901,180,-1,182,902,901,-1,182,903,904,-1,182,181,903,-1,104,905,105,-1,905,906,105,-1,907,44,40,-1,40,908,907,-1,1,909,2,-1,171,172,878,-1,878,879,171,-1,910,284,911,-1,284,283,911,-1,312,98,166,-1,98,99,166,-1,912,913,914,-1,106,892,224,-1,224,915,106,-1,104,916,917,-1,917,905,104,-1,918,64,61,-1,61,919,918,-1,202,201,332,-1,332,920,202,-1,13,844,845,-1,845,14,13,-1,918,66,64,-1,918,152,66,-1,144,515,146,-1,515,590,146,-1,142,143,140,-1,143,145,140,-1,123,125,120,-1,120,122,123,-1,906,908,921,-1,921,922,906,-1,923,868,924,-1,923,925,868,-1,108,342,345,-1,345,110,108,-1,107,109,926,-1,926,606,107,-1,304,306,317,-1,927,928,112,-1,84,929,87,-1,930,931,323,-1,323,324,930,-1,838,328,385,-1,838,325,328,-1,932,325,838,-1,932,840,325,-1,933,842,934,-1,934,935,933,-1,87,929,936,-1,936,937,87,-1,937,82,81,-1,937,936,82,-1,938,939,940,-1,938,329,939,-1,846,330,847,-1,846,331,330,-1,630,71,70,-1,630,629,71,-1,941,828,830,-1,830,942,941,-1,942,349,943,-1,942,830,349,-1,944,828,941,-1,944,352,828,-1,945,351,352,-1,352,944,945,-1,131,351,945,-1,131,354,351,-1,130,354,131,-1,130,353,354,-1,946,947,948,-1,946,350,947,-1,36,885,39,-1,646,178,177,-1,177,949,646,-1,45,44,950,-1,950,949,45,-1,41,135,134,-1,134,43,41,-1,232,951,37,-1,37,39,232,-1,885,884,952,-1,952,39,885,-1,835,190,953,-1,954,19,955,-1,19,21,955,-1,883,885,956,-1,882,883,956,-1,882,881,883,-1,16,957,18,-1,16,958,957,-1,255,873,874,-1,9,316,13,-1,316,314,13,-1,837,959,960,-1,960,127,837,-1,28,27,128,-1,8,347,281,-1,4,313,5,-1,212,961,126,-1,305,270,859,-1,305,271,270,-1,127,212,128,-1,127,961,212,-1,962,959,837,-1,962,963,959,-1,309,255,874,-1,256,255,309,-1,882,957,958,-1,882,956,957,-1,36,956,885,-1,36,957,956,-1,18,134,17,-1,134,18,38,-1,955,964,954,-1,964,955,965,-1,953,25,966,-1,967,25,953,-1,22,967,193,-1,22,25,967,-1,968,965,955,-1,968,24,965,-1,246,964,969,-1,246,970,964,-1,971,21,20,-1,971,972,21,-1,973,147,835,-1,148,147,973,-1,224,974,975,-1,224,223,974,-1,952,34,231,-1,952,35,34,-1,232,952,231,-1,232,39,952,-1,43,951,42,-1,43,37,951,-1,177,45,949,-1,976,45,177,-1,646,950,698,-1,646,949,950,-1,51,46,52,-1,51,49,46,-1,53,55,50,-1,56,55,53,-1,151,67,66,-1,67,151,827,-1,829,149,348,-1,829,977,149,-1,827,977,829,-1,827,151,977,-1,59,348,149,-1,348,59,58,-1,330,978,847,-1,979,978,330,-1,72,846,75,-1,331,846,72,-1,74,79,76,-1,74,73,79,-1,843,980,981,-1,843,982,980,-1,842,982,843,-1,842,933,982,-1,95,91,90,-1,91,95,92,-1,166,276,312,-1,166,103,276,-1,110,7,6,-1,110,345,7,-1,983,984,985,-1,984,983,986,-1,983,987,986,-1,983,988,987,-1,989,3,990,-1,989,4,3,-1,991,99,97,-1,992,99,991,-1,868,993,869,-1,925,993,868,-1,927,260,994,-1,995,260,927,-1,296,300,297,-1,290,300,296,-1,922,105,906,-1,105,922,893,-1,908,42,921,-1,908,40,42,-1,996,944,997,-1,996,945,944,-1,998,942,999,-1,998,941,942,-1,1000,946,1001,-1,1000,943,946,-1,0,1000,1,-1,0,999,1000,-1,993,910,1002,-1,993,284,910,-1,282,923,858,-1,282,925,923,-1,161,262,162,-1,912,262,161,-1,1003,213,1004,-1,1005,213,1003,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_5()
		{
			int[] value = {120,839,121,-1,120,207,839,-1,1006,920,1007,-1,920,1006,202,-1,919,1008,918,-1,1008,919,1009,-1,1010,996,1011,-1,1010,132,996,-1,904,186,183,-1,904,903,186,-1,177,1012,976,-1,176,1012,177,-1,905,1013,907,-1,905,917,1013,-1,104,915,916,-1,104,106,915,-1,1014,1006,155,-1,1014,1015,1006,-1,1016,826,215,-1,1016,288,826,-1,971,59,148,-1,971,54,59,-1,1017,914,1018,-1,914,1017,865,-1,180,0,2,-1,180,901,0,-1,1019,871,1020,-1,897,871,1019,-1,23,879,1021,-1,23,171,879,-1,906,907,908,-1,906,905,907,-1,915,975,1022,-1,915,224,975,-1,917,1023,1024,-1,1023,917,916,-1,173,893,922,-1,893,173,175,-1,1013,1024,1025,-1,1013,917,1024,-1,921,951,229,-1,921,42,951,-1,181,1012,903,-1,1012,181,133,-1,909,16,2,-1,909,958,16,-1,904,902,182,-1,904,1011,902,-1,1026,132,1010,-1,1026,129,132,-1,63,919,61,-1,1027,919,63,-1,998,902,997,-1,901,902,998,-1,977,147,149,-1,836,147,977,-1,1028,152,1029,-1,1028,150,152,-1,1027,1009,919,-1,1009,1027,1030,-1,1031,1008,156,-1,1008,1031,1029,-1,1028,188,834,-1,1028,1032,188,-1,1033,1031,1034,-1,1033,1032,1031,-1,155,1035,1014,-1,155,154,1035,-1,1036,1034,1037,-1,1034,1036,1033,-1,22,171,23,-1,160,171,22,-1,900,1036,195,-1,900,191,1036,-1,196,1007,920,-1,196,1037,1007,-1,333,900,334,-1,194,900,333,-1,1038,959,1039,-1,960,959,1038,-1,896,897,1019,-1,897,896,898,-1,1040,896,895,-1,1040,898,896,-1,1004,1041,1003,-1,1042,1041,1004,-1,218,209,825,-1,218,217,209,-1,894,895,208,-1,894,1043,895,-1,161,1040,1044,-1,1040,161,163,-1,1044,1045,913,-1,1044,1043,1045,-1,1046,215,216,-1,1016,215,1046,-1,1003,606,926,-1,1003,1041,606,-1,279,1046,1047,-1,1016,1046,279,-1,1048,225,891,-1,223,225,1048,-1,1049,1048,233,-1,1049,1050,1048,-1,234,226,230,-1,234,891,226,-1,1051,888,887,-1,1051,1052,888,-1,890,884,886,-1,890,889,884,-1,38,957,36,-1,38,18,957,-1,1053,886,1054,-1,886,1053,890,-1,1055,887,1056,-1,1051,887,1055,-1,1057,1053,1058,-1,1057,1056,1053,-1,1059,881,220,-1,1054,881,1059,-1,222,909,1,-1,221,909,222,-1,140,1058,1059,-1,1058,140,145,-1,590,1057,146,-1,790,1057,590,-1,948,142,139,-1,142,948,880,-1,1060,55,341,-1,1060,50,55,-1,1061,1060,242,-1,1060,1061,238,-1,241,1062,1063,-1,241,1061,1062,-1,1064,244,970,-1,244,1064,245,-1,1065,1062,1066,-1,1062,1065,1063,-1,1067,1065,1068,-1,1067,1069,1065,-1,877,1064,249,-1,877,1066,1064,-1,244,19,954,-1,243,19,244,-1,1021,250,969,-1,1021,879,250,-1,1070,877,876,-1,877,1070,1068,-1,338,1071,1070,-1,1071,338,337,-1,335,248,336,-1,876,248,335,-1,963,1039,959,-1,963,1072,1039,-1,874,1073,309,-1,874,841,1073,-1,1074,326,873,-1,1074,327,326,-1,340,872,10,-1,340,1075,872,-1,258,9,11,-1,9,258,316,-1,1076,873,870,-1,873,1076,1074,-1,112,1020,871,-1,1020,112,928,-1,1075,117,872,-1,1075,994,117,-1,868,253,924,-1,254,253,868,-1,1077,870,869,-1,1076,870,1077,-1,115,1078,1079,-1,265,1078,115,-1,867,111,264,-1,867,995,111,-1,1080,867,866,-1,867,1080,261,-1,310,1081,992,-1,1081,269,266,-1,310,269,1081,-1,913,1018,914,-1,913,1045,1018,-1,866,865,1017,-1,263,865,866,-1,1080,273,138,-1,1080,274,273,-1,864,275,274,-1,864,863,275,-1,863,278,280,-1,863,287,278,-1,1047,6,8,-1,6,1047,1082,-1,347,990,3,-1,347,346,990,-1,988,343,987,-1,344,343,988,-1,97,289,991,-1,860,289,97,-1,168,283,170,-1,985,283,168,-1,136,862,311,-1,862,136,321,-1,992,855,310,-1,992,991,855,-1,97,857,860,-1,97,96,857,-1,266,852,1081,-1,266,850,852,-1,318,859,101,-1,859,318,320,-1,253,299,924,-1,301,299,253,-1,923,857,858,-1,298,857,923,-1,292,257,1079,-1,292,295,257,-1,1078,855,291,-1,855,1078,856,-1,853,321,322,-1,853,285,321,-1,850,317,851,-1,850,304,317,-1,308,849,319,-1,308,307,849,-1,852,849,848,-1,852,851,849,-1,339,837,27,-1,339,962,837,-1,73,1083,79,-1,940,1083,73,-1,846,938,75,-1,69,938,846,-1,847,630,70,-1,630,847,978,-1,982,81,980,-1,937,81,982,-1,204,939,205,-1,1084,939,204,-1,1039,930,1038,-1,931,930,1039,-1,981,845,843,-1,981,1072,845,-1,875,842,844,-1,934,842,875,-1,841,1085,1073,-1,840,1085,841,-1,71,1086,839,-1,71,629,1086,-1,172,929,878,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_6()
		{
			int[] value = {936,929,172,-1,85,933,935,-1,933,85,87,-1,838,90,932,-1,838,95,90,-1,52,833,832,-1,52,46,833,-1,53,947,56,-1,53,831,947,-1,828,829,830,-1,827,829,828,-1,128,210,825,-1,212,210,128,-1,288,218,826,-1,288,219,218,-1,677,668,383,-1,776,668,677,-1,637,710,709,-1,710,637,635,-1,704,639,641,-1,704,706,639,-1,823,681,824,-1,603,681,823,-1,725,1087,724,-1,614,1087,725,-1,617,724,1087,-1,617,723,724,-1,620,754,569,-1,620,622,754,-1,819,721,718,-1,721,819,755,-1,979,585,628,-1,979,200,585,-1,716,584,775,-1,716,627,584,-1,717,551,552,-1,717,714,551,-1,623,777,779,-1,623,625,777,-1,618,1088,502,-1,618,1089,1088,-1,501,1090,615,-1,1090,501,588,-1,612,1091,1092,-1,612,1093,1091,-1,610,778,1094,-1,610,1095,778,-1,619,616,1096,-1,619,609,616,-1,722,1097,611,-1,1097,722,621,-1,613,720,719,-1,613,1098,720,-1,713,624,626,-1,624,713,715,-1,1099,412,821,-1,412,1099,413,-1,426,423,417,-1,426,419,423,-1,447,674,428,-1,674,447,807,-1,1100,464,818,-1,815,464,1100,-1,816,600,599,-1,816,461,600,-1,675,571,760,-1,571,675,808,-1,804,468,431,-1,804,803,468,-1,758,420,757,-1,758,418,420,-1,757,425,1101,-1,420,425,757,-1,1102,816,438,-1,1102,733,816,-1,434,735,815,-1,734,735,434,-1,1103,675,759,-1,675,1103,673,-1,758,727,451,-1,758,573,727,-1,984,812,911,-1,984,1104,812,-1,757,1105,572,-1,757,1101,1105,-1,1106,824,1107,-1,824,1106,823,-1,671,679,672,-1,671,674,679,-1,805,807,447,-1,805,728,807,-1,605,680,602,-1,605,1108,680,-1,809,670,1109,-1,809,671,670,-1,811,429,428,-1,811,473,429,-1,803,469,468,-1,469,803,806,-1,475,743,594,-1,743,475,476,-1,1110,474,467,-1,474,1110,1111,-1,432,487,818,-1,595,487,432,-1,743,800,488,-1,800,743,478,-1,485,730,729,-1,485,802,730,-1,1112,800,484,-1,801,800,1112,-1,735,1102,462,-1,733,1102,735,-1,458,460,734,-1,458,459,460,-1,732,497,498,-1,497,732,731,-1,1113,608,1114,-1,608,1113,607,-1,493,667,499,-1,490,667,493,-1,1114,1115,820,-1,608,1115,1114,-1,817,502,1088,-1,817,449,502,-1,394,798,504,-1,798,394,395,-1,506,390,391,-1,506,1116,390,-1,1116,1067,1071,-1,1117,1067,1116,-1,798,1118,799,-1,508,1118,798,-1,1119,507,799,-1,1119,1120,507,-1,1121,1117,505,-1,1122,1117,1121,-1,1122,1123,1069,-1,1124,1123,1122,-1,797,1121,1120,-1,797,1125,1121,-1,1126,660,1127,-1,1126,659,660,-1,1128,797,794,-1,1128,1125,797,-1,793,1123,1124,-1,240,1123,793,-1,791,1128,792,-1,1128,791,793,-1,700,239,791,-1,239,700,47,-1,792,701,702,-1,792,1129,701,-1,745,1130,781,-1,745,744,1130,-1,591,377,789,-1,377,591,593,-1,592,520,374,-1,520,592,745,-1,663,518,567,-1,663,521,518,-1,1131,790,789,-1,1055,790,1131,-1,525,1131,376,-1,525,522,1131,-1,661,375,519,-1,661,1132,375,-1,645,1132,661,-1,1132,645,653,-1,1049,691,788,-1,1049,32,691,-1,785,692,786,-1,785,787,692,-1,649,784,783,-1,784,649,651,-1,762,785,783,-1,526,785,762,-1,528,788,787,-1,1133,788,528,-1,782,1050,1133,-1,782,974,1050,-1,1130,565,781,-1,565,1130,1134,-1,809,814,810,-1,814,809,1135,-1,605,1136,1108,-1,605,604,1136,-1,1136,1137,1138,-1,1137,1136,1139,-1,1140,467,533,-1,1140,1110,467,-1,574,1141,1142,-1,574,576,1141,-1,545,1141,1140,-1,545,1143,1141,-1,358,1144,540,-1,1144,358,355,-1,1139,538,1137,-1,1139,780,538,-1,736,1042,1145,-1,736,1146,1042,-1,737,1086,402,-1,737,1147,1086,-1,597,777,738,-1,597,779,777,-1,776,1095,668,-1,776,778,1095,-1,544,1148,543,-1,1148,544,689,-1,775,586,774,-1,586,775,584,-1,773,755,819,-1,755,773,753,-1,774,1149,549,-1,1149,774,1150,-1,770,773,550,-1,771,773,770,-1,756,772,688,-1,756,753,772,-1,1151,380,1152,-1,380,1151,655,-1,1149,767,770,-1,1149,1153,767,-1,752,1150,1154,-1,752,1155,1150,-1,749,1155,752,-1,1156,1155,749,-1,1157,767,1153,-1,768,767,1157,-1,656,378,380,-1,768,378,656,-1,556,1157,1156,-1,556,1158,1157,-1,751,1030,1159,-1,1035,1030,751,-1,378,747,381,-1,378,1158,747,-1,1160,1161,678,-1,1161,1160,1162,-1,1163,1164,1165,-1,1164,1163,1166,-1,583,1015,1167,-1,199,1015,583,-1,765,1161,1165,-1,765,764,1161,-1,1168,1026,185,-1,1026,1168,1169,-1,765,1170,766,-1,765,1171,1170,-1,683,566,764,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_7()
		{
			int[] value = {666,566,683,-1,742,683,766,-1,742,682,683,-1,184,763,1172,-1,184,179,763,-1,1173,742,1174,-1,742,1173,740,-1,698,1175,699,-1,1025,1175,698,-1,1176,784,1177,-1,761,784,1176,-1,1022,1178,1023,-1,1178,1022,579,-1,532,577,530,-1,532,558,577,-1,689,1115,1148,-1,1115,689,820,-1,1111,479,474,-1,1111,477,479,-1,813,911,812,-1,813,910,911,-1,730,547,496,-1,730,1179,547,-1,822,794,796,-1,822,1129,794,-1,684,705,703,-1,705,684,1180,-1,529,530,578,-1,527,530,529,-1,560,1178,557,-1,560,1181,1178,-1,561,699,1175,-1,561,563,699,-1,1170,763,1174,-1,1170,1172,763,-1,1164,1168,1171,-1,1164,1169,1168,-1,1159,749,751,-1,554,749,1159,-1,1154,750,752,-1,1154,1167,750,-1,1146,598,780,-1,598,1146,736,-1,604,1139,1136,-1,1139,604,1182,-1,813,601,1183,-1,601,813,471,-1,381,748,711,-1,381,747,748,-1,1152,1127,1151,-1,1127,1152,1126,-1,587,1091,588,-1,587,1184,1091,-1,642,744,640,-1,1130,744,642,-1,633,1160,1134,-1,1160,633,632,-1,631,1163,1162,-1,1163,631,634,-1,739,636,638,-1,739,1166,636,-1,820,382,821,-1,820,689,382,-1,537,776,677,-1,537,738,776,-1,1145,737,736,-1,1145,1147,737,-1,1177,559,1176,-1,564,559,1177,-1,548,1179,1143,-1,1179,548,547,-1,1100,732,435,-1,489,732,1100,-1,486,1113,731,-1,486,801,1113,-1,495,1112,729,-1,1112,495,607,-1,1002,491,1077,-1,1002,1183,491,-1,428,671,811,-1,428,674,671,-1,1185,1107,1103,-1,1185,1106,1107,-1,1103,1104,1185,-1,759,1104,1103,-1,453,728,805,-1,453,452,728,-1,483,574,481,-1,574,483,575,-1,1087,404,1089,-1,1087,614,404,-1,617,1089,618,-1,617,1087,1089,-1,1097,612,611,-1,612,1097,1093,-1,1094,613,610,-1,1094,1098,613,-1,624,1094,625,-1,624,1098,1094,-1,411,623,403,-1,411,626,623,-1,638,353,130,-1,353,638,637,-1,639,633,642,-1,365,633,639,-1,512,641,640,-1,641,512,369,-1,369,513,370,-1,369,512,513,-1,516,370,513,-1,370,516,373,-1,517,373,516,-1,373,517,372,-1,647,563,697,-1,563,647,699,-1,697,740,1173,-1,697,696,740,-1,741,696,694,-1,740,696,741,-1,694,693,741,-1,694,650,693,-1,654,524,523,-1,654,690,524,-1,1052,690,31,-1,524,690,1052,-1,1136,1109,1108,-1,1136,1138,1109,-1,1126,746,1180,-1,746,1126,1152,-1,684,796,657,-1,684,822,796,-1,1186,687,1187,-1,685,687,1186,-1,1151,687,686,-1,1151,1127,687,-1,658,1119,1188,-1,658,795,1119,-1,769,772,771,-1,772,769,1189,-1,1189,656,655,-1,1189,769,656,-1,1187,1118,1186,-1,1188,1118,1187,-1,1184,413,1099,-1,413,1184,587,-1,806,455,454,-1,455,806,803,-1,805,454,453,-1,454,805,806,-1,676,383,542,-1,383,676,677,-1,669,1099,384,-1,1099,669,1184,-1,667,817,500,-1,667,443,817,-1,665,521,663,-1,521,665,662,-1,662,643,645,-1,665,643,662,-1,741,664,682,-1,741,693,664,-1,1188,660,658,-1,1188,1187,660,-1,686,655,1151,-1,686,1189,655,-1,1189,688,772,-1,688,1189,686,-1,1187,1127,660,-1,687,1127,1187,-1,1188,799,1118,-1,799,1188,1119,-1,659,1180,684,-1,1126,1180,659,-1,379,1152,380,-1,379,746,1152,-1,974,578,975,-1,782,578,974,-1,692,652,786,-1,652,692,654,-1,652,649,786,-1,644,649,652,-1,697,648,647,-1,697,1173,648,-1,371,702,367,-1,702,371,700,-1,362,748,589,-1,362,359,748,-1,711,359,364,-1,748,359,711,-1,978,628,408,-1,978,979,628,-1,409,716,713,-1,409,627,716,-1,720,714,717,-1,715,714,720,-1,1097,1090,1093,-1,1096,1090,1097,-1,1096,615,1090,-1,616,615,1096,-1,389,387,725,-1,389,388,387,-1,808,573,571,-1,727,573,808,-1,681,602,680,-1,603,602,681,-1,984,1185,1104,-1,984,986,1185,-1,987,1185,986,-1,1185,987,1106,-1,679,1103,1107,-1,673,1103,679,-1,572,463,726,-1,572,1105,463,-1,1183,492,491,-1,1183,601,492,-1,801,607,1113,-1,801,1112,607,-1,558,1176,559,-1,558,532,1176,-1,695,564,1177,-1,564,695,562,-1,634,1166,1163,-1,1166,634,636,-1,632,1162,1160,-1,1162,632,631,-1,642,1134,1130,-1,1134,642,633,-1,1134,678,565,-1,678,1134,1160,-1,910,1183,1002,-1,1183,910,813,-1,599,471,439,-1,601,471,599,-1,481,1142,802,-1,481,574,1142,-1,780,1182,1146,-1,780,1139,1182,-1,402,596,737,-1,596,402,401,-1,586,1167,1154,-1,586,583,1167,-1,554,582,555,-1,554,1159,582,-1,1166,1169,1164,-1,1169,1166,739,-1,1172,1171,1168,-1,1170,1171,1172,-1,1174,648,1173,-1,1174,763,648,-1,1175,560,561,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_8()
		{
			int[] value = {560,1175,1181,-1,579,557,1178,-1,577,557,579,-1,1167,1014,750,-1,1015,1014,1167,-1,355,1135,1144,-1,814,1135,355,-1,708,1180,746,-1,1180,708,705,-1,1179,802,1142,-1,1179,730,802,-1,575,477,1111,-1,575,483,477,-1,678,764,566,-1,1161,764,678,-1,494,1148,1115,-1,494,546,1148,-1,509,685,1186,-1,568,685,509,-1,975,579,1022,-1,579,975,578,-1,1023,1181,1024,-1,1023,1178,1181,-1,532,761,1176,-1,532,531,761,-1,1024,1175,1025,-1,1181,1175,1024,-1,651,1177,784,-1,1177,651,695,-1,1174,766,1170,-1,1174,742,766,-1,666,567,566,-1,663,567,666,-1,1168,184,1172,-1,1168,185,184,-1,1165,1171,765,-1,1164,1171,1165,-1,739,1026,1169,-1,1026,739,129,-1,582,63,580,-1,582,1027,63,-1,1165,1162,1163,-1,1165,1161,1162,-1,379,711,712,-1,379,381,711,-1,553,1158,556,-1,747,1158,553,-1,1159,1027,582,-1,1159,1030,1027,-1,554,1156,749,-1,554,556,1156,-1,768,1158,378,-1,1157,1158,768,-1,1156,1153,1155,-1,1157,1153,1156,-1,1035,750,1014,-1,751,750,1035,-1,1155,1149,1150,-1,1155,1153,1149,-1,568,688,685,-1,568,756,688,-1,1149,550,549,-1,770,550,1149,-1,1154,774,586,-1,1150,774,1154,-1,550,819,552,-1,550,773,819,-1,669,1095,1092,-1,669,668,1095,-1,546,543,1148,-1,546,548,543,-1,543,1143,545,-1,548,1143,543,-1,540,676,358,-1,676,540,537,-1,1041,1146,1182,-1,1041,1042,1146,-1,1137,540,1144,-1,1137,538,540,-1,536,357,356,-1,357,536,534,-1,545,533,535,-1,533,545,1140,-1,1143,1142,1141,-1,1143,1179,1142,-1,1110,1141,576,-1,1141,1110,1140,-1,1144,1138,1137,-1,1144,1135,1138,-1,606,1182,604,-1,1041,1182,606,-1,1138,809,1109,-1,1138,1135,809,-1,529,1133,528,-1,529,782,1133,-1,1133,1049,788,-1,1050,1049,1133,-1,526,787,785,-1,528,787,526,-1,524,1051,522,-1,1051,524,1052,-1,653,525,1132,-1,525,653,523,-1,665,693,643,-1,693,665,664,-1,1132,376,375,-1,1132,525,376,-1,522,1055,1131,-1,522,1051,1055,-1,376,789,377,-1,1131,789,376,-1,519,374,520,-1,519,375,374,-1,567,781,565,-1,567,518,781,-1,377,592,374,-1,377,593,592,-1,510,640,744,-1,510,512,640,-1,703,1129,822,-1,1129,703,701,-1,1129,1128,794,-1,1129,792,1128,-1,1125,793,1124,-1,793,1125,1128,-1,795,1120,1119,-1,795,797,1120,-1,1125,1122,1121,-1,1125,1124,1122,-1,1122,1067,1117,-1,1069,1067,1122,-1,1120,505,507,-1,505,1120,1121,-1,657,795,658,-1,657,796,795,-1,508,1186,1118,-1,509,1186,508,-1,505,1116,506,-1,505,1117,1116,-1,1071,390,1116,-1,1071,337,390,-1,504,391,394,-1,504,506,391,-1,1092,1184,669,-1,1184,1092,1091,-1,1088,500,817,-1,500,1088,406,-1,407,1074,499,-1,1074,407,327,-1,497,820,412,-1,1114,820,497,-1,414,436,498,-1,414,448,436,-1,499,1076,493,-1,499,1074,1076,-1,1115,495,494,-1,1115,608,495,-1,731,1114,497,-1,1114,731,1113,-1,444,492,600,-1,444,490,492,-1,493,1077,491,-1,493,1076,1077,-1,818,489,1100,-1,818,487,489,-1,729,484,485,-1,1112,484,729,-1,484,478,480,-1,484,800,478,-1,1101,433,1105,-1,804,1101,457,-1,804,433,1101,-1,1111,576,575,-1,1110,576,1111,-1,476,478,743,-1,479,478,476,-1,429,474,479,-1,474,429,473,-1,810,473,811,-1,465,473,810,-1,680,1109,670,-1,680,1108,1109,-1,1107,672,679,-1,672,1107,824,-1,343,1106,987,-1,343,823,1106,-1,462,726,463,-1,462,1102,726,-1,812,759,472,-1,812,1104,759,-1,468,594,431,-1,468,470,594,-1,430,1105,433,-1,463,1105,430,-1,438,726,1102,-1,726,438,441,-1,425,457,1101,-1,457,425,424,-1,453,422,452,-1,453,415,422,-1,461,444,600,-1,461,445,444,-1,438,599,439,-1,438,816,599,-1,435,815,1100,-1,434,815,435,-1,470,427,475,-1,427,470,446,-1,417,424,426,-1,456,424,417,-1,419,421,423,-1,418,421,419,-1,419,425,420,-1,426,425,419,-1,417,422,415,-1,417,423,422,-1,384,821,382,-1,821,384,1099,-1,1098,715,720,-1,1098,624,715,-1,626,409,713,-1,626,411,409,-1,630,408,410,-1,630,978,408,-1,719,611,613,-1,611,719,722,-1,621,1096,1097,-1,621,619,1096,-1,625,778,777,-1,625,1094,778,-1,610,1092,1095,-1,610,612,1092,-1,588,1093,1090,-1,1093,588,1091,-1,615,502,501,-1,615,618,502,-1,1089,406,1088,-1,1089,404,406,-1,1086,400,402,-1,629,400,1086,-1,397,569,399,-1,397,620,569,-1,725,386,614,-1,386,725,387,-1,373,367,370,-1,371,367,373,-1,641,368,704,-1,368,641,369,-1,364,361,366,-1,364,359,361,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_9()
		{
			int[] value = {358,542,356,-1,358,676,542,-1,357,814,355,-1,814,357,466,-1,960,961,127,-1,960,203,961,-1,65,354,62,-1,65,351,354,-1,350,56,947,-1,57,56,350,-1,1058,1054,1059,-1,1054,1058,1053,-1,7,344,346,-1,7,345,344,-1,1190,90,88,-1,1190,932,90,-1,88,935,1190,-1,935,88,85,-1,929,251,878,-1,929,84,251,-1,159,936,172,-1,82,936,159,-1,80,333,78,-1,80,158,333,-1,201,979,330,-1,979,201,200,-1,332,72,197,-1,331,72,332,-1,198,76,334,-1,74,76,198,-1,205,329,206,-1,939,329,205,-1,1073,934,875,-1,1085,934,1073,-1,1072,931,1039,-1,981,931,1072,-1,204,930,1084,-1,930,204,1038,-1,933,937,982,-1,87,937,933,-1,980,83,323,-1,980,81,83,-1,79,324,77,-1,1083,324,79,-1,940,75,938,-1,940,73,75,-1,10,962,339,-1,10,12,962,-1,319,851,317,-1,851,319,849,-1,5,286,854,-1,5,277,286,-1,291,1079,1078,-1,291,292,1079,-1,924,298,923,-1,299,298,924,-1,312,313,167,-1,312,276,313,-1,862,269,311,-1,267,269,862,-1,848,165,164,-1,165,848,307,-1,852,164,1081,-1,852,848,164,-1,290,295,292,-1,290,296,295,-1,991,291,855,-1,991,289,291,-1,313,989,168,-1,313,4,989,-1,103,165,100,-1,166,165,103,-1,283,984,911,-1,984,283,985,-1,992,164,99,-1,1081,164,992,-1,346,988,990,-1,346,344,988,-1,3,281,347,-1,5,281,3,-1,277,270,286,-1,102,270,277,-1,6,109,110,-1,109,6,1082,-1,8,279,1047,-1,281,279,8,-1,275,280,854,-1,280,275,863,-1,272,267,862,-1,272,271,267,-1,138,322,136,-1,138,273,322,-1,1080,1017,274,-1,866,1017,1080,-1,864,1045,861,-1,864,1018,1045,-1,265,856,1078,-1,265,137,856,-1,261,138,259,-1,261,1080,138,-1,261,995,867,-1,261,260,995,-1,860,290,289,-1,860,300,290,-1,297,293,296,-1,303,293,297,-1,872,116,11,-1,872,117,116,-1,928,994,1075,-1,928,927,994,-1,255,870,873,-1,255,254,870,-1,1020,1075,340,-1,1020,928,1075,-1,875,309,1073,-1,314,309,875,-1,247,336,248,-1,247,252,336,-1,338,876,335,-1,1070,876,338,-1,1067,1070,1071,-1,1067,1068,1070,-1,969,247,246,-1,969,250,247,-1,249,970,246,-1,1064,970,249,-1,1068,1066,877,-1,1068,1065,1066,-1,1123,1065,1069,-1,1123,1063,1065,-1,1066,245,1064,-1,245,1066,1062,-1,955,972,968,-1,21,972,955,-1,245,1061,242,-1,1062,1061,245,-1,1123,241,1063,-1,1123,240,241,-1,1061,237,238,-1,1061,241,237,-1,239,49,237,-1,239,47,49,-1,50,238,51,-1,1060,238,50,-1,1001,141,222,-1,141,1001,139,-1,1058,146,1057,-1,1058,145,146,-1,220,140,1059,-1,220,141,140,-1,221,958,909,-1,882,958,221,-1,790,1056,1057,-1,790,1055,1056,-1,1056,890,1053,-1,890,1056,887,-1,1054,883,881,-1,886,883,1054,-1,30,1049,233,-1,1049,30,32,-1,34,230,231,-1,234,230,34,-1,229,232,228,-1,229,951,232,-1,230,174,228,-1,230,226,174,-1,233,891,234,-1,233,1048,891,-1,1050,223,1048,-1,974,223,1050,-1,1,1001,222,-1,1,1000,1001,-1,288,279,278,-1,288,1016,279,-1,1191,109,1082,-1,109,1191,926,-1,216,1191,1046,-1,216,1005,1191,-1,861,1043,894,-1,1045,1043,861,-1,1044,912,161,-1,912,1044,913,-1,1044,895,1043,-1,895,1044,1040,-1,217,208,209,-1,217,894,208,-1,215,210,211,-1,215,826,210,-1,214,1005,216,-1,213,1005,214,-1,1042,119,1145,-1,119,1042,1004,-1,1086,121,839,-1,1147,121,1086,-1,205,125,124,-1,125,205,206,-1,1038,203,960,-1,203,1038,204,-1,1019,26,896,-1,1019,29,26,-1,920,197,196,-1,920,332,197,-1,158,194,333,-1,158,157,194,-1,1036,196,195,-1,1036,1037,196,-1,194,191,900,-1,194,192,191,-1,193,160,22,-1,160,193,157,-1,835,966,973,-1,835,953,966,-1,189,1036,191,-1,1033,1036,189,-1,1037,153,1007,-1,153,1037,1034,-1,1034,156,153,-1,1034,1031,156,-1,189,1032,1033,-1,189,188,1032,-1,834,190,835,-1,834,188,190,-1,1032,1029,1031,-1,1029,1032,1028,-1,1030,154,1009,-1,1030,1035,154,-1,1029,918,1008,-1,1029,152,918,-1,150,834,836,-1,834,150,1028,-1,901,999,0,-1,901,998,999,-1,1011,997,902,-1,1011,996,997,-1,1015,202,1006,-1,1015,199,202,-1,1026,183,185,-1,1026,1010,183,-1,2,15,180,-1,2,16,15,-1,15,133,181,-1,17,133,15,-1,176,184,186,-1,179,184,176,-1,133,976,1012,-1,133,135,976,-1,1013,698,950,-1,1013,1025,698,-1,229,922,921,-1,229,173,922,-1};
			return value;
		}
		private int[] getcoccyx_Geo_6_34_coordIndex_10()
		{
			int[] value = {916,1022,1023,-1,916,915,1022,-1,106,893,892,-1,893,106,105,-1,1020,29,1019,-1,1020,340,29,-1,897,113,871,-1,897,899,113,-1,274,1018,864,-1,1017,1018,274,-1,899,114,113,-1,114,899,163,-1,242,341,243,-1,1060,341,242,-1,54,20,55,-1,54,971,20,-1,892,225,224,-1,892,227,225,-1,950,907,1013,-1,907,950,44,-1,176,903,1012,-1,903,176,186,-1,183,1011,904,-1,1011,183,1010,-1,156,1009,154,-1,156,1008,1009,-1,155,1007,153,-1,1007,155,1006,-1,122,1004,213,-1,122,119,1004,-1,1005,926,1191,-1,1005,1003,926,-1,925,284,993,-1,925,282,284,-1,151,836,977,-1,150,836,151,-1,968,973,966,-1,968,972,973,-1,137,311,856,-1,137,136,311,-1,1072,14,845,-1,963,14,1072,-1,139,946,948,-1,139,1001,946,-1,999,943,1000,-1,999,942,943,-1,997,941,998,-1,997,944,941,-1,945,132,131,-1,996,132,945,-1,27,340,339,-1,29,340,27,-1,203,126,961,-1,126,203,124,-1,121,1145,119,-1,1145,121,1147,-1,163,898,1040,-1,163,899,898,-1,116,1079,257,-1,116,115,1079,-1,994,118,117,-1,260,118,994,-1,995,112,111,-1,995,927,112,-1,869,1002,1077,-1,993,1002,869,-1,281,854,280,-1,5,854,281,-1,990,983,989,-1,983,990,988,-1,985,989,983,-1,985,168,989,-1,102,859,270,-1,859,102,101,-1,912,865,262,-1,912,914,865,-1,840,1190,1085,-1,1190,840,932,-1,1085,935,934,-1,935,1085,1190,-1,931,980,323,-1,931,981,980,-1,324,1084,930,-1,1083,1084,324,-1,1084,940,939,-1,940,1084,1083,-1,329,69,68,-1,69,329,938,-1,943,350,946,-1,943,349,350,-1,947,880,948,-1,947,831,880,-1,235,831,832,-1,880,831,235,-1,832,236,235,-1,832,833,236,-1,833,517,236,-1,833,372,517,-1,135,45,976,-1,45,135,41,-1,38,43,134,-1,43,38,37,-1,889,952,884,-1,952,889,35,-1,888,35,889,-1,35,888,33,-1,33,1052,31,-1,33,888,1052,-1,1047,1191,1082,-1,1191,1047,1046,-1,148,972,971,-1,148,973,972,-1,243,20,19,-1,341,20,243,-1,24,1021,965,-1,24,23,1021,-1,24,966,25,-1,968,966,24,-1,970,954,964,-1,244,954,970,-1,193,187,192,-1,193,967,187,-1,190,967,953,-1,187,967,190,-1,969,965,1021,-1,969,964,965,-1,12,963,962,-1,12,14,963,-1,268,271,305,-1,268,267,271,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getcoccyx_Coord_7_34_point_1()
		{
			double[] value = {-.28921,30.29935,-2.84002,-.31384,30.22245,-2.86205,-.30326,30.26881,-2.79749,-.3206,31.21421,-3.51363,-.3198,31.19294,-3.56899,-.41429,31.19785,-3.54175,-.18665,31.27077,-3.34611,-.18918,31.23288,-3.38181,-.30771,31.23961,-3.37251,-.50858,30.77054,-3.37924,-.68185,30.87913,-3.43763,-.58431,30.8482,-3.45605,-.54356,30.78476,-3.36199,-.48995,30.69074,-3.35277,-.52459,30.71591,-3.31331,-.26454,30.26217,-2.74475,-.2816,30.22587,-2.75714,-.2403,30.23764,-2.65052,-.24773,30.19564,-2.66703,-.29144,30.23039,-3.03614,-.27034,30.19241,-2.97595,-.30848,30.25105,-3.01668,-.46635,30.50912,-3.06943,-.45764,30.46278,-3.10655,-.41074,30.42059,-3.07694,-.4245,30.46028,-3.03767,-.79901,31.07039,-3.402,-.69404,30.9703,-3.32973,-.68826,31.01159,-3.31981,-.82203,31.01577,-3.40891,-.06161,30.09323,-2.61254,0.0,30.11943,-2.62035,0.0,30.09568,-2.61567,-.06179,30.11158,-2.62126,-.13831,30.09542,-2.61773,-.13839,30.11491,-2.62161,-.22659,30.13679,-2.6301,-.21053,30.17325,-2.59706,-.22704,30.18194,-2.60871,-.19301,30.13298,-2.6128,-.19631,30.23301,-2.56008,-.20221,30.22812,-2.57552,-.2109,30.20279,-2.57189,-.21018,30.19533,-2.58931,-.16212,30.26426,-2.55077,-.16569,30.25731,-2.5688,-.09186,30.21471,-2.96563,0.0,30.21308,-2.98353,0.0,30.21579,-2.96945,-.08589,30.21792,-2.97806,-.19478,30.19708,-2.97036,-.14525,30.20783,-2.97819,-.15294,30.20487,-2.96807,-.20062,30.19839,-2.95411,-.25225,30.21898,-2.93521,-.22412,30.19708,-2.95821,-.22483,30.20067,-2.94526,-.2454,30.2242,-2.92698,-.25336,30.27768,-2.9044,-.25972,30.26885,-2.90985,0.0,30.43314,-2.87921,-.08649,30.43343,-2.88364,-.08677,30.41949,-2.88345,0.0,30.44749,-2.88334,-.16018,30.42278,-2.87809,-.15971,30.41148,-2.88215,-.2038,30.39991,-2.8761,-.2041,30.38753,-2.8762,-.15068,30.77327,-3.07839,-.15577,30.76602,-3.0805,-.08052,30.77166,-3.06543,-.07792,30.77993,-3.05926,-.23262,30.75043,-3.06238,-.33249,30.7335,-3.10671,-.33579,30.72858,-3.09943,-.23571,30.7494,-3.08551,-.39449,30.70077,-3.12471,-.42088,30.68793,-3.149,-.43653,30.67977,-3.13977,-.38579,30.71117,-3.13393,-.47212,30.65764,-3.16963,-.47379,30.64281,-3.20386,-.48335,30.63216,-3.19864,-.45632,30.66191,-3.17849,-.46198,30.58765,-3.28358,-.40896,30.60481,-3.29702,-.40362,30.58549,-3.30859,-.45584,30.6009,-3.2725,-.30624,30.61367,-3.30237,-.30414,30.58285,-3.33138,-.21344,30.62309,-3.31066,-.21558,30.58679,-3.33262,-.1112,30.58481,-3.32972,0.0,30.61337,-3.32116,0.0,30.58793,-3.33102,-.11117,30.61247,-3.31167,-.33025,31.03343,-3.72392,-.36279,31.02339,-3.77839,-.34613,31.11435,-3.75953,-.35985,31.09873,-3.82747};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_2()
		{
			double[] value = {-.36195,31.23455,-3.77677,-.40674,31.25921,-3.75589,-.41508,31.19827,-3.70866,-.34158,31.18966,-3.72909,-.10003,30.1826,-2.37069,-.11722,30.15387,-2.37566,-.09357,30.15543,-2.3558,0.0,31.20388,-3.27394,0.0,31.22498,-3.32304,-.0986,31.26764,-3.27669,-.09887,31.25991,-3.33729,-1.01425,31.14417,-3.66096,-1.01723,31.1025,-3.60401,-1.10093,31.14364,-3.58169,-1.10553,31.1958,-3.62424,-.59993,30.98305,-3.63759,-.60026,30.92512,-3.56913,-.72396,30.97109,-3.60128,-.71853,31.02682,-3.64884,-.07525,30.86242,-3.06788,-.14633,30.82019,-3.06613,-.07536,30.82334,-3.05931,-.1455,30.86292,-3.08244,-.23125,30.8678,-3.12695,-.33785,30.81953,-3.13126,-.23232,30.81904,-3.09713,-.34176,30.88539,-3.15818,-.50463,30.87851,-3.21875,-.5596,30.93612,-3.26686,0.0,30.42901,-2.84629,0.0,30.44195,-2.86728,-.08785,30.42724,-2.86614,-.08882,30.42745,-2.84172,-.21559,30.26972,-2.63701,-.22387,30.21504,-2.59719,-.21065,30.23886,-2.5855,-.573,31.12854,-3.73836,-.57503,31.09585,-3.74112,-.68917,31.16508,-3.73618,-.25444,30.16673,-2.92941,-.23449,30.13171,-2.92759,-.27122,30.14436,-2.90449,-.22067,30.15434,-2.94463,-.16738,30.16168,-2.95728,-.09046,30.15752,-2.96748,-.1663,30.14491,-2.9418,-.08678,30.14199,-2.94591,-.29372,30.32477,-2.89127,-.29354,30.26951,-2.91764,-.25426,30.30451,-2.89947,-.24468,30.39361,-2.87849,-.23434,30.37789,-2.88015,-.205,30.41798,-2.87981,-.15655,30.59302,-2.97037,-.07834,30.55047,-2.9453,-.07945,30.60362,-2.97362,-.15563,30.54506,-2.93403,-.49972,30.60983,-3.10022,-.47852,30.65299,-3.16098,-.48787,30.62626,-3.19063,-.50116,30.58224,-3.13502,-1.08931,31.26802,-3.6154,-1.09323,31.25015,-3.66908,-1.09319,31.21342,-3.57382,-.3632,31.16978,-3.85823,-.35643,31.19696,-3.82502,-.33774,31.15389,-3.77301,-.31643,31.11597,-3.73402,-.21171,31.14444,-3.65639,-.30983,31.03679,-3.70101,-.22784,31.03287,-3.672,-.49498,30.55556,-3.17992,-.49087,30.60405,-3.21995,-.16445,30.11431,-2.48815,-.1527,30.08123,-2.50167,-.12743,30.07622,-2.40963,-.08362,30.32468,-2.63487,-.08217,30.28531,-2.58068,0.0,30.30401,-2.58035,0.0,30.33118,-2.63531,-.28464,30.30714,-2.78098,-.22523,30.31103,-2.72246,-.23255,30.35557,-2.76508,-.0918,30.40411,-2.75776,0.0,30.37022,-2.70846,0.0,30.39793,-2.76573,-.0941,30.36791,-2.70864,-.40256,30.5176,-2.98839,-.33181,30.49239,-2.94133,-.35669,30.5339,-2.97624,-.36284,30.4611,-2.95851,-.39926,30.5958,-2.9899,-.44846,30.57358,-3.01464,-.46468,30.5516,-3.03524,-.47205,30.62976,-3.0749,-.34156,30.68802,-3.02842,-.24212,30.70512,-3.02359,-.2339,30.74115,-3.04872,-.33777,30.72418,-3.08327,0.0,30.72877,-3.0257};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_3()
		{
			double[] value = {0.0,30.75623,-3.03627,-.07848,30.75071,-3.03948,-.07773,30.72819,-3.02206,-.41555,30.81286,-3.16047,-.40315,30.75392,-3.14154,-.33063,30.77099,-3.10717,-.22981,30.78814,-3.08724,-.14747,30.79479,-3.06611,-.77898,31.1241,-3.40036,-.66709,31.07033,-3.33068,-.47434,30.99922,-3.24069,-.35723,30.96502,-3.19906,-.43803,30.9115,-3.2049,-.15997,30.93915,-3.12121,-.25653,30.9478,-3.15619,-.3945,31.05094,-3.22612,-.28128,31.03395,-3.19127,-.6559,31.1299,-3.34429,-.62955,31.11623,-3.32657,-.64808,31.20402,-3.37282,-.27526,30.12039,-2.85177,-.30375,30.14249,-2.83962,-.30894,30.15662,-2.88523,-.04463,30.07802,-2.38629,-.04248,30.11582,-2.3517,-.07249,30.07598,-2.39477,-.14105,30.07285,-2.50766,-.10654,30.07043,-2.4044,-.20435,30.0844,-2.56235,-.2106,30.13083,-2.5472,-.17921,30.06466,-2.56712,-.19932,30.08758,-2.61752,-.21246,30.11619,-2.60438,-.06244,30.0728,-2.55496,-.12697,30.06697,-2.56261,-.15975,30.17633,-2.97055,-.09062,30.17533,-2.9727,-.09166,30.21435,-3.0143,-.15083,30.19901,-3.01329,0.0,30.2126,-3.01867,0.0,30.24836,-3.07953,-.09972,30.24078,-3.07808,-.20424,30.21666,-3.06596,-.25792,30.21936,-3.05319,-.27509,30.27917,-3.10837,-.21409,30.2855,-3.11507,-.33286,30.38892,-3.21781,-.386,30.49813,-3.30518,-.28548,30.49367,-3.32929,-.24824,30.4005,-3.23093,-.44097,30.51103,-3.26679,-.464,30.57963,-3.28245,-.40137,30.57681,-3.31126,-.33201,30.76978,-3.47286,-.24929,30.75465,-3.48271,-.23696,30.69497,-3.42402,-.34273,30.70714,-3.43253,-.51736,30.88697,-3.55874,-.49541,30.79614,-3.4811,-.71009,31.09134,-3.70353,-.807,31.06735,-3.6634,-.79251,31.13549,-3.70391,-1.07652,31.31096,-3.69956,-1.00068,31.28465,-3.74269,-1.00714,31.21072,-3.69787,-.5973,31.03616,-3.69879,-.49961,31.21777,-3.83676,-.53672,31.21086,-3.7599,-.51113,31.25694,-3.78836,-.51713,31.16536,-3.79955,-.48299,31.21038,-3.70298,-.52375,31.22735,-3.72373,-.54112,31.1926,-3.69141,-.67523,31.20562,-3.67144,-.75515,31.24989,-3.64631,-.65111,31.20999,-3.59889,-.33218,31.17333,-3.67924,-.41283,31.15651,-3.64643,-.54118,31.24194,-3.38027,-.41202,31.22433,-3.33612,-.53478,31.22615,-3.44351,-.41583,31.22781,-3.40037,-.2409,30.96051,-3.64065,-.13524,31.04292,-3.66399,-.14584,30.9448,-3.64907,-.55103,31.18966,-3.67855,-.50009,31.1644,-3.64065,-.64387,31.24383,-3.42265,-.53875,31.18287,-3.32362,-.48017,30.97632,-3.72918,-.4658,30.91879,-3.66079,-.51521,31.00533,-3.7109,-.516,30.95073,-3.64531,-.44114,30.77469,-3.50024,-.47578,30.78908,-3.49475,-.49427,30.8825,-3.56475,-.45944,30.85361,-3.57831,-.37255,30.82642,-3.57585,-.33645,30.9014,-3.60657,-.34111,30.84471,-3.53617};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_4()
		{
			double[] value = {-.37793,30.89775,-3.64454,-.34403,30.76909,-3.47648,-.36024,30.71634,-3.44112,-.36913,30.76268,-3.49908,-.49952,31.26302,-3.7907,-.50334,31.2682,-3.76173,-.48859,31.26531,-3.76977,-.36553,31.20414,-3.83101,-.3723,31.23611,-3.7864,-.34455,30.6665,-3.39161,-.51441,31.14675,-3.79838,-.53855,31.11541,-3.74907,-.33499,31.13829,-3.7472,-.31892,31.17149,-3.64941,-.42666,30.66869,-3.37774,-.43864,30.73833,-3.41999,-.45693,30.73826,-3.40644,-.46303,31.2673,-3.78705,-.4099,31.26232,-3.7677,-.40861,31.25626,-3.78521,-.46814,31.27003,-3.76708,-.57037,31.17837,-3.70929,-.62272,31.19177,-3.67746,-.45734,30.67514,-3.18351,-.41893,30.70211,-3.15455,-.10972,30.6218,-3.33324,-.10881,30.62658,-3.34672,0.0,30.61381,-3.34768,0.0,30.62109,-3.33241,-.23197,30.77446,-3.08828,-.07905,30.7614,-3.05167,-.15321,30.75595,-3.04835,-.1534,30.74817,-3.03427,-.44666,30.67354,-3.13253,-.39774,30.69572,-3.11581,-.21533,30.57263,-3.33611,-.30411,30.57048,-3.33716,0.0,30.57151,-3.33721,-.11146,30.56924,-3.32983,-.6893,30.90901,-3.39267,-.82407,30.9694,-3.46982,-.23845,30.18926,-3.00415,0.0,31.2138,-3.35419,0.0,31.20915,-3.36853,-.1015,31.22136,-3.38225,-.10083,31.22829,-3.3696,-.19006,31.22575,-3.39424,-.30887,31.23815,-3.38733,-.25197,30.28628,-2.90218,-.25422,30.27892,-2.90085,-.24541,30.22296,-2.9251,-.15917,30.40966,-2.87946,-.20356,30.38521,-2.87502,0.0,30.43235,-2.87567,-.08703,30.41782,-2.88028,.51036,31.08312,-3.26413,.59827,31.04056,-3.29109,.62955,31.11623,-3.32657,.47434,30.99922,-3.24069,.2318,30.36641,-2.88109,.20356,30.38521,-2.87502,.23169,30.36524,-2.87893,.2041,30.38753,-2.8762,.25197,30.28628,-2.90218,.2406,30.33474,-2.89069,.25422,30.27892,-2.90085,.24072,30.33372,-2.88824,.15294,30.20487,-2.96807,.20062,30.19839,-2.95411,.20022,30.19668,-2.95259,.15418,30.19222,-2.96979,.09186,30.21471,-2.96563,0.0,30.19849,-2.96976,.09021,30.19384,-2.97136,.23622,30.10806,-2.86971,.2282,30.11304,-2.80332,.15787,30.11655,-2.81628,.16523,30.12138,-2.88644,.30558,30.43692,-2.90647,.29372,30.32477,-2.89127,.3312,30.39864,-2.92504,.26896,30.36491,-2.88399,.69404,30.9703,-3.32973,.50463,30.87851,-3.21875,.54146,30.8688,-3.24917,0.0,30.61259,-3.32008,.11073,30.62,-3.31544,.11117,30.61247,-3.31167,.1112,30.58481,-3.32972,.21558,30.58679,-3.33262,.11146,30.56924,-3.32983,.21533,30.57263,-3.33611,.30414,30.58285,-3.33138,.40362,30.58549,-3.30859,.30411,30.57048,-3.33716,.40137,30.57681,-3.31126,.46198,30.58765,-3.28358,.48034,30.59374,-3.26709,.464,30.57963,-3.28245,.48338,30.58508,-3.26156};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_5()
		{
			double[] value = {.07792,30.77993,-3.05926,.14747,30.79479,-3.06611,.08085,30.79593,-3.05647,.15068,30.77327,-3.07839,.21568,30.6234,-3.338,.10972,30.6218,-3.33324,.21569,30.6318,-3.35265,.10881,30.62658,-3.34672,.07944,30.76552,-3.06271,.1556,30.75846,-3.07522,.08052,30.77166,-3.06543,.15577,30.76602,-3.0805,.68185,30.87913,-3.43763,.54356,30.78476,-3.36199,.50858,30.77054,-3.37924,.46814,31.27003,-3.76708,.48859,31.26531,-3.76977,.46303,31.2673,-3.78705,.36553,31.20414,-3.83101,.39891,31.21354,-3.84375,.36974,31.18335,-3.85653,.3723,31.23611,-3.7864,.4099,31.26232,-3.7677,.40861,31.25626,-3.78521,.49039,31.22567,-3.83833,.46209,31.18591,-3.8663,.45232,31.22161,-3.84688,.59378,31.20952,-3.61255,.51807,31.19939,-3.55226,.65111,31.20999,-3.59889,.51468,31.07115,-3.76166,.53855,31.11541,-3.74907,.53126,31.07639,-3.75038,.51441,31.14675,-3.79838,.49427,30.8825,-3.56475,.51736,30.88697,-3.55874,.49541,30.79614,-3.4811,.47578,30.78908,-3.49475,.3323,30.97258,-3.66111,.31205,30.97526,-3.65282,.30983,31.03679,-3.70101,.33025,31.03343,-3.72392,.36024,30.71634,-3.44112,.34273,30.70714,-3.43253,.33201,30.76978,-3.47286,.34403,30.76909,-3.47648,.55103,31.18966,-3.67855,.50009,31.1644,-3.64065,.45693,30.73826,-3.40644,.42666,30.66869,-3.37774,.43864,30.73833,-3.41999,.36195,31.23455,-3.77677,.40674,31.25921,-3.75589,.46925,31.26919,-3.75487,.50334,31.2682,-3.76173,.51113,31.25694,-3.78836,.49952,31.26302,-3.7907,.49961,31.21777,-3.83676,.44114,30.77469,-3.50024,.36913,30.76268,-3.49908,.37255,30.82642,-3.57585,.34111,30.84471,-3.53617,.48017,30.97632,-3.72918,.48036,31.03728,-3.79191,.51521,31.00533,-3.7109,.64387,31.24383,-3.42265,.64808,31.20402,-3.37282,.73835,31.24577,-3.47762,.55038,31.17437,-3.71527,.54112,31.1926,-3.69141,.57037,31.17837,-3.70929,.2409,30.96051,-3.64065,.22784,31.03287,-3.672,.64303,31.22537,-3.49847,.73843,31.25427,-3.5626,.62272,31.19177,-3.67746,.67523,31.20562,-3.67144,.86811,31.27772,-3.69917,.77423,31.20626,-3.72702,.75515,31.24989,-3.64631,.88112,31.25577,-3.7277,1.07652,31.31096,-3.69956,1.00068,31.28465,-3.74269,.99346,31.31132,-3.72469,.89382,31.16943,-3.71137,1.00714,31.21072,-3.69787,.71853,31.02682,-3.64884,.5973,31.03616,-3.69879,.71009,31.09134,-3.70353,.59993,30.98305,-3.63759,.24929,30.75465,-3.48271,.14591,30.80312,-3.5475,.24753,30.8266,-3.53927,.14489,30.73836,-3.48008,1.03167,31.09821,-3.5491,1.01723,31.1025,-3.60401,1.10093,31.14364,-3.58169,.71611,30.90782,-3.50298,.58431,30.8482,-3.45605,.11994,30.66252,-3.41147};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_6()
		{
			double[] value = {.23287,30.67389,-3.39952,.48078,30.62199,-3.3152,.42246,30.61922,-3.33283,.48995,30.69074,-3.35277,.28548,30.49367,-3.32929,.19017,30.40509,-3.24387,.20914,30.50119,-3.33177,.24824,30.4005,-3.23093,.44097,30.51103,-3.26679,.47424,30.5326,-3.22225,.22067,30.15434,-2.94463,.16738,30.16168,-2.95728,.20485,30.17587,-2.955,.15975,30.17633,-2.97055,.09046,30.15752,-2.96748,0.0,30.15572,-2.97,.09062,30.17533,-2.9727,0.0,30.18076,-2.97357,.30375,30.14249,-2.83962,.26482,30.12246,-2.79099,.27526,30.12039,-2.85177,.27535,30.14632,-2.77836,.06902,30.11021,-2.72207,.14307,30.10193,-2.64479,.06216,30.09366,-2.64592,.14815,30.10647,-2.7225,.14105,30.07285,-2.50766,.10654,30.07043,-2.4044,.10052,30.07073,-2.50277,.07249,30.07598,-2.39477,.09292,30.10905,-2.36663,.12743,30.07622,-2.40963,.12483,30.11721,-2.39107,.75489,31.18506,-3.4314,.6559,31.1299,-3.34429,.77898,31.1241,-3.40036,.66709,31.07033,-3.33068,.34176,30.88539,-3.15818,.25653,30.9478,-3.15619,.23125,30.8678,-3.12695,.35723,30.96502,-3.19906,.68826,31.01159,-3.31981,.5596,30.93612,-3.26686,.90871,31.12155,-3.45724,.79901,31.07039,-3.402,.8899,31.17292,-3.47306,1.03113,31.12937,-3.51235,1.088,31.1728,-3.55075,1.01787,31.15893,-3.51416,.34156,30.68802,-3.02842,.42671,30.65438,-3.047,.33777,30.72418,-3.08327,.39774,30.69572,-3.11581,.205,30.41798,-2.87981,.15327,30.49288,-2.90072,.15781,30.44029,-2.87878,.21314,30.47903,-2.89841,.10003,30.1826,-2.37069,.11722,30.15387,-2.37566,.14757,30.20144,-2.46062,.12136,30.22982,-2.46015,.15748,30.25443,-2.50523,.19631,30.23301,-2.56008,.16212,30.26426,-2.55077,.18646,30.21594,-2.51647,.31384,30.22245,-2.86205,.30326,30.26881,-2.79749,.31019,30.19761,-2.82371,.49498,30.55556,-3.17992,.49087,30.60405,-3.21995,.34613,31.11435,-3.75953,.33499,31.13829,-3.7472,.35985,31.09873,-3.82747,.33774,31.15389,-3.77301,1.0682,31.32914,-3.66264,.99096,31.32696,-3.67836,.984,31.31074,-3.62043,.09357,30.15543,-2.3558,.04248,30.11582,-2.3517,.04524,30.16355,-2.34869,.08649,30.43343,-2.88364,.16018,30.42278,-2.87809,.07872,30.44528,-2.89365,.07773,30.72819,-3.02206,.1534,30.74817,-3.03427,.07848,30.75071,-3.03948,.15536,30.72109,-3.01918,.52459,30.71591,-3.31331,.50563,30.64707,-3.26463,.2038,30.39991,-2.8761,0.0,30.13407,-2.95097,.08678,30.14199,-2.94591,.23449,30.13171,-2.92759,.1663,30.14491,-2.9418,.573,31.12854,-3.73836,.57503,31.09585,-3.74112,.14633,30.82019,-3.06613,.23232,30.81904,-3.09713,.1455,30.86292,-3.08244,.31493,30.90168,-3.59893};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_7()
		{
			double[] value = {.32906,30.84594,-3.53397,.24825,30.88991,-3.58955,.09887,31.25991,-3.33729,.10083,31.22829,-3.3696,.08952,31.15268,-3.19711,.0986,31.26764,-3.27669,0.0,31.1488,-3.18965,.9096,31.06031,-3.62001,.92088,31.03178,-3.56615,.45584,30.6009,-3.2725,.44208,30.71801,-3.15419,.45734,30.67514,-3.18351,.49621,30.69973,-3.16833,.41893,30.70211,-3.15455,.21348,30.63038,-3.31551,.47247,30.60815,-3.29889,.45561,30.60745,-3.28048,.40842,30.61186,-3.30146,.41662,30.60875,-3.31926,.47317,30.61648,-3.23338,.48709,30.6125,-3.22513,.47379,30.64281,-3.20386,.48335,30.63216,-3.19864,.23197,30.77446,-3.08828,.33317,30.74163,-3.11286,.33258,30.75247,-3.10656,.23356,30.75907,-3.09141,.15321,30.75595,-3.04835,.07905,30.7614,-3.05167,0.0,30.78075,-3.05533,0.0,30.7718,-3.05619,.23774,30.36628,-2.87317,.25315,30.33141,-2.88219,.2843,30.25854,-2.89785,.2016,30.3904,-2.87153,.15917,30.40966,-2.87946,.15749,30.41317,-2.87081,.08703,30.41782,-2.88028,.08785,30.42724,-2.86614,.24541,30.22296,-2.9251,.237,30.18712,-2.94021,.22439,30.19877,-2.94367,.27586,30.19993,-2.92427,.22659,30.13679,-2.6301,.19301,30.13298,-2.6128,.21826,30.11214,-2.63879,0.0,30.29253,-2.57421,.07893,30.2677,-2.57416,.08217,30.28531,-2.58068,.21246,30.11619,-2.60438,.21053,30.17325,-2.59706,.21907,30.1621,-2.58293,.18265,30.10632,-2.62311,.20049,30.09774,-2.64527,.13839,30.11491,-2.62161,.36981,30.44512,-2.97181,.36284,30.4611,-2.95851,.29144,30.23039,-3.03614,.31825,30.29358,-3.08763,.30848,30.25105,-3.01668,.34477,30.31801,-3.06739,.23645,30.10798,-2.71155,.23981,30.13125,-2.70314,.28185,30.17104,-2.77185,.24773,30.19564,-2.66703,.24391,30.15361,-2.69081,.2816,30.22587,-2.75714,.23696,30.69497,-3.42402,.478,30.81149,-3.18965,.52664,30.79668,-3.20694,.30771,31.23961,-3.37251,.41583,31.22781,-3.40037,.30887,31.23815,-3.38733,.3198,31.19294,-3.56899,.41429,31.19785,-3.54175,.31892,31.17149,-3.64941,.43803,30.9115,-3.2049,.43258,30.88757,-3.19412,.28921,30.29935,-2.84002,.3206,31.21421,-3.51363,.18665,31.27077,-3.34611,.18918,31.23288,-3.38181,.2403,30.23764,-2.65052,.26454,30.26217,-2.74475,.27034,30.19241,-2.97595,.45764,30.46278,-3.10655,.4245,30.46028,-3.03767,.41074,30.42059,-3.07694,.46635,30.50912,-3.06943,.82203,31.01577,-3.40891,.06179,30.11158,-2.62126,.06161,30.09323,-2.61254,.13831,30.09542,-2.61773,.22704,30.18194,-2.60871,.21018,30.19533,-2.58931,.2109,30.20279,-2.57189,.20221,30.22812,-2.57552,.16569,30.25731,-2.5688,0.0,30.30565,-2.5521,.08308,30.29083,-2.54871};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_8()
		{
			double[] value = {.08589,30.21792,-2.97806,.19478,30.19708,-2.97036,.14525,30.20783,-2.97819,.22412,30.19708,-2.95821,.22483,30.20067,-2.94526,.25225,30.21898,-2.93521,.2454,30.2242,-2.92698,.25336,30.27768,-2.9044,.25972,30.26885,-2.90985,.08677,30.41949,-2.88345,.15971,30.41148,-2.88215,.24183,30.34342,-2.89009,.25426,30.30451,-2.89947,.23571,30.7494,-3.08551,.33579,30.72858,-3.09943,.33249,30.7335,-3.10671,.23262,30.75043,-3.06238,.39449,30.70077,-3.12471,.43653,30.67977,-3.13977,.42088,30.68793,-3.149,.38579,30.71117,-3.13393,.47212,30.65764,-3.16963,.45632,30.66191,-3.17849,.40896,30.60481,-3.29702,.30624,30.61367,-3.30237,.21344,30.62309,-3.31066,.36279,31.02339,-3.77839,.34158,31.18966,-3.72909,.41508,31.19827,-3.70866,1.01425,31.14417,-3.66096,1.10553,31.1958,-3.62424,.72396,30.97109,-3.60128,.60026,30.92512,-3.56913,.37793,30.89775,-3.64454,.45944,30.85361,-3.57831,.4658,30.91879,-3.66079,.07525,30.86242,-3.06788,.07536,30.82334,-3.05931,.33785,30.81953,-3.13126,.08882,30.42745,-2.84172,.21065,30.23886,-2.5855,.22387,30.21504,-2.59719,.21559,30.26972,-2.63701,.68917,31.16508,-3.73618,.25444,30.16673,-2.92941,.27122,30.14436,-2.90449,.29354,30.26951,-2.91764,.24468,30.39361,-2.87849,.23434,30.37789,-2.88015,.15563,30.54506,-2.93403,.07945,30.60362,-2.97362,.07834,30.55047,-2.9453,.15655,30.59302,-2.97037,.49972,30.60983,-3.10022,.48787,30.62626,-3.19063,.47852,30.65299,-3.16098,.50116,30.58224,-3.13502,.3632,31.16978,-3.85823,.35643,31.19696,-3.82502,.21171,31.14444,-3.65639,.31643,31.11597,-3.73402,.16445,30.11431,-2.48815,.1527,30.08123,-2.50167,.08362,30.32468,-2.63487,.28464,30.30714,-2.78098,.23255,30.35557,-2.76508,.22523,30.31103,-2.72246,.35669,30.5339,-2.97624,.33181,30.49239,-2.94133,.40256,30.5176,-2.98839,.39926,30.5958,-2.9899,.44846,30.57358,-3.01464,.46468,30.5516,-3.03524,.47205,30.62976,-3.0749,.24212,30.70512,-3.02359,.2339,30.74115,-3.04872,.41555,30.81286,-3.16047,.33063,30.77099,-3.10717,.40315,30.75392,-3.14154,.22981,30.78814,-3.08724,.15997,30.93915,-3.12121,.30894,30.15662,-2.88523,.04463,30.07802,-2.38629,.20435,30.0844,-2.56235,.2106,30.13083,-2.5472,.17921,30.06466,-2.56712,.19932,30.08758,-2.61752,.12697,30.06697,-2.56261,.06244,30.0728,-2.55496,.0812,30.12391,-2.89178,0.0,30.12295,-2.89343,.09166,30.21435,-3.0143,.15083,30.19901,-3.01329,.09972,30.24078,-3.07808,.20424,30.21666,-3.06596,.27509,30.27917,-3.10837,.25792,30.21936,-3.05319,.21409,30.2855,-3.11507,.386,30.49813,-3.30518,.33286,30.38892,-3.21781};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_9()
		{
			double[] value = {.79251,31.13549,-3.70391,.807,31.06735,-3.6634,1.09323,31.25015,-3.66908,.53672,31.21086,-3.7599,.51713,31.16536,-3.79955,.48299,31.21038,-3.70298,.52375,31.22735,-3.72373,.41283,31.15651,-3.64643,.33218,31.17333,-3.67924,.41202,31.22433,-3.33612,.54118,31.24194,-3.38027,.53478,31.22615,-3.44351,.13524,31.04292,-3.66399,.14584,30.9448,-3.64907,.53875,31.18287,-3.32362,.516,30.95073,-3.64531,.33645,30.9014,-3.60657,.34455,30.6665,-3.39161,.53294,31.01088,-3.70322,.44666,30.67354,-3.13253,.82407,30.9694,-3.46982,.6893,30.90901,-3.39267,.23845,30.18926,-3.00415,.1015,31.22136,-3.38225,.19006,31.22575,-3.39424,-.59827,31.04056,-3.29109,-.51036,31.08312,-3.26413,-.2318,30.36641,-2.88109,-.23169,30.36524,-2.87893,-.2406,30.33474,-2.89069,-.24072,30.33372,-2.88824,-.20022,30.19668,-2.95259,-.15418,30.19222,-2.96979,-.09021,30.19384,-2.97136,-.30558,30.43692,-2.90647,-.3312,30.39864,-2.92504,-.26896,30.36491,-2.88399,-.54146,30.8688,-3.24917,-.11073,30.62,-3.31544,-.08085,30.79593,-3.05647,-.21568,30.6234,-3.338,-.21569,30.6318,-3.35265,-.47247,30.60815,-3.29889,-.49917,30.62877,-3.25211,-.48078,30.62199,-3.3152,-.50563,30.64707,-3.26463,-.1556,30.75846,-3.07522,-.07944,30.76552,-3.06271,-.36974,31.18335,-3.85653,-.39891,31.21354,-3.84375,-.49039,31.22567,-3.83833,-.45232,31.22161,-3.84688,-.46209,31.18591,-3.8663,-.59378,31.20952,-3.61255,-.51807,31.19939,-3.55226,-.51468,31.07115,-3.76166,-.53126,31.07639,-3.75038,-.3323,30.97258,-3.66111,-.31205,30.97526,-3.65282,-.46925,31.26919,-3.75487,-.37324,30.959,-3.71394,-.73835,31.24577,-3.47762,-.55038,31.17437,-3.71527,-.64303,31.22537,-3.49847,-.73843,31.25427,-3.5626,-.99346,31.31132,-3.72469,-.88112,31.25577,-3.7277,-.89382,31.16943,-3.71137,-.24753,30.8266,-3.53927,-.14591,30.80312,-3.5475,-.14489,30.73836,-3.48008,-1.03167,31.09821,-3.5491,-.71611,30.90782,-3.50298,-.11994,30.66252,-3.41147,-.23287,30.67389,-3.39952,-.42246,30.61922,-3.33283,-.20914,30.50119,-3.33177,-.19017,30.40509,-3.24387,-.48338,30.58508,-3.26156,-.47424,30.5326,-3.22225,-.20485,30.17587,-2.955,-.26482,30.12246,-2.79099,-.27535,30.14632,-2.77836,-.23645,30.10798,-2.71155,-.20049,30.09774,-2.64527,-.21826,30.11214,-2.63879,-.2122,30.09817,-2.7197,-.06902,30.11021,-2.72207,-.06216,30.09366,-2.64592,-.14307,30.10193,-2.64479,-.14815,30.10647,-2.7225,-.10052,30.07073,-2.50277,-.09292,30.10905,-2.36663,-.12483,30.11721,-2.39107,-.75489,31.18506,-3.4314,-.8899,31.17292,-3.47306,-.90871,31.12155,-3.45724,-1.03113,31.12937,-3.51235,-1.01787,31.15893,-3.51416,-1.088,31.1728,-3.55075};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_10()
		{
			double[] value = {-.42671,30.65438,-3.047,-.27027,30.33947,-2.8299,-.21936,30.37686,-2.8192,-.17075,30.34892,-2.71175,-.17258,30.38693,-2.75621,-.12136,30.22982,-2.46015,-.14757,30.20144,-2.46062,-.15748,30.25443,-2.50523,-.18646,30.21594,-2.51647,-.31019,30.19761,-2.82371,0.0,30.93428,-3.65112,0.0,31.01582,-3.68286,-1.0682,31.32914,-3.66264,-.984,31.31074,-3.62043,-.99096,31.32696,-3.67836,-.04524,30.16355,-2.34869,-.055,30.21169,-2.37399,-.06939,30.25133,-2.46423,-.15781,30.44029,-2.87878,-.07872,30.44528,-2.89365,-.15536,30.72109,-3.01918,-.20215,30.1817,-2.52817,-.15689,30.15894,-2.4722,-.31493,30.90168,-3.59893,-.32906,30.84594,-3.53397,-.24825,30.88991,-3.58955,-.08952,31.15268,-3.19711,-.9096,31.06031,-3.62001,-.92088,31.03178,-3.56615,-.48034,30.59374,-3.26709,-.44208,30.71801,-3.15419,-.49621,30.69973,-3.16833,-.21348,30.63038,-3.31551,-.45561,30.60745,-3.28048,-.41662,30.60875,-3.31926,-.40842,30.61186,-3.30146,-.48709,30.6125,-3.22513,-.47317,30.61648,-3.23338,-.23356,30.75907,-3.09141,-.33258,30.75247,-3.10656,-.33317,30.74163,-3.11286,-.23774,30.36628,-2.87317,-.25315,30.33141,-2.88219,-.2843,30.25854,-2.89785,-.2016,30.3904,-2.87153,-.15749,30.41317,-2.87081,-.27586,30.19993,-2.92427,-.22439,30.19877,-2.94367,-.237,30.18712,-2.94021,-.07893,30.2677,-2.57416,-.08308,30.29083,-2.54871,-.21907,30.1621,-2.58293,-.18265,30.10632,-2.62311,-.36981,30.44512,-2.97181,-.31825,30.29358,-3.08763,-.34477,30.31801,-3.06739,-.23981,30.13125,-2.70314,-.24391,30.15361,-2.69081,-.28185,30.17104,-2.77185,-.52664,30.79668,-3.20694,-.478,30.81149,-3.18965,-.43258,30.88757,-3.19412,-.55073,30.82692,-3.30317,-.53802,30.75611,-3.25349,-.34592,30.36389,-3.14296,-.38091,30.38612,-3.11395,-.37952,30.40079,-2.99842,-.4169,30.49828,-3.00583,-.36951,30.35367,-3.03282,-.39475,30.40273,-3.18818,-.3008,30.34964,-3.15709,-.28324,30.2164,-2.94666,-.32447,30.284,-2.98854,-.3329,30.33229,-2.95431,0.0,30.07935,-2.38398,0.0,30.1214,-2.35087,-.16646,30.26953,-2.57535,-.24183,30.34342,-2.89009,0.0,30.7651,-3.05371,0.0,30.76315,-3.04498,-.47526,30.65397,-3.21045,-.50983,30.67494,-3.19839,-.47452,30.62605,-3.23955,-.11382,31.15641,-3.59228,0.0,31.1259,-3.65975,-.12305,31.1362,-3.65647,0.0,31.14457,-3.5697,0.0,31.18072,-3.46641,-.10609,31.19889,-3.47915,-.21269,31.16735,-3.59596,-.1966,31.2048,-3.48512,-.48036,31.03728,-3.79191,-.47357,31.10396,-3.83878,-.14771,30.86984,-3.59092,-.81491,31.01758,-3.60963,-.90398,31.10324,-3.66795,-.16088,30.41041,-2.84383,-.20876,30.38782,-2.84649,-.25666,30.35612,-2.85317,-.27363,30.31902,-2.86578};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_11()
		{
			double[] value = {-.29962,30.2434,-2.88584,-.29185,30.18231,-2.91026,0.0,30.85573,-3.59714,-.08542,31.01938,-3.14367,-.07092,30.92829,-3.10182,-.17661,31.02651,-3.15351,-.07851,30.67063,-2.98531,-.15475,30.6614,-2.98059,-.15327,30.49288,-2.90072,-.07679,30.49706,-2.91321,-.08943,30.42588,-2.81826,-.16559,30.40537,-2.81684,-.16434,30.30327,-2.63092,-.0754,30.28666,-2.50632,0.0,30.60493,-2.97621,0.0,30.67188,-2.99643,-.4163,31.17457,-3.28266,-.86811,31.27772,-3.69917,-.85194,31.28871,-3.62289,-.92392,31.0693,-3.45695,-.92074,31.01998,-3.50725,-.43763,30.43071,-3.14955,0.0,30.1724,-2.34486,0.0,30.22479,-2.37233,0.0,30.26503,-2.46182,0.0,30.29739,-2.50601,0.0,30.42851,-2.82567,0.0,30.45967,-2.89739,-.2741,30.45723,-2.90225,-.21314,30.47903,-2.89841,0.0,30.50119,-2.91853,-.21642,30.53154,-2.93236,-.29046,30.50976,-2.93448,-.30262,30.55999,-2.96497,-.22707,30.58201,-2.96711,0.0,30.55236,-2.95041,-.32628,30.62335,-2.97459,-.23265,30.6488,-2.97764,-.45137,30.74448,-3.16055,-.5035,30.72312,-3.17248,-1.00042,31.20653,-3.53157,0.0,31.0207,-3.13391,0.0,30.92297,-3.0915,-.8676,31.22697,-3.51134,-.98552,31.25549,-3.56505,-.85578,31.27828,-3.56267,-.30033,31.17297,-3.23681,-.30232,31.24042,-3.28752,-.05349,30.07577,-2.49637,0.0,30.07288,-2.55307,0.0,30.07416,-2.49579,0.0,30.1097,-2.72237,0.0,30.09854,-2.64316,-.15787,30.11655,-2.81628,-.2282,30.11304,-2.80332,0.0,30.12335,-2.81892,-.07671,30.12065,-2.81701,-.0812,30.12391,-2.89178,-.16523,30.12138,-2.88644,-.23622,30.10806,-2.86971,-.19272,30.18802,-3.01269,-.15471,30.22752,-3.07208,-.16221,30.2892,-3.11873,-.10376,30.30026,-3.12154,-.22868,30.35411,-3.16867,-.10618,30.36097,-3.18418,-.17425,30.35612,-3.17971,0.0,30.41102,-3.24688,-.10852,30.41071,-3.25005,0.0,30.36659,-3.1876,-.11202,30.50831,-3.32678,0.0,30.5123,-3.33054,-.51655,30.6886,-3.20816,-.31514,30.62767,-3.35052,0.0,30.64612,-3.41824,-.82849,30.98215,-3.52833,0.0,30.7202,-3.48959,0.0,30.78448,-3.54647,-.53294,31.01088,-3.70322,-.53575,30.95563,-3.63883,-.77423,31.20626,-3.72702,-.46956,31.17257,-3.86815,-.18426,31.2825,-3.28004,-.38405,30.72204,-3.1381,-.39287,30.73628,-3.13363,-.30984,30.61826,-3.33609,0.0,30.79757,-3.05269,.30245,30.62368,-3.30739,.31514,30.62767,-3.35052,.30984,30.61826,-3.33609,.49917,30.62877,-3.25211,.51655,30.6886,-3.20816,.5035,30.72312,-3.17248,.50983,30.67494,-3.19839,.39287,30.73628,-3.13363,.45137,30.74448,-3.16055,.47452,30.62605,-3.23955,.47526,30.65397,-3.21045,.38405,30.72204,-3.1381,.55073,30.82692,-3.30317};
			return value;
		}
		private double[] getcoccyx_Coord_7_34_point_12()
		{
			double[] value = {.53575,30.95563,-3.63883,.46956,31.17257,-3.86815,.37324,30.959,-3.71394,.21269,31.16735,-3.59596,.12305,31.1362,-3.65647,.47357,31.10396,-3.83878,.10609,31.19889,-3.47915,.1966,31.2048,-3.48512,.18426,31.2825,-3.28004,.30232,31.24042,-3.28752,.85578,31.27828,-3.56267,.85194,31.28871,-3.62289,.90398,31.10324,-3.66795,.81491,31.01758,-3.60963,.82849,30.98215,-3.52833,.92074,31.01998,-3.50725,.11202,30.50831,-3.32678,.10852,30.41071,-3.25005,.39475,30.40273,-3.18818,.3008,30.34964,-3.15709,.22868,30.35411,-3.16867,.17425,30.35612,-3.17971,.10618,30.36097,-3.18418,0.0,30.30261,-3.12845,.10376,30.30026,-3.12154,.16221,30.2892,-3.11873,.32447,30.284,-2.98854,.36951,30.35367,-3.03282,.15471,30.22752,-3.07208,.19272,30.18802,-3.01269,.29185,30.18231,-2.91026,.07671,30.12065,-2.81701,.2122,30.09817,-2.7197,.05349,30.07577,-2.49637,.29962,30.2434,-2.88584,.4163,31.17457,-3.28266,.18029,31.16418,-3.20498,.28128,31.03395,-3.19127,.30033,31.17297,-3.23681,.17661,31.02651,-3.15351,.8676,31.22697,-3.51134,.98552,31.25549,-3.56505,1.08931,31.26802,-3.6154,1.00042,31.20653,-3.53157,.3945,31.05094,-3.22612,0.0,30.85379,-3.05896,.07092,30.92829,-3.10182,0.0,30.82195,-3.0531,.92392,31.0693,-3.45695,.32628,30.62335,-2.97459,.23265,30.6488,-2.97764,.37952,30.40079,-2.99842,.3329,30.33229,-2.95431,.30262,30.55999,-2.96497,.15475,30.6614,-2.98059,.22707,30.58201,-2.96711,.21642,30.53154,-2.93236,.29046,30.50976,-2.93448,.2741,30.45723,-2.90225,.07679,30.49706,-2.91321,.27363,30.31902,-2.86578,.27027,30.33947,-2.8299,.25666,30.35612,-2.85317,.20876,30.38782,-2.84649,.16559,30.40537,-2.81684,.21936,30.37686,-2.8192,.16088,30.41041,-2.84383,.07851,30.67063,-2.98531,.0918,30.40411,-2.75776,.08943,30.42588,-2.81826,.17075,30.34892,-2.71175,.17258,30.38693,-2.75621,.0941,30.36791,-2.70864,.16646,30.26953,-2.57535,.16434,30.30327,-2.63092,.0754,30.28666,-2.50632,.15689,30.15894,-2.4722,.20215,30.1817,-2.52817,.055,30.21169,-2.37399,1.09319,31.21342,-3.57382,.28324,30.2164,-2.94666,.06939,30.25133,-2.46423,.08542,31.01938,-3.14367,.14771,30.86984,-3.59092,.53802,30.75611,-3.25349,.11382,31.15641,-3.59228,.43763,30.43071,-3.14955,.38091,30.38612,-3.11395,.34592,30.36389,-3.14296,.4169,30.49828,-3.00583,-.30245,30.62368,-3.30739,-.18029,31.16418,-3.20498};
			return value;
		}

		/** Large attribute array: IndexedFaceSet DEF='loscoxae_Geo' coordIndex field, scene-graph level=6, element #14, 10624 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getloscoxae_Geo_6_14_coordIndex()
		{
			MFInt32 loscoxae_Geo_6_14_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_1()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_2()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_3()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_4()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_5()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_6()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_7()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_8()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_9()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_10()))
				.append(new MFInt32(getloscoxae_Geo_6_14_coordIndex_11()));
			return loscoxae_Geo_6_14_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='loscoxae_Coord' point field, scene-graph level=7, element #14, 3984 total numbers made up of 1328 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getloscoxae_Coord_7_14_point()
		{
			MFVec3f loscoxae_Coord_7_14_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_1()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_2()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_3()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_4()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_5()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_6()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_7()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_8()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_9()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_10()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_11()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_12()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_13()))
				.append(new MFVec3f(getloscoxae_Coord_7_14_point_14()));
			return loscoxae_Coord_7_14_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='roscoxae_Geo' coordIndex field, scene-graph level=6, element #19, 10624 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getroscoxae_Geo_6_19_coordIndex()
		{
			MFInt32 roscoxae_Geo_6_19_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_1()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_2()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_3()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_4()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_5()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_6()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_7()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_8()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_9()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_10()))
				.append(new MFInt32(getroscoxae_Geo_6_19_coordIndex_11()));
			return roscoxae_Geo_6_19_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='roscoxae_Coord' point field, scene-graph level=7, element #19, 3984 total numbers made up of 1328 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getroscoxae_Coord_7_19_point()
		{
			MFVec3f roscoxae_Coord_7_19_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_1()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_2()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_3()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_4()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_5()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_6()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_7()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_8()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_9()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_10()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_11()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_12()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_13()))
				.append(new MFVec3f(getroscoxae_Coord_7_19_point_14()));
			return roscoxae_Coord_7_19_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='sacrum_Geo' coordIndex field, scene-graph level=6, element #24, 34528 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getsacrum_Geo_6_24_coordIndex()
		{
			MFInt32 sacrum_Geo_6_24_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_1()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_2()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_3()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_4()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_5()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_6()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_7()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_8()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_9()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_10()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_11()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_12()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_13()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_14()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_15()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_16()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_17()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_18()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_19()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_20()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_21()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_22()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_23()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_24()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_25()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_26()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_27()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_28()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_29()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_30()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_31()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_32()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_33()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_34()))
				.append(new MFInt32(getsacrum_Geo_6_24_coordIndex_35()));
			return sacrum_Geo_6_24_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='sacrum_Coord' point field, scene-graph level=7, element #24, 12852 total numbers made up of 4284 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getsacrum_Coord_7_24_point()
		{
			MFVec3f sacrum_Coord_7_24_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getsacrum_Coord_7_24_point_1()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_2()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_3()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_4()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_5()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_6()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_7()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_8()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_9()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_10()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_11()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_12()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_13()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_14()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_15()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_16()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_17()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_18()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_19()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_20()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_21()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_22()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_23()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_24()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_25()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_26()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_27()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_28()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_29()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_30()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_31()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_32()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_33()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_34()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_35()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_36()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_37()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_38()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_39()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_40()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_41()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_42()))
				.append(new MFVec3f(getsacrum_Coord_7_24_point_43()));
			return sacrum_Coord_7_24_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='sympubis_Geo' coordIndex field, scene-graph level=6, element #29, 928 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getsympubis_Geo_6_29_coordIndex()
		{
			MFInt32 sympubis_Geo_6_29_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getsympubis_Geo_6_29_coordIndex_1()));
			return sympubis_Geo_6_29_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='sympubis_Coord' point field, scene-graph level=7, element #29, 354 total numbers made up of 118 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getsympubis_Coord_7_29_point()
		{
			MFVec3f sympubis_Coord_7_29_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getsympubis_Coord_7_29_point_1()))
				.append(new MFVec3f(getsympubis_Coord_7_29_point_2()));
			return sympubis_Coord_7_29_point;
		}
		/** Large attribute array: IndexedFaceSet DEF='coccyx_Geo' coordIndex field, scene-graph level=6, element #34, 9520 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFInt32 getcoccyx_Geo_6_34_coordIndex()
		{
			MFInt32 coccyx_Geo_6_34_coordIndex = new MFInt32()/*2.finalize*/
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_1()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_2()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_3()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_4()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_5()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_6()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_7()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_8()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_9()))
				.append(new MFInt32(getcoccyx_Geo_6_34_coordIndex_10()));
			return coccyx_Geo_6_34_coordIndex;
		}
		/** Large attribute array: Coordinate DEF='coccyx_Coord' point field, scene-graph level=7, element #34, 3576 total numbers made up of 1192 3-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec3f getcoccyx_Coord_7_34_point()
		{
			MFVec3f coccyx_Coord_7_34_point = new MFVec3f()/*2.finalize*/
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_1()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_2()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_3()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_4()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_5()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_6()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_7()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_8()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_9()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_10()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_11()))
				.append(new MFVec3f(getcoccyx_Coord_7_34_point_12()));
			return coccyx_Coord_7_34_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return BonesGirdle model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new BonesGirdle().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Medical.BonesGirdle\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Medical.BonesGirdle self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Medical/BonesGirdle_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Medical/BonesGirdle_JavaExport.x3d"; 
                String filenameX3DV = "Medical/BonesGirdle_JavaExport.x3dv"; 
                String filenameJSON = "Medical/BonesGirdle_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
