package Basic.Medical;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Rendering.*;
import org.web3d.x3d.jsail.Shape.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> Human bone model for Chest. </p>
 <p> Related links: Catalog page <a href="../../../Medical/BonesChestIndex.html" target="_blank">BonesChest</a>,  source <a href="../../../Medical/BonesChest.java">BonesChest.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Medical/BonesChest.x3d">BonesChest.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Damon Hernandez, Joe Williams </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> Human bone model for Chest </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Joe Williams, Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> created </i> </td>
			<td> 5 December 2013 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesChest.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesChest.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Medical/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Damon Hernandez, Joe Williams
 */

public class BonesChest
{
	/** Default constructor to create this object. */
	public BonesChest ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERCHANGE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("BonesChest.x3d"))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Damon Hernandez, Joe Williams"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("Human bone model for Chest"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Joe Williams, Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_CREATED    ).setContent("5 December 2013"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Medical/BonesChest.x3d"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("BonesChest.x3d"))
    .addChild(new Transform("DSkeletonParts").setScale(0.029,0.029,0.029)
      .addChild(new Viewpoint("Hips").setDescription("Hips view").setFieldOfView(0.785).setPosition(-.22486,50.4387,33.51968))
      .addChild(new Group("Torso")
        .addComments(" sternum lcartend lclavcle lccart rccart2 lrib-12 lscapula lcoscart lfreecrt rcartend rclavcle rccart lccart2 rrib-12 rscapula rcoscart rfreecrt ")
        .addChild(new Shape("sternum")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("sternum_Geo").setDEF("sternum_Geo").setCreaseAngle(1.571).setCoordIndex(getsternum_Geo_6_15_coordIndex())
            .setCoord(new Coordinate("sternum_Coord").setPoint(getsternum_Coord_7_15_point()))))
        .addChild(new Shape("lcartend")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("lcartend_Geo").setDEF("lcartend_Geo").setCreaseAngle(1.571).setCoordIndex(getlcartend_Geo_6_20_coordIndex())
            .setCoord(new Coordinate("lcartend_Coord").setPoint(getlcartend_Coord_7_20_point()))))
        .addChild(new Shape("lclavcle")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lclavcle_Geo").setDEF("lclavcle_Geo").setCreaseAngle(1.571).setCoordIndex(getlclavcle_Geo_6_25_coordIndex())
            .setCoord(new Coordinate("lclavcle_Coord").setPoint(getlclavcle_Coord_7_25_point()))))
        .addChild(new Shape("lccart")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("lccart_Geo").setDEF("lccart_Geo").setCreaseAngle(1.571).setCoordIndex(getlccart_Geo_6_30_coordIndex())
            .setCoord(new Coordinate("lccart_Coord").setPoint(getlccart_Coord_7_30_point()))))
        .addChild(new Shape("lccart2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("lccart2_Geo").setDEF("lccart2_Geo").setCreaseAngle(1.571).setCoordIndex(getlccart2_Geo_6_35_coordIndex())
            .setCoord(new Coordinate("lccart2_Coord").setPoint(getlccart2_Coord_7_35_point()))))
        .addChild(new Shape("lrrib")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrrib_Geo").setDEF("lrrib_Geo").setCreaseAngle(1.571).setCoordIndex(getlrrib_Geo_6_40_coordIndex())
            .setCoord(new Coordinate("lrrib_Coord").setPoint(getlrrib_Coord_7_40_point()))))
        .addChild(new Shape("lrib2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib2_Geo").setDEF("lrib2_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib2_Geo_6_45_coordIndex())
            .setCoord(new Coordinate("lrib2_Coord").setPoint(getlrib2_Coord_7_45_point()))))
        .addChild(new Shape("lrib3")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib3_Geo").setDEF("lrib3_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib3_Geo_6_50_coordIndex())
            .setCoord(new Coordinate("lrib3_Coord").setPoint(getlrib3_Coord_7_50_point()))))
        .addChild(new Shape("lrib4")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib4_Geo").setDEF("lrib4_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib4_Geo_6_55_coordIndex())
            .setCoord(new Coordinate("lrib4_Coord").setPoint(getlrib4_Coord_7_55_point()))))
        .addChild(new Shape("lrib5")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib5_Geo").setDEF("lrib5_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib5_Geo_6_60_coordIndex())
            .setCoord(new Coordinate("lrib5_Coord").setPoint(getlrib5_Coord_7_60_point()))))
        .addChild(new Shape("lrib6")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib6_Geo").setDEF("lrib6_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib6_Geo_6_65_coordIndex())
            .setCoord(new Coordinate("lrib6_Coord").setPoint(getlrib6_Coord_7_65_point()))))
        .addChild(new Shape("lrib7")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib7_Geo").setDEF("lrib7_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib7_Geo_6_70_coordIndex())
            .setCoord(new Coordinate("lrib7_Coord").setPoint(getlrib7_Coord_7_70_point()))))
        .addChild(new Shape("lrib8")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib8_Geo").setDEF("lrib8_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib8_Geo_6_75_coordIndex())
            .setCoord(new Coordinate("lrib8_Coord").setPoint(getlrib8_Coord_7_75_point()))))
        .addChild(new Shape("lrib9")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib9_Geo").setDEF("lrib9_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib9_Geo_6_80_coordIndex())
            .setCoord(new Coordinate("lrib9_Coord").setPoint(getlrib9_Coord_7_80_point()))))
        .addChild(new Shape("lrib10")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib10_Geo").setDEF("lrib10_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib10_Geo_6_85_coordIndex())
            .setCoord(new Coordinate("lrib10_Coord").setPoint(getlrib10_Coord_7_85_point()))))
        .addChild(new Shape("lrib11")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib11_Geo").setDEF("lrib11_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib11_Geo_6_90_coordIndex())
            .setCoord(new Coordinate("lrib11_Coord").setPoint(getlrib11_Coord_7_90_point()))))
        .addChild(new Shape("lrib12")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lrib12_Geo").setDEF("lrib12_Geo").setCreaseAngle(1.571).setCoordIndex(getlrib12_Geo_6_95_coordIndex())
            .setCoord(new Coordinate("lrib12_Coord").setPoint(getlrib12_Coord_7_95_point()))))
        .addChild(new Shape("lscapula")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("lscapula_Geo").setDEF("lscapula_Geo").setCreaseAngle(1.571).setCoordIndex(getlscapula_Geo_6_100_coordIndex())
            .setCoord(new Coordinate("lscapula_Coord").setPoint(getlscapula_Coord_7_100_point()))))
        .addChild(new Shape("lcoscart")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("lcoscart_Geo").setDEF("lcoscart_Geo").setCreaseAngle(1.571).setCoordIndex(getlcoscart_Geo_6_105_coordIndex())
            .setCoord(new Coordinate("lcoscart_Coord").setPoint(getlcoscart_Coord_7_105_point()))))
        .addChild(new Shape("lfreecrt")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("lfreecrt_Geo").setDEF("lfreecrt_Geo").setCreaseAngle(1.571).setCoordIndex(getlfreecrt_Geo_6_110_coordIndex())
            .setCoord(new Coordinate("lfreecrt_Coord").setPoint(getlfreecrt_Coord_7_110_point()))))
        .addChild(new Shape("rclavcle")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rclavcle_Geo").setDEF("rclavcle_Geo").setCreaseAngle(1.571).setCoordIndex(getrclavcle_Geo_6_115_coordIndex())
            .setCoord(new Coordinate("rclavcle_Coord").setPoint(getrclavcle_Coord_7_115_point()))))
        .addChild(new Shape("rccart")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("rccart_Geo").setDEF("rccart_Geo").setCreaseAngle(1.571).setCoordIndex(getrccart_Geo_6_120_coordIndex())
            .setCoord(new Coordinate("rccart_Coord").setPoint(getrccart_Coord_7_120_point()))))
        .addChild(new Shape("rccart2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("rccart2_Geo").setDEF("rccart2_Geo").setCreaseAngle(1.571).setCoordIndex(getrccart2_Geo_6_125_coordIndex())
            .setCoord(new Coordinate("rccart2_Coord").setPoint(getrccart2_Coord_7_125_point()))))
        .addChild(new Shape("rrrib")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrrib_Geo").setDEF("rrrib_Geo").setCreaseAngle(1.571).setCoordIndex(getrrrib_Geo_6_130_coordIndex())
            .setCoord(new Coordinate("rrrib_Coord").setPoint(getrrrib_Coord_7_130_point()))))
        .addChild(new Shape("rrib2")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib2_Geo").setDEF("rrib2_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib2_Geo_6_135_coordIndex())
            .setCoord(new Coordinate("rrib2_Coord").setPoint(getrrib2_Coord_7_135_point()))))
        .addChild(new Shape("rrib3")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib3_Geo").setDEF("rrib3_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib3_Geo_6_140_coordIndex())
            .setCoord(new Coordinate("rrib3_Coord").setPoint(getrrib3_Coord_7_140_point()))))
        .addChild(new Shape("rrib4")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib4_Geo").setDEF("rrib4_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib4_Geo_6_145_coordIndex())
            .setCoord(new Coordinate("rrib4_Coord").setPoint(getrrib4_Coord_7_145_point()))))
        .addChild(new Shape("rrib5")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib5_Geo").setDEF("rrib5_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib5_Geo_6_150_coordIndex())
            .setCoord(new Coordinate("rrib5_Coord").setPoint(getrrib5_Coord_7_150_point()))))
        .addChild(new Shape("rrib6")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib6_Geo").setDEF("rrib6_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib6_Geo_6_155_coordIndex())
            .setCoord(new Coordinate("rrib6_Coord").setPoint(getrrib6_Coord_7_155_point()))))
        .addChild(new Shape("rrib7")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib7_Geo").setDEF("rrib7_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib7_Geo_6_160_coordIndex())
            .setCoord(new Coordinate("rrib7_Coord").setPoint(getrrib7_Coord_7_160_point()))))
        .addChild(new Shape("rrib8")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib8_Geo").setDEF("rrib8_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib8_Geo_6_165_coordIndex())
            .setCoord(new Coordinate("rrib8_Coord").setPoint(getrrib8_Coord_7_165_point()))))
        .addChild(new Shape("rrib9")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib9_Geo").setDEF("rrib9_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib9_Geo_6_170_coordIndex())
            .setCoord(new Coordinate("rrib9_Coord").setPoint(getrrib9_Coord_7_170_point()))))
        .addChild(new Shape("rrib10")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib10_Geo").setDEF("rrib10_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib10_Geo_6_175_coordIndex())
            .setCoord(new Coordinate("rrib10_Coord").setPoint(getrrib10_Coord_7_175_point()))))
        .addChild(new Shape("rrib11")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib11_Geo").setDEF("rrib11_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib11_Geo_6_180_coordIndex())
            .setCoord(new Coordinate("rrib11_Coord").setPoint(getrrib11_Coord_7_180_point()))))
        .addChild(new Shape("rrib12")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rrib12_Geo").setDEF("rrib12_Geo").setCreaseAngle(1.571).setCoordIndex(getrrib12_Geo_6_185_coordIndex())
            .setCoord(new Coordinate("rrib12_Coord").setPoint(getrrib12_Coord_7_185_point()))))
        .addChild(new Shape("rcartend")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("rcartend_Geo").setDEF("rcartend_Geo").setCreaseAngle(1.571).setCoordIndex(getrcartend_Geo_6_190_coordIndex())
            .setCoord(new Coordinate("rcartend_Coord").setPoint(getrcartend_Coord_7_190_point()))))
        .addChild(new Shape("rscapula")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.098).setDiffuseColor(1.0,.9765,.8667).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.349,.349,.349)))
          .setGeometry(new IndexedFaceSet("rscapula_Geo").setDEF("rscapula_Geo").setCreaseAngle(1.571).setCoordIndex(getrscapula_Geo_6_195_coordIndex())
            .setCoord(new Coordinate("rscapula_Coord").setPoint(getrscapula_Coord_7_195_point()))))
        .addChild(new Shape("rcoscart")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("rcoscart_Geo").setDEF("rcoscart_Geo").setCreaseAngle(1.571).setCoordIndex(getrcoscart_Geo_6_200_coordIndex())
            .setCoord(new Coordinate("rcoscart_Coord").setPoint(getrcoscart_Coord_7_200_point()))))
        .addChild(new Shape("rfreecrt")
          .setAppearance(new Appearance()
            .setMaterial(new Material().setAmbientIntensity(0.965).setDiffuseColor(.9843,.949,.7843).setEmissiveColor(1.0,1.0,0.0).setShininess(0.050).setSpecularColor(.9647,.949,.9098)))
          .setGeometry(new IndexedFaceSet("rfreecrt_Geo").setDEF("rfreecrt_Geo").setCreaseAngle(1.571).setCoordIndex(getrfreecrt_Geo_6_205_coordIndex())
            .setCoord(new Coordinate("rfreecrt_Coord").setPoint(getrfreecrt_Coord_7_205_point())))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type int[] */
		private int[] getsternum_Geo_6_15_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,6,9,7,-1,10,6,8,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,24,21,23,-1,23,25,24,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,33,34,35,-1,34,36,35,-1,37,38,39,-1,37,40,38,-1,41,29,42,-1,42,43,41,-1,44,45,46,-1,45,47,46,-1,37,39,48,-1,48,49,37,-1,50,19,51,-1,52,53,54,-1,54,55,52,-1,56,57,58,-1,56,59,57,-1,17,19,50,-1,60,61,62,-1,62,63,60,-1,52,64,65,-1,65,66,52,-1,54,53,67,-1,53,68,67,-1,69,54,70,-1,54,67,70,-1,71,11,72,-1,73,74,75,-1,76,77,78,-1,79,80,81,-1,80,82,81,-1,82,83,84,-1,82,85,83,-1,86,87,88,-1,89,90,91,-1,92,93,89,-1,94,95,93,-1,96,97,98,-1,99,100,101,-1,102,100,99,-1,102,103,104,-1,103,105,104,-1,106,105,107,-1,106,108,105,-1,106,107,109,-1,110,111,109,-1,112,113,114,-1,115,114,113,-1,81,116,117,-1,81,84,116,-1,77,76,118,-1,119,120,121,-1,122,123,124,-1,125,123,122,-1,126,127,128,-1,127,129,128,-1,130,131,132,-1,122,124,133,-1,133,134,122,-1,124,135,136,-1,136,133,124,-1,127,126,137,-1,138,139,140,-1,140,141,138,-1,142,143,144,-1,142,145,146,-1,147,146,148,-1,149,150,151,-1,152,153,154,-1,155,156,157,-1,158,159,160,-1,161,119,121,-1,121,162,161,-1,163,164,165,-1,166,167,168,-1,166,169,167,-1,170,171,172,-1,172,173,170,-1,174,4,175,-1,175,176,0,-1,176,177,0,-1,1,0,178,-1,0,177,178,-1,179,180,181,-1,180,182,183,-1,184,185,186,-1,185,187,186,-1,122,134,125,-1,188,143,189,-1,125,190,191,-1,192,193,194,-1,190,140,195,-1,195,191,190,-1,196,197,193,-1,197,194,193,-1,198,199,200,-1,198,201,199,-1,179,202,173,-1,173,172,179,-1,203,204,205,-1,203,206,204,-1,207,208,205,-1,207,209,208,-1,210,74,211,-1,212,213,207,-1,214,215,210,-1,210,216,214,-1,217,218,216,-1,219,74,220,-1,221,211,74,-1,182,209,213,-1,131,222,132,-1,223,224,225,-1,225,226,223,-1,191,227,125,-1,191,228,227,-1,229,230,231,-1,195,140,139,-1,139,232,195,-1,139,231,232,-1,233,229,231,-1,234,231,235,-1,145,148,146,-1,236,237,238,-1,239,147,148,-1,240,241,242,-1,243,239,244,-1,243,245,239,-1,246,151,150,-1,246,247,151,-1,239,148,244,-1,148,248,244,-1,249,250,251,-1,251,252,253,-1,253,254,251,-1,255,256,257,-1,258,244,248,-1,258,259,244,-1,260,261,262,-1,260,263,261,-1,264,265,266,-1,267,268,269,-1,268,270,269,-1,271,272,273,-1,274,275,276,-1,274,277,275,-1,278,279,280,-1,281,282,283,-1,284,285,286,-1,287,288,289,-1,289,290,287,-1,287,291,288,-1,287,292,291,-1,284,286,293,-1,286,294,293,-1,295,296,297,-1,298,299,290,-1,290,300,298,-1,301,302,303,-1,215,74,210,-1,73,304,74,-1,305,306,184,-1,307,212,305,-1,212,204,305,-1,138,231,139,-1,247,256,308,-1,308,309,247,-1,250,310,311,-1,311,312,250,-1,313,314,315,-1,313,297,314,-1,316,317,291,-1,318,283,282,-1,319,320,230,-1,230,229,319,-1,256,255,308,-1,249,310,250,-1,321,322,323,-1,322,324,323,-1,325,20,266,-1,20,326,266,-1,324,262,327,-1,324,260,262,-1,279,278,328,-1,329,322,321,-1,329,163,322,-1,161,18,330,-1,161,58,18,-1,271,331,272,-1,332,333,120,-1,120,119,332,-1,334,335,156,-1,336,337,338,-1,339,340,341,-1,339,342,340,-1,343,340,344,-1,345,327,346,-1,327,264,346,-1,165,343,347,-1,348,115,113,-1,349,350,9,-1,349,351,350,-1,155,352,353,-1,353,354,155,-1,355,356,357,-1,357,358,355,-1,359,360,159,-1,361,302,362,-1,280,363,278,-1,280,364,363,-1,365,366,367,-1,365,368,366,-1,369,370,371,-1,370,372,371,-1,308,255,258,-1,373,374,198,-1,375,376,377,-1,98,97,378,-1,97,379,378,-1,16,358,14,-1,16,380,358,-1,381,382,383,-1,382,384,383,-1,86,385,386,-1,386,387,86,-1,388,389,379,-1,389,378,379,-1,87,78,390,-1,391,392,359,-1,359,392,360,-1,160,159,393,-1,388,392,391,-1,394,395,396,-1,334,156,155,-1,366,397,398,-1,366,399,397,-1,400,158,160,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_2()
		{
			int[] value = {400,401,158,-1,90,89,93,-1,181,402,403,-1,181,183,402,-1,283,404,281,-1,283,405,404,-1,125,134,190,-1,156,406,359,-1,407,120,167,-1,407,121,120,-1,314,297,296,-1,408,405,409,-1,408,410,405,-1,411,410,412,-1,411,413,410,-1,414,415,416,-1,414,417,415,-1,416,285,284,-1,284,418,416,-1,237,419,420,-1,419,415,420,-1,420,417,421,-1,420,415,417,-1,191,193,422,-1,422,228,191,-1,164,329,423,-1,164,163,329,-1,424,339,341,-1,341,425,424,-1,426,427,428,-1,358,380,429,-1,429,355,358,-1,96,430,95,-1,98,431,96,-1,431,430,96,-1,432,433,289,-1,432,434,433,-1,149,144,435,-1,224,436,437,-1,436,438,437,-1,436,5,439,-1,436,440,5,-1,441,442,443,-1,444,445,446,-1,447,448,449,-1,447,450,448,-1,451,452,453,-1,451,454,452,-1,455,456,450,-1,450,457,455,-1,458,459,460,-1,448,450,456,-1,452,454,461,-1,462,463,464,-1,465,466,467,-1,468,469,470,-1,470,471,468,-1,469,472,473,-1,472,474,473,-1,468,471,475,-1,475,476,468,-1,477,478,479,-1,478,480,479,-1,481,482,483,-1,482,484,483,-1,485,486,487,-1,487,488,485,-1,477,479,489,-1,489,490,477,-1,491,480,492,-1,480,493,492,-1,486,485,481,-1,481,483,486,-1,465,494,495,-1,465,464,494,-1,496,497,498,-1,498,499,496,-1,500,501,502,-1,500,503,501,-1,504,505,506,-1,505,507,506,-1,463,462,508,-1,508,509,463,-1,510,511,512,-1,512,513,510,-1,503,512,514,-1,503,513,512,-1,499,515,504,-1,504,496,499,-1,494,464,463,-1,516,517,518,-1,519,520,521,-1,522,523,524,-1,522,525,523,-1,526,527,522,-1,526,528,527,-1,525,529,530,-1,531,532,533,-1,534,531,535,-1,536,534,537,-1,538,539,377,-1,538,540,539,-1,538,541,540,-1,542,543,544,-1,545,546,547,-1,547,548,545,-1,549,550,551,-1,551,552,553,-1,554,555,556,-1,555,557,556,-1,558,559,539,-1,539,560,558,-1,559,561,539,-1,562,563,564,-1,565,558,560,-1,565,566,558,-1,561,567,377,-1,568,569,570,-1,571,569,568,-1,572,573,574,-1,574,570,572,-1,544,575,576,-1,576,542,544,-1,577,578,579,-1,578,580,579,-1,581,582,583,-1,583,584,581,-1,585,586,587,-1,585,588,586,-1,575,578,577,-1,577,589,575,-1,589,590,591,-1,592,593,594,-1,577,579,590,-1,595,596,597,-1,594,598,599,-1,600,601,448,-1,602,603,604,-1,605,606,607,-1,608,609,610,-1,610,611,608,-1,609,612,613,-1,612,614,613,-1,615,616,617,-1,618,619,620,-1,621,611,610,-1,610,622,621,-1,623,611,624,-1,624,625,623,-1,626,627,610,-1,628,629,630,-1,630,622,628,-1,621,618,631,-1,610,627,622,-1,626,632,633,-1,629,628,634,-1,634,635,629,-1,636,637,638,-1,636,639,640,-1,641,638,642,-1,643,644,645,-1,645,646,643,-1,647,648,649,-1,647,650,648,-1,651,652,600,-1,600,448,651,-1,653,605,607,-1,654,655,656,-1,657,658,659,-1,658,660,659,-1,661,662,663,-1,663,664,665,-1,665,666,663,-1,523,525,667,-1,662,668,669,-1,669,668,441,-1,441,670,669,-1,671,672,673,-1,674,616,675,-1,674,614,616,-1,631,618,620,-1,676,637,677,-1,630,678,620,-1,679,680,681,-1,682,683,679,-1,683,680,679,-1,684,678,629,-1,678,630,629,-1,685,671,673,-1,686,687,688,-1,687,689,688,-1,690,691,692,-1,690,687,691,-1,688,693,694,-1,694,695,688,-1,520,696,521,-1,693,697,696,-1,693,698,697,-1,691,699,700,-1,696,520,701,-1,701,693,696,-1,702,670,703,-1,670,704,703,-1,521,703,705,-1,521,526,519,-1,662,661,706,-1,706,707,662,-1,700,685,692,-1,699,686,675,-1,686,708,675,-1,619,630,620,-1,709,684,635,-1,684,629,635,-1,710,711,615,-1,712,713,714,-1,715,640,639,-1,716,717,718,-1,640,715,643,-1,719,720,721,-1,722,715,723,-1,715,639,723,-1,724,725,726,-1,725,718,726,-1,721,727,728,-1,721,720,727,-1,729,730,725,-1,730,731,725,-1,730,732,733,-1,734,735,722,-1,734,736,735,-1,737,738,739,-1,740,741,742,-1,743,744,745,-1,746,747,748,-1,749,750,751,-1,750,752,751,-1,753,648,754,-1,648,755,754,-1,756,757,758,-1,759,760,761,-1,762,763,764,-1,762,765,763,-1,766,756,758,-1,758,767,766,-1,762,768,760,-1,760,765,762,-1,769,770,771,-1,771,772,769,-1,773,774,775,-1,776,768,777,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_3()
		{
			int[] value = {777,778,776,-1,779,780,781,-1,521,696,697,-1,702,521,782,-1,661,783,706,-1,661,666,783,-1,712,635,634,-1,733,728,727,-1,733,784,728,-1,739,785,723,-1,723,786,739,-1,766,774,787,-1,787,788,766,-1,765,789,763,-1,790,757,756,-1,671,685,711,-1,711,625,671,-1,622,627,628,-1,680,636,681,-1,791,779,777,-1,787,774,773,-1,749,792,754,-1,792,793,754,-1,794,795,507,-1,507,655,794,-1,740,796,797,-1,740,798,796,-1,799,752,508,-1,752,750,508,-1,800,801,792,-1,800,747,801,-1,802,745,744,-1,509,755,650,-1,755,648,650,-1,802,793,803,-1,803,745,802,-1,800,748,747,-1,804,606,605,-1,593,805,571,-1,593,592,805,-1,806,807,572,-1,572,603,806,-1,808,516,518,-1,809,810,811,-1,811,812,809,-1,603,570,813,-1,603,572,570,-1,814,742,741,-1,532,815,533,-1,536,562,532,-1,536,563,562,-1,816,817,818,-1,591,590,819,-1,819,584,591,-1,804,820,606,-1,820,821,606,-1,822,823,824,-1,824,825,822,-1,826,743,827,-1,826,744,743,-1,645,644,726,-1,726,828,645,-1,829,830,831,-1,732,784,733,-1,832,833,668,-1,833,442,668,-1,818,834,835,-1,447,449,458,-1,836,837,838,-1,838,839,836,-1,393,360,840,-1,821,840,607,-1,400,841,396,-1,842,843,844,-1,842,845,843,-1,708,846,674,-1,847,848,849,-1,847,850,848,-1,628,627,626,-1,833,851,852,-1,636,680,637,-1,712,853,854,-1,855,856,823,-1,856,820,804,-1,805,857,810,-1,857,811,810,-1,647,858,859,-1,860,848,861,-1,848,862,861,-1,863,864,865,-1,863,866,864,-1,850,867,868,-1,867,869,868,-1,870,871,872,-1,872,721,870,-1,530,873,874,-1,530,875,873,-1,876,877,878,-1,877,879,878,-1,880,881,882,-1,883,884,885,-1,883,886,884,-1,676,642,637,-1,642,638,637,-1,887,888,889,-1,887,874,888,-1,740,742,798,-1,890,548,891,-1,890,825,548,-1,448,456,651,-1,377,567,97,-1,892,559,558,-1,893,894,658,-1,761,758,895,-1,758,896,895,-1,897,646,645,-1,897,898,646,-1,899,681,646,-1,681,640,646,-1,678,679,899,-1,899,900,678,-1,901,902,903,-1,901,707,902,-1,646,640,643,-1,758,757,896,-1,757,904,896,-1,905,906,567,-1,907,461,908,-1,908,909,907,-1,910,827,911,-1,912,913,914,-1,914,915,912,-1,916,660,894,-1,916,917,660,-1,677,918,919,-1,919,676,677,-1,920,921,922,-1,922,923,920,-1,922,924,719,-1,922,921,924,-1,850,847,789,-1,789,867,850,-1,867,920,869,-1,867,921,920,-1,863,862,866,-1,863,861,862,-1,925,861,926,-1,925,860,861,-1,773,771,787,-1,809,812,927,-1,812,839,927,-1,607,606,821,-1,871,870,641,-1,641,642,871,-1,633,632,928,-1,849,848,929,-1,848,860,929,-1,613,674,846,-1,613,614,674,-1,553,930,551,-1,160,841,400,-1,160,931,841,-1,932,399,933,-1,932,397,399,-1,834,821,934,-1,396,935,394,-1,653,392,388,-1,393,840,160,-1,360,392,607,-1,607,392,653,-1,890,822,825,-1,379,556,388,-1,379,554,556,-1,936,546,545,-1,545,937,936,-1,452,907,938,-1,452,461,907,-1,554,379,939,-1,379,97,939,-1,377,539,561,-1,940,833,832,-1,739,738,785,-1,933,941,942,-1,942,943,933,-1,944,649,648,-1,944,945,649,-1,780,779,791,-1,840,360,607,-1,454,946,908,-1,908,461,454,-1,947,834,818,-1,818,817,947,-1,595,588,581,-1,657,857,658,-1,948,742,949,-1,742,814,949,-1,805,592,857,-1,915,592,594,-1,594,912,915,-1,444,950,445,-1,821,820,934,-1,812,951,654,-1,812,811,951,-1,748,800,751,-1,802,754,793,-1,802,753,754,-1,655,507,656,-1,507,505,656,-1,952,659,917,-1,659,660,917,-1,802,944,753,-1,814,741,953,-1,741,954,953,-1,955,956,794,-1,956,795,794,-1,811,657,951,-1,811,857,657,-1,729,957,732,-1,785,738,734,-1,714,682,684,-1,684,709,714,-1,958,929,790,-1,760,759,765,-1,788,787,770,-1,787,771,770,-1,724,729,725,-1,724,957,729,-1,785,734,722,-1,722,723,785,-1,959,712,634,-1,673,692,685,-1,673,690,692,-1,672,706,673,-1,521,705,528,-1,665,521,697,-1,777,779,778,-1,767,774,766,-1,767,775,774,-1,771,773,772,-1,788,770,790,-1,770,958,790,-1,960,763,847,-1,960,764,763,-1,761,768,776,-1,761,760,768,-1,767,758,761,-1,761,776,767,-1,763,789,847,-1,929,958,849,-1,648,753,944,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_4()
		{
			int[] value = {754,750,749,-1,754,755,750,-1,752,748,751,-1,747,961,801,-1,747,746,961,-1,955,798,742,-1,741,740,954,-1,740,797,954,-1,786,962,739,-1,962,737,739,-1,736,734,738,-1,727,731,730,-1,730,733,727,-1,730,729,732,-1,962,963,870,-1,962,786,963,-1,644,715,735,-1,715,722,735,-1,962,870,721,-1,721,728,962,-1,718,717,726,-1,963,641,870,-1,720,719,716,-1,638,963,639,-1,713,712,854,-1,712,709,635,-1,853,712,959,-1,959,964,965,-1,965,853,959,-1,712,714,709,-1,928,919,918,-1,928,966,919,-1,620,967,631,-1,620,968,967,-1,615,617,969,-1,700,699,675,-1,970,782,521,-1,703,521,702,-1,666,661,663,-1,703,971,705,-1,703,704,971,-1,665,697,698,-1,698,666,665,-1,691,700,692,-1,664,521,665,-1,686,699,691,-1,691,687,686,-1,687,783,689,-1,687,690,783,-1,972,695,694,-1,972,878,695,-1,677,683,973,-1,677,680,683,-1,965,964,633,-1,633,918,965,-1,679,678,682,-1,678,684,682,-1,680,677,637,-1,918,633,928,-1,679,681,899,-1,928,632,974,-1,671,624,672,-1,671,625,624,-1,674,675,708,-1,846,708,695,-1,529,971,975,-1,529,527,971,-1,971,443,975,-1,971,704,443,-1,443,670,441,-1,443,704,670,-1,441,668,442,-1,701,972,694,-1,694,693,701,-1,810,976,569,-1,810,809,976,-1,658,894,660,-1,654,656,836,-1,836,839,654,-1,160,840,931,-1,977,821,834,-1,396,978,935,-1,396,841,978,-1,859,650,647,-1,715,644,643,-1,963,638,641,-1,638,639,636,-1,640,681,636,-1,964,959,634,-1,634,628,964,-1,630,619,622,-1,610,979,626,-1,610,609,979,-1,626,974,632,-1,626,979,974,-1,615,969,710,-1,618,622,619,-1,618,621,622,-1,974,980,928,-1,979,980,974,-1,608,981,609,-1,981,612,609,-1,839,812,654,-1,855,823,982,-1,536,532,534,-1,532,531,534,-1,595,586,588,-1,586,595,597,-1,590,589,577,-1,590,579,983,-1,579,580,983,-1,580,574,983,-1,568,578,571,-1,568,580,578,-1,544,593,571,-1,543,593,544,-1,939,97,567,-1,553,905,559,-1,930,553,984,-1,985,551,930,-1,548,825,545,-1,599,598,535,-1,535,531,599,-1,534,542,537,-1,534,535,542,-1,822,982,823,-1,522,527,525,-1,527,529,525,-1,526,521,528,-1,459,458,453,-1,986,498,497,-1,986,987,498,-1,987,502,498,-1,987,988,502,-1,989,501,503,-1,503,514,989,-1,990,991,500,-1,500,992,990,-1,465,506,466,-1,505,515,993,-1,505,504,515,-1,499,502,501,-1,499,498,502,-1,495,506,465,-1,994,995,478,-1,478,470,994,-1,487,996,488,-1,487,997,996,-1,998,489,479,-1,479,999,998,-1,1000,1001,1002,-1,1002,1003,1000,-1,1004,36,1005,-1,36,34,1005,-1,32,1006,30,-1,1007,490,489,-1,489,1008,1007,-1,462,1009,1010,-1,1010,1011,462,-1,462,464,1009,-1,506,507,466,-1,507,795,466,-1,938,1012,452,-1,460,447,458,-1,517,445,454,-1,454,451,517,-1,446,1013,1014,-1,446,516,1013,-1,516,808,1013,-1,707,668,662,-1,875,975,443,-1,189,1015,1016,-1,1016,188,189,-1,435,143,188,-1,435,144,143,-1,370,435,372,-1,435,1017,372,-1,1018,432,288,-1,432,289,288,-1,165,164,1019,-1,1020,94,1021,-1,97,96,377,-1,1022,1023,1024,-1,381,87,390,-1,381,88,87,-1,265,264,261,-1,1025,1026,1027,-1,1027,1028,1025,-1,1029,1030,1031,-1,1029,1032,1030,-1,882,881,1033,-1,202,1034,1035,-1,1034,1036,1035,-1,1026,1037,1038,-1,1037,2,1038,-1,1039,1040,245,-1,1040,239,245,-1,414,416,418,-1,418,1041,414,-1,865,411,412,-1,865,864,411,-1,410,404,405,-1,410,413,404,-1,154,1042,152,-1,168,333,344,-1,333,343,344,-1,1043,335,1044,-1,76,1044,118,-1,234,232,231,-1,192,194,142,-1,1045,1046,374,-1,133,1047,141,-1,281,418,284,-1,281,404,418,-1,183,181,180,-1,1048,1049,1050,-1,1048,1051,1049,-1,94,92,1021,-1,94,93,92,-1,396,401,400,-1,359,159,156,-1,159,360,393,-1,1052,162,121,-1,1052,1053,162,-1,11,1054,12,-1,1055,1056,385,-1,1056,386,385,-1,1057,155,354,-1,4,174,373,-1,174,374,373,-1,254,1058,249,-1,831,830,1059,-1,240,150,369,-1,150,370,369,-1,1039,245,237,-1,237,420,1039,-1,1060,78,87,-1,1060,76,78,-1,406,335,1043,-1,406,156,335,-1,1061,109,1062,-1,1062,1063,1061,-1,354,353,1064,-1,1065,1066,117,-1,117,116,1065,-1,1067,1068,116,-1,262,264,327,-1,1069,1070,1071,-1,1069,1072,1070,-1,333,168,120,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_5()
		{
			int[] value = {168,167,120,-1,101,100,85,-1,100,342,85,-1,350,7,9,-1,1070,1073,1074,-1,1074,1071,1070,-1,344,340,100,-1,100,102,344,-1,1075,406,1043,-1,269,272,331,-1,1076,1077,328,-1,328,1078,1076,-1,280,275,1079,-1,1079,153,280,-1,1080,1078,328,-1,345,324,327,-1,345,323,324,-1,1081,267,331,-1,267,269,331,-1,1082,273,1083,-1,1082,277,273,-1,263,1084,261,-1,1084,265,261,-1,332,1084,263,-1,332,119,1084,-1,18,20,325,-1,325,330,18,-1,276,1081,274,-1,276,1077,1081,-1,296,298,314,-1,303,302,361,-1,143,142,194,-1,141,1047,127,-1,1085,307,187,-1,307,186,187,-1,1086,433,318,-1,286,285,316,-1,314,298,300,-1,300,315,314,-1,253,1058,254,-1,253,243,1058,-1,138,233,231,-1,306,216,218,-1,306,206,216,-1,1087,74,219,-1,215,1088,74,-1,1089,362,302,-1,303,292,287,-1,287,301,303,-1,299,298,296,-1,297,313,1090,-1,1090,295,297,-1,1090,313,281,-1,313,282,281,-1,291,292,1091,-1,1091,316,291,-1,1086,300,290,-1,290,289,1086,-1,294,286,1091,-1,286,316,1091,-1,288,291,317,-1,289,433,1086,-1,275,280,279,-1,279,276,275,-1,271,277,274,-1,271,273,277,-1,272,269,270,-1,1092,268,267,-1,267,1076,1092,-1,1078,1080,1093,-1,264,262,261,-1,258,255,259,-1,247,246,256,-1,246,257,256,-1,254,249,251,-1,312,251,250,-1,312,252,251,-1,243,238,245,-1,243,253,238,-1,309,151,247,-1,309,145,151,-1,245,238,237,-1,149,151,144,-1,242,241,236,-1,145,144,151,-1,230,235,231,-1,132,1085,130,-1,233,1094,319,-1,319,229,233,-1,125,1095,123,-1,125,227,1095,-1,226,1016,1015,-1,226,225,1016,-1,226,137,126,-1,182,208,209,-1,182,180,208,-1,212,307,213,-1,306,218,3,-1,3,5,306,-1,1096,75,74,-1,304,220,74,-1,220,177,219,-1,177,176,219,-1,170,1097,1088,-1,1088,171,170,-1,213,209,207,-1,1088,215,171,-1,215,214,171,-1,74,1088,1097,-1,207,205,204,-1,204,212,207,-1,1098,205,208,-1,1098,203,205,-1,305,186,307,-1,1094,137,319,-1,137,1015,319,-1,189,197,320,-1,189,194,197,-1,193,195,196,-1,193,191,195,-1,143,194,189,-1,226,1015,137,-1,193,192,422,-1,226,128,223,-1,182,1099,183,-1,1099,402,183,-1,305,184,186,-1,176,4,1100,-1,176,175,4,-1,4,3,217,-1,1101,1102,1103,-1,210,211,217,-1,217,216,210,-1,217,3,218,-1,161,330,119,-1,359,1075,391,-1,1104,1022,1024,-1,1104,1105,1022,-1,364,153,152,-1,364,280,153,-1,370,150,149,-1,149,435,370,-1,1106,146,147,-1,144,145,142,-1,146,192,142,-1,138,141,1094,-1,1094,233,138,-1,190,134,133,-1,127,1047,136,-1,223,128,129,-1,137,1094,141,-1,141,127,137,-1,136,1047,133,-1,185,1107,1108,-1,1108,187,185,-1,136,1107,129,-1,129,127,136,-1,226,126,128,-1,222,1099,132,-1,403,1109,135,-1,403,402,1109,-1,1110,1107,136,-1,136,135,1110,-1,359,406,1075,-1,1111,1071,1112,-1,1024,1113,1104,-1,83,85,342,-1,112,1114,113,-1,109,107,110,-1,342,100,340,-1,1062,109,111,-1,114,115,1115,-1,1115,1116,114,-1,1117,1118,348,-1,348,1063,1117,-1,80,1119,99,-1,80,1120,1119,-1,1115,10,8,-1,8,1116,1115,-1,1121,1070,1072,-1,1072,108,1121,-1,104,166,102,-1,1072,166,104,-1,377,96,375,-1,1122,1123,1124,-1,1122,1020,1123,-1,1125,1066,1065,-1,376,375,94,-1,376,1020,1122,-1,376,94,1020,-1,389,1126,378,-1,389,1127,1126,-1,93,1128,90,-1,90,1055,1129,-1,1130,385,86,-1,86,88,1130,-1,99,101,80,-1,377,376,538,-1,376,541,538,-1,376,1131,541,-1,79,81,117,-1,82,84,81,-1,1067,116,84,-1,1038,1132,1102,-1,1133,1134,75,-1,1134,73,75,-1,1135,1103,1133,-1,1103,1102,1133,-1,74,1097,1096,-1,350,1136,7,-1,1137,22,1138,-1,59,55,1139,-1,1139,57,59,-1,65,1140,66,-1,65,1141,1140,-1,1141,510,1140,-1,1141,511,510,-1,1082,23,1137,-1,1137,1079,1082,-1,19,58,57,-1,19,18,58,-1,53,52,66,-1,66,60,53,-1,55,69,1139,-1,55,54,69,-1,51,1138,50,-1,1138,22,50,-1,1142,1143,1144,-1,1142,1145,1143,-1,1146,1147,1148,-1,1148,1149,1146,-1,1150,40,1151,-1,1150,38,40,-1,29,41,1152,-1,1152,27,29,-1,46,1147,44,-1,1147,1146,44,-1,484,482,1149,-1,1149,1148,484,-1,41,37,1152,-1,41,40,37,-1,1153,1154,1155,-1,1155,1156,1153,-1,1157,1158,1159,-1,1159,1160,1157,-1,1161,17,50,-1,22,1137,23,-1,358,357,14,-1,1023,1162,1024,-1,13,72,11,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_6()
		{
			int[] value = {1023,1163,1164,-1,1164,1162,1023,-1,71,14,357,-1,357,1165,71,-1,1024,1162,12,-1,12,1054,1024,-1,9,1113,349,-1,9,6,1113,-1,8,336,338,-1,0,174,175,-1,1166,1167,1168,-1,1169,1170,1171,-1,1171,1172,1169,-1,1173,1174,1175,-1,1173,1176,1174,-1,1177,442,833,-1,1177,1178,442,-1,1179,833,852,-1,1179,1177,833,-1,1180,1181,1182,-1,1180,1183,1181,-1,1184,1185,1186,-1,1187,1188,1189,-1,1188,1190,1189,-1,1191,1192,1193,-1,1193,1194,1191,-1,1195,1193,1196,-1,1197,1198,1199,-1,1197,1200,1198,-1,1201,1202,1182,-1,1202,1180,1182,-1,1199,1203,1204,-1,1203,1205,1204,-1,1175,1206,1173,-1,1207,1208,1209,-1,1208,1210,1209,-1,1211,1212,1213,-1,1214,1215,1216,-1,1217,1193,1187,-1,1217,1218,1193,-1,1193,1195,1194,-1,1219,1220,1214,-1,1219,1221,1220,-1,875,443,1171,-1,1197,1181,1169,-1,1181,1170,1169,-1,1215,1222,1185,-1,1181,1197,1182,-1,1197,1199,1182,-1,1223,1224,1195,-1,1195,1196,1223,-1,1225,1226,1227,-1,1222,1218,1186,-1,1186,1185,1222,-1,1228,1190,1229,-1,1217,1187,1230,-1,1187,1189,1230,-1,1231,1232,1233,-1,1190,1188,1229,-1,1234,1190,1235,-1,1236,1237,1167,-1,1196,1193,1218,-1,1218,1222,1196,-1,1215,1214,1223,-1,1166,1168,1204,-1,1204,1205,1166,-1,1037,1201,1238,-1,1037,1202,1201,-1,1203,1199,1198,-1,1170,1183,873,-1,1170,1181,1183,-1,1169,1200,1197,-1,1169,1239,1200,-1,1227,1239,1176,-1,1176,1228,1227,-1,1172,1171,1174,-1,1171,1178,1174,-1,1240,1167,1166,-1,1224,1205,1195,-1,1205,1203,1195,-1,1214,1216,1219,-1,1214,1220,1224,-1,1241,1207,1242,-1,1207,1209,1242,-1,1173,1235,1176,-1,1212,1206,1179,-1,1179,1243,1212,-1,1182,1204,1201,-1,1182,1199,1204,-1,1214,1224,1223,-1,1211,1244,1234,-1,1211,1213,1244,-1,1191,1194,1198,-1,1245,1045,1242,-1,1242,1243,1245,-1,174,1236,1246,-1,174,0,1236,-1,1175,1174,1178,-1,1178,1177,1175,-1,1246,374,174,-1,1246,1241,374,-1,1169,1172,1239,-1,1113,1054,349,-1,1113,1024,1054,-1,13,1162,1164,-1,12,1162,13,-1,14,72,15,-1,72,14,71,-1,357,1136,1165,-1,357,336,1136,-1,16,1164,1163,-1,16,15,1164,-1,1083,23,1082,-1,23,1083,25,-1,1153,1247,1248,-1,1153,1156,1247,-1,346,1157,1160,-1,326,1157,346,-1,1161,22,21,-1,1161,50,22,-1,1159,24,1155,-1,1158,24,1159,-1,345,39,323,-1,48,39,345,-1,1156,24,25,-1,1155,24,1156,-1,49,1160,1159,-1,49,48,1160,-1,1248,27,1153,-1,27,1248,28,-1,1149,1249,1146,-1,1249,1149,33,-1,1144,44,1142,-1,1144,45,44,-1,41,1151,40,-1,41,43,1151,-1,31,484,1148,-1,31,30,484,-1,1147,428,1250,-1,46,428,1147,-1,47,1251,426,-1,47,42,1251,-1,38,329,321,-1,38,1150,329,-1,423,1145,1252,-1,423,1143,1145,-1,35,1050,1253,-1,1050,35,1048,-1,1254,428,427,-1,1254,1250,428,-1,1142,1253,1145,-1,1142,1249,1253,-1,1151,1143,1150,-1,1151,1144,1143,-1,1253,33,35,-1,1253,1249,33,-1,69,51,1139,-1,1138,51,69,-1,1140,60,66,-1,1140,61,60,-1,154,70,67,-1,154,153,70,-1,68,1255,1042,-1,68,63,1255,-1,62,1256,1257,-1,1258,1256,62,-1,1259,65,1260,-1,1259,1141,65,-1,59,1261,64,-1,1261,59,56,-1,1262,62,61,-1,1262,1258,62,-1,1139,19,57,-1,1139,51,19,-1,1138,70,1137,-1,69,70,1138,-1,1097,1135,1096,-1,1135,1097,170,-1,1101,173,202,-1,1101,1103,173,-1,1132,1133,1102,-1,1132,1134,1133,-1,1026,1102,1027,-1,1026,1038,1102,-1,1101,1035,1263,-1,1035,1101,202,-1,881,1264,1265,-1,881,1266,1264,-1,1122,1131,376,-1,1122,1267,1131,-1,1268,1269,1124,-1,1268,1270,1269,-1,84,1271,1067,-1,84,83,1271,-1,1129,385,1130,-1,1129,1055,385,-1,1272,389,1075,-1,1272,1127,389,-1,1128,431,1056,-1,1128,430,431,-1,1273,1274,1275,-1,1273,1068,1274,-1,1019,1276,1277,-1,1276,1019,164,-1,1278,1279,1280,-1,1279,1278,1277,-1,1269,1281,1267,-1,1281,1269,1282,-1,1020,1283,1123,-1,1020,1021,1283,-1,92,1284,1285,-1,92,89,1284,-1,1065,1068,1273,-1,1065,116,1068,-1,1286,8,338,-1,1286,1116,8,-1,1121,1073,1070,-1,1121,1287,1073,-1,1120,79,1117,-1,1120,80,79,-1,1115,1288,10,-1,1115,1118,1288,-1,104,108,1072,-1,104,105,108,-1,348,1061,1063,-1,348,113,1061,-1,1114,1286,1287,-1,112,1286,1114,-1,1289,108,106,-1,1289,1121,108,-1,1117,1062,1120,-1,1062,1117,1063,-1,115,1118,1115,-1,348,1118,115,-1,1120,111,1119,-1,1120,1062,111,-1,106,1061,1289,-1,106,109,1061,-1,1290,1113,1125,-1,1290,1104,1113,-1,11,349,1054,-1,11,351,349,-1,1069,1111,1291,-1,1069,1071,1111,-1,1074,1112,1071,-1,1074,1292,1112,-1,1293,135,1109,-1,135,1293,1110,-1,402,222,1109,-1,402,1099,222,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_7()
		{
			int[] value = {1108,131,130,-1,1293,131,1108,-1,1107,1293,1108,-1,1107,1110,1293,-1,1107,223,129,-1,185,223,1107,-1,141,190,133,-1,140,190,141,-1,1279,1051,1294,-1,1051,1279,1049,-1,1022,1284,1295,-1,1105,1284,1022,-1,1281,1296,1297,-1,1296,1281,1280,-1,89,1295,1284,-1,89,91,1295,-1,76,1272,1044,-1,76,1060,1272,-1,389,391,1075,-1,389,388,391,-1,401,395,1298,-1,395,401,396,-1,178,1132,1,-1,178,1134,1132,-1,403,1034,181,-1,123,1034,403,-1,320,1015,189,-1,320,319,1015,-1,199,438,200,-1,1299,438,199,-1,179,208,180,-1,179,1098,208,-1,171,203,1098,-1,171,214,203,-1,1133,1096,1135,-1,1096,1133,75,-1,220,178,177,-1,304,178,220,-1,1087,176,1100,-1,219,176,1087,-1,74,1300,221,-1,1300,74,1087,-1,213,1085,132,-1,1085,213,307,-1,204,306,305,-1,204,206,306,-1,235,196,234,-1,235,197,196,-1,240,246,150,-1,246,240,311,-1,252,238,253,-1,238,252,236,-1,330,1084,119,-1,330,325,1084,-1,1093,1076,1078,-1,1093,1092,1076,-1,284,1090,281,-1,1090,284,293,-1,315,282,313,-1,318,282,315,-1,362,293,294,-1,362,1089,293,-1,259,243,244,-1,259,1058,243,-1,361,294,1091,-1,361,362,294,-1,299,287,290,-1,299,301,287,-1,130,187,1108,-1,130,1085,187,-1,316,1301,317,-1,316,1302,1301,-1,299,302,301,-1,299,296,302,-1,277,1079,275,-1,1082,1079,277,-1,1076,1081,1077,-1,1076,267,1081,-1,260,322,347,-1,322,260,324,-1,343,332,347,-1,332,343,333,-1,331,274,1081,-1,274,331,271,-1,28,270,268,-1,28,1248,270,-1,279,1077,276,-1,1077,279,328,-1,1074,338,337,-1,338,1074,1073,-1,10,1066,6,-1,1288,1066,10,-1,1069,166,1072,-1,166,1069,169,-1,326,264,266,-1,346,264,326,-1,328,1303,1080,-1,328,1304,1303,-1,1125,1273,1290,-1,1125,1065,1273,-1,336,356,337,-1,357,356,336,-1,1292,1305,1112,-1,1305,1292,1306,-1,1057,334,155,-1,334,1057,1307,-1,1272,1043,1044,-1,1272,1075,1043,-1,1308,1309,1310,-1,1311,1309,1308,-1,1312,1310,1309,-1,1312,1313,1310,-1,1018,1310,1314,-1,1018,1308,1310,-1,1315,427,1316,-1,1254,427,1315,-1,365,152,1317,-1,365,364,152,-1,1318,1319,1320,-1,1321,1319,1318,-1,1039,421,1322,-1,421,1039,420,-1,371,1323,1059,-1,371,372,1323,-1,249,259,255,-1,249,1058,259,-1,1324,1059,830,-1,1059,1324,371,-1,240,1325,241,-1,369,1325,240,-1,1299,437,438,-1,1299,1326,437,-1,1327,1328,1017,-1,1329,1328,1327,-1,1330,1331,1332,-1,1330,1333,1331,-1,1334,1016,225,-1,1334,1335,1016,-1,1336,201,1046,-1,201,1336,1337,-1,1124,1274,1268,-1,1123,1274,1124,-1,1275,1290,1273,-1,1338,1290,1275,-1,1339,1130,383,-1,1339,1129,1130,-1,1023,384,1163,-1,1023,1340,384,-1,1341,1342,1343,-1,1342,1341,1344,-1,1345,121,407,-1,1345,1052,121,-1,1346,1064,1347,-1,1346,1291,1064,-1,1305,1348,1307,-1,1306,1348,1305,-1,1349,1298,395,-1,1298,1349,352,-1,1350,1255,1257,-1,1317,1255,1350,-1,1351,1257,1256,-1,1257,1351,1350,-1,1352,1341,1353,-1,1352,1344,1341,-1,1354,1332,1326,-1,1332,1354,1330,-1,1355,1328,1356,-1,1323,1328,1355,-1,1357,1025,1028,-1,1025,1357,1358,-1,147,1040,1106,-1,147,239,1040,-1,1359,328,278,-1,328,1359,1304,-1,1317,1042,1255,-1,1317,152,1042,-1,352,1360,353,-1,1349,1360,352,-1,1053,1260,1261,-1,1260,1053,1343,-1,1360,1345,1347,-1,1345,1360,1353,-1,1057,1064,1361,-1,1057,354,1064,-1,118,429,77,-1,429,118,1348,-1,1111,1305,1361,-1,1111,1112,1305,-1,1346,167,169,-1,1346,407,167,-1,1317,368,365,-1,1317,1350,368,-1,278,409,1359,-1,409,278,363,-1,367,398,408,-1,367,366,398,-1,1362,1363,1364,-1,1362,1365,1363,-1,411,1366,1367,-1,411,864,1366,-1,414,1367,1364,-1,414,1041,1367,-1,418,413,1041,-1,404,413,418,-1,1029,1040,1368,-1,1029,1106,1040,-1,1369,1322,1320,-1,1322,1369,1368,-1,1363,1321,1318,-1,1363,1365,1321,-1,1369,1370,1032,-1,1370,1369,1371,-1,1372,1373,1374,-1,1372,1375,1373,-1,1030,1376,1031,-1,1376,1030,1374,-1,1373,1377,1378,-1,1377,1373,1379,-1,1263,1102,1101,-1,1263,1027,1102,-1,1380,1033,1379,-1,882,1033,1380,-1,1381,1379,1033,-1,1381,1377,1379,-1,1034,1095,1036,-1,1034,123,1095,-1,1032,1382,1030,-1,1032,1370,1382,-1,1029,422,1106,-1,1029,1031,422,-1,1378,228,1376,-1,227,228,1378,-1,1377,1036,1095,-1,1036,1377,1381,-1,1264,1027,1263,-1,1027,1264,1028,-1,1266,1028,1264,-1,1266,1357,1028,-1,1104,1338,1105,-1,1104,1290,1338,-1,86,1060,87,-1,1060,86,387,-1,382,390,1383,-1,382,381,390,-1,1340,91,1339,-1,1295,91,1340,-1,1105,1285,1284,-1,1105,1338,1285,-1,1131,1384,541,-1,1131,1297,1384,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_8()
		{
			int[] value = {1123,1275,1274,-1,1275,1123,1283,-1,424,1278,1282,-1,424,425,1278,-1,1296,1385,1386,-1,1296,1294,1385,-1,1294,1387,1385,-1,1051,1387,1294,-1,1252,164,423,-1,1276,164,1252,-1,1080,1388,1316,-1,1388,1080,1303,-1,1302,237,236,-1,419,237,1302,-1,1316,1389,1315,-1,1389,1316,1388,-1,1390,432,1391,-1,1390,434,432,-1,1311,1324,1309,-1,1325,1324,1311,-1,1391,1392,1393,-1,1391,1314,1392,-1,1394,1389,1390,-1,1389,1394,1395,-1,1328,372,1017,-1,372,1328,1323,-1,1335,1329,1327,-1,1331,1329,1335,-1,1327,1016,1335,-1,188,1016,1327,-1,200,373,198,-1,200,439,373,-1,1337,199,201,-1,1337,1396,199,-1,1183,874,873,-1,1183,888,874,-1,445,516,446,-1,516,445,517,-1,1013,1397,601,-1,1397,1013,808,-1,460,1012,457,-1,459,1012,460,-1,1398,1011,476,-1,1398,799,1011,-1,473,949,994,-1,473,948,949,-1,956,466,795,-1,956,474,466,-1,1009,472,1010,-1,472,1009,467,-1,477,470,478,-1,477,471,470,-1,467,474,472,-1,467,466,474,-1,34,481,1005,-1,34,482,481,-1,1001,488,1002,-1,1001,485,488,-1,999,1399,996,-1,999,491,1399,-1,486,1006,1400,-1,483,1006,486,-1,910,997,487,-1,910,911,997,-1,998,1008,489,-1,998,1401,1008,-1,1402,493,995,-1,1402,952,493,-1,1403,917,916,-1,492,917,1403,-1,1003,842,1000,-1,842,1003,1404,-1,1405,1004,844,-1,1405,36,1004,-1,1405,843,1387,-1,843,1405,844,-1,1404,845,842,-1,1406,845,1404,-1,999,997,998,-1,999,996,997,-1,475,477,490,-1,475,471,477,-1,1002,1403,1003,-1,1399,1403,1002,-1,1262,513,991,-1,513,1262,510,-1,988,859,858,-1,987,859,988,-1,992,1407,990,-1,992,1408,1407,-1,650,463,509,-1,986,463,650,-1,511,1409,512,-1,1409,511,1410,-1,1411,514,1412,-1,514,1411,989,-1,502,992,500,-1,502,988,992,-1,515,501,989,-1,499,501,515,-1,701,523,972,-1,701,524,523,-1,888,1180,1358,-1,1183,1180,888,-1,1413,1414,876,-1,1413,1415,1414,-1,1416,565,560,-1,1416,1417,565,-1,1418,533,1419,-1,1418,1420,533,-1,555,1421,936,-1,555,1422,1421,-1,552,905,553,-1,552,906,905,-1,845,1423,1424,-1,1406,1423,845,-1,1425,1426,1427,-1,1428,1426,1425,-1,892,1429,984,-1,1430,1429,892,-1,1421,551,550,-1,552,551,1421,-1,1431,807,444,-1,807,1431,1432,-1,578,544,571,-1,544,578,575,-1,583,1433,537,-1,1433,583,582,-1,1014,587,446,-1,1014,585,587,-1,587,597,1431,-1,587,586,597,-1,1434,1432,596,-1,1434,573,1432,-1,805,569,571,-1,569,805,810,-1,912,599,1420,-1,594,599,912,-1,453,1435,451,-1,453,458,1435,-1,950,1436,946,-1,1436,950,806,-1,609,980,979,-1,609,613,980,-1,505,836,656,-1,993,836,505,-1,1437,1425,1438,-1,1424,1425,1437,-1,1439,1416,540,-1,1427,1416,1439,-1,938,1440,1441,-1,907,1440,938,-1,518,451,1435,-1,518,517,451,-1,978,931,977,-1,841,931,978,-1,977,840,821,-1,977,931,840,-1,915,857,592,-1,857,915,658,-1,530,975,875,-1,529,975,530,-1,1442,662,669,-1,1442,663,662,-1,706,902,707,-1,706,672,902,-1,631,672,624,-1,672,631,902,-1,973,918,677,-1,973,965,918,-1,1443,1444,1445,-1,1396,1444,1443,-1,1446,903,1447,-1,1446,901,903,-1,698,783,666,-1,698,689,783,-1,527,705,971,-1,705,527,528,-1,970,669,782,-1,669,1448,1442,-1,669,970,1448,-1,1442,664,663,-1,1448,664,1442,-1,675,615,700,-1,616,615,675,-1,678,968,620,-1,678,900,968,-1,1449,928,980,-1,1449,966,928,-1,682,713,683,-1,713,682,714,-1,854,965,973,-1,853,965,854,-1,718,731,716,-1,731,718,725,-1,963,723,639,-1,963,786,723,-1,657,797,951,-1,954,797,657,-1,798,794,796,-1,798,955,794,-1,803,961,1450,-1,801,961,803,-1,788,756,766,-1,788,790,756,-1,849,770,769,-1,849,958,770,-1,846,878,879,-1,846,695,878,-1,736,724,735,-1,736,957,724,-1,772,960,769,-1,772,781,960,-1,791,768,762,-1,791,777,768,-1,957,738,732,-1,957,736,738,-1,716,1451,717,-1,716,1452,1451,-1,1450,1007,1008,-1,961,1007,1450,-1,654,797,796,-1,797,654,951,-1,1402,814,953,-1,814,1402,949,-1,1450,1401,743,-1,1450,1008,1401,-1,536,1433,563,-1,536,537,1433,-1,593,598,594,-1,598,593,543,-1,543,535,598,-1,543,542,535,-1,1453,790,1454,-1,757,790,1453,-1,748,1455,746,-1,1455,748,1398,-1,596,819,1434,-1,596,595,819,-1,564,1013,601,-1,564,563,1013,-1,1456,946,1436,-1,1456,908,946,-1,856,934,820,-1,855,934,856,-1,759,1457,1451,-1,759,1458,1457,-1,765,924,789,-1,765,1452,924,-1,1459,1313,1460,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_9()
		{
			int[] value = {1313,1459,1392,-1,1458,761,895,-1,1458,759,761,-1,32,1461,1462,-1,1463,1461,32,-1,942,945,943,-1,945,942,649,-1,1464,933,399,-1,933,1464,941,-1,790,1465,1454,-1,1465,790,929,-1,1466,1467,923,-1,1466,1468,1467,-1,721,922,719,-1,721,872,922,-1,1469,831,1355,-1,831,1469,829,-1,828,1470,1471,-1,828,1472,1470,-1,1443,1473,1354,-1,1445,1473,1443,-1,1474,1475,1476,-1,1474,1356,1475,-1,898,899,646,-1,899,898,1477,-1,1478,1479,1480,-1,1478,1481,1479,-1,940,851,833,-1,1482,851,940,-1,913,1420,1418,-1,912,1420,913,-1,1483,1430,1484,-1,1483,1429,1430,-1,554,1422,555,-1,939,1422,554,-1,936,550,546,-1,936,1421,550,-1,1485,1486,1487,-1,1485,1488,1486,-1,1441,455,938,-1,1487,455,1441,-1,1485,548,547,-1,1485,891,548,-1,557,936,937,-1,557,555,936,-1,822,1440,982,-1,890,1440,822,-1,1489,1490,604,-1,816,1490,1489,-1,838,1491,1492,-1,838,837,1491,-1,1493,1494,1495,-1,1494,1493,1496,-1,927,1497,1498,-1,927,1499,1497,-1,855,1500,934,-1,1500,855,1501,-1,1502,935,1503,-1,1502,394,935,-1,1491,1409,1493,-1,1412,1409,1491,-1,1410,1493,1409,-1,1410,1496,1493,-1,394,1495,1494,-1,394,1502,1495,-1,865,932,863,-1,865,397,932,-1,1464,1504,941,-1,1464,1351,1504,-1,1505,1503,1506,-1,1505,1502,1503,-1,559,984,553,-1,892,984,559,-1,1476,1333,1481,-1,1475,1333,1476,-1,799,748,752,-1,799,1398,748,-1,947,977,834,-1,947,978,977,-1,838,1505,1499,-1,1505,838,1492,-1,817,1497,1506,-1,817,816,1497,-1,1501,908,1456,-1,1501,909,908,-1,1500,1490,835,-1,1490,1500,1507,-1,976,1489,813,-1,1489,976,1498,-1,836,1411,837,-1,836,993,1411,-1,929,925,1465,-1,925,929,860,-1,926,945,925,-1,943,945,926,-1,863,926,861,-1,863,932,926,-1,1366,1508,1362,-1,1509,1508,1366,-1,866,868,1509,-1,866,862,868,-1,1508,920,1510,-1,1508,869,920,-1,773,781,772,-1,779,781,773,-1,789,921,867,-1,921,789,924,-1,872,1511,1466,-1,1511,872,871,-1,884,1511,885,-1,1511,884,1512,-1,923,1510,920,-1,1467,1510,923,-1,1371,1468,1512,-1,1319,1468,1371,-1,1513,1375,1514,-1,1513,1380,1375,-1,1382,1515,1372,-1,1515,1382,886,-1,1514,1516,1517,-1,1514,1515,1516,-1,880,1414,881,-1,880,1518,1414,-1,612,969,617,-1,612,981,969,-1,883,919,1516,-1,883,676,919,-1,1517,1449,1519,-1,1517,966,1449,-1,876,1518,877,-1,1414,1518,876,-1,743,911,827,-1,911,743,1401,-1,1419,815,1520,-1,533,815,1419,-1,893,915,914,-1,658,915,893,-1,1521,937,824,-1,1521,557,937,-1,907,982,1440,-1,909,982,907,-1,1522,456,1486,-1,1522,651,456,-1,905,561,559,-1,561,905,567,-1,985,549,551,-1,985,1488,549,-1,1426,1418,1417,-1,913,1418,1426,-1,1386,1439,1384,-1,1386,1438,1439,-1,1423,914,1428,-1,893,914,1423,-1,1462,1006,32,-1,1462,1400,1006,-1,1453,904,757,-1,1453,1523,904,-1,717,1457,1472,-1,1451,1457,717,-1,1523,1524,904,-1,1523,1525,1524,-1,1459,896,1526,-1,895,896,1459,-1,830,1527,1312,-1,1527,830,1470,-1,1393,1524,1394,-1,1393,1526,1524,-1,1461,1395,1525,-1,1395,1461,1463,-1,1479,1528,1480,-1,1479,1473,1528,-1,968,1528,967,-1,1480,1528,968,-1,902,967,903,-1,967,902,631,-1,901,668,707,-1,668,901,832,-1,1245,851,1336,-1,852,851,1245,-1,1444,1337,1482,-1,1444,1396,1337,-1,832,1446,940,-1,832,901,1446,-1,900,1477,1478,-1,1477,900,899,-1,1447,967,1528,-1,1447,903,967,-1,1476,1478,1477,-1,1478,1476,1481,-1,897,1474,898,-1,1469,1474,897,-1,1525,1394,1524,-1,1395,1394,1525,-1,1392,1526,1393,-1,1392,1459,1526,-1,1470,1457,1527,-1,1457,1470,1472,-1,896,1524,1526,-1,896,904,1524,-1,1525,826,1461,-1,1523,826,1525,-1,719,1452,716,-1,1452,719,924,-1,1523,744,826,-1,1453,744,1523,-1,894,1404,916,-1,1404,894,1406,-1,1387,1437,1385,-1,1437,1387,843,-1,1385,1438,1386,-1,1385,1437,1438,-1,1428,913,1426,-1,1428,914,913,-1,1484,566,1520,-1,1430,566,1484,-1,1384,540,541,-1,1384,1439,540,-1,906,939,567,-1,906,1422,939,-1,1429,652,1529,-1,1429,1483,652,-1,985,1486,1488,-1,1486,985,1522,-1,890,1441,1440,-1,890,891,1441,-1,824,545,825,-1,937,545,824,-1,1483,600,652,-1,1483,1530,600,-1,889,1266,1415,-1,889,1357,1266,-1,887,1415,1413,-1,889,1415,887,-1,877,1519,1449,-1,1518,1519,877,-1,919,1517,1516,-1,1517,919,966,-1,676,885,642,-1,676,883,885,-1,1382,884,886,-1,1382,1370,884,-1,1449,879,877,-1,1449,980,879,-1,1513,1518,880,-1,1513,1519,1518,-1,880,1380,1513,-1,1380,880,882,-1,525,1413,667,-1,525,887,1413,-1,1519,1514,1517,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_10()
		{
			int[] value = {1513,1514,1519,-1,1516,886,883,-1,1515,886,1516,-1,1514,1372,1515,-1,1514,1375,1372,-1,1370,1512,884,-1,1371,1512,1370,-1,1321,1510,1467,-1,1321,1365,1510,-1,1466,1512,1468,-1,1511,1512,1466,-1,871,885,1511,-1,871,642,885,-1,862,850,868,-1,850,862,848,-1,1509,869,1508,-1,1509,868,869,-1,1366,866,1509,-1,1366,864,866,-1,1510,1362,1508,-1,1510,1365,1362,-1,932,943,926,-1,932,933,943,-1,925,944,1465,-1,945,944,925,-1,941,1531,942,-1,941,1504,1531,-1,809,1498,976,-1,809,927,1498,-1,1507,604,1490,-1,1507,602,604,-1,909,855,982,-1,1501,855,909,-1,816,835,1490,-1,816,818,835,-1,1499,1506,1497,-1,1505,1506,1499,-1,1412,837,1411,-1,1491,837,1412,-1,1506,947,817,-1,947,1506,1503,-1,858,1531,1408,-1,858,647,1531,-1,802,1465,944,-1,1454,1465,802,-1,888,1357,889,-1,1358,1357,888,-1,1474,1355,1356,-1,1355,1474,1469,-1,1479,1354,1473,-1,1330,1354,1479,-1,1492,1502,1505,-1,1492,1495,1502,-1,1407,1351,1256,-1,1504,1351,1407,-1,1408,1504,1407,-1,1504,1408,1531,-1,978,1503,935,-1,947,1503,978,-1,1501,1507,1500,-1,1507,1501,1456,-1,816,1498,1497,-1,816,1489,1498,-1,839,1499,927,-1,839,838,1499,-1,1493,1492,1491,-1,1495,1492,1493,-1,1487,891,1485,-1,1487,1441,891,-1,1487,456,455,-1,1487,1486,456,-1,547,1488,1485,-1,547,549,1488,-1,1530,1484,1532,-1,1484,1530,1483,-1,1520,565,1419,-1,565,1520,566,-1,1482,1336,851,-1,1337,1336,1482,-1,900,1480,968,-1,900,1478,1480,-1,1481,1330,1479,-1,1481,1333,1330,-1,1474,1477,898,-1,1477,1474,1476,-1,1528,1445,1447,-1,1528,1473,1445,-1,1472,726,717,-1,726,1472,828,-1,829,1470,830,-1,1471,1470,829,-1,828,897,645,-1,1471,897,828,-1,737,732,738,-1,737,784,732,-1,1469,1471,829,-1,1469,897,1471,-1,923,872,1466,-1,922,872,923,-1,1319,1467,1468,-1,1467,1319,1321,-1,647,942,1531,-1,647,649,942,-1,827,1461,826,-1,1461,827,1462,-1,1460,895,1459,-1,1460,1458,895,-1,1460,1312,1527,-1,1460,1313,1312,-1,1527,1458,1460,-1,1458,1527,1457,-1,804,1521,856,-1,804,605,1521,-1,934,835,834,-1,1500,835,934,-1,1507,1436,602,-1,1456,1436,1507,-1,808,1435,1397,-1,808,518,1435,-1,946,445,950,-1,445,946,454,-1,1532,564,1530,-1,1532,562,564,-1,1453,802,744,-1,1453,1454,802,-1,742,956,955,-1,956,742,948,-1,569,813,570,-1,976,813,569,-1,563,1014,1013,-1,1014,563,1433,-1,444,806,950,-1,807,806,444,-1,746,1007,961,-1,746,1455,1007,-1,749,800,792,-1,751,800,749,-1,659,954,657,-1,953,954,659,-1,953,952,1402,-1,953,659,952,-1,792,803,793,-1,792,801,803,-1,509,750,755,-1,750,509,508,-1,779,775,778,-1,779,773,775,-1,1451,765,759,-1,1451,1452,765,-1,625,710,623,-1,625,711,710,-1,776,775,767,-1,776,778,775,-1,764,791,762,-1,764,780,791,-1,728,737,962,-1,728,784,737,-1,960,780,764,-1,960,781,780,-1,769,847,849,-1,960,847,769,-1,803,743,745,-1,803,1450,743,-1,796,655,654,-1,796,794,655,-1,720,731,727,-1,716,731,720,-1,735,726,644,-1,724,726,735,-1,973,713,854,-1,973,683,713,-1,706,690,673,-1,706,783,690,-1,711,700,615,-1,685,700,711,-1,664,970,521,-1,664,1448,970,-1,670,782,669,-1,782,670,702,-1,519,522,524,-1,526,522,519,-1,689,693,688,-1,689,698,693,-1,686,695,708,-1,686,688,695,-1,1482,1446,1444,-1,1446,1482,940,-1,1447,1444,1446,-1,1444,1447,1445,-1,879,613,846,-1,613,879,980,-1,653,556,605,-1,653,388,556,-1,1521,823,856,-1,1521,824,823,-1,1522,930,1529,-1,1522,985,930,-1,1438,1427,1439,-1,1425,1427,1438,-1,1529,651,1522,-1,651,1529,652,-1,843,1424,1437,-1,845,1424,843,-1,633,628,626,-1,628,633,964,-1,631,611,621,-1,611,631,624,-1,981,611,623,-1,981,608,611,-1,969,623,710,-1,623,969,981,-1,617,614,612,-1,617,616,614,-1,602,806,603,-1,602,1436,806,-1,604,813,1489,-1,604,603,813,-1,1397,458,449,-1,1397,1435,458,-1,601,1530,564,-1,601,600,1530,-1,819,983,1434,-1,819,590,983,-1,589,576,575,-1,589,591,576,-1,582,588,585,-1,588,582,581,-1,591,583,576,-1,584,583,591,-1,574,1434,983,-1,574,573,1434,-1,1431,596,1432,-1,596,1431,597,-1,819,581,584,-1,819,595,581,-1,574,568,570,-1,574,580,568,-1,1433,585,1014,-1,1433,582,585,-1,537,576,583,-1,537,542,576,-1,807,573,572,-1,807,1432,573,-1,446,1431,444,-1,446,587,1431,-1,815,562,1532,-1,815,532,562,-1,1529,984,1429,-1,1529,930,984,-1,1430,558,566,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_11()
		{
			int[] value = {1430,892,558,-1,1427,1417,1416,-1,1426,1417,1427,-1,1424,1428,1425,-1,1423,1428,1424,-1,1406,893,1423,-1,894,893,1406,-1,1520,1532,1484,-1,1520,815,1532,-1,1422,552,1421,-1,1422,906,552,-1,556,1521,605,-1,556,557,1521,-1,546,549,547,-1,546,550,549,-1,1420,531,533,-1,1420,599,531,-1,1417,1419,565,-1,1417,1418,1419,-1,540,560,539,-1,540,1416,560,-1,1415,881,1414,-1,1415,1266,881,-1,876,667,1413,-1,878,667,876,-1,525,874,887,-1,525,530,874,-1,972,667,878,-1,972,523,667,-1,524,520,519,-1,701,520,524,-1,986,494,463,-1,494,986,497,-1,506,496,504,-1,506,495,496,-1,990,1262,991,-1,990,1258,1262,-1,1411,515,989,-1,993,515,1411,-1,514,1409,1412,-1,514,512,1409,-1,1256,990,1407,-1,990,1256,1258,-1,1408,988,858,-1,1408,992,988,-1,986,859,987,-1,986,650,859,-1,500,513,503,-1,500,991,513,-1,495,497,496,-1,497,495,494,-1,1005,1000,1004,-1,1005,1001,1000,-1,1403,491,492,-1,1403,1399,491,-1,480,995,493,-1,995,480,478,-1,910,1462,827,-1,910,1400,1462,-1,842,1004,1000,-1,844,1004,842,-1,1003,916,1404,-1,1003,1403,916,-1,917,493,952,-1,917,492,493,-1,1401,997,911,-1,1401,998,997,-1,910,486,1400,-1,486,910,487,-1,484,1006,483,-1,484,30,1006,-1,491,479,480,-1,491,999,479,-1,488,1399,1002,-1,488,996,1399,-1,1001,481,485,-1,1005,481,1001,-1,490,1455,475,-1,1007,1455,490,-1,473,470,469,-1,473,994,470,-1,1010,476,1011,-1,476,1010,468,-1,995,949,1402,-1,949,995,994,-1,1010,469,468,-1,469,1010,472,-1,464,467,1009,-1,464,465,467,-1,474,948,473,-1,948,474,956,-1,1398,475,1455,-1,1398,476,475,-1,462,799,508,-1,1011,799,462,-1,457,938,455,-1,457,1012,938,-1,459,452,1012,-1,453,452,459,-1,450,460,457,-1,460,450,447,-1,449,601,1397,-1,449,448,601,-1,1046,1245,1336,-1,1245,1046,1045,-1,4,439,5,-1,373,439,4,-1,224,440,436,-1,223,440,224,-1,437,225,224,-1,225,437,1334,-1,437,1332,1334,-1,437,1326,1332,-1,1395,1315,1389,-1,1463,1315,1395,-1,1390,1393,1394,-1,1390,1391,1393,-1,1309,830,1312,-1,1324,830,1309,-1,432,1314,1391,-1,1314,432,1018,-1,1390,1388,434,-1,1390,1389,1388,-1,1311,241,1325,-1,241,1311,1301,-1,434,1303,433,-1,434,1388,1303,-1,31,1254,32,-1,31,1250,1254,-1,425,1277,1278,-1,1277,425,1019,-1,1297,1386,1384,-1,1297,1296,1386,-1,1270,1282,1269,-1,1282,1270,424,-1,1129,91,90,-1,1129,1339,91,-1,375,95,94,-1,96,95,375,-1,1023,1295,1340,-1,1023,1022,1295,-1,77,380,1383,-1,380,77,429,-1,387,1272,1060,-1,387,1127,1272,-1,341,1019,425,-1,1019,341,165,-1,1068,1268,1274,-1,1268,1068,1067,-1,426,1093,427,-1,1251,1093,426,-1,1381,1035,1036,-1,1035,1381,1265,-1,1095,1378,1377,-1,1095,227,1378,-1,228,1031,1376,-1,228,422,1031,-1,422,146,1106,-1,192,146,422,-1,131,1109,222,-1,131,1293,1109,-1,1265,1033,881,-1,1265,1381,1033,-1,1376,1373,1378,-1,1376,1374,1373,-1,1374,1382,1372,-1,1030,1382,1374,-1,1375,1379,1373,-1,1375,1380,1379,-1,1320,1371,1369,-1,1371,1320,1319,-1,1363,421,417,-1,421,1363,1318,-1,1368,1032,1029,-1,1369,1032,1368,-1,1368,1039,1322,-1,1040,1039,1368,-1,415,285,416,-1,419,285,415,-1,1089,296,295,-1,296,1089,302,-1,417,1364,1363,-1,417,414,1364,-1,1041,411,1367,-1,1041,413,411,-1,1364,1366,1362,-1,1366,1364,1367,-1,408,412,410,-1,408,398,412,-1,363,408,409,-1,408,363,367,-1,409,283,1359,-1,405,283,409,-1,1261,162,1053,-1,1261,56,162,-1,1291,169,1069,-1,1346,169,1291,-1,1361,1307,1057,-1,1305,1307,1361,-1,355,1348,1306,-1,355,429,1348,-1,1347,353,1360,-1,1347,1064,353,-1,1353,1052,1345,-1,1341,1052,1353,-1,157,352,155,-1,157,1298,352,-1,272,1083,273,-1,272,1247,1083,-1,1333,1329,1331,-1,1329,1333,1475,-1,1349,1353,1360,-1,1349,1352,1353,-1,1350,1464,368,-1,1350,1351,1464,-1,398,865,412,-1,398,397,865,-1,1344,394,1494,-1,1344,1352,394,-1,1342,1410,1259,-1,1342,1496,1410,-1,1259,1343,1342,-1,1343,1259,1260,-1,395,1352,1349,-1,395,394,1352,-1,1307,118,334,-1,1348,118,1307,-1,1347,407,1346,-1,1347,1345,407,-1,1494,1342,1344,-1,1496,1342,1494,-1,1343,1052,1341,-1,1343,1053,1052,-1,1361,1291,1111,-1,1291,1361,1064,-1,1383,78,77,-1,78,1383,390,-1,386,1127,387,-1,386,1126,1127,-1,88,383,1130,-1,88,381,383,-1,1163,382,16,-1,382,1163,384,-1,1340,383,384,-1,1340,1339,383,-1,431,378,1126,-1,378,431,98,-1,1283,1338,1275,-1,1283,1285,1338,-1,1271,424,1270,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_12()
		{
			int[] value = {424,1271,339,-1,1046,198,374,-1,198,1046,201,-1,1332,1335,1334,-1,1332,1331,1335,-1,188,1017,435,-1,1327,1017,188,-1,1475,1328,1329,-1,1475,1356,1328,-1,1326,1443,1354,-1,1443,1326,1299,-1,1324,369,371,-1,1324,1325,369,-1,831,1323,1355,-1,1059,1323,831,-1,1318,1322,421,-1,1318,1320,1322,-1,1359,318,1304,-1,283,318,1359,-1,366,1464,399,-1,368,1464,366,-1,363,365,367,-1,364,365,363,-1,1316,1093,1080,-1,427,1093,1316,-1,1315,32,1254,-1,32,1315,1463,-1,288,1308,1018,-1,288,317,1308,-1,1313,1314,1310,-1,1392,1314,1313,-1,419,316,285,-1,419,1302,316,-1,1311,317,1301,-1,1311,1308,317,-1,334,1044,335,-1,1044,334,118,-1,356,1306,1292,-1,356,355,1306,-1,6,1125,1113,-1,6,1066,1125,-1,1061,1114,1289,-1,1061,113,1114,-1,1248,272,270,-1,1247,272,1248,-1,318,1303,1304,-1,1303,318,433,-1,82,101,85,-1,82,80,101,-1,1288,117,1066,-1,1288,79,117,-1,1251,1092,1093,-1,1251,26,1092,-1,28,1092,26,-1,1092,28,268,-1,1301,236,241,-1,1301,1302,236,-1,255,310,249,-1,255,257,310,-1,292,361,1091,-1,292,303,361,-1,293,295,1090,-1,293,1089,295,-1,311,257,246,-1,311,310,257,-1,308,248,309,-1,248,308,258,-1,202,181,1034,-1,202,179,181,-1,1086,315,300,-1,1086,318,315,-1,325,265,1084,-1,325,266,265,-1,263,347,332,-1,347,263,260,-1,309,148,145,-1,309,248,148,-1,312,240,242,-1,240,312,311,-1,252,242,236,-1,312,242,252,-1,195,234,196,-1,234,195,232,-1,235,320,197,-1,230,320,235,-1,132,182,213,-1,182,132,1099,-1,1100,1300,1087,-1,221,1100,1533,-1,221,1300,1100,-1,211,1533,217,-1,1533,211,221,-1,304,1134,178,-1,73,1134,304,-1,206,214,216,-1,206,203,214,-1,172,1098,179,-1,172,171,1098,-1,436,200,438,-1,436,439,200,-1,199,1443,1299,-1,1443,199,1396,-1,184,223,185,-1,440,223,184,-1,440,306,5,-1,440,184,306,-1,1533,4,217,-1,1533,1100,4,-1,1,1038,2,-1,1038,1,1132,-1,343,341,340,-1,165,341,343,-1,347,163,165,-1,322,163,347,-1,159,157,156,-1,159,158,157,-1,158,1298,157,-1,1298,158,401,-1,1165,350,351,-1,1165,1136,350,-1,1383,16,382,-1,16,1383,380,-1,1267,1297,1131,-1,1297,1267,1281,-1,1280,1294,1296,-1,1294,1280,1279,-1,162,58,161,-1,58,162,56,-1,123,135,124,-1,123,403,135,-1,1292,337,356,-1,1074,337,1292,-1,351,71,1165,-1,351,11,71,-1,83,339,1271,-1,339,83,342,-1,166,344,102,-1,168,344,166,-1,1119,110,103,-1,110,1119,111,-1,110,105,103,-1,107,105,110,-1,1287,1289,1114,-1,1287,1121,1289,-1,112,1116,1286,-1,112,114,1116,-1,1288,1117,79,-1,1118,1117,1288,-1,99,103,102,-1,1119,103,99,-1,1073,1286,338,-1,1287,1286,1073,-1,90,1056,1055,-1,1056,90,1128,-1,1285,1021,92,-1,1021,1285,1283,-1,1282,1280,1281,-1,1280,1282,1278,-1,1277,1049,1279,-1,1049,1277,1276,-1,95,1128,93,-1,95,430,1128,-1,1056,1126,386,-1,1056,431,1126,-1,1067,1270,1268,-1,1067,1271,1270,-1,1124,1267,1122,-1,1124,1269,1267,-1,1265,1263,1035,-1,1265,1264,1263,-1,1180,1025,1358,-1,1025,1180,1202,-1,1103,170,173,-1,1103,1135,170,-1,52,59,64,-1,59,52,55,-1,63,53,60,-1,63,68,53,-1,65,1261,1260,-1,64,1261,65,-1,1259,511,1141,-1,1410,511,1259,-1,1137,153,1079,-1,153,1137,70,-1,1257,63,62,-1,1257,1255,63,-1,154,68,1042,-1,68,154,67,-1,1140,1262,61,-1,510,1262,1140,-1,1152,1153,27,-1,1152,1154,1153,-1,47,43,42,-1,47,45,43,-1,1049,1252,1050,-1,1252,1049,1276,-1,1051,1405,1387,-1,1048,1405,1051,-1,35,1405,1048,-1,35,36,1405,-1,1050,1145,1253,-1,1252,1145,1050,-1,329,1143,423,-1,1143,329,1150,-1,38,323,39,-1,38,321,323,-1,26,42,29,-1,26,1251,42,-1,47,428,46,-1,47,426,428,-1,31,1147,1250,-1,1147,31,1148,-1,1144,43,45,-1,1144,1151,43,-1,44,1249,1142,-1,44,1146,1249,-1,1149,34,33,-1,1149,482,34,-1,1157,1161,1158,-1,1157,17,1161,-1,49,1152,37,-1,49,1154,1152,-1,49,1155,1154,-1,49,1159,1155,-1,1158,21,24,-1,1161,21,1158,-1,17,326,20,-1,17,1157,326,-1,345,1160,48,-1,345,346,1160,-1,25,1247,1156,-1,25,1083,1247,-1,15,13,1164,-1,13,15,72,-1,7,336,8,-1,1136,336,7,-1,1026,1202,1037,-1,1026,1025,1202,-1,1238,2,1037,-1,1238,1237,2,-1,1207,1246,1240,-1,1207,1241,1246,-1,374,1242,1045,-1,374,1241,1242,-1,1231,1184,1186,-1,1231,1233,1184,-1,1235,1228,1176,-1,1228,1235,1190,-1,1230,1221,1219,-1,1221,1230,1534,-1};
			return value;
		}
		private int[] getsternum_Geo_6_15_coordIndex_13()
		{
			int[] value = {1191,1225,1192,-1,1226,1225,1191,-1,1184,1232,1185,-1,1232,1184,1233,-1,1240,1208,1207,-1,1240,1166,1208,-1,1176,1172,1174,-1,1239,1172,1176,-1,1228,1225,1227,-1,1225,1228,1229,-1,1204,1238,1201,-1,1168,1238,1204,-1,1216,1185,1232,-1,1185,1216,1215,-1,1195,1198,1194,-1,1198,1195,1203,-1,1206,1177,1179,-1,1206,1175,1177,-1,1209,1213,1212,-1,1213,1209,1210,-1,1230,1244,1534,-1,1230,1189,1244,-1,1534,1213,1210,-1,1534,1244,1213,-1,1234,1173,1211,-1,1235,1173,1234,-1,1206,1211,1173,-1,1211,1206,1212,-1,1219,1217,1230,-1,1219,1216,1217,-1,1234,1189,1190,-1,1234,1244,1189,-1,1209,1243,1242,-1,1212,1243,1209,-1,1239,1226,1200,-1,1226,1239,1227,-1,1223,1222,1215,-1,1223,1196,1222,-1,1229,1192,1225,-1,1192,1229,1188,-1,1186,1217,1231,-1,1217,1186,1218,-1,1221,1166,1220,-1,1166,1221,1208,-1,442,1171,443,-1,1171,442,1178,-1,1205,1220,1166,-1,1220,1205,1224,-1,1221,1210,1208,-1,1221,1534,1210,-1,1200,1191,1198,-1,1200,1226,1191,-1,1188,1193,1192,-1,1193,1188,1187,-1,1232,1217,1216,-1,1232,1231,1217,-1,1237,0,2,-1,1237,1236,0,-1,852,1243,1179,-1,852,1245,1243,-1,1240,1236,1167,-1,1240,1246,1236,-1,1168,1237,1238,-1,1168,1167,1237,-1,875,1170,873,-1,875,1171,1170,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getsternum_Coord_7_15_point_1()
		{
			double[] value = {.2714,44.37799,3.01755,.28024,44.48482,3.09483,.25518,44.40391,3.08189,.43808,44.58738,2.88389,.35596,44.48518,2.86628,.47425,44.63706,2.85137,1.15112,50.06852,.52921,1.24209,50.06163,.61951,1.27016,50.00486,.63637,1.18256,50.08354,.5687,1.21777,49.99303,.57482,.98269,50.31622,.58793,.92292,50.36477,.54749,.93519,50.38967,.57755,1.04196,50.33989,.69936,.94627,50.44459,.62136,.90067,50.59365,.63884,.53463,48.87965,1.49672,.5607,48.90306,1.50679,.55612,48.90192,1.51254,.53793,48.88344,1.49328,.52502,48.86913,1.50416,.54016,48.87396,1.51683,.5303,48.86247,1.50757,.43042,48.88344,1.45441,.43745,48.8764,1.46004,.48075,48.90607,1.26832,.48944,48.86179,1.32792,.49022,48.85084,1.33461,.48218,48.91604,1.26411,0.0,48.9293,1.21491,.09395,48.93814,1.22102,0.0,48.66057,1.35184,.10689,48.9938,1.21982,0.0,48.96156,1.2231,.10473,49.00542,1.18105,0.0,48.98999,1.18734,.47714,48.8885,1.30972,.50244,48.96471,1.24734,.49855,48.90295,1.30503,.48297,48.93885,1.25552,.48097,48.93445,1.25741,.45238,48.91702,1.24634,.43689,48.9506,1.24307,.31935,48.98037,1.22959,.40904,48.95926,1.22828,.32097,48.95814,1.21726,.41005,48.92372,1.22486,.4244,48.88972,1.36767,.41684,48.88155,1.36885,.54005,48.87841,1.51225,.53598,48.8945,1.52002,.36803,48.98643,1.51501,.36736,48.98254,1.51662,.40884,48.97946,1.51192,.40936,48.98296,1.50969,.41129,48.99826,1.51419,.53034,48.9442,1.50683,.53341,48.95016,1.50298,.41039,48.9913,1.51665,.2746,49.0301,1.48078,.12792,49.01992,1.47002,.1269,49.01828,1.48713,.27576,49.00919,1.51034,.3688,48.9957,1.52111,.27502,49.04864,1.48132,.27512,49.03352,1.47815,.4025,48.96832,1.53584,.36654,48.96014,1.54824,.51843,48.90753,1.5261,.51197,48.90515,1.54436,1.01233,50.32782,.6434,.96402,50.38249,.60603,.23771,44.54871,3.05179,.25895,44.54701,2.99601,.24882,44.5822,3.05395,.52307,50.53335,.7435,.79845,50.39474,.82069,.56891,50.63078,.74569,1.09977,49.82887,.56293,1.01285,49.6841,.64808,1.02384,49.7812,.57038,.96329,49.71855,.63171,.88295,49.6731,.67826,.91178,49.74921,.62716,.9115,49.663,.68571,.33125,50.89611,.52215,.45412,50.77002,.64198,.40872,50.89407,.53053,.4054,50.51951,.32843,.28849,50.6992,.31627,.44234,50.66844,.32962,.377,50.42006,.32813,.26743,50.61715,.32047,.23169,50.51593,.34998,.19014,50.64573,.32617,.12471,50.64619,.33262,0.0,50.7531,.3527,.10036,50.76586,.36786,.95911,49.61265,.75527};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_2()
		{
			double[] value = {.91287,49.57829,.77517,.96519,49.62973,.71246,.9641,49.59815,.83854,.96747,49.6156,.82628,1.01067,49.61398,.88325,.99428,49.64442,.85668,.97228,49.80433,.80596,.92904,49.76718,.80294,1.1166,49.67803,.86155,.92154,49.86769,.72342,.90134,49.74616,.78419,.90672,49.75375,.74815,1.14713,50.02565,.69194,1.03638,50.01925,.66058,1.12637,50.04813,.64848,1.09505,50.03306,.61299,.93497,49.84135,.54207,1.05131,49.84458,.54171,.75453,50.2695,.86845,.64481,49.19904,1.21765,.66487,49.29359,1.14553,.54805,49.31343,1.18884,.6871,45.20494,2.9086,.60541,45.02937,2.97744,.68498,45.16268,2.89449,.67262,45.24609,2.90464,.67601,45.22012,2.7005,.71227,45.23276,2.75705,.68595,45.16861,2.70485,.69064,45.13353,2.73885,.52551,45.03973,2.8069,.54051,45.07663,2.83638,.49874,44.97571,2.86519,.71615,45.24405,2.82176,.68343,45.24717,2.88509,.6588,45.12037,2.88484,.72068,45.21064,2.79709,.6738,45.28582,2.69013,.60813,45.32593,2.78276,.61128,45.35757,2.82175,.67878,45.31997,2.84904,.71306,45.2711,2.78852,.82245,45.77179,2.65911,.74841,45.70226,2.57854,.74099,45.78206,2.54414,.79132,45.83324,2.63571,.78693,45.81377,2.76411,.71647,45.90248,2.74915,.73233,45.90419,2.69979,.6311,45.88525,2.49891,.57666,46.01524,2.4552,.69346,45.89123,2.53396,.3789,48.83952,1.62552,.51057,48.90118,1.54946,.40355,48.96292,1.54172,.47376,50.05289,.87826,.3207,50.22456,.76724,.2589,50.0954,.8166,.11438,50.10293,.78389,.11198,50.2429,.71522,0.0,50.08598,.74506,.61028,49.11796,1.32941,.44568,49.16223,1.36183,.515,49.18684,1.10668,.47081,49.20538,1.08915,.56543,49.33414,1.00702,.95613,49.57444,.94034,.76377,49.4493,1.05026,.76511,49.44474,1.01984,.93587,49.59008,.96777,.38966,44.65304,3.0289,.40745,44.67382,2.98119,.43261,44.68136,3.01636,.42611,44.67462,3.03573,.28987,44.34172,2.93386,.30841,44.38928,2.93279,.3001,44.40703,2.94283,.26229,44.39389,3.01639,.27324,44.49109,3.08003,.46035,44.71197,3.02502,.48468,44.76959,2.98912,.53139,44.88004,2.9903,.47741,44.89198,2.94198,.50211,44.87424,2.96923,.55217,44.84753,2.79849,.62287,44.98513,2.75598,.51638,44.84924,2.82495,.56405,44.98458,2.78135,.55357,45.63079,2.54752,.6834,45.61653,2.62103,.67633,45.31587,2.87192,.64213,45.49379,2.88424,.80082,45.73127,2.78991,.71611,45.64681,2.80502,.78985,45.67796,2.68948,.65723,45.48748,2.84934,.70513,45.61039,2.78593,.71691,45.64093,2.7,.2166,44.57872,2.81257,.12589,44.79821,2.77304};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_3()
		{
			double[] value = {.33182,44.70255,2.786,.1112,44.63184,2.78896,.46275,44.72595,3.0554,.41947,44.70065,2.93816,.46091,44.72071,2.90543,.44453,44.72908,2.93146,.44665,44.67613,2.90858,.46481,44.78957,2.91692,.4507,44.73592,2.95785,.46652,44.81853,2.93997,.33696,44.58855,2.95271,.32889,44.56733,2.93509,.47067,44.80574,2.88347,.48045,44.87931,2.894,.39442,44.67239,2.94476,.34502,44.60985,2.97027,.42588,44.62956,2.91574,.4185,44.58027,2.90337,.44753,44.62152,2.8944,.24247,44.47222,2.96901,.22703,44.47285,3.0092,.31394,44.55352,2.93579,.52171,45.05723,2.88584,.62103,44.98359,2.73338,.5484,45.00832,2.69312,.58341,45.23535,2.66024,.66256,45.21559,2.68223,.61963,45.26851,2.94122,.58161,45.49476,2.91029,.59741,45.45362,2.69256,.61748,45.55063,2.69048,.60139,45.46451,2.75136,.60536,45.47584,2.80999,.60567,45.34839,2.74166,.62215,45.56407,2.75714,.63057,45.5739,2.72004,.67626,46.52067,2.40501,.65386,46.54922,2.54475,.66913,46.48277,2.51511,.65646,46.04944,2.70211,.53521,46.24599,2.37871,.59033,46.49909,2.29471,.62951,46.46684,2.35777,.61902,46.26977,2.62205,.65098,46.05317,2.67604,.62618,46.28634,2.6444,.58079,46.02853,2.47661,.62981,45.94666,2.53903,.67114,45.97038,2.66109,.49033,46.20534,2.53066,.48691,46.27959,2.46039,.49941,46.31768,2.486,.63042,46.40049,2.4464,.61954,46.37032,2.5399,.50941,46.27747,2.5535,.51043,46.08019,2.56266,.52867,46.0095,2.54625,.51426,46.07654,2.50212,.544,46.01264,2.61975,.55393,46.09212,2.62213,.60319,49.1213,1.19983,.48546,49.07027,1.27738,.47618,49.05999,1.27563,.62604,49.12846,1.2129,.43913,49.00458,1.32996,.48301,49.05328,1.30272,.4804,49.01167,1.35388,.49024,48.60469,1.50345,.47434,48.66116,1.44351,.39845,48.70877,1.49128,.40194,48.76374,1.45023,.40671,48.70713,1.53016,.38969,48.7937,1.46975,.41817,48.77491,1.50921,.50263,48.63288,1.56665,.5132,48.66362,1.62636,.5309,48.52819,1.64653,.51526,48.69557,1.56594,.54897,48.39639,1.79708,.55105,48.45974,1.72443,.5009,48.63981,1.69042,.5419,47.58302,2.10538,.6001,47.78022,1.96961,.60263,47.83406,1.94338,.55378,47.23608,2.29165,.61871,47.00897,2.40762,.61566,47.06039,2.31299,.45865,47.23117,2.02446,.44661,47.21367,2.00329,.48187,47.56726,1.8867,.48384,47.55934,1.90712,.55541,47.03253,2.12536,.50367,47.11138,2.12494,.54343,47.26203,2.23319,.53749,47.12406,2.24817,.47496,47.49922,2.07725,.43392,47.47619,2.02916,.47256,47.60977,2.00669,.4518,47.60367,1.94163,.44119,47.49209,1.96848};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_4()
		{
			double[] value = {.52287,47.67325,1.90909,.42743,47.27921,2.04757,.42296,47.30176,2.10287,.43569,47.17286,2.12622,.22917,44.51514,3.04281,.49905,44.74092,2.86998,.47893,44.64258,2.8838,.4843,44.87109,2.84471,.56114,45.98489,2.58924,.69315,45.93947,2.59999,.49388,46.19589,2.4672,.54317,46.24126,2.40818,.58079,46.35349,2.40026,.56227,47.68955,1.98897,.45822,47.62908,1.96548,.57487,47.72004,1.93537,.66459,46.98384,2.24526,.54195,46.97549,2.09663,.63047,47.82415,1.89776,.61552,45.44801,2.65284,.67439,45.59471,2.64988,.50835,48.97461,1.24269,.56831,49.1651,1.13888,.50277,48.91067,1.30123,.57449,49.09388,1.20706,.586,49.03456,1.34171,.44486,48.89891,1.44448,.45749,49.00054,1.30255,.60059,48.41294,1.64422,.46321,48.9614,1.22142,.60934,49.11381,1.31392,.40317,48.6904,1.52009,.66405,49.23377,1.14585,.68933,49.30016,1.11271,.66003,50.18782,.89277,.37925,50.34127,.76123,1.27185,50.10229,.7046,1.28682,50.06694,.7524,1.30612,49.98005,.70346,.67497,49.6931,.74439,.70557,49.46531,.90163,.60652,49.49034,.87771,.85411,49.60095,.74558,.64493,49.30471,1.04557,.75331,49.44734,.95497,.42713,48.89459,1.36571,.40812,48.90856,1.40868,.62507,49.22387,1.12244,1.05333,49.99581,.59808,1.08289,50.16137,.5363,1.214,50.09879,.60832,1.13634,50.16581,.60373,.30834,49.91143,.91324,.53824,49.8848,.96142,.59827,49.94183,.92975,1.06061,50.20898,.7991,1.21708,50.12861,.76603,1.21939,50.15564,.71645,1.04857,50.30384,.72331,.12085,50.4746,.60901,0.0,50.42809,.55304,.45182,47.16389,2.16324,.45176,47.18241,2.18739,.47285,48.37985,1.81589,.41296,48.6216,1.74919,.33949,48.61344,1.75863,.16714,48.37408,1.84615,.31703,48.36423,1.83055,.16944,48.59819,1.7349,.46127,46.23227,2.36971,.5308,45.99904,2.42174,.30016,46.21897,2.39181,.30861,45.97624,2.48886,.32933,44.49992,2.8239,.25424,44.3462,2.85656,.15221,50.56969,.34405,.23588,50.38152,.38305,0.0,50.66212,.31538,.10351,50.79279,.41415,0.0,50.78556,.38994,.92141,50.53134,.70343,.59003,50.83754,.58527,.7493,50.75221,.61789,.5441,50.85802,.47183,.68881,50.76312,.50809,.29176,50.89368,.43831,.21138,50.85044,.43073,.25377,50.83859,.51306,0.0,50.78561,.43907,.12608,50.76218,.47246,.59056,50.7542,.68543,.04589,50.71494,.50912,0.0,50.71122,.48841,0.0,50.22174,.65154,0.0,49.54427,1.10146,.05012,49.66211,1.02388,0.0,49.66773,1.01951,0.0,48.10824,1.92539,.16455,48.11446,1.92365,0.0,48.35623,1.82608};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_5()
		{
			double[] value = {0.0,49.90533,.86934,.06899,49.9076,.88244,.5499,45.01588,2.93023,.60008,45.02497,2.94879,.50321,47.59455,2.13075,.49608,47.82232,1.96837,.21768,50.47265,.63712,.63331,49.47476,1.07447,.37194,48.11788,1.89134,.52978,48.13172,1.87962,.37938,47.82937,1.99391,.16743,47.59052,2.11472,.17668,47.86069,2.03517,.35454,47.58115,2.11641,.44022,46.94396,2.39486,.61267,46.74235,2.4453,.56811,47.01198,2.42342,.4831,46.71458,2.48126,.52539,47.26491,2.31582,.6693,46.75628,2.43047,.60933,46.52979,2.57183,.44676,46.51295,2.56688,.68481,45.69609,2.8624,.41745,48.97681,1.19412,.56752,49.74236,.71593,.51914,49.54526,.86772,.40786,48.90732,1.2298,.36813,48.65125,1.36368,.32256,48.94321,1.223,.93386,50.28679,.81649,.18024,50.66176,.32908,.1495,50.77634,.37173,.42549,47.6006,1.84594,.52377,47.8681,1.75368,.45498,47.89857,1.72865,.55419,45.82749,2.50913,.47789,44.85129,2.74982,.31072,45.10085,2.72597,.30016,44.91957,2.7519,.41698,44.64742,2.7912,.55151,44.8483,2.78077,-.30841,44.38928,2.93279,-.28987,44.34172,2.93386,-.27074,44.37931,3.02054,-1.30612,49.98005,.70346,-1.27185,50.10229,.7046,-1.27016,50.00486,.63637,-.92292,50.36477,.54749,-.89437,50.30586,.47574,-.93851,50.32134,.52952,-.86922,50.42831,.51026,-1.18623,50.17011,.66793,-1.04196,50.33989,.69936,-1.01233,50.32782,.6434,-1.21939,50.15564,.71645,-.83205,50.62405,.5446,-.75757,50.57619,.45474,-.8983,50.46538,.56742,-.98269,50.31622,.58793,-.96402,50.38249,.60603,-.93519,50.38967,.57755,-1.04857,50.30384,.72331,-.5303,48.86247,1.50757,-.54991,48.86734,1.53769,-.54016,48.87396,1.51683,-.54005,48.87841,1.51225,-.53463,48.87965,1.49672,-.52602,48.8743,1.50093,-.39156,48.88808,1.41585,-.3932,48.89382,1.41372,-.41684,48.88155,1.36885,-.41684,48.87537,1.37096,-.43193,48.88872,1.4512,-.40525,48.90432,1.41111,-.443,48.89442,1.44848,-.42424,48.86719,1.37532,-.39692,48.87703,1.42112,-.47642,48.88043,1.31444,-.47714,48.8885,1.30972,-.48097,48.93445,1.25741,-.48297,48.93885,1.25552,-.10614,48.98943,1.22127,0.0,48.95823,1.22411,-.09808,48.95278,1.21569,0.0,48.94253,1.2101,-.20269,48.97029,1.24478,-.20096,48.92606,1.23304,-.32097,48.95814,1.21726,-.31935,48.98037,1.22959,-.48218,48.91604,1.26411,-.48944,48.86179,1.32792,-.4378,48.95395,1.24112,-.46069,48.95227,1.22775,-.50244,48.96471,1.24734,-.53508,48.89144,1.52317,-.53598,48.8945,1.52002,-.51905,48.91097,1.52258,-.51843,48.90753,1.5261,-.40884,48.97946,1.51192,-.40936,48.98296,1.50969};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_6()
		{
			double[] value = {-.2746,49.0301,1.48078,-.36803,48.98643,1.51501,-.36736,48.98254,1.51662,-.27512,49.03352,1.47815,-.53034,48.9442,1.50683,-.53341,48.95016,1.50298,-.55612,48.90192,1.51254,-.5607,48.90306,1.50679,-.53262,48.85614,1.51032,-.55096,48.8613,1.54095,0.0,49.04418,1.4235,0.0,49.07827,1.41278,-.12567,49.05634,1.44911,-.12781,49.02362,1.46755,-.27502,49.04864,1.48132,-.41039,48.9913,1.51665,-1.24209,50.06163,.61951,-1.24293,50.10033,.65641,-1.214,50.09879,.60832,-.2837,44.60527,3.04073,-.31416,44.61807,3.01947,-.25895,44.54701,2.99601,-.3128,44.60657,3.08847,-.37583,44.65742,3.07682,-.35541,44.63961,3.06622,-.3172,44.62074,3.10283,-.24882,44.5822,3.05395,-.28676,44.54195,3.09395,-.23771,44.54871,3.05179,-.29109,44.53899,3.10825,-.26945,44.52945,3.11758,-.91178,49.74921,.62716,-.93497,49.84135,.54207,-.72937,49.85798,.59104,-1.02384,49.7812,.57038,-.96329,49.71855,.63171,-1.05131,49.84458,.54171,-1.09977,49.82887,.56293,0.0,50.52507,.33277,-.23588,50.38152,.38305,-.22159,50.17291,.49592,0.0,50.29262,.41794,-1.01285,49.6841,.64808,-.96519,49.62973,.71246,-.95911,49.61265,.75527,-.33125,50.89611,.52215,-.29176,50.89368,.43831,-.37215,50.90412,.44538,-.40872,50.89407,.53053,-.33606,50.83995,.37612,-.27074,50.83329,.36618,-.28849,50.6992,.31627,-.22622,50.68368,.32704,-.26743,50.61715,.32047,-.10351,50.79279,.41415,-.15744,50.81376,.42213,-.12608,50.76218,.47246,-.17958,50.79865,.48926,-.3459,50.29408,.38557,-.23169,50.51593,.34998,-.35209,50.21313,.44895,-.15221,50.56969,.34405,-.963,49.92848,.49837,-1.08794,49.95916,.51753,-.99265,49.99903,.48685,-.47104,50.079,.50803,-.47563,50.12736,.43096,-.12471,50.64619,.33262,-1.01067,49.61398,.88325,-.95613,49.57444,.94034,-1.14513,49.66438,.8781,-.9641,49.59815,.83854,-1.28649,49.80037,.8201,-1.27092,49.80793,.80614,-1.1166,49.67803,.86155,-.96304,49.62804,.76026,-1.01688,49.68671,.66287,-.90134,49.74616,.78419,-.96747,49.6156,.82628,-.92904,49.76718,.80294,-.99428,49.64442,.85668,-1.05333,49.99581,.59808,-1.1415,49.91082,.56989,-1.10177,49.83156,.5759,-1.02576,49.91684,.61435,-1.21377,49.98849,.58536,-1.12637,50.04813,.64848,-1.26228,49.99673,.64221,-1.09505,50.03306,.61299,-.90672,49.75375,.74815,-.92154,49.86769,.72342,-.94734,49.80688,.67921,-.70557,49.46531,.90163,-.91287,49.57829,.77517,-.85411,49.60095,.74558,-1.03638,50.01925,.66058,-1.14809,49.99485,.7263,-1.14713,50.02565,.69194,-.9115,49.663,.68571,-.88295,49.6731,.67826};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_7()
		{
			double[] value = {-.83974,50.20905,.43643,-1.03562,50.15658,.47735,-1.16397,49.93495,.85713,-1.25134,49.8572,.84275,-1.10115,49.89698,.85761,-.16985,50.62712,.57816,-.21768,50.47265,.63712,-.12085,50.4746,.60901,-.66752,45.15413,2.81534,-.6588,45.12037,2.88484,-.72068,45.21064,2.79709,-.67625,45.10195,2.76631,-.57649,45.09267,2.89613,-.60008,45.02497,2.94879,-.5499,45.01588,2.93023,-.49874,44.97571,2.86519,-.49515,44.98336,2.91789,-.52171,45.05723,2.88584,-.68595,45.16861,2.70485,-.67601,45.22012,2.7005,-.66256,45.21559,2.68223,-.69064,45.13353,2.73885,-.71227,45.23276,2.75705,-.58765,45.06708,2.77783,-.62287,44.98513,2.75598,-.56405,44.98458,2.78135,-.71615,45.24405,2.82176,-.71981,45.23915,2.79196,-.71306,45.2711,2.78852,-.66314,45.30942,2.71821,-.6738,45.28582,2.69013,-.62103,44.98359,2.73338,-.68343,45.24717,2.88509,-.67633,45.31587,2.87192,-.60813,45.32593,2.78276,-.60567,45.34839,2.74166,-.82245,45.77179,2.65911,-.80082,45.73127,2.78991,-.78693,45.81377,2.76411,-.79132,45.83324,2.63571,-.74099,45.78206,2.54414,-.71647,45.90248,2.74915,-.67676,45.84142,2.78478,-.6311,45.88525,2.49891,-.57666,46.01524,2.4552,-.5308,45.99904,2.42174,-.55419,45.82749,2.50913,-.3789,48.83952,1.62552,-.5009,48.63981,1.69042,-.41296,48.6216,1.74919,-.51057,48.90118,1.54946,-.71128,50.49384,.40724,-.66636,50.31282,.39372,-.04589,50.71494,.50912,-.64481,49.19904,1.21765,-.60934,49.11381,1.31392,-.61028,49.11796,1.32941,-.62507,49.22387,1.12244,-.56543,49.33414,1.00702,-.56831,49.1651,1.13888,-.515,49.18684,1.10668,-.44753,44.62152,2.8944,-.43808,44.58738,2.88389,-.4185,44.58027,2.90337,-.32889,44.56733,2.93509,-.33696,44.58855,2.95271,-.42588,44.62956,2.91574,-.39416,44.68291,3.08674,-.35596,44.48518,2.86628,-.35204,44.48899,2.88524,-.3001,44.40703,2.94283,-.51638,44.84924,2.82495,-.55217,44.84753,2.79849,-.49905,44.74092,2.86998,-.50211,44.87424,2.96923,-.47741,44.89198,2.94198,-.68481,45.69609,2.8624,-.71611,45.64681,2.80502,-.5936,45.43861,2.62775,-.6834,45.61653,2.62103,-.78985,45.67796,2.68948,-.74841,45.70226,2.57854,-.67439,45.59471,2.64988,-.71691,45.64093,2.7,-.61552,45.44801,2.65284,-.4843,44.87109,2.84471,-.4507,44.73592,2.95785,-.44453,44.72908,2.93146,-.43567,44.70409,2.97357,-.41947,44.70065,2.93816,-.46091,44.72071,2.90543,-.46481,44.78957,2.91692,-.47067,44.80574,2.88347,-.40745,44.67382,2.98119,-.43261,44.68136,3.01636,-.46035,44.71197,3.02502,-.32959,44.61391,2.99489,-.34502,44.60985,2.97027,-.39442,44.67239,2.94476,-.46652,44.81853,2.93997};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_8()
		{
			double[] value = {-.48045,44.87931,2.894,-.38966,44.65304,3.0289,-.24247,44.47222,2.96901,-.22703,44.47285,3.0092,-.26229,44.39389,3.01639,-.22917,44.51514,3.04281,-.47893,44.64258,2.8838,-.47425,44.63706,2.85137,-.48468,44.76959,2.98912,-.59741,45.45362,2.69256,-.52551,45.03973,2.8069,-.50152,44.9642,2.81347,-.60139,45.46451,2.75136,-.63057,45.5739,2.72004,-.61748,45.55063,2.69048,-.69346,45.89123,2.53396,-.67626,46.52067,2.40501,-.59033,46.49909,2.29471,-.62951,46.46684,2.35777,-.65386,46.54922,2.54475,-.66913,46.48277,2.51511,-.62618,46.28634,2.6444,-.62981,45.94666,2.53903,-.69315,45.93947,2.59999,-.54317,46.24126,2.40818,-.58079,46.35349,2.40026,-.53521,46.24599,2.37871,-.61954,46.37032,2.5399,-.61902,46.26977,2.62205,-.48691,46.27959,2.46039,-.49941,46.31768,2.486,-.63042,46.40049,2.4464,-.49033,46.20534,2.53066,-.50941,46.27747,2.5535,-.52867,46.0095,2.54625,-.58079,46.02853,2.47661,-.51426,46.07654,2.50212,-.55393,46.09212,2.62213,-.51043,46.08019,2.56266,-.544,46.01264,2.61975,-.48546,49.07027,1.27738,-.47618,49.05999,1.27563,-.43913,49.00458,1.32996,-.42061,48.66582,1.38502,-.43814,48.42974,1.48887,-.48062,48.47122,1.50532,-.40194,48.76374,1.45023,-.39845,48.70877,1.49128,-.38969,48.7937,1.46975,-.50263,48.63288,1.56665,-.51526,48.69557,1.56594,-.40671,48.70713,1.53016,-.41817,48.77491,1.50921,-.55105,48.45974,1.72443,-.5309,48.52819,1.64653,-.5132,48.66362,1.62636,-.57656,47.79091,1.85217,-.52377,47.8681,1.75368,-.48187,47.56726,1.8867,-.54195,46.97549,2.09663,-.55541,47.03253,2.12536,-.44661,47.21367,2.00329,-.54225,47.08391,2.20354,-.61566,47.06039,2.31299,-.53749,47.12406,2.24817,-.66459,46.98384,2.24526,-.52287,47.67325,1.90909,-.48384,47.55934,1.90712,-.50367,47.11138,2.12494,-.53688,47.56444,2.08433,-.56227,47.68955,1.98897,-.47256,47.60977,2.00669,-.47496,47.49922,2.07725,-.43392,47.47619,2.02916,-.4518,47.60367,1.94163,-.44119,47.49209,1.96848,-.45865,47.23117,2.02446,-.43569,47.17286,2.12622,-.42743,47.27921,2.04757,-.42296,47.30176,2.10287,-.45176,47.18241,2.18739,-.47414,47.29045,2.17669,-.26909,44.51237,2.93775,-.44665,44.67613,2.90858,-.53575,46.21278,2.59582,-.56114,45.98489,2.58924,-.67114,45.97038,2.66109,-.45822,47.62908,1.96548,-.57487,47.72004,1.93537,-.61871,47.00897,2.40762,-.63047,47.82415,1.89776,-.45182,47.16389,2.16324,-.49425,48.60029,1.54315,-.56191,48.47772,1.61461,-.586,49.03456,1.34171,-.53793,48.88344,1.49328,-.62132,49.11294,1.24927,-.62604,49.12846,1.2129,-.48301,49.05328,1.30272,-.43696,48.87064,1.46177};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_9()
		{
			double[] value = {-.40317,48.6904,1.52009,-.49024,48.60469,1.50345,-.60059,48.41294,1.64422,-.52748,48.52316,1.52464,-.27179,50.46207,.65253,-.75331,49.44734,.95497,-1.29271,49.96001,.80611,-1.30853,49.89235,.78481,-1.18256,50.08354,.5687,-.76377,49.4493,1.05026,-.76511,49.44474,1.01984,-.68933,49.30016,1.11271,-.66487,49.29359,1.14553,-1.112,49.6801,.90751,-.45749,49.00054,1.30255,-.74783,49.9068,.51496,-.73972,49.8423,.93931,-.53824,49.8848,.96142,-.59827,49.94183,.92975,-1.01032,49.96619,.67561,-.37925,50.34127,.76123,-.3207,50.22456,.76724,-.56891,50.63078,.74569,-.52307,50.53335,.7435,-.34135,50.72867,.62045,-.45412,50.77002,.64198,-.3641,48.45144,1.47868,-.36813,48.65125,1.36368,-.46127,46.23227,2.36971,-.06093,46.21802,2.41849,0.0,46.53164,2.30219,0.0,46.22812,2.42516,-.32933,44.49992,2.8239,-.25424,44.3462,2.85666,-.47376,50.05289,.87826,-.6845,50.00752,.90105,-.44568,49.16223,1.36183,-.36624,49.17976,1.37157,-.40288,49.33466,1.24818,-.54805,49.31343,1.18884,-.11198,50.2429,.71522,-.06899,49.9076,.88244,-.20532,49.00111,1.20311,-.12718,49.24653,1.07406,-.10631,49.02113,1.1725,-.22685,49.23059,1.08659,-.53139,44.88004,2.9903,-.55378,47.23608,2.29165,-.50321,47.59455,2.13075,-.5419,47.58302,2.10538,-.52539,47.26491,2.31582,-.11551,44.44139,2.80926,-.119,44.37827,2.82381,-.60536,45.47584,2.80999,-.62215,45.56407,2.75714,-.75453,50.2695,.86845,-.47243,50.40198,.73123,-.64493,49.30471,1.04557,-.36681,48.95465,1.55342,-.40355,48.96292,1.54172,-.49608,47.82232,1.96837,-.37938,47.82937,1.99391,-.35454,47.58115,2.11641,-.17668,47.86069,2.03517,0.0,47.5956,2.13285,0.0,47.86736,2.0079,-.16743,47.59052,2.11472,-.56811,47.01198,2.42342,-.35043,47.22634,2.29498,-.44022,46.94396,2.39486,-.65646,46.04944,2.70211,-.62148,46.05121,2.7338,-.61007,46.29472,2.66321,-.20564,44.4412,3.13191,-.21944,44.56214,3.14884,-.25799,44.39974,3.07435,-.42051,44.76424,3.09102,-.4901,44.89089,3.05717,-.46275,44.72595,3.0554,-.53357,44.88574,3.01207,-.16478,44.95816,3.05409,0.0,44.82059,3.11164,0.0,44.98204,3.05749,-.54022,45.68535,2.86823,-.2965,45.79818,2.81932,-.54329,45.81515,2.80013,-.3141,45.64924,2.86356,-.28336,44.66054,3.13522,-.09496,44.60705,3.16685,-.16082,44.69835,3.1314,-.59056,50.7542,.68543,-.59003,50.83754,.58527,-.35596,50.34414,.36126,-.49149,49.36662,1.0026,-.47081,49.20538,1.08915,-.39303,47.22821,1.98502,-.42549,47.6006,1.84594,-.30861,45.97624,2.48886,-.42438,45.79805,2.52996,-.55357,45.63079,2.54752};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_10()
		{
			double[] value = {-.51815,45.4248,2.63161,-.41698,44.64742,2.7912,-.55151,44.8483,2.78077,-.47789,44.85129,2.74982,-.45498,47.89857,1.72865,-.19014,50.64573,.32617,-.18024,50.66176,.32908,-.92141,50.53134,.70343,-1.06061,50.20898,.7991,-.93386,50.28679,.81649,-.32256,48.94321,1.223,-.40786,48.90732,1.2298,-.67497,49.6931,.74439,-.56752,49.74236,.71593,-.51914,49.54526,.86772,-.60652,49.49034,.87771,-.41745,48.97681,1.19412,-.46321,48.9614,1.22142,-.64213,45.49379,2.88424,-.58161,45.49476,2.91029,-.4831,46.71458,2.48126,-.61267,46.74235,2.4453,-.60933,46.52979,2.57183,-.44676,46.51295,2.56688,-.6693,46.75628,2.43047,-.52978,48.13172,1.87962,-.37194,48.11788,1.89134,-.63331,49.47476,1.07447,-.67262,45.24609,2.90464,-.60263,47.83406,1.94338,-.4054,50.51951,.32843,-.11438,50.10293,.78389,-.16455,48.11446,1.92365,-.16714,48.37408,1.84615,-.66003,50.18782,.89277,-.05012,49.66211,1.02388,-.21138,50.85044,.43073,-.25377,50.83859,.51306,-.90067,50.59365,.63884,-.10036,50.76586,.36786,-.2166,44.57872,2.81257,-.16944,48.59819,1.7349,-.33949,48.61344,1.75863,-.31703,48.36423,1.83055,-.54897,48.39639,1.79708,-.47285,48.37985,1.81589,-1.21708,50.12861,.76603,-.30834,49.91143,.91324,-.40812,48.90856,1.40868,-.42713,48.89459,1.36571,-1.28682,50.06694,.7524,-.66405,49.23377,1.14585,-.50835,48.97461,1.24269,-.57449,49.09388,1.20706,-.60319,49.1213,1.19983,-.4804,49.01167,1.35388,-.44486,48.89891,1.44448,-.49388,46.19589,2.4672,-.6001,47.78022,1.96961,-.61128,45.35757,2.82175,-.54343,47.26203,2.23319,-.47434,48.66116,1.44351,-.65098,46.05317,2.67604,-.73233,45.90419,2.69979,-.67878,45.31997,2.84904,-.65723,45.48748,2.84934,-.61963,45.26851,2.94122,-.5484,45.00832,2.69312,-.58341,45.23535,2.66024,-.54051,45.07663,2.83638,-.29899,44.53975,2.93647,-.27324,44.49109,3.08003,-.42611,44.67462,3.03573,-.70513,45.61039,2.78593,-.6871,45.20494,2.9086,-.28024,44.48482,3.09483,-.93587,49.59008,.96777,-.2589,50.0954,.8166,-.16587,49.90983,.89913,-.68498,45.16268,2.89449,-.60541,45.02937,2.97744,-.59297,45.11862,2.8246,-.79845,50.39474,.82069,-.97228,49.80433,.80596,-.377,50.42006,.32813,-.44234,50.66844,.32962,-.51197,48.90515,1.54436,-.4025,48.96832,1.53584,-.36654,48.96014,1.54824,-.3688,48.9957,1.52111,-.1269,49.01828,1.48713,-.12792,49.01992,1.47002,-.27576,49.00919,1.51034,-.41129,48.99826,1.51419,-.4244,48.88972,1.36767,-.49855,48.90295,1.30503,-.40904,48.95926,1.22828,-.41005,48.92372,1.22486,-.45238,48.91702,1.24634,-.43689,48.9506,1.24307};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_11()
		{
			double[] value = {-.20385,48.98522,1.21257,-.20232,48.97478,1.24244,-.31916,48.98457,1.2275,-.31745,49.01836,1.18679,-.10473,49.00542,1.18105,-.10689,48.9938,1.21982,-.09395,48.93814,1.22102,-.49022,48.85084,1.33461,-.48075,48.90607,1.26832,-.52502,48.86913,1.50416,-.43042,48.88344,1.45441,-.43745,48.8764,1.46004,-.94627,50.44459,.62136,-1.15112,50.06852,.52921,-1.21777,49.99303,.57482,.5936,45.43861,2.62775,.51815,45.4248,2.63161,.42438,45.79805,2.52996,.39303,47.22821,1.98502,.49149,49.36662,1.0026,.3459,50.29408,.38557,.35596,50.34414,.36126,.71128,50.49384,.40724,.75757,50.57619,.45474,.89437,50.30586,.47574,.09496,44.60705,3.16685,.21944,44.56214,3.14884,.28336,44.66054,3.13522,.16082,44.69835,3.1314,.54329,45.81515,2.80013,.3141,45.64924,2.86356,.54022,45.68535,2.86823,.2965,45.79818,2.81932,.16478,44.95816,3.05409,.53357,44.88574,3.01207,.42051,44.76424,3.09102,.4901,44.89089,3.05717,.20564,44.4412,3.13191,.26945,44.52945,3.11758,.61007,46.29472,2.66321,.62148,46.05121,2.7338,.35043,47.22634,2.29498,.36681,48.95465,1.55342,.27179,50.46207,.65253,.47243,50.40198,.73123,.119,44.37827,2.82381,.11551,44.44139,2.80926,.71981,45.23915,2.79196,.10631,49.02113,1.1725,.22685,49.23059,1.08659,.20532,49.00111,1.20311,.12718,49.24653,1.07406,.40288,49.33466,1.24818,.36624,49.17976,1.37157,.93851,50.32134,.52952,.27074,50.83329,.36618,.19864,50.81324,.37614,.6845,50.00752,.90105,.53575,46.21278,2.59582,.06093,46.21802,2.41849,.34135,50.72867,.62045,1.01032,49.96619,.67561,.94734,49.80688,.67921,1.02576,49.91684,.61435,.73972,49.8423,.93931,.963,49.92848,.49837,1.08794,49.95916,.51753,.72937,49.85798,.59104,.74783,49.9068,.51496,1.112,49.6801,.90751,1.28649,49.80037,.8201,1.25134,49.8572,.84275,1.14513,49.66438,.8781,1.30853,49.89235,.78481,1.29271,49.96001,.80611,.16985,50.62712,.57816,.52748,48.52316,1.52464,.56191,48.47772,1.61461,.48062,48.47122,1.50532,.55096,48.8613,1.54095,.43814,48.42974,1.48887,.49425,48.60029,1.54315,.53262,48.85614,1.51032,.43696,48.87064,1.46177,.62132,49.11294,1.24927,.50152,44.9642,2.81347,.57656,47.79091,1.85217,.26909,44.51237,2.93775,.32959,44.61391,2.99489,.47414,47.29045,2.17669,.53688,47.56444,2.08433,.54225,47.08391,2.20354,.46606,48.68212,1.40886,.42061,48.66582,1.38502,.66314,45.30942,2.71821,.57817,45.05844,3.00618,.2837,44.60527,3.04073,.31416,44.61807,3.01947,.43567,44.70409,2.97357,.49515,44.98336,2.91789};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_12()
		{
			double[] value = {.35204,44.48899,2.88524,.39416,44.68291,3.08674,.3172,44.62074,3.10283,.37583,44.65742,3.07682,.83974,50.20905,.43643,.66636,50.31282,.39372,.67676,45.84142,2.78478,.67625,45.10195,2.76631,.58765,45.06708,2.77783,.57649,45.09267,2.89613,.66752,45.15413,2.81534,1.10115,49.89698,.85761,1.16397,49.93495,.85713,1.03562,50.15658,.47735,1.14809,49.99485,.7263,1.21377,49.98849,.58536,1.26228,49.99673,.64221,1.10177,49.83156,.5759,1.1415,49.91082,.56989,.96304,49.62804,.76026,1.01688,49.68671,.66287,1.27092,49.80793,.80614,.35209,50.21313,.44895,.47563,50.12736,.43096,.47104,50.079,.50803,.99265,49.99903,.48685,.15744,50.81376,.42213,.17958,50.79865,.48926,.22622,50.68368,.32704,.33606,50.83995,.37612,.37215,50.90412,.44538,.22159,50.17291,.49592,.29109,44.53899,3.10825,.3128,44.60657,3.08847,.28676,44.54195,3.09395,.35541,44.63961,3.06622,1.24293,50.10033,.65641,.54991,48.86734,1.53769,.53508,48.89144,1.52317,.51905,48.91097,1.52258,.12781,49.02362,1.46755,.12567,49.05634,1.44911,.31916,48.98457,1.2275,.41468,48.96619,1.20105,.41003,48.96182,1.22672,.31745,49.01836,1.18679,.20269,48.97029,1.24478,.20096,48.92606,1.23304,.09808,48.95278,1.21569,.10614,48.98943,1.22127,.46069,48.95227,1.22775,.4378,48.95395,1.24112,.47642,48.88043,1.31444,.42424,48.86719,1.37532,.41684,48.87537,1.37096,.39156,48.88808,1.41585,.39692,48.87703,1.42112,.443,48.89442,1.44848,.43193,48.88872,1.4512,.3932,48.89382,1.41372,.40525,48.90432,1.41111,.52602,48.8743,1.50093,.86922,50.42831,.51026,.83205,50.62405,.5446,.8983,50.46538,.56742,1.18623,50.17011,.66793,.28918,44.01482,3.03169,.23447,44.18415,3.01707,.20556,44.18334,3.04298,-.22801,44.17892,3.04734,-.20674,44.30176,3.07784,-.26546,44.29524,3.01151,-.26926,44.1814,3.03075,-.18087,43.98063,2.99035,-.26294,44.19677,2.94928,-.21336,44.20166,2.92763,-.30857,43.95564,3.02179,-.22282,44.30958,2.87244,-.27846,44.29447,2.93842,-.1289,44.31289,2.85127,0.0,44.49533,3.17233,-.06853,44.28656,3.11829,.02217,44.29649,3.14998,-.07532,44.48295,3.15868,.12107,43.58459,3.24152,.15784,43.60471,3.26264,.08222,43.60841,3.24105,-.00243,43.7185,3.08002,-.06801,43.67876,3.07757,-.02295,43.83125,3.02647,-.11806,43.85035,3.04507,-.09337,43.83262,3.14786,-.08955,43.66619,3.16132,-.01625,43.71872,3.17841,.00161,43.83964,3.15047,.10343,43.85876,3.1897,.12042,43.77669,3.23403,-.09343,44.16306,3.06108,-.00822,43.99571,3.11384,.03161,44.16389,3.14791};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_13()
		{
			double[] value = {-.15957,43.97236,3.12192,.09187,44.28983,3.10935,.07532,44.48295,3.15868,.0559,44.01676,3.13721,.12568,44.16706,3.05053,.15747,44.00984,3.07139,-.14046,44.20722,2.90342,.23332,44.21182,2.92331,.27711,44.02327,2.9636,.11554,44.21487,2.89037,.11558,44.01635,2.94868,-.05455,44.01392,2.98004,-.0036,44.22579,2.87886,-.01356,44.0184,2.95445,.24213,43.76543,3.14784,.22738,43.69009,3.22276,.22945,43.68717,3.12972,.09675,43.67972,3.1248,.07151,43.66394,3.21189,.24929,43.7847,3.0328,.28344,43.85115,3.088,.26635,43.88793,3.01052,.13873,43.69746,3.25935,.20089,43.76688,3.18803,.16584,43.8481,3.12736,-.17326,43.68469,3.15926,-.18835,43.8265,3.14464,-.28291,43.81366,3.12396,-.23966,43.80947,3.06409,-.14595,43.69675,3.09326,.0804,43.8157,3.01666,.10324,43.57918,3.17192,.16228,43.58254,3.19093,.12647,43.57368,3.21166,-.07662,43.95472,3.00272,-.17291,43.95171,3.0018,.25319,44.30619,3.00754,.23956,44.30057,3.04377,.18341,44.30156,3.08716,-.31431,43.94442,3.08361,.23888,44.19092,2.99036,.2446,44.29648,2.88704,.12589,44.31562,2.87109,.00269,44.30994,2.86287,-.0129,43.93468,2.98555,0.0,44.38311,2.8312,.25531,44.30613,2.94737,.39791,48.87147,1.42409,.42561,48.86206,1.37862,.20232,48.97478,1.24244,.20028,48.91015,1.23939,.452,48.90493,1.25126,.31849,49.0288,1.18014,.20385,48.98522,1.21257,.18062,48.68834,1.35067,.27493,49.00476,1.51586,0.0,49.03545,1.44707,.12741,49.01342,1.49289,0.0,49.04007,1.44131,.12516,49.06375,1.44644,.2764,49.05627,1.47826,.37061,49.0025,1.51918,0.0,49.04136,1.42515,.35194,44.71193,3.11334,.19855,44.74815,3.11445,.24477,44.79276,3.09567,0.0,44.77491,3.12786,.33794,50.07643,.53495,.59175,49.95707,.54625,.45834,49.95786,.5798,.57875,49.83979,.62829,.70217,49.77344,.65914,.22,50.68469,.56934,.76708,49.99688,.46542,.59015,50.0159,.46584,.6079,50.10531,.42169,.34838,49.21606,1.09343,.37988,49.41153,.98547,.41582,49.59455,.85418,.25971,49.45926,.96733,.28541,49.67254,.82555,.32159,49.9251,.64397,.44565,49.84129,.67453,.49134,50.19109,.39352,.53507,50.39368,.35118,.5197,50.27446,.3606,1.2918,49.97356,.70128,1.29077,49.8942,.77388,1.14301,49.91128,.55802,1.13501,49.90952,.77009,.79977,50.09058,.44023,.91507,49.75236,.91822,1.20551,50.01281,.83485,.59297,45.11862,2.8246,.15105,49.49779,.94224,.57309,50.58159,.35699,.16905,49.72817,.79617,.20724,49.9975,.61212,.16587,49.90983,.89913,.18141,44.97327,2.75212};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_14()
		{
			double[] value = {.29899,44.53975,2.93647,.62211,46.72582,2.22221,.69817,46.74309,2.32113,.57148,48.12846,1.6462,.69375,48.16058,1.75385,1.00759,50.03301,.88159,1.04305,50.09845,.85622,.84579,50.108,.89812,.45259,46.97875,2.08385,.39571,46.73925,2.20083,.33776,46.99093,2.09536,.49213,46.72949,2.19939,0.0,46.77751,2.19963,0.0,47.02705,2.0966,.22576,47.24949,1.99351,.18434,48.49659,1.46127,.3641,48.45144,1.47868,.30004,48.84011,1.62511,.18047,46.47608,2.59504,0.0,46.29374,2.69003,.19365,46.28976,2.6654,0.0,46.48521,2.61403,.37952,46.28265,2.65956,.11409,45.96492,2.50573,.38227,46.50262,2.29388,.46521,46.49408,2.28461,.18386,45.13098,2.73462,.4293,45.64122,2.56911,.1357,45.72912,2.58685,.16929,45.57135,2.62941,0.0,45.28501,2.72471,.17428,45.41125,2.67323,.17907,45.26992,2.70669,0.0,45.42413,2.69526,.39324,45.24427,2.68665,.38674,45.40368,2.64984,0.0,44.46559,2.8114,0.0,44.65012,2.79073,.64203,50.19649,.39679,.49271,50.79155,.38348,.63072,50.69959,.41487,.25867,49.35238,1.24804,.11046,49.19799,1.35345,.2667,49.19193,1.36309,.11132,49.35341,1.24255,.46919,49.49966,1.11734,.7616,49.61585,.99084,.58859,49.65266,1.03276,.90757,50.18071,.86634,.17892,49.68516,1.0344,.15357,48.82693,1.62711,0.0,48.82579,1.58343,.11677,49.54141,1.12141,.29107,49.52261,1.13288,0.0,45.14819,2.74889,0.0,45.94597,2.53386,0.0,45.70606,2.62075,0.0,44.72953,3.14389,0.0,44.62564,3.17414,.64557,48.14194,1.85899,.35856,49.68724,1.04282,.89601,49.96203,.88037,0.0,46.857,2.45966,.16729,46.66492,2.52196,.15288,46.88006,2.42983,0.0,46.65494,2.54568,0.0,47.20789,2.3181,.1595,47.19937,2.29963,.40256,46.03262,2.73214,.20845,46.02306,2.75731,0.0,45.78784,2.86404,0.0,46.02312,2.79788,0.0,45.42769,2.96289,.30361,45.25836,2.95719,.30954,45.46028,2.91006,0.0,45.25637,2.99728,.44242,45.47991,2.90568,.366,45.08101,3.00726,.4893,45.25138,2.94538,.26382,45.10107,3.00597,0.0,45.11046,3.033,.30926,44.93054,3.06397,0.0,45.65893,2.90363,.79055,50.65187,.7049,0.0,50.06101,.54156,0.0,49.55052,.90902,0.0,49.80179,.73507,0.0,49.27087,1.05883,.47152,48.14708,1.63088,.35406,48.17135,1.61833,.36083,47.92786,1.71267,.23894,47.62566,1.82816,0.0,47.27993,1.99606,0.0,47.65945,1.83956,0.0,48.01468,1.70168,0.0,48.21818,1.61678,0.0,44.80159,2.77693,-1.08289,50.16137,.5363,-.39791,48.87147,1.42409,-.41003,48.96182,1.22672};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_15()
		{
			double[] value = {-.20028,48.91015,1.23939,-.452,48.90493,1.25126,-.50277,48.91067,1.30123,-.41468,48.96619,1.20105,-.31849,49.0288,1.18014,0.0,49.0015,1.18061,-.34838,49.21606,1.09343,-.12741,49.01342,1.49289,-.27493,49.00476,1.51586,-.12516,49.06375,1.44644,0.0,49.08497,1.41146,-.37061,49.0025,1.51918,-.2764,49.05627,1.47826,-.35194,44.71193,3.11334,-.24477,44.79276,3.09567,-.19855,44.74815,3.11445,-.33794,50.07643,.53495,-.45834,49.95786,.5798,-.57875,49.83979,.62829,-.59175,49.95707,.54625,-.70217,49.77344,.65914,-.19864,50.81324,.37614,-.1495,50.77634,.37173,-.37988,49.41153,.98547,-.25971,49.45926,.96733,-.28541,49.67254,.82555,-.44565,49.84129,.67453,-.32159,49.9251,.64397,-.41582,49.59455,.85418,-.5197,50.27446,.3606,-.49134,50.19109,.39352,-1.2918,49.97356,.70128,-1.29077,49.8942,.77388,-1.14301,49.91128,.55802,-1.13501,49.90952,.77009,-1.13634,50.16581,.60373,-1.20551,50.01281,.83485,-.15105,49.49779,.94224,-.16905,49.72817,.79617,-.20724,49.9975,.61212,-.79055,50.65187,.7049,-.7493,50.75221,.61789,-.38527,44.53444,2.89441,0.0,44.973,2.76665,-.12589,44.79821,2.77304,-.18141,44.97327,2.75212,-.33182,44.70255,2.786,-.30016,44.91957,2.7519,-.31394,44.55352,2.93579,-.57817,45.05844,3.00618,-.46606,48.68212,1.40886,-.62211,46.72582,2.22221,-.69817,46.74309,2.32113,-.57148,48.12846,1.6462,-.69375,48.16058,1.75385,-.42561,48.86206,1.37862,-1.04305,50.09845,.85622,-.49213,46.72949,2.19939,-.45259,46.97875,2.08385,-.22576,47.24949,1.99351,-.33776,46.99093,2.09536,-.18434,48.49659,1.46127,-.18062,48.68834,1.35067,0.0,48.49099,1.46319,0.0,48.60304,1.70348,-.64557,48.14194,1.85899,-.37952,46.28265,2.65956,-.18047,46.47608,2.59504,-.19365,46.28976,2.6654,-.11409,45.96492,2.50573,-.38227,46.50262,2.29388,-.30016,46.21897,2.39181,-.46521,46.49408,2.28461,-.18386,45.13098,2.73462,-.1357,45.72912,2.58685,0.0,45.56403,2.66028,-.16929,45.57135,2.62941,-.4293,45.64122,2.56911,-.38674,45.40368,2.64984,-.17907,45.26992,2.70669,-.39324,45.24427,2.68665,-.17428,45.41125,2.67323,-.1112,44.63184,2.78896,-.64203,50.19649,.39679,-.6079,50.10531,.42169,-.5441,50.85802,.47183,-.63072,50.69959,.41487,-.68881,50.76312,.50809,-.49271,50.79155,.38348,-.91507,49.75236,.91822,-.89601,49.96203,.88037,-.2667,49.19193,1.36309,-.25867,49.35238,1.24804,-.11046,49.19799,1.35345,0.0,49.34948,1.22957,-.11132,49.35341,1.24255,0.0,49.19658,1.32909,-.58859,49.65266,1.03276,-.7616,49.61585,.99084,-.46919,49.49966,1.11734};
			return value;
		}
		private double[] getsternum_Coord_7_15_point_16()
		{
			double[] value = {-.84579,50.108,.89812,-.90757,50.18071,.86634,-.11677,49.54141,1.12141,-.17892,49.68516,1.0344,-.15357,48.82693,1.62711,-.29107,49.52261,1.13288,-.35856,49.68724,1.04282,-1.00759,50.03301,.88159,-.15288,46.88006,2.42983,-.1595,47.19937,2.29963,-.16729,46.66492,2.52196,-.40256,46.03262,2.73214,-.20845,46.02306,2.75731,-.26382,45.10107,3.00597,-.30361,45.25836,2.95719,-.30954,45.46028,2.91006,-.44242,45.47991,2.90568,-.4893,45.25138,2.94538,-.30926,44.93054,3.06397,-.366,45.08101,3.00726,-.59015,50.0159,.46584,-.22,50.68469,.56934,-.57309,50.58159,.35699,-.47152,48.14708,1.63088,-.36083,47.92786,1.71267,-.35406,48.17135,1.61833,-.23894,47.62566,1.82816,-.39571,46.73925,2.20083,-.31072,45.10085,2.72597,-.53507,50.39368,.35118,-.79977,50.09058,.44023,-.30004,48.84011,1.62511,-.76708,49.99688,.46542,.38527,44.53444,2.89441,.09991,43.9187,2.98476};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlcartend_Geo_6_20_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,9,10,7,-1,11,12,13,-1,11,14,12,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,19,22,20,-1,9,23,10,-1,23,24,10,-1,9,25,12,-1,11,13,26,-1,13,27,26,-1,28,29,30,-1,28,31,29,-1,9,8,25,-1,3,32,33,-1,3,2,32,-1,34,35,36,-1,37,38,34,-1,38,39,34,-1,40,41,42,-1,40,43,41,-1,44,45,46,-1,45,47,46,-1,48,49,50,-1,48,51,49,-1,35,39,50,-1,39,52,50,-1,53,54,55,-1,54,52,55,-1,56,55,57,-1,56,53,55,-1,42,41,57,-1,41,58,57,-1,59,60,61,-1,60,58,61,-1,62,63,64,-1,63,65,64,-1,66,67,68,-1,66,69,67,-1,65,66,64,-1,65,70,66,-1,71,72,73,-1,71,74,72,-1,75,76,77,-1,78,79,80,-1,78,81,79,-1,82,83,84,-1,82,85,83,-1,86,84,87,-1,86,82,84,-1,88,89,90,-1,88,91,89,-1,92,93,94,-1,94,95,92,-1,88,96,97,-1,98,96,99,-1,87,96,86,-1,96,88,90,-1,96,87,95,-1,100,101,102,-1,102,103,100,-1,104,105,106,-1,107,100,103,-1,108,109,110,-1,111,112,113,-1,113,103,111,-1,103,113,107,-1,114,115,116,-1,116,117,114,-1,115,118,119,-1,119,116,115,-1,120,121,122,-1,120,123,121,-1,124,115,125,-1,115,114,125,-1,126,127,128,-1,128,129,126,-1,123,130,131,-1,123,132,130,-1,130,133,131,-1,134,135,133,-1,119,118,133,-1,136,121,123,-1,123,131,136,-1,134,133,137,-1,138,139,140,-1,141,142,143,-1,144,145,146,-1,144,147,145,-1,148,149,144,-1,148,150,149,-1,147,151,152,-1,153,154,155,-1,154,156,155,-1,157,158,159,-1,160,161,155,-1,162,163,164,-1,164,165,162,-1,145,147,166,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,173,176,174,-1,177,170,172,-1,178,179,180,-1,179,181,180,-1,182,183,184,-1,182,179,183,-1,180,163,162,-1,162,185,180,-1,142,186,143,-1,163,187,186,-1,163,188,187,-1,183,189,190,-1,186,142,164,-1,164,163,186,-1,191,192,193,-1,192,194,193,-1,195,196,197,-1,143,193,198,-1,143,148,141,-1,168,199,200,-1,200,201,168,-1,190,177,184,-1,189,178,175,-1,178,202,175,-1,159,203,157,-1,204,143,187,-1,143,198,150,-1,171,200,172,-1,172,184,177,-1,172,182,184,-1,202,205,173,-1,206,207,208,-1,207,209,208,-1,210,211,212,-1,211,213,212,-1,214,215,216,-1,216,217,214,-1,218,219,220,-1,218,213,219,-1,215,221,216,-1,215,222,221,-1,223,224,225,-1,223,226,224,-1,227,228,229,-1,230,231,232,-1,233,234,235,-1,229,236,237,-1,237,226,229,-1,238,236,239,-1,238,240,236,-1,241,242,243,-1,244,245,243,-1,246,247,243,-1,243,242,248,-1,249,231,250,-1,251,231,252,-1,231,230,252,-1,251,250,231,-1,253,254,255,-1,253,256,254,-1,257,258,259,-1,258,260,259,-1,261,262,256,-1,262,263,256,-1,264,265,262,-1,266,267,251,-1,266,268,267,-1,269,270,271,-1,265,259,260,-1,265,272,259,-1,270,273,252,-1,252,274,270,-1,269,266,273,-1,275,264,261,-1,272,265,264,-1,276,277,278,-1,278,279,276,-1,280,281,282,-1,280,283,281,-1,284,285,286,-1,284,287,285,-1,288,289,290,-1,288,291,289,-1,292,293,294,-1,292,295,293,-1,293,296,297,-1,298,299,300,-1,299,301,302,-1,299,298,301,-1,303,304,305,-1,304,306,305,-1,307,308,309,-1,308,301,309,-1,310,304,311,-1,310,312,304,-1,313,314,315,-1,314,316,315,-1,317,318,319,-1,318,283,319,-1,293,295,320,-1,320,296,293,-1,321,307,309,-1,321,316,307,-1,298,300,322,-1,323,324,325,-1,325,326,323,-1,325,327,326,-1,325,328,327,-1,329,330,276,-1,330,331,276,-1,332,333,334,-1,333,335,334,-1,336,337,338,-1,323,339,340,-1,323,341,339,-1,342,343,344,-1,332,345,333,-1,345,338,333,-1,342,346,347,-1,348,349,350,-1,350,351,348,-1,352,353,354,-1,354,355,352,-1,356,357,358,-1,356,359,357,-1,360,361,359,-1,359,356,360,-1,362,363,364,-1,348,365,366,-1,365,367,366,-1,368,369,370,-1,370,369,371,-1,371,372,370,-1,373,374,375,-1,374,376,375,-1,377,378,379,-1,379,380,377,-1,373,375,379,-1,379,378,373,-1,381,376,382,-1,376,383,382,-1,384,385,374,-1,374,386,384,-1};
			return value;
		}
		private int[] getlcartend_Geo_6_20_coordIndex_2()
		{
			int[] value = {387,368,352,-1,352,349,387,-1,348,366,387,-1,388,389,390,-1,391,392,393,-1,391,394,392,-1,395,396,397,-1,398,399,400,-1,399,401,400,-1,401,402,403,-1,401,399,402,-1,390,404,405,-1,390,406,404,-1,407,397,403,-1,397,401,403,-1,408,393,409,-1,408,391,393,-1,402,399,410,-1,399,411,410,-1,362,365,363,-1,365,412,363,-1,413,414,398,-1,398,415,413,-1,408,396,395,-1,389,388,416,-1,389,406,390,-1,417,418,419,-1,420,421,422,-1,421,423,422,-1,424,425,426,-1,425,427,426,-1,428,429,430,-1,428,361,429,-1,418,431,432,-1,432,419,418,-1,433,434,435,-1,433,436,434,-1,437,438,439,-1,439,421,437,-1,419,440,420,-1,419,432,440,-1,441,442,434,-1,442,431,434,-1,428,430,438,-1,438,437,428,-1,443,428,437,-1,437,440,443,-1,444,424,426,-1,426,436,444,-1,445,446,447,-1,446,448,447,-1,449,450,451,-1,451,452,449,-1,453,454,455,-1,453,456,454,-1,457,458,459,-1,457,460,458,-1,461,462,463,-1,463,464,461,-1,465,466,467,-1,465,468,466,-1,469,446,445,-1,469,470,446,-1,471,472,473,-1,474,475,476,-1,450,477,451,-1,450,478,477,-1,460,479,458,-1,460,480,479,-1,481,482,483,-1,481,484,482,-1,468,485,466,-1,468,486,485,-1,448,478,450,-1,448,487,478,-1,488,489,487,-1,490,491,489,-1,492,493,494,-1,479,492,495,-1,479,496,492,-1,497,494,493,-1,498,499,500,-1,501,502,503,-1,502,504,503,-1,505,506,507,-1,506,508,507,-1,505,507,509,-1,505,509,510,-1,511,512,513,-1,514,515,513,-1,516,517,518,-1,503,509,519,-1,519,501,503,-1,515,520,513,-1,472,471,521,-1,499,522,500,-1,523,524,525,-1,525,526,523,-1,513,512,514,-1,527,510,509,-1,509,503,527,-1,528,529,510,-1,510,527,528,-1,530,514,531,-1,530,515,514,-1,520,532,502,-1,502,501,520,-1,510,529,505,-1,529,506,505,-1,473,528,504,-1,504,471,473,-1,525,533,508,-1,508,534,525,-1,535,536,537,-1,538,522,499,-1,492,496,539,-1,539,493,492,-1,540,539,541,-1,539,496,541,-1,540,542,543,-1,486,543,485,-1,486,544,543,-1,494,545,546,-1,480,496,479,-1,480,541,496,-1,547,494,546,-1,493,548,497,-1,549,490,489,-1,550,488,487,-1,487,470,550,-1,466,485,551,-1,551,552,466,-1,486,483,482,-1,486,468,483,-1,546,545,462,-1,545,463,462,-1,458,495,553,-1,458,479,495,-1,492,547,495,-1,492,494,547,-1,525,534,526,-1,554,555,556,-1,464,463,481,-1,481,557,464,-1,558,468,465,-1,558,483,468,-1,467,552,559,-1,467,466,552,-1,432,431,560,-1,431,442,560,-1,424,444,561,-1,561,562,424,-1,417,444,433,-1,444,436,433,-1,563,564,565,-1,564,562,565,-1,562,564,425,-1,425,424,562,-1,566,389,567,-1,389,416,567,-1,395,391,408,-1,413,415,568,-1,568,569,413,-1,416,388,570,-1,388,571,570,-1,572,573,574,-1,573,367,574,-1,574,367,365,-1,365,362,574,-1,400,409,398,-1,409,415,398,-1,414,411,398,-1,411,399,398,-1,400,401,396,-1,401,397,396,-1,391,395,394,-1,406,389,572,-1,388,390,571,-1,390,405,571,-1,368,353,352,-1,370,403,402,-1,402,353,370,-1,348,387,349,-1,575,375,576,-1,575,379,375,-1,385,383,374,-1,383,376,374,-1,577,578,579,-1,579,580,577,-1,581,582,583,-1,582,584,583,-1,577,581,386,-1,386,578,577,-1,366,585,387,-1,353,368,370,-1,586,587,588,-1,589,590,591,-1,592,593,594,-1,353,402,410,-1,410,354,353,-1,412,348,351,-1,412,365,348,-1,338,345,336,-1,339,336,345,-1,342,344,346,-1,340,345,332,-1,340,339,345,-1,347,595,342,-1,326,327,344,-1,344,343,326,-1,339,341,336,-1,596,333,338,-1,338,337,596,-1,597,327,328,-1,328,598,597,-1,323,599,324,-1,323,340,599,-1,597,331,330,-1,597,598,331,-1,600,301,308,-1,601,602,320,-1,602,296,320,-1,603,601,320,-1,320,604,603,-1,605,316,314,-1,605,307,316,-1,300,606,607,-1,607,322,300,-1,608,609,610,-1,610,611,608,-1,603,604,612,-1,612,613,603,-1,311,304,303,-1,303,614,311,-1,609,608,315,-1,608,613,315,-1,600,317,615,-1,615,302,600,-1,616,312,617,-1,312,310,617,-1,302,301,600,-1,611,614,602,-1,618,619,620,-1,618,621,619,-1,290,289,295,-1,295,292,290,-1,286,285,291,-1,291,288,286,-1,282,287,284,-1,282,281,287,-1};
			return value;
		}
		private int[] getlcartend_Geo_6_20_coordIndex_3()
		{
			int[] value = {269,273,270,-1,253,261,256,-1,253,275,261,-1,273,266,251,-1,251,252,273,-1,274,622,270,-1,622,271,270,-1,266,269,268,-1,260,263,262,-1,262,265,260,-1,261,264,262,-1,622,623,624,-1,622,274,623,-1,625,626,267,-1,626,251,267,-1,626,250,251,-1,622,257,259,-1,622,624,257,-1,250,627,249,-1,626,627,250,-1,248,246,243,-1,245,241,243,-1,242,241,235,-1,235,628,242,-1,237,246,629,-1,246,248,629,-1,247,244,243,-1,630,240,238,-1,630,631,240,-1,226,629,224,-1,226,237,629,-1,239,236,229,-1,238,632,633,-1,227,226,223,-1,227,229,226,-1,634,222,215,-1,634,635,222,-1,636,637,638,-1,637,639,638,-1,640,212,641,-1,640,642,212,-1,208,215,214,-1,208,634,215,-1,643,644,642,-1,643,645,644,-1,212,213,641,-1,213,218,641,-1,646,173,205,-1,646,176,173,-1,170,177,203,-1,203,647,170,-1,199,648,200,-1,199,649,648,-1,191,143,650,-1,143,186,187,-1,157,651,158,-1,190,189,175,-1,652,650,143,-1,193,143,191,-1,649,199,167,-1,204,187,188,-1,188,649,204,-1,183,190,184,-1,653,143,204,-1,178,189,183,-1,183,179,178,-1,179,648,181,-1,179,182,648,-1,165,185,162,-1,165,654,185,-1,170,655,171,-1,170,647,655,-1,173,175,202,-1,205,202,185,-1,151,656,140,-1,151,149,656,-1,140,656,138,-1,656,194,138,-1,657,138,192,-1,138,194,192,-1,139,658,140,-1,167,653,204,-1,204,649,167,-1,199,168,167,-1,659,660,655,-1,655,647,659,-1,161,661,660,-1,157,174,651,-1,155,156,646,-1,156,176,646,-1,161,660,153,-1,153,155,161,-1,144,149,147,-1,149,151,147,-1,148,143,150,-1,169,168,201,-1,117,116,662,-1,116,663,662,-1,119,133,130,-1,136,133,135,-1,118,137,133,-1,115,124,118,-1,124,137,118,-1,127,126,134,-1,126,135,134,-1,131,133,136,-1,120,132,123,-1,120,664,132,-1,126,122,121,-1,126,129,122,-1,124,125,128,-1,128,127,124,-1,116,119,132,-1,119,130,132,-1,116,132,663,-1,132,664,663,-1,111,103,102,-1,105,665,106,-1,110,109,665,-1,665,105,110,-1,109,101,100,-1,109,108,101,-1,108,666,101,-1,108,667,666,-1,665,113,106,-1,665,107,113,-1,101,666,668,-1,668,102,101,-1,95,94,96,-1,98,86,96,-1,90,99,96,-1,669,97,96,-1,96,94,669,-1,80,91,88,-1,88,97,80,-1,98,82,86,-1,98,670,82,-1,89,671,672,-1,89,673,671,-1,84,674,92,-1,84,83,674,-1,93,81,78,-1,93,675,81,-1,80,676,91,-1,80,79,676,-1,69,677,67,-1,677,678,67,-1,679,680,75,-1,75,77,679,-1,68,67,75,-1,75,680,68,-1,62,64,681,-1,57,58,56,-1,58,60,56,-1,55,38,42,-1,42,57,55,-1,55,52,38,-1,52,39,38,-1,50,52,48,-1,52,54,48,-1,682,34,36,-1,40,42,37,-1,42,38,37,-1,35,34,39,-1,7,10,683,-1,9,14,23,-1,9,12,14,-1,1,684,32,-1,32,2,1,-1,7,683,685,-1,21,686,19,-1,686,687,19,-1,26,31,11,-1,31,28,11,-1,688,27,689,-1,27,13,689,-1,685,683,690,-1,691,692,17,-1,17,16,691,-1,693,6,3,-1,3,33,693,-1,22,4,694,-1,694,30,22,-1,13,25,689,-1,13,12,25,-1,4,6,694,-1,3,5,0,-1,0,2,3,-1,689,8,692,-1,689,25,8,-1,685,695,15,-1,685,690,695,-1,696,697,698,-1,696,684,697,-1,0,699,1,-1,699,0,687,-1,5,22,19,-1,5,4,22,-1,694,28,30,-1,694,700,28,-1,684,701,32,-1,701,684,696,-1,700,23,14,-1,700,693,23,-1,702,697,703,-1,698,697,702,-1,688,692,691,-1,692,688,689,-1,704,687,686,-1,699,687,704,-1,15,705,18,-1,695,705,15,-1,696,683,701,-1,696,690,683,-1,6,700,694,-1,6,693,700,-1,61,45,59,-1,45,61,47,-1,44,49,51,-1,44,46,49,-1,34,706,37,-1,34,682,706,-1,71,707,708,-1,71,73,707,-1,74,77,709,-1,679,77,74,-1,710,711,712,-1,72,711,710,-1,713,714,715,-1,714,713,70,-1,66,713,69,-1,66,70,713,-1,680,681,68,-1,681,680,62,-1,714,707,710,-1,707,714,708,-1,76,67,678,-1,76,75,67,-1,675,92,674,-1,675,93,92,-1,716,672,671,-1,716,670,672,-1,89,676,673,-1,91,676,89,-1,670,99,672,-1,99,670,98,-1,80,669,78,-1,669,80,97,-1,104,717,718,-1,112,717,104,-1};
			return value;
		}
		private int[] getlcartend_Geo_6_20_coordIndex_4()
		{
			int[] value = {719,102,668,-1,719,111,102,-1,108,720,667,-1,110,720,108,-1,107,109,100,-1,107,665,109,-1,121,135,126,-1,121,136,135,-1,134,124,127,-1,124,134,137,-1,164,145,165,-1,164,146,145,-1,155,721,160,-1,155,646,721,-1,651,176,156,-1,651,174,176,-1,158,659,159,-1,659,158,154,-1,154,660,659,-1,154,153,660,-1,169,196,167,-1,169,197,196,-1,192,169,657,-1,197,169,192,-1,200,722,201,-1,200,171,722,-1,723,171,655,-1,171,723,722,-1,188,648,649,-1,188,181,648,-1,149,198,656,-1,198,149,150,-1,650,195,197,-1,650,652,195,-1,196,653,167,-1,195,653,196,-1,175,157,190,-1,174,157,175,-1,647,159,659,-1,647,203,159,-1,724,725,726,-1,724,727,725,-1,728,727,724,-1,728,729,727,-1,730,634,731,-1,634,730,635,-1,732,733,734,-1,726,733,732,-1,216,643,217,-1,216,645,643,-1,642,210,212,-1,642,644,210,-1,636,219,735,-1,219,636,736,-1,209,638,731,-1,737,638,209,-1,643,640,738,-1,643,642,640,-1,736,739,740,-1,736,737,739,-1,206,214,741,-1,206,208,214,-1,742,216,221,-1,216,742,645,-1,644,732,210,-1,644,743,732,-1,636,744,637,-1,735,744,636,-1,639,731,638,-1,639,730,731,-1,222,729,221,-1,727,729,222,-1,728,743,742,-1,743,728,724,-1,745,734,733,-1,745,744,734,-1,746,730,639,-1,730,746,747,-1,748,229,228,-1,748,239,229,-1,749,234,750,-1,749,751,234,-1,238,752,630,-1,752,238,633,-1,224,628,751,-1,224,629,628,-1,235,630,233,-1,235,631,630,-1,247,237,236,-1,247,246,237,-1,629,242,628,-1,629,248,242,-1,241,631,235,-1,241,245,631,-1,254,263,753,-1,263,254,256,-1,623,252,230,-1,623,274,252,-1,268,253,267,-1,268,275,253,-1,754,755,756,-1,754,319,755,-1,297,757,758,-1,297,305,757,-1,759,760,306,-1,760,759,761,-1,762,619,763,-1,620,619,762,-1,764,621,618,-1,764,765,621,-1,610,321,766,-1,610,609,321,-1,611,767,608,-1,611,768,767,-1,317,754,615,-1,317,319,754,-1,616,621,765,-1,621,616,607,-1,313,613,612,-1,315,613,313,-1,604,291,612,-1,604,289,291,-1,613,767,603,-1,608,767,613,-1,602,768,611,-1,602,601,768,-1,322,616,617,-1,322,607,616,-1,605,283,318,-1,281,283,605,-1,300,769,606,-1,300,299,769,-1,600,318,317,-1,318,600,308,-1,303,602,614,-1,296,602,303,-1,759,304,312,-1,759,306,304,-1,615,763,769,-1,754,763,615,-1,314,285,287,-1,285,314,313,-1,619,769,763,-1,619,606,769,-1,770,310,766,-1,310,770,617,-1,771,329,276,-1,329,771,596,-1,329,347,330,-1,329,595,347,-1,330,346,597,-1,330,347,346,-1,326,341,323,-1,326,343,341,-1,342,341,343,-1,342,336,341,-1,336,595,337,-1,342,595,336,-1,772,773,429,-1,774,773,772,-1,775,776,777,-1,775,427,776,-1,429,360,772,-1,429,361,360,-1,778,563,779,-1,778,564,563,-1,375,381,576,-1,375,376,381,-1,370,407,403,-1,372,407,370,-1,780,579,781,-1,780,580,579,-1,584,566,583,-1,566,584,573,-1,368,585,369,-1,368,387,585,-1,371,581,577,-1,581,371,582,-1,385,567,782,-1,567,385,384,-1,371,580,372,-1,580,371,577,-1,583,386,581,-1,583,384,386,-1,378,781,579,-1,377,781,378,-1,589,383,590,-1,589,382,383,-1,405,783,571,-1,405,588,783,-1,406,574,404,-1,406,572,574,-1,568,784,569,-1,568,785,784,-1,409,568,415,-1,409,393,568,-1,570,590,782,-1,570,591,590,-1,591,571,783,-1,570,571,591,-1,782,416,570,-1,416,782,567,-1,395,781,394,-1,781,395,780,-1,417,435,418,-1,417,433,435,-1,775,442,441,-1,775,594,442,-1,359,560,357,-1,560,359,443,-1,563,786,773,-1,565,786,563,-1,417,561,444,-1,561,417,422,-1,787,788,789,-1,788,787,423,-1,562,787,565,-1,562,561,787,-1,790,791,792,-1,790,553,791,-1,559,793,794,-1,559,552,793,-1,557,483,558,-1,557,481,483,-1,550,554,556,-1,554,550,795,-1,494,484,545,-1,484,494,497,-1,547,553,495,-1,547,791,553,-1,456,796,454,-1,456,797,796,-1,791,546,462,-1,546,791,547,-1,798,552,551,-1,552,798,793,-1,488,556,799,-1,556,488,550,-1,800,551,801,-1,798,551,800,-1,802,803,804,-1,805,803,802,-1,804,796,797,-1,796,804,806,-1,803,543,542,-1,803,801,543,-1,540,544,539,-1,540,543,544,-1,482,497,548,-1,482,484,497,-1};
			return value;
		}
		private int[] getlcartend_Geo_6_20_coordIndex_5()
		{
			int[] value = {796,541,480,-1,796,806,541,-1,548,486,482,-1,548,544,486,-1,549,798,800,-1,549,799,798,-1,806,540,541,-1,542,540,806,-1,491,805,802,-1,490,805,491,-1,548,539,544,-1,493,539,548,-1,500,807,498,-1,500,808,807,-1,535,471,536,-1,535,521,471,-1,498,809,518,-1,498,531,809,-1,524,533,525,-1,524,810,533,-1,811,529,476,-1,811,506,529,-1,536,504,502,-1,536,471,504,-1,812,530,807,-1,812,532,530,-1,508,811,534,-1,508,506,811,-1,519,520,501,-1,519,513,520,-1,809,511,810,-1,511,809,512,-1,508,813,507,-1,508,533,813,-1,532,515,530,-1,515,532,520,-1,504,527,503,-1,527,504,528,-1,518,523,516,-1,524,523,518,-1,814,807,808,-1,807,814,812,-1,511,519,813,-1,511,513,519,-1,537,812,814,-1,537,536,812,-1,519,507,813,-1,519,509,507,-1,813,810,511,-1,813,533,810,-1,531,512,809,-1,531,514,512,-1,807,531,498,-1,807,530,531,-1,502,812,536,-1,812,502,532,-1,529,473,476,-1,473,529,528,-1,809,524,518,-1,524,809,810,-1,815,499,498,-1,499,815,538,-1,517,498,518,-1,517,815,498,-1,805,549,800,-1,805,490,549,-1,491,477,478,-1,491,802,477,-1,485,801,551,-1,543,801,485,-1,804,542,806,-1,804,803,542,-1,802,797,477,-1,802,804,797,-1,800,803,805,-1,800,801,803,-1,478,489,491,-1,489,478,487,-1,799,489,488,-1,549,489,799,-1,793,799,556,-1,793,798,799,-1,454,480,460,-1,454,796,480,-1,451,797,456,-1,451,477,797,-1,448,470,487,-1,470,448,446,-1,545,481,463,-1,481,545,484,-1,470,795,550,-1,795,470,469,-1,556,794,793,-1,794,556,555,-1,792,462,461,-1,792,791,462,-1,459,553,790,-1,459,458,553,-1,455,460,457,-1,455,454,460,-1,453,451,456,-1,452,451,453,-1,448,449,447,-1,448,450,449,-1,430,789,438,-1,789,430,786,-1,443,432,560,-1,440,432,443,-1,786,787,789,-1,787,786,565,-1,436,441,434,-1,436,426,441,-1,421,440,437,-1,440,421,420,-1,438,788,439,-1,438,789,788,-1,561,423,787,-1,561,422,423,-1,435,431,418,-1,435,434,431,-1,773,430,429,-1,773,786,430,-1,361,443,359,-1,443,361,428,-1,357,442,594,-1,442,357,560,-1,441,427,775,-1,426,427,441,-1,419,422,417,-1,422,419,420,-1,439,423,421,-1,439,788,423,-1,407,395,397,-1,407,780,395,-1,389,573,572,-1,573,389,566,-1,785,816,784,-1,785,380,816,-1,394,377,392,-1,394,781,377,-1,400,408,409,-1,396,408,400,-1,364,405,404,-1,405,364,588,-1,785,377,380,-1,392,377,785,-1,568,392,785,-1,393,392,568,-1,362,404,574,-1,404,362,364,-1,579,373,378,-1,579,578,373,-1,782,383,385,-1,782,590,383,-1,380,575,816,-1,575,380,379,-1,585,584,582,-1,585,366,584,-1,373,386,374,-1,373,578,386,-1,369,582,371,-1,582,369,585,-1,573,366,367,-1,573,584,366,-1,583,567,384,-1,583,566,567,-1,780,372,580,-1,780,407,372,-1,425,778,817,-1,778,425,564,-1,563,774,779,-1,563,773,774,-1,775,592,594,-1,592,775,777,-1,427,817,776,-1,427,425,817,-1,594,358,357,-1,358,594,593,-1,349,355,350,-1,349,352,355,-1,346,327,597,-1,346,344,327,-1,337,329,596,-1,337,595,329,-1,771,333,596,-1,771,335,333,-1,332,599,340,-1,332,334,599,-1,311,611,610,-1,311,614,611,-1,321,315,316,-1,315,321,609,-1,603,768,601,-1,767,768,603,-1,297,303,305,-1,296,303,297,-1,287,605,314,-1,287,281,605,-1,621,606,619,-1,607,606,621,-1,295,604,320,-1,295,289,604,-1,299,615,769,-1,615,299,302,-1,311,766,310,-1,311,610,766,-1,307,318,308,-1,605,318,307,-1,298,617,770,-1,298,322,617,-1,312,765,759,-1,312,616,765,-1,285,612,291,-1,313,612,285,-1,309,766,321,-1,766,309,770,-1,301,770,309,-1,301,298,770,-1,761,765,764,-1,761,759,765,-1,756,763,754,-1,762,763,756,-1,757,306,760,-1,757,305,306,-1,293,758,294,-1,293,297,758,-1,319,280,755,-1,319,283,280,-1,271,264,269,-1,271,272,264,-1,275,269,264,-1,275,268,269,-1,259,271,622,-1,259,272,271,-1,258,263,260,-1,753,263,258,-1,267,255,625,-1,253,255,267,-1,240,247,236,-1,244,247,240,-1,631,244,240,-1,631,245,244,-1,751,235,234,-1,751,628,235,-1,233,752,818,-1,233,630,752,-1,234,818,750,-1,234,233,818,-1,225,751,749,-1,225,224,751,-1};
			return value;
		}
		private int[] getlcartend_Geo_6_20_coordIndex_6()
		{
			int[] value = {632,239,748,-1,632,238,239,-1,637,745,819,-1,637,744,745,-1,743,726,732,-1,743,724,726,-1,742,729,728,-1,742,221,729,-1,639,819,746,-1,639,637,819,-1,211,744,735,-1,211,734,744,-1,742,644,645,-1,742,743,644,-1,741,217,820,-1,741,214,217,-1,737,207,739,-1,737,209,207,-1,220,736,740,-1,220,219,736,-1,217,738,820,-1,217,643,738,-1,737,636,638,-1,736,636,737,-1,213,735,219,-1,213,211,735,-1,210,734,211,-1,732,734,210,-1,747,635,730,-1,635,747,725,-1,731,208,209,-1,208,731,634,-1,747,726,725,-1,747,733,726,-1,746,733,747,-1,733,819,745,-1,746,819,733,-1,156,158,651,-1,156,154,158,-1,205,654,821,-1,205,185,654,-1,200,182,172,-1,200,648,182,-1,203,190,157,-1,177,190,203,-1,653,652,143,-1,195,652,653,-1,192,650,197,-1,650,192,191,-1,656,193,194,-1,193,656,198,-1,141,144,146,-1,148,144,141,-1,181,163,180,-1,181,188,163,-1,178,185,202,-1,178,180,185,-1,821,646,205,-1,646,821,721,-1,723,660,661,-1,660,723,655,-1,165,166,654,-1,165,145,166,-1,146,142,141,-1,164,142,146,-1,104,113,112,-1,104,106,113,-1,822,104,718,-1,822,105,104,-1,717,111,719,-1,111,717,112,-1,110,822,720,-1,105,822,110,-1,78,94,93,-1,94,78,669,-1,672,90,89,-1,90,672,99,-1,95,84,92,-1,87,84,95,-1,85,670,716,-1,670,85,82,-1,71,679,74,-1,63,679,71,-1,710,73,72,-1,73,710,707,-1,70,708,714,-1,708,70,65,-1,681,66,68,-1,64,66,681,-1,679,62,680,-1,62,679,63,-1,715,710,712,-1,710,715,714,-1,72,709,711,-1,74,709,72,-1,63,708,65,-1,708,63,71,-1,41,61,58,-1,61,41,43,-1,35,49,36,-1,50,49,35,-1,46,36,49,-1,46,682,36,-1,706,46,47,-1,46,706,682,-1,43,47,61,-1,47,43,706,-1,43,37,706,-1,40,37,43,-1,701,10,24,-1,683,10,701,-1,695,702,705,-1,702,695,698,-1,29,22,30,-1,29,20,22,-1,699,703,697,-1,704,703,699,-1,33,23,693,-1,24,23,33,-1,32,24,33,-1,32,701,24,-1,15,7,685,-1,15,17,7,-1,687,5,19,-1,687,0,5,-1,697,1,699,-1,697,684,1,-1,690,698,695,-1,690,696,698,-1,692,7,17,-1,692,8,7,-1,700,11,28,-1,700,14,11,-1,140,152,151,-1,152,140,658,-1,635,727,222,-1,725,727,635,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlcartend_Coord_7_20_point_1()
		{
			double[] value = {2.67475,44.17127,2.53099,2.70386,44.08999,2.55927,2.72848,44.12483,2.51577,2.71974,44.15806,2.48754,2.66207,44.18481,2.48858,2.66474,44.18806,2.50406,2.70837,44.14517,2.46184,2.81472,43.73578,2.36285,2.80464,43.73622,2.34212,2.82305,43.87408,2.35792,2.82904,43.87685,2.40237,2.73641,43.97217,2.35374,2.7658,43.83871,2.34233,2.76407,43.83879,2.32463,2.74385,43.96999,2.36855,2.79927,43.77979,2.45312,2.84103,43.7101,2.33812,2.81929,43.71362,2.35388,2.83793,43.76845,2.43721,2.66221,44.2062,2.51475,2.67958,44.22652,2.48177,2.68798,44.22658,2.52155,2.65757,44.19765,2.48906,2.78854,43.98849,2.40217,2.80366,43.98615,2.43922,2.78483,43.77486,2.33917,2.76195,43.99242,2.31513,2.79825,43.86014,2.28711,2.70838,44.10411,2.3994,2.70431,44.19814,2.4061,2.67204,44.15393,2.43824,2.72645,44.12716,2.35622,2.7822,44.07859,2.50064,2.76802,44.09874,2.46637,3.3345,43.45606,2.39694,3.28205,43.4945,2.4071,3.2932,43.5047,2.44197,3.4007,43.29541,2.3177,3.39103,43.24819,2.2586,3.31058,43.42195,2.36401,3.43025,43.23258,2.26669,3.43476,43.21389,2.25108,3.4462,43.22206,2.20526,3.41387,43.23767,2.32955,3.30718,43.46766,2.53993,3.36945,43.31462,2.48814,3.29404,43.44931,2.51911,3.35397,43.30141,2.45525,3.21622,43.50133,2.4301,3.24647,43.50576,2.4917,3.23267,43.48575,2.43534,3.25095,43.53396,2.50478,3.27523,43.39637,2.36869,3.37209,43.18733,2.19805,3.27474,43.38523,2.32297,3.37078,43.18903,2.22854,3.43707,43.14258,2.19979,3.42022,43.17091,2.21558,3.42457,43.15805,2.25447,3.40994,43.20197,2.39662,3.44548,43.1392,2.27508,3.39394,43.20798,2.3932,3.79303,42.59926,2.00588,3.75491,42.67597,2.03103,3.85656,42.58231,2.02501,3.82725,42.69685,2.09314,3.90293,42.52148,2.01458,3.87355,42.47927,1.94603,3.85369,42.49277,1.97784,3.94663,42.52508,1.97545,3.85803,42.66365,2.12206,3.73328,42.74844,2.07065,3.65121,42.82641,2.09974,3.7109,42.79569,2.09951,3.65703,42.74619,2.05647,3.78025,42.52841,1.94599,3.81209,42.55619,1.89092,3.71645,42.63682,1.95502,4.31864,42.10001,1.41998,4.28505,42.14354,1.42585,4.30499,42.14225,1.43325,4.30848,42.09263,1.40237,4.4081,42.19637,1.54522,4.44735,42.09671,1.4587,4.42886,42.09713,1.45123,4.42805,42.20783,1.55733,4.42867,42.20066,1.4847,4.42954,42.13028,1.44654,4.34352,42.18693,1.41558,4.32139,42.21203,1.48587,4.36397,42.21083,1.44789,4.30941,42.17818,1.45504,4.40405,42.04626,1.41522,4.38715,42.04726,1.40853,4.38895,42.09896,1.40061,4.41495,42.09721,1.41897,4.39674,42.16669,1.42939,4.34747,42.16406,1.40646,4.41176,42.21811,1.49134,4.39417,42.2225,1.48293};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_2()
		{
			double[] value = {4.60796,41.76324,.88561,4.61416,41.74157,.90708,4.58891,41.72196,.86668,4.56296,41.75796,.86139,4.51192,41.84592,1.02399,4.54656,41.89048,1.09436,4.52564,41.86353,1.0013,4.56665,41.79309,.90427,4.59618,41.83479,1.02769,4.60663,41.87134,.99816,4.57475,41.88939,1.09201,4.56558,41.71493,.84935,4.51085,41.77022,.90805,4.52563,41.78997,.89079,.67727,45.32053,2.86478,.67878,45.32146,2.84897,.71306,45.27448,2.78838,.7148,45.25446,2.817,.61128,45.35803,2.82172,.60813,45.32688,2.7827,.59656,45.43949,2.63563,.67439,45.59471,2.64988,.6824,45.61337,2.62899,.61552,45.44805,2.65284,.65723,45.48748,2.84934,.64499,45.49258,2.87764,.71691,45.64093,2.7,.70513,45.61039,2.78593,.71381,45.64149,2.79965,.78111,45.6711,2.69264,.60567,45.34909,2.74161,.59741,45.45362,2.69256,.66314,45.31146,2.7181,.60139,45.46451,2.75136,.62215,45.56407,2.75714,.63057,45.5739,2.72004,.61748,45.55063,2.69048,.60536,45.47584,2.80999,.27126,44.3779,3.01757,.25518,44.40391,3.08189,.28024,44.48482,3.09483,.2837,44.60527,3.04073,.31416,44.61807,3.01947,.25895,44.54701,2.99601,.3128,44.60657,3.08847,.37583,44.65742,3.07682,.35541,44.63961,3.06622,.3172,44.62074,3.10283,.24882,44.5822,3.05395,.28676,44.54195,3.09395,.23771,44.54871,3.05179,.29109,44.53899,3.10825,.26945,44.52945,3.11758,.66752,45.15413,2.81534,.59297,45.11862,2.8246,.6588,45.12037,2.88484,.57649,45.09267,2.89613,.49874,44.97571,2.86519,.54051,45.07663,2.83638,.52551,45.03973,2.8069,.68498,45.16268,2.89449,.72068,45.21064,2.79709,.43261,44.68136,3.01636,.40745,44.67382,2.98119,.38966,44.65304,3.0289,.42611,44.67462,3.03573,.39416,44.68291,3.08674,.4185,44.58027,2.90337,.43808,44.58738,2.88389,.35596,44.48518,2.86628,.51638,44.84924,2.82495,.55217,44.84753,2.79849,.49905,44.74092,2.86998,.50211,44.87424,2.96923,.49515,44.98336,2.91789,.47741,44.89198,2.94198,.5499,45.01588,2.93023,.4843,44.87109,2.84471,.4507,44.73592,2.95785,.44453,44.72908,2.93146,.43567,44.70409,2.97357,.41947,44.70065,2.93816,.46091,44.72071,2.90543,.46481,44.78957,2.91692,.47067,44.80574,2.88347,.46035,44.71197,3.02502,.32959,44.61391,2.99489,.34502,44.60985,2.97027,.39442,44.67239,2.94476,.46652,44.81853,2.93997,.48045,44.87931,2.894,.24247,44.47222,2.96901,.29998,44.40695,2.94284,.22703,44.47285,3.0092,.26229,44.39389,3.01639,.31394,44.55352,2.93579,.38527,44.53444,2.89441,.35204,44.48899,2.88524,.22917,44.51514,3.04281,.44753,44.62152,2.8944};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_3()
		{
			double[] value = {.47893,44.64258,2.8838,.47425,44.63706,2.85137,.48468,44.76959,2.98912,.50152,44.9642,2.81347,.33696,44.58855,2.95271,.53139,44.88004,2.9903,2.43124,44.9705,2.64284,2.44099,44.87994,2.63659,2.41586,44.96653,2.63865,2.42005,44.88019,2.62469,2.34298,44.89857,2.51661,2.373,44.84149,2.52919,2.32854,44.88592,2.51456,2.35982,44.8204,2.52264,2.37876,45.10304,2.61452,2.37788,45.0984,2.59315,2.29115,45.16241,2.55272,2.28156,45.19095,2.56186,2.36118,44.80694,2.50505,2.39464,44.7576,2.53326,2.40464,44.74646,2.51943,2.38381,45.12893,2.53519,2.43228,45.0664,2.5614,2.23869,45.73427,2.51049,2.24349,45.9662,2.48602,2.24267,45.96709,2.4901,2.2407,45.7357,2.50494,2.21858,45.64729,2.4752,2.2185,45.64703,2.47489,2.22239,45.65228,2.47156,.78424,45.84082,2.63325,.78486,45.837,2.62907,.79969,45.83281,2.63701,2.05004,46.26517,2.29726,2.05885,46.27877,2.30702,2.0469,46.23815,2.318,2.2161,45.66201,2.46322,2.22386,45.757,2.4941,2.16965,45.8302,2.36261,2.22161,45.65728,2.45179,2.16587,45.83789,2.37466,2.16044,46.21094,2.28701,2.24554,46.10861,2.36073,2.29665,45.98503,2.33597,2.24839,45.91981,2.32785,2.22285,46.0385,2.30798,2.30957,45.83389,2.43244,2.30583,45.75818,2.40416,2.28992,45.99616,2.40459,.74019,45.79146,2.54618,.69346,45.89123,2.53396,.62981,45.94666,2.53903,.69315,45.93947,2.59999,.54317,46.24126,2.40818,.62947,46.46239,2.36595,.53727,46.24476,2.38633,.58079,46.35349,2.40026,.62343,46.28448,2.63746,.66559,46.47681,2.51104,.61902,46.26977,2.62205,.61954,46.37032,2.5399,.48691,46.27959,2.46039,.49941,46.31768,2.486,.63042,46.40049,2.4464,.49033,46.20534,2.53066,.50941,46.27747,2.5535,.52867,46.0095,2.54625,.58079,46.02853,2.47661,.51426,46.07654,2.50212,.51043,46.08019,2.56266,.544,46.01264,2.61975,.55393,46.09212,2.62213,.53575,46.21278,2.59582,.56114,45.98489,2.58924,.67114,45.97038,2.66109,.49388,46.19589,2.4672,.55092,47.23444,2.28448,.56212,47.23566,2.29079,.56117,47.23636,2.29069,.56117,47.23684,2.29051,2.11735,47.25941,2.11136,2.10071,47.39286,2.06627,2.1035,47.39208,2.07746,2.12034,47.26197,2.09866,2.08512,47.48895,2.04179,2.04016,47.6666,1.96919,2.04051,47.66558,1.9709,2.08214,47.48475,2.03657,1.98796,47.77637,1.90476,1.93718,47.86129,1.84657,1.93649,47.86238,1.84716,1.98854,47.77499,1.90469,1.90466,47.87593,1.8008,1.90673,47.85739,1.78858,1.90315,47.86183,1.78306,1.90852,47.87134,1.80324,1.88656,47.78363,1.81957,1.91888,47.78777,1.77739,2.11,47.23192,1.99804,2.06461,47.09087,2.10965};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_4()
		{
			double[] value = {2.05134,47.09105,2.09063,2.13857,47.24365,2.02969,2.08145,47.11742,2.12161,1.89575,47.70728,1.82514,1.90935,47.6304,1.83526,1.93033,47.71002,1.77986,1.94591,47.63799,1.79896,2.06991,47.38607,2.06409,2.08513,47.24532,2.10882,2.16221,47.45334,1.93277,1.95737,47.40155,1.95548,1.92614,47.62797,1.84915,1.94831,47.38825,1.94869,2.02241,47.66174,1.97105,2.05889,47.48499,2.03851,2.01276,47.65987,1.94933,2.05658,47.48426,2.02724,2.10023,47.15041,2.13713,2.08845,47.24717,2.116,2.1375,47.15859,2.1113,1.8876,47.84688,1.83061,2.17515,47.56719,1.87862,2.01226,47.18244,2.04914,.48384,47.55934,1.90712,.48274,47.56717,1.89329,.4478,47.21614,2.0104,.45865,47.23117,2.02446,.50367,47.11138,2.12494,.55383,47.03706,2.1307,.54343,47.26203,2.23319,.53749,47.12406,2.24817,.61101,47.06167,2.3059,.57487,47.72004,1.93537,.56227,47.68955,1.98897,.62647,47.81665,1.90044,.59753,47.77483,1.96473,.43392,47.47619,2.02916,.47496,47.49922,2.07725,.47256,47.60977,2.00669,.4518,47.60367,1.94163,.52287,47.67325,1.90909,.44119,47.49209,1.96848,.42296,47.30176,2.10287,.42743,47.27921,2.04757,.43569,47.17286,2.12622,.45822,47.62908,1.96548,.45182,47.16389,2.16324,.45176,47.18241,2.18739,.55612,48.90192,1.51254,.53598,48.8945,1.52002,.52089,48.91256,1.52529,.52821,48.9382,1.50408,.53508,48.89144,1.52317,.54991,48.86734,1.53769,.51018,48.89956,1.54142,.51964,48.9078,1.53023,1.76555,48.7519,1.543,1.71283,48.87412,1.46043,1.70992,48.87821,1.46631,1.77009,48.74862,1.53951,1.8049,48.63471,1.58879,1.80721,48.63398,1.58269,.60934,49.11381,1.31392,.611,49.11123,1.32653,.64207,49.18903,1.2213,.5607,48.90306,1.50679,.53463,48.87965,1.49672,.53793,48.88344,1.49328,.54016,48.87396,1.51683,.52502,48.86913,1.50416,.5303,48.86247,1.50757,.43042,48.88344,1.45441,.43745,48.8764,1.46004,.47642,48.88043,1.31444,.47714,48.8885,1.30972,.48097,48.93445,1.25741,.48297,48.93885,1.25552,.49022,48.85084,1.33461,.48944,48.86179,1.32792,.48218,48.91604,1.26411,.48075,48.90607,1.26832,.44856,48.95035,1.24457,.46756,48.94959,1.23475,.50244,48.96471,1.24734,.4244,48.88972,1.36767,.49855,48.90295,1.30503,.41684,48.88155,1.36885,.54005,48.87841,1.51225,.47618,49.05999,1.27563,.43913,49.00458,1.32996,.48546,49.07027,1.27738,.39845,48.70877,1.49128,.47434,48.66116,1.44351,.49024,48.60469,1.50345,.40194,48.76374,1.45023,.38969,48.7937,1.46975,.40671,48.70713,1.53016,.41817,48.77491,1.50921,.5309,48.52819,1.64653,.5132,48.66362,1.62636};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_5()
		{
			double[] value = {.50263,48.63288,1.56665,.51526,48.69557,1.56594,.55096,48.8613,1.54095,.53262,48.85614,1.51032,.62132,49.11294,1.24927,.62604,49.12846,1.2129,.48301,49.05328,1.30272,.43696,48.87064,1.46177,.40317,48.6904,1.52009,.49425,48.60029,1.54315,.50922,48.89591,1.54554,.50347,48.63907,1.68346,.53096,48.94429,1.49984,.59745,48.42395,1.64211,.55017,48.46493,1.71603,.56191,48.47772,1.61461,.45749,49.00054,1.30255,1.74406,48.81499,1.38886,1.76272,48.80087,1.41932,1.76933,48.78835,1.43042,1.79075,48.73709,1.45705,1.8126,48.69668,1.47109,1.75985,48.72096,1.41935,1.79508,48.65967,1.46242,1.64518,48.84771,1.34938,1.63545,48.85644,1.33518,1.64268,48.86903,1.35905,1.64411,48.88873,1.34629,1.79658,48.62929,1.57271,1.82111,48.55707,1.58553,1.79696,48.56529,1.57689,1.74103,48.86521,1.40423,1.77014,48.82084,1.4321,1.74548,48.82106,1.39376,1.73094,48.88006,1.38362,1.75137,48.82111,1.40519,1.71286,48.87194,1.36717,1.85644,48.6529,1.52331,1.8662,48.61586,1.52817,1.82328,48.67602,1.47764,1.79955,48.74962,1.48206,1.66037,48.88721,1.38807,1.67702,48.89894,1.40727,1.76233,48.74485,1.53291,1.69573,48.85398,1.34906,1.46537,50.24793,.41202,1.47259,50.24264,.41018,1.46173,50.23817,.39941,1.46994,50.23238,.40298,1.46183,50.18308,.38948,1.47132,50.18052,.3945,1.49137,50.0448,.4194,1.48331,50.04381,.41349,1.50095,49.93773,.45536,1.53019,49.83548,.51257,1.5242,49.83152,.51011,1.50878,49.93836,.46203,1.56674,49.74805,.56524,1.62688,49.65487,.63877,1.62141,49.65013,.63455,1.57228,49.75183,.56747,1.73245,49.54097,.76501,1.73344,49.5456,.76477,1.72594,49.56078,.78693,1.7258,49.55703,.78969,1.63837,49.77337,.77375,1.60955,49.88808,.72287,1.60681,49.89241,.72803,1.64144,49.77116,.76957,1.48067,50.22651,.44403,1.48661,50.21946,.43916,1.02372,49.68501,.6744,.96883,49.63394,.7075,.96042,49.61778,.75693,.97149,49.59807,.83868,.97372,49.59828,.83912,.96511,49.60486,.83621,1.49236,50.05429,.44309,1.47633,50.17827,.41163,1.61593,49.68084,.63332,1.56933,49.75738,.57557,1.69999,49.59503,.81515,1.66545,49.65825,.81321,1.6727,49.66108,.81716,1.68863,49.5996,.80851,1.60075,49.88365,.71833,1.63275,49.77096,.76592,1.48177,50.20426,.42104,1.49491,50.17341,.46417,1.51356,50.14497,.44538,1.52059,50.11444,.45882,1.50908,50.10951,.44253,1.6741,49.65082,.68378,1.68517,49.6677,.72144,1.70038,49.60036,.75308,1.66612,49.60457,.70606,1.63908,49.69763,.64733,1.68577,49.61761,.77787,1.27016,50.00486,.63637,1.24209,50.06163,.61951};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_6()
		{
			double[] value = {1.18697,50.07543,.57026,1.02576,49.91684,.61435,1.10177,49.83156,.5759,.94734,49.80688,.67921,1.02493,49.6858,.67883,.92904,49.76718,.80294,.99428,49.64442,.85668,.97228,49.80433,.80596,1.1166,49.67803,.86155,.92154,49.86769,.72342,.90134,49.74616,.78419,1.14809,49.99485,.7263,1.14713,50.02565,.69194,1.03638,50.01925,.66058,1.12637,50.04813,.64848,1.09505,50.03306,.61299,1.2883,50.06016,.74858,1.27451,50.09274,.70444,1.30612,49.98005,.70346,1.01032,49.96619,.67561,1.05333,49.99581,.59808,.97005,49.71385,.63399,1.21861,50.09075,.60888,1.2958,49.95576,.8009,1.30853,49.89235,.78481,1.28649,49.80037,.8201,1.256,49.85246,.83934,.90672,49.75375,.74815,.96304,49.62804,.76026,.96747,49.6156,.82628,1.21377,49.98849,.58536,1.26228,49.99673,.64221,1.1415,49.91082,.56989,1.27092,49.80793,.80614,1.13572,49.66889,.87267,1.03069,49.7767,.57492,1.09977,49.82887,.56293,1.05842,49.84074,.54583,1.25201,50.09243,.66515,1.66216,49.726,.6724,1.62981,49.83394,.61132,1.58448,49.77485,.58837,1.60778,49.87511,.58714,1.60162,49.87804,.68309,1.64099,49.76197,.73783,1.7031,49.57498,.79077,1.70862,49.56655,.76889,1.69202,49.57261,.7451,1.66136,49.69181,.77095,1.52347,50.11383,.48834,1.5044,50.17907,.47347,1.56735,49.97687,.64216,1.58319,49.98421,.65994,1.68406,49.58437,.69837,1.52511,50.13375,.53324,1.52557,50.13274,.53442,1.52738,50.12819,.52608,1.69806,49.59253,.81894,1.66879,49.6631,.8208,1.58089,49.99075,.66672,1.70871,48.86286,1.45851,1.73161,48.70067,1.39899,1.66181,48.66414,1.39395,1.72862,48.54564,1.48005,1.66216,48.65005,1.38945,1.7234,48.55259,1.48796,.40812,48.90856,1.40868,.42713,48.89459,1.36571,.52748,48.52316,1.52464,.48474,48.4787,1.50714,.57449,49.09388,1.20706,.60319,49.1213,1.19983,.4804,49.01167,1.35388,.44486,48.89891,1.44448,.586,49.03456,1.34171,.4598,48.91857,1.24969,.44655,48.94706,1.24623,.39156,48.88808,1.41585,.41684,48.87537,1.37096,.42424,48.86719,1.37532,.39692,48.87703,1.42112,.3932,48.89382,1.41372,.43193,48.88872,1.4512,.40525,48.90432,1.41111,.443,48.89442,1.44848,.52602,48.8743,1.50093,.67139,49.23146,1.14883,.67705,49.22949,1.15073,.65909,49.22371,1.14858,.46577,48.96077,1.22377,.50835,48.97461,1.24269,.56904,49.15668,1.14694,1.6723,48.93113,1.40109,1.67198,48.93096,1.40169,1.68005,48.9212,1.40371,.47414,47.29045,2.17669,.53688,47.56444,2.08433,.54225,47.08391,2.20354,.65862,46.98867,2.24323,.57626,47.78641,1.86048};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_7()
		{
			double[] value = {2.09721,47.15183,2.13041,1.89322,47.8308,1.83621,1.89766,47.78487,1.82559,1.91911,47.83471,1.85339,1.91376,47.84491,1.86041,2.07392,47.38508,2.0752,2.04895,47.07168,2.0942,2.00209,47.17636,2.03811,2.04275,47.7737,1.84343,2.12027,47.69646,1.84943,2.07929,47.67352,1.79395,2.01795,47.77731,1.77809,1.96936,47.75998,1.91358,1.96513,47.74909,1.89969,1.91202,47.70853,1.83284,2.08415,47.10925,2.12812,1.96363,47.31488,1.98085,1.97258,47.32889,1.99175,2.04039,47.18538,1.99049,2.0856,47.07525,2.05822,2.08416,47.07098,2.05913,2.04233,47.18709,1.99394,.65098,46.05317,2.67604,.72899,45.90577,2.6926,.65375,46.04903,2.69487,.57787,46.01911,2.46144,.58989,46.00103,2.46432,.63622,45.89002,2.50188,2.17273,46.13722,2.41297,2.22818,45.95909,2.48304,2.11749,46.07007,2.31422,2.11031,46.06223,2.33064,2.16409,45.82901,2.35729,2.16401,45.82961,2.35717,2.41734,44.96847,2.61767,2.44996,44.99558,2.57022,2.40974,44.77971,2.55854,2.45437,44.86407,2.53081,2.42271,44.81581,2.58852,2.45566,44.8969,2.55482,2.281,45.03522,2.49371,2.32602,44.87426,2.50098,2.28523,45.03363,2.51113,2.26019,45.16637,2.53483,2.30498,45.04518,2.51439,2.28223,45.1536,2.5435,.60008,45.02497,2.94879,.56405,44.98458,2.78135,.44665,44.67613,2.90858,.42588,44.62956,2.91574,.26909,44.51237,2.93775,.52171,45.05723,2.88584,.29899,44.53975,2.93647,.32889,44.56733,2.93509,.46275,44.72595,3.0554,.62287,44.98513,2.75598,.27324,44.49109,3.08003,.30783,44.38887,2.93282,.26384,44.4799,3.10372,.58765,45.06708,2.77783,.67625,45.10195,2.76631,.69064,45.13353,2.73885,.71829,45.25055,2.79107,.7105,45.24464,2.75908,.67424,45.293,2.69586,4.57457,41.88262,.99564,4.62421,41.73733,.89525,4.61304,41.83516,1.0229,4.59805,41.70992,.84674,4.35988,42.13551,1.39833,4.38302,42.21102,1.55245,4.3534,42.248,1.5572,4.35374,42.21775,1.53812,4.30308,42.23088,1.49621,4.4127,42.02985,1.40392,4.38164,42.02802,1.38821,4.28495,42.19065,1.45753,3.97351,42.49832,1.91619,3.93199,42.48414,1.87524,3.69795,42.63563,2.00429,3.787,42.54467,1.98123,3.82985,42.55768,1.99552,3.32654,43.45997,2.45381,2.83624,43.88035,2.4554,2.73208,44.0022,2.5601,2.79402,43.80378,2.46095,2.69037,44.20382,2.55224,2.67349,44.1783,2.53895,2.82922,43.78733,2.2852,2.78291,43.76561,2.32305,2.7831,43.8726,2.5195,2.83431,43.7068,2.3147,2.80968,43.71637,2.32718,2.75466,44.10568,2.43518,2.67749,44.14935,2.44755,2.78572,43.86592,2.52851,2.75906,43.93403,2.55327,2.73241,44.00253,2.57265,2.76051,43.9329,2.56236,2.70318,44.09159,2.56818};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_8()
		{
			double[] value = {2.71393,44.10123,2.40818,2.81355,43.97685,2.48924,2.77715,43.93912,2.5747,2.74492,44.01764,2.5846,2.72072,44.10369,2.58419,2.80458,43.86862,2.53206,3.37909,43.31773,2.39587,3.74873,42.80432,2.13509,3.7924,42.77094,2.13289,3.66615,42.76371,2.01281,3.70911,42.83827,2.16042,3.66277,42.86414,2.06132,3.73098,42.88233,2.13445,3.89388,42.67878,2.10049,3.785,42.79044,2.18345,3.8131,42.82143,2.16411,4.38938,42.23929,1.57366,4.49111,41.76871,.89034,4.48982,41.84772,1.01439,4.56697,41.70762,.83403,4.59136,41.8983,1.09788,.60541,45.02937,2.97744,.55151,44.8483,2.78077,.62103,44.98359,2.73338,2.43112,45.01173,2.5216,2.44707,45.00331,2.54123,2.43514,44.99248,2.5214,2.44058,45.03096,2.54049,2.43084,45.02619,2.52553,2.43209,45.03219,2.52906,2.45269,44.94629,2.56299,2.41975,44.89227,2.60431,2.4021,44.94795,2.50248,2.43917,44.97702,2.52232,2.4239,44.90566,2.51056,2.40353,44.7842,2.53964,2.41342,44.75701,2.57016,2.42494,44.79363,2.60759,2.25809,45.19444,2.52217,2.44018,44.78866,2.61417,2.42875,44.74412,2.57349,2.39303,45.12523,2.61615,2.36976,45.11358,2.51755,2.3825,45.0311,2.50227,2.44596,44.86326,2.51751,2.44601,44.9497,2.52345,2.44818,44.97679,2.53475,2.44762,44.98894,2.53765,2.21709,45.65366,2.44876,2.1847,46.15744,2.41968,2.05386,46.28759,2.30618,2.18632,46.15424,2.4144,2.11329,46.06772,2.30885,.67327,46.51281,2.40772,2.13005,47.12339,2.09889,2.13603,47.13866,2.12766,2.12718,47.09676,2.11302,1.92736,47.70953,1.77476,1.91583,47.78848,1.77195,1.99841,47.40903,1.89278,1.94401,47.6365,1.79512,1.99633,47.40837,1.88866,2.11524,47.07102,2.09077,2.11775,47.08708,2.08408,2.01237,47.33337,1.92193,2.01437,47.33406,1.92594,2.14166,47.54296,1.83166,1.99524,47.83494,1.81711,1.98853,47.83164,1.7965,2.06638,47.07677,2.11675,2.12717,47.43077,1.89649,.54062,47.57828,2.10001,1.82051,48.55459,1.58897,1.80743,48.53422,1.56767,1.80642,48.52899,1.57104,1.66034,48.91171,1.37378,1.63504,48.89603,1.3393,1.65356,48.92231,1.37124,1.6525,48.64739,1.3839,1.72472,48.53969,1.47995,.39791,48.87147,1.42409,.42561,48.86206,1.37862,.50277,48.91067,1.30123,.62756,49.21756,1.13004,.42712,48.66816,1.38841,.46606,48.68212,1.40886,1.79287,48.54283,1.5652,1.7821,48.59387,1.47816,1.8239,48.65588,1.48147,1.8572,48.59254,1.52603,1.68097,49.57861,.69613,1.71194,49.55403,.73068,1.71059,49.54878,.73049,1.54647,50.07882,.57165,1.54351,50.08643,.57736,1.50011,50.18597,.47872,1.52814,49.8413,.52063,1.50878,49.94323,.47895,1.53168,50.07246,.55599,1.51676,50.118,.51725};
			return value;
		}
		private double[] getlcartend_Coord_7_20_point_9()
		{
			double[] value = {1.54971,50.03198,.55706,1.57558,49.9534,.62043,1.52137,50.02192,.47113,1.58114,49.95249,.54189,1.53064,49.93522,.49672,1.54912,50.03237,.50065,1.54773,49.85399,.53414,1.21777,49.99303,.57482,1.15693,50.06191,.53319,1.2918,49.97356,.70128,1.29077,49.8942,.77388,1.00875,49.62175,.87709,1.14301,49.91128,.55802,1.13501,49.90952,.77009,1.09415,49.95375,.52211,1.26665,50.09331,.68996,.45889,48.9052,1.25534,1.62511,48.85946,1.32708,2.04223,46.26847,2.28946,2.44914,44.95277,2.52875,2.29114,45.22488,2.55504,.53357,44.88574,3.01207,4.53816,41.90391,1.10356};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlclavcle_Geo_6_25_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,5,7,6,-1,8,9,10,-1,8,11,9,-1,12,13,8,-1,12,14,13,-1,1,11,15,-1,1,16,11,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,23,24,21,-1,22,25,23,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,34,37,35,-1,38,39,40,-1,39,41,40,-1,38,42,39,-1,43,44,45,-1,44,46,45,-1,43,47,44,-1,48,49,50,-1,50,51,48,-1,48,52,49,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,57,60,58,-1,60,61,58,-1,1,15,62,-1,62,3,1,-1,63,64,65,-1,63,66,64,-1,67,68,69,-1,68,70,69,-1,71,72,73,-1,73,74,71,-1,73,75,74,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,80,83,81,-1,80,84,83,-1,85,86,87,-1,87,88,85,-1,87,89,88,-1,90,91,92,-1,92,93,90,-1,94,95,96,-1,95,97,96,-1,98,4,6,-1,98,99,4,-1,100,101,102,-1,103,104,105,-1,105,14,103,-1,105,13,14,-1,106,107,108,-1,108,109,106,-1,110,111,112,-1,110,113,111,-1,114,115,116,-1,116,117,114,-1,118,119,120,-1,120,121,118,-1,122,123,124,-1,122,125,123,-1,126,127,128,-1,126,129,127,-1,130,131,132,-1,130,133,131,-1,134,135,136,-1,137,138,139,-1,139,140,137,-1,141,142,143,-1,141,144,142,-1,145,146,147,-1,148,149,150,-1,151,152,153,-1,151,154,152,-1,155,156,157,-1,157,158,155,-1,159,160,161,-1,159,162,160,-1,163,164,114,-1,163,165,164,-1,166,167,168,-1,166,169,167,-1,154,170,171,-1,170,172,171,-1,173,159,137,-1,159,56,137,-1,174,175,176,-1,176,52,174,-1,156,177,178,-1,177,179,178,-1,180,181,182,-1,180,183,181,-1,184,185,186,-1,184,187,185,-1,188,189,190,-1,188,191,189,-1,192,193,194,-1,192,195,193,-1,196,197,198,-1,146,199,144,-1,146,90,199,-1,200,201,148,-1,200,202,201,-1,203,204,205,-1,206,207,208,-1,206,209,207,-1,210,211,212,-1,212,213,210,-1,214,215,216,-1,217,71,76,-1,0,218,219,-1,219,16,0,-1,16,1,0,-1,115,220,221,-1,115,222,220,-1,126,223,224,-1,225,226,227,-1,228,135,131,-1,131,229,228,-1,230,231,232,-1,233,234,235,-1,236,237,238,-1,236,239,237,-1,240,125,241,-1,242,100,124,-1,242,243,100,-1,244,245,120,-1,120,246,244,-1,247,248,249,-1,248,250,249,-1,251,252,253,-1,252,254,253,-1,109,255,117,-1,117,256,109,-1,257,107,258,-1,258,259,257,-1,104,260,261,-1,260,262,261,-1,102,263,264,-1,102,265,263,-1,266,24,267,-1,268,269,85,-1,270,93,271,-1,271,84,270,-1,272,273,75,-1,272,274,273,-1,275,276,277,-1,278,72,279,-1,280,281,282,-1,283,284,285,-1,285,286,283,-1,287,288,289,-1,287,290,288,-1,291,292,44,-1,291,293,292,-1,67,294,295,-1,67,296,294,-1,297,298,299,-1,297,300,298,-1,301,57,302,-1,303,304,305,-1,303,58,304,-1,306,307,308,-1,309,29,310,-1,309,30,29,-1,311,312,313,-1,311,314,312,-1,42,37,315,-1,315,43,42,-1,316,39,45,-1,317,318,35,-1,35,38,317,-1,319,320,321,-1,322,28,323,-1,322,324,28,-1,25,325,326,-1,327,328,329,-1,330,331,332,-1,333,334,335,-1,335,336,333,-1,337,338,20,-1,337,339,338,-1,340,341,19,-1,340,342,341,-1,343,344,345,-1,345,346,343,-1,17,347,348,-1,17,349,347,-1,350,351,352,-1,351,353,352,-1,354,355,356,-1,354,357,355,-1,358,359,23,-1,360,361,362,-1,362,363,360,-1,364,32,365,-1,364,27,32,-1,366,367,368,-1,366,369,367,-1,370,40,371,-1,372,46,373,-1,33,374,50,-1,50,375,33,-1,376,377,22,-1,376,26,377,-1,378,379,380,-1,378,381,379,-1,382,383,384,-1,384,385,382,-1,386,387,388,-1,388,389,386,-1,390,391,69,-1,69,392,390,-1,393,394,395,-1,395,68,393,-1,396,397,398,-1,398,399,396,-1,400,401,402,-1,400,403,401,-1,404,405,406,-1,404,407,405,-1,408,409,410,-1,408,411,409,-1,412,73,413,-1,412,414,73,-1,415,416,417,-1,416,78,417,-1,418,419,77,-1,77,420,418,-1,421,422,82,-1,423,87,424,-1,423,425,87,-1,426,427,428,-1,80,429,430,-1,431,432,433,-1,433,434,431,-1,435,21,436,-1,53,437,97,-1,7,438,6,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_2()
		{
			int[] value = {7,439,438,-1,440,441,442,-1,440,443,441,-1,444,445,446,-1,444,447,445,-1,448,449,450,-1,448,451,449,-1,452,453,454,-1,452,455,453,-1,456,457,103,-1,458,459,460,-1,460,461,458,-1,462,463,464,-1,464,121,462,-1,122,128,465,-1,122,466,128,-1,130,123,467,-1,130,468,123,-1,469,470,471,-1,469,472,470,-1,473,474,475,-1,476,477,478,-1,479,136,480,-1,479,119,136,-1,481,482,483,-1,481,133,482,-1,484,485,127,-1,485,486,127,-1,129,487,488,-1,487,489,488,-1,490,491,492,-1,490,493,491,-1,494,495,101,-1,496,497,498,-1,496,499,497,-1,500,501,143,-1,143,502,500,-1,503,504,505,-1,503,506,504,-1,149,507,508,-1,149,509,507,-1,142,510,511,-1,512,49,513,-1,512,514,49,-1,515,516,517,-1,517,518,515,-1,48,64,519,-1,520,521,522,-1,522,523,520,-1,160,524,155,-1,155,525,160,-1,526,527,528,-1,527,66,528,-1,529,530,531,-1,530,162,531,-1,138,54,95,-1,532,63,533,-1,532,534,63,-1,530,177,524,-1,530,175,177,-1,535,525,536,-1,536,523,535,-1,178,170,537,-1,178,526,170,-1,504,200,538,-1,203,505,539,-1,539,540,203,-1,539,541,540,-1,542,543,501,-1,542,544,543,-1,531,173,545,-1,545,546,531,-1,480,228,477,-1,227,483,471,-1,471,236,227,-1,486,241,465,-1,486,472,241,-1,256,547,548,-1,256,549,547,-1,11,16,9,-1,550,490,551,-1,490,443,551,-1,552,553,432,-1,553,554,432,-1,555,268,556,-1,556,216,555,-1,556,206,216,-1,269,427,557,-1,558,436,266,-1,217,416,279,-1,559,281,560,-1,511,429,422,-1,202,294,383,-1,202,506,294,-1,561,562,563,-1,561,169,562,-1,564,167,565,-1,564,566,167,-1,182,567,568,-1,567,218,568,-1,306,569,570,-1,309,571,374,-1,309,572,571,-1,573,574,575,-1,576,577,312,-1,576,578,577,-1,316,372,579,-1,324,360,325,-1,325,377,324,-1,417,419,267,-1,267,328,417,-1,328,580,417,-1,267,359,328,-1,276,581,355,-1,400,582,412,-1,583,318,339,-1,339,368,583,-1,323,584,347,-1,323,364,584,-1,322,349,341,-1,341,361,322,-1,343,335,332,-1,335,350,332,-1,585,327,362,-1,362,345,585,-1,362,342,345,-1,168,184,186,-1,186,166,168,-1,547,113,548,-1,113,110,548,-1,111,566,112,-1,566,564,112,-1,167,169,565,-1,169,561,565,-1,343,331,344,-1,332,331,343,-1,346,342,340,-1,342,346,345,-1,362,341,342,-1,362,361,341,-1,340,18,586,-1,18,340,19,-1,587,347,584,-1,587,348,347,-1,368,337,366,-1,368,339,337,-1,18,338,588,-1,18,20,338,-1,336,589,333,-1,336,586,589,-1,350,334,351,-1,350,335,334,-1,353,320,352,-1,321,320,353,-1,331,357,354,-1,357,331,330,-1,355,590,356,-1,581,590,355,-1,327,580,328,-1,585,580,327,-1,329,362,327,-1,363,362,329,-1,326,23,25,-1,326,358,23,-1,326,360,363,-1,360,326,325,-1,377,28,324,-1,377,26,28,-1,29,32,27,-1,29,30,32,-1,591,364,365,-1,591,584,364,-1,321,413,319,-1,412,413,321,-1,592,591,593,-1,592,594,591,-1,595,369,596,-1,595,367,369,-1,597,598,599,-1,597,600,598,-1,36,318,583,-1,35,318,36,-1,40,601,371,-1,41,601,40,-1,39,579,41,-1,39,316,579,-1,42,45,39,-1,42,43,45,-1,373,44,292,-1,44,373,46,-1,602,37,34,-1,602,315,37,-1,311,603,314,-1,311,604,603,-1,312,597,576,-1,597,312,314,-1,378,313,381,-1,378,311,313,-1,576,605,578,-1,605,576,606,-1,607,575,574,-1,607,608,575,-1,573,609,574,-1,609,573,610,-1,611,193,195,-1,193,611,612,-1,50,571,51,-1,571,50,374,-1,376,29,26,-1,376,310,29,-1,376,308,307,-1,308,376,22,-1,308,569,306,-1,613,569,308,-1,53,614,437,-1,53,55,614,-1,615,616,617,-1,615,618,616,-1,619,620,621,-1,622,620,619,-1,623,624,625,-1,624,623,626,-1,182,624,180,-1,182,568,624,-1,627,305,625,-1,303,305,627,-1,628,57,59,-1,302,57,628,-1,305,629,630,-1,629,305,304,-1,631,632,622,-1,632,631,633,-1,634,571,572,-1,635,571,634,-1,65,533,63,-1,533,65,635,-1,60,563,61,-1,563,60,561,-1,636,565,637,-1,636,564,565,-1,638,301,302,-1,638,639,301,-1,640,380,379,-1,640,641,380,-1,642,640,643,-1,642,644,640,-1,645,389,641,-1,386,389,645,-1,646,647,648,-1,647,646,649,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_3()
		{
			int[] value = {647,650,651,-1,652,650,647,-1,385,653,382,-1,385,648,653,-1,383,296,384,-1,294,296,383,-1,654,390,655,-1,391,390,654,-1,387,656,388,-1,657,656,387,-1,300,658,298,-1,659,658,300,-1,660,44,47,-1,291,44,660,-1,661,398,662,-1,399,398,661,-1,69,663,392,-1,70,663,69,-1,67,393,68,-1,393,67,295,-1,395,284,283,-1,284,395,394,-1,409,664,665,-1,409,411,664,-1,397,288,290,-1,288,397,396,-1,405,292,293,-1,405,407,292,-1,402,582,400,-1,666,582,402,-1,667,668,669,-1,670,668,667,-1,404,280,282,-1,280,404,406,-1,287,671,672,-1,671,287,289,-1,408,673,674,-1,673,408,410,-1,286,675,676,-1,675,286,285,-1,677,422,421,-1,422,677,678,-1,679,680,681,-1,680,679,682,-1,560,423,424,-1,423,560,683,-1,282,559,670,-1,559,282,281,-1,668,684,666,-1,684,668,685,-1,582,414,412,-1,414,582,686,-1,413,72,278,-1,72,413,73,-1,590,416,415,-1,416,590,279,-1,416,76,78,-1,217,76,416,-1,79,71,74,-1,76,71,79,-1,687,688,689,-1,690,688,687,-1,420,433,418,-1,434,433,420,-1,82,429,80,-1,429,82,422,-1,691,83,692,-1,83,691,81,-1,87,693,89,-1,693,87,425,-1,557,85,269,-1,85,557,86,-1,274,428,427,-1,274,272,428,-1,510,429,511,-1,510,430,429,-1,199,93,270,-1,199,90,93,-1,83,271,694,-1,83,84,271,-1,693,695,696,-1,693,692,695,-1,88,697,698,-1,88,89,697,-1,206,699,209,-1,206,556,699,-1,269,555,700,-1,555,269,268,-1,701,702,690,-1,702,701,703,-1,688,431,434,-1,431,688,704,-1,433,554,558,-1,554,433,432,-1,97,705,96,-1,97,437,705,-1,436,24,266,-1,24,436,21,-1,181,567,182,-1,181,706,567,-1,707,7,708,-1,439,7,707,-1,709,439,710,-1,709,438,439,-1,443,711,551,-1,443,440,711,-1,492,443,490,-1,492,441,443,-1,102,440,442,-1,102,264,440,-1,450,265,448,-1,450,263,265,-1,12,712,713,-1,12,714,712,-1,715,103,14,-1,456,103,715,-1,716,447,717,-1,716,445,447,-1,446,718,444,-1,719,718,446,-1,720,494,721,-1,495,494,720,-1,722,451,723,-1,722,449,451,-1,724,725,726,-1,727,725,724,-1,104,728,105,-1,104,261,728,-1,104,457,260,-1,103,457,104,-1,262,259,261,-1,257,259,262,-1,454,729,452,-1,730,729,454,-1,250,731,727,-1,250,248,731,-1,725,732,730,-1,732,725,733,-1,729,107,257,-1,107,729,108,-1,259,734,735,-1,734,259,258,-1,736,112,737,-1,736,110,112,-1,109,548,106,-1,109,256,548,-1,117,163,114,-1,163,117,255,-1,221,116,115,-1,221,738,116,-1,739,547,549,-1,740,547,739,-1,741,111,113,-1,742,111,741,-1,743,167,566,-1,168,167,743,-1,252,222,254,-1,220,222,252,-1,251,744,745,-1,744,251,253,-1,247,460,248,-1,247,461,460,-1,746,250,747,-1,746,249,250,-1,246,748,244,-1,246,749,748,-1,245,121,120,-1,462,121,245,-1,463,242,464,-1,243,242,463,-1,494,100,243,-1,494,101,100,-1,242,123,468,-1,123,242,124,-1,127,465,128,-1,127,486,465,-1,750,237,745,-1,238,237,750,-1,750,474,473,-1,474,750,751,-1,240,123,125,-1,240,467,123,-1,240,472,469,-1,472,240,241,-1,471,239,236,-1,239,471,470,-1,239,752,237,-1,753,752,239,-1,233,474,234,-1,233,475,474,-1,754,235,234,-1,754,755,235,-1,756,476,757,-1,756,477,476,-1,755,758,757,-1,758,755,759,-1,232,480,230,-1,479,480,232,-1,228,136,135,-1,228,480,136,-1,131,481,229,-1,133,481,131,-1,485,760,753,-1,485,484,760,-1,488,127,129,-1,488,484,127,-1,489,492,491,-1,492,489,487,-1,115,164,222,-1,114,164,115,-1,761,762,763,-1,764,762,761,-1,765,766,767,-1,765,768,766,-1,769,770,771,-1,772,770,769,-1,773,184,774,-1,187,184,773,-1,775,776,777,-1,776,775,710,-1,553,778,779,-1,552,778,553,-1,139,95,94,-1,138,95,139,-1,778,213,212,-1,213,778,780,-1,781,496,498,-1,781,782,496,-1,781,207,783,-1,208,207,781,-1,213,784,210,-1,213,782,784,-1,785,211,786,-1,785,212,211,-1,545,137,140,-1,173,137,545,-1,500,542,501,-1,787,542,500,-1,511,143,142,-1,511,502,143,-1,145,788,789,-1,145,147,788,-1,542,541,544,-1,542,540,541,-1,790,791,792,-1,790,793,791,-1,200,150,538,-1,200,148,150,-1,794,203,540,-1,204,203,794,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_4()
		{
			int[] value = {202,504,506,-1,202,200,504,-1,507,790,508,-1,795,790,507,-1,796,789,793,-1,797,789,796,-1,90,145,91,-1,90,146,145,-1,798,799,800,-1,799,798,652,-1,801,642,802,-1,642,801,803,-1,804,197,196,-1,197,804,643,-1,198,805,196,-1,198,806,805,-1,805,807,808,-1,807,805,809,-1,810,811,812,-1,811,810,813,-1,512,193,514,-1,512,194,193,-1,49,176,513,-1,52,176,49,-1,814,531,546,-1,529,531,814,-1,815,816,817,-1,818,816,815,-1,819,816,820,-1,819,821,816,-1,822,518,808,-1,515,518,822,-1,190,823,824,-1,823,190,189,-1,174,48,519,-1,174,52,48,-1,185,825,186,-1,826,825,185,-1,827,828,829,-1,830,828,827,-1,831,181,183,-1,831,830,181,-1,828,832,826,-1,832,828,833,-1,152,825,153,-1,152,834,825,-1,178,157,156,-1,178,537,157,-1,536,520,523,-1,520,536,835,-1,522,535,523,-1,615,535,522,-1,160,535,161,-1,160,525,535,-1,177,155,524,-1,177,156,155,-1,178,527,526,-1,527,178,179,-1,528,170,526,-1,172,170,528,-1,531,159,173,-1,159,531,162,-1,172,836,171,-1,837,836,172,-1,563,838,839,-1,563,562,838,-1,836,840,839,-1,836,841,840,-1,586,346,340,-1,586,336,346,-1,344,354,842,-1,331,354,344,-1,366,348,587,-1,366,337,348,-1,317,588,338,-1,317,370,588,-1,333,371,601,-1,371,333,589,-1,277,352,320,-1,277,330,352,-1,277,357,330,-1,415,356,590,-1,415,843,356,-1,363,358,326,-1,358,363,329,-1,613,22,21,-1,613,308,22,-1,594,596,369,-1,592,596,594,-1,298,315,602,-1,298,658,315,-1,806,381,313,-1,806,198,381,-1,605,608,607,-1,608,605,606,-1,610,195,609,-1,611,195,610,-1,310,307,844,-1,376,307,310,-1,617,55,56,-1,617,616,55,-1,845,622,619,-1,845,631,622,-1,625,630,623,-1,625,305,630,-1,0,303,627,-1,0,2,303,-1,532,633,846,-1,532,632,633,-1,637,639,636,-1,301,639,637,-1,297,641,389,-1,641,297,380,-1,847,386,645,-1,847,848,386,-1,648,849,646,-1,648,385,849,-1,509,382,653,-1,509,201,382,-1,384,391,654,-1,296,391,384,-1,657,655,390,-1,657,387,655,-1,662,291,660,-1,662,398,291,-1,283,665,395,-1,283,409,665,-1,396,411,288,-1,411,396,664,-1,669,666,402,-1,669,668,666,-1,672,406,287,-1,672,280,406,-1,410,676,673,-1,286,676,410,-1,421,682,677,-1,421,680,682,-1,681,683,679,-1,681,423,683,-1,685,426,684,-1,850,426,685,-1,273,690,687,-1,273,701,690,-1,430,199,270,-1,510,199,430,-1,698,515,822,-1,515,698,697,-1,209,851,852,-1,851,209,699,-1,704,853,431,-1,499,853,704,-1,710,707,776,-1,710,439,707,-1,440,854,711,-1,440,264,854,-1,102,466,100,-1,102,223,466,-1,102,442,223,-1,713,263,450,-1,713,712,263,-1,714,8,10,-1,12,8,714,-1,719,244,748,-1,244,719,446,-1,723,717,447,-1,723,451,717,-1,721,243,463,-1,494,243,721,-1,747,727,724,-1,747,250,727,-1,257,452,729,-1,452,257,262,-1,733,255,732,-1,163,255,733,-1,763,738,221,-1,763,762,738,-1,774,168,743,-1,774,184,168,-1,164,254,222,-1,164,459,254,-1,251,237,752,-1,251,745,237,-1,746,855,249,-1,746,231,855,-1,473,238,750,-1,473,225,238,-1,753,470,485,-1,753,239,470,-1,235,757,476,-1,755,757,235,-1,761,491,764,-1,491,761,489,-1,856,769,857,-1,856,772,769,-1,780,782,213,-1,496,782,780,-1,210,818,815,-1,818,210,784,-1,858,786,211,-1,858,859,786,-1,792,508,790,-1,860,508,792,-1,797,861,862,-1,861,797,796,-1,802,188,801,-1,802,517,188,-1,812,809,810,-1,812,807,809,-1,863,194,512,-1,863,864,194,-1,513,529,814,-1,176,529,513,-1,834,186,825,-1,834,166,186,-1,835,183,520,-1,835,831,183,-1,528,837,172,-1,534,837,528,-1,837,841,836,-1,841,837,846,-1,615,161,535,-1,615,617,161,-1,835,158,865,-1,158,835,536,-1,826,153,825,-1,826,832,153,-1,821,574,609,-1,607,821,819,-1,607,574,821,-1,851,808,807,-1,851,822,808,-1,818,820,816,-1,818,866,820,-1,863,546,859,-1,814,546,863,-1,643,802,642,-1,802,643,804,-1,861,652,798,-1,861,650,652,-1,793,795,796,-1,790,795,793,-1,539,150,860,-1,539,538,150,-1,788,141,543,-1,141,788,147,-1,552,780,778,-1,552,853,780,-1,867,868,857,-1,868,867,550,-1,772,774,770,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_5()
		{
			int[] value = {772,773,774,-1,764,766,762,-1,764,767,766,-1,753,869,752,-1,753,760,869,-1,759,754,870,-1,754,759,755,-1,751,745,744,-1,750,745,751,-1,740,113,547,-1,740,741,113,-1,737,564,636,-1,737,112,564,-1,727,733,725,-1,727,731,733,-1,871,723,872,-1,871,722,723,-1,719,726,718,-1,719,724,726,-1,717,721,716,-1,717,720,721,-1,12,715,14,-1,12,713,715,-1,4,9,5,-1,4,10,9,-1,551,98,873,-1,98,551,711,-1,708,706,707,-1,567,706,708,-1,558,96,705,-1,558,554,96,-1,690,704,688,-1,690,702,704,-1,696,89,693,-1,696,697,89,-1,86,850,874,-1,86,557,850,-1,681,81,691,-1,81,681,680,-1,74,689,79,-1,74,687,689,-1,279,581,278,-1,279,590,581,-1,666,686,582,-1,666,684,686,-1,682,674,673,-1,682,679,674,-1,875,669,876,-1,669,875,667,-1,663,665,664,-1,70,665,663,-1,657,662,656,-1,662,657,661,-1,849,655,848,-1,849,654,655,-1,648,651,653,-1,648,647,651,-1,641,644,645,-1,641,640,644,-1,635,51,571,-1,51,635,65,-1,572,570,634,-1,570,572,844,-1,568,625,624,-1,625,568,627,-1,621,618,619,-1,616,618,621,-1,611,31,612,-1,611,877,31,-1,608,596,575,-1,608,595,596,-1,583,600,36,-1,583,598,600,-1,584,594,587,-1,584,591,594,-1,588,586,18,-1,588,589,586,-1,585,843,580,-1,585,842,843,-1,878,41,579,-1,878,601,41,-1,34,604,602,-1,34,603,604,-1,576,599,606,-1,576,597,599,-1,593,573,592,-1,573,593,610,-1,55,613,614,-1,569,613,55,-1,626,845,879,-1,845,626,623,-1,3,59,2,-1,3,628,59,-1,630,633,631,-1,630,629,633,-1,622,880,620,-1,622,632,880,-1,561,637,565,-1,561,60,637,-1,649,847,881,-1,847,649,646,-1,659,47,658,-1,659,660,47,-1,678,676,675,-1,678,677,676,-1,672,683,560,-1,671,683,672,-1,685,670,559,-1,670,685,668,-1,694,692,83,-1,694,695,692,-1,556,698,699,-1,88,698,556,-1,700,703,701,-1,700,555,703,-1,854,714,99,-1,854,712,714,-1,8,15,11,-1,8,13,15,-1,105,882,62,-1,105,728,882,-1,108,730,732,-1,108,729,730,-1,639,735,734,-1,639,638,735,-1,110,106,548,-1,110,736,106,-1,738,549,116,-1,738,739,549,-1,566,742,743,-1,111,742,566,-1,749,747,748,-1,746,747,749,-1,757,855,756,-1,757,758,855,-1,132,118,883,-1,132,134,118,-1,884,763,885,-1,884,761,763,-1,769,768,765,-1,768,769,771,-1,710,856,709,-1,775,856,710,-1,94,779,139,-1,94,553,779,-1,782,783,784,-1,781,783,782,-1,786,140,785,-1,786,545,140,-1,792,544,541,-1,791,544,792,-1,540,787,794,-1,542,787,540,-1,91,789,797,-1,789,91,145,-1,800,803,801,-1,800,799,803,-1,806,809,805,-1,806,577,809,-1,813,578,605,-1,810,578,813,-1,817,858,815,-1,864,858,817,-1,886,812,811,-1,886,852,812,-1,92,824,823,-1,824,92,862,-1,829,776,827,-1,829,777,776,-1,830,833,828,-1,830,831,833,-1,537,887,157,-1,151,887,537,-1,838,834,152,-1,838,562,834,-1,61,839,840,-1,563,839,61,-1,171,839,838,-1,836,839,171,-1,887,833,865,-1,887,832,833,-1,826,829,828,-1,829,826,185,-1,519,179,174,-1,527,179,519,-1,817,821,192,-1,817,816,821,-1,820,813,819,-1,820,811,813,-1,196,518,804,-1,196,808,518,-1,196,805,808,-1,800,824,798,-1,800,190,824,-1,793,788,791,-1,793,789,788,-1,783,886,866,-1,207,886,783,-1,498,208,781,-1,214,208,498,-1,779,212,785,-1,778,212,779,-1,775,187,773,-1,775,777,187,-1,867,767,493,-1,867,765,767,-1,484,884,760,-1,484,488,884,-1,230,477,756,-1,477,230,480,-1,229,226,475,-1,229,481,226,-1,475,478,229,-1,475,233,478,-1,467,469,482,-1,240,469,467,-1,751,234,474,-1,754,234,751,-1,468,464,242,-1,468,883,464,-1,479,749,246,-1,479,232,749,-1,247,759,461,-1,247,758,759,-1,869,220,252,-1,869,885,220,-1,870,253,458,-1,870,744,253,-1,771,742,741,-1,771,770,742,-1,766,740,739,-1,766,768,740,-1,737,258,736,-1,737,734,258,-1,248,165,731,-1,248,460,165,-1,260,871,455,-1,457,871,260,-1,261,735,728,-1,261,259,735,-1,730,726,725,-1,730,454,726,-1,453,444,718,-1,444,453,872,-1,445,462,245,-1,716,462,445,-1,449,456,715,-1,449,722,456,-1,448,495,720,-1,495,448,265,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_6()
		{
			int[] value = {487,441,492,-1,487,224,441,-1,868,438,709,-1,868,873,438,-1,830,706,181,-1,830,827,706,-1,7,219,708,-1,7,5,219,-1,703,497,702,-1,215,497,703,-1,696,191,516,-1,191,696,695,-1,694,823,189,-1,823,694,271,-1,700,427,269,-1,700,274,427,-1,692,425,691,-1,692,693,425,-1,558,418,433,-1,266,418,558,-1,689,434,420,-1,688,434,689,-1,686,272,414,-1,428,272,686,-1,424,559,560,-1,424,874,559,-1,678,511,422,-1,678,502,511,-1,285,500,675,-1,787,500,285,-1,674,289,408,-1,674,671,289,-1,404,670,667,-1,404,282,670,-1,290,293,397,-1,290,405,293,-1,394,794,284,-1,204,794,394,-1,295,205,393,-1,503,205,295,-1,392,399,661,-1,392,663,399,-1,388,659,300,-1,656,659,388,-1,795,651,650,-1,795,507,651,-1,652,649,799,-1,652,647,649,-1,803,644,642,-1,803,881,644,-1,379,643,640,-1,197,643,379,-1,635,880,533,-1,880,635,634,-1,841,304,840,-1,841,629,304,-1,882,302,628,-1,882,638,302,-1,180,626,521,-1,180,624,626,-1,522,618,615,-1,522,879,618,-1,435,437,614,-1,435,705,437,-1,621,570,569,-1,621,620,570,-1,514,612,375,-1,514,193,612,-1,604,378,299,-1,311,378,604,-1,373,407,875,-1,292,407,373,-1,876,579,372,-1,876,401,579,-1,314,600,597,-1,314,603,600,-1,599,367,595,-1,599,598,367,-1,278,319,413,-1,319,278,275,-1,593,365,877,-1,593,591,365,-1,412,353,400,-1,412,321,353,-1,878,351,334,-1,878,403,351,-1,534,846,837,-1,534,532,846,-1,562,166,834,-1,169,166,562,-1,171,152,154,-1,838,152,171,-1,137,54,138,-1,54,137,56,-1,530,176,175,-1,530,529,176,-1,528,63,534,-1,63,528,66,-1,177,174,179,-1,175,174,177,-1,530,160,162,-1,530,524,160,-1,159,617,56,-1,159,161,617,-1,155,536,525,-1,155,158,536,-1,151,170,154,-1,170,151,537,-1,157,865,158,-1,865,157,887,-1,151,832,887,-1,151,153,832,-1,865,831,835,-1,865,833,831,-1,180,520,183,-1,521,520,180,-1,777,185,187,-1,777,829,185,-1,64,527,519,-1,66,527,64,-1,517,191,188,-1,191,517,516,-1,852,807,812,-1,851,807,852,-1,866,811,820,-1,886,811,866,-1,864,859,858,-1,864,863,859,-1,512,814,863,-1,814,512,513,-1,192,864,817,-1,864,192,194,-1,609,192,821,-1,609,195,192,-1,819,605,607,-1,819,813,605,-1,810,577,578,-1,810,809,577,-1,804,517,802,-1,518,517,804,-1,801,190,800,-1,188,190,801,-1,862,798,824,-1,862,861,798,-1,510,144,199,-1,510,142,144,-1,92,797,862,-1,92,91,797,-1,650,796,795,-1,650,861,796,-1,201,149,148,-1,509,149,201,-1,503,203,205,-1,503,505,203,-1,149,860,150,-1,149,508,860,-1,504,539,505,-1,504,538,539,-1,541,860,792,-1,539,860,541,-1,144,147,146,-1,144,141,147,-1,543,791,788,-1,544,791,543,-1,143,543,141,-1,543,143,501,-1,207,852,886,-1,852,207,209,-1,859,545,786,-1,859,546,545,-1,211,815,858,-1,815,211,210,-1,866,784,783,-1,866,818,784,-1,214,206,208,-1,206,214,216,-1,215,498,497,-1,215,214,498,-1,496,853,499,-1,496,780,853,-1,139,785,140,-1,785,139,779,-1,493,550,867,-1,493,490,550,-1,857,709,856,-1,857,868,709,-1,856,773,772,-1,856,775,773,-1,765,857,769,-1,867,857,765,-1,764,493,767,-1,491,493,764,-1,885,221,220,-1,885,763,221,-1,884,489,761,-1,884,488,489,-1,487,126,224,-1,487,129,126,-1,760,885,869,-1,884,885,760,-1,227,481,483,-1,481,227,226,-1,134,131,135,-1,134,132,131,-1,119,134,136,-1,118,134,119,-1,231,756,855,-1,231,230,756,-1,228,478,477,-1,228,229,478,-1,233,476,478,-1,476,233,235,-1,226,473,475,-1,226,225,473,-1,227,238,225,-1,227,236,238,-1,482,471,483,-1,482,469,471,-1,485,472,486,-1,485,470,472,-1,130,482,133,-1,482,130,467,-1,883,130,132,-1,883,468,130,-1,754,744,870,-1,754,751,744,-1,465,125,122,-1,241,125,465,-1,466,126,128,-1,223,126,466,-1,100,122,124,-1,466,122,100,-1,121,883,118,-1,883,121,464,-1,246,119,479,-1,119,246,120,-1,232,746,749,-1,232,231,746,-1,249,758,247,-1,855,758,249,-1,461,870,458,-1,759,870,461,-1,459,165,460,-1,164,165,459,-1,253,459,458,-1,459,253,254,-1,752,252,251,-1,752,869,252,-1,770,743,742,-1,770,774,743,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_7()
		{
			int[] value = {768,741,740,-1,768,771,741,-1,762,739,738,-1,762,766,739,-1,116,256,117,-1,116,549,256,-1,734,636,639,-1,737,636,734,-1,107,736,258,-1,106,736,107,-1,732,109,108,-1,255,109,732,-1,731,163,733,-1,165,163,731,-1,457,722,871,-1,457,456,722,-1,455,872,453,-1,871,872,455,-1,262,455,452,-1,455,262,260,-1,728,638,882,-1,735,638,728,-1,718,454,453,-1,454,718,726,-1,748,724,719,-1,748,747,724,-1,716,463,462,-1,463,716,721,-1,451,720,717,-1,451,448,720,-1,245,446,445,-1,245,244,446,-1,872,447,444,-1,872,723,447,-1,715,450,449,-1,450,715,713,-1,62,13,105,-1,62,15,13,-1,5,16,219,-1,16,5,9,-1,10,99,714,-1,10,4,99,-1,263,854,264,-1,712,854,263,-1,265,101,495,-1,101,265,102,-1,224,442,441,-1,224,223,442,-1,711,99,98,-1,854,99,711,-1,550,873,868,-1,550,551,873,-1,873,6,438,-1,873,98,6,-1,218,708,219,-1,218,567,708,-1,827,707,706,-1,827,776,707,-1,54,97,95,-1,54,53,97,-1,436,705,435,-1,436,558,705,-1,94,554,553,-1,94,96,554,-1,552,431,853,-1,552,432,431,-1,499,702,497,-1,499,704,702,-1,703,216,215,-1,216,703,555,-1,85,556,268,-1,85,88,556,-1,699,822,851,-1,822,699,698,-1,697,516,515,-1,516,697,696,-1,695,189,191,-1,189,695,694,-1,271,92,823,-1,92,271,93,-1,84,430,270,-1,84,80,430,-1,274,701,273,-1,700,701,274,-1,557,426,850,-1,427,426,557,-1,874,87,86,-1,874,424,87,-1,423,691,425,-1,423,681,691,-1,680,82,81,-1,680,421,82,-1,419,266,267,-1,266,419,418,-1,79,420,77,-1,420,79,689,-1,75,687,74,-1,75,273,687,-1,419,78,77,-1,419,417,78,-1,276,278,581,-1,276,275,278,-1,217,72,71,-1,217,279,72,-1,414,75,73,-1,272,75,414,-1,684,428,686,-1,426,428,684,-1,559,850,685,-1,874,850,559,-1,280,560,281,-1,280,672,560,-1,671,679,683,-1,671,674,679,-1,673,677,682,-1,673,676,677,-1,675,502,678,-1,500,502,675,-1,285,794,787,-1,794,285,284,-1,409,286,410,-1,283,286,409,-1,408,288,411,-1,408,289,288,-1,405,287,406,-1,290,287,405,-1,407,667,875,-1,407,404,667,-1,876,402,401,-1,876,669,402,-1,398,293,291,-1,293,398,397,-1,399,664,396,-1,399,663,664,-1,395,70,68,-1,665,70,395,-1,393,204,394,-1,205,204,393,-1,294,503,295,-1,506,503,294,-1,296,69,391,-1,296,67,69,-1,390,661,657,-1,390,392,661,-1,656,660,659,-1,656,662,660,-1,389,300,297,-1,300,389,388,-1,848,387,386,-1,387,848,655,-1,385,654,849,-1,654,385,384,-1,202,382,201,-1,202,383,382,-1,653,507,509,-1,507,653,651,-1,848,646,849,-1,848,847,646,-1,799,881,803,-1,799,649,881,-1,881,645,644,-1,881,847,645,-1,380,299,378,-1,297,299,380,-1,197,381,198,-1,197,379,381,-1,301,60,57,-1,301,637,60,-1,48,65,64,-1,48,51,65,-1,632,533,880,-1,532,533,632,-1,620,634,570,-1,620,880,634,-1,629,846,633,-1,841,846,629,-1,840,58,61,-1,840,304,58,-1,58,2,59,-1,58,303,2,-1,62,628,3,-1,62,882,628,-1,627,218,0,-1,218,627,568,-1,623,631,845,-1,630,631,623,-1,879,521,626,-1,522,521,879,-1,879,619,618,-1,879,845,619,-1,616,569,55,-1,616,621,569,-1,21,614,613,-1,21,435,614,-1,306,844,307,-1,570,844,306,-1,844,309,310,-1,844,572,309,-1,375,49,514,-1,49,375,50,-1,33,309,374,-1,30,309,33,-1,375,31,33,-1,375,612,31,-1,611,593,877,-1,611,610,593,-1,575,592,573,-1,592,575,596,-1,606,595,608,-1,595,606,599,-1,577,313,312,-1,577,806,313,-1,299,602,604,-1,299,298,602,-1,658,43,315,-1,658,47,43,-1,875,372,373,-1,875,876,372,-1,372,45,46,-1,372,316,45,-1,403,579,401,-1,403,878,579,-1,37,38,35,-1,37,42,38,-1,317,40,370,-1,317,38,40,-1,603,36,600,-1,603,34,36,-1,598,368,367,-1,598,583,368,-1,369,587,594,-1,369,366,587,-1,417,843,415,-1,417,580,843,-1,275,320,319,-1,275,277,320,-1,877,32,31,-1,877,365,32,-1,28,364,323,-1,27,364,28,-1,360,322,361,-1,324,322,360,-1,377,25,22,-1,377,325,25,-1,24,359,267,-1,24,23,359,-1,359,329,328,-1,359,358,329,-1,842,356,843,-1,842,354,356,-1};
			return value;
		}
		private int[] getlclavcle_Geo_6_25_coordIndex_8()
		{
			int[] value = {357,276,355,-1,277,276,357,-1,330,350,352,-1,330,332,350,-1,403,353,351,-1,403,400,353,-1,334,601,878,-1,601,334,333,-1,589,370,371,-1,370,589,588,-1,318,338,339,-1,318,317,338,-1,337,17,348,-1,337,20,17,-1,347,322,323,-1,322,347,349,-1,17,341,349,-1,17,19,341,-1,343,336,335,-1,336,343,346,-1,345,842,585,-1,842,345,344,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlclavcle_Coord_7_25_point_1()
		{
			double[] value = {2.39254,50.14701,.57195,2.16245,50.19552,.60143,2.37623,50.21642,.48704,2.14495,50.28312,.52678,1.85659,50.16209,.80755,2.02183,50.16092,.8036,1.85912,50.17985,.88564,2.02396,50.19112,.87907,1.83839,50.23119,.66522,1.99891,50.18468,.73277,1.84707,50.19565,.73618,1.99079,50.20823,.6592,1.69635,50.23679,.65879,1.8445,50.25755,.59003,1.70175,50.2754,.5872,1.9836,50.23789,.58568,2.16895,50.18026,.67767,4.57217,49.99896,-1.22532,4.64972,49.94493,-1.24583,4.59447,49.93369,-1.20114,4.63737,49.99667,-1.25663,4.35776,49.94041,-.61809,4.29176,49.96671,-.71896,4.35408,49.91654,-.69464,4.37984,49.92634,-.66866,4.3322,49.93739,-.71842,4.30893,50.02904,-.92537,4.34875,50.10377,-1.07195,4.36658,50.0505,-1.05637,4.27341,50.08429,-.95732,4.25694,50.14504,-.96819,4.32946,50.23663,-1.07716,4.33221,50.16466,-1.08288,4.23971,50.23776,-.98022,5.01039,50.07319,-1.3875,4.88294,50.03698,-1.3328,4.86554,50.08692,-1.3449,5.02897,50.01933,-1.35904,4.90592,49.99126,-1.3087,5.03971,49.93681,-1.30043,4.89824,49.95478,-1.29705,4.92779,49.92418,-1.27896,5.05186,49.97431,-1.33503,5.22954,49.94608,-1.35223,5.38247,49.88331,-1.30355,5.21765,49.90906,-1.31744,5.28312,49.88864,-1.29932,5.37294,49.92197,-1.37623,3.95503,50.41693,-.6308,4.16945,50.38855,-.79391,4.12635,50.34637,-.8461,3.9806,50.35147,-.6716,4.03948,50.39276,-.6187,4.15501,49.96409,-.16791,4.16709,49.98805,-.15328,4.07892,49.96884,-.18118,4.11603,50.05032,-.13234,2.26843,50.48499,.45625,2.56624,50.32193,.37522,2.33355,50.38583,.45581,2.29342,50.57317,.47619,2.53022,50.48988,.37569,1.96095,50.30945,.54844,3.59806,50.39553,-.25138,3.77256,50.43428,-.41115,3.79852,50.36467,-.45138,3.61438,50.46348,-.22526,6.02957,49.77475,-1.1999,6.02966,49.74476,-1.15183,5.96067,49.77532,-1.26346,5.95709,49.75182,-1.19042,4.7484,49.88147,-.89123,4.74693,49.86096,-.91212,4.81716,49.88302,-.94114,4.76793,49.89991,-.8707,4.84829,49.90002,-.89014,4.67321,49.89283,-.84392,4.62842,49.90707,-.80082,4.62543,49.87925,-.83132,4.69271,49.91148,-.82345,5.86929,49.88895,-.64628,5.793,49.87492,-.67675,5.86108,49.8611,-.66559,5.77403,49.94313,-.66709,5.86032,49.94144,-.64845,5.28112,49.94723,-.74835,5.31372,49.93075,-.78979,5.46167,49.9267,-.75912,5.30661,49.98668,-.75489,5.44253,49.98437,-.74501,5.97399,50.00889,-.67917,5.9864,50.03441,-.71957,5.93543,50.07252,-.72282,5.9247,50.02613,-.67341,4.52924,49.95503,-.44203,4.39579,49.95815,-.33589,4.50976,49.92611,-.47019,4.38363,49.93524,-.3507,1.71018,50.15651,.88198,1.70835,50.15345,.79905};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_2()
		{
			double[] value = {1.20748,50.1101,.63222,1.23851,50.11553,.63959,1.31394,50.11062,.68956,1.67789,50.30312,.54189,1.68687,50.36172,.53545,1.82151,50.33452,.5589,1.45456,50.76571,.65343,1.48076,50.68086,.57134,1.33737,50.72673,.5228,1.30892,50.79918,.62659,1.54703,50.86221,.77958,1.68157,50.86436,.84939,1.67993,50.85561,.76302,1.54293,50.85753,.8773,.98118,50.89419,.67699,.99424,50.8131,.79503,1.11352,50.83372,.83443,1.11368,50.89425,.72748,1.00646,50.32973,.36626,.98177,50.38398,.31792,1.01749,50.36864,.28851,1.05743,50.31107,.35571,1.14827,50.08589,.68619,1.08726,50.15594,.59782,1.1454,50.12363,.60919,1.10866,50.12139,.65802,1.18386,50.05427,.80935,1.12094,50.07968,.81229,1.15412,50.0604,.76781,1.16488,50.08178,.85954,.99675,50.25972,.52412,.94179,50.35339,.46782,.97408,50.3087,.45697,.96468,50.31426,.53192,.96784,50.34358,.40917,.93549,50.38926,.42074,.94318,50.3997,.36122,4.33253,50.0891,-.32902,4.38328,50.02802,-.35018,4.51658,50.02463,-.45635,4.49136,50.08706,-.47351,6.03129,49.90513,-.72358,5.99299,49.89585,-.67666,6.01916,49.86965,-.73547,6.00235,49.92994,-.67709,6.01986,49.97761,-.72378,6.00738,49.95269,-.68347,6.0363,49.9278,-.72995,6.11206,49.895,-1.10026,6.10731,49.93155,-1.07556,6.11763,49.89488,-1.05397,3.06283,50.62078,.44533,2.79228,50.70605,.49986,2.8306,50.65837,.56846,3.01605,50.65333,.38386,3.60707,50.38622,.19533,3.55729,50.44719,.14531,3.33575,50.49686,.33375,3.36972,50.42273,.36302,4.11186,50.16709,-.14092,3.87329,50.27559,.03135,3.89632,50.17442,.04901,4.08083,50.24729,-.17581,1.00786,50.87006,.51689,.89135,50.8672,.62074,.88857,50.8628,.46556,2.31167,50.77577,.71732,2.01897,50.85858,.73867,2.05783,50.76881,.81887,2.27864,50.80947,.61776,3.23782,50.59304,.22206,2.96215,50.66262,.28889,3.18536,50.57173,.1515,4.29362,50.15595,-.34901,3.88707,50.42343,-.37984,3.97266,50.3748,-.29347,4.1488,50.35768,-.5244,3.78391,50.41207,-.06393,3.50581,50.50988,.09496,3.69963,50.45608,-.14918,2.95595,50.14495,.59315,2.71411,50.31063,.73952,2.7251,50.17942,.68389,2.94097,50.294,.62764,2.09577,50.68599,.87846,2.38652,50.61419,.81854,2.34894,50.70687,.7875,2.13688,50.5937,.92829,5.66465,50.14201,-.84125,5.76975,50.10577,-.74407,5.78932,50.11866,-.8103,5.65246,50.1144,-.77195,4.48253,50.36601,-.94292,4.36648,50.37475,-.9943,4.43755,50.36311,-.89568,4.43901,50.36071,-1.06491,5.35468,50.19382,-1.12698,5.41935,50.1737,-1.36082,5.31708,50.18561,-1.34472,5.95755,49.9639,-.64237};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_3()
		{
			double[] value = {6.11388,49.86994,-1.10279,6.09312,49.89996,-1.15239,6.08801,49.8683,-1.15011,6.09699,49.80395,-1.02458,6.07834,49.76287,-1.03671,6.0758,49.79828,-1.08692,5.01013,49.99931,-.73722,4.89299,50.08833,-.7598,4.92198,50.03712,-.72065,5.00085,50.08421,-.77947,4.7112,50.10156,-.67335,4.65674,50.11169,-.63819,4.6976,50.04812,-.61215,4.74162,50.04285,-.63206,4.91502,49.99826,-.69192,4.90996,49.96367,-.67469,5.00321,49.96104,-.70852,4.70088,49.85285,-.86496,2.44323,50.14695,.68662,2.19159,50.16586,.74925,.94169,50.60175,.82173,1.03259,50.62054,.86401,.90442,50.77956,.73618,1.24005,50.06681,.75031,1.23944,50.07299,.85608,.92659,50.42791,.60847,.93712,50.43632,.5487,.98101,50.35896,.61427,.91251,50.44928,.39317,.92768,50.43687,.47286,.88482,50.52994,.30408,.83869,50.63904,.23917,.89869,50.52809,.23313,.90424,50.50206,.50667,.87643,50.54858,.53585,.86693,50.56432,.4732,.98192,50.34203,.66571,.89772,50.47199,.70898,.92762,50.41016,.65876,.99356,50.27346,.74092,1.04438,50.19595,.64401,1.09399,50.12639,.70099,1.10912,50.19684,.50611,1.161,50.18627,.53705,1.00106,50.41349,.22844,1.07628,50.35564,.28676,.96971,50.44244,.23344,.79555,50.80725,.31783,.82768,50.80998,.31779,.81185,50.73906,.24852,.84576,50.71683,.23271,.84362,50.63911,.71713,.8786,50.60122,.77042,.80453,50.79627,.64877,.84132,50.7822,.68701,1.14157,50.85579,.56648,1.27235,50.88366,.74913,1.50006,50.61765,.51661,1.60351,50.65211,.59364,1.62091,50.56757,.56841,1.54067,50.40432,.50309,1.64483,50.47192,.54954,1.52392,50.52435,.49318,1.43079,50.18478,.66922,1.43354,50.12712,.74632,1.29823,50.17713,.62155,4.53934,49.91907,-.72061,4.48888,49.87852,-.76667,5.11644,49.94631,-.74005,5.10984,49.94138,-.7761,5.90823,49.98097,-.63662,5.85346,50.04515,-.67771,4.92701,49.90874,-.90346,4.8744,49.92168,-.83397,4.97888,49.92553,-.83098,4.74075,49.83389,-.97643,4.68841,49.81805,-.96034,4.70962,49.82498,-1.02809,4.73662,49.83861,-.93648,4.69944,49.83251,-.88585,5.44864,49.86533,-1.02688,5.43096,49.87399,-.9336,5.39696,49.85815,-1.03823,6.00572,49.74099,-1.01085,6.04386,49.74657,-.99532,6.02651,49.77667,-.92587,5.98235,49.75869,-.93491,5.5457,49.84701,-1.06684,5.69373,49.81961,-1.09444,5.66538,49.82456,-1.03577,5.5722,49.82682,-1.12229,5.48298,49.85943,-1.31463,5.40201,49.8499,-1.23132,5.48116,49.84123,-1.2155,6.05683,49.83262,-1.18564,6.05363,49.8101,-1.16095,6.01749,49.83082,-1.24338,5.44436,50.05361,-1.48909,5.34351,50.02734,-1.46929,5.326,50.0877,-1.48633};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_4()
		{
			double[] value = {5.45711,50.0002,-1.48439,2.02418,50.56254,.5388,2.03201,50.5138,.53435,2.60785,50.16163,.42123,2.78325,50.26846,.29144,2.84613,50.13056,.35303,3.98937,49.97183,-.34213,4.14555,49.97113,-.58228,4.20143,49.95453,-.55593,4.15724,50.13401,-.83062,4.20057,50.03806,-.7771,5.17033,50.15963,-1.45095,4.99066,50.22062,-1.3867,5.17555,50.18751,-1.41204,4.98676,50.1761,-1.39814,5.21288,49.9984,-1.40988,5.06316,49.88313,-1.26588,4.79016,49.99935,-1.29978,4.7786,50.04592,-1.3027,4.77605,49.8459,-.9949,4.74489,49.83694,-1.0466,4.82951,49.86616,-1.03433,4.44995,50.00625,-1.1153,4.4275,50.06129,-1.1319,4.3923,50.00555,-1.0197,4.37466,49.9556,-.88852,4.41385,49.9032,-.84896,4.53772,49.82239,-.98252,4.50887,49.84582,-.86482,4.48165,49.85869,-.89716,4.69087,49.8049,-1.08115,4.65316,49.77113,-1.07254,4.68254,49.77978,-1.12931,4.73851,49.86398,-1.23869,4.74991,49.83161,-1.20208,4.70399,49.80558,-1.18675,4.68136,49.84646,-1.20937,4.62519,50.05706,-1.27144,4.70235,50.0037,-1.28094,4.69076,50.05046,-1.2839,4.61119,49.87848,-1.18587,4.53435,49.94139,-1.15609,4.5719,49.85202,-1.10636,4.6611,49.78599,-1.14149,4.63174,49.77715,-1.0847,4.59912,49.80074,-1.08464,4.63853,49.82656,-1.16404,4.48959,50.06187,-1.1969,4.56,50.05954,-1.24012,4.51206,50.00695,-1.18028,4.72648,49.79991,-1.14087,4.77242,49.82608,-1.15617,4.73482,49.82536,-1.09271,4.81953,49.85368,-1.08036,4.6415,49.77755,-1.01495,4.65798,49.80455,-.95583,4.62957,49.80168,-.92275,4.67927,49.81155,-1.02352,4.43591,49.88186,-.82506,4.46298,49.8695,-.79283,4.42353,49.94461,-.98401,4.48136,49.9449,-1.07948,4.51873,49.85576,-1.02986,4.46293,49.89163,-.94432,4.40961,50.11468,-1.14754,4.40299,50.16685,-1.14572,4.61216,50.10998,-1.27671,4.6597,50.15588,-1.29563,4.67774,50.10315,-1.28913,4.60191,50.16121,-1.27345,4.7824,49.96283,-1.28819,4.79129,49.91811,-1.27794,5.12915,49.86205,-1.24737,5.30266,49.85436,-1.22712,4.14013,50.22709,-.84261,4.24486,50.33472,-.96056,4.23569,49.9847,-.74551,4.33431,49.98529,-.88899,5.31692,50.136,-1.4758,5.42422,50.15203,-1.45317,5.43542,50.10166,-1.47838,5.32229,50.16412,-1.43674,6.05748,49.905,-1.20458,6.05239,49.87334,-1.2023,6.01296,49.87179,-1.2601,5.99894,49.92455,-1.25635,5.70858,49.98445,-1.46012,5.72245,49.92753,-1.46566,5.58403,49.9662,-1.47942,5.57145,50.01918,-1.48393,5.8496,49.84752,-1.39211,5.94829,49.83234,-1.30718,5.845,49.80701,-1.33799,6.05363,49.78025,-1.11293,6.05624,49.74467,-1.06268,6.01806,49.73949,-1.07825,5.7108,49.8148,-1.17774,5.58932,49.82344,-1.20552,5.59109,49.84023,-1.30473,5.72142,49.8103,-1.29847};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_5()
		{
			double[] value = {4.90263,49.86877,-1.08831,4.97454,49.85591,-1.1853,4.98516,49.85704,-1.0962,4.85565,49.84004,-1.16404,5.40064,49.84848,-1.10005,5.47897,49.83547,-1.14402,5.45234,49.85507,-1.08868,5.39984,49.84325,-1.15983,5.78433,49.79933,-1.00298,5.9271,49.75234,-1.03452,5.90369,49.76933,-.95861,5.81254,49.79367,-1.06179,4.86031,49.88074,-1.00492,4.80684,49.86046,-.96551,4.89592,49.89119,-.95443,4.60935,49.82695,-.85398,4.65317,49.83934,-.85232,4.56008,49.84944,-.82821,4.61353,49.91734,-.75157,4.56311,49.87671,-.79766,4.66693,49.9153,-.77163,5.88433,49.81636,-.7116,5.91958,49.83156,-.70204,5.60508,49.87618,-.78464,5.48345,49.89252,-.82189,5.57207,49.91635,-.73882,5.03679,49.8995,-.92026,5.03408,49.92385,-.84625,4.98223,49.90674,-.91873,5.92788,49.85908,-.68262,5.91728,49.92768,-.63428,4.7497,49.93448,-.64257,4.70869,49.92568,-.61847,4.65808,49.92967,-.69528,4.71148,49.92776,-.71532,4.4013,49.93348,-.56374,4.51765,49.93277,-.66974,4.33454,49.93659,-.40944,1.85893,50.23852,.96656,2.00147,50.28572,.96032,1.43684,50.10886,.83405,1.3167,50.0948,.88188,1.31763,50.08325,.77705,1.43359,50.13396,.9309,1.17982,50.37475,.30239,1.13858,50.33644,.30788,1.06306,50.39751,.24885,1.1805,50.3274,.34389,1.29197,50.23535,.55096,1.4226,50.28326,.53767,1.42492,50.23527,.59601,1.28874,50.27506,.46237,1.38379,50.56344,.43539,1.2691,50.45374,.35115,1.22282,50.60713,.35941,1.4007,50.44308,.43764,1.535,50.3139,.53148,1.53207,50.34425,.50334,.78529,50.87437,.54212,.82204,50.86005,.58079,.8193,50.85696,.42607,.78718,50.85354,.42531,1.11629,50.29885,.35495,1.13112,50.25031,.44906,1.07917,50.26212,.41976,1.1335,50.09262,.72928,1.21016,50.07534,.70992,1.02291,50.23252,.58649,1.05089,50.23151,.49709,1.02361,50.2255,.65934,1.03876,50.19247,.74729,1.02732,50.25856,.66683,1.07316,50.15651,.71458,.90272,50.46922,.59675,.88538,50.52474,.56669,.91319,50.47812,.53752,.87111,50.55329,.43665,.89328,50.5038,.39008,.90847,50.4913,.47012,.93412,50.45909,.26378,.92016,50.45869,.33349,.95059,50.39702,.5352,.99085,50.28639,.59335,.99452,50.31968,.60241,1.09333,50.1248,.85801,1.06594,50.1476,.8054,1.10035,50.11013,.77361,1.22029,50.10355,.90653,1.13715,50.12944,.9052,1.20955,50.17617,.95348,1.42404,50.18802,.99748,1.29653,50.2184,.99653,1.30749,50.14092,.95024,1.40158,50.26193,1.02088,1.19201,50.19087,.54459,1.22264,50.18609,.5734,4.80795,49.99595,-.63669,4.85581,49.9673,-.65292,4.86092,50.00194,-.67013,4.81339,49.96096,-.63272};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_6()
		{
			double[] value = {6.0286,49.82079,-.83621,6.04197,49.85091,-.82937,5.98487,49.83512,-.74916,6.08121,49.82141,-1.1094,6.1103,49.8455,-1.08674,6.10253,49.82673,-1.04696,6.08451,49.84367,-1.13402,6.08042,50.00574,-1.07545,6.09271,49.95248,-1.02958,6.08846,49.93617,-1.12759,5.94823,49.9295,-.64187,5.95875,49.86077,-.69026,4.35881,50.36529,-.80987,4.27971,50.34945,-.6987,4.28825,50.3751,-.908,5.4288,50.11434,-.82475,5.5327,50.12447,-.80302,5.54482,50.15346,-.87239,5.41162,50.17484,-.91616,3.80274,50.44717,-.39179,3.17677,50.26655,.51866,3.19235,50.11908,.48464,3.43877,50.09523,.37842,3.41881,50.24021,.38348,3.83466,50.34989,-.01334,3.63432,50.31666,.21676,3.45147,50.52764,.0388,3.64446,50.47761,-.20613,3.39858,50.50971,-.03231,4.21862,50.30144,-.45095,4.04131,50.32236,-.22097,4.26187,50.2368,-.38427,3.39192,50.31462,-.07833,3.60579,50.27727,-.24526,3.38188,50.43926,-.05823,3.65644,50.21381,.23424,3.39617,50.35215,.38417,3.28495,50.55917,.28396,6.11946,49.8698,-1.05649,6.11161,49.85119,-1.01676,6.09105,49.81133,-.97233,6.09617,49.85787,-.95669,6.06845,49.8304,-.90812,6.0542,49.88588,-.81733,6.07342,49.87746,-.89265,4.45227,50.15376,-.49356,4.40057,50.22869,-.54412,1.41339,50.84957,.86844,1.41686,50.86897,.77239,1.27137,50.83701,.86126,1.55245,50.23488,1.01962,1.56417,50.17213,.96357,4.72722,49.94817,-.58425,4.64663,49.95265,-.53031,4.62704,49.92434,-.55861,5.01097,49.94468,-.73563,5.14217,49.98542,-.74637,5.14271,49.9254,-.81735,4.57669,49.92766,-.6352,5.33151,49.87414,-.9269,5.50584,49.86816,-.89694,2.27422,50.74639,.53983,2.52323,50.7545,.49911,2.51128,50.67127,.42765,1.81897,50.83858,.73273,2.01381,50.81346,.65614,1.82006,50.86076,.81792,2.4801,50.20882,.77731,2.70805,50.105,.61076,4.00213,49.96907,-.26393,3.9156,50.02709,-.34158,3.99417,50.23033,-.66804,4.02939,50.11977,-.63457,4.52819,50.30582,-1.20972,4.57006,50.33919,-1.16008,4.58483,50.29808,-1.23972,4.84053,50.24245,-1.34617,5.01288,50.23778,-1.27177,4.85828,50.27041,-1.25343,4.95123,49.8703,-1.24446,4.54338,49.82579,-.87997,4.6842,49.8227,-.92046,4.92764,49.88289,-1.02045,4.76115,50.09623,-1.31485,4.4767,50.1168,-1.20351,4.57195,49.80295,-.99794,4.66648,49.88961,-1.23051,4.54712,50.11423,-1.24671,4.71471,49.95195,-1.27011,4.72358,49.90731,-1.2599,4.65572,49.82008,-.88744,4.47011,50.16874,-1.20166,4.53313,50.22997,-1.23327,4.46636,50.23337,-1.1915,4.53684,50.16569,-1.2435,4.64753,50.21711,-1.2855,4.58969,50.2227,-1.26338,4.83666,50.1977,-1.35754,4.74316,50.14865,-1.32129,4.73141,50.20373,-1.31888};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_7()
		{
			double[] value = {4.84834,50.14292,-1.36002,4.8209,49.88745,-1.25985,5.19433,50.05152,-1.43831,4.99325,50.12865,-1.40256,5.1767,50.11247,-1.45548,4.73298,50.29932,-1.2068,4.71569,50.27088,-1.29908,4.61716,50.32527,-1.18596,4.63166,50.28486,-1.26586,4.5149,50.34756,-1.13015,4.47307,50.31401,-1.17971,4.40696,50.31965,-1.12824,4.33474,50.33233,-1.0573,4.21542,49.94763,-.47676,4.25852,49.94237,-.42282,3.67757,50.07187,.22938,3.86896,49.99305,.01205,3.89976,50.05645,.05749,3.64664,50.00624,.18425,3.57372,50.01042,.08155,3.71948,50.04842,-.14754,3.7929,49.98982,-.0699,3.50105,50.06858,.00444,3.12898,50.04299,.33934,2.93909,50.06833,.52006,2.89565,50.06524,.43214,3.17231,50.04613,.42729,2.65758,50.08782,.49669,2.09669,50.4166,.52413,3.00319,50.24508,.20076,3.06711,50.1082,.26286,3.28422,50.09178,.14203,3.43158,50.19366,-.05068,3.21595,50.2184,.0874,3.84142,50.13746,-.41204,3.80697,50.24874,-.44524,1.85277,50.69263,.63175,2.04833,50.64776,.57105,1.88355,50.53838,.56741,1.87561,50.58632,.57653,5.54428,50.12742,-1.44162,5.55533,50.07696,-1.467,5.62895,50.14838,-1.26513,5.50713,50.16068,-1.3055,5.66598,50.11314,-1.40135,5.69269,50.04203,-1.44295,5.91135,49.99639,-1.30284,5.99229,50.03547,-1.19383,5.99435,49.97691,-1.23297,5.90942,50.05401,-1.26358,6.0203,50.06913,-1.02677,6.04497,50.02662,-1.12895,5.96809,50.07585,-1.09119,6.05289,49.95756,-1.18119,5.93944,49.88397,-1.32925,5.84051,49.89991,-1.41438,5.59057,49.91565,-1.45057,5.72887,49.87765,-1.43694,5.35622,49.97332,-1.43393,5.46979,49.94663,-1.44909,5.47338,49.89724,-1.38738,5.72441,49.83607,-1.3827,5.5942,49.86692,-1.38884,5.84184,49.78137,-1.26459,5.83117,49.78789,-1.14389,5.94566,49.74552,-1.11671,5.01019,49.8717,-1.02829,5.28409,49.85018,-1.10927,5.13363,49.86307,-1.02263,5.12032,49.85506,-1.10026,5.29749,49.8596,-1.03155,5.64346,49.83678,-.95893,5.52371,49.85791,-.99007,5.87818,49.78339,-.87839,5.75885,49.81201,-.92276,5.99686,49.79651,-.846,5.95265,49.77814,-.85506,5.91789,49.79562,-.76849,5.9531,49.81056,-.75895,5.74273,49.82766,-.82363,5.81641,49.83034,-.72262,5.71568,49.85703,-.75447,5.84338,49.80006,-.79187,5.62745,49.85039,-.85971,5.01781,49.88612,-.97149,5.14125,49.87841,-.96581,4.96323,49.89371,-.96996,4.79401,49.92125,-.81456,4.76138,49.93146,-.7365,4.73116,49.91993,-.79429,4.82426,49.93296,-.75674,5.68289,49.89754,-.70845,5.6636,49.96632,-.69906,5.55313,49.97385,-.72457,5.76698,50.04716,-.69645,5.64984,50.05486,-.72423,5.5391,50.06329,-.74992,5.43529,50.05236,-.77162,5.29927,50.05531,-.78155,5.13293,50.06921,-.78855};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_8()
		{
			double[] value = {5.00437,49.9402,-.77168,4.90001,49.93525,-.77458,4.84204,49.94456,-.68391,4.91787,49.94716,-.70168,4.79965,49.93823,-.66369,4.46028,49.92905,-.52929,2.46889,50.33533,.8407,2.20536,50.32318,.91909,2.22829,50.21377,.84825,1.8439,50.31935,1.01347,1.98633,50.37338,1.00054,1.56788,50.13532,.86911,1.56333,50.1914,.70588,1.56083,50.2405,.63787,1.69833,50.19783,.73017,1.55893,50.28055,.57593,1.16228,50.28798,.37746,1.20415,50.27814,.41462,1.1346,50.47257,.27728,1.01821,50.49212,.22491,1.20768,50.23474,.5008,1.17699,50.24059,.47299,1.42051,50.32183,.48212,1.28632,50.31821,.41005,.96062,50.61011,.22029,1.05154,50.7357,.32863,1.08885,50.62298,.28827,.92397,50.72022,.26045,1.77941,50.44606,.5652,1.35628,50.67047,.46535,1.19572,50.70953,.39395,.90542,50.81441,.34624,1.16897,50.79615,.46087,1.02548,50.8169,.39703,1.73301,50.62774,.59963,1.75041,50.53998,.58117,1.57686,50.74787,.67105,1.71045,50.7247,.66305,1.15189,50.6465,.91075,1.29363,50.67812,.93963,1.43518,50.70261,.95884,1.57239,50.72969,.94895,1.71057,50.74845,.93055,1.8595,50.75601,.88728,.80689,50.75095,.61203,.84605,50.59363,.67844,.84952,50.64321,.21013,.88371,50.61809,.19457,.94082,50.50403,.19927,.90966,50.53117,.20504,.87591,50.53055,.628,.85858,50.58606,.59807,.90882,50.45408,.76292,1.00456,50.25884,.80013,.84254,50.64018,.52975,.83305,50.65491,.46693,.86283,50.57727,.34586,.84075,50.62792,.39265,.80052,50.75406,.35088,.79283,50.78511,.42549,1.03198,50.23427,.84902,1.16037,50.28754,.95243,1.19277,50.48297,.95668,1.09092,50.44446,.91525,1.26269,50.32681,.99424,1.49992,50.41927,1.03811,1.33462,50.51914,.99343,1.36747,50.3726,1.01786,1.46707,50.56465,1.00692,1.64713,50.47659,1.03064,1.74894,50.63525,.98032,1.60404,50.59865,1.00658,1.792,50.51605,1.01304,1.93901,50.55174,.98517,1.89757,50.65096,.94617,1.9695,50.45472,1.00464,2.18505,50.42316,.95323,2.16844,50.50471,.94806,4.71881,49.99699,-.59237,4.63824,50.0017,-.53845,4.76282,49.99194,-.6123,4.84603,50.04645,-.69548,4.79312,50.04037,-.662,4.81704,50.09812,-.73466,4.76265,50.09899,-.70333,4.613,50.06344,-.55553,4.57213,50.12749,-.58162,6.05504,49.8006,-.91503,6.05044,49.93907,-.78346,6.03399,49.98913,-.7773,6.07308,49.98208,-.95047,6.06995,49.92987,-.85848,6.08747,49.92272,-.94804,6.05556,49.98908,-.86096,6.07245,49.76994,-.9844,6.06106,50.03467,-.99616,6.02167,50.05765,-.86832,6.00012,50.05718,-.78467,5.91585,50.09974,-.90411,5.87737,50.09316,-1.13595};
			return value;
		}
		private double[] getlclavcle_Coord_7_25_point_9()
		{
			double[] value = {5.82538,50.11406,-.94862,5.70078,50.13939,-.97953,5.57531,50.16015,-1.02823,5.75458,50.12319,-1.21623,5.44195,50.18503,-1.07217,5.2347,50.21444,-1.07998,5.19817,50.20607,-1.29671,5.0826,50.21948,-.93765,5.26529,50.18966,-.93483,5.05201,50.24786,-1.08284,4.89696,50.27843,-1.06494,4.81292,50.26509,-.92855,4.93695,50.24029,-.93418,4.77297,50.30533,-1.0593,4.3565,50.29533,-.61141,4.64923,50.18626,-.73777,4.61873,50.2985,-.87571,4.55574,50.30611,-.83956,4.71234,50.17911,-.77383,4.65686,50.33043,-1.03874,4.71683,50.27848,-.90666,4.55902,50.35125,-1.00758,5.28267,50.12669,-.84324,5.86417,50.09198,-.72716,5.88369,50.10428,-.79343,2.59407,50.68439,.66849,2.63134,50.59616,.70753,2.44856,50.4403,.86316,2.6627,50.51069,.73274,2.41777,50.52911,.84905,2.69321,50.42403,.75382,2.91988,50.40757,.64062,2.86129,50.57351,.59982,2.89269,50.48892,.62723,2.55552,50.73539,.60349,3.15487,50.38014,.51972,2.94302,50.57826,.23161,3.16604,50.49059,.09417,2.73861,50.71426,.40511,2.72714,50.62443,.33116,2.74738,50.43508,.28676,2.96346,50.39075,.18778,4.60466,49.77937,-.99791,4.59252,49.80372,-.90588,4.07193,50.02566,-.58159,3.34681,50.02665,.21891,3.17501,50.3622,.07399,5.81283,50.01574,-1.38596,5.8268,49.95662,-1.40868,5.92532,49.93685,-1.32557,5.14554,49.89948,-.89124,5.11618,50.14251,-.85038,4.97063,50.16105,-.84679,4.76826,49.95694,-.60832,1.56559,50.14351,.78549,.81684,50.68865,.28126,1.82263,50.41763,1.02426,1.67703,50.36857,1.03817,4.59483,50.19669,-.70258,4.52022,50.20201,-.63226,6.103,49.91588,-1.008,5.98111,50.0909,-.89878,5.94912,50.09587,-.78795,4.43622,50.30875,-.722,4.51046,50.30409,-.7926,3.12748,50.46116,.50597,4.76662,50.17817,-.80525,1.52973,50.31287,1.04119,1.69829,50.27339,1.02032,.94376,50.42119,.82055,.79092,50.80231,.54223,1.41741,50.35478,.45616,1.28584,50.36444,.36626,1.7103,50.20319,.96806,5.33562,49.89781,-.85249,5.28333,49.84589,-1.16901,5.10959,49.85261,-1.18947,4.40027,50.23846,-1.13996,4.83239,49.85505,-1.22313,3.41937,50.02355,.32114,3.64648,50.15796,-.21735,5.78627,50.08726,-1.3442,1.91253,50.44248,.55919,1.02823,50.27912,.42964,1.08827,50.23891,.90227,1.00001,50.42309,.87126,4.86281,50.16608,-.8271,3.09375,50.53585,.47707};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlccart_Geo_6_30_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,6,7,4,-1,8,9,10,-1,10,11,8,-1,12,13,14,-1,13,15,14,-1,16,17,18,-1,16,19,17,-1,20,21,22,-1,20,23,21,-1,20,24,18,-1,20,25,24,-1,21,26,27,-1,27,28,21,-1,23,29,26,-1,26,21,23,-1,30,31,15,-1,15,13,30,-1,32,33,19,-1,33,17,19,-1,34,35,36,-1,35,37,36,-1,4,38,39,-1,4,7,38,-1,17,29,23,-1,17,33,29,-1,24,40,16,-1,16,18,24,-1,18,23,20,-1,18,17,23,-1,41,42,12,-1,12,14,41,-1,43,2,44,-1,45,3,1,-1,45,32,3,-1,5,46,47,-1,46,48,47,-1,47,49,5,-1,49,6,5,-1,50,51,52,-1,50,53,51,-1,54,55,30,-1,55,56,30,-1,57,58,55,-1,55,54,57,-1,27,26,59,-1,26,60,59,-1,61,62,63,-1,63,64,61,-1,6,65,66,-1,6,49,65,-1,30,67,31,-1,30,56,67,-1,32,68,33,-1,32,45,68,-1,69,70,71,-1,39,70,69,-1,72,73,74,-1,75,73,72,-1,48,76,77,-1,48,46,76,-1,61,78,66,-1,78,61,79,-1,2,80,64,-1,80,2,43,-1,7,81,38,-1,7,78,81,-1,80,82,79,-1,82,80,83,-1,44,84,43,-1,84,44,10,-1,85,86,87,-1,85,88,86,-1,89,85,90,-1,85,89,91,-1,92,57,54,-1,93,57,92,-1,41,72,74,-1,72,41,14,-1,35,12,42,-1,12,35,34,-1,94,91,89,-1,91,94,22,-1,16,8,11,-1,16,40,8,-1,95,36,37,-1,36,95,87,-1,96,75,72,-1,96,77,75,-1,96,31,97,-1,15,31,96,-1,76,39,69,-1,39,76,4,-1,38,98,99,-1,81,98,38,-1,52,88,50,-1,88,52,86,-1,13,54,30,-1,92,54,13,-1,28,50,88,-1,28,27,50,-1,100,10,44,-1,100,11,10,-1,83,101,82,-1,83,102,101,-1,93,52,57,-1,86,52,93,-1,84,102,83,-1,84,103,102,-1,82,98,81,-1,82,101,98,-1,77,69,75,-1,77,76,69,-1,10,103,84,-1,10,9,103,-1,87,93,36,-1,87,86,93,-1,22,25,20,-1,22,94,25,-1,22,28,91,-1,22,21,28,-1,19,11,100,-1,11,19,16,-1,14,96,72,-1,14,15,96,-1,12,92,13,-1,34,92,12,-1,34,93,92,-1,34,36,93,-1,90,87,95,-1,87,90,85,-1,91,88,85,-1,91,28,88,-1,43,83,80,-1,83,43,84,-1,79,81,78,-1,81,79,82,-1,64,79,61,-1,79,64,80,-1,3,44,2,-1,44,3,100,-1,66,7,6,-1,7,66,78,-1,5,76,46,-1,76,5,4,-1,97,77,96,-1,97,48,77,-1,75,71,73,-1,69,71,75,-1,39,99,70,-1,38,99,39,-1,32,100,3,-1,19,100,32,-1,29,60,26,-1,29,104,60,-1,67,48,97,-1,67,47,48,-1,61,65,62,-1,66,65,61,-1,64,0,2,-1,64,63,0,-1,51,57,52,-1,51,58,57,-1,59,50,27,-1,59,53,50,-1,33,104,29,-1,33,68,104,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlccart_Coord_7_30_point_1()
		{
			double[] value = {1.09415,49.95375,.52211,1.15693,50.06191,.53319,1.09735,49.96588,.51358,1.15449,50.06967,.52303,1.17664,49.62935,.71856,.96713,49.61354,.75403,.97414,49.63194,.70638,1.16318,49.67305,.66143,1.46537,50.24793,.41202,1.46173,50.23817,.39941,1.33819,50.17287,.43582,1.35818,50.21213,.45505,1.47071,49.6126,.86638,1.23913,49.61877,.88658,1.47268,49.58174,.83312,1.21603,49.59546,.84776,1.39273,50.19699,.50305,1.30868,50.15129,.57609,1.40715,50.17914,.5339,1.28681,50.15238,.53858,1.42943,50.15059,.58034,1.35683,50.12521,.65151,1.44349,50.13513,.5937,1.33258,50.14011,.62075,1.50011,50.18597,.47872,1.52511,50.13375,.53324,1.27149,50.10367,.69159,1.27862,50.10274,.70217,1.36574,50.10679,.66981,1.25453,50.10315,.66376,1.01794,49.61434,.8835,.97372,49.59828,.83912,1.18634,50.08696,.56425,1.21969,50.10208,.6064,1.49833,49.67299,.85848,1.66879,49.6631,.8208,1.51503,49.80687,.8113,1.63837,49.77337,.77375,1.36586,49.71264,.61238,1.39978,49.64155,.67839,1.48067,50.22651,.44403,1.7258,49.55703,.78969,1.69806,49.59253,.81894,1.20893,50.04129,.4677,1.21565,50.08259,.47404,1.18697,50.07543,.57026,.96629,49.61288,.75508,.96042,49.61778,.75693,.96652,49.61252,.75567,.96883,49.63394,.7075,1.29398,50.06576,.75124,1.2958,49.95576,.8009,1.30026,49.95615,.80651,1.2883,50.06016,.74858,1.15049,49.65712,.8796,1.13572,49.66889,.87267,1.00875,49.62175,.87709,1.25817,49.85197,.84374,1.256,49.85246,.83934,1.27451,50.09274,.70444,1.26665,50.09331,.68996,1.03053,49.77566,.57352,1.03069,49.7767,.57492,1.05842,49.84074,.54583,1.05794,49.83984,.5419,.97005,49.71385,.63399,.9708,49.71258,.63049,.96511,49.60486,.83621,1.21861,50.09075,.60888,1.43826,49.6004,.72467,1.62141,49.65013,.63455,1.68097,49.57861,.69613,1.47651,49.56864,.81214,1.71059,49.54878,.73049,1.73245,49.54097,.76501,1.45914,49.57858,.75386,1.19521,49.61258,.74451,1.20615,49.601,.76312,1.14803,49.75972,.58548,1.18239,49.83628,.52881,1.19278,49.91828,.49333,1.33713,49.79749,.54558,1.34389,49.88787,.49125,1.33976,49.98311,.45167,1.33625,50.11474,.42532,1.48885,50.02389,.70376,1.40137,49.94499,.79115,1.50861,49.92052,.76509,1.38885,50.04858,.7343,1.54351,50.08643,.57736,1.58089,49.99075,.66672,1.45914,50.09932,.6278,1.32133,49.67331,.87813,1.3837,49.83469,.835,1.52557,50.13274,.53442,1.60681,49.89241,.72803,1.21758,49.58906,.83711,.97149,49.59807,.83868,1.5242,49.83152,.51011,1.56674,49.74805,.56524};
			return value;
		}
		private double[] getlccart_Coord_7_30_point_2()
		{
			double[] value = {1.25116,50.14738,.49222,1.50095,49.93773,.45536,1.48331,50.04381,.41349,1.46183,50.18308,.38948,1.25201,50.09243,.66515};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlccart2_Geo_6_35_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,5,6,3,-1,7,8,9,-1,9,10,7,-1,11,12,13,-1,13,14,11,-1,15,16,17,-1,18,19,7,-1,18,20,19,-1,21,22,4,-1,21,23,22,-1,24,25,26,-1,26,27,24,-1,1,28,29,-1,1,30,28,-1,7,19,31,-1,31,8,7,-1,1,0,30,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,38,39,36,-1,40,41,42,-1,40,43,41,-1,44,45,46,-1,47,48,49,-1,50,51,37,-1,50,52,51,-1,53,54,13,-1,13,55,53,-1,56,57,58,-1,58,59,56,-1,60,61,62,-1,60,63,61,-1,15,17,64,-1,64,65,15,-1,35,66,67,-1,35,32,66,-1,68,36,69,-1,69,14,68,-1,70,71,46,-1,37,51,72,-1,72,38,37,-1,54,68,14,-1,14,13,54,-1,10,45,6,-1,73,74,75,-1,75,76,73,-1,43,77,41,-1,46,45,78,-1,79,43,40,-1,79,49,43,-1,80,31,81,-1,80,8,31,-1,82,83,5,-1,84,85,11,-1,85,86,11,-1,29,25,24,-1,29,28,25,-1,87,88,21,-1,88,23,21,-1,62,17,16,-1,5,83,18,-1,7,10,6,-1,21,4,3,-1,67,60,89,-1,2,15,0,-1,2,16,15,-1,67,90,35,-1,89,90,67,-1,60,66,63,-1,67,66,60,-1,27,91,24,-1,91,27,73,-1,92,93,87,-1,74,93,92,-1,80,69,94,-1,80,84,69,-1,35,55,33,-1,55,35,90,-1,24,95,29,-1,95,24,91,-1,39,46,78,-1,39,38,46,-1,87,96,88,-1,93,96,87,-1,85,80,81,-1,80,85,84,-1,50,54,97,-1,54,50,68,-1,53,98,99,-1,100,98,53,-1,101,49,79,-1,101,47,49,-1,76,102,103,-1,102,76,58,-1,71,75,104,-1,59,75,71,-1,103,73,76,-1,103,91,73,-1,105,41,77,-1,41,105,98,-1,97,106,107,-1,99,106,97,-1,74,104,75,-1,74,92,104,-1,3,45,44,-1,3,6,45,-1,9,39,78,-1,9,94,39,-1,102,57,108,-1,58,57,102,-1,95,79,2,-1,79,95,101,-1,40,2,79,-1,2,40,16,-1,42,16,40,-1,42,89,16,-1,53,90,100,-1,90,53,55,-1,0,65,30,-1,0,15,65,-1,17,61,64,-1,17,62,61,-1,18,82,20,-1,18,83,82,-1,100,89,42,-1,100,90,89,-1,101,91,103,-1,101,95,91,-1,59,70,56,-1,59,71,70,-1,69,39,94,-1,69,36,39,-1,44,92,3,-1,104,92,44,-1,52,97,107,-1,97,52,50,-1,106,98,105,-1,98,106,99,-1,102,48,47,-1,102,108,48,-1,46,104,44,-1,46,71,104,-1,76,59,58,-1,76,75,59,-1,47,103,102,-1,103,47,101,-1,41,100,42,-1,41,98,100,-1,54,99,97,-1,53,99,54,-1,68,37,36,-1,68,50,37,-1,33,86,34,-1,12,86,33,-1,26,93,27,-1,26,96,93,-1,4,82,5,-1,4,22,82,-1,10,78,45,-1,9,78,10,-1,46,72,70,-1,72,46,38,-1,77,49,48,-1,43,49,77,-1,29,2,1,-1,2,29,95,-1,13,33,55,-1,13,12,33,-1,11,69,84,-1,69,11,14,-1,94,8,80,-1,9,8,94,-1,5,7,6,-1,5,18,7,-1,3,87,21,-1,3,92,87,-1,74,27,93,-1,73,27,74,-1,89,62,16,-1,89,60,62,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlccart2_Coord_7_35_point_1()
		{
			double[] value = {.51104,48.90251,1.54776,.5174,48.88482,1.55865,.67686,48.79861,1.5927,.62762,48.76046,1.37622,.46013,48.91891,1.24701,.44627,48.94824,1.24517,.62446,48.82095,1.34371,.46762,48.9478,1.23421,.47021,48.95791,1.2246,.65186,48.90102,1.30584,.63146,48.85004,1.32786,.67705,49.22949,1.15073,.67139,49.23146,1.14883,.76616,49.08257,1.28432,.76165,49.08558,1.26208,.51197,48.90515,1.54436,.68146,48.83524,1.56582,.52309,48.91158,1.53296,.4375,48.95283,1.24177,.46756,48.94959,1.23475,.44856,48.95035,1.24457,.45548,48.9044,1.25184,.4598,48.91857,1.24969,.45889,48.9052,1.25534,.55843,48.46049,1.72365,.55017,48.46493,1.71603,.59745,48.42395,1.64211,.60801,48.41396,1.64374,.50347,48.63907,1.68346,.50831,48.64006,1.69008,.50922,48.89591,1.54554,.46577,48.96077,1.22377,.611,49.11123,1.32653,.65219,49.19706,1.21999,.64207,49.18903,1.2213,.61786,49.1163,1.33129,.85044,48.98075,1.32365,1.32235,48.90242,1.37304,1.2934,48.85835,1.37281,.82682,48.93739,1.3315,.82069,48.77545,1.58567,1.31452,48.782,1.5702,.8422,48.83712,1.53422,1.30144,48.73956,1.5941,.78772,48.74987,1.40012,.78119,48.76382,1.39294,1.2589,48.68881,1.42258,1.31376,48.5959,1.65237,1.8049,48.63471,1.58879,1.30217,48.68393,1.62122,1.33777,48.92304,1.39044,1.63504,48.89603,1.3393,1.65356,48.92231,1.37124,.86833,48.97201,1.38645,.86735,48.99492,1.34259,.75589,49.04844,1.33982,1.72472,48.53969,1.47995,1.80642,48.52899,1.57104,1.35851,48.46409,1.63508,1.31131,48.49637,1.5457,.53034,48.9442,1.50683,.52089,48.91256,1.52529,.52371,48.91501,1.52944,.52821,48.9382,1.50408,.51964,48.9078,1.53023,.51018,48.89956,1.54142,.53096,48.94429,1.49984,.53239,48.94818,1.50426,.86888,48.99215,1.33814,.73619,49.06144,1.25495,1.6525,48.64739,1.3839,1.26578,48.6073,1.46192,1.62511,48.85946,1.32708,.71716,48.46524,1.63117,.67886,48.51265,1.54428,.85247,48.49927,1.54935,.8888,48.47139,1.62992,1.76555,48.7519,1.543,.78093,48.77759,1.38607,.8231,48.73479,1.61335,.57432,49.1595,1.14232,.56904,49.15668,1.14694,.44655,48.94706,1.24623,.4372,48.95172,1.24242,.62922,49.21597,1.12386,.62756,49.21756,1.13004,.65909,49.22371,1.14858,.42807,48.66594,1.38531,.42712,48.66816,1.38841,.70093,48.89317,1.51428,.73248,48.98025,1.42465,.71334,48.50437,1.68113,.64012,48.63387,1.45146,.48742,48.47488,1.50191,.69622,48.9979,1.27058,.69095,48.61663,1.67273,.48474,48.4787,1.50714,1.34576,48.92981,1.4077,1.32177,48.8746,1.49656,1.33734,48.92144,1.43114};
			return value;
		}
		private double[] getlccart2_Coord_7_35_point_2()
		{
			double[] value = {.8584,48.91597,1.46177,.8393,48.60341,1.67238,1.35362,48.50482,1.66232,.87398,48.50099,1.67599,.79515,48.6189,1.46797,1.70992,48.87821,1.46631,1.67198,48.93096,1.40169,1.6723,48.93113,1.40109,1.82051,48.55459,1.58897};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrrib_Geo_6_40_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,13,16,14,-1,17,18,19,-1,20,21,22,-1,23,24,2,-1,23,25,24,-1,26,27,2,-1,2,3,26,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,34,37,35,-1,38,39,40,-1,41,42,43,-1,43,44,41,-1,45,46,43,-1,47,36,48,-1,45,42,49,-1,50,51,52,-1,53,54,55,-1,56,47,48,-1,44,24,25,-1,26,3,57,-1,58,59,60,-1,61,62,63,-1,28,30,64,-1,64,65,28,-1,60,66,58,-1,60,67,66,-1,60,68,67,-1,69,70,71,-1,70,72,71,-1,73,74,23,-1,23,27,73,-1,4,75,76,-1,76,77,4,-1,78,79,80,-1,78,81,79,-1,53,12,82,-1,53,5,12,-1,46,45,83,-1,84,85,86,-1,87,88,89,-1,87,90,88,-1,91,92,93,-1,92,94,93,-1,95,96,97,-1,96,98,97,-1,99,100,101,-1,100,102,101,-1,103,104,105,-1,106,102,100,-1,106,107,102,-1,108,109,110,-1,109,111,110,-1,12,78,82,-1,12,81,78,-1,112,113,114,-1,115,116,117,-1,118,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,129,130,127,-1,16,131,132,-1,16,133,131,-1,72,134,71,-1,135,136,137,-1,135,138,136,-1,139,140,141,-1,139,142,140,-1,139,131,143,-1,143,144,139,-1,145,144,143,-1,145,146,144,-1,147,148,149,-1,147,150,148,-1,151,152,153,-1,151,154,152,-1,155,156,157,-1,155,158,156,-1,159,160,161,-1,160,162,161,-1,163,164,165,-1,165,166,163,-1,167,168,169,-1,168,170,169,-1,171,172,173,-1,172,174,173,-1,175,161,176,-1,175,159,161,-1,177,176,178,-1,179,178,180,-1,181,182,183,-1,184,112,185,-1,186,187,171,-1,186,188,187,-1,148,189,149,-1,169,170,190,-1,170,191,190,-1,149,189,192,-1,173,174,193,-1,174,194,193,-1,195,194,196,-1,163,197,167,-1,163,198,197,-1,167,199,168,-1,167,197,199,-1,200,201,202,-1,202,203,200,-1,61,204,205,-1,61,17,204,-1,99,206,124,-1,206,207,124,-1,179,208,209,-1,179,180,208,-1,210,211,147,-1,211,191,147,-1,212,213,214,-1,215,216,217,-1,218,219,220,-1,53,55,221,-1,222,223,224,-1,224,225,222,-1,226,227,228,-1,229,230,231,-1,231,232,229,-1,233,214,213,-1,233,234,214,-1,235,236,237,-1,236,238,237,-1,239,240,213,-1,240,233,213,-1,241,242,243,-1,220,219,244,-1,219,245,244,-1,233,246,247,-1,233,240,246,-1,248,249,243,-1,250,251,252,-1,250,253,251,-1,253,254,251,-1,255,256,257,-1,258,259,260,-1,260,261,258,-1,262,263,264,-1,263,265,264,-1,264,266,259,-1,267,268,263,-1,263,269,267,-1,270,253,271,-1,253,272,271,-1,273,266,274,-1,275,274,266,-1,276,45,49,-1,277,278,279,-1,269,280,281,-1,282,283,284,-1,282,285,283,-1,286,287,288,-1,288,289,286,-1,243,290,291,-1,292,293,294,-1,293,19,294,-1,244,295,242,-1,244,234,295,-1,296,297,298,-1,298,103,296,-1,299,300,301,-1,299,302,300,-1,303,304,305,-1,303,306,304,-1,239,307,308,-1,309,9,8,-1,310,311,312,-1,235,212,313,-1,212,232,313,-1,307,237,314,-1,291,241,243,-1,315,62,61,-1,316,154,151,-1,70,317,72,-1,156,318,157,-1,319,320,321,-1,322,20,22,-1,322,323,20,-1,214,245,311,-1,247,243,295,-1,324,325,326,-1,325,327,326,-1,260,266,328,-1,265,266,264,-1,266,273,329,-1,330,236,331,-1,236,332,331,-1,266,333,334,-1,335,215,217,-1,266,336,275,-1,324,326,337,-1,326,338,337,-1,259,266,260,-1,236,235,332,-1,235,313,332,-1,295,243,242,-1,339,50,340,-1,339,51,50,-1,145,341,342,-1,145,343,341,-1,344,345,346,-1,306,104,347,-1,306,303,104,-1,348,349,350,-1,243,246,248,-1,210,193,211,-1,210,351,193,-1,352,353,354,-1,352,355,353,-1,356,339,357,-1,356,51,339,-1,314,238,358,-1,314,237,238,-1,3,1,359,-1,234,233,247,-1,247,295,234,-1,360,361,362,-1,249,290,243,-1,363,364,365,-1,365,366,363,-1,367,368,369,-1,368,370,369,-1,371,372,373,-1,372,297,373,-1,328,266,334,-1,374,227,375,-1,227,376,375,-1,333,266,329,-1,265,336,266,-1,254,377,251,-1,377,335,251,-1,268,267,270,-1,270,271,268,-1,262,258,378,-1,258,379,378,-1,380,381,382,-1,263,268,265,-1};
			return value;
		}
		private int[] getlrrib_Geo_6_40_coordIndex_2()
		{
			int[] value = {268,336,265,-1,258,262,264,-1,264,259,258,-1,223,222,334,-1,281,383,384,-1,358,238,216,-1,216,215,358,-1,335,385,215,-1,335,386,385,-1,387,366,365,-1,387,388,366,-1,388,249,248,-1,248,389,388,-1,390,366,308,-1,390,391,366,-1,364,360,365,-1,360,362,365,-1,1,0,37,-1,37,312,1,-1,212,239,213,-1,212,307,239,-1,311,245,392,-1,245,219,392,-1,242,241,220,-1,220,244,242,-1,243,247,246,-1,237,307,235,-1,307,212,235,-1,214,244,245,-1,393,394,395,-1,394,309,395,-1,385,358,215,-1,396,329,382,-1,257,333,255,-1,397,398,399,-1,397,400,398,-1,401,210,149,-1,402,403,404,-1,404,405,402,-1,406,201,200,-1,195,191,211,-1,195,190,191,-1,170,147,191,-1,170,150,147,-1,147,149,210,-1,185,407,408,-1,185,112,407,-1,113,153,409,-1,153,152,409,-1,116,400,410,-1,116,398,400,-1,210,401,351,-1,198,166,318,-1,198,163,166,-1,178,176,180,-1,176,161,180,-1,411,178,179,-1,399,176,177,-1,399,412,176,-1,172,413,174,-1,413,414,174,-1,415,186,171,-1,171,173,415,-1,407,114,192,-1,192,189,407,-1,168,150,170,-1,168,416,150,-1,114,407,112,-1,127,132,128,-1,132,141,128,-1,145,342,146,-1,342,417,146,-1,418,417,342,-1,418,121,417,-1,419,420,421,-1,419,422,420,-1,52,72,50,-1,52,134,72,-1,423,424,425,-1,426,406,427,-1,426,424,406,-1,428,429,430,-1,431,70,69,-1,69,432,431,-1,433,68,60,-1,433,434,68,-1,435,436,373,-1,436,437,373,-1,109,108,26,-1,26,57,109,-1,244,214,234,-1,403,438,107,-1,107,106,403,-1,305,87,89,-1,86,85,439,-1,439,440,86,-1,296,103,105,-1,105,441,296,-1,303,305,442,-1,305,89,442,-1,107,438,117,-1,438,115,117,-1,443,394,339,-1,394,357,339,-1,37,34,444,-1,444,312,37,-1,33,445,76,-1,76,75,33,-1,51,446,52,-1,51,356,446,-1,447,448,449,-1,18,109,57,-1,61,450,315,-1,24,0,2,-1,309,451,395,-1,449,452,447,-1,43,42,45,-1,44,35,24,-1,83,45,276,-1,453,83,276,-1,276,39,453,-1,41,49,42,-1,41,449,49,-1,454,39,38,-1,33,32,455,-1,456,29,28,-1,27,23,2,-1,18,3,19,-1,18,57,3,-1,7,80,79,-1,457,16,13,-1,457,133,16,-1,458,81,459,-1,458,79,81,-1,293,17,19,-1,12,5,10,-1,143,131,133,-1,425,97,423,-1,97,425,91,-1,460,461,462,-1,461,460,98,-1,344,463,464,-1,344,346,463,-1,439,465,440,-1,439,436,465,-1,11,81,12,-1,459,81,11,-1,101,428,430,-1,102,428,101,-1,466,403,402,-1,466,438,403,-1,373,467,371,-1,467,373,437,-1,437,344,467,-1,437,345,344,-1,468,23,74,-1,468,25,23,-1,40,456,455,-1,456,40,448,-1,277,469,278,-1,56,469,277,-1,447,30,29,-1,447,452,30,-1,38,455,32,-1,38,40,455,-1,470,56,277,-1,470,47,56,-1,276,449,39,-1,449,276,49,-1,46,453,48,-1,453,46,83,-1,465,471,472,-1,473,471,465,-1,279,31,474,-1,279,278,31,-1,422,350,349,-1,422,419,350,-1,315,475,476,-1,450,475,315,-1,477,420,478,-1,421,420,477,-1,111,479,110,-1,480,479,111,-1,448,39,449,-1,448,40,39,-1,481,349,482,-1,481,422,349,-1,483,484,485,-1,484,483,486,-1,487,446,356,-1,487,482,446,-1,62,476,480,-1,62,315,476,-1,486,65,478,-1,28,65,486,-1,488,489,490,-1,488,491,489,-1,490,393,395,-1,393,490,492,-1,487,493,494,-1,493,487,495,-1,82,496,53,-1,496,82,497,-1,455,483,498,-1,455,456,483,-1,499,34,470,-1,444,34,499,-1,357,393,495,-1,357,394,393,-1,445,500,501,-1,500,445,498,-1,443,340,130,-1,443,339,340,-1,430,461,101,-1,461,430,462,-1,104,442,105,-1,104,303,442,-1,435,441,473,-1,435,296,441,-1,502,84,503,-1,84,502,504,-1,159,402,405,-1,402,159,175,-1,66,350,58,-1,66,348,350,-1,66,67,348,-1,361,359,505,-1,361,294,359,-1,506,499,507,-1,499,506,444,-1,475,419,421,-1,475,59,419,-1,479,478,65,-1,478,479,477,-1,11,488,459,-1,491,488,11,-1,508,509,510,-1,509,508,511,-1,203,512,513,-1,512,203,514,-1,200,427,406,-1,515,427,200,-1,429,516,517,-1,516,429,518,-1,158,519,520,-1,155,519,158,-1,521,124,321,-1,521,125,124,-1,522,523,524,-1,525,523,522,-1};
			return value;
		}
		private int[] getlrrib_Geo_6_40_coordIndex_3()
		{
			int[] value = {526,155,404,-1,519,155,526,-1,68,432,69,-1,434,432,68,-1,70,527,317,-1,431,527,70,-1,341,418,342,-1,528,418,341,-1,316,528,529,-1,418,528,316,-1,512,530,531,-1,512,510,530,-1,518,428,117,-1,429,428,518,-1,514,202,517,-1,514,203,202,-1,532,528,341,-1,531,528,532,-1,427,533,426,-1,533,427,534,-1,424,460,406,-1,424,423,460,-1,535,424,426,-1,424,535,425,-1,533,13,536,-1,533,457,13,-1,504,537,538,-1,504,502,537,-1,67,134,348,-1,134,67,71,-1,61,60,450,-1,61,433,60,-1,485,481,494,-1,484,481,485,-1,539,9,129,-1,540,9,539,-1,541,542,543,-1,541,544,542,-1,96,541,545,-1,95,541,96,-1,546,142,547,-1,543,142,546,-1,119,121,525,-1,121,119,417,-1,321,548,521,-1,320,548,321,-1,126,106,100,-1,126,526,106,-1,524,548,522,-1,548,524,549,-1,316,121,418,-1,121,316,122,-1,122,151,550,-1,151,122,316,-1,112,153,113,-1,112,184,153,-1,400,551,181,-1,551,400,397,-1,399,552,412,-1,399,398,552,-1,553,192,114,-1,553,554,192,-1,408,555,185,-1,416,555,408,-1,188,553,409,-1,186,553,188,-1,556,557,558,-1,556,559,557,-1,511,560,509,-1,511,183,560,-1,561,562,563,-1,562,561,564,-1,565,566,567,-1,566,565,568,-1,189,408,407,-1,189,148,408,-1,186,554,553,-1,186,415,554,-1,413,569,414,-1,413,551,569,-1,397,177,570,-1,397,399,177,-1,571,414,569,-1,571,572,414,-1,573,208,574,-1,209,208,573,-1,405,155,157,-1,155,405,404,-1,198,156,564,-1,198,318,156,-1,116,552,398,-1,115,552,116,-1,166,157,318,-1,166,160,157,-1,196,574,575,-1,196,573,574,-1,572,174,414,-1,194,174,572,-1,195,193,194,-1,211,193,195,-1,404,106,526,-1,403,106,404,-1,401,415,351,-1,415,401,554,-1,162,180,161,-1,180,162,208,-1,558,530,556,-1,558,529,530,-1,576,577,343,-1,577,576,534,-1,183,578,560,-1,182,578,183,-1,527,425,535,-1,527,579,425,-1,464,434,433,-1,434,464,463,-1,140,128,141,-1,580,128,140,-1,118,417,119,-1,118,146,417,-1,555,568,565,-1,555,199,568,-1,93,581,544,-1,93,94,581,-1,578,171,187,-1,171,578,172,-1,582,402,175,-1,582,466,402,-1,329,255,333,-1,329,396,255,-1,382,273,380,-1,329,273,382,-1,583,382,381,-1,382,583,396,-1,17,584,204,-1,584,17,293,-1,585,586,587,-1,585,588,586,-1,228,374,589,-1,228,227,374,-1,590,591,592,-1,593,591,590,-1,583,594,256,-1,583,595,594,-1,596,332,597,-1,331,332,596,-1,506,312,444,-1,506,310,312,-1,230,376,231,-1,375,376,230,-1,597,313,598,-1,597,332,313,-1,594,599,600,-1,599,594,596,-1,330,217,216,-1,217,330,601,-1,312,392,1,-1,392,312,311,-1,252,601,381,-1,252,217,601,-1,449,468,452,-1,468,449,41,-1,390,386,391,-1,386,390,385,-1,366,389,308,-1,366,388,389,-1,307,390,308,-1,390,307,314,-1,90,281,280,-1,90,370,281,-1,302,383,368,-1,302,602,383,-1,386,377,299,-1,386,335,377,-1,603,267,384,-1,270,267,603,-1,379,604,378,-1,379,327,604,-1,605,326,606,-1,605,338,326,-1,224,599,592,-1,224,600,599,-1,328,222,607,-1,222,328,334,-1,275,268,271,-1,268,275,336,-1,273,272,380,-1,272,273,274,-1,257,224,223,-1,257,600,224,-1,261,605,606,-1,605,261,607,-1,379,261,606,-1,258,261,379,-1,250,381,380,-1,252,381,250,-1,63,17,61,-1,63,18,17,-1,588,375,507,-1,588,374,375,-1,376,226,608,-1,227,226,376,-1,592,609,590,-1,609,592,599,-1,337,591,593,-1,591,337,338,-1,610,589,611,-1,228,589,610,-1,587,353,585,-1,587,354,353,-1,84,612,135,-1,84,86,612,-1,472,440,465,-1,472,613,440,-1,105,614,441,-1,105,615,614,-1,89,616,442,-1,89,617,616,-1,88,327,325,-1,88,604,327,-1,297,286,298,-1,372,286,297,-1,289,306,347,-1,289,285,306,-1,369,282,367,-1,282,369,304,-1,300,368,367,-1,368,300,302,-1,372,204,584,-1,372,371,204,-1,301,366,391,-1,301,363,366,-1,387,249,388,-1,387,290,249,-1,618,365,362,-1,618,387,365,-1,389,246,240,-1,389,248,246,-1,505,362,361,-1,505,218,362,-1,288,292,360,-1,292,288,287,-1,135,323,138,-1,135,612,323,-1,21,619,497,-1,21,20,619,-1,615,352,614,-1,352,615,355,-1,617,620,616,-1,620,617,621,-1};
			return value;
		}
		private int[] getlrrib_Geo_6_40_coordIndex_4()
		{
			int[] value = {505,1,392,-1,1,505,359,-1,205,371,467,-1,371,205,204,-1,283,360,364,-1,288,360,283,-1,87,304,369,-1,87,305,304,-1,373,296,435,-1,296,373,297,-1,346,538,463,-1,504,538,346,-1,510,556,530,-1,556,510,509,-1,515,534,427,-1,577,534,515,-1,16,127,14,-1,127,16,132,-1,133,576,143,-1,133,457,576,-1,560,187,559,-1,578,187,560,-1,206,101,461,-1,99,101,206,-1,579,91,425,-1,92,91,579,-1,622,539,580,-1,622,136,539,-1,118,546,547,-1,319,546,118,-1,563,549,524,-1,562,549,563,-1,544,622,542,-1,622,544,581,-1,612,20,323,-1,20,612,613,-1,355,616,620,-1,616,355,615,-1,337,621,324,-1,621,337,610,-1,78,497,82,-1,21,497,78,-1,495,356,357,-1,495,487,356,-1,456,486,483,-1,456,28,486,-1,453,56,48,-1,453,469,56,-1,310,214,311,-1,310,229,214,-1,377,603,602,-1,377,254,603,-1,217,251,335,-1,217,252,251,-1,378,280,269,-1,378,604,280,-1,586,470,54,-1,586,499,470,-1,492,489,501,-1,492,490,489,-1,482,348,446,-1,349,348,482,-1,80,322,22,-1,322,80,7,-1,496,352,354,-1,623,352,496,-1,620,353,355,-1,620,611,353,-1,324,617,325,-1,324,621,617,-1,623,614,352,-1,623,471,614,-1,581,136,622,-1,581,137,136,-1,207,546,319,-1,207,545,546,-1,562,520,549,-1,562,158,520,-1,199,561,568,-1,199,197,561,-1,120,319,118,-1,320,319,120,-1,542,580,140,-1,622,580,542,-1,537,92,579,-1,92,537,502,-1,406,462,201,-1,462,406,460,-1,117,410,518,-1,116,410,117,-1,557,409,152,-1,557,188,409,-1,50,317,15,-1,317,50,72,-1,317,535,536,-1,317,527,535,-1,513,577,515,-1,577,513,532,-1,85,504,346,-1,504,85,84,-1,301,284,363,-1,284,301,300,-1,293,287,584,-1,293,292,287,-1,26,73,27,-1,73,26,108,-1,618,218,220,-1,218,618,362,-1,621,611,620,-1,621,610,611,-1,214,232,212,-1,214,229,232,-1,613,619,20,-1,613,472,619,-1,474,33,75,-1,474,31,33,-1,138,322,540,-1,138,323,322,-1,363,283,364,-1,363,284,283,-1,369,90,87,-1,90,369,370,-1,104,298,347,-1,104,103,298,-1,240,308,389,-1,239,308,240,-1,220,291,618,-1,220,241,291,-1,291,387,618,-1,290,387,291,-1,391,299,301,-1,386,299,391,-1,584,286,372,-1,584,287,286,-1,288,285,289,-1,285,288,283,-1,367,284,300,-1,367,282,284,-1,384,602,603,-1,384,383,602,-1,306,282,304,-1,285,282,306,-1,347,286,289,-1,286,347,298,-1,325,89,88,-1,89,325,617,-1,615,442,616,-1,105,442,615,-1,471,441,614,-1,473,441,471,-1,86,613,612,-1,86,440,613,-1,354,53,496,-1,587,53,354,-1,611,585,353,-1,589,585,611,-1,593,610,337,-1,593,228,610,-1,590,608,226,-1,590,609,608,-1,588,499,586,-1,588,507,499,-1,498,485,500,-1,485,498,483,-1,64,108,110,-1,64,73,108,-1,380,253,250,-1,380,272,253,-1,269,262,378,-1,269,263,262,-1,225,607,222,-1,225,605,607,-1,381,595,583,-1,381,601,595,-1,274,271,272,-1,271,274,275,-1,260,607,261,-1,607,260,328,-1,331,601,330,-1,601,331,595,-1,338,225,591,-1,605,225,338,-1,606,327,379,-1,606,326,327,-1,253,603,254,-1,253,270,603,-1,299,602,302,-1,299,377,602,-1,370,383,281,-1,370,368,383,-1,314,385,390,-1,385,314,358,-1,25,41,44,-1,468,41,25,-1,236,216,238,-1,236,330,216,-1,256,600,257,-1,600,256,594,-1,599,597,609,-1,599,596,597,-1,608,231,376,-1,608,598,231,-1,507,230,506,-1,507,375,230,-1,506,229,310,-1,229,506,230,-1,609,598,608,-1,609,597,598,-1,596,595,331,-1,595,596,594,-1,598,232,231,-1,313,232,598,-1,592,225,224,-1,592,591,225,-1,593,226,228,-1,593,590,226,-1,588,589,374,-1,585,589,588,-1,587,54,53,-1,587,586,54,-1,6,53,221,-1,6,5,53,-1,392,218,505,-1,392,219,218,-1,223,333,257,-1,333,223,334,-1,256,396,583,-1,256,255,396,-1,571,179,209,-1,571,411,179,-1,199,416,168,-1,199,555,416,-1,94,137,581,-1,94,503,137,-1,545,206,96,-1,207,206,545,-1,567,523,123,-1,567,566,523,-1,146,547,144,-1,146,118,547,-1,580,129,128,-1,129,580,539,-1,205,433,61,-1,433,205,464,-1,431,579,527,-1,579,431,537,-1,516,511,508,-1,516,624,511,-1,15,536,13,-1,15,317,536,-1};
			return value;
		}
		private int[] getlrrib_Geo_6_40_coordIndex_5()
		{
			int[] value = {532,343,577,-1,341,343,532,-1,559,188,557,-1,187,188,559,-1,195,575,190,-1,196,575,195,-1,569,411,571,-1,569,570,411,-1,173,351,415,-1,173,193,351,-1,190,164,169,-1,164,190,575,-1,197,564,561,-1,197,198,564,-1,172,182,413,-1,172,578,182,-1,194,573,196,-1,194,572,573,-1,164,574,165,-1,164,575,574,-1,413,181,551,-1,181,413,182,-1,412,466,582,-1,466,412,552,-1,405,160,159,-1,157,160,405,-1,165,208,162,-1,208,165,574,-1,572,209,573,-1,571,209,572,-1,178,570,177,-1,411,570,178,-1,570,551,397,-1,551,570,569,-1,163,169,164,-1,163,167,169,-1,165,160,166,-1,160,165,162,-1,567,184,565,-1,567,550,184,-1,563,568,561,-1,563,566,568,-1,564,158,562,-1,158,564,156,-1,624,183,511,-1,624,181,183,-1,509,559,556,-1,509,560,559,-1,152,558,557,-1,154,558,152,-1,412,175,176,-1,412,582,175,-1,416,148,150,-1,416,408,148,-1,554,149,192,-1,554,401,149,-1,114,409,553,-1,409,114,113,-1,410,181,624,-1,181,410,400,-1,443,309,394,-1,9,309,443,-1,153,550,151,-1,184,550,153,-1,123,525,121,-1,525,123,523,-1,521,549,520,-1,548,549,521,-1,100,124,126,-1,100,99,124,-1,522,320,120,-1,548,320,522,-1,547,139,144,-1,142,139,547,-1,545,543,546,-1,541,543,545,-1,95,544,541,-1,95,93,544,-1,543,140,142,-1,543,542,140,-1,141,131,139,-1,131,141,132,-1,136,540,539,-1,138,540,136,-1,503,135,137,-1,84,135,503,-1,134,446,348,-1,134,52,446,-1,463,432,434,-1,538,432,463,-1,538,431,432,-1,538,537,431,-1,536,426,533,-1,426,536,535,-1,534,457,533,-1,457,534,576,-1,513,531,532,-1,512,531,513,-1,508,517,516,-1,517,508,514,-1,531,529,528,-1,531,530,529,-1,185,565,184,-1,555,565,185,-1,343,143,576,-1,343,145,143,-1,9,130,129,-1,9,443,130,-1,130,14,127,-1,14,130,340,-1,126,519,526,-1,125,519,126,-1,550,123,122,-1,550,567,123,-1,566,524,523,-1,566,563,524,-1,120,525,522,-1,119,525,120,-1,321,207,319,-1,321,124,207,-1,520,125,521,-1,520,519,125,-1,552,438,466,-1,438,552,115,-1,430,517,202,-1,517,430,429,-1,518,624,516,-1,624,518,410,-1,203,515,200,-1,513,515,203,-1,514,510,512,-1,510,514,508,-1,529,154,316,-1,529,558,154,-1,494,500,485,-1,494,493,500,-1,309,458,451,-1,309,8,458,-1,540,7,9,-1,540,322,7,-1,480,477,479,-1,480,476,477,-1,3,294,19,-1,294,3,359,-1,439,346,345,-1,439,85,346,-1,473,436,435,-1,473,465,436,-1,461,96,206,-1,461,98,96,-1,93,97,91,-1,93,95,97,-1,92,503,94,-1,92,502,503,-1,280,88,90,-1,604,88,280,-1,462,202,201,-1,202,462,430,-1,33,498,445,-1,498,33,455,-1,493,501,500,-1,492,501,493,-1,501,76,445,-1,501,489,76,-1,11,77,491,-1,10,77,11,-1,623,497,619,-1,623,496,497,-1,492,495,393,-1,492,493,495,-1,451,459,488,-1,459,451,458,-1,75,6,474,-1,4,6,75,-1,489,77,76,-1,491,77,489,-1,395,488,490,-1,451,488,395,-1,73,30,74,-1,73,64,30,-1,484,422,481,-1,484,420,422,-1,68,71,67,-1,68,69,71,-1,450,59,475,-1,450,60,59,-1,18,111,109,-1,18,63,111,-1,478,484,486,-1,420,484,478,-1,494,482,487,-1,494,481,482,-1,110,65,64,-1,479,65,110,-1,63,480,111,-1,62,480,63,-1,476,421,477,-1,475,421,476,-1,419,58,350,-1,419,59,58,-1,454,453,39,-1,469,453,454,-1,474,221,279,-1,221,474,6,-1,36,44,48,-1,36,35,44,-1,277,54,470,-1,277,55,54,-1,472,623,619,-1,471,623,472,-1,44,46,48,-1,44,43,46,-1,454,32,31,-1,38,32,454,-1,448,29,456,-1,447,29,448,-1,35,0,24,-1,37,0,35,-1,34,47,470,-1,34,36,47,-1,454,278,469,-1,454,31,278,-1,74,452,468,-1,452,74,30,-1,279,55,277,-1,221,55,279,-1,22,78,80,-1,21,78,22,-1,292,361,360,-1,294,361,292,-1,269,384,267,-1,269,281,384,-1,117,102,107,-1,117,428,102,-1,15,340,50,-1,15,14,340,-1,7,458,8,-1,7,79,458,-1,5,77,10,-1,4,77,5,-1,436,345,437,-1,345,436,439,-1,467,464,205,-1,467,344,464,-1,98,423,97,-1,98,460,423,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrrib_Coord_7_40_point_1()
		{
			double[] value = {1.15786,52.27756,-1.70273,1.13899,52.27259,-1.6883,1.17097,52.2853,-1.70129,1.2,52.2694,-1.67709,1.39042,52.06739,-1.90387,1.37932,52.05934,-1.86829,1.35592,52.09055,-1.88504,1.80417,51.79026,-1.64305,1.81779,51.80287,-1.6805,1.99456,51.67772,-1.59721,1.46909,51.99719,-1.86867,1.50724,51.97778,-1.86036,1.49518,51.98056,-1.827,2.7165,50.66889,-.71152,2.60045,50.98973,-1.06838,2.55541,51.0522,-1.03037,2.76817,50.61465,-.73435,1.33902,52.19181,-1.58078,1.32059,52.26981,-1.63538,1.24215,52.24918,-1.62898,1.6082,51.86016,-1.58426,1.61717,51.88911,-1.69438,1.65766,51.86021,-1.66943,1.22272,52.32274,-1.74448,1.16728,52.28774,-1.7129,1.22058,52.32195,-1.75537,1.24396,52.3136,-1.70318,1.22445,52.32318,-1.7372,1.38519,52.35722,-1.8608,1.36099,52.34392,-1.86896,1.3251,52.36348,-1.83195,1.33704,52.17783,-1.93083,1.35529,52.19263,-1.95014,1.38598,52.16759,-1.95224,1.17073,52.2073,-1.72667,1.1558,52.26364,-1.71797,1.17909,52.21389,-1.74529,1.14886,52.25784,-1.70857,1.34771,52.20631,-1.95324,1.31717,52.23715,-1.91868,1.36621,52.23581,-1.95434,1.27054,52.31967,-1.8178,1.27575,52.2904,-1.82567,1.24504,52.27755,-1.80582,1.21277,52.28072,-1.76338,1.27489,52.27185,-1.84585,1.25677,52.2462,-1.82534,1.21218,52.18518,-1.76695,1.23704,52.21941,-1.80206,1.2932,52.29573,-1.86122,2.27666,51.45825,-1.31583,1.97594,51.84773,-1.55032,1.94779,51.8917,-1.51333,1.37857,52.05796,-1.84209,1.31392,52.10626,-1.8251,1.3211,52.10771,-1.83725,1.26445,52.18116,-1.83007,1.25074,52.30532,-1.69101,1.67722,52.17053,-1.61225,1.63213,52.21543,-1.64075,1.60541,52.16273,-1.58269,1.47279,52.17226,-1.593,1.4296,52.28095,-1.67334,1.38584,52.28995,-1.67225,1.32575,52.37463,-1.80278,1.38911,52.36509,-1.81473,1.7208,52.12471,-1.5817,1.76621,52.07333,-1.54494,1.74306,52.04068,-1.48389,1.87324,51.8928,-1.38248,2.13427,51.56277,-1.19201,1.90077,51.91917,-1.43399,2.20424,51.53123,-1.24065,1.27561,52.36063,-1.77422,1.27278,52.35501,-1.78693,1.39462,52.10942,-1.93147,1.46442,52.06942,-1.93521,1.46954,52.02376,-1.89766,1.62004,51.91559,-1.75666,1.70267,51.87194,-1.73702,1.68768,51.86938,-1.71172,1.61867,51.92078,-1.78323,1.49843,51.98276,-1.80533,1.28301,52.24447,-1.86287,1.71335,51.7012,-1.25328,1.62227,51.79063,-1.32006,1.62179,51.78351,-1.32268,.79033,51.95711,-1.40787,.62801,51.91062,-1.39088,.80198,51.94041,-1.43112,.62758,51.93158,-1.37376,2.14265,51.01593,-.69107,2.04642,51.24511,-.87508,2.14335,50.98806,-.70285,2.05351,51.21505,-.88218,2.16777,50.80772,-.53969,2.10904,50.61123,-.29717,2.1677,50.83226,-.52711,2.11461,50.63132,-.28174,1.91088,50.3752,.07936};
			return value;
		}
		private double[] getlrrib_Coord_7_40_point_2()
		{
			double[] value = {1.79097,50.32691,.19417,1.91124,50.38273,.10431,1.80693,50.33436,.21406,1.10989,51.99497,-1.4562,1.09178,51.9974,-1.45567,1.09811,51.98493,-1.48089,1.6708,50.26824,.30064,1.6809,50.28471,.31944,1.29157,52.3502,-1.72539,1.29875,52.33947,-1.69995,1.34803,52.35536,-1.74429,1.36167,52.33447,-1.71572,1.87502,49.51377,.71369,1.86198,49.54277,.75828,1.77297,49.54708,.7938,1.60055,50.22322,.42146,1.62257,50.1887,.44314,1.73387,50.25335,.3598,2.4957,49.85827,.07801,2.34553,49.78219,.19505,2.31315,49.80989,.1798,2.35064,49.59503,.41015,2.20697,49.55284,.50794,2.15598,49.5768,.47749,1.96647,50.23669,.08113,1.85666,50.13108,.20721,1.82344,50.1872,.20417,2.63204,50.92974,-1.09796,2.60874,50.91068,-1.10674,2.31415,51.29759,-1.35359,2.32954,51.34647,-1.37063,2.89111,50.29664,-.44129,2.79219,50.57475,-.75425,2.86175,50.30789,-.42953,1.9197,51.93599,-1.47614,1.78462,51.65937,-1.34526,2.07384,51.33736,-1.24993,1.98081,51.40399,-1.14557,1.8556,51.63448,-1.42836,2.88498,50.24373,-.42678,2.64318,50.61537,-.76848,2.77639,50.55529,-.76546,2.75627,50.29522,-.45555,2.84255,49.96757,-.0938,2.83025,49.95659,-.11361,2.66816,49.75548,.18592,2.64758,49.74288,.16423,1.72449,49.63567,.68774,1.73265,49.561,.7481,1.74329,49.58797,.75628,1.70967,49.59188,.70937,2.08161,49.54236,.63585,1.96292,49.57794,.71342,1.98223,49.53192,.69382,2.05323,49.57672,.65229,1.67401,50.04752,.38166,1.62626,49.91604,.44066,1.5852,50.01161,.41218,1.71965,49.93263,.3916,1.53419,50.15837,.39478,1.55582,50.01974,.41932,1.54084,50.15545,.41906,1.55535,50.03266,.44988,1.58693,49.81467,.51321,1.5828,49.82379,.5253,1.56823,49.92348,.48469,1.56984,49.91595,.46072,1.62698,49.7324,.56776,1.67754,49.63552,.63687,1.62129,49.74119,.57978,1.66485,49.66603,.63719,1.68967,49.75822,.77476,1.66388,49.87478,.72907,1.67549,49.75831,.76917,1.64928,49.86865,.72216,1.52862,50.21983,.4008,1.54672,50.18117,.42847,1.55858,50.15109,.47146,1.582,50.12074,.4523,1.58879,50.09049,.46554,1.57642,50.08588,.44938,1.67184,50.05918,.54957,1.68407,49.966,.64083,1.73127,49.97277,.60857,1.9731,49.51755,.65787,1.83422,49.53334,.68867,1.71294,49.65214,.8218,1.75206,49.76492,.75733,1.80972,49.64572,.77936,1.74843,49.55526,.7718,1.63882,49.75778,.59279,1.69133,49.68164,.65151,1.74051,49.56448,.79346,1.68759,49.74797,.74144,1.65408,49.86158,.68728,1.69272,49.81357,.61657,1.67164,49.85417,.59249,1.64914,49.71407,.54309,1.60499,49.81323,.48782,1.70527,49.62869,.60362};
			return value;
		}
		private double[] getlrrib_Coord_7_40_point_3()
		{
			double[] value = {2.22333,50.28796,.07596,2.17702,50.33212,.05253,2.07546,50.24986,.20334,2.15477,50.15733,.23257,1.36907,52.0832,-1.51474,1.46335,52.06372,-1.50038,2.02775,50.46015,-.08017,2.11492,50.28357,-.04867,1.58656,49.9996,.47736,1.6171,50.00898,.50671,1.73422,49.65304,.72526,1.71716,49.70901,.67683,.70541,52.2532,-1.61312,.71805,52.26168,-1.61618,.85942,52.26772,-1.65009,.56137,52.19075,-1.52865,.56417,52.20057,-1.54387,.53048,52.19092,-1.51002,1.01831,52.27604,-1.61735,1.0246,52.28569,-1.645,.94828,52.3065,-1.63734,1.34114,52.10086,-1.86728,.51429,51.99462,-1.51115,.511,52.04309,-1.53707,.56076,52.04962,-1.578,.57912,51.99898,-1.54943,.74457,52.08187,-1.62047,.75823,52.08456,-1.62274,.76764,52.03179,-1.60106,.86628,52.23033,-1.6506,.86689,52.17878,-1.64417,.7408,52.18302,-1.62433,.7199,52.22535,-1.61851,.76235,52.27849,-1.62633,.86074,52.2833,-1.64495,.66184,52.24034,-1.59851,.60597,52.21659,-1.58502,.6604,52.24828,-1.58748,.60673,52.22165,-1.57403,.72408,52.27028,-1.60005,.76947,52.29125,-1.61351,.9057,52.32327,-1.63145,.89948,52.32137,-1.64524,.85752,52.3282,-1.62919,.94108,52.29916,-1.65166,1.01344,52.28134,-1.66125,.81781,52.3164,-1.62201,.82173,52.30591,-1.63403,.82099,52.31462,-1.61641,.82925,52.30987,-1.60186,.50282,52.17793,-1.46319,.52496,52.17658,-1.48295,.51377,52.18149,-1.48542,.45785,52.1531,-1.37412,.51442,52.16378,-1.41197,.50731,52.11222,-1.53896,.51333,52.12429,-1.55175,.51286,52.09918,-1.55033,.49395,51.90467,-1.38472,.48672,51.93195,-1.39241,.49263,51.93572,-1.41224,.51638,51.91482,-1.42306,.47276,51.92121,-1.33921,.47331,51.96057,-1.30801,.47605,51.94567,-1.35961,.46577,51.98949,-1.34231,.46913,51.99256,-1.4145,.45721,52.05608,-1.28449,.42998,52.04523,-1.30352,.49867,51.945,-1.29273,.45482,52.11479,-1.33067,.43866,52.10029,-1.3428,.45177,52.13251,-1.39964,.46166,52.06178,-1.43103,.45537,52.06291,-1.41036,.44888,52.04608,-1.38198,1.29546,52.25506,-1.88424,1.27201,52.16745,-1.82665,1.30902,52.17522,-1.88982,1.32678,52.14158,-1.8857,.54676,51.9149,-1.36044,.56475,51.96688,-1.33463,.82646,52.0805,-1.41497,.92859,52.1541,-1.46619,.82234,52.1341,-1.44631,.9375,52.09927,-1.44497,1.15764,52.0686,-1.44868,1.15264,52.13529,-1.49063,1.04184,52.15008,-1.47253,1.04895,52.08847,-1.44686,.87412,52.31096,-1.60133,.90142,52.31472,-1.61603,1.14547,52.20572,-1.52623,1.22815,52.19448,-1.55394,1.1481,52.24242,-1.60821,.86281,52.31104,-1.63649,1.24393,51.97515,-1.44977,1.25093,51.99491,-1.43711,1.13027,52.0154,-1.43113,.61582,52.16596,-1.47424};
			return value;
		}
		private double[] getlrrib_Coord_7_40_point_4()
		{
			double[] value = {.72015,52.11738,-1.42376,.71124,52.18127,-1.47995,.62246,52.10845,-1.40278,.94957,51.99304,-1.43344,.81966,51.99841,-1.39174,.80867,51.95881,-1.41241,.94814,52.02653,-1.42173,.70806,52.2626,-1.59416,.7426,52.24941,-1.56862,1.82808,51.82601,-1.70541,1.06289,52.24556,-1.67364,1.0679,52.25844,-1.67563,1.11392,52.25329,-1.69262,.67859,52.20648,-1.61656,.66806,52.23392,-1.57899,1.46774,52.26639,-1.66015,2.22588,49.56483,.52944,2.40923,51.18981,-.98916,1.59956,49.90765,.45568,2.29988,50.02956,.01293,2.16613,49.96444,.1325,2.12427,50.01715,.1189,1.77374,51.76855,-1.58175,1.73239,51.74835,-1.50283,.65513,51.93044,-1.46288,.64541,51.91439,-1.41216,.59412,51.89601,-1.4397,.56809,51.8935,-1.40052,.49409,51.96992,-1.44619,.4805,52.06353,-1.46582,.56346,52.19215,-1.56549,.56652,52.16606,-1.58934,.6118,52.18213,-1.60995,.4858,52.0451,-1.4814,.48682,52.00417,-1.48386,.56239,52.18437,-1.50816,.44318,52.02224,-1.35473,.66234,51.97624,-1.52652,.60375,51.96042,-1.50362,2.00271,51.78333,-1.58577,2.31126,51.4099,-1.3432,2.46959,49.74969,.31859,2.53569,49.66853,.30271,2.59479,49.84509,.17933,1.51446,51.9161,-1.3907,1.50483,51.88905,-1.37058,1.61441,51.82121,-1.30946,1.07613,52.02274,-1.42967,1.78727,52.09291,-1.58906,1.72483,52.16773,-1.6476,1.71406,52.16897,-1.63468,1.70312,49.67966,.77409,1.23319,51.98989,-1.60839,1.06157,52.03861,-1.62494,1.21061,52.03955,-1.67267,1.08622,52.00529,-1.56913,1.83532,52.00534,-1.66612,1.8468,51.93458,-1.70757,.60074,52.20555,-1.55837,1.14396,52.2586,-1.6495,1.03002,52.22792,-1.51331,1.09823,52.24511,-1.58804,1.0111,52.26045,-1.58419,.80998,52.20393,-1.49263,.91362,52.22808,-1.50465,.89824,52.26856,-1.54387,.79127,52.24225,-1.54562,.73275,52.0694,-1.39625,.63037,52.05552,-1.36489,.76579,51.99337,-1.37815,.62287,51.97199,-1.35368,1.35583,51.99783,-1.44032,1.26529,52.0352,-1.44703,1.36319,51.95487,-1.4132,.86819,52.0981,-1.65219,.86681,52.15147,-1.64592,.75023,52.1508,-1.62585,.56351,52.16169,-1.44457,.51325,51.87836,-1.34434,.54134,51.88493,-1.39442,.47374,52.15346,-1.45702,.51132,52.16265,-1.52124,.49523,52.12938,-1.50266,.56984,52.05591,-1.3449,.52348,52.06583,-1.32098,.60061,52.19904,-1.54455,.60039,52.19247,-1.53,.88573,52.28751,-1.57345,.81334,52.2804,-1.57671,.78787,52.28559,-1.59631,.67819,52.22309,-1.55832,.68798,52.2119,-1.53628,1.07487,52.27333,-1.66111,1.74033,51.9774,-1.80766,1.84179,51.88733,-1.72982,1.72282,51.93241,-1.80552,.49989,52.12426,-1.52208,1.59574,50.11039,.53642,1.60076,50.17501,.46219,1.57243,50.16165,.48408};
			return value;
		}
		private double[] getlrrib_Coord_7_40_point_5()
		{
			double[] value = {1.63761,50.11629,.50608,1.72531,49.60634,.78078,1.56052,50.22704,.38703,1.58024,50.23007,.37796,1.62906,50.14631,.37485,1.57037,50.14503,.38795,2.2712,50.51337,-.21039,1.78249,49.52788,.76675,1.76135,49.53633,.73008,1.84327,49.57942,.78345,1.6758,50.1232,.47631,1.58958,50.09083,.49505,1.55247,50.20341,.45017,1.64411,49.96993,.66851,1.62239,49.95908,.64713,1.70115,49.64819,.8158,1.73334,49.56639,.69642,2.5136,49.66311,.27875,2.36951,49.60446,.42909,1.64136,52.23067,-1.66757,1.52272,52.32164,-1.75862,1.52403,52.31153,-1.71851,1.64801,52.23962,-1.69694,2.24755,50.77939,-.50321,2.32769,50.7246,-.48014,2.20934,50.99892,-.69009,2.46775,50.6359,-.43739,2.47276,50.32943,-.15249,1.85692,50.27726,.28271,1.883,50.24792,.2994,2.00053,50.32057,.16728,2.00455,51.56696,-1.13287,1.79836,51.84765,-1.33656,1.5749,52.08759,-1.53526,1.68473,51.98301,-1.42888,1.38424,51.92529,-1.42016,1.44519,51.89678,-1.39685,1.43445,51.92296,-1.39313,1.58408,50.25141,.39925,1.51367,51.86378,-1.37436,1.53269,51.85508,-1.40558,1.24761,51.97833,-1.49429,.94904,51.98079,-1.45863,2.01878,51.71366,-1.60917,1.15728,52.20159,-1.71816,1.46765,52.13229,-1.95295,1.81739,52.05074,-1.62678,1.35271,52.34436,-1.87438,1.36661,52.31445,-1.90772,1.31386,52.31399,-1.86901,1.50763,52.25012,-1.6439,1.7088,51.9055,-1.79187,1.32253,52.36067,-1.84599,1.28977,52.21893,-1.88179,1.33184,52.19273,-1.93695,1.37607,52.22854,-1.9518,1.37577,52.31094,-1.90374,2.79196,50.35338,-.4061,1.70921,51.88,-1.76195,1.61456,51.9284,-1.81346,2.18742,50.5796,-.2466,2.03799,50.48392,-.06012,2.08994,50.41057,.01293,1.64744,51.90724,-1.37008,1.54763,52.01494,-1.46618,1.46396,51.88896,-1.43306,1.56485,50.24929,.40662,1.43529,51.96155,-1.41595,1.2696,52.3521,-1.79963,1.30042,52.19005,-1.89177,1.21313,52.17398,-1.76012,1.40965,51.92221,-1.52205,1.49419,51.88631,-1.50815,1.39461,51.92085,-1.45806,1.35109,52.12847,-1.91062,1.52102,52.29266,-1.68908,1.46587,52.31348,-1.70914,1.46402,52.33563,-1.74195,1.4528,52.34895,-1.79193,1.40318,52.35268,-1.75262,1.41325,52.32814,-1.72037,1.64849,52.22173,-1.74884,1.73869,52.13522,-1.69215,1.44149,52.29567,-1.90131,1.51873,52.31069,-1.81893,1.51834,52.26554,-1.87222,1.44854,52.34019,-1.84799,1.75029,52.08745,-1.73576,1.60796,51.96637,-1.85545,1.54279,52.0342,-1.9152,1.6235,52.00049,-1.8792,1.52889,51.99991,-1.88915,1.64283,52.04673,-1.87678,1.6488,52.08634,-1.85093,1.64988,52.16854,-1.79941,1.74374,52.0212,-1.78281,1.40788,52.00487,-1.75859,1.51288,51.95149,-1.73766,1.4574,52.19987,-1.94298,1.16586,52.16702,-1.72304};
			return value;
		}
		private double[] getlrrib_Coord_7_40_point_6()
		{
			double[] value = {1.55029,52.15977,-1.9061,1.5652,52.08463,-1.91867,1.88522,51.49801,-1.06809,1.89264,51.4644,-1.07727,1.71009,51.73279,-1.24552,1.08717,52.25926,-1.62294,1.04411,52.1996,-1.66938,1.03589,52.16369,-1.67023,1.94195,50.00203,.46495,1.87708,49.90052,.59709,2.02225,49.90794,.50158,1.80552,49.98307,.55992,2.14568,49.93745,.39839,2.27532,50.00631,.26781,2.0384,50.07107,.36273,2.36559,50.11795,.1212,1.8522,50.10312,.42324,1.95547,50.16783,.33183,1.79344,50.17708,.39113,1.75197,50.08056,.3123,1.81048,49.95698,.32183,1.95177,49.983,.22775,2.13084,49.78003,.30114,2.04349,49.67994,.42002,1.97521,49.74961,.38728,2.183,49.72393,.32609,1.70725,50.15968,.30206,2.1825,51.26393,-.92445,2.31175,49.70522,.434,2.16513,49.6792,.53782,2.10753,49.79411,.5269,2.23604,49.82155,.42306,2.37296,49.87742,.30038,2.63967,50.48544,-.41616,2.62853,50.18144,-.1133,2.35914,50.93361,-.68081,2.5393,50.8326,-.69052,1.93293,51.5256,-1.09403,1.753,51.78656,-1.28608,2.19604,51.32342,-1.32045,1.92218,51.6468,-1.50717,2.32535,50.62043,-.53538,2.43573,50.71321,-.76784,2.53132,50.41604,-.50152,2.28477,50.85264,-.74075,2.27106,50.402,-.26931,2.46619,50.1909,-.22438,2.68399,50.04115,-.1641,2.01718,49.90462,.25302,1.87681,49.85444,.34225,2.05174,49.52687,.60476,1.61268,50.06255,.58105,1.5812,50.21587,.43293,1.74104,49.58515,.82126,1.72406,49.58971,.81105,1.76974,49.56474,.65793,1.94807,49.77351,.63448,1.90508,49.64689,.71852,2.0035,49.64777,.65976,1.8485,49.76941,.69477,1.78627,49.89096,.6562,1.73264,49.71598,.50973,1.76429,49.83085,.40807,1.84835,49.73003,.4547,1.6629,49.81669,.45876,1.89555,49.56564,.61071,1.91478,49.65331,.49984,1.99568,49.56845,.55808,1.8137,49.64016,.55837,1.59207,50.05209,.56235,1.57902,50.09662,.52408,1.61226,50.01091,.56292,1.63361,49.93451,.62537,1.64832,49.92985,.54756,1.59225,49.9147,.50223,1.60529,49.83538,.53894,2.73434,50.07075,-.09171,2.49463,49.9761,.16136,1.71013,49.88248,.70878,2.09515,51.25246,-.89296,2.48658,50.94427,-1.07564,2.17319,51.1267,-.94417,1.53553,50.2399,.42118,.51178,52.14363,-1.54552,1.25055,52.11229,-1.50661,1.04214,52.06701,-1.6602,1.17703,52.11979,-1.73002,1.19352,52.07162,-1.71361,1.03388,52.11461,-1.6751,.88236,52.05813,-1.63633,.65928,52.06739,-1.60711,.60606,52.00395,-1.55859,.59079,52.05495,-1.59101,.67311,52.01548,-1.57574,.54337,52.13645,-1.5771,.53768,52.15876,-1.56897,.5707,52.14229,-1.59543,.62289,52.15397,-1.61769,.69607,52.17492,-1.6231,.57456,52.11755,-1.59855};
			return value;
		}
		private double[] getlrrib_Coord_7_40_point_7()
		{
			double[] value = {.5494,52.11009,-1.58357,.53297,52.17909,-1.54396,.56438,52.10891,-1.38215,.50913,52.11482,-1.35487,.55253,51.89183,-1.37659,.58101,51.95449,-1.4941,.56694,51.89,-1.43175,.52141,51.95612,-1.46601,.70767,52.15317,-1.62543,.63359,52.13462,-1.62064,.7789,51.99999,-1.56486,.89968,52.03238,-1.6022,1.67421,51.75844,-1.40846,1.5644,51.85278,-1.48556,1.24142,51.98218,-1.53206,1.09536,51.98828,-1.5113,.94374,51.98604,-1.49627,.8003,51.94284,-1.44844,.94426,52.28669,-1.5987,1.52159,51.89905,-1.61182,.92096,51.99935,-1.5496,.79068,51.96243,-1.50553,2.3154,51.00666,-1.02418,1.41117,51.94213,-1.63444,1.72931,50.06448,.51182};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib2_Geo_6_45_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,10,11,12,-1,12,13,10,-1,12,14,13,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,31,32,33,-1,34,35,36,-1,34,37,35,-1,34,38,39,-1,39,37,34,-1,40,41,42,-1,42,43,40,-1,44,10,45,-1,46,41,47,-1,1,48,49,-1,1,0,48,-1,8,50,9,-1,8,51,50,-1,52,53,54,-1,54,55,52,-1,56,57,58,-1,57,59,58,-1,60,61,62,-1,63,64,65,-1,65,66,63,-1,67,68,69,-1,68,70,69,-1,65,71,66,-1,65,58,71,-1,72,73,74,-1,75,57,56,-1,76,77,60,-1,78,79,80,-1,81,82,83,-1,82,84,83,-1,85,86,87,-1,86,88,87,-1,89,90,91,-1,89,92,90,-1,93,94,95,-1,95,96,93,-1,97,98,99,-1,99,100,97,-1,101,102,90,-1,90,92,101,-1,95,91,103,-1,103,104,95,-1,85,98,86,-1,85,99,98,-1,105,106,107,-1,106,108,107,-1,109,110,88,-1,110,111,88,-1,112,87,113,-1,112,114,87,-1,115,116,81,-1,115,117,116,-1,118,103,91,-1,91,90,118,-1,119,120,121,-1,119,122,120,-1,123,124,125,-1,123,126,124,-1,127,128,129,-1,127,130,128,-1,131,132,133,-1,131,134,132,-1,62,76,60,-1,135,60,136,-1,36,137,49,-1,36,35,137,-1,138,67,139,-1,139,140,138,-1,55,141,142,-1,142,52,55,-1,39,143,144,-1,144,145,39,-1,137,146,147,-1,147,148,137,-1,149,150,11,-1,11,151,149,-1,152,153,154,-1,152,155,153,-1,156,157,158,-1,156,159,157,-1,160,161,162,-1,160,163,161,-1,164,165,166,-1,167,168,169,-1,170,171,172,-1,173,174,175,-1,176,177,178,-1,176,179,177,-1,0,10,44,-1,0,2,10,-1,11,150,180,-1,181,9,182,-1,181,7,9,-1,183,78,184,-1,78,185,184,-1,186,187,188,-1,186,189,187,-1,190,23,191,-1,190,24,23,-1,192,193,194,-1,192,195,193,-1,196,195,192,-1,196,154,195,-1,188,119,197,-1,188,187,119,-1,198,199,200,-1,198,121,199,-1,201,202,203,-1,201,204,202,-1,8,184,185,-1,8,29,184,-1,205,206,207,-1,205,208,206,-1,207,206,44,-1,44,45,207,-1,13,14,209,-1,18,210,15,-1,18,211,210,-1,212,213,214,-1,212,6,213,-1,157,215,155,-1,157,168,215,-1,108,216,217,-1,216,164,217,-1,132,168,218,-1,132,215,168,-1,158,157,155,-1,155,152,158,-1,108,193,216,-1,108,106,193,-1,219,211,220,-1,219,210,211,-1,221,222,223,-1,221,224,222,-1,147,225,222,-1,147,146,225,-1,226,60,227,-1,228,229,203,-1,203,202,228,-1,38,143,39,-1,38,32,143,-1,230,231,60,-1,135,61,60,-1,23,22,26,-1,22,232,26,-1,133,218,233,-1,133,132,218,-1,234,130,127,-1,234,235,130,-1,236,173,189,-1,236,174,173,-1,121,221,199,-1,121,120,221,-1,64,140,237,-1,66,238,63,-1,66,239,238,-1,82,81,116,-1,116,96,82,-1,240,99,85,-1,240,102,99,-1,241,216,195,-1,216,193,195,-1,105,110,242,-1,110,243,242,-1,244,113,107,-1,113,111,107,-1,110,105,111,-1,105,107,111,-1,245,93,116,-1,93,96,116,-1,246,247,115,-1,115,248,246,-1,115,81,248,-1,81,83,248,-1,136,60,226,-1,60,77,230,-1,249,250,251,-1,251,252,249,-1,77,253,254,-1,77,76,253,-1,255,51,256,-1,51,257,256,-1,258,259,237,-1,54,139,260,-1,260,74,54,-1,75,258,251,-1,258,261,251,-1,202,204,262,-1,227,60,231,-1,30,8,7,-1,0,206,48,-1,0,44,206,-1,45,13,46,-1,45,10,13,-1,263,184,29,-1,263,264,184,-1,265,181,182,-1,265,266,181,-1,137,267,146,-1,137,35,267,-1,268,264,269,-1,270,50,271,-1,270,31,50,-1,101,272,100,-1,101,273,272,-1,26,232,27,-1,179,274,275,-1,276,277,278,-1,278,279,276,-1,280,196,192,-1,192,281,280,-1,192,194,281,-1,194,191,281,-1,245,92,89,-1,180,197,198,-1,198,14,180,-1,71,58,59,-1,8,30,29,-1,270,229,282,-1,5,4,283,-1,151,213,149,-1,151,284,213,-1,285,79,78,-1,79,285,286,-1,148,2,1,-1,148,287,2,-1,272,97,100,-1,272,288,97,-1,273,92,245,-1,273,101,92,-1,124,236,125,-1,174,236,124,-1,279,196,280,-1,279,278,196,-1,289,277,276,-1,289,290,277,-1,290,291,292,-1};
			return value;
		}
		private int[] getlrib2_Geo_6_45_coordIndex_2()
		{
			int[] value = {289,291,290,-1,293,15,294,-1,15,293,16,-1,295,186,188,-1,295,296,186,-1,297,17,298,-1,297,18,17,-1,299,171,300,-1,301,171,299,-1,175,302,173,-1,175,178,302,-1,303,304,305,-1,303,306,304,-1,194,106,307,-1,193,106,194,-1,268,308,309,-1,268,269,308,-1,269,43,310,-1,269,264,43,-1,311,35,37,-1,35,311,267,-1,312,309,308,-1,309,312,313,-1,312,146,267,-1,146,312,225,-1,265,314,208,-1,265,315,314,-1,205,316,266,-1,316,205,317,-1,266,28,181,-1,266,316,28,-1,182,315,265,-1,315,182,318,-1,29,316,263,-1,29,28,316,-1,200,14,198,-1,209,14,200,-1,207,317,205,-1,317,207,47,-1,318,32,38,-1,318,33,32,-1,208,48,206,-1,208,314,48,-1,141,73,319,-1,141,55,73,-1,64,138,140,-1,64,63,138,-1,228,74,260,-1,320,74,228,-1,262,250,321,-1,262,57,250,-1,54,140,139,-1,54,53,140,-1,321,202,262,-1,202,321,322,-1,261,237,323,-1,237,261,258,-1,258,56,259,-1,56,258,75,-1,71,255,256,-1,201,255,71,-1,262,59,57,-1,262,204,59,-1,324,325,249,-1,326,325,324,-1,201,271,255,-1,201,203,271,-1,142,227,231,-1,141,227,142,-1,327,136,328,-1,135,136,327,-1,62,253,76,-1,62,324,253,-1,329,77,254,-1,230,77,329,-1,320,72,74,-1,320,330,72,-1,325,322,321,-1,325,331,322,-1,261,252,251,-1,332,252,261,-1,52,323,53,-1,52,333,323,-1,333,254,332,-1,254,333,329,-1,80,185,78,-1,80,257,185,-1,144,334,335,-1,144,336,334,-1,143,31,337,-1,32,31,143,-1,103,338,104,-1,103,339,338,-1,118,114,340,-1,118,240,114,-1,341,246,109,-1,247,246,341,-1,117,245,116,-1,117,273,245,-1,288,342,343,-1,288,272,342,-1,344,345,346,-1,344,347,345,-1,24,344,22,-1,344,24,348,-1,84,349,83,-1,84,347,349,-1,350,351,352,-1,351,350,353,-1,244,354,355,-1,354,244,217,-1,352,112,355,-1,112,352,351,-1,217,107,108,-1,217,244,107,-1,232,350,27,-1,232,346,350,-1,190,242,356,-1,242,190,307,-1,243,109,246,-1,243,110,109,-1,83,357,248,-1,349,357,83,-1,241,154,153,-1,195,154,241,-1,326,331,325,-1,327,331,326,-1,343,86,98,-1,343,341,86,-1,239,79,238,-1,239,80,79,-1,65,237,259,-1,65,64,237,-1,286,238,79,-1,238,286,358,-1,183,309,359,-1,268,309,183,-1,360,221,223,-1,221,360,199,-1,173,187,189,-1,173,361,187,-1,172,234,362,-1,172,235,234,-1,218,363,233,-1,218,170,363,-1,364,26,365,-1,23,26,364,-1,345,339,353,-1,345,338,339,-1,142,333,52,-1,329,333,142,-1,337,270,282,-1,270,337,31,-1,331,328,330,-1,327,328,331,-1,366,285,359,-1,285,366,335,-1,367,222,225,-1,367,223,222,-1,366,311,145,-1,366,313,311,-1,336,68,334,-1,70,68,336,-1,260,229,228,-1,69,229,260,-1,368,214,369,-1,214,368,370,-1,368,221,120,-1,368,224,221,-1,222,371,147,-1,371,222,224,-1,369,287,371,-1,369,284,287,-1,372,5,373,-1,5,372,3,-1,220,374,283,-1,220,211,374,-1,219,375,210,-1,219,376,375,-1,377,375,376,-1,375,377,378,-1,379,132,134,-1,379,215,132,-1,365,166,165,-1,26,166,365,-1,111,87,88,-1,113,87,111,-1,215,153,155,-1,215,379,153,-1,157,169,168,-1,159,169,157,-1,380,163,20,-1,163,380,161,-1,301,305,304,-1,305,301,299,-1,300,20,299,-1,300,380,20,-1,304,235,301,-1,304,130,235,-1,381,173,302,-1,381,361,173,-1,214,381,212,-1,214,370,381,-1,382,6,212,-1,382,4,6,-1,383,219,275,-1,219,383,376,-1,283,179,220,-1,179,283,177,-1,179,384,274,-1,176,384,179,-1,126,385,124,-1,126,386,385,-1,306,130,304,-1,306,128,130,-1,19,383,387,-1,21,383,19,-1,274,303,387,-1,303,274,384,-1,18,374,211,-1,297,374,18,-1,296,372,373,-1,295,372,296,-1,14,11,180,-1,14,12,11,-1,46,209,41,-1,209,46,13,-1,264,40,43,-1,264,263,40,-1,255,50,51,-1,255,271,50,-1,259,58,65,-1,259,56,58,-1,200,360,42,-1,360,200,199,-1,119,198,197,-1,119,121,198,-1,125,298,17,-1,125,236,298,-1,129,16,293,-1,129,123,16,-1,388,234,127,-1,389,234,388,-1,291,363,362,-1,289,363,291,-1,279,233,276,-1,279,133,233,-1,281,131,280,-1,281,364,131,-1,243,356,242,-1};
			return value;
		}
		private int[] getlrib2_Geo_6_45_coordIndex_3()
		{
			int[] value = {356,243,357,-1,154,278,152,-1,278,154,196,-1,158,290,156,-1,290,158,277,-1,292,160,162,-1,390,160,292,-1,375,391,294,-1,375,378,391,-1,294,210,375,-1,294,15,210,-1,390,378,160,-1,391,378,390,-1,292,156,290,-1,292,162,156,-1,277,152,278,-1,277,158,152,-1,191,307,190,-1,191,194,307,-1,349,356,357,-1,348,356,349,-1,191,364,281,-1,191,23,364,-1,280,133,279,-1,280,131,133,-1,276,363,289,-1,276,233,363,-1,389,362,234,-1,291,362,389,-1,127,293,388,-1,127,129,293,-1,123,17,16,-1,123,125,17,-1,236,186,298,-1,236,189,186,-1,264,183,184,-1,264,268,183,-1,257,239,256,-1,239,257,80,-1,295,150,372,-1,180,150,295,-1,373,297,296,-1,373,374,297,-1,151,10,2,-1,151,11,10,-1,275,387,383,-1,274,387,275,-1,305,387,303,-1,305,19,387,-1,386,128,306,-1,126,128,386,-1,176,386,384,-1,176,385,386,-1,220,275,219,-1,179,275,220,-1,4,177,283,-1,177,4,382,-1,376,21,377,-1,376,383,21,-1,175,124,385,-1,175,174,124,-1,178,382,302,-1,178,177,382,-1,122,381,370,-1,381,122,361,-1,302,212,381,-1,302,382,212,-1,172,301,235,-1,171,301,172,-1,170,168,167,-1,170,218,168,-1,167,380,300,-1,167,169,380,-1,19,299,20,-1,299,19,305,-1,377,20,163,-1,21,20,377,-1,161,169,159,-1,161,380,169,-1,379,241,153,-1,379,165,241,-1,26,354,166,-1,26,25,354,-1,134,165,379,-1,365,165,134,-1,378,163,160,-1,378,377,163,-1,162,159,156,-1,162,161,159,-1,283,373,5,-1,283,374,373,-1,3,150,149,-1,3,372,150,-1,284,214,213,-1,214,284,369,-1,147,287,148,-1,371,287,147,-1,224,369,371,-1,224,368,369,-1,120,370,368,-1,370,120,122,-1,145,37,39,-1,311,37,145,-1,337,70,336,-1,337,282,70,-1,72,319,73,-1,319,330,328,-1,72,330,319,-1,69,139,67,-1,69,260,139,-1,145,335,366,-1,145,144,335,-1,313,359,309,-1,359,313,366,-1,358,334,68,-1,358,286,334,-1,1,137,148,-1,1,49,137,-1,249,253,324,-1,249,252,253,-1,365,131,364,-1,365,134,131,-1,170,362,363,-1,170,172,362,-1,123,128,126,-1,129,128,123,-1,119,361,122,-1,187,361,119,-1,310,223,367,-1,310,360,223,-1,359,78,183,-1,285,78,359,-1,114,351,340,-1,114,112,351,-1,342,115,247,-1,342,117,115,-1,246,357,243,-1,357,246,248,-1,105,307,106,-1,105,242,307,-1,356,24,190,-1,356,348,24,-1,25,355,354,-1,355,25,352,-1,346,353,350,-1,346,345,353,-1,355,113,244,-1,355,112,113,-1,340,353,339,-1,340,351,353,-1,27,352,25,-1,352,27,350,-1,348,347,344,-1,347,348,349,-1,22,346,232,-1,22,344,346,-1,347,338,345,-1,347,84,338,-1,90,240,118,-1,102,240,90,-1,342,341,343,-1,342,247,341,-1,104,96,95,-1,104,82,96,-1,102,100,99,-1,102,101,100,-1,288,98,97,-1,288,343,98,-1,272,117,342,-1,272,273,117,-1,91,94,89,-1,94,91,95,-1,86,109,88,-1,109,86,341,-1,240,87,114,-1,240,85,87,-1,103,340,339,-1,103,118,340,-1,84,104,338,-1,82,104,84,-1,143,336,144,-1,337,336,143,-1,335,286,285,-1,286,335,334,-1,8,257,51,-1,8,185,257,-1,332,253,252,-1,332,254,253,-1,63,358,138,-1,63,238,358,-1,323,332,261,-1,333,332,323,-1,322,330,320,-1,330,322,331,-1,74,55,54,-1,55,74,73,-1,61,327,326,-1,61,135,327,-1,328,226,319,-1,136,226,328,-1,231,329,142,-1,231,230,329,-1,66,256,239,-1,66,71,256,-1,270,203,229,-1,270,271,203,-1,68,138,358,-1,138,68,67,-1,69,282,229,-1,69,70,282,-1,62,326,324,-1,61,326,62,-1,249,321,250,-1,325,321,249,-1,71,204,201,-1,204,71,59,-1,75,250,57,-1,250,75,251,-1,202,320,228,-1,320,202,322,-1,140,323,237,-1,323,140,53,-1,319,227,141,-1,227,319,226,-1,182,33,318,-1,33,182,9,-1,36,48,314,-1,36,49,48,-1,47,40,317,-1,41,40,47,-1,45,47,207,-1,46,47,45,-1,181,30,7,-1,28,30,181,-1,209,42,41,-1,209,200,42,-1,310,42,360,-1,310,43,42,-1,38,315,318,-1,34,315,38,-1,317,263,316,-1,263,317,40,-1,208,266,265,-1,266,208,205,-1,34,314,315,-1,34,36,314,-1,225,308,367,-1,312,308,225,-1,313,267,311,-1,267,313,312,-1};
			return value;
		}
		private int[] getlrib2_Geo_6_45_coordIndex_4()
		{
			int[] value = {269,367,308,-1,269,310,367,-1,33,50,31,-1,33,9,50,-1,217,166,354,-1,217,164,166,-1,165,216,241,-1,165,164,216,-1,384,306,303,-1,384,386,306,-1,178,385,176,-1,175,385,178,-1,167,171,170,-1,171,167,300,-1,188,180,295,-1,180,188,197,-1,298,296,297,-1,296,298,186,-1,294,388,293,-1,388,294,391,-1,389,391,390,-1,389,388,391,-1,389,292,291,-1,389,390,292,-1,94,245,89,-1,245,94,93,-1,6,149,213,-1,149,6,3,-1,284,2,287,-1,2,284,151,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib2_Coord_7_45_point_1()
		{
			double[] value = {1.40023,51.52715,-2.42704,1.39726,51.56475,-2.42339,1.65857,51.49169,-2.54075,2.84051,50.72224,-2.39796,3.2231,50.41233,-2.13673,3.23482,50.3582,-2.15155,2.85865,50.77275,-2.3719,1.09404,51.44519,-2.09895,1.07588,51.42401,-2.03808,1.03122,51.47854,-2.08286,1.64688,51.40158,-2.53605,1.98169,51.25566,-2.57945,1.99163,51.25382,-2.54595,1.68504,51.37954,-2.44038,2.01875,51.2574,-2.44878,3.80145,49.63974,-1.36972,3.70373,49.65794,-1.30827,3.58421,49.84671,-1.49819,3.65386,49.83053,-1.57263,3.97097,49.38726,-.86192,3.98259,49.18977,-.5628,4.03117,49.34823,-.87269,1.82506,48.93385,1.26759,2.12378,48.92021,1.16857,1.80611,48.91039,1.25691,1.93296,48.90795,1.36545,2.16566,48.94101,1.21628,1.88392,48.95351,1.31829,1.15971,51.40332,-2.16075,1.21033,51.38398,-2.13082,1.15386,51.41345,-2.11491,.87175,51.52406,-1.95236,1.01192,51.54472,-2.0698,1.02176,51.51138,-2.07633,1.12471,51.56302,-2.21745,1.19679,51.64373,-2.26294,1.17941,51.57028,-2.29368,1.13702,51.63256,-2.20897,1.0586,51.5631,-2.14169,1.07033,51.62635,-2.15519,1.31787,51.35928,-2.2444,1.3803,51.37539,-2.2899,1.46482,51.34446,-2.1963,1.40415,51.34869,-2.15191,1.41399,51.45265,-2.41638,1.44711,51.41865,-2.38379,1.46003,51.39553,-2.35192,1.33532,51.40109,-2.35023,1.24087,51.53383,-2.38458,1.23338,51.58358,-2.36996,.88633,51.47512,-1.96488,.94168,51.38604,-1.93879,.54407,51.49798,-1.4245,.59222,51.51816,-1.38352,.60053,51.59666,-1.53753,.54649,51.53214,-1.54645,.61501,51.18898,-1.51083,.60687,51.17667,-1.6234,.68069,51.23596,-1.61296,.66543,51.20588,-1.6641,.48679,51.3824,-1.53895,.5004,51.34488,-1.57483,.50129,51.31654,-1.55338,.74996,51.47891,-1.51687,.66318,51.43033,-1.42284,.68887,51.31873,-1.51529,.78125,51.36292,-1.58745,.69068,51.59766,-1.60488,.78499,51.60077,-1.69002,.67349,51.58674,-1.72114,.73061,51.60596,-1.7686,.75697,51.26523,-1.72351,.54454,51.49744,-1.67468,.54806,51.52772,-1.64006,.59535,51.57048,-1.6731,.58878,51.14593,-1.46929,.50048,51.32039,-1.51261,.49118,51.3464,-1.48116,1.18526,51.45316,-1.85043,1.01964,51.50753,-1.73309,1.04038,51.42999,-1.75398,1.64518,48.84771,1.34938,1.64268,48.86903,1.35905,1.63197,48.85667,1.32534,1.64257,48.89374,1.34017,1.79658,48.62929,1.57271,1.79696,48.56529,1.57689,1.81242,48.63628,1.58758,1.82811,48.5547,1.58803,1.76272,48.80087,1.41932,1.77014,48.82084,1.4321,1.74103,48.86521,1.40423,1.76933,48.78835,1.43042,1.74548,48.82106,1.39376,1.75137,48.82111,1.40519,1.73094,48.88006,1.38362,1.71286,48.87194,1.36717,1.82328,48.67602,1.47764,1.8662,48.61586,1.52817,1.85644,48.6529,1.52331};
			return value;
		}
		private double[] getlrib2_Coord_7_45_point_2()
		{
			double[] value = {1.8126,48.69668,1.47109,1.79075,48.73709,1.45705,1.79955,48.74962,1.48206,1.67702,48.89894,1.40727,1.66037,48.88721,1.38807,1.97235,48.55179,1.47134,2.07688,48.56917,1.42484,1.99167,48.57446,1.49366,2.10241,48.5838,1.44223,1.81326,48.52842,1.56653,1.87487,48.54988,1.51583,1.89993,48.57058,1.54657,1.82875,48.77469,1.50996,1.88045,48.65046,1.54144,1.77397,48.75051,1.5428,1.66181,48.66414,1.39395,1.69573,48.85398,1.34906,1.73161,48.70067,1.39899,1.70871,48.86286,1.45851,2.43817,51.05029,-2.16056,2.11078,51.33595,-2.15962,2.0869,51.27625,-2.19543,2.44659,51.09941,-2.11691,3.36482,49.8032,-1.15552,3.30707,50.01356,-1.33624,3.3033,49.95327,-1.31923,3.39419,49.84918,-1.16311,3.45937,49.55991,-.82626,3.45061,49.69603,-.97265,3.41863,49.67064,-.99432,3.49656,49.5924,-.81822,2.72405,48.91016,.83617,3.12888,48.96206,.62256,3.08464,48.92401,.59156,2.77158,48.93919,.87143,.50013,51.37333,-1.59629,.49494,51.4088,-1.59616,1.25564,51.65917,-2.31689,.72216,51.53978,-1.49604,.6299,51.60766,-1.5438,.61738,51.52629,-1.39258,.51962,51.49381,-1.54914,.5007,51.47175,-1.47332,1.00176,51.57847,-2.06328,1.03447,51.67052,-2.03493,1.11468,51.69645,-2.09785,1.29211,51.70712,-2.23675,1.46217,51.69931,-2.31771,1.43764,51.64563,-2.3732,2.44893,51.05346,-2.55346,2.42771,50.98717,-2.55632,2.00184,51.34422,-2.58984,3.46316,48.63703,.62889,3.15434,48.61364,.91617,3.08357,48.6114,.87244,3.51909,48.64762,.65296,3.97074,48.79776,-.03709,3.82785,48.71773,.34519,3.78403,48.69747,.32242,3.99484,48.82342,-.03341,4.10337,49.03765,-.62023,4.08513,48.96479,-.34128,4.07598,48.92878,-.36305,4.11935,49.07016,-.59162,2.32493,48.7315,1.31398,2.57298,48.76872,1.1668,2.28739,48.79375,1.3071,3.77255,49.02016,-.02325,3.61023,48.8857,.31655,3.83982,48.96115,-.02759,3.51665,49.18164,-.03222,3.67668,49.25286,-.31405,3.55844,49.31067,-.32916,2.99905,50.48431,-1.7546,3.18748,50.2149,-1.53114,3.29847,50.22766,-1.5973,3.58301,49.9543,-1.41923,3.48653,50.16559,-1.79309,3.39734,50.22449,-1.6704,3.68804,49.93658,-1.58251,2.45047,51.00596,-2.37035,1.10128,51.43469,-2.14833,1.05072,51.4775,-2.11394,1.33423,51.43269,-1.94092,1.28551,51.36623,-2.06266,1.13867,51.37705,-1.95983,3.1169,50.37012,-1.92578,2.70526,50.78481,-2.01327,2.76334,50.72297,-2.13176,3.00202,50.43296,-1.75848,1.89523,48.71922,1.29467,2.17313,48.74674,1.16267,2.52059,48.67094,1.07084,2.36332,48.58745,1.29942,2.25998,48.64999,1.21202,2.639,48.59835,1.12254,2.93006,48.71189,.84816,2.45178,50.99497,-2.2869,2.04505,51.24678,-2.35645,1.79211,51.38366,-2.1616};
			return value;
		}
		private double[] getlrib2_Coord_7_45_point_3()
		{
			double[] value = {1.74278,51.32951,-2.30032,.71417,51.32653,-1.78144,.6023,51.36957,-1.78253,.66907,51.41175,-1.81065,.63538,51.26029,-1.72157,1.22408,51.41475,-2.3166,1.25464,51.48085,-2.39434,1.29241,51.43812,-2.38965,1.19145,51.47036,-2.30064,1.70333,51.35249,-2.41167,3.90456,49.60271,-1.47335,3.72493,49.79058,-1.67812,2.85811,50.857,-2.25874,2.46545,51.11035,-2.52407,2.49035,51.18697,-2.42286,3.34754,48.83357,.65639,2.39543,48.59624,1.3175,2.07362,48.66628,1.45437,3.40062,49.03802,.316,3.94823,49.62851,-1.45992,3.7504,49.8478,-1.6695,1.78694,51.49206,-2.14453,1.51527,51.67112,-2.18644,1.55815,51.56828,-2.0514,1.74123,51.61978,-2.25706,1.34121,51.71198,-2.11189,.49803,51.42615,-1.56944,.49915,51.43648,-1.53945,.58491,51.50198,-1.77362,.64764,51.52367,-1.78024,.49132,51.40083,-1.49148,.49393,51.42705,-1.50614,1.85091,48.94823,1.28806,3.33503,49.00352,.2765,3.4893,49.42694,-.59669,3.54128,49.44671,-.57608,3.17478,50.18319,-1.53805,.59963,51.36913,-1.30825,.86679,51.50384,-1.62004,.89604,51.39375,-1.65622,1.76233,48.74485,1.53291,2.68106,48.60295,1.17829,1.90678,48.5774,1.41293,1.8066,48.56135,1.44424,1.98096,48.65561,1.50371,1.74406,48.81499,1.38886,1.73124,48.54217,1.47609,1.7234,48.55259,1.48796,1.66098,48.64701,1.38367,.54948,51.21004,-1.58905,.58245,51.17924,-1.60749,.5712,51.14991,-1.46903,.54848,51.19735,-1.47648,.51618,51.25816,-1.48627,.50818,51.3097,-1.42732,.79513,51.36092,-1.83714,.8534,51.31121,-1.77309,1.00339,51.34881,-1.85575,.5874,51.20192,-1.3318,.62192,51.25192,-1.40367,.61836,51.58402,-1.69003,.56103,51.21708,-1.34487,.60832,51.24679,-1.70675,1.26292,51.36169,-2.19127,1.34525,51.35583,-2.10731,1.1296,51.46852,-2.20693,1.16488,51.41268,-2.23593,1.23095,51.69942,-2.20342,1.38713,51.42757,-1.96707,1.43962,51.42378,-1.99313,.73052,51.49912,-1.83749,.74573,51.45049,-1.86007,1.79508,48.65967,1.46242,1.75985,48.72096,1.41935,3.79754,49.75777,-1.3374,3.86104,49.72093,-1.37356,3.52903,48.84695,.28802,3.63464,48.7996,.30968,3.28023,48.75376,.61039,3.21987,48.79536,.59611,2.85728,48.76105,.83004,2.44073,48.76007,1.0532,.71523,51.54766,-1.81489,3.51323,50.10162,-1.90466,2.02891,51.42248,-2.55983,1.14981,51.60803,-1.82751,.99377,51.59826,-1.72492,1.68443,51.57781,-2.49494,1.8239,48.65588,1.48147,3.71897,48.95207,-.06871,3.80337,48.90731,-.05856,3.82447,49.06174,-.33832,3.9095,49.02974,-.3447,3.80403,49.50461,-1.11837,3.91479,49.47176,-1.14556,2.79546,50.70937,-2.19859,3.16003,50.35903,-1.99348,3.43596,50.06565,-1.77352,3.37176,50.09175,-1.71584,3.84326,49.30162,-.56677};
			return value;
		}
		private double[] getlrib2_Coord_7_45_point_4()
		{
			double[] value = {3.85199,49.15451,-.30539,3.69566,49.37494,-.56828,3.17801,50.50172,-1.87886,3.76792,49.61729,-1.0306,3.63913,49.53856,-.81904,3.82136,49.46517,-.81994,3.58795,49.66543,-.99826,1.99751,48.60481,1.37563,1.37568,51.58979,-1.95209,1.3297,51.5959,-1.92511,1.49177,51.42133,-2.01911,1.17514,51.69614,-2.15058,1.28965,51.70825,-2.08137,1.23773,51.706,-2.05077,1.18195,51.51991,-2.29562,1.12261,51.51389,-2.20672,1.21444,51.38215,-2.23129,1.27044,51.38202,-2.2946,1.04745,51.51756,-2.11849,.51303,51.47358,-1.60279,.56357,51.49231,-1.75306,.58508,51.25721,-1.6954,.58191,51.36232,-1.76221,.58129,51.38506,-1.31943,.51107,51.26635,-1.56534,.54392,51.28095,-1.65348,.51346,51.30922,-1.60888,.51521,51.3631,-1.64995,.50863,51.43421,-1.65488,.502,51.42131,-1.43711,.53778,51.46724,-1.7093,.55046,51.36335,-1.71425,.53306,51.25798,-1.37906,.53084,51.41045,-1.38934,.93457,51.64732,-1.81608,1.08299,51.67531,-1.94077,.88172,51.64873,-1.90254,.85695,51.57334,-1.93983,1.66034,48.91836,1.3699,1.68105,48.92856,1.40254,1.71706,48.87924,1.46379,1.79287,48.54283,1.5652,1.7821,48.59387,1.47816,1.8572,48.59254,1.52603,1.75411,48.92178,1.29103,1.70689,48.92867,1.3442,1.77738,48.9401,1.314,1.68596,48.90655,1.31851,1.73784,48.89437,1.27796,1.6722,48.87523,1.30292,1.80793,48.9493,1.34693,1.77164,48.89491,1.43102,1.85013,48.90496,1.39575,1.73524,48.94155,1.38006,2.01784,48.79294,1.41787,1.92043,48.78688,1.46655,1.80136,48.70152,1.32194,1.71401,48.66958,1.35373,.84807,51.55706,-1.60561,1.2834,51.6028,-1.89806,1.56344,51.40977,-2.05805,2.72216,50.83414,-1.98803,3.48284,49.28281,-.3583,3.44694,49.15046,-.07025,2.35149,48.91086,1.05712,2.40999,48.9337,1.08505,1.18511,51.70512,-2.02009,1.42134,51.58461,-1.97899,2.06488,51.47941,-2.30938,2.05067,51.47783,-2.46861,2.49493,51.19023,-2.25939,1.69519,51.64404,-2.40821,2.81122,50.6673,-2.39978,3.23044,50.30079,-2.14558,3.50454,50.03413,-1.90789,4.08102,49.39505,-1.21224,4.10995,49.4264,-1.21163,4.14367,49.24332,-.93363,4.12018,49.22424,-.96002,2.99844,48.79875,.91448,3.94568,49.07623,-.31632,2.80188,50.90006,-2.09789,3.23161,50.46072,-2.01375,4.01424,49.49557,-1.11551,3.67923,49.78957,-1.2351,3.44828,49.98074,-1.37296,3.51697,49.84029,-1.21514,3.9296,49.54447,-1.08034,3.87961,49.33968,-.91131,3.88297,49.18154,-.58758,3.96281,49.14075,-.58942,3.95987,49.30187,-.91555};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib3_Geo_6_50_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,5,6,3,-1,7,8,9,-1,10,11,12,-1,13,14,15,-1,15,16,17,-1,17,13,15,-1,18,19,20,-1,19,21,20,-1,22,23,19,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,28,31,29,-1,32,33,34,-1,34,35,32,-1,36,37,38,-1,37,39,38,-1,40,41,42,-1,41,43,42,-1,44,45,46,-1,47,37,36,-1,36,48,47,-1,49,50,51,-1,50,52,51,-1,53,54,55,-1,53,56,54,-1,57,58,59,-1,59,60,57,-1,61,62,46,-1,46,63,61,-1,64,65,66,-1,67,66,68,-1,44,66,69,-1,6,70,71,-1,71,3,6,-1,72,23,22,-1,73,74,75,-1,75,76,73,-1,77,27,24,-1,24,78,77,-1,79,80,81,-1,81,82,79,-1,79,83,84,-1,85,86,87,-1,85,88,86,-1,89,87,90,-1,90,91,89,-1,92,93,94,-1,95,96,97,-1,98,99,100,-1,98,101,99,-1,102,103,104,-1,102,105,103,-1,96,106,107,-1,96,108,106,-1,102,109,110,-1,102,53,109,-1,111,23,112,-1,112,113,111,-1,114,115,116,-1,116,117,114,-1,118,119,120,-1,118,121,119,-1,122,123,124,-1,123,125,124,-1,7,126,127,-1,128,129,130,-1,128,131,129,-1,132,133,134,-1,134,135,132,-1,136,137,138,-1,138,139,136,-1,140,141,142,-1,142,143,140,-1,144,145,146,-1,146,147,144,-1,148,149,150,-1,150,151,148,-1,150,152,153,-1,150,149,152,-1,154,153,152,-1,154,155,153,-1,156,157,158,-1,159,160,161,-1,161,162,159,-1,163,164,165,-1,163,166,164,-1,167,168,169,-1,170,171,172,-1,170,173,171,-1,174,175,176,-1,174,177,175,-1,178,179,176,-1,176,21,178,-1,180,181,182,-1,181,183,182,-1,103,184,185,-1,103,186,184,-1,99,187,100,-1,187,188,100,-1,189,190,191,-1,192,193,194,-1,195,196,197,-1,198,199,200,-1,201,116,121,-1,121,202,201,-1,190,203,204,-1,205,206,207,-1,206,208,207,-1,194,209,202,-1,210,211,190,-1,212,153,213,-1,212,150,153,-1,211,214,190,-1,215,180,216,-1,215,217,180,-1,218,219,220,-1,218,221,219,-1,222,223,224,-1,224,225,222,-1,226,120,119,-1,119,227,226,-1,228,229,220,-1,220,219,228,-1,230,231,232,-1,231,197,232,-1,233,200,117,-1,200,234,117,-1,206,235,236,-1,206,205,235,-1,134,133,237,-1,133,238,237,-1,78,239,240,-1,240,77,78,-1,241,242,243,-1,243,244,241,-1,245,246,247,-1,246,248,247,-1,10,249,250,-1,10,12,249,-1,251,172,171,-1,177,29,26,-1,26,25,177,-1,252,253,254,-1,254,255,252,-1,256,257,258,-1,258,259,256,-1,13,260,14,-1,261,262,250,-1,262,263,250,-1,264,132,135,-1,135,265,264,-1,266,140,143,-1,238,267,237,-1,268,269,143,-1,268,270,269,-1,271,245,272,-1,271,246,245,-1,126,273,274,-1,126,248,273,-1,273,275,274,-1,275,276,274,-1,277,278,279,-1,278,280,279,-1,274,276,281,-1,276,282,281,-1,283,284,280,-1,283,285,284,-1,286,287,285,-1,285,283,286,-1,288,289,290,-1,288,291,289,-1,254,292,293,-1,254,170,292,-1,289,32,290,-1,32,294,290,-1,2,295,0,-1,295,252,0,-1,167,169,49,-1,173,170,296,-1,297,298,1,-1,1,0,297,-1,48,50,299,-1,50,300,299,-1,301,5,28,-1,28,83,301,-1,300,63,299,-1,300,61,63,-1,66,44,64,-1,302,295,303,-1,303,73,302,-1,23,178,21,-1,21,19,23,-1,48,299,304,-1,304,47,48,-1,305,306,307,-1,306,308,307,-1,111,91,90,-1,111,113,91,-1,309,310,95,-1,104,185,311,-1,104,103,185,-1,312,182,313,-1,312,314,182,-1,315,316,317,-1,203,190,318,-1,319,190,320,-1,321,190,322,-1,214,322,190,-1,189,320,190,-1,323,324,236,-1,324,325,236,-1,217,215,311,-1,311,326,217,-1,223,187,99,-1,99,224,223,-1,81,327,328,-1,327,86,328,-1,329,94,91,-1,91,113,329,-1,112,330,306,-1,306,305,112,-1,331,332,39,-1,332,38,39,-1,178,23,111,-1,111,333,178,-1,19,18,22,-1,18,334,22,-1,30,84,83,-1,30,174,84,-1,71,335,336,-1,71,70,335,-1,337,306,298,-1,337,308,306,-1,32,35,297,-1,294,0,255,-1,0,252,255,-1,251,167,172,-1,251,168,167,-1,290,294,255,-1,338,339,340,-1,338,341,339,-1,241,291,342,-1,343,288,259,-1,288,256,259,-1,344,340,345,-1,344,338,340,-1,283,278,345,-1};
			return value;
		}
		private int[] getlrib3_Geo_6_50_coordIndex_2()
		{
			int[] value = {283,280,278,-1,344,346,347,-1,344,348,346,-1,276,275,349,-1,349,342,276,-1,350,351,352,-1,350,353,351,-1,279,284,354,-1,279,280,284,-1,355,356,9,-1,355,357,356,-1,7,247,248,-1,248,126,7,-1,272,358,359,-1,272,245,358,-1,360,361,362,-1,363,277,268,-1,277,270,268,-1,364,268,143,-1,143,142,364,-1,365,353,350,-1,365,366,353,-1,367,368,369,-1,367,370,368,-1,371,372,151,-1,372,148,151,-1,28,4,31,-1,28,5,4,-1,259,258,352,-1,352,351,259,-1,190,321,373,-1,169,61,300,-1,69,67,58,-1,58,57,69,-1,60,3,71,-1,60,374,3,-1,60,59,374,-1,354,273,248,-1,248,246,354,-1,332,331,375,-1,331,376,375,-1,95,310,377,-1,310,378,377,-1,1,72,2,-1,1,330,72,-1,257,293,379,-1,293,292,379,-1,352,258,346,-1,258,347,346,-1,380,365,142,-1,365,364,142,-1,138,372,129,-1,138,381,372,-1,382,383,384,-1,385,386,387,-1,387,388,385,-1,235,323,236,-1,235,389,323,-1,390,183,384,-1,384,391,390,-1,54,215,216,-1,54,56,215,-1,217,181,180,-1,217,392,181,-1,230,386,382,-1,230,232,386,-1,393,394,395,-1,395,325,393,-1,396,397,17,-1,191,190,204,-1,398,119,115,-1,398,227,119,-1,206,395,208,-1,395,399,208,-1,100,188,399,-1,400,202,209,-1,400,201,202,-1,389,401,114,-1,190,373,318,-1,234,402,389,-1,401,389,235,-1,398,401,403,-1,404,387,386,-1,198,405,318,-1,123,192,118,-1,192,194,118,-1,190,319,210,-1,406,407,387,-1,408,391,409,-1,408,221,391,-1,180,182,314,-1,314,216,180,-1,20,21,176,-1,176,175,20,-1,25,410,175,-1,175,177,25,-1,240,173,296,-1,296,411,240,-1,293,412,255,-1,255,254,293,-1,295,302,253,-1,253,252,295,-1,413,12,414,-1,413,249,12,-1,249,413,415,-1,415,416,249,-1,417,165,418,-1,165,164,418,-1,260,419,14,-1,260,420,419,-1,421,422,423,-1,421,424,422,-1,425,416,415,-1,425,426,416,-1,427,160,159,-1,427,428,160,-1,166,425,423,-1,423,422,166,-1,16,212,396,-1,16,429,212,-1,430,162,161,-1,430,431,162,-1,432,263,262,-1,432,433,263,-1,434,435,436,-1,436,437,434,-1,438,381,439,-1,438,440,381,-1,441,155,154,-1,441,442,155,-1,443,359,444,-1,140,238,141,-1,140,144,238,-1,445,264,265,-1,445,446,264,-1,447,370,367,-1,448,449,450,-1,450,451,448,-1,7,127,452,-1,452,8,7,-1,385,388,315,-1,388,316,315,-1,120,123,118,-1,120,125,123,-1,121,116,115,-1,115,119,121,-1,114,117,234,-1,234,389,114,-1,382,386,385,-1,453,454,110,-1,110,109,453,-1,79,82,455,-1,329,112,305,-1,329,113,112,-1,108,377,55,-1,377,456,55,-1,85,100,394,-1,85,98,100,-1,88,394,393,-1,88,85,394,-1,457,458,459,-1,82,81,328,-1,328,460,82,-1,73,303,74,-1,303,334,74,-1,18,20,461,-1,374,59,462,-1,462,239,374,-1,66,67,69,-1,65,68,66,-1,58,462,59,-1,58,463,462,-1,109,53,464,-1,45,63,46,-1,45,465,63,-1,456,378,466,-1,456,377,378,-1,42,51,40,-1,51,467,40,-1,37,466,39,-1,466,378,39,-1,54,216,106,-1,307,375,376,-1,307,308,375,-1,24,26,468,-1,29,31,468,-1,468,26,29,-1,83,28,30,-1,16,396,17,-1,421,414,427,-1,9,448,355,-1,9,8,448,-1,368,469,369,-1,368,380,469,-1,366,281,353,-1,366,470,281,-1,349,287,242,-1,349,285,287,-1,301,6,5,-1,342,242,241,-1,342,349,242,-1,457,301,455,-1,457,6,301,-1,43,340,339,-1,286,340,43,-1,368,470,366,-1,368,370,470,-1,281,351,353,-1,281,282,351,-1,451,355,448,-1,355,451,471,-1,472,424,473,-1,472,422,424,-1,474,421,423,-1,474,475,421,-1,410,74,461,-1,75,74,410,-1,375,337,476,-1,308,337,375,-1,477,376,309,-1,477,307,376,-1,478,479,480,-1,479,478,97,-1,312,481,482,-1,225,481,312,-1,96,377,108,-1,377,96,95,-1,106,55,54,-1,55,106,108,-1,51,483,467,-1,51,52,483,-1,299,465,336,-1,299,63,465,-1,456,484,464,-1,484,456,466,-1,464,453,109,-1,453,464,484,-1,67,463,58,-1,67,68,463,-1,61,168,62,-1,61,169,168,-1,460,485,186,-1,460,328,485,-1,82,105,458,-1,82,460,105,-1,393,485,88,-1,485,393,486,-1,478,95,97,-1,478,487,95,-1,225,488,481,-1};
			return value;
		}
		private int[] getlrib3_Geo_6_50_coordIndex_3()
		{
			int[] value = {488,225,224,-1,477,94,329,-1,477,480,94,-1,331,378,310,-1,378,331,39,-1,80,327,81,-1,80,333,327,-1,459,110,454,-1,459,458,110,-1,234,199,402,-1,234,200,199,-1,383,391,384,-1,383,409,391,-1,489,388,490,-1,489,316,388,-1,8,449,448,-1,8,452,449,-1,451,491,492,-1,451,450,491,-1,493,494,495,-1,493,496,494,-1,496,497,492,-1,437,497,496,-1,11,493,498,-1,11,434,493,-1,264,447,367,-1,446,447,264,-1,445,499,500,-1,445,265,499,-1,501,502,503,-1,504,502,501,-1,504,494,502,-1,504,495,494,-1,505,438,506,-1,505,440,438,-1,238,147,267,-1,144,147,238,-1,507,444,362,-1,507,443,444,-1,361,508,509,-1,508,361,510,-1,441,157,511,-1,441,154,157,-1,512,146,513,-1,512,156,146,-1,509,511,512,-1,509,508,511,-1,381,137,439,-1,137,381,138,-1,135,499,265,-1,135,136,499,-1,438,237,267,-1,438,439,237,-1,491,502,494,-1,500,502,491,-1,514,433,515,-1,514,436,433,-1,360,510,361,-1,360,432,510,-1,433,435,263,-1,433,436,435,-1,432,516,510,-1,432,262,516,-1,151,212,429,-1,151,150,212,-1,128,430,517,-1,128,420,430,-1,425,163,426,-1,166,163,425,-1,498,160,428,-1,498,518,160,-1,519,416,426,-1,519,261,416,-1,474,425,415,-1,423,425,474,-1,475,414,421,-1,414,475,413,-1,430,260,431,-1,430,420,260,-1,17,418,520,-1,418,17,397,-1,153,417,213,-1,155,417,153,-1,521,14,419,-1,521,15,14,-1,213,396,212,-1,213,397,396,-1,414,428,427,-1,12,428,414,-1,292,172,341,-1,292,170,172,-1,77,411,76,-1,77,240,411,-1,80,84,179,-1,80,79,84,-1,461,175,410,-1,461,20,175,-1,314,106,216,-1,107,106,314,-1,522,523,524,-1,522,226,523,-1,525,228,526,-1,229,228,525,-1,225,313,222,-1,225,312,313,-1,391,218,390,-1,221,218,391,-1,317,408,409,-1,527,408,317,-1,490,387,407,-1,490,388,387,-1,210,406,387,-1,319,406,210,-1,406,320,528,-1,406,319,320,-1,191,209,194,-1,209,191,204,-1,405,203,318,-1,405,400,203,-1,318,199,198,-1,199,318,373,-1,232,404,386,-1,529,404,232,-1,227,403,530,-1,227,398,403,-1,531,524,532,-1,531,522,524,-1,315,409,383,-1,315,317,409,-1,403,235,205,-1,403,401,235,-1,523,207,526,-1,523,530,207,-1,408,219,221,-1,408,532,219,-1,486,533,184,-1,533,486,324,-1,402,323,389,-1,402,534,323,-1,114,398,115,-1,401,398,114,-1,201,117,116,-1,233,117,201,-1,98,87,89,-1,85,87,98,-1,394,399,395,-1,100,399,394,-1,199,321,195,-1,199,373,321,-1,407,528,535,-1,407,406,528,-1,404,214,211,-1,214,404,529,-1,87,327,90,-1,87,86,327,-1,392,382,181,-1,392,230,382,-1,122,407,535,-1,490,407,122,-1,325,206,236,-1,325,395,206,-1,399,525,208,-1,188,525,399,-1,534,536,537,-1,534,402,536,-1,230,538,231,-1,392,538,230,-1,122,192,123,-1,192,122,535,-1,371,129,372,-1,371,130,129,-1,380,141,469,-1,380,142,141,-1,365,539,364,-1,365,350,539,-1,258,379,347,-1,258,257,379,-1,346,350,352,-1,350,346,539,-1,302,296,253,-1,296,302,411,-1,70,454,335,-1,70,459,454,-1,476,540,541,-1,476,34,540,-1,540,33,542,-1,540,34,33,-1,285,275,284,-1,275,285,349,-1,356,543,358,-1,543,356,357,-1,515,544,514,-1,515,545,544,-1,250,435,10,-1,250,263,435,-1,419,128,130,-1,420,128,419,-1,155,165,417,-1,165,155,442,-1,428,11,498,-1,12,11,428,-1,475,415,413,-1,474,415,475,-1,166,472,164,-1,166,422,472,-1,336,304,299,-1,336,335,304,-1,45,69,57,-1,45,44,69,-1,463,65,546,-1,68,65,463,-1,537,533,534,-1,537,547,533,-1,72,295,2,-1,295,72,303,-1,4,468,31,-1,4,548,468,-1,162,549,473,-1,162,431,549,-1,550,441,551,-1,442,441,550,-1,517,131,128,-1,517,501,131,-1,264,369,132,-1,369,264,367,-1,380,366,365,-1,366,380,368,-1,539,268,364,-1,268,539,363,-1,511,551,441,-1,511,508,551,-1,552,266,553,-1,266,552,145,-1,277,271,270,-1,271,277,279,-1,272,553,269,-1,359,553,272,-1,513,443,507,-1,443,513,552,-1,360,545,515,-1,362,545,360,-1,358,444,359,-1,358,543,444,-1,247,9,356,-1,7,9,247,-1,471,357,355,-1,471,544,357,-1,500,450,445,-1,500,491,450,-1,452,446,449,-1};
			return value;
		}
		private int[] getlrib3_Geo_6_50_coordIndex_4()
		{
			int[] value = {452,447,446,-1,127,470,370,-1,126,470,127,-1,346,363,539,-1,346,348,363,-1,282,259,351,-1,282,343,259,-1,344,278,348,-1,345,278,344,-1,344,379,338,-1,347,379,344,-1,342,288,343,-1,342,291,288,-1,41,286,43,-1,41,287,286,-1,292,338,379,-1,292,341,338,-1,243,287,41,-1,287,243,242,-1,339,42,43,-1,339,167,42,-1,297,294,32,-1,297,0,294,-1,306,1,298,-1,306,330,1,-1,483,332,541,-1,483,38,332,-1,3,548,4,-1,3,374,548,-1,6,459,70,-1,6,457,459,-1,30,177,174,-1,177,30,29,-1,95,478,309,-1,95,487,478,-1,104,215,56,-1,104,311,215,-1,93,488,101,-1,93,92,488,-1,325,486,393,-1,324,486,325,-1,390,182,183,-1,390,313,182,-1,538,547,537,-1,538,326,547,-1,392,326,538,-1,392,217,326,-1,522,124,125,-1,522,531,124,-1,326,185,547,-1,185,326,311,-1,97,107,482,-1,97,96,107,-1,484,304,453,-1,484,47,304,-1,335,453,304,-1,335,454,453,-1,462,171,239,-1,171,462,251,-1,168,546,62,-1,546,168,251,-1,78,374,239,-1,78,548,374,-1,169,50,49,-1,169,300,50,-1,467,541,540,-1,467,483,541,-1,297,337,298,-1,35,337,297,-1,40,540,542,-1,40,467,540,-1,244,32,289,-1,244,33,32,-1,412,290,255,-1,290,412,554,-1,341,167,339,-1,341,172,167,-1,542,41,40,-1,41,542,243,-1,241,289,291,-1,244,289,241,-1,256,554,412,-1,256,290,554,-1,288,290,256,-1,276,343,282,-1,276,342,343,-1,348,277,363,-1,348,278,277,-1,281,126,274,-1,126,281,470,-1,447,127,370,-1,127,447,452,-1,449,445,450,-1,446,445,449,-1,497,544,471,-1,544,497,514,-1,279,246,271,-1,279,354,246,-1,362,543,545,-1,444,543,362,-1,359,552,553,-1,359,443,552,-1,269,271,272,-1,269,270,271,-1,143,553,266,-1,143,269,553,-1,145,513,146,-1,145,552,513,-1,381,148,372,-1,381,440,148,-1,140,145,144,-1,145,140,266,-1,503,131,501,-1,131,503,139,-1,518,504,555,-1,495,504,518,-1,516,550,551,-1,550,516,519,-1,434,10,435,-1,10,434,11,-1,421,159,424,-1,421,427,159,-1,112,72,330,-1,112,23,72,-1,257,412,293,-1,256,412,257,-1,547,184,533,-1,547,185,184,-1,462,546,251,-1,463,546,462,-1,336,60,71,-1,465,60,336,-1,520,164,472,-1,520,418,164,-1,521,130,371,-1,521,419,130,-1,550,165,442,-1,550,163,165,-1,371,429,521,-1,151,429,371,-1,160,555,161,-1,160,518,555,-1,357,545,543,-1,544,545,357,-1,416,250,249,-1,250,416,261,-1,284,273,354,-1,273,284,275,-1,358,247,356,-1,358,245,247,-1,375,541,332,-1,375,476,541,-1,243,33,244,-1,243,542,33,-1,171,240,239,-1,240,171,173,-1,170,253,296,-1,254,253,170,-1,469,238,133,-1,469,141,238,-1,187,220,229,-1,187,223,220,-1,536,197,231,-1,536,195,197,-1,402,195,536,-1,402,199,195,-1,231,537,536,-1,538,537,231,-1,208,526,207,-1,525,526,208,-1,194,121,118,-1,194,202,121,-1,479,488,92,-1,479,481,488,-1,223,218,220,-1,222,218,223,-1,531,489,124,-1,527,489,531,-1,214,196,322,-1,214,529,196,-1,211,387,404,-1,211,210,387,-1,535,193,192,-1,528,193,535,-1,405,200,233,-1,200,405,198,-1,195,322,196,-1,321,322,195,-1,400,233,201,-1,400,405,233,-1,534,324,323,-1,534,533,324,-1,385,383,382,-1,315,383,385,-1,228,532,524,-1,228,219,532,-1,530,205,207,-1,530,403,205,-1,532,527,531,-1,408,527,532,-1,226,530,523,-1,226,227,530,-1,197,529,232,-1,196,529,197,-1,204,400,209,-1,400,204,203,-1,528,189,193,-1,528,320,189,-1,193,191,194,-1,193,189,191,-1,527,316,489,-1,527,317,316,-1,222,390,218,-1,222,313,390,-1,101,89,93,-1,101,98,89,-1,188,229,525,-1,187,229,188,-1,524,526,228,-1,524,523,526,-1,226,125,120,-1,522,125,226,-1,384,181,382,-1,181,384,183,-1,302,76,411,-1,302,73,76,-1,179,333,80,-1,178,333,179,-1,176,84,174,-1,84,176,179,-1,429,15,521,-1,429,16,15,-1,473,159,162,-1,473,424,159,-1,213,418,397,-1,417,418,213,-1,431,13,549,-1,431,260,13,-1,517,161,555,-1,161,517,430,-1,426,550,519,-1,163,550,426,-1,515,432,360,-1,515,433,432,-1,437,514,497,-1,437,436,514,-1,507,512,513,-1,507,509,512,-1,439,134,237,-1,439,137,134,-1};
			return value;
		}
		private int[] getlrib3_Geo_6_50_coordIndex_5()
		{
			int[] value = {499,139,503,-1,136,139,499,-1,262,519,516,-1,519,262,261,-1,511,156,512,-1,511,157,156,-1,158,154,152,-1,157,154,158,-1,505,152,149,-1,505,158,152,-1,158,506,156,-1,506,158,505,-1,156,147,146,-1,506,147,156,-1,510,551,508,-1,551,510,516,-1,362,509,507,-1,509,362,361,-1,267,506,438,-1,147,506,267,-1,149,440,505,-1,149,148,440,-1,138,131,139,-1,131,138,129,-1,134,136,135,-1,136,134,137,-1,133,369,469,-1,132,369,133,-1,555,501,517,-1,555,504,501,-1,500,503,502,-1,500,499,503,-1,434,496,493,-1,434,437,496,-1,495,498,493,-1,498,495,518,-1,494,492,491,-1,496,492,494,-1,490,124,489,-1,490,122,124,-1,333,90,327,-1,333,111,90,-1,310,376,331,-1,310,309,376,-1,458,102,110,-1,105,102,458,-1,56,102,104,-1,56,53,102,-1,101,224,99,-1,101,488,224,-1,482,314,312,-1,482,107,314,-1,92,480,479,-1,480,92,94,-1,94,89,91,-1,93,89,94,-1,186,486,184,-1,186,485,486,-1,88,328,86,-1,88,485,328,-1,105,186,103,-1,460,186,105,-1,24,548,78,-1,548,24,468,-1,76,27,77,-1,76,75,27,-1,455,83,79,-1,455,301,83,-1,65,62,546,-1,65,64,62,-1,64,46,62,-1,64,44,46,-1,465,57,60,-1,465,45,57,-1,51,167,49,-1,167,51,42,-1,50,36,52,-1,50,48,36,-1,466,47,484,-1,47,466,37,-1,55,464,53,-1,464,55,456,-1,52,38,483,-1,52,36,38,-1,307,329,305,-1,477,329,307,-1,482,479,97,-1,481,479,482,-1,480,309,478,-1,480,477,309,-1,476,35,34,-1,337,35,476,-1,75,25,27,-1,75,410,25,-1,334,461,74,-1,18,461,334,-1,72,334,303,-1,72,22,334,-1,473,520,472,-1,473,549,520,-1,549,17,520,-1,17,549,13,-1,492,471,451,-1,471,492,497,-1,340,283,345,-1,283,340,286,-1,458,455,82,-1,458,457,455,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib3_Coord_7_50_point_1()
		{
			double[] value = {1.53908,50.50462,-2.59644,1.40673,50.5821,-2.54527,1.37309,50.59636,-2.59399,1.2066,50.80223,-2.54978,1.18455,50.79914,-2.58903,1.1164,50.739,-2.51775,1.11058,50.75646,-2.45022,4.23968,48.267,-.26948,3.9368,48.14059,.15587,3.91815,48.16634,.17325,1.91074,47.86226,1.78239,1.92337,47.79059,1.77123,1.88656,47.78363,1.81957,2.11,47.23192,1.99804,2.05134,47.09105,2.09063,2.06461,47.09087,2.10965,2.08145,47.11742,2.12161,2.13857,47.24365,2.02969,1.16991,50.66552,-2.723,1.14295,50.60612,-2.62816,1.13725,50.6848,-2.72082,1.10722,50.64272,-2.63179,1.15314,50.60169,-2.6256,1.09832,50.53904,-2.52471,1.24215,50.80133,-2.69285,1.22303,50.7569,-2.73548,1.21113,50.79763,-2.68783,1.24244,50.75778,-2.73302,1.10274,50.73768,-2.55819,1.1477,50.78949,-2.63692,1.10138,50.73638,-2.57159,1.15604,50.79437,-2.62348,1.97059,50.53549,-2.51195,1.97932,50.6141,-2.48624,1.66922,50.68825,-2.41879,1.63166,50.62631,-2.46148,1.39372,50.85583,-2.35291,1.21307,50.86773,-2.28433,1.3858,50.8446,-2.33124,1.21543,50.86142,-2.26864,1.97142,50.71221,-2.50069,2.10178,50.66688,-2.51908,1.9462,50.72566,-2.53724,2.08787,50.66832,-2.56464,1.34514,50.87399,-2.49962,1.30939,50.88242,-2.47948,1.34154,50.88758,-2.4719,1.20572,50.85091,-2.30545,1.38226,50.84661,-2.3704,1.63428,50.78275,-2.48886,1.52172,50.82379,-2.42617,1.66121,50.78892,-2.46031,1.53537,50.82307,-2.40102,.91624,50.81123,-2.16692,.84046,50.82276,-2.08236,.94749,50.8351,-2.13441,.82046,50.81351,-2.11081,1.25709,50.86604,-2.51426,1.27754,50.84983,-2.57593,1.26689,50.84206,-2.58154,1.24836,50.86114,-2.50977,1.471,50.85745,-2.50966,1.4632,50.85735,-2.5176,1.3404,50.88585,-2.45881,1.41732,50.85379,-2.53478,1.43064,50.81395,-2.5765,1.37429,50.84241,-2.55692,1.31731,50.84902,-2.56724,1.38599,50.81337,-2.59009,1.31199,50.86403,-2.53404,1.13427,50.8017,-2.42556,1.22446,50.82842,-2.4907,1.19163,50.59309,-2.59891,1.2584,50.68579,-2.72307,1.20945,50.69,-2.74525,1.23829,50.70932,-2.75053,1.27481,50.70391,-2.74168,1.31266,50.75231,-2.70541,1.28849,50.79148,-2.66367,1.00874,50.64399,-2.44999,1.00321,50.62421,-2.45015,.94425,50.68082,-2.34246,.95315,50.70145,-2.33682,1.06096,50.66441,-2.50737,1.04703,50.63843,-2.52154,.85049,50.61166,-2.21039,.92249,50.64783,-2.2806,.93971,50.61688,-2.26742,.83444,50.64323,-2.21612,.96284,50.61875,-2.23195,1.0026,50.58829,-2.35593,1.0484,50.57447,-2.31735,.96983,50.67163,-2.18466,.96857,50.6627,-2.19206,1.06215,50.66441,-2.24646,1.05467,50.83655,-2.16945,.95635,50.82542,-2.119,.95793,50.81434,-2.12377,.8659,50.61769,-2.17876,.77153,50.63555,-2.10414};
			return value;
		}
		private double[] getlrib3_Coord_7_50_point_2()
		{
			double[] value = {.76446,50.61748,-2.1291,.86842,50.65106,-2.14779,.90494,50.80732,-2.186,.80345,50.7638,-2.18981,.80741,50.81141,-2.13672,.89372,50.76573,-2.25319,.84973,50.82243,-2.07076,.85366,50.81545,-2.06825,.95182,50.8329,-2.12394,1.01373,50.81139,-2.2272,1.00005,50.79861,-2.25202,1.04676,50.53106,-2.43976,1.13478,50.53255,-2.43566,1.08466,50.54565,-2.37511,.51665,50.57752,-2.0303,.51647,50.53525,-1.98354,.50263,50.5434,-1.97686,.50678,50.58574,-2.02101,.52833,50.51894,-1.88038,.53157,50.52923,-1.92814,.54737,50.52605,-1.88739,.51398,50.53004,-1.92137,.55091,50.5733,-1.82333,.53795,50.53459,-1.84166,.56697,50.57619,-1.84007,.55191,50.54263,-1.85916,4.37721,48.4334,-.74506,4.24755,48.2367,-.29541,2.0477,47.18854,1.98801,2.41035,47.22017,1.77862,2.09122,47.07582,2.05267,2.3772,47.34464,1.73412,3.86058,47.7819,.39757,3.89572,47.72615,.41248,3.43244,47.55641,.89448,3.45702,47.65627,.86276,3.20276,47.58925,1.08935,3.1961,47.4793,1.11526,2.8692,47.37394,1.41397,2.84025,47.49451,1.38158,4.13306,47.88901,.20835,4.15418,47.82361,.18796,4.47661,48.01166,-.26314,4.45728,48.0714,-.22806,3.92382,47.81592,.45458,3.91246,47.87638,.47095,3.52164,47.75291,.897,3.49695,47.68717,.89614,2.43849,47.27179,1.80359,2.44576,47.31773,1.8003,2.14406,47.16005,2.10672,2.13678,47.12548,2.09456,2.45462,47.40742,1.79356,2.12722,47.26517,2.09491,2.45699,47.51539,1.77517,2.10806,47.39499,2.06381,3.26763,47.68944,1.13324,2.90886,47.62787,1.42531,2.90222,47.57226,1.43263,1.92614,47.62797,1.84915,1.90935,47.6304,1.83526,1.94831,47.38825,1.94869,1.95737,47.40155,1.95548,2.02241,47.66174,1.97105,2.05658,47.48426,2.02724,2.05889,47.48499,2.03851,2.01276,47.65987,1.94933,1.91394,50.70042,-2.63861,1.57157,50.79272,-2.5693,1.59993,50.79964,-2.53245,1.81126,50.53239,-2.78578,1.49301,50.71912,-2.68105,1.85368,50.60681,-2.74494,1.44645,50.68619,-2.68961,1.09458,50.71104,-2.59779,1.13348,50.7169,-2.70507,1.09385,50.67286,-2.62001,1.14335,50.75607,-2.678,1.0634,50.57543,-2.54136,1.04661,50.60796,-2.53504,.67998,50.80595,-1.98629,.6329,50.81296,-1.93677,.69458,50.7868,-1.97337,.64804,50.78836,-1.93021,.71831,50.72507,-2.15358,.71786,50.76065,-2.1272,.80936,50.71228,-2.21438,.68433,50.62967,-2.03166,.67436,50.61672,-2.05355,.50521,50.59291,-1.87078,.5044,50.63103,-1.89346,.50395,50.57838,-1.88291,.5189,50.55374,-1.83413,.5116,50.57131,-1.8526,.50949,50.54637,-1.87828,.51216,50.69156,-1.98219,.52474,50.74382,-1.94728,.52578,50.75327,-1.95342,.49413,50.60613,-1.98409,.50201,50.64615,-1.99378};
			return value;
		}
		private double[] getlrib3_Coord_7_50_point_3()
		{
			double[] value = {.49078,50.60066,-2.00563,.49441,50.56403,-1.96507,.50117,50.54966,-1.91335,.49647,50.59618,-1.92851,.49807,50.58465,-1.9057,.56198,50.5578,-2.01856,.6132,50.58164,-2.05247,.57485,50.55677,-2.00694,.62417,50.58551,-2.03815,.49956,50.55733,-1.9153,.52745,50.66888,-1.85594,.52497,50.69824,-1.87842,2.10023,47.15041,2.13713,2.08845,47.24717,2.116,.52509,50.71107,-1.90188,.73482,50.81657,-2.04934,.74784,50.81845,-2.02377,.66054,50.828,-2.00805,.65568,50.67977,-1.9597,.61739,50.62267,-1.92959,.64906,50.63661,-1.9871,.61456,50.67518,-1.91728,.69234,50.69177,-1.99374,.68419,50.65031,-2.0191,.77472,50.66176,-2.08199,.7682,50.71796,-2.05705,.55222,50.55874,-1.91904,.54171,50.53994,-1.96584,.60625,50.60144,-1.95714,.64602,50.61282,-2.00097,.57443,50.81274,-1.93015,.54747,50.78679,-1.99042,.54487,50.78137,-1.91459,.49281,50.58665,-1.98964,.50516,50.6061,-2.03511,.53163,50.58459,-2.04028,.59408,50.61167,-2.06338,3.44479,47.56241,.89803,3.9242,47.7347,.43772,1.34487,50.77956,-2.64092,1.40045,50.70862,-2.67963,2.36789,50.41545,-2.47656,2.37798,50.45731,-2.45669,2.10315,50.61123,-2.48879,2.09385,50.56558,-2.49595,4.21541,48.3258,-.20839,4.40127,48.48067,-.66548,4.20657,48.31588,-.23128,4.37237,48.47745,-.68468,1.8876,47.84688,1.83061,1.91271,47.87617,1.79781,1.54692,50.73563,-2.65575,1.48608,50.56095,-2.66081,1.45662,50.59119,-2.69389,1.81975,50.49752,-2.76306,1.84757,50.46965,-2.70906,2.32389,50.30201,-2.74137,2.30826,50.28369,-2.79407,2.94678,49.86648,-2.69003,2.93525,49.90953,-2.5719,2.01226,47.18244,2.04914,1.94327,47.86551,1.84298,2.30665,47.94498,1.59422,2.21755,47.98298,1.57018,3.85859,47.83578,.40049,3.44901,47.74034,.84015,4.12305,47.94391,.22542,3.48048,47.6253,.89309,4.66486,48.29946,-.80092,4.40218,48.20269,-.17705,4.60788,48.36406,-.74343,4.51203,48.45282,-.67949,4.29705,48.31002,-.14948,4.28341,48.75677,-1.22735,4.26526,48.71986,-1.24625,3.6471,49.42377,-1.88654,3.62103,49.3913,-1.94876,4.47389,48.67596,-1.33204,3.82532,49.3581,-2.03149,4.41081,48.73965,-1.24882,3.73456,49.4155,-1.93156,4.35343,48.59683,-1.36451,3.63538,49.30988,-2.07509,3.00673,50.0692,-2.3297,3.68431,49.43261,-1.88461,3.0012,50.06442,-2.26179,2.40977,50.47783,-2.52883,2.41229,50.48997,-2.48387,2.31959,50.2843,-2.66657,2.08561,50.48701,-2.52125,2.00343,50.41063,-2.66283,2.36445,50.33729,-2.48458,1.93782,50.48497,-2.81066,1.93529,50.45638,-2.79674,1.87713,50.4439,-2.64222,1.31408,50.64404,-2.66547,1.43882,50.63281,-2.71078,1.60971,50.59094,-2.48636,1.47744,50.61612,-2.43847,1.36549,50.85251,-2.40059};
			return value;
		}
		private double[] getlrib3_Coord_7_50_point_4()
		{
			double[] value = {1.49679,50.84053,-2.46553,1.08354,50.70474,-2.48099,1.3354,50.65886,-2.70097,1.23333,50.66815,-2.69889,1.19698,50.84111,-2.33373,1.17186,50.63147,-2.30687,1.34695,50.63255,-2.39227,1.18596,50.72312,-2.27636,1.36864,50.7004,-2.36019,1.12881,50.82273,-2.21183,1.13159,50.84197,-2.21251,.71514,50.81249,-2.08797,.76114,50.772,-2.03265,.69048,50.74189,-1.97614,.75664,50.80358,-2.0182,.59284,50.76026,-1.85322,.5888,50.69987,-1.83286,.58673,50.70233,-1.858,.49758,50.61653,-1.93798,.51688,50.63779,-1.85728,.507,50.60778,-1.8587,.51186,50.67616,-1.93297,.51612,50.69479,-1.92009,.56943,50.64719,-2.07708,.63538,50.66445,-2.11943,.64006,50.62681,-2.10373,.64,50.8055,-2.0466,.96972,50.63347,-2.34886,.89891,50.68489,-2.29116,1.11431,50.64491,-2.27393,1.2735,50.59304,-2.49496,1.20314,50.84597,-2.2528,1.38244,50.81233,-2.31581,1.02481,50.57501,-2.44915,1.18267,50.66048,-2.71584,1.17961,50.83227,-2.37531,1.28294,50.84106,-2.44568,1.50533,50.66777,-2.40451,2.33911,50.39513,-2.7408,2.05557,50.65018,-2.65199,2.40457,50.45291,-2.61885,1.98958,50.55593,-2.77034,2.94221,49.9916,-2.30834,2.92341,49.90819,-2.49138,3.02265,49.94574,-2.5912,3.03508,50.00707,-2.46964,3.78739,49.22991,-2.25286,2.96126,49.87407,-2.70301,3.8349,49.32071,-2.0958,2.97865,50.04182,-2.25335,4.47424,48.52716,-1.47263,3.71535,49.27584,-2.1622,3.76721,49.22948,-2.2505,4.41416,48.56184,-1.41828,4.31828,48.76446,-1.22432,3.70162,48.13331,.40408,3.88348,48.2146,.20558,3.66311,48.17289,.41945,3.89434,48.22647,.22462,3.9988,48.20146,.23116,3.10925,48.0642,1.04922,3.14248,48.04169,1.05496,3.37196,48.08998,.81816,4.50332,48.60033,-1.3889,4.67802,48.23206,-.86804,4.64435,48.23459,-.87648,4.54922,48.27316,-.86134,4.05433,47.92112,.12918,4.37943,48.04661,-.30819,4.07244,47.87168,.13897,4.32596,48.0947,-.31743,2.12446,47.08845,2.07976,2.4296,47.23058,1.80126,.50442,50.64434,-1.94026,1.24885,50.81515,-2.59004,1.3808,50.76532,-2.32396,1.19755,50.80668,-2.25179,1.05343,50.84344,-2.17655,1.14034,50.85091,-2.22231,2.31956,50.30345,-2.817,4.44014,48.00701,-.29236,2.88154,47.3826,1.42029,.59258,50.80721,-1.88996,.6019,50.77331,-1.87327,.60868,50.78154,-1.8836,.58242,50.7852,-1.85524,.55911,50.7824,-1.86365,.55729,50.70204,-1.82444,.57902,50.69956,-1.82172,.51665,50.61373,-2.04557,.65261,50.73448,-1.93994,.60883,50.72627,-1.90185,.61072,50.82091,-1.96492,.74424,50.6396,-2.15771,.75482,50.60538,-2.15709,.65576,50.59511,-2.09108,2.09721,47.15183,2.13041,2.08513,47.24532,2.10882,.53229,50.54424,-1.99414,.66699,50.6069,-2.06947};
			return value;
		}
		private double[] getlrib3_Coord_7_50_point_5()
		{
			double[] value = {.49539,50.57447,-1.95346,.52248,50.58124,-2.03506,.52365,50.66409,-2.03636,.54695,50.55118,-2.00588,.54923,50.75867,-1.86817,.49471,50.59446,-1.97655,.53261,50.6393,-1.82944,.53719,50.6392,-1.8219,.59476,50.6611,-1.89185,.59854,50.71632,-1.87979,1.21795,50.71314,-2.7533,1.36398,50.66786,-2.71451,1.97601,50.44996,-2.7424,1.89322,47.8308,1.83621,1.89766,47.78487,1.82559,1.91911,47.83471,1.85339,1.91376,47.84491,1.86041,2.07392,47.38508,2.0752,2.06991,47.38607,2.06409,2.04895,47.07168,2.0942,2.00209,47.17636,2.03811,2.01795,47.77731,1.77809,2.12027,47.69646,1.84943,2.04275,47.7737,1.84343,2.07929,47.67352,1.79395,1.96513,47.74909,1.89969,1.96936,47.75998,1.91358,1.91202,47.70853,1.83284,1.89575,47.70728,1.82514,2.08415,47.10925,2.12812,1.96363,47.31488,1.98085,1.97258,47.32889,1.99175,2.74172,48.02364,1.29885,2.65505,48.05333,1.25458,2.23242,47.88451,1.55094,2.22212,47.96945,1.5482,2.65529,48.04153,1.23528,2.66384,47.98656,1.24753,3.23197,47.54459,1.12549,3.20999,47.48673,1.11942,2.89105,47.43445,1.42336,2.44993,47.6133,1.7549,2.08949,47.48758,2.03469,3.82482,48.09154,.49345,3.75378,48.14851,.46389,3.43099,47.80609,.82852,3.8285,47.89267,.38527,4.01143,47.96818,.12271,3.74037,48.09383,.38866,3.76844,48.02124,.36536,3.36397,47.94319,.79512,3.33173,48.01555,.7846,3.95458,48.08261,.13089,1.10387,50.82058,-2.28147,1.0896,50.81173,-2.31431,1.02793,50.69687,-2.42091,1.05441,50.84273,-2.18599,1.05045,50.75747,-2.38988,.98094,50.76427,-2.32274,1.0593,50.77958,-2.3749,.89758,50.71811,-2.27588,1.18929,50.68948,-2.74736,1.39671,50.78156,-2.62853,1.40005,50.7894,-2.61744,1.02927,50.82107,-2.20891,1.30191,50.8779,-2.47222,1.13249,50.85078,-2.23325,1.67623,50.77125,-2.43478,1.21682,50.80732,-2.67221,4.11,47.81541,.16067,4.46593,48.31572,-.83859,3.28877,48.07532,.78607,2.17515,47.56719,1.87862,2.14166,47.54296,1.83166,1.99524,47.83494,1.81711,1.98853,47.83164,1.7965,1.53596,50.731,-2.36905,1.12529,50.73368,-2.24357,1.06099,50.82753,-2.17772,.96411,50.74405,-2.1538,1.06367,50.73527,-2.21922,.86357,50.73194,-2.10513,.85674,50.79388,-2.07786,1.54318,50.80788,-2.38254,1.12122,50.83502,-2.25352,.81391,50.68452,-2.22598,.72466,50.68385,-2.17096,1.05585,50.83487,-2.17098,.87029,50.66811,-2.13303,.57739,50.63875,-1.83429,.56373,50.63557,-1.82228,3.09384,47.90945,1.00435,3.06067,47.97817,.99528,2.24378,47.80753,1.56362,2.69933,47.84502,1.28108,2.25475,47.73271,1.58168,2.68257,47.9102,1.26365,3.02018,48.04208,.98815,1.93496,47.71037,1.77385,3.17635,47.68479,1.06462};
			return value;
		}
		private double[] getlrib3_Coord_7_50_point_6()
		{
			double[] value = {3.15194,47.75488,1.04747,2.33193,47.4631,1.68325,2.76482,47.67595,1.32594,2.80059,47.60085,1.34553,2.3156,47.53865,1.64884,2.89949,47.50185,1.42783,3.25702,47.61285,1.12715,3.47101,47.99142,.85925,2.84924,47.89255,1.37375,3.21657,47.95056,1.09266,2.79076,47.98108,1.3283,2.90188,47.74568,1.4152,3.26965,47.8278,1.12699,3.53156,47.90286,.88442,2.99669,48.07706,.9869,3.00239,48.08839,1.00329,2.36312,47.88453,1.63464,2.01979,47.33613,1.92006,1.95142,47.6391,1.79353,1.99475,47.77981,1.90183,2.16221,47.45334,1.93277,2.06638,47.07677,2.11675,.5587,50.57329,-1.89464,.57322,50.57142,-1.95347,.58275,50.58832,-1.92798,.63362,50.59748,-2.02227,.59179,50.58025,-1.9814,.57806,50.64932,-1.85804,.51462,50.58986,-1.83378,.54068,50.76442,-1.91104,.55907,50.54882,-1.98633,.57017,50.59609,-1.85848,.59216,50.61351,-1.90239,.62761,50.70741,-2.10244,.56971,50.68791,-2.06274,.51969,50.57923,-1.81979,.53337,50.71698,-2.02324,.57639,50.74413,-2.04094,.58427,50.79721,-2.00997,4.50162,48.52835,-1.47707,1.68026,50.72766,-2.41597,1.54583,50.77184,-2.36708,1.9919,50.65957,-2.47629,3.67257,48.18375,.43574,3.26113,48.10765,.79055,3.26445,48.11822,.80684,1.46842,50.78731,-2.6019,.63219,50.75794,-2.07711,1.23745,50.80872,-2.62759,2.12717,47.43077,1.89649,2.04769,47.66864,1.9684,2.41775,47.78469,1.68829,3.88418,48.00038,.49903,4.09548,48.07498,.25043,1.98535,50.43944,-2.72186,2.00371,47.41121,1.88686};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib4_Geo_6_55_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,7,10,8,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,25,26,23,-1,27,28,15,-1,29,30,31,-1,32,33,34,-1,32,35,33,-1,36,3,37,-1,36,9,3,-1,38,39,40,-1,38,32,39,-1,41,42,43,-1,43,44,41,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,49,52,50,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,60,61,62,-1,62,63,60,-1,64,65,66,-1,65,67,66,-1,61,68,69,-1,61,60,68,-1,70,71,72,-1,71,73,72,-1,74,75,76,-1,75,77,76,-1,76,78,74,-1,78,79,74,-1,80,81,82,-1,81,23,82,-1,21,83,26,-1,26,25,21,-1,84,85,86,-1,84,87,85,-1,88,89,30,-1,89,90,30,-1,84,86,91,-1,91,92,84,-1,93,15,94,-1,94,15,28,-1,95,96,97,-1,95,87,96,-1,95,85,87,-1,98,99,100,-1,100,101,98,-1,23,102,103,-1,23,26,102,-1,100,104,105,-1,106,81,80,-1,80,17,106,-1,107,104,108,-1,109,104,102,-1,110,111,77,-1,110,112,111,-1,20,113,21,-1,20,114,113,-1,115,116,117,-1,115,118,116,-1,119,120,121,-1,121,122,119,-1,123,122,121,-1,123,124,122,-1,125,126,127,-1,127,128,125,-1,129,130,131,-1,130,132,131,-1,133,134,135,-1,134,136,135,-1,137,138,139,-1,139,140,137,-1,141,142,143,-1,141,144,142,-1,145,146,147,-1,148,146,149,-1,150,146,151,-1,146,152,147,-1,153,154,142,-1,142,155,153,-1,49,156,52,-1,156,157,52,-1,158,143,159,-1,158,141,143,-1,160,161,162,-1,160,163,161,-1,164,165,166,-1,165,167,166,-1,168,169,170,-1,169,171,170,-1,172,169,168,-1,172,173,169,-1,174,6,47,-1,174,4,6,-1,175,176,177,-1,177,178,175,-1,179,180,181,-1,180,182,181,-1,183,43,42,-1,42,184,183,-1,185,186,187,-1,185,188,186,-1,189,90,190,-1,86,35,91,-1,33,191,34,-1,192,193,194,-1,194,195,192,-1,196,197,198,-1,196,117,197,-1,199,192,195,-1,195,59,199,-1,71,57,200,-1,71,58,57,-1,201,202,190,-1,203,88,204,-1,203,89,88,-1,84,92,205,-1,205,206,84,-1,207,96,87,-1,87,206,207,-1,103,104,107,-1,77,208,76,-1,77,111,208,-1,209,210,211,-1,209,212,210,-1,120,213,214,-1,120,119,213,-1,215,216,217,-1,216,218,217,-1,139,219,220,-1,139,138,219,-1,221,222,223,-1,221,224,222,-1,225,226,227,-1,227,228,225,-1,225,229,226,-1,229,230,226,-1,229,231,230,-1,231,232,230,-1,233,112,110,-1,233,204,112,-1,108,104,99,-1,87,84,206,-1,92,17,205,-1,201,190,89,-1,89,203,201,-1,13,12,234,-1,234,235,13,-1,70,236,58,-1,58,71,70,-1,195,237,238,-1,195,194,237,-1,19,18,193,-1,239,240,34,-1,240,241,34,-1,191,33,86,-1,86,85,191,-1,237,242,238,-1,242,185,238,-1,187,186,243,-1,186,244,243,-1,185,242,188,-1,245,246,247,-1,245,248,246,-1,181,182,184,-1,182,183,184,-1,36,249,250,-1,250,251,36,-1,45,10,252,-1,45,8,10,-1,175,253,176,-1,253,254,176,-1,255,164,256,-1,164,166,256,-1,169,161,171,-1,161,257,171,-1,159,167,165,-1,159,143,167,-1,152,146,150,-1,149,146,145,-1,258,259,211,-1,211,210,258,-1,227,129,260,-1,129,131,260,-1,261,262,258,-1,258,210,261,-1,263,212,209,-1,263,223,212,-1,264,226,230,-1,264,265,226,-1,102,104,103,-1,112,20,111,-1,112,114,20,-1,266,75,267,-1,266,268,75,-1,206,269,270,-1,270,207,206,-1,24,213,25,-1,205,80,271,-1,205,17,80,-1,105,104,109,-1,99,104,100,-1,98,272,108,-1,108,99,98,-1,96,207,97,-1,207,114,97,-1,204,273,112,-1,15,14,27,-1,93,16,15,-1,12,16,93,-1,93,234,12,-1,236,199,59,-1,59,58,236,-1,90,89,190,-1,81,24,23,-1,101,270,269,-1,269,98,101,-1,274,225,228,-1,200,73,71,-1,200,275,73,-1,110,77,268,-1,77,75,268,-1,72,233,70,-1,233,276,70,-1,1,145,147,-1,147,277,1,-1,68,278,150,-1,278,152,150,-1,151,146,148,-1,65,64,279,-1,64,280,279,-1,0,281,67,-1,67,65,0,-1,282,64,283,-1,64,66,283,-1,284,60,63,-1,63,285,284,-1,54,144,56,-1,144,141,56,-1,174,171,286,-1};
			return value;
		}
		private int[] getlrib4_Geo_6_55_coordIndex_2()
		{
			int[] value = {174,170,171,-1,287,288,289,-1,288,290,289,-1,156,283,157,-1,156,62,283,-1,282,61,69,-1,85,13,235,-1,235,191,85,-1,7,248,10,-1,248,245,10,-1,186,251,250,-1,186,188,251,-1,170,47,46,-1,170,174,47,-1,182,291,178,-1,182,180,291,-1,33,35,86,-1,143,142,154,-1,154,167,143,-1,81,106,292,-1,292,214,81,-1,213,293,25,-1,137,294,138,-1,17,116,106,-1,17,19,116,-1,197,193,192,-1,197,19,193,-1,241,32,34,-1,241,39,32,-1,38,35,32,-1,295,296,297,-1,296,298,299,-1,298,296,295,-1,10,44,252,-1,10,245,44,-1,41,39,241,-1,41,247,39,-1,106,118,292,-1,106,116,118,-1,300,301,302,-1,300,303,301,-1,302,304,300,-1,302,305,304,-1,302,306,305,-1,21,293,22,-1,21,25,293,-1,18,35,193,-1,35,18,91,-1,40,194,38,-1,237,194,40,-1,180,307,291,-1,180,244,307,-1,252,43,308,-1,44,43,252,-1,183,178,177,-1,183,182,178,-1,253,309,172,-1,309,253,310,-1,46,168,170,-1,168,46,254,-1,244,250,307,-1,244,186,250,-1,251,248,7,-1,188,248,251,-1,311,312,249,-1,312,311,313,-1,191,239,34,-1,191,235,239,-1,157,314,52,-1,315,314,157,-1,61,283,62,-1,282,283,61,-1,290,316,257,-1,288,316,290,-1,51,287,289,-1,50,287,51,-1,317,318,319,-1,318,317,281,-1,320,321,309,-1,321,320,322,-1,291,312,323,-1,307,312,291,-1,200,179,275,-1,179,200,243,-1,285,324,284,-1,324,285,325,-1,277,284,324,-1,284,277,278,-1,65,1,0,-1,65,279,1,-1,64,69,280,-1,64,282,69,-1,68,151,69,-1,68,150,151,-1,147,278,277,-1,278,147,152,-1,279,145,1,-1,279,149,145,-1,268,233,110,-1,233,268,276,-1,231,120,326,-1,231,121,120,-1,123,225,274,-1,229,225,123,-1,270,327,113,-1,101,327,270,-1,272,269,271,-1,269,272,98,-1,11,328,29,-1,11,95,328,-1,236,198,199,-1,236,329,198,-1,196,267,330,-1,266,267,196,-1,331,332,333,-1,334,332,331,-1,118,335,336,-1,115,335,118,-1,232,264,230,-1,337,264,232,-1,338,189,190,-1,338,234,189,-1,93,189,234,-1,189,93,94,-1,27,11,29,-1,11,27,14,-1,107,272,82,-1,272,107,108,-1,327,109,83,-1,327,105,109,-1,271,206,205,-1,206,271,269,-1,117,330,115,-1,117,196,330,-1,339,340,341,-1,339,342,340,-1,343,344,345,-1,343,346,344,-1,335,333,337,-1,335,331,333,-1,208,78,76,-1,208,221,78,-1,224,340,342,-1,347,340,224,-1,263,216,215,-1,263,209,216,-1,125,274,228,-1,125,348,274,-1,349,264,350,-1,265,264,349,-1,129,226,265,-1,129,227,226,-1,222,212,223,-1,222,351,212,-1,259,134,211,-1,134,259,136,-1,352,262,261,-1,352,353,262,-1,227,354,228,-1,227,260,354,-1,355,126,354,-1,126,355,356,-1,131,357,260,-1,131,358,357,-1,359,132,135,-1,132,359,360,-1,136,220,361,-1,136,259,220,-1,262,139,258,-1,262,140,139,-1,362,353,127,-1,353,362,363,-1,355,306,302,-1,355,357,306,-1,300,360,359,-1,300,304,360,-1,325,319,318,-1,364,319,325,-1,285,365,366,-1,365,285,63,-1,157,66,315,-1,157,283,66,-1,364,53,319,-1,53,364,367,-1,368,366,365,-1,369,366,368,-1,55,370,371,-1,370,55,56,-1,372,367,369,-1,373,367,372,-1,368,51,374,-1,368,49,51,-1,375,371,370,-1,375,314,371,-1,144,373,376,-1,144,54,373,-1,377,372,374,-1,378,372,377,-1,287,375,379,-1,287,50,375,-1,379,288,287,-1,288,379,297,-1,142,376,155,-1,144,376,142,-1,163,378,377,-1,160,378,163,-1,257,163,290,-1,161,163,257,-1,159,295,297,-1,295,159,165,-1,316,299,286,-1,316,296,299,-1,321,162,173,-1,321,153,162,-1,164,5,298,-1,5,164,255,-1,256,322,320,-1,256,166,322,-1,37,256,311,-1,37,255,256,-1,175,310,253,-1,175,323,310,-1,307,249,312,-1,249,307,250,-1,36,7,9,-1,7,36,251,-1,188,246,248,-1,242,246,188,-1,57,243,200,-1,57,187,243,-1,202,184,380,-1,202,181,184,-1,247,40,39,-1,247,246,40,-1,238,187,57,-1,238,185,187,-1,239,380,240,-1,380,239,338,-1,117,19,197,-1,117,116,19,-1,329,70,276,-1,329,236,70,-1,201,72,73,-1,201,203,72,-1,90,31,30,-1,189,31,90,-1,95,273,328,-1,273,95,97,-1,268,329,276,-1,266,329,268,-1};
			return value;
		}
		private int[] getlrib4_Geo_6_55_coordIndex_3()
		{
			int[] value = {347,22,340,-1,347,20,22,-1,115,331,335,-1,115,330,331,-1,343,124,348,-1,343,345,124,-1,337,350,264,-1,337,333,350,-1,218,134,133,-1,218,216,134,-1,350,218,349,-1,217,218,350,-1,358,306,357,-1,358,305,306,-1,219,361,220,-1,219,303,361,-1,351,210,212,-1,210,351,261,-1,301,362,356,-1,301,381,362,-1,222,342,344,-1,222,224,342,-1,128,348,125,-1,128,343,348,-1,345,122,124,-1,345,339,122,-1,261,346,352,-1,351,346,261,-1,362,294,363,-1,362,381,294,-1,360,305,358,-1,360,304,305,-1,349,133,130,-1,349,218,133,-1,332,215,217,-1,332,79,215,-1,75,334,267,-1,334,75,74,-1,292,336,326,-1,292,118,336,-1,341,213,119,-1,341,293,213,-1,208,20,347,-1,208,111,20,-1,263,221,223,-1,78,221,263,-1,97,112,273,-1,97,114,112,-1,204,328,273,-1,204,88,328,-1,202,73,275,-1,73,202,201,-1,233,203,204,-1,233,72,203,-1,57,195,238,-1,59,195,57,-1,199,197,192,-1,198,197,199,-1,92,18,17,-1,18,92,91,-1,380,190,202,-1,338,190,380,-1,239,234,338,-1,239,235,234,-1,240,184,42,-1,240,380,184,-1,275,181,202,-1,275,179,181,-1,178,323,175,-1,178,291,323,-1,311,320,313,-1,256,320,311,-1,255,3,5,-1,3,255,37,-1,48,254,46,-1,48,176,254,-1,309,173,172,-1,309,321,173,-1,299,174,286,-1,299,4,174,-1,169,162,161,-1,173,162,169,-1,166,154,322,-1,166,167,154,-1,164,295,165,-1,298,295,164,-1,153,160,162,-1,153,155,160,-1,296,288,297,-1,316,288,296,-1,160,376,378,-1,155,376,160,-1,158,297,379,-1,297,158,159,-1,377,290,163,-1,377,289,290,-1,370,379,375,-1,379,370,158,-1,289,374,51,-1,377,374,289,-1,373,378,376,-1,373,372,378,-1,56,158,370,-1,141,158,56,-1,375,52,314,-1,50,52,375,-1,369,374,372,-1,369,368,374,-1,367,54,53,-1,54,367,373,-1,314,382,371,-1,314,315,382,-1,49,365,156,-1,368,365,49,-1,369,364,366,-1,367,364,369,-1,317,371,382,-1,371,317,55,-1,315,67,382,-1,315,66,67,-1,156,63,62,-1,156,365,63,-1,325,366,364,-1,366,325,285,-1,281,382,67,-1,317,382,281,-1,151,280,69,-1,148,280,151,-1,176,308,177,-1,308,176,48,-1,363,137,140,-1,137,363,294,-1,356,302,301,-1,356,355,302,-1,303,359,361,-1,300,359,303,-1,356,127,126,-1,356,362,127,-1,353,140,262,-1,353,363,140,-1,258,220,259,-1,258,139,220,-1,361,135,136,-1,135,361,359,-1,132,358,131,-1,132,360,358,-1,260,355,354,-1,260,357,355,-1,135,130,133,-1,130,135,132,-1,354,125,228,-1,125,354,126,-1,127,352,128,-1,352,127,353,-1,351,344,346,-1,222,344,351,-1,265,130,129,-1,265,349,130,-1,274,124,123,-1,274,348,124,-1,209,134,216,-1,209,211,134,-1,339,119,122,-1,339,341,119,-1,221,347,224,-1,208,347,221,-1,74,332,334,-1,332,74,79,-1,326,232,231,-1,326,336,232,-1,341,22,293,-1,340,22,341,-1,345,342,339,-1,345,344,342,-1,128,346,343,-1,128,352,346,-1,270,114,207,-1,114,270,113,-1,109,26,83,-1,26,109,102,-1,23,107,82,-1,23,103,107,-1,101,105,327,-1,101,100,105,-1,94,31,189,-1,31,94,28,-1,215,78,263,-1,78,215,79,-1,336,337,232,-1,335,337,336,-1,217,333,332,-1,217,350,333,-1,330,334,331,-1,267,334,330,-1,266,198,329,-1,266,196,198,-1,11,85,95,-1,13,85,11,-1,88,29,328,-1,88,30,29,-1,327,21,113,-1,327,83,21,-1,80,272,271,-1,80,82,272,-1,121,229,123,-1,231,229,121,-1,326,214,292,-1,326,120,214,-1,148,279,280,-1,279,148,149,-1,1,324,2,-1,1,277,324,-1,284,68,60,-1,284,278,68,-1,324,318,2,-1,324,325,318,-1,243,180,179,-1,243,244,180,-1,310,320,309,-1,320,310,313,-1,322,153,321,-1,153,322,154,-1,281,2,318,-1,281,0,2,-1,319,55,317,-1,319,53,55,-1,257,286,171,-1,316,286,257,-1,45,308,48,-1,45,252,308,-1,42,241,240,-1,41,241,42,-1,45,6,8,-1,45,47,6,-1,311,36,37,-1,249,36,311,-1,172,254,253,-1,172,168,254,-1,177,43,183,-1,43,177,308,-1,313,323,312,-1,323,313,310,-1,38,193,35,-1,194,193,38,-1,246,237,40,-1,242,237,246,-1,31,27,29,-1,31,28,27,-1,214,24,81,-1,24,214,213,-1};
			return value;
		}
		private int[] getlrib4_Geo_6_55_coordIndex_4()
		{
			int[] value = {303,381,301,-1,303,219,381,-1,219,294,381,-1,219,138,294,-1,14,12,11,-1,14,16,12,-1,44,247,41,-1,44,245,247,-1,3,8,6,-1,9,8,3,-1,299,5,4,-1,5,299,298,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib4_Coord_7_55_point_1()
		{
			double[] value = {2.05133,46.26965,2.28867,2.0469,46.23815,2.318,2.0612,46.28678,2.30484,4.69591,47.87536,-1.30395,4.81768,47.57434,-.79889,4.74633,47.58948,-.77114,4.75389,47.85088,-1.3522,4.09736,48.55825,-2.3007,4.55893,48.15036,-1.90223,4.50568,48.17192,-1.84531,4.1244,48.53919,-2.36193,1.1374,50.08685,-2.9714,1.25932,50.0215,-3.05239,1.24083,50.00734,-3.0617,1.20083,50.08772,-2.97633,1.28497,50.07951,-2.98896,1.26854,50.04602,-3.02784,1.19472,49.83727,-2.8917,1.28912,49.87164,-2.91951,1.21507,49.89045,-2.85137,.88584,50.0504,-2.64071,.93278,50.00076,-2.722,.88503,49.98707,-2.65748,1.01587,49.89857,-2.77039,.99954,49.90873,-2.75106,.95089,49.93972,-2.72551,.95989,49.93829,-2.74268,1.21344,50.14039,-2.92227,1.28712,50.12775,-2.96079,1.16286,50.18239,-2.87337,1.26216,50.17861,-2.90502,1.2769,50.15495,-2.94073,1.75219,49.86039,-3.07154,1.428,49.8963,-3.05461,1.72817,49.86066,-3.11145,1.42558,49.88248,-3.01305,4.46701,48.238,-1.71016,4.6112,47.94017,-1.17497,1.77255,49.84597,-3.03418,2.10278,49.76862,-3.10867,2.12856,49.76209,-3.05835,2.50636,49.54627,-3.19943,2.50765,49.56832,-3.21404,3.503,48.98235,-2.87253,3.49024,48.96155,-2.84386,4.58947,48.12081,-1.96187,4.8246,47.82323,-1.41578,4.7915,47.81579,-1.41355,4.62052,48.12436,-1.9677,2.76046,45.85341,2.20759,3.21369,46.07634,1.82858,3.21735,46.09267,1.85464,2.76088,45.85988,2.16395,2.47186,46.47601,2.10117,2.96412,46.74056,1.7715,2.47485,46.46965,2.07275,2.95791,46.73459,1.74435,2.21671,49.92282,-2.98203,1.87039,50.04301,-2.93819,1.86724,49.9906,-2.94002,2.24656,45.73494,2.50872,2.22588,45.64647,2.47327,2.33799,45.65935,2.46049,2.35285,45.74806,2.46813,2.1722,45.82917,2.35556,2.12069,46.07112,2.30689,2.27516,45.86815,2.31925,2.20132,46.11291,2.25691,2.22386,45.757,2.4941,2.2161,45.66201,2.46322,1.5153,50.1734,-2.8678,1.86387,50.11183,-2.9577,1.50878,50.19169,-2.87971,1.85538,50.12936,-2.97974,.83583,50.1226,-2.48195,.92622,50.13992,-2.55864,.82829,50.13229,-2.49739,.91775,50.1504,-2.56483,.76057,50.12743,-2.42651,.77439,50.11271,-2.41635,1.15344,49.82934,-2.89876,1.01913,49.89865,-2.75643,1.13606,49.8328,-2.90139,.93541,49.99697,-2.73377,1.23488,49.9289,-3.04015,1.23506,49.98505,-3.05902,1.31895,49.92149,-3.03919,1.21542,49.95357,-3.04245,1.2645,50.18229,-2.89167,1.4702,50.1485,-2.99795,1.46545,50.14272,-3.00913,1.30426,49.88591,-2.99128,1.23876,49.86711,-2.97998,1.35882,50.03535,-3.06352,1.37169,50.09948,-3.01848,1.11987,50.09035,-2.9555,1.09897,50.07192,-2.92271,1.02168,50.10239,-2.76465,1.12333,49.91508,-3.00825,1.07573,49.92023,-2.94381};
			return value;
		}
		private double[] getlrib4_Coord_7_55_point_2()
		{
			double[] value = {1.03531,49.97062,-2.89002,1.04455,50.01388,-2.88723,.98584,49.94031,-2.79705,1.02522,49.89873,-2.82523,1.02868,49.93147,-2.86059,1.00218,49.98083,-2.83233,1.02489,49.89536,-2.73776,1.07518,49.872,-2.89056,1.08918,49.88354,-2.94258,.97774,49.96883,-2.79734,1.02551,50.16226,-2.61737,.90295,50.11838,-2.59735,.97457,50.12706,-2.66714,.98057,50.0359,-2.7778,.9703,50.0812,-2.72127,.94707,49.9442,-2.60357,1.03297,49.92602,-2.70263,1.04103,49.95521,-2.67128,.94209,49.90652,-2.63332,.82278,49.84391,-2.60531,.8258,49.82918,-2.60803,.72444,49.79821,-2.50725,.71296,49.81355,-2.51954,.64643,49.77808,-2.41484,.62511,49.79758,-2.43763,.50454,49.77447,-2.33843,.50005,49.78292,-2.33219,.51192,49.9098,-2.35892,.51537,49.90642,-2.36812,.51281,49.8122,-2.12245,.54751,49.90392,-2.10641,.5052,49.81517,-2.11888,.54364,49.90523,-2.10577,.57762,49.98379,-2.10762,.60953,50.09739,-2.15955,.57286,49.98522,-2.10675,.6042,50.09287,-2.16523,.51542,49.98157,-2.25316,.51572,49.98193,-2.24183,.5466,50.0653,-2.26506,.53894,50.03284,-2.28482,3.2873,46.92707,1.43833,3.748,47.16896,1.02428,3.72467,47.14947,1.00983,3.30187,46.92736,1.47006,2.16044,46.21094,2.28701,2.29665,45.98503,2.33597,2.24554,46.10861,2.36073,2.24839,45.91981,2.32785,2.22285,46.0385,2.30798,2.30957,45.83389,2.43244,2.30583,45.75818,2.40416,2.28992,45.99616,2.40459,4.27515,47.37577,.4962,4.25465,47.38425,.48693,3.8121,47.10809,1.06064,2.42174,45.68802,2.41031,2.40508,45.70539,2.36966,3.33086,46.78954,1.42551,3.7736,47.04942,.95469,3.90704,46.95513,1.08621,4.45602,47.14652,.44155,4.38036,47.26781,.48531,3.99197,46.80961,1.0849,4.50712,47.48603,-.16933,4.22907,47.29174,.35249,4.50769,47.56294,-.05708,4.20805,47.38919,.44258,4.93697,47.64842,-.77435,4.76531,47.40765,-.11271,4.90243,47.56186,-.83855,4.76594,47.32083,-.21244,4.86437,47.73309,-.68668,4.68014,47.49751,-.06073,4.86996,47.54891,-.83959,4.64345,48.27346,-1.76026,4.65814,48.18335,-1.88289,4.21305,48.60336,-2.38188,4.21859,48.69278,-2.27293,2.59631,49.83846,-3.00677,3.54036,49.24194,-2.61918,2.54282,49.77947,-3.12464,3.57407,49.18811,-2.7343,3.56011,49.11557,-2.82465,2.50798,49.69076,-3.16011,2.57665,49.63041,-2.93428,3.4864,49.15793,-2.55167,2.59547,49.73756,-2.94955,3.47688,49.0593,-2.57611,1.45734,50.11768,-3.03946,1.7715,50.08067,-3.09002,1.41915,49.91575,-3.0922,1.51485,49.88045,-2.93291,1.48736,49.86891,-2.9532,1.80411,49.83796,-2.98152,1.85056,49.88517,-2.94926,1.04912,50.00614,-2.6465,1.23558,49.94564,-2.80193,1.23539,49.99955,-2.75695,1.51742,49.9656,-2.89848};
			return value;
		}
		private double[] getlrib4_Coord_7_55_point_3()
		{
			double[] value = {2.21012,50.00908,-3.02149,1.80163,50.08872,-3.04815,2.12122,49.97166,-3.13765,1.48265,50.13996,-2.93446,1.19371,50.15383,-2.78057,1.20818,49.85855,-2.97858,1.17597,49.94356,-3.01644,1.07687,50.0527,-2.88442,.81785,50.1139,-2.52406,.65243,50.12806,-2.2936,.56734,50.10876,-2.28175,.60312,50.1264,-2.20584,.62828,50.10931,-2.33313,.91973,49.88495,-2.68348,.92576,49.87224,-2.68071,.71404,50.10324,-2.34651,.66757,50.10115,-2.27144,.72164,50.03759,-2.32501,.66253,50.02261,-2.2458,.51326,49.97202,-2.22988,.56038,50.05731,-2.21951,.75713,50.11547,-2.4565,.63765,50.04949,-2.40854,.68161,50.10972,-2.37914,.72955,50.04623,-2.48712,.58887,49.75773,-2.31996,.59908,49.78254,-2.29698,.49946,49.73145,-2.16754,.49502,49.71694,-2.23315,.65553,49.78239,-2.40576,.66608,49.82428,-2.38663,.73234,49.8037,-2.49658,.75125,49.85167,-2.46683,1.22481,50.21092,-2.71887,1.43653,49.98827,-3.11881,1.42694,49.94287,-3.12001,1.51747,50.04001,-2.86794,2.16493,49.7592,-2.99912,2.20428,49.80007,-2.98074,1.71388,49.89482,-3.14424,2.05438,49.7675,-3.21032,2.06464,49.73896,-3.19122,2.56437,49.59278,-2.95823,2.59976,49.82723,-2.98416,3.53038,49.23613,-2.60086,3.50736,48.99809,-2.75688,2.55277,49.57767,-3.02455,2.53673,49.57895,-3.0966,3.49275,48.99662,-2.69355,4.49841,48.29518,-1.66748,4.08469,48.68166,-2.14016,4.07481,48.61801,-2.18828,4.13153,48.50198,-2.43112,4.82288,47.98393,-1.25393,4.85954,47.89752,-1.36271,4.63664,47.70296,-.67019,4.67362,47.76311,-.59711,4.50744,47.06131,.32744,.55861,50.10508,-2.27656,.59822,50.11805,-2.20784,.49403,49.7393,-2.16937,.54941,50.06277,-2.3266,.54432,50.06038,-2.31948,.69711,50.12448,-2.35983,.68684,49.89537,-2.35295,.62275,49.87286,-2.28128,1.05384,50.05588,-2.628,.95716,50.05789,-2.56092,1.03121,50.14815,-2.61276,1.13972,49.92135,-3.01423,1.04612,50.02533,-2.87324,1.162,49.85784,-2.98068,1.13901,49.86196,-2.98174,1.04797,50.1413,-2.73706,.57913,49.75314,-2.32713,2.19986,50.02032,-3.0453,1.22877,50.1941,-2.71328,2.17273,46.13722,2.41297,2.22818,45.95909,2.48304,2.11031,46.06223,2.33064,2.16587,45.83789,2.37466,2.1296,46.30257,2.26195,2.22455,45.65342,2.44748,2.32559,45.66936,2.40279,2.25032,45.96938,2.48733,2.34896,46.02398,2.42495,4.7411,47.3123,-.2352,3.52726,46.27511,1.5385,4.01818,46.66256,.98396,3.58449,46.32493,1.5056,4.03198,46.66538,1.00903,4.17041,48.7182,-2.17132,.93169,49.87427,-2.66944,.91103,49.92884,-2.66945,.50694,49.9508,-2.25999,4.36592,47.14326,.29118,4.43412,47.10709,.30314,3.91379,46.80276,.93431,4.61311,47.37253,-.23472,4.68512,47.34889,-.2274};
			return value;
		}
		private double[] getlrib4_Coord_7_55_point_4()
		{
			double[] value = {.50877,49.95439,-2.21436,.50079,49.92702,-2.24372,.49808,49.91622,-2.23242,.51115,49.96387,-2.22411,.50508,49.94018,-2.20604,.49881,49.91716,-2.20795,.49708,49.91164,-2.2198,4.15426,48.71645,-2.15619,4.15613,48.51199,-2.4479,4.78041,47.78146,-.60018,4.74844,48.0234,-1.14153,4.64445,48.00144,-1.12275,4.57236,48.30465,-1.65454,4.72635,48.02636,-1.1341,2.62865,46.0334,2.114,2.37051,45.90337,2.27155,4.48665,47.05447,.30121,2.21543,46.34325,2.21574,2.14181,46.32136,2.28056,2.23117,46.3648,2.24152,4.75863,47.78581,-.59733,4.5896,47.56116,-.01325,4.56875,47.56739,-.01545,4.59765,48.30046,-1.66971,2.19144,46.16066,2.41493,2.27849,46.21443,2.3609,.83311,49.83386,-2.59676,.9797,50.02597,-2.78803,1.14374,50.18548,-2.85746,1.23569,50.0704,-2.72373,.95421,50.00185,-2.5793,.863,49.99606,-2.50703,.78702,50.04928,-2.41012,.77898,49.98347,-2.42195,.8697,50.05165,-2.48672,.85405,49.93142,-2.52984,.84625,49.87993,-2.56197,.76138,49.90843,-2.44242,1.7308,49.97078,-3.13825,.71889,49.89286,-2.51198,.79412,49.97086,-2.57797,.81302,49.90425,-2.59243,.71159,49.96032,-2.5116,.57125,49.89677,-2.40731,.62348,49.95631,-2.44523,.62884,49.88911,-2.44154,.57535,49.96406,-2.41457,.79357,50.04581,-2.54942,.55889,49.78331,-2.38352,.64573,49.95769,-2.25375,.71256,49.97868,-2.33517,.59681,50.05902,-2.3713,.52892,49.96438,-2.37582,.5249,49.96567,-2.36737,.49246,49.72389,-2.22997,.49592,49.83417,-2.23108,.50612,49.85709,-2.28207,.4934,49.84886,-2.20215,.49569,49.88365,-2.17331,.53388,49.9742,-2.16798,.51596,49.93197,-2.1693,.55485,50.02774,-2.19128,.51612,49.92941,-2.30996,.52229,49.95836,-2.30567,2.35408,46.26884,2.30894,2.4403,45.77264,2.41041,2.44243,46.06821,2.37251,2.5778,46.39801,2.15964,2.75149,45.98215,2.22507,2.67933,46.21252,2.20651,3.01609,46.58052,1.7228,2.5305,46.31085,2.05368,3.13606,46.48331,1.84819,3.02913,46.6709,1.82113,3.2164,46.22004,1.87765,3.11193,46.26586,1.76327,3.37283,46.84717,1.53971,3.55,46.44891,1.54554,3.44448,46.66491,1.57462,3.4458,46.49028,1.43483,2.07467,49.87868,-3.18474,.50422,49.94071,-2.25864,2.28225,46.15696,2.20229};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib5_Geo_6_60_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,7,8,9,-1,7,10,8,-1,11,12,13,-1,13,14,11,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,25,26,23,-1,27,28,29,-1,28,30,29,-1,31,32,33,-1,32,34,33,-1,35,36,23,-1,23,20,35,-1,29,30,37,-1,37,38,29,-1,39,40,41,-1,40,42,41,-1,43,44,45,-1,44,46,45,-1,47,48,49,-1,49,50,47,-1,18,51,16,-1,18,52,51,-1,53,49,54,-1,49,55,54,-1,56,53,54,-1,56,57,53,-1,58,54,59,-1,58,56,54,-1,60,61,62,-1,61,63,62,-1,64,65,66,-1,64,60,65,-1,67,68,69,-1,13,70,68,-1,47,50,71,-1,50,72,71,-1,66,67,73,-1,66,65,67,-1,74,75,76,-1,75,77,76,-1,78,79,80,-1,80,81,78,-1,82,83,84,-1,85,86,87,-1,87,88,85,-1,89,83,90,-1,89,91,83,-1,92,93,94,-1,92,94,95,-1,96,87,97,-1,98,99,100,-1,100,101,98,-1,80,95,81,-1,102,103,104,-1,102,105,103,-1,106,107,108,-1,109,110,111,-1,109,112,110,-1,113,114,115,-1,116,117,118,-1,116,119,117,-1,120,113,121,-1,121,122,120,-1,123,124,125,-1,69,73,67,-1,69,126,73,-1,127,128,12,-1,127,129,128,-1,130,131,132,-1,132,133,130,-1,134,135,132,-1,134,115,135,-1,136,137,138,-1,138,139,136,-1,140,141,142,-1,140,143,141,-1,134,132,144,-1,144,145,134,-1,146,116,147,-1,148,149,4,-1,148,150,149,-1,151,152,153,-1,151,154,152,-1,155,137,156,-1,156,11,155,-1,142,157,158,-1,142,159,157,-1,131,144,132,-1,133,160,161,-1,133,162,160,-1,12,163,127,-1,132,135,133,-1,164,133,135,-1,139,165,136,-1,12,128,13,-1,115,166,113,-1,167,168,169,-1,169,170,167,-1,168,171,169,-1,172,173,174,-1,173,175,174,-1,176,177,178,-1,177,179,178,-1,180,181,182,-1,180,183,181,-1,184,43,185,-1,184,44,43,-1,186,187,188,-1,188,189,186,-1,190,1,191,-1,1,3,191,-1,192,188,193,-1,188,194,193,-1,195,196,16,-1,196,17,16,-1,197,41,42,-1,42,198,197,-1,199,200,201,-1,200,202,201,-1,54,198,59,-1,54,203,198,-1,204,205,206,-1,206,207,204,-1,208,209,210,-1,208,211,209,-1,212,213,214,-1,213,215,214,-1,216,217,218,-1,217,219,218,-1,220,221,222,-1,220,223,221,-1,109,155,224,-1,224,225,109,-1,112,225,226,-1,112,109,225,-1,227,228,226,-1,228,112,226,-1,70,6,68,-1,229,159,142,-1,142,152,229,-1,160,230,161,-1,113,231,121,-1,113,166,231,-1,232,233,234,-1,234,235,232,-1,79,108,236,-1,108,237,236,-1,236,238,80,-1,80,79,236,-1,98,239,99,-1,98,89,239,-1,240,88,241,-1,241,242,240,-1,243,239,90,-1,244,245,236,-1,236,237,244,-1,246,83,91,-1,75,247,77,-1,247,82,77,-1,108,248,249,-1,108,107,248,-1,78,108,79,-1,233,250,251,-1,251,234,233,-1,122,147,120,-1,122,146,147,-1,252,120,153,-1,120,147,153,-1,253,254,255,-1,255,154,253,-1,256,257,123,-1,123,125,256,-1,225,258,259,-1,225,224,258,-1,6,70,148,-1,148,4,6,-1,258,209,259,-1,209,260,259,-1,261,262,263,-1,261,264,262,-1,265,50,53,-1,50,49,53,-1,201,266,267,-1,201,202,266,-1,267,266,72,-1,266,71,72,-1,200,174,268,-1,268,202,200,-1,197,269,41,-1,269,270,41,-1,271,192,272,-1,192,193,272,-1,273,188,192,-1,273,189,188,-1,194,187,274,-1,194,188,187,-1,46,275,276,-1,276,45,46,-1,182,1,190,-1,182,181,1,-1,168,277,278,-1,278,171,168,-1,70,13,279,-1,279,148,70,-1,130,165,131,-1,120,252,141,-1,280,281,160,-1,282,230,281,-1,160,140,280,-1,160,162,140,-1,130,133,161,-1,140,162,143,-1,141,252,142,-1,137,155,283,-1,12,156,163,-1,12,11,156,-1,284,285,286,-1,287,4,149,-1,287,5,4,-1,288,7,9,-1,154,229,152,-1,154,255,229,-1,125,289,290,-1,125,124,289,-1,291,257,256,-1,292,123,126,-1,126,69,292,-1,139,145,144,-1,139,138,145,-1,164,141,143,-1,164,114,141,-1,282,156,137,-1,137,136,282,-1,120,114,113,-1,120,141,114,-1,138,293,145,-1,138,294,293,-1,13,128,279,-1,159,10,7,-1,159,229,10,-1,255,254,285,-1,254,286,285,-1,295,296,124,-1};
			return value;
		}
		private int[] getlrib5_Geo_6_60_coordIndex_2()
		{
			int[] value = {296,289,124,-1,297,244,298,-1,151,116,118,-1,105,106,103,-1,105,107,106,-1,299,300,301,-1,239,89,90,-1,83,82,90,-1,302,81,303,-1,81,95,303,-1,108,78,106,-1,304,305,256,-1,306,307,264,-1,306,308,307,-1,191,196,194,-1,196,193,194,-1,6,292,69,-1,69,68,6,-1,279,128,129,-1,217,212,214,-1,217,260,212,-1,309,310,311,-1,309,312,310,-1,55,203,54,-1,195,313,196,-1,182,190,314,-1,190,274,314,-1,36,180,277,-1,180,278,277,-1,25,315,316,-1,315,317,316,-1,32,318,34,-1,318,22,34,-1,31,33,28,-1,28,319,31,-1,27,29,320,-1,320,321,27,-1,33,34,322,-1,34,323,322,-1,22,35,20,-1,22,318,35,-1,283,138,137,-1,324,256,305,-1,324,325,256,-1,325,291,256,-1,2,181,326,-1,2,1,181,-1,160,281,230,-1,327,181,183,-1,326,181,327,-1,328,329,330,-1,331,329,328,-1,331,332,329,-1,331,333,332,-1,321,167,170,-1,321,334,167,-1,320,335,336,-1,320,337,335,-1,338,339,340,-1,330,339,338,-1,33,30,28,-1,33,322,30,-1,19,34,22,-1,34,19,323,-1,315,334,336,-1,341,334,315,-1,168,24,277,-1,168,341,24,-1,27,170,342,-1,170,27,321,-1,30,343,37,-1,30,322,343,-1,339,323,19,-1,323,339,344,-1,345,25,316,-1,26,25,345,-1,336,317,315,-1,336,335,317,-1,333,38,37,-1,331,38,333,-1,46,346,275,-1,346,46,347,-1,182,278,180,-1,182,314,278,-1,264,348,306,-1,261,348,264,-1,349,177,176,-1,177,349,350,-1,270,173,172,-1,347,173,270,-1,63,351,62,-1,351,63,352,-1,353,50,265,-1,72,50,353,-1,354,309,311,-1,64,309,354,-1,213,263,215,-1,213,355,263,-1,205,201,267,-1,201,205,204,-1,310,356,357,-1,312,356,310,-1,215,262,358,-1,215,263,262,-1,62,211,208,-1,62,351,211,-1,214,358,359,-1,215,358,214,-1,360,312,361,-1,356,312,360,-1,64,362,309,-1,64,66,362,-1,67,363,68,-1,67,210,363,-1,364,354,365,-1,364,61,354,-1,193,313,272,-1,196,313,193,-1,357,264,307,-1,264,357,262,-1,218,366,367,-1,366,218,219,-1,368,82,84,-1,368,77,82,-1,304,369,370,-1,304,371,369,-1,372,117,119,-1,372,373,117,-1,374,375,376,-1,374,377,375,-1,228,324,305,-1,325,228,227,-1,325,324,228,-1,374,297,298,-1,374,76,297,-1,378,86,85,-1,378,300,86,-1,302,379,81,-1,379,302,301,-1,94,98,101,-1,98,94,93,-1,241,243,247,-1,96,243,241,-1,244,368,245,-1,244,297,368,-1,300,380,86,-1,300,299,380,-1,302,101,100,-1,303,101,302,-1,381,236,245,-1,381,238,236,-1,75,382,242,-1,74,382,75,-1,383,244,237,-1,244,383,298,-1,384,166,385,-1,231,166,384,-1,248,231,384,-1,231,248,386,-1,103,379,378,-1,103,106,379,-1,146,376,375,-1,146,387,376,-1,388,121,389,-1,122,121,388,-1,296,254,289,-1,254,296,286,-1,255,10,229,-1,285,10,255,-1,159,288,157,-1,159,7,288,-1,129,148,279,-1,150,148,129,-1,294,390,293,-1,294,391,390,-1,163,280,158,-1,163,281,280,-1,282,163,156,-1,282,281,163,-1,292,5,295,-1,292,6,5,-1,125,304,256,-1,125,290,304,-1,296,284,286,-1,296,287,284,-1,222,291,220,-1,222,257,291,-1,287,295,5,-1,295,287,296,-1,8,150,9,-1,8,149,150,-1,117,253,118,-1,117,371,253,-1,142,153,152,-1,142,252,153,-1,282,165,230,-1,165,282,136,-1,232,134,145,-1,232,385,134,-1,294,283,111,-1,294,138,283,-1,333,343,332,-1,343,333,37,-1,330,344,339,-1,330,329,344,-1,392,316,393,-1,316,392,345,-1,331,337,38,-1,328,337,331,-1,177,342,179,-1,177,319,342,-1,183,318,327,-1,183,35,318,-1,394,169,171,-1,395,169,394,-1,396,45,276,-1,396,349,45,-1,186,178,395,-1,185,178,186,-1,394,274,187,-1,394,314,274,-1,2,396,276,-1,2,326,396,-1,275,15,0,-1,15,275,346,-1,273,184,189,-1,175,184,273,-1,44,347,46,-1,44,173,347,-1,268,175,273,-1,268,174,175,-1,271,71,266,-1,271,272,71,-1,269,52,18,-1,52,269,197,-1,172,200,39,-1,172,174,200,-1,268,266,202,-1,268,271,266,-1,49,51,55,-1,49,48,51,-1,206,353,365,-1,206,205,353,-1,40,308,306,-1,40,199,308,-1,357,207,310,-1,307,207,357,-1,364,63,61,-1,364,57,63,-1,263,58,261,-1};
			return value;
		}
		private int[] getlrib5_Geo_6_60_coordIndex_3()
		{
			int[] value = {58,263,355,-1,223,362,221,-1,223,361,362,-1,210,258,363,-1,258,210,209,-1,259,217,216,-1,259,260,217,-1,144,165,139,-1,144,131,165,-1,250,293,390,-1,250,233,293,-1,369,110,370,-1,369,391,110,-1,220,325,367,-1,325,220,291,-1,289,253,290,-1,254,253,289,-1,372,390,373,-1,250,390,372,-1,375,116,146,-1,119,116,375,-1,242,247,75,-1,242,241,247,-1,377,250,372,-1,251,250,377,-1,106,81,379,-1,78,81,106,-1,235,383,249,-1,235,234,383,-1,251,374,298,-1,251,377,374,-1,91,92,246,-1,92,91,93,-1,382,388,397,-1,387,388,382,-1,243,97,239,-1,96,97,243,-1,380,239,97,-1,99,239,380,-1,104,88,240,-1,104,85,88,-1,386,102,389,-1,102,386,105,-1,378,104,103,-1,104,378,85,-1,397,389,102,-1,388,389,397,-1,298,234,251,-1,298,383,234,-1,385,235,384,-1,385,232,235,-1,387,74,376,-1,387,382,74,-1,154,118,253,-1,154,151,118,-1,158,127,163,-1,127,158,157,-1,129,9,150,-1,129,288,9,-1,226,218,227,-1,226,216,218,-1,371,290,253,-1,371,304,290,-1,225,216,226,-1,225,259,216,-1,391,111,110,-1,391,294,111,-1,155,14,224,-1,14,155,11,-1,126,221,73,-1,222,221,126,-1,367,223,220,-1,367,366,223,-1,217,359,219,-1,217,214,359,-1,211,260,209,-1,260,211,212,-1,73,362,66,-1,73,221,362,-1,361,366,360,-1,223,366,361,-1,56,355,352,-1,56,58,355,-1,310,206,311,-1,207,206,310,-1,207,308,204,-1,207,307,308,-1,348,198,42,-1,59,198,348,-1,199,39,200,-1,40,39,199,-1,197,203,52,-1,203,197,198,-1,16,48,195,-1,48,16,51,-1,271,273,192,-1,273,271,268,-1,346,18,15,-1,18,346,269,-1,184,173,44,-1,173,184,175,-1,191,17,196,-1,17,191,3,-1,276,0,2,-1,0,276,275,-1,185,189,184,-1,185,186,189,-1,395,187,186,-1,395,394,187,-1,178,43,176,-1,43,178,185,-1,398,326,327,-1,326,398,396,-1,171,314,394,-1,171,278,314,-1,395,179,169,-1,178,179,395,-1,350,396,398,-1,396,350,349,-1,327,32,398,-1,327,318,32,-1,169,342,170,-1,179,342,169,-1,31,398,32,-1,398,31,350,-1,335,399,317,-1,335,400,399,-1,340,392,338,-1,340,345,392,-1,344,332,343,-1,344,329,332,-1,365,311,206,-1,354,311,365,-1,233,145,293,-1,233,232,145,-1,130,230,165,-1,130,161,230,-1,164,162,133,-1,143,162,164,-1,287,8,284,-1,8,287,149,-1,153,116,151,-1,116,153,147,-1,363,224,14,-1,258,224,363,-1,140,158,280,-1,140,142,158,-1,164,115,114,-1,115,164,135,-1,373,391,369,-1,391,373,390,-1,124,292,295,-1,124,123,292,-1,157,129,127,-1,157,288,129,-1,123,222,126,-1,257,222,123,-1,389,231,386,-1,121,231,389,-1,122,387,146,-1,122,388,387,-1,107,386,248,-1,105,386,107,-1,384,249,248,-1,384,235,249,-1,385,115,134,-1,385,166,115,-1,237,249,383,-1,237,108,249,-1,370,112,228,-1,112,370,110,-1,111,155,109,-1,155,111,283,-1,240,102,104,-1,397,102,240,-1,242,397,240,-1,382,397,242,-1,76,368,297,-1,76,77,368,-1,100,301,302,-1,299,301,100,-1,299,99,380,-1,99,299,100,-1,86,97,87,-1,86,380,97,-1,84,245,368,-1,381,245,84,-1,246,238,381,-1,238,246,92,-1,82,243,90,-1,82,247,243,-1,88,96,241,-1,88,87,96,-1,98,91,89,-1,98,93,91,-1,101,95,94,-1,101,303,95,-1,301,378,379,-1,378,301,300,-1,83,381,84,-1,246,381,83,-1,92,80,238,-1,92,95,80,-1,305,370,228,-1,305,304,370,-1,367,227,218,-1,367,325,227,-1,376,76,374,-1,376,74,76,-1,377,119,375,-1,377,372,119,-1,371,373,369,-1,371,117,373,-1,219,360,366,-1,219,359,360,-1,274,191,194,-1,274,190,191,-1,71,313,47,-1,313,71,272,-1,265,365,353,-1,364,365,265,-1,65,210,67,-1,65,208,210,-1,68,14,13,-1,363,14,68,-1,309,361,312,-1,309,362,361,-1,359,356,360,-1,358,356,359,-1,351,212,211,-1,351,213,212,-1,60,208,65,-1,60,62,208,-1,358,357,356,-1,358,262,357,-1,204,199,201,-1,199,204,308,-1,213,352,355,-1,213,351,352,-1,53,364,265,-1,364,53,57,-1,261,59,348,-1,261,58,59,-1,354,60,64,-1,60,354,61,-1,205,72,353,-1,267,72,205,-1,57,352,63,-1,352,57,56,-1,55,52,203,-1};
			return value;
		}
		private int[] getlrib5_Geo_6_60_coordIndex_4()
		{
			int[] value = {52,55,51,-1,47,195,48,-1,47,313,195,-1,350,319,177,-1,319,350,31,-1,45,176,43,-1,176,45,349,-1,172,41,270,-1,172,39,41,-1,306,42,40,-1,306,348,42,-1,347,269,346,-1,269,347,270,-1,393,317,399,-1,317,393,316,-1,38,320,29,-1,320,38,337,-1,345,21,26,-1,345,340,21,-1,323,343,322,-1,323,344,343,-1,28,342,319,-1,342,28,27,-1,167,341,168,-1,341,167,334,-1,24,36,277,-1,36,24,23,-1,25,341,315,-1,24,341,25,-1,26,20,23,-1,26,21,20,-1,340,19,21,-1,339,19,340,-1,337,400,335,-1,337,328,400,-1,321,336,334,-1,321,320,336,-1,183,36,35,-1,180,36,183,-1,285,8,10,-1,285,284,8,-1,393,338,392,-1,338,393,399,-1,330,400,328,-1,338,400,330,-1,399,400,338,-1,3,15,17,-1,15,3,0,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib5_Coord_7_60_point_1()
		{
			double[] value = {3.94847,45.90292,1.03671,3.46812,45.44305,1.66741,3.43497,45.49252,1.66632,4.01709,45.86126,1.05145,1.15994,49.4386,-3.16827,1.1638,49.47181,-3.17847,1.35728,49.36928,-3.27641,.97779,49.43006,-2.99365,1.0282,49.46381,-3.03823,1.02119,49.42539,-3.01354,.97359,49.46605,-3.00127,1.27245,49.24085,-3.12676,1.21939,49.26089,-3.15007,1.37169,49.23229,-3.24206,1.42878,49.23991,-3.19976,4.58415,46.47859,.13799,4.98212,47.03008,-.88484,4.64754,46.44819,.13138,4.94487,47.06426,-.84888,2.34298,44.89857,2.51661,2.35982,44.8204,2.52264,2.373,44.84149,2.52919,2.32854,44.88592,2.51456,2.39464,44.7576,2.53326,2.41342,44.75701,2.57016,2.40974,44.77971,2.55854,2.40353,44.7842,2.53964,2.37876,45.10304,2.61452,2.28156,45.19095,2.56186,2.37788,45.0984,2.59315,2.29115,45.16241,2.55272,2.25809,45.19444,2.52217,2.281,45.03522,2.49371,2.26019,45.16637,2.53483,2.28523,45.03363,2.51113,2.36118,44.80694,2.50505,2.40464,44.74646,2.51943,2.38381,45.12893,2.53519,2.43228,45.0664,2.5614,4.93469,47.54735,-1.36949,4.82487,47.7814,-1.81482,4.89204,47.53562,-1.39117,4.76856,47.7707,-1.81291,3.33603,45.88594,1.7557,3.9069,46.28939,1.15877,3.30978,45.86929,1.74192,3.86039,46.26928,1.14429,5.00211,47.33878,-1.71269,4.97549,47.35754,-1.67941,4.7839,47.62454,-2.11502,4.79487,47.59421,-2.19435,4.92995,47.38123,-1.6373,4.89461,47.42313,-1.5729,4.46338,47.90228,-2.53505,4.44457,47.92893,-2.42956,4.74106,47.64882,-2.02479,4.01774,48.20897,-2.76318,4.00345,48.18088,-2.87129,4.08434,48.28363,-2.56012,4.44887,48.00711,-2.25505,2.82904,48.7555,-3.38777,3.41874,48.45563,-3.20999,2.86634,48.78706,-3.31515,3.45331,48.48159,-3.10621,2.8249,48.76789,-3.41791,2.43266,48.91055,-3.43617,2.42398,48.9343,-3.46278,1.9941,49.05997,-3.44475,1.60053,49.19124,-3.3251,1.58716,49.23831,-3.35764,1.34255,49.27479,-3.26981,5.03176,47.34143,-1.71256,4.81806,47.59967,-2.21096,1.97775,49.09506,-3.47048,.65011,49.31305,-2.4666,.62444,49.32477,-2.39974,.66322,49.30077,-2.46577,.63691,49.3034,-2.40111,.51248,48.92579,-2.45984,.55094,48.92123,-2.44177,.53906,48.90431,-2.36804,.48491,48.92754,-2.38547,.61269,49.2714,-2.33445,.60642,49.16016,-2.24672,.61307,49.21252,-2.32681,.43538,49.11097,-2.45346,.43265,49.10505,-2.4287,.47934,49.22179,-2.40542,.48894,49.22737,-2.43634,.58754,49.07841,-2.2119,.59553,49.17795,-2.24734,.59699,49.06868,-2.21656,.55548,48.99416,-2.28748,.56356,48.97004,-2.22121,.55144,48.93114,-2.25363,.53677,48.90817,-2.29476,.53237,49.30924,-2.39382,.48087,49.19317,-2.37399,.54886,48.97687,-2.2142,.47785,49.0337,-2.32231};
			return value;
		}
		private double[] getlrib5_Coord_7_60_point_2()
		{
			double[] value = {.47055,48.97999,-2.33626,.54022,48.93004,-2.25237,.52995,49.09432,-2.55974,.45766,49.02301,-2.49542,.45884,49.10588,-2.49834,.50633,49.00167,-2.5563,.47278,48.96913,-2.48103,.52319,48.97583,-2.54801,.5648,48.97738,-2.5292,1.32652,49.32026,-3.0552,1.26054,49.42208,-3.00919,1.25329,49.31652,-3.00621,1.34783,49.42192,-3.05124,.92894,49.24163,-2.87521,.95626,49.2487,-2.89233,.9709,49.19816,-2.89547,.95439,49.43913,-2.86166,1.0776,49.48031,-2.90961,1.01519,49.47241,-2.91475,.99679,49.4507,-2.84707,.92072,49.3236,-2.87163,.70508,49.17245,-2.7159,.7353,49.29088,-2.69921,1.37988,49.42902,-3.2792,1.18107,49.52102,-3.19003,1.22867,49.54432,-3.15744,1.59605,49.2726,-3.36911,1.05747,49.34392,-3.00819,1.22772,49.26496,-3.16514,1.0555,49.3641,-3.01811,1.06227,49.16611,-2.94958,1.09029,49.1732,-2.92713,1.02796,49.18196,-2.89669,.97276,49.19997,-2.92313,1.03085,49.17773,-2.88726,.97511,49.2019,-2.90198,1.17401,49.19262,-3.00645,1.19545,49.1986,-3.00756,1.17668,49.2164,-2.94872,1.16484,49.20335,-2.95021,.95302,49.32677,-2.93192,.95183,49.29722,-2.89803,.95401,49.36025,-2.9356,.95968,49.28441,-2.90334,1.11544,49.1925,-2.92033,1.11261,49.19658,-2.90594,.77791,49.35203,-2.6912,.94032,49.40071,-2.86367,1.16168,49.38005,-3.15617,1.06846,49.46104,-3.08398,1.06717,49.42197,-3.06364,.98064,49.46818,-2.92595,.97036,49.43278,-2.94449,.95309,49.40836,-2.91026,.98293,49.47731,-2.95521,1.31237,49.23472,-3.05916,1.1481,49.24796,-3.05092,1.00964,49.35825,-2.9756,1.00116,49.32453,-2.96433,.9704,49.41557,-2.98119,1.00818,49.23168,-2.97163,1.03673,49.19383,-2.97124,.96349,49.24354,-2.92221,1.07993,49.28995,-3.00305,.969,49.24151,-2.89881,1.13564,49.16992,-2.98092,.94595,49.18849,-2.8743,2.44099,44.87994,2.63659,2.44018,44.78866,2.61417,2.58343,45.09247,2.53236,2.43124,44.9705,2.64284,2.59291,44.87901,2.52999,4.91879,47.24623,-.62032,4.56503,46.80338,.32858,5.00844,47.24217,-.60847,4.62071,46.78144,.34387,2.66496,45.46143,2.31837,2.43156,45.32402,2.45587,2.78097,45.4228,2.32207,2.53494,45.24046,2.52238,2.55014,44.78483,2.44808,2.85208,45.05063,2.2089,2.88354,44.97968,2.20202,2.52174,44.86561,2.42815,3.99206,46.28679,1.1421,3.41764,45.83853,1.76905,3.51165,45.69622,1.74845,3.57413,45.5055,1.70632,4.10725,45.96734,1.13846,4.0282,46.1261,1.15984,3.50121,45.3938,1.66838,4.08556,45.81982,1.06639,4.76077,46.52559,.24639,4.75488,46.41649,.13712,4.11747,45.83168,1.08467,5.01914,47.00518,-.90812,4.712,46.4181,.12409,4.85247,47.50729,-1.45207,4.69386,47.73497,-1.8535,4.89212,47.78922,-1.871};
			return value;
		}
		private double[] getlrib5_Coord_7_60_point_3()
		{
			double[] value = {5.02995,47.54053,-1.38183,4.90936,47.74441,-2.01321,5.08078,47.4864,-1.50064,4.72711,47.6694,-1.97675,4.60402,48.0167,-2.43183,4.56671,47.9433,-2.5727,4.1091,48.22652,-2.91271,4.17666,48.30141,-2.77095,2.49042,48.95326,-3.34733,2.1123,49.10972,-3.27178,2.06096,49.10452,-3.35524,2.52313,48.94718,-3.27803,2.60107,49.02919,-3.15431,2.97208,48.86762,-3.0811,2.62013,49.12538,-3.15999,2.99937,48.96036,-3.06873,1.85535,49.37468,-3.17204,2.20092,49.28018,-3.21051,1.82301,49.4428,-3.23137,2.18992,49.33911,-3.25059,1.68436,49.43253,-3.3352,2.01621,49.21242,-3.44821,1.62797,49.36249,-3.3598,2.0833,49.29899,-3.39702,1.50652,49.22964,-3.13939,1.55017,49.3037,-3.11939,1.55918,49.43077,-3.13264,1.51217,49.5389,-3.20275,1.37898,49.55199,-3.11732,.96759,49.46168,-2.98992,1.09225,49.21225,-3.01508,.69208,49.08405,-2.72011,1.02875,49.19396,-2.84535,1.03661,49.25955,-2.82285,.84935,49.16505,-2.67657,.77984,49.09023,-2.70534,.60469,49.04655,-2.45198,.64325,49.06535,-2.50513,.56888,49.02163,-2.36567,.50382,49.146,-2.30802,.51285,49.23041,-2.47998,.5417,49.32113,-2.4166,.56812,49.31621,-2.45757,.59545,49.31093,-2.32972,.675,49.20252,-2.47796,.64806,49.18623,-2.41931,.60169,49.11595,-2.26343,.60627,49.32569,-2.35303,.60708,49.0075,-2.64534,.65626,49.02973,-2.62703,1.03889,49.36188,-2.82835,.86649,49.29113,-2.66517,.94314,49.34584,-2.90689,1.08986,49.50796,-2.9869,1.02128,49.52937,-3.03829,.98924,49.50587,-3.01156,1.30225,49.55371,-3.14405,1.40043,49.46304,-3.28324,1.76254,49.18856,-3.18912,1.84411,49.26,-3.15364,2.18771,49.18012,-3.18426,4.12812,48.32207,-2.5438,3.62034,48.66904,-2.85148,3.59232,48.63994,-2.80502,4.17627,48.34217,-2.55816,4.44885,47.86954,-2.61798,5.11138,47.41,-1.61483,4.90429,47.67152,-2.157,5.1087,47.14734,-.68236,4.86648,47.195,-.69354,4.87728,47.23025,-.64796,5.15667,47.04586,-.77726,5.08014,46.98566,-.92142,4.70639,46.64802,.31007,3.52134,45.3945,1.68937,3.80819,46.18603,1.12711,3.37874,45.82469,1.67796,2.42875,44.74412,2.57349,2.57149,44.79775,2.49154,1.18495,49.31997,-3.15821,.99988,49.29049,-2.95951,1.07383,49.27683,-2.99586,1.13617,49.2419,-3.03886,1.24462,49.22902,-3.00749,1.02752,49.50391,-3.05475,.98969,49.50232,-3.0214,1.0135,49.52356,-3.04469,1.07107,49.498,-3.10438,1.01399,49.37705,-2.98608,1.08962,49.54478,-3.10848,1.16687,49.53516,-3.07466,1.4436,49.51093,-3.2717,1.35917,49.39972,-3.28051,1.11314,49.28283,-2.87617,1.18057,49.30523,-2.94528,1.16682,49.51083,-3.18947,1.07766,49.53755,-3.11265,.66974,49.23843,-2.47454,.76587,49.23458,-2.57657,.44321,49.01311,-2.3847};
			return value;
		}
		private double[] getlrib5_Coord_7_60_point_4()
		{
			double[] value = {.42589,49.04366,-2.42816,.44283,48.9904,-2.40747,.47751,48.94004,-2.36149,.52655,48.90914,-2.28858,1.22846,49.53858,-3.04385,1.36003,49.56027,-3.12558,4.55933,48.05434,-2.23,4.20769,48.33829,-2.62048,4.61711,48.05846,-2.26919,2.89358,48.88434,-3.36669,3.59058,48.63636,-3.05387,3.51891,48.55909,-3.17699,2.9646,48.97232,-3.28044,5.05229,46.98327,-.92863,2.90685,44.99018,2.2236,2.42271,44.81581,2.58852,2.45437,44.86407,2.53081,2.45566,44.8969,2.55482,2.32602,44.87426,2.50098,2.29114,45.22488,2.55504,2.41734,44.96847,2.61767,2.41586,44.96653,2.63865,2.28223,45.1536,2.5435,2.30498,45.04518,2.51439,1.38301,49.55659,-3.13748,1.48874,49.5494,-3.2304,2.82054,45.12207,2.21475,2.49301,44.9711,2.41622,2.44707,45.00331,2.54123,2.43112,45.01173,2.5216,2.43514,44.99248,2.5214,2.44058,45.03096,2.54049,2.43084,45.02619,2.52553,2.43209,45.03219,2.52906,2.42005,44.88019,2.62469,2.45269,44.94629,2.56299,2.41975,44.89227,2.60431,2.44996,44.99558,2.57022,2.43917,44.97702,2.52232,2.4021,44.94795,2.50248,2.4239,44.90566,2.51056,2.42494,44.79363,2.60759,2.39303,45.12523,2.61615,2.36976,45.11358,2.51755,2.3825,45.0311,2.50227,2.44596,44.86326,2.51751,4.47196,46.72585,.26543,4.5072,46.78221,.30127,4.5086,48.04195,-2.22549,2.6509,45.4511,2.29707,2.41813,45.31352,2.43487,2.89746,48.78547,-3.23251,3.47096,48.49661,-3.01683,4.46714,47.87342,-2.63585,3.42287,48.46347,-3.23676,3.54672,48.56943,-2.8259,3.00162,49.02736,-3.18544,3.62565,48.67168,-2.90825,3.00698,49.01631,-3.12904,2.62012,49.18316,-3.20716,2.59527,49.20459,-3.27214,2.53374,49.15015,-3.35474,2.46689,49.06347,-3.42044,1.6595,49.20024,-3.27271,3.98167,48.15273,-2.96849,3.99477,48.15572,-2.98939,2.1422,49.36928,-3.32589,1.7536,49.46771,-3.30377,.64084,49.24703,-2.4112,1.16536,49.50272,-2.964,1.24055,49.52889,-3.03561,1.1532,49.51265,-2.97022,1.02323,49.43188,-2.83717,1.08834,49.46938,-2.90218,.75004,49.30761,-2.56672,.82216,49.3645,-2.66337,.72245,49.32485,-2.57058,.84345,49.35147,-2.6568,.42912,49.03717,-2.45307,.4503,48.97547,-2.42935,.44713,49.07421,-2.37845,.61697,49.16006,-2.32627,.61416,49.30937,-2.51826,.74255,49.1203,-2.59899,.71676,49.06431,-2.71802,.98787,49.1711,-2.86084,.58376,49.03142,-2.64493,.68381,49.31848,-2.60439,.64672,49.25552,-2.61965,.60851,49.12641,-2.63914,1.10619,49.39255,-2.88723,1.17361,49.41466,-2.94943,2.44601,44.9497,2.52345,2.44914,44.95277,2.52875,2.94407,45.09194,2.26414,2.85844,45.27524,2.31915,2.71643,45.33836,2.23526,.57239,49.22525,-2.54123,2.45023,45.16442,2.40734,2.44818,44.97679,2.53475};
			return value;
		}
		private double[] getlrib5_Coord_7_60_point_5()
		{
			double[] value = {2.44762,44.98894,2.53765};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib6_Geo_6_65_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,11,12,9,-1,13,14,15,-1,14,16,15,-1,17,18,19,-1,20,21,22,-1,23,24,25,-1,25,26,23,-1,27,28,29,-1,30,31,32,-1,30,33,31,-1,34,35,36,-1,34,37,35,-1,38,39,40,-1,38,41,39,-1,42,19,43,-1,44,45,46,-1,44,47,45,-1,28,36,48,-1,48,41,28,-1,36,28,27,-1,27,34,36,-1,49,50,51,-1,49,52,50,-1,25,53,26,-1,54,55,56,-1,57,58,59,-1,60,61,62,-1,60,63,61,-1,64,65,66,-1,66,58,64,-1,67,68,55,-1,68,56,55,-1,69,70,71,-1,72,73,74,-1,72,75,73,-1,76,77,78,-1,76,79,77,-1,35,37,80,-1,81,74,73,-1,81,82,74,-1,83,84,85,-1,83,86,84,-1,87,88,89,-1,87,90,88,-1,91,92,32,-1,91,93,92,-1,71,94,95,-1,57,96,97,-1,57,59,96,-1,98,99,100,-1,99,62,100,-1,101,102,103,-1,101,104,102,-1,105,69,106,-1,106,107,105,-1,108,109,110,-1,110,111,108,-1,112,113,13,-1,13,15,112,-1,114,13,104,-1,115,109,116,-1,109,108,116,-1,98,100,117,-1,117,118,98,-1,37,119,120,-1,37,34,119,-1,39,121,122,-1,121,123,122,-1,124,125,126,-1,126,125,127,-1,127,128,126,-1,129,130,45,-1,130,46,45,-1,131,47,48,-1,47,44,48,-1,132,133,134,-1,135,136,137,-1,138,139,140,-1,139,141,140,-1,142,143,144,-1,144,145,142,-1,146,147,148,-1,148,149,146,-1,150,151,152,-1,152,153,150,-1,145,154,155,-1,145,152,154,-1,156,128,157,-1,156,126,128,-1,155,154,158,-1,124,159,160,-1,161,155,158,-1,158,162,161,-1,163,164,165,-1,166,163,167,-1,163,165,167,-1,159,168,169,-1,159,170,168,-1,171,172,173,-1,21,20,174,-1,175,176,132,-1,175,177,176,-1,178,38,179,-1,162,180,181,-1,162,182,180,-1,163,183,164,-1,115,116,184,-1,116,185,184,-1,107,106,186,-1,186,187,107,-1,188,97,189,-1,190,16,191,-1,192,6,8,-1,192,193,6,-1,113,102,13,-1,102,104,13,-1,5,4,194,-1,4,195,194,-1,196,197,198,-1,199,200,201,-1,199,202,200,-1,203,204,205,-1,203,206,204,-1,207,120,119,-1,207,208,120,-1,189,96,111,-1,189,97,96,-1,209,71,70,-1,209,94,71,-1,210,211,212,-1,212,213,210,-1,65,93,66,-1,65,92,93,-1,67,214,68,-1,67,215,214,-1,72,216,217,-1,217,78,72,-1,218,219,54,-1,218,220,219,-1,221,68,214,-1,221,222,68,-1,74,216,72,-1,74,223,216,-1,224,220,225,-1,220,218,225,-1,224,226,220,-1,224,227,226,-1,228,227,224,-1,224,229,228,-1,230,231,232,-1,230,233,231,-1,60,234,235,-1,60,236,234,-1,237,238,239,-1,239,89,237,-1,63,240,61,-1,63,241,240,-1,98,242,243,-1,243,99,98,-1,18,244,19,-1,245,246,118,-1,245,247,246,-1,29,178,27,-1,248,50,178,-1,17,249,18,-1,249,250,18,-1,251,252,194,-1,194,253,251,-1,121,39,254,-1,39,41,254,-1,255,125,256,-1,255,127,125,-1,257,256,258,-1,257,255,256,-1,259,260,261,-1,261,262,259,-1,263,127,255,-1,263,130,127,-1,134,133,264,-1,133,265,264,-1,266,267,268,-1,266,269,267,-1,252,251,270,-1,248,178,179,-1,179,4,248,-1,52,27,178,-1,178,50,52,-1,271,272,252,-1,252,273,271,-1,29,38,178,-1,246,247,274,-1,247,275,274,-1,26,174,20,-1,26,53,174,-1,246,274,242,-1,274,276,242,-1,277,244,18,-1,278,241,279,-1,278,240,241,-1,241,63,280,-1,280,281,241,-1,232,281,280,-1,232,231,281,-1,282,283,284,-1,282,285,283,-1,286,81,287,-1,286,288,81,-1,223,214,216,-1,223,221,214,-1,289,54,56,-1,289,218,54,-1,216,214,217,-1,214,215,217,-1,211,210,217,-1,217,215,211,-1,92,30,32,-1,78,210,76,-1,78,217,210,-1,290,206,203,-1,290,291,206,-1,292,293,294,-1,292,295,293,-1,73,287,81,-1,15,16,190,-1,296,86,297,-1,297,276,296,-1,298,1,299,-1,298,300,1,-1,301,192,12,-1,192,8,12,-1,14,13,114,-1,71,95,106,-1,106,69,71,-1,302,187,303,-1,187,186,303,-1,110,189,111,-1,110,304,189,-1,103,184,305,-1,184,185,305,-1,24,134,25,-1,175,132,306,-1,307,17,308,-1,309,166,310,-1,310,311,309,-1,138,312,142,-1,312,143,142,-1};
			return value;
		}
		private int[] getlrib6_Geo_6_65_coordIndex_2()
		{
			int[] value = {160,159,169,-1,313,309,180,-1,181,314,141,-1,141,139,181,-1,315,257,258,-1,315,316,257,-1,317,183,171,-1,317,164,183,-1,162,318,182,-1,162,158,318,-1,145,155,161,-1,161,142,145,-1,165,169,168,-1,169,258,160,-1,258,256,160,-1,319,320,321,-1,153,152,145,-1,147,322,148,-1,322,151,148,-1,323,149,148,-1,142,139,138,-1,142,161,139,-1,135,324,201,-1,135,325,324,-1,326,317,171,-1,171,173,326,-1,44,46,254,-1,47,327,45,-1,201,328,199,-1,329,270,251,-1,308,42,49,-1,49,51,308,-1,271,273,249,-1,308,19,42,-1,274,296,276,-1,274,330,296,-1,209,331,94,-1,331,332,94,-1,215,64,211,-1,215,67,64,-1,204,206,70,-1,70,69,204,-1,190,191,333,-1,105,334,204,-1,204,69,105,-1,12,335,301,-1,12,11,335,-1,115,10,109,-1,115,336,10,-1,337,104,101,-1,337,114,104,-1,297,242,276,-1,297,243,242,-1,292,294,338,-1,332,292,94,-1,332,213,292,-1,339,290,340,-1,208,341,120,-1,208,84,341,-1,89,85,237,-1,89,88,85,-1,342,343,344,-1,344,345,342,-1,43,345,344,-1,80,330,346,-1,346,35,80,-1,83,297,86,-1,347,207,348,-1,347,238,207,-1,82,288,349,-1,82,81,288,-1,73,227,287,-1,73,226,227,-1,78,75,72,-1,78,77,75,-1,291,70,206,-1,291,209,70,-1,21,174,100,-1,174,117,100,-1,67,65,64,-1,67,55,65,-1,289,350,351,-1,289,222,350,-1,62,21,100,-1,62,61,21,-1,352,116,108,-1,352,353,116,-1,66,354,355,-1,244,277,22,-1,22,21,244,-1,249,273,177,-1,248,51,50,-1,248,356,51,-1,17,19,308,-1,44,41,48,-1,44,254,41,-1,34,52,343,-1,34,27,52,-1,179,195,4,-1,40,179,38,-1,76,332,331,-1,23,20,22,-1,23,26,20,-1,24,132,134,-1,24,306,132,-1,177,273,176,-1,273,357,176,-1,85,88,83,-1,11,10,336,-1,9,12,8,-1,8,7,9,-1,5,272,3,-1,272,271,3,-1,358,154,322,-1,359,360,361,-1,133,132,176,-1,362,359,363,-1,362,364,359,-1,364,360,359,-1,363,365,362,-1,259,153,145,-1,196,153,259,-1,365,310,362,-1,311,310,365,-1,320,366,172,-1,366,320,146,-1,196,150,153,-1,150,196,198,-1,356,4,3,-1,248,4,356,-1,307,3,271,-1,307,356,3,-1,357,133,176,-1,133,357,328,-1,52,344,343,-1,49,344,52,-1,41,29,28,-1,41,38,29,-1,367,368,122,-1,367,253,368,-1,1,265,2,-1,1,300,265,-1,369,174,53,-1,117,174,369,-1,280,283,232,-1,280,235,283,-1,351,230,285,-1,351,350,230,-1,289,68,222,-1,56,68,289,-1,53,370,369,-1,53,264,370,-1,209,371,331,-1,209,291,371,-1,288,372,349,-1,288,373,372,-1,239,347,374,-1,239,238,347,-1,348,119,342,-1,348,207,119,-1,84,296,341,-1,84,86,296,-1,267,35,346,-1,35,267,131,-1,342,278,348,-1,278,342,345,-1,227,286,287,-1,227,228,286,-1,237,84,208,-1,237,85,84,-1,375,290,203,-1,375,340,290,-1,376,377,378,-1,379,377,376,-1,94,338,95,-1,94,292,338,-1,14,337,334,-1,14,114,337,-1,187,191,107,-1,187,333,191,-1,380,381,302,-1,380,193,381,-1,382,7,6,-1,304,7,382,-1,109,9,110,-1,109,10,9,-1,184,336,115,-1,184,383,336,-1,384,193,192,-1,381,193,384,-1,113,383,102,-1,113,335,383,-1,188,293,97,-1,188,385,293,-1,380,303,385,-1,303,380,302,-1,101,205,337,-1,101,386,205,-1,305,375,386,-1,379,375,305,-1,211,58,212,-1,211,64,58,-1,213,295,292,-1,213,212,295,-1,93,354,66,-1,354,93,378,-1,291,339,371,-1,290,339,291,-1,275,330,274,-1,275,346,330,-1,387,369,370,-1,245,369,387,-1,51,307,308,-1,356,307,51,-1,388,329,367,-1,388,202,329,-1,270,328,357,-1,270,199,328,-1,135,366,325,-1,135,137,366,-1,328,324,133,-1,201,324,328,-1,358,147,319,-1,358,322,147,-1,323,151,150,-1,148,151,323,-1,389,136,200,-1,389,390,136,-1,45,391,129,-1,391,45,327,-1,258,165,315,-1,165,258,169,-1,321,182,318,-1,182,321,392,-1,164,315,165,-1,315,164,317,-1,143,156,144,-1,143,393,156,-1,125,160,256,-1,124,160,125,-1,394,395,396,-1,395,394,397,-1,138,398,312,-1,140,398,138,-1,309,181,180,-1,309,314,181,-1,395,399,396,-1,395,170,399,-1,400,170,395,-1,400,361,360,-1};
			return value;
		}
		private int[] getlrib6_Geo_6_65_coordIndex_3()
		{
			int[] value = {361,400,395,-1,140,401,398,-1,359,401,140,-1,398,402,397,-1,401,402,398,-1,360,403,400,-1,360,364,403,-1,18,404,277,-1,404,18,250,-1,306,250,175,-1,306,404,250,-1,24,404,306,-1,24,23,404,-1,395,402,361,-1,402,395,397,-1,311,314,309,-1,311,365,314,-1,334,205,204,-1,337,205,334,-1,304,188,189,-1,188,304,382,-1,15,384,112,-1,384,15,190,-1,133,2,265,-1,133,324,2,-1,370,298,387,-1,370,300,298,-1,405,266,268,-1,405,406,266,-1,197,407,408,-1,407,197,262,-1,409,47,269,-1,47,409,327,-1,391,260,157,-1,391,261,260,-1,323,2,149,-1,2,323,0,-1,168,167,165,-1,168,403,167,-1,410,123,121,-1,123,410,411,-1,185,353,377,-1,185,116,353,-1,186,95,338,-1,186,106,95,-1,379,340,375,-1,376,340,379,-1,31,371,339,-1,31,79,371,-1,77,31,33,-1,77,79,31,-1,30,65,55,-1,65,30,92,-1,412,30,219,-1,30,412,33,-1,226,219,220,-1,226,412,219,-1,413,221,223,-1,413,414,221,-1,233,350,414,-1,233,230,350,-1,413,349,415,-1,349,413,82,-1,416,349,372,-1,415,349,416,-1,282,417,229,-1,282,284,417,-1,373,286,87,-1,373,288,286,-1,231,418,281,-1,231,416,418,-1,235,284,283,-1,284,235,234,-1,88,417,419,-1,90,417,88,-1,419,83,88,-1,420,83,419,-1,279,281,418,-1,279,241,281,-1,279,348,278,-1,348,279,347,-1,83,243,297,-1,83,420,243,-1,278,244,240,-1,345,244,278,-1,246,98,118,-1,242,98,246,-1,25,264,53,-1,264,25,134,-1,247,268,275,-1,247,405,268,-1,131,36,35,-1,131,48,36,-1,272,194,252,-1,194,272,5,-1,387,406,405,-1,298,406,387,-1,298,408,406,-1,298,299,408,-1,121,46,410,-1,121,254,46,-1,389,202,388,-1,200,202,389,-1,130,410,46,-1,410,130,263,-1,390,411,421,-1,389,411,390,-1,262,409,407,-1,262,261,409,-1,257,263,255,-1,421,263,257,-1,358,321,318,-1,321,358,319,-1,173,136,326,-1,137,136,173,-1,394,143,312,-1,394,393,143,-1,163,392,183,-1,392,163,313,-1,316,421,257,-1,316,390,421,-1,145,260,259,-1,145,144,260,-1,200,135,201,-1,200,136,135,-1,411,263,421,-1,411,410,263,-1,1,198,299,-1,0,198,1,-1,388,411,389,-1,388,123,411,-1,269,407,409,-1,269,266,407,-1,368,194,195,-1,194,368,253,-1,405,245,387,-1,247,245,405,-1,345,19,244,-1,345,43,19,-1,240,21,61,-1,244,21,240,-1,99,420,236,-1,99,243,420,-1,237,207,238,-1,208,207,237,-1,99,60,62,-1,99,236,60,-1,374,279,418,-1,347,279,374,-1,419,236,420,-1,236,419,234,-1,87,239,373,-1,87,89,239,-1,234,417,284,-1,417,234,419,-1,372,418,416,-1,372,374,418,-1,229,90,228,-1,229,417,90,-1,233,416,231,-1,233,415,416,-1,229,225,282,-1,229,224,225,-1,415,414,413,-1,415,233,414,-1,225,285,282,-1,285,225,351,-1,82,223,74,-1,82,413,223,-1,222,414,350,-1,414,222,221,-1,351,218,289,-1,218,351,225,-1,412,73,75,-1,226,73,412,-1,219,55,54,-1,219,30,55,-1,33,75,77,-1,412,75,33,-1,91,31,339,-1,32,31,91,-1,213,76,210,-1,76,213,332,-1,354,352,355,-1,353,352,354,-1,338,303,186,-1,303,338,294,-1,185,379,305,-1,379,185,377,-1,80,120,341,-1,120,80,37,-1,172,321,320,-1,172,171,321,-1,262,196,259,-1,262,197,196,-1,299,197,408,-1,198,197,299,-1,157,144,156,-1,157,260,144,-1,261,327,409,-1,261,391,327,-1,131,269,47,-1,131,267,269,-1,408,266,406,-1,266,408,407,-1,40,195,179,-1,368,195,40,-1,320,147,146,-1,319,147,320,-1,383,11,336,-1,383,335,11,-1,190,381,384,-1,190,333,381,-1,295,97,293,-1,295,57,97,-1,365,141,314,-1,141,365,363,-1,394,124,393,-1,394,396,124,-1,403,362,167,-1,403,364,362,-1,313,182,392,-1,313,180,182,-1,162,139,161,-1,139,162,181,-1,277,23,22,-1,404,23,277,-1,249,175,250,-1,175,249,177,-1,273,270,357,-1,273,252,270,-1,167,310,166,-1,362,310,167,-1,396,159,124,-1,159,399,170,-1,396,399,159,-1,163,309,313,-1,163,166,309,-1,312,397,394,-1,397,312,398,-1,400,168,170,-1,400,403,168,-1,317,316,315,-1,326,316,317,-1,183,321,171,-1,183,392,321,-1,126,393,124,-1,156,393,126,-1,129,157,128,-1,157,129,391,-1};
			return value;
		}
		private int[] getlrib6_Geo_6_65_coordIndex_4()
		{
			int[] value = {390,326,136,-1,390,316,326,-1,154,151,322,-1,152,151,154,-1,0,150,198,-1,323,150,0,-1,318,154,358,-1,318,158,154,-1,141,359,140,-1,141,363,359,-1,325,146,149,-1,146,325,366,-1,137,172,366,-1,137,173,172,-1,128,130,129,-1,128,127,130,-1,367,123,388,-1,122,123,367,-1,117,245,118,-1,117,369,245,-1,267,275,268,-1,267,346,275,-1,339,376,91,-1,376,339,340,-1,57,212,58,-1,295,212,57,-1,386,103,305,-1,386,101,103,-1,203,386,375,-1,205,386,203,-1,385,294,293,-1,294,385,303,-1,385,382,380,-1,382,385,188,-1,113,301,335,-1,301,113,112,-1,112,192,301,-1,112,384,192,-1,16,107,191,-1,16,105,107,-1,9,304,110,-1,9,7,304,-1,6,380,382,-1,6,193,380,-1,302,333,187,-1,302,381,333,-1,16,334,105,-1,16,14,334,-1,103,383,184,-1,103,102,383,-1,91,378,93,-1,376,378,91,-1,378,353,354,-1,378,377,353,-1,87,228,90,-1,286,228,87,-1,341,330,80,-1,330,341,296,-1,342,34,343,-1,342,119,34,-1,373,374,372,-1,373,239,374,-1,331,79,76,-1,331,371,79,-1,59,66,355,-1,59,58,66,-1,355,96,59,-1,355,352,96,-1,232,285,230,-1,232,283,285,-1,63,235,280,-1,235,63,60,-1,300,264,265,-1,370,264,300,-1,251,367,329,-1,251,253,367,-1,122,40,39,-1,122,368,40,-1,43,49,42,-1,344,49,43,-1,270,202,199,-1,329,202,270,-1,307,249,17,-1,307,271,249,-1,352,111,96,-1,352,108,111,-1,149,324,325,-1,324,149,2,-1,361,401,359,-1,402,401,361,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib6_Coord_7_65_point_1()
		{
			double[] value = {.70565,48.51596,-2.76259,.74345,48.53101,-2.80957,.70901,48.54626,-2.79945,1.02952,48.3926,-3.20608,1.04318,48.29371,-3.20457,.98768,48.34944,-3.15944,2.70386,44.08999,2.55927,2.67475,44.17127,2.53099,2.72848,44.12483,2.51577,2.66474,44.18806,2.50406,2.66207,44.18481,2.48858,2.70837,44.14517,2.46184,2.71974,44.15806,2.48754,2.82305,43.87408,2.35792,2.80464,43.73622,2.34212,2.82904,43.87685,2.40237,2.81472,43.73578,2.36285,1.11999,48.54755,-3.28705,1.25035,48.60495,-3.33839,1.23877,48.58328,-3.37534,1.28423,48.68484,-3.28756,1.8581,48.71534,-3.59888,1.26869,48.65503,-3.31983,1.11816,48.63136,-3.18124,1.07985,48.62267,-3.13522,1.07831,48.64639,-3.14119,1.12577,48.66362,-3.17571,1.29997,48.31733,-3.38386,1.25547,48.2407,-3.2723,1.24627,48.23978,-3.27819,4.65717,45.64019,.27021,4.34259,44.93808,1.01326,4.28263,45.09213,1.04477,4.70091,45.45609,.18469,1.32467,48.31305,-3.38659,1.26914,48.26533,-3.2359,1.26608,48.24545,-3.26338,1.34843,48.31741,-3.34703,1.14405,48.20489,-3.18731,.96299,48.22686,-3.06413,.96806,48.23286,-3.07176,1.14677,48.20323,-3.17902,1.24788,48.49278,-3.41499,1.25791,48.49327,-3.42141,.92182,48.18374,-2.95741,.81513,48.14359,-2.83044,.79189,48.16439,-2.83777,.93884,48.18155,-2.94833,1.16158,48.20604,-3.17291,1.26041,48.40625,-3.4329,1.19588,48.33345,-3.34944,1.18291,48.40667,-3.36019,1.28095,48.34631,-3.41086,1.16605,48.66002,-3.15966,4.96253,46.28119,-.41047,4.71103,45.84305,.40518,4.98876,46.27869,-.37866,3.28852,44.53879,2.2186,3.65569,44.8325,1.93907,3.27319,44.58161,2.21131,2.72997,48.52309,-3.62351,2.2874,48.65728,-3.67692,2.29443,48.65184,-3.6419,2.73416,48.53193,-3.66125,4.28026,45.34721,1.18582,4.27142,45.34738,1.17396,3.65841,44.83512,1.88978,4.7248,45.84252,.41114,5.02166,46.27075,-.37683,2.84103,43.7101,2.33812,3.0169,43.80949,2.23166,3.01355,43.83409,2.29514,5.12761,45.88493,-.60017,5.09118,46.39509,-1.50294,5.13741,46.39022,-1.50758,5.06744,45.85885,-.62995,4.45764,44.86784,1.07744,4.8181,45.37004,.20405,4.84704,45.38848,.22967,4.4476,44.85765,1.05719,1.35367,48.30499,-3.31333,4.8553,46.85349,-2.2932,4.88733,46.85991,-2.29989,2.61247,48.28977,-3.62015,2.18635,48.33012,-3.66406,2.59797,48.27531,-3.64817,2.19655,48.35725,-3.63598,3.99895,47.60632,-3.19591,3.20758,48.01857,-3.44537,3.2283,47.97871,-3.58139,3.93498,47.63622,-3.09334,3.68411,44.56453,1.76975,4.2585,45.19173,1.07423,3.67288,44.72218,1.8301,3.43718,44.14669,2.07468,3.0033,43.87099,2.3368,2.84402,44.32935,2.46318,2.86623,44.27098,2.48304,1.89958,48.60443,-3.54137,2.29088,48.56356,-3.54717};
			return value;
		}
		private double[] getlrib6_Coord_7_65_point_2()
		{
			double[] value = {1.88359,48.70413,-3.58237,2.76407,43.83879,2.32463,2.74385,43.96999,2.36855,2.73641,43.97217,2.35374,2.7658,43.83871,2.34233,2.81929,43.71363,2.35388,2.83793,43.76845,2.43721,2.79927,43.77979,2.45312,2.67958,44.22652,2.48177,2.65757,44.19765,2.48906,2.66221,44.2062,2.51475,2.68798,44.22658,2.52155,2.80366,43.98615,2.43922,2.78854,43.98849,2.40217,2.78483,43.77486,2.33917,2.67204,44.15393,2.43824,2.70431,44.19814,2.4061,1.34422,48.63523,-3.22823,1.36281,48.57535,-3.22245,1.78152,48.35787,-3.72221,1.81309,48.37309,-3.66868,.87782,48.21949,-2.97592,.93841,48.26118,-3.04919,.8517,48.26403,-2.97303,.57346,48.09056,-2.61248,.59043,48.0903,-2.62606,.58769,48.08053,-2.60717,.64827,48.10918,-2.67387,.66062,48.10793,-2.66816,.74307,48.13079,-2.74995,.73009,48.13135,-2.75836,1.14386,48.23008,-3.1402,.94055,48.57218,-3.0144,.83914,48.55414,-2.92126,.94922,48.58597,-3.00934,.64656,48.50409,-2.76143,.64723,48.44008,-2.77197,.64136,48.50335,-2.75446,.57365,48.19076,-2.5599,.57675,48.21003,-2.55095,.55893,48.19469,-2.55705,.56364,48.21133,-2.5515,.61125,48.1384,-2.51783,.6051,48.10439,-2.52883,.61638,48.10342,-2.53188,.62431,48.14519,-2.52273,.64058,48.55613,-2.72986,.66645,48.50574,-2.69061,.67199,48.50495,-2.70938,.65343,48.55866,-2.74664,.69888,48.43292,-2.68167,.68489,48.43198,-2.66457,.68454,48.33583,-2.62956,.70564,48.33651,-2.64034,.67714,48.33227,-2.5984,.6291,48.16155,-2.51513,.59002,48.07457,-2.57151,.67268,48.11634,-2.65793,.64277,48.30636,-2.5129,.57527,48.13676,-2.64511,.58056,48.1252,-2.65524,.61656,48.1571,-2.51361,.62717,48.29955,-2.5068,.53764,48.34862,-2.58387,.54185,48.39596,-2.61876,.53153,48.29573,-2.61834,.53229,48.33113,-2.57785,.53055,48.28571,-2.60719,.54673,48.19458,-2.63253,.54671,48.18959,-2.63903,.564,48.15836,-2.63106,.57506,48.48251,-2.62636,.60209,48.52484,-2.68401,.59491,48.49215,-2.67342,1.31278,48.68546,-3.25397,1.05673,48.56732,-3.13269,.93581,48.56222,-3.01534,1.01969,48.554,-3.13892,1.17204,48.2535,-3.31194,1.05881,48.22929,-3.19123,.55946,48.33632,-2.54666,.57696,48.27042,-2.54254,.61116,48.40117,-2.52736,.56506,48.46574,-2.60876,2.70838,44.10411,2.3994,2.72645,44.12716,2.35622,2.80458,43.86862,2.53206,2.78572,43.86592,2.52851,2.72072,44.10369,2.58419,2.69037,44.20382,2.55224,2.83624,43.88035,2.4554,2.79402,43.80378,2.46095,2.7822,44.07859,2.50064,2.73208,44.0022,2.5601,.96131,48.34361,-3.10327,.99471,48.27963,-3.1238,.72672,48.3504,-2.67818,.74416,48.36068,-2.70947,.72021,48.43245,-2.71853,.82391,48.49606,-2.94221};
			return value;
		}
		private double[] getlrib6_Coord_7_65_point_3()
		{
			double[] value = {.70003,48.45249,-2.8393,.70329,48.51505,-2.82563,.8129,48.44479,-2.95651,3.00668,43.89603,2.15623,2.83431,43.7068,2.3147,2.82922,43.78733,2.2852,3.01744,43.81489,2.20142,2.14673,48.25037,-3.80226,2.16137,48.28698,-3.73879,3.46233,44.06488,1.99908,4.40132,45.08019,1.19876,4.34209,45.20857,1.18538,3.70521,44.68346,1.96125,3.76603,44.53523,1.88846,5.08349,46.20655,-.40495,4.77752,45.72645,.37333,5.14398,46.01467,-.52105,4.83812,45.59151,.32928,5.00586,46.72953,-1.28225,4.91103,46.09986,-.52496,4.93222,46.61452,-1.35644,5.16899,46.68816,-1.29973,5.11459,46.72589,-1.27553,5.19268,46.51474,-1.42924,4.80501,47.02185,-2.03262,4.89526,47.10573,-1.96249,4.961,46.45245,-1.46221,4.73736,46.91663,-2.15587,4.46524,47.28347,-2.64062,4.52126,47.38266,-2.58063,4.64776,47.49432,-2.59464,4.18745,47.79898,-3.13298,4.15414,47.83121,-3.04134,4.68201,47.43579,-2.66969,3.28083,48.22785,-3.3755,3.32636,48.26175,-3.4506,2.70393,48.46566,-3.54573,2.57119,48.20268,-3.77437,2.57519,48.15161,-3.84341,3.2295,47.93538,-3.67831,2.20422,48.58496,-3.74721,2.70981,48.47144,-3.74238,1.90314,48.51009,-3.53416,2.25781,48.44525,-3.5679,1.82176,48.63074,-3.70247,1.22238,48.56151,-3.13981,1.37488,48.4933,-3.23019,1.24316,48.48307,-3.13949,1.09751,48.30864,-3.28061,1.0348,48.56327,-3.21047,1.11297,48.58735,-3.20363,.88852,48.43947,-3.0398,.93144,48.44282,-3.12038,.91214,48.32822,-3.03997,.90472,48.19322,-2.96533,.61782,48.13213,-2.68875,.60611,48.1293,-2.67533,.5891,48.19935,-2.68005,.57516,48.19534,-2.67013,.70334,48.23414,-2.63712,.69409,48.15846,-2.64633,.76941,48.17645,-2.71705,.7568,48.27758,-2.71283,.69378,48.17451,-2.77774,.96889,48.5871,-2.99985,.85279,48.5574,-2.91254,.93887,48.32265,-2.90812,1.13511,48.27159,-3.08696,1.11627,48.35663,-3.05209,.95399,48.22897,-2.92324,.89357,48.46538,-3.02709,1.01332,48.47917,-3.22495,.96978,48.41718,-3.17053,.96674,48.5003,-3.13453,1.37028,48.39272,-3.26257,1.26565,48.37496,-3.16977,1.87667,48.4253,-3.5652,1.26499,48.62266,-3.34182,2.14457,48.42233,-3.79031,2.63944,48.30705,-3.82203,3.33978,48.26456,-3.4887,3.34829,48.21929,-3.56389,4.5689,47.49098,-2.56449,4.12505,47.83291,-3.01223,4.06645,47.82411,-2.98183,4.61363,47.4983,-2.57444,4.49837,47.27987,-2.77226,4.80459,46.88108,-2.23348,4.52116,47.22422,-2.85181,5.07266,46.73207,-1.27413,3.43119,44.13974,1.9177,3.46172,44.0624,1.9717,3.40255,44.25612,2.16359,2.89341,44.14769,2.49415,2.93785,44.05324,2.47393,3.34151,44.41818,2.22773,1.85672,48.36115,-3.58987,2.2192,48.38397,-3.6133,.89237,48.48216,-2.90233,.79002,48.45121,-2.80112};
			return value;
		}
		private double[] getlrib6_Coord_7_65_point_4()
		{
			double[] value = {.87201,48.53564,-2.90452,2.76802,44.09874,2.46637,2.76051,43.9329,2.56236,2.77715,43.93912,2.5747,2.67349,44.1783,2.53895,2.76195,43.99242,2.31513,1.07015,48.58995,-3.13645,1.07941,48.46037,-3.29184,1.16874,48.48768,-3.36877,.54909,48.32743,-2.54557,.53739,48.2389,-2.57522,.54177,48.2456,-2.56833,.56492,48.17091,-2.56309,.55606,48.34562,-2.54951,.56663,48.26201,-2.54273,.55259,48.31605,-2.6422,.58404,48.32779,-2.6726,.55459,48.40175,-2.63666,.62525,48.40038,-2.52854,.63755,48.49817,-2.65574,.61188,48.52579,-2.67451,.58831,48.47159,-2.58236,.68718,48.43702,-2.63607,.67735,48.506,-2.71667,.70854,48.54358,-2.81767,.64608,48.5598,-2.75139,.58348,48.41304,-2.67012,.82769,48.15712,-2.82135,.83376,48.528,-2.93074,.88246,48.4403,-3.03231,1.36507,48.31464,-3.28925,3.83572,44.32645,1.77976,3.80837,44.41015,1.82957,2.7831,43.8726,2.5195,2.80968,43.71637,2.32718,2.75466,44.10568,2.43518,2.67749,44.14935,2.44755,2.78291,43.76561,2.32305,2.96796,43.99378,2.43973,3.73703,44.37813,1.73286,3.40603,44.1935,1.91947,1.83878,48.34502,-3.61913,1.77195,48.37779,-3.74335,1.29042,48.34694,-3.41759,1.26954,48.40713,-3.43982,1.79112,48.49877,-3.73338,1.27666,48.29941,-3.19619,2.57803,48.1599,-3.86669,2.14391,48.26329,-3.82238,4.54374,47.22524,-2.86299,4.98617,47.11273,-1.99788,4.95107,47.11653,-1.97771,2.83881,44.3283,2.41344,2.8451,44.30297,2.34002,3.25772,44.56163,2.12797,3.26505,44.57577,2.16315,1.10738,48.39212,-3.29464,.91971,48.52748,-3.0188,.67018,48.43476,-2.61711,.54361,48.22018,-2.57009,.54041,48.22014,-2.58171,.5408,48.21407,-2.58012,.53747,48.2334,-2.57663,.54497,48.22522,-2.5685,.53833,48.22588,-2.5811,.5455,48.23906,-2.56641,.63545,48.55744,-2.73753,.90524,48.32674,-3.03265,.94245,48.26616,-3.05491,1.21057,48.61673,-3.14074,.98625,48.56142,-2.99085,3.83203,44.31907,1.75704,4.05493,47.5646,-3.29857,4.02961,47.5606,-3.28384,3.24545,47.94365,-3.70197,2.98359,43.97677,2.15944,3.34592,44.32865,1.96818,2.91588,44.21767,2.2471,3.28918,44.47167,2.04363,2.95904,44.09576,2.18522,2.73241,44.00253,2.57265,2.75906,43.93403,2.55327,2.70318,44.09159,2.56818,2.71393,44.10123,2.40818,2.81355,43.97685,2.48924,2.74492,44.01764,2.5846,2.79825,43.86014,2.28711,1.03183,48.51133,-3.0078,.82569,48.34177,-2.96473,.71426,48.35311,-2.84055,.65479,48.34889,-2.77832,.75434,48.1422,-2.7353,.57928,48.45781,-2.56827,.57732,48.0798,-2.56941,.55598,48.15172,-2.58414,.55203,48.15996,-2.59958,.56215,48.14268,-2.60858,.5473,48.16316,-2.57965,.55435,48.17916,-2.56167,.5627,48.14487,-2.6111};
			return value;
		}
		private double[] getlrib6_Coord_7_65_point_5()
		{
			double[] value = {.55369,48.1717,-2.61637,.5424,48.21507,-2.57131,.54062,48.20952,-2.57646,.54115,48.1996,-2.61636,1.11556,48.60316,-3.19599,1.09374,48.44294,-3.02463,.92446,48.41208,-2.89498,.83403,48.30508,-2.79662,.82112,48.39131,-2.79247,.84267,48.20208,-2.80452,.75422,48.20086,-2.84489,.73281,48.24194,-2.84907,4.94112,45.94052,-.61413,4.95595,46.92022,-2.20346,5.03364,47.07571,-2.03926,4.6059,47.32404,-2.86449,4.14002,47.63472,-3.26672,3.99645,47.73556,-3.02228,3.32877,48.03793,-3.6562,3.22975,48.11473,-3.39397,2.65039,48.35453,-3.5642,.66977,48.22537,-2.77876};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib7_Geo_6_70_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,20,22,21,-1,23,24,15,-1,17,5,6,-1,17,16,5,-1,25,26,27,-1,28,18,17,-1,29,30,31,-1,30,32,31,-1,13,33,14,-1,30,29,34,-1,35,36,37,-1,36,34,37,-1,38,39,40,-1,40,41,38,-1,42,13,43,-1,42,44,13,-1,45,46,47,-1,48,49,50,-1,1,0,51,-1,52,53,54,-1,55,56,57,-1,57,58,55,-1,59,60,54,-1,61,62,63,-1,61,64,62,-1,53,65,58,-1,53,64,65,-1,58,66,55,-1,58,65,66,-1,67,66,68,-1,68,69,67,-1,70,71,72,-1,73,74,72,-1,72,71,73,-1,75,76,77,-1,76,78,77,-1,79,80,81,-1,80,82,81,-1,83,84,85,-1,85,86,83,-1,87,86,85,-1,87,88,86,-1,89,90,91,-1,92,93,94,-1,93,95,94,-1,4,96,97,-1,96,89,97,-1,98,94,99,-1,19,95,100,-1,101,96,4,-1,102,103,104,-1,103,105,104,-1,106,107,108,-1,107,29,108,-1,109,110,42,-1,42,43,109,-1,111,15,24,-1,24,112,111,-1,100,113,20,-1,20,19,100,-1,110,114,112,-1,101,3,111,-1,111,112,101,-1,115,116,117,-1,25,118,119,-1,119,26,25,-1,84,83,120,-1,120,121,84,-1,122,123,124,-1,122,115,123,-1,125,126,127,-1,128,129,130,-1,129,131,130,-1,77,132,75,-1,132,133,75,-1,134,135,136,-1,137,138,139,-1,137,140,138,-1,137,141,142,-1,137,143,141,-1,144,145,146,-1,144,147,145,-1,148,44,149,-1,2,150,151,-1,151,0,2,-1,152,153,1,-1,153,154,1,-1,126,155,156,-1,155,157,156,-1,93,109,158,-1,93,92,109,-1,159,32,160,-1,72,74,161,-1,161,162,72,-1,77,163,144,-1,144,132,77,-1,164,68,165,-1,164,166,68,-1,167,168,169,-1,168,170,169,-1,171,172,173,-1,172,167,173,-1,174,169,175,-1,169,176,175,-1,177,178,179,-1,178,180,179,-1,70,181,182,-1,181,183,182,-1,184,183,185,-1,184,186,183,-1,187,179,188,-1,188,189,187,-1,190,191,162,-1,190,192,191,-1,193,182,194,-1,182,186,194,-1,71,193,195,-1,195,73,71,-1,196,197,198,-1,196,194,197,-1,147,141,145,-1,147,199,141,-1,78,195,200,-1,78,73,195,-1,75,133,201,-1,133,202,201,-1,203,204,205,-1,205,206,203,-1,12,0,207,-1,12,51,0,-1,35,208,126,-1,209,210,211,-1,212,210,213,-1,214,210,215,-1,210,216,211,-1,46,48,217,-1,218,219,220,-1,218,221,219,-1,51,152,1,-1,159,222,223,-1,222,27,223,-1,224,225,226,-1,4,3,101,-1,89,98,90,-1,98,99,90,-1,91,97,89,-1,13,227,43,-1,227,228,41,-1,41,229,227,-1,149,119,148,-1,119,230,148,-1,118,123,231,-1,123,232,231,-1,233,217,154,-1,154,153,233,-1,234,235,218,-1,235,221,218,-1,135,123,136,-1,135,232,123,-1,128,48,46,-1,46,129,128,-1,122,139,138,-1,122,234,139,-1,216,210,214,-1,215,210,212,-1,213,210,209,-1,38,41,228,-1,228,207,38,-1,202,203,206,-1,206,201,202,-1,236,237,238,-1,237,239,238,-1,196,239,237,-1,196,198,239,-1,86,187,240,-1,187,189,240,-1,71,182,193,-1,71,70,182,-1,188,192,190,-1,190,189,188,-1,88,177,187,-1,177,179,187,-1,185,241,184,-1,185,242,241,-1,186,182,183,-1,243,244,191,-1,191,192,243,-1,179,180,188,-1,180,245,188,-1,246,247,248,-1,247,249,248,-1,173,167,174,-1,167,169,174,-1,250,251,252,-1,252,249,250,-1,79,166,247,-1,166,164,247,-1,87,85,197,-1,85,198,197,-1,78,163,77,-1,78,200,163,-1,253,254,69,-1,254,255,69,-1,186,197,194,-1,186,184,197,-1,23,224,44,-1,152,14,33,-1,256,151,257,-1,257,258,256,-1,259,260,38,-1,260,39,38,-1,126,125,155,-1,163,261,147,-1,147,144,163,-1,262,263,220,-1,263,264,220,-1,155,130,157,-1,130,265,157,-1,237,261,266,-1,237,236,261,-1,118,25,124,-1,124,123,118,-1,123,115,136,-1,152,148,230,-1,152,33,148,-1,149,44,226,-1,44,224,226,-1,33,44,148,-1,33,13,44,-1,267,268,269,-1,270,271,272,-1,99,95,21,-1,99,94,95,-1,11,268,267,-1,11,10,268,-1,105,100,95,-1,95,93,105,-1,109,92,110,-1,92,114,110,-1,252,251,172,-1,251,273,172,-1,86,88,187,-1};
			return value;
		}
		private int[] getlrib7_Geo_6_70_coordIndex_2()
		{
			int[] value = {73,78,74,-1,78,76,74,-1,196,237,266,-1,166,69,68,-1,166,253,69,-1,67,255,274,-1,67,69,255,-1,275,55,66,-1,66,67,275,-1,65,68,66,-1,65,165,68,-1,64,165,65,-1,64,61,165,-1,276,63,62,-1,276,277,63,-1,278,279,280,-1,278,281,279,-1,274,255,281,-1,281,278,274,-1,56,275,282,-1,56,55,275,-1,54,60,52,-1,153,231,232,-1,232,233,153,-1,12,14,152,-1,152,51,12,-1,207,228,12,-1,34,29,37,-1,260,283,208,-1,16,111,3,-1,3,5,16,-1,15,111,16,-1,268,10,7,-1,7,284,268,-1,20,269,22,-1,269,285,22,-1,95,19,21,-1,15,224,23,-1,15,18,224,-1,224,18,225,-1,286,17,6,-1,6,8,286,-1,7,10,8,-1,10,9,8,-1,4,7,5,-1,7,6,5,-1,287,221,235,-1,287,288,221,-1,24,44,42,-1,24,23,44,-1,284,269,268,-1,269,284,285,-1,226,289,223,-1,226,225,289,-1,9,103,290,-1,9,11,103,-1,108,272,102,-1,108,270,272,-1,35,260,208,-1,35,39,260,-1,40,29,107,-1,29,40,37,-1,12,227,13,-1,12,228,227,-1,232,47,233,-1,47,232,135,-1,57,282,291,-1,57,56,282,-1,278,282,274,-1,282,278,291,-1,280,291,278,-1,291,280,59,-1,60,280,276,-1,59,280,60,-1,276,52,60,-1,276,62,52,-1,274,275,67,-1,275,274,282,-1,244,70,191,-1,181,70,244,-1,250,63,251,-1,250,61,63,-1,273,279,168,-1,273,277,279,-1,178,241,242,-1,241,178,177,-1,292,172,171,-1,292,252,172,-1,113,105,103,-1,113,100,105,-1,92,98,114,-1,94,98,92,-1,22,91,90,-1,91,22,285,-1,293,104,158,-1,104,293,106,-1,289,271,294,-1,271,289,28,-1,230,153,152,-1,153,230,231,-1,223,294,159,-1,294,223,289,-1,295,296,297,-1,298,296,295,-1,299,298,295,-1,299,140,298,-1,300,301,302,-1,301,300,303,-1,204,304,305,-1,204,203,304,-1,133,306,202,-1,133,302,306,-1,47,134,45,-1,47,135,134,-1,307,308,303,-1,307,263,308,-1,309,310,264,-1,309,143,310,-1,146,309,307,-1,309,146,145,-1,311,265,219,-1,157,265,311,-1,262,219,265,-1,262,220,219,-1,312,38,207,-1,312,259,38,-1,151,313,0,-1,256,313,151,-1,283,257,208,-1,283,258,257,-1,256,209,313,-1,256,213,209,-1,215,258,283,-1,258,215,212,-1,259,214,260,-1,259,216,214,-1,314,305,304,-1,305,314,315,-1,198,84,239,-1,198,85,84,-1,170,279,281,-1,170,168,279,-1,277,251,63,-1,273,251,277,-1,81,254,253,-1,176,254,81,-1,247,250,249,-1,247,164,250,-1,79,246,80,-1,79,247,246,-1,249,292,248,-1,249,252,292,-1,173,245,180,-1,173,174,245,-1,175,244,243,-1,175,82,244,-1,183,248,185,-1,183,246,248,-1,245,192,188,-1,245,243,192,-1,241,197,184,-1,197,241,87,-1,189,316,240,-1,189,190,316,-1,200,196,266,-1,200,195,196,-1,86,317,83,-1,86,240,317,-1,318,316,161,-1,319,316,318,-1,319,201,206,-1,318,201,319,-1,205,83,317,-1,205,120,83,-1,266,163,200,-1,163,266,261,-1,296,238,121,-1,238,296,320,-1,321,302,301,-1,302,321,306,-1,299,305,315,-1,305,299,295,-1,320,141,199,-1,320,142,141,-1,127,49,125,-1,127,150,49,-1,131,263,262,-1,263,131,308,-1,116,315,117,-1,116,299,315,-1,322,321,301,-1,322,45,321,-1,264,218,220,-1,218,264,310,-1,131,265,130,-1,262,265,131,-1,122,235,234,-1,122,124,235,-1,48,125,49,-1,128,125,48,-1,25,235,124,-1,287,235,25,-1,27,287,25,-1,222,287,27,-1,36,30,34,-1,36,323,30,-1,272,286,290,-1,271,286,272,-1,227,293,43,-1,227,229,293,-1,285,97,91,-1,97,285,284,-1,8,290,286,-1,290,8,9,-1,229,106,293,-1,229,107,106,-1,271,17,286,-1,28,17,271,-1,324,311,288,-1,325,311,324,-1,119,231,230,-1,231,119,118,-1,288,219,221,-1,311,219,288,-1,218,139,234,-1,310,139,218,-1,321,134,314,-1,45,134,321,-1,117,314,134,-1,117,315,314,-1,325,157,311,-1,325,156,157,-1,150,257,151,-1,150,127,257,-1,323,156,325,-1,323,36,156,-1,126,257,127,-1,126,208,257,-1,298,320,296,-1,320,298,142,-1,314,306,321,-1,314,304,306,-1,199,238,320,-1,199,236,238,-1,204,120,205,-1,204,297,120,-1,121,239,84,-1,239,121,238,-1,317,206,205,-1,319,206,317,-1};
			return value;
		}
		private int[] getlrib7_Geo_6_70_coordIndex_3()
		{
			int[] value = {318,75,201,-1,76,75,318,-1,161,76,318,-1,161,74,76,-1,319,240,316,-1,317,240,319,-1,236,147,261,-1,236,199,147,-1,144,300,132,-1,146,300,144,-1,194,195,193,-1,195,194,196,-1,190,161,316,-1,190,162,161,-1,242,248,292,-1,248,242,185,-1,181,246,183,-1,181,80,246,-1,174,243,245,-1,174,175,243,-1,173,178,171,-1,178,173,180,-1,82,176,81,-1,175,176,82,-1,176,170,254,-1,169,170,176,-1,172,168,167,-1,172,273,168,-1,165,250,164,-1,250,165,61,-1,281,254,170,-1,254,281,255,-1,159,324,222,-1,159,160,324,-1,104,93,158,-1,105,93,104,-1,211,259,312,-1,259,211,216,-1,260,215,283,-1,260,214,215,-1,212,256,258,-1,256,212,213,-1,313,211,312,-1,313,209,211,-1,0,312,207,-1,313,312,0,-1,146,303,300,-1,307,303,146,-1,141,309,145,-1,143,309,141,-1,140,142,298,-1,140,137,142,-1,143,139,310,-1,143,137,139,-1,264,307,309,-1,307,264,263,-1,134,115,117,-1,134,136,115,-1,129,45,322,-1,129,46,45,-1,306,203,202,-1,203,306,304,-1,305,297,204,-1,297,305,295,-1,301,308,322,-1,308,301,303,-1,155,128,130,-1,155,125,128,-1,322,131,129,-1,322,308,131,-1,132,302,133,-1,302,132,300,-1,116,122,138,-1,116,115,122,-1,119,226,26,-1,119,149,226,-1,299,138,140,-1,299,116,138,-1,297,121,120,-1,296,121,297,-1,21,90,99,-1,21,22,90,-1,271,31,294,-1,271,270,31,-1,42,112,24,-1,110,112,42,-1,158,43,293,-1,158,109,43,-1,106,102,104,-1,106,108,102,-1,126,36,35,-1,156,36,126,-1,114,101,112,-1,114,96,101,-1,113,269,20,-1,113,267,269,-1,97,7,4,-1,97,284,7,-1,11,113,103,-1,113,11,267,-1,98,96,114,-1,98,89,96,-1,242,171,178,-1,242,292,171,-1,177,87,241,-1,177,88,87,-1,291,54,57,-1,291,59,54,-1,253,79,81,-1,166,79,253,-1,82,181,244,-1,80,181,82,-1,72,191,70,-1,72,162,191,-1,64,52,62,-1,64,53,52,-1,276,279,277,-1,280,279,276,-1,57,53,58,-1,53,57,54,-1,50,150,2,-1,50,49,150,-1,233,46,217,-1,46,233,47,-1,217,50,154,-1,217,48,50,-1,37,39,35,-1,39,37,40,-1,41,107,229,-1,107,41,40,-1,294,32,159,-1,294,31,32,-1,323,32,30,-1,323,160,32,-1,29,270,108,-1,29,31,270,-1,102,290,103,-1,102,272,290,-1,289,18,28,-1,225,18,289,-1,223,26,226,-1,26,223,27,-1,160,325,324,-1,323,325,160,-1,288,222,324,-1,287,222,288,-1,154,2,1,-1,154,50,2,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib7_Coord_7_70_point_1()
		{
			double[] value = {1.12032,47.62617,-3.54847,1.18351,47.6564,-3.55223,1.21239,47.58132,-3.5894,.63484,47.53949,-2.60917,.5702,47.32139,-2.52513,.60937,47.44844,-2.63702,.60589,47.40953,-2.66252,.55324,47.26435,-2.55154,.59508,47.36278,-2.66959,.57012,47.27907,-2.68993,.54066,47.1823,-2.58606,.53831,47.19355,-2.67275,.97513,47.61831,-3.3358,.64029,47.65556,-2.97105,.98766,47.66725,-3.31028,.69069,47.65288,-2.83038,.64538,47.57491,-2.74487,.6558,47.55435,-2.76921,.71744,47.6277,-2.85265,.485,47.31284,-2.74649,.49981,47.25415,-2.70509,.48345,47.35678,-2.74505,.49119,47.32041,-2.68784,.69086,47.70772,-2.91029,.6386,47.69279,-2.82428,1.31497,47.71718,-3.37116,1.22006,47.72084,-3.29794,1.22977,47.68048,-3.29546,.72427,47.57934,-2.85845,.77632,47.33634,-3.0185,.95738,47.3815,-3.18393,.80112,47.43156,-2.99123,1.03284,47.46624,-3.18795,.98842,47.67984,-3.29644,.93476,47.36773,-3.18325,1.0772,47.38849,-3.35316,1.08533,47.39693,-3.33346,.92294,47.35963,-3.18643,1.01119,47.50075,-3.34947,1.06492,47.41171,-3.36271,.91642,47.3791,-3.20189,.9287,47.50334,-3.23266,.59429,47.70752,-2.86566,.58856,47.63984,-2.91011,.66877,47.71286,-2.93751,2.12735,47.43664,-4.00202,1.92175,47.46398,-3.93713,1.93508,47.50115,-3.90934,1.36594,47.462,-3.67817,1.28269,47.51377,-3.61372,1.27112,47.565,-3.61281,1.13714,47.67189,-3.50422,3.28205,43.4945,2.4071,3.31058,43.42195,2.36401,3.3345,43.45606,2.39694,3.4462,43.22206,2.20526,3.43025,43.23258,2.26669,3.4007,43.29541,2.3177,3.39103,43.24819,2.2586,3.32654,43.45997,2.45381,3.2932,43.5047,2.44197,3.27474,43.38523,2.32297,3.23267,43.48575,2.43534,3.2159,43.50158,2.42911,3.27523,43.39637,2.36869,3.37078,43.18903,2.22854,3.42022,43.17091,2.21558,3.42457,43.15805,2.25447,3.43707,43.14258,2.19979,3.44548,43.1392,2.27508,5.22318,45.0365,-.86473,5.15928,45.59483,-1.83707,5.1963,45.59546,-1.85196,4.90855,46.06336,-2.58589,4.95266,46.07249,-2.59613,3.71901,46.90801,-3.77081,4.35494,46.5311,-3.29363,3.71667,46.90555,-3.74461,4.32888,46.51868,-3.28935,4.04404,43.5626,1.6837,4.80837,44.23241,.57176,4.07212,43.58039,1.72024,4.84919,44.27721,.64219,4.51939,46.90351,-2.95211,4.44168,46.86601,-2.93979,4.90356,46.42993,-2.23833,5.02432,46.44933,-2.25994,5.15085,45.94148,-1.42501,5.25303,45.97926,-1.40776,.51045,47.4801,-2.64065,.4912,47.38598,-2.66891,.51983,47.34126,-2.59368,.49231,47.54011,-2.80444,.51589,47.41205,-2.82275,.47986,47.50981,-2.77581,.48523,47.37955,-2.78434,.52238,47.50815,-2.63726,.559,47.31846,-2.5284,.48988,47.52773,-2.71311,.48569,47.45828,-2.73876};
			return value;
		}
		private double[] getlrib7_Coord_7_70_point_2()
		{
			double[] value = {.50289,47.26091,-2.78613,.6009,47.54192,-2.59878,.66578,47.29814,-2.91229,.55225,47.22207,-2.79013,.64494,47.303,-2.91526,.51635,47.26331,-2.80953,.70506,47.31843,-2.96818,.76038,47.34629,-3.01857,.718,47.31243,-2.96091,.53614,47.61271,-2.85886,.54398,47.66478,-2.80075,.63866,47.6225,-2.72501,.57307,47.63353,-2.73266,.53632,47.2207,-2.76785,.4993,47.55472,-2.71287,1.93229,47.71794,-3.65347,2.21314,47.68078,-3.67226,2.20581,47.6812,-3.73306,1.31014,47.72865,-3.38124,1.19506,47.73135,-3.32944,3.79837,47.33604,-3.44208,3.73798,47.29254,-3.38621,1.92496,47.66979,-3.61683,1.48065,47.74749,-3.51936,1.50541,47.72234,-3.47445,1.26126,47.38428,-3.57438,1.17751,47.34489,-3.49545,1.22834,47.40898,-3.56508,1.36074,47.37031,-3.65697,1.92077,47.30268,-3.93847,1.37251,47.35108,-3.634,1.92609,47.29699,-3.92292,2.93228,47.11209,-4.00745,2.94713,47.12809,-4.03912,2.14717,47.57444,-3.90679,1.96676,47.58959,-3.84904,1.95164,47.62821,-3.78161,2.35842,47.4648,-3.67534,2.21204,47.64024,-3.63375,2.18832,47.4773,-3.64014,2.38203,47.6132,-3.64003,2.61989,47.29435,-3.76828,2.63521,47.4132,-3.64261,2.33772,47.33463,-3.77932,2.89799,47.1933,-3.88455,2.61745,47.24691,-3.8164,2.61463,47.25818,-3.9165,2.90704,47.20127,-3.80063,.98621,47.71296,-3.23524,.99843,47.73847,-3.1676,1.24222,47.5134,-3.60022,1.18527,47.51845,-3.59252,1.15937,47.71959,-3.44838,1.25881,47.69606,-3.51997,1.26087,47.61846,-3.59676,1.26466,47.37129,-3.55407,1.19058,47.37136,-3.43909,1.28322,47.38331,-3.52304,.58079,47.48051,-2.88307,1.09222,47.54131,-3.18763,1.09358,47.46797,-3.25201,4.99527,46.11361,-2.56986,5.22565,45.63954,-1.80747,3.67378,46.99176,-3.69642,3.55186,43.28047,2.07781,3.37209,43.18733,2.19805,3.57982,43.2289,2.07115,3.87678,43.94087,1.99486,3.45923,43.59673,2.42669,4.01473,43.81678,1.94657,3.54874,43.46174,2.36679,4.59463,44.66165,.99349,3.79928,43.97585,1.98958,4.67006,44.66019,1.00015,4.81535,44.53129,.87699,4.85968,44.41301,.76601,4.08756,43.70334,1.8427,5.12766,45.55588,-.59898,4.90028,45.1465,.13616,5.21793,45.52069,-.60428,4.96584,45.12974,.14993,5.03537,44.62438,-.16605,5.12155,45.06613,-.85487,4.96505,44.66549,-.15983,4.95417,45.34794,-.68898,4.89393,44.96047,.0252,5.05748,45.15605,-.78969,5.34309,45.95128,-1.47455,5.27605,45.39115,-.69084,5.32182,45.85492,-1.59484,5.27034,45.72969,-1.71561,5.28481,45.13255,-.8119,5.27618,45.26851,-.73838,5.16106,45.62402,-1.80826,5.12507,45.68953,-1.71646,4.81421,46.0521,-2.49703,4.76714,46.15734,-2.44201,5.09684,45.84033,-1.53016,4.77849,46.29701,-2.32075,2.90435,47.23442,-3.72703};
			return value;
		}
		private double[] getlrib7_Coord_7_70_point_3()
		{
			double[] value = {4.33324,46.59045,-3.23681,3.75071,47.0373,-3.74664,3.00044,47.31157,-3.96308,3.01413,47.45449,-3.86931,3.01812,47.5413,-3.77359,3.83699,47.29021,-3.57049,3.80494,47.17239,-3.67154,1.03219,47.58915,-3.44619,1.14388,47.34754,-3.49725,1.12441,47.54853,-3.54482,1.13248,47.48968,-3.52093,1.0966,47.53256,-3.51455,1.15605,47.45772,-3.54872,1.14723,47.50532,-3.55688,1.11236,47.44322,-3.47764,1.13689,47.42788,-3.51813,1.09005,47.49391,-3.47299,1.38372,47.54624,-3.66637,1.97539,47.40284,-3.70098,1.43029,47.36671,-3.55217,1.96057,47.37098,-3.76151,1.45984,47.45119,-3.51496,1.243,47.55224,-3.3235,1.05748,47.63907,-3.17031,.71174,47.70467,-2.92454,.76574,47.64187,-2.92587,1.01663,47.72251,-3.15169,.64401,47.63133,-2.97686,.97456,47.60086,-3.33475,.70907,47.50274,-3.01327,1.17724,47.72547,-3.38606,1.28362,47.71245,-3.44751,1.44767,47.68406,-3.57335,1.41375,47.61909,-3.62808,1.9327,47.50154,-3.59101,1.49776,47.54102,-3.46451,3.64533,47.03085,-3.5298,4.27261,46.64831,-3.0802,3.65542,47.12537,-3.43943,4.30828,46.74082,-2.9959,5.07307,46.39031,-2.33496,5.01822,45.50487,-.61994,4.73683,45.02069,.20921,5.09948,44.84539,.04228,5.08814,44.6951,-.08322,5.07424,44.96974,.11565,4.75424,44.26275,.57126,4.00507,43.60574,1.65708,4.66541,44.49654,.78489,3.89321,43.80412,1.80006,3.40906,43.4867,2.21358,3.34306,43.62993,2.34393,3.78426,43.94633,1.92772,3.57925,43.23186,2.14929,3.59856,43.33073,2.28581,3.40994,43.20197,2.39662,1.16433,47.51378,-3.58403,1.18757,47.41056,-3.56824,1.17311,47.42317,-3.56284,1.05011,47.48946,-3.42159,1.09227,47.39587,-3.43329,3.65204,46.99484,-3.59272,1.92041,47.35173,-3.8354,2.11516,47.31964,-3.90352,2.14518,47.32366,-3.80829,1.41232,47.35859,-3.58874,4.29044,46.62048,-3.13824,.52655,47.19122,-2.6694,.53018,47.17677,-2.58716,.51243,47.203,-2.63055,.73688,47.4195,-2.91833,.73375,47.49355,-2.87523,.71082,47.41538,-2.89482,3.36626,43.6484,2.41928,3.39394,43.20798,2.3932,3.43476,43.21389,2.25108,3.24647,43.50576,2.4917,3.25095,43.53396,2.50478,3.35397,43.30141,2.45525,3.30718,43.46766,2.53993,3.29404,43.44931,2.51911,3.36945,43.31462,2.48814,3.41387,43.23767,2.32955,1.13843,47.36814,-3.50422,.54369,47.26649,-2.55118,.51182,47.28213,-2.6102,.65272,47.45405,-2.77788,1.32517,47.55267,-3.39393,1.31214,47.4647,-3.44228,.78373,47.59925,-2.93817,.62005,47.36894,-2.78476,3.37909,43.31773,2.39587,4.46537,44.58067,1.01446,.64302,47.49041,-2.94787,.81446,47.51184,-2.95982,2.69219,47.62106,-3.66041,2.97205,47.51818,-3.58605,3.00008,47.56493,-3.63518,2.67779,47.57178,-3.61335,2.3837,47.66209,-3.68474};
			return value;
		}
		private double[] getlrib7_Coord_7_70_point_4()
		{
			double[] value = {2.62278,47.14919,-4.06443,2.31212,47.192,-4.07426,2.634,47.16441,-4.09689,2.31095,47.18531,-4.05538,2.69017,47.49735,-3.92111,2.69082,47.60301,-3.79649,2.66371,47.38097,-4.01617,2.32713,47.28975,-3.9382,2.10751,47.24488,-4.00115,2.33158,47.28759,-3.84062,2.15364,47.35627,-3.75199,1.29593,47.39186,-3.4779,1.06472,47.56265,-3.50116,1.11744,47.58617,-3.55662,2.3666,47.55694,-3.92931,2.37189,47.65972,-3.77733,5.04288,46.25483,-2.47347,4.55065,46.878,-3.01798,4.4454,46.64162,-3.23443,4.51239,46.78949,-3.12374,2.9118,47.35032,-3.61235,2.34639,47.40852,-4.03144,2.10397,47.25132,-4.01962,1.08841,47.41218,-3.30002,1.21458,47.4532,-3.36563,1.19832,47.38943,-3.40281};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib8_Geo_6_75_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,4,7,5,-1,8,9,10,-1,8,11,9,-1,12,13,14,-1,12,15,13,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,25,26,24,-1,26,27,24,-1,28,29,30,-1,29,31,30,-1,32,33,34,-1,35,36,37,-1,26,38,39,-1,39,27,26,-1,40,41,42,-1,40,15,43,-1,40,13,15,-1,42,44,13,-1,13,40,42,-1,21,45,46,-1,21,47,45,-1,48,49,50,-1,51,52,53,-1,54,55,56,-1,55,4,56,-1,57,58,59,-1,59,60,57,-1,61,62,63,-1,64,65,10,-1,64,66,65,-1,67,68,69,-1,67,70,68,-1,71,72,73,-1,74,75,76,-1,75,77,76,-1,78,79,80,-1,78,81,79,-1,73,82,83,-1,83,71,73,-1,56,84,54,-1,56,85,84,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,92,93,90,-1,94,95,96,-1,97,98,99,-1,97,100,98,-1,33,101,102,-1,103,104,105,-1,103,57,104,-1,92,106,107,-1,92,62,106,-1,30,108,109,-1,109,28,30,-1,110,111,112,-1,110,113,111,-1,114,115,116,-1,115,117,116,-1,115,114,118,-1,118,119,115,-1,120,121,122,-1,120,123,121,-1,117,124,125,-1,117,126,124,-1,127,115,119,-1,128,95,129,-1,95,94,129,-1,39,130,131,-1,39,38,130,-1,110,78,113,-1,110,132,78,-1,133,132,134,-1,134,71,133,-1,135,136,137,-1,137,138,135,-1,139,140,141,-1,139,55,140,-1,142,23,22,-1,143,17,144,-1,143,18,17,-1,51,74,5,-1,74,145,5,-1,4,6,56,-1,146,71,134,-1,146,72,71,-1,147,109,148,-1,109,108,148,-1,134,149,150,-1,150,146,134,-1,14,13,44,-1,151,152,86,-1,151,153,152,-1,154,155,156,-1,157,158,159,-1,159,160,157,-1,3,161,162,-1,3,0,161,-1,111,163,164,-1,111,113,163,-1,0,2,165,-1,166,167,112,-1,167,168,112,-1,154,169,155,-1,169,170,155,-1,98,65,171,-1,171,99,98,-1,59,172,173,-1,8,10,174,-1,175,176,49,-1,175,177,176,-1,170,178,179,-1,179,155,170,-1,179,180,155,-1,180,156,155,-1,29,181,180,-1,29,182,181,-1,182,109,150,-1,182,28,109,-1,181,156,180,-1,181,183,156,-1,180,179,29,-1,179,31,29,-1,31,179,184,-1,179,178,184,-1,49,185,50,-1,49,176,185,-1,186,187,188,-1,186,101,187,-1,189,190,129,-1,129,94,189,-1,32,191,190,-1,190,187,32,-1,192,193,102,-1,193,33,102,-1,194,61,63,-1,93,92,195,-1,92,196,195,-1,166,197,198,-1,198,167,166,-1,198,183,167,-1,183,181,167,-1,199,200,201,-1,201,162,199,-1,201,3,162,-1,201,202,3,-1,197,153,198,-1,197,203,153,-1,159,158,152,-1,158,204,152,-1,151,183,198,-1,198,153,151,-1,152,204,86,-1,204,89,86,-1,205,156,183,-1,183,151,205,-1,206,207,208,-1,208,209,206,-1,12,14,210,-1,150,109,147,-1,147,146,150,-1,139,52,7,-1,139,20,52,-1,211,207,212,-1,87,82,77,-1,87,89,82,-1,20,213,214,-1,20,19,213,-1,54,137,136,-1,54,84,137,-1,204,215,83,-1,204,158,215,-1,126,127,216,-1,127,217,216,-1,145,76,218,-1,145,74,76,-1,131,130,41,-1,130,42,41,-1,219,128,220,-1,128,129,220,-1,221,222,124,-1,222,125,124,-1,117,115,126,-1,115,127,126,-1,223,224,123,-1,123,120,223,-1,225,116,226,-1,225,114,116,-1,116,125,224,-1,116,117,125,-1,175,227,228,-1,228,184,175,-1,140,136,135,-1,135,229,140,-1,57,60,104,-1,105,104,230,-1,104,171,230,-1,231,232,138,-1,232,233,138,-1,234,8,174,-1,234,186,8,-1,91,63,62,-1,62,92,91,-1,93,235,90,-1,207,53,212,-1,53,52,212,-1,6,85,56,-1,6,236,85,-1,133,81,78,-1,133,215,81,-1,82,76,77,-1,82,73,76,-1,78,132,133,-1,66,70,67,-1,66,64,70,-1,192,237,193,-1,213,143,41,-1,41,40,213,-1,25,23,36,-1,36,238,25,-1,45,16,46,-1,136,55,54,-1,136,140,55,-1,84,239,137,-1,84,240,239,-1,137,231,138,-1,137,239,231,-1,241,10,9,-1,241,64,10,-1,57,130,38,-1,57,103,130,-1,130,103,42,-1,103,44,42,-1,19,242,213,-1,219,220,243,-1,243,220,244,-1,28,182,29,-1,238,58,26,-1,26,25,238,-1,140,229,141,-1,245,27,39,-1,17,16,246,-1,37,233,247,-1,247,35,37,-1,24,23,25,-1};
			return value;
		}
		private int[] getlrib8_Geo_6_75_coordIndex_2()
		{
			int[] value = {92,107,196,-1,223,225,226,-1,120,225,223,-1,120,248,225,-1,249,250,122,-1,249,251,250,-1,242,16,18,-1,242,46,16,-1,144,252,245,-1,144,17,252,-1,21,229,47,-1,21,141,229,-1,172,58,238,-1,172,59,58,-1,207,253,208,-1,207,211,253,-1,106,61,237,-1,62,61,106,-1,254,220,191,-1,254,244,220,-1,38,58,57,-1,38,26,58,-1,37,255,256,-1,37,142,255,-1,238,35,172,-1,238,36,35,-1,257,258,259,-1,257,260,258,-1,241,70,64,-1,185,70,241,-1,30,236,108,-1,30,228,236,-1,85,240,84,-1,85,227,240,-1,213,18,143,-1,18,213,242,-1,142,261,255,-1,261,142,22,-1,194,237,61,-1,237,194,193,-1,97,60,59,-1,99,60,97,-1,192,97,262,-1,192,100,97,-1,133,83,215,-1,71,83,133,-1,263,264,265,-1,264,263,222,-1,208,266,209,-1,266,208,267,-1,234,98,100,-1,174,98,234,-1,11,189,268,-1,189,11,188,-1,172,195,196,-1,35,195,172,-1,235,243,90,-1,243,235,219,-1,233,256,138,-1,233,37,256,-1,231,259,232,-1,257,259,231,-1,65,230,171,-1,230,65,66,-1,240,175,49,-1,240,227,175,-1,269,270,271,-1,270,269,272,-1,273,200,199,-1,121,200,273,-1,225,118,114,-1,248,118,225,-1,224,226,116,-1,226,224,223,-1,251,273,270,-1,249,273,251,-1,118,250,272,-1,250,118,248,-1,274,127,119,-1,217,127,274,-1,222,275,125,-1,275,222,263,-1,214,211,212,-1,214,43,211,-1,163,78,80,-1,78,163,113,-1,222,79,264,-1,79,222,221,-1,157,215,158,-1,157,81,215,-1,276,219,235,-1,128,219,276,-1,233,95,247,-1,233,232,95,-1,20,141,21,-1,20,139,141,-1,41,144,131,-1,41,143,144,-1,82,204,83,-1,89,204,82,-1,53,206,75,-1,53,207,206,-1,20,212,52,-1,20,214,212,-1,7,55,139,-1,4,55,7,-1,145,147,148,-1,147,145,218,-1,99,104,60,-1,171,104,99,-1,253,12,277,-1,253,15,12,-1,88,206,209,-1,88,87,206,-1,88,151,86,-1,88,205,151,-1,205,209,266,-1,205,88,209,-1,203,152,153,-1,203,159,152,-1,203,1,278,-1,203,197,1,-1,278,3,202,-1,3,278,1,-1,263,200,275,-1,201,200,263,-1,199,161,271,-1,199,162,161,-1,271,279,269,-1,279,271,161,-1,164,279,165,-1,274,279,164,-1,112,2,166,-1,112,111,2,-1,112,149,110,-1,112,168,149,-1,280,170,169,-1,281,170,280,-1,67,12,210,-1,67,69,12,-1,244,63,91,-1,254,63,244,-1,34,193,194,-1,33,193,34,-1,32,101,33,-1,101,32,187,-1,191,129,190,-1,191,220,129,-1,188,190,189,-1,188,187,190,-1,259,268,96,-1,258,268,259,-1,260,185,241,-1,185,260,50,-1,69,281,280,-1,281,69,68,-1,177,170,281,-1,178,170,177,-1,31,228,30,-1,31,184,228,-1,167,182,168,-1,182,167,181,-1,177,184,178,-1,177,175,184,-1,240,48,239,-1,49,48,240,-1,281,176,177,-1,68,176,281,-1,239,257,231,-1,257,239,48,-1,268,9,11,-1,9,268,258,-1,254,194,63,-1,34,194,254,-1,210,66,67,-1,66,210,230,-1,277,69,280,-1,277,12,69,-1,277,208,253,-1,267,208,277,-1,267,154,266,-1,154,267,169,-1,166,1,197,-1,1,166,2,-1,111,165,2,-1,111,164,165,-1,163,274,164,-1,163,217,274,-1,165,161,0,-1,279,161,165,-1,269,274,119,-1,279,274,269,-1,201,265,202,-1,263,265,201,-1,160,202,265,-1,160,278,202,-1,278,159,203,-1,278,160,159,-1,266,156,205,-1,266,154,156,-1,44,105,14,-1,44,103,105,-1,24,245,252,-1,245,24,27,-1,108,6,148,-1,108,236,6,-1,218,146,147,-1,146,218,72,-1,148,5,145,-1,148,6,5,-1,51,7,52,-1,7,51,5,-1,72,76,73,-1,76,72,218,-1,245,131,144,-1,245,39,131,-1,261,17,246,-1,261,252,17,-1,246,255,261,-1,246,282,255,-1,47,135,283,-1,229,135,47,-1,138,283,135,-1,138,256,283,-1,128,247,95,-1,128,276,247,-1,264,81,157,-1,81,264,79,-1,134,110,149,-1,132,110,134,-1,80,217,163,-1,80,216,217,-1,91,243,244,-1,243,91,90,-1,213,43,214,-1,213,40,43,-1,96,232,259,-1,96,95,232,-1,272,251,270,-1,251,272,250,-1,249,121,273,-1,122,121,249,-1,275,224,125,-1,275,123,224,-1,121,275,200,-1,123,275,121,-1,271,273,199,-1,273,271,270,-1,119,272,269,-1,272,119,118,-1};
			return value;
		}
		private int[] getlrib8_Geo_6_75_coordIndex_3()
		{
			int[] value = {150,168,182,-1,150,149,168,-1,258,241,9,-1,241,258,260,-1,100,102,234,-1,100,192,102,-1,101,234,102,-1,234,101,186,-1,235,195,276,-1,195,235,93,-1,230,14,105,-1,210,14,230,-1,189,96,268,-1,94,96,189,-1,65,174,10,-1,174,65,98,-1,87,75,206,-1,87,77,75,-1,216,124,126,-1,124,216,221,-1,221,80,79,-1,80,221,216,-1,75,51,53,-1,75,74,51,-1,196,173,172,-1,196,107,173,-1,173,106,262,-1,173,107,106,-1,59,262,97,-1,59,173,262,-1,228,85,236,-1,228,227,85,-1,185,68,70,-1,185,176,68,-1,48,260,257,-1,48,50,260,-1,16,282,246,-1,45,282,16,-1,283,45,47,-1,283,282,45,-1,256,282,283,-1,256,255,282,-1,36,142,37,-1,36,23,142,-1,211,15,253,-1,43,15,211,-1,276,35,247,-1,35,276,195,-1,191,34,254,-1,32,34,191,-1,262,237,192,-1,106,237,262,-1,277,169,267,-1,277,280,169,-1,252,22,24,-1,22,252,261,-1,242,21,46,-1,19,21,242,-1,188,8,186,-1,188,11,8,-1,122,248,120,-1,250,248,122,-1,265,157,160,-1,265,264,157,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib8_Coord_7_75_point_1()
		{
			double[] value = {4.39715,43.4605,1.24638,4.80804,43.78503,.74885,4.79389,43.78241,.70323,4.44212,43.45853,1.29616,2.19659,46.16189,-3.70705,2.91313,45.7933,-3.81569,2.93216,45.98486,-3.79646,2.18801,46.10466,-3.73017,1.089,46.83626,-3.29038,1.22633,46.76301,-3.29995,1.23086,46.86953,-3.37807,1.10364,46.77633,-3.22982,1.80346,46.60915,-3.73309,1.42442,46.56691,-3.69821,1.35409,46.63059,-3.59754,1.70348,46.48551,-3.76427,1.27757,46.26115,-3.45901,1.17379,46.30811,-3.42391,1.24714,46.3132,-3.489,1.39011,46.29582,-3.55714,1.70431,46.22314,-3.64763,1.39642,46.25212,-3.51598,1.07872,46.27104,-3.23912,.9868,46.31514,-3.19844,1.01387,46.32745,-3.27823,.97783,46.34667,-3.23467,.97278,46.47231,-3.3429,1.01551,46.43354,-3.3594,4.38156,45.3688,-2.87463,4.38986,45.45941,-2.83942,3.59206,45.78163,-3.54959,3.59721,45.95682,-3.54621,.76402,46.73101,-2.87583,.72295,46.86315,-2.94374,.70727,46.74752,-2.7392,.88776,46.34773,-3.09623,.9805,46.31429,-3.17811,1.11415,46.23462,-3.17967,1.02328,46.5468,-3.40749,1.04446,46.47781,-3.41633,1.41052,46.52268,-3.70491,1.20897,46.50449,-3.63243,1.2338,46.5855,-3.62699,1.6915,46.43923,-3.76198,1.26846,46.60287,-3.61973,1.29442,46.25204,-3.42408,1.34629,46.25255,-3.503,1.3309,46.24229,-3.40855,1.52504,46.4946,-3.35501,1.87475,46.56554,-3.53749,1.53086,46.6101,-3.39964,2.91385,45.79008,-3.85222,2.17251,46.11132,-3.77712,2.91701,45.82895,-3.87841,1.7756,46.28905,-3.55319,1.75631,46.26407,-3.57406,2.20326,46.19619,-3.68996,1.02667,46.56693,-3.40611,.97525,46.49515,-3.3334,.92037,46.54607,-3.28518,1.00222,46.62224,-3.37203,.55151,46.65535,-2.85132,.52324,46.57292,-2.8801,.58053,46.54256,-2.64681,1.36187,46.84904,-3.43003,1.18748,46.86112,-3.41485,1.3267,46.84814,-3.48322,1.48749,46.82702,-3.5373,1.8728,46.75716,-3.60429,1.85363,46.77794,-3.66878,1.50709,46.81899,-3.48785,5.08123,43.87304,-.7445,4.87712,44.44927,-1.82441,4.90854,44.44906,-1.85532,3.64883,45.49241,-3.64871,3.67153,45.5278,-3.66654,4.4002,45.08954,-3.01189,4.40805,45.13265,-3.03114,4.89594,43.26726,.51286,4.57434,42.93609,1.15557,4.5435,42.92135,1.1186,4.94784,43.2711,.54371,4.93787,44.4783,-1.85106,5.15021,43.86605,-.73148,1.83972,46.30376,-3.48868,2.22759,46.25031,-3.6266,5.07261,44.74468,-1.7637,4.46567,45.21766,-3.03285,4.50203,45.39026,-3.00014,4.99451,44.57015,-1.81357,.59121,46.25547,-2.63389,.57614,46.34562,-2.61888,.54175,46.42288,-2.87061,.61236,46.276,-2.85828,1.014,46.42409,-3.04507,1.01235,46.25105,-3.0442,1.08029,46.43411,-3.09079,.89793,46.76325,-3.2679,1.05443,46.88671,-3.35987,1.0171,46.76438,-3.36674};
			return value;
		}
		private double[] getlrib8_Coord_7_75_point_2()
		{
			double[] value = {.90012,46.89407,-3.27296,.83354,46.8353,-3.10454,.80805,46.9138,-3.15833,1.14256,46.61018,-3.53095,1.09577,46.64646,-3.41303,1.22038,46.64932,-3.51109,.54942,46.64329,-3.01278,.5746,46.48922,-2.9878,3.60258,45.72058,-3.57185,4.35808,45.27232,-2.90581,5.03452,43.66513,-.06989,4.82319,43.57546,.60501,5.09792,43.90807,.03194,4.85742,43.35103,.52861,3.787,42.54467,1.98123,3.78025,42.52841,1.94599,3.85369,42.49277,1.97784,3.87355,42.47927,1.94603,3.69795,42.63563,2.00429,3.71645,42.63682,1.95502,3.82725,42.69685,2.09314,3.785,42.79044,2.18345,3.7924,42.77094,2.13289,3.85803,42.66365,2.12206,3.97351,42.49832,1.91619,3.94663,42.52508,1.97545,3.93199,42.48414,1.87524,3.81209,42.55619,1.89092,.80471,46.1861,-2.86679,.83489,46.39607,-2.93678,1.12262,46.58818,-3.52093,1.10922,46.50429,-3.51779,5.05465,43.62637,-.11037,5.07602,43.62691,-.1923,5.07343,43.95962,-.70652,1.33468,46.22857,-3.31058,1.4461,46.27593,-3.37152,1.47101,46.26637,-3.32834,1.25077,46.23054,-3.23877,1.73386,46.20263,-3.59501,1.43518,46.27096,-3.39668,1.42501,46.23327,-3.4493,1.11114,46.24178,-3.2022,1.20242,46.3959,-3.54178,1.12741,46.4089,-3.45193,3.63759,45.49155,-3.61088,4.8919,44.5485,-1.78736,4.38162,45.18,-2.95901,3.6119,45.63604,-3.60859,5.05801,44.01713,-.68746,4.88555,44.60557,-1.77568,5.10031,44.90014,-1.72113,5.25565,44.18418,-.64261,5.23971,44.3722,-.54263,3.70638,46.16049,-3.56019,3.69608,46.18049,-3.51903,4.52761,45.67098,-2.86788,4.97256,43.39039,.61562,5.17247,43.70008,.03291,5.18644,43.86237,.07762,4.90866,43.56275,.69468,3.90768,43.06906,1.77919,3.94416,43.07038,1.85517,4.52598,43.06898,1.08956,4.4514,43.22662,1.12721,4.42535,43.36133,1.16978,5.07983,44.10172,.13952,5.20573,44.43655,-.52128,5.14022,44.22614,-.6228,3.03013,46.48633,-3.7763,3.01731,46.48274,-3.72042,1.1344,46.76705,-3.43319,.82649,46.42129,-3.11514,.73985,46.55434,-3.17373,1.08985,46.89444,-3.32032,2.28699,46.49414,-3.66521,1.87365,46.67816,-3.57677,2.3297,46.63322,-3.68313,3.03176,46.4214,-3.71924,3.67683,46.1408,-3.49387,4.48798,45.67771,-2.83563,5.04377,45.04242,-1.70021,4.97198,44.83366,-1.73215,5.06652,45.06101,-1.75943,2.97346,46.29178,-3.71898,1.51186,46.71298,-3.44895,.94986,46.83044,-3.20711,.8533,46.73925,-3.03919,.97458,46.75898,-3.13717,1.0083,46.63721,-3.08735,.88053,46.61626,-2.98419,.74744,46.57413,-2.81704,.75799,46.90401,-3.17885,.67924,46.86646,-2.95663,.64209,46.74108,-2.77524,.69091,46.28912,-2.93685,.60719,46.42036,-2.95549,5.09411,44.10753,.15169,5.23698,44.43803,-.53595,3.73098,42.88233,2.13445};
			return value;
		}
		private double[] getlrib8_Coord_7_75_point_3()
		{
			double[] value = {3.8131,42.82143,2.16411,4.03041,43.00238,1.85202,4.49033,43.35893,1.29273,5.14834,44.03204,.11654,5.2128,44.00064,-.7091,4.55984,45.58807,-2.91009,3.67218,45.71367,-3.73034,2.95221,46.07048,-3.92908,3.02092,46.23702,-3.91811,3.6938,45.92431,-3.67934,1.41451,46.69935,-3.59367,2.13294,46.34364,-3.87776,2.15009,46.25965,-3.83672,1.3854,46.38715,-3.64171,1.68944,46.32535,-3.70683,5.13471,43.59574,-.11349,4.14338,42.63685,1.60513,4.06925,42.73884,1.633,4.38778,45.08139,-2.97979,.73459,46.19424,-2.75563,.71301,46.39732,-2.79605,4.16686,42.64206,1.64228,4.17061,42.73201,1.72632,3.85656,42.58231,2.02501,3.90293,42.52148,2.01458,3.79303,42.59926,2.00588,3.82985,42.55768,1.99552,2.24404,46.30369,-3.61315,2.94755,46.12497,-3.73105,1.37824,46.22561,-3.37287,1.28218,46.75351,-3.52321,1.30836,46.26794,-3.21065,1.13279,46.25415,-3.10924,1.11406,46.23786,-3.14749,.93517,46.89492,-3.25133,.67685,46.15971,-2.84307,2.93774,46.0703,-3.75313,.58598,46.78514,-3.03931,.97239,46.36322,-3.21738,1.49239,46.29423,-3.30796,1.85483,46.34552,-3.47026,1.36283,46.73386,-3.37873,1.35493,46.29823,-3.54847,.64106,46.27585,-2.61538,.62716,46.381,-2.6004,1.06011,46.42718,-3.38224,1.21649,46.26353,-3.38138,.96193,46.23783,-3.07796,3.75491,42.67597,2.03103,3.74873,42.80432,2.13509,3.73328,42.74844,2.07065,3.7109,42.79569,2.09951,1.09993,46.31577,-3.33363,2.14761,46.38872,-3.88418,.64038,46.56056,-2.61613,1.18545,46.24864,-3.27737,1.21052,46.23953,-3.2615,1.35069,46.48434,-3.26787,1.24303,46.63276,-3.23596,1.19298,46.46084,-3.1635,1.38025,46.62154,-3.31724,1.1405,46.27083,-3.29804,.75167,46.71789,-3.18682,4.12675,42.86392,1.80565,4.58655,43.06875,1.22237,4.54942,43.20431,1.26445,3.71968,46.07678,-3.62704,3.0402,46.35154,-3.87806,1.12604,46.63314,-3.1632,3.66615,42.76371,2.01281,3.65121,42.82641,2.09974,3.66277,42.86414,2.06132,3.65703,42.74619,2.05647,3.70911,42.83827,2.16042,3.9779,42.86444,1.67362,3.89388,42.67878,2.10049,.75255,46.1634,-2.92684,2.25809,46.54464,-3.84376,4.87809,43.6722,.7133,3.93853,42.9712,1.71427,2.32891,46.6902,-3.76607,2.3147,46.68382,-3.70239,1.25047,46.24959,-3.35029,1.27807,46.24051,-3.33922};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib9_Geo_6_80_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,7,9,8,-1,10,11,12,-1,10,13,11,-1,14,15,16,-1,17,18,19,-1,19,20,17,-1,21,22,23,-1,24,25,26,-1,26,27,24,-1,28,29,30,-1,30,31,28,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,2,39,40,-1,2,1,39,-1,4,41,42,-1,42,43,4,-1,39,44,45,-1,45,40,39,-1,46,47,48,-1,48,49,46,-1,50,51,52,-1,52,53,50,-1,54,55,56,-1,55,57,56,-1,13,10,58,-1,59,60,61,-1,59,8,60,-1,62,63,64,-1,62,65,63,-1,66,67,68,-1,66,69,67,-1,70,71,72,-1,70,73,71,-1,64,74,75,-1,74,76,75,-1,77,78,79,-1,41,80,81,-1,80,82,81,-1,83,84,85,-1,85,82,83,-1,82,80,83,-1,15,86,84,-1,84,16,15,-1,87,88,89,-1,87,90,88,-1,17,91,92,-1,92,93,17,-1,94,95,96,-1,94,97,95,-1,98,99,100,-1,99,96,100,-1,101,102,103,-1,103,104,101,-1,105,106,107,-1,106,108,107,-1,109,110,94,-1,110,111,94,-1,112,113,114,-1,114,115,112,-1,116,117,109,-1,117,110,109,-1,118,99,98,-1,98,119,118,-1,120,121,104,-1,121,101,104,-1,121,120,122,-1,122,119,121,-1,122,117,116,-1,122,113,112,-1,122,120,123,-1,124,125,126,-1,125,127,126,-1,128,34,129,-1,34,130,129,-1,131,132,133,-1,132,134,133,-1,67,135,68,-1,130,33,136,-1,130,34,33,-1,90,137,138,-1,137,139,138,-1,140,141,142,-1,141,143,142,-1,144,145,146,-1,146,147,144,-1,148,149,150,-1,149,151,150,-1,152,153,154,-1,153,155,154,-1,156,90,138,-1,156,157,90,-1,54,158,55,-1,85,159,160,-1,159,161,160,-1,162,163,164,-1,163,165,164,-1,100,166,102,-1,166,93,102,-1,111,167,94,-1,167,97,94,-1,137,90,87,-1,168,169,170,-1,169,171,170,-1,172,173,147,-1,143,174,175,-1,174,176,175,-1,149,148,177,-1,178,179,180,-1,178,181,179,-1,182,183,181,-1,183,184,181,-1,185,178,186,-1,186,187,185,-1,133,134,26,-1,26,15,133,-1,188,76,74,-1,189,188,131,-1,189,76,188,-1,63,61,190,-1,190,191,63,-1,191,64,63,-1,191,74,64,-1,192,160,193,-1,192,194,160,-1,77,3,78,-1,3,5,78,-1,3,80,41,-1,41,4,3,-1,195,196,197,-1,198,199,200,-1,200,56,198,-1,201,202,203,-1,56,204,198,-1,56,57,204,-1,205,206,207,-1,205,208,206,-1,209,210,211,-1,209,205,210,-1,212,51,48,-1,48,213,212,-1,51,212,214,-1,214,52,51,-1,215,204,216,-1,216,217,215,-1,208,205,209,-1,206,69,66,-1,66,207,206,-1,218,219,220,-1,218,221,219,-1,222,204,57,-1,5,4,43,-1,43,223,5,-1,201,198,224,-1,224,197,201,-1,225,196,226,-1,227,200,73,-1,228,77,79,-1,228,229,77,-1,82,160,194,-1,82,85,160,-1,65,230,231,-1,65,62,230,-1,191,190,232,-1,190,233,232,-1,133,15,14,-1,14,234,133,-1,235,74,236,-1,235,188,74,-1,237,238,235,-1,239,240,152,-1,240,153,152,-1,178,180,240,-1,240,186,178,-1,134,27,26,-1,134,129,27,-1,181,185,182,-1,181,178,185,-1,180,179,151,-1,179,150,151,-1,241,36,32,-1,145,174,146,-1,145,242,174,-1,176,183,30,-1,176,184,183,-1,141,147,146,-1,141,172,147,-1,175,30,29,-1,175,176,30,-1,243,126,127,-1,243,244,126,-1,171,245,246,-1,245,247,246,-1,157,248,249,-1,95,89,166,-1,89,250,166,-1,251,252,253,-1,252,254,253,-1,141,140,172,-1,140,255,172,-1,123,256,122,-1,257,258,259,-1,257,260,258,-1,72,152,154,-1,72,261,152,-1,142,262,140,-1,262,263,140,-1,248,157,264,-1,157,156,264,-1,137,167,139,-1,167,254,139,-1,5,265,78,-1,5,266,265,-1,23,267,169,-1,267,268,169,-1,258,269,270,-1,269,223,270,-1,33,127,136,-1,127,125,136,-1,126,271,124,-1,271,272,124,-1,273,268,274,-1,268,267,274,-1,91,21,275,-1,21,168,275,-1,226,276,277,-1,277,225,226,-1,116,118,122,-1,113,122,256,-1,117,122,112,-1,119,122,118,-1,123,120,106,-1,120,104,106,-1,118,109,99,-1,118,116,109,-1,105,107,251,-1,251,114,105,-1,101,98,102,-1,98,100,102,-1,102,93,103,-1,93,92,103,-1,87,89,95,-1,95,97,87,-1,81,278,41,-1,278,42,41,-1,159,84,86,-1};
			return value;
		}
		private int[] getlrib9_Geo_6_80_coordIndex_2()
		{
			int[] value = {159,85,84,-1,234,14,279,-1,280,83,3,-1,83,80,3,-1,229,280,3,-1,3,77,229,-1,70,72,154,-1,154,237,70,-1,73,276,226,-1,226,71,73,-1,73,200,199,-1,199,276,73,-1,230,62,281,-1,201,197,202,-1,211,282,283,-1,211,210,282,-1,284,285,9,-1,284,79,285,-1,62,64,75,-1,75,281,62,-1,65,59,63,-1,59,61,63,-1,227,73,70,-1,70,236,227,-1,238,286,188,-1,188,235,238,-1,232,54,200,-1,54,56,200,-1,216,204,222,-1,55,287,57,-1,287,222,57,-1,44,43,42,-1,214,215,217,-1,222,287,206,-1,206,208,222,-1,39,1,135,-1,135,288,39,-1,220,2,289,-1,2,40,289,-1,214,212,215,-1,46,194,47,-1,35,127,33,-1,290,31,183,-1,31,30,183,-1,291,292,293,-1,292,162,293,-1,294,22,21,-1,21,20,294,-1,25,15,26,-1,25,86,15,-1,88,165,295,-1,88,249,165,-1,17,93,18,-1,59,6,8,-1,7,284,9,-1,200,227,191,-1,191,232,200,-1,207,210,205,-1,207,221,210,-1,44,42,45,-1,282,221,218,-1,221,282,210,-1,296,195,192,-1,196,195,296,-1,164,249,248,-1,249,164,165,-1,292,297,298,-1,297,292,291,-1,290,299,300,-1,290,301,299,-1,28,302,303,-1,302,28,31,-1,304,291,305,-1,304,297,291,-1,163,292,294,-1,292,163,162,-1,305,293,306,-1,305,291,293,-1,136,299,130,-1,300,299,136,-1,241,238,177,-1,238,241,286,-1,243,172,244,-1,173,172,243,-1,287,260,257,-1,260,287,55,-1,53,220,289,-1,218,220,53,-1,211,214,217,-1,211,283,214,-1,222,209,216,-1,208,209,222,-1,259,69,257,-1,67,69,259,-1,52,283,282,-1,214,283,52,-1,135,259,288,-1,67,259,135,-1,258,288,259,-1,288,258,270,-1,307,158,233,-1,158,307,308,-1,238,154,155,-1,238,237,154,-1,70,235,236,-1,70,237,235,-1,229,279,14,-1,229,228,279,-1,83,16,84,-1,83,280,16,-1,309,281,75,-1,58,281,309,-1,79,11,228,-1,11,79,284,-1,66,221,207,-1,66,219,221,-1,281,10,230,-1,10,281,58,-1,6,65,231,-1,6,59,65,-1,269,307,266,-1,308,307,269,-1,310,233,190,-1,233,310,307,-1,7,231,12,-1,7,6,231,-1,285,78,265,-1,79,78,285,-1,301,185,24,-1,301,182,185,-1,159,25,187,-1,159,86,25,-1,311,42,278,-1,45,42,311,-1,115,251,253,-1,115,114,251,-1,105,123,106,-1,256,123,105,-1,225,197,196,-1,225,202,197,-1,312,91,275,-1,92,91,312,-1,168,23,169,-1,21,23,168,-1,274,271,273,-1,274,272,271,-1,223,266,5,-1,223,269,266,-1,253,167,111,-1,167,253,254,-1,264,262,248,-1,262,264,263,-1,215,198,204,-1,198,215,224,-1,251,313,252,-1,107,313,251,-1,18,166,250,-1,166,18,93,-1,87,167,137,-1,167,87,97,-1,252,314,315,-1,313,314,252,-1,19,250,295,-1,250,19,18,-1,315,170,316,-1,314,170,315,-1,295,163,19,-1,295,165,163,-1,138,246,156,-1,316,246,138,-1,247,156,246,-1,247,264,156,-1,171,268,245,-1,169,268,171,-1,274,298,297,-1,298,274,267,-1,248,317,164,-1,248,262,317,-1,247,318,319,-1,318,247,245,-1,306,317,320,-1,317,306,293,-1,255,263,319,-1,255,140,263,-1,318,271,321,-1,271,318,273,-1,124,304,303,-1,304,124,272,-1,175,142,143,-1,142,175,320,-1,125,303,302,-1,125,124,303,-1,144,173,37,-1,144,147,173,-1,302,136,125,-1,302,300,136,-1,242,176,174,-1,242,184,176,-1,150,242,145,-1,150,179,242,-1,148,37,36,-1,148,144,37,-1,27,130,299,-1,130,27,129,-1,131,286,132,-1,131,188,286,-1,151,240,180,-1,240,151,153,-1,155,177,238,-1,177,155,149,-1,186,239,161,-1,186,240,239,-1,193,161,239,-1,160,161,193,-1,284,12,11,-1,7,12,284,-1,310,266,307,-1,265,266,310,-1,74,227,236,-1,74,191,227,-1,47,192,195,-1,192,47,194,-1,202,277,203,-1,202,225,277,-1,197,213,195,-1,213,197,224,-1,81,49,278,-1,81,46,49,-1,223,44,270,-1,223,43,44,-1,0,135,1,-1,135,0,68,-1,68,219,66,-1,0,219,68,-1,289,50,53,-1,50,289,311,-1,278,50,311,-1,49,50,278,-1,215,213,224,-1,213,215,212,-1,233,54,232,-1,233,158,54,-1,195,48,47,-1,48,195,213,-1,198,203,199,-1,201,203,198,-1,199,277,276,-1,277,199,203,-1,46,82,194,-1,46,81,82,-1};
			return value;
		}
		private int[] getlrib9_Geo_6_80_coordIndex_3()
		{
			int[] value = {261,192,193,-1,192,261,296,-1,265,60,285,-1,265,310,60,-1,76,309,75,-1,76,189,309,-1,152,193,239,-1,193,152,261,-1,161,187,186,-1,159,187,161,-1,241,132,286,-1,132,241,128,-1,183,301,290,-1,183,182,301,-1,184,179,181,-1,184,242,179,-1,35,36,38,-1,36,35,32,-1,35,243,127,-1,35,38,243,-1,255,244,172,-1,244,255,321,-1,320,29,306,-1,320,175,29,-1,321,126,244,-1,271,126,321,-1,319,321,255,-1,319,318,321,-1,320,262,142,-1,262,320,317,-1,272,297,304,-1,274,297,272,-1,264,319,263,-1,264,247,319,-1,293,164,317,-1,164,293,162,-1,245,273,318,-1,268,273,245,-1,171,316,170,-1,171,246,316,-1,249,90,157,-1,249,88,90,-1,168,314,275,-1,168,170,314,-1,139,316,138,-1,315,316,139,-1,295,89,88,-1,89,295,250,-1,313,275,314,-1,312,275,313,-1,315,254,252,-1,315,139,254,-1,312,107,108,-1,312,313,107,-1,166,96,95,-1,96,166,100,-1,71,196,296,-1,226,196,71,-1,72,296,261,-1,72,71,296,-1,153,149,155,-1,153,151,149,-1,148,145,144,-1,150,145,148,-1,146,143,141,-1,174,143,146,-1,131,234,189,-1,131,133,234,-1,128,134,132,-1,129,134,128,-1,92,108,103,-1,92,312,108,-1,121,98,101,-1,121,119,98,-1,117,115,110,-1,117,112,115,-1,114,256,105,-1,113,256,114,-1,96,109,94,-1,99,109,96,-1,110,253,111,-1,253,110,115,-1,106,103,108,-1,103,106,104,-1,21,17,20,-1,17,21,91,-1,267,22,298,-1,22,267,23,-1,189,279,309,-1,279,189,234,-1,289,45,311,-1,40,45,289,-1,24,187,25,-1,185,187,24,-1,61,310,190,-1,61,60,310,-1,260,269,258,-1,260,308,269,-1,13,309,279,-1,13,58,309,-1,8,285,60,-1,8,9,285,-1,14,280,229,-1,280,14,16,-1,13,228,11,-1,228,13,279,-1,158,260,55,-1,158,308,260,-1,49,51,50,-1,49,48,51,-1,39,270,44,-1,39,288,270,-1,206,257,69,-1,287,257,206,-1,209,217,216,-1,209,211,217,-1,282,53,52,-1,282,218,53,-1,37,243,38,-1,37,173,243,-1,32,128,241,-1,32,34,128,-1,36,177,148,-1,177,36,241,-1,306,28,305,-1,28,306,29,-1,305,303,304,-1,303,305,28,-1,31,300,302,-1,300,31,290,-1,299,24,27,-1,301,24,299,-1,298,294,292,-1,298,22,294,-1,19,294,20,-1,294,19,163,-1,12,230,10,-1,230,12,231,-1,0,220,219,-1,0,2,220,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib9_Coord_7_80_point_1()
		{
			double[] value = {.60508,45.36218,-2.70554,.6479,45.32442,-2.70747,.62413,45.35356,-2.66896,1.13281,45.42053,-3.26734,.95006,45.48189,-3.15127,.92565,45.49654,-3.18936,.99296,45.53793,-3.37736,1.03739,45.45426,-3.34343,.93727,45.56251,-3.34174,.97234,45.51013,-3.30707,1.09406,45.43067,-3.53667,1.11356,45.38039,-3.4006,1.06966,45.42295,-3.41918,1.15853,45.40279,-3.5305,1.2718,45.40819,-3.47124,1.58832,45.44991,-3.71426,1.30965,45.42909,-3.45941,4.54799,42.33053,.89638,4.52136,42.36083,.88984,4.66865,42.64181,.37775,4.6982,42.58732,.38102,4.72784,42.51745,.39159,4.85011,42.84353,-.23473,4.84507,42.79339,-.25276,2.09785,45.37705,-3.9142,1.91192,45.43618,-3.8002,1.8942,45.41393,-3.82057,2.0809,45.34936,-3.92762,4.17545,44.3699,-2.97695,4.10341,44.44698,-2.93954,3.34587,44.83205,-3.51507,3.31283,44.76364,-3.59445,2.41818,45.20113,-4.10635,2.66073,44.89012,-3.93497,2.3086,45.06538,-3.9989,2.75818,45.00354,-3.99583,2.50582,45.31548,-4.13933,2.92182,45.2163,-4.02287,2.87131,45.13733,-4.04719,.66606,45.31538,-2.70886,.65456,45.35248,-2.65397,.98345,45.45801,-3.0868,.83433,45.41946,-2.89949,.76446,45.41345,-2.95736,.72613,45.36417,-2.85684,.7685,45.39387,-2.80593,1.00172,45.59738,-3.08151,.99177,45.65156,-3.09623,.88389,45.66995,-2.91033,.86794,45.56901,-2.92213,.76943,45.56432,-2.77661,.80469,45.68311,-2.74647,.61274,45.65299,-2.59422,.5937,45.54562,-2.58603,.64068,45.698,-3.07787,.53335,45.64794,-2.95603,.6984,45.7952,-3.07316,.6316,45.77617,-2.91483,1.13224,45.44719,-3.60443,.94938,45.63334,-3.42711,.91336,45.59025,-3.33601,.94011,45.66598,-3.42824,1.02421,45.64462,-3.65708,.9708,45.67706,-3.515,1.0419,45.67482,-3.67277,.96654,45.64904,-3.50856,.5236,45.47596,-2.79041,.557,45.38107,-2.80702,.57475,45.37548,-2.78309,.51362,45.48698,-2.84149,1.39505,45.80647,-3.62188,1.07756,45.88089,-3.4109,1.44027,45.86316,-3.6102,1.03592,45.82544,-3.39476,1.29094,45.70544,-3.73014,1.10389,45.57347,-3.70106,1.32014,45.609,-3.76872,1.11892,45.41602,-3.28505,1.02006,45.48187,-3.24613,1.06884,45.42363,-3.30571,1.15448,45.43391,-3.20959,1.00808,45.51447,-3.06557,1.17308,45.50102,-3.19915,1.2735,45.4247,-3.30755,1.37519,45.4732,-3.43784,1.41144,45.5398,-3.42517,1.62831,45.47346,-3.65431,4.58372,42.58304,1.00022,4.72242,42.83386,.45992,4.56029,42.53631,.9554,4.77196,42.8844,.52021,4.57812,42.26876,.90259,4.46316,42.09835,1.22954,4.39199,42.18218,1.18462,4.30308,42.23088,1.49621,4.41671,42.36097,1.22091,4.28495,42.19065,1.45753,4.43928,42.38403,1.28269,4.30499,42.14225,1.43325,4.30941,42.17818,1.45504};
			return value;
		}
		private double[] getlrib9_Coord_7_80_point_2()
		{
			double[] value = {4.28505,42.14354,1.42585,4.31864,42.10001,1.41998,4.30848,42.09263,1.40237,4.38164,42.02802,1.38821,4.38715,42.04726,1.40853,4.42886,42.09713,1.45123,4.40405,42.04626,1.41522,4.44735,42.09671,1.4587,4.4127,42.02985,1.40392,4.32139,42.21203,1.48587,4.35374,42.21775,1.53812,4.3534,42.248,1.5572,4.41176,42.21811,1.49134,4.42867,42.20066,1.4847,4.4081,42.19637,1.54522,4.38302,42.21102,1.55245,4.36397,42.21083,1.44789,4.39417,42.2225,1.48293,4.34352,42.18693,1.41558,4.34747,42.16406,1.40646,4.38895,42.09896,1.40061,4.35988,42.13551,1.39833,4.39674,42.16669,1.42939,4.41495,42.09721,1.41897,4.15649,44.18193,-2.97273,3.31416,44.59897,-3.57965,4.16767,44.18486,-2.98615,3.32733,44.59572,-3.59789,2.01689,45.22927,-3.98906,2.01678,45.22718,-3.95,2.30807,45.0709,-3.96612,1.54052,45.45752,-3.80965,1.84321,45.33736,-3.92647,1.55134,45.43117,-3.77042,1.84648,45.32973,-3.88495,.61751,45.34377,-2.78695,2.6583,44.88263,-3.90078,4.59947,42.59776,1.02071,4.79965,42.87259,.53652,4.62806,42.5906,1.04438,4.78428,44.35701,-2.20753,4.29797,44.79496,-2.94042,4.75456,44.34986,-2.19979,4.26794,44.78935,-2.92405,3.0098,45.35005,-3.97885,3.00804,45.39126,-3.94246,3.57842,45.14171,-3.58702,3.57098,45.09101,-3.62195,2.632,45.49527,-4.07982,2.17777,45.64342,-3.99981,2.64609,45.52397,-4.03953,2.19202,45.6627,-3.95779,1.70563,45.79966,-3.71016,2.00189,45.7277,-3.87546,1.68569,45.79593,-3.74905,1.9865,45.71804,-3.9075,4.94564,43.16707,-.06013,4.91454,43.16551,-.07636,.63387,45.65879,-3.06216,1.66927,45.50088,-3.59395,1.44112,45.65068,-3.45533,1.68613,45.59178,-3.5845,4.87387,43.15778,-.7081,4.81604,42.91292,-.22522,4.9077,43.28559,-.64294,4.82464,43.04703,-.16995,4.40578,42.29078,1.18956,4.47221,42.40843,1.33945,4.75997,42.50776,.41826,4.87861,42.78973,-.23754,4.8042,42.61295,.47949,4.9644,42.89717,-.15424,4.33212,44.73019,-2.99269,3.54167,45.01892,-3.63783,3.5513,45.13439,-3.55574,4.15779,44.59741,-2.93254,3.40809,44.9541,-3.52985,2.14623,45.56899,-4.02983,2.19688,45.47256,-3.83216,2.61925,45.51691,-3.93114,2.25494,45.62367,-3.89798,2.51086,45.38266,-3.8859,2.43148,45.26446,-3.87718,2.75919,45.0841,-3.80573,2.85174,45.22611,-3.8449,2.14246,45.41064,-3.81192,1.99454,45.53316,-3.72462,1.9539,45.46342,-3.73144,1.56552,45.63493,-3.88484,1.30986,45.49665,-3.69459,.89734,45.72189,-3.32502,1.04447,45.76991,-3.45092,1.13748,45.78314,-3.29696,1.47019,45.77788,-3.51232,1.16624,45.62948,-3.23751,.94989,45.79438,-3.15757,.97635,45.92135,-3.31193,.89835,45.9291,-3.23683,.77392,45.9286,-3.09625,.81357,45.847,-3.28495};
			return value;
		}
		private double[] getlrib9_Coord_7_80_point_3()
		{
			double[] value = {.80952,45.81547,-3.28281,.78825,45.95016,-3.18182,.85859,45.94727,-3.27849,.81827,45.92198,-3.3096,.71485,45.89583,-2.88977,.56277,45.69103,-2.76828,.49112,45.6422,-2.87715,.53179,45.60576,-2.78651,.57246,45.73533,-2.82635,.62232,45.76159,-2.74862,.5772,45.63855,-2.67355,.61128,45.71475,-2.68666,.81041,45.79438,-2.76775,.86156,45.80667,-2.96795,.6334,45.68739,-2.60787,.76876,45.89239,-2.83277,.66293,45.80827,-2.74874,.65817,45.74767,-2.67195,.56153,45.54553,-2.58959,.56273,45.449,-2.68384,.60432,45.41472,-2.61218,.5675,45.56388,-2.67244,.60265,45.77738,-2.84429,.71145,45.40865,-3.00134,.80341,45.93118,-3.05439,.93795,45.93572,-3.33846,.99442,45.90341,-3.35758,1.03978,45.78979,-3.40523,1.16756,45.37093,-3.39338,1.21138,45.38154,-3.3632,1.03657,45.53474,-3.58257,1.01821,45.52622,-3.45731,.80398,45.77001,-3.2824,.79577,45.72345,-3.2673,1.32731,45.47022,-3.6475,1.62655,45.70396,-3.81405,1.34167,45.74558,-3.66633,1.65351,45.74067,-3.78362,1.92776,45.62301,-3.95813,1.73811,45.71341,-3.6521,2.04267,45.65876,-3.80452,2.08248,45.41441,-4.09185,2.95271,45.39695,-3.87568,3.47148,44.84275,-3.67271,4.25197,44.44396,-3.01829,5.00316,43.15013,-.67581,4.97392,43.06708,-.0869,5.04541,43.33561,-.58706,4.9802,43.41457,-.58251,4.87087,43.11355,-.11785,4.54192,42.47128,.9076,4.42804,42.20784,1.55735,4.51973,42.29967,1.37509,4.38938,42.23929,1.57366,4.50057,42.3888,1.36719,4.8009,44.24964,-2.26926,4.42954,42.13028,1.44654,.51912,45.49398,-2.88126,.61305,45.40589,-2.93399,.56807,45.38588,-2.84422,.56889,45.51496,-2.94737,1.44284,45.86269,-3.56046,4.97992,43.68737,-1.07292,5.01231,43.69289,-1.05868,5.01537,43.42584,-.56567,.90576,45.56849,-3.24694,.83184,45.54673,-3.19346,4.89255,43.02587,-.75244,4.93617,43.03181,-.73951,.66645,45.46542,-3.03395,.66092,45.36694,-2.90645,4.6339,43.79563,-2.29959,4.6202,43.79382,-2.29558,4.90077,43.26969,-1.26659,4.87003,43.2739,-1.27365,4.60327,42.26804,.92789,.95721,45.8677,-3.36257,.90751,45.91738,-3.35501,.8528,45.47366,-2.89342,1.18979,45.39888,-3.52709,1.23097,45.39055,-3.34614,1.08023,45.55194,-3.67361,.56713,45.62024,-2.59477,.59243,45.65822,-2.61151,1.06886,45.41617,-3.32795,.94366,45.53393,-3.28888,1.86846,45.51576,-4.00623,.49891,45.64586,-2.91674,.64319,45.33863,-2.81471,.63495,45.41349,-2.60973,2.74254,45.03187,-3.88262,4.89486,43.39753,-1.22467,4.90695,43.10956,-.71776,4.8575,43.42979,-1.22416,4.84676,42.86111,-.23,4.6899,42.76437,.40971,1.11165,45.88531,-3.36538,4.89835,43.38136,-1.22863,4.90942,43.09263,-.72345,2.39731,45.20233,-3.95374};
			return value;
		}
		private double[] getlrib9_Coord_7_80_point_4()
		{
			double[] value = {2.73605,45.01377,-3.8915,2.40724,45.21828,-3.94412,3.31004,44.74421,-3.60291,4.17711,44.35098,-2.98277,4.64278,43.91759,-2.28657,4.63872,43.93395,-2.28308,4.59586,43.97173,-2.26286,.78771,45.60071,-3.2131,.64723,45.54418,-3.04851,1.15725,45.45415,-3.62481,.87434,45.60987,-3.25847,.77134,45.45114,-2.7779,4.48459,42.09529,1.26254,4.51112,42.17277,1.32455,4.65107,42.37067,.99286,4.65918,42.50479,1.04573,4.83028,42.7751,.53173,4.89439,43.56352,-1.16747,4.99325,43.4277,-1.1913,5.03255,43.61117,-1.12502,4.65261,44.1797,-2.24476,4.73399,43.99485,-2.30151};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib10_Geo_6_85_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,7,10,8,-1,1,0,11,-1,12,13,14,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,20,22,21,-1,13,12,23,-1,12,24,23,-1,25,26,27,-1,27,28,25,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,33,36,34,-1,37,38,39,-1,38,40,39,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,50,53,51,-1,54,55,56,-1,54,57,55,-1,58,59,60,-1,58,61,59,-1,62,63,64,-1,64,33,62,-1,65,64,63,-1,65,66,64,-1,67,0,2,-1,32,68,69,-1,68,70,69,-1,71,72,73,-1,72,74,73,-1,75,76,77,-1,78,51,11,-1,78,52,51,-1,79,75,77,-1,79,80,75,-1,81,32,69,-1,81,30,32,-1,53,50,82,-1,83,84,85,-1,83,86,84,-1,87,88,89,-1,89,90,87,-1,51,53,54,-1,11,0,79,-1,91,92,50,-1,50,93,91,-1,41,83,94,-1,41,43,95,-1,96,97,98,-1,96,99,97,-1,100,28,101,-1,101,102,100,-1,103,104,14,-1,14,13,103,-1,105,106,26,-1,106,27,26,-1,107,108,109,-1,107,110,108,-1,27,111,112,-1,27,106,111,-1,113,114,115,-1,115,116,113,-1,117,118,119,-1,118,120,119,-1,121,122,123,-1,122,124,123,-1,125,126,127,-1,126,128,127,-1,129,130,15,-1,130,131,15,-1,132,133,9,-1,134,135,136,-1,132,8,137,-1,8,138,137,-1,9,8,132,-1,139,140,47,-1,39,141,47,-1,45,142,143,-1,45,144,142,-1,145,57,146,-1,145,147,57,-1,148,46,45,-1,148,149,46,-1,150,151,152,-1,150,153,151,-1,154,91,93,-1,154,88,91,-1,155,156,2,-1,2,1,155,-1,41,157,87,-1,42,41,94,-1,81,69,85,-1,85,84,81,-1,32,29,74,-1,158,159,67,-1,67,2,158,-1,97,99,160,-1,160,67,97,-1,125,161,162,-1,161,163,162,-1,25,73,74,-1,74,29,25,-1,112,164,101,-1,164,104,101,-1,104,107,14,-1,104,164,107,-1,165,166,119,-1,165,167,166,-1,168,169,166,-1,166,167,168,-1,18,129,15,-1,18,170,129,-1,171,172,173,-1,172,174,173,-1,175,176,177,-1,178,179,180,-1,179,181,180,-1,182,4,180,-1,182,183,4,-1,3,132,137,-1,172,184,174,-1,184,185,174,-1,186,123,124,-1,186,187,123,-1,24,21,167,-1,21,168,167,-1,188,108,110,-1,188,189,108,-1,98,190,96,-1,100,191,71,-1,71,73,100,-1,127,128,98,-1,98,97,127,-1,192,193,194,-1,159,127,67,-1,127,97,67,-1,195,72,163,-1,163,196,195,-1,86,83,41,-1,41,90,86,-1,81,76,75,-1,197,198,82,-1,82,199,200,-1,82,198,199,-1,54,53,146,-1,146,57,54,-1,201,202,203,-1,201,204,202,-1,205,206,55,-1,47,207,48,-1,47,37,39,-1,49,139,47,-1,10,7,208,-1,7,135,134,-1,134,208,7,-1,5,4,183,-1,183,136,5,-1,137,138,209,-1,138,210,209,-1,211,212,213,-1,212,171,213,-1,214,215,201,-1,214,216,215,-1,125,159,161,-1,125,127,159,-1,217,164,112,-1,112,111,217,-1,218,217,111,-1,110,164,217,-1,110,107,164,-1,13,23,219,-1,219,103,13,-1,194,106,105,-1,105,192,194,-1,160,192,220,-1,160,99,192,-1,90,41,87,-1,95,157,41,-1,155,51,56,-1,56,221,155,-1,77,76,154,-1,154,78,77,-1,85,222,83,-1,222,94,83,-1,50,52,93,-1,79,160,220,-1,220,80,79,-1,195,68,74,-1,74,72,195,-1,153,199,198,-1,198,151,153,-1,223,68,224,-1,32,74,68,-1,225,226,48,-1,48,207,225,-1,49,35,34,-1,33,64,148,-1,148,36,33,-1,51,54,56,-1,207,47,141,-1,227,48,226,-1,228,216,214,-1,144,44,229,-1,144,45,44,-1,230,68,195,-1,230,224,68,-1,231,197,232,-1,231,223,197,-1,37,47,140,-1,25,29,26,-1,20,17,22,-1,20,18,17,-1,15,131,16,-1,1,11,51,-1,51,155,1,-1,10,208,233,-1,3,5,133,-1,133,132,3,-1,234,235,58,-1,225,235,234,-1,61,38,236,-1,40,38,61,-1,237,143,142,-1,237,238,143,-1,227,239,62,-1,227,226,239,-1,197,224,198,-1,223,224,197,-1,232,240,231,-1,240,232,241,-1,242,195,196,-1,242,230,195,-1,243,158,244,-1,243,245,158,-1,44,214,229,-1,214,44,228,-1,204,221,206,-1,221,204,246,-1,65,146,200,-1,145,146,65,-1,247,62,239,-1};
			return value;
		}
		private int[] getlrib10_Geo_6_85_coordIndex_2()
		{
			int[] value = {63,62,247,-1,207,235,225,-1,235,207,141,-1,60,147,248,-1,147,60,205,-1,249,142,144,-1,249,236,142,-1,143,148,45,-1,143,36,148,-1,235,39,40,-1,235,141,39,-1,139,34,238,-1,34,139,49,-1,149,199,153,-1,149,66,199,-1,228,46,150,-1,44,46,228,-1,205,59,202,-1,205,60,59,-1,66,148,64,-1,149,148,66,-1,224,151,198,-1,151,224,230,-1,231,68,223,-1,70,68,231,-1,94,240,42,-1,222,240,94,-1,157,92,91,-1,92,157,95,-1,215,156,246,-1,244,156,215,-1,76,88,154,-1,76,89,88,-1,218,106,194,-1,218,111,106,-1,250,100,102,-1,100,250,191,-1,251,178,252,-1,179,178,251,-1,253,130,254,-1,253,255,130,-1,129,256,257,-1,256,129,170,-1,258,259,260,-1,259,258,261,-1,6,252,178,-1,6,209,252,-1,244,216,243,-1,216,244,215,-1,128,262,263,-1,128,126,262,-1,264,169,265,-1,264,166,169,-1,212,172,171,-1,172,212,266,-1,175,115,184,-1,115,175,116,-1,267,268,269,-1,267,270,268,-1,271,212,211,-1,271,272,212,-1,210,233,273,-1,138,233,210,-1,3,209,6,-1,3,137,209,-1,114,136,183,-1,134,136,114,-1,135,9,133,-1,135,7,9,-1,185,274,174,-1,181,274,185,-1,150,216,228,-1,152,216,150,-1,56,206,221,-1,206,56,55,-1,152,230,242,-1,230,152,151,-1,244,2,156,-1,2,244,158,-1,81,89,76,-1,81,84,89,-1,162,126,125,-1,162,275,126,-1,99,193,192,-1,99,96,193,-1,275,71,191,-1,71,275,162,-1,194,276,218,-1,193,276,194,-1,98,263,190,-1,128,263,98,-1,277,191,250,-1,191,277,275,-1,218,278,217,-1,276,278,218,-1,190,118,279,-1,263,118,190,-1,250,280,277,-1,250,219,280,-1,281,278,279,-1,281,188,278,-1,280,119,120,-1,165,119,280,-1,188,282,189,-1,281,282,188,-1,12,107,109,-1,107,12,14,-1,283,189,282,-1,283,284,189,-1,19,109,261,-1,109,19,12,-1,283,122,285,-1,265,122,283,-1,21,186,168,-1,21,22,186,-1,260,268,256,-1,286,268,260,-1,285,121,269,-1,122,121,285,-1,187,22,17,-1,186,22,187,-1,173,270,267,-1,270,173,287,-1,187,211,123,-1,187,271,211,-1,254,274,253,-1,287,274,254,-1,131,288,272,-1,131,289,288,-1,253,181,179,-1,181,253,274,-1,288,175,266,-1,288,176,175,-1,289,176,288,-1,289,290,176,-1,4,178,180,-1,4,6,178,-1,114,182,115,-1,114,183,182,-1,181,182,180,-1,181,185,182,-1,113,177,273,-1,291,113,116,-1,291,177,113,-1,251,292,290,-1,252,292,251,-1,292,273,177,-1,292,210,273,-1,177,290,292,-1,176,290,177,-1,210,252,209,-1,210,292,252,-1,177,116,175,-1,177,291,116,-1,185,115,182,-1,185,184,115,-1,255,290,289,-1,251,290,255,-1,289,130,255,-1,130,289,131,-1,272,266,212,-1,272,288,266,-1,174,287,173,-1,174,274,287,-1,287,257,270,-1,287,254,257,-1,271,17,16,-1,17,271,187,-1,267,171,173,-1,267,213,171,-1,18,258,170,-1,20,258,18,-1,269,286,285,-1,269,268,286,-1,261,20,19,-1,20,261,258,-1,124,168,186,-1,168,124,169,-1,285,284,283,-1,285,286,284,-1,265,282,264,-1,265,283,282,-1,284,108,189,-1,284,259,108,-1,23,167,165,-1,23,24,167,-1,281,264,282,-1,117,264,281,-1,219,165,280,-1,219,23,165,-1,279,117,281,-1,279,118,117,-1,188,217,278,-1,188,110,217,-1,219,102,103,-1,102,219,250,-1,120,277,280,-1,277,120,262,-1,276,279,278,-1,190,279,276,-1,27,101,28,-1,101,27,112,-1,275,262,126,-1,275,277,262,-1,72,162,163,-1,72,71,162,-1,192,31,220,-1,192,105,31,-1,196,161,245,-1,196,163,161,-1,220,30,80,-1,220,31,30,-1,231,222,70,-1,231,240,222,-1,154,52,78,-1,154,93,52,-1,152,243,216,-1,243,152,242,-1,215,204,201,-1,215,246,204,-1,66,200,199,-1,66,65,200,-1,286,259,284,-1,260,259,286,-1,8,233,138,-1,8,10,233,-1,136,133,5,-1,135,133,136,-1,233,113,273,-1,113,233,208,-1,113,134,114,-1,208,134,113,-1,272,16,131,-1,271,16,272,-1,123,213,121,-1,123,211,213,-1,270,256,268,-1,270,257,256,-1,144,203,249,-1,203,144,229,-1,266,184,172,-1,184,266,175,-1,265,124,122,-1,265,169,124,-1,117,166,264,-1,117,119,166,-1,263,120,118,-1,263,262,120,-1,245,159,158,-1,159,245,161,-1};
			return value;
		}
		private int[] getlrib10_Geo_6_85_coordIndex_3()
		{
			int[] value = {105,29,31,-1,105,26,29,-1,260,170,258,-1,260,256,170,-1,108,261,109,-1,108,259,261,-1,130,257,254,-1,130,129,257,-1,255,179,251,-1,253,179,255,-1,101,103,102,-1,103,101,104,-1,193,190,276,-1,96,190,193,-1,70,85,69,-1,85,70,222,-1,92,232,50,-1,92,241,232,-1,160,0,67,-1,160,79,0,-1,88,157,91,-1,88,87,157,-1,95,241,92,-1,241,95,43,-1,84,90,89,-1,84,86,90,-1,77,11,79,-1,77,78,11,-1,81,80,30,-1,81,75,80,-1,232,82,50,-1,232,197,82,-1,48,35,49,-1,35,48,227,-1,202,249,203,-1,202,59,249,-1,248,145,247,-1,147,145,248,-1,229,201,203,-1,229,214,201,-1,153,46,149,-1,46,153,150,-1,140,238,237,-1,238,140,139,-1,239,248,247,-1,234,248,239,-1,236,59,61,-1,236,249,59,-1,205,57,147,-1,57,205,55,-1,58,248,234,-1,248,58,60,-1,145,63,247,-1,145,65,63,-1,53,200,146,-1,53,82,200,-1,246,155,221,-1,155,246,156,-1,202,206,205,-1,206,202,204,-1,242,245,243,-1,242,196,245,-1,241,42,240,-1,42,241,43,-1,237,37,140,-1,237,38,37,-1,35,62,33,-1,62,35,227,-1,238,36,143,-1,36,238,34,-1,236,237,142,-1,38,237,236,-1,58,40,61,-1,58,235,40,-1,226,234,239,-1,234,226,225,-1,73,28,100,-1,25,28,73,-1,12,21,24,-1,12,19,21,-1,213,269,121,-1,213,267,269,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib10_Coord_7_85_point_1()
		{
			double[] value = {1.0907,44.72244,-3.35324,1.04022,44.7229,-3.30272,1.06712,44.78875,-3.26396,4.58891,41.72196,.86668,4.62421,41.73733,.89525,4.61416,41.74157,.90708,4.59805,41.70992,.84674,4.57457,41.88262,.99564,4.52563,41.78997,.89079,4.56665,41.79309,.90427,4.52564,41.86353,1.0013,1.03172,44.70554,-3.31643,4.00135,43.16623,-2.79163,3.61296,43.37509,-3.19313,3.59822,43.31722,-3.24197,4.54396,42.62218,-1.5632,4.50546,42.67318,-1.48871,4.41246,42.86931,-1.8796,4.43625,42.79722,-1.99557,4.16117,43.05399,-2.54194,4.27307,42.94309,-2.31737,4.11692,43.08849,-2.43146,4.24845,42.98958,-2.20236,3.61483,43.42242,-3.11906,3.94993,43.20193,-2.68831,1.86029,44.24037,-4.04112,1.85751,44.2351,-4.07479,2.21027,44.02474,-4.11122,2.22157,44.07861,-4.09551,1.37074,44.4585,-3.70672,1.19475,44.52468,-3.48897,1.35686,44.4918,-3.75742,1.23806,44.48783,-3.36583,.70125,44.33566,-2.57214,.69137,44.38998,-2.52113,.68446,44.35156,-2.55798,.70598,44.39151,-2.52316,.62084,44.57781,-2.51479,.61559,44.67352,-2.52463,.61963,44.54726,-2.53032,.62245,44.6039,-2.54794,1.06447,44.50257,-3.25368,1.07405,44.46472,-3.17316,1.01709,44.46441,-3.14908,.73694,44.8141,-2.61777,.71881,44.59821,-2.48554,.79448,44.62443,-2.5732,.63287,44.48283,-2.50587,.65231,44.41273,-2.55172,.65317,44.42234,-2.51596,.90984,44.52673,-3.12715,.95307,44.65096,-3.2005,.95117,44.63413,-3.21276,.8992,44.53777,-3.1127,.88183,44.57485,-3.11263,.77426,44.55873,-2.92457,.88211,44.59034,-3.10665,.78744,44.50762,-2.91667,.63259,44.50786,-2.60013,.63555,44.69782,-2.59419,.6463,44.51171,-2.6312,.62625,44.63634,-2.56369,.6877,44.33823,-2.61571,.7072,44.3451,-2.67043,.72598,44.32005,-2.61309,.75349,44.38692,-2.76579,.791,44.34741,-2.7094,1.40724,44.722,-3.7702,1.1492,44.48181,-3.17701,1.21708,44.48147,-3.35643,1.14865,44.47866,-3.18358,1.87159,44.2682,-3.95514,1.4127,44.42957,-3.63491,1.86314,44.24642,-4.00725,1.39975,44.42748,-3.65298,1.12801,44.62533,-3.47517,1.08177,44.61643,-3.4405,1.10314,44.65442,-3.45029,1.02337,44.68711,-3.32577,1.1117,44.66542,-3.45094,1.14157,44.62692,-3.49102,1.1708,44.52753,-3.46357,.91495,44.52029,-3.10845,1.16604,44.45755,-3.34322,1.14533,44.50319,-3.43722,1.17875,44.45541,-3.34886,1.14053,44.49811,-3.41584,1.01014,44.57318,-3.33457,1.00452,44.58955,-3.34658,1.06764,44.57039,-3.42134,1.06585,44.55888,-3.39625,.94383,44.56222,-3.24414,.92185,44.50528,-3.14804,.94877,44.60761,-3.23043,1.12437,44.46547,-3.20447,.9323,44.49979,-3.16041,2.25759,44.35036,-4.19693,1.90298,44.5219,-4.07966,2.28162,44.41506,-4.15501,1.87839,44.4451,-4.10652};
			return value;
		}
		private double[] getlrib10_Coord_7_85_point_2()
		{
			double[] value = {2.22927,44.0958,-4.03725,2.74481,43.76769,-3.94278,2.75733,43.85976,-3.89602,3.12928,43.6531,-3.66933,3.10407,43.57167,-3.70967,1.85642,44.25344,-4.11052,2.21588,44.02763,-4.13862,3.58936,43.26569,-3.32103,4.02533,43.0702,-2.92432,4.00025,43.05694,-2.90317,3.59757,43.27387,-3.34768,2.70898,43.69203,-4.00054,2.70651,43.69484,-3.96391,4.53816,41.90391,1.10356,4.59136,41.8983,1.09788,4.67631,42.05927,.73823,4.61991,42.05785,.73827,3.71878,43.80469,-3.03942,3.23103,44.11377,-3.60927,3.69957,43.78168,-3.00792,3.22261,44.09918,-3.57177,4.50497,43.15385,-1.66493,4.38068,43.31408,-1.99594,4.47521,43.13266,-1.65523,4.34485,43.29001,-1.97232,1.94721,44.57521,-3.96407,2.32269,44.46446,-4.02985,1.94026,44.59791,-4.02955,2.332,44.48874,-4.07516,4.57541,42.56011,-1.64982,4.65522,42.40793,-1.2247,4.58054,42.47589,-1.11667,4.56296,41.75796,.86139,4.60796,41.76324,.88561,4.57475,41.88939,1.09201,4.60663,41.87134,.99816,4.59618,41.83479,1.02769,4.56558,41.71493,.84935,4.51085,41.77022,.90805,.65064,44.51479,-2.48605,.62815,44.56375,-2.4951,.62238,44.49159,-2.54998,.63197,44.71069,-2.50818,.69126,44.56831,-2.47228,.6514,44.76935,-2.54254,.73901,44.40245,-2.76363,.79633,44.45612,-2.91595,.72881,44.45976,-2.7359,.7331,44.38522,-2.54483,.802,44.38376,-2.66092,.87774,44.59715,-2.78156,.99319,44.47018,-3.03765,.97945,44.61661,-3.02171,.88192,44.42118,-2.85586,.99922,44.62629,-3.33898,.97911,44.7166,-3.17175,.98004,44.7664,-3.15429,.95377,44.54706,-3.24298,1.09031,44.85135,-3.23821,1.44155,44.77867,-3.71201,1.37082,44.65082,-3.81043,1.46238,44.77024,-3.66728,1.91079,44.38253,-3.94132,1.46243,44.59634,-3.62397,3.07764,43.47071,-3.76903,3.65087,43.61556,-3.05132,4.04289,43.54134,-2.51759,4.00235,43.3668,-2.60291,4.16046,43.25066,-2.30159,4.23082,43.42111,-2.24041,4.43954,42.71406,-2.1107,4.66304,42.75988,-.88285,4.64922,42.58843,-.55032,4.74015,42.66432,-1.014,4.74651,42.51187,-.67897,4.61343,42.28334,.10249,4.58618,42.2213,.02814,4.53566,41.98121,.62434,4.64705,41.83569,.38502,4.68597,42.04078,-.21784,4.67276,41.86682,.4764,4.69713,42.09762,-.16011,4.70003,41.95814,.58997,4.61304,41.83516,1.0229,4.66114,42.28876,.1032,4.73464,42.19104,.00032,4.27837,43.11865,-2.05677,4.44071,42.99927,-1.75143,3.6913,43.47945,-3.35809,4.11427,43.26583,-2.84501,2.84524,44.13663,-4.0328,2.24107,44.14194,-4.00866,1.85441,44.37562,-4.13227,2.23372,44.26725,-4.21634,2.223,44.15072,-4.20184,1.15187,44.49775,-3.17372,1.15541,44.64751,-3.17483,1.02056,44.4705,-3.10146,.98977,44.4538,-3.05024,.87055,44.40882,-2.87358};
			return value;
		}
		private double[] getlrib10_Coord_7_85_point_3()
		{
			double[] value = {.81198,44.44002,-2.91781,.78174,44.86997,-2.82312,.69322,44.76336,-2.67425,.69085,44.84167,-2.66874,.77904,44.78215,-2.85278,.70391,44.54382,-2.73898,.77845,44.62185,-2.89819,.63946,44.43997,-2.55343,4.54656,41.89048,1.09436,4.56697,41.70762,.83403,4.49111,41.76871,.89034,4.54943,42.92645,-1.26827,4.61934,42.74763,-.86994,4.59499,42.94823,-1.27747,.80036,44.86909,-2.80718,.90453,44.85386,-3.01771,.92567,44.8376,-3.00777,3.08246,43.4749,-3.79292,2.75748,43.73496,-4.03497,3.15003,43.73111,-3.61263,1.3454,44.55807,-3.80486,.88842,44.66311,-3.07772,1.13383,44.466,-3.19709,1.08779,44.47604,-3.13762,1.07229,44.46655,-3.11402,.6538,44.41304,-2.5868,.66789,44.36566,-2.60712,.67641,44.35456,-2.58882,.8137,44.85638,-2.79804,.70785,44.84793,-2.64691,1.07541,44.48257,-3.1056,1.08827,44.47562,-3.14722,1.02106,44.47272,-3.11519,4.51192,41.84592,1.02399,.65981,44.41534,-2.61033,.62616,44.50231,-2.57864,.61638,44.69863,-2.53957,.6251,44.67693,-2.50145,.67299,44.55462,-2.47325,.67518,44.36244,-2.63213,1.07934,44.46484,-3.16309,1.0176,44.4639,-3.13389,1.07149,44.63003,-3.09406,1.01699,44.83661,-3.11331,.9962,44.84208,-3.12866,1.11413,44.84265,-3.21874,.8878,44.76218,-3.04834,.68972,44.36165,-2.66777,.67189,44.42299,-2.64193,.62716,44.74854,-2.5713,2.77968,43.9374,-3.84861,4.65232,42.03357,-.21849,4.60065,41.82568,.3767,4.69361,42.28201,-.90285,4.68839,42.41433,-1.23018,4.65931,42.27688,-.89967,4.45726,42.72201,-2.12353,4.59934,42.56681,-1.6583,4.27528,42.85827,-2.46124,4.18942,42.96131,-2.6883,4.30272,42.86953,-2.48065,4.16575,42.94764,-2.67074,2.83287,44.27861,-3.84418,2.84358,44.2991,-3.88534,4.08657,43.58135,-2.55253,4.26215,43.44434,-2.26631,4.59999,42.58103,-.55468,4.67541,42.86329,-1.41088,4.53303,42.88404,-2.01089,4.57801,43.0607,-1.83959,4.64521,42.69354,-1.55546,4.51295,42.81625,-1.34724,4.57074,42.64214,-.93705,4.48982,41.84772,1.01439,4.71684,42.36812,-.81534,2.2745,44.27365,-3.99272,2.80198,43.95817,-4.07348,2.81527,44.14621,-3.83085,3.19725,43.76601,-3.85493,3.24848,43.97267,-3.79702,3.19284,43.94079,-3.56515,3.74565,43.68576,-3.27212,4.14098,43.47477,-2.74698,4.30933,43.33965,-2.46044,4.2697,43.13881,-2.58467,4.44243,43.21077,-2.18241,4.3994,43.02207,-2.33782,4.73593,42.51462,-1.13631,4.57742,42.52231,-.65397,4.60023,42.3557,-.80945,4.59965,42.10513,-.17134,4.59734,42.0405,.71234,4.53626,41.87778,.47021};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib11_Geo_6_90_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,6,7,4,-1,8,9,10,-1,11,10,9,-1,11,12,10,-1,13,14,15,-1,15,16,13,-1,17,18,19,-1,17,20,18,-1,21,22,23,-1,21,24,22,-1,25,26,27,-1,27,28,25,-1,29,30,31,-1,32,33,34,-1,34,35,32,-1,36,37,38,-1,39,40,41,-1,40,36,41,-1,42,43,44,-1,45,46,47,-1,47,48,45,-1,49,50,51,-1,51,52,49,-1,53,54,55,-1,55,56,53,-1,57,58,59,-1,57,60,58,-1,61,62,54,-1,54,63,61,-1,21,49,64,-1,49,52,64,-1,65,24,37,-1,24,66,37,-1,22,67,44,-1,22,68,67,-1,69,70,71,-1,69,72,70,-1,36,73,41,-1,36,38,73,-1,55,54,62,-1,62,74,55,-1,75,76,77,-1,20,78,79,-1,28,79,25,-1,80,71,26,-1,71,70,26,-1,33,78,81,-1,33,79,78,-1,82,83,84,-1,84,85,82,-1,45,86,87,-1,86,27,87,-1,45,48,88,-1,82,85,89,-1,85,75,89,-1,90,91,92,-1,91,93,92,-1,94,95,29,-1,96,29,97,-1,82,98,83,-1,82,99,98,-1,100,101,102,-1,102,98,100,-1,7,103,104,-1,7,105,103,-1,106,107,108,-1,107,109,108,-1,110,111,112,-1,19,102,17,-1,102,14,17,-1,111,113,112,-1,111,114,113,-1,115,116,117,-1,116,118,117,-1,119,120,121,-1,120,122,121,-1,44,67,42,-1,42,123,124,-1,42,125,43,-1,55,126,58,-1,87,26,70,-1,70,127,87,-1,27,26,87,-1,128,77,129,-1,130,131,132,-1,130,133,131,-1,29,95,97,-1,30,29,134,-1,20,17,78,-1,135,99,82,-1,82,89,135,-1,13,136,78,-1,78,17,13,-1,137,138,121,-1,137,139,138,-1,140,141,142,-1,141,143,142,-1,144,145,146,-1,144,147,145,-1,9,8,147,-1,8,148,147,-1,149,106,150,-1,149,107,106,-1,151,152,109,-1,151,153,152,-1,109,8,108,-1,109,152,8,-1,154,108,10,-1,108,8,10,-1,11,9,144,-1,9,147,144,-1,7,6,155,-1,155,105,7,-1,156,157,158,-1,159,160,161,-1,161,136,159,-1,162,163,156,-1,156,135,162,-1,98,164,100,-1,165,162,89,-1,162,135,89,-1,83,98,19,-1,98,102,19,-1,166,167,168,-1,168,34,166,-1,84,83,18,-1,83,19,18,-1,169,170,29,-1,29,96,169,-1,130,132,171,-1,66,69,37,-1,69,38,37,-1,124,172,42,-1,67,173,42,-1,174,175,40,-1,40,176,174,-1,145,177,146,-1,145,178,177,-1,165,179,167,-1,179,168,167,-1,39,117,180,-1,39,115,117,-1,15,101,112,-1,112,113,15,-1,101,15,14,-1,14,102,101,-1,159,155,160,-1,159,105,155,-1,159,16,103,-1,103,105,159,-1,158,135,156,-1,158,99,135,-1,29,31,94,-1,29,170,134,-1,181,182,45,-1,45,88,181,-1,76,75,85,-1,47,46,57,-1,46,45,87,-1,130,20,91,-1,130,18,20,-1,84,171,183,-1,183,85,84,-1,93,79,28,-1,28,184,93,-1,171,132,183,-1,161,81,136,-1,81,78,136,-1,89,75,77,-1,176,39,180,-1,176,40,39,-1,125,185,43,-1,185,186,43,-1,44,23,22,-1,21,64,66,-1,66,24,21,-1,47,57,59,-1,60,55,58,-1,60,56,55,-1,125,42,172,-1,187,87,127,-1,187,46,87,-1,188,43,186,-1,41,115,39,-1,184,27,86,-1,184,28,27,-1,123,42,173,-1,49,21,23,-1,23,188,49,-1,65,68,22,-1,22,24,65,-1,63,189,190,-1,190,61,63,-1,13,17,14,-1,143,4,142,-1,191,192,193,-1,193,194,191,-1,195,1,0,-1,195,196,1,-1,197,198,199,-1,197,200,198,-1,3,201,202,-1,202,203,3,-1,204,202,205,-1,204,206,202,-1,207,198,208,-1,198,207,209,-1,200,202,206,-1,203,202,200,-1,3,210,201,-1,1,210,3,-1,211,205,196,-1,211,204,205,-1,198,191,199,-1,198,209,191,-1,212,200,197,-1,212,203,200,-1,211,195,192,-1,211,196,195,-1,199,194,213,-1,199,191,194,-1,153,197,214,-1,153,212,197,-1,2,215,0,-1,215,2,151,-1,192,216,193,-1,192,195,216,-1,194,217,218,-1,217,194,193,-1,201,205,202,-1,201,210,205,-1,4,219,5,-1,4,143,219,-1,220,189,63,-1,185,189,220,-1,221,61,190,-1,221,222,61,-1,223,65,224,-1,223,68,65,-1,49,186,50,-1,188,186,49,-1,190,123,221,-1,123,190,124,-1,86,225,184,-1,225,86,226,-1,179,116,168,-1,118,116,179,-1};
			return value;
		}
		private int[] getlrib11_Geo_6_90_coordIndex_2()
		{
			int[] value = {227,228,126,-1,228,227,229,-1,230,187,127,-1,231,187,230,-1,185,172,189,-1,185,125,172,-1,174,224,175,-1,174,222,224,-1,189,124,190,-1,189,172,124,-1,72,52,230,-1,72,64,52,-1,44,188,23,-1,44,43,188,-1,130,84,18,-1,130,171,84,-1,183,76,85,-1,183,232,76,-1,169,131,133,-1,131,169,96,-1,92,170,90,-1,92,134,170,-1,182,31,226,-1,182,94,31,-1,97,181,233,-1,181,97,95,-1,232,132,234,-1,183,132,232,-1,47,228,129,-1,228,47,59,-1,45,226,86,-1,182,226,45,-1,235,158,157,-1,158,235,164,-1,111,140,114,-1,236,140,111,-1,237,238,239,-1,238,237,141,-1,167,162,165,-1,240,162,167,-1,163,241,242,-1,163,243,241,-1,146,244,138,-1,177,244,146,-1,178,245,246,-1,245,178,145,-1,213,218,247,-1,194,218,213,-1,240,163,162,-1,240,243,163,-1,227,176,180,-1,227,74,176,-1,72,127,70,-1,72,230,127,-1,60,46,187,-1,57,46,60,-1,229,180,117,-1,180,229,227,-1,115,35,116,-1,115,248,35,-1,76,129,77,-1,129,76,47,-1,90,130,91,-1,130,90,133,-1,89,179,165,-1,179,89,77,-1,240,249,243,-1,250,249,240,-1,167,250,240,-1,167,166,250,-1,164,99,158,-1,99,164,98,-1,250,160,249,-1,161,160,250,-1,110,164,235,-1,164,110,100,-1,163,157,156,-1,163,242,157,-1,249,155,251,-1,160,155,249,-1,111,235,252,-1,235,111,110,-1,253,242,120,-1,242,253,157,-1,251,6,254,-1,155,6,251,-1,114,103,113,-1,114,104,103,-1,253,255,252,-1,253,256,255,-1,137,122,254,-1,137,121,122,-1,140,104,114,-1,104,140,142,-1,256,257,255,-1,256,258,257,-1,258,259,257,-1,258,260,259,-1,139,146,138,-1,139,144,146,-1,237,143,141,-1,237,12,143,-1,259,261,262,-1,260,261,259,-1,262,106,263,-1,262,150,106,-1,246,261,178,-1,246,264,261,-1,148,247,245,-1,148,265,247,-1,8,265,148,-1,8,152,265,-1,265,213,247,-1,265,214,213,-1,152,214,265,-1,152,153,214,-1,216,107,149,-1,215,107,216,-1,264,218,217,-1,246,218,264,-1,147,245,145,-1,147,148,245,-1,264,262,261,-1,264,150,262,-1,260,178,261,-1,177,178,260,-1,259,263,239,-1,259,262,263,-1,219,144,139,-1,219,11,144,-1,258,177,260,-1,244,177,258,-1,239,257,259,-1,257,239,238,-1,219,137,5,-1,219,139,137,-1,244,256,119,-1,244,258,256,-1,255,238,236,-1,255,257,238,-1,5,254,6,-1,5,137,254,-1,120,256,253,-1,120,119,256,-1,252,236,111,-1,252,255,236,-1,241,254,122,-1,251,254,241,-1,252,157,253,-1,157,252,235,-1,16,113,103,-1,16,15,113,-1,243,251,241,-1,249,251,243,-1,161,166,81,-1,161,250,166,-1,34,81,166,-1,33,81,34,-1,184,92,93,-1,184,225,92,-1,234,48,232,-1,234,88,48,-1,118,77,128,-1,77,118,179,-1,248,32,35,-1,32,248,80,-1,88,233,181,-1,234,233,88,-1,73,80,248,-1,73,71,80,-1,59,126,228,-1,126,59,58,-1,41,248,115,-1,248,41,73,-1,187,56,60,-1,231,56,187,-1,224,37,175,-1,37,224,65,-1,217,150,264,-1,149,150,217,-1,246,247,218,-1,246,245,247,-1,119,138,244,-1,119,121,138,-1,242,122,120,-1,242,241,122,-1,236,141,140,-1,236,238,141,-1,154,239,263,-1,239,154,237,-1,108,263,106,-1,108,154,263,-1,107,151,109,-1,107,215,151,-1,112,100,110,-1,100,112,101,-1,131,234,132,-1,131,233,234,-1,117,128,229,-1,118,128,117,-1,131,97,233,-1,96,97,131,-1,95,182,181,-1,182,95,94,-1,134,225,30,-1,92,225,134,-1,170,133,90,-1,170,169,133,-1,232,47,76,-1,232,48,47,-1,80,25,32,-1,80,26,25,-1,72,66,64,-1,69,66,72,-1,91,79,93,-1,20,79,91,-1,74,174,176,-1,74,62,174,-1,231,53,56,-1,231,51,53,-1,38,71,73,-1,38,69,71,-1,173,68,223,-1,68,173,67,-1,51,220,53,-1,220,51,50,-1,222,62,61,-1,222,174,62,-1,63,53,220,-1,53,63,54,-1,230,51,231,-1,51,230,52,-1,229,129,228,-1,129,229,128,-1,126,74,227,-1,126,55,74,-1,36,175,37,-1,175,36,40,-1,116,34,168,-1,116,35,34,-1,79,32,25,-1,32,79,33,-1,226,30,225,-1,30,226,31,-1,223,123,173,-1,223,221,123,-1,222,223,224,-1,221,223,222,-1,50,185,220,-1,50,186,185,-1};
			return value;
		}
		private int[] getlrib11_Geo_6_90_coordIndex_3()
		{
			int[] value = {16,136,13,-1,16,159,136,-1,11,143,12,-1,143,11,219,-1,10,237,154,-1,10,12,237,-1,193,149,217,-1,216,149,193,-1,7,142,4,-1,104,142,7,-1,215,195,0,-1,216,195,215,-1,151,212,153,-1,151,2,212,-1,199,214,197,-1,214,199,213,-1,209,192,191,-1,209,211,192,-1,3,212,2,-1,3,203,212,-1,209,204,211,-1,209,207,204,-1,196,210,1,-1,196,205,210,-1,200,208,198,-1,200,206,208,-1,207,206,204,-1,207,208,206,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib11_Coord_7_90_point_1()
		{
			double[] value = {4.44707,40.9705,.00983,4.4611,40.97917,.03815,4.43927,40.98534,.01383,4.45773,40.9907,.03721,3.6073,42.33199,-2.73919,3.63507,42.37988,-2.66206,2.99076,42.7706,-3.21523,2.91829,42.75353,-3.29057,4.44517,41.46081,-1.09193,4.34,41.68833,-1.48098,4.32773,41.64155,-1.52595,4.18022,41.91298,-1.87679,4.15145,41.86006,-1.93049,1.86565,43.17418,-3.61828,1.84741,43.16801,-3.65266,2.15093,42.95989,-3.61826,2.20713,43.01352,-3.59061,1.34842,43.35779,-3.53606,1.08819,43.40252,-3.49371,1.3435,43.39575,-3.58185,1.12425,43.34705,-3.38278,.68489,43.22486,-2.58528,.71196,43.25516,-2.5537,.68483,43.23703,-2.5738,.72086,43.25432,-2.56045,.93756,43.3243,-3.12083,.89119,43.3269,-3.03569,.90335,43.34304,-3.10044,.93283,43.33241,-3.15751,.87206,43.38368,-3.31535,.87303,43.3353,-3.22273,.85889,43.34872,-3.17111,.95852,43.33618,-3.10744,.9987,43.33519,-3.19705,1.13474,43.47064,-3.15717,1.06092,43.46535,-3.07148,.809,43.46942,-2.62995,.76435,43.35869,-2.5577,.80758,43.37248,-2.63482,.91973,43.56453,-2.7452,.8018,43.50477,-2.63197,.92583,43.55022,-2.7419,.68435,43.32107,-2.53556,.67467,43.28641,-2.57707,.69292,43.28256,-2.54438,.82392,43.42938,-3.11744,.82674,43.43863,-3.09695,.91307,43.53204,-3.18625,.89542,43.52041,-3.205,.65675,43.24256,-2.62397,.64334,43.27054,-2.64297,.63592,43.27713,-2.67551,.64779,43.25902,-2.6765,.63614,43.31982,-2.66323,.63248,43.37032,-2.65275,.66253,43.41406,-2.74312,.65496,43.36119,-2.74656,.83402,43.47387,-3.08871,.73876,43.44008,-2.87911,.84648,43.48501,-3.07863,.72355,43.40019,-2.87708,.66956,43.40992,-2.59014,.6817,43.4386,-2.61476,.63895,43.36057,-2.62263,.68171,43.21737,-2.62153,.74503,43.34882,-2.53569,.73072,43.25096,-2.58535,.70436,43.33133,-2.52835,.72869,43.34583,-2.52867,.74735,43.26626,-2.6869,.79492,43.28299,-2.84618,.81584,43.28929,-2.8318,.71596,43.24362,-2.71345,.89279,43.40982,-2.77009,.73262,43.46913,-2.68066,1.07325,43.57667,-3.32255,1.00174,43.57065,-3.28899,1.1122,43.62778,-3.22109,1.37807,43.3205,-3.47845,.97729,43.32186,-3.20682,.90875,43.3372,-3.02037,1.39921,43.32037,-3.45864,1.4393,43.54766,-3.62866,1.35807,43.46319,-3.62692,1.051,43.49087,-3.47091,1.03608,43.52475,-3.42264,.89427,43.34768,-3.12007,.83229,43.41868,-3.09587,.86783,43.502,-3.23393,1.52543,43.60173,-3.5896,1.01392,43.31613,-3.38364,1.08866,43.33964,-3.37962,.92053,43.31702,-3.25131,.96655,43.32047,-3.21936,.81486,43.40596,-3.16414,.82621,43.452,-3.26367,.89929,43.43042,-3.41007,.86422,43.46015,-3.34944,1.90264,43.30024,-3.72107,1.97708,43.35843,-3.69671};
			return value;
		}
		private double[] getlrib11_Coord_7_90_point_2()
		{
			double[] value = {2.22061,43.05956,-3.69706,2.15124,42.95844,-3.6461,1.84471,43.18489,-3.68946,2.61108,42.83789,-3.47133,2.88994,42.69951,-3.3139,2.66648,42.88209,-3.42066,4.40921,41.33753,-1.16744,4.47491,41.20444,-.8074,4.3849,41.36043,-1.15382,4.45817,41.22757,-.80174,2.59274,42.79689,-3.57834,2.81404,42.61676,-3.41483,2.51902,42.76809,-3.55492,2.52449,42.7836,-3.51358,2.80852,42.61894,-3.36688,1.04728,43.63038,-2.94824,1.13365,43.64954,-3.05518,1.0331,43.65056,-2.95412,1.11176,43.66172,-3.06825,3.90033,42.58206,-2.70423,3.39047,42.91488,-3.21785,3.88475,42.59418,-2.68181,3.38157,42.91552,-3.17859,.67734,43.37595,-2.54378,.66645,43.36437,-2.55737,.66589,43.30638,-2.57864,.77691,43.46881,-2.85427,.72791,43.33525,-2.88092,1.03691,43.60846,-3.10622,.99508,43.57346,-3.13623,1.04264,43.39781,-3.47157,.91051,43.44137,-3.42465,.95641,43.48004,-3.42482,.98751,43.37157,-3.45308,.90224,43.32164,-3.2661,2.05062,43.41508,-3.67587,1.88377,43.18017,-3.58449,3.77463,42.51242,-2.66454,4.21284,42.28544,-2.15155,4.14475,42.1775,-2.13285,3.50042,42.21607,-2.81949,3.85783,41.92257,-2.36556,3.5559,42.27976,-2.78086,3.99481,42.01164,-2.20712,4.2798,41.99747,-1.84167,4.48486,41.83089,-1.38947,4.3666,42.07035,-1.83384,4.41115,41.75672,-1.43598,4.5099,41.53869,-.99796,4.56953,41.21595,-.74551,4.51941,41.38446,-1.11259,4.4664,41.09349,-.36735,4.48642,41.31495,-.73821,4.51999,41.17254,-.32173,4.25604,41.54645,-1.56887,2.71365,42.91241,-3.38213,2.44407,43.25411,-3.65538,2.91305,42.99419,-3.51148,2.37102,43.20964,-3.69271,2.24446,43.03444,-3.52789,2.29698,43.0748,-3.49427,1.9232,43.19951,-3.53308,2.14222,43.46128,-3.63143,2.55981,43.29576,-3.58521,2.28896,43.14815,-3.72474,1.60082,43.6356,-3.53618,1.55379,43.47642,-3.44383,1.62829,43.62132,-3.49313,1.21892,43.65499,-3.16348,.97377,43.36443,-3.43763,.99084,43.31824,-3.38233,1.02593,43.48641,-3.45546,.65752,43.33923,-2.57364,.6896,43.36378,-2.52789,.70915,43.46471,-2.58177,.74584,43.46676,-2.55769,.78017,43.51143,-2.6488,4.38628,42.05813,-1.86188,4.51783,41.81415,-1.4098,1.1932,43.67098,-3.18117,.90143,43.57533,-2.75681,.82783,43.46733,-3.25926,.81439,43.41126,-3.14597,1.01378,43.51391,-3.42315,.92106,43.33405,-3.17437,.65665,43.29751,-2.60969,.65298,43.2668,-2.6202,.71396,43.35492,-2.87863,.66605,43.25032,-2.60248,.64584,43.35235,-2.60157,.66728,43.3939,-2.57551,4.58965,41.10567,.15269,4.57109,41.02802,.11898,4.61708,41.13507,-.26108,4.6575,41.22671,-.20915,4.52621,40.98321,.08256,4.51186,40.99416,.09254,4.5199,41.09249,.11908,4.56759,41.10168,.1518,4.57608,41.11856,.15514};
			return value;
		}
		private double[] getlrib11_Coord_7_90_point_3()
		{
			double[] value = {4.51968,41.07233,.11834,4.48237,41.01751,.0295,4.50169,41.052,.05279,4.49447,41.04582,.09345,4.54248,41.05134,.08211,4.51942,41.02119,.05788,4.52665,41.0816,.07826,4.56553,41.0873,.10777,4.5561,41.09874,.10384,4.57537,41.09058,.15078,4.48424,41.00686,.02932,4.54566,41.03629,.12667,4.48428,41.05606,.08731,4.62821,41.24934,-.19544,4.5671,41.22458,-.25232,4.47894,41.07614,-.37527,4.55721,41.08346,-.31052,4.63453,41.27031,-.69171,4.6708,41.39056,-.60809,4.03904,42.06306,-2.12286,.64644,43.30601,-2.63252,.69509,43.42662,-2.54512,.69743,43.44054,-2.55658,.71242,43.42373,-2.52585,.72541,43.44042,-2.52989,.88743,43.33105,-3.2041,.87146,43.34479,-3.1477,.85212,43.53475,-2.80009,.90791,43.52952,-3.03084,.96441,43.5877,-2.98983,.66556,43.29842,-2.76207,.65195,43.31787,-2.76164,.97788,43.5572,-3.30132,.87002,43.47618,-3.35225,.90277,43.51166,-3.33187,2.76927,42.91934,-3.57923,3.50241,42.2137,-2.85278,4.05197,41.76029,-2.01473,3.87253,41.91535,-2.39544,4.0694,41.74869,-2.03844,2.16272,43.4423,-3.56246,3.03549,43.07916,-3.37083,3.05016,43.08074,-3.41698,2.55445,43.2861,-3.53694,4.23957,42.26249,-2.18248,4.58727,41.59592,-.93547,4.62308,41.56589,-.9432,4.63554,41.42197,-.60267,.98963,43.46005,-2.98463,2.42089,43.17247,-3.47721,2.04144,43.29942,-3.51814,2.88886,43.0059,-3.34017,3.04305,42.7286,-3.39712,3.26313,42.84798,-3.32678,3.21797,42.83845,-3.16174,3.67414,42.29859,-2.82374,3.84126,42.47113,-2.78917,4.02837,42.01302,-2.35037,4.16899,42.14414,-2.27868,4.24421,41.82495,-1.9813,4.34995,41.91275,-1.92802,4.48844,41.67557,-1.49166,4.42151,41.60132,-1.521,4.28269,41.52606,-1.58669,4.58827,41.45121,-1.0649,4.54416,41.38107,-.67504};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlrib12_Geo_6_95_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,4,13,-1,14,5,4,-1,15,16,17,-1,16,18,17,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,26,28,27,-1,29,30,31,-1,30,32,31,-1,28,33,34,-1,35,34,36,-1,37,38,39,-1,38,40,39,-1,41,42,43,-1,41,44,42,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,50,52,51,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,57,60,58,-1,61,62,63,-1,64,65,66,-1,64,37,65,-1,66,67,64,-1,66,68,67,-1,69,70,71,-1,70,72,71,-1,52,73,74,-1,73,75,74,-1,76,77,78,-1,77,79,78,-1,80,11,81,-1,81,82,80,-1,41,83,84,-1,41,85,83,-1,86,87,88,-1,86,89,87,-1,59,86,57,-1,59,84,86,-1,90,91,92,-1,92,93,90,-1,94,27,35,-1,94,95,27,-1,36,93,92,-1,36,96,97,-1,36,98,99,-1,36,94,35,-1,100,101,102,-1,102,103,100,-1,104,101,40,-1,101,105,40,-1,106,107,21,-1,106,108,107,-1,105,100,109,-1,105,101,100,-1,54,110,111,-1,54,112,110,-1,62,113,63,-1,62,114,113,-1,24,115,22,-1,115,116,117,-1,117,22,115,-1,13,4,3,-1,118,119,120,-1,121,64,122,-1,64,67,122,-1,123,38,124,-1,38,121,124,-1,123,76,78,-1,123,124,76,-1,124,121,122,-1,125,111,119,-1,111,110,119,-1,25,126,127,-1,126,3,127,-1,23,13,128,-1,23,22,13,-1,105,109,129,-1,129,130,105,-1,131,132,133,-1,131,56,132,-1,107,134,135,-1,107,136,134,-1,40,130,39,-1,40,105,130,-1,103,131,100,-1,103,55,131,-1,36,99,94,-1,98,36,97,-1,96,36,92,-1,36,137,93,-1,138,139,98,-1,98,97,138,-1,35,28,34,-1,35,27,28,-1,57,88,140,-1,57,86,88,-1,55,87,49,-1,55,103,87,-1,141,51,52,-1,52,74,141,-1,72,70,58,-1,58,142,72,-1,143,144,47,-1,143,145,144,-1,131,133,100,-1,133,109,100,-1,146,147,118,-1,146,148,147,-1,149,42,69,-1,69,18,149,-1,54,111,56,-1,111,132,56,-1,50,150,52,-1,150,73,52,-1,42,44,69,-1,44,70,69,-1,151,152,20,-1,152,21,20,-1,38,123,40,-1,123,104,40,-1,39,106,37,-1,106,65,37,-1,26,153,154,-1,153,155,154,-1,96,30,29,-1,34,137,36,-1,156,30,91,-1,156,32,30,-1,1,157,158,-1,157,90,158,-1,31,32,62,-1,62,61,31,-1,115,24,61,-1,24,31,61,-1,153,20,19,-1,19,155,153,-1,22,117,159,-1,160,4,12,-1,160,14,4,-1,161,81,162,-1,15,163,16,-1,131,55,56,-1,137,164,158,-1,162,6,161,-1,7,6,162,-1,16,10,9,-1,10,16,163,-1,162,165,7,-1,165,162,166,-1,167,10,163,-1,168,10,167,-1,149,11,80,-1,9,11,149,-1,95,128,126,-1,128,95,169,-1,164,154,2,-1,154,164,33,-1,91,157,156,-1,157,91,90,-1,23,138,24,-1,23,139,138,-1,153,151,20,-1,153,127,151,-1,65,21,152,-1,65,106,21,-1,170,123,78,-1,123,170,104,-1,79,57,140,-1,57,79,60,-1,85,144,145,-1,85,171,144,-1,44,58,70,-1,44,59,58,-1,168,165,166,-1,168,167,165,-1,73,145,143,-1,150,145,73,-1,132,125,172,-1,111,125,132,-1,148,173,147,-1,174,173,148,-1,129,108,130,-1,129,175,108,-1,172,176,177,-1,172,173,176,-1,118,178,146,-1,178,118,120,-1,129,133,177,-1,133,129,109,-1,8,17,48,-1,15,17,8,-1,48,71,46,-1,48,17,71,-1,47,179,143,-1,47,46,179,-1,142,179,72,-1,75,179,142,-1,58,180,142,-1,58,60,180,-1,77,74,180,-1,77,141,74,-1,51,181,53,-1,51,141,181,-1,87,50,49,-1,87,89,50,-1,83,145,150,-1,83,85,145,-1,42,80,43,-1,149,80,42,-1,88,170,140,-1,88,102,170,-1,164,34,33,-1,164,137,34,-1,96,138,97,-1,96,29,138,-1,169,98,139,-1,98,169,99,-1,157,0,182,-1,157,1,0,-1,127,26,25,-1,153,26,127,-1,19,0,155,-1,19,135,0,-1,182,113,114,-1,182,134,113,-1,183,134,136,-1,183,113,134,-1,136,176,183,-1,136,175,176,-1,183,173,174,-1,183,176,173,-1,13,126,128,-1,13,3,126,-1,53,112,54,-1,53,181,112,-1,118,125,119,-1,147,125,118,-1,14,151,5,-1,152,151,14,-1,120,160,178,-1,160,120,68,-1};
			return value;
		}
		private int[] getlrib12_Geo_6_95_coordIndex_2()
		{
			int[] value = {152,66,65,-1,152,14,66,-1,122,112,124,-1,122,110,112,-1,181,124,112,-1,181,76,124,-1,110,67,119,-1,67,110,122,-1,38,64,121,-1,37,64,38,-1,68,14,160,-1,14,68,66,-1,68,119,67,-1,68,120,119,-1,159,160,12,-1,159,178,160,-1,146,116,148,-1,116,146,117,-1,127,5,151,-1,127,3,5,-1,159,13,22,-1,159,12,13,-1,62,156,114,-1,156,62,32,-1,174,113,183,-1,63,113,174,-1,177,132,172,-1,133,132,177,-1,107,175,136,-1,108,175,107,-1,0,134,182,-1,0,135,134,-1,135,21,107,-1,21,135,19,-1,104,102,101,-1,170,102,104,-1,2,155,0,-1,2,154,155,-1,157,114,156,-1,114,157,182,-1,94,169,95,-1,99,169,94,-1,96,91,30,-1,92,91,96,-1,93,158,90,-1,137,158,93,-1,41,59,44,-1,41,84,59,-1,87,102,88,-1,87,103,102,-1,83,86,84,-1,83,89,86,-1,82,43,80,-1,82,171,43,-1,171,184,144,-1,171,82,184,-1,89,150,50,-1,89,83,150,-1,76,141,77,-1,181,141,76,-1,60,77,180,-1,60,79,77,-1,75,180,74,-1,180,75,142,-1,143,75,73,-1,143,179,75,-1,46,72,179,-1,46,71,72,-1,71,18,69,-1,18,71,17,-1,82,161,184,-1,81,161,82,-1,117,178,159,-1,117,146,178,-1,175,177,176,-1,129,177,175,-1,108,39,130,-1,39,108,106,-1,6,48,45,-1,6,8,48,-1,63,148,116,-1,148,63,174,-1,147,172,125,-1,147,173,172,-1,53,49,51,-1,55,49,53,-1,161,45,184,-1,161,6,45,-1,116,61,63,-1,116,115,61,-1,47,184,45,-1,184,47,144,-1,41,171,85,-1,41,43,171,-1,140,78,79,-1,140,170,78,-1,128,139,23,-1,128,169,139,-1,24,29,31,-1,24,138,29,-1,33,26,154,-1,33,28,26,-1,126,27,95,-1,126,25,27,-1,18,9,149,-1,16,9,18,-1,7,167,163,-1,167,7,165,-1,168,162,10,-1,166,162,168,-1,11,162,81,-1,162,11,10,-1,7,15,8,-1,163,15,7,-1,158,2,1,-1,2,158,164,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlrib12_Coord_7_95_point_1()
		{
			double[] value = {.92602,42.11453,-2.43541,.78159,42.11839,-2.22976,.77217,42.06205,-2.21803,.76799,41.9602,-2.71152,.83135,42.00225,-2.79373,.90162,41.97626,-2.74403,3.37091,40.2337,-1.03356,3.35155,40.20802,-1.01976,3.36338,40.22083,-1.03416,3.23192,40.13509,-.98534,3.24916,40.13806,-.98576,3.24566,40.15331,-.98731,.82627,42.03835,-2.86811,.74117,42.10427,-2.77598,1.18602,41.93753,-2.83356,3.24798,40.12143,-1.01104,3.2419,40.12141,-1.00771,3.24367,40.12891,-1.03987,3.22417,40.13488,-1.02709,1.03231,42.0092,-2.60807,1.01929,41.97257,-2.60858,1.22359,41.95031,-2.6781,.77119,42.26707,-2.82998,.72736,42.24894,-2.79386,.70807,42.35731,-2.75863,.70835,41.88285,-2.53391,.72177,41.89695,-2.35534,.68145,41.90279,-2.52537,.68856,41.9101,-2.35886,.69244,42.35754,-2.65477,.69756,42.37344,-2.58117,.72007,42.38925,-2.69494,.74087,42.40111,-2.62871,.71207,41.94406,-2.29085,.69245,41.97843,-2.37624,.69681,41.9706,-2.50581,.72321,42.10295,-2.45114,1.55168,41.77141,-2.86173,1.8038,41.62075,-2.82999,1.54998,41.79711,-2.80974,1.81319,41.64692,-2.79174,3.22223,40.36341,-1.22636,3.19481,40.18159,-1.0575,3.24978,40.2549,-1.06431,3.15939,40.25685,-1.2324,3.38304,40.28066,-1.067,3.36232,40.2935,-1.13632,3.38982,40.33785,-1.1381,3.36687,40.24406,-1.07035,3.1235,41.02187,-2.13575,3.22975,40.84827,-1.88644,3.13177,41.01566,-2.16989,3.24204,40.82463,-1.90735,2.90993,41.22914,-2.41531,2.52634,41.50273,-2.73309,2.90254,41.2335,-2.39085,2.5154,41.51473,-2.71186,2.99494,40.61581,-1.85962,3.11375,40.41088,-1.57637,3.10213,40.42034,-1.5449,3.00468,40.5997,-1.88614,.79704,42.35586,-2.78444,.83176,42.38353,-2.74375,.99006,42.28853,-2.87788,1.56275,41.79083,-2.93538,1.35114,41.87898,-2.81347,1.33737,41.88209,-2.88485,1.5614,41.81094,-2.99335,1.33173,41.89863,-2.97399,3.20264,40.15954,-1.05634,3.1681,40.24495,-1.25659,3.23277,40.15659,-1.10251,3.21666,40.23253,-1.26808,3.33176,40.63703,-1.60851,3.22227,40.79549,-1.94172,3.30743,40.57921,-1.59929,2.74959,41.00338,-2.42814,2.97524,40.787,-2.15186,2.69441,40.9727,-2.37116,2.9012,40.73473,-2.08818,3.25391,40.20399,-1.01064,3.34277,40.23259,-1.00541,3.33691,40.26208,-1.02939,3.24495,40.60569,-1.56034,3.17252,40.52192,-1.53738,3.30206,40.42743,-1.24666,3.08882,40.71302,-1.86044,3.05465,40.94765,-2.07709,2.97576,40.85378,-2.04568,3.1575,40.7914,-1.86118,.76156,42.2262,-2.35525,.69949,42.36034,-2.52603,.71683,42.27715,-2.48632,.74524,42.16785,-2.34522,.69743,42.0162,-2.61756,.69645,41.98063,-2.6819,.71252,42.28761,-2.56326,.70031,42.25559,-2.63704,.70497,42.19109,-2.65758,.69815,42.09707,-2.64225};
			return value;
		}
		private double[] getlrib12_Coord_7_95_point_2()
		{
			double[] value = {2.48342,41.45626,-2.60944,2.436,41.31847,-2.56684,2.7389,41.08137,-2.34185,2.83036,41.17847,-2.37649,2.40078,41.24267,-2.57509,1.8613,41.71842,-2.80355,1.36126,41.89722,-2.74368,1.26094,42.01297,-2.67724,1.39807,41.953,-2.72622,1.9151,41.79786,-2.84449,1.88153,41.757,-3.01053,1.88834,41.82649,-3.03712,2.49048,41.37026,-2.75194,1.04808,42.28161,-2.79004,.87477,42.36598,-2.67229,.78383,42.32741,-2.81642,.96464,42.25214,-2.92952,.95378,42.21781,-2.92713,1.38656,42.05835,-3.02536,1.56983,41.95556,-3.05984,1.35297,41.99625,-3.03011,1.8337,41.6376,-2.9183,1.85782,41.66684,-2.96288,2.40897,41.2243,-2.61338,2.45667,41.25041,-2.68402,1.549,42.00996,-3.06248,.72005,41.96081,-2.70927,.8272,41.91761,-2.55402,.70337,42.10855,-2.77935,1.60535,41.97721,-2.8703,1.59056,41.86383,-2.78653,2.50768,41.50545,-2.66599,1.88828,41.85119,-2.99553,1.94251,41.83839,-2.91132,1.06431,42.18555,-2.68662,1.06196,42.07341,-2.60616,1.28833,42.12308,-2.73637,.72356,42.07273,-2.31289,.68214,42.33055,-2.71005,.70321,42.23886,-2.74686,2.8904,40.74792,-2.06238,3.08551,40.93124,-2.19853,3.19151,40.43587,-1.59294,3.38534,40.45241,-1.29183,3.38164,40.34712,-1.11765,3.37107,40.4694,-1.27762,1.17682,42.15358,-2.97462,1.38107,42.10497,-3.03327,1.18695,42.18138,-2.98925,3.21269,40.14933,-1.00477,3.31421,40.65711,-1.58987,.9862,41.94832,-2.65852,1.19711,41.92809,-2.7656,.84136,41.93817,-2.47682,.74658,41.93867,-2.27561,.87197,41.99442,-2.41942,.74468,42.39792,-2.56132,.79604,42.24026,-2.36123,.74565,42.11216,-2.2474,.88167,42.14247,-2.92408,1.13711,41.96349,-2.9256,3.36385,40.24894,-1.01695,3.34475,40.2206,-1.00549,3.25704,40.1267,-1.00491,.73632,42.05952,-2.23836,3.33137,40.20563,-1.02713,3.32753,40.21275,-1.01905,3.2696,40.15075,-1.01867,3.2644,40.15825,-1.00602,.68714,42.10876,-2.74193,2.68222,40.99471,-2.343,3.32403,40.30649,-1.08199,1.53464,42.06414,-3.00663,1.3752,42.1408,-2.98895,1.19118,42.2217,-2.9409,1.43147,42.06455,-2.8017,1.41859,42.13174,-2.90153,1.5944,42.04101,-2.94359,1.14712,42.06581,-2.9796,3.35394,40.39449,-1.29438,3.09135,40.64187,-1.90829,2.84771,41.11786,-2.47024,.92076,42.26323,-2.53822,1.26395,42.20195,-2.83498,3.37649,40.29653,-1.05665};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlscapula_Geo_6_100_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,10,12,11,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,28,33,-1,34,35,33,-1,32,35,36,-1,32,33,35,-1,37,38,39,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,46,49,47,-1,50,51,52,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,60,61,62,-1,63,64,65,-1,66,67,68,-1,66,69,67,-1,70,71,72,-1,70,73,71,-1,74,75,76,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,84,86,85,-1,87,88,66,-1,87,89,88,-1,0,90,91,-1,92,69,66,-1,66,88,92,-1,93,94,95,-1,95,65,93,-1,96,97,60,-1,98,99,100,-1,98,101,99,-1,102,103,104,-1,105,106,107,-1,107,108,105,-1,109,110,111,-1,111,112,109,-1,113,114,115,-1,113,116,114,-1,117,118,119,-1,118,120,119,-1,121,122,123,-1,121,124,122,-1,125,126,127,-1,125,128,126,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,135,136,133,-1,137,138,139,-1,139,23,137,-1,140,141,142,-1,142,143,140,-1,144,118,145,-1,118,117,145,-1,146,147,148,-1,149,150,151,-1,152,153,154,-1,152,155,153,-1,123,122,156,-1,157,158,159,-1,160,161,162,-1,162,163,160,-1,161,164,162,-1,165,141,140,-1,166,167,168,-1,44,169,170,-1,171,172,173,-1,171,174,172,-1,175,176,177,-1,176,178,177,-1,179,180,181,-1,181,182,179,-1,183,179,184,-1,185,176,186,-1,185,187,176,-1,188,189,190,-1,189,191,190,-1,192,102,193,-1,192,194,102,-1,195,196,197,-1,195,198,196,-1,199,200,201,-1,201,202,199,-1,203,102,194,-1,203,103,102,-1,200,194,192,-1,204,205,127,-1,204,206,205,-1,207,208,202,-1,208,199,202,-1,209,210,211,-1,212,213,214,-1,212,215,213,-1,216,68,217,-1,216,66,68,-1,218,219,109,-1,219,220,109,-1,221,222,223,-1,221,224,222,-1,225,226,227,-1,90,228,229,-1,95,230,231,-1,231,232,95,-1,233,72,234,-1,72,235,234,-1,236,64,237,-1,238,121,239,-1,240,241,242,-1,243,244,245,-1,243,246,247,-1,243,248,246,-1,249,250,251,-1,249,252,250,-1,253,254,255,-1,253,256,254,-1,257,258,259,-1,259,260,257,-1,261,262,263,-1,264,265,266,-1,264,267,265,-1,268,269,270,-1,271,272,259,-1,259,273,271,-1,274,241,275,-1,274,276,241,-1,277,278,252,-1,252,279,277,-1,280,281,282,-1,280,283,281,-1,284,285,286,-1,287,288,289,-1,290,291,292,-1,293,294,295,-1,295,296,293,-1,297,298,299,-1,300,301,302,-1,300,303,301,-1,304,305,306,-1,307,308,309,-1,310,311,307,-1,311,308,307,-1,312,233,217,-1,217,68,312,-1,313,314,315,-1,315,316,313,-1,317,318,319,-1,320,321,147,-1,322,323,324,-1,323,325,324,-1,326,327,328,-1,328,329,326,-1,330,331,332,-1,331,333,332,-1,334,331,335,-1,334,333,331,-1,336,337,338,-1,339,340,341,-1,342,343,344,-1,342,345,343,-1,346,347,348,-1,346,337,347,-1,349,38,37,-1,349,36,38,-1,340,339,350,-1,351,352,353,-1,351,354,352,-1,355,356,357,-1,358,359,360,-1,361,362,363,-1,364,365,366,-1,367,368,369,-1,368,370,369,-1,371,302,301,-1,372,373,303,-1,372,374,373,-1,305,137,25,-1,137,23,25,-1,375,376,377,-1,378,379,297,-1,297,380,378,-1,381,382,152,-1,383,384,165,-1,165,385,383,-1,386,387,388,-1,389,371,301,-1,301,390,389,-1,391,392,393,-1,391,394,392,-1,395,396,397,-1,398,399,400,-1,401,402,403,-1,404,405,406,-1,404,407,405,-1,408,409,29,-1,410,411,412,-1,411,413,412,-1,215,212,414,-1,414,415,215,-1,416,417,418,-1,417,419,418,-1,420,419,417,-1,420,421,419,-1,144,422,423,-1,423,118,144,-1,2,424,425,-1,2,426,424,-1,72,233,312,-1,427,230,428,-1,427,231,230,-1,429,430,62,-1,62,61,429,-1,431,432,433,-1,431,434,432,-1,239,123,435,-1,239,121,123,-1,436,437,438,-1,438,439,436,-1,106,440,441,-1,49,442,443,-1,49,46,442,-1,444,270,445,-1,444,268,270,-1,136,158,446,-1,446,447,136,-1,53,448,54,-1,449,450,451,-1,393,452,453,-1,138,383,454,-1,138,384,383,-1,455,140,143,-1,143,456,455,-1,457,458,21,-1,457,459,458,-1,460,461,462,-1,463,282,464,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_2()
		{
			int[] value = {465,464,466,-1,467,468,469,-1,469,470,467,-1,471,469,472,-1,471,473,469,-1,451,474,475,-1,475,419,451,-1,476,477,478,-1,478,479,476,-1,480,481,474,-1,481,475,474,-1,482,483,484,-1,483,485,484,-1,486,487,320,-1,486,488,487,-1,380,489,476,-1,476,378,380,-1,490,392,394,-1,159,135,491,-1,135,388,491,-1,492,493,494,-1,494,495,492,-1,496,494,497,-1,496,495,494,-1,351,353,498,-1,499,305,25,-1,25,500,499,-1,501,502,503,-1,501,499,502,-1,397,377,504,-1,505,402,401,-1,398,505,506,-1,507,508,509,-1,509,510,507,-1,432,511,512,-1,513,512,514,-1,318,515,516,-1,517,438,515,-1,517,518,438,-1,315,519,316,-1,520,521,522,-1,520,314,521,-1,523,524,525,-1,526,168,527,-1,526,528,168,-1,529,530,128,-1,529,531,530,-1,169,44,406,-1,44,43,406,-1,40,42,405,-1,40,405,532,-1,532,533,40,-1,534,535,536,-1,537,533,538,-1,537,536,533,-1,539,540,541,-1,540,542,541,-1,341,543,339,-1,323,322,544,-1,545,546,323,-1,546,547,323,-1,548,549,538,-1,549,537,538,-1,550,551,552,-1,550,553,551,-1,554,555,556,-1,554,557,555,-1,558,559,560,-1,558,561,559,-1,562,520,522,-1,562,563,520,-1,564,545,549,-1,564,546,545,-1,562,565,566,-1,567,565,568,-1,568,569,567,-1,570,571,572,-1,326,360,359,-1,359,327,326,-1,327,334,328,-1,327,573,334,-1,574,575,335,-1,324,325,576,-1,577,578,579,-1,580,581,582,-1,580,361,581,-1,583,370,584,-1,370,585,584,-1,117,586,587,-1,587,145,117,-1,321,588,589,-1,590,591,592,-1,592,593,590,-1,418,594,416,-1,418,595,594,-1,596,593,592,-1,592,597,596,-1,420,417,389,-1,389,390,420,-1,598,586,599,-1,600,601,10,-1,10,13,600,-1,6,12,7,-1,6,602,12,-1,603,604,218,-1,223,605,606,-1,223,604,605,-1,607,112,608,-1,608,609,607,-1,610,611,612,-1,610,613,611,-1,614,615,616,-1,614,617,615,-1,618,619,620,-1,618,621,619,-1,622,623,624,-1,624,625,622,-1,626,624,623,-1,626,627,624,-1,628,629,630,-1,630,631,628,-1,632,633,634,-1,632,635,633,-1,628,636,637,-1,637,638,628,-1,639,626,629,-1,640,641,642,-1,640,643,641,-1,644,645,643,-1,643,646,644,-1,200,646,201,-1,200,647,646,-1,237,66,236,-1,237,87,66,-1,181,648,649,-1,181,650,648,-1,208,651,652,-1,208,653,651,-1,63,654,237,-1,237,64,63,-1,654,97,655,-1,654,63,97,-1,656,657,658,-1,658,659,656,-1,660,77,651,-1,661,662,663,-1,664,655,97,-1,665,666,667,-1,668,669,670,-1,670,671,668,-1,671,672,673,-1,673,674,671,-1,675,676,677,-1,678,440,679,-1,678,680,440,-1,174,435,681,-1,174,239,435,-1,682,214,683,-1,682,212,214,-1,684,685,686,-1,686,110,684,-1,113,687,688,-1,113,115,687,-1,114,116,689,-1,689,690,114,-1,691,257,692,-1,691,247,257,-1,272,260,259,-1,272,693,260,-1,271,694,695,-1,271,273,694,-1,696,697,698,-1,696,699,697,-1,700,697,701,-1,701,702,700,-1,703,704,700,-1,700,705,703,-1,703,706,707,-1,707,708,703,-1,625,709,622,-1,625,710,709,-1,711,710,625,-1,711,712,710,-1,644,711,645,-1,644,713,711,-1,224,221,714,-1,221,715,714,-1,224,714,716,-1,716,717,224,-1,718,689,219,-1,219,719,718,-1,720,721,722,-1,722,448,720,-1,723,724,725,-1,725,449,723,-1,452,725,724,-1,721,726,727,-1,383,728,454,-1,728,729,454,-1,730,731,732,-1,730,733,731,-1,734,729,735,-1,734,454,729,-1,22,736,737,-1,17,16,447,-1,447,446,17,-1,738,739,740,-1,741,737,740,-1,694,742,743,-1,694,744,742,-1,745,746,747,-1,746,748,747,-1,292,749,750,-1,750,290,292,-1,751,752,753,-1,751,754,752,-1,755,753,752,-1,755,756,753,-1,754,757,758,-1,758,752,754,-1,759,760,761,-1,762,461,465,-1,762,462,461,-1,762,763,462,-1,764,765,766,-1,767,768,769,-1,769,770,767,-1,771,462,772,-1,773,764,766,-1,773,774,764,-1,773,74,775,-1,776,773,775,-1,776,774,773,-1,777,74,76,-1,776,778,779,-1,776,775,778,-1,250,780,781,-1,782,778,777,-1,777,783,782,-1,8,279,249,-1,279,252,249,-1,242,241,276,-1,276,784,242,-1,100,785,98,-1,100,253,785,-1,786,787,788,-1,788,789,786,-1,790,48,791,-1,790,46,48,-1,442,46,790,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_3()
		{
			int[] value = {792,793,192,-1,792,794,793,-1,795,796,797,-1,795,761,796,-1,798,799,797,-1,797,800,798,-1,786,644,787,-1,786,713,644,-1,789,98,785,-1,785,786,789,-1,99,101,801,-1,801,802,99,-1,802,749,803,-1,802,750,749,-1,804,240,805,-1,805,806,804,-1,276,807,784,-1,276,808,807,-1,809,810,811,-1,809,812,810,-1,813,692,814,-1,813,691,692,-1,815,777,76,-1,815,783,777,-1,775,74,777,-1,777,778,775,-1,74,816,75,-1,817,774,776,-1,817,818,774,-1,819,820,781,-1,781,821,819,-1,462,771,822,-1,771,821,822,-1,74,773,766,-1,766,816,74,-1,818,768,764,-1,764,774,818,-1,769,823,771,-1,772,769,771,-1,772,770,769,-1,763,772,462,-1,264,744,824,-1,824,267,264,-1,758,796,752,-1,796,755,752,-1,760,756,755,-1,825,826,827,-1,828,827,829,-1,286,830,284,-1,286,275,830,-1,828,829,716,-1,829,717,716,-1,286,285,831,-1,831,832,286,-1,743,695,694,-1,743,833,695,-1,280,834,742,-1,742,283,280,-1,835,740,836,-1,835,741,740,-1,741,20,22,-1,22,737,741,-1,739,836,740,-1,739,837,836,-1,739,838,839,-1,739,840,838,-1,840,738,16,-1,16,18,840,-1,841,842,839,-1,839,843,841,-1,844,732,731,-1,844,841,732,-1,843,845,846,-1,155,726,847,-1,155,727,726,-1,449,725,450,-1,720,718,721,-1,718,848,721,-1,719,222,718,-1,222,848,718,-1,849,850,714,-1,714,715,849,-1,645,625,624,-1,645,711,625,-1,709,707,706,-1,709,710,707,-1,700,702,851,-1,851,705,700,-1,697,700,704,-1,852,853,854,-1,854,855,852,-1,696,698,854,-1,854,856,696,-1,701,715,702,-1,715,221,702,-1,272,271,699,-1,699,696,272,-1,857,695,849,-1,824,744,694,-1,694,273,824,-1,257,858,692,-1,257,260,858,-1,685,113,688,-1,685,684,113,-1,115,859,687,-1,115,120,859,-1,111,686,412,-1,111,110,686,-1,860,688,687,-1,686,861,410,-1,410,412,686,-1,682,414,212,-1,862,673,863,-1,864,681,678,-1,678,865,864,-1,668,674,676,-1,668,671,674,-1,863,673,672,-1,672,866,863,-1,431,663,662,-1,431,867,663,-1,868,865,190,-1,869,666,660,-1,655,664,870,-1,78,660,871,-1,78,77,660,-1,870,872,655,-1,872,654,655,-1,232,61,60,-1,232,231,61,-1,237,872,87,-1,237,654,872,-1,659,873,182,-1,637,650,638,-1,637,648,650,-1,646,647,644,-1,627,642,641,-1,627,874,642,-1,641,643,645,-1,645,624,641,-1,617,709,615,-1,617,622,709,-1,875,876,615,-1,615,877,875,-1,615,876,616,-1,878,879,880,-1,878,881,879,-1,881,878,882,-1,882,883,881,-1,883,606,605,-1,883,882,606,-1,607,884,885,-1,607,609,884,-1,886,887,603,-1,606,702,223,-1,702,221,223,-1,607,109,112,-1,607,218,109,-1,607,886,218,-1,886,603,218,-1,7,12,601,-1,12,10,601,-1,598,599,420,-1,888,593,596,-1,888,594,593,-1,55,599,586,-1,55,56,599,-1,148,889,890,-1,148,589,889,-1,891,588,321,-1,891,371,588,-1,367,301,892,-1,300,893,894,-1,145,587,578,-1,587,579,578,-1,577,895,896,-1,577,897,895,-1,898,899,900,-1,898,901,899,-1,359,573,327,-1,359,902,573,-1,358,903,359,-1,904,571,905,-1,572,900,906,-1,572,898,900,-1,907,908,570,-1,908,909,570,-1,566,330,563,-1,563,562,566,-1,553,910,548,-1,167,554,556,-1,167,166,554,-1,550,552,555,-1,555,557,550,-1,549,911,537,-1,549,545,911,-1,325,323,547,-1,366,912,543,-1,343,913,344,-1,914,510,539,-1,915,543,341,-1,343,914,916,-1,917,918,916,-1,918,919,916,-1,920,918,911,-1,918,921,911,-1,347,922,348,-1,347,534,922,-1,923,535,924,-1,923,40,535,-1,405,42,406,-1,925,534,347,-1,336,926,924,-1,924,925,336,-1,338,45,927,-1,338,130,45,-1,170,926,927,-1,927,44,170,-1,928,128,530,-1,928,126,128,-1,929,930,931,-1,930,932,931,-1,930,933,934,-1,935,936,937,-1,937,156,935,-1,938,166,168,-1,168,528,938,-1,524,939,525,-1,939,938,525,-1,940,941,942,-1,940,523,941,-1,943,944,308,-1,945,939,524,-1,943,124,944,-1,943,122,124,-1,946,947,948,-1,948,949,946,-1,209,429,210,-1,209,430,429,-1,432,434,511,-1,512,513,432,-1,513,415,432,-1,507,31,508,-1,507,950,31,-1,510,345,357,-1,357,507,510,-1,352,355,342,-1,400,399,395,-1,399,951,395,-1,504,503,505,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_4()
		{
			int[] value = {304,137,305,-1,304,952,137,-1,500,502,499,-1,500,953,502,-1,954,366,365,-1,954,353,366,-1,496,953,500,-1,496,497,953,-1,497,494,409,-1,388,387,30,-1,30,491,388,-1,393,453,955,-1,955,391,393,-1,394,893,490,-1,893,956,490,-1,487,957,891,-1,957,958,891,-1,487,488,957,-1,484,959,482,-1,483,474,485,-1,483,480,474,-1,960,961,489,-1,962,590,595,-1,962,591,590,-1,595,477,962,-1,963,471,472,-1,472,964,963,-1,468,472,469,-1,468,965,472,-1,966,467,470,-1,470,967,966,-1,968,969,970,-1,969,971,970,-1,972,2,425,-1,972,0,2,-1,9,461,14,-1,9,465,461,-1,464,11,602,-1,15,14,973,-1,14,460,973,-1,14,461,460,-1,21,458,19,-1,381,397,396,-1,138,734,139,-1,138,454,734,-1,974,54,448,-1,448,723,974,-1,55,119,114,-1,114,690,55,-1,791,48,457,-1,975,440,680,-1,975,441,440,-1,439,518,238,-1,439,438,518,-1,433,432,415,-1,415,414,433,-1,231,427,429,-1,429,61,231,-1,55,586,117,-1,117,119,55,-1,890,889,976,-1,977,413,411,-1,423,294,293,-1,293,859,423,-1,45,44,927,-1,978,979,980,-1,979,368,980,-1,369,301,367,-1,369,390,301,-1,598,390,369,-1,598,420,390,-1,488,480,957,-1,488,481,480,-1,306,501,376,-1,501,377,376,-1,981,268,444,-1,982,983,984,-1,984,951,982,-1,301,303,892,-1,368,585,370,-1,368,979,585,-1,402,505,503,-1,503,502,402,-1,581,363,978,-1,581,361,363,-1,912,339,543,-1,339,912,985,-1,954,498,353,-1,918,917,986,-1,985,350,339,-1,325,982,576,-1,325,547,982,-1,570,572,906,-1,166,938,558,-1,487,321,320,-1,487,891,321,-1,987,313,316,-1,316,988,987,-1,315,314,559,-1,314,520,559,-1,930,934,932,-1,934,989,932,-1,526,307,941,-1,939,519,561,-1,142,990,991,-1,362,575,899,-1,379,146,297,-1,146,298,297,-1,897,992,895,-1,992,901,895,-1,993,992,979,-1,992,585,979,-1,909,905,571,-1,571,570,909,-1,994,285,284,-1,284,995,994,-1,996,826,825,-1,996,997,826,-1,998,285,994,-1,998,831,285,-1,833,999,746,-1,833,743,999,-1,832,282,463,-1,832,280,282,-1,464,465,11,-1,465,9,11,-1,824,259,258,-1,824,273,259,-1,824,258,246,-1,246,267,824,-1,261,266,265,-1,265,262,261,-1,281,266,261,-1,257,246,258,-1,257,247,246,-1,256,852,254,-1,256,1000,852,-1,75,245,1001,-1,245,244,1001,-1,248,243,245,-1,808,602,6,-1,808,1002,602,-1,739,738,840,-1,171,238,239,-1,239,174,171,-1,683,1003,682,-1,217,234,93,-1,217,233,234,-1,72,1004,235,-1,72,226,1004,-1,425,1005,972,-1,425,884,1005,-1,93,216,217,-1,93,65,216,-1,426,2,1,-1,1,1006,426,-1,726,721,848,-1,848,717,726,-1,717,848,222,-1,222,224,717,-1,219,689,220,-1,689,116,220,-1,851,702,606,-1,215,4,213,-1,215,5,4,-1,869,1007,1008,-1,192,647,200,-1,192,793,647,-1,202,201,640,-1,640,1009,202,-1,192,193,792,-1,198,759,196,-1,198,1010,759,-1,1011,188,190,-1,190,865,1011,-1,189,186,191,-1,189,185,186,-1,1009,207,202,-1,1009,187,207,-1,183,191,186,-1,650,175,177,-1,641,624,627,-1,874,639,177,-1,676,675,668,-1,40,923,41,-1,311,989,935,-1,397,504,395,-1,504,400,395,-1,23,981,24,-1,23,139,981,-1,24,444,495,-1,24,981,444,-1,130,129,204,-1,204,45,130,-1,121,1012,124,-1,382,1013,727,-1,591,962,961,-1,114,120,115,-1,114,119,120,-1,991,143,142,-1,991,456,143,-1,136,159,158,-1,136,135,159,-1,127,45,204,-1,127,126,45,-1,382,727,152,-1,727,155,152,-1,960,591,961,-1,960,592,591,-1,116,684,220,-1,116,113,684,-1,1014,1015,1016,-1,1016,1017,1014,-1,1018,1019,78,-1,1019,79,78,-1,1020,810,81,-1,810,82,81,-1,76,75,1001,-1,101,789,798,-1,101,98,789,-1,805,1021,806,-1,805,1022,1021,-1,1023,1024,870,-1,1025,613,426,-1,1004,1006,568,-1,968,1016,905,-1,235,1026,234,-1,235,1027,1026,-1,1004,568,1027,-1,1027,235,1004,-1,969,908,229,-1,969,909,908,-1,86,1028,1029,-1,1029,85,86,-1,1030,1031,84,-1,84,83,1030,-1,1032,1033,134,-1,1033,386,134,-1,811,810,1020,-1,442,1019,1018,-1,970,971,1005,-1,230,95,94,-1,72,312,70,-1,236,216,65,-1,65,64,236,-1,66,216,236,-1,431,662,62,-1,579,897,577,-1,579,584,897,-1,598,583,587,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_5()
		{
			int[] value = {587,586,598,-1,690,53,55,-1,48,459,457,-1,48,47,459,-1,27,26,1033,-1,1033,1032,27,-1,42,169,406,-1,42,41,169,-1,1034,1035,34,-1,1035,39,34,-1,39,1035,37,-1,1036,31,30,-1,1036,508,31,-1,35,38,36,-1,1034,34,33,-1,387,1036,30,-1,796,761,760,-1,760,755,796,-1,790,198,195,-1,195,104,790,-1,496,24,495,-1,21,20,457,-1,735,1037,269,-1,729,846,735,-1,885,886,607,-1,13,10,9,-1,9,14,13,-1,602,11,12,-1,516,4,3,-1,57,1038,862,-1,57,1039,1038,-1,862,863,57,-1,866,57,863,-1,866,58,57,-1,1040,1038,173,-1,862,1038,1040,-1,675,172,864,-1,677,172,675,-1,279,600,277,-1,279,601,600,-1,1041,1042,1043,-1,52,1042,1041,-1,1041,1044,1045,-1,1046,1044,1041,-1,269,1047,1048,-1,1047,269,1037,-1,1010,790,791,-1,1010,198,790,-1,32,542,1049,-1,32,36,542,-1,540,1050,1051,-1,540,509,1050,-1,39,35,34,-1,39,38,35,-1,859,860,687,-1,859,293,860,-1,1041,50,52,-1,1045,50,1041,-1,1045,1052,50,-1,1045,1053,1052,-1,587,584,579,-1,587,583,584,-1,312,67,70,-1,68,67,312,-1,1028,1030,1029,-1,1028,1031,1030,-1,1028,84,1031,-1,1028,86,84,-1,972,90,0,-1,90,972,228,-1,905,969,968,-1,909,969,905,-1,90,908,91,-1,229,908,90,-1,1006,569,568,-1,1,569,1006,-1,93,1026,94,-1,234,1026,93,-1,610,426,613,-1,426,610,424,-1,225,621,1054,-1,227,621,225,-1,1055,71,73,-1,1055,619,71,-1,1024,1056,1057,-1,1056,1024,1023,-1,60,63,232,-1,60,97,63,-1,664,96,1058,-1,664,97,96,-1,886,424,610,-1,885,424,886,-1,1057,59,58,-1,1057,1056,59,-1,1059,813,814,-1,1059,815,813,-1,812,82,810,-1,82,812,1060,-1,195,102,104,-1,102,195,193,-1,1061,792,197,-1,792,1061,794,-1,1020,1022,805,-1,1022,1020,81,-1,1062,806,1021,-1,1062,1063,806,-1,798,788,799,-1,788,798,789,-1,665,205,206,-1,665,667,205,-1,871,206,1064,-1,665,206,871,-1,1065,1017,1016,-1,1017,1065,1066,-1,1015,473,896,-1,473,1015,1014,-1,577,963,578,-1,963,577,471,-1,109,684,110,-1,220,684,109,-1,299,890,976,-1,298,890,299,-1,592,1067,597,-1,1067,592,960,-1,1013,149,151,-1,149,1013,382,-1,455,154,385,-1,152,154,455,-1,529,975,937,-1,975,529,441,-1,443,1034,49,-1,443,1068,1034,-1,27,459,28,-1,459,27,458,-1,492,157,159,-1,157,492,445,-1,456,163,162,-1,163,456,991,-1,33,49,1034,-1,47,49,33,-1,527,167,931,-1,168,167,527,-1,311,932,989,-1,310,932,311,-1,665,660,666,-1,665,871,660,-1,105,1011,679,-1,105,1069,1011,-1,105,108,1069,-1,667,1069,108,-1,666,1069,667,-1,669,675,868,-1,675,669,668,-1,679,865,678,-1,679,1011,865,-1,178,874,177,-1,642,874,178,-1,874,626,639,-1,874,627,626,-1,652,199,208,-1,203,199,652,-1,1070,760,1071,-1,1070,756,760,-1,1072,869,653,-1,869,1072,1007,-1,1073,632,634,-1,1073,1074,632,-1,882,851,606,-1,875,851,882,-1,1004,225,1025,-1,1004,226,225,-1,184,1075,1076,-1,184,873,1075,-1,238,1012,121,-1,238,518,1012,-1,6,1077,808,-1,1077,6,1078,-1,602,463,464,-1,602,1002,463,-1,1079,82,1080,-1,80,82,1079,-1,1000,853,852,-1,1000,1081,853,-1,246,1082,267,-1,248,1082,246,-1,1082,245,75,-1,1082,248,245,-1,16,740,737,-1,740,16,738,-1,733,1083,1084,-1,730,1083,733,-1,743,834,999,-1,743,742,834,-1,828,825,827,-1,828,747,825,-1,1085,826,997,-1,1085,1086,826,-1,747,996,825,-1,748,996,747,-1,1087,995,284,-1,1088,995,1087,-1,1046,1089,1090,-1,1091,1089,1046,-1,572,904,898,-1,572,571,904,-1,992,899,901,-1,899,992,993,-1,496,25,24,-1,500,25,496,-1,398,504,505,-1,504,398,400,-1,1092,375,990,-1,1092,376,375,-1,316,939,945,-1,316,519,939,-1,528,941,523,-1,526,941,528,-1,940,524,523,-1,940,945,524,-1,512,948,514,-1,512,949,948,-1,147,379,320,-1,147,146,379,-1,1093,560,559,-1,560,1093,1094,-1,549,910,564,-1,549,548,910,-1,166,560,554,-1,558,560,166,-1,1095,1096,1097,-1,1095,1098,1096,-1,1099,211,988,-1,1099,946,211,-1,352,985,353,-1,352,350,985,-1,403,954,401,-1,403,498,954,-1,926,338,927,-1,338,926,336,-1,541,917,916,-1,349,917,541,-1,900,1100,906,-1,574,1100,900,-1,306,499,501,-1,305,499,306,-1,991,375,163,-1,375,991,990,-1,486,481,488,-1,486,479,481,-1,381,955,453,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_6()
		{
			int[] value = {396,955,381,-1,162,381,152,-1,162,164,381,-1,596,976,889,-1,596,597,976,-1,1101,589,588,-1,888,589,1101,-1,979,363,993,-1,363,979,978,-1,408,356,354,-1,356,408,950,-1,544,920,323,-1,1102,920,544,-1,1103,531,933,-1,1103,530,531,-1,688,1104,685,-1,688,860,1104,-1,422,294,423,-1,1089,294,422,-1,1090,422,964,-1,1090,1089,422,-1,1053,468,467,-1,1045,468,1053,-1,411,967,977,-1,967,411,966,-1,1017,977,967,-1,977,1017,1066,-1,970,1016,968,-1,970,1065,1016,-1,884,424,885,-1,884,425,424,-1,123,680,435,-1,123,975,680,-1,125,106,441,-1,125,107,106,-1,204,1064,206,-1,204,129,1064,-1,445,1105,157,-1,445,270,1105,-1,133,22,19,-1,133,736,22,-1,958,300,302,-1,958,893,300,-1,725,485,450,-1,484,485,725,-1,452,149,453,-1,452,150,149,-1,849,701,857,-1,849,715,701,-1,969,228,971,-1,969,229,228,-1,1052,411,50,-1,411,1052,966,-1,1044,1090,965,-1,1046,1090,1044,-1,963,422,144,-1,963,964,422,-1,419,974,451,-1,419,421,974,-1,477,418,478,-1,418,477,595,-1,489,477,476,-1,489,962,477,-1,961,962,489,-1,490,959,392,-1,482,959,490,-1,483,957,480,-1,483,956,957,-1,893,957,956,-1,893,958,957,-1,391,372,894,-1,955,372,391,-1,493,30,29,-1,493,491,30,-1,29,494,493,-1,409,494,29,-1,403,497,409,-1,403,953,497,-1,953,402,502,-1,953,403,402,-1,990,141,1092,-1,990,142,141,-1,396,951,984,-1,396,395,951,-1,353,912,366,-1,985,912,353,-1,355,345,342,-1,345,355,357,-1,357,950,507,-1,357,356,950,-1,386,1051,1050,-1,1033,1051,386,-1,349,542,36,-1,349,541,542,-1,5,415,513,-1,215,415,5,-1,5,319,3,-1,5,514,319,-1,514,5,513,-1,209,434,430,-1,209,511,434,-1,949,211,946,-1,949,209,211,-1,516,319,318,-1,516,3,319,-1,1106,948,947,-1,1106,317,948,-1,988,210,987,-1,988,211,210,-1,313,427,428,-1,987,427,313,-1,1107,1108,1109,-1,1107,1106,1108,-1,124,517,944,-1,1012,517,124,-1,1012,518,517,-1,1109,942,309,-1,942,1109,1108,-1,946,1110,947,-1,946,1099,1110,-1,521,230,94,-1,230,521,428,-1,309,941,307,-1,942,941,309,-1,523,938,528,-1,525,938,523,-1,559,519,315,-1,559,561,519,-1,943,311,935,-1,311,943,308,-1,531,937,936,-1,531,529,937,-1,989,936,935,-1,989,934,936,-1,929,167,556,-1,929,931,167,-1,930,1111,1112,-1,930,929,1111,-1,407,1103,1112,-1,407,404,1103,-1,552,1111,555,-1,552,1113,1111,-1,532,407,1113,-1,407,532,405,-1,126,43,45,-1,126,928,43,-1,336,347,337,-1,925,347,336,-1,925,535,534,-1,535,925,924,-1,923,926,170,-1,923,924,926,-1,921,534,536,-1,534,921,922,-1,1035,1068,346,-1,1034,1068,1035,-1,922,918,986,-1,921,918,922,-1,915,919,1102,-1,915,913,919,-1,919,343,916,-1,343,919,913,-1,539,509,540,-1,539,510,509,-1,343,510,914,-1,345,510,343,-1,951,576,982,-1,951,399,576,-1,323,911,545,-1,323,920,911,-1,902,910,553,-1,910,902,359,-1,557,1097,550,-1,1095,1097,557,-1,560,1114,554,-1,560,1094,1114,-1,1097,573,902,-1,1097,1096,573,-1,330,1115,331,-1,1115,330,566,-1,1116,569,91,-1,1116,567,569,-1,91,907,1116,-1,908,907,91,-1,907,906,1100,-1,906,907,570,-1,1117,574,335,-1,574,1117,1100,-1,905,1015,904,-1,905,1016,1015,-1,895,898,904,-1,898,895,901,-1,85,1118,903,-1,1029,1118,85,-1,360,83,358,-1,83,360,1030,-1,564,1118,546,-1,564,903,1118,-1,580,326,329,-1,580,983,326,-1,899,363,362,-1,899,993,363,-1,984,374,396,-1,374,984,582,-1,980,303,373,-1,892,303,980,-1,894,303,300,-1,894,372,303,-1,891,302,371,-1,958,302,891,-1,589,147,321,-1,589,148,147,-1,416,888,1101,-1,416,594,888,-1,1119,973,460,-1,973,1119,278,-1,887,604,603,-1,604,887,605,-1,705,875,877,-1,705,851,875,-1,605,612,883,-1,612,605,887,-1,883,611,881,-1,883,612,611,-1,1120,881,611,-1,881,1120,879,-1,616,878,880,-1,616,876,878,-1,878,875,882,-1,876,875,878,-1,706,615,709,-1,706,877,615,-1,1121,879,1122,-1,1121,880,879,-1,1123,1122,1124,-1,1123,1121,1122,-1,631,617,614,-1,617,631,630,-1,636,1124,635,-1,636,1123,1124,-1,1055,620,619,-1,1055,633,620,-1,639,650,177,-1,639,638,650,-1,1125,1074,1073,-1,1125,1126,1074,-1,176,180,186,-1,176,175,180,-1,180,183,186,-1,180,179,183,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_7()
		{
			int[] value = {656,649,1126,-1,656,659,649,-1,1125,1127,1128,-1,1127,1125,89,-1,1128,1024,1129,-1,1128,1127,1024,-1,179,873,184,-1,873,179,182,-1,189,1072,185,-1,189,1007,1072,-1,1023,661,1056,-1,1023,1058,661,-1,657,1130,1131,-1,657,1129,1130,-1,670,1075,658,-1,1075,670,669,-1,190,1076,868,-1,191,1076,190,-1,1069,188,1011,-1,1069,1008,188,-1,1131,866,672,-1,866,1131,1130,-1,1056,663,59,-1,1056,661,663,-1,59,867,57,-1,59,663,867,-1,674,862,1040,-1,862,674,673,-1,57,1003,1039,-1,1003,57,867,-1,1038,1132,1133,-1,1038,1039,1132,-1,1133,436,439,-1,436,1133,1132,-1,414,1003,433,-1,1003,414,682,-1,861,51,410,-1,51,861,52,-1,1043,1104,860,-1,1042,1104,1043,-1,1104,52,861,-1,52,1104,1042,-1,413,111,412,-1,1134,111,413,-1,118,859,120,-1,118,423,859,-1,833,849,695,-1,849,833,850,-1,699,695,857,-1,271,695,699,-1,856,272,696,-1,693,272,856,-1,857,697,699,-1,701,697,857,-1,1079,854,853,-1,1079,856,854,-1,698,855,854,-1,1135,855,698,-1,1135,703,708,-1,1135,704,703,-1,855,254,852,-1,855,1136,254,-1,1136,255,254,-1,1136,1137,255,-1,710,1137,707,-1,710,712,1137,-1,720,53,690,-1,720,448,53,-1,151,452,724,-1,151,150,452,-1,1013,721,727,-1,1013,722,721,-1,154,1083,728,-1,154,153,1083,-1,735,845,1037,-1,735,846,845,-1,841,846,732,-1,841,843,846,-1,841,1138,842,-1,841,844,1138,-1,845,839,838,-1,845,843,839,-1,270,1048,1105,-1,270,269,1048,-1,840,1047,838,-1,840,18,1047,-1,839,837,739,-1,837,839,842,-1,1139,837,1140,-1,837,1139,836,-1,836,1141,835,-1,1141,836,1139,-1,457,741,835,-1,20,741,457,-1,281,464,282,-1,281,466,464,-1,746,850,833,-1,746,745,850,-1,286,274,275,-1,832,274,286,-1,831,999,834,-1,998,999,831,-1,1087,830,1142,-1,1087,284,830,-1,748,994,996,-1,748,998,994,-1,827,847,829,-1,847,827,1084,-1,995,996,994,-1,995,997,996,-1,827,1086,1143,-1,827,826,1086,-1,1144,733,1143,-1,1144,731,733,-1,291,1085,1088,-1,291,287,1085,-1,288,1144,289,-1,1144,288,1145,-1,1146,844,1145,-1,1146,1138,844,-1,290,751,288,-1,754,751,290,-1,1138,1147,1140,-1,1138,1146,1147,-1,1071,1139,1070,-1,1139,1071,1141,-1,283,744,264,-1,283,742,744,-1,261,466,281,-1,466,261,1148,-1,263,1148,261,-1,263,1149,1148,-1,770,763,1149,-1,770,772,763,-1,1082,265,267,-1,1150,265,1082,-1,768,823,769,-1,818,823,768,-1,819,771,823,-1,771,819,821,-1,820,817,1151,-1,819,817,820,-1,781,822,821,-1,822,781,780,-1,251,781,820,-1,251,250,781,-1,1151,1152,1153,-1,1152,1151,779,-1,244,813,1001,-1,691,813,244,-1,1059,783,815,-1,783,1059,1154,-1,1152,1155,1077,-1,1152,782,1155,-1,1077,807,808,-1,1077,1155,807,-1,812,1154,1059,-1,812,809,1154,-1,1060,1080,82,-1,1060,858,1080,-1,807,811,784,-1,807,809,811,-1,276,1002,808,-1,276,274,1002,-1,81,1081,1022,-1,81,80,1081,-1,804,830,240,-1,804,1142,830,-1,1021,1081,1000,-1,1081,1021,1022,-1,1021,256,1062,-1,1021,1000,256,-1,1142,803,749,-1,1142,804,803,-1,99,803,1063,-1,99,802,803,-1,750,801,757,-1,750,802,801,-1,798,801,101,-1,798,800,801,-1,1156,786,785,-1,713,786,1156,-1,797,758,800,-1,758,797,796,-1,797,1061,795,-1,1061,797,799,-1,787,647,793,-1,647,787,644,-1,197,795,1061,-1,795,197,196,-1,790,1019,442,-1,790,104,1019,-1,196,761,795,-1,761,196,759,-1,794,787,793,-1,794,788,787,-1,757,800,758,-1,800,757,801,-1,1062,253,100,-1,1062,256,253,-1,1063,804,806,-1,804,1063,803,-1,255,785,253,-1,255,1156,785,-1,242,805,240,-1,242,1020,805,-1,1020,784,811,-1,1020,242,784,-1,240,275,241,-1,275,240,830,-1,858,814,692,-1,1060,814,858,-1,809,1155,1154,-1,809,807,1155,-1,8,1078,6,-1,1078,8,249,-1,1077,1153,1152,-1,1153,1077,1078,-1,1154,782,783,-1,782,1154,1155,-1,779,782,1152,-1,782,779,778,-1,251,1151,1153,-1,251,820,1151,-1,278,250,252,-1,278,780,250,-1,779,817,776,-1,817,779,1151,-1,823,817,819,-1,823,818,817,-1,764,767,765,-1,768,767,764,-1,1150,75,816,-1,1082,75,1150,-1,767,1149,263,-1,767,770,1149,-1,1148,763,762,-1,1148,1149,763,-1,243,691,244,-1,243,247,691,-1,762,466,1148,-1,762,465,466,-1,281,264,266,-1,281,283,264,-1,756,1147,753,-1,756,1070,1147,-1,1140,1070,1139,-1,1140,1147,1070,-1,753,1146,751,-1,1146,753,1147,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_8()
		{
			int[] value = {757,290,750,-1,757,754,290,-1,751,1145,288,-1,751,1146,1145,-1,1145,731,1144,-1,731,1145,844,-1,288,291,290,-1,287,291,288,-1,1143,289,1144,-1,289,1143,1086,-1,1084,1143,733,-1,1084,827,1143,-1,1088,997,995,-1,997,1088,1085,-1,1142,292,1087,-1,292,1142,749,-1,746,998,748,-1,746,999,998,-1,714,745,716,-1,714,850,745,-1,832,834,280,-1,832,831,834,-1,835,791,457,-1,835,1141,791,-1,1140,842,1138,-1,1140,837,842,-1,17,1105,1048,-1,17,446,1105,-1,737,447,16,-1,447,737,736,-1,838,1037,845,-1,1037,838,1047,-1,268,735,269,-1,735,268,734,-1,729,732,846,-1,729,730,732,-1,728,730,729,-1,1083,730,728,-1,728,385,154,-1,728,383,385,-1,151,722,1013,-1,151,724,722,-1,722,723,448,-1,723,722,724,-1,718,690,689,-1,720,690,718,-1,223,719,604,-1,223,222,719,-1,1156,711,713,-1,711,1156,712,-1,712,255,1137,-1,712,1156,255,-1,1136,707,1137,-1,1136,708,707,-1,703,877,706,-1,703,705,877,-1,1135,1136,855,-1,1135,708,1136,-1,704,698,697,-1,704,1135,698,-1,1080,856,1079,-1,1080,693,856,-1,1080,260,693,-1,260,1080,858,-1,604,219,218,-1,219,604,719,-1,1134,977,1066,-1,1134,413,977,-1,685,861,686,-1,685,1104,861,-1,683,1039,1003,-1,683,1132,1039,-1,214,1132,683,-1,214,436,1132,-1,439,171,1133,-1,439,238,171,-1,173,1133,171,-1,173,1038,1133,-1,433,867,431,-1,433,1003,867,-1,680,681,435,-1,680,678,681,-1,58,1130,1057,-1,1130,58,866,-1,672,670,1131,-1,672,671,670,-1,1008,189,188,-1,1008,1007,189,-1,1076,669,868,-1,1076,1075,669,-1,1131,658,657,-1,658,1131,670,-1,1057,1129,1024,-1,1129,1057,1130,-1,661,96,662,-1,96,661,1058,-1,660,653,869,-1,653,660,651,-1,183,1076,191,-1,183,184,1076,-1,873,658,1075,-1,873,659,658,-1,1129,656,1128,-1,656,1129,657,-1,1128,1126,1125,-1,1128,656,1126,-1,185,207,187,-1,185,1072,207,-1,176,1009,178,-1,176,187,1009,-1,181,175,650,-1,175,181,180,-1,1126,648,1074,-1,1126,649,648,-1,89,1073,88,-1,89,1125,1073,-1,642,1009,640,-1,178,1009,642,-1,646,640,201,-1,643,640,646,-1,638,629,628,-1,639,629,638,-1,635,637,636,-1,637,635,632,-1,633,92,634,-1,633,1055,92,-1,635,620,633,-1,635,1124,620,-1,628,1123,636,-1,1123,628,631,-1,629,623,630,-1,629,626,623,-1,622,630,623,-1,622,617,630,-1,614,1123,631,-1,614,1121,1123,-1,618,1124,1122,-1,618,620,1124,-1,618,879,1120,-1,618,1122,879,-1,616,1121,614,-1,1121,616,880,-1,1054,611,613,-1,1120,611,1054,-1,887,610,612,-1,887,886,610,-1,277,973,278,-1,277,15,973,-1,822,460,462,-1,822,1119,460,-1,417,1101,389,-1,417,416,1101,-1,595,593,594,-1,595,590,593,-1,892,368,367,-1,980,368,892,-1,582,373,374,-1,373,582,581,-1,582,983,580,-1,983,582,984,-1,584,992,897,-1,992,584,585,-1,361,329,362,-1,361,580,329,-1,982,1118,360,-1,547,1118,982,-1,1118,547,546,-1,575,334,335,-1,575,328,334,-1,360,983,982,-1,360,326,983,-1,903,910,359,-1,903,564,910,-1,1029,360,1118,-1,1030,360,1029,-1,358,85,903,-1,85,358,83,-1,896,904,1015,-1,895,904,896,-1,331,1117,335,-1,1117,331,1115,-1,1100,1116,907,-1,1100,1117,1116,-1,1117,567,1116,-1,1117,1115,567,-1,1115,565,567,-1,1115,566,565,-1,334,1096,333,-1,573,1096,334,-1,568,562,1027,-1,568,565,562,-1,554,1095,557,-1,1114,1095,554,-1,550,902,553,-1,1097,902,550,-1,522,1027,562,-1,1027,522,1026,-1,563,559,520,-1,563,1093,559,-1,551,548,538,-1,553,548,551,-1,364,1102,544,-1,364,915,1102,-1,324,506,322,-1,398,506,324,-1,366,915,364,-1,543,915,366,-1,341,913,915,-1,341,344,913,-1,346,131,337,-1,131,346,1068,-1,536,911,921,-1,536,537,911,-1,536,40,533,-1,536,535,40,-1,538,532,551,-1,538,533,532,-1,406,928,404,-1,43,928,406,-1,551,1113,552,-1,1113,551,532,-1,1112,1113,407,-1,1113,1112,1111,-1,1112,933,930,-1,933,1112,1103,-1,555,929,556,-1,929,555,1111,-1,527,307,526,-1,307,527,310,-1,521,1026,522,-1,521,94,1026,-1,428,314,313,-1,428,521,314,-1,1108,940,942,-1,940,1108,1110,-1,944,1107,1109,-1,517,1107,944,-1,1106,1110,1108,-1,1106,947,1110,-1,429,987,210,-1,427,987,429,-1,318,517,515,-1,318,1107,517,-1,437,515,438,-1,437,516,515,-1,514,317,319,-1,514,948,317,-1,949,511,209,-1,949,512,511,-1,4,437,213,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_9()
		{
			int[] value = {437,4,516,-1,1051,26,1049,-1,1051,1033,26,-1,28,1049,26,-1,1049,28,32,-1,1050,387,386,-1,1050,1036,387,-1,340,352,342,-1,340,350,352,-1,372,396,374,-1,372,955,396,-1,1157,505,401,-1,505,1157,506,-1,397,160,377,-1,397,161,160,-1,503,377,501,-1,503,504,377,-1,351,403,409,-1,498,403,351,-1,354,409,408,-1,351,409,354,-1,491,492,159,-1,492,491,493,-1,386,135,134,-1,135,386,388,-1,486,379,378,-1,486,320,379,-1,482,956,483,-1,482,490,956,-1,475,479,478,-1,481,479,475,-1,478,419,475,-1,478,418,419,-1,450,474,451,-1,450,485,474,-1,54,421,56,-1,54,974,421,-1,470,473,1014,-1,473,470,469,-1,1067,489,380,-1,1067,960,489,-1,164,397,381,-1,164,161,397,-1,452,392,959,-1,452,393,392,-1,959,725,452,-1,959,484,725,-1,723,451,974,-1,449,451,723,-1,133,447,736,-1,133,136,447,-1,446,157,1105,-1,446,158,157,-1,981,734,268,-1,981,139,734,-1,1018,443,442,-1,132,443,1018,-1,205,125,127,-1,205,107,125,-1,436,213,437,-1,214,213,436,-1,430,431,62,-1,430,434,431,-1,1120,621,618,-1,1054,621,1120,-1,71,226,72,-1,226,71,227,-1,970,884,609,-1,970,1005,884,-1,609,1065,970,-1,1065,609,608,-1,421,599,56,-1,599,421,420,-1,829,726,717,-1,726,829,847,-1,369,583,598,-1,583,369,370,-1,967,1014,1017,-1,967,470,1014,-1,410,50,411,-1,50,410,51,-1,1045,965,468,-1,1044,965,1045,-1,1052,467,966,-1,1053,467,1052,-1,950,29,31,-1,408,29,950,-1,936,933,531,-1,933,936,934,-1,530,404,928,-1,404,530,1103,-1,401,365,1157,-1,401,954,365,-1,1102,918,920,-1,919,918,1102,-1,914,541,916,-1,914,539,541,-1,324,399,398,-1,324,576,399,-1,382,453,149,-1,453,382,381,-1,389,588,371,-1,1101,588,389,-1,889,888,596,-1,889,589,888,-1,952,1092,141,-1,952,304,1092,-1,152,456,162,-1,152,455,456,-1,394,894,893,-1,394,391,894,-1,299,380,297,-1,380,299,1067,-1,479,378,476,-1,378,479,486,-1,163,377,160,-1,163,375,377,-1,581,980,373,-1,978,980,581,-1,574,899,575,-1,574,900,899,-1,354,355,352,-1,354,356,355,-1,986,348,922,-1,986,37,348,-1,37,346,348,-1,1035,346,37,-1,365,544,1157,-1,365,364,544,-1,37,917,349,-1,37,986,917,-1,340,344,341,-1,340,342,344,-1,130,337,131,-1,337,130,338,-1,988,945,1099,-1,316,945,988,-1,1093,330,332,-1,330,1093,563,-1,333,1098,332,-1,1096,1098,333,-1,1098,1114,1094,-1,1098,1095,1114,-1,1094,332,1098,-1,332,1094,1093,-1,362,328,575,-1,329,328,362,-1,318,1106,1107,-1,1106,318,317,-1,944,309,308,-1,309,944,1109,-1,156,943,935,-1,943,156,122,-1,940,1099,945,-1,940,1110,1099,-1,939,558,938,-1,558,939,561,-1,304,376,1092,-1,304,306,376,-1,322,1157,544,-1,1157,322,506,-1,1089,295,294,-1,295,1089,1091,-1,965,964,472,-1,965,1090,964,-1,292,1088,1087,-1,291,1088,292,-1,287,1086,1085,-1,287,289,1086,-1,716,747,828,-1,716,745,747,-1,1002,832,463,-1,1002,274,832,-1,1141,1010,791,-1,1071,1010,1141,-1,153,1084,1083,-1,1084,155,847,-1,153,155,1084,-1,263,765,767,-1,765,263,262,-1,1150,262,265,-1,1150,765,262,-1,765,816,766,-1,765,1150,816,-1,1079,1081,80,-1,1081,1079,853,-1,1153,249,251,-1,1078,249,1153,-1,1119,780,278,-1,1119,822,780,-1,132,1064,129,-1,1064,132,1018,-1,88,634,92,-1,88,1073,634,-1,1074,637,632,-1,1074,648,637,-1,207,653,208,-1,207,1072,653,-1,77,652,651,-1,652,77,79,-1,203,200,199,-1,203,194,200,-1,1071,759,1010,-1,1071,760,759,-1,79,203,652,-1,103,203,79,-1,659,181,649,-1,659,182,181,-1,172,681,864,-1,174,681,172,-1,868,864,865,-1,868,675,864,-1,106,679,440,-1,106,105,679,-1,666,1008,1069,-1,666,869,1008,-1,923,169,41,-1,170,169,923,-1,310,931,932,-1,527,931,310,-1,134,19,1032,-1,134,133,19,-1,165,952,141,-1,384,952,165,-1,384,137,952,-1,138,137,384,-1,495,445,492,-1,445,495,444,-1,458,1032,19,-1,458,27,1032,-1,28,47,33,-1,47,28,459,-1,132,1068,443,-1,132,131,1068,-1,128,441,529,-1,441,128,125,-1,156,975,123,-1,156,937,975,-1,165,455,385,-1,165,140,455,-1,299,597,1067,-1,299,976,597,-1,148,298,146,-1,148,890,298,-1,608,1066,1065,-1,608,1134,1066,-1,145,963,144,-1,145,578,963,-1,896,471,577,-1,471,896,473,-1};
			return value;
		}
		private int[] getlscapula_Geo_6_100_coordIndex_10()
		{
			int[] value = {112,1134,608,-1,112,111,1134,-1,78,1064,1018,-1,78,871,1064,-1,667,107,205,-1,108,107,667,-1,1063,100,99,-1,1063,1062,100,-1,794,799,788,-1,799,794,1061,-1,197,193,195,-1,197,792,193,-1,103,1019,104,-1,79,1019,103,-1,1059,1060,812,-1,1059,814,1060,-1,1001,815,76,-1,1001,813,815,-1,62,96,60,-1,96,62,662,-1,1127,870,1024,-1,872,870,1127,-1,1023,664,1058,-1,664,1023,870,-1,65,232,63,-1,232,65,95,-1,89,872,1127,-1,89,87,872,-1,73,92,1055,-1,69,92,73,-1,227,619,621,-1,71,619,227,-1,1025,1054,613,-1,225,1054,1025,-1,1,91,569,-1,0,91,1,-1,1006,1025,426,-1,1025,1006,1004,-1,971,972,1005,-1,971,228,972,-1,70,69,73,-1,67,69,70,-1,293,1043,860,-1,293,296,1043,-1,509,1036,1050,-1,508,1036,509,-1,1049,540,1051,-1,1049,542,540,-1,18,1048,1047,-1,1048,18,17,-1,1043,295,1091,-1,1043,296,295,-1,1091,1041,1043,-1,1091,1046,1041,-1,600,15,277,-1,600,13,15,-1,601,8,7,-1,601,279,8,-1,1040,676,674,-1,677,676,1040,-1,173,677,1040,-1,173,172,677,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlscapula_Coord_7_100_point_1()
		{
			double[] value = {5.58558,48.60585,-1.942,5.51829,48.5621,-2.02239,5.57435,48.65584,-2.04856,3.89604,47.14915,-3.51935,3.90249,47.07804,-3.5703,4.04954,47.1514,-3.43083,5.83766,50.00576,-1.41707,5.85963,49.97949,-1.23823,5.89614,49.98398,-1.23214,5.83927,49.929,-1.08113,5.83252,49.95229,-1.07623,5.82367,49.94635,-1.26886,5.83941,49.9684,-1.23931,5.89321,49.90431,-.85134,5.93307,49.87629,-.83844,5.92952,49.89319,-.82729,3.31385,50.49858,-2.12514,3.51645,50.46853,-1.97171,3.52133,50.44666,-1.98253,2.89075,50.61329,-2.45994,2.8377,50.52029,-2.58701,2.80418,50.53331,-2.62858,2.952,50.59787,-2.42029,4.18393,50.05797,-1.44579,4.05512,50.1923,-1.42491,4.17926,50.02391,-1.43017,2.77207,50.43073,-2.57561,2.76175,50.48542,-2.61676,2.74154,50.35068,-2.67366,3.75518,50.27568,-1.73794,3.54252,50.40625,-1.83744,3.55049,50.38703,-1.85046,2.76079,50.31569,-2.6052,2.74685,50.19853,-2.76737,2.73502,50.17941,-2.73884,2.73828,50.18242,-2.73642,2.78369,50.30097,-2.58776,2.94274,50.16509,-2.62615,2.80407,50.18822,-2.69669,2.80464,50.17346,-2.69808,3.21039,49.47801,-2.74342,3.11107,49.46516,-2.77339,3.15506,49.44815,-2.79086,2.76917,49.4251,-3.14905,2.75913,49.46041,-3.13053,2.73147,49.50127,-3.23784,2.86169,50.24576,-2.89191,2.7466,50.20767,-2.77553,2.86307,50.32294,-2.85765,2.75027,50.17922,-2.80587,5.65392,49.10168,-1.48286,5.65992,49.12066,-1.48331,5.65326,49.13552,-1.47813,5.4757,49.56484,-1.23343,5.48781,49.57666,-1.12274,5.73998,49.45323,-1.06662,5.68733,49.4714,-.99301,4.19604,47.72327,-3.38784,4.38203,47.83473,-3.25055,4.40588,47.8224,-3.24952,5.01321,47.85318,-2.87462,5.01037,47.80364,-2.79967,4.87159,47.64765,-2.93286,5.14407,47.92983,-2.76733,5.24727,48.02132,-2.64731,5.26039,48.00596,-2.63397,5.24143,48.2466,-2.69472,5.34725,48.31141,-2.55382,5.34588,48.30129,-2.53171,5.34645,48.33137,-2.59336,5.38575,48.37138,-2.45897,5.44144,48.47528,-2.39166,5.42671,48.448,-2.30632,5.38616,48.39521,-2.5157,6.6335,49.72177,-1.92767,6.53271,49.65638,-1.86644,6.47367,49.70314,-2.0215,2.87419,49.83007,-3.12932,2.83982,49.88187,-3.12797,2.9565,50.01279,-3.04785,5.40788,49.98547,-2.46789,5.42025,50.02224,-2.48787,5.62467,49.95013,-2.38145,4.61951,49.30867,-2.18524,4.61522,49.32421,-2.13949,4.59294,49.35321,-2.18967,4.60269,49.35825,-2.15333,5.10299,48.17102,-2.78681,5.22132,48.26103,-2.69646,5.08172,48.18455,-2.79367,5.60098,48.61843,-1.91662,5.5708,48.60875,-1.9265,5.33336,48.34085,-2.60029,5.39161,48.22295,-2.40733,5.38487,48.21693,-2.39248,5.26693,47.99668,-2.62247,4.99387,47.85349,-2.89894,5.0045,47.86686,-2.8879,4.55198,50.00463,-3.02489,4.65826,50.06115,-2.98579};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_2()
		{
			double[] value = {4.66551,50.04398,-2.97624,4.54901,50.01997,-3.03598,3.09936,50.1991,-2.97901,3.09245,50.19501,-2.98141,3.07528,50.21699,-2.98261,2.86532,49.08542,-3.48802,2.86178,49.08644,-3.49079,2.85078,49.09649,-3.47586,2.86884,49.10148,-3.47316,5.97092,49.03391,-1.81808,5.97388,49.03072,-1.79922,5.97972,48.94326,-1.78289,5.98124,48.94179,-1.8016,5.77053,49.40077,-1.49141,5.75874,49.46947,-1.40042,5.76758,49.45458,-1.39454,5.76383,49.41746,-1.50048,5.62936,49.29925,-1.06283,5.64127,49.29702,-1.07818,5.7294,49.4251,-1.11028,5.7255,49.40981,-1.12556,3.28905,47.95569,-3.68008,3.1427,48.28969,-3.67158,3.14353,48.29438,-3.6951,3.2914,47.96346,-3.65888,2.81768,49.09699,-3.44264,2.76281,49.3522,-3.32643,2.76914,49.35591,-3.34651,2.81435,49.09353,-3.42175,2.72185,49.67623,-3.19023,2.71955,49.66783,-3.17168,2.7647,49.89084,-3.06506,2.76279,49.90029,-3.07973,3.0221,50.68409,-2.29295,3.0189,50.66776,-2.27938,3.21947,50.69885,-2.08775,3.22835,50.71014,-2.09844,4.36885,49.83568,-1.37776,4.37508,49.84504,-1.38373,4.18879,50.0684,-1.45893,4.66838,49.66737,-1.26338,4.66308,49.6731,-1.25768,4.67105,49.6634,-1.26908,4.68136,49.66835,-1.26955,5.59379,49.18258,-1.14482,5.57724,49.18255,-1.13632,5.69096,49.22364,-.34566,5.68326,49.22013,-.36056,5.70076,49.2164,-.36335,4.80415,49.5976,-1.32105,4.80967,49.61115,-1.32191,4.82362,49.6055,-1.32216,4.7091,49.61558,-1.5908,4.70452,49.62684,-1.60957,4.70211,49.63,-1.60284,4.71687,49.61851,-1.60698,3.13279,48.30387,-3.66841,3.48315,50.62647,-1.77073,3.46882,50.63636,-1.79402,3.47151,50.62599,-1.77017,4.66469,49.53839,-1.49065,4.66702,49.52729,-1.4871,4.67586,49.54152,-1.50295,4.65942,49.54489,-1.48407,4.68092,49.52946,-1.48398,4.66,49.68293,-1.26451,4.57935,48.60444,-2.59162,4.25521,48.67712,-2.67158,4.2637,48.65904,-2.67954,2.87584,49.43269,-2.9379,2.86358,49.46505,-2.94484,3.45565,47.77235,-3.74445,3.47578,48.02851,-3.66163,3.61991,47.85998,-3.60221,3.38212,47.96457,-3.72766,4.06235,49.03582,-2.81151,3.69894,49.21974,-2.89514,4.12841,49.09464,-2.77478,3.8486,49.30986,-2.7645,3.89134,48.93333,-2.88327,3.97349,48.96132,-2.86413,4.18915,48.78522,-2.83796,4.12627,48.74681,-2.87646,3.61961,49.02465,-2.94704,3.78971,48.90301,-2.94315,3.39375,49.21527,-2.98652,3.56599,49.11223,-2.95556,3.53313,49.31499,-2.88351,3.1294,49.05252,-3.29777,3.2504,49.14224,-3.13105,3.25807,48.89874,-3.20976,3.38366,48.99724,-3.09069,3.41227,50.15004,-2.96933,3.26775,50.19521,-3.02568,3.24548,50.11698,-2.89734,3.26062,50.21272,-3.0376,3.39061,50.25092,-3.09485,3.45003,50.20403,-3.09772,3.16289,50.26066,-3.00419,3.29441,49.87257,-2.81808};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_3()
		{
			double[] value = {3.41546,50.03871,-2.81358,3.51579,49.85969,-2.72483,3.46017,49.66095,-2.76064,3.18235,50.05168,-2.89728,2.74925,49.50242,-3.26637,2.81226,49.35226,-3.36596,2.80383,49.48364,-3.31366,3.35025,49.43464,-2.86291,3.18931,49.61051,-2.88683,4.72098,47.62591,-2.83249,4.85292,47.82255,-2.73156,4.72659,47.82443,-2.81406,4.14065,47.03235,-3.51608,3.93994,47.03562,-3.66041,3.96828,47.0536,-3.67813,4.125,47.02963,-3.48676,5.30505,48.17422,-2.6438,5.3401,48.28603,-2.49422,5.90982,49.0316,-1.86398,5.76315,49.28546,-1.73695,5.82186,49.2826,-1.71472,5.2654,49.24239,-1.92995,5.32937,49.32377,-1.77555,5.38175,49.11533,-1.86001,5.27515,49.34746,-1.86239,5.50302,48.59235,-2.22015,5.4521,48.52687,-2.20546,5.47436,48.54492,-2.28397,5.66559,48.68305,-1.91564,5.64628,48.65452,-1.84339,5.24987,47.98508,-2.58343,5.14326,47.88845,-2.69034,5.15368,47.91676,-2.75092,5.37331,48.35965,-2.41679,5.40118,48.31134,-2.32552,5.43714,48.41086,-2.22206,5.28641,48.15868,-2.66123,5.16998,48.10467,-2.7054,3.38459,47.73773,-3.77471,3.32975,47.92647,-3.76501,5.13855,50.14934,-2.51,5.33726,50.10051,-2.26101,5.36739,50.0993,-2.3408,6.34977,49.6532,-1.93589,6.39087,49.66863,-1.98088,6.42787,49.63771,-1.92651,6.21948,49.65899,-1.90636,6.22619,49.67595,-1.95213,6.34506,49.64813,-1.88605,5.94538,49.98319,-1.21892,6.19357,50.00982,-.97323,6.1863,49.98755,-1.1567,5.96539,49.9744,-1.01399,4.68793,49.97302,-2.85663,4.87678,49.90073,-2.63161,4.65222,49.89333,-2.6559,4.8722,49.98848,-2.7887,6.0061,49.69363,-2.06206,5.97657,49.65897,-2.03008,5.74996,49.64825,-2.14018,5.79298,49.71545,-2.16507,6.1273,49.76433,-1.51848,6.3684,49.73793,-1.5092,6.37757,49.77678,-1.39181,6.00176,49.66116,-1.75351,6.30261,49.70835,-1.61444,6.10231,49.74243,-1.56376,6.18448,49.66164,-1.77877,3.97434,50.25251,-1.5028,3.86091,50.27899,-1.67242,3.77453,50.39066,-1.6033,5.57125,49.5757,-2.14015,5.5728,49.64055,-2.21806,5.72846,49.59942,-2.05749,5.52903,50.05607,-1.77888,5.28038,50.10361,-2.1022,5.51141,50.09033,-2.05777,5.95627,49.95243,-.80411,5.98969,49.96927,-.76769,5.91958,50.02806,-1.04992,5.67702,49.83974,-1.75339,5.90348,49.83597,-1.61584,5.77404,49.88106,-1.625,5.82129,49.74659,-1.75963,5.0935,50.02009,-2.37716,5.29732,49.99674,-2.11725,5.32744,50.03309,-2.11728,4.61758,49.8937,-2.59354,4.36059,49.952,-2.69972,4.58586,49.83344,-2.54353,4.40642,50.14899,-2.78374,4.65613,50.04036,-2.66456,4.67141,50.09743,-2.69191,5.61759,49.20603,-1.38021,5.61173,49.16996,-1.35348,5.62196,49.15337,-1.40844,5.6286,49.16086,-1.42389,5.93625,49.21467,-.18815,5.93734,49.18855,-.26373,6.04149,49.19782,-.24803};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_4()
		{
			double[] value = {5.01341,49.34861,-.93556,5.2409,49.32164,-.85493,5.18237,49.28555,-.7911,4.96437,49.35672,-1.06303,4.47412,49.72718,-1.37884,4.34398,49.8513,-1.40791,4.46637,49.71137,-1.39806,3.47108,48.63994,-3.12142,3.26171,48.3361,-3.4385,3.55267,48.35678,-3.31085,3.43487,48.70008,-3.02511,3.17832,48.4793,-3.36715,5.38294,48.36357,-2.43714,5.04823,48.06222,-2.5778,5.1715,48.25095,-2.41225,5.0878,48.28224,-2.48903,4.94162,48.0933,-2.61748,3.9299,47.61299,-3.36653,3.6757,47.59487,-3.54346,3.9109,47.36544,-3.43556,5.4943,49.33289,-.38947,5.51684,49.26196,-.45261,4.39437,49.67029,-2.01933,4.20022,49.74931,-2.27625,4.5081,49.56255,-1.92707,4.50605,49.54081,-2.00877,4.75744,49.18507,-1.99258,4.71427,49.12548,-2.07801,4.88546,48.97435,-1.93142,4.88888,49.04162,-1.85333,5.12803,48.5819,-2.0404,5.09939,48.66956,-1.92053,4.92761,48.69231,-2.16013,4.88333,48.80657,-2.09611,4.87519,48.90917,-2.0242,5.09265,48.73643,-1.83769,2.8916,49.65396,-2.97369,2.84384,49.85257,-2.97986,2.81498,49.65901,-3.06744,3.799,50.0114,-1.9823,3.68649,50.08686,-2.01632,3.70245,50.06237,-2.0467,3.56793,50.16686,-2.05228,3.31006,50.2568,-2.2597,3.55935,50.13164,-2.13331,3.34894,50.33951,-2.12921,2.84732,50.03731,-2.86189,3.02354,49.80974,-2.82525,2.9957,50.00902,-2.7675,2.90871,50.29451,-2.55131,3.78258,50.0551,-1.93243,3.95207,50.0446,-1.7258,3.76591,50.09994,-1.88295,3.96797,49.96197,-1.84792,3.76631,50.18088,-1.81269,3.5738,50.24583,-1.96614,3.57493,50.28168,-1.9284,3.41005,50.35911,-2.02763,4.6048,49.29198,-2.18765,4.59554,49.22824,-2.18465,4.68438,49.29313,-2.0817,4.98739,49.09322,-1.55555,5.03576,48.91343,-1.69711,5.11071,49.03626,-1.45686,4.07106,49.87217,-2.06863,4.13952,49.86528,-1.93819,4.00832,49.90263,-1.946,5.19656,49.28505,-1.0397,5.17089,49.22809,-1.18927,5.34752,49.29504,-1.04486,5.3276,49.21749,-1.1754,5.3964,49.26161,-.64038,4.78838,49.41037,-1.16195,4.92987,49.3071,-1.26052,4.80082,49.3885,-1.31742,4.56712,49.62464,-1.41242,4.56253,49.62825,-1.41112,4.54158,49.60829,-1.43816,5.73213,49.36125,-.25294,5.64826,49.28648,-.26326,5.99446,49.28502,-.19917,4.724,49.50645,-1.43224,4.77242,49.54481,-1.47968,4.49024,49.81887,-1.50778,4.49678,49.77607,-1.34263,4.65395,49.69058,-1.42512,3.05415,50.6031,-2.22303,3.23819,50.56929,-2.04436,3.21258,50.60781,-2.0505,5.47042,49.31963,-.70959,5.39266,49.35475,-.88733,4.70112,49.50874,-1.16595,4.76156,49.58795,-1.01174,4.72026,49.59203,-1.21283,4.79206,49.51613,-.94028,4.66032,49.48261,-1.49281,4.69346,49.46578,-1.40966,4.64998,49.50708,-1.46635,4.51614,49.59581,-1.77957,4.63096,49.48113,-1.68811};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_5()
		{
			double[] value = {4.57038,49.52095,-1.61026,4.24812,49.80895,-1.77383,4.25009,49.80727,-1.6781,4.11556,49.9339,-1.65372,2.96817,49.29001,-3.04826,3.22544,49.40492,-2.79442,2.91331,49.42361,-2.96563,3.27293,49.24476,-2.86686,3.76132,50.23495,-1.76919,3.95018,50.10335,-1.65145,5.73985,49.06451,-1.58713,5.70864,49.01919,-1.56473,5.83802,49.00075,-1.68427,5.85087,48.93543,-1.66856,4.38856,47.17709,-3.3335,4.36247,47.18456,-3.28446,5.67894,49.34998,-.60447,5.55089,49.37866,-.77884,5.70565,49.47006,-.56346,5.58171,49.49038,-.7677,5.50922,49.38609,-.93576,5.62795,49.47971,-.9022,5.59916,49.1421,-1.24909,5.60297,49.19671,-1.26436,5.66691,48.76773,-2.01594,5.65202,48.72042,-1.95412,5.59888,48.68596,-2.09591,5.03628,47.87877,-2.6079,5.16196,48.01738,-2.52028,4.96043,47.78303,-2.67192,4.88317,47.61518,-2.77198,4.78137,47.44053,-2.94613,4.65189,47.32004,-3.0111,4.64363,47.31655,-3.07246,4.80084,47.42683,-2.84882,3.17553,48.27065,-3.72284,3.75005,47.18595,-3.77768,3.70445,47.17742,-3.74233,3.46325,47.52191,-3.68465,3.49361,47.55166,-3.78623,2.92213,48.79633,-3.66436,2.87662,48.87542,-3.5765,2.85878,50.06145,-3.02356,2.76113,50.05678,-2.9683,3.94685,50.32644,-1.4529,3.69013,50.53636,-1.59519,3.4495,50.60415,-1.90976,3.22952,50.66987,-2.1166,5.32419,49.58915,-1.29106,5.19492,49.66883,-1.00928,5.19533,49.69235,-.93793,5.40174,49.60155,-.82902,4.79991,49.6882,-1.26148,4.74744,49.53771,-1.26201,4.40156,49.89275,-1.50615,4.66233,49.67371,-1.41617,4.65906,49.61615,-1.39501,2.84104,50.44565,-2.7316,2.7652,50.50102,-2.63232,2.74411,50.36385,-2.6897,6.1328,49.82128,-.65944,6.08485,49.81852,-.77466,6.43782,49.87396,-.65778,5.69509,49.94427,-1.59599,5.81605,49.92511,-1.33258,5.91572,49.87205,-1.08895,5.92399,49.8788,-1.32542,5.6587,49.02118,-1.46883,5.63843,49.04401,-1.4292,5.69795,48.88829,-1.41218,5.74929,48.86892,-1.4824,5.62765,48.88067,-1.18533,5.61494,48.9889,-1.32783,5.7726,48.77949,-1.28035,5.34389,49.62463,-.77589,5.52242,49.57133,-.5784,5.7933,49.44496,-.26304,5.86687,49.47789,-.37845,5.68516,49.52163,-.46508,5.58211,49.48979,-.41754,5.25822,49.59339,-.65092,5.43394,49.52931,-.53339,4.91731,49.66959,-.92343,5.07883,49.64175,-.76213,4.95547,49.7417,-1.02342,5.15922,49.71192,-.88479,5.52907,49.40925,-.3964,5.31548,49.37821,-.51656,5.3504,49.42321,-.52164,6.05491,49.34759,-.22507,4.86007,49.57377,-.87378,3.48322,50.52816,-1.75045,3.68206,50.53152,-1.58844,3.68701,50.43959,-1.5667,3.88637,50.26581,-1.42127,3.94134,50.31632,-1.44402,4.04713,50.11964,-1.40674,4.01349,50.07667,-1.44789,4.07584,49.92851,-1.72909,4.32542,49.84615,-1.4205};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_6()
		{
			double[] value = {4.16744,49.98257,-1.41395,4.45531,49.68704,-1.41681,4.27842,49.79143,-1.46863,4.41998,49.62552,-1.4896,4.49468,49.56048,-1.51555,4.38653,49.69576,-1.7007,4.44223,49.66784,-1.83327,3.34484,50.44205,-2.01806,3.28581,50.46623,-2.01596,3.10679,50.49335,-2.17684,3.1472,50.45148,-2.17774,4.64647,47.44311,-2.92409,4.48797,47.42831,-3.05797,4.29657,47.30648,-3.23766,4.29608,47.36777,-3.22243,3.4968,47.50839,-3.62987,3.7236,47.20515,-3.62973,3.41885,47.76169,-3.5951,3.36265,47.73574,-3.66301,5.03652,48.28931,-2.52205,5.21409,48.34381,-2.2488,5.26586,48.22345,-2.34139,5.26733,48.33201,-2.25352,4.35361,48.45598,-2.84188,4.69255,48.3615,-2.71868,4.64665,48.47706,-2.66001,3.82756,48.65327,-2.88812,3.79351,48.70531,-2.81481,4.30012,48.59804,-2.73035,2.8723,48.87082,-3.55413,2.88046,49.06873,-3.34624,2.9211,48.8548,-3.44856,3.68034,49.33123,-2.64873,3.6536,49.46837,-2.59717,3.15255,49.76211,-2.71949,3.1674,49.60954,-2.73531,3.58439,49.71657,-2.56296,3.93541,49.59838,-2.43062,4.02968,49.43286,-2.50809,2.9153,50.40767,-2.40174,2.86784,50.45629,-2.39958,2.90773,50.34312,-2.49694,2.80839,50.35409,-2.51634,3.81015,49.98337,-2.04698,4.14544,49.81356,-2.18602,4.22201,49.67517,-2.30394,4.51704,49.46611,-2.17461,4.51901,49.50572,-2.08916,4.22731,49.38401,-2.39166,4.24011,49.49864,-2.34663,4.24409,49.09013,-2.52549,4.11245,49.25802,-2.56075,4.16927,49.11382,-2.60632,4.2394,49.21975,-2.4654,4.54966,48.67972,-2.57168,4.22244,48.92708,-2.66477,4.27847,48.75089,-2.71074,4.32515,48.91291,-2.58005,4.74772,48.53347,-2.52586,4.98756,48.40365,-2.41436,4.77194,48.53975,-2.50428,4.94585,48.36802,-2.49779,5.25929,48.45671,-2.15069,5.16702,48.48207,-2.1143,4.50258,49.39133,-2.22833,5.30234,48.53992,-2.07803,5.2409,48.55108,-2.05902,5.34629,48.60289,-2.0062,5.43127,48.50308,-2.1118,5.50421,48.56288,-2.00774,5.56387,48.74704,-1.67617,5.62769,48.76837,-1.57957,5.44774,48.78662,-1.57708,4.67389,49.03515,-2.18919,5.19239,48.78983,-1.71453,5.05251,48.84778,-1.74967,4.60589,49.45951,-1.86523,5.61295,48.87747,-1.18104,5.56621,49.02156,-1.13895,5.52588,49.03251,-1.1586,4.86849,49.17994,-1.67368,4.97334,49.21003,-1.43252,4.85964,49.27474,-1.50243,5.45525,49.20259,-1.17765,5.4322,49.06087,-1.20893,5.31281,49.09023,-1.25897,5.60538,49.31764,-1.06678,5.53055,49.18875,-1.14652,5.55903,49.24448,-.49802,5.72095,49.21273,-.39759,6.1032,49.36997,-.36486,6.1267,49.35988,-.32684,6.13722,49.2585,-.2964,6.05668,49.25953,-.36782,5.81608,49.31515,-.48985,5.88706,49.42866,-.46989,5.99653,49.21007,-.35327,6.09026,49.22771,-.27974,5.50533,49.29832,-1.04377,5.56601,49.37096,-1.00806};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_7()
		{
			double[] value = {5.91638,49.95665,-.82962,5.88978,50.02385,-1.05012,5.72915,49.9775,-1.41584,5.68881,48.94868,-1.92865,5.55591,49.07586,-1.86736,5.50798,48.97838,-1.93093,5.30398,49.06437,-1.93157,5.91463,48.91863,-1.87941,5.98729,48.85515,-1.75866,5.89206,48.82403,-1.82397,5.6496,48.78014,-2.02433,5.36378,48.77178,-2.04807,5.48593,48.85523,-1.9966,5.58175,48.69566,-2.10411,4.70735,49.07721,-2.33216,4.6609,49.29608,-2.3498,4.80154,49.09001,-2.22296,4.56588,49.2486,-2.42658,5.24656,48.63361,-2.25588,5.43022,48.48294,-2.39962,5.2019,48.55211,-2.33626,5.46403,48.55262,-2.2934,4.43611,49.41551,-2.45317,4.31334,49.40719,-2.54714,4.15771,49.5829,-2.56316,4.31838,49.60685,-2.49341,4.23497,49.3267,-2.64788,4.06706,49.46933,-2.65737,4.55514,48.96399,-2.57775,4.38093,49.14947,-2.60744,4.47549,49.19395,-2.50719,4.60281,49.03001,-2.43988,4.98191,48.47853,-2.5423,5.19594,48.47346,-2.46187,5.14076,48.40178,-2.54076,5.03322,48.54669,-2.43098,4.75188,48.74782,-2.46279,4.70711,48.67692,-2.59109,4.44476,48.91007,-2.67453,4.29246,49.07649,-2.6938,3.68701,49.64114,-2.68194,3.99287,49.54276,-2.67137,3.90793,49.43182,-2.69524,3.88338,49.72938,-2.67552,3.97968,49.95094,-2.72091,4.05921,49.76662,-2.62244,3.7564,49.94185,-2.71389,3.73392,49.99992,-2.76592,4.64096,48.60367,-2.68538,4.53214,48.52647,-2.80097,4.35475,48.84666,-2.74974,2.99962,49.65459,-3.0653,3.06252,49.86302,-2.95944,3.13185,49.47297,-3.01001,5.04218,48.0081,-2.81707,4.92062,47.9161,-2.90689,4.64686,48.24885,-2.85737,4.53195,48.17176,-2.9558,4.27643,48.3047,-2.98053,4.3912,48.43584,-2.8996,2.90729,49.56321,-3.21779,4.76468,47.79026,-3.05179,4.85912,47.65263,-2.95483,4.636,47.69878,-3.13228,4.89349,47.88954,-2.96329,2.82403,49.47811,-3.3138,2.91592,49.37709,-3.26542,2.83259,49.34689,-3.36548,3.7367,48.30264,-3.33475,3.81175,48.44206,-3.18304,4.14132,48.18384,-3.10851,3.99262,48.06481,-3.25376,4.21031,47.91838,-3.21702,4.02355,47.80231,-3.31713,3.82768,47.96004,-3.38239,3.52323,48.42775,-3.42852,3.62181,48.18175,-3.49294,3.5751,48.13003,-3.56281,3.06823,48.67585,-3.6395,2.98299,48.85996,-3.55588,2.98757,48.63227,-3.7004,3.21122,48.33719,-3.66685,4.23831,47.17728,-3.50644,4.16188,47.21388,-3.55885,5.83164,49.2733,-1.69717,5.78923,49.20902,-1.58617,5.83173,49.0705,-1.67209,5.70623,49.3101,-1.40156,5.73724,49.28939,-1.46743,5.67175,49.46928,-1.56866,5.57646,49.54042,-1.43975,6.23518,49.69203,-2.01134,6.03515,49.72919,-2.09433,5.57268,49.72948,-2.25887,5.7117,49.55833,-1.97768,5.57067,49.51275,-2.06274,5.34554,49.60383,-2.28251,5.22552,49.45534,-2.23002,5.19201,49.60044,-2.30646,5.36501,49.52248,-2.21488};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_8()
		{
			double[] value = {5.06611,49.38212,-2.20781,5.23653,49.32064,-2.0731,5.17297,49.23754,-2.0393,4.86138,49.45794,-2.30053,5.02605,49.45578,-2.27088,4.89978,49.35084,-2.24429,4.72898,49.43915,-2.34819,4.68888,49.5878,-2.41962,4.85369,49.59593,-2.39124,4.59479,49.43347,-2.39597,4.53867,49.59896,-2.44782,4.27579,49.75496,-2.55826,4.50024,49.7742,-2.55935,4.25989,49.89782,-2.67277,5.26766,49.37011,-1.91279,5.24707,49.32153,-1.97754,5.07448,49.42793,-1.87649,5.06067,49.4503,-1.76955,5.4643,49.49453,-1.63608,5.51158,49.30782,-1.77316,5.38237,49.565,-1.49647,5.07423,49.51045,-1.5688,5.0138,49.57796,-1.41951,5.23957,49.61774,-1.14322,4.97206,49.62154,-1.26256,4.92444,49.72277,-1.13609,4.9123,49.51399,-1.66544,4.78537,49.54864,-1.49507,4.51679,49.75566,-1.65866,4.35546,49.82347,-1.68458,4.43356,49.72514,-1.91798,4.32688,49.73871,-2.21155,4.22687,49.77647,-2.03838,4.54107,49.65528,-2.06399,4.17857,50.06345,-1.51067,4.13964,50.03933,-1.7086,3.02696,50.62917,-2.32411,3.08951,50.51234,-2.33459,3.41284,50.25376,-2.11504,3.55584,50.1393,-2.13438,3.30396,50.22458,-2.20618,2.9939,50.41715,-2.42644,5.71518,49.66704,-1.88264,5.62628,49.59009,-1.95764,5.84558,49.60125,-1.89364,5.16221,49.53709,-1.98221,5.33338,49.62418,-2.02733,5.07777,49.59446,-2.00961,5.21206,49.69697,-2.09109,4.65168,50.22464,-2.67439,4.43131,50.26022,-2.80453,4.15289,50.02575,-2.78019,3.96645,50.20333,-2.93807,3.95519,50.10119,-2.83943,4.18022,50.18807,-2.87103,3.70936,50.25048,-2.96282,3.67652,50.21896,-2.90655,4.20788,50.27494,-2.88931,3.98339,50.28057,-2.97805,3.37006,50.32432,-3.02103,3.44954,50.30341,-2.98773,3.50285,50.30873,-3.04877,6.12378,49.83804,-1.01798,6.40068,49.84084,-.91194,6.70612,49.77457,-1.59203,6.52144,49.72271,-1.57765,6.68147,49.68511,-1.73956,6.53654,49.80425,-1.34785,6.65711,49.84333,-1.33288,6.6353,49.84878,-1.06154,6.533,49.83574,-1.10634,6.60547,49.90447,-.87607,6.52654,49.8632,-.85567,6.72339,49.81416,-1.80872,6.70708,49.8679,-1.62806,6.60725,49.87247,-1.84194,6.60261,49.95535,-1.64775,6.47152,49.84946,-2.00353,6.47136,49.91288,-1.8758,6.46846,49.98373,-1.64789,6.2692,49.98344,-.70644,6.38803,50.02145,-.93147,6.23093,49.93656,-1.90568,6.27076,49.89602,-2.053,5.52901,50.07083,-2.20893,4.51772,49.94366,-2.86125,4.28121,49.95999,-2.90806,4.02004,50.05782,-2.94812,4.0477,50.03919,-3.15812,4.32962,49.98791,-3.11782,3.02746,50.26378,-2.95361,2.99109,50.34555,-2.86593,3.45409,50.18902,-3.08273,3.70954,50.12656,-2.99055,3.76424,50.09268,-3.14855,3.63128,50.23743,-3.14684,3.73812,50.29542,-3.00857,3.9286,50.25187,-3.19056,4.33076,49.99959,-3.12945,4.04706,50.04881,-3.16987};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_9()
		{
			double[] value = {4.18964,50.23506,-3.11116,4.36776,50.23338,-3.0156,4.56527,50.21007,-2.91254,4.74416,50.20228,-2.82637,4.96226,50.18642,-2.67774,5.21593,50.08478,-2.62621,5.07988,50.08527,-2.73038,5.80989,50.04183,-2.03752,5.72087,50.04362,-1.75845,5.84355,49.97729,-2.23784,5.6212,49.97061,-2.38757,5.60671,50.01253,-2.36138,5.85494,49.8897,-2.26139,6.26009,49.73335,-2.09385,6.0302,49.79425,-2.16177,6.2641,49.74946,-2.10245,6.58141,49.66684,-1.83868,6.5761,49.96836,-1.37672,6.68831,49.9085,-1.36088,6.5433,49.98161,-1.09093,6.4276,50.00797,-1.11093,6.48581,49.95691,-.8947,6.34615,49.93949,-.66037,6.69142,49.90609,-1.09752,5.91131,49.62932,-1.96145,4.97303,49.65282,-2.10912,4.92062,49.68256,-2.18385,4.80746,49.55532,-2.02104,4.97212,49.50256,-1.89386,4.94449,49.47697,-1.86156,5.05662,50.14785,-2.33985,5.44555,49.91401,-2.00994,5.57044,49.99832,-1.7879,5.52001,49.51095,-2.00909,5.56991,49.80018,-1.90363,3.00825,50.31863,-2.59182,3.311,50.06779,-2.36443,3.6294,49.99701,-2.30031,3.71991,50.21526,-1.87408,3.78496,50.07078,-2.0272,3.51364,50.29716,-2.06061,3.99676,49.87698,-2.1624,3.82437,49.93111,-2.22579,3.92343,49.98864,-1.92589,4.07414,49.81646,-2.32274,3.87569,50.09671,-1.77844,4.14814,49.88125,-1.81147,4.80732,49.52731,-1.74948,5.18625,49.42502,-1.67729,5.3281,49.3819,-2.0447,5.31501,49.42072,-1.97783,5.03342,49.16679,-2.09207,5.05746,49.92459,-2.5953,5.21926,49.95511,-2.52801,5.22072,49.78341,-2.43199,5.05037,49.7728,-2.47509,5.37865,49.76697,-2.36015,5.35394,49.39591,-2.09302,5.84743,49.80591,-2.1981,5.64713,49.26881,-1.28803,5.64746,49.21696,-1.459,5.71894,49.11558,-1.57686,3.92743,47.7394,-3.44275,4.10954,47.76282,-3.35243,3.30789,48.45969,-3.56531,3.15063,48.75698,-3.47696,4.32082,47.86441,-3.21542,4.44586,47.54266,-3.27602,3.49142,48.63624,-3.29015,3.07064,49.33169,-3.14579,4.84068,48.00189,-2.98705,2.82447,49.66105,-3.24834,4.93444,48.11281,-2.88896,4.05464,48.70458,-2.93687,4.08118,49.28131,-2.71614,4.90818,49.13165,-2.12476,4.81855,49.10851,-2.20766,4.77253,49.34111,-2.29784,4.96766,48.99126,-2.12091,5.12858,48.79373,-2.1252,4.933,48.95066,-2.15119,5.17555,48.85607,-2.04354,5.05554,49.01256,-2.02899,5.33489,48.91166,-1.97688,5.76532,48.78697,-1.87902,5.78492,48.84824,-1.93963,5.77666,48.86614,-1.94547,5.6293,48.92558,-1.9401,5.7671,49.2634,-.44367,5.93758,49.16776,-.328,5.93748,49.18128,-.28575,5.3305,49.35546,-.53994,5.06363,49.32967,-1.04445,4.97824,49.44295,-.74068,4.83164,49.40934,-1.05377,5.62318,48.77049,-1.33514,5.76364,48.774,-1.27903,5.49573,48.89755,-1.22124,5.42547,48.78401,-1.54779,5.19151,48.86154,-1.59828};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_10()
		{
			double[] value = {5.31825,48.80096,-1.59874,5.42662,48.79412,-1.44192,4.48329,49.11421,-2.32023,4.55355,49.3592,-2.19548,5.67517,48.74169,-1.44736,5.79164,48.75102,-1.64429,5.39011,48.79021,-1.6125,5.4631,48.72771,-1.81876,5.62911,48.65678,-1.83137,5.70952,48.71818,-1.71584,4.43347,49.30722,-2.29822,3.88942,49.82567,-2.41644,3.89155,49.96292,-1.96641,3.54624,50.10586,-2.27359,3.09114,50.35052,-2.36827,3.85303,49.94768,-2.20376,3.12488,50.30422,-2.39193,3.04899,50.25015,-2.51776,3.49985,50.06193,-2.4639,3.53139,50.0754,-2.37713,3.86976,49.89366,-2.39613,3.53322,49.94895,-2.55307,3.1045,49.97877,-2.70349,3.09201,49.49247,-2.78212,3.06572,49.57052,-2.80945,3.03302,49.69398,-2.82253,2.87377,49.54007,-2.97468,2.77582,49.51325,-3.09196,2.80307,49.31258,-3.22549,3.78591,48.80269,-2.85045,3.42075,48.81355,-3.03747,3.77454,48.72382,-2.80792,3.41057,48.71843,-3.02183,3.09148,48.84721,-3.26862,3.11109,48.65337,-3.35344,3.0662,48.43489,-3.4983,2.9945,48.60686,-3.51661,2.94619,48.62823,-3.62018,4.62978,48.50415,-2.64431,4.8545,48.31391,-2.64445,4.38767,48.22328,-2.94418,3.87118,48.55935,-2.98493,3.94773,48.30477,-3.13761,3.18888,48.26468,-3.54332,3.35073,47.99275,-3.57817,4.6072,48.17953,-2.84263,4.43742,47.81542,-3.03514,4.34764,47.80917,-3.08114,4.31456,47.60425,-3.13491,4.53456,47.56219,-2.97461,3.57131,50.33276,-1.88416,4.6874,49.42372,-1.63341,4.493,49.76713,-1.33752,4.14418,49.93718,-1.4664,4.14008,49.8664,-1.81323,4.70437,49.48179,-1.23639,4.98171,49.52952,-.715,5.1614,49.47334,-.58425,5.14817,49.38796,-.62914,4.82269,49.69948,-1.088,6.13959,49.26628,-.2797,6.12695,49.35568,-.30527,6.12364,49.36126,-.31634,5.58247,49.02128,-1.14476,5.60386,49.07626,-1.28256,5.61721,49.07296,-1.38938,5.68214,49.00699,-1.51686,5.7853,48.88299,-1.55899,5.81079,48.75273,-1.66101,5.72541,48.71768,-1.73293,5.86346,48.7778,-1.76887,5.74717,48.74718,-1.82778,5.66675,48.68938,-1.9407,5.96388,49.88628,-.77515,5.44066,49.57071,-.98926,2.94861,48.6336,-3.64317,6.04678,49.1946,-.26639,5.81905,48.88901,-1.61375,5.07492,49.16423,-1.3769,5.18236,49.12006,-1.32125,5.04494,49.26546,-1.22545,4.05196,50.20858,-1.4402,4.70116,49.37297,-1.86947,4.79905,49.25925,-1.73797,4.79504,49.33013,-1.55131,3.87014,49.99238,-1.93392,3.04142,50.14036,-2.58012,4.96129,47.95201,-2.63803,4.77804,47.98626,-2.75292,3.15493,48.49672,-3.36856,4.59299,49.63628,-1.38087,4.64766,49.6092,-1.39021,5.3627,48.94487,-1.28896,5.22919,48.99095,-1.37455,5.23884,49.87922,-2.16827,5.05344,49.92941,-2.333,5.11871,49.75276,-2.16267,4.99409,49.80601,-2.26982,5.32623,49.81796,-2.08528,5.43684,49.73165,-2.00972};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_11()
		{
			double[] value = {5.07391,50.00003,-2.66451,6.45889,49.68776,-2.01523,5.63605,50.00914,-1.59395,4.31643,47.35866,-3.40093,5.44563,48.50296,-2.12733,5.75531,48.75647,-1.84748,5.46502,48.51592,-2.10296,3.15048,49.2316,-3.12516,3.06285,49.19676,-3.23185,3.67093,49.44941,-2.74963,3.19689,50.32978,-2.97507,3.03926,48.9165,-3.46051,3.28767,47.94844,-3.66843,4.79188,49.55176,-1.48282,5.86968,48.7368,-1.42345,5.86285,48.73013,-1.42494,5.91964,48.74904,-1.58405,5.92263,48.75732,-1.57582,2.81841,49.89041,-3.12396,2.93647,50.02958,-3.0509,5.41989,50.03762,-2.48364,5.08707,50.06735,-2.7252,5.21912,50.069,-2.62726,4.82404,47.99033,-3.00145,4.81524,48.01158,-2.99635,5.57314,48.66805,-2.12153,5.39269,48.30781,-2.30922,5.4258,48.40937,-2.20622,4.63806,49.38259,-2.1559,4.61227,49.38104,-2.14819,4.67478,49.30826,-2.1112,4.68408,49.32852,-2.12824,2.88272,50.59473,-2.44682,2.8437,50.50827,-2.41986,2.75085,50.17383,-2.79333,2.80857,50.16321,-2.72086,3.26781,50.49174,-2.01756,3.86369,50.25999,-1.68747,3.82448,47.67121,-3.56196,4.03452,47.55832,-3.52761,3.74031,47.92068,-3.50029,5.63514,49.12521,-1.44079,5.64594,49.15023,-1.46506,5.63785,49.15958,-1.44583,5.625,49.10787,-1.4166,5.63348,49.09105,-1.43573,5.6217,49.12695,-1.40515,3.69308,50.35179,-1.82262,3.68398,50.3741,-1.81336,2.78518,50.37045,-2.53144,3.09052,50.51454,-2.1811,2.84707,50.47608,-2.41031,5.64932,49.08903,-1.47177,5.64221,49.08431,-1.45531,5.49338,48.60226,-2.22669,5.37508,48.40421,-2.52288,4.64568,47.88954,-3.10267,4.62475,47.90358,-3.10297,4.88102,47.87979,-2.97577,6.03648,49.81283,-2.16841,5.84948,49.87036,-2.2567,3.76411,50.10358,-3.16253,4.85154,50.05521,-2.88518,4.84704,50.07312,-2.8909,2.80482,49.66714,-3.246,5.9722,48.78536,-1.69294,5.97203,48.79307,-1.68059,6.09364,49.23556,-.26501,2.76277,50.04689,-2.95386,2.92732,49.13242,-3.40098,3.615,50.17404,-2.81778,3.35956,50.27401,-2.89411,3.24854,49.3308,-2.98724,5.04068,48.32998,-2.6579,4.89746,48.40073,-2.6568,3.91056,48.59609,-3.04542,3.59747,48.78735,-3.10898,5.96488,50.01793,-1.71321,5.93589,50.00736,-1.40372,5.38729,49.94299,-2.43202,5.62664,49.87942,-2.31189,5.22104,50.01683,-2.58128,6.40644,49.65552,-1.79971,4.58121,49.68619,-1.75884,4.68949,49.58732,-1.90029,4.84297,49.84119,-2.42059,4.7967,49.73807,-2.34857,4.91487,50.04288,-2.53572,4.89135,49.97508,-2.49753,5.60994,49.14244,-1.34577,5.61261,49.10946,-1.36258,5.62159,49.1426,-1.40265,4.58319,49.64387,-1.37823,5.00471,48.53866,-2.25223,4.81803,48.63543,-2.36802,4.5752,48.88643,-2.38655,4.66904,48.93478,-2.25852,4.49137,49.03552,-2.36209,4.7013,48.81922,-2.30724,4.43119,47.97483,-2.99031};
			return value;
		}
		private double[] getlscapula_Coord_7_100_point_12()
		{
			double[] value = {5.26392,48.76217,-1.71736,5.61705,49.29672,-.55121,3.85904,49.92111,-2.2991,3.03923,49.05787,-3.1777,5.69034,49.17439,-1.53495,3.59477,50.51266,-1.75214,3.95417,47.82724,-3.28832,3.59641,47.8218,-3.52103,3.96532,48.03949,-3.23071,3.57755,48.06812,-3.45268,4.37665,47.98731,-3.01794,3.76556,48.98935,-2.78723,3.35211,49.02635,-2.95592,3.73189,49.15271,-2.71077,4.65048,48.76341,-2.41243,5.23239,48.62366,-1.9443,5.3936,48.66815,-1.90647,5.23198,48.69344,-1.84089,4.60347,49.38943,-2.14101,6.11586,49.88907,-.67512,5.30462,48.69468,-2.15929,4.87533,48.87975,-2.23919,5.08113,48.7236,-2.21578,4.79576,48.81518,-2.3477,5.04441,48.62744,-2.3031,4.91279,48.26196,-2.7755,4.78741,48.32671,-2.77207,4.91136,48.12599,-2.89328,4.73695,48.19947,-2.85384,4.61687,48.11714,-2.95579,4.48035,47.97216,-3.07892,4.38373,48.02912,-3.07462,3.89267,47.34,-3.72765,3.66135,47.55138,-3.72623,5.98514,48.85952,-1.74144,5.02342,49.59641,-2.34859,4.86528,49.77064,-2.52184,4.66618,49.78397,-2.55838,3.88707,49.89847,-2.41197,3.38356,50.07681,-2.5806,3.69571,49.98283,-2.49757,3.17461,50.21976,-2.71552,4.88358,50.18042,-2.50283,4.67014,49.61186,-2.16448,4.44076,49.73374,-2.37956,4.22104,49.84767,-2.54956,4.04339,49.95243,-2.65141,3.86199,50.0542,-2.7296,6.14156,49.82642,-1.23933,6.3902,49.82592,-1.12657,6.46203,49.67797,-1.7203,6.42608,50.00842,-1.37391,6.21054,49.98076,-1.65948,6.17691,49.9861,-1.36816,6.03375,49.93964,-2.13829,5.99501,50.00038,-1.97221,4.48909,49.8842,-2.66181,4.28178,49.78164,-1.89936};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlcoscart_Geo_6_105_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,7,5,8,-1,5,9,8,-1,10,9,5,-1,10,11,9,-1,12,13,14,-1,8,15,7,-1,15,16,7,-1,17,18,19,-1,18,20,19,-1,21,22,23,-1,22,24,23,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,32,33,34,-1,35,33,36,-1,35,37,33,-1,38,39,40,-1,41,42,43,-1,44,45,46,-1,47,48,49,-1,50,51,52,-1,51,53,52,-1,54,55,56,-1,57,58,59,-1,58,57,60,-1,60,61,58,-1,62,30,63,-1,64,65,66,-1,66,67,64,-1,64,67,68,-1,68,69,64,-1,68,70,13,-1,65,71,66,-1,65,72,71,-1,71,72,73,-1,14,74,75,-1,76,77,78,-1,46,75,74,-1,46,79,75,-1,80,81,82,-1,82,83,80,-1,84,82,85,-1,84,83,82,-1,86,85,87,-1,82,88,87,-1,87,85,82,-1,89,90,91,-1,90,92,91,-1,91,93,89,-1,93,94,89,-1,95,91,92,-1,96,97,98,-1,96,98,99,-1,97,100,101,-1,102,103,104,-1,105,106,103,-1,106,107,103,-1,108,105,109,-1,110,111,112,-1,113,114,115,-1,116,117,113,-1,118,119,120,-1,121,122,123,-1,124,125,126,-1,127,128,129,-1,129,130,127,-1,129,131,130,-1,121,132,133,-1,134,135,136,-1,137,138,134,-1,139,140,141,-1,139,137,140,-1,142,137,139,-1,142,138,137,-1,143,144,145,-1,146,147,148,-1,149,150,151,-1,149,152,150,-1,153,154,142,-1,154,138,142,-1,155,156,157,-1,157,158,155,-1,159,160,161,-1,160,162,161,-1,135,134,163,-1,134,164,163,-1,165,166,167,-1,168,169,170,-1,171,172,173,-1,173,174,171,-1,175,176,177,-1,178,179,180,-1,180,181,178,-1,182,183,184,-1,185,186,187,-1,188,189,190,-1,191,192,193,-1,194,195,196,-1,196,197,194,-1,195,194,198,-1,199,200,201,-1,202,203,204,-1,204,205,202,-1,206,190,203,-1,202,207,203,-1,208,209,210,-1,210,211,208,-1,212,213,210,-1,166,165,214,-1,215,216,217,-1,218,219,220,-1,221,222,223,-1,221,224,222,-1,223,225,226,-1,227,228,229,-1,230,231,232,-1,233,234,235,-1,233,236,234,-1,237,238,239,-1,240,241,242,-1,242,243,240,-1,244,245,246,-1,244,247,245,-1,60,248,249,-1,250,251,252,-1,253,252,251,-1,254,255,256,-1,255,257,256,-1,258,87,88,-1,30,259,260,-1,261,93,262,-1,92,90,263,-1,90,73,263,-1,51,264,53,-1,51,265,264,-1,77,266,267,-1,268,269,19,-1,19,20,268,-1,73,72,270,-1,271,272,83,-1,95,273,274,-1,275,97,276,-1,276,277,275,-1,278,279,280,-1,278,281,279,-1,282,98,283,-1,282,284,98,-1,285,286,287,-1,283,98,97,-1,108,288,289,-1,290,108,291,-1,290,292,108,-1,293,294,121,-1,5,295,10,-1,296,297,298,-1,296,299,297,-1,300,301,302,-1,300,303,301,-1,304,253,301,-1,305,306,307,-1,307,308,305,-1,309,145,124,-1,124,310,309,-1,311,312,247,-1,312,313,247,-1,158,133,132,-1,121,314,315,-1,316,156,317,-1,316,157,156,-1,318,319,320,-1,320,321,318,-1,161,162,150,-1,162,151,150,-1,322,323,119,-1,324,325,326,-1,324,327,325,-1,154,328,164,-1,329,330,331,-1,330,303,331,-1,332,333,334,-1,334,335,332,-1,336,337,295,-1,295,338,336,-1,339,340,341,-1,342,343,344,-1,345,346,347,-1,346,348,347,-1,349,350,351,-1,350,352,351,-1,353,354,355,-1,353,356,354,-1,357,358,359,-1,360,361,362,-1,361,363,362,-1,364,361,365,-1,365,327,364,-1,366,250,367,-1,368,360,362,-1,368,369,360,-1,313,131,370,-1,370,247,313,-1,231,230,237,-1,371,372,373,-1,374,375,376,-1,377,378,379,-1,378,380,379,-1,381,216,215,-1,381,382,216,-1,383,306,305,-1,308,384,381,-1,213,385,386,-1,387,199,388,-1,199,389,388,-1,390,391,206,-1,390,392,391,-1,213,393,211,-1,213,394,393,-1,56,59,58,-1,58,54,56,-1,395,396,397,-1,398,399,400,-1,398,401,399,-1,29,63,30,-1,402,403,187,-1,213,386,404,-1,205,405,202,-1,40,78,406,-1,407,408,79,-1,409,410,411,-1,69,412,64,-1,413,43,42,-1,414,415,416,-1,417,418,419,-1,417,412,418,-1,420,406,24,-1,406,23,24,-1,421,422,423,-1,421,424,422,-1,425,49,48,-1,401,49,426,-1,260,31,30,-1,37,427,34,-1,276,101,428,-1,429,430,431,-1,431,432,429,-1,433,434,175,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_2()
		{
			int[] value = {434,435,175,-1,436,170,169,-1,167,166,437,-1,438,190,189,-1,439,440,441,-1,440,442,441,-1,226,443,430,-1,226,225,443,-1,444,435,431,-1,218,220,445,-1,446,447,220,-1,220,448,446,-1,449,450,451,-1,451,452,449,-1,453,454,455,-1,454,456,455,-1,457,458,459,-1,176,435,444,-1,176,175,435,-1,460,461,462,-1,241,463,464,-1,463,197,464,-1,465,466,467,-1,468,469,296,-1,470,471,472,-1,471,473,472,-1,361,364,302,-1,364,300,302,-1,46,74,474,-1,474,44,46,-1,475,19,269,-1,476,249,248,-1,248,477,476,-1,164,478,163,-1,164,479,478,-1,164,480,479,-1,15,8,481,-1,482,8,9,-1,347,483,484,-1,347,348,483,-1,485,482,11,-1,482,9,11,-1,7,16,6,-1,86,486,84,-1,86,27,486,-1,259,88,260,-1,487,380,488,-1,488,375,487,-1,377,256,489,-1,489,378,377,-1,428,277,276,-1,428,490,277,-1,100,491,492,-1,493,255,494,-1,493,495,255,-1,496,497,498,-1,496,499,497,-1,500,501,502,-1,503,504,505,-1,503,506,504,-1,503,507,506,-1,508,509,510,-1,132,155,158,-1,511,160,159,-1,159,512,511,-1,114,513,514,-1,114,515,513,-1,237,516,231,-1,245,247,370,-1,311,517,518,-1,311,519,517,-1,146,520,147,-1,146,521,520,-1,110,522,116,-1,110,523,522,-1,114,117,524,-1,114,113,117,-1,525,526,527,-1,525,528,526,-1,529,405,530,-1,530,531,529,-1,392,532,533,-1,392,389,532,-1,451,359,447,-1,451,534,359,-1,535,536,537,-1,537,538,535,-1,359,358,445,-1,539,540,541,-1,541,542,539,-1,543,484,544,-1,543,545,484,-1,546,479,352,-1,546,478,479,-1,348,480,483,-1,348,351,480,-1,273,15,481,-1,273,28,15,-1,72,547,270,-1,72,65,547,-1,411,74,409,-1,411,474,74,-1,548,399,401,-1,73,17,263,-1,482,104,8,-1,481,106,273,-1,481,107,106,-1,549,550,274,-1,551,552,553,-1,553,554,551,-1,482,555,556,-1,557,290,291,-1,558,104,482,-1,559,560,561,-1,561,371,559,-1,552,1,320,-1,320,562,552,-1,119,563,322,-1,314,354,564,-1,314,355,354,-1,230,232,565,-1,566,567,568,-1,568,569,566,-1,570,571,572,-1,570,573,571,-1,574,575,565,-1,576,577,578,-1,578,579,576,-1,566,569,382,-1,382,580,566,-1,581,582,583,-1,581,584,582,-1,463,384,585,-1,463,586,384,-1,587,588,393,-1,393,394,587,-1,589,590,437,-1,437,591,589,-1,592,593,180,-1,593,583,180,-1,594,595,596,-1,594,597,595,-1,598,599,600,-1,598,601,599,-1,601,602,599,-1,601,603,602,-1,439,604,602,-1,439,605,604,-1,606,607,442,-1,442,440,606,-1,606,608,609,-1,606,610,608,-1,180,583,181,-1,583,582,181,-1,437,590,593,-1,593,592,437,-1,393,588,589,-1,589,591,393,-1,593,581,583,-1,593,611,581,-1,577,566,580,-1,580,578,577,-1,575,612,565,-1,613,614,573,-1,346,345,615,-1,615,616,346,-1,564,354,617,-1,553,552,562,-1,562,618,553,-1,555,619,563,-1,371,556,372,-1,371,561,556,-1,374,560,559,-1,374,620,560,-1,621,622,623,-1,620,624,557,-1,557,285,620,-1,554,553,485,-1,625,550,626,-1,274,550,627,-1,628,626,550,-1,550,549,628,-1,95,28,273,-1,95,26,28,-1,94,93,261,-1,629,630,261,-1,320,0,321,-1,320,1,0,-1,631,632,152,-1,632,153,152,-1,544,483,328,-1,544,484,483,-1,543,633,545,-1,633,344,545,-1,530,168,634,-1,530,405,168,-1,186,635,636,-1,198,637,636,-1,638,639,640,-1,638,641,639,-1,642,528,525,-1,642,235,528,-1,183,643,644,-1,644,645,183,-1,522,117,116,-1,646,245,370,-1,646,647,245,-1,140,112,513,-1,513,648,140,-1,649,160,511,-1,649,650,160,-1,508,157,316,-1,508,510,157,-1,651,652,653,-1,654,655,656,-1,366,657,658,-1,101,255,495,-1,101,257,255,-1,97,275,283,-1,99,492,491,-1,99,659,492,-1,378,660,661,-1,378,489,660,-1,662,256,377,-1,662,254,256,-1,663,621,664,-1,663,622,621,-1,280,30,665,-1,280,259,30,-1,48,47,50,-1,47,51,50,-1,666,667,668,-1,272,266,407,-1,407,264,272,-1,25,86,669,-1,25,27,86,-1,5,7,6,-1,670,554,11,-1,554,485,11,-1,671,672,673,-1,673,674,671,-1,675,163,478,-1,675,676,163,-1,677,421,423,-1,401,678,49,-1,194,197,585,-1,197,463,585,-1,360,365,361,-1,470,472,300,-1,300,364,470,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_3()
		{
			int[] value = {468,679,469,-1,468,2,679,-1,471,680,473,-1,471,681,680,-1,431,430,443,-1,446,452,447,-1,452,451,447,-1,177,448,682,-1,682,175,177,-1,683,224,221,-1,448,177,684,-1,684,446,448,-1,685,212,686,-1,685,687,212,-1,360,369,688,-1,688,365,360,-1,437,592,167,-1,689,167,690,-1,167,592,690,-1,432,431,435,-1,435,434,432,-1,691,226,430,-1,430,429,691,-1,606,692,607,-1,693,281,694,-1,281,695,694,-1,695,696,697,-1,696,698,697,-1,699,282,283,-1,700,272,264,-1,701,401,426,-1,701,548,401,-1,547,22,21,-1,39,38,12,-1,70,548,409,-1,548,701,409,-1,702,416,703,-1,39,78,40,-1,704,705,706,-1,212,707,213,-1,707,385,213,-1,708,709,402,-1,709,403,402,-1,585,307,710,-1,401,398,678,-1,711,696,665,-1,696,278,665,-1,208,393,591,-1,208,211,393,-1,712,200,713,-1,713,714,712,-1,715,716,717,-1,717,718,715,-1,709,387,403,-1,387,388,403,-1,719,390,206,-1,306,714,720,-1,306,717,714,-1,384,308,585,-1,308,307,585,-1,307,306,710,-1,306,720,710,-1,384,382,381,-1,384,580,382,-1,663,664,721,-1,664,722,721,-1,378,661,380,-1,661,488,380,-1,662,377,723,-1,377,379,723,-1,371,373,487,-1,487,559,371,-1,724,647,646,-1,646,725,724,-1,633,342,344,-1,503,131,507,-1,726,353,355,-1,355,294,726,-1,568,567,727,-1,567,728,727,-1,729,338,295,-1,5,729,295,-1,5,4,729,-1,339,341,337,-1,337,336,339,-1,730,731,732,-1,731,733,732,-1,330,301,303,-1,330,304,301,-1,483,480,328,-1,480,164,328,-1,112,140,110,-1,633,688,369,-1,633,543,688,-1,734,324,735,-1,324,326,735,-1,736,323,322,-1,737,319,132,-1,132,123,737,-1,319,318,132,-1,121,133,144,-1,144,293,121,-1,128,509,506,-1,129,507,131,-1,564,315,314,-1,564,118,315,-1,518,124,738,-1,518,310,124,-1,121,123,132,-1,136,135,739,-1,739,148,136,-1,146,145,309,-1,146,143,145,-1,635,740,636,-1,494,501,493,-1,494,502,501,-1,337,10,295,-1,337,670,10,-1,670,341,741,-1,670,337,341,-1,302,301,253,-1,347,484,545,-1,659,742,492,-1,284,99,98,-1,108,289,106,-1,557,286,285,-1,557,291,286,-1,628,106,289,-1,626,284,282,-1,626,288,284,-1,278,280,665,-1,743,275,744,-1,275,277,744,-1,745,746,747,-1,745,490,746,-1,95,274,627,-1,627,93,95,-1,748,749,750,-1,549,274,273,-1,272,700,80,-1,80,83,272,-1,398,73,751,-1,398,400,73,-1,266,271,267,-1,266,272,271,-1,752,753,265,-1,753,754,265,-1,90,751,73,-1,629,261,262,-1,259,280,279,-1,279,88,259,-1,88,279,755,-1,755,258,88,-1,258,747,669,-1,258,755,747,-1,648,513,756,-1,513,757,756,-1,758,759,760,-1,253,304,252,-1,367,252,304,-1,367,250,252,-1,57,397,248,-1,248,60,57,-1,575,574,761,-1,761,572,575,-1,239,238,762,-1,238,763,762,-1,522,764,117,-1,765,236,233,-1,765,521,236,-1,766,242,767,-1,768,769,770,-1,769,456,770,-1,771,772,773,-1,226,221,223,-1,443,604,605,-1,686,212,210,-1,213,211,210,-1,214,209,166,-1,209,208,166,-1,207,206,203,-1,436,204,774,-1,204,438,774,-1,170,774,173,-1,170,436,774,-1,637,775,708,-1,197,776,464,-1,197,196,776,-1,186,777,635,-1,186,185,777,-1,403,185,187,-1,403,719,185,-1,778,184,645,-1,184,183,645,-1,178,779,179,-1,650,156,780,-1,156,155,780,-1,133,124,145,-1,145,144,133,-1,138,154,164,-1,164,134,138,-1,152,153,150,-1,153,142,150,-1,143,739,676,-1,134,110,137,-1,110,140,137,-1,136,781,134,-1,781,110,134,-1,318,782,783,-1,155,132,318,-1,131,313,130,-1,738,124,126,-1,121,315,122,-1,119,323,120,-1,120,122,118,-1,122,315,118,-1,112,514,513,-1,114,514,115,-1,110,116,111,-1,106,105,108,-1,104,103,107,-1,276,97,101,-1,491,96,99,-1,100,96,491,-1,100,97,96,-1,93,91,95,-1,37,784,630,-1,37,35,784,-1,81,80,785,-1,785,786,81,-1,84,85,86,-1,83,84,271,-1,14,13,74,-1,76,408,77,-1,39,75,76,-1,76,78,39,-1,71,73,400,-1,68,13,69,-1,399,66,71,-1,71,400,399,-1,66,399,548,-1,548,67,66,-1,27,475,486,-1,668,787,666,-1,788,61,249,-1,61,60,249,-1,54,789,55,-1,789,698,55,-1,94,261,630,-1,787,790,666,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_4()
		{
			int[] value = {791,45,677,-1,45,44,677,-1,792,678,398,-1,793,416,702,-1,704,415,414,-1,794,795,796,-1,786,785,31,-1,37,34,33,-1,753,785,754,-1,40,406,420,-1,670,11,10,-1,797,6,16,-1,619,485,553,-1,470,324,734,-1,734,471,470,-1,681,734,798,-1,734,681,471,-1,799,800,801,-1,799,802,800,-1,802,468,800,-1,802,803,468,-1,24,804,706,-1,804,24,22,-1,794,805,795,-1,794,806,805,-1,807,808,809,-1,807,43,808,-1,810,806,418,-1,806,810,805,-1,810,13,811,-1,810,69,13,-1,474,424,421,-1,474,411,424,-1,812,699,743,-1,813,699,812,-1,789,697,698,-1,789,814,697,-1,791,423,815,-1,677,423,791,-1,816,817,410,-1,818,817,816,-1,475,267,486,-1,475,269,267,-1,260,786,31,-1,260,81,786,-1,751,35,36,-1,751,784,35,-1,113,111,116,-1,115,111,113,-1,122,323,123,-1,122,120,323,-1,738,127,312,-1,126,127,738,-1,136,147,781,-1,147,136,148,-1,133,157,124,-1,133,158,157,-1,442,171,819,-1,607,171,442,-1,820,449,452,-1,449,820,174,-1,820,821,819,-1,684,821,820,-1,822,179,779,-1,179,822,690,-1,178,823,779,-1,178,824,823,-1,192,825,826,-1,825,192,191,-1,827,766,828,-1,766,827,829,-1,830,464,776,-1,464,830,767,-1,831,708,775,-1,831,709,708,-1,455,201,200,-1,455,832,201,-1,436,205,204,-1,169,205,436,-1,833,214,692,-1,833,209,214,-1,718,707,715,-1,707,718,385,-1,404,383,305,-1,386,383,404,-1,225,604,443,-1,225,834,604,-1,835,222,224,-1,600,222,835,-1,836,535,837,-1,535,836,539,-1,838,542,839,-1,838,536,542,-1,840,641,841,-1,639,641,840,-1,842,843,844,-1,842,845,843,-1,846,847,848,-1,357,847,846,-1,849,598,850,-1,849,851,598,-1,638,596,852,-1,638,594,596,-1,853,640,854,-1,640,853,855,-1,541,856,857,-1,541,540,856,-1,858,772,859,-1,772,858,773,-1,522,860,764,-1,522,523,860,-1,521,861,520,-1,861,521,765,-1,523,862,860,-1,862,523,863,-1,570,864,865,-1,866,864,570,-1,572,612,575,-1,571,612,572,-1,528,519,526,-1,519,528,517,-1,724,867,647,-1,867,724,868,-1,613,465,467,-1,613,573,465,-1,193,465,191,-1,466,465,193,-1,869,870,871,-1,869,872,870,-1,338,493,501,-1,338,729,493,-1,332,873,329,-1,874,873,332,-1,335,497,499,-1,497,335,875,-1,876,877,654,-1,876,878,877,-1,730,655,731,-1,651,655,730,-1,304,879,367,-1,330,879,304,-1,501,336,338,-1,880,336,501,-1,101,4,6,-1,4,101,495,-1,366,881,657,-1,881,366,882,-1,648,496,883,-1,648,756,496,-1,884,512,498,-1,884,511,512,-1,502,505,504,-1,494,505,502,-1,885,489,886,-1,489,885,660,-1,760,887,888,-1,887,760,759,-1,515,757,513,-1,515,889,757,-1,653,649,656,-1,653,317,649,-1,316,500,508,-1,316,890,500,-1,87,669,86,-1,258,669,87,-1,748,629,262,-1,427,629,748,-1,265,47,752,-1,47,265,51,-1,785,792,36,-1,753,792,785,-1,36,398,751,-1,792,398,36,-1,106,549,273,-1,628,549,106,-1,891,748,262,-1,748,891,749,-1,627,262,93,-1,891,262,627,-1,755,745,747,-1,693,745,755,-1,743,694,812,-1,744,694,743,-1,628,288,626,-1,628,289,288,-1,282,625,626,-1,625,282,892,-1,674,742,659,-1,742,674,673,-1,341,893,741,-1,341,340,893,-1,732,469,679,-1,732,733,469,-1,894,680,895,-1,894,334,680,-1,333,472,473,-1,333,331,472,-1,402,186,636,-1,186,402,187,-1,739,146,148,-1,739,143,146,-1,118,617,119,-1,118,564,617,-1,129,506,507,-1,128,506,129,-1,125,509,128,-1,125,510,509,-1,780,318,783,-1,780,155,318,-1,323,737,123,-1,323,736,737,-1,543,325,688,-1,543,544,325,-1,512,141,883,-1,512,159,141,-1,878,894,297,-1,878,875,894,-1,733,877,299,-1,731,877,733,-1,730,340,339,-1,730,732,340,-1,568,546,896,-1,568,727,546,-1,567,294,728,-1,567,726,294,-1,897,231,617,-1,897,232,231,-1,801,298,895,-1,801,800,298,-1,634,898,644,-1,898,634,168,-1,763,899,900,-1,763,238,899,-1,487,374,559,-1,374,487,375,-1,503,723,131,-1,503,662,723,-1,664,901,722,-1,664,902,901,-1,580,586,578,-1,384,586,580,-1,306,718,717,-1,383,718,306,-1,403,390,719,-1,403,388,390,-1,831,714,713,-1,831,720,714,-1,714,716,712,-1,717,716,714,-1,750,903,34,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_5()
		{
			int[] value = {750,904,903,-1,55,696,711,-1,55,698,696,-1,62,665,30,-1,62,905,665,-1,710,831,775,-1,710,720,831,-1,906,38,40,-1,809,38,906,-1,416,807,414,-1,793,807,416,-1,796,42,907,-1,42,796,795,-1,811,805,810,-1,811,413,805,-1,701,410,409,-1,816,410,701,-1,418,908,419,-1,806,908,418,-1,706,909,704,-1,706,804,909,-1,910,911,912,-1,910,913,911,-1,914,416,415,-1,416,914,703,-1,915,42,41,-1,42,915,907,-1,908,912,909,-1,908,910,912,-1,706,420,24,-1,420,706,705,-1,64,417,65,-1,64,412,417,-1,22,65,417,-1,547,65,22,-1,74,70,409,-1,74,13,70,-1,410,424,411,-1,424,410,817,-1,49,916,426,-1,916,49,425,-1,678,753,752,-1,753,678,792,-1,917,53,918,-1,917,52,53,-1,754,264,265,-1,700,264,754,-1,745,277,490,-1,745,744,277,-1,797,25,746,-1,25,797,16,-1,278,695,281,-1,278,696,695,-1,56,711,919,-1,56,55,711,-1,814,892,813,-1,814,788,892,-1,405,169,168,-1,169,405,205,-1,833,606,609,-1,606,833,692,-1,226,920,221,-1,691,920,226,-1,219,921,682,-1,922,921,219,-1,923,218,924,-1,923,925,218,-1,609,686,833,-1,686,609,685,-1,687,707,212,-1,687,926,707,-1,716,927,928,-1,927,716,715,-1,453,200,712,-1,455,200,453,-1,821,444,441,-1,444,821,176,-1,684,452,446,-1,452,684,820,-1,358,846,683,-1,846,358,357,-1,929,538,930,-1,931,538,929,-1,537,533,532,-1,537,932,533,-1,188,933,189,-1,188,934,933,-1,769,929,832,-1,769,935,929,-1,228,771,773,-1,227,771,228,-1,936,772,771,-1,937,772,936,-1,462,458,460,-1,462,459,458,-1,456,938,770,-1,938,456,454,-1,939,940,941,-1,935,940,939,-1,242,829,864,-1,242,766,829,-1,681,895,680,-1,895,681,801,-1,679,3,893,-1,2,3,679,-1,29,942,63,-1,32,942,29,-1,61,814,789,-1,61,788,814,-1,45,918,46,-1,45,917,918,-1,646,237,239,-1,370,237,646,-1,143,675,943,-1,143,676,675,-1,58,789,54,-1,58,61,789,-1,292,674,659,-1,674,292,944,-1,670,551,554,-1,741,551,670,-1,267,84,486,-1,84,267,271,-1,266,408,407,-1,77,408,266,-1,791,917,45,-1,791,945,917,-1,946,790,945,-1,946,666,790,-1,668,50,787,-1,48,50,668,-1,695,812,694,-1,695,697,812,-1,947,664,621,-1,947,902,664,-1,948,901,949,-1,901,948,722,-1,372,379,373,-1,723,379,372,-1,887,661,660,-1,661,887,949,-1,758,948,759,-1,950,948,758,-1,888,673,760,-1,673,888,742,-1,813,282,699,-1,892,282,813,-1,257,100,886,-1,100,257,101,-1,367,889,366,-1,367,879,889,-1,874,757,873,-1,757,874,756,-1,884,654,656,-1,884,876,654,-1,656,651,653,-1,656,655,651,-1,890,652,880,-1,653,652,890,-1,182,882,951,-1,882,182,881,-1,146,236,521,-1,146,309,236,-1,951,183,182,-1,951,643,183,-1,524,644,643,-1,644,524,634,-1,764,530,117,-1,531,530,764,-1,777,860,862,-1,952,860,777,-1,861,740,635,-1,861,765,740,-1,235,953,233,-1,953,235,642,-1,954,192,869,-1,193,192,954,-1,869,826,872,-1,869,192,826,-1,872,827,955,-1,872,826,827,-1,956,527,526,-1,956,955,527,-1,525,776,642,-1,525,830,776,-1,740,196,195,-1,740,953,196,-1,585,775,194,-1,585,710,775,-1,195,636,740,-1,195,198,636,-1,185,952,777,-1,185,957,952,-1,168,822,898,-1,168,170,822,-1,774,189,449,-1,189,774,438,-1,832,930,201,-1,832,929,930,-1,958,959,960,-1,959,958,934,-1,933,961,450,-1,933,962,961,-1,939,837,931,-1,939,229,837,-1,932,840,960,-1,932,838,840,-1,842,958,841,-1,958,842,962,-1,847,961,844,-1,961,847,534,-1,640,839,854,-1,839,640,639,-1,849,845,852,-1,845,849,843,-1,835,848,850,-1,848,835,846,-1,0,963,321,-1,0,803,963,-1,631,798,632,-1,631,799,798,-1,154,326,328,-1,154,735,326,-1,327,688,325,-1,327,365,688,-1,149,631,152,-1,964,631,149,-1,321,782,318,-1,963,782,321,-1,965,668,667,-1,965,966,668,-1,95,263,26,-1,92,263,95,-1,891,550,476,-1,627,550,891,-1,477,750,749,-1,750,477,396,-1,625,476,550,-1,249,476,625,-1,944,671,674,-1,671,944,967,-1,287,109,102,-1,286,109,287,-1,560,285,287,-1,560,620,285,-1,624,290,557,-1,624,968,290,-1,969,967,944,-1,969,970,967,-1,621,968,947,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_6()
		{
			int[] value = {621,623,968,-1,374,624,620,-1,374,376,624,-1,556,563,372,-1,556,555,563,-1,618,619,553,-1,563,619,618,-1,736,562,737,-1,618,562,736,-1,675,546,727,-1,546,675,478,-1,293,728,294,-1,943,728,293,-1,617,516,119,-1,617,231,516,-1,897,971,574,-1,897,356,971,-1,353,577,576,-1,353,726,577,-1,972,350,973,-1,972,896,350,-1,346,974,349,-1,974,346,616,-1,611,345,975,-1,615,345,611,-1,584,343,342,-1,584,581,343,-1,571,976,612,-1,976,571,977,-1,243,761,978,-1,243,866,761,-1,978,240,243,-1,978,579,240,-1,973,216,972,-1,216,973,587,-1,588,616,589,-1,588,974,616,-1,615,593,590,-1,615,611,593,-1,979,461,980,-1,462,461,979,-1,928,981,979,-1,981,928,982,-1,983,927,926,-1,984,927,983,-1,985,687,685,-1,986,687,985,-1,608,597,985,-1,608,595,597,-1,987,983,986,-1,987,988,983,-1,984,989,982,-1,984,990,989,-1,981,937,459,-1,981,991,937,-1,857,989,990,-1,856,989,857,-1,988,855,853,-1,988,987,855,-1,610,595,608,-1,992,595,610,-1,437,208,591,-1,208,437,166,-1,603,606,440,-1,610,606,603,-1,180,690,592,-1,690,180,179,-1,992,603,601,-1,992,610,603,-1,604,599,602,-1,599,604,834,-1,601,851,992,-1,601,598,851,-1,603,439,602,-1,603,440,439,-1,992,596,595,-1,851,596,992,-1,855,597,594,-1,987,597,855,-1,990,853,857,-1,990,988,853,-1,991,856,859,-1,991,989,856,-1,982,991,981,-1,982,989,991,-1,988,984,983,-1,988,990,984,-1,986,597,987,-1,985,597,986,-1,608,685,609,-1,985,685,608,-1,986,926,687,-1,983,926,986,-1,982,927,984,-1,982,928,927,-1,979,459,462,-1,459,979,981,-1,404,394,213,-1,394,404,217,-1,578,240,579,-1,240,578,586,-1,615,589,616,-1,589,615,590,-1,587,974,588,-1,973,974,587,-1,972,382,569,-1,382,972,216,-1,579,971,576,-1,978,971,579,-1,978,574,971,-1,761,574,978,-1,572,866,570,-1,572,761,866,-1,900,612,976,-1,900,899,612,-1,581,975,343,-1,975,581,611,-1,349,973,350,-1,973,349,974,-1,896,569,568,-1,569,896,972,-1,577,567,566,-1,577,726,567,-1,576,356,353,-1,971,356,576,-1,574,232,897,-1,565,232,574,-1,899,565,612,-1,899,230,565,-1,314,294,355,-1,121,294,314,-1,943,727,728,-1,675,727,943,-1,119,372,563,-1,372,119,516,-1,618,322,563,-1,618,736,322,-1,320,737,562,-1,319,737,320,-1,624,947,968,-1,947,624,376,-1,290,623,969,-1,290,968,623,-1,558,556,561,-1,482,556,558,-1,102,558,287,-1,102,104,558,-1,109,291,108,-1,109,286,291,-1,290,944,292,-1,969,944,290,-1,485,555,482,-1,485,619,555,-1,248,396,477,-1,248,397,396,-1,476,749,891,-1,476,477,749,-1,104,481,8,-1,104,107,481,-1,993,425,966,-1,425,993,916,-1,993,994,818,-1,993,995,994,-1,424,996,422,-1,996,424,817,-1,270,21,18,-1,270,547,21,-1,963,149,782,-1,963,964,149,-1,352,480,351,-1,352,479,480,-1,328,325,544,-1,328,326,325,-1,632,734,735,-1,632,798,734,-1,802,631,964,-1,802,799,631,-1,964,803,802,-1,964,963,803,-1,843,850,848,-1,843,849,850,-1,852,641,638,-1,641,852,845,-1,541,839,542,-1,541,854,839,-1,540,836,858,-1,836,540,539,-1,534,357,359,-1,534,847,357,-1,962,844,961,-1,962,842,844,-1,841,960,840,-1,960,841,958,-1,537,838,932,-1,537,536,838,-1,535,931,837,-1,931,535,538,-1,220,359,445,-1,220,447,359,-1,451,961,534,-1,450,961,451,-1,962,934,958,-1,934,962,933,-1,392,959,391,-1,392,533,959,-1,532,201,930,-1,532,199,201,-1,532,389,199,-1,931,935,939,-1,935,931,929,-1,779,898,822,-1,898,779,823,-1,957,531,952,-1,957,529,531,-1,642,196,953,-1,642,776,196,-1,527,830,525,-1,830,527,828,-1,955,828,527,-1,827,828,955,-1,870,955,956,-1,870,872,955,-1,867,870,246,-1,867,871,870,-1,868,871,867,-1,868,997,871,-1,765,953,740,-1,765,233,953,-1,635,862,861,-1,777,862,635,-1,952,764,860,-1,531,764,952,-1,530,524,117,-1,634,524,530,-1,643,114,524,-1,114,643,951,-1,781,520,863,-1,781,147,520,-1,236,310,234,-1,310,236,309,-1,518,234,310,-1,518,517,234,-1,519,247,244,-1,247,519,311,-1,516,723,372,-1,131,723,516,-1,951,515,114,-1,515,951,882,-1,506,508,504,-1,506,509,508,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_7()
		{
			int[] value = {254,503,505,-1,254,662,503,-1,161,142,139,-1,161,150,142,-1,500,880,501,-1,890,880,500,-1,497,884,498,-1,497,876,884,-1,496,874,499,-1,756,874,496,-1,889,873,757,-1,889,879,873,-1,492,886,100,-1,492,885,886,-1,742,885,492,-1,742,888,885,-1,760,672,758,-1,672,760,673,-1,949,759,948,-1,949,887,759,-1,721,948,950,-1,948,721,722,-1,949,488,661,-1,488,949,901,-1,487,379,380,-1,373,379,487,-1,815,945,791,-1,815,946,945,-1,407,46,918,-1,407,79,46,-1,228,858,836,-1,773,858,228,-1,561,287,558,-1,561,560,287,-1,156,649,317,-1,650,649,156,-1,292,99,108,-1,99,292,659,-1,144,943,293,-1,144,143,943,-1,153,735,154,-1,735,153,632,-1,846,224,683,-1,224,846,835,-1,239,725,646,-1,762,725,239,-1,406,77,268,-1,78,77,406,-1,268,23,406,-1,268,20,23,-1,741,3,551,-1,741,893,3,-1,296,800,468,-1,800,296,298,-1,191,865,825,-1,465,865,191,-1,241,767,242,-1,241,464,767,-1,864,825,865,-1,825,864,829,-1,358,221,924,-1,358,683,221,-1,682,220,219,-1,220,682,448,-1,941,229,939,-1,227,229,941,-1,935,768,940,-1,935,769,768,-1,461,938,454,-1,460,938,461,-1,937,457,459,-1,937,936,457,-1,937,859,772,-1,859,937,991,-1,461,453,980,-1,461,454,453,-1,959,188,391,-1,188,959,934,-1,450,189,933,-1,449,189,450,-1,533,960,959,-1,932,960,533,-1,930,537,532,-1,538,537,930,-1,980,712,716,-1,980,453,712,-1,218,358,924,-1,358,218,445,-1,605,441,444,-1,605,439,441,-1,441,819,821,-1,441,442,819,-1,637,402,636,-1,637,708,402,-1,529,202,405,-1,529,207,202,-1,928,980,716,-1,928,979,980,-1,926,715,707,-1,926,927,715,-1,218,922,219,-1,925,922,218,-1,433,682,921,-1,433,175,682,-1,924,920,923,-1,920,924,221,-1,970,623,622,-1,970,969,623,-1,905,711,665,-1,919,711,905,-1,693,744,745,-1,694,744,693,-1,669,746,25,-1,669,747,746,-1,427,750,34,-1,427,748,750,-1,945,52,917,-1,945,790,52,-1,264,918,53,-1,918,264,407,-1,966,48,668,-1,966,425,48,-1,427,630,629,-1,427,37,630,-1,916,818,816,-1,818,916,993,-1,44,421,677,-1,44,474,421,-1,816,426,916,-1,426,816,701,-1,966,995,993,-1,965,995,966,-1,417,804,22,-1,417,419,804,-1,811,12,808,-1,13,12,811,-1,794,913,910,-1,794,796,913,-1,704,912,415,-1,704,909,912,-1,413,808,43,-1,413,811,808,-1,702,41,793,-1,702,915,41,-1,415,911,914,-1,415,912,911,-1,909,419,908,-1,909,804,419,-1,704,906,705,-1,414,906,704,-1,910,806,794,-1,908,806,910,-1,43,793,41,-1,807,793,43,-1,418,69,810,-1,69,418,412,-1,795,413,42,-1,413,795,805,-1,414,809,906,-1,807,809,414,-1,719,957,185,-1,206,957,719,-1,207,957,206,-1,957,207,529,-1,903,32,34,-1,903,942,32,-1,396,904,750,-1,396,395,904,-1,395,57,59,-1,57,395,397,-1,391,190,206,-1,391,188,190,-1,392,388,389,-1,388,392,390,-1,215,308,381,-1,215,305,308,-1,587,217,216,-1,217,587,394,-1,488,902,375,-1,902,488,901,-1,376,902,947,-1,376,375,902,-1,230,238,237,-1,230,899,238,-1,370,516,237,-1,370,131,516,-1,363,302,253,-1,363,361,302,-1,327,470,364,-1,324,470,327,-1,658,250,366,-1,658,251,250,-1,633,368,342,-1,369,368,633,-1,823,644,898,-1,823,645,644,-1,975,347,545,-1,975,345,347,-1,356,617,354,-1,356,897,617,-1,896,352,350,-1,896,546,352,-1,349,348,346,-1,349,351,348,-1,343,545,344,-1,343,975,545,-1,878,299,877,-1,878,297,299,-1,334,875,335,-1,875,334,894,-1,331,332,329,-1,332,331,333,-1,780,151,162,-1,780,783,151,-1,510,124,157,-1,124,510,125,-1,311,738,312,-1,518,738,311,-1,331,300,472,-1,331,303,300,-1,473,334,333,-1,680,334,473,-1,895,297,894,-1,298,297,895,-1,469,299,296,-1,469,733,299,-1,732,893,340,-1,893,732,679,-1,99,288,108,-1,99,284,288,-1,279,693,755,-1,281,693,279,-1,746,428,797,-1,490,428,746,-1,31,32,29,-1,31,33,32,-1,18,73,270,-1,18,17,73,-1,267,268,77,-1,268,267,269,-1,49,752,47,-1,752,49,678,-1,754,80,700,-1,785,80,754,-1,508,502,504,-1,508,500,502,-1,890,317,653,-1,890,316,317,-1,882,889,515,-1,366,889,882,-1};
			return value;
		}
		private int[] getlcoscart_Geo_6_105_coordIndex_8()
		{
			int[] value = {888,660,885,-1,660,888,887,-1,886,256,257,-1,256,886,489,-1,255,505,494,-1,255,254,505,-1,656,511,884,-1,656,649,511,-1,498,883,496,-1,883,498,512,-1,101,797,428,-1,6,797,101,-1,493,4,495,-1,729,4,493,-1,652,336,880,-1,336,652,339,-1,339,651,730,-1,652,651,339,-1,731,654,877,-1,655,654,731,-1,876,875,878,-1,876,497,875,-1,332,499,874,-1,499,332,335,-1,330,873,879,-1,873,330,329,-1,871,954,869,-1,954,871,997,-1,865,573,570,-1,865,465,573,-1,246,956,244,-1,246,870,956,-1,647,246,245,-1,246,647,867,-1,244,526,519,-1,244,956,526,-1,517,235,234,-1,517,528,235,-1,242,866,243,-1,242,864,866,-1,241,586,463,-1,586,241,240,-1,862,520,861,-1,862,863,520,-1,540,859,856,-1,540,858,859,-1,857,854,541,-1,854,857,853,-1,594,640,855,-1,638,640,594,-1,852,851,849,-1,852,596,851,-1,600,850,598,-1,835,850,600,-1,844,848,847,-1,844,843,848,-1,841,845,842,-1,841,641,845,-1,839,840,838,-1,840,839,639,-1,539,536,535,-1,536,539,542,-1,837,228,836,-1,228,837,229,-1,599,222,600,-1,222,599,834,-1,225,222,834,-1,225,223,222,-1,605,431,443,-1,605,444,431,-1,305,217,404,-1,305,215,217,-1,383,385,718,-1,385,383,386,-1,692,165,607,-1,165,692,214,-1,210,833,686,-1,210,209,833,-1,190,204,203,-1,204,190,438,-1,456,832,455,-1,832,456,769,-1,709,713,387,-1,709,831,713,-1,637,194,775,-1,637,198,194,-1,828,767,830,-1,767,828,766,-1,826,829,827,-1,829,826,825,-1,199,713,200,-1,199,387,713,-1,573,977,571,-1,614,977,573,-1,778,823,824,-1,778,645,823,-1,170,172,689,-1,170,173,172,-1,170,690,822,-1,170,689,690,-1,176,684,177,-1,176,821,684,-1,172,607,165,-1,172,171,607,-1,819,174,820,-1,171,174,819,-1,174,774,449,-1,174,173,774,-1,689,165,167,-1,172,165,689,-1,159,139,141,-1,161,139,159,-1,650,162,160,-1,650,780,162,-1,163,739,135,-1,163,676,739,-1,783,149,151,-1,782,149,783,-1,883,140,648,-1,140,883,141,-1,110,863,523,-1,863,110,781,-1,313,127,130,-1,127,313,312,-1,127,125,128,-1,125,127,126,-1,115,112,111,-1,115,514,112,-1,102,105,103,-1,109,105,102,-1,90,784,751,-1,784,90,89,-1,94,784,89,-1,630,784,94,-1,88,81,260,-1,81,88,82,-1,75,408,76,-1,79,408,75,-1,68,548,70,-1,548,68,67,-1,818,996,817,-1,994,996,818,-1,892,249,625,-1,892,788,249,-1,697,813,812,-1,697,814,813,-1,283,743,699,-1,283,275,743,-1,790,50,52,-1,787,50,790,-1,705,40,420,-1,705,906,40,-1,809,12,38,-1,809,808,12,-1,36,31,785,-1,33,31,36,-1,475,17,19,-1,17,475,263,-1,28,16,15,-1,16,28,25,-1,20,21,23,-1,18,21,20,-1,26,475,27,-1,26,263,475,-1,75,12,14,-1,39,12,75,-1,551,1,552,-1,1,551,3,-1,2,803,0,-1,803,2,468,-1,801,798,799,-1,798,801,681,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlcoscart_Coord_7_105_point_1()
		{
			double[] value = {1.23293,43.48305,2.92422,1.3377,43.40406,2.9058,1.20018,43.45979,2.9535,1.3152,43.38271,2.94657,1.76798,43.08531,2.95116,1.73247,43.07243,2.94164,1.90086,42.85852,2.87532,1.88539,42.84352,2.83914,1.89478,42.84623,2.82228,1.73479,43.06784,2.92006,1.63993,43.17079,2.9492,1.64221,43.1521,2.92754,3.75245,41.79427,1.67163,3.75904,41.82945,1.64226,3.75952,41.80883,1.67756,2.01962,42.65556,2.68885,2.02431,42.637,2.7174,2.99662,41.95478,1.84392,3.10325,41.88529,1.74469,2.98959,41.93031,1.87924,3.09703,41.85054,1.76798,3.21489,41.82859,1.64466,3.34423,41.77543,1.54418,3.21403,41.79862,1.65968,3.33396,41.75185,1.55833,2.27657,42.45164,2.47764,2.58901,42.31461,2.23572,2.57777,42.30438,2.2675,2.27382,42.46405,2.44793,3.85088,42.38739,1.9433,3.87132,42.4269,2.0215,3.65072,42.3006,1.93055,3.81075,42.37711,1.9093,3.65165,42.31029,1.90413,3.6963,42.4171,1.92702,3.60497,42.28501,1.89923,3.63266,42.28437,1.88385,3.60924,42.30935,1.91677,3.60956,41.73197,1.68564,3.56677,41.77577,1.7568,3.46711,41.70527,1.69026,4.45266,41.76071,1.30702,4.45186,41.80968,1.33212,4.19351,41.71539,1.45775,4.05252,41.89907,1.62834,4.08081,41.92617,1.65756,3.81124,41.81628,1.71198,3.91417,42.13543,1.71791,4.08573,42.15176,1.66665,3.89484,42.15004,1.68387,4.10498,42.11321,1.69865,3.91503,42.11488,1.76091,4.11191,42.0786,1.70949,3.90716,42.08568,1.78359,3.60312,42.82146,2.18543,3.63165,42.81332,2.20762,3.73098,42.88233,2.13445,3.54366,42.79574,2.1119,3.54991,42.81858,2.13309,3.66277,42.86414,2.06132,3.4099,42.75558,2.15716,3.42365,42.76081,2.18794,3.94663,42.52508,1.97545,3.97351,42.49832,1.91619,3.59178,41.90222,1.57809,3.39842,41.87755,1.61758,3.40937,41.89141,1.62401,3.60819,41.91519,1.59221,3.71306,41.86291,1.58468,3.71523,41.85673,1.56542,3.74025,41.87474,1.59665,3.26028,41.97121,1.71398,3.24586,41.96017,1.70668,3.11251,42.03796,1.82681,3.81669,41.80783,1.68502,3.5729,41.797,1.76638,3.37355,41.83534,1.8173,3.21754,41.93264,2.00355,3.36611,41.8218,1.80409,3.57972,41.81573,1.78079,3.56497,42.27318,1.95202,3.5594,42.29058,1.96255,3.23844,42.25065,2.1252,3.24735,42.22973,2.13099,2.87558,42.26706,2.20867,2.89372,42.27209,2.22525,2.60427,42.33118,2.33503,2.92462,42.29563,2.22654,3.24077,42.26092,2.14742,3.22507,42.16165,1.99669,3.2158,42.1427,1.98344,2.85879,42.26026,2.10392,2.82822,42.2454,2.10457,2.87391,42.27261,2.10672,3.23283,42.17652,2.01074,2.6437,42.35097,2.23493,2.565,42.70171,2.52462,2.1701,42.76677,2.70454,2.55766,42.69247,2.52861,2.84067,42.75901,2.34243};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_2()
		{
			double[] value = {2.18735,42.78493,2.70764,1.92275,42.88087,2.87724,2.17608,42.83393,2.69568,2.15966,42.81763,2.71168,1.97448,42.89251,2.81904,2.50439,42.70586,2.43091,2.50713,42.69457,2.42558,2.14264,42.79977,2.70589,2.8034,42.75794,2.28363,2.50981,42.72581,2.42244,1.02581,44.24381,3.01129,.91048,44.41451,3.06441,.89232,44.39945,3.07753,.89201,44.46611,3.07356,.75071,44.58341,3.08299,.87312,44.45349,3.06911,.93046,44.42887,3.07076,1.00195,44.53874,3.09846,1.76606,43.56152,2.79491,1.92071,43.42488,2.66287,1.76087,43.55286,2.79912,1.54383,43.7062,2.95303,1.60579,43.66138,2.91342,1.59201,43.64885,2.91716,1.57089,43.71264,2.99805,1.71506,43.632,2.95634,1.72159,43.65403,2.95018,1.79762,43.6213,2.93759,1.79228,43.59921,2.94154,1.95053,43.53788,2.85351,1.94299,43.56605,2.86095,2.09727,43.45886,2.73304,1.49106,43.65526,2.97239,1.55589,43.70549,2.98598,1.02869,44.21013,2.9966,1.1427,44.14485,3.00671,1.14011,44.16091,3.03377,1.00388,44.19697,3.01291,.9928,44.18507,3.00071,1.07041,44.1003,3.03848,.99619,44.21753,3.02119,1.07058,44.10478,3.06642,1.06067,44.00603,2.96274,1.36559,43.89467,3.00566,1.47958,43.78309,2.98621,1.47941,43.80219,3.01137,1.39005,43.92349,3.05167,1.27695,44.04838,3.05298,1.27172,44.03665,3.04079,1.16998,43.74337,2.95586,1.11146,43.86467,2.98238,1.18539,43.76047,2.97842,1.08999,43.85106,2.96351,1.03628,43.99574,2.94933,.97483,44.17901,2.98701,1.42308,43.66743,3.02499,1.40836,43.66116,3.04852,1.51649,43.63848,3.02479,1.51031,43.64583,3.00478,1.13286,43.91643,3.05648,1.2065,43.80126,3.07578,1.13171,43.91261,3.02812,1.21052,43.79918,3.04987,1.14752,44.141,2.97838,1.03313,44.21053,2.97589,1.12189,44.96552,2.82991,1.1664,44.9202,2.82334,1.10591,44.95025,2.84096,1.07103,44.92159,3.01626,1.1034,44.94885,2.98305,1.1046,44.96808,2.90088,1.11938,44.98426,2.86978,1.11772,44.974,2.87063,1.11226,44.97649,2.90526,1.11851,44.98966,2.91505,.72614,45.24047,2.79271,.80699,45.19038,2.78198,.7927,45.20561,2.8225,.72068,45.21064,2.79709,.85032,45.09478,2.83245,.8531,45.04606,2.79117,.69064,45.13353,2.73885,.46275,44.72595,3.0554,.59844,44.83213,3.01957,.53357,44.88574,3.01207,1.43394,44.55972,3.0341,1.55749,44.41595,3.05244,1.59679,44.49189,3.0517,1.33123,44.88263,3.0237,1.25995,44.91238,3.02614,1.31011,44.83314,2.99583,2.45266,44.01707,2.69167,2.45821,43.98702,2.69592,2.72072,44.10369,2.58419,1.71556,44.28324,3.01551,1.70421,44.24889,3.05081,1.76338,44.12539,3.0518,1.80059,44.14598,3.00892,1.69735,44.28504,3.0468,1.77898,44.70053,2.96839};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_3()
		{
			double[] value = {1.80093,44.68138,2.93999,1.81752,44.71953,2.95629,1.27046,44.82036,2.99341,1.30145,44.81296,2.98432,1.23407,44.8816,2.9887,1.22092,44.8706,2.99261,1.38137,44.76086,2.98063,1.28877,44.79403,2.98728,1.23742,44.85391,2.85132,1.24238,44.86632,2.86276,1.32414,44.79542,2.91169,1.32408,44.77797,2.89777,1.42247,44.7444,2.90644,1.42105,44.66564,2.90236,1.17221,44.92647,2.82978,1.51886,44.49421,2.9032,1.46404,44.46141,2.89825,1.48804,44.52267,2.9003,.65158,45.49329,2.88587,.6855,45.3191,2.87477,.75756,45.28719,2.92005,.79637,45.67483,2.69107,.90502,45.53033,2.67369,.79714,45.57003,2.64834,.89202,45.57639,2.72112,.79069,45.53484,2.64079,.68926,45.61124,2.62138,2.29114,45.22488,2.55504,2.11916,45.11758,2.65674,2.13107,45.09895,2.6855,2.27214,43.59408,2.57663,2.13105,43.5125,2.57539,2.17762,43.60172,2.58697,1.58676,43.93552,3.07782,1.656,43.81873,3.03031,1.69935,43.8706,3.04633,1.5429,43.88557,3.04495,2.22319,43.51497,2.60189,2.56459,43.66139,2.46551,2.55051,43.61,2.50703,1.93569,44.08151,2.89402,1.94234,44.08959,2.93489,2.05956,44.06146,2.88817,2.05726,44.06171,2.85674,1.99218,43.72859,2.91458,2.20399,43.61641,2.73261,2.20492,43.71806,2.80701,1.9475,43.61333,2.87552,3.4118,42.71996,2.13012,3.28841,42.70593,2.20191,.33968,44.47368,3.09785,.26384,44.4799,3.10372,.31271,44.45126,3.09284,.25518,44.40391,3.08189,1.96223,43.17945,2.88398,1.86502,43.12419,2.9293,2.12492,43.09236,2.89305,2.02153,42.98081,2.89699,2.94591,42.31189,2.2274,3.57012,42.32845,2.05195,3.57285,42.30127,1.97631,3.24412,42.19641,2.02745,3.27294,42.33523,2.02857,2.79637,42.21316,2.1034,3.55171,42.11698,1.91693,3.71157,42.13286,1.80789,3.32208,41.99548,2.04959,3.08844,42.07518,2.11557,3.09985,41.88516,1.9087,2.96422,42.01104,2.00528,3.22887,41.93698,1.69724,3.17314,42.16954,2.13745,3.40332,42.14277,2.06577,2.35017,42.54586,2.43742,2.66975,42.36852,2.24236,2.52407,42.65982,2.55092,2.15502,42.74985,2.71458,2.49393,42.63153,2.55548,3.57498,42.50459,2.2604,3.25759,42.33572,2.30774,3.58146,42.44777,2.22532,3.27152,42.45491,2.34758,2.89327,42.63846,2.32019,2.54297,42.67402,2.53655,2.84096,42.6845,2.34723,2.56705,42.84915,2.41682,2.52355,42.77653,2.40103,2.21587,42.87366,2.65672,2.81084,42.68032,2.30481,2.77354,42.67999,2.30427,2.99208,42.93982,2.22335,2.77459,42.81099,2.27927,2.95916,42.84286,2.25923,1.49968,43.76156,2.93541,1.55288,43.77324,2.85759,1.64337,43.21025,2.97482,1.06166,43.5366,3.03833,.97867,43.63529,3.11051,.97075,43.62379,3.06854,1.07074,43.53966,3.08589};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_4()
		{
			double[] value = {.47563,44.25862,3.01586,.36232,44.37412,3.06009,.35741,44.34832,3.03025,.48235,44.27394,3.05936,.37605,44.41207,3.08414,1.56952,44.52573,2.9188,1.6561,44.54778,2.91917,1.68098,44.44235,2.94615,1.63859,44.40515,2.93054,1.49147,43.8271,3.03043,1.59143,43.74737,3.00706,1.80605,43.66166,2.94241,1.80624,43.63365,2.93804,1.94449,43.58179,2.86581,1.61795,43.68799,2.89443,1.60985,43.67024,2.9071,1.51253,43.56259,3.06278,1.40001,43.58871,3.07509,1.39047,43.6307,2.95672,1.47958,43.61285,2.93166,1.46433,43.53989,2.91011,1.33622,43.57821,2.90736,1.81628,43.45581,2.76104,1.75075,43.53621,2.80035,.67645,44.14727,3.00864,.73572,44.36305,2.9457,.83323,44.26641,2.96581,.58289,44.22402,2.97205,.91075,44.33504,2.94316,.61262,44.2031,3.13008,.46138,44.34102,3.10473,.58865,44.1711,3.08847,.75564,44.06518,3.1652,.71678,44.02292,3.10572,.79027,43.92153,3.14529,.83285,43.94883,3.18378,1.48118,43.34987,3.05544,1.45692,43.31682,3.03691,1.63897,43.26112,2.99353,1.3539,43.39738,3.06694,1.32813,43.3755,3.04221,1.35821,43.35619,3.04085,.47425,44.63706,2.85137,.68363,44.67742,2.82922,.60948,44.59941,2.87276,1.0121,44.60108,2.8197,1.10756,44.5035,2.81311,.96253,44.5405,2.84534,1.05605,44.45033,2.85485,1.15788,44.40588,2.83007,1.21151,44.3277,2.84268,1.10788,44.35877,2.85933,1.15417,44.25823,2.86741,1.71598,43.77499,2.80736,1.79469,43.61,2.75063,1.65362,43.70438,2.83271,1.86522,43.69317,2.74516,.98636,45.37717,2.90076,.84565,45.55844,2.83833,.94291,45.35341,2.95192,.35637,44.36102,2.9114,.36333,44.34007,2.99822,.30783,44.38887,2.93282,.27126,44.3779,3.01757,.51051,44.23622,2.97424,.47542,44.2935,2.9278,.43336,44.55266,3.11469,.39236,44.45372,3.09968,.35596,44.48518,2.86628,.44822,44.45347,2.9244,2.20615,43.51314,2.64101,2.23484,43.14497,2.63369,2.14108,43.3033,2.60284,2.26891,43.20675,2.67937,2.64755,43.16187,2.50742,2.67593,43.23744,2.59019,2.71169,43.18399,2.48992,2.21954,43.20134,2.86662,2.47913,43.14625,2.78676,2.25105,43.2388,2.80869,2.48252,43.20222,2.75557,1.60632,44.36966,2.91646,1.56816,44.34117,2.89789,1.59647,44.58289,2.92706,1.71199,44.2484,2.93303,1.54099,44.64519,2.90624,1.52103,44.61807,2.91685,1.7195,44.63922,2.9893,1.65275,44.63482,3.00077,1.70523,44.71515,2.99436,1.52263,44.6908,3.00702,1.41932,44.82302,3.02217,1.56269,44.75979,3.00455,1.32391,44.72643,2.85618,1.4194,44.58666,2.89327,3.66615,42.76371,2.01281,3.56139,42.70775,2.06305,3.55103,42.74091,2.08123,3.5665,42.15236,1.74844,3.42223,41.91374,1.64057};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_5()
		{
			double[] value = {3.2862,41.98805,1.71814,3.68245,42.04733,1.70383,1.62328,44.48109,3.05432,1.63359,44.56504,3.02418,1.50262,44.58828,2.91187,1.21182,44.83892,3.01856,3.25993,41.79292,1.74872,3.54465,41.93798,1.89687,3.40076,41.85156,1.83003,3.81398,41.91779,1.59509,4.00463,41.97055,1.55666,4.00381,41.90035,1.5775,3.68105,41.83411,1.50774,4.15437,41.76493,1.45121,4.12713,41.54596,1.3181,4.32605,41.60116,1.16406,4.39159,41.60317,1.19034,3.4938,41.78388,1.52451,3.78241,41.77663,1.44059,3.69521,41.70644,1.3755,3.40781,41.71249,1.65717,4.23418,41.97073,1.49878,4.38164,42.02802,1.38821,4.4127,42.02985,1.40392,4.21124,41.98287,1.48034,4.0524,42.13795,1.61604,3.834,42.08762,1.64419,3.5516,42.34091,1.96118,2.1101,42.69967,2.7442,.59656,45.43949,2.63563,.6022,45.4391,2.62769,.68039,45.2906,2.6859,.67424,45.293,2.69586,.71829,45.25055,2.79107,.7105,45.24464,2.75908,.71902,45.23504,2.75361,1.11197,44.96428,2.97892,1.15477,44.90769,2.81042,1.24549,44.89587,3.00173,.979,45.14065,2.68738,1.10072,45.04471,2.74075,.96026,45.09949,2.723,1.05598,45.02434,2.78352,.72753,45.38116,2.62301,.82286,45.18308,2.72826,.8011,45.43046,2.90318,.86421,45.19036,2.8875,.87536,45.26092,2.95328,.77801,45.23099,2.85907,1.12578,44.9961,3.00458,1.175,45.08293,3.03145,1.09297,45.12479,3.02552,1.00336,45.05933,2.94083,1.94859,44.64176,2.85195,2.18864,44.67592,2.72093,1.95585,44.66894,2.89,2.19469,44.72297,2.7681,2.32602,44.87426,2.50098,2.36118,44.80694,2.50505,2.1456,44.79718,2.64308,2.40464,44.74646,2.51943,2.1955,44.67958,2.67033,2.18016,44.7299,2.66797,1.83005,44.16071,2.97015,1.88504,44.06895,2.98526,2.43535,44.11233,2.67019,2.69037,44.20382,2.55224,2.68798,44.22658,2.52155,1.1205,43.52071,2.94717,1.11511,43.48645,3.01698,.63102,44.13874,3.02521,.76622,43.98276,3.02112,.58608,44.15607,3.04603,.71463,44.00778,3.06364,4.01773,41.88967,1.59956,2.78825,42.19205,2.14246,3.27657,42.58303,2.14512,3.42645,42.64642,2.10281,1.17806,44.15075,2.92999,1.11014,44.22839,2.91218,1.06531,44.32306,2.89424,2.05528,42.70881,2.67524,1.76218,43.07375,2.84854,1.00563,44.43021,2.90773,.90589,44.50241,2.87129,1.6637,43.1348,2.86846,2.77678,42.21418,2.17425,2.44636,43.17104,2.65605,2.70899,43.24014,2.6508,2.38973,43.03856,2.75667,2.42026,42.55595,2.55814,2.57999,42.71766,2.53764,2.62372,42.76441,2.5755,1.7066,43.25403,2.97148,1.78876,43.3022,2.93323,1.79152,43.09343,2.9496,.93587,44.05444,3.22467,.96664,43.79607,3.18118,1.02894,43.87521,3.1873,.8703,43.97092,3.20217};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_6()
		{
			double[] value = {1.65583,43.45265,3.00993,1.65372,43.30798,3.00215,1.76784,43.38953,2.97057,2.00466,43.3626,2.80809,1.83117,43.4394,2.93646,1.87101,43.32668,2.8917,1.80223,43.53454,2.94218,1.96743,43.47499,2.83688,1.69304,43.51239,2.99182,1.75672,43.55347,2.95982,1.69873,43.57722,2.97157,1.17545,43.78226,3.11805,1.09764,43.90483,3.14198,.79716,44.34675,3.15254,.85952,44.44194,3.08107,.61071,44.51266,3.13386,2.10506,43.45305,2.5853,1.78903,43.77003,2.99655,1.73761,43.68623,2.95297,1.8498,43.74515,2.97069,1.3153,44.11239,3.0932,1.42379,43.99292,3.07133,1.03834,44.45565,3.09942,1.10228,44.38268,3.1062,.87573,44.65172,3.04176,1.90157,43.92732,2.99684,1.88685,43.81263,2.99011,1.94615,43.90828,2.96852,1.82324,43.82133,3.01294,1.25572,44.74491,2.99484,1.12009,44.70129,3.11937,1.17074,44.64217,3.13331,1.73517,44.78883,2.99133,1.60116,44.83834,3.01773,1.12362,45.22364,3.00265,1.8683,45.01081,2.8283,1.79701,45.01472,2.88019,1.77259,44.91047,2.94764,1.86252,44.88331,2.91503,1.85697,45.02703,2.7938,1.86459,45.02769,2.7836,1.78791,45.03327,2.82255,1.79234,45.0346,2.83571,.66278,44.4519,2.90606,.81244,44.44077,2.91348,.7941,44.55166,2.861,1.21982,44.17001,2.87282,3.31736,41.83057,1.58854,3.64387,41.93536,1.61006,2.73704,42.48478,2.25825,2.88591,42.46143,2.19333,1.39275,43.32838,2.94656,1.43297,43.34175,2.89636,1.54494,43.26673,2.88049,1.52109,43.26011,2.945,1.78355,43.18399,2.79725,1.88611,43.15961,2.75716,2.76381,42.85185,2.29786,2.00315,42.95231,2.77422,2.39577,43.08782,2.56823,2.35287,43.02771,2.55976,2.14882,43.0535,2.671,1.57867,43.48504,2.87394,1.85651,43.3347,2.72477,1.77645,43.57885,2.78646,2.23656,43.71887,2.60864,1.54963,44.01394,2.86213,1.49156,43.92434,2.84973,1.38903,44.07384,2.85842,1.45343,44.15181,2.85194,2.28793,44.07686,2.72501,2.45887,44.02256,2.55429,2.26042,43.9781,2.65502,2.42811,44.11825,2.62198,2.07072,43.79118,2.68943,2.24302,43.80243,2.6356,1.79745,43.87407,2.81779,1.6768,43.91314,2.82276,1.8042,44.10423,2.87031,1.90608,44.03032,2.83512,1.67959,44.22636,2.88592,.74368,44.75707,2.80028,.62103,44.98359,2.73338,.83594,44.9216,2.7757,.55151,44.8483,2.78077,1.71737,44.2916,2.98122,1.82943,44.14523,2.92251,1.37515,44.56182,2.8962,1.3103,44.6755,2.83766,1.24563,44.76512,2.80972,1.14204,44.86082,2.80217,1.24542,44.81956,2.84168,.98943,44.95695,2.84579,.97355,44.87447,2.80425,1.51823,45.07386,2.83545,1.42442,45.04491,2.80241,1.42613,45.11215,2.82996,1.50097,44.99565,2.81491,1.2073,45.24372,2.78705,.96006,45.39481,2.68401};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_7()
		{
			double[] value = {1.01533,45.38859,2.71832,1.2111,45.19324,2.75579,.99494,45.23344,2.67333,1.16661,45.11254,2.74476,.86821,45.36624,2.64789,.85158,45.21928,2.69718,1.18995,44.97803,2.77762,1.12307,44.97826,2.82047,1.36499,44.95824,2.80279,1.30106,44.8893,2.82896,1.25358,45.05012,2.77185,.90226,44.71919,2.80518,2.50452,43.85382,2.50085,2.67958,44.22652,2.48177,2.70431,44.19814,2.4061,1.05957,44.67811,2.80094,1.15559,44.58119,2.81841,1.95314,43.50841,2.64819,1.68498,43.42872,2.80757,1.71354,43.20814,2.81887,2.61727,43.05975,2.43744,3.0298,43.2824,2.40459,3.27474,43.38523,2.32297,3.06509,43.2296,2.35646,2.72879,43.08335,2.3991,3.11368,42.65482,2.24196,2.88231,42.63619,2.28253,2.87633,42.34346,2.14806,2.80771,42.63564,2.28077,3.41204,42.27604,1.97453,3.48552,42.23069,1.90773,1.05136,43.80564,2.93578,.98979,43.95301,2.95911,.51514,44.51908,2.93117,.97644,44.80941,3.06037,1.48132,44.3042,3.13394,1.63122,44.33178,3.06179,1.67619,44.42375,3.03326,1.52794,45.09478,2.87014,1.6077,45.0608,2.90456,1.61523,45.05166,2.86382,1.50311,45.1027,2.91701,1.79562,43.99406,3.05243,.6798,44.76604,3.0283,.79155,44.88773,3.03466,.69848,44.9577,3.00659,2.54724,43.60927,2.5276,2.54143,43.65503,2.55792,.91236,44.19931,3.166,1.27738,43.6867,3.10287,1.31309,43.70917,3.07269,1.25107,43.50038,3.11144,1.37309,43.43121,3.07953,1.35679,43.53238,3.09336,1.1338,43.57886,3.13397,1.17986,43.54172,3.11886,1.21666,43.6332,3.12796,.3172,44.62074,3.10283,.26945,44.52945,3.11758,2.93635,42.8002,2.38191,2.68881,43.06526,2.68844,2.70019,43.18339,2.7114,2.04928,43.24515,2.82335,3.21622,43.50133,2.4301,2.96273,43.36408,2.53152,3.79058,42.58719,2.17912,4.38938,42.23929,1.57366,4.3534,42.248,1.5572,4.25451,42.19974,1.57887,2.65338,42.37179,2.34172,1.44472,43.29745,3.00144,3.44548,43.1392,2.27508,3.40994,43.20197,2.39662,3.18653,42.97552,2.42101,3.20905,42.95034,2.31938,1.28087,44.00544,2.93989,1.26651,44.00644,2.98601,4.2551,41.97897,1.52043,3.70677,42.15497,1.73626,1.19815,43.43585,3.03756,.78254,43.90887,3.10579,.86504,43.86558,3.00763,.72216,45.24643,2.82529,.87381,45.58758,2.76431,.91845,45.13016,2.8607,1.381,44.8239,2.86391,1.34073,44.80368,2.89779,1.47536,44.78072,2.88294,.58458,44.38826,2.91989,1.10617,44.96162,2.86647,.97298,45.004,2.87453,.6824,45.61337,2.62899,1.1789,44.94459,2.81367,3.04735,42.45536,2.40535,3.05385,42.55022,2.40253,3.30751,42.58018,2.35997,3.571,42.68195,2.31579,3.34716,42.6686,2.31817,3.50308,42.7331,2.27534,2.82361,42.60958,2.38931};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_8()
		{
			double[] value = {3.55159,42.16695,1.9267,3.83441,41.97805,1.59607,4.62421,41.73733,.89525,4.59805,41.70992,.84674,4.03406,41.56258,1.25534,3.7736,41.58888,1.38477,3.69443,41.63182,1.34126,1.57249,44.70132,2.89694,1.67224,44.46991,3.03155,1.6771,44.55639,3.01217,1.70043,44.46767,2.97122,3.71104,42.74667,2.24296,1.79095,44.65372,2.90226,1.73582,44.61903,2.96718,1.72699,44.60255,2.93134,1.70182,44.67526,2.89079,1.78767,44.65495,2.86652,1.71455,44.60893,2.90081,1.64126,44.62897,2.90859,1.47971,44.62499,3.02106,1.69478,44.54389,2.94176,3.25095,43.53396,2.50478,2.97216,43.36845,2.59902,2.13776,43.31948,2.75012,2.83793,43.76845,2.43721,2.84103,43.7101,2.33812,1.6029,43.8239,2.80966,1.32337,44.02063,2.89174,1.427,43.8805,2.90025,1.67055,43.233,2.97888,1.22509,43.47161,3.10081,1.14916,43.51542,3.10388,1.20408,43.44812,3.07774,1.12154,43.49541,3.07279,.79973,44.00979,2.99655,.92435,44.12838,2.99452,1.73051,43.50298,2.80271,1.59494,43.59052,2.89799,1.72693,43.66475,2.95112,1.26405,44.01199,3.00629,1.60484,44.17941,3.09839,1.35438,43.34143,3.00185,2.98486,42.85506,2.46478,2.78033,42.58101,2.42489,2.77012,42.5564,2.43507,2.73442,42.48909,2.43222,2.36781,42.504,2.55523,2.68878,42.40978,2.40006,3.47771,42.44633,2.02134,3.46122,42.4702,2.04211,3.60585,42.54643,2.00119,3.50805,42.2093,1.87053,3.70703,42.14137,1.79182,3.65159,42.21994,1.85483,3.63814,42.2089,1.87041,3.00829,42.35302,2.36354,.85153,44.16248,3.20094,.73184,44.30061,3.17003,3.36945,43.31462,2.48814,3.0797,43.16625,2.59487,3.10412,43.11661,2.56378,2.12678,43.97164,2.73386,2.83431,43.7068,2.3147,2.82922,43.78733,2.2852,1.0742,44.50878,3.12056,1.47253,44.03794,3.08344,2.00735,43.99662,2.93335,1.98518,44.01796,2.94815,2.44099,44.87994,2.63659,2.19488,44.76516,2.78737,2.44018,44.78866,2.61417,2.25809,45.19444,2.52217,2.1108,45.09382,2.63635,2.11575,45.1151,2.64854,1.11902,44.97827,2.98577,1.6963,44.4592,2.99608,1.84648,44.04225,3.01698,1.35816,44.43873,3.15811,.60541,45.02937,2.97744,.83854,45.105,2.86553,1.31846,43.70905,3.0496,1.14834,44.18046,3.05692,1.26423,43.64713,2.93977,1.28112,43.66347,2.96223,3.4941,42.21916,1.8873,3.63188,42.27354,1.91182,3.60371,42.29012,1.94026,4.27582,42.17613,1.59624,3.29996,42.71607,2.23226,3.468,42.76177,2.25035,4.28619,42.14363,1.60345,4.26868,42.00117,1.54212,3.65521,42.22703,1.81084,4.43313,41.66484,1.25266,4.38092,41.82089,1.29144,4.40996,41.82614,1.3094,4.53816,41.90391,1.10356,2.05338,42.65167,2.74143,.89994,43.88779,2.97743,.98054,43.76025,2.95687};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_9()
		{
			double[] value = {1.00773,43.63651,2.97405,.94228,43.74345,2.98948,1.0431,43.65497,2.94201,1.15047,43.5434,2.91599,3.68177,41.67252,1.34151,4.11792,41.78666,1.41509,4.09892,41.78239,1.39323,4.18542,41.6304,1.40354,3.93105,41.72232,1.53849,3.89424,41.63725,1.49169,3.87477,41.78506,1.49745,3.91401,41.76407,1.52967,3.08243,42.59102,2.37906,3.08495,42.63096,2.34373,3.32215,42.70656,2.28524,4.44735,42.09671,1.4587,4.00847,42.03064,1.56041,4.19106,42.03378,1.4742,4.18974,42.10406,1.48512,1.03613,45.02994,2.8589,1.0228,45.03826,2.89823,.92197,45.12368,2.81733,.96958,45.00901,2.91118,.79256,45.07436,2.94354,.68498,45.16268,2.89449,2.22701,43.98779,2.80751,2.22487,43.94505,2.81749,2.06564,43.93748,2.90232,1.9883,43.96659,2.94561,2.0793,43.98054,2.88866,1.94985,43.9851,2.973,1.69749,44.54933,2.9847,1.96225,44.70725,2.9083,1.25908,44.87575,2.84955,.89212,45.46027,2.65742,1.02678,45.39418,2.7661,1.93228,45.041,2.75742,1.94871,45.0254,2.78496,1.69868,45.02372,2.93162,1.69123,45.04509,2.88145,1.60478,45.04298,2.952,1.49194,45.08642,2.96685,1.40151,45.12153,2.97141,1.29833,45.2017,2.90318,1.27365,45.19061,2.95856,1.42187,45.13467,2.91541,1.01376,45.38994,2.83245,1.16343,45.25815,2.93669,1.18841,45.26649,2.88014,1.31493,45.20349,2.84538,1.20513,45.2628,2.83173,1.31411,45.1858,2.80192,1.43076,45.13265,2.86873,1.68873,45.0144,2.8244,1.69981,45.0379,2.85122,1.61119,45.0272,2.83388,1.85688,45.00847,2.76855,1.7744,45.01167,2.79991,1.93505,45.0416,2.74722,1.92937,45.02192,2.7338,1.14205,44.43195,3.12843,1.36759,44.15109,3.11039,1.24927,44.29459,3.13513,1.19874,44.2569,3.11352,2.14866,44.04933,2.83979,2.30094,44.07544,2.74557,2.13937,44.05327,2.81515,2.52847,43.7664,2.64295,2.80458,43.86862,2.53206,2.47437,43.90044,2.70132,2.21271,43.7913,2.82725,2.50537,43.83259,2.68031,2.21103,43.86199,2.83416,.64149,44.23088,3.15124,.78355,44.09414,3.18604,.92854,43.77484,3.166,1.03347,43.68153,3.15575,1.09932,43.55701,3.11891,1.00227,43.65673,3.14115,.48532,44.37259,3.1262,1.50668,43.38458,3.06324,.39416,44.68291,3.08674,.48583,44.60012,3.10559,1.01316,44.09056,3.18247,1.11181,43.73862,3.15273,2.65957,42.89792,2.63641,2.29056,42.89444,2.72514,2.87178,43.08774,2.63196,2.89677,42.9801,2.58132,.54704,44.44693,3.14319,1.48366,43.49647,3.07682,3.26729,42.41706,2.08708,3.12642,42.66075,2.27384,1.31848,43.36737,3.00356,.89183,43.75051,3.13232,.88458,43.73822,3.09323,1.29164,44.22548,2.8491,2.00981,43.62838,2.66781,.90015,44.98857,2.98944,2.54316,43.72053,2.47028};
			return value;
		}
		private double[] getlcoscart_Coord_7_105_point_10()
		{
			double[] value = {2.79825,43.86014,2.28711,2.82955,43.28694,2.60404,2.8307,43.28962,2.54834,3.81209,42.55619,1.89092,3.71645,42.63682,1.95502,3.89388,42.67878,2.10049,3.84571,41.58082,1.43568,4.59136,41.8983,1.09788,4.04738,41.71051,1.32217,4.01848,41.63235,1.25461,4.31223,41.75755,1.24219,4.49111,41.76871,.89034,4.2863,41.67551,1.17037,4.48982,41.84772,1.01439,4.56697,41.70762,.83403,4.61304,41.83516,1.0229,4.03491,42.09941,1.58211,4.11097,42.02731,1.70609,3.85748,41.96753,1.80039,3.8131,42.82143,2.16411,.78111,45.6711,2.69264,.7148,45.25446,2.817,.67727,45.32053,2.86478,.71381,45.64149,2.79965,.72241,45.6438,2.80764,.64499,45.49258,2.87764,1.59609,44.74802,2.86852,1.7244,44.72009,2.86167,1.81097,44.70236,2.83784,1.96912,44.76874,2.90646,1.84245,44.77184,2.95073,1.959,44.8823,2.88042,1.6424,44.94627,2.98735,1.31813,45.00346,3.04167,1.38259,44.96047,3.04099,2.18841,44.83773,2.79084,2.281,45.03522,2.49371,2.11011,44.9539,2.63164,2.42875,44.74412,2.57349,2.15878,44.97839,2.76439,2.43124,44.9705,2.64284,2.39303,45.12523,2.61615,3.93199,42.48414,1.87524,1.39353,43.8751,2.94281,3.20711,42.96628,2.22037,4.28557,42.09817,1.60016,4.42805,42.20783,1.55733,2.87091,43.22706,2.45625,3.01221,43.32739,2.64569,2.83696,43.22188,2.66359,3.30718,43.46766,2.53993,.56743,44.6645,3.06379,1.23463,44.5708,3.14142,1.69557,44.07023,3.08417,2.74492,44.01764,2.5846,2.04265,43.88056,2.9189,2.02249,43.80468,2.93188,1.3231,44.69377,2.99247,1.4373,45.04388,3.01677,1.46999,44.9141,3.03688,1.5346,44.99342,3.0129,1.23731,45.16484,3.00697,1.36747,45.08323,3.01866,1.21932,43.60962,2.90435,1.12907,43.70607,2.92211,4.30308,42.23088,1.49621,4.22151,42.18875,1.5348,3.43707,43.14258,2.19979,2.91759,43.13919,2.35896,3.19134,43.03227,2.19523,3.37209,43.18733,2.19805,1.92163,43.82386,2.77137,1.35475,44.29466,2.85579,1.27378,44.42735,2.85617,1.2243,44.49963,2.83796,.85197,44.62044,2.82973,2.76195,43.99242,2.31513,2.72645,44.12716,2.35622,2.02405,43.98915,2.79241,1.93767,44.68929,2.79214,1.93572,44.63839,2.80557,1.93424,44.779,2.73932,1.82699,44.78815,2.78464,1.62925,44.82831,2.82517,1.73046,44.80707,2.81106,1.44316,44.90192,2.82351,1.52644,44.85016,2.83839,1.58929,44.96257,2.81523,1.66397,44.9423,2.80898,1.84185,44.92043,2.75499,1.74762,44.93375,2.78991,1.92702,44.91928,2.71866,1.31091,45.12145,2.7752,4.19848,42.15281,1.50917,4.28505,42.14354,1.42585,4.28495,42.19065,1.45753,4.30848,42.09263,1.40237,2.77715,43.93912,2.5747};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getlfreecrt_Geo_6_110_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,6,7,4,-1,7,8,4,-1,9,10,11,-1,12,0,13,-1,0,2,13,-1,14,15,16,-1,16,17,14,-1,15,18,19,-1,19,16,15,-1,20,13,2,-1,2,21,20,-1,22,23,24,-1,24,25,22,-1,26,27,28,-1,29,18,15,-1,30,26,31,-1,30,27,26,-1,24,23,32,-1,32,33,24,-1,31,34,35,-1,31,26,34,-1,36,37,38,-1,37,39,38,-1,40,41,42,-1,40,43,41,-1,44,43,40,-1,40,45,44,-1,40,42,46,-1,46,47,40,-1,48,44,45,-1,45,49,48,-1,50,51,52,-1,53,37,36,-1,53,54,37,-1,55,56,57,-1,55,58,56,-1,59,10,60,-1,59,11,10,-1,17,61,62,-1,17,63,61,-1,64,65,66,-1,65,64,67,-1,68,69,59,-1,68,70,69,-1,35,1,31,-1,35,3,1,-1,30,71,32,-1,30,72,71,-1,73,74,75,-1,33,74,73,-1,76,19,77,-1,76,78,19,-1,17,79,63,-1,16,79,17,-1,80,66,81,-1,66,80,64,-1,82,83,84,-1,82,85,83,-1,86,70,68,-1,86,21,70,-1,35,87,69,-1,35,34,87,-1,68,60,83,-1,68,59,60,-1,88,89,67,-1,88,90,89,-1,91,65,92,-1,65,91,62,-1,72,93,71,-1,72,94,93,-1,75,95,96,-1,74,95,75,-1,97,78,76,-1,97,98,78,-1,25,33,73,-1,25,24,33,-1,27,32,23,-1,32,27,30,-1,99,100,98,-1,99,101,100,-1,61,4,8,-1,61,63,4,-1,98,79,78,-1,98,100,79,-1,15,102,29,-1,14,102,15,-1,103,92,104,-1,92,103,91,-1,23,28,27,-1,23,22,28,-1,105,87,34,-1,105,106,87,-1,25,107,22,-1,108,107,25,-1,109,82,80,-1,109,110,82,-1,111,86,85,-1,111,112,86,-1,112,21,86,-1,112,20,21,-1,110,85,82,-1,110,111,85,-1,14,62,91,-1,62,14,17,-1,0,113,94,-1,0,12,113,-1,93,114,95,-1,93,115,114,-1,99,97,116,-1,97,99,98,-1,96,116,97,-1,96,117,116,-1,94,115,93,-1,94,113,115,-1,81,7,118,-1,8,7,81,-1,80,118,109,-1,81,118,80,-1,117,95,114,-1,95,117,96,-1,11,106,9,-1,87,106,11,-1,26,105,34,-1,26,28,105,-1,9,90,10,-1,9,104,90,-1,91,102,14,-1,91,103,102,-1,29,108,18,-1,29,107,108,-1,63,100,4,-1,79,100,63,-1,77,18,108,-1,19,18,77,-1,4,101,5,-1,100,101,4,-1,73,108,25,-1,77,108,73,-1,96,76,75,-1,96,97,76,-1,71,95,74,-1,71,93,95,-1,1,94,72,-1,1,0,94,-1,92,67,89,-1,67,92,65,-1,83,88,84,-1,83,60,88,-1,11,69,87,-1,69,11,59,-1,21,3,70,-1,21,2,3,-1,86,83,85,-1,83,86,68,-1,82,64,80,-1,64,82,84,-1,61,81,66,-1,61,8,81,-1,78,16,19,-1,78,79,16,-1,75,77,73,-1,75,76,77,-1,33,71,74,-1,32,71,33,-1,31,72,30,-1,31,1,72,-1,3,69,70,-1,69,3,35,-1,84,67,64,-1,67,84,88,-1,62,66,65,-1,62,61,66,-1,90,60,10,-1,60,90,88,-1,119,57,50,-1,120,57,119,-1,121,122,123,-1,121,124,122,-1,125,126,127,-1,128,126,125,-1,129,46,130,-1,129,47,46,-1,131,132,133,-1,132,131,134,-1,135,55,38,-1,135,58,55,-1,57,51,50,-1,57,56,51,-1,121,136,124,-1,121,137,136,-1,138,139,140,-1,138,141,139,-1,53,142,54,-1,143,142,53,-1,127,49,45,-1,127,126,49,-1,40,127,45,-1,127,40,47,-1,46,144,133,-1,46,42,144,-1,145,131,146,-1,131,145,147,-1,134,143,132,-1,134,139,143,-1,36,130,53,-1,130,36,129,-1,147,148,149,-1,147,145,148,-1,150,151,152,-1,153,151,150,-1,154,126,155,-1,154,49,126,-1,150,120,119,-1,155,120,150,-1,122,153,123,-1,153,122,149,-1,152,156,157,-1,151,156,152,-1,38,128,125,-1,38,55,128,-1,158,146,159,-1,146,158,145,-1,145,160,148,-1,145,158,160,-1,161,49,154,-1,48,49,161,-1,151,160,156,-1,148,160,151,-1,144,41,162,-1,42,41,144,-1,159,144,162,-1,144,159,146,-1,157,154,152,-1,157,161,154,-1,163,149,122,-1,149,163,147,-1,119,153,150,-1,119,123,153,-1,155,128,120,-1,126,128,155,-1,152,155,150,-1,152,154,155,-1,153,148,151,-1,149,148,153,-1,129,38,125,-1,129,36,38,-1,53,132,143,-1};
			return value;
		}
		private int[] getlfreecrt_Geo_6_110_coordIndex_2()
		{
			int[] value = {132,53,130,-1,163,139,134,-1,163,140,139,-1,146,133,144,-1,133,146,131,-1,52,121,50,-1,52,137,121,-1,141,143,139,-1,141,142,143,-1,124,138,140,-1,124,136,138,-1,147,134,131,-1,134,147,163,-1,130,133,132,-1,130,46,133,-1,125,47,129,-1,125,127,47,-1,140,122,124,-1,122,140,163,-1,50,123,119,-1,50,121,123,-1,120,55,57,-1,128,55,120,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getlfreecrt_Coord_7_110_point_1()
		{
			double[] value = {1.50871,47.71562,1.92664,1.07465,47.65724,1.96634,1.5209,47.73246,1.9557,1.09169,47.67067,2.00097,1.65453,46.96077,2.25639,2.11524,47.07102,2.09077,2.12718,47.09676,2.11302,2.13603,47.13866,2.12766,1.65952,47.02193,2.2876,.54062,47.57828,2.10001,.54933,47.58301,2.10485,.54995,47.58371,2.10436,1.90315,47.86183,1.78306,1.90466,47.87593,1.8008,.67201,46.98393,2.24462,.56545,47.03214,2.12514,.85561,46.98084,2.19764,.89863,46.97165,2.26803,.564,47.03289,2.1247,.81903,47.03553,2.14561,1.93649,47.86238,1.84716,1.53428,47.69612,2.01109,.48274,47.56717,1.89329,.4902,47.56766,1.88614,.48932,47.5672,1.88633,.48924,47.566,1.88684,.58604,47.79104,1.8518,.58456,47.79053,1.85182,.57626,47.78641,1.86048,.55383,47.03706,2.1307,.81471,47.63909,1.92588,.83557,47.68843,1.9309,.77565,47.52981,1.94036,.76456,47.47358,1.95287,.6379,47.82419,1.8973,.85478,47.69889,1.96724,.73906,45.9079,2.70166,.72899,45.90577,2.6926,.79969,45.83281,2.63701,.78424,45.84082,2.63325,1.76429,45.5843,2.64198,2.23869,45.73427,2.51049,1.75281,45.68692,2.67577,2.21858,45.64729,2.4752,2.2185,45.64703,2.47489,1.78429,45.56351,2.61603,1.22481,45.78577,2.74511,1.26834,45.66502,2.72378,2.21709,45.65366,2.44876,1.75683,45.56012,2.56905,.58384,46.01801,2.45376,.58989,46.00103,2.46432,.57787,46.01911,2.46144,.66373,46.05255,2.70123,.65375,46.04903,2.69487,.7483,45.78093,2.54425,.63622,45.89002,2.50188,.63733,45.89004,2.49621,.74019,45.79146,2.54618,.8268,47.54056,2.11583,.82575,47.43925,2.17619,1.15862,46.98739,2.3439,.88609,47.034,2.31311,1.1632,46.92799,2.30163,1.11616,47.15753,2.32869,.85569,47.13057,2.31515,1.13112,47.08677,2.34441,.84296,47.18427,2.30506,1.08223,47.51978,2.14221,.84707,47.65203,2.03232,1.08939,47.62468,2.06391,1.0301,47.50155,1.97379,1.05957,47.60713,1.96015,.76382,47.37589,1.98679,1.02401,47.42244,1.99429,1.03165,47.32233,2.03238,1.04093,47.14217,2.1046,.77085,47.18042,2.06391,1.08528,46.99624,2.18545,1.12185,46.93469,2.23946,1.62478,47.21775,2.26297,1.64131,47.122,2.28481,1.60789,47.32028,2.22482,1.09157,47.41061,2.20608,1.10615,47.24015,2.29281,1.58157,47.48271,2.14968,1.5531,47.60046,2.08256,.60733,47.77769,1.97205,.83542,47.26526,2.2673,.56117,47.23636,2.29069,.56117,47.23684,2.29051,.62284,47.06472,2.3129,.56212,47.23566,2.29079,1.49601,47.5595,1.93277,1.50477,47.65757,1.92029,1.50317,47.46835,1.9588,1.52572,47.32392,2.01657,1.54258,47.17758,2.07794,1.58054,47.04022,2.15016,2.04039,47.18538,1.99049};
			return value;
		}
		private double[] getlfreecrt_Coord_7_110_point_2()
		{
			double[] value = {1.61774,46.96454,2.20727,2.08416,47.07098,2.05913,.65862,46.98867,2.24323,.61101,47.06167,2.3059,.55092,47.23444,2.28448,.62647,47.81665,1.90044,.59753,47.77483,1.96473,.4478,47.21614,2.0104,.4544,47.2158,2.00192,2.1035,47.39208,2.07746,2.08512,47.48895,2.04179,2.04051,47.66558,1.9709,1.98796,47.77637,1.90476,1.91583,47.78848,1.77195,1.94401,47.6365,1.79512,1.92736,47.70953,1.77476,2.01237,47.33337,1.92193,1.99633,47.40837,1.88866,2.11735,47.25941,2.11136,.88462,45.83186,2.52371,.92951,45.72817,2.5538,.54251,46.24462,2.37876,.90948,46.27793,2.44243,.84242,46.06079,2.46317,.63632,46.46319,2.35729,1.0742,45.65736,2.69574,1.26354,45.58063,2.61312,1.30179,45.59409,2.68615,1.03311,45.62421,2.61226,1.02422,45.71594,2.75271,.96479,45.847,2.76534,1.21471,46.21292,2.59271,.94034,46.07806,2.71816,1.20578,46.01756,2.70439,.96599,46.27237,2.59939,.78486,45.837,2.62907,.62947,46.46239,2.36595,.53727,46.24476,2.38633,.67327,46.51281,2.40772,.67623,46.48071,2.51512,.68344,46.51896,2.40484,.66559,46.47681,2.51104,.62343,46.28448,2.63746,.63385,46.28618,2.64339,1.74506,45.91804,2.64989,1.63617,46.21009,2.43982,1.72028,46.11115,2.55739,1.17615,46.28344,2.4751,1.61393,46.18014,2.41312,1.1416,46.24119,2.43771,1.14518,45.79241,2.5181,1.6279,45.97232,2.43503,1.676,45.73737,2.49113,1.10129,46.02517,2.45992,1.69424,45.69754,2.49848,1.18148,45.71014,2.53994,2.11329,46.06772,2.30885,2.16401,45.82961,2.35717,2.05386,46.28759,2.30618,2.1847,46.15744,2.41968,2.04223,46.26847,2.28946,2.16409,45.82901,2.35729,2.24267,45.96709,2.4901,.95032,46.32703,2.48516};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrclavcle_Geo_6_115_coordIndex_1()
		{
			int[] value = {0,1,2,-1,1,3,2,-1,4,5,6,-1,5,7,6,-1,8,9,10,-1,9,11,10,-1,12,13,14,-1,12,15,13,-1,16,17,18,-1,18,19,16,-1,19,20,16,-1,21,22,23,-1,21,24,22,-1,25,26,27,-1,25,28,26,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,35,36,33,-1,37,38,39,-1,40,41,42,-1,42,43,40,-1,42,44,43,-1,43,45,40,-1,46,47,48,-1,46,49,47,-1,50,51,52,-1,53,54,55,-1,53,56,54,-1,57,58,59,-1,60,61,62,-1,62,63,60,-1,64,65,66,-1,67,68,69,-1,68,70,69,-1,0,7,5,-1,0,2,7,-1,71,3,1,-1,71,72,3,-1,73,74,75,-1,75,76,73,-1,77,78,79,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,90,92,91,-1,93,94,95,-1,93,96,94,-1,95,97,93,-1,98,99,100,-1,99,101,100,-1,102,103,104,-1,103,105,104,-1,106,107,108,-1,109,110,111,-1,109,112,110,-1,113,114,115,-1,115,116,113,-1,117,118,119,-1,118,120,119,-1,121,122,123,-1,124,125,126,-1,124,127,125,-1,128,129,130,-1,128,131,129,-1,132,133,134,-1,134,135,132,-1,134,136,135,-1,137,138,139,-1,140,141,142,-1,143,144,145,-1,143,146,144,-1,147,148,149,-1,147,150,148,-1,151,152,153,-1,151,154,152,-1,155,156,157,-1,155,158,156,-1,159,160,161,-1,125,153,162,-1,125,163,153,-1,164,165,144,-1,165,166,144,-1,167,168,150,-1,167,151,168,-1,169,170,149,-1,170,171,149,-1,143,172,173,-1,143,174,172,-1,175,176,177,-1,178,179,91,-1,91,180,178,-1,181,182,183,-1,183,184,181,-1,185,186,187,-1,185,188,186,-1,79,189,190,-1,191,192,193,-1,193,194,191,-1,132,139,195,-1,139,74,195,-1,196,129,197,-1,196,136,129,-1,198,128,199,-1,199,200,198,-1,201,202,203,-1,201,204,202,-1,205,206,207,-1,208,209,105,-1,105,210,208,-1,211,212,213,-1,211,214,212,-1,215,216,217,-1,215,115,216,-1,218,219,220,-1,218,221,219,-1,122,222,110,-1,222,223,110,-1,120,224,225,-1,117,226,227,-1,228,114,229,-1,228,230,114,-1,231,232,233,-1,231,234,232,-1,116,235,236,-1,235,237,236,-1,238,239,240,-1,238,241,239,-1,109,242,243,-1,109,244,242,-1,245,246,247,-1,247,248,245,-1,249,250,251,-1,252,253,254,-1,252,255,253,-1,256,257,258,-1,258,259,256,-1,260,261,262,-1,261,263,262,-1,264,103,265,-1,264,266,103,-1,267,268,269,-1,269,270,267,-1,271,272,273,-1,84,274,275,-1,98,276,277,-1,277,278,98,-1,279,78,280,-1,281,88,282,-1,283,284,285,-1,283,286,284,-1,287,77,288,-1,289,290,291,-1,289,41,290,-1,42,81,292,-1,42,293,81,-1,294,295,296,-1,295,297,296,-1,298,299,300,-1,298,301,299,-1,302,303,304,-1,302,305,303,-1,306,307,308,-1,306,309,307,-1,310,311,312,-1,312,313,310,-1,314,315,316,-1,316,317,314,-1,318,319,320,-1,318,321,319,-1,322,323,324,-1,322,325,323,-1,326,76,327,-1,327,328,326,-1,329,330,331,-1,331,332,329,-1,333,334,335,-1,333,336,334,-1,337,48,338,-1,48,339,338,-1,340,341,342,-1,340,63,341,-1,343,344,51,-1,345,346,347,-1,345,348,346,-1,349,350,351,-1,35,352,353,-1,35,354,352,-1,44,355,356,-1,356,18,44,-1,357,358,30,-1,30,359,357,-1,16,49,360,-1,16,27,49,-1,361,45,362,-1,363,364,24,-1,363,365,364,-1,29,28,366,-1,366,367,29,-1,19,368,23,-1,23,369,19,-1,25,20,370,-1,370,371,25,-1,372,36,373,-1,373,374,372,-1,22,375,376,-1,376,377,22,-1,21,378,379,-1,380,43,17,-1,381,46,382,-1,383,47,26,-1,26,31,383,-1,384,385,386,-1,387,33,388,-1,388,389,387,-1,390,391,52,-1,392,393,394,-1,392,395,393,-1,396,53,397,-1,53,398,397,-1,399,400,62,-1,62,401,399,-1,402,403,66,-1,404,405,406,-1,404,407,405,-1,408,409,410,-1,411,412,413,-1,411,414,412,-1,415,73,416,-1,73,417,416,-1,418,419,420,-1,418,421,419,-1,422,423,424,-1,424,425,422,-1,426,427,428,-1,426,429,427,-1,430,431,432,-1,432,433,430,-1,434,435,436,-1,437,80,438,-1,80,439,438,-1,438,38,437,-1,440,39,441,-1,442,443,444,-1,442,445,443,-1,89,446,447,-1,447,448,89,-1,449,86,96,-1,40,450,83,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_2()
		{
			int[] value = {451,452,453,-1,451,454,452,-1,455,456,457,-1,455,458,456,-1,459,460,461,-1,461,462,459,-1,463,464,465,-1,465,466,463,-1,467,468,469,-1,467,470,468,-1,471,472,473,-1,471,474,472,-1,475,476,111,-1,475,477,476,-1,478,479,480,-1,479,481,480,-1,113,482,483,-1,484,485,486,-1,484,487,485,-1,488,489,119,-1,112,490,123,-1,491,492,121,-1,121,493,491,-1,494,118,495,-1,496,497,498,-1,68,499,500,-1,501,502,82,-1,95,503,504,-1,505,506,507,-1,505,508,506,-1,509,510,97,-1,509,511,510,-1,512,513,133,-1,514,515,138,-1,515,75,138,-1,516,517,518,-1,518,519,516,-1,520,521,142,-1,522,523,524,-1,524,525,522,-1,526,527,528,-1,526,92,527,-1,12,529,15,-1,12,530,529,-1,69,531,532,-1,69,533,531,-1,145,154,534,-1,145,535,154,-1,536,537,538,-1,536,152,537,-1,539,540,127,-1,539,541,540,-1,2,3,14,-1,14,13,2,-1,542,543,544,-1,543,545,544,-1,164,546,156,-1,546,547,156,-1,548,163,540,-1,548,168,163,-1,174,167,549,-1,174,534,167,-1,550,551,173,-1,550,552,551,-1,553,193,514,-1,554,518,555,-1,198,190,556,-1,190,519,556,-1,557,539,558,-1,557,161,539,-1,222,492,559,-1,484,227,560,-1,484,495,227,-1,235,215,498,-1,215,213,498,-1,475,561,240,-1,475,223,561,-1,471,490,243,-1,471,562,490,-1,563,564,469,-1,563,487,564,-1,4,11,9,-1,4,6,11,-1,565,566,464,-1,565,460,566,-1,567,249,568,-1,567,457,249,-1,568,569,567,-1,270,570,571,-1,270,572,570,-1,573,271,574,-1,271,159,574,-1,179,575,517,-1,517,446,179,-1,279,447,516,-1,516,189,279,-1,449,576,577,-1,577,578,449,-1,577,286,578,-1,287,579,280,-1,579,448,280,-1,579,580,448,-1,293,581,501,-1,293,289,581,-1,439,502,582,-1,582,295,439,-1,582,442,295,-1,318,317,416,-1,318,420,317,-1,583,323,319,-1,323,584,319,-1,585,515,192,-1,585,327,515,-1,586,165,158,-1,586,176,165,-1,405,587,409,-1,405,588,587,-1,409,336,405,-1,538,177,589,-1,590,591,592,-1,590,593,591,-1,390,594,394,-1,390,425,594,-1,390,344,425,-1,350,393,389,-1,595,395,596,-1,595,387,395,-1,357,341,400,-1,357,597,341,-1,383,399,339,-1,383,358,399,-1,361,337,274,-1,274,450,361,-1,361,382,337,-1,337,402,274,-1,402,598,274,-1,371,374,366,-1,371,599,374,-1,368,356,378,-1,356,600,378,-1,601,107,500,-1,601,108,107,-1,602,568,603,-1,602,569,568,-1,604,108,602,-1,604,106,108,-1,270,269,572,-1,269,605,572,-1,606,5,607,-1,606,0,5,-1,333,335,499,-1,335,500,499,-1,356,19,18,-1,368,19,356,-1,377,23,22,-1,369,23,377,-1,25,366,28,-1,25,371,366,-1,26,29,31,-1,28,29,26,-1,366,373,367,-1,366,374,373,-1,372,33,36,-1,372,388,33,-1,351,608,349,-1,609,608,351,-1,346,375,347,-1,376,375,346,-1,365,307,364,-1,365,308,307,-1,24,379,363,-1,24,21,379,-1,39,610,37,-1,610,39,440,-1,611,356,355,-1,611,600,356,-1,380,45,43,-1,380,362,45,-1,45,450,40,-1,45,361,450,-1,382,48,337,-1,382,46,48,-1,26,49,27,-1,49,26,47,-1,30,383,31,-1,383,30,358,-1,357,612,597,-1,357,359,612,-1,385,441,386,-1,385,440,441,-1,355,42,292,-1,355,44,42,-1,613,352,614,-1,613,353,352,-1,35,615,354,-1,35,34,615,-1,595,616,617,-1,595,596,616,-1,350,388,351,-1,350,389,388,-1,389,395,387,-1,389,393,395,-1,345,307,309,-1,345,347,307,-1,390,51,344,-1,390,52,51,-1,51,618,343,-1,51,50,618,-1,394,619,392,-1,394,594,619,-1,620,411,621,-1,620,414,411,-1,396,56,53,-1,396,622,56,-1,623,590,592,-1,624,590,623,-1,625,57,59,-1,626,57,625,-1,627,628,612,-1,627,629,628,-1,597,342,341,-1,597,630,342,-1,62,341,63,-1,341,62,400,-1,188,342,186,-1,340,342,188,-1,62,631,401,-1,62,61,631,-1,631,66,403,-1,66,631,64,-1,632,274,598,-1,632,275,274,-1,65,633,634,-1,65,635,633,-1,636,637,638,-1,636,639,637,-1,170,637,640,-1,637,170,169,-1,641,642,639,-1,642,641,643,-1,68,644,499,-1,67,644,68,-1,334,645,335,-1,334,646,645,-1,333,405,336,-1,333,406,405,-1,405,647,588,-1,405,407,647,-1,648,649,650,-1,649,648,651,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_3()
		{
			int[] value = {652,653,64,-1,652,654,653,-1,155,655,654,-1,655,155,157,-1,586,177,176,-1,586,589,177,-1,587,410,409,-1,587,606,410,-1,330,521,520,-1,330,329,521,-1,411,332,331,-1,332,411,413,-1,656,657,658,-1,656,659,657,-1,657,660,661,-1,657,662,660,-1,663,664,665,-1,663,659,664,-1,191,585,192,-1,666,585,191,-1,327,75,515,-1,327,76,75,-1,667,328,665,-1,326,328,667,-1,323,664,324,-1,583,664,323,-1,412,322,413,-1,325,322,412,-1,668,669,670,-1,668,671,669,-1,672,319,584,-1,672,320,319,-1,318,417,321,-1,318,416,417,-1,195,73,415,-1,73,195,74,-1,513,316,315,-1,316,513,512,-1,420,314,317,-1,314,420,419,-1,421,312,311,-1,421,418,312,-1,423,313,424,-1,310,313,423,-1,306,50,309,-1,306,673,50,-1,674,303,618,-1,674,304,303,-1,428,305,302,-1,305,428,427,-1,429,300,299,-1,429,426,300,-1,433,301,298,-1,301,433,432,-1,675,430,676,-1,431,430,675,-1,200,677,678,-1,677,200,199,-1,679,680,681,-1,679,682,680,-1,683,684,685,-1,683,686,684,-1,687,436,435,-1,687,688,436,-1,689,690,691,-1,690,689,692,-1,281,693,694,-1,693,281,282,-1,442,297,295,-1,297,442,444,-1,439,82,502,-1,439,80,82,-1,438,39,38,-1,438,441,39,-1,293,41,289,-1,293,42,41,-1,695,442,582,-1,695,445,442,-1,291,581,289,-1,696,581,291,-1,83,41,40,-1,290,41,83,-1,287,697,579,-1,287,288,697,-1,698,285,284,-1,698,699,285,-1,286,692,578,-1,286,283,692,-1,282,87,689,-1,87,282,88,-1,700,443,445,-1,443,700,701,-1,279,448,447,-1,279,280,448,-1,179,89,91,-1,446,89,179,-1,92,702,527,-1,90,702,92,-1,181,703,182,-1,704,703,181,-1,705,706,707,-1,708,706,705,-1,93,449,96,-1,93,576,449,-1,95,709,503,-1,94,709,95,-1,710,202,204,-1,710,711,202,-1,276,100,712,-1,276,98,100,-1,99,574,101,-1,99,573,574,-1,713,84,275,-1,713,85,84,-1,271,160,159,-1,271,273,160,-1,714,715,716,-1,714,717,715,-1,718,68,719,-1,718,70,68,-1,270,720,267,-1,270,571,720,-1,720,104,721,-1,720,102,104,-1,570,722,571,-1,722,570,723,-1,264,496,266,-1,264,497,496,-1,205,452,206,-1,453,452,205,-1,723,454,451,-1,454,723,724,-1,570,604,725,-1,570,572,604,-1,107,605,719,-1,106,605,107,-1,569,645,567,-1,569,601,645,-1,259,726,256,-1,727,726,259,-1,263,728,262,-1,263,729,728,-1,260,477,261,-1,260,476,477,-1,730,257,731,-1,730,258,257,-1,241,732,239,-1,733,732,241,-1,734,244,735,-1,734,242,244,-1,252,736,255,-1,737,736,252,-1,738,739,646,-1,739,738,740,-1,253,458,254,-1,456,458,253,-1,728,253,255,-1,253,728,741,-1,742,250,741,-1,742,251,250,-1,544,743,744,-1,743,544,545,-1,464,745,565,-1,745,464,463,-1,746,460,459,-1,460,746,566,-1,607,747,748,-1,747,607,749,-1,465,750,466,-1,465,751,750,-1,752,753,754,-1,752,755,753,-1,756,757,758,-1,756,759,757,-1,760,761,762,-1,760,763,761,-1,468,563,469,-1,468,764,563,-1,246,467,247,-1,470,467,246,-1,545,246,245,-1,246,545,543,-1,765,248,247,-1,248,765,766,-1,767,471,473,-1,471,767,562,-1,243,112,109,-1,243,490,112,-1,223,111,110,-1,475,111,223,-1,768,240,561,-1,238,240,768,-1,236,479,478,-1,479,236,237,-1,498,237,235,-1,237,498,497,-1,482,116,236,-1,116,482,113,-1,769,770,765,-1,769,771,770,-1,233,768,772,-1,233,232,768,-1,221,233,219,-1,231,233,221,-1,114,216,115,-1,114,230,216,-1,228,221,218,-1,228,229,221,-1,484,494,495,-1,484,486,494,-1,227,118,117,-1,227,495,118,-1,225,119,120,-1,488,119,225,-1,120,121,224,-1,120,493,121,-1,773,490,562,-1,773,123,490,-1,559,223,222,-1,223,559,561,-1,491,559,492,-1,491,772,559,-1,220,494,218,-1,118,494,220,-1,774,775,764,-1,775,774,776,-1,498,212,496,-1,498,213,212,-1,214,776,777,-1,214,211,776,-1,778,774,779,-1,778,780,774,-1,209,781,782,-1,781,209,208,-1,783,784,785,-1,784,783,786,-1,787,788,789,-1,787,790,788,-1,791,783,788,-1,791,721,783,-1,104,209,786,-1,104,105,209,-1,792,557,558,-1,793,557,792,-1,712,203,202,-1,712,794,203,-1,201,503,204,-1,201,504,503,-1,97,504,509,-1,95,504,97,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_4()
		{
			int[] value = {795,796,797,-1,795,798,796,-1,799,508,800,-1,506,508,799,-1,124,801,802,-1,124,126,801,-1,803,511,804,-1,510,511,803,-1,131,198,556,-1,128,198,131,-1,197,131,805,-1,131,197,129,-1,554,519,518,-1,554,556,519,-1,806,136,196,-1,136,806,135,-1,135,139,132,-1,135,137,139,-1,806,193,553,-1,806,194,193,-1,133,195,512,-1,133,132,195,-1,193,515,514,-1,515,193,192,-1,807,808,809,-1,807,810,808,-1,811,179,178,-1,811,575,179,-1,519,189,516,-1,519,190,189,-1,812,178,180,-1,812,810,178,-1,526,813,814,-1,813,526,528,-1,184,815,816,-1,815,184,183,-1,56,817,54,-1,56,818,817,-1,593,819,591,-1,593,820,819,-1,524,821,822,-1,524,523,821,-1,823,524,824,-1,525,524,823,-1,825,187,826,-1,185,187,825,-1,801,823,800,-1,801,826,823,-1,827,796,828,-1,796,827,804,-1,829,803,830,-1,803,829,707,-1,527,184,528,-1,181,184,527,-1,166,176,175,-1,176,166,165,-1,530,831,529,-1,530,832,831,-1,171,532,531,-1,532,171,170,-1,833,834,835,-1,833,836,834,-1,837,173,172,-1,837,550,173,-1,834,174,549,-1,172,174,834,-1,146,173,551,-1,143,173,146,-1,147,167,150,-1,147,549,167,-1,838,540,541,-1,838,548,540,-1,168,153,163,-1,168,151,153,-1,537,154,535,-1,154,537,152,-1,158,164,156,-1,165,164,158,-1,536,153,152,-1,536,162,153,-1,160,539,161,-1,541,539,160,-1,552,839,551,-1,839,552,840,-1,14,72,841,-1,72,14,3,-1,648,156,547,-1,648,157,156,-1,364,347,375,-1,364,307,347,-1,308,296,842,-1,365,296,308,-1,365,384,296,-1,359,627,612,-1,359,843,627,-1,386,438,294,-1,441,438,386,-1,354,624,623,-1,354,615,624,-1,617,398,844,-1,617,616,398,-1,52,309,50,-1,52,345,309,-1,303,343,618,-1,343,303,422,-1,331,621,411,-1,621,331,397,-1,630,186,342,-1,630,522,186,-1,64,635,65,-1,64,653,635,-1,272,275,632,-1,272,713,275,-1,638,169,845,-1,638,637,169,-1,640,532,170,-1,640,846,532,-1,408,646,334,-1,408,738,646,-1,407,651,647,-1,407,649,651,-1,654,847,155,-1,652,847,654,-1,848,329,849,-1,329,848,521,-1,658,661,850,-1,658,657,661,-1,662,851,660,-1,662,852,851,-1,666,809,808,-1,666,191,809,-1,670,325,412,-1,325,670,669,-1,312,320,672,-1,312,418,320,-1,512,415,316,-1,415,512,195,-1,675,315,431,-1,315,675,513,-1,423,427,310,-1,423,305,427,-1,853,304,674,-1,853,434,304,-1,426,686,300,-1,426,684,686,-1,199,430,677,-1,430,199,676,-1,79,678,77,-1,79,200,678,-1,435,283,687,-1,435,692,283,-1,435,690,692,-1,444,694,297,-1,694,444,281,-1,277,696,291,-1,696,277,854,-1,290,85,278,-1,85,290,83,-1,284,855,698,-1,284,856,855,-1,88,701,86,-1,88,443,701,-1,527,704,181,-1,702,704,527,-1,204,709,710,-1,709,204,503,-1,719,269,718,-1,719,605,269,-1,716,857,533,-1,716,715,857,-1,267,721,791,-1,267,720,721,-1,266,212,210,-1,266,496,212,-1,206,258,730,-1,452,258,206,-1,251,256,726,-1,251,742,256,-1,239,261,477,-1,261,239,732,-1,262,255,736,-1,728,255,262,-1,737,858,859,-1,737,252,858,-1,740,455,739,-1,740,462,455,-1,741,456,253,-1,456,741,250,-1,545,472,743,-1,545,245,472,-1,459,749,746,-1,459,747,749,-1,465,10,751,-1,8,10,465,-1,758,755,752,-1,758,757,755,-1,762,759,756,-1,762,761,759,-1,467,765,247,-1,467,769,765,-1,779,764,468,-1,779,774,764,-1,766,473,248,-1,766,767,473,-1,238,232,480,-1,238,768,232,-1,489,771,226,-1,771,489,770,-1,229,231,221,-1,231,229,483,-1,218,486,228,-1,218,494,486,-1,118,493,120,-1,118,220,493,-1,123,224,121,-1,123,773,224,-1,776,217,775,-1,776,211,217,-1,782,786,209,-1,782,784,786,-1,529,790,787,-1,529,831,790,-1,505,793,792,-1,793,505,860,-1,509,201,861,-1,201,509,504,-1,804,797,796,-1,797,804,511,-1,805,862,197,-1,805,863,862,-1,180,814,812,-1,180,526,814,-1,142,183,140,-1,142,815,183,-1,820,828,819,-1,820,827,828,-1,822,824,524,-1,822,864,824,-1,535,175,537,-1,175,535,166,-1,832,865,866,-1,530,865,832,-1,836,172,834,-1,836,837,172,-1,867,839,840,-1,839,867,868,-1,867,588,647,-1,588,867,71,-1,841,840,552,-1,841,72,840,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_5()
		{
			int[] value = {836,857,866,-1,836,833,857,-1,717,832,715,-1,717,831,832,-1,830,804,827,-1,830,803,804,-1,800,824,799,-1,824,800,823,-1,54,820,593,-1,820,54,817,-1,818,622,141,-1,818,56,622,-1,661,814,813,-1,661,660,814,-1,863,575,811,-1,555,575,863,-1,676,134,675,-1,134,676,130,-1,558,802,792,-1,558,124,802,-1,797,869,795,-1,869,797,861,-1,793,574,557,-1,793,101,574,-1,788,870,791,-1,870,788,790,-1,757,785,784,-1,759,785,757,-1,780,776,774,-1,780,777,776,-1,561,772,768,-1,561,559,772,-1,562,871,773,-1,562,767,871,-1,762,7,760,-1,7,762,6,-1,751,754,750,-1,751,752,754,-1,566,9,8,-1,566,746,9,-1,740,748,747,-1,740,738,748,-1,858,565,745,-1,858,872,565,-1,646,567,645,-1,646,739,567,-1,601,602,108,-1,601,569,602,-1,725,723,570,-1,725,724,723,-1,709,701,700,-1,709,94,701,-1,708,93,706,-1,93,708,576,-1,855,90,580,-1,855,702,90,-1,853,691,690,-1,873,691,853,-1,685,688,687,-1,688,685,684,-1,682,678,677,-1,682,679,678,-1,594,670,619,-1,594,668,670,-1,659,662,657,-1,663,662,659,-1,606,1,0,-1,606,587,1,-1,654,874,653,-1,654,655,874,-1,650,643,641,-1,650,649,643,-1,639,640,637,-1,642,640,639,-1,598,634,632,-1,634,598,65,-1,59,627,625,-1,629,627,59,-1,624,55,590,-1,624,844,55,-1,621,596,620,-1,621,616,596,-1,600,37,610,-1,611,37,600,-1,875,609,599,-1,875,608,609,-1,614,32,613,-1,614,843,32,-1,617,34,595,-1,617,615,34,-1,626,592,57,-1,626,623,592,-1,597,628,630,-1,597,612,628,-1,638,635,636,-1,635,638,633,-1,876,67,846,-1,644,67,876,-1,64,61,652,-1,631,61,64,-1,589,847,60,-1,586,847,589,-1,658,877,656,-1,658,849,877,-1,666,878,585,-1,666,852,878,-1,583,665,664,-1,583,667,665,-1,671,584,669,-1,672,584,671,-1,673,618,50,-1,674,618,673,-1,686,681,680,-1,686,683,681,-1,694,879,842,-1,694,693,879,-1,696,582,581,-1,696,695,582,-1,579,699,698,-1,697,699,579,-1,689,578,692,-1,689,87,578,-1,577,704,856,-1,577,703,704,-1,711,880,854,-1,711,710,880,-1,573,85,713,-1,573,99,85,-1,716,718,714,-1,718,716,70,-1,571,102,720,-1,722,102,571,-1,106,572,605,-1,106,604,572,-1,726,603,568,-1,726,727,603,-1,733,731,732,-1,733,730,731,-1,737,735,736,-1,737,734,735,-1,729,741,728,-1,729,742,741,-1,744,881,859,-1,744,743,881,-1,5,749,607,-1,5,4,749,-1,11,758,10,-1,11,756,758,-1,564,771,769,-1,771,564,560,-1,770,766,765,-1,882,766,770,-1,764,883,563,-1,764,775,883,-1,778,884,885,-1,778,779,884,-1,755,781,753,-1,755,782,781,-1,763,789,761,-1,763,787,789,-1,721,786,783,-1,104,786,721,-1,500,719,68,-1,719,500,107,-1,794,100,860,-1,794,712,100,-1,556,805,131,-1,554,805,556,-1,553,135,806,-1,553,137,135,-1,809,862,807,-1,862,809,886,-1,851,810,812,-1,851,808,810,-1,816,848,850,-1,815,848,816,-1,126,826,801,-1,826,126,825,-1,828,798,864,-1,828,796,798,-1,140,707,829,-1,140,705,707,-1,58,822,821,-1,822,591,819,-1,822,58,591,-1,550,865,887,-1,550,837,865,-1,549,835,834,-1,147,835,549,-1,548,845,148,-1,548,838,845,-1,546,551,839,-1,546,146,551,-1,651,547,868,-1,648,547,651,-1,531,835,171,-1,531,833,835,-1,12,841,887,-1,12,14,841,-1,162,185,825,-1,185,162,536,-1,525,826,187,-1,525,823,826,-1,818,830,817,-1,818,829,830,-1,528,816,813,-1,528,184,816,-1,810,811,178,-1,807,811,810,-1,194,196,886,-1,196,194,806,-1,802,800,508,-1,802,801,800,-1,798,506,799,-1,795,506,798,-1,869,794,507,-1,794,869,203,-1,785,788,783,-1,785,789,788,-1,208,777,781,-1,214,777,208,-1,871,488,225,-1,488,871,882,-1,230,883,216,-1,230,485,883,-1,219,772,491,-1,772,219,233,-1,482,478,234,-1,478,482,236,-1,470,543,884,-1,470,246,543,-1,13,763,760,-1,13,15,763,-1,754,780,778,-1,754,753,780,-1,466,885,542,-1,466,750,885,-1,463,744,745,-1,744,463,544,-1,254,461,872,-1,458,461,254,-1,881,242,734,-1,881,474,242,-1,481,733,241,-1,733,481,207,-1,731,729,263,-1,731,257,729,-1,476,735,244,-1,260,735,476,-1,602,725,604,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_6()
		{
			int[] value = {725,602,603,-1,454,727,259,-1,454,724,727,-1,453,497,264,-1,205,497,453,-1,205,237,497,-1,205,479,237,-1,723,265,722,-1,723,451,265,-1,714,870,717,-1,714,268,870,-1,712,711,276,-1,711,712,202,-1,707,510,803,-1,706,510,707,-1,182,708,705,-1,703,708,182,-1,880,445,695,-1,880,700,445,-1,282,691,693,-1,691,282,689,-1,685,699,683,-1,685,285,699,-1,681,288,679,-1,681,697,288,-1,682,298,680,-1,298,682,433,-1,302,688,428,-1,302,436,688,-1,879,673,306,-1,879,873,673,-1,299,311,429,-1,421,311,299,-1,419,432,314,-1,419,301,432,-1,424,671,668,-1,424,313,671,-1,321,326,667,-1,326,321,417,-1,665,878,663,-1,665,328,878,-1,324,659,656,-1,324,664,659,-1,877,413,322,-1,332,413,877,-1,748,606,607,-1,606,748,410,-1,650,157,648,-1,650,655,157,-1,601,335,645,-1,601,500,335,-1,406,499,644,-1,406,333,499,-1,643,876,642,-1,643,404,876,-1,874,639,636,-1,874,641,639,-1,160,634,541,-1,634,160,273,-1,634,838,541,-1,634,633,838,-1,403,401,631,-1,401,403,338,-1,340,538,589,-1,340,188,538,-1,523,629,821,-1,629,523,628,-1,330,622,396,-1,330,520,622,-1,392,414,620,-1,392,619,414,-1,348,393,350,-1,348,391,393,-1,626,614,352,-1,614,626,625,-1,362,360,381,-1,380,360,362,-1,611,292,437,-1,611,355,292,-1,363,440,385,-1,379,440,363,-1,379,610,440,-1,349,376,346,-1,608,376,349,-1,609,388,372,-1,609,351,388,-1,367,353,613,-1,367,373,353,-1,369,875,370,-1,369,377,875,-1,647,868,867,-1,647,651,868,-1,840,71,867,-1,840,72,71,-1,868,546,839,-1,546,868,547,-1,540,125,127,-1,163,125,540,-1,146,164,144,-1,164,146,546,-1,166,145,144,-1,535,145,166,-1,167,154,151,-1,167,534,154,-1,148,168,548,-1,148,150,168,-1,148,169,149,-1,169,148,845,-1,171,147,149,-1,835,147,171,-1,174,145,534,-1,174,143,145,-1,887,552,550,-1,887,841,552,-1,837,866,865,-1,836,866,837,-1,533,833,531,-1,533,857,833,-1,866,715,832,-1,715,866,857,-1,887,530,12,-1,530,887,865,-1,177,537,175,-1,177,538,537,-1,91,526,180,-1,92,526,91,-1,183,705,140,-1,705,183,182,-1,864,819,828,-1,864,822,819,-1,864,799,824,-1,799,864,798,-1,125,825,126,-1,825,125,162,-1,536,188,185,-1,188,536,538,-1,522,187,186,-1,522,525,187,-1,827,817,830,-1,820,817,827,-1,829,141,140,-1,818,141,829,-1,141,520,142,-1,141,622,520,-1,521,815,142,-1,848,815,521,-1,850,813,816,-1,661,813,850,-1,660,812,814,-1,851,812,660,-1,555,517,575,-1,555,518,517,-1,863,807,862,-1,807,863,811,-1,886,191,194,-1,191,886,809,-1,139,75,74,-1,139,138,75,-1,133,675,134,-1,675,133,513,-1,553,138,137,-1,553,514,138,-1,197,886,196,-1,197,862,886,-1,136,130,129,-1,136,134,130,-1,805,555,863,-1,805,554,555,-1,198,79,190,-1,198,200,79,-1,130,199,128,-1,199,130,676,-1,539,124,558,-1,124,539,127,-1,508,792,802,-1,508,505,792,-1,795,507,506,-1,795,869,507,-1,511,861,797,-1,861,511,509,-1,203,861,201,-1,203,869,861,-1,507,860,505,-1,794,860,507,-1,159,557,574,-1,557,159,161,-1,860,101,793,-1,101,860,100,-1,717,790,831,-1,870,790,717,-1,15,787,763,-1,787,15,529,-1,761,785,759,-1,785,761,789,-1,755,784,782,-1,755,757,784,-1,753,777,780,-1,777,753,781,-1,543,885,884,-1,885,543,542,-1,210,214,208,-1,212,214,210,-1,215,211,213,-1,215,217,211,-1,775,216,883,-1,775,217,216,-1,220,491,493,-1,491,220,219,-1,222,121,492,-1,222,122,121,-1,122,112,123,-1,112,122,110,-1,767,882,871,-1,766,882,767,-1,225,773,871,-1,225,224,773,-1,488,770,489,-1,488,882,770,-1,226,119,489,-1,226,117,119,-1,563,485,487,-1,485,563,883,-1,485,228,486,-1,230,228,485,-1,114,483,229,-1,113,483,114,-1,234,483,482,-1,234,231,483,-1,226,560,227,-1,771,560,226,-1,487,560,564,-1,560,487,484,-1,116,215,235,-1,116,115,215,-1,234,480,232,-1,478,480,234,-1,479,207,481,-1,479,205,207,-1,480,241,238,-1,241,480,481,-1,240,477,475,-1,477,240,239,-1,244,111,476,-1,244,109,111,-1,474,243,242,-1,474,471,243,-1,245,473,472,-1,245,248,473,-1,769,469,564,-1,467,469,769,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_7()
		{
			int[] value = {884,468,470,-1,468,884,779,-1,2,760,7,-1,760,2,13,-1,6,756,11,-1,756,6,762,-1,10,752,751,-1,752,10,758,-1,750,778,885,-1,750,754,778,-1,544,466,542,-1,463,466,544,-1,8,464,566,-1,8,465,464,-1,4,746,749,-1,4,9,746,-1,747,462,740,-1,459,462,747,-1,460,872,461,-1,565,872,460,-1,745,859,858,-1,744,859,745,-1,743,474,881,-1,743,472,474,-1,872,252,254,-1,252,872,858,-1,462,458,455,-1,458,462,461,-1,250,457,456,-1,457,250,249,-1,739,457,567,-1,739,455,457,-1,859,734,737,-1,734,859,881,-1,257,742,729,-1,257,256,742,-1,207,730,733,-1,730,207,206,-1,736,260,262,-1,260,736,735,-1,263,732,731,-1,263,261,732,-1,249,726,568,-1,726,249,251,-1,724,603,727,-1,724,725,603,-1,452,259,258,-1,452,454,259,-1,265,453,264,-1,265,451,453,-1,103,210,105,-1,103,266,210,-1,722,103,102,-1,722,265,103,-1,268,791,870,-1,268,267,791,-1,269,714,718,-1,714,269,268,-1,70,533,69,-1,70,716,533,-1,450,84,83,-1,274,84,450,-1,713,271,573,-1,713,272,271,-1,99,278,85,-1,98,278,99,-1,276,854,277,-1,711,854,276,-1,710,700,880,-1,709,700,710,-1,94,86,701,-1,96,86,94,-1,706,97,510,-1,706,93,97,-1,703,576,708,-1,703,577,576,-1,702,856,704,-1,702,855,856,-1,89,580,90,-1,89,448,580,-1,446,516,447,-1,446,517,516,-1,78,189,79,-1,78,279,189,-1,281,443,88,-1,281,444,443,-1,449,87,86,-1,578,87,449,-1,856,286,577,-1,284,286,856,-1,580,698,855,-1,579,698,580,-1,78,287,280,-1,77,287,78,-1,278,291,290,-1,291,278,277,-1,854,695,696,-1,695,854,880,-1,502,581,582,-1,581,502,501,-1,501,81,293,-1,81,501,82,-1,81,437,292,-1,80,437,81,-1,439,294,438,-1,295,294,439,-1,297,842,296,-1,694,842,297,-1,693,873,879,-1,691,873,693,-1,690,434,853,-1,435,434,690,-1,285,687,283,-1,685,687,285,-1,697,683,699,-1,681,683,697,-1,77,679,288,-1,678,679,77,-1,677,433,682,-1,430,433,677,-1,680,300,686,-1,298,300,680,-1,684,428,688,-1,426,428,684,-1,436,304,434,-1,302,304,436,-1,873,674,673,-1,674,873,853,-1,842,306,308,-1,306,842,879,-1,422,305,423,-1,422,303,305,-1,429,310,427,-1,311,310,429,-1,421,301,419,-1,421,299,301,-1,431,314,432,-1,315,314,431,-1,316,416,317,-1,415,416,316,-1,418,318,320,-1,318,418,420,-1,313,672,671,-1,672,313,312,-1,425,668,594,-1,668,425,424,-1,619,412,414,-1,412,619,670,-1,669,323,325,-1,323,669,584,-1,319,667,583,-1,667,319,321,-1,417,76,326,-1,76,417,73,-1,585,328,327,-1,585,878,328,-1,808,852,666,-1,852,808,851,-1,852,663,878,-1,662,663,852,-1,322,656,877,-1,656,322,324,-1,849,850,848,-1,849,658,850,-1,332,849,329,-1,332,877,849,-1,410,738,408,-1,410,748,738,-1,71,587,588,-1,1,587,71,-1,155,586,158,-1,847,586,155,-1,60,652,61,-1,652,60,847,-1,655,641,874,-1,650,641,655,-1,649,404,643,-1,407,404,649,-1,409,334,336,-1,334,409,408,-1,404,644,876,-1,644,404,406,-1,846,69,532,-1,846,67,69,-1,846,642,876,-1,640,642,846,-1,653,636,635,-1,636,653,874,-1,633,845,838,-1,633,638,845,-1,632,273,272,-1,632,634,273,-1,65,402,66,-1,402,65,598,-1,402,338,403,-1,337,338,402,-1,399,338,339,-1,399,401,338,-1,60,340,589,-1,63,340,60,-1,522,628,523,-1,630,628,522,-1,821,59,58,-1,629,59,821,-1,57,591,58,-1,57,592,591,-1,593,55,54,-1,590,55,593,-1,396,331,330,-1,396,397,331,-1,844,53,55,-1,398,53,844,-1,616,397,398,-1,616,621,397,-1,395,620,596,-1,395,392,620,-1,425,343,422,-1,344,343,425,-1,390,393,391,-1,390,394,393,-1,345,391,348,-1,345,52,391,-1,346,350,349,-1,350,346,348,-1,33,595,34,-1,595,33,387,-1,615,844,624,-1,615,617,844,-1,352,623,626,-1,352,354,623,-1,843,625,627,-1,843,614,625,-1,294,384,386,-1,384,294,296,-1,30,843,359,-1,30,32,843,-1,357,399,358,-1,357,400,399,-1,383,48,47,-1,383,339,48,-1,49,381,360,-1,46,381,49,-1,361,381,382,-1,361,362,381,-1,16,380,17,-1,380,16,360,-1,44,17,43,-1,17,44,18,-1,437,37,611,-1,37,437,38,-1};
			return value;
		}
		private int[] getrclavcle_Geo_6_115_coordIndex_8()
		{
			int[] value = {610,378,600,-1,379,378,610,-1,385,365,363,-1,365,385,384,-1,375,24,364,-1,375,22,24,-1,608,377,376,-1,608,875,377,-1,372,599,609,-1,372,374,599,-1,373,35,353,-1,373,36,35,-1,29,613,32,-1,29,367,613,-1,599,370,875,-1,371,370,599,-1,25,16,20,-1,25,27,16,-1,20,369,370,-1,19,369,20,-1,378,23,368,-1,23,378,21,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrclavcle_Coord_7_115_point_1()
		{
			double[] value = {-2.01381,50.81346,.65614,-2.27422,50.74639,.53983,-2.01897,50.85858,.73867,-2.27864,50.80947,.61776,-1.67993,50.85561,.76302,-1.81897,50.83858,.73273,-1.68157,50.86436,.84939,-1.82006,50.86076,.81792,-1.41686,50.86897,.77239,-1.54703,50.86221,.77958,-1.41339,50.84957,.86844,-1.54293,50.85753,.8773,-2.34894,50.70687,.7875,-2.05783,50.76881,.81887,-2.31167,50.77577,.71732,-2.09577,50.68599,.87846,-4.51873,49.85576,-1.02986,-4.53772,49.82239,-.98252,-4.57195,49.80295,-.99794,-4.59912,49.80074,-1.08464,-4.5719,49.85202,-1.10636,-4.68254,49.77978,-1.12931,-4.70399,49.80558,-1.18675,-4.6611,49.78599,-1.14149,-4.72648,49.79991,-1.14087,-4.53435,49.94139,-1.15609,-4.44995,50.00625,-1.1153,-4.48136,49.9449,-1.07948,-4.51206,50.00695,-1.18028,-4.48959,50.06187,-1.1969,-4.40961,50.11468,-1.14754,-4.4275,50.06129,-1.1319,-4.4767,50.1168,-1.20351,-4.7786,50.04592,-1.3027,-4.76115,50.09623,-1.31485,-4.67774,50.10315,-1.28913,-4.69076,50.05046,-1.2839,-4.65798,49.80455,-.95583,-4.6842,49.8227,-.92046,-4.68841,49.81805,-.96034,-4.48888,49.87852,-.76667,-4.56311,49.87671,-.79766,-4.56008,49.84944,-.82821,-4.50887,49.84582,-.86482,-4.54338,49.82579,-.87997,-4.46298,49.8695,-.79283,-4.37466,49.9556,-.88852,-4.3923,50.00555,-1.0197,-4.33431,49.98529,-.88899,-4.42353,49.94461,-.98401,-5.10959,49.85261,-1.18947,-5.12915,49.86205,-1.24737,-5.06316,49.88313,-1.26588,-4.99066,50.22062,-1.3867,-4.85828,50.27041,-1.25343,-4.84053,50.24245,-1.34617,-5.01288,50.23778,-1.27177,-4.58483,50.29808,-1.23972,-4.57006,50.33919,-1.16008,-4.52819,50.30582,-1.20972,-3.99417,50.23033,-.66804,-4.02939,50.11977,-.63457,-4.15724,50.13401,-.83062,-4.14013,50.22709,-.84261,-3.9156,50.02709,-.34158,-4.00213,49.96907,-.26393,-3.98937,49.97183,-.34213,-2.70805,50.105,.61076,-2.44323,50.14695,.68662,-2.7251,50.17942,.68389,-2.4801,50.20882,.77731,-2.51128,50.67127,.42765,-2.52323,50.7545,.49911,-6.05683,49.83262,-1.18564,-6.08451,49.84367,-1.13402,-6.08801,49.8683,-1.15011,-6.05239,49.87334,-1.2023,-5.91958,49.83156,-.70204,-5.92788,49.85908,-.68262,-5.95875,49.86077,-.69026,-4.69944,49.83251,-.88585,-4.65317,49.83934,-.85232,-4.70088,49.85285,-.86496,-4.53934,49.91907,-.72061,-4.51765,49.93277,-.66974,-4.57669,49.92766,-.6352,-5.10984,49.94138,-.7761,-5.14271,49.9254,-.81735,-5.03408,49.92385,-.84625,-5.85346,50.04515,-.67771,-5.76698,50.04716,-.69645,-5.86417,50.09198,-.72716,-5.76975,50.10577,-.74407,-5.14217,49.98542,-.74637,-5.01097,49.94468,-.73563,-5.00321,49.96104,-.70852,-5.11644,49.94631,-.74005,-5.01013,49.99931,-.73722,-4.70869,49.92568,-.61847,-4.62704,49.92434,-.55861};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_2()
		{
			double[] value = {-4.72722,49.94817,-.58425,-4.64663,49.95265,-.53031,-1.56417,50.17213,.96357,-1.43359,50.13396,.9309,-1.55245,50.23488,1.01962,-1.42404,50.18802,.99748,-1.99891,50.18468,.73277,-2.16895,50.18026,.67767,-1.99079,50.20823,.6592,-.90966,50.53117,.20504,-.93412,50.45909,.26378,-.96971,50.44244,.23344,-.89869,50.52809,.23313,-1.09399,50.12639,.70099,-1.07316,50.15651,.71458,-1.10035,50.11013,.77361,-1.1335,50.09262,.72928,-.91319,50.47812,.53752,-.93712,50.43632,.5487,-.90424,50.50206,.50667,-.90847,50.4913,.47012,-.91251,50.44928,.39317,-.92016,50.45869,.33349,-.88482,50.52994,.30408,-4.45227,50.15376,-.49356,-4.26187,50.2368,-.38427,-4.40057,50.22869,-.54412,-4.29362,50.15595,-.34901,-6.04197,49.85091,-.82937,-6.07342,49.87746,-.89265,-6.06845,49.8304,-.90812,-6.0542,49.88588,-.81733,-6.10253,49.82673,-1.04696,-6.09699,49.80395,-1.02458,-6.09105,49.81133,-.97233,-6.11161,49.85119,-1.01676,-6.09617,49.85787,-.95669,-6.11946,49.8698,-1.05649,-6.11388,49.86994,-1.10279,-6.1103,49.8455,-1.08674,-5.26529,50.18966,-.93483,-5.2347,50.21444,-1.07998,-5.35468,50.19382,-1.12698,-3.28495,50.55917,.28396,-3.45147,50.52764,.0388,-3.50581,50.50988,.09496,-3.23782,50.59304,.22206,-3.39617,50.35215,.38417,-3.65644,50.21381,.23424,-3.41881,50.24021,.38348,-3.63432,50.31666,.21676,-3.83466,50.34989,-.01334,-3.97266,50.3748,-.29347,-4.04131,50.32236,-.22097,-3.78391,50.41207,-.06393,-3.60579,50.27727,-.24526,-3.38188,50.43926,-.05823,-3.39192,50.31462,-.07833,-3.59806,50.39553,-.25138,-4.39579,49.95815,-.33589,-4.16709,49.98805,-.15328,-4.38328,50.02802,-.35018,-4.21862,50.30144,-.45095,-4.08083,50.24729,-.17581,-3.39858,50.50971,-.03231,-3.61438,50.46348,-.22526,-3.64446,50.47761,-.20613,-3.60707,50.38622,.19533,-3.87329,50.27559,.03135,-3.43877,50.09523,.37842,-3.19235,50.11908,.48464,-3.17677,50.26655,.51866,-3.09375,50.53585,.47707,-3.06283,50.62078,.44533,-3.33575,50.49686,.33375,-3.80274,50.44717,-.39179,-3.77256,50.43428,-.41115,-3.95503,50.41693,-.6308,-5.94912,50.09587,-.78795,-5.93543,50.07252,-.72282,-5.88369,50.10428,-.79343,-5.5327,50.12447,-.80302,-5.4288,50.11434,-.82475,-5.41162,50.17484,-.91616,-5.54482,50.15346,-.87239,-4.27971,50.34945,-.6987,-4.28825,50.3751,-.908,-4.35881,50.36529,-.80987,-4.16945,50.38855,-.79391,-5.94823,49.9295,-.64187,-5.99299,49.89585,-.67666,-6.08042,50.00574,-1.07545,-6.08846,49.93617,-1.12759,-6.10731,49.93155,-1.07556,-6.09271,49.95248,-1.02958,-6.08121,49.82141,-1.1094,-6.08747,49.92272,-.94804,-6.06995,49.92987,-.85848,-6.01916,49.86965,-.73547,-6.0286,49.82079,-.83621};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_3()
		{
			double[] value = {-5.98487,49.83512,-.74916,-4.86092,50.00194,-.67013,-4.81339,49.96096,-.63272,-4.80795,49.99595,-.63669,-4.85581,49.9673,-.65292,-1.23851,50.11553,.63959,-1.22264,50.18609,.5734,-1.19201,50.19087,.54459,-1.29653,50.2184,.99653,-1.40158,50.26193,1.02088,-1.30749,50.14092,.95024,-1.13715,50.12944,.9052,-1.22029,50.10355,.90653,-1.16488,50.08178,.85954,-1.20955,50.17617,.95348,-1.12094,50.07968,.81229,-1.06594,50.1476,.8054,-1.09333,50.1248,.85801,-.99452,50.31968,.60241,-.96468,50.31426,.53192,-.95059,50.39702,.5352,-.99085,50.28639,.59335,-.94318,50.3997,.36122,-.98177,50.38398,.31792,-.89328,50.5038,.39008,-.87111,50.55329,.43665,-.88538,50.52474,.56669,-.90272,50.46922,.59675,-1.02732,50.25856,.66683,-1.02361,50.2255,.65934,-1.03876,50.19247,.74729,-1.02291,50.23252,.58649,-1.05089,50.23151,.49709,-.99675,50.25972,.52412,-1.08726,50.15594,.59782,-1.15412,50.0604,.76781,-1.14827,50.08589,.68619,-1.21016,50.07534,.70992,-1.07917,50.26212,.41976,-1.11629,50.29885,.35495,-1.05743,50.31107,.35571,-1.13112,50.25031,.44906,-.88371,50.61809,.19457,-.84952,50.64321,.21013,-.94082,50.50403,.19927,-.8193,50.85696,.42607,-.82204,50.86005,.58079,-.78529,50.87437,.54212,-.78718,50.85354,.42531,-1.67789,50.30312,.54189,-1.53207,50.34425,.50334,-1.535,50.3139,.53148,-1.22282,50.60713,.35941,-1.4007,50.44308,.43764,-1.38379,50.56344,.43539,-1.2691,50.45374,.35115,-1.4226,50.28326,.53767,-1.28874,50.27506,.46237,-1.29197,50.23535,.55096,-1.42492,50.23527,.59601,-1.06306,50.39751,.24885,-1.13858,50.33644,.30788,-1.17982,50.37475,.30239,-1.1805,50.3274,.34389,-1.31763,50.08325,.77705,-1.43684,50.10886,.83405,-1.3167,50.0948,.88188,-1.85893,50.23852,.96656,-2.00147,50.28572,.96032,-2.02396,50.19112,.87907,-1.85912,50.17985,.88564,-4.38363,49.93524,-.3507,-4.33454,49.93659,-.40944,-4.15501,49.96409,-.16791,-4.35776,49.94041,-.61809,-4.4013,49.93348,-.56374,-4.7497,49.93448,-.64257,-4.71148,49.92776,-.71532,-4.65808,49.92967,-.69528,-5.91728,49.92768,-.63428,-5.86929,49.88895,-.64628,-4.98223,49.90674,-.91873,-5.03679,49.8995,-.92026,-5.48345,49.89252,-.82189,-5.57207,49.91635,-.73882,-5.60508,49.87618,-.78464,-5.46167,49.9267,-.75912,-5.86108,49.8611,-.66559,-5.88433,49.81636,-.7116,-4.62842,49.90707,-.80082,-4.61353,49.91734,-.75157,-4.66693,49.9153,-.77163,-4.60935,49.82695,-.85398,-4.62543,49.87925,-.83132,-4.80684,49.86046,-.96551,-4.81716,49.88302,-.94114,-4.86031,49.88074,-1.00492,-4.89592,49.89119,-.95443,-5.90369,49.76933,-.95861,-5.81254,49.79367,-1.06179};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_4()
		{
			double[] value = {-5.78433,49.79933,-1.00298,-5.9271,49.75234,-1.03452,-5.45234,49.85507,-1.08868,-5.39984,49.84325,-1.15983,-5.40064,49.84848,-1.10005,-5.47897,49.83547,-1.14402,-4.98516,49.85704,-1.0962,-4.85565,49.84004,-1.16404,-4.90263,49.86877,-1.08831,-4.97454,49.85591,-1.1853,-5.58932,49.82344,-1.20552,-5.7108,49.8148,-1.17774,-5.72142,49.8103,-1.29847,-5.59109,49.84023,-1.30473,-6.01806,49.73949,-1.07825,-6.05624,49.74467,-1.06268,-6.05363,49.78025,-1.11293,-6.02966,49.74476,-1.15183,-5.96067,49.77532,-1.26346,-5.8496,49.84752,-1.39211,-5.845,49.80701,-1.33799,-5.94829,49.83234,-1.30718,-5.57145,50.01918,-1.48393,-5.72245,49.92753,-1.46566,-5.70858,49.98445,-1.46012,-5.58403,49.9662,-1.47942,-6.01296,49.87179,-1.2601,-6.05748,49.905,-1.20458,-5.99894,49.92455,-1.25635,-5.42422,50.15203,-1.45317,-5.32229,50.16412,-1.43674,-5.31692,50.136,-1.4758,-5.43542,50.10166,-1.47838,-2.37623,50.21642,.48704,-2.09669,50.4166,.52413,-2.14495,50.28312,.52678,-2.33355,50.38583,.45581,-4.29176,49.96671,-.71896,-4.23569,49.9847,-.74551,-4.30893,50.02904,-.92537,-4.12635,50.34637,-.8461,-4.23971,50.23776,-.98022,-4.24486,50.33472,-.96056,-5.30266,49.85436,-1.22712,-5.28312,49.88864,-1.29932,-4.95123,49.8703,-1.24446,-4.8209,49.88745,-1.25985,-4.83239,49.85505,-1.22313,-4.92779,49.92418,-1.27896,-4.79129,49.91811,-1.27794,-4.89824,49.95478,-1.29705,-4.7824,49.96283,-1.28819,-4.60191,50.16121,-1.27345,-4.61216,50.10998,-1.27671,-4.6597,50.15588,-1.29563,-4.59252,49.80372,-.90588,-4.60466,49.77937,-.99791,-4.33221,50.16466,-1.08288,-4.34875,50.10377,-1.07195,-4.40299,50.16685,-1.14572,-4.46293,49.89163,-.94432,-4.35408,49.91654,-.69464,-4.43591,49.88186,-.82506,-4.73482,49.82536,-1.09271,-4.77242,49.82608,-1.15617,-4.81953,49.85368,-1.08036,-4.57217,49.99896,-1.22532,-4.56,50.05954,-1.24012,-4.63174,49.77715,-1.0847,-4.63853,49.82656,-1.16404,-4.61119,49.87848,-1.18587,-4.59447,49.93369,-1.20114,-4.70235,50.0037,-1.28094,-4.62519,50.05706,-1.27144,-4.63737,49.99667,-1.25663,-4.74991,49.83161,-1.20208,-4.73851,49.86398,-1.23869,-4.68136,49.84646,-1.20937,-4.65316,49.77113,-1.07254,-4.69087,49.8049,-1.08115,-4.48165,49.85869,-.89716,-4.41385,49.9032,-.84896,-4.3322,49.93739,-.71842,-4.36658,50.0505,-1.05637,-4.82951,49.86616,-1.03433,-4.74489,49.83694,-1.0466,-4.77605,49.8459,-.9949,-4.88294,50.03698,-1.3328,-4.79016,49.99935,-1.29978,-4.90592,49.99126,-1.3087,-5.21765,49.90906,-1.31744,-5.03971,49.93681,-1.30043,-5.21288,49.9984,-1.40988,-5.05186,49.97431,-1.33503,-5.22954,49.94608,-1.35223,-5.02897,50.01933,-1.35904,-5.17555,50.18751,-1.41204,-5.17033,50.15963,-1.45095,-4.98676,50.1761,-1.39814,-4.27341,50.08429,-.95732};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_5()
		{
			double[] value = {-4.25694,50.14504,-.96819,-4.20057,50.03806,-.7771,-4.20143,49.95453,-.55593,-4.14555,49.97113,-.58228,-2.84613,50.13056,.35303,-2.56624,50.32193,.37522,-2.60785,50.16163,.42123,-2.78325,50.26846,.29144,-2.03201,50.5138,.53435,-2.26843,50.48499,.45625,-2.02418,50.56254,.5388,-5.326,50.0877,-1.48633,-5.45711,50.0002,-1.48439,-5.44436,50.05361,-1.48909,-5.34351,50.02734,-1.46929,-6.05363,49.8101,-1.16095,-6.02957,49.77475,-1.1999,-6.01749,49.83082,-1.24338,-5.84184,49.78137,-1.26459,-5.94566,49.74552,-1.11671,-5.95709,49.75182,-1.19042,-5.83117,49.78789,-1.14389,-5.40201,49.8499,-1.23132,-5.48116,49.84123,-1.2155,-5.48298,49.85943,-1.31463,-5.38247,49.88331,-1.30355,-5.66538,49.82456,-1.03577,-5.5722,49.82682,-1.12229,-5.5457,49.84701,-1.06684,-5.69373,49.81961,-1.09444,-6.02651,49.77667,-.92587,-6.04386,49.74657,-.99532,-6.00572,49.74099,-1.01085,-5.98235,49.75869,-.93491,-5.39696,49.85815,-1.03823,-5.43096,49.87399,-.9336,-5.44864,49.86533,-1.02688,-4.65572,49.82008,-.88744,-4.73662,49.83861,-.93648,-4.74693,49.86096,-.91212,-4.70962,49.82498,-1.02809,-4.74075,49.83389,-.97643,-4.84829,49.90002,-.89014,-4.97888,49.92553,-.83098,-4.92701,49.90874,-.90346,-4.8744,49.92168,-.83397,-5.9247,50.02613,-.67341,-5.90823,49.98097,-.63662,-5.86032,49.94144,-.64845,-5.28112,49.94723,-.74835,-4.37984,49.92634,-.66866,-1.43354,50.12712,.74632,-1.29823,50.17713,.62155,-1.31394,50.11062,.68956,-1.43079,50.18478,.66922,-1.64483,50.47192,.54954,-1.54067,50.40432,.50309,-1.68687,50.36172,.53545,-1.52392,50.52435,.49318,-1.60351,50.65211,.59364,-1.48076,50.68086,.57134,-1.50006,50.61765,.51661,-1.62091,50.56757,.56841,-1.14157,50.85579,.56648,-1.30892,50.79918,.62659,-1.27235,50.88366,.74913,-1.11368,50.89425,.72748,-.80453,50.79627,.64877,-.8786,50.60122,.77042,-.84362,50.63911,.71713,-.84132,50.7822,.68701,-.81185,50.73906,.24852,-.82768,50.80998,.31779,-.79555,50.80725,.31783,-.84576,50.71683,.23271,-1.01749,50.36864,.28851,-1.00106,50.41349,.22844,-1.07628,50.35564,.28676,-1.1454,50.12363,.60919,-1.20748,50.1101,.63222,-1.10912,50.19684,.50611,-1.161,50.18627,.53705,-1.10866,50.12139,.65802,-1.04438,50.19595,.64401,-.92762,50.41016,.65876,-.99356,50.27346,.74092,-.98192,50.34203,.66571,-.89772,50.47199,.70898,-.86693,50.56432,.4732,-.87643,50.54858,.53585,-.83869,50.63904,.23917,-.94179,50.35339,.46782,-.93549,50.38926,.42074,-.92768,50.43687,.47286,-.98101,50.35896,.61427,-.92659,50.42791,.60847,-1.23944,50.07299,.85608,-1.24005,50.06681,.75031,-1.18386,50.05427,.80935,-2.39254,50.14701,.57195};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_6()
		{
			double[] value = {-2.16245,50.19552,.60143,-4.67321,49.89283,-.84392,-4.7484,49.88147,-.89123,-4.90996,49.96367,-.67469,-4.91502,49.99826,-.69192,-4.6976,50.04812,-.61215,-4.7112,50.10156,-.67335,-4.74162,50.04285,-.63206,-4.65674,50.11169,-.63819,-4.92198,50.03712,-.72065,-5.00085,50.08421,-.77947,-4.89299,50.08833,-.7598,-6.0758,49.79828,-1.08692,-6.07834,49.76287,-1.03671,-6.11206,49.895,-1.10026,-6.09312,49.89996,-1.15239,-5.95755,49.9639,-.64237,-5.97399,50.00889,-.67917,-6.00738,49.95269,-.68347,-6.00235,49.92994,-.67709,-5.31708,50.18561,-1.34472,-5.41935,50.1737,-1.36082,-4.36648,50.37475,-.9943,-4.43901,50.36071,-1.06491,-4.48253,50.36601,-.94292,-4.43755,50.36311,-.89568,-5.78932,50.11866,-.8103,-5.65246,50.1144,-.77195,-5.66465,50.14201,-.84125,-2.13688,50.5937,.92829,-2.38652,50.61419,.81854,-2.94097,50.294,.62764,-2.95595,50.14495,.59315,-2.71411,50.31063,.73952,-3.55729,50.44719,.14531,-3.69963,50.45608,-.14918,-4.1488,50.35768,-.5244,-3.88707,50.42343,-.37984,-4.03948,50.39276,-.6187,-4.33253,50.0891,-.32902,-4.11186,50.16709,-.14092,-4.11603,50.05032,-.13234,-.98118,50.89419,.67699,-.89135,50.8672,.62074,-1.00786,50.87006,.51689,-.88857,50.8628,.46556,-3.18536,50.57173,.1515,-3.16604,50.49059,.09417,-3.89632,50.17442,.04901,-3.36972,50.42273,.36302,-2.8306,50.65837,.56846,-3.01605,50.65333,.38386,-2.79228,50.70605,.49986,-6.11763,49.89488,-1.05397,-6.0363,49.9278,-.72995,-6.01986,49.97761,-.72378,-6.03129,49.90513,-.72358,-4.51658,50.02463,-.45635,-4.49136,50.08706,-.47351,-.96784,50.34358,.40917,-.87591,50.53055,.628,-1.00646,50.32973,.36626,-.81684,50.68865,.28126,-.90882,50.45408,.76292,-.84605,50.59363,.67844,-1.33737,50.72673,.5228,-1.45456,50.76571,.65343,-1.82151,50.33452,.5589,-1.70175,50.2754,.5872,-1.8445,50.25755,.59003,-1.70835,50.15345,.79905,-1.71018,50.15651,.88198,-1.85659,50.16209,.80755,-4.50976,49.92611,-.47019,-4.52924,49.95503,-.44203,-5.9864,50.03441,-.71957,-5.30661,49.98668,-.75489,-5.44253,49.98437,-.74501,-5.31372,49.93075,-.78979,-5.793,49.87492,-.67675,-5.77403,49.94313,-.66709,-4.69271,49.91148,-.82345,-4.76793,49.89991,-.8707,-5.84051,49.89991,-1.41438,-5.72887,49.87765,-1.43694,-6.05289,49.95756,-1.18119,-3.79852,50.36467,-.45138,-2.29342,50.57317,.47619,-2.53022,50.48988,.37569,-3.9806,50.35147,-.6716,-4.71569,50.27088,-1.29908,-4.61716,50.32527,-1.18596,-4.63166,50.28486,-1.26586,-4.73298,50.29932,-1.2068,-5.37294,49.92197,-1.37623,-4.86554,50.08692,-1.3449,-5.01039,50.07319,-1.3875,-4.32946,50.23663,-1.07716,-4.21542,49.94763,-.47676,-4.64972,49.94493,-1.24583};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_7()
		{
			double[] value = {-4.6415,49.77755,-1.01495,-1.9836,50.23789,.58568,-1.83839,50.23119,.66522,-1.69635,50.23679,.65879,-1.84707,50.19565,.73618,-2.02183,50.16092,.8036,-2.04833,50.64776,.57105,-1.85277,50.69263,.63175,-4.72358,49.90731,-1.2599,-4.71471,49.95195,-1.27011,-4.67927,49.81155,-1.02352,-4.62957,49.80168,-.92275,-4.40027,50.23846,-1.13996,-4.54712,50.11423,-1.24671,-4.53684,50.16569,-1.2435,-4.74316,50.14865,-1.32129,-4.99325,50.12865,-1.40256,-4.84834,50.14292,-1.36002,-5.28333,49.84589,-1.16901,-5.35622,49.97332,-1.43393,-5.19433,50.05152,-1.43831,-5.1767,50.11247,-1.45548,-5.19817,50.20607,-1.29671,-4.64753,50.21711,-1.2855,-4.73141,50.20373,-1.31888,-4.53313,50.22997,-1.23327,-4.58969,50.2227,-1.26338,-4.46636,50.23337,-1.1915,-4.40696,50.31965,-1.12824,-4.47307,50.31401,-1.17971,-4.33474,50.33233,-1.0573,-4.07193,50.02566,-.58159,-4.25852,49.94237,-.42282,-3.86896,49.99305,.01205,-4.07892,49.96884,-.18118,-3.7929,49.98982,-.0699,-3.57372,50.01042,.08155,-3.41937,50.02355,.32114,-3.64664,50.00624,.18425,-3.34681,50.02665,.21891,-3.17231,50.04613,.42729,-3.28422,50.09178,.14203,-3.12898,50.04299,.33934,-3.06711,50.1082,.26286,-2.65758,50.08782,.49669,-1.96095,50.30945,.54844,-1.91253,50.44248,.55919,-2.74738,50.43508,.28676,-3.17501,50.3622,.07399,-3.00319,50.24508,.20076,-3.21595,50.2184,.0874,-2.96346,50.39075,.18778,-3.84142,50.13746,-.41204,-3.71948,50.04842,-.14754,-3.64648,50.15796,-.21735,-3.43158,50.19366,-.05068,-5.69269,50.04203,-1.44295,-5.78627,50.08726,-1.3442,-5.66598,50.11314,-1.40135,-5.81283,50.01574,-1.38596,-5.87737,50.09316,-1.13595,-5.75458,50.12319,-1.21623,-5.90942,50.05401,-1.26358,-5.91135,49.99639,-1.30284,-5.8268,49.95662,-1.40868,-5.92532,49.93685,-1.32557,-6.04497,50.02662,-1.12895,-5.93944,49.88397,-1.32925,-5.47338,49.89724,-1.38738,-5.59057,49.91565,-1.45057,-5.46979,49.94663,-1.44909,-5.5942,49.86692,-1.38884,-5.72441,49.83607,-1.3827,-5.12032,49.85506,-1.10026,-5.28409,49.85018,-1.10927,-6.07245,49.76994,-.9844,-6.05504,49.8006,-.91503,-5.99686,49.79651,-.846,-5.9531,49.81056,-.75895,-5.91789,49.79562,-.76849,-5.87818,49.78339,-.87839,-5.84338,49.80006,-.79187,-5.95265,49.77814,-.85506,-5.74273,49.82766,-.82363,-5.64346,49.83678,-.95893,-5.62745,49.85039,-.85971,-5.75885,49.81201,-.92276,-5.50584,49.86816,-.89694,-5.52371,49.85791,-.99007,-5.14554,49.89948,-.89124,-5.33151,49.87414,-.9269,-5.14125,49.87841,-.96581,-5.33562,49.89781,-.85249,-5.01781,49.88612,-.97149,-4.96323,49.89371,-.96996,-4.79401,49.92125,-.81456,-4.73116,49.91993,-.79429,-5.81641,49.83034,-.72262,-5.68289,49.89754,-.70845,-5.71568,49.85703,-.75447};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_8()
		{
			double[] value = {-4.90001,49.93525,-.77458,-5.00437,49.9402,-.77168,-5.64984,50.05486,-.72423,-5.43529,50.05236,-.77162,-5.5391,50.06329,-.74992,-5.28267,50.12669,-.84324,-5.13293,50.06921,-.78855,-5.11618,50.14251,-.85038,-5.29927,50.05531,-.78155,-4.91787,49.94716,-.70168,-4.84204,49.94456,-.68391,-4.79965,49.93823,-.66369,-4.76826,49.95694,-.60832,-4.46028,49.92905,-.52929,-2.20536,50.32318,.91909,-2.44856,50.4403,.86316,-2.46889,50.33533,.8407,-2.18505,50.42316,.95323,-2.22829,50.21377,.84825,-2.19159,50.16586,.74925,-1.7103,50.20319,.96806,-1.69829,50.27339,1.02032,-1.56788,50.13532,.86911,-1.56559,50.14351,.78549,-1.56333,50.1914,.70588,-1.69833,50.19783,.73017,-1.55893,50.28055,.57593,-1.56083,50.2405,.63787,-1.28584,50.36444,.36626,-1.28632,50.31821,.41005,-1.20768,50.23474,.5008,-1.20415,50.27814,.41462,-1.16228,50.28798,.37746,-1.17699,50.24059,.47299,-.96062,50.61011,.22029,-1.01821,50.49212,.22491,-1.1346,50.47257,.27728,-1.08885,50.62298,.28827,-1.88355,50.53838,.56741,-1.77941,50.44606,.5652,-1.75041,50.53998,.58117,-1.41741,50.35478,.45616,-1.42051,50.32183,.48212,-.90542,50.81441,.34624,-1.02548,50.8169,.39703,-1.16897,50.79615,.46087,-1.57686,50.74787,.67105,-1.73301,50.62774,.59963,-1.87561,50.58632,.57653,-1.71045,50.7247,.66305,-1.11352,50.83372,.83443,-1.27137,50.83701,.86126,-1.29363,50.67812,.93963,-1.19277,50.48297,.95668,-1.15189,50.6465,.91075,-1.33462,50.51914,.99343,-1.57239,50.72969,.94895,-1.46707,50.56465,1.00692,-1.43518,50.70261,.95884,-1.60404,50.59865,1.00658,-1.8595,50.75601,.88728,-1.74894,50.63525,.98032,-1.71057,50.74845,.93055,-1.89757,50.65096,.94617,-.94376,50.42119,.82055,-.79092,50.80231,.54223,-.79283,50.78511,.42549,-.80052,50.75406,.35088,-1.02823,50.27912,.42964,-.80689,50.75095,.61203,-.84254,50.64018,.52975,-.85858,50.58606,.59807,-.97408,50.3087,.45697,-.86283,50.57727,.34586,-1.00001,50.42309,.87126,-1.03198,50.23427,.84902,-1.08827,50.23891,.90227,-1.16037,50.28754,.95243,-1.03259,50.62054,.86401,-.94169,50.60175,.82173,-1.09092,50.44446,.91525,-1.26269,50.32681,.99424,-1.36747,50.3726,1.01786,-1.67703,50.36857,1.03817,-1.49992,50.41927,1.03811,-1.64713,50.47659,1.03064,-1.52973,50.31287,1.04119,-1.93901,50.55174,.98517,-1.82263,50.41763,1.02426,-1.792,50.51605,1.01304,-1.9695,50.45472,1.00464,-1.8439,50.31935,1.01347,-4.613,50.06344,-.55553,-4.63824,50.0017,-.53845,-4.76282,49.99194,-.6123,-4.76265,50.09899,-.70333,-4.76662,50.17817,-.80525,-4.81704,50.09812,-.73466,-4.71234,50.17911,-.77383,-4.64923,50.18626,-.73777};
			return value;
		}
		private double[] getrclavcle_Coord_7_115_point_9()
		{
			double[] value = {-4.59483,50.19669,-.70258,-4.52022,50.20201,-.63226,-4.57213,50.12749,-.58162,-4.97063,50.16105,-.84679,-4.86281,50.16608,-.8271,-6.05044,49.93907,-.78346,-6.103,49.91588,-1.008,-6.02167,50.05765,-.86832,-6.0203,50.06913,-1.02677,-6.06106,50.03467,-.99616,-5.98111,50.0909,-.89878,-6.00012,50.05718,-.78467,-5.91585,50.09974,-.90411,-5.70078,50.13939,-.97953,-5.82538,50.11406,-.94862,-5.44195,50.18503,-1.07217,-5.57531,50.16015,-1.02823,-4.89696,50.27843,-1.06494,-5.05201,50.24786,-1.08284,-4.65686,50.33043,-1.03874,-4.77297,50.30533,-1.0593,-4.5149,50.34756,-1.13015,-4.55902,50.35125,-1.00758,-4.51046,50.30409,-.7926,-4.55574,50.30611,-.83956,-4.3565,50.29533,-.61141,-4.43622,50.30875,-.722,-4.81292,50.26509,-.92855,-4.71683,50.27848,-.90666,-5.0826,50.21948,-.93765,-4.93695,50.24029,-.93418,-2.16844,50.50471,.94806,-2.41777,50.52911,.84905,-2.91988,50.40757,.64062,-3.12748,50.46116,.50597,-3.15487,50.38014,.51972,-2.89269,50.48892,.62723,-2.86129,50.57351,.59982,-3.89976,50.05645,.05749,-2.96215,50.66262,.28889,-2.73861,50.71426,.40511,-2.55552,50.73539,.60349,-4.92764,49.88289,-1.02045,-4.47011,50.16874,-1.20166,-4.83666,50.1977,-1.35754,-3.67757,50.07187,.22938,-2.93909,50.06833,.52006,-3.80697,50.24874,-.44524,-5.50713,50.16068,-1.3055,-5.54428,50.12742,-1.44162,-5.62895,50.14838,-1.26513,-5.96809,50.07585,-1.09119,-5.99229,50.03547,-1.19383,-5.29749,49.8596,-1.03155,-4.76138,49.93146,-.7365,-5.6636,49.96632,-.69906,-5.55313,49.97385,-.72457,-2.69321,50.42403,.75382,-1.19572,50.70953,.39395,-1.05154,50.7357,.32863,-4.71881,49.99699,-.59237,-4.84603,50.04645,-.69548,-6.05556,49.98908,-.86096,-6.03399,49.98913,-.7773,-4.61873,50.2985,-.87571,-2.63134,50.59616,.70753,-2.6627,50.51069,.73274,-2.72714,50.62443,.33116,-2.94302,50.57826,.23161,-4.79312,50.04037,-.662,-1.98633,50.37338,1.00054,-.84075,50.62792,.39265,-1.35628,50.67047,.46535,-5.13363,49.86307,-1.02263,-3.50105,50.06858,.00444,-4.66648,49.88961,-1.23051,-2.89565,50.06524,.43214,-5.55533,50.07696,-1.467,-5.99435,49.97691,-1.23297,-5.01019,49.8717,-1.02829,-4.82426,49.93296,-.75674,-.92397,50.72022,.26045,-.83305,50.65491,.46693,-1.00456,50.25884,.80013,-.90442,50.77956,.73618,-.99424,50.8131,.79503,-6.07308,49.98208,-.95047,-2.59407,50.68439,.66849};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrccart_Geo_6_120_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,4,-1,4,0,2,-1,4,5,0,-1,6,7,8,-1,6,9,7,-1,10,11,12,-1,13,14,15,-1,15,16,13,-1,17,18,19,-1,19,20,17,-1,21,22,23,-1,23,24,21,-1,20,25,26,-1,26,23,20,-1,27,28,22,-1,22,21,27,-1,29,30,31,-1,29,32,30,-1,33,34,35,-1,33,36,34,-1,17,28,7,-1,17,22,28,-1,37,38,39,-1,39,40,37,-1,41,27,21,-1,21,42,41,-1,43,41,42,-1,42,44,43,-1,45,25,20,-1,20,19,45,-1,26,46,24,-1,24,23,26,-1,47,42,24,-1,42,21,24,-1,23,22,20,-1,22,17,20,-1,15,39,16,-1,15,40,39,-1,48,45,19,-1,19,49,48,-1,2,1,31,-1,31,30,2,-1,11,9,50,-1,9,6,50,-1,37,51,38,-1,51,52,38,-1,53,54,3,-1,3,2,53,-1,55,56,57,-1,55,58,56,-1,59,60,61,-1,61,62,59,-1,38,62,61,-1,38,52,62,-1,63,64,65,-1,63,66,64,-1,9,18,17,-1,17,7,9,-1,67,29,68,-1,29,67,32,-1,69,70,71,-1,70,69,72,-1,73,74,75,-1,73,5,74,-1,76,1,0,-1,31,1,76,-1,30,53,2,-1,77,53,30,-1,10,9,11,-1,18,9,10,-1,78,55,57,-1,79,55,78,-1,80,78,77,-1,81,78,80,-1,82,12,79,-1,83,12,82,-1,84,85,86,-1,84,44,85,-1,87,88,89,-1,86,88,87,-1,90,35,91,-1,90,33,35,-1,91,16,39,-1,16,91,35,-1,75,15,92,-1,75,40,15,-1,44,47,85,-1,44,42,47,-1,46,47,24,-1,46,93,47,-1,90,87,33,-1,90,94,87,-1,95,49,83,-1,95,48,49,-1,72,73,70,-1,72,76,73,-1,96,81,80,-1,96,97,81,-1,98,83,82,-1,98,95,83,-1,63,90,60,-1,90,63,94,-1,97,82,81,-1,97,98,82,-1,49,18,10,-1,49,19,18,-1,65,44,84,-1,65,43,44,-1,61,39,38,-1,39,61,91,-1,84,63,65,-1,94,63,84,-1,96,32,67,-1,32,96,80,-1,29,76,72,-1,31,76,29,-1,37,75,74,-1,75,37,40,-1,70,75,92,-1,70,73,75,-1,33,89,36,-1,87,89,33,-1,85,93,99,-1,47,93,85,-1,16,34,13,-1,35,34,16,-1,92,14,100,-1,15,14,92,-1,60,91,61,-1,91,60,90,-1,86,99,88,-1,85,99,86,-1,94,86,87,-1,94,84,86,-1,83,10,12,-1,49,10,83,-1,81,79,78,-1,82,79,81,-1,80,30,32,-1,80,77,30,-1,79,11,55,-1,12,11,79,-1,77,57,53,-1,78,57,77,-1,76,5,73,-1,76,0,5,-1,71,92,100,-1,92,71,70,-1,68,72,69,-1,72,68,29,-1,101,7,28,-1,101,8,7,-1,102,28,27,-1,102,101,28,-1,65,103,43,-1,65,64,103,-1,60,66,63,-1,60,59,66,-1,41,103,104,-1,103,41,43,-1,50,55,11,-1,50,58,55,-1,54,57,56,-1,57,54,53,-1,5,51,74,-1,5,4,51,-1,104,27,41,-1,104,102,27,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrccart_Coord_7_120_point_1()
		{
			double[] value = {-.96629,49.61288,.75508,-.96713,49.61354,.75403,-.97414,49.63194,.70638,-.96883,49.63394,.7075,-.96042,49.61778,.75693,-.96652,49.61252,.75567,-1.15693,50.06191,.53319,-1.18634,50.08696,.56425,-1.18697,50.07543,.57026,-1.15449,50.06967,.52303,-1.21565,50.08259,.47404,-1.09735,49.96588,.51358,-1.20893,50.04129,.4677,-1.69806,49.59253,.81894,-1.7258,49.55703,.78969,-1.47268,49.58174,.83312,-1.47071,49.6126,.86638,-1.28681,50.15238,.53858,-1.25116,50.14738,.49222,-1.35818,50.21213,.45505,-1.39273,50.19699,.50305,-1.33258,50.14011,.62075,-1.30868,50.15129,.57609,-1.40715,50.17914,.5339,-1.42943,50.15059,.58034,-1.48067,50.22651,.44403,-1.50011,50.18597,.47872,-1.25453,50.10315,.66376,-1.21969,50.10208,.6064,-1.39978,49.64155,.67839,-1.16318,49.67305,.66143,-1.17664,49.62935,.71856,-1.36586,49.71264,.61238,-1.51503,49.80687,.8113,-1.66879,49.6631,.8208,-1.49833,49.67299,.85848,-1.63837,49.77337,.77375,-.97372,49.59828,.83912,-1.01794,49.61434,.8835,-1.23913,49.61877,.88658,-1.21603,49.59546,.84776,-1.27149,50.10367,.69159,-1.35683,50.12521,.65151,-1.27862,50.10274,.70217,-1.36574,50.10679,.66981,-1.46537,50.24793,.41202,-1.52511,50.13375,.53324,-1.44349,50.13513,.5937,-1.46173,50.23817,.39941,-1.33819,50.17287,.43582,-1.09415,49.95375,.52211,-.96511,49.60486,.83621,-1.00875,49.62175,.87709,-.9708,49.71258,.63049,-.97005,49.71385,.63399,-1.05794,49.83984,.5419,-1.03069,49.7767,.57492,-1.03053,49.77566,.57352,-1.05842,49.84074,.54583,-1.256,49.85246,.83934,-1.25817,49.85197,.84374,-1.15049,49.65712,.8796,-1.13572,49.66889,.87267,-1.30026,49.95615,.80651,-1.2883,50.06016,.74858,-1.29398,50.06576,.75124,-1.2958,49.95576,.8009,-1.56674,49.74805,.56524,-1.62141,49.65013,.63455,-1.68097,49.57861,.69613,-1.45914,49.57858,.75386,-1.71059,49.54878,.73049,-1.43826,49.6004,.72467,-1.20615,49.601,.76312,-.97149,49.59807,.83868,-1.21758,49.58906,.83711,-1.19521,49.61258,.74451,-1.14803,49.75972,.58548,-1.18239,49.83628,.52881,-1.19278,49.91828,.49333,-1.33713,49.79749,.54558,-1.34389,49.88787,.49125,-1.33976,49.98311,.45167,-1.33625,50.11474,.42532,-1.38885,50.04858,.7343,-1.45914,50.09932,.6278,-1.48885,50.02389,.70376,-1.50861,49.92052,.76509,-1.58089,49.99075,.66672,-1.60681,49.89241,.72803,-1.3837,49.83469,.835,-1.32133,49.67331,.87813,-1.47651,49.56864,.81214,-1.52557,50.13274,.53442,-1.40137,49.94499,.79115,-1.46183,50.18308,.38948,-1.5242,49.83152,.51011,-1.50095,49.93773,.45536,-1.48331,50.04381,.41349,-1.54351,50.08643,.57736};
			return value;
		}
		private double[] getrccart_Coord_7_120_point_2()
		{
			double[] value = {-1.73245,49.54097,.76501,-1.21861,50.09075,.60888,-1.25201,50.09243,.66515,-1.27451,50.09274,.70444,-1.26665,50.09331,.68996};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrccart2_Geo_6_125_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,0,-1,4,5,6,-1,7,8,9,-1,10,11,12,-1,10,13,11,-1,13,14,11,-1,12,15,10,-1,2,16,17,-1,9,18,19,-1,9,20,18,-1,21,22,23,-1,23,24,21,-1,25,26,27,-1,25,28,26,-1,11,14,29,-1,30,31,32,-1,31,33,32,-1,34,35,36,-1,36,37,34,-1,38,39,40,-1,41,42,34,-1,43,44,45,-1,45,46,43,-1,12,39,15,-1,47,48,49,-1,49,50,47,-1,51,52,53,-1,53,54,51,-1,40,55,56,-1,57,47,50,-1,50,58,57,-1,6,59,60,-1,59,61,60,-1,17,62,5,-1,17,63,62,-1,64,65,66,-1,64,67,65,-1,49,48,68,-1,68,69,49,-1,53,52,70,-1,52,71,70,-1,35,72,73,-1,40,39,74,-1,67,45,75,-1,45,76,75,-1,41,34,37,-1,37,77,41,-1,54,53,57,-1,57,78,54,-1,79,60,61,-1,79,80,60,-1,81,0,82,-1,31,83,10,-1,10,33,31,-1,24,81,82,-1,24,23,81,-1,84,22,21,-1,84,85,22,-1,8,86,20,-1,20,9,8,-1,10,83,13,-1,83,87,13,-1,16,2,1,-1,49,88,25,-1,25,50,49,-1,33,10,15,-1,15,89,33,-1,11,8,7,-1,7,12,11,-1,3,82,0,-1,17,4,2,-1,17,5,4,-1,84,43,90,-1,43,84,44,-1,19,7,9,-1,19,91,7,-1,33,92,32,-1,92,33,89,-1,58,25,27,-1,50,25,58,-1,80,49,69,-1,80,88,49,-1,3,24,82,-1,93,24,3,-1,35,42,72,-1,42,35,34,-1,51,40,56,-1,54,40,51,-1,38,15,39,-1,15,38,89,-1,29,8,11,-1,29,86,8,-1,90,85,84,-1,90,94,85,-1,28,80,79,-1,80,28,88,-1,53,47,57,-1,53,70,47,-1,95,48,96,-1,48,95,68,-1,97,41,77,-1,97,98,41,-1,76,73,75,-1,99,73,76,-1,64,45,67,-1,64,46,45,-1,100,40,74,-1,100,55,40,-1,72,75,73,-1,72,101,75,-1,98,102,103,-1,95,102,98,-1,96,71,104,-1,70,71,96,-1,91,74,7,-1,74,91,100,-1,78,58,92,-1,78,57,58,-1,56,64,66,-1,56,55,64,-1,105,99,76,-1,105,93,99,-1,4,97,77,-1,4,106,97,-1,29,13,87,-1,29,14,13,-1,63,16,107,-1,63,17,16,-1,1,107,16,-1,107,1,108,-1,108,0,81,-1,108,1,0,-1,106,68,97,-1,69,68,106,-1,2,77,37,-1,2,4,77,-1,3,37,36,-1,2,37,3,-1,36,93,3,-1,99,93,36,-1,65,75,101,-1,75,65,67,-1,78,89,38,-1,78,92,89,-1,39,7,74,-1,39,12,7,-1,100,43,46,-1,100,91,43,-1,102,96,104,-1,96,102,95,-1,41,103,42,-1,98,103,41,-1,44,76,45,-1,44,105,76,-1,46,55,100,-1,55,46,64,-1,35,99,36,-1,35,73,99,-1,98,68,95,-1,68,98,97,-1,48,70,96,-1,47,70,48,-1,32,26,30,-1,27,26,32,-1,94,19,18,-1,19,94,90,-1,40,78,38,-1,40,54,78,-1,93,21,24,-1,105,21,93,-1,69,60,80,-1,106,60,69,-1,58,32,92,-1,58,27,32,-1,90,91,19,-1,91,90,43,-1,105,84,21,-1,44,84,105,-1,59,5,62,-1,5,59,6,-1,106,6,60,-1,6,106,4,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrccart2_Coord_7_125_point_1()
		{
			double[] value = {-.51104,48.90251,1.54776,-.51197,48.90515,1.54436,-.68146,48.83524,1.56582,-.67686,48.79861,1.5927,-.70093,48.89317,1.51428,-.53034,48.9442,1.50683,-.53239,48.94818,1.50426,-.62762,48.76046,1.37622,-.46013,48.91891,1.24701,-.45548,48.9044,1.25184,-.46762,48.9478,1.23421,-.44627,48.94824,1.24517,-.62446,48.82095,1.34371,-.4375,48.95283,1.24177,-.4372,48.95172,1.24242,-.63146,48.85004,1.32786,-.52309,48.91158,1.53296,-.52371,48.91501,1.52944,-.42712,48.66816,1.38841,-.42807,48.66594,1.38531,-.45889,48.9052,1.25534,-.55843,48.46049,1.72365,-.55017,48.46493,1.71603,-.50347,48.63907,1.68346,-.50831,48.64006,1.69008,-.67705,49.22949,1.15073,-.62756,49.21756,1.13004,-.62922,49.21597,1.12386,-.65909,49.22371,1.14858,-.44655,48.94706,1.24623,-.56904,49.15668,1.14694,-.46577,48.96077,1.22377,-.57432,49.1595,1.14232,-.47021,48.95791,1.2246,-1.30144,48.73956,1.5941,-1.30217,48.68393,1.62122,-.8231,48.73479,1.61335,-.82069,48.77545,1.58567,-.78093,48.77759,1.38607,-.78119,48.76382,1.39294,-1.2589,48.68881,1.42258,-1.31452,48.782,1.5702,-1.76555,48.7519,1.543,-.67886,48.51265,1.54428,-.71716,48.46524,1.63117,-.8888,48.47139,1.62992,-.85247,48.49927,1.54935,-.86888,48.99215,1.33814,-.86735,48.99492,1.34259,-.76616,49.08257,1.28432,-.76165,49.08558,1.26208,-1.62511,48.85946,1.32708,-1.63504,48.89603,1.3393,-1.32235,48.90242,1.37304,-1.2934,48.85835,1.37281,-1.26578,48.6073,1.46192,-1.6525,48.64739,1.3839,-.85044,48.98075,1.32365,-.73619,49.06144,1.25495,-.53096,48.94429,1.49984,-.61786,49.1163,1.33129,-.611,49.11123,1.32653,-.52821,48.9382,1.50408,-.52089,48.91256,1.52529,-1.31131,48.49637,1.5457,-1.80642,48.52899,1.57104,-1.72472,48.53969,1.47995,-1.35851,48.46409,1.63508,-.86833,48.97201,1.38645,-.75589,49.04844,1.33982,-1.33777,48.92304,1.39044,-1.65356,48.92231,1.37124,-1.8049,48.63471,1.58879,-1.31376,48.5959,1.65237,-.78772,48.74987,1.40012,-1.35362,48.50482,1.66232,-.87398,48.50099,1.67599,-.8422,48.83712,1.53422,-.82682,48.93739,1.3315,-.64207,49.18903,1.2213,-.65219,49.19706,1.21999,-.50922,48.89591,1.54554,-.5174,48.88482,1.55865,-.46756,48.94959,1.23475,-.60801,48.41396,1.64374,-.59745,48.42395,1.64211,-.4598,48.91857,1.24969,-.44856,48.95035,1.24457,-.67139,49.23146,1.14883,-.65186,48.90102,1.30584,-.48742,48.47488,1.50191,-.64012,48.63387,1.45146,-.69622,48.9979,1.27058,-.69095,48.61663,1.67273,-.48474,48.4787,1.50714,-1.33734,48.92144,1.43114,-1.34576,48.92981,1.4077,-.8584,48.91597,1.46177,-1.32177,48.8746,1.49656,-.8393,48.60341,1.67238};
			return value;
		}
		private double[] getrccart2_Coord_7_125_point_2()
		{
			double[] value = {-.79515,48.6189,1.46797,-1.82051,48.55459,1.58897,-1.67198,48.93096,1.40169,-1.70992,48.87821,1.46631,-1.6723,48.93113,1.40109,-.71334,48.50437,1.68113,-.73248,48.98025,1.42465,-.51964,48.9078,1.53023,-.51018,48.89956,1.54142};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrrib_Geo_6_130_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,3,9,10,-1,10,4,3,-1,11,12,13,-1,11,14,12,-1,15,0,16,-1,15,17,0,-1,12,18,19,-1,6,20,21,-1,6,22,20,-1,23,24,25,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,36,38,37,-1,39,40,41,-1,42,43,44,-1,40,35,45,-1,46,47,38,-1,48,49,50,-1,23,51,42,-1,52,53,54,-1,20,55,21,-1,38,56,46,-1,57,58,59,-1,59,60,57,-1,61,62,63,-1,62,64,63,-1,65,66,67,-1,65,68,66,-1,69,70,71,-1,71,72,69,-1,29,63,73,-1,29,31,63,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,79,81,80,-1,82,83,84,-1,84,85,82,-1,86,87,88,-1,88,89,86,-1,79,90,81,-1,91,75,92,-1,91,76,75,-1,93,94,95,-1,96,55,20,-1,96,97,55,-1,98,99,100,-1,99,101,100,-1,102,103,104,-1,103,105,104,-1,106,107,108,-1,107,109,108,-1,110,111,112,-1,110,113,111,-1,114,115,116,-1,117,118,119,-1,117,120,118,-1,121,118,122,-1,123,124,60,-1,123,125,124,-1,126,127,128,-1,126,129,127,-1,130,131,132,-1,130,133,131,-1,134,133,135,-1,133,130,135,-1,136,137,111,-1,137,138,111,-1,139,140,141,-1,142,143,144,-1,143,145,144,-1,146,140,147,-1,146,141,140,-1,148,149,150,-1,150,151,148,-1,152,153,154,-1,153,155,154,-1,156,157,158,-1,157,159,158,-1,160,161,162,-1,163,157,161,-1,161,164,163,-1,165,166,167,-1,167,168,165,-1,155,169,154,-1,155,170,169,-1,171,172,173,-1,174,175,176,-1,174,177,175,-1,178,179,180,-1,179,181,180,-1,182,140,139,-1,139,183,182,-1,173,184,185,-1,185,143,142,-1,142,186,185,-1,187,188,189,-1,187,186,188,-1,190,191,120,-1,192,92,193,-1,192,194,92,-1,145,195,144,-1,145,196,195,-1,184,173,172,-1,158,177,197,-1,158,175,177,-1,198,199,200,-1,201,202,203,-1,204,205,206,-1,207,4,208,-1,208,209,207,-1,210,211,212,-1,211,213,212,-1,48,70,214,-1,48,50,70,-1,215,95,94,-1,216,217,218,-1,219,220,95,-1,95,221,219,-1,222,223,224,-1,223,215,224,-1,66,51,225,-1,225,67,66,-1,226,227,228,-1,226,229,227,-1,230,231,232,-1,232,233,230,-1,226,232,234,-1,226,235,232,-1,236,237,205,-1,205,204,236,-1,238,239,240,-1,241,242,243,-1,244,245,246,-1,246,247,244,-1,248,249,250,-1,248,251,249,-1,201,252,253,-1,254,246,245,-1,254,255,246,-1,256,257,253,-1,253,258,256,-1,259,260,261,-1,259,262,260,-1,263,251,248,-1,202,263,199,-1,97,264,265,-1,265,266,97,-1,267,268,269,-1,269,270,267,-1,241,263,271,-1,98,272,273,-1,272,274,273,-1,275,276,277,-1,276,278,277,-1,235,228,279,-1,235,226,228,-1,218,280,231,-1,229,281,227,-1,217,282,93,-1,93,283,217,-1,284,225,22,-1,205,237,285,-1,285,286,205,-1,72,59,58,-1,58,69,72,-1,187,171,173,-1,187,287,171,-1,230,216,218,-1,97,25,264,-1,97,96,25,-1,288,289,290,-1,291,80,292,-1,291,293,80,-1,87,294,295,-1,295,296,87,-1,294,297,298,-1,125,299,300,-1,125,123,299,-1,130,301,135,-1,130,302,301,-1,110,59,72,-1,110,123,59,-1,220,218,283,-1,303,304,305,-1,304,306,305,-1,307,263,247,-1,308,309,310,-1,310,311,308,-1,312,251,263,-1,204,262,259,-1,241,199,263,-1,202,313,263,-1,244,263,248,-1,271,263,307,-1,309,314,310,-1,309,315,314,-1,283,218,217,-1,224,215,316,-1,215,317,316,-1,215,94,317,-1,318,26,28,-1,318,319,26,-1,320,321,322,-1,320,323,321,-1,324,325,326,-1,327,168,328,-1,125,300,107,-1,329,330,331,-1,54,332,52,-1,218,219,333,-1,286,285,334,-1,304,335,306,-1,304,336,335,-1,337,338,339,-1,337,340,338,-1,67,224,316,-1,341,342,50,-1,343,334,344,-1,81,292,80,-1,81,345,292,-1,346,347,348,-1,348,349,346,-1,272,84,83,-1,83,350,272,-1,220,283,95,-1,283,93,95,-1,6,8,351,-1,351,352,6,-1,333,280,218,-1,353,354,355,-1,353,356,354,-1,357,358,359,-1,359,360,357,-1,240,361,362,-1,363,364,365,-1,36,40,39,-1,263,366,312,-1,366,263,313,-1,367,256,368,-1,367,257,256,-1,249,369,362,-1,362,250,249,-1,247,263,244,-1,244,250,245,-1};
			return value;
		}
		private int[] getrrrib_Geo_6_130_coordIndex_2()
		{
			int[] value = {244,248,250,-1,307,247,246,-1,246,370,307,-1,200,371,198,-1,259,256,258,-1,259,261,256,-1,372,259,258,-1,286,334,373,-1,334,343,373,-1,218,231,230,-1,217,374,282,-1,217,216,374,-1,224,67,222,-1,67,225,222,-1,95,215,221,-1,215,223,221,-1,218,220,219,-1,375,282,344,-1,282,374,344,-1,285,237,306,-1,237,305,306,-1,94,93,282,-1,282,375,94,-1,376,317,336,-1,336,377,376,-1,212,268,210,-1,209,378,207,-1,221,223,379,-1,380,236,204,-1,94,375,335,-1,185,187,173,-1,185,186,187,-1,381,164,160,-1,381,382,164,-1,383,384,385,-1,383,386,384,-1,387,190,388,-1,387,191,190,-1,144,389,390,-1,144,195,389,-1,390,167,166,-1,390,389,167,-1,391,392,189,-1,392,152,150,-1,150,287,392,-1,146,147,184,-1,186,142,393,-1,393,188,186,-1,382,163,164,-1,382,394,163,-1,184,147,395,-1,183,139,396,-1,397,170,398,-1,164,161,160,-1,161,157,156,-1,157,163,399,-1,163,400,399,-1,152,154,151,-1,151,150,152,-1,401,149,402,-1,149,148,402,-1,393,142,390,-1,142,144,390,-1,403,166,165,-1,165,404,403,-1,163,394,400,-1,394,405,400,-1,327,406,407,-1,327,328,406,-1,182,196,145,-1,182,183,196,-1,184,143,185,-1,184,395,143,-1,181,139,180,-1,181,396,139,-1,2,134,135,-1,2,408,134,-1,408,1,409,-1,408,2,1,-1,137,410,409,-1,137,411,410,-1,412,413,414,-1,412,415,413,-1,416,124,125,-1,138,1,17,-1,1,0,17,-1,113,136,111,-1,113,417,136,-1,418,419,383,-1,420,421,131,-1,422,423,424,-1,74,176,77,-1,141,180,139,-1,425,426,5,-1,426,14,5,-1,266,55,97,-1,266,427,55,-1,399,400,192,-1,192,193,399,-1,428,76,91,-1,428,429,76,-1,82,293,83,-1,430,429,385,-1,429,428,385,-1,431,432,433,-1,432,434,433,-1,435,436,437,-1,436,438,437,-1,79,439,90,-1,439,440,90,-1,88,87,296,-1,41,40,441,-1,425,4,207,-1,425,5,4,-1,18,14,426,-1,18,12,14,-1,61,442,10,-1,10,9,61,-1,125,107,106,-1,106,416,125,-1,443,103,102,-1,265,444,26,-1,26,445,265,-1,446,332,54,-1,102,447,443,-1,20,22,96,-1,448,42,44,-1,449,450,451,-1,378,452,207,-1,60,59,123,-1,36,35,40,-1,449,453,450,-1,45,441,40,-1,45,35,44,-1,35,37,44,-1,36,33,38,-1,36,39,33,-1,454,33,32,-1,453,66,68,-1,453,43,66,-1,31,30,455,-1,444,27,26,-1,23,96,22,-1,23,25,96,-1,23,448,24,-1,23,42,448,-1,320,456,323,-1,6,21,7,-1,299,17,15,-1,299,112,17,-1,5,457,3,-1,342,341,19,-1,208,4,10,-1,23,225,51,-1,23,22,225,-1,122,432,431,-1,122,458,432,-1,459,460,461,-1,459,298,460,-1,297,101,99,-1,86,101,297,-1,13,19,341,-1,13,12,19,-1,110,299,123,-1,110,112,299,-1,429,74,76,-1,429,116,74,-1,238,362,369,-1,238,240,362,-1,281,351,227,-1,351,281,352,-1,426,320,18,-1,320,426,456,-1,378,363,365,-1,363,378,209,-1,47,462,463,-1,444,462,47,-1,364,34,464,-1,364,455,34,-1,450,68,465,-1,450,453,68,-1,51,43,42,-1,43,51,66,-1,27,56,28,-1,56,27,46,-1,30,34,455,-1,34,30,32,-1,33,41,466,-1,39,41,33,-1,441,44,449,-1,441,45,44,-1,467,468,469,-1,468,467,470,-1,452,365,465,-1,452,378,365,-1,44,453,449,-1,44,43,453,-1,209,471,363,-1,208,471,209,-1,466,34,33,-1,34,466,464,-1,443,128,288,-1,443,447,128,-1,126,472,473,-1,472,126,474,-1,475,446,427,-1,446,475,332,-1,445,266,265,-1,266,445,476,-1,477,478,479,-1,477,480,478,-1,481,482,319,-1,482,481,129,-1,427,21,55,-1,427,446,21,-1,447,53,474,-1,447,102,53,-1,416,103,483,-1,416,106,103,-1,127,481,480,-1,127,129,481,-1,444,264,462,-1,444,265,264,-1,484,48,485,-1,48,484,49,-1,9,62,61,-1,62,9,486,-1,208,442,471,-1,442,208,10,-1,11,49,484,-1,13,49,11,-1,487,488,214,-1,487,489,488,-1,490,467,469,-1,490,491,467,-1,9,457,486,-1,457,9,3,-1,442,63,31,-1,442,61,63,-1,64,489,492,-1,489,64,488,-1,387,493,191,-1,114,493,387,-1,439,361,440,-1,361,439,494,-1,495,438,436,-1,495,496,438,-1,431,435,437,-1,431,433,435,-1,434,497,384,-1};
			return value;
		}
		private int[] getrrrib_Geo_6_130_coordIndex_3()
		{
			int[] value = {434,432,497,-1,101,498,100,-1,101,499,498,-1,294,86,297,-1,294,87,86,-1,352,22,6,-1,284,22,352,-1,473,475,476,-1,473,472,475,-1,19,500,342,-1,19,322,500,-1,13,50,49,-1,13,341,50,-1,492,478,501,-1,492,489,478,-1,330,502,331,-1,330,503,502,-1,504,505,506,-1,507,505,504,-1,508,388,190,-1,388,508,509,-1,510,511,512,-1,174,511,510,-1,513,114,387,-1,115,114,513,-1,75,514,515,-1,77,514,75,-1,419,516,517,-1,419,518,516,-1,386,324,326,-1,386,383,324,-1,519,422,520,-1,422,519,423,-1,521,522,523,-1,521,524,522,-1,420,525,421,-1,420,526,525,-1,518,418,527,-1,418,518,419,-1,113,342,417,-1,113,71,342,-1,2,301,528,-1,2,135,301,-1,529,183,396,-1,183,529,196,-1,502,530,531,-1,502,532,530,-1,513,507,512,-1,505,507,513,-1,530,509,533,-1,509,530,506,-1,16,534,535,-1,528,534,16,-1,119,536,535,-1,537,536,119,-1,109,538,108,-1,109,539,538,-1,108,540,105,-1,540,108,538,-1,57,124,290,-1,57,60,124,-1,414,495,412,-1,495,414,296,-1,500,415,541,-1,415,500,413,-1,1,137,409,-1,138,137,1,-1,411,542,410,-1,411,543,542,-1,544,433,545,-1,544,435,433,-1,542,546,547,-1,546,542,545,-1,409,548,408,-1,548,409,410,-1,325,520,422,-1,520,325,549,-1,383,428,418,-1,383,385,428,-1,550,517,516,-1,517,550,549,-1,519,420,131,-1,523,420,519,-1,525,181,329,-1,181,525,396,-1,50,71,70,-1,71,50,342,-1,398,174,510,-1,177,174,398,-1,178,141,402,-1,180,141,178,-1,184,401,146,-1,184,172,401,-1,395,145,143,-1,395,182,145,-1,399,159,157,-1,399,551,159,-1,503,179,552,-1,179,503,330,-1,553,554,555,-1,553,556,554,-1,397,510,557,-1,397,398,510,-1,406,558,559,-1,328,558,406,-1,560,524,561,-1,560,522,524,-1,396,526,529,-1,396,525,526,-1,405,404,165,-1,394,404,405,-1,393,166,403,-1,393,390,166,-1,562,563,197,-1,564,563,562,-1,563,161,156,-1,161,563,162,-1,381,565,566,-1,565,381,567,-1,382,404,394,-1,568,404,382,-1,405,192,400,-1,192,405,327,-1,515,159,551,-1,514,159,515,-1,398,155,562,-1,170,155,398,-1,568,403,404,-1,568,569,403,-1,566,392,391,-1,566,565,392,-1,558,389,561,-1,558,167,389,-1,403,188,393,-1,569,188,403,-1,171,150,149,-1,171,287,150,-1,162,564,567,-1,162,563,564,-1,569,189,188,-1,189,569,391,-1,570,553,552,-1,553,570,571,-1,301,533,572,-1,533,301,302,-1,536,299,15,-1,536,300,299,-1,557,512,507,-1,557,510,512,-1,573,109,574,-1,539,109,573,-1,104,461,54,-1,459,461,104,-1,417,575,136,-1,541,575,417,-1,548,134,408,-1,548,424,134,-1,523,526,420,-1,523,522,526,-1,384,546,434,-1,546,384,386,-1,412,436,576,-1,412,495,436,-1,160,567,381,-1,160,162,567,-1,203,371,577,-1,203,198,371,-1,199,243,200,-1,241,243,199,-1,379,222,578,-1,379,223,222,-1,452,579,207,-1,452,580,579,-1,581,582,269,-1,582,581,583,-1,584,585,586,-1,584,587,585,-1,336,588,377,-1,588,336,304,-1,589,590,591,-1,592,590,589,-1,588,593,594,-1,588,595,593,-1,317,596,316,-1,376,596,317,-1,376,597,596,-1,376,270,597,-1,377,594,267,-1,377,588,594,-1,595,598,593,-1,595,590,598,-1,599,371,200,-1,592,371,599,-1,236,305,237,-1,236,600,305,-1,285,335,334,-1,306,335,285,-1,37,448,44,-1,448,37,463,-1,334,375,344,-1,375,334,335,-1,601,343,235,-1,343,601,373,-1,206,286,373,-1,205,286,206,-1,602,204,206,-1,204,602,262,-1,239,276,240,-1,239,278,276,-1,603,348,347,-1,603,260,348,-1,604,256,261,-1,604,368,256,-1,315,605,255,-1,315,309,605,-1,584,308,587,-1,308,584,606,-1,607,591,600,-1,589,591,607,-1,608,307,370,-1,271,307,608,-1,367,366,257,-1,312,366,367,-1,589,252,577,-1,589,607,252,-1,608,584,242,-1,608,606,584,-1,245,362,254,-1,245,250,362,-1,369,367,368,-1,369,249,367,-1,501,73,492,-1,318,73,501,-1,609,582,580,-1,609,597,582,-1,594,211,210,-1,594,593,211,-1,610,213,311,-1,610,212,213,-1,583,611,612,-1,611,583,581,-1,207,613,491,-1,613,207,579,-1,614,88,615,-1,614,89,88,-1,85,470,338,-1,470,85,498,-1,78,340,616,-1,340,78,82,-1,79,314,439,-1};
			return value;
		}
		private int[] getrrrib_Geo_6_130_coordIndex_4()
		{
			int[] value = {617,314,79,-1,354,291,355,-1,350,291,354,-1,359,292,345,-1,292,359,358,-1,603,238,604,-1,603,239,238,-1,360,277,346,-1,360,359,277,-1,358,353,355,-1,357,353,358,-1,354,618,274,-1,354,356,618,-1,348,601,349,-1,601,348,602,-1,234,333,619,-1,333,234,280,-1,333,221,619,-1,333,219,221,-1,343,374,233,-1,374,343,344,-1,350,293,291,-1,350,83,293,-1,440,275,90,-1,276,275,440,-1,357,279,228,-1,357,360,279,-1,322,413,500,-1,322,321,413,-1,31,471,442,-1,31,455,471,-1,469,614,323,-1,469,468,614,-1,337,613,612,-1,613,337,339,-1,336,94,335,-1,336,317,94,-1,611,620,621,-1,611,610,620,-1,379,619,221,-1,229,619,379,-1,356,8,618,-1,356,351,8,-1,360,349,279,-1,346,349,360,-1,572,509,508,-1,533,509,572,-1,537,300,536,-1,537,574,300,-1,178,552,179,-1,178,570,552,-1,174,74,511,-1,74,174,176,-1,493,120,191,-1,458,120,493,-1,438,539,573,-1,496,539,438,-1,575,543,411,-1,543,575,622,-1,326,422,424,-1,422,326,325,-1,561,195,560,-1,561,389,195,-1,516,559,550,-1,516,406,559,-1,547,386,326,-1,547,546,386,-1,415,576,622,-1,415,412,576,-1,338,467,339,-1,338,470,467,-1,617,310,314,-1,617,620,310,-1,612,621,337,-1,612,611,621,-1,339,491,613,-1,491,339,467,-1,322,18,320,-1,19,18,322,-1,290,477,57,-1,477,290,289,-1,62,488,64,-1,62,485,488,-1,465,580,452,-1,465,609,580,-1,361,254,362,-1,361,494,254,-1,259,380,204,-1,259,372,380,-1,600,303,305,-1,591,303,600,-1,604,260,603,-1,604,261,260,-1,451,466,449,-1,451,464,466,-1,58,487,69,-1,58,479,487,-1,490,426,425,-1,426,490,456,-1,620,311,310,-1,610,311,620,-1,616,337,621,-1,340,337,616,-1,323,615,321,-1,614,615,323,-1,622,544,543,-1,576,544,622,-1,550,524,521,-1,524,550,559,-1,547,424,548,-1,424,547,326,-1,541,622,575,-1,541,415,622,-1,437,573,121,-1,573,437,438,-1,430,384,497,-1,384,430,385,-1,571,556,553,-1,556,571,169,-1,528,0,2,-1,528,16,0,-1,111,17,112,-1,138,17,111,-1,534,508,117,-1,508,534,572,-1,555,504,532,-1,554,504,555,-1,538,294,540,-1,294,538,295,-1,84,98,100,-1,272,98,84,-1,345,90,275,-1,345,81,90,-1,227,357,228,-1,357,227,353,-1,273,461,460,-1,623,461,273,-1,225,578,222,-1,284,578,225,-1,621,617,616,-1,620,617,621,-1,469,456,490,-1,469,323,456,-1,321,414,413,-1,321,615,414,-1,351,353,227,-1,356,353,351,-1,229,578,281,-1,229,379,578,-1,216,233,374,-1,216,230,233,-1,226,619,229,-1,226,234,619,-1,231,234,232,-1,231,280,234,-1,235,349,601,-1,235,279,349,-1,623,274,618,-1,623,273,274,-1,278,346,277,-1,347,346,278,-1,359,275,277,-1,345,275,359,-1,292,355,291,-1,292,358,355,-1,354,272,350,-1,272,354,274,-1,315,439,314,-1,315,494,439,-1,616,79,78,-1,616,617,79,-1,338,82,85,-1,338,340,82,-1,89,468,499,-1,89,614,468,-1,615,296,414,-1,615,88,296,-1,612,579,583,-1,612,613,579,-1,581,610,611,-1,610,581,212,-1,587,311,213,-1,308,311,587,-1,593,585,211,-1,598,585,593,-1,210,267,594,-1,267,210,268,-1,270,582,597,-1,270,269,582,-1,7,446,54,-1,7,21,446,-1,252,258,253,-1,258,252,372,-1,370,255,605,-1,255,370,246,-1,606,370,605,-1,608,370,606,-1,586,200,243,-1,586,599,200,-1,257,313,253,-1,366,313,257,-1,249,312,367,-1,251,312,249,-1,242,271,608,-1,241,271,242,-1,598,586,585,-1,598,599,586,-1,309,606,605,-1,309,308,606,-1,494,255,254,-1,494,315,255,-1,369,604,238,-1,604,369,368,-1,260,602,348,-1,260,262,602,-1,239,347,278,-1,239,603,347,-1,240,440,361,-1,240,276,440,-1,233,235,343,-1,233,232,235,-1,602,373,601,-1,206,373,602,-1,463,38,47,-1,37,38,463,-1,607,372,252,-1,607,380,372,-1,380,600,236,-1,607,600,380,-1,598,592,599,-1,590,592,598,-1,304,595,588,-1,304,303,595,-1,267,376,377,-1,376,267,270,-1,67,596,65,-1,67,316,596,-1,303,590,595,-1,590,303,591,-1,592,577,371,-1,592,589,577,-1,586,242,584,-1,586,243,242,-1,587,211,585,-1,211,587,213,-1,269,212,581,-1,269,268,212,-1,580,583,579,-1,580,582,583,-1,618,7,623,-1};
			return value;
		}
		private int[] getrrrib_Geo_6_130_coordIndex_5()
		{
			int[] value = {8,7,618,-1,201,577,252,-1,203,577,201,-1,313,201,253,-1,201,313,202,-1,198,202,199,-1,198,203,202,-1,193,551,399,-1,193,515,551,-1,151,169,571,-1,154,169,151,-1,576,435,544,-1,576,436,435,-1,560,196,529,-1,560,195,196,-1,133,424,423,-1,133,134,424,-1,136,411,137,-1,411,136,575,-1,54,623,7,-1,461,623,54,-1,105,459,104,-1,540,459,105,-1,121,574,537,-1,121,573,574,-1,169,397,556,-1,397,169,170,-1,572,528,301,-1,534,528,572,-1,532,503,555,-1,532,502,503,-1,149,172,171,-1,401,172,149,-1,148,571,570,-1,151,571,148,-1,91,194,527,-1,194,91,92,-1,287,189,392,-1,189,287,187,-1,152,565,153,-1,565,152,392,-1,568,391,569,-1,568,566,391,-1,327,165,168,-1,327,405,165,-1,514,176,175,-1,176,514,77,-1,328,167,558,-1,328,168,167,-1,407,192,327,-1,194,192,407,-1,382,566,568,-1,566,382,381,-1,153,567,564,-1,153,565,567,-1,156,197,563,-1,156,158,197,-1,564,155,153,-1,564,562,155,-1,182,147,140,-1,182,395,147,-1,522,529,526,-1,560,529,522,-1,559,561,524,-1,558,561,559,-1,556,557,554,-1,556,397,557,-1,552,555,503,-1,552,553,555,-1,181,330,329,-1,181,179,330,-1,402,570,178,-1,570,402,148,-1,146,402,141,-1,146,401,402,-1,514,158,159,-1,514,175,158,-1,562,177,398,-1,197,177,562,-1,329,421,525,-1,331,421,329,-1,131,331,132,-1,421,331,131,-1,549,521,520,-1,550,521,549,-1,91,418,428,-1,91,527,418,-1,549,324,517,-1,324,549,325,-1,131,423,519,-1,133,423,131,-1,410,547,548,-1,547,410,542,-1,545,434,546,-1,434,545,433,-1,543,545,542,-1,543,544,545,-1,342,541,417,-1,541,342,500,-1,480,501,478,-1,501,480,481,-1,102,54,53,-1,102,104,54,-1,124,483,290,-1,416,483,124,-1,539,295,538,-1,539,496,295,-1,15,535,536,-1,15,16,535,-1,118,537,119,-1,121,537,118,-1,458,118,120,-1,458,122,118,-1,535,117,119,-1,534,117,535,-1,531,533,302,-1,533,531,530,-1,387,505,513,-1,387,388,505,-1,116,511,74,-1,511,116,115,-1,532,506,530,-1,532,504,506,-1,531,331,502,-1,331,531,132,-1,132,302,130,-1,302,132,531,-1,574,107,300,-1,107,574,109,-1,108,103,106,-1,103,108,105,-1,407,527,194,-1,527,407,518,-1,523,520,521,-1,520,523,519,-1,383,517,324,-1,383,419,517,-1,518,406,516,-1,406,518,407,-1,512,115,513,-1,511,115,512,-1,117,190,120,-1,190,117,508,-1,506,388,509,-1,505,388,506,-1,554,507,504,-1,557,507,554,-1,484,457,11,-1,457,484,486,-1,482,476,445,-1,473,476,482,-1,128,474,126,-1,128,447,474,-1,609,596,597,-1,65,596,609,-1,284,281,578,-1,284,352,281,-1,288,624,443,-1,290,624,288,-1,290,483,624,-1,296,496,495,-1,295,496,296,-1,85,100,498,-1,85,84,100,-1,78,293,82,-1,78,80,293,-1,497,114,430,-1,493,114,497,-1,110,71,113,-1,110,72,71,-1,492,63,64,-1,73,63,492,-1,214,69,487,-1,214,70,69,-1,68,609,465,-1,609,68,65,-1,318,29,73,-1,318,28,29,-1,491,425,207,-1,490,425,491,-1,489,479,478,-1,487,479,489,-1,214,485,48,-1,488,485,214,-1,62,484,485,-1,62,486,484,-1,462,25,24,-1,25,462,264,-1,445,319,482,-1,319,445,26,-1,624,103,443,-1,624,483,103,-1,472,332,475,-1,472,52,332,-1,57,479,58,-1,57,477,479,-1,481,318,501,-1,319,318,481,-1,289,480,477,-1,289,127,480,-1,33,56,38,-1,33,454,56,-1,476,427,266,-1,427,476,475,-1,129,473,482,-1,473,129,126,-1,474,52,472,-1,52,474,53,-1,288,127,289,-1,288,128,127,-1,455,363,471,-1,455,364,363,-1,470,499,468,-1,499,470,498,-1,466,441,449,-1,41,441,466,-1,451,465,365,-1,451,450,465,-1,29,32,30,-1,29,454,32,-1,444,46,27,-1,444,47,46,-1,464,365,364,-1,365,464,451,-1,28,454,29,-1,56,454,28,-1,24,463,462,-1,24,448,463,-1,298,99,460,-1,298,297,99,-1,460,98,273,-1,99,98,460,-1,92,515,193,-1,92,75,515,-1,116,430,114,-1,430,116,429,-1,14,457,5,-1,457,14,11,-1,499,86,89,-1,499,101,86,-1,540,298,459,-1,540,294,298,-1,497,458,493,-1,432,458,497,-1,431,121,122,-1,437,121,431,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrrib_Coord_7_130_point_1()
		{
			double[] value = {-2.86175,50.30789,-.42953,-2.89111,50.29664,-.44129,-2.84255,49.96757,-.0938,-1.46909,51.99719,-1.86867,-1.37932,52.05934,-1.86829,-1.49518,51.98056,-1.827,-1.24215,52.24918,-1.62898,-1.33902,52.19181,-1.58078,-1.22815,52.19448,-1.55394,-1.46954,52.02376,-1.89766,-1.39042,52.06739,-1.90387,-1.61456,51.9284,-1.81346,-1.70267,51.87194,-1.73702,-1.70921,51.88,-1.76195,-1.61867,51.92078,-1.78323,-2.7165,50.66889,-.71152,-2.79196,50.35338,-.4061,-2.76817,50.61465,-.73435,-1.68768,51.86938,-1.71172,-1.80417,51.79026,-1.64305,-1.25074,52.30532,-1.69101,-1.32059,52.26981,-1.63538,-1.2,52.2694,-1.67709,-1.17097,52.2853,-1.70129,-1.22272,52.32274,-1.74448,-1.22445,52.32318,-1.7372,-1.38519,52.35722,-1.8608,-1.36099,52.34392,-1.86896,-1.37577,52.31094,-1.90374,-1.37607,52.22854,-1.9518,-1.35529,52.19263,-1.95014,-1.38598,52.16759,-1.95224,-1.34771,52.20631,-1.95324,-1.31717,52.23715,-1.91868,-1.33184,52.19273,-1.93695,-1.27575,52.2904,-1.82567,-1.2932,52.29573,-1.86122,-1.27054,52.31967,-1.8178,-1.31386,52.31399,-1.86901,-1.29546,52.25506,-1.88424,-1.27489,52.27185,-1.84585,-1.28301,52.24447,-1.86287,-1.16728,52.28774,-1.7129,-1.1558,52.26364,-1.71797,-1.21277,52.28072,-1.76338,-1.24504,52.27755,-1.80582,-1.35271,52.34436,-1.87438,-1.32253,52.36067,-1.84599,-1.72282,51.93241,-1.80552,-1.7088,51.9055,-1.79187,-1.82808,51.82601,-1.70541,-1.15786,52.27756,-1.70273,-1.46774,52.26639,-1.66015,-1.50763,52.25012,-1.6439,-1.47279,52.17226,-1.593,-1.29875,52.33947,-1.69995,-1.36661,52.31445,-1.90772,-1.81739,52.05074,-1.62678,-1.83532,52.00534,-1.66612,-1.97594,51.84773,-1.55032,-1.94779,51.8917,-1.51333,-1.46442,52.06942,-1.93521,-1.54279,52.0342,-1.9152,-1.46765,52.13229,-1.95295,-1.5652,52.08463,-1.91867,-1.15728,52.20159,-1.71816,-1.14886,52.25784,-1.70857,-1.11392,52.25329,-1.69262,-1.17073,52.2073,-1.72667,-1.8468,51.93458,-1.70757,-1.84179,51.88733,-1.72982,-2.01878,51.71366,-1.60917,-2.00271,51.78333,-1.58577,-1.4574,52.19987,-1.94298,-1.73387,50.25335,.3598,-1.58408,50.25141,.39925,-1.6809,50.28471,.31944,-1.60055,50.22322,.42146,-.94904,51.98079,-1.45863,-.80198,51.94041,-1.43112,-.94957,51.99304,-1.43344,-.80867,51.95881,-1.41241,-1.09811,51.98493,-1.48089,-1.10989,51.99497,-1.4562,-1.24393,51.97515,-1.44977,-1.24761,51.97833,-1.49429,-1.51367,51.86378,-1.37436,-1.62227,51.79063,-1.32006,-1.62179,51.78351,-1.32268,-1.53269,51.85508,-1.40558,-.79033,51.95711,-1.40787,-1.6708,50.26824,.30064,-1.58024,50.23007,.37796,-.86074,52.2833,-1.64495,-.85942,52.26772,-1.65009,-.94108,52.29916,-1.65166,-1.24396,52.3136,-1.70318,-1.29157,52.3502,-1.72539,-1.36319,51.95487,-1.4132,-1.43445,51.92296,-1.39313};
			return value;
		}
		private double[] getrrrib_Coord_7_130_point_2()
		{
			double[] value = {-1.38424,51.92529,-1.42016,-1.44519,51.89678,-1.39685,-1.60541,52.16273,-1.58269,-1.74306,52.04068,-1.48389,-1.5749,52.08759,-1.53526,-1.68473,51.98301,-1.42888,-1.87324,51.8928,-1.38248,-2.13427,51.56277,-1.19201,-1.79836,51.84765,-1.33656,-2.00455,51.56696,-1.13287,-2.31126,51.4099,-1.3432,-2.63204,50.92974,-1.09796,-2.60045,50.98973,-1.06838,-2.32954,51.34647,-1.37063,-2.00053,50.32057,.16728,-1.883,50.24792,.2994,-1.85692,50.27726,.28271,-2.47276,50.32943,-.15249,-2.32769,50.7246,-.48014,-2.46775,50.6359,-.43739,-2.2712,50.51337,-.21039,-2.20934,50.99892,-.69009,-2.24755,50.77939,-.50321,-2.27666,51.45825,-1.31583,-1.9197,51.93599,-1.47614,-2.20424,51.53123,-1.24065,-1.52403,52.31153,-1.71851,-1.64801,52.23962,-1.69694,-1.64136,52.23067,-1.66757,-1.52272,52.32164,-1.75862,-2.53569,49.66853,.30271,-2.35064,49.59503,.41015,-2.36951,49.60446,.42909,-2.5136,49.66311,.27875,-2.64758,49.74288,.16423,-2.66816,49.75548,.18592,-2.60874,50.91068,-1.10674,-2.77639,50.55529,-.76546,-2.79219,50.57475,-.75425,-1.87502,49.51377,.71369,-1.78249,49.52788,.76675,-1.77297,49.54708,.7938,-1.66485,49.66603,.63719,-1.70967,49.59188,.70937,-1.67754,49.63552,.63687,-1.73334,49.56639,.69642,-1.74051,49.56448,.79346,-1.74843,49.55526,.7718,-1.71294,49.65214,.8218,-1.70115,49.64819,.8158,-1.67549,49.75831,.76917,-1.68967,49.75822,.77476,-1.64928,49.86865,.72216,-1.62239,49.95908,.64713,-1.66388,49.87478,.72907,-1.64411,49.96993,.66851,-1.55858,50.15109,.47146,-1.54672,50.18117,.42847,-1.57243,50.16165,.48408,-1.55247,50.20341,.45017,-1.58879,50.09049,.46554,-1.582,50.12074,.4523,-1.58958,50.09083,.49505,-1.54084,50.15545,.41906,-1.57642,50.08588,.44938,-1.56984,49.91595,.46072,-1.58693,49.81467,.51321,-1.60499,49.81323,.48782,-1.59956,49.90765,.45568,-1.71013,49.88248,.70878,-1.68407,49.966,.64083,-1.70312,49.67966,.77409,-1.72531,49.60634,.78078,-1.73422,49.65304,.72526,-1.6758,50.1232,.47631,-1.60076,50.17501,.46219,-1.62257,50.1887,.44314,-1.63761,50.11629,.50608,-1.84327,49.57942,.78345,-1.96292,49.57794,.71342,-1.86198,49.54277,.75828,-1.98223,49.53192,.69382,-1.76135,49.53633,.73008,-1.83422,49.53334,.68867,-1.74329,49.58797,.75628,-1.72449,49.63567,.68774,-1.69133,49.68164,.65151,-1.71716,49.70901,.67683,-1.63882,49.75778,.59279,-1.69272,49.81357,.61657,-2.22333,50.28796,.07596,-2.17702,50.33212,.05253,-1.57037,50.14503,.38795,-1.56052,50.22704,.38703,-1.62906,50.14631,.37485,-1.70527,49.62869,.60362,-1.76974,49.56474,.65793,-1.59574,50.11039,.53642,-.50731,52.11222,-1.53896,-.4858,52.0451,-1.4814};
			return value;
		}
		private double[] getrrrib_Coord_7_130_point_3()
		{
			double[] value = {-.51286,52.09918,-1.55033,-.49523,52.12938,-1.50266,-.4805,52.06353,-1.46582,-.49989,52.12426,-1.52208,-.56137,52.19075,-1.52865,-.60074,52.20555,-1.55837,-.60061,52.19904,-1.54455,-1.37857,52.05796,-1.84209,-1.35592,52.09055,-1.88504,-1.34114,52.10086,-1.86728,-.74457,52.08187,-1.62047,-.65928,52.06739,-1.60711,-.76764,52.03179,-1.60106,-.67311,52.01548,-1.57574,-1.74033,51.9774,-1.80766,-1.01344,52.28134,-1.66125,-.81781,52.3164,-1.62201,-.82173,52.30591,-1.63403,-.85752,52.3282,-1.62919,-.9057,52.32327,-1.63145,-.89948,52.32137,-1.64524,-.94828,52.3065,-1.63734,-1.07487,52.27333,-1.66111,-1.0246,52.28569,-1.645,-1.0679,52.25844,-1.67563,-1.13899,52.27259,-1.6883,-.89824,52.26856,-1.54387,-1.03002,52.22792,-1.51331,-.91362,52.22808,-1.50465,-1.0111,52.26045,-1.58419,-.82099,52.31462,-1.61641,-.82925,52.30987,-1.60186,-.81334,52.2804,-1.57671,-.78787,52.28559,-1.59631,-.88573,52.28751,-1.57345,-.79127,52.24225,-1.54562,-.56417,52.20057,-1.54387,-.60673,52.22165,-1.57403,-.52348,52.06583,-1.32098,-.56984,52.05591,-1.3449,-.56475,51.96688,-1.33463,-.48682,52.00417,-1.48386,-.51429,51.99462,-1.51115,-.511,52.04309,-1.53707,-.47605,51.94567,-1.35961,-.47276,51.92121,-1.33921,-.49395,51.90467,-1.38472,-.48672,51.93195,-1.39241,-.46577,51.98949,-1.34231,-.42998,52.04523,-1.30352,-.47331,51.96057,-1.30801,-.44318,52.02224,-1.35473,-.51132,52.16265,-1.52124,-.47374,52.15346,-1.45702,-.51325,51.87836,-1.34434,-.54134,51.88493,-1.39442,-.45785,52.1531,-1.37412,-.45177,52.13251,-1.39964,-.50282,52.17793,-1.46319,-.52496,52.17658,-1.48295,-.56351,52.16169,-1.44457,-.51442,52.16378,-1.41197,-.56239,52.18437,-1.50816,-.46913,51.99256,-1.4145,-1.27561,52.36063,-1.77422,-1.32575,52.37463,-1.80278,-1.34803,52.35536,-1.74429,-.75023,52.1508,-1.62585,-.75823,52.08456,-1.62274,-.86819,52.0981,-1.65219,-.86681,52.15147,-1.64592,-.49409,51.96992,-1.44619,-1.25093,51.99491,-1.43711,-1.35583,51.99783,-1.44032,-1.26529,52.0352,-1.44703,-.76579,51.99337,-1.37815,-.62287,51.97199,-1.35368,-.73275,52.0694,-1.39625,-.63037,52.05552,-1.36489,-.80998,52.20393,-1.49263,-.87412,52.31096,-1.60133,-1.09823,52.24511,-1.58804,-.76235,52.27849,-1.62633,-.86281,52.31104,-1.63649,-1.14396,52.2586,-1.6495,-.6604,52.24828,-1.58748,-.66806,52.23392,-1.57899,-1.68759,49.74797,.74144,-1.71406,52.16897,-1.63468,-1.72483,52.16773,-1.6476,-1.78727,52.09291,-1.58906,-1.07613,52.02274,-1.42967,-.94814,52.02653,-1.42173,-1.09178,51.9974,-1.45567,-1.61441,51.82121,-1.30946,-1.71009,51.73279,-1.24552,-1.71335,51.7012,-1.25328,-1.50483,51.88905,-1.37058,-1.51446,51.9161,-1.3907,-2.55541,51.0522,-1.03037};
			return value;
		}
		private double[] getrrrib_Coord_7_130_point_4()
		{
			double[] value = {-2.40923,51.18981,-.98916,-2.59479,49.84509,.17933,-2.46959,49.74969,.31859,-.6118,52.18213,-1.60995,-.67859,52.20648,-1.61656,-.60597,52.21659,-1.58502,-.66184,52.24034,-1.59851,-.49263,51.93572,-1.41224,-.60375,51.96042,-1.50362,-.59412,51.89601,-1.4397,-.65513,51.93044,-1.46288,-.66234,51.97624,-1.52652,-.44888,52.04608,-1.38198,-.46166,52.06178,-1.43103,-.64541,51.91439,-1.41216,-.56809,51.8935,-1.40052,-1.06289,52.24556,-1.67364,-.86628,52.23033,-1.6506,-1.44149,52.29567,-1.90131,-1.44854,52.34019,-1.84799,-1.65766,51.86021,-1.66943,-1.73239,51.74835,-1.50283,-1.77374,51.76855,-1.58175,-1.6082,51.86016,-1.58426,-2.12427,50.01715,.1189,-2.16613,49.96444,.1325,-2.29988,50.02956,.01293,-1.5852,50.01161,.41218,-1.62626,49.91604,.44066,-2.08161,49.54236,.63585,-2.05323,49.57672,.65229,-2.22588,49.56483,.52944,-1.4296,52.28095,-1.67334,-.90142,52.31472,-1.61603,-.70806,52.2626,-1.59416,-.70541,52.2532,-1.61312,-.7199,52.22535,-1.61851,-1.08622,52.00529,-1.56913,-1.24142,51.98218,-1.53206,-1.23319,51.98989,-1.60839,-1.09536,51.98828,-1.5113,-1.81779,51.80287,-1.6805,-1.99456,51.67772,-1.59721,-.7426,52.24941,-1.56862,-.72408,52.27028,-1.60005,-.81966,51.99841,-1.39174,-.72015,52.11738,-1.42376,-.62246,52.10845,-1.40278,-.61582,52.16596,-1.47424,-.71124,52.18127,-1.47995,-1.13027,52.0154,-1.43113,-1.14547,52.20572,-1.52623,-1.1481,52.24242,-1.60821,-1.04184,52.15008,-1.47253,-1.15764,52.0686,-1.44868,-1.04895,52.08847,-1.44686,-1.15264,52.13529,-1.49063,-.92859,52.1541,-1.46619,-.9375,52.09927,-1.44497,-.82646,52.0805,-1.41497,-.82234,52.1341,-1.44631,-.54676,51.9149,-1.36044,-.49867,51.945,-1.29273,-1.32678,52.14158,-1.8857,-1.30902,52.17522,-1.88982,-1.27201,52.16745,-1.82665,-.45537,52.06291,-1.41036,-.43866,52.10029,-1.3428,-.45482,52.11479,-1.33067,-.45721,52.05608,-1.28449,-.51638,51.91482,-1.42306,-.51333,52.12429,-1.55175,-.51377,52.18149,-1.48542,-.67819,52.22309,-1.55832,-.76947,52.29125,-1.61351,-.71805,52.26168,-1.61618,-.86689,52.17878,-1.64417,-.7408,52.18302,-1.62433,-1.3211,52.10771,-1.83725,-1.01831,52.27604,-1.61735,-.53048,52.19092,-1.51002,-1.6171,50.00898,.50671,-1.58656,49.9996,.47736,-1.96647,50.23669,.08113,-2.02775,50.46015,-.08017,-1.91088,50.3752,.07936,-2.11492,50.28357,-.04867,-2.07546,50.24986,.20334,-2.15477,50.15733,.23257,-1.64914,49.71407,.54309,-1.62698,49.7324,.56776,-1.67164,49.85417,.59249,-1.65408,49.86158,.68728,-1.62129,49.74119,.57978,-1.55535,50.03266,.44988,-1.73265,49.561,.7481,-1.9731,49.51755,.65787,-1.73127,49.97277,.60857,-1.67184,50.05918,.54957,-1.52862,50.21983,.4008};
			return value;
		}
		private double[] getrrrib_Coord_7_130_point_5()
		{
			double[] value = {-1.53419,50.15837,.39478,-1.72406,49.58971,.81105,-1.74104,49.58515,.82126,-1.5828,49.82379,.5253,-1.56823,49.92348,.48469,-1.55582,50.01974,.41932,-1.71965,49.93263,.3916,-1.67401,50.04752,.38166,-2.83025,49.95659,-.11361,-2.88498,50.24373,-.42678,-2.75627,50.29522,-.45555,-2.64318,50.61537,-.76848,-1.98081,51.40399,-1.14557,-1.8556,51.63448,-1.42836,-1.78462,51.65937,-1.34526,-2.07384,51.33736,-1.24993,-1.90077,51.91917,-1.43399,-2.31415,51.29759,-1.35359,-1.82344,50.1872,.20417,-1.85666,50.13108,.20721,-2.15598,49.5768,.47749,-2.20697,49.55284,.50794,-2.31315,49.80989,.1798,-2.34553,49.78219,.19505,-2.4957,49.85827,.07801,-1.49843,51.98276,-1.80533,-1.62004,51.91559,-1.75666,-1.36167,52.33447,-1.71572,-1.79097,50.32691,.19417,-1.80693,50.33436,.21406,-1.91124,50.38273,.10431,-2.1677,50.83226,-.52711,-2.11461,50.63132,-.28174,-2.16777,50.80772,-.53969,-2.10904,50.61123,-.29717,-2.14335,50.98806,-.70285,-2.05351,51.21505,-.88218,-2.14265,51.01593,-.69107,-2.04642,51.24511,-.87508,-.62801,51.91062,-1.39088,-.62758,51.93158,-1.37376,-1.25677,52.2462,-1.82534,-1.39462,52.10942,-1.93147,-1.67722,52.17053,-1.61225,-1.3251,52.36348,-1.83195,-1.38911,52.36509,-1.81473,-1.38584,52.28995,-1.67225,-1.63213,52.21543,-1.64075,-1.22058,52.32195,-1.75537,-1.23704,52.21941,-1.80206,-1.21218,52.18518,-1.76695,-1.26445,52.18116,-1.83007,-1.31392,52.10626,-1.8251,-1.17909,52.21389,-1.74529,-1.36621,52.23581,-1.95434,-1.33704,52.17783,-1.93083,-1.61717,51.88911,-1.69438,-1.50724,51.97778,-1.86036,-2.18742,50.5796,-.2466,-1.54763,52.01494,-1.46618,-1.43529,51.96155,-1.41595,-1.46335,52.06372,-1.50038,-1.27278,52.35501,-1.78693,-1.2696,52.3521,-1.79963,-1.30042,52.19005,-1.89177,-1.21313,52.17398,-1.76012,-1.28977,52.21893,-1.88179,-1.41117,51.94213,-1.63444,-1.49419,51.88631,-1.50815,-1.52159,51.89905,-1.61182,-1.40965,51.92221,-1.52205,-1.35109,52.12847,-1.91062,-1.46587,52.31348,-1.70914,-1.46402,52.33563,-1.74195,-1.52102,52.29266,-1.68908,-1.41325,52.32814,-1.72037,-1.40318,52.35268,-1.75262,-1.73869,52.13522,-1.69215,-1.64988,52.16854,-1.79941,-1.75029,52.08745,-1.73576,-1.64849,52.22173,-1.74884,-1.51873,52.31069,-1.81893,-1.4528,52.34895,-1.79193,-1.76621,52.07333,-1.54494,-1.60796,51.96637,-1.85545,-1.6235,52.00049,-1.8792,-1.52889,51.99991,-1.88915,-1.74374,52.0212,-1.78281,-1.64283,52.04673,-1.87678,-1.6488,52.08634,-1.85093,-1.51288,51.95149,-1.73766,-1.40788,52.00487,-1.75859,-1.55029,52.15977,-1.9061,-2.08994,50.41057,.01293,-.55253,51.89183,-1.37659,-1.89264,51.4644,-1.07727,-1.88522,51.49801,-1.06809,-2.03799,50.48392,-.06012,-1.39461,51.92085,-1.45806,-1.46396,51.88896,-1.43306};
			return value;
		}
		private double[] getrrrib_Coord_7_130_point_6()
		{
			double[] value = {-1.92218,51.6468,-1.50717,-1.51834,52.26554,-1.87222,-2.16513,49.6792,.53782,-2.0035,49.64777,.65976,-2.02225,49.90794,.50158,-2.0384,50.07107,.36273,-2.14568,49.93745,.39839,-1.94195,50.00203,.46495,-2.36559,50.11795,.1212,-2.27532,50.00631,.26781,-1.72931,50.06448,.51182,-1.79344,50.17708,.39113,-1.8522,50.10312,.42324,-1.95547,50.16783,.33183,-1.5812,50.21587,.43293,-1.56485,50.24929,.40662,-1.81048,49.95698,.32183,-1.95177,49.983,.22775,-1.75197,50.08056,.3123,-2.183,49.72393,.32609,-2.13084,49.78003,.30114,-1.97521,49.74961,.38728,-1.91478,49.65331,.49984,-2.04349,49.67994,.42002,-1.84835,49.73003,.4547,-2.05174,49.52687,.60476,-1.99568,49.56845,.55808,-1.70725,50.15968,.30206,-2.73434,50.07075,-.09171,-1.89555,49.56564,.61071,-2.23604,49.82155,.42306,-2.31175,49.70522,.434,-2.10753,49.79411,.5269,-2.37296,49.87742,.30038,-2.62853,50.18144,-.1133,-2.63967,50.48544,-.41616,-2.5393,50.8326,-.69052,-2.35914,50.93361,-.68081,-1.753,51.78656,-1.28608,-1.93293,51.5256,-1.09403,-1.64744,51.90724,-1.37008,-2.19604,51.32342,-1.32045,-2.53132,50.41604,-.50152,-2.43573,50.71321,-.76784,-2.28477,50.85264,-.74075,-2.32535,50.62043,-.53538,-2.27106,50.402,-.26931,-2.46619,50.1909,-.22438,-2.68399,50.04115,-.1641,-2.01718,49.90462,.25302,-1.87681,49.85444,.34225,-1.53553,50.2399,.42118,-1.90508,49.64689,.71852,-1.8485,49.76941,.69477,-1.87708,49.90052,.59709,-1.94807,49.77351,.63448,-1.78627,49.89096,.6562,-1.80552,49.98307,.55992,-1.6629,49.81669,.45876,-1.76429,49.83085,.40807,-1.8137,49.64016,.55837,-1.73264,49.71598,.50973,-1.61268,50.06255,.58105,-1.57902,50.09662,.52408,-1.59207,50.05209,.56235,-1.63361,49.93451,.62537,-1.64832,49.92985,.54756,-1.61226,50.01091,.56292,-1.59225,49.9147,.50223,-1.60529,49.83538,.53894,-1.80972,49.64572,.77936,-1.75206,49.76492,.75733,-2.49463,49.9761,.16136,-2.09515,51.25246,-.89296,-2.1825,51.26393,-.92445,-2.48658,50.94427,-1.07564,-2.17319,51.1267,-.94417,-.51178,52.14363,-1.54552,-1.08717,52.25926,-1.62294,-1.19352,52.07162,-1.71361,-1.17703,52.11979,-1.73002,-.88236,52.05813,-1.63633,-1.03388,52.11461,-1.6751,-1.04214,52.06701,-1.6602,-.57912,51.99898,-1.54943,-.59079,52.05495,-1.59101,-.56076,52.04962,-1.578,-.60606,52.00395,-1.55859,-.69607,52.17492,-1.6231,-.53768,52.15876,-1.56897,-.5707,52.14229,-1.59543,-.56652,52.16606,-1.58934,-.54337,52.13645,-1.5771,-.63359,52.13462,-1.62064,-.70767,52.15317,-1.62543,-.62289,52.15397,-1.61769,-1.04411,52.1996,-1.66938,-1.03589,52.16369,-1.67023,-.57456,52.11755,-1.59855,-.5494,52.11009,-1.58357};
			return value;
		}
		private double[] getrrrib_Coord_7_130_point_7()
		{
			double[] value = {-.56346,52.19215,-1.56549,-.68798,52.2119,-1.53628,-.60039,52.19247,-1.53,-.56438,52.10891,-1.38215,-.50913,52.11482,-1.35487,-.56694,51.89,-1.43175,-.58101,51.95449,-1.4941,-.53297,52.17909,-1.54396,-.52141,51.95612,-1.46601,-1.16586,52.16702,-1.72304,-.7789,51.99999,-1.56486,-.89968,52.03238,-1.6022,-1.06157,52.03861,-1.62494,-1.21061,52.03955,-1.67267,-1.5644,51.85278,-1.48556,-1.67421,51.75844,-1.40846,-.94374,51.98604,-1.49627,-.8003,51.94284,-1.44844,-1.25055,52.11229,-1.50661,-.94426,52.28669,-1.5987,-.79068,51.96243,-1.50553,-.92096,51.99935,-1.5496,-2.3154,51.00666,-1.02418,-1.36907,52.0832,-1.51474,-1.7208,52.12471,-1.5817};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib2_Geo_6_135_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,13,15,14,-1,16,17,18,-1,19,20,21,-1,20,22,21,-1,21,23,19,-1,21,24,23,-1,25,26,27,-1,27,28,25,-1,29,30,31,-1,32,33,34,-1,35,36,37,-1,35,38,36,-1,39,40,5,-1,40,41,5,-1,42,43,44,-1,45,46,47,-1,46,48,47,-1,49,50,51,-1,51,52,49,-1,6,43,53,-1,6,54,43,-1,55,56,57,-1,57,58,55,-1,59,60,61,-1,60,62,61,-1,63,8,7,-1,64,65,66,-1,67,68,69,-1,69,70,67,-1,71,72,73,-1,74,75,76,-1,74,77,75,-1,78,79,80,-1,78,81,79,-1,69,82,75,-1,83,84,85,-1,84,86,85,-1,87,88,89,-1,88,90,89,-1,74,91,92,-1,92,93,74,-1,94,95,93,-1,94,96,95,-1,97,98,65,-1,99,65,100,-1,101,102,103,-1,102,104,103,-1,101,105,106,-1,101,103,105,-1,107,108,18,-1,107,109,108,-1,110,111,112,-1,111,113,112,-1,111,114,115,-1,111,110,114,-1,116,112,113,-1,116,117,112,-1,118,119,120,-1,119,121,120,-1,122,123,124,-1,123,125,124,-1,107,104,126,-1,126,109,107,-1,127,128,129,-1,127,130,128,-1,69,68,131,-1,132,133,134,-1,134,135,132,-1,136,137,138,-1,136,139,137,-1,140,141,142,-1,140,143,141,-1,144,145,146,-1,144,147,145,-1,65,148,149,-1,65,64,97,-1,150,4,151,-1,151,73,150,-1,66,65,99,-1,152,153,154,-1,153,45,154,-1,155,156,157,-1,155,152,156,-1,158,159,160,-1,158,161,159,-1,121,162,163,-1,121,119,162,-1,164,165,166,-1,164,167,165,-1,168,169,170,-1,170,171,168,-1,172,173,174,-1,172,175,173,-1,147,176,145,-1,147,177,176,-1,178,121,163,-1,178,179,121,-1,180,161,181,-1,180,159,161,-1,182,14,55,-1,62,183,57,-1,62,60,183,-1,183,60,184,-1,60,185,184,-1,186,6,8,-1,186,54,6,-1,150,73,187,-1,73,72,187,-1,188,189,12,-1,188,190,189,-1,13,132,135,-1,135,191,13,-1,27,192,23,-1,27,146,192,-1,21,193,24,-1,21,118,193,-1,22,118,21,-1,22,119,118,-1,194,195,196,-1,196,20,194,-1,191,136,197,-1,191,135,136,-1,49,63,50,-1,49,198,63,-1,62,56,61,-1,56,199,61,-1,200,29,160,-1,200,201,29,-1,202,31,203,-1,202,204,31,-1,205,137,139,-1,206,207,208,-1,209,177,210,-1,211,212,179,-1,174,200,213,-1,174,173,200,-1,171,175,172,-1,171,170,175,-1,166,169,168,-1,166,165,169,-1,193,167,164,-1,193,214,167,-1,215,216,217,-1,215,218,216,-1,219,220,221,-1,221,222,219,-1,223,224,225,-1,225,226,223,-1,81,87,89,-1,89,68,81,-1,41,3,5,-1,41,227,3,-1,228,48,229,-1,228,47,48,-1,100,65,149,-1,65,230,231,-1,146,145,232,-1,232,192,146,-1,233,143,140,-1,233,234,143,-1,235,236,237,-1,235,238,236,-1,189,133,132,-1,189,239,133,-1,240,241,242,-1,240,243,241,-1,104,107,244,-1,244,103,104,-1,245,110,246,-1,110,112,246,-1,111,163,113,-1,163,162,113,-1,247,248,122,-1,248,123,122,-1,243,249,250,-1,243,240,249,-1,242,125,17,-1,125,37,17,-1,123,248,251,-1,251,35,123,-1,249,252,108,-1,108,109,249,-1,240,242,16,-1,242,17,16,-1,253,247,122,-1,253,245,247,-1,102,126,104,-1,102,254,126,-1,255,256,257,-1,65,98,230,-1,258,259,76,-1,260,80,261,-1,11,10,262,-1,262,129,11,-1,263,88,87,-1,263,264,88,-1,262,131,127,-1,127,129,262,-1,231,148,65,-1,10,259,258,-1,10,9,259,-1,225,67,226,-1,225,79,67,-1,198,40,8,-1,40,86,8,-1,228,59,265,-1,59,61,265,-1,266,267,58,-1,57,56,62,-1,267,268,269,-1,269,270,267,-1,220,271,272,-1,220,273,271,-1,48,272,271,-1,271,229,48,-1,274,275,41,-1,7,6,276,-1,32,34,277,-1,195,194,278,-1,279,280,281,-1,282,180,181,-1,181,283,282,-1,284,55,14,-1,198,8,63,-1,2,285,286,-1,2,1,285,-1,199,265,61,-1,199,287,288,-1,215,287,199,-1,217,285,289,-1,286,285,217,-1,18,252,16,-1,18,108,252,-1,290,291,292,-1,290,293,291,-1,294,291,293,-1,294,295,291,-1,295,296,297,-1,294,296,295,-1,298,299,300,-1,197,299,298,-1,15,191,301,-1,13,191,15,-1,207,210,208,-1,302,210,207,-1};
			return value;
		}
		private int[] getrrib2_Geo_6_135_coordIndex_2()
		{
			int[] value = {303,202,203,-1,202,303,205,-1,304,305,306,-1,304,307,305,-1,121,212,120,-1,121,179,212,-1,211,178,308,-1,211,179,178,-1,40,274,41,-1,40,198,274,-1,309,42,310,-1,309,311,42,-1,46,312,313,-1,314,312,46,-1,310,153,309,-1,153,310,314,-1,315,271,316,-1,315,229,271,-1,51,185,52,-1,184,185,51,-1,53,317,318,-1,268,317,53,-1,316,273,319,-1,273,316,271,-1,270,311,320,-1,270,269,311,-1,270,182,267,-1,270,188,182,-1,7,50,63,-1,50,7,276,-1,266,57,183,-1,57,266,58,-1,268,266,317,-1,266,268,267,-1,59,229,315,-1,59,228,229,-1,274,49,319,-1,198,49,274,-1,66,321,224,-1,99,321,66,-1,260,73,151,-1,322,73,260,-1,91,76,259,-1,74,76,91,-1,72,11,187,-1,9,11,72,-1,323,92,91,-1,92,323,324,-1,325,231,326,-1,231,325,148,-1,3,263,4,-1,3,264,263,-1,150,5,4,-1,150,39,5,-1,83,129,128,-1,83,11,129,-1,327,64,223,-1,327,97,64,-1,99,328,321,-1,328,99,100,-1,329,148,325,-1,329,149,148,-1,96,230,98,-1,96,94,230,-1,225,80,79,-1,261,80,225,-1,330,322,260,-1,331,322,330,-1,95,70,77,-1,70,95,332,-1,90,127,89,-1,90,130,127,-1,84,8,86,-1,84,186,8,-1,333,334,335,-1,336,334,333,-1,337,219,222,-1,219,337,227,-1,250,254,338,-1,254,250,126,-1,339,243,340,-1,339,241,243,-1,253,124,341,-1,253,122,124,-1,246,247,245,-1,342,247,246,-1,252,240,16,-1,249,240,252,-1,244,38,343,-1,244,36,38,-1,248,344,251,-1,248,345,344,-1,35,125,123,-1,35,37,125,-1,109,250,249,-1,109,126,250,-1,342,343,345,-1,342,105,343,-1,124,242,241,-1,242,124,125,-1,338,346,347,-1,338,254,346,-1,348,278,33,-1,348,349,278,-1,346,350,349,-1,351,350,346,-1,352,32,277,-1,353,32,352,-1,354,339,340,-1,354,355,339,-1,114,356,115,-1,114,357,356,-1,354,348,353,-1,354,347,348,-1,356,277,308,-1,352,277,356,-1,195,358,196,-1,195,350,358,-1,359,113,162,-1,359,116,113,-1,360,106,117,-1,101,106,360,-1,103,343,105,-1,103,244,343,-1,355,341,339,-1,355,357,341,-1,257,361,362,-1,361,257,335,-1,155,311,309,-1,155,320,311,-1,239,190,157,-1,190,239,189,-1,234,237,236,-1,237,234,233,-1,363,208,364,-1,363,206,208,-1,192,365,366,-1,192,232,365,-1,33,194,34,-1,33,278,194,-1,94,92,326,-1,94,93,92,-1,47,265,367,-1,47,228,265,-1,219,273,220,-1,219,275,273,-1,336,90,88,-1,336,333,90,-1,361,312,368,-1,369,312,361,-1,334,221,369,-1,334,222,221,-1,81,263,87,-1,81,78,263,-1,321,370,261,-1,330,321,328,-1,321,330,370,-1,264,227,337,-1,264,3,227,-1,272,221,220,-1,221,272,313,-1,371,239,372,-1,133,239,371,-1,373,156,374,-1,373,372,156,-1,288,154,367,-1,154,288,374,-1,375,287,289,-1,373,287,375,-1,216,286,217,-1,216,376,286,-1,377,0,2,-1,377,378,0,-1,212,232,379,-1,232,212,365,-1,308,34,211,-1,308,277,34,-1,120,379,214,-1,120,212,379,-1,167,177,165,-1,167,176,177,-1,209,170,169,-1,209,380,170,-1,280,173,175,-1,173,280,279,-1,381,281,280,-1,382,281,381,-1,380,210,302,-1,380,209,210,-1,177,208,210,-1,177,147,208,-1,383,206,141,-1,206,383,207,-1,384,385,386,-1,384,387,385,-1,386,133,371,-1,134,133,386,-1,384,289,285,-1,375,289,384,-1,387,202,385,-1,387,204,202,-1,238,205,303,-1,238,137,205,-1,279,200,173,-1,279,201,200,-1,204,1,0,-1,387,1,204,-1,29,158,160,-1,158,29,31,-1,307,203,305,-1,307,303,203,-1,234,307,304,-1,307,234,236,-1,388,382,306,-1,388,281,382,-1,388,29,201,-1,29,388,30,-1,56,215,199,-1,56,218,215,-1,300,377,298,-1,300,378,377,-1,216,301,376,-1,301,216,15,-1,128,84,83,-1,255,84,128,-1,362,43,54,-1,362,44,43,-1,197,138,299,-1,197,136,138,-1,283,237,282,-1,283,235,237,-1,297,140,295,-1,297,233,140,-1,363,291,142,-1,291,363,292,-1,364,26,389,-1,364,144,26,-1,366,20,19,-1,366,194,20,-1,358,351,360,-1,351,358,350,-1,359,20,196,-1,359,22,20,-1,164,25,28,-1,164,166,25,-1,168,290,390,-1,168,171,290,-1,174,293,172,-1,293,174,294,-1,159,296,213,-1};
			return value;
		}
		private int[] getrrib2_Geo_6_135_coordIndex_3()
		{
			int[] value = {159,180,296,-1,294,213,296,-1,294,174,213,-1,172,290,171,-1,290,172,293,-1,390,166,168,-1,25,166,390,-1,28,193,164,-1,24,193,28,-1,358,117,116,-1,360,117,358,-1,192,19,23,-1,192,366,19,-1,144,27,26,-1,144,146,27,-1,364,292,363,-1,292,364,389,-1,142,295,140,-1,295,142,291,-1,282,233,297,-1,282,237,233,-1,299,235,283,-1,299,138,235,-1,12,132,13,-1,12,189,132,-1,320,188,270,-1,190,188,320,-1,54,257,362,-1,54,186,257,-1,10,82,262,-1,10,258,82,-1,40,85,86,-1,40,39,85,-1,268,43,269,-1,268,53,43,-1,182,58,267,-1,55,58,182,-1,284,216,218,-1,14,216,284,-1,216,14,15,-1,376,298,377,-1,298,376,301,-1,378,181,161,-1,181,378,300,-1,306,30,388,-1,305,30,306,-1,201,281,388,-1,281,201,279,-1,143,304,391,-1,143,234,304,-1,303,236,238,-1,303,307,236,-1,305,31,30,-1,31,305,203,-1,31,0,158,-1,204,0,31,-1,285,387,384,-1,285,1,387,-1,386,375,384,-1,386,371,375,-1,139,386,385,-1,139,134,386,-1,141,391,383,-1,141,143,391,-1,280,302,381,-1,280,380,302,-1,382,383,391,-1,381,383,382,-1,175,380,280,-1,170,380,175,-1,209,165,177,-1,165,209,169,-1,214,176,167,-1,214,379,176,-1,253,110,245,-1,110,253,114,-1,211,365,212,-1,365,211,34,-1,145,379,232,-1,145,176,379,-1,213,160,159,-1,213,200,160,-1,378,158,0,-1,378,161,158,-1,2,376,377,-1,286,376,2,-1,288,373,374,-1,288,287,373,-1,374,152,154,-1,156,152,374,-1,157,372,239,-1,157,156,372,-1,375,372,373,-1,371,372,375,-1,367,45,47,-1,154,45,367,-1,4,78,151,-1,78,4,263,-1,88,337,336,-1,337,88,264,-1,313,369,221,-1,313,312,369,-1,152,309,153,-1,152,155,309,-1,335,369,361,-1,334,369,335,-1,328,331,330,-1,331,328,329,-1,332,223,226,-1,223,332,327,-1,340,347,354,-1,340,338,347,-1,34,366,365,-1,366,34,194,-1,364,147,144,-1,364,208,147,-1,142,206,363,-1,142,141,206,-1,135,139,136,-1,135,134,139,-1,157,320,155,-1,190,320,157,-1,368,362,361,-1,362,368,44,-1,130,333,256,-1,90,333,130,-1,69,262,82,-1,69,131,262,-1,256,128,130,-1,256,255,128,-1,247,345,248,-1,247,342,345,-1,331,325,324,-1,325,331,329,-1,193,120,214,-1,120,193,118,-1,360,102,101,-1,102,360,351,-1,246,117,106,-1,246,112,117,-1,116,196,358,-1,359,196,116,-1,353,33,32,-1,353,348,33,-1,111,178,163,-1,111,115,178,-1,357,352,356,-1,355,352,357,-1,253,357,114,-1,253,341,357,-1,308,115,356,-1,178,115,308,-1,355,353,352,-1,354,353,355,-1,351,254,102,-1,351,346,254,-1,349,195,278,-1,350,195,349,-1,347,349,348,-1,347,346,349,-1,343,344,345,-1,343,38,344,-1,18,244,107,-1,18,36,244,-1,106,342,246,-1,342,106,105,-1,341,241,339,-1,341,124,241,-1,338,243,250,-1,338,340,243,-1,41,219,227,-1,219,41,275,-1,336,222,334,-1,336,337,222,-1,186,255,257,-1,186,84,255,-1,96,332,95,-1,327,332,96,-1,70,226,67,-1,70,332,226,-1,93,77,74,-1,77,93,95,-1,322,324,323,-1,322,331,324,-1,370,260,261,-1,260,370,330,-1,98,327,96,-1,327,98,97,-1,94,231,230,-1,94,326,231,-1,100,329,328,-1,329,100,149,-1,66,223,64,-1,223,66,224,-1,39,187,85,-1,39,150,187,-1,324,326,92,-1,326,324,325,-1,9,71,259,-1,9,72,71,-1,85,11,83,-1,11,85,187,-1,258,75,82,-1,76,75,258,-1,69,77,70,-1,75,77,69,-1,73,323,71,-1,322,323,73,-1,68,79,81,-1,68,67,79,-1,91,71,323,-1,91,259,71,-1,80,151,78,-1,151,80,260,-1,89,131,68,-1,89,127,131,-1,261,224,321,-1,261,225,224,-1,59,185,60,-1,59,315,185,-1,275,319,273,-1,275,274,319,-1,317,183,184,-1,266,183,317,-1,14,188,12,-1,188,14,182,-1,318,6,53,-1,318,276,6,-1,316,49,52,-1,319,49,316,-1,276,51,50,-1,276,318,51,-1,318,184,51,-1,317,184,318,-1,315,52,185,-1,315,316,52,-1,45,314,46,-1,153,314,45,-1,368,314,310,-1,312,314,368,-1,48,313,272,-1,46,313,48,-1,269,42,311,-1,269,43,42,-1,310,44,368,-1,310,42,44,-1,162,22,359,-1,22,162,119,-1,391,306,382,-1,391,304,306,-1};
			return value;
		}
		private int[] getrrib2_Geo_6_135_coordIndex_4()
		{
			int[] value = {385,205,139,-1,385,202,205,-1,207,381,302,-1,381,207,383,-1,283,300,299,-1,283,181,300,-1,197,301,191,-1,197,298,301,-1,180,297,296,-1,282,297,180,-1,292,390,290,-1,390,292,389,-1,25,389,26,-1,25,390,389,-1,24,27,23,-1,24,28,27,-1,138,238,235,-1,238,138,137,-1,17,36,18,-1,17,37,36,-1,251,38,35,-1,251,344,38,-1,55,218,56,-1,284,218,55,-1,199,367,265,-1,199,288,367,-1,256,335,257,-1,333,335,256,-1,289,215,217,-1,289,287,215,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib2_Coord_7_135_point_1()
		{
			double[] value = {-3.51323,50.10162,-1.90466,-3.2231,50.41233,-2.13673,-3.23482,50.3582,-2.15155,-.71523,51.54766,-1.81489,-.64764,51.52367,-1.78024,-.73052,51.49912,-1.83749,-1.21033,51.38398,-2.13082,-1.15386,51.41345,-2.11491,-1.07588,51.42401,-2.03808,-.66543,51.20588,-1.6641,-.68069,51.23596,-1.61296,-.75697,51.26523,-1.72351,-2.04505,51.24678,-2.35645,-2.45178,50.99497,-2.2869,-2.01875,51.2574,-2.44878,-2.45047,51.00596,-2.37035,-1.76272,48.80087,1.41932,-1.76933,48.78835,1.43042,-1.74406,48.81499,1.38886,-2.44073,48.76007,1.0532,-2.17313,48.74674,1.16267,-2.52059,48.67094,1.07084,-2.25998,48.64999,1.21202,-2.85728,48.76105,.83004,-2.93006,48.71189,.84816,-3.63464,48.7996,.30968,-3.52903,48.84695,.28802,-3.21987,48.79536,.59611,-3.28023,48.75376,.61039,-3.86104,49.72093,-1.37356,-3.79754,49.75777,-1.3374,-3.68804,49.93658,-1.58251,-1.88392,48.95351,1.31829,-1.85091,48.94823,1.28806,-2.16566,48.94101,1.21628,-1.8126,48.69668,1.47109,-1.75985,48.72096,1.41935,-1.79075,48.73709,1.45705,-1.79508,48.65967,1.46242,-.74573,51.45049,-1.86007,-.88633,51.47512,-1.96488,-.87175,51.52406,-1.95236,-1.43962,51.42378,-1.99313,-1.34525,51.35583,-2.10731,-1.38713,51.42757,-1.96707,-1.29211,51.70712,-2.23675,-1.23095,51.69942,-2.20342,-1.25564,51.65917,-2.31689,-1.19679,51.64373,-2.26294,-1.05072,51.4775,-2.11394,-1.10128,51.43469,-2.14833,-1.16488,51.41268,-2.23593,-1.1296,51.46852,-2.20693,-1.26292,51.36169,-2.19127,-1.28551,51.36623,-2.06266,-1.68504,51.37954,-2.44038,-1.64688,51.40158,-2.53605,-1.44711,51.41865,-2.38379,-1.46003,51.39553,-2.35192,-1.24087,51.53383,-2.38458,-1.25464,51.48085,-2.39434,-1.40023,51.52715,-2.42704,-1.41399,51.45265,-2.41638,-1.09404,51.44519,-2.09895,-.49393,51.42705,-1.50614,-.48679,51.3824,-1.53895,-.49915,51.43648,-1.53945,-.59222,51.51816,-1.38352,-.61738,51.52629,-1.39258,-.59963,51.36913,-1.30825,-.58129,51.38506,-1.31943,-.60832,51.24679,-1.70675,-.63538,51.26029,-1.72157,-.6023,51.36957,-1.78253,-.5712,51.14991,-1.46903,-.5874,51.20192,-1.3318,-.58878,51.14593,-1.46929,-.56103,51.21708,-1.34487,-.61836,51.58402,-1.69003,-.60053,51.59666,-1.53753,-.59535,51.57048,-1.6731,-.6299,51.60766,-1.5438,-.62192,51.25192,-1.40367,-.8534,51.31121,-1.77309,-1.00339,51.34881,-1.85575,-.79513,51.36092,-1.83714,-.94168,51.38604,-1.93879,-.69068,51.59766,-1.60488,-.78499,51.60077,-1.69002,-.72216,51.53978,-1.49604,-.84807,51.55706,-1.60561,-.58245,51.17924,-1.60749,-.54948,51.21004,-1.58905,-.54848,51.19735,-1.47648,-.51618,51.25816,-1.48627,-.53306,51.25798,-1.37906,-.50818,51.3097,-1.42732,-.49132,51.40083,-1.49148,-.49118,51.3464,-1.48116,-.49803,51.42615,-1.56944};
			return value;
		}
		private double[] getrrib2_Coord_7_135_point_2()
		{
			double[] value = {-.49494,51.4088,-1.59616,-1.66098,48.64701,1.38367,-1.63197,48.85667,1.32534,-1.66181,48.66414,1.39395,-1.64518,48.84771,1.34938,-1.7234,48.55259,1.48796,-1.73124,48.54217,1.47609,-1.69573,48.85398,1.34906,-1.74548,48.82106,1.39376,-1.71286,48.87194,1.36717,-1.89993,48.57058,1.54657,-1.99167,48.57446,1.49366,-1.87487,48.54988,1.51583,-1.97235,48.55179,1.47134,-1.88045,48.65046,1.54144,-1.98096,48.65561,1.50371,-1.90678,48.5774,1.41293,-1.8066,48.56135,1.44424,-2.639,48.59835,1.12254,-2.36332,48.58745,1.29942,-2.68106,48.60295,1.17829,-2.39543,48.59624,1.3175,-1.79658,48.62929,1.57271,-1.85644,48.6529,1.52331,-1.76233,48.74485,1.53291,-1.79955,48.74962,1.48206,-1.64268,48.86903,1.35905,-.74996,51.47891,-1.51687,-.89604,51.39375,-1.65622,-.78125,51.36292,-1.58745,-.86679,51.50384,-1.62004,-.66318,51.43033,-1.42284,-2.43817,51.05029,-2.16056,-2.44659,51.09941,-2.11691,-2.72216,50.83414,-1.98803,-2.70526,50.78481,-2.01327,-3.00202,50.43296,-1.75848,-3.18748,50.2149,-1.53114,-3.17478,50.18319,-1.53805,-2.99905,50.48431,-1.7546,-3.45937,49.55991,-.82626,-3.54128,49.44671,-.57608,-3.4893,49.42694,-.59669,-3.49656,49.5924,-.81822,-3.33503,49.00352,.2765,-3.12888,48.96206,.62256,-3.08464,48.92401,.59156,-3.40062,49.03802,.316,-.5004,51.34488,-1.57483,-.50013,51.37333,-1.59629,-.66907,51.41175,-1.81065,-.58491,51.50198,-1.77362,-1.51527,51.67112,-2.18644,-1.34121,51.71198,-2.11189,-1.46217,51.69931,-2.31771,-1.55815,51.56828,-2.0514,-1.74123,51.61978,-2.25706,-1.78694,51.49206,-2.14453,-3.7504,49.8478,-1.6695,-3.90456,49.60271,-1.47335,-3.94823,49.62851,-1.45992,-3.72493,49.79058,-1.67812,-2.07688,48.56917,1.42484,-2.10241,48.5838,1.44223,-3.46316,48.63703,.62889,-3.82785,48.71773,.34519,-3.78403,48.69747,.32242,-3.51909,48.64762,.65296,-3.97074,48.79776,-.03709,-3.99484,48.82342,-.03341,-4.08513,48.96479,-.34128,-4.07598,48.92878,-.36305,-4.10337,49.03765,-.62023,-4.14367,49.24332,-.93363,-4.12018,49.22424,-.96002,-4.11935,49.07016,-.59162,-3.34754,48.83357,.65639,-3.61023,48.8857,.31655,-2.07362,48.66628,1.45437,-2.32493,48.7315,1.31398,-3.80145,49.63974,-1.36972,-3.65386,49.83053,-1.57263,-1.70333,51.35249,-2.41167,-1.29241,51.43812,-2.38965,-1.22408,51.41475,-2.3166,-1.19145,51.47036,-2.30064,-1.13867,51.37705,-1.95983,-.71417,51.32653,-1.78144,-1.74278,51.32951,-2.30032,-2.0869,51.27625,-2.19543,-1.79211,51.38366,-2.1616,-2.76334,50.72297,-2.13176,-2.72405,48.91016,.83617,-3.08357,48.6114,.87244,-2.12378,48.92021,1.16857,-1.80611,48.91039,1.25691,-1.89523,48.71922,1.29467,-3.1169,50.37012,-1.92578,-1.03122,51.47854,-2.08286,-1.65857,51.49169,-2.54075};
			return value;
		}
		private double[] getrrib2_Coord_7_135_point_3()
		{
			double[] value = {-4.10995,49.4264,-1.21163,-4.01424,49.49557,-1.11551,-3.39734,50.22449,-1.6704,-3.58301,49.9543,-1.41923,-3.48653,50.16559,-1.79309,-3.29847,50.22766,-1.5973,-3.55844,49.31067,-.32916,-3.67668,49.25286,-.31405,-3.51665,49.18164,-.03222,-3.83982,48.96115,-.02759,-3.77255,49.02016,-.02325,-2.28739,48.79375,1.3071,-2.57298,48.76872,1.1668,-4.08102,49.39505,-1.21224,-3.15434,48.61364,.91617,-2.00184,51.34422,-2.58984,-2.42771,50.98717,-2.55632,-2.44893,51.05346,-2.55346,-1.98169,51.25566,-2.57945,-1.00176,51.57847,-2.06328,-1.07033,51.62635,-2.15519,-1.11468,51.69645,-2.09785,-1.03447,51.67052,-2.03493,-.5007,51.47175,-1.47332,-.51962,51.49381,-1.54914,-.54649,51.53214,-1.54645,-.54407,51.49798,-1.4245,-.85695,51.57334,-1.93983,-1.23338,51.58358,-2.36996,-1.17941,51.57028,-2.29368,-.50048,51.32039,-1.51261,-.50129,51.31654,-1.55338,-2.77158,48.93919,.87143,-3.41863,49.67064,-.99432,-3.45061,49.69603,-.97265,-3.3033,49.95327,-1.31923,-3.39419,49.84918,-1.16311,-3.36482,49.8032,-1.15552,-3.30707,50.01356,-1.33624,-2.11078,51.33595,-2.15962,-1.74103,48.86521,1.40423,-1.70871,48.86286,1.45851,-1.77014,48.82084,1.4321,-1.67702,48.89894,1.40727,-1.73161,48.70067,1.39899,-1.82811,48.5547,1.58803,-1.81326,48.52842,1.56653,-1.79696,48.56529,1.57689,-1.8662,48.61586,1.52817,-1.73094,48.88006,1.38362,-1.66037,48.88721,1.38807,-1.82328,48.67602,1.47764,-1.75137,48.82111,1.40519,-1.81242,48.63628,1.58758,-1.64257,48.89374,1.34017,-1.04038,51.42999,-1.75398,-1.01964,51.50753,-1.73309,-1.18526,51.45316,-1.85043,-.61501,51.18898,-1.51083,-.60687,51.17667,-1.6234,-.56357,51.49231,-1.75306,-.54806,51.52772,-1.64006,-.68887,51.31873,-1.51529,-.67349,51.58674,-1.72114,-.73061,51.60596,-1.7686,-1.39726,51.56475,-2.42339,-1.33532,51.40109,-2.35023,-1.3803,51.37539,-2.2899,-1.31787,51.35928,-2.2444,-1.40415,51.34869,-2.15191,-1.46482,51.34446,-2.1963,-1.12471,51.56302,-2.21745,-1.13702,51.63256,-2.20897,-1.0586,51.5631,-2.14169,-1.02176,51.51138,-2.07633,-1.01192,51.54472,-2.0698,-1.15971,51.40332,-2.16075,-1.93296,48.90795,1.36545,-1.82506,48.93385,1.26759,-4.03117,49.34823,-.87269,-3.98259,49.18977,-.5628,-3.97097,49.38726,-.86192,-3.70373,49.65794,-1.30827,-3.58421,49.84671,-1.49819,-1.99163,51.25382,-2.54595,-2.85865,50.77275,-2.3719,-2.84051,50.72224,-2.39796,-2.02891,51.42248,-2.55983,-1.68443,51.57781,-2.49494,-2.46545,51.11035,-2.52407,-3.9095,49.02974,-.3447,-3.88297,49.18154,-.58758,-3.82447,49.06174,-.33832,-3.96281,49.14075,-.58942,-3.95987,49.30187,-.91555,-3.87961,49.33968,-.91131,-3.91479,49.47176,-1.14556,-3.80403,49.50461,-1.11837,-3.16003,50.35903,-1.99348,-3.37176,50.09175,-1.71584};
			return value;
		}
		private double[] getrrib2_Coord_7_135_point_4()
		{
			double[] value = {-3.43596,50.06565,-1.77352,-2.79546,50.70937,-2.19859,-3.85199,49.15451,-.30539,-3.44828,49.98074,-1.37296,-3.58795,49.66543,-.99826,-3.67923,49.78957,-1.2351,-3.76792,49.61729,-1.0306,-3.51697,49.84029,-1.21514,-2.01784,48.79294,1.41787,-1.42134,51.58461,-1.97899,-1.37568,51.58979,-1.95209,-1.49177,51.42133,-2.01911,-1.23773,51.706,-2.05077,-1.17514,51.69614,-2.15058,-1.28965,51.70825,-2.08137,-1.18195,51.51991,-2.29562,-1.12261,51.51389,-2.20672,-1.27044,51.38202,-2.2946,-1.21444,51.38215,-2.23129,-1.04745,51.51756,-2.11849,-1.56344,51.40977,-2.05805,-.51303,51.47358,-1.60279,-.58191,51.36232,-1.76221,-.58508,51.25721,-1.6954,-.54392,51.28095,-1.65348,-.51346,51.30922,-1.60888,-.51107,51.26635,-1.56534,-.502,51.42131,-1.43711,-.50863,51.43421,-1.65488,-.51521,51.3631,-1.64995,-.53778,51.46724,-1.7093,-.55046,51.36335,-1.71425,-.53084,51.41045,-1.38934,-.99377,51.59826,-1.72492,-1.08299,51.67531,-1.94077,-1.14981,51.60803,-1.82751,-.93457,51.64732,-1.81608,-.88172,51.64873,-1.90254,-1.66034,48.91836,1.3699,-1.71706,48.87924,1.46379,-1.68105,48.92856,1.40254,-1.77397,48.75051,1.5428,-1.79287,48.54283,1.5652,-1.7821,48.59387,1.47816,-1.8239,48.65588,1.48147,-1.8572,48.59254,1.52603,-1.68596,48.90655,1.31851,-1.70689,48.92867,1.3442,-1.77738,48.9401,1.314,-1.75411,48.92178,1.29103,-1.73784,48.89437,1.27796,-1.6722,48.87523,1.30292,-1.85013,48.90496,1.39575,-1.80793,48.9493,1.34693,-1.73524,48.94155,1.38006,-1.77164,48.89491,1.43102,-1.92043,48.78688,1.46655,-1.82875,48.77469,1.50996,-1.80136,48.70152,1.32194,-1.99751,48.60481,1.37563,-1.71401,48.66958,1.35373,-1.2834,51.6028,-1.89806,-1.33423,51.43269,-1.94092,-3.48284,49.28281,-.3583,-3.44694,49.15046,-.07025,-2.40999,48.9337,1.08505,-2.35149,48.91086,1.05712,-1.43764,51.64563,-2.3732,-1.3297,51.5959,-1.92511,-1.18511,51.70512,-2.02009,-.54454,51.49744,-1.67468,-2.49493,51.19023,-2.25939,-2.06488,51.47941,-2.30938,-2.05067,51.47783,-2.46861,-1.69519,51.64404,-2.40821,-2.49035,51.18697,-2.42286,-2.81122,50.6673,-2.39978,-3.23044,50.30079,-2.14558,-3.50454,50.03413,-1.90789,-2.99844,48.79875,.91448,-3.94568,49.07623,-.31632,-3.84326,49.30162,-.56677,-3.82136,49.46517,-.81994,-3.69566,49.37494,-.56828,-2.85811,50.857,-2.25874,-3.17801,50.50172,-1.87886,-2.80188,50.90006,-2.09789,-3.23161,50.46072,-2.01375,-3.9296,49.54447,-1.08034,-3.71897,48.95207,-.06871,-3.80337,48.90731,-.05856,-3.63913,49.53856,-.81904};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib3_Geo_6_140_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,7,10,8,-1,11,12,13,-1,11,14,12,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,22,23,24,-1,25,26,27,-1,28,29,30,-1,28,31,29,-1,28,30,32,-1,33,34,35,-1,34,36,35,-1,37,38,39,-1,40,41,42,-1,41,43,42,-1,44,45,46,-1,45,47,46,-1,43,48,49,-1,43,41,48,-1,50,51,52,-1,52,53,50,-1,54,55,56,-1,57,58,59,-1,58,60,59,-1,61,62,63,-1,64,65,61,-1,66,2,67,-1,66,27,2,-1,58,57,68,-1,68,69,58,-1,70,71,72,-1,73,74,75,-1,75,76,73,-1,77,78,79,-1,78,80,79,-1,81,82,83,-1,84,85,86,-1,84,87,85,-1,87,88,85,-1,87,89,88,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,96,97,94,-1,67,80,66,-1,98,99,56,-1,56,100,98,-1,101,102,103,-1,104,105,106,-1,106,107,104,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,113,115,114,-1,116,117,118,-1,118,16,116,-1,119,18,120,-1,120,121,119,-1,122,123,124,-1,125,126,127,-1,127,128,125,-1,129,130,131,-1,130,132,131,-1,133,134,135,-1,136,137,138,-1,138,139,136,-1,140,141,142,-1,141,143,142,-1,144,145,146,-1,145,147,146,-1,148,149,150,-1,148,151,149,-1,152,153,154,-1,152,155,153,-1,23,156,157,-1,157,24,23,-1,158,159,160,-1,158,161,159,-1,162,163,164,-1,164,19,162,-1,165,166,167,-1,167,161,165,-1,158,160,21,-1,160,168,21,-1,169,170,171,-1,171,172,169,-1,173,174,175,-1,174,176,175,-1,165,177,178,-1,178,166,165,-1,20,178,177,-1,20,179,178,-1,180,181,182,-1,182,183,180,-1,184,185,186,-1,186,187,184,-1,188,189,190,-1,190,191,188,-1,192,193,194,-1,192,195,193,-1,192,196,71,-1,196,197,71,-1,198,199,38,-1,199,200,38,-1,201,202,203,-1,201,204,202,-1,205,206,207,-1,208,209,210,-1,112,211,113,-1,112,212,211,-1,213,214,215,-1,102,205,216,-1,217,218,219,-1,220,107,218,-1,101,103,221,-1,103,222,221,-1,107,223,104,-1,213,224,210,-1,106,218,107,-1,225,226,227,-1,225,228,226,-1,229,230,89,-1,231,232,233,-1,231,229,232,-1,234,210,235,-1,22,236,23,-1,102,237,238,-1,238,103,102,-1,239,240,241,-1,241,200,239,-1,38,242,39,-1,38,243,242,-1,244,245,204,-1,245,246,204,-1,247,248,107,-1,107,220,247,-1,244,222,103,-1,249,141,250,-1,249,251,141,-1,252,253,12,-1,253,254,12,-1,255,256,257,-1,256,258,257,-1,259,260,261,-1,260,186,261,-1,262,263,264,-1,264,265,262,-1,189,69,190,-1,189,266,69,-1,48,41,267,-1,41,268,267,-1,33,269,270,-1,270,34,33,-1,271,272,273,-1,273,274,271,-1,275,68,276,-1,68,57,276,-1,275,277,68,-1,278,279,280,-1,224,281,210,-1,261,186,282,-1,186,185,282,-1,257,258,283,-1,258,284,283,-1,31,0,26,-1,31,285,0,-1,286,251,287,-1,286,288,251,-1,11,123,122,-1,11,13,123,-1,289,9,254,-1,289,7,9,-1,252,290,253,-1,252,291,290,-1,290,292,293,-1,290,294,292,-1,295,296,297,-1,134,298,299,-1,134,300,298,-1,274,301,302,-1,301,118,302,-1,17,303,15,-1,17,304,303,-1,272,305,306,-1,305,307,306,-1,257,7,289,-1,257,283,7,-1,308,309,310,-1,310,5,308,-1,256,255,311,-1,255,312,311,-1,313,307,314,-1,314,315,313,-1,316,317,311,-1,311,315,316,-1,284,282,318,-1,282,319,318,-1,310,320,321,-1,322,323,317,-1,317,316,322,-1,321,324,325,-1,321,320,324,-1,326,327,328,-1,326,329,327,-1,184,330,331,-1,184,183,330,-1,332,333,334,-1,335,336,337,-1,336,36,337,-1,338,339,275,-1,275,340,338,-1,96,341,342,-1,342,97,96,-1,40,343,269,-1,343,270,269,-1,263,93,90,-1,90,336,263,-1,344,345,92,-1,92,91,344,-1,77,94,78,-1,77,346,94,-1,347,348,349,-1,348,350,349,-1,243,241,351,-1,351,352,243,-1,353,354,248,-1,248,247,353,-1,210,355,356,-1,210,357,358,-1,357,210,281,-1,355,210,209,-1,213,210,359,-1,360,361,221,-1,268,362,363,-1,95,91,96,-1,95,344,91,-1,35,336,90,-1,35,36,336,-1,364,51,365,-1,365,366,364,-1,367,342,341,-1,367,197,342,-1,182,181,75,-1,75,74,182,-1,368,369,61,-1};
			return value;
		}
		private int[] getrrib3_Geo_6_140_coordIndex_2()
		{
			int[] value = {26,0,2,-1,2,27,26,-1,364,52,51,-1,364,278,52,-1,264,335,332,-1,332,330,264,-1,188,370,189,-1,371,280,329,-1,330,182,265,-1,330,183,182,-1,372,334,324,-1,372,331,334,-1,186,370,187,-1,186,260,370,-1,324,320,319,-1,319,372,324,-1,323,260,259,-1,259,317,323,-1,314,6,373,-1,314,4,6,-1,307,4,314,-1,307,305,4,-1,10,374,375,-1,374,309,375,-1,306,313,292,-1,306,307,313,-1,309,308,271,-1,271,375,309,-1,375,271,274,-1,274,302,375,-1,299,273,376,-1,299,298,273,-1,291,294,290,-1,291,377,294,-1,378,379,130,-1,291,131,380,-1,381,125,128,-1,128,382,381,-1,125,381,11,-1,11,122,125,-1,383,151,384,-1,151,148,384,-1,169,172,385,-1,261,282,284,-1,284,258,261,-1,187,180,184,-1,180,183,184,-1,30,29,194,-1,194,193,30,-1,266,326,328,-1,383,178,386,-1,178,179,386,-1,301,274,298,-1,274,273,298,-1,190,69,387,-1,387,388,190,-1,378,130,389,-1,130,390,389,-1,220,391,233,-1,233,247,220,-1,105,392,393,-1,105,104,392,-1,394,113,211,-1,394,395,113,-1,396,397,398,-1,398,399,396,-1,111,114,400,-1,114,401,400,-1,349,402,403,-1,349,350,402,-1,399,202,404,-1,404,396,399,-1,38,241,243,-1,38,200,241,-1,210,358,405,-1,406,407,156,-1,407,408,156,-1,210,405,208,-1,228,225,212,-1,409,231,391,-1,231,233,391,-1,234,359,210,-1,228,109,226,-1,228,110,109,-1,226,109,105,-1,105,393,226,-1,392,410,215,-1,411,412,413,-1,212,414,211,-1,235,210,356,-1,89,348,347,-1,89,230,348,-1,415,416,417,-1,415,418,416,-1,199,245,200,-1,245,239,200,-1,419,342,197,-1,197,196,419,-1,192,194,420,-1,420,196,192,-1,326,266,370,-1,266,189,370,-1,280,327,329,-1,176,159,421,-1,176,174,159,-1,163,162,155,-1,155,152,163,-1,236,422,173,-1,236,22,422,-1,163,423,164,-1,163,424,423,-1,425,426,427,-1,407,136,139,-1,139,428,407,-1,428,429,408,-1,408,407,428,-1,408,288,286,-1,408,429,288,-1,430,132,431,-1,430,432,132,-1,250,433,434,-1,433,435,434,-1,389,390,382,-1,390,381,382,-1,436,249,437,-1,249,438,437,-1,117,302,118,-1,439,115,395,-1,115,113,395,-1,111,110,112,-1,112,114,111,-1,109,108,106,-1,106,105,109,-1,93,96,91,-1,93,341,96,-1,100,55,440,-1,100,56,55,-1,441,442,443,-1,441,37,442,-1,444,445,440,-1,444,417,445,-1,89,446,88,-1,89,347,446,-1,345,447,448,-1,449,346,86,-1,86,85,449,-1,450,27,66,-1,78,451,80,-1,451,66,80,-1,32,452,388,-1,388,387,32,-1,453,76,454,-1,76,75,454,-1,455,341,262,-1,275,339,1,-1,1,277,275,-1,64,61,369,-1,62,61,65,-1,61,63,368,-1,456,457,279,-1,279,458,456,-1,57,59,459,-1,459,276,57,-1,460,39,55,-1,39,242,55,-1,47,53,371,-1,53,52,371,-1,42,365,51,-1,51,50,42,-1,456,461,369,-1,343,40,50,-1,40,42,50,-1,442,37,460,-1,37,39,460,-1,462,334,333,-1,462,463,334,-1,25,29,26,-1,29,31,26,-1,193,452,32,-1,32,30,193,-1,367,341,455,-1,71,197,72,-1,197,367,72,-1,22,24,464,-1,464,385,22,-1,464,169,385,-1,179,465,386,-1,17,16,118,-1,0,285,277,-1,277,1,0,-1,265,264,330,-1,5,321,3,-1,321,5,310,-1,67,82,80,-1,67,83,82,-1,314,316,315,-1,373,316,314,-1,466,467,120,-1,468,467,466,-1,22,469,422,-1,385,469,22,-1,422,470,471,-1,422,469,470,-1,73,262,74,-1,73,455,262,-1,70,73,76,-1,73,70,72,-1,193,453,452,-1,193,195,453,-1,333,472,462,-1,472,333,337,-1,362,473,363,-1,362,474,473,-1,475,476,477,-1,476,475,478,-1,92,35,90,-1,35,92,474,-1,343,53,479,-1,343,50,53,-1,461,458,480,-1,456,458,461,-1,54,460,55,-1,49,460,54,-1,365,43,481,-1,42,43,365,-1,329,47,371,-1,46,47,329,-1,459,480,276,-1,459,461,480,-1,456,368,457,-1,456,369,368,-1,457,63,482,-1,457,368,63,-1,452,454,388,-1,452,453,454,-1,483,32,387,-1,28,32,483,-1,416,445,417,-1,445,416,79,-1,77,86,346,-1,77,484,86,-1,485,416,418,-1,485,484,416,-1,486,345,344,-1,345,486,447,-1,473,448,475,-1,345,448,473,-1,198,476,487,-1,198,441,476,-1,349,446,347,-1};
			return value;
		}
		private int[] getrrib3_Geo_6_140_coordIndex_3()
		{
			int[] value = {349,488,446,-1,440,242,444,-1,440,55,242,-1,49,442,460,-1,49,48,442,-1,440,82,100,-1,82,440,445,-1,33,268,269,-1,33,362,268,-1,439,489,490,-1,439,395,489,-1,221,491,101,-1,221,361,491,-1,467,492,493,-1,492,467,494,-1,423,495,496,-1,424,495,423,-1,494,147,496,-1,494,146,147,-1,497,498,499,-1,497,500,498,-1,501,502,503,-1,501,504,502,-1,11,390,14,-1,390,11,381,-1,435,389,382,-1,433,389,435,-1,438,250,434,-1,249,250,438,-1,143,429,505,-1,143,288,429,-1,506,379,142,-1,379,506,431,-1,507,295,508,-1,296,295,507,-1,509,510,511,-1,512,510,509,-1,431,427,430,-1,427,431,506,-1,506,425,427,-1,505,425,506,-1,428,505,429,-1,428,425,505,-1,139,425,428,-1,425,139,426,-1,427,513,514,-1,427,426,513,-1,515,148,512,-1,384,148,515,-1,434,500,497,-1,500,434,435,-1,389,140,378,-1,389,433,140,-1,514,508,516,-1,514,507,508,-1,517,146,468,-1,517,144,146,-1,150,518,297,-1,150,149,518,-1,519,167,515,-1,167,519,421,-1,152,503,502,-1,154,503,152,-1,385,153,469,-1,385,172,153,-1,173,406,236,-1,406,173,175,-1,162,470,155,-1,162,168,470,-1,464,157,520,-1,464,24,157,-1,450,196,420,-1,419,196,450,-1,97,419,451,-1,419,97,342,-1,454,181,191,-1,454,75,181,-1,239,244,103,-1,245,244,239,-1,115,401,114,-1,401,115,521,-1,522,523,398,-1,522,524,523,-1,397,230,525,-1,230,397,348,-1,486,446,447,-1,486,88,446,-1,246,402,404,-1,246,526,402,-1,361,527,490,-1,361,360,527,-1,235,414,212,-1,235,356,414,-1,356,528,414,-1,356,355,528,-1,227,234,225,-1,359,234,227,-1,529,411,237,-1,411,529,412,-1,530,401,524,-1,530,400,401,-1,527,531,532,-1,531,527,203,-1,391,530,409,-1,391,217,530,-1,531,398,523,-1,531,399,398,-1,354,533,248,-1,354,534,533,-1,393,227,226,-1,393,214,227,-1,111,219,108,-1,111,400,219,-1,357,413,412,-1,413,357,281,-1,392,214,393,-1,215,214,392,-1,414,394,211,-1,394,414,528,-1,205,405,216,-1,205,208,405,-1,412,358,357,-1,412,529,358,-1,232,84,353,-1,232,87,84,-1,490,532,439,-1,532,490,527,-1,404,350,396,-1,350,404,402,-1,488,475,448,-1,488,478,475,-1,110,212,112,-1,110,228,212,-1,522,231,409,-1,231,522,525,-1,535,536,537,-1,536,535,538,-1,413,223,537,-1,413,410,223,-1,491,102,101,-1,205,102,491,-1,411,537,536,-1,411,413,537,-1,396,348,397,-1,396,350,348,-1,130,14,390,-1,130,129,14,-1,180,370,188,-1,370,180,187,-1,463,539,325,-1,463,540,539,-1,541,34,270,-1,541,472,34,-1,301,300,304,-1,301,298,300,-1,271,305,272,-1,308,305,271,-1,383,166,178,-1,384,166,383,-1,542,303,543,-1,303,542,544,-1,502,163,152,-1,502,424,163,-1,157,287,520,-1,287,157,286,-1,176,519,137,-1,176,421,519,-1,436,520,287,-1,436,170,520,-1,174,422,471,-1,174,173,422,-1,276,340,275,-1,340,276,480,-1,59,64,459,-1,59,65,64,-1,482,58,328,-1,58,482,60,-1,418,545,534,-1,418,415,545,-1,262,93,263,-1,262,341,93,-1,162,21,168,-1,162,19,21,-1,386,147,145,-1,465,147,386,-1,519,512,509,-1,515,512,519,-1,504,424,502,-1,424,504,495,-1,438,497,501,-1,434,497,438,-1,432,131,132,-1,380,131,432,-1,288,141,251,-1,288,143,141,-1,516,432,430,-1,516,546,432,-1,547,291,380,-1,547,377,291,-1,376,377,299,-1,376,294,377,-1,546,134,547,-1,546,135,134,-1,543,295,542,-1,295,543,133,-1,273,306,376,-1,273,272,306,-1,544,468,466,-1,517,468,544,-1,127,119,121,-1,119,127,126,-1,117,124,123,-1,116,124,117,-1,302,10,375,-1,8,10,302,-1,292,312,293,-1,292,313,312,-1,318,309,374,-1,318,310,309,-1,548,282,185,-1,372,282,548,-1,282,372,319,-1,549,540,44,-1,539,540,549,-1,329,323,322,-1,329,326,323,-1,331,185,184,-1,372,185,331,-1,548,185,372,-1,334,325,324,-1,334,463,325,-1,550,44,540,-1,550,45,44,-1,337,332,335,-1,332,337,333,-1,541,45,550,-1,541,479,45,-1,52,280,371,-1,52,278,280,-1,68,387,69,-1,68,483,387,-1,482,327,457,-1,328,327,482,-1,266,58,69,-1,328,58,266,-1,99,338,366,-1,99,98,338,-1,420,27,450,-1,27,420,25,-1,72,455,73,-1};
			return value;
		}
		private int[] getrrib3_Geo_6_140_coordIndex_4()
		{
			int[] value = {455,72,367,-1,366,481,99,-1,366,365,481,-1,441,477,476,-1,441,443,477,-1,415,351,545,-1,352,351,415,-1,439,521,115,-1,439,532,521,-1,351,240,538,-1,351,241,240,-1,545,538,535,-1,545,351,538,-1,199,246,245,-1,199,526,246,-1,199,487,526,-1,199,198,487,-1,485,353,84,-1,353,485,354,-1,352,417,444,-1,352,415,417,-1,488,447,446,-1,488,448,447,-1,243,444,242,-1,243,352,444,-1,363,267,268,-1,363,551,267,-1,194,25,420,-1,29,25,194,-1,81,1,339,-1,81,83,1,-1,364,279,278,-1,364,458,279,-1,483,277,285,-1,483,68,277,-1,270,479,541,-1,270,343,479,-1,264,336,335,-1,264,263,336,-1,331,332,334,-1,331,330,332,-1,46,322,552,-1,46,329,322,-1,6,539,549,-1,3,539,6,-1,373,549,552,-1,373,6,549,-1,319,310,318,-1,319,320,310,-1,259,311,317,-1,311,259,256,-1,313,311,312,-1,311,313,315,-1,284,374,283,-1,284,318,374,-1,293,255,553,-1,293,312,255,-1,8,117,123,-1,117,8,302,-1,126,116,119,-1,126,124,116,-1,121,498,127,-1,121,493,498,-1,303,466,15,-1,303,544,466,-1,17,301,304,-1,301,17,118,-1,133,300,134,-1,133,543,300,-1,542,297,518,-1,297,542,295,-1,135,516,508,-1,546,516,135,-1,547,299,377,-1,299,547,134,-1,376,292,294,-1,306,292,376,-1,380,546,547,-1,432,546,380,-1,509,513,138,-1,509,511,513,-1,290,553,253,-1,293,553,290,-1,9,12,254,-1,13,12,9,-1,438,503,437,-1,438,501,503,-1,138,519,509,-1,519,138,137,-1,469,155,470,-1,469,153,155,-1,28,285,31,-1,28,483,285,-1,182,262,265,-1,74,262,182,-1,534,535,533,-1,534,545,535,-1,63,60,482,-1,60,63,62,-1,64,461,459,-1,64,369,461,-1,366,340,364,-1,366,338,340,-1,471,159,174,-1,471,160,159,-1,165,554,177,-1,554,165,555,-1,465,164,423,-1,164,465,179,-1,176,136,175,-1,137,136,176,-1,437,170,436,-1,170,437,171,-1,145,383,386,-1,145,151,383,-1,544,518,517,-1,544,542,518,-1,543,304,300,-1,303,304,543,-1,308,4,305,-1,5,4,308,-1,3,325,539,-1,3,321,325,-1,463,550,540,-1,463,462,550,-1,550,472,541,-1,550,462,472,-1,98,339,338,-1,98,81,339,-1,188,181,180,-1,191,181,188,-1,289,255,257,-1,553,255,289,-1,259,258,256,-1,259,261,258,-1,553,254,253,-1,553,289,254,-1,129,12,14,-1,129,252,12,-1,249,287,251,-1,249,436,287,-1,536,237,411,-1,237,536,238,-1,538,238,536,-1,238,538,240,-1,537,533,535,-1,537,223,533,-1,525,229,231,-1,229,525,230,-1,233,353,247,-1,233,232,353,-1,206,395,394,-1,395,206,489,-1,103,240,239,-1,103,238,240,-1,94,449,95,-1,94,346,449,-1,358,216,405,-1,529,216,358,-1,528,206,394,-1,528,207,206,-1,281,410,413,-1,281,224,410,-1,229,87,232,-1,87,229,89,-1,449,88,486,-1,88,449,85,-1,219,106,108,-1,106,219,218,-1,248,223,107,-1,248,533,223,-1,534,485,418,-1,354,485,534,-1,399,203,202,-1,399,531,203,-1,409,524,522,-1,409,530,524,-1,220,217,391,-1,220,218,217,-1,201,221,222,-1,201,360,221,-1,523,532,531,-1,523,521,532,-1,217,400,530,-1,217,219,400,-1,216,237,102,-1,237,216,529,-1,410,213,215,-1,224,213,410,-1,359,214,213,-1,359,227,214,-1,225,235,212,-1,234,235,225,-1,355,207,528,-1,355,209,207,-1,207,208,205,-1,208,207,209,-1,205,489,206,-1,205,491,489,-1,203,360,201,-1,360,203,527,-1,404,204,246,-1,204,404,202,-1,526,403,402,-1,526,487,403,-1,398,525,522,-1,525,398,397,-1,524,521,523,-1,524,401,521,-1,37,198,38,-1,198,37,441,-1,192,70,195,-1,192,71,70,-1,450,451,419,-1,450,66,451,-1,191,388,454,-1,191,190,388,-1,326,260,323,-1,326,370,260,-1,164,20,19,-1,20,164,179,-1,23,406,156,-1,23,236,406,-1,169,520,170,-1,169,464,520,-1,175,407,406,-1,407,175,136,-1,172,154,153,-1,172,171,154,-1,20,554,21,-1,177,554,20,-1,161,555,165,-1,555,161,158,-1,166,515,167,-1,166,384,515,-1,421,161,167,-1,161,421,159,-1,154,437,503,-1,154,171,437,-1,156,286,157,-1,156,408,286,-1,512,150,510,-1,512,148,150,-1,145,149,151,-1,145,144,149,-1,510,297,296,-1,510,150,297,-1,149,517,518,-1,149,144,517,-1,499,493,492,-1};
			return value;
		}
		private int[] getrrib3_Geo_6_140_coordIndex_5()
		{
			int[] value = {493,499,498,-1,378,142,379,-1,378,140,142,-1,500,382,128,-1,500,435,382,-1,433,141,140,-1,250,141,433,-1,513,507,514,-1,513,511,507,-1,430,514,516,-1,430,427,514,-1,426,138,513,-1,426,139,138,-1,511,296,507,-1,510,296,511,-1,133,508,295,-1,133,135,508,-1,131,252,129,-1,252,131,291,-1,431,130,379,-1,130,431,132,-1,142,505,506,-1,142,143,505,-1,492,504,499,-1,492,495,504,-1,499,501,497,-1,501,499,504,-1,500,127,498,-1,500,128,127,-1,124,125,122,-1,125,124,126,-1,496,465,423,-1,496,147,465,-1,468,494,467,-1,494,468,146,-1,492,496,495,-1,492,494,496,-1,493,120,467,-1,493,121,120,-1,119,16,18,-1,119,116,16,-1,491,490,489,-1,491,361,490,-1,204,222,244,-1,204,201,222,-1,410,104,223,-1,410,392,104,-1,100,81,98,-1,100,82,81,-1,94,451,78,-1,94,97,451,-1,41,269,268,-1,40,269,41,-1,345,474,92,-1,345,473,474,-1,488,403,478,-1,349,403,488,-1,477,551,363,-1,477,267,551,-1,267,477,443,-1,95,486,344,-1,95,449,486,-1,484,84,86,-1,485,84,484,-1,445,80,82,-1,445,79,80,-1,484,79,416,-1,484,77,79,-1,327,279,457,-1,327,280,279,-1,60,65,59,-1,60,62,65,-1,99,54,56,-1,481,54,99,-1,481,49,54,-1,43,49,481,-1,480,364,340,-1,480,458,364,-1,552,44,46,-1,552,549,44,-1,479,47,45,-1,479,53,47,-1,48,443,442,-1,267,443,48,-1,478,487,476,-1,487,478,403,-1,475,363,473,-1,477,363,475,-1,33,474,362,-1,33,35,474,-1,337,34,472,-1,34,337,36,-1,76,195,70,-1,195,76,453,-1,21,555,158,-1,21,554,555,-1,168,471,470,-1,168,160,471,-1,15,120,18,-1,466,120,15,-1,283,10,7,-1,283,374,10,-1,8,13,9,-1,8,123,13,-1,316,552,322,-1,552,316,373,-1,2,83,67,-1,2,1,83,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib3_Coord_7_140_point_1()
		{
			double[] value = {-1.1164,50.739,-2.51775,-1.11058,50.75646,-2.45022,-1.08354,50.70474,-2.48099,-2.37798,50.45731,-2.45669,-3.0012,50.06442,-2.26179,-2.97865,50.04182,-2.25335,-2.41229,50.48997,-2.48387,-4.41416,48.56184,-1.41828,-4.46593,48.31572,-.83859,-4.54922,48.27316,-.86134,-4.35343,48.59683,-1.36451,-4.07244,47.87168,.13897,-4.44014,48.00701,-.29236,-4.37943,48.04661,-.30819,-4.11,47.81541,.16067,-3.70162,48.13331,.40408,-3.9368,48.14059,.15587,-3.91815,48.16634,.17325,-3.74037,48.09383,.38866,-1.91202,47.70853,1.83284,-1.89766,47.78487,1.82559,-2.01795,47.77731,1.77809,-2.13857,47.24365,2.02969,-2.09721,47.15183,2.13041,-2.08145,47.11742,2.12161,-1.10138,50.73638,-2.57159,-1.10274,50.73768,-2.55819,-1.06096,50.66441,-2.50737,-1.21682,50.80732,-2.67221,-1.1477,50.78949,-2.63692,-1.21113,50.79763,-2.68783,-1.15604,50.79437,-2.62348,-1.24215,50.80133,-2.69285,-1.19755,50.80668,-2.25179,-1.3808,50.76532,-2.32396,-1.18596,50.72312,-2.27636,-1.36864,50.7004,-2.36019,-.84973,50.82243,-2.07076,-.74784,50.81845,-2.02377,-.84046,50.82276,-2.08236,-1.21543,50.86142,-2.26864,-1.14034,50.85091,-2.22231,-1.21307,50.86773,-2.28433,-1.13249,50.85078,-2.23325,-1.97142,50.71221,-2.50069,-1.67623,50.77125,-2.43478,-1.9462,50.72566,-2.53724,-1.66121,50.78892,-2.46031,-1.05343,50.84344,-2.17655,-1.05441,50.84273,-2.18599,-1.39372,50.85583,-2.35291,-1.38226,50.84661,-2.3704,-1.52172,50.82379,-2.42617,-1.53537,50.82307,-2.40102,-1.02927,50.82107,-2.20891,-.91624,50.81123,-2.16692,-1.01373,50.81139,-2.2272,-1.26689,50.84206,-2.58154,-1.39671,50.78156,-2.62853,-1.27754,50.84983,-2.57593,-1.40005,50.7894,-2.61744,-1.37429,50.84241,-2.55692,-1.38599,50.81337,-2.59009,-1.43064,50.81395,-2.5765,-1.31199,50.86403,-2.53404,-1.31731,50.84902,-2.56724,-1.00874,50.64399,-2.44999,-1.02793,50.69687,-2.42091,-1.24885,50.81515,-2.59004,-1.34487,50.77956,-2.64092,-1.18929,50.68948,-2.74736,-1.13725,50.6848,-2.72082,-1.16991,50.66552,-2.723,-1.18267,50.66048,-2.71584,-1.23333,50.66815,-2.69889,-1.2584,50.68579,-2.72307,-1.20945,50.69,-2.74525,-.89891,50.68489,-2.29116,-.94425,50.68082,-2.34246,-.89758,50.71811,-2.27588,-.95315,50.70145,-2.33682,-1.0593,50.77958,-2.3749,-.98094,50.76427,-2.32274,-1.05045,50.75747,-2.38988,-.74424,50.6396,-2.15771,-.85049,50.61166,-2.21039,-.83444,50.64323,-2.21612,-.75482,50.60538,-2.15709,-.8659,50.61769,-2.17876,-.76446,50.61748,-2.1291,-1.17186,50.63147,-2.30687,-1.08466,50.54565,-2.37511,-1.11431,50.64491,-2.27393,-1.13478,50.53255,-2.43566,-.96972,50.63347,-2.34886,-1.0026,50.58829,-2.35593,-1.04676,50.53106,-2.43976,-1.02481,50.57501,-2.44915,-1.0896,50.81173,-2.31431,-1.10387,50.82058,-2.28147};
			return value;
		}
		private double[] getrrib3_Coord_7_140_point_2()
		{
			double[] value = {-1.00005,50.79861,-2.25202,-.58242,50.7852,-1.85524,-.55911,50.7824,-1.86365,-.59258,50.80721,-1.88996,-.50516,50.6061,-2.03511,-.50678,50.58574,-2.02101,-.51665,50.57752,-2.0303,-.51665,50.61373,-2.04557,-.51647,50.53525,-1.98354,-.50263,50.5434,-1.97686,-.51398,50.53004,-1.92137,-.53157,50.52923,-1.92814,-.52833,50.51894,-1.88038,-.53795,50.53459,-1.84166,-.54737,50.52605,-1.88739,-.55191,50.54263,-1.85916,-3.95458,48.08261,.13089,-4.24755,48.2367,-.29541,-4.23968,48.267,-.26948,-3.76844,48.02124,.36536,-3.33173,48.01555,.7846,-3.36397,47.94319,.79512,-4.05433,47.92112,.12918,-4.32596,48.0947,-.31743,-4.01143,47.96818,.12271,-3.85859,47.83578,.40049,-3.8285,47.89267,.38527,-3.43099,47.80609,.82852,-3.44901,47.74034,.84015,-4.15418,47.82361,.18796,-3.9242,47.7347,.43772,-4.13306,47.88901,.20835,-3.92382,47.81592,.45458,-3.75378,48.14851,.46389,-3.9988,48.20146,.23116,-3.82482,48.09154,.49345,-2.10806,47.39499,2.06381,-2.08949,47.48758,2.03469,-2.44993,47.6133,1.7549,-2.45699,47.51539,1.77517,-3.20999,47.48673,1.11942,-2.88154,47.3826,1.42029,-3.23197,47.54459,1.12549,-2.89105,47.43445,1.42336,-2.65529,48.04153,1.23528,-2.22212,47.96945,1.5482,-2.66384,47.98656,1.24753,-2.23242,47.88451,1.55094,-2.30665,47.94498,1.59422,-2.65505,48.05333,1.25458,-2.74172,48.02364,1.29885,-2.21755,47.98298,1.57018,-1.94831,47.38825,1.94869,-1.97258,47.32889,1.99175,-1.96363,47.31488,1.98085,-1.95737,47.40155,1.95548,-2.10023,47.15041,2.13713,-2.08415,47.10925,2.12812,-2.04275,47.7737,1.84343,-2.01276,47.65987,1.94933,-2.12027,47.69646,1.84943,-1.96513,47.74909,1.89969,-1.92614,47.62797,1.84915,-1.90935,47.6304,1.83526,-1.89575,47.70728,1.82514,-1.91911,47.83471,1.85339,-1.91376,47.84491,1.86041,-1.96936,47.75998,1.91358,-2.07929,47.67352,1.79395,-2.05134,47.09105,2.09063,-2.04895,47.07168,2.0942,-2.00209,47.17636,2.03811,-2.01226,47.18244,2.04914,-2.06991,47.38607,2.06409,-2.05658,47.48426,2.02724,-2.07392,47.38508,2.0752,-2.05889,47.48499,2.03851,-1.89322,47.8308,1.83621,-1.8876,47.84688,1.83061,-1.88656,47.78363,1.81957,-1.45662,50.59119,-2.69389,-1.3354,50.65886,-2.70097,-1.31408,50.64404,-2.66547,-1.48608,50.56095,-2.66081,-1.84757,50.46965,-2.70906,-1.97601,50.44996,-2.7424,-1.93529,50.45638,-2.79674,-1.81975,50.49752,-2.76306,-1.43882,50.63281,-2.71078,-1.44645,50.68619,-2.68961,-1.40045,50.70862,-2.67963,-1.36398,50.66786,-2.71451,-1.13348,50.7169,-2.70507,-1.22303,50.7569,-2.73548,-1.14335,50.75607,-2.678,-1.21795,50.71314,-2.7533,-1.09385,50.67286,-2.62001,-1.10722,50.64272,-2.63179,-.75664,50.80358,-2.0182,-.69458,50.7868,-1.97337};
			return value;
		}
		private double[] getrrib3_Coord_7_140_point_3()
		{
			double[] value = {-.67998,50.80595,-1.98629,-.59854,50.71632,-1.87979,-.61456,50.67518,-1.91728,-.59476,50.6611,-1.89185,-.60883,50.72627,-1.90185,-.55729,50.70204,-1.82444,-.53719,50.6392,-1.8219,-.53261,50.6393,-1.82944,-.52745,50.66888,-1.85594,-.51688,50.63779,-1.85728,-.5044,50.63103,-1.89346,-.5189,50.55374,-1.83413,-.50949,50.54637,-1.87828,-.49758,50.61653,-1.93798,-.49471,50.59446,-1.97655,-.49413,50.60613,-1.98409,-.54923,50.75867,-1.86817,-.54695,50.55118,-2.00588,-.52248,50.58124,-2.03506,-.53229,50.54424,-1.99414,-.53163,50.58459,-2.04028,-.59284,50.76026,-1.85322,-.6019,50.77331,-1.87327,-.52365,50.66409,-2.03636,-.50442,50.64434,-1.94026,-.49956,50.55733,-1.9153,-.49441,50.56403,-1.96507,-.49539,50.57447,-1.95346,-.50117,50.54966,-1.91335,-.66699,50.6069,-2.06947,-.67436,50.61672,-2.05355,-.62417,50.58551,-2.03815,-.65576,50.59511,-2.09108,-.6132,50.58164,-2.05247,-.49807,50.58465,-1.9057,-.50395,50.57838,-1.88291,-2.08513,47.24532,2.10882,-.54487,50.78137,-1.91459,-.57443,50.81274,-1.93015,-.6329,50.81296,-1.93677,-.61072,50.82091,-1.96492,-.66054,50.828,-2.00805,-.82046,50.81351,-2.11081,-.73482,50.81657,-2.04934,-.60868,50.78154,-1.8836,-.64804,50.78836,-1.93021,-.65261,50.73448,-1.93994,-.59408,50.61167,-2.06338,-.56943,50.64719,-2.07708,-2.41035,47.22017,1.77862,-2.8692,47.37394,1.41397,-2.4296,47.23058,1.80126,-4.47661,48.01166,-.26314,-4.67802,48.23206,-.86804,-4.64435,48.23459,-.87648,-3.78739,49.22991,-2.25286,-2.96126,49.87407,-2.70301,-3.76721,49.22948,-2.2505,-2.94678,49.86648,-2.69003,-2.31956,50.30345,-2.817,-1.93782,50.48497,-2.81066,-2.30826,50.28369,-2.79407,-1.19163,50.59309,-2.59891,-1.2735,50.59304,-2.49496,-1.40673,50.5821,-2.54527,-1.37309,50.59636,-2.59399,-1.49301,50.71912,-2.68105,-1.05467,50.83655,-2.16945,-1.13159,50.84197,-2.21251,-1.20314,50.84597,-2.2528,-1.38244,50.81233,-2.31581,-4.28341,48.75677,-1.22735,-4.31828,48.76446,-1.22432,-4.40127,48.48067,-.66548,-4.37237,48.47745,-.68468,-1.22446,50.82842,-2.4907,-1.24836,50.86114,-2.50977,-1.2066,50.80223,-2.54978,-1.49679,50.84053,-2.46553,-1.471,50.85745,-2.50966,-1.59993,50.79964,-2.53245,-.51186,50.67616,-1.93297,-2.32389,50.30201,-2.74137,-3.71535,49.27584,-2.1622,-2.93525,49.90953,-2.5719,-1.18455,50.79914,-2.58903,-2.13678,47.12548,2.09456,-2.12446,47.08845,2.07976,-2.43849,47.27179,1.80359,-4.47424,48.52716,-1.47263,-4.66486,48.29946,-.80092,-4.45728,48.0714,-.22806,-4.47389,48.67596,-1.33204,-4.50332,48.60033,-1.3889,-4.60788,48.36406,-.74343,-3.37196,48.08998,.81816,-3.14248,48.04169,1.05496,-3.10925,48.0642,1.04922,-4.21541,48.3258,-.20839,-4.29705,48.31002,-.14948};
			return value;
		}
		private double[] getrrib3_Coord_7_140_point_4()
		{
			double[] value = {-3.89434,48.22647,.22462,-4.20657,48.31588,-.23128,-4.37721,48.4334,-.74506,-3.66311,48.17289,.41945,-3.88348,48.2146,.20558,-3.68431,49.43261,-1.88461,-4.41081,48.73965,-1.24882,-3.73456,49.4155,-1.93156,-3.6471,49.42377,-1.88654,-3.62103,49.3913,-1.94876,-2.94221,49.9916,-2.30834,-3.02265,49.94574,-2.5912,-3.8349,49.32071,-2.0958,-3.82532,49.3581,-2.03149,-3.00673,50.0692,-2.3297,-3.03508,50.00707,-2.46964,-2.40457,50.45291,-2.61885,-2.33911,50.39513,-2.7408,-2.92341,49.90819,-2.49138,-2.31959,50.2843,-2.66657,-2.36445,50.33729,-2.48458,-2.36789,50.41545,-2.47656,-2.05557,50.65018,-2.65199,-1.98958,50.55593,-2.77034,-2.08561,50.48701,-2.52125,-2.09385,50.56558,-2.49595,-1.85368,50.60681,-2.74494,-1.57157,50.79272,-2.5693,-1.54692,50.73563,-2.65575,-1.91394,50.70042,-2.63861,-1.53908,50.50462,-2.59644,-1.87713,50.4439,-2.64222,-1.60971,50.59094,-2.48636,-1.63166,50.62631,-2.46148,-1.97059,50.53549,-2.51195,-1.47744,50.61612,-2.43847,-1.34695,50.63255,-2.39227,-1.50533,50.66777,-2.40451,-1.17961,50.83227,-2.37531,-1.13427,50.8017,-2.42556,-1.28294,50.84106,-2.44568,-1.09832,50.53904,-2.52471,-1.0634,50.57543,-2.54136,-1.3858,50.8446,-2.33124,-1.0484,50.57447,-2.31735,-1.06215,50.66441,-2.24646,-.92249,50.64783,-2.2806,-.77153,50.63555,-2.10414,-.68433,50.62967,-2.03166,-.77472,50.66176,-2.08199,-.68419,50.65031,-2.0191,-.64,50.8055,-2.0466,-.71514,50.81249,-2.08797,-.64006,50.62681,-2.10373,-.63538,50.66445,-2.11943,-.507,50.60778,-1.8587,-.50521,50.59291,-1.87078,-.51612,50.69479,-1.92009,-.52509,50.71107,-1.90188,-.49647,50.59618,-1.92851,-.58673,50.70233,-1.858,-.5888,50.69987,-1.83286,-1.12881,50.82273,-2.21183,-1.06099,50.82753,-2.17772,-1.36549,50.85251,-2.40059,-1.20572,50.85091,-2.30545,-1.19698,50.84111,-2.33373,-1.14295,50.60612,-2.62816,-1.41732,50.85379,-2.53478,-1.34514,50.87399,-2.49962,-1.81126,50.53239,-2.78578,-1.63428,50.78275,-2.48886,-2.00343,50.41063,-2.66283,-2.40977,50.47783,-2.52883,-3.63538,49.30988,-2.07509,-4.26526,48.71986,-1.24625,-4.51203,48.45282,-.67949,-4.40218,48.20269,-.17705,-3.44479,47.56241,.89803,-3.48048,47.6253,.89309,-4.12305,47.94391,.22542,-3.86058,47.7819,.39757,-3.45702,47.65627,.86276,-1.91271,47.87617,1.79781,-1.94327,47.86551,1.84298,-2.11,47.23192,1.99804,-1.91074,47.86226,1.78239,-1.28849,50.79148,-2.66367,-1.31266,50.75231,-2.70541,-3.43244,47.55641,.89448,-3.89572,47.72615,.41248,-.56198,50.5578,-2.01856,-.49078,50.60066,-2.00563,-.49281,50.58665,-1.98964,-.51969,50.57923,-1.81979,-.55091,50.5733,-1.82333,-.64906,50.63661,-1.9871,-.64602,50.61282,-2.00097,-.60625,50.60144,-1.95714,-.61739,50.62267,-1.92959};
			return value;
		}
		private double[] getrrib3_Coord_7_140_point_5()
		{
			double[] value = {-.54171,50.53994,-1.96584,-.55222,50.55874,-1.91904,-.69234,50.69177,-1.99374,-.7682,50.71796,-2.05705,-.65568,50.67977,-1.9597,-.52497,50.69824,-1.87842,-2.08845,47.24717,2.116,-2.12722,47.26517,2.09491,-2.14406,47.16005,2.10672,-.57485,50.55677,-2.00694,-.50201,50.64615,-1.99378,-.52578,50.75327,-1.95342,-.52474,50.74382,-1.94728,-.51216,50.69156,-1.98219,-.5116,50.57131,-1.8526,-.71786,50.76065,-2.1272,-.80936,50.71228,-2.21438,-.80345,50.7638,-2.18981,-.71831,50.72507,-2.15358,-1.04661,50.60796,-2.53504,-1.09458,50.71104,-2.59779,-2.02241,47.66174,1.97105,-2.16221,47.45334,1.93277,-1.93496,47.71037,1.77385,-1.95142,47.6391,1.79353,-2.90222,47.57226,1.43263,-2.90886,47.62787,1.42531,-3.26763,47.68944,1.13324,-2.45462,47.40742,1.79356,-2.44576,47.31773,1.8003,-3.52164,47.75291,.897,-3.49695,47.68717,.89614,-3.91246,47.87638,.47095,-3.1961,47.4793,1.11526,-2.84025,47.49451,1.38158,-3.20276,47.58925,1.08935,-2.09122,47.07582,2.05267,-2.0477,47.18854,1.98801,-2.3772,47.34464,1.73412,-.56697,50.57619,-1.84007,-.90494,50.80732,-2.186,-.85366,50.81545,-2.06825,-.95182,50.8329,-2.12394,-.95635,50.82542,-2.119,-.80741,50.81141,-2.13672,-.89372,50.76573,-2.25319,-.86842,50.65106,-2.14779,-.96857,50.6627,-2.19206,-.96983,50.67163,-2.18466,-.93971,50.61688,-2.26742,-1.04703,50.63843,-2.52154,-1.00321,50.62421,-2.45015,-1.24244,50.75778,-2.73302,-1.23829,50.70932,-2.75053,-1.27481,50.70391,-2.74168,-1.15314,50.60169,-2.6256,-1.34154,50.88758,-2.4719,-1.4632,50.85735,-2.5176,-1.3404,50.88585,-2.45881,-1.25709,50.86604,-2.51426,-.94749,50.8351,-2.13441,-1.30939,50.88242,-2.47948,-1.66922,50.68825,-2.41879,-1.97932,50.6141,-2.48624,-2.06461,47.09087,2.10965,-1.92337,47.79059,1.77123,-3.28877,48.07532,.78607,-3.06067,47.97817,.99528,-3.02018,48.04208,.98815,-2.12717,47.43077,1.89649,-2.14166,47.54296,1.83166,-2.17515,47.56719,1.87862,-1.53596,50.731,-2.36905,-1.06367,50.73527,-2.21922,-1.12529,50.73368,-2.24357,-.96411,50.74405,-2.1538,-.85674,50.79388,-2.07786,-.95793,50.81434,-2.12377,-.86357,50.73194,-2.10513,-1.54318,50.80788,-2.38254,-1.30191,50.8779,-2.47222,-1.12122,50.83502,-2.25352,-1.46842,50.78731,-2.6019,-1.23745,50.80872,-2.62759,-.81391,50.68452,-2.22598,-.72466,50.68385,-2.17096,-.96284,50.61875,-2.23195,-.76114,50.772,-2.03265,-.87029,50.66811,-2.13303,-.56373,50.63557,-1.82228,-.57739,50.63875,-1.83429,-.57902,50.69956,-1.82172,-2.69933,47.84502,1.28108,-3.09384,47.90945,1.00435,-2.68257,47.9102,1.26365,-2.25475,47.73271,1.58168,-2.24378,47.80753,1.56362,-2.80059,47.60085,1.34553,-3.15194,47.75488,1.04747,-2.76482,47.67595,1.32594};
			return value;
		}
		private double[] getrrib3_Coord_7_140_point_6()
		{
			double[] value = {-3.17635,47.68479,1.06462,-2.33193,47.4631,1.68325,-2.00371,47.41121,1.88686,-2.01979,47.33613,1.92006,-2.3156,47.53865,1.64884,-2.89949,47.50185,1.42783,-3.25702,47.61285,1.12715,-3.21657,47.95056,1.09266,-3.47101,47.99142,.85925,-2.41775,47.78469,1.68829,-2.79076,47.98108,1.3283,-2.84924,47.89255,1.37375,-2.36312,47.88453,1.63464,-2.90188,47.74568,1.4152,-3.26965,47.8278,1.12699,-1.99475,47.77981,1.90183,-3.53156,47.90286,.88442,-2.99669,48.07706,.9869,-3.00239,48.08839,1.00329,-2.04769,47.66864,1.9684,-2.06638,47.07677,2.11675,-.5587,50.57329,-1.89464,-.59179,50.58025,-1.9814,-.58275,50.58832,-1.92798,-.57322,50.57142,-1.95347,-.63362,50.59748,-2.02227,-.69048,50.74189,-1.97614,-.57806,50.64932,-1.85804,-.51462,50.58986,-1.83378,-.54068,50.76442,-1.91104,-.55907,50.54882,-1.98633,-.59216,50.61351,-1.90239,-.57017,50.59609,-1.85848,-.56971,50.68791,-2.06274,-.62761,50.70741,-2.10244,-.57639,50.74413,-2.04094,-.54747,50.78679,-1.99042,-.53337,50.71698,-2.02324,-.58427,50.79721,-2.00997,-2.10315,50.61123,-2.48879,-1.9919,50.65957,-2.47629,-1.54583,50.77184,-2.36708,-3.26445,48.11822,.80684,-3.67257,48.18375,.43574,-3.26113,48.10765,.79055,-.63219,50.75794,-2.07711,-3.88418,48.00038,.49903,-4.09548,48.07498,.25043,-1.98535,50.43944,-2.72186,-2.10178,50.66688,-2.51908,-1.68026,50.72766,-2.41597,-1.05585,50.83487,-2.17098,-2.08787,50.66832,-2.56464,-4.50162,48.52835,-1.47707,-1.98853,47.83164,1.7965,-1.99524,47.83494,1.81711};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib4_Geo_6_145_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,3,7,-1,7,8,6,-1,9,10,11,-1,9,12,10,-1,13,14,15,-1,16,17,18,-1,19,9,20,-1,19,21,9,-1,22,23,24,-1,24,25,22,-1,26,4,27,-1,28,29,30,-1,28,31,29,-1,32,33,34,-1,32,35,33,-1,36,37,38,-1,36,39,37,-1,40,41,42,-1,41,43,42,-1,44,45,46,-1,44,47,45,-1,48,49,50,-1,51,52,53,-1,52,54,53,-1,55,56,57,-1,56,58,57,-1,59,38,37,-1,59,60,38,-1,61,62,63,-1,62,64,63,-1,65,66,67,-1,67,68,65,-1,69,70,71,-1,71,72,69,-1,73,74,66,-1,74,67,66,-1,75,76,72,-1,76,77,72,-1,78,79,80,-1,81,74,73,-1,81,82,74,-1,83,84,85,-1,85,86,83,-1,87,88,89,-1,88,90,89,-1,91,92,93,-1,92,94,93,-1,95,96,97,-1,95,98,96,-1,99,100,101,-1,102,103,104,-1,104,105,102,-1,106,107,20,-1,108,109,110,-1,111,112,113,-1,111,114,112,-1,115,116,117,-1,115,118,116,-1,119,118,115,-1,120,121,119,-1,122,123,124,-1,125,126,127,-1,125,128,126,-1,129,130,131,-1,130,104,131,-1,130,132,133,-1,134,132,129,-1,135,11,136,-1,136,137,135,-1,16,18,107,-1,103,138,126,-1,103,102,138,-1,139,128,122,-1,139,140,128,-1,141,132,142,-1,143,144,145,-1,145,146,143,-1,147,148,149,-1,147,150,148,-1,151,152,153,-1,153,154,151,-1,155,156,157,-1,156,158,157,-1,159,160,151,-1,151,154,159,-1,161,162,163,-1,163,164,161,-1,84,79,165,-1,81,79,82,-1,166,23,167,-1,166,24,23,-1,60,168,169,-1,168,170,169,-1,171,172,173,-1,172,174,173,-1,175,176,177,-1,175,40,176,-1,178,179,180,-1,178,181,179,-1,182,30,183,-1,183,184,182,-1,185,43,41,-1,185,186,43,-1,187,188,189,-1,190,191,192,-1,191,193,192,-1,194,195,196,-1,194,184,195,-1,189,188,197,-1,197,198,189,-1,46,27,44,-1,46,26,27,-1,6,8,199,-1,8,196,199,-1,200,201,10,-1,198,197,202,-1,202,203,198,-1,114,204,205,-1,204,206,205,-1,113,87,95,-1,113,112,87,-1,116,45,47,-1,47,117,116,-1,207,108,208,-1,207,109,108,-1,123,209,124,-1,209,210,124,-1,136,11,211,-1,138,212,213,-1,133,132,214,-1,93,124,90,-1,93,122,124,-1,215,216,217,-1,217,146,215,-1,143,217,100,-1,143,146,217,-1,157,143,100,-1,100,99,157,-1,148,218,219,-1,148,220,218,-1,19,221,222,-1,19,18,221,-1,154,150,147,-1,147,159,154,-1,223,139,94,-1,223,224,139,-1,225,132,141,-1,213,126,138,-1,213,127,126,-1,136,211,212,-1,212,138,136,-1,108,226,208,-1,97,113,95,-1,97,227,113,-1,98,89,208,-1,89,207,208,-1,111,204,114,-1,111,203,204,-1,205,228,229,-1,205,206,228,-1,203,200,204,-1,203,202,200,-1,6,44,27,-1,230,4,26,-1,108,110,231,-1,192,193,189,-1,193,187,189,-1,194,232,182,-1,182,184,194,-1,30,29,233,-1,233,183,30,-1,28,162,234,-1,28,163,162,-1,39,235,37,-1,39,236,235,-1,33,169,34,-1,169,237,34,-1,38,60,33,-1,60,169,33,-1,238,239,240,-1,238,170,239,-1,167,62,241,-1,167,23,62,-1,242,51,243,-1,51,53,243,-1,25,244,245,-1,245,22,25,-1,83,82,79,-1,80,79,81,-1,165,79,78,-1,83,79,84,-1,23,22,64,-1,64,62,23,-1,246,13,247,-1,13,15,247,-1,248,249,250,-1,248,251,249,-1,252,253,254,-1,252,255,253,-1,156,256,158,-1,256,257,158,-1,155,157,99,-1,99,249,155,-1,250,258,259,-1,259,260,250,-1,261,262,263,-1,261,264,262,-1,264,222,221,-1,264,261,222,-1,228,265,266,-1,228,12,265,-1,267,128,140,-1,267,268,128,-1,142,132,134,-1,214,132,225,-1,135,20,9,-1,9,11,135,-1,102,136,138,-1,102,137,136,-1,129,132,130,-1,141,142,106,-1,142,269,106,-1,213,46,270,-1,270,127,213,-1,125,127,270,-1,271,119,272,-1,272,119,115,-1,230,212,211,-1,230,26,212,-1,273,110,210,-1,110,109,210,-1,269,274,267,-1,267,16,269,-1,275,20,135,-1,275,106,20,-1,276,277,223,-1,277,278,223,-1,223,94,276,-1,94,92,276,-1,89,98,87,-1,98,95,87,-1,48,73,49,-1,73,66,49,-1,279,72,77,-1,279,69,72,-1,54,49,66,-1,66,65,54,-1,111,113,227,-1};
			return value;
		}
		private int[] getrrib4_Geo_6_145_coordIndex_2()
		{
			int[] value = {280,61,281,-1,61,63,281,-1,282,242,243,-1,282,283,242,-1,39,161,177,-1,39,36,161,-1,194,284,285,-1,285,232,194,-1,286,3,5,-1,286,7,3,-1,287,288,180,-1,287,289,288,-1,6,4,3,-1,6,27,4,-1,290,273,291,-1,119,271,120,-1,292,267,140,-1,10,201,11,-1,118,119,121,-1,45,116,293,-1,288,40,42,-1,288,176,40,-1,294,236,289,-1,294,235,236,-1,295,85,71,-1,294,296,235,-1,297,296,294,-1,176,289,236,-1,289,176,288,-1,185,285,284,-1,185,41,285,-1,116,121,293,-1,116,118,121,-1,200,206,204,-1,200,10,206,-1,14,298,299,-1,14,13,298,-1,299,300,301,-1,299,298,300,-1,107,19,20,-1,18,19,107,-1,120,290,291,-1,120,271,290,-1,197,186,286,-1,186,197,188,-1,200,5,4,-1,5,200,202,-1,302,303,304,-1,305,303,302,-1,232,163,182,-1,164,163,232,-1,181,187,193,-1,181,178,187,-1,180,306,287,-1,306,180,179,-1,236,177,176,-1,236,39,177,-1,8,194,196,-1,194,8,284,-1,164,177,161,-1,164,175,177,-1,59,168,60,-1,168,59,307,-1,280,308,309,-1,280,281,308,-1,295,70,310,-1,295,71,70,-1,244,311,312,-1,25,311,244,-1,313,305,314,-1,303,305,313,-1,29,190,233,-1,29,191,190,-1,310,315,295,-1,310,316,315,-1,77,52,279,-1,52,77,50,-1,315,85,295,-1,315,86,85,-1,75,78,76,-1,165,78,75,-1,19,317,21,-1,19,222,317,-1,217,261,263,-1,261,217,216,-1,318,135,137,-1,318,275,135,-1,267,131,268,-1,267,274,131,-1,291,210,209,-1,291,273,210,-1,46,293,270,-1,293,46,45,-1,205,319,320,-1,205,229,319,-1,321,322,323,-1,322,321,324,-1,325,326,327,-1,325,328,326,-1,329,330,215,-1,330,329,331,-1,278,332,149,-1,277,332,278,-1,290,272,231,-1,271,272,290,-1,105,214,318,-1,133,214,105,-1,225,106,275,-1,225,141,106,-1,269,134,274,-1,142,134,269,-1,128,103,126,-1,268,103,128,-1,91,324,92,-1,324,91,319,-1,333,259,334,-1,333,335,259,-1,336,337,338,-1,336,339,337,-1,292,340,17,-1,340,292,341,-1,215,317,216,-1,215,330,317,-1,327,276,321,-1,277,276,327,-1,342,219,218,-1,219,342,224,-1,221,338,264,-1,221,340,338,-1,253,147,343,-1,253,159,147,-1,262,101,263,-1,262,344,101,-1,257,144,158,-1,257,345,144,-1,339,346,333,-1,346,339,220,-1,335,260,259,-1,347,260,335,-1,258,249,99,-1,250,249,258,-1,257,252,254,-1,256,252,257,-1,251,155,249,-1,251,348,155,-1,349,256,156,-1,349,350,256,-1,252,351,255,-1,352,351,252,-1,353,151,160,-1,353,246,151,-1,247,347,152,-1,247,354,347,-1,260,248,250,-1,260,355,248,-1,352,300,351,-1,300,352,356,-1,357,248,301,-1,357,251,248,-1,15,354,247,-1,14,354,15,-1,76,80,48,-1,80,76,78,-1,358,70,69,-1,70,358,309,-1,359,316,360,-1,68,316,359,-1,65,53,54,-1,65,361,53,-1,69,362,358,-1,69,279,362,-1,363,309,358,-1,280,309,363,-1,360,364,359,-1,364,360,365,-1,361,243,53,-1,243,361,366,-1,358,367,363,-1,358,362,367,-1,63,365,281,-1,368,365,63,-1,369,364,370,-1,369,366,364,-1,242,371,367,-1,371,242,283,-1,241,61,372,-1,61,241,62,-1,373,368,374,-1,373,370,368,-1,369,55,282,-1,55,369,375,-1,376,372,371,-1,241,372,376,-1,56,375,239,-1,56,55,375,-1,0,241,376,-1,167,241,0,-1,374,240,373,-1,240,374,245,-1,58,1,0,-1,1,58,307,-1,240,244,238,-1,240,245,244,-1,2,174,166,-1,174,2,297,-1,25,172,311,-1,25,24,172,-1,238,169,170,-1,169,238,237,-1,37,296,59,-1,37,235,296,-1,237,314,34,-1,237,312,314,-1,35,161,36,-1,35,162,161,-1,289,173,294,-1,287,173,289,-1,313,306,303,-1,306,313,171,-1,32,162,35,-1,162,32,234,-1,302,28,234,-1,302,31,28,-1,183,96,226,-1,183,233,96,-1,117,199,377,-1,117,47,199,-1,108,195,226,-1,195,108,377,-1,201,211,11,-1,230,211,201,-1,203,227,198,-1,227,203,111,-1,207,90,124,-1,207,89,90,-1,98,226,96,-1,208,226,98,-1,122,125,123,-1,122,128,125,-1,219,149,148,-1,149,219,278,-1,140,224,342,-1,140,139,224,-1,18,340,221,-1,18,17,340,-1,330,21,317,-1,330,265,21,-1,321,92,324,-1,276,92,321,-1,332,327,326,-1};
			return value;
		}
		private int[] getrrib4_Geo_6_145_coordIndex_3()
		{
			int[] value = {332,277,327,-1,254,345,257,-1,254,378,345,-1,379,350,349,-1,379,380,350,-1,13,353,298,-1,353,13,246,-1,14,355,354,-1,14,299,355,-1,333,153,335,-1,153,333,346,-1,264,337,262,-1,264,338,337,-1,344,259,258,-1,344,334,259,-1,336,220,339,-1,336,218,220,-1,355,301,248,-1,355,299,301,-1,154,346,150,-1,153,346,154,-1,351,298,353,-1,351,300,298,-1,381,349,348,-1,381,379,349,-1,378,328,345,-1,328,378,326,-1,253,378,254,-1,253,343,378,-1,343,326,378,-1,326,343,332,-1,328,329,145,-1,328,325,329,-1,262,334,344,-1,262,337,334,-1,323,266,331,-1,323,322,266,-1,292,342,341,-1,292,140,342,-1,320,91,88,-1,91,320,319,-1,123,270,209,-1,125,270,123,-1,210,207,124,-1,210,109,207,-1,290,110,273,-1,110,290,231,-1,87,320,88,-1,87,112,320,-1,10,228,206,-1,10,12,228,-1,195,199,196,-1,377,199,195,-1,192,198,227,-1,192,189,198,-1,286,185,7,-1,286,186,185,-1,184,226,195,-1,184,183,226,-1,190,227,97,-1,190,192,227,-1,186,187,43,-1,187,186,188,-1,42,180,288,-1,178,180,42,-1,179,382,304,-1,181,382,179,-1,305,234,32,-1,305,302,234,-1,171,287,306,-1,171,173,287,-1,311,171,313,-1,311,172,171,-1,294,174,297,-1,173,174,294,-1,238,312,237,-1,238,244,312,-1,24,174,172,-1,24,166,174,-1,296,307,59,-1,296,1,307,-1,2,167,0,-1,166,167,2,-1,239,168,56,-1,168,239,170,-1,373,239,375,-1,239,373,240,-1,374,22,245,-1,22,374,64,-1,58,376,57,-1,0,376,58,-1,371,57,376,-1,371,283,57,-1,370,375,369,-1,375,370,373,-1,368,64,374,-1,368,63,64,-1,363,371,372,-1,363,367,371,-1,282,366,369,-1,282,243,366,-1,365,370,364,-1,370,365,368,-1,372,280,363,-1,61,280,372,-1,359,366,361,-1,366,359,364,-1,281,360,308,-1,365,360,281,-1,279,51,362,-1,279,52,51,-1,361,68,359,-1,65,68,361,-1,308,316,310,-1,316,308,360,-1,350,356,352,-1,350,380,356,-1,381,251,357,-1,381,348,251,-1,347,355,260,-1,354,355,347,-1,246,152,151,-1,246,247,152,-1,353,255,351,-1,353,160,255,-1,256,352,252,-1,350,352,256,-1,348,156,155,-1,348,349,156,-1,152,335,153,-1,152,347,335,-1,253,160,159,-1,255,160,253,-1,150,220,148,-1,150,346,220,-1,143,158,144,-1,143,157,158,-1,145,345,328,-1,345,145,144,-1,101,258,99,-1,101,344,258,-1,343,149,332,-1,343,147,149,-1,341,218,336,-1,218,341,342,-1,278,224,223,-1,278,219,224,-1,325,331,329,-1,325,323,331,-1,339,334,337,-1,339,333,334,-1,341,338,340,-1,341,336,338,-1,94,122,93,-1,94,139,122,-1,322,228,266,-1,322,229,228,-1,134,131,274,-1,134,129,131,-1,318,225,275,-1,214,225,318,-1,104,133,105,-1,130,133,104,-1,293,120,291,-1,121,120,293,-1,231,115,117,-1,272,115,231,-1,231,377,108,-1,231,117,377,-1,145,215,146,-1,215,145,329,-1,331,265,330,-1,265,331,266,-1,327,323,325,-1,323,327,321,-1,324,229,322,-1,229,324,319,-1,205,112,114,-1,205,320,112,-1,209,293,291,-1,209,270,293,-1,46,212,26,-1,46,213,212,-1,102,318,137,-1,105,318,102,-1,131,103,268,-1,103,131,104,-1,100,263,101,-1,263,100,217,-1,222,216,317,-1,222,261,216,-1,90,91,93,-1,88,91,90,-1,84,75,85,-1,84,165,75,-1,74,83,86,-1,82,83,74,-1,80,73,48,-1,80,81,73,-1,48,77,76,-1,48,50,77,-1,85,72,71,-1,85,75,72,-1,67,86,315,-1,74,86,67,-1,315,68,67,-1,316,68,315,-1,233,97,96,-1,190,97,233,-1,304,31,302,-1,31,304,382,-1,312,313,314,-1,311,313,312,-1,310,309,308,-1,70,309,310,-1,57,282,55,-1,282,57,283,-1,307,56,168,-1,56,307,58,-1,52,49,54,-1,49,52,50,-1,367,51,242,-1,51,367,362,-1,199,44,6,-1,199,47,44,-1,304,306,179,-1,303,306,304,-1,43,178,42,-1,178,43,187,-1,181,191,382,-1,181,193,191,-1,33,36,38,-1,35,36,33,-1,314,32,34,-1,305,32,314,-1,28,182,163,-1,28,30,182,-1,232,175,164,-1,175,232,285,-1,382,29,31,-1,382,191,29,-1,202,286,5,-1,286,202,197,-1,4,201,200,-1,230,201,4,-1,269,107,106,-1,16,107,269,-1,17,267,292,-1,17,16,267,-1,380,357,356,-1};
			return value;
		}
		private int[] getrrib4_Geo_6_145_coordIndex_4()
		{
			int[] value = {379,357,380,-1,379,381,357,-1,301,356,357,-1,301,300,356,-1,265,9,21,-1,265,12,9,-1,7,284,8,-1,7,185,284,-1,285,40,175,-1,285,41,40,-1,297,1,296,-1,2,1,297,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib4_Coord_7_145_point_1()
		{
			double[] value = {-3.91379,46.80276,.93431,-4.43412,47.10709,.30314,-4.36592,47.14326,.29118,-1.75219,49.86039,-3.07154,-1.42558,49.88248,-3.01305,-1.77255,49.84597,-3.03418,-1.72817,49.86066,-3.11145,-2.10278,49.76862,-3.10867,-2.06464,49.73896,-3.19122,-1.02489,49.89536,-2.73776,-1.21507,49.89045,-2.85137,-1.19472,49.83727,-2.8917,-1.03297,49.92602,-2.70263,-.51572,49.98193,-2.24183,-.50694,49.9508,-2.25999,-.51542,49.98157,-2.25316,-.95089,49.93972,-2.72551,-.91103,49.92884,-2.66945,-.91973,49.88495,-2.68348,-.92576,49.87224,-2.68071,-1.01913,49.89865,-2.75643,-.93169,49.87427,-2.66944,-3.748,47.16896,1.02428,-3.72467,47.14947,1.00983,-4.20805,47.38919,.44258,-4.25465,47.38425,.48693,-1.31895,49.92149,-3.03919,-1.428,49.8963,-3.05461,-4.21859,48.69278,-2.27293,-3.54036,49.24194,-2.61918,-3.57407,49.18811,-2.7343,-4.17041,48.7182,-2.17132,-4.82288,47.98393,-1.25393,-4.93697,47.64842,-.77435,-4.86437,47.73309,-.68668,-4.85954,47.89752,-1.36271,-4.8246,47.82323,-1.41578,-4.86996,47.54891,-.83959,-4.90243,47.56186,-.83855,-4.7915,47.81579,-1.41355,-4.1244,48.53919,-2.36193,-3.50736,48.99809,-2.75688,-4.09736,48.55825,-2.3007,-3.49275,48.99662,-2.69355,-1.41915,49.91575,-3.0922,-1.24083,50.00734,-3.0617,-1.23506,49.98505,-3.05902,-1.42694,49.94287,-3.12001,-2.2161,45.66201,2.46322,-2.22588,45.64647,2.47327,-2.22455,45.65342,2.44748,-2.40508,45.70539,2.36966,-2.32559,45.66936,2.40279,-2.42174,45.68802,2.41031,-2.33799,45.65935,2.46049,-3.58449,46.32493,1.5056,-4.03198,46.66538,1.00903,-3.52726,46.27511,1.5385,-4.01818,46.66256,.98396,-4.7411,47.3123,-.2352,-4.76594,47.32083,-.21244,-2.95791,46.73459,1.74435,-3.2873,46.92707,1.43833,-2.96412,46.74056,1.7715,-3.30187,46.92736,1.47006,-2.35285,45.74806,2.46813,-2.24656,45.73494,2.50872,-2.25032,45.96938,2.48733,-2.34896,46.02398,2.42495,-2.20132,46.11291,2.25691,-2.1296,46.30257,2.26195,-2.05133,46.26965,2.28867,-2.12069,46.07112,2.30689,-2.22386,45.757,2.4941,-2.22818,45.95909,2.48304,-2.11031,46.06223,2.33064,-2.16587,45.83789,2.37466,-2.1722,45.82917,2.35556,-2.24839,45.91981,2.32785,-2.29665,45.98503,2.33597,-2.30583,45.75818,2.40416,-2.30957,45.83389,2.43244,-2.28992,45.99616,2.40459,-2.24554,46.10861,2.36073,-2.16044,46.21094,2.28701,-2.0469,46.23815,2.318,-2.17273,46.13722,2.41297,-1.5153,50.1734,-2.8678,-1.22877,50.1941,-2.71328,-1.50878,50.19169,-2.87971,-1.22481,50.21092,-2.71887,-1.03121,50.14815,-2.61276,-.92622,50.13992,-2.55864,-1.02551,50.16226,-2.61737,-.91775,50.1504,-2.56483,-1.86387,50.11183,-2.9577,-2.19986,50.02032,-3.0453,-2.21012,50.00908,-3.02149,-1.85538,50.12936,-2.97974,-.49502,49.71694,-2.23315};
			return value;
		}
		private double[] getrrib4_Coord_7_145_point_2()
		{
			double[] value = {-.58887,49.75773,-2.31996,-.57913,49.75314,-2.32713,-1.13972,49.92135,-3.01423,-1.04612,50.02533,-2.87324,-1.04455,50.01388,-2.88723,-1.12333,49.91508,-3.00825,-1.01587,49.89857,-2.77039,-.99954,49.90873,-2.75106,-1.7715,50.08067,-3.09002,-1.4702,50.1485,-2.99795,-1.46545,50.14272,-3.00913,-1.86724,49.9906,-2.94002,-1.51747,50.04001,-2.86794,-1.87039,50.04301,-2.93819,-1.51742,49.9656,-2.89848,-1.35882,50.03535,-3.06352,-1.25932,50.0215,-3.05239,-1.43653,49.98827,-3.11881,-1.26854,50.04602,-3.02784,-1.28497,50.07951,-2.98896,-1.21344,50.14039,-2.92227,-1.20083,50.08772,-2.97633,-.97457,50.12706,-2.66714,-1.04797,50.1413,-2.73706,-1.19371,50.15383,-2.78057,-1.02168,50.10239,-2.76465,-1.07687,50.0527,-2.88442,-1.09897,50.07192,-2.92271,-.9703,50.0812,-2.72127,-1.00218,49.98083,-2.83233,-1.03531,49.97062,-2.89002,-.9797,50.02597,-2.78803,-1.02868,49.93147,-2.86059,-1.07573,49.92023,-2.94381,-.97774,49.96883,-2.79734,-1.15344,49.82934,-2.89876,-1.20818,49.85855,-2.97858,-1.162,49.85784,-2.98068,-1.17597,49.94356,-3.01644,-.90295,50.11838,-2.59735,-.88584,50.0504,-2.64071,-1.02522,49.89873,-2.82523,-.98584,49.94031,-2.79705,-.59908,49.78254,-2.29698,-.62275,49.87286,-2.28128,-.68684,49.89537,-2.35295,-.66608,49.82428,-2.38663,-.65243,50.12806,-2.2936,-.68161,50.10972,-2.37914,-.69711,50.12448,-2.35983,-.62828,50.10931,-2.33313,-.55861,50.10508,-2.27656,-.54432,50.06038,-2.31948,-.54941,50.06277,-2.3266,-.56734,50.10876,-2.28175,-.49403,49.7393,-2.16937,-.5052,49.81517,-2.11888,-.49946,49.73145,-2.16754,-.51281,49.8122,-2.12245,-.60312,50.1264,-2.20584,-.59822,50.11805,-2.20784,-4.62052,48.12436,-1.9677,-4.65814,48.18335,-1.88289,-4.21305,48.60336,-2.38188,-4.15613,48.51199,-2.4479,-2.22285,46.0385,2.30798,-4.22907,47.29174,.35249,-3.7736,47.04942,.95469,-4.50744,47.06131,.32744,-4.76531,47.40765,-.11271,-4.45602,47.14652,.44155,-4.67362,47.76311,-.59711,-4.50769,47.56294,-.05708,-4.63664,47.70296,-.67019,-4.50712,47.48603,-.16933,-4.13153,48.50198,-2.43112,-4.55893,48.15036,-1.90223,-4.58947,48.12081,-1.96187,-4.07481,48.61801,-2.18828,-4.49841,48.29518,-1.66748,-4.46701,48.238,-1.71016,-4.08469,48.68166,-2.14016,-3.56011,49.11557,-2.82465,-2.54282,49.77947,-3.12464,-2.50798,49.69076,-3.16011,-2.53673,49.57895,-3.0966,-2.55277,49.57767,-3.02455,-3.47688,49.0593,-2.57611,-2.56437,49.59278,-2.95823,-2.57665,49.63041,-2.93428,-2.59976,49.82723,-2.98416,-3.53038,49.23613,-2.60086,-2.59547,49.73756,-2.94955,-3.4864,49.15793,-2.55167,-2.50765,49.56832,-3.21404,-2.07467,49.87868,-3.18474,-2.05438,49.7675,-3.21032,-2.16493,49.7592,-2.99912,-2.20428,49.80007,-2.98074,-1.71388,49.89482,-3.14424};
			return value;
		}
		private double[] getrrib4_Coord_7_145_point_3()
		{
			double[] value = {-1.48736,49.86891,-2.9532,-1.28912,49.87164,-2.91951,-1.80411,49.83796,-2.98152,-1.85056,49.88517,-2.94926,-1.51485,49.88045,-2.93291,-1.23539,49.99955,-2.75695,-1.23558,49.94564,-2.80193,-1.48265,50.13996,-2.93446,-1.80163,50.08872,-3.04815,-1.14374,50.18548,-2.85746,-1.2645,50.18229,-2.89167,-1.23876,49.86711,-2.97998,-1.23488,49.9289,-3.04015,-1.21542,49.95357,-3.04245,-1.08918,49.88354,-2.94258,-.75125,49.85167,-2.46683,-.73234,49.8037,-2.49658,-.65553,49.78239,-2.40576,-.72955,50.04623,-2.48712,-.75713,50.11547,-2.4565,-.63765,50.04949,-2.40854,-.82278,49.84391,-2.60531,-.8258,49.82918,-2.60803,-.82829,50.13229,-2.49739,-.81785,50.1139,-2.52406,-1.07518,49.872,-2.89056,-2.12122,49.97166,-3.13765,-2.21671,49.92282,-2.98203,-1.04103,49.95521,-2.67128,-1.04912,50.00614,-2.6465,-1.30426,49.88591,-2.99128,-1.45734,50.11768,-3.03946,-3.503,48.98235,-2.87253,-2.59631,49.83846,-3.00677,-4.64345,48.27346,-1.76026,-4.81768,47.57434,-.79889,-4.75389,47.85088,-1.3522,-4.68014,47.49751,-.06073,-4.38036,47.26781,.48531,-3.99197,46.80961,1.0849,-3.90704,46.95513,1.08621,-3.33086,46.78954,1.42551,-2.76088,45.85988,2.16395,-2.76046,45.85341,2.20759,-4.27515,47.37577,.4962,-3.8121,47.10809,1.06064,-.5466,50.0653,-2.26506,-.53894,50.03284,-2.28482,-.50612,49.85709,-2.28207,-.49246,49.72389,-2.22997,-.50005,49.78292,-2.33219,-.49592,49.83417,-2.23108,-.57286,49.98522,-2.10675,-.60953,50.09739,-2.15955,-.57762,49.98379,-2.10762,-.6042,50.09287,-2.16523,-.54364,49.90523,-2.10577,-.54751,49.90392,-2.10641,-.50454,49.77447,-2.33843,-.51537,49.90642,-2.36812,-.51192,49.9098,-2.35892,-.72444,49.79821,-2.50725,-.62511,49.79758,-2.43763,-.64643,49.77808,-2.41484,-.71296,49.81355,-2.51954,-.94209,49.90652,-2.63332,-.94707,49.9442,-2.60357,-.93278,50.00076,-2.722,-.98057,50.0359,-2.7778,-.95989,49.93829,-2.74268,-1.11987,50.09035,-2.9555,-1.28712,50.12775,-2.96079,-1.37169,50.09948,-3.01848,-1.26216,50.17861,-2.90502,-.93541,49.99697,-2.73377,-1.13606,49.8328,-2.90139,-.83583,50.1226,-2.48195,-.77439,50.11271,-2.41635,-.76057,50.12743,-2.42651,-2.27516,45.86815,2.31925,-2.47485,46.46965,2.07275,-2.47186,46.47601,2.10117,-3.21735,46.09267,1.85464,-3.21369,46.07634,1.82858,-2.50636,49.54627,-3.19943,-3.49024,48.96155,-2.84386,-2.12856,49.76209,-3.05835,-4.6112,47.94017,-1.17497,-4.50568,48.17192,-1.84531,-4.69591,47.87536,-1.30395,-1.2769,50.15495,-2.94073,-1.16286,50.18239,-2.87337,-.88503,49.98707,-2.65748,-1.1374,50.08685,-2.9714,-4.74633,47.58948,-.77114,-2.0612,46.28678,2.30484,-4.68512,47.34889,-.2274,-4.61311,47.37253,-.23472,-.51326,49.97202,-2.22988,-.50422,49.94071,-2.25864};
			return value;
		}
		private double[] getrrib4_Coord_7_145_point_4()
		{
			double[] value = {-.51115,49.96387,-2.22411,-.50079,49.92702,-2.24372,-4.59765,48.30046,-1.66971,-4.72635,48.02636,-1.1341,-4.57236,48.30465,-1.65454,-4.74844,48.0234,-1.14153,-4.64445,48.00144,-1.12275,-4.48665,47.05447,.30121,-2.23117,46.3648,2.24152,-2.21543,46.34325,2.21574,-2.14181,46.32136,2.28056,-4.56875,47.56739,-.01545,-4.5896,47.56116,-.01325,-4.75863,47.78581,-.59733,-4.78041,47.78146,-.60018,-2.19144,46.16066,2.41493,-2.27849,46.21443,2.3609,-.83311,49.83386,-2.59676,-1.13901,49.86196,-2.98174,-1.05384,50.05588,-2.628,-1.23569,50.0704,-2.72373,-.8697,50.05165,-2.48672,-.95421,50.00185,-2.5793,-.863,49.99606,-2.50703,-.95716,50.05789,-2.56092,-.77898,49.98347,-2.42195,-.72164,50.03759,-2.32501,-.78702,50.04928,-2.41012,-.71256,49.97868,-2.33517,-.76138,49.90843,-2.44242,-.84625,49.87993,-2.56197,-.85405,49.93142,-2.52984,-.71404,50.10324,-2.34651,-.57535,49.96406,-2.41457,-.57125,49.89677,-2.40731,-.52892,49.96438,-2.37582,-.71159,49.96032,-2.5116,-.62884,49.88911,-2.44154,-.71889,49.89286,-2.51198,-.62348,49.95631,-2.44523,-.81302,49.90425,-2.59243,-.79412,49.97086,-2.57797,-.79357,50.04581,-2.54942,-.66757,50.10115,-2.27144,-.55889,49.78331,-2.38352,-.64573,49.95769,-2.25375,-.59681,50.05902,-2.3713,-.5249,49.96567,-2.36737,-.4934,49.84886,-2.20215,-.49569,49.88365,-2.17331,-.51596,49.93197,-2.1693,-.55485,50.02774,-2.19128,-.53388,49.9742,-2.16798,-.56038,50.05731,-2.21951,-.52229,49.95836,-2.30567,-.51612,49.92941,-2.30996,-.50877,49.95439,-2.21436,-.49808,49.91622,-2.23242,-2.28225,46.15696,2.20229,-2.44243,46.06821,2.37251,-2.35408,46.26884,2.30894,-2.4403,45.77264,2.41041,-2.37051,45.90337,2.27155,-2.5305,46.31085,2.05368,-2.67933,46.21252,2.20651,-2.5778,46.39801,2.15964,-2.75149,45.98215,2.22507,-2.62865,46.0334,2.114,-3.02913,46.6709,1.82113,-3.2164,46.22004,1.87765,-3.13606,46.48331,1.84819,-3.11193,46.26586,1.76327,-3.01609,46.58052,1.7228,-3.44448,46.66491,1.57462,-3.37283,46.84717,1.53971,-3.55,46.44891,1.54554,-3.4458,46.49028,1.43483,-1.7308,49.97078,-3.13825,-.66253,50.02261,-2.2458,-.49881,49.91716,-2.20795,-.50508,49.94018,-2.20604,-.49708,49.91164,-2.2198,-4.15426,48.71645,-2.15619};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib5_Geo_6_150_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,3,6,4,-1,7,8,9,-1,8,10,9,-1,8,11,10,-1,12,13,14,-1,12,15,13,-1,16,17,18,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,23,26,24,-1,27,28,29,-1,29,30,27,-1,24,21,31,-1,21,20,31,-1,32,33,34,-1,33,35,34,-1,36,37,38,-1,36,39,37,-1,40,27,30,-1,30,41,40,-1,42,43,44,-1,43,45,44,-1,46,47,48,-1,47,49,48,-1,50,51,52,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,60,63,61,-1,64,65,66,-1,64,67,65,-1,68,69,70,-1,71,72,73,-1,73,74,71,-1,75,76,77,-1,76,50,77,-1,78,79,80,-1,78,81,79,-1,8,7,82,-1,83,84,85,-1,84,86,85,-1,87,88,89,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,96,97,94,-1,98,99,90,-1,98,100,101,-1,102,103,104,-1,87,105,106,-1,106,107,87,-1,108,109,110,-1,111,112,113,-1,114,115,116,-1,114,117,115,-1,13,118,119,-1,118,120,119,-1,121,14,122,-1,14,123,122,-1,70,69,124,-1,125,126,17,-1,17,127,125,-1,128,129,130,-1,128,131,129,-1,132,133,134,-1,133,131,134,-1,16,135,136,-1,16,137,135,-1,138,129,133,-1,129,131,133,-1,139,17,140,-1,139,127,17,-1,141,71,74,-1,141,142,71,-1,8,143,11,-1,117,114,144,-1,144,145,117,-1,123,119,146,-1,146,147,123,-1,148,121,149,-1,150,151,152,-1,152,153,150,-1,118,13,15,-1,137,154,155,-1,155,156,137,-1,18,157,16,-1,158,159,129,-1,138,160,161,-1,162,163,164,-1,165,160,2,-1,165,161,160,-1,1,0,135,-1,2,1,165,-1,129,159,130,-1,166,167,164,-1,70,168,169,-1,70,124,168,-1,35,170,171,-1,171,172,35,-1,49,6,48,-1,49,4,6,-1,173,174,175,-1,175,176,173,-1,177,178,179,-1,178,180,179,-1,181,76,182,-1,76,177,182,-1,183,42,184,-1,42,44,184,-1,185,186,187,-1,187,188,185,-1,189,190,191,-1,190,192,191,-1,191,192,193,-1,192,188,193,-1,194,195,196,-1,195,197,196,-1,198,78,199,-1,198,200,78,-1,201,202,203,-1,201,204,202,-1,205,206,207,-1,205,65,206,-1,168,72,150,-1,150,169,168,-1,205,208,209,-1,205,207,208,-1,142,143,8,-1,8,144,142,-1,210,156,211,-1,210,212,156,-1,213,130,159,-1,213,214,130,-1,130,215,216,-1,130,214,215,-1,217,218,219,-1,219,220,217,-1,221,222,223,-1,221,224,222,-1,225,89,88,-1,226,99,227,-1,99,228,227,-1,229,90,92,-1,230,112,231,-1,230,232,112,-1,98,101,233,-1,234,235,236,-1,235,237,236,-1,238,230,225,-1,225,239,238,-1,230,89,225,-1,230,231,89,-1,223,222,217,-1,217,220,223,-1,240,241,128,-1,240,242,241,-1,162,0,2,-1,158,122,123,-1,123,147,158,-1,73,72,168,-1,243,244,245,-1,243,246,244,-1,243,247,246,-1,243,209,247,-1,248,249,250,-1,249,203,250,-1,251,252,253,-1,252,66,253,-1,254,255,53,-1,255,54,53,-1,188,187,256,-1,256,193,188,-1,257,50,52,-1,257,258,50,-1,76,75,177,-1,75,178,177,-1,77,4,49,-1,77,259,4,-1,178,260,180,-1,260,261,180,-1,262,263,264,-1,262,265,263,-1,48,266,267,-1,48,6,266,-1,186,268,269,-1,268,270,269,-1,171,170,271,-1,128,241,134,-1,124,69,155,-1,136,167,140,-1,132,163,133,-1,163,132,272,-1,211,156,155,-1,2,160,163,-1,163,162,2,-1,272,139,166,-1,212,210,158,-1,210,122,158,-1,137,16,157,-1,157,154,137,-1,213,147,110,-1,147,146,110,-1,150,273,169,-1,150,153,273,-1,214,109,215,-1,139,272,274,-1,274,127,139,-1,158,129,161,-1,129,138,161,-1,16,136,140,-1,140,17,16,-1,272,132,274,-1,132,134,274,-1,272,166,164,-1,164,163,272,-1,275,141,74,-1,275,276,141,-1,123,14,13,-1,13,119,123,-1,144,114,142,-1,240,130,216,-1,240,128,130,-1,219,218,242,-1,218,241,242,-1,108,277,109,-1,108,278,277,-1,134,131,128,-1,279,246,247,-1,247,280,279,-1,89,105,87,-1,281,106,282,-1,281,107,106,-1,96,95,239,-1,283,284,285,-1,285,286,283,-1,287,288,289,-1,95,290,291,-1,290,292,291,-1,98,229,100,-1,98,90,229,-1,293,294,235,-1,235,288,293,-1,93,90,99,-1,239,225,88,-1,88,96,239,-1,276,275,295,-1};
			return value;
		}
		private int[] getrrib5_Geo_6_150_coordIndex_2()
		{
			int[] value = {295,296,276,-1,190,189,297,-1,189,197,297,-1,298,275,73,-1,73,299,298,-1,73,168,124,-1,74,73,275,-1,204,61,300,-1,204,201,61,-1,296,301,302,-1,296,295,301,-1,63,300,61,-1,63,303,300,-1,304,191,193,-1,304,305,191,-1,306,307,301,-1,306,308,307,-1,254,309,310,-1,254,53,309,-1,53,311,309,-1,53,194,311,-1,55,195,194,-1,194,53,55,-1,312,313,314,-1,314,257,312,-1,195,297,197,-1,195,315,297,-1,173,176,265,-1,176,263,265,-1,183,316,317,-1,316,318,317,-1,319,320,27,-1,27,40,319,-1,32,34,22,-1,22,19,32,-1,25,31,321,-1,25,24,31,-1,27,320,28,-1,320,322,28,-1,323,21,324,-1,323,19,21,-1,271,29,325,-1,271,326,29,-1,257,314,327,-1,327,258,257,-1,124,155,154,-1,154,328,124,-1,148,12,121,-1,12,14,121,-1,72,151,150,-1,5,4,329,-1,4,259,329,-1,327,259,258,-1,329,259,327,-1,330,331,332,-1,330,333,331,-1,334,333,330,-1,333,335,336,-1,334,335,333,-1,34,266,22,-1,266,34,267,-1,337,29,326,-1,337,30,29,-1,330,41,338,-1,330,332,41,-1,324,339,323,-1,339,324,340,-1,19,341,32,-1,19,323,341,-1,342,38,37,-1,38,342,33,-1,322,321,343,-1,322,25,321,-1,342,271,170,-1,326,271,342,-1,344,322,343,-1,28,322,344,-1,345,26,23,-1,345,346,26,-1,323,347,341,-1,323,339,347,-1,39,335,334,-1,36,335,39,-1,267,35,172,-1,35,267,34,-1,316,80,318,-1,316,348,80,-1,183,269,42,-1,183,317,269,-1,349,173,265,-1,350,173,349,-1,343,351,352,-1,321,351,343,-1,52,297,315,-1,52,51,297,-1,313,55,54,-1,312,55,313,-1,59,311,308,-1,309,311,59,-1,189,305,353,-1,305,189,191,-1,301,354,302,-1,307,354,301,-1,254,199,348,-1,254,310,199,-1,355,194,196,-1,311,194,355,-1,256,304,193,-1,79,304,256,-1,303,356,300,-1,303,200,356,-1,357,301,295,-1,357,306,301,-1,67,57,358,-1,67,58,57,-1,300,359,204,-1,359,300,356,-1,201,62,61,-1,201,360,62,-1,328,73,124,-1,73,328,299,-1,298,295,275,-1,298,357,295,-1,361,196,353,-1,196,361,355,-1,51,190,297,-1,181,190,51,-1,77,47,75,-1,77,49,47,-1,204,252,202,-1,204,359,252,-1,362,363,364,-1,362,278,363,-1,277,365,366,-1,277,367,365,-1,245,368,251,-1,245,10,368,-1,369,7,244,-1,369,82,7,-1,239,291,238,-1,239,95,291,-1,370,102,371,-1,103,102,370,-1,95,286,290,-1,95,94,286,-1,229,285,100,-1,229,292,285,-1,289,235,234,-1,289,288,235,-1,233,99,98,-1,233,228,99,-1,238,92,91,-1,291,92,238,-1,232,93,372,-1,93,232,91,-1,287,293,288,-1,287,373,293,-1,284,104,373,-1,283,104,284,-1,102,283,97,-1,283,102,104,-1,372,84,113,-1,372,226,84,-1,374,236,237,-1,236,374,375,-1,282,237,281,-1,237,282,374,-1,157,280,247,-1,18,280,157,-1,246,369,244,-1,279,369,246,-1,376,231,377,-1,376,89,231,-1,134,218,274,-1,134,241,218,-1,376,219,378,-1,376,220,219,-1,379,105,378,-1,105,379,106,-1,380,216,215,-1,380,381,216,-1,242,382,379,-1,382,242,240,-1,248,142,141,-1,142,248,143,-1,68,210,211,-1,68,149,210,-1,71,114,116,-1,71,142,114,-1,383,362,364,-1,384,362,383,-1,212,161,165,-1,212,158,161,-1,208,299,328,-1,299,208,207,-1,109,213,110,-1,214,213,109,-1,12,152,15,-1,153,152,12,-1,160,133,163,-1,133,160,138,-1,0,164,167,-1,0,162,164,-1,127,222,125,-1,127,217,222,-1,60,361,385,-1,361,60,354,-1,386,346,345,-1,386,387,346,-1,336,339,333,-1,336,347,339,-1,334,338,39,-1,334,330,338,-1,388,321,31,-1,351,321,388,-1,344,389,325,-1,389,344,390,-1,31,391,388,-1,31,20,391,-1,392,351,388,-1,350,351,392,-1,390,393,389,-1,393,390,394,-1,46,171,395,-1,46,172,171,-1,3,388,391,-1,392,388,3,-1,265,394,349,-1,262,394,265,-1,260,393,261,-1,260,395,393,-1,180,262,264,-1,180,261,262,-1,260,75,47,-1,260,178,75,-1,329,174,5,-1,175,174,329,-1,258,77,50,-1,259,77,258,-1,270,264,263,-1,268,264,270,-1,314,45,327,-1,44,45,314,-1,179,182,177,-1,185,182,179,-1,315,257,52,-1,312,257,315,-1,54,184,313,-1,255,184,54,-1,317,256,187,-1};
			return value;
		}
		private int[] getrrib5_Geo_6_150_coordIndex_3()
		{
			int[] value = {256,317,318,-1,255,348,316,-1,348,255,254,-1,79,396,304,-1,79,81,396,-1,385,63,60,-1,63,385,396,-1,56,309,59,-1,56,310,309,-1,360,276,296,-1,360,249,276,-1,65,358,206,-1,67,358,65,-1,359,66,252,-1,359,64,66,-1,203,368,250,-1,203,202,368,-1,249,141,276,-1,141,249,248,-1,328,157,208,-1,154,157,328,-1,280,383,279,-1,280,126,383,-1,253,209,243,-1,253,205,209,-1,145,363,397,-1,145,82,363,-1,251,243,245,-1,251,253,243,-1,148,68,273,-1,148,149,68,-1,146,120,397,-1,146,119,120,-1,108,146,397,-1,108,110,146,-1,86,380,85,-1,86,375,380,-1,378,89,376,-1,378,105,89,-1,223,111,221,-1,223,377,111,-1,100,284,101,-1,284,100,285,-1,382,374,282,-1,374,382,381,-1,281,370,107,-1,294,370,281,-1,282,379,382,-1,106,379,282,-1,235,281,237,-1,235,294,281,-1,101,373,287,-1,373,101,284,-1,287,233,101,-1,233,287,289,-1,381,375,374,-1,375,381,380,-1,291,229,92,-1,292,229,291,-1,83,221,111,-1,83,365,221,-1,377,220,376,-1,377,223,220,-1,96,87,371,-1,87,96,88,-1,224,365,367,-1,365,224,221,-1,228,236,227,-1,228,234,236,-1,109,366,215,-1,366,109,277,-1,384,367,362,-1,367,384,224,-1,397,117,145,-1,117,397,120,-1,10,250,368,-1,11,250,10,-1,279,364,369,-1,279,383,364,-1,125,224,384,-1,125,222,224,-1,208,247,209,-1,208,157,247,-1,167,139,140,-1,167,166,139,-1,66,205,253,-1,66,65,205,-1,207,298,299,-1,206,298,207,-1,398,67,64,-1,398,58,67,-1,357,206,358,-1,298,206,357,-1,360,203,249,-1,360,201,203,-1,310,198,199,-1,56,198,310,-1,308,355,307,-1,308,311,355,-1,396,303,63,-1,303,396,81,-1,305,396,385,-1,305,304,396,-1,79,318,80,-1,79,256,318,-1,353,385,361,-1,353,305,385,-1,316,184,255,-1,316,183,184,-1,312,195,55,-1,312,315,195,-1,192,185,188,-1,192,182,185,-1,187,269,317,-1,187,186,269,-1,313,44,314,-1,184,44,313,-1,190,182,192,-1,190,181,182,-1,268,185,179,-1,268,186,185,-1,43,263,176,-1,43,270,263,-1,264,179,180,-1,179,264,268,-1,327,175,329,-1,45,175,327,-1,392,5,174,-1,392,3,5,-1,47,395,260,-1,47,46,395,-1,394,261,393,-1,261,394,262,-1,173,392,174,-1,173,350,392,-1,389,395,171,-1,395,389,393,-1,390,349,394,-1,390,352,349,-1,20,266,391,-1,20,22,266,-1,171,325,389,-1,271,325,171,-1,344,352,390,-1,344,343,352,-1,41,399,40,-1,399,41,332,-1,36,336,335,-1,347,336,36,-1,346,331,340,-1,346,387,331,-1,345,400,386,-1,319,400,345,-1,18,126,280,-1,18,17,126,-1,274,217,127,-1,274,218,217,-1,167,135,0,-1,136,135,167,-1,213,158,147,-1,213,159,158,-1,397,278,108,-1,397,363,278,-1,273,12,148,-1,273,153,12,-1,116,152,151,-1,115,152,116,-1,11,248,250,-1,11,143,248,-1,15,115,118,-1,15,152,115,-1,82,144,8,-1,82,145,144,-1,151,71,116,-1,151,72,71,-1,156,135,137,-1,156,1,135,-1,165,156,212,-1,165,1,156,-1,384,126,125,-1,384,383,126,-1,169,68,70,-1,68,169,273,-1,211,69,68,-1,155,69,211,-1,149,122,210,-1,149,121,122,-1,120,115,117,-1,118,115,120,-1,240,381,382,-1,381,240,216,-1,85,215,366,-1,85,380,215,-1,371,107,370,-1,371,87,107,-1,242,378,219,-1,379,378,242,-1,112,377,231,-1,111,377,112,-1,375,227,236,-1,227,375,86,-1,230,91,232,-1,230,238,91,-1,286,97,283,-1,97,286,94,-1,373,103,293,-1,373,104,103,-1,372,112,232,-1,372,113,112,-1,233,234,228,-1,234,233,289,-1,285,290,286,-1,292,290,285,-1,371,97,96,-1,102,97,371,-1,293,370,294,-1,293,103,370,-1,113,83,111,-1,113,84,83,-1,9,244,7,-1,244,10,245,-1,244,9,10,-1,86,226,227,-1,84,226,86,-1,366,83,85,-1,366,365,83,-1,278,367,277,-1,278,362,367,-1,364,82,369,-1,364,363,82,-1,99,372,93,-1,99,226,372,-1,202,251,368,-1,252,251,202,-1,78,303,81,-1,200,303,78,-1,51,76,181,-1,76,51,50,-1,354,355,361,-1,354,307,355,-1,360,302,62,-1,360,296,302,-1,356,64,359,-1,64,356,398,-1,358,306,357,-1,358,57,306,-1,200,398,356,-1,200,198,398,-1,198,58,398,-1,198,56,58,-1};
			return value;
		}
		private int[] getrrib5_Geo_6_150_coordIndex_4()
		{
			int[] value = {62,354,60,-1,354,62,302,-1,197,353,196,-1,353,197,189,-1,57,308,306,-1,59,308,57,-1,270,42,269,-1,42,270,43,-1,352,350,349,-1,351,350,352,-1,348,78,80,-1,78,348,199,-1,172,48,267,-1,172,46,48,-1,45,176,175,-1,43,176,45,-1,40,400,319,-1,400,40,399,-1,39,337,37,-1,39,338,337,-1,38,347,36,-1,347,38,341,-1,26,340,324,-1,346,340,26,-1,345,320,319,-1,345,23,320,-1,325,28,344,-1,29,28,325,-1,33,170,35,-1,33,342,170,-1,326,37,337,-1,37,326,342,-1,38,32,341,-1,38,33,32,-1,24,324,21,-1,26,324,24,-1,320,25,322,-1,320,23,25,-1,340,333,339,-1,333,340,331,-1,338,30,337,-1,338,41,30,-1,387,332,331,-1,387,399,332,-1,386,399,387,-1,386,400,399,-1,6,391,266,-1,391,6,3,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib5_Coord_7_150_point_1()
		{
			double[] value = {-1.09225,49.21225,-3.01508,-1.07383,49.27683,-2.99586,-1.00818,49.23168,-2.97163,-2.82054,45.12207,2.21475,-3.46812,45.44305,1.66741,-3.43497,45.49252,1.66632,-2.85208,45.05063,2.2089,-1.36003,49.56027,-3.12558,-1.30225,49.55371,-3.14405,-1.38301,49.55659,-3.13748,-1.48874,49.5494,-3.2304,-1.4436,49.51093,-3.2717,-1.0282,49.46381,-3.03823,-.98969,49.50232,-3.0214,-.97359,49.46605,-3.00127,-1.02752,49.50391,-3.05475,-1.19545,49.1986,-3.00756,-1.17668,49.2164,-2.94872,-1.24462,49.22902,-3.00749,-2.35982,44.8204,2.52264,-2.32602,44.87426,2.50098,-2.32854,44.88592,2.51456,-2.36118,44.80694,2.50505,-2.28223,45.1536,2.5435,-2.28523,45.03363,2.51113,-2.26019,45.16637,2.53483,-2.30498,45.04518,2.51439,-2.37788,45.0984,2.59315,-2.37876,45.10304,2.61452,-2.41586,44.96653,2.63865,-2.41734,44.96847,2.61767,-2.281,45.03522,2.49371,-2.39464,44.7576,2.53326,-2.41342,44.75701,2.57016,-2.40464,44.74646,2.51943,-2.42875,44.74412,2.57349,-2.45437,44.86407,2.53081,-2.42271,44.81581,2.58852,-2.40974,44.77971,2.55854,-2.45566,44.8969,2.55482,-2.43228,45.0664,2.5614,-2.44996,44.99558,2.57022,-4.87728,47.23025,-.64796,-4.5072,46.78221,.30127,-4.86648,47.195,-.69354,-4.47196,46.72585,.26543,-2.90685,44.99018,2.2236,-3.52134,45.3945,1.68937,-2.88354,44.97968,2.20202,-3.50121,45.3938,1.66838,-4.712,46.4181,.12409,-5.05229,46.98327,-.92863,-5.01914,47.00518,-.90812,-4.44457,47.92893,-2.42956,-4.72711,47.6694,-1.97675,-4.74106,47.64882,-2.02479,-3.54672,48.56943,-2.8259,-2.89746,48.78547,-3.23251,-2.97208,48.86762,-3.0811,-3.47096,48.49661,-3.01683,-3.51891,48.55909,-3.17699,-2.9646,48.97232,-3.28044,-2.89358,48.88434,-3.36669,-3.59058,48.63636,-3.05387,-2.62013,49.12538,-3.15999,-2.18771,49.18012,-3.18426,-2.20092,49.28018,-3.21051,-2.60107,49.02919,-3.15431,-1.0555,49.3641,-3.01811,-1.22772,49.26496,-3.16514,-1.18495,49.31997,-3.15821,-1.35917,49.39972,-3.28051,-1.35728,49.36928,-3.27641,-1.60053,49.19124,-3.3251,-1.58716,49.23831,-3.35764,-4.11747,45.83168,1.08467,-4.75488,46.41649,.13712,-4.08556,45.81982,1.06639,-4.17627,48.34217,-2.55816,-4.61711,48.05846,-2.26919,-4.55933,48.05434,-2.23,-4.20769,48.33829,-2.62048,-1.22846,49.53858,-3.04385,-.75004,49.30761,-2.56672,-.66322,49.30077,-2.46577,-.72245,49.32485,-2.57058,-.65011,49.31305,-2.4666,-.47278,48.96913,-2.48103,-.51248,48.92579,-2.45984,-.5648,48.97738,-2.5292,-.60642,49.16016,-2.24672,-.61697,49.16006,-2.32627,-.60169,49.11595,-2.26343,-.61307,49.21252,-2.32681,-.52655,48.90914,-2.28858,-.53677,48.90817,-2.29476,-.48491,48.92754,-2.38547,-.47751,48.94004,-2.36149,-.59553,49.17795,-2.24734,-.61269,49.2714,-2.33445};
			return value;
		}
		private double[] getrrib5_Coord_7_150_point_2()
		{
			double[] value = {-.58754,49.07841,-2.2119,-.50382,49.146,-2.30802,-.44283,48.9904,-2.40747,-.42589,49.04366,-2.42816,-.44321,49.01311,-2.3847,-.52319,48.97583,-2.54801,-.50633,49.00167,-2.5563,-.45766,49.02301,-2.49542,-1.01519,49.47241,-2.91475,-.95439,49.43913,-2.86166,-.98064,49.46818,-2.92595,-.76587,49.23458,-2.57657,-.675,49.20252,-2.47796,-.66974,49.23843,-2.47454,-1.18107,49.52102,-3.19003,-1.07766,49.53755,-3.11265,-1.16682,49.51083,-3.18947,-1.08962,49.54478,-3.10848,-1.0135,49.52356,-3.04469,-.98924,49.50587,-3.01156,-1.02128,49.52937,-3.03829,-.97779,49.43006,-2.99365,-.9704,49.41557,-2.98119,-.96759,49.46168,-2.98992,-1.37169,49.23229,-3.24206,-1.11314,49.28283,-2.87617,-1.18057,49.30523,-2.94528,-1.11261,49.19658,-2.90594,-.92894,49.24163,-2.87521,-.95183,49.29722,-2.89803,-.92072,49.3236,-2.87163,-.95626,49.2487,-2.89233,-.97511,49.2019,-2.90198,-.969,49.24151,-2.89881,-.9709,49.19816,-2.89547,-1.13617,49.2419,-3.03886,-1.17401,49.19262,-3.00645,-1.1481,49.24796,-3.05092,-.95968,49.28441,-2.90334,-1.11544,49.1925,-2.92033,-1.16484,49.20335,-2.95021,-1.59605,49.2726,-3.36911,-1.37988,49.42902,-3.2792,-1.40043,49.46304,-3.28324,-1.22867,49.54432,-3.15744,-1.16687,49.53516,-3.07466,-.98293,49.47731,-2.95521,-.97036,49.43278,-2.94449,-1.02119,49.42539,-3.01354,-1.01399,49.37705,-2.98608,-1.15994,49.4386,-3.16827,-1.1638,49.47181,-3.17847,-1.07107,49.498,-3.10438,-1.06846,49.46104,-3.08398,-1.27245,49.24085,-3.12676,-1.21939,49.26089,-3.15007,-1.07993,49.28995,-3.00305,-1.31237,49.23472,-3.05916,-.95401,49.36025,-2.9356,-.94314,49.34584,-2.90689,-.96349,49.24354,-2.92221,-.95302,49.32677,-2.93192,-1.03673,49.19383,-2.97124,-.97276,49.19997,-2.92313,-1.06227,49.16611,-2.94958,-.99988,49.29049,-2.95951,-1.09029,49.1732,-2.92713,-1.13564,49.16992,-2.98092,-1.34255,49.27479,-3.26981,-1.16168,49.38005,-3.15617,-2.44018,44.78866,2.61417,-2.59291,44.87901,2.52999,-2.57149,44.79775,2.49154,-3.30978,45.86929,1.74192,-3.37874,45.82469,1.67796,-3.80819,46.18603,1.12711,-3.86039,46.26928,1.14429,-4.76077,46.52559,.24639,-4.10725,45.96734,1.13846,-4.70639,46.64802,.31007,-4.0282,46.1261,1.15984,-5.08014,46.98566,-.92142,-5.15667,47.04586,-.77726,-4.89204,47.53562,-1.39117,-4.85247,47.50729,-1.45207,-5.1087,47.14734,-.68236,-5.00844,47.24217,-.60847,-5.02995,47.54053,-1.38183,-5.08078,47.4864,-1.50064,-4.81806,47.59967,-2.21096,-5.03176,47.34143,-1.71256,-4.90429,47.67152,-2.157,-5.11138,47.41,-1.61483,-4.90936,47.74441,-2.01321,-4.46338,47.90228,-2.53505,-4.7839,47.62454,-2.11502,-4.44885,47.86954,-2.61798,-4.79487,47.59421,-2.19435,-3.59232,48.63994,-2.80502,-4.12812,48.32207,-2.5438};
			return value;
		}
		private double[] getrrib5_Coord_7_150_point_3()
		{
			double[] value = {-3.62034,48.66904,-2.85148,-2.53374,49.15015,-3.35474,-2.1422,49.36928,-3.32589,-2.0833,49.29899,-3.39702,-2.59527,49.20459,-3.27214,-1.84411,49.26,-3.15364,-2.1123,49.10972,-3.27178,-1.76254,49.18856,-3.18912,-1.50652,49.22964,-3.13939,-1.55017,49.3037,-3.11939,-1.00964,49.35825,-2.9756,-1.05747,49.34392,-3.00819,-1.00116,49.32453,-2.96433,-.95309,49.40836,-2.91026,-.94032,49.40071,-2.86367,-.77791,49.35203,-2.6912,-.7353,49.29088,-2.69921,-1.02875,49.19396,-2.84535,-.98787,49.1711,-2.86084,-.71676,49.06431,-2.71802,-.77984,49.09023,-2.70534,-.86649,49.29113,-2.66517,-1.03661,49.25955,-2.82285,-.84935,49.16505,-2.67657,-1.03889,49.36188,-2.82835,-.55094,48.92123,-2.44177,-.63691,49.3034,-2.40111,-.62444,49.32477,-2.39974,-.60627,49.32569,-2.35303,-.59699,49.06868,-2.21656,-.60469,49.04655,-2.45198,-.64325,49.06535,-2.50513,-.64806,49.18623,-2.41931,-.59545,49.31093,-2.32972,-.5417,49.32113,-2.4166,-.48894,49.22737,-2.43634,-.56812,49.31621,-2.45757,-.51285,49.23041,-2.47998,-.56888,49.02163,-2.36567,-.53906,48.90431,-2.36804,-.70508,49.17245,-2.7159,-.94595,49.18849,-2.8743,-.69208,49.08405,-2.72011,-1.55918,49.43077,-3.13264,-1.37898,49.55199,-3.11732,-1.51217,49.5389,-3.20275,-1.34783,49.42192,-3.05124,-1.32652,49.32026,-3.0552,-1.62797,49.36249,-3.3598,-2.01621,49.21242,-3.44821,-1.68436,49.43253,-3.3352,-1.82301,49.4428,-3.23137,-2.18992,49.33911,-3.25059,-1.85535,49.37468,-3.17204,-4.44887,48.00711,-2.25505,-4.69386,47.73497,-1.8535,-4.89212,47.78922,-1.871,-4.98212,47.03008,-.88484,-4.64754,46.44819,.13138,-4.01709,45.86126,1.05145,-3.57413,45.5055,1.70632,-3.51165,45.69622,1.74845,-3.41764,45.83853,1.76905,-3.9069,46.28939,1.15877,-3.99206,46.28679,1.1421,-3.33603,45.88594,1.7557,-2.52174,44.86561,2.42815,-2.55014,44.78483,2.44808,-4.62071,46.78144,.34387,-4.91879,47.24623,-.62032,-4.56503,46.80338,.32858,-2.44099,44.87994,2.63659,-1.02796,49.18196,-2.89669,-1.06717,49.42197,-3.06364,-1.03085,49.17773,-2.88726,-1.9941,49.05997,-3.44475,-1.97775,49.09506,-3.47048,-.99679,49.4507,-2.84707,-1.0776,49.48031,-2.90961,-1.26054,49.42208,-3.00919,-1.25329,49.31652,-3.00621,-.45884,49.10588,-2.49834,-.52995,49.09432,-2.55974,-.47055,48.97999,-2.33626,-.47785,49.0337,-2.32231,-.54886,48.97687,-2.2142,-.54022,48.93004,-2.25237,-.48087,49.19317,-2.37399,-.47934,49.22179,-2.40542,-.53237,49.30924,-2.39382,-.55144,48.93114,-2.25363,-.55548,48.99416,-2.28748,-.56356,48.97004,-2.22121,-.43265,49.10505,-2.4287,-.43538,49.11097,-2.45346,-2.43266,48.91055,-3.43617,-2.42398,48.9343,-3.46278,-5.00211,47.33878,-1.71269,-2.06096,49.10452,-3.35524,-1.6595,49.20024,-3.27271};
			return value;
		}
		private double[] getrrib5_Coord_7_150_point_4()
		{
			double[] value = {-3.00162,49.02736,-3.18544,-2.82904,48.7555,-3.38777,-2.8249,48.76789,-3.41791,-3.62565,48.67168,-2.90825,-4.60402,48.0167,-2.43183,-4.56671,47.9433,-2.5727,-2.86634,48.78706,-3.31515,-3.41874,48.45563,-3.20999,-3.45331,48.48159,-3.10621,-4.01774,48.20897,-2.76318,-4.08434,48.28363,-2.56012,-4.00345,48.18088,-2.87129,-4.92995,47.38123,-1.6373,-4.89461,47.42313,-1.5729,-4.94487,47.06426,-.84888,-4.97549,47.35754,-1.67941,-4.76856,47.7707,-1.81291,-4.93469,47.54735,-1.36949,-4.82487,47.7814,-1.81482,-2.38381,45.12893,2.53519,-2.29115,45.16241,2.55272,-2.25809,45.19444,2.52217,-2.28156,45.19095,2.56186,-2.373,44.84149,2.52919,-2.34298,44.89857,2.51661,-2.43124,44.9705,2.64284,-2.42005,44.88019,2.62469,-4.58415,46.47859,.13799,-1.42878,49.23991,-3.19976,-3.94847,45.90292,1.03671,-2.44762,44.98894,2.53765,-2.43514,44.99248,2.5214,-2.44707,45.00331,2.54123,-2.43917,44.97702,2.52232,-2.44818,44.97679,2.53475,-2.44914,44.95277,2.52875,-2.44601,44.9497,2.52345,-2.41975,44.89227,2.60431,-2.45269,44.94629,2.56299,-2.4239,44.90566,2.51056,-2.4021,44.94795,2.50248,-2.40353,44.7842,2.53964,-2.42494,44.79363,2.60759,-2.29114,45.22488,2.55504,-2.39303,45.12523,2.61615,-2.36976,45.11358,2.51755,-2.3825,45.0311,2.50227,-2.44596,44.86326,2.51751,-4.5086,48.04195,-2.22549,-2.66496,45.46143,2.31837,-2.6509,45.4511,2.29707,-2.41813,45.31352,2.43487,-2.43156,45.32402,2.45587,-4.46714,47.87342,-2.63585,-3.42287,48.46347,-3.23676,-3.98167,48.15273,-2.96849,-3.00698,49.01631,-3.12904,-2.49042,48.95326,-3.34733,-2.52313,48.94718,-3.27803,-2.62012,49.18316,-3.20716,-2.46689,49.06347,-3.42044,-3.99477,48.15572,-2.98939,-1.08834,49.46938,-2.90218,-1.1532,49.51265,-2.97022,-1.16536,49.50272,-2.964,-.84345,49.35147,-2.6568,-.82216,49.3645,-2.66337,-1.02323,49.43188,-2.83717,-1.7536,49.46771,-3.30377,-1.24055,49.52889,-3.03561,-.42912,49.03717,-2.45307,-.4503,48.97547,-2.42935,-.64084,49.24703,-2.4112,-.44713,49.07421,-2.37845,-.57239,49.22525,-2.54123,-.61416,49.30937,-2.51826,-.65626,49.02973,-2.62703,-.74255,49.1203,-2.59899,-.60708,49.0075,-2.64534,-.58376,49.03142,-2.64493,-.68381,49.31848,-2.60439,-.64672,49.25552,-2.61965,-.60851,49.12641,-2.63914,-1.17361,49.41466,-2.94943,-1.10619,49.39255,-2.88723,-4.1091,48.22652,-2.91271,-2.43084,45.02619,2.52553,-2.43112,45.01173,2.5216,-2.45023,45.16442,2.40734,-2.58343,45.09247,2.53236,-2.53494,45.24046,2.52238,-2.49301,44.9711,2.41622,-2.71643,45.33836,2.23526,-2.85844,45.27524,2.31915,-2.78097,45.4228,2.32207,-2.94407,45.09194,2.26414,-4.17666,48.30141,-2.77095,-1.08986,49.50796,-2.9869,-2.99937,48.96036,-3.06873,-2.44058,45.03096,2.54049};
			return value;
		}
		private double[] getrrib5_Coord_7_150_point_5()
		{
			double[] value = {-2.43209,45.03219,2.52906};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib6_Geo_6_155_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,7,8,2,-1,9,10,11,-1,10,12,11,-1,13,14,15,-1,16,17,18,-1,16,18,19,-1,20,21,22,-1,22,23,20,-1,24,25,26,-1,27,28,29,-1,30,5,31,-1,5,32,31,-1,33,34,35,-1,33,36,34,-1,37,38,39,-1,40,41,42,-1,43,44,41,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,50,52,51,-1,53,54,55,-1,56,57,58,-1,56,59,57,-1,60,61,62,-1,33,63,64,-1,64,65,33,-1,66,67,68,-1,69,70,71,-1,71,72,69,-1,73,74,75,-1,73,65,74,-1,76,77,78,-1,76,79,77,-1,80,81,82,-1,80,83,81,-1,73,84,65,-1,84,85,65,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,94,97,95,-1,98,99,100,-1,98,101,99,-1,102,103,104,-1,102,105,103,-1,106,107,27,-1,108,109,110,-1,110,111,108,-1,112,113,114,-1,112,45,115,-1,115,113,112,-1,116,28,117,-1,116,29,28,-1,118,119,120,-1,119,121,120,-1,122,123,124,-1,125,126,38,-1,125,127,126,-1,128,129,127,-1,130,131,132,-1,132,107,130,-1,133,134,135,-1,133,136,134,-1,137,25,24,-1,24,138,137,-1,139,26,20,-1,20,140,139,-1,141,142,143,-1,143,144,141,-1,145,146,147,-1,89,141,144,-1,89,86,141,-1,148,133,149,-1,133,150,149,-1,151,82,152,-1,151,80,82,-1,125,37,87,-1,125,38,37,-1,130,153,108,-1,108,154,130,-1,155,54,53,-1,62,61,17,-1,156,53,59,-1,156,155,53,-1,157,158,159,-1,160,161,162,-1,163,164,165,-1,52,166,51,-1,167,168,169,-1,169,170,167,-1,162,12,171,-1,162,11,12,-1,172,173,174,-1,173,175,174,-1,176,10,177,-1,14,13,178,-1,13,179,178,-1,180,178,181,-1,182,183,184,-1,185,186,187,-1,185,188,186,-1,189,187,190,-1,175,191,180,-1,180,174,175,-1,192,193,194,-1,194,195,192,-1,196,197,167,-1,167,170,196,-1,198,199,200,-1,198,201,199,-1,186,202,203,-1,186,204,202,-1,173,205,206,-1,173,207,205,-1,208,209,210,-1,187,211,185,-1,174,212,172,-1,174,213,212,-1,53,55,214,-1,32,5,215,-1,216,30,31,-1,206,175,173,-1,206,195,175,-1,217,192,210,-1,192,208,210,-1,199,201,218,-1,218,219,199,-1,149,220,148,-1,220,221,148,-1,222,223,224,-1,223,225,224,-1,226,227,144,-1,226,228,227,-1,134,229,230,-1,20,231,140,-1,20,23,231,-1,232,233,234,-1,232,235,233,-1,200,236,237,-1,236,238,237,-1,107,153,130,-1,107,106,153,-1,147,239,240,-1,99,94,96,-1,129,241,127,-1,129,242,241,-1,39,243,244,-1,244,92,39,-1,245,246,247,-1,244,243,152,-1,243,151,152,-1,244,248,249,-1,244,152,248,-1,250,251,252,-1,252,78,250,-1,249,253,254,-1,249,248,253,-1,94,101,255,-1,94,99,101,-1,256,257,258,-1,256,259,257,-1,260,261,262,-1,260,263,261,-1,263,264,265,-1,263,260,264,-1,266,265,267,-1,267,268,266,-1,269,64,63,-1,131,130,154,-1,154,270,131,-1,36,271,34,-1,36,85,271,-1,272,273,270,-1,270,154,272,-1,274,40,275,-1,276,18,17,-1,17,61,276,-1,274,46,56,-1,46,48,56,-1,158,157,276,-1,277,278,279,-1,277,280,278,-1,281,282,30,-1,282,6,30,-1,283,284,285,-1,283,286,284,-1,287,238,288,-1,288,289,287,-1,188,283,204,-1,204,186,188,-1,204,290,202,-1,204,291,290,-1,188,286,283,-1,188,292,286,-1,293,157,294,-1,293,276,157,-1,269,62,55,-1,269,295,62,-1,274,56,58,-1,110,49,296,-1,110,297,49,-1,46,274,275,-1,298,273,299,-1,298,270,273,-1,54,64,269,-1,300,131,301,-1,300,132,131,-1,74,265,264,-1,74,267,265,-1,117,103,116,-1,117,302,103,-1,303,304,305,-1,303,306,304,-1,262,307,308,-1,262,261,307,-1,309,97,310,-1,310,311,309,-1,100,312,98,-1,100,313,312,-1,314,308,307,-1,314,79,308,-1,315,97,309,-1,315,95,97,-1,254,253,314,-1,314,313,254,-1,316,252,309,-1,252,315,309,-1,90,254,317,-1,90,249,254,-1,92,249,90,-1,92,244,249,-1,247,246,83,-1,246,81,83,-1,68,247,83,-1,68,318,247,-1,89,227,87,-1,227,125,87,-1,222,319,223,-1,319,320,223,-1,321,118,120,-1,120,105,321,-1,322,86,323,-1,322,141,86,-1,162,324,160,-1};
			return value;
		}
		private int[] getrrib6_Geo_6_155_coordIndex_2()
		{
			int[] value = {162,325,324,-1,326,327,328,-1,293,43,19,-1,293,44,43,-1,229,329,330,-1,229,136,329,-1,331,332,231,-1,231,23,331,-1,146,239,147,-1,223,320,333,-1,221,70,138,-1,221,220,70,-1,197,196,334,-1,206,208,195,-1,208,192,195,-1,41,40,274,-1,5,4,60,-1,60,215,5,-1,85,36,65,-1,169,335,170,-1,187,189,211,-1,189,336,211,-1,212,337,338,-1,338,172,212,-1,339,334,340,-1,339,190,334,-1,190,197,334,-1,200,199,213,-1,213,236,200,-1,195,191,175,-1,195,194,191,-1,185,211,201,-1,194,14,191,-1,237,198,200,-1,237,341,198,-1,191,14,180,-1,14,178,180,-1,179,342,181,-1,181,178,179,-1,176,343,344,-1,344,10,176,-1,236,213,174,-1,174,180,236,-1,345,346,171,-1,30,6,5,-1,51,165,296,-1,296,49,51,-1,163,284,347,-1,163,166,284,-1,341,292,198,-1,341,286,292,-1,198,292,201,-1,348,349,350,-1,350,351,348,-1,118,321,47,-1,47,352,118,-1,298,73,301,-1,298,84,73,-1,70,137,138,-1,70,69,137,-1,136,229,134,-1,229,330,240,-1,330,353,240,-1,224,137,69,-1,69,222,224,-1,354,226,143,-1,226,144,143,-1,148,136,133,-1,148,329,136,-1,73,75,301,-1,75,300,301,-1,320,355,356,-1,320,319,355,-1,228,125,227,-1,245,318,357,-1,245,247,318,-1,117,358,359,-1,117,28,358,-1,121,106,27,-1,27,29,121,-1,153,106,121,-1,121,119,153,-1,96,100,99,-1,96,317,100,-1,109,352,110,-1,92,360,39,-1,92,91,360,-1,317,96,93,-1,93,90,317,-1,227,89,144,-1,81,250,82,-1,250,361,82,-1,362,83,80,-1,362,68,83,-1,75,264,305,-1,75,74,264,-1,355,362,356,-1,250,81,251,-1,34,271,216,-1,56,48,156,-1,156,59,56,-1,363,297,47,-1,47,46,363,-1,49,297,363,-1,363,50,49,-1,166,165,51,-1,166,163,165,-1,114,54,155,-1,42,50,40,-1,42,350,50,-1,297,110,47,-1,110,352,47,-1,275,363,46,-1,216,35,34,-1,216,31,35,-1,33,65,36,-1,54,269,55,-1,239,230,229,-1,229,240,239,-1,20,25,21,-1,20,26,25,-1,23,22,331,-1,19,43,16,-1,57,43,58,-1,57,16,43,-1,9,235,364,-1,2,365,0,-1,2,8,365,-1,366,7,2,-1,7,366,367,-1,222,72,319,-1,222,69,72,-1,4,61,60,-1,4,368,61,-1,62,214,55,-1,62,17,214,-1,324,158,160,-1,158,324,159,-1,156,114,155,-1,114,156,112,-1,42,351,350,-1,42,369,351,-1,370,157,159,-1,370,294,157,-1,281,233,282,-1,233,281,371,-1,303,264,260,-1,305,264,303,-1,257,262,308,-1,257,259,262,-1,319,66,355,-1,319,72,66,-1,68,355,66,-1,68,362,355,-1,360,37,39,-1,360,372,37,-1,373,374,375,-1,373,302,374,-1,47,115,45,-1,47,321,115,-1,108,119,109,-1,153,119,108,-1,310,359,358,-1,359,310,255,-1,71,376,67,-1,71,377,376,-1,376,357,318,-1,357,376,378,-1,379,148,221,-1,379,329,148,-1,142,239,143,-1,142,230,239,-1,145,380,381,-1,145,382,380,-1,383,331,384,-1,383,332,331,-1,225,21,224,-1,225,22,21,-1,354,239,146,-1,354,143,239,-1,231,353,140,-1,231,385,353,-1,140,330,139,-1,353,330,140,-1,384,386,383,-1,333,386,384,-1,129,386,242,-1,387,386,129,-1,150,323,388,-1,323,150,322,-1,389,356,362,-1,356,389,241,-1,378,124,357,-1,122,124,378,-1,272,280,277,-1,272,111,280,-1,299,84,298,-1,299,390,84,-1,348,370,391,-1,370,348,351,-1,284,341,347,-1,284,286,341,-1,335,345,392,-1,335,169,345,-1,344,12,10,-1,392,12,344,-1,2,207,338,-1,2,1,207,-1,14,193,15,-1,14,194,193,-1,13,176,179,-1,176,13,343,-1,342,364,326,-1,364,342,177,-1,168,290,346,-1,168,202,290,-1,237,347,341,-1,393,347,237,-1,182,196,170,-1,182,217,196,-1,202,167,203,-1,167,202,168,-1,189,394,336,-1,189,395,394,-1,396,212,219,-1,337,212,396,-1,209,334,210,-1,209,340,334,-1,211,218,201,-1,397,211,336,-1,211,397,218,-1,340,398,399,-1,398,340,209,-1,399,339,340,-1,339,399,0,-1,158,61,368,-1,158,276,61,-1,215,62,295,-1,60,62,215,-1,35,63,33,-1,63,35,400,-1,0,395,339,-1,0,365,395,-1,207,3,205,-1,1,3,207,-1,381,387,401,-1,387,381,380,-1,320,241,242,-1,320,356,241,-1,382,147,385,-1};
			return value;
		}
		private int[] getrrib6_Geo_6_155_coordIndex_3()
		{
			int[] value = {382,145,147,-1,26,379,24,-1,26,139,379,-1,343,183,344,-1,183,343,184,-1,44,42,41,-1,42,44,369,-1,279,402,403,-1,404,402,279,-1,278,296,165,-1,278,280,296,-1,164,287,405,-1,164,393,287,-1,327,232,402,-1,232,327,326,-1,328,289,288,-1,328,327,289,-1,182,335,183,-1,182,170,335,-1,118,109,119,-1,352,109,118,-1,406,220,149,-1,377,220,406,-1,387,128,401,-1,129,128,387,-1,88,323,86,-1,323,88,123,-1,72,67,66,-1,67,72,71,-1,39,126,243,-1,38,126,39,-1,407,357,124,-1,357,407,245,-1,93,408,91,-1,408,93,409,-1,81,410,251,-1,81,246,410,-1,96,409,93,-1,409,96,95,-1,252,76,78,-1,316,76,252,-1,314,77,79,-1,253,77,314,-1,254,100,317,-1,254,313,100,-1,257,316,258,-1,76,316,257,-1,314,312,313,-1,314,307,312,-1,316,311,258,-1,316,309,311,-1,411,307,261,-1,411,312,307,-1,358,311,310,-1,358,412,311,-1,413,375,411,-1,413,373,375,-1,412,306,256,-1,414,306,412,-1,302,359,374,-1,302,117,359,-1,304,414,415,-1,306,414,304,-1,266,373,413,-1,373,266,104,-1,305,300,75,-1,305,304,300,-1,105,116,103,-1,116,105,120,-1,415,300,304,-1,415,132,300,-1,65,267,74,-1,267,65,64,-1,54,113,64,-1,54,114,113,-1,299,416,417,-1,416,299,273,-1,58,41,274,-1,41,58,43,-1,293,369,44,-1,294,369,293,-1,404,278,405,-1,404,279,278,-1,418,391,419,-1,418,348,391,-1,326,235,232,-1,235,326,364,-1,285,418,291,-1,285,420,418,-1,171,325,162,-1,171,346,325,-1,238,180,288,-1,238,236,180,-1,217,334,196,-1,210,334,217,-1,213,219,212,-1,213,199,219,-1,346,169,168,-1,169,346,345,-1,182,15,193,-1,184,15,182,-1,285,204,283,-1,204,285,291,-1,405,289,404,-1,405,287,289,-1,418,290,291,-1,290,418,419,-1,420,284,166,-1,285,284,420,-1,324,419,391,-1,419,324,325,-1,166,349,420,-1,166,52,349,-1,402,234,403,-1,402,232,234,-1,403,417,416,-1,417,403,234,-1,350,52,50,-1,52,350,349,-1,293,18,276,-1,19,18,293,-1,277,273,272,-1,277,416,273,-1,281,216,271,-1,30,216,281,-1,301,270,298,-1,270,301,131,-1,64,268,267,-1,268,64,113,-1,132,27,107,-1,132,415,27,-1,102,266,268,-1,104,266,102,-1,263,266,413,-1,263,265,266,-1,27,414,28,-1,414,27,415,-1,412,28,414,-1,28,412,358,-1,256,303,259,-1,306,303,256,-1,413,261,263,-1,413,411,261,-1,255,374,359,-1,255,101,374,-1,412,258,311,-1,412,256,258,-1,98,411,375,-1,411,98,312,-1,410,95,315,-1,410,409,95,-1,361,253,248,-1,361,77,253,-1,315,251,410,-1,251,315,252,-1,246,409,410,-1,408,409,246,-1,82,248,152,-1,361,248,82,-1,407,91,408,-1,407,360,91,-1,372,407,124,-1,372,360,407,-1,389,243,126,-1,389,151,243,-1,122,406,388,-1,406,122,378,-1,228,401,128,-1,228,226,401,-1,71,220,377,-1,71,70,220,-1,348,420,349,-1,418,420,348,-1,339,189,190,-1,339,395,189,-1,9,177,10,-1,364,177,9,-1,238,393,237,-1,238,287,393,-1,165,405,278,-1,164,405,165,-1,404,327,402,-1,289,327,404,-1,279,416,277,-1,279,403,416,-1,234,371,417,-1,234,233,371,-1,9,6,282,-1,9,11,6,-1,385,240,353,-1,147,240,385,-1,354,401,226,-1,381,401,354,-1,333,225,223,-1,384,225,333,-1,322,142,141,-1,142,322,135,-1,205,398,209,-1,205,3,398,-1,367,421,7,-1,396,421,367,-1,400,31,32,-1,400,35,31,-1,295,32,215,-1,295,400,32,-1,400,269,63,-1,295,269,400,-1,395,8,394,-1,395,365,8,-1,367,337,396,-1,337,367,366,-1,366,338,337,-1,338,366,2,-1,7,394,8,-1,421,394,7,-1,397,421,218,-1,336,421,397,-1,421,336,394,-1,206,209,208,-1,206,205,209,-1,421,219,218,-1,396,219,421,-1,185,292,188,-1,292,185,201,-1,203,197,190,-1,167,197,203,-1,192,182,193,-1,217,182,192,-1,190,186,203,-1,187,186,190,-1,393,163,347,-1,164,163,393,-1,346,419,325,-1,346,290,419,-1,179,177,342,-1,177,179,176,-1,343,15,184,-1,343,13,15,-1,338,173,172,-1,338,207,173,-1,11,161,6,-1,161,11,162,-1,392,171,12,-1,392,345,171,-1,161,158,368,-1,161,160,158,-1,159,391,370,-1,159,324,391,-1,214,59,53,-1,59,214,57,-1};
			return value;
		}
		private int[] getrrib6_Geo_6_155_coordIndex_4()
		{
			int[] value = {390,417,371,-1,417,390,299,-1,108,272,154,-1,108,111,272,-1,124,88,372,-1,88,124,123,-1,67,318,68,-1,376,318,67,-1,241,126,127,-1,241,389,126,-1,362,151,389,-1,362,80,151,-1,388,149,150,-1,149,388,406,-1,322,133,135,-1,322,150,133,-1,387,383,386,-1,380,383,387,-1,242,333,320,-1,242,386,333,-1,379,330,329,-1,379,139,330,-1,332,385,231,-1,385,332,382,-1,24,221,138,-1,24,379,221,-1,21,137,224,-1,21,25,137,-1,22,384,331,-1,384,22,225,-1,382,383,380,-1,382,332,383,-1,146,381,354,-1,146,145,381,-1,135,230,142,-1,135,134,230,-1,128,125,228,-1,128,127,125,-1,377,378,376,-1,378,377,406,-1,123,388,323,-1,123,122,388,-1,121,116,120,-1,121,29,116,-1,255,97,94,-1,255,310,97,-1,268,115,102,-1,113,115,268,-1,110,280,111,-1,296,280,110,-1,321,102,115,-1,321,105,102,-1,104,302,373,-1,104,103,302,-1,375,101,98,-1,375,374,101,-1,372,87,37,-1,372,88,87,-1,371,271,390,-1,371,281,271,-1,361,78,77,-1,78,361,250,-1,308,76,257,-1,308,79,76,-1,259,260,262,-1,259,303,260,-1,85,390,271,-1,390,85,84,-1,282,235,9,-1,282,233,235,-1,369,370,351,-1,369,294,370,-1,275,50,363,-1,275,40,50,-1,112,48,45,-1,48,112,156,-1,245,408,246,-1,245,407,408,-1,6,368,4,-1,161,368,6,-1,16,214,17,-1,16,57,214,-1,342,328,181,-1,326,328,342,-1,392,183,335,-1,344,183,392,-1,399,3,0,-1,3,399,398,-1,181,288,180,-1,288,181,328,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib6_Coord_7_155_point_1()
		{
			double[] value = {-.53747,48.2334,-2.57663,-.54497,48.22522,-2.5685,-.54361,48.22018,-2.57009,-.5455,48.23906,-2.56641,-.93581,48.56222,-3.01534,-.94055,48.57218,-3.0144,-.83914,48.55414,-2.92126,-.5408,48.21407,-2.58012,-.54041,48.22014,-2.58171,-.70901,48.54626,-2.79945,-.65343,48.55866,-2.74664,-.70854,48.54358,-2.81767,-.64608,48.5598,-2.75139,-.68718,48.43702,-2.63607,-.67714,48.33227,-2.5984,-.67018,48.43476,-2.61711,-1.02952,48.3926,-3.20608,-1.01332,48.47917,-3.22495,-.96978,48.41718,-3.17053,-.98768,48.34944,-3.15944,-2.71974,44.15806,2.48754,-2.66474,44.18806,2.50406,-2.67475,44.17127,2.53099,-2.72848,44.12483,2.51577,-2.67749,44.14935,2.44755,-2.66207,44.18481,2.48858,-2.70837,44.14517,2.46184,-2.61247,48.28977,-3.62015,-3.20758,48.01857,-3.44537,-2.59797,48.27531,-3.64817,-.94922,48.58597,-3.00934,-1.07985,48.62267,-3.13522,-1.07015,48.58995,-3.13645,-1.26869,48.65503,-3.31983,-1.12577,48.66362,-3.17571,-1.11816,48.63136,-3.18124,-1.28423,48.68484,-3.28756,-3.83572,44.32645,1.77976,-3.80837,44.41015,1.82957,-4.45764,44.86784,1.07744,-1.14405,48.20489,-3.18731,-1.05881,48.22929,-3.19123,-.96806,48.23286,-3.07176,-1.04318,48.29371,-3.20457,-.99471,48.27963,-3.1238,-1.29042,48.34694,-3.41759,-1.29997,48.31733,-3.38386,-1.32467,48.31305,-3.38659,-1.28095,48.34631,-3.41086,-1.16158,48.20604,-3.17291,-1.14677,48.20323,-3.17902,-.92182,48.18374,-2.95741,-.90472,48.19322,-2.96533,-1.16874,48.48768,-3.36877,-1.23877,48.58328,-3.37534,-1.11999,48.54755,-3.28705,-1.19588,48.33345,-3.34944,-1.10738,48.39212,-3.29464,-1.09751,48.30864,-3.28061,-1.18291,48.40667,-3.36019,-1.01969,48.554,-3.13892,-.96674,48.5003,-3.13453,-1.0348,48.56327,-3.21047,-1.26499,48.62266,-3.34182,-1.82176,48.63074,-3.70247,-1.8581,48.71534,-3.59888,-3.26505,44.57577,2.16315,-3.25772,44.56163,2.12797,-3.65841,44.83512,1.88978,-2.67958,44.22652,2.48177,-2.70431,44.19814,2.4061,-2.8451,44.30297,2.34002,-2.83881,44.3283,2.41344,-1.88359,48.70413,-3.58237,-2.2874,48.65728,-3.67692,-2.29443,48.65184,-3.6419,-4.95107,47.11653,-1.97771,-5.11459,46.72589,-1.27553,-5.07266,46.73207,-1.27413,-4.98617,47.11273,-1.99788,-4.28026,45.34721,1.18582,-4.71103,45.84305,.40518,-4.7248,45.84252,.41114,-4.27142,45.34738,1.17396,-1.34422,48.63523,-3.22823,-1.31278,48.68546,-3.25397,-3.01744,43.81489,2.20142,-3.46233,44.06488,1.99908,-3.46172,44.0624,1.9717,-3.0169,43.80949,2.23166,-5.12761,45.88493,-.60017,-4.8181,45.37004,.20405,-4.84704,45.38848,.22967,-5.06744,45.85885,-.62995,-4.80459,46.88108,-2.23348,-4.961,46.45245,-1.46221,-5.09118,46.39509,-1.50294,-4.73736,46.91663,-2.15587,-4.54374,47.22524,-2.86299,-4.8553,46.85349,-2.2932};
			return value;
		}
		private double[] getrrib6_Coord_7_155_point_2()
		{
			double[] value = {-4.88733,46.85991,-2.29989,-4.52116,47.22422,-2.85181,-2.14391,48.26329,-3.82238,-2.57519,48.15161,-3.84341,-2.57803,48.1599,-3.86669,-2.14673,48.25037,-3.80226,-2.19655,48.35725,-3.63598,-2.2192,48.38397,-3.6133,-1.36507,48.31464,-3.28925,-1.35367,48.30499,-3.31333,-1.26914,48.26533,-3.2359,-1.27666,48.29941,-3.19619,-1.26954,48.40713,-3.43982,-1.79112,48.49877,-3.73338,-1.25791,48.49327,-3.42141,-1.77195,48.37779,-3.74335,-2.57119,48.20268,-3.77437,-3.2283,47.97871,-3.58139,-1.81309,48.37309,-3.66868,-1.83878,48.34502,-3.61913,-2.16137,48.28698,-3.73879,-2.18635,48.33012,-3.66406,-3.40603,44.1935,1.91947,-3.43119,44.13974,1.9177,-3.73703,44.37813,1.73286,-3.43718,44.14669,2.07468,-3.76603,44.53523,1.88846,-3.40255,44.25612,2.16359,-2.96796,43.99378,2.43973,-2.93785,44.05324,2.47393,-1.87667,48.4253,-3.5652,-1.90314,48.51009,-3.53416,-2.25781,48.44525,-3.5679,-2.76407,43.83879,2.32463,-2.78483,43.77486,2.33917,-2.78291,43.76561,2.32305,-2.7658,43.83871,2.34233,-2.65757,44.19765,2.48906,-2.67204,44.15393,2.43824,-2.75466,44.10568,2.43518,-2.76802,44.09874,2.46637,-2.83431,43.7068,2.3147,-2.80968,43.71637,2.32718,-2.81929,43.71363,2.35388,-2.84103,43.7101,2.33812,-2.7831,43.8726,2.5195,-2.79402,43.80378,2.46095,-2.83624,43.88035,2.4554,-2.73641,43.97217,2.35374,-2.76195,43.99242,2.31513,-2.79825,43.86014,2.28711,-4.34209,45.20857,1.18538,-4.77752,45.72645,.37333,-1.85672,48.36115,-3.58987,-1.37028,48.39272,-3.26257,-1.24788,48.49278,-3.41499,-1.26041,48.40625,-3.4329,-.88852,48.43947,-3.0398,-.89357,48.46538,-3.02709,-.88246,48.4403,-3.03231,-.82391,48.49606,-2.94221,-.83376,48.528,-2.93074,-.70329,48.51505,-2.82563,-.81513,48.14359,-2.83044,-.82769,48.15712,-2.82135,-.93884,48.18155,-2.94833,-.79189,48.16439,-2.83777,-.55459,48.40175,-2.63666,-.58348,48.41304,-2.67012,-.59491,48.49215,-2.67342,-.57506,48.48251,-2.62636,-.64656,48.50409,-2.76143,-.57365,48.19076,-2.5599,-.57675,48.21003,-2.55095,-.61125,48.1384,-2.51783,-.61656,48.1571,-2.51361,-.67199,48.50495,-2.70938,-.67735,48.506,-2.71667,-.68454,48.33583,-2.62956,-.68489,48.43198,-2.66457,-.62431,48.14519,-2.52273,-.70564,48.33651,-2.64034,-.58831,48.47159,-2.58236,-.61188,48.52579,-2.67451,-.63755,48.49817,-2.65574,-.58056,48.1252,-2.65524,-.57516,48.19534,-2.67013,-.54671,48.18959,-2.63903,-.60611,48.1293,-2.67533,-.54673,48.19458,-2.63253,-.53153,48.29573,-2.61834,-.6291,48.16155,-2.51513,-.61116,48.40117,-2.52736,-.62525,48.40038,-2.52854,-.64277,48.30636,-2.5129,-.62717,48.29955,-2.5068,-.56506,48.46574,-2.60876,-.54185,48.39596,-2.61876,-.58769,48.08053,-2.60717,-.57732,48.0798,-2.56941};
			return value;
		}
		private double[] getrrib6_Coord_7_155_point_3()
		{
			double[] value = {-.59002,48.07457,-2.57151,-.57346,48.09056,-2.61248,-.58404,48.32779,-2.6726,-.55259,48.31605,-2.6422,-.5891,48.19935,-2.68005,-.56663,48.26201,-2.54273,-.57696,48.27042,-2.54254,-.56364,48.21133,-2.5515,-.55946,48.33632,-2.54666,-.54909,48.32743,-2.54557,-.55606,48.34562,-2.54951,-.57527,48.13676,-2.64511,-.56492,48.17091,-2.56309,-.6051,48.10439,-2.52883,-1.07941,48.46037,-3.29184,-1.05673,48.56732,-3.13269,-1.07831,48.64639,-3.14119,-.57928,48.45781,-2.56827,-.56215,48.14268,-2.60858,-.55598,48.15172,-2.58414,-2.72645,44.12716,2.35622,-2.70838,44.10411,2.3994,-2.68798,44.22658,2.52155,-2.69037,44.20382,2.55224,-2.66221,44.2062,2.51475,-2.67349,44.1783,2.53895,-2.83793,43.76845,2.43721,-3.01355,43.83409,2.29514,-3.0033,43.87099,2.3368,-2.82305,43.87408,2.35792,-2.80464,43.73622,2.34212,-2.7822,44.07859,2.50064,-.79002,48.45121,-2.80112,-.87201,48.53564,-2.90452,-.89237,48.48216,-2.90233,-.74345,48.53101,-2.80957,-.61638,48.10342,-2.53188,-.67268,48.11634,-2.65793,-.69409,48.15846,-2.64633,-2.81472,43.73578,2.36285,-2.82904,43.87685,2.40237,-3.34151,44.41818,2.22773,-2.89341,44.14769,2.49415,-4.40132,45.08019,1.19876,-4.83812,45.59151,.32928,-4.28263,45.09213,1.04477,-4.65717,45.64019,.27021,-4.2585,45.19173,1.07423,-5.08349,46.20655,-.40495,-5.14398,46.01467,-.52105,-4.98876,46.27869,-.37866,-4.96253,46.28119,-.41047,-5.00586,46.72953,-1.28225,-5.16899,46.68816,-1.29973,-5.19268,46.51474,-1.42924,-4.49837,47.27987,-2.77226,-4.06645,47.82411,-2.98183,-4.61363,47.4983,-2.57444,-4.5689,47.49098,-2.56449,-4.12505,47.83291,-3.01223,-3.33978,48.26456,-3.4887,-4.18745,47.79898,-3.13298,-4.15414,47.83121,-3.04134,-3.34829,48.21929,-3.56389,-2.73416,48.53193,-3.66125,-2.70981,48.47144,-3.74238,-2.63944,48.30705,-3.82203,-2.20422,48.58496,-3.74721,-2.14457,48.42233,-3.79031,-1.25035,48.60495,-3.33839,-1.37488,48.4933,-3.23019,-1.16605,48.66002,-3.15966,-1.26565,48.37496,-3.16977,-1.24316,48.48307,-3.13949,-1.17204,48.2535,-3.31194,-1.24627,48.23978,-3.27819,-.93144,48.44282,-3.12038,-1.11627,48.35663,-3.05209,-.95399,48.22897,-2.92324,-.93887,48.32265,-2.90812,-1.13511,48.27159,-3.08696,-.96889,48.5871,-2.99985,-.85279,48.5574,-2.91254,-.61782,48.13213,-2.68875,-.73009,48.13135,-2.75836,-.69378,48.17451,-2.77774,-.64827,48.10918,-2.67387,-.76941,48.17645,-2.71705,-.70334,48.23414,-2.63712,-.7568,48.27758,-2.71283,-.65479,48.34889,-2.77832,-.66977,48.22537,-2.77876,-.59043,48.0903,-2.62606,-.96131,48.34361,-3.10327,-.91214,48.32822,-3.03997,-1.11297,48.58735,-3.20363,-1.14386,48.23008,-3.1402,-1.26608,48.24545,-3.26338,-1.36281,48.57535,-3.22245,-1.22238,48.56151,-3.13981};
			return value;
		}
		private double[] getrrib6_Coord_7_155_point_4()
		{
			double[] value = {-2.29088,48.56356,-3.54717,-1.89958,48.60443,-3.54137,-3.2295,47.93538,-3.67831,-3.32636,48.26175,-3.4506,-2.70393,48.46566,-3.54573,-2.72997,48.52309,-3.62351,-3.28083,48.22785,-3.3755,-4.68201,47.43579,-2.66969,-4.64776,47.49432,-2.59464,-4.80501,47.02185,-2.03262,-4.46524,47.28347,-2.64062,-4.52126,47.38266,-2.58063,-4.6059,47.32404,-2.86449,-4.95595,46.92022,-2.20346,-5.03364,47.07571,-2.03926,-4.93222,46.61452,-1.35644,-4.89526,47.10573,-1.96249,-5.13741,46.39022,-1.50758,-3.67288,44.72218,1.8301,-2.84402,44.32935,2.46318,-2.86623,44.27098,2.48304,-1.78152,48.35787,-3.72221,-2.82922,43.78733,2.2852,-3.00668,43.89603,2.15623,-.8129,48.44479,-2.95651,-.70003,48.45249,-2.8393,-.72021,48.43245,-2.71853,-.74416,48.36068,-2.70947,-.72672,48.3504,-2.67818,-2.74385,43.96999,2.36855,-2.78854,43.98849,2.40217,-2.70386,44.08999,2.55927,-2.73208,44.0022,2.5601,-2.72072,44.10369,2.58419,-.53764,48.34862,-2.58387,-.60209,48.52484,-2.68401,-.564,48.15836,-2.63106,-.55435,48.17916,-2.56167,-.55893,48.19469,-2.55705,-.53055,48.28571,-2.60719,-.53229,48.33113,-2.57785,-.66062,48.10793,-2.66816,-.69888,48.43292,-2.68167,-.66645,48.50574,-2.69061,-.64058,48.55613,-2.72986,-.64136,48.50335,-2.75446,-.64723,48.44008,-2.77197,-.74307,48.13079,-2.74995,-.8517,48.26403,-2.97303,-.87782,48.21949,-2.97592,-.96299,48.22686,-3.06413,-.93841,48.26118,-3.04919,-1.34843,48.31741,-3.34703,-2.80366,43.98615,2.43922,-2.79927,43.77979,2.45312,-3.27319,44.58161,2.21131,-3.28852,44.53879,2.2186,-3.68411,44.56453,1.76975,-3.93498,47.63622,-3.09334,-3.99895,47.60632,-3.19591,-4.4476,44.85765,1.05719,-5.02166,46.27075,-.37683,-3.65569,44.8325,1.93907,-1.25547,48.2407,-3.2723,-.70565,48.51596,-2.76259,-.53833,48.22588,-2.5811,-.5424,48.21507,-2.57131,-.54062,48.20952,-2.57646,-.91971,48.52748,-3.0188,-.94245,48.26616,-3.05491,-.90524,48.32674,-3.03265,-.98625,48.56142,-2.99085,-3.83203,44.31907,1.75704,-3.24545,47.94365,-3.70197,-4.02961,47.5606,-3.28384,-4.05493,47.5646,-3.29857,-3.28918,44.47167,2.04363,-2.91588,44.21767,2.2471,-3.34592,44.32865,1.96818,-2.71393,44.10123,2.40818,-2.76051,43.9329,2.56236,-2.78572,43.86592,2.52851,-2.75906,43.93403,2.55327,-2.73241,44.00253,2.57265,-2.70318,44.09159,2.56818,-2.81355,43.97685,2.48924,-2.74492,44.01764,2.5846,-2.77715,43.93912,2.5747,-2.98359,43.97677,2.15944,-3.70521,44.68346,1.96125,-1.21057,48.61673,-3.14074,-.82569,48.34177,-2.96473,-.63545,48.55744,-2.73753,-.75434,48.1422,-2.7353,-.55369,48.1717,-2.61637,-.54115,48.1996,-2.61636,-.5473,48.16316,-2.57965,-.5627,48.14487,-2.6111,-.54177,48.2456,-2.56833,-.53739,48.2389,-2.57522};
			return value;
		}
		private double[] getrrib6_Coord_7_155_point_5()
		{
			double[] value = {-1.11556,48.60316,-3.19599,-2.80458,43.86862,2.53206,-.82112,48.39131,-2.79247,-.92446,48.41208,-2.89498,-.83403,48.30508,-2.79662,-.84267,48.20208,-2.80452,-2.95904,44.09576,2.18522,-4.34259,44.93808,1.01326,-4.70091,45.45609,.18469,-4.94112,45.94052,-.61413,-4.91103,46.09986,-.52496,-4.14002,47.63472,-3.26672,-3.99645,47.73556,-3.02228,-3.32877,48.03793,-3.6562,-3.22975,48.11473,-3.39397,-2.65039,48.35453,-3.5642,-1.09374,48.44294,-3.02463,-1.03183,48.51133,-3.0078,-.73281,48.24194,-2.84907,-.71426,48.35311,-2.84055,-.75422,48.20086,-2.84489,-.55203,48.15996,-2.59958};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib7_Geo_6_160_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,4,5,6,-1,7,6,8,-1,6,5,8,-1,9,10,11,-1,1,12,13,-1,13,14,1,-1,15,16,8,-1,17,16,15,-1,15,0,17,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,27,24,28,-1,27,29,24,-1,30,31,32,-1,32,33,30,-1,34,35,36,-1,36,37,38,-1,38,39,36,-1,40,41,42,-1,43,40,42,-1,44,45,46,-1,44,47,45,-1,48,49,47,-1,47,44,48,-1,50,51,52,-1,52,53,50,-1,53,34,39,-1,39,54,53,-1,55,56,57,-1,57,54,55,-1,58,59,55,-1,59,56,55,-1,58,41,40,-1,40,60,58,-1,46,45,61,-1,61,60,46,-1,62,63,64,-1,65,66,67,-1,66,68,67,-1,69,70,71,-1,72,73,74,-1,73,75,74,-1,11,76,77,-1,77,78,11,-1,13,12,79,-1,79,80,13,-1,80,81,82,-1,80,79,81,-1,9,83,84,-1,9,11,83,-1,85,86,87,-1,88,13,80,-1,89,90,91,-1,90,92,91,-1,89,91,27,-1,27,93,89,-1,94,95,96,-1,97,98,96,-1,96,99,97,-1,100,101,102,-1,101,103,102,-1,104,105,63,-1,63,62,104,-1,106,107,108,-1,106,109,107,-1,110,111,112,-1,110,113,111,-1,114,115,116,-1,116,117,114,-1,104,118,119,-1,119,120,104,-1,112,121,122,-1,91,29,27,-1,90,6,7,-1,123,124,125,-1,125,126,123,-1,127,118,128,-1,128,68,127,-1,129,130,131,-1,129,132,130,-1,74,75,133,-1,75,134,133,-1,135,136,137,-1,136,138,137,-1,139,129,140,-1,139,133,129,-1,141,142,143,-1,142,144,143,-1,145,146,147,-1,146,148,147,-1,149,150,126,-1,125,151,152,-1,151,153,152,-1,69,143,70,-1,143,154,70,-1,155,141,156,-1,155,147,141,-1,157,150,158,-1,150,159,158,-1,160,69,71,-1,160,156,69,-1,63,161,162,-1,162,64,63,-1,163,164,161,-1,163,165,164,-1,163,161,105,-1,161,63,105,-1,166,167,168,-1,166,169,167,-1,25,170,26,-1,25,171,170,-1,172,173,174,-1,174,175,172,-1,176,177,178,-1,179,177,180,-1,181,177,182,-1,110,183,184,-1,110,185,183,-1,186,187,188,-1,186,189,187,-1,190,191,108,-1,108,107,190,-1,96,33,192,-1,192,94,96,-1,193,194,187,-1,193,195,194,-1,196,197,31,-1,197,32,31,-1,30,96,98,-1,30,33,96,-1,89,102,103,-1,89,93,102,-1,171,25,198,-1,198,199,171,-1,200,198,92,-1,201,202,203,-1,204,205,201,-1,204,84,205,-1,206,17,2,-1,101,4,6,-1,207,208,209,-1,209,210,207,-1,211,27,28,-1,212,195,193,-1,193,117,212,-1,197,190,107,-1,111,113,116,-1,116,213,111,-1,214,182,177,-1,180,177,181,-1,178,177,179,-1,214,177,176,-1,122,18,215,-1,26,216,24,-1,216,28,24,-1,217,218,219,-1,218,220,219,-1,168,221,222,-1,168,167,221,-1,128,223,68,-1,223,67,68,-1,62,64,128,-1,64,223,128,-1,224,225,226,-1,226,120,224,-1,162,124,64,-1,124,123,64,-1,223,157,158,-1,158,67,223,-1,123,150,157,-1,123,126,150,-1,227,145,155,-1,145,147,155,-1,141,143,69,-1,69,156,141,-1,152,126,125,-1,152,149,126,-1,150,149,159,-1,149,228,159,-1,143,144,154,-1,144,229,154,-1,230,231,135,-1,231,136,135,-1,137,138,232,-1,138,72,232,-1,136,233,138,-1,233,234,138,-1,56,59,130,-1,130,132,56,-1,235,118,127,-1,235,119,118,-1,236,65,237,-1,237,227,236,-1,238,239,209,-1,110,112,122,-1,122,185,110,-1,211,31,27,-1,211,196,31,-1,175,174,240,-1,240,216,175,-1,103,90,89,-1,241,120,119,-1,241,224,120,-1,242,243,244,-1,242,225,243,-1,186,245,244,-1,244,189,186,-1,94,192,246,-1,222,221,127,-1,221,235,127,-1,111,213,191,-1,213,108,191,-1,173,122,121,-1,99,95,188,-1,99,96,95,-1,165,247,164,-1,165,248,247,-1,98,97,100,-1,100,102,98,-1,249,250,95,-1,251,17,206,-1,251,16,17,-1,251,252,253,-1,254,82,76,-1,76,10,254,-1,255,256,86,-1,255,257,256,-1,258,16,251,-1,258,8,16,-1,259,253,260,-1,260,200,259,-1,261,77,262,-1,77,81,262,-1,2,263,206,-1,76,11,10,-1,84,83,205,-1,202,263,2,-1,202,201,263,-1,83,11,264,-1,11,78,264,-1,203,204,201,-1,265,70,266,-1,265,71,70,-1,72,74,267,-1,267,232,72,-1,164,247,71,-1,71,265,164,-1};
			return value;
		}
		private int[] getrrib7_Geo_6_160_coordIndex_2()
		{
			int[] value = {268,269,131,-1,269,270,131,-1,127,68,222,-1,68,66,222,-1,237,65,158,-1,65,67,158,-1,237,158,159,-1,59,58,60,-1,60,61,59,-1,41,58,38,-1,58,55,38,-1,38,54,39,-1,38,55,54,-1,50,54,57,-1,50,53,54,-1,36,35,271,-1,37,42,41,-1,41,38,37,-1,36,39,34,-1,28,216,211,-1,272,273,190,-1,274,107,109,-1,200,92,259,-1,92,90,259,-1,275,276,170,-1,170,171,275,-1,21,277,22,-1,21,275,277,-1,23,22,278,-1,29,91,92,-1,239,278,22,-1,22,279,239,-1,280,5,255,-1,207,100,97,-1,3,15,280,-1,3,0,15,-1,8,258,7,-1,9,254,10,-1,9,281,254,-1,280,15,8,-1,8,5,280,-1,29,92,24,-1,79,12,282,-1,283,1,3,-1,0,2,17,-1,240,211,216,-1,240,196,211,-1,240,272,196,-1,208,284,285,-1,284,208,286,-1,282,1,283,-1,282,12,1,-1,287,3,280,-1,283,3,287,-1,254,288,88,-1,281,288,254,-1,183,238,285,-1,238,183,289,-1,100,210,101,-1,207,210,100,-1,5,257,255,-1,257,5,4,-1,290,262,81,-1,290,85,262,-1,87,22,291,-1,87,279,22,-1,239,289,278,-1,239,238,289,-1,239,256,209,-1,239,279,256,-1,277,171,199,-1,275,171,277,-1,276,21,215,-1,275,21,276,-1,272,197,196,-1,272,190,197,-1,107,32,197,-1,274,32,107,-1,174,272,240,-1,174,273,272,-1,49,52,51,-1,52,49,48,-1,61,130,59,-1,61,292,130,-1,145,237,159,-1,145,227,237,-1,228,269,146,-1,269,228,270,-1,131,292,268,-1,292,131,130,-1,36,293,37,-1,36,271,293,-1,266,154,151,-1,266,70,154,-1,232,153,229,-1,232,267,153,-1,260,252,264,-1,253,252,260,-1,263,205,252,-1,263,201,205,-1,1,202,2,-1,1,14,202,-1,88,82,254,-1,88,80,82,-1,206,252,251,-1,206,263,252,-1,294,122,215,-1,122,294,185,-1,262,295,261,-1,262,291,295,-1,200,296,297,-1,200,260,296,-1,251,259,258,-1,259,251,253,-1,279,86,256,-1,279,87,86,-1,204,9,84,-1,204,281,9,-1,103,6,90,-1,101,6,103,-1,165,298,248,-1,298,165,299,-1,186,300,245,-1,186,250,300,-1,188,250,186,-1,188,95,250,-1,219,235,221,-1,301,235,219,-1,213,106,108,-1,213,302,106,-1,191,112,111,-1,191,121,112,-1,302,220,106,-1,303,220,302,-1,298,304,305,-1,306,304,298,-1,169,217,167,-1,307,217,169,-1,95,246,249,-1,95,94,246,-1,308,114,309,-1,115,114,308,-1,189,243,310,-1,189,244,243,-1,242,245,311,-1,242,244,245,-1,309,225,224,-1,225,309,243,-1,303,241,301,-1,241,303,308,-1,312,276,20,-1,170,276,312,-1,313,216,26,-1,216,313,314,-1,175,315,172,-1,175,316,315,-1,214,314,313,-1,214,176,314,-1,316,179,315,-1,178,179,316,-1,180,20,19,-1,180,181,20,-1,312,214,313,-1,182,214,312,-1,78,261,296,-1,261,78,77,-1,285,209,208,-1,285,238,209,-1,292,45,317,-1,61,45,292,-1,162,266,124,-1,162,265,266,-1,317,47,233,-1,45,47,317,-1,134,56,132,-1,57,56,134,-1,234,72,138,-1,234,73,72,-1,233,231,317,-1,231,233,136,-1,231,269,268,-1,269,231,230,-1,229,137,232,-1,144,137,229,-1,148,135,142,-1,148,230,135,-1,140,228,149,-1,140,270,228,-1,139,153,267,-1,152,153,139,-1,236,155,318,-1,236,227,155,-1,223,123,157,-1,64,123,223,-1,301,119,235,-1,119,301,241,-1,120,105,104,-1,120,226,105,-1,160,319,318,-1,319,160,320,-1,66,236,321,-1,66,65,236,-1,222,321,168,-1,321,222,66,-1,166,320,322,-1,320,166,319,-1,248,305,322,-1,248,298,305,-1,163,226,323,-1,163,105,226,-1,217,324,218,-1,217,307,324,-1,323,311,299,-1,242,311,323,-1,172,122,173,-1,172,18,122,-1,185,289,183,-1,185,294,289,-1,324,249,246,-1,324,325,249,-1,246,218,324,-1,218,246,109,-1,189,193,187,-1,193,189,310,-1,212,284,195,-1,284,212,184,-1,30,102,93,-1,98,102,30,-1,184,285,284,-1,285,184,183,-1,280,86,287,-1,86,280,255,-1,295,199,297,-1,295,277,199,-1,290,283,287,-1,282,283,290,-1,202,288,203,-1,14,288,202,-1,297,198,200,-1,297,199,198,-1,287,85,290,-1,85,287,86,-1,278,294,23,-1,278,289,294,-1,286,207,97,-1,207,286,208,-1,194,97,99,-1,97,194,286,-1,121,190,273,-1,190,121,191,-1};
			return value;
		}
		private int[] getrrib7_Geo_6_160_coordIndex_3()
		{
			int[] value = {194,188,187,-1,194,99,188,-1,193,114,117,-1,310,114,193,-1,218,106,220,-1,218,109,106,-1,325,250,249,-1,325,300,250,-1,115,213,116,-1,302,213,115,-1,273,173,121,-1,273,174,173,-1,225,323,226,-1,225,242,323,-1,304,300,325,-1,306,300,304,-1,163,299,165,-1,323,299,163,-1,169,322,305,-1,322,169,166,-1,118,62,128,-1,104,62,118,-1,247,322,320,-1,247,248,322,-1,168,319,166,-1,319,168,321,-1,318,321,236,-1,321,318,319,-1,320,71,247,-1,320,160,71,-1,318,156,160,-1,318,155,156,-1,124,151,125,-1,266,151,124,-1,147,142,141,-1,147,148,142,-1,139,149,152,-1,139,140,149,-1,146,230,148,-1,146,269,230,-1,142,137,144,-1,142,135,137,-1,267,133,139,-1,267,74,133,-1,140,131,270,-1,140,129,131,-1,134,129,133,-1,134,132,129,-1,317,268,292,-1,268,317,231,-1,75,51,50,-1,51,75,73,-1,49,233,47,-1,49,234,233,-1,164,162,161,-1,164,265,162,-1,304,324,307,-1,325,324,304,-1,264,296,260,-1,296,264,78,-1,181,312,20,-1,181,182,312,-1,315,180,19,-1,179,180,315,-1,176,316,314,-1,176,178,316,-1,172,19,18,-1,172,315,19,-1,314,175,216,-1,175,314,316,-1,170,313,26,-1,170,312,313,-1,212,116,113,-1,212,117,116,-1,113,184,212,-1,184,113,110,-1,309,241,308,-1,224,241,309,-1,310,309,114,-1,310,243,309,-1,302,308,303,-1,302,115,308,-1,246,274,109,-1,246,192,274,-1,217,221,167,-1,217,219,221,-1,307,305,304,-1,307,169,305,-1,220,301,219,-1,303,301,220,-1,311,300,306,-1,311,245,300,-1,299,306,298,-1,306,299,311,-1,256,210,209,-1,257,210,256,-1,31,93,27,-1,30,93,31,-1,261,297,296,-1,295,297,261,-1,291,277,295,-1,291,22,277,-1,203,281,204,-1,288,281,203,-1,205,264,252,-1,264,205,83,-1,77,82,81,-1,77,76,82,-1,151,229,153,-1,154,229,151,-1,49,73,234,-1,49,51,73,-1,50,134,75,-1,50,57,134,-1,159,146,145,-1,146,159,228,-1,40,46,60,-1,43,46,40,-1,34,52,35,-1,34,53,52,-1,48,35,52,-1,35,48,271,-1,293,48,44,-1,271,48,293,-1,43,44,46,-1,293,44,43,-1,43,37,293,-1,43,42,37,-1,274,33,32,-1,192,33,274,-1,198,24,92,-1,198,25,24,-1,23,215,21,-1,23,294,215,-1,20,215,18,-1,20,276,215,-1,85,291,262,-1,85,87,291,-1,81,282,290,-1,81,79,282,-1,257,101,210,-1,257,4,101,-1,88,14,13,-1,288,14,88,-1,90,258,259,-1,90,7,258,-1,195,286,194,-1,195,284,286,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib7_Coord_7_160_point_1()
		{
			double[] value = {-.60937,47.44844,-2.63702,-.55324,47.26435,-2.55154,-.5702,47.32139,-2.52513,-.60589,47.40953,-2.66252,-.76574,47.64187,-2.92587,-.71744,47.6277,-2.85265,-.71174,47.70467,-2.92454,-.69086,47.70772,-2.91029,-.69069,47.65288,-2.83038,-.48345,47.35678,-2.74505,-.485,47.31284,-2.74649,-.48523,47.37955,-2.78434,-.54066,47.1823,-2.58606,-.53018,47.17677,-2.58716,-.54369,47.26649,-2.55118,-.64538,47.57491,-2.74487,-.63866,47.6225,-2.72501,-.63484,47.53949,-2.60917,-1.14388,47.34754,-3.49725,-1.13843,47.36814,-3.50422,-1.09227,47.39587,-3.43329,-.92294,47.35963,-3.18643,-.77632,47.33634,-3.0185,-.93476,47.36773,-3.18325,-.97513,47.61831,-3.3358,-.97456,47.60086,-3.33475,-1.03219,47.58915,-3.44619,-1.15937,47.71959,-3.44838,-1.13714,47.67189,-3.50422,-.98766,47.66725,-3.31028,-1.28362,47.71245,-3.44751,-1.25881,47.69606,-3.51997,-1.41375,47.61909,-3.62808,-1.44767,47.68406,-3.57335,-3.28205,43.4945,2.4071,-3.2932,43.5047,2.44197,-3.3345,43.45606,2.39694,-3.4007,43.29541,2.3177,-3.39103,43.24819,2.2586,-3.31058,43.42195,2.36401,-3.43476,43.21389,2.25108,-3.4462,43.22206,2.20526,-3.43025,43.23258,2.26669,-3.41387,43.23767,2.32955,-3.35397,43.30141,2.45525,-3.40994,43.20197,2.39662,-3.39394,43.20798,2.3932,-3.36945,43.31462,2.48814,-3.29404,43.44931,2.51911,-3.30718,43.46766,2.53993,-3.2159,43.50158,2.42911,-3.25095,43.53396,2.50478,-3.24647,43.50576,2.4917,-3.23267,43.48575,2.43534,-3.27523,43.39637,2.36869,-3.37078,43.18903,2.22854,-3.37209,43.18733,2.19805,-3.27474,43.38523,2.32297,-3.42022,43.17091,2.21558,-3.43707,43.14258,2.19979,-3.42457,43.15805,2.25447,-3.44548,43.1392,2.27508,-4.29044,46.62048,-3.13824,-4.27261,46.64831,-3.0802,-4.76714,46.15734,-2.44201,-4.95266,46.07249,-2.59613,-4.35494,46.5311,-3.29363,-4.90855,46.06336,-2.58589,-4.32888,46.51868,-3.28935,-5.34309,45.95128,-1.47455,-5.25303,45.97926,-1.40776,-5.02432,46.44933,-2.25994,-3.79928,43.97585,1.98958,-3.36626,43.6484,2.41928,-3.78426,43.94633,1.92772,-3.34306,43.62993,2.34393,-.50289,47.26091,-2.78613,-.51635,47.26331,-2.80953,-.51589,47.41205,-2.82275,-.53831,47.19355,-2.67275,-.52655,47.19122,-2.6694,-.55225,47.22207,-2.79013,-.53632,47.2207,-2.76785,-.47986,47.50981,-2.77581,-.48569,47.45828,-2.73876,-.71082,47.41538,-2.89482,-.73375,47.49355,-2.87523,-.73688,47.4195,-2.91833,-.51243,47.203,-2.63055,-.98621,47.71296,-3.23524,-.66877,47.71286,-2.93751,-.98842,47.67984,-3.29644,-.64029,47.65556,-2.97105,-1.17724,47.72547,-3.38606,-1.95164,47.62821,-3.78161,-1.93229,47.71794,-3.65347,-1.48065,47.74749,-3.51936,-1.31497,47.71718,-3.37116,-1.31014,47.72865,-3.38124,-1.50541,47.72234,-3.47445};
			return value;
		}
		private double[] getrrib7_Coord_7_160_point_2()
		{
			double[] value = {-1.22006,47.72084,-3.29794,-1.01663,47.72251,-3.15169,-1.19506,47.73135,-3.32944,-.99843,47.73847,-3.1676,-3.65204,46.99484,-3.59272,-3.64533,47.03085,-3.5298,-2.10397,47.25132,-4.01962,-1.92175,47.46398,-3.93713,-1.92077,47.30268,-3.93847,-2.12735,47.43664,-4.00202,-1.28322,47.38331,-3.52304,-1.37251,47.35108,-3.634,-1.26466,47.37129,-3.55407,-1.41232,47.35859,-3.58874,-2.14518,47.32366,-3.80829,-2.11516,47.31964,-3.90352,-1.92041,47.35173,-3.8354,-1.96057,47.37098,-3.76151,-3.67378,46.99176,-3.69642,-2.89799,47.1933,-3.88455,-2.90704,47.20127,-3.80063,-1.26126,47.38428,-3.57438,-1.17751,47.34489,-3.49545,-5.12507,45.68953,-1.71646,-5.09684,45.84033,-1.53016,-4.95417,45.34794,-.68898,-5.05748,45.15605,-.78969,-3.71667,46.90555,-3.74461,-4.33324,46.59045,-3.23681,-4.00507,43.60574,1.65708,-3.57982,43.2289,2.07115,-4.04404,43.5626,1.6837,-3.55186,43.28047,2.07781,-3.89321,43.80412,1.80006,-3.40906,43.4867,2.21358,-4.81535,44.53129,.87699,-4.01473,43.81678,1.94657,-4.67006,44.66019,1.00015,-3.87678,43.94087,1.99486,-4.66541,44.49654,.78489,-4.75424,44.26275,.57126,-5.27605,45.39115,-.69084,-5.07424,44.96974,.11565,-5.21793,45.52069,-.60428,-4.96584,45.12974,.14993,-5.28481,45.13255,-.8119,-5.08814,44.6951,-.08322,-5.27618,45.26851,-.73838,-5.09948,44.84539,.04228,-4.96505,44.66549,-.15983,-5.12155,45.06613,-.85487,-5.01822,45.50487,-.61994,-4.89393,44.96047,.0252,-4.73683,45.02069,.20921,-5.12766,45.55588,-.59898,-5.27034,45.72969,-1.71561,-5.32182,45.85492,-1.59484,-5.16106,45.62402,-1.80826,-5.15928,45.59483,-1.83707,-5.22318,45.0365,-.86473,-5.07307,46.39031,-2.33496,-4.30828,46.74082,-2.9959,-4.77849,46.29701,-2.32075,-3.65542,47.12537,-3.43943,-4.44168,46.86601,-2.93979,-3.73798,47.29254,-3.38621,-3.80494,47.17239,-3.67154,-3.00044,47.31157,-3.96308,-3.75071,47.0373,-3.74664,-3.01413,47.45449,-3.86931,-1.01119,47.50075,-3.34947,-.9287,47.50334,-3.23266,-1.18757,47.41056,-3.56824,-1.22834,47.40898,-3.56508,-1.24222,47.5134,-3.60022,-1.18527,47.51845,-3.59252,-1.12441,47.54853,-3.54482,-1.13248,47.48968,-3.52093,-1.14723,47.50532,-3.55688,-1.15605,47.45772,-3.54872,-1.13689,47.42788,-3.51813,-1.11236,47.44322,-3.47764,-1.09005,47.49391,-3.47299,-1.19832,47.38943,-3.40281,-1.29593,47.39186,-3.4779,-1.19058,47.37136,-3.43909,-2.21204,47.64024,-3.63375,-1.9327,47.50154,-3.59101,-1.92496,47.66979,-3.61683,-2.18832,47.4773,-3.64014,-1.36594,47.462,-3.67817,-1.36074,47.37031,-3.65697,-1.96676,47.58959,-3.84904,-1.97539,47.40284,-3.70098,-1.49776,47.54102,-3.46451,-1.45984,47.45119,-3.51496,-1.26087,47.61846,-3.59676,-1.38372,47.54624,-3.66637,-.64401,47.63133,-2.97686,-.70907,47.50274,-3.01327};
			return value;
		}
		private double[] getrrib7_Coord_7_160_point_3()
		{
			double[] value = {-.58856,47.63984,-2.91011,-.51045,47.4801,-2.64065,-.559,47.31846,-2.5284,-.51983,47.34126,-2.59368,-.4912,47.38598,-2.66891,-.48988,47.52773,-2.71311,-.6009,47.54192,-2.59878,-1.22977,47.68048,-3.29546,-1.243,47.55224,-3.3235,-1.09222,47.54131,-3.18763,-1.05748,47.63907,-3.17031,-1.18351,47.6564,-3.55223,-1.43029,47.36671,-3.55217,-1.92609,47.29699,-3.92292,-1.0966,47.53256,-3.51455,-1.0772,47.38849,-3.35316,-1.12032,47.62617,-3.54847,-2.66371,47.38097,-4.01617,-2.34639,47.40852,-4.03144,-2.634,47.16441,-4.09689,-2.31212,47.192,-4.07426,-2.94713,47.12809,-4.03912,-3.71901,46.90801,-3.77081,-4.81421,46.0521,-2.49703,-2.61745,47.24691,-3.8164,-2.61989,47.29435,-3.76828,-2.90435,47.23442,-3.72703,-5.22565,45.63954,-1.80747,-5.03537,44.62438,-.16605,-4.90028,45.1465,.13616,-4.85968,44.41301,.76601,-4.08756,43.70334,1.8427,-4.59463,44.66165,.99349,-3.54874,43.46174,2.36679,-3.45923,43.59673,2.42669,-2.93228,47.11209,-4.00745,-4.99527,46.11361,-2.56986,-5.1963,45.59546,-1.85196,-1.09358,47.46797,-3.25201,-1.03284,47.46624,-3.18795,-1.21239,47.58132,-3.5894,-2.61463,47.25818,-3.9165,-2.63521,47.4132,-3.64261,-2.33772,47.33463,-3.77932,-2.35842,47.4648,-3.67534,-2.38203,47.6132,-3.64003,-2.14717,47.57444,-3.90679,-4.51939,46.90351,-2.95211,-3.79837,47.33604,-3.44208,-2.20581,47.6812,-3.73306,-2.21314,47.68078,-3.67226,-.57307,47.63353,-2.73266,-.4993,47.55472,-2.71287,-.54398,47.66478,-2.80075,-.49981,47.25415,-2.70509,-.72427,47.57934,-2.85845,-.81446,47.51184,-2.95982,-.78373,47.59925,-2.93817,-.6386,47.69279,-2.82428,-.59429,47.70752,-2.86566,-.53614,47.61271,-2.85886,-.64494,47.303,-2.91526,-.66578,47.29814,-2.91229,-.52238,47.50815,-2.63726,-.49231,47.54011,-2.80444,-4.90356,46.42993,-2.23833,-5.15085,45.94148,-1.42501,-4.46537,44.58067,1.01446,-4.07212,43.58039,1.72024,-4.84919,44.27721,.64219,-4.80837,44.23241,.57176,-3.32654,43.45997,2.45381,-1.27112,47.565,-3.61281,-1.28269,47.51377,-3.61372,-1.93508,47.50115,-3.90934,-.91642,47.3791,-3.20189,-1.06492,47.41171,-3.36271,-.76038,47.34629,-3.01857,-.95738,47.3815,-3.18393,-.80112,47.43156,-2.99123,-.6558,47.55435,-2.76921,-.49119,47.32041,-2.68784,-.57012,47.27907,-2.68993,-.59508,47.36278,-2.66959,-1.31214,47.4647,-3.44228,-1.21458,47.4532,-3.36563,-1.32517,47.55267,-3.39393,-.65272,47.45405,-2.77788,-.51182,47.28213,-2.6102,-1.08841,47.41218,-3.30002,-.62005,47.36894,-2.78476,-.718,47.31243,-2.96091,-3.57925,43.23186,2.14929,-3.37909,43.31773,2.39587,-1.08533,47.39693,-3.33346,-.70506,47.31843,-2.96818,-.58079,47.48051,-2.88307,-.64302,47.49041,-2.94787,-3.00008,47.56493,-3.63518,-2.97205,47.51818,-3.58605};
			return value;
		}
		private double[] getrrib7_Coord_7_160_point_4()
		{
			double[] value = {-2.3837,47.66209,-3.68474,-2.62278,47.14919,-4.06443,-2.10751,47.24488,-4.00115,-2.31095,47.18531,-4.05538,-2.69082,47.60301,-3.79649,-3.01812,47.5413,-3.77359,-2.69219,47.62106,-3.66041,-2.69017,47.49735,-3.92111,-2.32713,47.28975,-3.9382,-2.33158,47.28759,-3.84062,-2.15364,47.35627,-3.75199,-2.67779,47.57178,-3.61335,-1.05011,47.48946,-3.42159,-1.06472,47.56265,-3.50116,-1.11744,47.58617,-3.55662,-1.17311,47.42317,-3.56284,-1.16433,47.51378,-3.58403,-3.59856,43.33073,2.28581,-5.04288,46.25483,-2.47347,-4.51239,46.78949,-3.12374,-4.55065,46.878,-3.01798,-4.4454,46.64162,-3.23443,-3.83699,47.29021,-3.57049,-2.9118,47.35032,-3.61235,-2.3666,47.55694,-3.92931,-2.37189,47.65972,-3.77733};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib8_Geo_6_165_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,11,12,9,-1,13,14,15,-1,16,17,18,-1,19,20,21,-1,22,23,24,-1,24,6,22,-1,25,26,27,-1,27,28,25,-1,29,30,31,-1,32,33,34,-1,34,33,35,-1,36,37,38,-1,39,40,41,-1,39,42,40,-1,41,40,43,-1,43,44,41,-1,45,46,47,-1,45,48,46,-1,49,50,51,-1,49,52,50,-1,51,53,54,-1,51,50,53,-1,55,21,56,-1,55,57,21,-1,58,14,59,-1,60,7,6,-1,6,24,60,-1,61,36,62,-1,61,63,36,-1,64,65,66,-1,67,4,68,-1,68,69,67,-1,70,46,71,-1,70,72,46,-1,73,74,75,-1,76,77,78,-1,78,79,76,-1,75,80,73,-1,75,81,80,-1,82,83,84,-1,82,85,83,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,93,94,5,-1,93,95,94,-1,96,97,98,-1,96,99,97,-1,100,101,102,-1,100,103,101,-1,104,66,105,-1,105,98,104,-1,49,10,52,-1,10,106,52,-1,100,107,103,-1,107,108,103,-1,108,109,43,-1,110,21,20,-1,110,56,21,-1,111,112,113,-1,111,114,112,-1,115,111,2,-1,115,116,111,-1,117,118,119,-1,117,120,118,-1,121,122,123,-1,121,114,122,-1,33,124,35,-1,33,125,124,-1,61,41,126,-1,61,39,41,-1,127,128,129,-1,127,76,128,-1,130,131,132,-1,130,133,131,-1,134,80,135,-1,80,136,135,-1,56,51,54,-1,54,55,56,-1,36,38,137,-1,137,138,36,-1,79,139,140,-1,79,78,139,-1,86,88,141,-1,142,137,143,-1,142,89,137,-1,144,145,146,-1,146,147,144,-1,102,101,148,-1,149,88,150,-1,150,151,149,-1,152,153,154,-1,154,155,152,-1,156,135,157,-1,156,139,135,-1,158,152,155,-1,155,159,158,-1,158,160,161,-1,158,159,160,-1,162,163,164,-1,163,165,164,-1,166,167,162,-1,162,164,166,-1,168,169,158,-1,169,152,158,-1,161,170,168,-1,168,158,161,-1,3,5,92,-1,92,171,3,-1,95,172,173,-1,174,175,176,-1,176,177,174,-1,178,179,97,-1,178,177,179,-1,180,181,182,-1,180,183,181,-1,184,185,186,-1,185,187,186,-1,29,187,188,-1,29,186,187,-1,188,152,169,-1,188,153,152,-1,146,145,30,-1,145,31,30,-1,188,169,29,-1,169,30,29,-1,189,153,187,-1,153,188,187,-1,187,190,189,-1,187,185,190,-1,191,190,185,-1,191,192,190,-1,182,191,193,-1,182,181,191,-1,96,48,99,-1,194,64,195,-1,194,173,64,-1,68,196,197,-1,198,199,200,-1,200,107,198,-1,189,190,201,-1,190,26,201,-1,202,168,170,-1,202,203,168,-1,204,205,206,-1,207,208,209,-1,207,210,208,-1,162,206,163,-1,162,211,206,-1,212,136,213,-1,213,214,212,-1,159,212,160,-1,159,157,212,-1,153,189,201,-1,157,159,155,-1,155,156,157,-1,42,215,101,-1,146,216,147,-1,216,217,147,-1,218,145,144,-1,218,219,145,-1,217,220,147,-1,217,221,220,-1,82,84,222,-1,223,129,224,-1,129,128,224,-1,15,225,63,-1,63,226,15,-1,227,7,228,-1,19,57,143,-1,19,21,57,-1,51,56,110,-1,110,49,51,-1,80,81,136,-1,81,213,136,-1,217,73,221,-1,217,74,73,-1,126,44,16,-1,126,41,44,-1,229,230,124,-1,124,125,229,-1,231,232,131,-1,114,121,112,-1,121,132,112,-1,233,234,232,-1,232,231,233,-1,113,112,232,-1,232,234,113,-1,202,208,235,-1,202,209,208,-1,145,236,31,-1,145,219,236,-1,103,108,40,-1,108,43,40,-1,11,10,49,-1,49,237,11,-1,104,179,195,-1,35,90,34,-1,35,91,90,-1,200,105,238,-1,200,199,105,-1,239,230,229,-1,5,94,90,-1,90,92,5,-1,240,140,156,-1,140,139,156,-1,55,85,82,-1,55,54,85,-1,78,77,221,-1,221,134,78,-1,241,81,75,-1,241,242,81,-1,76,243,128,-1,76,79,243,-1,77,220,221,-1,244,72,70,-1,244,245,72,-1,48,71,46,-1,48,198,71,-1,95,93,172,-1,197,109,200,-1,200,238,197,-1,197,23,43,-1,43,109,197,-1,82,57,55,-1,82,222,57,-1,54,246,85,-1,54,53,246,-1,87,89,224,-1,180,182,247,-1,58,248,249,-1,58,59,248,-1,250,251,62,-1,251,215,62,-1,39,61,62,-1,16,22,17,-1,16,44,22,-1,11,60,12,-1,194,195,176,-1,236,29,31,-1,236,186,29,-1,252,88,149,-1,252,141,88,-1,8,22,6,-1,8,17,22,-1,24,23,196,-1};
			return value;
		}
		private int[] getrrib8_Geo_6_165_coordIndex_2()
		{
			int[] value = {23,197,196,-1,8,7,227,-1,249,137,38,-1,225,15,14,-1,215,251,148,-1,148,101,215,-1,48,253,99,-1,48,45,253,-1,84,142,222,-1,84,223,142,-1,1,254,2,-1,254,115,2,-1,205,163,206,-1,205,255,163,-1,213,256,214,-1,213,257,256,-1,254,258,115,-1,258,254,117,-1,99,178,97,-1,99,253,178,-1,249,37,58,-1,37,249,38,-1,227,259,8,-1,260,259,227,-1,65,69,66,-1,69,65,67,-1,194,175,261,-1,175,194,176,-1,12,262,9,-1,171,262,12,-1,251,141,252,-1,141,251,250,-1,228,60,11,-1,228,7,60,-1,263,237,264,-1,263,265,237,-1,59,264,248,-1,59,263,264,-1,263,14,13,-1,14,263,59,-1,266,247,267,-1,266,180,247,-1,245,183,72,-1,245,181,183,-1,85,268,83,-1,85,246,268,-1,69,197,238,-1,69,68,197,-1,68,3,196,-1,68,4,3,-1,224,243,87,-1,224,128,243,-1,241,123,242,-1,130,123,241,-1,121,130,132,-1,123,130,121,-1,243,140,150,-1,243,79,140,-1,96,198,48,-1,199,198,96,-1,239,269,270,-1,269,239,229,-1,171,91,262,-1,92,91,171,-1,98,179,104,-1,97,179,98,-1,47,271,45,-1,266,271,47,-1,246,184,268,-1,246,193,184,-1,203,146,30,-1,203,216,146,-1,120,231,272,-1,233,231,120,-1,273,274,167,-1,118,274,273,-1,275,276,166,-1,276,275,116,-1,111,275,114,-1,111,116,275,-1,234,0,113,-1,0,234,1,-1,276,277,273,-1,277,276,258,-1,131,112,132,-1,131,232,112,-1,106,239,278,-1,106,230,239,-1,250,36,138,-1,250,62,36,-1,34,94,32,-1,90,94,34,-1,133,241,210,-1,133,130,241,-1,235,217,216,-1,217,235,74,-1,81,257,213,-1,242,257,81,-1,9,124,230,-1,9,262,124,-1,264,49,110,-1,264,237,49,-1,110,248,264,-1,248,110,20,-1,265,13,260,-1,265,263,13,-1,15,260,13,-1,15,259,260,-1,126,18,226,-1,126,16,18,-1,76,220,77,-1,127,220,76,-1,142,224,89,-1,223,224,142,-1,223,218,129,-1,223,84,218,-1,147,127,144,-1,220,127,147,-1,84,219,218,-1,84,83,219,-1,18,8,259,-1,17,8,18,-1,103,42,101,-1,103,40,42,-1,153,279,154,-1,153,201,279,-1,135,212,157,-1,135,136,212,-1,212,280,160,-1,212,214,280,-1,165,214,256,-1,165,280,214,-1,256,164,165,-1,164,256,281,-1,282,272,231,-1,272,282,283,-1,211,204,206,-1,204,211,283,-1,282,210,207,-1,282,133,210,-1,204,209,205,-1,204,207,209,-1,255,170,161,-1,205,170,255,-1,201,25,279,-1,26,25,201,-1,149,28,252,-1,28,149,25,-1,244,28,27,-1,244,148,28,-1,71,102,70,-1,100,102,71,-1,173,261,95,-1,261,173,194,-1,195,66,104,-1,195,64,66,-1,174,229,125,-1,229,174,269,-1,45,270,253,-1,271,270,45,-1,267,50,52,-1,247,50,267,-1,181,192,191,-1,192,181,245,-1,247,53,50,-1,53,247,182,-1,184,191,185,-1,184,193,191,-1,30,168,203,-1,169,168,30,-1,268,186,236,-1,268,184,186,-1,192,244,27,-1,245,244,192,-1,183,266,47,-1,180,266,183,-1,270,278,239,-1,278,270,271,-1,174,178,269,-1,174,177,178,-1,125,175,174,-1,125,33,175,-1,179,176,195,-1,177,176,179,-1,95,32,94,-1,32,95,261,-1,148,70,102,-1,148,244,70,-1,190,27,26,-1,27,190,192,-1,216,202,235,-1,216,203,202,-1,205,202,170,-1,205,209,202,-1,283,207,204,-1,207,283,282,-1,283,274,272,-1,211,274,283,-1,211,167,274,-1,211,162,167,-1,166,281,275,-1,281,166,164,-1,163,280,165,-1,255,280,163,-1,255,160,280,-1,255,161,160,-1,151,154,279,-1,151,240,154,-1,155,240,156,-1,155,154,240,-1,150,240,151,-1,150,140,240,-1,148,252,28,-1,148,251,252,-1,108,200,109,-1,200,108,107,-1,144,129,218,-1,127,129,144,-1,57,142,143,-1,142,57,222,-1,86,137,89,-1,86,138,137,-1,150,87,243,-1,150,88,87,-1,135,78,134,-1,78,135,139,-1,226,61,126,-1,226,63,61,-1,19,137,249,-1,19,143,137,-1,230,10,9,-1,230,106,10,-1,35,262,91,-1,262,35,124,-1,242,122,257,-1,123,122,242,-1,75,210,241,-1,208,210,75,-1,74,208,75,-1,208,74,235,-1,141,138,86,-1,141,250,138,-1,275,122,114,-1,281,122,275,-1,131,282,231,-1,282,131,133,-1,117,233,120,-1,254,233,117,-1,273,119,118,-1,119,273,277,-1};
			return value;
		}
		private int[] getrrib8_Geo_6_165_coordIndex_3()
		{
			int[] value = {116,258,276,-1,258,116,115,-1,0,111,113,-1,2,111,0,-1,233,1,234,-1,1,233,254,-1,166,273,167,-1,273,166,276,-1,118,272,274,-1,120,272,118,-1,193,53,182,-1,193,246,53,-1,93,4,67,-1,4,93,5,-1,100,198,107,-1,71,198,100,-1,278,52,106,-1,52,278,267,-1,171,196,3,-1,196,171,12,-1,269,253,270,-1,178,253,269,-1,199,98,105,-1,98,199,96,-1,279,149,151,-1,25,149,279,-1,257,281,256,-1,122,281,257,-1,134,73,80,-1,73,134,221,-1,238,66,69,-1,238,105,66,-1,65,173,172,-1,64,173,65,-1,260,228,265,-1,227,228,260,-1,225,36,63,-1,37,36,225,-1,83,236,219,-1,83,268,236,-1,72,47,46,-1,47,72,183,-1,271,267,278,-1,271,266,267,-1,12,24,196,-1,12,60,24,-1,62,42,39,-1,62,215,42,-1,265,11,237,-1,265,228,11,-1,23,44,43,-1,23,22,44,-1,33,261,175,-1,33,32,261,-1,172,67,65,-1,67,172,93,-1,20,249,248,-1,20,19,249,-1,259,226,18,-1,259,15,226,-1,14,37,225,-1,14,58,37,-1,117,277,258,-1,117,119,277,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib8_Coord_7_165_point_1()
		{
			double[] value = {-3.82985,42.55768,1.99552,-3.79303,42.59926,2.00588,-3.85656,42.58231,2.02501,-.60719,46.42036,-2.95549,-.5746,46.48922,-2.9878,-.54175,46.42288,-2.87061,-.97783,46.34667,-3.23467,-.9868,46.31514,-3.19844,-1.01387,46.32745,-3.27823,-.96193,46.23783,-3.07796,-1.11406,46.23786,-3.14749,-1.11415,46.23462,-3.17967,-.88776,46.34773,-3.09623,-1.21649,46.26353,-3.38138,-1.27757,46.26115,-3.45901,-1.17379,46.30811,-3.42391,-1.04446,46.47781,-3.41633,-1.01551,46.43354,-3.3594,-1.06011,46.42718,-3.38224,-1.42501,46.23327,-3.4493,-1.37824,46.22561,-3.37287,-1.43518,46.27096,-3.39668,-.97278,46.47231,-3.3429,-.97525,46.49515,-3.3334,-.97239,46.36322,-3.21738,-3.0402,46.35154,-3.87806,-3.03013,46.48633,-3.7763,-2.32891,46.6902,-3.76607,-2.25809,46.54464,-3.84376,-4.38986,45.45941,-2.83942,-4.97198,44.83366,-1.73215,-4.38156,45.3688,-2.87463,-.62716,46.381,-2.6004,-.71301,46.39732,-2.79605,-.64106,46.27585,-2.61538,-.73459,46.19424,-2.75563,-1.3854,46.38715,-3.64171,-1.35493,46.29823,-3.54847,-1.39011,46.29582,-3.55714,-1.2338,46.5855,-3.62699,-1.14256,46.61018,-3.53095,-1.12262,46.58818,-3.52093,-1.26846,46.60287,-3.61973,-1.02667,46.56693,-3.40611,-1.02328,46.5468,-3.40749,-1.22633,46.76301,-3.29995,-1.36187,46.84904,-3.43003,-1.36283,46.73386,-3.37873,-1.23086,46.86953,-3.37807,-1.25077,46.23054,-3.23877,-1.49239,46.29423,-3.30796,-1.47101,46.26637,-3.32834,-1.30836,46.26794,-3.21065,-1.85483,46.34552,-3.47026,-1.83972,46.30376,-3.48868,-1.7756,46.28905,-3.55319,-1.4461,46.27593,-3.37152,-1.75631,46.26407,-3.57406,-1.34629,46.25255,-3.503,-1.29442,46.25204,-3.42408,-.9805,46.31429,-3.17811,-1.20897,46.50449,-3.63243,-1.41052,46.52268,-3.70491,-1.20242,46.3959,-3.54178,-.67924,46.86646,-2.95663,-.58598,46.78514,-3.03931,-.75799,46.90401,-3.17885,-.54942,46.64329,-3.01278,-.73985,46.55434,-3.17373,-.75167,46.71789,-3.18682,-1.48749,46.82702,-3.5373,-1.3267,46.84814,-3.48322,-1.50709,46.81899,-3.48785,-5.07602,43.62691,-.1923,-5.05465,43.62637,-.11037,-4.89594,43.26726,.51286,-4.4002,45.08954,-3.01189,-4.90854,44.44906,-1.85532,-4.93787,44.4783,-1.85106,-4.40805,45.13265,-3.03114,-5.13471,43.59574,-.11349,-4.94784,43.2711,.54371,-2.20326,46.19619,-3.68996,-2.93774,46.0703,-3.75313,-2.93216,45.98486,-3.79646,-2.22759,46.25031,-3.6266,-2.15009,46.25965,-3.83672,-2.91701,45.82895,-3.87841,-2.95221,46.07048,-3.92908,-2.17251,46.11132,-3.77712,-.59121,46.25547,-2.63389,-.67685,46.15971,-2.84307,-.61236,46.276,-2.85828,-.52324,46.57292,-2.8801,-.57614,46.34562,-2.61888,-.58053,46.54256,-2.64681,-1.08985,46.89444,-3.32032,-.94986,46.83044,-3.20711,-.93517,46.89492,-3.25133,-1.089,46.83626,-3.29038};
			return value;
		}
		private double[] getrrib8_Coord_7_165_point_2()
		{
			double[] value = {-1.28218,46.75351,-3.52321,-1.35409,46.63059,-3.59754,-1.41451,46.69935,-3.59367,-1.22038,46.64932,-3.51109,-.80805,46.9138,-3.15833,-.90012,46.89407,-3.27296,-1.13279,46.25415,-3.10924,-1.1344,46.76705,-3.43319,-1.09577,46.64646,-3.41303,-1.00222,46.62224,-3.37203,-1.33468,46.22857,-3.31058,-3.90293,42.52148,2.01458,-3.87355,42.47927,1.94603,-3.85369,42.49277,1.97784,-3.94663,42.52508,1.97545,-3.82725,42.69685,2.09314,-3.85803,42.66365,2.12206,-3.73328,42.74844,2.07065,-3.65121,42.82641,2.09974,-3.7109,42.79569,2.09951,-3.65703,42.74619,2.05647,-3.97351,42.49832,1.91619,-4.17061,42.73201,1.72632,-4.16686,42.64206,1.64228,-.80471,46.1861,-2.86679,-.83489,46.39607,-2.93678,-1.10922,46.50429,-3.51779,-4.38778,45.08139,-2.97979,-3.64883,45.49241,-3.64871,-3.63759,45.49155,-3.61088,-4.14338,42.63685,1.60513,-3.81209,42.55619,1.89092,-3.93199,42.48414,1.87524,-4.06925,42.73884,1.633,-5.15021,43.86605,-.73148,-5.2128,44.00064,-.7091,-5.17247,43.70008,.03291,-1.70431,46.22314,-3.64763,-1.68944,46.32535,-3.70683,-4.99451,44.57015,-1.81357,-4.46567,45.21766,-3.03285,-2.13294,46.34364,-3.87776,-2.18801,46.10466,-3.73017,-1.73386,46.20263,-3.59501,-4.38162,45.18,-2.95901,-4.35808,45.27232,-2.90581,-4.88555,44.60557,-1.77568,-4.8919,44.5485,-1.78736,-1.80346,46.60915,-3.73309,-3.02092,46.23702,-3.91811,-3.67218,45.71367,-3.73034,-3.6938,45.92431,-3.67934,-5.06652,45.06101,-1.75943,-4.52761,45.67098,-2.86788,-4.55984,45.58807,-2.91009,-5.10031,44.90014,-1.72113,-5.07261,44.74468,-1.7637,-5.25565,44.18418,-.64261,-5.23698,44.43803,-.53595,-5.23971,44.3722,-.54263,-5.14834,44.03204,.11654,-5.09411,44.10753,.15169,-3.94416,43.07038,1.85517,-4.44212,43.45853,1.29616,-4.03041,43.00238,1.85202,-4.49033,43.35893,1.29273,-3.8131,42.82143,2.16411,-3.73098,42.88233,2.13445,-5.20573,44.43655,-.52128,-5.04377,45.04242,-1.70021,-5.07983,44.10172,.13952,-.69091,46.28912,-2.93685,-.55151,46.65535,-2.85132,-.64209,46.74108,-2.77524,-.88053,46.61626,-2.98419,-.74744,46.57413,-2.81704,-.76402,46.73101,-2.87583,-.8533,46.73925,-3.03919,-.97458,46.75898,-3.13717,-.83354,46.8353,-3.10454,-1.53086,46.6101,-3.39964,-1.87365,46.67816,-3.57677,-1.87475,46.56554,-3.53749,-1.51186,46.71298,-3.44895,-2.97346,46.29178,-3.71898,-3.03176,46.4214,-3.71924,-3.59721,45.95682,-3.54621,-3.67683,46.1408,-3.49387,-4.48798,45.67771,-2.83563,-3.69608,46.18049,-3.51903,-3.01731,46.48274,-3.72042,-2.3297,46.63322,-3.68313,-2.3147,46.68382,-3.70239,-2.28699,46.49414,-3.66521,-.70727,46.74752,-2.7392,-.72295,46.86315,-2.94374,-.82649,46.42129,-3.11514,-.92037,46.54607,-3.28518,-1.18748,46.86112,-3.41485,-1.05443,46.88671,-3.35987};
			return value;
		}
		private double[] getrrib8_Coord_7_165_point_3()
		{
			double[] value = {-1.0171,46.76438,-3.36674,-3.70638,46.16049,-3.56019,-5.09792,43.90807,.03194,-5.14022,44.22614,-.6228,-4.42535,43.36133,1.16978,-4.79389,43.78241,.70323,-4.39715,43.4605,1.24638,-4.4514,43.22662,1.12721,-4.85742,43.35103,.52861,-4.82319,43.57546,.60501,-4.52598,43.06898,1.08956,-3.90768,43.06906,1.77919,-5.18644,43.86237,.07762,-4.97256,43.39039,.61562,-4.90866,43.56275,.69468,-1.42442,46.56691,-3.69821,-5.05801,44.01713,-.68746,-5.07343,43.95962,-.70652,-3.6119,45.63604,-3.60859,-3.60258,45.72058,-3.57185,-4.87712,44.44927,-1.82441,-5.08123,43.87304,-.7445,-2.19659,46.16189,-3.70705,-2.91313,45.7933,-3.81569,-2.91385,45.79008,-3.85222,-1.24714,46.3132,-3.489,-1.12741,46.4089,-3.45193,-1.07872,46.27104,-3.23912,-1.11114,46.24178,-3.2022,-1.014,46.42409,-3.04507,-1.01235,46.25105,-3.0442,-3.71645,42.63682,1.95502,-3.78025,42.52841,1.94599,-3.69795,42.63563,2.00429,-3.787,42.54467,1.98123,-5.03452,43.66513,-.06989,-3.59206,45.78163,-3.54959,-1.21052,46.23953,-3.2615,-.89793,46.76325,-3.2679,-1.08029,46.43411,-3.09079,-4.50203,45.39026,-3.00014,-4.5435,42.92135,1.1186,-4.57434,42.93609,1.15557,-3.67153,45.5278,-3.66654,-1.85363,46.77794,-3.66878,-1.8728,46.75716,-3.60429,-2.24404,46.30369,-3.61315,-1.52504,46.4946,-3.35501,-1.3309,46.24229,-3.40855,-1.39642,46.25212,-3.51598,-1.6915,46.43923,-3.76198,-1.70348,46.48551,-3.76427,-2.14761,46.38872,-3.88418,-1.10364,46.77633,-3.22982,-3.75491,42.67597,2.03103,-4.80804,43.78503,.74885,-4.54942,43.20431,1.26445,-4.58655,43.06875,1.22237,-3.7924,42.77094,2.13289,-1.09993,46.31577,-3.33363,-1.1405,46.27083,-3.29804,-.64038,46.56056,-2.61613,-.75255,46.1634,-2.92684,-1.25047,46.24959,-3.35029,-1.27807,46.24051,-3.33922,-1.18545,46.24864,-3.27737,-1.38025,46.62154,-3.31724,-1.35069,46.48434,-3.26787,-2.94755,46.12497,-3.73105,-1.0083,46.63721,-3.08735,-1.12604,46.63314,-3.1632,-1.24303,46.63276,-3.23596,-3.66615,42.76371,2.01281,-3.70911,42.83827,2.16042,-3.66277,42.86414,2.06132,-3.89388,42.67878,2.10049,-3.785,42.79044,2.18345,-3.74873,42.80432,2.13509,-1.19298,46.46084,-3.1635,-3.71968,46.07678,-3.62704,-4.87809,43.6722,.7133,-4.12675,42.86392,1.80565,-3.9779,42.86444,1.67362,-3.93853,42.9712,1.71427};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib9_Geo_6_170_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,4,6,5,-1,7,8,9,-1,9,10,7,-1,11,12,13,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,21,23,22,-1,24,25,26,-1,24,27,25,-1,28,29,30,-1,30,31,28,-1,32,33,34,-1,33,35,34,-1,36,37,38,-1,37,39,38,-1,40,41,42,-1,43,44,45,-1,46,47,48,-1,49,50,51,-1,50,52,51,-1,53,54,55,-1,55,56,53,-1,57,46,48,-1,1,58,2,-1,59,54,60,-1,59,55,54,-1,61,62,63,-1,62,64,63,-1,55,65,66,-1,9,67,10,-1,9,68,67,-1,69,70,71,-1,70,72,71,-1,73,74,8,-1,73,75,74,-1,76,16,77,-1,77,78,76,-1,79,80,81,-1,79,82,80,-1,11,83,12,-1,83,84,12,-1,85,86,87,-1,86,4,87,-1,88,89,90,-1,81,80,91,-1,92,93,74,-1,74,94,92,-1,95,96,97,-1,96,75,97,-1,98,99,100,-1,98,101,99,-1,98,102,101,-1,98,103,102,-1,104,105,106,-1,107,108,109,-1,109,25,107,-1,110,1,111,-1,1,112,111,-1,113,114,115,-1,114,116,115,-1,117,118,18,-1,18,119,117,-1,119,120,121,-1,119,122,120,-1,123,124,125,-1,125,126,123,-1,125,124,127,-1,124,128,127,-1,129,130,131,-1,131,132,129,-1,133,134,135,-1,135,136,133,-1,131,137,138,-1,139,137,140,-1,128,137,127,-1,137,131,130,-1,141,93,92,-1,92,142,141,-1,143,144,145,-1,144,28,145,-1,146,147,148,-1,147,149,148,-1,150,151,152,-1,151,153,152,-1,154,155,40,-1,155,41,40,-1,156,157,158,-1,157,159,158,-1,160,149,161,-1,149,147,161,-1,162,163,164,-1,162,165,163,-1,166,167,168,-1,167,169,168,-1,170,171,172,-1,171,173,172,-1,174,175,176,-1,175,177,176,-1,95,178,96,-1,95,179,178,-1,180,158,181,-1,158,182,181,-1,137,128,136,-1,183,184,185,-1,184,174,185,-1,186,167,126,-1,167,187,126,-1,188,114,113,-1,113,189,188,-1,23,172,173,-1,190,191,192,-1,191,193,192,-1,41,152,194,-1,152,195,194,-1,196,37,197,-1,37,198,197,-1,199,183,185,-1,199,200,183,-1,37,36,198,-1,36,201,198,-1,199,202,203,-1,199,204,202,-1,205,206,207,-1,208,209,210,-1,209,211,210,-1,212,213,214,-1,214,24,212,-1,215,211,216,-1,216,217,215,-1,179,218,219,-1,218,217,219,-1,71,72,97,-1,73,69,71,-1,73,220,69,-1,105,27,221,-1,221,106,105,-1,10,222,7,-1,10,223,222,-1,91,80,77,-1,77,224,91,-1,225,108,226,-1,226,44,225,-1,84,100,227,-1,100,99,227,-1,74,9,8,-1,92,228,142,-1,229,230,90,-1,90,89,229,-1,231,164,157,-1,157,58,231,-1,59,65,55,-1,232,6,233,-1,233,51,232,-1,234,235,53,-1,53,5,234,-1,236,3,56,-1,66,46,57,-1,66,65,46,-1,48,47,61,-1,61,237,48,-1,62,47,238,-1,62,61,47,-1,87,3,236,-1,87,4,3,-1,53,56,3,-1,3,5,53,-1,230,65,68,-1,65,59,68,-1,239,88,90,-1,9,240,230,-1,230,68,9,-1,89,228,241,-1,162,98,100,-1,162,164,98,-1,242,44,243,-1,242,225,44,-1,78,82,7,-1,82,220,7,-1,222,76,78,-1,78,7,222,-1,244,245,246,-1,244,69,245,-1,220,245,69,-1,24,214,221,-1,221,27,24,-1,218,247,217,-1,247,215,217,-1,211,209,248,-1,248,216,211,-1,210,36,208,-1,210,201,36,-1,249,250,251,-1,198,204,252,-1,252,197,198,-1,200,253,183,-1,254,192,144,-1,192,160,144,-1,116,255,168,-1,256,115,257,-1,115,169,257,-1,119,18,122,-1,18,189,122,-1,258,21,33,-1,21,259,33,-1,260,109,108,-1,108,225,260,-1,60,261,67,-1,262,173,171,-1,262,255,173,-1,46,65,230,-1,230,229,46,-1,95,263,179,-1,263,218,179,-1,264,247,250,-1,247,251,250,-1,203,265,200,-1,200,199,203,-1,176,252,174,-1,252,185,174,-1,262,166,255,-1,166,168,255,-1,154,266,267,-1,154,40,266,-1,268,269,270,-1,221,214,244,-1,214,271,244,-1,213,267,272,-1,267,266,272,-1,152,41,150,-1,41,155,150,-1,136,135,137,-1,139,127,137,-1,130,140,137,-1,273,138,137,-1,137,135,273,-1,120,131,138,-1,120,132,131,-1,129,140,130,-1,129,274,140,-1,125,127,139,-1,139,275,125,-1,256,274,129,-1,256,257,274,-1,123,276,124,-1,276,133,124,-1,119,121,134,-1,134,117,119,-1};
			return value;
		}
		private int[] getrrib9_Geo_6_170_coordIndex_2()
		{
			int[] value = {277,113,256,-1,113,115,256,-1,118,145,19,-1,19,18,118,-1,22,255,116,-1,116,114,22,-1,107,27,278,-1,107,25,27,-1,108,102,103,-1,108,107,102,-1,103,226,108,-1,111,226,110,-1,226,103,110,-1,209,208,279,-1,208,280,279,-1,83,165,162,-1,162,84,83,-1,84,162,100,-1,96,94,75,-1,94,74,75,-1,163,281,282,-1,282,159,163,-1,268,270,234,-1,270,235,234,-1,82,78,80,-1,78,77,80,-1,283,14,16,-1,16,76,283,-1,284,285,286,-1,68,60,67,-1,68,59,60,-1,237,61,63,-1,63,287,237,-1,43,45,64,-1,64,62,43,-1,0,2,288,-1,288,50,0,-1,1,110,231,-1,231,58,1,-1,289,290,206,-1,266,40,205,-1,40,42,205,-1,37,196,39,-1,196,291,39,-1,24,26,279,-1,279,212,24,-1,161,29,28,-1,292,17,31,-1,17,19,31,-1,278,27,105,-1,293,286,285,-1,285,294,293,-1,14,13,15,-1,14,11,13,-1,164,231,98,-1,52,295,296,-1,51,296,232,-1,51,52,296,-1,91,294,285,-1,224,294,91,-1,30,292,31,-1,259,292,30,-1,30,297,35,-1,30,29,297,-1,279,298,212,-1,298,279,280,-1,299,39,300,-1,38,39,299,-1,301,302,303,-1,291,302,301,-1,291,304,302,-1,196,304,291,-1,249,206,250,-1,207,206,249,-1,272,205,207,-1,272,266,205,-1,194,290,289,-1,194,253,290,-1,287,86,237,-1,287,233,86,-1,57,236,66,-1,57,87,236,-1,181,53,235,-1,53,181,54,-1,305,295,288,-1,305,269,295,-1,156,288,2,-1,156,305,288,-1,182,261,60,-1,182,282,261,-1,227,286,293,-1,104,286,227,-1,101,105,99,-1,278,105,101,-1,83,14,283,-1,83,11,14,-1,306,286,104,-1,306,284,286,-1,93,9,74,-1,240,9,93,-1,159,182,158,-1,159,282,182,-1,307,76,222,-1,307,283,76,-1,248,279,26,-1,279,248,209,-1,0,49,308,-1,49,0,50,-1,104,246,306,-1,106,246,104,-1,29,147,297,-1,161,147,29,-1,19,28,31,-1,145,28,19,-1,117,133,276,-1,134,133,117,-1,186,274,257,-1,275,274,186,-1,129,277,256,-1,277,129,132,-1,275,140,274,-1,275,139,140,-1,120,273,121,-1,120,138,273,-1,276,118,117,-1,276,309,118,-1,214,272,271,-1,272,214,213,-1,106,244,246,-1,106,221,244,-1,252,199,185,-1,199,252,204,-1,203,250,265,-1,250,203,264,-1,251,218,263,-1,251,247,218,-1,310,96,178,-1,310,94,96,-1,228,94,310,-1,94,228,92,-1,277,189,113,-1,122,189,277,-1,123,309,276,-1,123,311,309,-1,167,312,187,-1,167,166,312,-1,143,311,313,-1,311,143,309,-1,114,20,22,-1,188,20,114,-1,314,166,262,-1,166,314,312,-1,313,144,143,-1,313,254,144,-1,255,23,173,-1,255,22,23,-1,314,192,254,-1,314,190,192,-1,148,193,315,-1,193,148,149,-1,258,32,316,-1,33,32,258,-1,317,170,175,-1,317,191,170,-1,318,151,303,-1,151,318,146,-1,177,319,176,-1,316,319,177,-1,320,317,184,-1,320,315,317,-1,152,320,195,-1,320,152,153,-1,196,319,304,-1,196,197,319,-1,195,184,183,-1,320,184,195,-1,194,42,41,-1,194,289,42,-1,206,42,289,-1,205,42,206,-1,264,215,247,-1,264,321,215,-1,321,201,210,-1,321,202,201,-1,280,36,38,-1,280,208,36,-1,271,207,70,-1,272,207,271,-1,248,260,216,-1,260,248,109,-1,242,179,219,-1,178,179,242,-1,306,245,79,-1,306,246,245,-1,283,165,83,-1,283,307,165,-1,243,178,242,-1,310,178,243,-1,226,45,44,-1,226,111,45,-1,141,240,93,-1,239,240,141,-1,239,230,240,-1,230,239,90,-1,62,241,43,-1,238,241,62,-1,67,223,10,-1,67,261,223,-1,238,46,229,-1,47,46,238,-1,63,112,308,-1,112,63,64,-1,63,49,287,-1,308,49,63,-1,232,268,234,-1,268,232,296,-1,269,296,295,-1,268,296,269,-1,2,157,156,-1,2,58,157,-1,64,111,112,-1,64,45,111,-1,238,89,241,-1,229,89,238,-1,141,88,239,-1,141,142,88,-1,243,43,241,-1,44,43,243,-1,110,98,231,-1,110,103,98,-1,8,220,73,-1,8,7,220,-1,163,307,281,-1,307,163,165,-1,294,12,293,-1,12,294,13,-1,260,242,219,-1,242,260,225,-1,219,216,260,-1,219,217,216,-1,249,263,72,-1,251,263,249,-1,70,244,271,-1,70,69,244,-1,267,212,298,-1,213,212,267,-1,210,215,321,-1,215,210,211,-1,290,250,206,-1,290,265,250,-1};
			return value;
		}
		private int[] getrrib9_Geo_6_170_coordIndex_3()
		{
			int[] value = {202,264,203,-1,202,321,264,-1,198,202,204,-1,198,201,202,-1,154,300,155,-1,154,299,300,-1,253,265,290,-1,253,200,265,-1,301,155,300,-1,301,150,155,-1,176,197,252,-1,319,197,176,-1,303,150,301,-1,151,150,303,-1,153,315,320,-1,148,315,153,-1,175,184,317,-1,175,174,184,-1,316,304,319,-1,32,304,316,-1,315,191,317,-1,193,191,315,-1,316,172,258,-1,316,177,172,-1,297,146,318,-1,147,146,297,-1,149,192,193,-1,192,149,160,-1,171,191,190,-1,171,170,191,-1,190,262,171,-1,262,190,314,-1,259,20,292,-1,259,21,20,-1,254,312,314,-1,312,254,313,-1,188,292,20,-1,17,292,188,-1,313,187,312,-1,187,313,311,-1,169,116,168,-1,115,116,169,-1,189,17,188,-1,18,17,189,-1,311,126,187,-1,126,311,123,-1,177,170,172,-1,175,170,177,-1,169,186,257,-1,167,186,169,-1,163,157,164,-1,163,159,157,-1,153,146,148,-1,153,151,146,-1,161,144,160,-1,144,161,28,-1,145,309,143,-1,309,145,118,-1,89,142,228,-1,89,88,142,-1,121,135,134,-1,121,273,135,-1,136,124,133,-1,124,136,128,-1,126,275,186,-1,126,125,275,-1,132,122,277,-1,122,132,120,-1,1,308,112,-1,308,1,0,-1,26,109,248,-1,26,25,109,-1,224,13,294,-1,224,15,13,-1,79,220,82,-1,79,245,220,-1,223,307,222,-1,281,307,223,-1,77,15,224,-1,77,16,15,-1,285,81,91,-1,284,81,285,-1,6,234,5,-1,6,232,234,-1,293,84,227,-1,12,84,293,-1,81,306,79,-1,306,81,284,-1,278,102,107,-1,278,101,102,-1,104,99,105,-1,104,227,99,-1,71,75,73,-1,71,97,75,-1,95,72,263,-1,95,97,72,-1,261,281,223,-1,282,281,261,-1,305,158,180,-1,156,158,305,-1,180,269,305,-1,269,180,270,-1,85,237,86,-1,237,85,48,-1,235,180,181,-1,180,235,270,-1,236,55,66,-1,55,236,56,-1,48,87,57,-1,48,85,87,-1,51,287,49,-1,287,51,233,-1,295,50,288,-1,50,295,52,-1,182,54,181,-1,60,54,182,-1,183,194,195,-1,194,183,253,-1,72,207,249,-1,70,207,72,-1,298,154,267,-1,154,298,299,-1,32,302,304,-1,32,34,302,-1,35,259,30,-1,33,259,35,-1,34,303,302,-1,34,318,303,-1,300,291,301,-1,39,291,300,-1,298,38,299,-1,298,280,38,-1,318,35,297,-1,34,35,318,-1,23,258,172,-1,21,258,23,-1,241,310,243,-1,310,241,228,-1,6,86,233,-1,4,86,6,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib9_Coord_7_170_point_1()
		{
			double[] value = {-.7685,45.39387,-2.80593,-.83433,45.41946,-2.89949,-.72613,45.36417,-2.85684,-.56277,45.69103,-2.76828,-.5772,45.63855,-2.67355,-.53179,45.60576,-2.78651,-.5675,45.56388,-2.67244,-1.04447,45.76991,-3.45092,-1.03978,45.78979,-3.40523,-.80952,45.81547,-3.28281,-.80398,45.77001,-3.2824,-.97234,45.51013,-3.30707,-1.06886,45.41617,-3.32795,-1.03739,45.45426,-3.34343,-.93727,45.56251,-3.34174,-.99296,45.53793,-3.37736,-.94938,45.63334,-3.42711,-4.52136,42.36083,.88984,-4.39199,42.18218,1.18462,-4.54799,42.33053,.89638,-4.6899,42.76437,.40971,-4.82464,43.04703,-.16995,-4.72242,42.83386,.45992,-4.87087,43.11355,-.11785,-1.8942,45.41393,-3.82057,-1.62831,45.47346,-3.65431,-1.91192,45.43618,-3.8002,-1.58832,45.44991,-3.71426,-4.72784,42.51745,.39159,-4.85011,42.84353,-.23473,-4.84676,42.86111,-.23,-4.6982,42.58732,.38102,-4.8575,43.42979,-1.22416,-4.87387,43.15778,-.7081,-4.89486,43.39753,-1.22467,-4.90695,43.10956,-.71776,-2.75919,45.0841,-3.80573,-3.34587,44.83205,-3.51507,-2.74254,45.03187,-3.88262,-3.31283,44.76364,-3.59445,-2.66073,44.89012,-3.93497,-3.32733,44.59572,-3.59789,-2.75818,45.00354,-3.99583,-.99177,45.65156,-3.09623,-1.16624,45.62948,-3.23751,-1.00172,45.59738,-3.08151,-.76876,45.89239,-2.83277,-.81041,45.79438,-2.76775,-.6334,45.68739,-2.60787,-.63495,45.41349,-2.60973,-.65456,45.35248,-2.65397,-.60432,45.41472,-2.61218,-.62413,45.35356,-2.66896,-.49112,45.6422,-2.87715,-.49891,45.64586,-2.91674,-.60265,45.77738,-2.84429,-.57246,45.73533,-2.82635,-.65817,45.74767,-2.67195,-.76446,45.41345,-2.95736,-.6316,45.77617,-2.91483,-.53335,45.64794,-2.95603,-.80469,45.68311,-2.74647,-.88389,45.66995,-2.91033,-.76943,45.56432,-2.77661,-.86794,45.56901,-2.92213,-.71485,45.89583,-2.88977,-.66293,45.80827,-2.74874,-.64068,45.698,-3.07787,-.6984,45.7952,-3.07316,-1.56552,45.63493,-3.88484,-1.86846,45.51576,-4.00623,-1.62655,45.70396,-3.81405,-1.92776,45.62301,-3.95813,-1.34167,45.74558,-3.66633,-1.03592,45.82544,-3.39476,-1.39505,45.80647,-3.62188,-.94011,45.66598,-3.42824,-.96654,45.64904,-3.50856,-.9708,45.67706,-3.515,-1.10389,45.57347,-3.70106,-1.02421,45.64462,-3.65708,-1.08023,45.55194,-3.67361,-1.0419,45.67482,-3.67277,-.94366,45.53393,-3.28888,-1.06884,45.42363,-3.30571,-.59243,45.65822,-2.61151,-.56713,45.62024,-2.59477,-.61128,45.71475,-2.68666,-.85859,45.94727,-3.27849,-.89835,45.9291,-3.23683,-.78825,45.95016,-3.18182,-1.03657,45.53474,-3.58257,-.99442,45.90341,-3.35758,-.95721,45.8677,-3.36257,-1.07756,45.88089,-3.4109,-1.68569,45.79593,-3.74905,-1.44027,45.86316,-3.6102,-1.65351,45.74067,-3.78362,-1.13281,45.42053,-3.26734,-1.21138,45.38154,-3.3632};
			return value;
		}
		private double[] getrrib9_Coord_7_170_point_2()
		{
			double[] value = {-1.11892,45.41602,-3.28505,-1.23097,45.39055,-3.34614,-1.2735,45.4247,-3.30755,-1.15448,45.43391,-3.20959,-1.18979,45.39888,-3.52709,-1.2718,45.40819,-3.47124,-1.32731,45.47022,-3.6475,-1.37519,45.4732,-3.43784,-1.41144,45.5398,-3.42517,-1.66927,45.50088,-3.59395,-.98345,45.45801,-3.0868,-1.00808,45.51447,-3.06557,-.8528,45.47366,-2.89342,-4.41671,42.36097,1.22091,-4.56029,42.53631,.9554,-4.43928,42.38403,1.28269,-4.58372,42.58304,1.00022,-4.38164,42.02802,1.38821,-4.46316,42.09835,1.22954,-4.30848,42.09263,1.40237,-4.30499,42.14225,1.43325,-4.31864,42.10001,1.41998,-4.28505,42.14354,1.42585,-4.44735,42.09671,1.4587,-4.42886,42.09713,1.45123,-4.4081,42.19637,1.54522,-4.42804,42.20784,1.55735,-4.42867,42.20066,1.4847,-4.42954,42.13028,1.44654,-4.32139,42.21203,1.48587,-4.36397,42.21083,1.44789,-4.34352,42.18693,1.41558,-4.30941,42.17818,1.45504,-4.40405,42.04626,1.41522,-4.38715,42.04726,1.40853,-4.38895,42.09896,1.40061,-4.41495,42.09721,1.41897,-4.39674,42.16669,1.42939,-4.34747,42.16406,1.40646,-4.41176,42.21811,1.49134,-4.39417,42.2225,1.48293,-.90751,45.91738,-3.35501,-.93795,45.93572,-3.33846,-4.60327,42.26804,.92789,-4.75997,42.50776,.41826,-4.57812,42.26876,.90259,-4.87003,43.2739,-1.27365,-4.89255,43.02587,-.75244,-4.90077,43.26969,-1.26659,-4.93617,43.03181,-.73951,-4.15649,44.18193,-2.97273,-4.6202,43.79382,-2.29558,-4.16767,44.18486,-2.98615,-4.6339,43.79563,-2.29959,-2.6583,44.88263,-3.90078,-3.31416,44.59897,-3.57965,-.66092,45.36694,-2.90645,-.71145,45.40865,-3.00134,-.61305,45.40589,-2.93399,-.66645,45.46542,-3.03395,-4.87861,42.78973,-.23754,-4.84507,42.79339,-.25276,-1.02006,45.48187,-3.24613,-.83184,45.54673,-3.19346,-.92565,45.49654,-3.18936,-.90576,45.56849,-3.24694,-4.62806,42.5906,1.04438,-4.50057,42.3888,1.36719,-4.59947,42.59776,1.02071,-4.47221,42.40843,1.33945,-5.01537,43.42584,-.56567,-4.94564,43.16707,-.06013,-4.9802,43.41457,-.58251,-4.91454,43.16551,-.07636,-4.78428,44.35701,-2.20753,-5.01231,43.69289,-1.05868,-4.75456,44.34986,-2.19979,-4.97992,43.68737,-1.07292,-1.44284,45.86269,-3.56046,-1.70563,45.79966,-3.71016,-.56807,45.38588,-2.84422,-.51912,45.49398,-2.88126,-.56889,45.51496,-2.94737,-4.33212,44.73019,-2.99269,-4.8009,44.24964,-2.26926,-4.29797,44.79496,-2.94042,-4.38938,42.23929,1.57366,-4.51973,42.29967,1.37509,-4.54192,42.47128,.9076,-4.40578,42.29078,1.18956,-4.97392,43.06708,-.0869,-5.04541,43.33561,-.58706,-4.9644,42.89717,-.15424,-5.00316,43.15013,-.67581,-3.47148,44.84275,-3.67271,-4.25197,44.44396,-3.01829,-4.10341,44.44698,-2.93954,-4.15779,44.59741,-2.93254,-3.40809,44.9541,-3.52985,-3.57842,45.14171,-3.58702};
			return value;
		}
		private double[] getrrib9_Coord_7_170_point_3()
		{
			double[] value = {-3.57098,45.09101,-3.62195,-2.85174,45.22611,-3.8449,-2.95271,45.39695,-3.87568,-3.00804,45.39126,-3.94246,-3.5513,45.13439,-3.55574,-2.41818,45.20113,-4.10635,-2.50582,45.31548,-4.13933,-2.08248,45.41441,-4.09185,-2.43148,45.26446,-3.87718,-2.14246,45.41064,-3.81192,-2.51086,45.38266,-3.8859,-2.19688,45.47256,-3.83216,-2.0809,45.34936,-3.92762,-2.01678,45.22718,-3.95,-1.84648,45.32973,-3.88495,-2.25494,45.62367,-3.89798,-1.99454,45.53316,-3.72462,-2.04267,45.65876,-3.80452,-2.00189,45.7277,-3.87546,-1.73811,45.71341,-3.6521,-1.29094,45.70544,-3.73014,-1.55134,45.43117,-3.77042,-.89734,45.72189,-3.32502,-.79577,45.72345,-3.2673,-1.01821,45.52622,-3.45731,-1.44112,45.65068,-3.45533,-1.17308,45.50102,-3.19915,-1.16756,45.37093,-3.39338,-.97635,45.92135,-3.31193,-.80341,45.93118,-3.05439,-.77392,45.9286,-3.09625,-.95006,45.48189,-3.15127,-.56273,45.449,-2.68384,-.56153,45.54553,-2.58959,-.5236,45.47596,-2.79041,-.51362,45.48698,-2.84149,-.62232,45.76159,-2.74862,-.61274,45.65299,-2.59422,-.86156,45.80667,-2.96795,-.81827,45.92198,-3.3096,-.81357,45.847,-3.28495,-.94989,45.79438,-3.15757,-1.47019,45.77788,-3.51232,-1.13748,45.78314,-3.29696,-1.54052,45.45752,-3.80965,-1.32014,45.609,-3.76872,-1.30986,45.49665,-3.69459,-2.19202,45.6627,-3.95779,-1.9539,45.46342,-3.73144,-2.14623,45.56899,-4.02983,-2.632,45.49527,-4.07982,-2.17777,45.64342,-3.99981,-4.26794,44.78935,-2.92405,-3.54167,45.01892,-3.63783,-4.8042,42.61295,.47949,-4.77196,42.8844,.52021,-4.30308,42.23088,1.49621,-4.3534,42.248,1.5572,-4.9077,43.28559,-.64294,-4.81604,42.91292,-.22522,-1.68613,45.59178,-3.5845,-.63387,45.65879,-3.06216,-4.79965,42.87259,.53652,-1.9865,45.71804,-3.9075,-2.64609,45.52397,-4.03953,-3.0098,45.35005,-3.97885,-2.3086,45.06538,-3.9989,-2.30807,45.0709,-3.96612,-.57475,45.37548,-2.78309,-.61751,45.34377,-2.78695,-.557,45.38107,-2.80702,-1.84321,45.33736,-3.92647,-2.01689,45.22927,-3.98906,-4.35988,42.13551,1.39833,-4.35374,42.21775,1.53812,-4.38302,42.21102,1.55245,-4.4127,42.02985,1.40392,-4.28495,42.19065,1.45753,-1.30965,45.42909,-3.45941,-2.09785,45.37705,-3.9142,-2.40724,45.21828,-3.94412,-.78771,45.60071,-3.2131,-.64723,45.54418,-3.04851,-.91336,45.59025,-3.33601,-1.13224,45.44719,-3.60443,-1.09406,45.43067,-3.53667,-1.15853,45.40279,-3.5305,-.5937,45.54562,-2.58603,-.66606,45.31538,-2.70886,-2.87131,45.13733,-4.04719,-2.92182,45.2163,-4.02287,-4.17545,44.3699,-2.97695,-4.66865,42.64181,.37775,-1.11356,45.38039,-3.4006,-1.06966,45.42295,-3.41918,-.6479,45.32442,-2.70747,-.60508,45.36218,-2.70554,-4.90942,43.09263,-.72345,-2.39731,45.20233,-3.95374,-2.73605,45.01377,-3.8915};
			return value;
		}
		private double[] getrrib9_Coord_7_170_point_4()
		{
			double[] value = {-3.31004,44.74421,-3.60291,-4.17711,44.35098,-2.98277,-4.63872,43.93395,-2.28308,-4.64278,43.91759,-2.28657,-4.59586,43.97173,-2.26286,-.64319,45.33863,-2.81471,-1.15725,45.45415,-3.62481,-.87434,45.60987,-3.25847,-.77134,45.45114,-2.7779,-4.48459,42.09529,1.26254,-1.11165,45.88531,-3.36538,-4.51112,42.17277,1.32455,-4.65918,42.50479,1.04573,-4.65107,42.37067,.99286,-4.83028,42.7751,.53173,-4.99325,43.4277,-1.1913,-4.89439,43.56352,-1.16747,-5.03255,43.61117,-1.12502,-4.89835,43.38136,-1.22863,-4.65261,44.1797,-2.24476,-4.73399,43.99485,-2.30151,-2.61925,45.51691,-3.93114};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib10_Geo_6_175_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,0,-1,4,5,6,-1,7,8,9,-1,9,10,7,-1,11,12,13,-1,14,15,16,-1,15,17,16,-1,18,19,20,-1,21,22,23,-1,24,25,26,-1,26,27,24,-1,28,29,30,-1,30,31,28,-1,32,33,34,-1,33,35,34,-1,36,37,38,-1,39,40,41,-1,42,22,43,-1,44,45,10,-1,46,47,48,-1,46,49,47,-1,50,51,52,-1,39,53,43,-1,43,40,39,-1,54,32,55,-1,54,36,32,-1,29,56,57,-1,30,29,26,-1,58,59,60,-1,59,61,60,-1,62,29,28,-1,62,56,29,-1,63,64,65,-1,65,66,63,-1,67,68,69,-1,70,71,72,-1,71,73,72,-1,74,75,76,-1,76,77,74,-1,10,9,78,-1,78,44,10,-1,79,80,81,-1,82,79,83,-1,63,84,64,-1,84,85,64,-1,86,87,88,-1,88,84,86,-1,89,90,91,-1,91,92,89,-1,93,94,95,-1,95,96,93,-1,97,93,98,-1,97,94,93,-1,97,99,94,-1,100,101,102,-1,100,103,101,-1,54,104,36,-1,104,37,36,-1,105,106,107,-1,106,108,107,-1,32,34,55,-1,34,109,55,-1,1,0,110,-1,110,111,1,-1,112,110,113,-1,113,5,112,-1,5,113,6,-1,22,114,52,-1,115,23,22,-1,40,43,22,-1,116,117,118,-1,55,119,54,-1,55,120,119,-1,121,122,45,-1,121,123,122,-1,124,58,125,-1,124,59,58,-1,125,58,25,-1,126,37,127,-1,126,128,37,-1,129,75,130,-1,131,83,79,-1,79,70,131,-1,132,133,28,-1,133,62,28,-1,134,100,132,-1,100,133,132,-1,86,84,63,-1,63,135,86,-1,136,101,103,-1,136,137,101,-1,88,138,84,-1,139,140,101,-1,101,137,139,-1,141,142,143,-1,142,144,143,-1,145,146,139,-1,96,147,148,-1,147,149,148,-1,150,151,152,-1,152,153,150,-1,154,155,156,-1,154,157,155,-1,155,158,159,-1,158,160,159,-1,161,3,2,-1,162,163,164,-1,163,165,164,-1,166,160,164,-1,160,158,164,-1,162,167,168,-1,162,169,167,-1,170,171,172,-1,171,173,172,-1,171,174,173,-1,175,171,170,-1,156,155,106,-1,155,159,106,-1,13,176,17,-1,13,177,176,-1,178,179,153,-1,179,150,153,-1,180,178,181,-1,178,153,181,-1,182,95,94,-1,94,183,182,-1,184,94,99,-1,184,183,94,-1,146,185,186,-1,185,187,186,-1,143,20,19,-1,19,56,143,-1,133,100,102,-1,102,188,133,-1,64,137,136,-1,64,85,137,-1,136,103,189,-1,189,190,136,-1,56,19,57,-1,72,191,130,-1,130,192,72,-1,71,79,193,-1,82,80,79,-1,194,9,8,-1,8,190,194,-1,128,60,61,-1,61,195,128,-1,35,196,46,-1,196,197,46,-1,123,198,199,-1,123,121,198,-1,200,201,35,-1,201,34,35,-1,22,42,115,-1,22,21,114,-1,3,202,203,-1,161,204,202,-1,202,3,161,-1,111,110,112,-1,203,0,3,-1,12,205,177,-1,177,13,12,-1,101,140,102,-1,140,206,102,-1,207,208,209,-1,208,210,209,-1,180,211,212,-1,211,187,212,-1,213,127,37,-1,37,104,213,-1,170,214,175,-1,170,166,214,-1,99,87,215,-1,99,97,87,-1,216,96,95,-1,216,147,96,-1,18,215,86,-1,215,87,86,-1,182,91,90,-1,182,183,91,-1,217,144,218,-1,218,184,217,-1,137,85,145,-1,145,139,137,-1,81,219,79,-1,71,70,79,-1,69,220,221,-1,221,67,69,-1,65,222,7,-1,45,122,10,-1,223,224,83,-1,224,82,83,-1,125,69,122,-1,191,57,130,-1,57,225,130,-1,76,129,65,-1,129,66,65,-1,10,68,77,-1,77,7,10,-1,27,29,226,-1,27,26,29,-1,76,75,129,-1,49,46,197,-1,197,227,49,-1,56,62,141,-1,141,143,56,-1,191,29,57,-1,191,226,29,-1,190,222,136,-1,228,49,227,-1,227,229,228,-1,61,227,197,-1,61,59,227,-1,49,230,47,-1,49,228,230,-1,231,232,233,-1,233,234,231,-1,44,116,45,-1,116,121,45,-1,68,122,69,-1,68,10,122,-1,52,40,22,-1,196,35,33,-1,219,193,79,-1,115,235,23,-1,115,236,235,-1,230,39,41,-1,230,237,39,-1,51,50,47,-1,50,48,47,-1,135,225,19,-1,225,57,19,-1,18,20,217,-1,217,215,18,-1,151,14,238,-1,14,16,238,-1,15,11,17,-1,11,13,17,-1,182,90,239,-1,7,222,8,-1,202,6,113,-1,113,203,202,-1,1,163,240,-1,240,2,1,-1,190,8,222,-1,241,105,209,-1,241,242,105,-1,151,239,152,-1,151,238,239,-1};
			return value;
		}
		private int[] getrrib10_Geo_6_175_coordIndex_2()
		{
			int[] value = {217,143,144,-1,143,217,20,-1,243,39,237,-1,53,39,243,-1,236,233,232,-1,236,244,233,-1,245,246,201,-1,246,245,235,-1,48,247,200,-1,50,247,48,-1,230,51,47,-1,41,51,230,-1,23,245,21,-1,23,235,245,-1,193,248,249,-1,219,248,193,-1,134,126,127,-1,134,132,126,-1,117,120,118,-1,119,120,117,-1,9,250,78,-1,194,250,9,-1,124,122,123,-1,124,125,122,-1,228,199,251,-1,228,229,199,-1,252,233,243,-1,234,233,252,-1,121,118,198,-1,116,118,121,-1,231,246,232,-1,231,109,246,-1,252,237,251,-1,237,252,243,-1,247,21,245,-1,114,21,247,-1,196,61,197,-1,195,61,196,-1,199,252,251,-1,252,199,198,-1,109,120,55,-1,109,231,120,-1,51,40,52,-1,41,40,51,-1,125,24,69,-1,125,25,24,-1,66,130,225,-1,66,129,130,-1,7,76,65,-1,7,77,76,-1,83,192,223,-1,83,131,192,-1,248,81,220,-1,219,81,248,-1,80,224,221,-1,80,82,224,-1,222,64,136,-1,222,65,64,-1,24,220,69,-1,24,248,220,-1,72,226,191,-1,73,226,72,-1,146,138,253,-1,138,146,145,-1,91,184,218,-1,183,184,91,-1,167,254,255,-1,254,167,256,-1,257,205,258,-1,257,177,205,-1,259,147,216,-1,259,260,147,-1,176,261,262,-1,176,263,261,-1,19,86,135,-1,19,18,86,-1,103,134,189,-1,100,134,103,-1,211,186,187,-1,211,264,186,-1,178,212,265,-1,178,180,212,-1,208,266,210,-1,208,179,266,-1,160,267,159,-1,172,267,160,-1,263,268,269,-1,263,257,268,-1,105,207,209,-1,105,107,207,-1,11,270,12,-1,270,11,271,-1,112,175,214,-1,175,112,5,-1,272,161,273,-1,272,204,161,-1,1,165,163,-1,165,1,111,-1,175,4,274,-1,5,4,175,-1,4,202,204,-1,4,6,202,-1,260,275,276,-1,275,260,261,-1,124,227,59,-1,124,229,227,-1,119,104,54,-1,119,250,104,-1,68,74,77,-1,68,67,74,-1,73,27,226,-1,73,249,27,-1,225,63,66,-1,225,135,63,-1,188,62,133,-1,188,141,62,-1,264,277,206,-1,264,278,277,-1,184,215,217,-1,99,215,184,-1,185,253,279,-1,253,185,146,-1,278,211,280,-1,264,211,278,-1,218,92,91,-1,281,92,218,-1,93,148,279,-1,93,96,148,-1,212,185,282,-1,212,187,185,-1,181,92,280,-1,181,89,92,-1,265,282,283,-1,282,265,212,-1,153,89,181,-1,153,152,89,-1,147,276,149,-1,147,260,276,-1,283,266,265,-1,283,284,266,-1,276,285,284,-1,276,275,285,-1,150,208,286,-1,179,208,150,-1,16,259,238,-1,262,259,16,-1,275,241,285,-1,275,269,241,-1,207,286,208,-1,207,287,286,-1,262,17,176,-1,17,262,16,-1,106,242,156,-1,106,105,242,-1,15,271,11,-1,287,271,15,-1,257,154,268,-1,257,258,154,-1,267,270,108,-1,267,288,270,-1,205,289,254,-1,12,289,205,-1,290,254,289,-1,254,290,255,-1,291,272,273,-1,291,292,272,-1,290,174,292,-1,174,290,173,-1,274,292,174,-1,274,272,292,-1,292,255,290,-1,255,292,291,-1,174,175,274,-1,175,174,171,-1,164,169,162,-1,164,158,169,-1,164,214,166,-1,164,165,214,-1,168,163,162,-1,168,240,163,-1,173,289,288,-1,173,290,289,-1,172,288,267,-1,172,173,288,-1,169,256,167,-1,157,256,169,-1,288,12,270,-1,288,289,12,-1,157,258,256,-1,258,157,154,-1,107,287,207,-1,107,271,287,-1,268,156,242,-1,154,156,268,-1,14,287,15,-1,287,14,286,-1,209,285,241,-1,285,209,210,-1,269,261,263,-1,261,269,275,-1,286,151,150,-1,286,14,151,-1,210,284,285,-1,284,210,266,-1,216,238,259,-1,239,238,216,-1,149,284,283,-1,149,276,284,-1,95,239,216,-1,182,239,95,-1,283,148,149,-1,148,283,282,-1,180,280,211,-1,280,180,181,-1,279,282,185,-1,279,148,282,-1,280,281,278,-1,280,92,281,-1,279,98,93,-1,98,279,253,-1,142,278,281,-1,277,278,142,-1,186,139,146,-1,139,186,140,-1,253,88,98,-1,88,253,138,-1,141,277,142,-1,188,277,141,-1,138,85,84,-1,138,145,85,-1,206,188,102,-1,206,277,188,-1,223,130,75,-1,223,192,130,-1,190,213,194,-1,189,213,190,-1,31,128,126,-1,60,128,31,-1,224,67,221,-1,67,224,74,-1,117,44,78,-1,116,44,117,-1,37,195,38,-1,195,37,128,-1,157,158,155,-1,158,157,169,-1,203,110,0,-1,203,113,110,-1,111,214,165,-1,214,111,112,-1};
			return value;
		}
		private int[] getrrib10_Geo_6_175_coordIndex_3()
		{
			int[] value = {273,2,240,-1,273,161,2,-1,4,272,274,-1,272,4,204,-1,108,271,107,-1,108,270,271,-1,269,242,241,-1,269,268,242,-1,166,172,160,-1,170,172,166,-1,159,108,106,-1,267,108,159,-1,179,265,266,-1,179,178,265,-1,264,140,186,-1,264,206,140,-1,291,240,168,-1,291,273,240,-1,260,262,261,-1,259,262,260,-1,263,177,257,-1,176,177,263,-1,205,256,258,-1,205,254,256,-1,168,255,291,-1,255,168,167,-1,144,281,218,-1,142,281,144,-1,87,98,88,-1,87,97,98,-1,224,75,74,-1,224,223,75,-1,194,104,250,-1,104,194,213,-1,220,80,221,-1,81,80,220,-1,249,71,193,-1,71,249,73,-1,192,70,72,-1,192,131,70,-1,60,30,58,-1,31,30,60,-1,231,118,120,-1,231,234,118,-1,196,38,195,-1,38,196,33,-1,50,114,247,-1,52,114,50,-1,115,244,236,-1,115,42,244,-1,46,200,35,-1,46,48,200,-1,201,109,34,-1,201,246,109,-1,198,234,252,-1,118,234,198,-1,244,43,53,-1,42,43,244,-1,230,251,237,-1,251,230,228,-1,123,229,124,-1,229,123,199,-1,78,119,117,-1,250,119,78,-1,36,33,32,-1,38,33,36,-1,189,127,213,-1,189,134,127,-1,28,126,132,-1,28,31,126,-1,249,24,27,-1,248,24,249,-1,30,25,58,-1,25,30,26,-1,200,245,201,-1,200,247,245,-1,235,232,246,-1,232,235,236,-1,244,243,233,-1,243,244,53,-1,90,152,239,-1,89,152,90,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib10_Coord_7_175_point_1()
		{
			double[] value = {-4.60796,41.76324,.88561,-4.61416,41.74157,.90708,-4.58891,41.72196,.86668,-4.56296,41.75796,.86139,-4.51192,41.84592,1.02399,-4.54656,41.89048,1.09436,-4.52564,41.86353,1.0013,-1.03172,44.70554,-3.31643,-1.04022,44.7229,-3.30272,-.97911,44.7166,-3.17175,-.95307,44.65096,-3.2005,-4.50546,42.67318,-1.48871,-4.58054,42.47589,-1.11667,-4.54396,42.62218,-1.5632,-4.24845,42.98958,-2.20236,-4.41246,42.86931,-1.8796,-4.27307,42.94309,-2.31737,-4.43625,42.79722,-1.99557,-1.85751,44.2351,-4.07479,-1.37074,44.4585,-3.70672,-1.86029,44.24037,-4.04112,-.62815,44.56375,-2.4951,-.63287,44.48283,-2.50587,-.62084,44.57781,-2.51479,-1.02106,44.47272,-3.11519,-1.02056,44.4705,-3.10146,-1.08779,44.47604,-3.13762,-1.08827,44.47562,-3.14722,-1.15187,44.49775,-3.17372,-1.1492,44.48181,-3.17701,-1.07229,44.46655,-3.11402,-1.07541,44.48257,-3.1056,-.70785,44.84793,-2.64691,-.73694,44.8141,-2.61777,-.6514,44.76935,-2.54254,-.71881,44.59821,-2.48554,-.80036,44.86909,-2.80718,-.92567,44.8376,-3.00777,-.8137,44.85638,-2.79804,-.66789,44.36566,-2.60712,-.65231,44.41273,-2.55172,-.67641,44.35456,-2.58882,-.62238,44.49159,-2.54998,-.63946,44.43997,-2.55343,-.88211,44.59034,-3.10665,-.88183,44.57485,-3.11263,-.7331,44.38522,-2.54483,-.70125,44.33566,-2.57214,-.70598,44.39151,-2.52316,-.72598,44.32005,-2.61309,-.69137,44.38998,-2.52113,-.68446,44.35156,-2.55798,-.65317,44.42234,-2.51596,-.6538,44.41304,-2.5868,-.78174,44.86997,-2.82312,-.69085,44.84167,-2.66874,-1.39975,44.42748,-3.65298,-1.23806,44.48783,-3.36583,-.98977,44.4538,-3.05024,-.87055,44.40882,-2.87358,-.99319,44.47018,-3.03765,-.88192,44.42118,-2.85586,-1.4127,44.42957,-3.63491,-1.3454,44.55807,-3.80486,-1.37082,44.65082,-3.81043,-1.1117,44.66542,-3.45094,-1.14157,44.62692,-3.49102,-.94877,44.60761,-3.23043,-.95117,44.63413,-3.21276,-.90984,44.52673,-3.12715,-1.16604,44.45755,-3.34322,-1.12437,44.46547,-3.20447,-1.17875,44.45541,-3.34886,-1.13383,44.466,-3.19709,-.99922,44.62629,-3.33898,-1.08177,44.61643,-3.4405,-1.10314,44.65442,-3.45029,-1.02337,44.68711,-3.32577,-.88842,44.66311,-3.07772,-1.06447,44.50257,-3.25368,-.95377,44.54706,-3.24298,-.9323,44.49979,-3.16041,-1.01014,44.57318,-3.33457,-1.06585,44.55888,-3.39625,-1.85441,44.37562,-4.13227,-1.87839,44.4451,-4.10652,-1.85642,44.25344,-4.11052,-2.21588,44.02763,-4.13862,-2.223,44.15072,-4.20184,-3.61483,43.42242,-3.11906,-3.61296,43.37509,-3.19313,-3.12928,43.6531,-3.66933,-3.15003,43.73111,-3.61263,-3.08246,43.4749,-3.79292,-3.07764,43.47071,-3.76903,-3.58936,43.26569,-3.32103,-3.59757,43.27387,-3.34768,-2.70898,43.69203,-4.00054,-2.75748,43.73496,-4.03497,-2.70651,43.69484,-3.96391};
			return value;
		}
		private double[] getrrib10_Coord_7_175_point_2()
		{
			double[] value = {-1.46238,44.77024,-3.66728,-1.94026,44.59791,-4.02955,-1.94721,44.57521,-3.96407,-1.44155,44.77867,-3.71201,-.90453,44.85386,-3.01771,-4.59499,42.94823,-1.27747,-4.66304,42.75988,-.88285,-4.54943,42.92645,-1.26827,-4.61934,42.74763,-.86994,-.62716,44.74854,-2.5713,-4.60663,41.87134,.99816,-4.59618,41.83479,1.02769,-4.57475,41.88939,1.09201,-4.57457,41.88262,.99564,-.65064,44.51479,-2.48605,-.61963,44.54726,-2.53032,-.77426,44.55873,-2.92457,-.77845,44.62185,-2.89819,-.70391,44.54382,-2.73898,-.77904,44.78215,-2.85278,-.69322,44.76336,-2.67425,-.78744,44.50762,-2.91667,-.8992,44.53777,-3.1127,-.79633,44.45612,-2.91595,-.81198,44.44002,-2.91781,-.91495,44.52029,-3.10845,-1.07149,44.63003,-3.09406,-1.01699,44.83661,-3.11331,-.97945,44.61661,-3.02171,-1.12801,44.62533,-3.47517,-1.1708,44.52753,-3.46357,-1.14053,44.49811,-3.41584,-1.15541,44.64751,-3.17483,-1.46243,44.59634,-3.62397,-1.11413,44.84265,-3.21874,-1.35686,44.4918,-3.75742,-1.40724,44.722,-3.7702,-1.90298,44.5219,-4.07966,-2.23372,44.26725,-4.21634,-2.28162,44.41506,-4.15501,-2.332,44.48874,-4.07516,-1.87159,44.2682,-3.95514,-2.24107,44.14194,-4.00866,-1.86314,44.24642,-4.00725,-2.22927,44.0958,-4.03725,-2.25759,44.35036,-4.19693,-2.84524,44.13663,-4.0328,-4.02533,43.0702,-2.92432,-3.6913,43.47945,-3.35809,-4.11427,43.26583,-2.84501,-4.16046,43.25066,-2.30159,-4.11692,43.08849,-2.43146,-3.94993,43.20193,-2.68831,-4.00235,43.3668,-2.60291,-4.73593,42.51462,-1.13631,-4.74651,42.51187,-.67897,-4.74015,42.66432,-1.014,-4.71684,42.36812,-.81534,-4.73464,42.19104,.00032,-4.64922,42.58843,-.55032,-4.66114,42.28876,.1032,-4.56558,41.71493,.84935,-4.67276,41.86682,.4764,-4.62421,41.73733,.89525,-4.70003,41.95814,.58997,-4.61304,41.83516,1.0229,-4.67631,42.05927,.73823,-4.68597,42.04078,-.21784,-4.64705,41.83569,.38502,-4.69713,42.09762,-.16011,-4.61991,42.05785,.73827,-4.59734,42.0405,.71234,-4.61343,42.28334,.10249,-4.58618,42.2213,.02814,-4.53566,41.98121,.62434,-4.53816,41.90391,1.10356,-4.43954,42.71406,-2.1107,-4.57541,42.56011,-1.64982,-4.04289,43.54134,-2.51759,-4.23082,43.42111,-2.24041,-3.69957,43.78168,-3.00792,-3.65087,43.61556,-3.05132,-3.59822,43.31722,-3.24197,-3.10407,43.57167,-3.70967,-2.74481,43.76769,-3.94278,-3.24848,43.97267,-3.79702,-2.84358,44.2991,-3.88534,-3.23103,44.11377,-3.60927,-1.91079,44.38253,-3.94132,-1.09031,44.85135,-3.23821,-1.06712,44.78875,-3.26396,-1.21708,44.48147,-3.35643,-1.14533,44.50319,-3.43722,-1.07405,44.46472,-3.17316,-.98004,44.7664,-3.15429,-.87774,44.59715,-2.78156,-.79448,44.62443,-2.5732,-.802,44.38376,-2.66092,-.72881,44.45976,-2.7359,-.73901,44.40245,-2.76363};
			return value;
		}
		private double[] getrrib10_Coord_7_175_point_3()
		{
			double[] value = {-.69126,44.56831,-2.47228,-.63197,44.71069,-2.50818,-4.52563,41.78997,.89079,-4.56665,41.79309,.90427,-4.51085,41.77022,.90805,-4.65522,42.40793,-1.2247,-2.32269,44.46446,-4.02985,-4.47521,43.13266,-1.65523,-4.34485,43.29001,-1.97232,-4.50497,43.15385,-1.66493,-4.38068,43.31408,-1.99594,-3.22261,44.09918,-3.57177,-3.71878,43.80469,-3.03942,-.9962,44.84208,-3.12866,-4.59136,41.8983,1.09788,-2.21027,44.02474,-4.11122,-4.00025,43.05694,-2.90317,-2.22157,44.07861,-4.09551,-2.75733,43.85976,-3.89602,-1.01709,44.46441,-3.14908,-.92185,44.50528,-3.14804,-.94383,44.56222,-3.24414,-1.0907,44.72244,-3.35324,-1.06764,44.57039,-3.42134,-1.00452,44.58955,-3.34658,-1.19475,44.52468,-3.48897,-1.14865,44.47866,-3.18358,-.791,44.34741,-2.7094,-.7072,44.3451,-2.67043,-.75349,44.38692,-2.76579,-.6877,44.33823,-2.61571,-.63555,44.69782,-2.59419,-.62625,44.63634,-2.56369,-.63259,44.50786,-2.60013,-.6463,44.51171,-2.6312,-.61559,44.67352,-2.52463,-.62245,44.6039,-2.54794,-.67518,44.36244,-2.63213,-4.16117,43.05399,-2.54194,-4.00135,43.16623,-2.79163,-4.59805,41.70992,.84674,-4.57801,43.0607,-1.83959,-4.67541,42.86329,-1.41088,-.65981,44.41534,-2.61033,-.62616,44.50231,-2.57864,-.6251,44.67693,-2.50145,-.61638,44.69863,-2.53957,-.67299,44.55462,-2.47325,-1.0176,44.4639,-3.13389,-1.07934,44.46484,-3.16309,-.8878,44.76218,-3.04834,-.68972,44.36165,-2.66777,-.67189,44.42299,-2.64193,-2.80198,43.95817,-4.07348,-4.65931,42.27688,-.89967,-4.65232,42.03357,-.21849,-4.69361,42.28201,-.90285,-4.59934,42.56681,-1.6583,-4.68839,42.41433,-1.23018,-4.16575,42.94764,-2.67074,-4.18942,42.96131,-2.6883,-4.30272,42.86953,-2.48065,-4.27528,42.85827,-2.46124,-4.45726,42.72201,-2.12353,-2.83287,44.27861,-3.84418,-4.08657,43.58135,-2.55253,-4.26215,43.44434,-2.26631,-4.59999,42.58103,-.55468,-4.64521,42.69354,-1.55546,-4.53303,42.88404,-2.01089,-4.57074,42.64214,-.93705,-4.51295,42.81625,-1.34724,-4.49111,41.76871,.89034,-4.56697,41.70762,.83403,-4.48982,41.84772,1.01439,-4.3994,43.02207,-2.33782,-4.2697,43.13881,-2.58467,-2.2745,44.27365,-3.99272,-2.81527,44.14621,-3.83085,-3.19725,43.76601,-3.85493,-3.19284,43.94079,-3.56515,-2.77968,43.9374,-3.84861,-3.74565,43.68576,-3.27212,-4.14098,43.47477,-2.74698,-4.30933,43.33965,-2.46044,-4.44243,43.21077,-2.18241,-4.27837,43.11865,-2.05677,-4.44071,42.99927,-1.75143,-4.57742,42.52231,-.65397,-4.60023,42.3557,-.80945,-4.59965,42.10513,-.17134,-4.60065,41.82568,.3767,-4.53626,41.87778,.47021};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib11_Geo_6_180_coordIndex_1()
		{
			int[] value = {0,1,2,-1,0,3,1,-1,0,2,4,-1,4,5,0,-1,6,7,8,-1,9,10,11,-1,12,13,11,-1,13,14,11,-1,15,16,17,-1,15,18,16,-1,19,20,21,-1,19,22,20,-1,23,24,25,-1,26,27,28,-1,26,29,27,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,38,39,36,-1,40,24,41,-1,42,43,44,-1,43,45,44,-1,46,47,48,-1,49,50,21,-1,49,51,50,-1,19,52,53,-1,34,54,41,-1,34,33,54,-1,55,56,57,-1,55,30,56,-1,58,59,60,-1,12,61,62,-1,61,63,62,-1,64,65,66,-1,28,67,68,-1,28,27,67,-1,66,69,70,-1,70,64,66,-1,71,72,73,-1,72,74,73,-1,36,75,37,-1,76,77,78,-1,78,79,76,-1,47,37,48,-1,70,59,80,-1,75,81,82,-1,82,83,75,-1,84,78,85,-1,86,87,85,-1,88,89,90,-1,90,91,88,-1,92,14,13,-1,13,93,92,-1,94,95,13,-1,95,93,13,-1,96,97,98,-1,98,9,96,-1,99,97,96,-1,99,100,97,-1,55,101,30,-1,101,31,30,-1,102,103,104,-1,103,105,104,-1,106,107,108,-1,106,109,107,-1,110,111,57,-1,57,56,110,-1,24,23,112,-1,24,40,113,-1,114,115,49,-1,114,116,115,-1,66,65,73,-1,77,117,85,-1,85,78,77,-1,74,118,69,-1,74,119,118,-1,102,120,121,-1,121,103,102,-1,119,98,118,-1,98,122,118,-1,60,123,104,-1,60,88,123,-1,124,125,122,-1,91,126,123,-1,123,88,91,-1,62,94,12,-1,94,13,12,-1,90,127,91,-1,95,128,93,-1,128,129,93,-1,130,131,132,-1,130,133,131,-1,134,135,136,-1,135,137,136,-1,137,138,139,-1,137,135,138,-1,139,140,141,-1,139,138,140,-1,142,143,144,-1,142,145,143,-1,146,135,147,-1,147,148,146,-1,106,108,149,-1,108,148,149,-1,8,150,151,-1,151,6,8,-1,152,153,154,-1,153,155,154,-1,132,131,156,-1,156,127,132,-1,12,11,10,-1,10,61,12,-1,157,88,60,-1,157,89,88,-1,158,159,160,-1,159,161,160,-1,61,10,72,-1,84,85,162,-1,163,164,85,-1,65,165,73,-1,165,76,73,-1,166,58,167,-1,36,168,29,-1,39,168,36,-1,39,169,168,-1,42,170,43,-1,34,41,24,-1,113,25,24,-1,24,112,53,-1,152,171,133,-1,171,131,133,-1,101,172,31,-1,172,173,31,-1,10,9,119,-1,9,98,119,-1,100,174,175,-1,137,139,145,-1,139,143,145,-1,92,93,129,-1,129,176,92,-1,118,122,157,-1,122,89,157,-1,163,85,117,-1,85,164,86,-1,177,71,79,-1,177,68,71,-1,178,179,64,-1,179,65,64,-1,83,180,75,-1,29,26,75,-1,75,36,29,-1,69,157,70,-1,69,118,157,-1,63,67,181,-1,63,61,67,-1,168,169,182,-1,169,183,182,-1,184,67,27,-1,67,61,72,-1,58,80,59,-1,185,186,43,-1,43,187,185,-1,32,116,188,-1,32,189,116,-1,183,190,115,-1,183,169,190,-1,114,21,20,-1,114,49,21,-1,51,191,50,-1,51,192,191,-1,186,17,16,-1,186,185,17,-1,46,42,47,-1,42,44,47,-1,186,193,45,-1,45,43,186,-1,194,191,192,-1,194,195,191,-1,180,37,75,-1,180,48,37,-1,53,34,24,-1,32,188,30,-1,188,56,30,-1,116,114,188,-1,121,181,196,-1,196,197,121,-1,87,162,85,-1,29,184,27,-1,29,168,184,-1,19,21,50,-1,50,52,19,-1,119,74,10,-1,74,72,10,-1,9,11,14,-1,14,96,9,-1,147,198,199,-1,147,134,198,-1,134,147,135,-1,128,200,129,-1,200,7,129,-1,201,202,203,-1,201,204,202,-1,205,206,207,-1,205,208,206,-1,208,209,210,-1,208,205,209,-1,211,212,204,-1,211,213,212,-1,214,215,202,-1,214,216,215,-1,207,1,3,-1,207,206,1,-1,210,217,218,-1,210,209,217,-1,219,204,201,-1,219,211,204,-1,202,220,203,-1,202,215,220,-1,221,218,217,-1,222,218,221,-1,219,141,140,-1,219,201,141,-1,220,223,203,-1,223,220,224,-1,6,129,7,-1,129,6,176,-1,144,5,225,-1,5,144,224,-1,226,134,136,-1,226,198,134,-1,8,199,198,-1,227,199,8,-1,54,195,228,-1,54,33,195,-1,229,230,231,-1,230,229,232,-1,191,52,50,-1,35,52,191,-1,25,229,23,-1,25,232,229,-1,162,233,234,-1,87,233,162,-1,196,67,184,-1,181,67,196,-1,121,173,103,-1,121,197,173,-1,110,188,114,-1,56,188,110,-1,187,170,235,-1,187,43,170,-1};
			return value;
		}
		private int[] getrrib11_Geo_6_180_coordIndex_2()
		{
			int[] value = {166,236,237,-1,167,236,166,-1,194,238,239,-1,192,238,194,-1,193,16,228,-1,186,16,193,-1,185,230,17,-1,185,111,230,-1,228,194,193,-1,195,194,228,-1,22,23,229,-1,112,23,22,-1,183,116,189,-1,183,115,116,-1,193,239,45,-1,193,194,239,-1,111,187,57,-1,111,185,187,-1,67,71,68,-1,71,67,72,-1,49,190,51,-1,190,49,115,-1,184,182,196,-1,184,168,182,-1,48,178,80,-1,48,180,178,-1,234,84,162,-1,84,234,177,-1,81,164,82,-1,86,164,81,-1,163,165,240,-1,165,163,117,-1,167,101,236,-1,101,167,172,-1,179,165,65,-1,179,240,165,-1,124,100,175,-1,97,100,124,-1,141,143,139,-1,141,223,143,-1,241,137,145,-1,241,136,137,-1,242,136,241,-1,226,136,242,-1,150,243,151,-1,150,244,243,-1,171,156,131,-1,171,245,156,-1,153,133,246,-1,153,152,133,-1,247,248,249,-1,247,250,248,-1,142,225,251,-1,225,142,144,-1,114,231,110,-1,20,231,114,-1,45,38,44,-1,38,45,239,-1,252,32,31,-1,189,32,252,-1,170,46,237,-1,42,46,170,-1,182,189,252,-1,182,183,189,-1,240,83,82,-1,83,240,179,-1,196,252,197,-1,182,252,196,-1,58,172,167,-1,105,172,58,-1,180,179,178,-1,180,83,179,-1,177,28,68,-1,177,234,28,-1,63,121,120,-1,121,63,181,-1,120,62,63,-1,120,160,62,-1,253,159,245,-1,159,253,161,-1,99,14,92,-1,99,96,14,-1,127,254,132,-1,255,254,127,-1,256,245,171,-1,245,256,253,-1,243,254,174,-1,243,257,254,-1,256,200,128,-1,256,154,200,-1,244,257,243,-1,244,258,257,-1,130,246,133,-1,130,259,246,-1,154,227,200,-1,154,155,227,-1,258,242,260,-1,244,242,258,-1,109,259,261,-1,259,109,246,-1,149,227,155,-1,149,199,227,-1,241,260,242,-1,241,262,260,-1,107,261,263,-1,261,107,109,-1,148,199,149,-1,148,147,199,-1,262,251,263,-1,262,142,251,-1,250,148,108,-1,250,146,148,-1,249,251,225,-1,251,249,248,-1,143,224,144,-1,224,143,223,-1,221,138,264,-1,221,140,138,-1,222,264,247,-1,222,221,264,-1,264,135,146,-1,264,138,135,-1,247,146,250,-1,247,264,146,-1,263,248,107,-1,263,251,248,-1,145,262,241,-1,145,142,262,-1,263,260,262,-1,260,263,261,-1,8,226,150,-1,8,198,226,-1,106,155,153,-1,106,149,155,-1,260,259,258,-1,260,261,259,-1,258,130,257,-1,258,259,130,-1,176,151,265,-1,6,151,176,-1,171,154,256,-1,171,152,154,-1,257,132,254,-1,257,130,132,-1,92,265,99,-1,92,176,265,-1,128,253,256,-1,253,128,95,-1,255,174,254,-1,175,174,255,-1,95,161,253,-1,161,95,94,-1,127,126,91,-1,127,156,126,-1,125,175,255,-1,124,175,125,-1,94,160,161,-1,160,94,62,-1,89,125,90,-1,122,125,89,-1,160,102,158,-1,160,120,102,-1,105,60,104,-1,58,60,105,-1,73,79,71,-1,76,79,73,-1,166,80,58,-1,48,80,166,-1,197,31,173,-1,197,252,31,-1,55,236,101,-1,235,236,55,-1,37,44,38,-1,44,37,47,-1,39,190,169,-1,39,238,190,-1,57,235,55,-1,57,187,235,-1,126,158,123,-1,126,159,158,-1,249,222,247,-1,222,249,4,-1,250,107,248,-1,108,107,250,-1,246,106,153,-1,106,246,109,-1,245,126,156,-1,245,159,126,-1,123,102,104,-1,102,123,158,-1,100,265,174,-1,100,99,265,-1,244,226,242,-1,150,226,244,-1,151,174,265,-1,174,151,243,-1,90,255,127,-1,125,255,90,-1,98,124,122,-1,98,97,124,-1,233,75,26,-1,75,233,81,-1,237,48,166,-1,46,48,237,-1,59,157,60,-1,59,70,157,-1,82,163,240,-1,164,163,82,-1,87,81,233,-1,87,86,81,-1,78,177,79,-1,78,84,177,-1,165,77,76,-1,117,77,165,-1,80,64,70,-1,80,178,64,-1,69,73,74,-1,69,66,73,-1,35,53,52,-1,35,34,53,-1,192,190,238,-1,192,51,190,-1,53,22,19,-1,53,112,22,-1,113,18,15,-1,113,40,18,-1,231,111,110,-1,231,230,111,-1,40,54,18,-1,40,41,54,-1,38,238,39,-1,238,38,239,-1,237,235,170,-1,236,235,237,-1,173,105,103,-1,105,173,172,-1,234,26,28,-1,233,26,234,-1,25,15,232,-1,113,15,25,-1,33,191,195,-1,191,33,35,-1,20,229,231,-1,20,22,229,-1,17,232,15,-1,17,230,232,-1,18,228,16,-1,228,18,54,-1,227,7,200,-1,227,8,7,-1};
			return value;
		}
		private int[] getrrib11_Geo_6_180_coordIndex_3()
		{
			int[] value = {216,212,213,-1,216,214,212,-1,225,4,249,-1,5,4,225,-1,224,0,5,-1,224,220,0,-1,223,201,203,-1,141,201,223,-1,217,140,221,-1,217,219,140,-1,4,218,222,-1,4,2,218,-1,220,3,0,-1,220,215,3,-1,209,219,217,-1,209,211,219,-1,2,210,218,-1,2,1,210,-1,216,3,215,-1,216,207,3,-1,214,204,212,-1,204,214,202,-1,213,209,205,-1,209,213,211,-1,210,206,208,-1,1,206,210,-1,213,207,216,-1,213,205,207,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib11_Coord_7_180_point_1()
		{
			double[] value = {-4.57109,41.02802,.11898,-4.57537,41.09058,.15078,-4.58965,41.10567,.15269,-4.54566,41.03629,.12667,-4.6575,41.22671,-.20915,-4.61708,41.13507,-.26108,-3.5559,42.27976,-2.78086,-3.6073,42.33199,-2.73919,-3.99481,42.01164,-2.20712,-1.84741,43.16801,-3.65266,-1.34842,43.35779,-3.53606,-1.86565,43.17418,-3.61828,-1.88377,43.18017,-3.58449,-2.24446,43.03444,-3.52789,-2.20713,43.01352,-3.59061,-.66728,43.3939,-2.57551,-.63895,43.36057,-2.62263,-.66956,43.40992,-2.59014,-.64584,43.35235,-2.60157,-.71196,43.25516,-2.5537,-.74503,43.34882,-2.53569,-.72086,43.25432,-2.56045,-.72869,43.34583,-2.52867,-.6896,43.36378,-2.52789,-.68435,43.32107,-2.53556,-.67734,43.37595,-2.54378,-.89427,43.34768,-3.12007,-.93283,43.33241,-3.15751,-.92106,43.33405,-3.17437,-.90335,43.34304,-3.10044,-.91973,43.56453,-2.7452,-1.04728,43.63038,-2.94824,-.92583,43.55022,-2.7419,-.65298,43.2668,-2.6202,-.67467,43.28641,-2.57707,-.66605,43.25032,-2.60248,-.83229,43.41868,-3.09587,-.82674,43.43863,-3.09695,-.71396,43.35492,-2.87863,-.72791,43.33525,-2.88092,-.65752,43.33923,-2.57364,-.66589,43.30638,-2.57864,-.73876,43.44008,-2.87911,-.66253,43.41406,-2.74312,-.72355,43.40019,-2.87708,-.65496,43.36119,-2.74656,-.84648,43.48501,-3.07863,-.83402,43.47387,-3.08871,-.91307,43.53204,-3.18625,-.73072,43.25096,-2.58535,-.68489,43.22486,-2.58528,-.68171,43.21737,-2.62153,-.68483,43.23703,-2.5738,-.69292,43.28256,-2.54438,-.65665,43.29751,-2.60969,-.90143,43.57533,-2.75681,-.8018,43.50477,-2.63197,-.78017,43.51143,-2.6488,-1.1122,43.62778,-3.22109,-1.07325,43.57667,-3.32255,-1.52543,43.60173,-3.5896,-1.37807,43.3205,-3.47845,-1.9232,43.19951,-3.53308,-1.39921,43.32037,-3.45864,-1.01378,43.51391,-3.42315,-.95641,43.48004,-3.42482,-1.02593,43.48641,-3.45546,-.97729,43.32186,-3.20682,-.96655,43.32047,-3.21936,-1.051,43.49087,-3.47091,-1.03608,43.52475,-3.42264,-1.08866,43.33964,-3.37962,-1.12425,43.34705,-3.38278,-1.04264,43.39781,-3.47157,-1.08819,43.40252,-3.49371,-.82392,43.42938,-3.11744,-.98751,43.37157,-3.45308,-.97377,43.36443,-3.43763,-.99084,43.31824,-3.38233,-1.01392,43.31613,-3.38364,-1.00174,43.57065,-3.28899,-.81439,43.41126,-3.14597,-.82783,43.46733,-3.25926,-.86783,43.502,-3.23393,-.90224,43.32164,-3.2661,-.87206,43.38368,-3.31535,-.81486,43.40596,-3.16414,-.85889,43.34872,-3.17111,-2.05062,43.41508,-3.67587,-1.97708,43.35843,-3.69671,-2.37102,43.20964,-3.69271,-2.44407,43.25411,-3.65538,-2.61108,42.83789,-3.47133,-2.66648,42.88209,-3.42066,-2.29698,43.0748,-3.49427,-2.71365,42.91241,-3.38213,-2.15093,42.95989,-3.61826,-2.15124,42.95844,-3.6461,-1.84471,43.18489,-3.68946,-2.52449,42.7836,-3.51358};
			return value;
		}
		private double[] getrrib11_Coord_7_180_point_2()
		{
			double[] value = {-2.51902,42.76809,-3.55492,-1.0331,43.65056,-2.95412,-1.62829,43.62132,-3.49313,-1.21892,43.65499,-3.16348,-1.60082,43.6356,-3.53618,-1.1932,43.67098,-3.18117,-4.3666,42.07035,-1.83384,-4.51783,41.81415,-1.4098,-4.48486,41.83089,-1.38947,-4.38628,42.05813,-1.86188,-.74584,43.46676,-2.55769,-.70915,43.46471,-2.58177,-.70436,43.33133,-2.52835,-.66645,43.36437,-2.55737,-.76435,43.35869,-2.5577,-.74735,43.26626,-2.6869,-.80758,43.37248,-2.63482,-.89929,43.43042,-3.41007,-1.35807,43.46319,-3.62692,-1.3435,43.39575,-3.58185,-1.55379,43.47642,-3.44383,-1.13474,43.47064,-3.15717,-1.90264,43.30024,-3.72107,-2.14222,43.46128,-3.63143,-2.22061,43.05956,-3.69706,-2.28896,43.14815,-3.72474,-2.55981,43.29576,-3.58521,-2.91305,42.99419,-3.51148,-2.99076,42.7706,-3.21523,-2.91829,42.75353,-3.29057,-3.84126,42.47113,-2.78917,-3.39047,42.91488,-3.21785,-3.26313,42.84798,-3.32678,-3.90033,42.58206,-2.70423,-4.32773,41.64155,-1.52595,-4.44517,41.46081,-1.09193,-4.25604,41.54645,-1.56887,-4.3849,41.36043,-1.15382,-4.48642,41.31495,-.73821,-4.45817,41.22757,-.80174,-4.51999,41.17254,-.32173,-4.4664,41.09349,-.36735,-4.51941,41.38446,-1.11259,-4.47491,41.20444,-.8074,-4.56953,41.21595,-.74551,-4.40921,41.33753,-1.16744,-4.5099,41.53869,-.99796,-4.34,41.68833,-1.48098,-4.41115,41.75672,-1.43598,-4.2798,41.99747,-1.84167,-3.85783,41.92257,-2.36556,-3.50042,42.21607,-2.81949,-3.88475,42.59418,-2.68181,-4.21284,42.28544,-2.15155,-3.77463,42.51242,-2.66454,-4.14475,42.1775,-2.13285,-3.05016,43.08074,-3.41698,-1.4393,43.54766,-3.62866,-2.16272,43.4423,-3.56246,-2.55445,43.2861,-3.53694,-2.04144,43.29942,-3.51814,-2.42089,43.17247,-3.47721,-.87303,43.3353,-3.22273,-.86422,43.46015,-3.34944,-.82621,43.452,-3.26367,-.91051,43.44137,-3.42465,-.99508,43.57346,-3.13623,-1.03691,43.60846,-3.10622,-.89119,43.3269,-3.03569,-.79492,43.28299,-2.84618,-.77691,43.46881,-2.85427,-3.38157,42.91552,-3.17859,-1.11176,43.66172,-3.06825,-1.13365,43.64954,-3.05518,-2.81404,42.61676,-3.41483,-2.59274,42.79689,-3.57834,-2.88994,42.69951,-3.3139,-.92053,43.31702,-3.25131,-.97788,43.5572,-3.30132,-.90277,43.51166,-3.33187,-.89542,43.52041,-3.205,-.9987,43.33519,-3.19705,-.90875,43.3372,-3.02037,-.81584,43.28929,-2.8318,-.93756,43.3243,-3.12083,-.6817,43.4386,-2.61476,-.63248,43.37032,-2.65275,-.73262,43.46913,-2.68066,-.809,43.46942,-2.62995,-.89279,43.40982,-2.77009,-.71596,43.24362,-2.71345,-.65675,43.24256,-2.62397,-.64779,43.25902,-2.6765,-.63614,43.31982,-2.66323,-.63592,43.27713,-2.67551,-.64334,43.27054,-2.64297,-.95852,43.33618,-3.10744,-1.06092,43.46535,-3.07148,-4.15145,41.86006,-1.93049,-4.18022,41.91298,-1.87679};
			return value;
		}
		private double[] getrrib11_Coord_7_180_point_3()
		{
			double[] value = {-3.63507,42.37988,-2.66206,-4.43927,40.98534,.01383,-4.4611,40.97917,.03815,-4.44707,40.9705,.00983,-4.45773,40.9907,.03721,-4.52665,41.0816,.07826,-4.56553,41.0873,.10777,-4.54248,41.05134,.08211,-4.5561,41.09874,.10384,-4.51968,41.07233,.11834,-4.56759,41.10168,.1518,-4.49447,41.04582,.09345,-4.48237,41.01751,.0295,-4.50169,41.052,.05279,-4.48424,41.00686,.02932,-4.51186,40.99416,.09254,-4.51942,41.02119,.05788,-4.5199,41.09249,.11908,-4.57608,41.11856,.15514,-4.48428,41.05606,.08731,-4.52621,40.98321,.08256,-4.5671,41.22458,-.25232,-4.62821,41.24934,-.19544,-4.47894,41.07614,-.37527,-4.55721,41.08346,-.31052,-4.63453,41.27031,-.69171,-4.05197,41.76029,-2.01473,-4.03904,42.06306,-2.12286,-.64644,43.30601,-2.63252,-.71242,43.42373,-2.52585,-.69743,43.44054,-2.55658,-.72541,43.44042,-2.52989,-.69509,43.42662,-2.54512,-.87146,43.34479,-3.1477,-.88743,43.33105,-3.2041,-.85212,43.53475,-2.80009,-.96441,43.5877,-2.98983,-.90791,43.52952,-3.03084,-.66556,43.29842,-2.76207,-.65195,43.31787,-2.76164,-.87002,43.47618,-3.35225,-4.28269,41.52606,-1.58669,-4.0694,41.74869,-2.03844,-3.50241,42.2137,-2.85278,-3.87253,41.91535,-2.39544,-3.03549,43.07916,-3.37083,-4.23957,42.26249,-2.18248,-4.63554,41.42197,-.60267,-4.62308,41.56589,-.9432,-4.6708,41.39056,-.60809,-4.58727,41.59592,-.93547,-4.58827,41.45121,-1.0649,-.98963,43.46005,-2.98463,-2.88886,43.0059,-3.34017,-3.04305,42.7286,-3.39712,-2.76927,42.91934,-3.57923,-3.21797,42.83845,-3.16174,-3.67414,42.29859,-2.82374,-4.02837,42.01302,-2.35037,-4.16899,42.14414,-2.27868,-4.24421,41.82495,-1.9813,-4.34995,41.91275,-1.92802,-4.42151,41.60132,-1.521,-4.48844,41.67557,-1.49166,-4.54416,41.38107,-.67504,-2.80852,42.61894,-3.36688};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrrib12_Geo_6_185_coordIndex_1()
		{
			int[] value = {0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,12,13,14,-1,14,15,12,-1,16,17,18,-1,19,20,21,-1,21,22,19,-1,23,24,25,-1,23,26,24,-1,27,28,26,-1,26,23,27,-1,29,30,31,-1,31,32,29,-1,0,33,34,-1,33,35,34,-1,36,37,38,-1,37,28,38,-1,39,2,40,-1,41,37,42,-1,43,22,21,-1,21,44,43,-1,45,46,47,-1,46,48,47,-1,49,50,51,-1,50,52,51,-1,53,54,55,-1,54,56,55,-1,57,58,59,-1,59,3,57,-1,49,60,61,-1,49,51,60,-1,62,63,64,-1,62,65,63,-1,66,67,68,-1,66,69,67,-1,70,71,5,-1,71,72,5,-1,73,74,75,-1,73,76,74,-1,50,77,78,-1,78,79,50,-1,80,81,82,-1,80,53,81,-1,83,84,4,-1,83,85,84,-1,86,87,88,-1,86,89,87,-1,40,90,29,-1,29,91,40,-1,92,93,94,-1,94,95,92,-1,96,2,39,-1,97,39,42,-1,94,39,95,-1,98,99,39,-1,70,5,4,-1,4,84,70,-1,46,100,101,-1,101,102,46,-1,103,104,45,-1,103,105,104,-1,106,107,108,-1,108,109,106,-1,72,3,5,-1,72,57,3,-1,110,111,112,-1,111,18,112,-1,113,31,30,-1,113,114,31,-1,115,58,116,-1,115,117,58,-1,68,67,118,-1,118,17,68,-1,119,120,121,-1,122,121,48,-1,122,123,121,-1,120,47,48,-1,48,121,120,-1,124,115,66,-1,114,13,111,-1,17,118,25,-1,25,18,17,-1,18,25,24,-1,125,126,27,-1,125,127,126,-1,58,128,59,-1,58,117,128,-1,71,70,104,-1,70,100,104,-1,127,107,129,-1,129,126,127,-1,130,131,132,-1,130,109,131,-1,45,100,46,-1,45,104,100,-1,101,100,84,-1,100,70,84,-1,30,44,21,-1,21,113,30,-1,91,98,39,-1,99,95,39,-1,94,42,39,-1,97,96,39,-1,91,32,98,-1,91,29,32,-1,97,33,96,-1,97,36,33,-1,88,133,134,-1,88,87,133,-1,89,135,87,-1,89,85,135,-1,133,136,137,-1,133,138,136,-1,10,139,140,-1,140,141,10,-1,122,142,123,-1,142,143,123,-1,80,144,53,-1,144,54,53,-1,145,77,49,-1,77,50,49,-1,63,146,8,-1,63,65,146,-1,147,148,149,-1,147,150,148,-1,149,151,147,-1,149,152,151,-1,125,27,23,-1,134,153,88,-1,134,79,153,-1,4,3,154,-1,3,59,154,-1,81,53,83,-1,53,55,83,-1,155,156,157,-1,156,158,157,-1,73,65,62,-1,73,159,65,-1,160,52,137,-1,160,51,52,-1,103,45,151,-1,45,47,151,-1,39,40,91,-1,40,161,90,-1,26,37,41,-1,26,28,37,-1,29,90,30,-1,90,44,30,-1,24,112,18,-1,130,20,19,-1,146,6,8,-1,146,61,6,-1,13,162,14,-1,111,13,12,-1,139,163,164,-1,63,165,64,-1,162,13,114,-1,166,34,167,-1,166,0,34,-1,1,0,166,-1,8,165,63,-1,165,8,7,-1,9,139,10,-1,163,139,9,-1,9,158,163,-1,158,9,157,-1,156,165,7,-1,155,165,156,-1,164,61,60,-1,61,164,6,-1,44,161,43,-1,44,90,161,-1,41,24,26,-1,41,93,24,-1,92,110,112,-1,92,168,110,-1,152,103,151,-1,152,132,103,-1,122,86,142,-1,122,102,86,-1,20,169,170,-1,20,130,169,-1,171,137,136,-1,171,160,137,-1,172,73,62,-1,76,73,172,-1,23,118,125,-1,23,25,118,-1,62,11,172,-1,62,64,11,-1,83,154,81,-1,154,83,4,-1,173,69,116,-1,173,174,69,-1,67,125,118,-1,175,125,67,-1,103,131,105,-1,132,131,103,-1,176,177,178,-1,177,176,179,-1,180,17,16,-1,180,68,17,-1,11,141,172,-1,141,11,10,-1,61,145,49,-1,146,145,61,-1,77,159,181,-1,77,145,159,-1,144,75,54,-1,144,181,75,-1,182,144,80,-1,78,144,182,-1,143,153,182,-1,143,142,153,-1,82,123,143,-1,123,82,183,-1,56,135,55,-1,56,138,135,-1,172,171,76,-1,172,141,171,-1,160,141,140,-1,160,171,141,-1,87,138,133,-1,87,135,138,-1,101,85,89,-1,101,84,85,-1,134,137,52,-1,134,133,137,-1,0,96,33,-1,96,0,2,-1,36,42,37,-1,42,36,97,-1,168,98,32,-1,98,168,99,-1,126,35,38,-1,129,35,126,-1,22,166,167,-1,22,43,166,-1,130,106,109,-1,19,106,130,-1,107,167,129,-1,107,106,167,-1,177,109,108,-1,109,177,131,-1,71,105,179,-1,71,104,105,-1,57,176,173,-1,176,57,72,-1};
			return value;
		}
		private int[] getrrib12_Geo_6_185_coordIndex_2()
		{
			int[] value = {127,175,184,-1,175,127,125,-1,38,27,126,-1,28,27,38,-1,111,16,18,-1,111,12,16,-1,162,113,170,-1,162,114,113,-1,15,16,12,-1,15,180,16,-1,115,148,150,-1,115,124,148,-1,14,148,15,-1,149,148,14,-1,147,47,120,-1,47,147,151,-1,150,117,115,-1,119,117,150,-1,121,183,128,-1,121,123,183,-1,128,119,121,-1,128,117,119,-1,147,119,150,-1,119,147,120,-1,149,169,152,-1,149,14,169,-1,15,124,180,-1,148,124,15,-1,170,14,162,-1,14,170,169,-1,116,66,115,-1,66,116,69,-1,128,154,59,-1,128,183,154,-1,31,111,110,-1,31,114,111,-1,174,184,175,-1,174,178,184,-1,178,108,184,-1,178,177,108,-1,107,184,108,-1,107,127,184,-1,167,19,22,-1,167,106,19,-1,167,35,129,-1,167,34,35,-1,95,168,92,-1,99,168,95,-1,93,42,94,-1,93,41,42,-1,40,1,161,-1,40,2,1,-1,102,89,86,-1,102,101,89,-1,140,51,160,-1,51,140,60,-1,74,138,56,-1,74,136,138,-1,55,85,83,-1,55,135,85,-1,183,81,154,-1,183,82,81,-1,80,143,182,-1,80,82,143,-1,182,79,78,-1,182,153,79,-1,181,78,77,-1,78,181,144,-1,181,73,75,-1,181,159,73,-1,145,65,159,-1,145,146,65,-1,72,179,176,-1,71,179,72,-1,180,66,68,-1,124,66,180,-1,178,173,176,-1,178,174,173,-1,131,179,105,-1,131,177,179,-1,174,67,69,-1,67,174,175,-1,116,57,173,-1,57,116,58,-1,74,54,75,-1,54,74,56,-1,79,52,50,-1,79,134,52,-1,76,136,74,-1,76,171,136,-1,88,142,86,-1,153,142,88,-1,48,102,122,-1,46,102,48,-1,130,152,169,-1,130,132,152,-1,170,21,20,-1,170,113,21,-1,93,112,24,-1,93,92,112,-1,35,36,38,-1,33,36,35,-1,43,1,166,-1,161,1,43,-1,110,32,31,-1,168,32,110,-1,139,60,140,-1,60,139,164,-1,163,156,7,-1,156,163,158,-1,155,9,165,-1,157,9,155,-1,163,6,164,-1,7,6,163,-1,64,9,11,-1,9,64,165,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrrib12_Coord_7_185_point_1()
		{
			double[] value = {-.74565,42.11216,-2.2474,-.73632,42.05952,-2.23836,-.72356,42.07273,-2.31289,-2.5154,41.51473,-2.71186,-2.90254,41.2335,-2.39085,-2.50768,41.50545,-2.66599,-3.2419,40.12141,-1.00771,-3.25704,40.1267,-1.00491,-3.24798,40.12143,-1.01104,-3.34475,40.2206,-1.00549,-3.34277,40.23259,-1.00541,-3.36385,40.24894,-1.01695,-.82627,42.03835,-2.86811,-.83135,42.00225,-2.79373,-1.18602,41.93753,-2.83356,-1.13711,41.96349,-2.9256,-.88167,42.14247,-2.92408,-.95378,42.21781,-2.92713,-.77119,42.26707,-2.82998,-1.03231,42.0092,-2.60807,-1.01929,41.97257,-2.60858,-.84136,41.93817,-2.47682,-.87197,41.99442,-2.41942,-.79704,42.35586,-2.78444,-.70807,42.35731,-2.75863,-.78383,42.32741,-2.81642,-.72007,42.38925,-2.69494,-.83176,42.38353,-2.74375,-.74087,42.40111,-2.62871,-.68145,41.90279,-2.52537,-.70835,41.88285,-2.53391,-.72005,41.96081,-2.70927,-.69645,41.98063,-2.6819,-.76156,42.2262,-2.35525,-.78159,42.11839,-2.22976,-.79604,42.24026,-2.36123,-.69949,42.36034,-2.52603,-.69756,42.37344,-2.58117,-.74468,42.39792,-2.56132,-.72321,42.10295,-2.45114,-.69245,41.97843,-2.37624,-.69244,42.35754,-2.65477,-.71252,42.28761,-2.56326,-.74658,41.93867,-2.27561,-.72177,41.89695,-2.35534,-1.81319,41.64692,-2.79174,-2.40078,41.24267,-2.57509,-1.8038,41.62075,-2.82999,-2.40897,41.2243,-2.61338,-3.20264,40.15954,-1.05634,-3.1681,40.24495,-1.25659,-3.19481,40.18159,-1.0575,-3.15939,40.25685,-1.2324,-3.24204,40.82463,-1.90735,-3.33176,40.63703,-1.60851,-3.22975,40.84827,-1.88644,-3.31421,40.65711,-1.58987,-1.88828,41.85119,-2.99553,-1.88834,41.82649,-3.03712,-2.52634,41.50273,-2.73309,-3.21269,40.14933,-1.00477,-3.22417,40.13488,-1.02709,-3.38304,40.28066,-1.067,-3.36338,40.22083,-1.03416,-3.37091,40.2337,-1.03356,-3.36687,40.24406,-1.07035,-1.38656,42.05835,-3.02536,-1.18695,42.18138,-2.98925,-1.17682,42.15358,-2.97462,-1.38107,42.10497,-3.03327,-2.48342,41.45626,-2.60944,-1.9151,41.79786,-2.84449,-1.94251,41.83839,-2.91132,-3.38982,40.33785,-1.1381,-3.37107,40.4694,-1.27762,-3.38534,40.45241,-1.29183,-3.38164,40.34712,-1.11765,-3.21666,40.23253,-1.26808,-3.19151,40.43587,-1.59294,-3.11375,40.41088,-1.57637,-3.22227,40.79549,-1.94172,-3.13177,41.01566,-2.16989,-3.08551,40.93124,-2.19853,-3.1235,41.02187,-2.13575,-2.83036,41.17847,-2.37649,-3.05465,40.94765,-2.07709,-2.8904,40.74792,-2.06238,-3.08882,40.71302,-1.86044,-2.99494,40.61581,-1.85962,-2.97576,40.85378,-2.04568,-.68856,41.9101,-2.35886,-.69681,41.9706,-2.50581,-.70321,42.23886,-2.74686,-.68214,42.33055,-2.71005,-.70031,42.25559,-2.63704,-.70497,42.19109,-2.65758,-.74524,42.16785,-2.34522,-.71683,42.27715,-2.48632,-.69743,42.0162,-2.61756,-.69815,42.09707,-2.64225};
			return value;
		}
		private double[] getrrib12_Coord_7_185_point_2()
		{
			double[] value = {-2.436,41.31847,-2.56684,-2.7389,41.08137,-2.34185,-2.68222,40.99471,-2.343,-1.54998,41.79711,-2.80974,-1.8613,41.71842,-2.80355,-1.59056,41.86383,-2.78653,-1.06196,42.07341,-2.60616,-1.06431,42.18555,-2.68662,-1.28833,42.12308,-2.73637,-1.26094,42.01297,-2.67724,-.70337,42.10855,-2.77935,-.74117,42.10427,-2.77598,-.72736,42.24894,-2.79386,-.8272,41.91761,-2.55402,-.76799,41.9602,-2.71152,-1.56983,41.95556,-3.05984,-1.549,42.00996,-3.06248,-1.88153,41.757,-3.01053,-.96464,42.25214,-2.92952,-1.85782,41.66684,-2.96288,-1.8337,41.6376,-2.9183,-2.45667,41.25041,-2.68402,-2.69441,40.9727,-2.37116,-2.74959,41.00338,-2.42814,-1.35297,41.99625,-3.03011,-.99006,42.28853,-2.87788,-.87477,42.36598,-2.67229,-1.04808,42.28161,-2.79004,-2.49048,41.37026,-2.75194,-.92076,42.26323,-2.53822,-1.22359,41.95031,-2.6781,-1.39807,41.953,-2.72622,-1.36126,41.89722,-2.74368,-3.17252,40.52192,-1.53738,-3.10213,40.42034,-1.5449,-3.1575,40.7914,-1.86118,-3.30206,40.42743,-1.24666,-3.22223,40.36341,-1.22636,-3.24495,40.60569,-1.56034,-3.24566,40.15331,-.98731,-3.25391,40.20399,-1.01064,-3.33691,40.26208,-1.02939,-2.9012,40.73473,-2.08818,-2.97524,40.787,-2.15186,-3.30743,40.57921,-1.59929,-3.23277,40.15659,-1.10251,-3.24367,40.12891,-1.03987,-1.56275,41.79083,-2.93538,-1.33173,41.89863,-2.97399,-1.33737,41.88209,-2.88485,-1.5614,41.81094,-2.99335,-1.55168,41.77141,-2.86173,-1.35114,41.87898,-2.81347,-3.00468,40.5997,-1.88614,-2.90993,41.22914,-2.41531,-3.33137,40.20563,-1.02713,-3.2696,40.15075,-1.01867,-3.32753,40.21275,-1.01905,-3.2644,40.15825,-1.00602,-3.36232,40.2935,-1.13632,-3.24978,40.2549,-1.06431,-.71207,41.94406,-2.29085,-.90162,41.97626,-2.74403,-3.24916,40.13806,-.98576,-3.23192,40.13509,-.98534,-3.35155,40.20802,-1.01976,-.77217,42.06205,-2.21803,-.92602,42.11453,-2.43541,-.68714,42.10876,-2.74193,-1.19711,41.92809,-2.7656,-.9862,41.94832,-2.65852,-3.32403,40.30649,-1.08199,-3.37649,40.29653,-1.05665,-1.53464,42.06414,-3.00663,-1.3752,42.1408,-2.98895,-1.19118,42.2217,-2.9409,-1.5944,42.04101,-2.94359,-1.43147,42.06455,-2.8017,-1.41859,42.13174,-2.90153,-1.60535,41.97721,-2.8703,-1.14712,42.06581,-2.9796,-3.35394,40.39449,-1.29438,-3.09135,40.64187,-1.90829,-2.84771,41.11786,-2.47024,-1.26395,42.20195,-2.83498};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrcartend_Geo_6_190_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,0,-1,4,5,6,-1,7,8,9,-1,7,10,8,-1,11,6,12,-1,11,4,6,-1,1,13,14,-1,1,5,13,-1,15,16,17,-1,17,18,15,-1,19,20,21,-1,12,22,23,-1,23,11,12,-1,24,25,26,-1,25,27,26,-1,28,29,30,-1,28,31,29,-1,32,33,34,-1,33,35,34,-1,21,20,36,-1,37,38,2,-1,37,39,38,-1,40,41,42,-1,41,8,42,-1,20,43,36,-1,44,45,46,-1,47,48,49,-1,47,50,48,-1,51,45,52,-1,53,54,55,-1,54,56,55,-1,50,44,57,-1,44,56,57,-1,48,57,58,-1,48,50,57,-1,59,60,58,-1,59,61,60,-1,62,63,64,-1,65,66,67,-1,66,68,67,-1,66,65,69,-1,69,70,66,-1,71,72,73,-1,71,74,72,-1,68,75,76,-1,68,77,75,-1,78,79,80,-1,78,81,79,-1,82,83,84,-1,84,85,82,-1,86,87,88,-1,86,89,87,-1,90,91,92,-1,90,93,91,-1,94,95,96,-1,95,97,96,-1,98,92,99,-1,98,90,92,-1,100,78,80,-1,80,101,100,-1,102,85,103,-1,102,82,85,-1,102,103,104,-1,104,101,102,-1,104,98,99,-1,104,94,96,-1,104,103,105,-1,106,107,108,-1,108,109,106,-1,110,111,112,-1,111,113,112,-1,114,115,116,-1,114,117,115,-1,107,106,118,-1,118,119,107,-1,112,120,121,-1,121,122,112,-1,110,112,122,-1,108,123,116,-1,124,125,126,-1,124,127,125,-1,125,128,126,-1,125,129,128,-1,130,131,132,-1,130,133,131,-1,134,135,136,-1,135,137,136,-1,138,125,139,-1,125,127,139,-1,140,141,142,-1,141,143,144,-1,145,141,140,-1,129,141,128,-1,146,124,126,-1,146,126,147,-1,148,149,150,-1,151,152,153,-1,154,155,156,-1,156,157,154,-1,158,159,155,-1,158,160,159,-1,161,162,163,-1,157,164,154,-1,165,157,166,-1,166,167,165,-1,168,149,169,-1,170,171,168,-1,168,172,170,-1,173,174,175,-1,176,177,178,-1,176,179,177,-1,177,180,173,-1,177,179,180,-1,181,182,183,-1,182,184,185,-1,186,165,187,-1,165,167,187,-1,181,188,189,-1,189,190,181,-1,191,192,193,-1,191,194,192,-1,195,196,193,-1,195,197,196,-1,170,152,171,-1,198,199,195,-1,200,201,170,-1,170,172,200,-1,168,169,172,-1,202,152,203,-1,204,171,152,-1,184,197,199,-1,205,161,163,-1,201,206,152,-1,207,152,202,-1,208,172,169,-1,208,194,172,-1,209,210,167,-1,210,187,167,-1,183,160,158,-1,183,185,160,-1,211,212,213,-1,213,214,211,-1,215,216,217,-1,216,218,217,-1,219,220,221,-1,219,222,220,-1,223,224,225,-1,225,226,223,-1,227,228,229,-1,227,221,228,-1,215,219,230,-1,215,217,219,-1,231,232,233,-1,231,234,232,-1,235,236,237,-1,235,238,236,-1,239,240,241,-1,241,242,239,-1,243,244,245,-1,236,246,247,-1,248,249,238,-1,248,250,249,-1,245,251,252,-1,252,253,245,-1,254,255,256,-1,250,257,249,-1,250,258,257,-1,259,260,261,-1,261,262,259,-1,254,260,263,-1,254,257,258,-1,264,265,266,-1,267,265,264,-1,268,269,270,-1,270,271,268,-1,272,266,273,-1,272,264,266,-1,272,274,264,-1,270,275,271,-1,270,276,275,-1,277,278,279,-1,277,280,281,-1,281,282,277,-1,283,284,285,-1,286,271,275,-1,286,287,271,-1,274,285,288,-1,288,289,274,-1,279,290,291,-1,291,292,279,-1,286,288,284,-1,293,294,295,-1,293,296,294,-1,297,298,299,-1,297,300,298,-1,301,302,303,-1,301,304,302,-1,305,306,307,-1,307,308,305,-1,309,310,311,-1,312,313,314,-1,315,316,317,-1,316,318,317,-1,319,312,314,-1,314,320,319,-1,321,322,310,-1,310,323,321,-1,324,325,326,-1,326,327,324,-1,328,329,311,-1,311,330,328,-1,331,332,333,-1,333,334,331,-1,335,336,337,-1,335,338,336,-1,339,340,325,-1,325,324,339,-1,339,341,340,-1,341,309,340,-1,342,313,312,-1,343,344,345,-1,344,346,345,-1,347,348,349,-1,348,350,349,-1,351,352,345,-1,345,346,351,-1,353,354,355,-1,354,356,355,-1,357,354,353,-1,353,358,357,-1,359,360,361,-1,362,352,363,-1,363,364,362,-1,365,366,367,-1,368,361,350,-1,350,369,368,-1,370,362,365,-1,368,359,361,-1,359,368,357,-1,371,372,373,-1,372,374,373,-1,375,376,377,-1,376,378,377,-1,379,380,381,-1,382,383,384,-1,385,386,387,-1,388,389,378,-1,390,391,392,-1,393,394,395,-1};
			return value;
		}
		private int[] getrcartend_Geo_6_190_coordIndex_2()
		{
			int[] value = {395,396,393,-1,397,398,399,-1,399,400,397,-1,401,402,403,-1,401,404,402,-1,405,406,407,-1,405,408,406,-1,409,390,372,-1,410,388,378,-1,378,376,410,-1,411,378,389,-1,412,413,414,-1,412,415,413,-1,416,417,418,-1,419,420,421,-1,421,422,419,-1,423,424,425,-1,426,427,428,-1,426,429,427,-1,430,431,432,-1,430,433,431,-1,430,434,428,-1,430,435,434,-1,436,437,416,-1,437,438,416,-1,439,414,440,-1,439,412,414,-1,422,435,441,-1,441,442,422,-1,443,425,424,-1,444,440,445,-1,440,417,445,-1,446,447,448,-1,446,449,447,-1,450,448,451,-1,448,447,451,-1,452,453,454,-1,454,455,452,-1,456,457,458,-1,456,459,457,-1,460,461,462,-1,460,463,461,-1,457,446,448,-1,448,461,457,-1,464,452,465,-1,464,466,452,-1,467,468,469,-1,467,470,468,-1,471,472,473,-1,471,474,472,-1,475,476,477,-1,475,478,476,-1,479,480,481,-1,479,482,480,-1,483,484,485,-1,486,487,488,-1,489,490,478,-1,490,476,478,-1,491,492,493,-1,491,494,492,-1,495,496,497,-1,495,491,496,-1,498,490,499,-1,498,476,490,-1,500,472,474,-1,474,501,500,-1,470,502,468,-1,470,503,502,-1,482,504,480,-1,482,505,504,-1,506,507,508,-1,505,509,506,-1,505,510,509,-1,511,512,513,-1,499,492,494,-1,496,514,515,-1,496,516,514,-1,499,490,492,-1,502,517,501,-1,502,518,517,-1,518,519,520,-1,516,521,520,-1,520,514,516,-1,516,493,513,-1,513,521,516,-1,522,523,524,-1,525,526,527,-1,528,488,487,-1,487,529,528,-1,530,531,532,-1,532,533,530,-1,534,535,536,-1,534,537,535,-1,538,539,540,-1,540,541,538,-1,542,543,544,-1,544,545,542,-1,546,547,530,-1,530,533,546,-1,548,549,550,-1,550,540,548,-1,546,551,552,-1,488,553,554,-1,554,486,488,-1,555,523,522,-1,556,534,557,-1,552,544,547,-1,558,550,549,-1,549,545,558,-1,559,560,561,-1,552,547,546,-1,552,551,562,-1,540,550,541,-1,550,563,541,-1,563,538,541,-1,563,529,538,-1,549,542,545,-1,549,537,542,-1,564,538,565,-1,564,539,538,-1,526,534,527,-1,534,556,527,-1,555,522,532,-1,513,492,511,-1,492,513,493,-1,506,509,507,-1,505,506,504,-1,468,501,474,-1,468,502,501,-1,472,489,478,-1,472,500,489,-1,497,515,566,-1,497,496,515,-1,567,568,569,-1,569,570,567,-1,571,510,572,-1,571,573,510,-1,564,574,575,-1,536,557,534,-1,576,482,479,-1,479,577,576,-1,469,474,471,-1,469,468,474,-1,477,498,578,-1,477,476,498,-1,579,566,580,-1,579,497,566,-1,581,570,582,-1,581,567,570,-1,583,572,584,-1,583,571,572,-1,585,576,577,-1,585,586,576,-1,587,446,457,-1,457,459,587,-1,588,589,590,-1,590,591,588,-1,592,593,589,-1,589,588,592,-1,453,466,594,-1,453,452,466,-1,595,592,588,-1,588,596,595,-1,454,453,456,-1,453,459,456,-1,465,452,455,-1,455,597,465,-1,593,598,589,-1,593,599,598,-1,587,449,446,-1,587,600,449,-1,463,596,601,-1,463,460,596,-1,413,418,417,-1,440,414,417,-1,424,426,443,-1,602,373,603,-1,373,374,603,-1,375,433,376,-1,375,431,433,-1,444,439,440,-1,444,604,439,-1,434,421,443,-1,421,425,443,-1,410,429,605,-1,410,427,429,-1,415,606,413,-1,606,418,413,-1,428,433,430,-1,428,427,433,-1,429,426,424,-1,421,420,425,-1,420,423,425,-1,413,417,414,-1,390,392,372,-1,409,411,390,-1,411,389,390,-1,401,403,607,-1,607,608,401,-1,609,404,610,-1,609,402,404,-1,406,408,611,-1,611,612,406,-1,613,612,614,-1,613,406,612,-1,408,401,611,-1,408,404,401,-1,615,616,388,-1,388,617,615,-1,388,616,389,-1,392,374,372,-1,392,437,374,-1,618,602,603,-1,619,598,620,-1,619,621,598,-1,622,621,619,-1,622,623,621,-1,378,411,624,-1,624,377,378,-1,625,409,372,-1,372,371,625,-1,367,370,365,-1,354,368,369,-1,354,357,368,-1,362,364,365,-1,361,360,349,-1,349,350,361,-1,357,358,359,-1,626,343,627,-1,626,344,343,-1,363,351,628,-1,363,352,351,-1,363,347,349,-1,363,628,347,-1,333,332,629,-1,339,304,630,-1,630,341,339,-1,631,632,319,-1,632,633,319,-1,634,338,635,-1,338,335,635,-1,322,321,318,-1,318,316,322,-1,314,313,636,-1,313,629,636,-1,332,636,629,-1,637,341,630,-1,638,304,301,-1,638,630,304,-1,303,302,300,-1};
			return value;
		}
		private int[] getrcartend_Geo_6_190_coordIndex_3()
		{
			int[] value = {300,297,303,-1,299,298,296,-1,296,293,299,-1,295,632,639,-1,295,294,632,-1,640,641,626,-1,626,642,640,-1,278,282,643,-1,279,278,290,-1,288,285,284,-1,281,643,282,-1,281,268,643,-1,287,286,284,-1,274,272,285,-1,272,283,285,-1,277,282,278,-1,292,277,279,-1,292,280,277,-1,268,644,269,-1,268,281,644,-1,289,264,274,-1,264,645,267,-1,258,261,254,-1,254,256,257,-1,254,263,255,-1,254,261,260,-1,247,246,251,-1,251,245,247,-1,238,246,236,-1,238,249,246,-1,259,241,240,-1,646,645,647,-1,236,648,237,-1,242,649,650,-1,242,241,649,-1,651,238,235,-1,651,248,238,-1,652,653,224,-1,653,654,224,-1,655,656,216,-1,656,218,216,-1,230,221,227,-1,230,219,221,-1,228,224,223,-1,228,652,224,-1,657,233,656,-1,233,658,656,-1,217,218,659,-1,218,660,659,-1,226,661,662,-1,661,663,662,-1,185,183,182,-1,210,198,664,-1,198,192,664,-1,664,208,186,-1,151,665,152,-1,201,152,170,-1,163,209,666,-1,184,196,197,-1,184,182,196,-1,198,210,199,-1,208,169,149,-1,149,148,208,-1,667,153,152,-1,665,203,152,-1,203,179,202,-1,179,176,202,-1,668,669,206,-1,206,670,668,-1,199,197,195,-1,206,201,670,-1,201,200,670,-1,152,206,669,-1,195,193,192,-1,192,198,195,-1,671,193,196,-1,671,191,193,-1,664,187,210,-1,184,162,185,-1,162,160,185,-1,664,186,187,-1,176,150,672,-1,176,178,150,-1,673,149,168,-1,673,672,149,-1,672,150,149,-1,674,675,676,-1,190,189,668,-1,668,670,190,-1,155,154,677,-1,666,205,163,-1,678,679,675,-1,680,681,153,-1,681,151,153,-1,682,676,680,-1,676,675,680,-1,152,669,667,-1,173,175,177,-1,143,141,683,-1,138,134,140,-1,140,142,138,-1,141,144,128,-1,141,145,683,-1,142,141,129,-1,142,129,138,-1,129,125,138,-1,133,130,136,-1,136,137,133,-1,131,684,132,-1,684,685,132,-1,135,134,138,-1,138,139,135,-1,128,144,685,-1,685,126,128,-1,113,111,123,-1,111,116,123,-1,111,114,116,-1,121,120,119,-1,123,686,113,-1,110,122,687,-1,108,107,686,-1,686,123,108,-1,105,688,104,-1,99,100,104,-1,94,104,688,-1,98,104,96,-1,101,104,100,-1,103,86,105,-1,103,85,86,-1,92,78,100,-1,100,99,92,-1,88,87,689,-1,689,95,88,-1,80,83,82,-1,80,79,83,-1,70,690,66,-1,68,66,77,-1,66,690,77,-1,63,691,74,-1,74,71,63,-1,64,67,62,-1,64,65,67,-1,67,68,691,-1,68,76,691,-1,692,60,693,-1,60,61,693,-1,58,694,48,-1,58,60,694,-1,58,57,59,-1,57,695,59,-1,57,56,695,-1,56,54,695,-1,55,696,53,-1,696,697,53,-1,698,699,700,-1,699,701,700,-1,692,693,701,-1,701,699,692,-1,694,702,49,-1,48,694,49,-1,51,46,45,-1,14,37,1,-1,37,2,1,-1,10,703,42,-1,704,705,35,-1,35,33,704,-1,11,23,25,-1,23,27,25,-1,8,10,42,-1,706,40,42,-1,42,43,706,-1,30,22,28,-1,22,12,28,-1,15,18,705,-1,705,704,15,-1,9,41,24,-1,9,8,41,-1,42,703,36,-1,36,43,42,-1,0,6,5,-1,5,1,0,-1,2,38,3,-1,707,708,654,-1,708,707,213,-1,678,173,679,-1,174,173,678,-1,24,709,25,-1,24,41,709,-1,36,16,15,-1,36,703,16,-1,32,19,33,-1,32,710,19,-1,38,711,712,-1,38,39,711,-1,0,31,28,-1,0,3,31,-1,36,704,21,-1,36,15,704,-1,706,37,14,-1,706,713,37,-1,40,14,13,-1,14,40,706,-1,714,712,711,-1,712,714,715,-1,9,716,7,-1,9,717,716,-1,43,713,706,-1,713,43,20,-1,47,702,718,-1,702,47,49,-1,699,702,692,-1,718,702,699,-1,698,718,699,-1,52,718,698,-1,51,698,696,-1,51,52,698,-1,696,46,51,-1,46,696,55,-1,692,694,60,-1,702,694,692,-1,73,719,71,-1,720,719,73,-1,721,722,723,-1,722,721,724,-1,725,726,727,-1,72,726,725,-1,64,69,65,-1,719,69,64,-1,691,62,67,-1,62,691,63,-1,728,725,722,-1,729,725,728,-1,69,720,724,-1,720,69,719,-1,97,689,730,-1,95,689,97,-1,88,105,86,-1,105,88,688,-1,731,121,732,-1,121,731,122,-1,687,731,733,-1,687,122,731,-1,119,686,107,-1,686,119,120,-1,111,687,114,-1,111,110,687,-1,145,130,683,-1,145,136,130,-1,144,132,685,-1,144,143,132,-1};
			return value;
		}
		private int[] getrcartend_Geo_6_190_coordIndex_4()
		{
			int[] value = {669,682,667,-1,682,669,668,-1,674,189,188,-1,674,676,189,-1,679,680,675,-1,679,681,680,-1,157,734,164,-1,165,734,157,-1,180,679,173,-1,180,681,679,-1,158,735,183,-1,736,735,158,-1,181,196,182,-1,181,671,196,-1,670,191,671,-1,670,200,191,-1,680,667,682,-1,667,680,153,-1,203,180,179,-1,665,180,203,-1,207,176,672,-1,202,176,207,-1,152,737,204,-1,152,207,737,-1,199,209,163,-1,209,199,210,-1,192,208,664,-1,192,194,208,-1,188,183,735,-1,188,181,183,-1,205,159,161,-1,205,738,159,-1,739,214,213,-1,740,214,739,-1,740,741,214,-1,226,742,661,-1,225,742,226,-1,708,212,743,-1,213,212,708,-1,744,659,660,-1,659,744,745,-1,658,218,656,-1,658,660,218,-1,233,746,231,-1,746,233,657,-1,657,655,747,-1,657,656,655,-1,663,746,748,-1,663,661,746,-1,228,749,229,-1,228,223,749,-1,222,750,220,-1,222,751,750,-1,752,660,658,-1,752,744,660,-1,654,225,224,-1,654,708,225,-1,214,234,211,-1,214,232,234,-1,753,750,754,-1,753,653,750,-1,739,751,745,-1,739,755,751,-1,741,232,214,-1,741,752,232,-1,247,244,756,-1,247,245,244,-1,649,651,650,-1,649,248,651,-1,757,240,239,-1,757,253,240,-1,259,649,241,-1,259,262,649,-1,255,252,251,-1,255,263,252,-1,256,251,246,-1,251,256,255,-1,758,272,273,-1,272,758,291,-1,280,644,281,-1,644,280,759,-1,287,268,271,-1,287,643,268,-1,284,290,278,-1,284,283,290,-1,278,287,284,-1,278,643,287,-1,639,631,760,-1,639,632,631,-1,761,630,638,-1,761,637,630,-1,762,763,764,-1,762,765,763,-1,766,767,768,-1,767,766,769,-1,770,771,772,-1,770,773,771,-1,774,313,775,-1,774,629,313,-1,776,775,777,-1,774,775,776,-1,327,298,300,-1,298,327,635,-1,634,329,328,-1,634,326,329,-1,770,318,773,-1,770,317,318,-1,315,629,774,-1,315,333,629,-1,633,336,342,-1,336,633,337,-1,776,322,316,-1,776,330,322,-1,320,636,778,-1,314,636,320,-1,324,304,339,-1,324,302,304,-1,331,307,306,-1,307,331,334,-1,337,296,335,-1,337,294,296,-1,323,637,765,-1,637,323,341,-1,779,325,340,-1,325,779,780,-1,634,777,338,-1,328,777,634,-1,311,322,330,-1,311,310,322,-1,348,369,350,-1,348,781,369,-1,627,358,353,-1,627,366,358,-1,352,370,345,-1,352,362,370,-1,624,409,625,-1,624,411,409,-1,622,379,623,-1,380,379,622,-1,782,600,783,-1,782,449,600,-1,381,784,379,-1,785,784,381,-1,786,451,787,-1,786,788,451,-1,789,449,782,-1,447,449,789,-1,617,790,400,-1,617,605,790,-1,444,396,607,-1,444,445,396,-1,392,438,437,-1,392,393,438,-1,394,616,615,-1,391,616,394,-1,608,399,398,-1,608,395,399,-1,608,611,401,-1,608,398,611,-1,393,391,394,-1,393,392,391,-1,407,613,791,-1,406,613,407,-1,402,604,403,-1,402,383,604,-1,611,397,612,-1,611,398,397,-1,606,603,436,-1,618,603,606,-1,614,419,613,-1,419,614,420,-1,374,436,603,-1,374,437,436,-1,415,618,606,-1,385,618,415,-1,443,428,434,-1,428,443,426,-1,614,423,420,-1,614,792,423,-1,791,419,793,-1,791,613,419,-1,438,417,416,-1,445,417,438,-1,424,605,429,-1,424,790,605,-1,460,595,596,-1,460,794,595,-1,463,597,458,-1,601,597,463,-1,600,594,784,-1,594,600,587,-1,466,623,379,-1,464,623,466,-1,590,598,621,-1,589,598,590,-1,593,788,599,-1,593,795,788,-1,794,592,595,-1,794,796,592,-1,591,596,588,-1,601,596,591,-1,594,459,453,-1,594,587,459,-1,462,795,796,-1,450,795,462,-1,465,590,464,-1,590,465,591,-1,796,593,592,-1,795,593,796,-1,584,586,585,-1,584,572,586,-1,571,582,570,-1,582,571,583,-1,566,581,580,-1,566,567,581,-1,495,579,797,-1,495,497,579,-1,498,798,578,-1,498,799,798,-1,800,483,801,-1,484,483,800,-1,482,586,505,-1,576,586,482,-1,569,571,570,-1,569,573,571,-1,515,567,566,-1,515,568,567,-1,802,801,483,-1,802,803,801,-1,506,802,504,-1,802,506,508,-1,804,805,806,-1,804,807,805,-1,569,808,573,-1,569,809,808,-1,519,809,810,-1,519,804,809,-1,807,502,503,-1,502,807,518,-1,573,509,510,-1,573,808,509,-1,508,806,805,-1,508,507,806,-1,532,560,559,-1,532,811,560,-1,522,811,532,-1,524,811,522,-1,553,812,559,-1,813,812,553,-1,536,539,564,-1};
			return value;
		}
		private int[] getrcartend_Geo_6_190_coordIndex_5()
		{
			int[] value = {535,539,536,-1,814,542,526,-1,543,542,814,-1,551,533,812,-1,551,546,533,-1,813,815,562,-1,813,528,815,-1,535,540,539,-1,540,535,548,-1,563,558,815,-1,563,550,558,-1,814,525,816,-1,814,526,525,-1,558,562,815,-1,558,552,562,-1,531,816,817,-1,814,816,531,-1,554,559,561,-1,559,554,553,-1,548,537,549,-1,535,537,548,-1,547,543,530,-1,544,543,547,-1,815,529,563,-1,815,528,529,-1,562,812,813,-1,551,812,562,-1,544,558,545,-1,544,552,558,-1,565,529,487,-1,565,538,529,-1,530,814,531,-1,530,543,814,-1,537,526,542,-1,537,534,526,-1,528,553,488,-1,528,813,553,-1,812,532,559,-1,812,533,532,-1,531,555,532,-1,531,817,555,-1,521,512,517,-1,512,521,513,-1,806,509,808,-1,509,806,507,-1,520,810,514,-1,810,520,519,-1,803,508,805,-1,803,802,508,-1,501,512,500,-1,501,517,512,-1,493,496,491,-1,493,516,496,-1,514,568,515,-1,514,810,568,-1,511,500,512,-1,511,489,500,-1,517,520,521,-1,517,518,520,-1,518,804,519,-1,518,807,804,-1,568,809,569,-1,810,809,568,-1,804,808,809,-1,808,804,806,-1,503,805,807,-1,805,503,803,-1,572,505,586,-1,572,510,505,-1,483,504,802,-1,480,504,483,-1,470,803,503,-1,801,803,470,-1,499,799,498,-1,494,799,499,-1,495,494,491,-1,495,799,494,-1,489,492,490,-1,511,492,489,-1,485,480,483,-1,481,480,485,-1,472,475,473,-1,472,478,475,-1,801,467,800,-1,801,470,467,-1,799,797,798,-1,799,495,797,-1,462,448,450,-1,462,461,448,-1,597,591,465,-1,601,591,597,-1,794,462,796,-1,460,462,794,-1,461,458,457,-1,463,458,461,-1,795,451,788,-1,451,795,450,-1,464,621,623,-1,590,621,464,-1,466,784,594,-1,466,379,784,-1,455,458,597,-1,454,458,455,-1,454,456,458,-1,792,424,423,-1,790,424,792,-1,432,435,430,-1,435,432,441,-1,412,382,818,-1,382,412,439,-1,383,439,604,-1,383,382,439,-1,422,434,435,-1,422,421,434,-1,427,376,433,-1,410,376,427,-1,793,422,442,-1,793,419,422,-1,436,418,606,-1,436,416,418,-1,818,415,412,-1,818,385,415,-1,402,384,383,-1,402,609,384,-1,792,612,397,-1,612,792,614,-1,608,396,395,-1,608,607,396,-1,400,615,617,-1,399,615,400,-1,444,403,604,-1,607,403,444,-1,395,615,399,-1,394,615,395,-1,391,389,616,-1,391,390,389,-1,445,393,396,-1,438,393,445,-1,397,790,792,-1,397,400,790,-1,605,388,410,-1,388,605,617,-1,610,408,405,-1,610,404,408,-1,451,789,787,-1,451,447,789,-1,620,599,819,-1,620,598,599,-1,783,784,785,-1,783,600,784,-1,788,819,599,-1,819,788,786,-1,366,359,358,-1,359,366,365,-1,360,365,364,-1,360,359,365,-1,360,363,349,-1,360,364,363,-1,370,343,345,-1,370,367,343,-1,367,627,343,-1,367,366,627,-1,369,356,354,-1,781,356,369,-1,627,355,626,-1,353,355,627,-1,316,774,776,-1,315,774,316,-1,775,338,777,-1,775,336,338,-1,778,306,766,-1,778,331,306,-1,298,335,296,-1,635,335,298,-1,766,320,778,-1,320,766,768,-1,321,773,318,-1,321,762,773,-1,309,323,310,-1,323,309,341,-1,633,312,319,-1,342,312,633,-1,778,332,331,-1,778,636,332,-1,632,337,633,-1,337,632,294,-1,313,336,775,-1,313,342,336,-1,317,333,315,-1,317,334,333,-1,779,309,311,-1,779,340,309,-1,780,326,325,-1,326,780,329,-1,300,324,327,-1,300,302,324,-1,765,321,323,-1,765,762,321,-1,326,635,327,-1,635,326,634,-1,307,317,770,-1,334,317,307,-1,768,319,320,-1,768,631,319,-1,780,311,329,-1,780,779,311,-1,777,330,776,-1,777,328,330,-1,307,772,308,-1,307,770,772,-1,306,769,766,-1,769,306,305,-1,764,773,762,-1,771,773,764,-1,763,637,761,-1,763,765,637,-1,760,768,767,-1,760,631,768,-1,291,283,272,-1,291,290,283,-1,288,275,289,-1,275,288,286,-1,289,276,647,-1,289,275,276,-1,292,758,820,-1,758,292,291,-1,647,264,289,-1,647,645,264,-1,280,820,759,-1,292,820,280,-1,252,260,259,-1,252,263,260,-1,261,250,262,-1,261,258,250,-1,249,256,246,-1,249,257,256,-1,253,259,240,-1,253,252,259,-1,262,248,649,-1,262,250,248,-1,757,245,253,-1,243,245,757,-1,236,756,648,-1,236,247,756,-1,743,211,234,-1,212,211,743,-1,744,741,740,-1,744,752,741,-1,751,754,750,-1,755,754,751,-1};
			return value;
		}
		private int[] getrcartend_Geo_6_190_coordIndex_6()
		{
			int[] value = {753,654,653,-1,654,753,707,-1,742,234,231,-1,742,743,234,-1,752,233,232,-1,233,752,658,-1,745,222,659,-1,745,751,222,-1,652,750,653,-1,220,750,652,-1,223,662,749,-1,223,226,662,-1,748,657,747,-1,748,746,657,-1,231,661,742,-1,661,231,746,-1,659,219,217,-1,659,222,219,-1,221,652,228,-1,221,220,652,-1,740,745,744,-1,745,740,739,-1,225,743,742,-1,708,743,225,-1,213,755,739,-1,707,755,213,-1,707,754,755,-1,707,753,754,-1,666,167,166,-1,666,209,167,-1,163,184,199,-1,184,163,162,-1,672,737,207,-1,204,672,673,-1,204,737,672,-1,171,673,168,-1,673,171,204,-1,665,681,180,-1,151,681,665,-1,194,200,172,-1,194,191,200,-1,190,671,181,-1,190,670,671,-1,186,734,165,-1,821,734,186,-1,821,208,148,-1,821,186,208,-1,157,738,166,-1,157,156,738,-1,166,205,666,-1,738,205,166,-1,160,161,159,-1,160,162,161,-1,736,155,677,-1,736,158,155,-1,738,155,159,-1,155,738,156,-1,676,668,189,-1,676,682,668,-1,132,683,130,-1,143,683,132,-1,145,134,136,-1,145,140,134,-1,126,684,147,-1,126,685,684,-1,120,113,686,-1,120,112,113,-1,732,119,118,-1,119,732,121,-1,108,115,109,-1,108,116,115,-1,117,687,733,-1,687,117,114,-1,102,80,82,-1,101,80,102,-1,98,97,90,-1,96,97,98,-1,95,688,88,-1,688,95,94,-1,81,92,91,-1,92,81,78,-1,90,730,93,-1,90,97,730,-1,86,84,89,-1,86,85,84,-1,724,728,722,-1,728,724,720,-1,729,72,725,-1,73,72,729,-1,822,691,76,-1,822,74,691,-1,72,822,726,-1,74,822,72,-1,723,725,727,-1,725,723,722,-1,70,724,721,-1,724,70,69,-1,729,720,73,-1,729,728,720,-1,71,64,63,-1,71,719,64,-1,718,45,47,-1,718,52,45,-1,56,46,55,-1,56,44,46,-1,696,700,697,-1,696,698,700,-1,47,44,50,-1,45,44,47,-1,709,5,4,-1,709,13,5,-1,20,710,713,-1,20,19,710,-1,31,715,29,-1,715,31,712,-1,16,716,17,-1,7,716,16,-1,717,24,26,-1,717,9,24,-1,711,34,714,-1,34,711,32,-1,40,709,41,-1,40,13,709,-1,713,39,37,-1,710,39,713,-1,25,4,11,-1,25,709,4,-1,12,0,28,-1,12,6,0,-1,712,3,38,-1,31,3,712,-1,711,710,32,-1,711,39,710,-1,33,21,704,-1,33,19,21,-1,703,7,16,-1,703,10,7,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrcartend_Coord_7_190_point_1()
		{
			double[] value = {-2.66474,44.18806,2.50406,-2.71974,44.15806,2.48754,-2.72848,44.12483,2.51577,-2.67475,44.17127,2.53099,-2.67749,44.14935,2.44755,-2.70837,44.14517,2.46184,-2.66207,44.18481,2.48858,-2.78291,43.76561,2.32305,-2.7658,43.83871,2.34233,-2.76407,43.83879,2.32463,-2.78483,43.77486,2.33917,-2.67204,44.15393,2.43824,-2.65757,44.19765,2.48906,-2.75466,44.10568,2.43518,-2.76802,44.09874,2.46637,-2.81929,43.71362,2.35388,-2.80968,43.71637,2.32718,-2.83431,43.7068,2.3147,-2.84103,43.7101,2.33812,-2.7831,43.8726,2.5195,-2.83624,43.88035,2.4554,-2.79402,43.80378,2.46095,-2.67958,44.22652,2.48177,-2.70431,44.19814,2.4061,-2.73641,43.97217,2.35374,-2.70838,44.10411,2.3994,-2.76195,43.99242,2.31513,-2.72645,44.12716,2.35622,-2.66221,44.2062,2.51475,-2.69037,44.20382,2.55224,-2.68798,44.22658,2.52155,-2.67349,44.1783,2.53895,-2.76051,43.9329,2.56236,-2.78572,43.86592,2.52851,-2.77715,43.93912,2.5747,-2.80458,43.86862,2.53206,-2.81472,43.73578,2.36285,-2.7822,44.07859,2.50064,-2.70386,44.08999,2.55927,-2.73208,44.0022,2.5601,-2.78854,43.98849,2.40217,-2.74385,43.96999,2.36855,-2.82305,43.87408,2.35792,-2.82904,43.87685,2.40237,-3.31058,43.42195,2.36401,-3.3345,43.45606,2.39694,-3.28205,43.4945,2.4071,-3.4007,43.29541,2.3177,-3.4462,43.22206,2.20526,-3.43025,43.23258,2.26669,-3.39103,43.24819,2.2586,-3.2932,43.5047,2.44197,-3.32654,43.45997,2.45381,-3.21622,43.50133,2.4301,-3.27474,43.38523,2.32297,-3.23267,43.48575,2.43534,-3.27523,43.39637,2.36869,-3.37078,43.18903,2.22854,-3.42022,43.17091,2.21558,-3.43707,43.14258,2.19979,-3.42457,43.15805,2.25447,-3.44548,43.1392,2.27508,-3.82985,42.55768,1.99552,-3.85656,42.58231,2.02501,-3.79303,42.59926,2.00588,-3.787,42.54467,1.98123,-3.78025,42.52841,1.94599,-3.85369,42.49277,1.97784,-3.87355,42.47927,1.94603,-3.69795,42.63563,2.00429,-3.71645,42.63682,1.95502,-3.82725,42.69685,2.09314,-3.785,42.79044,2.18345,-3.7924,42.77094,2.13289,-3.85803,42.66365,2.12206,-3.97351,42.49832,1.91619,-3.94663,42.52508,1.97545,-3.93199,42.48414,1.87524,-4.30941,42.17818,1.45504,-4.28505,42.14354,1.42585,-4.30499,42.14225,1.43325,-4.28495,42.19065,1.45753,-4.31864,42.10001,1.41998,-4.30848,42.09263,1.40237,-4.38164,42.02802,1.38821,-4.38715,42.04726,1.40853,-4.40405,42.04626,1.41522,-4.44735,42.09671,1.4587,-4.42886,42.09713,1.45123,-4.4127,42.02985,1.40392,-4.35374,42.21775,1.53812,-4.30308,42.23088,1.49621,-4.32139,42.21203,1.48587,-4.3534,42.248,1.5572,-4.42867,42.20066,1.4847,-4.4081,42.19637,1.54522,-4.41176,42.21811,1.49134,-4.38302,42.21102,1.55245,-4.39417,42.2225,1.48293,-4.36397,42.21083,1.44789};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_2()
		{
			double[] value = {-4.34352,42.18693,1.41558,-4.34747,42.16406,1.40646,-4.35988,42.13551,1.39833,-4.38895,42.09896,1.40061,-4.39674,42.16669,1.42939,-4.41495,42.09721,1.41897,-4.62421,41.73733,.89525,-4.61416,41.74157,.90708,-4.58891,41.72196,.86668,-4.59805,41.70992,.84674,-4.52564,41.86353,1.0013,-4.52563,41.78997,.89079,-4.57457,41.88262,.99564,-4.56665,41.79309,.90427,-4.51085,41.77022,.90805,-4.56697,41.70762,.83403,-4.56558,41.71493,.84935,-4.49111,41.76871,.89034,-4.61304,41.83516,1.0229,-4.59618,41.83479,1.02769,-4.60663,41.87134,.99816,-4.57475,41.88939,1.09201,-4.54656,41.89048,1.09436,-4.56296,41.75796,.86139,-.7105,45.24464,2.75908,-.66314,45.31146,2.7181,-.71306,45.27448,2.78838,-.67424,45.293,2.69586,-.60813,45.32688,2.7827,-.60567,45.34909,2.74161,-.70513,45.61039,2.78593,-.64499,45.49258,2.87764,-.65723,45.48748,2.84934,-.71381,45.64149,2.79965,-.67439,45.59471,2.64988,-.6824,45.61337,2.62899,-.71691,45.64093,2.7,-.78111,45.6711,2.69264,-.61552,45.44805,2.65284,-.59656,45.43949,2.63563,-.61748,45.55063,2.69048,-.60139,45.46451,2.75136,-.59741,45.45362,2.69256,-.60536,45.47584,2.80999,-.61128,45.35803,2.82172,-.63057,45.5739,2.72004,-.71829,45.25055,2.79107,-.7148,45.25446,2.817,-.47425,44.63706,2.85137,-.43808,44.58738,2.88389,-.35596,44.48518,2.86628,-.23771,44.54871,3.05179,-.25895,44.54701,2.99601,-.24882,44.5822,3.05395,-.72068,45.21064,2.79709,-.6588,45.12037,2.88484,-.66752,45.15413,2.81534,-.67625,45.10195,2.76631,-.60008,45.02497,2.94879,-.57649,45.09267,2.89613,-.5499,45.01588,2.93023,-.52171,45.05723,2.88584,-.49515,44.98336,2.91789,-.49874,44.97571,2.86519,-.69064,45.13353,2.73885,-.62287,44.98513,2.75598,-.58765,45.06708,2.77783,-.56405,44.98458,2.78135,-.4185,44.58027,2.90337,-.44753,44.62152,2.8944,-.33696,44.58855,2.95271,-.32889,44.56733,2.93509,-.42588,44.62956,2.91574,-.28024,44.48482,3.09483,-.26384,44.4799,3.10372,-.25518,44.40391,3.08189,-.29998,44.40695,2.94284,-.27126,44.3779,3.01757,-.30783,44.38887,2.93282,-.26229,44.39389,3.01639,-.27324,44.49109,3.08003,-.46035,44.71197,3.02502,-.48468,44.76959,2.98912,-.53139,44.88004,2.9903,-.47741,44.89198,2.94198,-.50211,44.87424,2.96923,-.55217,44.84753,2.79849,-.51638,44.84924,2.82495,-.46275,44.72595,3.0554,-.42611,44.67462,3.03573,-.43261,44.68136,3.01636,-.41947,44.70065,2.93816,-.46091,44.72071,2.90543,-.44453,44.72908,2.93146,-.44665,44.67613,2.90858,-.46481,44.78957,2.91692,-.4507,44.73592,2.95785,-.46652,44.81853,2.93997,-.47067,44.80574,2.88347,-.48045,44.87931,2.894};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_3()
		{
			double[] value = {-.39442,44.67239,2.94476,-.34502,44.60985,2.97027,-.24247,44.47222,2.96901,-.22703,44.47285,3.0092,-.31394,44.55352,2.93579,-.54051,45.07663,2.83638,-.32959,44.61391,2.99489,-.26909,44.51237,2.93775,-.47893,44.64258,2.8838,-.50152,44.9642,2.81347,-.4843,44.87109,2.84471,-2.44818,44.97679,2.53475,-2.44762,44.98894,2.53765,-2.44707,45.00331,2.54123,-2.44914,44.95277,2.52875,-2.32602,44.87426,2.50098,-2.36118,44.80694,2.50505,-2.32854,44.88592,2.51456,-2.35982,44.8204,2.52264,-2.28523,45.03363,2.51113,-2.28223,45.1536,2.5435,-2.26019,45.16637,2.53483,-2.30498,45.04518,2.51439,-2.37876,45.10304,2.61452,-2.37788,45.0984,2.59315,-2.41734,44.96847,2.61767,-2.41586,44.96653,2.63865,-2.25809,45.19444,2.52217,-2.28156,45.19095,2.56186,-2.29114,45.22488,2.55504,-2.281,45.03522,2.49371,-2.42271,44.81581,2.58852,-2.45437,44.86407,2.53081,-2.40974,44.77971,2.55854,-2.45566,44.8969,2.55482,-2.23869,45.73427,2.51049,-2.22239,45.65228,2.47156,-2.21858,45.64729,2.4752,-2.2407,45.7357,2.50494,-2.04223,46.26847,2.28946,-2.05004,46.26517,2.29726,-2.05885,46.27877,2.30702,-2.05386,46.28759,2.30618,-2.16401,45.82961,2.35717,-2.16409,45.82901,2.35729,-2.16965,45.8302,2.36261,-2.2161,45.66201,2.46322,-2.22161,45.65728,2.45179,-2.24349,45.9662,2.48602,-2.22386,45.757,2.4941,-2.22818,45.95909,2.48304,-2.16587,45.83789,2.37466,-2.11031,46.06223,2.33064,-2.11749,46.07007,2.31422,-2.29665,45.98503,2.33597,-2.24839,45.91981,2.32785,-2.30583,45.75818,2.40416,-2.30957,45.83389,2.43244,-2.28992,45.99616,2.40459,-2.0469,46.23815,2.318,-2.16044,46.21094,2.28701,-2.24554,46.10861,2.36073,-2.17273,46.13722,2.41297,-2.22285,46.0385,2.30798,-.69346,45.89123,2.53396,-.63622,45.89002,2.50188,-.58989,46.00103,2.46432,-.74019,45.79146,2.54618,-.61902,46.26977,2.62205,-.62343,46.28448,2.63746,-.65375,46.04903,2.69487,-.65098,46.05317,2.67604,-.58079,46.02853,2.47661,-.57787,46.01911,2.46144,-.62981,45.94666,2.53903,-.67114,45.97038,2.66109,-.72899,45.90577,2.6926,-.49941,46.31768,2.486,-.49033,46.20534,2.53066,-.48691,46.27959,2.46039,-.63042,46.40049,2.4464,-.61954,46.37032,2.5399,-.50941,46.27747,2.5535,-.51426,46.07654,2.50212,-.51043,46.08019,2.56266,-.52867,46.0095,2.54625,-.544,46.01264,2.61975,-.55393,46.09212,2.62213,-.56114,45.98489,2.58924,-.69315,45.93947,2.59999,-.49388,46.19589,2.4672,-.54317,46.24126,2.40818,-.58079,46.35349,2.40026,-2.08512,47.48895,2.04179,-2.10071,47.39286,2.06627,-2.1035,47.39208,2.07746,-2.08214,47.48475,2.03657,-1.98796,47.77637,1.90476,-2.04016,47.6666,1.96919,-2.04051,47.66558,1.9709};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_4()
		{
			double[] value = {-1.98854,47.77499,1.90469,-1.90466,47.87593,1.8008,-1.93718,47.86129,1.84657,-1.93649,47.86238,1.84716,-1.90852,47.87134,1.80324,-2.08416,47.07098,2.05913,-2.0856,47.07525,2.05822,-2.04233,47.18709,1.99394,-2.04039,47.18538,1.99049,-1.89766,47.78487,1.82559,-1.91202,47.70853,1.83284,-2.01795,47.77731,1.77809,-2.09721,47.15183,2.13041,-2.13857,47.24365,2.02969,-2.08145,47.11742,2.12161,-1.97258,47.32889,1.99175,-1.95737,47.40155,1.95548,-1.96363,47.31488,1.98085,-1.94831,47.38825,1.94869,-2.10023,47.15041,2.13713,-2.08415,47.10925,2.12812,-1.90935,47.6304,1.83526,-1.92614,47.62797,1.84915,-1.89575,47.70728,1.82514,-1.91376,47.84491,1.86041,-1.91911,47.83471,1.85339,-1.96513,47.74909,1.89969,-1.96936,47.75998,1.91358,-2.12027,47.69646,1.84943,-2.04275,47.7737,1.84343,-2.07929,47.67352,1.79395,-2.04895,47.07168,2.0942,-2.05134,47.09105,2.09063,-2.01226,47.18244,2.04914,-2.00209,47.17636,2.03811,-2.05889,47.48499,2.03851,-2.06991,47.38607,2.06409,-2.07392,47.38508,2.0752,-2.05658,47.48426,2.02724,-1.8876,47.84688,1.83061,-1.89322,47.8308,1.83621,-1.88656,47.78363,1.81957,-2.08513,47.24532,2.10882,-.53749,47.12406,2.24817,-.61101,47.06167,2.3059,-.54225,47.08391,2.20354,-.65862,46.98867,2.24323,-.48274,47.56717,1.89329,-.57626,47.78641,1.86048,-.48384,47.55934,1.90712,-.52287,47.67325,1.90909,-.55383,47.03706,2.1307,-.50367,47.11138,2.12494,-.53688,47.56444,2.08433,-.56227,47.68955,1.98897,-.54062,47.57828,2.10001,-.59753,47.77483,1.96473,-.47256,47.60977,2.00669,-.47496,47.49922,2.07725,-.43392,47.47619,2.02916,-.44119,47.49209,1.96848,-.4518,47.60367,1.94163,-.43569,47.17286,2.12622,-.45865,47.23117,2.02446,-.42743,47.27921,2.04757,-.42296,47.30176,2.10287,-.47414,47.29045,2.17669,-.45176,47.18241,2.18739,-.45822,47.62908,1.96548,-.57487,47.72004,1.93537,-.45182,47.16389,2.16324,-.52821,48.9382,1.50408,-.55612,48.90192,1.51254,-.53096,48.94429,1.49984,-.5607,48.90306,1.50679,-.50922,48.89591,1.54554,-.55096,48.8613,1.54095,-.51018,48.89956,1.54142,-.54991,48.86734,1.53769,-1.68005,48.9212,1.40371,-1.67198,48.93096,1.40169,-1.6723,48.93113,1.40109,-.56904,49.15668,1.14694,-.50835,48.97461,1.24269,-.46577,48.96077,1.22377,-.65909,49.22371,1.14858,-.67705,49.22949,1.15073,-.67139,49.23146,1.14883,-.5303,48.86247,1.50757,-.54016,48.87396,1.51683,-.54005,48.87841,1.51225,-.52602,48.8743,1.50093,-.53463,48.87965,1.49672,-.443,48.89442,1.44848,-.43193,48.88872,1.4512,-.3932,48.89382,1.41372,-.40525,48.90432,1.41111,-.42424,48.86719,1.37532,-.41684,48.87537,1.37096,-.39156,48.88808,1.41585};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_5()
		{
			double[] value = {-.39692,48.87703,1.42112,-.47714,48.8885,1.30972,-.50244,48.96471,1.24734,-.49855,48.90295,1.30503,-.48297,48.93885,1.25552,-.44655,48.94706,1.24623,-.48218,48.91604,1.26411,-.4598,48.91857,1.24969,-.48097,48.93445,1.25741,-.53598,48.8945,1.52002,-.53262,48.85614,1.51032,-.53508,48.89144,1.52317,-.60319,49.1213,1.19983,-.48546,49.07027,1.27738,-.47618,49.05999,1.27563,-.62604,49.12846,1.2129,-.4804,49.01167,1.35388,-.43913,49.00458,1.32996,-.48301,49.05328,1.30272,-.46606,48.68212,1.40886,-.47434,48.66116,1.44351,-.49024,48.60469,1.50345,-.52748,48.52316,1.52464,-.40194,48.76374,1.45023,-.38969,48.7937,1.46975,-.39845,48.70877,1.49128,-.40671,48.70713,1.53016,-.51526,48.69557,1.56594,-.50263,48.63288,1.56665,-.41817,48.77491,1.50921,-.5309,48.52819,1.64653,-.50347,48.63907,1.68346,-.55017,48.46493,1.71603,-.5132,48.66362,1.62636,-.49425,48.60029,1.54315,-.56191,48.47772,1.61461,-.586,49.03456,1.34171,-.53793,48.88344,1.49328,-.44486,48.89891,1.44448,-.57449,49.09388,1.20706,-.45749,49.00054,1.30255,-.59745,48.42395,1.64211,-.48474,48.4787,1.50714,-.40317,48.6904,1.52009,-.42713,48.89459,1.36571,-.40812,48.90856,1.40868,-1.64518,48.84771,1.34938,-1.66216,48.65005,1.38945,-1.66181,48.66414,1.39395,-1.63545,48.85644,1.33518,-1.7234,48.55259,1.48796,-1.72862,48.54564,1.48005,-1.74103,48.86521,1.40423,-1.73094,48.88006,1.38362,-1.75137,48.82111,1.40519,-1.76272,48.80087,1.41932,-1.74548,48.82106,1.39376,-1.69573,48.85398,1.34906,-1.74406,48.81499,1.38886,-1.71286,48.87194,1.36717,-1.79508,48.65967,1.46242,-1.73161,48.70067,1.39899,-1.7821,48.59387,1.47816,-1.75985,48.72096,1.41935,-1.70871,48.86286,1.45851,-1.77014,48.82084,1.4321,-1.67702,48.89894,1.40727,-1.58089,49.99075,.66672,-1.60955,49.88808,.72287,-1.60681,49.89241,.72803,-1.58319,49.98421,.65994,-1.63837,49.77337,.77375,-1.6727,49.66108,.81716,-1.66879,49.6631,.8208,-1.64144,49.77116,.76957,-1.69806,49.59253,.81894,-1.72594,49.56078,.78693,-1.7258,49.55703,.78969,-1.69999,49.59503,.81515,-1.48067,50.22651,.44403,-1.5044,50.17907,.47347,-1.50011,50.18597,.47872,-1.48661,50.21946,.43916,-1.52738,50.12819,.52608,-1.52557,50.13274,.53442,-1.52511,50.13375,.53324,-1.256,49.85246,.83934,-1.13572,49.66889,.87267,-1.28649,49.80037,.8201,-1.68863,49.5996,.80851,-1.7031,49.57498,.79077,-1.66612,49.60457,.70606,-1.70038,49.60036,.75308,-1.6741,49.65082,.68378,-1.69202,49.57261,.7451,-1.68406,49.58437,.69837,-1.61593,49.68084,.63332,-1.62688,49.65487,.63877,-1.73344,49.5456,.76477,-1.70862,49.56655,.76889};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_6()
		{
			double[] value = {-1.66545,49.65825,.81321,-1.63275,49.77096,.76592,-1.60075,49.88365,.71833,-1.56735,49.97687,.64216,-1.49491,50.17341,.46417,-1.48177,50.20426,.42104,-1.51356,50.14497,.44538,-1.52059,50.11444,.45882,-1.52347,50.11383,.48834,-1.50908,50.10951,.44253,-1.47633,50.17827,.41163,-1.68577,49.61761,.77787,-1.66136,49.69181,.77095,-1.68517,49.6677,.72144,-1.58448,49.77485,.58837,-1.56933,49.75738,.57557,-1.63908,49.69763,.64733,-1.64099,49.76197,.73783,-1.60162,49.87804,.68309,-1.60778,49.87511,.58714,-1.62981,49.83394,.61132,-1.66216,49.726,.6724,-1.24209,50.06163,.61951,-1.21861,50.09075,.60888,-1.25201,50.09243,.66515,-1.05842,49.84074,.54583,-1.09977,49.82887,.56293,-1.03069,49.7767,.57492,-1.27092,49.80793,.80614,-1.1166,49.67803,.86155,-1.21377,49.98849,.58536,-1.21777,49.99303,.57482,-1.27016,50.00486,.63637,-1.26228,49.99673,.64221,-1.02372,49.68501,.6744,-.96304,49.62804,.76026,-.96042,49.61778,.75693,-1.02493,49.6858,.67883,-.99428,49.64442,.85668,-.96747,49.6156,.82628,-.90134,49.74616,.78419,-.92904,49.76718,.80294,-1.10177,49.83156,.5759,-1.1415,49.91082,.56989,-1.05333,49.99581,.59808,-1.02576,49.91684,.61435,-1.12637,50.04813,.64848,-1.09505,50.03306,.61299,-.90672,49.75375,.74815,-.94734,49.80688,.67921,-.92154,49.86769,.72342,-1.14713,50.02565,.69194,-1.03638,50.01925,.66058,-1.30853,49.89235,.78481,-1.2958,49.95576,.8009,-1.18697,50.07543,.57026,-.97005,49.71385,.63399,-.96883,49.63394,.7075,-1.01032,49.96619,.67561,-1.30612,49.98005,.70346,-1.27451,50.09274,.70444,-1.2883,50.06016,.74858,-1.14809,49.99485,.7263,-.97228,49.80433,.80596,-.96511,49.60486,.83621,-1.00875,49.62175,.87709,-1.57228,49.75183,.56747,-1.53019,49.83548,.51257,-1.52814,49.8413,.52063,-1.50878,49.94323,.47895,-1.50878,49.93836,.46203,-1.49137,50.0448,.4194,-1.47132,50.18052,.3945,-1.49236,50.05429,.44309,-.97372,49.59828,.83912,-.97149,49.59807,.83868,-1.47259,50.24264,.41018,-1.46537,50.24793,.41202,-1.73245,49.54097,.76501,-1.62141,49.65013,.63455,-1.56674,49.74805,.56524,-1.5242,49.83152,.51011,-1.50095,49.93773,.45536,-1.48331,50.04381,.41349,-1.46183,50.18308,.38948,-1.46173,50.23817,.39941,-1.46994,50.23238,.40298,-1.64268,48.86903,1.35905,-1.85644,48.6529,1.52331,-1.79658,48.62929,1.57271,-1.76233,48.74485,1.53291,-1.79955,48.74962,1.48206,-1.8662,48.61586,1.52817,-1.79696,48.56529,1.57689,-1.66037,48.88721,1.38807,-1.82328,48.67602,1.47764,-1.8126,48.69668,1.47109,-1.76933,48.78835,1.43042,-1.80721,48.63398,1.58269,-1.82111,48.55707,1.58553};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_7()
		{
			double[] value = {-1.64411,48.88873,1.34629,-1.79075,48.73709,1.45705,-.611,49.11123,1.32653,-.60934,49.11381,1.31392,-.50277,48.91067,1.30123,-.43696,48.87064,1.46177,-.62132,49.11294,1.24927,-.4244,48.88972,1.36767,-.41684,48.88155,1.36885,-.46756,48.94959,1.23475,-.44856,48.95035,1.24457,-.47642,48.88043,1.31444,-.48944,48.86179,1.32792,-.48075,48.90607,1.26832,-.49022,48.85084,1.33461,-.43042,48.88344,1.45441,-.52502,48.86913,1.50416,-.43745,48.8764,1.46004,-.64207,49.18903,1.2213,-1.76555,48.7519,1.543,-1.8049,48.63471,1.58879,-1.77009,48.74862,1.53951,-1.70992,48.87821,1.46631,-1.71283,48.87412,1.46043,-.51964,48.9078,1.53023,-.52089,48.91256,1.52529,-.55092,47.23444,2.28448,-.54343,47.26203,2.23319,-.4478,47.21614,2.0104,-2.11,47.23192,1.99804,-1.90673,47.85739,1.78858,-2.1375,47.15859,2.1113,-2.12034,47.26197,2.09866,-2.08845,47.24717,2.116,-2.01276,47.65987,1.94933,-2.02241,47.66174,1.97105,-2.06461,47.09087,2.10965,-1.91888,47.78777,1.77739,-1.90315,47.86183,1.78306,-2.11735,47.25941,2.11136,-.56117,47.23636,2.29069,-.56212,47.23566,2.29079,-.56117,47.23684,2.29051,-.53575,46.21278,2.59582,-.66559,46.47681,2.51104,-.78486,45.837,2.62907,-.79969,45.83281,2.63701,-.78424,45.84082,2.63325,-2.2185,45.64703,2.47489,-2.18632,46.15424,2.4144,-2.1847,46.15744,2.41968,-2.24267,45.96709,2.4901,-2.29115,45.16241,2.55272,-2.38381,45.12893,2.53519,-2.43228,45.0664,2.5614,-2.40464,44.74646,2.51943,-2.39464,44.7576,2.53326,-2.41342,44.75701,2.57016,-2.40353,44.7842,2.53964,-2.34298,44.89857,2.51661,-2.373,44.84149,2.52919,-2.42005,44.88019,2.62469,-2.43124,44.9705,2.64284,-2.44099,44.87994,2.63659,-.49905,44.74092,2.86998,-.22917,44.51514,3.04281,-.52551,45.03973,2.8069,-.2837,44.60527,3.04073,-.38966,44.65304,3.0289,-.31416,44.61807,3.01947,-.40745,44.67382,2.98119,-.43567,44.70409,2.97357,-.35204,44.48899,2.88524,-.38527,44.53444,2.89441,-.39416,44.68291,3.08674,-.3172,44.62074,3.10283,-.37583,44.65742,3.07682,-.68498,45.16268,2.89449,-.26945,44.52945,3.11758,-.29109,44.53899,3.10825,-.3128,44.60657,3.08847,-.28676,44.54195,3.09395,-.35541,44.63961,3.06622,-.62215,45.56407,2.75714,-.67727,45.32053,2.86478,-.67878,45.32146,2.84897,-4.60796,41.76324,.88561,-4.51192,41.84592,1.02399,-4.42954,42.13028,1.44654,-4.42805,42.20783,1.55733,-3.81209,42.55619,1.89092,-3.90293,42.52148,2.01458,-3.39394,43.20798,2.3932,-3.40994,43.20197,2.39662,-3.43476,43.21389,2.25108,-3.37209,43.18733,2.19805,-3.24647,43.50576,2.4917,-3.25095,43.53396,2.50478,-3.29404,43.44931,2.51911,-3.35397,43.30141,2.45525};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_8()
		{
			double[] value = {-3.30718,43.46766,2.53993,-3.36945,43.31462,2.48814,-3.41387,43.23767,2.32955,-2.80464,43.73622,2.34212,-2.79927,43.77979,2.45312,-2.83793,43.76845,2.43721,-2.80366,43.98615,2.43922,-2.44058,45.03096,2.54049,-2.44996,44.99558,2.57022,-2.71393,44.10123,2.40818,-2.75906,43.93403,2.55327,-2.73241,44.00253,2.57265,-2.70318,44.09159,2.56818,-2.81355,43.97685,2.48924,-2.74492,44.01764,2.5846,-2.72072,44.10369,2.58419,-2.82922,43.78733,2.2852,-2.79825,43.86014,2.28711,-3.37909,43.31773,2.39587,-3.75491,42.67597,2.03103,-3.73328,42.74844,2.07065,-3.66615,42.76371,2.01281,-3.65121,42.82641,2.09974,-3.66277,42.86414,2.06132,-3.65703,42.74619,2.05647,-3.70911,42.83827,2.16042,-3.8131,42.82143,2.16411,-3.73098,42.88233,2.13445,-3.7109,42.79569,2.09951,-3.74873,42.80432,2.13509,-4.38938,42.23929,1.57366,-4.53816,41.90391,1.10356,-4.59136,41.8983,1.09788,-4.48982,41.84772,1.01439,-.62103,44.98359,2.73338,-.53357,44.88574,3.01207,-.60541,45.02937,2.97744,-.29899,44.53975,2.93647,-.59297,45.11862,2.8246,-2.43514,44.99248,2.5214,-2.43917,44.97702,2.52232,-2.44601,44.9497,2.52345,-2.41975,44.89227,2.60431,-2.45269,44.94629,2.56299,-2.4239,44.90566,2.51056,-2.4021,44.94795,2.50248,-2.42494,44.79363,2.60759,-2.42875,44.74412,2.57349,-2.44018,44.78866,2.61417,-2.39303,45.12523,2.61615,-2.36976,45.11358,2.51755,-2.3825,45.0311,2.50227,-2.44596,44.86326,2.51751,-2.43209,45.03219,2.52906,-2.43084,45.02619,2.52553,-2.43112,45.01173,2.5216,-2.21709,45.65366,2.44876,-2.11329,46.06772,2.30885,-.53727,46.24476,2.38633,-.67327,46.51281,2.40772,-2.13603,47.13866,2.12766,-1.91583,47.78848,1.77195,-1.94591,47.63799,1.79896,-1.92736,47.70953,1.77476,-1.94401,47.6365,1.79512,-1.93033,47.71002,1.77986,-2.11775,47.08708,2.08408,-2.12718,47.09676,2.11302,-2.13005,47.12339,2.09889,-2.11524,47.07102,2.09077,-2.01437,47.33406,1.92594,-1.99633,47.40837,1.88866,-2.01237,47.33337,1.92193,-1.99841,47.40903,1.89278,-2.12717,47.43077,1.89649,-2.16221,47.45334,1.93277,-2.14166,47.54296,1.83166,-2.17515,47.56719,1.87862,-2.06638,47.07677,2.11675,-1.98853,47.83164,1.7965,-1.99524,47.83494,1.81711,-.62647,47.81665,1.90044,-1.62511,48.85946,1.32708,-1.63504,48.89603,1.3393,-1.66034,48.91171,1.37378,-1.65356,48.92231,1.37124,-1.80642,48.52899,1.57104,-1.72472,48.53969,1.47995,-1.80743,48.53422,1.56767,-1.6525,48.64739,1.3839,-.39791,48.87147,1.42409,-.45889,48.9052,1.25534,-.42561,48.86206,1.37862,-.42712,48.66816,1.38841,-1.8239,48.65588,1.48147,-1.79287,48.54283,1.5652,-1.8572,48.59254,1.52603,-1.68097,49.57861,.69613,-1.71059,49.54878,.73049,-1.71194,49.55403,.73068};
			return value;
		}
		private double[] getrcartend_Coord_7_190_point_9()
		{
			double[] value = {-1.54351,50.08643,.57736,-1.54647,50.07882,.57165,-1.51676,50.118,.51725,-1.53168,50.07246,.55599,-1.58114,49.95249,.54189,-1.54971,50.03198,.55706,-1.54912,50.03237,.50065,-1.57558,49.9534,.62043,-1.52137,50.02192,.47113,-1.53064,49.93522,.49672,-1.54773,49.85399,.53414,-1.26665,50.09331,.68996,-1.2918,49.97356,.70128,-1.29077,49.8942,.77388,-1.14301,49.91128,.55802,-1.13501,49.90952,.77009,-1.09415,49.95375,.52211,-1.15693,50.06191,.53319,-.62756,49.21756,1.13004,-1.82051,48.55459,1.58897,-.62947,46.46239,2.36595,-.55151,44.8483,2.78077,-3.89388,42.67878,2.10049};
			return value;
		}


		/** Define subarrays using type int[] */
		private int[] getrscapula_Geo_6_195_coordIndex_1()
		{
			int[] value = {0,1,2,-1,2,3,0,-1,2,4,3,-1,5,6,7,-1,8,9,10,-1,11,12,13,-1,13,14,11,-1,15,16,17,-1,18,19,20,-1,21,22,23,-1,24,25,21,-1,26,27,28,-1,29,30,31,-1,32,33,34,-1,34,35,32,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,36,45,37,-1,36,46,45,-1,47,48,49,-1,50,51,52,-1,50,53,51,-1,54,55,56,-1,56,57,54,-1,26,58,59,-1,26,60,58,-1,61,62,63,-1,64,65,66,-1,66,67,64,-1,68,69,70,-1,69,71,70,-1,72,73,74,-1,75,76,77,-1,78,76,75,-1,75,79,78,-1,80,81,82,-1,83,84,85,-1,86,87,88,-1,89,90,91,-1,92,93,94,-1,95,54,57,-1,95,96,54,-1,97,98,99,-1,99,100,97,-1,101,102,103,-1,103,104,101,-1,105,106,107,-1,105,108,106,-1,109,110,111,-1,109,112,110,-1,113,112,109,-1,113,114,112,-1,115,116,117,-1,115,118,116,-1,119,120,121,-1,110,122,111,-1,123,124,125,-1,126,127,128,-1,129,130,131,-1,129,132,130,-1,133,134,135,-1,135,136,133,-1,137,138,139,-1,140,93,92,-1,140,141,93,-1,142,90,89,-1,142,143,90,-1,144,145,146,-1,144,120,145,-1,147,148,149,-1,147,150,148,-1,151,152,153,-1,152,154,153,-1,155,156,157,-1,155,158,156,-1,159,160,161,-1,159,162,160,-1,60,39,58,-1,60,163,39,-1,164,165,166,-1,166,167,164,-1,168,169,170,-1,170,171,168,-1,172,173,174,-1,172,175,173,-1,151,176,152,-1,156,177,157,-1,178,179,180,-1,162,181,182,-1,162,159,181,-1,29,183,184,-1,184,30,29,-1,30,185,186,-1,30,184,185,-1,187,188,189,-1,187,190,188,-1,191,192,193,-1,51,194,195,-1,196,197,198,-1,199,200,201,-1,202,203,204,-1,199,205,206,-1,207,208,209,-1,210,211,212,-1,212,213,210,-1,207,214,215,-1,215,208,207,-1,216,217,218,-1,216,219,217,-1,220,221,222,-1,220,223,221,-1,224,225,226,-1,227,213,212,-1,227,228,213,-1,143,229,230,-1,229,231,230,-1,232,233,234,-1,6,235,236,-1,236,237,6,-1,238,239,240,-1,147,241,242,-1,147,149,241,-1,243,244,245,-1,245,246,243,-1,244,247,245,-1,247,248,245,-1,249,123,122,-1,122,250,249,-1,251,76,252,-1,76,78,252,-1,253,254,255,-1,253,86,254,-1,109,111,82,-1,111,256,82,-1,252,113,251,-1,113,257,251,-1,258,259,260,-1,261,262,263,-1,262,264,263,-1,265,266,267,-1,268,269,270,-1,268,10,269,-1,271,272,273,-1,137,271,138,-1,137,274,271,-1,275,276,277,-1,275,278,276,-1,279,280,281,-1,280,282,281,-1,283,284,285,-1,283,286,284,-1,287,288,289,-1,288,287,290,-1,290,291,288,-1,292,221,293,-1,293,294,292,-1,280,279,295,-1,279,296,295,-1,279,297,296,-1,297,298,296,-1,9,11,299,-1,11,300,299,-1,301,302,303,-1,301,304,302,-1,305,306,307,-1,306,308,307,-1,309,310,311,-1,309,312,310,-1,313,314,315,-1,313,316,314,-1,316,313,317,-1,317,318,316,-1,319,119,106,-1,319,320,119,-1,321,322,323,-1,323,324,321,-1,325,326,327,-1,325,328,326,-1,329,330,331,-1,171,332,168,-1,333,334,335,-1,336,337,338,-1,339,192,340,-1,192,341,340,-1,342,343,344,-1,342,345,343,-1,346,347,348,-1,346,349,347,-1,350,351,352,-1,353,354,319,-1,355,356,357,-1,358,359,360,-1,361,362,363,-1,357,364,355,-1,365,355,364,-1,366,367,368,-1,368,369,366,-1,370,371,372,-1,370,373,371,-1,321,324,374,-1,374,375,321,-1,376,377,378,-1,379,380,381,-1,381,382,379,-1,183,383,184,-1,384,385,386,-1,384,387,385,-1,388,389,390,-1,388,391,389,-1,392,393,394,-1,392,395,393,-1,396,397,66,-1,396,398,397,-1,399,378,396,-1,378,398,396,-1,400,401,402,-1,400,403,401,-1,404,405,162,-1,406,407,408,-1,408,409,406,-1,410,411,412,-1,413,414,415,-1,397,416,417,-1,397,418,416,-1,419,67,61,-1,61,173,419,-1,420,421,422,-1,421,88,422,-1,421,86,88,-1,421,254,86,-1,423,424,256,-1,424,82,256,-1,425,426,427,-1,426,428,427,-1,429,430,431,-1,431,432,429,-1,262,433,434,-1,262,435,433,-1,436,437,237,-1,237,438,436,-1,439,440,441,-1,440,442,441,-1,161,443,444,-1,443,445,444,-1,26,59,292,-1,446,164,447,-1,164,448,447,-1,174,173,61,-1,61,63,174,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_2()
		{
			int[] value = {449,450,451,-1,451,452,449,-1,453,454,455,-1,455,456,453,-1,185,457,458,-1,457,459,458,-1,460,461,462,-1,463,464,28,-1,465,14,466,-1,465,467,14,-1,467,468,14,-1,10,9,299,-1,14,300,11,-1,14,468,300,-1,255,249,253,-1,249,469,253,-1,88,107,121,-1,88,87,107,-1,470,471,472,-1,470,473,471,-1,474,475,476,-1,477,151,153,-1,478,479,480,-1,479,391,480,-1,481,455,482,-1,388,390,348,-1,347,483,348,-1,483,388,348,-1,484,485,486,-1,485,487,486,-1,488,453,489,-1,489,490,488,-1,491,38,492,-1,491,36,38,-1,493,494,495,-1,496,495,31,-1,496,497,495,-1,498,499,363,-1,499,361,363,-1,500,497,496,-1,500,372,497,-1,501,502,393,-1,393,395,501,-1,373,370,188,-1,187,503,190,-1,187,381,503,-1,504,505,506,-1,507,508,509,-1,509,510,507,-1,45,46,509,-1,46,511,509,-1,7,6,437,-1,6,237,437,-1,512,513,429,-1,514,515,516,-1,514,517,515,-1,518,178,519,-1,178,520,519,-1,521,335,522,-1,523,518,519,-1,524,525,526,-1,524,336,525,-1,527,335,521,-1,527,351,335,-1,528,351,529,-1,528,352,351,-1,530,191,531,-1,531,532,530,-1,341,533,340,-1,534,160,535,-1,534,536,160,-1,404,537,405,-1,404,538,537,-1,162,182,539,-1,539,404,162,-1,540,541,542,-1,540,538,541,-1,543,544,542,-1,50,52,545,-1,540,195,194,-1,540,546,195,-1,547,548,549,-1,548,360,549,-1,402,360,359,-1,402,550,360,-1,402,401,551,-1,365,552,553,-1,403,508,401,-1,554,553,551,-1,364,499,555,-1,556,557,558,-1,559,560,561,-1,560,562,561,-1,563,564,565,-1,564,352,565,-1,114,566,112,-1,114,567,566,-1,568,569,570,-1,319,108,571,-1,319,106,108,-1,119,320,572,-1,573,574,575,-1,576,577,573,-1,573,578,576,-1,579,329,580,-1,580,581,579,-1,380,582,583,-1,321,69,322,-1,321,71,69,-1,584,64,585,-1,584,70,64,-1,586,487,587,-1,376,378,399,-1,349,588,589,-1,589,347,349,-1,415,414,590,-1,590,591,415,-1,67,417,61,-1,417,416,61,-1,397,417,66,-1,467,592,593,-1,467,594,592,-1,465,466,595,-1,466,596,595,-1,597,8,598,-1,597,12,8,-1,599,16,15,-1,599,600,16,-1,601,602,15,-1,602,599,15,-1,603,239,238,-1,603,604,239,-1,600,605,16,-1,606,238,607,-1,238,608,607,-1,608,609,610,-1,610,607,608,-1,611,610,609,-1,611,612,610,-1,613,614,615,-1,615,614,616,-1,616,617,615,-1,615,618,619,-1,618,620,619,-1,621,204,203,-1,203,622,621,-1,204,201,202,-1,204,623,201,-1,624,625,626,-1,627,628,629,-1,627,206,628,-1,210,214,211,-1,210,630,214,-1,631,632,633,-1,116,118,634,-1,118,635,634,-1,636,428,637,-1,636,427,428,-1,638,635,126,-1,635,118,126,-1,126,639,638,-1,640,641,234,-1,216,218,642,-1,643,644,645,-1,643,646,644,-1,647,648,1,-1,1,643,647,-1,649,650,196,-1,196,198,649,-1,651,652,218,-1,651,653,652,-1,1,648,2,-1,654,436,438,-1,438,260,654,-1,655,431,258,-1,656,657,658,-1,658,659,656,-1,660,661,662,-1,659,663,664,-1,659,658,663,-1,660,175,172,-1,660,409,175,-1,661,150,665,-1,661,148,150,-1,666,667,281,-1,667,668,281,-1,669,296,298,-1,669,670,296,-1,671,672,673,-1,674,675,676,-1,674,677,675,-1,239,678,679,-1,239,604,678,-1,680,676,681,-1,681,682,680,-1,682,278,683,-1,682,684,278,-1,685,686,687,-1,239,686,688,-1,688,240,239,-1,689,690,618,-1,618,691,689,-1,203,692,622,-1,692,693,622,-1,694,695,671,-1,671,678,694,-1,696,244,243,-1,243,697,696,-1,247,696,698,-1,247,244,696,-1,699,700,701,-1,702,156,158,-1,702,248,156,-1,703,704,705,-1,704,706,705,-1,22,707,708,-1,709,710,711,-1,709,712,710,-1,713,710,708,-1,713,714,710,-1,266,265,715,-1,715,716,266,-1,713,265,267,-1,713,717,265,-1,718,719,267,-1,267,720,718,-1,721,722,723,-1,721,27,722,-1,718,720,722,-1,722,724,718,-1,725,302,726,-1,726,727,725,-1,669,672,308,-1,672,307,308,-1,314,316,728,-1,728,303,314,-1,310,729,311,-1,310,245,729,-1,318,730,728,-1,318,731,730,-1,729,732,311,-1,732,733,734,-1,34,735,35,-1,736,33,737,-1,736,34,33,-1,296,670,738,-1,738,295,296,-1,593,739,740,-1,741,742,739,-1,739,743,741,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_3()
		{
			int[] value = {743,744,741,-1,745,746,747,-1,747,748,745,-1,285,749,750,-1,750,283,285,-1,592,751,593,-1,751,743,593,-1,752,753,751,-1,753,754,751,-1,755,747,756,-1,755,748,747,-1,138,283,750,-1,757,750,758,-1,758,759,757,-1,94,93,760,-1,760,761,94,-1,762,270,763,-1,763,764,762,-1,131,765,129,-1,131,766,765,-1,767,768,769,-1,767,770,768,-1,136,771,769,-1,769,772,136,-1,773,134,774,-1,773,135,134,-1,775,776,774,-1,775,624,776,-1,777,778,133,-1,133,779,777,-1,777,32,780,-1,777,33,32,-1,781,782,224,-1,224,226,781,-1,783,784,91,-1,59,784,783,-1,783,292,59,-1,775,774,134,-1,134,785,775,-1,135,786,787,-1,135,773,786,-1,763,788,764,-1,763,789,788,-1,790,791,792,-1,790,793,791,-1,759,794,795,-1,795,757,759,-1,752,796,797,-1,759,758,755,-1,755,798,759,-1,139,750,757,-1,758,750,749,-1,285,745,749,-1,745,748,749,-1,741,744,747,-1,747,746,741,-1,739,593,743,-1,741,746,742,-1,746,799,742,-1,285,284,745,-1,593,740,800,-1,800,468,593,-1,300,468,800,-1,32,35,223,-1,737,801,736,-1,801,802,736,-1,736,735,34,-1,736,803,735,-1,803,736,804,-1,736,802,804,-1,768,805,806,-1,768,770,805,-1,309,305,312,-1,309,807,305,-1,308,727,669,-1,727,670,669,-1,720,723,722,-1,720,267,266,-1,808,809,448,-1,808,716,809,-1,723,810,721,-1,21,23,457,-1,23,459,457,-1,712,811,812,-1,712,709,811,-1,23,706,704,-1,704,459,23,-1,177,247,813,-1,177,156,247,-1,156,248,247,-1,814,700,454,-1,700,451,701,-1,700,814,451,-1,247,698,452,-1,452,813,247,-1,242,241,696,-1,696,697,242,-1,245,694,246,-1,245,310,694,-1,694,604,246,-1,694,678,604,-1,693,776,624,-1,624,622,693,-1,692,690,693,-1,690,815,693,-1,618,690,692,-1,692,620,618,-1,689,816,817,-1,689,691,816,-1,686,816,688,-1,686,685,816,-1,679,686,239,-1,679,687,686,-1,687,674,676,-1,676,680,687,-1,672,669,677,-1,669,298,677,-1,666,282,818,-1,666,281,282,-1,241,174,63,-1,241,149,174,-1,661,660,148,-1,660,172,148,-1,658,665,150,-1,150,663,658,-1,819,820,821,-1,819,662,820,-1,258,431,430,-1,430,259,258,-1,260,438,258,-1,438,655,258,-1,654,434,436,-1,654,822,434,-1,653,261,263,-1,653,823,261,-1,440,439,651,-1,651,824,440,-1,825,198,197,-1,648,647,650,-1,650,649,648,-1,826,196,650,-1,650,827,826,-1,828,641,829,-1,830,638,639,-1,831,73,832,-1,231,229,640,-1,833,834,633,-1,833,835,834,-1,638,830,836,-1,836,635,638,-1,635,836,79,-1,79,634,635,-1,230,837,838,-1,230,231,837,-1,839,206,840,-1,839,628,206,-1,75,116,634,-1,75,77,116,-1,626,625,841,-1,841,228,626,-1,621,622,624,-1,624,626,621,-1,842,843,200,-1,629,844,627,-1,629,845,844,-1,846,847,848,-1,846,849,847,-1,850,844,851,-1,850,842,844,-1,852,202,843,-1,852,203,202,-1,852,620,692,-1,692,203,852,-1,853,854,855,-1,853,856,854,-1,613,619,857,-1,613,615,619,-1,618,617,691,-1,618,615,617,-1,420,601,15,-1,15,421,420,-1,238,606,603,-1,606,858,603,-1,599,858,600,-1,12,859,13,-1,12,597,859,-1,417,67,66,-1,860,861,397,-1,397,398,860,-1,154,862,863,-1,863,864,154,-1,865,866,867,-1,866,475,867,-1,154,152,476,-1,476,862,154,-1,868,588,349,-1,67,419,585,-1,585,64,67,-1,321,375,65,-1,65,71,321,-1,70,584,68,-1,869,558,870,-1,871,330,872,-1,873,576,578,-1,873,874,576,-1,573,875,578,-1,573,582,875,-1,354,320,319,-1,319,571,876,-1,876,353,319,-1,110,877,878,-1,110,879,877,-1,880,879,566,-1,881,882,883,-1,881,884,882,-1,567,885,566,-1,567,886,885,-1,887,333,350,-1,887,888,333,-1,560,889,562,-1,889,570,562,-1,890,881,568,-1,890,891,881,-1,557,882,884,-1,557,556,882,-1,892,893,557,-1,355,365,894,-1,400,895,403,-1,400,896,895,-1,897,898,891,-1,891,890,897,-1,898,546,544,-1,545,195,897,-1,897,899,545,-1,545,52,195,-1,537,540,194,-1,537,538,540,-1,50,405,53,-1,50,900,405,-1,536,901,902,-1,536,534,901,-1,903,528,338,-1,528,529,338,-1,527,521,525,-1,567,904,886,-1,904,905,886,-1,342,334,906,-1,907,433,435,-1,435,908,907,-1,7,907,909,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_4()
		{
			int[] value = {910,911,912,-1,911,512,429,-1,45,509,508,-1,508,913,45,-1,914,373,915,-1,916,371,373,-1,188,387,189,-1,370,372,385,-1,372,500,385,-1,501,500,496,-1,496,917,501,-1,362,361,918,-1,495,494,31,-1,494,29,31,-1,494,919,29,-1,919,920,29,-1,491,492,165,-1,492,166,165,-1,486,456,484,-1,346,348,921,-1,348,390,921,-1,474,922,923,-1,923,924,474,-1,450,925,926,-1,450,418,925,-1,927,928,929,-1,929,930,927,-1,927,473,470,-1,927,931,473,-1,932,299,300,-1,299,304,301,-1,593,468,467,-1,169,933,934,-1,934,170,169,-1,459,704,458,-1,704,935,458,-1,454,453,488,-1,926,699,701,-1,449,452,62,-1,808,448,167,-1,448,164,167,-1,446,447,936,-1,936,937,446,-1,937,383,183,-1,937,936,383,-1,938,91,939,-1,91,784,939,-1,434,437,436,-1,434,433,437,-1,823,940,180,-1,180,261,823,-1,430,513,74,-1,430,429,513,-1,72,425,427,-1,72,941,425,-1,85,428,426,-1,426,942,85,-1,81,257,82,-1,408,943,944,-1,944,945,408,-1,925,418,397,-1,397,861,925,-1,432,655,236,-1,432,431,655,-1,659,410,656,-1,659,411,410,-1,946,493,947,-1,545,948,949,-1,949,50,545,-1,950,371,916,-1,190,503,915,-1,189,951,187,-1,456,486,489,-1,489,453,456,-1,589,860,398,-1,398,378,589,-1,492,38,96,-1,952,704,703,-1,952,935,704,-1,155,157,462,-1,325,327,953,-1,953,954,325,-1,387,384,955,-1,917,502,501,-1,917,186,502,-1,366,956,957,-1,957,377,366,-1,378,958,589,-1,396,374,399,-1,396,375,374,-1,499,498,555,-1,579,876,872,-1,579,353,876,-1,959,331,960,-1,582,573,575,-1,510,961,505,-1,506,962,918,-1,918,361,506,-1,356,355,963,-1,47,42,964,-1,47,43,42,-1,965,966,967,-1,965,543,966,-1,554,551,504,-1,551,507,504,-1,894,963,355,-1,539,966,541,-1,871,968,874,-1,871,969,968,-1,970,969,971,-1,970,968,969,-1,873,875,972,-1,873,578,875,-1,870,557,893,-1,870,558,557,-1,327,349,346,-1,973,909,974,-1,906,345,342,-1,906,905,345,-1,975,257,81,-1,975,251,257,-1,337,193,976,-1,337,523,193,-1,977,523,337,-1,386,501,395,-1,958,377,587,-1,958,378,377,-1,978,328,325,-1,19,406,20,-1,19,407,406,-1,805,979,806,-1,980,981,982,-1,728,316,318,-1,304,289,302,-1,289,726,302,-1,793,595,596,-1,596,791,793,-1,297,675,298,-1,675,677,298,-1,936,24,383,-1,280,983,273,-1,280,295,983,-1,984,290,287,-1,297,279,668,-1,279,281,668,-1,985,275,786,-1,275,277,786,-1,282,273,272,-1,282,280,273,-1,271,274,272,-1,788,789,766,-1,179,435,262,-1,634,79,75,-1,85,84,637,-1,637,428,85,-1,105,986,987,-1,423,256,988,-1,243,246,604,-1,604,603,243,-1,602,147,599,-1,147,242,599,-1,251,975,76,-1,975,77,76,-1,989,990,991,-1,213,838,210,-1,213,992,838,-1,161,993,159,-1,161,444,993,-1,226,994,841,-1,994,995,996,-1,995,997,996,-1,228,992,213,-1,228,841,992,-1,998,222,999,-1,998,220,222,-1,216,215,219,-1,216,208,215,-1,1000,211,214,-1,214,207,1000,-1,1001,1002,209,-1,1003,1002,631,-1,631,840,1003,-1,1004,1000,205,-1,205,199,1004,-1,537,53,405,-1,528,565,352,-1,933,394,952,-1,1005,460,1006,-1,1006,1007,1005,-1,1005,461,460,-1,165,164,446,-1,531,520,940,-1,705,1008,155,-1,1008,158,155,-1,1009,1010,1011,-1,591,868,326,-1,585,419,944,-1,419,945,944,-1,168,394,933,-1,933,169,168,-1,186,458,502,-1,186,185,458,-1,171,1005,1007,-1,171,170,1005,-1,167,95,1012,-1,167,166,95,-1,161,536,443,-1,161,160,536,-1,940,520,180,-1,520,178,180,-1,173,945,419,-1,173,175,945,-1,172,174,149,-1,149,148,172,-1,601,663,602,-1,601,664,663,-1,445,1013,1014,-1,1014,1015,445,-1,1016,997,995,-1,787,136,135,-1,787,771,136,-1,636,830,1017,-1,84,252,78,-1,84,83,252,-1,1018,1019,1020,-1,1020,77,1018,-1,1021,987,469,-1,77,117,116,-1,77,1020,117,-1,104,97,100,-1,104,103,97,-1,141,140,1022,-1,143,142,229,-1,139,138,750,-1,1023,1018,77,-1,975,1023,77,-1,78,79,836,-1,72,427,636,-1,1024,646,0,-1,61,449,62,-1,61,416,449,-1,1025,1026,1027,-1,1026,1028,1027,-1,1027,1029,1025,-1,59,939,784,-1,59,58,939,-1,162,405,900,-1,52,51,195,-1,49,43,47,-1,44,39,1030,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_5()
		{
			int[] value = {1030,42,44,-1,39,44,40,-1,39,163,1030,-1,46,36,946,-1,163,56,55,-1,783,222,292,-1,222,221,292,-1,917,30,186,-1,28,721,463,-1,28,27,721,-1,715,809,716,-1,466,14,13,-1,9,12,11,-1,9,8,12,-1,792,598,268,-1,235,6,5,-1,249,250,469,-1,197,1031,825,-1,197,652,1031,-1,825,1032,1033,-1,825,1031,1032,-1,198,1033,649,-1,1033,198,825,-1,792,597,598,-1,792,791,597,-1,466,859,596,-1,466,13,859,-1,1034,819,1035,-1,18,819,1034,-1,20,819,18,-1,1036,715,1037,-1,809,715,1036,-1,222,1016,999,-1,1016,222,783,-1,895,1038,1039,-1,895,896,1038,-1,37,913,1040,-1,913,37,45,-1,49,41,40,-1,49,48,41,-1,819,406,662,-1,819,20,406,-1,1018,80,1041,-1,80,1018,1023,-1,253,87,86,-1,253,986,87,-1,125,122,123,-1,111,122,125,-1,1021,250,878,-1,250,1021,469,-1,1042,125,124,-1,125,1042,988,-1,856,423,854,-1,423,856,424,-1,1019,1041,1043,-1,1041,1019,1018,-1,637,78,836,-1,84,78,637,-1,639,128,1044,-1,126,128,639,-1,126,115,127,-1,115,126,118,-1,1017,72,636,-1,73,72,1017,-1,1045,137,139,-1,1045,1046,137,-1,1047,1048,760,-1,1047,1049,1048,-1,90,997,1016,-1,997,90,143,-1,225,998,999,-1,225,224,998,-1,778,782,785,-1,1050,782,778,-1,787,1051,771,-1,787,1052,1051,-1,445,828,444,-1,828,445,1015,-1,1053,142,89,-1,1053,1054,142,-1,1055,601,420,-1,1055,664,601,-1,929,1056,68,-1,928,1056,929,-1,1057,585,944,-1,1057,584,585,-1,1058,420,422,-1,1058,1055,420,-1,328,591,326,-1,328,415,591,-1,864,978,1059,-1,864,413,978,-1,934,952,703,-1,934,933,952,-1,441,531,940,-1,441,532,531,-1,442,536,902,-1,443,536,442,-1,1060,1061,938,-1,1060,1062,1061,-1,57,464,463,-1,57,56,464,-1,937,29,920,-1,183,29,937,-1,502,935,393,-1,935,502,458,-1,393,952,394,-1,952,393,935,-1,463,95,57,-1,463,1012,95,-1,1063,976,339,-1,976,1063,903,-1,53,194,51,-1,194,53,537,-1,232,641,1064,-1,232,234,641,-1,824,1013,440,-1,824,1014,1013,-1,652,642,218,-1,652,197,642,-1,653,1031,652,-1,1031,653,263,-1,840,633,839,-1,840,631,633,-1,996,143,230,-1,143,996,997,-1,223,293,221,-1,223,35,293,-1,781,841,625,-1,841,781,226,-1,841,996,992,-1,841,994,996,-1,837,210,838,-1,837,630,210,-1,629,1065,848,-1,629,628,1065,-1,846,1020,1019,-1,846,1066,1020,-1,1053,1061,181,-1,89,1061,1053,-1,796,594,595,-1,796,592,594,-1,790,1067,1068,-1,1067,790,1069,-1,1070,1071,1022,-1,684,1071,1070,-1,290,286,291,-1,290,284,286,-1,284,984,799,-1,290,984,284,-1,1072,1008,1073,-1,158,1072,702,-1,1072,158,1008,-1,303,269,301,-1,303,1074,269,-1,1075,982,1076,-1,1075,980,982,-1,734,1077,1078,-1,734,733,1077,-1,1079,805,1080,-1,805,1079,979,-1,1081,1082,930,-1,1081,1083,1082,-1,19,1084,407,-1,18,1084,19,-1,580,69,1085,-1,580,322,69,-1,1086,893,892,-1,914,893,1086,-1,384,395,392,-1,384,386,395,-1,350,335,351,-1,333,335,350,-1,1087,526,522,-1,1087,1088,526,-1,519,531,191,-1,520,531,519,-1,977,518,523,-1,1089,518,977,-1,886,906,888,-1,886,905,906,-1,1090,909,1091,-1,974,909,1090,-1,873,331,330,-1,331,873,972,-1,970,1092,1093,-1,1094,1092,970,-1,1095,1093,1092,-1,1095,1096,1093,-1,1093,968,970,-1,968,1093,1097,-1,971,1094,970,-1,885,1094,971,-1,556,869,380,-1,869,556,558,-1,522,344,1087,-1,344,522,342,-1,966,182,1062,-1,539,182,966,-1,554,963,894,-1,554,504,963,-1,359,47,964,-1,359,358,47,-1,892,498,1086,-1,892,555,498,-1,967,47,965,-1,47,967,48,-1,965,358,1098,-1,965,47,358,-1,505,962,506,-1,505,961,962,-1,960,368,959,-1,368,960,369,-1,329,872,330,-1,329,579,872,-1,387,1007,1006,-1,387,955,1007,-1,953,923,922,-1,921,923,953,-1,954,978,325,-1,1059,978,954,-1,586,486,487,-1,586,489,486,-1,170,155,1005,-1,170,934,155,-1,1099,414,863,-1,1099,590,414,-1,588,860,589,-1,860,588,1100,-1,374,368,367,-1,374,324,368,-1,488,157,1011,-1,462,157,488,-1,503,870,915,-1,503,869,870,-1,360,1101,549,-1,1101,360,550,-1,498,916,1086,-1,498,363,916,-1,949,534,535,-1,1102,534,949,-1,533,530,901,-1,341,530,533,-1,946,511,46,-1,511,946,947,-1,473,1028,471,-1,1028,473,1027,-1,1082,1103,931,-1,1103,1082,1104,-1,1026,656,410,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_6()
		{
			int[] value = {1025,656,1026,-1,146,472,144,-1,146,470,472,-1,65,396,66,-1,375,396,65,-1,248,729,245,-1,702,729,248,-1,854,1105,855,-1,1105,854,1042,-1,74,941,72,-1,74,513,941,-1,938,89,91,-1,89,938,1061,-1,457,184,383,-1,457,185,184,-1,808,1012,810,-1,808,167,1012,-1,926,451,450,-1,451,926,701,-1,700,455,454,-1,700,482,455,-1,951,460,462,-1,951,189,460,-1,477,1059,954,-1,477,153,1059,-1,930,931,927,-1,930,1082,931,-1,928,470,146,-1,927,470,928,-1,1057,930,929,-1,1081,930,1057,-1,418,449,416,-1,418,450,449,-1,479,699,926,-1,479,478,699,-1,925,924,1106,-1,925,867,924,-1,476,176,474,-1,476,152,176,-1,923,1106,924,-1,1106,923,389,-1,485,481,480,-1,485,484,481,-1,327,921,953,-1,327,346,921,-1,166,96,95,-1,492,96,166,-1,920,491,165,-1,919,491,920,-1,493,962,947,-1,962,493,918,-1,950,918,493,-1,918,950,362,-1,387,370,385,-1,387,188,370,-1,1006,189,387,-1,1006,460,189,-1,373,1086,916,-1,914,1086,373,-1,951,957,956,-1,951,490,957,-1,506,963,504,-1,506,356,963,-1,38,1040,96,-1,38,37,1040,-1,1038,163,55,-1,1030,163,1038,-1,55,1039,1038,-1,55,54,1039,-1,432,911,429,-1,432,912,911,-1,512,516,991,-1,512,911,516,-1,990,941,991,-1,990,425,941,-1,974,910,973,-1,974,514,910,-1,907,437,433,-1,907,7,437,-1,908,909,907,-1,908,1091,909,-1,343,425,990,-1,425,343,426,-1,1088,1090,1107,-1,1088,517,1090,-1,1091,518,1089,-1,518,1091,908,-1,526,1107,524,-1,1088,1107,526,-1,905,942,345,-1,905,904,942,-1,114,904,567,-1,114,83,904,-1,337,903,338,-1,976,903,337,-1,340,1063,339,-1,1063,340,1108,-1,1108,559,563,-1,1109,559,1108,-1,533,1110,340,-1,1102,1110,533,-1,1111,1110,948,-1,1109,1110,1111,-1,1111,889,560,-1,899,889,1111,-1,535,50,949,-1,50,535,900,-1,899,890,889,-1,899,897,890,-1,195,898,897,-1,195,546,898,-1,547,898,548,-1,547,891,898,-1,1062,967,966,-1,1060,967,1062,-1,543,1098,544,-1,965,1098,543,-1,553,894,365,-1,553,554,894,-1,552,364,555,-1,552,365,364,-1,914,870,893,-1,870,914,915,-1,1101,555,892,-1,1101,552,555,-1,884,891,547,-1,891,884,881,-1,568,889,890,-1,889,568,570,-1,888,885,886,-1,888,1094,885,-1,577,562,570,-1,562,577,1112,-1,1096,564,561,-1,564,1096,1095,-1,880,885,971,-1,566,885,880,-1,566,110,112,-1,566,879,110,-1,1097,874,968,-1,874,1097,576,-1,879,1113,877,-1,879,880,1113,-1,877,1114,1115,-1,877,1113,1114,-1,1115,876,571,-1,1115,1114,876,-1,1114,969,871,-1,1113,969,1114,-1,581,353,579,-1,353,581,354,-1,572,1056,145,-1,1056,572,1085,-1,104,575,574,-1,100,575,104,-1,582,101,583,-1,101,582,99,-1,569,574,573,-1,569,883,574,-1,379,582,380,-1,379,875,582,-1,874,330,871,-1,874,873,330,-1,583,556,380,-1,583,882,556,-1,972,960,331,-1,972,1116,960,-1,68,1085,69,-1,1056,1085,68,-1,379,1117,1116,-1,382,1117,379,-1,366,1117,956,-1,369,1117,366,-1,374,376,399,-1,376,374,367,-1,862,475,866,-1,862,476,475,-1,866,863,862,-1,863,866,1099,-1,1100,861,860,-1,1100,865,861,-1,17,421,15,-1,17,254,421,-1,1118,605,1119,-1,1118,16,605,-1,1120,1042,124,-1,1042,1120,1105,-1,1121,613,857,-1,611,613,1121,-1,612,855,1105,-1,612,1122,855,-1,1123,855,1122,-1,1123,853,855,-1,1124,857,851,-1,1124,1121,857,-1,850,620,852,-1,850,619,620,-1,852,842,850,-1,852,843,842,-1,1124,844,845,-1,851,844,1124,-1,853,847,849,-1,853,1123,847,-1,1019,849,846,-1,1019,1043,849,-1,629,847,845,-1,848,847,629,-1,842,627,844,-1,627,842,200,-1,227,626,228,-1,626,227,621,-1,212,623,227,-1,623,212,1004,-1,1066,117,1020,-1,1066,1125,117,-1,628,1126,1065,-1,628,839,1126,-1,205,840,206,-1,1003,840,205,-1,212,1000,1004,-1,212,211,1000,-1,1126,1127,1125,-1,1126,834,1127,-1,834,1128,1127,-1,835,1128,834,-1,833,632,1129,-1,833,633,632,-1,1130,209,208,-1,1130,1001,209,-1,229,1054,640,-1,1054,229,142,-1,837,640,234,-1,231,640,837,-1,1017,832,73,-1,1044,832,1017,-1,1128,644,127,-1,645,644,1128,-1,833,1131,835,-1,827,1131,833,-1,826,1130,642,-1,826,1129,1130,-1,215,232,219,-1,215,233,232,-1,827,647,1131,-1,827,650,647,-1,74,831,1132,-1,73,831,74,-1,653,439,823,-1,653,651,439,-1,1132,430,74,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_7()
		{
			int[] value = {1132,259,430,-1,822,1032,264,-1,822,4,1032,-1,264,434,822,-1,264,262,434,-1,3,260,259,-1,3,654,260,-1,657,665,658,-1,657,820,665,-1,412,1055,1058,-1,412,411,1055,-1,242,858,599,-1,697,858,242,-1,668,1133,1134,-1,667,1133,668,-1,681,1133,1071,-1,681,1134,1133,-1,680,685,687,-1,680,1135,685,-1,1136,1135,683,-1,1136,817,1135,-1,617,816,691,-1,617,688,816,-1,689,1136,1137,-1,689,817,1136,-1,985,815,1137,-1,985,1138,815,-1,693,1138,776,-1,815,1138,693,-1,697,603,858,-1,697,243,603,-1,63,696,241,-1,696,63,698,-1,451,813,452,-1,814,813,451,-1,813,1009,177,-1,813,814,1009,-1,812,706,23,-1,706,812,1073,-1,712,23,22,-1,712,812,23,-1,21,383,24,-1,457,383,21,-1,25,717,707,-1,1037,717,25,-1,808,723,716,-1,810,723,808,-1,447,809,1036,-1,447,448,809,-1,714,1139,1140,-1,714,719,1139,-1,292,724,26,-1,292,294,724,-1,725,303,302,-1,725,314,303,-1,312,694,310,-1,312,695,694,-1,315,305,807,-1,315,306,305,-1,805,1141,1080,-1,770,1141,805,-1,1077,1079,317,-1,1076,1079,1077,-1,1142,1072,811,-1,1142,732,1072,-1,980,1142,1143,-1,1075,1142,980,-1,979,981,806,-1,981,979,982,-1,709,1144,1143,-1,711,1144,709,-1,1144,804,981,-1,1144,1145,804,-1,806,801,768,-1,806,802,801,-1,1145,803,804,-1,1146,803,1145,-1,1147,1139,1148,-1,1147,1146,1139,-1,1146,735,803,-1,1146,1147,735,-1,738,289,288,-1,738,726,289,-1,932,800,1149,-1,932,300,800,-1,818,272,274,-1,818,282,272,-1,740,1149,800,-1,740,1150,1149,-1,1150,799,984,-1,1150,742,799,-1,138,286,283,-1,286,138,983,-1,799,745,284,-1,745,799,746,-1,756,744,754,-1,756,747,744,-1,756,798,755,-1,1151,798,756,-1,797,595,793,-1,797,796,595,-1,1151,1068,1067,-1,1151,753,1068,-1,794,798,1152,-1,759,798,794,-1,757,1045,139,-1,757,795,1045,-1,666,1046,1049,-1,666,818,1046,-1,794,1153,795,-1,1154,1153,794,-1,1067,1155,1152,-1,1069,1155,1067,-1,1069,792,268,-1,790,792,1069,-1,1154,761,1153,-1,1154,762,761,-1,1049,667,666,-1,667,1049,1047,-1,730,766,789,-1,731,766,730,-1,764,92,94,-1,764,788,92,-1,131,788,766,-1,131,92,788,-1,773,985,786,-1,773,1138,985,-1,765,1051,129,-1,767,1051,765,-1,786,1052,787,-1,786,277,1052,-1,779,801,737,-1,772,801,779,-1,775,782,781,-1,775,785,782,-1,32,220,780,-1,223,220,32,-1,90,783,91,-1,783,90,1016,-1,780,998,1050,-1,220,998,780,-1,625,775,781,-1,624,775,625,-1,1050,777,780,-1,778,777,1050,-1,737,777,779,-1,33,777,737,-1,774,1138,773,-1,1138,774,776,-1,772,133,136,-1,772,779,133,-1,772,768,801,-1,772,769,768,-1,767,771,1051,-1,767,769,771,-1,767,1141,770,-1,767,765,1141,-1,277,132,1052,-1,277,276,132,-1,1070,132,276,-1,130,132,1070,-1,731,765,766,-1,731,1141,765,-1,1070,140,130,-1,1070,1022,140,-1,269,763,270,-1,269,1074,763,-1,94,762,764,-1,94,761,762,-1,1133,1047,141,-1,1133,667,1047,-1,1153,760,1048,-1,1153,761,760,-1,762,1155,270,-1,762,1154,1155,-1,1154,1152,1155,-1,1154,794,1152,-1,795,1048,1045,-1,1153,1048,795,-1,1046,274,137,-1,274,1046,818,-1,1152,1151,1067,-1,798,1151,1152,-1,752,1068,753,-1,752,797,1068,-1,748,758,749,-1,758,748,755,-1,592,752,751,-1,796,752,592,-1,756,753,1151,-1,753,756,754,-1,743,754,744,-1,751,754,743,-1,291,983,295,-1,983,291,286,-1,740,742,1150,-1,740,739,742,-1,1149,984,287,-1,1149,1150,984,-1,932,287,289,-1,1149,287,932,-1,670,726,738,-1,670,727,726,-1,1148,293,1147,-1,294,293,1148,-1,1146,1140,1139,-1,1146,1145,1140,-1,804,806,981,-1,806,804,802,-1,711,1145,1144,-1,711,1140,1145,-1,1143,981,980,-1,1144,981,1143,-1,1076,979,1079,-1,1076,982,979,-1,811,1143,1142,-1,811,709,1143,-1,1075,732,1142,-1,1075,733,732,-1,1078,317,313,-1,1078,1077,317,-1,702,732,729,-1,1072,732,702,-1,313,807,1078,-1,313,315,807,-1,731,1080,1141,-1,731,318,1080,-1,306,314,725,-1,314,306,315,-1,1074,728,730,-1,728,1074,303,-1,695,305,307,-1,695,312,305,-1,299,289,304,-1,299,932,289,-1,722,26,724,-1,26,722,27,-1,294,718,724,-1,1148,718,294,-1,719,1148,1139,-1,718,1148,719,-1,719,713,267,-1,714,713,719,-1,1037,265,717,-1,1037,715,265,-1,1036,936,447,-1,1036,24,936,-1,713,707,717,-1,713,708,707,-1,1140,710,714,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_8()
		{
			int[] value = {1140,711,710,-1,22,710,712,-1,22,708,710,-1,707,21,25,-1,707,22,21,-1,1073,705,706,-1,1073,1008,705,-1,454,1009,814,-1,454,1010,1009,-1,62,698,63,-1,62,452,698,-1,1137,690,689,-1,1137,815,690,-1,985,1136,275,-1,985,1137,1136,-1,275,683,278,-1,275,1136,683,-1,816,1135,817,-1,816,685,1135,-1,683,680,682,-1,680,683,1135,-1,682,1071,684,-1,682,681,1071,-1,687,673,674,-1,673,687,679,-1,675,681,676,-1,681,675,1134,-1,672,674,673,-1,674,672,677,-1,671,307,672,-1,695,307,671,-1,1134,297,668,-1,297,1134,675,-1,409,945,175,-1,409,408,945,-1,664,411,659,-1,411,664,1055,-1,1029,820,657,-1,821,820,1029,-1,1025,657,656,-1,1029,657,1025,-1,654,4,822,-1,654,3,4,-1,259,0,3,-1,1132,0,259,-1,2,649,1033,-1,648,649,2,-1,1132,1024,0,-1,1132,831,1024,-1,831,1156,1024,-1,831,832,1156,-1,643,1131,647,-1,645,1131,643,-1,219,1064,217,-1,219,232,1064,-1,1130,216,642,-1,216,1130,208,-1,1129,827,833,-1,826,827,1129,-1,645,835,1131,-1,645,1128,835,-1,832,128,1156,-1,832,1044,128,-1,630,215,214,-1,630,233,215,-1,632,1002,1001,-1,631,1002,632,-1,127,1127,1128,-1,127,115,1127,-1,115,1125,1127,-1,117,1125,115,-1,839,834,1126,-1,839,633,834,-1,209,1003,207,-1,209,1002,1003,-1,1003,1000,207,-1,1003,205,1000,-1,1065,1125,1066,-1,1065,1126,1125,-1,206,200,199,-1,206,627,200,-1,623,621,227,-1,623,204,621,-1,853,1043,856,-1,853,849,1043,-1,1123,845,847,-1,1123,1124,845,-1,619,851,857,-1,850,851,619,-1,1122,1124,1123,-1,1122,1121,1124,-1,612,1121,1122,-1,612,611,1121,-1,616,609,608,-1,609,616,614,-1,609,613,611,-1,609,614,613,-1,610,1105,1120,-1,612,1105,610,-1,1120,607,610,-1,1120,1119,607,-1,124,1119,1120,-1,1119,124,1118,-1,1119,606,607,-1,605,606,1119,-1,616,688,617,-1,616,240,688,-1,858,605,600,-1,606,605,858,-1,268,8,10,-1,598,8,268,-1,465,594,467,-1,595,594,465,-1,1099,865,1100,-1,1099,866,865,-1,868,590,588,-1,868,591,590,-1,958,347,589,-1,347,958,483,-1,377,586,587,-1,377,957,586,-1,377,367,366,-1,367,377,376,-1,956,382,951,-1,1117,382,956,-1,1116,369,960,-1,1117,369,1116,-1,959,329,331,-1,959,323,329,-1,875,1116,972,-1,875,379,1116,-1,583,883,882,-1,583,574,883,-1,100,582,575,-1,99,582,100,-1,583,104,574,-1,104,583,101,-1,581,1085,572,-1,580,1085,581,-1,145,119,572,-1,145,120,119,-1,872,1114,871,-1,876,1114,872,-1,571,1021,1115,-1,1021,571,108,-1,878,1115,1021,-1,878,877,1115,-1,1113,971,969,-1,880,971,1113,-1,576,1112,577,-1,576,1097,1112,-1,1095,887,564,-1,1095,1092,887,-1,1112,561,562,-1,561,1112,1096,-1,569,577,570,-1,573,577,569,-1,563,561,564,-1,563,559,561,-1,547,557,884,-1,547,549,557,-1,869,381,380,-1,869,503,381,-1,508,551,401,-1,551,508,507,-1,913,403,895,-1,913,508,403,-1,551,550,402,-1,553,550,551,-1,550,552,1101,-1,550,553,552,-1,360,1098,358,-1,1098,360,548,-1,1060,48,967,-1,48,1060,41,-1,544,548,898,-1,1098,548,544,-1,546,542,544,-1,540,542,546,-1,543,541,966,-1,541,543,542,-1,900,160,162,-1,900,535,160,-1,948,899,1111,-1,545,899,948,-1,1109,560,559,-1,1109,1111,560,-1,1102,948,1110,-1,1102,949,948,-1,1109,340,1110,-1,1109,1108,340,-1,565,1108,563,-1,565,1063,1108,-1,530,192,191,-1,530,341,192,-1,532,901,530,-1,532,902,901,-1,193,519,191,-1,523,519,193,-1,334,888,906,-1,334,333,888,-1,351,525,529,-1,527,525,351,-1,336,977,337,-1,977,336,524,-1,85,904,83,-1,942,904,85,-1,1088,515,517,-1,1088,1087,515,-1,524,1089,977,-1,1107,1089,524,-1,908,178,518,-1,908,179,178,-1,908,435,179,-1,1107,1091,1089,-1,1107,1090,1091,-1,426,345,942,-1,345,426,343,-1,990,344,343,-1,990,989,344,-1,514,1090,517,-1,514,974,1090,-1,973,7,909,-1,973,5,7,-1,989,516,515,-1,989,991,516,-1,513,991,941,-1,513,512,991,-1,973,235,5,-1,910,235,973,-1,912,235,910,-1,432,235,912,-1,235,432,236,-1,896,964,42,-1,896,400,964,-1,1039,96,1040,-1,96,1039,54,-1,511,510,509,-1,511,961,510,-1,507,505,504,-1,510,505,507,-1,364,361,499,-1,361,364,357,-1,381,951,382,-1,381,187,951,-1,394,332,392,-1,394,168,332,-1,371,497,372,-1,371,950,497,-1,495,950,493,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_9()
		{
			int[] value = {495,497,950,-1,494,946,919,-1,946,494,493,-1,36,919,946,-1,36,491,919,-1,957,489,586,-1,489,957,490,-1,388,487,485,-1,388,483,487,-1,954,922,477,-1,953,922,954,-1,388,480,391,-1,388,485,480,-1,455,484,456,-1,484,455,481,-1,480,482,478,-1,482,480,481,-1,479,389,391,-1,479,1106,389,-1,474,477,922,-1,176,477,474,-1,477,176,151,-1,867,474,924,-1,475,474,867,-1,926,1106,479,-1,1106,926,925,-1,943,1057,944,-1,943,1081,1057,-1,1083,1104,1082,-1,1104,1083,1034,-1,410,1028,1026,-1,471,1028,410,-1,986,107,87,-1,986,105,107,-1,679,671,673,-1,679,678,671,-1,26,464,60,-1,28,464,26,-1,1011,454,488,-1,1011,1010,454,-1,478,700,699,-1,700,478,482,-1,587,483,958,-1,587,487,483,-1,721,1012,463,-1,721,810,1012,-1,1053,159,993,-1,1053,181,159,-1,1013,442,440,-1,1013,443,442,-1,1013,445,443,-1,439,940,823,-1,439,441,940,-1,1157,254,17,-1,1157,255,254,-1,255,123,249,-1,255,1157,123,-1,120,88,121,-1,120,422,88,-1,925,865,867,-1,925,861,865,-1,412,144,472,-1,1058,144,412,-1,472,410,412,-1,471,410,472,-1,931,1027,473,-1,1027,931,1103,-1,943,1083,1081,-1,943,1084,1083,-1,407,943,408,-1,943,407,1084,-1,820,661,665,-1,820,662,661,-1,901,1102,533,-1,901,534,1102,-1,549,892,557,-1,892,549,1101,-1,961,947,962,-1,511,947,961,-1,959,324,323,-1,368,324,959,-1,590,1100,588,-1,1100,590,1099,-1,413,863,414,-1,413,864,863,-1,462,1005,155,-1,462,461,1005,-1,490,462,488,-1,462,490,951,-1,389,921,390,-1,389,923,921,-1,955,171,1007,-1,332,171,955,-1,500,386,385,-1,386,500,501,-1,359,400,402,-1,400,359,964,-1,539,538,404,-1,541,538,539,-1,363,950,916,-1,363,362,950,-1,357,506,361,-1,357,356,506,-1,989,1087,344,-1,989,515,1087,-1,1097,1096,1112,-1,1097,1093,1096,-1,887,352,564,-1,352,887,350,-1,569,881,883,-1,569,568,881,-1,887,1094,888,-1,1092,1094,887,-1,327,868,349,-1,327,326,868,-1,514,911,910,-1,514,516,911,-1,521,526,525,-1,521,522,526,-1,336,529,525,-1,529,336,338,-1,335,342,522,-1,335,334,342,-1,955,392,332,-1,955,384,392,-1,188,915,373,-1,190,915,188,-1,917,31,30,-1,31,917,496,-1,329,322,580,-1,323,322,329,-1,572,354,581,-1,572,320,354,-1,1084,1034,1083,-1,1034,1084,18,-1,317,1080,318,-1,1080,317,1079,-1,1078,309,734,-1,309,1078,807,-1,733,1076,1077,-1,733,1075,1076,-1,734,311,732,-1,734,309,311,-1,725,308,306,-1,725,727,308,-1,789,1074,730,-1,789,763,1074,-1,1073,811,1072,-1,811,1073,812,-1,720,716,723,-1,266,716,720,-1,295,288,291,-1,288,295,738,-1,271,983,138,-1,271,273,983,-1,684,276,278,-1,684,1070,276,-1,141,1071,1133,-1,1071,141,1022,-1,1068,793,790,-1,1068,797,793,-1,301,10,299,-1,301,269,10,-1,1155,268,270,-1,1069,268,1155,-1,261,179,262,-1,261,180,179,-1,1129,1001,1130,-1,1129,632,1001,-1,257,109,82,-1,113,109,257,-1,988,111,125,-1,988,256,111,-1,240,608,238,-1,608,240,616,-1,848,1066,846,-1,848,1065,1066,-1,438,236,655,-1,438,237,236,-1,234,630,837,-1,233,630,234,-1,994,225,995,-1,225,994,226,-1,35,1147,293,-1,35,735,1147,-1,992,230,838,-1,230,992,996,-1,843,201,200,-1,843,202,201,-1,201,1004,199,-1,1004,201,623,-1,1031,264,1032,-1,1031,263,264,-1,218,824,651,-1,218,217,824,-1,197,826,642,-1,196,826,197,-1,1064,828,1015,-1,828,1064,641,-1,217,1014,824,-1,1064,1014,217,-1,1064,1015,1014,-1,640,829,641,-1,640,1054,829,-1,339,193,192,-1,193,339,976,-1,565,903,1063,-1,903,565,528,-1,939,39,41,-1,39,939,58,-1,446,920,165,-1,937,920,446,-1,60,56,163,-1,464,56,60,-1,41,938,939,-1,41,1060,938,-1,181,1062,182,-1,1061,1062,181,-1,441,902,532,-1,442,902,441,-1,705,934,703,-1,934,705,155,-1,1011,177,1009,-1,157,177,1011,-1,1059,154,864,-1,153,154,1059,-1,415,978,413,-1,978,415,328,-1,150,602,663,-1,602,150,147,-1,1057,68,584,-1,929,68,1057,-1,928,145,1056,-1,146,145,928,-1,144,422,120,-1,1058,422,144,-1,993,1054,1053,-1,1054,993,829,-1,444,829,993,-1,444,828,829,-1,785,133,778,-1,134,133,785,-1,129,1052,132,-1,129,1051,1052,-1,130,92,131,-1,140,92,130,-1,224,1050,998,-1,782,1050,224,-1,995,999,1016,-1,225,999,995,-1};
			return value;
		}
		private int[] getrscapula_Geo_6_195_coordIndex_10()
		{
			int[] value = {141,760,93,-1,1047,760,141,-1,1046,1048,1049,-1,1046,1045,1048,-1,1024,644,646,-1,1024,1156,644,-1,1157,16,1118,-1,16,1157,17,-1,1017,639,1044,-1,1017,830,639,-1,836,636,637,-1,836,830,636,-1,1156,127,644,-1,128,127,1156,-1,424,1043,1041,-1,424,856,1043,-1,854,988,1042,-1,988,854,423,-1,123,1118,124,-1,1157,1118,123,-1,114,252,83,-1,252,114,113,-1,878,122,110,-1,122,878,250,-1,108,987,1021,-1,987,108,105,-1,107,119,121,-1,119,107,106,-1,987,253,469,-1,986,253,987,-1,97,102,98,-1,97,103,102,-1,99,102,101,-1,99,98,102,-1,1041,82,424,-1,82,1041,80,-1,1023,81,80,-1,81,1023,975,-1,71,64,70,-1,71,65,64,-1,1027,1035,1029,-1,1027,1103,1035,-1,662,409,660,-1,662,406,409,-1,44,49,40,-1,44,43,49,-1,1040,895,1039,-1,1040,913,895,-1,896,1030,1038,-1,896,42,1030,-1,1037,24,1036,-1,25,24,1037,-1,1104,1035,1103,-1,1035,1104,1034,-1,821,1035,819,-1,1035,821,1029,-1,859,791,596,-1,859,597,791,-1,4,1033,1032,-1,1033,4,2,-1,0,643,1,-1,0,646,643,-1};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getrscapula_Coord_7_195_point_1()
		{
			double[] value = {-4.19604,47.72327,-3.38784,-4.10954,47.76282,-3.35243,-3.92743,47.7394,-3.44275,-4.03452,47.55832,-3.52761,-3.82448,47.67121,-3.56196,-3.89604,47.14915,-3.51935,-3.90249,47.07804,-3.5703,-3.7236,47.20515,-3.62973,-5.83941,49.9684,-1.23931,-5.82367,49.94635,-1.26886,-5.72915,49.9775,-1.41584,-5.83927,49.929,-1.08113,-5.83252,49.95229,-1.07623,-5.89321,49.90431,-.85134,-5.93307,49.87629,-.83844,-5.91463,48.91863,-1.87941,-5.77666,48.86614,-1.94547,-5.78492,48.84824,-1.93963,-5.62159,49.1426,-1.40265,-5.62196,49.15337,-1.40844,-5.6286,49.16086,-1.42389,-4.13964,50.03933,-1.7086,-4.14814,49.88125,-1.81147,-4.35546,49.82347,-1.68458,-3.86091,50.27899,-1.67242,-3.86369,50.25999,-1.68747,-2.84104,50.44565,-2.7316,-2.8377,50.52029,-2.58701,-2.80418,50.53331,-2.62858,-3.94134,50.31632,-1.44402,-4.05512,50.1923,-1.42491,-4.04713,50.11964,-1.40674,-3.50285,50.30873,-3.04877,-3.73812,50.29542,-3.00857,-3.70936,50.25048,-2.96282,-3.44954,50.30341,-2.98773,-3.54252,50.40625,-1.83744,-3.26781,50.49174,-2.01756,-3.23819,50.56929,-2.04436,-2.74685,50.19853,-2.76737,-2.73502,50.17941,-2.73884,-2.75085,50.17383,-2.79333,-2.78369,50.30097,-2.58776,-2.80407,50.18822,-2.69669,-2.73828,50.18242,-2.73642,-3.28581,50.46623,-2.01596,-3.55049,50.38703,-1.85046,-2.94274,50.16509,-2.62615,-2.80857,50.16321,-2.72086,-2.80464,50.17346,-2.69808,-2.91331,49.42361,-2.96563,-3.11107,49.46516,-2.77339,-3.15506,49.44815,-2.79086,-2.87584,49.43269,-2.9379,-2.8437,50.50827,-2.41986,-2.77207,50.43073,-2.57561,-2.76175,50.48542,-2.61676,-2.88272,50.59473,-2.44682,-2.7466,50.20767,-2.77553,-2.86307,50.32294,-2.85765,-2.74411,50.36385,-2.6897,-5.73998,49.45323,-1.06662,-5.4757,49.56484,-1.23343,-5.57646,49.54042,-1.43975,-5.53055,49.18875,-1.14652,-5.45525,49.20259,-1.17765,-5.50533,49.29832,-1.04377,-5.60538,49.31764,-1.06678,-5.61295,48.87747,-1.18104,-5.49573,48.89755,-1.22124,-5.52588,49.03251,-1.1586,-5.4322,49.06087,-1.20893,-4.87159,47.64765,-2.93286,-4.85912,47.65263,-2.95483,-4.78137,47.44053,-2.94613,-5.28641,48.15868,-2.66123,-5.30505,48.17422,-2.6438,-5.24143,48.2466,-2.69472,-5.26039,48.00596,-2.63397,-5.24727,48.02132,-2.64731,-5.38575,48.37138,-2.45897,-5.38294,48.36357,-2.43714,-5.42671,48.448,-2.30632,-5.38487,48.21693,-2.39248,-5.26693,47.99668,-2.62247,-5.24987,47.98508,-2.58343,-5.75531,48.75647,-1.84748,-5.74717,48.74718,-1.82778,-5.86346,48.7778,-1.76887,-2.81841,49.89041,-3.12396,-2.93647,50.02958,-3.0509,-2.85878,50.06145,-3.02356,-5.41989,50.03762,-2.48364,-5.6212,49.97061,-2.38757,-5.60671,50.01253,-2.36138,-3.0189,50.66776,-2.27938,-3.05415,50.6031,-2.22303,-4.61522,49.32421,-2.13949,-4.68408,49.32852,-2.12824,-4.67478,49.30826,-2.1112};
			return value;
		}
		private double[] getrscapula_Coord_7_195_point_2()
		{
			double[] value = {-4.61951,49.30867,-2.18524,-4.61227,49.38104,-2.14819,-4.63806,49.38259,-2.1559,-4.60269,49.35825,-2.15333,-4.59294,49.35321,-2.18967,-5.64628,48.65452,-1.84339,-5.70952,48.71818,-1.71584,-5.72541,48.71768,-1.73293,-5.62911,48.65678,-1.83137,-5.43714,48.41086,-2.22206,-5.43127,48.50308,-2.1118,-5.44563,48.50296,-2.12733,-5.4258,48.40937,-2.20622,-5.40118,48.31134,-2.32552,-5.39269,48.30781,-2.30922,-4.91136,48.12599,-2.89328,-5.10299,48.17102,-2.78681,-5.08172,48.18455,-2.79367,-4.93444,48.11281,-2.88896,-5.79164,48.75102,-1.64429,-5.91964,48.74904,-1.58405,-5.81079,48.75273,-1.66101,-5.46502,48.51592,-2.10296,-5.59888,48.68596,-2.09591,-5.58175,48.69566,-2.10411,-5.57314,48.66805,-2.12153,-4.84068,48.00189,-2.98705,-4.81524,48.01158,-2.99635,-4.82404,47.99033,-3.00145,-5.07988,50.08527,-2.73038,-5.21912,50.069,-2.62726,-5.21593,50.08478,-2.62621,-5.08707,50.06735,-2.7252,-4.33076,49.99959,-3.12945,-4.32962,49.98791,-3.11782,-4.55198,50.00463,-3.02489,-4.54901,50.01997,-3.03598,-6.45889,49.68776,-2.01523,-6.53271,49.65638,-1.86644,-6.47367,49.70314,-2.0215,-5.42025,50.02224,-2.48787,-5.62467,49.95013,-2.38145,-2.83982,49.88187,-3.12797,-2.9565,50.01279,-3.04785,-5.92263,48.75732,-1.57582,-5.86285,48.73013,-1.42494,-5.86968,48.7368,-1.42345,-5.82186,49.2826,-1.71472,-5.77053,49.40077,-1.49141,-5.76383,49.41746,-1.50048,-5.83164,49.2733,-1.69717,-6.12695,49.35568,-.30527,-6.1267,49.35988,-.32684,-6.13959,49.26628,-.2797,-6.13722,49.2585,-.2964,-4.7091,49.61558,-1.5908,-4.78537,49.54864,-1.49507,-4.77242,49.54481,-1.47968,-4.71687,49.61851,-1.60698,-2.74925,49.50242,-3.26637,-2.76281,49.3522,-3.32643,-2.76914,49.35591,-3.34651,-2.73147,49.50127,-3.23784,-2.74154,50.35068,-2.67366,-3.46882,50.63636,-1.79402,-3.47151,50.62599,-1.77017,-3.21947,50.69885,-2.08775,-3.22835,50.71014,-2.09844,-4.67105,49.6634,-1.26908,-4.68136,49.66835,-1.26955,-4.65906,49.61615,-1.39501,-4.64766,49.6092,-1.39021,-5.76758,49.45458,-1.39454,-5.7294,49.4251,-1.11028,-5.75874,49.46947,-1.40042,-5.7255,49.40981,-1.12556,-6.12364,49.36126,-.31634,-4.79188,49.55176,-1.48282,-3.2914,47.96346,-3.65888,-3.28767,47.94844,-3.66843,-3.28905,47.95569,-3.68008,-2.72185,49.67623,-3.19023,-2.71955,49.66783,-3.17168,-3.94685,50.32644,-1.4529,-4.05196,50.20858,-1.4402,-4.18879,50.0684,-1.45893,-4.18393,50.05797,-1.44579,-4.66032,49.48261,-1.49281,-4.49468,49.56048,-1.51555,-4.64998,49.50708,-1.46635,-4.57038,49.52095,-1.61026,-3.0662,48.43489,-3.4983,-3.15493,48.49672,-3.36856,-3.17832,48.4793,-3.36715,-3.09201,49.49247,-2.78212,-3.21039,49.47801,-2.74342,-3.7367,48.30264,-3.33475,-3.52323,48.42775,-3.42852,-3.62181,48.18175,-3.49294,-4.12841,49.09464,-2.77478};
			return value;
		}
		private double[] getrscapula_Coord_7_195_point_3()
		{
			double[] value = {-4.29246,49.07649,-2.6938,-4.08118,49.28131,-2.71614,-4.06706,49.46933,-2.65737,-4.15771,49.5829,-2.56316,-3.99287,49.54276,-2.67137,-4.06235,49.03582,-2.81151,-4.35475,48.84666,-2.74974,-3.56599,49.11223,-2.95556,-3.38366,48.99724,-3.09069,-3.61961,49.02465,-2.94704,-3.35025,49.43464,-2.86291,-3.53313,49.31499,-2.88351,-3.67093,49.44941,-2.74963,-3.46017,49.66095,-2.76064,-3.39375,49.21527,-2.98652,-3.2504,49.14224,-3.13105,-3.25807,48.89874,-3.20976,-3.03926,48.9165,-3.46051,-3.15063,48.75698,-3.47696,-3.1294,49.05252,-3.29777,-3.39061,50.25092,-3.09485,-3.19689,50.32978,-2.97507,-3.16289,50.26066,-3.00419,-3.37006,50.32432,-3.02103,-3.45409,50.18902,-3.08273,-3.26775,50.19521,-3.02568,-3.41227,50.15004,-2.96933,-3.68701,49.64114,-2.68194,-3.51579,49.85969,-2.72483,-2.87419,49.83007,-3.12932,-3.06252,49.86302,-2.95944,-2.99962,49.65459,-3.0653,-3.06285,49.19676,-3.23185,-3.15048,49.2316,-3.12516,-3.07064,49.33169,-3.14579,-4.04954,47.1514,-3.43083,-4.125,47.02963,-3.48676,-3.93994,47.03562,-3.66041,-5.30398,49.06437,-1.93157,-5.17297,49.23754,-2.0393,-5.03342,49.16679,-2.09207,-5.67175,49.46928,-1.56866,-5.76315,49.28546,-1.73695,-5.32937,49.32377,-1.77555,-5.18625,49.42502,-1.67729,-5.06067,49.4503,-1.76955,-5.27515,49.34746,-1.86239,-5.07423,49.51045,-1.5688,-4.9123,49.51399,-1.66544,-5.57435,48.65584,-2.04856,-5.51829,48.5621,-2.02239,-5.3401,48.28603,-2.49422,-5.39161,48.22295,-2.40733,-5.66675,48.68938,-1.9407,-5.76532,48.78697,-1.87902,-5.65202,48.72042,-1.95412,-5.4521,48.52687,-2.20546,-5.37331,48.35965,-2.41679,-4.23831,47.17728,-3.50644,-4.31643,47.35866,-3.40093,-4.16188,47.21388,-3.55885,-3.32975,47.92647,-3.76501,-3.38459,47.73773,-3.77471,-3.38212,47.96457,-3.72766,-3.45565,47.77235,-3.74445,-3.51364,50.29716,-2.06061,-3.41284,50.25376,-2.11504,-3.55584,50.1393,-2.13438,-5.83766,50.00576,-1.41707,-5.63605,50.00914,-1.59395,-5.72087,50.04362,-1.75845,-6.42787,49.63771,-1.92651,-6.34977,49.6532,-1.93589,-6.34506,49.64813,-1.88605,-6.39087,49.66863,-1.98088,-4.87678,49.90073,-2.63161,-5.07391,50.00003,-2.66451,-4.8722,49.98848,-2.7887,-5.05746,49.92459,-2.5953,-5.97657,49.65897,-2.03008,-6.21948,49.65899,-1.90636,-6.0061,49.69363,-2.06206,-6.22619,49.67595,-1.95213,-6.58141,49.66684,-1.83868,-6.52144,49.72271,-1.57765,-6.68147,49.68511,-1.73956,-6.46203,49.67797,-1.7203,-6.1273,49.76433,-1.51848,-6.10231,49.74243,-1.56376,-5.90348,49.83597,-1.61584,-6.3684,49.73793,-1.5092,-6.30261,49.70835,-1.61444,-2.99109,50.34555,-2.86593,-3.35956,50.27401,-2.89411,-3.17461,50.21976,-2.71552,-6.18448,49.66164,-1.77877,-5.91131,49.62932,-1.96145,-5.74996,49.64825,-2.14018,-5.72846,49.59942,-2.05749,-5.81605,49.92511,-1.33258};
			return value;
		}
		private double[] getrscapula_Coord_7_195_point_4()
		{
			double[] value = {-5.91572,49.87205,-1.08895,-5.69509,49.94427,-1.59599,-5.67702,49.83974,-1.75339,-5.57044,49.99832,-1.7879,-5.77404,49.88106,-1.625,-5.33338,49.62418,-2.02733,-5.43684,49.73165,-2.00972,-5.52001,49.51095,-2.00909,-5.62628,49.59009,-1.95764,-5.07777,49.59446,-2.00961,-5.07448,49.42793,-1.87649,-4.97212,49.50256,-1.89386,-5.16221,49.53709,-1.98221,-5.23884,49.87922,-2.16827,-5.44555,49.91401,-2.00994,-5.32623,49.81796,-2.08528,-5.29732,49.99674,-2.11725,-5.05344,49.92941,-2.333,-5.0935,50.02009,-2.37716,-5.56387,48.74704,-1.67617,-5.62769,48.76837,-1.57957,-5.31281,49.09023,-1.25897,-5.3627,48.94487,-1.28896,-5.22919,48.99095,-1.37455,-5.18236,49.12006,-1.32125,-5.93625,49.21467,-.18815,-5.69096,49.22364,-.34566,-5.64826,49.28648,-.26326,-5.93734,49.18855,-.26373,-5.19151,48.86154,-1.59828,-5.05251,48.84778,-1.74967,-5.03576,48.91343,-1.69711,-4.59299,49.63628,-1.38087,-4.94585,48.36802,-2.49779,-5.03652,48.28931,-2.52205,-4.8545,48.31391,-2.64445,-3.87118,48.55935,-2.98493,-3.47108,48.63994,-3.12142,-3.82756,48.65327,-2.88812,-3.41057,48.71843,-3.02183,-3.42075,48.81355,-3.03747,-3.11109,48.65337,-3.35344,-4.94162,48.0933,-2.61748,-4.96129,47.95201,-2.63803,-4.77804,47.98626,-2.75292,-5.04823,48.06222,-2.5778,-5.4943,49.33289,-.38947,-5.3305,49.35546,-.53994,-5.31548,49.37821,-.51656,-5.51684,49.26196,-.45261,-4.74772,48.53347,-2.52586,-4.62978,48.50415,-2.64431,-4.57935,48.60444,-2.59162,-5.39011,48.79021,-1.6125,-5.44774,48.78662,-1.57708,-3.799,50.0114,-1.9823,-3.78258,50.0551,-1.93243,-3.87014,49.99238,-1.93392,-3.04142,50.14036,-2.58012,-3.04899,50.25015,-2.51776,-3.49985,50.06193,-2.4639,-3.96797,49.96197,-1.84792,-4.07584,49.92851,-1.72909,-4.14008,49.8664,-1.81323,-3.89155,49.96292,-1.96641,-3.81015,49.98337,-2.04698,-4.92987,49.3071,-1.26052,-5.04494,49.26546,-1.22545,-5.07492,49.16423,-1.3769,-4.97334,49.21003,-1.43252,-4.41998,49.62552,-1.4896,-4.25009,49.80727,-1.6781,-4.27842,49.79143,-1.46863,-4.38653,49.69576,-1.7007,-5.17089,49.22809,-1.18927,-5.3276,49.21749,-1.1754,-5.06363,49.32967,-1.04445,-4.96437,49.35672,-1.06303,-5.2409,49.32164,-.85493,-4.79905,49.25925,-1.73797,-4.70116,49.37297,-1.86947,-4.6874,49.42372,-1.63341,-4.79504,49.33013,-1.55131,-3.97434,50.25251,-1.5028,-4.56253,49.62825,-1.41112,-4.45531,49.68704,-1.41681,-4.46637,49.71137,-1.39806,-4.54158,49.60829,-1.43816,-5.1614,49.47334,-.58425,-5.43394,49.52931,-.53339,-5.3504,49.42321,-.52164,-5.25822,49.59339,-.65092,-4.58319,49.64387,-1.37823,-4.493,49.76713,-1.33752,-4.66308,49.6731,-1.25768,-4.47412,49.72718,-1.37884,-5.34752,49.29504,-1.04486,-5.50922,49.38609,-.93576,-5.39266,49.35475,-.88733,-5.19656,49.28505,-1.0397};
			return value;
		}
		private double[] getrscapula_Coord_7_195_point_5()
		{
			double[] value = {-2.90773,50.34312,-2.49694,-3.09114,50.35052,-2.36827,-3.12488,50.30422,-2.39193,-2.9153,50.40767,-2.40174,-2.77582,49.51325,-3.09196,-2.75913,49.46041,-3.13053,-5.61759,49.20603,-1.38021,-5.61173,49.16996,-1.35348,-5.60297,49.19671,-1.26436,-5.64713,49.26881,-1.28803,-5.70864,49.01919,-1.56473,-5.85087,48.93543,-1.66856,-5.81905,48.88901,-1.61375,-6.04678,49.1946,-.26639,-5.93758,49.16776,-.328,-5.93748,49.18128,-.28575,-5.68733,49.4714,-.99301,-5.56601,49.37096,-1.00806,-5.62795,49.47971,-.9022,-5.62936,49.29925,-1.06283,-5.98729,48.85515,-1.75866,-5.89206,48.82403,-1.82397,-5.9722,48.78536,-1.69294,-5.47436,48.54492,-2.28397,-5.44144,48.47528,-2.39166,-4.96043,47.78303,-2.67192,-5.03628,47.87877,-2.6079,-5.01037,47.80364,-2.79967,-5.14326,47.88845,-2.69034,-4.65189,47.32004,-3.0111,-4.64363,47.31655,-3.07246,-4.38856,47.17709,-3.3335,-4.36247,47.18456,-3.28446,-3.46325,47.52191,-3.68465,-3.49361,47.55166,-3.78623,-3.36265,47.73574,-3.66301,-3.75005,47.18595,-3.77768,-3.70445,47.17742,-3.74233,-3.96828,47.0536,-3.67813,-2.98757,48.63227,-3.7004,-2.92213,48.79633,-3.66436,-2.94861,48.6336,-3.64317,-2.87662,48.87542,-3.5765,-2.81768,49.09699,-3.44264,-2.81226,49.35226,-3.36596,-2.85078,49.09649,-3.47586,-3.48315,50.62647,-1.77073,-3.59477,50.51266,-1.75214,-3.4495,50.60415,-1.90976,-5.48781,49.57666,-1.12274,-5.44066,49.57071,-.98926,-5.23957,49.61774,-1.14322,-5.32419,49.58915,-1.29106,-4.72026,49.59203,-1.21283,-4.79991,49.6882,-1.26148,-4.82269,49.69948,-1.088,-4.76156,49.58795,-1.01174,-4.17857,50.06345,-1.51067,-4.37508,49.84504,-1.38373,-4.40156,49.89275,-1.50615,-4.66702,49.52729,-1.4871,-4.68092,49.52946,-1.48398,-4.724,49.50645,-1.43224,-2.89075,50.61329,-2.45994,-2.7652,50.50102,-2.63232,-5.96388,49.88628,-.77515,-5.92952,49.89319,-.82729,-6.1328,49.82128,-.65944,-6.08485,49.81852,-.77466,-5.58558,48.60585,-1.942,-5.74929,48.86892,-1.4824,-5.68214,49.00699,-1.51686,-5.7853,48.88299,-1.55899,-5.6587,49.02118,-1.46883,-5.86687,49.47789,-.37845,-5.88706,49.42866,-.46989,-6.1032,49.36997,-.36486,-6.05491,49.34759,-.22507,-5.15922,49.71192,-.88479,-5.34389,49.62463,-.77589,-5.07883,49.64175,-.76213,-4.91731,49.66959,-.92343,-4.95547,49.7417,-1.02342,-5.14817,49.38796,-.62914,-4.86007,49.57377,-.87378,-4.98171,49.52952,-.715,-4.79206,49.51613,-.94028,-4.97824,49.44295,-.74068,-4.74744,49.53771,-1.26201,-4.70112,49.50874,-1.16595,-4.70437,49.48179,-1.23639,-3.48322,50.52816,-1.75045,-3.21258,50.60781,-2.0505,-3.95018,50.10335,-1.65145,-3.88637,50.26581,-1.42127,-4.01349,50.07667,-1.44789,-4.16744,49.98257,-1.41395,-4.14418,49.93718,-1.4664,-4.13952,49.86528,-1.93819,-4.00832,49.90263,-1.946};
			return value;
		}
		private double[] getrscapula_Coord_7_195_point_6()
		{
			double[] value = {-4.32542,49.84615,-1.4205,-4.34398,49.8513,-1.40791,-4.36885,49.83568,-1.37776,-4.63096,49.48113,-1.68811,-3.56793,50.16686,-2.05228,-3.5738,50.24583,-1.96614,-3.76591,50.09994,-1.88295,-3.34894,50.33951,-2.12921,-3.1472,50.45148,-2.17774,-3.34484,50.44205,-2.01806,-3.41005,50.35911,-2.02763,-3.57131,50.33276,-1.88416,-4.64647,47.44311,-2.92409,-4.80084,47.42683,-2.84882,-4.31456,47.60425,-3.13491,-4.43742,47.81542,-3.03514,-4.53456,47.56219,-2.97461,-4.34764,47.80917,-3.08114,-3.35073,47.99275,-3.57817,-3.18888,48.26468,-3.54332,-3.1427,48.28969,-3.67158,-4.69255,48.3615,-2.71868,-4.6072,48.17953,-2.84263,-3.26171,48.3361,-3.4385,-3.94773,48.30477,-3.13761,-4.35361,48.45598,-2.84188,-4.38767,48.22328,-2.94418,-4.64665,48.47706,-2.66001,-4.2637,48.65904,-2.67954,-4.30012,48.59804,-2.73035,-2.9945,48.60686,-3.51661,-3.13279,48.30387,-3.66841,-2.94619,48.62823,-3.62018,-3.09148,48.84721,-3.26862,-2.88046,49.06873,-3.34624,-2.80307,49.31258,-3.22549,-2.81435,49.09353,-3.42175,-2.86358,49.46505,-2.94484,-2.87377,49.54007,-2.97468,-2.81498,49.65901,-3.06744,-3.06572,49.57052,-2.80945,-2.8916,49.65396,-2.97369,-3.03302,49.69398,-2.82253,-3.02354,49.80974,-2.82525,-3.15255,49.76211,-2.71949,-3.22544,49.40492,-2.79442,-3.1674,49.60954,-2.73531,-3.88942,49.82567,-2.41644,-3.53322,49.94895,-2.55307,-3.86976,49.89366,-2.39613,-3.53139,50.0754,-2.37713,-3.31006,50.2568,-2.2597,-3.85303,49.94768,-2.20376,-3.54624,50.10586,-2.27359,-3.55935,50.13164,-2.13331,-4.07106,49.87217,-2.06863,-4.51901,49.50572,-2.08916,-4.20022,49.74931,-2.27625,-4.50605,49.54081,-2.00877,-4.22244,48.92708,-2.66477,-4.16927,49.11382,-2.60632,-4.32515,48.91291,-2.58005,-4.24409,49.09013,-2.52549,-4.27847,48.75089,-2.71074,-4.54966,48.67972,-2.57168,-4.25521,48.67712,-2.67158,-5.25929,48.45671,-2.15069,-5.26733,48.33201,-2.25352,-4.22731,49.38401,-2.39166,-4.43347,49.30722,-2.29822,-4.2394,49.21975,-2.4654,-5.4631,48.72771,-1.81876,-5.67517,48.74169,-1.44736,-4.59554,49.22824,-2.18465,-4.55355,49.3592,-2.19548,-4.6048,49.29198,-2.18765,-4.67389,49.03515,-2.18919,-4.48329,49.11421,-2.32023,-4.71427,49.12548,-2.07801,-5.31825,48.80096,-1.59874,-5.42662,48.79412,-1.44192,-5.42547,48.78401,-1.54779,-4.68438,49.29313,-2.0817,-4.60347,49.38943,-2.14101,-5.56621,49.02156,-1.13895,-5.57724,49.18255,-1.13632,-4.83164,49.40934,-1.05377,-5.01341,49.34861,-.93556,-5.55903,49.24448,-.49802,-5.3964,49.26161,-.64038,-5.72095,49.21273,-.39759,-5.70076,49.2164,-.36335,-6.34615,49.93949,-.66037,-6.43782,49.87396,-.65778,-6.11586,49.88907,-.67512,-5.98969,49.96927,-.76769,-5.95627,49.95243,-.80411,-5.88978,50.02385,-1.05012,-5.85963,49.97949,-1.23823,-5.90982,49.0316,-1.86398};
			return value;
		}
		private double[] getrscapula_Coord_7_195_point_7()
		{
			double[] value = {-5.68881,48.94868,-1.92865,-5.98124,48.94179,-1.8016,-5.97092,49.03391,-1.81808,-5.38175,49.11533,-1.86001,-5.2654,49.24239,-1.92995,-5.6293,48.92558,-1.9401,-5.50798,48.97838,-1.93093,-5.33489,48.91166,-1.97688,-5.05554,49.01256,-2.02899,-4.96766,48.99126,-2.12091,-5.17555,48.85607,-2.04354,-4.933,48.95066,-2.15119,-5.12858,48.79373,-2.1252,-4.80154,49.09001,-2.22296,-4.81855,49.10851,-2.20766,-4.6609,49.29608,-2.3498,-4.90818,49.13165,-2.12476,-4.77253,49.34111,-2.29784,-4.59479,49.43347,-2.39597,-4.56588,49.2486,-2.42658,-4.43611,49.41551,-2.45317,-3.88338,49.72938,-2.67552,-4.05921,49.76662,-2.62244,-3.90793,49.43182,-2.69524,-3.97968,49.95094,-2.72091,-3.73392,49.99992,-2.76592,-3.7564,49.94185,-2.71389,-4.44476,48.91007,-2.67453,-4.64096,48.60367,-2.68538,-4.70711,48.67692,-2.59109,-3.24854,49.3308,-2.98724,-4.12627,48.74681,-2.87646,-4.05464,48.70458,-2.93687,-4.3912,48.43584,-2.8996,-5.16998,48.10467,-2.7054,-5.04218,48.0081,-2.81707,-5.01321,47.85318,-2.87462,-5.15368,47.91676,-2.75092,-4.92062,47.9161,-2.90689,-4.89349,47.88954,-2.96329,-2.90729,49.56321,-3.21779,-2.91592,49.37709,-3.26542,-3.49142,48.63624,-3.29015,-4.32082,47.86441,-3.21542,-4.62475,47.90358,-3.10297,-4.48035,47.97216,-3.07892,-4.38203,47.83473,-3.25055,-4.21031,47.91838,-3.21702,-4.02355,47.80231,-3.31713,-3.82768,47.96004,-3.38239,-3.99262,48.06481,-3.25376,-3.06823,48.67585,-3.6395,-3.30789,48.45969,-3.56531,-3.21122,48.33719,-3.66685,-3.89267,47.34,-3.72765,-4.14065,47.03235,-3.51608,-5.73985,49.06451,-1.58713,-5.71894,49.11558,-1.57686,-5.83173,49.0705,-1.67209,-5.83802,49.00075,-1.68427,-5.70623,49.3101,-1.40156,-5.73724,49.28939,-1.46743,-5.64746,49.21696,-1.459,-5.97388,49.03072,-1.79922,-5.97972,48.94326,-1.78289,-5.78923,49.20902,-1.58617,-6.03515,49.72919,-2.09433,-5.84743,49.80591,-2.1981,-5.79298,49.71545,-2.16507,-5.7117,49.55833,-1.97768,-5.84558,49.60125,-1.89364,-5.3281,49.3819,-2.0447,-5.57067,49.51275,-2.06274,-5.35394,49.39591,-2.09302,-5.36501,49.52248,-2.21488,-5.5728,49.64055,-2.21806,-5.34554,49.60383,-2.28251,-5.57125,49.5757,-2.14015,-5.24707,49.32153,-1.97754,-5.23653,49.32064,-2.0731,-5.19201,49.60044,-2.30646,-5.37865,49.76697,-2.36015,-5.22072,49.78341,-2.43199,-5.05037,49.7728,-2.47509,-5.21926,49.95511,-2.52801,-5.02605,49.45578,-2.27088,-5.06611,49.38212,-2.20781,-5.22552,49.45534,-2.23002,-4.89978,49.35084,-2.24429,-4.68888,49.5878,-2.41962,-4.53867,49.59896,-2.44782,-4.72898,49.43915,-2.34819,-4.31838,49.60685,-2.49341,-4.27579,49.75496,-2.55826,-5.26766,49.37011,-1.91279,-5.31501,49.42072,-1.97783,-5.4643,