####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python BodySkinIndexedFaceSetNIST.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.1',
  head=head(
    children=[
    meta(content='BodySkinIndexedFaceSetNIST.x3d',name='title'),
    meta(content='Human body skin made of IndexedFaceSet polygons, gender neutral, semi-transparent for use with MedicalMetadata and MedicalMetadataViewer.x3d.',name='description'),
    meta(content='TODO (NIST team)',name='creator'),
    meta(content='Joe Williams and Don Brutzman',name='translator'),
    meta(content='1 November 2007',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='BodySkinIndexedFaceSetNIST.png',name='Image'),
    meta(content='MedicalMetadata.x3d',name='reference'),
    meta(content='MedicalMetadataViewer.x3d',name='reference'),
    meta(content='https://www.web3d.org/x3d/workgroups/medical',name='reference'),
    meta(content='Polygonal human body skin',name='subject'),
    meta(content='note skin material is partly transparent to support visualization use by MedicalMetadata scenes',name='info'),
    meta(content='needs metadata regarding original authoring and usage',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Medical/BodySkinIndexedFaceSetNIST.x3d',name='identifier'),
    meta(content='FluxStudio',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='BodySkinIndexedFaceSetNIST.x3d'),
    Background(skyColor=[(1,1,1)]),
    Viewpoint(description='Human body modeled by NIST, 1.8m tall',position=(0,0,3)),
    Transform(DEF='dad_body',scale=(0.024,0.024,0.024),
      children=[
      Shape(DEF='body',
        appearance=Appearance(
          material=Material(DEF='material0',transparency=0.6)),
        geometry=IndexedFaceSet(DEF='A_0',coordIndex=[0,1,2,-1,3,4,5,-1,6,7,8,-1,9,10,11,-1,10,12,11,-1,9,13,10,-1,14,15,16,-1,17,18,19,-1,20,21,22,-1,22,21,23,-1,24,25,26,-1,27,28,26,-1,23,29,25,-1,22,23,25,-1,30,31,32,-1,33,34,35,-1,36,37,38,-1,39,40,41,-1,42,43,44,-1,43,42,45,-1,46,47,48,-1,11,12,49,-1,43,50,35,-1,51,52,53,-1,42,54,55,-1,56,50,57,-1,57,58,56,-1,59,60,61,-1,22,25,24,-1,62,63,10,-1,64,65,66,-1,67,68,69,-1,70,71,72,-1,69,70,73,-1,74,75,76,-1,77,78,79,-1,80,74,76,-1,81,82,83,-1,82,84,85,-1,81,84,82,-1,86,87,88,-1,89,90,91,-1,92,91,90,-1,93,94,95,-1,96,97,98,-1,77,75,99,-1,100,93,101,-1,102,96,103,-1,104,105,106,-1,107,108,109,-1,110,111,112,-1,113,114,115,-1,116,117,118,-1,119,120,121,-1,93,122,94,-1,123,124,125,-1,126,127,128,-1,129,73,70,-1,73,130,131,-1,132,130,133,-1,134,135,136,-1,137,138,139,-1,140,135,141,-1,142,143,144,-1,72,129,70,-1,145,125,146,-1,118,147,148,-1,149,150,151,-1,100,116,152,-1,149,151,153,-1,154,155,156,-1,99,157,77,-1,65,158,159,-1,160,161,97,-1,97,161,162,-1,157,78,77,-1,163,164,165,-1,10,13,62,-1,166,167,163,-1,168,169,170,-1,171,172,173,-1,174,175,171,-1,2,1,176,-1,5,4,177,-1,8,178,6,-1,179,180,181,-1,179,182,180,-1,180,183,181,-1,184,185,186,-1,187,188,189,-1,190,191,192,-1,193,191,190,-1,194,195,196,-1,194,197,198,-1,195,199,193,-1,195,193,190,-1,200,31,201,-1,202,203,204,-1,205,206,207,-1,208,209,210,-1,211,212,213,-1,214,213,212,-1,215,216,217,-1,218,182,179,-1,202,219,212,-1,220,221,222,-1,223,224,213,-1,225,219,226,-1,226,227,225,-1,228,229,230,-1,196,195,190,-1,180,231,232,-1,233,234,235,-1,236,237,238,-1,239,240,241,-1,242,241,236,-1,243,244,245,-1,246,247,248,-1,243,245,249,-1,250,251,252,-1,253,254,251,-1,251,254,252,-1,255,256,257,-1,258,259,260,-1,259,258,261,-1,262,263,264,-1,265,266,267,-1,268,244,248,-1,269,264,270,-1,271,267,272,-1,273,274,275,-1,276,277,278,-1,279,280,281,-1,282,283,284,-1,285,286,287,-1,288,289,290,-1,263,291,264,-1,292,293,294,-1,295,296,297,-1,241,242,298,-1,299,300,242,-1,301,300,302,-1,303,304,305,-1,306,307,308,-1,309,304,310,-1,311,312,313,-1,241,298,239,-1,314,292,315,-1,316,317,285,-1,318,319,320,-1,321,287,270,-1,322,318,320,-1,323,324,325,-1,248,326,268,-1,327,328,234,-1,266,329,330,-1,331,329,266,-1,248,247,326,-1,332,333,334,-1,232,183,180,-1,334,335,336,-1,337,338,339,-1,340,341,342,-1,342,343,344,-1,30,345,346,-1,346,31,30,-1,31,1,347,-1,347,32,31,-1,348,8,7,-1,7,349,348,-1,348,349,350,-1,350,351,348,-1,351,350,352,-1,352,353,351,-1,353,352,354,-1,354,355,353,-1,355,354,356,-1,356,357,355,-1,357,356,358,-1,358,359,357,-1,359,358,360,-1,360,361,359,-1,361,360,362,-1,362,363,361,-1,363,362,0,-1,0,2,363,-1,364,365,40,-1,40,39,364,-1,5,366,367,-1,367,3,5,-1,368,6,369,-1,369,370,368,-1,371,372,370,-1,370,369,371,-1,373,374,375,-1,375,4,373,-1,366,364,39,-1,39,367,366,-1,11,376,377,-1,377,9,11,-1,378,379,14,-1,14,16,378,-1,380,381,14,-1,14,379,380,-1,378,84,81,-1,81,379,378,-1,16,345,30,-1,30,378,16,-1,14,382,383,-1,383,15,14,-1,384,383,382,-1,382,385,384,-1,386,387,385,-1,385,382,386,-1,387,388,389,-1,389,385,387,-1,387,386,390,-1,390,388,387,-1,381,386,382,-1,382,14,381,-1,391,384,385,-1,385,389,391,-1,388,392,393,-1,393,389,388,-1,381,380,390,-1,390,386,381,-1,394,380,379,-1,379,81,394,-1,18,395,396,-1,396,19,18,-1,17,82,397,-1,397,18,17,-1,19,20,398,-1,398,17,19,-1,399,400,401,-1,401,402,399,-1,403,404,405,-1,405,406,403,-1,396,407,20,-1,20,19,396,-1,408,396,395,-1,395,409,408,-1,397,410,395,-1,395,18,397,-1,409,411,412,-1,412,408,409,-1,412,406,413,-1,413,414,412,-1,415,409,395,-1,395,410,415,-1,416,417,404,-1,404,403,416,-1,20,407,418,-1,418,21,20,-1,407,419,420,-1,420,418,407,-1,23,21,418,-1,418,421,23,-1,421,422,29,-1,29,23,421,-1,391,423,424,-1,424,384,391,-1,423,26,425,-1,425,424,423,-1,391,17,398,-1,398,423,391,-1,423,398,24,-1,24,26,423,-1,17,391,389,-1,389,393,17,-1,26,28,426,-1,426,425,26,-1,24,398,20,-1,20,22,24,-1,28,427,428,-1,428,426,28,-1,28,27,48,-1,48,427,28,-1,26,25,429,-1,429,27,26,-1,25,29,430,-1,430,429,25,-1,429,430,431,-1,431,46,429,-1,29,422,432,-1,432,430,29,-1,430,432,433,-1,433,431,430,-1,427,434,435,-1,435,428,427,-1,47,434,427,-1,427,48,47,-1,27,429,46,-1,46,48,27,-1,436,46,431,-1,431,437,436,-1,392,388,390,-1,390,438,392,-1,390,380,394,-1,394,438,390,-1,34,44,43,-1,43,35,34,-1,50,439,33,-1,33,35,50,-1,376,53,36,-1,36,377,376,-1,52,440,36,-1,36,53,52,-1,51,53,376,-1,376,441,51,-1,41,442,443,-1,443,39,41,-1,442,59,61,-1,61,443,442,-1,444,445,446,-1,446,447,444,-1,448,446,445,-1,445,449,448,-1,44,450,54,-1,54,42,44,-1,450,451,452,-1,452,54,450,-1,52,54,452,-1,452,453,52,-1,434,452,451,-1,451,435,434,-1,453,452,434,-1,434,47,453,-1,54,52,51,-1,51,55,54,-1,453,436,440,-1,440,52,453,-1,36,440,454,-1,454,37,36,-1,440,436,437,-1,437,454,440,-1,47,46,436,-1,436,453,47,-1,377,36,38,-1,38,455,377,-1,456,457,455,-1,455,38,456,-1,9,377,455,-1,455,458,9,-1,63,459,12,-1,12,10,63,-1,50,43,45,-1,45,57,50,-1,449,33,439,-1,439,448,449,-1,460,45,42,-1,42,55,460,-1,461,439,50,-1,50,56,461,-1,49,12,56,-1,56,58,49,-1,12,459,461,-1,461,56,12,-1,58,462,463,-1,463,49,58,-1,11,464,441,-1,441,376,11,-1,55,51,441,-1,441,460,55,-1,462,465,464,-1,464,463,462,-1,49,463,464,-1,464,11,49,-1,460,441,464,-1,464,465,460,-1,57,465,462,-1,462,58,57,-1,45,460,465,-1,465,57,45,-1,447,61,60,-1,60,444,447,-1,378,30,32,-1,32,84,378,-1,457,456,466,-1,466,467,457,-1,13,9,458,-1,458,468,13,-1,459,63,70,-1,70,69,459,-1,459,69,68,-1,68,461,459,-1,62,469,470,-1,470,71,62,-1,471,468,458,-1,458,472,471,-1,62,71,70,-1,70,63,62,-1,473,471,474,-1,474,475,473,-1,476,477,478,-1,478,479,476,-1,474,471,472,-1,472,480,474,-1,470,469,473,-1,473,481,470,-1,140,481,165,-1,165,164,140,-1,467,466,482,-1,482,478,467,-1,480,467,478,-1,478,477,480,-1,480,472,457,-1,457,467,480,-1,141,72,71,-1,71,470,141,-1,141,133,129,-1,129,72,141,-1,472,458,455,-1,455,457,472,-1,448,439,461,-1,461,68,448,-1,483,484,166,-1,166,163,483,-1,485,153,66,-1,66,486,485,-1,419,407,396,-1,396,408,419,-1,349,487,488,-1,488,350,349,-1,352,350,488,-1,488,489,352,-1,490,491,86,-1,86,492,490,-1,7,493,487,-1,487,349,7,-1,354,494,147,-1,147,356,354,-1,495,358,356,-1,356,147,495,-1,496,148,497,-1,497,498,496,-1,496,122,152,-1,152,148,496,-1,494,354,352,-1,352,489,494,-1,499,500,498,-1,498,497,499,-1,358,495,104,-1,104,360,358,-1,360,104,106,-1,106,362,360,-1,104,495,117,-1,117,105,104,-1,147,118,117,-1,117,495,147,-1,490,492,500,-1,500,499,490,-1,501,161,417,-1,417,416,501,-1,160,502,400,-1,400,399,160,-1,503,504,400,-1,400,502,503,-1,505,506,76,-1,76,75,505,-1,506,85,80,-1,80,76,506,-1,506,505,410,-1,410,397,506,-1,85,84,32,-1,32,80,85,-1,506,397,82,-1,82,85,506,-1,80,32,347,-1,347,74,80,-1,392,438,83,-1,83,393,392,-1,82,17,393,-1,393,83,82,-1,438,394,81,-1,81,83,438,-1,507,108,508,-1,508,509,507,-1,108,510,511,-1,511,508,108,-1,512,109,108,-1,108,507,512,-1,509,503,102,-1,102,507,509,-1,110,88,87,-1,87,92,110,-1,513,87,86,-1,86,514,513,-1,492,86,88,-1,88,515,492,-1,156,89,91,-1,91,513,156,-1,110,92,90,-1,90,111,110,-1,510,111,516,-1,516,511,510,-1,79,78,517,-1,517,415,79,-1,518,519,95,-1,95,162,518,-1,97,96,502,-1,502,160,97,-1,74,347,520,-1,520,521,74,-1,521,520,106,-1,106,101,521,-1,0,520,347,-1,347,1,0,-1,521,99,75,-1,75,74,521,-1,522,103,96,-1,96,98,522,-1,523,522,94,-1,94,122,523,-1,101,93,95,-1,95,519,101,-1,106,105,100,-1,100,101,106,-1,362,106,520,-1,520,0,362,-1,101,519,99,-1,99,521,101,-1,102,503,502,-1,502,96,102,-1,507,102,103,-1,103,512,507,-1,503,509,524,-1,524,504,503,-1,498,500,525,-1,525,526,498,-1,107,526,525,-1,525,527,107,-1,525,500,492,-1,492,515,525,-1,496,498,526,-1,526,528,496,-1,116,100,105,-1,105,117,116,-1,496,528,523,-1,523,122,496,-1,528,109,512,-1,512,523,528,-1,108,107,527,-1,527,510,108,-1,510,527,112,-1,112,111,510,-1,525,515,112,-1,112,527,525,-1,513,514,113,-1,113,156,513,-1,529,113,514,-1,514,530,529,-1,120,487,493,-1,493,121,120,-1,121,531,532,-1,532,119,121,-1,522,523,512,-1,512,103,522,-1,528,526,107,-1,107,109,528,-1,110,112,515,-1,515,88,110,-1,513,91,92,-1,92,87,513,-1,100,152,122,-1,122,93,100,-1,514,86,491,-1,491,530,514,-1,156,533,534,-1,534,89,156,-1,535,114,113,-1,113,529,535,-1,531,121,493,-1,493,368,531,-1,493,7,6,-1,6,368,493,-1,155,536,533,-1,533,156,155,-1,125,124,370,-1,370,372,125,-1,531,368,370,-1,370,124,531,-1,372,537,146,-1,146,125,372,-1,3,538,373,-1,373,4,3,-1,539,538,3,-1,3,367,539,-1,367,39,443,-1,443,539,367,-1,539,443,61,-1,61,540,539,-1,540,61,447,-1,447,541,540,-1,540,128,538,-1,538,539,540,-1,538,128,127,-1,127,373,538,-1,541,126,128,-1,128,540,541,-1,131,126,541,-1,541,67,131,-1,127,542,374,-1,374,373,127,-1,130,127,126,-1,126,131,130,-1,133,130,73,-1,73,129,133,-1,543,64,66,-1,66,544,543,-1,164,136,135,-1,135,140,164,-1,132,135,134,-1,134,545,132,-1,546,547,167,-1,167,166,546,-1,67,446,448,-1,448,68,67,-1,69,73,131,-1,131,67,69,-1,541,447,446,-1,446,67,541,-1,130,548,542,-1,542,127,130,-1,549,550,115,-1,115,114,549,-1,155,551,552,-1,552,536,155,-1,550,549,138,-1,138,137,550,-1,553,549,114,-1,114,535,553,-1,554,555,556,-1,556,557,554,-1,558,138,549,-1,549,553,558,-1,551,554,557,-1,557,552,551,-1,151,150,559,-1,559,560,151,-1,560,559,561,-1,561,562,560,-1,563,564,559,-1,559,150,563,-1,544,151,560,-1,560,565,544,-1,544,565,566,-1,566,543,544,-1,565,567,568,-1,568,566,565,-1,145,561,559,-1,559,564,145,-1,563,569,123,-1,123,564,563,-1,570,149,153,-1,153,139,570,-1,123,569,571,-1,571,124,123,-1,124,571,532,-1,532,531,124,-1,544,66,153,-1,153,151,544,-1,133,141,135,-1,135,132,133,-1,144,547,546,-1,546,142,144,-1,565,560,562,-1,562,567,565,-1,562,572,175,-1,175,567,562,-1,561,573,572,-1,572,562,561,-1,564,123,125,-1,125,145,564,-1,139,138,558,-1,558,570,139,-1,568,567,175,-1,175,174,568,-1,132,574,548,-1,548,130,132,-1,545,575,574,-1,574,132,545,-1,146,573,561,-1,561,145,146,-1,143,142,568,-1,568,174,143,-1,148,147,494,-1,494,497,148,-1,497,494,489,-1,489,499,497,-1,499,489,488,-1,488,490,499,-1,490,488,487,-1,487,491,490,-1,491,487,120,-1,120,530,491,-1,530,120,119,-1,119,529,530,-1,529,119,532,-1,532,535,529,-1,535,532,571,-1,571,553,535,-1,553,571,569,-1,569,558,553,-1,558,569,563,-1,563,570,558,-1,570,563,150,-1,150,149,570,-1,152,116,118,-1,118,148,152,-1,481,140,141,-1,141,470,481,-1,159,486,66,-1,66,65,159,-1,576,477,476,-1,476,577,576,-1,475,165,481,-1,481,473,475,-1,555,554,578,-1,578,579,555,-1,578,554,551,-1,551,580,578,-1,580,551,155,-1,155,154,580,-1,156,113,115,-1,115,154,156,-1,154,115,550,-1,550,580,154,-1,580,550,137,-1,137,578,580,-1,137,485,579,-1,579,578,137,-1,169,168,555,-1,555,579,169,-1,579,485,486,-1,486,169,579,-1,406,412,411,-1,411,403,406,-1,403,411,517,-1,517,416,403,-1,416,517,78,-1,78,501,416,-1,157,99,519,-1,519,518,157,-1,402,404,417,-1,417,399,402,-1,399,417,161,-1,161,160,399,-1,478,482,581,-1,581,479,478,-1,158,476,479,-1,479,582,158,-1,415,517,411,-1,411,409,415,-1,415,410,505,-1,505,79,415,-1,79,505,75,-1,75,77,79,-1,414,419,408,-1,408,412,414,-1,583,169,486,-1,486,159,583,-1,159,158,582,-1,582,583,159,-1,583,582,584,-1,584,585,583,-1,568,142,546,-1,546,566,568,-1,566,546,166,-1,166,543,566,-1,543,166,484,-1,484,64,543,-1,64,484,577,-1,577,65,64,-1,65,577,476,-1,476,158,65,-1,97,162,95,-1,95,98,97,-1,98,95,94,-1,94,522,98,-1,162,161,501,-1,501,518,162,-1,518,501,78,-1,78,157,518,-1,139,153,485,-1,485,137,139,-1,477,576,474,-1,474,480,477,-1,143,575,545,-1,545,144,143,-1,144,545,134,-1,134,547,144,-1,547,134,136,-1,136,167,547,-1,167,136,164,-1,164,163,167,-1,577,484,483,-1,483,576,577,-1,471,473,469,-1,469,468,471,-1,468,469,62,-1,62,13,468,-1,475,474,576,-1,576,483,475,-1,165,475,483,-1,483,163,165,-1,170,169,583,-1,583,585,170,-1,584,582,479,-1,479,581,584,-1,175,572,172,-1,172,171,175,-1,172,572,573,-1,573,586,172,-1,586,587,588,-1,588,172,586,-1,173,172,588,-1,588,589,173,-1,589,590,591,-1,591,173,589,-1,173,591,592,-1,592,171,173,-1,592,593,575,-1,575,143,592,-1,594,375,374,-1,374,595,594,-1,595,374,542,-1,542,596,595,-1,596,542,548,-1,548,574,596,-1,574,575,593,-1,593,596,574,-1,596,593,597,-1,597,595,596,-1,595,597,598,-1,598,594,595,-1,590,598,597,-1,597,591,590,-1,591,597,593,-1,593,592,591,-1,573,146,537,-1,537,586,573,-1,586,537,599,-1,599,587,586,-1,143,174,171,-1,171,592,143,-1,371,599,537,-1,537,372,371,-1,31,346,600,-1,600,201,31,-1,200,601,1,-1,1,31,200,-1,602,178,8,-1,8,348,602,-1,351,603,602,-1,602,348,351,-1,353,604,603,-1,603,351,353,-1,355,605,604,-1,604,353,355,-1,357,606,605,-1,605,355,357,-1,359,607,606,-1,606,357,359,-1,361,608,607,-1,607,359,361,-1,363,609,608,-1,608,361,363,-1,2,176,609,-1,609,363,2,-1,210,209,365,-1,365,364,210,-1,177,610,366,-1,366,5,177,-1,611,369,6,-1,6,612,611,-1,369,611,613,-1,613,371,369,-1,4,375,614,-1,614,615,4,-1,610,210,364,-1,364,366,610,-1,181,616,617,-1,617,179,181,-1,184,186,618,-1,618,619,184,-1,618,186,620,-1,620,621,618,-1,618,252,254,-1,254,619,618,-1,619,201,600,-1,600,184,619,-1,185,622,623,-1,623,186,185,-1,624,623,622,-1,622,625,624,-1,623,624,626,-1,626,627,623,-1,624,628,629,-1,629,626,624,-1,629,630,627,-1,627,626,629,-1,186,623,627,-1,627,620,186,-1,628,624,625,-1,625,631,628,-1,628,632,633,-1,633,629,628,-1,627,630,621,-1,621,620,627,-1,252,618,621,-1,621,634,252,-1,187,635,636,-1,636,188,187,-1,188,637,251,-1,251,189,188,-1,189,638,192,-1,192,187,189,-1,639,640,641,-1,641,642,639,-1,643,644,645,-1,645,646,643,-1,187,192,647,-1,647,635,187,-1,648,636,635,-1,635,649,648,-1,188,636,650,-1,650,637,188,-1,649,651,652,-1,652,648,649,-1,653,654,643,-1,643,651,653,-1,650,636,648,-1,648,655,650,-1,646,645,656,-1,656,657,646,-1,191,658,647,-1,647,192,191,-1,658,659,660,-1,660,647,658,-1,661,658,191,-1,191,193,661,-1,193,199,662,-1,662,661,193,-1,625,663,664,-1,664,631,625,-1,663,665,194,-1,194,664,663,-1,664,638,189,-1,189,631,664,-1,194,196,638,-1,638,664,194,-1,632,628,631,-1,631,189,632,-1,665,666,197,-1,197,194,665,-1,190,192,638,-1,638,196,190,-1,666,667,668,-1,668,197,666,-1,668,215,198,-1,198,197,668,-1,198,669,195,-1,195,194,198,-1,669,670,199,-1,199,195,669,-1,217,671,670,-1,670,669,217,-1,670,672,662,-1,662,199,670,-1,671,673,672,-1,672,670,671,-1,667,674,675,-1,675,668,667,-1,215,668,675,-1,675,216,215,-1,215,217,669,-1,669,198,215,-1,676,671,217,-1,217,677,676,-1,678,630,629,-1,629,633,678,-1,678,634,621,-1,621,630,678,-1,202,212,211,-1,211,203,202,-1,202,204,679,-1,679,219,202,-1,616,207,220,-1,220,617,616,-1,220,207,680,-1,680,221,220,-1,681,617,220,-1,220,222,681,-1,210,682,683,-1,683,208,210,-1,682,228,230,-1,230,683,682,-1,684,685,686,-1,686,687,684,-1,688,686,685,-1,685,689,688,-1,213,224,690,-1,690,211,213,-1,224,691,692,-1,692,690,224,-1,693,691,224,-1,224,221,693,-1,674,692,691,-1,691,675,674,-1,216,675,691,-1,691,693,216,-1,223,222,221,-1,221,224,223,-1,221,680,677,-1,677,693,221,-1,206,694,680,-1,680,207,206,-1,694,676,677,-1,677,680,694,-1,693,677,217,-1,217,216,693,-1,695,205,207,-1,207,616,695,-1,205,695,696,-1,696,697,205,-1,698,695,616,-1,616,181,698,-1,180,182,699,-1,699,231,180,-1,225,214,212,-1,212,219,225,-1,689,679,204,-1,204,688,689,-1,223,213,214,-1,214,700,223,-1,226,219,679,-1,679,701,226,-1,227,226,182,-1,182,218,227,-1,226,701,699,-1,699,182,226,-1,218,702,703,-1,703,227,218,-1,617,681,704,-1,704,179,617,-1,700,681,222,-1,222,223,700,-1,702,704,705,-1,705,703,702,-1,179,704,702,-1,702,218,179,-1,705,704,681,-1,681,700,705,-1,227,703,705,-1,705,225,227,-1,225,705,700,-1,700,214,225,-1,687,229,228,-1,228,684,687,-1,254,200,201,-1,201,619,254,-1,706,707,697,-1,697,696,706,-1,708,698,181,-1,181,183,708,-1,236,241,231,-1,231,699,236,-1,701,237,236,-1,236,699,701,-1,240,709,710,-1,710,232,240,-1,711,698,708,-1,708,712,711,-1,231,241,240,-1,240,232,231,-1,713,714,712,-1,712,715,713,-1,716,717,718,-1,718,719,716,-1,720,711,712,-1,712,714,720,-1,721,715,710,-1,710,709,721,-1,333,332,721,-1,721,310,333,-1,717,722,707,-1,707,706,717,-1,718,717,706,-1,706,720,718,-1,706,696,711,-1,711,720,706,-1,709,240,239,-1,239,309,709,-1,239,298,301,-1,301,309,239,-1,696,695,698,-1,698,711,696,-1,237,701,679,-1,679,689,237,-1,334,336,723,-1,723,724,334,-1,725,233,322,-1,322,726,725,-1,649,635,647,-1,647,660,649,-1,603,727,728,-1,728,602,603,-1,729,727,603,-1,603,604,729,-1,730,257,731,-1,731,732,730,-1,602,728,733,-1,733,178,602,-1,606,317,734,-1,734,605,606,-1,317,606,607,-1,607,735,317,-1,736,737,316,-1,316,738,736,-1,316,321,291,-1,291,738,316,-1,729,604,605,-1,605,734,729,-1,737,736,739,-1,739,740,737,-1,608,275,735,-1,735,607,608,-1,609,273,275,-1,275,608,609,-1,274,286,735,-1,735,275,274,-1,735,286,285,-1,285,317,735,-1,740,739,730,-1,730,732,740,-1,657,656,329,-1,329,741,657,-1,642,641,742,-1,742,330,642,-1,742,641,743,-1,743,744,742,-1,244,243,745,-1,745,746,244,-1,243,249,253,-1,253,745,243,-1,637,650,746,-1,746,745,637,-1,249,200,254,-1,254,253,249,-1,253,251,637,-1,637,745,253,-1,245,601,200,-1,200,249,245,-1,632,250,678,-1,678,633,632,-1,250,632,189,-1,189,251,250,-1,250,252,634,-1,634,678,250,-1,747,748,277,-1,277,749,747,-1,748,750,751,-1,751,277,748,-1,749,277,276,-1,276,752,749,-1,749,272,744,-1,744,747,749,-1,261,256,255,-1,255,281,261,-1,753,257,256,-1,256,754,753,-1,755,255,257,-1,257,730,755,-1,754,258,260,-1,260,323,754,-1,280,259,261,-1,261,281,280,-1,750,756,280,-1,280,751,750,-1,655,757,247,-1,247,246,655,-1,331,262,758,-1,758,759,331,-1,330,742,267,-1,267,266,330,-1,760,761,601,-1,601,245,760,-1,269,273,761,-1,761,760,269,-1,1,601,761,-1,761,176,1,-1,245,244,268,-1,268,760,245,-1,265,267,271,-1,271,762,265,-1,291,263,762,-1,762,763,291,-1,758,262,264,-1,264,269,758,-1,269,270,274,-1,274,273,269,-1,176,761,273,-1,273,609,176,-1,760,268,758,-1,758,269,760,-1,267,742,744,-1,744,272,267,-1,752,271,272,-1,272,749,752,-1,743,764,747,-1,747,744,743,-1,765,766,739,-1,739,736,765,-1,767,766,765,-1,765,278,767,-1,755,730,739,-1,739,766,755,-1,768,765,736,-1,736,738,768,-1,286,274,270,-1,270,287,286,-1,291,763,768,-1,768,738,291,-1,763,752,276,-1,276,768,763,-1,751,767,278,-1,278,277,751,-1,280,279,767,-1,767,751,280,-1,767,279,755,-1,755,766,767,-1,323,284,753,-1,753,754,323,-1,769,753,284,-1,284,770,769,-1,288,733,728,-1,728,289,288,-1,290,771,772,-1,772,288,290,-1,271,752,763,-1,763,762,271,-1,276,278,765,-1,765,768,276,-1,255,755,279,-1,279,281,255,-1,256,261,258,-1,258,754,256,-1,264,291,321,-1,321,270,264,-1,769,731,257,-1,257,753,769,-1,260,773,774,-1,774,323,260,-1,770,284,283,-1,283,775,770,-1,612,733,288,-1,288,772,612,-1,612,6,178,-1,178,733,612,-1,323,774,776,-1,776,324,323,-1,613,611,293,-1,293,292,613,-1,293,611,612,-1,612,772,293,-1,292,314,777,-1,777,613,292,-1,4,615,778,-1,778,177,4,-1,610,177,778,-1,778,779,610,-1,779,682,210,-1,210,610,779,-1,780,228,682,-1,682,779,780,-1,781,684,228,-1,228,780,781,-1,779,778,295,-1,295,780,779,-1,615,296,295,-1,295,778,615,-1,780,295,297,-1,297,781,780,-1,238,781,297,-1,297,299,238,-1,615,614,782,-1,782,296,615,-1,299,297,296,-1,296,300,299,-1,298,242,300,-1,300,301,298,-1,783,233,235,-1,235,784,783,-1,310,304,303,-1,303,333,310,-1,785,305,304,-1,304,302,785,-1,336,335,786,-1,786,787,336,-1,237,689,685,-1,685,238,237,-1,238,299,242,-1,242,236,238,-1,238,685,684,-1,684,781,238,-1,296,782,788,-1,788,300,296,-1,283,282,789,-1,789,790,283,-1,776,791,792,-1,792,324,776,-1,308,307,790,-1,790,789,308,-1,775,283,790,-1,790,793,775,-1,794,795,796,-1,796,797,794,-1,793,790,307,-1,307,798,793,-1,791,794,797,-1,797,792,791,-1,799,800,319,-1,319,318,799,-1,801,802,800,-1,800,799,801,-1,319,800,803,-1,803,804,319,-1,805,799,318,-1,318,783,805,-1,784,806,805,-1,805,783,784,-1,806,807,808,-1,808,805,806,-1,803,800,802,-1,802,315,803,-1,803,294,809,-1,809,804,803,-1,306,322,320,-1,320,810,306,-1,293,811,809,-1,809,294,293,-1,772,771,811,-1,811,293,772,-1,318,322,233,-1,233,783,318,-1,302,304,309,-1,309,301,302,-1,313,787,786,-1,786,311,313,-1,808,801,799,-1,799,805,808,-1,808,343,812,-1,812,801,808,-1,801,812,813,-1,813,802,801,-1,315,292,294,-1,294,803,315,-1,810,798,307,-1,307,306,810,-1,344,343,808,-1,808,807,344,-1,300,788,814,-1,814,302,300,-1,302,814,815,-1,815,785,302,-1,315,802,813,-1,813,314,315,-1,344,807,313,-1,313,312,344,-1,737,734,317,-1,317,316,737,-1,740,729,734,-1,734,737,740,-1,732,727,729,-1,729,740,732,-1,731,728,727,-1,727,732,731,-1,769,289,728,-1,728,731,769,-1,770,290,289,-1,289,769,770,-1,775,771,290,-1,290,770,775,-1,793,811,771,-1,771,775,793,-1,798,809,811,-1,811,793,798,-1,810,804,809,-1,809,798,810,-1,320,319,804,-1,804,810,320,-1,316,285,287,-1,287,321,316,-1,709,309,310,-1,310,721,709,-1,234,233,725,-1,725,327,234,-1,816,719,718,-1,718,817,816,-1,715,721,332,-1,332,713,715,-1,818,819,797,-1,797,796,818,-1,820,792,797,-1,797,819,820,-1,325,324,792,-1,792,820,325,-1,325,282,284,-1,284,323,325,-1,820,789,282,-1,282,325,820,-1,819,308,789,-1,789,820,819,-1,819,818,726,-1,726,308,819,-1,818,796,339,-1,339,338,818,-1,338,725,726,-1,726,818,338,-1,646,652,651,-1,651,643,646,-1,657,757,652,-1,652,646,657,-1,741,247,757,-1,757,657,741,-1,759,758,268,-1,268,326,759,-1,642,656,645,-1,645,639,642,-1,330,329,656,-1,656,642,330,-1,716,821,722,-1,722,717,716,-1,822,716,719,-1,719,328,822,-1,648,652,757,-1,757,655,648,-1,246,746,650,-1,650,655,246,-1,248,244,746,-1,746,246,248,-1,651,649,660,-1,660,653,651,-1,327,725,338,-1,338,823,327,-1,823,822,328,-1,328,327,823,-1,824,825,822,-1,822,823,824,-1,806,787,313,-1,313,807,806,-1,784,336,787,-1,787,806,784,-1,235,723,336,-1,336,784,235,-1,234,816,723,-1,723,235,234,-1,328,719,816,-1,816,234,328,-1,265,262,331,-1,331,266,265,-1,762,263,262,-1,262,265,762,-1,759,741,329,-1,329,331,759,-1,326,247,741,-1,741,759,326,-1,308,726,322,-1,322,306,308,-1,720,714,817,-1,817,718,720,-1,311,785,815,-1,815,312,311,-1,786,305,785,-1,785,311,786,-1,335,303,305,-1,305,786,335,-1,334,333,303,-1,303,335,334,-1,817,724,723,-1,723,816,817,-1,708,710,715,-1,715,712,708,-1,183,232,710,-1,710,708,183,-1,724,817,714,-1,714,713,724,-1,334,724,713,-1,713,332,334,-1,824,823,338,-1,338,337,824,-1,821,716,822,-1,822,825,821,-1,342,341,812,-1,812,343,342,-1,826,813,812,-1,812,341,826,-1,341,588,587,-1,587,826,341,-1,589,588,341,-1,341,340,589,-1,340,827,590,-1,590,589,340,-1,342,828,827,-1,827,340,342,-1,312,815,829,-1,829,828,312,-1,830,614,375,-1,375,594,830,-1,831,782,614,-1,614,830,831,-1,814,788,782,-1,782,831,814,-1,831,829,815,-1,815,814,831,-1,830,832,829,-1,829,831,830,-1,594,598,832,-1,832,830,594,-1,827,832,598,-1,598,590,827,-1,828,829,832,-1,832,827,828,-1,826,777,314,-1,314,813,826,-1,587,599,777,-1,777,826,587,-1,828,342,344,-1,344,312,828,-1,613,777,599,-1,599,371,613,-1,833,834,835,-1,836,837,838,-1,839,840,841,-1,842,843,844,-1,845,846,847,-1,848,849,850,-1,851,852,853,-1,854,855,856,-1,857,858,859,-1,860,861,862,-1,846,834,847,-1,848,837,849,-1,863,864,865,-1,866,867,868,-1,869,870,871,-1,872,873,874,-1,869,871,875,-1,876,872,874,-1,877,839,875,-1,876,844,878,-1,877,879,839,-1,844,880,878,-1,881,877,882,-1,883,878,884,-1,885,886,887,-1,888,889,890,-1,891,892,893,-1,894,895,896,-1,897,898,899,-1,900,901,902,-1,903,904,905,-1,906,907,908,-1,909,910,911,-1,912,913,914,-1,915,916,917,-1,918,919,920,-1,921,917,916,-1,919,918,922,-1,917,923,915,-1,920,924,918,-1,925,915,923,-1,924,920,926,-1,927,915,925,-1,926,920,928,-1,929,930,931,-1,932,933,934,-1,921,887,935,-1,936,888,922,-1,935,937,921,-1,922,938,936,-1,939,940,941,-1,942,943,944,-1,931,905,945,-1,946,906,932,-1,905,947,945,-1,946,948,906,-1,949,950,887,-1,888,951,952,-1,898,953,899,-1,900,954,901,-1,940,955,956,-1,957,958,943,-1,959,960,961,-1,962,963,964,-1,960,965,961,-1,962,966,963,-1,955,967,968,-1,969,970,958,-1,971,972,973,-1,974,975,976,-1,977,978,979,-1,980,981,982,-1,983,979,984,-1,985,980,986,-1,987,988,989,-1,990,991,987,-1,987,992,988,-1,991,993,987,-1,987,994,992,-1,993,995,987,-1,987,996,994,-1,995,996,987,-1,997,998,999,-1,1000,1001,1002,-1,1003,1004,1005,-1,1006,1007,1008,-1,988,1009,989,-1,990,1010,991,-1,1011,1012,1013,-1,1014,1015,1016,-1,999,998,1017,-1,1018,1001,1000,-1,998,1019,1017,-1,1018,1020,1001,-1,1021,1022,1023,-1,1024,1025,1026,-1,1027,1028,1029,-1,1030,1031,1032,-1,1033,865,864,-1,867,866,1034,-1,1035,1036,1037,-1,1038,1039,1040,-1,1041,1042,345,-1,600,1043,1044,-1,1045,1046,383,-1,622,1047,1048,-1,1049,1050,1051,-1,1052,1053,1054,-1,1055,1056,1057,-1,1058,1059,1060,-1,1061,1062,1056,-1,1059,1063,1064,-1,1065,1066,1067,-1,1067,1068,1065,-1,1068,1069,1070,-1,1070,1065,1068,-1,857,1071,1068,-1,1068,1067,857,-1,1069,1068,1071,-1,1071,862,1069,-1,1072,1073,1074,-1,1074,1075,1072,-1,1076,1077,1073,-1,1073,1072,1076,-1,1078,1072,1075,-1,1075,1079,1078,-1,1080,1076,1072,-1,1072,1078,1080,-1,1081,1078,1079,-1,1079,1082,1081,-1,1083,1080,1078,-1,1078,1081,1083,-1,1084,1081,1082,-1,1082,1085,1084,-1,1086,1083,1081,-1,1081,1084,1086,-1,1087,1084,1085,-1,1085,1088,1087,-1,1089,1086,1084,-1,1084,1087,1089,-1,1090,1087,1088,-1,1088,1091,1090,-1,1092,1089,1087,-1,1087,1090,1092,-1,1093,1090,1091,-1,1091,1094,1093,-1,1095,1092,1090,-1,1090,1093,1095,-1,1096,1093,1094,-1,1094,1097,1096,-1,1098,1095,1093,-1,1093,1096,1098,-1,1099,1096,1097,-1,1097,1100,1099,-1,1101,1098,1096,-1,1096,1099,1101,-1,1102,1099,1100,-1,1100,1103,1102,-1,1104,1101,1099,-1,1099,1102,1104,-1,859,1105,1071,-1,1071,857,859,-1,862,1071,1105,-1,1105,860,862,-1,1106,1105,859,-1,859,1107,1106,-1,1108,860,1105,-1,1105,1106,1108,-1,1109,1110,1111,-1,1111,1112,1109,-1,1113,1114,1115,-1,1115,1116,1113,-1,879,1112,1111,-1,1111,1117,879,-1,1118,1114,1113,-1,1113,880,1118,-1,1119,1120,1111,-1,1111,1110,1119,-1,1115,1114,1121,-1,1121,1122,1115,-1,1109,858,1123,-1,1123,1110,1109,-1,1115,1124,861,-1,861,1116,1115,-1,881,1125,1109,-1,1109,1112,881,-1,1113,1116,1126,-1,1126,884,1113,-1,1117,1111,1120,-1,1120,1127,1117,-1,1128,1121,1114,-1,1114,1118,1128,-1,1129,1119,1110,-1,1110,1123,1129,-1,1124,1115,1122,-1,1122,1130,1124,-1,840,1117,1127,-1,1127,1131,840,-1,1132,1128,1118,-1,1118,843,1132,-1,881,1112,879,-1,879,877,881,-1,878,880,1113,-1,1113,884,878,-1,839,879,1117,-1,1117,840,839,-1,843,1118,880,-1,880,844,843,-1,851,1133,973,-1,973,972,851,-1,975,974,1134,-1,1134,856,975,-1,870,1135,1136,-1,1136,1137,870,-1,1138,1139,1140,-1,1140,873,1138,-1,1141,1142,1137,-1,1137,1136,1141,-1,1139,1138,1143,-1,1143,1144,1139,-1,1145,1136,1135,-1,1135,1146,1145,-1,1147,1140,1139,-1,1139,1148,1147,-1,841,1135,870,-1,870,869,841,-1,874,873,1140,-1,1140,842,874,-1,1137,1149,871,-1,871,870,1137,-1,873,872,1150,-1,1150,1138,873,-1,1146,1135,841,-1,841,840,1146,-1,843,842,1140,-1,1140,1147,843,-1,1151,1141,1136,-1,1136,1145,1151,-1,1148,1139,1144,-1,1144,1152,1148,-1,1146,1153,1029,-1,1029,1145,1146,-1,1148,1030,1154,-1,1154,1147,1148,-1,1155,1156,1142,-1,1142,1157,1155,-1,1158,1143,1159,-1,1159,1160,1158,-1,1161,1157,1142,-1,1142,1141,1161,-1,1144,1143,1158,-1,1158,1162,1144,-1,1137,1142,1156,-1,1156,1149,1137,-1,1150,1159,1143,-1,1143,1138,1150,-1,1163,1156,1155,-1,1155,1164,1163,-1,1165,1160,1159,-1,1159,1166,1165,-1,1157,1167,1168,-1,1168,1155,1157,-1,1160,1169,1170,-1,1170,1158,1160,-1,1141,1151,863,-1,863,1161,1141,-1,1162,868,1152,-1,1152,1144,1162,-1,863,865,1171,-1,1171,1161,863,-1,1162,1172,866,-1,866,868,1162,-1,1151,1028,864,-1,864,863,1151,-1,868,867,1031,-1,1031,1152,868,-1,1173,1168,1167,-1,1167,1174,1173,-1,1175,1170,1169,-1,1169,1176,1175,-1,1177,1174,1167,-1,1167,1171,1177,-1,1172,1170,1175,-1,1175,1178,1172,-1,1179,1168,1173,-1,1173,1180,1179,-1,1181,1176,1169,-1,1169,1182,1181,-1,1174,1183,1184,-1,1184,1173,1174,-1,1176,1185,1186,-1,1186,1175,1176,-1,1171,865,1037,-1,1037,1177,1171,-1,1178,1038,866,-1,866,1172,1178,-1,1177,1037,1036,-1,1036,1187,1177,-1,1188,1039,1038,-1,1038,1178,1188,-1,1189,835,834,-1,834,846,1189,-1,849,837,836,-1,836,1190,849,-1,833,1184,1183,-1,1183,834,833,-1,837,1186,1185,-1,1185,838,837,-1,886,885,833,-1,833,835,886,-1,836,838,890,-1,890,889,836,-1,1187,1036,1191,-1,1191,847,1187,-1,848,1192,1039,-1,1039,1188,848,-1,845,847,1191,-1,1191,1193,845,-1,1194,1192,848,-1,848,850,1194,-1,847,834,1183,-1,1183,1187,847,-1,1188,1186,837,-1,837,848,1188,-1,1123,1067,1066,-1,1066,1129,1123,-1,1130,1070,1069,-1,1069,1124,1130,-1,1153,1146,840,-1,840,1131,1153,-1,1132,843,1147,-1,1147,1154,1132,-1,841,869,875,-1,875,839,841,-1,844,876,874,-1,874,842,844,-1,1067,1123,858,-1,858,857,1067,-1,862,861,1124,-1,1124,1069,862,-1,858,1109,1125,-1,1125,859,858,-1,860,1126,1116,-1,1116,861,860,-1,1195,1196,1197,-1,1197,972,1195,-1,975,1198,1199,-1,1199,1200,975,-1,1133,851,853,-1,853,1201,1133,-1,1202,854,856,-1,856,1134,1202,-1,972,1197,1203,-1,1203,851,972,-1,856,1204,1198,-1,1198,975,856,-1,1201,1205,1206,-1,1206,1051,1201,-1,1052,1207,1208,-1,1208,1202,1052,-1,1209,845,1205,-1,1205,1210,1209,-1,1211,1208,850,-1,850,1212,1211,-1,1201,853,1210,-1,1210,1205,1201,-1,1208,1211,854,-1,854,1202,1208,-1,1193,1206,1205,-1,1205,845,1193,-1,850,1208,1207,-1,1207,1194,850,-1,846,845,1209,-1,1209,1189,846,-1,1190,1212,850,-1,850,849,1190,-1,1210,1213,911,-1,911,1209,1210,-1,1212,912,1214,-1,1214,1211,1212,-1,853,852,1213,-1,1213,1210,853,-1,1211,1214,855,-1,855,854,1211,-1,1189,1209,911,-1,911,910,1189,-1,913,912,1212,-1,1212,1190,913,-1,1155,1168,1179,-1,1179,1164,1155,-1,1165,1182,1169,-1,1169,1160,1165,-1,1171,1167,1157,-1,1157,1161,1171,-1,1162,1158,1170,-1,1170,1172,1162,-1,1187,1183,1174,-1,1174,1177,1187,-1,1178,1175,1186,-1,1186,1188,1178,-1,1173,1184,1215,-1,1215,1180,1173,-1,1181,1216,1185,-1,1185,1176,1181,-1,1217,871,1149,-1,1149,1218,1217,-1,1219,1150,872,-1,872,1220,1219,-1,875,871,1217,-1,1217,877,875,-1,878,1220,872,-1,872,876,878,-1,1145,1029,1028,-1,1028,1151,1145,-1,1152,1031,1030,-1,1030,1148,1152,-1,1149,1156,1163,-1,1163,1218,1149,-1,1219,1166,1159,-1,1159,1150,1219,-1,885,1215,1184,-1,1184,833,885,-1,838,1185,1216,-1,1216,890,838,-1,910,886,835,-1,835,1189,910,-1,1190,836,889,-1,889,913,1190,-1,882,877,1217,-1,1217,1221,882,-1,1222,1220,878,-1,878,883,1222,-1,1223,1125,881,-1,881,882,1223,-1,883,884,1126,-1,1126,1224,883,-1,886,910,949,-1,949,887,886,-1,888,952,913,-1,913,889,888,-1,916,885,887,-1,887,921,916,-1,922,888,890,-1,890,919,922,-1,1074,1225,1226,-1,1226,1075,1074,-1,1076,1227,1228,-1,1228,1077,1076,-1,1075,1226,1229,-1,1229,1079,1075,-1,1080,1230,1227,-1,1227,1076,1080,-1,1079,1229,1231,-1,1231,1082,1079,-1,1083,1232,1230,-1,1230,1080,1083,-1,1082,1231,1233,-1,1233,1085,1082,-1,1086,1234,1232,-1,1232,1083,1086,-1,1085,1233,1235,-1,1235,1088,1085,-1,1089,1236,1234,-1,1234,1086,1089,-1,1235,1237,1091,-1,1091,1088,1235,-1,1089,1092,1238,-1,1238,1236,1089,-1,1091,1237,1239,-1,1239,1094,1091,-1,1095,1240,1238,-1,1238,1092,1095,-1,1094,1239,1241,-1,1241,1097,1094,-1,1098,1242,1240,-1,1240,1095,1098,-1,1097,1241,1243,-1,1243,1100,1097,-1,1101,1244,1242,-1,1242,1098,1101,-1,1100,1243,1245,-1,1245,1103,1100,-1,1104,1246,1244,-1,1244,1101,1104,-1,1247,1248,1249,-1,1249,978,1247,-1,981,1250,1251,-1,1251,1252,981,-1,1248,1253,1254,-1,1254,1249,1248,-1,1250,1255,1256,-1,1256,1251,1250,-1,1257,1258,1248,-1,1248,1247,1257,-1,1252,1251,1259,-1,1259,1260,1252,-1,1243,1247,978,-1,978,1245,1243,-1,1246,981,1252,-1,1252,1244,1246,-1,984,1249,1254,-1,1254,1261,984,-1,1262,1255,1250,-1,1250,985,1262,-1,1253,1263,1264,-1,1264,1254,1253,-1,1255,1265,1266,-1,1266,1256,1255,-1,1248,1258,965,-1,965,1253,1248,-1,1256,966,1259,-1,1259,1251,1256,-1,1267,1261,1254,-1,1254,1264,1267,-1,1265,1255,1262,-1,1262,1268,1265,-1,1263,1269,1270,-1,1270,1264,1263,-1,1265,1271,1272,-1,1272,1266,1265,-1,1253,965,960,-1,960,1263,1253,-1,1266,963,966,-1,966,1256,1266,-1,1264,1270,1196,-1,1196,1267,1264,-1,1268,1199,1271,-1,1271,1265,1268,-1,1269,1273,1274,-1,1274,1270,1269,-1,1271,1275,1276,-1,1276,1272,1271,-1,960,1277,1269,-1,1269,1263,960,-1,1266,1272,1278,-1,1278,963,1266,-1,1197,1196,1270,-1,1270,1274,1197,-1,1275,1271,1199,-1,1199,1198,1275,-1,1274,1273,1279,-1,1279,1280,1274,-1,1281,1282,1276,-1,1276,1275,1281,-1,1277,1283,1273,-1,1273,1269,1277,-1,1272,1276,1284,-1,1284,1278,1272,-1,1283,1277,1285,-1,1285,899,1283,-1,900,1286,1278,-1,1278,1284,900,-1,892,1287,899,-1,899,1285,892,-1,1286,900,1288,-1,1288,895,1286,-1,1277,960,1289,-1,1289,1285,1277,-1,1286,1290,963,-1,963,1278,1286,-1,1283,899,953,-1,953,1291,1283,-1,1292,954,900,-1,900,1284,1292,-1,893,892,1285,-1,1285,1289,893,-1,1290,1286,895,-1,895,894,1290,-1,1289,960,959,-1,959,1293,1289,-1,1294,964,963,-1,963,1290,1294,-1,1107,859,1125,-1,1125,1223,1107,-1,1224,1126,860,-1,860,1108,1224,-1,1218,1295,1221,-1,1221,1217,1218,-1,1220,1222,1296,-1,1296,1219,1220,-1,1297,1287,892,-1,892,891,1297,-1,896,895,1288,-1,1288,1298,896,-1,891,893,1299,-1,1299,956,891,-1,957,1300,894,-1,894,896,957,-1,1295,1218,1163,-1,1163,1301,1295,-1,1302,1166,1219,-1,1219,1296,1302,-1,1301,1163,1164,-1,1164,1303,1301,-1,1304,1165,1166,-1,1166,1302,1304,-1,1164,1179,1305,-1,1305,1303,1164,-1,1304,1306,1182,-1,1182,1165,1304,-1,1305,1179,1180,-1,1180,1307,1305,-1,1308,1181,1182,-1,1182,1306,1308,-1,1180,1215,1309,-1,1309,1307,1180,-1,1308,1310,1216,-1,1216,1181,1308,-1,1309,1215,885,-1,885,916,1309,-1,919,890,1216,-1,1216,1310,919,-1,1233,1311,1312,-1,1312,1235,1233,-1,1236,1313,1314,-1,1314,1234,1236,-1,1312,1315,1237,-1,1237,1235,1312,-1,1236,1238,1316,-1,1316,1313,1236,-1,1311,1317,1318,-1,1318,1312,1311,-1,1313,1319,1320,-1,1320,1314,1313,-1,1231,941,1311,-1,1311,1233,1231,-1,1234,1314,942,-1,942,1232,1234,-1,1318,1321,1315,-1,1315,1312,1318,-1,1313,1316,1322,-1,1322,1319,1313,-1,1318,1317,1299,-1,1299,1293,1318,-1,1294,1300,1320,-1,1320,1319,1294,-1,941,940,1317,-1,1317,1311,941,-1,1314,1320,943,-1,943,942,1314,-1,1287,1323,897,-1,897,899,1287,-1,900,902,1324,-1,1324,1288,900,-1,1323,1325,1326,-1,1326,897,1323,-1,902,1327,1328,-1,1328,1324,902,-1,1329,1323,1287,-1,1287,1297,1329,-1,1298,1288,1324,-1,1324,1330,1298,-1,898,897,1326,-1,1326,1331,898,-1,1332,1327,902,-1,902,901,1332,-1,1326,1325,1333,-1,1333,1334,1326,-1,1335,1336,1328,-1,1328,1327,1335,-1,1337,1325,1323,-1,1323,1329,1337,-1,1330,1324,1328,-1,1328,1338,1330,-1,1339,1340,1341,-1,1341,1342,1339,-1,1343,1344,1345,-1,1345,1346,1343,-1,1342,1341,1279,-1,1279,1291,1342,-1,1292,1282,1344,-1,1344,1343,1292,-1,1347,1341,1340,-1,1340,904,1347,-1,907,1345,1344,-1,1344,1348,907,-1,1349,1350,1340,-1,1340,1339,1349,-1,1346,1345,1351,-1,1351,1352,1346,-1,1342,1353,1354,-1,1354,1339,1342,-1,1346,1355,1356,-1,1356,1343,1346,-1,1241,1257,1247,-1,1247,1243,1241,-1,1244,1252,1260,-1,1260,1242,1244,-1,1239,1357,1257,-1,1257,1241,1239,-1,1242,1260,1358,-1,1358,1240,1242,-1,1357,1359,1258,-1,1258,1257,1357,-1,1260,1259,1360,-1,1360,1358,1260,-1,1291,1279,1273,-1,1273,1283,1291,-1,1284,1276,1282,-1,1282,1292,1284,-1,1280,1279,1341,-1,1341,1347,1280,-1,1348,1344,1282,-1,1282,1281,1348,-1,1291,953,1353,-1,1353,1342,1291,-1,1343,1356,954,-1,954,1292,1343,-1,1280,1203,1197,-1,1197,1274,1280,-1,1275,1198,1204,-1,1204,1281,1275,-1,1347,1361,1203,-1,1203,1280,1347,-1,1281,1204,1362,-1,1362,1348,1281,-1,851,1203,1361,-1,1361,852,851,-1,855,1362,1204,-1,1204,856,855,-1,904,1363,1361,-1,1361,1347,904,-1,1348,1362,1364,-1,1364,907,1348,-1,852,1361,1363,-1,1363,1213,852,-1,1214,1364,1362,-1,1362,855,1214,-1,903,909,1363,-1,1363,904,903,-1,907,1364,914,-1,914,908,907,-1,904,1340,1350,-1,1350,905,904,-1,906,1351,1345,-1,1345,907,906,-1,1339,1354,1365,-1,1365,1349,1339,-1,1352,1366,1355,-1,1355,1346,1352,-1,903,905,931,-1,931,1367,903,-1,1368,932,906,-1,906,908,1368,-1,910,909,1369,-1,1369,949,910,-1,952,1370,914,-1,914,913,952,-1,911,1213,1363,-1,1363,909,911,-1,914,1364,1214,-1,1214,912,914,-1,929,925,923,-1,923,930,929,-1,933,924,926,-1,926,934,933,-1,1371,1372,947,-1,947,1373,1371,-1,1374,948,1375,-1,1375,1376,1374,-1,1372,1377,927,-1,927,1378,1372,-1,1379,928,1380,-1,1380,1375,1379,-1,923,937,1381,-1,1381,930,923,-1,933,1382,938,-1,938,924,933,-1,1378,927,925,-1,925,929,1378,-1,934,926,928,-1,928,1379,934,-1,887,950,1383,-1,1383,935,887,-1,936,1384,951,-1,951,888,936,-1,1225,1385,1386,-1,1386,1226,1225,-1,1227,1387,1388,-1,1388,1228,1227,-1,1385,967,955,-1,955,1386,1385,-1,1387,958,970,-1,970,1388,1387,-1,1229,939,941,-1,941,1231,1229,-1,1232,942,944,-1,944,1230,1232,-1,1226,1386,939,-1,939,1229,1226,-1,1230,944,1387,-1,1387,1227,1230,-1,1386,955,940,-1,940,939,1386,-1,944,943,958,-1,958,1387,944,-1,956,1299,1317,-1,1317,940,956,-1,943,1320,1300,-1,1300,957,943,-1,968,1389,1297,-1,1297,891,968,-1,896,1298,1390,-1,1390,969,896,-1,891,956,955,-1,955,968,891,-1,969,958,957,-1,957,896,969,-1,945,1378,929,-1,929,931,945,-1,932,934,1379,-1,1379,946,932,-1,945,947,1372,-1,1372,1378,945,-1,1379,1375,948,-1,948,946,1379,-1,1373,947,905,-1,905,1350,1373,-1,1351,906,948,-1,948,1374,1351,-1,903,1367,1369,-1,1369,909,903,-1,914,1370,1368,-1,1368,908,914,-1,1381,1383,1369,-1,1369,1367,1381,-1,1368,1370,1384,-1,1384,1382,1368,-1,930,1381,1367,-1,1367,931,930,-1,932,1368,1382,-1,1382,933,932,-1,949,1369,1383,-1,1383,950,949,-1,951,1384,1370,-1,1370,952,951,-1,937,935,1383,-1,1383,1381,937,-1,1382,1384,936,-1,936,938,1382,-1,917,921,937,-1,937,923,917,-1,924,938,922,-1,922,918,924,-1,1331,1326,1334,-1,1334,1391,1331,-1,1392,1335,1327,-1,1327,1332,1392,-1,1353,1331,1391,-1,1391,1354,1353,-1,1355,1392,1332,-1,1332,1356,1355,-1,953,898,1331,-1,1331,1353,953,-1,1356,1332,901,-1,901,954,1356,-1,961,1359,1321,-1,1321,959,961,-1,964,1322,1360,-1,1360,962,964,-1,961,965,1258,-1,1258,1359,961,-1,1360,1259,966,-1,966,962,1360,-1,1293,959,1321,-1,1321,1318,1293,-1,1319,1322,964,-1,964,1294,1319,-1,1315,1321,1359,-1,1359,1357,1315,-1,1358,1360,1322,-1,1322,1316,1358,-1,1293,1299,893,-1,893,1289,1293,-1,1290,894,1300,-1,1300,1294,1290,-1,1237,1315,1357,-1,1357,1239,1237,-1,1240,1358,1316,-1,1316,1238,1240,-1,1051,1050,1133,-1,1133,1201,1051,-1,1202,1134,1053,-1,1053,1052,1202,-1,1393,1102,1103,-1,1103,1022,1393,-1,1025,1104,1102,-1,1102,1393,1025,-1,972,971,1394,-1,1394,1195,972,-1,1200,1395,976,-1,976,975,1200,-1,1267,1196,1195,-1,1195,997,1267,-1,1002,1200,1199,-1,1199,1268,1002,-1,983,984,1261,-1,1261,999,983,-1,1000,1262,985,-1,985,986,1000,-1,1261,1267,997,-1,997,999,1261,-1,1000,1002,1268,-1,1268,1262,1000,-1,983,1396,977,-1,977,979,983,-1,980,982,1397,-1,1397,986,980,-1,1103,1245,1023,-1,1023,1022,1103,-1,1025,1024,1246,-1,1246,1104,1025,-1,978,1249,984,-1,984,979,978,-1,980,985,1250,-1,1250,981,980,-1,1245,978,977,-1,977,1023,1245,-1,1024,982,981,-1,981,1246,1024,-1,1398,1399,1400,-1,1400,1401,1398,-1,1402,1400,1399,-1,1399,1403,1402,-1,987,989,1404,-1,1404,1405,987,-1,1405,1406,990,-1,990,987,1405,-1,994,996,1407,-1,1407,1408,994,-1,1409,1407,996,-1,996,995,1409,-1,1405,1404,1401,-1,1401,1400,1405,-1,1400,1402,1406,-1,1406,1405,1400,-1,1408,1407,1410,-1,1410,1411,1408,-1,1412,1410,1407,-1,1407,1409,1412,-1,1413,1414,1399,-1,1399,1398,1413,-1,1403,1399,1414,-1,1414,1415,1403,-1,1416,1393,1022,-1,1022,1417,1416,-1,1418,1025,1393,-1,1393,1416,1418,-1,1419,1416,1417,-1,1417,1005,1419,-1,1006,1418,1416,-1,1416,1419,1006,-1,1410,1419,1005,-1,1005,1411,1410,-1,1412,1006,1419,-1,1419,1410,1412,-1,1062,971,973,-1,973,1420,1062,-1,1421,974,976,-1,976,1063,1421,-1,1394,998,997,-1,997,1195,1394,-1,1200,1002,1001,-1,1001,1395,1200,-1,971,1062,1422,-1,1422,1394,971,-1,1395,1423,1063,-1,1063,976,1395,-1,1420,973,1133,-1,1133,1050,1420,-1,1053,1134,974,-1,974,1421,1053,-1,998,1394,1422,-1,1422,1424,998,-1,1425,1423,1395,-1,1395,1001,1425,-1,1426,1398,1401,-1,1401,1427,1426,-1,1428,1402,1403,-1,1403,1429,1428,-1,1404,1430,1427,-1,1427,1401,1404,-1,1402,1428,1431,-1,1431,1406,1402,-1,1398,1426,1013,-1,1013,1413,1398,-1,1415,1014,1429,-1,1429,1403,1415,-1,1432,1426,1427,-1,1427,1433,1432,-1,1434,1428,1429,-1,1429,1435,1434,-1,1430,1436,1433,-1,1433,1427,1430,-1,1428,1434,1437,-1,1437,1431,1428,-1,1013,1426,1432,-1,1432,1011,1013,-1,1016,1435,1429,-1,1429,1014,1016,-1,1004,1432,1433,-1,1433,1438,1004,-1,1439,1434,1435,-1,1435,1007,1439,-1,1436,1440,1438,-1,1438,1433,1436,-1,1434,1439,1441,-1,1441,1437,1434,-1,1011,1432,1004,-1,1004,1003,1011,-1,1008,1007,1435,-1,1435,1016,1008,-1,1005,1004,1438,-1,1438,1411,1005,-1,1412,1439,1007,-1,1007,1006,1412,-1,1440,1408,1411,-1,1411,1438,1440,-1,1439,1412,1409,-1,1409,1441,1439,-1,988,992,1440,-1,1440,1436,988,-1,1437,1441,993,-1,993,991,1437,-1,992,994,1408,-1,1408,1440,992,-1,1441,1409,995,-1,995,993,1441,-1,1009,988,1436,-1,1436,1430,1009,-1,1431,1437,991,-1,991,1010,1431,-1,989,1009,1430,-1,1430,1404,989,-1,1406,1431,1010,-1,1010,990,1406,-1,1003,1442,1012,-1,1012,1011,1003,-1,1016,1015,1443,-1,1443,1008,1016,-1,1022,1021,1444,-1,1444,1417,1022,-1,1418,1445,1026,-1,1026,1025,1418,-1,1417,1444,1003,-1,1003,1005,1417,-1,1006,1008,1445,-1,1445,1418,1006,-1,1442,1446,1447,-1,1447,1012,1442,-1,1015,1448,1449,-1,1449,1443,1015,-1,1444,1450,1442,-1,1442,1003,1444,-1,1008,1443,1451,-1,1451,1445,1008,-1,1447,1446,1019,-1,1019,1452,1447,-1,1453,1020,1449,-1,1449,1448,1453,-1,1450,1454,1446,-1,1446,1442,1450,-1,1443,1449,1455,-1,1455,1451,1443,-1,1452,1019,998,-1,998,1424,1452,-1,1425,1001,1020,-1,1020,1453,1425,-1,1017,1454,983,-1,983,999,1017,-1,1000,986,1455,-1,1455,1018,1000,-1,1017,1019,1446,-1,1446,1454,1017,-1,1455,1449,1020,-1,1020,1018,1455,-1,1396,983,1454,-1,1454,1450,1396,-1,1451,1455,986,-1,986,1397,1451,-1,1021,1396,1450,-1,1450,1444,1021,-1,1445,1451,1397,-1,1397,1026,1445,-1,977,1396,1021,-1,1021,1023,977,-1,1024,1026,1397,-1,1397,982,1024,-1,1028,1027,1033,-1,1033,864,1028,-1,867,1034,1032,-1,1032,1031,867,-1,865,1033,1035,-1,1035,1037,865,-1,1038,1040,1034,-1,1034,866,1038,-1,1036,1035,1456,-1,1456,1191,1036,-1,1192,1457,1040,-1,1040,1039,1192,-1,1066,1065,1458,-1,1458,1042,1066,-1,1043,1458,1065,-1,1065,1070,1043,-1,1458,346,345,-1,345,1042,1458,-1,1043,600,346,-1,346,1458,1043,-1,1119,1459,1460,-1,1460,1120,1119,-1,1121,1461,1462,-1,1462,1122,1121,-1,1127,1120,1460,-1,1460,1046,1127,-1,1047,1461,1121,-1,1121,1128,1047,-1,1459,16,15,-1,15,1460,1459,-1,1461,185,184,-1,184,1462,1461,-1,1041,1459,1119,-1,1119,1129,1041,-1,1130,1122,1462,-1,1462,1044,1130,-1,1460,15,383,-1,383,1046,1460,-1,1047,622,185,-1,185,1461,1047,-1,1131,1127,1046,-1,1046,1045,1131,-1,1048,1047,1128,-1,1128,1132,1048,-1,1153,1463,1027,-1,1027,1029,1153,-1,1030,1032,1464,-1,1464,1154,1030,-1,1463,384,424,-1,424,1027,1463,-1,1032,663,625,-1,625,1464,1032,-1,1153,1131,1045,-1,1045,1463,1153,-1,1464,1048,1132,-1,1132,1154,1464,-1,1027,424,425,-1,425,1033,1027,-1,1034,665,663,-1,663,1032,1034,-1,1033,425,426,-1,426,1035,1033,-1,1040,666,665,-1,665,1034,1040,-1,428,1456,1035,-1,1035,426,428,-1,666,1040,1457,-1,1457,667,666,-1,383,384,1463,-1,1463,1045,383,-1,1048,1464,625,-1,625,622,1048,-1,1129,1066,1042,-1,1042,1041,1129,-1,1044,1043,1070,-1,1070,1130,1044,-1,345,16,1459,-1,1459,1041,345,-1,1044,1462,184,-1,184,600,1044,-1,1456,1465,1193,-1,1193,1191,1456,-1,1192,1194,1466,-1,1466,1457,1192,-1,1467,1414,1413,-1,1413,1468,1467,-1,1469,1415,1414,-1,1414,1467,1469,-1,365,1467,1468,-1,1468,40,365,-1,209,1469,1467,-1,1467,365,209,-1,1051,1206,1470,-1,1470,1471,1051,-1,1472,1473,1207,-1,1207,1052,1472,-1,1470,451,450,-1,450,1471,1470,-1,1472,690,692,-1,692,1473,1472,-1,1465,1470,1206,-1,1206,1193,1465,-1,1194,1207,1473,-1,1473,1466,1194,-1,1049,1051,1471,-1,1471,1474,1049,-1,1475,1472,1052,-1,1052,1054,1475,-1,1456,428,435,-1,435,1465,1456,-1,1466,674,667,-1,667,1457,1466,-1,1465,435,451,-1,451,1470,1465,-1,1473,692,674,-1,674,1466,1473,-1,1057,1056,1062,-1,1062,1420,1057,-1,1421,1063,1059,-1,1059,1058,1421,-1,1013,1476,1468,-1,1468,1413,1013,-1,1415,1469,1477,-1,1477,1014,1415,-1,1478,1476,1013,-1,1013,1012,1478,-1,1015,1014,1477,-1,1477,1479,1015,-1,1476,41,40,-1,40,1468,1476,-1,1469,209,208,-1,208,1477,1469,-1,1050,1049,1057,-1,1057,1420,1050,-1,1421,1058,1054,-1,1054,1053,1421,-1,1055,34,33,-1,33,1056,1055,-1,1059,204,203,-1,203,1060,1059,-1,1057,1049,1474,-1,1474,1055,1057,-1,1060,1475,1054,-1,1054,1058,1060,-1,1447,1480,1478,-1,1478,1012,1447,-1,1015,1479,1481,-1,1481,1448,1015,-1,1478,1480,59,-1,59,442,1478,-1,683,230,1481,-1,1481,1479,683,-1,1480,1447,1452,-1,1452,1482,1480,-1,1483,1453,1448,-1,1448,1481,1483,-1,1476,1478,442,-1,442,41,1476,-1,208,683,1479,-1,1479,1477,208,-1,59,1480,1482,-1,1482,60,59,-1,229,1483,1481,-1,1481,230,229,-1,1484,445,444,-1,444,1485,1484,-1,1486,687,686,-1,686,1487,1486,-1,60,1482,1485,-1,1485,444,60,-1,687,1486,1483,-1,1483,229,687,-1,1061,449,445,-1,445,1484,1061,-1,1487,686,688,-1,688,1064,1487,-1,1485,1424,1422,-1,1422,1484,1485,-1,1487,1423,1425,-1,1425,1486,1487,-1,33,449,1061,-1,1061,1056,33,-1,1059,1064,688,-1,688,204,1059,-1,1484,1422,1062,-1,1062,1061,1484,-1,1064,1063,1423,-1,1423,1487,1064,-1,1471,450,44,-1,44,1474,1471,-1,1475,211,690,-1,690,1472,1475,-1,1474,44,34,-1,34,1055,1474,-1,1060,203,211,-1,211,1475,1060,-1,1482,1452,1424,-1,1424,1485,1482,-1,1486,1425,1453,-1,1453,1483,1486,-1,1488,1489,1490,-1,1490,1491,1488,-1,1492,1493,1494,-1,1495,1496,1497,-1,1492,1498,1493,-1,1496,1498,1497,-1,1498,1492,1499,-1,1499,1497,1498,-1,1500,1501,1502,-1,1503,1501,1500,-1,1498,1504,1493,-1,1496,1504,1498,-1,1505,1506,1504,-1,1504,1507,1505,-1,1505,1500,1508,-1,1509,1500,1505,-1,1510,1511,1512,-1,1512,1511,1513,-1,1514,1515,1516,-1,1517,1518,1514,-1,1519,1520,1521,-1,1522,1523,1524,-1,1525,1526,1527,-1,1528,1529,1530,-1,1531,1532,1533,-1,1534,1535,1536,-1,1537,1533,1538,-1,1539,1534,1540,-1,1541,1542,1543,-1,1544,1545,1546,-1,1547,1489,1488,-1,1488,1491,1548,-1,1549,1550,1489,-1,1491,1551,1552,-1,1553,1554,1555,-1,1556,1557,1558,-1,1559,1560,1561,-1,1562,1563,1564,-1,1565,1566,1567,-1,1568,1569,1570,-1,1571,1572,1573,-1,1574,1575,1576,-1,1577,1578,1579,-1,1580,1581,1582,-1,1583,1566,1584,-1,1585,1569,1586,-1,1587,1588,1589,-1,1590,1591,1592,-1,1593,1492,1594,-1,1595,1497,1596,-1,1597,1598,1599,-1,1600,1601,1602,-1,1603,1329,1297,-1,1298,1330,1604,-1,1389,968,1605,-1,1606,969,1390,-1,1607,1608,1609,-1,1610,1611,1612,-1,1613,1614,1615,-1,1616,1617,1618,-1,1597,1599,1609,-1,1610,1600,1602,-1,1619,1589,1365,-1,1366,1590,1620,-1,1391,1365,1354,-1,1355,1366,1392,-1,1621,1622,1623,-1,1624,1625,1626,-1,1615,1627,1613,-1,1618,1628,1616,-1,1629,1630,1631,-1,1632,1633,1634,-1,1635,1636,1637,-1,1638,1639,1640,-1,1641,1642,1643,-1,1644,1645,1646,-1,1647,1648,1649,-1,1650,1651,1652,-1,1653,1654,1655,-1,1656,1657,1658,-1,1659,1660,1661,-1,1662,1663,1664,-1,1665,1666,1667,-1,1668,1669,1670,-1,1671,1672,1673,-1,1674,1675,1676,-1,1677,1678,1679,-1,1680,1681,1682,-1,1679,1683,1677,-1,1682,1684,1680,-1,1685,1686,1687,-1,1688,1689,1690,-1,1691,1692,1693,-1,1694,1695,1696,-1,1697,1698,1699,-1,1700,1701,1702,-1,1703,1691,1693,-1,1694,1696,1704,-1,1619,1365,1698,-1,1701,1366,1620,-1,1705,1706,1707,-1,1708,1709,1710,-1,1711,915,1712,-1,1713,920,1714,-1,1711,1712,1715,-1,1716,1713,1714,-1,1715,1717,1711,-1,1714,1718,1716,-1,1719,1706,1717,-1,1718,1709,1720,-1,1721,1722,1723,-1,1724,1725,1726,-1,1727,1728,1729,-1,1730,1731,1732,-1,1711,1717,1706,-1,1709,1718,1714,-1,1733,1734,1653,-1,1658,1735,1736,-1,1737,1738,1739,-1,1740,1741,1742,-1,1743,1744,1745,-1,1746,1747,1748,-1,1749,1750,1641,-1,1646,1751,1752,-1,1631,1753,1754,-1,1755,1756,1632,-1,1757,1758,1759,-1,1759,1760,1757,-1,1760,1761,1762,-1,1762,1757,1760,-1,1763,1550,1758,-1,1758,1757,1763,-1,1757,1762,1551,-1,1551,1763,1757,-1,1764,1765,1766,-1,1766,1767,1764,-1,1767,1766,1768,-1,1768,1769,1767,-1,1765,1547,1488,-1,1488,1766,1765,-1,1766,1488,1548,-1,1548,1768,1766,-1,1763,1490,1489,-1,1489,1550,1763,-1,1551,1491,1490,-1,1490,1763,1551,-1,1502,1501,1514,-1,1514,1516,1502,-1,1517,1514,1501,-1,1501,1503,1517,-1,1770,1511,1510,-1,1510,1771,1770,-1,1772,1513,1511,-1,1511,1770,1772,-1,1773,1774,1775,-1,1775,1776,1773,-1,1777,1778,1774,-1,1774,1773,1777,-1,1073,1773,1776,-1,1776,1074,1073,-1,1077,1777,1773,-1,1773,1073,1077,-1,1779,1780,1566,-1,1566,1583,1779,-1,1586,1569,1780,-1,1780,1779,1586,-1,1781,1106,1107,-1,1107,1567,1781,-1,1568,1108,1106,-1,1106,1781,1568,-1,1782,1783,1784,-1,1784,1785,1782,-1,1785,1784,1786,-1,1786,1787,1785,-1,1783,1788,1789,-1,1789,1784,1783,-1,1784,1789,1790,-1,1790,1786,1784,-1,1788,1764,1767,-1,1767,1789,1788,-1,1789,1767,1769,-1,1769,1790,1789,-1,1499,1492,1593,-1,1593,1791,1499,-1,1791,1596,1497,-1,1497,1499,1791,-1,1791,1593,1792,-1,1792,1793,1791,-1,1793,1794,1596,-1,1596,1791,1793,-1,1793,1792,1795,-1,1795,1796,1793,-1,1796,1797,1794,-1,1794,1793,1796,-1,1796,1795,1798,-1,1798,1512,1796,-1,1512,1799,1797,-1,1797,1796,1512,-1,1567,1566,1780,-1,1780,1781,1567,-1,1781,1780,1569,-1,1569,1568,1781,-1,1583,1782,1785,-1,1785,1779,1583,-1,1779,1785,1787,-1,1787,1586,1779,-1,1771,1775,1774,-1,1774,1770,1771,-1,1770,1774,1778,-1,1778,1772,1770,-1,1800,1801,1802,-1,1802,1803,1800,-1,1804,1805,1806,-1,1806,1807,1804,-1,1808,1508,1803,-1,1803,1802,1808,-1,1805,1804,1509,-1,1509,1809,1805,-1,1801,1810,1541,-1,1541,1802,1801,-1,1805,1546,1811,-1,1811,1806,1805,-1,1801,1800,1812,-1,1812,1813,1801,-1,1814,1815,1807,-1,1807,1806,1814,-1,1803,1502,1516,-1,1516,1800,1803,-1,1807,1517,1503,-1,1503,1804,1807,-1,1800,1516,1515,-1,1515,1812,1800,-1,1815,1518,1517,-1,1517,1807,1815,-1,1521,1816,1817,-1,1817,1519,1521,-1,1524,1818,1819,-1,1819,1522,1524,-1,1820,1821,1519,-1,1519,1817,1820,-1,1818,1524,1822,-1,1822,1823,1818,-1,1817,1816,1824,-1,1824,1825,1817,-1,1826,1827,1819,-1,1819,1818,1826,-1,1527,1526,1828,-1,1828,1542,1527,-1,1545,1829,1529,-1,1529,1528,1545,-1,1526,1525,1830,-1,1830,1831,1526,-1,1832,1833,1530,-1,1530,1529,1832,-1,1527,1810,1834,-1,1834,1525,1527,-1,1530,1835,1811,-1,1811,1528,1530,-1,1493,1504,1506,-1,1506,1836,1493,-1,1837,1507,1504,-1,1504,1496,1837,-1,1808,1543,1836,-1,1836,1506,1808,-1,1507,1837,1544,-1,1544,1809,1507,-1,1836,1838,1494,-1,1494,1493,1836,-1,1496,1495,1839,-1,1839,1837,1496,-1,1494,1838,1542,-1,1542,1828,1494,-1,1829,1545,1839,-1,1839,1495,1829,-1,1840,1828,1526,-1,1526,1831,1840,-1,1832,1529,1829,-1,1829,1841,1832,-1,1810,1527,1542,-1,1542,1541,1810,-1,1546,1545,1528,-1,1528,1811,1546,-1,1842,1843,1844,-1,1844,1845,1842,-1,1846,1847,1848,-1,1848,1849,1846,-1,1820,1850,1845,-1,1845,1844,1820,-1,1847,1846,1851,-1,1851,1823,1847,-1,1843,1852,1853,-1,1853,1844,1843,-1,1847,1854,1855,-1,1855,1848,1847,-1,1843,1842,1856,-1,1856,1553,1843,-1,1558,1857,1849,-1,1849,1848,1558,-1,1852,1840,1831,-1,1831,1853,1852,-1,1854,1832,1841,-1,1841,1855,1854,-1,1830,1821,1853,-1,1853,1831,1830,-1,1832,1854,1822,-1,1822,1833,1832,-1,1840,1852,1555,-1,1555,1858,1840,-1,1859,1556,1855,-1,1855,1841,1859,-1,1828,1840,1858,-1,1858,1494,1828,-1,1495,1859,1841,-1,1841,1829,1495,-1,1753,1631,1860,-1,1860,1861,1753,-1,1862,1863,1632,-1,1632,1756,1862,-1,1753,1861,1532,-1,1532,1531,1753,-1,1536,1535,1862,-1,1862,1756,1536,-1,1538,1533,1532,-1,1532,1864,1538,-1,1865,1535,1534,-1,1534,1539,1865,-1,1864,1866,1867,-1,1867,1538,1864,-1,1539,1868,1869,-1,1869,1865,1539,-1,1870,1871,1825,-1,1825,1824,1870,-1,1827,1826,1872,-1,1872,1873,1827,-1,1871,1874,1850,-1,1850,1825,1871,-1,1826,1851,1875,-1,1875,1872,1826,-1,1870,1876,1877,-1,1877,1871,1870,-1,1872,1878,1879,-1,1879,1873,1872,-1,1820,1817,1825,-1,1825,1850,1820,-1,1851,1826,1818,-1,1818,1823,1851,-1,1880,1881,1643,-1,1643,1882,1880,-1,1883,1644,1884,-1,1884,1885,1883,-1,1537,1547,1886,-1,1886,1533,1537,-1,1534,1887,1548,-1,1548,1540,1534,-1,1547,1765,1888,-1,1888,1886,1547,-1,1887,1889,1768,-1,1768,1548,1887,-1,1549,1489,1547,-1,1547,1537,1549,-1,1540,1548,1491,-1,1491,1552,1540,-1,1867,1549,1537,-1,1537,1538,1867,-1,1539,1540,1552,-1,1552,1868,1539,-1,1758,1867,1866,-1,1866,1759,1758,-1,1761,1869,1868,-1,1868,1762,1761,-1,1549,1867,1758,-1,1758,1550,1549,-1,1551,1762,1868,-1,1868,1552,1551,-1,1838,1836,1543,-1,1543,1542,1838,-1,1545,1544,1837,-1,1837,1839,1545,-1,1765,1764,1890,-1,1890,1888,1765,-1,1889,1891,1769,-1,1769,1768,1889,-1,1788,1892,1890,-1,1890,1764,1788,-1,1769,1891,1893,-1,1893,1790,1769,-1,1876,1882,1643,-1,1643,1877,1876,-1,1878,1644,1883,-1,1883,1879,1878,-1,1494,1858,1894,-1,1894,1492,1494,-1,1497,1895,1859,-1,1859,1495,1497,-1,1492,1894,1896,-1,1896,1594,1492,-1,1595,1897,1895,-1,1895,1497,1595,-1,1858,1555,1554,-1,1554,1894,1858,-1,1895,1557,1556,-1,1556,1859,1895,-1,1894,1554,1898,-1,1898,1896,1894,-1,1897,1899,1557,-1,1557,1895,1897,-1,1830,1525,1900,-1,1900,1520,1830,-1,1523,1901,1530,-1,1530,1833,1523,-1,1821,1820,1844,-1,1844,1853,1821,-1,1854,1847,1823,-1,1823,1822,1854,-1,1520,1519,1821,-1,1821,1830,1520,-1,1833,1822,1524,-1,1524,1523,1833,-1,1852,1843,1553,-1,1553,1555,1852,-1,1556,1558,1848,-1,1848,1855,1556,-1,1802,1541,1543,-1,1543,1808,1802,-1,1809,1544,1546,-1,1546,1805,1809,-1,1506,1505,1508,-1,1508,1808,1506,-1,1809,1509,1505,-1,1505,1507,1809,-1,1508,1500,1502,-1,1502,1803,1508,-1,1804,1503,1500,-1,1500,1509,1804,-1,1813,1834,1810,-1,1810,1801,1813,-1,1806,1811,1835,-1,1835,1814,1806,-1,1571,1902,1903,-1,1903,1904,1571,-1,1905,1906,1907,-1,1907,1576,1905,-1,1561,1908,1597,-1,1597,1909,1561,-1,1910,1602,1911,-1,1911,1562,1910,-1,1908,1561,1560,-1,1560,1661,1908,-1,1662,1563,1562,-1,1562,1911,1662,-1,1912,1667,1661,-1,1661,1560,1912,-1,1563,1662,1668,-1,1668,1913,1563,-1,1512,1798,1914,-1,1914,1510,1512,-1,1513,1915,1799,-1,1799,1512,1513,-1,1771,1510,1914,-1,1914,1916,1771,-1,1917,1915,1513,-1,1513,1772,1917,-1,1775,1918,1919,-1,1919,1776,1775,-1,1777,1920,1921,-1,1921,1778,1777,-1,1776,1919,1225,-1,1225,1074,1776,-1,1077,1228,1920,-1,1920,1777,1077,-1,1391,1334,1922,-1,1922,1365,1391,-1,1366,1923,1335,-1,1335,1392,1366,-1,1924,1925,1667,-1,1667,1912,1924,-1,1913,1668,1926,-1,1926,1927,1913,-1,1928,1912,1560,-1,1560,1559,1928,-1,1564,1563,1913,-1,1913,1929,1564,-1,1930,1924,1912,-1,1912,1928,1930,-1,1929,1913,1927,-1,1927,1931,1929,-1,1928,1559,1932,-1,1932,1933,1928,-1,1934,1935,1564,-1,1564,1929,1934,-1,1223,882,1579,-1,1579,1936,1223,-1,1937,1580,883,-1,883,1224,1937,-1,1565,1567,1107,-1,1107,1223,1565,-1,1224,1108,1568,-1,1568,1570,1224,-1,1936,1938,1565,-1,1565,1223,1936,-1,1224,1570,1939,-1,1939,1937,1224,-1,1579,882,1221,-1,1221,1577,1579,-1,1582,1222,883,-1,883,1580,1582,-1,1303,1305,1940,-1,1940,1941,1303,-1,1942,1943,1306,-1,1306,1304,1942,-1,1940,1305,1307,-1,1307,1944,1940,-1,1945,1308,1306,-1,1306,1943,1945,-1,1307,1309,1946,-1,1946,1944,1307,-1,1945,1947,1310,-1,1310,1308,1945,-1,1946,1309,916,-1,916,1948,1946,-1,1949,919,1310,-1,1310,1947,1949,-1,1950,1951,1952,-1,1952,1953,1950,-1,1954,1955,1956,-1,1956,1957,1954,-1,1958,1953,1952,-1,1952,1959,1958,-1,1960,1955,1954,-1,1954,1961,1960,-1,1962,1963,1952,-1,1952,1951,1962,-1,1956,1955,1964,-1,1964,1965,1956,-1,1950,1966,1967,-1,1967,1951,1950,-1,1956,1968,1969,-1,1969,1957,1956,-1,1936,1950,1953,-1,1953,1938,1936,-1,1939,1954,1957,-1,1957,1937,1939,-1,1622,1902,1970,-1,1970,1966,1622,-1,1969,1971,1907,-1,1907,1625,1969,-1,1970,1972,1967,-1,1967,1966,1970,-1,1969,1968,1973,-1,1973,1971,1969,-1,1972,1970,1902,-1,1902,1571,1972,-1,1576,1907,1971,-1,1971,1973,1576,-1,1903,1902,1622,-1,1622,1621,1903,-1,1626,1625,1907,-1,1907,1906,1626,-1,1950,1623,1622,-1,1622,1966,1950,-1,1969,1625,1624,-1,1624,1957,1969,-1,1972,1571,1573,-1,1573,1974,1972,-1,1975,1574,1576,-1,1576,1973,1975,-1,1972,1974,1976,-1,1976,1967,1972,-1,1968,1977,1975,-1,1975,1973,1968,-1,1566,1565,1938,-1,1938,1584,1566,-1,1585,1939,1570,-1,1570,1569,1585,-1,1963,1978,1890,-1,1890,1892,1963,-1,1893,1891,1979,-1,1979,1964,1893,-1,1788,1783,1959,-1,1959,1892,1788,-1,1893,1960,1786,-1,1786,1790,1893,-1,1959,1952,1963,-1,1963,1892,1959,-1,1893,1964,1955,-1,1955,1960,1893,-1,1959,1783,1782,-1,1782,1958,1959,-1,1961,1787,1786,-1,1786,1960,1961,-1,1584,1958,1782,-1,1782,1583,1584,-1,1586,1787,1961,-1,1961,1585,1586,-1,1962,1980,1978,-1,1978,1963,1962,-1,1964,1979,1981,-1,1981,1965,1964,-1,1951,1967,1976,-1,1976,1962,1951,-1,1965,1977,1968,-1,1968,1956,1965,-1,1974,1982,1983,-1,1983,1976,1974,-1,1977,1984,1985,-1,1985,1975,1977,-1,1986,1337,1329,-1,1329,1603,1986,-1,1604,1330,1338,-1,1338,1987,1604,-1,1350,1349,1588,-1,1588,1373,1350,-1,1374,1591,1352,-1,1352,1351,1374,-1,1712,1377,1988,-1,1988,1715,1712,-1,1716,1989,1380,-1,1380,1713,1716,-1,1990,1988,1371,-1,1371,1587,1990,-1,1592,1376,1989,-1,1989,1991,1592,-1,1988,1377,1372,-1,1372,1371,1988,-1,1376,1375,1380,-1,1380,1989,1376,-1,1594,1896,1992,-1,1992,1993,1594,-1,1994,1995,1897,-1,1897,1595,1994,-1,1896,1898,1996,-1,1996,1992,1896,-1,1995,1997,1899,-1,1899,1897,1995,-1,1993,1792,1593,-1,1593,1594,1993,-1,1595,1596,1794,-1,1794,1994,1595,-1,1993,1992,1930,-1,1930,1998,1993,-1,1999,1931,1995,-1,1995,1994,1999,-1,1992,1996,1924,-1,1924,1930,1992,-1,1931,1927,1997,-1,1997,1995,1931,-1,1996,1728,1925,-1,1925,1924,1996,-1,1927,1926,1731,-1,1731,1997,1927,-1,1998,1795,1792,-1,1792,1993,1998,-1,1994,1794,1797,-1,1797,1999,1994,-1,1998,1930,1928,-1,1928,1933,1998,-1,1934,1929,1931,-1,1931,1999,1934,-1,1798,1933,1932,-1,1932,1914,1798,-1,1915,1935,1934,-1,1934,1799,1915,-1,1559,1561,1909,-1,1909,1932,1559,-1,1935,1910,1562,-1,1562,1564,1935,-1,1909,1608,1914,-1,1914,1932,1909,-1,1935,1915,1611,-1,1611,1910,1935,-1,1609,1608,1909,-1,1909,1597,1609,-1,1602,1910,1611,-1,1611,1610,1602,-1,1599,1598,2000,-1,2000,2001,1599,-1,2002,2003,1601,-1,1601,1600,2002,-1,2001,2000,1389,-1,1389,1605,2001,-1,1606,1390,2003,-1,2003,2002,1606,-1,1609,1599,2001,-1,2001,1607,1609,-1,1612,2002,1600,-1,1600,1610,1612,-1,1603,2000,2004,-1,2004,1986,1603,-1,1987,2005,2003,-1,2003,1604,1987,-1,1297,1389,2000,-1,2000,1603,1297,-1,1604,2003,1390,-1,1390,1298,1604,-1,1627,2001,1605,-1,1605,2006,1627,-1,2007,1606,2002,-1,2002,1628,2007,-1,1916,1914,1608,-1,1608,1614,1916,-1,1617,1611,1915,-1,1915,1917,1617,-1,1916,1918,1775,-1,1775,1771,1916,-1,1772,1778,1921,-1,1921,1917,1772,-1,1615,1614,1608,-1,1608,1607,1615,-1,1612,1611,1617,-1,1617,1616,1612,-1,1607,2001,1627,-1,1627,1615,1607,-1,1616,1628,2002,-1,2002,1612,1616,-1,1918,1613,2008,-1,2008,1919,1918,-1,1920,2009,1618,-1,1618,1921,1920,-1,1919,2008,1385,-1,1385,1225,1919,-1,1228,1388,2009,-1,2009,1920,1228,-1,2006,2008,1613,-1,1613,1627,2006,-1,1628,1618,2009,-1,2009,2007,1628,-1,1614,1613,1918,-1,1918,1916,1614,-1,1917,1921,1618,-1,1618,1617,1917,-1,967,2006,1605,-1,1605,968,967,-1,969,1606,2007,-1,2007,970,969,-1,2008,2006,967,-1,967,1385,2008,-1,1388,970,2007,-1,2007,2009,1388,-1,1933,1798,1795,-1,1795,1998,1933,-1,1999,1797,1799,-1,1799,1934,1999,-1,915,927,1377,-1,1377,1712,915,-1,1713,1380,928,-1,928,920,1713,-1,1373,1588,1587,-1,1587,1371,1373,-1,1376,1592,1591,-1,1591,1374,1376,-1,1588,1349,1365,-1,1365,1589,1588,-1,1590,1366,1352,-1,1352,1591,1590,-1,1623,1579,1578,-1,1578,1621,1623,-1,1626,1581,1580,-1,1580,1624,1626,-1,1579,1623,1950,-1,1950,1936,1579,-1,1937,1957,1624,-1,1624,1580,1937,-1,1976,1983,1980,-1,1980,1962,1976,-1,1965,1981,1984,-1,1984,1977,1965,-1,1938,1953,1958,-1,1958,1584,1938,-1,1585,1961,1954,-1,1954,1939,1585,-1,2010,1842,1845,-1,1845,1648,2010,-1,1651,1846,1849,-1,1849,2011,1651,-1,1631,1630,2012,-1,2012,1860,1631,-1,1863,2013,1633,-1,1633,1632,1863,-1,1881,1880,2012,-1,2012,1630,1881,-1,1633,2013,1885,-1,1885,1884,1633,-1,1631,1754,2014,-1,2014,1629,1631,-1,1634,2015,1755,-1,1755,1632,1634,-1,1749,1881,1630,-1,1630,2016,1749,-1,2017,1633,1884,-1,1884,1752,2017,-1,2014,1754,1637,-1,1637,1636,2014,-1,1639,1638,1755,-1,1755,2015,1639,-1,2018,2019,1636,-1,1636,1635,2018,-1,1640,1639,2020,-1,2020,2021,1640,-1,2022,2023,2019,-1,2019,2018,2022,-1,2021,2020,2024,-1,2024,2025,2021,-1,1871,1877,2026,-1,2026,1874,1871,-1,1875,2027,1878,-1,1878,1872,1875,-1,1877,1643,1642,-1,1642,2026,1877,-1,2027,1645,1644,-1,1644,1878,2027,-1,1881,1749,1641,-1,1641,1643,1881,-1,1644,1646,1752,-1,1752,1884,1644,-1,1553,1856,2028,-1,2028,1554,1553,-1,1557,2029,1857,-1,1857,1558,1557,-1,1554,2028,1729,-1,1729,1898,1554,-1,1899,1730,2029,-1,2029,1557,1899,-1,1874,1648,1845,-1,1845,1850,1874,-1,1851,1846,1651,-1,1651,1875,1851,-1,1842,2010,2030,-1,2030,1856,1842,-1,1857,2031,2011,-1,2011,1849,1857,-1,2026,1649,1648,-1,1648,1874,2026,-1,1875,1651,1650,-1,1650,2027,1875,-1,1630,1629,2032,-1,2032,2016,1630,-1,2017,2033,1634,-1,1634,1633,2017,-1,2034,2014,1636,-1,1636,2035,2034,-1,2036,1639,2015,-1,2015,2037,2036,-1,1745,2038,2019,-1,2019,2023,1745,-1,2024,2020,2039,-1,2039,1746,2024,-1,2040,1739,1743,-1,1743,2041,2040,-1,2042,1748,1740,-1,1740,2043,2042,-1,2035,1636,2019,-1,2019,2038,2035,-1,2039,2020,1639,-1,1639,2036,2039,-1,2032,1629,2014,-1,2014,2034,2032,-1,2037,2015,1634,-1,1634,2033,2037,-1,1745,2023,2041,-1,2041,1743,1745,-1,1748,2042,2024,-1,2024,1746,1748,-1,2023,2022,2044,-1,2044,2041,2023,-1,2042,2045,2025,-1,2025,2024,2042,-1,1655,1654,2046,-1,2046,2047,1655,-1,2048,2049,1657,-1,1657,1656,2048,-1,1621,1578,1654,-1,1654,1653,1621,-1,1658,1657,1581,-1,1581,1626,1658,-1,1655,2050,1733,-1,1733,1653,1655,-1,1658,1736,2051,-1,2051,1656,1658,-1,2052,1904,1903,-1,1903,1734,2052,-1,1735,1906,1905,-1,1905,2053,1735,-1,1903,1621,1653,-1,1653,1734,1903,-1,1735,1658,1626,-1,1626,1906,1735,-1,2054,1904,2052,-1,2052,1673,2054,-1,1674,2053,1905,-1,1905,2055,1674,-1,1733,2056,2052,-1,2052,1734,1733,-1,1735,2053,2057,-1,2057,1736,1735,-1,2058,2059,1597,-1,1597,1908,2058,-1,1911,1602,2060,-1,2060,2061,1911,-1,1598,1597,2059,-1,2059,2062,1598,-1,2063,2060,1602,-1,1602,1601,2063,-1,1660,2058,1908,-1,1908,1661,1660,-1,1662,1911,2061,-1,2061,1663,1662,-1,1666,1659,1661,-1,1661,1667,1666,-1,1668,1662,1664,-1,1664,1669,1668,-1,2064,1665,1667,-1,1667,1925,2064,-1,1926,1668,1670,-1,1670,2065,1926,-1,1672,2066,2054,-1,2054,1673,1672,-1,1674,2055,2067,-1,2067,1675,1674,-1,2068,1572,2054,-1,2054,2066,2068,-1,2067,2055,1575,-1,1575,2069,2067,-1,2070,2071,2072,-1,2072,2073,2070,-1,2074,2075,2076,-1,2076,2077,2074,-1,1571,1904,2054,-1,2054,1572,1571,-1,1575,2055,1905,-1,1905,1576,1575,-1,1573,1572,2068,-1,2068,2078,1573,-1,2079,2069,1575,-1,1575,1574,2079,-1,2080,2081,2073,-1,2073,2072,2080,-1,2075,2074,2082,-1,2082,2083,2075,-1,1679,1678,2084,-1,2084,1692,1679,-1,1695,2085,1681,-1,1681,1680,1695,-1,1686,2086,2087,-1,2087,1687,1686,-1,1688,2088,2089,-1,2089,1689,1688,-1,1679,1687,2087,-1,2087,1683,1679,-1,1684,2088,1688,-1,1688,1680,1684,-1,2090,2087,2086,-1,2086,2091,2090,-1,2092,2089,2088,-1,2088,2093,2092,-1,2086,1686,1337,-1,1337,1986,2086,-1,1987,1338,1689,-1,1689,2089,1987,-1,2094,2095,1723,-1,1723,2096,2094,-1,2097,1724,2098,-1,2098,2099,2097,-1,2100,2096,1723,-1,1723,1722,2100,-1,1725,1724,2097,-1,2097,2101,1725,-1,2095,2094,2084,-1,2084,2102,2095,-1,2103,2085,2099,-1,2099,2098,2103,-1,2104,1693,2094,-1,2094,2096,2104,-1,2097,2099,1694,-1,1694,2105,2097,-1,2094,1693,1692,-1,1692,2084,2094,-1,2085,1695,1694,-1,1694,2099,2085,-1,2100,1722,2106,-1,2106,2107,2100,-1,2108,2109,1725,-1,1725,2101,2108,-1,2107,2106,2110,-1,2110,2111,2107,-1,2112,2113,2109,-1,2109,2108,2112,-1,1722,1721,2114,-1,2114,2106,1722,-1,2109,2115,1726,-1,1726,1725,2109,-1,1697,2100,2107,-1,2107,1698,1697,-1,1701,2108,2101,-1,2101,1702,1701,-1,1698,2107,2111,-1,2111,1619,1698,-1,1620,2112,2108,-1,2108,1701,1620,-1,1697,2104,2096,-1,2096,2100,1697,-1,2101,2097,2105,-1,2105,1702,2101,-1,1703,1685,1687,-1,1687,1691,1703,-1,1696,1688,1690,-1,1690,1704,1696,-1,2116,1703,1693,-1,1693,2104,2116,-1,2105,1694,1704,-1,1704,2117,2105,-1,1698,1365,1922,-1,1922,1699,1698,-1,1700,1923,1366,-1,1366,1701,1700,-1,2104,1697,1699,-1,1699,2116,2104,-1,2117,1700,1702,-1,1702,2105,2117,-1,1692,1691,1687,-1,1687,1679,1692,-1,1680,1688,1696,-1,1696,1695,1680,-1,1685,1703,2116,-1,2116,2118,1685,-1,2119,2117,1704,-1,1704,1690,2119,-1,1699,1922,2118,-1,2118,2116,1699,-1,2117,2119,1923,-1,1923,1700,2117,-1,1334,1333,2118,-1,2118,1922,1334,-1,1923,2119,1336,-1,1336,1335,1923,-1,1719,2110,1707,-1,1707,1706,1719,-1,1709,1708,2113,-1,2113,1720,1709,-1,2120,2121,1706,-1,1706,1705,2120,-1,1710,1709,2122,-1,2122,2123,1710,-1,2110,1719,2124,-1,2124,2111,2110,-1,2112,2125,1720,-1,1720,2113,2112,-1,2110,2106,2114,-1,2114,1707,2110,-1,1708,2115,2109,-1,2109,2113,1708,-1,2111,2124,1589,-1,1589,1619,2111,-1,1620,1590,2125,-1,2125,2112,1620,-1,1577,1221,1295,-1,1295,2126,1577,-1,2127,1296,1222,-1,1222,1582,2127,-1,2126,1295,1301,-1,1301,2128,2126,-1,2129,1302,1296,-1,1296,2127,2129,-1,2126,1654,1578,-1,1578,1577,2126,-1,1582,1581,1657,-1,1657,2127,1582,-1,2130,2131,2047,-1,2047,2046,2130,-1,2049,2048,2132,-1,2132,2133,2049,-1,2131,2130,2134,-1,2134,2135,2131,-1,2136,2137,2133,-1,2133,2132,2136,-1,1941,2130,2046,-1,2046,2128,1941,-1,2129,2049,2133,-1,2133,1942,2129,-1,2128,1301,1303,-1,1303,1941,2128,-1,1942,1304,1302,-1,1302,2129,1942,-1,2128,2046,1654,-1,1654,2126,2128,-1,2127,1657,2049,-1,2049,2129,2127,-1,2135,2134,2138,-1,2138,2139,2135,-1,2140,2141,2137,-1,2137,2136,2140,-1,2139,2138,2142,-1,2142,2143,2139,-1,2144,2145,2141,-1,2141,2140,2144,-1,1944,2138,2134,-1,2134,1940,1944,-1,1943,2137,2141,-1,2141,1945,1943,-1,2143,2142,2121,-1,2121,2120,2143,-1,2123,2122,2145,-1,2145,2144,2123,-1,2121,2142,1946,-1,1946,1948,2121,-1,1949,1947,2145,-1,2145,2122,1949,-1,1711,1948,916,-1,916,915,1711,-1,920,919,1949,-1,1949,1714,920,-1,2078,1982,1974,-1,1974,1573,2078,-1,1574,1975,1985,-1,1985,2079,1574,-1,1673,2052,2056,-1,2056,1671,1673,-1,1676,2057,2053,-1,2053,1674,1676,-1,2146,2147,2148,-1,2148,2149,2146,-1,2150,2151,2152,-1,2152,2153,2150,-1,2154,2155,2071,-1,2071,2070,2154,-1,2077,2076,2156,-1,2156,2157,2077,-1,2158,2159,2155,-1,2155,2154,2158,-1,2157,2156,2160,-1,2160,2161,2157,-1,1686,1333,1325,-1,1325,1337,1686,-1,1338,1328,1336,-1,1336,1689,1338,-1,1986,2004,2091,-1,2091,2086,1986,-1,2089,2092,2005,-1,2005,1987,2089,-1,2062,2059,2162,-1,2162,2163,2062,-1,2164,2165,2060,-1,2060,2063,2164,-1,1711,1706,2121,-1,2121,1948,1711,-1,1949,2122,1709,-1,1709,1714,1949,-1,1990,2124,1719,-1,1719,1717,1990,-1,1718,1720,2125,-1,2125,1991,1718,-1,2124,1990,1587,-1,1587,1589,2124,-1,1590,1592,1991,-1,1991,2125,1590,-1,1988,1990,1717,-1,1717,1715,1988,-1,1716,1718,1991,-1,1991,1989,1716,-1,1685,2118,1333,-1,1333,1686,1685,-1,1689,1336,2119,-1,2119,1690,1689,-1,1898,1729,1728,-1,1728,1996,1898,-1,1997,1731,1730,-1,1730,1899,1997,-1,2064,1925,1728,-1,1728,1727,2064,-1,1732,1731,1926,-1,1926,2065,1732,-1,1598,2062,2004,-1,2004,2000,1598,-1,2003,2005,2063,-1,2063,1601,2003,-1,2004,2062,2163,-1,2163,2091,2004,-1,2092,2164,2063,-1,2063,2005,2092,-1,1944,1946,2142,-1,2142,2138,1944,-1,2141,2145,1947,-1,1947,1945,2141,-1,2081,2080,2147,-1,2147,2146,2081,-1,2153,2152,2083,-1,2083,2082,2153,-1,2148,2166,2167,-1,2167,2149,2148,-1,2150,2168,2169,-1,2169,2151,2150,-1,2166,2040,2170,-1,2170,2167,2166,-1,2168,2171,2043,-1,2043,2169,2168,-1,2170,2040,2041,-1,2041,2044,2170,-1,2045,2042,2043,-1,2043,2171,2045,-1,2166,1737,1739,-1,1739,2040,2166,-1,2043,1740,1742,-1,1742,2169,2043,-1,1941,1940,2134,-1,2134,2130,1941,-1,2133,2137,1943,-1,1943,1942,2133,-1,1739,1738,1744,-1,1744,1743,1739,-1,1748,1747,1741,-1,1741,1740,1748,-1,1745,1744,2172,-1,2172,2038,1745,-1,2039,2173,1747,-1,1747,1746,2039,-1,2016,2174,1750,-1,1750,1749,2016,-1,1752,1751,2175,-1,2175,2017,1752,-1,1754,1753,1531,-1,1531,1637,1754,-1,1638,1536,1756,-1,1756,1755,1638,-1,1637,1531,1533,-1,1640,1887,1534,-1,1635,1886,1888,-1,1888,2018,1635,-1,2021,1889,1887,-1,1887,1640,2021,-1,2018,1888,1890,-1,1890,2022,2018,-1,2025,1891,1889,-1,1889,2021,2025,-1,2022,1890,1978,-1,1978,2044,2022,-1,2045,1979,1891,-1,1891,2025,2045,-1,2044,1978,1980,-1,1980,2170,2044,-1,2171,1981,1979,-1,1979,2045,2171,-1,2170,1980,1983,-1,1983,2167,2170,-1,2168,1984,1981,-1,1981,2171,2168,-1,2167,1983,1982,-1,1982,2149,2167,-1,2150,1985,1984,-1,1984,2168,2150,-1,2149,1982,2078,-1,2078,2146,2149,-1,2153,2079,1985,-1,1985,2150,2153,-1,2146,2078,2068,-1,2068,2081,2146,-1,2082,2069,2079,-1,2079,2153,2082,-1,2081,2068,2066,-1,2066,2073,2081,-1,2074,2067,2069,-1,2069,2082,2074,-1,2073,2066,1672,-1,1672,2070,2073,-1,2077,1675,2067,-1,2067,2074,2077,-1,2070,1672,1671,-1,1671,2154,2070,-1,2157,1676,1675,-1,1675,2077,2157,-1,2154,1671,2056,-1,2056,2158,2154,-1,2161,2057,1676,-1,1676,2157,2161,-1,2038,2172,2176,-1,2176,2035,2038,-1,2036,2177,2173,-1,2173,2039,2036,-1,2035,2176,2178,-1,2178,2034,2035,-1,2037,2179,2177,-1,2177,2036,2037,-1,2034,2178,2180,-1,2180,2032,2034,-1,2033,2181,2179,-1,2179,2037,2033,-1,2032,2180,2174,-1,2174,2016,2032,-1,2017,2175,2181,-1,2181,2033,2017,-1,1533,1886,1635,-1,1635,1637,1533,-1,1534,1536,1638,-1,1638,1640,1534,-1,2182,2183,2184,-1,2185,2186,2187,-1,2188,2184,2189,-1,2190,2185,2191,-1,2192,2193,2194,-1,2195,2196,2197,-1,2198,1812,2199,-1,2200,1815,2201,-1,2202,2198,2203,-1,2204,2201,2205,-1,1532,1861,2206,-1,2207,1862,1535,-1,2193,2208,2209,-1,2210,2211,2196,-1,2189,2212,2213,-1,2214,2215,2190,-1,2209,2216,2183,-1,2186,2217,2210,-1,2218,2219,2220,-1,2221,2222,2223,-1,2224,1515,1514,-1,1514,2225,2224,-1,2225,1514,1518,-1,1518,2226,2225,-1,2224,2225,2227,-1,2227,2228,2224,-1,2229,2227,2225,-1,2225,2226,2229,-1,2230,2231,2232,-1,2232,2233,2230,-1,2234,2235,2231,-1,2231,2230,2234,-1,1760,1759,2236,-1,2236,2237,1760,-1,2237,2238,1761,-1,1761,1760,2237,-1,2232,2231,2237,-1,2237,2236,2232,-1,2238,2237,2231,-1,2231,2235,2238,-1,2239,2240,2241,-1,2241,2242,2239,-1,2242,2241,2243,-1,2243,2244,2242,-1,2245,2246,2247,-1,2247,2248,2245,-1,2249,2250,2246,-1,2246,2245,2249,-1,2240,2251,2252,-1,2252,2241,2240,-1,2241,2252,2253,-1,2253,2243,2241,-1,2251,2254,2255,-1,2255,2252,2251,-1,2252,2255,2256,-1,2256,2253,2252,-1,2254,2228,2227,-1,2227,2255,2254,-1,2255,2227,2229,-1,2229,2256,2255,-1,2246,2257,2258,-1,2258,2247,2246,-1,2250,2259,2257,-1,2257,2246,2250,-1,2257,2230,2233,-1,2233,2258,2257,-1,2259,2234,2230,-1,2230,2257,2259,-1,2242,2260,2261,-1,2261,2239,2242,-1,2244,2262,2260,-1,2260,2242,2244,-1,2263,2264,2265,-1,2265,2266,2263,-1,2267,2268,2269,-1,2269,2270,2267,-1,2265,2264,2271,-1,2271,2272,2265,-1,2273,2274,2269,-1,2269,2268,2273,-1,2272,2271,2275,-1,2275,2276,2272,-1,2277,2278,2274,-1,2274,2273,2277,-1,2276,2275,2218,-1,2218,2279,2276,-1,2280,2223,2278,-1,2278,2277,2280,-1,2239,2261,2281,-1,2281,2213,2239,-1,2214,2282,2262,-1,2262,2244,2214,-1,2248,2247,2283,-1,2283,2284,2248,-1,2285,2286,2250,-1,2250,2249,2285,-1,2284,2283,2287,-1,2287,2288,2284,-1,2289,2290,2286,-1,2286,2285,2289,-1,2288,2287,2291,-1,2291,2292,2288,-1,2293,2294,2290,-1,2290,2289,2293,-1,2292,2291,2295,-1,2295,2296,2292,-1,2297,2298,2294,-1,2294,2293,2297,-1,2296,2295,2299,-1,2299,2300,2296,-1,2301,2302,2298,-1,2298,2297,2301,-1,2300,2299,2263,-1,2263,2266,2300,-1,2267,2270,2302,-1,2302,2301,2267,-1,2303,2194,2193,-1,2193,2209,2303,-1,2210,2196,2195,-1,2195,2304,2210,-1,2193,2192,2305,-1,2305,2306,2193,-1,2307,2308,2197,-1,2197,2196,2307,-1,2303,2209,2183,-1,2183,2182,2303,-1,2187,2186,2210,-1,2210,2304,2187,-1,2213,2281,2188,-1,2188,2189,2213,-1,2190,2191,2282,-1,2282,2214,2190,-1,2309,2306,2305,-1,2305,2310,2309,-1,2311,2308,2307,-1,2307,2312,2311,-1,2313,2314,2309,-1,2309,2310,2313,-1,2311,2312,2315,-1,2315,2316,2311,-1,2279,2218,2314,-1,2314,2313,2279,-1,2316,2315,2223,-1,2223,2280,2316,-1,2224,2199,1812,-1,1812,1515,2224,-1,1518,1815,2200,-1,2200,2226,1518,-1,1813,1812,2198,-1,2198,2317,1813,-1,2318,2201,1815,-1,1815,1814,2318,-1,2203,2198,2199,-1,2199,2319,2203,-1,2320,2200,2201,-1,2201,2204,2320,-1,2321,2317,2198,-1,2198,2202,2321,-1,2205,2201,2318,-1,2318,2322,2205,-1,2208,2202,2203,-1,2203,2323,2208,-1,2324,2204,2205,-1,2205,2211,2324,-1,2219,1816,1521,-1,1521,2220,2219,-1,2221,1522,1819,-1,1819,2222,2221,-1,2325,2326,2317,-1,2317,2321,2325,-1,2322,2318,2327,-1,2327,2328,2322,-1,2202,2208,2329,-1,2329,2321,2202,-1,2322,2330,2211,-1,2211,2205,2322,-1,2331,1860,2012,-1,2012,2332,2331,-1,2333,2013,1863,-1,1863,2334,2333,-1,2335,1861,1860,-1,1860,2331,2335,-1,2334,1863,1862,-1,1862,2336,2334,-1,2206,2233,1864,-1,1864,1532,2206,-1,1535,1865,2234,-1,2234,2207,1535,-1,1834,1813,2317,-1,2317,2326,1834,-1,2327,2318,1814,-1,1814,1835,2327,-1,2199,2224,2228,-1,2228,2319,2199,-1,2320,2229,2226,-1,2226,2200,2320,-1,2337,2323,2203,-1,2203,2319,2337,-1,2320,2204,2324,-1,2324,2338,2320,-1,2339,1870,1824,-1,1824,2340,2339,-1,2341,1827,1873,-1,1873,2342,2341,-1,2337,2319,2228,-1,2228,2254,2337,-1,2256,2229,2320,-1,2320,2338,2256,-1,1900,2326,2325,-1,2325,2343,1900,-1,2344,2328,2327,-1,2327,1901,2344,-1,2329,2345,2325,-1,2325,2321,2329,-1,2322,2328,2346,-1,2346,2330,2322,-1,2340,1824,1816,-1,1816,2219,2340,-1,2222,1819,1827,-1,1827,2341,2222,-1,2332,2012,1880,-1,1880,2347,2332,-1,2348,1885,2013,-1,2013,2333,2348,-1,2233,2232,1866,-1,1866,1864,2233,-1,1865,1869,2235,-1,2235,2234,1865,-1,2236,1759,1866,-1,1866,2232,2236,-1,2235,1869,1761,-1,1761,2238,2235,-1,2258,2233,2206,-1,2206,2349,2258,-1,2350,2207,2234,-1,2234,2259,2350,-1,2349,2206,1861,-1,1861,2335,2349,-1,2336,1862,2207,-1,2207,2350,2336,-1,2351,1876,1870,-1,1870,2339,2351,-1,2342,1873,1879,-1,1879,2352,2342,-1,1882,1876,2351,-1,2351,2353,1882,-1,2354,2352,1879,-1,1879,1883,2354,-1,2347,1880,1882,-1,1882,2353,2347,-1,2354,1883,1885,-1,1885,2348,2354,-1,2345,2355,2343,-1,2343,2325,2345,-1,2328,2344,2356,-1,2356,2346,2328,-1,2326,1900,1525,-1,1525,1834,2326,-1,1835,1530,1901,-1,1901,2327,1835,-1,1520,1900,2343,-1,2343,1521,1520,-1,1522,2344,1901,-1,1901,1523,1522,-1,1521,2343,2355,-1,2355,2220,1521,-1,2221,2356,2344,-1,2344,1522,2221,-1,2306,2329,2208,-1,2208,2193,2306,-1,2196,2211,2330,-1,2330,2307,2196,-1,2263,2353,2351,-1,2351,2264,2263,-1,2269,2352,2354,-1,2354,2270,2269,-1,2264,2351,2339,-1,2339,2271,2264,-1,2274,2342,2352,-1,2352,2269,2274,-1,2271,2339,2340,-1,2340,2275,2271,-1,2278,2341,2342,-1,2342,2274,2278,-1,2275,2340,2219,-1,2219,2218,2275,-1,2223,2222,2341,-1,2341,2278,2223,-1,2220,2355,2314,-1,2314,2218,2220,-1,2223,2315,2356,-1,2356,2221,2223,-1,2213,2212,2240,-1,2240,2239,2213,-1,2244,2243,2215,-1,2215,2214,2244,-1,2212,2357,2251,-1,2251,2240,2212,-1,2243,2253,2358,-1,2358,2215,2243,-1,2247,2258,2349,-1,2349,2283,2247,-1,2286,2350,2259,-1,2259,2250,2286,-1,2283,2349,2335,-1,2335,2287,2283,-1,2290,2336,2350,-1,2350,2286,2290,-1,2287,2335,2331,-1,2331,2291,2287,-1,2294,2334,2336,-1,2336,2290,2294,-1,2291,2331,2332,-1,2332,2295,2291,-1,2298,2333,2334,-1,2334,2294,2298,-1,2295,2332,2347,-1,2347,2299,2295,-1,2302,2348,2333,-1,2333,2298,2302,-1,2299,2347,2353,-1,2353,2263,2299,-1,2270,2354,2348,-1,2348,2302,2270,-1,2309,2314,2355,-1,2355,2345,2309,-1,2346,2356,2315,-1,2315,2312,2346,-1,2183,2212,2189,-1,2189,2184,2183,-1,2185,2190,2215,-1,2215,2186,2185,-1,2183,2216,2357,-1,2357,2212,2183,-1,2215,2358,2217,-1,2217,2186,2215,-1,2345,2329,2306,-1,2306,2309,2345,-1,2312,2307,2330,-1,2330,2346,2312,-1,2216,2209,2208,-1,2208,2323,2216,-1,2324,2211,2210,-1,2210,2217,2324,-1,2357,2337,2254,-1,2254,2251,2357,-1,2253,2256,2338,-1,2338,2358,2253,-1,2337,2357,2216,-1,2216,2323,2337,-1,2324,2217,2358,-1,2358,2338,2324,-1,2359,2360,2361,-1,2362,2363,2364,-1,2365,2366,2367,-1,2368,2369,2370,-1,2371,2372,2373,-1,2374,2373,2372,-1,2363,2362,2375,-1,2376,2365,2367,-1,2377,2378,2379,-1,2380,2381,2382,-1,2383,2384,2385,-1,2382,2386,2387,-1,2388,2389,2377,-1,2390,2391,2392,-1,2393,2390,2394,-1,2395,2385,2396,-1,2397,2398,2399,-1,2398,2400,2399,-1,2401,2402,2403,-1,2403,2402,2404,-1,2402,2405,2404,-1,2405,2406,2404,-1,2404,2406,2400,-1,2406,2407,2400,-1,2400,2407,2399,-1,2408,2409,2410,-1,2410,2409,2411,-1,2401,2412,2402,-1,2412,2413,2402,-1,2402,2413,2414,-1,2414,2413,2415,-1,2413,2411,2415,-1,2415,2411,2416,-1,2409,2416,2411,-1,2417,2418,2419,-1,2420,2421,2422,-1,2423,2421,2424,-1,2425,2426,2427,-1,2428,2429,2430,-1,2431,2432,2433,-1,2434,2435,2436,-1,2437,2435,2438,-1,2439,2440,2441,-1,2442,2443,2444,-1,2445,2446,2447,-1,2447,2446,2448,-1,2449,2450,2447,-1,2451,2452,2453,-1,2454,2455,2456,-1,2457,2458,2459,-1,2459,2458,2460,-1,2458,2461,2460,-1,2462,2460,2463,-1,2460,2461,2463,-1,2464,2465,2466,-1,2467,2465,2464,-1,2464,2468,2469,-1,2470,2471,2472,-1,2473,2474,2475,-1,2476,2477,2478,-1,2477,2479,2478,-1,2478,2479,2480,-1,2481,2482,2479,-1,2482,2480,2479,-1,2483,2484,2485,-1,2486,2487,2484,-1,2487,2488,2484,-1,2488,2489,2484,-1,2489,2485,2484,-1,2490,2491,2492,-1,2493,2492,2494,-1,2494,2492,2495,-1,2495,2492,2496,-1,2492,2491,2496,-1,2497,2498,2499,-1,2500,2501,2502,-1,2501,2503,2502,-1,2504,2498,2505,-1,2506,2507,2508,-1,2509,2510,2511,-1,2512,2513,2514,-1,2515,2505,2516,-1,2517,2504,2505,-1,2518,2519,2520,-1,2521,2522,2504,-1,2523,2504,2522,-1,2524,2504,2523,-1,2525,2526,2527,-1,2528,2529,2530,-1,2531,2532,2519,-1,2519,2533,2531,-1,2534,2533,2519,-1,2518,2535,2519,-1,2519,2535,2536,-1,2536,2534,2519,-1,2537,2538,2539,-1,2540,2541,2542,-1,2541,2543,2542,-1,2544,2538,2545,-1,2546,2547,2548,-1,2549,2550,2551,-1,2552,2553,2554,-1,2555,2544,2556,-1,2544,2545,2557,-1,2558,2559,2560,-1,2545,2561,2562,-1,2561,2545,2563,-1,2563,2545,2564,-1,2565,2566,2567,-1,2568,2569,2570,-1,2559,2571,2572,-1,2572,2573,2559,-1,2559,2573,2574,-1,2559,2575,2560,-1,2576,2575,2559,-1,2559,2574,2576,-1,2577,2578,2579,-1,2580,2581,2582,-1,2583,2584,2585,-1,2586,2585,2584,-1,2587,2588,2589,-1,2590,2591,2592,-1,2590,2592,2593,-1,2581,2580,2594,-1,2595,2596,2597,-1,2598,2599,2600,-1,2601,2602,2603,-1,2604,2605,2598,-1,2597,2606,2607,-1,2608,2609,2610,-1,2611,2610,2612,-1,2613,2601,2614,-1,2615,2616,2617,-1,2618,2619,2620,-1,2621,2622,2619,-1,2619,2622,2620,-1,2622,2623,2620,-1,2624,2620,2625,-1,2626,2627,2628,-1,2629,2630,2631,-1,2631,2632,2629,-1,2633,2634,2635,-1,2635,2636,2633,-1,2637,2638,2639,-1,2638,2640,2639,-1,2641,2639,2640,-1,2642,2635,2643,-1,2644,2645,2646,-1,2647,2648,2649,-1,2650,2651,2652,-1,2652,2653,2650,-1,2654,2655,2656,-1,2657,2658,2659,-1,2658,2657,2654,-1,2660,2659,2658,-1,2661,2662,2663,-1,2664,2665,2666,-1,2666,2667,2668,-1,2669,2670,2668,-1,2671,2672,2673,-1,2674,2675,2504,-1,2676,2674,2677,-1,2675,2498,2504,-1,2499,2498,2639,-1,2678,2679,2680,-1,2679,2681,2682,-1,2683,2681,2684,-1,2674,2504,2685,-1,2504,2524,2686,-1,2641,2499,2639,-1,2687,2641,2640,-1,2688,2499,2689,-1,2690,2691,2692,-1,2693,2678,2694,-1,2695,2694,2696,-1,2697,2698,2699,-1,2700,2698,2701,-1,2702,2700,2703,-1,2677,2674,2704,-1,2705,2706,2707,-1,2706,2708,2707,-1,2708,2709,2707,-1,2709,2710,2707,-1,2707,2711,2705,-1,2712,2713,2714,-1,2713,2715,2714,-1,2715,2716,2714,-1,2714,2716,2717,-1,2718,2719,2720,-1,2721,2720,2722,-1,2719,2722,2720,-1,2723,2724,2725,-1,2726,2727,2728,-1,2727,2726,2729,-1,2727,2730,2731,-1,2732,2733,2734,-1,2699,2735,2697,-1,2736,2737,2738,-1,2738,2737,2739,-1,2739,2737,2740,-1,2741,2742,2743,-1,2744,2745,2746,-1,2744,2746,2747,-1,2693,2748,2702,-1,2690,2678,2703,-1,2734,2749,2750,-1,2751,2752,2747,-1,2729,2752,2751,-1,2751,2747,2753,-1,2752,2729,2754,-1,2730,2751,2753,-1,2755,2756,2757,-1,2758,2759,2500,-1,2760,2761,2759,-1,2759,2761,2500,-1,2501,2500,2761,-1,2762,2763,2764,-1,2765,2766,2767,-1,2768,2769,2770,-1,2769,2771,2770,-1,2770,2771,2772,-1,2773,2774,2775,-1,2775,2776,2777,-1,2778,2779,2780,-1,2781,2773,2775,-1,2782,2781,2783,-1,2773,2781,2782,-1,2781,2784,2783,-1,2783,2785,2786,-1,2787,2788,2789,-1,2790,2791,2792,-1,2793,2788,2791,-1,2788,2793,2789,-1,2794,2795,2796,-1,2785,2783,2797,-1,2790,2798,2791,-1,2799,2800,2801,-1,2802,2803,2804,-1,2805,2802,2784,-1,2806,2791,2807,-1,2808,2809,2810,-1,2811,2812,2813,-1,2814,2503,2815,-1,2761,2815,2501,-1,2815,2503,2501,-1,2816,2817,2818,-1,2819,2820,2821,-1,2794,2822,2823,-1,2824,2825,2826,-1,2827,2828,2829,-1,2721,2722,2828,-1,2828,2722,2829,-1,2830,2742,2741,-1,2831,2832,2833,-1,2832,2834,2835,-1,2835,2834,2836,-1,2834,2837,2836,-1,2838,2835,2836,-1,2839,2840,2841,-1,2760,2759,2669,-1,2842,2843,2844,-1,2845,2846,2847,-1,2848,2849,2850,-1,2851,2852,2853,-1,2854,2852,2855,-1,2855,2852,2856,-1,2852,2851,2856,-1,2856,2851,2857,-1,2858,2859,2860,-1,2861,2862,2858,-1,2863,2864,2865,-1,2860,2865,2864,-1,2856,2836,2855,-1,2866,2867,2868,-1,2869,2853,2870,-1,2871,2872,2860,-1,2824,2873,2874,-1,2875,2876,2877,-1,2878,2276,2279,-1,2879,2880,2881,-1,2882,2883,2884,-1,2885,2886,2887,-1,2888,2889,2890,-1,2875,2877,2891,-1,2892,2891,2893,-1,2894,2895,2896,-1,2897,2898,2899,-1,2900,2899,2901,-1,2902,2903,2904,-1,2825,2874,2905,-1,2906,2907,2908,-1,2909,2910,2911,-1,2912,2913,2914,-1,2825,2824,2874,-1,2915,2916,2917,-1,2917,2916,2918,-1,2916,2919,2918,-1,2918,2919,2920,-1,2920,2919,2921,-1,2919,2922,2921,-1,2921,2922,2923,-1,2923,2922,2924,-1,2924,2922,2925,-1,2925,2922,2926,-1,2926,2922,2927,-1,2927,2922,2928,-1,2929,2930,2931,-1,2932,2933,2934,-1,2877,2935,2936,-1,2937,2938,2939,-1,2933,2932,2940,-1,2941,2942,2943,-1,2944,2945,2946,-1,2947,2948,2949,-1,2950,2951,2952,-1,2953,2954,2955,-1,2956,2957,2958,-1,2959,2960,2948,-1,2961,2960,2962,-1,2963,2964,2965,-1,2966,2967,2968,-1,2969,2970,2971,-1,2972,2973,2974,-1,2975,2947,2976,-1,2977,2978,2979,-1,2980,2981,2982,-1,2980,2982,2983,-1,2984,2983,2985,-1,2984,2985,2986,-1,2621,2987,2972,-1,2988,2989,2962,-1,2990,2991,2992,-1,2993,2994,2995,-1,2996,2997,2944,-1,2940,2998,2933,-1,2999,3000,3001,-1,3002,3003,3004,-1,3005,3006,2941,-1,3006,3007,2941,-1,2621,2972,2622,-1,2974,3008,2972,-1,2972,3008,2622,-1,2622,3008,2623,-1,3008,2980,3009,-1,2983,2984,2980,-1,3009,2980,2984,-1,3010,3011,3012,-1,3013,3014,3015,-1,3016,3014,3017,-1,3014,3013,3017,-1,3013,3018,3017,-1,3019,3013,3020,-1,3021,3022,3023,-1,3024,3025,3026,-1,3026,3027,3024,-1,3028,3029,3030,-1,3030,3031,3028,-1,3032,3033,3034,-1,3034,3033,3035,-1,3035,3033,3036,-1,3037,3028,3038,-1,3039,3040,3041,-1,3042,3043,3044,-1,3045,3046,3047,-1,3047,3048,3045,-1,3049,3050,3051,-1,3052,3053,3054,-1,3053,3052,3055,-1,3051,3054,3053,-1,3056,3057,3058,-1,3059,3060,3061,-1,3059,3062,3063,-1,3063,3064,3065,-1,3066,3067,3068,-1,3069,3070,3071,-1,2545,3072,3070,-1,2545,2538,3072,-1,3033,2538,2537,-1,3073,3074,3075,-1,3076,3077,3074,-1,3078,3077,3079,-1,3080,2564,2545,-1,3081,2545,3070,-1,3033,2537,3036,-1,3035,3036,3082,-1,3083,2537,3084,-1,3085,3086,3087,-1,3088,3075,3089,-1,3090,3088,3091,-1,3092,3093,3094,-1,3095,3093,3096,-1,3097,3096,3098,-1,3099,3070,3069,-1,3100,3101,3102,-1,3102,3101,3103,-1,3103,3101,3104,-1,3101,3105,3104,-1,3100,3106,3101,-1,3107,3108,3109,-1,3109,3108,3110,-1,3110,3108,3111,-1,3112,3111,3108,-1,3113,3114,3115,-1,3116,3117,3118,-1,3119,3118,3117,-1,3120,3121,3117,-1,3122,3123,3124,-1,3094,3125,3092,-1,3126,3127,3128,-1,3127,3129,3128,-1,3130,3128,3129,-1,3131,3132,3133,-1,3134,3131,3133,-1,3098,3135,3089,-1,3097,3075,3087,-1,3136,3137,3122,-1,3134,3138,3139,-1,3139,3138,3119,-1,3140,3134,3139,-1,3141,3119,3138,-1,3140,3139,3121,-1,3142,3143,3144,-1,2540,3145,3146,-1,3147,3145,3148,-1,3145,2540,3148,-1,3148,2540,2542,-1,3149,3150,3151,-1,3152,3153,3154,-1,3155,3156,3157,-1,3157,3156,3158,-1,3159,3158,3156,-1,3160,3161,3162,-1,3163,3164,3160,-1,3165,3166,3167,-1,3160,3162,3168,-1,3169,3168,3170,-1,3169,3171,3168,-1,3170,3168,3162,-1,3172,3173,3169,-1,3174,3175,3176,-1,3177,3178,3179,-1,3175,3178,3180,-1,3177,3180,3178,-1,3181,3182,3183,-1,3184,3169,3173,-1,3175,3185,3176,-1,3186,3187,3188,-1,3189,3190,3191,-1,3171,3191,3192,-1,3193,3175,3194,-1,3195,3196,3197,-1,3198,3199,3200,-1,3201,3202,2543,-1,3148,2542,3202,-1,2542,2543,3202,-1,3203,3204,3205,-1,3206,3207,3208,-1,3209,3210,3183,-1,3211,3212,3213,-1,3214,3215,3216,-1,3217,3218,3215,-1,3219,3218,3217,-1,3219,3220,3218,-1,3219,3217,3221,-1,3222,3223,3224,-1,3061,3145,3147,-1,3225,3226,3227,-1,3228,3229,3230,-1,3231,3232,3233,-1,3234,3235,3236,-1,3237,3238,3235,-1,3238,3239,3235,-1,3239,3236,3235,-1,3240,3236,3239,-1,3241,3242,3243,-1,3243,3244,3245,-1,3246,3247,3248,-1,3247,3246,3241,-1,3238,3219,3239,-1,3249,3250,3251,-1,3252,3234,3253,-1,3241,3254,3255,-1,3256,3257,3213,-1,3258,3259,3260,-1,2280,2277,3261,-1,3262,3263,3264,-1,3265,3266,3267,-1,3268,3269,3270,-1,3271,3272,3273,-1,3274,3258,3260,-1,3275,3274,3276,-1,3277,3278,3279,-1,3280,3281,3282,-1,3283,3280,3284,-1,3285,3286,3287,-1,3288,3256,3212,-1,3289,3290,3291,-1,3292,3293,3294,-1,3295,3296,3297,-1,3256,3213,3212,-1,3298,3299,3300,-1,3299,3301,3300,-1,3300,3301,3302,-1,3301,3303,3302,-1,3303,3304,3302,-1,3302,3304,3305,-1,3304,3306,3305,-1,3306,3307,3305,-1,3307,3308,3305,-1,3308,3309,3305,-1,3309,3310,3305,-1,3311,3305,3310,-1,3312,3313,3314,-1,3315,3316,3317,-1,3318,3319,3258,-1,3320,3321,3322,-1,3323,3317,3316,-1,3324,3325,3326,-1,3327,3328,3329,-1,3330,3331,3332,-1,3333,3334,3335,-1,3336,3337,3338,-1,3339,3340,3341,-1,3342,3343,3344,-1,3331,3343,3345,-1,3346,3347,3348,-1,3349,3350,3351,-1,3352,3353,3354,-1,3355,3356,3357,-1,3358,3332,3359,-1,3360,3361,3362,-1,3363,3364,3365,-1,3366,3363,3365,-1,3367,3366,3368,-1,3369,3367,3368,-1,3357,3370,3016,-1,3342,3371,3372,-1,3373,3374,3375,-1,3376,3377,3378,-1,3329,3379,3380,-1,3316,3381,3323,-1,3382,3383,3384,-1,3385,3386,3387,-1,3326,3388,3389,-1,3326,3390,3388,-1,3016,3017,3357,-1,3355,3357,3391,-1,3017,3391,3357,-1,3018,3391,3017,-1,3392,3365,3391,-1,3365,3368,3366,-1,3368,3365,3392,-1,2364,2363,2372,-1,2372,2371,2364,-1,2367,2366,2370,-1,2370,2369,2367,-1,2373,3393,3394,-1,3394,2371,2373,-1,3393,3395,3396,-1,3396,3394,3393,-1,3395,2368,2370,-1,2370,3396,3395,-1,2365,3397,3398,-1,3398,2366,2365,-1,3397,3399,3400,-1,3400,3398,3397,-1,3399,2362,2364,-1,2364,3400,3399,-1,2363,3401,3402,-1,3402,2372,2363,-1,2361,3403,3404,-1,3404,2359,2361,-1,3404,3405,2360,-1,2360,2359,3404,-1,3406,3407,3408,-1,3408,3409,3406,-1,3407,3406,3405,-1,3405,3404,3407,-1,3410,3411,3402,-1,3402,3401,3410,-1,3409,3408,3411,-1,3411,3410,3409,-1,3412,3407,3404,-1,3404,3403,3412,-1,3413,3408,3407,-1,3407,3412,3413,-1,2374,3411,3408,-1,3408,3413,2374,-1,2372,3402,3411,-1,3411,2374,2372,-1,2375,3410,3401,-1,3401,2363,2375,-1,3414,3409,3410,-1,3410,2375,3414,-1,3415,3406,3409,-1,3409,3414,3415,-1,2376,3405,3406,-1,3406,3415,2376,-1,2367,2360,3405,-1,3405,2376,2367,-1,2368,3403,2361,-1,2361,2369,2368,-1,3395,3412,3403,-1,3403,2368,3395,-1,3393,3413,3412,-1,3412,3395,3393,-1,2373,2374,3413,-1,3413,3393,2373,-1,3399,3414,2375,-1,2375,2362,3399,-1,3397,3415,3414,-1,3414,3399,3397,-1,2365,2376,3415,-1,3415,3397,2365,-1,3398,3400,3394,-1,3394,3396,3398,-1,2371,3394,3400,-1,3400,2364,2371,-1,2366,3398,3396,-1,3396,2370,2366,-1,2380,3416,3417,-1,3417,2379,2380,-1,2380,2382,3418,-1,3418,3416,2380,-1,3417,3416,3418,-1,3418,3419,3417,-1,2377,2379,3417,-1,3417,3419,2377,-1,2380,2379,2378,-1,2378,2381,2380,-1,3420,3421,3419,-1,3419,3418,3420,-1,3421,3420,3422,-1,3422,3423,3421,-1,2388,2377,3419,-1,3419,3421,2388,-1,2382,2387,3420,-1,3420,3418,2382,-1,3424,3425,3423,-1,3423,3422,3424,-1,3425,3424,3426,-1,3426,3427,3425,-1,3428,3429,3423,-1,3423,3425,3428,-1,3430,3431,3424,-1,3424,3422,3430,-1,2387,3430,3422,-1,3422,3420,2387,-1,3429,2388,3421,-1,3421,3423,3429,-1,3432,3433,3427,-1,3427,3426,3432,-1,3434,3435,3433,-1,3433,3432,3434,-1,2394,3436,3427,-1,3427,3433,2394,-1,3437,2395,3432,-1,3432,3426,3437,-1,3431,3437,3426,-1,3426,3424,3431,-1,3436,3428,3425,-1,3425,3427,3436,-1,2396,2393,3435,-1,3435,3434,2396,-1,2393,2394,3433,-1,3433,3435,2393,-1,2395,2396,3434,-1,3434,3432,2395,-1,2381,2378,3438,-1,3438,3439,2381,-1,3440,3441,3439,-1,3439,3438,3440,-1,3441,3440,3442,-1,3442,3443,3441,-1,3439,3441,3444,-1,3444,2386,3439,-1,3440,3438,2389,-1,2389,3445,3440,-1,3438,2378,2377,-1,2377,2389,3438,-1,2381,3439,2386,-1,2386,2382,2381,-1,2391,2384,3443,-1,3443,3442,2391,-1,2384,2391,2390,-1,2390,2385,2384,-1,3443,2384,2383,-1,2383,3446,3443,-1,2391,3442,3447,-1,3447,2392,2391,-1,3442,3440,3445,-1,3445,3447,3442,-1,3441,3443,3446,-1,3446,3444,3441,-1,3446,2383,3437,-1,3437,3431,3446,-1,3444,3446,3431,-1,3431,3430,3444,-1,2386,3444,3430,-1,3430,2387,2386,-1,3445,2389,2388,-1,2388,3429,3445,-1,3447,3445,3429,-1,3429,3428,3447,-1,2392,3447,3428,-1,3428,3436,2392,-1,2390,2392,3436,-1,3436,2394,2390,-1,2385,2390,2393,-1,2393,2396,2385,-1,2383,2385,2395,-1,2395,3437,2383,-1,2398,2397,3448,-1,3448,3449,2398,-1,2400,2398,3449,-1,3449,3450,2400,-1,3451,2404,2400,-1,2400,3450,3451,-1,3452,2403,2404,-1,2404,3451,3452,-1,3452,3453,2401,-1,2401,2403,3452,-1,3454,2405,2402,-1,2402,3455,3454,-1,2406,2405,3454,-1,3454,2418,2406,-1,2418,2417,2407,-1,2407,2406,2418,-1,3456,2399,2407,-1,2407,2417,3456,-1,3448,2397,2399,-1,2399,3456,3448,-1,3454,3457,3458,-1,3458,2418,3454,-1,3458,2427,2419,-1,2419,2418,3458,-1,3459,3456,2417,-1,2417,2419,3459,-1,3457,3454,3455,-1,3455,3460,3457,-1,3457,3461,2422,-1,2422,3458,3457,-1,3458,2422,2421,-1,2421,2427,3458,-1,3459,2419,2427,-1,2427,2426,3459,-1,3461,3457,3460,-1,3460,3462,3461,-1,3461,3463,2420,-1,2420,2422,3461,-1,2425,2427,2421,-1,2421,2423,2425,-1,3463,3461,3462,-1,3462,3464,3463,-1,3465,2420,3463,-1,3463,3466,3465,-1,2421,2420,3465,-1,3465,2424,2421,-1,3467,2428,2424,-1,2424,3465,3467,-1,3466,3463,3464,-1,3464,3468,3466,-1,3469,3467,3465,-1,3465,3466,3469,-1,3470,3448,3456,-1,3456,3459,3470,-1,3471,3449,3448,-1,3448,3470,3471,-1,3472,3470,3459,-1,3459,2426,3472,-1,3473,3450,3449,-1,3449,3471,3473,-1,3474,3471,3470,-1,3470,3472,3474,-1,3475,3451,3450,-1,3450,3473,3475,-1,3473,3471,3474,-1,3474,3476,3473,-1,3477,3452,3451,-1,3451,3475,3477,-1,3478,3475,3473,-1,3473,3476,3478,-1,3479,3453,3452,-1,3452,3477,3479,-1,3480,3477,3475,-1,3475,3478,3480,-1,3477,3480,3481,-1,3481,3479,3477,-1,3482,3480,3478,-1,3478,3483,3482,-1,3484,3483,3478,-1,3478,3476,3484,-1,3484,3476,3474,-1,3474,3485,3484,-1,3472,2426,2425,-1,2425,3486,3472,-1,3486,2425,2423,-1,2423,2430,3486,-1,3483,3484,2428,-1,2428,3467,3483,-1,3480,3482,3487,-1,3487,3481,3480,-1,3469,3482,3483,-1,3483,3467,3469,-1,3482,3469,3488,-1,3488,3487,3482,-1,3469,3466,3468,-1,3468,3488,3469,-1,3484,3485,2429,-1,2429,2428,3484,-1,2430,2423,2424,-1,2424,2428,2430,-1,3485,3486,2430,-1,2430,2429,3485,-1,3474,3472,3486,-1,3486,3485,3474,-1,3488,3468,3489,-1,3489,3490,3488,-1,3468,3464,3491,-1,3491,3489,3468,-1,3479,3481,3492,-1,3492,3493,3479,-1,3493,3494,3453,-1,3453,3479,3493,-1,2412,2401,3453,-1,3453,3494,2412,-1,3481,3487,3495,-1,3495,3492,3481,-1,3487,3488,3490,-1,3490,3495,3487,-1,3464,3462,3496,-1,3496,3491,3464,-1,3462,3460,3497,-1,3497,3496,3462,-1,3460,3455,3498,-1,3498,3497,3460,-1,3455,2402,2414,-1,2414,3498,3455,-1,2433,2416,2409,-1,2409,3499,2433,-1,2415,2416,2433,-1,2433,2432,2415,-1,2432,3498,2414,-1,2414,2415,2432,-1,3500,2413,2412,-1,2412,3494,3500,-1,3501,2411,2413,-1,2413,3500,3501,-1,3501,3502,2410,-1,2410,2411,3501,-1,3502,3503,2408,-1,2408,2410,3502,-1,3499,2409,2408,-1,2408,3503,3499,-1,2432,3504,3497,-1,3497,3498,2432,-1,2432,2431,2439,-1,2439,3504,2432,-1,2431,2433,3499,-1,3499,3505,2431,-1,3504,2434,3496,-1,3496,3497,3504,-1,2440,2439,2431,-1,2431,3505,2440,-1,2439,2435,2434,-1,2434,3504,2439,-1,2434,2436,3491,-1,3491,3496,2434,-1,2438,2435,2439,-1,2439,2441,2438,-1,3489,3491,2436,-1,2436,3506,3489,-1,2437,3506,2436,-1,2436,2435,2437,-1,3506,2437,2444,-1,2444,3507,3506,-1,3489,3506,3507,-1,3507,3490,3489,-1,3505,3499,3503,-1,3503,3508,3505,-1,3508,3503,3502,-1,3502,3509,3508,-1,2440,3505,3508,-1,3508,3510,2440,-1,3509,3502,3501,-1,3501,3511,3509,-1,3510,3508,3509,-1,3509,3512,3510,-1,3511,3501,3500,-1,3500,3513,3511,-1,3514,3512,3509,-1,3509,3511,3514,-1,3513,3500,3494,-1,3494,3493,3513,-1,3514,3511,3513,-1,3513,3515,3514,-1,3515,3513,3493,-1,3493,3492,3515,-1,3516,3515,3492,-1,3492,3495,3516,-1,3514,3515,3516,-1,3516,3517,3514,-1,3518,3512,3514,-1,3514,3517,3518,-1,3519,2441,2440,-1,2440,3510,3519,-1,2442,2438,2441,-1,2441,3519,2442,-1,3507,2444,3517,-1,3517,3516,3507,-1,3507,3516,3495,-1,3495,3490,3507,-1,2444,2443,3518,-1,3518,3517,2444,-1,2444,2437,2438,-1,2438,2442,2444,-1,2443,2442,3519,-1,3519,3518,2443,-1,3518,3519,3510,-1,3510,3512,3518,-1,3520,3521,3522,-1,3522,3523,3520,-1,3524,3525,3521,-1,3521,3520,3524,-1,3521,3526,3527,-1,3527,3522,3521,-1,3522,3528,3529,-1,3529,3523,3522,-1,2447,3520,3523,-1,3523,2445,2447,-1,3530,3531,3532,-1,3532,3533,3530,-1,3534,3535,3531,-1,3531,3530,3534,-1,3536,3532,3531,-1,3531,3537,3536,-1,3538,3533,3532,-1,3532,3539,3538,-1,3540,3530,3533,-1,3533,3541,3540,-1,3526,3521,3525,-1,3525,3542,3526,-1,3526,3543,3544,-1,3544,3527,3526,-1,3527,3544,3528,-1,3528,3522,3527,-1,2445,3545,3546,-1,3546,2446,2445,-1,3520,2447,2450,-1,2450,3524,3520,-1,3523,3529,3545,-1,3545,2445,3523,-1,2448,3547,3548,-1,3548,2447,2448,-1,2448,3549,3550,-1,3550,3547,2448,-1,3540,3548,3547,-1,3547,3551,3540,-1,2447,3548,3552,-1,3552,2449,2447,-1,2446,3546,3549,-1,3549,2448,2446,-1,3551,3534,3530,-1,3530,3540,3551,-1,3551,3553,3554,-1,3554,3534,3551,-1,3541,3552,3548,-1,3548,3540,3541,-1,3547,3550,3553,-1,3553,3551,3547,-1,3534,3554,3555,-1,3555,3535,3534,-1,3537,3531,3535,-1,3535,3556,3537,-1,3557,3552,3541,-1,3541,3558,3557,-1,3558,3541,3533,-1,3533,3538,3558,-1,3559,2450,2449,-1,2449,3560,3559,-1,3560,2449,3552,-1,3552,3557,3560,-1,3561,3525,3524,-1,3524,3562,3561,-1,3562,3524,2450,-1,2450,3559,3562,-1,3563,3542,3525,-1,3525,3561,3563,-1,3564,3526,3542,-1,3542,3565,3564,-1,3565,3566,2451,-1,2451,3564,3565,-1,3567,3566,3565,-1,3565,3568,3567,-1,2452,2451,3566,-1,3566,3569,2452,-1,2453,3570,3564,-1,3564,2451,2453,-1,3564,3570,3543,-1,3543,3526,3564,-1,3568,3565,3542,-1,3542,3563,3568,-1,3569,3566,3567,-1,3567,3571,3569,-1,3572,2452,3569,-1,3569,3573,3572,-1,3573,2455,2454,-1,2454,3572,3573,-1,3574,2455,3573,-1,3573,3575,3574,-1,2454,3576,3577,-1,3577,3572,2454,-1,3572,3577,2453,-1,2453,2452,3572,-1,3573,3569,3571,-1,3571,3575,3573,-1,2456,3578,3579,-1,3579,2454,2456,-1,3580,3578,2456,-1,2456,3581,3580,-1,3578,3582,3583,-1,3583,3579,3578,-1,3579,3584,3576,-1,3576,2454,3579,-1,3581,2456,2455,-1,2455,3574,3581,-1,3585,3582,3578,-1,3578,3580,3585,-1,3582,3586,3587,-1,3587,3583,3582,-1,3583,3588,3584,-1,3584,3579,3583,-1,3589,3586,3582,-1,3582,3585,3589,-1,3586,2462,2463,-1,2463,3587,3586,-1,3587,3590,3588,-1,3588,3583,3587,-1,2460,2462,3586,-1,3586,3589,2460,-1,2463,2461,3590,-1,3590,3587,2463,-1,3589,3591,2459,-1,2459,2460,3589,-1,2457,2459,3591,-1,3591,3592,2457,-1,2458,2457,3592,-1,3592,3593,2458,-1,2461,2458,3593,-1,3593,3590,2461,-1,3590,3593,3594,-1,3594,3588,3590,-1,3593,3592,3595,-1,3595,3594,3593,-1,3592,3591,3596,-1,3596,3595,3592,-1,3588,3594,3597,-1,3597,3584,3588,-1,3594,3595,3598,-1,3598,3597,3594,-1,3596,3591,3589,-1,3589,3585,3596,-1,3595,3596,3599,-1,3599,3598,3595,-1,3584,3597,3600,-1,3600,3576,3584,-1,3597,3598,3601,-1,3601,3600,3597,-1,3599,3596,3585,-1,3585,3580,3599,-1,3598,3599,3602,-1,3602,3601,3598,-1,3576,3600,3603,-1,3603,3577,3576,-1,3600,3601,3604,-1,3604,3603,3600,-1,3602,3599,3580,-1,3580,3581,3602,-1,3601,3602,3605,-1,3605,3604,3601,-1,3577,3603,3606,-1,3606,2453,3577,-1,3603,3604,3607,-1,3607,3606,3603,-1,3574,3605,3602,-1,3602,3581,3574,-1,3604,3605,3608,-1,3608,3607,3604,-1,3606,3609,3570,-1,3570,2453,3606,-1,3607,3610,3609,-1,3609,3606,3607,-1,3575,3608,3605,-1,3605,3574,3575,-1,3608,3611,3610,-1,3610,3607,3608,-1,3609,3612,3543,-1,3543,3570,3609,-1,3610,3613,3612,-1,3612,3609,3610,-1,3571,3611,3608,-1,3608,3575,3571,-1,3611,3614,3613,-1,3613,3610,3611,-1,3543,3612,3615,-1,3615,3544,3543,-1,3612,3613,3616,-1,3616,3615,3612,-1,3567,3614,3611,-1,3611,3571,3567,-1,3613,3614,3617,-1,3617,3616,3613,-1,3544,3615,3618,-1,3618,3528,3544,-1,3615,3616,3619,-1,3619,3618,3615,-1,3568,3617,3614,-1,3614,3567,3568,-1,3616,3617,3620,-1,3620,3619,3616,-1,3528,3618,3621,-1,3621,3529,3528,-1,3618,3619,3622,-1,3622,3621,3618,-1,3563,3620,3617,-1,3617,3568,3563,-1,3619,3620,3623,-1,3623,3622,3619,-1,3529,3621,3624,-1,3624,3545,3529,-1,3621,3622,3625,-1,3625,3624,3621,-1,3561,3623,3620,-1,3620,3563,3561,-1,3622,3623,3626,-1,3626,3625,3622,-1,3545,3624,3627,-1,3627,3546,3545,-1,3624,3625,3628,-1,3628,3627,3624,-1,3562,3626,3623,-1,3623,3561,3562,-1,3625,3626,3629,-1,3629,3628,3625,-1,3546,3627,3630,-1,3630,3549,3546,-1,3627,3628,3631,-1,3631,3630,3627,-1,3559,3629,3626,-1,3626,3562,3559,-1,3628,3629,3632,-1,3632,3631,3628,-1,3549,3630,3633,-1,3633,3550,3549,-1,3630,3631,3634,-1,3634,3633,3630,-1,3560,3632,3629,-1,3629,3559,3560,-1,3631,3632,3635,-1,3635,3634,3631,-1,3550,3633,3636,-1,3636,3553,3550,-1,3633,3634,3637,-1,3637,3636,3633,-1,3557,3635,3632,-1,3632,3560,3557,-1,3634,3635,3638,-1,3638,3637,3634,-1,3553,3636,3639,-1,3639,3554,3553,-1,3636,3637,3640,-1,3640,3639,3636,-1,3558,3638,3635,-1,3635,3557,3558,-1,3637,3638,3641,-1,3641,3640,3637,-1,3554,3639,3642,-1,3642,3555,3554,-1,3639,3640,3643,-1,3643,3642,3639,-1,3538,3641,3638,-1,3638,3558,3538,-1,3640,3641,3644,-1,3644,3643,3640,-1,3535,3555,3645,-1,3645,3556,3535,-1,3555,3642,3646,-1,3646,3645,3555,-1,3642,3643,3647,-1,3647,3646,3642,-1,3539,3644,3641,-1,3641,3538,3539,-1,3643,3644,3648,-1,3648,3647,3643,-1,3539,3532,3536,-1,3536,3649,3539,-1,3649,3648,3644,-1,3644,3539,3649,-1,3650,3651,3652,-1,3652,3653,3650,-1,3650,3654,3655,-1,3655,3651,3650,-1,3651,3656,3657,-1,3657,3652,3651,-1,3653,3652,3658,-1,3658,3659,3653,-1,2466,3650,3653,-1,3653,2464,2466,-1,3660,3536,3537,-1,3537,3661,3660,-1,3651,3655,3662,-1,3662,3656,3651,-1,3656,3662,3663,-1,3663,3657,3656,-1,3664,3658,3652,-1,3652,3657,3664,-1,2465,3665,3666,-1,3666,2466,2465,-1,2466,3666,3654,-1,3654,3650,2466,-1,3659,2468,2464,-1,2464,3653,3659,-1,2464,3667,3668,-1,3668,2467,2464,-1,2469,3669,3667,-1,3667,2464,2469,-1,3670,3668,3667,-1,3667,3661,3670,-1,3668,3671,3672,-1,3672,2467,3668,-1,2467,3672,3665,-1,3665,2465,2467,-1,3661,3537,3556,-1,3556,3670,3661,-1,3556,3645,3673,-1,3673,3670,3556,-1,3670,3673,3671,-1,3671,3668,3670,-1,3661,3667,3669,-1,3669,3660,3661,-1,3674,3660,3669,-1,3669,3675,3674,-1,3649,3536,3660,-1,3660,3674,3649,-1,3676,2469,2468,-1,2468,3677,3676,-1,3675,3669,2469,-1,2469,3676,3675,-1,3678,3659,3658,-1,3658,3679,3678,-1,3677,2468,3659,-1,3659,3678,3677,-1,3679,3658,3664,-1,3664,3680,3679,-1,3681,3664,3657,-1,3657,3682,3681,-1,3682,2472,3683,-1,3683,3681,3682,-1,2472,3682,3684,-1,3684,2470,2472,-1,3685,3683,2472,-1,2472,2471,3685,-1,3686,3681,3683,-1,3683,3687,3686,-1,3680,3664,3681,-1,3681,3686,3680,-1,3657,3663,3684,-1,3684,3682,3657,-1,3688,3687,3683,-1,3683,3685,3688,-1,3689,3685,2471,-1,2471,3690,3689,-1,3690,2475,2474,-1,2474,3689,3690,-1,3690,3691,3692,-1,3692,2475,3690,-1,3693,3689,2474,-1,2474,3694,3693,-1,3693,3688,3685,-1,3685,3689,3693,-1,2471,2470,3691,-1,3691,3690,2471,-1,2475,3695,3696,-1,3696,2473,2475,-1,2475,3692,3697,-1,3697,3695,2475,-1,3695,3698,3699,-1,3699,3696,3695,-1,3700,2473,3696,-1,3696,3701,3700,-1,3694,2474,2473,-1,2473,3700,3694,-1,3695,3697,3702,-1,3702,3698,3695,-1,3698,3703,3704,-1,3704,3699,3698,-1,3701,3696,3699,-1,3699,3705,3701,-1,3698,3702,3706,-1,3706,3703,3698,-1,3703,2482,2481,-1,2481,3704,3703,-1,3705,3699,3704,-1,3704,3707,3705,-1,3703,3706,2480,-1,2480,2482,3703,-1,3707,3704,2481,-1,2481,2479,3707,-1,3706,3708,2478,-1,2478,2480,3706,-1,3708,3709,2476,-1,2476,2478,3708,-1,3709,3710,2477,-1,2477,2476,3709,-1,2479,2477,3710,-1,3710,3707,2479,-1,3702,3711,3708,-1,3708,3706,3702,-1,3711,3712,3709,-1,3709,3708,3711,-1,3712,3713,3710,-1,3710,3709,3712,-1,3697,3714,3711,-1,3711,3702,3697,-1,3714,3715,3712,-1,3712,3711,3714,-1,3715,3716,3713,-1,3713,3712,3715,-1,3705,3707,3710,-1,3710,3713,3705,-1,3692,3717,3714,-1,3714,3697,3692,-1,3717,3718,3715,-1,3715,3714,3717,-1,3718,3719,3716,-1,3716,3715,3718,-1,3701,3705,3713,-1,3713,3716,3701,-1,3691,3720,3717,-1,3717,3692,3691,-1,3720,3721,3718,-1,3718,3717,3720,-1,3721,3722,3719,-1,3719,3718,3721,-1,3700,3701,3716,-1,3716,3719,3700,-1,2470,3723,3720,-1,3720,3691,2470,-1,3723,3724,3721,-1,3721,3720,3723,-1,3724,3725,3722,-1,3722,3721,3724,-1,3700,3719,3722,-1,3722,3694,3700,-1,2470,3684,3726,-1,3726,3723,2470,-1,3723,3726,3727,-1,3727,3724,3723,-1,3724,3727,3728,-1,3728,3725,3724,-1,3694,3722,3725,-1,3725,3693,3694,-1,3684,3663,3729,-1,3729,3726,3684,-1,3726,3729,3730,-1,3730,3727,3726,-1,3727,3730,3731,-1,3731,3728,3727,-1,3693,3725,3728,-1,3728,3688,3693,-1,3662,3732,3729,-1,3729,3663,3662,-1,3732,3733,3730,-1,3730,3729,3732,-1,3733,3734,3731,-1,3731,3730,3733,-1,3688,3728,3731,-1,3731,3687,3688,-1,3655,3735,3732,-1,3732,3662,3655,-1,3735,3736,3733,-1,3733,3732,3735,-1,3736,3737,3734,-1,3734,3733,3736,-1,3687,3731,3734,-1,3734,3686,3687,-1,3654,3738,3735,-1,3735,3655,3654,-1,3738,3739,3736,-1,3736,3735,3738,-1,3739,3740,3737,-1,3737,3736,3739,-1,3686,3734,3737,-1,3737,3680,3686,-1,3666,3741,3738,-1,3738,3654,3666,-1,3741,3742,3739,-1,3739,3738,3741,-1,3742,3743,3740,-1,3740,3739,3742,-1,3680,3737,3740,-1,3740,3679,3680,-1,3665,3744,3741,-1,3741,3666,3665,-1,3744,3745,3742,-1,3742,3741,3744,-1,3745,3746,3743,-1,3743,3742,3745,-1,3679,3740,3743,-1,3743,3678,3679,-1,3672,3747,3744,-1,3744,3665,3672,-1,3747,3748,3745,-1,3745,3744,3747,-1,3748,3749,3746,-1,3746,3745,3748,-1,3678,3743,3746,-1,3746,3677,3678,-1,3671,3750,3747,-1,3747,3672,3671,-1,3750,3751,3748,-1,3748,3747,3750,-1,3751,3752,3749,-1,3749,3748,3751,-1,3677,3746,3749,-1,3749,3676,3677,-1,3673,3753,3750,-1,3750,3671,3673,-1,3753,3754,3751,-1,3751,3750,3753,-1,3754,3755,3752,-1,3752,3751,3754,-1,3676,3749,3752,-1,3752,3675,3676,-1,3645,3646,3753,-1,3753,3673,3645,-1,3646,3647,3754,-1,3754,3753,3646,-1,3647,3648,3755,-1,3755,3754,3647,-1,3675,3752,3755,-1,3755,3674,3675,-1,3674,3755,3648,-1,3648,3649,3674,-1,3756,2489,2488,-1,2488,3757,3756,-1,3758,2485,2489,-1,2489,3756,3758,-1,3759,2483,2485,-1,2485,3758,3759,-1,3759,3760,2484,-1,2484,2483,3759,-1,3761,2486,2484,-1,2484,3760,3761,-1,2487,2486,3761,-1,3761,3762,2487,-1,3757,2488,2487,-1,2487,3762,3757,-1,3763,3764,3765,-1,3765,3766,3763,-1,3767,3764,3763,-1,3763,3768,3767,-1,3765,3764,3769,-1,3769,3770,3765,-1,3771,3766,3765,-1,3765,3772,3771,-1,3773,3763,3766,-1,3766,3774,3773,-1,3775,3776,3774,-1,3774,3777,3775,-1,3778,3779,3776,-1,3776,3775,3778,-1,3774,3776,3780,-1,3780,3773,3774,-1,3777,3774,3766,-1,3766,3771,3777,-1,3781,3775,3777,-1,3777,3782,3781,-1,3783,3773,3780,-1,3780,3784,3783,-1,3768,3763,3773,-1,3773,3783,3768,-1,3784,3780,3785,-1,3785,3786,3784,-1,3784,3787,3788,-1,3788,3783,3784,-1,3783,3788,3789,-1,3789,3768,3783,-1,3790,3769,3764,-1,3764,3767,3790,-1,3768,3789,3791,-1,3791,3767,3768,-1,3790,3792,3793,-1,3793,3769,3790,-1,3791,3794,3790,-1,3790,3767,3791,-1,3794,3795,3792,-1,3792,3790,3794,-1,3796,3797,3793,-1,3793,3792,3796,-1,3769,3793,3798,-1,3798,3770,3769,-1,3796,3799,3800,-1,3800,3797,3796,-1,3798,3793,3797,-1,3797,3801,3798,-1,3792,3795,3802,-1,3802,3796,3792,-1,3802,3803,3799,-1,3799,3796,3802,-1,3804,3805,3800,-1,3800,3799,3804,-1,3797,3800,3806,-1,3806,3801,3797,-1,3807,3808,3805,-1,3805,3804,3807,-1,3800,3805,3809,-1,3809,3806,3800,-1,3799,3803,3810,-1,3810,3804,3799,-1,3811,3812,3808,-1,3808,3807,3811,-1,3813,3809,3805,-1,3805,3808,3813,-1,3810,3814,3807,-1,3807,3804,3810,-1,3815,3816,3812,-1,3812,3811,3815,-1,3808,3812,3817,-1,3817,3813,3808,-1,3807,3814,3818,-1,3818,3811,3807,-1,3819,3820,3816,-1,3816,3815,3819,-1,3821,3817,3812,-1,3812,3816,3821,-1,3811,3818,3822,-1,3822,3815,3811,-1,3823,3824,3820,-1,3820,3819,3823,-1,3816,3820,3825,-1,3825,3821,3816,-1,3815,3822,3826,-1,3826,3819,3815,-1,3827,3828,3824,-1,3824,3823,3827,-1,3820,3824,3829,-1,3829,3825,3820,-1,3819,3826,3830,-1,3830,3823,3819,-1,3831,3832,3828,-1,3828,3827,3831,-1,3824,3828,3833,-1,3833,3829,3824,-1,3823,3830,3834,-1,3834,3827,3823,-1,3762,3761,3832,-1,3832,3831,3762,-1,3835,3833,3828,-1,3828,3832,3835,-1,3827,3834,3836,-1,3836,3831,3827,-1,3832,3761,3760,-1,3760,3835,3832,-1,3836,3757,3762,-1,3762,3831,3836,-1,3837,3835,3760,-1,3760,3759,3837,-1,3838,3833,3835,-1,3835,3837,3838,-1,3837,3759,3758,-1,3758,3839,3837,-1,3840,3829,3833,-1,3833,3838,3840,-1,3841,3838,3837,-1,3837,3839,3841,-1,3842,3825,3829,-1,3829,3840,3842,-1,3843,3840,3838,-1,3838,3841,3843,-1,3844,3821,3825,-1,3825,3842,3844,-1,3845,3842,3840,-1,3840,3843,3845,-1,3846,3817,3821,-1,3821,3844,3846,-1,3847,3844,3842,-1,3842,3845,3847,-1,3848,3813,3817,-1,3817,3846,3848,-1,3849,3846,3844,-1,3844,3847,3849,-1,3850,3809,3813,-1,3813,3848,3850,-1,3851,3848,3846,-1,3846,3849,3851,-1,3852,3806,3809,-1,3809,3850,3852,-1,3850,3848,3851,-1,3851,3853,3850,-1,3854,3801,3806,-1,3806,3852,3854,-1,3855,3852,3850,-1,3850,3853,3855,-1,3854,3856,3798,-1,3798,3801,3854,-1,3854,3852,3855,-1,3855,3857,3854,-1,3858,3856,3854,-1,3854,3857,3858,-1,3859,3770,3798,-1,3798,3856,3859,-1,3859,3772,3765,-1,3765,3770,3859,-1,3859,3856,3858,-1,3858,3860,3859,-1,3772,3859,3860,-1,3860,3861,3772,-1,3862,3771,3772,-1,3772,3861,3862,-1,3782,3777,3771,-1,3771,3862,3782,-1,3785,3780,3776,-1,3776,3779,3785,-1,3786,3863,3787,-1,3787,3784,3786,-1,3787,3864,3865,-1,3865,3788,3787,-1,3863,3866,3864,-1,3864,3787,3863,-1,3864,3781,3782,-1,3782,3865,3864,-1,3788,3865,3867,-1,3867,3789,3788,-1,3866,3868,3781,-1,3781,3864,3866,-1,3865,3782,3862,-1,3862,3867,3865,-1,3868,3778,3775,-1,3775,3781,3868,-1,3789,3867,3869,-1,3869,3791,3789,-1,3867,3862,3861,-1,3861,3869,3867,-1,3869,3870,3794,-1,3794,3791,3869,-1,3861,3860,3870,-1,3870,3869,3861,-1,3870,3871,3795,-1,3795,3794,3870,-1,3860,3858,3871,-1,3871,3870,3860,-1,3795,3871,3872,-1,3872,3802,3795,-1,3871,3858,3857,-1,3857,3872,3871,-1,3872,3873,3803,-1,3803,3802,3872,-1,3857,3855,3873,-1,3873,3872,3857,-1,3803,3873,3874,-1,3874,3810,3803,-1,3873,3855,3853,-1,3853,3874,3873,-1,3874,3875,3814,-1,3814,3810,3874,-1,3853,3851,3875,-1,3875,3874,3853,-1,3814,3875,3876,-1,3876,3818,3814,-1,3875,3851,3849,-1,3849,3876,3875,-1,3818,3876,3877,-1,3877,3822,3818,-1,3876,3849,3847,-1,3847,3877,3876,-1,3822,3877,3878,-1,3878,3826,3822,-1,3877,3847,3845,-1,3845,3878,3877,-1,3826,3878,3879,-1,3879,3830,3826,-1,3878,3845,3843,-1,3843,3879,3878,-1,3830,3879,3880,-1,3880,3834,3830,-1,3879,3843,3841,-1,3841,3880,3879,-1,3834,3880,3881,-1,3881,3836,3834,-1,3880,3841,3839,-1,3839,3881,3880,-1,3881,3756,3757,-1,3757,3836,3881,-1,3839,3758,3756,-1,3756,3881,3839,-1,3882,3883,2493,-1,2493,2494,3882,-1,3884,2492,2493,-1,2493,3883,3884,-1,2490,2492,3884,-1,3884,3885,2490,-1,3886,2491,2490,-1,2490,3885,3886,-1,3887,2496,2491,-1,2491,3886,3887,-1,3888,2495,2496,-1,2496,3887,3888,-1,3882,2494,2495,-1,2495,3888,3882,-1,3889,3890,3891,-1,3891,3892,3889,-1,3893,3890,3889,-1,3889,3894,3893,-1,3895,3896,3891,-1,3891,3890,3895,-1,3897,3892,3891,-1,3891,3898,3897,-1,3779,3889,3892,-1,3892,3785,3779,-1,3894,3889,3779,-1,3779,3778,3894,-1,3786,3785,3892,-1,3892,3897,3786,-1,3897,3899,3863,-1,3863,3786,3897,-1,3898,3891,3896,-1,3896,3900,3898,-1,3898,3901,3899,-1,3899,3897,3898,-1,3896,3902,3903,-1,3903,3900,3896,-1,3898,3900,3904,-1,3904,3901,3898,-1,3895,3905,3902,-1,3902,3896,3895,-1,3903,3902,3906,-1,3906,3907,3903,-1,3900,3903,3908,-1,3908,3904,3900,-1,3909,3906,3902,-1,3902,3905,3909,-1,3906,3910,3911,-1,3911,3907,3906,-1,3907,3912,3908,-1,3908,3903,3907,-1,3909,3913,3910,-1,3910,3906,3909,-1,3911,3910,3914,-1,3914,3915,3911,-1,3907,3911,3916,-1,3916,3912,3907,-1,3913,3917,3914,-1,3914,3910,3913,-1,3915,3914,3918,-1,3918,3919,3915,-1,3915,3920,3916,-1,3916,3911,3915,-1,3918,3914,3917,-1,3917,3921,3918,-1,3919,3918,3922,-1,3922,3923,3919,-1,3915,3919,3924,-1,3924,3920,3915,-1,3921,3925,3922,-1,3922,3918,3921,-1,3923,3922,3926,-1,3926,3927,3923,-1,3923,3928,3924,-1,3924,3919,3923,-1,3926,3922,3925,-1,3925,3929,3926,-1,3927,3926,3930,-1,3930,3931,3927,-1,3927,3932,3928,-1,3928,3923,3927,-1,3929,3933,3930,-1,3930,3926,3929,-1,3931,3930,3934,-1,3934,3935,3931,-1,3931,3936,3932,-1,3932,3927,3931,-1,3933,3937,3934,-1,3934,3930,3933,-1,3935,3934,3938,-1,3938,3939,3935,-1,3935,3940,3936,-1,3936,3931,3935,-1,3937,3941,3938,-1,3938,3934,3937,-1,3939,3938,3942,-1,3942,3943,3939,-1,3939,3944,3940,-1,3940,3935,3939,-1,3942,3938,3941,-1,3941,3945,3942,-1,3943,3942,3883,-1,3883,3882,3943,-1,3943,3946,3944,-1,3944,3939,3943,-1,3945,3884,3883,-1,3883,3942,3945,-1,3943,3882,3888,-1,3888,3946,3943,-1,3885,3884,3945,-1,3945,3947,3885,-1,3947,3945,3941,-1,3941,3948,3947,-1,3949,3886,3885,-1,3885,3947,3949,-1,3948,3941,3937,-1,3937,3950,3948,-1,3949,3947,3948,-1,3948,3951,3949,-1,3950,3937,3933,-1,3933,3952,3950,-1,3951,3948,3950,-1,3950,3953,3951,-1,3952,3933,3929,-1,3929,3954,3952,-1,3953,3950,3952,-1,3952,3955,3953,-1,3954,3929,3925,-1,3925,3956,3954,-1,3955,3952,3954,-1,3954,3957,3955,-1,3956,3925,3921,-1,3921,3958,3956,-1,3957,3954,3956,-1,3956,3959,3957,-1,3958,3921,3917,-1,3917,3960,3958,-1,3959,3956,3958,-1,3958,3961,3959,-1,3960,3917,3913,-1,3913,3962,3960,-1,3963,3961,3958,-1,3958,3960,3963,-1,3962,3913,3909,-1,3909,3964,3962,-1,3963,3960,3962,-1,3962,3965,3963,-1,3909,3905,3966,-1,3966,3964,3909,-1,3967,3965,3962,-1,3962,3964,3967,-1,3966,3905,3895,-1,3895,3968,3966,-1,3967,3964,3966,-1,3966,3969,3967,-1,3895,3890,3893,-1,3893,3968,3895,-1,3970,3969,3966,-1,3966,3968,3970,-1,3971,3970,3968,-1,3968,3893,3971,-1,3971,3893,3894,-1,3894,3972,3971,-1,3972,3894,3778,-1,3778,3868,3972,-1,3899,3973,3866,-1,3866,3863,3899,-1,3973,3972,3868,-1,3868,3866,3973,-1,3901,3974,3973,-1,3973,3899,3901,-1,3974,3971,3972,-1,3972,3973,3974,-1,3901,3904,3975,-1,3975,3974,3901,-1,3974,3975,3970,-1,3970,3971,3974,-1,3904,3908,3976,-1,3976,3975,3904,-1,3975,3976,3969,-1,3969,3970,3975,-1,3912,3977,3976,-1,3976,3908,3912,-1,3977,3967,3969,-1,3969,3976,3977,-1,3912,3916,3978,-1,3978,3977,3912,-1,3977,3978,3965,-1,3965,3967,3977,-1,3920,3979,3978,-1,3978,3916,3920,-1,3979,3963,3965,-1,3965,3978,3979,-1,3920,3924,3980,-1,3980,3979,3920,-1,3979,3980,3961,-1,3961,3963,3979,-1,3928,3981,3980,-1,3980,3924,3928,-1,3981,3959,3961,-1,3961,3980,3981,-1,3932,3982,3981,-1,3981,3928,3932,-1,3982,3957,3959,-1,3959,3981,3982,-1,3936,3983,3982,-1,3982,3932,3936,-1,3983,3955,3957,-1,3957,3982,3983,-1,3940,3984,3983,-1,3983,3936,3940,-1,3984,3953,3955,-1,3955,3983,3984,-1,3944,3985,3984,-1,3984,3940,3944,-1,3985,3951,3953,-1,3953,3984,3985,-1,3946,3986,3985,-1,3985,3944,3946,-1,3986,3949,3951,-1,3951,3985,3986,-1,3946,3888,3887,-1,3887,3986,3946,-1,3986,3887,3886,-1,3886,3949,3986,-1,3987,3988,3989,-1,3989,3990,3987,-1,3991,3992,3993,-1,3993,3994,3991,-1,3995,3996,3988,-1,3988,3987,3995,-1,3994,3993,3996,-1,3996,3995,3994,-1,2500,2502,3997,-1,3997,2758,2500,-1,2771,3998,3992,-1,3992,3991,2771,-1,2769,3999,3998,-1,3998,2771,2769,-1,4000,4001,3999,-1,3999,2769,4000,-1,4002,4003,4001,-1,4001,4000,4002,-1,4004,4005,4003,-1,4003,4002,4004,-1,4006,4007,4005,-1,4005,4004,4006,-1,2758,3997,4007,-1,4007,4006,2758,-1,4008,4009,2502,-1,2502,2503,4008,-1,4010,4011,4009,-1,4009,4008,4010,-1,3990,3989,4011,-1,4011,4010,3990,-1,4003,4012,4013,-1,4013,4001,4003,-1,4005,4014,4012,-1,4012,4003,4005,-1,4007,2508,4014,-1,4014,4005,4007,-1,3997,2506,2508,-1,2508,4007,3997,-1,2502,4015,2506,-1,2506,3997,2502,-1,4001,4013,2513,-1,2513,3999,4001,-1,3999,2513,2512,-1,2512,3998,3999,-1,3998,2512,4016,-1,4016,3992,3998,-1,3992,4016,4017,-1,4017,3993,3992,-1,3993,4017,4018,-1,4018,3996,3993,-1,3996,4018,4019,-1,4019,3988,3996,-1,3988,4019,4020,-1,4020,3989,3988,-1,3989,4020,4021,-1,4021,4011,3989,-1,4011,4021,4022,-1,4022,4009,4011,-1,4009,4022,4015,-1,4015,2502,4009,-1,4023,2509,4020,-1,4020,4019,4023,-1,4023,4024,2510,-1,2510,2509,4023,-1,2509,2511,4021,-1,4021,4020,2509,-1,4023,4019,4018,-1,4018,4025,4023,-1,4018,4017,4016,-1,4016,4025,4018,-1,4016,2512,2514,-1,2514,4025,4016,-1,2507,2506,4015,-1,4015,4022,2507,-1,2511,2507,4022,-1,4022,4021,2511,-1,2507,2511,4014,-1,4014,2508,2507,-1,2511,2510,4012,-1,4012,4014,2511,-1,4023,4025,2514,-1,2514,4024,4023,-1,2510,4024,4013,-1,4013,4012,2510,-1,4024,2514,2513,-1,2513,4013,4024,-1,2688,4026,2497,-1,2497,2499,2688,-1,4027,4026,2688,-1,2688,4028,4027,-1,4029,4027,4028,-1,4028,4030,4029,-1,4029,4030,4031,-1,4031,4032,4029,-1,4033,4034,4032,-1,4032,4031,4033,-1,2515,4035,2517,-1,2517,2505,2515,-1,2498,2497,2516,-1,2516,2505,2498,-1,2516,4036,4037,-1,4037,2515,2516,-1,2519,2504,2517,-1,2517,2520,2519,-1,4037,4038,4035,-1,4035,2515,4037,-1,2520,2517,4035,-1,4035,4039,2520,-1,4040,4041,4038,-1,4038,4037,4040,-1,4039,4035,4038,-1,4038,4042,4039,-1,4043,4044,4041,-1,4041,4040,4043,-1,4042,4038,4041,-1,4041,4045,4042,-1,4036,4046,4040,-1,4040,4037,4036,-1,4044,4043,4047,-1,4047,4048,4044,-1,4045,4041,4044,-1,4044,4049,4045,-1,4046,4050,4043,-1,4043,4040,4046,-1,4050,4051,4047,-1,4047,4043,4050,-1,4052,4053,4048,-1,4048,4047,4052,-1,4049,4044,4048,-1,4048,4054,4049,-1,4055,4056,4053,-1,4053,4052,4055,-1,4054,4048,4053,-1,4053,4057,4054,-1,4051,4058,4052,-1,4052,4047,4051,-1,4032,4034,4058,-1,4058,4051,4032,-1,4055,4052,4058,-1,4058,4059,4055,-1,4029,4032,4051,-1,4051,4050,4029,-1,4027,4029,4050,-1,4050,4046,4027,-1,4026,4027,4046,-1,4046,4036,4026,-1,2497,4026,4036,-1,4036,2516,2497,-1,4060,4061,4034,-1,4034,4033,4060,-1,4059,4058,4034,-1,4034,4061,4059,-1,2532,2521,2504,-1,2504,2519,2532,-1,4057,4053,4056,-1,4056,4062,4057,-1,4063,4054,4057,-1,4057,4064,4063,-1,4065,4049,4054,-1,4054,4063,4065,-1,4066,4045,4049,-1,4049,4065,4066,-1,4067,4042,4045,-1,4045,4066,4067,-1,4068,4039,4042,-1,4042,4067,4068,-1,2518,2520,4039,-1,4039,4068,2518,-1,2530,4069,4070,-1,4070,4071,2530,-1,2529,4072,4069,-1,4069,2530,2529,-1,4070,4069,4073,-1,4073,4074,4070,-1,4075,4071,4070,-1,4070,4076,4075,-1,4077,4078,2530,-1,2530,4071,4077,-1,4079,4080,2522,-1,2522,2521,4079,-1,4081,4082,4080,-1,4080,4079,4081,-1,4083,2523,2522,-1,2522,4080,4083,-1,4084,4079,2521,-1,2521,2532,4084,-1,4074,4073,4082,-1,4082,4081,4074,-1,4085,4083,4080,-1,4080,4082,4085,-1,4086,4081,4079,-1,4079,4084,4086,-1,4087,4085,4082,-1,4082,4073,4087,-1,4088,4074,4081,-1,4081,4086,4088,-1,4072,4087,4073,-1,4073,4069,4072,-1,4076,4070,4074,-1,4074,4088,4076,-1,4089,2568,4078,-1,4078,4077,4089,-1,4090,2528,2530,-1,2530,4078,4090,-1,4091,4077,4071,-1,4071,4075,4091,-1,4092,2524,2523,-1,2523,4083,4092,-1,4083,4085,2526,-1,2526,4092,4083,-1,4085,4087,2527,-1,2527,2526,4085,-1,2527,4093,4094,-1,4094,2525,2527,-1,4093,4095,4096,-1,4096,4094,4093,-1,4096,4095,4097,-1,4097,4098,4096,-1,4097,4099,4100,-1,4100,4098,4097,-1,4087,4072,4093,-1,4093,2527,4087,-1,4072,2529,4095,-1,4095,4093,4072,-1,2529,2528,4097,-1,4097,4095,2529,-1,2528,4090,4099,-1,4099,4097,2528,-1,4078,2568,2570,-1,2570,4090,4078,-1,4101,4099,4090,-1,4090,2570,4101,-1,4102,4100,4099,-1,4099,4101,4102,-1,4103,4084,2532,-1,2532,2531,4103,-1,4104,4086,4084,-1,4084,4103,4104,-1,4105,4088,4086,-1,4086,4104,4105,-1,4106,4076,4088,-1,4088,4105,4106,-1,4107,4075,4076,-1,4076,4106,4107,-1,4108,4089,4077,-1,4077,4091,4108,-1,4109,4091,4075,-1,4075,4107,4109,-1,4110,4111,4112,-1,4112,4113,4110,-1,4114,4115,4111,-1,4111,4110,4114,-1,4116,4112,4111,-1,4111,4117,4116,-1,4113,4112,4118,-1,4118,4119,4113,-1,4113,4120,4121,-1,4121,4110,4113,-1,4122,4123,4115,-1,4115,4114,4122,-1,4117,4111,4115,-1,4115,4124,4117,-1,4110,4121,4125,-1,4125,4114,4110,-1,4123,4122,2533,-1,2533,2534,4123,-1,4124,4115,4123,-1,4123,4126,4124,-1,4114,4125,2533,-1,2533,4122,4114,-1,4127,4118,4112,-1,4112,4116,4127,-1,4128,4129,4119,-1,4119,4118,4128,-1,4119,4130,4120,-1,4120,4113,4119,-1,4129,4128,4131,-1,4131,4132,4129,-1,4129,4133,4130,-1,4130,4119,4129,-1,4134,4128,4118,-1,4118,4127,4134,-1,4135,4131,4128,-1,4128,4134,4135,-1,4132,4131,4136,-1,4136,4137,4132,-1,4132,4138,4133,-1,4133,4129,4132,-1,4125,4103,2531,-1,2531,2533,4125,-1,4121,4104,4103,-1,4103,4125,4121,-1,4120,4105,4104,-1,4104,4121,4120,-1,4130,4106,4105,-1,4105,4120,4130,-1,4133,4107,4106,-1,4106,4130,4133,-1,4139,4108,4091,-1,4091,4109,4139,-1,4138,4109,4107,-1,4107,4133,4138,-1,4064,4057,4062,-1,4062,4140,4064,-1,4141,4063,4064,-1,4064,4142,4141,-1,4143,4065,4063,-1,4063,4141,4143,-1,4144,4066,4065,-1,4065,4143,4144,-1,4145,4067,4066,-1,4066,4144,4145,-1,4146,4068,4067,-1,4067,4145,4146,-1,2535,2518,4068,-1,4068,4146,2535,-1,4142,4064,4140,-1,4140,4147,4142,-1,4148,4141,4142,-1,4142,4149,4148,-1,4150,4143,4141,-1,4141,4148,4150,-1,4151,4144,4143,-1,4143,4150,4151,-1,4152,4145,4144,-1,4144,4151,4152,-1,4153,4146,4145,-1,4145,4152,4153,-1,4154,2535,4146,-1,4146,4153,4154,-1,4155,4139,4109,-1,4109,4138,4155,-1,4137,4155,4138,-1,4138,4132,4137,-1,4149,4142,4147,-1,4147,4156,4149,-1,4134,4148,4149,-1,4149,4135,4134,-1,4127,4150,4148,-1,4148,4134,4127,-1,4116,4151,4150,-1,4150,4127,4116,-1,4117,4152,4151,-1,4151,4116,4117,-1,4124,4153,4152,-1,4152,4117,4124,-1,2536,2535,4154,-1,4154,4126,2536,-1,4126,4154,4153,-1,4153,4124,4126,-1,4126,4123,2534,-1,2534,2536,4126,-1,4135,4149,4156,-1,4156,4157,4135,-1,4157,4136,4131,-1,4131,4135,4157,-1,4158,4159,4160,-1,4160,4161,4158,-1,4162,4163,4164,-1,4164,4165,4162,-1,4161,4160,4166,-1,4166,4167,4161,-1,4167,4166,4163,-1,4163,4162,4167,-1,3146,4168,2541,-1,2541,2540,3146,-1,4165,4164,4169,-1,4169,3158,4165,-1,3158,4169,4170,-1,4170,3157,3158,-1,3157,4170,4171,-1,4171,4172,3157,-1,4172,4171,4173,-1,4173,4174,4172,-1,4174,4173,4175,-1,4175,4176,4174,-1,4176,4175,4177,-1,4177,4178,4176,-1,4178,4177,4168,-1,4168,3146,4178,-1,2543,2541,4179,-1,4179,4180,2543,-1,4180,4179,4181,-1,4181,4182,4180,-1,4182,4181,4159,-1,4159,4158,4182,-1,4171,4183,4184,-1,4184,4173,4171,-1,4173,4184,4185,-1,4185,4175,4173,-1,4175,4185,2546,-1,2546,4177,4175,-1,4177,2546,2548,-1,2548,4168,4177,-1,4168,2548,4186,-1,4186,2541,4168,-1,4170,2553,4183,-1,4183,4171,4170,-1,4169,2554,2553,-1,2553,4170,4169,-1,4164,4187,2554,-1,2554,4169,4164,-1,4163,4188,4187,-1,4187,4164,4163,-1,4166,4189,4188,-1,4188,4163,4166,-1,4160,4190,4189,-1,4189,4166,4160,-1,4159,4191,4190,-1,4190,4160,4159,-1,4181,4192,4191,-1,4191,4159,4181,-1,4179,4193,4192,-1,4192,4181,4179,-1,2541,4186,4193,-1,4193,4179,2541,-1,4190,4191,2551,-1,2551,4194,4190,-1,4191,4192,2549,-1,2549,2551,4191,-1,2551,2550,4195,-1,4195,4194,2551,-1,4196,4189,4190,-1,4190,4194,4196,-1,4196,4187,4188,-1,4188,4189,4196,-1,4196,2552,2554,-1,2554,4187,4196,-1,4193,4186,2548,-1,2548,2547,4193,-1,4192,4193,2547,-1,2547,2549,4192,-1,2546,4185,2549,-1,2549,2547,2546,-1,4185,4184,2550,-1,2550,2549,4185,-1,4195,2552,4196,-1,4196,4194,4195,-1,4184,4183,4195,-1,4195,2550,4184,-1,4183,2553,2552,-1,2552,4195,4183,-1,2537,2539,4197,-1,4197,3084,2537,-1,4198,3084,4197,-1,4197,4199,4198,-1,4200,4198,4199,-1,4199,4201,4200,-1,4061,4060,4200,-1,4200,4201,4061,-1,2544,2555,2539,-1,2539,2538,2544,-1,2544,2557,4202,-1,4202,2556,2544,-1,2556,4203,4204,-1,4204,2555,2556,-1,2558,2557,2545,-1,2545,2559,2558,-1,4205,4202,2557,-1,2557,2558,4205,-1,2556,4202,4206,-1,4206,4203,2556,-1,4207,4206,4202,-1,4202,4205,4207,-1,4203,4206,4208,-1,4208,4209,4203,-1,4210,4208,4206,-1,4206,4207,4210,-1,4209,4208,4211,-1,4211,4212,4209,-1,4203,4209,4213,-1,4213,4204,4203,-1,4214,4211,4208,-1,4208,4210,4214,-1,4056,4055,4212,-1,4212,4211,4056,-1,4209,4212,4215,-1,4215,4213,4209,-1,4212,4055,4059,-1,4059,4215,4212,-1,4062,4056,4211,-1,4211,4214,4062,-1,4215,4059,4061,-1,4061,4201,4215,-1,4213,4215,4201,-1,4201,4199,4213,-1,4204,4213,4199,-1,4199,4197,4204,-1,2555,4204,4197,-1,4197,2539,2555,-1,2559,2545,2562,-1,2562,2571,2559,-1,4140,4062,4214,-1,4214,4216,4140,-1,4216,4214,4210,-1,4210,4217,4216,-1,4217,4210,4207,-1,4207,4218,4217,-1,4218,4207,4205,-1,4205,4219,4218,-1,4219,4205,2558,-1,2558,2560,4219,-1,4089,4220,4221,-1,4221,2568,4089,-1,4222,4220,4089,-1,4089,4108,4222,-1,4223,4224,4221,-1,4221,4220,4223,-1,2568,4221,4225,-1,4225,2569,2568,-1,2562,2561,4226,-1,4226,4227,2562,-1,4226,2561,2563,-1,2563,4228,4226,-1,4227,4226,4229,-1,4229,4230,4227,-1,2571,2562,4227,-1,4227,4231,2571,-1,4229,4226,4228,-1,4228,4232,4229,-1,4230,4229,4224,-1,4224,4223,4230,-1,4231,4227,4230,-1,4230,4233,4231,-1,4224,4229,4232,-1,4232,4234,4224,-1,4233,4230,4223,-1,4223,4235,4233,-1,4221,4224,4234,-1,4234,4225,4221,-1,4235,4223,4220,-1,4220,4222,4235,-1,4228,2563,2564,-1,2564,4236,4228,-1,4236,2566,4232,-1,4232,4228,4236,-1,2566,2565,4234,-1,4234,4232,2566,-1,2567,4237,4238,-1,4238,2565,2567,-1,4237,4239,4240,-1,4240,4238,4237,-1,4102,4101,4240,-1,4240,4239,4102,-1,2565,4238,4225,-1,4225,4234,2565,-1,4238,4240,2569,-1,2569,4225,4238,-1,4240,4101,2570,-1,2570,2569,4240,-1,2572,2571,4231,-1,4231,4241,2572,-1,4241,4231,4233,-1,4233,4242,4241,-1,4242,4233,4235,-1,4235,4243,4242,-1,4243,4235,4222,-1,4222,4244,4243,-1,4244,4222,4108,-1,4108,4139,4244,-1,4245,4246,4247,-1,4247,4248,4245,-1,4249,4250,4246,-1,4246,4245,4249,-1,4251,4247,4246,-1,4246,4252,4251,-1,4248,4247,4253,-1,4253,4254,4248,-1,4248,4255,4256,-1,4256,4245,4248,-1,4257,4253,4247,-1,4247,4251,4257,-1,4254,4253,4258,-1,4258,4259,4254,-1,4254,4260,4255,-1,4255,4248,4254,-1,4261,4258,4253,-1,4253,4257,4261,-1,2574,2573,4259,-1,4259,4258,2574,-1,4259,2573,4260,-1,4260,4254,4259,-1,4250,4249,4137,-1,4137,4136,4250,-1,4252,4246,4250,-1,4250,4262,4252,-1,4245,4256,4263,-1,4263,4249,4245,-1,4249,4263,4155,-1,4155,4137,4249,-1,4262,4250,4136,-1,4136,4157,4262,-1,2573,2572,4241,-1,4241,4260,2573,-1,4260,4241,4242,-1,4242,4255,4260,-1,4255,4242,4243,-1,4243,4256,4255,-1,4256,4243,4244,-1,4244,4263,4256,-1,4263,4244,4139,-1,4139,4155,4263,-1,4147,4140,4216,-1,4216,4264,4147,-1,4264,4216,4217,-1,4217,4265,4264,-1,4265,4217,4218,-1,4218,4266,4265,-1,4266,4218,4219,-1,4219,4267,4266,-1,4267,4219,2560,-1,2560,2575,4267,-1,4156,4147,4264,-1,4264,4268,4156,-1,4268,4264,4265,-1,4265,4269,4268,-1,4269,4265,4266,-1,4266,4270,4269,-1,4270,4266,4267,-1,4267,4271,4270,-1,4271,4267,2575,-1,2575,4272,4271,-1,4157,4156,4268,-1,4268,4262,4157,-1,4262,4268,4269,-1,4269,4252,4262,-1,4252,4269,4270,-1,4270,4251,4252,-1,4251,4270,4271,-1,4271,4257,4251,-1,4261,4272,2575,-1,2575,2576,4261,-1,4257,4271,4272,-1,4272,4261,4257,-1,2576,2574,4258,-1,4258,4261,2576,-1,2577,2588,2590,-1,2590,2578,2577,-1,2588,2577,4273,-1,4273,2589,2588,-1,2588,2587,2591,-1,2591,2590,2588,-1,2593,4274,2578,-1,2578,2590,2593,-1,2579,2578,4274,-1,4274,4275,2579,-1,2579,4275,4273,-1,4273,2577,2579,-1,2582,2581,2584,-1,2584,2583,2582,-1,2581,4276,4277,-1,4277,2584,2581,-1,2583,4278,4279,-1,4279,2582,2583,-1,4278,2583,2585,-1,2585,4280,4278,-1,2587,4281,4282,-1,4282,2591,2587,-1,2591,4282,4283,-1,4283,2592,2591,-1,2582,4279,4284,-1,4284,2580,2582,-1,4279,4281,4285,-1,4285,4284,4279,-1,4284,4286,2594,-1,2594,2580,4284,-1,4281,4279,4278,-1,4278,4282,4281,-1,4281,2587,2589,-1,2589,4285,4281,-1,4285,4287,4286,-1,4286,4284,4285,-1,2589,4273,4287,-1,4287,4285,2589,-1,4282,4278,4280,-1,4280,4283,4282,-1,4283,4288,2593,-1,2593,2592,4283,-1,4280,4289,4288,-1,4288,4283,4280,-1,2585,2586,4289,-1,4289,4280,2585,-1,2594,4290,4276,-1,4276,2581,2594,-1,4277,4276,4290,-1,4290,4291,4277,-1,2584,4277,4291,-1,4291,2586,2584,-1,4273,4275,4292,-1,4292,4287,4273,-1,4275,4274,4293,-1,4293,4292,4275,-1,4294,4295,4292,-1,4292,4293,4294,-1,4291,4290,4295,-1,4295,4294,4291,-1,4287,4292,4295,-1,4295,4286,4287,-1,4289,4294,4293,-1,4293,4288,4289,-1,4288,4293,4274,-1,4274,2593,4288,-1,4286,4295,4290,-1,4290,2594,4286,-1,2586,4291,4294,-1,4294,4289,2586,-1,2595,4296,4297,-1,4297,2600,2595,-1,4298,4296,2595,-1,2595,2597,4298,-1,4298,4299,4297,-1,4297,4296,4298,-1,4297,4299,2598,-1,2598,2600,4297,-1,2599,2596,2595,-1,2595,2600,2599,-1,4299,4298,4300,-1,4300,4301,4299,-1,4300,4298,2597,-1,2597,2607,4300,-1,4302,4303,4301,-1,4301,4300,4302,-1,4299,4301,2604,-1,2604,2598,4299,-1,4303,4302,4304,-1,4304,4305,4303,-1,4304,4302,4306,-1,4306,4307,4304,-1,4308,4309,4305,-1,4305,4304,4308,-1,4303,4305,4310,-1,4310,4311,4303,-1,4301,4303,4311,-1,4311,2604,4301,-1,4302,4300,2607,-1,2607,4306,4302,-1,4309,4308,4312,-1,4312,4313,4309,-1,4312,4308,4314,-1,4314,2611,4312,-1,4313,4312,4315,-1,4315,4316,4313,-1,4309,4313,2614,-1,2614,4317,4309,-1,4305,4309,4317,-1,4317,4310,4305,-1,4308,4304,4307,-1,4307,4314,4308,-1,4315,4312,2611,-1,2611,2612,4315,-1,4316,4315,2612,-1,2612,2613,4316,-1,4313,4316,2613,-1,2613,2614,4313,-1,4318,4319,2596,-1,2596,2599,4318,-1,4319,4318,4320,-1,4320,4321,4319,-1,2605,4322,4320,-1,4320,4318,2605,-1,4323,4324,4321,-1,4321,4320,4323,-1,4325,2606,4319,-1,4319,4321,4325,-1,2606,2597,2596,-1,2596,4319,2606,-1,2598,2605,4318,-1,4318,2599,2598,-1,4324,4323,2602,-1,2602,2609,4324,-1,4326,2603,2602,-1,2602,4323,4326,-1,2601,2610,2609,-1,2609,2602,2601,-1,2608,4327,4324,-1,4324,2609,2608,-1,4327,4325,4321,-1,4321,4324,4327,-1,4322,4326,4323,-1,4323,4320,4322,-1,4310,4317,2603,-1,2603,4326,4310,-1,4311,4310,4326,-1,4326,4322,4311,-1,2604,4311,4322,-1,4322,2605,2604,-1,4306,2607,2606,-1,2606,4325,4306,-1,4307,4306,4325,-1,4325,4327,4307,-1,4314,4307,4327,-1,4327,2608,4314,-1,2611,4314,2608,-1,2608,2610,2611,-1,2613,2612,2610,-1,2610,2601,2613,-1,4317,2614,2601,-1,2601,2603,4317,-1,2360,2367,2369,-1,2369,2361,2360,-1,2616,2615,4328,-1,4328,4329,2616,-1,4330,4331,4328,-1,4328,2615,4330,-1,4332,4333,4329,-1,4329,4328,4332,-1,2616,4329,2934,-1,2934,4334,2616,-1,2870,4335,2619,-1,2619,2618,2870,-1,2620,2624,4336,-1,4336,2618,2620,-1,2623,4337,2625,-1,2625,2620,2623,-1,4338,4339,2624,-1,2624,2625,4338,-1,4339,4340,4336,-1,4336,2624,4339,-1,2869,2870,2618,-1,2618,4336,2869,-1,3990,2626,2628,-1,2628,3987,3990,-1,4010,4341,2626,-1,2626,3990,4010,-1,3995,3987,2628,-1,2628,4342,3995,-1,3994,4343,4344,-1,4344,3991,3994,-1,3994,3995,4342,-1,4342,4343,3994,-1,4345,4346,4344,-1,4344,4343,4345,-1,2772,2771,3991,-1,3991,4344,2772,-1,4341,2765,2627,-1,2627,2626,4341,-1,2628,2627,4347,-1,4347,2823,2628,-1,4342,2628,2823,-1,2823,2762,4342,-1,2629,2820,4348,-1,4348,2630,2629,-1,4349,2631,2630,-1,2630,4350,4349,-1,4351,4352,2634,-1,2634,2633,4351,-1,4353,2643,2635,-1,2635,2634,4353,-1,2638,4353,2634,-1,2634,2640,2638,-1,2651,4353,2638,-1,2638,4354,2651,-1,4352,2687,2640,-1,2640,2634,4352,-1,4353,2651,4355,-1,4355,2643,4353,-1,2636,4356,2646,-1,2646,2645,2636,-1,2635,2642,4356,-1,4356,2636,2635,-1,4356,4357,2873,-1,2873,2646,4356,-1,2645,4351,2633,-1,2633,2636,2645,-1,4358,4357,4356,-1,4356,2642,4358,-1,2903,2874,2873,-1,2873,4357,2903,-1,2646,2873,2824,-1,2824,2644,2646,-1,2647,4355,4359,-1,4359,2648,2647,-1,4360,4361,2649,-1,2649,2648,4360,-1,2649,4358,2642,-1,2642,2647,2649,-1,2642,2643,4355,-1,4355,2647,2642,-1,4355,2651,2650,-1,2650,4359,4355,-1,2648,4359,4362,-1,4362,4360,2648,-1,4363,4362,4359,-1,4359,2650,4363,-1,4364,4365,2653,-1,2653,2652,4364,-1,4366,4363,2650,-1,2650,2653,4366,-1,4364,2677,4367,-1,4367,4365,4364,-1,4366,2653,4365,-1,4365,4368,4366,-1,4354,4364,2652,-1,2652,2651,4354,-1,4367,4369,4368,-1,4368,4365,4367,-1,4367,4370,4371,-1,4371,4369,4367,-1,4368,4369,2657,-1,2657,2659,4368,-1,2848,4372,2656,-1,2656,2655,2848,-1,2850,4373,4372,-1,4372,2848,2850,-1,4374,2656,4372,-1,4372,4375,4374,-1,4376,2849,2848,-1,2848,2655,4376,-1,2655,2654,2657,-1,2657,4376,2655,-1,4374,2658,2654,-1,2654,2656,4374,-1,2850,2821,4377,-1,4377,4373,2850,-1,2819,2821,2850,-1,2850,2849,2819,-1,2821,2820,2629,-1,2629,4377,2821,-1,4375,4372,4373,-1,4373,4377,4375,-1,2661,4378,4379,-1,4379,2662,2661,-1,2662,2854,2855,-1,2855,2663,2662,-1,2663,4380,4381,-1,4381,2661,2663,-1,4382,4378,2661,-1,2661,4381,4382,-1,4378,4383,4384,-1,4384,4379,4378,-1,4379,2868,2854,-1,2854,2662,4379,-1,4378,4382,4385,-1,4385,4383,4378,-1,4384,4383,2941,-1,2941,2943,4384,-1,4379,4384,2866,-1,2866,2868,4379,-1,2664,2666,2668,-1,2668,2670,2664,-1,2670,4386,4387,-1,4387,2664,2670,-1,2665,2671,2667,-1,2667,2666,2665,-1,2760,2669,2668,-1,2668,2667,2760,-1,2671,2665,4388,-1,4388,2672,2671,-1,2672,2914,2913,-1,2913,2673,2672,-1,2671,2673,4389,-1,4389,2667,2671,-1,2665,2664,4387,-1,4387,4388,2665,-1,4390,2914,2672,-1,2672,4388,4390,-1,4391,4390,4388,-1,4388,4387,4391,-1,2637,2675,2674,-1,2674,2676,2637,-1,2498,2675,2637,-1,2637,2639,2498,-1,2638,2637,2676,-1,2676,4354,2638,-1,4364,4354,2676,-1,2676,2677,4364,-1,2692,2679,2678,-1,2678,2690,2692,-1,4392,2680,2679,-1,2679,2682,4392,-1,2694,2678,2680,-1,2680,2696,2694,-1,2681,2679,2692,-1,2692,2684,2681,-1,2691,4393,2684,-1,2684,2692,2691,-1,2682,2681,2683,-1,2683,4394,2682,-1,4394,2685,2504,-1,2504,2686,4394,-1,4395,2685,4394,-1,4394,2683,4395,-1,2682,4394,2686,-1,2686,4396,2682,-1,4396,2686,2524,-1,2524,4092,4396,-1,4397,4392,2682,-1,2682,4396,4397,-1,2499,2641,2687,-1,2687,2689,2499,-1,2687,4398,4399,-1,4399,2689,2687,-1,2691,2690,2703,-1,2703,4400,2691,-1,4401,2696,2680,-1,2680,4392,4401,-1,2698,2697,4402,-1,4402,2701,2698,-1,2697,2756,2755,-1,2755,4402,2697,-1,2701,4402,2816,-1,2816,4400,2701,-1,2702,4403,2698,-1,2698,2700,2702,-1,2703,2700,2701,-1,2701,4400,2703,-1,4404,4405,4406,-1,4406,4407,4404,-1,4408,4405,4404,-1,4404,4409,4408,-1,4406,4405,4096,-1,4096,4098,4406,-1,4410,4411,4407,-1,4407,4406,4410,-1,4412,4404,4407,-1,4407,4413,4412,-1,4404,4412,2695,-1,2695,4409,4404,-1,4411,4414,4413,-1,4413,4407,4411,-1,4415,4412,4413,-1,4413,4416,4415,-1,4417,2695,4412,-1,4412,4415,4417,-1,4414,4418,4416,-1,4416,4413,4414,-1,4419,4415,4416,-1,4416,4420,4419,-1,2704,2674,2685,-1,2685,4395,2704,-1,4421,4370,2704,-1,2704,4395,4421,-1,4421,4395,2683,-1,2683,2684,4421,-1,4393,4422,4421,-1,4421,2684,4393,-1,4370,4367,2677,-1,2677,2704,4370,-1,4370,4421,4422,-1,4422,4371,4370,-1,4423,4424,2706,-1,2706,2705,4423,-1,4424,4425,2708,-1,2708,2706,4424,-1,4425,4426,2709,-1,2709,2708,4425,-1,4426,4427,2710,-1,2710,2709,4426,-1,4427,4428,2707,-1,2707,2710,4427,-1,2714,2711,2707,-1,2707,2712,2714,-1,4429,4430,2713,-1,2713,2712,4429,-1,4430,4431,2715,-1,2715,2713,4430,-1,4431,4432,2716,-1,2716,2715,4431,-1,4432,4433,2717,-1,2717,2716,4432,-1,4433,4434,2714,-1,2714,2717,4433,-1,4435,4436,4424,-1,4424,4423,4435,-1,4437,4423,2705,-1,2705,2711,4437,-1,4436,4438,4425,-1,4425,4424,4436,-1,4438,4439,4426,-1,4426,4425,4438,-1,4439,4440,4427,-1,4427,4426,4439,-1,4440,4441,4428,-1,4428,4427,4440,-1,4428,4429,2712,-1,2712,2707,4428,-1,4441,4442,4429,-1,4429,4428,4441,-1,4442,4443,4430,-1,4430,4429,4442,-1,4443,4444,4431,-1,4431,4430,4443,-1,4444,4445,4432,-1,4432,4431,4444,-1,4445,4446,4433,-1,4433,4432,4445,-1,4446,4447,4434,-1,4434,4433,4446,-1,4434,4437,2711,-1,2711,2714,4434,-1,4447,4448,4437,-1,4437,4434,4447,-1,4448,4435,4423,-1,4423,4437,4448,-1,4420,2719,4436,-1,4436,4435,4420,-1,2719,2718,4438,-1,4438,4436,2719,-1,2718,4449,4439,-1,4439,4438,2718,-1,4449,4450,4440,-1,4440,4439,4449,-1,4450,4451,4441,-1,4441,4440,4450,-1,4451,4452,4442,-1,4442,4441,4451,-1,4452,4453,4443,-1,4443,4442,4452,-1,4453,4454,4444,-1,4444,4443,4453,-1,4454,4455,4445,-1,4445,4444,4454,-1,4455,2725,4446,-1,4446,4445,4455,-1,2725,2724,4447,-1,4447,4446,2725,-1,2724,4419,4448,-1,4448,4447,2724,-1,4419,4420,4435,-1,4435,4448,4419,-1,4420,4456,2722,-1,2722,2719,4420,-1,2720,2736,4449,-1,4449,2718,2720,-1,4449,2736,2738,-1,2738,4450,4449,-1,4457,4451,4450,-1,4450,2738,4457,-1,4451,4457,4458,-1,4458,4452,4451,-1,4458,4459,4453,-1,4453,4452,4458,-1,4454,4453,4459,-1,4459,4460,4454,-1,4460,4461,4455,-1,4455,4454,4460,-1,4462,2725,4455,-1,4455,4461,4462,-1,4417,4415,4419,-1,4419,2724,4417,-1,4418,4456,4420,-1,4420,4416,4418,-1,2829,2722,4456,-1,4456,4463,2829,-1,2728,2750,4464,-1,4464,2726,2728,-1,2734,2750,2728,-1,2728,2732,2734,-1,4464,2750,2749,-1,2749,4465,4464,-1,4464,2754,2729,-1,2729,2726,4464,-1,2751,2730,2727,-1,2727,2729,2751,-1,2728,2727,2731,-1,2731,2735,2728,-1,2735,2731,4466,-1,4466,4467,2735,-1,2735,2699,2732,-1,2732,2728,2735,-1,2733,2732,2699,-1,2699,2698,2733,-1,2698,4403,4468,-1,4468,2733,2698,-1,4403,4469,4462,-1,4462,4468,4403,-1,2733,4468,4470,-1,4470,2734,2733,-1,4417,2724,2723,-1,2723,4471,4417,-1,4469,2723,2725,-1,2725,4462,4469,-1,2730,4472,4466,-1,4466,2731,2730,-1,2697,2735,4467,-1,4467,2756,2697,-1,2748,4469,4403,-1,4403,2702,2748,-1,4462,4461,4470,-1,4470,4468,4462,-1,2723,4469,2748,-1,2748,4471,2723,-1,4473,4474,4475,-1,4475,4476,4473,-1,4477,4474,4473,-1,4473,4478,4477,-1,4479,4475,4474,-1,4474,4480,4479,-1,4475,4481,4482,-1,4482,4476,4475,-1,4483,4473,4476,-1,4476,4484,4483,-1,4473,4483,4485,-1,4485,4478,4473,-1,4476,4482,2745,-1,2745,4484,4476,-1,4486,2740,4483,-1,4483,4484,4486,-1,2737,4485,4483,-1,4483,2740,2737,-1,4485,2737,4487,-1,4487,4478,4485,-1,4457,2738,2739,-1,2739,4488,4457,-1,2736,2720,4487,-1,4487,2737,2736,-1,2740,4486,4489,-1,4489,2739,2740,-1,2743,2742,4490,-1,4490,2746,2743,-1,2742,4491,4492,-1,4492,4490,2742,-1,4490,2753,2747,-1,2747,2746,4490,-1,4482,2743,2746,-1,2746,2745,4482,-1,4482,4481,2741,-1,2741,2743,4482,-1,2745,2744,4486,-1,4486,4484,2745,-1,2720,2721,4493,-1,4493,4487,2720,-1,4494,4493,2721,-1,2721,2828,4494,-1,4493,4477,4478,-1,4478,4487,4493,-1,4495,4488,2739,-1,2739,4489,4495,-1,4458,4457,4488,-1,4488,4496,4458,-1,4488,4495,4497,-1,4497,4496,4488,-1,4459,4458,4496,-1,4496,4498,4459,-1,4498,4496,4497,-1,4497,4465,4498,-1,4460,4459,4498,-1,4498,4499,4460,-1,4499,4498,4465,-1,4465,2749,4499,-1,4461,4460,4499,-1,4499,4470,4461,-1,2694,2695,4417,-1,4417,4471,2694,-1,2830,2741,4481,-1,4481,4500,2830,-1,2744,2747,4489,-1,4489,4486,2744,-1,2752,4495,4489,-1,4489,2747,2752,-1,4470,4499,2749,-1,2749,2734,4470,-1,2693,2694,4471,-1,4471,2748,2693,-1,2703,2678,2693,-1,2693,2702,2703,-1,2754,4497,4495,-1,4495,2752,2754,-1,4472,2730,2753,-1,2753,4501,4472,-1,4490,4492,4501,-1,4501,2753,4490,-1,4502,4472,4501,-1,4501,4503,4502,-1,4466,4472,4502,-1,4502,4504,4466,-1,4501,4492,4505,-1,4505,4503,4501,-1,4506,4502,4503,-1,4503,4507,4506,-1,4502,4506,4508,-1,4508,4504,4502,-1,4507,4503,4505,-1,4505,4509,4507,-1,2804,4506,4507,-1,4507,4510,2804,-1,4506,2804,2803,-1,2803,4508,4506,-1,4510,4507,4509,-1,4509,4511,4510,-1,2801,2800,2804,-1,2804,4510,2801,-1,2816,4402,2755,-1,2755,4512,2816,-1,4343,4342,2762,-1,2762,2764,4343,-1,2758,4006,4513,-1,4513,2759,2758,-1,2763,2762,2823,-1,2823,2822,2763,-1,4514,4343,2764,-1,2764,2801,4514,-1,4515,2766,2765,-1,2765,4341,4515,-1,2767,2766,4516,-1,4516,4517,2767,-1,2627,2765,2767,-1,2767,4347,2627,-1,4347,2767,4517,-1,4517,2795,4347,-1,2823,4347,2795,-1,2795,2794,2823,-1,4346,4518,2772,-1,2772,4344,4346,-1,4519,2768,2770,-1,2770,4520,4519,-1,4000,2769,2768,-1,2768,4521,4000,-1,4518,4522,2770,-1,2770,2772,4518,-1,4523,4521,2768,-1,2768,4519,4523,-1,4002,4000,4521,-1,4521,4524,4002,-1,4525,4524,4521,-1,4521,4523,4525,-1,4004,4002,4524,-1,4524,4526,4004,-1,4527,4526,4524,-1,4524,4525,4527,-1,4006,4004,4526,-1,4526,4513,4006,-1,4526,4527,4528,-1,4528,4513,4526,-1,2669,2759,4513,-1,4513,4528,2669,-1,4529,4530,4531,-1,4531,4532,4529,-1,4530,4529,4533,-1,4533,4534,4530,-1,4531,4530,4535,-1,4535,4536,4531,-1,4531,4537,2929,-1,2929,4532,4531,-1,4538,4529,4532,-1,4532,4539,4538,-1,4540,4541,4542,-1,4542,4543,4540,-1,4544,4541,4540,-1,4540,4545,4544,-1,4546,4547,4542,-1,4542,4541,4546,-1,4542,4548,4549,-1,4549,4543,4542,-1,4543,4550,4551,-1,4551,4540,4543,-1,4535,4530,4534,-1,4534,4552,4535,-1,4535,4553,4554,-1,4554,4536,4535,-1,4536,4555,4537,-1,4537,4531,4536,-1,2789,4556,4557,-1,4557,4558,2789,-1,4559,4556,2789,-1,2789,2793,4559,-1,4556,4544,4545,-1,4545,4557,4556,-1,4557,4560,4561,-1,4561,4558,4557,-1,4553,2789,4558,-1,4558,4554,4553,-1,4559,4562,4544,-1,4544,4556,4559,-1,4545,4563,4560,-1,4560,4557,4545,-1,4562,4546,4541,-1,4541,4544,4562,-1,4540,4551,4563,-1,4563,4545,4540,-1,4547,2776,4548,-1,4548,4542,4547,-1,4548,2774,4564,-1,4564,4549,4548,-1,4549,4565,4550,-1,4550,4543,4549,-1,4548,2776,2775,-1,2775,2774,4548,-1,2774,2773,4566,-1,4566,4564,2774,-1,4564,4567,4565,-1,4565,4549,4564,-1,2773,4568,4569,-1,4569,4566,2773,-1,4566,4570,4567,-1,4567,4564,4566,-1,2782,4571,4568,-1,4568,2773,2782,-1,4568,4572,4573,-1,4573,4569,4568,-1,4569,4574,4570,-1,4570,4566,4569,-1,4572,4568,4571,-1,4571,4575,4572,-1,4539,4573,4572,-1,4572,4538,4539,-1,4573,4576,4574,-1,4574,4569,4573,-1,4529,4538,4577,-1,4577,4533,4529,-1,4532,2929,2931,-1,2931,4539,4532,-1,4553,4535,4552,-1,4552,4578,4553,-1,4554,4579,4555,-1,4555,4536,4554,-1,2789,4553,4578,-1,4578,2787,2789,-1,4558,4561,4579,-1,4579,4554,4558,-1,4580,2805,2775,-1,2775,2777,4580,-1,4581,4582,2805,-1,2805,4580,4581,-1,2775,2805,2784,-1,2784,2781,2775,-1,2777,4583,4584,-1,4584,4580,2777,-1,2778,4559,2793,-1,2793,2779,2778,-1,4585,2780,2779,-1,2779,4586,4585,-1,4587,2778,2780,-1,2780,4588,4587,-1,4547,4583,2777,-1,2777,2776,4547,-1,4583,4589,4590,-1,4590,4584,4583,-1,4591,4581,4580,-1,4580,4584,4591,-1,4589,4583,4547,-1,4547,4546,4589,-1,4589,4587,4588,-1,4588,4590,4589,-1,4592,4591,4584,-1,4584,4590,4592,-1,4587,4589,4546,-1,4546,4562,4587,-1,4593,4592,4590,-1,4590,4588,4593,-1,4587,4562,4559,-1,4559,2778,4587,-1,2780,4585,4593,-1,4593,4588,2780,-1,4571,2782,2783,-1,2783,2786,4571,-1,4575,4571,2786,-1,2786,4594,4575,-1,4595,4594,2786,-1,2786,2785,4595,-1,4577,4575,4594,-1,4594,4596,4577,-1,4533,4577,4596,-1,4596,4597,4533,-1,4598,4597,4596,-1,4596,4599,4598,-1,4534,4533,4597,-1,4597,4600,4534,-1,4601,4600,4597,-1,4597,4598,4601,-1,4552,4534,4600,-1,4600,4602,4552,-1,4603,4602,4600,-1,4600,4601,4603,-1,4578,4552,4602,-1,4602,4604,4578,-1,4605,4604,4602,-1,4602,4603,4605,-1,2787,4578,4604,-1,4604,2792,2787,-1,2790,2792,4604,-1,4604,4605,2790,-1,2788,2787,2792,-1,2792,2791,2788,-1,2806,2779,2793,-1,2793,2791,2806,-1,2796,2795,4598,-1,4598,4599,2796,-1,4517,4601,4598,-1,4598,2795,4517,-1,4599,4595,4606,-1,4606,2796,4599,-1,2798,2790,4605,-1,4605,4607,2798,-1,2807,2791,2798,-1,2798,4608,2807,-1,2783,2799,2763,-1,2763,2797,2783,-1,4606,4595,2785,-1,2785,2797,4606,-1,4607,4605,4603,-1,4603,4516,4607,-1,4609,4608,2798,-1,2798,4607,4609,-1,2797,2763,2822,-1,2822,4606,2797,-1,4596,4594,4595,-1,4595,4599,4596,-1,2796,4606,2822,-1,2822,2794,2796,-1,4516,4603,4601,-1,4601,4517,4516,-1,2766,4609,4607,-1,4607,4516,2766,-1,2800,2799,2783,-1,2783,2784,2800,-1,2799,2801,2764,-1,2764,2763,2799,-1,4610,4586,2779,-1,2779,2806,4610,-1,4611,4612,4585,-1,4585,4586,4611,-1,2803,2802,2805,-1,2805,4582,2803,-1,2784,2802,2804,-1,2804,2800,2784,-1,4508,2803,4582,-1,4582,4613,4508,-1,4582,4581,4614,-1,4614,4613,4582,-1,4615,4614,4581,-1,4581,4591,4615,-1,4591,4592,2840,-1,2840,4615,4591,-1,4592,4593,4616,-1,4616,2840,4592,-1,4593,4585,4612,-1,4612,4616,4593,-1,2833,4611,4586,-1,4586,4610,2833,-1,4617,4610,2806,-1,2806,2807,4617,-1,4618,4619,4620,-1,4620,4621,4618,-1,4619,4618,4622,-1,4622,4623,4619,-1,4624,4620,4619,-1,4619,4625,4624,-1,4626,4627,4621,-1,4621,4620,4626,-1,4621,4628,4629,-1,4629,4618,4621,-1,4630,4631,4632,-1,4632,4633,4630,-1,4631,4630,4634,-1,4634,4635,4631,-1,4636,4637,4632,-1,4632,4631,4636,-1,4638,4639,4633,-1,4633,4632,4638,-1,4633,4640,4641,-1,4641,4630,4633,-1,4642,4390,4391,-1,4391,2910,4642,-1,4390,4642,2912,-1,2912,2914,4390,-1,4643,2911,2910,-1,2910,4391,4643,-1,4642,2910,4644,-1,4644,4645,4642,-1,4334,4382,4381,-1,4381,4646,4334,-1,4647,4648,4649,-1,4649,4650,4647,-1,4651,4652,4648,-1,4648,4647,4651,-1,4648,2292,2296,-1,2296,4649,4648,-1,4650,4649,4653,-1,4653,4654,4650,-1,4655,4647,4650,-1,4650,4656,4655,-1,2266,2265,2810,-1,2810,2809,2266,-1,2810,2265,2272,-1,2272,4657,2810,-1,4653,2300,2266,-1,2266,2809,4653,-1,4654,4653,2809,-1,2809,2808,4654,-1,2808,2810,4657,-1,4657,4658,2808,-1,2811,2813,2901,-1,2901,4659,2811,-1,2184,2901,2813,-1,2813,2182,2184,-1,4659,2901,2899,-1,2899,2898,4659,-1,2811,4659,4660,-1,4660,4661,2811,-1,4662,4663,4664,-1,4664,4665,4662,-1,4663,4662,2826,-1,2826,2825,4663,-1,4666,4664,4663,-1,4663,4667,4666,-1,4668,4669,4665,-1,4665,4664,4668,-1,4665,4670,4671,-1,4671,4662,4665,-1,4398,4672,4673,-1,4673,4674,4398,-1,4672,4398,2687,-1,2687,4352,4672,-1,4673,4672,4675,-1,4675,4676,4673,-1,4673,4677,4678,-1,4678,4674,4673,-1,4398,4674,4679,-1,4679,4399,4398,-1,4677,4673,4676,-1,4676,4680,4677,-1,4681,4678,4677,-1,4677,4682,4681,-1,4674,4678,4683,-1,4683,4679,4674,-1,4684,4685,4612,-1,4612,4611,4684,-1,4685,4684,4686,-1,4686,4350,4685,-1,4616,4612,4685,-1,4685,4687,4616,-1,2832,4684,4611,-1,4611,2833,2832,-1,2833,4610,4617,-1,4617,4688,2833,-1,2840,4616,4687,-1,4687,2841,2840,-1,4615,2840,2839,-1,2839,4689,4615,-1,4614,4615,4689,-1,4689,2757,4614,-1,4613,4614,2757,-1,2757,4690,4613,-1,4508,4613,4690,-1,4690,4504,4508,-1,4688,4617,2815,-1,2815,2761,4688,-1,2833,4688,4691,-1,4691,2831,2833,-1,4617,2807,4608,-1,4608,2815,4617,-1,2815,4608,4609,-1,4609,2814,2815,-1,2814,4609,2766,-1,2766,4515,2814,-1,2503,2814,4515,-1,4515,4008,2503,-1,4008,4515,4341,-1,4341,4010,4008,-1,4692,4693,4527,-1,4527,4525,4692,-1,2844,4692,4525,-1,4525,4523,2844,-1,2842,2844,4523,-1,4523,4519,2842,-1,2770,4522,4694,-1,4694,4520,2770,-1,4695,2842,4519,-1,4519,4520,4695,-1,4514,4696,4345,-1,4345,4343,4514,-1,4697,4696,4514,-1,4514,4511,4697,-1,4698,4345,4696,-1,4696,4699,4698,-1,4700,4505,4492,-1,4492,4491,4700,-1,4467,4466,4504,-1,4504,4690,4467,-1,4512,2755,2757,-1,2757,4689,4512,-1,2817,2816,4512,-1,4512,4701,2817,-1,4701,4512,4689,-1,4689,2839,4701,-1,2820,2817,4701,-1,4701,4348,2820,-1,2820,2819,2818,-1,2818,2817,2820,-1,4348,4701,2839,-1,2839,2841,4348,-1,2841,4687,2630,-1,2630,4348,2841,-1,2631,4349,4702,-1,4702,2632,2631,-1,4350,2630,4687,-1,4687,4685,4350,-1,4703,4349,4350,-1,4350,4686,4703,-1,4393,2691,2818,-1,2818,2819,4393,-1,2632,4375,4377,-1,4377,2629,2632,-1,4538,4572,4575,-1,4575,4577,4538,-1,4681,4704,4683,-1,4683,4678,4681,-1,4705,4682,4677,-1,4677,4680,4705,-1,4682,4706,4707,-1,4707,4681,4682,-1,4662,4671,4708,-1,4708,2826,4662,-1,4667,4663,2825,-1,2825,2905,4667,-1,4671,4709,4710,-1,4710,4708,4671,-1,4708,2644,2824,-1,2824,2826,4708,-1,4670,4711,4709,-1,4709,4671,4670,-1,4710,4709,4676,-1,4676,4675,4710,-1,4710,2645,2644,-1,2644,4708,4710,-1,4711,4680,4676,-1,4676,4709,4711,-1,2645,4710,4675,-1,4675,4351,2645,-1,4712,4713,4711,-1,4711,4670,4712,-1,4714,4715,4713,-1,4713,4712,4714,-1,4713,4705,4680,-1,4680,4711,4713,-1,4669,4712,4670,-1,4670,4665,4669,-1,4715,4716,4705,-1,4705,4713,4715,-1,4716,4706,4682,-1,4682,4705,4716,-1,4672,4352,4351,-1,4351,4675,4672,-1,4028,2688,2689,-1,2689,4399,4028,-1,4030,4028,4399,-1,4399,4679,4030,-1,4679,4683,4031,-1,4031,4030,4679,-1,4707,4717,4704,-1,4704,4681,4707,-1,4033,4031,4683,-1,4683,4704,4033,-1,2754,4464,4465,-1,4465,4497,2754,-1,4718,4463,4456,-1,4456,4418,4718,-1,4494,4719,4477,-1,4477,4493,4494,-1,4719,4480,4474,-1,4474,4477,4719,-1,4479,4500,4481,-1,4481,4475,4479,-1,4720,2834,2832,-1,2832,2831,4720,-1,4684,2832,2835,-1,2835,4686,4684,-1,4389,4720,2831,-1,2831,4691,4389,-1,2673,4721,4720,-1,4720,4389,2673,-1,4389,4691,2760,-1,2760,2667,4389,-1,4721,2837,2834,-1,2834,4720,4721,-1,4686,2835,2838,-1,2838,4703,4686,-1,4722,4703,2838,-1,2838,2857,4722,-1,2838,2836,2856,-1,2856,2857,2838,-1,2756,4467,4690,-1,4690,2757,2756,-1,2801,4510,4511,-1,4511,4514,2801,-1,4723,4697,4511,-1,4511,4509,4723,-1,4724,4725,4697,-1,4697,4723,4724,-1,4509,4505,4700,-1,4700,4723,4509,-1,4725,4699,4696,-1,4696,4697,4725,-1,4691,4688,2761,-1,2761,2760,4691,-1,4726,2670,2669,-1,2669,4528,4726,-1,4698,4727,4346,-1,4346,4345,4698,-1,4727,3159,4518,-1,4518,4346,4727,-1,3159,3156,4522,-1,4522,4518,3159,-1,4728,4694,4522,-1,4522,3156,4728,-1,4729,4695,4520,-1,4520,4694,4729,-1,4730,4695,4729,-1,4729,4731,4730,-1,4694,4728,4732,-1,4732,4729,4694,-1,2843,2842,4695,-1,4695,4730,2843,-1,4692,2844,2843,-1,2843,4733,4692,-1,4734,4693,4692,-1,4692,4733,4734,-1,4693,4726,4528,-1,4528,4527,4693,-1,4735,4726,4693,-1,4693,4734,4735,-1,4386,2670,4726,-1,4726,4735,4386,-1,2673,2913,4380,-1,4380,4721,2673,-1,4721,4380,2663,-1,2663,2837,4721,-1,2855,2836,2837,-1,2837,2663,2855,-1,4702,4349,4703,-1,4703,4722,4702,-1,4736,4408,4409,-1,4409,4401,4736,-1,4408,4736,2525,-1,2525,4094,4408,-1,2696,4401,4409,-1,4409,2695,2696,-1,4397,4736,4401,-1,4401,4392,4397,-1,4397,4396,4092,-1,4092,2526,4397,-1,2819,2849,4422,-1,4422,4393,2819,-1,4366,4368,2659,-1,2659,4363,4366,-1,2660,4737,4363,-1,4363,2659,2660,-1,4369,4371,4376,-1,4376,2657,4369,-1,4376,4371,4422,-1,4422,2849,4376,-1,2691,4400,2816,-1,2816,2818,2691,-1,4405,4408,4094,-1,4094,4096,4405,-1,2526,2525,4736,-1,4736,4397,2526,-1,4738,4739,4411,-1,4411,4410,4738,-1,4410,4406,4098,-1,4098,4100,4410,-1,4739,4740,4414,-1,4414,4411,4739,-1,4740,4718,4418,-1,4418,4414,4740,-1,2845,4667,2905,-1,2905,4741,2845,-1,2847,4666,4667,-1,4667,2845,2847,-1,4741,2905,2874,-1,2874,2903,4741,-1,2846,2845,4741,-1,4741,4742,2846,-1,2846,4743,4744,-1,4744,2847,2846,-1,2846,4745,4746,-1,4746,4743,2846,-1,3228,4744,4743,-1,4743,3229,3228,-1,4666,2847,4744,-1,4744,4747,4666,-1,4747,4744,3228,-1,3228,4748,4747,-1,4747,4668,4664,-1,4664,4666,4747,-1,4742,4741,2903,-1,2903,2902,4742,-1,4742,4749,4745,-1,4745,2846,4742,-1,4750,4751,4669,-1,4669,4668,4750,-1,4751,4714,4712,-1,4712,4669,4751,-1,4737,4752,4362,-1,4362,4363,4737,-1,4362,4752,4753,-1,4753,4360,4362,-1,4754,2660,2658,-1,2658,4374,4754,-1,2632,4754,4374,-1,4374,4375,2632,-1,4754,2632,4702,-1,4702,4755,4754,-1,2660,4754,4755,-1,4755,4756,2660,-1,4737,2660,4756,-1,4756,4757,4737,-1,4752,4737,4757,-1,4757,4758,4752,-1,4753,4752,4758,-1,4758,4759,4753,-1,4760,4361,4360,-1,4360,4753,4760,-1,4759,4758,2864,-1,2864,2863,4759,-1,4761,4760,4753,-1,4753,4759,4761,-1,4758,4757,2861,-1,2861,2864,4758,-1,4757,4756,2862,-1,2862,2861,4757,-1,4756,4755,4762,-1,4762,2862,4756,-1,4755,4702,4722,-1,4722,4762,4755,-1,4335,2870,2853,-1,2853,2852,4335,-1,2851,2853,4763,-1,4763,2857,2851,-1,2853,2859,2858,-1,2858,4763,2853,-1,4762,4722,2857,-1,2857,4763,4762,-1,2869,4764,2859,-1,2859,2853,2869,-1,2862,4762,4763,-1,4763,2858,2862,-1,2864,2861,2858,-1,2858,2860,2864,-1,4764,2871,2860,-1,2860,2859,4764,-1,4765,4766,2863,-1,2863,2865,4765,-1,4766,4761,4759,-1,4759,2863,4766,-1,2868,4335,2852,-1,2852,2854,2868,-1,4381,4380,2913,-1,2913,4646,4381,-1,4335,2868,2867,-1,2867,2619,4335,-1,2621,2619,2867,-1,2867,4767,2621,-1,4382,4334,2934,-1,2934,4385,4382,-1,2941,4383,4385,-1,4385,3005,2941,-1,4385,2934,2933,-1,2933,3005,4385,-1,4768,4334,4646,-1,4646,4769,4768,-1,2617,2616,4334,-1,4334,4768,2617,-1,4769,4646,2913,-1,2913,2912,4769,-1,4768,4769,4645,-1,4645,4770,4768,-1,4771,2871,4764,-1,4764,4340,4771,-1,4772,2872,2871,-1,2871,4771,4772,-1,4340,4764,2869,-1,2869,4336,4340,-1,2890,4771,4340,-1,4340,4339,2890,-1,2872,4765,2865,-1,2865,2860,2872,-1,4773,4765,2872,-1,2872,4772,4773,-1,4766,4765,4773,-1,4773,4774,4766,-1,4761,4766,4774,-1,4774,4661,4761,-1,4760,4761,4661,-1,4661,4660,4760,-1,4361,4760,4660,-1,4660,4775,4361,-1,2649,4361,4775,-1,4775,4776,2649,-1,2904,4358,2649,-1,2649,4776,2904,-1,4357,4358,2904,-1,2904,2903,4357,-1,4777,4778,4779,-1,4779,2875,4777,-1,4780,4781,4778,-1,4778,4777,4780,-1,4778,2808,4658,-1,4658,4779,4778,-1,2875,4779,4782,-1,4782,2876,2875,-1,2892,4777,2875,-1,2875,2891,2892,-1,4781,4654,2808,-1,2808,4778,4781,-1,4779,4658,4783,-1,4783,4782,4779,-1,4658,4657,2878,-1,2878,4783,4658,-1,4657,2272,2276,-1,2276,2878,4657,-1,4784,2937,2876,-1,2876,4782,4784,-1,4782,4783,4785,-1,4785,4784,4782,-1,4783,2878,4786,-1,4786,4785,4783,-1,4784,4785,4787,-1,4787,4338,4784,-1,2279,2313,4786,-1,4786,2878,2279,-1,4785,4786,4788,-1,4788,4787,4785,-1,2937,4784,4338,-1,4338,2625,2937,-1,2937,2625,4337,-1,4337,2938,2937,-1,2890,4339,4338,-1,4338,4787,2890,-1,2313,2310,4788,-1,4788,4786,2313,-1,2888,2890,4787,-1,4787,4788,2888,-1,4749,4742,2902,-1,2902,2897,4749,-1,4749,4789,4790,-1,4790,4745,4749,-1,4789,4749,2897,-1,2897,2899,4789,-1,4789,4791,4792,-1,4792,4790,4789,-1,4745,4790,4793,-1,4793,4746,4745,-1,4789,2899,2900,-1,2900,4791,4789,-1,4791,2281,2261,-1,2261,4792,4791,-1,4790,4792,4794,-1,4794,4793,4790,-1,4791,2900,2188,-1,2188,2281,4791,-1,4792,2261,2260,-1,2260,4794,4792,-1,4743,4746,4795,-1,4795,3229,4743,-1,4746,4793,4796,-1,4796,4795,4746,-1,4793,4794,4797,-1,4797,4796,4793,-1,4794,2260,2262,-1,2262,4797,4794,-1,4798,4799,4800,-1,4800,2907,4798,-1,3290,4801,4799,-1,4799,4798,3290,-1,4799,4802,4803,-1,4803,4800,4799,-1,2907,4800,4804,-1,4804,2881,2907,-1,2907,2906,4805,-1,4805,4798,2907,-1,4801,4806,4802,-1,4802,4799,4801,-1,4802,4807,4808,-1,4808,4803,4802,-1,4800,4803,4809,-1,4809,4804,4800,-1,4806,4810,4807,-1,4807,4802,4806,-1,4807,4811,4812,-1,4812,4808,4807,-1,4803,4808,4813,-1,4813,4809,4803,-1,4810,4814,4811,-1,4811,4807,4810,-1,4811,4815,4816,-1,4816,4812,4811,-1,4808,4812,4817,-1,4817,4813,4808,-1,4814,4818,4815,-1,4815,4811,4814,-1,4815,4819,4820,-1,4820,4816,4815,-1,4812,4816,4821,-1,4821,4817,4812,-1,4818,4822,4819,-1,4819,4815,4818,-1,4819,4823,4824,-1,4824,4820,4819,-1,4816,4820,4825,-1,4825,4821,4816,-1,4822,4826,4823,-1,4823,4819,4822,-1,4823,2245,2248,-1,2248,4824,4823,-1,4820,4824,4827,-1,4827,4825,4820,-1,4826,2249,2245,-1,2245,4823,4826,-1,4824,2248,2284,-1,2284,4827,4824,-1,2881,4804,4828,-1,4828,2879,2881,-1,2907,2881,2880,-1,2880,2908,2907,-1,4804,4809,4829,-1,4829,4828,4804,-1,4809,4813,4830,-1,4830,4829,4809,-1,4813,4817,4831,-1,4831,4830,4813,-1,4817,4821,4832,-1,4832,4831,4817,-1,4821,4825,4651,-1,4651,4832,4821,-1,4825,4827,4652,-1,4652,4651,4825,-1,4827,2284,2288,-1,2288,4652,4827,-1,2879,4828,4833,-1,4833,2884,2879,-1,4828,4829,4834,-1,4834,4833,4828,-1,4829,4830,4835,-1,4835,4834,4829,-1,4830,4831,4836,-1,4836,4835,4830,-1,4831,4832,4655,-1,4655,4836,4831,-1,4832,4651,4647,-1,4647,4655,4832,-1,4652,2288,2292,-1,2292,4648,4652,-1,2884,4833,4837,-1,4837,2882,2884,-1,4838,2879,2884,-1,2884,2883,4838,-1,4833,4834,4839,-1,4839,4837,4833,-1,4834,4835,4840,-1,4840,4839,4834,-1,4835,4836,4841,-1,4841,4840,4835,-1,4836,4655,4656,-1,4656,4841,4836,-1,4842,2886,2882,-1,2882,4837,4842,-1,4837,4839,4843,-1,4843,4842,4837,-1,4839,4840,4844,-1,4844,4843,4839,-1,4840,4841,4780,-1,4780,4844,4840,-1,4841,4656,4781,-1,4781,4780,4841,-1,4656,4650,4654,-1,4654,4781,4656,-1,4649,2296,2300,-1,2300,4653,4649,-1,2896,2887,2886,-1,2886,4842,2896,-1,4845,2882,2886,-1,2886,2885,4845,-1,4842,4843,4846,-1,4846,2896,4842,-1,4843,4844,2892,-1,2892,4846,4843,-1,4844,4780,4777,-1,4777,2892,4844,-1,2895,4331,2887,-1,2887,2896,2895,-1,4847,2894,2896,-1,2896,4846,4847,-1,2893,4847,4846,-1,4846,2892,2893,-1,4848,2889,2888,-1,2888,4849,4848,-1,2889,4772,4771,-1,4771,2890,2889,-1,2889,4848,4773,-1,4773,4772,2889,-1,2310,2305,2888,-1,2888,4788,2310,-1,4333,2932,2934,-1,2934,4329,4333,-1,2877,2876,4850,-1,4850,2935,2877,-1,4851,4852,4847,-1,4847,2893,4851,-1,4853,4854,2895,-1,2895,2894,4853,-1,4331,2895,4854,-1,4854,4855,4331,-1,4856,2887,4331,-1,4331,4330,4856,-1,4330,2615,4857,-1,4857,4856,4330,-1,4857,2615,2617,-1,2617,4858,4857,-1,4856,4857,4859,-1,4859,4860,4856,-1,4768,4770,4858,-1,4858,2617,4768,-1,4858,4861,4859,-1,4859,4857,4858,-1,2812,4862,2194,-1,2194,2303,2812,-1,4862,2812,2811,-1,2811,4863,4862,-1,4862,4849,2192,-1,2192,2194,4862,-1,2813,2812,2303,-1,2303,2182,2813,-1,2888,2305,2192,-1,2192,4849,2888,-1,4863,4848,4849,-1,4849,4862,4863,-1,4863,2811,4661,-1,4661,4774,4863,-1,2898,2897,4776,-1,4776,4775,2898,-1,2184,2188,2900,-1,2900,2901,2184,-1,2897,2902,2904,-1,2904,4776,2897,-1,4848,4863,4774,-1,4774,4773,4848,-1,4659,2898,4775,-1,4775,4660,4659,-1,4864,4805,2906,-1,2906,4865,4864,-1,4798,4805,3291,-1,3291,3290,4798,-1,4386,4735,4866,-1,4866,4643,4386,-1,4735,4734,4867,-1,4867,4866,4735,-1,4734,4733,4868,-1,4868,4867,4734,-1,2843,4730,4869,-1,4869,4870,2843,-1,4731,4729,4732,-1,4732,4871,4731,-1,4730,4731,4872,-1,4872,4869,4730,-1,4643,4866,4873,-1,4873,2911,4643,-1,4386,4643,4391,-1,4391,4387,4386,-1,4866,4867,4874,-1,4874,4873,4866,-1,4733,2843,4870,-1,4870,4868,4733,-1,4867,4868,4636,-1,4636,4874,4867,-1,4868,4870,4637,-1,4637,4636,4868,-1,4870,4869,4875,-1,4875,4637,4870,-1,4876,4872,4731,-1,4731,4871,4876,-1,4869,4872,4877,-1,4877,4875,4869,-1,2911,4873,4878,-1,4878,2909,2911,-1,4873,4874,4635,-1,4635,4878,4873,-1,4874,4636,4631,-1,4631,4635,4874,-1,4637,4875,4638,-1,4638,4632,4637,-1,4879,4877,4872,-1,4872,4876,4879,-1,4875,4877,4880,-1,4880,4638,4875,-1,2909,4878,4881,-1,4881,4882,2909,-1,4635,4634,4881,-1,4881,4878,4635,-1,4883,4880,4877,-1,4877,4879,4883,-1,4880,4884,4639,-1,4639,4638,4880,-1,4883,4885,4884,-1,4884,4880,4883,-1,4884,4886,4887,-1,4887,4639,4884,-1,4885,4888,4886,-1,4886,4884,4885,-1,4886,4889,4890,-1,4890,4887,4886,-1,4639,4887,4640,-1,4640,4633,4639,-1,4888,4891,4889,-1,4889,4886,4888,-1,4889,4892,4893,-1,4893,4890,4889,-1,4887,4890,4894,-1,4894,4640,4887,-1,4891,4895,4892,-1,4892,4889,4891,-1,4892,4896,4897,-1,4897,4893,4892,-1,4890,4893,4626,-1,4626,4894,4890,-1,4895,4898,4896,-1,4896,4892,4895,-1,4896,4899,4900,-1,4900,4897,4896,-1,4893,4897,4627,-1,4627,4626,4893,-1,4898,4901,4899,-1,4899,4896,4898,-1,4899,4864,4865,-1,4865,4900,4899,-1,4897,4900,4902,-1,4902,4627,4897,-1,4901,4903,4864,-1,4864,4899,4901,-1,4900,4865,4904,-1,4904,4902,4900,-1,4903,3291,4805,-1,4805,4864,4903,-1,4865,2906,2908,-1,2908,4904,4865,-1,4640,4894,4624,-1,4624,4641,4640,-1,4894,4626,4620,-1,4620,4624,4894,-1,4627,4902,4628,-1,4628,4621,4627,-1,4902,4904,4905,-1,4905,4628,4902,-1,4904,2908,2880,-1,2880,4905,4904,-1,4630,4641,4906,-1,4906,4634,4630,-1,4641,4624,4625,-1,4625,4906,4641,-1,4628,4905,4838,-1,4838,4629,4628,-1,4905,2880,2879,-1,2879,4838,4905,-1,4634,4906,4907,-1,4907,4881,4634,-1,4906,4625,4908,-1,4908,4907,4906,-1,4625,4619,4623,-1,4623,4908,4625,-1,4618,4629,4909,-1,4909,4622,4618,-1,4629,4838,2883,-1,2883,4909,4629,-1,4882,4881,4907,-1,4907,4910,4882,-1,4910,4907,4908,-1,4908,4911,4910,-1,4911,4908,4623,-1,4623,4912,4911,-1,4912,4623,4622,-1,4622,4913,4912,-1,4913,4622,4909,-1,4909,4845,4913,-1,4845,4909,2883,-1,2883,2882,4845,-1,2909,4882,4644,-1,4644,2910,2909,-1,4882,4910,4914,-1,4914,4644,4882,-1,4910,4911,4861,-1,4861,4914,4910,-1,4911,4912,4859,-1,4859,4861,4911,-1,4912,4913,4860,-1,4860,4859,4912,-1,4913,4845,2885,-1,2885,4860,4913,-1,4645,4644,4914,-1,4914,4770,4645,-1,4770,4914,4861,-1,4861,4858,4770,-1,4856,4860,2885,-1,2885,2887,4856,-1,4642,4645,4769,-1,4769,2912,4642,-1,4491,4915,4916,-1,4916,4700,4491,-1,4723,4700,4916,-1,4916,4724,4723,-1,4917,4915,4491,-1,4491,2742,4917,-1,4767,2867,2866,-1,2866,4918,4767,-1,4918,2866,4384,-1,4384,2943,4918,-1,2894,4847,4852,-1,4852,4853,2894,-1,2876,2937,2939,-1,2939,4850,2876,-1,2936,4919,2891,-1,2891,2877,2936,-1,4855,4332,4328,-1,4328,4331,4855,-1,4748,4750,4668,-1,4668,4747,4748,-1,4920,2926,2927,-1,2927,4921,4920,-1,4922,2925,2926,-1,2926,4920,4922,-1,4923,2924,2925,-1,2925,4922,4923,-1,4924,2923,2924,-1,2924,4923,4924,-1,4925,2921,2923,-1,2923,4924,4925,-1,4926,2920,2921,-1,2921,4925,4926,-1,4927,2918,2920,-1,2920,4926,4927,-1,4928,2917,2918,-1,2918,4927,4928,-1,4929,2915,2917,-1,2917,4928,4929,-1,4930,2916,2915,-1,2915,4929,4930,-1,4931,2919,2916,-1,2916,4930,4931,-1,2930,2922,2919,-1,2919,4931,2930,-1,4932,2928,2922,-1,2922,2930,4932,-1,4921,2927,2928,-1,2928,4932,4921,-1,4537,4932,2930,-1,2930,2929,4537,-1,4555,4921,4932,-1,4932,4537,4555,-1,4579,4920,4921,-1,4921,4555,4579,-1,4561,4922,4920,-1,4920,4579,4561,-1,4560,4923,4922,-1,4922,4561,4560,-1,4563,4924,4923,-1,4923,4560,4563,-1,4551,4925,4924,-1,4924,4563,4551,-1,4550,4926,4925,-1,4925,4551,4550,-1,4565,4927,4926,-1,4926,4550,4565,-1,4567,4928,4927,-1,4927,4565,4567,-1,4570,4929,4928,-1,4928,4567,4570,-1,4574,4930,4929,-1,4929,4570,4574,-1,2931,4576,4573,-1,4573,4539,2931,-1,4576,4931,4930,-1,4930,4574,4576,-1,2930,4931,4576,-1,4576,2931,2930,-1,2891,4919,4851,-1,4851,2893,2891,-1,2940,2932,4333,-1,4333,4933,2940,-1,4934,4935,4851,-1,4851,4919,4934,-1,4936,4852,4851,-1,4851,4935,4936,-1,4850,4937,4938,-1,4938,2935,4850,-1,2939,2986,4937,-1,4937,4850,2939,-1,2986,2939,2938,-1,2938,2984,2986,-1,4939,4853,4852,-1,4852,4936,4939,-1,4940,4854,4853,-1,4853,4939,4940,-1,4941,4855,4854,-1,4854,4940,4941,-1,4942,4332,4855,-1,4855,4941,4942,-1,4933,4333,4332,-1,4332,4942,4933,-1,2936,4943,4934,-1,4934,4919,2936,-1,4944,2946,2945,-1,2945,4945,4944,-1,2995,4946,2946,-1,2946,4944,2995,-1,2945,4947,4948,-1,4948,4945,2945,-1,4945,4948,4949,-1,4949,4944,4945,-1,2945,4950,4951,-1,4951,4947,2945,-1,4952,4948,4947,-1,4947,4953,4952,-1,4954,2947,2949,-1,2949,2965,4954,-1,2976,2947,4954,-1,4954,4955,2976,-1,2965,2949,4956,-1,4956,2963,2965,-1,2965,2964,4955,-1,4955,4954,2965,-1,4957,4958,2971,-1,2971,2954,4957,-1,4958,4957,4959,-1,4959,4960,4958,-1,4961,2969,2971,-1,2971,4958,4961,-1,2970,2955,2954,-1,2954,2971,2970,-1,2966,2957,4957,-1,4957,2954,2966,-1,2958,2957,2966,-1,2966,2968,2958,-1,2957,2956,4959,-1,4959,4957,2957,-1,2953,2967,2966,-1,2966,2954,2953,-1,4962,4963,4964,-1,4964,4965,4962,-1,4962,4966,4967,-1,4967,4963,4962,-1,4963,4968,4969,-1,4969,4964,4963,-1,4965,4964,4970,-1,4970,4971,4965,-1,4972,4962,4965,-1,4965,4973,4972,-1,4952,4974,2952,-1,2952,2951,4952,-1,4953,2989,4974,-1,4974,4952,4953,-1,2952,4974,4975,-1,4975,4976,2952,-1,4952,2951,4949,-1,4949,4948,4952,-1,2950,4977,4949,-1,4949,2951,2950,-1,2950,4978,4979,-1,4979,4977,2950,-1,4949,4977,2995,-1,2995,4944,4949,-1,2964,4980,4981,-1,4981,4982,2964,-1,4983,4980,2964,-1,2964,2963,4983,-1,2968,4981,4980,-1,4980,4984,2968,-1,4981,4985,4986,-1,4986,4982,4981,-1,4987,4955,2964,-1,2964,4982,4987,-1,4986,4988,4987,-1,4987,4982,4986,-1,2953,2955,4988,-1,4988,4986,2953,-1,4987,4988,4989,-1,4989,4990,4987,-1,2970,4989,4988,-1,4988,2955,2970,-1,4985,2967,2953,-1,2953,4986,4985,-1,4991,4992,4950,-1,4950,2997,4991,-1,4993,4994,4992,-1,4992,4991,4993,-1,4995,4951,4950,-1,4950,4992,4995,-1,2945,2944,2997,-1,2997,4950,2945,-1,4996,4997,4991,-1,4991,2997,4996,-1,4998,4999,4994,-1,4994,4993,4998,-1,5000,4995,4992,-1,4992,4994,5000,-1,4991,4997,5001,-1,5001,4993,4991,-1,5002,4997,4996,-1,4996,5003,5002,-1,5001,4997,5002,-1,5002,5004,5001,-1,5005,5003,4996,-1,4996,5006,5005,-1,5007,5008,5002,-1,5002,5003,5007,-1,5008,5009,5004,-1,5004,5002,5008,-1,5010,5001,5004,-1,5004,5011,5010,-1,4984,4999,4998,-1,4998,5012,4984,-1,4994,4999,4983,-1,4983,5000,4994,-1,5001,5010,4998,-1,4998,4993,5001,-1,5013,5011,5004,-1,5004,5009,5013,-1,5014,5010,5011,-1,5011,5015,5014,-1,5012,4998,5010,-1,5010,5014,5012,-1,5016,5015,5011,-1,5011,5013,5016,-1,2956,5014,5015,-1,5015,4959,2956,-1,2958,5012,5014,-1,5014,2956,2958,-1,4960,4959,5015,-1,5015,5016,4960,-1,2947,5017,5018,-1,5018,2948,2947,-1,2947,2975,5019,-1,5019,5017,2947,-1,2943,2942,5018,-1,5018,5017,2943,-1,5018,5020,2959,-1,2959,2948,5018,-1,2948,2960,2961,-1,2961,5021,2948,-1,4951,4995,5021,-1,5021,2961,4951,-1,2949,2948,5021,-1,5021,4956,2949,-1,5021,4995,5000,-1,5000,4956,5021,-1,5000,4983,2963,-1,2963,4956,5000,-1,4951,2961,4953,-1,4953,4947,4951,-1,4983,4999,4984,-1,4984,4980,4983,-1,2968,2967,4985,-1,4985,4981,2968,-1,4984,5012,2958,-1,2958,2968,4984,-1,4953,2961,2962,-1,2962,2989,4953,-1,4974,2989,2988,-1,2988,4975,4974,-1,4973,5022,5023,-1,5023,4972,4973,-1,5022,4973,5024,-1,5024,5025,5022,-1,5026,5023,5022,-1,5022,5027,5026,-1,5023,5028,5029,-1,5029,4972,5023,-1,4962,4972,5029,-1,5029,4966,4962,-1,4973,4965,4971,-1,4971,5024,4973,-1,5027,5030,5031,-1,5031,5026,5027,-1,5030,5027,5032,-1,5032,5033,5030,-1,5030,5034,5035,-1,5035,5031,5030,-1,5026,5031,3003,-1,3003,3002,5026,-1,5023,5026,3002,-1,3002,5028,5023,-1,5027,5022,5025,-1,5025,5032,5027,-1,5034,5030,5033,-1,5033,5036,5034,-1,5037,5035,5034,-1,5034,5038,5037,-1,3003,5031,5035,-1,5035,2999,3003,-1,2999,5035,5037,-1,5037,3000,2999,-1,5038,5034,5036,-1,5036,5039,5038,-1,5037,5038,5040,-1,5040,5041,5037,-1,2942,5042,5020,-1,5020,5018,2942,-1,3007,5042,2942,-1,2942,2941,3007,-1,5043,5020,5042,-1,5042,2992,5043,-1,5044,2970,2969,-1,2969,5045,5044,-1,2952,5046,4978,-1,4978,2950,2952,-1,4958,4960,5047,-1,5047,4961,4958,-1,5016,5048,5047,-1,5047,4960,5016,-1,4961,5047,5049,-1,5049,5050,4961,-1,5048,5051,5049,-1,5049,5047,5048,-1,5050,5049,5052,-1,5052,5053,5050,-1,5050,5045,2969,-1,2969,4961,5050,-1,5045,2973,2972,-1,2972,5044,5045,-1,5053,2973,5045,-1,5045,5050,5053,-1,2972,2987,5054,-1,5054,5044,2972,-1,2970,5044,5054,-1,5054,4989,2970,-1,5051,5055,5052,-1,5052,5049,5051,-1,5056,5053,5052,-1,5052,5057,5056,-1,4975,5058,5059,-1,5059,4976,4975,-1,5060,5046,2952,-1,2952,4976,5060,-1,5060,5061,5062,-1,5062,5046,5060,-1,5063,5060,4976,-1,4976,5059,5063,-1,5064,5065,5066,-1,5066,5067,5064,-1,5059,5058,5065,-1,5065,5064,5059,-1,5043,5066,5065,-1,5065,5068,5043,-1,5067,5066,2991,-1,2991,5069,5067,-1,5067,5070,5071,-1,5071,5064,5067,-1,2992,2991,5066,-1,5066,5043,2992,-1,2990,5040,5069,-1,5069,2991,2990,-1,5069,5039,5070,-1,5070,5067,5069,-1,5068,5065,5058,-1,5058,5072,5068,-1,5064,5071,5063,-1,5063,5059,5064,-1,2943,5017,5019,-1,5019,4918,2943,-1,5073,5019,2975,-1,2975,5074,5073,-1,5075,5076,5008,-1,5008,5007,5075,-1,5077,5007,5003,-1,5003,5005,5077,-1,5076,5075,5078,-1,5078,5079,5076,-1,5076,5080,5009,-1,5009,5008,5076,-1,5081,5075,5007,-1,5007,5077,5081,-1,5075,5081,5082,-1,5082,5078,5075,-1,5083,5084,5079,-1,5079,5078,5083,-1,5079,2979,5080,-1,5080,5076,5079,-1,5085,5086,5084,-1,5084,5083,5085,-1,5084,2977,2979,-1,2979,5079,5084,-1,5087,5083,5078,-1,5078,5082,5087,-1,4970,5088,5086,-1,5086,5085,4970,-1,5086,5089,2977,-1,2977,5084,5086,-1,5090,5085,5083,-1,5083,5087,5090,-1,4964,4969,5088,-1,5088,4970,4964,-1,5088,5091,5089,-1,5089,5086,5088,-1,4971,4970,5085,-1,5085,5090,4971,-1,4969,5092,5091,-1,5091,5088,4969,-1,4967,5093,4968,-1,4968,4963,4967,-1,4968,5094,5092,-1,5092,4969,4968,-1,5095,5096,5093,-1,5093,4967,5095,-1,5093,5097,5094,-1,5094,4968,5093,-1,4935,4934,5096,-1,5096,5095,4935,-1,5096,5098,5097,-1,5097,5093,5096,-1,5095,4967,4966,-1,4966,5099,5095,-1,4934,4943,5098,-1,5098,5096,4934,-1,4935,5095,5099,-1,5099,4936,4935,-1,5006,4996,2997,-1,2997,2996,5006,-1,5009,5080,5100,-1,5100,5013,5009,-1,2979,2978,5100,-1,5100,5080,2979,-1,5089,5101,2978,-1,2978,2977,5089,-1,5091,5102,5101,-1,5101,5089,5091,-1,5092,5103,5102,-1,5102,5091,5092,-1,5094,5104,5103,-1,5103,5092,5094,-1,5097,5105,5104,-1,5104,5094,5097,-1,5098,5106,5105,-1,5105,5097,5098,-1,4943,4938,5106,-1,5106,5098,4943,-1,5100,5048,5016,-1,5016,5013,5100,-1,2978,5051,5048,-1,5048,5100,2978,-1,5101,5055,5051,-1,5051,2978,5101,-1,5102,5107,5055,-1,5055,5101,5102,-1,5103,5108,5107,-1,5107,5102,5103,-1,5104,5109,5108,-1,5108,5103,5104,-1,5105,5110,5109,-1,5109,5104,5105,-1,5106,5111,5110,-1,5110,5105,5106,-1,4938,4943,2936,-1,2936,2935,4938,-1,4938,4937,5111,-1,5111,5106,4938,-1,5055,5107,5057,-1,5057,5052,5055,-1,5107,5108,2981,-1,2981,5057,5107,-1,5108,5109,2982,-1,2982,2981,5108,-1,5109,5110,2983,-1,2983,2982,5109,-1,5110,5111,2985,-1,2985,2983,5110,-1,5111,4937,2986,-1,2986,2985,5111,-1,2980,5056,5057,-1,5057,2981,2980,-1,2974,2973,5053,-1,5053,5056,2974,-1,4989,5054,5074,-1,5074,4990,4989,-1,2987,5073,5074,-1,5074,5054,2987,-1,5074,2975,2976,-1,2976,4990,5074,-1,5073,2987,2621,-1,2621,4767,5073,-1,4990,2976,4955,-1,4955,4987,4990,-1,4918,5019,5073,-1,5073,4767,4918,-1,2959,5068,5072,-1,5072,2960,2959,-1,5020,5043,5068,-1,5068,2959,5020,-1,2960,5072,2988,-1,2988,2962,2960,-1,5072,5058,4975,-1,4975,2988,5072,-1,5042,3007,5112,-1,5112,2992,5042,-1,2990,5113,5041,-1,5041,5040,2990,-1,5069,5040,5038,-1,5038,5039,5069,-1,5046,5062,5114,-1,5114,4978,5046,-1,5071,5115,5116,-1,5116,5063,5071,-1,5070,5117,5115,-1,5115,5071,5070,-1,5039,5036,5117,-1,5117,5070,5039,-1,5114,5118,4979,-1,4979,4978,5114,-1,4977,4979,2993,-1,2993,2995,4977,-1,5062,5119,5118,-1,5118,5114,5062,-1,5118,5120,2993,-1,2993,4979,5118,-1,5116,5061,5060,-1,5060,5063,5116,-1,5061,5121,5119,-1,5119,5062,5061,-1,5115,5122,5123,-1,5123,5116,5115,-1,5117,5124,5122,-1,5122,5115,5117,-1,5036,5033,5124,-1,5124,5117,5036,-1,5119,5125,5120,-1,5120,5118,5119,-1,5123,5121,5061,-1,5061,5116,5123,-1,5121,5126,5125,-1,5125,5119,5121,-1,5122,5127,5128,-1,5128,5123,5122,-1,5124,5129,5127,-1,5127,5122,5124,-1,5033,5032,5129,-1,5129,5124,5033,-1,5128,5126,5121,-1,5121,5123,5128,-1,5126,5130,5131,-1,5131,5125,5126,-1,5120,5132,2994,-1,2994,2993,5120,-1,5120,5125,5131,-1,5131,5132,5120,-1,5127,5133,5134,-1,5134,5128,5127,-1,5129,5135,5133,-1,5133,5127,5129,-1,5032,5025,5135,-1,5135,5129,5032,-1,2994,5136,4946,-1,4946,2995,2994,-1,4946,2996,2944,-1,2944,2946,4946,-1,5132,5137,5136,-1,5136,2994,5132,-1,5132,5131,5138,-1,5138,5137,5132,-1,5134,5130,5126,-1,5126,5128,5134,-1,5130,5139,5138,-1,5138,5131,5130,-1,5133,5140,5141,-1,5141,5134,5133,-1,5135,5142,5140,-1,5140,5133,5135,-1,5025,5024,5142,-1,5142,5135,5025,-1,5136,5006,2996,-1,2996,4946,5136,-1,5137,5005,5006,-1,5006,5136,5137,-1,5138,5077,5005,-1,5005,5137,5138,-1,5141,5139,5130,-1,5130,5134,5141,-1,5139,5081,5077,-1,5077,5138,5139,-1,5140,5087,5082,-1,5082,5141,5140,-1,5142,5090,5087,-1,5087,5140,5142,-1,5024,4971,5090,-1,5090,5142,5024,-1,5082,5081,5139,-1,5139,5141,5082,-1,4933,5143,2998,-1,2998,2940,4933,-1,4933,4942,3001,-1,3001,5143,4933,-1,5143,5144,5145,-1,5145,2998,5143,-1,4941,3004,3001,-1,3001,4942,4941,-1,3001,3000,5144,-1,5144,5143,3001,-1,4940,5146,3004,-1,3004,4941,4940,-1,3004,3003,2999,-1,2999,3001,3004,-1,4939,5147,5146,-1,5146,4940,4939,-1,5146,5028,3002,-1,3002,3004,5146,-1,4939,4936,5099,-1,5099,5147,4939,-1,5147,5029,5028,-1,5028,5146,5147,-1,5099,4966,5029,-1,5029,5147,5099,-1,5144,5041,5113,-1,5113,5145,5144,-1,2998,5145,5148,-1,5148,2933,2998,-1,3000,5037,5041,-1,5041,5144,3000,-1,5112,5148,5145,-1,5145,5113,5112,-1,5113,2990,2992,-1,2992,5112,5113,-1,5148,5112,3007,-1,3007,3006,5148,-1,5148,3006,3005,-1,3005,2933,5148,-1,2980,3008,2974,-1,2974,5056,2980,-1,3008,3009,4337,-1,4337,2623,3008,-1,2938,4337,3009,-1,3009,2984,2938,-1,4704,4717,4060,-1,4060,4033,4704,-1,4100,4102,4738,-1,4738,4410,4100,-1,5149,5150,3012,-1,3012,3011,5149,-1,5150,5149,5151,-1,5151,5152,5150,-1,3012,5150,5153,-1,5153,5154,3012,-1,5155,3315,5149,-1,5149,3011,5155,-1,3015,3014,5156,-1,5156,3252,3015,-1,3015,5157,3020,-1,3020,3013,3015,-1,3013,3019,5158,-1,5158,3018,3013,-1,3019,3020,5159,-1,5159,5160,3019,-1,5157,3015,3252,-1,3252,3253,5157,-1,3020,5157,5161,-1,5161,5159,3020,-1,4161,3021,3023,-1,3023,4158,4161,-1,5162,3021,4161,-1,4161,4167,5162,-1,4158,3023,5163,-1,5163,4182,4158,-1,4165,4727,4698,-1,4698,4162,4165,-1,4727,4165,3158,-1,3158,3159,4727,-1,4698,5162,4167,-1,4167,4162,4698,-1,3209,5164,3022,-1,3022,3021,3209,-1,3023,3022,3154,-1,3154,5163,3023,-1,3151,3209,3021,-1,3021,5162,3151,-1,5165,3025,3024,-1,3024,5166,5165,-1,3025,5167,3207,-1,3207,3026,3025,-1,3029,3028,3037,-1,3037,5168,3029,-1,3030,3029,5169,-1,5169,5170,3030,-1,3035,3029,5168,-1,5168,3034,3035,-1,3029,3035,3082,-1,3082,5169,3029,-1,5171,3034,5168,-1,5168,3046,5171,-1,3037,5172,3046,-1,3046,5168,3037,-1,3040,3039,5173,-1,5173,3031,3040,-1,3039,3257,5174,-1,5174,5173,3039,-1,3031,5173,3038,-1,3038,3028,3031,-1,3031,3030,5170,-1,5170,3040,3031,-1,3041,3213,3257,-1,3257,3039,3041,-1,5174,3257,3256,-1,3256,3286,5174,-1,3038,5173,5174,-1,5174,5175,3038,-1,3043,3042,5176,-1,5176,5177,3043,-1,3043,5178,5172,-1,5172,3044,3043,-1,3044,3038,5175,-1,5175,3042,3044,-1,5177,5179,5178,-1,5178,3043,5177,-1,5178,3047,3046,-1,3046,5172,5178,-1,3044,5172,3037,-1,3037,3038,3044,-1,3047,5178,5179,-1,5179,5180,3047,-1,3048,3047,5180,-1,5180,5181,3048,-1,3045,3048,5182,-1,5182,5183,3045,-1,5184,5182,3048,-1,3048,5181,5184,-1,5182,5185,3069,-1,3069,5183,5182,-1,3046,3045,5183,-1,5183,5171,3046,-1,5182,5184,5186,-1,5186,5185,5182,-1,3052,3054,5186,-1,5186,5184,3052,-1,5186,5187,5188,-1,5188,5185,5186,-1,3050,3049,5189,-1,5189,3233,3050,-1,5190,5189,3049,-1,3049,5191,5190,-1,3233,5189,5192,-1,5192,3231,3233,-1,3050,3233,3232,-1,3232,5193,3050,-1,5193,3054,3051,-1,3051,3050,5193,-1,3049,3051,3053,-1,3053,5191,3049,-1,5192,5194,3206,-1,3206,3231,5192,-1,5194,5192,5189,-1,5189,5190,5194,-1,5194,3026,3207,-1,3207,3206,5194,-1,3232,3231,3206,-1,3206,3208,3232,-1,3056,3238,3237,-1,3237,3057,3056,-1,3057,5195,5196,-1,5196,3058,3057,-1,3058,5197,5198,-1,5198,3056,3058,-1,3057,3237,3249,-1,3249,5195,3057,-1,5195,5199,5200,-1,5200,5196,5195,-1,5197,3058,5196,-1,5196,5201,5197,-1,3249,3251,5199,-1,5199,5195,3249,-1,3324,3326,5200,-1,5200,5199,3324,-1,5200,5202,5201,-1,5201,5196,5200,-1,3060,3059,3063,-1,3063,3065,3060,-1,3065,5203,5204,-1,5204,3060,3065,-1,3062,3059,3061,-1,3061,3147,3062,-1,3063,3062,3068,-1,3068,3064,3063,-1,3066,3296,3295,-1,3295,3067,3066,-1,3067,5205,3064,-1,3064,3068,3067,-1,3062,5206,3066,-1,3066,3068,3062,-1,5205,3067,3295,-1,3295,5207,5205,-1,5205,5203,3065,-1,3065,3064,5205,-1,5203,5205,5207,-1,5207,5208,5203,-1,3071,3070,3072,-1,3072,3032,3071,-1,3033,3032,3072,-1,3072,2538,3033,-1,5171,3071,3032,-1,3032,3034,5171,-1,3069,3071,5171,-1,5171,5183,3069,-1,3076,3074,3073,-1,3073,5209,3076,-1,3087,3075,3074,-1,3074,3085,3087,-1,3090,3073,3075,-1,3075,3088,3090,-1,3078,3085,3074,-1,3074,3077,3078,-1,3085,3078,5210,-1,5210,3086,3085,-1,5211,3079,3077,-1,3077,3076,5211,-1,3080,2545,3081,-1,3081,5211,3080,-1,3079,5211,3081,-1,3081,5212,3079,-1,5213,3080,5211,-1,5211,3076,5213,-1,4236,2564,3080,-1,3080,5213,4236,-1,5213,3076,5209,-1,5209,5214,5213,-1,3083,3082,3036,-1,3036,2537,3083,-1,3083,5215,5216,-1,5216,3082,3083,-1,5217,3097,3087,-1,3087,3086,5217,-1,5209,3073,3090,-1,3090,5218,5209,-1,3095,5219,3094,-1,3094,3093,3095,-1,5217,3205,5219,-1,5219,3095,5217,-1,5219,3144,3143,-1,3143,3094,5219,-1,3096,3093,5220,-1,5220,3098,3096,-1,5217,3095,3096,-1,3096,3097,5217,-1,4739,4738,5221,-1,5221,5222,4739,-1,4102,4239,5221,-1,5221,4738,4102,-1,5223,5222,5221,-1,5221,5224,5223,-1,4740,4739,5222,-1,5222,5225,4740,-1,5223,3091,5225,-1,5225,5222,5223,-1,4718,4740,5225,-1,5225,5226,4718,-1,5226,5225,3091,-1,3091,5227,5226,-1,4463,4718,5226,-1,5226,5228,4463,-1,5212,3081,3070,-1,3070,3099,5212,-1,5212,3099,5188,-1,5188,5229,5212,-1,3078,3079,5212,-1,5212,5229,3078,-1,3078,5229,5230,-1,5230,5210,3078,-1,3099,3069,5185,-1,5185,5188,3099,-1,5187,5230,5229,-1,5229,5188,5187,-1,3105,3101,5231,-1,5231,5232,3105,-1,3104,3105,5232,-1,5232,5233,3104,-1,3103,3104,5233,-1,5233,5234,3103,-1,3102,3103,5234,-1,5234,5235,3102,-1,3100,3102,5235,-1,5235,5236,3100,-1,3111,3112,5237,-1,5237,5238,3111,-1,3110,3111,5238,-1,5238,5239,3110,-1,3109,3110,5239,-1,5239,5240,3109,-1,3107,3109,5240,-1,5240,5241,3107,-1,3107,3101,3106,-1,3106,3108,3107,-1,3112,3108,5242,-1,5242,5237,3112,-1,5236,5235,5243,-1,5243,5244,5236,-1,3106,3100,5236,-1,5236,5245,3106,-1,5235,5234,5246,-1,5246,5243,5235,-1,5234,5233,5247,-1,5247,5246,5234,-1,5233,5232,5248,-1,5248,5247,5233,-1,3101,3107,5241,-1,5241,5231,3101,-1,5232,5231,5249,-1,5249,5248,5232,-1,5231,5241,5250,-1,5250,5249,5231,-1,5241,5240,5251,-1,5251,5250,5241,-1,5240,5239,5252,-1,5252,5251,5240,-1,5239,5238,5253,-1,5253,5252,5239,-1,5238,5237,5254,-1,5254,5253,5238,-1,3108,3106,5245,-1,5245,5242,3108,-1,5237,5242,5255,-1,5255,5254,5237,-1,5242,5245,5256,-1,5256,5255,5242,-1,5245,5236,5244,-1,5244,5256,5245,-1,5244,5243,2829,-1,2829,4463,5244,-1,5243,5246,2827,-1,2827,2829,5243,-1,5246,5247,5257,-1,5257,2827,5246,-1,5247,5248,5258,-1,5258,5257,5247,-1,5248,5249,5259,-1,5259,5258,5248,-1,5249,5250,5260,-1,5260,5259,5249,-1,5250,5251,5261,-1,5261,5260,5250,-1,5251,5252,5262,-1,5262,5261,5251,-1,5252,5253,5263,-1,5263,5262,5252,-1,5253,5254,3113,-1,3113,5263,5253,-1,5254,5255,3114,-1,3114,3113,5254,-1,5255,5256,5228,-1,5228,3114,5255,-1,5256,5244,4463,-1,4463,5228,5256,-1,2827,5257,3126,-1,3126,2828,2827,-1,5258,3127,3126,-1,3126,5257,5258,-1,3127,5258,5259,-1,5259,5264,3127,-1,5260,5265,5264,-1,5264,5259,5260,-1,5260,5261,5266,-1,5266,5265,5260,-1,5267,5266,5261,-1,5261,5262,5267,-1,5262,5263,5268,-1,5268,5267,5262,-1,5268,5263,3113,-1,3113,5269,5268,-1,3114,5228,5226,-1,5226,5227,3114,-1,3118,5270,3136,-1,3136,3116,3118,-1,3118,3119,3141,-1,3141,5270,3118,-1,5271,3137,3136,-1,3136,5270,5271,-1,3124,3116,3136,-1,3136,3122,3124,-1,3119,3117,3121,-1,3121,3139,3119,-1,3125,3120,3117,-1,3117,3116,3125,-1,5272,5273,3120,-1,3120,3125,5272,-1,3116,3124,3092,-1,3092,3125,3116,-1,3093,3092,3124,-1,3124,3123,3093,-1,3123,5274,5220,-1,5220,3093,3123,-1,3122,5275,5274,-1,5274,3123,3122,-1,5274,5269,5276,-1,5276,5220,5274,-1,5277,3115,3114,-1,3114,5227,5277,-1,5269,3113,3115,-1,3115,5276,5269,-1,3120,5273,5278,-1,5278,3121,3120,-1,3143,5272,3125,-1,3125,3094,3143,-1,5274,5275,5268,-1,5268,5269,5274,-1,3098,5220,5276,-1,5276,3135,3098,-1,5277,3135,5276,-1,5276,3115,5277,-1,5279,4479,4480,-1,4480,5280,5279,-1,5279,3132,4500,-1,4500,4479,5279,-1,4719,5281,5280,-1,5280,4480,4719,-1,5279,5280,3130,-1,3130,5282,5279,-1,3130,5280,5281,-1,5281,3128,3130,-1,4719,4494,3128,-1,3128,5281,4719,-1,3128,4494,2828,-1,2828,3126,3128,-1,5283,3129,3127,-1,3127,5264,5283,-1,3129,5284,5282,-1,5282,3130,3129,-1,3131,4917,2742,-1,2742,2830,3131,-1,3131,3134,3140,-1,3140,4917,3131,-1,3132,3131,2830,-1,2830,4500,3132,-1,5279,5282,3133,-1,3133,3132,5279,-1,5284,3129,5283,-1,5283,5285,5284,-1,5286,5283,5264,-1,5264,5265,5286,-1,5286,5287,5285,-1,5285,5283,5286,-1,5288,5286,5265,-1,5265,5266,5288,-1,5271,5287,5286,-1,5286,5288,5271,-1,5289,5288,5266,-1,5266,5267,5289,-1,3137,5271,5288,-1,5288,5289,3137,-1,5275,5289,5267,-1,5267,5268,5275,-1,5277,5227,3091,-1,3091,3088,5277,-1,5282,5284,3134,-1,3134,3133,5282,-1,3134,5284,5285,-1,5285,3138,3134,-1,3122,3137,5289,-1,5289,5275,3122,-1,3135,5277,3088,-1,3088,3089,3135,-1,3098,3089,3075,-1,3075,3097,3098,-1,3138,5285,5287,-1,5287,3141,3138,-1,5290,3140,3121,-1,3121,5278,5290,-1,3140,5290,4915,-1,4915,4917,3140,-1,5291,5290,5278,-1,5278,5292,5291,-1,5291,4916,4915,-1,4915,5290,5291,-1,5293,5292,5278,-1,5278,5273,5293,-1,5294,5291,5292,-1,5292,5295,5294,-1,4724,4916,5291,-1,5291,5294,4724,-1,5293,5296,5295,-1,5295,5292,5293,-1,5297,5294,5295,-1,5295,3189,5297,-1,4725,4724,5294,-1,5294,5297,4725,-1,5296,3190,3189,-1,3189,5295,5296,-1,5297,3189,3187,-1,3187,3186,5297,-1,5298,3144,5219,-1,5219,3205,5298,-1,3149,3151,5162,-1,5162,4698,3149,-1,3145,5299,4178,-1,4178,3146,3145,-1,3210,3209,3151,-1,3151,3150,3210,-1,3186,3149,4698,-1,4698,4699,3186,-1,5300,5301,3153,-1,3153,3152,5300,-1,5163,3154,3153,-1,3153,5302,5163,-1,5164,3152,3154,-1,3154,3022,5164,-1,3182,5300,3152,-1,3152,5164,3182,-1,3183,3182,5164,-1,5164,3209,3183,-1,5303,3155,3157,-1,3157,4172,5303,-1,4728,3156,3155,-1,3155,5304,4728,-1,5304,3155,5303,-1,5303,5305,5304,-1,5306,5303,4172,-1,4172,4174,5306,-1,5305,5303,5306,-1,5306,5307,5305,-1,5308,5306,4174,-1,4174,4176,5308,-1,5307,5306,5308,-1,5308,5309,5307,-1,5299,5308,4176,-1,4176,4178,5299,-1,5299,5310,5309,-1,5309,5308,5299,-1,5310,5299,3145,-1,3145,3061,5310,-1,5311,5312,5313,-1,5313,5314,5311,-1,5311,3314,5315,-1,5315,5312,5311,-1,5316,5317,5313,-1,5313,5312,5316,-1,5318,5319,5314,-1,5314,5313,5318,-1,5320,5311,5314,-1,5314,5321,5320,-1,5322,5323,5324,-1,5324,5325,5322,-1,5322,5326,5327,-1,5327,5323,5322,-1,5324,5323,5328,-1,5328,5329,5324,-1,5330,5325,5324,-1,5324,5331,5330,-1,5325,5332,5333,-1,5333,5322,5325,-1,5316,5334,5335,-1,5335,5317,5316,-1,5336,5318,5313,-1,5313,5317,5336,-1,5312,5315,5337,-1,5337,5316,5312,-1,5338,5339,5340,-1,5340,3177,5338,-1,5338,5341,5342,-1,5342,5339,5338,-1,5339,5330,5331,-1,5331,5340,5339,-1,3180,3177,5340,-1,5340,5343,3180,-1,5334,5338,3177,-1,3177,5335,5334,-1,5339,5342,5344,-1,5344,5330,5339,-1,5340,5331,5345,-1,5345,5343,5340,-1,5330,5344,5332,-1,5332,5325,5330,-1,5331,5324,5329,-1,5329,5345,5331,-1,5322,5333,5346,-1,5346,5326,5322,-1,5326,5347,3161,-1,3161,5327,5326,-1,5323,5327,3164,-1,3164,5328,5323,-1,5326,5346,5348,-1,5348,5347,5326,-1,5347,5349,3162,-1,3162,3161,5347,-1,3161,3160,3164,-1,3164,5327,3161,-1,5347,5348,5350,-1,5350,5349,5347,-1,5349,5351,5352,-1,5352,3162,5349,-1,5349,5350,5353,-1,5353,5351,5349,-1,5351,5354,5355,-1,5355,5352,5351,-1,3162,5352,5356,-1,5356,3170,3162,-1,5351,5353,5357,-1,5357,5354,5351,-1,5321,5355,5354,-1,5354,5320,5321,-1,5358,5356,5352,-1,5352,5355,5358,-1,5320,3312,3314,-1,3314,5311,5320,-1,5319,5359,5321,-1,5321,5314,5319,-1,5316,5337,5360,-1,5360,5334,5316,-1,5361,5336,5317,-1,5317,5335,5361,-1,5334,5360,5341,-1,5341,5338,5334,-1,3179,5361,5335,-1,5335,3177,3179,-1,3163,3160,3192,-1,3192,5362,3163,-1,3168,3171,3192,-1,3192,3160,3168,-1,5362,3192,5363,-1,5363,5364,5362,-1,5362,5365,5366,-1,5366,3163,5362,-1,5367,3166,3165,-1,3165,5368,5367,-1,3166,3180,5343,-1,5343,3167,3166,-1,5369,3165,3167,-1,3167,5370,5369,-1,5365,5362,5364,-1,5364,5371,5365,-1,5365,5372,5373,-1,5373,5366,5365,-1,3164,3163,5366,-1,5366,5328,3164,-1,5372,5365,5371,-1,5371,5374,5372,-1,5372,5369,5370,-1,5370,5373,5372,-1,5329,5328,5366,-1,5366,5373,5329,-1,5369,5372,5374,-1,5374,5375,5369,-1,5345,5329,5373,-1,5373,5370,5345,-1,5369,5375,5368,-1,5368,3165,5369,-1,3167,5343,5345,-1,5345,5370,3167,-1,3172,3169,3170,-1,3170,5356,3172,-1,5376,3172,5356,-1,5356,5358,5376,-1,3173,3172,5376,-1,5376,5377,3173,-1,5378,5376,5358,-1,5358,5359,5378,-1,5379,5378,5359,-1,5359,5319,5379,-1,5380,5378,5379,-1,5379,5381,5380,-1,5382,5379,5319,-1,5319,5318,5382,-1,5381,5379,5382,-1,5382,5383,5381,-1,5384,5382,5318,-1,5318,5336,5384,-1,5383,5382,5384,-1,5384,5385,5383,-1,5386,5384,5336,-1,5336,5361,5386,-1,5385,5384,5386,-1,5386,5387,5385,-1,3174,5386,5361,-1,5361,3179,3174,-1,5387,5386,3174,-1,3174,3176,5387,-1,3175,3174,3179,-1,3179,3178,3175,-1,3175,3180,3166,-1,3166,3194,3175,-1,5380,5381,3182,-1,3182,3181,5380,-1,3182,5381,5383,-1,5383,5300,3182,-1,3181,5388,5377,-1,5377,5380,3181,-1,5389,3185,3175,-1,3175,3193,5389,-1,5390,5387,3176,-1,3176,3185,5390,-1,3184,3150,3188,-1,3188,3169,3184,-1,3184,3173,5377,-1,5377,5388,3184,-1,5301,5385,5387,-1,5387,5390,5301,-1,5390,3185,5389,-1,5389,5391,5390,-1,5388,3210,3150,-1,3150,3184,5388,-1,5380,5377,5376,-1,5376,5378,5380,-1,3183,3210,5388,-1,5388,3181,3183,-1,5300,5383,5385,-1,5385,5301,5300,-1,5301,5390,5391,-1,5391,3153,5301,-1,3171,3169,3188,-1,3188,3187,3171,-1,3150,3149,3186,-1,3186,3188,3150,-1,3194,3166,5367,-1,5367,5392,3194,-1,5367,5368,5393,-1,5393,5394,5367,-1,5363,3192,3191,-1,3191,3190,5363,-1,3187,3189,3191,-1,3191,3171,3187,-1,5395,5363,3190,-1,3190,5296,5395,-1,5395,5396,5364,-1,5364,5363,5395,-1,5371,5364,5396,-1,5396,5397,5371,-1,5397,3223,5374,-1,5374,5371,5397,-1,3223,5398,5375,-1,5375,5374,3223,-1,5398,5393,5368,-1,5368,5375,5398,-1,5392,5367,5394,-1,5394,3214,5392,-1,3193,3194,5392,-1,5392,5399,3193,-1,5400,5401,5402,-1,5402,5403,5400,-1,5401,5400,5404,-1,5404,5405,5401,-1,5406,5402,5401,-1,5401,5407,5406,-1,5408,5409,5403,-1,5403,5402,5408,-1,5403,5410,5411,-1,5411,5400,5403,-1,5412,5413,5414,-1,5414,5415,5412,-1,5413,5412,4885,-1,4885,4883,5413,-1,5414,5413,5416,-1,5416,5417,5414,-1,5418,5419,5415,-1,5415,5414,5418,-1,5415,5420,5421,-1,5421,5412,5415,-1,3293,5208,5207,-1,5207,5422,3293,-1,5208,3293,3292,-1,3292,5423,5208,-1,3295,3297,5422,-1,5422,5207,3295,-1,5424,5425,3293,-1,3293,5422,5424,-1,5426,5197,5201,-1,5201,5155,5426,-1,5427,5428,5429,-1,5429,5430,5427,-1,5431,5432,5428,-1,5428,5427,5431,-1,5428,2297,2293,-1,2293,5429,5428,-1,5430,5429,5433,-1,5433,5434,5430,-1,5435,5427,5430,-1,5430,5436,5435,-1,3196,3195,2268,-1,2268,2267,3196,-1,5437,2273,2268,-1,2268,3195,5437,-1,3196,2267,2301,-1,2301,5432,3196,-1,3197,3196,5432,-1,5432,5431,3197,-1,5438,5437,3195,-1,3195,3197,5438,-1,5439,3283,3198,-1,3198,3200,5439,-1,3281,3280,3283,-1,3283,5439,3281,-1,2187,3198,3283,-1,3283,2185,2187,-1,5440,5441,5439,-1,5439,3200,5440,-1,4751,4750,5442,-1,5442,5443,4751,-1,5444,5442,4750,-1,4750,4748,5444,-1,3212,3211,5443,-1,5443,5442,3212,-1,5443,5445,4714,-1,4714,4751,5443,-1,5446,5447,5448,-1,5448,5216,5446,-1,5446,4707,4706,-1,4706,5447,5446,-1,5449,5450,5448,-1,5448,5447,5449,-1,5169,3082,5216,-1,5216,5448,5169,-1,5215,5451,5446,-1,5446,5216,5215,-1,5451,4717,4707,-1,4707,5446,5451,-1,4716,5449,5447,-1,5447,4706,4716,-1,5394,5393,5452,-1,5452,5453,5394,-1,5454,5452,5393,-1,5393,5398,5454,-1,5165,5455,5453,-1,5453,5452,5165,-1,3214,5394,5453,-1,5453,3215,3214,-1,5456,5399,5392,-1,5392,3214,5456,-1,3222,5454,5398,-1,5398,3223,3222,-1,5457,3224,3223,-1,3223,5397,5457,-1,3142,5457,5397,-1,5397,5396,3142,-1,5458,3142,5396,-1,5396,5395,5458,-1,5293,5458,5395,-1,5395,5296,5293,-1,3148,3202,5399,-1,5399,5456,3148,-1,3216,5459,5456,-1,5456,3214,3216,-1,3202,5389,3193,-1,3193,5399,3202,-1,3201,5391,5389,-1,5389,3202,3201,-1,5302,3153,5391,-1,5391,3201,5302,-1,4180,5302,3201,-1,3201,2543,4180,-1,4182,5163,5302,-1,5302,4180,4182,-1,5307,5309,5460,-1,5460,5461,5307,-1,5305,5307,5461,-1,5461,3225,5305,-1,5304,5305,3225,-1,3225,3227,5304,-1,4728,5304,3227,-1,3227,4732,4728,-1,5458,5293,5273,-1,5273,5272,5458,-1,5457,3142,3144,-1,3144,5298,5457,-1,5462,5298,3205,-1,3205,3204,5462,-1,3224,5457,5298,-1,5298,5462,3224,-1,5167,5462,3204,-1,3204,3207,5167,-1,3222,3224,5462,-1,5462,5167,3222,-1,3204,3203,3208,-1,3208,3207,3204,-1,5167,3025,5454,-1,5454,3222,5167,-1,5452,5454,3025,-1,3025,5165,5452,-1,3027,5463,5166,-1,5166,3024,3027,-1,5455,5165,5166,-1,5166,5464,5455,-1,3208,3203,3086,-1,3086,5210,3208,-1,3026,5194,5190,-1,5190,3027,3026,-1,5359,5358,5355,-1,5355,5321,5359,-1,3211,5465,5445,-1,5445,5443,3211,-1,3288,3212,5442,-1,5442,5444,3288,-1,3211,3213,3041,-1,3041,5465,3211,-1,5465,5466,5467,-1,5467,5445,5465,-1,5465,3041,3040,-1,3040,5466,5465,-1,5450,5449,5467,-1,5467,5466,5450,-1,5445,5467,4715,-1,4715,4714,5445,-1,5467,5449,4716,-1,4716,4715,5467,-1,5170,5450,5466,-1,5466,3040,5170,-1,5450,5170,5169,-1,5169,5448,5450,-1,5215,3083,3084,-1,3084,4198,5215,-1,5451,5215,4198,-1,4198,4200,5451,-1,4200,4060,4717,-1,4717,5451,4200,-1,5287,5271,5270,-1,5270,3141,5287,-1,3216,3215,3218,-1,3218,5468,3216,-1,5455,3217,3215,-1,3215,5453,5455,-1,5459,3216,5468,-1,5468,5206,5459,-1,5206,5468,5469,-1,5469,3066,5206,-1,3062,3147,5459,-1,5459,5206,3062,-1,5468,3218,3220,-1,3220,5469,5468,-1,5464,3221,3217,-1,3217,5455,5464,-1,3240,3221,5464,-1,5464,5470,3240,-1,3240,3239,3219,-1,3219,3221,3240,-1,3142,5458,5272,-1,5272,3143,3142,-1,4699,4725,5297,-1,5297,3186,4699,-1,3147,3148,5456,-1,5456,5459,3147,-1,5310,3061,3060,-1,3060,5471,5310,-1,4871,4732,3227,-1,3227,3226,4871,-1,5472,3226,3225,-1,3225,5461,5472,-1,5309,5310,5471,-1,5471,5460,5309,-1,5472,5461,5460,-1,5460,5473,5472,-1,5473,5460,5471,-1,5471,5474,5473,-1,5474,5471,3060,-1,3060,5204,5474,-1,5469,5198,3296,-1,3296,3066,5469,-1,3220,3056,5198,-1,5198,5469,3220,-1,3056,3220,3219,-1,3219,3238,3056,-1,5470,5464,5166,-1,5166,5463,5470,-1,5218,5223,5224,-1,5224,5475,5218,-1,3091,5223,5218,-1,5218,3090,3091,-1,4237,2567,5475,-1,5475,5224,4237,-1,5209,5218,5475,-1,5475,5214,5209,-1,2566,4236,5213,-1,5213,5214,2566,-1,5210,5230,3232,-1,3232,3208,5210,-1,5180,3052,5184,-1,5184,5181,5180,-1,3052,5180,5476,-1,5476,3055,3052,-1,3054,5193,5187,-1,5187,5186,3054,-1,3232,5230,5187,-1,5187,5193,3232,-1,3203,3205,5217,-1,5217,3086,3203,-1,4239,4237,5224,-1,5224,5221,4239,-1,5214,5475,2567,-1,2567,2566,5214,-1,5477,3288,5444,-1,5444,3230,5477,-1,3286,3256,3288,-1,3288,5477,3286,-1,3230,5444,4748,-1,4748,3228,3230,-1,5478,5477,3230,-1,3230,3229,5478,-1,3287,3286,5477,-1,5477,5478,3287,-1,3229,4795,5479,-1,5479,5478,3229,-1,5180,5179,5480,-1,5480,5476,5180,-1,5177,5481,5480,-1,5480,5179,5177,-1,5191,3053,3055,-1,3055,5482,5191,-1,5190,5191,5482,-1,5482,3027,5190,-1,5483,5463,3027,-1,3027,5482,5483,-1,5484,5483,5482,-1,5482,3055,5484,-1,5485,5484,3055,-1,3055,5476,5485,-1,5486,5485,5476,-1,5476,5480,5486,-1,5481,5177,5176,-1,5176,5487,5481,-1,5488,5486,5480,-1,5480,5481,5488,-1,3248,3247,5486,-1,5486,5488,3248,-1,5488,5481,5487,-1,5487,5489,5488,-1,3247,3245,5485,-1,5485,5486,3247,-1,3245,3244,5484,-1,5484,5485,3245,-1,3244,5490,5483,-1,5483,5484,3244,-1,5490,5470,5463,-1,5463,5483,5490,-1,3235,3234,3252,-1,3252,5156,3235,-1,3240,5491,3234,-1,3234,3236,3240,-1,5491,3240,5470,-1,5470,5490,5491,-1,5491,3243,3242,-1,3242,3234,5491,-1,3243,5491,5490,-1,5490,3244,3243,-1,3234,3242,5492,-1,5492,3253,3234,-1,3241,3243,3245,-1,3245,3247,3241,-1,3242,3241,3255,-1,3255,5492,3242,-1,3246,3248,5493,-1,5493,5494,3246,-1,3248,5488,5489,-1,5489,5493,3248,-1,3237,3235,5156,-1,5156,3249,3237,-1,5426,3296,5198,-1,5198,5197,5426,-1,3014,3250,3249,-1,3249,5156,3014,-1,5495,3250,3014,-1,3014,3016,5495,-1,3389,5202,5200,-1,5200,3326,3389,-1,5202,3315,5155,-1,5155,5201,5202,-1,3389,3316,3315,-1,3315,5202,3389,-1,5496,5426,5155,-1,5155,5497,5496,-1,3297,3296,5426,-1,5426,5496,3297,-1,5497,5155,3011,-1,3011,3010,5497,-1,5498,5424,5496,-1,5496,5497,5498,-1,5161,5492,3255,-1,3255,5499,5161,-1,5157,3253,5492,-1,5492,5161,5157,-1,5499,3255,3254,-1,3254,5500,5499,-1,5159,5161,5499,-1,5499,3271,5159,-1,3241,3246,5494,-1,5494,3254,3241,-1,5500,3254,5494,-1,5494,5501,5500,-1,5502,5501,5494,-1,5494,5493,5502,-1,5440,5502,5493,-1,5493,5489,5440,-1,5441,5440,5489,-1,5489,5487,5441,-1,5503,5441,5487,-1,5487,5176,5503,-1,5504,5503,5176,-1,5176,3042,5504,-1,5504,3042,5175,-1,5175,3285,5504,-1,3286,3285,5175,-1,5175,5174,3286,-1,3260,5505,5506,-1,5506,5507,3260,-1,3259,5508,5505,-1,5505,3260,3259,-1,5505,5438,3197,-1,3197,5506,5505,-1,5507,5506,5509,-1,5509,5510,5507,-1,3274,3260,5507,-1,5507,3276,3274,-1,5508,5511,5438,-1,5438,5505,5508,-1,5506,3197,5431,-1,5431,5509,5506,-1,5511,3261,5437,-1,5437,5438,5511,-1,3261,2277,2273,-1,2273,5437,3261,-1,5508,3259,3322,-1,3322,5512,5508,-1,5512,5513,5511,-1,5511,5508,5512,-1,5513,5514,3261,-1,3261,5511,5513,-1,5160,5515,5513,-1,5513,5512,5160,-1,5515,5516,5514,-1,5514,5513,5515,-1,3261,5514,2316,-1,2316,2280,3261,-1,3019,5160,5512,-1,5512,3322,3019,-1,3321,5158,3019,-1,3019,3322,3321,-1,5515,5160,5159,-1,5159,3271,5515,-1,5516,5515,3271,-1,3271,3273,5516,-1,5514,5516,2311,-1,2311,2316,5514,-1,4795,4796,5517,-1,5517,5479,4795,-1,3282,3287,5478,-1,5478,5479,3282,-1,4796,4797,5518,-1,5518,5517,4796,-1,3280,3282,5479,-1,5479,5517,3280,-1,4797,2262,2282,-1,2282,5518,4797,-1,5518,3284,3280,-1,3280,5517,5518,-1,2282,2191,3284,-1,3284,5518,2282,-1,3262,5519,4801,-1,4801,3290,3262,-1,5519,5520,4806,-1,4806,4801,5519,-1,5520,5521,4810,-1,4810,4806,5520,-1,5521,5522,4814,-1,4814,4810,5521,-1,5522,5523,4818,-1,4818,4814,5522,-1,5523,5524,4822,-1,4822,4818,5523,-1,5524,5525,4826,-1,4826,4822,5524,-1,5525,2285,2249,-1,2249,4826,5525,-1,3264,5526,5519,-1,5519,3262,3264,-1,3289,3263,3262,-1,3262,3290,3289,-1,5526,5527,5520,-1,5520,5519,5526,-1,5527,5528,5521,-1,5521,5520,5527,-1,5528,5529,5522,-1,5522,5521,5528,-1,5529,5530,5523,-1,5523,5522,5529,-1,5530,5434,5524,-1,5524,5523,5530,-1,5434,5433,5525,-1,5525,5524,5434,-1,5433,2289,2285,-1,2285,5525,5433,-1,3265,5531,5526,-1,5526,3264,3265,-1,5531,5532,5527,-1,5527,5526,5531,-1,5532,5533,5528,-1,5528,5527,5532,-1,5533,5534,5529,-1,5529,5528,5533,-1,5534,5436,5530,-1,5530,5529,5534,-1,5436,5430,5434,-1,5434,5530,5436,-1,5429,2293,2289,-1,2289,5433,5429,-1,3267,5535,5531,-1,5531,3265,3267,-1,3266,3265,3264,-1,3264,5536,3266,-1,5535,5537,5532,-1,5532,5531,5535,-1,5537,5538,5533,-1,5533,5532,5537,-1,5538,5539,5534,-1,5534,5533,5538,-1,5539,5435,5436,-1,5436,5534,5539,-1,5535,3267,3269,-1,3269,5540,5535,-1,5540,5541,5537,-1,5537,5535,5540,-1,5541,5542,5538,-1,5538,5537,5541,-1,5542,5510,5539,-1,5539,5538,5542,-1,5510,5509,5435,-1,5435,5539,5510,-1,5509,5431,5427,-1,5427,5435,5509,-1,5432,2301,2297,-1,2297,5428,5432,-1,3270,3269,3267,-1,3267,5543,3270,-1,5540,3269,3268,-1,3268,3277,5540,-1,3277,5544,5541,-1,5541,5540,3277,-1,5544,3276,5542,-1,5542,5541,5544,-1,3276,5507,5510,-1,5510,5542,3276,-1,3277,3268,5153,-1,5153,3278,3277,-1,5544,3277,3279,-1,3279,5545,5544,-1,3276,5544,5545,-1,5545,3275,3276,-1,3271,5499,5500,-1,5500,3272,3271,-1,5546,3273,3272,-1,3272,5547,5546,-1,5500,5501,5547,-1,5547,3272,5500,-1,5516,3273,2308,-1,2308,2311,5516,-1,5149,3315,3317,-1,3317,5151,5149,-1,3319,5548,3259,-1,3259,3258,3319,-1,3275,5545,5549,-1,5549,5550,3275,-1,3279,3278,5551,-1,5551,5552,3279,-1,5154,5153,3268,-1,3268,5553,5154,-1,5554,5551,3278,-1,3278,5153,5554,-1,5553,5555,3012,-1,3012,5154,5553,-1,5556,5557,5555,-1,5555,5553,5556,-1,5558,3010,3012,-1,3012,5555,5558,-1,3010,5558,5498,-1,5498,5497,3010,-1,5555,5557,5559,-1,5559,5558,5555,-1,2304,2195,5560,-1,5560,3199,2304,-1,2195,2197,5546,-1,5546,5560,2195,-1,5561,3200,3199,-1,3199,5560,5561,-1,2187,2304,3199,-1,3199,3198,2187,-1,5546,2197,2308,-1,2308,3273,5546,-1,5560,5546,5547,-1,5547,5561,5560,-1,5502,5440,3200,-1,3200,5561,5502,-1,5503,5504,3282,-1,3282,3281,5503,-1,3283,3284,2191,-1,2191,2185,3283,-1,5504,3285,3287,-1,3287,3282,5504,-1,5501,5502,5561,-1,5561,5547,5501,-1,5441,5503,3281,-1,3281,5439,5441,-1,5423,5562,5474,-1,5474,5204,5423,-1,5562,5563,5473,-1,5473,5474,5562,-1,5563,5564,5472,-1,5472,5473,5563,-1,5565,4876,4871,-1,4871,3226,5565,-1,3292,5566,5562,-1,5562,5423,3292,-1,5203,5208,5423,-1,5423,5204,5203,-1,5566,5567,5563,-1,5563,5562,5566,-1,5567,5417,5564,-1,5564,5563,5567,-1,5564,5565,3226,-1,3226,5472,5564,-1,5417,5416,5565,-1,5565,5564,5417,-1,5416,4879,4876,-1,4876,5565,5416,-1,3294,5568,5566,-1,5566,3292,3294,-1,5568,5418,5567,-1,5567,5566,5568,-1,5418,5414,5417,-1,5417,5567,5418,-1,5413,4883,4879,-1,4879,5416,5413,-1,5569,5570,5568,-1,5568,3294,5569,-1,5568,5570,5419,-1,5419,5418,5568,-1,5412,5421,4888,-1,4888,4885,5412,-1,5421,5571,4891,-1,4891,4888,5421,-1,5571,5405,4895,-1,4895,4891,5571,-1,5405,5404,4898,-1,4898,4895,5405,-1,5404,5572,4901,-1,4901,4898,5404,-1,5572,5573,4903,-1,4903,4901,5572,-1,5573,3289,3291,-1,3291,4903,5573,-1,5420,5407,5571,-1,5571,5421,5420,-1,5407,5401,5405,-1,5405,5571,5407,-1,5400,5411,5572,-1,5572,5404,5400,-1,5411,5574,5573,-1,5573,5572,5411,-1,5574,3263,3289,-1,3289,5573,5574,-1,5419,5575,5420,-1,5420,5415,5419,-1,5575,5406,5407,-1,5407,5420,5575,-1,5410,5536,5574,-1,5574,5411,5410,-1,5536,3264,3263,-1,3263,5574,5536,-1,5570,5576,5575,-1,5575,5419,5570,-1,5576,5577,5406,-1,5406,5575,5576,-1,5577,5408,5402,-1,5402,5406,5577,-1,5409,5578,5410,-1,5410,5403,5409,-1,5578,3266,5536,-1,5536,5410,5578,-1,5579,5576,5570,-1,5570,5569,5579,-1,5580,5577,5576,-1,5576,5579,5580,-1,5581,5408,5577,-1,5577,5580,5581,-1,5582,5409,5408,-1,5408,5581,5582,-1,5543,5578,5409,-1,5409,5582,5543,-1,3267,3266,5578,-1,5578,5543,3267,-1,3293,5425,5569,-1,5569,3294,3293,-1,5425,5583,5579,-1,5579,5569,5425,-1,5583,5559,5580,-1,5580,5579,5583,-1,5559,5557,5581,-1,5581,5580,5559,-1,5557,5556,5582,-1,5582,5581,5557,-1,5556,3270,5543,-1,5543,5582,5556,-1,5498,5583,5425,-1,5425,5424,5498,-1,5558,5559,5583,-1,5583,5498,5558,-1,3268,3270,5556,-1,5556,5553,3268,-1,3297,5496,5424,-1,5424,5422,3297,-1,5584,3251,3250,-1,3250,5495,5584,-1,3324,5199,3251,-1,3251,5584,3324,-1,5552,5549,5545,-1,5545,3279,5552,-1,5548,3320,3322,-1,3322,3259,5548,-1,3258,3274,5585,-1,5585,3318,3258,-1,5153,5150,5152,-1,5152,5554,5153,-1,3313,3305,3311,-1,3311,5586,3313,-1,5587,3302,3305,-1,3305,3313,5587,-1,5588,3300,3302,-1,3302,5587,5588,-1,5589,3298,3300,-1,3300,5588,5589,-1,5590,3299,3298,-1,3298,5589,5590,-1,5591,3301,3299,-1,3299,5590,5591,-1,5592,3303,3301,-1,3301,5591,5592,-1,5593,3304,3303,-1,3303,5592,5593,-1,5594,3306,3304,-1,3304,5593,5594,-1,5595,3307,3306,-1,3306,5594,5595,-1,5596,3308,3307,-1,3307,5595,5596,-1,5597,3309,3308,-1,3308,5596,5597,-1,5598,3310,3309,-1,3309,5597,5598,-1,5586,3311,3310,-1,3310,5598,5586,-1,3314,3313,5586,-1,5586,5315,3314,-1,5315,5586,5598,-1,5598,5337,5315,-1,5337,5598,5597,-1,5597,5360,5337,-1,5360,5597,5596,-1,5596,5341,5360,-1,5341,5596,5595,-1,5595,5342,5341,-1,5342,5595,5594,-1,5594,5344,5342,-1,5344,5594,5593,-1,5593,5332,5344,-1,5332,5593,5592,-1,5592,5333,5332,-1,5333,5592,5591,-1,5591,5346,5333,-1,5346,5591,5590,-1,5590,5348,5346,-1,5348,5590,5589,-1,5589,5350,5348,-1,5350,5589,5588,-1,5588,5353,5350,-1,5353,5588,5587,-1,5587,5357,5353,-1,5320,5354,5357,-1,5357,3312,5320,-1,3312,5357,5587,-1,5587,3313,3312,-1,3275,5550,5585,-1,5585,3274,3275,-1,5599,5151,3317,-1,3317,3323,5599,-1,5585,5550,5600,-1,5600,5601,5585,-1,5600,5550,5549,-1,5549,5602,5600,-1,3319,5603,5604,-1,5604,5548,3319,-1,5548,5604,3369,-1,3369,3320,5548,-1,3368,3321,3320,-1,3320,3369,3368,-1,5602,5549,5552,-1,5552,5605,5602,-1,5605,5552,5551,-1,5551,5606,5605,-1,5606,5551,5554,-1,5554,5607,5606,-1,5607,5554,5152,-1,5152,5608,5607,-1,5608,5152,5151,-1,5151,5599,5608,-1,5585,5601,5609,-1,5609,3318,5585,-1,5610,3328,3327,-1,3327,5611,5610,-1,5610,5612,5613,-1,5613,3328,5610,-1,5611,3327,5614,-1,5614,3376,5611,-1,5611,5615,5612,-1,5612,5610,5611,-1,5616,5613,5612,-1,5612,5617,5616,-1,5613,5618,5619,-1,5619,3328,5613,-1,3346,3330,3332,-1,3332,5620,3346,-1,3348,5621,3330,-1,3330,3346,3348,-1,5622,5620,3332,-1,3332,3358,5622,-1,5620,5622,3347,-1,3347,3346,5620,-1,3337,3352,5623,-1,5623,5624,3337,-1,3352,3337,3336,-1,3336,3353,3352,-1,5623,3352,3354,-1,3354,5625,5623,-1,5626,5627,5624,-1,5624,5623,5626,-1,3337,5624,3340,-1,3340,3351,3337,-1,5624,5627,3341,-1,3341,3340,5624,-1,3349,3351,3340,-1,3340,3339,3349,-1,3337,3351,3350,-1,3350,3338,3337,-1,5628,5629,5630,-1,5630,5631,5628,-1,5632,5633,5629,-1,5629,5628,5632,-1,5629,5634,5635,-1,5635,5630,5629,-1,5630,5636,5637,-1,5637,5631,5630,-1,5638,5628,5631,-1,5631,5639,5638,-1,3334,3333,5640,-1,5640,5617,3334,-1,5641,5642,5640,-1,5640,3333,5641,-1,5617,5640,3371,-1,3371,5616,5617,-1,5612,5615,3334,-1,3334,5617,5612,-1,3334,5615,5643,-1,5643,3335,3334,-1,5611,3376,5643,-1,5643,5615,5611,-1,5643,5644,5645,-1,5645,3335,5643,-1,5646,5647,5648,-1,5648,3347,5646,-1,5646,5649,5650,-1,5650,5647,5646,-1,5651,5648,5647,-1,5647,3349,5651,-1,3348,3347,5648,-1,5648,5652,3348,-1,5646,3347,5622,-1,5622,5653,5646,-1,5646,5653,5654,-1,5654,5649,5646,-1,5655,5656,5654,-1,5654,5653,5655,-1,5649,5654,3336,-1,3336,3338,5649,-1,3336,5654,5656,-1,5656,3353,3336,-1,5649,3338,3350,-1,3350,5650,5649,-1,3379,5619,5657,-1,5657,5658,3379,-1,5619,3379,3329,-1,3329,3328,5619,-1,5657,5619,5618,-1,5618,5659,5657,-1,5658,5657,5660,-1,5660,5661,5658,-1,3379,5658,5662,-1,5662,5663,3379,-1,5660,5657,5659,-1,5659,5664,5660,-1,5661,5660,5665,-1,5665,5666,5661,-1,5661,5667,5662,-1,5662,5658,5661,-1,5668,5663,5662,-1,5662,5669,5668,-1,5670,5663,5668,-1,5668,5671,5670,-1,5672,5669,5662,-1,5662,5667,5672,-1,5668,5669,5673,-1,5673,5674,5668,-1,5669,5672,5675,-1,5675,5673,5669,-1,5676,5672,5667,-1,5667,5677,5676,-1,5664,5652,5665,-1,5665,5660,5664,-1,5678,5666,5665,-1,5665,5651,5678,-1,5661,5666,5677,-1,5677,5667,5661,-1,5675,5672,5676,-1,5676,5679,5675,-1,5680,5676,5677,-1,5677,5681,5680,-1,5679,5676,5680,-1,5680,5682,5679,-1,5681,5677,5666,-1,5666,5678,5681,-1,5627,5680,5681,-1,5681,3341,5627,-1,3341,5681,5678,-1,5678,3339,3341,-1,5682,5680,5627,-1,5627,5626,5682,-1,3331,5683,5684,-1,5684,3332,3331,-1,3331,3345,5685,-1,5685,5683,3331,-1,5684,5683,3325,-1,3325,3324,5684,-1,5684,5686,3359,-1,3359,3332,5684,-1,5687,3344,3343,-1,3343,3331,5687,-1,3344,5687,5659,-1,5659,5618,3344,-1,5621,5687,3331,-1,3331,3330,5621,-1,5621,5664,5659,-1,5659,5687,5621,-1,5621,3348,5652,-1,5652,5664,5621,-1,5613,5616,3344,-1,3344,5618,5613,-1,5648,5651,5665,-1,5665,5652,5648,-1,5647,5650,3350,-1,3350,3349,5647,-1,3349,3339,5678,-1,5678,5651,3349,-1,5642,3372,3371,-1,3371,5640,5642,-1,3371,3342,3344,-1,3344,5616,3371,-1,5639,5688,5689,-1,5689,5638,5639,-1,5639,5690,5691,-1,5691,5688,5639,-1,5692,5689,5688,-1,5688,5693,5692,-1,5694,5695,5638,-1,5638,5689,5694,-1,5695,5632,5628,-1,5628,5638,5695,-1,5637,5690,5639,-1,5639,5631,5637,-1,5693,5696,5697,-1,5697,5692,5693,-1,3387,3386,5696,-1,5696,5693,3387,-1,5696,5698,5699,-1,5699,5697,5696,-1,5700,5701,5692,-1,5692,5697,5700,-1,5701,5694,5689,-1,5689,5692,5701,-1,5691,3387,5693,-1,5693,5688,5691,-1,3384,5698,5696,-1,5696,3386,3384,-1,5702,5699,5698,-1,5698,5703,5702,-1,5704,5700,5697,-1,5697,5699,5704,-1,5705,5704,5699,-1,5699,5702,5705,-1,3383,5703,5698,-1,5698,3384,3383,-1,5706,5707,5702,-1,5702,5703,5706,-1,5683,5685,5708,-1,5708,3325,5683,-1,3373,5708,5685,-1,5685,5709,3373,-1,3326,3325,5708,-1,5708,3390,3326,-1,5710,3354,3353,-1,3353,5711,5710,-1,3335,5645,5712,-1,5712,3333,3335,-1,5625,5713,5626,-1,5626,5623,5625,-1,5714,5715,5713,-1,5713,5625,5714,-1,5626,5713,5716,-1,5716,5682,5626,-1,5717,5718,5715,-1,5715,5714,5717,-1,5713,5715,5719,-1,5719,5716,5713,-1,5625,3354,5710,-1,5710,5714,5625,-1,5711,3357,3356,-1,3356,5710,5711,-1,5711,5720,3370,-1,3370,3357,5711,-1,5714,5710,3356,-1,3356,5717,5714,-1,5656,5720,5711,-1,5711,3353,5656,-1,5721,5718,5717,-1,5717,5722,5721,-1,5715,5718,5723,-1,5723,5719,5715,-1,5641,5724,5725,-1,5725,5642,5641,-1,5641,3333,5712,-1,5712,5726,5641,-1,5712,5727,5728,-1,5728,5726,5712,-1,5724,5641,5726,-1,5726,5729,5724,-1,5730,5731,5732,-1,5732,5733,5730,-1,5734,3374,5731,-1,5731,5730,5734,-1,5735,5732,5731,-1,5731,5709,5735,-1,5733,5732,5725,-1,5725,5724,5733,-1,5733,5736,5737,-1,5737,5730,5733,-1,3374,5734,5707,-1,5707,3375,3374,-1,5709,5731,3374,-1,3374,3373,5709,-1,5730,5737,5705,-1,5705,5734,5730,-1,5738,5725,5732,-1,5732,5735,5738,-1,5724,5729,5736,-1,5736,5733,5724,-1,5584,5686,5684,-1,5684,3324,5584,-1,5739,3359,5686,-1,5686,5740,5739,-1,5674,5673,5741,-1,5741,5742,5674,-1,5671,5668,5674,-1,5674,5743,5671,-1,5673,5675,5744,-1,5744,5741,5673,-1,5745,5746,5742,-1,5742,5741,5745,-1,5743,5674,5742,-1,5742,5747,5743,-1,5746,5745,5748,-1,5748,5749,5746,-1,5746,5750,5747,-1,5747,5742,5746,-1,5741,5744,3360,-1,3360,5745,5741,-1,5745,3360,3362,-1,3362,5748,5745,-1,5749,5748,5751,-1,5751,5752,5749,-1,5750,5746,5749,-1,5749,5753,5750,-1,5748,3362,5754,-1,5754,5751,5748,-1,5752,5751,5755,-1,5755,5633,5752,-1,5753,5749,5752,-1,5752,5756,5753,-1,5751,5754,5757,-1,5757,5755,5751,-1,5633,5755,5634,-1,5634,5629,5633,-1,5756,5752,5633,-1,5633,5632,5756,-1,5755,5757,5758,-1,5758,5634,5755,-1,5634,5758,5759,-1,5759,5635,5634,-1,5630,5635,5760,-1,5760,5636,5630,-1,5635,5759,5761,-1,5761,5760,5635,-1,5636,5760,5762,-1,5762,5763,5636,-1,5760,5761,5764,-1,5764,5762,5760,-1,5763,5762,5601,-1,5601,5600,5763,-1,5765,5637,5636,-1,5636,5763,5765,-1,5762,5764,5609,-1,5609,5601,5762,-1,5602,5765,5763,-1,5763,5600,5602,-1,3380,3379,5663,-1,5663,5670,3380,-1,5679,5766,5744,-1,5744,5675,5679,-1,5744,5766,3361,-1,3361,3360,5744,-1,3362,3361,5767,-1,5767,5754,3362,-1,5754,5767,5768,-1,5768,5757,5754,-1,5757,5768,5769,-1,5769,5758,5757,-1,5758,5769,5770,-1,5770,5759,5758,-1,5759,5770,5771,-1,5771,5761,5759,-1,5761,5771,5772,-1,5772,5764,5761,-1,5764,5772,5603,-1,5603,5609,5764,-1,5679,5682,5716,-1,5716,5766,5679,-1,5766,5716,5719,-1,5719,3361,5766,-1,3361,5719,5723,-1,5723,5767,3361,-1,5767,5723,5773,-1,5773,5768,5767,-1,5768,5773,5774,-1,5774,5769,5768,-1,5769,5774,5775,-1,5775,5770,5769,-1,5770,5775,5776,-1,5776,5771,5770,-1,5771,5776,5777,-1,5777,5772,5771,-1,5772,5777,5604,-1,5604,5603,5772,-1,3319,3318,5609,-1,5609,5603,3319,-1,5718,5721,5773,-1,5773,5723,5718,-1,5721,3364,5774,-1,5774,5773,5721,-1,3364,3363,5775,-1,5775,5774,3364,-1,3363,3366,5776,-1,5776,5775,3363,-1,3366,3367,5777,-1,5777,5776,3366,-1,3367,3369,5604,-1,5604,5777,3367,-1,3364,5721,5722,-1,5722,3365,3364,-1,5722,5717,3356,-1,3356,3355,5722,-1,5655,5739,5720,-1,5720,5656,5655,-1,5720,5739,5740,-1,5740,3370,5720,-1,5655,3358,3359,-1,3359,5739,5655,-1,5495,3016,3370,-1,3370,5740,5495,-1,5653,5622,3358,-1,3358,5655,5653,-1,5495,5740,5686,-1,5686,5584,5495,-1,3343,5738,5735,-1,5735,3345,3343,-1,3345,5735,5709,-1,5709,5685,3345,-1,3342,3372,5738,-1,5738,3343,3342,-1,3372,5642,5725,-1,5725,5738,3372,-1,3373,5778,3390,-1,3390,5708,3373,-1,5705,5702,5707,-1,5707,5734,5705,-1,5707,5706,5779,-1,5779,3375,5707,-1,5645,5780,5727,-1,5727,5712,5645,-1,5729,5781,5782,-1,5782,5736,5729,-1,5736,5782,5783,-1,5783,5737,5736,-1,5737,5783,5704,-1,5704,5705,5737,-1,3376,3378,5644,-1,5644,5643,3376,-1,5645,5644,5784,-1,5784,5780,5645,-1,5644,3378,5785,-1,5785,5784,5644,-1,5780,5784,5786,-1,5786,5727,5780,-1,5727,5786,5787,-1,5787,5728,5727,-1,5729,5726,5728,-1,5728,5781,5729,-1,5781,5788,5789,-1,5789,5782,5781,-1,5782,5789,5790,-1,5790,5783,5782,-1,5783,5790,5700,-1,5700,5704,5783,-1,5784,5785,5791,-1,5791,5786,5784,-1,5786,5791,5792,-1,5792,5787,5786,-1,5781,5728,5787,-1,5787,5788,5781,-1,5788,5793,5794,-1,5794,5789,5788,-1,5789,5794,5795,-1,5795,5790,5789,-1,5790,5795,5701,-1,5701,5700,5790,-1,5791,5796,5797,-1,5797,5792,5791,-1,5788,5787,5792,-1,5792,5793,5788,-1,3378,3377,5798,-1,5798,5785,3378,-1,5798,5796,5791,-1,5791,5785,5798,-1,5793,5799,5800,-1,5800,5794,5793,-1,5794,5800,5801,-1,5801,5795,5794,-1,5795,5801,5694,-1,5694,5701,5795,-1,3327,3329,3380,-1,3380,5614,3327,-1,3376,5614,5802,-1,5802,3377,3376,-1,3377,5802,5803,-1,5803,5798,3377,-1,5803,5804,5796,-1,5796,5798,5803,-1,5796,5804,5805,-1,5805,5797,5796,-1,5793,5792,5797,-1,5797,5799,5793,-1,5799,5806,5807,-1,5807,5800,5799,-1,5800,5807,5808,-1,5808,5801,5800,-1,5801,5808,5695,-1,5695,5694,5801,-1,5614,3380,5670,-1,5670,5802,5614,-1,5802,5670,5671,-1,5671,5803,5802,-1,5803,5671,5743,-1,5743,5804,5803,-1,5804,5743,5747,-1,5747,5805,5804,-1,5799,5797,5805,-1,5805,5806,5799,-1,5806,5750,5753,-1,5753,5807,5806,-1,5807,5753,5756,-1,5756,5808,5807,-1,5808,5756,5632,-1,5632,5695,5808,-1,5806,5805,5747,-1,5747,5750,5806,-1,3323,3381,5809,-1,5809,5599,3323,-1,3381,5810,5811,-1,5811,5809,3381,-1,5809,3382,5608,-1,5608,5599,5809,-1,5809,5811,3383,-1,3383,3382,5809,-1,5608,3382,3385,-1,3385,5607,5608,-1,3382,3384,3386,-1,3386,3385,3382,-1,5607,3385,5812,-1,5812,5606,5607,-1,3385,3387,5691,-1,5691,5812,3385,-1,5606,5812,5813,-1,5813,5605,5606,-1,5812,5691,5690,-1,5690,5813,5812,-1,5813,5765,5602,-1,5602,5605,5813,-1,5813,5690,5637,-1,5637,5765,5813,-1,3316,5814,5810,-1,5810,3381,3316,-1,5810,5779,5706,-1,5706,5811,5810,-1,5811,5706,5703,-1,5703,3383,5811,-1,5779,5810,5814,-1,5814,5778,5779,-1,5778,3373,3375,-1,3375,5779,5778,-1,3388,3390,5778,-1,5778,5814,3388,-1,3316,3389,3388,-1,3388,5814,3316,-1,5722,3355,3391,-1,3391,3365,5722,-1,3018,5158,3392,-1,3392,3391,3018,-1,3368,3392,5158,-1,5158,3321,3368,-1,5815,5816,5817,-1,5815,5818,5816,-1,5817,5819,5815,-1,5815,5820,5818,-1,5815,5821,5820,-1,5815,5822,5821,-1,5815,5823,5822,-1,5815,5824,5823,-1,5815,5825,5824,-1,5815,5826,5825,-1,5815,5827,5826,-1,5815,5828,5827,-1,5815,5829,5828,-1,5815,5830,5829,-1,5815,5831,5830,-1,5815,5832,5831,-1,5815,5833,5832,-1,5815,5834,5833,-1,5815,5835,5834,-1,5815,5836,5835,-1,5815,5837,5836,-1,5815,5838,5837,-1,5815,5839,5838,-1,5815,5819,5839,-1,5840,5841,5842,-1,5841,5843,5842,-1,5843,5844,5842,-1,5844,5845,5842,-1,5845,5846,5842,-1,5846,5847,5842,-1,5847,5848,5842,-1,5848,5849,5842,-1,5849,5850,5842,-1,5850,5851,5842,-1,5851,5852,5842,-1,5852,5853,5842,-1,5853,5854,5842,-1,5854,5855,5842,-1,5855,5856,5842,-1,5856,5857,5842,-1,5857,5858,5842,-1,5858,5859,5842,-1,5859,5860,5842,-1,5860,5861,5842,-1,5861,5862,5842,-1,5862,5863,5842,-1,5863,5864,5842,-1,5864,5840,5842,-1,5816,5865,5866,-1,5866,5817,5816,-1,5818,5867,5865,-1,5865,5816,5818,-1,5820,5868,5867,-1,5867,5818,5820,-1,5821,5869,5868,-1,5868,5820,5821,-1,5822,5870,5869,-1,5869,5821,5822,-1,5823,5871,5870,-1,5870,5822,5823,-1,5824,5872,5871,-1,5871,5823,5824,-1,5825,5873,5872,-1,5872,5824,5825,-1,5826,5874,5873,-1,5873,5825,5826,-1,5827,5875,5874,-1,5874,5826,5827,-1,5828,5876,5875,-1,5875,5827,5828,-1,5829,5877,5876,-1,5876,5828,5829,-1,5830,5878,5877,-1,5877,5829,5830,-1,5831,5879,5878,-1,5878,5830,5831,-1,5832,5880,5879,-1,5879,5831,5832,-1,5833,5881,5880,-1,5880,5832,5833,-1,5834,5882,5881,-1,5881,5833,5834,-1,5835,5883,5882,-1,5882,5834,5835,-1,5836,5884,5883,-1,5883,5835,5836,-1,5837,5885,5884,-1,5884,5836,5837,-1,5838,5886,5885,-1,5885,5837,5838,-1,5839,5887,5886,-1,5886,5838,5839,-1,5819,5888,5887,-1,5887,5839,5819,-1,5817,5866,5888,-1,5888,5819,5817,-1,5889,5866,5865,-1,5865,5890,5889,-1,5889,5891,5888,-1,5888,5866,5889,-1,5890,5865,5867,-1,5867,5892,5890,-1,5890,5893,5894,-1,5894,5889,5890,-1,5892,5867,5868,-1,5868,5895,5892,-1,5892,5896,5893,-1,5893,5890,5892,-1,5895,5868,5869,-1,5869,5897,5895,-1,5895,5898,5896,-1,5896,5892,5895,-1,5897,5869,5870,-1,5870,5899,5897,-1,5897,5900,5898,-1,5898,5895,5897,-1,5899,5870,5871,-1,5871,5901,5899,-1,5899,5902,5900,-1,5900,5897,5899,-1,5901,5871,5872,-1,5872,5903,5901,-1,5901,5904,5902,-1,5902,5899,5901,-1,5903,5872,5873,-1,5873,5905,5903,-1,5903,5906,5904,-1,5904,5901,5903,-1,5905,5873,5874,-1,5874,5907,5905,-1,5905,5908,5906,-1,5906,5903,5905,-1,5907,5874,5875,-1,5875,5909,5907,-1,5907,5910,5908,-1,5908,5905,5907,-1,5909,5875,5876,-1,5876,5911,5909,-1,5909,5912,5910,-1,5910,5907,5909,-1,5911,5876,5877,-1,5877,5913,5911,-1,5911,5914,5912,-1,5912,5909,5911,-1,5913,5877,5878,-1,5878,5915,5913,-1,5913,5916,5914,-1,5914,5911,5913,-1,5915,5878,5879,-1,5879,5917,5915,-1,5915,5918,5916,-1,5916,5913,5915,-1,5917,5879,5880,-1,5880,5919,5917,-1,5917,5920,5918,-1,5918,5915,5917,-1,5919,5880,5881,-1,5881,5921,5919,-1,5919,5922,5920,-1,5920,5917,5919,-1,5921,5881,5882,-1,5882,5923,5921,-1,5921,5924,5922,-1,5922,5919,5921,-1,5923,5882,5883,-1,5883,5925,5923,-1,5923,5926,5924,-1,5924,5921,5923,-1,5925,5883,5884,-1,5884,5927,5925,-1,5925,5928,5926,-1,5926,5923,5925,-1,5927,5884,5885,-1,5885,5929,5927,-1,5927,5930,5928,-1,5928,5925,5927,-1,5929,5885,5886,-1,5886,5931,5929,-1,5929,5932,5930,-1,5930,5927,5929,-1,5931,5886,5887,-1,5887,5933,5931,-1,5931,5934,5932,-1,5932,5929,5931,-1,5933,5887,5888,-1,5888,5891,5933,-1,5933,5935,5934,-1,5934,5931,5933,-1,5891,5936,5935,-1,5935,5933,5891,-1,5889,5894,5936,-1,5936,5891,5889,-1,5937,5894,5893,-1,5893,5938,5937,-1,5939,5936,5894,-1,5894,5937,5939,-1,5938,5893,5896,-1,5896,5940,5938,-1,5941,5937,5938,-1,5938,5942,5941,-1,5940,5896,5898,-1,5898,5943,5940,-1,5942,5938,5940,-1,5940,5944,5942,-1,5943,5898,5900,-1,5900,5945,5943,-1,5944,5940,5943,-1,5943,5946,5944,-1,5945,5900,5902,-1,5902,5947,5945,-1,5946,5943,5945,-1,5945,5948,5946,-1,5947,5902,5904,-1,5904,5949,5947,-1,5948,5945,5947,-1,5947,5950,5948,-1,5949,5904,5906,-1,5906,5951,5949,-1,5950,5947,5949,-1,5949,5952,5950,-1,5951,5906,5908,-1,5908,5953,5951,-1,5952,5949,5951,-1,5951,5954,5952,-1,5953,5908,5910,-1,5910,5955,5953,-1,5954,5951,5953,-1,5953,5956,5954,-1,5955,5910,5912,-1,5912,5957,5955,-1,5956,5953,5955,-1,5955,5958,5956,-1,5957,5912,5914,-1,5914,5959,5957,-1,5958,5955,5957,-1,5957,5960,5958,-1,5959,5914,5916,-1,5916,5961,5959,-1,5960,5957,5959,-1,5959,5962,5960,-1,5961,5916,5918,-1,5918,5963,5961,-1,5962,5959,5961,-1,5961,5964,5962,-1,5963,5918,5920,-1,5920,5965,5963,-1,5964,5961,5963,-1,5963,5966,5964,-1,5965,5920,5922,-1,5922,5967,5965,-1,5966,5963,5965,-1,5965,5968,5966,-1,5967,5922,5924,-1,5924,5969,5967,-1,5968,5965,5967,-1,5967,5970,5968,-1,5969,5924,5926,-1,5926,5971,5969,-1,5970,5967,5969,-1,5969,5972,5970,-1,5971,5926,5928,-1,5928,5973,5971,-1,5972,5969,5971,-1,5971,5974,5972,-1,5973,5928,5930,-1,5930,5975,5973,-1,5974,5971,5973,-1,5973,5976,5974,-1,5975,5930,5932,-1,5932,5977,5975,-1,5976,5973,5975,-1,5975,5978,5976,-1,5977,5932,5934,-1,5934,5979,5977,-1,5978,5975,5977,-1,5977,5980,5978,-1,5979,5934,5935,-1,5935,5981,5979,-1,5980,5977,5979,-1,5979,5982,5980,-1,5981,5935,5936,-1,5936,5939,5981,-1,5982,5979,5981,-1,5981,5983,5982,-1,5983,5981,5939,-1,5939,5984,5983,-1,5984,5939,5937,-1,5937,5941,5984,-1,5985,5941,5942,-1,5942,5986,5985,-1,5986,5942,5944,-1,5944,5987,5986,-1,5987,5944,5946,-1,5946,5988,5987,-1,5988,5946,5948,-1,5948,5989,5988,-1,5989,5948,5950,-1,5950,5990,5989,-1,5990,5950,5952,-1,5952,5991,5990,-1,5991,5952,5954,-1,5954,5992,5991,-1,5992,5954,5956,-1,5956,5993,5992,-1,5993,5956,5958,-1,5958,5994,5993,-1,5994,5958,5960,-1,5960,5995,5994,-1,5995,5960,5962,-1,5962,5996,5995,-1,5996,5962,5964,-1,5964,5997,5996,-1,5997,5964,5966,-1,5966,5998,5997,-1,5998,5966,5968,-1,5968,5999,5998,-1,5999,5968,5970,-1,5970,6000,5999,-1,6000,5970,5972,-1,5972,6001,6000,-1,6001,5972,5974,-1,5974,6002,6001,-1,6002,5974,5976,-1,5976,6003,6002,-1,6003,5976,5978,-1,5978,6004,6003,-1,6004,5978,5980,-1,5980,6005,6004,-1,6005,5980,5982,-1,5982,6006,6005,-1,6006,5982,5983,-1,5983,6007,6006,-1,6007,5983,5984,-1,5984,6008,6007,-1,6008,5984,5941,-1,5941,5985,6008,-1,6009,5985,5986,-1,5986,6010,6009,-1,6010,5986,5987,-1,5987,6011,6010,-1,6011,5987,5988,-1,5988,6012,6011,-1,6012,5988,5989,-1,5989,6013,6012,-1,6013,5989,5990,-1,5990,6014,6013,-1,6014,5990,5991,-1,5991,6015,6014,-1,6015,5991,5992,-1,5992,6016,6015,-1,6016,5992,5993,-1,5993,6017,6016,-1,6017,5993,5994,-1,5994,6018,6017,-1,6018,5994,5995,-1,5995,6019,6018,-1,6019,5995,5996,-1,5996,6020,6019,-1,6020,5996,5997,-1,5997,6021,6020,-1,6021,5997,5998,-1,5998,6022,6021,-1,6022,5998,5999,-1,5999,6023,6022,-1,6023,5999,6000,-1,6000,6024,6023,-1,6024,6000,6001,-1,6001,6025,6024,-1,6025,6001,6002,-1,6002,6026,6025,-1,6026,6002,6003,-1,6003,6027,6026,-1,6027,6003,6004,-1,6004,6028,6027,-1,6028,6004,6005,-1,6005,6029,6028,-1,6029,6005,6006,-1,6006,6030,6029,-1,6030,6006,6007,-1,6007,6031,6030,-1,6031,6007,6008,-1,6008,6032,6031,-1,6032,6008,5985,-1,5985,6009,6032,-1,6033,6009,6010,-1,6010,6034,6033,-1,6034,6010,6011,-1,6011,6035,6034,-1,6035,6011,6012,-1,6012,6036,6035,-1,6036,6012,6013,-1,6013,6037,6036,-1,6037,6013,6014,-1,6014,6038,6037,-1,6038,6014,6015,-1,6015,6039,6038,-1,6039,6015,6016,-1,6016,6040,6039,-1,6040,6016,6017,-1,6017,6041,6040,-1,6041,6017,6018,-1,6018,6042,6041,-1,6042,6018,6019,-1,6019,6043,6042,-1,6043,6019,6020,-1,6020,6044,6043,-1,6044,6020,6021,-1,6021,6045,6044,-1,6045,6021,6022,-1,6022,6046,6045,-1,6046,6022,6023,-1,6023,6047,6046,-1,6047,6023,6024,-1,6024,6048,6047,-1,6048,6024,6025,-1,6025,6049,6048,-1,6049,6025,6026,-1,6026,6050,6049,-1,6050,6026,6027,-1,6027,6051,6050,-1,6051,6027,6028,-1,6028,6052,6051,-1,6052,6028,6029,-1,6029,6053,6052,-1,6053,6029,6030,-1,6030,6054,6053,-1,6054,6030,6031,-1,6031,6055,6054,-1,6055,6031,6032,-1,6032,6056,6055,-1,6056,6032,6009,-1,6009,6033,6056,-1,6057,6033,6034,-1,6034,6058,6057,-1,6058,6034,6035,-1,6035,6059,6058,-1,6059,6035,6036,-1,6036,6060,6059,-1,6060,6036,6037,-1,6037,6061,6060,-1,6061,6037,6038,-1,6038,6062,6061,-1,6062,6038,6039,-1,6039,6063,6062,-1,6063,6039,6040,-1,6040,6064,6063,-1,6064,6040,6041,-1,6041,6065,6064,-1,6065,6041,6042,-1,6042,6066,6065,-1,6066,6042,6043,-1,6043,6067,6066,-1,6067,6043,6044,-1,6044,6068,6067,-1,6068,6044,6045,-1,6045,6069,6068,-1,6069,6045,6046,-1,6046,6070,6069,-1,6070,6046,6047,-1,6047,6071,6070,-1,6071,6047,6048,-1,6048,6072,6071,-1,6072,6048,6049,-1,6049,6073,6072,-1,6073,6049,6050,-1,6050,6074,6073,-1,6074,6050,6051,-1,6051,6075,6074,-1,6075,6051,6052,-1,6052,6076,6075,-1,6076,6052,6053,-1,6053,6077,6076,-1,6077,6053,6054,-1,6054,6078,6077,-1,6078,6054,6055,-1,6055,6079,6078,-1,6079,6055,6056,-1,6056,6080,6079,-1,6080,6056,6033,-1,6033,6057,6080,-1,6081,6057,6058,-1,6058,6082,6081,-1,6082,6058,6059,-1,6059,6083,6082,-1,6083,6059,6060,-1,6060,6084,6083,-1,6084,6060,6061,-1,6061,6085,6084,-1,6085,6061,6062,-1,6062,6086,6085,-1,6086,6062,6063,-1,6063,6087,6086,-1,6087,6063,6064,-1,6064,6088,6087,-1,6088,6064,6065,-1,6065,6089,6088,-1,6089,6065,6066,-1,6066,6090,6089,-1,6090,6066,6067,-1,6067,6091,6090,-1,6091,6067,6068,-1,6068,6092,6091,-1,6092,6068,6069,-1,6069,6093,6092,-1,6093,6069,6070,-1,6070,6094,6093,-1,6094,6070,6071,-1,6071,6095,6094,-1,6095,6071,6072,-1,6072,6096,6095,-1,6096,6072,6073,-1,6073,6097,6096,-1,6097,6073,6074,-1,6074,6098,6097,-1,6098,6074,6075,-1,6075,6099,6098,-1,6099,6075,6076,-1,6076,6100,6099,-1,6100,6076,6077,-1,6077,6101,6100,-1,6101,6077,6078,-1,6078,6102,6101,-1,6102,6078,6079,-1,6079,6103,6102,-1,6103,6079,6080,-1,6080,6104,6103,-1,6104,6080,6057,-1,6057,6081,6104,-1,6105,6081,6082,-1,6082,6106,6105,-1,6106,6082,6083,-1,6083,6107,6106,-1,6107,6083,6084,-1,6084,6108,6107,-1,6108,6084,6085,-1,6085,6109,6108,-1,6109,6085,6086,-1,6086,6110,6109,-1,6110,6086,6087,-1,6087,6111,6110,-1,6111,6087,6088,-1,6088,6112,6111,-1,6112,6088,6089,-1,6089,6113,6112,-1,6113,6089,6090,-1,6090,6114,6113,-1,6114,6090,6091,-1,6091,6115,6114,-1,6115,6091,6092,-1,6092,6116,6115,-1,6116,6092,6093,-1,6093,6117,6116,-1,6117,6093,6094,-1,6094,6118,6117,-1,6118,6094,6095,-1,6095,6119,6118,-1,6119,6095,6096,-1,6096,6120,6119,-1,6120,6096,6097,-1,6097,6121,6120,-1,6121,6097,6098,-1,6098,6122,6121,-1,6122,6098,6099,-1,6099,6123,6122,-1,6123,6099,6100,-1,6100,6124,6123,-1,6124,6100,6101,-1,6101,6125,6124,-1,6125,6101,6102,-1,6102,6126,6125,-1,6126,6102,6103,-1,6103,6127,6126,-1,6127,6103,6104,-1,6104,6128,6127,-1,6128,6104,6081,-1,6081,6105,6128,-1,5840,6105,6106,-1,6106,5841,5840,-1,5841,6106,6107,-1,6107,5843,5841,-1,5843,6107,6108,-1,6108,5844,5843,-1,5844,6108,6109,-1,6109,5845,5844,-1,5845,6109,6110,-1,6110,5846,5845,-1,5846,6110,6111,-1,6111,5847,5846,-1,5847,6111,6112,-1,6112,5848,5847,-1,5848,6112,6113,-1,6113,5849,5848,-1,5849,6113,6114,-1,6114,5850,5849,-1,5850,6114,6115,-1,6115,5851,5850,-1,5851,6115,6116,-1,6116,5852,5851,-1,5852,6116,6117,-1,6117,5853,5852,-1,5853,6117,6118,-1,6118,5854,5853,-1,5854,6118,6119,-1,6119,5855,5854,-1,5855,6119,6120,-1,6120,5856,5855,-1,5856,6120,6121,-1,6121,5857,5856,-1,5857,6121,6122,-1,6122,5858,5857,-1,5858,6122,6123,-1,6123,5859,5858,-1,5859,6123,6124,-1,6124,5860,5859,-1,5860,6124,6125,-1,6125,5861,5860,-1,5861,6125,6126,-1,6126,5862,5861,-1,5862,6126,6127,-1,6127,5863,5862,-1,5863,6127,6128,-1,6128,5864,5863,-1,5864,6128,6105,-1,6105,5840,5864,-1,6129,6130,6131,-1,6130,6132,6131,-1,6131,6133,6129,-1,6132,6134,6131,-1,6134,6135,6131,-1,6135,6136,6131,-1,6136,6137,6131,-1,6137,6138,6131,-1,6138,6139,6131,-1,6139,6140,6131,-1,6140,6141,6131,-1,6141,6142,6131,-1,6142,6143,6131,-1,6143,6144,6131,-1,6144,6145,6131,-1,6145,6146,6131,-1,6146,6147,6131,-1,6147,6148,6131,-1,6148,6149,6131,-1,6149,6150,6131,-1,6150,6151,6131,-1,6151,6152,6131,-1,6152,6153,6131,-1,6153,6133,6131,-1,6154,6155,6156,-1,6154,6157,6155,-1,6154,6158,6157,-1,6154,6159,6158,-1,6154,6160,6159,-1,6154,6161,6160,-1,6154,6162,6161,-1,6154,6163,6162,-1,6154,6164,6163,-1,6154,6165,6164,-1,6154,6166,6165,-1,6154,6167,6166,-1,6154,6168,6167,-1,6154,6169,6168,-1,6154,6170,6169,-1,6154,6171,6170,-1,6154,6172,6171,-1,6154,6173,6172,-1,6154,6174,6173,-1,6154,6175,6174,-1,6154,6176,6175,-1,6154,6177,6176,-1,6154,6178,6177,-1,6154,6156,6178,-1,6129,6179,6180,-1,6180,6130,6129,-1,6130,6180,6181,-1,6181,6132,6130,-1,6132,6181,6182,-1,6182,6134,6132,-1,6134,6182,6183,-1,6183,6135,6134,-1,6135,6183,6184,-1,6184,6136,6135,-1,6136,6184,6185,-1,6185,6137,6136,-1,6137,6185,6186,-1,6186,6138,6137,-1,6138,6186,6187,-1,6187,6139,6138,-1,6139,6187,6188,-1,6188,6140,6139,-1,6140,6188,6189,-1,6189,6141,6140,-1,6141,6189,6190,-1,6190,6142,6141,-1,6142,6190,6191,-1,6191,6143,6142,-1,6143,6191,6192,-1,6192,6144,6143,-1,6144,6192,6193,-1,6193,6145,6144,-1,6145,6193,6194,-1,6194,6146,6145,-1,6146,6194,6195,-1,6195,6147,6146,-1,6147,6195,6196,-1,6196,6148,6147,-1,6148,6196,6197,-1,6197,6149,6148,-1,6149,6197,6198,-1,6198,6150,6149,-1,6150,6198,6199,-1,6199,6151,6150,-1,6151,6199,6200,-1,6200,6152,6151,-1,6152,6200,6201,-1,6201,6153,6152,-1,6153,6201,6202,-1,6202,6133,6153,-1,6133,6202,6179,-1,6179,6129,6133,-1,6203,6180,6179,-1,6179,6204,6203,-1,6205,6181,6180,-1,6180,6203,6205,-1,6179,6202,6206,-1,6206,6204,6179,-1,6204,6207,6208,-1,6208,6203,6204,-1,6209,6182,6181,-1,6181,6205,6209,-1,6203,6208,6210,-1,6210,6205,6203,-1,6211,6183,6182,-1,6182,6209,6211,-1,6205,6210,6212,-1,6212,6209,6205,-1,6213,6184,6183,-1,6183,6211,6213,-1,6209,6212,6214,-1,6214,6211,6209,-1,6215,6185,6184,-1,6184,6213,6215,-1,6211,6214,6216,-1,6216,6213,6211,-1,6217,6186,6185,-1,6185,6215,6217,-1,6213,6216,6218,-1,6218,6215,6213,-1,6219,6187,6186,-1,6186,6217,6219,-1,6215,6218,6220,-1,6220,6217,6215,-1,6221,6188,6187,-1,6187,6219,6221,-1,6217,6220,6222,-1,6222,6219,6217,-1,6223,6189,6188,-1,6188,6221,6223,-1,6219,6222,6224,-1,6224,6221,6219,-1,6225,6190,6189,-1,6189,6223,6225,-1,6221,6224,6226,-1,6226,6223,6221,-1,6227,6191,6190,-1,6190,6225,6227,-1,6223,6226,6228,-1,6228,6225,6223,-1,6229,6192,6191,-1,6191,6227,6229,-1,6225,6228,6230,-1,6230,6227,6225,-1,6231,6193,6192,-1,6192,6229,6231,-1,6227,6230,6232,-1,6232,6229,6227,-1,6233,6194,6193,-1,6193,6231,6233,-1,6229,6232,6234,-1,6234,6231,6229,-1,6235,6195,6194,-1,6194,6233,6235,-1,6231,6234,6236,-1,6236,6233,6231,-1,6237,6196,6195,-1,6195,6235,6237,-1,6233,6236,6238,-1,6238,6235,6233,-1,6239,6197,6196,-1,6196,6237,6239,-1,6235,6238,6240,-1,6240,6237,6235,-1,6241,6198,6197,-1,6197,6239,6241,-1,6237,6240,6242,-1,6242,6239,6237,-1,6243,6199,6198,-1,6198,6241,6243,-1,6239,6242,6244,-1,6244,6241,6239,-1,6245,6200,6199,-1,6199,6243,6245,-1,6241,6244,6246,-1,6246,6243,6241,-1,6247,6201,6200,-1,6200,6245,6247,-1,6243,6246,6248,-1,6248,6245,6243,-1,6206,6202,6201,-1,6201,6247,6206,-1,6245,6248,6249,-1,6249,6247,6245,-1,6247,6249,6250,-1,6250,6206,6247,-1,6206,6250,6207,-1,6207,6204,6206,-1,6251,6208,6207,-1,6207,6252,6251,-1,6253,6210,6208,-1,6208,6251,6253,-1,6252,6207,6250,-1,6250,6254,6252,-1,6255,6251,6252,-1,6252,6256,6255,-1,6257,6212,6210,-1,6210,6253,6257,-1,6258,6253,6251,-1,6251,6255,6258,-1,6259,6214,6212,-1,6212,6257,6259,-1,6260,6257,6253,-1,6253,6258,6260,-1,6261,6216,6214,-1,6214,6259,6261,-1,6262,6259,6257,-1,6257,6260,6262,-1,6263,6218,6216,-1,6216,6261,6263,-1,6264,6261,6259,-1,6259,6262,6264,-1,6265,6220,6218,-1,6218,6263,6265,-1,6266,6263,6261,-1,6261,6264,6266,-1,6267,6222,6220,-1,6220,6265,6267,-1,6268,6265,6263,-1,6263,6266,6268,-1,6269,6224,6222,-1,6222,6267,6269,-1,6270,6267,6265,-1,6265,6268,6270,-1,6271,6226,6224,-1,6224,6269,6271,-1,6272,6269,6267,-1,6267,6270,6272,-1,6273,6228,6226,-1,6226,6271,6273,-1,6274,6271,6269,-1,6269,6272,6274,-1,6275,6230,6228,-1,6228,6273,6275,-1,6276,6273,6271,-1,6271,6274,6276,-1,6277,6232,6230,-1,6230,6275,6277,-1,6278,6275,6273,-1,6273,6276,6278,-1,6279,6234,6232,-1,6232,6277,6279,-1,6280,6277,6275,-1,6275,6278,6280,-1,6281,6236,6234,-1,6234,6279,6281,-1,6282,6279,6277,-1,6277,6280,6282,-1,6283,6238,6236,-1,6236,6281,6283,-1,6284,6281,6279,-1,6279,6282,6284,-1,6285,6240,6238,-1,6238,6283,6285,-1,6286,6283,6281,-1,6281,6284,6286,-1,6287,6242,6240,-1,6240,6285,6287,-1,6288,6285,6283,-1,6283,6286,6288,-1,6289,6244,6242,-1,6242,6287,6289,-1,6290,6287,6285,-1,6285,6288,6290,-1,6291,6246,6244,-1,6244,6289,6291,-1,6292,6289,6287,-1,6287,6290,6292,-1,6293,6248,6246,-1,6246,6291,6293,-1,6294,6291,6289,-1,6289,6292,6294,-1,6295,6249,6248,-1,6248,6293,6295,-1,6296,6293,6291,-1,6291,6294,6296,-1,6254,6250,6249,-1,6249,6295,6254,-1,6297,6295,6293,-1,6293,6296,6297,-1,6298,6254,6295,-1,6295,6297,6298,-1,6256,6252,6254,-1,6254,6298,6256,-1,6299,6255,6256,-1,6256,6300,6299,-1,6301,6258,6255,-1,6255,6299,6301,-1,6302,6260,6258,-1,6258,6301,6302,-1,6303,6262,6260,-1,6260,6302,6303,-1,6304,6264,6262,-1,6262,6303,6304,-1,6305,6266,6264,-1,6264,6304,6305,-1,6306,6268,6266,-1,6266,6305,6306,-1,6307,6270,6268,-1,6268,6306,6307,-1,6308,6272,6270,-1,6270,6307,6308,-1,6309,6274,6272,-1,6272,6308,6309,-1,6310,6276,6274,-1,6274,6309,6310,-1,6311,6278,6276,-1,6276,6310,6311,-1,6312,6280,6278,-1,6278,6311,6312,-1,6313,6282,6280,-1,6280,6312,6313,-1,6314,6284,6282,-1,6282,6313,6314,-1,6315,6286,6284,-1,6284,6314,6315,-1,6316,6288,6286,-1,6286,6315,6316,-1,6317,6290,6288,-1,6288,6316,6317,-1,6318,6292,6290,-1,6290,6317,6318,-1,6319,6294,6292,-1,6292,6318,6319,-1,6320,6296,6294,-1,6294,6319,6320,-1,6321,6297,6296,-1,6296,6320,6321,-1,6322,6298,6297,-1,6297,6321,6322,-1,6300,6256,6298,-1,6298,6322,6300,-1,6323,6299,6300,-1,6300,6324,6323,-1,6325,6301,6299,-1,6299,6323,6325,-1,6326,6302,6301,-1,6301,6325,6326,-1,6327,6303,6302,-1,6302,6326,6327,-1,6328,6304,6303,-1,6303,6327,6328,-1,6329,6305,6304,-1,6304,6328,6329,-1,6330,6306,6305,-1,6305,6329,6330,-1,6331,6307,6306,-1,6306,6330,6331,-1,6332,6308,6307,-1,6307,6331,6332,-1,6333,6309,6308,-1,6308,6332,6333,-1,6334,6310,6309,-1,6309,6333,6334,-1,6335,6311,6310,-1,6310,6334,6335,-1,6336,6312,6311,-1,6311,6335,6336,-1,6337,6313,6312,-1,6312,6336,6337,-1,6338,6314,6313,-1,6313,6337,6338,-1,6339,6315,6314,-1,6314,6338,6339,-1,6340,6316,6315,-1,6315,6339,6340,-1,6341,6317,6316,-1,6316,6340,6341,-1,6342,6318,6317,-1,6317,6341,6342,-1,6343,6319,6318,-1,6318,6342,6343,-1,6344,6320,6319,-1,6319,6343,6344,-1,6345,6321,6320,-1,6320,6344,6345,-1,6346,6322,6321,-1,6321,6345,6346,-1,6324,6300,6322,-1,6322,6346,6324,-1,6347,6323,6324,-1,6324,6348,6347,-1,6349,6325,6323,-1,6323,6347,6349,-1,6350,6326,6325,-1,6325,6349,6350,-1,6351,6327,6326,-1,6326,6350,6351,-1,6352,6328,6327,-1,6327,6351,6352,-1,6353,6329,6328,-1,6328,6352,6353,-1,6354,6330,6329,-1,6329,6353,6354,-1,6355,6331,6330,-1,6330,6354,6355,-1,6356,6332,6331,-1,6331,6355,6356,-1,6357,6333,6332,-1,6332,6356,6357,-1,6358,6334,6333,-1,6333,6357,6358,-1,6359,6335,6334,-1,6334,6358,6359,-1,6360,6336,6335,-1,6335,6359,6360,-1,6361,6337,6336,-1,6336,6360,6361,-1,6362,6338,6337,-1,6337,6361,6362,-1,6363,6339,6338,-1,6338,6362,6363,-1,6364,6340,6339,-1,6339,6363,6364,-1,6365,6341,6340,-1,6340,6364,6365,-1,6366,6342,6341,-1,6341,6365,6366,-1,6367,6343,6342,-1,6342,6366,6367,-1,6368,6344,6343,-1,6343,6367,6368,-1,6369,6345,6344,-1,6344,6368,6369,-1,6370,6346,6345,-1,6345,6369,6370,-1,6348,6324,6346,-1,6346,6370,6348,-1,6371,6347,6348,-1,6348,6372,6371,-1,6373,6349,6347,-1,6347,6371,6373,-1,6374,6350,6349,-1,6349,6373,6374,-1,6375,6351,6350,-1,6350,6374,6375,-1,6376,6352,6351,-1,6351,6375,6376,-1,6377,6353,6352,-1,6352,6376,6377,-1,6378,6354,6353,-1,6353,6377,6378,-1,6379,6355,6354,-1,6354,6378,6379,-1,6380,6356,6355,-1,6355,6379,6380,-1,6381,6357,6356,-1,6356,6380,6381,-1,6382,6358,6357,-1,6357,6381,6382,-1,6383,6359,6358,-1,6358,6382,6383,-1,6384,6360,6359,-1,6359,6383,6384,-1,6385,6361,6360,-1,6360,6384,6385,-1,6386,6362,6361,-1,6361,6385,6386,-1,6387,6363,6362,-1,6362,6386,6387,-1,6388,6364,6363,-1,6363,6387,6388,-1,6389,6365,6364,-1,6364,6388,6389,-1,6390,6366,6365,-1,6365,6389,6390,-1,6391,6367,6366,-1,6366,6390,6391,-1,6392,6368,6367,-1,6367,6391,6392,-1,6393,6369,6368,-1,6368,6392,6393,-1,6394,6370,6369,-1,6369,6393,6394,-1,6372,6348,6370,-1,6370,6394,6372,-1,6395,6371,6372,-1,6372,6396,6395,-1,6397,6373,6371,-1,6371,6395,6397,-1,6398,6374,6373,-1,6373,6397,6398,-1,6399,6375,6374,-1,6374,6398,6399,-1,6400,6376,6375,-1,6375,6399,6400,-1,6401,6377,6376,-1,6376,6400,6401,-1,6402,6378,6377,-1,6377,6401,6402,-1,6403,6379,6378,-1,6378,6402,6403,-1,6404,6380,6379,-1,6379,6403,6404,-1,6405,6381,6380,-1,6380,6404,6405,-1,6406,6382,6381,-1,6381,6405,6406,-1,6407,6383,6382,-1,6382,6406,6407,-1,6408,6384,6383,-1,6383,6407,6408,-1,6409,6385,6384,-1,6384,6408,6409,-1,6410,6386,6385,-1,6385,6409,6410,-1,6411,6387,6386,-1,6386,6410,6411,-1,6412,6388,6387,-1,6387,6411,6412,-1,6413,6389,6388,-1,6388,6412,6413,-1,6414,6390,6389,-1,6389,6413,6414,-1,6415,6391,6390,-1,6390,6414,6415,-1,6416,6392,6391,-1,6391,6415,6416,-1,6417,6393,6392,-1,6392,6416,6417,-1,6418,6394,6393,-1,6393,6417,6418,-1,6396,6372,6394,-1,6394,6418,6396,-1,6419,6395,6396,-1,6396,6420,6419,-1,6421,6397,6395,-1,6395,6419,6421,-1,6422,6398,6397,-1,6397,6421,6422,-1,6423,6399,6398,-1,6398,6422,6423,-1,6424,6400,6399,-1,6399,6423,6424,-1,6425,6401,6400,-1,6400,6424,6425,-1,6426,6402,6401,-1,6401,6425,6426,-1,6427,6403,6402,-1,6402,6426,6427,-1,6428,6404,6403,-1,6403,6427,6428,-1,6429,6405,6404,-1,6404,6428,6429,-1,6430,6406,6405,-1,6405,6429,6430,-1,6431,6407,6406,-1,6406,6430,6431,-1,6432,6408,6407,-1,6407,6431,6432,-1,6433,6409,6408,-1,6408,6432,6433,-1,6434,6410,6409,-1,6409,6433,6434,-1,6435,6411,6410,-1,6410,6434,6435,-1,6436,6412,6411,-1,6411,6435,6436,-1,6437,6413,6412,-1,6412,6436,6437,-1,6438,6414,6413,-1,6413,6437,6438,-1,6439,6415,6414,-1,6414,6438,6439,-1,6440,6416,6415,-1,6415,6439,6440,-1,6441,6417,6416,-1,6416,6440,6441,-1,6442,6418,6417,-1,6417,6441,6442,-1,6420,6396,6418,-1,6418,6442,6420,-1,6155,6419,6420,-1,6420,6156,6155,-1,6157,6421,6419,-1,6419,6155,6157,-1,6158,6422,6421,-1,6421,6157,6158,-1,6159,6423,6422,-1,6422,6158,6159,-1,6160,6424,6423,-1,6423,6159,6160,-1,6161,6425,6424,-1,6424,6160,6161,-1,6162,6426,6425,-1,6425,6161,6162,-1,6163,6427,6426,-1,6426,6162,6163,-1,6164,6428,6427,-1,6427,6163,6164,-1,6165,6429,6428,-1,6428,6164,6165,-1,6166,6430,6429,-1,6429,6165,6166,-1,6167,6431,6430,-1,6430,6166,6167,-1,6168,6432,6431,-1,6431,6167,6168,-1,6169,6433,6432,-1,6432,6168,6169,-1,6170,6434,6433,-1,6433,6169,6170,-1,6171,6435,6434,-1,6434,6170,6171,-1,6172,6436,6435,-1,6435,6171,6172,-1,6173,6437,6436,-1,6436,6172,6173,-1,6174,6438,6437,-1,6437,6173,6174,-1,6175,6439,6438,-1,6438,6174,6175,-1,6176,6440,6439,-1,6439,6175,6176,-1,6177,6441,6440,-1,6440,6176,6177,-1,6178,6442,6441,-1,6441,6177,6178,-1,6156,6420,6442,-1,6442,6178,6156,-1,6443,6444,6445,-1,6444,6446,6447,-1,6443,6446,6444,-1,6443,6448,6446,-1,6448,6449,6446,-1,6447,6450,6444,-1,6451,2030,2010,-1,6452,6453,6454,-1,2059,2058,6453,-1,1678,6455,6456,-1,6457,6458,6459,-1,6460,6461,6457,-1,6462,6461,6463,-1,6464,6465,6466,-1,6455,6467,6468,-1,6469,6470,6471,-1,2090,6472,6473,-1,1721,6474,2114,-1,6475,6476,6474,-1,6477,6478,6455,-1,6479,6480,6481,-1,6482,6463,6483,-1,6468,6480,6484,-1,6485,6486,6487,-1,6488,6489,6490,-1,6491,6492,6493,-1,6489,6494,6490,-1,6495,6496,6497,-1,6498,6499,6500,-1,6501,6502,6503,-1,6504,6505,6506,-1,6507,6504,6508,-1,6509,6510,6511,-1,6512,2030,6451,-1,2030,6512,6513,-1,6514,6513,6515,-1,6513,6512,6515,-1,6516,6517,6518,-1,6519,6520,6521,-1,6522,6523,6524,-1,6462,6525,6526,-1,6527,6528,6529,-1,6530,6529,6531,-1,6532,6533,6534,-1,6475,6535,6536,-1,6536,6535,6537,-1,6477,6484,6538,-1,6539,6540,6535,-1,6541,6525,6542,-1,6543,6544,6545,-1,6546,6547,6548,-1,6549,6550,6551,-1,6552,6553,6554,-1,6555,6483,6556,-1,6557,6548,6555,-1,6558,6559,6560,-1,6561,6562,6563,-1,6564,6565,6566,-1,6567,6568,6569,-1,6570,6571,6572,-1,6573,6574,6575,-1,6576,6577,6578,-1,6446,6579,6580,-1,6580,6447,6446,-1,6443,6581,6582,-1,6582,6448,6443,-1,6445,6583,6581,-1,6581,6443,6445,-1,6444,6584,6583,-1,6583,6445,6444,-1,6585,6452,6454,-1,6454,6586,6585,-1,6586,6454,6587,-1,6587,6588,6586,-1,6589,6470,6452,-1,6452,6585,6589,-1,6590,6585,6586,-1,6586,6591,6590,-1,6592,6459,6470,-1,6470,6589,6592,-1,6593,6589,6585,-1,6585,6590,6593,-1,6594,6595,6459,-1,6459,6592,6594,-1,6596,6592,6589,-1,6589,6593,6596,-1,6597,6598,6595,-1,6595,6594,6597,-1,6599,6594,6592,-1,6592,6596,6599,-1,6600,6601,6598,-1,6598,6597,6600,-1,6602,6597,6594,-1,6594,6599,6602,-1,6588,6587,6601,-1,6601,6600,6588,-1,6603,6600,6597,-1,6597,6602,6603,-1,6604,6588,6600,-1,6600,6603,6604,-1,6591,6586,6588,-1,6588,6604,6591,-1,6581,6590,6591,-1,6591,6582,6581,-1,6583,6593,6590,-1,6590,6581,6583,-1,6584,6596,6593,-1,6593,6583,6584,-1,6605,6599,6596,-1,6596,6584,6605,-1,6580,6602,6599,-1,6599,6605,6580,-1,6579,6603,6602,-1,6602,6580,6579,-1,6606,6604,6603,-1,6603,6579,6606,-1,6582,6591,6604,-1,6604,6606,6582,-1,6450,6605,6584,-1,6584,6444,6450,-1,6447,6580,6605,-1,6605,6450,6447,-1,6449,6606,6579,-1,6579,6446,6449,-1,6448,6582,6606,-1,6606,6449,6448,-1,1856,2030,6556,-1,6556,2028,1856,-1,2026,1642,6505,-1,6505,1649,2026,-1,1648,1647,6451,-1,6451,2010,1648,-1,2028,6556,6483,-1,6483,1729,2028,-1,1737,2166,2148,-1,2148,6607,1737,-1,6452,6470,6469,-1,6469,6453,6452,-1,6470,6459,6458,-1,6458,6471,6470,-1,6457,6459,6595,-1,6595,6460,6457,-1,6598,1665,6460,-1,6460,6595,6598,-1,6598,6601,1666,-1,1666,1665,6598,-1,1659,1666,6601,-1,6601,6587,1659,-1,1660,1659,6587,-1,6587,6454,1660,-1,6454,6453,2058,-1,2058,1660,6454,-1,6467,6455,1678,-1,1678,1677,6467,-1,2095,6608,1721,-1,1721,1723,2095,-1,2084,1678,6456,-1,6456,2102,2084,-1,2102,6539,6608,-1,6608,2095,2102,-1,1707,2114,6474,-1,6474,1705,1707,-1,6455,6478,6540,-1,6540,6456,6455,-1,6458,6457,6526,-1,6526,6609,6458,-1,6458,6609,6610,-1,6610,6471,6458,-1,6464,6469,6471,-1,6471,6610,6464,-1,1665,2064,6461,-1,6461,6460,1665,-1,1727,6463,6461,-1,6461,2064,1727,-1,2131,6611,6612,-1,6612,2047,2131,-1,6461,6462,6526,-1,6526,6457,6461,-1,2139,6613,6614,-1,6614,2135,2139,-1,2120,6487,6486,-1,6486,2143,2120,-1,1683,2087,2090,-1,2090,6473,1683,-1,2091,2163,6472,-1,6472,2090,2091,-1,6453,6469,2162,-1,2162,2059,6453,-1,6469,6464,6466,-1,6466,2162,6469,-1,6466,6472,2163,-1,2163,2162,6466,-1,1705,6474,6487,-1,6487,2120,1705,-1,6456,6540,6539,-1,6539,2102,6456,-1,1677,1683,6481,-1,6481,6467,1677,-1,1729,6483,6463,-1,6463,1727,1729,-1,6481,1683,6473,-1,6473,6479,6481,-1,6615,6472,6466,-1,6466,6465,6615,-1,1721,6608,6475,-1,6475,6474,1721,-1,2047,6612,2050,-1,2050,1655,2047,-1,6616,6617,2159,-1,2159,2158,6616,-1,6487,6569,6568,-1,6568,6485,6487,-1,6618,6619,6620,-1,6620,6621,6618,-1,6622,2080,2072,-1,2072,6575,6622,-1,2071,6573,6575,-1,6575,2072,2071,-1,6623,2147,2080,-1,2080,6622,6623,-1,6468,6484,6477,-1,6477,6455,6468,-1,6473,6472,6615,-1,6615,6479,6473,-1,6467,6481,6480,-1,6480,6468,6467,-1,6485,6568,6621,-1,6621,6620,6485,-1,6619,6618,6624,-1,6624,6625,6619,-1,6607,2148,2147,-1,2147,6623,6607,-1,6626,6627,6617,-1,6617,6616,6626,-1,6479,6615,6553,-1,6553,6552,6479,-1,6474,6476,6569,-1,6569,6487,6474,-1,6465,6628,6553,-1,6553,6615,6465,-1,6552,6484,6480,-1,6480,6479,6552,-1,2135,6614,6611,-1,6611,2131,2135,-1,2143,6486,6613,-1,6613,2139,2143,-1,6607,6629,1738,-1,1738,1737,6607,-1,2158,2056,1733,-1,1733,6616,2158,-1,6616,1733,2050,-1,2050,6626,6616,-1,6626,2050,6612,-1,6612,6630,6626,-1,6630,6612,6611,-1,6611,6625,6630,-1,6625,6611,6614,-1,6614,6619,6625,-1,6619,6614,6613,-1,6613,6620,6619,-1,6620,6613,6486,-1,6486,6485,6620,-1,6631,6632,6508,-1,6508,6633,6631,-1,6631,6634,6635,-1,6635,6636,6631,-1,6636,6635,6498,-1,6498,6637,6636,-1,6638,6635,6634,-1,6634,6639,6638,-1,6510,6634,6631,-1,6631,6633,6510,-1,6632,6631,6636,-1,6636,6640,6632,-1,6638,6639,6641,-1,6641,6642,6638,-1,6643,6641,6639,-1,6639,6509,6643,-1,6638,6642,6644,-1,6644,6645,6638,-1,6646,6490,6492,-1,6492,6647,6646,-1,6491,6648,6647,-1,6647,6492,6491,-1,6493,6492,6490,-1,6490,6494,6493,-1,6490,6646,6649,-1,6649,6496,6490,-1,6646,6647,6650,-1,6650,6651,6646,-1,6494,6518,6652,-1,6652,6493,6494,-1,6488,6653,6516,-1,6516,6489,6488,-1,6654,6521,6523,-1,6523,6497,6654,-1,6493,6652,6507,-1,6507,6491,6493,-1,6494,6489,6516,-1,6516,6518,6494,-1,6495,6522,6653,-1,6653,6488,6495,-1,6655,6654,6497,-1,6497,6656,6655,-1,6649,6656,6497,-1,6497,6496,6649,-1,6655,6657,6658,-1,6658,6654,6655,-1,6655,6656,6501,-1,6501,6503,6655,-1,6649,6646,6651,-1,6651,6659,6649,-1,6488,6490,6496,-1,6496,6495,6488,-1,6648,6660,6650,-1,6650,6647,6648,-1,6640,6648,6491,-1,6491,6632,6640,-1,6640,6636,6637,-1,6637,6661,6640,-1,6497,6523,6522,-1,6522,6495,6497,-1,6632,6491,6507,-1,6507,6508,6632,-1,6510,6509,6639,-1,6639,6634,6510,-1,6654,6658,6519,-1,6519,6521,6654,-1,6662,6663,6519,-1,6519,6658,6662,-1,6635,6638,6645,-1,6645,6498,6635,-1,6648,6640,6661,-1,6661,6660,6648,-1,6501,6656,6649,-1,6649,6659,6501,-1,6664,6662,6658,-1,6658,6657,6664,-1,6503,6665,6657,-1,6657,6655,6503,-1,6666,6500,6667,-1,6667,6668,6666,-1,6499,6669,6667,-1,6667,6500,6499,-1,6500,6666,6637,-1,6637,6498,6500,-1,6666,6668,6670,-1,6670,6671,6666,-1,6672,6669,6499,-1,6499,6673,6672,-1,6673,6674,6675,-1,6675,6672,6673,-1,6674,6673,6645,-1,6645,6644,6674,-1,6676,6677,6678,-1,6678,6679,6676,-1,6651,6650,6679,-1,6679,6678,6651,-1,6680,6681,6678,-1,6678,6677,6680,-1,6682,6676,6679,-1,6679,6683,6682,-1,6650,6660,6683,-1,6683,6679,6650,-1,6670,6682,6683,-1,6683,6671,6670,-1,6661,6671,6683,-1,6683,6660,6661,-1,6659,6651,6678,-1,6678,6681,6659,-1,6681,6680,6684,-1,6684,6502,6681,-1,6684,6665,6503,-1,6503,6502,6684,-1,6502,6501,6659,-1,6659,6681,6502,-1,6637,6666,6671,-1,6671,6661,6637,-1,6499,6498,6645,-1,6645,6673,6499,-1,6664,6657,6665,-1,6665,6685,6664,-1,6686,6531,6687,-1,6687,6688,6686,-1,6689,6686,6688,-1,6688,6690,6689,-1,6691,6690,6688,-1,6688,6692,6691,-1,6686,6689,6693,-1,6693,6694,6686,-1,6695,6696,6697,-1,6697,6698,6695,-1,6699,6700,6701,-1,6701,6702,6699,-1,6703,6545,6547,-1,6547,6704,6703,-1,6705,6706,6530,-1,6530,6694,6705,-1,6707,6708,6709,-1,6709,6710,6707,-1,6697,6707,6710,-1,6710,6698,6697,-1,6705,6709,6708,-1,6708,6706,6705,-1,6701,6543,6711,-1,6711,6702,6701,-1,6698,6712,6713,-1,6713,6695,6698,-1,6710,6714,6712,-1,6712,6698,6710,-1,6709,6715,6714,-1,6714,6710,6709,-1,6705,6716,6715,-1,6715,6709,6705,-1,6694,6693,6716,-1,6716,6705,6694,-1,6702,6717,6718,-1,6718,6699,6702,-1,6718,6719,6720,-1,6720,6699,6718,-1,6717,6702,6711,-1,6711,6721,6717,-1,6722,6721,6711,-1,6711,6703,6722,-1,6722,6703,6704,-1,6704,6723,6722,-1,6724,6723,6704,-1,6704,6725,6724,-1,6686,6694,6530,-1,6530,6531,6686,-1,6546,6725,6704,-1,6704,6547,6546,-1,6703,6711,6543,-1,6543,6545,6703,-1,6692,6688,6687,-1,6687,6726,6692,-1,6726,6727,6720,-1,6720,6692,6726,-1,6727,6700,6699,-1,6699,6720,6727,-1,6720,6719,6691,-1,6691,6692,6720,-1,6728,6511,1642,-1,1642,1641,6728,-1,6509,6511,6728,-1,6728,6643,6509,-1,6504,6506,6633,-1,6633,6508,6504,-1,6510,6633,6506,-1,6506,6511,6510,-1,1642,6511,6506,-1,6506,6505,1642,-1,6504,1647,1649,-1,1649,6505,6504,-1,6729,6451,1647,-1,1647,6504,6729,-1,6512,6451,6729,-1,6729,6517,6512,-1,6504,6507,6652,-1,6652,6729,6504,-1,6729,6652,6518,-1,6518,6517,6729,-1,6512,6517,6730,-1,6730,6515,6512,-1,6515,6730,6524,-1,6524,6514,6515,-1,6514,6524,6520,-1,6520,6556,6514,-1,6524,6730,6653,-1,6653,6522,6524,-1,6514,6556,2030,-1,2030,6513,6514,-1,6516,6653,6730,-1,6730,6517,6516,-1,6556,6520,6557,-1,6557,6555,6556,-1,6524,6523,6521,-1,6521,6520,6524,-1,6520,6519,6663,-1,6663,6557,6520,-1,6609,6541,6731,-1,6731,6610,6609,-1,6463,6482,6525,-1,6525,6462,6463,-1,6732,6464,6610,-1,6610,6731,6732,-1,6609,6526,6525,-1,6525,6541,6609,-1,6531,6529,6528,-1,6528,6687,6531,-1,6726,6687,6528,-1,6528,6733,6726,-1,6554,6550,6534,-1,6534,6533,6554,-1,6706,6708,6533,-1,6533,6532,6706,-1,6529,6532,6534,-1,6534,6527,6529,-1,6534,6550,6549,-1,6549,6527,6534,-1,6532,6529,6530,-1,6530,6706,6532,-1,6608,6539,6535,-1,6535,6475,6608,-1,6475,6536,6734,-1,6734,6476,6475,-1,6478,6537,6535,-1,6535,6540,6478,-1,6538,6735,6536,-1,6536,6537,6538,-1,6536,6697,6696,-1,6696,6734,6536,-1,6735,6707,6697,-1,6697,6536,6735,-1,6477,6538,6537,-1,6537,6478,6477,-1,6554,6538,6484,-1,6484,6552,6554,-1,6541,6542,6736,-1,6736,6731,6541,-1,6551,6732,6731,-1,6731,6736,6551,-1,6737,6736,6542,-1,6542,6738,6737,-1,6738,6701,6700,-1,6700,6737,6738,-1,6727,6739,6737,-1,6737,6700,6727,-1,6544,6543,6701,-1,6701,6738,6544,-1,6482,6740,6542,-1,6542,6525,6482,-1,6542,6740,6544,-1,6544,6738,6542,-1,6739,6551,6736,-1,6736,6737,6739,-1,6547,6545,6544,-1,6544,6548,6547,-1,6555,6548,6544,-1,6544,6740,6555,-1,6464,6732,6628,-1,6628,6465,6464,-1,6732,6551,6550,-1,6550,6628,6732,-1,6553,6628,6550,-1,6550,6554,6553,-1,6551,6739,6733,-1,6733,6549,6551,-1,6707,6735,6533,-1,6533,6708,6707,-1,6735,6538,6554,-1,6554,6533,6735,-1,6483,6555,6740,-1,6740,6482,6483,-1,6549,6733,6528,-1,6528,6527,6549,-1,6726,6733,6739,-1,6739,6727,6726,-1,6685,6741,6724,-1,6724,6664,6685,-1,6664,6724,6725,-1,6725,6662,6664,-1,6662,6725,6546,-1,6546,6663,6662,-1,6663,6546,6548,-1,6548,6557,6663,-1,6643,6742,6743,-1,6743,6641,6643,-1,6743,6744,6642,-1,6642,6641,6743,-1,6745,6746,6747,-1,6747,6748,6745,-1,6749,6750,6748,-1,6748,6747,6749,-1,6743,6742,6751,-1,6751,6752,6743,-1,6753,6566,6754,-1,6754,6755,6753,-1,6751,6564,6756,-1,6756,6752,6751,-1,6755,6745,6757,-1,6757,6758,6755,-1,6758,6757,6558,-1,6558,6560,6758,-1,6757,6745,6748,-1,6748,6759,6757,-1,6755,6754,6746,-1,6746,6745,6755,-1,6760,6753,6755,-1,6755,6758,6760,-1,6752,6761,6744,-1,6744,6743,6752,-1,6762,6744,6761,-1,6761,6763,6762,-1,6756,6764,6761,-1,6761,6752,6756,-1,6765,6759,6748,-1,6748,6750,6765,-1,6757,6759,6766,-1,6766,6558,6757,-1,6759,6765,6767,-1,6767,6766,6759,-1,6768,6765,6750,-1,6750,6769,6768,-1,6756,6753,6760,-1,6760,6764,6756,-1,6760,6758,6560,-1,6560,6563,6760,-1,6642,6744,6762,-1,6762,6644,6642,-1,6761,6764,6562,-1,6562,6763,6761,-1,6770,6769,6750,-1,6750,6749,6770,-1,6753,6756,6564,-1,6564,6566,6753,-1,6563,6562,6764,-1,6764,6760,6563,-1,6559,6771,6563,-1,6563,6560,6559,-1,6561,6772,6763,-1,6763,6562,6561,-1,6767,6773,6774,-1,6774,6766,6767,-1,6775,6776,6773,-1,6773,6767,6775,-1,6774,6559,6558,-1,6558,6766,6774,-1,6777,6675,6674,-1,6674,6778,6777,-1,6644,6762,6778,-1,6778,6674,6644,-1,6772,6779,6777,-1,6777,6778,6772,-1,6780,6779,6772,-1,6772,6561,6780,-1,6563,6771,6780,-1,6780,6561,6563,-1,6778,6762,6763,-1,6763,6772,6778,-1,6781,6782,6783,-1,6783,6784,6781,-1,6785,6781,6784,-1,6784,6786,6785,-1,6787,6788,6786,-1,6786,6784,6787,-1,6781,6785,6789,-1,6789,6790,6781,-1,6781,6790,6791,-1,6791,6782,6781,-1,6792,6793,6791,-1,6791,6790,6792,-1,6790,6789,6794,-1,6794,6792,6790,-1,6792,6794,6795,-1,6795,6796,6792,-1,6797,6798,6799,-1,6799,6796,6797,-1,6800,6801,6802,-1,6802,6803,6800,-1,6792,6796,6799,-1,6799,6793,6792,-1,6803,6802,6696,-1,6696,6695,6803,-1,6783,6570,6787,-1,6787,6784,6783,-1,6804,6768,6769,-1,6769,6797,6804,-1,6796,6795,6804,-1,6804,6797,6796,-1,6805,6788,6787,-1,6787,6806,6805,-1,6807,6808,6805,-1,6805,6806,6807,-1,6809,6808,6807,-1,6807,6810,6809,-1,6806,6572,6811,-1,6811,6807,6806,-1,6812,6813,6809,-1,6809,6810,6812,-1,6814,6813,6812,-1,6812,6800,6814,-1,6810,6815,6816,-1,6816,6812,6810,-1,6803,6695,6713,-1,6713,6817,6803,-1,6814,6800,6803,-1,6803,6817,6814,-1,6806,6787,6570,-1,6570,6572,6806,-1,6797,6769,6770,-1,6770,6798,6797,-1,6800,6812,6816,-1,6816,6801,6800,-1,6810,6807,6811,-1,6811,6815,6810,-1,1750,6578,6728,-1,6728,1641,1750,-1,6578,6742,6643,-1,6643,6728,6578,-1,6576,6578,1750,-1,1750,2174,6576,-1,6742,6578,6577,-1,6577,6751,6742,-1,6818,6819,6747,-1,6747,6746,6818,-1,6629,6749,6747,-1,6747,6819,6629,-1,6819,6818,6820,-1,6820,6821,6819,-1,6818,6746,6754,-1,6754,6822,6818,-1,6820,6823,2178,-1,2178,2176,6820,-1,6824,2180,2178,-1,2178,6823,6824,-1,2172,6821,6820,-1,6820,2176,2172,-1,6770,6749,6629,-1,6629,6825,6770,-1,1738,6629,6819,-1,6819,6821,1738,-1,1738,6821,2172,-1,2172,1744,1738,-1,6576,2174,2180,-1,2180,6824,6576,-1,6566,6565,6822,-1,6822,6754,6566,-1,6751,6577,6565,-1,6565,6564,6751,-1,6782,6826,6827,-1,6827,6783,6782,-1,6570,6783,6827,-1,6827,6571,6570,-1,6828,6829,6617,-1,6617,6627,6828,-1,6826,6782,6791,-1,6791,6830,6826,-1,6802,6801,6831,-1,6831,6832,6802,-1,6832,6569,6476,-1,6476,6734,6832,-1,6833,6621,6568,-1,6568,6567,6833,-1,6834,6618,6621,-1,6621,6833,6834,-1,6816,6815,6835,-1,6835,6836,6816,-1,6837,6624,6618,-1,6618,6834,6837,-1,6838,6839,6624,-1,6624,6837,6838,-1,6811,6572,6571,-1,6571,6840,6811,-1,6630,6625,6624,-1,6624,6839,6630,-1,6627,6839,6838,-1,6838,6828,6627,-1,6841,2159,6617,-1,6617,6829,6841,-1,6842,2155,2159,-1,2159,6841,6842,-1,6830,6791,6793,-1,6793,6843,6830,-1,6573,2071,2155,-1,2155,6842,6573,-1,6799,6574,6843,-1,6843,6793,6799,-1,6798,6844,6574,-1,6574,6799,6798,-1,6825,6844,6798,-1,6798,6770,6825,-1,6734,6696,6802,-1,6802,6832,6734,-1,6836,6831,6801,-1,6801,6816,6836,-1,6626,6630,6839,-1,6839,6627,6626,-1,6840,6835,6815,-1,6815,6811,6840,-1,6569,6832,6831,-1,6831,6567,6569,-1,6567,6831,6836,-1,6836,6833,6567,-1,6833,6836,6835,-1,6835,6834,6833,-1,6834,6835,6840,-1,6840,6837,6834,-1,6837,6840,6571,-1,6571,6838,6837,-1,6838,6571,6827,-1,6827,6828,6838,-1,6828,6827,6826,-1,6826,6829,6828,-1,6829,6826,6830,-1,6830,6841,6829,-1,6841,6830,6843,-1,6843,6842,6841,-1,6842,6843,6574,-1,6574,6573,6842,-1,6575,6574,6844,-1,6844,6622,6575,-1,6622,6844,6825,-1,6825,6623,6622,-1,6623,6825,6629,-1,6629,6607,6623,-1,6820,6818,6822,-1,6822,6823,6820,-1,6823,6822,6565,-1,6565,6824,6823,-1,6824,6565,6577,-1,6577,6576,6824,-1,6767,6765,6768,-1,6768,6775,6767,-1,6845,6846,6847,-1,6846,6848,6849,-1,6850,6851,6852,-1,6845,6847,6851,-1,6853,6854,6855,-1,6856,6857,6858,-1,6857,6859,6858,-1,6858,6860,6856,-1,6861,6862,6863,-1,6864,6863,6862,-1,6865,6866,6867,-1,6868,6869,6870,-1,6869,6871,6872,-1,6871,6869,6868,-1,6873,6869,6874,-1,6868,6875,6876,-1,6877,6878,6879,-1,6880,6881,6882,-1,6883,6884,6885,-1,6886,6870,6887,-1,6885,6860,6858,-1,6860,6885,6884,-1,6888,6889,6890,-1,6891,6892,6893,-1,6894,6895,6896,-1,6897,6898,6899,-1,6900,6901,6902,-1,6903,6904,6905,-1,6906,6907,6897,-1,6908,6909,6910,-1,6911,6912,6913,-1,6914,6915,6916,-1,6917,6918,6919,-1,6920,6921,6922,-1,6923,6924,6925,-1,6926,6927,6928,-1,6929,6930,6931,-1,6932,6933,6934,-1,6935,6936,6937,-1,6938,6939,6940,-1,6941,6910,6942,-1,6940,6943,6944,-1,6945,6946,6947,-1,6948,6949,6950,-1,6951,6952,6953,-1,6954,6955,6956,-1,6957,6958,6959,-1,6960,6961,6962,-1,6963,6964,6965,-1,6956,6966,6967,-1,6967,6968,6969,-1,6970,6971,6972,-1,6973,6974,6975,-1,6976,6977,6978,-1,6979,6980,6981,-1,6982,6919,6981,-1,6983,6984,6985,-1,6986,6987,6959,-1,6986,6988,6962,-1,6989,6990,6991,-1,6992,6993,6994,-1,6995,6996,6997,-1,6998,6788,6805,-1,6999,6855,7000,-1,7000,7001,6999,-1,7002,7003,7001,-1,7001,7000,7002,-1,6855,6999,7004,-1,7004,6853,6855,-1,7005,6999,7001,-1,7001,6856,7005,-1,7006,7007,7008,-1,7008,7009,7006,-1,7009,7008,6903,-1,6903,7010,7009,-1,7007,7011,7012,-1,7012,7008,7007,-1,7013,7014,7007,-1,7007,7006,7013,-1,7015,7006,7009,-1,7009,7016,7015,-1,6848,6846,6845,-1,6845,7017,6848,-1,6851,6850,7017,-1,7017,6845,6851,-1,7018,7019,6848,-1,6848,7017,7018,-1,7017,6850,7002,-1,7002,7018,7017,-1,7010,6903,7020,-1,7020,7021,7010,-1,7008,7012,6904,-1,6904,6903,7008,-1,7016,7009,7010,-1,7010,7022,7016,-1,7021,7020,7023,-1,7023,7024,7021,-1,6905,7025,7020,-1,7020,6903,6905,-1,7014,7026,7011,-1,7011,7007,7014,-1,6853,7004,7014,-1,7014,7013,6853,-1,7006,7015,7027,-1,7027,7013,7006,-1,7004,7028,7026,-1,7026,7014,7004,-1,6853,7013,7027,-1,7027,6854,6853,-1,6999,7005,7028,-1,7028,7004,6999,-1,7003,6861,6856,-1,6856,7001,7003,-1,7002,6850,6852,-1,6852,7003,7002,-1,6847,7029,6852,-1,6852,6851,6847,-1,6849,6848,7019,-1,7019,7030,6849,-1,6849,7031,6847,-1,6847,6846,6849,-1,7032,7033,7030,-1,7030,7019,7032,-1,7033,7034,7035,-1,7035,7030,7033,-1,7036,7033,7032,-1,7032,7037,7036,-1,6929,7038,7036,-1,7036,7037,6929,-1,7038,7039,7040,-1,7040,7036,7038,-1,6932,7041,7038,-1,7038,6929,6932,-1,7041,7042,7039,-1,7039,7038,7041,-1,7043,7041,6932,-1,6932,6935,7043,-1,7044,7045,7046,-1,7046,7047,7044,-1,7047,7046,6907,-1,6907,6906,7047,-1,7048,7049,7046,-1,7046,7045,7048,-1,6935,7044,7047,-1,7047,7043,6935,-1,7049,7050,6907,-1,6907,7046,7049,-1,7051,7052,7049,-1,7049,7048,7051,-1,7052,7053,7050,-1,7050,7049,7052,-1,7054,7052,7051,-1,7051,7055,7054,-1,7023,7054,7055,-1,7055,7024,7023,-1,7020,7025,7056,-1,7056,7023,7020,-1,7054,7057,7053,-1,7053,7052,7054,-1,7058,7042,7041,-1,7041,7043,7058,-1,7035,7031,6849,-1,6849,7030,7035,-1,6852,7029,6861,-1,6861,7003,6852,-1,7040,7034,7033,-1,7033,7036,7040,-1,7043,7047,6906,-1,6906,7058,7043,-1,7056,7057,7054,-1,7054,7023,7056,-1,6861,6863,6857,-1,6857,6856,6861,-1,7029,7059,6862,-1,6862,6861,7029,-1,6865,7060,7061,-1,7061,6866,6865,-1,6892,6866,7061,-1,7061,7062,6892,-1,7060,7063,7064,-1,7064,7061,7060,-1,7060,6865,7065,-1,7065,7066,7060,-1,7067,7068,7069,-1,7069,6878,7067,-1,6878,7069,7070,-1,7070,6880,6878,-1,7071,7068,7067,-1,7067,7072,7071,-1,6878,6877,7073,-1,7073,7067,6878,-1,7074,6872,7075,-1,7075,7076,7074,-1,7077,7078,7076,-1,7076,7075,7077,-1,7075,6872,6871,-1,6871,7079,7075,-1,6872,7074,6874,-1,6874,6869,6872,-1,7074,7076,7080,-1,7080,7081,7074,-1,7078,7082,7080,-1,7080,7076,7078,-1,7079,7083,7077,-1,7077,7075,7079,-1,7084,7085,7079,-1,7079,6871,7084,-1,7081,7086,6874,-1,6874,7074,7081,-1,7087,7080,7082,-1,7082,7088,7087,-1,7081,7080,7087,-1,7087,6883,7081,-1,7089,6883,7087,-1,7087,7090,7089,-1,7086,7081,6883,-1,6883,6885,7086,-1,6873,6874,7086,-1,7086,6859,6873,-1,7091,7083,7079,-1,7079,7085,7091,-1,7092,7091,7085,-1,7085,7093,7092,-1,7084,7094,7093,-1,7093,7085,7084,-1,7093,7094,7095,-1,7095,7096,7093,-1,7094,7084,6876,-1,6876,7097,7094,-1,7084,6871,6868,-1,6868,6876,7084,-1,7096,7098,7092,-1,7092,7093,7096,-1,7099,7100,7096,-1,7096,7095,7099,-1,7095,7094,7097,-1,7097,7101,7095,-1,6875,6864,7097,-1,7097,6876,6875,-1,7065,7102,7089,-1,7089,7066,7065,-1,7066,7089,7090,-1,7090,7103,7066,-1,6883,7089,7102,-1,7102,6884,6883,-1,7102,7065,7104,-1,7104,7105,7102,-1,7103,7090,7106,-1,7106,7107,7103,-1,7066,7103,7063,-1,7063,7060,7066,-1,7088,7106,7090,-1,7090,7087,7088,-1,7108,7063,7103,-1,7103,7107,7108,-1,7064,7109,7062,-1,7062,7061,7064,-1,7110,7064,7063,-1,7063,7108,7110,-1,7065,6865,6867,-1,6867,7104,7065,-1,7111,7112,7113,-1,7113,7114,7111,-1,7115,7116,7117,-1,7117,7118,7115,-1,7115,7112,7111,-1,7111,7116,7115,-1,7119,7120,7116,-1,7116,7111,7119,-1,7096,7100,7121,-1,7121,7098,7096,-1,7113,7121,7100,-1,7100,7114,7113,-1,7114,7100,7099,-1,7099,7122,7114,-1,7123,7124,7125,-1,7125,7126,7123,-1,7127,7128,7126,-1,7126,7125,7127,-1,7124,7129,7130,-1,7130,7125,7124,-1,7124,7123,7131,-1,7131,7132,7124,-1,7123,7126,7133,-1,7133,7134,7123,-1,7135,7133,7126,-1,7126,7128,7135,-1,7136,7127,7125,-1,7125,7130,7136,-1,7130,7129,7137,-1,7137,7138,7130,-1,7129,7124,7132,-1,7132,6895,7129,-1,7139,7132,7131,-1,7131,7140,7139,-1,7123,7134,7141,-1,7141,7131,7123,-1,7142,7133,7135,-1,7135,7143,7142,-1,7133,7142,7144,-1,7144,7134,7133,-1,7145,7141,7134,-1,7134,7144,7145,-1,7117,7146,7144,-1,7144,7142,7117,-1,7131,7141,7147,-1,7147,7140,7131,-1,7136,7130,7138,-1,7138,7148,7136,-1,7149,7138,7137,-1,7137,7150,7149,-1,7137,7129,6895,-1,6895,6894,7137,-1,7139,6896,6895,-1,6895,7132,7139,-1,7151,7152,7153,-1,7153,7154,7151,-1,7155,7151,7154,-1,7154,7156,7155,-1,7157,7154,7153,-1,7153,7158,7157,-1,7152,7159,7160,-1,7160,7153,7152,-1,7161,7149,7160,-1,7160,7159,7161,-1,7153,7160,7162,-1,7162,7158,7153,-1,7158,7162,6898,-1,6898,7163,7158,-1,7162,7160,7149,-1,7149,7150,7162,-1,7157,7164,7156,-1,7156,7154,7157,-1,7156,7164,7165,-1,7165,7166,7156,-1,7164,7157,7167,-1,7167,7168,7164,-1,7157,7158,7163,-1,7163,7167,7157,-1,7169,7167,7163,-1,7163,7170,7169,-1,7150,6899,6898,-1,6898,7162,7150,-1,7163,6898,6897,-1,6897,7170,7163,-1,7166,7171,7155,-1,7155,7156,7166,-1,6881,6880,7166,-1,7166,7165,6881,-1,7172,7165,7164,-1,7164,7168,7172,-1,7169,7173,7168,-1,7168,7167,7169,-1,7070,7171,7166,-1,7166,6880,7070,-1,6882,6879,6878,-1,6878,6880,6882,-1,7174,7175,6879,-1,6879,6882,7174,-1,6881,7165,7172,-1,7172,7176,6881,-1,7177,7176,7172,-1,7172,7178,7177,-1,6882,6881,7176,-1,7176,7174,6882,-1,7120,7146,7117,-1,7117,7116,7120,-1,7120,7179,7180,-1,7180,7146,7120,-1,7120,7119,6900,-1,6900,7179,7120,-1,6900,6902,7181,-1,7181,7179,6900,-1,7119,7122,6901,-1,6901,6900,7119,-1,7119,7111,7114,-1,7114,7122,7119,-1,7122,7099,7182,-1,7182,6901,7122,-1,6901,7182,7059,-1,7059,6902,6901,-1,7095,7101,7182,-1,7182,7099,7095,-1,7141,7145,7183,-1,7183,7147,7141,-1,7146,7180,7145,-1,7145,7144,7146,-1,7118,7117,7142,-1,7142,7143,7118,-1,7145,7180,7184,-1,7184,7183,7145,-1,6894,6899,7150,-1,7150,7137,6894,-1,6899,6894,6896,-1,6896,6897,6899,-1,7138,7149,7161,-1,7161,7148,7138,-1,7109,7064,7110,-1,7110,7185,7109,-1,7109,7185,7071,-1,7071,7072,7109,-1,7062,7109,7072,-1,7072,7186,7062,-1,6891,6867,6866,-1,6866,6892,6891,-1,7186,6893,6892,-1,6892,7062,7186,-1,7072,7067,7073,-1,7073,7186,7072,-1,7105,6860,6884,-1,6884,7102,7105,-1,6889,6877,6879,-1,6879,7175,6889,-1,7187,7188,7175,-1,7175,7174,7187,-1,7073,6877,6889,-1,6889,6888,7073,-1,7188,6890,6889,-1,6889,7175,7188,-1,6888,6893,7186,-1,7186,7073,6888,-1,6893,6888,6890,-1,6890,6891,6893,-1,7097,6864,6862,-1,6862,7101,7097,-1,7180,7179,7181,-1,7181,7184,7180,-1,6864,6875,6886,-1,6886,6863,6864,-1,6868,6870,6886,-1,6886,6875,6868,-1,7182,7101,6862,-1,6862,7059,7182,-1,6887,6857,6863,-1,6863,6886,6887,-1,6869,6873,6887,-1,6887,6870,6869,-1,6859,6857,6887,-1,6887,6873,6859,-1,6859,7086,6885,-1,6885,6858,6859,-1,7028,7104,6867,-1,6867,7026,7028,-1,6860,7105,7005,-1,7005,6856,6860,-1,7012,6890,7188,-1,7188,6904,7012,-1,6905,6904,7188,-1,7188,7187,6905,-1,7174,7176,7177,-1,7177,7187,7174,-1,7039,7140,7147,-1,7147,7040,7039,-1,6896,7139,7042,-1,7042,7058,6896,-1,7147,7183,7034,-1,7034,7040,7147,-1,7050,7170,6897,-1,6897,6907,7050,-1,7172,7168,7173,-1,7173,7178,7172,-1,7057,7173,7169,-1,7169,7053,7057,-1,7178,7173,7057,-1,7057,7056,7178,-1,7034,7183,7184,-1,7184,7035,7034,-1,7184,7181,7031,-1,7031,7035,7184,-1,7005,7105,7104,-1,7104,7028,7005,-1,7026,6867,6891,-1,6891,7011,7026,-1,7011,6891,6890,-1,6890,7012,7011,-1,7187,7177,7025,-1,7025,6905,7187,-1,6902,7059,7029,-1,7029,6847,6902,-1,7031,7181,6902,-1,6902,6847,7031,-1,7042,7139,7140,-1,7140,7039,7042,-1,7053,7169,7170,-1,7170,7050,7053,-1,7025,7177,7178,-1,7178,7056,7025,-1,7058,6906,6897,-1,6897,6896,7058,-1,7015,6916,6915,-1,6915,7027,7015,-1,7016,6928,6916,-1,6916,7015,7016,-1,6855,6854,7189,-1,7189,7000,6855,-1,7022,7010,7021,-1,7021,7190,7022,-1,7191,7002,7000,-1,7000,7189,7191,-1,7192,7032,7019,-1,7019,7193,7192,-1,6929,7037,7194,-1,7194,6930,6929,-1,6931,6933,6932,-1,6932,6929,6931,-1,7195,7196,7045,-1,7045,7044,7195,-1,7197,7048,7045,-1,7045,7196,7197,-1,6938,7051,7048,-1,7048,7197,6938,-1,7190,7021,7024,-1,7024,7198,7190,-1,7055,7051,6938,-1,6938,7199,7055,-1,6936,6935,6932,-1,6932,6934,6936,-1,7193,7019,7018,-1,7018,7200,7193,-1,7200,7018,7002,-1,7002,7191,7200,-1,7192,7194,7037,-1,7037,7032,7192,-1,6937,7195,7044,-1,7044,6935,6937,-1,7199,7198,7024,-1,7024,7055,7199,-1,7201,7202,6909,-1,6909,6908,7201,-1,7201,6908,6943,-1,6943,7203,7201,-1,7203,6939,7204,-1,7204,7205,7203,-1,7204,7206,7207,-1,7207,7205,7204,-1,6913,7208,7209,-1,7209,6911,6913,-1,7210,6965,7211,-1,7211,6931,7210,-1,6976,7192,7193,-1,7193,6924,6976,-1,6922,6923,6925,-1,6925,6920,6922,-1,7212,7213,6934,-1,6934,6933,7212,-1,7213,7214,6936,-1,6936,6934,7213,-1,7214,6911,6937,-1,6937,6936,7214,-1,7208,7207,7206,-1,7206,7209,7208,-1,7209,7206,7196,-1,7196,7195,7209,-1,7204,7197,7196,-1,7196,7206,7204,-1,6917,7215,7216,-1,7216,7217,6917,-1,7218,6918,7219,-1,7219,7220,7218,-1,7220,7219,7221,-1,7221,7222,7220,-1,7222,7221,7223,-1,7223,7224,7222,-1,6940,6939,7203,-1,7203,6943,6940,-1,6943,6908,6910,-1,6910,6944,6943,-1,6942,6910,6909,-1,6909,7225,6942,-1,7225,7226,7227,-1,7227,6942,7225,-1,7212,6933,6931,-1,6931,7211,7212,-1,6930,6972,7210,-1,7210,6931,6930,-1,7228,6941,7229,-1,7229,7230,7228,-1,7230,7229,6927,-1,6927,6926,7230,-1,7231,7232,7229,-1,7229,6941,7231,-1,6944,6910,6941,-1,6941,7228,6944,-1,7228,7230,7190,-1,7190,7198,7228,-1,6914,7233,7234,-1,7234,6915,6914,-1,7234,6854,7027,-1,7027,6915,7234,-1,7235,7234,7233,-1,7233,7236,7235,-1,7233,6914,7237,-1,7237,7238,7233,-1,7235,7189,6854,-1,6854,7234,7235,-1,6926,7022,7190,-1,7190,7230,6926,-1,6944,7228,7198,-1,7198,7199,6944,-1,7199,6938,6940,-1,6940,6944,7199,-1,7239,7240,6988,-1,6988,7241,7239,-1,6975,6972,6930,-1,6930,7194,6975,-1,7217,7216,6922,-1,6922,6921,7217,-1,7242,7217,6921,-1,6921,7236,7242,-1,7236,6921,6920,-1,6920,7235,7236,-1,7221,7219,7238,-1,7238,7237,7221,-1,6914,7243,7244,-1,7244,7237,6914,-1,7238,7242,7236,-1,7236,7233,7238,-1,7223,7221,7237,-1,7237,7244,7223,-1,7245,7239,7244,-1,7244,7243,7245,-1,6916,6928,7243,-1,7243,6914,6916,-1,7217,7242,6918,-1,6918,6917,7217,-1,6924,7193,7200,-1,7200,6925,6924,-1,6918,7242,7238,-1,7238,7219,6918,-1,6939,6938,7197,-1,7197,7204,6939,-1,7227,7246,7247,-1,7247,7231,7227,-1,7231,7247,7240,-1,7240,7232,7231,-1,6942,7227,7231,-1,7231,6941,6942,-1,6988,7240,7247,-1,7247,7248,6988,-1,6927,7245,7243,-1,7243,6928,6927,-1,7232,7245,6927,-1,6927,7229,7232,-1,7223,7244,7239,-1,7239,7241,7223,-1,6920,7191,7189,-1,7189,7235,6920,-1,6925,7200,7191,-1,7191,6920,6925,-1,7194,7192,6976,-1,6976,6975,7194,-1,7022,6926,6928,-1,6928,7016,7022,-1,6911,7209,7195,-1,7195,6937,6911,-1,7240,7239,7245,-1,7245,7232,7240,-1,7249,7250,6668,-1,6668,6667,7249,-1,6667,6669,7251,-1,7251,7249,6667,-1,7252,6672,6675,-1,6675,7253,7252,-1,7254,6677,6676,-1,6676,7255,7254,-1,6676,6682,7256,-1,7256,7255,6676,-1,7256,6682,6670,-1,6670,7257,7256,-1,6675,6777,6997,-1,6997,7253,6675,-1,6780,6994,6995,-1,6995,6779,6780,-1,6559,7258,6992,-1,6992,6771,6559,-1,6559,6774,7259,-1,7259,7258,6559,-1,7260,6680,6677,-1,6677,7254,7260,-1,7261,6685,6665,-1,6665,6684,7261,-1,6777,6779,6995,-1,6995,6997,6777,-1,6780,6771,6992,-1,6992,6994,6780,-1,7261,6684,6680,-1,6680,7260,7261,-1,7251,6669,6672,-1,6672,7252,7251,-1,6668,7250,7257,-1,7257,6670,6668,-1,6773,7262,7259,-1,7259,6774,6773,-1,7263,7264,7265,-1,7265,7266,7263,-1,6813,7266,7265,-1,7265,6809,6813,-1,7267,7265,7264,-1,7264,6989,7267,-1,7264,7263,7268,-1,7268,7269,7264,-1,7270,7263,7266,-1,7266,7271,7270,-1,7267,6989,6991,-1,6991,7272,7267,-1,7267,7272,6805,-1,6805,6808,7267,-1,7271,7273,7274,-1,7274,7270,7271,-1,6817,7273,7271,-1,7271,6814,6817,-1,7275,7276,7277,-1,7277,7278,7275,-1,7279,7280,7281,-1,7281,7282,7279,-1,6690,7283,6955,-1,6955,6689,6690,-1,7284,7285,7286,-1,7286,7287,7284,-1,7279,7282,7286,-1,7286,7285,7279,-1,6998,7288,7276,-1,7276,7275,6998,-1,6713,6712,7289,-1,7289,7290,6713,-1,6714,7291,7289,-1,7289,6712,6714,-1,6714,6715,7292,-1,7292,7291,6714,-1,6716,7293,7292,-1,7292,6715,6716,-1,6693,7294,7293,-1,7293,6716,6693,-1,6718,6717,7295,-1,7295,7296,6718,-1,6721,7297,7295,-1,7295,6717,6721,-1,6722,6723,7298,-1,7298,7299,6722,-1,7278,7277,7281,-1,7281,7280,7278,-1,6689,6955,7294,-1,7294,6693,6689,-1,6814,7271,7266,-1,7266,6813,6814,-1,7267,6808,6809,-1,6809,7265,7267,-1,7270,7300,7268,-1,7268,7263,7270,-1,7301,6989,7264,-1,7264,7269,7301,-1,6741,7298,6723,-1,6723,6724,6741,-1,7297,6721,6722,-1,6722,7299,7297,-1,6817,6713,7290,-1,7290,7273,6817,-1,6776,6775,7284,-1,7284,7287,6776,-1,7288,6998,6805,-1,6805,7272,7288,-1,7283,6690,6691,-1,6691,7302,7283,-1,7302,6691,6719,-1,6719,7303,7302,-1,7303,6719,6718,-1,6718,7296,7303,-1,7304,7291,7292,-1,7292,7305,7304,-1,7304,7306,7289,-1,7289,7291,7304,-1,7292,7293,7307,-1,7307,7305,7292,-1,7294,6955,6954,-1,6954,7308,7294,-1,7293,7294,7308,-1,7308,7307,7293,-1,7309,7276,7288,-1,7288,7310,7309,-1,7311,7262,6773,-1,6773,6776,7311,-1,6950,6949,7299,-1,7299,7298,6950,-1,7312,7313,7295,-1,7295,7297,7312,-1,7313,7314,7296,-1,7296,7295,7313,-1,7306,7315,7290,-1,7290,7289,7306,-1,7286,7316,7317,-1,7317,7287,7286,-1,7286,7282,7318,-1,7318,7316,7286,-1,6955,7283,7319,-1,7319,6956,6955,-1,7282,7281,7320,-1,7320,7318,7282,-1,7321,7320,7281,-1,7281,7277,7321,-1,7276,7309,7321,-1,7321,7277,7276,-1,7322,7323,7324,-1,7324,7325,7322,-1,7326,7325,7324,-1,7324,7327,7326,-1,7328,7323,7322,-1,7322,7329,7328,-1,6958,6957,7322,-1,7322,7325,6958,-1,7326,7330,6958,-1,6958,7325,7326,-1,7331,7326,7327,-1,7327,7332,7331,-1,7329,7333,7334,-1,7334,7328,7329,-1,7334,7333,7335,-1,7335,7336,7334,-1,7329,7337,7338,-1,7338,7333,7329,-1,7339,7335,7333,-1,7333,7338,7339,-1,7338,7337,6987,-1,6987,6961,7338,-1,7337,7329,7322,-1,7322,6957,7337,-1,7340,7341,7342,-1,7342,6996,7340,-1,7332,7342,7341,-1,7341,7331,7332,-1,7343,7331,7341,-1,7341,7344,7343,-1,7345,7346,7347,-1,7347,7348,7345,-1,7310,7288,7272,-1,7272,6991,7310,-1,7347,7349,7350,-1,7350,7348,7347,-1,7351,7347,7346,-1,7346,6990,7351,-1,7352,7345,7348,-1,7348,7353,7352,-1,7354,7355,7352,-1,7352,7353,7354,-1,7350,7356,7353,-1,7353,7348,7350,-1,7354,7357,7358,-1,7358,7355,7354,-1,7359,7360,7358,-1,7358,7357,7359,-1,7361,7362,7360,-1,7360,7359,7361,-1,7363,7359,7357,-1,7357,7364,7363,-1,7357,7354,7365,-1,7365,7364,7357,-1,7366,7367,6947,-1,6947,6946,7366,-1,6776,7287,7317,-1,7317,7311,6776,-1,7367,7362,7361,-1,7361,6947,7367,-1,7363,7368,7361,-1,7361,7359,7363,-1,6990,6989,7301,-1,7301,7351,6990,-1,7369,7300,7270,-1,7270,7274,7369,-1,7290,7315,7274,-1,7274,7273,7290,-1,7335,7339,7370,-1,7370,7371,7335,-1,6961,6960,7339,-1,7339,7338,6961,-1,7372,7336,7335,-1,7335,7371,7372,-1,7370,7373,7374,-1,7374,7371,7370,-1,7374,7375,7372,-1,7372,7371,7374,-1,6950,7374,7373,-1,7373,6948,6950,-1,7373,7370,7376,-1,7376,7377,7373,-1,7341,7340,7378,-1,7378,7344,7341,-1,7379,7340,6996,-1,6996,6993,7379,-1,7340,7379,7380,-1,7380,7378,7340,-1,7381,7379,6993,-1,6993,7382,7381,-1,7379,7381,7383,-1,7383,7380,7379,-1,7384,7381,7382,-1,7382,7385,7384,-1,7381,7384,7386,-1,7386,7383,7381,-1,7385,7366,6946,-1,6946,7384,7385,-1,7299,6949,7312,-1,7312,7297,7299,-1,7312,6949,6948,-1,6948,6953,7312,-1,6950,7298,6741,-1,6741,7387,6950,-1,7375,7374,6950,-1,6950,7387,7375,-1,7388,7389,7377,-1,7377,7376,7388,-1,7370,7339,6960,-1,6960,7376,7370,-1,6948,7373,7377,-1,7377,6953,6948,-1,7303,7296,7314,-1,7314,7390,7303,-1,7391,7314,7313,-1,7313,6952,7391,-1,7313,7312,6953,-1,6953,6952,7313,-1,7392,7393,7304,-1,7304,7305,7392,-1,7393,7394,7306,-1,7306,7304,7393,-1,7392,7395,7396,-1,7396,7393,7392,-1,7397,7392,7305,-1,7305,7307,7397,-1,7392,7397,7398,-1,7398,7395,7392,-1,7399,7397,7307,-1,7307,7308,7399,-1,7397,7399,7400,-1,7400,7398,7397,-1,7401,7399,7308,-1,7308,6954,7401,-1,7402,7403,7300,-1,7300,7369,7402,-1,7274,7315,7404,-1,7404,7369,7274,-1,7394,7404,7315,-1,7315,7306,7394,-1,7405,7406,7404,-1,7404,7394,7405,-1,7405,7394,7393,-1,7393,7396,7405,-1,7356,7365,7354,-1,7354,7353,7356,-1,7401,6954,6956,-1,6956,6967,7401,-1,7302,7407,7319,-1,7319,7283,7302,-1,7407,7408,7409,-1,7409,7319,7407,-1,7407,7302,7303,-1,7303,7390,7407,-1,6947,7361,7368,-1,7368,6945,6947,-1,7368,7363,7410,-1,7410,7411,7368,-1,6946,6945,7386,-1,7386,7384,6946,-1,6980,6979,7386,-1,7386,6945,6980,-1,7386,6979,7412,-1,7412,7383,7386,-1,7330,7326,7331,-1,7331,7343,7330,-1,7404,7406,7402,-1,7402,7369,7404,-1,7349,7347,7351,-1,7351,7413,7349,-1,7314,7391,7414,-1,7414,7390,7314,-1,6951,7415,7391,-1,7391,6952,6951,-1,7377,7389,6951,-1,6951,6953,7377,-1,7414,7408,7407,-1,7407,7390,7414,-1,7409,6966,6956,-1,6956,7319,7409,-1,6945,7368,7411,-1,7411,6980,6945,-1,6959,6987,7337,-1,7337,6957,6959,-1,6984,6959,6958,-1,6958,7330,6984,-1,6984,6983,6986,-1,6986,6959,6984,-1,6985,6984,7330,-1,7330,7343,6985,-1,7378,7416,7417,-1,7417,7344,7378,-1,7343,7344,7417,-1,7417,6985,7343,-1,7224,6983,6985,-1,6985,7417,7224,-1,7268,7418,7419,-1,7419,7269,7268,-1,7376,6960,7248,-1,7248,7388,7376,-1,7388,7246,7420,-1,7420,7389,7388,-1,7420,7415,6951,-1,6951,7389,7420,-1,7227,7226,7420,-1,7420,7246,7227,-1,7248,7247,7246,-1,7246,7388,7248,-1,7396,7421,6964,-1,6964,7405,7396,-1,7422,7421,7396,-1,7396,7395,7422,-1,7421,7422,7212,-1,7212,7211,7421,-1,7398,7423,7422,-1,7422,7395,7398,-1,7422,7423,7213,-1,7213,7212,7422,-1,7400,7424,7423,-1,7423,7398,7400,-1,7399,7401,7425,-1,7425,7400,7399,-1,7423,7424,7214,-1,7214,7213,7423,-1,7425,6912,7424,-1,7424,7400,7425,-1,7425,7401,6967,-1,6967,6969,7425,-1,7301,7426,7413,-1,7413,7351,7301,-1,7300,7403,7418,-1,7418,7268,7300,-1,7418,7403,6971,-1,6971,6970,7418,-1,7403,7402,7427,-1,7427,6971,7403,-1,7210,6972,6971,-1,6971,7427,7210,-1,6963,7427,7402,-1,7402,7406,6963,-1,7406,7405,6964,-1,6964,6963,7406,-1,7413,6978,6977,-1,6977,7349,7413,-1,6973,6978,7413,-1,7413,7426,6973,-1,6975,6976,6978,-1,6978,6973,6975,-1,7419,6974,6973,-1,6973,7426,7419,-1,7426,7301,7269,-1,7269,7419,7426,-1,6970,6974,7419,-1,7419,7418,6970,-1,6972,6975,6974,-1,6974,6970,6972,-1,7225,6909,7202,-1,7202,7428,7225,-1,7429,7409,7202,-1,7202,7201,7429,-1,7202,7409,7408,-1,7408,7428,7202,-1,7414,7430,7428,-1,7428,7408,7414,-1,7429,7431,6966,-1,6966,7409,7429,-1,6966,7431,6968,-1,6968,6967,6966,-1,7207,7431,7429,-1,7429,7205,7207,-1,7203,7205,7429,-1,7429,7201,7203,-1,6968,7431,7207,-1,7207,7208,6968,-1,7414,7391,7415,-1,7415,7430,7414,-1,7424,6912,6911,-1,6911,7214,7424,-1,6912,7425,6969,-1,6969,6913,6912,-1,7415,7420,7226,-1,7226,7430,7415,-1,6969,6968,7208,-1,7208,6913,6969,-1,7210,7427,6963,-1,6963,6965,7210,-1,7421,7211,6965,-1,6965,6964,7421,-1,7432,6977,6976,-1,6976,6924,7432,-1,7349,6977,7432,-1,7432,7350,7349,-1,7433,7432,6924,-1,6924,6923,7433,-1,7432,7433,7356,-1,7356,7350,7432,-1,7356,7433,7434,-1,7434,7365,7356,-1,6923,6922,7434,-1,7434,7433,6923,-1,7216,7435,7434,-1,7434,6922,7216,-1,7434,7435,7364,-1,7364,7365,7434,-1,7410,7363,7364,-1,7364,7435,7410,-1,7216,7215,7410,-1,7410,7435,7216,-1,7215,6982,7411,-1,7411,7410,7215,-1,7383,7412,7436,-1,7436,7380,7383,-1,6979,6981,7218,-1,7218,7412,6979,-1,7380,7436,7416,-1,7416,7378,7380,-1,7218,7220,7436,-1,7436,7412,7218,-1,7220,7222,7416,-1,7416,7436,7220,-1,7222,7224,7417,-1,7417,7416,7222,-1,6982,6981,6980,-1,6980,7411,6982,-1,6917,6919,6982,-1,6982,7215,6917,-1,6961,6987,6986,-1,6986,6962,6961,-1,7225,7428,7430,-1,7430,7226,7225,-1,6962,6988,7248,-1,7248,6960,6962,-1,6983,7241,6988,-1,6988,6986,6983,-1,7224,7223,7241,-1,7241,6983,7224,-1,7218,6981,6919,-1,6919,6918,7218,-1,6991,6990,7346,-1,7346,7310,6991,-1,7310,7346,7345,-1,7345,7309,7310,-1,7309,7345,7352,-1,7352,7321,7309,-1,7321,7352,7355,-1,7355,7320,7321,-1,7320,7355,7358,-1,7358,7318,7320,-1,7318,7358,7360,-1,7360,7316,7318,-1,7316,7360,7362,-1,7362,7317,7316,-1,7317,7362,7367,-1,7367,7311,7317,-1,7311,7367,7366,-1,7366,7262,7311,-1,7262,7366,7385,-1,7385,7259,7262,-1,7259,7385,7382,-1,7382,7258,7259,-1,7258,7382,6993,-1,6993,6992,7258,-1,6994,6993,6996,-1,6996,6995,6994,-1,6997,6996,7342,-1,7342,7253,6997,-1,7253,7342,7332,-1,7332,7252,7253,-1,7252,7332,7327,-1,7327,7251,7252,-1,7251,7327,7324,-1,7324,7249,7251,-1,7249,7324,7323,-1,7323,7250,7249,-1,7250,7323,7328,-1,7328,7257,7250,-1,7257,7328,7334,-1,7334,7256,7257,-1,7256,7334,7336,-1,7336,7255,7256,-1,7255,7336,7372,-1,7372,7254,7255,-1,7254,7372,7375,-1,7375,7260,7254,-1,7260,7375,7387,-1,7387,7261,7260,-1,7261,7387,6741,-1,6741,6685,7261,-1,6775,6768,6804,-1,6804,7284,6775,-1,7284,6804,6795,-1,6795,7285,7284,-1,7285,6795,6794,-1,6794,7279,7285,-1,7279,6794,6789,-1,6789,7280,7279,-1,7280,6789,6785,-1,6785,7278,7280,-1,7278,6785,6786,-1,6786,7275,7278,-1,7275,6786,6788,-1,6788,6998,7275,-1,7437,7438,7439,-1,7440,7441,7442,-1,7443,7444,7445,-1,7446,7447,7448,-1,7449,7450,7451,-1,7452,7453,7454,-1,7453,7455,7454,-1,7456,7457,7458,-1,7457,7459,7458,-1,7460,7461,7462,-1,7461,7463,7462,-1,7464,7465,7466,-1,7467,7464,7106,-1,7468,7469,7470,-1,7471,7472,7473,-1,7474,7475,7476,-1,7477,7478,7479,-1,7480,7479,7481,-1,7482,7483,7484,-1,7485,7459,7486,-1,7487,7488,7489,-1,7490,7491,7492,-1,7493,7494,7495,-1,7484,7496,7497,-1,7489,7148,7161,-1,7498,7499,7500,-1,7069,7501,7070,-1,7502,7503,7500,-1,7470,7504,7505,-1,7506,7507,7508,-1,7507,7509,7510,-1,7511,7512,7455,-1,7513,7514,7515,-1,7516,7517,7518,-1,7465,7519,7520,-1,7521,7522,7523,-1,7524,7525,7526,-1,7527,7528,7529,-1,7530,7531,7532,-1,7533,7534,7535,-1,7536,7537,7538,-1,7539,7471,7540,-1,7541,7542,7543,-1,7544,7545,7546,-1,7547,7438,7437,-1,7437,7548,7547,-1,7437,7442,7549,-1,7549,7548,7437,-1,7547,7550,7551,-1,7551,7438,7547,-1,7549,7442,7441,-1,7441,7552,7549,-1,7442,7437,7537,-1,7537,7440,7442,-1,7552,7441,7553,-1,7553,7554,7552,-1,7554,7553,7555,-1,7555,7556,7554,-1,7553,7441,7440,-1,7440,7557,7553,-1,7558,7556,7555,-1,7555,7559,7558,-1,7555,7553,7557,-1,7557,7560,7555,-1,7561,7562,7563,-1,7563,7564,7561,-1,7565,7566,7564,-1,7564,7563,7565,-1,7563,7562,7545,-1,7545,7544,7563,-1,7567,7568,7562,-1,7562,7561,7567,-1,7569,7444,7443,-1,7443,7570,7569,-1,7443,7571,7572,-1,7572,7570,7443,-1,7573,7444,7569,-1,7569,7574,7573,-1,7447,7575,7576,-1,7576,7448,7447,-1,7577,7448,7576,-1,7576,7578,7577,-1,7579,7576,7575,-1,7575,7580,7579,-1,7581,7579,7580,-1,7580,7582,7581,-1,7576,7579,7583,-1,7583,7578,7576,-1,7571,7581,7582,-1,7582,7572,7571,-1,7584,7581,7571,-1,7571,7585,7584,-1,7571,7443,7445,-1,7445,7585,7571,-1,7444,7573,7586,-1,7586,7445,7444,-1,7574,7558,7559,-1,7559,7573,7574,-1,7587,7588,7589,-1,7589,7590,7587,-1,7551,7550,7590,-1,7590,7589,7551,-1,7589,7588,7591,-1,7591,7592,7589,-1,7566,7565,7588,-1,7588,7587,7566,-1,7545,7562,7568,-1,7568,7593,7545,-1,7568,7567,7447,-1,7447,7446,7568,-1,7560,7594,7559,-1,7559,7555,7560,-1,7594,7586,7573,-1,7573,7559,7594,-1,7524,7593,7568,-1,7568,7446,7524,-1,7439,7438,7551,-1,7551,7595,7439,-1,7589,7592,7595,-1,7595,7551,7589,-1,7544,7596,7565,-1,7565,7563,7544,-1,7584,7583,7579,-1,7579,7581,7584,-1,7446,7448,7577,-1,7577,7524,7446,-1,7565,7596,7591,-1,7591,7588,7565,-1,7597,7585,7445,-1,7445,7598,7597,-1,7599,7595,7592,-1,7592,7600,7599,-1,7595,7599,7538,-1,7538,7439,7595,-1,7601,7602,7578,-1,7578,7583,7601,-1,7603,7604,7605,-1,7605,7485,7603,-1,7605,7458,7459,-1,7459,7485,7605,-1,7605,7604,7606,-1,7606,7607,7605,-1,7603,7608,7609,-1,7609,7604,7603,-1,7610,7603,7485,-1,7485,7486,7610,-1,7450,7449,7510,-1,7510,7611,7450,-1,7510,7509,7612,-1,7612,7611,7510,-1,7449,7508,7507,-1,7507,7510,7449,-1,7452,7450,7611,-1,7611,7453,7452,-1,7450,7613,7614,-1,7614,7451,7450,-1,7508,7449,7451,-1,7451,7615,7508,-1,7454,7616,7617,-1,7617,7452,7454,-1,7457,7456,7460,-1,7460,7462,7457,-1,7618,7619,7456,-1,7456,7458,7618,-1,7620,7461,7460,-1,7460,7621,7620,-1,7622,7462,7463,-1,7463,7623,7622,-1,7623,7463,7461,-1,7461,7624,7623,-1,7457,7625,7486,-1,7486,7459,7457,-1,7467,7626,7465,-1,7465,7464,7467,-1,7519,7465,7626,-1,7626,7627,7519,-1,7467,7477,7628,-1,7628,7626,7467,-1,7068,7468,7501,-1,7501,7069,7068,-1,7470,7499,7501,-1,7501,7468,7470,-1,7498,7629,7501,-1,7501,7499,7498,-1,7470,7505,7500,-1,7500,7499,7470,-1,7630,7473,7472,-1,7472,7631,7630,-1,7632,7472,7471,-1,7471,7539,7632,-1,7633,7620,7471,-1,7471,7473,7633,-1,7633,7624,7461,-1,7461,7620,7633,-1,7634,7624,7633,-1,7633,7635,7634,-1,7633,7473,7630,-1,7630,7635,7633,-1,7636,7635,7630,-1,7630,7637,7636,-1,7472,7632,7638,-1,7638,7631,7472,-1,7639,7640,7631,-1,7631,7638,7639,-1,7641,7638,7632,-1,7632,7476,7641,-1,7539,7474,7476,-1,7476,7632,7539,-1,7540,7534,7474,-1,7474,7539,7540,-1,7631,7640,7637,-1,7637,7630,7631,-1,7642,7643,7637,-1,7637,7640,7642,-1,7636,7644,7634,-1,7634,7635,7636,-1,7634,7644,7645,-1,7645,7646,7634,-1,7644,7636,7647,-1,7647,7648,7644,-1,7636,7637,7643,-1,7643,7647,7636,-1,7647,7643,7649,-1,7649,7650,7647,-1,7640,7639,7480,-1,7480,7642,7640,-1,7481,7651,7642,-1,7642,7480,7481,-1,7479,7480,7639,-1,7639,7652,7479,-1,7638,7641,7652,-1,7652,7639,7638,-1,7653,7628,7652,-1,7652,7641,7653,-1,7077,7654,7655,-1,7655,7078,7077,-1,7655,7478,7082,-1,7082,7078,7655,-1,7082,7478,7477,-1,7477,7088,7082,-1,7478,7655,7481,-1,7481,7479,7478,-1,7654,7651,7481,-1,7481,7655,7654,-1,7651,7654,7656,-1,7656,7649,7651,-1,7654,7077,7083,-1,7083,7656,7654,-1,7091,7657,7656,-1,7656,7083,7091,-1,7088,7477,7467,-1,7467,7106,7088,-1,7656,7657,7650,-1,7650,7649,7656,-1,7658,7659,7650,-1,7650,7657,7658,-1,7091,7092,7658,-1,7658,7657,7091,-1,7658,7092,7098,-1,7098,7660,7658,-1,7650,7659,7648,-1,7648,7647,7650,-1,7659,7658,7660,-1,7660,7661,7659,-1,7121,7662,7660,-1,7660,7098,7121,-1,7663,7664,7665,-1,7665,7661,7663,-1,7648,7659,7661,-1,7661,7665,7648,-1,7645,7665,7664,-1,7664,7666,7645,-1,7667,7668,7664,-1,7664,7663,7667,-1,7660,7662,7663,-1,7663,7661,7660,-1,7669,7666,7664,-1,7664,7668,7669,-1,7669,7670,7671,-1,7671,7666,7669,-1,7668,7672,7673,-1,7673,7669,7668,-1,7674,7672,7668,-1,7668,7667,7674,-1,7675,7676,7672,-1,7672,7674,7675,-1,7677,7674,7667,-1,7667,7678,7677,-1,7667,7663,7662,-1,7662,7678,7667,-1,7113,7678,7662,-1,7662,7121,7113,-1,7608,7673,7672,-1,7672,7676,7608,-1,7608,7603,7610,-1,7610,7673,7608,-1,7482,7609,7608,-1,7608,7676,7482,-1,7675,7483,7482,-1,7482,7676,7675,-1,7679,7483,7675,-1,7675,7680,7679,-1,7675,7674,7677,-1,7677,7680,7675,-1,7115,7680,7677,-1,7677,7112,7115,-1,7670,7669,7673,-1,7673,7610,7670,-1,7486,7625,7670,-1,7670,7610,7486,-1,7606,7604,7609,-1,7609,7681,7606,-1,7666,7671,7646,-1,7646,7645,7666,-1,7623,7646,7671,-1,7671,7622,7623,-1,7625,7622,7671,-1,7671,7670,7625,-1,7625,7457,7462,-1,7462,7622,7625,-1,7649,7643,7642,-1,7642,7651,7649,-1,7682,7683,7488,-1,7488,7684,7682,-1,7685,7686,7684,-1,7684,7488,7685,-1,7488,7683,7687,-1,7687,7489,7488,-1,7683,7682,7688,-1,7688,7689,7683,-1,7684,7495,7494,-1,7494,7682,7684,-1,7615,7495,7684,-1,7684,7686,7615,-1,7615,7451,7493,-1,7493,7495,7615,-1,7508,7615,7686,-1,7686,7690,7508,-1,7685,7492,7690,-1,7690,7686,7685,-1,7492,7491,7691,-1,7691,7690,7492,-1,7492,7685,7692,-1,7692,7490,7492,-1,7488,7487,7692,-1,7692,7685,7488,-1,7152,7692,7487,-1,7487,7159,7152,-1,7508,7690,7691,-1,7691,7506,7508,-1,7693,7503,7691,-1,7691,7491,7693,-1,7152,7151,7490,-1,7490,7692,7152,-1,7694,7494,7493,-1,7493,7695,7694,-1,7696,7697,7695,-1,7695,7493,7696,-1,7494,7694,7688,-1,7688,7682,7494,-1,7698,7699,7694,-1,7694,7695,7698,-1,7700,7688,7694,-1,7694,7699,7700,-1,7688,7700,7701,-1,7701,7689,7688,-1,7702,7703,7689,-1,7689,7701,7702,-1,7701,7700,7704,-1,7704,7705,7701,-1,7683,7689,7703,-1,7703,7687,7683,-1,7127,7136,7687,-1,7687,7703,7127,-1,7107,7106,7464,-1,7464,7706,7107,-1,7706,7707,7108,-1,7108,7107,7706,-1,7678,7113,7112,-1,7112,7677,7678,-1,7115,7118,7679,-1,7679,7680,7115,-1,7143,7496,7679,-1,7679,7118,7143,-1,7128,7127,7703,-1,7703,7702,7128,-1,7128,7702,7497,-1,7497,7135,7128,-1,7705,7497,7702,-1,7702,7701,7705,-1,7687,7136,7148,-1,7148,7489,7687,-1,7497,7496,7143,-1,7143,7135,7497,-1,7484,7497,7705,-1,7705,7681,7484,-1,7151,7155,7708,-1,7708,7490,7151,-1,7693,7491,7490,-1,7490,7708,7693,-1,7708,7155,7171,-1,7171,7629,7708,-1,7159,7487,7489,-1,7489,7161,7159,-1,7629,7498,7693,-1,7693,7708,7629,-1,7501,7629,7171,-1,7171,7070,7501,-1,7498,7500,7503,-1,7503,7693,7498,-1,7500,7505,7709,-1,7709,7502,7500,-1,7691,7503,7502,-1,7502,7506,7691,-1,7509,7507,7506,-1,7506,7502,7509,-1,7618,7458,7605,-1,7605,7607,7618,-1,7704,7700,7699,-1,7699,7710,7704,-1,7704,7606,7681,-1,7681,7705,7704,-1,7606,7704,7710,-1,7710,7607,7606,-1,7698,7711,7710,-1,7710,7699,7698,-1,7711,7618,7607,-1,7607,7710,7711,-1,7698,7712,7713,-1,7713,7711,7698,-1,7679,7496,7484,-1,7484,7483,7679,-1,7609,7482,7484,-1,7484,7681,7609,-1,7714,7715,7716,-1,7716,7717,7714,-1,7716,7718,7719,-1,7719,7717,7716,-1,7720,7721,7716,-1,7716,7715,7720,-1,7715,7714,7722,-1,7722,7616,7715,-1,7723,7714,7717,-1,7717,7724,7723,-1,7724,7717,7719,-1,7719,7725,7724,-1,7726,7727,7719,-1,7719,7718,7726,-1,7721,7728,7718,-1,7718,7716,7721,-1,7718,7728,7729,-1,7729,7726,7718,-1,7730,7731,7728,-1,7728,7721,7730,-1,7714,7723,7732,-1,7732,7722,7714,-1,7733,7723,7724,-1,7724,7734,7733,-1,7725,7735,7734,-1,7734,7724,7725,-1,7734,7735,7515,-1,7515,7736,7734,-1,7737,7735,7725,-1,7725,7738,7737,-1,7727,7738,7725,-1,7725,7719,7727,-1,7722,7732,7739,-1,7739,7740,7722,-1,7723,7733,7741,-1,7741,7732,7723,-1,7742,7739,7732,-1,7732,7741,7742,-1,7733,7743,7744,-1,7744,7741,7733,-1,7616,7454,7720,-1,7720,7715,7616,-1,7720,7454,7455,-1,7455,7512,7720,-1,7730,7721,7720,-1,7720,7512,7730,-1,7729,7728,7731,-1,7731,7745,7729,-1,7730,7746,7747,-1,7747,7731,7730,-1,7727,7707,7706,-1,7706,7738,7727,-1,7727,7726,7748,-1,7748,7707,7727,-1,7707,7748,7110,-1,7110,7108,7707,-1,7729,7749,7748,-1,7748,7726,7729,-1,7469,7745,7731,-1,7731,7747,7469,-1,7745,7750,7749,-1,7749,7729,7745,-1,7748,7749,7185,-1,7185,7110,7748,-1,7750,7071,7185,-1,7185,7749,7750,-1,7468,7068,7071,-1,7071,7750,7468,-1,7734,7736,7743,-1,7743,7733,7734,-1,7744,7751,7742,-1,7742,7741,7744,-1,7743,7752,7753,-1,7753,7744,7743,-1,7754,7736,7515,-1,7515,7514,7754,-1,7515,7735,7737,-1,7737,7513,7515,-1,7736,7754,7752,-1,7752,7743,7736,-1,7754,7755,7756,-1,7756,7752,7754,-1,7514,7757,7755,-1,7755,7754,7514,-1,7758,7755,7757,-1,7757,7520,7758,-1,7514,7513,7466,-1,7466,7757,7514,-1,7752,7756,7759,-1,7759,7753,7752,-1,7753,7759,7760,-1,7760,7761,7753,-1,7762,7763,7759,-1,7759,7756,7762,-1,7758,7762,7756,-1,7756,7755,7758,-1,7758,7516,7518,-1,7518,7762,7758,-1,7762,7518,7533,-1,7533,7763,7762,-1,7519,7516,7758,-1,7758,7520,7519,-1,7465,7520,7757,-1,7757,7466,7465,-1,7737,7738,7706,-1,7706,7464,7737,-1,7466,7513,7737,-1,7737,7464,7466,-1,7475,7474,7518,-1,7518,7517,7475,-1,7627,7517,7516,-1,7516,7519,7627,-1,7476,7475,7653,-1,7653,7641,7476,-1,7475,7517,7627,-1,7627,7653,7475,-1,7626,7628,7653,-1,7653,7627,7626,-1,7479,7652,7628,-1,7628,7477,7479,-1,7509,7502,7709,-1,7709,7612,7509,-1,7505,7504,7764,-1,7764,7709,7505,-1,7709,7764,7765,-1,7765,7612,7709,-1,7764,7504,7747,-1,7747,7746,7764,-1,7504,7470,7469,-1,7469,7747,7504,-1,7612,7765,7453,-1,7453,7611,7612,-1,7746,7511,7765,-1,7765,7764,7746,-1,7468,7750,7745,-1,7745,7469,7468,-1,7645,7644,7648,-1,7648,7665,7645,-1,7623,7624,7634,-1,7634,7646,7623,-1,7511,7455,7453,-1,7453,7765,7511,-1,7512,7511,7746,-1,7746,7730,7512,-1,7618,7711,7713,-1,7713,7619,7618,-1,7445,7586,7766,-1,7766,7598,7445,-1,7584,7585,7597,-1,7597,7767,7584,-1,7768,7597,7598,-1,7598,7769,7768,-1,7598,7766,7770,-1,7770,7769,7598,-1,7768,7771,7767,-1,7767,7597,7768,-1,7772,7768,7769,-1,7769,7773,7772,-1,7773,7769,7770,-1,7770,7774,7773,-1,7771,7768,7772,-1,7772,7775,7771,-1,7613,7772,7773,-1,7773,7614,7613,-1,7601,7583,7584,-1,7584,7767,7601,-1,7601,7767,7771,-1,7771,7776,7601,-1,7776,7777,7602,-1,7602,7601,7776,-1,7778,7779,7602,-1,7602,7777,7778,-1,7523,7522,7777,-1,7777,7776,7523,-1,7780,7778,7777,-1,7777,7522,7780,-1,7776,7771,7775,-1,7775,7523,7776,-1,7779,7577,7578,-1,7578,7602,7779,-1,7524,7577,7779,-1,7779,7525,7524,-1,7778,7781,7525,-1,7525,7779,7778,-1,7780,7782,7781,-1,7781,7778,7780,-1,7739,7780,7522,-1,7522,7740,7739,-1,7783,7526,7525,-1,7525,7781,7783,-1,7784,7526,7783,-1,7783,7785,7784,-1,7786,7783,7781,-1,7781,7782,7786,-1,7785,7783,7786,-1,7786,7787,7785,-1,7751,7786,7782,-1,7782,7742,7751,-1,7782,7780,7739,-1,7739,7742,7782,-1,7787,7786,7751,-1,7751,7761,7787,-1,7761,7751,7744,-1,7744,7753,7761,-1,7614,7773,7774,-1,7774,7696,7614,-1,7775,7772,7613,-1,7613,7788,7775,-1,7451,7614,7696,-1,7696,7493,7451,-1,7788,7613,7450,-1,7450,7452,7788,-1,7740,7617,7616,-1,7616,7722,7740,-1,7617,7740,7522,-1,7522,7521,7617,-1,7521,7788,7452,-1,7452,7617,7521,-1,7789,7529,7528,-1,7528,7530,7789,-1,7790,7531,7530,-1,7530,7528,7790,-1,7789,7591,7596,-1,7596,7529,7789,-1,7600,7789,7530,-1,7530,7532,7600,-1,7791,7531,7790,-1,7790,7792,7791,-1,7793,7790,7528,-1,7528,7527,7793,-1,7790,7793,7794,-1,7794,7792,7790,-1,7792,7794,7534,-1,7534,7540,7792,-1,7541,7543,7794,-1,7794,7793,7541,-1,7794,7543,7535,-1,7535,7534,7794,-1,7795,7535,7543,-1,7543,7542,7795,-1,7796,7599,7600,-1,7600,7532,7796,-1,7536,7538,7599,-1,7599,7796,7536,-1,7796,7532,7531,-1,7531,7797,7796,-1,7791,7798,7797,-1,7797,7531,7791,-1,7799,7536,7796,-1,7796,7797,7799,-1,7621,7791,7792,-1,7792,7540,7621,-1,7621,7460,7798,-1,7798,7791,7621,-1,7620,7621,7540,-1,7540,7471,7620,-1,7799,7800,7801,-1,7801,7536,7799,-1,7802,7799,7797,-1,7797,7798,7802,-1,7803,7800,7799,-1,7799,7802,7803,-1,7456,7802,7798,-1,7798,7460,7456,-1,7619,7803,7802,-1,7802,7456,7619,-1,7804,7594,7560,-1,7560,7805,7804,-1,7560,7557,7806,-1,7806,7805,7560,-1,7586,7594,7804,-1,7804,7766,7586,-1,7807,7804,7805,-1,7805,7808,7807,-1,7808,7805,7806,-1,7806,7809,7808,-1,7807,7770,7766,-1,7766,7804,7807,-1,7810,7807,7808,-1,7808,7811,7810,-1,7811,7808,7809,-1,7809,7812,7811,-1,7770,7807,7810,-1,7810,7774,7770,-1,7697,7810,7811,-1,7811,7712,7697,-1,7712,7811,7812,-1,7812,7713,7712,-1,7774,7810,7697,-1,7697,7696,7774,-1,7695,7697,7712,-1,7712,7698,7695,-1,7593,7524,7526,-1,7526,7784,7593,-1,7813,7545,7593,-1,7593,7784,7813,-1,7785,7814,7813,-1,7813,7784,7785,-1,7787,7815,7814,-1,7814,7785,7787,-1,7761,7760,7815,-1,7815,7787,7761,-1,7529,7546,7816,-1,7816,7527,7529,-1,7527,7816,7541,-1,7541,7793,7527,-1,7813,7816,7546,-1,7546,7545,7813,-1,7546,7529,7596,-1,7596,7544,7546,-1,7541,7816,7813,-1,7813,7814,7541,-1,7542,7541,7814,-1,7814,7815,7542,-1,7795,7542,7815,-1,7815,7760,7795,-1,7763,7795,7760,-1,7760,7759,7763,-1,7763,7533,7535,-1,7535,7795,7763,-1,7474,7534,7533,-1,7533,7518,7474,-1,7537,7437,7439,-1,7439,7538,7537,-1,7440,7537,7536,-1,7536,7801,7440,-1,7803,7812,7809,-1,7809,7800,7803,-1,7619,7713,7812,-1,7812,7803,7619,-1,7806,7557,7440,-1,7440,7801,7806,-1,7806,7801,7800,-1,7800,7809,7806,-1,7523,7775,7788,-1,7788,7521,7523,-1,7600,7592,7591,-1,7591,7789,7600,-1,7817,7818,7819,-1,7820,7821,7822,-1,7823,7824,7820,-1,7825,7826,7827,-1,7823,7826,7828,-1,7827,7829,7830,-1,7831,7832,7830,-1,7833,7834,7835,-1,7836,7834,7833,-1,7837,7838,7839,-1,7829,7840,7841,-1,7842,7843,7844,-1,7845,7846,7847,-1,7848,7849,7556,-1,7850,7851,7852,-1,7853,7854,7834,-1,7855,7856,7857,-1,7858,7859,7860,-1,7858,7860,7861,-1,7862,7863,7864,-1,7850,7865,7851,-1,7866,7867,7868,-1,7869,7870,7871,-1,7872,7873,7822,-1,7874,7875,7876,-1,7877,7878,7879,-1,7880,7881,7882,-1,7883,7884,7885,-1,7886,7887,7888,-1,7889,7888,7887,-1,7890,7891,7892,-1,7893,7894,7895,-1,7896,7897,7898,-1,7899,7900,7901,-1,7902,7903,7904,-1,7905,7906,7907,-1,7908,7909,7893,-1,7902,7910,7903,-1,7911,7912,7913,-1,7914,7889,7913,-1,7912,7914,7913,-1,7915,7916,7917,-1,7918,7919,7920,-1,7921,7922,7923,-1,7924,7570,7572,-1,7925,7926,7927,-1,7928,7929,7930,-1,7931,7932,7933,-1,7934,7935,7936,-1,7855,7937,7856,-1,7937,7938,7856,-1,7558,7574,7921,-1,7574,7569,7939,-1,7940,7941,7942,-1,7940,7882,7941,-1,7943,7944,7945,-1,7946,7947,7948,-1,7949,7950,7951,-1,7952,7953,7954,-1,7955,7956,7957,-1,7828,7838,7958,-1,7959,7960,7961,-1,7962,7963,7964,-1,7965,7966,7967,-1,7968,7969,7970,-1,7971,7972,7973,-1,7973,7974,7971,-1,7875,7874,7821,-1,7821,7820,7875,-1,7821,7975,7872,-1,7872,7822,7821,-1,7822,7976,7823,-1,7823,7820,7822,-1,7976,7822,7873,-1,7873,7840,7976,-1,7976,7827,7826,-1,7826,7823,7976,-1,7827,7976,7840,-1,7840,7829,7827,-1,7826,7825,7838,-1,7838,7828,7826,-1,7827,7830,7832,-1,7832,7825,7827,-1,7839,7838,7825,-1,7825,7832,7839,-1,7824,7823,7828,-1,7828,7958,7824,-1,7875,7820,7824,-1,7824,7977,7875,-1,7833,7835,7978,-1,7978,7859,7833,-1,7979,7834,7836,-1,7836,7980,7979,-1,7981,7836,7833,-1,7833,7859,7981,-1,7857,7854,7853,-1,7853,7855,7857,-1,7982,7983,7837,-1,7837,7839,7982,-1,7951,7983,7982,-1,7982,7949,7951,-1,7983,7984,7985,-1,7985,7837,7983,-1,7982,7839,7986,-1,7986,7987,7982,-1,7951,7988,7984,-1,7984,7983,7951,-1,7989,7985,7984,-1,7984,7990,7989,-1,7837,7985,7958,-1,7958,7838,7837,-1,7831,7986,7839,-1,7839,7832,7831,-1,7991,7831,7830,-1,7830,7992,7991,-1,7993,7994,7841,-1,7841,7840,7993,-1,7829,7841,7992,-1,7992,7830,7829,-1,7995,7996,7994,-1,7994,7993,7995,-1,7994,7942,7992,-1,7992,7841,7994,-1,7993,7840,7873,-1,7873,7997,7993,-1,7996,7940,7942,-1,7942,7994,7996,-1,7991,7992,7942,-1,7942,7941,7991,-1,7998,7999,7547,-1,7547,7548,7998,-1,8000,8001,8002,-1,8002,8003,8000,-1,8004,8005,8002,-1,8002,8001,8004,-1,8006,8007,8000,-1,8000,8003,8006,-1,8008,8009,7843,-1,7843,7842,8008,-1,8010,8011,7844,-1,7844,7843,8010,-1,7842,7844,8012,-1,8012,7846,7842,-1,8013,7845,7847,-1,7847,8014,8013,-1,7845,8013,8015,-1,8015,8016,7845,-1,7847,8017,8018,-1,8018,8014,7847,-1,7845,8016,8019,-1,8019,7846,7845,-1,8017,7847,7846,-1,7846,8012,8017,-1,7957,7925,8020,-1,8020,8021,7957,-1,7956,7926,7925,-1,7925,7957,7956,-1,8022,8020,7925,-1,7925,7927,8022,-1,8021,8020,8023,-1,8023,8024,8021,-1,7955,7957,8021,-1,8021,8025,7955,-1,8026,8027,8028,-1,8028,8029,8026,-1,8027,8026,8030,-1,8030,8031,8027,-1,8032,8028,8027,-1,8027,8033,8032,-1,8029,8028,8034,-1,8034,8024,8029,-1,8029,8035,8036,-1,8036,8026,8029,-1,8037,8034,8028,-1,8028,8032,8037,-1,8025,8021,8024,-1,8024,8034,8025,-1,8023,8035,8029,-1,8029,8024,8023,-1,8020,8022,8038,-1,8038,8023,8020,-1,8039,8040,7849,-1,7849,7848,8039,-1,8041,8040,8039,-1,8039,8042,8041,-1,8043,8044,7849,-1,7849,8040,8043,-1,8039,7848,7921,-1,7921,7923,8039,-1,8045,7998,7548,-1,7548,7549,8045,-1,8022,7998,8045,-1,8045,8038,8022,-1,8045,7549,7552,-1,7552,8046,8045,-1,8046,7552,7554,-1,7554,8044,8046,-1,8044,7554,7556,-1,7556,7849,8044,-1,7848,7556,7558,-1,7558,7921,7848,-1,8018,8017,7855,-1,7855,7853,8018,-1,7853,7834,7979,-1,7979,8018,7853,-1,7858,8047,7981,-1,7981,7859,7858,-1,8048,7860,7859,-1,7859,7978,8048,-1,7860,7954,7953,-1,7953,7861,7860,-1,8047,7858,7861,-1,7861,8049,8047,-1,7851,8050,8051,-1,8051,7852,7851,-1,7851,7865,8052,-1,8052,8050,7851,-1,8050,8053,8054,-1,8054,8051,8050,-1,8055,8053,8050,-1,8050,8052,8055,-1,7862,8054,8053,-1,8053,7863,7862,-1,8053,8055,7952,-1,7952,7863,8053,-1,7863,7952,7954,-1,7954,7864,7863,-1,7864,7954,7860,-1,7860,8048,7864,-1,8056,8057,8007,-1,8007,8006,8056,-1,7817,7866,7868,-1,7868,8058,7817,-1,7912,7866,7817,-1,7817,7819,7912,-1,8058,7868,7935,-1,7935,7969,8058,-1,8059,8057,8056,-1,8056,8060,8059,-1,8047,8049,7871,-1,7871,7870,8047,-1,8061,7871,8049,-1,8049,8062,8061,-1,8063,7997,7873,-1,7873,7872,8063,-1,7997,8063,7947,-1,7947,7946,7997,-1,8064,8063,7872,-1,7872,7975,8064,-1,7821,7874,8065,-1,8065,7975,7821,-1,8065,7874,7876,-1,7876,8009,8065,-1,7975,8065,8066,-1,8066,8064,7975,-1,8066,8065,8067,-1,8067,8068,8066,-1,8069,8070,8064,-1,8064,8066,8069,-1,7824,7958,8071,-1,8071,8072,7824,-1,8071,7958,7985,-1,7985,7989,8071,-1,8072,8071,7878,-1,7878,7877,8072,-1,8073,7977,7824,-1,7824,8072,8073,-1,7878,8071,7989,-1,7989,8074,7878,-1,7877,8075,8073,-1,8073,8072,7877,-1,7879,7878,7561,-1,7561,7564,7879,-1,7877,7879,8076,-1,8076,8075,7877,-1,7561,7878,8074,-1,8074,7567,7561,-1,7879,7564,7566,-1,7566,8076,7879,-1,7912,7819,8077,-1,8077,7914,7912,-1,7911,7867,7866,-1,7866,7912,7911,-1,7882,7881,7928,-1,7928,7930,7882,-1,7934,7880,7882,-1,7882,7940,7934,-1,7880,7934,7936,-1,7936,8078,7880,-1,7884,7883,8079,-1,8079,8080,7884,-1,7884,8081,8082,-1,8082,7885,7884,-1,7885,8083,8084,-1,8084,7883,7885,-1,8085,7886,7888,-1,7888,8086,8085,-1,7885,8082,8087,-1,8087,8088,7885,-1,8082,8089,8037,-1,8037,8087,8082,-1,8090,8088,8087,-1,8087,8091,8090,-1,8083,7885,8088,-1,8088,8092,8083,-1,8090,8093,8092,-1,8092,8088,8090,-1,8094,7953,8093,-1,8093,8090,8094,-1,8093,8055,8052,-1,8052,8092,8093,-1,8095,7861,7953,-1,7953,8094,8095,-1,7952,8055,8093,-1,8093,7953,7952,-1,8090,8091,8096,-1,8096,8094,8090,-1,8062,8049,7861,-1,7861,8095,8062,-1,8094,8096,8097,-1,8097,8095,8094,-1,8095,8097,8098,-1,8098,8062,8095,-1,8099,8100,7871,-1,7871,8061,8099,-1,8062,8098,7897,-1,7897,8061,8062,-1,7891,7890,8100,-1,8100,8099,7891,-1,7869,7871,8100,-1,8100,8101,7869,-1,7897,7896,8099,-1,8099,8061,7897,-1,8102,8101,8100,-1,8100,7890,8102,-1,8103,7891,8099,-1,8099,7896,8103,-1,7888,7889,7892,-1,7892,7891,7888,-1,7889,7914,8077,-1,8077,7892,7889,-1,8103,8086,7888,-1,7888,7891,8103,-1,8098,8104,8105,-1,8105,7897,8098,-1,8097,8106,8104,-1,8104,8098,8097,-1,8107,7967,8105,-1,8105,8104,8107,-1,8108,7898,7897,-1,7897,8105,8108,-1,8086,7895,8109,-1,8109,8085,8086,-1,8086,8103,7893,-1,7893,7895,8086,-1,7895,7894,7906,-1,7906,8109,7895,-1,8109,8110,8111,-1,8111,8085,8109,-1,8103,7896,7898,-1,7898,7893,8103,-1,7893,7898,8108,-1,8108,7908,7893,-1,8112,8113,7901,-1,7901,7900,8112,-1,8112,8114,8115,-1,8115,8113,8112,-1,8113,8116,8117,-1,8117,7901,8113,-1,7933,8118,8112,-1,8112,7900,7933,-1,8113,8115,8119,-1,8119,8116,8113,-1,8120,8111,8117,-1,8117,8116,8120,-1,7904,7899,7901,-1,7901,8117,7904,-1,8110,7904,8117,-1,8117,8111,8110,-1,8110,7905,7902,-1,7902,7904,8110,-1,8109,7906,7905,-1,7905,8110,8109,-1,7886,8085,8111,-1,8111,8120,7886,-1,8121,8122,8123,-1,8123,8124,8121,-1,8121,8125,8126,-1,8126,8122,8121,-1,8127,8128,8123,-1,8123,8122,8127,-1,8124,8123,8129,-1,8129,8130,8124,-1,7965,8131,8121,-1,8121,8124,7965,-1,7905,7907,7910,-1,7910,7902,7905,-1,8128,8132,8129,-1,8129,8123,8128,-1,7908,8130,8129,-1,8129,7909,7908,-1,8130,7966,7965,-1,7965,8124,8130,-1,7908,8108,7966,-1,7966,8130,7908,-1,7966,8108,8105,-1,8105,7967,7966,-1,7906,7894,7917,-1,7917,7916,7906,-1,7904,7903,8133,-1,8133,7899,7904,-1,8133,7903,8134,-1,8134,8135,8133,-1,8136,7900,7899,-1,7899,8133,8136,-1,7909,7917,7894,-1,7894,7893,7909,-1,8137,7974,7973,-1,7973,8138,8137,-1,8134,7903,7910,-1,7910,8139,8134,-1,8139,7910,8140,-1,8140,8141,8139,-1,8139,8138,7973,-1,7973,8134,8139,-1,7916,8142,7907,-1,7907,7906,7916,-1,8142,8140,7910,-1,7910,7907,8142,-1,8143,7951,7950,-1,7950,8144,8143,-1,8145,7950,7949,-1,7949,8146,8145,-1,8147,8140,8142,-1,8142,8148,8147,-1,8126,8125,7920,-1,7920,7919,8126,-1,8125,7923,7922,-1,7922,7920,8125,-1,8149,8150,8126,-1,8126,7919,8149,-1,8131,7923,8125,-1,8125,8121,8131,-1,7939,7918,7920,-1,7920,7922,7939,-1,8151,8152,8153,-1,8153,8154,8151,-1,7919,8152,8151,-1,8151,8149,7919,-1,8152,8155,7924,-1,7924,8153,8152,-1,8153,8156,8157,-1,8157,8154,8153,-1,7918,8155,8152,-1,8152,7919,7918,-1,8155,7569,7570,-1,7570,7924,8155,-1,7572,8156,8153,-1,8153,7924,7572,-1,8155,7918,7939,-1,7939,7569,8155,-1,7865,8083,8092,-1,8092,8052,7865,-1,7865,7850,8084,-1,8084,8083,7865,-1,8081,8158,8089,-1,8089,8082,8081,-1,8089,8025,8034,-1,8034,8037,8089,-1,8087,8037,8032,-1,8032,8091,8087,-1,8025,8089,8158,-1,8158,7955,8025,-1,8023,8038,8159,-1,8159,8035,8023,-1,8022,7927,7999,-1,7999,7998,8022,-1,8038,8045,8046,-1,8046,8159,8038,-1,7999,7927,7926,-1,7926,8160,7999,-1,7962,7964,8160,-1,8160,7926,7962,-1,8160,7550,7547,-1,7547,7999,8160,-1,7916,7915,8148,-1,8148,8142,7916,-1,7973,7972,8135,-1,8135,8134,7973,-1,8135,8161,8136,-1,8136,8133,8135,-1,7930,7929,7933,-1,7933,7932,7930,-1,8118,7933,7929,-1,7929,8162,8118,-1,7932,7941,7882,-1,7882,7930,7932,-1,7934,7970,7969,-1,7969,7935,7934,-1,8012,7937,7855,-1,7855,8017,8012,-1,7937,8011,8163,-1,8163,7938,7937,-1,8031,8030,8164,-1,8164,8107,8031,-1,8030,8041,8042,-1,8042,8164,8030,-1,7967,8107,8164,-1,8164,7965,7967,-1,8106,8031,8107,-1,8107,8104,8106,-1,8030,8026,8036,-1,8036,8041,8030,-1,8164,8042,8131,-1,8131,7965,8164,-1,8036,8043,8040,-1,8040,8041,8036,-1,8042,8039,7923,-1,7923,8131,8042,-1,7939,7922,7921,-1,7921,7574,7939,-1,8165,8166,8167,-1,8167,8168,8165,-1,8168,8016,8015,-1,8015,8165,8168,-1,8019,8016,8168,-1,8168,8169,8019,-1,8019,8008,7842,-1,7842,7846,8019,-1,8019,8169,8170,-1,8170,8008,8019,-1,8169,8171,8068,-1,8068,8170,8169,-1,8172,8009,8008,-1,8008,8170,8172,-1,7915,8173,8174,-1,8174,8148,7915,-1,8173,7915,7917,-1,7917,8132,8173,-1,8132,8128,8175,-1,8175,8173,8132,-1,8005,8004,7869,-1,7869,8101,8005,-1,7890,7892,8077,-1,8077,8102,7890,-1,7996,7995,7968,-1,7968,7970,7996,-1,7995,7993,7943,-1,7943,7945,7995,-1,7996,7970,7934,-1,7934,7940,7996,-1,7943,7946,7948,-1,7948,7944,7943,-1,8176,7945,7944,-1,7944,8177,8176,-1,7993,7997,7946,-1,7946,7943,7993,-1,8177,7944,7948,-1,7948,8178,8177,-1,7948,7947,8179,-1,8179,8178,7948,-1,7968,7995,7945,-1,7945,8176,7968,-1,8171,8169,8168,-1,8168,8167,8171,-1,8180,8069,8171,-1,8171,8167,8180,-1,8166,8181,8180,-1,8180,8167,8166,-1,8067,8172,8170,-1,8170,8068,8067,-1,8065,8009,8172,-1,8172,8067,8065,-1,7932,8182,7991,-1,7991,7941,7932,-1,7991,8182,7986,-1,7986,7831,7991,-1,8183,7988,7951,-1,7951,8143,8183,-1,7987,7986,8182,-1,8182,8184,7987,-1,7949,7982,7987,-1,7987,8146,7949,-1,8180,8181,8057,-1,8057,8059,8180,-1,8070,8059,8060,-1,8060,8185,8070,-1,8180,8059,8070,-1,8070,8069,8180,-1,8084,8186,8079,-1,8079,7883,8084,-1,8080,8079,8010,-1,8010,7959,8080,-1,8080,8187,8081,-1,8081,7884,8080,-1,7850,8188,8186,-1,8186,8084,7850,-1,8186,8189,8190,-1,8190,8079,8186,-1,8163,8191,8190,-1,8190,8189,8163,-1,8190,8191,8010,-1,8010,8079,8190,-1,8189,8192,7938,-1,7938,8163,8189,-1,7844,8011,7937,-1,7937,8012,7844,-1,8163,8011,8010,-1,8010,8191,8163,-1,8132,7917,7909,-1,7909,8129,8132,-1,8145,8146,7972,-1,7972,7971,8145,-1,8135,7972,8146,-1,8146,8161,8135,-1,7987,8184,8161,-1,8161,8146,7987,-1,8193,7990,7984,-1,7984,7988,8193,-1,8194,8195,7990,-1,7990,8193,8194,-1,8193,7988,8183,-1,8183,8196,8193,-1,8194,7575,7447,-1,7447,8195,8194,-1,8074,7989,7990,-1,7990,8195,8074,-1,8193,8196,8197,-1,8197,8194,8193,-1,7575,8194,8197,-1,8197,7580,7575,-1,7567,8074,8195,-1,8195,7447,7567,-1,7582,7580,8197,-1,8197,8198,7582,-1,8198,8197,8196,-1,8196,8199,8198,-1,8156,8198,8199,-1,8199,8157,8156,-1,7572,7582,8198,-1,8198,8156,7572,-1,7960,7843,8009,-1,8009,7876,7960,-1,7959,8010,7843,-1,7843,7960,7959,-1,7961,7960,7876,-1,7876,7875,7961,-1,8200,8201,7977,-1,7977,8073,8200,-1,7956,8202,8201,-1,8201,8200,7956,-1,8201,7961,7875,-1,7875,7977,8201,-1,8073,8075,7962,-1,7962,8200,8073,-1,8202,7956,7955,-1,7955,8158,8202,-1,8202,8187,7961,-1,7961,8201,8202,-1,8187,8202,8158,-1,8158,8081,8187,-1,8136,8161,8184,-1,8184,7931,8136,-1,8069,8066,8068,-1,8068,8171,8069,-1,8064,8070,8185,-1,8185,8063,8064,-1,8182,7932,7931,-1,7931,8184,8182,-1,7964,7963,7587,-1,7587,7590,7964,-1,7566,7587,7963,-1,7963,8076,7566,-1,7550,8160,7964,-1,7964,7590,7550,-1,8076,7963,7962,-1,7962,8075,8076,-1,7926,7956,8200,-1,8200,7962,7926,-1,8033,8027,8031,-1,8031,8106,8033,-1,8150,8127,8122,-1,8122,8126,8150,-1,8091,8032,8033,-1,8033,8096,8091,-1,8096,8033,8106,-1,8106,8097,8096,-1,8035,8159,8043,-1,8043,8036,8035,-1,8159,8046,8044,-1,8044,8043,8159,-1,7933,7900,8136,-1,8136,7931,7933,-1,8187,8080,7959,-1,7959,7961,8187,-1,8063,8185,8179,-1,8179,7947,8063,-1,8185,8060,8203,-1,8203,8179,8185,-1,7971,7974,8204,-1,8204,8205,8206,-1,8207,8208,8209,-1,8209,8210,8207,-1,8211,8212,8213,-1,8211,8213,8214,-1,8215,8206,8216,-1,8206,8217,8216,-1,8216,8218,8215,-1,8215,8218,8219,-1,8220,8221,8205,-1,8137,8222,7974,-1,8144,8223,8224,-1,8144,8224,8143,-1,8225,8226,8227,-1,8228,8229,8226,-1,8228,8226,8230,-1,8220,8231,8230,-1,8232,8233,8234,-1,8235,8236,8237,-1,8236,8238,8237,-1,8237,8239,8240,-1,8241,8242,8199,-1,8205,8204,7974,-1,7974,8222,8205,-1,8204,8219,8243,-1,8243,7971,8204,-1,8205,8221,8217,-1,8217,8206,8205,-1,8215,8219,8204,-1,8204,8206,8215,-1,8207,8232,8244,-1,8244,8208,8207,-1,8214,8213,8209,-1,8209,8208,8214,-1,8245,8212,8211,-1,8211,8246,8245,-1,8211,8214,8247,-1,8247,8246,8211,-1,8248,8218,8245,-1,8245,8246,8248,-1,8245,8218,8216,-1,8216,8249,8245,-1,8137,8250,8231,-1,8231,8222,8137,-1,8240,8225,8251,-1,8251,8252,8240,-1,8239,8253,8225,-1,8225,8240,8239,-1,8227,8254,8251,-1,8251,8225,8227,-1,8252,8251,8255,-1,8255,8256,8252,-1,8252,8235,8237,-1,8237,8240,8252,-1,8144,7950,8145,-1,8145,8223,8144,-1,8243,8248,8224,-1,8224,8223,8243,-1,7971,8243,8223,-1,8223,8145,7971,-1,8227,8226,8229,-1,8229,8257,8227,-1,8229,8258,8141,-1,8141,8257,8229,-1,8254,8227,8257,-1,8257,8147,8254,-1,8225,8253,8259,-1,8259,8226,8225,-1,8258,8229,8228,-1,8228,8250,8258,-1,8138,8258,8250,-1,8250,8137,8138,-1,8258,8138,8139,-1,8139,8141,8258,-1,8250,8228,8230,-1,8230,8231,8250,-1,8141,8140,8147,-1,8147,8257,8141,-1,8231,8220,8205,-1,8205,8222,8231,-1,8260,8261,8234,-1,8234,8262,8260,-1,8263,8264,8261,-1,8261,8260,8263,-1,8232,8234,8261,-1,8261,8244,8232,-1,8262,8234,8233,-1,8233,8265,8262,-1,8262,8266,8267,-1,8267,8260,8262,-1,8268,8269,8270,-1,8270,8271,8268,-1,8272,8269,8268,-1,8268,8256,8272,-1,8149,8270,8269,-1,8269,8150,8149,-1,8271,8270,8273,-1,8273,8265,8271,-1,8271,8236,8235,-1,8235,8268,8271,-1,8274,8275,8233,-1,8233,8232,8274,-1,8265,8273,8266,-1,8266,8262,8265,-1,8273,8151,8154,-1,8154,8266,8273,-1,8149,8151,8273,-1,8273,8270,8149,-1,8236,8271,8265,-1,8265,8233,8236,-1,8236,8233,8275,-1,8275,8238,8236,-1,8259,8276,8230,-1,8230,8226,8259,-1,8154,8157,8267,-1,8267,8266,8154,-1,8207,8210,8274,-1,8274,8232,8207,-1,8221,8220,8230,-1,8230,8276,8221,-1,8277,8278,8143,-1,8143,8224,8277,-1,8277,8264,8263,-1,8263,8278,8277,-1,8241,8183,8143,-1,8143,8278,8241,-1,8277,8224,8248,-1,8248,8246,8277,-1,8173,8175,8255,-1,8255,8174,8173,-1,8174,8254,8147,-1,8147,8148,8174,-1,8175,8272,8256,-1,8256,8255,8175,-1,8251,8254,8174,-1,8174,8255,8251,-1,8272,8175,8128,-1,8128,8127,8272,-1,8272,8127,8150,-1,8150,8269,8272,-1,8235,8252,8256,-1,8256,8268,8235,-1,8219,8218,8248,-1,8248,8243,8219,-1,8264,8247,8244,-1,8244,8261,8264,-1,8247,8214,8208,-1,8208,8244,8247,-1,8247,8264,8277,-1,8277,8246,8247,-1,8260,8267,8242,-1,8242,8263,8260,-1,8241,8278,8263,-1,8263,8242,8241,-1,8157,8199,8242,-1,8242,8267,8157,-1,8199,8196,8183,-1,8183,8241,8199,-1,8209,8279,8280,-1,8280,8210,8209,-1,8280,8281,8282,-1,8283,8216,8217,-1,8217,8221,8284,-1,8221,8276,8284,-1,8285,8284,8276,-1,8286,8259,8253,-1,8287,8288,8289,-1,8290,8291,8292,-1,8276,8259,8285,-1,8293,8294,8295,-1,8296,8297,8298,-1,8299,8300,8301,-1,8213,8302,8279,-1,8279,8209,8213,-1,8279,8293,8281,-1,8281,8280,8279,-1,8281,8303,8304,-1,8304,8282,8281,-1,8274,8210,8280,-1,8280,8282,8274,-1,8212,8245,8249,-1,8249,8305,8212,-1,8213,8212,8305,-1,8305,8302,8213,-1,8306,8283,8217,-1,8217,8284,8306,-1,8299,8283,8306,-1,8306,8300,8299,-1,8307,8308,8306,-1,8306,8284,8307,-1,8309,8310,8311,-1,8311,8312,8309,-1,8313,8314,8315,-1,8315,8292,8313,-1,8298,8297,8314,-1,8314,8313,8298,-1,8296,8298,8316,-1,8316,8317,8296,-1,8318,8319,8310,-1,8310,8309,8318,-1,8320,8321,8319,-1,8319,8318,8320,-1,8322,8323,8321,-1,8321,8320,8322,-1,8324,8325,8323,-1,8323,8322,8324,-1,8317,8316,8325,-1,8325,8324,8317,-1,8326,8318,8309,-1,8309,8327,8326,-1,8328,8320,8318,-1,8318,8326,8328,-1,8309,8312,8329,-1,8329,8327,8309,-1,8303,8326,8327,-1,8327,8304,8303,-1,8274,8282,8304,-1,8304,8275,8274,-1,8275,8304,8330,-1,8330,8238,8275,-1,8331,8332,8259,-1,8259,8286,8331,-1,8333,8286,8253,-1,8253,8239,8333,-1,8238,8330,8334,-1,8334,8237,8238,-1,8335,8334,8330,-1,8330,8329,8335,-1,8237,8334,8333,-1,8333,8239,8237,-1,8329,8330,8304,-1,8304,8327,8329,-1,8335,8336,8333,-1,8333,8334,8335,-1,8290,8288,8287,-1,8287,8291,8290,-1,8332,8337,8285,-1,8285,8259,8332,-1,8332,8315,8314,-1,8314,8337,8332,-1,8337,8307,8284,-1,8284,8285,8337,-1,8337,8314,8297,-1,8297,8307,8337,-1,8297,8296,8308,-1,8308,8307,8297,-1,8308,8338,8300,-1,8300,8306,8308,-1,8308,8296,8317,-1,8317,8338,8308,-1,8338,8339,8340,-1,8340,8300,8338,-1,8338,8317,8324,-1,8324,8339,8338,-1,8339,8341,8294,-1,8294,8340,8339,-1,8301,8300,8340,-1,8340,8342,8301,-1,8339,8324,8322,-1,8322,8341,8339,-1,8341,8328,8295,-1,8295,8294,8341,-1,8340,8294,8293,-1,8293,8342,8340,-1,8341,8322,8320,-1,8320,8328,8341,-1,8328,8326,8303,-1,8303,8295,8328,-1,8295,8303,8281,-1,8281,8293,8295,-1,8289,8343,8312,-1,8312,8311,8289,-1,8288,8290,8344,-1,8344,8345,8288,-1,8345,8343,8289,-1,8289,8288,8345,-1,8290,8292,8315,-1,8315,8344,8290,-1,8343,8335,8329,-1,8329,8312,8343,-1,8343,8345,8336,-1,8336,8335,8343,-1,8216,8283,8299,-1,8299,8249,8216,-1,8301,8305,8249,-1,8249,8299,8301,-1,8342,8302,8305,-1,8305,8301,8342,-1,8302,8342,8293,-1,8293,8279,8302,-1,8336,8331,8286,-1,8286,8333,8336,-1,8345,8344,8331,-1,8331,8336,8345,-1,8344,8315,8332,-1,8332,8331,8344,-1,8346,8347,8348,-1,8349,8350,8351,-1,8346,8352,8353,-1,8354,8350,8355,-1,8356,8357,8358,-1,8359,8360,8361,-1,8362,8363,8364,-1,8365,8362,8364,-1,8366,8292,8291,-1,8367,8368,8369,-1,8367,8370,8371,-1,8372,8347,8346,-1,8346,8353,8372,-1,8373,8348,8347,-1,8347,8374,8373,-1,8375,8352,8346,-1,8346,8348,8375,-1,8349,8376,8355,-1,8355,8350,8349,-1,8351,8350,8354,-1,8354,8377,8351,-1,8363,8349,8351,-1,8351,8364,8363,-1,8372,8378,8374,-1,8374,8347,8372,-1,8379,8372,8353,-1,8353,8380,8379,-1,8381,8378,8372,-1,8372,8379,8381,-1,8382,8380,8353,-1,8353,8352,8382,-1,8376,8379,8380,-1,8380,8355,8376,-1,8383,8381,8379,-1,8379,8376,8383,-1,8354,8355,8380,-1,8380,8382,8354,-1,8376,8349,8363,-1,8363,8383,8376,-1,8384,8382,8352,-1,8352,8375,8384,-1,8377,8354,8382,-1,8382,8384,8377,-1,8384,8375,8385,-1,8385,8386,8384,-1,8377,8384,8386,-1,8386,8387,8377,-1,8351,8377,8387,-1,8387,8364,8351,-1,8385,8375,8348,-1,8348,8373,8385,-1,8388,8389,8390,-1,8390,8365,8388,-1,8388,8316,8298,-1,8298,8389,8388,-1,8391,8392,8390,-1,8390,8389,8391,-1,8390,8393,8362,-1,8362,8365,8390,-1,8388,8365,8394,-1,8394,8395,8388,-1,8396,8397,8311,-1,8311,8310,8396,-1,8396,8358,8398,-1,8398,8397,8396,-1,8311,8397,8399,-1,8399,8289,8311,-1,8400,8396,8310,-1,8310,8319,8400,-1,8401,8391,8313,-1,8313,8292,8401,-1,8401,8402,8392,-1,8392,8391,8401,-1,8391,8389,8298,-1,8298,8313,8391,-1,8403,8401,8292,-1,8292,8366,8403,-1,8388,8395,8325,-1,8325,8316,8388,-1,8400,8356,8358,-1,8358,8396,8400,-1,8404,8400,8319,-1,8319,8321,8404,-1,8404,8405,8356,-1,8356,8400,8404,-1,8406,8404,8321,-1,8321,8323,8406,-1,8406,8407,8405,-1,8405,8404,8406,-1,8395,8406,8323,-1,8323,8325,8395,-1,8395,8394,8407,-1,8407,8406,8395,-1,8408,8357,8356,-1,8356,8373,8408,-1,8409,8398,8358,-1,8358,8357,8409,-1,8359,8361,8410,-1,8410,8411,8359,-1,8361,8412,8408,-1,8408,8410,8361,-1,8378,8411,8410,-1,8410,8374,8378,-1,8411,8413,8414,-1,8414,8359,8411,-1,8360,8415,8412,-1,8412,8361,8360,-1,8357,8408,8412,-1,8412,8409,8357,-1,8373,8374,8410,-1,8410,8408,8373,-1,8393,8416,8363,-1,8363,8362,8393,-1,8378,8381,8413,-1,8413,8411,8378,-1,8383,8363,8416,-1,8416,8417,8383,-1,8383,8417,8413,-1,8413,8381,8383,-1,8394,8365,8364,-1,8364,8387,8394,-1,8407,8386,8385,-1,8385,8405,8407,-1,8394,8387,8386,-1,8386,8407,8394,-1,8405,8385,8373,-1,8373,8356,8405,-1,8287,8289,8399,-1,8399,8418,8287,-1,8419,8420,8418,-1,8418,8399,8419,-1,8418,8366,8291,-1,8291,8287,8418,-1,8366,8418,8420,-1,8420,8403,8366,-1,8419,8399,8397,-1,8397,8398,8419,-1,8368,8417,8416,-1,8416,8369,8368,-1,8414,8413,8417,-1,8417,8368,8414,-1,8421,8369,8416,-1,8416,8393,8421,-1,8422,8414,8368,-1,8368,8367,8422,-1,8414,8422,8360,-1,8360,8359,8414,-1,8422,8367,8371,-1,8371,8423,8422,-1,8424,8425,8420,-1,8420,8419,8424,-1,8415,8423,8425,-1,8425,8424,8415,-1,8425,8426,8403,-1,8403,8420,8425,-1,8424,8419,8398,-1,8398,8409,8424,-1,8360,8422,8423,-1,8423,8415,8360,-1,8423,8371,8426,-1,8426,8425,8423,-1,8415,8424,8409,-1,8409,8412,8415,-1,8426,8402,8401,-1,8401,8403,8426,-1,8371,8370,8402,-1,8402,8426,8371,-1,8421,8392,8402,-1,8402,8370,8421,-1,8370,8367,8369,-1,8369,8421,8370,-1,8392,8421,8393,-1,8393,8390,8392,-1,8114,8427,8428,-1,8429,8428,8427,-1,8430,8431,8432,-1,8431,8430,8433,-1,8434,8435,8436,-1,8436,8435,8437,-1,7880,8078,7881,-1,8438,8439,8440,-1,8438,7935,7868,-1,8441,7936,7935,-1,7936,8441,8442,-1,7935,8438,8441,-1,8443,8444,8445,-1,8446,8447,8448,-1,8427,8114,8112,-1,8112,8118,8427,-1,8428,8449,8115,-1,8115,8114,8428,-1,8432,8450,8443,-1,8443,8430,8432,-1,8451,8452,8435,-1,8435,8434,8451,-1,8436,8431,8433,-1,8433,8434,8436,-1,8451,8434,8433,-1,8433,8453,8451,-1,8430,8443,8453,-1,8453,8433,8430,-1,8435,8452,8454,-1,8454,8437,8435,-1,7881,8078,8455,-1,8455,7928,7881,-1,8456,8457,8458,-1,8458,8459,8456,-1,8446,8457,8456,-1,8456,8447,8446,-1,8458,8457,8460,-1,8460,8461,8458,-1,8462,8459,8458,-1,8458,8463,8462,-1,8464,8444,8465,-1,8465,8466,8464,-1,8467,8468,8469,-1,8469,8470,8467,-1,8470,8469,8464,-1,8464,8466,8470,-1,8467,8462,8463,-1,8463,8468,8467,-1,8471,7887,7886,-1,7886,8472,8471,-1,8473,8474,8475,-1,8475,8476,8473,-1,8473,8449,8477,-1,8477,8474,8473,-1,8475,8474,8478,-1,8478,8479,8475,-1,8475,8480,8481,-1,8481,8476,8475,-1,8476,8482,8119,-1,8119,8473,8476,-1,8483,8427,8118,-1,8118,8484,8483,-1,8120,8482,8472,-1,8472,7886,8120,-1,8120,8116,8119,-1,8119,8482,8120,-1,8481,8472,8482,-1,8482,8476,8481,-1,8449,8473,8119,-1,8119,8115,8449,-1,8429,8477,8449,-1,8449,8428,8429,-1,8438,7868,7867,-1,7867,8439,8438,-1,8485,8440,8439,-1,8439,8486,8485,-1,8441,8438,8440,-1,8440,8487,8441,-1,8439,7867,7911,-1,7911,8486,8439,-1,8486,7911,7913,-1,7913,8488,8486,-1,8489,8471,8472,-1,8472,8481,8489,-1,8488,7913,8471,-1,8471,8489,8488,-1,8481,8480,8490,-1,8490,8489,8481,-1,7913,7889,7887,-1,7887,8471,7913,-1,8489,8490,8491,-1,8491,8488,8489,-1,8491,8485,8486,-1,8486,8488,8491,-1,8461,8460,8485,-1,8485,8491,8461,-1,8440,8485,8460,-1,8460,8492,8440,-1,8443,8450,8465,-1,8465,8444,8443,-1,8445,8444,8493,-1,8493,8494,8445,-1,8443,8445,8495,-1,8495,8453,8443,-1,8494,8496,8495,-1,8495,8445,8494,-1,8429,8497,8496,-1,8496,8494,8429,-1,8496,8498,8499,-1,8499,8495,8496,-1,8427,8483,8497,-1,8497,8429,8427,-1,8497,8500,8498,-1,8498,8496,8497,-1,8494,8493,8477,-1,8477,8429,8494,-1,8483,8442,8500,-1,8500,8497,8483,-1,8484,8118,8162,-1,8162,8455,8484,-1,8484,7936,8442,-1,8442,8483,8484,-1,8495,8499,8451,-1,8451,8453,8495,-1,8499,8448,8452,-1,8452,8451,8499,-1,8498,8501,8448,-1,8448,8499,8498,-1,8500,8487,8501,-1,8501,8498,8500,-1,8442,8441,8487,-1,8487,8500,8442,-1,8455,8078,7936,-1,7936,8484,8455,-1,8447,8454,8452,-1,8452,8448,8447,-1,8501,8492,8446,-1,8446,8448,8501,-1,8487,8440,8492,-1,8492,8501,8487,-1,8492,8460,8457,-1,8457,8446,8492,-1,8162,7929,7928,-1,7928,8455,8162,-1,8502,8461,8491,-1,8491,8490,8502,-1,8463,8458,8461,-1,8461,8502,8463,-1,8478,8493,8444,-1,8444,8464,8478,-1,8474,8477,8493,-1,8493,8478,8474,-1,8469,8479,8478,-1,8478,8464,8469,-1,8468,8503,8479,-1,8479,8469,8468,-1,8468,8463,8502,-1,8502,8503,8468,-1,8479,8503,8480,-1,8480,8475,8479,-1,8503,8502,8490,-1,8490,8480,8503,-1,8436,8504,8505,-1,8506,8431,8507,-1,8431,8506,8432,-1,8504,8436,8437,-1,8462,8508,8459,-1,8509,8510,8511,-1,8511,8512,8513,-1,8505,8504,8510,-1,8510,8514,8505,-1,8504,8437,8454,-1,8454,8510,8504,-1,8514,8510,8509,-1,8509,8515,8514,-1,8514,8516,8507,-1,8507,8505,8514,-1,8507,8516,8517,-1,8517,8506,8507,-1,8517,8516,8518,-1,8518,8519,8517,-1,8506,8517,8450,-1,8450,8432,8506,-1,8431,8436,8505,-1,8505,8507,8431,-1,8516,8514,8515,-1,8515,8518,8516,-1,8520,8515,8509,-1,8509,8521,8520,-1,8520,8522,8518,-1,8518,8515,8520,-1,8509,8511,8513,-1,8513,8521,8509,-1,8520,8521,8523,-1,8523,8524,8520,-1,8525,8526,8527,-1,8527,8519,8525,-1,8526,8525,8528,-1,8528,8529,8526,-1,8530,8527,8526,-1,8526,8531,8530,-1,8532,8517,8519,-1,8519,8527,8532,-1,8522,8525,8519,-1,8519,8518,8522,-1,8522,8520,8524,-1,8524,8533,8522,-1,8525,8522,8533,-1,8533,8528,8525,-1,8531,8526,8529,-1,8529,8534,8531,-1,8535,8536,8513,-1,8513,8537,8535,-1,8538,8535,8537,-1,8537,8539,8538,-1,8540,8538,8539,-1,8539,8541,8540,-1,8541,8542,8543,-1,8543,8540,8541,-1,8542,8531,8534,-1,8534,8543,8542,-1,8544,8512,8456,-1,8456,8459,8544,-1,8466,8465,8532,-1,8532,8545,8466,-1,8465,8450,8517,-1,8517,8532,8465,-1,8545,8532,8527,-1,8527,8530,8545,-1,8545,8546,8470,-1,8470,8466,8545,-1,8547,8467,8470,-1,8470,8546,8547,-1,8547,8508,8462,-1,8462,8467,8547,-1,8548,8549,8547,-1,8547,8546,8548,-1,8546,8545,8530,-1,8530,8548,8546,-1,8549,8550,8508,-1,8508,8547,8549,-1,8550,8544,8459,-1,8459,8508,8550,-1,8454,8447,8511,-1,8511,8510,8454,-1,8536,8523,8521,-1,8521,8513,8536,-1,8512,8511,8447,-1,8447,8456,8512,-1,8537,8513,8512,-1,8512,8544,8537,-1,8539,8537,8544,-1,8544,8550,8539,-1,8530,8531,8542,-1,8542,8548,8530,-1,8541,8539,8550,-1,8550,8549,8541,-1,8549,8548,8542,-1,8542,8541,8549,-1,8551,8552,8553,-1,8554,8555,8556,-1,8557,8558,8554,-1,8559,8552,8560,-1,8561,8562,8563,-1,8564,8565,8566,-1,8567,8568,8569,-1,8570,8571,8572,-1,8573,8574,8575,-1,8551,8576,8560,-1,8560,8552,8551,-1,8559,8577,8553,-1,8553,8552,8559,-1,8553,8562,8561,-1,8561,8551,8553,-1,8578,8555,8554,-1,8554,8558,8578,-1,8556,8555,8565,-1,8565,8564,8556,-1,8554,8556,8579,-1,8579,8557,8554,-1,8555,8578,8580,-1,8580,8565,8555,-1,8581,8578,8558,-1,8558,8582,8581,-1,8578,8581,8583,-1,8583,8580,8578,-1,8582,8558,8557,-1,8557,8584,8582,-1,8576,8581,8582,-1,8582,8560,8576,-1,8581,8576,8585,-1,8585,8583,8581,-1,8584,8559,8560,-1,8560,8582,8584,-1,8576,8551,8561,-1,8561,8585,8576,-1,8584,8586,8577,-1,8577,8559,8584,-1,8557,8579,8586,-1,8586,8584,8557,-1,8553,8577,8587,-1,8587,8562,8553,-1,8577,8586,8588,-1,8588,8587,8577,-1,8586,8579,8589,-1,8589,8588,8586,-1,8579,8556,8564,-1,8564,8589,8579,-1,8533,8524,8571,-1,8571,8590,8533,-1,8524,8523,8591,-1,8591,8571,8524,-1,8592,8590,8571,-1,8571,8570,8592,-1,8528,8533,8590,-1,8590,8593,8528,-1,8528,8593,8594,-1,8594,8529,8528,-1,8566,8595,8594,-1,8594,8593,8566,-1,8534,8529,8594,-1,8594,8596,8534,-1,8566,8593,8590,-1,8590,8592,8566,-1,8596,8594,8595,-1,8595,8597,8596,-1,8543,8534,8596,-1,8596,8598,8543,-1,8535,8599,8600,-1,8600,8536,8535,-1,8535,8538,8601,-1,8601,8599,8535,-1,8602,8603,8600,-1,8600,8599,8602,-1,8523,8536,8600,-1,8600,8591,8523,-1,8538,8540,8604,-1,8604,8601,8538,-1,8605,8602,8599,-1,8599,8601,8605,-1,8598,8604,8540,-1,8540,8543,8598,-1,8606,8605,8601,-1,8601,8604,8606,-1,8604,8598,8607,-1,8607,8606,8604,-1,8598,8596,8597,-1,8597,8607,8598,-1,8562,8587,8572,-1,8572,8563,8562,-1,8608,8561,8563,-1,8563,8603,8608,-1,8565,8609,8595,-1,8595,8566,8565,-1,8564,8566,8592,-1,8592,8589,8564,-1,8570,8572,8587,-1,8587,8588,8570,-1,8589,8592,8570,-1,8570,8588,8589,-1,8608,8610,8585,-1,8585,8561,8608,-1,8610,8611,8583,-1,8583,8585,8610,-1,8612,8580,8583,-1,8583,8611,8612,-1,8609,8565,8580,-1,8580,8612,8609,-1,8568,8567,8602,-1,8602,8605,8568,-1,8568,8613,8614,-1,8614,8569,8568,-1,8567,8569,8610,-1,8610,8608,8567,-1,8591,8600,8603,-1,8603,8563,8591,-1,8572,8571,8591,-1,8591,8563,8572,-1,8567,8608,8603,-1,8603,8602,8567,-1,8574,8612,8611,-1,8611,8614,8574,-1,8574,8573,8609,-1,8609,8612,8574,-1,8569,8614,8611,-1,8611,8610,8569,-1,8613,8575,8574,-1,8574,8614,8613,-1,8597,8595,8609,-1,8609,8573,8597,-1,8607,8597,8573,-1,8573,8575,8607,-1,8605,8606,8613,-1,8613,8568,8605,-1,8613,8606,8607,-1,8607,8575,8613,-1,8615,7818,7817,-1,8616,8617,8618,-1,8619,8620,8621,-1,8622,8623,8624,-1,8624,8625,8622,-1,8626,8627,8628,-1,8629,8628,8627,-1,7969,8630,8058,-1,7819,8631,8077,-1,8632,8633,8634,-1,8005,8101,8635,-1,8636,8637,8203,-1,8638,8639,8640,-1,8641,8642,8643,-1,7968,8644,7969,-1,8639,8645,8644,-1,8643,8646,8647,-1,8615,8648,8649,-1,8649,7818,8615,-1,8615,7817,8058,-1,8058,8630,8615,-1,8003,8634,8616,-1,8616,8618,8003,-1,8003,8002,8632,-1,8632,8634,8003,-1,8633,8650,8616,-1,8616,8634,8633,-1,8006,8003,8618,-1,8618,8651,8006,-1,8620,8619,8060,-1,8060,8056,8620,-1,8621,8620,8652,-1,8652,8653,8621,-1,8654,8619,8621,-1,8621,8655,8654,-1,8622,8647,8646,-1,8646,8623,8622,-1,8656,8627,8626,-1,8626,8657,8656,-1,8658,8626,8628,-1,8628,8659,8658,-1,8656,8657,8625,-1,8625,8624,8656,-1,8660,8661,8625,-1,8625,8657,8660,-1,8658,8660,8657,-1,8657,8626,8658,-1,8622,8625,8661,-1,8661,8647,8622,-1,8662,8648,8615,-1,8615,8630,8662,-1,8620,8056,8006,-1,8006,8651,8620,-1,8663,8664,8665,-1,8665,8666,8663,-1,8667,8668,8669,-1,8669,8670,8667,-1,8668,8671,8672,-1,8672,8669,8668,-1,8671,8673,8674,-1,8674,8672,8671,-1,8673,8663,8666,-1,8666,8674,8673,-1,8631,7819,7818,-1,7818,8675,8631,-1,8676,8102,8077,-1,8077,8631,8676,-1,8676,8633,8632,-1,8632,8635,8676,-1,8675,8677,8650,-1,8650,8633,8675,-1,7818,8649,8677,-1,8677,8675,7818,-1,8678,8679,8650,-1,8650,8677,8678,-1,8633,8676,8631,-1,8631,8675,8633,-1,8680,8678,8677,-1,8677,8649,8680,-1,8679,8681,8616,-1,8616,8650,8679,-1,8002,8005,8635,-1,8635,8632,8002,-1,8649,8648,8682,-1,8682,8680,8649,-1,8676,8635,8101,-1,8101,8102,8676,-1,8636,8638,8640,-1,8640,8637,8636,-1,8637,8178,8179,-1,8179,8203,8637,-1,8060,8619,8636,-1,8636,8203,8060,-1,8619,8654,8638,-1,8638,8636,8619,-1,8177,8178,8637,-1,8637,8640,8177,-1,8654,8645,8639,-1,8639,8638,8654,-1,8176,8177,8640,-1,8640,8639,8176,-1,8644,7968,8176,-1,8176,8639,8644,-1,8618,8617,8683,-1,8683,8651,8618,-1,8641,8683,8617,-1,8617,8684,8641,-1,8683,8652,8620,-1,8620,8651,8683,-1,8652,8683,8641,-1,8641,8643,8652,-1,8681,8684,8617,-1,8617,8616,8681,-1,8642,8641,8684,-1,8684,8665,8642,-1,8666,8665,8684,-1,8684,8681,8666,-1,8685,8642,8665,-1,8665,8664,8685,-1,8685,8646,8643,-1,8643,8642,8685,-1,8659,8628,8629,-1,8629,8686,8659,-1,8687,8688,8659,-1,8659,8686,8687,-1,8687,8667,8670,-1,8670,8688,8687,-1,8659,8688,8689,-1,8689,8658,8659,-1,8690,8691,8689,-1,8689,8688,8690,-1,8689,8692,8660,-1,8660,8658,8689,-1,8662,8693,8691,-1,8691,8690,8662,-1,8691,8694,8692,-1,8692,8689,8691,-1,8688,8670,8682,-1,8682,8690,8688,-1,8630,8645,8693,-1,8693,8662,8630,-1,8693,8655,8694,-1,8694,8691,8693,-1,8690,8682,8648,-1,8648,8662,8690,-1,7969,8644,8645,-1,8645,8630,7969,-1,8645,8654,8655,-1,8655,8693,8645,-1,8670,8669,8680,-1,8680,8682,8670,-1,8692,8695,8661,-1,8661,8660,8692,-1,8694,8653,8695,-1,8695,8692,8694,-1,8655,8621,8653,-1,8653,8694,8655,-1,8695,8643,8647,-1,8647,8661,8695,-1,8653,8652,8643,-1,8643,8695,8653,-1,8674,8666,8681,-1,8681,8679,8674,-1,8669,8672,8678,-1,8678,8680,8669,-1,8672,8674,8679,-1,8679,8678,8672,-1,8623,8696,8624,-1,8696,8697,8624,-1,8698,8629,8627,-1,8698,8627,8699,-1,8700,8701,8702,-1,8703,8704,8705,-1,8706,8707,8708,-1,8709,8710,8700,-1,8646,8700,8710,-1,8711,8656,8624,-1,8624,8697,8711,-1,8627,8656,8711,-1,8711,8699,8627,-1,8712,8713,8714,-1,8714,8715,8712,-1,8716,8712,8715,-1,8715,8717,8716,-1,8718,8716,8717,-1,8717,8719,8718,-1,8720,8707,8721,-1,8721,8722,8720,-1,8723,8707,8720,-1,8720,8724,8723,-1,8721,8707,8706,-1,8706,8725,8721,-1,8721,8718,8719,-1,8719,8722,8721,-1,8726,8714,8713,-1,8713,8727,8726,-1,8702,8728,8727,-1,8727,8713,8702,-1,8727,8729,8730,-1,8730,8726,8727,-1,8663,8731,8732,-1,8732,8664,8663,-1,8663,8673,8733,-1,8733,8731,8663,-1,8731,8734,8728,-1,8728,8732,8731,-1,8701,8685,8664,-1,8664,8732,8701,-1,8731,8733,8735,-1,8735,8734,8731,-1,8729,8727,8728,-1,8728,8734,8729,-1,8728,8702,8701,-1,8701,8732,8728,-1,8668,8667,8736,-1,8736,8737,8668,-1,8703,8736,8667,-1,8667,8687,8703,-1,8706,8708,8737,-1,8737,8736,8706,-1,8671,8668,8737,-1,8737,8738,8671,-1,8738,8737,8708,-1,8708,8739,8738,-1,8707,8723,8739,-1,8739,8708,8707,-1,8733,8738,8739,-1,8739,8735,8733,-1,8740,8723,8724,-1,8724,8741,8740,-1,8729,8740,8741,-1,8741,8730,8729,-1,8723,8740,8735,-1,8735,8739,8723,-1,8740,8729,8734,-1,8734,8735,8740,-1,8673,8671,8738,-1,8738,8733,8673,-1,8709,8697,8696,-1,8696,8710,8709,-1,8623,8646,8710,-1,8710,8696,8623,-1,8629,8698,8704,-1,8704,8686,8629,-1,8646,8685,8701,-1,8701,8700,8646,-1,8709,8700,8702,-1,8702,8742,8709,-1,8725,8743,8718,-1,8718,8721,8725,-1,8703,8705,8743,-1,8743,8725,8703,-1,8743,8744,8716,-1,8716,8718,8743,-1,8705,8745,8744,-1,8744,8743,8705,-1,8725,8706,8736,-1,8736,8703,8725,-1,8686,8704,8703,-1,8703,8687,8686,-1,8698,8699,8705,-1,8705,8704,8698,-1,8699,8711,8745,-1,8745,8705,8699,-1,8744,8742,8712,-1,8712,8716,8744,-1,8745,8709,8742,-1,8742,8744,8745,-1,8711,8697,8709,-1,8709,8745,8711,-1,8742,8702,8713,-1,8713,8712,8742,-1,8746,8747,8748,-1,8749,8750,8751,-1,8752,8747,8753,-1,8754,8755,8749,-1,8756,8757,8758,-1,8759,8760,8761,-1,8762,8763,8764,-1,8765,8763,8762,-1,8766,8762,8767,-1,8766,8765,8762,-1,8746,8768,8753,-1,8753,8747,8746,-1,8769,8748,8747,-1,8747,8752,8769,-1,8757,8746,8748,-1,8748,8758,8757,-1,8770,8750,8749,-1,8749,8755,8770,-1,8759,8751,8750,-1,8750,8760,8759,-1,8771,8754,8749,-1,8749,8751,8771,-1,8772,8768,8746,-1,8746,8757,8772,-1,8768,8773,8774,-1,8774,8753,8768,-1,8773,8768,8772,-1,8772,8775,8773,-1,8773,8770,8755,-1,8755,8774,8773,-1,8752,8753,8774,-1,8774,8776,8752,-1,8770,8773,8775,-1,8775,8777,8770,-1,8776,8774,8755,-1,8755,8754,8776,-1,8750,8770,8777,-1,8777,8760,8750,-1,8778,8776,8754,-1,8754,8771,8778,-1,8751,8759,8779,-1,8779,8771,8751,-1,8769,8752,8776,-1,8776,8778,8769,-1,8780,8778,8771,-1,8771,8779,8780,-1,8778,8780,8781,-1,8781,8769,8778,-1,8758,8748,8769,-1,8769,8781,8758,-1,8781,8782,8756,-1,8756,8758,8781,-1,8779,8759,8761,-1,8761,8783,8779,-1,8715,8714,8784,-1,8784,8785,8715,-1,8786,8784,8714,-1,8714,8726,8786,-1,8785,8784,8756,-1,8756,8782,8785,-1,8785,8787,8717,-1,8717,8715,8785,-1,8787,8785,8782,-1,8782,8788,8787,-1,8787,8789,8719,-1,8719,8717,8787,-1,8789,8787,8788,-1,8788,8783,8789,-1,8722,8719,8789,-1,8789,8790,8722,-1,8782,8781,8780,-1,8780,8788,8782,-1,8772,8791,8792,-1,8792,8775,8772,-1,8793,8777,8775,-1,8775,8792,8793,-1,8777,8793,8794,-1,8794,8760,8777,-1,8791,8772,8757,-1,8757,8795,8791,-1,8783,8788,8780,-1,8780,8779,8783,-1,8790,8796,8720,-1,8720,8722,8790,-1,8796,8797,8724,-1,8724,8720,8796,-1,8798,8786,8726,-1,8726,8730,8798,-1,8797,8799,8741,-1,8741,8724,8797,-1,8799,8798,8730,-1,8730,8741,8799,-1,8763,8791,8795,-1,8795,8764,8763,-1,8762,8764,8800,-1,8800,8801,8762,-1,8767,8762,8801,-1,8801,8802,8767,-1,8767,8794,8793,-1,8793,8766,8767,-1,8790,8789,8783,-1,8783,8761,8790,-1,8796,8790,8761,-1,8761,8803,8796,-1,8804,8756,8784,-1,8784,8786,8804,-1,8795,8757,8756,-1,8756,8804,8795,-1,8760,8794,8803,-1,8803,8761,8760,-1,8800,8804,8786,-1,8786,8798,8800,-1,8764,8795,8804,-1,8804,8800,8764,-1,8801,8800,8798,-1,8798,8799,8801,-1,8765,8792,8791,-1,8791,8763,8765,-1,8766,8793,8792,-1,8792,8765,8766,-1,8802,8803,8794,-1,8794,8767,8802,-1,8802,8797,8796,-1,8796,8803,8802,-1,8802,8801,8799,-1,8799,8797,8802,-1,8805,8806,8807,-1,8808,8809,8810,-1,8811,8812,8808,-1,8813,8814,8812,-1,8815,8816,8817,-1,8818,8819,8820,-1,8816,8815,8821,-1,8818,8822,8819,-1,8822,8823,8824,-1,7979,7980,8825,-1,8047,8826,7981,-1,8827,8828,8829,-1,8830,8831,8832,-1,8166,8833,8181,-1,8057,8181,8834,-1,8822,8818,8823,-1,8001,8000,8835,-1,8835,8836,8001,-1,8837,8838,8807,-1,8807,8806,8837,-1,8839,8840,8838,-1,8838,8837,8839,-1,8807,8838,8015,-1,8015,8013,8807,-1,8841,8837,8806,-1,8806,8842,8841,-1,8014,8805,8807,-1,8807,8013,8014,-1,8815,8817,8820,-1,8820,8819,8815,-1,8814,8809,8808,-1,8808,8812,8814,-1,8814,8843,8824,-1,8824,8809,8814,-1,8843,8814,8813,-1,8813,8844,8843,-1,8843,8821,8822,-1,8822,8824,8843,-1,8824,8845,8841,-1,8841,8809,8824,-1,8821,8815,8819,-1,8819,8822,8821,-1,8821,8843,8844,-1,8844,8816,8821,-1,8057,8846,8847,-1,8847,8007,8057,-1,8846,8057,8834,-1,8834,8848,8846,-1,8849,8850,8847,-1,8847,8846,8849,-1,8007,8847,8851,-1,8851,8000,8007,-1,8852,8835,8000,-1,8000,8851,8852,-1,8853,8854,8835,-1,8835,8852,8853,-1,8852,8851,8855,-1,8855,8856,8852,-1,8857,7980,8854,-1,8854,8853,8857,-1,8854,8858,8836,-1,8836,8835,8854,-1,8853,8852,8856,-1,8856,8859,8853,-1,8860,8825,7980,-1,7980,8857,8860,-1,7980,7836,8858,-1,8858,8854,7980,-1,8859,8861,8857,-1,8857,8853,8859,-1,8858,8826,8862,-1,8862,8836,8858,-1,8860,8863,8864,-1,8864,8825,8860,-1,8861,8865,8860,-1,8860,8857,8861,-1,8825,8864,8018,-1,8018,7979,8825,-1,8018,8864,8805,-1,8805,8014,8018,-1,7981,8826,8858,-1,8858,7836,7981,-1,8850,8855,8851,-1,8851,8847,8850,-1,8826,8047,7870,-1,7870,8862,8826,-1,8004,8001,8836,-1,8836,8862,8004,-1,7870,7869,8004,-1,8004,8862,7870,-1,8829,8866,8867,-1,8867,8827,8829,-1,8866,8868,8869,-1,8869,8867,8866,-1,8827,8867,8870,-1,8870,8871,8827,-1,8871,8872,8828,-1,8828,8827,8871,-1,8830,8869,8868,-1,8868,8831,8830,-1,8873,8870,8867,-1,8867,8869,8873,-1,8869,8830,8874,-1,8874,8873,8869,-1,8830,8832,8875,-1,8875,8874,8830,-1,8818,8872,8850,-1,8850,8849,8818,-1,8849,8846,8848,-1,8848,8876,8849,-1,8855,8850,8872,-1,8872,8871,8855,-1,8833,8166,8165,-1,8165,8015,8833,-1,8015,8838,8840,-1,8840,8833,8015,-1,8181,8833,8840,-1,8840,8834,8181,-1,8848,8834,8840,-1,8840,8839,8848,-1,8863,8806,8805,-1,8805,8864,8863,-1,8845,8839,8837,-1,8837,8841,8845,-1,8876,8848,8839,-1,8839,8845,8876,-1,8809,8841,8842,-1,8842,8810,8809,-1,8842,8877,8878,-1,8878,8810,8842,-1,8823,8876,8845,-1,8845,8824,8823,-1,8818,8849,8876,-1,8876,8823,8818,-1,8806,8863,8877,-1,8877,8842,8806,-1,8820,8828,8872,-1,8872,8818,8820,-1,8811,8808,8810,-1,8810,8879,8811,-1,8810,8878,8880,-1,8880,8879,8810,-1,8873,8874,8861,-1,8861,8859,8873,-1,8874,8875,8865,-1,8865,8861,8874,-1,8859,8856,8870,-1,8870,8873,8859,-1,8856,8855,8871,-1,8871,8870,8856,-1,8865,8877,8863,-1,8863,8860,8865,-1,8875,8878,8877,-1,8877,8865,8875,-1,8832,8880,8878,-1,8878,8875,8832,-1,8881,8817,8816,-1,8882,8820,8883,-1,8813,8812,8884,-1,8885,8881,8816,-1,8813,8884,8886,-1,8887,8888,8889,-1,8887,8890,8888,-1,8891,8892,8893,-1,8891,8890,8894,-1,8895,8894,8896,-1,8897,8895,8896,-1,8866,8829,8898,-1,8831,8899,8832,-1,8817,8881,8883,-1,8883,8820,8817,-1,8885,8900,8883,-1,8883,8881,8885,-1,8884,8812,8811,-1,8811,8901,8884,-1,8879,8902,8901,-1,8901,8811,8879,-1,8901,8903,8886,-1,8886,8884,8901,-1,8904,8900,8885,-1,8885,8905,8904,-1,8882,8883,8900,-1,8900,8906,8882,-1,8907,8903,8901,-1,8901,8902,8907,-1,8903,8904,8905,-1,8905,8886,8903,-1,8903,8907,8908,-1,8908,8904,8903,-1,8905,8844,8813,-1,8813,8886,8905,-1,8906,8900,8904,-1,8904,8908,8906,-1,8885,8816,8844,-1,8844,8905,8885,-1,8888,8909,8910,-1,8910,8889,8888,-1,8889,8911,8912,-1,8912,8887,8889,-1,8891,8894,8895,-1,8895,8892,8891,-1,8892,8913,8914,-1,8914,8893,8892,-1,8890,8891,8893,-1,8893,8888,8890,-1,8893,8914,8909,-1,8909,8888,8893,-1,8890,8887,8896,-1,8896,8894,8890,-1,8912,8897,8896,-1,8896,8887,8912,-1,8915,8916,8917,-1,8917,8918,8915,-1,8919,8916,8915,-1,8915,8920,8919,-1,8917,8916,8921,-1,8921,8922,8917,-1,8917,8892,8895,-1,8895,8918,8917,-1,8923,8911,8889,-1,8889,8924,8923,-1,8924,8889,8910,-1,8910,8925,8924,-1,8924,8926,8927,-1,8927,8923,8924,-1,8898,8928,8929,-1,8929,8866,8898,-1,8898,8930,8921,-1,8921,8928,8898,-1,8929,8928,8919,-1,8919,8931,8929,-1,8868,8866,8929,-1,8929,8932,8868,-1,8933,8934,8899,-1,8899,8831,8933,-1,8935,8926,8934,-1,8934,8933,8935,-1,8934,8925,8936,-1,8936,8899,8934,-1,8932,8933,8831,-1,8831,8868,8932,-1,8919,8928,8921,-1,8921,8916,8919,-1,8920,8937,8931,-1,8931,8919,8920,-1,8937,8938,8939,-1,8939,8931,8937,-1,8935,8939,8938,-1,8938,8940,8935,-1,8932,8929,8931,-1,8931,8939,8932,-1,8939,8935,8933,-1,8933,8932,8939,-1,8926,8935,8940,-1,8940,8927,8926,-1,8934,8926,8924,-1,8924,8925,8934,-1,8898,8829,8828,-1,8828,8930,8898,-1,8917,8922,8913,-1,8913,8892,8917,-1,8902,8910,8909,-1,8909,8907,8902,-1,8907,8909,8914,-1,8914,8908,8907,-1,8908,8914,8913,-1,8913,8906,8908,-1,8882,8906,8913,-1,8913,8922,8882,-1,8922,8921,8930,-1,8930,8882,8922,-1,8902,8936,8925,-1,8925,8910,8902,-1,8882,8930,8828,-1,8828,8820,8882,-1,8879,8880,8936,-1,8936,8902,8879,-1,8899,8936,8880,-1,8880,8832,8899,-1,8941,8942,8943,-1,8944,8945,8946,-1,8947,8942,8948,-1,8949,8944,8950,-1,8951,8952,8953,-1,8954,8955,8956,-1,8957,8958,8959,-1,8958,8957,8960,-1,8958,8961,8959,-1,8961,8958,8962,-1,8957,8963,8964,-1,8965,8966,8961,-1,8941,8967,8948,-1,8948,8942,8941,-1,8947,8968,8943,-1,8943,8942,8947,-1,8943,8969,8952,-1,8952,8941,8943,-1,8970,8945,8944,-1,8944,8949,8970,-1,8954,8946,8945,-1,8945,8955,8954,-1,8946,8971,8950,-1,8950,8944,8946,-1,8967,8941,8952,-1,8952,8951,8967,-1,8967,8972,8973,-1,8973,8948,8967,-1,8972,8967,8951,-1,8951,8974,8972,-1,8972,8970,8949,-1,8949,8973,8972,-1,8947,8948,8973,-1,8973,8975,8947,-1,8970,8972,8974,-1,8974,8976,8970,-1,8949,8950,8975,-1,8975,8973,8949,-1,8945,8970,8976,-1,8976,8955,8945,-1,8950,8971,8977,-1,8977,8975,8950,-1,8971,8946,8954,-1,8954,8978,8971,-1,8975,8977,8968,-1,8968,8947,8975,-1,8943,8968,8979,-1,8979,8969,8943,-1,8980,8979,8968,-1,8968,8977,8980,-1,8978,8980,8977,-1,8977,8971,8978,-1,8953,8952,8969,-1,8969,8981,8953,-1,8953,8982,8983,-1,8983,8951,8953,-1,8984,8897,8912,-1,8912,8985,8984,-1,8986,8895,8897,-1,8897,8984,8986,-1,8981,8969,8979,-1,8979,8987,8981,-1,8982,8953,8981,-1,8981,8988,8982,-1,8989,8956,8955,-1,8955,8990,8989,-1,8954,8956,8991,-1,8991,8978,8954,-1,8992,8974,8951,-1,8951,8983,8992,-1,8993,8987,8979,-1,8979,8980,8993,-1,8978,8991,8993,-1,8993,8980,8978,-1,8990,8955,8976,-1,8976,8994,8990,-1,8994,8976,8974,-1,8974,8992,8994,-1,8995,8996,8915,-1,8915,8918,8995,-1,8911,8923,8997,-1,8997,8998,8911,-1,8999,8920,8915,-1,8915,8996,8999,-1,8937,8920,8999,-1,8999,9000,8937,-1,8938,8937,9000,-1,9000,9001,8938,-1,9001,9002,8940,-1,8940,8938,9001,-1,9002,9003,8927,-1,8927,8940,9002,-1,8923,8927,9003,-1,9003,8997,8923,-1,9004,8963,8957,-1,8957,8959,9004,-1,9001,9000,8962,-1,8962,8958,9001,-1,8962,9005,8965,-1,8965,8961,8962,-1,9004,8992,8983,-1,8983,8963,9004,-1,8961,8966,9004,-1,9004,8959,8961,-1,8966,8994,8992,-1,8992,9004,8966,-1,8991,8986,8984,-1,8984,8993,8991,-1,8993,8984,8985,-1,8985,8987,8993,-1,8987,8985,8998,-1,8998,8981,8987,-1,8956,8995,8986,-1,8986,8991,8956,-1,8985,8912,8911,-1,8911,8998,8985,-1,8988,8981,8998,-1,8998,8997,8988,-1,8956,8989,8996,-1,8996,8995,8956,-1,8995,8918,8895,-1,8895,8986,8995,-1,8997,9003,9006,-1,9006,8988,8997,-1,9003,9002,8960,-1,8960,9006,9003,-1,8964,8982,8988,-1,8988,9006,8964,-1,8958,8960,9002,-1,9002,9001,8958,-1,8957,8964,9006,-1,9006,8960,8957,-1,9000,8999,9005,-1,9005,8962,9000,-1,8963,8983,8982,-1,8982,8964,8963,-1,8965,8990,8994,-1,8994,8966,8965,-1,8965,9005,8989,-1,8989,8990,8965,-1,9005,8999,8996,-1,8996,8989,9005,-1,9007,9008,9009,-1,9010,9008,9011,-1,9012,9013,9014,-1,9015,9016,9012,-1,9017,7850,7852,-1,9018,9019,9020,-1,9021,9022,9023,-1,9024,9025,9026,-1,8186,8188,9027,-1,7834,9028,9029,-1,9029,7835,7834,-1,7857,9030,9031,-1,9031,7854,7857,-1,9030,7857,9032,-1,9032,9033,9030,-1,9031,9030,9034,-1,9034,9010,9031,-1,9028,7834,7854,-1,7854,9031,9028,-1,9033,9035,9034,-1,9034,9030,9033,-1,9034,9009,9008,-1,9008,9010,9034,-1,9011,9028,9031,-1,9031,9010,9011,-1,9034,9035,9036,-1,9036,9009,9034,-1,9037,9013,9012,-1,9012,9016,9037,-1,9013,9037,9038,-1,9038,9039,9013,-1,9038,9040,9007,-1,9007,9039,9038,-1,9039,9036,9014,-1,9014,9013,9039,-1,9008,9007,9040,-1,9040,9041,9008,-1,9042,9011,9008,-1,9008,9041,9042,-1,9014,9043,9015,-1,9015,9012,9014,-1,9035,9043,9014,-1,9014,9036,9035,-1,9044,9045,9015,-1,9015,9043,9044,-1,9009,9036,9039,-1,9039,9007,9009,-1,9044,9043,9035,-1,9035,9033,9044,-1,9046,8188,7850,-1,7850,9017,9046,-1,7852,9047,9045,-1,9045,9017,7852,-1,9020,9019,9048,-1,9048,9025,9020,-1,9020,9049,9050,-1,9050,9018,9020,-1,9049,9020,9025,-1,9025,9051,9049,-1,9049,9052,9053,-1,9053,9050,9049,-1,9054,9055,9022,-1,9022,9021,9054,-1,9023,9056,9057,-1,9057,9021,9023,-1,9056,9053,9052,-1,9052,9057,9056,-1,9057,9058,9054,-1,9054,9021,9057,-1,9059,9058,9057,-1,9057,9052,9059,-1,9052,9049,9051,-1,9051,9059,9052,-1,9047,7852,8051,-1,8051,9026,9047,-1,8054,9024,9026,-1,9026,8051,8054,-1,9024,8054,7862,-1,7862,9060,9024,-1,7864,9061,9060,-1,9060,7862,7864,-1,9062,8048,7978,-1,7978,9063,9062,-1,7835,9029,9063,-1,9063,7978,7835,-1,9063,9029,9055,-1,9055,9054,9063,-1,9061,7864,8048,-1,8048,9062,9061,-1,9011,9055,9029,-1,9029,9028,9011,-1,9048,9047,9026,-1,9026,9025,9048,-1,9045,9047,9048,-1,9048,9015,9045,-1,7856,9027,9032,-1,9032,7857,7856,-1,8192,9027,7856,-1,7856,7938,8192,-1,9062,9063,9054,-1,9054,9058,9062,-1,9027,8192,8189,-1,8189,8186,9027,-1,9032,9027,8188,-1,8188,9046,9032,-1,9011,9042,9022,-1,9022,9055,9011,-1,9048,9019,9016,-1,9016,9015,9048,-1,9033,9032,9046,-1,9046,9044,9033,-1,9046,9017,9045,-1,9045,9044,9046,-1,9059,9051,9060,-1,9060,9061,9059,-1,9051,9025,9024,-1,9024,9060,9051,-1,9061,9062,9058,-1,9058,9059,9061,-1,9016,9064,9037,-1,9065,9041,9040,-1,9066,9037,9064,-1,9064,9016,9067,-1,9065,9040,9068,-1,9069,9038,9037,-1,9037,9066,9069,-1,9070,9067,9071,-1,9071,9072,9070,-1,9070,9073,9074,-1,9074,9067,9070,-1,9019,9071,9067,-1,9067,9016,9019,-1,9075,9072,9071,-1,9071,9076,9075,-1,9070,9072,9077,-1,9077,9078,9070,-1,9079,9080,9081,-1,9081,9082,9079,-1,9080,9079,9083,-1,9083,9084,9080,-1,9080,9085,9086,-1,9086,9081,9080,-1,9081,9065,9068,-1,9068,9082,9081,-1,9087,9079,9082,-1,9082,9088,9087,-1,9070,9078,9089,-1,9089,9073,9070,-1,9073,9087,9088,-1,9088,9074,9073,-1,9064,9067,9074,-1,9074,9066,9064,-1,9073,9089,9090,-1,9090,9087,9073,-1,9066,9074,9088,-1,9088,9069,9066,-1,9087,9090,9083,-1,9083,9079,9087,-1,9069,9088,9082,-1,9082,9068,9069,-1,9075,9091,9077,-1,9077,9072,9075,-1,9075,9092,9093,-1,9093,9091,9075,-1,9085,9080,9084,-1,9084,9094,9085,-1,9094,9095,9096,-1,9096,9085,9094,-1,9092,9075,9076,-1,9076,9097,9092,-1,9092,9098,9099,-1,9099,9093,9092,-1,9095,9100,9101,-1,9101,9096,9095,-1,9102,9086,9085,-1,9085,9096,9102,-1,9100,9099,9098,-1,9098,9101,9100,-1,9103,9102,9096,-1,9096,9101,9103,-1,9104,9103,9101,-1,9101,9098,9104,-1,9098,9092,9097,-1,9097,9104,9098,-1,9076,9071,9019,-1,9019,9018,9076,-1,9097,9076,9018,-1,9018,9050,9097,-1,9050,9053,9104,-1,9104,9097,9050,-1,9023,9022,9086,-1,9086,9102,9023,-1,9022,9042,9081,-1,9081,9086,9022,-1,9102,9103,9056,-1,9056,9023,9102,-1,9103,9104,9053,-1,9053,9056,9103,-1,9081,9042,9041,-1,9041,9065,9081,-1,9068,9040,9038,-1,9038,9069,9068,-1,9105,9106,9107,-1,9106,9108,9107,-1,9109,9110,9111,-1,9112,9110,9109,-1,9113,9108,9106,-1,9112,9114,9110,-1,9108,9115,9107,-1,9112,9109,9116,-1,9089,9117,9118,-1,9119,9120,9083,-1,9121,9122,9123,-1,9124,9125,9122,-1,9123,9126,9127,-1,9127,9128,9129,-1,9126,9128,9127,-1,9129,9117,9130,-1,9120,9131,9132,-1,9133,9134,9135,-1,9117,9106,9105,-1,9105,9118,9117,-1,9105,9107,9136,-1,9136,9137,9105,-1,9110,9120,9119,-1,9119,9111,9110,-1,9137,9136,9109,-1,9109,9111,9137,-1,9113,9138,9115,-1,9115,9108,9113,-1,9129,9113,9106,-1,9106,9117,9129,-1,9139,9114,9112,-1,9112,9116,9139,-1,9120,9110,9114,-1,9114,9131,9120,-1,9128,9138,9113,-1,9113,9129,9128,-1,9138,9140,9141,-1,9141,9115,9138,-1,9140,9138,9128,-1,9128,9142,9140,-1,9140,9139,9116,-1,9116,9141,9140,-1,9141,9136,9107,-1,9107,9115,9141,-1,9139,9140,9142,-1,9142,9143,9139,-1,9116,9109,9136,-1,9136,9141,9116,-1,9114,9139,9143,-1,9143,9131,9114,-1,9144,9137,9111,-1,9111,9119,9144,-1,9137,9144,9118,-1,9118,9105,9137,-1,9117,9089,9078,-1,9078,9130,9117,-1,9144,9090,9089,-1,9089,9118,9144,-1,9132,9084,9083,-1,9083,9120,9132,-1,9119,9083,9090,-1,9090,9144,9119,-1,9145,9124,9122,-1,9122,9121,9145,-1,9122,9125,9126,-1,9126,9123,9122,-1,9123,9127,9146,-1,9146,9121,9123,-1,9147,9148,9126,-1,9126,9125,9147,-1,9129,9130,9146,-1,9146,9127,9129,-1,9121,9146,9077,-1,9077,9091,9121,-1,9132,9149,9094,-1,9094,9084,9132,-1,9145,9121,9091,-1,9091,9093,9145,-1,9095,9094,9149,-1,9149,9150,9095,-1,9100,9095,9150,-1,9150,9151,9100,-1,9152,9099,9100,-1,9100,9151,9152,-1,9152,9145,9093,-1,9093,9099,9152,-1,9153,9131,9143,-1,9143,9154,9153,-1,9142,9148,9154,-1,9154,9143,9142,-1,9128,9126,9148,-1,9148,9142,9128,-1,9124,9145,9152,-1,9152,9155,9124,-1,9147,9125,9124,-1,9124,9155,9147,-1,9134,9133,9147,-1,9147,9155,9134,-1,9134,9151,9150,-1,9150,9135,9134,-1,9133,9135,9153,-1,9153,9154,9133,-1,9149,9132,9131,-1,9131,9153,9149,-1,9146,9130,9078,-1,9078,9077,9146,-1,9152,9151,9134,-1,9134,9155,9152,-1,9133,9154,9148,-1,9148,9147,9133,-1,9150,9149,9153,-1,9153,9135,9150,-1,9156,9157,9158,-1,9159,9160,9157,-1,9157,9160,9158,-1,9160,9161,9158,-1,9160,9162,9161,-1,9157,9163,9159,-1,2011,2031,9164,-1,9165,9166,9167,-1,9166,2061,2060,-1,9168,9169,1681,-1,9170,9171,9172,-1,9172,9173,9174,-1,9175,9173,9176,-1,9177,9178,9179,-1,9180,9181,9169,-1,9182,9183,9184,-1,9185,9186,2093,-1,2115,9187,1726,-1,9187,9188,9189,-1,9169,9190,9191,-1,9192,9193,9194,-1,9195,9175,9196,-1,9197,9193,9180,-1,9198,9199,9200,-1,9201,9202,9203,-1,9204,9205,9206,-1,9201,9207,9202,-1,9208,9209,9210,-1,9211,9212,9213,-1,9214,9215,9216,-1,9217,9218,9219,-1,9220,9219,9221,-1,9222,9223,9224,-1,9164,2031,9225,-1,9226,9225,2031,-1,9227,9226,9228,-1,9227,9225,9226,-1,9229,9230,9231,-1,9232,9233,9234,-1,9235,9236,9237,-1,9238,9239,9176,-1,9240,9241,9242,-1,9243,9240,9244,-1,9245,9246,9247,-1,9248,9249,9189,-1,9250,9249,9248,-1,9251,9197,9191,-1,9249,9252,9253,-1,9254,9239,9255,-1,9256,9257,9258,-1,9259,9260,9261,-1,9262,9263,9264,-1,9265,9266,9267,-1,9268,9195,9269,-1,9269,9259,9270,-1,9271,9272,9273,-1,9274,9275,9276,-1,9277,9278,9279,-1,9280,9281,9282,-1,9283,9284,9285,-1,9286,9287,9288,-1,9289,9290,9291,-1,9159,9292,9293,-1,9293,9160,9159,-1,9161,9294,9295,-1,9295,9158,9161,-1,9158,9295,9296,-1,9296,9156,9158,-1,9156,9296,9297,-1,9297,9157,9156,-1,9298,9165,9167,-1,9167,9299,9298,-1,9300,9301,9165,-1,9165,9298,9300,-1,9299,9167,9183,-1,9183,9302,9299,-1,9303,9298,9299,-1,9299,9304,9303,-1,9302,9183,9170,-1,9170,9305,9302,-1,9304,9299,9302,-1,9302,9306,9304,-1,9305,9170,9307,-1,9307,9308,9305,-1,9306,9302,9305,-1,9305,9309,9306,-1,9308,9307,9310,-1,9310,9311,9308,-1,9309,9305,9308,-1,9308,9312,9309,-1,9311,9310,9313,-1,9313,9314,9311,-1,9312,9308,9311,-1,9311,9315,9312,-1,9314,9313,9301,-1,9301,9300,9314,-1,9315,9311,9314,-1,9314,9316,9315,-1,9316,9314,9300,-1,9300,9317,9316,-1,9317,9300,9298,-1,9298,9303,9317,-1,9294,9303,9304,-1,9304,9295,9294,-1,9295,9304,9306,-1,9306,9296,9295,-1,9296,9306,9309,-1,9309,9297,9296,-1,9297,9309,9312,-1,9312,9318,9297,-1,9318,9312,9315,-1,9315,9292,9318,-1,9292,9315,9316,-1,9316,9293,9292,-1,9293,9316,9317,-1,9317,9319,9293,-1,9319,9317,9303,-1,9303,9294,9319,-1,9157,9297,9318,-1,9318,9163,9157,-1,9163,9318,9292,-1,9292,9159,9163,-1,9160,9293,9319,-1,9319,9162,9160,-1,9162,9319,9294,-1,9294,9161,9162,-1,2029,9268,2031,-1,2031,1857,2029,-1,1650,9218,1645,-1,1645,2027,1650,-1,2011,9164,1652,-1,1652,1651,2011,-1,1730,9195,9268,-1,9268,2029,1730,-1,9320,2151,2169,-1,2169,1742,9320,-1,9166,9184,9183,-1,9183,9167,9166,-1,9182,9171,9170,-1,9170,9183,9182,-1,9174,9307,9170,-1,9170,9172,9174,-1,9307,9174,1670,-1,1670,9310,9307,-1,1670,1669,9313,-1,9313,9310,1670,-1,9301,9313,1669,-1,1669,1664,9301,-1,9165,9301,1664,-1,1664,1663,9165,-1,1663,2061,9166,-1,9166,9165,1663,-1,1682,1681,9169,-1,9169,9181,1682,-1,1724,1726,9321,-1,9321,2098,1724,-1,2103,9168,1681,-1,1681,2085,2103,-1,2098,9321,9253,-1,9253,2103,2098,-1,1710,9187,2115,-1,2115,1708,1710,-1,9168,9252,9190,-1,9190,9169,9168,-1,9322,9238,9172,-1,9172,9171,9322,-1,9182,9323,9322,-1,9322,9171,9182,-1,9323,9182,9184,-1,9184,9179,9323,-1,9174,9173,2065,-1,2065,1670,9174,-1,2065,9173,9175,-1,9175,1732,2065,-1,2048,9324,9325,-1,9325,2132,2048,-1,9172,9238,9176,-1,9176,9173,9172,-1,2136,9326,9327,-1,9327,2140,2136,-1,2144,9199,9198,-1,9198,2123,2144,-1,9185,2093,2088,-1,2088,1684,9185,-1,2093,9186,2164,-1,2164,2092,2093,-1,2060,2165,9184,-1,9184,9166,2060,-1,2165,9177,9179,-1,9179,9184,2165,-1,2165,2164,9186,-1,9186,9177,2165,-1,2123,9198,9187,-1,9187,1710,2123,-1,2103,9253,9252,-1,9252,9168,2103,-1,9181,9192,1684,-1,1684,1682,9181,-1,1732,9175,9195,-1,9195,1730,1732,-1,9194,9185,1684,-1,1684,9192,9194,-1,9178,9177,9186,-1,9186,9328,9178,-1,9187,9189,9321,-1,9321,1726,9187,-1,1656,2051,9324,-1,9324,2048,1656,-1,2161,2160,9329,-1,9329,9330,2161,-1,9200,9281,9280,-1,9280,9198,9200,-1,9331,9332,9333,-1,9333,9334,9331,-1,9286,2075,2083,-1,2083,9335,9286,-1,2075,9286,9288,-1,9288,2076,2075,-1,9335,2083,2152,-1,2152,9336,9335,-1,9169,9191,9197,-1,9197,9180,9169,-1,9194,9328,9186,-1,9186,9185,9194,-1,9180,9193,9192,-1,9192,9181,9180,-1,9332,9331,9281,-1,9281,9200,9332,-1,9337,9338,9334,-1,9334,9333,9337,-1,9336,2152,2151,-1,2151,9320,9336,-1,9330,9329,9339,-1,9339,9340,9330,-1,9267,9266,9328,-1,9328,9194,9267,-1,9198,9280,9188,-1,9188,9187,9198,-1,9328,9266,9341,-1,9341,9178,9328,-1,9194,9193,9197,-1,9197,9267,9194,-1,2132,9325,9326,-1,9326,2136,2132,-1,2140,9327,9199,-1,9199,2144,2140,-1,1742,1741,9342,-1,9342,9320,1742,-1,9330,1736,2057,-1,2057,2161,9330,-1,9340,2051,1736,-1,1736,9330,9340,-1,9343,9324,2051,-1,2051,9340,9343,-1,9337,9325,9324,-1,9324,9343,9337,-1,9333,9326,9325,-1,9325,9337,9333,-1,9332,9327,9326,-1,9326,9333,9332,-1,9200,9199,9327,-1,9327,9332,9200,-1,9344,9220,9345,-1,9345,9346,9344,-1,9347,9348,9349,-1,9349,9346,9347,-1,9350,9213,9348,-1,9348,9347,9350,-1,9351,9349,9348,-1,9348,9352,9351,-1,9344,9346,9349,-1,9349,9223,9344,-1,9353,9347,9346,-1,9346,9345,9353,-1,9354,9355,9351,-1,9351,9352,9354,-1,9224,9351,9355,-1,9355,9356,9224,-1,9357,9358,9354,-1,9354,9352,9357,-1,9359,9205,9201,-1,9201,9360,9359,-1,9205,9359,9361,-1,9361,9206,9205,-1,9207,9201,9205,-1,9205,9204,9207,-1,9209,9362,9360,-1,9360,9201,9209,-1,9363,9364,9359,-1,9359,9360,9363,-1,9204,9365,9229,-1,9229,9207,9204,-1,9202,9231,9366,-1,9366,9203,9202,-1,9208,9236,9232,-1,9232,9367,9208,-1,9206,9221,9365,-1,9365,9204,9206,-1,9229,9231,9202,-1,9202,9207,9229,-1,9203,9366,9237,-1,9237,9210,9203,-1,9368,9208,9367,-1,9367,9369,9368,-1,9209,9208,9368,-1,9368,9362,9209,-1,9367,9370,9371,-1,9371,9369,9367,-1,9214,9216,9368,-1,9368,9369,9214,-1,9372,9363,9360,-1,9360,9362,9372,-1,9210,9209,9201,-1,9201,9203,9210,-1,9359,9364,9373,-1,9373,9361,9359,-1,9345,9206,9361,-1,9361,9353,9345,-1,9374,9350,9347,-1,9347,9353,9374,-1,9210,9237,9236,-1,9236,9208,9210,-1,9220,9221,9206,-1,9206,9345,9220,-1,9349,9351,9224,-1,9224,9223,9349,-1,9232,9234,9370,-1,9370,9367,9232,-1,9370,9234,9375,-1,9375,9376,9370,-1,9213,9357,9352,-1,9352,9348,9213,-1,9373,9374,9353,-1,9353,9361,9373,-1,9372,9362,9368,-1,9368,9216,9372,-1,9371,9370,9376,-1,9376,9377,9371,-1,9369,9371,9378,-1,9378,9214,9369,-1,9379,9380,9211,-1,9211,9381,9379,-1,9211,9380,9382,-1,9382,9212,9211,-1,9213,9350,9381,-1,9381,9211,9213,-1,9383,9384,9379,-1,9379,9381,9383,-1,9385,9212,9382,-1,9382,9386,9385,-1,9386,9387,9388,-1,9388,9385,9386,-1,9358,9357,9385,-1,9385,9388,9358,-1,9389,9390,9391,-1,9391,9392,9389,-1,9390,9389,9364,-1,9364,9363,9390,-1,9391,9390,9393,-1,9393,9394,9391,-1,9395,9389,9392,-1,9392,9396,9395,-1,9389,9395,9373,-1,9373,9364,9389,-1,9383,9395,9396,-1,9396,9384,9383,-1,9373,9395,9383,-1,9383,9374,9373,-1,9393,9390,9363,-1,9363,9372,9393,-1,9215,9397,9394,-1,9394,9393,9215,-1,9215,9214,9378,-1,9378,9397,9215,-1,9393,9372,9216,-1,9216,9215,9393,-1,9374,9383,9381,-1,9381,9350,9374,-1,9385,9357,9213,-1,9213,9212,9385,-1,9398,9378,9371,-1,9371,9377,9398,-1,9399,9400,9243,-1,9243,9401,9399,-1,9402,9399,9401,-1,9401,9403,9402,-1,9404,9399,9402,-1,9402,9405,9404,-1,9406,9407,9403,-1,9403,9401,9406,-1,9408,9409,9410,-1,9410,9411,9408,-1,9412,9413,9414,-1,9414,9415,9412,-1,9416,9260,9256,-1,9256,9417,9416,-1,9406,9244,9418,-1,9418,9419,9406,-1,9420,9421,9422,-1,9422,9423,9420,-1,9408,9420,9423,-1,9423,9409,9408,-1,9418,9422,9421,-1,9421,9419,9418,-1,9412,9424,9258,-1,9258,9413,9412,-1,9411,9425,9426,-1,9426,9408,9411,-1,9408,9426,9427,-1,9427,9420,9408,-1,9420,9427,9428,-1,9428,9421,9420,-1,9421,9428,9429,-1,9429,9419,9421,-1,9419,9429,9407,-1,9407,9406,9419,-1,9415,9430,9431,-1,9431,9412,9415,-1,9415,9432,9433,-1,9433,9430,9415,-1,9434,9424,9412,-1,9412,9431,9434,-1,9417,9424,9434,-1,9434,9435,9417,-1,9436,9416,9417,-1,9417,9435,9436,-1,9437,9416,9436,-1,9436,9438,9437,-1,9243,9244,9406,-1,9406,9401,9243,-1,9260,9416,9437,-1,9437,9261,9260,-1,9256,9258,9424,-1,9424,9417,9256,-1,9439,9400,9399,-1,9399,9404,9439,-1,9404,9432,9440,-1,9440,9439,9404,-1,9432,9415,9414,-1,9414,9440,9432,-1,9404,9405,9433,-1,9433,9432,9404,-1,1646,1645,9222,-1,9222,9441,1646,-1,9356,9441,9222,-1,9222,9224,9356,-1,9220,9344,9217,-1,9217,9219,9220,-1,9222,9217,9344,-1,9344,9223,9222,-1,9218,9217,9222,-1,9222,1645,9218,-1,9218,1650,1652,-1,1652,9219,9218,-1,9219,1652,9164,-1,9164,9442,9219,-1,9230,9442,9164,-1,9164,9225,9230,-1,9442,9365,9221,-1,9221,9219,9442,-1,9230,9229,9365,-1,9365,9442,9230,-1,9227,9443,9230,-1,9230,9225,9227,-1,9228,9235,9443,-1,9443,9227,9228,-1,9268,9233,9235,-1,9235,9228,9268,-1,9237,9366,9443,-1,9443,9235,9237,-1,9226,2031,9268,-1,9268,9228,9226,-1,9230,9443,9366,-1,9366,9231,9230,-1,9269,9270,9233,-1,9233,9268,9269,-1,9233,9232,9236,-1,9236,9235,9233,-1,9270,9375,9234,-1,9234,9233,9270,-1,9323,9444,9255,-1,9255,9322,9323,-1,9176,9239,9196,-1,9196,9175,9176,-1,9444,9323,9179,-1,9179,9445,9444,-1,9255,9239,9238,-1,9238,9322,9255,-1,9400,9241,9240,-1,9240,9243,9400,-1,9446,9241,9400,-1,9400,9439,9446,-1,9246,9245,9263,-1,9263,9265,9246,-1,9247,9246,9422,-1,9422,9418,9247,-1,9242,9245,9247,-1,9247,9240,9242,-1,9242,9264,9263,-1,9263,9245,9242,-1,9418,9244,9240,-1,9240,9247,9418,-1,9189,9249,9253,-1,9253,9321,9189,-1,9188,9447,9248,-1,9248,9189,9188,-1,9252,9249,9250,-1,9250,9190,9252,-1,9250,9248,9448,-1,9448,9251,9250,-1,9447,9410,9409,-1,9409,9248,9447,-1,9248,9409,9423,-1,9423,9448,9248,-1,9190,9250,9251,-1,9251,9191,9190,-1,9267,9197,9251,-1,9251,9265,9267,-1,9444,9449,9254,-1,9254,9255,9444,-1,9449,9444,9445,-1,9445,9262,9449,-1,9450,9254,9449,-1,9449,9451,9450,-1,9451,9414,9413,-1,9413,9450,9451,-1,9414,9451,9452,-1,9452,9440,9414,-1,9450,9413,9258,-1,9258,9257,9450,-1,9239,9254,9453,-1,9453,9196,9239,-1,9450,9257,9453,-1,9453,9254,9450,-1,9451,9449,9262,-1,9262,9452,9451,-1,9259,9257,9256,-1,9256,9260,9259,-1,9453,9257,9259,-1,9259,9269,9453,-1,9178,9341,9445,-1,9445,9179,9178,-1,9341,9263,9262,-1,9262,9445,9341,-1,9265,9263,9341,-1,9341,9266,9265,-1,9264,9446,9452,-1,9452,9262,9264,-1,9422,9246,9448,-1,9448,9423,9422,-1,9246,9265,9251,-1,9251,9448,9246,-1,9196,9453,9269,-1,9269,9195,9196,-1,9242,9241,9446,-1,9446,9264,9242,-1,9440,9452,9446,-1,9446,9439,9440,-1,9377,9438,9454,-1,9454,9398,9377,-1,9376,9437,9438,-1,9438,9377,9376,-1,9375,9261,9437,-1,9437,9376,9375,-1,9270,9259,9261,-1,9261,9375,9270,-1,9355,9455,9456,-1,9456,9356,9355,-1,9355,9354,9457,-1,9457,9455,9355,-1,9458,9459,9460,-1,9460,9461,9458,-1,9459,9458,9462,-1,9462,9463,9459,-1,9464,9465,9456,-1,9456,9455,9464,-1,9466,9467,9277,-1,9277,9468,9466,-1,9464,9469,9279,-1,9279,9465,9464,-1,9470,9471,9461,-1,9461,9466,9470,-1,9271,9273,9471,-1,9471,9470,9271,-1,9472,9458,9461,-1,9461,9471,9472,-1,9461,9460,9467,-1,9467,9466,9461,-1,9470,9466,9468,-1,9468,9473,9470,-1,9455,9457,9474,-1,9474,9464,9455,-1,9475,9474,9457,-1,9457,9476,9475,-1,9464,9474,9477,-1,9477,9469,9464,-1,9462,9458,9472,-1,9472,9478,9462,-1,9273,9479,9472,-1,9472,9471,9273,-1,9479,9480,9478,-1,9478,9472,9479,-1,9481,9462,9478,-1,9478,9482,9481,-1,9477,9473,9468,-1,9468,9469,9477,-1,9274,9271,9470,-1,9470,9473,9274,-1,9358,9476,9457,-1,9457,9354,9358,-1,9475,9275,9477,-1,9477,9474,9475,-1,9463,9462,9481,-1,9481,9483,9463,-1,9277,9279,9469,-1,9469,9468,9277,-1,9473,9477,9275,-1,9275,9274,9473,-1,9271,9274,9484,-1,9484,9272,9271,-1,9275,9475,9485,-1,9485,9276,9275,-1,9479,9486,9487,-1,9487,9480,9479,-1,9480,9487,9488,-1,9488,9489,9480,-1,9479,9273,9272,-1,9272,9486,9479,-1,9490,9388,9387,-1,9387,9491,9490,-1,9388,9490,9476,-1,9476,9358,9388,-1,9490,9491,9492,-1,9492,9485,9490,-1,9276,9485,9492,-1,9492,9493,9276,-1,9276,9493,9484,-1,9484,9274,9276,-1,9485,9475,9476,-1,9476,9490,9485,-1,9494,9495,9496,-1,9496,9497,9494,-1,9498,9494,9497,-1,9497,9499,9498,-1,9494,9498,9500,-1,9500,9501,9494,-1,9502,9503,9499,-1,9499,9497,9502,-1,9496,9504,9502,-1,9502,9497,9496,-1,9502,9504,9505,-1,9505,9506,9502,-1,9506,9507,9503,-1,9503,9502,9506,-1,9508,9509,9507,-1,9507,9506,9508,-1,9508,9510,9511,-1,9511,9512,9508,-1,9513,9514,9515,-1,9515,9516,9513,-1,9505,9510,9508,-1,9508,9506,9505,-1,9411,9410,9514,-1,9514,9513,9411,-1,9494,9501,9285,-1,9285,9495,9494,-1,9512,9481,9482,-1,9482,9517,9512,-1,9512,9517,9509,-1,9509,9508,9512,-1,9518,9501,9500,-1,9500,9519,9518,-1,9518,9519,9520,-1,9520,9521,9518,-1,9522,9521,9520,-1,9520,9523,9522,-1,9521,9524,9283,-1,9283,9518,9521,-1,9522,9523,9525,-1,9525,9526,9522,-1,9516,9526,9525,-1,9525,9527,9516,-1,9526,9528,9529,-1,9529,9522,9526,-1,9530,9425,9411,-1,9411,9513,9530,-1,9530,9513,9516,-1,9516,9527,9530,-1,9283,9285,9501,-1,9501,9518,9283,-1,9511,9483,9481,-1,9481,9512,9511,-1,9515,9528,9526,-1,9526,9516,9515,-1,9529,9524,9521,-1,9521,9522,9529,-1,1646,9441,9289,-1,9289,1751,1646,-1,9441,9356,9456,-1,9456,9289,9441,-1,2175,1751,9289,-1,9289,9291,2175,-1,9465,9290,9289,-1,9289,9456,9465,-1,9460,9459,9531,-1,9531,9532,9460,-1,9531,9459,9463,-1,9463,9342,9531,-1,9533,9534,9532,-1,9532,9531,9533,-1,9535,9467,9460,-1,9460,9532,9535,-1,2177,2179,9536,-1,9536,9534,2177,-1,9536,2179,2181,-1,2181,9537,9536,-1,2177,9534,9533,-1,9533,2173,2177,-1,9538,9342,9463,-1,9463,9483,9538,-1,9533,9531,9342,-1,9342,1741,9533,-1,1747,2173,9533,-1,9533,1741,1747,-1,9537,2181,2175,-1,2175,9291,9537,-1,9467,9535,9278,-1,9278,9277,9467,-1,9279,9278,9290,-1,9290,9465,9279,-1,9495,9539,9540,-1,9540,9496,9495,-1,9284,9539,9495,-1,9495,9285,9284,-1,9339,9329,9541,-1,9541,9542,9339,-1,9543,9504,9496,-1,9496,9540,9543,-1,9544,9545,9515,-1,9515,9514,9544,-1,9447,9188,9280,-1,9280,9544,9447,-1,9282,9281,9331,-1,9331,9546,9282,-1,9546,9331,9334,-1,9334,9547,9546,-1,9548,9549,9529,-1,9529,9528,9548,-1,9547,9334,9338,-1,9338,9550,9547,-1,9550,9338,9551,-1,9551,9552,9550,-1,9553,9284,9283,-1,9283,9524,9553,-1,9551,9338,9337,-1,9337,9343,9551,-1,9542,9552,9551,-1,9551,9339,9542,-1,9541,9329,2160,-1,2160,9554,9541,-1,9554,2160,2156,-1,2156,9555,9554,-1,9556,9505,9504,-1,9504,9543,9556,-1,9555,2156,2076,-1,2076,9288,9555,-1,9505,9556,9287,-1,9287,9510,9505,-1,9510,9287,9557,-1,9557,9511,9510,-1,9483,9511,9557,-1,9557,9538,9483,-1,9544,9514,9410,-1,9410,9447,9544,-1,9528,9515,9545,-1,9545,9548,9528,-1,9339,9551,9343,-1,9343,9340,9339,-1,9524,9529,9549,-1,9549,9553,9524,-1,9282,9545,9544,-1,9544,9280,9282,-1,9546,9548,9545,-1,9545,9282,9546,-1,9547,9549,9548,-1,9548,9546,9547,-1,9550,9553,9549,-1,9549,9547,9550,-1,9552,9284,9553,-1,9553,9550,9552,-1,9542,9539,9284,-1,9284,9552,9542,-1,9541,9540,9539,-1,9539,9542,9541,-1,9554,9543,9540,-1,9540,9541,9554,-1,9555,9556,9543,-1,9543,9554,9555,-1,9288,9287,9556,-1,9556,9555,9288,-1,9335,9557,9287,-1,9287,9286,9335,-1,9336,9538,9557,-1,9557,9335,9336,-1,9320,9342,9538,-1,9538,9336,9320,-1,9536,9535,9532,-1,9532,9534,9536,-1,9537,9278,9535,-1,9535,9536,9537,-1,9291,9290,9278,-1,9278,9537,9291,-1,9489,9482,9478,-1,9478,9480,9489,-1,9558,9559,9560,-1,9561,9562,9559,-1,9563,9564,9565,-1,9564,9558,9560,-1,9566,9567,9568,-1,9569,9570,9571,-1,9569,9572,9570,-1,9571,9573,9569,-1,9574,9575,9576,-1,9575,9574,9577,-1,9578,9579,9580,-1,9581,9582,9583,-1,9584,9585,9582,-1,9583,9582,9585,-1,9586,9582,9587,-1,9588,9589,9583,-1,9590,9591,9592,-1,9593,9594,9595,-1,9596,9597,9598,-1,9599,9581,9600,-1,9569,9573,9596,-1,9597,9596,9573,-1,9601,9602,9603,-1,9604,9605,9606,-1,9607,9608,9609,-1,9610,9611,9612,-1,9613,9614,9615,-1,9616,9617,9618,-1,9612,9619,9620,-1,9621,9622,9623,-1,9624,9625,9626,-1,9627,9628,9629,-1,9630,9631,9632,-1,9633,9634,9635,-1,9636,9637,9638,-1,9639,9640,9641,-1,9642,9643,9644,-1,9645,9646,9647,-1,9648,9649,9650,-1,9651,9652,9653,-1,9654,9621,9655,-1,9656,9657,9651,-1,9658,9659,9660,-1,9661,9662,9663,-1,9664,9665,9666,-1,9667,9668,9669,-1,9670,9671,9672,-1,9673,9674,9675,-1,9676,9677,9678,-1,9679,9680,9667,-1,9681,9682,9679,-1,9683,9684,9685,-1,9686,9687,9688,-1,9689,9690,9691,-1,9692,9693,9694,-1,9692,9630,9695,-1,9696,9697,9698,-1,9670,9699,9700,-1,9673,9701,9700,-1,9702,9703,9704,-1,9705,9706,9707,-1,9708,9709,9710,-1,9519,9500,9711,-1,9712,9713,9566,-1,9566,9714,9712,-1,9713,9712,9715,-1,9715,9716,9713,-1,9568,9717,9714,-1,9714,9566,9568,-1,9571,9712,9714,-1,9714,9718,9571,-1,9719,9720,9721,-1,9721,9722,9719,-1,9723,9618,9720,-1,9720,9719,9723,-1,9720,9724,9725,-1,9725,9721,9720,-1,9722,9721,9726,-1,9726,9727,9722,-1,9728,9719,9722,-1,9722,9729,9728,-1,9730,9560,9559,-1,9559,9562,9730,-1,9560,9730,9565,-1,9565,9564,9560,-1,9730,9562,9731,-1,9731,9732,9730,-1,9732,9716,9565,-1,9565,9730,9732,-1,9733,9734,9618,-1,9618,9723,9733,-1,9618,9617,9724,-1,9724,9720,9618,-1,9735,9723,9719,-1,9719,9728,9735,-1,9736,9737,9734,-1,9734,9733,9736,-1,9618,9734,9738,-1,9738,9616,9618,-1,9721,9725,9739,-1,9739,9726,9721,-1,9727,9726,9717,-1,9717,9568,9727,-1,9727,9740,9729,-1,9729,9722,9727,-1,9726,9739,9741,-1,9741,9717,9726,-1,9567,9740,9727,-1,9727,9568,9567,-1,9717,9741,9718,-1,9718,9714,9717,-1,9712,9571,9576,-1,9576,9715,9712,-1,9715,9563,9565,-1,9565,9716,9715,-1,9564,9563,9742,-1,9742,9558,9564,-1,9743,9731,9562,-1,9562,9561,9743,-1,9559,9558,9744,-1,9744,9561,9559,-1,9731,9743,9745,-1,9745,9746,9731,-1,9743,9747,9748,-1,9748,9745,9743,-1,9749,9746,9745,-1,9745,9750,9749,-1,9749,9750,9751,-1,9751,9644,9749,-1,9750,9752,9753,-1,9753,9751,9750,-1,9644,9751,9754,-1,9754,9647,9644,-1,9751,9753,9755,-1,9755,9754,9751,-1,9650,9647,9754,-1,9754,9756,9650,-1,9757,9758,9759,-1,9759,9760,9757,-1,9620,9619,9758,-1,9758,9757,9620,-1,9759,9758,9761,-1,9761,9762,9759,-1,9756,9757,9760,-1,9760,9650,9756,-1,9758,9619,9763,-1,9763,9761,9758,-1,9762,9761,9764,-1,9764,9765,9762,-1,9761,9763,9766,-1,9766,9764,9761,-1,9767,9765,9764,-1,9764,9768,9767,-1,9736,9767,9768,-1,9768,9737,9736,-1,9737,9769,9738,-1,9738,9734,9737,-1,9764,9766,9770,-1,9770,9768,9764,-1,9756,9754,9755,-1,9755,9771,9756,-1,9743,9561,9744,-1,9744,9747,9743,-1,9715,9576,9742,-1,9742,9563,9715,-1,9750,9745,9748,-1,9748,9752,9750,-1,9771,9620,9757,-1,9757,9756,9771,-1,9737,9768,9770,-1,9770,9769,9737,-1,9571,9570,9574,-1,9574,9576,9571,-1,9576,9575,9772,-1,9772,9742,9576,-1,9579,9773,9774,-1,9774,9580,9579,-1,9775,9773,9579,-1,9579,9605,9775,-1,9773,9776,9777,-1,9777,9774,9773,-1,9778,9779,9580,-1,9580,9774,9778,-1,9591,9780,9781,-1,9781,9782,9591,-1,9595,9783,9780,-1,9780,9591,9595,-1,9784,9782,9781,-1,9781,9785,9784,-1,9782,9786,9592,-1,9592,9591,9782,-1,9787,9788,9584,-1,9584,9789,9787,-1,9788,9787,9790,-1,9790,9791,9788,-1,9792,9585,9584,-1,9584,9788,9792,-1,9582,9586,9789,-1,9789,9584,9582,-1,9793,9794,9787,-1,9787,9789,9793,-1,9787,9794,9795,-1,9795,9790,9787,-1,9788,9791,9796,-1,9796,9792,9788,-1,9585,9792,9797,-1,9797,9798,9585,-1,9789,9586,9799,-1,9799,9793,9789,-1,9800,9795,9794,-1,9794,9801,9800,-1,9598,9801,9794,-1,9794,9793,9598,-1,9802,9801,9598,-1,9598,9803,9802,-1,9596,9598,9793,-1,9793,9799,9596,-1,9572,9799,9586,-1,9586,9587,9572,-1,9797,9792,9796,-1,9796,9804,9797,-1,9805,9797,9804,-1,9804,9806,9805,-1,9797,9805,9807,-1,9807,9798,9797,-1,9808,9809,9807,-1,9807,9805,9808,-1,9810,9588,9798,-1,9798,9807,9810,-1,9588,9583,9585,-1,9585,9798,9588,-1,9805,9806,9811,-1,9811,9808,9805,-1,9809,9808,9812,-1,9812,9813,9809,-1,9814,9810,9807,-1,9807,9809,9814,-1,9588,9810,9577,-1,9577,9589,9588,-1,9778,9803,9815,-1,9815,9779,9778,-1,9816,9802,9803,-1,9803,9778,9816,-1,9597,9815,9803,-1,9803,9598,9597,-1,9817,9818,9779,-1,9779,9815,9817,-1,9819,9820,9802,-1,9802,9816,9819,-1,9774,9777,9816,-1,9816,9778,9774,-1,9801,9802,9820,-1,9820,9800,9801,-1,9819,9816,9777,-1,9777,9821,9819,-1,9773,9775,9822,-1,9822,9776,9773,-1,9821,9777,9776,-1,9776,9823,9821,-1,9818,9578,9580,-1,9580,9779,9818,-1,9824,9825,9826,-1,9826,9827,9824,-1,9828,9829,9830,-1,9830,9831,9828,-1,9830,9827,9826,-1,9826,9831,9830,-1,9827,9830,9832,-1,9832,9833,9827,-1,9811,9834,9812,-1,9812,9808,9811,-1,9824,9812,9834,-1,9834,9825,9824,-1,9835,9813,9812,-1,9812,9824,9835,-1,9836,9837,9838,-1,9838,9839,9836,-1,9837,9836,9840,-1,9840,9841,9837,-1,9837,9842,9843,-1,9843,9838,9837,-1,9844,9845,9839,-1,9839,9838,9844,-1,9846,9847,9836,-1,9836,9839,9846,-1,9840,9836,9847,-1,9847,9848,9840,-1,9842,9837,9841,-1,9841,9849,9842,-1,9850,9851,9843,-1,9843,9842,9850,-1,9608,9844,9838,-1,9838,9843,9608,-1,9852,9845,9844,-1,9844,9853,9852,-1,9845,9854,9846,-1,9846,9839,9845,-1,9855,9848,9847,-1,9847,9856,9855,-1,9846,9857,9856,-1,9856,9847,9846,-1,9857,9846,9854,-1,9854,9858,9857,-1,9856,9857,9859,-1,9859,9829,9856,-1,9852,9860,9854,-1,9854,9845,9852,-1,9861,9850,9842,-1,9842,9849,9861,-1,9862,9851,9850,-1,9850,9863,9862,-1,9609,9608,9843,-1,9843,9851,9609,-1,9844,9608,9607,-1,9607,9853,9844,-1,9864,9865,9866,-1,9866,9867,9864,-1,9868,9864,9867,-1,9867,9869,9868,-1,9870,9865,9864,-1,9864,9871,9870,-1,9865,9872,9873,-1,9873,9866,9865,-1,9873,9872,9863,-1,9863,9874,9873,-1,9870,9875,9872,-1,9872,9865,9870,-1,9876,9611,9875,-1,9875,9870,9876,-1,9862,9863,9872,-1,9872,9875,9862,-1,9864,9868,9877,-1,9877,9871,9864,-1,9878,9879,9877,-1,9877,9868,9878,-1,9880,9881,9871,-1,9871,9877,9880,-1,9881,9876,9870,-1,9870,9871,9881,-1,9882,9876,9881,-1,9881,9883,9882,-1,9875,9611,9610,-1,9610,9862,9875,-1,9882,9612,9611,-1,9611,9876,9882,-1,9868,9869,9884,-1,9884,9878,9868,-1,9879,9878,9595,-1,9595,9594,9879,-1,9880,9877,9879,-1,9879,9885,9880,-1,9881,9880,9886,-1,9886,9883,9881,-1,9595,9878,9884,-1,9884,9783,9595,-1,9595,9591,9590,-1,9590,9593,9595,-1,9593,9590,9887,-1,9887,9888,9593,-1,9889,9885,9879,-1,9879,9594,9889,-1,9890,9885,9889,-1,9889,9891,9890,-1,9888,9889,9594,-1,9594,9593,9888,-1,9830,9829,9859,-1,9859,9832,9830,-1,9859,9892,9893,-1,9893,9832,9859,-1,9893,9615,9833,-1,9833,9832,9893,-1,9893,9894,9613,-1,9613,9615,9893,-1,9615,9614,9835,-1,9835,9833,9615,-1,9835,9824,9827,-1,9827,9833,9835,-1,9614,9895,9813,-1,9813,9835,9614,-1,9613,9772,9895,-1,9895,9614,9613,-1,9813,9895,9814,-1,9814,9809,9813,-1,9860,9896,9858,-1,9858,9854,9860,-1,9857,9858,9892,-1,9892,9859,9857,-1,9855,9856,9829,-1,9829,9828,9855,-1,9896,9897,9892,-1,9892,9858,9896,-1,9851,9862,9610,-1,9610,9609,9851,-1,9612,9607,9609,-1,9609,9610,9612,-1,9861,9874,9863,-1,9863,9850,9861,-1,9898,9823,9776,-1,9776,9822,9898,-1,9784,9785,9898,-1,9898,9822,9784,-1,9899,9784,9822,-1,9822,9775,9899,-1,9605,9579,9578,-1,9578,9606,9605,-1,9775,9605,9604,-1,9604,9899,9775,-1,9899,9786,9782,-1,9782,9784,9899,-1,9815,9597,9573,-1,9573,9817,9815,-1,9887,9590,9592,-1,9592,9602,9887,-1,9888,9887,9900,-1,9900,9901,9888,-1,9603,9602,9592,-1,9592,9786,9603,-1,9887,9602,9601,-1,9601,9900,9887,-1,9786,9899,9604,-1,9604,9603,9786,-1,9606,9601,9603,-1,9603,9604,9606,-1,9814,9575,9577,-1,9577,9810,9814,-1,9897,9894,9893,-1,9893,9892,9897,-1,9574,9600,9589,-1,9589,9577,9574,-1,9589,9600,9581,-1,9581,9583,9589,-1,9772,9575,9814,-1,9814,9895,9772,-1,9600,9574,9570,-1,9570,9599,9600,-1,9581,9599,9587,-1,9587,9582,9581,-1,9587,9599,9570,-1,9570,9572,9587,-1,9569,9596,9799,-1,9799,9572,9569,-1,9739,9578,9818,-1,9818,9741,9739,-1,9571,9718,9817,-1,9817,9573,9571,-1,9617,9900,9601,-1,9601,9724,9617,-1,9901,9900,9617,-1,9617,9616,9901,-1,9901,9891,9889,-1,9889,9888,9901,-1,9752,9860,9852,-1,9852,9753,9752,-1,9771,9755,9853,-1,9853,9607,9771,-1,9752,9748,9896,-1,9896,9860,9752,-1,9619,9612,9882,-1,9882,9763,9619,-1,9890,9886,9880,-1,9880,9885,9890,-1,9766,9883,9886,-1,9886,9770,9766,-1,9769,9770,9886,-1,9886,9890,9769,-1,9747,9897,9896,-1,9896,9748,9747,-1,9747,9744,9894,-1,9894,9897,9747,-1,9741,9818,9817,-1,9817,9718,9741,-1,9725,9606,9578,-1,9578,9739,9725,-1,9724,9601,9606,-1,9606,9725,9724,-1,9616,9738,9891,-1,9891,9901,9616,-1,9558,9742,9772,-1,9772,9613,9558,-1,9558,9613,9894,-1,9894,9744,9558,-1,9753,9852,9853,-1,9853,9755,9753,-1,9763,9882,9883,-1,9883,9766,9763,-1,9769,9890,9891,-1,9891,9738,9769,-1,9607,9612,9620,-1,9620,9771,9607,-1,9740,9628,9627,-1,9627,9729,9740,-1,9729,9627,9639,-1,9639,9728,9729,-1,9713,9902,9567,-1,9567,9566,9713,-1,9903,9733,9723,-1,9723,9735,9903,-1,9902,9713,9716,-1,9716,9904,9902,-1,9905,9731,9746,-1,9746,9906,9905,-1,9643,9907,9749,-1,9749,9644,9643,-1,9644,9647,9646,-1,9646,9642,9644,-1,9760,9759,9908,-1,9908,9909,9760,-1,9908,9759,9762,-1,9762,9910,9908,-1,9910,9762,9765,-1,9765,9653,9910,-1,9911,9736,9733,-1,9733,9903,9911,-1,9912,9653,9765,-1,9765,9767,9912,-1,9645,9647,9650,-1,9650,9649,9645,-1,9913,9732,9731,-1,9731,9905,9913,-1,9904,9716,9732,-1,9732,9913,9904,-1,9746,9749,9907,-1,9907,9906,9746,-1,9650,9760,9909,-1,9909,9648,9650,-1,9767,9736,9911,-1,9911,9912,9767,-1,9623,9622,9914,-1,9914,9915,9623,-1,9916,9657,9623,-1,9623,9915,9916,-1,9917,9918,9652,-1,9652,9916,9917,-1,9917,9919,9920,-1,9920,9918,9917,-1,9626,9921,9922,-1,9922,9624,9626,-1,9642,9923,9676,-1,9676,9924,9642,-1,9637,9905,9906,-1,9906,9691,9637,-1,9635,9636,9638,-1,9638,9633,9635,-1,9646,9645,9925,-1,9925,9926,9646,-1,9645,9649,9927,-1,9927,9925,9645,-1,9649,9648,9626,-1,9626,9927,9649,-1,9921,9920,9919,-1,9919,9922,9921,-1,9909,9908,9920,-1,9920,9921,9909,-1,9920,9908,9910,-1,9910,9918,9920,-1,9928,9929,9930,-1,9930,9632,9928,-1,9931,9932,9631,-1,9631,9933,9931,-1,9934,9935,9932,-1,9932,9931,9934,-1,9936,9937,9935,-1,9935,9934,9936,-1,9657,9916,9652,-1,9652,9651,9657,-1,9656,9621,9623,-1,9623,9657,9656,-1,9938,9622,9621,-1,9621,9654,9938,-1,9654,9939,9940,-1,9940,9938,9654,-1,9923,9642,9646,-1,9646,9926,9923,-1,9642,9924,9683,-1,9683,9643,9642,-1,9941,9942,9655,-1,9655,9943,9941,-1,9641,9640,9942,-1,9942,9941,9641,-1,9655,9942,9944,-1,9944,9945,9655,-1,9943,9655,9621,-1,9621,9656,9943,-1,9911,9903,9941,-1,9941,9943,9911,-1,9628,9946,9947,-1,9947,9629,9628,-1,9628,9740,9567,-1,9567,9946,9628,-1,9948,9947,9946,-1,9946,9949,9948,-1,9950,9951,9629,-1,9629,9947,9950,-1,9946,9567,9902,-1,9902,9949,9946,-1,9941,9903,9735,-1,9735,9641,9941,-1,9912,9911,9943,-1,9943,9656,9912,-1,9656,9651,9653,-1,9653,9912,9656,-1,9952,9701,9953,-1,9953,9954,9952,-1,9907,9643,9683,-1,9683,9686,9907,-1,9634,9633,9929,-1,9929,9928,9634,-1,9948,9634,9928,-1,9928,9955,9948,-1,9949,9635,9634,-1,9634,9948,9949,-1,9951,9950,9932,-1,9932,9935,9951,-1,9951,9956,9957,-1,9957,9629,9951,-1,9947,9948,9955,-1,9955,9950,9947,-1,9956,9951,9935,-1,9935,9937,9956,-1,9957,9956,9954,-1,9954,9958,9957,-1,9629,9957,9639,-1,9639,9627,9629,-1,9632,9631,9955,-1,9955,9928,9632,-1,9636,9913,9905,-1,9905,9637,9636,-1,9932,9950,9955,-1,9955,9631,9932,-1,9918,9910,9653,-1,9653,9652,9918,-1,9945,9959,9960,-1,9960,9939,9945,-1,9944,9953,9959,-1,9959,9945,9944,-1,9655,9945,9939,-1,9939,9654,9655,-1,9961,9959,9953,-1,9953,9701,9961,-1,9639,9957,9958,-1,9958,9640,9639,-1,9942,9640,9958,-1,9958,9944,9942,-1,9952,9954,9956,-1,9956,9937,9952,-1,9949,9902,9904,-1,9904,9635,9949,-1,9635,9904,9913,-1,9913,9636,9635,-1,9686,9691,9906,-1,9906,9907,9686,-1,9728,9639,9641,-1,9641,9735,9728,-1,9648,9909,9921,-1,9921,9626,9648,-1,9944,9958,9954,-1,9954,9953,9944,-1,9380,9379,9962,-1,9962,9963,9380,-1,9963,9964,9382,-1,9382,9380,9963,-1,9965,9387,9386,-1,9386,9966,9965,-1,9967,9392,9391,-1,9391,9968,9967,-1,9967,9969,9396,-1,9396,9392,9967,-1,9970,9384,9396,-1,9396,9969,9970,-1,9965,9708,9491,-1,9491,9387,9965,-1,9492,9710,9705,-1,9705,9493,9492,-1,9484,9707,9971,-1,9971,9272,9484,-1,9971,9972,9486,-1,9486,9272,9971,-1,9968,9391,9394,-1,9394,9973,9968,-1,9397,9378,9398,-1,9398,9974,9397,-1,9708,9710,9492,-1,9492,9491,9708,-1,9705,9707,9484,-1,9484,9493,9705,-1,9973,9394,9397,-1,9397,9974,9973,-1,9966,9386,9382,-1,9382,9964,9966,-1,9384,9970,9962,-1,9962,9379,9384,-1,9486,9972,9975,-1,9975,9487,9486,-1,9976,9977,9978,-1,9978,9979,9976,-1,9523,9977,9976,-1,9976,9525,9523,-1,9704,9978,9977,-1,9977,9980,9704,-1,9981,9982,9979,-1,9979,9978,9981,-1,9983,9976,9979,-1,9979,9984,9983,-1,9985,9702,9704,-1,9704,9980,9985,-1,9519,9985,9980,-1,9980,9520,9519,-1,9984,9986,9987,-1,9987,9983,9984,-1,9527,9983,9987,-1,9987,9530,9527,-1,9988,9989,9990,-1,9990,9991,9988,-1,9992,9993,9994,-1,9994,9995,9992,-1,9403,9668,9996,-1,9996,9402,9403,-1,9997,9998,9999,-1,9999,10000,9997,-1,9999,9998,9992,-1,9992,9995,9999,-1,9991,9990,10001,-1,10001,9711,9991,-1,10002,10003,9426,-1,9426,9425,10002,-1,9426,10003,10004,-1,10004,9427,9426,-1,10004,10005,9428,-1,9428,9427,10004,-1,9428,10005,10006,-1,10006,9429,9428,-1,9429,10006,10007,-1,10007,9407,9429,-1,10008,10009,9431,-1,9431,9430,10008,-1,9431,10009,10010,-1,10010,9434,9431,-1,10011,10012,9436,-1,9436,9435,10011,-1,9994,9993,9989,-1,9989,9988,9994,-1,9407,10007,9668,-1,9668,9403,9407,-1,9525,9976,9983,-1,9983,9527,9525,-1,9977,9523,9520,-1,9520,9980,9977,-1,9979,9982,10013,-1,10013,9984,9979,-1,9981,9978,9704,-1,9704,10014,9981,-1,9438,9436,10012,-1,10012,9454,9438,-1,10011,9435,9434,-1,9434,10010,10011,-1,10002,9425,9530,-1,9530,9987,10002,-1,9997,10000,9489,-1,9489,9488,9997,-1,9519,9711,10001,-1,10001,9985,9519,-1,10015,9405,9402,-1,9402,9996,10015,-1,10016,9433,9405,-1,9405,10015,10016,-1,10008,9430,9433,-1,9433,10016,10008,-1,10017,10005,10004,-1,10004,10018,10017,-1,10004,10003,10019,-1,10019,10018,10004,-1,10017,10020,10006,-1,10006,10005,10017,-1,10021,9669,9668,-1,9668,10007,10021,-1,10020,10021,10007,-1,10007,10006,10020,-1,10022,10001,9990,-1,9990,10023,10022,-1,9488,9487,9975,-1,9975,10024,9488,-1,10012,10011,9662,-1,9662,9661,10012,-1,10010,10009,10025,-1,10025,10026,10010,-1,10008,10027,10025,-1,10025,10009,10008,-1,10003,10002,10028,-1,10028,10019,10003,-1,9997,10029,10030,-1,10030,9998,9997,-1,10030,10031,9992,-1,9992,9998,10030,-1,9667,10032,9996,-1,9996,9668,9667,-1,10031,10033,9993,-1,9993,9992,10031,-1,9989,9993,10033,-1,10033,10034,9989,-1,9989,10034,10023,-1,10023,9990,9989,-1,10035,10036,10037,-1,10037,10038,10035,-1,10039,10036,10035,-1,10035,10040,10039,-1,10041,10038,10037,-1,10037,10042,10041,-1,10035,10038,9672,-1,9672,9671,10035,-1,10035,9671,10043,-1,10043,10040,10035,-1,10044,10039,10040,-1,10040,10045,10044,-1,10042,10046,10047,-1,10047,10041,10042,-1,10048,10049,10047,-1,10047,10046,10048,-1,10047,10050,10051,-1,10051,10041,10047,-1,10050,10047,10049,-1,10049,10052,10050,-1,9674,9699,10051,-1,10051,10050,9674,-1,9672,10038,10041,-1,10041,10051,9672,-1,9709,10053,10054,-1,10054,10055,9709,-1,10045,10054,10053,-1,10053,10044,10045,-1,10056,10054,10045,-1,10045,10057,10056,-1,10058,10059,10060,-1,10060,10061,10058,-1,9702,9985,10001,-1,10001,10022,9702,-1,10058,10062,10063,-1,10063,10059,10058,-1,9703,10060,10059,-1,10059,10064,9703,-1,10065,10058,10061,-1,10061,10066,10065,-1,10065,10066,10067,-1,10067,10068,10065,-1,10058,10065,10069,-1,10069,10062,10058,-1,10067,10070,10071,-1,10071,10068,10067,-1,10071,10070,10072,-1,10072,10073,10071,-1,10072,10074,10075,-1,10075,10073,10072,-1,10076,10071,10073,-1,10073,10077,10076,-1,10076,10078,10068,-1,10068,10071,10076,-1,9659,9658,10079,-1,10079,10080,9659,-1,10024,10029,9997,-1,9997,9488,10024,-1,9658,10075,10074,-1,10074,10079,9658,-1,10073,10075,10081,-1,10081,10077,10073,-1,10064,10014,9704,-1,9704,9703,10064,-1,9986,9984,10013,-1,10013,10082,9986,-1,9987,9986,10028,-1,10028,10002,9987,-1,10083,10084,10052,-1,10052,10049,10083,-1,10050,10052,9675,-1,9675,9674,10050,-1,10083,10049,10048,-1,10048,10085,10083,-1,10083,10086,10087,-1,10087,10084,10083,-1,10083,10085,10088,-1,10088,10086,10083,-1,9663,10087,10086,-1,10086,9661,9663,-1,10089,10090,10084,-1,10084,10087,10089,-1,10056,10091,10055,-1,10055,10054,10056,-1,9706,9709,10055,-1,10055,10092,9706,-1,10091,10093,10092,-1,10092,10055,10091,-1,10094,9706,10092,-1,10092,10095,10094,-1,10093,10096,10095,-1,10095,10092,10093,-1,10097,10094,10095,-1,10095,10098,10097,-1,10096,10099,10098,-1,10098,10095,10096,-1,10098,9659,10080,-1,10080,10097,10098,-1,10010,10026,9662,-1,9662,10011,10010,-1,9664,9663,9662,-1,9662,10026,9664,-1,10100,9454,10012,-1,10012,9661,10100,-1,10100,9661,10086,-1,10086,10088,10100,-1,10090,10089,10101,-1,10101,10102,10090,-1,10090,9675,10052,-1,10052,10084,10090,-1,9664,10089,10087,-1,10087,9663,9664,-1,10103,10027,10008,-1,10008,10016,10103,-1,9665,10025,10027,-1,10027,10104,9665,-1,9665,9664,10026,-1,10026,10025,9665,-1,10017,10018,10105,-1,10105,10106,10017,-1,10018,10019,10107,-1,10107,10105,10018,-1,10105,10108,10109,-1,10109,10106,10105,-1,10020,10017,10106,-1,10106,10110,10020,-1,10109,10111,10110,-1,10110,10106,10109,-1,10021,10020,10110,-1,10110,10112,10021,-1,10111,10113,10112,-1,10112,10110,10111,-1,9669,10021,10112,-1,10112,10114,9669,-1,10082,10013,10115,-1,10115,10116,10082,-1,10082,10117,10028,-1,10028,9986,10082,-1,10019,10028,10117,-1,10117,10107,10019,-1,10107,10117,10118,-1,10118,10119,10107,-1,10108,10105,10107,-1,10107,10119,10108,-1,10065,10068,10078,-1,10078,10069,10065,-1,9679,9667,9669,-1,9669,10114,9679,-1,9996,10032,10120,-1,10120,10015,9996,-1,10032,10121,10122,-1,10122,10120,10032,-1,10103,10016,10015,-1,10015,10120,10103,-1,9660,10081,10075,-1,10075,9658,9660,-1,10123,10124,10077,-1,10077,10081,10123,-1,10098,10099,9660,-1,9660,9659,10098,-1,9660,10099,9694,-1,9694,9693,9660,-1,10096,10125,9694,-1,9694,10099,10096,-1,10057,10045,10040,-1,10040,10043,10057,-1,10082,10116,10118,-1,10118,10117,10082,-1,10126,10064,10059,-1,10059,10063,10126,-1,10103,10127,10104,-1,10104,10027,10103,-1,9665,10104,10128,-1,10128,9666,9665,-1,9664,9666,10101,-1,10101,10089,9664,-1,10103,10120,10122,-1,10122,10127,10103,-1,10032,9667,9680,-1,9680,10121,10032,-1,9693,10123,10081,-1,10081,9660,9693,-1,9672,10051,9699,-1,9699,9670,9672,-1,10043,9671,9670,-1,9670,9697,10043,-1,9670,9700,9698,-1,9698,9697,9670,-1,10057,10043,9697,-1,9697,9696,10057,-1,10056,10129,10130,-1,10130,10091,10056,-1,9696,10129,10056,-1,10056,10057,9696,-1,10129,9696,9698,-1,9698,9936,10129,-1,9981,10131,10132,-1,10132,9982,9981,-1,10102,9961,9675,-1,9675,10090,10102,-1,10101,10133,9960,-1,9960,10102,10101,-1,10101,9666,10128,-1,10128,10133,10101,-1,9960,10133,9940,-1,9940,9939,9960,-1,10102,9960,9959,-1,9959,9961,10102,-1,10119,9677,10134,-1,10134,10108,10119,-1,10109,10108,10134,-1,10134,10135,10109,-1,9923,9926,10135,-1,10135,10134,9923,-1,10109,10135,10136,-1,10136,10111,10109,-1,9926,9925,10136,-1,10136,10135,9926,-1,10111,10136,10137,-1,10137,10113,10111,-1,10113,10138,10114,-1,10114,10112,10113,-1,9925,9927,10137,-1,10137,10136,9925,-1,10113,10137,9625,-1,9625,10138,10113,-1,9681,9679,10114,-1,10114,10138,9681,-1,10064,10126,10139,-1,10139,10014,10064,-1,9982,10132,10115,-1,10115,10013,9982,-1,9685,9684,10115,-1,10115,10132,9685,-1,9684,10140,10116,-1,10116,10115,9684,-1,10140,9684,9683,-1,9683,9924,10140,-1,10118,10116,10140,-1,10140,9678,10118,-1,9678,9677,10119,-1,10119,10118,9678,-1,10063,9690,9689,-1,9689,10126,10063,-1,10139,10126,9689,-1,9689,9688,10139,-1,9688,9689,9691,-1,9691,9686,9688,-1,10139,9688,9687,-1,9687,10131,10139,-1,10131,9981,10014,-1,10014,10139,10131,-1,10132,10131,9687,-1,9687,9685,10132,-1,9685,9687,9686,-1,9686,9683,9685,-1,10141,9914,9622,-1,9622,9938,10141,-1,9915,9914,10121,-1,10121,10142,9915,-1,10141,10122,10121,-1,10121,9914,10141,-1,10122,10141,10143,-1,10143,10127,10122,-1,10121,9680,10144,-1,10144,10142,10121,-1,9679,9682,10144,-1,10144,9680,9679,-1,9917,10142,10144,-1,10144,9919,9917,-1,9915,10142,9917,-1,9917,9916,9915,-1,9922,9919,10144,-1,10144,9682,9922,-1,10143,10128,10104,-1,10104,10127,10143,-1,9927,9626,9625,-1,9625,10137,9927,-1,9624,9681,10138,-1,10138,9625,9624,-1,10143,9940,10133,-1,10133,10128,10143,-1,9624,9922,9682,-1,9682,9681,9624,-1,9676,9678,10140,-1,10140,9924,9676,-1,9677,9676,9923,-1,9923,10134,9677,-1,9637,9691,9690,-1,9690,10145,9637,-1,10062,10145,9690,-1,9690,10063,10062,-1,9638,9637,10145,-1,10145,10146,9638,-1,10062,10069,10146,-1,10146,10145,10062,-1,10078,10147,10146,-1,10146,10069,10078,-1,10146,10147,9633,-1,9633,9638,10146,-1,9633,10147,10148,-1,10148,9929,9633,-1,10078,10076,10148,-1,10148,10147,10078,-1,10148,10076,10077,-1,10077,10124,10148,-1,10148,10124,9930,-1,9930,9929,10148,-1,10124,10123,9695,-1,9695,9930,10124,-1,10093,10149,10125,-1,10125,10096,10093,-1,10125,9933,9692,-1,9692,9694,10125,-1,10091,10130,10149,-1,10149,10093,10091,-1,10125,10149,9931,-1,9931,9933,10125,-1,10149,10130,9934,-1,9934,9931,10149,-1,10130,10129,9936,-1,9936,9934,10130,-1,10123,9693,9692,-1,9692,9695,10123,-1,9930,9695,9630,-1,9630,9632,9930,-1,9673,9700,9699,-1,9699,9674,9673,-1,9940,10143,10141,-1,10141,9938,9940,-1,9675,9961,9701,-1,9701,9673,9675,-1,9700,9701,9952,-1,9952,9698,9700,-1,9698,9952,9937,-1,9937,9936,9698,-1,9631,9630,9692,-1,9692,9933,9631,-1,10022,10060,9703,-1,9703,9702,10022,-1,10023,10061,10060,-1,10060,10022,10023,-1,10034,10066,10061,-1,10061,10023,10034,-1,10033,10067,10066,-1,10066,10034,10033,-1,10031,10070,10067,-1,10067,10033,10031,-1,10030,10072,10070,-1,10070,10031,10030,-1,10029,10074,10072,-1,10072,10030,10029,-1,10024,10079,10074,-1,10074,10029,10024,-1,9975,10080,10079,-1,10079,10024,9975,-1,9972,10097,10080,-1,10080,9975,9972,-1,9971,10094,10097,-1,10097,9972,9971,-1,9707,9706,10094,-1,10094,9971,9707,-1,9710,9709,9706,-1,9706,9705,9710,-1,9965,10053,9709,-1,9709,9708,9965,-1,9966,10044,10053,-1,10053,9965,9966,-1,9964,10039,10044,-1,10044,9966,9964,-1,9963,10036,10039,-1,10039,9964,9963,-1,9962,10037,10036,-1,10036,9963,9962,-1,9970,10042,10037,-1,10037,9962,9970,-1,9969,10046,10042,-1,10042,9970,9969,-1,9967,10048,10046,-1,10046,9969,9967,-1,9968,10085,10048,-1,10048,9967,9968,-1,9973,10088,10085,-1,10085,9968,9973,-1,9974,10100,10088,-1,10088,9973,9974,-1,9398,9454,10100,-1,10100,9974,9398,-1,10000,9517,9482,-1,9482,9489,10000,-1,9999,9509,9517,-1,9517,10000,9999,-1,9995,9507,9509,-1,9509,9999,9995,-1,9994,9503,9507,-1,9507,9995,9994,-1,9988,9499,9503,-1,9503,9994,9988,-1,9991,9498,9499,-1,9499,9988,9991,-1,9711,9500,9498,-1,9498,9991,9711,-1,10150,10151,10152,-1,10153,10154,10155,-1,10156,10157,10158,-1,10159,10160,10161,-1,10162,10163,10164,-1,10165,10166,10167,-1,10165,10168,10166,-1,10169,10170,10171,-1,10169,10172,10170,-1,10173,10174,10175,-1,10173,10176,10174,-1,10177,10178,10179,-1,9820,10179,10180,-1,10181,10182,10183,-1,10184,10185,10186,-1,10187,10188,10189,-1,10190,10191,10192,-1,10193,10190,10194,-1,10195,10196,10197,-1,10198,10172,10199,-1,10200,10201,10202,-1,10203,10204,10205,-1,10206,10207,10208,-1,10209,10210,10195,-1,9874,9861,10200,-1,10211,10212,10213,-1,9783,10214,9780,-1,10211,10215,10216,-1,10217,10218,10181,-1,10219,10220,10221,-1,10222,10223,10220,-1,10168,10224,10225,-1,10226,10227,10228,-1,10229,10230,10231,-1,10232,10233,10178,-1,10234,10235,10236,-1,10237,10238,10239,-1,10240,10241,10242,-1,10243,10244,10245,-1,10246,10247,10248,-1,10249,10250,10251,-1,10252,10186,10253,-1,10254,10255,10256,-1,10257,10258,10259,-1,10260,10152,10151,-1,10151,10261,10260,-1,10260,10262,10153,-1,10153,10152,10260,-1,10151,10263,10264,-1,10264,10261,10151,-1,10265,10154,10153,-1,10153,10262,10265,-1,10155,10250,10152,-1,10152,10153,10155,-1,10266,10267,10154,-1,10154,10265,10266,-1,10268,10269,10267,-1,10267,10266,10268,-1,10270,10155,10154,-1,10154,10267,10270,-1,10271,10269,10268,-1,10268,10272,10271,-1,10273,10270,10267,-1,10267,10269,10273,-1,10274,10275,10276,-1,10276,10277,10274,-1,10275,10274,10278,-1,10278,10279,10275,-1,10259,10258,10276,-1,10276,10275,10259,-1,10277,10276,10280,-1,10280,10281,10277,-1,10282,10158,10157,-1,10157,10283,10282,-1,10282,10284,10285,-1,10285,10158,10282,-1,10286,10283,10157,-1,10157,10287,10286,-1,10159,10288,10289,-1,10289,10160,10159,-1,10290,10288,10159,-1,10159,10291,10290,-1,10292,10289,10288,-1,10288,10293,10292,-1,10294,10292,10293,-1,10293,10295,10294,-1,10290,10296,10293,-1,10293,10288,10290,-1,10284,10294,10295,-1,10295,10285,10284,-1,10297,10285,10295,-1,10295,10298,10297,-1,10297,10156,10158,-1,10158,10285,10297,-1,10156,10299,10287,-1,10287,10157,10156,-1,10287,10271,10272,-1,10272,10286,10287,-1,10300,10301,10302,-1,10302,10303,10300,-1,10301,10300,10264,-1,10264,10263,10301,-1,10304,10305,10302,-1,10302,10301,10304,-1,10303,10302,10279,-1,10279,10278,10303,-1,10306,10280,10276,-1,10276,10258,10306,-1,10161,10160,10281,-1,10281,10280,10161,-1,10269,10271,10307,-1,10307,10273,10269,-1,10271,10287,10299,-1,10299,10307,10271,-1,10161,10280,10306,-1,10306,10239,10161,-1,10308,10263,10151,-1,10151,10150,10308,-1,10263,10308,10304,-1,10304,10301,10263,-1,10275,10279,10309,-1,10309,10259,10275,-1,10295,10293,10296,-1,10296,10298,10295,-1,10239,10291,10159,-1,10159,10161,10239,-1,10302,10305,10309,-1,10309,10279,10302,-1,10310,10156,10297,-1,10297,10311,10310,-1,10312,10304,10308,-1,10308,10313,10312,-1,10150,10249,10313,-1,10313,10308,10150,-1,10296,10290,10314,-1,10314,10315,10296,-1,10199,10316,10317,-1,10317,10318,10199,-1,10199,10172,10169,-1,10169,10316,10199,-1,10319,10320,10317,-1,10317,10316,10319,-1,10317,10321,10322,-1,10322,10318,10317,-1,10198,10199,10318,-1,10318,10323,10198,-1,10324,10222,10164,-1,10164,10163,10324,-1,10324,10325,10223,-1,10223,10222,10324,-1,10222,10220,10219,-1,10219,10164,10222,-1,10166,10324,10163,-1,10163,10167,10166,-1,10162,10326,10327,-1,10327,10163,10162,-1,10328,10162,10164,-1,10164,10219,10328,-1,10167,10329,10330,-1,10330,10165,10167,-1,10173,10175,10171,-1,10171,10170,10173,-1,10169,10171,10331,-1,10331,10332,10169,-1,10333,10175,10174,-1,10174,10334,10333,-1,10335,10176,10173,-1,10173,10336,10335,-1,10337,10174,10176,-1,10176,10335,10337,-1,10172,10198,10338,-1,10338,10170,10172,-1,10179,10178,10339,-1,10339,10180,10179,-1,10340,10339,10178,-1,10178,10233,10340,-1,10339,10341,10192,-1,10192,10180,10339,-1,9780,10214,10183,-1,10183,9781,9780,-1,10183,10214,10212,-1,10212,10181,10183,-1,10212,10214,10342,-1,10342,10213,10212,-1,10212,10211,10217,-1,10217,10181,10212,-1,10343,10185,10184,-1,10184,10344,10343,-1,10253,10186,10185,-1,10185,10345,10253,-1,10184,10186,10334,-1,10334,10346,10184,-1,10334,10174,10337,-1,10337,10346,10334,-1,10347,10346,10337,-1,10337,10348,10347,-1,10347,10344,10184,-1,10184,10346,10347,-1,10349,10344,10347,-1,10347,10350,10349,-1,10343,10351,10345,-1,10345,10185,10343,-1,10351,10343,10352,-1,10352,10353,10351,-1,10187,10345,10351,-1,10351,10354,10187,-1,10345,10187,10189,-1,10189,10253,10345,-1,10253,10189,10247,-1,10247,10252,10253,-1,10344,10349,10352,-1,10352,10343,10344,-1,10352,10349,10355,-1,10355,10356,10352,-1,10347,10348,10357,-1,10357,10350,10347,-1,10358,10359,10357,-1,10357,10348,10358,-1,10360,10361,10350,-1,10350,10357,10360,-1,10361,10355,10349,-1,10349,10350,10361,-1,10362,10363,10355,-1,10355,10361,10362,-1,10356,10194,10353,-1,10353,10352,10356,-1,10194,10356,10364,-1,10364,10193,10194,-1,10365,10353,10194,-1,10194,10190,10365,-1,10353,10365,10354,-1,10354,10351,10353,-1,10354,10365,10341,-1,10341,10366,10354,-1,9790,10367,10368,-1,10368,9791,9790,-1,9790,9795,10191,-1,10191,10367,9790,-1,9800,10192,10191,-1,10191,9795,9800,-1,10190,10193,10367,-1,10367,10191,10190,-1,10367,10193,10364,-1,10364,10368,10367,-1,10363,10369,10368,-1,10368,10364,10363,-1,10369,9796,9791,-1,9791,10368,10369,-1,9796,10369,10370,-1,10370,9804,9796,-1,9820,10180,10192,-1,10192,9800,9820,-1,10363,10362,10370,-1,10370,10369,10363,-1,10370,10362,10371,-1,10371,10372,10370,-1,10370,10372,9806,-1,9806,9804,10370,-1,10373,9811,9806,-1,9806,10372,10373,-1,10361,10360,10371,-1,10371,10362,10361,-1,10374,10373,10372,-1,10372,10371,10374,-1,9811,10373,10375,-1,10375,9834,9811,-1,10374,10376,10377,-1,10377,10378,10374,-1,10376,10374,10371,-1,10371,10360,10376,-1,10379,10377,10376,-1,10376,10359,10379,-1,10378,10377,10380,-1,10380,10381,10378,-1,10374,10378,10375,-1,10375,10373,10374,-1,10380,10377,10379,-1,10379,10382,10380,-1,10379,10383,10384,-1,10384,10382,10379,-1,10382,10385,10386,-1,10386,10380,10382,-1,10381,10380,10386,-1,10386,10387,10381,-1,10387,10386,10388,-1,10388,10389,10387,-1,10390,10381,10387,-1,10387,10391,10390,-1,10390,10375,10378,-1,10378,10381,10390,-1,9834,10375,10390,-1,10390,9825,9834,-1,10388,10386,10385,-1,10385,10322,10388,-1,10385,10323,10318,-1,10318,10322,10385,-1,10388,10322,10321,-1,10321,10197,10388,-1,10388,10197,10196,-1,10196,10389,10388,-1,10392,10389,10196,-1,10196,10393,10392,-1,10392,10391,10387,-1,10387,10389,10392,-1,9826,10391,10392,-1,10392,9831,9826,-1,10323,10385,10382,-1,10382,10384,10323,-1,10323,10384,10338,-1,10338,10198,10323,-1,10394,10321,10317,-1,10317,10320,10394,-1,10359,10358,10383,-1,10383,10379,10359,-1,10336,10383,10358,-1,10358,10335,10336,-1,10384,10383,10336,-1,10336,10338,10384,-1,10336,10173,10170,-1,10170,10338,10336,-1,10364,10356,10355,-1,10355,10363,10364,-1,10395,10201,10396,-1,10396,10397,10395,-1,10201,10395,10398,-1,10398,10399,10201,-1,10200,10400,10396,-1,10396,10201,10200,-1,10401,10402,10397,-1,10397,10396,10401,-1,10397,10207,10206,-1,10206,10395,10397,-1,10398,10395,10206,-1,10206,10328,10398,-1,10206,10208,10162,-1,10162,10328,10206,-1,10403,10398,10328,-1,10328,10219,10403,-1,10398,10403,10203,-1,10203,10399,10398,-1,10403,10404,10204,-1,10204,10203,10403,-1,10205,10405,10399,-1,10399,10203,10205,-1,10399,10405,10202,-1,10202,10201,10399,-1,9873,10202,10405,-1,10405,9866,9873,-1,10221,10404,10403,-1,10403,10219,10221,-1,10204,10404,10215,-1,10215,10406,10204,-1,10405,10205,9867,-1,9867,9866,10405,-1,10407,10208,10207,-1,10207,10408,10407,-1,10208,10407,10409,-1,10409,10410,10208,-1,10397,10402,10408,-1,10408,10207,10397,-1,10407,10408,10411,-1,10411,10412,10407,-1,10411,10408,10402,-1,10402,10413,10411,-1,10401,10414,10413,-1,10413,10402,10401,-1,10414,10401,10415,-1,10415,10416,10414,-1,10417,10418,10413,-1,10413,10414,10417,-1,10400,10415,10401,-1,10401,10396,10400,-1,10415,10400,9849,-1,9849,9841,10415,-1,10419,10179,9820,-1,9820,9819,10419,-1,9819,9821,10420,-1,10420,10419,9819,-1,10391,9826,9825,-1,9825,10390,10391,-1,10392,10393,9828,-1,9828,9831,10392,-1,9828,10393,10210,-1,10210,9855,9828,-1,10416,10415,9841,-1,9841,9840,10416,-1,9848,10209,10416,-1,10416,9840,9848,-1,10414,10416,10209,-1,10209,10417,10414,-1,10200,9861,9849,-1,9849,10400,10200,-1,9848,9855,10210,-1,10210,10209,9848,-1,10394,10417,10209,-1,10209,10195,10394,-1,10205,10421,9869,-1,9869,9867,10205,-1,10421,10205,10204,-1,10204,10406,10421,-1,10342,9884,9869,-1,9869,10421,10342,-1,9874,10200,10202,-1,10202,9873,9874,-1,10421,10406,10213,-1,10213,10342,10421,-1,9783,9884,10342,-1,10342,10214,9783,-1,10406,10215,10211,-1,10211,10213,10406,-1,10216,10422,10217,-1,10217,10211,10216,-1,10221,10216,10215,-1,10215,10404,10221,-1,10216,10221,10220,-1,10220,10223,10216,-1,10319,10316,10169,-1,10169,10332,10319,-1,10423,10411,10413,-1,10413,10418,10423,-1,10417,10394,10320,-1,10320,10418,10417,-1,10319,10423,10418,-1,10418,10320,10319,-1,10411,10423,10424,-1,10424,10412,10411,-1,10423,10319,10332,-1,10332,10424,10423,-1,10424,10425,10426,-1,10426,10412,10424,-1,10196,10195,10210,-1,10210,10393,10196,-1,10394,10195,10197,-1,10197,10321,10394,-1,10427,10428,10429,-1,10429,10430,10427,-1,10427,10431,10432,-1,10432,10428,10427,-1,10429,10428,10433,-1,10433,10434,10429,-1,10330,10435,10430,-1,10430,10429,10330,-1,10436,10427,10430,-1,10430,10437,10436,-1,10438,10431,10427,-1,10427,10436,10438,-1,10432,10431,10439,-1,10439,10440,10432,-1,10428,10432,10441,-1,10441,10433,10428,-1,10440,10442,10441,-1,10441,10432,10440,-1,10433,10441,10443,-1,10443,10444,10433,-1,10435,10445,10437,-1,10437,10430,10435,-1,10446,10436,10437,-1,10437,10447,10446,-1,10436,10446,10448,-1,10448,10438,10436,-1,10449,10226,10448,-1,10448,10446,10449,-1,10450,10438,10448,-1,10448,10451,10450,-1,10431,10438,10450,-1,10450,10439,10431,-1,10452,10453,10445,-1,10445,10435,10452,-1,10445,10454,10447,-1,10447,10437,10445,-1,10454,10445,10453,-1,10453,10455,10454,-1,10454,10456,10457,-1,10457,10447,10454,-1,10429,10434,10165,-1,10165,10330,10429,-1,10224,10168,10165,-1,10165,10434,10224,-1,10224,10434,10433,-1,10433,10444,10224,-1,10458,10443,10441,-1,10441,10442,10458,-1,10443,10459,10460,-1,10460,10444,10443,-1,10450,10419,10420,-1,10420,10439,10450,-1,10420,10461,10440,-1,10440,10439,10420,-1,9821,9823,10461,-1,10461,10420,9821,-1,10440,10461,10462,-1,10462,10442,10440,-1,10459,10443,10458,-1,10458,10182,10459,-1,10442,10462,10463,-1,10463,10458,10442,-1,9823,9898,10462,-1,10462,10461,9823,-1,10462,9898,9785,-1,9785,10463,10462,-1,10463,9785,9781,-1,9781,10183,10463,-1,10447,10457,10449,-1,10449,10446,10447,-1,10454,10455,10464,-1,10464,10456,10454,-1,10456,10465,10466,-1,10466,10457,10456,-1,10227,10226,10449,-1,10449,10467,10227,-1,10228,10451,10448,-1,10448,10226,10228,-1,10457,10466,10467,-1,10467,10449,10457,-1,10466,10468,10469,-1,10469,10467,10466,-1,10467,10469,10470,-1,10470,10227,10467,-1,10232,10470,10469,-1,10469,10471,10232,-1,10470,10177,10228,-1,10228,10227,10470,-1,10465,10472,10468,-1,10468,10466,10465,-1,10473,10474,10472,-1,10472,10465,10473,-1,10468,10472,10475,-1,10475,10476,10468,-1,10469,10468,10476,-1,10476,10471,10469,-1,10476,10229,10231,-1,10231,10471,10476,-1,10475,10248,10229,-1,10229,10476,10475,-1,10232,10471,10231,-1,10231,10233,10232,-1,10177,10470,10232,-1,10232,10178,10177,-1,10179,10419,10450,-1,10450,10451,10179,-1,10179,10451,10228,-1,10228,10177,10179,-1,10230,10229,10189,-1,10189,10188,10230,-1,10233,10231,10230,-1,10230,10340,10233,-1,10354,10366,10188,-1,10188,10187,10354,-1,10366,10340,10230,-1,10230,10188,10366,-1,10340,10366,10341,-1,10341,10339,10340,-1,10192,10341,10365,-1,10365,10190,10192,-1,10325,10422,10216,-1,10216,10223,10325,-1,10422,10477,10218,-1,10218,10217,10422,-1,10325,10478,10477,-1,10477,10422,10325,-1,10460,10459,10218,-1,10218,10477,10460,-1,10459,10182,10181,-1,10181,10218,10459,-1,10324,10166,10478,-1,10478,10325,10324,-1,10477,10478,10225,-1,10225,10460,10477,-1,10182,10458,10463,-1,10463,10183,10182,-1,10376,10360,10357,-1,10357,10359,10376,-1,10358,10348,10337,-1,10337,10335,10358,-1,10478,10166,10168,-1,10168,10225,10478,-1,10444,10460,10225,-1,10225,10224,10444,-1,10331,10425,10424,-1,10424,10332,10331,-1,10310,10479,10299,-1,10299,10156,10310,-1,10480,10311,10297,-1,10297,10298,10480,-1,10481,10310,10311,-1,10311,10482,10481,-1,10481,10483,10479,-1,10479,10310,10481,-1,10311,10480,10484,-1,10484,10482,10311,-1,10485,10481,10482,-1,10482,10486,10485,-1,10487,10483,10481,-1,10481,10485,10487,-1,10488,10486,10482,-1,10482,10484,10488,-1,10326,10485,10486,-1,10486,10327,10326,-1,10480,10298,10296,-1,10296,10315,10480,-1,10489,10484,10480,-1,10480,10315,10489,-1,10315,10314,10490,-1,10490,10489,10315,-1,10490,10314,10491,-1,10491,10492,10490,-1,10489,10490,10235,-1,10235,10234,10489,-1,10235,10490,10492,-1,10492,10493,10235,-1,10234,10488,10484,-1,10484,10489,10234,-1,10314,10290,10291,-1,10291,10491,10314,-1,10238,10491,10291,-1,10291,10239,10238,-1,10491,10238,10494,-1,10494,10492,10491,-1,10492,10494,10495,-1,10495,10493,10492,-1,10452,10235,10493,-1,10493,10453,10452,-1,10494,10238,10237,-1,10237,10496,10494,-1,10497,10496,10237,-1,10237,10498,10497,-1,10495,10494,10496,-1,10496,10499,10495,-1,10500,10499,10496,-1,10496,10497,10500,-1,10455,10495,10499,-1,10499,10464,10455,-1,10455,10453,10493,-1,10493,10495,10455,-1,10473,10464,10499,-1,10499,10500,10473,-1,10465,10456,10464,-1,10464,10473,10465,-1,10410,10487,10485,-1,10485,10326,10410,-1,10501,10327,10486,-1,10486,10488,10501,-1,10208,10410,10326,-1,10326,10162,10208,-1,10167,10163,10327,-1,10327,10501,10167,-1,10435,10330,10329,-1,10329,10452,10435,-1,10236,10235,10452,-1,10452,10329,10236,-1,10329,10167,10501,-1,10501,10236,10329,-1,10245,10241,10240,-1,10240,10502,10245,-1,10241,10245,10244,-1,10244,10503,10241,-1,10240,10309,10305,-1,10305,10502,10240,-1,10243,10245,10502,-1,10502,10312,10243,-1,10504,10503,10244,-1,10244,10505,10504,-1,10242,10241,10503,-1,10503,10506,10242,-1,10504,10507,10506,-1,10506,10503,10504,-1,10252,10247,10507,-1,10507,10504,10252,-1,10506,10507,10254,-1,10254,10256,10506,-1,10247,10246,10254,-1,10254,10507,10247,-1,10255,10254,10246,-1,10246,10508,10255,-1,10243,10312,10313,-1,10313,10509,10243,-1,10509,10313,10249,-1,10249,10251,10509,-1,10510,10244,10243,-1,10243,10509,10510,-1,10244,10510,10511,-1,10511,10505,10244,-1,10510,10509,10251,-1,10251,10512,10510,-1,10252,10504,10505,-1,10505,10333,10252,-1,10505,10511,10175,-1,10175,10333,10505,-1,10186,10252,10333,-1,10333,10334,10186,-1,10251,10513,10514,-1,10514,10512,10251,-1,10511,10510,10512,-1,10512,10515,10511,-1,10515,10512,10514,-1,10514,10516,10515,-1,10175,10511,10515,-1,10515,10171,10175,-1,10171,10515,10516,-1,10516,10331,10171,-1,10517,10273,10307,-1,10307,10518,10517,-1,10517,10519,10270,-1,10270,10273,10517,-1,10479,10518,10307,-1,10307,10299,10479,-1,10520,10517,10518,-1,10518,10521,10520,-1,10522,10519,10517,-1,10517,10520,10522,-1,10518,10479,10483,-1,10483,10521,10518,-1,10523,10520,10521,-1,10521,10524,10523,-1,10525,10522,10520,-1,10520,10523,10525,-1,10487,10524,10521,-1,10521,10483,10487,-1,10426,10523,10524,-1,10524,10409,10426,-1,10425,10525,10523,-1,10523,10426,10425,-1,10410,10409,10524,-1,10524,10487,10410,-1,10412,10426,10409,-1,10409,10407,10412,-1,10498,10237,10239,-1,10239,10306,10498,-1,10498,10306,10258,-1,10258,10526,10498,-1,10498,10526,10527,-1,10527,10497,10498,-1,10497,10527,10528,-1,10528,10500,10497,-1,10500,10528,10474,-1,10474,10473,10500,-1,10242,10529,10257,-1,10257,10240,10242,-1,10506,10256,10529,-1,10529,10242,10506,-1,10258,10257,10529,-1,10529,10526,10258,-1,10259,10309,10240,-1,10240,10257,10259,-1,10527,10526,10529,-1,10529,10256,10527,-1,10528,10527,10256,-1,10256,10255,10528,-1,10474,10528,10255,-1,10255,10508,10474,-1,10472,10474,10508,-1,10508,10475,10472,-1,10508,10246,10248,-1,10248,10475,10508,-1,10229,10248,10247,-1,10247,10189,10229,-1,10249,10150,10152,-1,10152,10250,10249,-1,10513,10251,10250,-1,10250,10155,10513,-1,10514,10522,10525,-1,10525,10516,10514,-1,10516,10525,10425,-1,10425,10331,10516,-1,10513,10155,10270,-1,10270,10519,10513,-1,10522,10514,10513,-1,10513,10519,10522,-1,10236,10501,10488,-1,10488,10234,10236,-1,10502,10305,10304,-1,10304,10312,10502,-1,10530,10531,10532,-1,10533,10534,10535,-1,10535,10536,10537,-1,10538,10539,10540,-1,10541,10539,10537,-1,10542,10543,10538,-1,10542,10544,10545,-1,10546,10547,10548,-1,10548,10547,10549,-1,10550,10551,10552,-1,10553,10554,10543,-1,10555,10556,10557,-1,10558,10559,10560,-1,10268,10561,10562,-1,10563,10564,10565,-1,10547,10566,10567,-1,10568,10569,10570,-1,10571,10572,10573,-1,10574,10571,10573,-1,10575,10576,10577,-1,10564,10578,10565,-1,10579,10580,10581,-1,10582,10583,10584,-1,10533,10585,10586,-1,10587,10588,10589,-1,10590,10591,10592,-1,10593,10594,10595,-1,10596,10597,10598,-1,10599,10600,10601,-1,10600,10599,10602,-1,10603,10604,10605,-1,10606,10607,10608,-1,10609,10610,10611,-1,10612,10613,10614,-1,10615,10616,10617,-1,10618,10619,10620,-1,10608,10621,10622,-1,10616,10623,10617,-1,10624,10625,10626,-1,10624,10602,10627,-1,10624,10627,10625,-1,10628,10629,10630,-1,10631,10632,10633,-1,10634,10635,10636,-1,10284,10282,10637,-1,10638,10639,10640,-1,10641,10642,10643,-1,10644,10645,10646,-1,10647,10648,10649,-1,10569,10650,10570,-1,10569,10651,10650,-1,10636,10286,10272,-1,10652,10283,10286,-1,10653,10654,10655,-1,10654,10593,10655,-1,10656,10657,10658,-1,10659,10660,10661,-1,10662,10663,10664,-1,10665,10666,10667,-1,10668,10669,10670,-1,10671,10551,10541,-1,10672,10673,10674,-1,10675,10676,10677,-1,10678,10679,10680,-1,10681,10682,10683,-1,10684,10685,10686,-1,10686,10687,10684,-1,10535,10534,10589,-1,10589,10588,10535,-1,10533,10586,10688,-1,10688,10534,10533,-1,10535,10537,10689,-1,10689,10533,10535,-1,10554,10585,10533,-1,10533,10689,10554,-1,10537,10539,10538,-1,10538,10689,10537,-1,10543,10554,10689,-1,10689,10538,10543,-1,10541,10551,10540,-1,10540,10539,10541,-1,10540,10544,10542,-1,10542,10538,10540,-1,10544,10540,10551,-1,10551,10550,10544,-1,10671,10541,10537,-1,10537,10536,10671,-1,10690,10536,10535,-1,10535,10588,10690,-1,10572,10691,10546,-1,10546,10548,10572,-1,10692,10549,10547,-1,10547,10693,10692,-1,10572,10548,10549,-1,10549,10694,10572,-1,10570,10567,10566,-1,10566,10568,10570,-1,10550,10552,10695,-1,10695,10696,10550,-1,10664,10696,10695,-1,10695,10662,10664,-1,10552,10697,10698,-1,10698,10695,10552,-1,10699,10700,10550,-1,10550,10696,10699,-1,10695,10698,10701,-1,10701,10662,10695,-1,10702,10698,10697,-1,10697,10703,10702,-1,10551,10671,10697,-1,10697,10552,10551,-1,10544,10550,10700,-1,10700,10545,10544,-1,10704,10542,10545,-1,10545,10705,10704,-1,10554,10553,10706,-1,10706,10707,10554,-1,10542,10704,10553,-1,10553,10543,10542,-1,10707,10706,10708,-1,10708,10709,10707,-1,10553,10704,10653,-1,10653,10706,10553,-1,10710,10585,10554,-1,10554,10707,10710,-1,10706,10653,10655,-1,10655,10708,10706,-1,10654,10653,10704,-1,10704,10705,10654,-1,10260,10261,10711,-1,10711,10712,10260,-1,10713,10714,10715,-1,10715,10716,10713,-1,10715,10714,10717,-1,10717,10718,10715,-1,10713,10716,10719,-1,10719,10720,10713,-1,10557,10556,10721,-1,10721,10722,10557,-1,10556,10555,10723,-1,10723,10724,10556,-1,10559,10725,10555,-1,10555,10557,10559,-1,10726,10558,10560,-1,10560,10727,10726,-1,10728,10729,10727,-1,10727,10560,10728,-1,10726,10730,10731,-1,10731,10558,10726,-1,10559,10732,10728,-1,10728,10560,10559,-1,10725,10559,10558,-1,10558,10731,10725,-1,10733,10734,10640,-1,10640,10668,10733,-1,10668,10640,10639,-1,10639,10669,10668,-1,10638,10640,10734,-1,10734,10735,10638,-1,10736,10737,10734,-1,10734,10733,10736,-1,10738,10733,10668,-1,10668,10670,10738,-1,10739,10740,10741,-1,10741,10742,10739,-1,10743,10744,10742,-1,10742,10741,10743,-1,10745,10741,10740,-1,10740,10746,10745,-1,10736,10747,10740,-1,10740,10739,10736,-1,10742,10748,10749,-1,10749,10739,10742,-1,10746,10740,10747,-1,10747,10750,10746,-1,10747,10736,10733,-1,10733,10738,10747,-1,10736,10739,10749,-1,10749,10737,10736,-1,10737,10751,10735,-1,10735,10734,10737,-1,10562,10561,10752,-1,10752,10753,10562,-1,10754,10753,10752,-1,10752,10755,10754,-1,10752,10561,10756,-1,10756,10757,10752,-1,10634,10636,10562,-1,10562,10753,10634,-1,10262,10260,10712,-1,10712,10758,10262,-1,10751,10758,10712,-1,10712,10735,10751,-1,10759,10265,10262,-1,10262,10758,10759,-1,10756,10266,10265,-1,10265,10759,10756,-1,10561,10268,10266,-1,10266,10756,10561,-1,10636,10272,10268,-1,10268,10562,10636,-1,10567,10570,10731,-1,10731,10730,10567,-1,10730,10693,10547,-1,10547,10567,10730,-1,10572,10694,10760,-1,10760,10573,10572,-1,10691,10572,10571,-1,10571,10761,10691,-1,10574,10666,10665,-1,10665,10571,10574,-1,10762,10574,10573,-1,10573,10760,10762,-1,10563,10763,10764,-1,10764,10564,10563,-1,10764,10765,10578,-1,10578,10564,10764,-1,10763,10766,10767,-1,10767,10764,10763,-1,10765,10764,10767,-1,10767,10768,10765,-1,10576,10767,10766,-1,10766,10577,10576,-1,10576,10667,10768,-1,10768,10767,10576,-1,10575,10665,10667,-1,10667,10576,10575,-1,10761,10571,10665,-1,10665,10575,10761,-1,10720,10719,10769,-1,10769,10770,10720,-1,10771,10579,10581,-1,10581,10532,10771,-1,10530,10532,10581,-1,10581,10625,10530,-1,10682,10648,10579,-1,10579,10771,10682,-1,10772,10770,10769,-1,10769,10773,10772,-1,10583,10582,10762,-1,10762,10760,10583,-1,10774,10762,10582,-1,10582,10775,10774,-1,10586,10585,10710,-1,10710,10776,10586,-1,10661,10660,10776,-1,10776,10710,10661,-1,10688,10586,10776,-1,10776,10777,10688,-1,10688,10778,10589,-1,10589,10534,10688,-1,10721,10587,10589,-1,10589,10778,10721,-1,10777,10779,10778,-1,10778,10688,10777,-1,10780,10781,10778,-1,10778,10779,10780,-1,10779,10777,10782,-1,10782,10783,10779,-1,10784,10785,10671,-1,10671,10536,10784,-1,10703,10697,10671,-1,10671,10785,10703,-1,10592,10591,10785,-1,10785,10784,10592,-1,10784,10536,10690,-1,10690,10786,10784,-1,10787,10703,10785,-1,10785,10591,10787,-1,10784,10786,10788,-1,10788,10592,10784,-1,10274,10277,10591,-1,10591,10590,10274,-1,10788,10789,10590,-1,10590,10592,10788,-1,10281,10787,10591,-1,10591,10277,10281,-1,10789,10278,10274,-1,10274,10590,10789,-1,10627,10790,10530,-1,10530,10625,10627,-1,10625,10581,10580,-1,10580,10626,10625,-1,10641,10643,10594,-1,10594,10593,10641,-1,10655,10593,10595,-1,10595,10649,10655,-1,10791,10647,10649,-1,10649,10595,10791,-1,10792,10793,10598,-1,10598,10597,10792,-1,10596,10794,10795,-1,10795,10597,10596,-1,10598,10796,10797,-1,10797,10596,10598,-1,10798,10599,10601,-1,10601,10799,10798,-1,10800,10801,10794,-1,10794,10596,10800,-1,10801,10750,10802,-1,10802,10794,10801,-1,10803,10801,10800,-1,10800,10804,10803,-1,10805,10800,10596,-1,10596,10797,10805,-1,10800,10805,10806,-1,10806,10804,10800,-1,10804,10806,10666,-1,10666,10807,10804,-1,10805,10765,10768,-1,10768,10806,10805,-1,10807,10666,10574,-1,10574,10808,10807,-1,10666,10806,10768,-1,10768,10667,10666,-1,10807,10809,10803,-1,10803,10804,10807,-1,10808,10574,10762,-1,10762,10774,10808,-1,10808,10810,10809,-1,10809,10807,10808,-1,10774,10811,10810,-1,10810,10808,10774,-1,10775,10582,10812,-1,10812,10813,10775,-1,10775,10610,10811,-1,10811,10774,10775,-1,10813,10812,10605,-1,10605,10604,10813,-1,10814,10812,10582,-1,10582,10584,10814,-1,10775,10813,10611,-1,10611,10610,10775,-1,10605,10812,10814,-1,10814,10815,10605,-1,10611,10813,10604,-1,10604,10816,10611,-1,10604,10603,10602,-1,10602,10599,10604,-1,10603,10790,10627,-1,10627,10602,10603,-1,10604,10599,10798,-1,10798,10816,10604,-1,10610,10817,10818,-1,10818,10811,10610,-1,10811,10818,10819,-1,10819,10810,10811,-1,10818,10817,10678,-1,10678,10820,10818,-1,10817,10610,10609,-1,10609,10821,10817,-1,10799,10822,10606,-1,10606,10798,10799,-1,10606,10608,10816,-1,10816,10798,10606,-1,10822,10619,10607,-1,10607,10606,10822,-1,10799,10823,10824,-1,10824,10822,10799,-1,10608,10609,10611,-1,10611,10816,10608,-1,10622,10821,10609,-1,10609,10608,10622,-1,10613,10612,10825,-1,10825,10826,10613,-1,10825,10827,10828,-1,10828,10826,10825,-1,10612,10829,10830,-1,10830,10825,10612,-1,10613,10826,10831,-1,10831,10644,10613,-1,10830,10832,10827,-1,10827,10825,10830,-1,10830,10829,10823,-1,10823,10833,10830,-1,10829,10612,10614,-1,10614,10615,10829,-1,10823,10829,10615,-1,10615,10824,10823,-1,10615,10617,10620,-1,10620,10824,10615,-1,10824,10620,10619,-1,10619,10822,10824,-1,10833,10823,10799,-1,10799,10601,10833,-1,10834,10835,10836,-1,10836,10837,10834,-1,10836,10838,10839,-1,10839,10837,10836,-1,10836,10835,10840,-1,10840,10841,10836,-1,10842,10843,10835,-1,10835,10834,10842,-1,10834,10837,10844,-1,10844,10680,10834,-1,10617,10623,10618,-1,10618,10620,10617,-1,10835,10843,10845,-1,10845,10840,10835,-1,10621,10843,10842,-1,10842,10622,10621,-1,10834,10680,10679,-1,10679,10842,10834,-1,10842,10679,10821,-1,10821,10622,10842,-1,10678,10817,10821,-1,10821,10679,10678,-1,10629,10628,10607,-1,10607,10619,10629,-1,10614,10846,10616,-1,10616,10615,10614,-1,10847,10848,10616,-1,10616,10846,10847,-1,10846,10614,10613,-1,10613,10849,10846,-1,10608,10607,10628,-1,10628,10621,10608,-1,10850,10685,10684,-1,10684,10851,10850,-1,10852,10623,10616,-1,10616,10848,10852,-1,10853,10854,10623,-1,10623,10852,10853,-1,10848,10685,10850,-1,10850,10852,10848,-1,10619,10618,10855,-1,10855,10629,10619,-1,10618,10623,10854,-1,10854,10855,10618,-1,10856,10663,10662,-1,10662,10857,10856,-1,10858,10664,10663,-1,10663,10859,10858,-1,10860,10855,10854,-1,10854,10861,10860,-1,10632,10631,10839,-1,10839,10838,10632,-1,10631,10635,10634,-1,10634,10839,10631,-1,10632,10838,10862,-1,10862,10863,10632,-1,10837,10839,10634,-1,10634,10844,10837,-1,10635,10631,10633,-1,10633,10652,10635,-1,10864,10865,10866,-1,10866,10867,10864,-1,10863,10867,10866,-1,10866,10632,10863,-1,10865,10637,10868,-1,10868,10866,10865,-1,10864,10869,10870,-1,10870,10865,10864,-1,10632,10866,10868,-1,10868,10633,10632,-1,10637,10282,10283,-1,10283,10868,10637,-1,10637,10865,10870,-1,10870,10284,10637,-1,10283,10652,10633,-1,10633,10868,10283,-1,10765,10805,10797,-1,10797,10578,10765,-1,10797,10796,10565,-1,10565,10578,10797,-1,10794,10802,10871,-1,10871,10795,10794,-1,10750,10747,10738,-1,10738,10802,10750,-1,10803,10746,10750,-1,10750,10801,10803,-1,10670,10871,10802,-1,10802,10738,10670,-1,10749,10872,10751,-1,10751,10737,10749,-1,10712,10711,10638,-1,10638,10735,10712,-1,10872,10759,10758,-1,10758,10751,10872,-1,10873,10639,10638,-1,10638,10711,10873,-1,10639,10873,10675,-1,10675,10677,10639,-1,10711,10261,10264,-1,10264,10873,10711,-1,10855,10860,10630,-1,10630,10629,10855,-1,10848,10847,10686,-1,10686,10685,10848,-1,10846,10849,10874,-1,10874,10847,10846,-1,10645,10644,10642,-1,10642,10641,10645,-1,10875,10642,10644,-1,10644,10831,10875,-1,10641,10593,10654,-1,10654,10645,10641,-1,10648,10682,10681,-1,10681,10649,10648,-1,10731,10570,10650,-1,10650,10725,10731,-1,10651,10876,10723,-1,10723,10650,10651,-1,10820,10877,10744,-1,10744,10743,10820,-1,10877,10754,10755,-1,10755,10744,10877,-1,10680,10877,10820,-1,10820,10678,10680,-1,10818,10820,10743,-1,10743,10819,10818,-1,10755,10748,10742,-1,10742,10744,10755,-1,10680,10844,10754,-1,10754,10877,10680,-1,10755,10752,10757,-1,10757,10748,10755,-1,10844,10634,10753,-1,10753,10754,10844,-1,10286,10636,10635,-1,10635,10652,10286,-1,10878,10879,10880,-1,10880,10881,10878,-1,10881,10729,10728,-1,10728,10878,10881,-1,10882,10878,10728,-1,10728,10732,10882,-1,10559,10557,10722,-1,10722,10732,10559,-1,10722,10883,10882,-1,10882,10732,10722,-1,10883,10780,10884,-1,10884,10882,10883,-1,10883,10722,10721,-1,10721,10885,10883,-1,10860,10886,10887,-1,10887,10630,10860,-1,10845,10628,10630,-1,10630,10887,10845,-1,10887,10888,10840,-1,10840,10845,10887,-1,10814,10584,10718,-1,10718,10717,10814,-1,10815,10790,10603,-1,10603,10605,10815,-1,10681,10683,10709,-1,10709,10708,10681,-1,10656,10658,10707,-1,10707,10709,10656,-1,10655,10649,10681,-1,10681,10708,10655,-1,10657,10659,10661,-1,10661,10658,10657,-1,10889,10657,10656,-1,10656,10890,10889,-1,10658,10661,10710,-1,10710,10707,10658,-1,10891,10659,10657,-1,10657,10889,10891,-1,10891,10892,10660,-1,10660,10659,10891,-1,10890,10656,10709,-1,10709,10683,10890,-1,10879,10878,10882,-1,10882,10884,10879,-1,10879,10884,10783,-1,10783,10893,10879,-1,10879,10893,10894,-1,10894,10880,10879,-1,10780,10883,10885,-1,10885,10781,10780,-1,10781,10885,10721,-1,10721,10778,10781,-1,10654,10705,10895,-1,10895,10645,10654,-1,10545,10700,10895,-1,10895,10705,10545,-1,10857,10662,10701,-1,10701,10896,10857,-1,10897,10895,10700,-1,10700,10699,10897,-1,10858,10699,10696,-1,10696,10664,10858,-1,10773,10769,10894,-1,10894,10893,10773,-1,10898,10772,10773,-1,10773,10782,10898,-1,10783,10782,10773,-1,10773,10893,10783,-1,10598,10793,10899,-1,10899,10796,10598,-1,10674,10724,10793,-1,10793,10792,10674,-1,10597,10795,10900,-1,10900,10792,10597,-1,10796,10899,10901,-1,10901,10565,10796,-1,10793,10902,10903,-1,10903,10899,10793,-1,10903,10902,10904,-1,10904,10876,10903,-1,10793,10724,10904,-1,10904,10902,10793,-1,10876,10651,10905,-1,10905,10903,10876,-1,10725,10650,10723,-1,10723,10555,10725,-1,10904,10724,10723,-1,10723,10876,10904,-1,10843,10621,10628,-1,10628,10845,10843,-1,10687,10686,10858,-1,10858,10859,10687,-1,10874,10858,10686,-1,10686,10847,10874,-1,10858,10874,10897,-1,10897,10699,10858,-1,10701,10698,10702,-1,10702,10906,10701,-1,10906,10702,10907,-1,10907,10908,10906,-1,10909,10896,10701,-1,10701,10906,10909,-1,10907,10160,10289,-1,10289,10908,10907,-1,10907,10702,10703,-1,10703,10787,10907,-1,10908,10910,10909,-1,10909,10906,10908,-1,10292,10910,10908,-1,10908,10289,10292,-1,10160,10907,10787,-1,10787,10281,10160,-1,10911,10910,10292,-1,10292,10294,10911,-1,10912,10909,10910,-1,10910,10911,10912,-1,10869,10912,10911,-1,10911,10870,10869,-1,10870,10911,10294,-1,10294,10284,10870,-1,10587,10721,10556,-1,10556,10673,10587,-1,10673,10556,10724,-1,10724,10674,10673,-1,10588,10587,10673,-1,10673,10672,10588,-1,10786,10690,10913,-1,10913,10914,10786,-1,10914,10913,10915,-1,10915,10669,10914,-1,10690,10588,10672,-1,10672,10913,10690,-1,10914,10677,10788,-1,10788,10786,10914,-1,10871,10670,10669,-1,10669,10915,10871,-1,10913,10672,10900,-1,10900,10915,10913,-1,10795,10871,10915,-1,10915,10900,10795,-1,10646,10897,10874,-1,10874,10849,10646,-1,10884,10780,10779,-1,10779,10783,10884,-1,10776,10898,10782,-1,10782,10777,10776,-1,10897,10646,10645,-1,10645,10895,10897,-1,10300,10303,10676,-1,10676,10675,10300,-1,10789,10676,10303,-1,10303,10278,10789,-1,10300,10675,10873,-1,10873,10264,10300,-1,10788,10677,10676,-1,10676,10789,10788,-1,10677,10914,10669,-1,10669,10639,10677,-1,10819,10743,10741,-1,10741,10745,10819,-1,10838,10836,10841,-1,10841,10862,10838,-1,10809,10745,10746,-1,10746,10803,10809,-1,10810,10819,10745,-1,10745,10809,10810,-1,10748,10757,10872,-1,10872,10749,10748,-1,10757,10756,10759,-1,10759,10872,10757,-1,10646,10849,10613,-1,10613,10644,10646,-1,10672,10674,10792,-1,10792,10900,10672,-1,10660,10892,10898,-1,10898,10776,10660,-1,10892,10916,10772,-1,10772,10898,10892,-1,10917,10684,10687,-1,10918,10919,10917,-1,10920,10921,10922,-1,10922,10923,10920,-1,10924,10925,10926,-1,10927,10924,10926,-1,10928,10918,10929,-1,10928,10930,10918,-1,10929,10931,10928,-1,10932,10931,10929,-1,10919,10933,10934,-1,10684,10935,10851,-1,10936,10937,10856,-1,10857,10936,10856,-1,10938,10939,10940,-1,10939,10941,10942,-1,10943,10939,10942,-1,10943,10944,10934,-1,10945,10946,10947,-1,10948,10949,10950,-1,10948,10951,10949,-1,10952,10953,10948,-1,10912,10954,10955,-1,10935,10684,10917,-1,10917,10919,10935,-1,10687,10956,10932,-1,10932,10917,10687,-1,10918,10930,10933,-1,10933,10919,10918,-1,10918,10917,10932,-1,10932,10929,10918,-1,10921,10957,10947,-1,10947,10922,10921,-1,10921,10920,10924,-1,10924,10927,10921,-1,10958,10926,10925,-1,10925,10959,10958,-1,10958,10960,10927,-1,10927,10926,10958,-1,10958,10959,10931,-1,10931,10961,10958,-1,10962,10928,10931,-1,10931,10959,10962,-1,10935,10944,10963,-1,10963,10851,10935,-1,10964,10965,10940,-1,10940,10952,10964,-1,10952,10940,10966,-1,10966,10953,10952,-1,10940,10965,10967,-1,10967,10938,10940,-1,10968,10969,10965,-1,10965,10964,10968,-1,10952,10948,10950,-1,10950,10964,10952,-1,10937,10859,10663,-1,10663,10856,10937,-1,10937,10936,10961,-1,10961,10956,10937,-1,10859,10937,10956,-1,10956,10687,10859,-1,10970,10941,10939,-1,10939,10938,10970,-1,10970,10853,10971,-1,10971,10941,10970,-1,10861,10970,10938,-1,10938,10967,10861,-1,10939,10972,10966,-1,10966,10940,10939,-1,10963,10942,10941,-1,10941,10971,10963,-1,10851,10963,10971,-1,10971,10850,10851,-1,10853,10852,10850,-1,10850,10971,10853,-1,10944,10943,10942,-1,10942,10963,10944,-1,10970,10861,10854,-1,10854,10853,10970,-1,10935,10919,10934,-1,10934,10944,10935,-1,10973,10945,10974,-1,10974,10975,10973,-1,10975,10974,10976,-1,10976,10977,10975,-1,10957,10974,10945,-1,10945,10947,10957,-1,10978,10946,10945,-1,10945,10973,10978,-1,10975,10979,10980,-1,10980,10973,10975,-1,10981,10982,10983,-1,10983,10984,10981,-1,10968,10984,10983,-1,10983,10985,10968,-1,10862,10983,10982,-1,10982,10863,10862,-1,10978,10986,10982,-1,10982,10981,10978,-1,10984,10950,10949,-1,10949,10981,10984,-1,10947,10946,10987,-1,10987,10988,10947,-1,10973,10980,10986,-1,10986,10978,10973,-1,10980,10864,10867,-1,10867,10986,10980,-1,10982,10986,10867,-1,10867,10863,10982,-1,10946,10978,10981,-1,10981,10949,10946,-1,10951,10987,10946,-1,10946,10949,10951,-1,10939,10943,10989,-1,10989,10972,10939,-1,10980,10979,10869,-1,10869,10864,10980,-1,10947,10988,10923,-1,10923,10922,10947,-1,10989,10943,10934,-1,10934,10933,10989,-1,10936,10857,10990,-1,10990,10991,10936,-1,10990,10977,10976,-1,10976,10991,10990,-1,10990,10857,10896,-1,10896,10955,10990,-1,10958,10961,10936,-1,10936,10991,10958,-1,10886,10969,10888,-1,10888,10887,10886,-1,10860,10861,10967,-1,10967,10886,10860,-1,10969,10968,10985,-1,10985,10888,10969,-1,10969,10886,10967,-1,10967,10965,10969,-1,10841,10840,10888,-1,10888,10985,10841,-1,10983,10862,10841,-1,10841,10985,10983,-1,10984,10968,10964,-1,10964,10950,10984,-1,10956,10961,10931,-1,10931,10932,10956,-1,10974,10957,10960,-1,10960,10976,10974,-1,10957,10921,10927,-1,10927,10960,10957,-1,10958,10991,10976,-1,10976,10960,10958,-1,10977,10954,10979,-1,10979,10975,10977,-1,10954,10977,10990,-1,10990,10955,10954,-1,10979,10954,10912,-1,10912,10869,10979,-1,10955,10896,10909,-1,10909,10912,10955,-1,10992,10993,10920,-1,10920,10923,10992,-1,10994,10995,10992,-1,10930,10928,10996,-1,10997,10933,10930,-1,10997,10989,10933,-1,10989,10997,10998,-1,10966,10972,10999,-1,11000,11001,11002,-1,11003,11004,11005,-1,10998,10972,10989,-1,11006,11007,11008,-1,11009,11010,11011,-1,11012,11013,11014,-1,10920,10993,11015,-1,11015,10924,10920,-1,10992,10995,11008,-1,11008,10993,10992,-1,10994,11016,11017,-1,11017,10995,10994,-1,10994,10992,10923,-1,10923,10988,10994,-1,11018,10962,10959,-1,10959,10925,11018,-1,11015,11018,10925,-1,10925,10924,11015,-1,10997,10930,10996,-1,10996,11019,10997,-1,11013,11019,10996,-1,10996,11014,11013,-1,10997,11019,11020,-1,11020,11021,10997,-1,11022,11023,11024,-1,11024,11025,11022,-1,11003,11026,11027,-1,11027,11028,11003,-1,11028,11027,11010,-1,11010,11009,11028,-1,11029,11030,11009,-1,11009,11011,11029,-1,11025,11024,11031,-1,11031,11032,11025,-1,11032,11031,11033,-1,11033,11034,11032,-1,11034,11033,11035,-1,11035,11036,11034,-1,11036,11035,11037,-1,11037,11038,11036,-1,11038,11037,11030,-1,11030,11029,11038,-1,11039,11025,11032,-1,11032,11040,11039,-1,11040,11032,11034,-1,11034,11041,11040,-1,11039,11042,11022,-1,11022,11025,11039,-1,11016,11039,11040,-1,11040,11017,11016,-1,10987,11016,10994,-1,10994,10988,10987,-1,10951,11043,11016,-1,11016,10987,10951,-1,10999,10972,11044,-1,11044,11045,10999,-1,10953,10966,10999,-1,10999,11046,10953,-1,10948,11047,11043,-1,11043,10951,10948,-1,11042,11043,11047,-1,11047,11048,11042,-1,10953,11046,11047,-1,11047,10948,10953,-1,11039,11016,11043,-1,11043,11042,11039,-1,11047,11046,11049,-1,11049,11048,11047,-1,11004,11002,11001,-1,11001,11005,11004,-1,10972,10998,11050,-1,11050,11044,10972,-1,11050,11027,11026,-1,11026,11044,11050,-1,10998,10997,11021,-1,11021,11050,10998,-1,11021,11010,11027,-1,11027,11050,11021,-1,11021,11020,11011,-1,11011,11010,11021,-1,11019,11013,11051,-1,11051,11020,11019,-1,11051,11029,11011,-1,11011,11020,11051,-1,11013,11052,11053,-1,11053,11051,11013,-1,11053,11038,11029,-1,11029,11051,11053,-1,11052,11007,11054,-1,11054,11053,11052,-1,11055,11052,11013,-1,11013,11012,11055,-1,11054,11036,11038,-1,11038,11053,11054,-1,11007,11006,11041,-1,11041,11054,11007,-1,11055,11008,11007,-1,11007,11052,11055,-1,11041,11034,11036,-1,11036,11054,11041,-1,11006,11017,11040,-1,11040,11041,11006,-1,11008,10995,11017,-1,11017,11006,11008,-1,11023,11022,11056,-1,11056,11000,11023,-1,11057,11058,11005,-1,11005,11001,11057,-1,11001,11000,11056,-1,11056,11057,11001,-1,11058,11026,11003,-1,11003,11005,11058,-1,11022,11042,11048,-1,11048,11056,11022,-1,11048,11049,11057,-1,11057,11056,11048,-1,10962,11014,10996,-1,10996,10928,10962,-1,11014,10962,11018,-1,11018,11012,11014,-1,11012,11018,11015,-1,11015,11055,11012,-1,10993,11008,11055,-1,11055,11015,10993,-1,11046,10999,11045,-1,11045,11049,11046,-1,11049,11045,11058,-1,11058,11057,11049,-1,11045,11044,11026,-1,11026,11058,11045,-1,11059,11060,11061,-1,11062,11063,11064,-1,11065,11066,11061,-1,11067,11063,11068,-1,11069,11070,11071,-1,11072,11073,11074,-1,11075,11076,11077,-1,11075,11077,11078,-1,11004,11003,11079,-1,11080,11081,11082,-1,11083,11084,11082,-1,11065,11061,11060,-1,11060,11085,11065,-1,11086,11060,11059,-1,11059,11087,11086,-1,11059,11061,11066,-1,11066,11088,11059,-1,11063,11067,11089,-1,11089,11064,11063,-1,11090,11068,11063,-1,11063,11062,11090,-1,11075,11062,11064,-1,11064,11076,11075,-1,11060,11086,11091,-1,11091,11085,11060,-1,11092,11065,11085,-1,11085,11093,11092,-1,11093,11085,11091,-1,11091,11094,11093,-1,11066,11065,11092,-1,11092,11095,11066,-1,11067,11092,11093,-1,11093,11089,11067,-1,11089,11093,11094,-1,11094,11096,11089,-1,11095,11092,11067,-1,11067,11068,11095,-1,11096,11076,11064,-1,11064,11089,11096,-1,11088,11066,11095,-1,11095,11097,11088,-1,11097,11095,11068,-1,11068,11090,11097,-1,11098,11099,11088,-1,11088,11097,11098,-1,11100,11098,11097,-1,11097,11090,11100,-1,11075,11100,11090,-1,11090,11062,11075,-1,11087,11059,11088,-1,11088,11099,11087,-1,11078,11101,11102,-1,11102,11103,11078,-1,11102,11009,11030,-1,11030,11103,11102,-1,11102,11101,11104,-1,11104,11105,11102,-1,11078,11077,11106,-1,11106,11101,11078,-1,11107,11108,11078,-1,11078,11103,11107,-1,11024,11023,11109,-1,11109,11110,11024,-1,11109,11111,11069,-1,11069,11110,11109,-1,11000,11112,11109,-1,11109,11023,11000,-1,11031,11024,11110,-1,11110,11113,11031,-1,11003,11028,11105,-1,11105,11114,11003,-1,11105,11104,11115,-1,11115,11114,11105,-1,11028,11009,11102,-1,11102,11105,11028,-1,11079,11003,11114,-1,11114,11116,11079,-1,11030,11037,11107,-1,11107,11103,11030,-1,11110,11069,11071,-1,11071,11113,11110,-1,11033,11031,11113,-1,11113,11117,11033,-1,11113,11071,11118,-1,11118,11117,11113,-1,11035,11033,11117,-1,11117,11119,11035,-1,11117,11118,11120,-1,11120,11119,11117,-1,11037,11035,11119,-1,11119,11107,11037,-1,11119,11120,11108,-1,11108,11107,11119,-1,11087,11071,11070,-1,11070,11121,11087,-1,11070,11069,11111,-1,11111,11122,11070,-1,11123,11124,11072,-1,11072,11074,11123,-1,11124,11121,11125,-1,11125,11072,11124,-1,11086,11124,11123,-1,11123,11091,11086,-1,11074,11126,11127,-1,11127,11123,11074,-1,11072,11125,11128,-1,11128,11073,11072,-1,11122,11125,11121,-1,11121,11070,11122,-1,11121,11124,11086,-1,11086,11087,11121,-1,11077,11076,11129,-1,11129,11106,11077,-1,11123,11127,11094,-1,11094,11091,11123,-1,11130,11129,11076,-1,11076,11096,11130,-1,11094,11127,11130,-1,11130,11096,11094,-1,11100,11075,11078,-1,11078,11108,11100,-1,11118,11099,11098,-1,11098,11120,11118,-1,11120,11098,11100,-1,11100,11108,11120,-1,11071,11087,11099,-1,11099,11118,11071,-1,11131,11112,11000,-1,11000,11002,11131,-1,11112,11131,11132,-1,11132,11133,11112,-1,11002,11004,11079,-1,11079,11131,11002,-1,11116,11132,11131,-1,11131,11079,11116,-1,11111,11109,11112,-1,11112,11133,11111,-1,11080,11129,11130,-1,11130,11081,11080,-1,11081,11130,11127,-1,11127,11126,11081,-1,11106,11129,11080,-1,11080,11134,11106,-1,11082,11081,11126,-1,11126,11135,11082,-1,11074,11073,11135,-1,11135,11126,11074,-1,11136,11083,11082,-1,11082,11135,11136,-1,11133,11132,11137,-1,11137,11138,11133,-1,11138,11137,11136,-1,11136,11128,11138,-1,11132,11116,11139,-1,11139,11137,11132,-1,11122,11111,11133,-1,11133,11138,11122,-1,11128,11136,11135,-1,11135,11073,11128,-1,11137,11139,11083,-1,11083,11136,11137,-1,11125,11122,11138,-1,11138,11128,11125,-1,11116,11114,11115,-1,11115,11139,11116,-1,11139,11115,11084,-1,11084,11083,11139,-1,11084,11115,11104,-1,11104,11134,11084,-1,11134,11080,11082,-1,11082,11084,11134,-1,11101,11106,11134,-1,11134,11104,11101,-1,11140,11141,10828,-1,11141,11140,11142,-1,11143,11144,11145,-1,11146,11145,11144,-1,11147,11148,11149,-1,11150,11148,11147,-1,10594,10791,10595,-1,11151,11152,11153,-1,10579,10648,11153,-1,10648,10647,11154,-1,11155,11154,10647,-1,11154,11153,10648,-1,11156,11157,11158,-1,11159,11160,11161,-1,10831,10826,10828,-1,10828,11141,10831,-1,10828,10827,11162,-1,11162,11140,10828,-1,11145,11158,11163,-1,11163,11143,11145,-1,11149,11148,11164,-1,11164,11165,11149,-1,11149,11146,11144,-1,11144,11147,11149,-1,11166,11146,11149,-1,11149,11165,11166,-1,11146,11166,11158,-1,11158,11145,11146,-1,11150,11167,11164,-1,11164,11148,11150,-1,10643,11168,10791,-1,10791,10594,10643,-1,11169,11170,11171,-1,11171,11172,11169,-1,11160,11172,11171,-1,11171,11161,11160,-1,11173,11174,11171,-1,11171,11170,11173,-1,11175,11170,11169,-1,11169,11176,11175,-1,11177,11178,11157,-1,11157,11179,11177,-1,11180,11181,11182,-1,11182,11183,11180,-1,11177,11179,11181,-1,11181,11180,11177,-1,11182,11175,11176,-1,11176,11183,11182,-1,11184,10601,10600,-1,10600,11185,11184,-1,11186,11187,11188,-1,11188,11189,11186,-1,11188,11190,11162,-1,11162,11189,11188,-1,11191,11192,11188,-1,11188,11187,11191,-1,11186,11193,11194,-1,11194,11187,11186,-1,11189,10832,11195,-1,11195,11186,11189,-1,11196,10831,11141,-1,11141,11197,11196,-1,10601,11184,11195,-1,11195,10833,10601,-1,11195,10832,10830,-1,10830,10833,11195,-1,11186,11195,11184,-1,11184,11193,11186,-1,10827,10832,11189,-1,11189,11162,10827,-1,11140,11162,11190,-1,11190,11142,11140,-1,11152,10580,10579,-1,10579,11153,11152,-1,11198,11152,11151,-1,11151,11199,11198,-1,11200,11151,11153,-1,11153,11154,11200,-1,11198,10626,10580,-1,10580,11152,11198,-1,11201,10624,10626,-1,10626,11198,11201,-1,11193,11184,11185,-1,11185,11202,11193,-1,11202,11185,10624,-1,10624,11201,11202,-1,11202,11203,11194,-1,11194,11193,11202,-1,11185,10600,10602,-1,10602,10624,11185,-1,11201,11204,11203,-1,11203,11202,11201,-1,11201,11198,11199,-1,11199,11204,11201,-1,11204,11199,11174,-1,11174,11173,11204,-1,11205,11174,11199,-1,11199,11151,11205,-1,11157,11178,11163,-1,11163,11158,11157,-1,11206,11207,11157,-1,11157,11156,11206,-1,11166,11208,11156,-1,11156,11158,11166,-1,11156,11208,11209,-1,11209,11206,11156,-1,11206,11209,11210,-1,11210,11142,11206,-1,11208,11211,11212,-1,11212,11209,11208,-1,11142,11210,11197,-1,11197,11141,11142,-1,11209,11212,11213,-1,11213,11210,11209,-1,11142,11190,11207,-1,11207,11206,11142,-1,11210,11213,11155,-1,11155,11197,11210,-1,11168,10875,10831,-1,10831,11196,11168,-1,11197,11155,10647,-1,10647,11196,11197,-1,11166,11165,11211,-1,11211,11208,11166,-1,11165,11164,11159,-1,11159,11211,11165,-1,11211,11159,11214,-1,11214,11212,11211,-1,11212,11214,11200,-1,11200,11213,11212,-1,11213,11200,11154,-1,11154,11155,11213,-1,11196,10647,10791,-1,10791,11168,11196,-1,11159,11164,11167,-1,11167,11160,11159,-1,11159,11161,11205,-1,11205,11214,11159,-1,11214,11205,11151,-1,11151,11200,11214,-1,11161,11171,11174,-1,11174,11205,11161,-1,11168,10643,10642,-1,10642,10875,11168,-1,11203,11204,11173,-1,11173,11215,11203,-1,11215,11173,11170,-1,11170,11175,11215,-1,11179,11157,11207,-1,11207,11192,11179,-1,11192,11207,11190,-1,11190,11188,11192,-1,11179,11192,11191,-1,11191,11181,11179,-1,11181,11191,11216,-1,11216,11182,11181,-1,11216,11215,11175,-1,11175,11182,11216,-1,11187,11194,11216,-1,11216,11191,11187,-1,11194,11203,11215,-1,11215,11216,11194,-1,11217,11218,11147,-1,11219,11144,11220,-1,11143,11220,11144,-1,11150,11147,11218,-1,11169,11221,11176,-1,11222,11223,11224,-1,11225,11226,11222,-1,11227,11223,11218,-1,11218,11217,11227,-1,11223,11167,11150,-1,11150,11218,11223,-1,11228,11224,11223,-1,11223,11227,11228,-1,11217,11219,11229,-1,11229,11227,11217,-1,11220,11230,11229,-1,11229,11219,11220,-1,11231,11232,11229,-1,11229,11230,11231,-1,11143,11163,11230,-1,11230,11220,11143,-1,11219,11217,11147,-1,11147,11144,11219,-1,11232,11228,11227,-1,11227,11229,11232,-1,11233,11224,11228,-1,11228,11234,11233,-1,11228,11232,11235,-1,11235,11234,11228,-1,11233,11225,11222,-1,11222,11224,11233,-1,11236,11237,11233,-1,11233,11234,11236,-1,11231,11238,11239,-1,11239,11240,11231,-1,11241,11242,11240,-1,11240,11239,11241,-1,11243,11239,11238,-1,11238,11244,11243,-1,11238,11231,11230,-1,11230,11245,11238,-1,11232,11231,11240,-1,11240,11235,11232,-1,11246,11236,11234,-1,11234,11235,11246,-1,11242,11246,11235,-1,11235,11240,11242,-1,11247,11241,11239,-1,11239,11243,11247,-1,11248,11225,11249,-1,11249,11250,11248,-1,11251,11248,11250,-1,11250,11252,11251,-1,11253,11251,11252,-1,11252,11254,11253,-1,11254,11255,11256,-1,11256,11253,11254,-1,11255,11247,11243,-1,11243,11256,11255,-1,11169,11172,11226,-1,11226,11257,11169,-1,11258,11245,11178,-1,11178,11177,11258,-1,11245,11230,11163,-1,11163,11178,11245,-1,11244,11238,11245,-1,11245,11258,11244,-1,11177,11180,11259,-1,11259,11258,11177,-1,11259,11180,11183,-1,11183,11260,11259,-1,11183,11176,11221,-1,11221,11260,11183,-1,11259,11260,11261,-1,11261,11262,11259,-1,11262,11244,11258,-1,11258,11259,11262,-1,11260,11221,11263,-1,11263,11261,11260,-1,11221,11169,11257,-1,11257,11263,11221,-1,11223,11222,11160,-1,11160,11167,11223,-1,11225,11233,11237,-1,11237,11249,11225,-1,11172,11160,11222,-1,11222,11226,11172,-1,11257,11226,11225,-1,11225,11248,11257,-1,11263,11257,11248,-1,11248,11251,11263,-1,11262,11256,11243,-1,11243,11244,11262,-1,11261,11263,11251,-1,11251,11253,11261,-1,11253,11256,11262,-1,11262,11261,11253,-1,11264,11265,11266,-1,11267,11268,11269,-1,11269,11270,11271,-1,11272,11265,11273,-1,11274,11275,11276,-1,11277,11278,11279,-1,11280,11281,11282,-1,11283,11284,11285,-1,11286,11287,11288,-1,11265,11272,11289,-1,11289,11266,11265,-1,11265,11264,11290,-1,11290,11273,11265,-1,11266,11276,11275,-1,11275,11264,11266,-1,11270,11269,11268,-1,11268,11291,11270,-1,11279,11278,11268,-1,11268,11267,11279,-1,11271,11292,11267,-1,11267,11269,11271,-1,11278,11293,11291,-1,11291,11268,11278,-1,11294,11270,11291,-1,11291,11295,11294,-1,11293,11296,11295,-1,11295,11291,11293,-1,11297,11271,11270,-1,11270,11294,11297,-1,11272,11294,11295,-1,11295,11289,11272,-1,11296,11298,11289,-1,11289,11295,11296,-1,11294,11272,11273,-1,11273,11297,11294,-1,11298,11276,11266,-1,11266,11289,11298,-1,11273,11290,11299,-1,11299,11297,11273,-1,11297,11299,11292,-1,11292,11271,11297,-1,11275,11300,11290,-1,11290,11264,11275,-1,11300,11301,11299,-1,11299,11290,11300,-1,11301,11302,11292,-1,11292,11299,11301,-1,11302,11279,11267,-1,11267,11292,11302,-1,11303,11284,11236,-1,11236,11246,11303,-1,11284,11304,11237,-1,11237,11236,11284,-1,11285,11284,11303,-1,11303,11305,11285,-1,11306,11303,11246,-1,11246,11242,11306,-1,11241,11307,11306,-1,11306,11242,11241,-1,11306,11307,11308,-1,11308,11277,11306,-1,11309,11307,11241,-1,11241,11247,11309,-1,11305,11303,11306,-1,11306,11277,11305,-1,11310,11308,11307,-1,11307,11309,11310,-1,11311,11309,11247,-1,11247,11255,11311,-1,11249,11312,11313,-1,11313,11250,11249,-1,11313,11314,11252,-1,11252,11250,11313,-1,11313,11312,11315,-1,11315,11316,11313,-1,11304,11312,11249,-1,11249,11237,11304,-1,11314,11317,11254,-1,11254,11252,11314,-1,11314,11313,11316,-1,11316,11318,11314,-1,11255,11254,11317,-1,11317,11311,11255,-1,11317,11314,11318,-1,11318,11319,11317,-1,11319,11320,11311,-1,11311,11317,11319,-1,11320,11310,11309,-1,11309,11311,11320,-1,11274,11283,11300,-1,11300,11275,11274,-1,11315,11274,11276,-1,11276,11321,11315,-1,11277,11308,11322,-1,11322,11278,11277,-1,11302,11305,11277,-1,11277,11279,11302,-1,11301,11300,11283,-1,11283,11285,11301,-1,11301,11285,11305,-1,11305,11302,11301,-1,11276,11298,11323,-1,11323,11321,11276,-1,11298,11296,11324,-1,11324,11323,11298,-1,11324,11296,11293,-1,11293,11325,11324,-1,11325,11293,11278,-1,11278,11322,11325,-1,11318,11316,11282,-1,11282,11281,11318,-1,11280,11326,11327,-1,11327,11281,11280,-1,11321,11323,11280,-1,11280,11282,11321,-1,11274,11315,11312,-1,11312,11304,11274,-1,11274,11304,11284,-1,11284,11283,11274,-1,11316,11315,11321,-1,11321,11282,11316,-1,11326,11324,11325,-1,11325,11287,11326,-1,11325,11322,11288,-1,11288,11287,11325,-1,11323,11324,11326,-1,11326,11280,11323,-1,11326,11287,11286,-1,11286,11327,11326,-1,11288,11322,11308,-1,11308,11310,11288,-1,11286,11288,11310,-1,11310,11320,11286,-1,11281,11327,11319,-1,11319,11318,11281,-1,11286,11320,11319,-1,11319,11327,11286,-1,10532,10531,11328,-1,11329,11330,11331,-1,11332,11333,11334,-1,11335,11336,11337,-1,11337,11338,11335,-1,11339,11340,11341,-1,11340,11339,11342,-1,10771,11343,10682,-1,10790,11344,10530,-1,11345,11346,11347,-1,11348,10814,10717,-1,10916,11349,11350,-1,11351,11352,11353,-1,11354,11355,11356,-1,10682,11357,10683,-1,11357,11358,11352,-1,11359,11360,11354,-1,10531,11361,11362,-1,11362,11328,10531,-1,11343,10771,10532,-1,10532,11328,11343,-1,11329,11331,11345,-1,11345,10713,11329,-1,11345,11347,10714,-1,10714,10713,11345,-1,11345,11331,11363,-1,11363,11346,11345,-1,11364,11329,10713,-1,10713,10720,11364,-1,10770,10772,11334,-1,11334,11333,10770,-1,11365,11366,11333,-1,11333,11332,11365,-1,11367,11332,11334,-1,11334,11368,11367,-1,11336,11360,11359,-1,11359,11337,11336,-1,11369,11341,11340,-1,11340,11370,11369,-1,11371,11339,11341,-1,11341,11372,11371,-1,11335,11338,11369,-1,11369,11370,11335,-1,11369,11338,11373,-1,11373,11374,11369,-1,11341,11369,11374,-1,11374,11372,11341,-1,11359,11373,11338,-1,11338,11337,11359,-1,11343,11328,11362,-1,11362,11375,11343,-1,11364,10720,10770,-1,10770,11333,11364,-1,11376,11377,11378,-1,11378,11379,11376,-1,11380,11381,11382,-1,11382,11383,11380,-1,11381,11384,11385,-1,11385,11382,11381,-1,11384,11386,11387,-1,11387,11385,11384,-1,11386,11376,11379,-1,11379,11387,11386,-1,11388,10531,10530,-1,10530,11344,11388,-1,11344,10790,10815,-1,10815,11389,11344,-1,11348,11347,11346,-1,11346,11389,11348,-1,11346,11363,11390,-1,11390,11388,11346,-1,11388,11390,11361,-1,11361,10531,11388,-1,11390,11363,11391,-1,11391,11392,11390,-1,11388,11344,11389,-1,11389,11346,11388,-1,11361,11390,11392,-1,11392,11393,11361,-1,11363,11331,11394,-1,11394,11391,11363,-1,11347,11348,10717,-1,10717,10714,11347,-1,11393,11395,11362,-1,11362,11361,11393,-1,10815,10814,11348,-1,11348,11389,10815,-1,11349,11351,11353,-1,11353,11350,11349,-1,10916,10892,10891,-1,10891,11349,10916,-1,10916,11350,11334,-1,11334,10772,10916,-1,11350,11353,11368,-1,11368,11334,11350,-1,11351,11349,10891,-1,10891,10889,11351,-1,11353,11352,11358,-1,11358,11368,11353,-1,11352,11351,10889,-1,10889,10890,11352,-1,11352,10890,10683,-1,10683,11357,11352,-1,11364,11396,11330,-1,11330,11329,11364,-1,11397,11330,11396,-1,11396,11356,11397,-1,11364,11333,11366,-1,11366,11396,11364,-1,11354,11356,11396,-1,11396,11366,11354,-1,11331,11330,11397,-1,11397,11394,11331,-1,11377,11397,11356,-1,11356,11355,11377,-1,11394,11397,11377,-1,11377,11376,11394,-1,11378,11377,11355,-1,11355,11398,11378,-1,11355,11354,11360,-1,11360,11398,11355,-1,11399,11342,11339,-1,11339,11371,11399,-1,11399,11371,11400,-1,11400,11401,11399,-1,11400,11380,11383,-1,11383,11401,11400,-1,11372,11402,11400,-1,11400,11371,11372,-1,11400,11402,11403,-1,11403,11404,11400,-1,11372,11374,11405,-1,11405,11402,11372,-1,11404,11403,11406,-1,11406,11375,11404,-1,11402,11405,11407,-1,11407,11403,11402,-1,11404,11395,11380,-1,11380,11400,11404,-1,11375,11406,11358,-1,11358,11343,11375,-1,11403,11407,11367,-1,11367,11406,11403,-1,11375,11362,11395,-1,11395,11404,11375,-1,11343,11358,11357,-1,11357,10682,11343,-1,11406,11367,11368,-1,11368,11358,11406,-1,11395,11393,11381,-1,11381,11380,11395,-1,11374,11373,11408,-1,11408,11405,11374,-1,11405,11408,11365,-1,11365,11407,11405,-1,11407,11365,11332,-1,11332,11367,11407,-1,11373,11359,11354,-1,11354,11408,11373,-1,11408,11354,11366,-1,11366,11365,11408,-1,11391,11394,11376,-1,11376,11386,11391,-1,11393,11392,11384,-1,11384,11381,11393,-1,11392,11391,11386,-1,11386,11384,11392,-1,11335,11409,11336,-1,11335,11410,11409,-1,11340,11342,11411,-1,11412,11340,11411,-1,11413,11414,11415,-1,11416,11417,11418,-1,11419,11420,11421,-1,11415,11422,11423,-1,11422,11415,11360,-1,11410,11335,11370,-1,11370,11424,11410,-1,11412,11424,11370,-1,11370,11340,11412,-1,11425,11426,11427,-1,11427,11428,11425,-1,11429,11425,11428,-1,11428,11430,11429,-1,11431,11429,11430,-1,11430,11432,11431,-1,11433,11434,11420,-1,11420,11435,11433,-1,11436,11435,11420,-1,11420,11437,11436,-1,11438,11421,11420,-1,11420,11434,11438,-1,11433,11431,11432,-1,11432,11434,11433,-1,11439,11427,11426,-1,11426,11440,11439,-1,11427,11439,11441,-1,11441,11413,11427,-1,11440,11442,11443,-1,11443,11439,11440,-1,11378,11444,11445,-1,11445,11379,11378,-1,11445,11446,11387,-1,11387,11379,11445,-1,11444,11441,11447,-1,11447,11445,11444,-1,11444,11378,11398,-1,11398,11414,11444,-1,11447,11448,11446,-1,11446,11445,11447,-1,11447,11441,11439,-1,11439,11443,11447,-1,11444,11414,11413,-1,11413,11441,11444,-1,11449,11450,11383,-1,11383,11382,11449,-1,11401,11383,11450,-1,11450,11418,11401,-1,11450,11449,11419,-1,11419,11421,11450,-1,11451,11449,11382,-1,11382,11385,11451,-1,11452,11419,11449,-1,11449,11451,11452,-1,11419,11452,11437,-1,11437,11420,11419,-1,11448,11452,11451,-1,11451,11446,11448,-1,11453,11436,11437,-1,11437,11454,11453,-1,11442,11453,11454,-1,11454,11443,11442,-1,11452,11448,11454,-1,11454,11437,11452,-1,11448,11447,11443,-1,11443,11454,11448,-1,11446,11451,11385,-1,11385,11387,11446,-1,11422,11409,11410,-1,11410,11423,11422,-1,11409,11422,11360,-1,11360,11336,11409,-1,11399,11417,11411,-1,11411,11342,11399,-1,11415,11414,11398,-1,11398,11360,11415,-1,11455,11413,11415,-1,11415,11423,11455,-1,11434,11432,11456,-1,11456,11438,11434,-1,11438,11456,11416,-1,11416,11418,11438,-1,11432,11430,11457,-1,11457,11456,11432,-1,11456,11457,11458,-1,11458,11416,11456,-1,11418,11450,11421,-1,11421,11438,11418,-1,11401,11418,11417,-1,11417,11399,11401,-1,11417,11416,11412,-1,11412,11411,11417,-1,11416,11458,11424,-1,11424,11412,11416,-1,11430,11428,11455,-1,11455,11457,11430,-1,11457,11455,11423,-1,11423,11458,11457,-1,11458,11423,11410,-1,11410,11424,11458,-1,11428,11427,11413,-1,11413,11455,11428,-1,11459,11460,11461,-1,11462,11463,11464,-1,11465,11460,11466,-1,11464,11467,11468,-1,11469,11470,11471,-1,11472,11473,11474,-1,11475,11476,11477,-1,11477,11476,11478,-1,11479,11477,11480,-1,11477,11478,11480,-1,11460,11465,11481,-1,11481,11461,11460,-1,11466,11460,11459,-1,11459,11482,11466,-1,11469,11459,11461,-1,11461,11470,11469,-1,11467,11464,11463,-1,11463,11483,11467,-1,11473,11463,11462,-1,11462,11474,11473,-1,11462,11464,11468,-1,11468,11484,11462,-1,11470,11461,11481,-1,11481,11485,11470,-1,11465,11486,11487,-1,11487,11481,11465,-1,11488,11485,11481,-1,11481,11487,11488,-1,11486,11467,11483,-1,11483,11487,11486,-1,11489,11486,11465,-1,11465,11466,11489,-1,11490,11488,11487,-1,11487,11483,11490,-1,11468,11467,11486,-1,11486,11489,11468,-1,11473,11490,11483,-1,11483,11463,11473,-1,11484,11468,11489,-1,11489,11491,11484,-1,11484,11492,11474,-1,11474,11462,11484,-1,11491,11489,11466,-1,11466,11482,11491,-1,11492,11484,11491,-1,11491,11493,11492,-1,11482,11494,11493,-1,11493,11491,11482,-1,11494,11482,11459,-1,11459,11469,11494,-1,11469,11471,11495,-1,11495,11494,11469,-1,11496,11472,11474,-1,11474,11492,11496,-1,11497,11498,11426,-1,11426,11425,11497,-1,11440,11426,11498,-1,11498,11499,11440,-1,11495,11471,11498,-1,11498,11497,11495,-1,11425,11429,11500,-1,11500,11497,11425,-1,11501,11495,11497,-1,11497,11500,11501,-1,11429,11431,11502,-1,11502,11500,11429,-1,11496,11501,11500,-1,11500,11502,11496,-1,11503,11502,11431,-1,11431,11433,11503,-1,11501,11493,11494,-1,11494,11495,11501,-1,11488,11504,11505,-1,11505,11485,11488,-1,11504,11488,11490,-1,11490,11506,11504,-1,11473,11507,11506,-1,11506,11490,11473,-1,11508,11470,11485,-1,11485,11505,11508,-1,11492,11493,11501,-1,11501,11496,11492,-1,11433,11435,11509,-1,11509,11503,11433,-1,11435,11436,11510,-1,11510,11509,11435,-1,11442,11440,11499,-1,11499,11511,11442,-1,11436,11453,11512,-1,11512,11510,11436,-1,11453,11442,11511,-1,11511,11512,11453,-1,11475,11508,11505,-1,11505,11476,11475,-1,11513,11514,11475,-1,11475,11477,11513,-1,11515,11513,11477,-1,11477,11479,11515,-1,11480,11506,11507,-1,11507,11479,11480,-1,11472,11496,11502,-1,11502,11503,11472,-1,11516,11472,11503,-1,11503,11509,11516,-1,11499,11498,11471,-1,11471,11517,11499,-1,11517,11471,11470,-1,11470,11508,11517,-1,11472,11516,11507,-1,11507,11473,11472,-1,11511,11499,11517,-1,11517,11514,11511,-1,11514,11517,11508,-1,11508,11475,11514,-1,11512,11511,11514,-1,11514,11513,11512,-1,11476,11505,11504,-1,11504,11478,11476,-1,11478,11504,11506,-1,11506,11480,11478,-1,11479,11507,11516,-1,11516,11515,11479,-1,11516,11509,11510,-1,11510,11515,11516,-1,11510,11512,11513,-1,11513,11515,11510,-1,11518,11519,11520,-1,11521,11522,11523,-1,11523,11524,11525,-1,11524,11526,11527,-1,11528,11529,11530,-1,11531,11532,11533,-1,11534,11530,11529,-1,11532,11535,11533,-1,11536,11537,11535,-1,11538,10692,10693,-1,10694,11539,10760,-1,11540,11541,11542,-1,11543,11544,11545,-1,10894,11546,10880,-1,11547,10894,10769,-1,11537,11533,11535,-1,11548,11549,10716,-1,10716,10715,11548,-1,11519,11518,11550,-1,11550,11551,11519,-1,11551,11550,11552,-1,11552,11553,11551,-1,10727,10729,11550,-1,11550,11518,10727,-1,11554,11519,11551,-1,11551,11555,11554,-1,10727,11518,11520,-1,11520,10726,10727,-1,11532,11531,11528,-1,11528,11530,11532,-1,11524,11523,11522,-1,11522,11526,11524,-1,11522,11536,11556,-1,11556,11526,11522,-1,11557,11527,11526,-1,11526,11556,11557,-1,11536,11535,11534,-1,11534,11556,11536,-1,11522,11555,11558,-1,11558,11536,11522,-1,11535,11532,11530,-1,11530,11534,11535,-1,11529,11557,11556,-1,11556,11534,11529,-1,10719,11559,11560,-1,11560,10769,10719,-1,11561,11547,10769,-1,10769,11560,11561,-1,11560,11559,11562,-1,11562,11563,11560,-1,10716,11564,11559,-1,11559,10719,10716,-1,11564,10716,11549,-1,11549,11565,11564,-1,11565,11549,11566,-1,11566,11567,11565,-1,11568,11569,11564,-1,11564,11565,11568,-1,11567,11566,10692,-1,10692,11570,11567,-1,11549,11548,11571,-1,11571,11566,11549,-1,11572,11568,11565,-1,11565,11567,11572,-1,11570,10692,11538,-1,11538,11573,11570,-1,11566,11571,10549,-1,10549,10692,11566,-1,11567,11570,11574,-1,11574,11572,11567,-1,11548,11575,11539,-1,11539,11571,11548,-1,11538,11576,11577,-1,11577,11573,11538,-1,11570,11573,11578,-1,11578,11574,11570,-1,10693,10730,11576,-1,11576,11538,10693,-1,10726,11520,11576,-1,11576,10730,10726,-1,10549,11571,11539,-1,11539,10694,10549,-1,11559,11564,11569,-1,11569,11562,11559,-1,11575,10583,10760,-1,10760,11539,11575,-1,11575,11548,10715,-1,10715,10718,11575,-1,11575,10718,10584,-1,10584,10583,11575,-1,11542,11579,11580,-1,11580,11540,11542,-1,11579,11581,11582,-1,11582,11580,11579,-1,11583,11584,11579,-1,11579,11542,11583,-1,11542,11541,11585,-1,11585,11583,11542,-1,11544,11582,11581,-1,11581,11545,11544,-1,11581,11579,11584,-1,11584,11586,11581,-1,11586,11587,11545,-1,11545,11581,11586,-1,11587,11588,11543,-1,11543,11545,11587,-1,11563,11562,11585,-1,11585,11533,11563,-1,11589,11561,11560,-1,11560,11563,11589,-1,11583,11585,11562,-1,11562,11569,11583,-1,10729,10881,10880,-1,10880,11546,10729,-1,11546,11552,11550,-1,11550,10729,11546,-1,11547,11552,11546,-1,11546,10894,11547,-1,11553,11552,11547,-1,11547,11561,11553,-1,11576,11520,11519,-1,11519,11577,11576,-1,11555,11551,11553,-1,11553,11558,11555,-1,11558,11553,11561,-1,11561,11589,11558,-1,11521,11554,11555,-1,11555,11522,11521,-1,11521,11590,11591,-1,11591,11554,11521,-1,11536,11558,11589,-1,11589,11537,11536,-1,11537,11589,11563,-1,11563,11533,11537,-1,11554,11591,11577,-1,11577,11519,11554,-1,11533,11585,11541,-1,11541,11531,11533,-1,11592,11521,11523,-1,11523,11525,11592,-1,11592,11593,11590,-1,11590,11521,11592,-1,11572,11574,11587,-1,11587,11586,11572,-1,11574,11578,11588,-1,11588,11587,11574,-1,11586,11584,11568,-1,11568,11572,11586,-1,11584,11583,11569,-1,11569,11568,11584,-1,11573,11577,11591,-1,11591,11578,11573,-1,11578,11591,11590,-1,11590,11588,11578,-1,11588,11590,11593,-1,11593,11543,11588,-1,11529,11528,11594,-1,11595,11531,11596,-1,11597,11524,11527,-1,11529,11594,11598,-1,11599,11597,11527,-1,11600,11601,11602,-1,11601,11603,11602,-1,11604,11605,11606,-1,11607,11603,11606,-1,11608,11607,11609,-1,11608,11609,11610,-1,11611,11540,11580,-1,11543,11612,11544,-1,11531,11595,11594,-1,11594,11528,11531,-1,11594,11595,11613,-1,11613,11598,11594,-1,11614,11525,11524,-1,11524,11597,11614,-1,11525,11614,11615,-1,11615,11592,11525,-1,11597,11599,11616,-1,11616,11614,11597,-1,11617,11598,11613,-1,11613,11618,11617,-1,11619,11613,11595,-1,11595,11596,11619,-1,11615,11614,11616,-1,11616,11620,11615,-1,11599,11617,11618,-1,11618,11616,11599,-1,11618,11621,11620,-1,11620,11616,11618,-1,11599,11527,11557,-1,11557,11617,11599,-1,11621,11618,11613,-1,11613,11619,11621,-1,11617,11557,11529,-1,11529,11598,11617,-1,11600,11622,11623,-1,11623,11601,11600,-1,11602,11624,11625,-1,11625,11600,11602,-1,11605,11609,11607,-1,11607,11606,11605,-1,11604,11626,11627,-1,11627,11605,11604,-1,11601,11604,11606,-1,11606,11603,11601,-1,11601,11623,11626,-1,11626,11604,11601,-1,11607,11608,11602,-1,11602,11603,11607,-1,11602,11608,11610,-1,11610,11624,11602,-1,11628,11629,11630,-1,11630,11631,11628,-1,11632,11631,11630,-1,11630,11633,11632,-1,11634,11635,11630,-1,11630,11629,11634,-1,11628,11609,11605,-1,11605,11629,11628,-1,11636,11600,11625,-1,11625,11637,11636,-1,11638,11622,11600,-1,11600,11636,11638,-1,11637,11639,11640,-1,11640,11636,11637,-1,11580,11641,11642,-1,11642,11611,11580,-1,11642,11635,11643,-1,11643,11611,11642,-1,11644,11633,11642,-1,11642,11641,11644,-1,11645,11641,11580,-1,11580,11582,11645,-1,11544,11612,11646,-1,11646,11647,11544,-1,11647,11646,11640,-1,11640,11648,11647,-1,11612,11649,11638,-1,11638,11646,11612,-1,11582,11544,11647,-1,11647,11645,11582,-1,11630,11635,11642,-1,11642,11633,11630,-1,11633,11644,11650,-1,11650,11632,11633,-1,11644,11651,11652,-1,11652,11650,11644,-1,11653,11652,11651,-1,11651,11648,11653,-1,11651,11644,11641,-1,11641,11645,11651,-1,11645,11647,11648,-1,11648,11651,11645,-1,11639,11653,11648,-1,11648,11640,11639,-1,11638,11636,11640,-1,11640,11646,11638,-1,11643,11541,11540,-1,11540,11611,11643,-1,11605,11627,11634,-1,11634,11629,11605,-1,11620,11623,11622,-1,11622,11615,11620,-1,11621,11626,11623,-1,11623,11620,11621,-1,11619,11627,11626,-1,11626,11621,11619,-1,11634,11627,11619,-1,11619,11596,11634,-1,11596,11643,11635,-1,11635,11634,11596,-1,11622,11638,11649,-1,11649,11615,11622,-1,11531,11541,11643,-1,11643,11596,11531,-1,11615,11649,11593,-1,11593,11592,11615,-1,11543,11593,11649,-1,11649,11612,11543,-1,11654,11655,11656,-1,11657,11658,11659,-1,11660,11655,11661,-1,11662,11659,11663,-1,11664,11665,11666,-1,11667,11668,11669,-1,11670,11671,11672,-1,11673,11672,11671,-1,11670,11674,11671,-1,11675,11671,11674,-1,11676,11677,11672,-1,11674,11678,11679,-1,11655,11660,11680,-1,11680,11656,11655,-1,11655,11654,11681,-1,11681,11661,11655,-1,11656,11665,11682,-1,11682,11654,11656,-1,11663,11659,11658,-1,11658,11683,11663,-1,11668,11658,11657,-1,11657,11669,11668,-1,11659,11662,11684,-1,11684,11657,11659,-1,11666,11665,11656,-1,11656,11680,11666,-1,11660,11685,11686,-1,11686,11680,11660,-1,11687,11666,11680,-1,11680,11686,11687,-1,11685,11663,11683,-1,11683,11686,11685,-1,11688,11685,11660,-1,11660,11661,11688,-1,11689,11687,11686,-1,11686,11683,11689,-1,11685,11688,11662,-1,11662,11663,11685,-1,11668,11689,11683,-1,11683,11658,11668,-1,11688,11690,11684,-1,11684,11662,11688,-1,11691,11669,11657,-1,11657,11684,11691,-1,11661,11681,11690,-1,11690,11688,11661,-1,11682,11692,11681,-1,11681,11654,11682,-1,11690,11681,11692,-1,11692,11693,11690,-1,11684,11690,11693,-1,11693,11691,11684,-1,11694,11682,11665,-1,11665,11664,11694,-1,11666,11695,11696,-1,11696,11664,11666,-1,11697,11624,11610,-1,11610,11698,11697,-1,11698,11610,11609,-1,11609,11699,11698,-1,11700,11692,11682,-1,11682,11694,11700,-1,11701,11694,11664,-1,11664,11696,11701,-1,11702,11668,11667,-1,11667,11703,11702,-1,11691,11704,11667,-1,11667,11669,11691,-1,11695,11666,11687,-1,11687,11705,11695,-1,11693,11692,11700,-1,11700,11706,11693,-1,11693,11706,11704,-1,11704,11691,11693,-1,11707,11689,11668,-1,11668,11702,11707,-1,11705,11687,11689,-1,11689,11707,11705,-1,11628,11631,11708,-1,11708,11709,11628,-1,11710,11711,11637,-1,11637,11625,11710,-1,11708,11631,11632,-1,11632,11712,11708,-1,11713,11712,11632,-1,11632,11650,11713,-1,11714,11713,11650,-1,11650,11652,11714,-1,11652,11653,11715,-1,11715,11714,11652,-1,11653,11639,11716,-1,11716,11715,11653,-1,11711,11716,11639,-1,11639,11637,11711,-1,11670,11672,11677,-1,11677,11717,11670,-1,11671,11675,11713,-1,11713,11714,11671,-1,11674,11679,11718,-1,11718,11675,11674,-1,11677,11695,11705,-1,11705,11717,11677,-1,11670,11717,11678,-1,11678,11674,11670,-1,11717,11705,11707,-1,11707,11678,11717,-1,11706,11698,11699,-1,11699,11704,11706,-1,11700,11697,11698,-1,11698,11706,11700,-1,11694,11710,11697,-1,11697,11700,11694,-1,11704,11699,11709,-1,11709,11667,11704,-1,11710,11625,11624,-1,11624,11697,11710,-1,11711,11710,11694,-1,11694,11701,11711,-1,11709,11708,11703,-1,11703,11667,11709,-1,11699,11609,11628,-1,11628,11709,11699,-1,11701,11719,11716,-1,11716,11711,11701,-1,11719,11673,11715,-1,11715,11716,11719,-1,11719,11701,11696,-1,11696,11676,11719,-1,11714,11715,11673,-1,11673,11671,11714,-1,11673,11719,11676,-1,11676,11672,11673,-1,11675,11718,11712,-1,11712,11713,11675,-1,11676,11696,11695,-1,11695,11677,11676,-1,11678,11707,11702,-1,11702,11679,11678,-1,11702,11703,11718,-1,11718,11679,11702,-1,11703,11708,11712,-1,11712,11718,11703,-1,11720,11721,11722,-1,11723,11721,11724,-1,11725,11726,11727,-1,11727,11728,11729,-1,10563,10565,11730,-1,11731,11732,11733,-1,11734,11735,11736,-1,11737,11738,11739,-1,11740,10901,10899,-1,10546,11741,11742,-1,11742,10547,10546,-1,10566,11743,11744,-1,11744,10568,10566,-1,11745,11746,10568,-1,10568,11744,11745,-1,11724,11747,11744,-1,11744,11743,11724,-1,11743,10566,10547,-1,10547,11742,11743,-1,11744,11747,11748,-1,11748,11745,11744,-1,11724,11721,11720,-1,11720,11747,11724,-1,11724,11743,11742,-1,11742,11723,11724,-1,11720,11749,11748,-1,11748,11747,11720,-1,11728,11727,11726,-1,11726,11750,11728,-1,11751,11752,11750,-1,11750,11726,11751,-1,11751,11722,11753,-1,11753,11752,11751,-1,11726,11725,11749,-1,11749,11751,11726,-1,11754,11753,11722,-1,11722,11721,11754,-1,11754,11721,11723,-1,11723,11755,11754,-1,11727,11729,11756,-1,11756,11725,11727,-1,11749,11725,11756,-1,11756,11748,11749,-1,11756,11729,11757,-1,11757,11758,11756,-1,11722,11751,11749,-1,11749,11720,11722,-1,11745,11748,11756,-1,11756,11758,11745,-1,11730,10565,10901,-1,10901,11759,11730,-1,11730,11757,11760,-1,11760,10563,11730,-1,11738,11761,11732,-1,11732,11731,11738,-1,11733,11762,11763,-1,11763,11731,11733,-1,11764,11738,11731,-1,11731,11763,11764,-1,11762,11765,11766,-1,11766,11763,11762,-1,11736,11735,11767,-1,11767,11768,11736,-1,11736,11769,11770,-1,11770,11734,11736,-1,11769,11766,11765,-1,11765,11770,11769,-1,11736,11768,11771,-1,11771,11769,11736,-1,11766,11769,11771,-1,11771,11772,11766,-1,11772,11764,11763,-1,11763,11766,11772,-1,11737,10763,10563,-1,10563,11760,11737,-1,10763,11737,11739,-1,11739,10766,10763,-1,11773,10577,10766,-1,10766,11739,11773,-1,10577,11773,11774,-1,11774,10575,10577,-1,11775,10691,10761,-1,10761,11776,11775,-1,10691,11775,11741,-1,11741,10546,10691,-1,11768,11767,11741,-1,11741,11775,11768,-1,11776,10761,10575,-1,10575,11774,11776,-1,11742,11741,11767,-1,11767,11723,11742,-1,11738,11737,11760,-1,11760,11761,11738,-1,11729,11761,11760,-1,11760,11757,11729,-1,10568,11746,11740,-1,11740,10569,10568,-1,10651,10569,11740,-1,11740,10905,10651,-1,11771,11768,11775,-1,11775,11776,11771,-1,10899,10903,10905,-1,10905,11740,10899,-1,11759,10901,11740,-1,11740,11746,11759,-1,11767,11735,11755,-1,11755,11723,11767,-1,11729,11728,11732,-1,11732,11761,11729,-1,11758,11759,11746,-1,11746,11745,11758,-1,11758,11757,11730,-1,11730,11759,11758,-1,11774,11773,11764,-1,11764,11772,11774,-1,11773,11739,11738,-1,11738,11764,11773,-1,11772,11771,11776,-1,11776,11774,11772,-1,11750,11777,11728,-1,11753,11754,11778,-1,11777,11750,11779,-1,11780,11728,11777,-1,11781,11753,11778,-1,11779,11750,11752,-1,11752,11782,11779,-1,11783,11784,11780,-1,11780,11785,11783,-1,11780,11786,11787,-1,11787,11785,11780,-1,11728,11780,11784,-1,11784,11732,11728,-1,11788,11784,11783,-1,11783,11789,11788,-1,11790,11791,11783,-1,11783,11785,11790,-1,11792,11793,11794,-1,11794,11795,11792,-1,11796,11797,11795,-1,11795,11794,11796,-1,11793,11798,11799,-1,11799,11794,11793,-1,11792,11781,11778,-1,11778,11793,11792,-1,11800,11792,11795,-1,11795,11801,11800,-1,11787,11802,11790,-1,11790,11785,11787,-1,11786,11800,11801,-1,11801,11787,11786,-1,11779,11786,11780,-1,11780,11777,11779,-1,11801,11803,11802,-1,11802,11787,11801,-1,11782,11800,11786,-1,11786,11779,11782,-1,11795,11797,11803,-1,11803,11801,11795,-1,11781,11792,11800,-1,11800,11782,11781,-1,11783,11791,11804,-1,11804,11789,11783,-1,11804,11805,11806,-1,11806,11789,11804,-1,11807,11796,11794,-1,11794,11799,11807,-1,11799,11808,11809,-1,11809,11807,11799,-1,11810,11788,11789,-1,11789,11806,11810,-1,11805,11811,11812,-1,11812,11806,11805,-1,11808,11813,11814,-1,11814,11809,11808,-1,11808,11799,11798,-1,11798,11815,11808,-1,11813,11812,11811,-1,11811,11814,11813,-1,11813,11808,11815,-1,11815,11816,11813,-1,11812,11813,11816,-1,11816,11817,11812,-1,11817,11810,11806,-1,11806,11812,11817,-1,11733,11732,11784,-1,11784,11788,11733,-1,11762,11733,11788,-1,11788,11810,11762,-1,11810,11817,11765,-1,11765,11762,11810,-1,11815,11798,11735,-1,11735,11734,11815,-1,11798,11793,11755,-1,11755,11735,11798,-1,11734,11770,11816,-1,11816,11815,11734,-1,11770,11765,11817,-1,11817,11816,11770,-1,11778,11754,11755,-1,11755,11793,11778,-1,11782,11752,11753,-1,11753,11781,11782,-1,11818,11819,11820,-1,11818,11821,11819,-1,11822,11823,11824,-1,11824,11823,11825,-1,11819,11821,11826,-1,11823,11827,11825,-1,11818,11828,11821,-1,11829,11824,11825,-1,11830,11831,11802,-1,11797,11832,11833,-1,11834,11835,11836,-1,11835,11837,11838,-1,11839,11840,11834,-1,11841,11842,11839,-1,11839,11842,11840,-1,11843,11831,11841,-1,11844,11845,11832,-1,11846,11847,11848,-1,11830,11820,11819,-1,11819,11831,11830,-1,11849,11850,11818,-1,11818,11820,11849,-1,11822,11833,11832,-1,11832,11823,11822,-1,11822,11824,11850,-1,11850,11849,11822,-1,11821,11828,11851,-1,11851,11826,11821,-1,11831,11819,11826,-1,11826,11841,11831,-1,11829,11825,11827,-1,11827,11852,11829,-1,11845,11827,11823,-1,11823,11832,11845,-1,11841,11826,11851,-1,11851,11842,11841,-1,11828,11853,11854,-1,11854,11851,11828,-1,11855,11842,11851,-1,11851,11854,11855,-1,11853,11829,11852,-1,11852,11854,11853,-1,11828,11818,11850,-1,11850,11853,11828,-1,11856,11855,11854,-1,11854,11852,11856,-1,11853,11850,11824,-1,11824,11829,11853,-1,11845,11856,11852,-1,11852,11827,11845,-1,11833,11822,11849,-1,11849,11857,11833,-1,11820,11830,11857,-1,11857,11849,11820,-1,11843,11790,11802,-1,11802,11831,11843,-1,11830,11802,11803,-1,11803,11857,11830,-1,11832,11797,11796,-1,11796,11844,11832,-1,11857,11803,11797,-1,11797,11833,11857,-1,11836,11835,11838,-1,11838,11858,11836,-1,11834,11840,11837,-1,11837,11835,11834,-1,11836,11859,11839,-1,11839,11834,11836,-1,11837,11840,11860,-1,11860,11861,11837,-1,11839,11859,11843,-1,11843,11841,11839,-1,11804,11791,11859,-1,11859,11836,11804,-1,11796,11807,11862,-1,11862,11844,11796,-1,11805,11804,11836,-1,11836,11858,11805,-1,11863,11862,11807,-1,11807,11809,11863,-1,11864,11863,11809,-1,11809,11814,11864,-1,11864,11814,11811,-1,11811,11865,11864,-1,11811,11805,11858,-1,11858,11865,11811,-1,11866,11856,11845,-1,11845,11867,11866,-1,11856,11866,11860,-1,11860,11855,11856,-1,11855,11860,11840,-1,11840,11842,11855,-1,11868,11865,11858,-1,11858,11838,11868,-1,11868,11838,11837,-1,11837,11861,11868,-1,11868,11861,11848,-1,11848,11847,11868,-1,11846,11863,11864,-1,11864,11847,11846,-1,11866,11867,11846,-1,11846,11848,11866,-1,11867,11845,11844,-1,11844,11862,11867,-1,11791,11790,11843,-1,11843,11859,11791,-1,11868,11847,11864,-1,11864,11865,11868,-1,11861,11860,11866,-1,11866,11848,11861,-1,11846,11867,11862,-1,11862,11863,11846,-1,11869,11870,11871,-1,11872,11869,11871,-1,11873,11874,11875,-1,11876,11877,11878,-1,11879,11880,11881,-1,11882,11883,11884,-1,11885,11886,11887,-1,11888,11889,11890,-1,11891,11892,11893,-1,11894,11892,11891,-1,11890,11892,11894,-1,11895,11896,11897,-1,11897,11896,11898,-1,11899,11900,11901,-1,11902,11903,11904,-1,11905,11906,11907,-1,11908,11909,11910,-1,11911,11912,11913,-1,11914,11898,11896,-1,11915,11916,11917,-1,11918,11919,11920,-1,11921,11922,11923,-1,11910,11921,11924,-1,11925,11926,11927,-1,11925,11927,11913,-1,11928,11929,11930,-1,11931,11932,11933,-1,11934,11935,11936,-1,11937,11938,11939,-1,11938,11940,11939,-1,11941,11942,11943,-1,11944,11945,11946,-1,11947,11948,11949,-1,11950,11951,11952,-1,11907,11953,11954,-1,11955,11956,11957,-1,11958,11959,11960,-1,11961,11958,11962,-1,11963,11964,11965,-1,11966,11967,11968,-1,11969,11964,11970,-1,11971,11972,11973,-1,11958,11961,11954,-1,11927,11926,11974,-1,11975,11976,11977,-1,11978,11979,11940,-1,11980,11981,11880,-1,11982,11887,11930,-1,11983,11930,11884,-1,11921,11910,11922,-1,11984,11985,11986,-1,11987,11988,11989,-1,456,11990,466,-1,482,466,11991,-1,11992,555,168,-1,482,11993,581,-1,585,11994,170,-1,11995,11996,11997,-1,11998,11999,12000,-1,12001,12002,11914,-1,11974,12003,12004,-1,12000,12005,11998,-1,12006,12007,11988,-1,11991,466,12008,-1,12009,12010,12011,-1,584,581,12012,-1,12013,12014,12015,-1,12016,12014,12013,-1,12017,12018,12019,-1,12020,12021,12022,-1,12023,12024,12025,-1,12026,12027,12028,-1,12029,12030,12031,-1,12032,12033,12034,-1,12035,12036,12015,-1,12037,12007,12038,-1,11899,12039,12040,-1,12041,12042,12043,-1,401,12044,12045,-1,12045,12046,401,-1,12047,12048,12049,-1,12050,12051,12052,-1,12050,12047,12053,-1,433,432,12054,-1,12053,12047,12055,-1,12056,12057,12055,-1,12044,504,524,-1,12058,90,12059,-1,12060,12061,12062,-1,12063,12064,12065,-1,12046,12048,12066,-1,12048,12047,12067,-1,12047,12050,12068,-1,420,419,414,-1,432,422,12069,-1,12051,12070,12071,-1,12072,12073,12052,-1,12074,12070,12075,-1,12076,12074,12077,-1,12078,12079,12080,-1,12081,12082,12083,-1,12084,12085,12086,-1,12087,12088,12089,-1,12090,12091,12092,-1,12092,12091,12093,-1,12094,11871,11870,-1,11870,12095,12094,-1,12096,12097,11870,-1,11870,11869,12096,-1,12098,12099,12100,-1,12100,12101,12098,-1,12100,12102,12103,-1,12103,12101,12100,-1,12104,11873,11875,-1,11875,12105,12104,-1,12106,12107,11873,-1,11873,12104,12106,-1,11876,11878,12108,-1,12108,12096,11876,-1,12096,12108,12107,-1,12107,12097,12096,-1,12108,11878,11873,-1,11873,12107,12108,-1,11872,11876,12096,-1,12096,11869,11872,-1,12104,12109,12110,-1,12110,12106,12104,-1,11874,11873,11878,-1,11878,11877,11874,-1,12109,11903,12111,-1,12111,12110,12109,-1,11903,11902,12112,-1,12112,12111,11903,-1,12099,12098,11892,-1,11892,12094,12099,-1,12113,11881,11880,-1,11880,12114,12113,-1,11980,11880,11879,-1,11879,12115,11980,-1,12116,11879,11881,-1,11881,12117,12116,-1,12118,12119,12120,-1,12120,12121,12118,-1,12122,12121,12120,-1,12120,12116,12122,-1,12115,12120,12119,-1,12119,12123,12115,-1,12124,12125,12119,-1,12119,12118,12124,-1,12126,12127,12128,-1,12128,12129,12126,-1,12130,12131,12129,-1,12129,12128,12130,-1,12132,12128,12127,-1,12127,12133,12132,-1,12134,12127,12126,-1,12126,12135,12134,-1,11882,11972,12136,-1,12136,11883,11882,-1,12137,11883,12136,-1,12136,12138,12137,-1,12139,12136,11972,-1,11972,11971,12139,-1,12140,11973,11972,-1,11972,11882,12140,-1,12141,11887,11886,-1,11886,12142,12141,-1,12143,12144,11886,-1,11886,11885,12143,-1,12145,11885,11887,-1,11887,11982,12145,-1,12144,11889,11888,-1,11888,11886,12144,-1,12142,11886,11888,-1,11888,12146,12142,-1,11877,11889,12144,-1,12144,11874,11877,-1,12147,12148,11891,-1,11891,11893,12147,-1,12149,12150,11891,-1,11891,12148,12149,-1,11895,12148,12147,-1,12147,12151,11895,-1,12152,12147,11893,-1,11893,12153,12152,-1,11987,11896,11895,-1,11895,12151,11987,-1,12148,11895,11897,-1,11897,12149,12148,-1,12154,12155,12146,-1,12146,11894,12154,-1,11888,11890,11894,-1,11894,12146,11888,-1,12156,12142,12146,-1,12146,12155,12156,-1,12155,12154,12157,-1,12157,12158,12155,-1,12154,11894,11891,-1,11891,12150,12154,-1,12159,12160,11928,-1,11928,12141,12159,-1,12141,11928,11930,-1,11930,11887,12141,-1,12160,12161,11929,-1,11929,11928,12160,-1,12159,12162,11909,-1,11909,12160,12159,-1,12159,12141,12142,-1,12142,12156,12159,-1,11892,11890,11871,-1,11871,12094,11892,-1,12101,12163,12153,-1,12153,12098,12101,-1,12098,12153,11893,-1,11893,11892,12098,-1,12153,12163,12164,-1,12164,12152,12153,-1,12103,12165,12163,-1,12163,12101,12103,-1,12166,12152,12164,-1,12164,12167,12166,-1,12165,12168,12164,-1,12164,12163,12165,-1,12166,12167,12169,-1,12169,12170,12166,-1,12169,12171,11997,-1,11997,12170,12169,-1,12172,11900,12169,-1,12169,12167,12172,-1,12151,12166,12170,-1,12170,11987,12151,-1,12170,11997,11988,-1,11988,11987,12170,-1,12169,11900,11899,-1,11899,12171,12169,-1,12173,12174,12165,-1,12165,12103,12173,-1,12164,12168,12172,-1,12172,12167,12164,-1,12174,12175,12168,-1,12168,12165,12174,-1,11941,11943,11900,-1,11900,12172,11941,-1,11943,12176,11901,-1,11901,11900,11943,-1,12143,12177,12105,-1,12105,11875,12143,-1,12109,12104,12105,-1,12105,11977,12109,-1,11977,12105,12177,-1,12177,11975,11977,-1,12177,12143,11885,-1,11885,12145,12177,-1,12143,11875,11874,-1,11874,12144,12143,-1,12109,11977,11904,-1,11904,11903,12109,-1,11902,11949,11948,-1,11948,12112,11902,-1,12178,12179,12180,-1,12180,11976,12178,-1,11977,11976,12180,-1,12180,11904,11977,-1,12179,12181,12182,-1,12182,12180,12179,-1,11944,12179,12178,-1,12178,12183,11944,-1,12184,12178,11976,-1,11976,11975,12184,-1,12185,12184,12145,-1,12145,11982,12185,-1,12145,12184,11975,-1,11975,12177,12145,-1,12185,12183,12178,-1,12178,12184,12185,-1,12185,11982,11930,-1,11930,11983,12185,-1,12139,12186,12138,-1,12138,12136,12139,-1,12137,11983,11884,-1,11884,11883,12137,-1,12187,11945,12137,-1,12137,12138,12187,-1,11905,12188,12189,-1,12189,11906,11905,-1,11974,12189,12188,-1,12188,11973,11974,-1,12190,12188,11905,-1,11905,11970,12190,-1,11920,11919,12158,-1,12158,12157,11920,-1,12191,12157,12154,-1,12154,12150,12191,-1,12156,12155,12158,-1,12158,12192,12156,-1,12192,12158,11919,-1,11919,11923,12192,-1,12159,12156,12192,-1,12192,12162,12159,-1,12162,12192,11923,-1,11923,11922,12162,-1,12160,11909,11908,-1,11908,12161,12160,-1,12161,11908,12193,-1,12193,11912,12161,-1,11912,11911,11929,-1,11929,12161,11912,-1,11882,11929,11911,-1,11911,12140,11882,-1,11912,12193,12194,-1,12194,11913,11912,-1,12140,11911,11913,-1,11913,11927,12140,-1,11915,11898,11914,-1,11914,12002,11915,-1,11989,11914,11896,-1,11896,11987,11989,-1,11916,12195,12196,-1,12196,11917,11916,-1,11916,11915,12197,-1,12197,12198,11916,-1,11917,11897,11898,-1,11898,11915,11917,-1,12149,12196,12191,-1,12191,12150,12149,-1,12195,12199,12191,-1,12191,12196,12195,-1,11897,11917,12196,-1,12196,12149,11897,-1,12198,11918,12195,-1,12195,11916,12198,-1,12191,12199,11920,-1,11920,12157,12191,-1,11920,12199,12195,-1,12195,11918,11920,-1,12162,11922,11910,-1,11910,11909,12162,-1,11908,11910,11924,-1,11924,12193,11908,-1,12193,11924,12200,-1,12200,12194,12193,-1,11924,12198,12197,-1,12197,12200,11924,-1,11918,12198,11924,-1,11924,11921,11918,-1,11918,11921,11923,-1,11923,11919,11918,-1,11927,11974,11973,-1,11973,12140,11927,-1,11884,11930,11929,-1,11929,11882,11884,-1,11872,11871,11890,-1,11890,11889,11872,-1,12201,12202,11932,-1,11932,12203,12201,-1,12204,12203,11932,-1,11932,11931,12204,-1,12205,11932,12202,-1,12202,12206,12205,-1,12207,12201,12203,-1,12203,12208,12207,-1,11932,12205,12209,-1,12209,11933,11932,-1,12210,12211,11933,-1,11933,12209,12210,-1,12212,12209,12205,-1,12205,11939,12212,-1,12211,12210,11934,-1,11934,11984,12211,-1,11934,12213,11985,-1,11985,11984,11934,-1,11935,11934,12210,-1,12210,12214,11935,-1,11986,12215,12211,-1,12211,11984,11986,-1,11985,12213,12216,-1,12216,12217,11985,-1,12213,12218,12219,-1,12219,12216,12213,-1,12220,11985,12217,-1,12217,12221,12220,-1,12208,12203,12204,-1,12204,12222,12208,-1,12223,12207,12208,-1,12208,12224,12223,-1,12114,12222,12204,-1,12204,12225,12114,-1,11981,12224,12208,-1,12208,12222,11981,-1,12114,12225,12226,-1,12226,12113,12114,-1,12227,12113,12226,-1,12226,12220,12227,-1,12225,12215,11986,-1,11986,12226,12225,-1,12227,12220,12221,-1,12221,12228,12227,-1,12117,12227,12228,-1,12228,12229,12117,-1,12218,12230,12231,-1,12231,12219,12218,-1,11936,12218,12213,-1,12213,11934,11936,-1,12212,12214,12210,-1,12210,12209,12212,-1,12232,11935,12214,-1,12214,12233,12232,-1,11939,12205,12206,-1,12206,11937,11939,-1,11979,12212,11939,-1,11939,11940,11979,-1,11943,11938,11937,-1,11937,12176,11943,-1,12234,12235,12236,-1,12236,12237,12234,-1,11942,12237,12236,-1,12236,12238,11942,-1,12239,12236,12235,-1,12235,12240,12239,-1,12241,12235,12234,-1,12234,12242,12241,-1,12174,12234,12237,-1,12237,12175,12174,-1,11942,12238,11938,-1,11938,11943,11942,-1,11940,11938,12238,-1,12238,11978,11940,-1,12119,12125,12243,-1,12243,12123,12119,-1,12131,12130,12125,-1,12125,12124,12131,-1,12123,12243,12244,-1,12244,12245,12123,-1,12246,12245,12244,-1,12244,12247,12246,-1,12244,12243,12248,-1,12248,11957,12244,-1,12115,12123,12245,-1,12245,11980,12115,-1,12246,12247,12249,-1,12249,12250,12246,-1,12251,12252,12250,-1,12250,12249,12251,-1,12253,12249,12247,-1,12247,11956,12253,-1,11981,12246,12250,-1,12250,12224,11981,-1,12229,12122,12116,-1,12116,12117,12229,-1,12246,11981,11980,-1,11980,12245,12246,-1,12224,12250,12252,-1,12252,12223,12224,-1,12244,11957,11956,-1,11956,12247,12244,-1,12249,12253,12254,-1,12254,12251,12249,-1,12255,12256,12253,-1,12253,11956,12255,-1,12168,12175,11941,-1,11941,12172,12168,-1,11907,11954,11970,-1,11970,11905,11907,-1,11946,11945,12187,-1,12187,11966,11946,-1,12257,11967,11966,-1,11966,12187,12257,-1,12258,11946,11966,-1,11966,11968,12258,-1,12182,12259,11949,-1,11949,11902,12182,-1,12242,11951,11950,-1,11950,12241,12242,-1,12260,11950,11952,-1,11952,12261,12260,-1,12174,12173,12242,-1,12242,12234,12174,-1,12102,12262,12173,-1,12173,12103,12102,-1,12241,12263,12240,-1,12240,12235,12241,-1,11954,11961,11969,-1,11969,11970,11954,-1,12248,12132,11955,-1,11955,11957,12248,-1,12133,12264,11955,-1,11955,12132,12133,-1,12132,12248,12130,-1,12130,12128,12132,-1,12181,12265,12259,-1,12259,12182,12181,-1,12265,12266,12267,-1,12267,12259,12265,-1,12258,12265,12181,-1,12181,11946,12258,-1,12125,12130,12248,-1,12248,12243,12125,-1,12253,12256,12268,-1,12268,12254,12253,-1,11953,12268,12256,-1,12256,11959,11953,-1,12133,12269,12270,-1,12270,12264,12133,-1,12255,12264,12270,-1,12270,11960,12255,-1,12271,12270,12269,-1,12269,12272,12271,-1,12127,12134,12269,-1,12269,12133,12127,-1,12273,12134,12135,-1,12135,12274,12273,-1,12255,11960,11959,-1,11959,12256,12255,-1,11953,11959,11958,-1,11958,11954,11953,-1,11962,11958,11960,-1,11960,12275,11962,-1,12134,12273,12272,-1,12272,12269,12134,-1,11947,12273,12274,-1,12274,11948,11947,-1,12275,11960,12270,-1,12270,12271,12275,-1,12266,12271,12272,-1,12272,12267,12266,-1,11969,11961,11962,-1,11962,12276,11969,-1,12277,12278,12276,-1,12276,11962,12277,-1,12279,11964,11969,-1,11969,12276,12279,-1,12186,12139,11963,-1,11963,11965,12186,-1,11971,12190,11963,-1,11963,12139,11971,-1,12257,12186,11965,-1,11965,12280,12257,-1,12275,12281,12277,-1,12277,11962,12275,-1,12277,12281,12258,-1,12258,11968,12277,-1,12266,12281,12275,-1,12275,12271,12266,-1,12267,11947,11949,-1,11949,12259,12267,-1,12281,12266,12265,-1,12265,12258,12281,-1,11955,12264,12255,-1,12255,11956,11955,-1,12278,12277,11968,-1,11968,11967,12278,-1,12280,12278,11967,-1,11967,12257,12280,-1,11963,12190,11970,-1,11970,11964,11963,-1,11973,12188,12190,-1,12190,11971,11973,-1,12183,12137,11945,-1,11945,11944,12183,-1,12257,12187,12138,-1,12138,12186,12257,-1,12280,12279,12276,-1,12276,12278,12280,-1,11876,11872,11889,-1,11889,11877,11876,-1,11904,12180,12182,-1,12182,11902,11904,-1,11946,12181,12179,-1,12179,11944,11946,-1,12282,12232,12240,-1,12240,12263,12282,-1,12233,12239,12240,-1,12240,12232,12233,-1,12282,11936,11935,-1,11935,12232,12282,-1,12230,12282,12263,-1,12263,12260,12230,-1,11978,12239,12233,-1,12233,11979,11978,-1,12231,12230,12260,-1,12260,12261,12231,-1,11983,12137,12183,-1,12183,12185,11983,-1,12152,12166,12151,-1,12151,12147,12152,-1,11941,12175,12237,-1,12237,11942,11941,-1,12239,11978,12238,-1,12238,12236,12239,-1,11979,12233,12214,-1,12214,12212,11979,-1,12215,11931,11933,-1,11933,12211,12215,-1,12225,12204,11931,-1,11931,12215,12225,-1,11880,11981,12222,-1,12222,12114,11880,-1,12242,12173,12262,-1,12262,11951,12242,-1,12113,12227,12117,-1,12117,11881,12113,-1,12220,12226,11986,-1,11986,11985,12220,-1,12120,12115,11879,-1,11879,12116,12120,-1,12282,12230,12218,-1,12218,11936,12282,-1,12263,12241,11950,-1,11950,12260,12263,-1,11947,12267,12272,-1,12272,12273,11947,-1,11964,12279,12280,-1,12280,11965,11964,-1,12002,12005,12197,-1,12197,11915,12002,-1,12283,12284,12285,-1,12285,12286,12283,-1,12284,12283,12006,-1,12006,11996,12284,-1,37,454,12287,-1,12287,12288,37,-1,431,433,12289,-1,12289,437,431,-1,437,12289,12287,-1,12287,454,437,-1,38,37,12288,-1,12288,12290,38,-1,456,38,12290,-1,12290,11990,456,-1,11991,12291,11993,-1,11993,482,11991,-1,12292,12293,12294,-1,12294,12295,12292,-1,12294,12293,12296,-1,12296,12297,12294,-1,12297,12296,12298,-1,12298,12299,12297,-1,12299,12298,12300,-1,12300,12301,12299,-1,557,556,12302,-1,12302,12303,557,-1,557,12303,12304,-1,12304,552,557,-1,552,12304,12305,-1,12305,536,552,-1,536,12305,12306,-1,12306,533,536,-1,533,12306,12307,-1,12307,534,533,-1,12308,12307,12306,-1,12306,12301,12308,-1,12301,12306,12305,-1,12305,12299,12301,-1,12299,12305,12304,-1,12304,12297,12299,-1,12297,12304,12303,-1,12303,12294,12297,-1,12303,12302,12295,-1,12295,12294,12303,-1,12309,11906,12189,-1,12189,12310,12309,-1,12309,12310,12311,-1,12311,12312,12309,-1,12313,12311,12310,-1,12310,12004,12313,-1,12309,12312,12314,-1,12314,12315,12309,-1,12316,12317,12318,-1,12318,12319,12316,-1,12320,12036,12318,-1,12318,12317,12320,-1,12320,11999,11998,-1,11998,12036,12320,-1,12194,11999,12320,-1,12320,11913,12194,-1,12320,12317,11925,-1,11925,11913,12320,-1,12194,12200,12000,-1,12000,11999,12194,-1,12005,12002,12001,-1,12001,11998,12005,-1,12321,12001,11914,-1,11914,11989,12321,-1,12200,12197,12005,-1,12005,12000,12200,-1,12317,12316,11926,-1,11926,11925,12317,-1,11974,11926,12316,-1,12316,12003,11974,-1,12003,12316,12319,-1,12319,12322,12003,-1,11907,12315,12323,-1,12323,11953,11907,-1,12315,11907,11906,-1,11906,12309,12315,-1,12004,12310,12189,-1,12189,11974,12004,-1,12004,12003,12322,-1,12322,12313,12004,-1,11989,11988,12007,-1,12007,12321,11989,-1,11997,11996,12006,-1,12006,11988,11997,-1,12324,12323,12315,-1,12315,12314,12324,-1,12287,12325,12326,-1,12326,12288,12287,-1,12327,12290,12288,-1,12288,12326,12327,-1,12328,12329,12330,-1,12330,12331,12328,-1,12289,12332,12325,-1,12325,12287,12289,-1,12289,433,12333,-1,12333,12332,12289,-1,12334,12335,12336,-1,12336,12337,12334,-1,12338,12339,12340,-1,12340,12341,12338,-1,12331,12330,12335,-1,12335,12334,12331,-1,12342,12343,12329,-1,12329,12328,12342,-1,12290,12327,12344,-1,12344,11990,12290,-1,12345,12346,12343,-1,12343,12342,12345,-1,12347,12348,12349,-1,12349,12350,12347,-1,12351,12352,12346,-1,12346,12345,12351,-1,12353,12354,12349,-1,12349,12348,12353,-1,12355,12338,12341,-1,12341,12356,12355,-1,12357,12358,12359,-1,12359,12360,12357,-1,12361,12011,12362,-1,12362,12363,12361,-1,12364,12358,12357,-1,12357,12365,12364,-1,12366,12367,12354,-1,12354,12353,12366,-1,12368,12369,12370,-1,12370,12371,12368,-1,12356,12367,12366,-1,12366,12355,12356,-1,12083,12369,12368,-1,12368,12372,12083,-1,12008,466,11990,-1,11990,12344,12008,-1,12373,12371,12370,-1,12370,12374,12373,-1,12375,12376,12377,-1,12377,12378,12375,-1,12359,12033,12379,-1,12379,12380,12359,-1,12381,12382,12383,-1,12383,12384,12381,-1,12380,12379,12028,-1,12028,12385,12380,-1,12014,12386,12387,-1,12387,12388,12014,-1,12389,12390,12035,-1,12035,12388,12389,-1,12391,12026,12386,-1,12386,12029,12391,-1,12015,12014,12388,-1,12388,12035,12015,-1,12392,12393,12010,-1,12010,12009,12392,-1,12376,12375,12394,-1,12394,12395,12376,-1,12396,12381,12384,-1,12384,12397,12396,-1,12374,12364,12365,-1,12365,12373,12374,-1,12352,12351,12398,-1,12398,12291,12352,-1,12031,12399,12400,-1,12400,12401,12031,-1,12402,12037,12403,-1,12403,12030,12402,-1,12401,12391,12029,-1,12029,12031,12401,-1,12404,11993,12291,-1,12291,12398,12404,-1,12405,12406,12393,-1,12393,12392,12405,-1,12383,12382,12390,-1,12390,12389,12383,-1,12012,581,11993,-1,11993,12404,12012,-1,12407,12408,12405,-1,12405,12409,12407,-1,12410,12411,11992,-1,11992,168,12410,-1,12412,12413,12411,-1,12411,12410,12412,-1,12414,12415,12416,-1,12416,12417,12414,-1,12418,12419,12414,-1,12414,12417,12418,-1,12420,12292,12419,-1,12419,12418,12420,-1,12421,12400,12399,-1,12399,12422,12421,-1,12038,12423,12403,-1,12403,12037,12038,-1,12422,12424,12425,-1,12425,12421,12422,-1,12030,12014,12016,-1,12016,12402,12030,-1,12426,12427,12428,-1,12428,12429,12426,-1,12430,12296,12293,-1,12293,12431,12430,-1,12284,12432,12433,-1,12433,12285,12284,-1,12425,12424,12426,-1,12426,12429,12425,-1,12286,12423,12038,-1,12038,12283,12286,-1,12431,12293,12292,-1,12292,12420,12431,-1,12434,12435,12378,-1,12378,12377,12434,-1,12396,12397,12435,-1,12435,12434,12396,-1,556,555,11992,-1,11992,12436,556,-1,12436,11992,12411,-1,12411,12437,12436,-1,12413,12412,12438,-1,12438,12406,12413,-1,12406,12438,12439,-1,12439,12393,12406,-1,12393,12439,12440,-1,12440,12010,12393,-1,12010,12440,12020,-1,12020,12011,12010,-1,12441,12442,12443,-1,12443,12444,12441,-1,12445,12446,12447,-1,12447,12448,12445,-1,12448,12447,12449,-1,12449,12450,12448,-1,12451,12401,12400,-1,12400,12452,12451,-1,12453,12452,12454,-1,12454,12455,12453,-1,12455,12454,12456,-1,12456,12457,12455,-1,12458,12459,12431,-1,12431,12420,12458,-1,12458,12420,12418,-1,12418,12460,12458,-1,12460,12418,12417,-1,12417,12461,12460,-1,12461,12417,12416,-1,12416,12450,12461,-1,12450,12416,12462,-1,12462,12448,12450,-1,12448,12462,12463,-1,12463,12445,12448,-1,12444,12024,12023,-1,12023,12441,12444,-1,12441,12023,12347,-1,12347,12350,12441,-1,12464,12437,12408,-1,12408,12407,12464,-1,12457,12456,12465,-1,12465,12466,12457,-1,12466,12465,12467,-1,12467,12468,12466,-1,12469,12430,12431,-1,12431,12459,12469,-1,12445,12463,12444,-1,12444,12443,12445,-1,12416,12415,12470,-1,12470,12462,12416,-1,12462,12470,12471,-1,12471,12463,12462,-1,12463,12471,12024,-1,12024,12444,12463,-1,12363,12362,12472,-1,12472,12473,12363,-1,12473,12472,12474,-1,12474,12475,12473,-1,12475,12474,12476,-1,12476,12477,12475,-1,12477,12476,12478,-1,12478,12479,12477,-1,12479,12478,12480,-1,12480,12481,12479,-1,12480,12482,12483,-1,12483,12484,12480,-1,12011,12020,12022,-1,12022,12362,12011,-1,12362,12022,12485,-1,12485,12472,12362,-1,12485,12486,12487,-1,12487,12488,12485,-1,12488,12487,12018,-1,12018,12017,12488,-1,12019,12018,12489,-1,12489,12482,12019,-1,12482,12480,12478,-1,12478,12019,12482,-1,12019,12478,12476,-1,12476,12017,12019,-1,12017,12476,12474,-1,12474,12488,12017,-1,12488,12474,12472,-1,12472,12485,12488,-1,168,170,11994,-1,11994,12410,168,-1,12410,11994,12490,-1,12490,12412,12410,-1,12412,12490,12491,-1,12491,12438,12412,-1,12438,12491,12492,-1,12492,12439,12438,-1,12439,12492,12493,-1,12493,12440,12439,-1,12440,12493,12021,-1,12021,12020,12440,-1,12022,12021,12486,-1,12486,12485,12022,-1,12333,12336,12335,-1,12335,12332,12333,-1,12332,12335,12330,-1,12330,12325,12332,-1,12325,12330,12329,-1,12329,12326,12325,-1,12326,12329,12343,-1,12343,12327,12326,-1,12327,12343,12346,-1,12346,12344,12327,-1,12344,12346,12352,-1,12352,12008,12344,-1,12008,12352,12291,-1,12291,11991,12008,-1,12494,12495,12489,-1,12489,12496,12494,-1,12496,12489,12018,-1,12018,12497,12496,-1,12497,12018,12487,-1,12487,12498,12497,-1,12498,12487,12486,-1,12486,12499,12498,-1,12499,12486,12021,-1,12021,12500,12499,-1,12500,12021,12493,-1,12493,12501,12500,-1,12501,12493,12492,-1,12492,12502,12501,-1,12502,12492,12491,-1,12491,12503,12502,-1,12503,12491,12490,-1,12490,12504,12503,-1,12504,12490,11994,-1,11994,585,12504,-1,585,584,12012,-1,12012,12504,585,-1,12504,12012,12404,-1,12404,12503,12504,-1,12503,12404,12398,-1,12398,12502,12503,-1,12502,12398,12351,-1,12351,12501,12502,-1,12501,12351,12345,-1,12345,12500,12501,-1,12500,12345,12342,-1,12342,12499,12500,-1,12499,12342,12328,-1,12328,12498,12499,-1,12498,12328,12331,-1,12331,12497,12498,-1,12497,12331,12334,-1,12334,12496,12497,-1,12496,12334,12337,-1,12337,12494,12496,-1,12482,12489,12495,-1,12495,12483,12482,-1,12484,12505,12481,-1,12481,12480,12484,-1,12338,12481,12505,-1,12505,12339,12338,-1,12481,12338,12355,-1,12355,12479,12481,-1,12479,12355,12366,-1,12366,12477,12479,-1,12477,12366,12353,-1,12353,12475,12477,-1,12475,12353,12348,-1,12348,12473,12475,-1,12473,12348,12347,-1,12347,12363,12473,-1,12363,12347,12023,-1,12023,12361,12363,-1,12025,12024,12471,-1,12471,12506,12025,-1,12506,12471,12470,-1,12470,12507,12506,-1,12507,12470,12415,-1,12415,12508,12507,-1,12508,12415,12414,-1,12414,12509,12508,-1,12509,12414,12419,-1,12419,12510,12509,-1,12510,12419,12292,-1,12292,12295,12510,-1,12442,12441,12350,-1,12350,12360,12442,-1,12360,12350,12349,-1,12349,12357,12360,-1,12357,12349,12354,-1,12354,12365,12357,-1,12365,12354,12367,-1,12367,12373,12365,-1,12373,12367,12356,-1,12356,12371,12373,-1,12371,12356,12341,-1,12341,12368,12371,-1,12368,12341,12340,-1,12340,12372,12368,-1,12083,12082,12511,-1,12511,12369,12083,-1,12369,12511,12512,-1,12512,12370,12369,-1,12370,12512,12513,-1,12513,12374,12370,-1,12374,12513,12514,-1,12514,12364,12374,-1,12364,12514,12034,-1,12034,12358,12364,-1,12358,12034,12033,-1,12033,12359,12358,-1,12446,12445,12443,-1,12443,12385,12446,-1,12385,12443,12442,-1,12442,12380,12385,-1,12380,12442,12360,-1,12360,12359,12380,-1,12468,12469,12459,-1,12459,12466,12468,-1,12458,12457,12466,-1,12466,12459,12458,-1,12457,12458,12460,-1,12460,12455,12457,-1,12455,12460,12461,-1,12461,12453,12455,-1,12453,12461,12450,-1,12450,12449,12453,-1,12428,12467,12465,-1,12465,12429,12428,-1,12456,12425,12429,-1,12429,12465,12456,-1,12425,12456,12454,-1,12454,12421,12425,-1,12421,12454,12452,-1,12452,12400,12421,-1,12401,12451,12515,-1,12515,12391,12401,-1,12391,12515,12027,-1,12027,12026,12391,-1,12386,12014,12030,-1,12030,12029,12386,-1,12031,12030,12403,-1,12403,12399,12031,-1,12399,12403,12423,-1,12423,12422,12399,-1,12422,12423,12286,-1,12286,12424,12422,-1,12424,12286,12285,-1,12285,12426,12424,-1,12426,12285,12433,-1,12433,12427,12426,-1,12082,12394,12375,-1,12375,12511,12082,-1,12511,12375,12378,-1,12378,12512,12511,-1,12512,12378,12435,-1,12435,12513,12512,-1,12513,12435,12397,-1,12397,12514,12513,-1,12514,12397,12384,-1,12384,12034,12514,-1,12034,12384,12383,-1,12383,12032,12034,-1,12032,12383,12389,-1,12389,12516,12032,-1,12389,12388,12387,-1,12387,12516,12389,-1,12516,12379,12033,-1,12033,12032,12516,-1,12386,12026,12028,-1,12028,12387,12386,-1,12387,12028,12379,-1,12379,12516,12387,-1,12452,12453,12449,-1,12449,12451,12452,-1,12451,12449,12447,-1,12447,12515,12451,-1,12515,12447,12446,-1,12446,12027,12515,-1,12027,12446,12385,-1,12385,12028,12027,-1,12377,12312,12311,-1,12311,12434,12377,-1,12434,12311,12313,-1,12313,12396,12434,-1,12396,12313,12322,-1,12322,12381,12396,-1,12381,12322,12319,-1,12319,12382,12381,-1,12382,12319,12318,-1,12318,12390,12382,-1,12390,12318,12036,-1,12036,12035,12390,-1,12015,12036,11998,-1,11998,12013,12015,-1,12013,11998,12001,-1,12001,12016,12013,-1,12016,12001,12321,-1,12321,12402,12016,-1,12402,12321,12007,-1,12007,12037,12402,-1,12038,12007,12006,-1,12006,12283,12038,-1,12284,11996,11995,-1,11995,12432,12284,-1,12312,12377,12376,-1,12376,12314,12312,-1,12314,12376,12395,-1,12395,12324,12314,-1,12011,12361,12517,-1,12517,12009,12011,-1,12009,12517,12518,-1,12518,12392,12009,-1,12392,12518,12409,-1,12409,12405,12392,-1,12437,12464,12519,-1,12519,12436,12437,-1,12436,12519,12302,-1,12302,556,12436,-1,12295,12302,12519,-1,12519,12510,12295,-1,12510,12519,12464,-1,12464,12509,12510,-1,12509,12464,12407,-1,12407,12508,12509,-1,12508,12407,12409,-1,12409,12507,12508,-1,12507,12409,12518,-1,12518,12506,12507,-1,12506,12518,12517,-1,12517,12025,12506,-1,12025,12517,12361,-1,12361,12023,12025,-1,12437,12411,12413,-1,12413,12408,12437,-1,12408,12413,12406,-1,12406,12405,12408,-1,11997,12171,12087,-1,12087,11995,11997,-1,11901,12176,12520,-1,12520,12521,11901,-1,12522,12202,12201,-1,12201,12042,12522,-1,12042,12201,12207,-1,12207,12043,12042,-1,12206,12202,12522,-1,12522,12523,12206,-1,12524,12043,12207,-1,12207,12223,12524,-1,11937,12206,12523,-1,12523,12525,11937,-1,12176,11937,12525,-1,12525,12520,12176,-1,12526,12527,12252,-1,12252,12251,12526,-1,12223,12252,12527,-1,12527,12524,12223,-1,12251,12254,12528,-1,12528,12526,12251,-1,12268,12529,12528,-1,12528,12254,12268,-1,11953,12323,12529,-1,12529,12268,11953,-1,11899,11901,12521,-1,12521,12039,11899,-1,12530,12043,12524,-1,12524,12531,12530,-1,12531,12524,12527,-1,12527,12532,12531,-1,12532,12527,12526,-1,12526,12533,12532,-1,12533,12526,12528,-1,12528,12534,12533,-1,12534,12528,12529,-1,12529,12535,12534,-1,12535,12529,12323,-1,12323,12324,12535,-1,12536,12525,12523,-1,12523,12537,12536,-1,12537,12523,12522,-1,12522,12538,12537,-1,12538,12522,12042,-1,12042,12041,12538,-1,12043,12530,12539,-1,12539,12041,12043,-1,12540,12049,12045,-1,12045,12044,12540,-1,400,504,12044,-1,12044,401,400,-1,12541,12542,12543,-1,12543,12544,12541,-1,12053,12545,12051,-1,12051,12050,12053,-1,12544,12543,12546,-1,12546,12547,12544,-1,12545,12057,12548,-1,12548,12549,12545,-1,12057,12550,12551,-1,12551,12548,12057,-1,12552,12553,12554,-1,12554,12555,12552,-1,12550,12556,12557,-1,12557,12551,12550,-1,12558,12550,12057,-1,12057,12056,12558,-1,402,401,12046,-1,12046,12559,402,-1,12559,12046,12066,-1,12066,12560,12559,-1,406,405,12561,-1,12561,413,406,-1,414,413,12562,-1,12562,420,414,-1,12562,12563,12564,-1,12564,12565,12562,-1,413,12561,12563,-1,12563,12562,413,-1,12566,12567,12568,-1,12568,12569,12566,-1,12560,12066,12567,-1,12567,12566,12560,-1,12570,420,12562,-1,12562,12565,12570,-1,12565,12564,12571,-1,12571,12572,12565,-1,12054,432,12069,-1,12069,12572,12054,-1,12571,12573,12574,-1,12574,12575,12571,-1,12575,12574,12336,-1,12336,12333,12575,-1,12576,12073,12577,-1,12577,12578,12576,-1,12574,12579,12337,-1,12337,12336,12574,-1,12071,12580,12581,-1,12581,12072,12071,-1,12072,12052,12051,-1,12051,12071,12072,-1,12546,12582,12077,-1,12077,12547,12546,-1,12583,12584,12585,-1,12585,12586,12583,-1,12581,12580,12484,-1,12484,12483,12581,-1,12076,12587,12340,-1,12340,12339,12076,-1,12081,12083,12372,-1,12372,12588,12081,-1,12582,12587,12076,-1,12076,12077,12582,-1,12045,12049,12048,-1,12048,12046,12045,-1,12056,12049,12540,-1,12540,12558,12056,-1,12589,12540,12044,-1,12044,524,12589,-1,12047,12049,12056,-1,12056,12055,12047,-1,12558,12540,12589,-1,12589,12590,12558,-1,12555,12554,12542,-1,12542,12541,12555,-1,12591,12592,12593,-1,12593,12594,12591,-1,12092,12595,12553,-1,12553,12552,12092,-1,12596,12585,12584,-1,12584,12597,12596,-1,12055,12057,12545,-1,12545,12053,12055,-1,12598,12599,12061,-1,12061,12060,12598,-1,12600,12593,12592,-1,12592,12601,12600,-1,12597,12591,12594,-1,12594,12596,12597,-1,12065,12064,12602,-1,12602,12603,12065,-1,12604,12395,12394,-1,12394,12605,12604,-1,12606,12081,12588,-1,12588,12607,12606,-1,12063,12608,12609,-1,12609,12064,12063,-1,12586,12606,12607,-1,12607,12583,12586,-1,12602,12599,12598,-1,12598,12603,12602,-1,12605,12610,12611,-1,12611,12604,12605,-1,12590,12556,12550,-1,12550,12558,12590,-1,12611,12610,12609,-1,12609,12608,12611,-1,12572,12069,12570,-1,12570,12565,12572,-1,12612,12613,12614,-1,12614,12615,12612,-1,12616,12617,12618,-1,12618,12619,12616,-1,12620,12621,12079,-1,12079,12622,12620,-1,12623,12624,12625,-1,12625,12626,12623,-1,12627,12628,12629,-1,12629,12630,12627,-1,12631,12062,12061,-1,12061,12632,12631,-1,12625,12624,12631,-1,12631,12632,12625,-1,12090,12092,12557,-1,12557,12633,12090,-1,12078,12634,12622,-1,12622,12079,12078,-1,12635,12636,12637,-1,12637,12638,12635,-1,12639,12640,12089,-1,12089,12088,12639,-1,12641,12298,12296,-1,12296,12430,12641,-1,508,12589,524,-1,524,509,508,-1,12059,90,89,-1,89,534,12059,-1,12556,516,12633,-1,12633,12557,12556,-1,516,111,90,-1,90,12633,516,-1,511,516,12556,-1,12556,12590,511,-1,12090,12633,90,-1,90,12058,12090,-1,12589,508,511,-1,511,12590,12589,-1,12620,12642,12643,-1,12643,12621,12620,-1,12300,12298,12641,-1,12641,12644,12300,-1,12645,12646,12647,-1,12647,12648,12645,-1,12649,12650,12084,-1,12084,12086,12649,-1,12651,12652,12621,-1,12621,12643,12651,-1,12653,12644,12641,-1,12641,12654,12653,-1,12654,12641,12430,-1,12430,12469,12654,-1,12559,405,404,-1,404,402,12559,-1,405,12559,12560,-1,12560,12561,405,-1,12561,12560,12566,-1,12566,12563,12561,-1,12563,12566,12569,-1,12569,12564,12563,-1,12564,12569,12573,-1,12573,12571,12564,-1,12333,433,12054,-1,12054,12575,12333,-1,12575,12054,12572,-1,12572,12571,12575,-1,12069,422,421,-1,421,12570,12069,-1,12570,421,418,-1,418,420,12570,-1,12578,12577,12495,-1,12495,12494,12578,-1,12494,12337,12579,-1,12579,12578,12494,-1,12579,12574,12573,-1,12573,12655,12579,-1,12655,12573,12569,-1,12569,12568,12655,-1,12578,12579,12655,-1,12655,12576,12578,-1,12576,12655,12568,-1,12568,12656,12576,-1,12656,12568,12567,-1,12567,12067,12656,-1,12067,12567,12066,-1,12066,12048,12067,-1,12073,12576,12656,-1,12656,12068,12073,-1,12068,12656,12067,-1,12067,12047,12068,-1,12483,12495,12577,-1,12577,12581,12483,-1,12581,12577,12073,-1,12073,12072,12581,-1,12071,12070,12657,-1,12657,12580,12071,-1,12580,12657,12505,-1,12505,12484,12580,-1,12052,12073,12068,-1,12068,12050,12052,-1,12339,12505,12657,-1,12657,12076,12339,-1,12076,12657,12070,-1,12070,12074,12076,-1,12075,12070,12051,-1,12051,12658,12075,-1,12658,12051,12545,-1,12545,12549,12658,-1,12308,12642,12620,-1,12620,12659,12308,-1,12659,12620,12622,-1,12622,12660,12659,-1,12077,12074,12075,-1,12075,12547,12077,-1,12547,12075,12658,-1,12658,12544,12547,-1,12544,12658,12549,-1,12549,12541,12544,-1,12541,12549,12548,-1,12548,12555,12541,-1,12555,12548,12551,-1,12551,12552,12555,-1,12552,12551,12557,-1,12557,12092,12552,-1,12595,12092,12093,-1,12093,12634,12595,-1,12634,12093,12660,-1,12660,12622,12634,-1,12080,12079,12621,-1,12621,12652,12080,-1,12372,12340,12587,-1,12587,12588,12372,-1,12588,12587,12582,-1,12582,12607,12588,-1,12607,12582,12546,-1,12546,12583,12607,-1,12583,12546,12543,-1,12543,12584,12583,-1,12584,12543,12542,-1,12542,12597,12584,-1,12597,12542,12554,-1,12554,12591,12597,-1,12591,12554,12553,-1,12553,12592,12591,-1,12592,12553,12595,-1,12595,12601,12592,-1,12601,12595,12634,-1,12634,12078,12601,-1,12600,12632,12061,-1,12061,12593,12600,-1,12593,12061,12599,-1,12599,12594,12593,-1,12594,12599,12602,-1,12602,12596,12594,-1,12596,12602,12064,-1,12064,12585,12596,-1,12585,12064,12609,-1,12609,12586,12585,-1,12586,12609,12610,-1,12610,12606,12586,-1,12606,12610,12605,-1,12605,12081,12606,-1,12600,12601,12078,-1,12078,12661,12600,-1,12661,12078,12080,-1,12080,12085,12661,-1,12085,12080,12652,-1,12652,12086,12085,-1,12086,12652,12651,-1,12651,12649,12086,-1,12647,12653,12654,-1,12654,12648,12647,-1,12648,12654,12469,-1,12469,12468,12648,-1,12630,12638,12637,-1,12637,12627,12630,-1,12613,12623,12626,-1,12626,12614,12613,-1,12632,12600,12661,-1,12661,12625,12632,-1,12625,12661,12085,-1,12085,12626,12625,-1,12626,12085,12084,-1,12084,12614,12626,-1,12614,12084,12650,-1,12650,12615,12614,-1,12619,12646,12645,-1,12645,12616,12619,-1,12640,12639,12618,-1,12618,12617,12640,-1,12628,12627,12613,-1,12613,12612,12628,-1,12613,12627,12637,-1,12637,12623,12613,-1,12623,12637,12636,-1,12636,12624,12623,-1,12081,12605,12394,-1,12394,12082,12081,-1,12624,12636,12662,-1,12662,12631,12624,-1,12631,12662,12663,-1,12663,12062,12631,-1,12062,12663,12664,-1,12664,12060,12062,-1,12060,12664,12539,-1,12539,12598,12060,-1,12598,12539,12530,-1,12530,12603,12598,-1,12040,12039,12630,-1,12630,12629,12040,-1,12630,12039,12521,-1,12521,12638,12630,-1,12638,12521,12520,-1,12520,12635,12638,-1,12635,12520,12525,-1,12525,12536,12635,-1,12041,12539,12664,-1,12664,12538,12041,-1,12538,12664,12663,-1,12663,12537,12538,-1,12537,12663,12662,-1,12662,12536,12537,-1,12536,12662,12636,-1,12636,12635,12536,-1,12324,12395,12604,-1,12604,12535,12324,-1,12535,12604,12611,-1,12611,12534,12535,-1,12534,12611,12608,-1,12608,12533,12534,-1,12533,12608,12063,-1,12063,12532,12533,-1,12532,12063,12065,-1,12065,12531,12532,-1,12531,12065,12603,-1,12603,12530,12531,-1,534,12307,12665,-1,12665,12059,534,-1,12059,12665,12666,-1,12666,12058,12059,-1,12058,12666,12091,-1,12091,12090,12058,-1,12093,12091,12666,-1,12666,12660,12093,-1,12660,12666,12665,-1,12665,12659,12660,-1,12659,12665,12307,-1,12307,12308,12659,-1,12648,12468,12467,-1,12467,12645,12648,-1,12645,12467,12428,-1,12428,12616,12645,-1,12616,12428,12427,-1,12427,12617,12616,-1,12617,12427,12433,-1,12433,12640,12617,-1,12640,12433,12432,-1,12432,12089,12640,-1,12089,12432,11995,-1,11995,12087,12089,-1,12308,12301,12300,-1,12300,12642,12308,-1,12642,12300,12644,-1,12644,12643,12642,-1,12643,12644,12653,-1,12653,12651,12643,-1,12651,12653,12647,-1,12647,12649,12651,-1,12649,12647,12646,-1,12646,12650,12649,-1,12650,12646,12619,-1,12619,12615,12650,-1,12615,12619,12618,-1,12618,12612,12615,-1,12612,12618,12639,-1,12639,12628,12612,-1,12628,12639,12088,-1,12088,12629,12628,-1,12629,12088,12087,-1,12087,12040,12629,-1,12040,12087,12171,-1,12171,11899,12040,-1,12667,12668,12669,-1,12670,12671,12672,-1,12673,12674,12675,-1,12676,12677,12678,-1,12679,12680,12681,-1,12682,12683,12684,-1,12685,12686,12687,-1,12688,12689,12690,-1,12689,12691,12690,-1,12692,12693,12694,-1,12695,12696,12697,-1,12695,12684,12698,-1,12682,12699,12683,-1,12700,12701,12702,-1,12703,12700,12704,-1,12703,12701,12700,-1,12705,12706,12707,-1,12708,12709,12710,-1,12698,12684,12683,-1,12711,12712,12713,-1,12714,12715,12716,-1,12716,12715,12717,-1,12718,12719,12720,-1,12124,12721,12722,-1,12723,12724,12725,-1,12726,12727,12728,-1,12729,12730,12731,-1,12732,12733,12734,-1,12735,12736,12737,-1,12735,12713,12712,-1,12095,11870,12738,-1,12739,12740,12741,-1,12736,12740,12742,-1,12743,12744,12745,-1,12746,12747,12748,-1,12749,12750,12751,-1,12752,12753,12754,-1,12753,12755,12756,-1,12757,12758,12759,-1,12760,12750,12749,-1,12761,12760,12749,-1,12106,12762,12763,-1,12764,12106,12110,-1,12762,12106,12764,-1,12728,12762,12726,-1,12726,12762,12764,-1,12111,12765,12766,-1,12767,12111,12112,-1,12765,12111,12767,-1,12765,12724,12723,-1,12768,12769,12770,-1,12771,12772,12773,-1,12774,12775,12772,-1,12776,12777,12719,-1,12778,12779,12780,-1,12781,12782,12783,-1,12784,12779,12785,-1,12786,12787,12788,-1,12112,11948,12767,-1,12126,12789,12135,-1,12790,12791,12792,-1,11952,12793,12741,-1,12794,12795,12231,-1,12681,12680,12796,-1,12797,12798,12799,-1,12799,12800,12797,-1,12675,12800,12799,-1,12799,12673,12675,-1,12798,12801,12802,-1,12802,12799,12798,-1,12797,12733,12732,-1,12732,12798,12797,-1,12803,12797,12800,-1,12800,12804,12803,-1,12805,12669,12668,-1,12668,12806,12805,-1,12668,12667,12759,-1,12759,12807,12668,-1,12808,12809,12667,-1,12667,12669,12808,-1,12806,12668,12807,-1,12807,12810,12806,-1,12811,12808,12669,-1,12669,12805,12811,-1,12801,12805,12806,-1,12806,12802,12801,-1,12802,12806,12810,-1,12810,12812,12802,-1,12813,12811,12805,-1,12805,12801,12813,-1,12799,12802,12812,-1,12812,12673,12799,-1,12732,12813,12801,-1,12801,12798,12732,-1,12814,12803,12804,-1,12804,12815,12814,-1,12672,12816,12815,-1,12815,12804,12672,-1,12803,12814,12817,-1,12817,12818,12803,-1,12819,12814,12815,-1,12815,12820,12819,-1,12816,12672,12671,-1,12671,12687,12816,-1,12821,12822,12687,-1,12687,12671,12821,-1,12816,12687,12686,-1,12686,12823,12816,-1,12672,12675,12674,-1,12674,12670,12672,-1,12673,12824,12825,-1,12825,12674,12673,-1,12674,12825,12826,-1,12826,12670,12674,-1,12672,12804,12800,-1,12800,12675,12672,-1,12803,12818,12733,-1,12733,12797,12803,-1,12821,12671,12670,-1,12670,12826,12821,-1,12827,12828,12825,-1,12825,12824,12827,-1,12825,12828,12829,-1,12829,12826,12825,-1,12830,12828,12827,-1,12827,12831,12830,-1,12677,12827,12824,-1,12824,12678,12677,-1,12832,12677,12676,-1,12676,12833,12832,-1,12812,12810,12676,-1,12676,12678,12812,-1,12673,12812,12678,-1,12678,12824,12673,-1,12831,12827,12677,-1,12677,12832,12831,-1,12834,12835,12836,-1,12836,12837,12834,-1,12838,12837,12836,-1,12836,12839,12838,-1,12835,12840,12841,-1,12841,12836,12835,-1,12731,12835,12834,-1,12834,12842,12731,-1,12837,12843,12844,-1,12844,12834,12837,-1,12679,12845,12846,-1,12846,12847,12679,-1,12848,12847,12846,-1,12846,12849,12848,-1,12845,12850,12775,-1,12775,12846,12845,-1,12851,12845,12679,-1,12679,12852,12851,-1,12680,12679,12847,-1,12847,12853,12680,-1,12854,12853,12847,-1,12847,12848,12854,-1,12796,12680,12853,-1,12853,12855,12796,-1,12840,12796,12855,-1,12855,12841,12840,-1,12856,12841,12855,-1,12855,12857,12856,-1,12858,12796,12840,-1,12840,12730,12858,-1,12839,12836,12841,-1,12841,12856,12839,-1,12730,12840,12835,-1,12835,12731,12730,-1,12859,12682,12684,-1,12684,12860,12859,-1,12697,12860,12684,-1,12684,12695,12697,-1,12859,12689,12699,-1,12699,12682,12859,-1,12861,12862,12859,-1,12859,12860,12861,-1,12863,12822,12864,-1,12864,12865,12863,-1,12706,12705,12865,-1,12865,12864,12706,-1,12822,12821,12866,-1,12866,12864,12822,-1,12822,12863,12685,-1,12685,12687,12822,-1,12816,12823,12820,-1,12820,12815,12816,-1,12867,12817,12814,-1,12814,12819,12867,-1,12689,12688,12868,-1,12868,12699,12689,-1,12700,12688,12690,-1,12690,12704,12700,-1,12689,12859,12862,-1,12862,12691,12689,-1,12860,12697,12869,-1,12869,12861,12860,-1,12870,12869,12697,-1,12697,12696,12870,-1,12696,12694,12871,-1,12871,12870,12696,-1,12871,12694,12693,-1,12693,12872,12871,-1,12694,12696,12695,-1,12695,12692,12694,-1,12873,12872,12693,-1,12693,12874,12873,-1,12874,12693,12692,-1,12692,12875,12874,-1,12876,12692,12695,-1,12695,12698,12876,-1,12683,12699,12868,-1,12868,12877,12683,-1,12688,12700,12878,-1,12878,12868,12688,-1,12879,12877,12868,-1,12868,12878,12879,-1,12880,12878,12700,-1,12700,12702,12880,-1,12881,12702,12701,-1,12701,12882,12881,-1,12880,12702,12881,-1,12881,12883,12880,-1,12883,12881,12707,-1,12707,12706,12883,-1,12884,12885,12880,-1,12880,12883,12884,-1,12881,12882,12886,-1,12886,12707,12881,-1,12883,12706,12887,-1,12887,12884,12883,-1,12887,12706,12864,-1,12864,12866,12887,-1,12888,12817,12867,-1,12867,12889,12888,-1,12890,12891,12708,-1,12708,12710,12890,-1,12892,12893,12708,-1,12708,12891,12892,-1,12891,12890,12894,-1,12894,12895,12891,-1,12893,12896,12709,-1,12709,12708,12893,-1,12744,12893,12892,-1,12892,12746,12744,-1,12895,12897,12892,-1,12892,12891,12895,-1,12896,12888,12889,-1,12889,12709,12896,-1,12893,12744,12743,-1,12743,12896,12893,-1,12898,12888,12896,-1,12896,12743,12898,-1,12888,12898,12818,-1,12818,12817,12888,-1,12899,12900,12901,-1,12901,12902,12899,-1,12901,12903,12904,-1,12904,12902,12901,-1,12905,12906,12902,-1,12902,12904,12905,-1,12904,12903,12843,-1,12843,12907,12904,-1,12901,12874,12875,-1,12875,12903,12901,-1,12908,12899,12902,-1,12902,12906,12908,-1,12908,12906,12909,-1,12909,12910,12908,-1,12909,12906,12905,-1,12905,12911,12909,-1,12912,12905,12904,-1,12904,12907,12912,-1,12900,12873,12874,-1,12874,12901,12900,-1,12910,12909,12895,-1,12895,12894,12910,-1,12895,12909,12911,-1,12911,12897,12895,-1,12911,12913,12747,-1,12747,12897,12911,-1,12913,12911,12905,-1,12905,12912,12913,-1,12746,12892,12897,-1,12897,12747,12746,-1,12843,12903,12875,-1,12875,12844,12843,-1,12876,12844,12875,-1,12875,12692,12876,-1,12913,12914,12748,-1,12748,12747,12913,-1,12907,12838,12915,-1,12915,12912,12907,-1,12913,12912,12915,-1,12915,12914,12913,-1,12683,12877,12916,-1,12916,12917,12683,-1,12878,12880,12885,-1,12885,12879,12878,-1,12879,12885,12918,-1,12918,12919,12879,-1,12917,12920,12698,-1,12698,12683,12917,-1,12842,12834,12844,-1,12844,12876,12842,-1,12907,12843,12837,-1,12837,12838,12907,-1,12746,12748,12745,-1,12745,12744,12746,-1,12898,12921,12733,-1,12733,12818,12898,-1,12712,12711,12922,-1,12922,12715,12712,-1,12923,12717,12715,-1,12715,12922,12923,-1,12924,12922,12711,-1,12711,12925,12924,-1,12712,12715,12714,-1,12714,12926,12712,-1,12927,12926,12714,-1,12714,12791,12927,-1,12792,12791,12714,-1,12714,12716,12792,-1,12926,12927,12740,-1,12740,12736,12926,-1,12794,12928,12927,-1,12927,12791,12794,-1,12712,12926,12736,-1,12736,12735,12712,-1,12925,12711,12809,-1,12809,12808,12925,-1,12929,12923,12922,-1,12922,12924,12929,-1,12930,12924,12925,-1,12925,12931,12930,-1,12923,12932,12933,-1,12933,12717,12923,-1,12720,12719,12777,-1,12777,12934,12720,-1,12935,12719,12718,-1,12718,12783,12935,-1,12936,12718,12720,-1,12720,12937,12936,-1,12721,12938,12939,-1,12939,12722,12721,-1,12940,12941,12722,-1,12722,12939,12940,-1,12938,12942,12943,-1,12943,12939,12938,-1,12938,12721,12944,-1,12944,12945,12938,-1,12937,12720,12934,-1,12934,12946,12937,-1,12783,12718,12936,-1,12936,12947,12783,-1,12948,12936,12937,-1,12937,12949,12948,-1,12950,12943,12942,-1,12942,12951,12950,-1,12778,12951,12942,-1,12942,12952,12778,-1,12953,12954,12943,-1,12943,12950,12953,-1,12951,12948,12949,-1,12949,12950,12951,-1,12950,12949,12955,-1,12955,12953,12950,-1,12780,12948,12951,-1,12951,12778,12780,-1,12946,12955,12949,-1,12949,12937,12946,-1,12947,12936,12948,-1,12948,12780,12947,-1,12727,12723,12725,-1,12725,12728,12727,-1,12725,12956,12957,-1,12957,12728,12725,-1,12766,12765,12723,-1,12723,12727,12766,-1,12958,12730,12729,-1,12729,12959,12958,-1,12731,12842,12920,-1,12920,12729,12731,-1,12838,12839,12960,-1,12960,12915,12838,-1,12914,12915,12960,-1,12960,12961,12914,-1,12962,12960,12839,-1,12839,12856,12962,-1,12959,12729,12920,-1,12920,12917,12959,-1,12842,12876,12698,-1,12698,12920,12842,-1,12826,12829,12866,-1,12866,12821,12826,-1,12963,12964,12965,-1,12965,12961,12963,-1,12961,12965,12748,-1,12748,12914,12961,-1,12965,12964,12966,-1,12966,12967,12965,-1,12963,12786,12788,-1,12788,12964,12963,-1,12961,12960,12962,-1,12962,12963,12961,-1,12750,12809,12711,-1,12711,12713,12750,-1,12750,12760,12667,-1,12667,12809,12750,-1,12750,12713,12968,-1,12968,12751,12750,-1,12733,12921,12969,-1,12969,12734,12733,-1,12734,12970,12813,-1,12813,12732,12734,-1,12970,12931,12811,-1,12811,12813,12970,-1,12969,12971,12970,-1,12970,12734,12969,-1,12931,12925,12808,-1,12808,12811,12931,-1,12971,12930,12931,-1,12931,12970,12971,-1,12945,12944,12972,-1,12972,12973,12945,-1,12974,12973,12972,-1,12972,12975,12974,-1,12121,12972,12944,-1,12944,12118,12121,-1,12945,12973,12785,-1,12785,12952,12945,-1,12976,12789,12977,-1,12977,12978,12976,-1,12941,12940,12978,-1,12978,12977,12941,-1,12129,12977,12789,-1,12789,12126,12129,-1,12979,12789,12976,-1,12976,12980,12979,-1,12981,12976,12978,-1,12978,12982,12981,-1,12713,12735,12737,-1,12737,12968,12713,-1,12737,12983,12984,-1,12984,12968,12737,-1,12738,12985,12986,-1,12986,12984,12738,-1,12986,12751,12968,-1,12968,12984,12986,-1,12985,12987,12988,-1,12988,12986,12985,-1,12738,11870,12097,-1,12097,12985,12738,-1,12989,12738,12984,-1,12984,12983,12989,-1,12099,12094,12095,-1,12095,12990,12099,-1,12933,12792,12716,-1,12716,12717,12933,-1,12983,12737,12736,-1,12736,12742,12983,-1,12983,12742,12991,-1,12991,12989,12983,-1,12990,12989,12991,-1,12991,12992,12990,-1,12991,12742,12740,-1,12740,12739,12991,-1,12990,12992,12100,-1,12100,12099,12990,-1,12993,12102,12100,-1,12100,12992,12993,-1,12933,12932,12994,-1,12994,12995,12933,-1,12996,12932,12923,-1,12923,12929,12996,-1,12991,12739,12993,-1,12993,12992,12991,-1,12793,12262,12102,-1,12102,12993,12793,-1,12745,12748,12965,-1,12965,12967,12745,-1,12921,12745,12967,-1,12967,12969,12921,-1,12743,12745,12921,-1,12921,12898,12743,-1,12967,12966,12971,-1,12971,12969,12967,-1,12107,12987,12985,-1,12985,12097,12107,-1,12988,12749,12751,-1,12751,12986,12988,-1,12997,12988,12987,-1,12987,12763,12997,-1,12758,12956,12754,-1,12754,12753,12758,-1,12724,12754,12956,-1,12956,12725,12724,-1,12956,12758,12757,-1,12757,12957,12956,-1,12758,12753,12756,-1,12756,12759,12758,-1,12807,12759,12756,-1,12756,12998,12807,-1,12759,12667,12760,-1,12760,12757,12759,-1,12760,12761,12957,-1,12957,12757,12760,-1,12111,12766,12764,-1,12764,12110,12111,-1,12763,12762,12728,-1,12728,12997,12763,-1,12728,12957,12761,-1,12761,12997,12728,-1,12216,12999,13000,-1,13000,12217,12216,-1,13000,12999,12773,-1,12773,13001,13000,-1,12773,12772,13002,-1,13002,13001,12773,-1,12999,13003,13004,-1,13004,12773,12999,-1,13005,13000,13001,-1,13001,13006,13005,-1,12850,13007,13008,-1,13008,13002,12850,-1,13008,13006,13001,-1,13001,13002,13008,-1,12769,13008,13007,-1,13007,12770,12769,-1,13007,12850,12845,-1,12845,12851,13007,-1,12772,12775,12850,-1,12850,13002,12772,-1,12770,13007,12851,-1,12851,13009,12770,-1,12852,12679,12681,-1,12681,13010,12852,-1,13009,12851,12852,-1,12852,13011,13009,-1,12858,13010,12681,-1,12681,12796,12858,-1,13011,12852,13010,-1,13010,12781,13011,-1,12782,12858,12730,-1,12730,12958,12782,-1,13012,12228,12221,-1,12221,13005,13012,-1,13012,13005,13006,-1,13006,13013,13012,-1,12769,13013,13006,-1,13006,13008,12769,-1,13014,13012,13013,-1,13013,13015,13014,-1,13009,12780,12779,-1,12779,12770,13009,-1,13011,12947,12780,-1,12780,13009,13011,-1,12782,12781,13010,-1,13010,12858,12782,-1,12781,12783,12947,-1,12947,13011,12781,-1,12958,12935,12783,-1,12783,12782,12958,-1,12959,13016,12935,-1,12935,12958,12959,-1,12917,12916,13016,-1,13016,12959,12917,-1,12962,12856,12857,-1,12857,13017,12962,-1,13018,13017,12857,-1,12857,12854,13018,-1,12786,12963,12962,-1,12962,13017,12786,-1,13018,12854,12848,-1,12848,13019,13018,-1,13019,12848,12849,-1,12849,13020,13019,-1,12787,13018,13019,-1,13019,13021,12787,-1,13020,12849,12774,-1,12774,13022,13020,-1,13021,13019,13020,-1,13020,12994,13021,-1,13022,12774,12772,-1,12772,12771,13022,-1,12849,12846,12775,-1,12775,12774,12849,-1,12994,13020,13022,-1,13022,12995,12994,-1,12995,13022,12771,-1,12771,13023,12995,-1,12773,13004,13023,-1,13023,12771,12773,-1,12790,13004,13003,-1,13003,12795,12790,-1,12216,12219,13003,-1,13003,12999,12216,-1,13017,13018,12787,-1,12787,12786,13017,-1,13021,12996,12788,-1,12788,12787,13021,-1,13021,12994,12932,-1,12932,12996,13021,-1,12995,13023,12792,-1,12792,12933,12995,-1,12740,12927,12928,-1,12928,12741,12740,-1,12261,12928,12794,-1,12794,12231,12261,-1,12795,12794,12791,-1,12791,12790,12795,-1,12919,12918,13024,-1,13024,13025,12919,-1,12885,12884,13026,-1,13026,12918,12885,-1,12919,12916,12877,-1,12877,12879,12919,-1,13025,13024,12776,-1,12776,12719,13025,-1,12918,13026,13027,-1,13027,13024,12918,-1,13025,13016,12916,-1,12916,12919,13025,-1,13024,13027,13028,-1,13028,12776,13024,-1,12719,12935,13016,-1,13016,13025,12719,-1,12945,12952,12942,-1,12942,12938,12945,-1,12952,12785,12779,-1,12779,12778,12952,-1,12944,12721,12124,-1,12124,12118,12944,-1,12770,12779,12784,-1,12784,12768,12770,-1,13015,12768,12784,-1,12784,12974,13015,-1,13015,12974,12975,-1,12975,13014,13015,-1,12229,13014,12975,-1,12975,12122,12229,-1,12866,12829,13029,-1,13029,12887,12866,-1,13029,12829,12828,-1,12828,12830,13029,-1,13026,13029,12830,-1,12830,13027,13026,-1,13027,12830,12831,-1,12831,13028,13027,-1,13028,12831,12832,-1,12832,13030,13028,-1,12833,12676,12998,-1,12998,13031,12833,-1,13030,12832,12833,-1,12833,13032,13030,-1,13031,12998,12756,-1,12756,13033,13031,-1,12810,12807,12998,-1,12998,12676,12810,-1,13032,12833,13031,-1,13031,13034,13032,-1,12756,12755,13035,-1,13035,13033,12756,-1,13034,13031,13033,-1,13033,13036,13034,-1,12884,12887,13029,-1,13029,13026,12884,-1,12776,13028,13030,-1,13030,12777,12776,-1,12777,13030,13032,-1,13032,12934,12777,-1,12934,13032,13034,-1,13034,12946,12934,-1,12946,13034,13036,-1,13036,12955,12946,-1,12955,13036,13037,-1,13037,12953,12955,-1,12954,12953,13037,-1,13037,12982,12954,-1,13036,13033,13035,-1,13035,13037,13036,-1,12954,12982,12978,-1,12978,12940,12954,-1,12129,12131,12941,-1,12941,12977,12129,-1,12788,12996,12929,-1,12929,13038,12788,-1,13038,12929,12924,-1,12924,12930,13038,-1,12964,12788,13038,-1,13038,12966,12964,-1,12966,13038,12930,-1,12930,12971,12966,-1,12981,13039,12980,-1,12980,12976,12981,-1,12274,12135,12789,-1,12789,12979,12274,-1,12767,12979,12980,-1,12980,13040,12767,-1,12131,12124,12722,-1,12722,12941,12131,-1,12954,12940,12939,-1,12939,12943,12954,-1,12755,13039,12981,-1,12981,13035,12755,-1,13037,13035,12981,-1,12981,12982,13037,-1,13039,12755,12753,-1,12753,12752,13039,-1,12793,11952,11951,-1,11951,12262,12793,-1,12739,12741,12793,-1,12793,12993,12739,-1,13004,12790,12792,-1,12792,13023,13004,-1,13003,12219,12231,-1,12231,12795,13003,-1,12752,13040,12980,-1,12980,13039,12752,-1,12767,11948,12274,-1,12274,12979,12767,-1,12765,12767,13040,-1,13040,12724,12765,-1,12726,12764,12766,-1,12766,12727,12726,-1,12997,12761,12749,-1,12749,12988,12997,-1,13040,12752,12754,-1,12754,12724,13040,-1,12768,13015,13013,-1,13013,12769,12768,-1,12974,12784,12785,-1,12785,12973,12974,-1,12121,12122,12975,-1,12975,12972,12121,-1,12989,12990,12095,-1,12095,12738,12989,-1,12106,12763,12987,-1,12987,12107,12106,-1,13005,12221,12217,-1,12217,13000,13005,-1,13014,12229,12228,-1,12228,13012,13014,-1,12261,11952,12741,-1,12741,12928,12261,-1,12857,12855,12853,-1,12853,12854,12857,-1,13041,13042,13043,-1,13044,13041,13043,-1,13045,13046,12819,-1,13047,13041,12886,-1,13048,13044,13049,-1,13050,13051,13052,-1,12890,13053,12894,-1,12889,13051,12709,-1,12894,13053,12910,-1,12690,12691,13054,-1,13055,13056,13057,-1,13058,13059,13060,-1,13061,13055,13057,-1,13062,13063,13064,-1,13062,13064,13065,-1,13066,13067,13068,-1,13069,13070,13071,-1,13072,13073,13074,-1,13075,13072,13076,-1,13077,13078,13079,-1,13080,13079,13078,-1,13081,13082,13083,-1,13084,13083,13085,-1,13086,13087,13088,-1,13089,13077,13090,-1,13091,13092,13071,-1,13093,13094,13095,-1,13096,13097,13098,-1,13099,13100,13101,-1,13102,13103,13104,-1,13105,13106,13107,-1,13108,13086,13109,-1,13105,13107,13103,-1,13097,13110,13098,-1,13088,13087,13111,-1,13112,13071,13076,-1,13113,13095,13114,-1,13115,13116,13117,-1,13118,13119,13120,-1,13121,13122,13123,-1,13124,13122,13125,-1,13126,13127,13128,-1,13129,13130,13131,-1,13118,13132,13133,-1,13134,13135,13136,-1,13137,13091,13138,-1,13138,13139,13140,-1,13141,13142,13143,-1,13144,13143,13145,-1,13146,13147,13148,-1,13149,13150,13151,-1,13152,13153,13154,-1,13155,13156,13157,-1,13158,13159,13160,-1,13161,13162,13163,-1,13164,13165,13166,-1,13041,13167,13168,-1,13168,13042,13041,-1,13169,12867,12819,-1,12819,13046,13169,-1,13170,13046,13045,-1,13045,13171,13170,-1,13045,12819,12820,-1,12820,13172,13045,-1,13173,13171,13045,-1,13045,13172,13173,-1,13046,13170,13174,-1,13174,13169,13046,-1,13175,12863,12865,-1,12865,13049,13175,-1,13049,12865,12705,-1,12705,13048,13049,-1,13176,12685,12863,-1,12863,13175,13176,-1,13177,13175,13049,-1,13049,13178,13177,-1,13178,13049,13044,-1,13044,13043,13178,-1,13175,13177,13179,-1,13179,13176,13175,-1,13180,12686,12685,-1,12685,13176,13180,-1,12823,13181,13172,-1,13172,12820,12823,-1,13181,12823,12686,-1,12686,13180,13181,-1,13182,13180,13176,-1,13176,13179,13182,-1,12862,12861,13183,-1,13183,13184,12862,-1,13183,13167,13185,-1,13185,13184,13183,-1,13183,12861,12869,-1,12869,13186,13183,-1,12691,12862,13184,-1,13184,13054,12691,-1,12871,13187,13188,-1,13188,12870,12871,-1,12871,12872,13189,-1,13189,13187,12871,-1,13190,12704,12690,-1,12690,13054,13190,-1,13054,13184,13185,-1,13185,13190,13054,-1,13041,13047,13185,-1,13185,13167,13041,-1,13167,13183,13186,-1,13186,13168,13167,-1,12886,13041,13044,-1,13044,13048,12886,-1,13191,13047,12886,-1,12886,12882,13191,-1,12703,13191,12882,-1,12882,12701,12703,-1,12704,13190,13191,-1,13191,12703,12704,-1,12707,12886,13048,-1,13048,12705,12707,-1,13181,13180,13182,-1,13182,13140,13181,-1,13140,13173,13172,-1,13172,13181,13140,-1,13192,13189,12872,-1,12872,12873,13192,-1,12869,12870,13188,-1,13188,13186,12869,-1,13169,13193,12889,-1,12889,12867,13169,-1,13133,13194,13052,-1,13052,13193,13133,-1,13174,13133,13193,-1,13193,13169,13174,-1,13052,13051,12889,-1,12889,13193,13052,-1,13050,13052,13194,-1,13194,13195,13050,-1,13196,13053,13050,-1,13050,13195,13196,-1,13053,12890,12710,-1,12710,13050,13053,-1,13197,12910,13053,-1,13053,13196,13197,-1,12710,12709,13051,-1,13051,13050,12710,-1,13198,12900,12899,-1,12899,13199,13198,-1,13199,12899,12908,-1,12908,13200,13199,-1,13198,13192,12873,-1,12873,12900,13198,-1,13200,12908,12910,-1,12910,13197,13200,-1,13190,13185,13047,-1,13047,13191,13190,-1,13042,13201,13202,-1,13202,13043,13042,-1,13059,13058,13056,-1,13056,13055,13059,-1,13055,13203,13090,-1,13090,13059,13055,-1,13055,13061,13063,-1,13063,13062,13055,-1,13067,13066,13062,-1,13062,13065,13067,-1,13066,13068,13204,-1,13204,13069,13066,-1,13092,13205,13062,-1,13062,13066,13092,-1,13069,13204,13206,-1,13206,13070,13069,-1,13070,13206,13207,-1,13207,13075,13070,-1,13075,13076,13071,-1,13071,13070,13075,-1,13069,13071,13092,-1,13092,13066,13069,-1,13072,13074,13208,-1,13208,13076,13072,-1,13209,13112,13076,-1,13076,13208,13209,-1,13082,13081,13208,-1,13208,13074,13082,-1,13073,13072,13075,-1,13075,13207,13073,-1,13210,13211,13078,-1,13078,13077,13210,-1,13077,13079,13059,-1,13059,13090,13077,-1,13212,13085,13083,-1,13083,13082,13212,-1,13213,13214,13081,-1,13081,13083,13213,-1,13215,13216,13217,-1,13217,13218,13215,-1,13219,13218,13217,-1,13217,13094,13219,-1,13220,13221,13217,-1,13217,13216,13220,-1,13215,13222,13223,-1,13223,13216,13215,-1,13224,13085,13212,-1,13212,13225,13224,-1,13226,13111,13224,-1,13224,13225,13226,-1,13111,13087,13227,-1,13227,13224,13111,-1,13228,13111,13226,-1,13226,13229,13228,-1,13228,13230,13088,-1,13088,13111,13228,-1,13102,13086,13088,-1,13088,13230,13102,-1,13109,13086,13102,-1,13102,13104,13109,-1,13105,13103,13102,-1,13102,13230,13105,-1,13223,13231,13220,-1,13220,13216,13223,-1,13080,13223,13222,-1,13222,13232,13080,-1,13231,13223,13080,-1,13080,13233,13231,-1,13234,13079,13080,-1,13080,13232,13234,-1,13080,13078,13211,-1,13211,13233,13080,-1,13060,13059,13079,-1,13079,13234,13060,-1,13090,13203,13235,-1,13235,13089,13090,-1,13062,13205,13203,-1,13203,13055,13062,-1,13203,13205,13137,-1,13137,13235,13203,-1,13137,13205,13092,-1,13092,13091,13137,-1,13094,13217,13221,-1,13221,13095,13094,-1,13094,13093,13236,-1,13236,13219,13094,-1,13237,13238,13239,-1,13239,13240,13237,-1,13098,13240,13239,-1,13239,13096,13098,-1,13096,13239,13238,-1,13238,13236,13096,-1,13240,13099,13241,-1,13241,13237,13240,-1,13096,13236,13093,-1,13093,13097,13096,-1,13098,13242,13099,-1,13099,13240,13098,-1,13099,13101,13243,-1,13243,13241,13099,-1,13244,13100,13099,-1,13099,13242,13244,-1,13245,13242,13098,-1,13098,13110,13245,-1,13243,13101,13246,-1,13246,13247,13243,-1,13101,13100,13248,-1,13248,13246,13101,-1,13109,13104,13248,-1,13248,13249,13109,-1,13249,13248,13100,-1,13100,13244,13249,-1,13248,13104,13103,-1,13103,13246,13248,-1,13250,13130,13109,-1,13109,13249,13250,-1,13247,13246,13103,-1,13103,13107,13247,-1,13106,13105,13230,-1,13230,13228,13106,-1,13251,13250,13249,-1,13249,13244,13251,-1,13251,13244,13242,-1,13242,13245,13251,-1,13108,13252,13087,-1,13087,13086,13108,-1,13227,13084,13085,-1,13085,13224,13227,-1,13252,13253,13227,-1,13227,13087,13252,-1,13084,13254,13213,-1,13213,13083,13084,-1,13227,13253,13254,-1,13254,13084,13227,-1,13208,13081,13214,-1,13214,13209,13208,-1,13093,13095,13113,-1,13113,13097,13093,-1,13097,13113,13255,-1,13255,13110,13097,-1,13113,13114,13148,-1,13148,13255,13113,-1,13256,13255,13148,-1,13148,13147,13256,-1,13148,13114,13257,-1,13257,13146,13148,-1,13256,13245,13110,-1,13110,13255,13256,-1,13121,13123,13170,-1,13170,13171,13121,-1,13258,13120,13117,-1,13117,13116,13258,-1,13259,13116,13115,-1,13115,13260,13259,-1,13261,13115,13117,-1,13117,13262,13261,-1,13115,13261,13263,-1,13263,13260,13115,-1,13258,13116,13259,-1,13259,13264,13258,-1,13259,13260,13265,-1,13265,13266,13259,-1,13120,13119,13124,-1,13124,13117,13120,-1,13262,13117,13124,-1,13124,13125,13262,-1,13124,13119,13123,-1,13123,13122,13124,-1,13119,13174,13170,-1,13170,13123,13119,-1,13119,13118,13133,-1,13133,13174,13119,-1,13127,13267,13268,-1,13268,13269,13127,-1,13268,13131,13270,-1,13270,13269,13268,-1,13268,13267,13271,-1,13271,13272,13268,-1,13127,13126,13273,-1,13273,13267,13127,-1,13128,13127,13269,-1,13269,13274,13128,-1,13274,13269,13270,-1,13270,13275,13274,-1,13128,13274,13147,-1,13147,13146,13128,-1,13131,13130,13250,-1,13250,13270,13131,-1,13250,13251,13275,-1,13275,13270,13250,-1,13272,13129,13131,-1,13131,13268,13272,-1,13276,13277,13278,-1,13278,13279,13276,-1,13279,13278,13273,-1,13273,13280,13279,-1,13271,13278,13277,-1,13277,13281,13271,-1,13282,13277,13276,-1,13276,13283,13282,-1,13284,13285,13276,-1,13276,13279,13284,-1,13266,13265,13129,-1,13129,13272,13266,-1,13286,13130,13129,-1,13129,13265,13286,-1,13272,13271,13281,-1,13281,13266,13272,-1,13281,13277,13282,-1,13282,13264,13281,-1,13271,13267,13273,-1,13273,13278,13271,-1,13264,13259,13266,-1,13266,13281,13264,-1,13254,13262,13125,-1,13125,13213,13254,-1,13214,13213,13125,-1,13125,13287,13214,-1,13262,13254,13253,-1,13253,13261,13262,-1,13125,13122,13121,-1,13121,13287,13125,-1,13287,13121,13288,-1,13288,13289,13287,-1,13135,13258,13264,-1,13264,13282,13135,-1,13118,13120,13258,-1,13258,13132,13118,-1,13258,13135,13134,-1,13134,13132,13258,-1,13136,13135,13282,-1,13282,13283,13136,-1,13134,13136,13195,-1,13195,13194,13134,-1,13134,13194,13133,-1,13133,13132,13134,-1,13252,13263,13261,-1,13261,13253,13252,-1,13263,13252,13108,-1,13108,13286,13263,-1,13108,13109,13130,-1,13130,13286,13108,-1,13260,13263,13286,-1,13286,13265,13260,-1,13290,13177,13178,-1,13178,13291,13290,-1,13290,13292,13179,-1,13179,13177,13290,-1,13292,13293,13182,-1,13182,13179,13292,-1,13292,13290,13294,-1,13294,13089,13292,-1,13139,13138,13091,-1,13091,13295,13139,-1,13138,13293,13235,-1,13235,13137,13138,-1,13112,13295,13091,-1,13091,13071,13112,-1,13289,13295,13112,-1,13112,13209,13289,-1,13139,13288,13173,-1,13173,13140,13139,-1,13293,13138,13140,-1,13140,13182,13293,-1,13296,13142,13141,-1,13141,13297,13296,-1,13141,13298,13299,-1,13299,13297,13141,-1,13300,13301,13142,-1,13142,13296,13300,-1,13297,13302,13149,-1,13149,13296,13297,-1,13275,13251,13245,-1,13245,13256,13275,-1,13274,13275,13256,-1,13256,13147,13274,-1,13126,13303,13280,-1,13280,13273,13126,-1,13304,13303,13126,-1,13126,13128,13304,-1,13304,13298,13305,-1,13305,13303,13304,-1,13304,13128,13146,-1,13146,13306,13304,-1,13305,13307,13280,-1,13280,13303,13305,-1,13298,13141,13308,-1,13308,13305,13298,-1,13298,13304,13306,-1,13306,13299,13298,-1,13307,13305,13308,-1,13308,13309,13307,-1,13308,13141,13143,-1,13143,13144,13308,-1,13301,13145,13143,-1,13143,13142,13301,-1,13310,13144,13145,-1,13145,13311,13310,-1,13309,13308,13144,-1,13144,13310,13309,-1,13312,13302,13297,-1,13297,13299,13312,-1,13299,13306,13313,-1,13313,13312,13299,-1,13257,13313,13306,-1,13306,13146,13257,-1,13314,13114,13095,-1,13095,13221,13314,-1,13114,13314,13315,-1,13315,13257,13114,-1,13316,13314,13221,-1,13221,13220,13316,-1,13317,13313,13257,-1,13257,13315,13317,-1,13318,13315,13314,-1,13314,13316,13318,-1,13317,13319,13312,-1,13312,13313,13317,-1,13320,13317,13315,-1,13315,13318,13320,-1,13319,13321,13302,-1,13302,13312,13319,-1,13322,13319,13317,-1,13317,13320,13322,-1,13302,13321,13150,-1,13150,13149,13302,-1,13323,13321,13319,-1,13319,13322,13323,-1,13296,13149,13151,-1,13151,13300,13296,-1,13324,13150,13321,-1,13321,13323,13324,-1,13325,13300,13151,-1,13151,13326,13325,-1,13043,13202,13291,-1,13291,13178,13043,-1,13201,13327,13164,-1,13164,13202,13201,-1,13328,13201,13042,-1,13042,13168,13328,-1,13202,13164,13166,-1,13166,13291,13202,-1,13291,13166,13294,-1,13294,13290,13291,-1,13293,13292,13089,-1,13089,13235,13293,-1,13121,13171,13173,-1,13173,13288,13121,-1,13139,13295,13289,-1,13289,13288,13139,-1,13189,13329,13330,-1,13330,13187,13189,-1,13153,13152,13331,-1,13331,13157,13153,-1,13157,13331,13332,-1,13332,13155,13157,-1,13331,13152,13325,-1,13325,13326,13331,-1,13329,13153,13157,-1,13157,13330,13329,-1,13155,13332,13333,-1,13333,13334,13155,-1,13332,13331,13326,-1,13326,13324,13332,-1,13335,13188,13187,-1,13187,13330,13335,-1,13335,13336,13186,-1,13186,13188,13335,-1,13330,13157,13156,-1,13156,13335,13330,-1,13337,13329,13189,-1,13189,13192,13337,-1,13154,13153,13329,-1,13329,13337,13154,-1,13156,13155,13334,-1,13334,13338,13156,-1,13334,13339,13340,-1,13340,13338,13334,-1,13335,13156,13338,-1,13338,13336,13335,-1,13341,13339,13334,-1,13334,13333,13341,-1,13333,13332,13324,-1,13324,13323,13333,-1,13339,13341,13342,-1,13342,13343,13339,-1,13341,13333,13323,-1,13323,13322,13341,-1,13336,13338,13340,-1,13340,13328,13336,-1,13340,13339,13343,-1,13343,13327,13340,-1,13160,13164,13327,-1,13327,13343,13160,-1,13328,13340,13327,-1,13327,13201,13328,-1,13342,13344,13160,-1,13160,13343,13342,-1,13342,13341,13322,-1,13322,13320,13342,-1,13318,13344,13342,-1,13342,13320,13318,-1,13326,13151,13150,-1,13150,13324,13326,-1,13152,13345,13346,-1,13346,13325,13152,-1,13325,13346,13301,-1,13301,13300,13325,-1,13345,13347,13311,-1,13311,13346,13345,-1,13345,13152,13154,-1,13154,13348,13345,-1,13348,13154,13337,-1,13337,13349,13348,-1,13349,13337,13192,-1,13192,13198,13349,-1,13336,13328,13168,-1,13168,13186,13336,-1,13214,13287,13289,-1,13289,13209,13214,-1,13233,13211,13159,-1,13159,13158,13233,-1,13233,13158,13350,-1,13350,13231,13233,-1,13231,13350,13316,-1,13316,13220,13231,-1,13344,13350,13158,-1,13158,13160,13344,-1,13350,13344,13318,-1,13318,13316,13350,-1,13164,13160,13159,-1,13159,13165,13164,-1,13165,13159,13211,-1,13211,13210,13165,-1,13210,13294,13166,-1,13166,13165,13210,-1,13210,13077,13089,-1,13089,13294,13210,-1,13162,13196,13195,-1,13195,13136,13162,-1,13161,13197,13196,-1,13196,13162,13161,-1,13136,13283,13163,-1,13163,13162,13136,-1,13311,13145,13301,-1,13301,13346,13311,-1,13347,13351,13310,-1,13310,13311,13347,-1,13345,13348,13352,-1,13352,13347,13345,-1,13310,13351,13353,-1,13353,13309,13310,-1,13347,13352,13354,-1,13354,13351,13347,-1,13309,13353,13284,-1,13284,13307,13309,-1,13351,13354,13355,-1,13355,13353,13351,-1,13355,13285,13284,-1,13284,13353,13355,-1,13354,13356,13161,-1,13161,13355,13354,-1,13163,13285,13355,-1,13355,13161,13163,-1,13307,13284,13279,-1,13279,13280,13307,-1,13276,13285,13163,-1,13163,13283,13276,-1,13348,13349,13357,-1,13357,13352,13348,-1,13352,13357,13356,-1,13356,13354,13352,-1,13349,13198,13199,-1,13199,13357,13349,-1,13357,13199,13200,-1,13200,13356,13357,-1,13356,13200,13197,-1,13197,13161,13356,-1,13358,13359,13360,-1,13361,13362,13363,-1,13362,13361,13364,-1,13359,13358,13365,-1,13366,13367,13368,-1,13367,13369,13370,-1,13371,13372,13373,-1,13374,13375,13376,-1,13376,13375,13377,-1,13378,13379,13380,-1,13381,13382,13383,-1,13384,13385,13386,-1,13387,13388,13389,-1,13390,13391,13392,-1,13393,13390,13392,-1,13394,13389,13395,-1,13396,13397,13398,-1,13399,13400,13401,-1,13400,13399,13402,-1,13397,13396,13403,-1,13404,13405,13406,-1,13406,13405,13407,-1,13408,13409,13410,-1,13411,13409,13408,-1,13412,13409,13413,-1,13411,13413,13409,-1,13414,13415,13416,-1,13417,13415,13418,-1,13419,13420,13421,-1,13420,13422,13218,-1,13423,13424,13425,-1,13424,13426,13427,-1,13428,13429,13430,-1,13431,13432,13215,-1,13433,13434,13435,-1,13436,13437,13438,-1,13439,13440,13441,-1,13442,13443,13444,-1,13445,13446,13447,-1,13222,13215,13448,-1,13222,13448,13449,-1,13450,13451,13452,-1,13453,13450,13454,-1,13455,13450,13453,-1,13451,13450,13455,-1,13234,13456,13457,-1,13458,13459,13457,-1,13457,13460,13060,-1,13234,13457,13060,-1,13461,13460,13452,-1,13462,13463,13464,-1,13465,13461,13452,-1,13413,13466,13425,-1,13467,13468,13469,-1,13470,13471,13472,-1,13473,13474,13475,-1,13476,13477,13478,-1,13479,13407,13476,-1,13480,13359,13365,-1,13481,13358,13482,-1,13483,13484,13485,-1,13483,13482,13484,-1,13482,13483,13481,-1,13364,13361,13486,-1,13487,13486,13488,-1,13489,13490,13491,-1,13492,13493,13494,-1,13495,13411,13408,-1,13496,13495,13497,-1,13498,13499,13500,-1,13468,13463,13501,-1,13502,13499,13503,-1,13504,13505,13506,-1,13485,13507,13483,-1,13508,13406,13509,-1,13510,13511,13512,-1,13510,13513,13514,-1,13515,13064,13513,-1,13513,13516,13514,-1,13517,13514,13518,-1,13517,13519,13511,-1,13520,13521,13522,-1,13523,13524,13518,-1,13525,13526,13527,-1,13528,13529,13479,-1,13530,13531,13532,-1,13533,13525,13534,-1,13535,13536,13537,-1,13535,13538,13539,-1,13540,13541,13542,-1,13543,13544,13545,-1,13546,13547,13548,-1,13549,13550,13551,-1,13552,13553,13554,-1,13555,13551,13550,-1,13556,13557,13558,-1,13559,13560,13558,-1,13561,13562,13563,-1,13564,13388,13565,-1,13566,13567,13568,-1,13512,13568,13569,-1,13570,13571,13068,-1,13572,13573,13574,-1,13571,13575,13068,-1,13574,13576,13577,-1,13578,13579,13577,-1,13580,13581,13204,-1,13582,13579,13578,-1,13583,13370,13369,-1,13583,13369,13584,-1,13585,13377,13586,-1,13587,13588,13589,-1,13587,13590,13588,-1,13590,13587,13591,-1,13371,13590,13591,-1,13366,13592,13593,-1,13594,13595,13596,-1,13592,13594,13593,-1,13592,13595,13594,-1,13597,13598,13599,-1,13581,13206,13204,-1,13600,13601,13602,-1,13603,13604,13605,-1,13606,13607,13608,-1,13609,13610,13611,-1,13612,13613,13614,-1,13612,13614,13615,-1,13616,13617,13618,-1,13619,13620,13621,-1,13622,13623,13557,-1,13624,13625,13626,-1,13627,13628,13629,-1,13630,13631,13632,-1,13633,13634,13635,-1,13636,13637,13638,-1,13638,13639,13636,-1,13640,13641,13642,-1,13642,13643,13644,-1,13645,13643,13646,-1,13647,13648,13649,-1,13647,13650,13651,-1,13646,13379,13652,-1,13653,13382,13649,-1,13651,13654,13655,-1,13656,13657,13658,-1,13659,13660,13661,-1,13662,13663,13664,-1,13665,13666,13667,-1,13668,13669,13654,-1,13658,13670,13671,-1,13672,13673,13674,-1,13576,13574,13675,-1,13676,13677,13678,-1,13679,13676,13247,-1,13680,13559,13558,-1,13673,13681,13682,-1,13219,13236,13421,-1,13683,13247,13676,-1,13684,13685,13686,-1,13538,13687,13688,-1,13689,13690,13691,-1,13692,13693,13694,-1,13695,13692,13696,-1,13695,13693,13692,-1,13696,13385,13695,-1,13697,13698,13699,-1,13700,13701,13702,-1,13703,13704,13705,-1,13706,13707,13393,-1,13708,13397,13403,-1,13709,13396,13710,-1,13711,13712,13713,-1,13711,13710,13712,-1,13710,13711,13709,-1,13402,13399,13714,-1,13715,13714,13716,-1,13717,13718,13719,-1,13720,13721,13722,-1,13723,13721,13724,-1,13725,13726,13727,-1,13713,13728,13711,-1,13360,13729,13730,-1,13730,13358,13360,-1,13358,13730,13731,-1,13731,13482,13358,-1,13729,13732,13733,-1,13733,13730,13729,-1,13729,13360,13359,-1,13359,13734,13729,-1,13730,13733,13735,-1,13735,13731,13730,-1,13732,13363,13362,-1,13362,13733,13732,-1,13729,13734,13736,-1,13736,13732,13729,-1,13733,13362,13737,-1,13737,13735,13733,-1,13361,13363,13732,-1,13732,13736,13361,-1,13738,13488,13736,-1,13736,13734,13738,-1,13739,13368,13367,-1,13367,13370,13739,-1,13367,13366,13593,-1,13593,13369,13367,-1,13368,13740,13741,-1,13741,13366,13368,-1,13740,13368,13739,-1,13739,13742,13740,-1,13742,13739,13370,-1,13370,13743,13742,-1,13376,13373,13372,-1,13372,13374,13376,-1,13744,13372,13371,-1,13371,13745,13744,-1,13585,13590,13371,-1,13371,13373,13585,-1,13746,13374,13372,-1,13372,13744,13746,-1,13377,13585,13373,-1,13373,13376,13377,-1,13747,13375,13374,-1,13374,13746,13747,-1,13748,13377,13375,-1,13375,13747,13748,-1,13746,13742,13743,-1,13743,13747,13746,-1,13749,13748,13747,-1,13747,13743,13749,-1,13744,13740,13742,-1,13742,13746,13744,-1,13583,13749,13743,-1,13743,13370,13583,-1,13750,13592,13366,-1,13366,13741,13750,-1,13745,13741,13740,-1,13740,13744,13745,-1,13646,13641,13380,-1,13380,13379,13646,-1,13378,13751,13752,-1,13752,13379,13378,-1,13378,13380,13753,-1,13753,13754,13378,-1,13755,13652,13379,-1,13379,13752,13755,-1,13751,13756,13757,-1,13757,13752,13751,-1,13754,13758,13751,-1,13751,13378,13754,-1,13756,13751,13758,-1,13758,13759,13756,-1,13760,13759,13758,-1,13758,13761,13760,-1,13383,13756,13759,-1,13759,13762,13383,-1,13759,13760,13763,-1,13763,13762,13759,-1,13756,13383,13382,-1,13382,13757,13756,-1,13381,13383,13762,-1,13762,13763,13381,-1,13381,13763,13650,-1,13650,13647,13381,-1,13760,13764,13650,-1,13650,13763,13760,-1,13754,13753,13761,-1,13761,13758,13754,-1,13764,13760,13761,-1,13761,13765,13764,-1,13753,13640,13765,-1,13765,13761,13753,-1,13647,13649,13382,-1,13382,13381,13647,-1,13380,13641,13640,-1,13640,13753,13380,-1,13757,13382,13653,-1,13653,13766,13757,-1,13488,13486,13361,-1,13361,13736,13488,-1,13480,13738,13734,-1,13734,13359,13480,-1,13745,13371,13591,-1,13591,13767,13745,-1,13741,13745,13767,-1,13767,13750,13741,-1,13757,13766,13755,-1,13755,13752,13757,-1,13768,13769,13770,-1,13770,13771,13768,-1,13388,13387,13771,-1,13771,13770,13388,-1,13772,13770,13769,-1,13769,13773,13772,-1,13769,13768,13386,-1,13386,13385,13769,-1,13774,13768,13771,-1,13771,13775,13774,-1,13768,13774,13391,-1,13391,13386,13768,-1,13773,13769,13385,-1,13385,13696,13773,-1,13775,13771,13387,-1,13387,13776,13775,-1,13394,13776,13387,-1,13387,13389,13394,-1,13777,13775,13776,-1,13776,13394,13777,-1,13778,13774,13775,-1,13775,13777,13778,-1,13770,13772,13565,-1,13565,13388,13770,-1,13391,13390,13384,-1,13384,13386,13391,-1,13774,13778,13392,-1,13392,13391,13774,-1,13394,13779,13780,-1,13780,13777,13394,-1,13777,13780,13781,-1,13781,13778,13777,-1,13778,13781,13393,-1,13393,13392,13778,-1,13390,13393,13707,-1,13707,13384,13390,-1,13384,13707,13695,-1,13695,13385,13384,-1,13395,13389,13388,-1,13388,13564,13395,-1,13398,13782,13783,-1,13783,13396,13398,-1,13396,13783,13784,-1,13784,13710,13396,-1,13782,13785,13786,-1,13786,13783,13782,-1,13782,13398,13397,-1,13397,13787,13782,-1,13783,13786,13788,-1,13788,13784,13783,-1,13785,13401,13400,-1,13400,13786,13785,-1,13782,13787,13789,-1,13789,13785,13782,-1,13786,13400,13790,-1,13790,13788,13786,-1,13399,13401,13785,-1,13785,13789,13399,-1,13791,13716,13789,-1,13789,13787,13791,-1,13716,13714,13399,-1,13399,13789,13716,-1,13708,13791,13787,-1,13787,13397,13708,-1,13792,13405,13404,-1,13404,13793,13792,-1,13404,13406,13794,-1,13794,13795,13404,-1,13476,13407,13405,-1,13405,13475,13476,-1,13406,13407,13479,-1,13479,13796,13406,-1,13412,13797,13410,-1,13410,13409,13412,-1,13410,13497,13495,-1,13495,13408,13410,-1,13413,13469,13798,-1,13798,13412,13413,-1,13797,13799,13800,-1,13800,13410,13797,-1,13797,13412,13798,-1,13798,13554,13797,-1,13410,13800,13801,-1,13801,13497,13410,-1,13799,13792,13793,-1,13793,13800,13799,-1,13797,13554,13553,-1,13553,13799,13797,-1,13800,13793,13802,-1,13802,13801,13800,-1,13473,13792,13799,-1,13799,13553,13473,-1,13793,13404,13795,-1,13795,13802,13793,-1,13475,13405,13792,-1,13792,13473,13475,-1,13803,13416,13415,-1,13415,13417,13803,-1,13418,13415,13414,-1,13414,13432,13418,-1,13449,13448,13414,-1,13414,13416,13449,-1,13448,13215,13432,-1,13432,13414,13448,-1,13804,13418,13432,-1,13432,13431,13804,-1,13805,13422,13420,-1,13420,13419,13805,-1,13422,13805,13430,-1,13430,13429,13422,-1,13805,13419,13806,-1,13806,13807,13805,-1,13467,13425,13424,-1,13424,13427,13467,-1,13423,13808,13426,-1,13426,13424,13423,-1,13423,13425,13466,-1,13466,13809,13423,-1,13808,13810,13807,-1,13807,13426,13808,-1,13808,13423,13809,-1,13809,13811,13808,-1,13427,13426,13807,-1,13807,13806,13427,-1,13810,13430,13805,-1,13805,13807,13810,-1,13810,13808,13811,-1,13811,13812,13810,-1,13813,13430,13810,-1,13810,13812,13813,-1,13428,13814,13804,-1,13804,13429,13428,-1,13428,13430,13813,-1,13813,13433,13428,-1,13429,13804,13431,-1,13431,13422,13429,-1,13422,13431,13215,-1,13215,13218,13422,-1,13814,13441,13418,-1,13418,13804,13814,-1,13417,13418,13441,-1,13441,13440,13417,-1,13437,13434,13433,-1,13433,13813,13437,-1,13814,13428,13433,-1,13433,13435,13814,-1,13435,13439,13441,-1,13441,13814,13435,-1,13434,13815,13816,-1,13816,13435,13434,-1,13437,13436,13815,-1,13815,13434,13437,-1,13813,13812,13438,-1,13438,13437,13813,-1,13809,13466,13817,-1,13817,13818,13809,-1,13819,13818,13817,-1,13817,13820,13819,-1,13466,13471,13821,-1,13821,13817,13466,-1,13811,13809,13818,-1,13818,13822,13811,-1,13819,13823,13822,-1,13822,13818,13819,-1,13812,13811,13822,-1,13822,13438,13812,-1,13823,13436,13438,-1,13438,13822,13823,-1,13419,13421,13824,-1,13824,13806,13419,-1,13825,13427,13806,-1,13806,13824,13825,-1,13421,13826,13827,-1,13827,13824,13421,-1,13803,13417,13440,-1,13440,13828,13803,-1,13829,13828,13440,-1,13440,13439,13829,-1,13828,13830,13831,-1,13831,13803,13828,-1,13832,13833,13444,-1,13444,13443,13832,-1,13446,13443,13442,-1,13442,13834,13446,-1,13790,13835,13442,-1,13442,13444,13790,-1,13834,13442,13835,-1,13835,13715,13834,-1,13443,13446,13445,-1,13445,13832,13443,-1,13447,13446,13834,-1,13834,13836,13447,-1,13837,13836,13834,-1,13834,13715,13837,-1,13829,13447,13836,-1,13836,13838,13829,-1,13836,13837,13839,-1,13839,13838,13836,-1,13447,13829,13439,-1,13439,13445,13447,-1,13829,13838,13830,-1,13830,13828,13829,-1,13421,13420,13218,-1,13218,13219,13421,-1,13840,13449,13416,-1,13416,13841,13840,-1,13831,13841,13416,-1,13416,13803,13831,-1,13840,13232,13222,-1,13222,13449,13840,-1,13456,13840,13841,-1,13841,13842,13456,-1,13450,13452,13459,-1,13459,13843,13450,-1,13843,13459,13458,-1,13458,13844,13843,-1,13452,13460,13457,-1,13457,13459,13452,-1,13454,13450,13843,-1,13843,13845,13454,-1,13846,13845,13843,-1,13843,13844,13846,-1,13847,13454,13845,-1,13845,13848,13847,-1,13842,13841,13831,-1,13831,13849,13842,-1,13234,13232,13840,-1,13840,13456,13234,-1,13457,13456,13842,-1,13842,13458,13457,-1,13458,13842,13849,-1,13849,13844,13458,-1,13058,13060,13460,-1,13460,13461,13058,-1,13464,13825,13824,-1,13824,13827,13464,-1,13464,13463,13468,-1,13468,13825,13464,-1,13827,13826,13462,-1,13462,13464,13827,-1,13468,13467,13427,-1,13427,13825,13468,-1,13236,13238,13826,-1,13826,13421,13236,-1,13462,13826,13238,-1,13238,13237,13462,-1,13461,13465,13850,-1,13850,13851,13461,-1,13452,13451,13852,-1,13852,13465,13452,-1,13413,13411,13853,-1,13853,13854,13413,-1,13853,13855,13856,-1,13856,13854,13853,-1,13411,13857,13858,-1,13858,13853,13411,-1,13471,13466,13413,-1,13413,13854,13471,-1,13425,13467,13469,-1,13469,13413,13425,-1,13472,13471,13854,-1,13854,13856,13472,-1,13469,13468,13501,-1,13501,13798,13469,-1,13455,13472,13856,-1,13856,13859,13455,-1,13859,13856,13855,-1,13855,13860,13859,-1,13470,13472,13455,-1,13455,13453,13470,-1,13451,13455,13859,-1,13859,13852,13451,-1,13850,13465,13852,-1,13852,13861,13850,-1,13859,13860,13861,-1,13861,13852,13859,-1,13477,13476,13475,-1,13475,13474,13477,-1,13549,13477,13474,-1,13474,13546,13549,-1,13862,13365,13358,-1,13358,13481,13862,-1,13480,13365,13862,-1,13862,13863,13480,-1,13492,13863,13862,-1,13862,13864,13492,-1,13865,13738,13480,-1,13480,13863,13865,-1,13362,13364,13866,-1,13866,13737,13362,-1,13862,13481,13483,-1,13483,13864,13862,-1,13482,13731,13867,-1,13867,13484,13482,-1,13731,13735,13868,-1,13868,13867,13731,-1,13735,13737,13869,-1,13869,13868,13735,-1,13487,13488,13738,-1,13738,13865,13487,-1,13364,13486,13487,-1,13487,13866,13364,-1,13737,13866,13870,-1,13870,13869,13737,-1,13490,13870,13866,-1,13866,13487,13490,-1,13871,13491,13490,-1,13490,13487,13871,-1,13490,13489,13872,-1,13872,13870,13490,-1,13489,13491,13873,-1,13873,13855,13489,-1,13493,13874,13875,-1,13875,13494,13493,-1,13493,13492,13864,-1,13864,13876,13493,-1,13494,13877,13863,-1,13863,13492,13494,-1,13491,13871,13878,-1,13878,13873,13491,-1,13879,13871,13487,-1,13487,13865,13879,-1,13877,13879,13865,-1,13865,13863,13877,-1,13877,13494,13875,-1,13875,13880,13877,-1,13871,13879,13881,-1,13881,13878,13871,-1,13879,13877,13880,-1,13880,13881,13879,-1,13495,13496,13857,-1,13857,13411,13495,-1,13882,13496,13497,-1,13497,13801,13882,-1,13499,13883,13872,-1,13872,13500,13499,-1,13884,13503,13499,-1,13499,13498,13884,-1,13500,13858,13857,-1,13857,13498,13500,-1,13496,13884,13498,-1,13498,13857,13496,-1,13489,13858,13500,-1,13500,13872,13489,-1,13489,13855,13853,-1,13853,13858,13489,-1,13885,13886,13850,-1,13850,13861,13885,-1,13501,13552,13554,-1,13554,13798,13501,-1,13463,13547,13552,-1,13552,13501,13463,-1,13884,13496,13882,-1,13882,13887,13884,-1,13503,13884,13887,-1,13887,13888,13503,-1,13883,13499,13502,-1,13502,13889,13883,-1,13503,13888,13890,-1,13890,13502,13503,-1,13502,13890,13891,-1,13891,13889,13502,-1,13888,13892,13893,-1,13893,13890,13888,-1,13894,13891,13890,-1,13890,13893,13894,-1,13892,13506,13505,-1,13505,13893,13892,-1,13895,13892,13888,-1,13888,13887,13895,-1,13894,13893,13505,-1,13505,13896,13894,-1,13892,13895,13897,-1,13897,13506,13892,-1,13504,13898,13896,-1,13896,13505,13504,-1,13506,13897,13899,-1,13899,13504,13506,-1,13900,13898,13504,-1,13504,13899,13900,-1,13897,13901,13902,-1,13902,13899,13897,-1,13507,13876,13864,-1,13864,13483,13507,-1,13507,13485,13896,-1,13896,13898,13507,-1,13894,13896,13485,-1,13485,13484,13894,-1,13484,13867,13891,-1,13891,13894,13484,-1,13889,13891,13867,-1,13867,13868,13889,-1,13883,13889,13868,-1,13868,13869,13883,-1,13872,13883,13869,-1,13869,13870,13872,-1,13895,13903,13901,-1,13901,13897,13895,-1,13903,13802,13795,-1,13795,13901,13903,-1,13903,13895,13887,-1,13887,13882,13903,-1,13901,13795,13794,-1,13794,13902,13901,-1,13903,13882,13801,-1,13801,13802,13903,-1,13406,13508,13904,-1,13904,13794,13406,-1,13904,13905,13902,-1,13902,13794,13904,-1,13508,13906,13874,-1,13874,13904,13508,-1,13796,13527,13509,-1,13509,13406,13796,-1,13508,13509,13907,-1,13907,13906,13508,-1,13512,13511,13521,-1,13521,13568,13512,-1,13510,13514,13517,-1,13517,13511,13510,-1,13512,13515,13513,-1,13513,13510,13512,-1,13512,13569,13908,-1,13908,13515,13512,-1,13909,13910,13516,-1,13516,13513,13909,-1,13910,13911,13523,-1,13523,13516,13910,-1,13912,13910,13909,-1,13909,13913,13912,-1,13064,13063,13909,-1,13909,13513,13064,-1,13516,13523,13518,-1,13518,13514,13516,-1,13914,13915,13523,-1,13523,13911,13914,-1,13910,13912,13916,-1,13916,13911,13910,-1,13518,13524,13519,-1,13519,13517,13518,-1,13521,13511,13519,-1,13519,13522,13521,-1,13519,13526,13525,-1,13525,13522,13519,-1,13523,13915,13917,-1,13917,13524,13523,-1,13524,13917,13906,-1,13906,13907,13524,-1,13875,13917,13915,-1,13915,13880,13875,-1,13526,13519,13524,-1,13524,13907,13526,-1,13907,13509,13527,-1,13527,13526,13907,-1,13529,13534,13796,-1,13796,13479,13529,-1,13796,13534,13525,-1,13525,13527,13796,-1,13905,13900,13899,-1,13899,13902,13905,-1,13905,13904,13874,-1,13874,13493,13905,-1,13917,13875,13874,-1,13874,13906,13917,-1,13850,13886,13918,-1,13918,13851,13850,-1,13056,13058,13461,-1,13461,13851,13056,-1,13860,13919,13885,-1,13885,13861,13860,-1,13057,13056,13851,-1,13851,13918,13057,-1,13061,13057,13918,-1,13918,13913,13061,-1,13919,13920,13916,-1,13916,13885,13919,-1,13855,13873,13919,-1,13919,13860,13855,-1,13912,13886,13885,-1,13885,13916,13912,-1,13920,13914,13911,-1,13911,13916,13920,-1,13920,13919,13873,-1,13873,13878,13920,-1,13881,13914,13920,-1,13920,13878,13881,-1,13881,13880,13915,-1,13915,13914,13881,-1,13886,13912,13913,-1,13913,13918,13886,-1,13909,13063,13061,-1,13061,13913,13909,-1,13529,13528,13921,-1,13921,13922,13529,-1,13476,13478,13528,-1,13528,13479,13476,-1,13923,13924,13532,-1,13532,13531,13923,-1,13924,13925,13926,-1,13926,13532,13924,-1,13927,13928,13924,-1,13924,13923,13927,-1,13923,13531,13929,-1,13929,13930,13923,-1,13921,13530,13532,-1,13532,13926,13921,-1,13926,13925,13931,-1,13931,13932,13926,-1,13928,13933,13925,-1,13925,13924,13928,-1,13533,13934,13935,-1,13935,13525,13533,-1,13534,13529,13922,-1,13922,13533,13534,-1,13528,13936,13530,-1,13530,13921,13528,-1,13936,13937,13531,-1,13531,13530,13936,-1,13478,13544,13936,-1,13936,13528,13478,-1,13938,13560,13536,-1,13536,13939,13938,-1,13940,13929,13939,-1,13939,13536,13940,-1,13560,13559,13537,-1,13537,13536,13560,-1,13558,13560,13938,-1,13938,13941,13558,-1,13939,13937,13543,-1,13543,13938,13939,-1,13536,13535,13539,-1,13539,13940,13536,-1,13942,13535,13537,-1,13537,13943,13942,-1,13539,13538,13944,-1,13944,13945,13539,-1,13946,13538,13535,-1,13535,13942,13946,-1,13940,13539,13945,-1,13945,13947,13940,-1,13937,13939,13929,-1,13929,13531,13937,-1,13937,13936,13544,-1,13544,13543,13937,-1,13921,13926,13932,-1,13932,13922,13921,-1,13922,13932,13934,-1,13934,13533,13922,-1,13948,13949,13950,-1,13950,13951,13948,-1,13950,13952,13953,-1,13953,13951,13950,-1,13949,13954,13955,-1,13955,13950,13949,-1,13948,13956,13957,-1,13957,13949,13948,-1,13958,13948,13951,-1,13951,13959,13958,-1,13950,13955,13960,-1,13960,13952,13950,-1,13954,13541,13961,-1,13961,13955,13954,-1,13954,13949,13957,-1,13957,13962,13954,-1,13955,13961,13963,-1,13963,13960,13955,-1,13541,13540,13964,-1,13964,13961,13541,-1,13954,13962,13542,-1,13542,13541,13954,-1,13961,13964,13623,-1,13623,13963,13961,-1,13540,13942,13943,-1,13943,13964,13540,-1,13964,13943,13680,-1,13680,13623,13964,-1,13540,13542,13946,-1,13946,13942,13540,-1,13559,13680,13943,-1,13943,13537,13559,-1,13965,13934,13932,-1,13932,13931,13965,-1,13925,13933,13966,-1,13966,13931,13925,-1,13967,13965,13931,-1,13931,13966,13967,-1,13968,13969,13966,-1,13966,13933,13968,-1,13545,13544,13478,-1,13478,13477,13545,-1,13545,13477,13549,-1,13549,13551,13545,-1,13550,13549,13546,-1,13546,13548,13550,-1,13548,13241,13243,-1,13243,13550,13548,-1,13547,13546,13474,-1,13474,13552,13547,-1,13474,13473,13553,-1,13553,13552,13474,-1,13905,13493,13876,-1,13876,13900,13905,-1,13507,13898,13900,-1,13900,13876,13507,-1,13929,13940,13947,-1,13947,13930,13929,-1,13941,13938,13543,-1,13543,13545,13941,-1,13683,13556,13555,-1,13555,13550,13683,-1,13556,13558,13941,-1,13941,13555,13556,-1,13678,13556,13683,-1,13683,13676,13678,-1,13247,13683,13550,-1,13550,13243,13247,-1,13545,13551,13555,-1,13555,13941,13545,-1,13780,13779,13561,-1,13561,13563,13780,-1,13779,13970,13971,-1,13971,13561,13779,-1,13972,13781,13780,-1,13780,13563,13972,-1,13973,13562,13561,-1,13561,13971,13973,-1,13971,13970,13974,-1,13974,13975,13971,-1,13394,13395,13970,-1,13970,13779,13394,-1,13395,13564,13974,-1,13974,13970,13395,-1,13564,13565,13976,-1,13976,13974,13564,-1,13977,13975,13974,-1,13974,13976,13977,-1,13976,13565,13772,-1,13772,13978,13976,-1,13908,13065,13064,-1,13064,13515,13908,-1,13979,13980,13567,-1,13567,13566,13979,-1,13980,13572,13981,-1,13981,13567,13980,-1,13982,13980,13979,-1,13979,13983,13982,-1,13984,13979,13566,-1,13566,13985,13984,-1,13981,13569,13568,-1,13568,13567,13981,-1,13981,13572,13570,-1,13570,13986,13981,-1,13980,13982,13573,-1,13573,13572,13980,-1,13569,13981,13986,-1,13986,13908,13569,-1,13986,13067,13065,-1,13065,13908,13986,-1,13068,13067,13986,-1,13986,13570,13068,-1,13572,13574,13571,-1,13571,13570,13572,-1,13574,13577,13575,-1,13575,13571,13574,-1,13577,13579,13580,-1,13580,13575,13577,-1,13204,13068,13575,-1,13575,13580,13204,-1,13579,13582,13581,-1,13581,13580,13579,-1,13581,13582,13987,-1,13987,13988,13581,-1,13603,13605,13586,-1,13586,13377,13603,-1,13590,13585,13586,-1,13586,13588,13590,-1,13989,13588,13586,-1,13586,13605,13989,-1,13377,13748,13990,-1,13990,13603,13377,-1,13748,13749,13991,-1,13991,13990,13748,-1,13749,13583,13992,-1,13992,13991,13749,-1,13369,13593,13594,-1,13594,13584,13369,-1,13583,13584,13993,-1,13993,13992,13583,-1,13994,13767,13591,-1,13591,13587,13994,-1,13995,13750,13767,-1,13767,13994,13995,-1,13592,13750,13995,-1,13995,13595,13592,-1,13996,13997,13998,-1,13998,13999,13996,-1,14000,14001,13999,-1,13999,13998,14000,-1,13610,13998,13997,-1,13997,14002,13610,-1,13996,13598,14003,-1,14003,13997,13996,-1,13999,14004,14005,-1,14005,13996,13999,-1,13598,13996,14005,-1,14005,14006,13598,-1,14007,14008,14006,-1,14006,14005,14007,-1,13599,13598,14006,-1,14006,14009,13599,-1,14010,14009,14006,-1,14006,14008,14010,-1,14011,13599,14009,-1,14009,14012,14011,-1,14013,14012,14009,-1,14009,14010,14013,-1,14011,14014,13597,-1,13597,13599,14011,-1,14015,14011,14012,-1,14012,14016,14015,-1,14017,14016,14012,-1,14012,14013,14017,-1,14015,13989,14014,-1,14014,14011,14015,-1,13589,14015,14016,-1,14016,14018,13589,-1,14016,14017,14019,-1,14019,14018,14016,-1,13589,13588,13989,-1,13989,14015,13589,-1,13589,14018,14020,-1,14020,13587,13589,-1,13994,13587,14020,-1,14020,14021,13994,-1,14022,14020,14018,-1,14018,14019,14022,-1,13542,13962,13602,-1,13602,13601,13542,-1,13675,13601,13600,-1,13600,13576,13675,-1,14023,13600,13602,-1,13602,14024,14023,-1,13576,13600,13578,-1,13578,13577,13576,-1,13606,13608,14025,-1,14025,14026,13606,-1,14026,14025,13604,-1,13604,14027,14026,-1,14028,14025,13608,-1,13608,14029,14028,-1,14030,13606,14026,-1,14026,14031,14030,-1,14026,14027,14032,-1,14032,14031,14026,-1,13606,14030,14002,-1,14002,13607,13606,-1,13611,14030,14031,-1,14031,14033,13611,-1,14034,14033,14031,-1,14031,14032,14034,-1,13611,13610,14002,-1,14002,14030,13611,-1,13609,13611,14033,-1,14033,14035,13609,-1,14035,14033,14034,-1,14034,14036,14035,-1,13609,14035,14037,-1,14037,14000,13609,-1,13207,13206,13581,-1,13581,14038,13207,-1,13582,13578,14039,-1,14039,13987,13582,-1,14040,14041,13987,-1,13987,14039,14040,-1,13578,14042,14043,-1,14043,14039,13578,-1,14044,14045,13594,-1,13594,13596,14044,-1,13595,14046,14047,-1,14047,13596,13595,-1,14045,13993,13584,-1,13584,13594,14045,-1,13958,14048,14045,-1,14045,14044,13958,-1,13596,14047,13956,-1,13956,14044,13596,-1,14048,14036,13993,-1,13993,14045,14048,-1,13959,14037,14048,-1,14048,13958,13959,-1,14044,13956,13948,-1,13948,13958,14044,-1,14037,14035,14036,-1,14036,14048,14037,-1,14001,14000,14037,-1,14037,13959,14001,-1,13959,13951,13953,-1,13953,14001,13959,-1,13953,13952,14049,-1,14049,14004,13953,-1,14004,14049,14007,-1,14007,14005,14004,-1,14050,14049,13952,-1,13952,13960,14050,-1,14001,13953,14004,-1,14004,13999,14001,-1,13609,14000,13998,-1,13998,13610,13609,-1,14027,13604,13603,-1,13603,13990,14027,-1,14025,14028,13605,-1,13605,13604,14025,-1,14036,14034,13992,-1,13992,13993,14036,-1,14032,14027,13990,-1,13990,13991,14032,-1,14034,14032,13991,-1,13991,13992,14034,-1,13995,14051,14046,-1,14046,13595,13995,-1,14050,13960,13963,-1,13963,14052,14050,-1,13957,13956,14047,-1,14047,14024,13957,-1,14024,14047,14046,-1,14046,14023,14024,-1,13962,13957,14024,-1,14024,13602,13962,-1,13542,13601,13675,-1,13675,13946,13542,-1,13613,13616,13618,-1,13618,13614,13613,-1,13613,13612,14053,-1,14053,14054,13613,-1,13618,13617,13626,-1,13626,13625,13618,-1,13616,14055,14056,-1,14056,13617,13616,-1,14020,14022,14043,-1,14043,14021,14020,-1,13994,14021,14051,-1,14051,13995,13994,-1,14043,14042,14051,-1,14051,14021,14043,-1,13989,13605,14028,-1,14028,14014,13989,-1,14014,14028,14029,-1,14029,13597,14014,-1,14057,14017,14013,-1,14013,14058,14057,-1,13557,13556,13678,-1,13678,13619,13557,-1,13619,13678,13677,-1,13677,13624,13619,-1,13622,13557,13619,-1,13619,13621,13622,-1,13621,14059,14052,-1,14052,13622,13621,-1,14050,14052,14059,-1,14059,14060,14050,-1,14061,14060,14059,-1,14059,14062,14061,-1,14049,14050,14060,-1,14060,14007,14049,-1,14060,14061,14008,-1,14008,14007,14060,-1,14002,13997,14003,-1,14003,13607,14002,-1,13622,14052,13963,-1,13963,13623,13622,-1,13620,14062,14059,-1,14059,13621,13620,-1,14063,14064,14061,-1,14061,14062,14063,-1,14029,13608,13607,-1,13607,14003,14029,-1,13597,14029,14003,-1,14003,13598,13597,-1,14064,14010,14008,-1,14008,14061,14064,-1,14058,14013,14010,-1,14010,14064,14058,-1,14065,14058,14064,-1,14064,14063,14065,-1,14062,13620,14056,-1,14056,14063,14062,-1,13617,14056,13620,-1,13620,13626,13617,-1,13626,13620,13619,-1,13619,13624,13626,-1,13614,13618,13625,-1,13625,14066,13614,-1,14063,14056,14055,-1,14055,14065,14063,-1,14055,14067,14068,-1,14068,14065,14055,-1,14017,14057,14069,-1,14069,14019,14017,-1,14068,14057,14058,-1,14058,14065,14068,-1,14070,14068,14067,-1,14067,14071,14070,-1,13671,14067,14055,-1,14055,13616,13671,-1,14071,14067,13671,-1,13671,13670,14071,-1,14057,14068,14070,-1,14070,14069,14057,-1,14072,14041,14070,-1,14070,14071,14072,-1,13628,14073,14074,-1,14074,13629,13628,-1,14075,13628,13627,-1,13627,14076,14075,-1,14077,13627,13629,-1,13629,13662,14077,-1,14074,13663,13662,-1,13662,13629,14074,-1,13631,14074,14073,-1,14073,14078,13631,-1,14079,14073,13628,-1,13628,14075,14079,-1,14079,14080,14078,-1,14078,14073,14079,-1,13630,13663,14074,-1,14074,13631,13630,-1,14078,14081,13632,-1,13632,13631,14078,-1,14081,14082,14083,-1,14083,13632,14081,-1,14084,14081,14078,-1,14078,14080,14084,-1,13630,13632,14083,-1,14083,14085,13630,-1,14082,14066,13625,-1,13625,14083,14082,-1,14084,14086,14082,-1,14082,14081,14084,-1,14083,13625,13624,-1,13624,14085,14083,-1,14086,14087,14066,-1,14066,14082,14086,-1,14087,13615,13614,-1,13614,14066,14087,-1,14040,14022,14019,-1,14019,14069,14040,-1,14039,14043,14022,-1,14022,14040,14039,-1,14041,14040,14069,-1,14069,14070,14041,-1,13615,14088,14053,-1,14053,13612,13615,-1,14089,13635,13634,-1,13634,14090,14089,-1,14091,14092,13634,-1,13634,13633,14091,-1,13681,13633,13635,-1,13635,14093,13681,-1,14092,14094,14090,-1,14090,13634,14092,-1,13635,14089,14095,-1,14095,14093,13635,-1,14096,14089,14090,-1,14090,14097,14096,-1,13660,14097,14090,-1,14090,14094,13660,-1,14096,14098,14095,-1,14095,14089,14096,-1,14097,13615,14087,-1,14087,14096,14097,-1,14087,14086,14098,-1,14098,14096,14087,-1,14088,13615,14097,-1,14097,13660,14088,-1,14099,14053,14088,-1,14088,14100,14099,-1,13681,13673,13672,-1,13672,13633,13681,-1,14101,13682,13681,-1,13681,14093,14101,-1,14102,14103,14104,-1,14104,14105,14102,-1,14105,14104,13764,-1,13764,13765,14105,-1,14106,14104,14103,-1,14103,14107,14106,-1,14102,13674,14108,-1,14108,14103,14102,-1,14109,14102,14105,-1,14105,14110,14109,-1,14110,14105,13765,-1,13765,13640,14110,-1,14109,13672,13674,-1,13674,14102,14109,-1,14091,14109,14110,-1,14110,14111,14091,-1,13640,13642,14111,-1,14111,14110,13640,-1,14091,13633,13672,-1,13672,14109,14091,-1,14092,14091,14111,-1,14111,14112,14092,-1,13644,14112,14111,-1,14111,13642,13644,-1,14094,14092,14112,-1,14112,14113,14094,-1,14114,14084,14080,-1,14080,14115,14114,-1,14116,14115,14080,-1,14080,14079,14116,-1,14086,14084,14114,-1,14114,14098,14086,-1,14117,14114,14115,-1,14115,14118,14117,-1,14119,14118,14115,-1,14115,14116,14119,-1,14114,14117,14095,-1,14095,14098,14114,-1,14101,14117,14118,-1,14118,14120,14101,-1,14121,14120,14118,-1,14118,14119,14121,-1,14093,14095,14117,-1,14117,14101,14093,-1,13682,14101,14120,-1,14120,13638,13682,-1,13639,13638,14120,-1,14120,14121,13639,-1,14108,13682,13638,-1,13638,13637,14108,-1,13674,13673,13682,-1,13682,14108,13674,-1,13637,14107,14103,-1,14103,14108,13637,-1,14122,13636,13639,-1,13639,14123,14122,-1,13639,14121,14124,-1,14124,14123,13639,-1,13636,14122,14107,-1,14107,13637,13636,-1,14125,14122,14123,-1,14123,14126,14125,-1,13641,13646,13643,-1,13643,13642,13641,-1,13648,14127,13653,-1,13653,13649,13648,-1,13647,13651,13655,-1,13655,13648,13647,-1,14104,14106,13650,-1,13650,13764,14104,-1,14128,13667,14129,-1,14129,14130,14128,-1,14130,14129,14131,-1,14131,14132,14130,-1,13666,14133,14129,-1,14129,13667,13666,-1,14128,14134,13665,-1,13665,13667,14128,-1,14127,14128,14130,-1,14130,14135,14127,-1,14135,14130,14132,-1,14132,14136,14135,-1,14128,14127,14137,-1,14137,14134,14128,-1,13766,13653,14127,-1,14127,14135,13766,-1,14127,13648,13655,-1,13655,14137,14127,-1,13655,13654,13669,-1,13669,14137,13655,-1,14123,14124,14138,-1,14138,14126,14123,-1,14107,14122,14125,-1,14125,14106,14107,-1,13651,14125,14126,-1,14126,13654,13651,-1,13654,14126,14138,-1,14138,13668,13654,-1,14125,13651,13650,-1,13650,14106,14125,-1,14041,14072,13988,-1,13988,13987,14041,-1,14038,13581,13988,-1,13988,14139,14038,-1,14072,14140,14139,-1,14139,13988,14072,-1,14141,14038,14139,-1,14139,14142,14141,-1,14142,14143,14144,-1,14144,14141,14142,-1,14141,14144,14145,-1,14145,14146,14141,-1,14147,14144,14143,-1,14143,14148,14147,-1,13657,13656,14143,-1,14143,14142,13657,-1,13656,14149,14148,-1,14148,14143,13656,-1,14145,14144,14147,-1,14147,14150,14145,-1,14151,14152,14147,-1,14147,14148,14151,-1,13645,13646,13652,-1,13652,14153,13645,-1,14153,13652,13755,-1,13755,14136,14153,-1,14136,13755,13766,-1,13766,14135,14136,-1,14140,14072,14071,-1,14071,13670,14140,-1,13670,13658,13657,-1,13657,14140,13670,-1,14149,13656,13658,-1,13658,14154,14149,-1,14154,13658,13671,-1,13671,14054,14154,-1,14154,14099,14155,-1,14155,14149,14154,-1,14156,14151,14155,-1,14155,14157,14156,-1,14157,14155,14099,-1,14099,14100,14157,-1,14149,14155,14151,-1,14151,14148,14149,-1,14156,14131,14152,-1,14152,14151,14156,-1,14158,14156,14157,-1,14157,14159,14158,-1,13659,14159,14157,-1,14157,14100,13659,-1,14158,14132,14131,-1,14131,14156,14158,-1,14153,14158,14159,-1,14159,14160,14153,-1,13644,14161,14113,-1,14113,14112,13644,-1,13660,14094,14113,-1,14113,13661,13660,-1,14161,14160,13661,-1,13661,14113,14161,-1,14088,13660,13659,-1,13659,14100,14088,-1,14116,14079,14075,-1,14075,14162,14116,-1,14076,14163,14162,-1,14162,14075,14076,-1,14119,14116,14162,-1,14162,14164,14119,-1,14164,14162,14163,-1,14163,14165,14164,-1,14121,14119,14164,-1,14164,14124,14121,-1,14124,14164,14165,-1,14165,14138,14124,-1,13082,14166,13684,-1,13684,13212,13082,-1,13225,13686,14077,-1,14077,13226,13225,-1,13662,13229,13226,-1,13226,14077,13662,-1,13686,14167,13627,-1,13627,14077,13686,-1,13686,13225,13212,-1,13212,13684,13686,-1,14166,14168,13685,-1,13685,13684,14166,-1,13074,14146,14166,-1,14166,13082,13074,-1,14146,14145,14168,-1,14168,14166,14146,-1,14146,13074,13073,-1,13073,14141,14146,-1,14133,13666,14169,-1,14169,14150,14133,-1,14145,14150,14169,-1,14169,14168,14145,-1,13666,14170,14171,-1,14171,14169,13666,-1,14133,14150,14147,-1,14147,14152,14133,-1,14168,14169,14171,-1,14171,13685,14168,-1,14167,14171,14170,-1,14170,14172,14167,-1,13665,14173,14170,-1,14170,13666,13665,-1,14172,14170,14173,-1,14173,14174,14172,-1,14134,14175,14173,-1,14173,13665,14134,-1,14129,14133,14152,-1,14152,14131,14129,-1,14175,14176,14174,-1,14174,14173,14175,-1,13669,14175,14134,-1,14134,14137,13669,-1,14176,14175,13669,-1,13669,13668,14176,-1,14176,13668,14138,-1,14138,14165,14176,-1,14163,14174,14176,-1,14176,14165,14163,-1,14174,14163,14076,-1,14076,14172,14174,-1,14172,14076,13627,-1,13627,14167,14172,-1,13229,13662,13664,-1,13664,14177,13229,-1,14177,13106,13228,-1,13228,13229,14177,-1,13643,13645,14161,-1,14161,13644,13643,-1,14038,14141,13073,-1,13073,13207,14038,-1,14136,14132,14158,-1,14158,14153,14136,-1,13645,14153,14160,-1,14160,14161,13645,-1,14160,14159,13659,-1,13659,13661,14160,-1,14054,14053,14099,-1,14099,14154,14054,-1,14140,13657,14142,-1,14142,14139,14140,-1,14042,13578,13600,-1,13600,14023,14042,-1,14023,14046,14051,-1,14051,14042,14023,-1,13574,13573,13687,-1,13687,13675,13574,-1,13679,14178,13677,-1,13677,13676,13679,-1,14085,13624,13677,-1,13677,14178,14085,-1,14179,14178,13679,-1,13679,14180,14179,-1,14179,13630,14085,-1,14085,14178,14179,-1,14179,13664,13663,-1,13663,13630,14179,-1,13557,13623,13680,-1,13680,13558,13557,-1,13548,13547,13463,-1,13463,13462,13548,-1,13237,13241,13548,-1,13548,13462,13237,-1,14180,13107,13106,-1,13106,14177,14180,-1,14180,13679,13247,-1,13247,13107,14180,-1,14177,13664,14179,-1,14179,14180,14177,-1,14054,13671,13616,-1,13616,13613,14054,-1,13685,14171,14167,-1,14167,13686,13685,-1,13675,13687,13538,-1,13538,13946,13675,-1,13687,13573,13982,-1,13982,13688,13687,-1,14181,13566,13568,-1,13568,13521,14181,-1,13522,13525,13935,-1,13935,13520,13522,-1,13689,14182,14183,-1,14183,13690,13689,-1,13690,14183,14184,-1,14184,14185,13690,-1,14182,14186,14187,-1,14187,14183,14182,-1,14188,14182,13689,-1,13689,14189,14188,-1,13691,13690,14185,-1,14185,14190,13691,-1,14189,13689,13691,-1,13691,14191,14189,-1,14192,13978,13772,-1,13772,13773,14192,-1,13978,14192,13984,-1,13984,13985,13978,-1,13692,14192,13773,-1,13773,13696,13692,-1,13984,14192,13692,-1,13692,14193,13984,-1,13692,13694,14194,-1,14194,14193,13692,-1,14186,13694,13693,-1,13693,14187,14186,-1,13693,13695,13707,-1,13707,13706,13693,-1,13703,14187,13693,-1,13693,13706,13703,-1,14194,13694,14186,-1,14186,14195,14194,-1,14183,14187,13703,-1,13703,14184,14183,-1,14195,14186,14182,-1,14182,14188,14195,-1,13976,13978,13985,-1,13985,14196,13976,-1,13566,14181,14196,-1,14196,13985,13566,-1,13977,13976,14196,-1,14196,14197,13977,-1,14181,14198,14197,-1,14197,14196,14181,-1,14199,13977,14197,-1,14197,14200,14199,-1,14198,14201,14200,-1,14200,14197,14198,-1,13977,14199,14202,-1,14202,13975,13977,-1,14203,14199,14200,-1,14200,13967,14203,-1,13965,13967,14200,-1,14200,14201,13965,-1,14199,14203,14204,-1,14204,14202,14199,-1,13969,14203,13967,-1,13967,13966,13969,-1,14203,13969,14205,-1,14205,14204,14203,-1,13969,13968,14206,-1,14206,14205,13969,-1,14207,13968,13933,-1,13933,13928,14207,-1,14208,14206,13968,-1,13968,14207,14208,-1,14209,14207,13928,-1,13928,13927,14209,-1,14207,14209,14210,-1,14210,14208,14207,-1,14191,13691,14209,-1,14209,13927,14191,-1,14206,13698,14211,-1,14211,14205,14206,-1,14204,14205,14211,-1,14211,14212,14204,-1,14211,13698,13697,-1,13697,14213,14211,-1,13699,13698,14206,-1,14206,14208,13699,-1,14214,13697,13699,-1,13699,14215,14214,-1,14216,14217,14218,-1,14218,14219,14216,-1,13563,14219,14218,-1,14218,13972,13563,-1,14218,14217,14220,-1,14220,13705,14218,-1,14216,14214,13701,-1,13701,14217,14216,-1,14219,14221,14213,-1,14213,14216,14219,-1,13702,13701,14214,-1,14214,14215,13702,-1,14217,13701,13700,-1,13700,14220,14217,-1,14190,14185,13700,-1,13700,13702,14190,-1,13393,13704,13703,-1,13703,13706,13393,-1,14194,14195,13944,-1,13944,14222,14194,-1,14222,13944,13538,-1,13538,13688,14222,-1,13945,13944,14195,-1,14195,14188,13945,-1,14222,13983,14193,-1,14193,14194,14222,-1,13947,13945,14188,-1,14188,14189,13947,-1,13702,14215,14210,-1,14210,14190,13702,-1,14215,13699,14208,-1,14208,14210,14215,-1,14210,14209,13691,-1,13691,14190,14210,-1,13705,14220,14184,-1,14184,13703,13705,-1,14185,14184,14220,-1,14220,13700,14185,-1,13927,13923,13930,-1,13930,14191,13927,-1,13930,13947,14189,-1,14189,14191,13930,-1,14198,14181,13521,-1,13521,13520,14198,-1,13520,13935,14201,-1,14201,14198,13520,-1,13984,14193,13983,-1,13983,13979,13984,-1,13688,13982,13983,-1,13983,14222,13688,-1,13935,13934,13965,-1,13965,14201,13935,-1,14213,13697,14214,-1,14214,14216,14213,-1,14212,14211,14213,-1,14213,14221,14212,-1,13562,14221,14219,-1,14219,13563,13562,-1,13972,14218,13705,-1,13705,13704,13972,-1,13704,13393,13781,-1,13781,13972,13704,-1,13975,14202,13973,-1,13973,13971,13975,-1,14202,14204,14212,-1,14212,13973,14202,-1,13973,14212,14221,-1,14221,13562,13973,-1,14223,13403,13396,-1,13396,13709,14223,-1,13708,13403,14223,-1,14223,14224,13708,-1,13717,14224,14223,-1,14223,14225,13717,-1,14226,13791,13708,-1,13708,14224,14226,-1,13400,13402,13835,-1,13835,13790,13400,-1,14223,13709,13711,-1,13711,14225,14223,-1,13710,13784,14227,-1,14227,13712,13710,-1,13784,13788,14228,-1,14228,14227,13784,-1,13788,13790,13444,-1,13444,14228,13788,-1,13715,13716,13791,-1,13791,14226,13715,-1,13402,13714,13715,-1,13715,13835,13402,-1,13718,14229,13847,-1,13847,13719,13718,-1,13718,13717,14225,-1,14225,14230,13718,-1,13719,14231,14224,-1,14224,13717,13719,-1,14232,13837,13715,-1,13715,14226,14232,-1,14231,14232,14226,-1,14226,14224,14231,-1,14231,13719,13847,-1,13847,13848,14231,-1,13837,14232,14233,-1,14233,13839,13837,-1,14232,14231,13848,-1,13848,14233,14232,-1,13721,13833,13832,-1,13832,13722,13721,-1,14234,13724,13721,-1,13721,13720,14234,-1,13722,13816,13815,-1,13815,13720,13722,-1,13436,14234,13720,-1,13720,13815,13436,-1,13445,13816,13722,-1,13722,13832,13445,-1,13445,13439,13435,-1,13435,13816,13445,-1,14234,13436,13823,-1,13823,14235,14234,-1,13724,14234,14235,-1,14235,14236,13724,-1,13833,13721,13723,-1,13723,14237,13833,-1,13724,14236,14238,-1,14238,13723,13724,-1,13723,14238,14239,-1,14239,14237,13723,-1,14236,14240,14241,-1,14241,14238,14236,-1,14242,14239,14238,-1,14238,14241,14242,-1,14240,13727,13726,-1,13726,14241,14240,-1,14243,14240,14236,-1,14236,14235,14243,-1,14242,14241,13726,-1,13726,14244,14242,-1,14240,14243,14245,-1,14245,13727,14240,-1,13725,14246,14244,-1,14244,13726,13725,-1,13727,14245,14247,-1,14247,13725,13727,-1,14248,14246,13725,-1,13725,14247,14248,-1,14245,13820,14249,-1,14249,14247,14245,-1,13728,14230,14225,-1,14225,13711,13728,-1,13728,13713,14244,-1,14244,14246,13728,-1,14242,14244,13713,-1,13713,13712,14242,-1,13712,14227,14239,-1,14239,14242,13712,-1,14237,14239,14227,-1,14227,14228,14237,-1,13833,14237,14228,-1,14228,13444,13833,-1,14243,13819,13820,-1,13820,14245,14243,-1,13819,14243,14235,-1,14235,13823,13819,-1,13820,13817,13821,-1,13821,14249,13820,-1,13471,13470,14250,-1,14250,13821,13471,-1,14250,14251,14249,-1,14249,13821,14250,-1,13470,13453,14229,-1,14229,14250,13470,-1,14251,14248,14247,-1,14247,14249,14251,-1,14251,14250,14229,-1,14229,13718,14251,-1,13454,13847,14229,-1,14229,13453,13454,-1,13830,14252,13849,-1,13849,13831,13830,-1,14252,13846,13844,-1,13844,13849,14252,-1,14252,13830,13838,-1,13838,13839,14252,-1,14233,13846,14252,-1,14252,13839,14233,-1,14233,13848,13845,-1,13845,13846,14233,-1,14251,13718,14230,-1,14230,14248,14251,-1,13728,14246,14248,-1,14248,14230,13728,-1,14253,14254,14255,-1,14253,14255,14256,-1,14257,14258,14259,-1,14260,14261,14262,-1,14263,14264,14265,-1,14266,14267,14268,-1,14269,14270,14271,-1,14272,14273,14274,-1,14275,14276,14277,-1,14277,14276,14278,-1,14278,14276,14272,-1,14279,14280,14281,-1,14282,14280,14279,-1,14283,14284,14285,-1,14286,14287,14288,-1,14289,14290,14291,-1,14292,14293,14294,-1,14295,14296,14297,-1,14280,14282,14298,-1,14299,14300,14301,-1,14302,14303,14304,-1,14305,14306,14307,-1,14308,14307,14292,-1,14309,14310,14311,-1,14295,14309,14311,-1,14312,14313,14314,-1,14315,14316,14317,-1,14318,14319,14320,-1,14321,14322,14323,-1,14321,14324,14322,-1,14325,14326,14327,-1,14328,14329,14330,-1,14331,14332,14333,-1,14334,14335,14336,-1,14337,14338,14289,-1,14339,14340,14341,-1,14342,14343,14344,-1,14345,14344,14346,-1,14347,14348,14349,-1,14350,14351,14352,-1,14353,14348,14354,-1,14355,14356,14357,-1,14337,14346,14344,-1,14358,14310,14309,-1,14359,14360,14361,-1,14324,14362,14363,-1,14264,14364,14365,-1,14312,14269,14366,-1,14266,14312,14367,-1,14306,14292,14307,-1,14368,14369,14370,-1,14371,14372,14373,-1,707,14374,697,-1,14375,707,722,-1,339,796,14376,-1,821,14377,722,-1,337,14378,824,-1,14379,14380,14381,-1,14382,14383,14384,-1,14298,14385,14386,-1,14387,14388,14358,-1,14384,14389,14382,-1,14372,14390,14391,-1,14392,707,14375,-1,14393,14394,14395,-1,14396,821,825,-1,14397,14398,14399,-1,14399,14398,14400,-1,14401,14402,14403,-1,14404,14405,14406,-1,14407,14408,14409,-1,14410,14411,14412,-1,14413,14414,14415,-1,14416,14417,14418,-1,14397,14419,14420,-1,14421,14390,14422,-1,14423,14424,14285,-1,14425,14426,14427,-1,14428,14429,640,-1,640,14430,14428,-1,14431,14432,14433,-1,14434,14435,14436,-1,14437,14433,14436,-1,14438,672,673,-1,14439,14433,14437,-1,14439,14440,14441,-1,764,743,14429,-1,14442,259,14443,-1,14444,14445,14446,-1,14447,14448,14449,-1,14450,14432,14430,-1,14451,14433,14432,-1,14452,14436,14433,-1,653,660,659,-1,14453,662,672,-1,14454,14455,14435,-1,14434,14456,14457,-1,14458,14455,14459,-1,14460,14459,14461,-1,14462,14463,14464,-1,14465,14466,14467,-1,14468,14469,14470,-1,14471,14472,14473,-1,14474,14475,14476,-1,14477,14475,14474,-1,14478,14254,14253,-1,14253,14479,14478,-1,14255,14254,14480,-1,14480,14481,14255,-1,14482,14483,14484,-1,14484,14485,14482,-1,14482,14486,14487,-1,14487,14483,14482,-1,14488,14257,14259,-1,14259,14489,14488,-1,14489,14259,14490,-1,14490,14491,14489,-1,14481,14492,14260,-1,14260,14262,14481,-1,14480,14490,14492,-1,14492,14481,14480,-1,14490,14259,14260,-1,14260,14492,14490,-1,14255,14481,14262,-1,14262,14256,14255,-1,14491,14493,14494,-1,14494,14489,14491,-1,14261,14260,14259,-1,14259,14258,14261,-1,14493,14495,14287,-1,14287,14494,14493,-1,14495,14496,14288,-1,14288,14287,14495,-1,14479,14276,14485,-1,14485,14484,14479,-1,14497,14264,14263,-1,14263,14498,14497,-1,14499,14265,14264,-1,14264,14365,14499,-1,14500,14263,14265,-1,14265,14501,14500,-1,14502,14503,14504,-1,14504,14505,14502,-1,14501,14503,14502,-1,14502,14506,14501,-1,14507,14504,14503,-1,14503,14499,14507,-1,14505,14504,14508,-1,14508,14509,14505,-1,14510,14511,14512,-1,14512,14513,14510,-1,14511,14510,14514,-1,14514,14515,14511,-1,14516,14512,14511,-1,14511,14517,14516,-1,14518,14513,14512,-1,14512,14519,14518,-1,14267,14520,14356,-1,14356,14268,14267,-1,14521,14520,14267,-1,14267,14522,14521,-1,14357,14356,14520,-1,14520,14523,14357,-1,14268,14356,14355,-1,14355,14524,14268,-1,14525,14270,14269,-1,14269,14526,14525,-1,14271,14270,14527,-1,14527,14528,14271,-1,14366,14269,14271,-1,14271,14529,14366,-1,14270,14274,14273,-1,14273,14527,14270,-1,14530,14274,14270,-1,14270,14525,14530,-1,14258,14527,14273,-1,14273,14261,14258,-1,14275,14277,14531,-1,14531,14532,14275,-1,14531,14277,14533,-1,14533,14534,14531,-1,14535,14532,14531,-1,14531,14281,14535,-1,14536,14275,14532,-1,14532,14537,14536,-1,14535,14281,14280,-1,14280,14373,14535,-1,14534,14279,14281,-1,14281,14531,14534,-1,14278,14530,14538,-1,14538,14539,14278,-1,14530,14278,14272,-1,14272,14274,14530,-1,14538,14530,14525,-1,14525,14540,14538,-1,14541,14542,14539,-1,14539,14538,14541,-1,14533,14277,14278,-1,14278,14539,14533,-1,14526,14314,14543,-1,14543,14544,14526,-1,14269,14312,14314,-1,14314,14526,14269,-1,14314,14313,14545,-1,14545,14543,14314,-1,14543,14293,14546,-1,14546,14544,14543,-1,14540,14525,14526,-1,14526,14544,14540,-1,14479,14253,14272,-1,14272,14276,14479,-1,14485,14536,14547,-1,14547,14482,14485,-1,14276,14275,14536,-1,14536,14485,14276,-1,14537,14548,14547,-1,14547,14536,14537,-1,14482,14547,14549,-1,14549,14486,14482,-1,14550,14548,14537,-1,14537,14551,14550,-1,14547,14548,14552,-1,14552,14549,14547,-1,14553,14554,14550,-1,14550,14551,14553,-1,14553,14379,14555,-1,14555,14554,14553,-1,14550,14554,14284,-1,14284,14556,14550,-1,14373,14553,14551,-1,14551,14535,14373,-1,14373,14372,14379,-1,14379,14553,14373,-1,14555,14285,14284,-1,14284,14554,14555,-1,14486,14549,14557,-1,14557,14558,14486,-1,14550,14556,14552,-1,14552,14548,14550,-1,14549,14552,14559,-1,14559,14557,14549,-1,14556,14284,14325,-1,14325,14327,14556,-1,14284,14283,14560,-1,14560,14325,14284,-1,14257,14488,14561,-1,14561,14528,14257,-1,14359,14488,14489,-1,14489,14494,14359,-1,14361,14561,14488,-1,14488,14359,14361,-1,14529,14271,14528,-1,14528,14561,14529,-1,14527,14258,14257,-1,14257,14528,14527,-1,14287,14286,14359,-1,14359,14494,14287,-1,14496,14332,14331,-1,14331,14288,14496,-1,14360,14562,14563,-1,14563,14564,14360,-1,14286,14562,14360,-1,14360,14359,14286,-1,14562,14565,14566,-1,14566,14563,14562,-1,14567,14564,14563,-1,14563,14330,14567,-1,14361,14360,14564,-1,14564,14568,14361,-1,14366,14529,14568,-1,14568,14569,14366,-1,14561,14361,14568,-1,14568,14529,14561,-1,14568,14564,14567,-1,14567,14569,14568,-1,14367,14312,14366,-1,14366,14569,14367,-1,14520,14521,14570,-1,14570,14523,14520,-1,14267,14266,14367,-1,14367,14522,14267,-1,14521,14522,14329,-1,14329,14571,14521,-1,14290,14572,14573,-1,14573,14291,14290,-1,14355,14573,14572,-1,14572,14358,14355,-1,14353,14291,14573,-1,14573,14574,14353,-1,14542,14541,14303,-1,14303,14302,14542,-1,14533,14539,14542,-1,14542,14575,14533,-1,14576,14541,14538,-1,14538,14540,14576,-1,14305,14303,14541,-1,14541,14576,14305,-1,14546,14576,14540,-1,14540,14544,14546,-1,14306,14305,14576,-1,14576,14546,14306,-1,14545,14294,14293,-1,14293,14543,14545,-1,14296,14577,14294,-1,14294,14545,14296,-1,14545,14313,14297,-1,14297,14296,14545,-1,14524,14297,14313,-1,14313,14268,14524,-1,14295,14578,14577,-1,14577,14296,14295,-1,14309,14295,14297,-1,14297,14524,14309,-1,14385,14298,14282,-1,14282,14301,14385,-1,14373,14280,14298,-1,14298,14371,14373,-1,14299,14579,14580,-1,14580,14300,14299,-1,14581,14582,14301,-1,14301,14300,14581,-1,14301,14282,14279,-1,14279,14299,14301,-1,14533,14575,14579,-1,14579,14534,14533,-1,14579,14575,14583,-1,14583,14580,14579,-1,14534,14579,14299,-1,14299,14279,14534,-1,14300,14580,14304,-1,14304,14581,14300,-1,14542,14302,14583,-1,14583,14575,14542,-1,14304,14580,14583,-1,14583,14302,14304,-1,14293,14292,14306,-1,14306,14546,14293,-1,14577,14308,14292,-1,14292,14294,14577,-1,14578,14584,14308,-1,14308,14577,14578,-1,14584,14582,14581,-1,14581,14308,14584,-1,14307,14308,14581,-1,14581,14304,14307,-1,14303,14305,14307,-1,14307,14304,14303,-1,14524,14355,14358,-1,14358,14309,14524,-1,14268,14313,14312,-1,14312,14266,14268,-1,14273,14272,14253,-1,14253,14256,14273,-1,14585,14316,14586,-1,14586,14587,14585,-1,14317,14316,14585,-1,14585,14588,14317,-1,14589,14586,14316,-1,14316,14590,14589,-1,14591,14585,14587,-1,14587,14592,14591,-1,14315,14593,14590,-1,14590,14316,14315,-1,14593,14315,14594,-1,14594,14595,14593,-1,14321,14590,14593,-1,14593,14596,14321,-1,14370,14320,14595,-1,14595,14594,14370,-1,14370,14369,14597,-1,14597,14320,14370,-1,14598,14595,14320,-1,14320,14319,14598,-1,14370,14594,14599,-1,14599,14368,14370,-1,14600,14601,14597,-1,14597,14369,14600,-1,14601,14602,14603,-1,14603,14597,14601,-1,14604,14600,14369,-1,14369,14605,14604,-1,14606,14588,14585,-1,14585,14591,14606,-1,14607,14591,14592,-1,14592,14608,14607,-1,14609,14588,14606,-1,14606,14497,14609,-1,14606,14591,14607,-1,14607,14364,14606,-1,14498,14610,14609,-1,14609,14497,14498,-1,14605,14610,14498,-1,14498,14611,14605,-1,14610,14368,14599,-1,14599,14609,14610,-1,14612,14604,14605,-1,14605,14611,14612,-1,14613,14612,14611,-1,14611,14500,14613,-1,14602,14614,14615,-1,14615,14603,14602,-1,14320,14597,14603,-1,14603,14318,14320,-1,14593,14595,14598,-1,14598,14596,14593,-1,14616,14598,14319,-1,14319,14617,14616,-1,14323,14589,14590,-1,14590,14321,14323,-1,14324,14321,14596,-1,14596,14362,14324,-1,14560,14323,14322,-1,14322,14325,14560,-1,14618,14619,14620,-1,14620,14621,14618,-1,14622,14619,14618,-1,14618,14326,14622,-1,14623,14620,14619,-1,14619,14624,14623,-1,14625,14621,14620,-1,14620,14626,14625,-1,14559,14618,14621,-1,14621,14557,14559,-1,14325,14322,14622,-1,14622,14326,14325,-1,14363,14622,14322,-1,14322,14324,14363,-1,14507,14627,14508,-1,14508,14504,14507,-1,14509,14508,14515,-1,14515,14514,14509,-1,14628,14629,14627,-1,14627,14507,14628,-1,14630,14629,14628,-1,14628,14631,14630,-1,14339,14632,14627,-1,14627,14629,14339,-1,14365,14628,14507,-1,14507,14499,14365,-1,14633,14634,14630,-1,14630,14631,14633,-1,14634,14633,14635,-1,14635,14636,14634,-1,14340,14630,14634,-1,14634,14637,14340,-1,14607,14633,14631,-1,14631,14364,14607,-1,14500,14501,14506,-1,14506,14613,14500,-1,14628,14365,14364,-1,14364,14631,14628,-1,14608,14635,14633,-1,14633,14607,14608,-1,14630,14340,14339,-1,14339,14629,14630,-1,14636,14638,14637,-1,14637,14634,14636,-1,14340,14637,14639,-1,14639,14640,14340,-1,14556,14327,14559,-1,14559,14552,14556,-1,14291,14353,14337,-1,14337,14289,14291,-1,14352,14571,14329,-1,14329,14328,14352,-1,14571,14352,14351,-1,14351,14641,14571,-1,14350,14352,14328,-1,14328,14642,14350,-1,14288,14331,14643,-1,14643,14565,14288,-1,14626,14336,14335,-1,14335,14625,14626,-1,14644,14334,14336,-1,14336,14645,14644,-1,14621,14625,14558,-1,14558,14557,14621,-1,14486,14558,14646,-1,14646,14487,14486,-1,14620,14623,14647,-1,14647,14626,14620,-1,14353,14354,14346,-1,14346,14337,14353,-1,14339,14341,14517,-1,14517,14632,14339,-1,14517,14341,14648,-1,14648,14516,14517,-1,14511,14515,14632,-1,14632,14517,14511,-1,14565,14643,14649,-1,14649,14566,14565,-1,14643,14650,14651,-1,14651,14649,14643,-1,14328,14566,14649,-1,14649,14642,14328,-1,14627,14632,14515,-1,14515,14508,14627,-1,14638,14652,14639,-1,14639,14637,14638,-1,14343,14639,14652,-1,14652,14338,14343,-1,14648,14653,14654,-1,14654,14516,14648,-1,14342,14653,14648,-1,14648,14640,14342,-1,14655,14654,14653,-1,14653,14656,14655,-1,14516,14654,14519,-1,14519,14512,14516,-1,14657,14518,14519,-1,14519,14658,14657,-1,14639,14343,14342,-1,14342,14640,14639,-1,14337,14344,14343,-1,14343,14338,14337,-1,14659,14342,14344,-1,14344,14345,14659,-1,14654,14655,14658,-1,14658,14519,14654,-1,14332,14657,14658,-1,14658,14333,14332,-1,14656,14653,14342,-1,14342,14659,14656,-1,14650,14655,14656,-1,14656,14651,14650,-1,14660,14345,14346,-1,14346,14354,14660,-1,14345,14660,14661,-1,14661,14662,14345,-1,14660,14354,14348,-1,14348,14663,14660,-1,14347,14349,14523,-1,14523,14570,14347,-1,14523,14349,14574,-1,14574,14357,14523,-1,14664,14347,14570,-1,14570,14641,14664,-1,14345,14662,14665,-1,14665,14659,14345,-1,14350,14642,14665,-1,14665,14662,14350,-1,14656,14659,14665,-1,14665,14651,14656,-1,14643,14331,14333,-1,14333,14650,14643,-1,14642,14649,14651,-1,14651,14665,14642,-1,14340,14640,14648,-1,14648,14341,14340,-1,14351,14350,14662,-1,14662,14661,14351,-1,14641,14351,14661,-1,14661,14664,14641,-1,14348,14353,14574,-1,14574,14349,14348,-1,14357,14574,14573,-1,14573,14355,14357,-1,14330,14329,14522,-1,14522,14567,14330,-1,14570,14521,14571,-1,14571,14641,14570,-1,14661,14660,14663,-1,14663,14664,14661,-1,14261,14273,14256,-1,14256,14262,14261,-1,14288,14565,14562,-1,14562,14286,14288,-1,14330,14563,14566,-1,14566,14328,14330,-1,14647,14623,14617,-1,14617,14666,14647,-1,14617,14623,14624,-1,14624,14616,14617,-1,14617,14319,14318,-1,14318,14666,14617,-1,14645,14647,14666,-1,14666,14615,14645,-1,14362,14616,14624,-1,14624,14363,14362,-1,14644,14645,14615,-1,14615,14614,14644,-1,14569,14567,14522,-1,14522,14367,14569,-1,14532,14535,14551,-1,14551,14537,14532,-1,14326,14618,14559,-1,14559,14327,14326,-1,14619,14622,14363,-1,14363,14624,14619,-1,14596,14598,14616,-1,14616,14362,14596,-1,14594,14315,14317,-1,14317,14599,14594,-1,14599,14317,14588,-1,14588,14609,14599,-1,14497,14606,14364,-1,14364,14264,14497,-1,14335,14646,14558,-1,14558,14625,14335,-1,14263,14500,14611,-1,14611,14498,14263,-1,14369,14368,14610,-1,14610,14605,14369,-1,14501,14265,14499,-1,14499,14503,14501,-1,14318,14603,14615,-1,14615,14666,14318,-1,14645,14336,14626,-1,14626,14647,14645,-1,14658,14655,14650,-1,14650,14333,14658,-1,14347,14664,14663,-1,14663,14348,14347,-1,14301,14582,14389,-1,14389,14385,14301,-1,14667,14668,14669,-1,14669,14670,14667,-1,14380,14391,14670,-1,14670,14669,14380,-1,14671,14672,694,-1,694,206,14671,-1,676,14673,673,-1,673,671,676,-1,694,14672,14673,-1,14673,676,694,-1,14674,14671,206,-1,206,205,14674,-1,14374,14674,205,-1,205,697,14374,-1,722,14377,14675,-1,14675,14375,722,-1,14676,14677,14678,-1,14678,14679,14676,-1,14680,14681,14678,-1,14678,14677,14680,-1,14682,14683,14681,-1,14681,14680,14682,-1,14684,14685,14683,-1,14683,14682,14684,-1,14686,14687,795,-1,795,794,14686,-1,791,14688,14686,-1,14686,794,791,-1,776,14689,14688,-1,14688,791,776,-1,774,14690,14689,-1,14689,776,774,-1,773,14691,14690,-1,14690,774,773,-1,14684,14690,14691,-1,14691,14692,14684,-1,14682,14689,14690,-1,14690,14684,14682,-1,14680,14688,14689,-1,14689,14682,14680,-1,14677,14686,14688,-1,14688,14680,14677,-1,14677,14676,14687,-1,14687,14686,14677,-1,14693,14572,14290,-1,14290,14694,14693,-1,14695,14696,14693,-1,14693,14694,14695,-1,14387,14693,14696,-1,14696,14697,14387,-1,14698,14699,14695,-1,14695,14694,14698,-1,14700,14701,14702,-1,14702,14703,14700,-1,14702,14701,14419,-1,14419,14704,14702,-1,14419,14384,14383,-1,14383,14704,14419,-1,14295,14704,14383,-1,14383,14578,14295,-1,14295,14311,14702,-1,14702,14704,14295,-1,14383,14382,14584,-1,14584,14578,14383,-1,14384,14386,14385,-1,14385,14389,14384,-1,14371,14298,14386,-1,14386,14705,14371,-1,14382,14389,14582,-1,14582,14584,14382,-1,14311,14310,14703,-1,14703,14702,14311,-1,14388,14703,14310,-1,14310,14358,14388,-1,14706,14700,14703,-1,14703,14388,14706,-1,14338,14707,14698,-1,14698,14289,14338,-1,14694,14290,14289,-1,14289,14698,14694,-1,14358,14572,14693,-1,14693,14387,14358,-1,14697,14706,14388,-1,14388,14387,14697,-1,14705,14390,14372,-1,14372,14371,14705,-1,14372,14391,14380,-1,14380,14379,14372,-1,14699,14698,14707,-1,14707,14708,14699,-1,14671,14709,14710,-1,14710,14672,14671,-1,14709,14671,14674,-1,14674,14711,14709,-1,14712,14713,14714,-1,14714,14715,14712,-1,14672,14710,14716,-1,14716,14673,14672,-1,14716,14717,673,-1,673,14673,14716,-1,14718,14719,14720,-1,14720,14721,14718,-1,14722,14723,14724,-1,14724,14725,14722,-1,14721,14720,14713,-1,14713,14712,14721,-1,14715,14714,14726,-1,14726,14727,14715,-1,14374,14728,14711,-1,14711,14674,14374,-1,14727,14726,14729,-1,14729,14730,14727,-1,14731,14732,14733,-1,14733,14734,14731,-1,14730,14729,14735,-1,14735,14736,14730,-1,14733,14732,14737,-1,14737,14738,14733,-1,14739,14722,14725,-1,14725,14740,14739,-1,14741,14742,14743,-1,14743,14744,14741,-1,14745,14746,14393,-1,14393,14747,14745,-1,14748,14744,14743,-1,14743,14749,14748,-1,14738,14737,14750,-1,14750,14751,14738,-1,14752,14753,14754,-1,14754,14755,14752,-1,14740,14751,14750,-1,14750,14739,14740,-1,14756,14755,14754,-1,14754,14465,14756,-1,14728,14374,707,-1,707,14392,14728,-1,14757,14753,14752,-1,14752,14758,14757,-1,14759,14760,14761,-1,14761,14762,14759,-1,14763,14764,14417,-1,14417,14742,14763,-1,14765,14766,14767,-1,14767,14768,14765,-1,14769,14410,14764,-1,14764,14763,14769,-1,14770,14771,14772,-1,14772,14398,14770,-1,14770,14420,14773,-1,14773,14774,14770,-1,14415,14772,14412,-1,14412,14775,14415,-1,14420,14770,14398,-1,14398,14397,14420,-1,14395,14394,14776,-1,14776,14777,14395,-1,14778,14779,14762,-1,14762,14761,14778,-1,14780,14765,14768,-1,14768,14781,14780,-1,14758,14748,14749,-1,14749,14757,14758,-1,14675,14782,14736,-1,14736,14735,14675,-1,14783,14784,14785,-1,14785,14413,14783,-1,14414,14786,14422,-1,14422,14787,14414,-1,14413,14415,14775,-1,14775,14783,14413,-1,14782,14675,14377,-1,14377,14788,14782,-1,14777,14776,14789,-1,14789,14790,14777,-1,14774,14773,14767,-1,14767,14766,14774,-1,14788,14377,821,-1,821,14396,14788,-1,14791,14790,14792,-1,14792,14793,14791,-1,339,14376,14794,-1,14794,14795,339,-1,14795,14794,14796,-1,14796,14797,14795,-1,14798,14799,14800,-1,14800,14801,14798,-1,14798,14801,14802,-1,14802,14803,14798,-1,14803,14802,14679,-1,14679,14804,14803,-1,14805,14785,14784,-1,14784,14806,14805,-1,14422,14786,14807,-1,14807,14421,14422,-1,14806,14808,14809,-1,14809,14805,14806,-1,14787,14400,14398,-1,14398,14414,14787,-1,14810,14811,14812,-1,14812,14813,14810,-1,14814,14678,14681,-1,14681,14815,14814,-1,14668,14816,14817,-1,14817,14669,14668,-1,14810,14813,14809,-1,14809,14808,14810,-1,14670,14421,14807,-1,14807,14667,14670,-1,14804,14679,14678,-1,14678,14814,14804,-1,14760,14759,14818,-1,14818,14819,14760,-1,14819,14818,14780,-1,14780,14781,14819,-1,14820,14376,796,-1,796,795,14820,-1,14821,14794,14376,-1,14376,14820,14821,-1,14789,14822,14797,-1,14797,14796,14789,-1,14776,14823,14822,-1,14822,14789,14776,-1,14394,14824,14823,-1,14823,14776,14394,-1,14393,14406,14824,-1,14824,14394,14393,-1,14825,14826,14827,-1,14827,14828,14825,-1,14829,14830,14831,-1,14831,14832,14829,-1,14833,14834,14830,-1,14830,14829,14833,-1,14835,14784,14783,-1,14783,14836,14835,-1,14837,14838,14835,-1,14835,14839,14837,-1,14840,14841,14838,-1,14838,14837,14840,-1,14804,14814,14842,-1,14842,14843,14804,-1,14844,14803,14804,-1,14804,14843,14844,-1,14845,14798,14803,-1,14803,14844,14845,-1,14833,14799,14798,-1,14798,14845,14833,-1,14829,14846,14799,-1,14799,14833,14829,-1,14832,14847,14846,-1,14846,14829,14832,-1,14828,14409,14408,-1,14408,14825,14828,-1,14731,14734,14409,-1,14409,14828,14731,-1,14793,14792,14821,-1,14821,14848,14793,-1,14849,14850,14841,-1,14841,14840,14849,-1,14851,14852,14850,-1,14850,14849,14851,-1,14842,14814,14815,-1,14815,14853,14842,-1,14826,14825,14847,-1,14847,14832,14826,-1,14846,14854,14800,-1,14800,14799,14846,-1,14847,14855,14854,-1,14854,14846,14847,-1,14825,14408,14855,-1,14855,14847,14825,-1,14856,14857,14746,-1,14746,14745,14856,-1,14858,14859,14857,-1,14857,14856,14858,-1,14860,14861,14859,-1,14859,14858,14860,-1,14862,14863,14861,-1,14861,14860,14862,-1,14864,14865,14863,-1,14863,14862,14864,-1,14866,14867,14868,-1,14868,14865,14866,-1,14746,14404,14406,-1,14406,14393,14746,-1,14857,14869,14404,-1,14404,14746,14857,-1,14870,14871,14872,-1,14872,14869,14870,-1,14403,14402,14871,-1,14871,14870,14403,-1,14868,14873,14402,-1,14402,14401,14868,-1,14401,14863,14865,-1,14865,14868,14401,-1,14403,14861,14863,-1,14863,14401,14403,-1,14870,14859,14861,-1,14861,14403,14870,-1,14869,14857,14859,-1,14859,14870,14869,-1,14795,14378,337,-1,337,339,14795,-1,14797,14874,14378,-1,14378,14795,14797,-1,14822,14875,14874,-1,14874,14797,14822,-1,14823,14876,14875,-1,14875,14822,14823,-1,14824,14877,14876,-1,14876,14823,14824,-1,14406,14405,14877,-1,14877,14824,14406,-1,14869,14872,14405,-1,14405,14404,14869,-1,14716,14720,14719,-1,14719,14717,14716,-1,14710,14713,14720,-1,14720,14716,14710,-1,14709,14714,14713,-1,14713,14710,14709,-1,14711,14726,14714,-1,14714,14709,14711,-1,14728,14729,14726,-1,14726,14711,14728,-1,14392,14735,14729,-1,14729,14728,14392,-1,14375,14675,14735,-1,14735,14392,14375,-1,14878,14873,14879,-1,14879,14880,14878,-1,14881,14402,14873,-1,14873,14878,14881,-1,14882,14871,14402,-1,14402,14881,14882,-1,14883,14872,14871,-1,14871,14882,14883,-1,14884,14405,14872,-1,14872,14883,14884,-1,14885,14877,14405,-1,14405,14884,14885,-1,14886,14876,14877,-1,14877,14885,14886,-1,14887,14875,14876,-1,14876,14886,14887,-1,14888,14874,14875,-1,14875,14887,14888,-1,824,14378,14874,-1,14874,14888,824,-1,14888,14396,825,-1,825,824,14888,-1,14887,14788,14396,-1,14396,14888,14887,-1,14886,14782,14788,-1,14788,14887,14886,-1,14885,14736,14782,-1,14782,14886,14885,-1,14884,14730,14736,-1,14736,14885,14884,-1,14883,14727,14730,-1,14730,14884,14883,-1,14882,14715,14727,-1,14727,14883,14882,-1,14881,14712,14715,-1,14715,14882,14881,-1,14878,14721,14712,-1,14712,14881,14878,-1,14880,14718,14721,-1,14721,14878,14880,-1,14867,14879,14873,-1,14873,14868,14867,-1,14865,14864,14889,-1,14889,14866,14865,-1,14724,14889,14864,-1,14864,14725,14724,-1,14862,14740,14725,-1,14725,14864,14862,-1,14860,14751,14740,-1,14740,14862,14860,-1,14858,14738,14751,-1,14751,14860,14858,-1,14856,14733,14738,-1,14738,14858,14856,-1,14745,14734,14733,-1,14733,14856,14745,-1,14747,14409,14734,-1,14734,14745,14747,-1,14890,14855,14408,-1,14408,14407,14890,-1,14891,14854,14855,-1,14855,14890,14891,-1,14892,14800,14854,-1,14854,14891,14892,-1,14893,14801,14800,-1,14800,14892,14893,-1,14894,14802,14801,-1,14801,14893,14894,-1,14676,14679,14802,-1,14802,14894,14676,-1,14741,14731,14828,-1,14828,14827,14741,-1,14744,14732,14731,-1,14731,14741,14744,-1,14748,14737,14732,-1,14732,14744,14748,-1,14758,14750,14737,-1,14737,14748,14758,-1,14752,14739,14750,-1,14750,14758,14752,-1,14755,14722,14739,-1,14739,14752,14755,-1,14756,14723,14722,-1,14722,14755,14756,-1,14754,14895,14466,-1,14466,14465,14754,-1,14753,14896,14895,-1,14895,14754,14753,-1,14757,14897,14896,-1,14896,14753,14757,-1,14749,14898,14897,-1,14897,14757,14749,-1,14743,14416,14898,-1,14898,14749,14743,-1,14742,14417,14416,-1,14416,14743,14742,-1,14769,14826,14832,-1,14832,14831,14769,-1,14763,14827,14826,-1,14826,14769,14763,-1,14742,14741,14827,-1,14827,14763,14742,-1,14849,14842,14853,-1,14853,14851,14849,-1,14842,14849,14840,-1,14840,14843,14842,-1,14837,14844,14843,-1,14843,14840,14837,-1,14839,14845,14844,-1,14844,14837,14839,-1,14834,14833,14845,-1,14845,14839,14834,-1,14810,14850,14852,-1,14852,14811,14810,-1,14850,14810,14808,-1,14808,14841,14850,-1,14806,14838,14841,-1,14841,14808,14806,-1,14784,14835,14838,-1,14838,14806,14784,-1,14775,14899,14836,-1,14836,14783,14775,-1,14412,14411,14899,-1,14899,14775,14412,-1,14415,14414,14398,-1,14398,14772,14415,-1,14785,14786,14414,-1,14414,14413,14785,-1,14805,14807,14786,-1,14786,14785,14805,-1,14809,14667,14807,-1,14807,14805,14809,-1,14813,14668,14667,-1,14667,14809,14813,-1,14812,14816,14668,-1,14668,14813,14812,-1,14895,14762,14779,-1,14779,14466,14895,-1,14896,14759,14762,-1,14762,14895,14896,-1,14897,14818,14759,-1,14759,14896,14897,-1,14898,14780,14818,-1,14818,14897,14898,-1,14416,14765,14780,-1,14780,14898,14416,-1,14418,14766,14765,-1,14765,14416,14418,-1,14900,14774,14766,-1,14766,14418,14900,-1,14900,14771,14770,-1,14770,14774,14900,-1,14418,14417,14764,-1,14764,14900,14418,-1,14771,14410,14412,-1,14412,14772,14771,-1,14900,14764,14410,-1,14410,14771,14900,-1,14836,14834,14839,-1,14839,14835,14836,-1,14899,14830,14834,-1,14834,14836,14899,-1,14411,14831,14830,-1,14830,14899,14411,-1,14410,14769,14831,-1,14831,14411,14410,-1,14819,14696,14695,-1,14695,14760,14819,-1,14781,14697,14696,-1,14696,14819,14781,-1,14768,14706,14697,-1,14697,14781,14768,-1,14767,14700,14706,-1,14706,14768,14767,-1,14773,14701,14700,-1,14700,14767,14773,-1,14420,14419,14701,-1,14701,14773,14420,-1,14399,14384,14419,-1,14419,14397,14399,-1,14400,14386,14384,-1,14384,14399,14400,-1,14787,14705,14386,-1,14386,14400,14787,-1,14422,14390,14705,-1,14705,14787,14422,-1,14670,14391,14390,-1,14390,14421,14670,-1,14817,14381,14380,-1,14380,14669,14817,-1,14699,14761,14760,-1,14760,14695,14699,-1,14708,14778,14761,-1,14761,14699,14708,-1,14395,14901,14747,-1,14747,14393,14395,-1,14777,14902,14901,-1,14901,14395,14777,-1,14790,14791,14902,-1,14902,14777,14790,-1,14820,14903,14848,-1,14848,14821,14820,-1,795,14687,14903,-1,14903,14820,795,-1,14894,14903,14687,-1,14687,14676,14894,-1,14893,14848,14903,-1,14903,14894,14893,-1,14892,14793,14848,-1,14848,14893,14892,-1,14891,14791,14793,-1,14793,14892,14891,-1,14890,14902,14791,-1,14791,14891,14890,-1,14407,14901,14902,-1,14902,14890,14407,-1,14409,14747,14901,-1,14901,14407,14409,-1,14792,14796,14794,-1,14794,14821,14792,-1,14790,14789,14796,-1,14796,14792,14790,-1,14381,14473,14555,-1,14555,14379,14381,-1,14904,14905,14560,-1,14560,14283,14904,-1,14426,14587,14586,-1,14586,14906,14426,-1,14425,14592,14587,-1,14587,14426,14425,-1,14907,14906,14586,-1,14586,14589,14907,-1,14608,14592,14425,-1,14425,14908,14608,-1,14909,14907,14589,-1,14589,14323,14909,-1,14905,14909,14323,-1,14323,14560,14905,-1,14636,14635,14910,-1,14910,14911,14636,-1,14908,14910,14635,-1,14635,14608,14908,-1,14911,14912,14638,-1,14638,14636,14911,-1,14638,14912,14913,-1,14913,14652,14638,-1,14652,14913,14707,-1,14707,14338,14652,-1,14424,14904,14283,-1,14283,14285,14424,-1,14914,14908,14425,-1,14425,14915,14914,-1,14916,14910,14908,-1,14908,14914,14916,-1,14917,14911,14910,-1,14910,14916,14917,-1,14918,14912,14911,-1,14911,14917,14918,-1,14919,14913,14912,-1,14912,14918,14919,-1,14708,14707,14913,-1,14913,14919,14708,-1,14920,14907,14909,-1,14909,14921,14920,-1,14922,14906,14907,-1,14907,14920,14922,-1,14427,14426,14906,-1,14906,14922,14427,-1,14427,14923,14915,-1,14915,14425,14427,-1,14429,14428,14431,-1,14431,14924,14429,-1,640,14429,743,-1,743,641,640,-1,14925,14926,14927,-1,14927,14928,14925,-1,14436,14435,14929,-1,14929,14437,14436,-1,14930,14931,14926,-1,14926,14925,14930,-1,14932,14933,14440,-1,14440,14929,14932,-1,14933,14934,14935,-1,14935,14440,14933,-1,14936,14937,14938,-1,14938,14939,14936,-1,14934,14940,14941,-1,14941,14935,14934,-1,14441,14440,14935,-1,14935,14942,14441,-1,14943,14430,640,-1,640,639,14943,-1,14944,14450,14430,-1,14430,14943,14944,-1,654,14945,644,-1,644,643,654,-1,659,14946,654,-1,654,653,659,-1,14947,14948,14949,-1,14949,14946,14947,-1,14946,14949,14945,-1,14945,654,14946,-1,14950,14951,14952,-1,14952,14953,14950,-1,14953,14952,14450,-1,14450,14944,14953,-1,14947,14946,659,-1,659,14954,14947,-1,14955,14956,14948,-1,14948,14947,14955,-1,14955,14453,672,-1,672,14438,14955,-1,14957,14958,14959,-1,14959,14956,14957,-1,14717,14719,14958,-1,14958,14957,14717,-1,14960,14961,14456,-1,14456,14962,14960,-1,14719,14718,14963,-1,14963,14958,14719,-1,14457,14964,14965,-1,14965,14454,14457,-1,14454,14435,14434,-1,14434,14457,14454,-1,14930,14460,14966,-1,14966,14931,14930,-1,14967,14968,14969,-1,14969,14970,14967,-1,14867,14866,14965,-1,14965,14964,14867,-1,14724,14723,14971,-1,14971,14461,14724,-1,14972,14756,14465,-1,14465,14467,14972,-1,14460,14461,14971,-1,14971,14966,14460,-1,14430,14432,14431,-1,14431,14428,14430,-1,14942,14924,14431,-1,14431,14441,14942,-1,764,14429,14924,-1,14924,14973,764,-1,14439,14441,14431,-1,14431,14433,14439,-1,14974,14973,14924,-1,14924,14942,14974,-1,14928,14927,14937,-1,14937,14936,14928,-1,14975,14976,14977,-1,14977,14978,14975,-1,14939,14938,14979,-1,14979,14474,14939,-1,14980,14969,14968,-1,14968,14981,14980,-1,14437,14929,14440,-1,14440,14439,14437,-1,14446,14445,14982,-1,14982,14983,14446,-1,14984,14977,14976,-1,14976,14985,14984,-1,14981,14975,14978,-1,14978,14980,14981,-1,14986,14987,14448,-1,14448,14447,14986,-1,14988,14779,14778,-1,14778,14989,14988,-1,14990,14972,14467,-1,14467,14991,14990,-1,14448,14992,14993,-1,14993,14449,14448,-1,14970,14990,14991,-1,14991,14967,14970,-1,14986,14983,14982,-1,14982,14987,14986,-1,14989,14994,14995,-1,14995,14988,14989,-1,14942,14935,14941,-1,14941,14974,14942,-1,14993,14992,14995,-1,14995,14994,14993,-1,14947,14954,14453,-1,14453,14955,14947,-1,14996,14997,14998,-1,14998,14999,14996,-1,15000,15001,15002,-1,15002,15003,15000,-1,15004,14463,15005,-1,15005,15006,15004,-1,15007,15008,15009,-1,15009,15010,15007,-1,15011,15012,15013,-1,15013,15014,15011,-1,15015,14445,14444,-1,14444,15016,15015,-1,15015,15016,15009,-1,15009,15008,15015,-1,15017,14940,14474,-1,14474,14476,15017,-1,14463,15004,15018,-1,15018,14464,14463,-1,15019,15020,15021,-1,15021,15022,15019,-1,14472,14471,15023,-1,15023,15024,14472,-1,14815,14681,14683,-1,14683,15025,14815,-1,747,764,14973,-1,14973,748,747,-1,773,260,259,-1,259,14442,773,-1,14940,15017,756,-1,756,14941,14940,-1,15017,259,280,-1,280,756,15017,-1,14974,14941,756,-1,756,750,14974,-1,14443,259,15017,-1,15017,14476,14443,-1,14974,750,748,-1,748,14973,14974,-1,15005,15026,15027,-1,15027,15006,15005,-1,15028,15025,14683,-1,14683,14685,15028,-1,15029,15030,15031,-1,15031,15032,15029,-1,14468,14470,15033,-1,15033,15034,14468,-1,15026,15005,15035,-1,15035,15036,15026,-1,15037,15025,15028,-1,15028,15038,15037,-1,14853,14815,15025,-1,15025,15037,14853,-1,639,645,644,-1,644,14943,639,-1,14945,14944,14943,-1,14943,644,14945,-1,14949,14953,14944,-1,14944,14945,14949,-1,14948,14950,14953,-1,14953,14949,14948,-1,14956,14959,14950,-1,14950,14948,14956,-1,14957,14438,673,-1,673,14717,14957,-1,14956,14955,14438,-1,14438,14957,14956,-1,14954,661,662,-1,662,14453,14954,-1,659,658,661,-1,661,14954,659,-1,14880,14879,14961,-1,14961,14960,14880,-1,14960,14963,14718,-1,14718,14880,14960,-1,15039,14959,14958,-1,14958,14963,15039,-1,14951,14950,14959,-1,14959,15039,14951,-1,14962,15039,14963,-1,14963,14960,14962,-1,15040,14951,15039,-1,15039,14962,15040,-1,14451,14952,14951,-1,14951,15040,14451,-1,14432,14450,14952,-1,14952,14451,14432,-1,14452,15040,14962,-1,14962,14456,14452,-1,14433,14451,15040,-1,15040,14452,14433,-1,14964,14961,14879,-1,14879,14867,14964,-1,14457,14456,14961,-1,14961,14964,14457,-1,14965,15041,14455,-1,14455,14454,14965,-1,14866,14889,15041,-1,15041,14965,14866,-1,14436,14452,14456,-1,14456,14434,14436,-1,14461,15041,14889,-1,14889,14724,14461,-1,14459,14455,15041,-1,15041,14461,14459,-1,15042,14435,14455,-1,14455,14458,15042,-1,14932,14929,14435,-1,14435,15042,14932,-1,15043,15006,15027,-1,15027,14692,15043,-1,15044,15004,15006,-1,15006,15043,15044,-1,14930,14458,14459,-1,14459,14460,14930,-1,14925,15042,14458,-1,14458,14930,14925,-1,14928,14932,15042,-1,15042,14925,14928,-1,14936,14933,14932,-1,14932,14928,14936,-1,14939,14934,14933,-1,14933,14936,14939,-1,14474,14940,14934,-1,14934,14939,14474,-1,15018,14477,14474,-1,14474,14979,15018,-1,15004,15044,14477,-1,14477,15018,15004,-1,15035,15005,14463,-1,14463,14462,15035,-1,14972,14971,14723,-1,14723,14756,14972,-1,14990,14966,14971,-1,14971,14972,14990,-1,14970,14931,14966,-1,14966,14990,14970,-1,14969,14926,14931,-1,14931,14970,14969,-1,14980,14927,14926,-1,14926,14969,14980,-1,14978,14937,14927,-1,14927,14980,14978,-1,14977,14938,14937,-1,14937,14978,14977,-1,14984,14979,14938,-1,14938,14977,14984,-1,14464,15018,14979,-1,14979,14984,14464,-1,14976,14445,15015,-1,15015,14985,14976,-1,14975,14982,14445,-1,14445,14976,14975,-1,14981,14987,14982,-1,14982,14975,14981,-1,14968,14448,14987,-1,14987,14981,14968,-1,14967,14992,14448,-1,14448,14968,14967,-1,14991,14995,14992,-1,14992,14967,14991,-1,14467,14988,14995,-1,14995,14991,14467,-1,15045,14464,14984,-1,14984,14985,15045,-1,14469,14462,14464,-1,14464,15045,14469,-1,14468,15035,14462,-1,14462,14469,14468,-1,15034,15036,15035,-1,15035,14468,15034,-1,15029,15037,15038,-1,15038,15030,15029,-1,14851,14853,15037,-1,15037,15029,14851,-1,15014,15020,15019,-1,15019,15011,15014,-1,14997,15007,15010,-1,15010,14998,14997,-1,15008,15045,14985,-1,14985,15015,15008,-1,15007,14469,15045,-1,15045,15008,15007,-1,14997,14470,14469,-1,14469,15007,14997,-1,14996,15033,14470,-1,14470,14997,14996,-1,15003,15032,15031,-1,15031,15000,15003,-1,15002,15001,15024,-1,15024,15023,15002,-1,14999,14998,15014,-1,15014,15013,14999,-1,15010,15020,15014,-1,15014,14998,15010,-1,15009,15021,15020,-1,15020,15010,15009,-1,14466,14779,14988,-1,14988,14467,14466,-1,15016,15046,15021,-1,15021,15009,15016,-1,14444,15047,15046,-1,15046,15016,14444,-1,14446,15048,15047,-1,15047,14444,14446,-1,14983,14923,15048,-1,15048,14446,14983,-1,14986,14915,14923,-1,14923,14983,14986,-1,15012,15011,14424,-1,14424,14423,15012,-1,15019,14904,14424,-1,14424,15011,15019,-1,15022,14905,14904,-1,14904,15019,15022,-1,14921,14909,14905,-1,14905,15022,14921,-1,14922,15048,14923,-1,14923,14427,14922,-1,14920,15047,15048,-1,15048,14922,14920,-1,14921,15046,15047,-1,15047,14920,14921,-1,15022,15021,15046,-1,15046,14921,15022,-1,14919,14989,14778,-1,14778,14708,14919,-1,14918,14994,14989,-1,14989,14919,14918,-1,14917,14993,14994,-1,14994,14918,14917,-1,14916,14449,14993,-1,14993,14917,14916,-1,14914,14447,14449,-1,14449,14916,14914,-1,14915,14986,14447,-1,14447,14914,14915,-1,14442,15049,14691,-1,14691,773,14442,-1,14443,15050,15049,-1,15049,14442,14443,-1,14476,14475,15050,-1,15050,14443,14476,-1,15044,15050,14475,-1,14475,14477,15044,-1,15043,15049,15050,-1,15050,15044,15043,-1,14692,14691,15049,-1,15049,15043,14692,-1,15032,14852,14851,-1,14851,15029,15032,-1,15003,14811,14852,-1,14852,15032,15003,-1,15002,14812,14811,-1,14811,15003,15002,-1,15023,14816,14812,-1,14812,15002,15023,-1,14471,14817,14816,-1,14816,15023,14471,-1,14473,14381,14817,-1,14817,14471,14473,-1,15027,14685,14684,-1,14684,14692,15027,-1,15026,15028,14685,-1,14685,15027,15026,-1,15036,15038,15028,-1,15028,15026,15036,-1,15034,15030,15038,-1,15038,15036,15034,-1,15033,15031,15030,-1,15030,15034,15033,-1,14996,15000,15031,-1,15031,15033,14996,-1,14999,15001,15000,-1,15000,14996,14999,-1,15013,15024,15001,-1,15001,14999,15013,-1,15012,14472,15024,-1,15024,15013,15012,-1,14423,14473,14472,-1,14472,15012,14423,-1,14285,14555,14473,-1,14473,14423,14285,-1,15051,15052,15053,-1,15054,15055,15056,-1,15057,15058,15059,-1,15060,15061,15062,-1,15063,15064,15065,-1,15066,15067,15068,-1,15069,15070,15071,-1,15072,15073,15074,-1,15072,15075,15073,-1,15076,15077,15078,-1,15079,15080,15081,-1,15082,15066,15081,-1,15067,15083,15068,-1,15084,15085,15086,-1,15087,15086,15088,-1,15086,15085,15088,-1,15089,15090,15091,-1,15092,15093,15094,-1,15067,15066,15082,-1,15095,15096,15097,-1,15098,15099,15100,-1,15101,15099,15098,-1,15102,15103,15104,-1,15105,15106,14509,-1,15107,15108,15109,-1,15110,15111,15112,-1,15113,15114,15115,-1,15116,15117,15118,-1,15119,15120,15121,-1,15096,15095,15121,-1,15122,14254,14478,-1,15123,15124,15125,-1,15126,15124,15120,-1,15127,15128,15129,-1,15130,15131,15132,-1,15133,15134,15135,-1,15136,15137,15138,-1,15139,15140,15137,-1,15141,15142,15143,-1,15135,15134,15144,-1,15135,15144,15145,-1,15146,15147,14491,-1,14493,14491,15148,-1,15148,14491,15147,-1,15112,15147,15110,-1,15148,15147,15112,-1,15149,15150,14495,-1,14496,14495,15151,-1,15151,14495,15150,-1,15109,15108,15150,-1,15152,15153,15154,-1,15155,15156,15157,-1,15156,15158,15159,-1,15103,15160,15161,-1,15162,15163,15164,-1,15165,15166,15167,-1,15168,15163,15169,-1,15170,15171,15172,-1,15151,14332,14496,-1,14518,15173,14513,-1,15174,15175,15176,-1,15123,15177,14334,-1,14614,15178,15179,-1,15180,15064,15063,-1,15181,15182,15183,-1,15183,15184,15181,-1,15059,15182,15181,-1,15181,15057,15059,-1,15182,15185,15186,-1,15186,15183,15182,-1,15183,15118,15117,-1,15117,15184,15183,-1,15187,15181,15184,-1,15184,15188,15187,-1,15189,15052,15051,-1,15051,15190,15189,-1,15191,15141,15053,-1,15053,15052,15191,-1,15051,15053,15192,-1,15192,15193,15051,-1,15194,15191,15052,-1,15052,15189,15194,-1,15190,15051,15193,-1,15193,15195,15190,-1,15185,15189,15190,-1,15190,15186,15185,-1,15196,15194,15189,-1,15189,15185,15196,-1,15186,15190,15195,-1,15195,15197,15186,-1,15059,15196,15185,-1,15185,15182,15059,-1,15183,15186,15197,-1,15197,15118,15183,-1,15198,15187,15188,-1,15188,15199,15198,-1,15187,15198,15200,-1,15200,15054,15187,-1,15201,15202,15199,-1,15199,15188,15201,-1,15203,15198,15199,-1,15199,15204,15203,-1,15069,15055,15054,-1,15054,15200,15069,-1,15055,15069,15205,-1,15205,15206,15055,-1,15207,15070,15069,-1,15069,15200,15207,-1,15056,15058,15057,-1,15057,15054,15056,-1,15058,15208,15209,-1,15209,15059,15058,-1,15056,15210,15208,-1,15208,15058,15056,-1,15057,15181,15187,-1,15187,15054,15057,-1,15184,15117,15201,-1,15201,15188,15184,-1,15210,15056,15055,-1,15055,15206,15210,-1,15209,15208,15211,-1,15211,15212,15209,-1,15210,15213,15211,-1,15211,15208,15210,-1,15214,15212,15211,-1,15211,15215,15214,-1,15060,15209,15212,-1,15212,15061,15060,-1,15216,15062,15061,-1,15061,15217,15216,-1,15060,15062,15194,-1,15194,15196,15060,-1,15209,15060,15196,-1,15196,15059,15209,-1,15217,15061,15212,-1,15212,15214,15217,-1,15218,15219,15220,-1,15220,15221,15218,-1,15222,15219,15218,-1,15218,15223,15222,-1,15219,15224,15225,-1,15225,15220,15219,-1,15226,15221,15220,-1,15220,15113,15226,-1,15221,15227,15228,-1,15228,15218,15221,-1,15229,15230,15231,-1,15231,15065,15229,-1,15232,15230,15229,-1,15229,15233,15232,-1,15230,15158,15234,-1,15234,15231,15230,-1,15235,15065,15231,-1,15231,15236,15235,-1,15237,15229,15065,-1,15065,15064,15237,-1,15233,15229,15237,-1,15237,15238,15233,-1,15239,15237,15064,-1,15064,15180,15239,-1,15224,15239,15180,-1,15180,15225,15224,-1,15240,15239,15224,-1,15224,15241,15240,-1,15114,15225,15180,-1,15180,15242,15114,-1,15241,15224,15219,-1,15219,15222,15241,-1,15113,15220,15225,-1,15225,15114,15113,-1,15243,15066,15068,-1,15068,15244,15243,-1,15081,15066,15243,-1,15243,15079,15081,-1,15068,15083,15073,-1,15073,15244,15068,-1,15243,15244,15245,-1,15245,15246,15243,-1,15247,15248,15205,-1,15205,15249,15247,-1,15248,15247,15091,-1,15091,15090,15248,-1,15248,15250,15206,-1,15206,15205,15248,-1,15069,15071,15249,-1,15249,15205,15069,-1,15198,15203,15207,-1,15207,15200,15198,-1,15204,15199,15202,-1,15202,15251,15204,-1,15083,15252,15074,-1,15074,15073,15083,-1,15087,15072,15074,-1,15074,15086,15087,-1,15075,15245,15244,-1,15244,15073,15075,-1,15246,15253,15079,-1,15079,15243,15246,-1,15080,15079,15253,-1,15253,15254,15080,-1,15254,15255,15076,-1,15076,15080,15254,-1,15256,15077,15076,-1,15076,15255,15256,-1,15078,15081,15080,-1,15080,15076,15078,-1,15257,15077,15256,-1,15256,15258,15257,-1,15259,15078,15077,-1,15077,15257,15259,-1,15082,15081,15078,-1,15078,15260,15082,-1,15261,15252,15083,-1,15083,15067,15261,-1,15252,15262,15086,-1,15086,15074,15252,-1,15262,15252,15261,-1,15261,15263,15262,-1,15084,15086,15262,-1,15262,15264,15084,-1,15265,15085,15084,-1,15084,15266,15265,-1,15267,15266,15084,-1,15084,15264,15267,-1,15090,15089,15266,-1,15266,15267,15090,-1,15267,15264,15268,-1,15268,15269,15267,-1,15089,15270,15265,-1,15265,15266,15089,-1,15269,15271,15090,-1,15090,15267,15269,-1,15250,15248,15090,-1,15090,15271,15250,-1,15272,15251,15202,-1,15202,15273,15272,-1,15092,15094,15274,-1,15274,15275,15092,-1,15274,15094,15276,-1,15276,15277,15274,-1,15278,15279,15275,-1,15275,15274,15278,-1,15094,15093,15280,-1,15280,15276,15094,-1,15132,15277,15276,-1,15276,15128,15132,-1,15274,15277,15281,-1,15281,15278,15274,-1,15093,15272,15273,-1,15273,15280,15093,-1,15280,15129,15128,-1,15128,15276,15280,-1,15129,15280,15273,-1,15273,15282,15129,-1,15202,15201,15282,-1,15282,15273,15202,-1,15283,15284,15285,-1,15285,15286,15283,-1,15283,15287,15288,-1,15288,15284,15283,-1,15287,15283,15289,-1,15289,15290,15287,-1,15291,15228,15288,-1,15288,15287,15291,-1,15288,15259,15257,-1,15257,15284,15288,-1,15289,15283,15286,-1,15286,15292,15289,-1,15293,15294,15289,-1,15289,15292,15293,-1,15295,15290,15289,-1,15289,15294,15295,-1,15291,15287,15290,-1,15290,15296,15291,-1,15284,15257,15258,-1,15258,15285,15284,-1,15279,15278,15294,-1,15294,15293,15279,-1,15281,15295,15294,-1,15294,15278,15281,-1,15281,15131,15297,-1,15297,15295,15281,-1,15296,15290,15295,-1,15295,15297,15296,-1,15131,15281,15277,-1,15277,15132,15131,-1,15227,15259,15288,-1,15288,15228,15227,-1,15078,15259,15227,-1,15227,15260,15078,-1,15131,15130,15298,-1,15298,15297,15131,-1,15296,15299,15223,-1,15223,15291,15296,-1,15298,15299,15296,-1,15296,15297,15298,-1,15300,15301,15261,-1,15261,15067,15300,-1,15263,15268,15264,-1,15264,15262,15263,-1,15302,15303,15268,-1,15268,15263,15302,-1,15067,15082,15304,-1,15304,15300,15067,-1,15260,15227,15221,-1,15221,15226,15260,-1,15223,15218,15228,-1,15228,15291,15223,-1,15128,15127,15130,-1,15130,15132,15128,-1,15201,15117,15305,-1,15305,15282,15201,-1,15099,15306,15097,-1,15097,15096,15099,-1,15306,15099,15101,-1,15101,15307,15306,-1,15308,15097,15306,-1,15306,15309,15308,-1,15310,15100,15099,-1,15099,15096,15310,-1,15175,15100,15310,-1,15310,15311,15175,-1,15098,15100,15175,-1,15175,15174,15098,-1,15120,15124,15311,-1,15311,15310,15120,-1,15175,15311,15312,-1,15312,15179,15175,-1,15121,15120,15310,-1,15310,15096,15121,-1,15193,15192,15097,-1,15097,15308,15193,-1,15309,15306,15307,-1,15307,15313,15309,-1,15314,15308,15309,-1,15309,15315,15314,-1,15101,15316,15317,-1,15317,15307,15101,-1,15318,15160,15103,-1,15103,15102,15318,-1,15165,15104,15103,-1,15103,15319,15165,-1,15320,15102,15104,-1,15104,15321,15320,-1,15105,15322,15323,-1,15323,15106,15105,-1,15322,15105,15324,-1,15324,15325,15322,-1,15322,15326,15327,-1,15327,15323,15322,-1,15328,15329,15106,-1,15106,15323,15328,-1,15330,15318,15102,-1,15102,15320,15330,-1,15331,15321,15104,-1,15104,15165,15331,-1,15332,15320,15321,-1,15321,15333,15332,-1,15334,15327,15326,-1,15326,15335,15334,-1,15336,15327,15334,-1,15334,15164,15336,-1,15335,15326,15337,-1,15337,15338,15335,-1,15335,15332,15333,-1,15333,15334,15335,-1,15338,15339,15332,-1,15332,15335,15338,-1,15164,15334,15333,-1,15333,15162,15164,-1,15320,15332,15339,-1,15339,15330,15320,-1,15162,15333,15321,-1,15321,15331,15162,-1,15110,15107,15109,-1,15109,15111,15110,-1,15110,15340,15341,-1,15341,15107,15110,-1,15111,15109,15150,-1,15150,15149,15111,-1,15342,15115,15114,-1,15114,15343,15342,-1,15115,15304,15226,-1,15226,15113,15115,-1,15299,15344,15222,-1,15222,15223,15299,-1,15345,15344,15299,-1,15299,15298,15345,-1,15241,15222,15344,-1,15344,15346,15241,-1,15300,15304,15115,-1,15115,15342,15300,-1,15304,15082,15260,-1,15260,15226,15304,-1,15206,15250,15213,-1,15213,15210,15206,-1,15345,15347,15348,-1,15348,15349,15345,-1,15298,15130,15347,-1,15347,15345,15298,-1,15350,15351,15348,-1,15348,15347,15350,-1,15348,15170,15172,-1,15172,15349,15348,-1,15349,15346,15344,-1,15344,15345,15349,-1,15095,15097,15192,-1,15192,15134,15095,-1,15192,15053,15144,-1,15144,15134,15192,-1,15133,15352,15095,-1,15095,15134,15133,-1,15116,15353,15305,-1,15305,15117,15116,-1,15118,15197,15354,-1,15354,15116,15118,-1,15197,15195,15314,-1,15314,15354,15197,-1,15116,15354,15355,-1,15355,15353,15116,-1,15195,15193,15308,-1,15308,15314,15195,-1,15354,15314,15315,-1,15315,15355,15354,-1,15356,15357,15329,-1,15329,15328,15356,-1,15358,15357,15356,-1,15356,15359,15358,-1,14505,15329,15357,-1,15357,14502,14505,-1,15336,15168,15356,-1,15356,15328,15336,-1,15360,15361,15173,-1,15173,15362,15360,-1,15361,15360,15325,-1,15325,15324,15361,-1,14513,15173,15361,-1,15361,14510,14513,-1,15363,15362,15173,-1,15173,15364,15363,-1,15365,15360,15362,-1,15362,15366,15365,-1,15352,15119,15121,-1,15121,15095,15352,-1,15352,15367,15368,-1,15368,15119,15352,-1,15367,15369,15370,-1,15370,15122,15367,-1,15367,15352,15133,-1,15133,15369,15367,-1,15369,15371,15372,-1,15372,15370,15369,-1,15370,14480,14254,-1,14254,15122,15370,-1,15368,15367,15122,-1,15122,15373,15368,-1,15374,14478,14479,-1,14479,14484,15374,-1,15101,15098,15174,-1,15174,15316,15101,-1,15126,15120,15119,-1,15119,15368,15126,-1,15373,15375,15126,-1,15126,15368,15373,-1,15376,15375,15373,-1,15373,15374,15376,-1,15125,15124,15126,-1,15126,15375,15125,-1,14484,14483,15376,-1,15376,15374,14484,-1,15376,14483,14487,-1,14487,15377,15376,-1,15378,15379,15317,-1,15317,15316,15378,-1,15313,15307,15317,-1,15317,15380,15313,-1,15376,15377,15125,-1,15125,15375,15376,-1,15377,14487,14646,-1,14646,15177,15377,-1,15350,15347,15130,-1,15130,15127,15350,-1,15353,15350,15127,-1,15127,15305,15353,-1,15282,15305,15127,-1,15127,15129,15282,-1,15353,15355,15351,-1,15351,15350,15353,-1,14480,15370,15372,-1,15372,14490,14480,-1,15369,15133,15135,-1,15135,15371,15369,-1,15146,15372,15371,-1,15371,15381,15146,-1,15137,15136,15341,-1,15341,15142,15137,-1,15107,15341,15136,-1,15136,15108,15107,-1,15340,15143,15142,-1,15142,15341,15340,-1,15141,15139,15137,-1,15137,15142,15141,-1,15382,15139,15141,-1,15141,15191,15382,-1,15143,15144,15053,-1,15053,15141,15143,-1,15143,15340,15145,-1,15145,15144,15143,-1,14493,15148,15149,-1,15149,14495,14493,-1,15381,15110,15147,-1,15147,15146,15381,-1,15381,15145,15340,-1,15340,15110,15381,-1,14600,15383,15384,-1,15384,14601,14600,-1,15385,15155,15384,-1,15384,15383,15385,-1,15385,15386,15156,-1,15156,15155,15385,-1,15155,15387,15388,-1,15388,15384,15155,-1,15389,15385,15383,-1,15383,15390,15389,-1,15386,15391,15392,-1,15392,15234,15386,-1,15386,15385,15389,-1,15389,15391,15386,-1,15152,15392,15391,-1,15391,15153,15152,-1,15236,15231,15234,-1,15234,15392,15236,-1,15386,15234,15158,-1,15158,15156,15386,-1,15393,15236,15392,-1,15392,15152,15393,-1,15394,15063,15065,-1,15065,15235,15394,-1,15395,15235,15236,-1,15236,15393,15395,-1,15180,15063,15394,-1,15394,15242,15180,-1,15167,15394,15235,-1,15235,15395,15167,-1,15343,15114,15242,-1,15242,15166,15343,-1,15390,14604,14612,-1,14612,15396,15390,-1,15397,15389,15390,-1,15390,15396,15397,-1,15391,15389,15397,-1,15397,15153,15391,-1,15398,15397,15396,-1,15396,15399,15398,-1,15152,15163,15162,-1,15162,15393,15152,-1,15393,15162,15331,-1,15331,15395,15393,-1,15242,15394,15167,-1,15167,15166,15242,-1,15395,15331,15165,-1,15165,15167,15395,-1,15166,15165,15319,-1,15319,15343,15166,-1,15343,15319,15400,-1,15400,15342,15343,-1,15342,15400,15301,-1,15301,15300,15342,-1,15401,15240,15241,-1,15241,15346,15401,-1,15238,15240,15401,-1,15401,15402,15238,-1,15401,15346,15349,-1,15349,15172,15401,-1,15403,15233,15238,-1,15238,15402,15403,-1,15404,15232,15233,-1,15233,15403,15404,-1,15405,15403,15402,-1,15402,15171,15405,-1,15406,15159,15232,-1,15232,15404,15406,-1,15379,15404,15403,-1,15403,15405,15379,-1,15157,15156,15159,-1,15159,15406,15157,-1,15159,15158,15230,-1,15230,15232,15159,-1,15378,15406,15404,-1,15404,15379,15378,-1,15407,15157,15406,-1,15406,15378,15407,-1,15157,15407,15387,-1,15387,15155,15157,-1,15178,15388,15387,-1,15387,15176,15178,-1,15384,15388,14602,-1,14602,14601,15384,-1,15172,15171,15402,-1,15402,15401,15172,-1,15171,15170,15380,-1,15380,15405,15171,-1,15380,15317,15379,-1,15379,15405,15380,-1,15316,15174,15407,-1,15407,15378,15316,-1,15123,15312,15311,-1,15311,15124,15123,-1,14614,15179,15312,-1,15312,14644,14614,-1,15176,15175,15179,-1,15179,15178,15176,-1,15408,15409,15303,-1,15303,15302,15408,-1,15303,15410,15269,-1,15269,15268,15303,-1,15263,15261,15301,-1,15301,15302,15263,-1,15103,15161,15409,-1,15409,15408,15103,-1,15409,15411,15410,-1,15410,15303,15409,-1,15302,15301,15400,-1,15400,15408,15302,-1,15161,15412,15411,-1,15411,15409,15161,-1,15408,15400,15319,-1,15319,15103,15408,-1,15323,15327,15336,-1,15336,15328,15323,-1,15164,15163,15168,-1,15168,15336,15164,-1,14505,14509,15106,-1,15106,15329,14505,-1,15154,15169,15163,-1,15163,15152,15154,-1,15359,15169,15154,-1,15154,15398,15359,-1,15399,15358,15359,-1,15359,15398,15399,-1,14506,15358,15399,-1,15399,14613,14506,-1,15271,15413,15213,-1,15213,15250,15271,-1,15215,15211,15213,-1,15213,15413,15215,-1,15411,15215,15413,-1,15413,15410,15411,-1,15412,15214,15215,-1,15215,15411,15412,-1,15414,15217,15214,-1,15214,15412,15414,-1,15415,15382,15062,-1,15062,15216,15415,-1,15416,15216,15217,-1,15217,15414,15416,-1,15417,15139,15382,-1,15382,15415,15417,-1,15062,15382,15191,-1,15191,15194,15062,-1,15418,15415,15216,-1,15216,15416,15418,-1,15417,15419,15140,-1,15140,15139,15417,-1,15420,15417,15415,-1,15415,15418,15420,-1,15410,15413,15271,-1,15271,15269,15410,-1,15160,15414,15412,-1,15412,15161,15160,-1,15318,15416,15414,-1,15414,15160,15318,-1,15330,15418,15416,-1,15416,15318,15330,-1,15339,15420,15418,-1,15418,15330,15339,-1,15338,15421,15420,-1,15420,15339,15338,-1,15365,15421,15338,-1,15338,15337,15365,-1,15421,15419,15417,-1,15417,15420,15421,-1,15325,15360,15365,-1,15365,15337,15325,-1,15361,15324,14514,-1,14514,14510,15361,-1,15422,15313,15380,-1,15380,15170,15422,-1,15315,15309,15313,-1,15313,15422,15315,-1,15351,15422,15170,-1,15170,15348,15351,-1,15355,15315,15422,-1,15422,15351,15355,-1,15362,15363,15423,-1,15423,15366,15362,-1,15364,15173,14518,-1,14518,14657,15364,-1,15424,15363,15364,-1,15364,15151,15424,-1,15324,15105,14509,-1,14509,14514,15324,-1,15326,15322,15325,-1,15325,15337,15326,-1,15419,15366,15423,-1,15423,15140,15419,-1,15365,15366,15419,-1,15419,15421,15365,-1,15138,15137,15140,-1,15140,15423,15138,-1,14646,14335,14334,-1,14334,15177,14646,-1,15377,15177,15123,-1,15123,15125,15377,-1,15407,15174,15176,-1,15176,15387,15407,-1,15178,14614,14602,-1,14602,15388,15178,-1,15423,15363,15424,-1,15424,15138,15423,-1,15364,14657,14332,-1,14332,15151,15364,-1,15108,15424,15151,-1,15151,15150,15108,-1,15111,15149,15148,-1,15148,15112,15111,-1,15371,15135,15145,-1,15145,15381,15371,-1,15108,15136,15138,-1,15138,15424,15108,-1,15153,15397,15398,-1,15398,15154,15153,-1,15356,15168,15169,-1,15169,15359,15356,-1,15357,15358,14506,-1,14506,14502,15357,-1,15122,14478,15374,-1,15374,15373,15122,-1,14490,15372,15146,-1,15146,14491,14490,-1,15383,14600,14604,-1,14604,15390,15383,-1,15396,14612,14613,-1,14613,15399,15396,-1,15312,15123,14334,-1,14334,14644,15312,-1,15238,15237,15239,-1,15239,15240,15238,-1,15425,15426,15427,-1,15425,15427,15428,-1,15204,15429,15430,-1,15270,15427,15431,-1,15432,15428,15433,-1,15434,15435,15436,-1,15279,15437,15275,-1,15093,15435,15272,-1,15293,15437,15279,-1,15438,15075,15072,-1,15439,15440,15441,-1,15442,15443,15444,-1,15439,15441,15445,-1,15446,15447,15448,-1,15449,15446,15448,-1,15450,15451,15452,-1,15453,15454,15455,-1,15456,15457,15458,-1,15459,15458,15460,-1,15461,15462,15463,-1,15462,15461,15464,-1,15465,15466,15467,-1,15468,15465,15469,-1,15470,15471,15472,-1,15473,15463,15474,-1,15453,15475,15476,-1,15477,15478,15479,-1,15480,15481,15482,-1,15483,15484,15485,-1,15486,15487,15488,-1,15489,15490,15491,-1,15492,15472,15493,-1,15487,15489,15491,-1,15480,15494,15481,-1,15495,15471,15470,-1,15459,15453,15496,-1,15497,15477,15498,-1,15499,15500,15501,-1,15502,15503,15504,-1,15505,15506,15507,-1,15508,15506,15509,-1,15510,15511,15512,-1,15513,15514,15515,-1,15516,15517,15504,-1,15518,15519,15520,-1,15521,15476,15522,-1,15523,15524,15521,-1,15525,15526,15527,-1,15528,15525,15529,-1,15530,15531,15532,-1,15533,15534,15535,-1,15536,15537,15538,-1,15539,15540,15541,-1,15542,15543,15544,-1,15545,15546,15547,-1,15548,15549,15550,-1,15426,15551,15552,-1,15552,15427,15426,-1,15429,15204,15251,-1,15251,15553,15429,-1,15554,15430,15429,-1,15429,15555,15554,-1,15556,15203,15204,-1,15204,15430,15556,-1,15556,15430,15554,-1,15554,15557,15556,-1,15553,15558,15555,-1,15555,15429,15553,-1,15432,15247,15249,-1,15249,15559,15432,-1,15433,15091,15247,-1,15247,15432,15433,-1,15559,15249,15071,-1,15071,15560,15559,-1,15561,15432,15559,-1,15559,15562,15561,-1,15425,15428,15432,-1,15432,15561,15425,-1,15560,15563,15562,-1,15562,15559,15560,-1,15560,15071,15070,-1,15070,15564,15560,-1,15203,15556,15565,-1,15565,15207,15203,-1,15564,15070,15207,-1,15207,15565,15564,-1,15563,15560,15564,-1,15564,15566,15563,-1,15567,15568,15246,-1,15246,15245,15567,-1,15567,15569,15552,-1,15552,15568,15567,-1,15570,15253,15246,-1,15246,15568,15570,-1,15438,15567,15245,-1,15245,15075,15438,-1,15254,15571,15572,-1,15572,15255,15254,-1,15572,15573,15256,-1,15256,15255,15572,-1,15438,15072,15087,-1,15087,15574,15438,-1,15574,15569,15567,-1,15567,15438,15574,-1,15552,15569,15431,-1,15431,15427,15552,-1,15551,15570,15568,-1,15568,15552,15551,-1,15433,15428,15427,-1,15427,15270,15433,-1,15265,15270,15431,-1,15431,15575,15265,-1,15085,15265,15575,-1,15575,15088,15085,-1,15088,15575,15574,-1,15574,15087,15088,-1,15091,15433,15270,-1,15270,15089,15091,-1,15523,15566,15564,-1,15564,15565,15523,-1,15565,15556,15557,-1,15557,15523,15565,-1,15258,15256,15573,-1,15573,15576,15258,-1,15570,15571,15254,-1,15254,15253,15570,-1,15251,15272,15577,-1,15577,15553,15251,-1,15577,15434,15578,-1,15578,15516,15577,-1,15553,15577,15516,-1,15516,15558,15553,-1,15577,15272,15435,-1,15435,15434,15577,-1,15579,15578,15434,-1,15434,15436,15579,-1,15579,15436,15437,-1,15437,15580,15579,-1,15436,15092,15275,-1,15275,15437,15436,-1,15580,15437,15293,-1,15293,15581,15580,-1,15436,15435,15093,-1,15093,15092,15436,-1,15582,15286,15285,-1,15285,15583,15582,-1,15584,15292,15286,-1,15286,15582,15584,-1,15285,15258,15576,-1,15576,15583,15285,-1,15581,15293,15292,-1,15292,15584,15581,-1,15575,15431,15569,-1,15569,15574,15575,-1,15425,15585,15586,-1,15586,15426,15425,-1,15441,15440,15444,-1,15444,15443,15441,-1,15443,15473,15587,-1,15587,15441,15443,-1,15448,15447,15445,-1,15445,15441,15448,-1,15449,15448,15452,-1,15452,15451,15449,-1,15455,15588,15450,-1,15450,15452,15455,-1,15452,15448,15589,-1,15589,15475,15452,-1,15454,15590,15588,-1,15588,15455,15454,-1,15460,15591,15590,-1,15590,15454,15460,-1,15454,15453,15459,-1,15459,15460,15454,-1,15452,15475,15453,-1,15453,15455,15452,-1,15459,15592,15456,-1,15456,15458,15459,-1,15592,15459,15496,-1,15496,15593,15592,-1,15456,15592,15467,-1,15467,15466,15456,-1,15591,15460,15458,-1,15458,15457,15591,-1,15463,15462,15594,-1,15594,15595,15463,-1,15473,15443,15461,-1,15461,15463,15473,-1,15466,15465,15468,-1,15468,15596,15466,-1,15465,15467,15597,-1,15597,15598,15465,-1,15599,15600,15601,-1,15601,15602,15599,-1,15478,15600,15599,-1,15599,15603,15478,-1,15601,15600,15604,-1,15604,15605,15601,-1,15601,15606,15607,-1,15607,15602,15601,-1,15608,15596,15468,-1,15468,15609,15608,-1,15608,15609,15495,-1,15495,15610,15608,-1,15609,15611,15471,-1,15471,15495,15609,-1,15612,15610,15495,-1,15495,15613,15612,-1,15495,15470,15614,-1,15614,15613,15495,-1,15614,15470,15472,-1,15472,15488,15614,-1,15486,15488,15472,-1,15472,15492,15486,-1,15614,15488,15487,-1,15487,15491,15614,-1,15601,15605,15615,-1,15615,15606,15601,-1,15616,15607,15606,-1,15606,15464,15616,-1,15617,15464,15606,-1,15606,15615,15617,-1,15616,15464,15461,-1,15461,15618,15616,-1,15617,15594,15462,-1,15462,15464,15617,-1,15618,15461,15443,-1,15443,15442,15618,-1,15474,15619,15587,-1,15587,15473,15474,-1,15441,15587,15589,-1,15589,15448,15441,-1,15619,15522,15589,-1,15589,15587,15619,-1,15476,15475,15589,-1,15589,15522,15476,-1,15477,15604,15600,-1,15600,15478,15477,-1,15603,15620,15479,-1,15479,15478,15603,-1,15621,15622,15623,-1,15623,15624,15621,-1,15482,15622,15621,-1,15621,15480,15482,-1,15620,15623,15622,-1,15622,15482,15620,-1,15624,15625,15485,-1,15485,15621,15624,-1,15481,15479,15620,-1,15620,15482,15481,-1,15621,15485,15626,-1,15626,15480,15621,-1,15625,15627,15483,-1,15483,15485,15625,-1,15626,15485,15484,-1,15484,15628,15626,-1,15494,15480,15626,-1,15626,15629,15494,-1,15630,15631,15483,-1,15483,15627,15630,-1,15631,15632,15484,-1,15484,15483,15631,-1,15633,15632,15486,-1,15486,15492,15633,-1,15628,15484,15632,-1,15632,15633,15628,-1,15631,15487,15486,-1,15486,15632,15631,-1,15633,15492,15514,-1,15514,15634,15633,-1,15489,15487,15631,-1,15631,15630,15489,-1,15613,15614,15491,-1,15491,15490,15613,-1,15628,15633,15634,-1,15634,15635,15628,-1,15629,15626,15628,-1,15628,15635,15629,-1,15472,15471,15636,-1,15636,15493,15472,-1,15609,15468,15469,-1,15469,15611,15609,-1,15471,15611,15637,-1,15637,15636,15471,-1,15465,15598,15638,-1,15638,15469,15465,-1,15469,15638,15637,-1,15637,15611,15469,-1,15593,15597,15467,-1,15467,15592,15593,-1,15481,15498,15477,-1,15477,15479,15481,-1,15494,15639,15498,-1,15498,15481,15494,-1,15639,15530,15497,-1,15497,15498,15639,-1,15531,15530,15639,-1,15639,15640,15531,-1,15532,15641,15497,-1,15497,15530,15532,-1,15639,15494,15629,-1,15629,15640,15639,-1,15554,15555,15505,-1,15505,15507,15554,-1,15500,15499,15502,-1,15502,15642,15500,-1,15643,15501,15500,-1,15500,15644,15643,-1,15645,15499,15501,-1,15501,15646,15645,-1,15643,15647,15646,-1,15646,15501,15643,-1,15648,15644,15500,-1,15500,15642,15648,-1,15649,15650,15643,-1,15643,15644,15649,-1,15499,15509,15503,-1,15503,15502,15499,-1,15508,15509,15499,-1,15499,15645,15508,-1,15506,15505,15503,-1,15503,15509,15506,-1,15505,15555,15558,-1,15558,15503,15505,-1,15558,15516,15504,-1,15504,15503,15558,-1,15651,15652,15653,-1,15653,15511,15651,-1,15651,15654,15513,-1,15513,15652,15651,-1,15655,15656,15653,-1,15653,15652,15655,-1,15653,15657,15512,-1,15512,15511,15653,-1,15658,15651,15511,-1,15511,15510,15658,-1,15659,15654,15651,-1,15651,15658,15659,-1,15532,15531,15658,-1,15658,15510,15532,-1,15654,15634,15514,-1,15514,15513,15654,-1,15654,15659,15635,-1,15635,15634,15654,-1,15652,15513,15515,-1,15515,15655,15652,-1,15660,15661,15662,-1,15662,15663,15660,-1,15664,15657,15661,-1,15661,15660,15664,-1,15665,15662,15661,-1,15661,15656,15665,-1,15666,15663,15662,-1,15662,15667,15666,-1,15660,15663,15668,-1,15668,15669,15660,-1,15655,15515,15650,-1,15650,15649,15655,-1,15650,15515,15514,-1,15514,15670,15650,-1,15649,15665,15656,-1,15656,15655,15649,-1,15648,15667,15662,-1,15662,15665,15648,-1,15661,15657,15653,-1,15653,15656,15661,-1,15665,15649,15644,-1,15644,15648,15665,-1,15598,15508,15645,-1,15645,15638,15598,-1,15671,15508,15598,-1,15598,15597,15671,-1,15646,15637,15638,-1,15638,15645,15646,-1,15671,15507,15506,-1,15506,15508,15671,-1,15672,15673,15507,-1,15507,15671,15672,-1,15667,15648,15642,-1,15642,15519,15667,-1,15517,15642,15502,-1,15502,15504,15517,-1,15517,15520,15519,-1,15519,15642,15517,-1,15666,15667,15519,-1,15519,15518,15666,-1,15578,15579,15518,-1,15518,15520,15578,-1,15517,15516,15578,-1,15578,15520,15517,-1,15637,15646,15647,-1,15647,15636,15637,-1,15670,15493,15636,-1,15636,15647,15670,-1,15670,15514,15492,-1,15492,15493,15670,-1,15650,15670,15647,-1,15647,15643,15650,-1,15674,15561,15562,-1,15562,15675,15674,-1,15562,15563,15676,-1,15676,15675,15562,-1,15563,15566,15677,-1,15677,15676,15563,-1,15474,15678,15675,-1,15675,15676,15474,-1,15679,15476,15521,-1,15521,15524,15679,-1,15522,15619,15677,-1,15677,15521,15522,-1,15453,15476,15679,-1,15679,15496,15453,-1,15593,15496,15679,-1,15679,15672,15593,-1,15523,15557,15673,-1,15673,15524,15523,-1,15566,15523,15521,-1,15521,15677,15566,-1,15680,15527,15526,-1,15526,15681,15680,-1,15680,15682,15683,-1,15683,15527,15680,-1,15681,15526,15684,-1,15684,15685,15681,-1,15681,15535,15686,-1,15686,15680,15681,-1,15640,15629,15635,-1,15635,15659,15640,-1,15531,15640,15659,-1,15659,15658,15531,-1,15657,15664,15687,-1,15687,15512,15657,-1,15510,15512,15687,-1,15687,15688,15510,-1,15687,15689,15683,-1,15683,15688,15687,-1,15690,15532,15510,-1,15510,15688,15690,-1,15687,15664,15691,-1,15691,15689,15687,-1,15689,15692,15527,-1,15527,15683,15689,-1,15682,15690,15688,-1,15688,15683,15682,-1,15693,15692,15689,-1,15689,15691,15693,-1,15529,15525,15527,-1,15527,15692,15529,-1,15526,15525,15528,-1,15528,15684,15526,-1,15694,15528,15529,-1,15529,15695,15694,-1,15695,15529,15692,-1,15692,15693,15695,-1,15682,15680,15686,-1,15686,15696,15682,-1,15696,15697,15690,-1,15690,15682,15696,-1,15532,15690,15697,-1,15697,15641,15532,-1,15604,15477,15497,-1,15497,15698,15604,-1,15641,15699,15698,-1,15698,15497,15641,-1,15605,15604,15698,-1,15698,15700,15605,-1,15699,15641,15697,-1,15697,15701,15699,-1,15700,15698,15699,-1,15699,15702,15700,-1,15697,15696,15703,-1,15703,15701,15697,-1,15702,15699,15701,-1,15701,15704,15702,-1,15696,15686,15705,-1,15705,15703,15696,-1,15704,15701,15703,-1,15703,15706,15704,-1,15535,15534,15705,-1,15705,15686,15535,-1,15706,15703,15705,-1,15705,15707,15706,-1,15685,15533,15535,-1,15535,15681,15685,-1,15707,15705,15534,-1,15534,15708,15707,-1,15709,15533,15685,-1,15685,15710,15709,-1,15561,15674,15585,-1,15585,15425,15561,-1,15585,15550,15711,-1,15711,15586,15585,-1,15551,15426,15586,-1,15586,15712,15551,-1,15674,15548,15550,-1,15550,15585,15674,-1,15675,15678,15548,-1,15548,15674,15675,-1,15619,15474,15676,-1,15676,15677,15619,-1,15673,15557,15554,-1,15554,15507,15673,-1,15673,15672,15679,-1,15679,15524,15673,-1,15572,15713,15714,-1,15714,15573,15572,-1,15539,15715,15538,-1,15538,15537,15539,-1,15541,15716,15715,-1,15715,15539,15541,-1,15709,15710,15538,-1,15538,15715,15709,-1,15713,15539,15537,-1,15537,15714,15713,-1,15717,15718,15716,-1,15716,15541,15717,-1,15708,15709,15715,-1,15715,15716,15708,-1,15713,15572,15571,-1,15571,15719,15713,-1,15571,15570,15720,-1,15720,15719,15571,-1,15719,15540,15539,-1,15539,15713,15719,-1,15576,15573,15714,-1,15714,15721,15576,-1,15721,15714,15537,-1,15537,15536,15721,-1,15722,15717,15541,-1,15541,15540,15722,-1,15722,15723,15724,-1,15724,15717,15722,-1,15720,15722,15540,-1,15540,15719,15720,-1,15718,15717,15724,-1,15724,15725,15718,-1,15707,15708,15716,-1,15716,15718,15707,-1,15726,15727,15725,-1,15725,15724,15726,-1,15706,15707,15718,-1,15718,15725,15706,-1,15712,15723,15722,-1,15722,15720,15712,-1,15711,15726,15724,-1,15724,15723,15711,-1,15726,15711,15550,-1,15550,15542,15726,-1,15586,15711,15723,-1,15723,15712,15586,-1,15726,15542,15728,-1,15728,15727,15726,-1,15704,15706,15725,-1,15725,15727,15704,-1,15704,15727,15728,-1,15728,15702,15704,-1,15708,15534,15533,-1,15533,15709,15708,-1,15710,15729,15730,-1,15730,15538,15710,-1,15685,15684,15729,-1,15729,15710,15685,-1,15729,15694,15731,-1,15731,15730,15729,-1,15732,15536,15538,-1,15538,15730,15732,-1,15733,15721,15536,-1,15536,15732,15733,-1,15583,15576,15721,-1,15721,15733,15583,-1,15570,15551,15712,-1,15712,15720,15570,-1,15593,15672,15671,-1,15671,15597,15593,-1,15544,15543,15594,-1,15594,15617,15544,-1,15615,15734,15544,-1,15544,15617,15615,-1,15605,15700,15734,-1,15734,15615,15605,-1,15542,15544,15734,-1,15734,15728,15542,-1,15700,15702,15728,-1,15728,15734,15700,-1,15549,15543,15542,-1,15542,15550,15549,-1,15595,15594,15543,-1,15543,15549,15595,-1,15549,15548,15678,-1,15678,15595,15549,-1,15678,15474,15463,-1,15463,15595,15678,-1,15518,15579,15580,-1,15580,15546,15518,-1,15546,15580,15581,-1,15581,15547,15546,-1,15546,15545,15666,-1,15666,15518,15546,-1,15729,15684,15528,-1,15528,15694,15729,-1,15694,15695,15735,-1,15735,15731,15694,-1,15731,15736,15732,-1,15732,15730,15731,-1,15693,15737,15735,-1,15735,15695,15693,-1,15735,15738,15736,-1,15736,15731,15735,-1,15691,15669,15737,-1,15737,15693,15691,-1,15737,15739,15738,-1,15738,15735,15737,-1,15737,15669,15668,-1,15668,15739,15737,-1,15739,15547,15740,-1,15740,15738,15739,-1,15547,15739,15668,-1,15668,15545,15547,-1,15664,15660,15669,-1,15669,15691,15664,-1,15666,15545,15668,-1,15668,15663,15666,-1,15736,15741,15733,-1,15733,15732,15736,-1,15738,15740,15741,-1,15741,15736,15738,-1,15741,15582,15583,-1,15583,15733,15741,-1,15740,15584,15582,-1,15582,15741,15740,-1,15547,15581,15584,-1,15584,15740,15547,-1,15742,15743,15744,-1,15745,15746,15747,-1,15748,15747,15746,-1,15749,15744,15743,-1,15750,15751,15752,-1,15753,15754,15751,-1,15755,15756,15757,-1,15758,15759,15760,-1,15761,15759,15758,-1,15762,15763,15764,-1,15765,15766,15767,-1,15768,15769,15770,-1,15771,15772,15773,-1,15774,15775,15776,-1,15774,15776,15777,-1,15778,15771,15779,-1,15780,15781,15782,-1,15783,15784,15785,-1,15786,15785,15784,-1,15787,15782,15781,-1,15788,15789,15790,-1,15791,15789,15788,-1,15792,15793,15794,-1,15794,15793,15795,-1,15796,15793,15797,-1,15793,15796,15795,-1,15798,15799,15800,-1,15801,15799,15802,-1,15803,15804,15805,-1,15599,15806,15804,-1,15807,15808,15809,-1,15810,15811,15808,-1,15812,15813,15814,-1,15602,15815,15816,-1,15817,15818,15819,-1,15820,15821,15822,-1,15823,15824,15825,-1,15826,15827,15828,-1,15829,15830,15831,-1,15832,15602,15607,-1,15833,15832,15607,-1,15834,15835,15836,-1,15837,15836,15838,-1,15838,15836,15839,-1,15839,15836,15835,-1,15840,15841,15618,-1,15840,15842,15843,-1,15442,15844,15840,-1,15442,15840,15618,-1,15834,15844,15845,-1,15846,15847,15848,-1,15834,15845,15849,-1,15807,15850,15796,-1,15851,15852,15853,-1,15854,15855,15856,-1,15857,15858,15859,-1,15860,15861,15862,-1,15862,15791,15863,-1,15749,15743,15864,-1,15865,15744,15866,-1,15867,15868,15869,-1,15868,15865,15869,-1,15866,15869,15865,-1,15870,15747,15748,-1,15871,15870,15872,-1,15873,15874,15875,-1,15876,15877,15878,-1,15794,15795,15879,-1,15880,15879,15881,-1,15882,15883,15884,-1,15885,15847,15852,-1,15886,15883,15887,-1,15888,15889,15890,-1,15869,15891,15867,-1,15892,15788,15893,-1,15894,15895,15896,-1,15897,15898,15896,-1,15898,15446,15899,-1,15897,15900,15898,-1,15901,15897,15902,-1,15895,15903,15902,-1,15904,15905,15906,-1,15901,15907,15908,-1,15909,15910,15911,-1,15863,15912,15913,-1,15914,15915,15916,-1,15917,15911,15918,-1,15919,15920,15921,-1,15922,15923,15921,-1,15924,15925,15926,-1,15927,15928,15929,-1,15930,15931,15932,-1,15933,15934,15935,-1,15936,15937,15938,-1,15934,15933,15939,-1,15940,15941,15942,-1,15940,15943,15944,-1,15945,15946,15947,-1,15948,15772,15949,-1,15950,15951,15952,-1,15953,15950,15894,-1,15450,15954,15955,-1,15956,15957,15958,-1,15450,15959,15954,-1,15960,15961,15956,-1,15960,15962,15963,-1,15588,15964,15965,-1,15963,15962,15966,-1,15754,15753,15967,-1,15968,15754,15967,-1,15969,15761,15970,-1,15971,15972,15973,-1,15972,15974,15973,-1,15975,15973,15974,-1,15975,15974,15757,-1,15976,15977,15752,-1,15978,15979,15980,-1,15976,15980,15977,-1,15980,15979,15977,-1,15981,15982,15983,-1,15588,15590,15964,-1,15984,15985,15986,-1,15987,15988,15989,-1,15990,15991,15992,-1,15993,15994,15995,-1,15996,15997,15998,-1,15999,15996,15998,-1,16000,16001,16002,-1,16003,16004,16005,-1,15941,16006,16007,-1,16008,16009,16010,-1,16011,16012,16013,-1,16014,16015,16016,-1,16017,16018,16019,-1,16020,16021,16022,-1,16022,16023,16020,-1,16024,16025,16026,-1,16027,16028,16024,-1,16029,16028,16030,-1,16031,16032,16033,-1,16034,16035,16033,-1,16036,15763,16029,-1,16031,15766,16037,-1,16038,16039,16034,-1,16040,16041,16042,-1,16043,16044,16045,-1,16046,16047,16048,-1,16049,16050,16051,-1,16039,16052,16053,-1,16054,16055,16040,-1,16056,16057,16058,-1,16059,15956,15961,-1,16060,16061,16062,-1,15630,16062,16063,-1,15940,15944,16064,-1,16065,16066,16057,-1,15803,15620,15603,-1,16062,15630,16067,-1,16068,16069,16070,-1,16071,16072,15923,-1,16073,16074,16075,-1,16076,16077,16078,-1,16079,16078,16080,-1,16078,16077,16080,-1,16080,15769,16079,-1,16081,16082,16083,-1,16084,16085,16086,-1,16087,16088,16089,-1,15777,16090,16091,-1,15787,15781,16092,-1,16093,15782,16094,-1,16095,16096,16097,-1,16096,16093,16097,-1,16094,16097,16093,-1,16098,15785,15786,-1,16099,16098,16100,-1,16101,16102,16103,-1,16104,16105,16106,-1,16107,16105,16108,-1,16109,16110,16111,-1,16097,16112,16095,-1,15744,16113,16114,-1,16114,15742,15744,-1,15865,16115,16113,-1,16113,15744,15865,-1,16113,16116,16117,-1,16117,16114,16113,-1,16118,15743,15742,-1,15742,16114,16118,-1,16115,16119,16116,-1,16116,16113,16115,-1,16116,15746,15745,-1,15745,16117,16116,-1,16117,16120,16118,-1,16118,16114,16117,-1,16119,16121,15746,-1,15746,16116,16119,-1,16120,16117,15745,-1,15745,15747,16120,-1,16118,16120,15871,-1,15871,16122,16118,-1,15753,15751,15750,-1,15750,16123,15753,-1,15754,15976,15752,-1,15752,15751,15754,-1,15752,16124,16125,-1,16125,15750,15752,-1,16126,16123,15750,-1,15750,16125,16126,-1,16127,15753,16123,-1,16123,16126,16127,-1,15760,15756,15755,-1,15755,15758,15760,-1,16128,15757,15756,-1,15756,16129,16128,-1,15755,15757,15974,-1,15974,15970,15755,-1,16129,15756,15760,-1,15760,16130,16129,-1,15758,15755,15970,-1,15970,15761,15758,-1,16130,15760,15759,-1,15759,16131,16130,-1,16131,15759,15761,-1,15761,16132,16131,-1,16131,16127,16126,-1,16126,16130,16131,-1,16127,16131,16132,-1,16132,16133,16127,-1,16130,16126,16125,-1,16125,16129,16130,-1,15753,16127,16133,-1,16133,15967,15753,-1,16124,15752,15977,-1,15977,16134,16124,-1,16129,16125,16124,-1,16124,16128,16129,-1,15763,15762,16025,-1,16025,16029,15763,-1,15763,16135,16136,-1,16136,15764,15763,-1,16137,16138,15762,-1,15762,15764,16137,-1,16135,15763,16036,-1,16036,16139,16135,-1,16135,16140,16141,-1,16141,16136,16135,-1,15764,16136,16142,-1,16142,16137,15764,-1,16143,16142,16136,-1,16136,16141,16143,-1,16144,16142,16143,-1,16143,16145,16144,-1,16146,16143,16141,-1,16141,15765,16146,-1,16146,16147,16145,-1,16145,16143,16146,-1,16140,15766,15765,-1,15765,16141,16140,-1,16147,16146,15765,-1,15765,15767,16147,-1,16033,16035,16147,-1,16147,15767,16033,-1,16147,16035,16148,-1,16148,16145,16147,-1,16142,16144,16138,-1,16138,16137,16142,-1,16149,16144,16145,-1,16145,16148,16149,-1,16144,16149,16026,-1,16026,16138,16144,-1,15767,15766,16031,-1,16031,16033,15767,-1,16138,16026,16025,-1,16025,15762,16138,-1,16150,16037,15766,-1,15766,16140,16150,-1,16120,15747,15870,-1,15870,15871,16120,-1,15743,16118,16122,-1,16122,15864,15743,-1,16151,15975,15757,-1,15757,16128,16151,-1,16134,16151,16128,-1,16128,16124,16134,-1,16135,16139,16150,-1,16150,16140,16135,-1,16152,16153,16154,-1,16154,16155,16152,-1,16153,16152,15773,-1,15773,15772,16153,-1,16156,16154,16153,-1,16153,16157,16156,-1,15769,15768,16155,-1,16155,16154,15769,-1,16158,16152,16155,-1,16155,16159,16158,-1,15768,15775,16159,-1,16159,16155,15768,-1,16079,15769,16154,-1,16154,16156,16079,-1,16160,15773,16152,-1,16152,16158,16160,-1,15771,15773,16160,-1,16160,15779,15771,-1,15779,16160,16158,-1,16158,16161,15779,-1,16161,16158,16159,-1,16159,16162,16161,-1,15772,15948,16157,-1,16157,16153,15772,-1,15768,15770,15776,-1,15776,15775,15768,-1,15775,15774,16162,-1,16162,16159,15775,-1,16161,16163,16164,-1,16164,15779,16161,-1,16162,16165,16163,-1,16163,16161,16162,-1,15774,15777,16165,-1,16165,16162,15774,-1,15770,16090,15777,-1,15777,15776,15770,-1,15769,16080,16090,-1,16090,15770,15769,-1,15949,15772,15771,-1,15771,15778,15949,-1,15782,16166,16167,-1,16167,15780,15782,-1,16093,16168,16166,-1,16166,15782,16093,-1,16166,16169,16170,-1,16170,16167,16166,-1,16171,15781,15780,-1,15780,16167,16171,-1,16168,16172,16169,-1,16169,16166,16168,-1,16169,15784,15783,-1,15783,16170,16169,-1,16170,16173,16171,-1,16171,16167,16170,-1,16172,16174,15784,-1,15784,16169,16172,-1,16173,16170,15783,-1,15783,15785,16173,-1,16171,16173,16099,-1,16099,16175,16171,-1,16173,15785,16098,-1,16098,16099,16173,-1,15781,16171,16175,-1,16175,16092,15781,-1,16176,15790,15789,-1,15789,16177,16176,-1,16178,16179,15788,-1,15788,15790,16178,-1,15857,15789,15791,-1,15791,15862,15857,-1,16180,15863,15791,-1,15791,15788,16180,-1,15793,15792,16181,-1,16181,15797,15793,-1,15794,15879,15880,-1,15880,15792,15794,-1,15797,16182,15851,-1,15851,15796,15797,-1,15792,16183,16184,-1,16184,16181,15792,-1,15936,16182,15797,-1,15797,16181,15936,-1,15880,16185,16183,-1,16183,15792,15880,-1,16183,16176,16177,-1,16177,16184,16183,-1,16184,15937,15936,-1,15936,16181,16184,-1,16185,16186,16176,-1,16176,16183,16185,-1,15937,16184,16177,-1,16177,15859,15937,-1,16186,16178,15790,-1,15790,16176,16186,-1,15859,16177,15789,-1,15789,15857,15859,-1,15802,15799,15798,-1,15798,16187,15802,-1,15815,15800,15799,-1,15799,15801,15815,-1,15798,15800,15832,-1,15832,15833,15798,-1,15800,15815,15602,-1,15602,15832,15800,-1,15816,15815,15801,-1,15801,16188,15816,-1,15805,15804,15806,-1,15806,16189,15805,-1,15813,15812,16189,-1,16189,15806,15813,-1,16190,16191,15805,-1,15805,16189,16190,-1,15810,15808,15807,-1,15807,15853,15810,-1,15808,15811,16192,-1,16192,15809,15808,-1,16193,15850,15807,-1,15807,15809,16193,-1,15811,16190,16194,-1,16194,16192,15811,-1,16195,16193,15809,-1,15809,16192,16195,-1,16191,16190,15811,-1,15811,15810,16191,-1,16190,16189,15812,-1,15812,16194,16190,-1,16196,16195,16192,-1,16192,16194,16196,-1,16196,16194,15812,-1,15812,16197,16196,-1,15813,16188,16198,-1,16198,15814,15813,-1,15819,16197,15812,-1,15812,15814,15819,-1,15806,15816,16188,-1,16188,15813,15806,-1,15599,15602,15816,-1,15816,15806,15599,-1,16188,15801,15823,-1,15823,16198,16188,-1,15824,15823,15801,-1,15801,15802,15824,-1,16197,15819,15818,-1,15818,15821,16197,-1,15817,15819,15814,-1,15814,16198,15817,-1,16198,15823,15825,-1,15825,15817,16198,-1,15817,16199,16200,-1,16200,15818,15817,-1,15818,16200,15822,-1,15822,15821,15818,-1,15821,15820,16196,-1,16196,16197,15821,-1,16201,16202,15850,-1,15850,16193,16201,-1,16203,16202,16201,-1,16201,16204,16203,-1,16202,16205,15855,-1,15855,15850,16202,-1,16206,16201,16193,-1,16193,16195,16206,-1,16201,16206,16207,-1,16207,16204,16201,-1,15820,16206,16195,-1,16195,16196,15820,-1,16206,15820,15822,-1,15822,16207,16206,-1,16191,16208,15803,-1,15803,15805,16191,-1,16208,16191,15810,-1,15810,16209,16208,-1,16208,16210,16211,-1,16211,15803,16208,-1,16212,15824,15802,-1,15802,16187,16212,-1,15825,15824,16212,-1,16212,16213,15825,-1,16187,16214,16215,-1,16215,16212,16187,-1,15827,15826,16216,-1,16216,16217,15827,-1,16218,15828,15827,-1,15827,15830,16218,-1,15826,15828,16219,-1,16219,16174,15826,-1,16100,16219,15828,-1,15828,16218,16100,-1,16217,15831,15830,-1,15830,15827,16217,-1,16220,16218,15830,-1,15830,15829,16220,-1,16100,16218,16220,-1,16220,16221,16100,-1,16222,16220,15829,-1,15829,16213,16222,-1,16222,16223,16221,-1,16221,16220,16222,-1,15831,15825,16213,-1,16213,15829,15831,-1,16212,16215,16222,-1,16222,16213,16212,-1,15603,15599,15804,-1,15804,15803,15603,-1,16224,15798,15833,-1,15833,16225,16224,-1,16187,15798,16224,-1,16224,16214,16187,-1,15833,15607,15616,-1,15616,16225,15833,-1,16226,16224,16225,-1,16225,15841,16226,-1,16227,15842,15834,-1,15834,15836,16227,-1,16228,15843,15842,-1,15842,16227,16228,-1,15842,15840,15844,-1,15844,15834,15842,-1,16229,16227,15836,-1,15836,15837,16229,-1,16228,16227,16229,-1,16229,16230,16228,-1,16231,16229,15837,-1,15837,16232,16231,-1,16233,16214,16224,-1,16224,16226,16233,-1,15841,16225,15616,-1,15616,15618,15841,-1,15843,16226,15841,-1,15841,15840,15843,-1,16228,16233,16226,-1,16226,15843,16228,-1,15845,15844,15442,-1,15442,15444,15845,-1,16210,16208,16209,-1,16209,15846,16210,-1,16209,15852,15847,-1,15847,15846,16209,-1,15846,15848,16211,-1,16211,16210,15846,-1,16209,15810,15853,-1,15853,15852,16209,-1,15803,16211,15623,-1,15623,15620,15803,-1,15624,15623,16211,-1,16211,15848,15624,-1,16234,16235,15849,-1,15849,15845,16234,-1,15849,16236,15835,-1,15835,15834,15849,-1,16237,16238,15795,-1,15795,15796,16237,-1,16237,16239,16240,-1,16240,16238,16237,-1,16238,16241,16242,-1,16242,15795,16238,-1,16237,15796,15850,-1,15850,15855,16237,-1,15796,15851,15853,-1,15853,15807,15796,-1,16239,16237,15855,-1,15855,15854,16239,-1,16182,15885,15852,-1,15852,15851,16182,-1,16243,16239,15854,-1,15854,15839,16243,-1,16244,16240,16239,-1,16239,16243,16244,-1,15838,15839,15854,-1,15854,15856,15838,-1,16236,16243,15839,-1,15839,15835,16236,-1,16245,16236,15849,-1,15849,16235,16245,-1,16236,16245,16244,-1,16244,16243,16236,-1,15858,15857,15862,-1,15862,15861,15858,-1,15932,15858,15861,-1,15861,15935,15932,-1,15866,15744,15749,-1,15749,16246,15866,-1,16247,16246,15749,-1,15749,15864,16247,-1,16248,16246,16247,-1,16247,15878,16248,-1,16247,15864,16122,-1,16122,16249,16247,-1,16121,16250,15748,-1,15748,15746,16121,-1,16248,15869,15866,-1,15866,16246,16248,-1,15868,16251,16115,-1,16115,15865,15868,-1,16251,16252,16119,-1,16119,16115,16251,-1,16252,16253,16121,-1,16121,16119,16252,-1,16249,16122,15871,-1,15871,15872,16249,-1,16250,15872,15870,-1,15870,15748,16250,-1,16253,16254,16250,-1,16250,16121,16253,-1,15872,16250,16254,-1,16254,15874,15872,-1,15872,15874,15873,-1,15873,16255,15872,-1,16254,16256,15875,-1,15875,15874,16254,-1,16240,16257,15873,-1,15873,15875,16240,-1,15876,16258,16259,-1,16259,15877,15876,-1,16260,16248,15878,-1,15878,15877,16260,-1,15878,16247,16261,-1,16261,15876,15878,-1,16257,16262,16255,-1,16255,15873,16257,-1,16249,15872,16255,-1,16255,16263,16249,-1,16247,16249,16263,-1,16263,16261,16247,-1,16264,16258,15876,-1,15876,16261,16264,-1,16262,16265,16263,-1,16263,16255,16262,-1,16265,16264,16261,-1,16261,16263,16265,-1,15795,16242,15881,-1,15881,15879,15795,-1,16185,15880,15881,-1,15881,16266,16185,-1,15882,16256,16267,-1,16267,15883,15882,-1,15884,15883,15886,-1,15886,16268,15884,-1,15884,16242,16241,-1,16241,15882,15884,-1,16242,15884,16268,-1,16268,15881,16242,-1,16256,15882,16241,-1,16241,15875,16256,-1,16241,16238,16240,-1,16240,15875,16241,-1,16245,16235,16269,-1,16269,16270,16245,-1,16182,15936,15938,-1,15938,15885,16182,-1,15885,15938,15931,-1,15931,15847,15885,-1,16271,16266,15881,-1,15881,16268,16271,-1,16272,16271,16268,-1,16268,15886,16272,-1,16273,15887,15883,-1,15883,16267,16273,-1,15887,16274,16272,-1,16272,15886,15887,-1,16273,16275,16274,-1,16274,15887,16273,-1,16274,16276,16277,-1,16277,16272,16274,-1,16276,16274,16275,-1,16275,16278,16276,-1,16276,15889,15888,-1,15888,16277,16276,-1,16271,16272,16277,-1,16277,16279,16271,-1,16280,15889,16276,-1,16276,16278,16280,-1,15888,16281,16279,-1,16279,16277,15888,-1,15889,16280,16282,-1,16282,15890,15889,-1,15890,16283,16281,-1,16281,15888,15890,-1,16283,15890,16282,-1,16282,16284,16283,-1,16283,16285,16286,-1,16286,16281,16283,-1,15869,16248,16260,-1,16260,15891,15869,-1,16282,16280,15867,-1,15867,15891,16282,-1,15868,15867,16280,-1,16280,16278,15868,-1,16278,16275,16251,-1,16251,15868,16278,-1,16252,16251,16275,-1,16275,16273,16252,-1,16253,16252,16273,-1,16273,16267,16253,-1,16254,16253,16267,-1,16267,16256,16254,-1,16281,16286,16287,-1,16287,16279,16281,-1,16286,16178,16186,-1,16186,16287,16286,-1,16266,16271,16279,-1,16279,16287,16266,-1,16285,16179,16178,-1,16178,16286,16285,-1,16186,16185,16266,-1,16266,16287,16186,-1,16179,16288,15893,-1,15893,15788,16179,-1,16179,16285,16289,-1,16289,16288,16179,-1,16288,16259,16290,-1,16290,15893,16288,-1,15788,15892,15909,-1,15909,16180,15788,-1,16290,16291,15892,-1,15892,15893,16290,-1,15950,15905,15895,-1,15895,15894,15950,-1,15895,15902,15897,-1,15897,15896,15895,-1,15896,15898,15899,-1,15899,15894,15896,-1,15899,16292,15953,-1,15953,15894,15899,-1,15898,15900,16293,-1,16293,16294,15898,-1,15900,15908,16295,-1,16295,16293,15900,-1,16296,16294,16293,-1,16293,16297,16296,-1,15898,16294,15447,-1,15447,15446,15898,-1,15897,15901,15908,-1,15908,15900,15897,-1,16295,15908,16298,-1,16298,16299,16295,-1,16295,16300,16297,-1,16297,16293,16295,-1,15902,15903,15907,-1,15907,15901,15902,-1,15904,15903,15895,-1,15895,15905,15904,-1,15904,15911,15910,-1,15910,15903,15904,-1,15907,16301,16298,-1,16298,15908,15907,-1,16291,16290,16301,-1,16301,15907,16291,-1,16264,16298,16301,-1,16301,16258,16264,-1,16291,15907,15903,-1,15903,15910,16291,-1,15910,15909,15892,-1,15892,16291,15910,-1,15863,16180,15917,-1,15917,15912,15863,-1,15909,15911,15917,-1,15917,16180,15909,-1,16285,16283,16284,-1,16284,16289,16285,-1,15877,16259,16288,-1,16288,16289,15877,-1,16290,16259,16258,-1,16258,16301,16290,-1,16234,16302,16269,-1,16269,16235,16234,-1,16234,15845,15444,-1,15444,15440,16234,-1,16245,16270,16303,-1,16303,16244,16245,-1,16302,16234,15440,-1,15440,15439,16302,-1,16296,16302,15439,-1,15439,15445,16296,-1,16270,16300,16304,-1,16304,16303,16270,-1,16244,16303,16257,-1,16257,16240,16244,-1,16300,16270,16269,-1,16269,16297,16300,-1,16300,16295,16299,-1,16299,16304,16300,-1,16262,16257,16303,-1,16303,16304,16262,-1,16262,16304,16299,-1,16299,16265,16262,-1,16299,16298,16264,-1,16264,16265,16299,-1,16302,16296,16297,-1,16297,16269,16302,-1,16296,15445,15447,-1,15447,16294,16296,-1,16305,16306,15913,-1,15913,15912,16305,-1,15863,15913,15860,-1,15860,15862,15863,-1,15915,15914,16307,-1,16307,16308,15915,-1,15914,16309,16310,-1,16310,16307,15914,-1,16308,16307,16311,-1,16311,16312,16308,-1,16313,16314,15915,-1,15915,16308,16313,-1,16309,15914,15916,-1,15916,16306,16309,-1,16315,16316,16310,-1,16310,16309,16315,-1,16307,16310,16317,-1,16317,16311,16307,-1,15911,16318,16319,-1,16319,15918,15911,-1,15918,16305,15912,-1,15912,15917,15918,-1,16306,15916,16320,-1,16320,15913,16306,-1,15916,15915,16321,-1,16321,16320,15916,-1,15913,16320,15928,-1,15928,15860,15913,-1,16322,15920,15943,-1,15943,16323,16322,-1,15920,16322,16314,-1,16314,16324,15920,-1,15920,15919,15944,-1,15944,15943,15920,-1,16325,16323,15943,-1,15943,15940,16325,-1,16323,15929,16321,-1,16321,16322,16323,-1,16324,15922,15921,-1,15921,15920,16324,-1,16326,15919,15921,-1,15921,16327,16326,-1,16328,16329,15923,-1,15923,15922,16328,-1,16327,15921,15923,-1,15923,16330,16327,-1,16331,16328,15922,-1,15922,16324,16331,-1,15915,16314,16322,-1,16322,16321,15915,-1,15929,15928,16320,-1,16320,16321,15929,-1,16305,16315,16309,-1,16309,16306,16305,-1,15918,16319,16315,-1,16315,16305,15918,-1,16332,16333,16334,-1,16334,16335,16332,-1,16332,16336,16337,-1,16337,16333,16332,-1,16333,16338,16339,-1,16339,16334,16333,-1,16334,16340,16341,-1,16341,16335,16334,-1,16342,16332,16335,-1,16335,16343,16342,-1,16337,16344,16338,-1,16338,16333,16337,-1,16338,16345,15925,-1,15925,16339,16338,-1,16346,16340,16334,-1,16334,16339,16346,-1,16344,16347,16345,-1,16345,16338,16344,-1,16345,16348,15926,-1,15926,15925,16345,-1,15925,15924,16346,-1,16346,16339,15925,-1,16347,16006,16348,-1,16348,16345,16347,-1,16348,16326,16327,-1,16327,15926,16348,-1,16006,16064,16326,-1,16326,16348,16006,-1,16327,16330,15924,-1,15924,15926,16327,-1,15919,16326,16064,-1,16064,15944,15919,-1,16316,16315,16319,-1,16319,16349,16316,-1,16316,16350,16317,-1,16317,16310,16316,-1,16350,16316,16349,-1,16349,16351,16350,-1,16317,16350,16352,-1,16352,16353,16317,-1,15861,15860,15928,-1,15928,15927,15861,-1,15933,15935,15861,-1,15861,15927,15933,-1,15930,15932,15935,-1,15935,15934,15930,-1,15934,15627,15625,-1,15625,15930,15934,-1,15938,15858,15932,-1,15932,15931,15938,-1,15938,15937,15859,-1,15859,15858,15938,-1,16284,16260,15877,-1,15877,16289,16284,-1,16260,16284,16282,-1,16282,15891,16260,-1,16313,16331,16324,-1,16324,16314,16313,-1,15927,15929,16323,-1,16323,16325,15927,-1,15934,15939,15942,-1,15942,16067,15934,-1,15939,16325,15940,-1,15940,15942,15939,-1,16062,16067,15942,-1,15942,16060,16062,-1,15627,15934,16067,-1,16067,15630,15627,-1,16325,15939,15933,-1,15933,15927,16325,-1,15945,15947,16164,-1,16164,16163,15945,-1,15947,16354,16355,-1,16355,16164,15947,-1,15945,16163,16165,-1,16165,16356,15945,-1,16354,15947,15946,-1,15946,16357,16354,-1,16358,16359,16355,-1,16355,16354,16358,-1,16164,16355,15778,-1,15778,15779,16164,-1,16355,16359,15949,-1,15949,15778,16355,-1,16359,16360,15948,-1,15948,15949,16359,-1,16360,16359,16358,-1,16358,16361,16360,-1,16362,16157,15948,-1,15948,16360,16362,-1,15899,15446,15449,-1,15449,16292,15899,-1,15952,15951,16363,-1,16363,16364,15952,-1,15951,16365,15958,-1,15958,16363,15951,-1,16366,16364,16363,-1,16363,16367,16366,-1,16368,15952,16364,-1,16364,16369,16368,-1,15951,15950,15953,-1,15953,16365,15951,-1,16370,15955,15958,-1,15958,16365,16370,-1,15958,15957,16367,-1,16367,16363,15958,-1,16292,16370,16365,-1,16365,15953,16292,-1,16292,15449,15451,-1,15451,16370,16292,-1,15955,16370,15451,-1,15451,15450,15955,-1,15955,15954,15956,-1,15956,15958,15955,-1,15954,15959,15960,-1,15960,15956,15954,-1,15959,15965,15962,-1,15962,15960,15959,-1,15965,15959,15450,-1,15450,15588,15965,-1,15965,15964,15966,-1,15966,15962,15965,-1,16371,16372,15966,-1,15966,15964,16371,-1,15761,15969,15987,-1,15987,15989,15761,-1,15972,15969,15970,-1,15970,15974,15972,-1,15987,15969,15972,-1,15972,16373,15987,-1,15989,16374,16132,-1,16132,15761,15989,-1,16374,16375,16133,-1,16133,16132,16374,-1,16375,16376,15967,-1,15967,16133,16375,-1,15968,15980,15976,-1,15976,15754,15968,-1,16376,16377,15968,-1,15968,15967,16376,-1,15973,15975,16151,-1,16151,16378,15973,-1,16378,16151,16134,-1,16134,16379,16378,-1,15979,16379,16134,-1,16134,15977,15979,-1,16380,16381,16382,-1,16382,16383,16380,-1,16381,16380,16384,-1,16384,16385,16381,-1,16386,16382,16381,-1,16381,15994,16386,-1,16382,16387,15982,-1,15982,16383,16382,-1,16383,16388,16389,-1,16389,16380,16383,-1,16390,16388,16383,-1,16383,15982,16390,-1,16388,16390,16391,-1,16391,16392,16388,-1,16393,16390,15982,-1,15982,15981,16393,-1,16391,16390,16393,-1,16393,16394,16391,-1,16395,16393,15981,-1,15981,16396,16395,-1,16394,16393,16395,-1,16395,16397,16394,-1,15981,15983,16398,-1,16398,16396,15981,-1,16399,16395,16396,-1,16396,16400,16399,-1,16397,16395,16399,-1,16399,16401,16397,-1,16396,16398,16373,-1,16373,16400,16396,-1,16402,16399,16400,-1,16400,15971,16402,-1,16402,16403,16401,-1,16401,16399,16402,-1,16400,16373,15972,-1,15972,15971,16400,-1,15973,16404,16402,-1,16402,15971,15973,-1,16405,16404,15973,-1,15973,16378,16405,-1,16403,16402,16404,-1,16404,16406,16403,-1,15985,15984,16346,-1,16346,15924,15985,-1,15961,15986,15985,-1,15985,16059,15961,-1,16407,15984,15986,-1,15986,16408,16407,-1,15960,15963,15986,-1,15986,15961,15960,-1,16409,16410,15990,-1,15990,15992,16409,-1,16411,15988,16410,-1,16410,16409,16411,-1,16412,15990,16410,-1,16410,16413,16412,-1,16414,16409,15992,-1,15992,16415,16414,-1,16414,16416,16411,-1,16411,16409,16414,-1,15991,16386,16415,-1,16415,15992,15991,-1,16417,16414,16415,-1,16415,15993,16417,-1,16416,16414,16417,-1,16417,16418,16416,-1,16415,16386,15994,-1,15994,15993,16415,-1,16419,16417,15993,-1,15993,15995,16419,-1,16420,16418,16417,-1,16417,16419,16420,-1,16385,16421,16419,-1,16419,15995,16385,-1,16422,15964,15590,-1,15590,15591,16422,-1,16372,16423,15963,-1,15963,15966,16372,-1,16423,16372,16424,-1,16424,16425,16423,-1,16423,16426,16427,-1,16427,15963,16423,-1,15978,15980,16428,-1,16428,16429,15978,-1,15978,16430,16431,-1,16431,15979,15978,-1,15980,15968,16377,-1,16377,16428,15980,-1,16429,16428,16432,-1,16432,16343,16429,-1,16429,16341,16430,-1,16430,15978,16429,-1,16428,16377,16420,-1,16420,16432,16428,-1,16343,16432,16421,-1,16421,16342,16343,-1,16343,16335,16341,-1,16341,16429,16343,-1,16432,16420,16419,-1,16419,16421,16432,-1,16342,16421,16385,-1,16385,16384,16342,-1,16384,16336,16332,-1,16332,16342,16384,-1,16389,16433,16337,-1,16337,16336,16389,-1,16388,16392,16433,-1,16433,16389,16388,-1,16344,16337,16433,-1,16433,16434,16344,-1,16380,16389,16336,-1,16336,16384,16380,-1,15994,16381,16385,-1,16385,15995,15994,-1,16374,15989,15988,-1,15988,16411,16374,-1,15988,15987,16413,-1,16413,16410,15988,-1,16377,16376,16418,-1,16418,16420,16377,-1,16375,16374,16411,-1,16411,16416,16375,-1,16376,16375,16416,-1,16416,16418,16376,-1,15979,16431,16435,-1,16435,16379,15979,-1,16436,16347,16344,-1,16344,16434,16436,-1,16407,16430,16341,-1,16341,16340,16407,-1,16408,16431,16430,-1,16430,16407,16408,-1,15984,16407,16340,-1,16340,16346,15984,-1,16330,16059,15985,-1,15985,15924,16330,-1,15996,16000,16002,-1,16002,15997,15996,-1,16437,16438,15998,-1,15998,15997,16437,-1,16009,16008,16001,-1,16001,16000,16009,-1,16001,16439,16440,-1,16440,16002,16001,-1,16405,16426,16406,-1,16406,16404,16405,-1,16379,16435,16405,-1,16405,16378,16379,-1,16405,16435,16427,-1,16427,16426,16405,-1,16398,16413,15987,-1,15987,16373,16398,-1,15983,16412,16413,-1,16413,16398,15983,-1,16441,16397,16401,-1,16401,16442,16441,-1,16005,16060,15942,-1,15942,15941,16005,-1,16010,16061,16060,-1,16060,16005,16010,-1,16003,16005,15941,-1,15941,16007,16003,-1,16007,16436,16443,-1,16443,16003,16007,-1,16444,16443,16436,-1,16436,16434,16444,-1,16445,16443,16444,-1,16444,16446,16445,-1,16392,16444,16434,-1,16434,16433,16392,-1,16392,16391,16446,-1,16446,16444,16392,-1,15991,16387,16382,-1,16382,16386,15991,-1,16006,16347,16436,-1,16436,16007,16006,-1,16003,16443,16445,-1,16445,16004,16003,-1,16445,16446,16447,-1,16447,16448,16445,-1,16387,15991,15990,-1,15990,16412,16387,-1,15982,16387,16412,-1,16412,15983,15982,-1,16446,16391,16394,-1,16394,16447,16446,-1,16447,16394,16397,-1,16397,16441,16447,-1,16448,16447,16441,-1,16441,16449,16448,-1,16448,16439,16004,-1,16004,16445,16448,-1,16008,16004,16439,-1,16439,16001,16008,-1,16010,16005,16004,-1,16004,16008,16010,-1,16450,16009,16000,-1,16000,15996,16450,-1,16449,16440,16439,-1,16439,16448,16449,-1,16449,16451,16452,-1,16452,16440,16449,-1,16403,16453,16442,-1,16442,16401,16403,-1,16449,16441,16442,-1,16442,16451,16449,-1,16454,16452,16451,-1,16451,16455,16454,-1,16002,16440,16452,-1,16452,16054,16002,-1,16055,16054,16452,-1,16452,16454,16055,-1,16453,16455,16451,-1,16451,16442,16453,-1,16454,16455,16424,-1,16424,16456,16454,-1,16011,16457,16458,-1,16458,16012,16011,-1,16459,16013,16012,-1,16012,16460,16459,-1,16048,16011,16013,-1,16013,16461,16048,-1,16011,16048,16047,-1,16047,16457,16011,-1,16462,16458,16457,-1,16457,16015,16462,-1,16460,16012,16458,-1,16458,16463,16460,-1,16458,16462,16464,-1,16464,16463,16458,-1,16015,16457,16047,-1,16047,16016,16015,-1,16015,16014,16465,-1,16465,16462,16015,-1,16014,16466,16467,-1,16467,16465,16014,-1,16464,16462,16465,-1,16465,16468,16464,-1,16469,16466,16014,-1,16014,16016,16469,-1,16466,16009,16450,-1,16450,16467,16466,-1,16465,16467,16470,-1,16470,16468,16465,-1,16469,16010,16009,-1,16009,16466,16469,-1,16467,16450,16471,-1,16471,16470,16467,-1,16450,15996,15999,-1,15999,16471,16450,-1,16453,16403,16406,-1,16406,16425,16453,-1,16425,16406,16426,-1,16426,16423,16425,-1,16455,16453,16425,-1,16425,16424,16455,-1,15998,16438,16472,-1,16472,15999,15998,-1,16473,16018,16017,-1,16017,16474,16473,-1,16019,16018,16475,-1,16475,16476,16019,-1,16477,16017,16019,-1,16019,16066,16477,-1,16018,16473,16478,-1,16478,16475,16018,-1,16477,16479,16474,-1,16474,16017,16477,-1,16480,16473,16474,-1,16474,16481,16480,-1,16478,16473,16480,-1,16480,16044,16478,-1,16474,16479,16482,-1,16482,16481,16474,-1,16481,16471,15999,-1,15999,16480,16481,-1,16481,16482,16470,-1,16470,16471,16481,-1,16044,16480,15999,-1,15999,16472,16044,-1,16483,16472,16438,-1,16438,16484,16483,-1,16019,16058,16057,-1,16057,16066,16019,-1,16477,16066,16065,-1,16065,16485,16477,-1,16486,16487,16488,-1,16488,16489,16486,-1,16149,16148,16487,-1,16487,16486,16149,-1,16490,16488,16487,-1,16487,16491,16490,-1,16488,16492,16056,-1,16056,16489,16488,-1,16493,16486,16489,-1,16489,16494,16493,-1,16026,16149,16486,-1,16486,16493,16026,-1,16489,16056,16058,-1,16058,16494,16489,-1,16495,16493,16494,-1,16494,16476,16495,-1,16493,16495,16024,-1,16024,16026,16493,-1,16494,16058,16019,-1,16019,16476,16494,-1,16496,16495,16476,-1,16476,16475,16496,-1,16024,16495,16496,-1,16496,16027,16024,-1,16497,16496,16475,-1,16475,16478,16497,-1,16498,16464,16468,-1,16468,16499,16498,-1,16463,16464,16498,-1,16498,16500,16463,-1,16482,16499,16468,-1,16468,16470,16482,-1,16501,16498,16499,-1,16499,16502,16501,-1,16500,16498,16501,-1,16501,16503,16500,-1,16482,16479,16502,-1,16502,16499,16482,-1,16504,16501,16502,-1,16502,16485,16504,-1,16503,16501,16504,-1,16504,16505,16503,-1,16485,16502,16479,-1,16479,16477,16485,-1,16020,16504,16485,-1,16485,16065,16020,-1,16505,16504,16020,-1,16020,16023,16505,-1,16021,16020,16065,-1,16065,16492,16021,-1,16492,16065,16057,-1,16057,16056,16492,-1,16492,16488,16490,-1,16490,16021,16492,-1,16506,16023,16022,-1,16022,16507,16506,-1,16506,16508,16505,-1,16505,16023,16506,-1,16021,16490,16507,-1,16507,16022,16021,-1,16509,16506,16507,-1,16507,16510,16509,-1,16024,16028,16029,-1,16029,16025,16024,-1,16031,16037,16511,-1,16511,16032,16031,-1,16032,16038,16034,-1,16034,16033,16032,-1,16148,16035,16491,-1,16491,16487,16148,-1,16512,16513,16049,-1,16049,16514,16512,-1,16515,16516,16513,-1,16513,16512,16515,-1,16049,16513,16517,-1,16517,16050,16049,-1,16049,16051,16518,-1,16518,16514,16049,-1,16519,16512,16514,-1,16514,16511,16519,-1,16520,16515,16512,-1,16512,16519,16520,-1,16518,16521,16511,-1,16511,16514,16518,-1,16519,16511,16037,-1,16037,16150,16519,-1,16521,16038,16032,-1,16032,16511,16521,-1,16521,16052,16039,-1,16039,16038,16521,-1,16509,16522,16508,-1,16508,16506,16509,-1,16491,16510,16507,-1,16507,16490,16491,-1,16039,16509,16510,-1,16510,16034,16039,-1,16053,16522,16509,-1,16509,16039,16053,-1,16491,16035,16034,-1,16034,16510,16491,-1,16372,16371,16456,-1,16456,16424,16372,-1,16523,16371,15964,-1,15964,16422,16523,-1,16371,16523,16524,-1,16524,16456,16371,-1,16525,16523,16422,-1,16422,16526,16525,-1,16526,16527,16528,-1,16528,16525,16526,-1,16529,16530,16527,-1,16527,16526,16529,-1,16531,16528,16527,-1,16527,16532,16531,-1,16525,16528,16042,-1,16042,16041,16525,-1,16528,16531,16533,-1,16533,16042,16528,-1,16534,16532,16527,-1,16527,16530,16534,-1,16531,16532,16535,-1,16535,16536,16531,-1,16537,16036,16029,-1,16029,16030,16537,-1,16520,16139,16036,-1,16036,16537,16520,-1,16519,16150,16139,-1,16139,16520,16519,-1,16055,16454,16456,-1,16456,16524,16055,-1,16524,16041,16040,-1,16040,16055,16524,-1,16538,16040,16042,-1,16042,16533,16538,-1,16437,16054,16040,-1,16040,16538,16437,-1,16533,16539,16484,-1,16484,16538,16533,-1,16540,16539,16536,-1,16536,16541,16540,-1,16483,16484,16539,-1,16539,16540,16483,-1,16531,16536,16539,-1,16539,16533,16531,-1,16536,16535,16516,-1,16516,16541,16536,-1,16542,16540,16541,-1,16541,16543,16542,-1,16483,16540,16542,-1,16542,16045,16483,-1,16541,16516,16515,-1,16515,16543,16541,-1,16544,16542,16543,-1,16543,16537,16544,-1,16496,16497,16545,-1,16545,16027,16496,-1,16043,16497,16478,-1,16478,16044,16043,-1,16497,16043,16544,-1,16544,16545,16497,-1,16483,16045,16044,-1,16044,16472,16483,-1,16546,16460,16463,-1,16463,16500,16546,-1,16460,16546,16547,-1,16547,16459,16460,-1,16548,16546,16500,-1,16500,16503,16548,-1,16549,16547,16546,-1,16546,16548,16549,-1,16508,16548,16503,-1,16503,16505,16508,-1,16522,16549,16548,-1,16548,16508,16522,-1,15596,16070,16550,-1,16550,15466,15596,-1,15610,16461,16068,-1,16068,15608,15610,-1,16461,15610,15612,-1,15612,16048,16461,-1,16461,16013,16551,-1,16551,16068,16461,-1,16070,15596,15608,-1,15608,16068,16070,-1,16070,16069,16552,-1,16552,16550,16070,-1,15466,16550,16529,-1,16529,15456,15466,-1,16550,16552,16530,-1,16530,16529,16550,-1,16526,15457,15456,-1,15456,16529,16526,-1,16534,16553,16050,-1,16050,16517,16534,-1,16552,16553,16534,-1,16534,16530,16552,-1,16553,16554,16555,-1,16555,16050,16553,-1,16535,16532,16534,-1,16534,16517,16535,-1,16069,16554,16553,-1,16553,16552,16069,-1,16556,16555,16554,-1,16554,16551,16556,-1,16050,16555,16557,-1,16557,16051,16050,-1,16558,16557,16555,-1,16555,16556,16558,-1,16051,16557,16559,-1,16559,16518,16051,-1,16516,16535,16517,-1,16517,16513,16516,-1,16557,16558,16560,-1,16560,16559,16557,-1,16521,16518,16559,-1,16559,16052,16521,-1,16053,16052,16559,-1,16559,16560,16053,-1,16549,16522,16053,-1,16053,16560,16549,-1,16549,16560,16558,-1,16558,16547,16549,-1,16556,16459,16547,-1,16547,16558,16556,-1,16551,16013,16459,-1,16459,16556,16551,-1,16561,16046,16048,-1,16048,15612,16561,-1,15612,15613,15490,-1,15490,16561,15612,-1,16027,16545,16030,-1,16030,16028,16027,-1,15591,15457,16526,-1,16526,16422,15591,-1,16537,16543,16515,-1,16515,16520,16537,-1,16545,16544,16537,-1,16537,16030,16545,-1,16043,16045,16542,-1,16542,16544,16043,-1,16538,16484,16438,-1,16438,16437,16538,-1,16523,16525,16041,-1,16041,16524,16523,-1,16408,15986,15963,-1,15963,16427,16408,-1,16427,16435,16431,-1,16431,16408,16427,-1,16059,16072,15957,-1,15957,15956,16059,-1,16062,16061,16562,-1,16562,16063,16062,-1,16562,16061,16010,-1,16010,16469,16562,-1,16563,16063,16562,-1,16562,16564,16563,-1,16562,16469,16016,-1,16016,16564,16562,-1,16016,16047,16046,-1,16046,16564,16016,-1,15940,16064,16006,-1,16006,15941,15940,-1,15848,15847,15931,-1,15931,15930,15848,-1,15848,15930,15625,-1,15625,15624,15848,-1,16561,15490,15489,-1,15489,16563,16561,-1,15489,15630,16063,-1,16063,16563,15489,-1,16563,16564,16046,-1,16046,16561,16563,-1,15997,16002,16054,-1,16054,16437,15997,-1,16068,16551,16554,-1,16554,16069,16068,-1,16330,15923,16072,-1,16072,16059,16330,-1,16071,16367,15957,-1,15957,16072,16071,-1,15905,15950,15952,-1,15952,16565,15905,-1,15906,16318,15911,-1,15911,15904,15906,-1,16074,16566,16567,-1,16567,16075,16074,-1,16568,16569,16566,-1,16566,16074,16568,-1,16566,16570,16571,-1,16571,16567,16566,-1,16572,16075,16567,-1,16567,16573,16572,-1,16574,16568,16074,-1,16074,16073,16574,-1,16575,16073,16075,-1,16075,16572,16575,-1,16156,16157,16362,-1,16362,16576,16156,-1,16368,16369,16576,-1,16576,16362,16368,-1,16079,16156,16576,-1,16576,16078,16079,-1,16577,16078,16576,-1,16576,16369,16577,-1,16577,16578,16076,-1,16076,16078,16577,-1,16570,16077,16076,-1,16076,16571,16570,-1,16091,16090,16080,-1,16080,16077,16091,-1,16091,16077,16570,-1,16570,16089,16091,-1,16579,16571,16076,-1,16076,16578,16579,-1,16569,16089,16570,-1,16570,16566,16569,-1,16573,16567,16571,-1,16571,16579,16573,-1,16580,16368,16362,-1,16362,16360,16580,-1,16368,16580,16565,-1,16565,15952,16368,-1,16581,16580,16360,-1,16360,16361,16581,-1,16580,16581,16582,-1,16582,16565,16580,-1,16583,16581,16361,-1,16361,16584,16583,-1,16581,16583,16585,-1,16585,16582,16581,-1,16358,16586,16584,-1,16584,16361,16358,-1,16351,16583,16584,-1,16584,16587,16351,-1,16585,16583,16351,-1,16351,16349,16585,-1,16586,16588,16587,-1,16587,16584,16586,-1,16350,16351,16587,-1,16587,16352,16350,-1,16588,16589,16352,-1,16352,16587,16588,-1,16589,16590,16353,-1,16353,16352,16589,-1,16311,16317,16353,-1,16353,16591,16311,-1,16591,16353,16590,-1,16590,16592,16591,-1,16312,16311,16591,-1,16591,16593,16312,-1,16592,16594,16593,-1,16593,16591,16592,-1,16312,16593,16073,-1,16073,16575,16312,-1,16589,16595,16082,-1,16082,16590,16589,-1,16596,16595,16589,-1,16589,16588,16596,-1,16597,16083,16082,-1,16082,16595,16597,-1,16592,16590,16082,-1,16082,16081,16592,-1,16598,16081,16083,-1,16083,16599,16598,-1,16600,16601,16602,-1,16602,16603,16600,-1,16356,16601,16600,-1,16600,15945,16356,-1,16087,16604,16602,-1,16602,16601,16087,-1,16602,16085,16599,-1,16599,16603,16602,-1,16603,16597,16605,-1,16605,16600,16603,-1,16598,16599,16085,-1,16085,16084,16598,-1,16604,16086,16085,-1,16085,16602,16604,-1,16084,16086,16568,-1,16568,16574,16084,-1,16091,16089,16088,-1,16088,15777,16091,-1,16606,16329,16579,-1,16579,16578,16606,-1,16071,15923,16329,-1,16329,16606,16071,-1,16573,16579,16329,-1,16329,16328,16573,-1,16578,16577,16366,-1,16366,16606,16578,-1,16572,16573,16328,-1,16328,16331,16572,-1,16574,16594,16598,-1,16598,16084,16574,-1,16594,16592,16081,-1,16081,16598,16594,-1,16574,16073,16593,-1,16593,16594,16574,-1,16089,16569,16604,-1,16604,16087,16089,-1,16086,16604,16569,-1,16569,16568,16086,-1,16575,16313,16308,-1,16308,16312,16575,-1,16575,16572,16331,-1,16331,16313,16575,-1,15906,15905,16565,-1,16565,16582,15906,-1,16582,16585,16318,-1,16318,15906,16582,-1,16364,16366,16577,-1,16577,16369,16364,-1,16606,16366,16367,-1,16367,16071,16606,-1,16585,16349,16319,-1,16319,16318,16585,-1,16603,16599,16083,-1,16083,16597,16603,-1,16605,16597,16595,-1,16595,16596,16605,-1,15945,16600,16605,-1,16605,15946,15945,-1,16088,16087,16601,-1,16601,16356,16088,-1,16356,16165,15777,-1,15777,16088,16356,-1,16354,16357,16586,-1,16586,16358,16354,-1,16357,16596,16588,-1,16588,16586,16357,-1,15946,16605,16596,-1,16596,16357,15946,-1,16094,15782,15787,-1,15787,16607,16094,-1,16608,16607,15787,-1,15787,16092,16608,-1,16609,16607,16608,-1,16608,16103,16609,-1,16608,16092,16175,-1,16175,16610,16608,-1,16174,16219,15786,-1,15786,15784,16174,-1,16609,16097,16094,-1,16094,16607,16609,-1,16096,16611,16168,-1,16168,16093,16096,-1,16611,16612,16172,-1,16172,16168,16611,-1,16612,15826,16174,-1,16174,16172,16612,-1,16610,16175,16099,-1,16099,16100,16610,-1,16219,16100,16098,-1,16098,15786,16219,-1,16101,16232,16613,-1,16613,16102,16101,-1,16614,16609,16103,-1,16103,16102,16614,-1,16103,16608,16615,-1,16615,16101,16103,-1,16610,16100,16221,-1,16221,16616,16610,-1,16608,16610,16616,-1,16616,16615,16608,-1,16231,16232,16101,-1,16101,16615,16231,-1,16223,16617,16616,-1,16616,16221,16223,-1,16617,16231,16615,-1,16615,16616,16617,-1,16104,16217,16216,-1,16216,16105,16104,-1,16106,16105,16107,-1,16107,16618,16106,-1,16106,16200,16199,-1,16199,16104,16106,-1,16200,16106,16618,-1,16618,15822,16200,-1,16217,16104,16199,-1,16199,15831,16217,-1,16199,15817,15825,-1,15825,15831,16199,-1,16619,16207,15822,-1,15822,16618,16619,-1,16620,16619,16618,-1,16618,16107,16620,-1,16621,16108,16105,-1,16105,16216,16621,-1,16108,16622,16620,-1,16620,16107,16108,-1,16621,16623,16622,-1,16622,16108,16621,-1,16622,16624,16625,-1,16625,16620,16622,-1,16624,16622,16623,-1,16623,16626,16624,-1,16624,16110,16109,-1,16109,16625,16624,-1,16619,16620,16625,-1,16625,16627,16619,-1,16628,16110,16624,-1,16624,16626,16628,-1,16109,16629,16627,-1,16627,16625,16109,-1,16110,16628,16630,-1,16630,16111,16110,-1,16111,16631,16629,-1,16629,16109,16111,-1,16631,16111,16630,-1,16630,16632,16631,-1,16631,16633,16203,-1,16203,16629,16631,-1,16097,16609,16614,-1,16614,16112,16097,-1,16630,16628,16095,-1,16095,16112,16630,-1,16096,16095,16628,-1,16628,16626,16096,-1,16626,16623,16611,-1,16611,16096,16626,-1,16612,16611,16623,-1,16623,16621,16612,-1,15826,16612,16621,-1,16621,16216,15826,-1,16629,16203,16204,-1,16204,16627,16629,-1,16207,16619,16627,-1,16627,16204,16207,-1,16633,16205,16202,-1,16202,16203,16633,-1,16205,16634,15856,-1,15856,15855,16205,-1,16205,16633,16635,-1,16635,16634,16205,-1,16634,16613,15838,-1,15838,15856,16634,-1,16633,16631,16632,-1,16632,16635,16633,-1,16102,16613,16634,-1,16634,16635,16102,-1,15838,16613,16232,-1,16232,15837,15838,-1,16214,16233,16636,-1,16636,16215,16214,-1,16233,16228,16230,-1,16230,16636,16233,-1,16223,16222,16215,-1,16215,16636,16223,-1,16223,16636,16230,-1,16230,16617,16223,-1,16230,16229,16231,-1,16231,16617,16230,-1,16632,16614,16102,-1,16102,16635,16632,-1,16614,16632,16630,-1,16630,16112,16614,-1],creaseAngle=1.5,
          coord=Coordinate(DEF='body_Coord',point=[(-.055,3.856,-5.206),(-.014,4.976,-5.188),(-.014,3.856,-5.206),(-.314,3.459,3.327),(-.014,2.391,3.111),(-.014,3.381,3.323),(-.014,-.277,-.997),(-.043,-.188,-1.386),(-.014,-.19,-1.387),(-4.944,4.824,2.34),(-4.722,4.961,2.405),(-5.015,5.678,2.416),(-4.751,5.658,2.547),(-4.532,4.531,2.426),(-1.504,7.743,-4.274),(-1.413,8.169,-4.188),(-.963,7.998,-4.265),(-2.98,6.958,-4.71),(-3.229,6.058,-5.221),(-3.744,6.138,-5.06),(-4.347,6.247,-4.834),(-4.92,6.273,-4.499),(-4.745,6.949,-4.329),(-5.327,6.289,-4.011),(-4.654,7.347,-3.995),(-5.255,7.379,-3.564),(-4.942,8.077,-3.274),(-5.662,7.929,-2.18),(-5.644,8.092,-2.161),(-5.643,6.29,-3.582),(-.251,6.433,-4.785),(-.014,6.118,-4.924),(-.339,5.73,-5.087),(-4.366,6.986,2.827),(-4.762,7.048,2.682),(-4.67,6.701,2.59),(-5.583,5.283,1.937),(-5.671,4.429,1.808),(-5.276,4.302,2.188),(-.497,4.91,3.565),(-.249,6.644,3.777),(-.769,6.679,3.77),(-5.364,6.736,2.012),(-5.218,6.638,2.282),(-5.375,7.431,2.259),(-5.222,6.545,2.292),(-6.18,6.847,-1.133),(-5.914,7.826,-1.017),(-5.894,7.874,-1.256),(-4.884,5.827,2.504),(-4.713,6.385,2.598),(-5.456,6.257,2.017),(-5.817,6.977,1.151),(-5.471,6.092,1.991),(-5.813,7.2,1.122),(-5.396,6.621,2.024),(-4.704,6.046,2.601),(-4.963,6.269,2.464),(-4.863,6.084,2.517),(-2.273,6.824,3.385),(-2.47,6.854,3.289),(-2.076,5.321,3.387),(-3.85,4.203,2.544),(-4.021,4.691,2.563),(-1.531,.409,1.949),(-1.627,.432,1.99),(-1.359,.147,1.819),(-2.764,4.762,3.022),(-3.607,5.294,2.827),(-3.524,4.832,2.728),(-3.445,4.419,2.642),(-3.333,3.989,2.571),(-2.993,3.786,2.577),(-2.77,3.946,2.702),(-.26,4.768,-5.438),(-.828,4.071,-5.928),(-.57,5.117,-5.562),(-1.054,3.553,-6.057),(-1.494,3.215,-6.26),(-1.363,3.824,-6.132),(-.465,5.412,-5.399),(-1.508,6.91,-4.671),(-1.943,6.647,-4.972),(-1.964,6.872,-4.737),(-.897,6.528,-4.887),(-.944,6.118,-5.294),(-.175,-.574,-1.699),(-.349,-.855,-1.861),(-.378,-.873,-2.045),(-.838,-1.349,-2.11),(-1.395,-1.724,-2.92),(-.826,-1.286,-2.239),(-.793,-1.226,-2.38),(-.211,1.625,-5.302),(-.334,1.053,-5.244),(-.555,1.628,-5.761),(-1.074,.791,-5.849),(-1.328,1.366,-6.106),(-.808,1.119,-5.776),(-.588,3.153,-5.883),(-.095,1.608,-5.083),(-.118,2.458,-5.319),(-1.001,-.055,-5.349),(-.731,.216,-5.273),(-.074,1.869,-4.883),(-.097,1.771,-4.965),(-.094,2.47,-5.179),(-.563,-.719,-3.748),(-1.079,-1.063,-4.155),(-.592,-.514,-4.175),(-.784,-1.185,-2.483),(-1.534,-1.651,-3.211),(-.742,-1.13,-2.735),(-.205,-.566,-1.275),(-.206,-.535,-.982),(-.25,-.626,-.879),(-.091,1.225,-4.892),(-.091,1.432,-4.758),(-.087,.964,-4.451),(-.111,-.394,-1.351),(-.094,-.356,-1.468),(-.093,-.369,-1.352),(-.207,.791,-4.83),(-.444,-.246,.304),(-.249,-.42,-.17),(-.423,-.268,.317),(-1.877,3.814,3.068),(-1.233,2.634,2.874),(-1.533,3.734,3.204),(-2.859,3.815,2.63),(-2.044,2.827,2.516),(-2.422,3.934,2.847),(-2.08,2.495,2.398),(-2.368,3.039,2.501),(-1.74,1.296,2.204),(-2.112,2.271,2.318),(-1.81,1.326,2.188),(-.609,-.472,.591),(-.535,-.384,.317),(-.7,-.307,.824),(-2.18,2.306,2.318),(-2.584,3.153,2.485),(-1.409,.668,2.087),(-1.189,.702,2.098),(-1.509,.923,2.145),(-.61,-.174,.767),(-.583,-.202,.739),(-.068,.954,-4.318),(-.126,.705,-4.362),(-.831,-.153,1.222),(-.853,-.087,1.262),(-1.064,.019,1.557),(-.149,1.008,-4.863),(-.937,-.148,1.378),(-.296,-.766,-.851),(-.32,-.871,-.829),(-.342,-.882,-1.316),(-1.041,3.186,-6.071),(-1.973,.456,2.168),(-1.836,.289,2.106),(-1.791,1.214,-6.256),(-1.738,1.941,-6.387),(-1.146,1.763,-6.063),(-1.783,1.025,2.139),(-1.885,1.355,2.194),(-2.043,1.469,2.25),(-1.562,.65,2.035),(-1.686,.988,2.11),(-1.859,-.504,2.085),(-1.833,-.145,2.073),(-2.176,-.182,2.26),(-.594,.101,2.209),(-.47,-.263,1.858),(-.471,.071,2.2),(-1.101,.535,1.999),(-1.013,.368,1.9),(.027,3.856,-5.206),(.286,3.459,3.327),(.015,-.187,-1.399),(4.987,5.678,2.417),(4.694,4.971,2.405),(4.918,4.821,2.343),(4.723,5.658,2.549),(4.504,4.541,2.428),(.935,7.998,-4.265),(1.385,8.169,-4.188),(1.476,7.743,-4.274),(3.716,6.136,-5.056),(3.201,6.043,-5.224),(2.952,6.956,-4.708),(4.717,6.947,-4.327),(4.892,6.271,-4.496),(4.319,6.233,-4.837),(5.298,6.278,-4.016),(4.914,8.076,-3.274),(5.227,7.378,-3.563),(4.626,7.346,-3.993),(5.616,8.092,-2.161),(5.634,7.929,-2.18),(5.614,6.289,-3.58),(.311,5.73,-5.087),(.223,6.433,-4.785),(4.642,6.702,2.591),(4.734,7.048,2.683),(4.338,6.986,2.828),(5.248,4.311,2.19),(5.642,4.437,1.809),(5.559,5.287,1.934),(.741,6.679,3.77),(.221,6.644,3.777),(.468,4.91,3.565),(5.347,7.431,2.259),(5.19,6.638,2.282),(5.336,6.736,2.012),(5.194,6.545,2.293),(5.866,7.874,-1.256),(5.886,7.826,-1.017),(6.152,6.847,-1.133),(4.856,5.837,2.499),(4.685,6.386,2.599),(5.443,6.092,1.992),(5.789,6.977,1.151),(5.428,6.257,2.018),(5.368,6.621,2.024),(5.785,7.2,1.122),(4.935,6.28,2.458),(4.676,6.046,2.602),(4.835,6.084,2.519),(2.048,5.305,3.381),(2.442,6.854,3.289),(2.245,6.824,3.385),(3.993,4.701,2.565),(3.821,4.213,2.547),(1.319,.129,1.784),(1.588,.438,1.99),(1.491,.407,1.938),(3.496,4.832,2.731),(3.579,5.294,2.829),(2.735,4.75,3.027),(2.965,3.785,2.58),(3.305,3.988,2.575),(3.417,4.419,2.645),(2.742,3.946,2.705),(.542,5.117,-5.562),(.8,4.117,-5.945),(.231,4.768,-5.438),(1.335,3.872,-6.13),(1.466,3.214,-6.255),(1.026,3.645,-6.087),(.437,5.412,-5.399),(1.936,6.902,-4.728),(1.915,6.658,-4.962),(1.48,6.927,-4.67),(.916,6.118,-5.294),(.869,6.528,-4.887),(.354,-.885,-2.011),(.325,-.869,-1.812),(.149,-.552,-1.837),(.787,-1.287,-2.217),(1.391,-1.747,-2.892),(.814,-1.359,-2.086),(.77,-1.242,-2.342),(.527,1.755,-5.838),(.306,1.18,-5.342),(.183,1.687,-5.348),(.78,1.089,-5.756),(1.3,1.334,-6.086),(1.046,.761,-5.826),(.56,3.211,-5.911),(.09,2.467,-5.334),(.067,1.646,-5.105),(.703,.189,-5.248),(.973,-.082,-5.321),(.066,2.48,-5.194),(.069,1.803,-4.993),(.046,1.888,-4.904),(.575,-.535,-4.156),(1.062,-1.084,-4.132),(.545,-.747,-3.714),(.705,-1.132,-2.713),(1.531,-1.681,-3.166),(.746,-1.191,-2.445),(.223,-.626,-1.075),(.179,-.532,-1.133),(.179,-.553,-1.441),(.059,.996,-4.479),(.063,1.466,-4.782),(.063,1.261,-4.918),(.066,-.363,-1.431),(.068,-.349,-1.534),(.084,-.388,-1.431),(.179,.886,-4.908),(.392,-.309,.162),(.219,-.442,-.318),(.416,-.286,.161),(1.504,3.722,3.191),(1.205,2.613,2.859),(1.849,3.778,3.052),(2.831,3.814,2.633),(2.394,3.91,2.849),(2.016,2.794,2.507),(2.34,3.027,2.5),(2.052,2.473,2.391),(1.782,1.305,2.172),(2.084,2.259,2.314),(1.712,1.265,2.18),(.667,-.38,.627),(.503,-.431,.131),(.577,-.534,.387),(2.556,3.152,2.487),(2.152,2.294,2.314),(1.481,.884,2.108),(1.161,.601,1.984),(1.381,.62,2.037),(.555,-.262,.584),(.582,-.235,.613),(.097,.757,-4.413),(.04,.974,-4.337),(1.036,-.057,1.435),(.825,-.179,1.086),(.803,-.243,1.043),(.121,1.067,-4.908),(.908,-.252,1.185),(.315,-.853,-1.611),(.292,-.871,-1.095),(.268,-.766,-1.096),(1.013,3.293,-6.11),(1.808,.305,2.13),(1.934,.49,2.201),(1.71,1.907,-6.37),(1.763,1.181,-6.235),(1.118,1.731,-6.046),(2.015,1.467,2.252),(1.857,1.353,2.195),(1.755,1.014,2.13),(1.658,.968,2.092),(1.534,.63,2.015),(2.161,-.161,2.3),(1.805,-.119,2.112),(1.837,-.487,2.12),(.443,.053,2.175),(.433,-.306,1.781),(.566,.053,2.148),(.985,.274,1.777),(1.073,.438,1.881),(-.189,7.591,-4.338),(-.014,7.501,-4.372),(-.116,4.889,-5.281),(-.014,-.187,-1.408),(-.048,-.187,-1.395),(-.042,-.129,-1.786),(-.014,-.13,-1.787),(-.041,-.049,-2.661),(-.014,-.049,-2.661),(-.047,.558,-3.797),(-.014,.568,-3.808),(-.047,.986,-4.233),(-.014,.984,-4.232),(-.046,1.49,-4.586),(-.014,1.49,-4.586),(-.047,1.897,-4.837),(-.014,1.909,-4.844),(-.054,2.488,-5.149),(-.014,2.488,-5.149),(-.014,4.84,3.579),(-.014,6.626,3.779),(-.014,3.927,3.431),(-.381,4.028,3.427),(-.053,-.319,-1.068),(-.014,-.453,-.162),(-.162,-.442,-.175),(-.014,-.524,.185),(-.243,-.497,.264),(-.632,2.515,3.03),(-.473,1.809,2.846),(-.014,1.812,2.916),(-5.279,5.808,2.3),(-5.243,5.008,2.254),(-.881,6.99,-4.66),(-1.389,7.159,-4.537),(-1.72,7.282,-4.412),(-1.738,7.565,-4.295),(-1.964,8.005,-4.11),(-1.922,8.328,-4.032),(-2.772,8.501,-3.899),(-2.417,7.953,-4.107),(-1.952,7.726,-4.195),(-2.172,7.667,-4.201),(-2.213,7.41,-4.271),(-2.549,7.507,-4.204),(-1.947,7.354,-4.29),(-2.82,7.611,-4.156),(-2.153,7.205,-4.446),(-2.467,7.12,-4.504),(-1.793,7.125,-4.517),(-3.46,4.894,-5.663),(-3.963,4.9,-5.404),(-2.032,5.854,-5.514),(-4.018,7.268,-4.352),(-2.971,1.133,-6.345),(-3.096,.4,-6.266),(-3.855,.46,-6.172),(-3.819,1.247,-6.209),(-3.73,2.709,-6.166),(-3.784,2.033,-6.24),(-4.167,2.133,-5.976),(-4.131,2.851,-5.853),(-4.532,4.909,-5.05),(-4.054,4.237,-5.578),(-3.574,4.22,-5.872),(-2.311,4.745,-5.926),(-3.658,3.481,-6.06),(-4.074,3.601,-5.711),(-4.665,3.161,-5.322),(-4.607,3.844,-5.228),(-2.432,4.099,-6.095),(-2.699,2.626,-6.369),(-2.803,2.023,-6.432),(-5.104,4.937,-4.422),(-4.591,4.302,-5.166),(-5.125,4.364,-4.462),(-5.51,4.97,-3.869),(-5.827,5.003,-3.41),(-3.764,7.85,-3.9),(-3.671,8.707,-3.634),(-4.823,8.827,-3.109),(-5.596,8.771,-2.141),(-5.917,7.999,-1.259),(-5.894,8.8,-1.326),(-5.948,7.28,-2.351),(-6.209,6.062,-2.435),(-6.466,5.626,-1.162),(-6.296,4.925,-2.373),(-6.61,4.602,-1.135),(-5.933,7.958,-.994),(-5.942,8.773,-.913),(-6.114,6.413,.199),(-6.222,5.068,.189),(-1.95,7.098,-4.541),(-4.15,6.155,2.81),(-5.879,5.843,1.183),(-5.274,5.992,2.323),(-1.731,6.735,3.614),(-1.336,5.158,3.483),(-2.803,6.899,3.239),(-3.419,6.948,3.095),(-3.113,5.703,3.136),(-2.455,5.43,3.293),(-3.732,5.94,2.947),(-3.998,6.956,2.953),(-5.917,8.05,1.177),(-6.032,8.529,.033),(-5.998,7.681,.065),(-5.966,7.529,.073),(-5.985,4.719,1.13),(-4.955,4.224,2.303),(-4.991,4.138,2.288),(-4.527,3.821,2.413),(-4.41,3.99,2.43),(-4.111,5.219,2.645),(-5.239,6.42,2.316),(-4.127,5.613,2.741),(-4.944,6.106,2.502),(-4.947,5.907,2.495),(-5.048,5.822,2.433),(-5.015,6.215,2.459),(-4.386,2.794,2.473),(-3.787,2.466,2.581),(-3.952,3.783,2.512),(-3.177,3.409,2.502),(-2.848,3.263,2.485),(-3.431,3.195,2.5),(-4.076,3.544,2.485),(-2.792,2.788,2.435),(-2.631,1.848,2.443),(-2.298,1.651,2.334),(-2.187,.768,2.292),(-2.563,1.29,2.436),(-3.121,1.484,2.61),(-2.64,.834,2.475),(-3.091,2.102,2.555),(-2.477,2.532,2.372),(-3.757,1.842,2.621),(-1.992,1.116,2.204),(-1.703,.67,2.078),(-1.005,-.318,1.405),(-1.581,.01,1.936),(-.087,-.314,-1.482),(-.079,-.266,-1.799),(-.097,-.159,-2.697),(-.125,-.385,-1.875),(-.13,-.443,-1.585),(-.173,-.507,-1.948),(-.067,-.32,-1.38),(-.075,.459,-3.789),(-.071,1.44,-4.631),(-.174,.451,-4.337),(-.118,.286,-3.777),(-.161,.114,-3.763),(-.139,-.274,-2.761),(-.175,-.394,-2.799),(-1.634,2.489,-6.335),(-1.846,.585,-6.14),(-2.068,-.313,-5.713),(-3.223,-.428,-5.907),(-1.229,4.444,-5.991),(-1.042,5.538,-5.596),(-.992,-.565,-4.833),(-2.34,-1.384,-4.913),(-2.194,-.898,-5.333),(-1.15,-1.348,-3.816),(-2.384,-1.706,-4.571),(-.657,-.179,-4.801),(-.347,-.844,-1.672),(-.198,-.548,-1.563),(-.328,-.795,-2.248),(-2.454,-1.984,-4.26),(-2.578,3.329,-6.292),(-1.05,2.359,-6.057),(-.466,2.303,-5.804),(-.097,3.817,-5.239),(-.142,3.758,-5.354),(-.564,.524,-5.24),(-.427,.145,-4.753),(-3.202,-.866,-5.657),(-.327,-.664,-2.994),(-.328,-.378,-3.659),(-.615,-.915,-3.356),(-.369,-.16,-4.166),(-.148,-.454,-1.348),(-.132,-.425,-1.497),(-.104,-.384,-1.027),(-.132,-.416,-1.015),(-.407,-1.128,-1.302),(-.845,-1.515,-2.008),(-.169,-.476,-.999),(-.337,-1.038,-.806),(-.323,-.508,.538),(-.951,3.647,3.266),(-1.111,4.273,3.363),(-1.805,4.528,3.298),(-2.166,4.616,3.184),(-.98,1.824,2.705),(-1.413,.438,1.9),(-1.275,.216,1.767),(-1.628,1.235,2.225),(-1.502,.635,2.044),(-1.621,.97,2.128),(-1.367,1.766,2.527),(-.327,-.519,-.148),(-.354,-.606,-.18),(-.382,-.826,-.138),(-.388,-.98,-.116),(-.31,-.474,-.169),(-.616,-.761,.631),(-1.078,-.731,1.483),(-1.047,-.935,1.449),(-.622,-.931,.649),(-.499,-.333,.304),(-.849,-.059,1.278),(-1.04,.072,1.584),(-.814,-.04,1.294),(-.974,.09,1.603),(-.666,-.213,.755),(-.638,-.173,.766),(-1.227,.268,1.783),(-1.364,.46,1.924),(-1.155,.301,1.833),(-1.282,.485,1.96),(-.463,-.287,.277),(-.681,-.259,.8),(-.293,-.427,-.177),(-.911,.132,1.688),(-.788,-.054,1.305),(-1.478,1.45,2.397),(-1.362,1.092,2.256),(-2.218,1.177,2.299),(-1.894,.71,2.149),(-.61,-.604,.62),(-1.04,-.499,1.435),(-.37,-.713,-.161),(-3.032,.923,2.641),(-2.326,.468,2.333),(-2.125,.198,2.244),(-2.706,.51,2.509),(-2.477,.131,2.417),(-.418,-.424,1.228),(-.014,-.522,1.133),(-.014,-.369,1.778),(-.014,.021,2.226),(-.014,.437,2.443),(-.479,.48,2.399),(-.7,.535,2.346),(-.797,.978,2.483),(-.014,1.366,2.75),(-.48,1.392,2.673),(-.896,1.411,2.595),(-.479,.942,2.524),(-.014,.899,2.601),(-.014,-.601,.415),(.161,7.591,-4.338),(.088,4.889,-5.281),(.02,-.185,-1.42),(.014,-.127,-1.799),(.013,-.043,-2.673),(.019,.567,-3.807),(.019,.996,-4.243),(.018,1.501,-4.593),(.019,1.909,-4.844),(.026,2.488,-5.149),(.353,4.028,3.427),(.132,-.458,-.282),(.025,-.319,-1.094),(.211,-.526,.142),(.445,1.809,2.846),(.603,2.515,3.03),(5.218,5.014,2.253),(5.251,5.809,2.302),(1.361,7.159,-4.537),(.853,6.99,-4.66),(1.71,7.58,-4.289),(1.692,7.298,-4.407),(1.893,8.341,-4.022),(1.936,8.019,-4.101),(2.389,7.952,-4.106),(2.744,8.5,-3.898),(2.144,7.683,-4.195),(1.924,7.741,-4.188),(2.521,7.515,-4.192),(2.185,7.408,-4.27),(1.919,7.37,-4.285),(2.792,7.619,-4.144),(2.439,7.129,-4.492),(2.125,7.215,-4.434),(1.765,7.142,-4.514),(3.934,4.885,-5.4),(3.432,4.878,-5.66),(2.004,5.867,-5.506),(3.99,7.266,-4.35),(3.799,1.214,-6.186),(3.837,.428,-6.145),(3.078,.364,-6.24),(2.943,1.101,-6.323),(4.106,2.821,-5.838),(4.144,2.103,-5.958),(3.761,2,-6.221),(3.702,2.677,-6.151),(4.504,4.895,-5.047),(3.546,4.203,-5.866),(4.026,4.221,-5.571),(2.282,4.743,-5.921),(4.045,3.586,-5.701),(3.63,3.465,-6.051),(4.579,3.831,-5.22),(4.639,3.149,-5.312),(2.404,4.082,-6.09),(2.775,1.99,-6.414),(2.671,2.593,-6.355),(5.079,4.922,-4.42),(5.096,4.341,-4.459),(4.565,4.287,-5.16),(5.486,4.956,-3.868),(5.799,4.994,-3.411),(3.643,8.706,-3.634),(3.736,7.848,-3.899),(4.795,8.827,-3.109),(5.567,8.771,-2.141),(5.866,8.8,-1.326),(5.889,7.999,-1.259),(5.919,7.28,-2.351),(6.188,6.055,-2.435),(6.443,5.62,-1.162),(6.268,4.92,-2.375),(6.582,4.602,-1.135),(5.914,8.773,-.913),(5.905,7.958,-.994),(6.194,5.068,.189),(6.085,6.413,.199),(1.922,7.115,-4.539),(4.122,6.156,2.812),(5.857,5.838,1.183),(5.246,5.993,2.324),(1.308,5.158,3.483),(1.703,6.735,3.614),(2.427,5.4,3.291),(3.084,5.703,3.137),(3.391,6.949,3.096),(2.775,6.882,3.242),(3.97,6.956,2.954),(3.704,5.94,2.948),(5.889,8.05,1.177),(5.97,7.681,.065),(6.003,8.529,.033),(5.938,7.529,.073),(5.959,4.719,1.129),(4.927,4.243,2.306),(4.501,3.832,2.418),(4.963,4.149,2.291),(4.383,3.999,2.434),(4.083,5.219,2.648),(5.211,6.42,2.316),(4.099,5.613,2.743),(4.919,5.918,2.49),(4.916,6.107,2.503),(5.02,5.822,2.435),(4.987,6.215,2.46),(3.764,2.483,2.593),(4.362,2.813,2.483),(3.924,3.792,2.517),(2.82,3.261,2.487),(3.149,3.418,2.507),(4.05,3.563,2.492),(3.403,3.203,2.506),(2.27,1.659,2.343),(2.596,1.872,2.457),(2.764,2.786,2.437),(2.612,.863,2.506),(3.101,1.5,2.627),(2.535,1.309,2.454),(2.159,.795,2.323),(3.063,2.131,2.575),(2.449,2.53,2.373),(3.736,1.859,2.637),(1.664,.667,2.069),(1.955,1.13,2.214),(1.553,.016,1.949),(.957,-.387,1.249),(.051,-.259,-1.838),(.059,-.308,-1.535),(.069,-.132,-2.76),(.149,-.479,-2.084),(.104,-.429,-1.693),(.1,-.367,-1.968),(.039,-.316,-1.419),(.047,.476,-3.811),(.043,1.463,-4.647),(.132,.174,-3.846),(.09,.33,-3.834),(.146,.524,-4.413),(.153,-.342,-2.932),(.111,-.24,-2.839),(1.606,2.455,-6.321),(1.809,.56,-6.116),(3.208,-.461,-5.876),(2.053,-.349,-5.683),(1.014,5.557,-5.605),(1.201,4.508,-6.005),(2.194,-.931,-5.306),(2.341,-1.426,-4.867),(.976,-.59,-4.813),(2.385,-1.734,-4.54),(1.131,-1.368,-3.791),(.629,-.203,-4.774),(.172,-.527,-1.714),(.322,-.856,-1.623),(.305,-.82,-2.17),(2.455,-2.02,-4.209),(2.55,3.296,-6.282),(.438,2.388,-5.85),(1.022,2.406,-6.068),(.114,3.758,-5.354),(.069,3.817,-5.239),(.536,.511,-5.227),(.399,.121,-4.727),(3.204,-.912,-5.613),(.3,-.417,-3.588),(.306,-.701,-2.918),(.581,-.921,-3.336),(.341,-.196,-4.11),(.106,-.413,-1.604),(.121,-.444,-1.47),(.104,-.415,-1.109),(.077,-.382,-1.107),(.822,-1.528,-1.967),(.366,-1.123,-1.266),(.141,-.474,-1.121),(.309,-1.039,-1.095),(.29,-.548,.401),(.923,3.647,3.266),(1.083,4.273,3.363),(1.776,4.513,3.288),(2.138,4.589,3.175),(.952,1.804,2.688),(1.235,.183,1.709),(1.385,.41,1.868),(1.599,1.194,2.192),(1.593,.94,2.101),(1.474,.606,2.014),(1.339,1.695,2.475),(.324,-.633,-.376),(.297,-.546,-.326),(.358,-1.016,-.372),(.352,-.859,-.372),(.28,-.498,-.332),(.574,-.993,.395),(.997,-.971,1.348),(1.029,-.767,1.386),(.569,-.819,.4),(.467,-.38,.119),(1.012,-.019,1.439),(.821,-.151,1.103),(.946,-.009,1.446),(.786,-.127,1.132),(.61,-.238,.599),(.638,-.278,.587),(1.199,.217,1.714),(1.336,.415,1.87),(1.254,.422,1.885),(1.127,.217,1.719),(.431,-.33,.108),(.648,-.331,.605),(.262,-.451,-.338),(.883,.037,1.544),(.76,-.135,1.155),(1.45,1.378,2.342),(1.334,1.014,2.184),(1.855,.725,2.16),(2.181,1.2,2.317),(.991,-.548,1.315),(.577,-.672,.397),(.34,-.743,-.375),(3.014,.938,2.661),(2.298,.496,2.366),(2.109,.219,2.281),(2.461,.144,2.442),(2.689,.535,2.542),(.384,-.47,1.121),(.451,.471,2.387),(.672,.496,2.302),(.769,.938,2.443),(.452,1.392,2.673),(.868,1.38,2.568),(.451,.942,2.524),(-5.642,12.857,-1.672),(-5.45,11.466,-1.396),(-5.576,12.899,-1.42),(5.548,12.899,-1.42),(5.422,11.466,-1.396),(5.614,12.857,-1.672),(-2.169,13.396,-4.192),(-2.091,11.66,-3.635),(-2.392,12.463,-3.88),(2.363,12.463,-3.88),(2.063,11.66,-3.635),(2.141,13.396,-4.192),(-5.452,11.338,-.646),(-5.425,11.429,-1.172),(-5.439,10.881,-1.37),(5.411,10.881,-1.37),(5.397,11.429,-1.172),(5.424,11.338,-.646),(-4.912,10.824,2.184),(-5.329,11.636,1.51),(-5.337,11.319,1.418),(5.309,11.319,1.418),(5.301,11.636,1.51),(4.884,10.824,2.184),(-.373,13.82,-3.785),(-.577,13.784,-3.927),(-.434,15.63,-4.596),(.406,15.63,-4.596),(.549,13.784,-3.927),(.345,13.82,-3.785),(-4.324,10.496,-2.987),(-4.329,10.365,-2.977),(-4.638,10.338,-2.804),(4.61,10.338,-2.804),(4.301,10.365,-2.977),(4.296,10.496,-2.987),(-2.539,12.644,-3.965),(-2.789,12.187,-3.818),(-2.78,13.121,-4.143),(2.752,13.121,-4.143),(2.761,12.187,-3.818),(2.511,12.644,-3.965),(-2.422,13.277,-4.191),(2.394,13.277,-4.191),(-2.003,15.376,-4.844),(1.975,15.376,-4.844),(-2.002,13.403,-4.168),(1.974,13.403,-4.168),(-1.833,15.4,-4.82),(-1.928,17.193,-5.301),(1.9,17.193,-5.301),(1.805,15.4,-4.82),(-6.104,14.492,-1.923),(-5.899,14.273,-1.353),(-6.05,14.699,-1.349),(6.022,14.699,-1.349),(5.871,14.273,-1.353),(6.076,14.492,-1.923),(-3.025,14.399,4.14),(-3.369,13.74,3.88),(-3.166,13.563,3.899),(3.138,13.563,3.899),(3.341,13.74,3.88),(2.997,14.399,4.14),(-4.459,13.746,3.4),(-4.437,13.505,3.252),(-3.868,13.012,3.393),(3.84,13.012,3.393),(4.408,13.505,3.252),(4.431,13.746,3.4),(-6.019,14.622,.507),(-5.764,13.999,1.26),(-6.153,15.141,.622),(6.125,15.141,.622),(5.736,13.999,1.26),(5.991,14.622,.507),(-5.908,14.111,.076),(-5.85,14.014,-.712),(-5.702,13.45,-.114),(5.674,13.45,-.114),(5.821,14.014,-.712),(5.88,14.111,.076),(-6.365,16.101,-1.269),(-6.536,15.83,-2.065),(-6.297,15.767,-1.361),(6.269,15.767,-1.361),(6.508,15.83,-2.065),(6.337,16.101,-1.269),(-6.234,15.379,-1.354),(6.206,15.379,-1.354),(-6.33,15.575,-.653),(6.302,15.575,-.653),(-6.336,15.743,-.496),(6.307,15.743,-.496),(-6.365,15.843,-.439),(6.337,15.843,-.439),(-6.297,15.427,.063),(-6.298,15.246,-.014),(-6.23,15.224,.316),(6.202,15.224,.316),(6.27,15.246,-.014),(6.269,15.427,.063),(-6.172,14.966,-.975),(6.144,14.966,-.975),(-6.28,15.201,-.745),(6.252,15.201,-.745),(-1.769,14.548,4.486),(-2.544,14.328,4.295),(-1.95,14.072,4.492),(1.922,14.072,4.492),(2.516,14.328,4.295),(1.74,14.548,4.486),(-6.243,15.356,.41),(6.215,15.356,.41),(-6.286,15.454,.539),(6.258,15.454,.539),(-5.993,14.406,-.739),(-6.057,14.531,-.8),(6.029,14.531,-.8),(5.965,14.406,-.739),(-4.427,13.311,3.13),(4.399,13.311,3.13),(-2.608,14.616,4.298),(-2.821,14.335,4.202),(2.793,14.335,4.202),(2.58,14.616,4.298),(-2.911,12.457,3.726),(-3.158,12.239,3.629),(-2.864,12.249,3.688),(2.836,12.249,3.688),(3.13,12.239,3.629),(2.883,12.457,3.726),(-2.887,12.023,3.658),(2.859,12.023,3.658),(-2.534,14.938,4.381),(-2.812,14.841,4.268),(2.784,14.841,4.268),(2.506,14.938,4.381),(-4.18,9.564,2.917),(-4.185,10.247,2.8),(-4.342,9.58,2.787),(4.314,9.58,2.787),(4.157,10.247,2.8),(4.152,9.564,2.917),(-1.937,9.768,3.696),(-2.074,10.25,3.825),(-2.265,9.867,3.553),(2.237,9.867,3.553),(2.046,10.25,3.825),(1.909,9.768,3.696),(-2.373,9.611,3.419),(-2.538,10.045,3.445),(2.51,10.045,3.445),(2.345,9.611,3.419),(-.014,8.577,3.702),(-.332,8.757,3.656),(-.243,8.593,3.682),(.215,8.593,3.682),(.304,8.757,3.656),(-.297,8.789,3.654),(.269,8.789,3.654),(-.196,8.821,3.656),(.168,8.821,3.656),(-.014,8.81,3.665),(-3.087,9.775,3.169),(-3.016,9.37,3.172),(-2.707,9.612,3.267),(2.679,9.612,3.267),(2.988,9.37,3.172),(3.059,9.775,3.169),(-1.191,8.976,3.673),(-.422,8.861,3.717),(-.237,8.928,3.733),(.209,8.928,3.733),(.393,8.861,3.717),(1.163,8.976,3.673),(-.326,8.696,3.664),(.297,8.696,3.664),(-1.132,8.699,3.772),(-2.162,8.37,3.693),(-1.07,8.407,3.84),(1.042,8.407,3.84),(2.134,8.37,3.693),(1.104,8.699,3.772),(-2.661,9.374,3.201),(2.633,9.374,3.201),(-2.683,9.157,3.165),(2.655,9.157,3.165),(-1.159,9.38,3.672),(-.421,9.479,3.81),(-1.135,9.643,3.829),(1.107,9.643,3.829),(.393,9.479,3.81),(1.131,9.38,3.672),(-3.68,9.485,-3.477),(-3.73,10.415,-3.273),(-3.242,10.366,-3.429),(3.214,10.366,-3.429),(3.702,10.415,-3.273),(3.652,9.485,-3.477),(-4.716,9.556,-2.972),(4.688,9.556,-2.972),(-5.463,9.507,-2.075),(-5.28,10.325,-1.925),(-5.06,10.33,-2.232),(5.032,10.33,-2.232),(5.252,10.325,-1.925),(5.435,9.507,-2.075),(-.4,8.598,-3.984),(-.212,8.53,-3.929),(.184,8.53,-3.929),(.372,8.598,-3.984),(-2.043,9.132,-3.779),(-1.866,9.087,-3.817),(1.838,9.087,-3.817),(2.015,9.132,-3.779),(-5.086,8.783,2.261),(-5.06,9.084,2.24),(-5.6,9.608,1.121),(5.572,9.608,1.121),(5.032,9.084,2.24),(5.058,8.783,2.261),(-4.71,7.748,2.77),(-4.323,7.675,3.004),(-4.61,8.095,2.809),(4.582,8.095,2.809),(4.295,7.675,3.004),(4.682,7.748,2.77),(-4.096,7.638,3.081),(-4.178,8.44,3.021),(4.15,8.44,3.021),(4.068,7.638,3.081),(-.014,9.626,-3.336),(-.296,9.739,-3.462),(-.361,11.614,-3.332),(-.014,11.608,-3.132),(.333,11.614,-3.332),(.268,9.739,-3.462),(-.014,13.862,-3.59),(-.014,14.985,4.426),(-.014,15.328,4.498),(-.233,15.242,4.557),(-.258,14.81,4.478),(.23,14.81,4.478),(.205,15.242,4.557),(-.014,14.534,4.397),(-.255,14.431,4.483),(.227,14.431,4.483),(-.014,13.878,4.383),(-.265,13.894,4.468),(.237,13.894,4.468),(-.014,13.174,4.307),(-.279,13.178,4.399),(.251,13.178,4.399),(-.014,12.607,4.192),(-.299,12.564,4.237),(.271,12.564,4.237),(-.014,12.292,4.071),(-.298,12.219,4.1),(.27,12.219,4.1),(-.014,12.07,3.977),(-.297,11.98,4.061),(.269,11.98,4.061),(-.014,11.648,3.98),(-.312,11.573,4.011),(.284,11.573,4.011),(-.014,10.956,3.931),(-.34,10.925,4.032),(.312,10.925,4.032),(-.014,9.962,3.867),(-.357,10.043,3.965),(.329,10.043,3.965),(-.014,15.716,-4.432),(-.014,16.514,-4.711),(-.407,16.599,-4.895),(.379,16.599,-4.895),(-1.085,13.626,-4.138),(-1.069,11.64,-3.725),(-1.53,11.661,-3.771),(-1.72,13.512,-4.217),(1.692,13.512,-4.217),(1.502,11.661,-3.771),(1.041,11.64,-3.725),(1.057,13.626,-4.138),(-1.917,11.667,-3.659),(1.889,11.667,-3.659),(-1.014,9.952,-3.734),(-1.462,10.056,-3.745),(1.434,10.056,-3.745),(.986,9.952,-3.734),(-.598,11.6,-3.502),(.57,11.6,-3.502),(-1.066,15.631,-4.838),(1.038,15.631,-4.838),(-1.928,10.165,-3.593),(1.9,10.165,-3.593),(-.544,9.77,-3.587),(.516,9.77,-3.587),(-2.103,10.158,-3.567),(2.075,10.158,-3.567),(-5.011,9.864,2.184),(4.983,9.864,2.184),(-2.765,11.9,-3.694),(-3.261,11.377,-3.436),(-3.285,11.753,-3.58),(3.257,11.753,-3.58),(3.233,11.377,-3.436),(2.737,11.9,-3.694),(-3.747,11.127,-3.258),(-3.792,11.515,-3.364),(3.764,11.515,-3.364),(3.719,11.127,-3.258),(-3.252,11.043,-3.418),(-2.767,11.484,-3.593),(2.739,11.484,-3.593),(3.224,11.043,-3.418),(-3.296,13.026,-4.042),(3.268,13.026,-4.042),(-3.733,10.771,-3.251),(3.705,10.771,-3.251),(-2.755,10.317,-3.556),(2.727,10.317,-3.556),(-4.692,12.721,-3.531),(-4.057,12.914,-3.834),(-4.393,11.385,-3.154),(4.365,11.385,-3.154),(4.029,12.914,-3.834),(4.664,12.721,-3.531),(-4.323,10.982,-3.053),(4.295,10.982,-3.053),(-4.428,14.795,-4.418),(-5.138,14.576,-4.015),(5.11,14.576,-4.015),(4.4,14.795,-4.418),(-4.916,11.322,-2.846),(-5.212,12.604,-3.053),(5.184,12.604,-3.053),(4.888,11.322,-2.846),(-4.747,10.894,-2.784),(4.719,10.894,-2.784),(-5.518,12.626,-2.644),(-5.203,11.243,-2.431),(5.175,11.243,-2.431),(5.489,12.626,-2.644),(-5.06,10.817,-2.357),(5.032,10.817,-2.357),(-5.846,14.422,-3.477),(-6.086,14.317,-3.103),(6.058,14.317,-3.103),(5.817,14.422,-3.477),(-5.427,11.289,-1.987),(-5.705,12.688,-2.182),(5.677,12.688,-2.182),(5.399,11.289,-1.987),(-5.328,10.784,-1.942),(5.3,10.784,-1.942),(-5.465,12.819,-1.001),(5.437,12.819,-1.001),(-5.475,10.294,-1.343),(5.447,10.294,-1.343),(-5.568,10.191,-.806),(5.54,10.191,-.806),(-3.618,9.961,3.119),(-3.619,10.425,3.19),(-4.111,10.784,2.873),(4.083,10.784,2.873),(3.591,10.425,3.19),(3.59,9.961,3.119),(-5.43,10.622,1.279),(5.402,10.622,1.279),(-4.813,11.349,2.399),(4.785,11.349,2.399),(-5.56,11.049,.306),(-5.671,10.007,.114),(5.643,10.007,.114),(5.532,11.049,.306),(-5.506,12.586,-.385),(-5.539,11.959,.549),(5.511,11.959,.549),(5.478,12.586,-.385),(-5.602,12.499,.709),(5.574,12.499,.709),(-6.213,14.271,-2.589),(6.184,14.271,-2.589),(-2.723,15.266,-5.006),(-3.364,15.115,-4.872),(3.336,15.115,-4.872),(2.695,15.266,-5.006),(-2.826,17.101,-5.406),(2.798,17.101,-5.406),(-1.046,17.131,-5.2),(1.018,17.131,-5.2),(-.809,15.236,4.601),(-.838,14.812,4.543),(.81,14.812,4.543),(.781,15.236,4.601),(-.864,14.456,4.536),(.836,14.456,4.536),(-.92,13.939,4.558),(.892,13.939,4.558),(-.968,13.222,4.48),(.94,13.222,4.48),(-.917,12.527,4.271),(.889,12.527,4.271),(-.909,12.176,4.113),(.881,12.176,4.113),(-.929,11.965,4.056),(.901,11.965,4.056),(-.988,11.594,4.025),(.96,11.594,4.025),(-1.072,10.979,4.096),(1.044,10.979,4.096),(-1.09,10.142,4.011),(1.062,10.142,4.011),(-2.179,11.134,3.963),(-2.723,11.18,3.653),(-2.63,10.495,3.522),(2.602,10.495,3.522),(2.695,11.18,3.653),(2.151,11.134,3.963),(-2.947,11.24,3.525),(-2.898,10.592,3.413),(2.87,10.592,3.413),(2.919,11.24,3.525),(-2.155,11.879,3.951),(-2.681,11.947,3.754),(2.653,11.947,3.754),(2.127,11.879,3.951),(-2.8,10.131,3.345),(2.772,10.131,3.345),(-3.229,11.343,3.41),(-3.218,10.72,3.328),(3.19,10.72,3.328),(3.201,11.343,3.41),(-3.168,10.256,3.249),(3.14,10.256,3.249),(-3.584,11.462,3.264),(-3.602,10.889,3.248),(3.574,10.889,3.248),(3.556,11.462,3.264),(-4.025,11.763,3.05),(-4.057,11.328,2.96),(4.029,11.328,2.96),(3.997,11.763,3.05),(-3.576,12.395,3.434),(3.548,12.395,3.434),(-4.615,12.376,2.8),(-4.641,11.97,2.603),(4.613,11.97,2.603),(4.587,12.376,2.8),(-3.95,12.584,3.288),(3.922,12.584,3.288),(-3.55,12.876,3.533),(3.522,12.876,3.533),(-3.703,14.263,3.902),(3.675,14.263,3.902),(-3.248,12.819,3.67),(3.22,12.819,3.67),(-4.496,13.019,3.069),(4.468,13.019,3.069),(-3.007,12.901,3.805),(2.979,12.901,3.805),(-3.632,16.722,-5.296),(3.604,16.722,-5.296),(-3.353,15.107,4.185),(3.325,15.107,4.185),(-2.99,13.532,3.985),(2.962,13.532,3.985),(-4.763,16.132,-4.828),(4.735,16.132,-4.828),(-5.494,15.844,-4.419),(5.466,15.844,-4.419),(-6.23,15.631,-3.831),(6.202,15.631,-3.831),(-6.476,15.545,-3.368),(6.448,15.545,-3.368),(-6.616,15.511,-2.856),(6.588,15.511,-2.856),(-2.073,13.387,4.376),(-2.08,12.81,4.188),(2.052,12.81,4.188),(2.045,13.387,4.376),(-2.024,12.464,4.049),(1.996,12.464,4.049),(-2.768,13.519,4.091),(-2.783,12.95,3.941),(2.755,12.95,3.941),(2.739,13.519,4.091),(-2.664,12.526,3.857),(2.636,12.526,3.857),(-4.183,14.756,3.776),(4.154,14.756,3.776),(-4.994,15.488,3.268),(-5.155,14.548,3.02),(5.126,14.548,3.02),(4.966,15.488,3.268),(-3.781,15.58,3.926),(3.753,15.58,3.926),(-5.101,14.178,2.805),(5.073,14.178,2.805),(-5.767,16.493,2.443),(-5.856,15.698,2.271),(5.828,15.698,2.271),(5.739,16.493,2.443),(-4.67,16.121,3.354),(4.642,16.121,3.354),(-5.808,14.838,1.901),(-5.777,14.391,1.681),(-5.203,13.265,2.327),(-5.16,13.696,2.544),(5.132,13.696,2.544),(5.174,13.265,2.327),(5.749,14.391,1.681),(5.78,14.838,1.901),(-5.236,12.819,2.047),(5.208,12.819,2.047),(-6.199,15.939,1.211),(-6.17,15.475,1.039),(6.142,15.475,1.039),(6.171,15.939,1.211),(-5.109,13.98,2.635),(-5.781,15.149,1.999),(5.753,15.149,1.999),(5.081,13.98,2.635),(-2.039,12.231,3.992),(2.011,12.231,3.992),(-2.629,12.274,3.812),(2.601,12.274,3.812),(-5.341,12.156,1.728),(5.313,12.156,1.728),(-5.699,13.112,.934),(5.671,13.112,.934),(-6.218,16.359,1.253),(6.19,16.359,1.253),(-6.123,14.809,.222),(6.095,14.809,.222),(-6.033,14.483,-.127),(6.005,14.483,-.127),(-6.448,15.984,.497),(-6.387,15.699,.283),(-6.331,15.76,.802),(6.303,15.76,.802),(6.359,15.699,.283),(6.42,15.984,.497),(-6.444,16.035,-.311),(-6.321,15.542,.127),(6.292,15.542,.127),(6.416,16.035,-.311),(-6.226,14.913,-.168),(6.198,14.913,-.168),(-6.121,14.655,-.46),(6.093,14.655,-.46),(-1.747,15.178,4.544),(-1.687,14.865,4.497),(1.659,14.865,4.497),(1.719,15.178,4.544),(-2.971,15.376,4.316),(2.942,15.376,4.316),(-5.782,15.296,2.116),(5.754,15.296,2.116),(-.014,9.437,3.812),(-3.631,9.462,3.124),(3.603,9.462,3.124),(-1.929,9.462,3.577),(1.901,9.462,3.577),(-.27,8.4,3.781),(-.014,8.401,3.773),(-.014,8.478,3.742),(-.268,8.491,3.737),(.24,8.491,3.737),(.242,8.4,3.781),(-.263,8.536,3.643),(-.014,8.511,3.643),(.235,8.536,3.643),(-.014,8.846,3.613),(-.204,8.863,3.613),(.176,8.863,3.613),(-.014,8.864,3.696),(-.208,8.882,3.699),(.18,8.882,3.699),(-.273,8.235,3.818),(-.014,8.2,3.819),(.245,8.235,3.818),(-.014,9.129,3.649),(-.36,9.159,3.734),(.332,9.159,3.734),(-.014,8.909,3.714),(-4.509,8.551,2.831),(4.481,8.551,2.831),(-3.613,8.358,3.2),(3.585,8.358,3.2),(-3.101,8.379,3.222),(3.073,8.379,3.222),(-.511,8.604,3.752),(-.444,8.627,3.73),(.416,8.627,3.73),(.483,8.604,3.752),(-.38,8.657,3.601),(.352,8.657,3.601),(-.521,8.759,3.725),(-.462,8.765,3.706),(.434,8.765,3.706),(.493,8.759,3.725),(-.392,8.765,3.605),(.364,8.765,3.605),(-.373,8.84,3.695),(.344,8.84,3.695),(-.33,8.822,3.609),(.302,8.822,3.609),(-2.017,9.047,3.533),(1.989,9.047,3.533),(-1.171,9.183,3.653),(1.143,9.183,3.653),(-2.445,9.081,3.337),(-2.545,8.383,3.421),(2.517,8.383,3.421),(2.417,9.081,3.337),(-1.93,9.254,3.519),(1.902,9.254,3.519),(-2.761,8.378,3.242),(2.733,8.378,3.242),(-2.375,9.331,3.347),(2.347,9.331,3.347),(-5.737,9.531,-1.332),(5.708,9.531,-1.332),(-.014,8.463,-3.873),(-.998,8.796,-4.019),(-1.404,8.946,-3.98),(1.376,8.946,-3.98),(.97,8.796,-4.019),(-2.754,9.277,-3.72),(2.726,9.277,-3.72),(-5.82,9.422,-.883),(5.792,9.422,-.883),(-.014,7.329,3.825),(-.262,7.343,3.83),(.234,7.343,3.83),(-5.944,9.186,.067),(-5.862,8.743,1.177),(5.834,8.743,1.177),(5.916,9.186,.067),(-5.317,8.146,2.265),(5.289,8.146,2.265),(-.89,7.391,3.829),(.862,7.391,3.829),(-1.967,7.591,3.736),(1.939,7.591,3.736),(-2.47,7.603,3.408),(2.442,7.603,3.408),(-2.674,7.587,3.268),(2.645,7.587,3.268),(-3.566,7.639,3.24),(-3.014,7.587,3.259),(2.986,7.587,3.259),(3.538,7.639,3.24),(-.014,25.538,-4.756),(-.217,26.309,-4.467),(-.014,26.302,-4.45),(.189,26.309,-4.467),(-.522,22.778,2.699),(-.172,23.689,2.111),(-.881,23.986,1.992),(.853,23.986,1.992),(.144,23.689,2.111),(.494,22.778,2.699),(-.014,23.465,2.216),(-.014,22.665,2.657),(-.014,24.092,1.788),(-.014,24.337,1.542),(-.133,24.361,1.592),(.105,24.361,1.592),(-.014,23.646,2.141),(-.014,23.949,1.916),(-.155,23.944,1.969),(.127,23.944,1.969),(-.107,24.109,1.814),(.079,24.109,1.814),(-.21,17.444,4.5),(-.014,17.39,4.497),(-.014,18.379,4.347),(.182,17.444,4.5),(-.014,24.655,1.34),(-.284,24.889,1.261),(-.239,24.678,1.373),(.211,24.678,1.373),(.256,24.889,1.261),(-1.93,26.127,.359),(-1.702,26.087,.48),(-1.884,26.766,.219),(1.856,26.766,.219),(1.674,26.087,.48),(1.902,26.127,.359),(-1.099,25.251,1.118),(-.916,24.869,1.48),(-.783,24.752,1.452),(.755,24.752,1.452),(.888,24.869,1.48),(1.071,25.251,1.118),(-2.144,26.439,-4.522),(-1.464,27.14,-3.989),(-1.626,26.386,-4.524),(1.609,26.386,-4.532),(1.446,27.14,-3.997),(2.14,26.439,-4.533),(-.866,26.321,-4.516),(-.874,26.647,-4.355),(.846,26.647,-4.355),(.838,26.321,-4.516),(-.525,24.429,1.706),(-.637,24.374,1.713),(-.449,24.241,1.818),(.421,24.241,1.818),(.609,24.374,1.713),(.497,24.429,1.706),(-.639,25.566,-4.853),(.611,25.566,-4.853),(-.385,26.418,-4.428),(-.208,26.53,-4.393),(.18,26.53,-4.393),(.357,26.418,-4.428),(-2.61,24.192,1.353),(-2.314,23.249,2.233),(-2.141,24.137,1.552),(2.113,24.137,1.552),(2.286,23.249,2.233),(2.582,24.192,1.353),(-1.069,18.239,4.658),(-1.754,18.512,4.716),(-1.76,17.928,4.623),(1.732,17.928,4.623),(1.726,18.512,4.716),(1.041,18.239,4.658),(-.687,17.466,-5.294),(-.397,17.551,-5.281),(-.374,17.104,-5.111),(.346,17.104,-5.111),(.369,17.551,-5.281),(.659,17.466,-5.294),(-3.008,19.653,-5.973),(-3.407,20.045,-6.083),(-3.202,20.481,-6.153),(3.174,20.481,-6.153),(3.379,20.045,-6.083),(2.98,19.653,-5.973),(-2.915,17.663,-5.457),(-2.981,18.083,-5.496),(-2.044,18.146,-5.475),(2.016,18.146,-5.475),(2.953,18.083,-5.496),(2.887,17.663,-5.457),(-.366,18.144,-5.43),(-.635,18.13,-5.48),(.607,18.13,-5.48),(.338,18.144,-5.43),(-6.447,16.354,.65),(-6.356,16.197,.915),(-6.382,16.539,.829),(6.353,16.539,.829),(6.328,16.197,.915),(6.419,16.354,.65),(-.244,21.694,3.263),(-.417,21.754,3.288),(.389,21.754,3.288),(.216,21.694,3.263),(-2.964,17.334,4.095),(-2.944,16.956,4.032),(-2.779,16.967,4.076),(2.751,16.967,4.076),(2.916,16.956,4.032),(2.936,17.334,4.095),(-3.603,15.723,4.028),(3.575,15.723,4.028),(-2.732,15.393,4.336),(2.704,15.393,4.336),(-2.407,16.869,4.187),(-1.709,17.042,4.36),(-2.56,16.983,4.134),(2.532,16.983,4.134),(1.681,17.042,4.36),(2.379,16.869,4.187),(-1.683,16.497,4.518),(-1.644,16.935,4.465),(-2.286,16.777,4.34),(2.258,16.777,4.34),(1.616,16.935,4.465),(1.655,16.497,4.518),(-6.385,16.693,.874),(6.341,16.685,.874),(-2.984,18.568,-5.562),(-2.526,18.86,-5.635),(-2.205,18.603,-5.554),(2.177,18.603,-5.554),(2.498,18.86,-5.635),(2.956,18.568,-5.562),(-2.442,16.457,4.322),(2.414,16.457,4.322),(-3.691,26.896,-3.73),(-3.614,26.831,-2.839),(-3.422,27.077,-3.596),(3.463,27.079,-3.607),(3.655,26.833,-2.847),(3.767,26.898,-3.737),(-2.778,25.295,-5.206),(-3.58,25.108,-5.321),(-2.873,25.781,-4.91),(2.896,25.781,-4.924),(3.67,25.11,-5.329),(2.805,25.295,-5.221),(-4.031,25.945,-1.765),(-3.963,25.872,-1.524),(-3.226,26.347,-1.746),(3.215,26.349,-1.748),(3.977,25.872,-1.525),(4.065,25.944,-1.764),(-4.317,25.335,-.289),(-3.82,25.331,.005),(-4.162,25.407,-.414),(4.16,25.406,-.412),(3.813,25.332,.005),(4.301,25.333,-.282),(-4.065,18.571,-5.506),(-4.189,18.053,-5.36),(-4.808,18.466,-5.348),(4.769,18.463,-5.348),(4.161,18.053,-5.36),(4.037,18.571,-5.506),(-4.109,18.655,4.239),(-4.209,18.438,4.176),(-3.121,18.509,4.481),(3.093,18.509,4.481),(4.181,18.438,4.176),(4.081,18.655,4.239),(-4.085,19.454,4.104),(-4.09,19.069,4.203),(-3.245,19.302,4.332),(3.217,19.302,4.332),(4.062,19.069,4.203),(4.057,19.454,4.104),(-4.639,19.782,-5.843),(-4.375,20.044,-5.933),(-4.129,19.576,-5.931),(4.101,19.576,-5.931),(4.341,20.043,-5.933),(4.604,19.78,-5.843),(-6.364,18.166,1.193),(-6.44,18.217,.918),(-6.326,18.019,1.256),(6.286,18.012,1.256),(6.389,18.202,.918),(6.313,18.152,1.193),(-6.326,18.236,1.419),(6.275,18.222,1.419),(-6.116,17.388,1.729),(-5.677,16.864,2.434),(-6.157,17.699,1.657),(6.117,17.692,1.657),(5.649,16.864,2.434),(6.074,17.382,1.729),(-6.355,17.654,1.334),(-6.403,17.811,1.144),(-6.446,17.567,1.143),(6.404,17.56,1.143),(6.362,17.804,1.144),(6.314,17.647,1.334),(-6.49,17.154,1.022),(-6.426,16.891,1.011),(-6.371,17.01,1.251),(6.328,17.003,1.251),(6.382,16.883,1.011),(6.447,17.146,1.022),(-6.33,17.458,1.397),(6.289,17.451,1.397),(-6.602,17.951,-1.254),(-6.501,17.537,-1.196),(-6.537,17.678,-1.025),(6.496,17.67,-1.025),(6.46,17.53,-1.196),(6.55,17.935,-1.254),(-6.469,16.974,-1.252),(-6.445,16.535,-1.031),(6.401,16.528,-1.031),(6.426,16.967,-1.252),(-6.5,16.765,-.849),(6.456,16.757,-.849),(-6.503,17.057,-.708),(6.46,17.049,-.708),(-6.481,17.204,-.536),(6.438,17.197,-.536),(-6.642,18.03,-.602),(-6.661,17.656,-.096),(-6.668,17.796,.035),(6.614,17.78,.035),(6.62,17.648,-.096),(6.59,18.014,-.602),(-3.782,21.079,3.527),(-3.326,21.073,3.675),(-3.586,22.297,2.889),(3.547,22.297,2.888),(3.298,21.073,3.675),(3.754,21.079,3.527),(-5,19.051,-5.443),(-4.116,18.774,-5.59),(4.088,18.774,-5.59),(4.963,19.048,-5.443),(-4.356,22.867,-5.941),(-4.783,23.408,-5.746),(-4.303,22.947,-5.952),(4.384,22.942,-5.945),(4.901,23.394,-5.726),(4.438,22.86,-5.933),(-4.115,23.313,-6.024),(-4.525,23.579,-5.875),(-4.067,23.538,-6.004),(4.167,23.536,-6.002),(4.628,23.571,-5.863),(4.197,23.311,-6.021),(-3.919,26.319,-2.378),(-4.252,26.137,-2.397),(4.301,26.135,-2.389),(3.959,26.319,-2.38),(-2.964,26.929,-4.173),(-3.319,26.693,-4.354),(3.384,26.695,-4.368),(2.993,26.932,-4.186),(-.014,26.726,-4.29),(-.268,26.762,-4.29),(-.219,27.011,-4.129),(-.014,27.012,-4.116),(.191,27.011,-4.129),(.24,26.762,-4.29),(-.014,26.506,-4.388),(-.603,22.805,-5.892),(-.619,24.354,-5.49),(-.014,24.309,-5.357),(-.014,22.782,-5.675),(.591,24.354,-5.49),(.575,22.805,-5.892),(-.014,17.241,4.534),(-.207,17.266,4.548),(.179,17.266,4.548),(-.014,15.908,4.536),(-.014,16.934,4.551),(-.191,16.9,4.588),(-.187,15.891,4.632),(.159,15.891,4.632),(.163,16.9,4.588),(-.014,18.172,-5.322),(-.014,17.515,-5.161),(-.014,17.039,-4.98),(-.386,18.929,-5.601),(-.447,20.011,-5.866),(-.014,20.02,-5.699),(-.014,18.958,-5.484),(.419,20.011,-5.866),(.358,18.929,-5.601),(-.533,21.481,-5.958),(-.014,21.459,-5.72),(.505,21.481,-5.958),(-.014,21.66,3.267),(-.18,20.464,3.8),(-.014,20.393,3.778),(.152,20.464,3.8),(-.165,19.262,4.201),(-.014,19.129,4.175),(.137,19.262,4.201),(-.207,18.528,4.34),(.179,18.528,4.34),(-.358,24.712,1.421),(-.503,24.758,1.477),(-.365,24.417,1.683),(-.229,24.378,1.626),(.201,24.378,1.626),(.337,24.417,1.683),(.475,24.758,1.477),(.33,24.712,1.421),(-.249,24.153,1.849),(.221,24.153,1.849),(-.674,24.779,1.485),(.646,24.779,1.485),(-.486,25.142,1.238),(-.658,25.178,1.267),(.63,25.178,1.267),(.458,25.142,1.238),(-2.118,26.811,-.074),(-2.141,26.125,.096),(2.113,26.125,.096),(2.09,26.811,-.074),(-2.284,25.539,.356),(-1.974,25.496,.666),(1.946,25.496,.666),(2.256,25.539,.356),(-2.316,26.872,-.425),(-2.505,26.189,-.299),(2.477,26.189,-.299),(2.288,26.872,-.425),(-.859,24.458,1.762),(.831,24.458,1.762),(-1.561,25.423,.885),(-1.435,25.046,1.295),(1.407,25.046,1.295),(1.533,25.423,.885),(-.882,25.242,1.21),(.854,25.242,1.21),(-.34,23.98,1.962),(.312,23.98,1.962),(-.685,24.107,1.881),(.657,24.107,1.881),(-1.432,24.716,1.538),(1.404,24.716,1.538),(-3.31,24.981,.662),(-2.656,24.866,1.032),(-2.544,25.178,.812),(-3.171,25.254,.461),(3.143,25.254,.461),(2.516,25.178,.812),(2.628,24.866,1.032),(3.282,24.981,.662),(-2.761,25.682,-.015),(2.733,25.682,-.015),(-2.09,24.814,1.266),(-2.021,25.114,1.06),(1.993,25.114,1.06),(2.062,24.814,1.266),(-3.498,24.34,.976),(3.477,24.342,.976),(-1.408,24.084,1.834),(1.379,24.084,1.834),(-2.565,27.66,-3.231),(-2.065,27.623,-3.588),(2.045,27.623,-3.594),(2.544,27.66,-3.235),(-.773,27.072,-4.031),(.745,27.072,-4.031),(-.4,27.022,-4.092),(-.429,26.731,-4.288),(.401,26.731,-4.288),(.372,27.022,-4.092),(-2.451,26.931,-.901),(-2.778,26.213,-.75),(2.75,26.213,-.75),(2.423,26.931,-.901),(-3.191,25.707,-.471),(3.175,25.71,-.471),(-2.578,27.066,-1.477),(-3.021,26.212,-1.272),(2.993,26.212,-1.272),(2.55,27.066,-1.477),(-2.795,27.442,-2.246),(-3.45,26.58,-2.363),(-2.696,27.21,-1.821),(2.667,27.21,-1.821),(3.456,26.582,-2.37),(2.772,27.442,-2.249),(-1.772,25.506,-5.093),(1.77,25.506,-5.106),(-2.026,24.369,-5.829),(2.029,24.369,-5.842),(-2.242,23.013,-6.175),(2.214,23.013,-6.175),(-1.561,21.524,-6.137),(1.533,21.524,-6.137),(-1.227,23.071,2.554),(1.198,23.071,2.554),(-.935,22.014,3.399),(.907,22.014,3.399),(-1.93,22.132,3.308),(1.902,22.132,3.308),(-1.393,26.014,.679),(1.365,26.014,.679),(-2.779,19.108,-5.757),(-3.275,18.804,-5.673),(-3.445,19.147,-5.857),(3.417,19.147,-5.857),(3.247,18.804,-5.673),(2.75,19.108,-5.757),(-3.012,17.774,4.322),(-1.719,17.431,4.417),(1.691,17.431,4.417),(2.984,17.774,4.322),(-1.718,19.034,4.653),(1.69,19.034,4.653),(-.641,17.521,4.463),(.613,17.521,4.463),(-.637,17.276,4.545),(.609,17.276,4.545),(-.617,16.772,4.653),(-.699,15.866,4.712),(.671,15.866,4.712),(.589,16.772,4.653),(-6.187,16.664,1.512),(6.159,16.664,1.512),(-1.618,19.756,4.451),(-3.32,19.922,4.161),(3.292,19.922,4.161),(1.59,19.756,4.451),(-.749,18.744,4.603),(.721,18.744,4.603),(-.637,19.449,4.455),(.609,19.449,4.455),(-.803,17.79,4.468),(-.383,18.598,4.394),(.355,18.598,4.394),(.775,17.79,4.468),(-1.397,18.124,-5.463),(1.369,18.124,-5.463),(-1.004,18.111,-5.503),(.976,18.111,-5.503),(-6.428,16.559,-3.921),(-5.823,16.757,-4.478),(5.78,16.751,-4.478),(6.383,16.552,-3.921),(-6.664,16.512,-3.448),(6.619,16.504,-3.448),(-6.797,16.525,-2.932),(6.753,16.516,-2.932),(-6.782,16.828,-2.064),(6.738,16.82,-2.064),(-1.739,18.842,-5.652),(-2.174,20.096,-5.987),(-1.795,20.119,-6.026),(-1.319,18.843,-5.707),(1.291,18.843,-5.707),(1.767,20.119,-6.026),(2.146,20.096,-5.987),(1.711,18.842,-5.652),(-.867,18.91,-5.683),(-1.162,20.108,-5.961),(1.134,20.108,-5.961),(.839,18.91,-5.683),(-2.589,21.111,-6.147),(-2.256,21.307,-6.205),(2.228,21.307,-6.205),(2.561,21.111,-6.147),(-2.286,19.224,-5.737),(-2.479,20.053,-5.95),(2.451,20.053,-5.95),(2.258,19.224,-5.737),(-2.56,19.365,-5.799),(2.532,19.365,-5.799),(-2.708,19.926,-5.957),(2.68,19.926,-5.957),(-2.984,20.775,-6.124),(2.956,20.775,-6.124),(-2.799,20.956,-6.111),(2.77,20.956,-6.111),(-2.821,22.22,-6.266),(2.793,22.22,-6.266),(-3.045,21.823,-6.202),(3.017,21.823,-6.202),(-3.354,21.405,-6.179),(-3.194,21.622,-6.174),(3.166,21.622,-6.174),(3.326,21.405,-6.179),(-4.58,16.354,3.425),(4.552,16.354,3.425),(-6.523,16.307,-.118),(6.495,16.307,-.118),(-6.53,16.651,.075),(6.486,16.643,.075),(-.782,20.895,3.954),(-.343,20.486,3.865),(.315,20.486,3.865),(.754,20.895,3.954),(-1.758,21.087,3.936),(1.73,21.087,3.936),(-.326,19.285,4.271),(.298,19.285,4.271),(-3.084,16.413,4.064),(-2.706,16.401,4.154),(2.678,16.401,4.154),(3.056,16.413,4.064),(-4.436,16.733,3.474),(4.408,16.733,3.474),(-2.513,15.465,4.447),(2.485,15.465,4.447),(-1.759,15.672,4.602),(1.731,15.672,4.602),(-4.049,25.098,.201),(4.035,25.098,.201),(-2.748,27.53,-2.612),(2.726,27.53,-2.616),(-3.698,26.469,-4.527),(3.777,26.469,-4.534),(-4.146,26.614,-2.921),(4.228,26.612,-2.916),(-2.885,24.324,-5.801),(-3.562,24.288,-5.785),(3.641,24.29,-5.792),(2.919,24.324,-5.815),(-2.993,23.289,-6.137),(-3.603,23.522,-6.112),(3.646,23.523,-6.116),(2.998,23.289,-6.143),(-3.575,25.755,-.898),(3.57,25.757,-.898),(-3.64,23.371,1.779),(3.604,23.371,1.778),(-4.536,24.366,.612),(4.514,24.362,.619),(-4.353,26.601,-3.809),(4.462,26.596,-3.797),(-4.358,26.132,-4.61),(-4.202,25.029,-5.223),(4.34,25.026,-5.215),(4.487,26.127,-4.597),(-4.136,24.224,-5.7),(4.251,24.222,-5.696),(-3.938,22.679,-6.085),(-3.769,23.028,-6.154),(3.811,23.029,-6.156),(3.981,22.679,-6.086),(-3.32,22.624,-6.209),(3.308,22.624,-6.211),(-5.307,17.591,-4.863),(-5.71,18.087,-4.972),(5.67,18.082,-4.972),(5.265,17.587,-4.863),(-5.387,18.905,-5.248),(5.341,18.897,-5.248),(-4.12,19.068,-5.763),(4.092,19.068,-5.763),(-3.714,19.655,-6.005),(3.686,19.655,-6.005),(-4.9,19.341,-5.657),(4.864,19.339,-5.657),(-4.246,17.819,3.986),(-4.372,17.468,3.653),(4.344,17.468,3.653),(4.218,17.819,3.986),(-4.374,17.09,3.526),(4.346,17.09,3.526),(-3.905,19.958,3.991),(3.877,19.958,3.991),(-4.156,20.229,-6),(4.128,20.229,-6),(-3.89,20.614,-6.096),(3.862,20.614,-6.096),(-4.828,20.482,-5.815),(-5.266,20.912,-5.7),(-5.098,21.109,-5.766),(-4.642,20.672,-5.879),(4.607,20.668,-5.879),(5.091,21.095,-5.759),(5.244,20.901,-5.696),(4.791,20.477,-5.815),(-3.58,21.097,-6.195),(3.552,21.097,-6.195),(-4.837,21.498,-5.929),(-4.379,21.06,-6.01),(4.349,21.059,-6.01),(4.835,21.485,-5.924),(-6.509,17.999,.797),(6.457,17.983,.797),(-5.597,17.08,2.517),(-6.195,17.94,1.713),(6.155,17.933,1.713),(5.569,17.08,2.517),(-6.201,18.223,1.796),(-5.507,17.34,2.638),(5.465,17.335,2.638),(6.162,18.216,1.796),(-6.586,17.772,.712),(-6.638,17.993,.2),(-6.638,17.533,.61),(6.597,17.525,.61),(6.586,17.977,.2),(6.546,17.764,.712),(-6.643,17.337,.51),(6.601,17.329,.51),(-6.568,18.164,.357),(6.517,18.148,.357),(-6.486,17.337,1.091),(6.443,17.329,1.091),(-6.599,17.487,-.267),(-6.597,17.136,.407),(6.555,17.128,.407),(6.557,17.479,-.267),(-6.522,17.355,-.4),(-6.528,16.971,.277),(6.485,16.963,.277),(6.48,17.348,-.4),(-6.571,17.819,-.853),(6.518,17.803,-.853),(-6.347,17.219,1.375),(6.304,17.212,1.375),(-6.147,17.047,1.674),(6.104,17.041,1.674),(-7.049,17.671,-2.091),(-6.866,17.222,-2.066),(6.824,17.213,-2.066),(6.995,17.653,-2.091),(-6.505,16.841,.196),(6.461,16.833,.196),(-3.912,17.387,-5.328),(3.884,17.387,-5.328),(-5.116,17.017,-4.849),(5.073,17.014,-4.849),(-6.024,17.233,-4.518),(-6.401,17.785,-4.617),(6.36,17.777,-4.617),(5.981,17.227,-4.518),(-6.653,16.945,-3.986),(-7.026,17.543,-4.064),(6.971,17.525,-4.064),(6.61,16.937,-3.986),(-6.88,16.878,-3.492),(-7.233,17.462,-3.543),(7.178,17.443,-3.543),(6.837,16.869,-3.492),(-7.003,16.875,-2.96),(-7.324,17.442,-2.983),(7.269,17.422,-2.983),(6.96,16.866,-2.96),(-4.058,21.547,-6.121),(-4.489,21.987,-6.053),(-4.238,22.334,-6.044),(-3.825,21.871,-6.11),(3.797,21.871,-6.11),(4.282,22.329,-6.041),(4.511,21.979,-6.048),(4.03,21.547,-6.121),(-5.094,20.177,-5.73),(-5.531,20.564,-5.622),(5.506,20.55,-5.617),(5.055,20.17,-5.73),(-5.378,19.723,-5.541),(-5.859,20.101,-5.425),(5.815,20.084,-5.425),(5.337,19.714,-5.541),(-5.499,17.941,2.933),(-5.448,17.579,2.794),(5.406,17.575,2.794),(5.458,17.936,2.933),(-4.046,22.521,-6.063),(-3.634,22.072,-6.117),(3.623,22.072,-6.118),(4.089,22.52,-6.062),(-3.507,22.251,-6.142),(3.495,22.251,-6.144),(-4.669,24.169,-5.601),(4.818,24.158,-5.579),(-4.702,26.393,-3.012),(4.799,26.383,-2.99),(-4.852,24.942,-5.132),(4.995,24.929,-5.104),(-5.051,25.791,-4.694),(5.191,25.776,-4.661),(-5.025,26.3,-3.889),(5.147,26.286,-3.857),(-1.102,28.276,.911),(-.97,27.862,.852),(-.965,28.206,1.009),(.937,28.206,1.009),(.942,27.862,.852),(1.074,28.276,.911),(-.771,28.215,1.231),(-.712,28.023,1.145),(.684,28.023,1.145),(.743,28.215,1.231),(-1.645,28.617,.367),(-1.441,28.09,.41),(-1.53,28.561,.487),(1.502,28.561,.487),(1.413,28.09,.41),(1.617,28.617,.367),(-.705,25.918,.909),(-.525,25.729,1.013),(.497,25.729,1.013),(.677,25.918,.909),(-.955,26.691,.604),(-.82,26.681,.604),(.792,26.681,.604),(.927,26.691,.604),(-1.186,27.595,-3.718),(1.158,27.595,-3.718),(-1.186,27.433,.495),(-1.258,27.994,.603),(1.23,27.994,.603),(1.158,27.433,.495),(-.574,27.718,1.089),(-.556,27.971,1.225),(.528,27.971,1.225),(.546,27.718,1.089),(-.954,27.739,.827),(.926,27.739,.827),(-2.164,28.174,-.174),(-2.116,27.516,-.103),(-1.976,27.485,.006),(1.948,27.485,.006),(2.088,27.516,-.103),(2.136,28.174,-.174),(-.3,25.633,1.045),(-.014,25.591,1.061),(.272,25.633,1.045),(-.014,26.511,.818),(-.319,26.555,.761),(.29,26.555,.761),(-.014,27.554,-3.733),(-.014,27.391,-3.826),(-.272,27.29,-3.9),(-.519,27.587,-3.723),(.491,27.587,-3.723),(.244,27.29,-3.9),(-.146,27.155,-4.003),(-.014,27.228,-3.944),(.118,27.155,-4.003),(-.204,27.938,1.305),(-.273,27.597,1.322),(-.014,27.522,1.34),(-.014,27.857,1.307),(.245,27.597,1.322),(.176,27.938,1.305),(-.014,29.362,-3.186),(-.014,28.699,-3.361),(-.316,28.744,-3.354),(-.279,29.385,-3.188),(.251,29.385,-3.188),(.288,28.744,-3.354),(-.291,27.366,1.24),(-.014,27.261,1.268),(.263,27.366,1.24),(-.331,26.941,.904),(-.014,26.874,.978),(.303,26.941,.904),(-.014,28.14,-3.535),(-.41,28.17,-3.549),(.382,28.17,-3.549),(-.014,28.075,1.391),(-.173,28.139,1.396),(.145,28.139,1.396),(-2.427,28.425,-1.763),(-2.39,28.364,-1.47),(-2.313,28.974,-1.413),(-2.331,29.065,-1.67),(2.303,29.065,-1.67),(2.285,28.974,-1.413),(2.361,28.364,-1.47),(2.399,28.425,-1.763),(-2.346,28.269,-.941),(-2.341,28.873,-.969),(2.312,28.873,-.969),(2.318,28.269,-.941),(-2.313,28.188,-.464),(-2.342,28.805,-.491),(2.313,28.805,-.491),(2.285,28.188,-.464),(-2.288,28.746,-.277),(2.26,28.746,-.277),(-.566,28.166,1.343),(.538,28.166,1.343),(-.842,28.745,-3.335),(-.737,29.362,-3.151),(.709,29.362,-3.151),(.814,28.745,-3.335),(-1.538,28.751,-3.165),(-1.36,29.342,-2.993),(1.332,29.342,-2.993),(1.51,28.751,-3.165),(-2.012,28.704,-2.895),(-1.809,29.317,-2.746),(1.781,29.317,-2.746),(1.984,28.704,-2.895),(-2.319,28.649,-2.521),(-2.194,29.291,-2.4),(2.166,29.291,-2.4),(2.29,28.649,-2.521),(-2.471,28.537,-2.138),(-2.364,29.192,-2.041),(2.335,29.192,-2.041),(2.443,28.537,-2.138),(-1.306,28.378,.738),(1.277,28.378,.738),(-1.79,28.66,.287),(-1.599,28.072,.347),(1.571,28.072,.347),(1.762,28.66,.287),(-1.843,28.087,.211),(-2.02,28.662,.129),(1.992,28.662,.129),(1.814,28.087,.211),(-2.176,28.698,-.072),(-2.025,28.118,.017),(1.997,28.118,.017),(2.148,28.698,-.072),(-.919,25.942,.953),(.891,25.942,.953),(-.581,26.625,.672),(.553,26.625,.672),(-1.176,26.715,.677),(1.148,26.715,.677),(-.89,27.264,.673),(.862,27.264,.673),(-1.428,26.725,.584),(-1.182,25.998,.848),(1.154,25.998,.848),(1.4,26.725,.584),(-1.398,27.416,.485),(1.37,27.416,.485),(-2.249,28.121,-3.074),(-2.517,28.057,-2.58),(2.489,28.057,-2.58),(2.221,28.121,-3.074),(-1.8,28.144,-3.365),(1.772,28.144,-3.365),(-.639,27.094,.812),(.611,27.094,.812),(-2.37,27.658,-.921),(-2.294,27.571,-.453),(2.265,27.571,-.453),(2.342,27.658,-.921),(-1.635,26.713,.412),(1.607,26.713,.412),(-1.648,27.428,.37),(1.62,27.428,.37),(-2.642,27.965,-2.183),(2.614,27.965,-2.183),(-.996,28.15,-3.522),(.968,28.15,-3.522),(-2.458,27.771,-1.475),(2.43,27.771,-1.475),(-2.532,27.85,-1.775),(2.504,27.85,-1.775),(-1.844,27.446,.176),(1.816,27.446,.176),(-.598,27.493,1.006),(.57,27.493,1.006),(-2.04,33.112,3.208),(-2.042,33.108,3.21),(-2.047,33.108,3.22),(-1.182,32.986,3.531),(-.875,33.118,3.352),(-1.183,32.924,3.558),(-2.035,33.068,3.27),(-2.063,33.033,3.309),(-2.073,33.078,3.235),(-2.053,33.071,3.287),(-2.078,33.082,3.243),(-2.068,33.038,3.314),(-1.194,32.933,3.585),(-.876,33.13,3.354),(-1.192,32.985,3.563),(-1.185,33.042,3.507),(-1.176,33.021,3.478),(-2.02,33.077,3.254),(-1.982,33.302,3.244),(-2.034,33.252,3.305),(-2.042,33.273,3.194),(-2.055,33.277,3.189),(-2.061,33.261,3.295),(-2.021,33.311,3.236),(-1.364,33.509,3.711),(-1.367,33.528,3.739),(-1.111,33.489,3.634),(-1.98,33.352,3.391),(-1.954,33.379,3.329),(-1.924,33.358,3.327),(-1.934,33.321,3.379),(-1.124,33.451,3.661),(-1.367,33.497,3.737),(-1.368,33.47,3.713),(-.924,33.34,3.327),(-1.118,33.404,3.515),(-1.097,33.425,3.525),(-.894,33.338,3.326),(-.746,29.998,1.767),(-.681,30.025,1.78),(-.762,29.822,1.758),(-.5,30.044,1.781),(-.014,30.031,1.786),(-.014,29.701,1.756),(-.101,30.031,1.786),(-.316,30.049,1.779),(-.201,29.701,1.756),(-.45,29.72,1.757),(-.699,29.757,1.757),(.718,29.998,1.767),(.733,29.822,1.758),(.653,30.025,1.78),(.472,30.044,1.781),(.073,30.031,1.786),(.288,30.049,1.779),(.173,29.701,1.756),(.422,29.72,1.757),(.671,29.757,1.757),(-.739,29.757,2.15),(-.484,29.725,2.365),(-.765,29.767,2.581),(-.291,29.899,3.52),(-.578,29.9,3.361),(-.373,29.868,3.364),(-.693,29.935,3.323),(-.556,29.933,3.431),(-.79,29.92,3.166),(-.832,29.87,2.957),(-.74,29.848,3.051),(-.57,30.036,3.486),(-.694,30.046,3.39),(-.713,30.022,3.357),(.737,29.767,2.581),(.456,29.725,2.365),(.711,29.757,2.15),(.345,29.868,3.364),(.55,29.9,3.361),(.263,29.899,3.52),(.528,29.933,3.431),(.665,29.935,3.323),(.712,29.848,3.051),(.804,29.87,2.957),(.762,29.92,3.166),(.685,30.022,3.357),(.666,30.046,3.39),(.542,30.036,3.486),(-.489,30.152,3.615),(-.441,30.163,3.639),(-.342,29.889,3.567),(-.373,30.167,3.662),(-.391,29.748,3.719),(-.488,29.777,3.666),(-.628,29.924,3.252),(-.663,29.918,3.15),(-.786,30.099,3.137),(-.765,29.91,2.761),(-.969,29.845,2.994),(-.999,29.848,2.85),(-1.126,30.154,1.719),(-1.089,30.145,1.731),(-1.169,30.101,1.712),(-1.142,29.944,1.743),(-1.035,30.138,1.733),(-1.137,29.913,1.749),(-.877,29.956,1.749),(.314,29.889,3.567),(.413,30.163,3.639),(.461,30.152,3.615),(.345,30.167,3.662),(.46,29.777,3.666),(.363,29.748,3.719),(.758,30.099,3.137),(.635,29.918,3.15),(.6,29.924,3.252),(.971,29.848,2.85),(.94,29.845,2.994),(.737,29.91,2.761),(1.098,30.154,1.719),(1.141,30.101,1.712),(1.061,30.145,1.731),(1.114,29.944,1.743),(1.007,30.138,1.733),(1.109,29.913,1.749),(.849,29.956,1.749),(-1.157,30.448,1.688),(-1.009,30.441,1.784),(-1.187,30.299,1.673),(-1.005,30.179,1.796),(-1.148,30.168,1.72),(-1.174,30.177,1.699),(-1.192,30.207,1.676),(1.129,30.448,1.688),(1.159,30.299,1.673),(.981,30.441,1.784),(.977,30.179,1.796),(1.12,30.168,1.72),(1.146,30.177,1.699),(1.164,30.207,1.676),(-.923,30.057,3.779),(-1.059,30.097,3.589),(-.946,29.997,3.782),(-2.472,33.89,3.05),(-2.474,33.881,3.05),(-2.471,33.885,3.056),(-2.47,33.879,3.054),(-1.126,30.208,3.478),(-1.023,30.204,3.566),(-2.371,34.033,3.181),(-2.216,34.071,3.362),(-2.219,34.171,3.324),(-1.471,34.081,3.753),(-1.474,34.147,3.748),(-1.883,34.121,3.559),(-.443,34.182,3.939),(-.608,34.297,3.902),(-.636,34.151,3.924),(-.923,30.209,3.688),(-.928,30.142,3.739),(-1.003,30.22,3.55),(-.936,29.835,3.322),(-1.076,30.213,3.396),(-1.002,30.22,3.44),(-1.005,30.228,3.553),(-1.028,30.226,3.573),(-1.071,30.264,3.618),(-1.107,30.306,3.644),(-.634,30.487,4.192),(-.853,30.401,4.046),(-.626,30.399,4.154),(-.107,30.281,4.185),(-.197,30.29,4.176),(-.101,30.207,4.102),(-1.07,30.543,3.514),(-1.004,30.228,3.443),(-1.115,30.789,3.329),(-1.219,30.351,3.253),(-.954,29.536,3.103),(-1.164,29.934,3.178),(.918,29.997,3.782),(1.031,30.097,3.589),(.895,30.057,3.779),(2.444,33.89,3.05),(2.443,33.885,3.056),(2.445,33.881,3.05),(2.442,33.879,3.054),(.995,30.204,3.566),(1.098,30.208,3.478),(2.191,34.171,3.324),(2.188,34.071,3.362),(2.343,34.033,3.181),(1.855,34.121,3.559),(1.446,34.147,3.748),(1.443,34.081,3.753),(.608,34.151,3.924),(.58,34.297,3.902),(.415,34.182,3.939),(.9,30.142,3.739),(.895,30.209,3.688),(.975,30.22,3.55),(.974,30.22,3.44),(1.048,30.213,3.396),(.908,29.835,3.322),(1,30.226,3.573),(.977,30.228,3.553),(1.043,30.264,3.618),(1.079,30.306,3.644),(.598,30.399,4.154),(.825,30.401,4.046),(.606,30.487,4.192),(.073,30.207,4.102),(.169,30.29,4.176),(.079,30.281,4.185),(.976,30.228,3.443),(1.042,30.543,3.514),(1.087,30.789,3.329),(1.19,30.351,3.253),(.926,29.536,3.103),(1.136,29.934,3.178),(2.019,33.108,3.22),(2.014,33.108,3.21),(2.012,33.112,3.208),(1.164,32.985,3.563),(.848,33.13,3.354),(1.166,32.933,3.585),(1.155,32.924,3.558),(.847,33.118,3.352),(1.153,32.986,3.531),(1.148,33.021,3.478),(2.04,33.038,3.314),(2.05,33.082,3.243),(2.025,33.071,3.287),(2.045,33.078,3.235),(2.035,33.033,3.309),(2.007,33.068,3.27),(1.992,33.077,3.254),(1.157,33.042,3.507),(2.014,33.273,3.194),(2.006,33.252,3.305),(1.954,33.302,3.244),(1.993,33.311,3.236),(2.033,33.261,3.295),(2.027,33.277,3.189),(1.083,33.489,3.634),(1.339,33.528,3.739),(1.336,33.509,3.711),(1.926,33.379,3.329),(1.952,33.352,3.391),(1.906,33.321,3.379),(1.896,33.358,3.327),(1.34,33.47,3.713),(1.339,33.497,3.737),(1.096,33.451,3.661),(1.09,33.404,3.515),(.896,33.34,3.327),(.866,33.338,3.326),(1.069,33.425,3.525),(-3.168,33.817,-.807),(-3.164,33.738,-.433),(-3.167,33.982,-.436),(-2.915,31.408,.29),(-3.065,32.028,.224),(-2.943,31.364,.117),(-3.11,32.033,.087),(-3.074,31.715,.057),(-2.997,31.428,.013),(-2.87,31.161,.171),(-2.877,31.199,-.066),(-1.458,33.901,3.726),(-1.45,33.84,3.681),(-.988,33.854,3.743),(-2.218,31.414,3.244),(-2.289,31.814,3.25),(-2.315,31.455,3.156),(-2.283,31.16,3.05),(-1.191,29.316,3.668),(-1.101,29.61,3.595),(-1.385,29.18,3.47),(-1.218,29.109,3.642),(-1.196,30.008,3.496),(-1.192,29.805,3.486),(-1.073,29.981,3.633),(-1.039,29.776,3.639),(-.995,29.875,3.683),(-1.524,28.892,3.147),(-1.508,29.219,3.327),(-.913,28.685,3.815),(-1.02,29.039,3.804),(-1.066,28.726,3.69),(-1.716,28.962,2.825),(-1.788,29,2.7),(-1.63,28.682,2.605),(-1.821,29.753,3.049),(-1.53,29.639,3.271),(-1.697,29.806,3.159),(-1.798,29.97,3.128),(-1.915,30.642,3.165),(-1.877,30.735,3.246),(-1.96,30.759,3.159),(-1.896,30.47,3.185),(-1.977,30.525,3.026),(-1.968,30.217,2.972),(-2.129,30.434,2.808),(-3.04,32.821,.832),(-3.034,32.657,.863),(-3.041,32.699,1.298),(-2.565,34.896,2.244),(-2.594,34.694,2.143),(-2.565,34.615,2.38),(-2.63,34.015,2.381),(-2.54,34.602,2.556),(-2.515,34.585,2.728),(-2.503,35.12,2.468),(-2.725,34.171,1.928),(-2.771,34.184,1.767),(-2.867,33.614,1.765),(-1.228,30.189,3.437),(-1.152,30.128,3.485),(-1.276,30.021,3.441),(-1.452,30.046,3.356),(-.924,31.066,3.733),(-1.097,30.768,3.661),(-.857,30.901,3.826),(-1.15,30.674,3.63),(-1.039,30.569,3.741),(-1.222,30.493,3.6),(-1.321,30.661,3.585),(-1.211,30.257,3.496),(-1.123,30.332,3.651),(-.838,29.743,3.792),(-.814,29.953,3.935),(-.817,29.926,3.926),(-1.066,31.05,3.63),(-1.332,31.063,3.632),(-1.145,30.91,3.603),(-.74,31.28,3.818),(-.689,31.107,3.886),(-.363,31.08,4.104),(-.687,30.957,3.962),(-.774,31.903,3.902),(-.715,31.772,3.875),(-.714,31.872,3.94),(-.787,31.566,3.78),(-.843,31.648,3.803),(-.755,31.476,3.782),(-.99,31.19,3.658),(-1.348,30.204,3.442),(-.209,31.555,4.25),(-.192,31.589,4.379),(-.361,31.691,4.324),(-.217,31.608,4.417),(-.252,31.636,4.416),(-.287,31.668,4.406),(-.24,31.584,4.195),(-.43,31.704,4.222),(-.493,31.691,4.153),(-.392,31.608,4.158),(-.518,31.665,4.106),(-.509,31.633,4.076),(-.454,31.61,4.102),(-.217,31.38,4.553),(-.166,31.318,4.469),(-.192,31.375,4.608),(-.014,31.341,4.573),(-.014,31.279,4.427),(-.551,31.314,4.023),(-.426,31.325,4.137),(-.533,31.342,4.05),(-.582,32.003,4.15),(-.415,32.077,4.274),(-.621,31.982,4.039),(-.39,32.035,4.33),(-.334,32.189,4.342),(-.414,32.096,4.249),(-.7,31.87,3.962),(-.708,31.766,3.889),(-.796,31.761,4.022),(-.606,32.007,4.021),(-.305,31.431,4.612),(-.293,31.481,4.746),(-.399,31.501,4.583),(-.431,31.589,4.665),(-.366,31.602,4.759),(-.014,32.073,4.804),(-.014,32.259,4.67),(-.091,32.076,4.804),(-.291,31.966,4.782),(-.24,31.91,4.873),(-.158,32.079,4.789),(-.33,32.057,4.626),(-.689,31.333,3.872),(-.786,31.768,4.116),(-.7,31.899,4.089),(-.36,32.138,4.46),(-.431,31.995,4.47),(-.227,32.262,4.454),(-.479,31.979,4.411),(-.975,32.046,3.783),(-.856,32.096,3.844),(-1.007,32.347,3.709),(-2.404,34.032,3.107),(-2.456,34.263,2.91),(-2.638,33.927,2.61),(-2.589,33.684,2.817),(-.627,33.747,3.727),(-.672,33.588,3.4),(-.457,33.661,3.713),(-1.814,33.768,3.522),(-2.043,33.666,3.369),(-1.786,33.71,3.491),(-.575,34.692,3.818),(-.574,34.331,3.879),(-.259,34.663,3.846),(-.392,34.202,3.926),(-.229,34.274,3.932),(-.791,33.229,3.281),(-.857,33.145,3.317),(-.738,33.13,3.268),(-.996,33.024,3.363),(-.967,32.93,3.336),(-2.086,32.944,3.15),(-2.221,32.99,3.033),(-2.098,32.914,3.146),(-.654,33.232,3.284),(-.704,33.285,3.265),(-.641,33.344,3.247),(-.571,33.218,3.335),(-.755,33.454,3.23),(-.766,33.428,3.256),(-2.074,33.223,3.083),(-2.108,33.195,3.066),(-2.041,33.178,3.094),(-2.111,33.303,3.025),(-2.18,33.211,3.034),(-2.099,33.271,3.048),(-2.141,33.084,3.068),(-1.17,33.691,3.471),(-1.36,33.662,3.479),(-1.172,33.63,3.416),(-.742,33.473,3.269),(-2.151,33.32,3.031),(-.564,33.448,3.425),(-.519,33.373,3.454),(-.364,33.52,3.655),(-.539,33.112,3.495),(-.524,33.069,3.561),(-.434,33.176,3.597),(-.684,33.022,3.351),(-2.282,33.116,2.973),(-2.309,33.249,2.97),(-2.441,30.362,-1.515),(-2.292,29.72,-1.577),(-2.31,29.67,-1.406),(-1.447,28.894,1.308),(-1.34,28.636,.877),(-1.198,28.54,1.038),(-2.362,33.731,3.12),(-2.45,33.539,2.939),(-1.26,31.612,3.77),(-1.637,31.502,3.61),(-1.488,31.283,3.622),(-1.692,31.001,3.47),(-1.868,31.445,3.487),(-1.883,31.135,3.374),(-.98,33.7,3.462),(-.98,33.789,3.664),(-.793,28.445,3.706),(-.638,28.366,3.684),(-.634,28.469,3.798),(.189,31.38,4.553),(.164,31.375,4.608),(.138,31.318,4.469),(.063,32.076,4.804),(-2.757,33.04,2.451),(-2.769,32.723,2.485),(-2.596,33.008,2.747),(-2.908,32.703,2.086),(-2.89,32.413,2.292),(-3.006,32.374,1.787),(-2.988,32.749,1.666),(-2.917,32.023,2.053),(-1.754,32.167,3.506),(-1.776,32.415,3.461),(-1.832,32.152,3.468),(-.763,35.835,3.366),(-.943,36.48,3.031),(-.975,35.805,3.348),(-.281,28.268,3.304),(-.165,28.233,2.835),(-.17,28.253,3.329),(-1.854,30.87,3.318),(-1.758,30.844,3.412),(-1.863,30.971,3.331),(-2.88,31.736,1.307),(-2.943,31.807,1.028),(-2.783,31.276,1.022),(-3.016,32.317,.941),(-3.021,32.342,1.364),(-2.946,31.987,1.496),(-2.79,31.57,1.809),(-2.663,30.652,1.472),(-2.719,30.708,1.077),(-2.648,30.149,1.16),(-2.491,30.457,1.862),(-2.508,30.58,1.906),(-2.427,29.634,1.53),(-2.473,29.988,1.691),(-2.536,29.832,1.392),(-3.124,32.499,.152),(-3.113,32.326,.187),(-3.048,32.305,.448),(-2.862,31.18,.527),(-2.883,31.405,.51),(-2.66,30.205,.658),(-2.57,29.96,.828),(-.951,28.452,3.575),(-.802,28.354,3.557),(-2.955,31.547,-1.169),(-3.01,31.532,-.805),(-3.02,31.716,-1.034),(-2.42,29.484,-.492),(-1.678,35.024,-3.648),(-1.254,35.216,-3.828),(-1.225,35.088,-3.861),(-2.585,34.713,-2.856),(-2.243,35.082,-3.211),(-2.173,34.829,-3.289),(-2.953,34.723,-2.238),(-2.893,34.456,-2.358),(-3.119,34.118,-1.805),(-1.958,29.255,.297),(-2.132,29.855,.498),(-2.35,30.147,.315),(-3.029,32.119,-1.288),(-2.915,32.188,-1.776),(-3.043,32.451,-1.352),(-3.089,33.03,-1.326),(-3.125,33.303,-1.276),(-3.024,33.548,-1.927),(-1.061,28.373,2.374),(-1.16,28.483,1.943),(-.947,28.417,1.874),(-.817,28.397,1.418),(-.972,28.443,1.338),(-1.004,28.33,2.769),(-1.001,28.358,3.207),(-1.261,28.414,2.827),(-.631,28.314,3.544),(-.546,35.47,-3.952),(-.609,35.166,-4.024),(-.689,35.416,-3.932),(-2.638,36.028,1.429),(-2.773,35.465,1.317),(-2.633,35.973,1.558),(-2.948,34.175,1.192),(-2.988,33.668,1.215),(-2.9,34.191,1.327),(-.32,33.238,2.716),(-.431,33.44,2.714),(-.426,33.059,2.714),(-.725,32.934,2.711),(-.762,33.67,2.715),(-1.184,32.816,2.717),(-1.674,32.789,2.745),(-1.227,33.831,2.716),(-2.103,32.849,2.771),(-2.371,32.98,2.776),(-2.469,33.149,2.776),(-2.402,33.411,2.776),(-2.121,33.695,2.761),(-1.697,33.853,2.733),(-1.319,33.48,3.462),(-1.222,33.843,2.745),(-1.177,33.449,3.416),(-3.239,33.355,-.396),(-3.229,33.22,-.271),(-3.191,33.484,-.187),(-3.052,31.842,-.753),(-3.08,32.007,-.932),(-2.918,31.256,-.366),(-2.965,31.312,-.255),(-3.002,31.48,-.372),(-3.242,33.331,-.392),(-3.185,32.855,-.163),(-3.195,32.814,-.203),(-3.179,32.68,-.084),(-3.493,32.591,-1.022),(-3.354,32.551,-.996),(-3.506,32.668,-.966),(-3.273,32.565,-.24),(-3.247,32.619,-.37),(-3.17,32.535,-.351),(-3.516,33.309,-.555),(-3.405,33.242,-.569),(-3.464,33.366,-.402),(-3.244,31.97,-.228),(-3.307,31.93,-.237),(-3.275,31.967,-.204),(-3.339,32.015,-.39),(-3.292,31.987,-.353),(-3.162,32.016,-.538),(-3.398,32.766,-.378),(-3.408,32.721,-.473),(-3.331,32.648,-.664),(-3.372,32.737,-.587),(-3.088,32.414,-.417),(-3.15,32.327,-.319),(-3.165,32.475,-.323),(-3.237,31.971,-.332),(-3.18,31.989,-.312),(-3.114,32.055,-.561),(-3.286,31.587,-.171),(-3.305,31.931,-.154),(-3.324,31.847,-.207),(-3.144,31.945,-.014),(-3.087,31.47,-.067),(-3.051,31.467,-.062),(-3.329,32.43,-.178),(-3.375,32.407,-.276),(-3.56,31.669,-1.127),(-3.498,31.584,-.901),(-3.56,31.705,-1.103),(-3.011,31.366,-.21),(-3.082,31.381,-.442),(-3.123,31.502,-.403),(-3.078,31.509,-.368),(-2.998,31.36,-.283),(-3.035,31.51,-.36),(-3.016,31.504,-.358),(-3.152,32.025,-.008),(-3.48,32.923,-.482),(-3.377,32.924,-.545),(-3.319,33.352,-.294),(-3.358,33.342,-.248),(-3.291,33.141,-.244),(-3.631,33.123,-.877),(-3.672,33.018,-.931),(-3.61,32.929,-.845),(-3.543,32.607,-1.025),(-3.411,32.351,-1.026),(-3.254,33.335,-.379),(-3.353,33.49,-.677),(-3.335,33.478,-.583),(-3.297,33.427,-.65),(-3.435,33.382,-.979),(-3.387,33.473,-.83),(-3.356,33.359,-.852),(-3.195,33.003,-.164),(-3.207,32.971,-.183),(-3.219,32.956,-.198),(-3.042,31.464,-.055),(-2.995,31.341,-.131),(3.139,33.982,-.436),(3.136,33.738,-.433),(3.14,33.817,-.807),(2.914,31.364,.117),(3.037,32.028,.224),(2.887,31.408,.29),(3.082,32.033,.087),(3.046,31.715,.057),(2.969,31.428,.013),(2.849,31.199,-.066),(2.842,31.161,.171),(.96,33.854,3.743),(1.422,33.84,3.681),(1.43,33.901,3.726),(2.287,31.455,3.156),(2.261,31.814,3.25),(2.19,31.414,3.244),(2.255,31.16,3.05),(1.357,29.18,3.47),(1.073,29.61,3.595),(1.162,29.316,3.668),(1.19,29.109,3.642),(1.168,30.008,3.496),(1.045,29.981,3.633),(1.164,29.805,3.486),(1.011,29.776,3.639),(.967,29.875,3.683),(1.48,29.219,3.327),(1.496,28.892,3.147),(1.038,28.726,3.69),(.992,29.039,3.804),(.885,28.685,3.815),(1.602,28.682,2.605),(1.76,29,2.7),(1.688,28.962,2.825),(1.669,29.806,3.159),(1.502,29.639,3.271),(1.793,29.753,3.049),(1.769,29.97,3.128),(1.932,30.759,3.159),(1.848,30.735,3.246),(1.887,30.642,3.165),(1.94,30.217,2.972),(1.949,30.525,3.026),(1.867,30.47,3.185),(2.101,30.434,2.808),(3.013,32.699,1.298),(3.006,32.657,.863),(3.012,32.821,.832),(2.512,34.602,2.556),(2.474,35.12,2.468),(2.487,34.585,2.728),(2.602,34.015,2.381),(2.537,34.615,2.38),(2.566,34.694,2.143),(2.537,34.896,2.244),(2.839,33.614,1.765),(2.743,34.184,1.767),(2.696,34.171,1.928),(1.424,30.046,3.356),(1.2,30.189,3.437),(1.248,30.021,3.441),(1.124,30.128,3.485),(.829,30.901,3.826),(1.069,30.768,3.661),(.896,31.066,3.733),(1.011,30.569,3.741),(1.122,30.674,3.63),(1.293,30.661,3.585),(1.193,30.493,3.6),(1.095,30.332,3.651),(1.183,30.257,3.496),(.81,29.743,3.792),(.789,29.926,3.926),(.786,29.953,3.935),(1.117,30.91,3.603),(1.303,31.063,3.632),(1.038,31.05,3.63),(.661,31.107,3.886),(.712,31.28,3.818),(.659,30.957,3.962),(.335,31.08,4.104),(.686,31.872,3.94),(.687,31.772,3.875),(.746,31.903,3.902),(.815,31.648,3.803),(.759,31.566,3.78),(.962,31.19,3.658),(.727,31.476,3.782),(1.32,30.204,3.442),(.181,31.555,4.25),(.333,31.691,4.324),(.164,31.589,4.379),(.189,31.608,4.417),(.224,31.636,4.416),(.259,31.668,4.406),(.212,31.584,4.195),(.402,31.704,4.222),(.364,31.608,4.158),(.465,31.691,4.153),(.49,31.665,4.106),(.481,31.633,4.076),(.426,31.61,4.102),(.505,31.342,4.05),(.398,31.325,4.137),(.523,31.314,4.023),(.593,31.982,4.039),(.386,32.077,4.274),(.554,32.003,4.15),(.362,32.035,4.33),(.386,32.096,4.249),(.306,32.189,4.342),(.768,31.761,4.022),(.68,31.766,3.889),(.672,31.87,3.962),(.578,32.007,4.021),(.277,31.431,4.612),(.371,31.501,4.583),(.265,31.481,4.746),(.403,31.589,4.665),(.338,31.602,4.759),(.13,32.079,4.789),(.212,31.91,4.873),(.263,31.966,4.782),(.302,32.057,4.626),(.661,31.333,3.872),(.672,31.899,4.089),(.758,31.768,4.116),(.403,31.995,4.47),(.332,32.138,4.46),(.199,32.262,4.454),(.451,31.979,4.411),(.979,32.347,3.709),(.828,32.096,3.844),(.947,32.046,3.783),(2.428,34.263,2.91),(2.376,34.032,3.107),(2.61,33.927,2.61),(2.561,33.684,2.817),(.429,33.661,3.713),(.644,33.588,3.4),(.599,33.747,3.727),(1.758,33.71,3.491),(2.015,33.666,3.369),(1.786,33.768,3.522),(.547,34.692,3.818),(.231,34.663,3.846),(.546,34.331,3.879),(.364,34.202,3.926),(.201,34.274,3.932),(.71,33.13,3.268),(.829,33.145,3.317),(.763,33.229,3.281),(.939,32.93,3.336),(.968,33.024,3.363),(2.07,32.914,3.146),(2.193,32.99,3.033),(2.058,32.944,3.15),(.626,33.232,3.284),(.613,33.344,3.247),(.676,33.285,3.265),(.543,33.218,3.335),(.738,33.428,3.256),(.727,33.454,3.23),(2.071,33.271,3.048),(2.152,33.211,3.034),(2.083,33.303,3.025),(2.013,33.178,3.094),(2.08,33.195,3.066),(2.046,33.223,3.083),(2.113,33.084,3.068),(1.144,33.63,3.416),(1.332,33.662,3.479),(1.142,33.691,3.471),(.714,33.473,3.269),(2.123,33.32,3.031),(.336,33.52,3.655),(.491,33.373,3.454),(.536,33.448,3.425),(.406,33.176,3.597),(.496,33.069,3.561),(.51,33.112,3.495),(.656,33.022,3.351),(2.281,33.249,2.97),(2.254,33.116,2.973),(2.282,29.67,-1.406),(2.264,29.72,-1.577),(2.413,30.362,-1.515),(1.17,28.54,1.038),(1.312,28.636,.877),(1.418,28.894,1.308),(2.334,33.731,3.12),(2.422,33.539,2.939),(1.46,31.283,3.622),(1.609,31.502,3.61),(1.232,31.612,3.77),(1.855,31.135,3.374),(1.84,31.445,3.487),(1.664,31.001,3.47),(.952,33.789,3.664),(.952,33.7,3.462),(.606,28.469,3.798),(.61,28.366,3.684),(.765,28.445,3.706),(2.567,33.008,2.747),(2.741,32.723,2.485),(2.729,33.04,2.451),(2.862,32.413,2.292),(2.88,32.703,2.086),(2.978,32.374,1.787),(2.959,32.749,1.666),(2.889,32.023,2.053),(1.804,32.152,3.468),(1.748,32.415,3.461),(1.725,32.167,3.506),(.947,35.805,3.348),(.915,36.48,3.031),(.735,35.835,3.366),(.142,28.253,3.329),(.137,28.233,2.835),(.253,28.268,3.304),(1.835,30.971,3.331),(1.73,30.844,3.412),(1.826,30.87,3.318),(2.755,31.276,1.022),(2.915,31.807,1.028),(2.852,31.736,1.307),(2.988,32.317,.941),(2.993,32.342,1.364),(2.918,31.987,1.496),(2.762,31.57,1.809),(2.62,30.149,1.16),(2.691,30.708,1.077),(2.635,30.652,1.472),(2.48,30.58,1.906),(2.463,30.457,1.862),(2.508,29.832,1.392),(2.445,29.988,1.691),(2.399,29.634,1.53),(3.02,32.305,.448),(3.085,32.326,.187),(3.096,32.499,.152),(2.855,31.405,.51),(2.834,31.18,.527),(2.542,29.96,.828),(2.632,30.205,.658),(.774,28.354,3.557),(.923,28.452,3.575),(2.992,31.716,-1.034),(2.982,31.532,-.805),(2.927,31.547,-1.169),(2.392,29.484,-.492),(1.197,35.088,-3.861),(1.226,35.216,-3.828),(1.65,35.024,-3.648),(2.145,34.829,-3.289),(2.215,35.082,-3.211),(2.557,34.713,-2.856),(3.091,34.118,-1.805),(2.865,34.456,-2.358),(2.925,34.723,-2.238),(2.322,30.147,.315),(2.104,29.855,.498),(1.93,29.255,.297),(3.001,32.119,-1.288),(3.015,32.451,-1.352),(2.886,32.188,-1.776),(2.995,33.548,-1.927),(3.097,33.303,-1.276),(3.061,33.03,-1.326),(.919,28.417,1.874),(1.132,28.483,1.943),(1.032,28.373,2.374),(.944,28.443,1.338),(.789,28.397,1.418),(1.233,28.414,2.827),(.973,28.358,3.207),(.976,28.33,2.769),(.603,28.314,3.544),(.661,35.416,-3.932),(.581,35.166,-4.024),(.518,35.47,-3.952),(2.605,35.973,1.558),(2.745,35.465,1.317),(2.609,36.028,1.429),(2.872,34.191,1.327),(2.96,33.668,1.215),(2.92,34.175,1.192),(.292,33.238,2.716),(.398,33.059,2.714),(.403,33.44,2.714),(.697,32.934,2.711),(.734,33.67,2.715),(1.155,32.816,2.717),(1.646,32.789,2.745),(1.198,33.831,2.716),(2.075,32.849,2.771),(2.343,32.98,2.776),(2.441,33.149,2.776),(2.374,33.411,2.776),(2.092,33.695,2.761),(1.669,33.853,2.733),(1.149,33.449,3.416),(1.194,33.843,2.745),(1.291,33.48,3.462),(3.163,33.484,-.187),(3.201,33.22,-.271),(3.211,33.355,-.396),(3.052,32.007,-.932),(3.024,31.842,-.753),(2.973,31.48,-.372),(2.936,31.312,-.255),(2.89,31.256,-.366),(3.214,33.331,-.392),(3.151,32.68,-.084),(3.167,32.814,-.203),(3.157,32.855,-.163),(3.478,32.668,-.966),(3.326,32.551,-.996),(3.465,32.591,-1.022),(3.142,32.535,-.351),(3.219,32.619,-.37),(3.245,32.565,-.24),(3.436,33.366,-.402),(3.377,33.242,-.569),(3.488,33.309,-.555),(3.247,31.967,-.204),(3.279,31.93,-.237),(3.216,31.97,-.228),(3.134,32.016,-.538),(3.264,31.987,-.353),(3.311,32.015,-.39),(3.344,32.737,-.587),(3.38,32.721,-.473),(3.303,32.648,-.664),(3.37,32.766,-.378),(3.137,32.475,-.323),(3.122,32.327,-.319),(3.06,32.414,-.417),(3.086,32.055,-.561),(3.152,31.989,-.312),(3.209,31.971,-.332),(3.296,31.847,-.207),(3.277,31.931,-.154),(3.258,31.587,-.171),(3.023,31.467,-.062),(3.059,31.47,-.067),(3.116,31.945,-.014),(3.347,32.407,-.276),(3.301,32.43,-.178),(3.532,31.705,-1.103),(3.47,31.584,-.901),(3.532,31.669,-1.127),(3.095,31.502,-.403),(3.054,31.381,-.442),(2.983,31.366,-.21),(3.05,31.509,-.368),(3.007,31.51,-.36),(2.97,31.36,-.283),(2.988,31.504,-.358),(3.124,32.025,-.008),(3.349,32.924,-.545),(3.452,32.923,-.482),(3.263,33.141,-.244),(3.33,33.342,-.248),(3.29,33.352,-.294),(3.582,32.929,-.845),(3.644,33.018,-.931),(3.603,33.123,-.877),(3.383,32.351,-1.026),(3.515,32.607,-1.025),(3.226,33.335,-.379),(3.269,33.427,-.65),(3.307,33.478,-.583),(3.325,33.49,-.677),(3.328,33.359,-.852),(3.359,33.473,-.83),(3.407,33.382,-.979),(3.179,32.971,-.183),(3.167,33.003,-.164),(3.191,32.956,-.198),(3.014,31.464,-.055),(2.967,31.341,-.131),(-1.5,32.952,3.61),(-1.505,32.9,3.645),(-1.728,32.986,3.567),(-1.748,32.928,3.591),(-1.727,32.98,3.525),(-1.757,32.92,3.556),(-1.496,32.945,3.573),(-1.504,32.893,3.61),(-.953,33.131,3.373),(-.956,33.135,3.371),(-2.028,33.102,3.255),(-2.01,33.118,3.221),(-2.015,33.106,3.227),(-1.7,33.037,3.475),(-1.69,33.056,3.471),(-1.484,33.028,3.503),(-1.482,33.01,3.508),(-1.165,33.057,3.472),(-1.176,33.069,3.464),(-1.71,33.033,3.512),(-1.491,33.004,3.547),(-1.495,32.986,3.533),(-1.715,33.016,3.497),(-2.047,33.296,3.149),(-2.034,33.292,3.154),(-2.008,33.339,3.177),(-1.97,33.326,3.191),(-1.948,33.421,3.266),(-1.915,33.399,3.27),(-1.832,33.463,3.399),(-1.809,33.436,3.395),(-1.577,33.525,3.539),(-1.576,33.491,3.533),(-1.342,33.509,3.544),(-1.349,33.478,3.533),(-1.589,33.46,3.595),(-1.825,33.401,3.457),(-1.844,33.399,3.463),(-1.59,33.494,3.602),(-1.084,33.46,3.464),(-1.105,33.438,3.454),(-.89,33.349,3.304),(-.92,33.351,3.305),(-1.361,33.449,3.595),(-1.355,33.48,3.605),(-2.001,33.32,3.47),(-2.033,33.344,3.467),(-1.886,33.415,3.648),(-1.91,33.44,3.641),(-1.618,33.503,3.743),(-1.622,33.534,3.742),(-1.866,33.41,3.552),(-1.841,33.392,3.557),(-1.605,33.519,3.706),(-1.601,33.477,3.709),(-.805,30.043,2.187),(-.738,30.096,2.239),(-.545,30.139,2.284),(-.265,30.166,2.33),(-.076,30.146,2.348),(-.014,30.146,2.348),(-.215,29.706,2.365),(-.014,29.706,2.365),(-.809,29.831,2.155),(-.212,29.795,3.051),(-.476,29.813,3.051),(-.838,29.833,2.589),(-.014,29.795,3.051),(-.165,29.86,3.367),(-.014,29.86,3.367),(-.103,29.899,3.551),(-.014,29.899,3.551),(-.28,29.924,3.565),(-.088,29.918,3.607),(-.289,30.008,3.619),(-.014,29.918,3.607),(-.092,29.985,3.661),(-.837,30.03,2.65),(-.769,30.109,2.755),(-.828,30.016,3.036),(-.555,30.177,2.853),(-.756,30.085,3.181),(-.257,30.208,2.947),(-.568,30.13,3.341),(-.069,30.187,2.978),(-.273,30.156,3.479),(-.014,30.187,2.978),(-.075,30.139,3.521),(-.014,30.139,3.521),(-.086,30.08,3.64),(-.288,30.098,3.596),(-.572,30.089,3.452),(-.738,30.065,3.296),(-.789,30.034,3.222),(-.014,30.08,3.64),(-.014,29.985,3.661),(.06,29.918,3.607),(.063,29.985,3.661),(.075,29.899,3.551),(.047,30.139,3.521),(.041,30.187,2.978),(.048,30.146,2.348),(.058,30.08,3.64),(.137,29.86,3.367),(.184,29.795,3.051),(.187,29.706,2.365),(.781,29.831,2.155),(.237,30.166,2.33),(.517,30.139,2.284),(.71,30.096,2.239),(.777,30.043,2.187),(.448,29.813,3.051),(.81,29.833,2.589),(.251,29.924,3.565),(.261,30.008,3.619),(.809,30.03,2.65),(.741,30.109,2.755),(.8,30.016,3.036),(.527,30.177,2.853),(.728,30.085,3.181),(.229,30.208,2.947),(.54,30.13,3.341),(.245,30.156,3.479),(.26,30.098,3.596),(.544,30.089,3.452),(.71,30.065,3.296),(.761,30.034,3.222),(-.453,29.919,3.512),(-.527,29.935,3.457),(-.642,30.204,3.534),(-.573,30.189,3.575),(-.512,29.792,3.633),(-.596,29.796,3.62),(-.601,29.949,3.387),(-.644,30.15,3.46),(-.665,30.212,3.552),(-.606,30.201,3.596),(-.084,29.812,3.645),(-.014,29.789,3.663),(-.014,29.689,3.72),(-.126,29.692,3.734),(-.104,30.159,3.711),(-.014,30.132,3.705),(.098,29.692,3.734),(.056,29.812,3.645),(-.125,29.73,3.746),(-.014,29.725,3.733),(-.158,29.837,3.64),(-.24,29.725,3.73),(-.704,29.802,3.55),(-.712,30.125,3.356),(-.687,30.173,3.462),(-.509,30.16,3.624),(-.467,30.175,3.659),(-.293,30.15,3.696),(-.232,29.86,3.621),(-.392,30.177,3.689),(-.311,30.155,3.713),(-.213,30.162,3.711),(-.3,29.747,3.718),(-.226,30.168,3.738),(-.108,30.162,3.742),(-.014,30.135,3.735),(.076,30.159,3.711),(-.303,29.782,3.724),(-.241,29.76,3.738),(-.492,29.809,3.673),(-.394,29.782,3.724),(-.603,29.83,3.624),(-.518,29.825,3.639),(-.708,29.838,3.556),(-.607,29.942,3.339),(-.738,29.821,3.45),(-.818,29.825,3.393),(-.82,29.867,3.395),(-.743,29.856,3.455),(-.87,29.836,3.311),(-.735,30.114,3.274),(-.87,29.877,3.31),(-.716,29.938,2.983),(-.898,29.816,3.148),(-.972,29.88,2.995),(-.9,29.853,3.15),(-.889,30.105,2.824),(-.851,30.122,2.972),(-1.062,29.862,2.507),(-.811,29.92,2.436),(-1.067,29.895,2.506),(-1.004,29.882,2.849),(-1.139,29.861,2.205),(-.845,29.932,2.104),(-.947,30.102,2.513),(-1.144,29.895,2.201),(-1.17,29.903,1.874),(-.871,29.948,1.857),(-.996,30.102,2.174),(-1.174,29.936,1.87),(-1.032,30.133,1.845),(-1.194,30.1,1.846),(-1.136,30.154,1.844),(-1.091,30.143,1.847),(-1.056,30.113,2.174),(-1.107,30.125,2.172),(-1.168,30.068,2.181),(-1.003,30.112,2.51),(-1.045,30.121,2.505),(-1.093,30.064,2.501),(-.941,30.112,2.826),(-.982,30.118,2.834),(-1.027,30.054,2.846),(-.902,30.128,2.976),(-.943,30.131,2.988),(-.991,30.059,3),(-.831,30.103,3.14),(-.866,30.104,3.151),(-.911,30.041,3.158),(-.78,30.121,3.278),(-.818,30.129,3.293),(-.871,30.082,3.31),(-.754,30.129,3.362),(-.786,30.13,3.381),(-.827,30.072,3.401),(-.716,30.16,3.462),(-.739,30.132,3.474),(-.763,30.032,3.479),(-.681,30.197,3.559),(-.705,30.149,3.575),(-.728,30.014,3.582),(-.624,30.188,3.606),(-.639,30.14,3.63),(-.637,30.002,3.647),(-.523,30.15,3.631),(-.542,30.107,3.657),(-.546,29.985,3.669),(-.483,30.16,3.669),(-.502,30.105,3.694),(-.513,29.972,3.703),(-.402,30.16,3.703),(-.411,30.099,3.731),(-.412,29.952,3.75),(-.319,30.141,3.722),(-.321,30.093,3.746),(-.316,29.953,3.753),(-.233,30.15,3.75),(-.242,30.091,3.773),(-.248,29.94,3.777),(-.11,30.141,3.758),(-.113,30.078,3.789),(-.119,29.919,3.806),(-.014,30.115,3.75),(-.014,30.056,3.779),(-.014,29.905,3.796),(.08,30.162,3.742),(.082,30.141,3.758),(.084,30.078,3.789),(.091,29.919,3.806),(.097,29.73,3.746),(.545,30.189,3.575),(.614,30.204,3.534),(.499,29.935,3.457),(.425,29.919,3.512),(.578,30.201,3.596),(.637,30.212,3.552),(.616,30.15,3.46),(.572,29.949,3.387),(.568,29.796,3.62),(.484,29.792,3.633),(.212,29.725,3.73),(.13,29.837,3.64),(.659,30.173,3.462),(.684,30.125,3.356),(.676,29.802,3.55),(.439,30.175,3.659),(.481,30.16,3.624),(.204,29.86,3.621),(.265,30.15,3.696),(.272,29.747,3.718),(.185,30.162,3.711),(.283,30.155,3.713),(.364,30.177,3.689),(.198,30.168,3.738),(.213,29.76,3.738),(.275,29.782,3.724),(.366,29.782,3.724),(.464,29.809,3.673),(.49,29.825,3.639),(.575,29.83,3.624),(.68,29.838,3.556),(.71,29.821,3.45),(.579,29.942,3.339),(.79,29.825,3.393),(.706,30.114,3.274),(.842,29.836,3.311),(.715,29.856,3.455),(.792,29.867,3.395),(.842,29.877,3.31),(.87,29.816,3.148),(.688,29.938,2.983),(.823,30.122,2.972),(.861,30.105,2.824),(.872,29.853,3.15),(.944,29.88,2.995),(.783,29.92,2.436),(1.034,29.862,2.507),(.919,30.102,2.513),(.817,29.932,2.104),(1.111,29.861,2.205),(.976,29.882,2.849),(1.039,29.895,2.506),(.968,30.102,2.174),(.843,29.948,1.857),(1.142,29.903,1.874),(1.116,29.895,2.201),(1.004,30.133,1.845),(1.146,29.936,1.87),(1.063,30.143,1.847),(1.108,30.154,1.844),(1.166,30.1,1.846),(1.028,30.113,2.174),(1.079,30.125,2.172),(1.14,30.068,2.181),(.975,30.112,2.51),(1.017,30.121,2.505),(1.065,30.064,2.501),(.913,30.112,2.826),(.954,30.118,2.834),(.999,30.054,2.846),(.874,30.128,2.976),(.915,30.131,2.988),(.963,30.059,3),(.803,30.103,3.14),(.838,30.104,3.151),(.883,30.041,3.158),(.752,30.121,3.278),(.79,30.129,3.293),(.843,30.082,3.31),(.726,30.129,3.362),(.758,30.13,3.381),(.799,30.072,3.401),(.688,30.16,3.462),(.711,30.132,3.474),(.735,30.032,3.479),(.653,30.197,3.559),(.677,30.149,3.575),(.7,30.014,3.582),(.596,30.188,3.606),(.611,30.14,3.63),(.609,30.002,3.647),(.495,30.15,3.631),(.514,30.107,3.657),(.518,29.985,3.669),(.455,30.16,3.669),(.474,30.105,3.694),(.485,29.972,3.703),(.374,30.16,3.703),(.383,30.099,3.731),(.384,29.952,3.75),(.291,30.141,3.722),(.293,30.093,3.746),(.288,29.953,3.753),(.205,30.15,3.75),(.214,30.091,3.773),(.22,29.94,3.777),(-1.181,30.245,2.041),(-1.163,30.196,2.052),(-1.176,30.357,2.039),(-1.147,30.502,2.044),(-.999,30.491,2.099),(-.996,30.203,2.114),(-1.14,30.19,2.068),(-.244,30.127,3.786),(-.354,30.177,3.732),(-.36,30.56,3.697),(-.253,30.558,3.749),(-.376,30.159,3.802),(-.245,30.11,3.858),(-.493,30.143,3.694),(-.501,30.558,3.657),(-.265,30.574,3.823),(-.381,30.577,3.766),(-.044,30.134,3.787),(-.091,30.555,3.75),(-.014,30.572,3.802),(-.014,30.556,3.73),(-.089,30.572,3.824),(.061,30.572,3.824),(.063,30.555,3.75),(-.014,30.151,3.763),(-.014,30.422,3.846),(-.072,30.421,3.866),(-.05,30.118,3.859),(-.014,30.135,3.836),(.016,30.134,3.787),(.022,30.118,3.859),(-.014,30.158,3.863),(-.052,30.142,3.885),(-.246,30.133,3.884),(-.523,30.128,3.758),(-.38,30.176,3.83),(-.702,30.176,3.621),(-.632,30.192,3.548),(-.528,30.147,3.785),(-.712,30.192,3.643),(-.773,30.128,3.567),(-.686,30.142,3.485),(-.647,30.546,3.53),(-.848,30.225,3.397),(-.791,30.241,3.356),(-.718,30.54,3.445),(-.784,30.152,3.587),(-.855,30.241,3.412),(-.913,30.192,3.355),(-.817,30.2,3.289),(-.785,30.533,3.324),(-.974,30.171,3.226),(-.864,30.179,3.192),(-.813,30.528,3.263),(-.924,30.206,3.374),(-.962,30.23,3.12),(-.895,30.248,3.101),(-.86,30.522,3.166),(-.986,30.184,3.24),(-1.02,30.169,3.015),(-.91,30.177,2.984),(-.891,30.517,3.08),(-.971,30.237,3.131),(-1.042,30.182,2.833),(-.907,30.196,2.833),(-.905,30.508,2.96),(-1.033,30.181,3.025),(-1.127,30.179,2.634),(-.912,30.192,2.631),(-.903,30.5,2.812),(-1.056,30.19,2.837),(-1.095,30.168,2.408),(-.953,30.182,2.438),(-.915,30.49,2.612),(-1.154,30.186,2.634),(-1.154,30.17,2.247),(-.95,30.182,2.276),(-.957,30.479,2.42),(-1.118,30.174,2.401),(-.952,30.475,2.259),(-1.182,30.175,2.236),(-1.177,30.484,2.229),(-1.101,30.489,2.391),(-1.206,30.339,2.228),(-1.148,30.502,2.614),(-1.129,30.344,2.394),(-1.042,30.513,2.808),(-1.176,30.358,2.624),(-1.026,30.523,2.988),(-1.068,30.37,2.822),(-.956,30.53,3.098),(-1.05,30.38,3.006),(-.979,30.537,3.202),(-.979,30.389,3.12),(-.916,30.546,3.332),(-1.002,30.394,3.226),(-.841,30.548,3.362),(-.938,30.403,3.36),(-.813,30.555,3.53),(-.86,30.41,3.396),(-.722,30.561,3.605),(-.816,30.4,3.562),(-.736,30.412,3.637),(-.533,30.574,3.723),(-.549,30.43,3.763),(-.391,30.431,3.808),(-.268,30.424,3.865),(.024,30.142,3.885),(-.014,30.292,3.87),(-.06,30.286,3.892),(.032,30.286,3.892),(-.266,30.288,3.891),(.044,30.421,3.866),(-.39,30.305,3.83),(-.548,30.302,3.788),(-.732,30.293,3.654),(-.809,30.273,3.585),(-.861,30.317,3.411),(-.941,30.293,3.375),(-1.005,30.278,3.24),(-.982,30.288,3.132),(-1.053,30.267,3.018),(-1.071,30.261,2.832),(-1.18,30.249,2.631),(-1.133,30.233,2.399),(-1.211,30.228,2.232),(1.112,30.19,2.068),(.968,30.203,2.114),(.971,30.491,2.099),(1.119,30.502,2.044),(1.148,30.357,2.039),(1.153,30.245,2.041),(1.135,30.196,2.052),(.225,30.558,3.749),(.332,30.56,3.697),(.326,30.177,3.732),(.216,30.127,3.786),(.352,30.577,3.766),(.237,30.574,3.823),(.473,30.558,3.657),(.465,30.143,3.694),(.217,30.11,3.858),(.348,30.159,3.802),(.218,30.133,3.884),(.495,30.128,3.758),(.352,30.176,3.83),(.604,30.192,3.548),(.674,30.176,3.621),(.5,30.147,3.785),(.619,30.546,3.53),(.658,30.142,3.485),(.744,30.128,3.567),(.684,30.192,3.643),(.689,30.54,3.445),(.763,30.241,3.356),(.82,30.225,3.397),(.756,30.152,3.587),(.757,30.533,3.324),(.789,30.2,3.289),(.885,30.192,3.355),(.827,30.241,3.412),(.785,30.528,3.263),(.836,30.179,3.192),(.946,30.171,3.226),(.896,30.206,3.374),(.832,30.522,3.166),(.867,30.248,3.101),(.934,30.23,3.12),(.958,30.184,3.24),(.863,30.517,3.08),(.882,30.177,2.984),(.992,30.169,3.015),(.943,30.237,3.131),(.877,30.508,2.96),(.879,30.196,2.833),(1.014,30.182,2.833),(1.005,30.181,3.025),(.874,30.5,2.812),(.884,30.192,2.631),(1.099,30.179,2.634),(1.028,30.19,2.837),(.887,30.49,2.612),(.925,30.182,2.438),(1.067,30.168,2.408),(1.126,30.186,2.634),(.929,30.479,2.42),(.922,30.182,2.276),(1.126,30.17,2.247),(1.09,30.174,2.401),(.924,30.475,2.259),(1.154,30.175,2.236),(1.149,30.484,2.229),(1.073,30.489,2.391),(1.178,30.339,2.228),(1.12,30.502,2.614),(1.1,30.344,2.394),(1.014,30.513,2.808),(1.148,30.358,2.624),(.998,30.523,2.988),(1.04,30.37,2.822),(.928,30.53,3.098),(1.022,30.38,3.006),(.951,30.537,3.202),(.951,30.389,3.12),(.888,30.546,3.332),(.974,30.394,3.226),(.813,30.548,3.362),(.91,30.403,3.36),(.784,30.555,3.53),(.832,30.41,3.396),(.694,30.561,3.605),(.788,30.4,3.562),(.505,30.574,3.723),(.708,30.412,3.637),(.521,30.43,3.763),(.363,30.431,3.808),(.24,30.424,3.865),(.238,30.288,3.891),(.362,30.305,3.83),(.52,30.302,3.788),(.704,30.293,3.654),(.781,30.273,3.585),(.833,30.317,3.411),(.913,30.293,3.375),(.977,30.278,3.24),(.954,30.288,3.132),(1.025,30.267,3.018),(1.043,30.261,2.832),(1.152,30.249,2.631),(1.105,30.233,2.399),(1.183,30.228,2.232),(-.997,33.92,3.824),(-.996,33.926,3.83),(-1.467,33.992,3.761),(-1.467,33.984,3.758),(-.402,33.98,3.914),(-.41,33.983,3.916),(-.517,33.888,3.861),(-.513,33.882,3.856),(-.624,33.877,3.85),(-.624,33.883,3.857),(-2.403,34.026,3.114),(-.4,34.199,3.927),(-.577,34.323,3.882),(-.977,34.328,3.841),(-.978,34.32,3.844),(-1.448,34.317,3.667),(-1.449,34.309,3.672),(-1.864,34.276,3.497),(-1.865,34.268,3.501),(-2.229,34.192,3.294),(-2.229,34.184,3.3),(-2.222,33.965,3.372),(-2.226,33.978,3.372),(-1.884,34,3.555),(-1.885,34.009,3.556),(-1.454,34.287,3.696),(-.992,34.301,3.856),(-1.87,34.245,3.521),(-2.441,33.921,3.117),(-.451,33.988,3.928),(-.533,33.907,3.887),(-.647,33.906,3.882),(-.997,33.945,3.853),(-1.468,34.017,3.758),(-1.885,34.032,3.569),(-2.224,34,3.374),(-1.006,34.011,3.88),(-1.015,34.155,3.88),(-.656,33.989,3.914),(-.805,30.048,3.939),(-.615,30.007,4.07),(-.641,29.9,4.057),(-.313,30.003,4.167),(-.331,29.862,4.139),(-.158,29.857,4.165),(-.137,30.008,4.18),(-.014,29.852,4.164),(-.014,30.011,4.169),(-.902,30.224,3.673),(-.788,30.145,3.907),(-.767,30.222,3.866),(-.75,30.237,3.848),(-.904,30.226,3.566),(-.554,30.231,3.985),(-.541,30.244,3.96),(-.754,30.241,3.745),(-.289,30.194,4.101),(-.28,30.207,4.07),(-.545,30.248,3.851),(-.581,30.127,4.043),(-.103,30.183,4.118),(-.099,30.197,4.085),(-.281,30.209,3.94),(-.3,30.11,4.148),(-.125,30.103,4.167),(-.014,30.185,4.113),(-.014,30.198,4.081),(-.099,30.197,3.953),(.075,30.183,4.118),(.071,30.197,4.085),(-.014,30.198,3.951),(-.014,30.105,4.158),(.097,30.103,4.167),(.13,29.857,4.165),(.109,30.008,4.18),(.071,30.197,3.953),(-.115,29.835,3.842),(-.014,29.835,3.832),(-.32,29.835,3.829),(-.563,29.835,3.753),(-.73,29.835,3.658),(-.855,29.835,3.477),(-.288,30.219,4.077),(-.28,30.217,4.048),(-.098,30.204,4.071),(-.326,30.301,4.152),(-.562,30.261,3.998),(-.548,30.259,3.97),(-.098,30.204,3.953),(-.28,30.217,3.938),(-.014,30.206,4.082),(-.014,30.208,4.115),(-.906,30.234,3.679),(-.93,30.233,3.699),(-.759,30.253,3.865),(-.78,30.253,3.89),(-.989,30.277,3.749),(-.906,30.234,3.569),(-.812,30.306,3.977),(-.759,30.253,3.755),(-.59,30.308,4.083),(-.548,30.259,3.859),(.07,30.204,4.071),(-.014,30.28,4.19),(-.014,30.206,3.953),(-1.034,30.347,3.784),(-.344,30.42,4.214),(-.34,30.57,4.28),(-.217,30.401,4.248),(-.239,30.58,4.297),(-.133,30.375,4.267),(-.126,30.525,4.304),(-.014,30.367,4.255),(-.014,30.507,4.276),(.105,30.375,4.267),(.097,30.525,4.304),(-.956,30.534,3.612),(-.788,30.543,3.803),(-.535,30.551,3.916),(-.241,30.534,3.996),(-.082,30.532,4.009),(.07,30.204,3.953),(-.014,30.534,4.007),(-.773,30.785,1.695),(-.742,30.369,1.48),(-.527,30.374,1.48),(-.523,30.793,1.695),(-.936,30.778,1.695),(-.888,30.364,1.48),(-.534,29.955,1.48),(-.717,29.953,1.48),(-.259,30.366,1.48),(-.232,30.781,1.695),(-.532,30.793,3.728),(-.793,30.785,3.614),(-1.08,30.789,1.695),(-1.17,30.351,1.48),(-.846,29.95,1.48),(-.964,30.778,3.421),(-1.116,29.934,1.48),(-.288,29.951,1.48),(-.091,30.366,1.48),(-.079,30.78,1.695),(-.234,30.781,3.809),(-.014,30.367,1.48),(-.014,30.782,1.695),(-.079,30.78,3.822),(-.102,29.951,1.48),(-.014,29.952,1.48),(.062,30.366,1.48),(.051,30.78,1.695),(-.014,30.782,3.82),(.054,30.532,4.009),(.087,29.835,3.842),(-.118,29.536,3.625),(-.014,29.536,3.614),(-.327,29.536,3.613),(-.565,29.536,3.537),(-.725,29.536,3.443),(-.844,29.536,3.263),(.09,29.536,3.625),(-.115,29.536,1.695),(-.014,29.536,1.698),(-.319,29.536,1.695),(-.546,29.536,1.695),(-.698,29.536,1.695),(-.812,29.536,1.695),(-.92,29.536,1.695),(.051,30.78,3.822),(.087,29.536,1.695),(.074,29.951,1.48),(1.439,33.984,3.758),(1.439,33.992,3.761),(.968,33.926,3.83),(.969,33.92,3.824),(.485,33.882,3.856),(.489,33.888,3.861),(.382,33.983,3.916),(.374,33.98,3.914),(.595,33.883,3.857),(.595,33.877,3.85),(2.375,34.026,3.114),(.372,34.199,3.927),(.549,34.323,3.882),(.95,34.32,3.844),(.949,34.328,3.841),(1.421,34.309,3.672),(1.42,34.317,3.667),(1.837,34.268,3.501),(1.836,34.276,3.497),(2.201,34.184,3.3),(2.2,34.192,3.294),(2.198,33.978,3.372),(2.194,33.965,3.372),(1.857,34.009,3.556),(1.856,34,3.555),(.964,34.301,3.856),(1.426,34.287,3.696),(1.842,34.245,3.521),(2.413,33.921,3.117),(.423,33.988,3.928),(.505,33.907,3.887),(.619,33.906,3.882),(.969,33.945,3.853),(1.44,34.017,3.758),(1.857,34.032,3.569),(2.196,34,3.374),(.978,34.011,3.88),(.987,34.155,3.88),(.627,33.989,3.914),(.777,30.048,3.939),(.613,29.9,4.057),(.586,30.007,4.07),(.303,29.862,4.139),(.285,30.003,4.167),(.874,30.224,3.673),(.739,30.222,3.866),(.76,30.145,3.907),(.876,30.226,3.566),(.722,30.237,3.848),(.726,30.241,3.745),(.513,30.244,3.96),(.526,30.231,3.985),(.517,30.248,3.851),(.251,30.207,4.07),(.261,30.194,4.101),(.553,30.127,4.043),(.253,30.209,3.94),(.272,30.11,4.148),(.292,29.835,3.829),(.534,29.835,3.753),(.702,29.835,3.658),(.827,29.835,3.477),(.252,30.217,4.048),(.26,30.219,4.077),(.252,30.217,3.938),(.52,30.259,3.97),(.534,30.261,3.998),(.297,30.301,4.152),(.902,30.233,3.699),(.878,30.234,3.679),(.961,30.277,3.749),(.752,30.253,3.89),(.731,30.253,3.865),(.878,30.234,3.569),(.784,30.306,3.977),(.731,30.253,3.755),(.562,30.308,4.083),(.52,30.259,3.859),(1.006,30.347,3.784),(.311,30.57,4.28),(.316,30.42,4.214),(.211,30.58,4.297),(.189,30.401,4.248),(.928,30.534,3.612),(.76,30.543,3.803),(.507,30.551,3.916),(.213,30.534,3.996),(.495,30.793,1.695),(.499,30.374,1.48),(.714,30.369,1.48),(.745,30.785,1.695),(.204,30.781,1.695),(.231,30.366,1.48),(.689,29.953,1.48),(.506,29.955,1.48),(.86,30.364,1.48),(.908,30.778,1.695),(.765,30.785,3.614),(.504,30.793,3.728),(.818,29.95,1.48),(1.142,30.351,1.48),(1.052,30.789,1.695),(.936,30.778,3.421),(1.088,29.934,1.48),(.259,29.951,1.48),(.206,30.781,3.809),(.299,29.536,3.613),(.537,29.536,3.537),(.697,29.536,3.443),(.816,29.536,3.263),(.291,29.536,1.695),(.518,29.536,1.695),(.67,29.536,1.695),(.784,29.536,1.695),(.891,29.536,1.695),(2,33.102,3.255),(1.987,33.106,3.227),(1.982,33.118,3.221),(.928,33.135,3.371),(.925,33.131,3.373),(1.476,32.893,3.61),(1.477,32.9,3.645),(1.468,32.945,3.573),(1.72,32.928,3.591),(1.729,32.92,3.556),(1.699,32.98,3.525),(1.472,32.952,3.61),(1.7,32.986,3.567),(1.463,33.004,3.547),(1.682,33.033,3.512),(1.687,33.016,3.497),(1.467,32.986,3.533),(1.148,33.069,3.464),(1.137,33.057,3.472),(1.662,33.056,3.471),(1.672,33.037,3.475),(1.454,33.01,3.508),(1.456,33.028,3.503),(2.006,33.292,3.154),(2.019,33.296,3.149),(1.942,33.326,3.191),(1.979,33.339,3.177),(1.887,33.399,3.27),(1.92,33.421,3.266),(1.781,33.436,3.395),(1.804,33.463,3.399),(1.548,33.491,3.533),(1.549,33.525,3.539),(1.797,33.401,3.457),(1.561,33.46,3.595),(1.32,33.478,3.533),(1.314,33.509,3.544),(1.562,33.494,3.602),(1.816,33.399,3.463),(1.077,33.438,3.454),(1.056,33.46,3.464),(1.333,33.449,3.595),(.892,33.351,3.305),(.862,33.349,3.304),(1.327,33.48,3.605),(2.005,33.344,3.467),(1.972,33.32,3.47),(1.881,33.44,3.641),(1.858,33.415,3.648),(1.838,33.41,3.552),(1.594,33.534,3.742),(1.59,33.503,3.743),(1.813,33.392,3.557),(1.577,33.519,3.706),(1.573,33.477,3.709),(-3.186,33.549,-.787),(-3.2,33.56,-.449),(-3.15,33.702,-1.105),(-3.153,33.514,-1.152),(-3.249,33.392,-.671),(-3.25,33.401,-.515),(-3.13,33.614,.141),(-3.009,31.965,.49),(-2.866,31.167,.326),(-2.973,31.335,-.124),(-2.721,30.715,-.002),(-2.686,30.708,.227),(-2.741,30.686,.354),(-1.86,33.867,3.567),(-.625,33.81,3.798),(-.275,33.784,3.82),(-.247,34.027,3.913),(-.014,33.801,3.808),(-.014,34.035,3.88),(-1.438,33.772,3.626),(-1.887,31.833,3.494),(-2.555,31.62,2.789),(-2.552,31.96,2.9),(-.986,29.378,3.782),(-.886,29.602,3.734),(-1.246,29.617,3.493),(-1.388,29.822,3.365),(-1.707,29.288,3.052),(-1.288,28.807,3.461),(-1.187,28.507,3.319),(-1.443,28.571,2.927),(-1.839,29.368,2.878),(-1.947,29.094,2.41),(-1.81,28.793,2.286),(-1.989,29.479,2.636),(-1.979,29.868,2.906),(-1.619,29.893,3.257),(-1.739,30.023,3.219),(-1.874,30.046,3.086),(-1.615,30.145,3.358),(-1.865,30.177,3.117),(-1.826,30.383,3.268),(-1.502,30.33,3.456),(-1.728,30.555,3.405),(-1.967,30.923,3.214),(-1.927,30.967,3.265),(-2.044,30.745,3.052),(-2.093,30.966,3.127),(-1.812,30.688,3.33),(-2.052,31.105,3.249),(-3.099,32.876,.307),(-3.079,32.649,.361),(-3.028,33.193,1.237),(-3.049,33.191,.786),(-3.124,33.143,.252),(-3.151,32.882,.033),(-3.135,32.676,.1),(-3.178,33.104,-.049),(-2.538,35.46,2.253),(-2.581,35.15,2.066),(-2.688,34.728,1.892),(-2.73,33.532,2.212),(-2.847,34.744,1.517),(-2.688,35.296,1.715),(-.833,30.651,3.941),(-1.502,30.824,3.572),(-1.159,30.399,3.632),(-1.282,30.328,3.513),(-1.043,30.374,3.785),(-.856,30.428,4.052),(-.649,29.717,3.867),(-.644,29.876,4.044),(-1.124,31.36,3.717),(-.661,30.715,4.051),(-.932,31.824,3.859),(-.736,31.531,3.868),(-.283,30.787,4.168),(-.233,30.607,4.296),(-.125,30.553,4.3),(-.168,30.774,4.156),(-.337,30.598,4.281),(-.368,30.789,4.176),(-.014,30.536,4.269),(-.014,30.762,4.153),(-.281,31.061,4.097),(-.158,31.007,4.081),(-.014,30.933,4.126),(-.266,31.231,4.146),(-.152,31.137,4.153),(-.423,31.291,4.109),(-.014,31.122,4.15),(-.259,31.297,4.18),(-.197,31.259,4.272),(-1.44,30.496,3.54),(-1.618,30.683,3.498),(-.212,31.506,4.255),(-.189,31.549,4.405),(-.222,31.587,4.461),(-.27,31.625,4.458),(-.318,31.665,4.446),(-.399,31.689,4.355),(-.467,31.702,4.255),(-.533,31.688,4.181),(-.562,31.658,4.121),(-.542,31.613,4.084),(-.483,31.573,4.089),(-.404,31.56,4.148),(-.217,31.31,4.283),(-.192,31.36,4.458),(-.255,31.537,4.186),(-.234,31.403,4.523),(-.292,31.446,4.519),(-.352,31.493,4.506),(-.431,31.519,4.397),(-.503,31.533,4.282),(-.583,31.517,4.198),(-.614,31.484,4.129),(-.594,31.432,4.085),(-.529,31.387,4.086),(-.435,31.373,4.16),(-.267,31.346,4.204),(-.288,31.433,4.548),(-.362,31.487,4.531),(-.448,31.513,4.412),(-.517,31.528,4.3),(-.601,31.512,4.212),(-.636,31.475,4.129),(-.616,31.415,4.071),(-.014,31.226,4.289),(-.489,31.522,4.465),(-.55,31.543,4.355),(-.652,31.527,4.233),(-.734,31.504,4.12),(-.738,31.457,4.011),(-.691,31.386,3.941),(.169,31.259,4.272),(-.658,31.932,4.236),(-.72,31.786,4.285),(-.478,32.355,4.086),(-.663,32.179,3.945),(-.736,31.535,3.888),(-.689,31.372,3.923),(-.788,31.583,3.992),(-.567,31.261,3.989),(-.396,32.423,4.162),(-.115,31.68,4.929),(-.014,31.679,4.931),(-.014,31.799,4.925),(-.132,31.806,4.918),(-.014,31.552,4.905),(-.105,31.545,4.905),(.104,31.806,4.918),(.086,31.68,4.929),(-.014,31.897,4.903),(-.124,31.901,4.898),(-.223,31.647,4.898),(-.253,31.813,4.889),(-.173,31.573,4.898),(-.344,31.828,4.765),(-.139,31.426,4.746),(-.513,31.606,4.54),(-.389,31.836,4.674),(-.138,32.244,4.649),(-.014,32.561,4.45),(-.141,32.54,4.437),(-.014,31.426,4.738),(.111,31.426,4.746),(-.486,31.829,4.519),(-.574,31.618,4.43),(-.539,31.816,4.436),(-.718,31.574,4.283),(-.792,31.579,4.115),(.096,31.901,4.898),(-.258,32.535,4.287),(-.411,32.685,3.988),(-.259,32.828,4.106),(-.482,32.62,3.935),(-.136,32.9,4.205),(-.424,32.947,3.827),(-.26,33.061,3.946),(-.508,32.887,3.768),(-.132,33.148,4.045),(-.28,33.294,3.801),(-.13,33.371,3.853),(-1.351,31.96,3.703),(-2.227,34.4,3.245),(-.213,33.585,3.751),(-2.146,33.826,3.394),(-1.95,33.561,3.299),(-1.682,33.639,3.417),(-.014,34.29,3.865),(-.66,35.268,3.608),(-.281,35.264,3.627),(-.943,34.693,3.776),(-.014,34.656,3.793),(-.943,35.22,3.588),(-1.436,34.541,3.609),(-1.42,35.147,3.438),(-1.85,34.424,3.47),(-1.834,35.044,3.269),(-2.232,34.832,3.086),(-1.331,33.469,3.556),(-1.646,33.487,3.517),(-1.624,33.479,3.433),(-1.327,33.471,3.476),(-1.329,33.56,3.532),(-1.657,33.554,3.48),(-1.87,33.403,3.383),(-1.835,33.415,3.321),(-1.626,33.488,3.418),(-1.192,33.437,3.514),(-1.189,33.44,3.439),(-1.602,33.061,3.429),(-1.624,33.055,3.485),(-1.342,33.044,3.509),(-1.32,33.053,3.439),(-1.904,33.093,3.334),(-1.876,33.091,3.288),(-1.64,32.932,3.437),(-1.31,32.95,3.466),(-1.018,33.13,3.379),(-1.017,33.131,3.323),(-1.312,33.049,3.421),(-1.603,33.057,3.413),(-1.909,33.466,3.356),(-2.013,33.269,3.226),(-1.997,33.288,3.167),(-1.844,33.422,3.303),(-2.006,33.143,3.195),(-1.989,33.149,3.163),(-2.054,33.175,3.022),(-2.06,33.043,3.183),(-2.006,33.146,3.139),(-2.073,33.173,2.993),(-1.927,32.978,3.294),(-1.885,33.088,3.269),(-.857,33.147,3.262),(-.999,33.129,3.302),(-.791,33.231,3.233),(-.834,33.145,3.243),(-.841,33.287,3.297),(-.84,33.289,3.248),(-.766,33.231,3.217),(-.797,33.368,3.282),(-1.052,33.403,3.455),(-1.052,33.407,3.386),(-.817,33.291,3.228),(-1.022,33.474,3.42),(-1.036,33.414,3.369),(-1.175,33.518,3.476),(-2.052,33.33,3.187),(-2.018,33.29,3.145),(-.961,32.904,3.345),(-.951,32.773,3.471),(-.688,32.903,3.512),(-1.288,32.875,3.425),(-1.291,32.847,3.423),(-2.19,32.753,3.137),(-2.366,32.875,2.983),(-1.927,32.876,3.254),(-1.935,32.846,3.25),(-1.651,32.835,3.397),(-1.66,32.805,3.395),(-1.323,32.684,3.484),(-1.723,32.609,3.427),(-2.023,32.661,3.267),(-.997,33.528,3.341),(-.997,33.556,3.314),(-1.169,33.586,3.401),(-1.342,33.622,3.462),(-1.35,33.649,3.436),(-1.173,33.613,3.375),(-1.664,33.611,3.407),(-1.664,33.63,3.379),(-1.929,33.532,3.294),(-1.921,33.553,3.272),(-2.079,33.391,3.123),(-2.09,33.419,3.094),(-.984,33.576,3.352),(-2.133,33.434,3.101),(-2.276,33.417,3.017),(-2.212,33.579,3.145),(-2.443,33.077,2.875),(-2.501,32.752,2.909),(-2.324,32.587,3.115),(-.682,32.748,3.668),(-.96,32.63,3.583),(-1.358,32.5,3.551),(-2.119,32.468,3.289),(-2.52,33.282,2.873),(-2.122,36.631,-2.515),(-2.111,37.005,-1.682),(-1.586,37.403,-1.778),(-1.527,37.021,-2.599),(-2.48,36.202,-2.33),(-2.545,36.547,-1.573),(-1.591,37.577,-.948),(-2.109,37.145,-.87),(-1.009,37.592,-1.816),(-.972,37.174,-2.678),(-1.433,36.474,-3.174),(-1.995,36.156,-3.029),(-1.602,37.441,.902),(-1.58,37.235,1.721),(-.891,37.507,1.735),(-.897,37.723,.901),(-2.051,37.027,.845),(-2.025,36.872,1.63),(-1.58,37.035,2.105),(-.925,37.234,2.21),(-.361,37.616,1.709),(-.356,37.825,.843),(-.911,37.841,.011),(-1.595,37.552,.023),(-2.926,34.759,1.221),(-2.572,35.749,1.958),(-2.892,35.541,.751),(-3.024,34.817,.712),(-3.058,33.691,.696),(-1.848,30.545,-2.672),(-1.765,29.931,-2.603),(-2.178,29.915,-2.288),(-2.279,30.509,-2.27),(-1.283,30.585,-3.009),(-1.272,29.953,-2.909),(-2.336,29.833,-1.941),(-2.422,30.457,-1.916),(-1.914,31.205,-2.952),(-2.397,31.151,-2.447),(-2.403,29.551,-.962),(-2.631,30.27,-1.009),(-1.283,28.628,1.615),(-1.702,28.803,1.873),(-1.841,28.992,1.545),(-.387,28.475,3.858),(-.367,28.357,3.74),(-.202,28.362,3.766),(-.212,28.482,3.909),(-.193,28.306,3.586),(-.347,28.304,3.585),(-.014,28.367,3.769),(-.014,28.486,3.918),(-.236,28.742,4.041),(-.491,28.744,4.024),(-.689,29.574,3.841),(-.401,29.583,3.849),(-.345,29.712,3.885),(-.767,29.429,3.888),(-.467,29.418,3.91),(-.183,29.592,3.83),(-.175,29.708,3.845),(-.329,29.839,4.123),(-.218,29.395,3.899),(-.014,29.703,3.817),(-.014,29.581,3.819),(-.159,29.835,4.149),(-2.673,32.499,2.74),(-2.482,32.277,3.016),(-2.748,32.192,2.569),(-2.231,32.134,3.273),(-2.637,33.332,2.719),(-1.366,32.251,3.636),(-.721,32.471,3.799),(-2.714,33.428,2.484),(-1.42,35.74,3.22),(-1.866,35.544,3.069),(-.014,35.226,3.613),(-.323,35.886,3.353),(-.014,33.595,3.774),(-.014,33.382,3.867),(.247,33.784,3.82),(.185,33.585,3.751),(-.014,32.931,4.219),(-1.72,31.874,3.569),(-2.498,31.242,2.673),(-2.732,31.797,2.435),(-.014,29.829,4.149),(-.014,29.378,3.893),(.155,29.592,3.83),(.147,29.708,3.845),(-.727,28.725,3.943),(-.536,29.105,4.009),(-.804,29.086,3.948),(-.247,29.078,4.022),(-.014,28.728,4.029),(-.014,29.044,4.007),(.208,28.742,4.041),(.219,29.078,4.022),(.19,29.395,3.899),(.131,29.835,4.149),(.124,31.137,4.153),(.077,31.545,4.905),(-2.831,33.101,2.086),(-2.98,33.131,1.647),(-2.646,31.398,2.269),(-.014,33.2,4.035),(.104,33.148,4.045),(.102,33.371,3.853),(-2.216,35.381,2.793),(.219,34.027,3.913),(.253,35.264,3.627),(-.014,35.849,3.402),(-.366,36.544,3.067),(-.014,36.541,3.104),(.295,35.886,3.353),(-1.52,36.304,2.891),(-1.961,36.058,2.708),(-2.328,35.768,2.485),(-.634,30.514,4.191),(-2.148,30.07,2.663),(.097,30.553,4.3),(.14,30.774,4.156),(.13,31.007,4.081),(-.623,28.294,3.241),(-.561,28.288,2.792),(-.014,28.219,2.854),(-.014,28.254,3.339),(-.163,28.24,2.246),(-.014,28.226,2.219),(-.014,28.312,3.578),(.165,28.306,3.586),(-.561,28.298,2.34),(.174,28.362,3.766),(.184,28.482,3.909),(-2.152,29.608,2.451),(-2.072,29.226,2.169),(-2.226,30.807,2.917),(-2.434,30.881,2.543),(-2.364,30.487,2.404),(-2.325,30.252,2.32),(-2.313,29.787,2.121),(-2.237,29.399,1.863),(-1.982,28.953,2.022),(-2.148,29.156,1.715),(-2.554,31.027,2.105),(-2.676,31.147,1.616),(-2.773,30.676,.557),(-2.438,29.666,1.07),(-2.29,29.394,1.415),(-3.154,32.307,.082),(-3.104,34.137,.078),(-3.027,34.18,.676),(-3.104,34.755,.006),(-2.554,30.17,.469),(-2.397,29.9,.63),(-2.162,29.51,.949),(-1.979,29.211,1.251),(-1.556,28.648,2.158),(-1.388,28.5,2.494),(-2.785,31.6,-1.671),(-2.624,30.999,-1.606),(-2.793,30.92,-1.053),(-2.664,31.652,-2.139),(-2.565,31.069,-1.981),(-2.819,30.898,-.673),(-2.662,30.262,-.574),(-2.82,30.808,-.297),(-2.659,30.205,-.208),(-2.334,29.334,-.149),(-2.497,30.107,.081),(-2.176,29.277,.085),(-.522,28.336,1.815),(-.172,28.301,1.749),(-.546,28.329,1.51),(-.157,28.29,1.636),(-.014,28.274,1.742),(-.014,28.24,1.632),(.135,28.24,2.246),(.144,28.301,1.749),(.129,28.29,1.636),(-.014,35.262,-4.075),(-.014,34.261,-4.208),(-.514,34.246,-4.146),(.486,34.246,-4.146),(-.014,33.234,-4.19),(-.482,33.275,-4.158),(-1.088,34.214,-4.004),(-.014,35.622,-3.965),(.454,33.275,-4.158),(-.014,32.388,-4.049),(-.45,32.412,-4.009),(-1.039,33.326,-3.994),(.422,32.412,-4.009),(-.014,31.757,-3.857),(-.36,31.757,-3.815),(-.975,32.419,-3.909),(.332,31.757,-3.815),(-.014,31.201,-3.565),(-.321,31.217,-3.527),(-.88,31.733,-3.699),(.293,31.217,-3.527),(-.014,30.689,-3.222),(-.314,30.649,-3.212),(-.81,31.223,-3.458),(.286,30.649,-3.212),(-.014,30.046,-3.103),(-.283,30.031,-3.094),(-.705,30.609,-3.168),(.255,30.031,-3.094),(-.701,29.98,-3.052),(-1.563,34.146,-3.778),(-1.532,33.328,-3.806),(-1.5,32.462,-3.721),(-1.457,31.749,-3.511),(-1.373,31.244,-3.309),(-2.072,34.04,-3.42),(-2.05,33.219,-3.437),(-1.985,32.424,-3.37),(-1.966,31.753,-3.15),(-2.494,33.978,-3.015),(-1.822,35.511,-3.452),(-2.47,33.192,-3.024),(-2.465,32.382,-2.871),(-2.431,31.733,-2.658),(-2.82,33.847,-2.527),(-2.785,33.04,-2.523),(-2.745,32.27,-2.363),(-2.717,35.225,-2.58),(-2.957,32.917,-1.95),(-3.06,32.775,-1.337),(-1.894,29.457,.727),(-1.771,29.053,.433),(-3.029,31.694,-.563),(-3.11,32.487,-1.146),(-3.147,32.745,-1.119),(-3.2,32.951,-1.06),(-3.25,33.183,-.96),(-3.245,33.305,-.849),(-3.167,34.364,-1.563),(-3.197,34.524,-1.062),(-3.13,34.675,-.549),(-3.065,35.268,-1.281),(-3.002,35.075,-1.888),(-3.022,35.447,-.669),(-1.544,28.876,.634),(-1.63,29.132,1.014),(-.014,36.187,-3.731),(-.504,36.109,-3.707),(-2.375,36.098,2.157),(-2.051,36.458,2.291),(-1.564,36.796,2.436),(-.388,37.049,2.614),(-.943,36.984,2.578),(.338,36.544,3.067),(-.014,37.054,2.671),(-2.405,36.326,1.764),(-2.057,36.683,1.932),(-.359,37.34,2.262),(.36,37.049,2.614),(-.014,37.386,2.276),(-2.406,36.453,1.513),(.331,37.34,2.262),(-.014,37.66,1.706),(-2.42,36.634,.811),(-2.693,36.136,.792),(.333,37.616,1.709),(-.014,37.881,.832),(.328,37.825,.843),(-.014,37.95,-.037),(-.414,37.93,-.02),(.386,37.93,-.02),(-.014,37.891,-1.009),(-.405,37.865,-1.003),(.377,37.865,-1.003),(-.014,37.703,-1.874),(-.448,37.673,-1.855),(-.965,37.794,-.98),(.42,37.673,-1.855),(-.014,37.303,-2.709),(-.438,37.295,-2.682),(.409,37.295,-2.682),(-.014,36.785,-3.335),(-.454,36.771,-3.289),(.426,36.771,-3.289),(-.896,36.696,-3.248),(.476,36.109,-3.707),(-.78,36.017,-3.672),(-1.34,35.785,-3.604),(-2.087,37.134,-.006),(-2.482,36.702,-.031),(-2.516,36.686,-.839),(-2.401,35.753,-2.843),(-2.757,36.169,-.038),(-2.796,36.131,-.735),(-2.817,35.957,-1.402),(-2.788,35.633,-2.104),(-2.962,35.518,-.008),(.113,32.54,4.437),(.108,32.9,4.205),(.11,32.244,4.649),(-3.171,32.49,.039),(-3.101,32.256,-1.11),(-2.422,33.414,2.804),(-2.135,33.704,2.79),(-2.491,33.147,2.804),(-2.391,32.974,2.804),(-2.117,32.841,2.8),(-1.679,32.779,2.774),(-1.179,32.807,2.745),(-.71,32.927,2.737),(-.406,33.055,2.742),(-.297,33.238,2.743),(-.41,33.443,2.742),(-.748,33.679,2.742),(-1.702,33.866,2.761),(-3.263,33.381,-.514),(-3.117,32.255,-1.092),(-3.13,32.483,-1.123),(-3.172,32.742,-1.099),(-3.048,31.704,-.553),(-3.069,31.851,-.742),(-3.23,32.947,-1.043),(-3.277,33.178,-.94),(-3.268,33.293,-.838),(-3.271,33.376,-.668),(-3.101,32.016,-.915),(-3.546,32.82,-.858),(-3.386,32.805,-.912),(-3.591,32.725,-.957),(-3.321,32.732,-.89),(-3.343,32.949,-.78),(-3.42,33.062,-.74),(-3.299,32.426,-.964),(-3.313,32.566,-.794),(-3.336,33.095,-.629),(-3.338,32.888,-.66),(-3.283,32.492,-.281),(-3.323,32.383,-.326),(-3.183,32.476,-.519),(-3.373,31.9,-.279),(-3.339,31.708,-.285),(-3.416,31.888,-.354),(-3.377,31.639,-.4),(-3.316,31.443,-.26),(-3.485,32.739,-1.285),(-3.435,32.391,-1.212),(-3.435,32.344,-1.382),(-3.493,32.739,-1.473),(-3.437,32.737,-1.153),(-3.381,32.426,-1.128),(-3.392,32.135,-1.098),(-3.378,32.029,-1.274),(-3.482,32.315,-1.465),(-3.536,32.728,-1.567),(-3.529,33.036,-1.272),(-3.528,33.078,-1.457),(-3.392,33.166,-.435),(-3.58,33.127,-.419),(-3.65,33.259,-.389),(-3.539,33.15,-.691),(-3.576,33.381,-.61),(-3.604,33.236,-.705),(-3.072,32.202,-.516),(-3.077,32.121,-.458),(-3.2,32.204,-.305),(-3.101,32.277,-.613),(-3.119,32.11,-.645),(-3.143,32.044,-.344),(-3.223,32.043,-.241),(-3.334,32.235,-.308),(-3.252,32.044,-.22),(-3.299,32.048,-.157),(-3.375,32.253,-.233),(-3.39,32.29,-1.002),(-3.276,32.382,-.944),(-3.344,32.167,-.914),(-3.218,32.281,-.87),(-3.265,32.479,-.765),(-3.496,32.303,-1.023),(-3.474,32.245,-.999),(-3.278,32.096,-.699),(-3.151,32.173,-.745),(-3.179,32.384,-.728),(-3.412,32.134,-.899),(-3.566,32.179,-1.014),(-3.605,32.271,-1.072),(-3.504,32.072,-.9),(-3.687,32.631,-1.155),(-3.606,32.625,-1.057),(-3.599,32.273,-1.34),(-3.536,32.019,-1.22),(-3.502,31.901,-1.003),(-3.437,32.117,-.609),(-3.515,32.014,-.632),(-3.198,32.034,-.583),(-3.484,31.829,-.756),(-3.382,32.05,-.452),(-3.457,31.924,-.455),(-3.452,31.722,-.549),(-3.218,32.643,-.163),(-3.214,32.735,-.264),(-3.217,32.469,-.06),(-3.281,32.844,-.285),(-3.259,32.534,-.61),(-3.517,33.436,-1.353),(-3.527,33.355,-1.19),(-3.582,33.094,-1.531),(-3.588,33.477,-1.409),(-3.511,33.495,-1.063),(-3.503,33.614,-1.203),(-3.478,33.251,-1.065),(-3.458,33,-1.151),(-3.443,33.72,-.919),(-3.45,33.577,-.851),(-3.57,33.668,-1.253),(-3.513,33.807,-.951),(-3.422,33.723,-.671),(-3.409,33.578,-.671),(-3.501,33.784,-.622),(-3.409,33.529,-.559),(-3.4,33.631,-.51),(-3.465,33.669,-.437),(-3.351,33.48,-.364),(-3.339,33.442,-.418),(-3.236,32.926,-.223),(-3.381,33.033,-.255),(-3.229,31.924,-.064),(-3.213,31.487,-.099),(-3.566,33.572,-.489),(-3.357,31.373,-.417),(-3.452,31.517,-.635),(-3.292,31.245,-.448),(-3.241,31.312,-.206),(-3.429,31.416,-.681),(-3.17,31.209,-.462),(-3.094,31.279,-.196),(-3.245,32.031,-.065),(-3.339,31.368,-.736),(-3.032,31.304,-.204),(-3.099,31.271,-.462),(-3.604,33.106,-.375),(-3.657,33.259,-.368),(-3.716,33.516,-.459),(-3.741,33.654,-.594),(-3.586,33.677,-.669),(-3.724,33.524,-.441),(-3.64,33.296,-.307),(-3.58,33.15,-.299),(-3.47,33.254,-.227),(-3.519,33.414,-.253),(-3.515,32.972,-.331),(-3.403,33.493,-.294),(-3.582,33.64,-.383),(-3.7,33.563,-.406),(-3.527,32.905,-.435),(-3.194,32.285,-.024),(-3.304,32.268,-.136),(-3.69,32.264,-1.379),(-3.57,31.978,-1.263),(-3.696,32.706,-1.415),(-3.721,32.253,-1.417),(-3.606,31.925,-1.302),(-3.535,31.794,-1.058),(-3.807,32.686,-1.449),(-3.818,32.685,-1.476),(-3.719,32.242,-1.462),(-3.613,31.903,-1.34),(-3.623,32.27,-1.516),(-3.548,31.912,-1.364),(-3.807,32.691,-1.529),(-3.431,31.973,-1.338),(-3.491,31.654,-1.151),(-3.695,32.71,-1.6),(-3.373,31.702,-1.132),(-3.331,31.783,-1.076),(-3.348,32.183,-1.04),(-3.316,31.913,-.962),(-3.266,32.455,-1.133),(-3.231,32.218,-1.071),(-3.278,31.951,-.928),(-3.172,31.992,-.923),(-3.322,32.736,-1.135),(-3.508,31.676,-.847),(-3.428,31.521,-.959),(-3.333,31.564,-.958),(-3.283,31.65,-.892),(-3.259,31.766,-.81),(-3.225,31.789,-.782),(-3.113,31.83,-.759),(-3.239,31.415,-.726),(-3.216,31.498,-.676),(-3.203,31.595,-.597),(-3.143,31.639,-.579),(-3.084,31.683,-.562),(-3.259,33.174,-.265),(-3.294,33.35,-.327),(-3.551,33.51,-.708),(-3.738,33.72,-.564),(-3.752,33.669,-.582),(-3.619,33.787,-.584),(-3.609,33.458,-.835),(-3.661,33.668,-.887),(-3.687,33.308,-.969),(-3.795,33.681,-.838),(-3.773,33.764,-.86),(-3.802,33.696,-.837),(-3.661,33.818,-.916),(-3.711,33.529,-1.169),(-3.851,33.566,-1.104),(-3.835,33.631,-1.156),(-3.861,33.576,-1.111),(-3.712,33.683,-1.228),(-3.858,33.38,-1.258),(-3.71,33.358,-1.302),(-3.723,33.169,-1.051),(-3.857,33.423,-1.322),(-3.87,33.387,-1.268),(-3.741,33.471,-1.409),(-3.681,32.794,-.995),(-3.722,32.904,-1.137),(-3.707,33.03,-1.397),(-3.827,33.03,-1.398),(-3.843,33.056,-1.467),(-3.843,33.034,-1.417),(-3.735,33.09,-1.554),(-3.285,33.384,-.492),(-3.319,33.407,-.454),(-3.275,33.345,-.35),(-3.404,33.223,-.987),(-3.376,32.976,-1.09),(-3.244,33.198,-.27),(3.172,33.56,-.449),(3.158,33.549,-.787),(3.222,33.401,-.515),(3.221,33.392,-.671),(3.125,33.514,-1.152),(3.122,33.702,-1.105),(3.102,33.614,.141),(2.981,31.965,.49),(2.838,31.167,.326),(2.945,31.335,-.124),(2.658,30.708,.227),(2.693,30.715,-.002),(2.713,30.686,.354),(.597,33.81,3.798),(1.832,33.867,3.567),(1.41,33.772,3.626),(2.524,31.96,2.9),(2.527,31.62,2.789),(1.859,31.833,3.494),(1.218,29.617,3.493),(.858,29.602,3.734),(.958,29.378,3.782),(1.36,29.822,3.365),(1.679,29.288,3.052),(1.26,28.807,3.461),(1.159,28.507,3.319),(1.415,28.571,2.927),(1.782,28.793,2.286),(1.919,29.094,2.41),(1.81,29.368,2.878),(1.961,29.479,2.636),(1.951,29.868,2.906),(1.845,30.046,3.086),(1.711,30.023,3.219),(1.591,29.893,3.257),(1.837,30.177,3.117),(1.587,30.145,3.358),(1.798,30.383,3.268),(1.7,30.555,3.405),(1.474,30.33,3.456),(1.939,30.923,3.214),(2.065,30.966,3.127),(2.016,30.745,3.052),(1.899,30.967,3.265),(1.784,30.688,3.33),(2.024,31.105,3.249),(3.051,32.649,.361),(3.071,32.876,.307),(3.02,33.191,.786),(3,33.193,1.237),(3.107,32.676,.1),(3.123,32.882,.033),(3.096,33.143,.252),(3.15,33.104,-.049),(2.553,35.15,2.066),(2.51,35.46,2.253),(2.659,34.728,1.892),(2.702,33.532,2.212),(2.819,34.744,1.517),(2.66,35.296,1.715),(.805,30.651,3.941),(1.474,30.824,3.572),(1.131,30.399,3.632),(1.254,30.328,3.513),(1.015,30.374,3.785),(.828,30.428,4.052),(.616,29.876,4.044),(.621,29.717,3.867),(1.096,31.36,3.717),(.633,30.715,4.051),(.904,31.824,3.859),(.708,31.531,3.868),(.205,30.607,4.296),(.255,30.787,4.168),(.34,30.789,4.176),(.309,30.598,4.281),(.253,31.061,4.097),(.238,31.231,4.146),(.395,31.291,4.109),(.231,31.297,4.18),(1.412,30.496,3.54),(1.59,30.683,3.498),(.371,31.689,4.355),(.289,31.665,4.446),(.242,31.625,4.458),(.194,31.587,4.461),(.161,31.549,4.405),(.184,31.506,4.255),(.454,31.573,4.089),(.514,31.613,4.084),(.534,31.658,4.121),(.505,31.688,4.181),(.439,31.702,4.255),(.376,31.56,4.148),(.164,31.36,4.458),(.189,31.31,4.283),(.227,31.537,4.186),(.206,31.403,4.523),(.264,31.446,4.519),(.324,31.493,4.506),(.403,31.519,4.397),(.475,31.533,4.282),(.555,31.517,4.198),(.586,31.484,4.129),(.565,31.432,4.085),(.501,31.387,4.086),(.407,31.373,4.16),(.239,31.346,4.204),(.26,31.433,4.548),(.334,31.487,4.531),(.42,31.513,4.412),(.489,31.528,4.3),(.573,31.512,4.212),(.608,31.475,4.129),(.588,31.415,4.071),(.461,31.522,4.465),(.522,31.543,4.355),(.624,31.527,4.233),(.706,31.504,4.12),(.71,31.457,4.011),(.663,31.386,3.941),(.63,31.932,4.236),(.692,31.786,4.285),(.635,32.179,3.945),(.45,32.355,4.086),(.708,31.535,3.888),(.76,31.583,3.992),(.661,31.372,3.923),(.539,31.261,3.989),(.368,32.423,4.162),(.225,31.813,4.889),(.195,31.647,4.898),(.145,31.573,4.898),(.316,31.828,4.765),(.485,31.606,4.54),(.361,31.836,4.674),(.458,31.829,4.519),(.546,31.618,4.43),(.511,31.816,4.436),(.69,31.574,4.283),(.764,31.579,4.115),(.23,32.535,4.287),(.231,32.828,4.106),(.383,32.685,3.988),(.454,32.62,3.935),(.232,33.061,3.946),(.396,32.947,3.827),(.48,32.887,3.768),(.252,33.294,3.801),(1.323,31.96,3.703),(2.199,34.4,3.245),(1.654,33.639,3.417),(1.922,33.561,3.299),(2.118,33.826,3.394),(.915,34.693,3.776),(.632,35.268,3.608),(.915,35.22,3.588),(1.408,34.541,3.609),(1.392,35.147,3.438),(1.822,34.424,3.47),(1.806,35.044,3.269),(2.204,34.832,3.086),(1.299,33.471,3.476),(1.596,33.479,3.433),(1.618,33.487,3.517),(1.303,33.469,3.556),(1.598,33.488,3.418),(1.807,33.415,3.321),(1.842,33.403,3.383),(1.628,33.554,3.48),(1.301,33.56,3.532),(1.161,33.44,3.439),(1.164,33.437,3.514),(1.292,33.053,3.439),(1.314,33.044,3.509),(1.596,33.055,3.485),(1.574,33.061,3.429),(.989,33.131,3.323),(.99,33.13,3.379),(1.282,32.95,3.466),(1.612,32.932,3.437),(1.847,33.091,3.288),(1.876,33.093,3.334),(1.575,33.057,3.413),(1.284,33.049,3.421),(1.968,33.288,3.167),(1.985,33.269,3.226),(1.881,33.466,3.356),(1.816,33.422,3.303),(2.025,33.175,3.022),(1.961,33.149,3.163),(1.978,33.143,3.195),(2.044,33.173,2.993),(1.978,33.146,3.139),(2.032,33.043,3.183),(1.857,33.088,3.269),(1.899,32.978,3.294),(.971,33.129,3.302),(.829,33.147,3.262),(.806,33.145,3.243),(.763,33.231,3.233),(.738,33.231,3.217),(.812,33.289,3.248),(.813,33.287,3.297),(.789,33.291,3.228),(1.024,33.407,3.386),(1.024,33.403,3.455),(.769,33.368,3.282),(1.007,33.414,3.369),(.994,33.474,3.42),(1.147,33.518,3.476),(1.99,33.29,3.145),(2.024,33.33,3.187),(.933,32.904,3.345),(.66,32.903,3.512),(.923,32.773,3.471),(1.263,32.847,3.423),(1.26,32.875,3.425),(2.338,32.875,2.983),(2.162,32.753,3.137),(1.907,32.846,3.25),(1.899,32.876,3.254),(1.295,32.684,3.484),(1.632,32.805,3.395),(1.623,32.835,3.397),(1.695,32.609,3.427),(1.995,32.661,3.267),(.969,33.528,3.341),(.969,33.556,3.314),(1.141,33.586,3.401),(1.314,33.622,3.462),(1.145,33.613,3.375),(1.322,33.649,3.436),(1.636,33.611,3.407),(1.636,33.63,3.379),(1.901,33.532,3.294),(1.893,33.553,3.272),(2.051,33.391,3.123),(2.062,33.419,3.094),(.956,33.576,3.352),(2.248,33.417,3.017),(2.104,33.434,3.101),(2.184,33.579,3.145),(2.415,33.077,2.875),(2.296,32.587,3.115),(2.473,32.752,2.909),(.654,32.748,3.668),(.932,32.63,3.583),(1.33,32.5,3.551),(2.091,32.468,3.289),(2.492,33.282,2.873),(1.499,37.021,-2.599),(1.558,37.403,-1.778),(2.083,37.005,-1.682),(2.094,36.631,-2.515),(.944,37.174,-2.678),(.981,37.592,-1.816),(2.081,37.145,-.87),(1.563,37.577,-.948),(2.517,36.547,-1.573),(2.451,36.202,-2.33),(1.967,36.156,-3.029),(1.405,36.474,-3.174),(.869,37.723,.901),(.863,37.507,1.735),(1.552,37.235,1.721),(1.574,37.441,.902),(.897,37.234,2.21),(1.552,37.035,2.105),(1.996,36.872,1.63),(2.023,37.027,.845),(1.567,37.552,.023),(.883,37.841,.011),(2.898,34.759,1.221),(2.544,35.749,1.958),(2.996,34.817,.712),(2.864,35.541,.751),(3.03,33.691,.696),(2.251,30.509,-2.27),(2.15,29.915,-2.288),(1.737,29.931,-2.603),(1.82,30.545,-2.672),(2.394,30.457,-1.916),(2.308,29.833,-1.941),(1.244,29.953,-2.909),(1.255,30.585,-3.009),(2.369,31.151,-2.447),(1.886,31.205,-2.952),(2.375,29.551,-.962),(2.603,30.27,-1.009),(1.255,28.628,1.615),(1.813,28.992,1.545),(1.674,28.803,1.873),(.339,28.357,3.74),(.359,28.475,3.858),(.319,28.304,3.585),(.463,28.744,4.024),(.317,29.712,3.885),(.373,29.583,3.849),(.661,29.574,3.841),(.439,29.418,3.91),(.739,29.429,3.888),(.301,29.839,4.123),(2.454,32.277,3.016),(2.645,32.499,2.74),(2.203,32.134,3.273),(2.72,32.192,2.569),(2.609,33.332,2.719),(1.338,32.251,3.636),(.693,32.471,3.799),(2.686,33.428,2.484),(1.838,35.544,3.069),(1.392,35.74,3.22),(1.692,31.874,3.569),(2.47,31.242,2.673),(2.704,31.797,2.435),(.699,28.725,3.943),(.776,29.086,3.948),(.508,29.105,4.009),(2.803,33.101,2.086),(2.952,33.131,1.647),(2.618,31.398,2.269),(2.188,35.381,2.793),(1.492,36.304,2.891),(1.933,36.058,2.708),(2.299,35.768,2.485),(.606,30.514,4.191),(2.12,30.07,2.663),(.595,28.294,3.241),(.533,28.288,2.792),(.533,28.298,2.34),(2.124,29.608,2.451),(2.044,29.226,2.169),(2.198,30.807,2.917),(2.406,30.881,2.543),(2.336,30.487,2.404),(2.297,30.252,2.32),(2.285,29.787,2.121),(1.954,28.953,2.022),(2.209,29.399,1.863),(2.12,29.156,1.715),(2.526,31.027,2.105),(2.648,31.147,1.616),(2.745,30.676,.557),(2.262,29.394,1.415),(2.41,29.666,1.07),(3.126,32.307,.082),(2.999,34.18,.676),(3.076,34.137,.078),(3.076,34.755,.006),(2.526,30.17,.469),(2.369,29.9,.63),(2.134,29.51,.949),(1.951,29.211,1.251),(1.528,28.648,2.158),(1.36,28.5,2.494),(2.765,30.92,-1.053),(2.596,30.999,-1.606),(2.756,31.6,-1.671),(2.791,30.898,-.673),(2.537,31.069,-1.981),(2.636,31.652,-2.139),(2.634,30.262,-.574),(2.792,30.808,-.297),(2.631,30.205,-.208),(2.306,29.334,-.149),(2.469,30.107,.081),(2.148,29.277,.085),(.494,28.336,1.815),(.518,28.329,1.51),(1.06,34.214,-4.004),(1.011,33.326,-3.994),(.947,32.419,-3.909),(.852,31.733,-3.699),(.782,31.223,-3.458),(.677,30.609,-3.168),(.673,29.98,-3.052),(1.535,34.146,-3.778),(1.504,33.328,-3.806),(1.472,32.462,-3.721),(1.429,31.749,-3.511),(1.345,31.244,-3.309),(2.044,34.04,-3.42),(2.022,33.219,-3.437),(1.957,32.424,-3.37),(1.937,31.753,-3.15),(2.466,33.978,-3.015),(1.794,35.511,-3.452),(2.442,33.192,-3.024),(2.437,32.382,-2.871),(2.403,31.733,-2.658),(2.792,33.847,-2.527),(2.757,33.04,-2.523),(2.716,32.27,-2.363),(2.689,35.225,-2.58),(2.929,32.917,-1.95),(3.032,32.775,-1.337),(1.743,29.053,.433),(1.866,29.457,.727),(3.001,31.694,-.563),(3.119,32.745,-1.119),(3.082,32.487,-1.146),(3.222,33.183,-.96),(3.172,32.951,-1.06),(3.139,34.364,-1.563),(3.217,33.305,-.849),(3.169,34.524,-1.062),(2.973,35.075,-1.888),(3.036,35.268,-1.281),(3.102,34.675,-.549),(2.994,35.447,-.669),(1.516,28.876,.634),(1.602,29.132,1.014),(2.347,36.098,2.157),(2.022,36.458,2.291),(1.536,36.796,2.436),(.915,36.984,2.578),(2.377,36.326,1.764),(2.029,36.683,1.932),(2.378,36.453,1.513),(2.665,36.136,.792),(2.392,36.634,.811),(.937,37.794,-.98),(.868,36.696,-3.248),(.752,36.017,-3.672),(1.312,35.785,-3.604),(2.059,37.134,-.006),(2.454,36.702,-.031),(2.488,36.686,-.839),(2.373,35.753,-2.843),(2.729,36.169,-.038),(2.768,36.131,-.735),(2.789,35.957,-1.402),(2.76,35.633,-2.104),(2.934,35.518,-.008),(3.143,32.49,.039),(3.073,32.256,-1.11),(1.674,33.866,2.761),(.72,33.679,2.742),(.382,33.443,2.742),(.269,33.238,2.743),(.378,33.055,2.742),(.682,32.927,2.737),(1.15,32.807,2.745),(1.651,32.779,2.774),(2.089,32.841,2.8),(2.363,32.974,2.804),(2.463,33.147,2.804),(2.394,33.414,2.804),(2.107,33.704,2.79),(3.235,33.381,-.514),(3.102,32.483,-1.123),(3.089,32.255,-1.092),(3.144,32.742,-1.099),(3.041,31.851,-.742),(3.02,31.704,-.553),(3.202,32.947,-1.043),(3.249,33.178,-.94),(3.24,33.293,-.838),(3.243,33.376,-.668),(3.073,32.016,-.915),(3.358,32.805,-.912),(3.518,32.82,-.858),(3.315,32.949,-.78),(3.293,32.732,-.89),(3.563,32.725,-.957),(3.392,33.062,-.74),(3.31,32.888,-.66),(3.308,33.095,-.629),(3.285,32.566,-.794),(3.271,32.426,-.964),(3.255,32.492,-.281),(3.155,32.476,-.519),(3.295,32.383,-.326),(3.311,31.708,-.285),(3.345,31.9,-.279),(3.287,31.443,-.26),(3.349,31.639,-.4),(3.388,31.888,-.354),(3.465,32.739,-1.473),(3.407,32.344,-1.382),(3.407,32.391,-1.212),(3.457,32.739,-1.285),(3.508,32.728,-1.567),(3.454,32.315,-1.465),(3.35,32.029,-1.274),(3.364,32.135,-1.098),(3.353,32.426,-1.128),(3.409,32.737,-1.153),(3.5,33.078,-1.457),(3.501,33.036,-1.272),(3.364,33.166,-.435),(3.622,33.259,-.389),(3.552,33.127,-.419),(3.511,33.15,-.691),(3.576,33.236,-.705),(3.548,33.381,-.61),(3.172,32.204,-.305),(3.049,32.121,-.458),(3.044,32.202,-.516),(3.195,32.043,-.241),(3.115,32.044,-.344),(3.091,32.11,-.645),(3.073,32.277,-.613),(3.306,32.235,-.308),(3.224,32.044,-.22),(3.347,32.253,-.233),(3.271,32.048,-.157),(3.248,32.382,-.944),(3.362,32.29,-1.002),(3.237,32.479,-.765),(3.19,32.281,-.87),(3.315,32.167,-.914),(3.446,32.245,-.999),(3.468,32.303,-1.023),(3.151,32.384,-.728),(3.123,32.173,-.745),(3.25,32.096,-.699),(3.384,32.134,-.899),(3.576,32.271,-1.072),(3.538,32.179,-1.014),(3.578,32.625,-1.057),(3.659,32.631,-1.155),(3.476,32.072,-.9),(3.507,32.019,-1.22),(3.571,32.273,-1.34),(3.474,31.901,-1.003),(3.487,32.014,-.632),(3.409,32.117,-.609),(3.17,32.034,-.583),(3.456,31.829,-.756),(3.429,31.924,-.455),(3.354,32.05,-.452),(3.424,31.722,-.549),(3.186,32.735,-.264),(3.19,32.643,-.163),(3.253,32.844,-.285),(3.189,32.469,-.06),(3.231,32.534,-.61),(3.499,33.355,-1.19),(3.489,33.436,-1.353),(3.43,33,-1.151),(3.45,33.251,-1.065),(3.475,33.614,-1.203),(3.483,33.495,-1.063),(3.56,33.477,-1.409),(3.554,33.094,-1.531),(3.422,33.577,-.851),(3.415,33.72,-.919),(3.381,33.578,-.671),(3.394,33.723,-.671),(3.485,33.807,-.951),(3.542,33.668,-1.253),(3.372,33.631,-.51),(3.381,33.529,-.559),(3.473,33.784,-.622),(3.437,33.669,-.437),(3.311,33.442,-.418),(3.322,33.48,-.364),(3.208,32.926,-.223),(3.353,33.033,-.255),(3.185,31.487,-.099),(3.201,31.924,-.064),(3.538,33.572,-.489),(3.329,31.373,-.417),(3.213,31.312,-.206),(3.264,31.245,-.448),(3.424,31.517,-.635),(3.066,31.279,-.196),(3.142,31.209,-.462),(3.401,31.416,-.681),(3.217,32.031,-.065),(3.071,31.271,-.462),(3.004,31.304,-.204),(3.311,31.368,-.736),(3.629,33.259,-.368),(3.576,33.106,-.375),(3.688,33.516,-.459),(3.558,33.677,-.669),(3.713,33.654,-.594),(3.696,33.524,-.441),(3.491,33.414,-.253),(3.442,33.254,-.227),(3.552,33.15,-.299),(3.612,33.296,-.307),(3.375,33.493,-.294),(3.487,32.972,-.331),(3.672,33.563,-.406),(3.554,33.64,-.383),(3.499,32.905,-.435),(3.276,32.268,-.136),(3.166,32.285,-.024),(3.542,31.978,-1.263),(3.662,32.264,-1.379),(3.668,32.706,-1.415),(3.507,31.794,-1.058),(3.578,31.925,-1.302),(3.693,32.253,-1.417),(3.779,32.686,-1.449),(3.585,31.903,-1.34),(3.691,32.242,-1.462),(3.79,32.685,-1.476),(3.52,31.912,-1.364),(3.595,32.27,-1.516),(3.779,32.691,-1.529),(3.463,31.654,-1.151),(3.403,31.973,-1.338),(3.667,32.71,-1.6),(3.345,31.702,-1.132),(3.303,31.783,-1.076),(3.288,31.913,-.962),(3.319,32.183,-1.04),(3.25,31.951,-.928),(3.203,32.218,-1.071),(3.238,32.455,-1.133),(3.144,31.992,-.923),(3.294,32.736,-1.135),(3.48,31.676,-.847),(3.4,31.521,-.959),(3.305,31.564,-.958),(3.255,31.65,-.892),(3.231,31.766,-.81),(3.197,31.789,-.782),(3.085,31.83,-.759),(3.211,31.415,-.726),(3.188,31.498,-.676),(3.174,31.595,-.597),(3.115,31.639,-.579),(3.056,31.683,-.562),(3.231,33.174,-.265),(3.266,33.35,-.327),(3.523,33.51,-.708),(3.724,33.669,-.582),(3.71,33.72,-.564),(3.591,33.787,-.584),(3.581,33.458,-.835),(3.659,33.308,-.969),(3.633,33.668,-.887),(3.767,33.681,-.838),(3.774,33.696,-.837),(3.745,33.764,-.86),(3.633,33.818,-.916),(3.683,33.529,-1.169),(3.823,33.566,-1.104),(3.833,33.576,-1.111),(3.807,33.631,-1.156),(3.684,33.683,-1.228),(3.682,33.358,-1.302),(3.83,33.38,-1.258),(3.695,33.169,-1.051),(3.842,33.387,-1.268),(3.829,33.423,-1.322),(3.713,33.471,-1.409),(3.653,32.794,-.995),(3.694,32.904,-1.137),(3.679,33.03,-1.397),(3.799,33.03,-1.398),(3.815,33.034,-1.417),(3.815,33.056,-1.467),(3.707,33.09,-1.554),(3.257,33.384,-.492),(3.247,33.345,-.35),(3.291,33.407,-.454),(3.376,33.223,-.987),(3.348,32.976,-1.09),(3.216,33.198,-.27),(1.404,33.287,3.485),(1.442,33.41,3.469),(1.41,33.415,3.471),(1.473,33.397,3.467),(1.376,33.41,3.473),(1.5,33.377,3.466),(1.52,33.351,3.465),(1.533,33.32,3.464),(1.537,33.287,3.464),(1.533,33.254,3.464),(1.52,33.223,3.465),(1.5,33.196,3.466),(1.474,33.176,3.467),(1.443,33.163,3.469),(1.41,33.159,3.471),(1.377,33.163,3.473),(1.346,33.176,3.474),(1.32,33.196,3.476),(1.299,33.222,3.477),(1.286,33.253,3.478),(1.282,33.286,3.478),(1.286,33.32,3.478),(1.299,33.35,3.477),(1.319,33.377,3.476),(1.346,33.397,3.474),(1.332,33.477,2.098),(1.382,33.47,2.095),(1.331,33.287,2.074),(1.427,33.451,2.092),(1.467,33.421,2.09),(1.497,33.382,2.089),(1.516,33.336,2.088),(1.522,33.287,2.087),(1.516,33.237,2.088),(1.497,33.192,2.089),(1.467,33.152,2.09),(1.427,33.122,2.092),(1.382,33.103,2.095),(1.332,33.096,2.098),(1.283,33.103,2.101),(1.238,33.122,2.103),(1.198,33.152,2.105),(1.168,33.192,2.107),(1.149,33.237,2.108),(1.143,33.287,2.108),(1.149,33.336,2.108),(1.168,33.382,2.107),(1.198,33.421,2.105),(1.238,33.451,2.103),(1.283,33.47,2.101),(1.453,33.451,3.462),(1.409,33.457,3.465),(1.494,33.434,3.46),(1.53,33.407,3.458),(1.557,33.372,3.457),(1.574,33.331,3.456),(1.579,33.287,3.455),(1.574,33.242,3.456),(1.557,33.201,3.457),(1.53,33.166,3.458),(1.494,33.139,3.46),(1.453,33.122,3.462),(1.409,33.116,3.465),(1.365,33.122,3.467),(1.324,33.139,3.47),(1.289,33.166,3.472),(1.262,33.201,3.473),(1.245,33.242,3.474),(1.239,33.287,3.474),(1.245,33.331,3.474),(1.262,33.372,3.473),(1.289,33.407,3.472),(1.324,33.434,3.47),(1.365,33.451,3.467),(1.408,33.541,3.443),(1.474,33.533,3.439),(1.342,33.533,3.446),(1.535,33.507,3.436),(1.5,33.641,3.386),(1.405,33.654,3.392),(1.588,33.467,3.433),(1.588,33.605,3.381),(1.628,33.414,3.43),(1.664,33.546,3.377),(1.653,33.353,3.429),(1.722,33.47,3.374),(1.662,33.287,3.429),(1.759,33.382,3.372),(1.653,33.221,3.429),(1.772,33.287,3.371),(1.628,33.159,3.43),(1.759,33.192,3.372),(1.588,33.106,3.433),(1.722,33.103,3.374),(1.535,33.066,3.436),(1.664,33.027,3.377),(1.474,33.04,3.439),(1.588,32.969,3.381),(1.408,33.032,3.443),(1.5,32.932,3.386),(1.342,33.04,3.447),(1.405,32.919,3.392),(1.281,33.066,3.45),(1.31,32.932,3.397),(1.228,33.106,3.453),(1.222,32.969,3.402),(1.187,33.159,3.455),(1.146,33.027,3.406),(1.162,33.221,3.457),(1.087,33.103,3.409),(1.153,33.287,3.457),(1.051,33.192,3.411),(1.162,33.353,3.457),(1.038,33.287,3.412),(1.187,33.414,3.455),(1.051,33.382,3.411),(1.228,33.467,3.453),(1.087,33.47,3.409),(1.281,33.507,3.45),(1.146,33.546,3.406),(1.222,33.605,3.402),(1.31,33.641,3.397),(1.399,33.806,3.279),(1.533,33.788,3.272),(1.264,33.788,3.287),(1.658,33.736,3.265),(1.39,33.923,3.133),(1.555,33.901,3.124),(1.765,33.654,3.259),(1.708,33.837,3.115),(1.848,33.546,3.254),(1.839,33.736,3.108),(1.9,33.421,3.251),(1.94,33.605,3.102),(1.917,33.287,3.25),(2.004,33.451,3.099),(1.9,33.152,3.251),(2.025,33.287,3.098),(1.848,33.027,3.254),(2.004,33.122,3.099),(1.765,32.919,3.259),(1.94,32.969,3.102),(1.658,32.837,3.265),(1.839,32.837,3.108),(1.533,32.785,3.272),(1.708,32.736,3.115),(1.399,32.767,3.279),(1.555,32.672,3.124),(1.264,32.785,3.287),(1.39,32.651,3.133),(1.139,32.837,3.294),(1.226,32.672,3.142),(1.032,32.919,3.3),(1.073,32.736,3.151),(.95,33.027,3.305),(.941,32.837,3.158),(.898,33.152,3.307),(.84,32.969,3.164),(.88,33.287,3.308),(.777,33.122,3.167),(.898,33.421,3.307),(.755,33.287,3.169),(.95,33.546,3.305),(.777,33.451,3.167),(1.032,33.654,3.3),(.84,33.605,3.164),(1.139,33.736,3.294),(.941,33.736,3.158),(1.073,33.837,3.151),(1.226,33.901,3.142),(1.381,33.996,2.963),(1.564,33.972,2.953),(1.735,33.901,2.943),(1.882,33.788,2.935),(1.994,33.641,2.928),(2.065,33.47,2.925),(2.089,33.287,2.923),(2.065,33.103,2.925),(1.994,32.932,2.928),(1.882,32.785,2.935),(1.735,32.672,2.943),(1.564,32.601,2.953),(1.381,32.577,2.963),(1.198,32.601,2.973),(1.027,32.672,2.983),(.88,32.785,2.991),(.767,32.932,2.997),(.697,33.103,3.001),(.673,33.287,3.002),(.697,33.47,3.001),(.767,33.641,2.997),(.88,33.788,2.991),(1.027,33.901,2.983),(1.198,33.972,2.973),(1.371,34.021,2.78),(1.56,33.996,2.769),(1.737,33.923,2.759),(1.889,33.806,2.751),(2.006,33.654,2.744),(2.079,33.477,2.74),(2.104,33.287,2.739),(2.079,33.096,2.74),(2.006,32.919,2.744),(1.889,32.767,2.751),(1.737,32.651,2.76),(1.56,32.577,2.769),(1.371,32.552,2.78),(1.181,32.577,2.791),(1.004,32.651,2.801),(.852,32.767,2.809),(.736,32.919,2.816),(.662,33.096,2.82),(.637,33.287,2.821),(.662,33.477,2.82),(.736,33.654,2.816),(.852,33.806,2.809),(1.004,33.923,2.801),(1.181,33.996,2.791),(1.361,33.996,2.597),(1.544,33.972,2.587),(1.715,33.901,2.577),(1.861,33.788,2.569),(1.974,33.641,2.563),(2.045,33.47,2.559),(2.069,33.287,2.558),(2.045,33.103,2.559),(1.974,32.932,2.563),(1.861,32.785,2.569),(1.715,32.672,2.577),(1.544,32.601,2.587),(1.361,32.577,2.597),(1.177,32.601,2.607),(1.006,32.672,2.617),(.86,32.785,2.625),(.747,32.932,2.632),(.676,33.103,2.635),(.652,33.287,2.637),(.676,33.47,2.635),(.747,33.641,2.632),(.86,33.788,2.625),(1.006,33.901,2.617),(1.177,33.972,2.607),(1.351,33.923,2.427),(1.515,33.901,2.418),(1.669,33.837,2.409),(1.8,33.736,2.402),(1.901,33.605,2.396),(1.964,33.451,2.393),(1.986,33.287,2.391),(1.964,33.122,2.393),(1.901,32.969,2.396),(1.8,32.837,2.402),(1.669,32.736,2.409),(1.515,32.672,2.418),(1.351,32.651,2.427),(1.187,32.672,2.436),(1.033,32.736,2.445),(.902,32.837,2.452),(.801,32.969,2.458),(.737,33.122,2.461),(.716,33.287,2.462),(.737,33.451,2.461),(.801,33.605,2.458),(.902,33.736,2.452),(1.033,33.837,2.445),(1.187,33.901,2.436),(1.343,33.806,2.281),(1.477,33.788,2.273),(1.602,33.736,2.266),(1.709,33.654,2.26),(1.792,33.546,2.255),(1.844,33.421,2.253),(1.861,33.287,2.252),(1.844,33.152,2.253),(1.792,33.027,2.255),(1.709,32.919,2.26),(1.602,32.837,2.266),(1.477,32.785,2.273),(1.343,32.767,2.281),(1.209,32.785,2.288),(1.083,32.837,2.295),(.976,32.919,2.301),(.894,33.027,2.306),(.842,33.152,2.309),(.824,33.287,2.31),(.842,33.421,2.309),(.894,33.546,2.306),(.976,33.654,2.301),(1.083,33.736,2.295),(1.209,33.788,2.288),(1.337,33.654,2.168),(1.431,33.641,2.163),(1.52,33.605,2.158),(1.596,33.546,2.154),(1.654,33.47,2.151),(1.691,33.382,2.149),(1.703,33.287,2.148),(1.691,33.192,2.149),(1.654,33.103,2.151),(1.596,33.027,2.154),(1.52,32.969,2.158),(1.431,32.932,2.163),(1.337,32.919,2.168),(1.242,32.932,2.174),(1.153,32.969,2.179),(1.077,33.027,2.183),(1.019,33.103,2.186),(.982,33.192,2.188),(.97,33.287,2.189),(.982,33.382,2.188),(1.019,33.47,2.186),(1.077,33.546,2.183),(1.153,33.605,2.179),(1.242,33.641,2.174),(-1.438,33.415,3.471),(-1.471,33.41,3.469),(-1.432,33.287,3.485),(-1.501,33.397,3.467),(-1.405,33.41,3.473),(-1.528,33.377,3.466),(-1.548,33.351,3.465),(-1.561,33.32,3.464),(-1.565,33.287,3.464),(-1.561,33.254,3.464),(-1.548,33.223,3.465),(-1.528,33.196,3.466),(-1.502,33.176,3.467),(-1.471,33.163,3.469),(-1.438,33.159,3.471),(-1.405,33.163,3.473),(-1.374,33.176,3.474),(-1.348,33.196,3.476),(-1.327,33.222,3.477),(-1.314,33.253,3.478),(-1.31,33.286,3.478),(-1.314,33.32,3.478),(-1.327,33.35,3.477),(-1.347,33.377,3.476),(-1.374,33.397,3.474),(-1.359,33.287,2.074),(-1.41,33.47,2.095),(-1.361,33.477,2.098),(-1.455,33.451,2.092),(-1.495,33.421,2.09),(-1.525,33.382,2.089),(-1.544,33.336,2.088),(-1.55,33.287,2.087),(-1.544,33.237,2.088),(-1.525,33.192,2.089),(-1.495,33.152,2.09),(-1.455,33.122,2.092),(-1.41,33.103,2.095),(-1.361,33.096,2.098),(-1.311,33.103,2.101),(-1.266,33.122,2.103),(-1.226,33.152,2.105),(-1.196,33.192,2.107),(-1.177,33.237,2.108),(-1.171,33.287,2.108),(-1.177,33.336,2.108),(-1.196,33.382,2.107),(-1.226,33.421,2.105),(-1.266,33.451,2.103),(-1.311,33.47,2.101),(-1.437,33.457,3.465),(-1.481,33.451,3.462),(-1.522,33.434,3.46),(-1.558,33.407,3.458),(-1.585,33.372,3.457),(-1.602,33.331,3.456),(-1.607,33.287,3.455),(-1.602,33.242,3.456),(-1.585,33.201,3.457),(-1.558,33.166,3.458),(-1.522,33.139,3.46),(-1.481,33.122,3.462),(-1.437,33.116,3.465),(-1.393,33.122,3.467),(-1.352,33.139,3.47),(-1.317,33.166,3.472),(-1.29,33.201,3.473),(-1.273,33.242,3.474),(-1.267,33.287,3.474),(-1.273,33.331,3.474),(-1.29,33.372,3.473),(-1.317,33.407,3.472),(-1.352,33.434,3.47),(-1.393,33.451,3.467),(-1.502,33.533,3.439),(-1.436,33.541,3.443),(-1.563,33.507,3.436),(-1.37,33.533,3.446),(-1.433,33.654,3.392),(-1.528,33.641,3.386),(-1.616,33.467,3.433),(-1.616,33.605,3.381),(-1.656,33.414,3.43),(-1.692,33.546,3.377),(-1.682,33.353,3.429),(-1.75,33.47,3.374),(-1.69,33.287,3.429),(-1.787,33.382,3.372),(-1.682,33.221,3.429),(-1.8,33.287,3.371),(-1.656,33.159,3.43),(-1.787,33.192,3.372),(-1.616,33.106,3.433),(-1.75,33.103,3.374),(-1.563,33.066,3.436),(-1.692,33.027,3.377),(-1.502,33.04,3.439),(-1.616,32.969,3.381),(-1.436,33.032,3.443),(-1.528,32.932,3.386),(-1.37,33.04,3.447),(-1.433,32.919,3.392),(-1.309,33.066,3.45),(-1.338,32.932,3.397),(-1.256,33.106,3.453),(-1.25,32.969,3.402),(-1.216,33.159,3.455),(-1.174,33.027,3.406),(-1.19,33.221,3.457),(-1.115,33.103,3.409),(-1.181,33.287,3.457),(-1.079,33.192,3.411),(-1.19,33.353,3.457),(-1.066,33.287,3.412),(-1.216,33.414,3.455),(-1.079,33.382,3.411),(-1.256,33.467,3.453),(-1.115,33.47,3.409),(-1.309,33.507,3.45),(-1.174,33.546,3.406),(-1.25,33.605,3.402),(-1.338,33.641,3.397),(-1.561,33.788,3.272),(-1.427,33.806,3.279),(-1.686,33.736,3.265),(-1.292,33.788,3.287),(-1.583,33.901,3.124),(-1.419,33.923,3.133),(-1.793,33.654,3.259),(-1.736,33.837,3.115),(-1.876,33.546,3.254),(-1.868,33.736,3.108),(-1.928,33.421,3.251),(-1.968,33.605,3.102),(-1.945,33.287,3.25),(-2.032,33.451,3.099),(-1.928,33.152,3.251),(-2.054,33.287,3.098),(-1.876,33.027,3.254),(-2.032,33.122,3.099),(-1.793,32.919,3.259),(-1.968,32.969,3.102),(-1.686,32.837,3.265),(-1.868,32.837,3.108),(-1.561,32.785,3.272),(-1.736,32.736,3.115),(-1.427,32.767,3.279),(-1.583,32.672,3.124),(-1.292,32.785,3.287),(-1.419,32.651,3.133),(-1.167,32.837,3.294),(-1.254,32.672,3.142),(-1.06,32.919,3.3),(-1.101,32.736,3.151),(-.978,33.027,3.305),(-.969,32.837,3.158),(-.926,33.152,3.307),(-.869,32.969,3.164),(-.908,33.287,3.308),(-.805,33.122,3.167),(-.926,33.421,3.307),(-.783,33.287,3.169),(-.978,33.546,3.305),(-.805,33.451,3.167),(-1.06,33.654,3.3),(-.869,33.605,3.164),(-1.167,33.736,3.294),(-.969,33.736,3.158),(-1.101,33.837,3.151),(-1.254,33.901,3.142),(-1.592,33.972,2.953),(-1.409,33.996,2.963),(-1.763,33.901,2.943),(-1.91,33.788,2.935),(-2.022,33.641,2.928),(-2.093,33.47,2.925),(-2.117,33.287,2.923),(-2.093,33.103,2.925),(-2.022,32.932,2.928),(-1.91,32.785,2.935),(-1.763,32.672,2.943),(-1.592,32.601,2.953),(-1.409,32.577,2.963),(-1.226,32.601,2.973),(-1.055,32.672,2.983),(-.908,32.785,2.991),(-.796,32.932,2.997),(-.725,33.103,3.001),(-.701,33.287,3.002),(-.725,33.47,3.001),(-.796,33.641,2.997),(-.908,33.788,2.991),(-1.055,33.901,2.983),(-1.226,33.972,2.973),(-1.589,33.996,2.769),(-1.399,34.021,2.78),(-1.765,33.923,2.759),(-1.917,33.806,2.751),(-2.034,33.654,2.744),(-2.107,33.477,2.74),(-2.132,33.287,2.739),(-2.107,33.096,2.74),(-2.034,32.919,2.744),(-1.917,32.767,2.751),(-1.765,32.651,2.76),(-1.589,32.577,2.769),(-1.399,32.552,2.78),(-1.209,32.577,2.791),(-1.032,32.651,2.801),(-.88,32.767,2.809),(-.764,32.919,2.816),(-.69,33.096,2.82),(-.665,33.287,2.821),(-.69,33.477,2.82),(-.764,33.654,2.816),(-.88,33.806,2.809),(-1.032,33.923,2.801),(-1.209,33.996,2.791),(-1.572,33.972,2.587),(-1.389,33.996,2.597),(-1.743,33.901,2.577),(-1.889,33.788,2.569),(-2.002,33.641,2.563),(-2.073,33.47,2.559),(-2.097,33.287,2.558),(-2.073,33.103,2.559),(-2.002,32.932,2.563),(-1.889,32.785,2.569),(-1.743,32.672,2.577),(-1.572,32.601,2.587),(-1.389,32.577,2.597),(-1.205,32.601,2.607),(-1.034,32.672,2.617),(-.888,32.785,2.625),(-.775,32.932,2.632),(-.704,33.103,2.635),(-.68,33.287,2.637),(-.704,33.47,2.635),(-.775,33.641,2.632),(-.888,33.788,2.625),(-1.034,33.901,2.617),(-1.205,33.972,2.607),(-1.543,33.901,2.418),(-1.379,33.923,2.427),(-1.697,33.837,2.409),(-1.828,33.736,2.402),(-1.929,33.605,2.396),(-1.992,33.451,2.393),(-2.014,33.287,2.391),(-1.992,33.122,2.393),(-1.929,32.969,2.396),(-1.828,32.837,2.402),(-1.697,32.736,2.409),(-1.543,32.672,2.418),(-1.379,32.651,2.427),(-1.215,32.672,2.436),(-1.062,32.736,2.445),(-.93,32.837,2.452),(-.829,32.969,2.458),(-.766,33.122,2.461),(-.744,33.287,2.462),(-.766,33.451,2.461),(-.829,33.605,2.458),(-.93,33.736,2.452),(-1.062,33.837,2.445),(-1.215,33.901,2.436),(-1.505,33.788,2.273),(-1.371,33.806,2.281),(-1.63,33.736,2.266),(-1.737,33.654,2.26),(-1.82,33.546,2.255),(-1.872,33.421,2.253),(-1.889,33.287,2.252),(-1.872,33.152,2.253),(-1.82,33.027,2.255),(-1.737,32.919,2.26),(-1.63,32.837,2.266),(-1.505,32.785,2.273),(-1.371,32.767,2.281),(-1.237,32.785,2.288),(-1.112,32.837,2.295),(-1.004,32.919,2.301),(-.922,33.027,2.306),(-.87,33.152,2.309),(-.852,33.287,2.31),(-.87,33.421,2.309),(-.922,33.546,2.306),(-1.004,33.654,2.301),(-1.112,33.736,2.295),(-1.237,33.788,2.288),(-1.459,33.641,2.163),(-1.365,33.654,2.168),(-1.548,33.605,2.158),(-1.624,33.546,2.154),(-1.682,33.47,2.151),(-1.719,33.382,2.149),(-1.731,33.287,2.148),(-1.719,33.192,2.149),(-1.682,33.103,2.151),(-1.624,33.027,2.154),(-1.548,32.969,2.158),(-1.459,32.932,2.163),(-1.365,32.919,2.168),(-1.27,32.932,2.174),(-1.181,32.969,2.179),(-1.105,33.027,2.183),(-1.047,33.103,2.186),(-1.01,33.192,2.188),(-.998,33.287,2.189),(-1.01,33.382,2.188),(-1.047,33.47,2.186),(-1.105,33.546,2.183),(-1.181,33.605,2.179),(-1.27,33.641,2.174),(-4.903,18.808,4.041),(-4.929,18.902,4.029),(-4.947,18.848,4.022),(-4.755,18.889,4.102),(-4.801,18.939,4.082),(-4.795,18.785,4.084),(-4.756,18.829,4.102),(-4.873,18.95,4.052),(-4.638,25.062,-.098),(-5.025,18.566,3.873),(-4.648,17.899,3.846),(-4.627,18.48,4.051),(-6.57,18.475,.798),(-6.523,18.327,.523),(-5.221,19.588,3.653),(-5.555,19.178,3.547),(-5.139,19.032,3.831),(-4.893,19.55,3.861),(-4.857,20.005,3.738),(-5.665,20.354,3.232),(-4.925,21.1,3.16),(-6.293,19.066,2.446),(-6.305,18.999,1.891),(-6.222,18.727,2.075),(-6.494,18.423,1.061),(-6.55,18.592,.936),(-5.626,18.362,3.136),(-5.232,18.759,3.792),(-5.692,18.855,3.406),(-6.241,18.456,1.805),(-6.322,18.342,1.62),(-6.624,18.367,-1.365),(-6.692,19.247,-1.382),(-6.766,19.248,-1.617),(-6.664,18.855,.555),(-6.658,18.735,.255),(-6.484,18.78,1.249),(-6.532,18.715,1.083),(-6.468,18.498,1.251),(-5.707,21.434,2.631),(-5.087,22.248,2.383),(-6.623,19.136,.766),(-7.667,18.5,-2.997),(-7.548,18.053,-3.035),(-7.16,18.142,-2.165),(-6.231,24.64,-.262),(-6.169,24.729,-.333),(-6.385,24.779,-.35),(-6.261,25.322,-.873),(-6.339,25.062,-.585),(-6.172,25.021,-.566),(-6.173,24.852,-.403),(-6.37,24.488,-.156),(-6.48,24.545,-.177),(-6.635,24.354,-.045),(-7.287,25.606,-1.412),(-7.991,25.458,-1.493),(-7.987,25.381,-1.384),(-7.167,24.297,-.074),(-7.541,24.032,-.032),(-7.398,23.984,.046),(-5.165,25.311,-.764),(-4.865,25.437,-.958),(-5.16,25.458,-1.122),(-5.889,25.294,-.839),(-5.879,25.428,-1.072),(-5.899,25.655,-1.545),(-5.891,25.594,-1.405),(-5.132,25.674,-1.516),(-4.99,24.692,.029),(-4.932,24.377,.405),(-5.427,24.183,.43),(-5.24,24.382,.206),(-5.943,24.673,-.306),(-5.408,24.707,-.236),(-5.901,24.889,-.431),(-6.975,23.64,.449),(-6.193,23.588,.793),(-6.59,23.978,.277),(-6.211,24.392,-.062),(-6.326,24.278,.032),(-5.789,24.189,.2),(-6.415,20.757,2.531),(-5.844,20.053,3.198),(-7.113,21.332,.064),(-7.206,21.376,.044),(-7.187,21.329,-.233),(-7.263,21.248,-.429),(-7.28,21.36,-.262),(-7.06,21.258,-.368),(-6.906,21.145,-.531),(-6.971,21.259,-.227),(-6.63,19.378,-1.058),(-6.736,20.506,-1.812),(-6.682,19.739,-.867),(-6.668,20.254,-.398),(-6.58,18.486,-.266),(-6.572,18.612,-.085),(-6.649,20.57,2.318),(-6.957,21.517,1.436),(-7.283,22.182,.482),(-7.053,22.334,.937),(-7.217,22.433,.536),(-7.129,23.058,.561),(-7.147,22.696,.587),(-6.782,22.868,1.048),(-7.084,21.241,.322),(-6.852,20.911,.519),(-7.003,21.005,.804),(-6.546,19.322,.926),(-6.496,19.507,1.102),(-6.707,20.663,.136),(-6.023,22.586,1.719),(-5.264,23.316,1.318),(-6.494,23.221,.917),(-7.063,24.845,-4.784),(-7.896,24.571,-4.683),(-7.332,25.077,-4.528),(-7.989,25.452,-3.673),(-7.602,25.594,-3.59),(-7.692,25.363,-4.032),(-6.726,25.879,-3.584),(-6.246,25.991,-3.834),(-6.68,25.73,-4.015),(-7.614,19.302,-2.974),(-7.662,18.918,-2.981),(-7.271,19.023,-2.262),(-6.933,20.758,-4.506),(-7.056,20.21,-4.559),(-7.044,20.637,-4.278),(-5.559,21.328,-5.614),(-5.888,21.757,-5.54),(-5.481,21.422,-5.645),(-5.34,26.171,-3.059),(-5.755,26.033,-3.083),(-5.319,25.879,-2.639),(-4.691,18.897,4.081),(-4.759,18.972,4.052),(-4.913,18.775,3.987),(-4.75,18.74,4.054),(-4.979,18.835,3.961),(-4.952,18.916,3.972),(-5.025,18.599,3.911),(-4.644,18.517,4.071),(-4.442,18.699,4.145),(-4.488,18.711,4.155),(-5.21,18.773,3.83),(-4.989,18.674,3.955),(-4.689,18.609,4.077),(-5.129,19.015,3.863),(-5.125,18.801,3.893),(-4.914,19.193,3.95),(-4.908,19.224,3.923),(-5.067,18.974,3.917),(-4.64,19.153,4.072),(-4.614,19.181,4.055),(-4.903,19.111,3.985),(-4.478,18.963,4.155),(-4.435,18.976,4.146),(-4.694,19.081,4.075),(-4.563,18.936,4.135),(-4.565,18.748,4.136),(-4.868,18.988,4.006),(-4.692,18.805,4.08),(-4.674,22.73,-5.871),(-6.632,18.342,-.474),(-6.132,19.657,2.977),(-6.253,19.382,2.758),(-6.766,18.376,-4.6),(-6.082,18.626,-4.954),(-7.506,18.101,-3.564),(-7.348,18.192,-4.064),(-6.367,18.891,1.525),(-5.533,19.444,-5.327),(-6.083,19.833,-5.207),(-7.602,19.084,-3.893),(-7.519,18.648,-3.977),(-7.647,18.544,-3.493),(-7.686,18.981,-3.446),(-5.215,21.85,-5.807),(-4.894,22.294,-5.905),(-7.319,19.228,-4.431),(-7.059,18.814,-4.519),(-5.844,19.279,-5.153),(-6.317,19.651,-5.053),(-6.551,19.717,1.355),(-5.029,23.088,-5.725),(-6.461,19.02,-4.887),(-6.348,25.579,-1.305),(-6.295,25.481,-1.116),(-5.888,25.533,-1.292),(-6.38,25.628,-1.397),(-6.682,25.639,-1.407),(-6.652,25.585,-1.306),(-7.147,25.57,-1.277),(-6.721,25.695,-1.559),(-6.419,25.689,-1.536),(-6.604,25.501,-1.132),(-6.512,25.787,-1.895),(-6.821,25.788,-1.931),(-5.973,25.758,-1.865),(-7.295,25.77,-1.973),(-7.235,25.689,-1.606),(-6.65,24.808,-.364),(-6.593,25.089,-.607),(-6.57,25.355,-.902),(-6.725,24.563,-.181),(-7.059,25.069,-.583),(-7.079,24.778,-.361),(-5.93,25.039,-.563),(-6.049,24.518,-.177),(-6.983,24.053,.137),(-7.2,24.032,.086),(-6.9,24.35,-.062),(-7.476,23.485,.211),(-7.319,23.547,.287),(-7.1,24.501,-.178),(-7.085,25.346,-.883),(-7.115,25.496,-1.112),(-7.366,23.177,.334),(-7.123,23.312,.507),(-7.488,23.12,.26),(-7.637,23.441,.137),(-7.942,25.349,-1.266),(-8.834,24.75,-1.437),(-8.809,24.701,-1.303),(-8.87,24.879,-1.601),(-8.772,24.649,-1.107),(-7.884,25.299,-1.087),(-8.872,25.014,-1.823),(-7.947,25.567,-1.692),(-7.959,25.654,-2.048),(-8.878,25.114,-2.165),(-8.483,24.189,-.513),(-8.276,23.877,-.276),(-7.682,24.537,-.317),(-7.743,24.855,-.542),(-8.027,23.578,-.079),(-7.602,24.22,-.141),(-8.673,24.489,-.846),(-7.829,25.141,-.849),(-7.826,23.449,.043),(-7.651,23.06,.178),(-7.33,21.323,-.335),(-7.311,21.4,-.094),(-7.358,21.358,-.197),(-7.354,21.259,-.405),(-7.381,21.298,-.264),(-7.406,21.32,-.168),(-7.39,21.381,-.088),(-7.342,21.131,-.593),(-7.302,21.194,-.512),(-7.049,20.85,-2.404),(-6.977,20.719,-2.286),(-6.931,20.862,-2.03),(-7.003,20.969,-2.118),(-7.422,21.544,.146),(-7.393,21.626,.3),(-7.357,21.839,.389),(-7.393,21.73,.227),(-7.31,22.289,.361),(-7.331,22.581,.404),(-7.262,21.111,-.761),(-7.2,21.183,-.628),(-6.96,21.033,-1.465),(-7.083,21.155,-.934),(-7.164,21.114,-1.095),(-7.038,21.07,-1.608),(-7.338,22.038,.302),(-7.048,20.98,-2.129),(-7.087,20.868,-2.43),(-7.085,21.054,-1.646),(-7.209,21.064,-1.167),(-7.302,21.047,-.847),(-7.399,21.648,.158),(-7.424,21.467,.071),(-7.422,21.396,-.031),(-7.411,21.46,.059),(-7.352,21.939,.237),(-7.406,22.209,.283),(-7.435,22.529,.328),(-7.472,22.905,.304),(-7.349,22.96,.383),(-7.351,21.424,.036),(-7.385,21.514,.185),(-5.182,25.738,-1.847),(-5.321,25.041,-.447),(-5.613,24.419,-.034),(-6.748,20.28,2.011),(-6.699,19.941,1.673),(-7.213,21.368,.271),(-6.894,20.247,-1.984),(-6.74,20.869,-1.079),(-7.038,21.252,1.151),(-7.297,21.596,.604),(-7.254,21.886,.731),(-7.279,21.377,.399),(-6.624,21.904,1.699),(-7.634,22.838,.222),(-6.192,25.884,-2.602),(-6.661,25.86,-2.549),(-6.97,25.84,-2.559),(-6.193,24.836,-4.872),(-5.932,24.8,-4.924),(-5.695,24.161,-5.251),(-5.917,24.208,-5.193),(-5.501,23.443,-5.497),(-5.764,23.57,-5.418),(-6.468,25.945,-3.012),(-6.832,25.869,-3.031),(-6.967,25.611,-4),(-6.288,25.353,-4.554),(-6.572,25.306,-4.538),(-7.034,25.758,-3.553),(-6.561,24.887,-4.833),(-6.856,25.259,-4.507),(-6.117,24.257,-5.166),(-7.215,25.51,-4.018),(-7.131,25.8,-3.065),(-7.409,25.795,-2.604),(-7.511,25.733,-3.112),(-7.267,25.682,-3.553),(-6.069,23.703,-5.409),(-6.401,24.251,-5.17),(-6.263,23.712,-5.423),(-6.129,23.149,-5.565),(-5.877,23.054,-5.543),(-5.649,22.896,-5.606),(-8.486,24.799,-4.18),(-8.038,25.586,-3.206),(-6.634,23.711,-5.439),(-7.172,24.167,-5.135),(-6.34,23.191,-5.574),(-6.59,23.21,-5.578),(-8.883,25.135,-2.841),(-8.016,25.663,-2.695),(-8.844,25.074,-3.304),(-8.707,24.94,-3.808),(-6.791,21.331,-4.765),(-6.77,21.097,-4.788),(-6.85,20.907,-4.64),(-6.858,21.105,-4.623),(-6.807,21.4,-4.768),(-6.891,21.18,-4.626),(-6.93,20.962,-4.488),(-6.967,21.007,-4.483),(-6.693,21.933,-5.053),(-6.659,21.83,-5.064),(-6.655,21.463,-5.045),(-6.56,22.203,-5.302),(-6.495,21.907,-5.278),(-6.627,22.282,-5.307),(-6.533,22.582,-5.513),(-6.416,22.469,-5.476),(-6.128,22.705,-5.567),(-5.927,22.543,-5.589),(-6.255,22.243,-5.468),(-7.316,20.429,-2.925),(-7.352,20.244,-2.888),(-7.149,20.477,-2.597),(-7.146,20.693,-2.642),(-6.372,22.818,-5.603),(-7.055,20.851,-4.259),(-7.045,20.813,-4.257),(-7.256,20.484,-3.908),(-7.225,20.554,-3.901),(-7.298,20.369,-3.58),(-7.382,20.298,-3.57),(-7.287,20.318,-3.925),(-7.394,20.284,-3.227),(-7.305,20.34,-3.255),(-7.277,20.478,-2.953),(-7.426,20.126,-3.577),(-7.443,20.123,-3.217),(-7.161,20.722,-2.662),(-5.52,24.71,-5.098),(-5.436,24.04,-5.379),(-5.182,24.829,-5.11),(-5.105,24.064,-5.487),(-5.804,25.392,-4.704),(-5.433,25.587,-4.702),(-5.535,26.122,-3.865),(-5.316,22.621,-5.771),(-6.66,20.617,-4.894),(-6.802,20.418,-4.745),(-6.607,20.033,-4.886),(-6.418,20.225,-5.042),(-6.525,20.949,-5.126),(-7.543,19.674,-2.978),(-7.17,19.941,-2.395),(-7.635,19.329,-3.421),(-7.574,19.416,-3.865),(-7.531,19.732,-3.833),(-7.573,19.669,-3.407),(-7.344,19.604,-4.354),(-6.966,19.813,-4.685),(-6.843,19.399,-4.812),(-7.338,19.941,-4.273),(-6.222,20.518,-5.27),(-5.899,20.989,-5.475),(-6.274,21.426,-5.351),(-5.629,22.22,-5.697),(-8.114,16.398,-5.078),(-7.923,16.321,-4.966),(-8.522,15.178,-5.13),(-7.73,16.5,-4.93),(-7.73,16.243,-4.858),(-8.411,16.723,-5.232),(-8.401,16.439,-5.182),(-8.696,16.484,-5.259),(-10.298,17.464,-4.367),(-10.081,18.115,-4.252),(-10.016,17.542,-4.615),(-10.306,15.439,-4.841),(-10.261,14.433,-5.032),(-10.496,14.545,-4.821),(-10.609,14.092,-4.824),(-10.611,14.596,-4.684),(-9.74,15.478,-5.346),(-9.726,14.239,-5.314),(-10.082,14.353,-5.178),(-10.026,13.815,-5.269),(-11.366,14.096,-3.424),(-11.389,14.099,-3.172),(-11.18,14.853,-3.487),(-10.506,13.19,-4.835),(-10.637,13.237,-4.763),(-10.561,13.263,-4.804),(-10.53,12.932,-4.847),(-10.685,12.975,-4.761),(-10.65,13.551,-4.799),(-10.786,13.369,-4.703),(-10.328,13.421,-5),(-10.277,13.19,-5.01),(-11.467,13.203,-2.27),(-11.599,12.41,-2.055),(-11.418,13.111,-2.153),(-11.444,12.271,-1.954),(-11.28,12.88,-1.967),(-11.352,12.977,-2.026),(-11.208,13.266,-4.311),(-10.988,13.832,-4.408),(-10.865,13.879,-4.585),(-10.4,13.544,-4.962),(-10.53,13.601,-4.885),(-11.294,14.005,-2.571),(-11.282,13.968,-2.472),(-11.043,14.815,-2.757),(-11.095,14.834,-2.981),(-11.345,14.067,-2.852),(-11.306,14.034,-2.675),(-9.117,13.113,-1.612),(-8.977,13.077,-1.708),(-8.576,14.033,-1.753),(-8.692,14.058,-1.56),(-9.239,13.099,-1.491),(-9.171,13.108,-1.545),(-9.099,13.121,-5.083),(-9.291,13.194,-5.189),(-8.87,14.072,-5.113),(-10.636,16.406,-2.442),(-10.839,15.431,-2.522),(-10.782,15.428,-2.218),(-8.056,15.068,-1.659),(-8.143,15.079,-1.357),(-7.933,19.566,-.709),(-7.832,19.786,-.676),(-8.324,19.404,-.821),(-7.015,19.156,-1.34),(-6.954,19.719,-1.148),(-6.979,19.698,-1.075),(-10.355,18.365,-3.635),(-10.331,18.094,-3.666),(-10.331,18.082,-3.507),(-8.468,19.968,-5.114),(-9.245,19.828,-4.818),(-8.512,20.208,-5.149),(-8.314,19.249,-5.07),(-8.329,19.496,-5.033),(-7.546,19.932,-5.088),(-6.932,19.699,-5.108),(-6.697,19.41,-4.823),(-7.012,19.436,-5.093),(-10.17,18.382,-2.317),(-10.113,18.546,-2.33),(-10.361,18.218,-2.847),(-6.929,17.034,-3.125),(-6.824,17.975,-3.324),(-6.901,17.954,-2.793),(-7.092,17.007,-2.16),(-6.978,17.95,-2.283),(-7.033,17.984,-1.909),(-7.315,17.027,-1.652),(-7.08,18.008,-1.566),(-7.1,18.02,-1.49),(-8.239,18.011,-.584),(-7.891,19.116,-.62),(-8.075,19.088,-.691),(-8.939,19.173,-1.126),(-8.33,19.494,-.822),(-8.027,19.307,-.709),(-8.434,19.032,-.832),(-7.698,21.698,-5.32),(-7.501,22.238,-5.348),(-7.254,22.098,-5.402),(-7.868,21.82,.047),(-7.771,21.902,.097),(-7.836,22.243,.128),(-7.701,20.837,-.182),(-7.571,20.941,-.141),(-7.801,21.384,-.035),(-7.302,20.786,-.76),(-7.364,21.082,-.567),(-7.253,20.808,-.675),(-9.657,21.516,-1.519),(-9.727,21.507,-1.607),(-9.78,21.18,-1.629),(-9.027,21.049,-.724),(-9.461,21.157,-1.174),(-9.569,20.872,-1.315),(-7.118,20.013,-2.74),(-7.134,19.976,-2.538),(-6.934,19.444,-2.737),(-7.064,20.445,-.758),(-7.081,20.384,-.848),(-6.964,19.988,-.913),(-6.951,20.004,-.965),(-7.084,19.951,-3.416),(-7.087,19.948,-3.144),(-6.796,19.093,-3.368),(-7.07,19.927,-4.033),(-7.081,19.948,-3.73),(-6.911,19.23,-3.932),(-6.853,19.309,-4.45),(-6.895,19.927,-4.562),(-7.022,19.901,-4.317),(-8.439,21.264,-5.134),(-8.033,21.157,-5.27),(-8.457,20.659,-5.185),(-8.155,20.475,-5.255),(-10.015,20.764,-1.915),(-9.901,21.127,-1.791),(-9.996,21.101,-2.009),(-9.837,20.87,-1.639),(-9.701,21.153,-1.482),(-9.826,20.164,-1.639),(-7.17,20.562,-3.982),(-7.138,20.71,-4.335),(-7.121,20.825,-4.322),(-8.951,24.428,-4.094),(-9.303,23.962,-4.05),(-9.056,24.493,-3.913),(-9.293,24.64,-3.216),(-9.639,24.12,-3.174),(-9.315,24.67,-2.982),(-6.989,21.047,-4.531),(-10.28,16.533,-4.659),(-9.774,17.553,-4.924),(-10.001,16.546,-5.012),(-8.879,17.537,-5.39),(-9.379,16.595,-5.385),(-10.599,16.535,-4.366),(-10.55,15.459,-4.505),(-10.549,17.419,-3.297),(-10.767,16.46,-3.189),(-10.692,16.428,-2.907),(-10.535,17.421,-2.952),(-10.456,17.386,-2.337),(-10.948,15.44,-3.097),(-10.903,15.436,-2.822),(-10.55,17.419,-3.653),(-10.849,16.495,-3.571),(-10.376,17.95,-3.462),(-10.4,18.032,-2.873),(-7.967,16.661,-5.105),(-7.636,17.366,-5.16),(-6.852,17.139,-4.63),(-10.473,16.367,-1.849),(-10.302,17.334,-1.819),(-10.261,18.142,-2.297),(-10.061,16.369,-1.183),(-9.769,17.326,-1.099),(-10.662,15.415,-1.8),(-11.041,15.444,-3.551),(-10.352,17.976,-3.665),(-10.847,15.491,-4.196),(-9.06,15.308,-5.316),(-7.212,16.013,-4.515),(-8.075,15.009,-4.806),(-6.837,17.09,-4.25),(-6.967,15.948,-4.15),(-7.361,14.754,-4.13),(-7.662,14.856,-4.461),(-6.991,15.918,-3.723),(-6.882,17.031,-3.784),(-7.049,15.915,-3.04),(-7.35,14.699,-3.104),(-7.256,14.699,-3.662),(-7.308,15.956,-2.142),(-7.66,14.893,-2.177),(-7.582,16.081,-1.685),(-7.347,17.022,-1.458),(-7.485,17.06,-1.105),(-7.748,16.141,-1.151),(-7.611,16.087,-1.512),(-7.932,17.071,-.684),(-8.245,16.158,-.79),(-8.611,15.133,-.937),(-8.616,17.165,-.587),(-9.027,16.192,-.737),(-9.415,15.229,-.952),(-9.621,16.303,-.918),(-9.206,17.251,-.8),(-10.308,15.412,-1.296),(-9.945,15.323,-1.071),(-8.013,15.055,-1.784),(-9.37,14.175,-5.308),(-11.588,13.432,-3.333),(-11.653,13.378,-2.971),(-11.57,13.341,-2.616),(-11.849,12.823,-3.365),(-11.89,12.762,-2.892),(-11.243,14.027,-3.889),(-11.463,13.406,-3.757),(-11.662,12.478,-2.126),(-11.749,12.032,-1.978),(-11.674,11.99,-1.933),(-11.569,11.933,-1.92),(-11.848,12.102,-2.05),(-11.728,12.539,-2.223),(-11.498,13.244,-2.347),(-10.901,13.075,-4.682),(-10.737,12.572,-4.865),(-11.015,12.677,-4.782),(-10.799,12.223,-5.037),(-11.096,12.33,-4.947),(-10.553,12.541,-4.965),(-11.22,12.752,-4.602),(-11.081,13.189,-4.51),(-11.345,12.367,-4.754),(-10.608,12.197,-5.14),(-10.286,12.912,-5.048),(-10.306,12.565,-5.19),(-10.871,13.665,-4.604),(-11.367,12.784,-4.396),(-11.522,12.365,-4.525),(-11.375,13.362,-3.975),(-11.588,12.809,-4.036),(-10.372,12.223,-5.359),(-10.2,12.244,-5.505),(-10.116,12.601,-5.36),(-10.064,12.923,-5.252),(-9.884,12.896,-5.31),(-9.964,12.596,-5.422),(-10.043,13.331,-5.231),(-10.085,12.246,-5.568),(-9.657,12.827,-5.288),(-9.763,12.546,-5.414),(-9.788,13.333,-5.292),(-11.128,13.96,-4.117),(-11.704,12.825,-3.801),(-11.038,14.801,-4.081),(-10.823,14.703,-4.332),(-11.774,12.362,-4.106),(-11.888,12.404,-3.853),(-12.023,12.438,-3.4),(-11.797,12.658,-2.455),(-12.043,12.385,-2.843),(-9.379,12.383,-5.302),(-9.464,12.039,-5.417),(-9.634,12.131,-5.505),(-9.542,12.477,-5.385),(-9.319,11.864,-5.187),(-9.212,12.203,-5.093),(-8.973,11.946,-4.768),(-9.105,11.565,-4.866),(-9.262,12.671,-5.176),(-9.078,12.523,-4.948),(-9.885,12.203,-5.555),(-9.442,12.759,-5.265),(-8.465,12.019,-3.022),(-8.853,12.152,-2.09),(-9.105,11.503,-2.221),(-8.699,11.417,-3.112),(-9.252,11.035,-2.332),(-8.874,10.931,-3.162),(-9.312,12.269,-1.678),(-9.533,11.618,-1.751),(-8.168,12.768,-3.037),(-8.567,12.944,-2.094),(-8.565,11.42,-3.895),(-8.338,12.027,-3.775),(-8.764,10.961,-3.927),(-9.666,11.171,-1.73),(-9.436,12.304,-1.621),(-9.695,11.64,-1.626),(-8.16,13.842,-2.182),(-7.772,13.65,-3.015),(-8.069,12.718,-3.747),(-8.639,11.581,-4.27),(-8.834,11.076,-4.301),(-8.471,12.13,-4.171),(-8.236,12.775,-4.148),(-8.827,12.341,-4.632),(-7.678,13.63,-3.673),(-9.797,11.274,-1.578),(-9.719,11.634,-1.599),(-9.501,12.3,-1.572),(-10.713,11.372,-1.656),(-10.155,11.23,-1.51),(-10.008,11.674,-1.581),(-10.544,11.797,-1.752),(-11.124,11.545,-1.667),(-10.953,11.946,-1.8),(-10.316,12.451,-1.744),(-9.776,12.313,-1.562),(-9.903,11.214,-1.551),(-9.792,11.627,-1.578),(-9.822,11.272,-1.554),(-9.566,12.292,-1.553),(-9.468,13.114,-1.413),(-10.744,12.561,-1.794),(-10.979,12.677,-1.878),(-11.172,12.076,-1.884),(-10.043,13.259,-1.504),(-10.47,13.383,-1.572),(-9.759,14.266,-1.23),(-9.038,14.108,-1.179),(-11.338,11.683,-1.732),(-10.772,13.502,-1.69),(-10.208,14.386,-1.317),(-11.179,13.778,-2.068),(-11.233,13.862,-2.258),(-11.079,13.673,-1.896),(-10.807,14.649,-1.854),(-10.519,14.501,-1.472),(-8.866,13.007,-4.85),(-8.602,12.885,-4.555),(-8.405,13.876,-4.671),(-9.512,13.257,-5.241),(-7.831,13.684,-4.086),(-8.201,13.788,-4.462),(-11.945,12.217,-2.324),(-11.528,13.277,-2.423),(-10.925,14.736,-2.165),(-10.985,14.802,-2.466),(-9.451,18.324,-4.816),(-10.019,18.195,-1.79),(-8.564,18.487,-5.209),(-6.753,18.082,-4.35),(-6.754,18.179,-4.734),(-6.782,18.015,-3.861),(-7.126,18.009,-1.314),(-7.264,18.015,-1.031),(-7.612,18.009,-.662),(-9.432,18.167,-1.098),(-8.831,18.09,-.818),(-7.267,18.338,-5.17),(-7.61,19.754,-.644),(-7.552,19.984,-.595),(-7.773,19.409,-.649),(-7.321,19.131,-.766),(-7.267,19.596,-.766),(-7.07,19.124,-.938),(-7.022,19.657,-.888),(-6.989,19.681,-1.02),(-7.029,19.119,-1.159),(-6.787,19.083,-2.986),(-6.824,19.09,-2.621),(-6.868,19.107,-2.274),(-6.931,19.1,-1.747),(-6.98,19.126,-1.494),(-7.919,20.262,-5.225),(-7.718,20.078,-5.159),(-8.376,19.693,-5.064),(-9.252,20.558,-4.844),(-9.977,19.55,-4.265),(-9.837,20.425,-4.3),(-10.372,19.457,-3.601),(-10.233,20.328,-3.573),(-10.424,19.726,-2.648),(-10.296,20.508,-2.584),(-7.888,19.834,-.645),(-7.932,20.005,-.539),(-8.361,19.744,-.726),(-9.07,18.896,-1.142),(-9.752,18.802,-1.841),(-9.851,18.586,-1.826),(-8.985,19.365,-1.091),(-9.767,19.048,-1.766),(-10.008,18.502,-4.15),(-10.045,18.269,-4.193),(-9.305,18.729,-4.709),(-9.205,18.97,-4.649),(-10.384,18.751,-3.607),(-10.011,18.869,-4.215),(-10.184,19.286,-2.15),(-9.779,19.536,-1.685),(-10.147,20.008,-2.04),(-9.282,19.314,-4.7),(-10.411,18.544,-2.785),(-10.436,18.954,-2.71),(-10.143,18.83,-2.237),(-8.401,20.079,-.604),(-9.044,19.819,-.956),(-9.054,20.409,-.84),(-9.25,24.204,-1.434),(-9.211,24.144,-1.303),(-9.308,24.347,-1.617),(-9.349,24.483,-1.846),(-9.372,24.59,-2.193),(-8.448,23.328,-.243),(-8.757,23.594,-.489),(-9.031,23.908,-.836),(-9.165,24.086,-1.102),(-8.362,24.153,-4.688),(-7.664,23.81,-5.132),(-8.104,23.071,-.041),(-7.849,22.993,.084),(-7.126,23.408,-5.425),(-7.196,20.375,-3.35),(-7.19,20.422,-3.669),(-7.235,20.431,-3.638),(-7.243,20.391,-3.326),(-7.215,20.568,-3.903),(-7.162,20.331,-3.363),(-7.16,20.364,-3.686),(-7.202,20.479,-3.056),(-7.241,20.482,-3.047),(-7.079,20.903,-4.3),(-7.174,20.741,-2.753),(-7.212,20.576,-2.8),(-6.912,21.238,-4.69),(-6.943,21.258,-4.717),(-6.865,21.513,-4.881),(-6.842,21.47,-4.835),(-6.708,22.248,-5.304),(-6.757,21.94,-5.067),(-6.784,21.892,-5.063),(-6.739,22.174,-5.291),(-7.379,21.104,-.399),(-6.537,22.874,-5.613),(-6.622,22.58,-5.522),(-6.69,22.496,-5.52),(-6.616,22.841,-5.613),(-7.026,21.045,-4.533),(-7.116,20.936,-2.216),(-7.139,20.841,-2.522),(-7.153,20.981,-1.797),(-7.26,20.948,-1.332),(-7.351,20.91,-1.004),(-7.38,20.979,-.751),(-7.38,21.429,.05),(-7.405,21.253,-.045),(-7.483,21.764,.136),(-7.598,22.422,.239),(-7.561,22.091,.196),(-7.18,20.362,-3.084),(-7.153,20.399,-3.998),(-7.388,21.124,-.291),(-7.402,21.192,-.155),(-7.224,20.817,-1.921),(-7.316,20.759,-1.485),(-7.189,20.796,-2.268),(-7.396,20.709,-1.14),(-7.382,20.757,-.891),(-6.984,21.212,-4.751),(-7.069,20.983,-4.535),(-6.818,22.986,-5.541),(-7.674,21.546,.033),(-7.495,21.155,-.067),(-7.319,20.912,-.159),(-7.199,20.706,-2.569),(-6.75,22.313,-5.476),(-6.714,22.658,-5.563),(-6.788,22.019,-5.275),(-7.265,20.779,-.505),(-6.818,21.778,-5.075),(-6.907,21.457,-4.925),(-9.632,22.223,-1.422),(-9.491,23.517,-1.344),(-9.547,23.593,-1.474),(-9.719,22.281,-1.55),(-9.864,22.407,-1.757),(-9.633,23.73,-1.68),(-9.436,23.456,-1.135),(-9.555,22.174,-1.224),(-9.82,21.503,-1.787),(-9.997,22.519,-2.017),(-9.706,23.866,-1.919),(-9.284,22.033,-.925),(-9.256,23.255,-.855),(-8.826,22.01,-.492),(-8.879,22.946,-.477),(-9.575,21.504,-1.339),(-9.348,21.513,-1.047),(-8.838,21.536,-.545),(-10.023,22.659,-3.311),(-10.081,22.591,-2.398),(-9.747,23.964,-2.274),(-9.937,21.497,-2.042),(-10.042,21.511,-2.483),(-7.002,21.129,-4.785),(-7.086,20.892,-4.537),(-7.086,20.601,-4.537),(-6.957,20.781,-4.816),(-6.999,20.3,-4.559),(-6.801,20.429,-4.86),(-7.135,20.498,-4.291),(-6.93,21.373,-4.974),(-6.841,20.986,-5.016),(-6.71,21.212,-5.094),(-6.836,21.634,-5.089),(-6.619,20.61,-5.057),(-6.689,21.385,-5.226),(-6.804,21.819,-5.254),(-6.664,21.592,-5.358),(-6.785,22.091,-5.433),(-6.93,21.886,-5.438),(-6.775,22.405,-5.514),(-6.946,21.133,-5.332),(-6.767,20.94,-5.213),(-6.649,20.789,-5.104),(-7.294,22.855,-5.401),(-6.997,22.682,-5.493),(-7.28,21.384,-5.388),(-7.199,20.463,-2.847),(-8.384,21.613,-.259),(-8.448,22.107,-.218),(-8.484,22.762,-.225),(-8.05,21.724,-.044),(-8.09,22.167,-.001),(-8.101,22.692,-.009),(-8.418,21.187,-.351),(-7.957,21.253,-.128),(-10.007,21.582,-3.414),(-9.627,22.647,-4.155),(-9.589,21.614,-4.221),(-8.904,22.563,-4.771),(-8.675,23.589,-4.714),(-8.941,21.757,-4.812),(-8.095,22.364,-5.128),(-7.95,23.282,-5.13),(-8.292,21.808,-5.126),(-7.846,22.74,.121),(-8.45,20.584,-.495),(-7.971,20.757,-.272),(-7.268,20.846,-.262),(-7.37,20.65,-.241),(-7.318,20.51,-1.662),(-7.261,20.634,-2.061),(-7.233,20.613,-2.336),(-7.226,20.233,-1.879),(-7.225,20.292,-2.222),(-7.374,20.449,-1.304),(-7.263,20.149,-1.492),(-7.318,20.464,-1.034),(-7.19,20.13,-1.174),(-7.167,20.455,-.891),(-7.176,20.307,-2.895),(-7.154,20.277,-3.11),(-7.215,20.518,-2.624),(-7.209,20.3,-2.456),(-7.191,20.31,-2.683),(-7.259,20.796,-.414),(-7.117,20.412,-.503),(-7.041,20.343,-.579),(-7.357,20.726,-5.297),(-7.659,20.943,-5.334),(-9.079,21.221,-4.832),(-7.087,20.233,-4.3),(-7.253,20.518,-.353),(-7.648,20.472,-.307),(-10.068,20.991,-3.502),(-10.127,21.021,-2.552),(-7.136,20.263,-3.372),(-7.138,20.258,-3.699),(-7.965,20.308,-.404),(-7.097,19.862,-2.401),(-7.048,19.83,-2.063),(-7.085,19.779,-1.629),(-6.98,19.752,-1.302),(-7.008,20.089,-1.01),(-7.12,20.231,-4.011),(-7.087,19.937,-2.918),(-7.546,20.082,-.575),(-7.178,19.954,-.701),(-7.603,20.249,-.442),(-6.972,20.03,-.829),(-6.641,20.05,-4.859),(-6.674,20.247,-5.079),(-6.99,20.417,-5.118),(-7.151,20.548,-5.208),(-9.691,21.088,-4.273),(-13.625,2.138,-3.383),(-13.855,2.201,-3.493),(-13.797,2.445,-3.537),(-13.171,2.587,-3.272),(-13.323,2.077,-3.14),(-13.455,2.098,-3.293),(-13.289,2.48,-.942),(-13.123,2.416,-1.206),(-13.03,2.856,-1.305),(-14.418,2.885,-1.343),(-14.527,2.455,-1.115),(-14.367,2.888,-1.246),(-11.421,8.877,-1.322),(-11.714,8.477,-1.226),(-11.158,8.344,-1.398),(-12.138,8.452,-1.209),(-11.947,9.153,-1.29),(-12.253,9.247,-1.382),(-12.103,9.569,-1.333),(-11.349,6.994,-4.956),(-11.039,8.162,-5.218),(-10.628,7.92,-4.879),(-10.549,8.439,-5.176),(-12.019,7.486,-5.224),(-11.664,8.597,-5.437),(-11.294,8.342,-5.326),(-11.39,8.945,-5.517),(-11.998,12.034,-3.964),(-12.233,11.48,-4.126),(-12.262,11.507,-4.063),(-11.891,12.002,-4.185),(-11.786,11.759,-1.888),(-11.857,11.36,-1.747),(-11.776,11.21,-1.667),(-12.1,8.897,-5.348),(-11.83,9.813,-5.396),(-11.689,9.727,-5.464),(-12.631,9.355,-4.967),(-12.414,10.261,-4.875),(-12.291,10.158,-5.06),(-11.703,11.952,-4.561),(-11.505,11.932,-4.843),(-11.593,11.702,-4.894),(-11.374,11.422,-5.189),(-11.27,11.636,-5.169),(-9.472,10.482,-4.883),(-9.381,10.772,-4.867),(-9.121,10.517,-4.385),(-10.198,9.019,-5.198),(-10.309,9.061,-5.26),(-9.958,10.931,-1.476),(-10.031,10.465,-1.459),(-9.861,10.988,-1.535),(-10.822,11.12,-1.562),(-11.16,10.802,-1.49),(-10.9,10.697,-1.458),(-10.377,8.141,-1.688),(-9.967,9.034,-1.845),(-10.28,9.205,-1.514),(-8.982,10.753,-4.307),(-8.909,10.628,-3.941),(-11.55,11.136,-1.533),(-11.696,11.319,-1.677),(-11.716,10.748,-1.495),(-11.693,11.692,-1.84),(-11.673,10.26,-1.422),(-11.585,10.547,-1.441),(-11.88,10.7,-1.516),(-11.799,10.638,-1.489),(-11.455,10.133,-1.428),(-11.479,9.877,-1.395),(-11.143,9.728,-1.375),(-11.616,9.906,-1.388),(-11.565,9.457,-1.342),(-12.026,10.026,-1.378),(-12.147,10.051,-1.403),(-12.395,11.347,-3.846),(-12.604,10.981,-3.841),(-12.611,10.966,-3.66),(-12.576,10.401,-4.485),(-12.52,10.351,-4.634),(-12.792,9.517,-4.566),(-12.427,10.889,-4.39),(-12.481,10.922,-4.3),(-12.589,7.316,-1.22),(-12.93,7.181,-1.435),(-12.626,6.913,-1.212),(-14.229,3.781,-1.585),(-13.869,4.731,-1.715),(-13.976,4.771,-1.856),(-13.946,4.475,-3.43),(-13.854,4.404,-3.581),(-14.23,3.515,-3.216),(-13.768,4.31,-3.741),(-13.327,5.259,-4.163),(-13.67,4.215,-3.822),(-12.997,8.518,-4.434),(-12.981,8.25,-4.641),(-13.108,8.087,-4.37),(-13.162,3.673,-3.821),(-13.431,2.755,-3.507),(-13.612,2.863,-3.618),(-12.376,9.123,-5.197),(-12.626,8.039,-4.951),(-13.686,5.739,-3.575),(-13.444,6.917,-3.947),(-13.399,6.887,-4.079),(-14.474,3.146,-2.78),(-14.444,3.498,-2.543),(-14.332,3.525,-2.935),(-13.934,1.967,-3.417),(-13.637,1.854,-3.385),(-13.473,1.825,-3.319),(-14.182,2.046,-3.405),(-14.121,2.301,-3.512),(-13.351,1.799,-3.183),(-13.072,2.062,-2.839),(-13.142,1.805,-2.8),(-12.933,2.141,-2.41),(-13.05,1.835,-2.347),(-12.899,2.549,-2.956),(-13.018,1.953,-1.868),(-12.896,2.245,-1.981),(-12.763,2.547,-2.515),(-14.777,2.425,-2.103),(-14.611,2.781,-2.251),(-14.56,2.698,-2.598),(-14.723,2.343,-2.484),(-14.48,2.605,-2.935),(-14.597,2.275,-2.862),(-14.729,2.438,-1.627),(-14.57,2.856,-1.764),(-13.253,2.051,-1.036),(-13.381,2.144,-.798),(-13.442,2.536,-.848),(-13.535,2.188,-.686),(-12.931,2.354,-1.591),(-13.071,2.001,-1.446),(-14.192,2.469,-.731),(-14.097,2.872,-.815),(-14.16,3.671,-1.378),(-13.923,3.557,-1.022),(-13.877,2.775,-.792),(-13.985,2.376,-.68),(-13.631,2.647,-.795),(-13.779,2.284,-.629),(-13.705,3.42,-.925),(-13.455,3.261,-.953),(-13.241,3.057,-1.069),(-12.818,2.738,-1.713),(-14.506,2.202,-3.027),(-14.452,2.547,-3.103),(-14.357,2.417,-3.311),(-14.413,2.13,-3.186),(-14.37,2.923,-3.225),(-14.252,2.797,-3.406),(-14.402,3.671,-2.022),(-12.76,2.619,-2.084),(-14.045,2.626,-3.558),(-14.42,3.012,-3.022),(-12.795,4.076,-1.327),(-12.589,3.889,-1.598),(-13.86,3.041,-3.67),(-14.081,3.212,-3.536),(-13.272,4.422,-1.142),(-13.543,4.579,-1.26),(-9.965,9.608,-5.203),(-9.814,9.582,-5.045),(-10.066,8.951,-5.005),(-9.474,9.505,-4.487),(-9.794,8.848,-4.533),(-9.795,10.143,-5.158),(-9.597,10.12,-4.939),(-10.093,9.658,-5.29),(-11.774,9.188,-1.299),(-11.745,9.897,-1.379),(-11.978,7.289,-1.181),(-11.341,7.193,-1.431),(-10.787,9.523,-1.309),(-12.555,9.223,-1.59),(-12.524,8.422,-1.412),(-10.298,7.781,-4.476),(-10.749,6.772,-4.351),(-11.852,8.728,-5.44),(-12.316,7.721,-5.151),(-10.917,9.347,-5.5),(-11.178,9.485,-5.585),(-11.321,9.538,-5.582),(-10.542,9.158,-5.352),(-12.094,11.537,-4.287),(-12.326,10.942,-4.511),(-11.924,11.474,-4.656),(-11.449,11.436,-1.632),(-11.448,10.268,-5.468),(-11.591,10.357,-5.392),(-12.072,9.983,-5.241),(-11.503,9.631,-5.538),(-11.106,10.107,-5.61),(-11.266,10.182,-5.551),(-11.037,10.679,-5.52),(-11.218,10.774,-5.417),(-11.83,10.541,-5.238),(-11.562,11.086,-5.204),(-11.351,10.873,-5.343),(-12.05,10.747,-5.025),(-11.173,11.247,-5.297),(-11.041,11.152,-5.37),(-10.883,10.599,-5.595),(-10.755,10.536,-5.621),(-10.958,10.042,-5.618),(-10.862,11.061,-5.492),(-10.721,10.987,-5.584),(-10.902,11.437,-5.353),(-10.719,11.384,-5.489),(-11.046,11.5,-5.274),(-11.771,11.351,-4.939),(-12.188,10.858,-4.803),(-10.919,11.831,-5.173),(-11.195,11.925,-5.075),(-10.757,11.79,-5.251),(-10.555,11.771,-5.427),(-10.416,11.759,-5.564),(-10.593,11.337,-5.597),(-10.303,11.74,-5.627),(-10.484,11.303,-5.647),(-10.076,11.691,-5.602),(-10.25,11.232,-5.606),(-10.379,10.832,-5.576),(-10.607,10.931,-5.624),(-10.517,10.421,-5.56),(-9.924,11.138,-5.504),(-10.068,10.703,-5.457),(-10.196,10.268,-5.433),(-10.336,9.764,-5.403),(-10.687,9.922,-5.541),(-9.86,10.612,-5.333),(-9.974,10.166,-5.313),(-9.721,11.046,-5.379),(-9.596,10.919,-5.161),(-9.695,10.536,-5.143),(-9.58,11.534,-5.401),(-9.77,11.623,-5.521),(-9.262,11.132,-4.869),(-9.462,11.38,-5.165),(-9.226,10.129,-4.387),(-9.84,9.697,-1.78),(-9.778,10.364,-1.73),(-10.126,9.84,-1.475),(-10.383,10.539,-1.346),(-10.591,10.018,-1.326),(-9.731,10.867,-1.719),(-9.5,9.508,-2.46),(-9.394,10.136,-2.397),(-11.055,10.198,-1.393),(-11.37,10.389,-1.444),(-10.236,10.95,-1.414),(-11.398,10.954,-1.475),(-9.698,8.893,-2.453),(-10.064,7.956,-2.384),(-10.745,6.891,-1.84),(-10.593,6.778,-2.425),(-9.876,7.853,-3.196),(-9.516,8.86,-3.227),(-9.283,9.51,-3.252),(-9.115,10.032,-3.287),(-8.984,10.508,-3.257),(-9.319,10.655,-2.361),(-9.316,9.473,-3.967),(-9.091,10.119,-3.965),(-12.061,12.056,-3.793),(-12.175,12.119,-3.328),(-11.246,11.289,-1.561),(-11.786,10.31,-1.427),(-9.59,8.805,-3.943),(-9.986,7.734,-3.853),(-10.465,6.683,-3.026),(-10.506,6.681,-3.833),(-12.834,9.851,-2.298),(-12.568,9.95,-1.845),(-12.535,10.565,-2.087),(-12.74,10.505,-2.613),(-12.416,11.166,-2.356),(-12.563,11.139,-2.921),(-12.301,9.994,-1.522),(-12.307,10.542,-1.681),(-12.872,9.122,-1.971),(-12.981,9.756,-2.711),(-12.811,10.455,-3.106),(-12.561,11.081,-3.431),(-12.275,11.695,-2.591),(-12.362,11.676,-3.162),(-12.241,11.066,-1.894),(-12.131,11.568,-2.083),(-12.146,10.485,-1.51),(-12.096,10.966,-1.672),(-13.058,9.013,-2.315),(-13.063,9.664,-2.914),(-12.84,10.422,-3.309),(-12.571,11.031,-3.617),(-12.858,10.399,-3.412),(-12.312,11.498,-3.806),(-12.299,11.607,-3.65),(-13.048,8.278,-1.978),(-12.831,8.365,-1.668),(-13.151,8.961,-2.418),(-13.131,8.266,-2.076),(-13.104,9.692,-3.097),(-13.293,9.009,-2.796),(-11.995,11.452,-1.843),(-12.013,10.417,-1.459),(-11.957,10.862,-1.589),(-12.149,12.105,-2.751),(-12.031,11.956,-2.22),(-11.913,11.842,-1.97),(-13.405,8.275,-2.566),(-13.128,9.601,-3.485),(-13.338,8.926,-3.3),(-12.849,10.403,-3.699),(-12.712,10.519,-4.19),(-13.005,9.495,-4.142),(-12.545,10.994,-4.136),(-12.633,10.442,-4.377),(-13.233,8.756,-3.988),(-13.416,8.184,-3.872),(-13.501,8.252,-3.149),(-12.838,9.558,-4.439),(-13.047,8.584,-4.307),(-11.893,10.358,-1.431),(-11.908,9.947,-1.37),(-12.398,3.718,-1.926),(-12.999,4.251,-1.174),(-12.393,5.415,-1.364),(-12.096,5.216,-1.595),(-11.801,4.985,-1.968),(-12.624,5.56,-1.258),(-12.131,6.606,-1.234),(-11.611,6.376,-1.453),(-11.124,6.083,-1.915),(-12.341,6.733,-1.195),(-12.873,5.695,-1.257),(-13.178,5.855,-1.413),(-13.413,5.92,-1.733),(-13.778,4.686,-1.594),(-13.179,7.165,-1.82),(-13.519,5.939,-1.859),(-13.247,7.167,-1.923),(-13.695,5.958,-2.072),(-14.112,4.746,-2.275),(-13.821,5.893,-2.539),(-13.538,7.178,-2.279),(-13.676,7.137,-2.878),(-12.22,7.305,-1.15),(-14.196,3.334,-3.388),(-13.486,5.474,-4.002),(-12.804,6.563,-4.779),(-13.072,6.748,-4.567),(-13.636,5.574,-3.763),(-13.344,6.88,-4.272),(-13.173,8.104,-4.237),(-13.447,4.012,-3.95),(-13.01,5.133,-4.298),(-12.498,6.36,-4.824),(-12.566,4.848,-4.173),(-12.088,4.649,-3.788),(-12.707,3.509,-3.482),(-11.91,5.99,-4.616),(-11.373,5.729,-4.153),(-12.289,3.564,-2.307),(-12.284,3.452,-2.718),(-12.44,3.415,-3.188),(-11.641,4.809,-2.444),(-11.59,4.679,-2.887),(-11.801,4.595,-3.449),(-10.987,5.934,-2.436),(-10.917,5.826,-2.915),(-11.131,5.675,-3.806),(-14.122,4.641,-2.826),(-13.838,5.754,-3.16),(-13.626,7.027,-3.578),(-14.011,4.543,-3.228),(-15.683,-1.233,-.723),(-15.422,-1.456,-.792),(-15.425,-1.412,-.728),(-15.549,.393,-1.972),(-15.673,-.019,-2.005),(-15.747,.044,-1.773),(-15.629,.412,-1.666),(-15.335,.878,-2.02),(-15.656,.446,-1.153),(-15.653,.434,-1.291),(-15.746,.231,-1.2),(-15.585,.581,-1.356),(-15.885,.002,-1.063),(-15.845,.127,-.968),(-15.807,.182,-.732),(-15.757,.32,-.863),(-14.781,-1.6,-2.363),(-14.984,-1.417,-2.575),(-14.786,-1.555,-2.48),(-14.784,-1.678,-2.172),(-15.418,.782,-.768),(-15.555,.685,-1.1),(-15.6,.501,-.677),(-15.912,-.194,-1.362),(-15.91,-.091,-1.022),(-15.412,-.772,-2.719),(-15.309,-.534,-2.732),(-15.365,-.79,-2.766),(-15.441,-1.064,-2.641),(-15.427,-.904,-2.67),(-15.375,-1.05,-2.701),(-13.046,1.627,-2.079),(-13.056,1.587,-2.288),(-14.604,-1.173,-3.285),(-14.399,-1.324,-3.231),(-14.449,-1.344,-3.228),(-15.125,-1.258,-2.741),(-15.055,-1.396,-2.714),(-15.181,-1.08,-2.862),(-15.125,-1.108,-2.907),(-15.101,-1.371,-2.831),(-14.413,-1.448,-2.3),(-14.609,-1.509,-2.356),(-14.428,-1.438,-2.352),(-14.231,-1.05,-2.286),(-14.312,-1.467,-2.8),(-14.232,-1.456,-2.813),(-14.381,-1.486,-2.634),(-14.373,-1.257,-3.246),(-15.74,-1.191,-.669),(-15.758,-1.198,-.653),(-15.887,-1.058,-.67),(-14.808,-1.395,-1.661),(-14.772,-1.39,-1.739),(-14.723,-1.002,-1.72),(-15.883,-.295,-1.75),(-15.896,-.26,-1.618),(-15.54,-.068,-2.305),(-15.363,.295,-2.412),(-15.443,-.121,-2.468),(-14.874,1.788,-2.374),(-14.935,1.981,-1.947),(-14.808,2.004,-2.402),(-16.085,-.498,-.421),(-16.068,-.466,-.355),(-16.025,-.299,-.434),(-14.491,-.669,-3.329),(-14.436,-.464,-3.34),(-14.177,-.662,-3.344),(-14.981,-1.028,-.132),(-15.008,-1.245,-.381),(-14.913,-1.015,-.523),(-15.024,-1.302,-.52),(-14.981,-1.251,-.911),(-14.879,-.921,-.884),(-15.001,-1.263,-.798),(-14.491,-.416,-1.124),(-14.551,-.591,-.745),(-14.788,-.746,-.613),(-14.618,-.456,-1.423),(-14.456,-.274,-1.714),(-14.483,-.305,-1.464),(-15.417,-.505,.208),(-15.638,-.422,.139),(-15.445,-.558,.216),(-14.871,-.568,.106),(-14.957,-.494,.137),(-15.119,-.616,.183),(-14.772,-.64,-.019),(-14.644,-.664,-.328),(-14.663,-.629,-.061),(-14.285,-.139,-1.341),(-14.228,-.172,-1.264),(-14.629,-.554,.025),(-15.516,-1.383,-.584),(-15.474,-1.379,-.606),(-15.227,-1.432,-.419),(-15.214,-1.436,-.552),(-14.134,-.478,-.577),(-14.344,-.577,-.475),(-14.19,-.36,-.959),(-13.113,1.67,-1.278),(-13.018,1.405,-1.05),(-13.113,1.58,-1.325),(-13.043,1.676,-1.81),(-13.148,1.678,-1.627),(-13.131,1.387,-1.815),(-13.375,2.107,-.782),(-14.01,1.277,-3.429),(-14.288,1.525,-3.316),(-13.972,1.438,-3.423),(-16.017,-.41,-.192),(-15.943,-.374,-.079),(-15.963,-.254,-.247),(-15.716,-.148,-.099),(-15.876,-.129,-.314),(-15.805,-.368,.015),(-16.09,-.625,-.708),(-16.024,-.898,-.675),(-16.1,-.807,-.372),(-15.198,-.971,-2.882),(-15.128,-.985,-2.981),(-13.166,1.884,-1.396),(-16.018,-.402,-.719),(-15.961,-.157,-.508),(-15.957,-.208,-.773),(-16.087,-.492,-1.327),(-16.121,-.599,-1.332),(-16.115,-.608,-1.201),(-16.064,-.523,-1.568),(-16.076,-.611,-1.672),(-16.102,-.639,-1.552),(-14.897,.691,-.121),(-14.752,.717,-.087),(-14.76,.991,-.254),(-14.156,-1.391,-2.733),(-14.039,-1.12,-2.645),(-14.191,-1.426,-2.585),(-14.076,.918,-3.42),(-14.444,1.078,-3.263),(-14.059,1.055,-3.411),(-15.386,1.031,-1.474),(-15.032,-.304,-2.96),(-15.216,-.242,-2.781),(-15.022,.166,-2.912),(-14.58,1.558,-3.091),(-14.579,1.887,-3.013),(-14.497,1.83,-3.143),(-13.542,.716,-1.827),(-13.963,.298,-1.699),(-13.951,.33,-1.786),(-16.094,-.718,-1.034),(-15.996,-.969,-.863),(-16.071,-.679,-.889),(-14.662,.129,.102),(-14.891,-.048,.128),(-14.666,-.308,.078),(-14.548,-.23,.073),(-15.793,-.398,-2.014),(-15.781,.097,-1.498),(-15.18,.702,-2.461),(-14.659,-1.535,-2.496),(-15.068,-1.466,-2.471),(-14.928,-1.674,-2.266),(-14.734,-1.554,-2.095),(-15.264,.598,-.292),(-15.104,.893,-.445),(-14.966,1.225,-.637),(-15.215,1.151,-.996),(-15.675,.28,-.485),(-15.438,.308,-.21),(-14.663,1.231,-.383),(-15.054,1.547,-1.189),(-14.859,1.586,-.804),(-15.883,.029,-.62),(-15.904,-.047,-.846),(-15.979,-.36,-1.294),(-15.969,-.257,-.976),(-16.069,-.55,-1.071),(-16.042,-.479,-.929),(-15.953,-.387,-1.599),(-13.634,1.618,-3.429),(-13.949,1.736,-3.425),(-15.228,-1.646,-1.664),(-15.065,-1.688,-1.657),(-15.15,-1.713,-1.426),(-15.304,-1.666,-1.513),(-14.954,-1.593,-1.665),(-15.075,-1.589,-1.381),(-15.5,-1.495,-1.661),(-15.466,-1.505,-1.72),(-15.567,-.731,-2.556),(-15.591,-.523,-2.468),(-15.074,-.615,-2.997),(-15.235,-.833,-2.893),(-15.351,-.909,-2.759),(-15.492,-1.228,-2.625),(-15.35,-1.248,-2.663),(-15.691,-1.172,-2.466),(-15.607,-1.055,-2.533),(-15.321,-1.027,-2.752),(-15.228,-1.247,-2.656),(-15.584,-.877,-2.558),(-13.75,1.088,-3.369),(-13.764,.97,-3.354),(-13.651,1.32,-3.409),(-13.505,.964,-3.257),(-13.537,.873,-3.235),(-13.793,.718,-3.385),(-13.193,.695,-2.594),(-13.313,.321,-2.604),(-13.387,.453,-2.975),(-13.349,.769,-3.03),(-13.28,.684,-2.181),(-13.552,.263,-2.173),(-13.524,-.012,-3.022),(-13.478,-.127,-2.656),(-13.578,.6,-3.249),(-13.285,.892,-3.076),(-13.143,.888,-2.633),(-13.687,.109,-3.266),(-13.459,1.272,-3.322),(-13.084,1.345,-2.017),(-13.038,1.303,-2.218),(-13.109,.98,-2.192),(-13.194,1.036,-1.957),(-13.066,1.21,-2.692),(-13.083,1.534,-2.732),(-13.437,1.578,-3.337),(-13.276,1.552,-3.175),(-14.66,-1.372,-1.984),(-14.54,-1.521,-2.52),(-14.539,-.995,-1.977),(-14.285,-1.38,-3.121),(-14.346,-1.396,-3.116),(-14.237,-1.309,-3.127),(-14.226,-1.422,-2.965),(-14.298,-1.433,-2.955),(-14.15,-1.372,-2.953),(-15.739,-1.273,-1.742),(-15.679,-1.261,-1.842),(-15.858,-1.093,-.792),(-15.836,-1.032,-1.888),(-16.01,-.976,-1.721),(-14.666,-.708,-1.735),(-14.424,-.753,-1.978),(-15.953,-.58,-1.794),(-15.853,-.568,-2.001),(-15.72,-.493,-2.241),(-15.786,-.613,-2.133),(-15.741,-.613,-2.292),(-15.766,-.661,-2.264),(-15.817,-.803,-2.07),(-15.869,-.774,-1.949),(-15.176,1.486,-1.673),(-15.091,1.354,-2.237),(-14.999,1.203,-2.546),(-14.887,1.971,-1.424),(-14.811,1.681,-2.73),(-14.703,1.977,-2.801),(-15.169,-1.455,-.757),(-16.097,-.571,-.323),(-14.909,-.664,-3.176),(-14.848,-.344,-3.155),(-14.376,-.046,-3.373),(-14.033,-.254,-3.366),(-14.309,-1.018,-3.275),(-14.534,-.942,-3.322),(-14.903,-.903,-.161),(-14.855,-.882,-.561),(-13.864,-.359,-3.233),(-14.028,-.719,-3.213),(-13.886,.225,-3.402),(-13.942,-.806,-3.025),(-13.735,-.448,-3.043),(-14.161,-1.091,-3.152),(-14.067,-1.136,-2.981),(-13.964,-.846,-2.618),(-14.174,-.802,-2.254),(-13.708,-.499,-2.627),(-13.985,-.44,-2.205),(-14.254,-.361,-1.946),(-14.799,-.772,-1.414),(-14.86,-1.047,-1.415),(-14.951,-1.447,-1.35),(-15.085,-1.484,-.987),(-14.764,-.719,-.975),(-14.13,-.118,-1.91),(-14.283,-.041,-1.735),(-13.802,-.186,-2.177),(-13.817,.305,-1.913),(-14.316,-.068,-1.572),(-14.863,-.784,-.208),(-14.95,-.724,.067),(-15.006,-.813,.085),(-15.752,-.616,.2),(-15.554,-.679,.247),(-15.812,-.789,.225),(-15.632,-.842,.273),(-15.264,-.804,.215),(-15.185,-.718,.195),(-15.898,-.615,.038),(-15.338,-.932,.233),(-15.076,-.905,.105),(-13.224,.995,-1.578),(-13.196,.729,-1.353),(-13.613,.363,-1.433),(-13.591,.523,-1.623),(-13.112,1.297,-1.472),(-13.033,1.091,-1.203),(-13.205,.443,-1.05),(-13.586,.075,-1.094),(-13.941,.064,-1.385),(-13.963,.238,-1.563),(-13.224,1.074,-1.848),(-13.924,-.167,-1.055),(-15.255,-.332,.166),(-14.838,-.413,.111),(-15.071,-.192,.141),(-15.455,-.228,.11),(-14.375,-.316,.05),(-14.405,-.34,.029),(-14.535,-.441,.021),(-14.357,-.564,-.107),(-14.277,-.475,-.086),(-14.387,-.6,-.173),(-14.369,1.025,-.121),(-14.366,.737,.002),(-14.732,.421,.015),(-15.05,.284,-.008),(-14.083,-.543,-.242),(-14.112,-.541,-.319),(-12.977,1.086,-.721),(-13.02,.781,-.901),(-13.086,1.429,-.496),(-13.193,1.723,-.764),(-13.359,1.88,-.628),(-13.315,1.646,-.391),(-13.239,1.953,-.965),(-13.549,1.982,-.55),(-13.559,1.763,-.363),(-14.27,.412,-3.379),(-13.232,1.222,-3.136),(-14.232,1.753,-3.351),(-15.266,-.034,.067),(-15.982,-.487,-.07),(-15.139,-.876,-2.988),(-13.458,.702,-1.927),(-15.747,-1.094,-2.333),(-15.782,-1.093,-2.275),(-15.8,-.995,-2.229),(-15.736,-1.001,-2.356),(-15.717,-.841,-2.376),(-15.701,-.675,-2.398),(-15.796,-.829,-2.221),(-15.699,-.627,-2.372),(-13.906,-.331,-.657),(-13.851,-.434,-.437),(-13.603,-.172,-.685),(-16.128,-.74,-1.166),(-16.151,-.748,-1.336),(-16.125,-.761,-1.535),(-16.087,-.772,-1.677),(-15.785,-.997,-2.046),(-15.789,-1.099,-2.096),(-15.779,.076,-.389),(-14.375,1.29,-.24),(-15.589,.064,-.143),(-15.952,-.764,-1.8),(-14.881,-.902,-3.202),(-14.752,.123,-3.213),(-14.866,-1.121,-3.192),(-15.018,-.914,-3.111),(-15.027,-.783,-3.121),(-15.091,-.767,-3.041),(-15.053,-.996,-3.058),(-14.486,1.684,-.449),(-14.355,2.099,-.606),(-14.697,2.011,-.972),(-14.272,1.746,-.35),(-14.127,2.084,-.515),(-13.838,2.053,-.483),(-13.889,1.83,-.323),(-14.734,1.097,-2.96),(-14.871,.584,-2.924),(-14.654,.56,-3.212),(-16.12,-.895,-1.594),(-14.368,-.089,.049),(-14.264,-.204,.023),(-14.223,-.184,.083),(-13.408,.371,.416),(-13.542,.424,.436),(-13.567,.256,.497),(-13.379,.284,.445),(-13.884,.326,.433),(-13.938,.143,.433),(-13.801,.193,.497),(-13.795,.413,.444),(-14.198,-.053,.163),(-14.135,-.067,.222),(-14.114,-.268,.057),(-14.14,.102,.196),(-14.255,.001,.11),(-14.149,-.286,-.049),(-14.136,-.288,-.036),(-14.319,-.262,.009),(-14.366,.576,.021),(-14.205,.681,.087),(-13.666,-.405,-.389),(-13.863,-.459,-.3),(-13.868,-.457,-.334),(-14.061,-.42,-.164),(-14.084,-.442,-.194),(-14.04,-.387,-.162),(-14.189,-.337,-.055),(-13.336,.463,.329),(-13.163,.425,.096),(-13.358,.6,.202),(-13.092,.073,-.256),(-13.027,.244,-.092),(-13.121,.034,-.189),(-13.054,.137,-.027),(-13.356,-.196,-.352),(-13.352,-.182,-.362),(-13.947,1.449,-.216),(-13.787,1.463,-.212),(-14.366,.332,.078),(-13.531,.562,.349),(-14.031,.141,.343),(-14.007,.484,.286),(-13.768,.571,.353),(-14.167,.426,.164),(-14.021,-.055,.383),(-14.222,-.384,-.049),(-13.661,-.383,-.442),(-13.31,-.156,-.433),(-13.673,-.403,-.357),(-13.879,-.47,-.4),(-13.647,-.311,-.554),(-13.275,-.081,-.516),(-14.072,-.486,-.228),(-14.256,-.415,-.083),(-13.86,-.446,-.278),(-13.518,1.013,.032),(-13.53,.695,.237),(-13.342,.901,0),(-13.783,1.073,.042),(-13.746,.726,.244),(-13.137,.667,-.085),(-13.286,1.264,-.251),(-13.512,1.38,-.247),(-13.07,.165,-.357),(-13.033,.372,-.594),(-12.939,.732,-.481),(-13.005,.407,-.209),(-13.246,.071,-.694),(-13.056,1.033,-.347),(-13.274,.279,.355),(-13.15,.232,.188),(-14.03,-.384,-.151),(-13.985,.712,.221),(-13.977,1.087,.044),(-13.583,.098,.531),(-13.415,.151,.498),(-13.376,-.04,.492),(-13.274,.059,.427),(-14.07,-.221,.237),(-14.056,-.42,.07),(-14.002,-.446,-.122),(-13.663,-.414,-.321),(-13.339,-1.131,-.179),(-13.338,-1.074,-.18),(-13.078,-1.126,.041),(-13.599,-1.092,-.207),(-13.575,-1.145,-.215),(-13.733,-1.182,-.185),(-13.555,-.105,.518),(-13.569,-.244,.504),(-13.512,-.235,.505),(-13.955,-.869,.178),(-13.957,-.886,.076),(-13.949,-1.167,.141),(-13.992,-.193,.398),(-13.943,-.339,.402),(-13.93,-.171,.46),(-13.797,.035,.529),(-13.325,-.199,.462),(-13.166,-.152,.315),(-13.935,-.006,.467),(-14.03,-.391,.216),(-14,-.601,.04),(-13.994,-.553,.198),(-13.145,-.761,.37),(-13.085,-1.089,.373),(-13.027,-1.144,.267),(-13.11,-.789,.235),(-13.91,-1.169,-.068),(-13.929,-.91,-.058),(-13.759,-.929,-.193),(-13.882,-1.14,.326),(-13.904,-.821,.35),(-13.234,-.728,.474),(-13.181,-1.028,.457),(-13.406,-.696,.524),(-13.36,-.969,.536),(-13.585,-.715,.523),(-13.553,-1,.528),(-13.753,-.765,.46),(-13.719,-1.071,.468),(-13.283,-.387,.46),(-13.177,-.394,.338),(-13.457,-.383,.511),(-13.096,-.416,.143),(-13.062,-.156,.088),(-13.62,-.643,-.301),(-13.822,-.666,-.236),(-13.343,-.31,-.323),(-13.106,-.215,-.114),(-13.128,-.458,-.057),(-13.348,-.543,-.254),(-13.98,-.635,-.085),(-13.943,-.488,.367),(-13.764,-.415,.471),(-13.783,-.276,.485),(-13.572,-.383,.51),(-13.794,-.138,.511),(-13.122,-.814,.041),(-13.588,-.917,-.234),(-13.341,-.856,-.182),(-13.099,-2.069,.383),(-13.097,-2.068,.374),(-13.134,-1.743,.36),(-13.663,-2.122,.357),(-13.661,-2.121,.364),(-13.623,-1.801,.301),(-13.189,-2.077,.475),(-13.187,-2.15,.489),(-13.57,-2.105,.417),(-13.569,-2.194,.418),(-13.1,-1.458,.373),(-13.017,-1.48,.304),(-13.019,-1.409,.304),(-13.136,-2.23,.265),(-13.092,-2.109,.101),(-13.037,-2.073,.254),(-13.753,-1.796,.273),(-13.676,-2.123,.351),(-13.645,-1.788,.302),(-13.788,-1.529,.311),(-13.55,-1.189,-.221),(-13.521,-2.124,.003),(-13.53,-2.238,.156),(-13.667,-2.13,.092),(-13.648,-1.848,-.13),(-13.522,-1.868,-.142),(-13.183,-2.155,.478),(-13.114,-1.727,.36),(-13.083,-2.071,.369),(-13.232,-1.726,.426),(-13.57,-2.196,.404),(-13.565,-1.762,.382),(-13.177,-2.177,.473),(-13.367,-2.219,.494),(-13.368,-2.214,.503),(-13.364,-2.24,.489),(-13.374,-2.092,.487),(-13.57,-2.219,.397),(-13.406,-1.749,.422),(-13.231,-1.705,.438),(-13.41,-1.728,.434),(-13.575,-1.742,.39),(-13.866,-1.316,.327),(-13.943,-1.329,.143),(-13.892,-1.554,.118),(-13.896,-1.332,-.096),(-13.868,-1.537,-.112),(-13.829,-1.814,.123),(-13.635,-1.526,.392),(-13.699,-1.293,.444),(-13.059,-1.19,.356),(-13.02,-1.159,.273),(-12.969,-1.361,.213),(-13.062,-1.146,.042),(-13.127,-1.214,.426),(-13.71,-1.347,-.225),(-13.698,-1.556,-.208),(-13.551,-1.332,-.24),(-13.3,-1.248,.514),(-13.262,-1.489,.445),(-13.494,-1.267,.513),(-13.439,-1.518,.448),(-13.042,-1.733,.324),(-12.962,-1.502,.21),(-13.074,-2.071,.348),(-13.181,-2.228,.385),(-12.992,-1.757,.229),(-13.348,-2.289,.396),(-13.321,-2.276,.22),(-13.054,-1.824,-.001),(-13.711,-2.126,.235),(-13.577,-2.253,.325),(-13.31,-1.181,-.18),(-13.04,-1.325,-.023),(-13.271,-1.317,-.212),(-13.796,-1.833,-.034),(-13.275,-2.14,.036),(-13.246,-1.873,-.104),(-13.025,-1.548,-.026),(-13.232,-1.588,-.21),(-13.525,-1.573,-.234),(-15.939,-.823,.078),(-15.842,-.886,.228),(-16.017,-1.247,.184),(-16.258,-2.065,.258),(-16.337,-2.224,.16),(-16.246,-2.154,.288),(-16.293,-2.064,.129),(-16.312,-2.118,-.122),(-16.322,-2.169,-.195),(-16.336,-2.274,-.093),(-16.327,-2.294,-.227),(-15.966,-1.132,-.637),(-15.784,-1.223,-.633),(-15.98,-1.445,-.572),(-16.053,-1.095,-.561),(-16.082,-1.008,-.328),(-16.154,-2.015,.338),(-15.961,-1.98,.453),(-16.143,-1.917,.311),(-16.108,-2.09,-.416),(-16.119,-2.341,-.364),(-16.184,-2.021,-.347),(-15.655,-.943,.287),(-16.151,-2.126,.385),(-16.293,-2.048,-.147),(-16.269,-2.116,-.268),(-16.265,-1.993,.107),(-16.238,-2.329,-.316),(-16.067,-.572,-.162),(-15.96,-2.417,-.396),(-15.942,-2.214,-.428),(-15.668,-2.265,-.336),(-15.73,-2.427,-.31),(-15.879,-1.958,-.488),(-15.593,-2.067,-.377),(-15.569,-2.279,-.122),(-15.505,-2.234,-.112),(-15.72,-2.076,.448),(-15.966,-2.15,.475),(-15.733,-2.171,.433),(-15.506,-2.249,.059),(-15.456,-2.181,.076),(-15.495,-2.151,.279),(-15.538,-2.211,.27),(-15.16,-1.349,-.253),(-15.135,-1.255,-.109),(-15.376,-1.025,.246),(-15.502,-1.383,.354),(-15.291,-1.519,.204),(-15.207,-1.159,.105),(-15.803,-1.287,.353),(-15.628,-1.881,.428),(-15.432,-1.995,.279),(-15.218,-1.649,.015),(-15.174,-1.31,-.086),(-15.169,-1.111,.091),(-16.057,-.944,-.094),(-16.061,-.741,-.119),(-15.703,-1.663,-.536),(-15.542,-1.433,-.561),(-16.087,-1.359,-.489),(-15.302,-1.49,-.409),(-15.202,-1.403,-.221),(-15.27,-1.73,-.169),(-15.427,-1.75,-.407),(-16.089,-1.874,-.492),(-15.942,-1.771,.422),(-16.127,-1.693,.254),(-16.254,-1.898,.075),(-16.222,-1.666,.015),(-16.125,-1.245,-.072),(-16.253,-1.709,-.233),(-16.281,-1.931,-.17),(-16.149,-1.285,-.295),(-16.202,-1.765,-.413),(-15.426,-2.069,-.133),(-15.383,-2.04,.066),(-16.338,-2.367,-.163),(-16.343,-2.386,-.077),(-16.266,-2.286,.292),(-16.34,-2.376,.157),(-15.578,-2.453,-.123),(-16.205,-2.8,-.223),(-16.272,-2.491,-.24),(-16.062,-2.764,-.307),(-15.964,-2.782,-.333),(-15.97,-3.146,-.266),(-16.303,-2.568,-.084),(-16.273,-2.83,-.048),(-16.303,-2.537,.16),(-16.178,-2.397,.392),(-16.277,-2.782,.158),(-16.177,-2.715,.39),(-16.231,-3.166,-.026),(-16.146,-3.154,-.211),(-16.214,-3.117,.2),(-16.082,-3.32,-.197),(-16.181,-3.314,-.002),(-16.131,-3.061,.369),(-15.947,-3.031,.514),(-15.981,-2.665,.507),(-16.13,-3.202,.379),(-15.921,-3.178,.513),(-15.679,-2.597,.49),(-15.691,-2.988,.485),(-16.001,-2.373,.489),(-16.193,-3.249,.221),(-15.688,-3.135,.457),(-15.702,-3.295,-.206),(-15.906,-3.296,-.244),(-15.736,-3.148,-.227),(-15.592,-3.239,-.062),(-15.597,-3.089,-.072),(-15.534,-3.191,.115),(-15.506,-3.026,.106),(-15.52,-2.991,.293),(-15.566,-3.168,.292),(-15.735,-2.809,-.28),(-15.707,-2.363,.456),(-15.533,-2.378,.27),(-15.509,-2.394,.063),(-15.499,-2.611,.31),(-15.464,-2.649,.111),(-15.569,-2.727,-.104),(-15.632,-4.052,-.025),(-15.647,-4.068,-.029),(-15.825,-3.816,-.042),(-15.69,-4.026,.424),(-15.672,-4.015,.423),(-15.86,-3.752,.356),(-15.749,-4.052,.308),(-15.674,-4.136,.343),(-15.723,-4.086,.07),(-15.644,-4.168,.078),(-15.626,-4.061,-.04),(-15.827,-3.807,-.062),(-15.879,-3.699,-.127),(-15.865,-3.737,.377),(-15.667,-4.015,.438),(-15.921,-3.609,.436),(-15.434,-3.991,-.095),(-15.369,-3.955,-.001),(-15.408,-4.125,.048),(-16.032,-3.653,.133),(-16.105,-3.478,.016),(-16.013,-3.663,.046),(-15.387,-3.92,.411),(-15.397,-4.079,.327),(-15.324,-3.903,.312),(-15.627,-4.16,.078),(-15.922,-3.759,.057),(-15.659,-4.127,.343),(-15.934,-3.737,.263),(-15.64,-4.141,.349),(-15.648,-4.178,.218),(-15.665,-4.186,.218),(-15.63,-4.193,.22),(-15.761,-4.079,.197),(-15.608,-4.175,.076),(-15.946,-3.738,.154),(-15.937,-3.746,.046),(-15.964,-3.725,.152),(-15.949,-3.721,.272),(-16.116,-3.428,.24),(-15.981,-3.491,-.169),(-16.029,-3.619,.269),(-16.041,-3.389,.427),(-15.862,-3.315,.531),(-15.748,-3.585,.525),(-15.611,-3.279,.465),(-15.487,-3.558,.466),(-15.477,-3.282,.307),(-15.64,-3.426,-.212),(-15.817,-3.478,-.248),(-15.516,-3.372,-.069),(-15.517,-3.712,-.181),(-15.687,-3.725,-.209),(-15.46,-3.323,.122),(-15.408,-3.669,-.049),(-15.35,-3.605,.143),(-15.365,-3.576,.313),(-15.556,-4.056,-.104),(-15.537,-3.97,.459),(-15.528,-4.193,.038),(-15.52,-4.208,.218),(-15.534,-4.152,.351),(-15.327,-3.936,.163),(-15.396,-4.141,.203),(-15.677,-1.36,-.721),(-15.243,-1.951,-1.279),(-15.431,-1.998,-1.49),(-15.359,-1.882,-1.478),(-16.057,-1.176,-1.543),(-15.874,-1.633,-1.624),(-16.05,-1.563,-1.487),(-16.011,-2.739,-1.368),(-15.957,-2.831,-1.384),(-16.056,-2.852,-1.323),(-16.083,-2.709,-1.327),(-16.173,-2.658,-.859),(-16.162,-2.778,-.83),(-16.137,-2.644,-.755),(-16.103,-2.721,-.699),(-15.969,-1.209,-.834),(-15.304,-1.527,-.85),(-15.187,-1.696,-1.265),(-15.221,-1.647,-1.085),(-15.239,-1.699,-1.293),(-15.116,-1.609,-1.279),(-16.131,-.989,-1.518),(-16.134,-.868,-1.528),(-16.172,-1,-1.348),(-16.146,-.946,-1.199),(-16.167,-.867,-1.344),(-15.683,-2.274,-1.529),(-15.692,-2.41,-1.496),(-15.904,-2.334,-1.462),(-16.093,-.986,-1.061),(-16.093,-1.146,-1.111),(-15.866,-2.822,-1.399),(-15.99,-2.61,-1.378),(-15.741,-1.623,-.685),(-15.512,-1.72,-.726),(-15.235,-1.905,-1.071),(-15.521,-1.694,-1.611),(-15.904,-1.996,-1.522),(-16.061,-1.944,-1.42),(-16.146,-1.177,-1.334),(-16.129,-1.506,-1.277),(-16.166,-2.849,-1.087),(-16.194,-2.691,-1.116),(-16.163,-2.497,-.876),(-16.109,-2.523,-.724),(-16.165,-2.505,-1.126),(-16.053,-2.536,-1.324),(-15.975,-1.551,-.78),(-15.401,-2.684,-1.166),(-15.467,-2.782,-1.327),(-15.478,-2.433,-1.415),(-15.306,-2.469,-1.204),(-15.696,-2.674,-.551),(-15.607,-2.63,-.614),(-15.592,-2.328,-.628),(-15.773,-2.307,-.587),(-15.487,-2.628,-.751),(-15.409,-2.407,-.755),(-15.445,-2.664,-.948),(-15.318,-2.487,-.968),(-15.325,-1.539,-.86),(-15.189,-1.609,-1.061),(-15.322,-1.814,-.817),(-15.346,-2.057,-.782),(-15.246,-2.181,-1.027),(-15.537,-1.958,-.669),(-15.281,-2.211,-1.25),(-15.763,-1.893,-.625),(-15.67,-2.004,-1.589),(-15.472,-2.214,-1.45),(-15.684,-2.836,-1.396),(-16.051,-2.697,-.628),(-15.943,-2.685,-.568),(-16.061,-2.29,-.68),(-16.168,-2.286,-.911),(-16.036,-1.874,-.731),(-16.148,-1.887,-.946),(-16.191,-2.312,-1.151),(-16.099,-1.525,-1.02),(-16.172,-1.904,-1.205),(-16.079,-2.325,-1.363),(-15.934,-2.913,-1.352),(-15.988,-3.002,-1.285),(-16.075,-2.83,-.725),(-16.085,-2.91,-.801),(-15.745,-3.057,-1.329),(-15.63,-3.035,-1.329),(-15.6,-3.263,-1.253),(-15.837,-2.932,-.562),(-15.982,-2.883,-.634),(-15.966,-3.053,-.755),(-15.493,-3.094,-.473),(-15.33,-3.346,-.416),(-15.437,-3.075,-.471),(-15.901,-3.121,-1.249),(-15.867,-2.998,-1.329),(-16.078,-3.001,-1.048),(-15.537,-3.573,-1.094),(-15.43,-3.529,-1.169),(-15.289,-3.745,-1.095),(-15.358,-3.782,-1.019),(-15.638,-3.597,-.868),(-15.505,-3.795,-.81),(-15.637,-3.577,-.623),(-15.47,-3.788,-.564),(-15.257,-3.557,-.391),(-15.514,-3.444,-.459),(-15.395,-3.689,-.4),(-15.133,-3.246,-.543),(-15.05,-3.456,-.527),(-15.706,-3.188,-.515),(-15.087,-3.666,-1.099),(-15.192,-3.444,-1.169),(-15.337,-3.199,-1.244),(-15.026,-3.358,-1.029),(-14.959,-3.559,-.986),(-15.35,-2.831,-1.146),(-15.434,-2.969,-1.3),(-15.319,-2.833,-.904),(-15.146,-3.107,-1.095),(-15.145,-3.025,-.837),(-15.632,-2.87,-.504),(-15.529,-2.837,-.534),(-15.39,-2.776,-.692),(-15.237,-3.007,-.596),(-15.029,-3.299,-.771),(-14.989,-3.503,-.734),(-15.729,-3.339,-1.175),(-15.818,-3.297,-.705),(-15.82,-3.354,-.958),(-15.976,-3.135,-1.02),(-14.63,-4.271,-.884),(-14.633,-4.286,-.878),(-14.897,-4.154,-.845),(-14.722,-4.249,-.358),(-14.72,-4.236,-.355),(-14.981,-4.115,-.466),(-14.647,-4.336,-.798),(-14.586,-4.363,-.763),(-14.704,-4.297,-.427),(-14.653,-4.319,-.43),(-14.927,-4.013,-1),(-14.625,-4.254,-.904),(-14.911,-4.155,-.854),(-14.995,-4.117,-.465),(-14.727,-4.217,-.333),(-15.05,-4.004,-.358),(-14.468,-3.913,-.589),(-14.39,-4.111,-.753),(-14.447,-4.017,-.844),(-14.387,-4.15,-.601),(-14.432,-4.094,-.482),(-14.494,-3.944,-.426),(-14.575,-4.353,-.764),(-14.963,-4.15,-.767),(-14.641,-4.311,-.428),(-15.007,-4.129,-.562),(-14.55,-4.352,-.766),(-14.593,-4.384,-.611),(-14.604,-4.391,-.61),(-14.57,-4.388,-.608),(-14.688,-4.356,-.62),(-14.619,-4.31,-.415),(-15.011,-4.151,-.671),(-15.026,-4.131,-.567),(-15.032,-4.153,-.674),(-14.985,-4.151,-.772),(-15.065,-4.064,-.855),(-15.121,-4.073,-.524),(-15.135,-3.874,-1.041),(-15.221,-3.916,-.975),(-14.93,-3.794,-1.046),(-15.327,-3.958,-.751),(-15.149,-4.114,-.698),(-15.306,-3.927,-.522),(-15.233,-3.835,-.363),(-14.468,-4.262,-.765),(-14.491,-4.319,-.596),(-14.551,-4.244,-.436),(-14.632,-4.116,-.341),(-14.543,-4.143,-.915),(-15.043,-3.711,-.36),(-14.838,-3.616,-.474),(-14.768,-3.706,-.935),(-14.782,-3.614,-.682),(-14.593,-3.848,-.912),(-14.576,-3.765,-.629),(-14.627,-3.764,-.436),(-14.862,-3.857,-.324),(-14.711,-3.942,-1.009),(-15.37,-1.468,-2.605),(-15.4,-1.721,-2.514),(-15.428,-1.451,-2.582),(-15.529,-2.487,-2.3),(-15.649,-2.388,-2.194),(-15.423,-2.394,-2.353),(-15.392,-2.75,-2.249),(-15.545,-2.739,-2.219),(-15.611,-2.785,-2.146),(-15.647,-2.669,-2.185),(-15.725,-2.624,-1.686),(-15.724,-2.737,-1.74),(-15.704,-2.691,-1.64),(-15.636,-2.287,-1.637),(-15.704,-2.399,-1.653),(-15.617,-2.666,-1.531),(-15.767,-2.645,-1.787),(-15.755,-2.379,-1.804),(-15.748,-2.323,-1.823),(-15.738,-2.378,-2.025),(-15.077,-1.606,-2.433),(-14.773,-1.596,-1.952),(-15.168,-2.523,-1.523),(-15.351,-2.609,-1.452),(-15.157,-2.677,-1.478),(-14.965,-2.56,-1.989),(-14.885,-2.699,-1.946),(-15.008,-2.737,-2.125),(-15.769,-1.19,-2.263),(-15.732,-1.289,-2.059),(-15.074,-1.717,-1.787),(-14.969,-1.7,-1.796),(-15.62,-1.664,-2.442),(-15.632,-1.395,-2.454),(-15.736,-1.626,-2.242),(-15.746,-1.345,-2.298),(-15.639,-2.018,-2.31),(-15.42,-2.066,-2.442),(-15.74,-2.656,-2.005),(-15.703,-2.774,-1.961),(-15.743,-1.987,-2.133),(-15.629,-1.633,-1.768),(-15.509,-1.664,-1.683),(-15.733,-1.624,-1.988),(-15.623,-1.938,-1.69),(-15.482,-1.936,-1.613),(-15.288,-1.796,-1.65),(-15.089,-1.859,-1.732),(-14.95,-1.896,-1.904),(-14.967,-1.739,-1.945),(-15.23,-1.983,-1.605),(-15.03,-2.012,-1.673),(-14.941,-1.925,-2.156),(-14.858,-1.718,-1.934),(-14.928,-2.047,-1.847),(-15.073,-1.867,-2.373),(-14.922,-2.076,-2.102),(-14.868,-1.605,-1.785),(-15.24,-1.78,-2.507),(-15.209,-1.522,-2.558),(-15.094,-2.126,-2.321),(-15.013,-2.66,-1.558),(-15.047,-2.48,-1.615),(-14.92,-2.619,-1.74),(-14.967,-2.468,-1.777),(-14.994,-2.31,-1.603),(-15.198,-2.279,-1.549),(-15.46,-2.26,-1.553),(-14.931,-2.305,-1.789),(-14.947,-2.363,-2.031),(-15.091,-2.442,-2.217),(-15.747,-1.944,-1.891),(-15.275,-2.099,-2.436),(-15.272,-2.456,-2.353),(-15.313,-2.734,-2.278),(-15.148,-2.779,-2.261),(-15.668,-2.764,-1.643),(-15.351,-2.953,-1.428),(-15.571,-2.821,-1.547),(-15.512,-2.826,-2.18),(-15.64,-2.84,-1.707),(-15.543,-2.879,-2.09),(-14.873,-3.433,-1.873),(-14.889,-3.422,-1.878),(-14.746,-3.383,-1.979),(-14.898,-3.437,-1.83),(-14.988,-3.44,-1.656),(-15.025,-3.386,-1.453),(-15.007,-3.431,-1.662),(-14.96,-3.469,-1.646),(-14.935,-3.47,-1.418),(-14.947,-3.492,-1.642),(-14.913,-3.529,-1.63),(-15.093,-2.705,-1.454),(-14.852,-2.855,-2.076),(-15.552,-2.891,-1.637),(-15.366,-2.908,-2.169),(-15.17,-3.005,-2.158),(-15.42,-2.962,-2.041),(-15.51,-2.956,-1.854),(-15.593,-2.89,-1.89),(-15.388,-3.043,-1.569),(-15.278,-3.072,-2.005),(-15.369,-3.089,-1.784),(-15.084,-3.243,-1.931),(-14.943,-3.181,-2.059),(-14.639,-3.48,-1.928),(-14.771,-3.528,-1.851),(-15.229,-3.21,-1.51),(-15.2,-3.249,-1.718),(-14.739,-3.276,-1.269),(-14.859,-3.148,-1.293),(-14.97,-3.278,-1.32),(-14.878,-3.36,-1.287),(-14.739,-3.089,-1.334),(-14.614,-3.234,-1.31),(-15.035,-3.013,-1.347),(-15.135,-3.113,-1.361),(-14.522,-3.413,-1.903),(-14.621,-3.304,-1.959),(-14.818,-3.125,-2.065),(-14.523,-3.215,-1.878),(-14.423,-3.318,-1.842),(-14.918,-2.892,-1.389),(-14.799,-2.81,-1.486),(-15.237,-2.799,-1.399),(-14.609,-3.056,-1.437),(-14.726,-2.787,-1.654),(-14.671,-2.876,-1.86),(-14.671,-2.999,-1.978),(-14.491,-3.131,-1.777),(-15.007,-2.981,-2.172),(-14.507,-3.203,-1.414),(-14.438,-3.199,-1.557),(-14.516,-3.052,-1.577),(-14.408,-3.24,-1.738),(-14.083,-3.869,-1.576),(-14.089,-3.899,-1.577),(-14.298,-3.789,-1.629),(-14.202,-3.821,-1.072),(-14.198,-3.813,-1.077),(-14.403,-3.73,-1.208),(-14.145,-3.974,-1.487),(-14.04,-4.004,-1.447),(-14.122,-3.968,-1.159),(-14.221,-3.943,-1.207),(-14,-3.985,-1.448),(-14.066,-3.873,-1.586),(-14.037,-3.873,-1.604),(-14.406,-3.724,-1.192),(-14.194,-3.805,-1.062),(-14.461,-3.676,-1.165),(-13.964,-3.52,-1.465),(-14.076,-3.437,-1.371),(-13.957,-3.549,-1.346),(-14.072,-3.439,-1.563),(-14.083,-3.515,-1.229),(-14.143,-3.458,-1.228),(-13.841,-3.756,-1.449),(-13.887,-3.686,-1.55),(-14.098,-3.602,-1.108),(-13.951,-3.695,-1.145),(-14.032,-3.985,-1.441),(-14.375,-3.812,-1.592),(-14.28,-3.775,-1.651),(-14.112,-3.95,-1.155),(-14.506,-3.783,-1.341),(-14.066,-4.025,-1.298),(-14.073,-4.042,-1.306),(-14.038,-4.027,-1.291),(-14.2,-3.991,-1.353),(-14.087,-3.946,-1.123),(-14.47,-3.837,-1.483),(-14.514,-3.781,-1.325),(-14.378,-3.813,-1.605),(-14.478,-3.837,-1.486),(-14.3,-3.734,-1.742),(-13.954,-3.811,-1.604),(-13.892,-3.917,-1.452),(-14.745,-3.68,-1.562),(-14.62,-3.669,-1.753),(-14.752,-3.622,-1.355),(-14.431,-3.803,-1.647),(-14.17,-3.635,-1.762),(-14.375,-3.555,-1.118),(-14.156,-3.712,-1.057),(-14.544,-3.762,-1.322),(-13.899,-3.913,-1.28),(-14.514,-3.825,-1.499),(-13.991,-3.825,-1.11),(-14.698,-3.507,-1.232),(-14.561,-3.41,-1.217),(-14.352,-3.533,-1.858),(-14.473,-3.619,-1.847),(-14.449,-3.365,-1.258),(-14.338,-3.34,-1.338),(-14.264,-3.329,-1.464),(-14.23,-3.341,-1.68),(-14.261,-3.423,-1.788),(-13.855,-3.761,-1.298),(-14.268,-3.495,-1.144),(-14.097,-3.508,-1.689),(-15.035,-2.225,-2.779),(-15.015,-2.16,-2.651),(-15.028,-2.121,-2.773),(-15.064,-1.94,-2.686),(-14.985,-1.933,-2.569),(-14.751,-2.089,-3.156),(-14.834,-2.143,-3.133),(-14.835,-2.038,-3.129),(-14.689,-1.86,-3.235),(-14.637,-2.231,-3.144),(-14.618,-1.328,-3.245),(-14.294,-2.222,-2.874),(-14.437,-2.179,-3.08),(-14.353,-2.121,-2.909),(-14.553,-2.132,-2.423),(-14.76,-2.242,-2.431),(-14.516,-2.211,-2.415),(-14.33,-1.636,-2.965),(-14.364,-1.868,-2.961),(-14.356,-1.623,-3.065),(-15.027,-1.148,-3.054),(-15.013,-1.634,-2.584),(-14.798,-1.654,-2.485),(-15.09,-1.656,-2.818),(-15.054,-1.647,-2.687),(-15.054,-1.337,-3.035),(-15.058,-1.628,-3.013),(-15.08,-1.944,-2.782),(-15.03,-1.904,-2.984),(-14.987,-2.08,-2.967),(-14.805,-2.307,-3.099),(-14.956,-2.342,-2.938),(-14.97,-2.208,-2.975),(-15.029,-2.352,-2.749),(-14.982,-2.296,-2.598),(-14.913,-2.299,-2.513),(-14.864,-1.871,-3.159),(-14.873,-1.579,-3.178),(-14.682,-1.593,-3.254),(-14.873,-1.308,-3.196),(-14.476,-1.604,-3.199),(-14.482,-1.881,-3.152),(-14.339,-2.074,-2.763),(-14.315,-2.19,-2.741),(-14.302,-1.862,-2.75),(-14.385,-2.092,-2.59),(-14.342,-2.196,-2.582),(-14.589,-1.896,-2.429),(-14.822,-1.898,-2.485),(-14.391,-2.212,-2.5),(-14.41,-2.096,-2.502),(-14.401,-1.885,-2.476),(-14.337,-1.877,-2.561),(-14.29,-1.644,-2.772),(-14.379,-1.657,-2.597),(-14.465,-1.661,-2.524),(-14.627,-1.658,-2.49),(-14.701,-2.376,-3.093),(-14.971,-2.445,-2.638),(-14.745,-2.436,-3.037),(-14.468,-2.565,-3.001),(-14.966,-2.477,-2.725),(-14.875,-2.467,-2.893),(-14.356,-2.765,-2.915),(-14.285,-2.531,-2.954),(-14.172,-2.747,-2.869),(-14.503,-2.813,-2.874),(-14.635,-2.602,-2.936),(-14.109,-2.702,-2.732),(-14.186,-2.445,-2.817),(-14.012,-2.986,-2.79),(-14.178,-3.013,-2.815),(-14.636,-2.882,-2.623),(-14.619,-2.844,-2.459),(-14.77,-2.578,-2.506),(-14.834,-2.633,-2.673),(-14.475,-3.091,-2.518),(-14.442,-3.044,-2.334),(-14.496,-2.729,-2.32),(-14.621,-2.505,-2.369),(-14.587,-2.836,-2.775),(-14.747,-2.617,-2.821),(-14.328,-3.042,-2.766),(-14.427,-3.078,-2.651),(-13.898,-2.952,-2.659),(-14.07,-2.651,-2.581),(-13.855,-2.864,-2.486),(-14.321,-2.912,-2.213),(-14.111,-2.82,-2.153),(-14.306,-2.64,-2.273),(-14.18,-2.366,-2.676),(-14.093,-2.605,-2.446),(-13.892,-2.808,-2.348),(-13.979,-2.802,-2.243),(-14.143,-2.614,-2.356),(-14.438,-2.418,-2.344),(-14.253,-2.372,-2.42),(-14.191,-2.354,-2.525),(-14.116,-3.293,-2.513),(-14.004,-3.306,-2.548),(-13.885,-3.46,-2.465),(-13.813,-3.439,-2.486),(-14.018,-3.493,-2.192),(-14.162,-3.295,-2.284),(-14.167,-3.301,-2.424),(-14.001,-3.47,-2.11),(-13.804,-3.426,-2.482),(-13.982,-3.441,-2.099),(-13.812,-3.568,-2.38),(-13.957,-3.575,-2.156),(-13.989,-3.291,-2.567),(-14.111,-3.281,-2.526),(-14.178,-3.289,-2.415),(-14.172,-3.28,-2.257),(-13.712,-3.152,-2.511),(-13.645,-3.357,-2.338),(-13.67,-3.397,-2.388),(-13.645,-3.315,-2.274),(-13.64,-3.452,-2.239),(-13.698,-3.538,-2.321),(-13.725,-3.414,-2.475),(-13.77,-3.549,-2.369),(-13.79,-3.415,-2.497),(-13.909,-3.258,-2.615),(-13.976,-3.427,-2.066),(-14.191,-3.24,-2.194),(-13.771,-3.404,-2.042),(-13.761,-3.251,-2.078),(-13.831,-3.274,-2.027),(-13.966,-3.513,-2.339),(-14.152,-3.295,-2.48),(-13.8,-3.542,-2.371),(-13.942,-3.549,-2.144),(-13.863,-3.588,-2.253),(-13.878,-3.613,-2.266),(-13.844,-3.598,-2.236),(-13.922,-3.556,-2.121),(-14.159,-3.29,-2.484),(-13.694,-3.093,-2.361),(-13.799,-3.225,-2.602),(-13.702,-3.471,-2.117),(-13.777,-3.569,-2.163),(-14.103,-3.142,-2.085),(-13.945,-3.049,-2.052),(-13.82,-3.034,-2.136),(-13.721,-3.04,-2.224),(-13.935,-3.359,-2.03),(-13.856,-3.503,-2.054),(-13.676,-3.256,-2.168),(4.895,18.846,4.025),(4.877,18.899,4.032),(4.851,18.805,4.044),(4.749,18.937,4.085),(4.703,18.887,4.104),(4.743,18.783,4.086),(4.704,18.827,4.104),(4.821,18.947,4.055),(4.626,25.056,-.085),(4.574,18.478,4.053),(4.582,17.896,3.848),(4.973,18.563,3.877),(6.469,18.311,.531),(6.526,18.467,.805),(5.088,19.029,3.834),(5.497,19.169,3.551),(5.165,19.581,3.656),(4.809,20.003,3.74),(4.843,19.548,3.864),(4.878,21.091,3.163),(5.603,20.344,3.242),(6.165,18.714,2.082),(6.251,18.985,1.898),(6.238,19.052,2.453),(6.507,18.585,.944),(6.439,18.408,1.069),(5.642,18.85,3.411),(5.18,18.756,3.795),(5.575,18.358,3.141),(6.265,18.328,1.627),(6.184,18.443,1.812),(6.587,18.359,-1.357),(6.714,19.231,-1.6),(6.639,19.231,-1.366),(6.608,18.719,.263),(6.613,18.838,.563),(6.412,18.483,1.259),(6.478,18.7,1.091),(6.431,18.765,1.256),(5.036,22.231,2.393),(5.63,21.409,2.652),(6.568,19.12,.782),(7.113,18.123,-2.156),(7.504,18.032,-3.024),(7.614,18.467,-2.986),(6.402,24.736,-.279),(6.178,24.689,-.276),(6.233,24.599,-.204),(6.184,24.988,-.508),(6.364,25.028,-.523),(6.312,25.282,-.812),(6.186,24.812,-.346),(6.619,24.314,.033),(6.473,24.507,-.104),(6.357,24.451,-.086),(8.097,25.272,-1.256),(8.11,25.347,-1.365),(7.376,25.546,-1.311),(7.384,23.924,.146),(7.531,23.962,.076),(7.164,24.242,.021),(5.176,25.449,-1.076),(4.876,25.429,-.935),(5.18,25.296,-.718),(5.914,25.399,-1.021),(5.915,25.265,-.787),(5.172,25.662,-1.474),(5.937,25.564,-1.353),(5.938,25.632,-1.493),(4.978,24.678,.061),(4.91,24.365,.425),(5.219,24.364,.244),(5.403,24.158,.463),(5.916,24.854,-.382),(5.4,24.689,-.189),(5.94,24.643,-.25),(6.551,23.937,.359),(6.14,23.556,.842),(6.923,23.595,.545),(5.772,24.157,.245),(6.302,24.24,.107),(6.191,24.359,.001),(5.786,20.036,3.203),(6.332,20.718,2.557),(7.09,21.282,-.135),(7.108,21.329,.13),(7.023,21.285,.141),(7.172,21.31,-.155),(7.162,21.198,-.323),(6.897,21.215,-.156),(6.837,21.099,-.469),(6.981,21.211,-.292),(6.704,20.476,-1.765),(6.577,19.362,-1.034),(6.624,19.714,-.834),(6.605,20.221,-.37),(6.522,18.597,-.077),(6.54,18.478,-.258),(6.864,21.473,1.495),(6.571,20.536,2.346),(7.112,22.392,.641),(6.955,22.291,1.02),(7.163,22.133,.591),(6.706,22.822,1.111),(7.052,22.654,.686),(7.056,23.008,.655),(6.918,20.958,.859),(6.775,20.859,.571),(6.988,21.194,.396),(6.642,20.628,.174),(6.436,19.491,1.125),(6.484,19.298,.942),(5.212,23.291,1.341),(5.95,22.548,1.756),(6.431,23.184,.976),(7.541,24.992,-4.425),(8.108,24.428,-4.565),(7.265,24.77,-4.7),(7.908,25.245,-3.925),(7.808,25.495,-3.478),(8.203,25.326,-3.547),(6.874,25.671,-3.945),(6.406,25.956,-3.776),(6.897,25.828,-3.512),(7.212,18.991,-2.242),(7.607,18.881,-2.959),(7.556,19.259,-2.938),(7.052,20.563,-4.199),(7.02,20.16,-4.521),(6.961,20.708,-4.441),(5.519,21.398,-5.63),(5.973,21.726,-5.5),(5.593,21.299,-5.598),(5.392,25.868,-2.591),(5.863,26.007,-3.035),(5.416,26.165,-3.009),(4.707,18.97,4.055),(4.638,18.895,4.083),(4.698,18.738,4.056),(4.861,18.772,3.99),(4.928,18.833,3.964),(4.901,18.914,3.975),(4.591,18.515,4.073),(4.972,18.596,3.914),(4.425,18.709,4.157),(4.379,18.697,4.147),(5.159,18.769,3.834),(4.636,18.607,4.08),(4.937,18.671,3.958),(5.078,19.012,3.866),(5.073,18.798,3.896),(4.857,19.221,3.926),(4.863,19.19,3.953),(5.016,18.971,3.921),(4.563,19.18,4.057),(4.589,19.152,4.074),(4.852,19.108,3.987),(4.374,18.974,4.148),(4.417,18.961,4.157),(4.642,19.079,4.077),(4.51,18.934,4.137),(4.513,18.747,4.138),(4.816,18.986,4.009),(4.64,18.804,4.082),(4.753,22.718,-5.858),(6.592,18.334,-.466),(6.079,19.644,2.984),(6.199,19.368,2.765),(6.047,18.613,-4.947),(6.728,18.359,-4.591),(7.307,18.172,-4.054),(7.463,18.08,-3.553),(6.314,18.877,1.532),(6.049,19.815,-5.201),(5.504,19.435,-5.322),(7.621,18.941,-3.423),(7.606,18.522,-3.483),(7.481,18.626,-3.967),(7.541,19.045,-3.871),(5.277,21.826,-5.792),(4.965,22.279,-5.896),(7.014,18.786,-4.51),(7.253,19.194,-4.421),(6.282,19.63,-5.046),(5.814,19.268,-5.147),(6.483,19.694,1.378),(5.155,23.07,-5.703),(6.428,19.005,-4.879),(5.93,25.504,-1.24),(6.356,25.44,-1.054),(6.405,25.544,-1.241),(6.717,25.546,-1.222),(6.762,25.59,-1.322),(6.441,25.592,-1.332),(7.231,25.513,-1.18),(6.492,25.654,-1.47),(6.807,25.646,-1.473),(6.662,25.462,-1.05),(6.928,25.735,-1.842),(6.598,25.752,-1.814),(6.031,25.735,-1.811),(7.333,25.63,-1.505),(7.411,25.708,-1.872),(6.631,25.043,-.529),(6.66,24.768,-.285),(6.617,25.317,-.823),(6.723,24.521,-.1),(7.095,24.727,-.269),(7.105,25.008,-.491),(5.945,25.01,-.51),(6.047,24.481,-.117),(6.957,24.007,.225),(6.891,24.304,.024),(7.183,23.976,.181),(7.276,23.493,.395),(7.436,23.415,.317),(7.104,24.449,-.086),(7.151,25.284,-.789),(7.191,25.441,-1.016),(7.071,23.266,.599),(7.307,23.115,.445),(7.431,23.048,.366),(7.602,23.363,.247),(8.89,24.546,-1.148),(8.924,24.591,-1.281),(8.037,25.247,-1.14),(8.97,24.722,-1.444),(7.976,25.198,-.972),(8.841,24.499,-.953),(8.081,25.456,-1.574),(8.991,24.852,-1.666),(9.018,24.946,-2.008),(8.106,25.542,-1.93),(7.782,24.779,-.432),(7.703,24.463,-.209),(8.276,23.761,-.144),(8.507,24.059,-.372),(7.601,24.149,-.031),(8.005,23.473,.045),(7.89,25.06,-.736),(8.723,24.349,-.697),(7.793,23.359,.161),(7.59,22.978,.292),(7.232,21.306,-.072),(7.199,21.35,.013),(7.208,21.27,-.211),(7.244,21.247,-.127),(7.223,21.205,-.273),(7.256,21.328,.039),(7.259,21.269,-.019),(7.198,21.143,-.398),(7.228,21.076,-.466),(6.959,20.917,-2.037),(6.887,20.806,-1.957),(6.937,20.657,-2.208),(7.012,20.787,-2.323),(7.248,21.683,.366),(7.232,21.792,.506),(7.267,21.581,.423),(7.279,21.495,.287),(7.23,22.533,.523),(7.189,22.241,.484),(7.105,21.13,-.533),(7.162,21.057,-.653),(6.988,21.02,-1.516),(7.083,21.061,-.991),(7.011,21.106,-.854),(6.908,20.986,-1.389),(7.2,21.993,.433),(7.047,20.806,-2.326),(7.008,20.923,-2.029),(7.03,21,-1.551),(7.122,21.008,-1.056),(7.202,20.992,-.721),(7.273,21.419,.219),(7.243,21.6,.301),(7.274,21.41,.19),(7.269,21.346,.118),(7.213,21.891,.361),(7.281,22.157,.404),(7.334,22.47,.442),(7.272,22.9,.497),(7.396,22.84,.415),(7.229,21.373,.145),(7.263,21.469,.309),(5.231,25.726,-1.803),(5.323,25.024,-.402),(5.607,24.388,.014),(6.666,20.238,2.039),(6.623,19.916,1.706),(7.114,21.323,.356),(6.845,20.215,-1.944),(6.686,20.828,-1.027),(6.952,21.199,1.204),(7.146,21.842,.826),(7.186,21.55,.701),(7.177,21.331,.487),(6.538,21.866,1.746),(7.555,22.759,.338),(6.779,25.822,-2.465),(6.292,25.852,-2.542),(7.11,25.781,-2.467),(6.071,24.188,-5.136),(5.857,24.14,-5.201),(6.086,24.78,-4.865),(6.375,24.792,-4.815),(5.916,23.539,-5.374),(5.668,23.416,-5.456),(6.981,25.816,-2.943),(6.594,25.906,-2.946),(6.754,25.259,-4.471),(6.467,25.314,-4.496),(7.152,25.55,-3.921),(7.207,25.704,-3.459),(7.061,25.189,-4.431),(6.751,24.831,-4.764),(6.282,24.234,-5.104),(7.416,25.436,-3.919),(7.288,25.743,-2.969),(7.679,25.657,-3.004),(7.56,25.725,-2.5),(7.451,25.615,-3.453),(6.235,23.682,-5.35),(6.575,24.209,-5.105),(6.429,23.687,-5.357),(6.024,23.021,-5.494),(6.293,23.127,-5.505),(5.797,22.867,-5.564),(8.697,24.618,-4.04),(8.238,25.461,-3.078),(7.378,24.068,-5.045),(6.82,23.651,-5.366),(6.743,23.137,-5.5),(6.504,23.166,-5.506),(8.197,25.544,-2.568),(9.056,24.955,-2.684),(9.037,24.883,-3.151),(8.915,24.747,-3.659),(6.915,21.051,-4.545),(6.886,20.86,-4.578),(6.817,21.062,-4.728),(6.854,21.277,-4.69),(6.942,21.113,-4.541),(6.891,21.33,-4.676),(7.01,20.947,-4.401),(6.977,20.897,-4.402),(6.773,21.777,-4.977),(6.794,21.861,-4.967),(6.743,21.427,-4.977),(6.616,21.877,-5.208),(6.685,22.168,-5.228),(6.755,22.221,-5.229),(6.565,22.442,-5.407),(6.676,22.547,-5.438),(6.388,22.22,-5.405),(6.068,22.51,-5.538),(6.286,22.683,-5.5),(7.108,20.62,-2.539),(7.114,20.418,-2.509),(7.304,20.177,-2.795),(7.266,20.341,-2.806),(6.532,22.792,-5.535),(7.069,20.734,-4.165),(7.095,20.785,-4.156),(7.218,20.468,-3.776),(7.255,20.404,-3.806),(7.341,20.205,-3.454),(7.265,20.273,-3.432),(7.27,20.248,-3.848),(7.256,20.248,-3.106),(7.34,20.192,-3.11),(7.226,20.395,-2.818),(7.4,20.052,-3.121),(7.395,20.06,-3.49),(7.123,20.655,-2.553),(5.588,24.01,-5.342),(5.667,24.684,-5.058),(5.254,24.044,-5.46),(5.331,24.808,-5.081),(5.96,25.373,-4.648),(5.582,25.574,-4.654),(5.645,26.111,-3.809),(5.421,22.599,-5.746),(6.782,20.374,-4.71),(6.67,20.575,-4.852),(6.399,20.197,-5.019),(6.571,20.001,-4.871),(6.554,20.909,-5.087),(7.112,19.899,-2.342),(7.487,19.618,-2.913),(7.583,19.287,-3.384),(7.53,19.376,-3.828),(7.524,19.617,-3.352),(7.49,19.683,-3.775),(7.299,19.559,-4.324),(6.804,19.373,-4.804),(6.938,19.776,-4.658),(7.303,19.894,-4.227),(6.219,20.491,-5.249),(5.931,20.966,-5.454),(6.35,21.389,-5.302),(5.725,22.193,-5.665),(7.796,14.892,-4.789),(7.32,16.092,-4.667),(7.517,16.148,-4.78),(7.122,16.034,-4.556),(7.144,16.289,-4.637),(8.105,16.178,-4.962),(7.807,16.161,-4.884),(7.842,16.441,-4.944),(9.522,17.137,-4.343),(9.644,17.715,-3.991),(9.787,17.041,-4.096),(9.688,14.095,-4.471),(9.443,13.996,-4.676),(9.587,15.003,-4.517),(9.752,13.631,-4.462),(9.8,14.138,-4.341),(9.255,13.928,-4.818),(8.89,13.841,-4.947),(9.022,15.074,-5.02),(9.141,13.391,-4.891),(10.413,14.386,-3.155),(10.554,13.627,-2.821),(10.527,13.616,-3.073),(9.623,12.808,-4.414),(9.697,12.777,-4.374),(9.561,12.74,-4.442),(9.725,12.511,-4.363),(9.562,12.481,-4.445),(9.858,12.898,-4.321),(9.736,13.088,-4.421),(9.33,12.754,-4.613),(9.401,12.98,-4.613),(10.51,12.677,-1.78),(10.63,11.968,-1.664),(10.565,12.764,-1.899),(10.432,12.559,-1.648),(10.356,12.47,-1.584),(10.467,11.849,-1.554),(9.992,13.405,-4.219),(10.113,13.354,-4.041),(10.271,12.767,-3.935),(9.62,13.145,-4.507),(9.484,13.097,-4.58),(10.281,14.384,-2.422),(10.446,13.53,-2.116),(10.457,13.562,-2.221),(10.469,13.586,-2.326),(10.511,13.61,-2.499),(10.332,14.392,-2.647),(7.767,13.856,-1.371),(8.081,12.877,-1.298),(8.226,12.904,-1.203),(8.281,12.897,-1.136),(8.348,12.884,-1.083),(7.887,13.878,-1.18),(8.013,13.754,-4.73),(8.345,12.838,-4.778),(8.149,12.786,-4.667),(10.083,15.036,-1.898),(10.138,15.024,-2.202),(10.024,16.016,-2.149),(7.43,14.949,-1.014),(7.341,14.936,-1.315),(7.981,19.254,-.613),(7.521,19.682,-.486),(7.603,19.453,-.511),(6.669,19.658,-.898),(6.648,19.678,-.971),(6.649,19.107,-1.147),(9.885,17.682,-3.243),(9.888,17.689,-3.403),(9.935,17.958,-3.379),(8.315,19.919,-4.953),(8.985,19.481,-4.607),(8.239,19.683,-4.915),(7.328,19.73,-4.905),(8.046,19.224,-4.825),(8.01,18.979,-4.856),(6.741,19.281,-4.906),(6.421,19.291,-4.641),(6.685,19.549,-4.929),(9.919,17.834,-2.594),(9.701,18.199,-2.082),(9.744,18.031,-2.064),(6.473,17.878,-2.562),(6.419,17.889,-3.096),(6.416,16.947,-2.858),(6.566,17.923,-1.676),(6.528,17.882,-2.05),(6.534,16.936,-1.889),(6.649,17.965,-1.258),(6.612,17.952,-1.333),(6.776,16.952,-1.382),(7.704,18.965,-.479),(7.522,19.012,-.41),(7.777,17.882,-.338),(7.995,19.343,-.617),(8.578,18.961,-.906),(8.061,18.874,-.613),(7.676,19.187,-.503),(7.27,21.912,-5.278),(7.515,22.028,-5.222),(7.665,21.463,-5.17),(7.722,22.151,.257),(7.63,21.818,.235),(7.718,21.726,.191),(7.609,21.291,.116),(7.343,20.871,.022),(7.468,20.755,-.014),(7.075,20.755,-.526),(7.227,21.028,-.422),(7.132,20.73,-.602),(9.6,20.872,-1.426),(9.576,21.203,-1.414),(9.505,21.22,-1.328),(9.356,20.592,-1.116),(9.27,20.889,-.979),(8.821,20.832,-.542),(6.676,19.358,-2.543),(6.939,19.885,-2.37),(6.939,19.919,-2.574),(6.835,20.338,-.689),(6.822,20.403,-.601),(6.666,19.968,-.799),(6.676,19.952,-.746),(6.51,18.999,-3.166),(6.902,19.845,-2.977),(6.916,19.843,-3.249),(6.644,19.11,-3.731),(6.919,19.831,-3.563),(6.913,19.803,-3.865),(6.851,19.772,-4.147),(6.72,19.799,-4.395),(6.613,19.178,-4.253),(8.301,20.371,-5.002),(7.936,20.905,-5.107),(8.347,20.98,-4.963),(7.985,20.213,-5.074),(9.815,20.764,-1.807),(9.718,20.804,-1.591),(9.801,20.429,-1.711),(9.516,20.856,-1.281),(9.629,20.558,-1.435),(9.555,19.856,-1.423),(7.097,20.718,-4.192),(7.093,20.6,-4.202),(7.1,20.455,-3.846),(9.215,24.249,-3.784),(9.43,23.674,-3.91),(9.104,24.184,-3.975),(9.447,24.439,-2.858),(9.75,23.839,-3.028),(9.435,24.392,-3.093),(7.012,20.966,-4.422),(9.4,16.13,-4.717),(9.283,17.16,-4.654),(9.677,16.104,-4.363),(8.784,16.222,-5.091),(8.391,17.208,-5.124),(9.996,16.087,-4.071),(9.835,15.012,-4.183),(10.023,17.022,-2.674),(10.079,16.018,-2.614),(10.155,16.034,-2.897),(10.037,17.008,-3.019),(9.939,17.013,-2.058),(10.199,15.014,-2.502),(10.242,15.005,-2.778),(10.237,16.049,-3.281),(10.04,16.997,-3.374),(9.942,17.645,-2.614),(9.912,17.547,-3.201),(7.394,16.422,-4.816),(6.325,17.015,-4.368),(7.148,17.156,-4.899),(9.779,16.99,-1.54),(9.862,16.011,-1.554),(9.81,17.784,-2.042),(9.246,17.051,-.827),(9.454,16.071,-.883),(9.967,15.048,-1.479),(10.331,14.985,-3.232),(9.891,17.568,-3.405),(10.136,15.028,-3.877),(8.33,14.966,-4.98),(6.585,15.862,-4.209),(7.328,14.771,-4.454),(6.312,15.83,-3.84),(6.314,16.977,-3.983),(6.905,14.666,-4.103),(6.6,14.602,-3.766),(6.352,16.929,-3.515),(6.334,15.812,-3.412),(6.413,15.824,-2.732),(6.495,14.573,-3.297),(6.593,14.583,-2.739),(6.675,15.87,-1.834),(6.929,14.78,-1.826),(6.959,15.985,-1.38),(6.988,15.994,-1.208),(7.129,16.047,-.849),(6.947,16.987,-.835),(6.806,16.95,-1.188),(7.625,16.031,-.487),(7.392,16.971,-.412),(7.904,14.975,-.597),(8.407,15.999,-.433),(8.08,17.007,-.314),(8.715,15.001,-.619),(8.676,17.035,-.526),(9.011,16.052,-.617),(9.617,15.092,-.97),(9.249,15.044,-.741),(7.297,14.922,-1.439),(8.529,13.808,-4.936),(10.751,12.89,-2.611),(10.69,12.934,-2.966),(10.675,12.874,-2.249),(10.932,12.256,-2.523),(10.89,12.3,-2.986),(10.555,12.905,-3.387),(10.385,13.541,-3.538),(10.67,11.548,-1.524),(10.746,11.587,-1.572),(10.698,12.031,-1.74),(10.56,11.503,-1.506),(10.766,12.082,-1.841),(10.851,11.643,-1.651),(10.598,12.799,-1.978),(10.016,12.181,-4.38),(9.73,12.097,-4.455),(9.95,12.593,-4.291),(10.05,11.814,-4.539),(9.742,11.733,-4.617),(9.54,12.081,-4.55),(10.142,12.697,-4.126),(10.231,12.244,-4.208),(10.306,11.839,-4.353),(9.547,11.72,-4.715),(9.29,12.121,-4.772),(9.313,12.475,-4.641),(9.97,13.189,-4.234),(10.488,11.829,-4.128),(10.384,12.269,-4.005),(10.614,12.288,-3.65),(10.453,12.86,-3.607),(9.318,11.767,-4.929),(9.101,12.167,-4.94),(9.146,11.797,-5.073),(9.09,12.498,-4.843),(8.947,12.173,-4.998),(8.896,12.483,-4.897),(9.106,12.906,-4.836),(9.018,11.806,-5.133),(8.743,12.141,-4.985),(8.665,12.434,-4.869),(8.851,12.929,-4.894),(10.268,13.479,-3.757),(10.735,12.302,-3.418),(10.034,14.24,-3.99),(10.259,14.326,-3.745),(10.873,11.863,-3.466),(10.75,11.82,-3.714),(11.022,11.905,-3.018),(10.844,12.18,-2.074),(11.051,11.868,-2.459),(8.518,12.093,-4.95),(8.566,11.736,-5.057),(8.386,11.661,-4.959),(8.35,12.019,-4.861),(8.002,11.235,-4.38),(7.917,11.64,-4.304),(8.172,11.866,-4.643),(8.242,11.513,-4.722),(8.08,12.201,-4.51),(8.27,12.321,-4.746),(8.815,11.781,-5.113),(8.445,12.386,-4.839),(7.628,11.2,-2.613),(8.06,11.295,-1.736),(7.87,11.961,-1.638),(7.454,11.822,-2.554),(7.755,10.705,-2.643),(8.164,10.803,-1.828),(8.509,11.386,-1.281),(8.345,12.053,-1.238),(7.661,12.767,-1.67),(7.23,12.595,-2.596),(7.313,11.814,-3.304),(7.476,11.182,-3.392),(7.629,10.71,-3.407),(8.599,10.935,-1.24),(8.675,11.398,-1.16),(8.475,12.077,-1.183),(6.918,13.503,-2.612),(7.331,13.689,-1.789),(7.114,12.529,-3.302),(7.701,10.801,-3.787),(7.56,11.33,-3.781),(7.446,11.89,-3.705),(7.279,12.556,-3.708),(7.811,12.051,-4.18),(6.815,13.469,-3.268),(8.744,11.027,-1.097),(8.539,12.074,-1.137),(8.699,11.391,-1.134),(9.531,11.47,-1.312),(8.991,11.405,-1.123),(9.098,10.953,-1.035),(9.662,11.041,-1.197),(9.95,11.583,-1.373),(10.087,11.169,-1.226),(8.813,12.062,-1.132),(9.36,12.135,-1.326),(8.771,11.384,-1.114),(8.845,10.958,-1.07),(8.77,11.024,-1.074),(8.604,12.055,-1.117),(8.578,12.882,-1.009),(9.793,12.21,-1.389),(10.179,11.683,-1.469),(10.037,12.3,-1.481),(9.598,13.055,-1.192),(9.162,12.972,-1.114),(8.238,13.917,-.811),(8.97,14.009,-.874),(10.312,11.283,-1.302),(9.905,13.149,-1.323),(9.426,14.087,-.969),(10.389,13.44,-1.902),(10.331,13.369,-1.709),(10.222,13.284,-1.54),(9.745,14.168,-1.13),(10.042,14.271,-1.512),(7.646,12.618,-4.124),(7.912,12.701,-4.426),(7.549,13.617,-4.28),(8.569,12.88,-4.836),(6.968,13.496,-3.683),(7.34,13.554,-4.066),(10.95,11.737,-1.93),(10.63,12.826,-2.056),(10.226,14.387,-2.131),(10.164,14.336,-1.828),(9.048,17.964,-4.563),(9.573,17.874,-1.534),(8.172,18.19,-4.972),(6.358,18.06,-4.514),(6.351,17.972,-4.124),(6.377,17.918,-3.637),(6.807,17.959,-.798),(6.671,17.957,-1.082),(7.152,17.933,-.422),(8.982,17.918,-.847),(8.374,17.903,-.57),(6.877,18.158,-4.943),(7.258,19.906,-.415),(7.297,19.67,-.457),(7.429,19.312,-.45),(6.943,19.539,-.58),(6.958,19.072,-.565),(6.693,19.618,-.71),(6.709,19.083,-.74),(6.67,19.074,-.965),(6.666,19.642,-.841),(6.511,19.021,-2.431),(6.475,19.007,-2.793),(6.592,19.047,-1.555),(6.538,19.045,-2.083),(6.627,19.076,-1.301),(8.122,19.418,-4.859),(7.502,19.856,-4.976),(7.731,20.023,-5.043),(9.63,20.039,-4.089),(9.684,19.155,-4.035),(9.067,20.209,-4.647),(10.005,19.929,-3.353),(10.054,19.046,-3.371),(10.068,20.131,-2.369),(10.121,19.338,-2.425),(7.581,19.725,-.456),(8.047,19.593,-.527),(7.638,19.895,-.353),(9.442,18.277,-1.577),(9.362,18.5,-1.6),(8.685,18.674,-.912),(9.399,18.746,-1.526),(8.639,19.149,-.872),(9.621,17.872,-3.938),(9.604,18.109,-3.901),(8.868,18.635,-4.414),(8.928,18.38,-4.473),(9.64,18.473,-3.977),(9.997,18.34,-3.363),(9.865,19.66,-1.821),(9.453,19.233,-1.458),(9.838,18.935,-1.917),(8.976,18.969,-4.474),(10.062,18.565,-2.471),(10.005,18.157,-2.529),(9.756,18.481,-1.998),(8.735,19.6,-.745),(8.11,19.925,-.409),(8.795,20.19,-.644),(9.268,23.952,-1.171),(9.314,24.007,-1.303),(9.386,24.142,-1.487),(9.481,24.366,-2.066),(9.441,24.27,-1.717),(8.758,23.438,-.353),(8.428,23.191,-.117),(9.063,23.727,-.705),(9.215,23.894,-.971),(8.523,23.943,-4.572),(7.817,23.644,-5.031),(8.06,22.954,.08),(7.794,22.897,.201),(7.264,23.268,-5.334),(7.149,20.293,-3.186),(7.152,20.327,-3.499),(7.098,20.312,-3.521),(7.089,20.27,-3.201),(7.16,20.463,-3.767),(7.05,20.252,-3.537),(7.043,20.227,-3.214),(7.149,20.389,-2.908),(7.107,20.383,-2.911),(7.079,20.81,-4.181),(7.123,20.489,-2.665),(7.112,20.66,-2.622),(6.893,21.392,-4.735),(6.907,21.421,-4.775),(6.972,21.176,-4.611),(6.95,21.159,-4.586),(6.821,22.081,-5.196),(6.837,21.799,-4.963),(6.821,21.848,-4.968),(6.782,22.166,-5.213),(7.233,21.052,-.255),(6.74,22.748,-5.531),(6.792,22.414,-5.433),(6.738,22.489,-5.436),(6.666,22.798,-5.534),(7.036,20.96,-4.423),(7.079,20.766,-2.392),(7.056,20.868,-2.09),(7.083,20.918,-1.67),(7.169,20.887,-1.202),(7.244,20.849,-.871),(7.261,20.922,-.611),(7.24,21.203,.097),(7.215,21.38,.188),(7.335,21.707,.269),(7.434,22.022,.32),(7.502,22.354,.358),(7.066,20.264,-2.935),(7.052,20.282,-3.85),(7.24,21.074,-.147),(7.242,21.141,-.012),(7.206,20.69,-1.343),(7.142,20.747,-1.789),(7.114,20.722,-2.137),(7.268,20.642,-.994),(7.234,20.694,-.739),(7.062,20.884,-4.416),(7.003,21.117,-4.638),(6.941,22.865,-5.452),(7.291,21.095,.088),(7.501,21.468,.176),(7.1,20.865,-.002),(7.12,20.625,-2.436),(6.802,22.556,-5.475),(6.832,22.215,-5.383),(6.841,21.908,-5.173),(7.066,20.73,-.346),(6.86,21.672,-4.969),(6.936,21.361,-4.816),(9.639,21.985,-1.369),(9.576,23.344,-1.32),(9.512,23.275,-1.19),(9.544,21.937,-1.249),(9.676,23.486,-1.527),(9.799,22.093,-1.575),(9.455,21.893,-1.052),(9.446,23.223,-.981),(9.672,21.186,-1.592),(9.765,23.612,-1.766),(9.951,22.196,-1.834),(9.244,23.044,-.7),(9.165,21.783,-.749),(8.837,22.766,-.335),(8.695,21.816,-.323),(9.185,21.257,-.857),(9.418,21.221,-1.15),(8.669,21.341,-.367),(9.822,23.698,-2.122),(10.049,22.251,-2.214),(10.02,22.3,-3.13),(9.899,21.145,-2.29),(9.793,21.163,-1.843),(6.893,20.646,-4.672),(7.01,20.476,-4.395),(7.071,20.783,-4.409),(7.001,21.019,-4.664),(6.673,20.29,-4.7),(6.879,20.167,-4.402),(7.045,20.375,-4.144),(6.774,20.851,-4.879),(6.931,21.259,-4.857),(6.848,21.511,-4.973),(6.652,21.072,-4.959),(6.486,20.479,-4.906),(6.835,21.708,-5.148),(6.642,21.243,-5.096),(6.82,21.973,-5.331),(6.637,21.461,-5.24),(6.836,22.286,-5.417),(6.917,21.726,-5.318),(6.657,20.79,-5.067),(6.856,20.963,-5.186),(6.516,20.653,-4.956),(7.079,22.544,-5.394),(7.385,22.691,-5.296),(7.223,21.185,-5.241),(7.099,20.371,-2.701),(8.322,21.949,-.067),(8.213,21.461,-.095),(8.416,22.607,-.084),(7.968,22.053,.142),(7.892,21.61,.105),(8.025,22.574,.119),(7.752,21.146,.036),(8.216,21.036,-.174),(9.888,21.193,-3.223),(9.645,22.298,-3.983),(9.503,21.252,-4.032),(8.803,23.341,-4.578),(8.931,22.241,-4.611),(8.894,21.438,-4.636),(8.068,23.083,-5.012),(8.124,22.11,-4.985),(8.262,21.526,-4.963),(7.772,22.645,.241),(7.735,20.65,-.096),(8.201,20.427,-.313),(7.054,20.802,-.105),(7.123,20.597,-.075),(7.15,20.555,-1.916),(7.174,20.433,-1.514),(7.136,20.531,-2.192),(7.063,20.205,-2.061),(7.043,20.153,-1.716),(7.21,20.376,-1.144),(7.057,20.076,-1.315),(7.133,20.4,-.867),(6.957,20.069,-1.009),(6.943,20.401,-.733),(7.025,20.174,-2.952),(7.038,20.207,-2.735),(7.112,20.43,-2.479),(7.049,20.214,-2.523),(7.065,20.209,-2.297),(7.06,20.75,-.257),(6.776,20.307,-.421),(6.856,20.372,-.345),(7.545,20.723,-5.174),(7.213,20.532,-5.138),(8.964,20.887,-4.651),(6.964,20.11,-4.149),(7,20.473,-.185),(7.389,20.393,-.129),(9.948,20.658,-2.345),(9.904,20.607,-3.295),(7.013,20.147,-3.548),(7.014,20.16,-3.222),(7.692,20.196,-.225),(6.889,19.774,-2.22),(6.81,19.755,-1.881),(6.835,19.715,-1.456),(6.7,19.704,-1.129),(6.75,20.046,-.845),(7,20.114,-3.859),(6.907,19.841,-2.751),(7.258,20.004,-.398),(6.882,19.905,-.529),(7.327,20.169,-.268),(6.686,19.995,-.662),(6.445,19.923,-4.689),(6.478,20.121,-4.922),(6.817,20.261,-4.958),(7.002,20.378,-5.05),(9.551,20.715,-4.076),(11.891,1.794,-2.738),(11.927,1.549,-2.685),(11.696,1.512,-2.566),(11.526,1.491,-2.47),(11.397,1.489,-2.313),(11.288,2.004,-2.466),(11.227,2.372,-.511),(11.282,1.93,-.394),(11.461,1.99,-.137),(12.563,2.285,-.484),(12.694,1.842,-.34),(12.611,2.273,-.582),(9.845,7.996,-.815),(10.415,8.085,-.66),(10.156,8.506,-.768),(11.016,8.796,-.862),(10.705,8.734,-.76),(10.835,8.023,-.651),(10.897,9.132,-.825),(9.192,7.47,-4.261),(9.615,7.66,-4.619),(9.815,6.479,-4.306),(9.153,7.982,-4.579),(9.883,7.811,-4.741),(10.271,8.027,-4.87),(10.519,6.895,-4.614),(10.027,8.394,-4.96),(11.158,10.921,-3.641),(11.125,10.895,-3.702),(10.946,11.474,-3.561),(10.831,11.444,-3.778),(10.709,10.786,-1.222),(10.8,10.925,-1.311),(10.76,11.318,-1.469),(10.396,9.148,-4.949),(10.546,9.223,-4.888),(10.733,8.29,-4.804),(11.044,9.539,-4.578),(11.18,9.639,-4.4),(11.313,8.714,-4.455),(10.491,11.146,-4.468),(10.425,11.378,-4.423),(10.63,11.395,-4.147),(10.157,11.091,-4.73),(10.239,10.871,-4.744),(7.933,10.216,-3.854),(8.202,10.425,-4.352),(8.267,10.127,-4.357),(8.968,8.619,-4.686),(8.854,8.589,-4.62),(8.782,10.74,-1.044),(8.91,10.212,-.944),(8.878,10.681,-.982),(9.797,10.357,-.976),(10.063,10.445,-1.013),(9.754,10.787,-1.094),(9.045,8.927,-.951),(8.71,8.77,-1.267),(9.042,7.851,-1.078),(7.746,10.362,-3.411),(7.821,10.463,-3.783),(10.612,10.34,-1.027),(10.639,10.895,-1.239),(10.48,10.739,-1.081),(10.664,11.266,-1.417),(10.465,10.154,-.961),(10.528,9.855,-.936),(10.684,10.224,-1.018),(10.77,10.277,-1.049),(9.954,9.374,-.854),(10.301,9.492,-.888),(10.299,9.755,-.925),(10.351,9.069,-.817),(10.441,9.509,-.885),(10.981,9.605,-.918),(10.86,9.592,-.888),(11.47,10.375,-3.223),(11.456,10.376,-3.402),(11.281,10.76,-3.419),(11.498,8.878,-4.066),(11.3,9.729,-4.166),(11.364,9.781,-4.021),(11.316,10.309,-3.856),(11.262,10.283,-3.944),(11.194,6.45,-.598),(11.514,6.679,-.841),(11.193,6.853,-.624),(12.326,4.167,-1.175),(12.22,4.142,-1.029),(12.496,3.171,-.861),(12.426,2.834,-2.478),(12.118,3.735,-2.877),(12.221,3.804,-2.732),(11.911,3.553,-3.104),(11.652,4.608,-3.485),(12.019,3.643,-3.029),(11.683,7.432,-3.82),(11.571,7.597,-4.087),(11.616,7.871,-3.893),(11.742,2.223,-2.834),(11.555,2.138,-2.714),(11.361,3.062,-3.064),(11.191,7.405,-4.38),(11.032,8.496,-4.669),(11.873,6.224,-3.48),(11.925,6.257,-3.35),(12.071,5.079,-2.93),(12.537,2.848,-2.199),(12.658,2.827,-1.809),(12.649,2.464,-2.03),(11.68,1.227,-2.555),(11.985,1.311,-2.6),(11.516,1.216,-2.482),(12.201,1.623,-2.714),(12.242,1.365,-2.598),(11.398,1.21,-2.343),(11.202,1.254,-1.956),(11.155,1.51,-2.006),(11.127,1.313,-1.503),(11.038,1.625,-1.58),(11.022,2.005,-2.142),(11.023,1.752,-1.155),(11.121,1.456,-1.029),(10.899,2.035,-1.698),(12.836,1.65,-1.706),(12.705,2.013,-1.83),(12.773,2.107,-1.489),(12.909,1.743,-1.331),(12.693,1.577,-2.077),(12.607,1.914,-2.16),(12.747,2.212,-1.005),(12.878,1.782,-.854),(11.533,1.659,.02),(11.39,1.568,-.209),(11.694,1.693,.126),(11.621,2.036,-.049),(11.192,1.517,-.612),(11.075,1.868,-.771),(12.304,2.313,-.047),(12.371,1.908,.052),(12.186,3,-.281),(12.423,3.077,-.647),(12.158,1.837,.113),(12.077,2.237,-.015),(11.946,1.766,.173),(11.821,2.132,-.006),(11.96,2.888,-.173),(11.461,2.563,-.29),(11.696,2.752,-.187),(10.993,2.255,-.907),(12.486,1.436,-2.389),(12.457,1.722,-2.524),(12.57,1.851,-2.325),(12.591,1.506,-2.235),(12.379,2.11,-2.635),(12.513,2.232,-2.462),(12.646,3.027,-1.296),(10.915,2.126,-1.271),(12.153,1.952,-2.773),(12.576,2.325,-2.264),(10.873,3.427,-.839),(11.103,3.607,-.583),(12.243,2.532,-2.78),(12.003,2.376,-2.9),(11.896,4.042,-.559),(11.615,3.916,-.426),(8.722,8.542,-4.422),(8.527,9.191,-4.485),(8.675,9.196,-4.647),(8.454,8.485,-3.94),(8.195,9.169,-3.917),(8.361,9.75,-4.399),(8.555,9.746,-4.623),(8.805,9.23,-4.739),(10.536,8.784,-.767),(10.569,9.489,-.878),(9.934,6.835,-.795),(10.584,6.884,-.567),(9.583,9.206,-.771),(11.211,7.949,-.86),(11.309,8.736,-1.075),(9.216,6.34,-3.675),(8.861,7.379,-3.845),(10.837,7.105,-4.56),(10.469,8.139,-4.883),(9.863,8.948,-5.049),(9.592,8.838,-4.952),(10.01,8.987,-5.051),(9.205,8.689,-4.787),(10.988,10.958,-3.863),(11.162,10.34,-4.065),(10.804,10.894,-4.225),(10.405,11.035,-1.195),(10.357,9.787,-4.904),(10.204,9.708,-4.973),(10.806,9.377,-4.746),(10.2,9.066,-5.014),(10.013,9.634,-5.048),(9.846,9.572,-5.099),(10.022,10.233,-4.939),(9.83,10.151,-5.035),(10.615,9.955,-4.763),(10.165,10.323,-4.874),(10.397,10.522,-4.748),(10.858,10.149,-4.564),(9.881,10.628,-4.906),(10.022,10.713,-4.841),(9.668,10.082,-5.103),(9.692,9.521,-5.102),(9.535,10.03,-5.123),(9.542,10.483,-5.106),(9.691,10.548,-5.02),(9.579,10.878,-5.026),(9.769,10.92,-4.896),(9.918,10.975,-4.825),(10.634,10.774,-4.499),(11.011,10.256,-4.351),(10.11,11.393,-4.649),(9.825,11.324,-4.737),(9.657,11.293,-4.808),(9.451,11.284,-4.979),(9.445,10.843,-5.131),(9.307,11.281,-5.113),(9.191,11.269,-5.172),(9.332,10.817,-5.177),(8.962,11.242,-5.141),(9.422,10.436,-5.141),(9.188,10.36,-5.083),(9.094,10.77,-5.127),(9.288,9.94,-5.052),(8.87,10.265,-4.952),(8.764,10.71,-5.015),(8.958,9.822,-4.912),(9.414,9.429,-5.013),(9.053,9.309,-4.861),(8.732,9.746,-4.783),(8.657,10.199,-4.82),(8.556,10.639,-4.88),(8.491,10.146,-4.623),(8.425,10.533,-4.654),(8.653,11.206,-5.05),(8.458,11.14,-4.923),(8.332,11.01,-4.677),(8.118,10.794,-4.368),(8.001,9.82,-3.84),(8.949,9.574,-.938),(8.642,10.122,-1.204),(8.643,9.444,-1.23),(9.431,9.723,-.8),(9.27,10.259,-.842),(8.637,10.624,-1.22),(8.218,9.898,-1.856),(8.272,9.257,-1.893),(9.907,9.857,-.885),(10.237,10.017,-.952),(9.158,10.678,-.927),(10.315,10.568,-1.015),(8.697,7.666,-1.759),(8.414,8.628,-1.863),(9.121,6.447,-1.749),(9.3,6.571,-1.173),(8.21,8.578,-2.63),(8.48,7.545,-2.561),(8.036,9.244,-2.68),(7.908,9.782,-2.735),(8.191,10.428,-1.839),(7.823,10.27,-2.724),(7.876,9.841,-3.416),(8.047,9.174,-3.393),(11.015,11.499,-3.392),(11.146,11.573,-2.931),(10.19,10.918,-1.11),(10.644,9.901,-.94),(8.261,8.485,-3.345),(8.562,7.388,-3.214),(8.983,6.295,-3.147),(8.966,6.337,-2.34),(11.583,9.95,-2.159),(11.397,10.051,-1.632),(11.381,9.447,-1.363),(11.626,9.304,-1.816),(11.456,10.584,-2.492),(11.325,10.653,-1.922),(11.178,10.073,-1.215),(11.127,9.528,-1.037),(11.606,8.59,-1.457),(11.637,9.873,-2.65),(11.753,9.178,-2.228),(11.432,10.497,-2.996),(11.295,11.12,-2.751),(11.224,11.176,-2.177),(11.154,10.591,-1.451),(11.081,11.081,-1.664),(11.006,10.515,-1.222),(11.016,10.039,-1.038),(11.773,8.45,-1.8),(11.657,9.829,-2.852),(11.822,9.071,-2.428),(11.433,10.439,-3.181),(11.671,9.8,-2.955),(11.215,11.035,-3.234),(11.214,10.919,-3.385),(11.515,7.855,-1.127),(11.714,7.734,-1.438),(11.859,8.385,-1.903),(11.792,7.711,-1.538),(11.995,8.404,-2.285),(11.86,9.088,-2.613),(10.943,10.999,-1.414),(10.86,10.428,-1.131),(10.879,9.986,-.981),(11.133,11.584,-2.356),(11.014,11.475,-1.815),(10.893,11.379,-1.559),(12.051,7.673,-2.035),(12.02,8.295,-2.786),(11.867,8.978,-2.997),(11.655,9.792,-3.241),(11.719,8.855,-3.646),(11.517,9.898,-3.734),(11.391,10.382,-3.696),(11.427,9.821,-3.915),(11.883,8.106,-3.463),(12.126,7.614,-2.618),(12.013,7.522,-3.335),(11.675,7.937,-3.77),(11.55,8.92,-3.942),(10.755,9.939,-.948),(10.736,9.523,-.875),(10.657,3.259,-1.155),(11.327,3.769,-.444),(10.502,4.793,-.886),(10.822,4.973,-.672),(10.176,4.573,-1.239),(11.07,5.102,-.579),(10.128,5.997,-.786),(10.673,6.189,-.591),(9.603,5.73,-1.22),(10.895,6.297,-.565),(11.329,5.213,-.592),(11.642,5.338,-.762),(12.129,4.111,-.904),(11.872,5.366,-1.092),(11.748,6.623,-1.231),(11.976,5.37,-1.221),(11.813,6.613,-1.336),(12.146,5.363,-1.44),(12.251,5.266,-1.906),(12.446,4.11,-1.595),(12.093,6.582,-1.699),(12.208,6.502,-2.299),(10.827,6.88,-.544),(12.372,2.65,-2.64),(11.835,4.815,-3.338),(11.52,6.095,-3.952),(11.231,5.925,-4.147),(12.001,4.911,-3.108),(11.812,6.214,-3.67),(11.753,7.448,-3.689),(11.666,3.366,-3.216),(11.321,4.505,-3.605),(10.906,5.749,-4.174),(10.858,4.268,-3.455),(10.902,2.955,-2.707),(10.376,4.131,-3.048),(10.294,5.444,-3.933),(9.75,5.254,-3.444),(10.498,2.97,-1.932),(10.524,3.099,-1.526),(10.636,2.898,-2.403),(9.911,4.247,-2.137),(9.986,4.391,-1.702),(10.095,4.118,-2.699),(9.342,5.448,-2.201),(9.436,5.57,-1.729),(9.515,5.238,-3.089),(12.429,3.98,-2.141),(12.236,5.098,-2.52),(12.127,6.366,-2.992),(12.297,3.875,-2.535),(13.223,-2.065,.198),(13.213,-2.111,.137),(13.505,-1.92,.189),(13.661,-.7,-.921),(13.574,-.765,-1.147),(13.49,-.342,-1.129),(13.322,.158,-1.193),(13.582,-.318,-.827),(13.696,-.489,-.356),(13.619,-.283,-.454),(13.627,-.265,-.316),(13.563,-.133,-.524),(13.791,-.592,-.123),(13.816,-.725,-.213),(13.725,-.388,-.024),(13.766,-.524,.112),(12.511,-2.223,-1.525),(12.73,-2.119,-1.633),(12.515,-2.255,-1.408),(12.519,-2.323,-1.216),(13.592,-.185,.158),(13.55,-.016,-.272),(13.434,.107,.059),(13.838,-.821,-.168),(13.816,-.934,-.504),(13.172,-1.535,-1.864),(13.141,-1.274,-1.84),(13.222,-1.52,-1.819),(13.16,-1.801,-1.786),(13.226,-1.65,-1.765),(13.226,-1.809,-1.729),(11.112,1.067,-1.432),(11.112,1.117,-1.224),(12.191,-2.013,-2.277),(12.145,-1.988,-2.28),(12.364,-1.868,-2.345),(12.796,-2.121,-1.771),(12.886,-1.991,-1.808),(12.845,-2.106,-1.891),(12.899,-1.846,-1.982),(12.959,-1.821,-1.94),(12.19,-2.059,-1.399),(12.362,-2.15,-1.403),(12.176,-2.065,-1.346),(12.035,-1.666,-1.343),(12.118,-2.113,-1.675),(11.972,-2.074,-1.852),(12.049,-2.093,-1.84),(12.128,-1.919,-2.298),(13.729,-1.764,.227),(13.585,-1.891,.255),(13.567,-1.883,.239),(12.546,-1.641,-.793),(12.556,-2.026,-.796),(12.593,-2.03,-.72),(13.786,-1.009,-.756),(13.765,-1.049,-.886),(13.321,-.864,-1.599),(13.283,-.44,-1.56),(13.428,-.813,-1.441),(12.892,1.308,-1.611),(13.029,1.293,-1.158),(12.937,1.088,-1.573),(13.949,-1.013,.425),(13.978,-1.18,.511),(13.989,-1.217,.445),(11.984,-1.32,-2.415),(12.26,-1.147,-2.427),(12.296,-1.356,-2.409),(12.77,-1.617,.397),(12.845,-1.85,.547),(12.848,-1.62,.787),(12.851,-1.914,.41),(12.826,-1.888,.132),(12.735,-1.54,.034),(12.805,-1.878,.019),(12.669,-1.346,.3),(12.443,-1.175,.166),(12.388,-1.011,-.218),(12.38,-.914,-.562),(12.348,-.892,-.812),(12.501,-1.075,-.518),(13.366,-1.185,1.101),(13.568,-1.071,1.012),(13.342,-1.129,1.091),(13.035,-1.213,1.079),(12.884,-1.079,1.033),(12.79,-1.146,1.007),(12.572,-1.194,.848),(12.542,-1.238,.584),(12.681,-1.213,.888),(12.145,-.749,-.361),(12.202,-.725,-.442),(12.543,-1.112,.94),(13.037,-2.055,.513),(13.279,-2.036,.319),(13.32,-2.044,.34),(13.014,-2.059,.38),(12.099,-.92,-.047),(12.247,-1.13,.442),(12.044,-1.015,.341),(11.198,1.097,-.471),(11.101,.947,-.192),(11.207,1.188,-.428),(11.182,.882,-.952),(11.232,1.178,-.778),(11.122,1.181,-.959),(11.524,1.621,.04),(11.975,.78,-2.582),(12.301,.84,-2.487),(11.998,.617,-2.581),(13.898,-.954,.611),(13.871,-1.064,.784),(13.937,-1.112,.671),(13.737,-1.04,.882),(13.818,-.823,.541),(13.664,-.817,.761),(13.976,-1.523,.509),(13.882,-1.619,.211),(13.974,-1.356,.164),(12.987,-1.715,-1.966),(12.913,-1.726,-2.062),(11.276,1.394,-.558),(13.88,-.931,.084),(13.897,-.869,.346),(13.924,-1.128,.145),(13.989,-1.366,-.329),(13.992,-1.364,-.46),(13.969,-1.253,-.459),(13.962,-1.41,-.678),(13.931,-1.378,-.799),(13.93,-1.285,-.698),(12.814,.4,.581),(12.783,.133,.763),(12.924,.091,.727),(11.943,-2.031,-1.626),(11.826,-1.721,-1.695),(11.907,-1.996,-1.775),(12.027,.393,-2.554),(12.416,.385,-2.417),(12.03,.254,-2.556),(13.403,.329,-.657),(12.915,-.558,-2.044),(13.075,-.976,-1.9),(12.88,-1.028,-2.071),(12.543,1.131,-2.334),(12.634,1.186,-2.209),(12.601,.856,-2.271),(11.901,-.246,-.897),(11.911,-.275,-.809),(11.528,.175,-.945),(13.943,-1.416,-.013),(13.841,-1.7,.029),(13.961,-1.466,-.156),(12.473,-.759,1.025),(12.605,-.857,1.003),(12.86,-.63,1.006),(12.639,-.418,1.008),(13.658,-1.154,-1.142),(13.709,-.639,-.649),(13.137,-.02,-1.621),(12.389,-2.185,-1.54),(12.657,-2.34,-1.31),(12.816,-2.165,-1.531),(12.486,-2.192,-1.144),(13.142,.262,.385),(13.275,-.046,.551),(13.259,.484,-.179),(13.029,.597,.182),(13.422,-.348,.643),(13.646,-.413,.363),(12.737,.642,.443),(12.952,.959,.002),(13.128,.882,-.385),(13.837,-.766,.005),(13.831,-.679,.228),(13.881,-.989,-.117),(13.869,-1.104,-.43),(13.934,-1.215,-.062),(13.948,-1.292,-.201),(13.831,-1.141,-.732),(11.98,1.078,-2.597),(11.655,.992,-2.587),(13.044,-2.334,-.569),(12.887,-2.354,-.478),(12.807,-2.338,-.707),(12.967,-2.313,-.719),(12.838,-2.229,-.438),(12.71,-2.233,-.716),(13.224,-2.212,-.786),(13.26,-2.203,-.729),(13.431,-1.279,-1.585),(13.385,-1.486,-1.663),(13.037,-1.578,-1.985),(12.897,-1.35,-2.095),(13.149,-1.66,-1.85),(13.115,-1.999,-1.737),(13.263,-1.982,-1.707),(13.399,-1.816,-1.625),(13.472,-1.942,-1.555),(12.993,-1.985,-1.728),(13.107,-1.778,-1.836),(13.393,-1.638,-1.658),(11.726,.338,-2.484),(11.723,.456,-2.505),(11.645,.694,-2.553),(11.496,.268,-2.355),(11.471,.361,-2.381),(11.731,.083,-2.505),(11.305,.192,-2.141),(11.315,-.123,-2.071),(11.239,-.229,-1.697),(11.156,.153,-1.698),(11.484,-.29,-1.27),(11.254,.154,-1.29),(11.359,-.692,-1.734),(11.404,-.598,-2.106),(11.51,-.008,-2.357),(11.123,.348,-1.745),(11.251,.318,-2.191),(11.572,-.507,-2.354),(11.452,.669,-2.459),(11.069,.789,-1.347),(11.126,.835,-1.15),(11.208,.521,-1.079),(11.111,.462,-1.308),(11.12,.991,-1.873),(11.075,.672,-1.817),(11.459,.975,-2.488),(11.3,.972,-2.321),(12.439,-2.006,-1.039),(12.273,-2.154,-1.563),(12.355,-1.627,-1.045),(12.085,-2.045,-2.161),(12.026,-2.022,-2.165),(11.988,-1.947,-2.174),(12.037,-2.068,-1.996),(11.967,-2.048,-2.006),(11.898,-1.988,-1.996),(13.468,-1.998,-.928),(13.529,-2.01,-.83),(13.692,-1.804,.109),(13.829,-1.737,-.83),(13.645,-1.783,-.989),(12.263,-1.376,-1.053),(12.516,-1.343,-.82),(13.807,-1.341,-.918),(13.702,-1.328,-1.124),(13.569,-1.251,-1.363),(13.628,-1.372,-1.251),(13.606,-1.43,-1.379),(13.582,-1.377,-1.409),(13.701,-1.532,-1.063),(13.642,-1.561,-1.181),(13.114,.642,-1.424),(13.229,.789,-.869),(13.001,.491,-1.724),(12.996,1.31,-.635),(12.854,.971,-1.923),(12.773,1.273,-2.004),(12.963,-2.077,.176),(13.997,-1.286,.547),(12.688,-1.058,-2.259),(12.718,-1.383,-2.267),(11.878,-.9,-2.452),(12.239,-.727,-2.477),(12.315,-1.632,-2.391),(12.086,-1.683,-2.335),(12.724,-1.485,.355),(12.781,-1.489,.754),(11.834,-1.357,-2.278),(11.704,-.984,-2.31),(11.778,-.416,-2.5),(11.573,-1.052,-2.112),(11.747,-1.427,-2.084),(11.938,-1.727,-2.206),(11.842,-1.753,-2.031),(11.777,-1.451,-1.676),(12.002,-1.413,-1.32),(11.555,-1.083,-1.693),(11.848,-1.032,-1.283),(12.132,-.969,-1.034),(12.687,-1.686,-.49),(12.652,-1.407,-.5),(12.737,-2.079,-.41),(12.873,-2.11,-.049),(12.636,-1.332,-.062),(12.197,-.644,-.839),(12.033,-.713,-1.006),(11.692,-.761,-1.261),(11.76,-.263,-1.019),(12.232,-.667,-.676),(12.752,-1.369,.703),(12.9,-1.399,.993),(12.853,-1.309,.972),(13.463,-1.313,1.134),(13.665,-1.273,1.08),(13.525,-1.481,1.167),(13.708,-1.45,1.111),(13.091,-1.317,1.093),(13.162,-1.41,1.115),(13.806,-1.294,.914),(13.223,-1.544,1.138),(12.961,-1.497,1.015),(11.561,-.018,-.73),(11.571,-.169,-.532),(11.198,.244,-.464),(11.247,.491,-.701),(11.078,.627,-.329),(11.17,.809,-.608),(11.513,-.434,-.178),(11.177,-.017,-.151),(11.911,-.328,-.671),(11.877,-.492,-.485),(11.244,.561,-.974),(11.849,-.707,-.145),(13.196,-.944,1.045),(13.026,-.79,1.02),(12.772,-.989,1.007),(13.404,-.863,.98),(12.315,-.846,1.008),(12.278,-.816,1.035),(12.46,-.977,.963),(12.198,-.984,.884),(12.266,-1.092,.844),(12.297,-1.143,.743),(12.404,.212,.873),(12.432,.476,.724),(13.04,-.323,.857),(12.735,-.15,.889),(12.017,-1.06,.628),(11.992,-1.045,.735),(11.039,.345,-.017),(11.037,.658,.149),(11.438,1.187,.448),(11.492,1.401,.205),(11.315,1.257,.075),(11.187,.993,.357),(11.369,1.473,-.132),(11.688,1.277,.469),(11.693,1.489,.273),(12.177,-.266,-2.496),(11.228,.648,-2.265),(12.266,1.072,-2.531),(13.232,-.654,.934),(13.899,-1.18,.798),(12.935,-1.616,-2.075),(11.44,.166,-1.042),(13.537,-1.769,-1.455),(13.605,-1.764,-1.33),(13.576,-1.861,-1.37),(13.539,-1.861,-1.428),(13.535,-1.608,-1.481),(13.536,-1.442,-1.51),(13.618,-1.598,-1.329),(13.532,-1.388,-1.487),(11.764,-.932,.525),(11.821,-.851,.27),(11.482,-.655,.253),(14.006,-1.515,-.459),(13.989,-1.497,-.288),(13.973,-1.533,-.655),(13.927,-1.539,-.797),(13.595,-1.756,-1.146),(13.588,-1.86,-1.191),(13.738,-.612,.459),(12.46,.734,.591),(13.556,-.596,.711),(13.789,-1.524,-.916),(12.671,-1.625,-2.282),(12.634,-.588,-2.335),(12.632,-1.843,-2.26),(12.83,-1.516,-2.209),(12.807,-1.645,-2.193),(12.897,-1.504,-2.131),(12.836,-1.732,-2.137),(12.6,1.107,.362),(12.825,1.388,-.18),(12.504,1.524,.191),(12.396,1.193,.464),(12.279,1.536,.288),(11.99,1.535,.329),(12.024,1.314,.498),(12.804,-.128,-2.071),(12.715,.391,-2.123),(12.579,-.147,-2.346),(13.952,-1.668,-.709),(12.264,-.579,1.059),(12.09,-.632,1.135),(12.132,-.676,1.065),(11.515,-.042,1.456),(11.512,.12,1.375),(11.375,.091,1.361),(11.334,.008,1.398),(11.733,-.135,1.474),(11.858,-.218,1.421),(11.835,-.034,1.391),(11.76,.068,1.387),(12.02,-.494,1.248),(12.099,-.493,1.182),(11.956,-.713,1.121),(12.061,-.33,1.19),(12.159,-.454,1.126),(11.969,-.748,1.038),(11.982,-.751,1.025),(12.184,-.747,1.048),(12.228,.207,.989),(12.372,.065,.928),(11.652,-.926,.763),(11.654,-.922,.799),(11.469,-.849,.698),(11.873,-.924,.901),(11.85,-.892,.935),(11.844,-.858,.925),(12.026,-.805,1.017),(11.359,.28,1.12),(11.137,.132,1.039),(11.319,.177,1.262),(11.026,-.292,.813),(10.971,-.058,.878),(11.004,-.257,.739),(10.981,-.154,.956),(11.208,-.573,.685),(11.209,-.585,.698),(11.906,.976,.611),(12.062,.94,.605),(12.34,-.161,1.022),(11.526,.238,1.27),(11.99,.075,1.223),(11.946,-.255,1.335),(11.762,.209,1.274),(12.149,-.018,1.11),(11.908,-.439,1.401),(12.051,-.863,1.022),(11.17,-.551,.609),(11.471,-.835,.639),(11.479,-.845,.731),(11.659,-.953,.688),(11.15,-.48,.509),(11.454,-.775,.493),(11.918,-.976,.839),(12.092,-.907,.979),(11.657,-.908,.815),(11.39,.545,.88),(11.543,.35,1.142),(11.579,.63,.901),(11.765,.345,1.145),(11.852,.65,.901),(11.145,.339,.828),(11.621,.93,.588),(11.384,.867,.589),(10.971,.097,.745),(10.952,.372,.436),(10.987,0,.37),(10.995,-.178,.628),(11.135,-.338,.322),(11.118,.664,.528),(11.096,-.045,1.153),(11.228,.006,1.31),(11.834,-.852,.937),(12.056,.626,.896),(12.008,.29,1.125),(11.361,-.138,1.453),(11.517,-.214,1.498),(11.205,-.212,1.396),(11.288,-.315,1.478),(11.935,-.662,1.264),(11.882,-.878,1.13),(11.82,-.925,.941),(11.485,-.863,.741),(10.799,-1.395,1.211),(11.041,-1.433,.998),(11.03,-1.488,1.013),(11.411,-1.623,1.026),(11.256,-1.56,.986),(11.291,-1.512,.98),(11.385,-.525,1.526),(11.439,-.544,1.527),(11.452,-.406,1.518),(11.656,-1.583,1.325),(11.694,-1.318,1.22),(11.697,-1.283,1.317),(11.808,-.551,1.476),(11.788,-.724,1.449),(11.865,-.594,1.419),(11.716,-.316,1.509),(11.058,-.412,1.319),(11.207,-.462,1.474),(11.843,-.391,1.456),(11.863,-.822,1.272),(11.79,-.979,1.283),(11.783,-1.055,1.134),(10.886,-1.025,1.34),(10.76,-1.352,1.432),(10.825,-1.283,1.521),(10.929,-.98,1.469),(11.485,-1.376,.959),(11.66,-1.36,1.092),(11.603,-1.622,1.132),(11.66,-1.195,1.476),(11.6,-1.507,1.496),(10.932,-1.23,1.591),(11.025,-.947,1.568),(11.118,-1.198,1.659),(11.196,-.946,1.616),(11.301,-1.267,1.66),(11.369,-.998,1.623),(11.449,-1.379,1.62),(11.522,-1.089,1.573),(11.025,-.648,1.381),(11.133,-.64,1.502),(11.306,-.66,1.555),(10.939,-.687,1.19),(10.952,-.436,1.094),(11.594,-1.129,.872),(11.405,-1.079,.799),(11.193,-.705,.719),(10.981,-.533,.905),(10.961,-.766,1.003),(11.157,-.923,.822),(11.758,-1.113,1.017),(11.758,-.876,1.436),(11.643,-.619,1.517),(11.601,-.753,1.526),(11.419,-.68,1.556),(11.68,-.483,1.52),(10.89,-1.086,1.154),(11.09,-1.217,.948),(11.319,-1.339,.913),(10.792,-1.949,1.656),(10.706,-2.258,1.735),(10.708,-2.258,1.744),(11.262,-2.1,1.611),(11.254,-2.404,1.735),(11.256,-2.406,1.728),(10.786,-2.327,1.864),(10.8,-2.261,1.835),(11.153,-2.448,1.804),(11.169,-2.362,1.784),(10.731,-1.621,1.527),(10.717,-1.689,1.542),(10.805,-1.666,1.604),(10.642,-2.278,1.619),(10.684,-2.354,1.477),(10.715,-2.443,1.663),(11.285,-2.09,1.61),(11.268,-2.411,1.723),(11.389,-2.123,1.583),(11.469,-1.864,1.56),(11.262,-1.614,.97),(11.248,-2.471,1.471),(11.098,-2.539,1.557),(11.102,-2.46,1.383),(11.134,-2.244,1.194),(11.262,-2.244,1.2),(10.781,-2.335,1.854),(10.692,-2.259,1.731),(10.775,-1.931,1.653),(10.893,-1.935,1.716),(11.154,-2.453,1.79),(11.213,-2.035,1.681),(10.772,-2.355,1.855),(10.955,-2.416,1.892),(10.953,-2.423,1.883),(10.947,-2.443,1.883),(10.98,-2.303,1.849),(11.15,-2.476,1.788),(11.06,-1.987,1.718),(11.068,-1.965,1.725),(10.896,-1.912,1.723),(11.227,-2.016,1.685),(11.56,-1.948,1.378),(11.647,-1.736,1.357),(11.579,-1.668,1.532),(11.529,-1.98,1.156),(11.592,-1.784,1.124),(11.456,-2.187,1.44),(11.423,-1.591,1.641),(11.322,-1.817,1.64),(10.763,-1.376,1.441),(10.8,-1.393,1.53),(10.685,-1.583,1.428),(10.799,-1.424,1.215),(10.872,-1.421,1.602),(11.398,-1.799,1.005),(11.357,-1.988,1.06),(11.246,-1.757,.982),(11.04,-1.463,1.697),(10.961,-1.708,1.682),(11.227,-1.516,1.7),(11.131,-1.765,1.692),(10.702,-1.931,1.619),(10.656,-1.721,1.456),(10.764,-2.424,1.78),(10.683,-2.263,1.71),(10.644,-1.967,1.531),(10.888,-2.528,1.628),(10.92,-2.508,1.803),(10.686,-2.092,1.322),(11.297,-2.444,1.61),(11.149,-2.525,1.725),(11.028,-1.554,1.007),(10.974,-1.688,1.005),(10.753,-1.616,1.188),(11.415,-2.233,1.292),(10.858,-2.428,1.419),(10.862,-2.194,1.232),(10.892,-1.941,1.065),(10.702,-1.828,1.236),(11.184,-1.982,1.039),(13.731,-1.549,1.117),(13.828,-1.503,.961),(13.869,-1.928,1.085),(14.011,-2.86,1.225),(14.088,-2.949,1.1),(14.032,-2.77,1.191),(14.064,-2.78,1.061),(14.073,-3.012,.85),(14.07,-2.908,.742),(14.069,-2.846,.813),(14.057,-3.037,.717),(13.787,-2.154,.34),(13.611,-1.917,.275),(13.8,-1.845,.261),(13.893,-1.813,.333),(13.939,-1.718,.56),(13.936,-2.602,1.237),(13.751,-2.638,1.387),(13.936,-2.7,1.269),(13.944,-2.743,.585),(13.84,-3.064,.589),(13.859,-2.807,.521),(13.541,-1.585,1.184),(13.923,-2.814,1.323),(14.022,-2.849,.667),(14.056,-2.768,.784),(14.042,-2.699,1.036),(13.961,-3.066,.633),(13.973,-1.277,.706),(13.442,-3.089,.655),(13.404,-2.925,.623),(13.679,-2.913,.521),(13.669,-3.12,.564),(13.351,-2.726,.573),(13.643,-2.655,.448),(13.255,-2.859,.848),(13.311,-2.913,.839),(13.504,-2.799,1.382),(13.738,-2.808,1.418),(13.504,-2.705,1.393),(13.301,-2.821,1.226),(13.268,-2.756,1.234),(13.218,-2.793,1.035),(13.258,-2.865,1.018),(12.979,-1.86,.818),(12.992,-1.964,.678),(13.067,-1.763,1.025),(13.121,-2.126,1.139),(13.349,-2.005,1.276),(13.255,-1.641,1.155),(13.658,-1.939,1.261),(13.222,-2.598,1.227),(13.432,-2.504,1.366),(13.016,-1.919,.843),(13.03,-2.256,.958),(13.034,-1.712,1.01),(13.951,-1.443,.757),(13.928,-1.642,.792),(13.353,-2.098,.363),(13.492,-2.342,.394),(13.905,-2.074,.415),(13.114,-2.125,.524),(13.03,-2.02,.711),(13.068,-2.35,.776),(13.213,-2.396,.535),(13.861,-2.594,.435),(13.94,-2.38,1.171),(13.755,-2.43,1.345),(14.04,-2.605,.999),(14.029,-2.374,.929),(13.968,-1.947,.826),(14.055,-2.651,.756),(14.047,-2.431,.683),(13.98,-1.999,.604),(13.986,-2.489,.507),(13.195,-2.693,.82),(13.161,-2.651,1.019),(14.062,-3.127,.872),(14.057,-3.114,.787),(14.067,-3.105,1.106),(14.009,-2.999,1.238),(13.292,-3.079,.845),(13.722,-3.471,.669),(13.969,-3.233,.718),(13.861,-3.524,.752),(13.577,-3.837,.732),(13.622,-3.476,.646),(13.993,-3.305,.877),(13.928,-3.554,.928),(14.004,-3.261,1.119),(13.906,-3.093,1.346),(13.862,-3.404,1.361),(13.944,-3.497,1.13),(13.751,-3.872,.785),(13.838,-3.886,.97),(13.835,-3.823,1.193),(13.763,-4.03,1.005),(13.66,-4.029,.812),(13.679,-3.32,1.478),(13.594,-3.675,1.504),(13.766,-3.742,1.357),(13.544,-3.816,1.513),(13.742,-3.886,1.379),(13.347,-3.592,1.476),(13.389,-3.208,1.463),(13.739,-3.035,1.444),(13.792,-3.954,1.223),(13.321,-3.735,1.457),(13.348,-3.8,.775),(13.49,-3.976,.766),(13.292,-3.936,.805),(13.227,-3.707,.927),(13.197,-3.852,.946),(13.152,-3.62,1.103),(13.152,-3.783,1.121),(13.191,-3.755,1.295),(13.177,-3.575,1.286),(13.393,-3.466,.704),(13.448,-2.981,1.416),(13.27,-2.978,1.234),(13.239,-3.002,1.028),(13.158,-3.247,1.092),(13.204,-3.205,1.287),(13.246,-3.351,.879),(13.35,-4.464,.998),(13.135,-4.683,1.03),(13.123,-4.664,1.033),(13.406,-4.383,1.39),(13.18,-4.609,1.477),(13.2,-4.623,1.478),(13.166,-4.735,1.405),(13.247,-4.664,1.363),(13.124,-4.777,1.143),(13.209,-4.707,1.128),(13.421,-4.363,.905),(13.354,-4.458,.977),(13.115,-4.673,1.018),(13.492,-4.249,1.46),(13.18,-4.609,1.492),(13.414,-4.368,1.41),(12.897,-4.699,1.114),(12.879,-4.524,1.055),(12.935,-4.576,.963),(13.563,-4.339,1.073),(13.681,-4.175,1.03),(13.586,-4.327,1.158),(12.852,-4.448,1.365),(12.9,-4.636,1.389),(12.914,-4.469,1.464),(13.108,-4.766,1.142),(13.459,-4.418,1.092),(13.152,-4.722,1.404),(13.479,-4.386,1.295),(13.131,-4.733,1.412),(13.145,-4.79,1.283),(13.13,-4.779,1.282),(13.11,-4.791,1.286),(13.251,-4.699,1.254),(13.088,-4.778,1.142),(13.488,-4.396,1.187),(13.475,-4.409,1.08),(13.508,-4.386,1.183),(13.497,-4.372,1.303),(13.705,-4.117,1.251),(13.552,-4.178,.848),(13.592,-4.285,1.292),(13.644,-4.053,1.436),(13.483,-3.943,1.538),(13.328,-4.191,1.551),(13.24,-3.868,1.474),(13.073,-4.125,1.495),(13.103,-3.859,1.318),(13.391,-4.142,.771),(13.226,-4.059,.807),(13.116,-3.975,.948),(13.225,-4.362,.828),(13.06,-4.32,.858),(13.074,-3.907,1.137),(12.962,-4.252,.989),(12.921,-4.169,1.178),(12.945,-4.132,1.345),(13.044,-4.66,.955),(13.059,-4.542,1.512),(13.005,-4.786,1.106),(12.999,-4.789,1.287),(13.025,-4.727,1.416),(12.887,-4.704,1.27),(12.845,-4.49,1.219),(13.474,-2.043,.2),(13.076,-2.556,-.526),(13.132,-2.681,-.534),(12.958,-2.6,-.322),(13.802,-2.33,-.565),(13.615,-2.383,-.694),(13.856,-1.958,-.637),(13.651,-3.611,-.336),(13.555,-3.578,-.396),(13.623,-3.493,-.387),(13.699,-3.471,-.35),(13.777,-3.385,.217),(13.778,-3.527,.15),(13.808,-3.407,.113),(13.732,-3.454,.28),(13.782,-1.94,.074),(13.081,-2.166,.084),(12.986,-2.351,-.349),(12.98,-2.287,-.143),(12.935,-2.34,-.32),(12.876,-2.244,-.337),(13.976,-1.664,-.641),(13.956,-1.782,-.624),(14.013,-1.658,-.457),(13.984,-1.726,-.309),(13.999,-1.79,-.454),(13.553,-3.076,-.498),(13.332,-3.125,-.525),(13.347,-2.991,-.566),(13.93,-1.75,-.167),(13.907,-1.909,-.21),(13.621,-3.362,-.405),(13.467,-3.555,-.411),(13.268,-2.381,.213),(13.504,-2.312,.246),(12.961,-2.544,-.117),(13.257,-2.397,-.672),(13.765,-2.706,-.48),(13.601,-2.742,-.576),(13.893,-2.275,-.359),(13.95,-1.958,-.432),(13.818,-3.455,-.141),(13.765,-3.612,-.101),(13.768,-3.26,.242),(13.82,-3.248,.088),(13.696,-3.295,-.356),(13.815,-3.268,-.16),(13.744,-2.278,.143),(12.955,-3.105,-.227),(13.119,-3.112,-.439),(13.08,-3.45,-.336),(13.024,-3.331,-.179),(13.451,-2.989,.376),(13.268,-2.984,.338),(13.257,-3.284,.365),(13.339,-3.337,.429),(13.076,-3.036,.217),(13.126,-3.268,.231),(12.969,-3.112,.01),(13.074,-3.308,.037),(13.1,-2.181,.074),(12.954,-2.244,-.12),(13.065,-2.453,.131),(12.937,-2.817,-.059),(13.058,-2.695,.177),(13.263,-2.617,.281),(12.962,-2.861,-.281),(13.492,-2.581,.318),(13.366,-2.723,-.638),(13.148,-2.898,-.486),(13.285,-3.541,-.405),(13.685,-3.419,.35),(13.736,-3.022,.278),(13.581,-3.388,.41),(13.837,-3.045,.046),(13.871,-2.639,-.01),(13.768,-2.602,.205),(13.851,-3.087,-.193),(13.867,-2.278,-.101),(13.886,-2.671,-.268),(13.734,-3.093,-.402),(13.554,-3.652,-.365),(13.596,-3.744,-.294),(13.718,-3.559,.254),(13.715,-3.643,.183),(13.181,-3.951,-.246),(13.238,-3.727,-.331),(13.347,-3.765,-.332),(13.58,-3.764,.237),(13.621,-3.593,.349),(13.471,-3.617,.426),(13.067,-3.702,.526),(12.935,-3.949,.591),(13.12,-3.729,.525),(13.475,-3.724,-.336),(13.494,-3.847,-.251),(13.693,-3.743,-.059),(12.863,-4.431,.023),(12.798,-4.388,-.053),(12.975,-4.191,-.147),(13.081,-4.241,-.069),(13.02,-4.449,.229),(13.183,-4.266,.155),(12.995,-4.421,.473),(13.193,-4.238,.398),(12.949,-4.296,.63),(13.097,-4.077,.553),(12.837,-4.139,.632),(12.647,-4.013,.495),(12.756,-3.828,.461),(13.317,-3.854,.484),(12.749,-4.076,-.147),(12.611,-4.276,-.055),(12.93,-3.851,-.236),(12.511,-4.137,.053),(12.61,-3.955,-.01),(13.054,-3.633,-.303),(12.993,-3.478,-.155),(12.967,-3.464,.087),(12.757,-3.726,-.088),(12.775,-3.631,.164),(13.182,-3.479,.453),(13.281,-3.524,.484),(13.05,-3.407,.295),(12.875,-3.613,.403),(12.568,-4.065,.297),(12.635,-3.878,.244),(13.297,-4.04,-.167),(13.403,-3.987,.299),(13.39,-4.056,.049),(13.573,-3.86,-.023),(12.376,-4.717,.253),(12.093,-4.805,.245),(12.092,-4.791,.237),(12.488,-4.659,.622),(12.216,-4.724,.756),(12.216,-4.738,.754),(12.041,-4.863,.368),(12.103,-4.85,.328),(12.133,-4.802,.693),(12.188,-4.788,.69),(12.39,-4.721,.244),(12.089,-4.775,.215),(12.417,-4.596,.087),(12.579,-4.549,.718),(12.228,-4.705,.775),(12.501,-4.663,.623),(11.955,-4.507,.26),(11.889,-4.582,.361),(12.007,-4.386,.502),(11.888,-4.607,.517),(12.038,-4.406,.666),(11.949,-4.549,.628),(12.032,-4.851,.366),(12.446,-4.717,.327),(12.123,-4.791,.694),(12.505,-4.685,.528),(12.007,-4.847,.366),(12.063,-4.879,.522),(12.053,-4.871,.521),(12.03,-4.871,.525),(12.151,-4.86,.505),(12.102,-4.786,.707),(12.499,-4.718,.421),(12.523,-4.691,.522),(12.519,-4.724,.417),(12.468,-4.722,.322),(12.553,-4.656,.229),(12.627,-4.644,.557),(12.723,-4.548,.088),(12.642,-4.498,.021),(12.452,-4.385,.02),(12.833,-4.588,.311),(12.637,-4.705,.387),(12.833,-4.534,.535),(12.787,-4.416,.687),(11.964,-4.789,.534),(11.941,-4.744,.361),(12.045,-4.711,.683),(12.151,-4.591,.762),(12.026,-4.653,.197),(12.622,-4.259,.687),(12.429,-4.143,.573),(12.316,-4.261,.127),(12.361,-4.15,.369),(12.135,-4.262,.444),(12.123,-4.372,.17),(12.197,-4.253,.633),(12.421,-4.372,.745),(12.218,-4.492,.077),(13.171,-2.2,-1.649),(13.109,-2.458,-1.569),(13.112,-2.21,-1.67),(13.05,-3.125,-1.376),(13.282,-3.144,-1.219),(13.145,-3.233,-1.32),(13.131,-3.482,-1.226),(12.975,-3.471,-1.252),(13.244,-3.428,-1.197),(13.188,-3.539,-1.15),(13.31,-3.432,-.652),(13.32,-3.484,-.749),(13.341,-3.367,-.702),(13.23,-3.387,-.543),(13.348,-3.139,-.68),(13.297,-3.014,-.668),(13.377,-3.4,-.802),(13.397,-3.135,-.831),(13.375,-3.139,-1.053),(13.398,-3.077,-.854),(12.807,-2.296,-1.486),(12.519,-2.221,-1.002),(12.779,-3.316,-.483),(12.98,-3.282,-.464),(12.805,-3.171,-.535),(12.601,-3.378,-1.123),(12.492,-3.31,-.941),(12.585,-3.195,-.993),(13.554,-1.974,-1.351),(13.508,-2.057,-1.141),(12.705,-2.345,-.845),(12.807,-2.376,-.837),(13.384,-2.168,-1.528),(13.339,-2.427,-1.504),(13.508,-2.124,-1.378),(13.463,-2.395,-1.308),(13.088,-2.798,-1.48),(13.313,-2.774,-1.355),(13.344,-3.417,-1.019),(13.289,-3.528,-.968),(13.426,-2.748,-1.182),(13.242,-2.376,-.741),(13.363,-2.367,-.83),(13.468,-2.381,-1.054),(13.187,-2.639,-.66),(13.325,-2.663,-.74),(13.009,-2.474,-.698),(12.805,-2.516,-.775),(12.694,-2.391,-.992),(12.658,-2.542,-.942),(12.727,-2.657,-.707),(12.931,-2.651,-.644),(12.638,-2.581,-1.192),(12.586,-2.352,-.979),(12.617,-2.685,-.877),(12.772,-2.551,-1.415),(12.601,-2.725,-1.131),(12.613,-2.231,-.836),(12.945,-2.237,-1.617),(12.943,-2.493,-1.556),(12.761,-2.81,-1.352),(12.688,-3.115,-.626),(12.637,-3.276,-.561),(12.606,-3.099,-.787),(12.54,-3.227,-.74),(12.867,-2.936,-.576),(12.655,-2.935,-.623),(13.129,-2.955,-.585),(12.588,-2.93,-.807),(12.588,-3.003,-1.047),(12.72,-3.115,-1.232),(13.441,-2.695,-.942),(12.892,-3.163,-1.37),(12.939,-2.811,-1.469),(12.9,-3.443,-1.281),(12.727,-3.454,-1.259),(13.277,-3.503,-.651),(13.172,-3.54,-.553),(12.938,-3.626,-.425),(13.1,-3.565,-1.183),(13.232,-3.579,-.711),(13.122,-3.619,-1.09),(12.265,-3.975,-.941),(12.404,-4.036,-.843),(12.386,-4.046,-.836),(12.411,-4.053,-.793),(12.525,-4.059,-.629),(12.558,-4.01,-.422),(12.505,-4.064,-.621),(12.473,-4.087,-.61),(12.456,-4.107,-.604),(12.455,-4.075,-.382),(12.416,-4.136,-.59),(12.727,-3.336,-.458),(12.446,-3.472,-1.065),(13.139,-3.61,-.638),(12.937,-3.62,-1.166),(12.727,-3.676,-1.148),(12.983,-3.676,-1.036),(13.173,-3.629,-.891),(13.081,-3.677,-.852),(12.972,-3.729,-.565),(12.844,-3.758,-.996),(12.939,-3.78,-.778),(12.495,-3.817,-1.037),(12.628,-3.892,-.909),(12.267,-4.118,-.807),(12.143,-4.048,-.883),(12.75,-3.908,-.7),(12.791,-3.865,-.494),(12.426,-3.95,-.255),(12.53,-3.886,-.295),(12.445,-3.736,-.271),(12.306,-3.839,-.237),(12.192,-3.774,-.277),(12.323,-3.648,-.311),(12.719,-3.749,-.348),(12.623,-3.628,-.334),(12.157,-3.873,-.921),(12.042,-3.955,-.857),(12.367,-3.733,-1.041),(11.968,-3.839,-.796),(12.07,-3.752,-.842),(12.421,-3.393,-.477),(12.527,-3.49,-.379),(12.854,-3.451,-.402),(12.199,-3.595,-.412),(12.348,-3.365,-.644),(12.248,-3.579,-.957),(12.272,-3.452,-.844),(12.06,-3.659,-.745),(12.572,-3.625,-1.159),(12.09,-3.728,-.38),(12.106,-3.578,-.549),(12.018,-3.716,-.517),(11.973,-3.756,-.696),(11.779,-4.292,-.554),(11.557,-4.362,-.488),(11.557,-4.331,-.487),(11.915,-4.239,-.142),(11.706,-4.279,.003),(11.708,-4.288,.008),(11.497,-4.453,-.352),(11.604,-4.443,-.397),(11.699,-4.416,-.123),(11.6,-4.421,-.069),(11.509,-4.328,-.514),(11.539,-4.332,-.497),(11.462,-4.427,-.351),(11.984,-4.195,-.103),(11.704,-4.271,.017),(11.92,-4.233,-.126),(11.501,-3.986,-.266),(11.636,-3.898,-.301),(11.506,-3.963,-.387),(11.622,-3.906,-.493),(11.637,-3.972,-.156),(11.706,-3.926,-.16),(11.398,-4.116,-.461),(11.346,-4.173,-.355),(11.48,-4.122,-.058),(11.643,-4.055,-.033),(11.494,-4.432,-.346),(11.853,-4.328,-.52),(11.763,-4.277,-.575),(11.594,-4.402,-.066),(12,-4.314,-.277),(11.531,-4.491,-.21),(11.527,-4.472,-.203),(11.5,-4.469,-.195),(11.662,-4.464,-.265),(11.571,-4.393,-.032),(11.947,-4.365,-.414),(12.009,-4.312,-.261),(11.855,-4.329,-.533),(11.955,-4.367,-.417),(11.785,-4.242,-.67),(11.367,-4.341,-.353),(11.439,-4.252,-.512),(12.108,-4.235,-.696),(12.239,-4.262,-.511),(12.265,-4.197,-.307),(11.906,-4.33,-.577),(11.673,-4.123,-.687),(11.684,-4.172,.02),(11.923,-4.059,-.057),(12.042,-4.299,-.26),(11.384,-4.332,-.182),(11.992,-4.362,-.432),(11.498,-4.256,-.021),(12.126,-3.948,-.172),(12.241,-4.07,-.188),(11.968,-4.163,-.786),(11.864,-4.055,-.795),(12.023,-3.885,-.21),(11.914,-3.843,-.287),(11.837,-3.823,-.41),(11.79,-3.837,-.624),(11.8,-3.927,-.729),(11.366,-4.175,-.204),(11.827,-3.981,-.081),(11.628,-3.982,-.617),(12.679,-2.843,-1.794),(12.664,-2.875,-1.67),(12.67,-2.952,-1.795),(12.66,-2.638,-1.599),(12.735,-2.662,-1.716),(12.486,-2.751,-2.151),(12.474,-2.855,-2.151),(12.394,-2.792,-2.173),(12.263,-2.916,-2.152),(12.363,-2.56,-2.264),(12.359,-2.02,-2.297),(12.005,-2.743,-1.919),(12.077,-2.827,-2.087),(11.936,-2.826,-1.874),(12.174,-2.83,-1.423),(12.406,-2.909,-1.443),(12.223,-2.763,-1.437),(12.065,-2.269,-2.099),(12.051,-2.504,-1.985),(12.04,-2.274,-1.998),(12.792,-1.892,-2.121),(12.509,-2.333,-1.525),(12.722,-2.351,-1.627),(12.762,-2.373,-1.731),(12.797,-2.391,-1.862),(12.765,-2.368,-2.058),(12.794,-2.08,-2.094),(12.748,-2.673,-1.812),(12.7,-2.636,-2.015),(12.638,-2.802,-1.99),(12.417,-3.017,-2.107),(12.604,-2.935,-1.991),(12.565,-3.068,-1.947),(12.643,-3.078,-1.76),(12.61,-3.009,-1.611),(12.544,-2.997,-1.525),(12.536,-2.589,-2.189),(12.386,-2.292,-2.294),(12.578,-2.301,-2.222),(12.615,-2.036,-2.253),(12.184,-2.272,-2.236),(12.158,-2.547,-2.177),(11.967,-2.793,-1.743),(12.005,-2.686,-1.775),(11.997,-2.477,-1.775),(12,-2.793,-1.585),(12.058,-2.703,-1.602),(12.506,-2.578,-1.513),(12.278,-2.539,-1.457),(12.086,-2.706,-1.515),(12.049,-2.812,-1.503),(12.098,-2.499,-1.503),(12.038,-2.484,-1.587),(12.011,-2.264,-1.806),(12.095,-2.281,-1.631),(12.339,-2.312,-1.527),(12.177,-2.292,-1.559),(12.321,-3.071,-2.096),(12.595,-3.156,-1.646),(12.354,-3.134,-2.037),(12.058,-3.208,-1.984),(12.579,-3.193,-1.729),(12.483,-3.179,-1.895),(11.747,-3.325,-1.831),(11.889,-3.144,-1.933),(11.919,-3.383,-1.882),(12.221,-3.271,-1.924),(12.056,-3.455,-1.843),(11.811,-3.033,-1.796),(11.701,-3.26,-1.695),(11.702,-3.582,-1.761),(11.547,-3.519,-1.734),(12.423,-3.322,-1.667),(12.38,-3.247,-1.503),(12.184,-3.486,-1.43),(12.185,-3.536,-1.592),(11.972,-3.64,-1.285),(11.988,-3.704,-1.467),(12.253,-3.143,-1.364),(12.092,-3.34,-1.296),(12.335,-3.298,-1.813),(12.139,-3.491,-1.746),(11.844,-3.639,-1.715),(11.938,-3.688,-1.6),(11.449,-3.453,-1.603),(11.431,-3.349,-1.436),(11.68,-3.194,-1.547),(11.887,-3.479,-1.17),(11.926,-3.213,-1.248),(11.703,-3.34,-1.111),(11.826,-2.944,-1.661),(11.484,-3.295,-1.302),(11.719,-3.145,-1.417),(11.77,-3.159,-1.327),(11.574,-3.302,-1.2),(12.089,-3.024,-1.337),(11.91,-2.951,-1.408),(11.846,-2.925,-1.512),(11.366,-3.965,-1.379),(11.504,-3.837,-1.474),(11.618,-3.842,-1.442),(11.298,-3.932,-1.398),(11.67,-3.855,-1.353),(11.671,-3.839,-1.214),(11.5,-4.005,-1.107),(11.491,-3.976,-1.027),(11.292,-3.918,-1.395),(11.478,-3.943,-1.017),(11.279,-4.053,-1.286),(11.427,-4.074,-1.064),(11.615,-3.83,-1.455),(11.491,-3.82,-1.493),(11.684,-3.826,-1.189),(11.683,-3.844,-1.345),(11.168,-3.861,-1.3),(11.151,-3.815,-1.252),(11.246,-3.63,-1.439),(11.134,-3.902,-1.147),(11.161,-3.77,-1.191),(11.216,-3.892,-1.387),(11.174,-4.001,-1.225),(11.279,-3.906,-1.411),(11.24,-4.027,-1.275),(11.417,-3.776,-1.541),(11.713,-3.786,-1.128),(11.475,-3.927,-.985),(11.36,-3.748,-.951),(11.294,-3.716,-1.002),(11.278,-3.867,-.957),(11.654,-3.849,-1.41),(11.441,-4.024,-1.251),(11.271,-4.026,-1.278),(11.418,-4.045,-1.054),(11.34,-4.104,-1.17),(11.33,-4.075,-1.159),(11.309,-4.081,-1.141),(11.398,-4.047,-1.03),(11.662,-3.846,-1.414),(11.244,-3.561,-1.292),(11.315,-3.723,-1.528),(11.251,-4.036,-1.068),(11.196,-3.924,-1.026),(11.648,-3.669,-1.023),(11.511,-3.546,-.992),(11.386,-3.513,-1.075),(11.285,-3.506,-1.159),(11.344,-3.98,-.965),(11.448,-3.85,-.951),(11.206,-3.712,-1.089),(-4.074,-17.054,1.829),(-4.133,-17.72,1.609),(-3.865,-16.789,1.518),(-4.18,-16.477,1.96),(-4.915,-17.019,2.566),(-4.783,-16.308,2.507),(-4.953,-16.211,2.609),(-4.436,-16.742,2.246),(-4.58,-16.472,2.362),(-4.717,-17.083,2.46),(-6.635,-15.139,-1.338),(-6.602,-14.438,-1.46),(-6.578,-15.122,-1.455),(-5.219,-12.467,2.719),(-5.444,-13.116,2.618),(-5.355,-13.179,2.61),(-4.862,-15.048,2.514),(-4.554,-15.321,2.372),(-4.853,-14.391,2.514),(-4.185,-15.76,1.966),(-4.25,-16.107,2.035),(-3.762,-16.17,1.407),(-3.293,-15.382,.942),(-3.394,-16.373,.735),(-3.152,-15.551,.546),(-3.653,-15.73,1.323),(-2.665,-13.688,.397),(-2.446,-12.33,.636),(-2.698,-13.582,.519),(-2.483,-12.197,1.006),(-2.323,-11.08,-1.225),(-2.747,-13.18,-1.567),(-2.524,-11.075,-1.66),(-6.524,-16.057,1.819),(-6.353,-16.243,2.233),(-6.327,-15.945,2.237),(-6.852,-11.009,2.466),(-6.877,-10.495,2.442),(-7.227,-10.73,1.438),(-4.463,-12.857,2.843),(-4.447,-13.446,2.718),(-3.931,-13.207,2.595),(-4.859,-11.695,2.79),(-4.777,-11.734,2.8),(-4.596,-10.643,2.749),(-2.565,-10.494,1.131),(-2.585,-12.055,1.372),(-2.728,-12.818,1.404),(-2.677,-13.173,1.066),(-3.123,-13.465,2.007),(-3.404,-14.143,2.12),(-3.19,-14.185,1.921),(-3.479,-13.411,2.314),(-3.829,-13.655,2.492),(-3.679,-13.905,2.369),(-3.512,-12.438,2.426),(-4.779,-10.227,2.889),(-5.143,-10.163,2.957),(-5.006,-10.77,2.845),(-4.972,-13.431,2.591),(-5.001,-12.585,2.691),(-5.123,-13.343,2.589),(-5.284,-13.587,-1.925),(-5.064,-12.609,-2.205),(-4.87,-13.601,-1.976),(-4.477,-15.267,-1.89),(-4.13,-15.229,-1.869),(-4.137,-15.596,-1.813),(-3.5,-10.958,-2.916),(-3.639,-12.851,-2.298),(-3.889,-12.803,-2.41),(-3.901,-13.345,-2.272),(-3.173,-14.181,-1.742),(-3.425,-14.065,-1.912),(-3.164,-12.98,-1.998),(-6.201,-14.177,2.227),(-6.231,-13.988,2.243),(-6.53,-14.136,1.981),(-6.646,-15.902,1.487),(-6.636,-16.448,1.503),(-6.581,-15.921,1.547),(-3.746,-16.308,-1.543),(-3.627,-16.477,-1.45),(-3.686,-16.903,-1.361),(-7.539,-10.679,.56),(-7.224,-11.197,1.442),(-7.007,-14.641,.589),(-7.116,-13.886,.309),(-7.106,-14.579,.199),(-7.185,-12.814,1.22),(-7.265,-12.801,.883),(-7.072,-13.949,1.057),(-7.077,-12.757,1.701),(-6.958,-13.452,1.601),(-5.988,-12.451,2.791),(-6.454,-12.717,2.633),(-6.101,-13.009,2.645),(-6.556,-13.841,2.059),(-6.613,-13.597,2.109),(-6.67,-13.818,1.927),(-6.919,-12.671,2.213),(-6.818,-11.575,2.489),(-5.5,-12.294,2.753),(-5.397,-12.364,2.719),(-5.347,-11.402,2.816),(-5.399,-10.452,2.853),(-5.717,-15.379,2.488),(-5.9,-15.351,2.43),(-5.954,-15.921,2.499),(-3.899,-13.961,-2.096),(-3.98,-13.934,-2.133),(-6.682,-14.395,-1.301),(-6.661,-13.734,-1.498),(-5.206,-14.238,2.507),(-5.414,-13.483,2.578),(-5.103,-15.042,-1.683),(-5.494,-15.807,-1.811),(-5.506,-14.975,-1.672),(-2.35,-12.503,.231),(-2.229,-10.396,.578),(-2.358,-10.454,.89),(-4.872,2.98,2.31),(-4.24,2.065,2.531),(-1.806,-.822,2.041),(-3.624,1.169,2.67),(-2.46,-.225,2.398),(-1.461,-8.654,.002),(-1.586,-8.528,.416),(-2.108,-10.852,-.152),(-3.189,-7.998,2.154),(-3.614,-9.504,2.435),(-3.191,-9.769,2.184),(-2.748,-8.163,1.729),(-2.705,-10.164,1.553),(-5.591,-8.747,2.887),(-5.748,-8.706,2.831),(-2.976,-9.958,1.907),(-1.787,-8.387,.824),(-2.096,-8.221,1.242),(-4.358,2.12,2.496),(-3.885,-1.495,2.634),(-3.907,-1.347,2.633),(-4.401,-1.418,2.775),(-2.979,.565,2.634),(-3.09,-6.822,2.185),(-2.992,-5.645,2.215),(-3.344,-6.684,2.321),(-2.867,-6.905,1.969),(-6.501,-.656,1.618),(-6.52,.029,1.468),(-6.565,-.648,1.537),(-4.468,-.784,2.722),(-4.524,-.153,2.671),(-4.606,-.792,2.725),(-4.337,-2.029,2.823),(-3.82,-1.939,2.639),(-3.842,-1.791,2.637),(-3.119,-4.063,2.386),(-3.138,-3.834,2.411),(-3.614,-4.135,2.586),(-2.729,-4.824,2.225),(-2.649,-5.633,2.113),(-2.6,-4.843,2.176),(-5.012,-4.643,3.049),(-4.983,-4.264,3.017),(-5.768,-4.555,2.71),(-3.618,-6.584,2.474),(-3.696,-7.722,2.428),(-2.147,-6.99,1.518),(-1.951,-7.078,1.361),(-1.84,-8.881,-1.346),(-1.762,-8.892,-1.077),(-5.681,-8.031,-3.365),(-5.682,-8.436,-3.285),(-6.482,-8.327,-2.614),(-3.957,-.358,-5.877),(-4.238,.067,-5.938),(-4.231,.612,-6.022),(-5.494,-.06,-4.683),(-4.942,.423,-5.418),(-4.894,-.495,-5.267),(-5.949,-.367,-3.99),(-6.394,-.671,-3.298),(-6.309,.169,-3.291),(-5.784,-.825,-4.127),(-6.32,4.414,-2.349),(-5.378,-1.346,-4.458),(-5.136,-1.418,-4.673),(-5.298,-1.942,-4.296),(-1.595,-2.107,-3.096),(-1.33,-1.884,-2.734),(-4.564,-7.264,-3.939),(-4.497,-6.19,-4.205),(-4.35,-7.208,-3.963),(-6.976,-6.997,-2.083),(-6.886,-5.732,-2.464),(-6.865,-7.021,-2.28),(-4.871,1.155,-5.397),(-5.412,.848,-4.649),(-5.842,.573,-3.993),(-5.822,4.565,-3.394),(-6.771,-1,-2.675),(-6.624,-.391,-2.825),(-6.454,.237,-3.022),(-6.216,1.016,-3.298),(-6.907,-1.91,-2.491),(-6.814,-1.898,-2.566),(-7.393,-2.104,-1.644),(-6.974,-2.362,-2.407),(-2.215,-4.32,-3.655),(-1.481,-3.428,-2.679),(-1.45,-3.887,-2.583),(-7.498,-4.589,-1.369),(-7.654,-4.864,-.122),(-7.653,-4.441,-.15),(-1.088,-4.335,-1.688),(-1.424,-4.526,-2.422),(-1.102,-4.002,-1.758),(-1.683,-8.902,-.809),(-1.372,-7.709,-.79),(-1.291,-7.648,-.371),(-2.374,-2.56,-4.08),(-2.33,-2.923,-3.984),(-3.135,-3.069,-4.433),(-2.294,-3.212,-3.921),(-3.612,-17.16,.917),(-3.879,-17.896,1.026),(-4.335,-17.343,2.111),(-4.362,-17.905,1.905),(-3.161,-16.547,.088),(-3.358,-17.311,.229),(-3.288,-17.334,-.383),(-3.117,-16.587,-.527),(-3.337,-17.141,-.997),(-3.229,-16.449,-1.154),(-5.411,-16.693,2.642),(-5.34,-16.063,2.612),(-5.494,-17.249,2.606),(-4.837,-17.619,2.393),(-4.611,-17.474,2.334),(-6.001,-16.443,2.53),(-6.03,-16.964,2.515),(-6.385,-16.723,2.232),(-6.57,-16.563,1.794),(-6.395,-14.989,-1.656),(-6.4,-14.33,-1.712),(-6.714,-15.048,-1.199),(-6.684,-15.728,-1.296),(-6.615,-15.706,-1.432),(-7.052,-16.433,-.865),(-6.997,-15.795,-.81),(-6.795,-15.755,-1.132),(-6.876,-16.4,-1.121),(-6.768,-16.372,-1.272),(-6.969,-15.107,-.754),(-7.174,-16.421,-.334),(-7.149,-15.82,-.271),(-6.854,-16.494,.939),(-6.89,-15.843,.89),(-6.939,-15.863,.648),(-6.954,-16.464,.667),(-7.11,-15.806,.159),(-7.115,-16.42,.224),(-6.961,-15.243,.622),(-6.945,-15.275,.837),(-6.861,-15.812,1.021),(-6.837,-16.408,1.038),(-5.606,-13.006,2.632),(-5.724,-13.542,2.509),(-5.85,-13.424,2.503),(-5.719,-12.858,2.663),(-5.099,-11.525,2.808),(-4.787,-14.306,2.517),(-4.492,-15.08,2.378),(-4.882,-15.557,2.518),(-4.617,-15.749,2.384),(-5.267,-14.92,2.523),(-4.127,-15.543,1.942),(-2.835,-14.753,.306),(-2.9,-14.647,.596),(-2.924,-14.447,.713),(-3.222,-15.185,1.079),(-2.546,-13.787,.199),(-2.766,-14.893,-.122),(-2.986,-15.707,-.022),(-3.561,-15.503,1.413),(-4.024,-15.374,1.985),(-4.379,-14.959,2.411),(-3.321,-14.902,1.672),(-3.769,-14.868,2.112),(-4.662,-14.244,2.559),(-4.843,-13.438,2.646),(-4.869,-12.666,2.735),(-4.316,-13.983,2.613),(-2.974,-15.799,-.632),(-2.807,-15.043,-.682),(-3.125,-15.669,-1.271),(-2.506,-14.066,-.198),(-2.663,-14.241,-.739),(-2.986,-14.996,-1.332),(-2.438,-12.923,-.85),(-2.308,-12.702,-.261),(-2.249,-11.068,-.83),(-2.884,-14.301,-1.407),(-3.439,-16.228,-1.418),(-3.35,-15.54,-1.534),(-3.237,-14.864,-1.638),(-2.821,-10.97,-2.299),(-5.305,-15.441,2.541),(-5.862,-14.779,2.433),(-6.24,-14.686,2.231),(-6.295,-15.401,2.21),(-6.516,-14.663,1.931),(-6.516,-15.424,1.865),(-5.814,-14.187,2.425),(-5.624,-14.835,2.495),(-5.53,-14.212,2.487),(-5.961,-13.231,2.557),(-6.27,-13.72,2.293),(-5.974,-11.197,2.792),(-6.06,-10.452,2.769),(-5.92,-12.006,2.822),(-3.057,-14.66,1.415),(-4.115,-14.51,2.453),(-4.282,-11.969,2.856),(-4.012,-10.908,2.659),(-2.848,-13.63,1.531),(-2.84,-14.032,1.109),(-2.911,-11.733,1.832),(-2.997,-12.63,1.906),(-3.006,-14.199,1.7),(-3.324,-11.354,2.287),(-5.91,-10.765,-2.676),(-4.964,-10.775,-3.02),(-5.98,-12.623,-2.059),(-6.007,-13.63,-1.859),(-4.211,-12.721,-2.445),(-4.165,-10.85,-3.052),(-6.507,-10.712,-2.238),(-6.471,-12.616,-1.926),(-4.265,-13.753,-2.181),(-4.349,-14.487,-2.02),(-4.966,-14.283,-1.773),(-4.052,-13.818,-2.202),(-4.582,-16.012,-1.82),(-4.091,-14.534,-2.026),(-5.372,-14.241,-1.739),(-4.646,-16.675,-1.847),(-5.565,-16.473,-1.957),(-4.174,-16.123,-1.721),(-4.165,-16.85,-1.613),(-6.154,-15.718,-1.79),(-6.238,-16.358,-1.828),(-6.406,-13.684,-1.798),(-6.83,-10.728,-1.924),(-6.749,-12.624,-1.683),(-6.042,-14.276,-1.754),(-6.071,-14.963,-1.704),(-6.444,-15.703,-1.614),(-6.509,-16.334,-1.608),(-6.68,-16.34,-1.426),(-3.967,-16.229,-1.643),(-3.899,-16.999,-1.451),(-3.984,-15.226,-1.824),(-3.987,-14.563,-1.978),(-3.545,-15.441,-1.648),(-3.762,-15.332,-1.739),(-3.738,-14.638,-1.883),(-3.467,-14.754,-1.78),(-3.722,-13.924,-2.049),(-3.895,-14.589,-1.941),(-3.894,-15.25,-1.794),(-3.767,-15.862,-1.64),(-3.595,-16.051,-1.539),(-7.138,-15.172,-.202),(-7.143,-14.544,-.14),(-6.958,-14.483,-.724),(-6.976,-13.822,-.732),(-7.123,-13.884,-.188),(-7.11,-15.173,.156),(-7.173,-12.667,-.305),(-7.077,-12.634,-.777),(-7.228,-10.661,-.832),(-7.151,-10.655,-1.166),(-7.261,-12.601,.049),(-7.354,-10.678,-.519),(-7.105,-13.935,.724),(-7.315,-12.712,.466),(-6.336,-13.476,2.361),(-6.644,-14.148,1.783),(-6.598,-15.381,1.588),(-3.831,-16.271,-1.587),(-3.768,-16.966,-1.386),(-3.518,-16.786,-1.302),(-3.87,-15.771,-1.695),(-7.008,-14.669,.803),(-6.625,-14.669,1.685),(-6.69,-14.673,1.621),(-6.663,-15.369,1.527),(-7.48,-10.641,-.046),(-6.912,-15.302,1.006),(-6.97,-14.704,1.03),(-6.849,-14.698,1.363),(-6.808,-15.337,1.296),(-6.767,-15.95,1.279),(-6.742,-16.519,1.296),(-6.903,-14.074,1.464),(-6.817,-13.155,2.141),(-6.754,-13.728,1.892),(-6.71,-13.404,2.135),(-6.563,-13.044,2.471),(-6.446,-13.249,2.434),(-6.719,-14.127,1.728),(-3.959,-15.716,-1.731),(-1.618,-7.271,.919),(-1.405,-7.441,.508),(-1.214,-6.241,.605),(-1.454,-6.083,1.043),(-6.08,3.754,1.113),(-5.744,3.436,1.748),(-6.312,4.158,.191),(-5.293,3.167,2.171),(-4.044,1.315,2.612),(-1.047,-1.533,1.452),(-.658,-1.519,.709),(-.644,-1.288,.684),(-1.046,-1.293,1.468),(-.478,-1.582,-.028),(-.437,-1.338,-.071),(-.453,-1.678,-.72),(-.401,-1.418,-.752),(-.561,-1.855,-1.225),(-.488,-1.544,-1.253),(-1.042,-1.111,1.456),(-.636,-1.111,.665),(-.415,-1.16,-.096),(-.372,-1.228,-.766),(-.451,-1.335,-1.279),(-.837,-1.685,-1.92),(-.833,-1.884,-1.823),(-6.71,-8.492,2.374),(-6.118,-8.609,2.699),(-6.197,-7.461,2.672),(-6.621,-7.449,2.363),(-5.855,-7.508,2.791),(-7.178,-7.46,1.415),(-7.198,-8.345,1.444),(-5.131,-8.805,3.128),(-4.485,-9.036,2.97),(-4.237,-7.633,3.005),(-5.113,-7.516,3.207),(-4.079,-9.26,2.601),(-2.392,-8.137,1.538),(-5.678,-7.465,2.876),(-7.675,-8.223,.2),(-7.669,-7.489,.131),(-6.148,3.033,1.159),(-5.788,2.735,1.752),(-5.289,2.493,2.194),(-5.866,1.362,1.854),(-5.823,2.064,1.775),(-6.223,2.29,1.215),(-6.322,1.546,1.305),(-6.427,3.384,.282),(-6.696,3.773,-1.048),(-6.717,1.787,.487),(-6.561,2.535,.402),(-6.795,2.946,-.924),(-6.964,2.214,-.843),(-7.149,-2.167,.91),(-7.629,-2.168,-.316),(-7.648,-2.747,-.249),(-7.176,-2.716,.97),(-5.312,1.185,2.293),(-5.285,1.802,2.216),(-4.788,2.286,2.376),(-4.644,1.005,2.515),(-4.704,1.585,2.444),(-4.773,-2.13,2.838),(-5.527,-2.238,2.625),(-5.579,-2.805,2.669),(-4.855,-2.713,2.886),(-4.207,.896,2.563),(-4.279,1.426,2.539),(-6.076,-2.224,2.273),(-6.11,-2.8,2.337),(-6.652,-2.192,1.708),(-6.684,-2.746,1.769),(-5.647,-3.433,2.684),(-5.718,-4.096,2.699),(-4.952,-3.857,2.982),(-4.903,-3.213,2.928),(-4.369,-1.723,2.799),(-4.678,-1.432,2.78),(-4.726,-1.781,2.809),(-6.055,-4.215,2.493),(-6.081,-3.548,2.42),(-6.44,-2.226,1.975),(-6.426,-2.785,2.091),(-7.163,-3.512,1.079),(-7.146,-4.308,1.195),(-6.617,-4.312,2.086),(-6.65,-3.539,1.929),(-7.651,-3.594,-.204),(-6.39,-3.55,2.209),(-6.357,-4.265,2.32),(-7.139,-5.372,1.318),(-7.162,-6.575,1.378),(-6.607,-6.401,2.309),(-6.593,-5.323,2.255),(-4.182,-4.176,2.949),(-4.208,-3.713,2.93),(-5.752,-6.239,2.797),(-5.083,-6.276,3.144),(-5.046,-5.211,3.091),(-5.811,-5.271,2.734),(-3.649,-3.57,2.616),(-3.054,-4.825,2.301),(-3.575,-4.754,2.553),(-3.54,-5.446,2.52),(-4.141,-5.387,2.996),(-4.186,-6.438,3),(-2.811,-4.1,2.324),(-3.526,-1.419,2.591),(-3.555,-1.269,2.6),(-7.658,-5.563,-.075),(-7.665,-6.755,.052),(-5.943,-6.276,2.686),(-6.014,-5.286,2.602),(-3.946,.812,2.621),(-2.154,-4.878,1.909),(-2.11,-4.101,1.998),(-2.526,-4.094,2.22),(-2.518,-6.886,1.822),(-2.202,-5.758,1.803),(-3.539,.712,2.684),(-3.176,-1.325,2.617),(-3.211,-1.136,2.641),(-2.736,-1.39,2.506),(-2.758,-1.217,2.524),(-3.15,-1.486,2.602),(-2.4,-.581,2.373),(-2.35,-.909,2.35),(-2.836,-.634,2.57),(-2.784,-1.009,2.543),(-2.253,-1.711,2.264),(-2.687,-1.782,2.464),(-2.632,-2.219,2.418),(-2.201,-2.162,2.213),(-1.716,-2.112,1.905),(-1.731,-1.633,1.959),(-1.055,-2.024,1.405),(-1.634,-4.118,1.678),(-1.715,-4.99,1.592),(-1.811,-5.934,1.489),(-1.313,-5.122,1.133),(-1.199,-4.212,1.214),(-1.144,-5.214,.744),(-.97,-5.395,.119),(-.893,-4.514,.074),(-1.039,-4.321,.777),(-.547,-2.112,-.017),(-.719,-2.028,.73),(-1.276,-7.561,.093),(-1.067,-6.345,.153),(-6.258,-6.331,2.562),(-6.313,-5.337,2.466),(-1.776,-1.022,2.021),(-2.323,-1.116,2.33),(-3.285,-.691,2.666),(-3.658,-.737,2.62),(-3.99,-.76,2.622),(-4.284,-2.531,2.863),(-4.246,-3.012,2.901),(-3.693,-2.883,2.652),(-3.752,-2.407,2.644),(-3.254,-2.806,2.505),(-3.18,-3.395,2.458),(-2.889,-3.27,2.429),(-2.949,-2.764,2.481),(-2.528,-3.172,2.316),(-2.571,-2.704,2.366),(-2.507,-3.628,2.261),(-2.087,-3.548,2.061),(-2.107,-3.088,2.115),(-1.608,-3.521,1.751),(-1.627,-3.048,1.805),(-1.164,-3.588,1.305),(-1.109,-3.061,1.353),(-1.076,-2.553,1.375),(-.772,-2.582,.743),(-1.664,-2.595,1.849),(-2.146,-2.64,2.159),(-3.023,-2.289,2.527),(-3.344,-2.346,2.533),(-2.302,-1.298,2.31),(-.946,-3.697,.783),(-.856,-3.14,.76),(-.785,-3.856,.058),(-.702,-3.269,.038),(-.612,-2.681,.026),(-3.092,-1.853,2.567),(-3.433,-1.89,2.561),(-5.473,-1.465,2.555),(-5.5,-1.852,2.59),(-6.032,-1.401,2.174),(-6.054,-1.813,2.223),(-6.474,-1.342,1.774),(-6.457,-1.784,1.874),(-6.603,-1.325,1.612),(-6.628,-1.759,1.66),(-7.097,-1.206,.807),(-7.122,-1.662,.856),(-7.056,-.473,.728),(-7.413,-.123,-.568),(-7.517,-.986,-.464),(-5.423,-.743,2.49),(-5.366,-.077,2.433),(-5.952,-.05,2.016),(-5.996,-.725,2.093),(-7.012,.261,.658),(-2.88,-.227,2.6),(-3.355,-.215,2.686),(-3.751,-.205,2.638),(-4.063,-.174,2.61),(-7.142,1.485,-.762),(-7.309,.738,-.681),(-6.865,1.024,.572),(-6.421,.788,1.387),(-5.909,.661,1.939),(-5.339,.559,2.367),(-4.584,.426,2.591),(-4.135,.355,2.58),(-3.849,.298,2.623),(-3.439,.24,2.674),(-2.933,.168,2.613),(-7.589,-1.577,-.387),(-3.467,-1.717,2.572),(-3.125,-1.646,2.587),(-2.714,-1.564,2.487),(-2.28,-1.481,2.29),(-1.76,-1.401,1.985),(-7.137,-4.706,1.254),(-6.6,-4.718,2.168),(-6.337,-4.674,2.383),(-6.038,-4.63,2.539),(-2.844,-3.711,2.373),(-4.155,-4.68,2.97),(-3.863,-1.643,2.636),(-3.496,-1.568,2.581),(-1.767,-1.21,2.003),(-2.5,-8.757,-2.719),(-1.997,-8.861,-1.883),(-4.63,-8.482,-3.669),(-4.135,-8.607,-3.668),(-6.835,-8.274,-2.108),(-3.446,-8.739,-3.446),(-7.105,-8.213,-1.453),(-7.058,-8.227,-1.715),(-7.262,-8.205,-1.258),(-7.585,-8.192,-.661),(-6.495,-7.68,-2.71),(-6.853,-7.647,-2.191),(-7.019,-7.612,-1.896),(-7.109,-7.582,-1.59),(-7.263,-7.569,-1.405),(-7.568,-7.51,-.808),(-3.392,-8.148,-3.57),(-4.209,-8.176,-3.76),(-4.616,-8.101,-3.754),(-5.672,-7.627,-3.447),(-4.115,-1.089,-5.485),(-6.116,-2.414,-3.48),(-6.181,-2.931,-3.383),(-6.537,-2.831,-2.897),(-6.503,-2.332,-3.002),(-6.005,-1.407,-3.692),(-6.857,-2.791,-2.472),(-6.835,-2.344,-2.519),(-5.29,-2.086,-4.236),(-6.05,-1.898,-3.577),(-4.207,-2.147,-4.688),(-4.222,-2.369,-4.6),(-4.198,-3.012,-4.519),(-4.162,-3.716,-4.407),(-5.267,-3.329,-4.085),(-5.284,-2.702,-4.171),(-3.219,-2.053,-4.614),(-3.211,-2.287,-4.526),(-4.171,-1.617,-5.103),(-4.186,1.354,-6.02),(-4.797,1.923,-5.369),(-4.727,2.545,-5.348),(-5.133,3.589,-4.508),(-5.208,2.962,-4.547),(-5.516,3.331,-3.94),(-5.497,3.916,-3.913),(-5.28,2.321,-4.582),(-5.349,1.556,-4.62),(-5.682,1.955,-3.987),(-5.546,2.731,-3.965),(-5.499,4.445,-3.892),(-5.824,3.528,-3.361),(-5.825,4.132,-3.371),(-5.849,2.922,-3.326),(-6.497,3.073,-2.271),(-6.404,3.748,-2.317),(-6.111,1.644,-3.321),(-6.954,1.227,-2.105),(-6.799,1.842,-2.164),(-6.656,2.421,-2.215),(-7.193,-.506,-1.849),(-7.075,.359,-1.969),(-7.042,-2.814,-2.323),(-6.94,-3.759,-2.324),(-6.652,-3.811,-2.752),(-6.775,-4.789,-2.602),(-7.028,-4.725,-2.169),(-7.471,-2.838,-1.567),(-7.483,-3.714,-1.473),(-3.203,-1.259,-5.353),(-3.201,-1.671,-4.997),(-5.393,-4.22,-3.992),(-4.277,-4.541,-4.34),(-4.393,-5.365,-4.273),(-5.518,-5.11,-3.898),(-3.107,-3.776,-4.326),(-6.404,-4.807,-3.127),(-6.289,-3.873,-3.247),(-5.661,-7.173,-3.539),(-5.634,-6.01,-3.776),(-3.137,-5.354,-4.116),(-3.101,-4.613,-4.213),(-6.512,-5.777,-3.006),(-6.501,-7.034,-2.811),(-7.549,-6.828,-.963),(-7.516,-5.642,-1.234),(-7.185,-4.714,-2.017),(-7.111,-3.765,-2.174),(-7.11,-6.952,-1.734),(-7.112,-5.692,-2.021),(-7.254,-5.663,-1.868),(-7.26,-6.934,-1.56),(-1.092,-5.76,-1.148),(-1.216,-5.825,-1.506),(-1.134,-4.984,-1.588),(-1.026,-4.887,-1.239),(-.873,-4.661,-.436),(-.935,-5.555,-.366),(-.969,-5.695,-.802),(-.919,-4.789,-.89),(-1.157,-2.494,-2.235),(-1.117,-2.937,-2.05),(-1.53,-2.923,-2.815),(-1.468,-5.951,-2.211),(-2.215,-6.297,-3.129),(-2.217,-5.652,-3.295),(-1.461,-5.253,-2.352),(-1.297,-6.593,-1.44),(-1.178,-6.555,-1.101),(-1.471,-7.723,-1.094),(-1.57,-7.737,-1.398),(-3.257,-6.913,-3.819),(-3.163,-6.054,-4.02),(-2.419,-2.206,-4.155),(-2.247,-3.5,-3.852),(-2.378,-7.844,-2.86),(-2.253,-6.971,-2.987),(-1.54,-6.664,-2.104),(-1.771,-7.763,-1.998),(-1.059,-6.516,-.762),(-1.028,-6.44,-.326),(-.525,-2.212,-.667),(-.861,-2.176,-1.729),(-.873,-2.651,-1.61),(-.625,-2.371,-1.179),(-.765,-3.987,-.472),(-.834,-4.115,-.942),(-.743,-3.525,-1.021),(-.68,-3.381,-.535),(-.923,-3.756,-1.376),(-.972,-4.24,-1.316),(-.888,-3.19,-1.479),(-1.107,-3.448,-1.88),(-.667,-2.938,-1.104),(-.607,-2.799,-.597),(-6.002,2.23,-3.345),(-5.757,1.322,-3.992),(-7.314,-1.37,-1.721),(-6.468,-1.838,-3.085),(-1.194,-2.239,-2.382),(-1.575,-2.634,-2.937),(-2.216,-5.042,-3.449),(-3.327,-7.558,-3.689),(-4.272,-7.745,-3.851),(-4.593,-7.721,-3.838),(-1.258,-2.05,-2.539),(-1.603,-2.382,-3.038),(-5.87,-22.113,2.072),(-6.083,-23.597,2.005),(-5.93,-23.656,1.966),(-6.438,-30.876,1.823),(-6.414,-30.99,1.838),(-6.266,-30.994,1.88),(-6.644,-28.48,1.654),(-6.576,-29.708,1.728),(-6.393,-29.845,1.777),(-7.098,-24.84,1.618),(-7.193,-26.461,1.358),(-7.08,-26.532,1.465),(-5.487,-23.014,-2.811),(-5.419,-24.608,-2.457),(-5.783,-24.473,-2.334),(-6.566,-32.494,-.849),(-6.682,-31.364,-.82),(-6.326,-32.553,-1.035),(-6.514,-32.718,2.139),(-6.333,-32.676,2.253),(-6.415,-31.931,2.009),(-7.107,-33.432,-.514),(-6.897,-33.451,-.617),(-7.133,-34.005,-.454),(-7.043,-34.083,-.518),(-5.995,-32.736,-1.652),(-5.957,-33.807,-1.925),(-6.03,-33.791,-1.82),(-6.153,-32.639,-1.287),(-6.176,-33.722,-1.446),(-6.25,-33.66,-1.218),(-6.245,-31.259,-1.334),(-6.807,-32.462,-.77),(-7.352,-33.346,-.141),(-7.432,-33.776,.34),(-7.349,-33.216,.431),(-7.435,-33.855,.287),(-7.411,-34.011,-.137),(-7.132,-33.126,1.078),(-7.112,-32.093,.93),(-7.222,-33.198,.966),(-4.58,-33.092,.602),(-4.666,-33.122,.973),(-4.558,-33.402,.64),(-5.034,-22.243,1.509),(-4.46,-20.666,.888),(-4.84,-20.613,1.294),(-3.888,-19.968,-.024),(-4.164,-20.714,.529),(-3.863,-20.274,.016),(-3.781,-20.771,.103),(-7.926,-24.042,-.713),(-7.649,-26.346,-.542),(-7.901,-24.027,-.47),(-7.207,-16.996,-.498),(-7.203,-17.003,-.236),(-6.339,-18.036,1.967),(-6.436,-18.224,1.877),(-6.281,-18.407,1.992),(-6.071,-17.764,2.337),(-6.212,-17.9,2.138),(-6.032,-18.347,2.219),(-6.5,-27.952,-1.577),(-6.347,-26.297,-1.842),(-6.353,-27.956,-1.653),(-5.746,-28.985,1.623),(-5.544,-30.321,1.573),(-5.649,-29.044,1.594),(-4.298,-20.133,.736),(-3.833,-19.365,-.039),(-4.11,-19.615,.61),(-4.107,-18.523,1.09),(-3.537,-18.153,-.819),(-3.615,-18.498,-.739),(-3.636,-17.678,-1.097),(-3.721,-18.976,-.132),(-4.89,-31.48,.88),(-4.804,-31.561,.648),(-4.883,-30.676,.782),(-4.801,-31.654,.027),(-4.852,-31.673,-.102),(-4.777,-30.758,-.075),(-5.292,-19.414,2.018),(-5.343,-20.6,1.805),(-4.92,-19.514,1.706),(-6.597,-18.597,1.653),(-6.5,-20.108,1.838),(-6.452,-18.837,1.845),(-6.778,-19.923,1.542),(-6.845,-21.693,1.78),(-6.074,-20.383,2.063),(-6.355,-20.214,1.941),(-6.38,-21.912,1.979),(-5.701,-20.57,2.138),(-5.748,-19.192,2.175),(-5.877,-17.661,2.469),(-5.565,-17.866,2.47),(-6.051,-17.328,2.461),(-6.465,-17.35,1.999),(-6.343,-17.229,2.204),(-6.579,-17.243,1.764),(-6.968,-18.254,-1.691),(-6.72,-18.262,-1.916),(-7.027,-19.404,-2.058),(-4.24,-18.527,-1.964),(-4.715,-18.426,-2.198),(-4.595,-17.779,-1.966),(-4.384,-19.698,-2.376),(-4.815,-19.587,-2.555),(-7.693,-26.934,.118),(-7.801,-26.207,.116),(-7.547,-19.433,-1.249),(-7.413,-19.417,-1.547),(-7.927,-21.033,-1.491),(-7.238,-24.601,-2.023),(-7.116,-24.928,-1.798),(-7.872,-24.215,-1.261),(-7.117,-18.241,-1.452),(-7.181,-18.107,-1.276),(-4.28,-26.335,-1.245),(-4.186,-26.025,-1.318),(-4.02,-25.904,-.222),(-6.867,-17.145,.984),(-3.742,-18.395,-1.16),(-3.688,-18.831,-.781),(-3.646,-19.251,-.867),(-3.588,-17.345,-1.154),(-3.748,-17.722,-1.21),(-3.843,-17.644,-1.336),(-5.596,-25.073,-2.22),(-5.826,-30.147,1.752),(-5.907,-28.893,1.702),(-6.087,-28.792,1.722),(-5.982,-30.059,1.8),(-6.073,-27.075,1.748),(-6.245,-27.08,1.77),(-5.771,-31.072,1.789),(-5.916,-31.038,1.85),(-6.055,-25.38,1.899),(-6.216,-25.358,1.922),(-6.492,-23.418,1.953),(-5.632,-23.75,1.761),(-5.485,-22.186,1.792),(-6.602,-25.088,1.844),(-5.714,-25.462,1.71),(-6.699,-26.803,1.655),(-5.794,-27.19,1.638),(-5.678,-32.028,1.93),(-5.849,-31.993,2.084),(-6.135,-31.959,2.082),(-5.389,-32.12,1.66),(-5.506,-31.173,1.593),(-5.55,-32.745,2.11),(-5.817,-32.653,2.324),(-6.678,-31.021,1.654),(-6.63,-31.957,1.783),(-6.101,-32.651,2.321),(-7.029,-28.173,1.465),(-6.876,-29.415,1.563),(-6.694,-30.744,1.632),(-7.24,-27.919,1.274),(-7.157,-29.091,1.32),(-7.031,-30.474,1.344),(-7.324,-28.757,.85),(-7.46,-27.438,.824),(-7.554,-26.3,.868),(-7.629,-24.545,1.017),(-5.733,-29.96,-1.754),(-5.767,-28.188,-1.808),(-5.411,-28.401,-1.76),(-5.492,-30.09,-1.72),(-5.23,-30.278,-1.469),(-5.112,-28.653,-1.574),(-5.675,-26.638,-1.941),(-5.22,-26.838,-1.88),(-6.218,-29.819,-1.55),(-5.537,-31.396,-1.689),(-5.701,-31.368,-1.712),(-5.454,-21.085,-2.84),(-4.834,-21.216,-2.848),(-4.946,-23.518,-2.767),(-4.386,-23.87,-2.562),(-4.247,-21.34,-2.661),(-5.512,-19.466,-2.558),(-6.405,-20.929,-2.746),(-6.533,-22.924,-2.762),(-5.04,-25.127,-2.387),(-4.641,-25.605,-2.181),(-5.171,-25.624,-2.125),(-4.983,-27.013,-1.728),(-4.78,-26.016,-1.967),(-6.385,-25.032,-2.165),(-6.597,-33.508,-.726),(-6.379,-33.539,-.879),(-6.713,-34.227,-.812),(-6.838,-34.183,-.683),(-6.729,-32.795,1.906),(-6.872,-31.994,1.487),(-6.932,-32.914,1.62),(-6.978,-31.04,1.354),(-5.231,-32.876,1.812),(-7.081,-32.382,-.542),(-6.489,-34.33,-1.16),(-6.27,-34.429,-1.624),(-6.085,-34.576,-2.073),(-5.995,-34.599,-2.121),(-5.772,-34.629,-2.129),(-5.769,-33.825,-1.978),(-5.742,-32.798,-1.78),(-6.087,-31.254,-1.5),(-7.051,-31.285,-.561),(-7.242,-32.305,-.15),(-7.191,-31.218,-.078),(-7.228,-32.199,.462),(-7.321,-33.192,.63),(-7.406,-33.808,.504),(-7.214,-32.154,.659),(-7.176,-31.126,.623),(-7.234,-31.175,.378),(-7.258,-33.84,.865),(-7.118,-31.072,.866),(-5.088,-32.227,1.32),(-4.948,-33.046,1.361),(-4.548,-33.483,.364),(-4.547,-33.264,.287),(-4.767,-32.504,.157),(-4.76,-32.415,.579),(-4.781,-33.766,.029),(-4.813,-33.343,-.023),(-4.866,-32.329,.934),(-4.863,-32.538,-.084),(-5.168,-31.348,1.268),(-5.389,-34.552,-1.844),(-5.584,-34.644,-2.054),(-5.609,-33.822,-1.906),(-5.467,-33.746,-1.602),(-5.573,-32.8,-1.734),(-5.379,-32.761,-1.502),(-5.254,-32.629,-.843),(-5.317,-33.575,-.847),(-5.291,-31.399,-1.492),(-5.284,-34.373,-1.101),(-5.013,-33.4,-.283),(-5.014,-34.152,-.444),(-5.038,-32.562,-.33),(-5.205,-31.484,-1.045),(-4.93,-31.647,-.487),(-4.867,-30.695,-.602),(-5.135,-30.351,-1.191),(-7.058,-29.897,-.593),(-6.67,-29.901,-.912),(-7.348,-30.043,.267),(-7.215,-29.959,-.15),(-6.347,-29.796,-1.442),(-5.158,-30.507,1.255),(-4.418,-22.314,1.074),(-3.752,-22.401,.38),(-4.759,-23.985,1.388),(-5.472,-23.793,1.682),(-3.933,-19.787,.027),(-3.679,-18.738,-.722),(-3.699,-17.703,-1.143),(-4.083,-24.207,.517),(-5.068,-25.647,1.326),(-5.589,-25.496,1.636),(-3.277,-22.248,-.646),(-3.422,-20.692,-.767),(-7.968,-24.167,.085),(-7.497,-26.318,-.948),(-8.036,-22.836,-.776),(-7.97,-22.819,-.456),(-7.254,-17.605,-.595),(-7.223,-17.64,-.275),(-7.214,-17.676,.253),(-7.131,-17.014,.272),(-7.349,-18.305,-.688),(-7.3,-18.356,-.308),(-7.112,-16.997,-.93),(-7.18,-17.564,-1.023),(-8.027,-22.784,.167),(-8.035,-22.924,-1.554),(-7.946,-21.084,-.779),(-7.815,-21.11,-.389),(-7.449,-19.538,-.386),(-7.561,-19.481,-.795),(-7.279,-18.169,-1.14),(-7.492,-19.569,.193),(-7.291,-18.396,.198),(-7.823,-21.101,.184),(-6.287,-18.919,1.965),(-6.088,-18.856,2.116),(-6.929,-26.303,-1.514),(-6.9,-28.034,-1.23),(-4.975,-28.867,-1.328),(-4.8,-29.243,-.776),(-4.747,-27.188,-1.575),(-4.529,-27.465,-1.029),(-4.413,-27.672,-.113),(-4.661,-29.439,-.1),(-4.673,-27.494,.68),(-4.867,-29.377,.785),(-4.504,-19.642,1.201),(-5.156,-29.285,1.273),(-5.697,-27.22,1.59),(-5.159,-27.388,1.236),(-6.969,-16.978,-1.131),(-7.069,-17.56,-1.182),(-6.973,-17.557,-1.327),(-6.866,-16.956,-1.274),(-6.925,-17.764,.953),(-6.994,-17.044,.651),(-7.103,-17.726,.62),(-6.738,-17.184,1.322),(-6.768,-17.844,1.315),(-6.982,-18.493,.976),(-7.176,-18.436,.607),(-3.962,-19.165,.513),(-4.286,-19.056,1.128),(-4.489,-18.344,1.799),(-4.698,-18.881,1.731),(-4.962,-18.175,2.25),(-5.134,-18.74,2.106),(-3.808,-18.664,.428),(-3.604,-18.04,.332),(-3.645,-18.598,-.189),(-3.5,-18.032,-.278),(-3.471,-17.767,-.874),(-3.408,-21.954,-1.679),(-3.619,-20.251,-1.632),(-3.565,-24.128,-.398),(-5.643,-18.476,2.292),(-7.011,-23.219,1.758),(-4.66,-17.221,-1.883),(-5.605,-17.039,-2.063),(-5.619,-17.649,-2.17),(-5.623,-18.328,-2.339),(-4.103,-17.432,-1.562),(-4.017,-18.039,-1.56),(-6.297,-16.963,-1.862),(-6.345,-17.595,-1.974),(-6.336,-19.358,-2.401),(-6.385,-18.274,-2.133),(-7.368,-20.855,-2.303),(-6.472,-24.634,-2.413),(-7.436,-22.878,-2.405),(-6.577,-16.937,-1.65),(-6.65,-17.575,-1.751),(-6.766,-16.936,-1.454),(-6.861,-17.557,-1.54),(-7.227,-28.216,-.713),(-4.494,-26.206,-1.744),(-4.35,-25.89,-1.886),(-3.955,-24.068,-2.212),(-3.751,-21.5,-2.33),(-3.66,-24.108,-1.537),(-3.924,-19.869,-2.091),(-3.894,-18.699,-1.602),(-7.523,-28.376,.156),(-7.428,-28.26,-.298),(-7.26,-30.162,.571),(-7.425,-28.566,.501),(-7.578,-27.186,.469),(-7.173,-30.282,.876),(-7.702,-26.256,.498),(-7.56,-22.92,1.193),(-7.823,-24.357,.558),(-7.35,-21.376,1.185),(-7.841,-22.848,.697),(-7.092,-19.743,1.046),(-7.633,-21.231,.702),(-7.344,-19.646,.655),(-4.454,-25.814,.599),(-6.801,-18.592,1.342),(-6.575,-17.977,1.675),(-7.335,-34.301,.619),(-7.377,-34.948,.558),(-7.499,-34.55,1.286),(-7.207,-33.997,1.177),(-5.453,-33.264,2.491),(-5.35,-33.309,2.38),(-7.34,-34.245,.576),(-7.135,-33.829,1.149),(-7.072,-33.595,1.776),(-4.658,-33.866,.713),(-4.769,-33.54,1.062),(-4.768,-33.839,1.102),(-4.687,-33.989,.311),(-7.109,-34.198,-.469),(-7.473,-35.3,4.39),(-7.74,-35.559,4.725),(-7.621,-35.513,4.864),(-7.865,-35.589,4.589),(-7.845,-35.398,4.033),(-7.984,-35.583,4.502),(-7.478,-35.484,4.927),(-7.038,-35.232,4.753),(-7.299,-35.456,5.051),(-7.198,-35.494,5.211),(-7.02,-35.434,5.277),(-6.55,-35.203,5.083),(-6.817,-35.401,5.392),(-6.648,-35.396,5.511),(-6.264,-35.155,5.217),(-6.112,-35.13,5.289),(-6.215,-34.801,4.685),(-5.492,-35.002,5.563),(-5.477,-35.074,5.695),(-5.208,-35.04,5.668),(-5.841,-35.057,5.42),(-5.791,-34.701,4.869),(-7.991,-35.306,3.263),(-8.117,-35.461,3.272),(-8.078,-35.458,3.777),(-8.319,-35.697,3.296),(-5.056,-34.975,4.948),(-4.921,-35.281,5.687),(-4.902,-35.201,4.938),(-4.731,-35.544,4.863),(-4.746,-35.575,5.071),(-5.178,-36.576,4.661),(-4.808,-36.243,4.725),(-4.922,-36.501,4.97),(-7.469,-34.975,3.106),(-7.756,-35.173,3.656),(-6.315,-34.512,4.07),(-6.461,-34.903,4.603),(-8.008,-36.724,3.582),(-8.083,-36.69,3.586),(-7.862,-36.734,2.929),(-7.932,-36.755,4.162),(-7.889,-36.736,3.578),(-7.431,-36.784,4.122),(-6.986,-36.791,4.456),(-6.524,-36.705,4.633),(-6.527,-36.73,4.73),(-5.263,-36.742,4.886),(-5.419,-36.846,5.102),(-5.433,-36.773,4.782),(-5.22,-36.817,5.348),(-5.135,-36.79,5.543),(-5.425,-36.818,5.474),(-5.194,-36.49,4.384),(-5.48,-36.601,4.435),(-7.433,-36.781,3.552),(-4.749,-36.35,5.314),(-5.823,-34.622,4.722),(-7.749,-36.745,2.938),(-7.573,-36.736,2.131),(-4.843,-35.412,3.004),(-4.841,-35.39,2.847),(-4.843,-34.999,3.036),(-4.772,-34.731,2.161),(-4.896,-34.476,2.694),(-4.781,-34.86,2.348),(-5.273,-34.141,3.402),(-5.045,-34.391,3.25),(-5.053,-34.281,3.067),(-4.926,-34.652,3.148),(-4.978,-34.843,3.931),(-5.978,-36.496,1.567),(-5.986,-36.49,1.644),(-6.403,-36.672,1.562),(-5.552,-36.273,3.037),(-5.5,-36.437,3.755),(-5.698,-36.323,3.036),(-4.741,-34.864,1.89),(-4.813,-34.25,1.661),(-4.718,-35.094,1.387),(-4.792,-35.299,1.414),(-4.779,-35.354,.756),(-6.721,-34.62,3.829),(-6.494,-34.161,3.432),(-6.04,-34.002,3.643),(-6.202,-33.503,3.146),(-5.69,-37.221,-.492),(-5.819,-37.234,-1.016),(-5.61,-37.218,-1.007),(-5.391,-37.18,-.986),(-5.549,-37.158,-1.398),(-6.871,-36.767,1.497),(-6.971,-36.728,2.229),(-7.124,-36.758,2.212),(-6.516,-37.178,-1.198),(-6.659,-37.117,-1.254),(-6.457,-37.147,-1.35),(-6.062,-36.898,-1.84),(-6.163,-36.525,-2.072),(-5.905,-36.506,-2.075),(-6.766,-36.354,-1.647),(-6.729,-36.109,-1.68),(-6.423,-36.503,-2.007),(-7.946,-35.677,1.877),(-7.879,-35.552,1.919),(-7.659,-35.768,1.201),(-4.998,-35.718,-.535),(-4.909,-35.569,.137),(-4.944,-35.737,.138),(-7.612,-35.528,1.225),(-7.818,-35.467,1.956),(-7.771,-35.343,1.947),(-7.198,-34.651,-.114),(-7.116,-35.172,-.158),(-5.106,-33.471,2.059),(-5.198,-33.779,2.669),(-5.402,-33.654,2.957),(-5.814,-33.135,2.709),(-5.769,-33.471,3.21),(-4.965,-33.964,2.277),(-6.901,-33.417,2.05),(-6.661,-33.262,2.346),(-7.151,-33.978,2.28),(-7.408,-34.19,1.838),(-6.894,-33.815,2.635),(-6.388,-33.165,2.567),(-6.135,-33.103,2.729),(-6.599,-33.695,2.952),(-6.901,-34.54,-.668),(-6.969,-34.427,-.599),(-7.229,-34.54,-.103),(-6.815,-35.204,-1.035),(-6.25,-35.361,-2.269),(-6.515,-35.267,-1.795),(-6.046,-35.418,-2.343),(-7.381,-34.219,-.139),(-7.423,-34.007,.382),(-5.781,-35.447,-2.315),(-4.898,-33.695,1.512),(-4.739,-34.444,1.261),(-4.724,-34.702,.71),(-4.833,-34.853,.198),(-5.008,-35.109,-.601),(-5.593,-35.455,-2.24),(-5.277,-35.414,-2.003),(-5.129,-35.257,-1.364),(-7.359,-35.532,.47),(-7.593,-35.266,1.256),(-7.362,-35.105,4.04),(-6.334,-35.327,5.554),(-6.926,-35.016,4.348),(-6.086,-35.274,5.589),(-5.817,-35.193,5.642),(-5.396,-34.695,4.97),(-5.455,-34.577,4.738),(-7.895,-35.319,2.724),(-8.04,-35.481,2.7),(-4.821,-35.599,5.722),(-4.912,-35.081,4.506),(-5.105,-34.828,4.6),(-8.501,-36.249,4.318),(-8.387,-36.34,3.553),(-8.291,-36.513,3.599),(-8.42,-36.43,4.373),(-8.256,-36.601,4.405),(-8.192,-36.394,2.841),(-8.078,-36.578,2.892),(-8.535,-35.876,4.172),(-8.432,-35.901,3.339),(-4.714,-35.818,5.149),(-4.794,-35.81,5.732),(-4.809,-36.279,5.865),(-4.708,-35.806,4.807),(-4.884,-36.647,5.432),(-4.906,-36.575,5.955),(-5.001,-36.714,5.155),(-8.298,-35.966,2.721),(-8.434,-35.66,4.19),(-8.194,-35.637,2.681),(-8.173,-35.587,4.317),(-7.087,-34.787,3.589),(-8.146,-36.688,4.435),(-7.547,-36.747,4.652),(-8.035,-36.719,4.481),(-7.925,-36.765,4.331),(-7.403,-36.813,4.323),(-7.134,-36.746,4.824),(-7.006,-36.71,4.168),(-6.588,-36.76,5.063),(-6.517,-36.625,4.338),(-7.024,-36.713,3.589),(-6.005,-36.793,4.855),(-6.057,-36.779,5.258),(-5.983,-36.769,4.732),(-5.945,-36.672,4.414),(-5.983,-36.502,3.727),(-6.617,-36.559,3.679),(-4.843,-36.107,4.284),(-4.725,-35.715,4.35),(-4.76,-35.42,4.401),(-7.332,-36.781,2.972),(-7.037,-36.737,2.991),(-7.318,-36.722,1.466),(-4.824,-35.305,2.102),(-4.996,-35.675,2.713),(-4.992,-35.735,2.988),(-4.796,-35.564,3.814),(-4.824,-35.232,3.854),(-4.896,-35.91,3.76),(-4.933,-35.585,2.019),(-5.275,-36.079,3.01),(-5.242,-35.967,2.582),(-5.701,-36.334,1.724),(-5.729,-36.308,2.383),(-6.051,-36.439,2.312),(-6.085,-36.469,3.036),(-5.469,-36.151,1.808),(-5.516,-36.18,2.457),(-5.684,-36.335,1.59),(-6.593,-36.619,2.264),(-6.676,-36.57,3.022),(-5.058,-36.056,.828),(-5.147,-35.889,1.527),(-5.437,-36.159,1.574),(-5.257,-36.333,.886),(-5.573,-36.644,.926),(-5.18,-35.876,1.919),(-4.897,-35.543,1.456),(-4.856,-35.615,.771),(-5.163,-36.59,.227),(-5.039,-36.225,.171),(-5.197,-36.279,3.761),(-5.198,-34.514,4.038),(-5.631,-33.984,3.647),(-5.523,-34.323,4.227),(-7.416,-34.636,2.432),(-7.608,-34.913,1.933),(-7.181,-34.441,2.831),(-6.799,-34.255,3.212),(-7.694,-35.145,2.644),(-5.938,-34.369,4.221),(-6.166,-37.222,-1.103),(-6.269,-37.222,-.562),(-5.859,-37.096,.221),(-6.527,-37.114,.147),(-6.07,-37.17,-1.493),(-5.78,-37.163,-1.466),(-6.773,-37.143,-.712),(-5.805,-36.765,.962),(-6.199,-36.885,.943),(-5.496,-36.991,.235),(-6.75,-36.932,.874),(-5.338,-36.872,.236),(-5.364,-37.149,-.448),(-5.199,-37.042,-.439),(-5.229,-37.071,-1.023),(-5.445,-37.07,-1.52),(-7.032,-36.996,.038),(-7.178,-36.825,.791),(-7.824,-36.572,2.071),(-7.561,-36.566,1.402),(-7.943,-36.409,2.04),(-7.388,-36.686,.733),(-7.677,-36.416,1.339),(-7.299,-36.846,-.029),(-7.504,-36.527,.687),(-7.037,-37.029,-.787),(-7.387,-36.694,-.128),(-7.14,-36.886,-.877),(-6.717,-37.003,-1.365),(-6.071,-37.08,-1.66),(-6.484,-37.054,-1.512),(-7.378,-35.654,.468),(-7.145,-35.664,-.305),(-6.101,-35.909,-2.304),(-6.383,-35.921,-2.202),(-6.472,-36.791,-1.808),(-6.766,-36.67,-1.564),(-7.128,-36.577,-1.092),(-7.077,-36.178,-1.15),(-6.692,-35.865,-1.714),(-6.876,-35.771,-1.13),(-5.826,-35.923,-2.277),(-6.912,-35.878,-1.13),(-7.344,-36.004,-.388),(-7.169,-35.75,-.319),(-7.415,-36.338,-.32),(-7.607,-36.245,.564),(-7.472,-35.899,.469),(-7.76,-36.172,1.218),(-5.736,-36.916,-1.791),(-5.76,-37.07,-1.641),(-5.375,-36.93,-1.619),(-5.703,-36.497,-2.045),(-5.635,-35.935,-2.208),(-8.025,-36.05,1.889),(-5.134,-36.889,-1.119),(-5.328,-36.525,-1.796),(-5.059,-36.807,-.453),(-5.06,-36.497,-1.225),(-4.974,-36.421,-.474),(-5.082,-35.812,-1.339),(-5.291,-35.901,-1.965),(-7.88,-35.984,6.827),(-7.842,-35.929,6.701),(-7.882,-35.971,6.824),(-8.134,-35.985,6.578),(-8.162,-36.005,6.667),(-8.162,-35.993,6.667),(-8.157,-35.98,6.573),(-7.823,-35.916,6.711),(-6.83,-35.824,7.73),(-6.878,-35.914,7.881),(-6.878,-35.904,7.887),(-6.902,-35.891,7.862),(-6.862,-35.944,7.942),(-6.371,-35.853,7.814),(-6.395,-35.897,7.966),(-6.391,-35.911,7.964),(-6.41,-35.913,8.012),(-6.414,-35.93,8.011),(-6.405,-35.926,8.002),(-6.405,-35.926,8.036),(-5.934,-35.625,7.912),(-5.824,-35.73,7.565),(-5.934,-35.638,7.927),(-5.296,-35.622,8.073),(-5.204,-35.747,7.7),(-5.297,-35.607,8.067),(-7.168,-35.903,7.553),(-7.143,-35.847,7.416),(-7.173,-35.892,7.554),(-7.584,-35.94,7.442),(-7.533,-35.862,7.303),(-7.583,-35.95,7.437),(-7.183,-35.919,7.587),(-7.189,-35.908,7.596),(-7.192,-35.923,7.594),(-7.186,-35.919,7.62),(-7.569,-35.974,7.495),(-7.607,-35.932,7.419),(-8.371,-36.169,5.983),(-8.342,-36.094,5.872),(-8.375,-36.157,5.982),(-8.584,-36.184,5.758),(-8.611,-36.218,5.839),(-8.612,-36.206,5.84),(-8.602,-36.183,5.759),(-8.328,-36.081,5.882),(-7.563,-36.237,6.297),(-7.557,-36.25,6.287),(-7.517,-36.093,6.247),(-7.511,-36.229,6.339),(-7.972,-36.25,5.853),(-7.981,-36.257,5.614),(-7.864,-36.276,5.886),(-8.092,-36.198,5.844),(-7.977,-36.267,5.582),(-8.043,-36.252,5.439),(-8.585,-35.934,4.618),(-8.588,-35.935,4.636),(-8.559,-35.81,4.614),(-8.61,-35.94,4.732),(-8.593,-36.098,4.716),(-8.382,-36.388,5.011),(-8.426,-36.385,4.931),(-8.28,-36.528,4.939),(-8.474,-36.304,4.893),(-8.117,-36.293,5.353),(-8.119,-36.305,5.34),(-8.058,-36.275,5.406),(-8.204,-36.326,5.253),(-8.16,-36.349,5.266),(-8.493,-36.299,4.967),(-8.479,-36.293,4.911),(-8.412,-36.309,5.038),(-8.541,-36.212,4.771),(-8.597,-36.103,4.709),(-8.542,-36.292,5.131),(-8.551,-36.321,5.163),(-8.621,-36.205,5.135),(-8.443,-36.461,5.323),(-8.433,-36.368,5.175),(-8.371,-36.376,5.2),(-8.693,-36.074,5.145),(-8.64,-35.946,4.867),(-8.629,-36.092,4.853),(-8.656,-36.212,5.749),(-8.683,-36.242,5.737),(-8.663,-36.287,5.87),(-8.726,-36.219,5.473),(-8.709,-36.149,5.552),(-8.717,-36.119,5.51),(-8.551,-35.904,4.367),(-8.539,-35.833,4.375),(-8.057,-35.786,5.089),(-8.04,-35.839,5.092),(-7.98,-35.737,4.864),(-8.084,-35.905,5.391),(-8.114,-35.813,5.343),(-8.068,-35.915,5.276),(-8.243,-35.589,4.512),(-8.068,-35.623,4.636),(-8.15,-35.614,4.798),(-8.063,-35.689,4.833),(-7.987,-35.644,4.688),(-7.907,-35.664,4.739),(-7.763,-36.624,5.16),(-7.828,-36.546,5.277),(-7.939,-36.562,5.168),(-7.919,-35.729,4.925),(-8.062,-36.245,5.434),(-8.034,-36.327,5.398),(-7.926,-36.436,5.366),(-8.006,-36.325,5.433),(-8.087,-36.061,5.436),(-8.072,-36.177,5.437),(-8.086,-36.056,5.395),(-7.612,-36.408,6.152),(-7.526,-36.497,6.009),(-7.562,-36.392,6.215),(-7.457,-36.347,6.349),(-7.36,-36.481,6.228),(-7.388,-36.333,6.449),(-7.481,-36.215,6.363),(-7.83,-35.906,6.702),(-7.826,-35.965,6.841),(-7.885,-35.994,6.864),(-7.764,-35.995,6.826),(-7.889,-36.025,6.894),(-7.782,-36.059,6.88),(-8.147,-35.965,6.57),(-8.089,-35.801,6.484),(-8.081,-35.921,6.561),(-8.304,-36.023,6.271),(-8.195,-35.892,6.409),(-8.202,-35.841,6.315),(-7.654,-35.893,6.592),(-7.574,-35.952,6.553),(-7.633,-35.864,6.525),(-7.981,-36.287,5.912),(-8.025,-36.353,6.156),(-7.92,-36.309,5.952),(-8.197,-36.314,6.429),(-8.184,-36.302,6.567),(-8.251,-36.252,6.447),(-7.877,-36.448,5.455),(-8.126,-36.281,6.712),(-8.085,-36.379,6.553),(-7.694,-36.215,6.782),(-7.754,-36.218,6.829),(-7.73,-36.281,6.751),(-7.688,-36.065,6.829),(-7.507,-35.981,6.156),(-7.485,-35.941,6.057),(-7.333,-35.563,5.609),(-7.364,-35.571,5.77),(-7.234,-35.529,5.753),(-7.287,-35.536,5.379),(-7.368,-35.575,5.557),(-7.184,-35.506,5.506),(-7.398,-35.566,5.539),(-7.414,-35.619,5.71),(-7.434,-35.629,5.701),(-7.444,-35.719,5.827),(-7.493,-35.676,6.212),(-7.388,-35.556,6.09),(-7.476,-35.667,6.111),(-7.513,-35.61,5.751),(-7.466,-35.724,5.823),(-7.489,-35.884,6.215),(-7.459,-35.823,5.928),(-7.477,-35.937,6.06),(-7.41,-36.279,6.501),(-7.466,-36.208,6.402),(-7.293,-36.243,6.555),(-7.176,-36.232,6.62),(-7.301,-36.235,6.583),(-7.483,-36.063,6.33),(-7.49,-36.071,6.308),(-6.88,-36.01,6.61),(-6.934,-36.157,6.664),(-6.886,-36.149,6.678),(-6.877,-35.808,6.433),(-6.887,-36.003,6.619),(-6.844,-35.995,6.67),(-6.839,-35.987,6.699),(-6.834,-35.788,6.555),(-7.193,-36.332,6.584),(-7.285,-36.336,6.528),(-7.2,-36.481,6.375),(-7.456,-36.58,5.805),(-7.571,-36.575,5.697),(-7.376,-36.65,5.399),(-7.2,-36.577,6.044),(-6.82,-36.684,5.612),(-7.081,-36.573,6.154),(-7.673,-36.5,5.808),(-7.738,-36.421,5.978),(-7.791,-36.403,5.877),(-6.927,-36.584,6.23),(-6.589,-36.624,6.394),(-6.648,-36.475,6.682),(-6.794,-36.471,6.608),(-6.886,-36.252,6.728),(-6.929,-36.269,6.702),(-7.623,-36.014,7.525),(-7.639,-36.071,7.533),(-7.502,-35.989,7.627),(-7.553,-35.844,7.297),(-7.54,-35.832,7.291),(-7.271,-35.433,6.622),(-7.143,-35.451,6.172),(-7.216,-35.465,6.136),(-7.112,-35.498,5.764),(-6.829,-35.477,5.701),(-6.714,-35.47,5.729),(-6.924,-35.543,5.889),(-6.878,-35.578,6.041),(-6.781,-35.543,5.946),(-6.588,-35.439,5.769),(-6.739,-35.542,6.094),(-6.539,-35.473,5.981),(-6.475,-35.435,6.421),(-6.395,-35.43,5.979),(-6.371,-35.39,5.81),(-6.05,-35.432,5.874),(-6.261,-35.455,6.058),(-6.873,-35.952,7.963),(-6.968,-35.911,7.841),(-6.383,-35.907,7.966),(-6.355,-35.918,7.976),(-6.297,-35.72,7.627),(-6.304,-35.861,7.796),(-6.247,-35.798,7.625),(-6.349,-35.833,7.801),(-6.357,-35.823,7.795),(-6.834,-35.792,7.715),(-6.849,-35.803,7.724),(-6.959,-35.827,7.658),(-6.785,-35.643,7.509),(-6.91,-35.734,7.474),(-6.262,-36.135,7.644),(-6.367,-36.219,7.535),(-6.257,-36.104,7.593),(-6.676,-35.503,6.389),(-6.783,-35.597,6.418),(-6.793,-35.601,6.526),(-6.4,-35.962,8.085),(-6.392,-36.057,8.114),(-6.293,-35.988,7.987),(-6.512,-36.339,8.065),(-6.49,-36.359,8.001),(-6.425,-36.316,8.03),(-6.888,-36.297,7.86),(-6.789,-36.343,7.9),(-6.808,-36.317,7.961),(-5.907,-36.114,6.692),(-5.912,-36.105,6.646),(-5.921,-36.212,6.751),(-5.931,-36.094,6.881),(-5.93,-36.085,6.589),(-5.988,-36.222,6.726),(-5.939,-36.23,6.753),(-6.37,-36.534,6.668),(-6.291,-36.249,6.778),(-6.436,-36.3,6.85),(-6.625,-36.3,6.842),(-6.783,-36.238,6.793),(-6.074,-36.567,6.619),(-5.892,-36.311,6.772),(-6.007,-36.282,6.747),(-4.85,-36.161,6.292),(-4.936,-36.372,6.42),(-4.931,-36.39,6.404),(-5.391,-36.647,6.461),(-5.242,-36.499,6.561),(-5.433,-36.466,6.622),(-6.015,-36.021,8.081),(-6.071,-36.051,7.822),(-6.01,-36.132,7.858),(-5.323,-36.058,8.187),(-5.391,-36,8.245),(-5.407,-36.174,8.108),(-5.226,-36.138,8.041),(-5.954,-35.64,7.974),(-5.957,-35.625,7.917),(-5.979,-35.627,7.911),(-5.922,-35.691,7.594),(-6.034,-35.717,7.662),(-5.909,-35.705,7.525),(-5.851,-35.719,7.552),(-5.282,-35.607,8.088),(-5.153,-35.692,7.76),(-5.188,-35.715,7.728),(-5.317,-35.605,8.144),(-5.266,-35.619,8.102),(-5.815,-35.689,7.515),(-5.183,-35.706,7.666),(-5.081,-35.757,7.859),(-5.114,-35.697,7.786),(-5.8,-35.579,6.226),(-5.813,-35.582,6.21),(-5.83,-35.689,6.274),(-5.983,-35.814,7.145),(-6.019,-35.952,7.121),(-5.993,-35.817,7.193),(-5,-36.576,6.211),(-5.152,-36.614,6.341),(-5.244,-36.748,6.176),(-4.944,-35.574,6.986),(-4.969,-35.541,6.588),(-5,-35.526,6.977),(-4.925,-35.873,7.589),(-4.969,-35.767,7.559),(-5.87,-35.695,6.262),(-5.869,-35.89,6.395),(-5.95,-35.968,8.156),(-5.831,-36.075,8.165),(-5.809,-35.901,8.258),(-6.826,-35.649,6.21),(-6.171,-36.706,5.785),(-6.133,-36.668,6.387),(-6.312,-36.65,6.405),(-5.988,-36.716,5.815),(-6.847,-36.245,6.754),(-5.831,-36.112,8.111),(-5.599,-36.143,8.131),(-6.275,-36.704,5.756),(-4.834,-35.638,6.005),(-4.835,-35.645,6.057),(-4.81,-35.821,6.062),(-6.875,-35.654,6.195),(-6.912,-35.621,6.355),(-6.983,-36.073,7.241),(-6.988,-36.103,7.288),(-7.069,-36.218,7.161),(-7.061,-35.714,7.262),(-7.065,-35.849,7.413),(-7.004,-35.779,7.268),(-7.124,-35.825,7.408),(-7.131,-35.817,7.402),(-7.522,-36.358,7.523),(-7.594,-36.341,7.423),(-7.497,-36.385,7.47),(-7.157,-36.311,7.634),(-7.242,-36.345,7.657),(-7.213,-36.367,7.6),(-7.057,-35.966,7.596),(-7.169,-35.953,7.67),(-7.156,-36.037,7.702),(-7.121,-35.908,7.572),(-7.161,-35.899,7.556),(-8.335,-36.072,5.874),(-8.327,-36.144,5.997),(-8.375,-36.184,6.016),(-8.267,-36.159,5.978),(-8.376,-36.217,6.04),(-8.275,-36.228,6.021),(-8.595,-36.166,5.757),(-8.57,-35.994,5.691),(-8.547,-36.114,5.747),(-8.184,-36.017,5.769),(-8.12,-36.056,5.721),(-8.17,-35.979,5.71),(-8.592,-36.493,5.589),(-8.592,-36.487,5.8),(-8.646,-36.448,5.613),(-8.551,-36.475,5.883),(-8.506,-36.544,5.776),(-8.179,-36.335,5.957),(-8.237,-36.356,5.993),(-8.211,-36.398,5.934),(-8.191,-36.211,5.972),(-8.007,-35.951,6.806),(-8.007,-35.964,6.808),(-8.017,-35.978,6.837),(-8.101,-35.956,6.745),(-8.1,-35.969,6.747),(-7.938,-35.903,6.621),(-8.118,-35.989,6.769),(-8.075,-35.942,6.567),(-8.188,-36.009,6.681),(-7.938,-35.88,6.618),(-6.865,-35.926,7.945),(-6.718,-35.862,7.952),(-6.659,-35.778,7.729),(-6.734,-35.9,8.024),(-6.732,-35.919,8.024),(-6.516,-35.856,7.988),(-6.468,-35.794,7.776),(-6.532,-35.885,8.042),(-6.533,-35.904,8.043),(-6.538,-35.906,8.076),(-6.74,-35.917,8.05),(-6.656,-35.746,7.72),(-5.719,-35.511,7.975),(-5.638,-35.616,7.557),(-5.931,-35.64,7.955),(-5.935,-35.613,7.941),(-5.63,-35.586,7.513),(-5.445,-35.507,8.027),(-5.354,-35.618,7.625),(-5.746,-35.507,8.054),(-5.464,-35.499,8.112),(-5.471,-35.524,8.128),(-5.745,-35.536,8.071),(-5.312,-35.589,8.105),(-5.315,-35.615,8.113),(-5.472,-35.518,8.155),(-5.757,-35.528,8.093),(-5.338,-35.584,7.583),(-6.46,-35.764,7.769),(-7.283,-35.87,7.554),(-7.227,-35.805,7.366),(-7.409,-35.815,7.299),(-7.475,-35.899,7.494),(-7.409,-35.783,7.291),(-7.222,-35.776,7.362),(-7.299,-35.899,7.604),(-7.492,-35.936,7.562),(-7.574,-35.958,7.497),(-7.488,-35.953,7.562),(-7.299,-35.916,7.604),(-7.591,-35.987,7.509),(-7.498,-35.952,7.587),(-7.306,-35.918,7.637),(-8.487,-36.158,5.969),(-8.486,-36.171,5.97),(-8.493,-36.189,5.995),(-8.567,-36.172,5.914),(-8.565,-36.184,5.914),(-8.428,-36.077,5.802),(-8.579,-36.209,5.932),(-8.538,-36.131,5.752),(-8.634,-36.229,5.851),(-8.431,-36.056,5.802),(-7.633,-36.307,6.199),(-7.641,-36.293,6.187),(-7.539,-36.11,6.305),(-7.57,-36.233,6.321),(-7.496,-36.088,6.266),(-7.856,-36.29,5.875),(-7.94,-36.338,5.555),(-7.746,-36.336,6.036),(-7.751,-36.321,6.034),(-7.783,-36.318,6.08),(-7.66,-36.291,6.243),(-8.589,-35.8,4.758),(-8.541,-36.201,4.779),(-8.407,-36.32,5.025),(-8.31,-36.381,5.114),(-8.343,-36.327,5.109),(-8.21,-36.314,5.258),(-8.124,-36.287,5.392),(-8.35,-36.316,5.115),(-8.223,-36.314,5.272),(-8.361,-36.333,5.156),(-8.434,-36.328,5.127),(-8.57,-36.206,4.897),(-8.569,-36.427,5.331),(-8.668,-36.336,5.394),(-8.072,-36.295,5.541),(-8.12,-36.334,5.445),(-8.159,-36.395,5.516),(-8.083,-36.328,5.623),(-8.078,-36.183,5.557),(-8.234,-36.372,5.31),(-8.277,-36.433,5.404),(-8.174,-36.488,5.113),(-8.064,-36.459,5.244),(-8.083,-36.609,4.968),(-8.037,-36.574,5.072),(-8.634,-35.831,4.906),(-8.691,-35.94,5.198),(-8.588,-35.717,4.972),(-8.525,-35.678,4.821),(-8.703,-36.315,5.701),(-8.653,-36.359,5.862),(-8.646,-36.09,5.615),(-8.63,-36.186,5.761),(-8.662,-36.032,5.532),(-8.574,-35.922,5.631),(-8.657,-35.841,5.239),(-8.541,-35.763,5.331),(-8.446,-35.674,4.419),(-8.466,-35.683,4.656),(-8.317,-35.589,4.717),(-8.126,-35.676,5.069),(-8.247,-35.574,5.006),(-8.192,-35.703,5.273),(-8.313,-35.622,5.188),(-8.142,-35.883,5.519),(-8.246,-35.787,5.499),(-8.404,-35.606,4.905),(-7.897,-35.674,4.996),(-7.829,-35.638,4.832),(-7.985,-35.825,5.115),(-8.159,-36.085,5.836),(-8.061,-36.18,5.434),(-8.205,-35.937,5.831),(-8.071,-36.046,5.406),(-8.161,-36.284,6.155),(-8.259,-36.16,6.205),(-8.042,-35.91,5.286),(-8.079,-35.786,5.47),(-7.987,-35.716,5.234),(-7.787,-35.911,6.719),(-7.777,-35.81,6.583),(-7.703,-35.949,6.717),(-7.911,-35.776,6.55),(-8.188,-35.976,6.575),(-8.026,-36.02,6.869),(-8.135,-36.039,6.795),(-8.215,-36.067,6.704),(-8.221,-35.998,6.564),(-8.08,-35.734,6.412),(-8.29,-36.096,6.524),(-8.133,-35.694,5.901),(-7.54,-35.882,6.243),(-7.574,-35.799,6.225),(-7.628,-36.005,6.705),(-7.752,-35.77,6.513),(-7.994,-35.624,5.992),(-7.884,-35.705,6.474),(-7.671,-35.683,6.187),(-7.802,-35.584,6.097),(-7.837,-36.361,6.247),(-8.219,-36.163,6.687),(-8.067,-36.405,6.402),(-7.909,-35.589,5.398),(-7.803,-35.56,5.185),(-7.905,-36.422,6.469),(-7.964,-36.381,6.619),(-8.146,-36.161,6.79),(-8.005,-36.269,6.795),(-8.025,-36.129,6.881),(-7.83,-36.347,6.691),(-7.878,-36.249,6.843),(-7.905,-36.115,6.913),(-7.76,-36.38,6.565),(-7.779,-36.121,6.886),(-7.677,-36.302,6.655),(-7.687,-36.132,6.826),(-7.627,-36.197,6.682),(-7.617,-36.104,6.695),(-7.597,-36.267,6.479),(-7.575,-36.149,6.535),(-7.694,-36.338,6.37),(-7.533,-36.017,6.269),(-7.568,-36.066,6.552),(-7.509,-35.846,6.078),(-7.468,-35.825,5.925),(-7.063,-35.483,5.572),(-7.423,-35.509,5.254),(-7.531,-35.526,5.456),(-7.619,-35.534,5.648),(-7.674,-35.539,5.324),(-7.569,-35.516,5.135),(-7.706,-35.543,5.84),(-7.593,-35.637,5.943),(-7.778,-35.552,5.52),(-7.524,-35.752,6.018),(-7.709,-35.545,5.024),(-8.032,-35.631,5.601),(-7.881,-35.565,5.716),(-7.411,-36.258,6.511),(-7.46,-36.191,6.417),(-7.183,-36.16,6.834),(-7.364,-36.17,6.798),(-7.48,-36.091,6.749),(-7.427,-36.237,6.54),(-7.23,-36.184,6.999),(-7.409,-36.194,6.969),(-7.035,-36.204,6.659),(-7.026,-36.089,6.851),(-7.514,-36.038,6.716),(-7.466,-36.164,6.486),(-7.531,-36.152,6.974),(-7.491,-36.049,6.413),(-7.506,-35.881,6.318),(-7.293,-36.261,6.549),(-7.174,-36.249,6.616),(-7.04,-36.309,6.658),(-7.031,-36.22,6.66),(-6.938,-36.142,6.659),(-7.008,-36.478,6.514),(-6.853,-36.012,6.61),(-6.85,-36.147,6.695),(-6.903,-35.739,6.784),(-6.902,-35.874,6.793),(-6.852,-35.846,6.459),(-6.935,-35.967,6.819),(-6.938,-35.867,7.365),(-6.842,-35.888,7.035),(-6.82,-35.956,7.07),(-6.895,-36.011,7.365),(-6.797,-36.026,7.104),(-6.839,-36.093,7.363),(-6.832,-35.975,6.756),(-6.803,-36.059,6.812),(-6.926,-35.766,7.359),(-6.843,-35.763,6.972),(-6.96,-35.908,7.439),(-6.929,-36.042,7.431),(-6.774,-36.145,6.868),(-6.804,-36.106,6.75),(-6.835,-35.787,6.639),(-6.763,-36.224,6.798),(-6.823,-36.124,6.725),(-7.532,-35.961,6.676),(-7.594,-36.068,6.969),(-7.649,-35.936,6.965),(-7.559,-36.213,7.032),(-7.628,-36.1,7.025),(-7.638,-35.935,7.412),(-7.695,-35.959,7.392),(-7.314,-35.959,7.691),(-7.727,-36.057,7.382),(-7.605,-35.844,7.281),(-7.678,-35.878,7.233),(-7.532,-35.697,7.1),(-7.631,-35.775,7.069),(-7.367,-35.66,7.168),(-7.111,-35.455,6.701),(-7.05,-35.461,6.223),(-7.03,-35.497,5.812),(-6.957,-35.505,6.282),(-7.006,-35.525,6.742),(-7.167,-35.614,7.138),(-7.336,-35.597,7.078),(-6.943,-35.469,5.63),(-6.158,-35.496,6.153),(-6.02,-35.538,6.046),(-6.247,-35.915,7.77),(-6.546,-35.949,8.132),(-6.745,-35.956,8.091),(-6.901,-36.013,7.998),(-7.015,-35.991,7.843),(-6.421,-35.65,7.607),(-6.609,-35.623,7.567),(-6.556,-36.243,7.472),(-6.602,-36.36,7.747),(-6.772,-36.326,7.702),(-6.742,-36.206,7.433),(-6.908,-36.254,7.663),(-6.869,-36.154,7.429),(-6.641,-36.378,7.943),(-6.405,-36.334,7.828),(-6.723,-36.146,7.366),(-6.543,-36.168,7.398),(-6.372,-36.137,7.442),(-6.498,-36.156,7.167),(-6.328,-36.107,7.168),(-6.248,-36.038,7.494),(-6.218,-35.985,7.122),(-6.217,-35.98,7.62),(-6.199,-35.922,7.506),(-6.171,-35.891,7.091),(-6.23,-36.019,7.703),(-6.217,-35.869,7.626),(-6.192,-35.825,7.505),(-6.153,-35.755,7.081),(-6.212,-35.752,7.5),(-6.179,-35.643,7.068),(-6.269,-35.668,7.509),(-6.401,-35.601,7.502),(-6.231,-35.527,7.046),(-6.677,-35.455,6.892),(-6.807,-35.566,6.908),(-6.385,-36.2,8.092),(-6.538,-36.234,8.13),(-6.539,-36.083,8.153),(-6.271,-36.136,7.95),(-6.314,-36.264,7.881),(-6.675,-36.336,8.032),(-6.71,-36.245,8.099),(-6.74,-36.087,8.125),(-6.851,-36.254,8.011),(-6.89,-36.128,8.014),(-6.963,-36.23,7.853),(-7.005,-36.101,7.848),(-6.982,-36.149,7.654),(-5.829,-35.347,5.872),(-6.29,-35.453,6.498),(-6.195,-35.508,6.55),(-6.122,-35.562,6.249),(-6.5,-35.402,6.944),(-6.332,-35.444,7.013),(-6.956,-35.812,7.451),(-7.02,-35.899,7.642),(-6.745,-35.58,7.398),(-6.88,-35.673,7.358),(-7.021,-36.011,7.646),(-6.67,-36.144,7.152),(-6.622,-36.206,6.906),(-6.575,-35.562,7.457),(-6.622,-36.275,6.844),(-5.868,-35.902,6.604),(-5.86,-35.899,6.476),(-6.132,-35.992,6.582),(-6.207,-36.162,6.735),(-6.146,-35.756,6.641),(-6.177,-35.955,6.742),(-6.44,-36.283,6.852),(-6.456,-36.211,6.917),(-6.335,-36.181,6.902),(-6.304,-36.24,6.788),(-6.221,-36.154,6.744),(-6.241,-36.1,6.843),(-6.142,-35.986,6.602),(-5.878,-36.291,6.78),(-6.074,-35.859,6.434),(-6.097,-35.809,6.475),(-6.158,-35.632,6.598),(-6.096,-35.669,6.351),(-6.011,-35.686,6.272),(-6.008,-35.632,6.176),(-4.996,-36.422,6.471),(-4.993,-36.442,6.456),(-4.893,-36.324,6.584),(-4.844,-36.04,6.585),(-4.841,-36.204,6.153),(-5.238,-36.477,6.574),(-4.958,-36.391,6.591),(-5.237,-36.475,6.666),(-5.433,-36.444,6.635),(-5.648,-36.365,6.7),(-5.66,-36.386,6.692),(-5.444,-36.44,6.733),(-5.785,-36.591,6.582),(-5.649,-36.366,6.798),(-5.891,-36.211,6.902),(-5.961,-35.883,6.87),(-6.004,-36.158,7.419),(-6.055,-36.062,7.416),(-6.056,-35.895,8.028),(-6.108,-35.957,7.774),(-5.831,-36.267,7.891),(-6.073,-35.968,7.434),(-5.779,-36.387,7.487),(-5.953,-36.146,7.13),(-6.015,-36.043,7.125),(-5.701,-36.307,7.137),(-5.816,-35.656,6.536),(-5.884,-35.695,6.868),(-5.583,-36.339,7.847),(-5.809,-35.764,8.243),(-5.522,-35.772,8.304),(-5.492,-35.62,8.259),(-5.789,-35.631,8.196),(-5.35,-35.686,8.256),(-5.369,-35.858,8.285),(-5.562,-35.931,8.283),(-5.976,-35.844,8.115),(-5.977,-35.721,8.05),(-6.044,-35.761,7.954),(-6.095,-35.82,7.712),(-6.052,-35.829,7.455),(-5.464,-36.379,7.085),(-5.221,-36.412,7.033),(-4.93,-36.338,6.893),(-5.533,-36.426,7.453),(-5.283,-36.428,7.418),(-4.919,-36.359,7.298),(-5.328,-36.365,7.803),(-5.057,-36.277,7.71),(-5.269,-35.919,8.215),(-5.153,-36.021,8.032),(-4.982,-36.174,7.697),(-5.255,-35.747,8.206),(-5.087,-35.853,7.96),(-5.09,-35.622,7.475),(-5.047,-35.558,7.302),(-5.188,-35.444,6.965),(-5.22,-35.499,7.28),(-5.485,-35.43,6.945),(-5.573,-35.49,7.245),(-5.163,-35.404,6.589),(-4.97,-35.619,7.307),(-5.261,-35.536,7.388),(-5.595,-35.539,7.355),(-5.023,-35.692,7.533),(-4.908,-35.987,7.636),(-5.867,-35.492,6.07),(-5.875,-35.595,6.175),(-5.52,-35.244,6.04),(-5.732,-35.448,6.151),(-5.727,-35.441,6.172),(-5.525,-35.253,6.085),(-5.186,-35.189,6.082),(-5.191,-35.177,6.023),(-5.483,-35.299,6.314),(-5.665,-35.421,6.299),(-5.775,-35.563,6.316),(-5.173,-35.268,6.301),(-5.608,-35.464,6.544),(-5.436,-35.391,6.555),(-5.769,-35.603,7.296),(-5.816,-35.681,6.362),(-5.734,-35.549,6.535),(-5.662,-35.491,6.91),(-5.788,-35.57,6.883),(-5.751,-35.562,7.203),(-5.88,-35.634,7.169),(-5.909,-35.676,7.261),(-5.998,-35.743,7.477),(-4.872,-36.272,6.888),(-4.832,-35.981,6.882),(-4.856,-36.293,7.297),(-4.795,-36.048,7.263),(-4.932,-35.368,5.985),(-4.812,-35.827,6.285),(-4.927,-35.381,6.061),(-4.921,-35.452,6.332),(-4.875,-35.702,6.58),(-4.832,-35.676,6.303),(-4.835,-35.825,6.58),(-4.863,-35.732,6.933),(-4.835,-35.832,6.907),(-4.877,-35.748,7.305),(-4.832,-35.845,7.297),(-5.189,-36.755,5.931),(-5.889,-36.68,6.363),(-5.48,-36.725,6.301),(-5.441,-36.766,5.907),(-7.427,-35.506,6.559),(-6.958,-35.94,7.269),(-6.973,-35.98,7.343),(-7.019,-36.098,7.569),(-7.044,-36.24,7.505),(-6.969,-35.84,7.274),(-7.003,-35.891,7.4),(-6.939,-35.885,7.169),(-6.975,-36.005,7.152),(-7.116,-36.332,7.428),(-7.075,-36.129,7.073),(-7.186,-35.663,7.226),(-7.034,-35.663,7.163),(-6.97,-35.734,7.162),(-6.943,-35.798,7.169),(-7.494,-35.633,7.009),(-7.597,-35.728,6.969),(-7.534,-35.64,6.564),(-7.678,-35.883,7.038),(-7.646,-35.839,6.961),(-7.544,-35.851,6.623),(-7.727,-35.977,7.201),(-7.671,-35.973,7.027),(-7.722,-36.075,7.212),(-7.684,-36.198,7.222),(-7.603,-36.3,7.24),(-7.426,-36.258,7.029),(-7.462,-36.368,7.271),(-7.24,-36.265,7.067),(-7.292,-36.382,7.315),(-7.673,-36.273,7.408),(-7.725,-36.151,7.393),(-7.573,-36.292,7.562),(-7.397,-36.358,7.604),(-7.353,-36.402,7.528),(-7.444,-36.26,7.657),(-7.281,-36.232,7.707),(-7.297,-36.078,7.719),(-7.488,-36.108,7.667),(-7.134,-36.177,7.69),(-7.623,-36.162,7.552),(-6.943,-35.633,6.768),(-8.298,-36.072,5.889),(-8.303,-35.961,5.774),(-8.219,-36.093,5.881),(-8.424,-35.947,5.749),(-8.497,-36.233,6.02),(-8.588,-36.262,5.951),(-8.101,-35.96,5.538),(-8.151,-36.134,5.859),(-8.287,-35.911,5.712),(-8.412,-35.869,5.685),(-8.377,-35.707,5.43),(-8.467,-36.543,5.552),(-8.33,-36.523,5.606),(-8.402,-36.526,5.834),(-8.588,-36.356,5.95),(-8.448,-36.445,5.957),(-8.488,-36.317,6.033),(-8.303,-36.48,5.891),(-8.341,-36.407,5.998),(-8.383,-36.293,6.057),(-8.211,-36.465,5.696),(-8.264,-36.285,6.02),(-8.148,-36.394,5.786),(-8.177,-36.273,5.964),(-8.118,-36.297,5.821),(-8.121,-36.214,5.843),(-8.088,-36.226,5.686),(-8.088,-36.086,5.55),(-8.099,-36.155,5.71),(-8.472,-35.655,5.071),(3.966,-16.717,1.665),(4.19,-17.624,1.763),(4.164,-16.975,1.983),(4.277,-16.422,2.112),(5.027,-16.178,2.774),(4.864,-16.271,2.669),(4.991,-16.961,2.736),(4.793,-17.02,2.626),(4.668,-16.423,2.521),(4.525,-16.688,2.405),(6.708,-15.107,-1.272),(6.727,-14.423,-1.282),(6.764,-15.123,-1.155),(5.413,-13.143,2.759),(5.5,-13.079,2.768),(5.277,-12.431,2.861),(4.922,-14.359,2.666),(4.632,-15.293,2.527),(4.936,-15.017,2.671),(3.877,-16.123,1.56),(4.353,-16.067,2.194),(4.284,-15.729,2.122),(3.275,-15.519,.681),(3.519,-16.314,.884),(3.406,-15.354,1.078),(3.766,-15.694,1.472),(2.788,-13.583,.634),(2.527,-12.332,.746),(2.758,-13.69,.512),(2.558,-12.196,1.115),(2.621,-11.094,-1.558),(2.859,-13.196,-1.447),(2.415,-11.097,-1.125),(6.418,-15.904,2.419),(6.441,-16.212,2.423),(6.628,-16.027,2.004),(7.286,-10.688,1.589),(6.924,-10.448,2.586),(6.902,-10.962,2.614),(3.989,-13.183,2.724),(4.506,-13.416,2.857),(4.523,-12.826,2.98),(4.64,-10.611,2.869),(4.829,-11.701,2.931),(4.911,-11.661,2.922),(2.63,-10.491,1.236),(2.76,-13.17,1.185),(2.804,-12.811,1.521),(2.656,-12.05,1.481),(3.266,-14.171,2.048),(3.476,-14.126,2.25),(3.192,-13.452,2.127),(3.746,-13.884,2.501),(3.892,-13.632,2.623),(3.543,-13.392,2.439),(3.573,-12.417,2.549),(5.05,-10.734,2.971),(5.19,-10.125,3.079),(4.828,-10.192,3.009),(5.182,-13.309,2.736),(5.061,-12.551,2.832),(5.032,-13.398,2.737),(4.996,-13.604,-1.829),(5.178,-12.613,-2.063),(5.409,-13.586,-1.773),(4.276,-15.604,-1.661),(4.267,-15.23,-1.715),(4.614,-15.272,-1.736),(4.007,-12.817,-2.28),(3.756,-12.866,-2.17),(3.609,-10.979,-2.805),(4.022,-13.358,-2.137),(3.279,-12.997,-1.874),(3.554,-14.079,-1.782),(3.301,-14.196,-1.615),(6.604,-14.095,2.155),(6.3,-13.948,2.411),(6.271,-14.137,2.396),(6.685,-15.889,1.732),(6.741,-16.436,1.7),(6.751,-15.871,1.672),(3.838,-16.844,-1.213),(3.787,-16.435,-1.305),(3.895,-16.285,-1.388),(7.287,-11.155,1.596),(7.608,-10.642,.714),(7.208,-14.547,.385),(7.211,-13.853,.489),(7.104,-14.607,.774),(7.158,-13.911,1.237),(7.346,-12.763,1.05),(7.263,-12.774,1.386),(7.032,-13.411,1.775),(7.149,-12.714,1.866),(6.156,-12.967,2.803),(6.515,-12.672,2.79),(6.046,-12.408,2.941),(6.743,-13.776,2.1),(6.681,-13.554,2.279),(6.627,-13.799,2.23),(6.872,-11.528,2.641),(6.985,-12.625,2.375),(5.397,-11.365,2.951),(5.455,-12.326,2.862),(5.557,-12.256,2.897),(5.441,-10.413,2.981),(6.042,-15.88,2.676),(5.977,-15.312,2.604),(5.793,-15.341,2.66),(4.111,-13.946,-1.996),(4.03,-13.972,-1.96),(6.781,-13.719,-1.325),(6.804,-14.378,-1.123),(5.273,-14.204,2.662),(5.474,-13.447,2.73),(5.638,-14.971,-1.506),(5.628,-15.798,-1.636),(5.236,-15.04,-1.521),(2.425,-10.454,.992),(2.298,-10.4,.679),(2.436,-12.509,.342),(4.846,3.001,2.319),(4.22,2.092,2.55),(1.768,-.801,2.069),(3.61,1.194,2.694),(2.443,-.205,2.431),(2.186,-10.863,-.057),(1.64,-8.538,.487),(1.52,-8.669,.073),(3.242,-9.752,2.288),(3.661,-9.482,2.54),(3.226,-7.981,2.243),(2.764,-10.156,1.656),(2.784,-8.154,1.81),(5.786,-8.664,2.946),(5.628,-8.706,3.001),(3.03,-9.944,2.01),(2.139,-8.221,1.316),(1.836,-8.392,.896),(4.338,2.138,2.508),(4.395,-1.387,2.821),(3.901,-1.321,2.676),(3.88,-1.469,2.678),(2.969,.585,2.661),(3.37,-6.665,2.401),(3.012,-5.63,2.284),(3.119,-6.806,2.263),(2.898,-6.892,2.047),(6.559,-.611,1.588),(6.517,.065,1.507),(6.495,-.619,1.668),(4.595,-.76,2.767),(4.519,-.121,2.707),(4.457,-.753,2.764),(3.839,-1.766,2.684),(3.819,-1.914,2.687),(4.346,-1.997,2.875),(3.628,-4.111,2.65),(3.151,-3.815,2.471),(3.134,-4.044,2.447),(2.622,-4.83,2.242),(2.669,-5.621,2.178),(2.751,-4.81,2.29),(5.785,-4.514,2.789),(4.996,-4.227,3.089),(5.028,-4.605,3.124),(3.729,-7.7,2.519),(3.642,-6.562,2.555),(1.989,-7.077,1.433),(2.182,-6.987,1.591),(1.835,-8.912,-1.002),(1.916,-8.904,-1.269),(6.568,-8.322,-2.49),(5.776,-8.443,-3.169),(5.764,-8.04,-3.255),(4.247,.043,-5.912),(3.97,-.383,-5.85),(4.237,.588,-5.999),(4.906,-.511,-5.239),(4.948,.407,-5.394),(5.502,-.069,-4.656),(6.313,.173,-3.265),(6.412,-.674,-3.248),(5.959,-.379,-3.948),(5.808,-.838,-4.077),(6.296,4.406,-2.343),(5.407,-1.365,-4.406),(5.331,-1.95,-4.258),(5.167,-1.44,-4.621),(1.337,-1.912,-2.699),(1.605,-2.137,-3.058),(4.432,-7.231,-3.87),(4.573,-6.213,-4.119),(4.646,-7.285,-3.844),(6.932,-7.012,-2.169),(6.944,-5.724,-2.363),(7.041,-6.986,-1.972),(4.872,1.138,-5.376),(5.414,.839,-4.627),(5.845,.56,-3.959),(5.799,4.561,-3.389),(6.632,-.384,-2.796),(6.789,-.995,-2.62),(6.215,1.019,-3.276),(6.457,.236,-2.985),(6.838,-1.892,-2.503),(6.93,-1.903,-2.428),(6.995,-2.355,-2.348),(7.411,-2.088,-1.586),(1.489,-3.922,-2.531),(1.517,-3.463,-2.63),(2.262,-4.357,-3.596),(7.684,-4.409,-.062),(7.687,-4.832,-.032),(7.536,-4.569,-1.281),(1.138,-4.033,-1.707),(1.467,-4.559,-2.364),(1.125,-4.365,-1.634),(1.346,-7.666,-.3),(1.432,-7.73,-.718),(1.754,-8.921,-.734),(3.164,-3.105,-4.374),(2.357,-2.952,-3.949),(2.4,-2.599,-4.027),(2.323,-3.241,-3.885),(3.936,-17.781,1.175),(3.716,-17.071,1.065),(4.398,-17.813,2.063),(4.402,-17.266,2.268),(3.262,-16.517,-.392),(3.408,-17.228,-.24),(3.468,-17.208,.375),(3.295,-16.476,.22),(3.378,-16.391,-1.004),(3.475,-17.055,-.854),(5.428,-16.026,2.784),(5.488,-16.664,2.819),(4.876,-17.548,2.562),(5.546,-17.212,2.787),(4.663,-17.399,2.497),(6.108,-16.952,2.705),(6.081,-16.405,2.715),(6.474,-16.709,2.427),(6.669,-16.551,1.991),(6.528,-14.318,-1.538),(6.527,-14.977,-1.477),(6.84,-15.03,-1.015),(6.75,-15.686,-1.241),(6.812,-15.712,-1.112),(7.028,-16.406,-.918),(6.925,-15.74,-.946),(7.131,-15.786,-.621),(7.201,-16.445,-.659),(6.922,-16.373,-1.072),(7.089,-15.083,-.566),(7.281,-15.812,-.08),(7.315,-16.439,-.126),(7.076,-16.469,.871),(7.06,-15.846,.837),(7.005,-15.82,1.078),(6.971,-16.495,1.141),(7.247,-16.431,.431),(7.237,-15.794,.349),(7.044,-15.24,1.026),(7.063,-15.209,.811),(6.951,-16.404,1.239),(6.974,-15.788,1.208),(5.662,-12.967,2.784),(5.911,-13.385,2.662),(5.786,-13.504,2.667),(5.781,-12.818,2.813),(5.149,-11.489,2.941),(4.568,-15.052,2.53),(4.855,-14.275,2.667),(4.704,-15.72,2.545),(4.96,-15.526,2.68),(5.34,-14.885,2.685),(4.212,-15.522,2.093),(3.005,-14.638,.722),(2.944,-14.747,.432),(3.328,-15.163,1.213),(3.018,-14.444,.838),(2.643,-13.792,.314),(3.12,-15.671,.111),(2.889,-14.881,.003),(4.108,-15.353,2.133),(3.667,-15.472,1.554),(4.454,-14.932,2.561),(3.847,-14.848,2.252),(3.412,-14.882,1.806),(4.902,-13.405,2.79),(4.729,-14.214,2.707),(4.929,-12.632,2.874),(4.38,-13.955,2.754),(3.121,-15.76,-.499),(2.939,-15.036,-.555),(3.275,-15.651,-1.135),(2.777,-14.252,-.619),(2.61,-14.074,-.082),(3.12,-15.002,-1.202),(2.402,-12.712,-.149),(2.54,-12.936,-.735),(2.337,-11.083,-.731),(3.007,-14.316,-1.283),(3.499,-15.527,-1.39),(3.588,-16.195,-1.265),(3.368,-14.877,-1.505),(2.924,-10.992,-2.195),(5.381,-15.406,2.707),(6.376,-15.36,2.39),(6.315,-14.645,2.404),(5.935,-14.74,2.602),(6.602,-15.384,2.049),(6.595,-14.623,2.108),(5.882,-14.148,2.589),(5.697,-14.797,2.661),(5.597,-14.175,2.647),(6.02,-13.191,2.715),(6.337,-13.679,2.46),(6.102,-10.409,2.905),(6.022,-11.154,2.933),(5.973,-11.964,2.968),(3.151,-14.644,1.543),(4.186,-14.485,2.595),(4.336,-11.939,2.983),(4.059,-10.882,2.775),(2.926,-14.027,1.23),(2.925,-13.622,1.649),(3.066,-12.618,2.024),(2.974,-11.722,1.943),(3.084,-14.189,1.824),(3.379,-11.336,2.399),(6.093,-12.618,-1.907),(5.064,-10.786,-2.894),(6.015,-10.766,-2.539),(6.132,-13.622,-1.696),(4.275,-10.867,-2.934),(4.329,-12.733,-2.312),(6.582,-12.607,-1.768),(6.607,-10.705,-2.095),(4.395,-13.762,-2.042),(5.095,-14.283,-1.62),(4.483,-14.494,-1.874),(4.182,-13.829,-2.065),(4.718,-16.016,-1.657),(4.225,-14.543,-1.883),(5.499,-14.238,-1.581),(5.72,-16.463,-1.777),(4.806,-16.65,-1.681),(4.322,-16.8,-1.456),(4.318,-16.111,-1.559),(6.394,-16.347,-1.637),(6.294,-15.709,-1.609),(6.53,-13.673,-1.629),(6.857,-12.611,-1.523),(6.927,-10.715,-1.778),(6.17,-14.268,-1.586),(6.204,-14.954,-1.53),(6.581,-15.685,-1.425),(6.656,-16.332,-1.419),(6.837,-16.34,-1.228),(4.05,-16.942,-1.299),(4.116,-16.207,-1.484),(4.12,-14.573,-1.837),(4.121,-15.235,-1.678),(3.599,-14.766,-1.644),(3.871,-14.649,-1.744),(3.898,-15.342,-1.595),(3.685,-15.44,-1.501),(3.852,-13.936,-1.916),(4.03,-15.259,-1.648),(4.029,-14.599,-1.8),(3.744,-16.032,-1.389),(3.917,-15.855,-1.493),(7.251,-15.143,-.011),(7.073,-14.459,-.541),(7.25,-14.515,.045),(7.226,-13.855,-.007),(7.086,-13.798,-.555),(7.218,-15.141,.346),(7.176,-12.611,-.614),(7.266,-12.639,-.14),(7.238,-10.634,-1.017),(7.312,-10.637,-.682),(7.35,-12.57,.215),(7.434,-10.651,-.368),(7.4,-12.677,.633),(7.195,-13.899,.905),(6.399,-13.434,2.526),(6.721,-14.108,1.959),(6.687,-15.342,1.773),(3.918,-16.9,-1.236),(3.981,-16.243,-1.429),(3.672,-16.723,-1.158),(4.017,-15.763,-1.543),(7.103,-14.634,.988),(6.707,-14.63,1.864),(6.753,-15.331,1.713),(6.773,-14.634,1.801),(7.555,-10.609,.106),(7.062,-14.667,1.214),(7.009,-15.266,1.194),(6.901,-15.299,1.483),(6.936,-14.659,1.545),(6.851,-16.514,1.497),(6.88,-15.928,1.467),(6.984,-14.034,1.642),(6.881,-13.11,2.311),(6.776,-13.361,2.306),(6.826,-13.686,2.066),(6.621,-12.999,2.637),(6.507,-13.206,2.6),(6.797,-14.086,1.904),(4.102,-15.713,-1.577),(1.486,-6.089,1.103),(1.251,-6.252,.664),(1.452,-7.451,.578),(1.661,-7.276,.989),(5.711,3.451,1.756),(6.048,3.766,1.12),(6.281,4.166,.195),(5.263,3.197,2.182),(4.03,1.331,2.627),(1.013,-1.308,1.431),(.599,-1.361,.384),(.63,-1.608,.382),(1.013,-1.519,1.481),(.412,-1.382,-.374),(.436,-1.62,-.377),(.363,-1.411,-.728),(.413,-1.671,-.693),(.469,-1.553,-1.226),(.542,-1.863,-1.196),(.591,-1.179,.39),(1.009,-1.14,1.389),(.374,-1.189,-.374),(.334,-1.222,-1.095),(.415,-1.333,-1.255),(.821,-1.699,-1.89),(.817,-1.897,-1.792),(6.147,-8.566,2.82),(6.742,-8.447,2.501),(6.653,-7.404,2.475),(6.226,-7.417,2.78),(5.884,-7.466,2.897),(7.239,-8.303,1.575),(7.217,-7.419,1.531),(5.139,-7.476,3.308),(4.265,-7.602,3.1),(4.524,-9.003,3.078),(5.167,-8.766,3.24),(4.123,-9.233,2.707),(2.431,-8.132,1.615),(5.706,-7.424,2.981),(7.729,-8.187,.336),(7.72,-7.454,.252),(5.76,2.763,1.768),(6.117,3.045,1.17),(5.267,2.516,2.205),(6.307,1.579,1.331),(6.198,2.315,1.234),(5.805,2.089,1.789),(5.852,1.396,1.88),(6.397,3.395,.293),(6.669,3.773,-1.041),(6.943,2.225,-.821),(6.771,2.955,-.909),(6.537,2.555,.42),(6.696,1.808,.512),(7.193,-2.679,1.033),(7.668,-2.718,-.185),(7.644,-2.139,-.257),(7.162,-2.132,.968),(5.267,1.835,2.238),(5.299,1.209,2.311),(4.767,2.307,2.388),(4.688,1.615,2.467),(4.631,1.036,2.542),(4.868,-2.677,2.944),(5.583,-2.766,2.733),(5.537,-2.2,2.681),(4.783,-2.095,2.891),(4.264,1.443,2.555),(4.196,.913,2.581),(6.116,-2.76,2.403),(6.086,-2.185,2.329),(6.692,-2.707,1.837),(6.664,-2.153,1.765),(4.909,-3.177,2.991),(4.963,-3.82,3.051),(5.732,-4.056,2.774),(5.656,-3.393,2.753),(4.722,-1.747,2.86),(4.672,-1.399,2.828),(4.365,-1.692,2.848),(6.092,-3.507,2.492),(6.07,-4.174,2.571),(6.433,-2.744,2.158),(6.452,-2.186,2.032),(6.663,-3.498,2.004),(6.635,-4.271,2.167),(7.169,-4.269,1.279),(7.181,-3.474,1.156),(7.676,-3.564,-.124),(6.373,-4.223,2.399),(6.402,-3.509,2.283),(6.61,-5.28,2.349),(6.632,-6.357,2.413),(7.195,-6.535,1.487),(7.164,-5.332,1.418),(4.217,-3.682,2.994),(4.196,-4.145,3.017),(5.824,-5.23,2.822),(5.066,-5.173,3.171),(5.099,-6.237,3.234),(5.772,-6.198,2.892),(3.66,-3.545,2.676),(3.556,-5.424,2.592),(3.594,-4.731,2.623),(3.075,-4.808,2.369),(4.205,-6.407,3.085),(4.152,-5.356,3.071),(2.827,-4.085,2.385),(3.548,-1.246,2.641),(3.52,-1.396,2.632),(7.71,-6.721,.167),(7.695,-5.53,.031),(6.028,-5.245,2.692),(5.964,-6.234,2.783),(3.935,.827,2.639),(2.542,-4.081,2.278),(2.127,-4.093,2.055),(2.178,-4.87,1.973),(2.226,-5.752,1.867),(2.55,-6.877,1.896),(3.528,.725,2.702),(3.204,-1.115,2.679),(3.17,-1.304,2.656),(3.145,-1.465,2.642),(2.751,-1.2,2.56),(2.731,-1.374,2.543),(2.342,-.897,2.382),(2.39,-.569,2.402),(2.776,-.992,2.578),(2.825,-.616,2.602),(2.212,-2.151,2.262),(2.642,-2.203,2.468),(2.685,-1.767,2.505),(2.252,-1.7,2.302),(1.731,-1.629,1.994),(1.7,-2.101,1.944),(1.041,-2.02,1.439),(1.741,-4.989,1.655),(1.653,-4.116,1.733),(1.839,-5.933,1.551),(1.221,-4.218,1.267),(1.342,-5.127,1.195),(1.064,-4.331,.831),(.923,-4.53,.128),(1.006,-5.411,.181),(1.176,-5.223,.806),(.69,-2.021,.762),(.503,-2.1,.013),(1.109,-6.36,.212),(1.327,-7.576,.164),(6.328,-5.295,2.558),(6.28,-6.288,2.662),(1.754,-1.009,2.051),(2.317,-1.104,2.364),(3.274,-.669,2.701),(3.648,-.712,2.657),(3.98,-.733,2.66),(3.764,-2.382,2.698),(3.698,-2.858,2.707),(4.251,-2.981,2.959),(4.296,-2.499,2.919),(2.963,-2.745,2.536),(2.898,-3.253,2.483),(3.19,-3.375,2.514),(3.269,-2.785,2.561),(2.585,-2.689,2.42),(2.537,-3.159,2.367),(2.1,-3.54,2.114),(2.52,-3.615,2.316),(1.638,-3.046,1.851),(1.622,-3.519,1.801),(2.117,-3.079,2.163),(1.1,-3.056,1.396),(1.157,-3.584,1.353),(.768,-2.584,.792),(1.07,-2.547,1.424),(1.679,-2.591,1.9),(2.16,-2.63,2.212),(3.034,-2.269,2.578),(3.355,-2.324,2.585),(2.297,-1.286,2.345),(.832,-3.131,.813),(.942,-3.698,.83),(.702,-3.276,.093),(.786,-3.864,.106),(.608,-2.69,.064),(3.09,-1.833,2.611),(3.432,-1.868,2.607),(5.498,-1.814,2.645),(5.468,-1.428,2.607),(6.053,-1.774,2.281),(6.029,-1.363,2.228),(6.458,-1.745,1.934),(6.473,-1.303,1.83),(6.629,-1.72,1.72),(6.602,-1.288,1.668),(7.127,-1.627,.917),(7.099,-1.171,.865),(7.524,-.958,-.406),(7.414,-.098,-.526),(7.053,-.439,.78),(5.413,-.707,2.536),(5.989,-.688,2.141),(5.948,-.013,2.054),(5.362,-.041,2.47),(7.008,.294,.695),(2.876,-.208,2.634),(3.351,-.191,2.72),(3.747,-.179,2.673),(4.059,-.147,2.646),(6.856,1.055,.603),(7.305,.762,-.647),(7.117,1.488,-.734),(6.412,.822,1.419),(5.9,.697,1.971),(5.33,.594,2.399),(4.575,.457,2.622),(4.127,.383,2.611),(3.841,.324,2.654),(3.431,.264,2.705),(2.926,.187,2.644),(7.599,-1.548,-.324),(3.464,-1.694,2.616),(3.121,-1.626,2.629),(2.711,-1.548,2.526),(2.277,-1.47,2.326),(1.741,-1.389,2.017),(7.163,-4.667,1.34),(6.621,-4.676,2.252),(6.357,-4.631,2.465),(6.057,-4.589,2.62),(2.857,-3.695,2.43),(4.172,-4.649,3.042),(3.86,-1.617,2.681),(3.492,-1.545,2.624),(1.747,-1.198,2.034),(2.079,-8.886,-1.805),(2.591,-8.785,-2.636),(4.729,-8.5,-3.565),(4.235,-8.629,-3.568),(6.914,-8.264,-1.981),(3.545,-8.765,-3.353),(7.133,-8.211,-1.586),(7.177,-8.195,-1.324),(7.332,-8.184,-1.127),(7.648,-8.164,-.526),(6.923,-7.638,-2.075),(6.57,-7.677,-2.596),(7.087,-7.599,-1.779),(7.174,-7.566,-1.473),(7.326,-7.55,-1.287),(7.626,-7.484,-.687),(4.295,-8.199,-3.661),(3.477,-8.176,-3.477),(4.703,-8.121,-3.652),(5.752,-7.636,-3.34),(4.147,-1.111,-5.456),(6.524,-2.332,-2.943),(6.562,-2.831,-2.834),(6.208,-2.937,-3.32),(6.139,-2.421,-3.421),(6.031,-1.415,-3.637),(6.856,-2.339,-2.46),(6.881,-2.785,-2.409),(6.078,-1.898,-3.537),(5.324,-2.104,-4.179),(4.259,-2.387,-4.565),(4.243,-2.165,-4.654),(5.31,-2.721,-4.111),(5.308,-3.337,-4.041),(4.207,-3.734,-4.365),(4.228,-3.041,-4.459),(3.247,-2.312,-4.496),(3.254,-2.078,-4.585),(4.204,-1.637,-5.072),(4.186,1.33,-5.999),(4.793,1.906,-5.351),(4.718,2.527,-5.333),(5.114,3.582,-4.499),(5.476,3.91,-3.905),(5.495,3.317,-3.929),(5.192,2.948,-4.534),(5.526,2.718,-3.951),(5.674,1.95,-3.971),(5.345,1.546,-4.601),(5.271,2.311,-4.566),(5.48,4.426,-3.887),(5.802,4.12,-3.365),(5.802,3.517,-3.351),(6.379,3.743,-2.309),(6.476,3.075,-2.26),(5.831,2.917,-3.314),(6.783,1.842,-2.139),(6.941,1.228,-2.075),(6.104,1.645,-3.303),(6.638,2.424,-2.201),(7.076,.37,-1.932),(7.203,-.492,-1.796),(7.066,-2.806,-2.26),(7.071,-4.715,-2.083),(6.82,-4.785,-2.516),(6.691,-3.808,-2.675),(6.976,-3.751,-2.246),(7.494,-2.821,-1.503),(7.515,-3.695,-1.392),(3.236,-1.301,-5.312),(3.234,-1.698,-4.97),(5.572,-5.124,-3.815),(4.451,-5.39,-4.194),(4.33,-4.567,-4.268),(5.441,-4.235,-3.917),(3.153,-3.801,-4.289),(6.33,-3.869,-3.195),(6.452,-4.809,-3.042),(5.705,-6.021,-3.683),(5.739,-7.183,-3.437),(3.153,-4.648,-4.147),(3.194,-5.388,-4.044),(6.571,-7.032,-2.702),(6.574,-5.776,-2.908),(7.563,-5.62,-1.129),(7.603,-6.804,-.848),(7.146,-3.754,-2.095),(7.226,-4.701,-1.93),(7.166,-5.679,-1.919),(7.171,-6.937,-1.621),(7.319,-6.916,-1.446),(7.306,-5.648,-1.765),(1.066,-4.913,-1.181),(1.176,-5.013,-1.528),(1.267,-5.853,-1.45),(1.14,-5.786,-1.094),(.956,-4.813,-.833),(1.013,-5.719,-.737),(.975,-5.575,-.303),(.907,-4.682,-.381),(1.556,-2.958,-2.761),(1.12,-2.96,-1.997),(1.159,-2.519,-2.186),(1.509,-5.286,-2.289),(2.272,-5.686,-3.225),(2.283,-6.33,-3.061),(1.525,-5.983,-2.152),(1.635,-7.762,-1.323),(1.533,-7.746,-1.02),(1.232,-6.58,-1.039),(1.354,-6.62,-1.377),(3.236,-6.086,-3.946),(3.334,-6.943,-3.737),(2.453,-2.245,-4.111),(2.289,-3.538,-3.799),(1.841,-7.79,-1.922),(1.603,-6.694,-2.038),(2.325,-7.002,-2.913),(2.455,-7.873,-2.778),(1.075,-6.46,-.266),(1.11,-6.539,-.701),(.503,-2.216,-.635),(.854,-2.662,-1.561),(.845,-2.188,-1.695),(.607,-2.379,-1.145),(.681,-3.393,-.479),(.746,-3.541,-.965),(.841,-4.13,-.891),(.769,-3.999,-.423),(1.007,-4.268,-1.263),(.932,-3.775,-1.329),(1.116,-3.47,-1.833),(.872,-3.2,-1.437),(.586,-2.802,-.559),(.668,-2.955,-1.052),(5.987,2.225,-3.33),(5.754,1.309,-3.964),(7.33,-1.355,-1.661),(6.494,-1.839,-3.025),(1.2,-2.265,-2.345),(1.579,-2.662,-2.886),(2.267,-5.07,-3.411),(3.409,-7.587,-3.602),(4.356,-7.768,-3.754),(4.677,-7.741,-3.739),(1.264,-2.077,-2.503),(1.614,-2.411,-2.998),(5.53,-23.646,2.153),(5.685,-23.598,2.198),(5.58,-22.103,2.257),(5.395,-31.044,2.097),(5.544,-31.048,2.061),(5.57,-30.928,2.045),(5.595,-29.878,2.001),(5.789,-29.745,1.951),(5.924,-28.507,1.869),(6.483,-26.593,1.715),(6.607,-26.53,1.615),(6.62,-24.906,1.861),(5.52,-24.458,-2.151),(5.161,-24.569,-2.291),(5.326,-22.983,-2.638),(5.45,-32.552,-.845),(5.882,-31.391,-.614),(5.688,-32.511,-.65),(5.481,-32.024,2.218),(5.362,-32.798,2.448),(5.543,-32.846,2.338),(6.168,-34.011,-.304),(5.954,-33.448,-.437),(6.161,-33.448,-.329),(6.08,-34.08,-.374),(5.106,-33.698,-1.694),(5.035,-33.711,-1.8),(5.123,-32.676,-1.503),(5.318,-33.599,-1.071),(5.247,-33.651,-1.306),(5.278,-32.608,-1.118),(5.474,-31.258,-1.141),(5.928,-32.495,-.565),(6.391,-33.31,.631),(6.453,-33.855,.508),(6.4,-33.405,.053),(6.437,-34.052,.017),(6.456,-33.927,.45),(6.254,-33.316,1.164),(6.207,-32.181,1.162),(6.165,-33.243,1.279),(3.593,-33.364,.776),(3.707,-33.094,1.127),(3.631,-33.037,.757),(4.689,-20.539,1.449),(4.319,-20.568,1.032),(4.755,-22.178,1.662),(3.775,-20.137,.143),(4.031,-20.596,.665),(3.821,-19.834,.11),(3.658,-20.627,.227),(7.576,-24.151,-.191),(7.178,-26.45,-.255),(7.61,-24.169,-.432),(7.329,-17.044,-.028),(7.337,-17.038,-.29),(6.267,-18.434,2.187),(6.442,-18.262,2.074),(6.355,-18.068,2.161),(6.018,-18.357,2.409),(6.235,-17.923,2.331),(6.1,-17.772,2.53),(5.835,-27.97,-1.445),(5.96,-26.316,-1.629),(5.978,-27.976,-1.362),(4.903,-29.005,1.762),(4.72,-30.293,1.758),(4.997,-28.952,1.795),(4.049,-19.496,.75),(3.806,-19.228,.094),(4.198,-20.024,.88),(4.105,-18.401,1.239),(3.75,-17.567,-.952),(3.664,-18.356,-.6),(3.614,-18.019,-.675),(3.722,-18.833,.009),(4.074,-30.583,.92),(3.947,-31.464,.795),(4.03,-31.398,1.039),(3.997,-30.659,.064),(4.012,-31.577,.042),(3.959,-31.554,.17),(4.833,-19.448,1.868),(5.176,-20.56,1.976),(5.203,-19.372,2.189),(6.412,-18.874,2.044),(6.366,-20.145,2.042),(6.578,-18.645,1.855),(6.596,-21.749,1.999),(6.664,-19.979,1.754),(6.105,-21.937,2.183),(6.206,-20.241,2.143),(5.911,-20.391,2.256),(5.524,-20.553,2.319),(5.674,-19.181,2.359),(5.586,-17.846,2.651),(5.911,-17.656,2.658),(6.106,-17.334,2.652),(6.413,-17.245,2.4),(6.532,-17.375,2.198),(6.657,-17.269,1.965),(7.045,-19.481,-1.838),(6.798,-18.327,-1.706),(7.036,-18.333,-1.48),(4.705,-17.705,-1.8),(4.792,-18.36,-2.031),(4.307,-18.421,-1.811),(4.84,-19.518,-2.395),(4.398,-19.6,-2.228),(7.301,-26.32,.41),(7.146,-27.037,.4),(7.824,-21.166,-1.241),(7.416,-19.519,-1.316),(7.539,-19.544,-1.015),(7.571,-24.338,-.982),(6.799,-25.001,-1.551),(6.953,-24.682,-1.768),(7.254,-18.195,-1.062),(7.185,-18.331,-1.233),(3.572,-25.765,-.134),(3.792,-25.899,-1.225),(3.864,-26.214,-1.153),(6.968,-17.178,1.186),(3.647,-19.103,-.733),(3.706,-18.681,-.64),(3.807,-18.261,-1.018),(3.717,-17.249,-1.003),(3.963,-17.549,-1.185),(3.86,-17.612,-1.063),(5.302,-25.045,-2.046),(5.164,-30.059,1.996),(5.351,-28.782,1.91),(5.166,-28.871,1.881),(5.005,-30.136,1.94),(5.602,-27.083,1.97),(5.433,-27.067,1.938),(5.044,-31.063,2.053),(4.899,-31.085,1.988),(5.687,-25.364,2.121),(5.525,-25.375,2.091),(6.107,-23.447,2.164),(5.197,-22.15,1.963),(5.235,-23.72,1.935),(6.093,-25.12,2.065),(5.19,-25.434,1.884),(6.079,-26.838,1.88),(5.153,-27.163,1.813),(4.917,-32.048,2.274),(4.749,-32.066,2.116),(5.197,-32.035,2.278),(4.635,-31.156,1.777),(4.464,-32.122,1.836),(4.848,-32.734,2.508),(4.579,-32.807,2.288),(5.702,-32.052,1.997),(5.812,-31.085,1.883),(5.131,-32.76,2.51),(6.109,-29.463,1.794),(6.333,-28.227,1.704),(5.846,-30.802,1.861),(6.416,-29.152,1.557),(6.566,-27.988,1.527),(6.207,-30.543,1.589),(6.841,-27.524,1.091),(6.626,-28.83,1.096),(7.199,-24.649,1.287),(7.005,-26.395,1.147),(4.824,-30.042,-1.556),(4.868,-28.352,-1.601),(5.244,-28.164,-1.631),(5.074,-29.929,-1.58),(4.538,-28.583,-1.427),(4.54,-30.212,-1.317),(4.798,-26.78,-1.732),(5.268,-26.611,-1.767),(5.559,-29.82,-1.355),(4.933,-31.331,-1.538),(4.767,-31.348,-1.521),(4.76,-23.45,-2.618),(4.778,-21.145,-2.694),(5.395,-21.055,-2.664),(4.177,-21.229,-2.527),(4.169,-23.763,-2.437),(5.544,-19.443,-2.379),(6.373,-22.962,-2.547),(6.351,-20.962,-2.541),(4.753,-25.061,-2.242),(4.313,-25.511,-2.058),(4.837,-25.565,-1.974),(4.419,-25.931,-1.841),(4.542,-26.939,-1.592),(6.088,-25.056,-1.951),(5.444,-33.492,-.716),(5.656,-33.48,-.555),(5.879,-34.16,-.549),(5.755,-34.192,-.683),(5.96,-33.05,1.826),(5.956,-32.095,1.711),(5.759,-32.934,2.109),(6.121,-31.112,1.592),(4.259,-32.917,1.98),(6.201,-32.433,-.329),(5.535,-34.266,-1.041),(5.322,-34.329,-1.514),(5.143,-34.443,-1.975),(5.053,-34.46,-2.026),(4.847,-33.719,-1.855),(4.829,-34.483,-2.039),(4.866,-32.716,-1.636),(5.323,-31.242,-1.313),(6.248,-31.336,-.339),(6.356,-32.367,.07),(6.374,-31.279,.148),(6.33,-32.271,.691),(6.421,-33.896,.669),(6.36,-33.296,.831),(6.313,-32.231,.889),(6.403,-31.238,.606),(6.339,-31.185,.849),(6.27,-33.936,1.025),(6.276,-31.133,1.095),(3.984,-33.05,1.523),(4.167,-32.196,1.49),(3.596,-33.198,.432),(3.586,-33.427,.495),(3.846,-32.333,.735),(3.862,-32.41,.308),(3.864,-33.276,.123),(3.815,-33.708,.148),(3.948,-32.264,1.096),(3.962,-32.449,.068),(4.299,-31.296,1.437),(4.54,-33.64,-1.474),(4.686,-33.708,-1.784),(4.639,-34.495,-1.969),(4.443,-34.411,-1.757),(4.502,-32.676,-1.351),(4.695,-32.711,-1.588),(4.378,-33.489,-.703),(4.369,-32.561,-.68),(4.515,-31.334,-1.332),(4.329,-34.274,-1.007),(4.052,-34.084,-.343),(4.068,-33.326,-.136),(4.141,-32.483,-.174),(4.408,-31.413,-.888),(4.105,-31.557,-.34),(4.112,-30.603,-.463),(4.425,-30.279,-1.04),(5.976,-29.931,-.699),(6.349,-29.952,-.363),(6.484,-30.025,.083),(6.592,-30.116,.509),(5.68,-29.805,-1.243),(4.34,-30.439,1.411),(4.153,-22.208,1.203),(3.51,-22.252,.483),(5.076,-23.753,1.85),(4.366,-23.897,1.525),(3.877,-19.656,.162),(3.702,-18.588,-.581),(3.813,-17.596,-.996),(3.713,-24.075,.621),(5.067,-25.459,1.804),(4.554,-25.576,1.466),(3.331,-20.526,-.653),(3.088,-22.068,-.561),(7.607,-24.295,.367),(7.052,-26.412,-.67),(7.722,-22.95,-.186),(7.799,-22.972,-.502),(7.315,-17.711,-.063),(7.356,-17.673,-.383),(7.248,-17.051,.479),(7.293,-17.747,.464),(7.337,-18.451,-.09),(7.401,-18.399,-.469),(7.292,-17.628,-.812),(7.249,-17.041,-.724),(7.756,-22.919,.439),(7.823,-23.061,-1.28),(7.675,-21.234,-.136),(7.821,-21.217,-.521),(7.538,-19.592,-.56),(7.411,-19.642,-.154),(7.349,-18.259,-.922),(7.313,-18.49,.416),(7.436,-19.674,.425),(7.664,-21.226,.437),(6.042,-18.869,2.307),(6.24,-18.945,2.161),(6.353,-28.084,-.994),(6.52,-26.36,-1.268),(4.376,-28.787,-1.188),(4.152,-29.15,-.645),(4.286,-27.097,-1.453),(3.969,-29.335,.028),(3.841,-27.555,-.008),(4.021,-27.357,-.92),(4.142,-29.286,.921),(4.069,-27.394,.794),(4.424,-19.548,1.352),(4.411,-29.212,1.418),(5.057,-27.187,1.759),(4.53,-27.319,1.377),(7.183,-17.618,-.972),(7.11,-17.014,-.927),(7.011,-16.989,-1.072),(7.088,-17.62,-1.118),(7.173,-17.791,.829),(7.104,-17.08,.855),(6.985,-17.823,1.159),(6.811,-17.901,1.518),(6.832,-17.211,1.523),(7.183,-18.528,.822),(6.982,-18.566,1.187),(4.253,-18.95,1.281),(3.934,-19.037,.654),(4.663,-18.802,1.893),(4.488,-18.252,1.957),(5.098,-18.69,2.277),(4.967,-18.115,2.42),(3.812,-18.522,.571),(3.668,-17.915,.477),(3.672,-18.451,-.049),(3.576,-17.902,-.135),(3.577,-17.649,-.732),(3.584,-20.1,-1.511),(3.273,-21.785,-1.58),(3.244,-23.963,-.317),(5.62,-18.46,2.474),(6.645,-23.283,1.991),(5.759,-17.036,-1.88),(4.804,-17.179,-1.714),(5.739,-17.643,-1.986),(5.708,-18.314,-2.157),(4.109,-17.933,-1.404),(4.238,-17.354,-1.407),(6.464,-17.634,-1.776),(6.451,-16.975,-1.669),(6.467,-18.318,-1.93),(6.368,-19.398,-2.191),(7.303,-20.952,-2.069),(6.207,-24.665,-2.195),(7.262,-22.976,-2.154),(6.728,-16.956,-1.452),(6.773,-17.622,-1.548),(6.981,-17.615,-1.332),(6.914,-16.961,-1.253),(6.64,-28.287,-.461),(4.11,-26.1,-1.634),(3.988,-25.776,-1.779),(3.719,-23.932,-2.112),(3.661,-21.355,-2.212),(3.392,-23.951,-1.45),(3.921,-19.739,-1.956),(3.943,-18.569,-1.457),(6.815,-28.343,-.041),(6.88,-28.465,.417),(6.484,-30.229,.809),(6.753,-28.647,.756),(6.995,-27.28,.743),(6.377,-30.342,1.109),(7.177,-26.361,.786),(7.241,-23.022,1.446),(7.429,-24.475,.832),(7.141,-21.468,1.422),(7.545,-22.969,.962),(7.003,-19.821,1.267),(7.449,-21.342,.949),(7.271,-19.741,.883),(3.969,-25.703,.708),(6.788,-18.653,1.549),(6.6,-18.024,1.874),(6.503,-34.395,1.276),(6.391,-34.736,.523),(6.359,-34.1,.622),(6.228,-33.829,1.196),(4.376,-33.142,2.41),(4.479,-33.108,2.524),(6.367,-34.042,.583),(6.094,-33.465,1.817),(6.16,-33.66,1.178),(3.798,-33.573,1.093),(3.808,-33.264,1.071),(3.692,-33.568,.702),(3.726,-33.672,.293),(6.156,-33.924,-.46),(6.547,-35.572,4.795),(6.667,-35.613,4.656),(6.416,-35.325,4.331),(6.915,-35.631,4.437),(6.792,-35.41,3.977),(6.794,-35.638,4.521),(6.403,-35.542,4.855),(6.116,-35.559,5.133),(6.223,-35.516,4.977),(5.975,-35.266,4.687),(5.939,-35.497,5.199),(5.563,-35.462,5.426),(5.734,-35.465,5.311),(5.481,-35.24,5.009),(5.168,-34.806,4.627),(5.04,-35.165,5.21),(5.194,-35.192,5.14),(4.131,-35.069,5.574),(4.398,-35.114,5.604),(4.419,-35.035,5.478),(4.743,-34.702,4.81),(4.769,-35.092,5.339),(7.03,-35.461,3.724),(7.059,-35.446,3.216),(6.933,-35.287,3.21),(7.252,-35.69,3.229),(3.838,-35.176,4.829),(3.836,-35.302,5.572),(3.999,-34.956,4.856),(3.667,-35.553,4.935),(3.658,-35.509,4.73),(3.816,-36.475,4.782),(3.717,-36.2,4.55),(4.077,-36.54,4.474),(6.714,-35.16,3.61),(6.438,-34.921,3.065),(5.409,-34.911,4.546),(5.281,-34.483,4.038),(6.785,-36.676,2.787),(7,-36.684,3.456),(6.924,-36.714,3.448),(6.331,-36.786,3.968),(6.8,-36.723,3.438),(6.839,-36.774,4.025),(5.416,-36.741,4.564),(5.416,-36.71,4.469),(5.877,-36.8,4.294),(4.323,-36.752,4.588),(4.3,-36.844,4.903),(4.152,-36.722,4.69),(4.297,-36.839,5.276),(4.007,-36.806,5.34),(4.095,-36.823,5.145),(4.384,-36.561,4.254),(4.102,-36.438,4.203),(6.343,-36.753,3.402),(3.64,-36.34,5.13),(4.781,-34.615,4.669),(6.509,-36.621,1.986),(6.671,-36.684,2.794),(3.82,-34.863,2.948),(3.811,-35.242,2.735),(3.809,-35.273,2.89),(3.776,-34.681,2.269),(3.895,-34.322,2.64),(3.766,-34.541,2.096),(4.05,-34.155,3.027),(4.035,-34.276,3.202),(4.267,-34.042,3.374),(3.945,-34.766,3.848),(3.911,-34.526,3.082),(5.351,-36.488,1.404),(4.938,-36.3,1.49),(4.932,-36.301,1.414),(4.632,-36.21,2.886),(4.422,-36.361,3.589),(4.487,-36.155,2.887),(3.822,-34.023,1.626),(3.736,-34.656,1.817),(3.78,-35.077,.655),(3.782,-35.063,1.316),(3.715,-34.854,1.3),(5.481,-34.099,3.426),(5.688,-34.588,3.798),(5.213,-33.417,3.176),(5.029,-33.94,3.639),(4.588,-36.854,-1.206),(4.796,-36.875,-1.213),(4.659,-36.89,-.69),(4.535,-36.768,-1.593),(4.37,-36.811,-1.186),(6.059,-36.635,2.059),(5.906,-36.602,2.076),(5.817,-36.593,1.341),(5.442,-36.787,-1.53),(5.643,-36.769,-1.429),(5.497,-36.829,-1.379),(4.921,-36.087,-2.223),(5.179,-36.114,-2.217),(5.062,-36.498,-2.011),(5.437,-36.104,-2.147),(5.749,-35.739,-1.792),(5.778,-35.987,-1.773),(6.639,-35.602,1.119),(6.852,-35.436,1.852),(6.916,-35.56,1.803),(3.944,-35.427,.018),(3.914,-35.257,.026),(4.01,-35.368,-.652),(6.75,-35.226,1.891),(6.793,-35.351,1.894),(6.598,-35.362,1.157),(6.136,-34.908,-.21),(6.232,-34.394,-.133),(4.132,-33.274,2.077),(4.408,-33.528,2.966),(4.205,-33.628,2.668),(4.842,-33,2.753),(4.78,-33.376,3.235),(3.973,-33.78,2.262),(5.926,-33.296,2.099),(5.687,-33.149,2.398),(6.41,-34.07,1.847),(6.156,-33.872,2.297),(5.899,-33.722,2.658),(5.417,-33.043,2.619),(5.165,-32.972,2.78),(5.608,-33.609,2.976),(6.018,-34.134,-.607),(5.948,-34.241,-.683),(6.257,-34.291,-.114),(5.849,-34.878,-1.092),(5.561,-34.886,-1.858),(5.302,-34.943,-2.341),(5.097,-34.99,-2.421),(6.417,-33.977,-.129),(6.455,-33.803,.406),(4.832,-35.013,-2.399),(3.924,-33.455,1.513),(3.748,-34.189,1.215),(3.744,-34.422,.648),(3.857,-34.545,.13),(4.039,-34.756,-.68),(4.323,-34.984,-2.094),(4.642,-35.019,-2.328),(4.169,-34.861,-1.449),(6.586,-35.102,1.204),(6.358,-35.312,.4),(6.311,-35.104,3.988),(5.25,-35.386,5.467),(5.875,-35.022,4.294),(5.003,-35.327,5.5),(4.736,-35.241,5.551),(4.346,-34.689,4.903),(4.414,-34.56,4.679),(7.001,-35.417,2.638),(6.861,-35.253,2.67),(3.726,-35.618,5.585),(4.06,-34.792,4.516),(3.861,-35.031,4.406),(7.329,-36.482,4.265),(7.217,-36.509,3.485),(7.319,-36.336,3.452),(7.416,-36.301,4.223),(7.159,-36.649,4.283),(7.005,-36.525,2.763),(7.125,-36.341,2.725),(7.358,-35.9,3.261),(7.446,-35.929,4.102),(3.692,-35.829,5.581),(3.626,-35.799,4.998),(3.689,-36.305,5.685),(3.628,-35.765,4.657),(3.775,-36.609,5.759),(3.763,-36.648,5.232),(3.884,-36.702,4.955),(7.245,-35.91,2.633),(7.353,-35.717,4.131),(7.134,-35.588,2.612),(7.109,-35.63,4.257),(6.053,-34.751,3.553),(7.045,-36.734,4.305),(6.296,-36.828,4.166),(6.824,-36.798,4.192),(6.931,-36.764,4.347),(6.44,-36.787,4.505),(6.023,-36.783,4.669),(5.908,-36.702,4.012),(5.47,-36.794,4.895),(5.416,-36.613,4.179),(5.936,-36.676,3.437),(4.935,-36.807,5.077),(4.893,-36.795,4.672),(4.874,-36.763,4.55),(4.844,-36.645,4.24),(4.899,-36.438,3.569),(5.532,-36.511,3.527),(3.766,-36.039,4.12),(3.658,-35.647,4.207),(3.702,-35.358,4.277),(6.253,-36.71,2.82),(5.959,-36.659,2.837),(6.266,-36.559,1.319),(3.803,-35.111,2.002),(3.95,-35.599,2.858),(3.961,-35.522,2.587),(3.782,-35.145,3.744),(3.746,-35.473,3.683),(3.837,-35.818,3.61),(3.905,-35.389,1.904),(4.194,-35.813,2.447),(4.216,-35.952,2.868),(4.993,-36.291,2.161),(4.674,-36.155,2.236),(4.656,-36.14,1.575),(5.014,-36.367,2.883),(4.463,-36.026,2.314),(4.429,-35.957,1.667),(4.642,-36.133,1.442),(5.531,-36.484,2.111),(5.602,-36.484,2.872),(4.227,-36.076,.733),(4.4,-35.949,1.432),(4.119,-35.669,1.397),(4.037,-35.79,.688),(4.534,-36.397,.759),(4.146,-35.68,1.791),(3.849,-35.34,.656),(3.88,-35.311,1.344),(4.024,-35.918,.022),(4.137,-36.289,.058),(4.128,-36.194,3.595),(4.172,-34.45,3.979),(4.502,-34.28,4.182),(4.624,-33.911,3.634),(6.587,-34.8,1.9),(6.396,-34.547,2.413),(6.17,-34.362,2.819),(5.787,-34.189,3.205),(6.667,-35.068,2.598),(4.913,-34.339,4.185),(5.238,-36.904,-.751),(5.144,-36.868,-1.293),(5.487,-36.847,-.033),(4.819,-36.814,.032),(4.767,-36.776,-1.658),(5.057,-36.789,-1.68),(5.747,-36.831,-.888),(4.762,-36.527,.79),(5.152,-36.658,.771),(4.459,-36.7,.047),(5.702,-36.716,.707),(4.304,-36.576,.053),(4.334,-36.812,-.647),(4.172,-36.701,-.634),(4.436,-36.67,-1.71),(4.212,-36.695,-1.218),(5.998,-36.738,-.126),(6.135,-36.617,.637),(6.765,-36.461,1.94),(6.514,-36.407,1.269),(6.889,-36.301,1.921),(6.35,-36.481,.591),(6.636,-36.256,1.217),(6.27,-36.591,-.18),(6.471,-36.323,.557),(6.016,-36.721,-.952),(6.363,-36.436,-.268),(6.124,-36.575,-1.032),(5.706,-36.65,-1.533),(5.475,-36.685,-1.686),(5.063,-36.69,-1.841),(6.373,-35.434,.39),(6.154,-35.391,-.386),(5.418,-35.51,-2.306),(5.138,-35.484,-2.412),(5.475,-36.404,-1.965),(5.768,-36.307,-1.71),(6.086,-35.85,-1.262),(6.124,-36.254,-1.227),(5.72,-35.493,-1.811),(5.896,-35.44,-1.22),(4.863,-35.491,-2.391),(5.929,-35.548,-1.226),(6.176,-35.477,-.405),(6.345,-35.731,-.486),(6.405,-36.071,-.438),(6.461,-35.682,.377),(6.584,-36.037,.453),(6.728,-36.008,1.113),(4.752,-36.672,-1.827),(4.736,-36.508,-1.967),(4.371,-36.522,-1.803),(4.719,-36.074,-2.196),(4.67,-35.501,-2.325),(6.984,-35.935,1.794),(4.124,-36.505,-1.304),(4.339,-36.106,-1.954),(4.039,-36.461,-.636),(4.062,-36.105,-1.388),(3.966,-36.072,-.635),(4.105,-35.415,-1.459),(4.323,-35.472,-2.086),(6.757,-36.156,6.722),(6.721,-36.105,6.601),(6.755,-36.168,6.724),(7.039,-36.177,6.567),(7.039,-36.189,6.567),(7.013,-36.163,6.479),(7.032,-36.159,6.479),(6.702,-36.092,6.611),(5.737,-36.121,7.771),(5.738,-36.131,7.764),(5.695,-36.03,7.619),(5.719,-36.164,7.823),(5.762,-36.107,7.747),(5.25,-36.117,7.84),(5.254,-36.103,7.843),(5.234,-36.049,7.693),(5.262,-36.134,7.877),(5.271,-36.139,7.886),(5.267,-36.122,7.888),(5.262,-36.137,7.911),(4.802,-35.828,7.812),(4.695,-35.894,7.444),(4.802,-35.814,7.799),(4.164,-35.784,7.944),(4.073,-35.898,7.568),(4.162,-35.8,7.95),(6.039,-36.098,7.444),(6.013,-36.044,7.309),(6.033,-36.109,7.442),(6.448,-36.162,7.33),(6.404,-36.064,7.201),(6.45,-36.152,7.336),(6.056,-36.132,7.482),(6.054,-36.118,7.485),(6.047,-36.127,7.475),(6.049,-36.129,7.509),(6.473,-36.144,7.314),(6.433,-36.189,7.386),(7.256,-36.306,5.882),(7.228,-36.236,5.776),(7.252,-36.318,5.882),(7.495,-36.356,5.74),(7.493,-36.368,5.738),(7.469,-36.328,5.659),(7.487,-36.327,5.66),(7.214,-36.222,5.786),(6.399,-36.231,6.133),(6.434,-36.391,6.163),(6.439,-36.379,6.175),(6.387,-36.372,6.216),(6.744,-36.404,5.768),(6.867,-36.372,5.5),(6.853,-36.38,5.738),(6.976,-36.33,5.736),(6.933,-36.358,5.326),(6.863,-36.379,5.467),(7.479,-35.881,4.541),(7.504,-36.008,4.556),(7.501,-36.005,4.538),(7.502,-36.176,4.626),(7.523,-36.02,4.652),(7.171,-36.609,4.814),(7.322,-36.471,4.818),(7.276,-36.477,4.897),(7.373,-36.389,4.786),(6.948,-36.379,5.293),(7.009,-36.407,5.226),(7.008,-36.396,5.239),(7.05,-36.448,5.15),(7.095,-36.425,5.139),(7.308,-36.401,4.929),(7.378,-36.379,4.805),(7.391,-36.389,4.861),(7.506,-36.181,4.618),(7.446,-36.292,4.672),(7.518,-36.31,5.037),(7.444,-36.426,5.056),(7.436,-36.394,5.026),(7.262,-36.477,5.086),(7.324,-36.47,5.062),(7.328,-36.572,5.204),(7.535,-36.18,4.763),(7.551,-36.036,4.787),(7.594,-36.183,5.057),(7.542,-36.44,5.766),(7.566,-36.387,5.636),(7.541,-36.358,5.65),(7.609,-36.252,5.419),(7.599,-36.283,5.458),(7.615,-36.349,5.375),(7.474,-35.959,4.289),(7.463,-35.888,4.302),(6.898,-35.806,4.785),(6.95,-35.924,5.007),(6.968,-35.871,5.007),(7.02,-35.916,5.26),(6.985,-36.01,5.302),(6.972,-36.012,5.186),(6.994,-35.68,4.566),(7.172,-35.644,4.448),(6.983,-35.758,4.758),(7.073,-35.684,4.73),(6.912,-35.701,4.615),(6.829,-35.723,4.664),(6.825,-36.646,5.034),(6.712,-36.634,5.142),(6.648,-36.702,5.019),(6.835,-35.799,4.845),(6.952,-36.351,5.322),(6.893,-36.429,5.316),(6.811,-36.533,5.24),(6.922,-36.43,5.281),(6.983,-36.161,5.296),(6.964,-36.284,5.33),(6.983,-36.169,5.337),(6.435,-36.528,6.083),(6.399,-36.622,5.867),(6.485,-36.542,6.02),(6.259,-36.478,6.318),(6.23,-36.611,6.087),(6.329,-36.489,6.217),(6.357,-36.359,6.241),(6.709,-36.082,6.602),(6.759,-36.181,6.76),(6.701,-36.149,6.738),(6.653,-36.243,6.77),(6.762,-36.214,6.788),(6.638,-36.176,6.72),(7.023,-36.143,6.476),(6.963,-36.096,6.465),(6.972,-35.972,6.4),(7.087,-36.006,6.231),(7.077,-36.062,6.322),(7.184,-36.187,6.178),(6.517,-36.023,6.426),(6.454,-36.11,6.447),(6.536,-36.056,6.491),(6.86,-36.421,5.795),(6.798,-36.444,5.833),(6.897,-36.501,6.037),(7.12,-36.425,6.338),(7.049,-36.48,6.454),(7.065,-36.484,6.316),(6.761,-36.549,5.327),(6.952,-36.552,6.429),(6.993,-36.466,6.595),(6.597,-36.455,6.627),(6.621,-36.398,6.71),(6.563,-36.39,6.662),(6.56,-36.243,6.718),(6.375,-36.066,5.952),(6.394,-36.113,6.049),(6.143,-35.629,5.67),(6.269,-35.676,5.688),(6.242,-35.657,5.527),(6.277,-35.667,5.476),(6.201,-35.614,5.298),(6.097,-35.589,5.425),(6.307,-35.658,5.459),(6.338,-35.731,5.617),(6.319,-35.722,5.626),(6.343,-35.829,5.738),(6.373,-35.796,6.023),(6.289,-35.681,6.007),(6.389,-35.811,6.123),(6.365,-35.835,5.733),(6.417,-35.719,5.669),(6.367,-36.063,5.955),(6.355,-35.94,5.83),(6.378,-36.019,6.113),(6.341,-36.353,6.28),(6.281,-36.428,6.373),(6.173,-36.385,6.456),(6.047,-36.381,6.491),(6.165,-36.391,6.427),(6.372,-36.211,6.195),(6.364,-36.205,6.216),(5.759,-36.292,6.55),(5.807,-36.301,6.536),(5.759,-36.149,6.49),(5.766,-36.143,6.5),(5.765,-35.937,6.325),(5.72,-35.923,6.448),(5.716,-36.131,6.58),(5.722,-36.137,6.55),(6.067,-36.615,6.231),(6.154,-36.483,6.395),(6.062,-36.478,6.449),(6.254,-36.731,5.249),(6.446,-36.681,5.554),(6.328,-36.689,5.66),(5.95,-36.692,6.001),(5.695,-36.76,5.449),(6.071,-36.693,5.892),(6.668,-36.528,5.749),(6.612,-36.551,5.848),(6.548,-36.616,5.672),(5.794,-36.703,6.073),(5.658,-36.606,6.458),(5.511,-36.61,6.53),(5.452,-36.739,6.232),(5.798,-36.414,6.567),(5.755,-36.398,6.593),(6.363,-36.21,7.516),(6.499,-36.29,7.42),(6.485,-36.233,7.415),(6.412,-36.034,7.19),(6.425,-36.047,7.197),(6.119,-35.587,6.055),(6.046,-35.574,6.092),(6.167,-35.587,6.544),(6.021,-35.594,5.681),(5.625,-35.551,5.641),(5.74,-35.56,5.615),(5.686,-35.64,5.855),(5.78,-35.683,5.949),(5.83,-35.641,5.799),(5.499,-35.519,5.682),(5.446,-35.564,5.89),(5.641,-35.646,6.002),(5.303,-35.516,5.888),(5.375,-35.551,6.33),(4.958,-35.501,5.776),(5.283,-35.465,5.722),(5.167,-35.542,5.963),(5.73,-36.174,7.843),(5.828,-36.128,7.726),(5.213,-36.123,7.851),(5.242,-36.113,7.842),(5.114,-35.979,7.506),(5.167,-36.054,7.674),(5.167,-35.903,7.513),(5.213,-36.027,7.681),(5.221,-36.018,7.676),(5.714,-36.009,7.614),(5.7,-35.997,7.606),(5.782,-35.928,7.37),(5.659,-35.834,7.408),(5.825,-36.033,7.549),(5.116,-36.282,7.456),(5.223,-36.397,7.392),(5.119,-36.316,7.504),(5.686,-35.733,6.43),(5.678,-35.722,6.322),(5.574,-35.624,6.297),(5.149,-36.192,7.857),(5.243,-36.271,7.98),(5.254,-36.175,7.958),(5.269,-36.526,7.882),(5.333,-36.569,7.85),(5.355,-36.554,7.917),(5.653,-36.535,7.818),(5.635,-36.556,7.756),(5.735,-36.511,7.72),(4.791,-36.328,6.603),(4.788,-36.215,6.505),(4.782,-36.227,6.551),(4.803,-36.219,6.74),(4.808,-36.347,6.605),(4.858,-36.339,6.579),(4.807,-36.192,6.45),(5.301,-36.439,6.705),(5.16,-36.379,6.634),(5.231,-36.659,6.508),(5.652,-36.384,6.657),(5.491,-36.445,6.7),(4.875,-36.4,6.596),(4.759,-36.427,6.618),(4.935,-36.68,6.453),(3.799,-36.453,6.225),(3.804,-36.435,6.243),(3.728,-36.215,6.126),(4.298,-36.558,6.451),(4.103,-36.581,6.381),(4.25,-36.728,6.275),(4.864,-36.318,7.714),(4.928,-36.237,7.684),(4.869,-36.221,7.944),(4.255,-36.356,7.952),(4.242,-36.19,8.099),(4.174,-36.243,8.036),(4.077,-36.31,7.884),(4.847,-35.817,7.798),(4.826,-35.815,7.804),(4.821,-35.833,7.859),(4.904,-35.893,7.545),(4.794,-35.86,7.476),(4.723,-35.882,7.432),(4.782,-35.869,7.407),(4.057,-35.868,7.597),(4.022,-35.845,7.63),(4.149,-35.785,7.965),(4.131,-35.797,7.978),(4.183,-35.788,8.021),(4.688,-35.849,7.396),(4.054,-35.855,7.536),(3.983,-35.851,7.655),(3.947,-35.915,7.725),(4.725,-35.774,6.158),(4.713,-35.663,6.101),(4.7,-35.66,6.116),(4.868,-35.963,7.07),(4.891,-36.095,6.99),(4.859,-35.957,7.022),(4.105,-36.809,5.979),(4.014,-36.679,6.153),(3.866,-36.632,6.02),(3.889,-35.627,6.857),(3.86,-35.618,6.462),(3.826,-35.674,6.856),(3.839,-35.903,7.423),(3.792,-36.009,7.445),(4.755,-35.984,6.267),(4.765,-35.781,6.146),(4.663,-36.106,8.125),(4.681,-36.274,8.022),(4.803,-36.171,8.021),(5.723,-35.763,6.112),(5.174,-36.757,6.238),(4.995,-36.768,6.215),(5.04,-36.772,5.608),(4.857,-36.778,5.634),(5.715,-36.392,6.619),(4.447,-36.332,7.98),(4.681,-36.308,7.965),(5.146,-36.771,5.582),(3.703,-35.86,5.917),(3.733,-35.685,5.923),(3.734,-35.675,5.872),(5.807,-35.747,6.26),(5.772,-35.769,6.098),(5.931,-36.396,7.03),(5.852,-36.286,7.162),(5.849,-36.254,7.118),(5.879,-35.962,7.163),(5.934,-36.043,7.304),(5.937,-35.899,7.162),(6.002,-36.013,7.296),(5.994,-36.021,7.302),(6.348,-36.595,7.335),(6.447,-36.552,7.292),(6.373,-36.573,7.39),(6.063,-36.576,7.461),(6.091,-36.559,7.52),(6.008,-36.521,7.498),(6.014,-36.251,7.582),(6.031,-36.166,7.556),(5.92,-36.17,7.479),(6.026,-36.105,7.446),(5.986,-36.114,7.46),(7.221,-36.213,5.78),(7.255,-36.335,5.915),(7.209,-36.292,5.897),(7.154,-36.376,5.916),(7.254,-36.37,5.936),(7.149,-36.305,5.876),(7.481,-36.31,5.659),(7.435,-36.254,5.654),(7.462,-36.132,5.606),(7.062,-36.105,5.618),(7.01,-36.181,5.623),(7.074,-36.147,5.675),(7.526,-36.583,5.498),(7.467,-36.633,5.682),(7.47,-36.626,5.471),(7.379,-36.685,5.652),(7.424,-36.625,5.764),(7.086,-36.54,5.814),(7.113,-36.503,5.877),(7.056,-36.478,5.841),(7.071,-36.353,5.865),(6.883,-36.152,6.708),(6.883,-36.139,6.706),(6.891,-36.168,6.736),(6.977,-36.156,6.648),(6.978,-36.143,6.647),(6.819,-36.077,6.524),(6.994,-36.178,6.669),(6.955,-36.117,6.469),(7.065,-36.195,6.581),(6.82,-36.054,6.522),(5.723,-36.146,7.828),(5.526,-35.979,7.618),(5.578,-36.078,7.836),(5.592,-36.12,7.906),(5.589,-36.14,7.905),(5.333,-35.991,7.661),(5.376,-36.067,7.869),(5.39,-36.1,7.922),(5.39,-36.119,7.921),(5.395,-36.123,7.955),(5.596,-36.139,7.931),(5.523,-35.945,7.61),(4.513,-35.773,7.44),(4.591,-35.697,7.865),(4.803,-35.804,7.828),(4.799,-35.83,7.84),(4.507,-35.74,7.398),(4.228,-35.77,7.503),(4.315,-35.687,7.913),(4.616,-35.698,7.945),(4.333,-35.685,7.999),(4.614,-35.728,7.959),(4.339,-35.711,8.013),(4.178,-35.769,7.984),(4.181,-35.796,7.99),(4.34,-35.706,8.041),(4.625,-35.721,7.983),(4.214,-35.733,7.464),(5.327,-35.96,7.656),(6.341,-36.111,7.389),(6.282,-36.013,7.198),(6.099,-36.002,7.262),(6.149,-36.08,7.447),(6.095,-35.973,7.26),(6.282,-35.981,7.192),(6.356,-36.152,7.454),(6.164,-36.112,7.495),(6.438,-36.173,7.389),(6.351,-36.17,7.453),(6.163,-36.129,7.495),(6.361,-36.171,7.478),(6.454,-36.203,7.399),(6.169,-36.133,7.527),(7.367,-36.322,5.871),(7.369,-36.31,5.871),(7.373,-36.342,5.895),(7.446,-36.335,5.816),(7.45,-36.323,5.817),(7.315,-36.217,5.709),(7.46,-36.361,5.833),(7.425,-36.273,5.655),(7.516,-36.38,5.75),(7.319,-36.196,5.71),(6.518,-36.43,6.062),(6.509,-36.445,6.073),(6.446,-36.376,6.198),(6.419,-36.252,6.19),(6.378,-36.226,6.152),(6.735,-36.417,5.755),(6.825,-36.447,5.435),(6.627,-36.453,5.912),(6.621,-36.468,5.914),(6.658,-36.454,5.959),(6.535,-36.432,6.119),(7.506,-35.881,4.686),(7.446,-36.281,4.68),(7.303,-36.411,4.916),(7.237,-36.421,4.998),(7.202,-36.475,4.999),(7.102,-36.414,5.145),(7.014,-36.392,5.279),(7.245,-36.411,5.005),(7.114,-36.415,5.159),(7.254,-36.43,5.045),(7.327,-36.427,5.017),(7.472,-36.294,4.798),(7.556,-36.459,5.288),(7.455,-36.543,5.218),(7.007,-36.442,5.328),(6.958,-36.408,5.426),(6.967,-36.446,5.506),(7.042,-36.509,5.396),(6.967,-36.298,5.449),(7.123,-36.475,5.194),(7.162,-36.544,5.284),(7.063,-36.577,4.989),(6.951,-36.552,5.119),(6.924,-36.656,4.939),(6.971,-36.685,4.834),(7.547,-35.923,4.833),(7.595,-36.053,5.118),(7.445,-35.762,4.756),(7.504,-35.812,4.905),(7.53,-36.511,5.753),(7.585,-36.459,5.596),(7.537,-36.227,5.524),(7.515,-36.332,5.663),(7.556,-36.164,5.445),(7.47,-36.056,5.55),(7.563,-35.955,5.164),(7.448,-35.88,5.259),(7.389,-35.754,4.59),(7.375,-35.73,4.353),(7.242,-35.66,4.654),(7.041,-35.762,4.996),(7.167,-35.661,4.942),(7.103,-35.804,5.199),(7.228,-35.722,5.122),(7.149,-35.904,5.42),(7.042,-35.997,5.433),(7.325,-35.691,4.842),(6.751,-35.699,4.757),(6.814,-35.748,4.919),(6.895,-35.91,5.03),(6.953,-36.286,5.326),(7.046,-36.219,5.737),(6.968,-36.151,5.308),(7.097,-36.072,5.742),(7.136,-36.319,6.102),(7.035,-36.436,6.043),(6.946,-36.007,5.196),(6.983,-35.895,5.389),(6.898,-35.808,5.156),(6.666,-36.087,6.619),(6.662,-35.977,6.49),(6.581,-36.122,6.613),(6.797,-35.945,6.461),(7.063,-36.156,6.481),(6.899,-36.212,6.766),(7.009,-36.23,6.692),(7.089,-36.254,6.601),(7.096,-36.178,6.47),(6.966,-35.9,6.332),(7.162,-36.276,6.425),(7.031,-35.831,5.825),(6.466,-35.938,6.129),(6.429,-36.021,6.141),(6.504,-36.175,6.597),(6.639,-35.932,6.422),(6.892,-35.763,5.918),(6.774,-35.869,6.389),(6.567,-35.822,6.101),(6.7,-35.723,6.022),(6.707,-36.508,6.124),(7.091,-36.349,6.578),(6.932,-36.569,6.28),(6.72,-35.643,5.114),(6.82,-35.689,5.326),(6.773,-36.585,6.34),(6.83,-36.555,6.493),(7.016,-36.352,6.68),(6.872,-36.455,6.677),(6.894,-36.321,6.771),(6.744,-36.435,6.723),(6.696,-36.521,6.565),(6.774,-36.306,6.801),(6.627,-36.544,6.436),(6.649,-36.306,6.773),(6.545,-36.469,6.529),(6.557,-36.31,6.711),(6.498,-36.365,6.562),(6.49,-36.272,6.58),(6.45,-36.305,6.417),(6.469,-36.421,6.355),(6.566,-36.488,6.243),(6.417,-36.157,6.159),(6.445,-36.223,6.44),(6.401,-35.974,5.979),(6.364,-35.942,5.827),(5.976,-35.566,5.49),(6.443,-35.617,5.381),(6.341,-35.585,5.178),(6.527,-35.64,5.573),(6.489,-35.589,5.062),(6.589,-35.627,5.251),(6.492,-35.759,5.861),(6.61,-35.663,5.766),(6.688,-35.655,5.447),(6.42,-35.876,5.925),(6.63,-35.615,4.952),(6.938,-35.747,5.528),(6.786,-35.684,5.644),(6.336,-36.337,6.296),(6.283,-36.408,6.384),(6.234,-36.336,6.676),(6.053,-36.322,6.709),(6.299,-36.389,6.415),(6.353,-36.258,6.633),(6.275,-36.372,6.845),(6.096,-36.358,6.873),(5.898,-36.248,6.728),(5.907,-36.35,6.53),(6.342,-36.314,6.366),(6.39,-36.204,6.604),(6.398,-36.334,6.855),(6.394,-36.023,6.217),(6.372,-36.196,6.301),(6.164,-36.409,6.421),(6.045,-36.398,6.486),(5.902,-36.366,6.529),(5.909,-36.455,6.522),(5.811,-36.286,6.531),(5.874,-36.614,6.367),(5.723,-36.29,6.566),(5.732,-36.15,6.489),(5.781,-36.025,6.681),(5.787,-35.89,6.681),(5.738,-35.976,6.349),(5.811,-36.121,6.702),(5.761,-36.197,7.244),(5.692,-36.122,6.951),(5.717,-36.052,6.921),(5.808,-36.054,7.253),(5.702,-36.276,7.236),(5.667,-36.192,6.981),(5.677,-36.208,6.687),(5.71,-36.121,6.637),(5.723,-35.923,6.866),(5.799,-35.953,7.253),(5.792,-36.232,7.308),(5.827,-36.1,7.324),(5.644,-36.296,6.737),(5.677,-36.25,6.622),(5.72,-35.927,6.532),(5.632,-36.37,6.662),(5.696,-36.268,6.597),(6.41,-36.125,6.569),(6.464,-36.252,6.856),(6.523,-36.122,6.86),(6.496,-36.288,6.91),(6.424,-36.399,6.909),(6.561,-36.172,7.286),(6.505,-36.147,7.307),(6.175,-36.178,7.579),(6.59,-36.27,7.271),(6.549,-36.081,7.132),(6.476,-36.048,7.181),(6.411,-35.888,7.009),(6.508,-35.966,6.974),(6.246,-35.85,7.075),(5.952,-35.583,6.141),(6.005,-35.608,6.618),(5.939,-35.594,5.728),(5.897,-35.678,6.654),(5.858,-35.628,6.194),(6.22,-35.78,6.989),(6.049,-35.795,7.045),(5.856,-35.552,5.546),(4.923,-35.616,5.943),(5.061,-35.585,6.055),(5.109,-36.104,7.644),(5.4,-36.17,8.007),(5.6,-36.181,7.969),(5.755,-36.237,7.875),(5.872,-36.209,7.723),(5.294,-35.836,7.5),(5.483,-35.812,7.465),(5.6,-36.39,7.298),(5.622,-36.527,7.559),(5.449,-36.559,7.599),(5.412,-36.424,7.331),(5.729,-36.342,7.299),(5.76,-36.457,7.526),(5.485,-36.59,7.795),(5.252,-36.531,7.678),(5.404,-36.344,7.261),(5.584,-36.326,7.234),(5.232,-36.309,7.305),(5.194,-36.262,7.032),(5.363,-36.317,7.031),(5.111,-36.21,7.361),(5.089,-36.134,6.992),(5.065,-36.093,7.379),(5.079,-36.159,7.49),(5.045,-36.037,6.966),(5.089,-36.203,7.571),(5.061,-35.996,7.384),(5.083,-36.049,7.503),(5.032,-35.9,6.965),(5.084,-35.924,7.384),(5.062,-35.788,6.959),(5.143,-35.842,7.399),(5.277,-35.779,7.398),(5.117,-35.673,6.945),(5.694,-35.722,6.813),(5.568,-35.606,6.803),(5.383,-36.454,7.988),(5.232,-36.412,7.95),(5.388,-36.304,8.021),(5.163,-36.461,7.734),(5.123,-36.337,7.81),(5.555,-36.469,7.96),(5.519,-36.554,7.886),(5.59,-36.313,7.995),(5.697,-36.477,7.873),(5.74,-36.352,7.884),(5.813,-36.447,7.718),(5.859,-36.319,7.722),(5.838,-36.355,7.525),(4.74,-35.409,5.775),(5.189,-35.567,6.403),(5.021,-35.656,6.145),(5.091,-35.623,6.451),(5.222,-35.591,6.918),(5.392,-35.551,6.855),(5.884,-36.106,7.529),(5.826,-36.006,7.343),(5.756,-35.858,7.258),(5.623,-35.764,7.3),(5.881,-36.218,7.526),(5.535,-36.309,7.02),(5.49,-36.354,6.769),(5.453,-35.744,7.358),(5.488,-36.419,6.703),(4.745,-35.997,6.347),(4.751,-36.008,6.475),(5.079,-36.287,6.595),(5.012,-36.105,6.451),(5.055,-36.079,6.615),(5.033,-35.874,6.525),(5.306,-36.422,6.708),(5.324,-36.355,6.778),(5.173,-36.371,6.644),(5.203,-36.32,6.763),(5.113,-36.232,6.707),(5.093,-36.279,6.605),(5.022,-36.101,6.472),(4.745,-36.407,6.627),(4.985,-35.915,6.356),(4.961,-35.962,6.311),(5.049,-35.748,6.49),(4.906,-35.777,6.159),(4.99,-35.768,6.24),(4.906,-35.718,6.067),(3.859,-36.509,6.275),(3.861,-36.49,6.292),(3.719,-36.112,6.426),(3.76,-36.396,6.408),(3.72,-36.249,5.985),(4.1,-36.559,6.395),(3.822,-36.466,6.412),(4.097,-36.563,6.487),(4.298,-36.537,6.466),(4.526,-36.49,6.53),(4.514,-36.469,6.539),(4.308,-36.539,6.564),(4.647,-36.692,6.41),(4.514,-36.475,6.637),(4.758,-36.336,6.754),(4.84,-36.008,6.743),(4.919,-36.223,7.279),(4.865,-36.317,7.275),(4.969,-36.142,7.643),(4.914,-36.093,7.899),(4.68,-36.449,7.736),(4.939,-36.132,7.302),(4.631,-36.543,7.325),(4.884,-36.185,6.989),(4.818,-36.286,6.987),(4.562,-36.439,6.98),(4.769,-35.819,6.752),(4.707,-35.757,6.422),(4.43,-36.511,7.684),(4.652,-35.832,8.079),(4.355,-35.815,8.138),(4.38,-35.974,8.175),(4.668,-35.968,8.118),(4.225,-36.05,8.148),(4.211,-35.876,8.129),(4.415,-36.13,8.144),(4.84,-35.919,7.931),(4.834,-36.046,7.988),(4.907,-35.955,7.834),(4.96,-36.001,7.589),(4.922,-35.993,7.332),(4.081,-36.522,6.862),(4.323,-36.5,6.919),(3.789,-36.43,6.717),(4.135,-36.563,7.246),(4.385,-36.572,7.285),(3.776,-36.476,7.125),(4.176,-36.525,7.635),(3.909,-36.423,7.543),(4.008,-36.19,7.882),(4.123,-36.104,8.072),(3.838,-36.317,7.536),(3.948,-36.017,7.82),(4.115,-35.931,8.074),(3.967,-35.756,7.35),(4.104,-35.626,7.164),(4.079,-35.551,6.853),(3.929,-35.681,7.18),(4.458,-35.627,7.135),(4.377,-35.545,6.839),(4.058,-35.487,6.474),(3.849,-35.739,7.18),(4.142,-35.671,7.271),(4.476,-35.683,7.242),(3.896,-35.828,7.402),(3.771,-36.124,7.485),(4.769,-35.567,5.965),(4.775,-35.676,6.065),(4.634,-35.523,6.045),(4.43,-35.306,5.943),(4.435,-35.318,5.988),(4.629,-35.517,6.067),(4.105,-35.228,5.924),(4.098,-35.243,5.982),(4.568,-35.503,6.197),(4.386,-35.377,6.213),(4.674,-35.649,6.207),(4.078,-35.335,6.196),(4.336,-35.481,6.451),(4.506,-35.559,6.438),(4.649,-35.749,7.183),(4.71,-35.771,6.246),(4.629,-35.647,6.426),(4.676,-35.691,6.772),(4.553,-35.61,6.803),(4.761,-35.776,7.055),(4.634,-35.702,7.092),(4.787,-35.824,7.145),(4.87,-35.907,7.358),(3.734,-36.362,6.715),(3.703,-36.071,6.725),(3.715,-36.408,7.127),(3.663,-36.16,7.107),(3.841,-35.407,5.87),(3.7,-35.879,6.139),(3.834,-35.425,5.945),(3.82,-35.512,6.211),(3.725,-35.731,6.166),(3.761,-35.775,6.443),(3.717,-35.896,6.434),(3.741,-35.826,6.792),(3.71,-35.923,6.76),(3.753,-35.865,7.169),(3.705,-35.96,7.154),(4.055,-36.798,5.733),(4.751,-36.773,6.184),(4.307,-36.816,5.712),(4.34,-36.801,6.108),(6.322,-35.661,6.478),(5.839,-36.167,7.225),(5.827,-36.122,7.153),(5.9,-36.439,7.371),(5.878,-36.3,7.444),(5.871,-36.082,7.287),(5.841,-36.023,7.164),(5.844,-36.18,7.033),(5.812,-36.061,7.056),(5.97,-36.528,7.291),(5.942,-36.302,6.948),(6.064,-35.85,7.131),(5.913,-35.841,7.065),(5.848,-35.91,7.059),(5.818,-35.974,7.062),(6.377,-35.817,6.921),(6.478,-35.913,6.876),(6.424,-35.798,6.477),(6.523,-36.025,6.862),(6.552,-36.074,6.937),(6.427,-36.013,6.523),(6.596,-36.18,7.095),(6.543,-36.164,6.921),(6.587,-36.278,7.099),(6.545,-36.4,7.102),(6.461,-36.5,7.112),(6.289,-36.44,6.901),(6.317,-36.565,7.136),(6.102,-36.443,6.936),(6.146,-36.577,7.177),(6.529,-36.485,7.282),(6.585,-36.364,7.276),(6.426,-36.51,7.434),(6.203,-36.611,7.39),(6.247,-36.573,7.469),(6.345,-36.331,7.548),(6.154,-36.298,7.599),(6.133,-36.451,7.577),(6.296,-36.481,7.529),(5.988,-36.389,7.562),(6.479,-36.382,7.432),(5.83,-35.784,6.672),(7.184,-36.213,5.793),(7.194,-36.096,5.685),(7.105,-36.231,5.782),(7.317,-36.084,5.664),(7.375,-36.388,5.918),(7.467,-36.416,5.849),(6.997,-36.075,5.445),(7.035,-36.268,5.756),(7.182,-36.042,5.626),(7.309,-36.002,5.604),(7.284,-35.824,5.359),(7.346,-36.669,5.428),(7.208,-36.648,5.481),(7.274,-36.668,5.71),(7.464,-36.512,5.839),(7.321,-36.597,5.838),(7.363,-36.472,5.926),(7.214,-36.557,5.88),(7.177,-36.622,5.767),(7.258,-36.446,5.949),(7.089,-36.593,5.572),(7.141,-36.433,5.911),(7.027,-36.525,5.665),(7.056,-36.414,5.854),(6.999,-36.429,5.706),(7.004,-36.348,5.734),(6.973,-36.349,5.576),(6.98,-36.201,5.449),(6.986,-36.28,5.604),(7.387,-35.753,5.006)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for BodySkinIndexedFaceSetNIST.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python BodySkinIndexedFaceSetNIST.py load and self-test diagnostics complete.")
