/**
 *<p>
 *	LatticeXvl was an experimental parametric geometry approach that was not adopted into the X3D standard.
 *	These nodes nevertheless demonstrate extensibility techniques for integrating new capabilities using X3D DOCTYPE (DTD).
 *	The LatticeXvl nodes are merely experimental: not approved by the X3D Abstract Specification, not in the X3D XML Schema, and not in the X3D Unified Object Model (X3DUOM).
 *</p>
 *<p>
 *      The LatticeXvl examples
 *      do show how 
 *      <a href="http://www.lattice3d.com" target="_blank">Lattice technology</a>
 *      from the 
 *      <a href="http://www.xvl3d.com" target="_blank">XVL3D company</a>
 *      was integratable as a commercial extension within X3D.
 *      This technique is repeatable. 
 *      The extension approach to XML DTD validation has been maintained through each version of X3D, 
 *      and is documented further in the actual
 *      <a href="https://www.web3d.org/specifications" target="_blank">X3D DTDs and Schemas</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl" target="_blank">X3D Basic: LatticeXvl</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.LatticeXvl;

