//
// Copyright (C) 1998-2000 Lattice Technology, Inc. All rights reserved.
//

//
// x3pFromProcessor.java

package jp.co.lattice.vProcessor.base;


import  java.awt.*;

import  jp.co.lattice.vProcessor.com.*;

// eBXJ[l
import	jp.co.lattice.vKernel.core.c0.*;


/**
 * Java XVL3 Processor ʊKwɈnf[^̃NX
 * @author	  created by Eishin Matsui (00/03/11-)
 */
public class x3pFromProcessor extends x3pRoot {

    /** }eAɊւNX	*/
	public static class Material {
		
		/** ̗ */
		public double    ambientIntensity = 0.2;
		/** gUˌF */
		public x3pColor  diffuseColor     = null;
		/** F */
		public x3pColor  emissiveColor    = null;
		/** ʔ˂̉s */
		public double    shininess        = 0.2;
		/** ʔˌF */
		public x3pColor  specularColor    = null;
		/** x */
		public double    transparency     = 0.0;

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public Material( x3pGlobal dt )
		{
			diffuseColor  = new x3pColor( dt, 0.8, 0.8, 0.8 );
			emissiveColor = new x3pColor( dt, 0.0, 0.0, 0.0 );
			specularColor = new x3pColor( dt, 0.0, 0.0, 0.0 );
		}
	}
	
   /** eNX`ɊւNX	*/
	public static class Texture {
		
		/**
		 * eNX`t@CURLBXVL3t@CɋLqꂽ܂܂̕ŕԂB								<br>
		 * url != null ̎ image == null  url == null ̎ image != null ƂȂB						<br>
		 *  url == null && image == null ̏ꍇ́AeNX`t@C摜݂ȂƂ
		 */
		public String   url 		= null;
		
		/**
		 * eNX`t@CImageBXVL3t@CɁiBASE64ŃGR[hꂽj摜t@C				<br>
		 * ݂ꍇAϐuimagevɒlB														<br>
		 * url != null ̎ image == null  url == null ̎ image != null ƂȂB						<br>
		 *  url == null && image == null ̏ꍇ́AeNX`t@C摜݂ȂƂ
		 */
		public Image    image		= null;
		
		/**
		 * SJԂtO JԂȂ:false, JԂ:true --- lFtrue
		 */
		public boolean  repeatS		= true;
		
		/**
		 * TJԂtO JԂȂ:false, JԂ:true --- lFtrue
		 */
		public boolean  repeatT		= true;
	}
	
	/** u1̃VFɊւuJava XVL3 Processor ʊKwɈnf[^vv̔z --- l null */
	public x3pShellInfo[]  shellInfo	= null;
	
	/** }eAo^e[u --- l null */
	public Material[]      material     = null;

	/** eNX`o^e[uBeNX`݂Ȃ́Anull --- l null */
	public Texture[]       texture      = null;


// -------------------------------------------------------------------

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		public x3pShellInfo[]  shell		= null;
		public Material[]      material		= null;
		public Texture[]       texture		= null;

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  Global( x3pGlobal dt )
		{
		}
	}

	/** NXp̃O[of[^		*/
	private final Global
	Gbl()
	{
		return  ( ( x3pBaseGblElm )global.GBaseX3p() ).gFromProcessor;
	}

	private final x3pToProcessor.Global
	ToProcessor()
	{
		return  ( ( x3pBaseGblElm )global.GBaseX3p() ).gToProcessor;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public  x3pFromProcessor( x3pGlobal dt )
	{
		super( dt );
	}

// -------------------------------------------------------------------

	/** lvErrorp̃O[of[^				*/
	private final lvError.Global
	ErrProc()
	{
		return   ( ( lvComGblElm )global.GCom() ).gError;
	}

// -------------------------------------------------------------------

	/**
	 * Java XVL3 Processor f[^擾i̊֐sO shellInfo[]  null ƂĂ)
	 * @return				lvConst.LV_SUCCESS ܂ lvConst.LV_FAILURE
	 */
	public final boolean
	GetData()
	{
		try {
			ErrProc().BeginThrowMode();
			
				GetDataMain();
				
			ErrProc().EndThrowMode();
			return  lvConst.LV_SUCCESS;
		}
		catch( lvThrowable exception ) {
			ErrProc().EndThrowMode();
			return  lvConst.LV_FAILURE;
		}
	}
	
	private final void
	GetDataMain() throws lvThrowable
	{
		ExecTraverse();
		ExecInstance();
		MakeNormalMat();
		
		shellInfo = Gbl().shell;
		material  = Gbl().material;
		texture   = Gbl().texture;
		
		Finish();
	}
	
	private final void
	ExecTraverse() throws lvThrowable
	{
		x3pTrvFromKernel  xvl0 = new x3pTrvFromKernel( global );
		xvl0.FromKernel( ToProcessor().topElms );
	}
	
	private final void
	ExecInstance() throws lvThrowable
	{
		int  numInstance[] = null;

		x3pTrvNumInstance  xvl0 = new x3pTrvNumInstance( global );
		xvl0.GetNumInstance( ToProcessor().topElms );
		numInstance = xvl0.GetNumInstance();
		
		int  numShell = Gbl().shell.length;
		for( int i=0; i<numShell; i++ ) {
			Gbl().shell[ i ].instance = new x3pShellInfo.Instance[ numInstance[ i ] ];
			for( int j=0; j<numInstance[ i ]; j++ )
				Gbl().shell[ i ].instance[ j ] = new x3pShellInfo.Instance( global );
		}
			
		x3pTrvInstance  xvl1 = new x3pTrvInstance( global );
		xvl1.SetInstance( ToProcessor().topElms );
	}
	
	private final void
	MakeNormalMat() throws lvThrowable
	{
		int  numShell = Gbl().shell.length;
		for( int i=0; i<numShell; i++ ) {
			int  numInstance = Gbl().shell[ i ].instance.length;
			for( int j=0; j<numInstance; j++ ) {
				x3pShellInfo.Instance  instance = Gbl().shell[ i ].instance[ j ];
				MakeNormalMatMain( instance );
			}
		}
	}
	
	private final void
	MakeNormalMatMain( x3pShellInfo.Instance instance ) throws lvThrowable
	{
		instance.normalMat.Set( instance.posMat );
		instance.normalMat.m[ 3 ][ 0 ] = 0;
		instance.normalMat.m[ 3 ][ 1 ] = 0;
		instance.normalMat.m[ 3 ][ 2 ] = 0;
		
		x3pMatrix  normalMat = new x3pMatrix( global, instance.normalMat );
		
		normalMat.Invert33();
		normalMat.Transpose();
		
		instance.normalMat.Set( normalMat );
	}
	
	private final void
	Finish()
	{
	}
	
}
