//
// Copyright (C) 1998-2000 Lattice Technology, Inc. All rights reserved.
//

//
// lv0ExecUVcalc.java		iŁj
//

package jp.co.lattice.vKernel.texEx.a0x;

import	jp.co.lattice.vKernel.core.c0.*;
import	jp.co.lattice.vKernel.tex.c0a.*;


/**
 * @author	  created by Eishin Matsui (00/06/07-)
 * 
 */
public class lv0ExecUVcalc extends lvExecUVcalc {

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		/** lvMakeUVpublicIuWFNg		*/
		private lvMakeUVpublic     makeUVpublic		= null;

		/** lvMakeUVboundIuWFNg		*/
		private lvMakeUVbound      makeUVbound		= null;

		/** lvMakeUVedgeIuWFNg		*/
		private lvMakeUVedgeVtx    makeUVedgeVtx	= null;

		/** lvMakeUVspaceUVIuWFNg		*/
		private lvMakeUVspaceUV    makeUVspaceUV	= null;

		/** lvMakeUVspaceSTIuWFNg		*/
		private lvMakeUVspaceST    makeUVspaceST	= null;

		/** lvMakeUVoutIuWFNg			*/
		private lvMakeUVout        makeUVout		= null;

		/** lvMakeUVspaceType.UVpublicf[^			*/
		private lvMakeUVspaceType.UVpublic    uvPublic			= null;

		/** lvMakeUVspaceType.Boundf[^				*/
		private lvMakeUVspaceType.Bound       bound				= null;

		/** lvMakeUVspaceType.EdgeVtxf[^				*/
		private lvMakeUVspaceType.EdgeVtx     edgeVtx			= null;

		/** lvMakeUVspaceType.UVspaceUVf[^			*/
		private lvMakeUVspaceType.UVspaceUV   uvSpaceUV			= null;

		/** lvMakeUVspaceType.UVspaceSTf[^			*/
		private lvMakeUVspaceType.UVspaceST   uvSpaceST			= null;

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public Global( lvGlobal dt )
		{
			makeUVpublic  = new lvMakeUVpublic( dt );
			makeUVbound   = new lvMakeUVbound( dt );
			makeUVedgeVtx = new lvMakeUVedgeVtx( dt );
			makeUVspaceUV = new lvMakeUVspaceUV( dt );
			makeUVspaceST = new lvMakeUVspaceST( dt );
			makeUVout     = new lvMakeUVout( dt );
		}
	}

	/** NXp̃O[of[^	*/
	private final Global
	Gbl()
	{
		return  ( ( lv0UVcalcGblElm )global.GUVcalc() ).gExecUVcalc;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public lv0ExecUVcalc( lvGlobal dt )
	{
		super( dt );
	}

// -------------------------------------------------------------------
	
	public void
	Exec( int shellNo, lvToKernelUV srcUVspace ) throws lvThrowable
	{
		Gbl().uvPublic  = Gbl().makeUVpublic.Exec(  shellNo, srcUVspace     );
		Gbl().bound     = Gbl().makeUVbound.Exec(   shellNo, Gbl().uvPublic );
		Gbl().edgeVtx   = Gbl().makeUVedgeVtx.Exec( shellNo, Gbl().uvPublic, Gbl().bound   );
		Gbl().uvSpaceUV = Gbl().makeUVspaceUV.Exec( shellNo, Gbl().uvPublic, Gbl().edgeVtx );
		Gbl().uvSpaceST = Gbl().makeUVspaceST.Exec( shellNo, Gbl().uvPublic, Gbl().edgeVtx, Gbl().uvSpaceUV );
		
		Gbl().makeUVout.Exec( shellNo, Gbl().uvPublic, Gbl().uvSpaceST );
	}
	
	public void
	Finish()
	{
		Gbl().uvPublic  = null;
		Gbl().bound     = null;
		Gbl().edgeVtx   = null;
		Gbl().uvSpaceUV = null;
		Gbl().uvSpaceST = null;
	}
	
}
