//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lv0MakeGreg.java		iŁj
//

package jp.co.lattice.vKernel.greg.t0g;

import	jp.co.lattice.vKernel.core.c0.*;
import	jp.co.lattice.vKernel.core.t0.*;
import	jp.co.lattice.vKernel.greg.c0g.*;


/**
 * @author	  created by Eishin Matsui (00/06/07-)
 */
public class lv0MakeGreg extends lvMakeGreg {

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		/** IuWFNg				*/
		private lvRound			round		= null;
		private lvConvGreg		convGreg	= null;
		
		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public	Global( lvGlobal dt )
		{
			round		= new lvRound( dt );
			convGreg	= new lvConvGreg( dt );
		}
	}

	/** NXp̃O[of[^			*/
	private final Global
	Gbl()
	{
		return  ( ( lv0TopoGGblElm )global.GTopoG() ).gMakeGreg;
	}
	/** lvModelPolyp̃O[of[^				*/
	private final lvModelPoly.Global
	ModelPoly()
	{
		return	( ( lvComGblElm )global.GCom() ).gModelPoly;
	}
	/** lvModelGregp̃O[of[^				*/
	private final lvModelGreg.Global
	ModelGreg()
	{
		return	( ( lv0ComGGblElm )global.GComG() ).gModelGreg;
	}
	/** lvShellPoly.Attrf[^pNXIuWFNg		*/
	private final lvShellPoly.Attr
	Attr( int shellNo )
	{
		return	ModelPoly().shell[ shellNo ].attr;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public lv0MakeGreg( lvGlobal dt )
	{
		super( dt );
	}

// -------------------------------------------------------------------

	public void
	Exec( int shellNo ) throws lvThrowable
	{
		if( Attr( shellNo ).type == lvConst.LV_SS_LATTICE )
			Gbl().round.Exec( shellNo );
		else if( Attr( shellNo ).type == lvConst.LV_SS_GREGORY )
			Gbl().convGreg.Exec( shellNo );
	}
	
}
