//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lvDivPoly.java
//

package jp.co.lattice.vKernel.core.t0;

import	jp.co.lattice.vKernel.core.c0.*;
import	jp.co.lattice.vKernel.core.g0.lvDivPolyLow;
import	jp.co.lattice.vKernel.tex.a0.lvDivPolyUV;
import	jp.co.lattice.vKernel.tex.a0.lv0DivPolyUV;
import	jp.co.lattice.vKernel.tex.a0.lv0AttGblElm;


/**
 * Round̍쐬NXiʃC[j
 * @author	  created by Eishin Matsui (99/08/17-)
 * 
 */
public class lvDivPoly extends lvRoot {
	
	private static final int  maxNumVtxPos = 256;
		
// -------------------------------------------------------------------
	
	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		/** JgVFNo							*/
		private int  curShellNo		= 0;
		
		/** JgGSNo								*/
		private int  curGsNo		= 0;

		/** ʃC[(geom0)IuWFNg				*/
		private lvDivPolyLow              divPolyLow		= null;

		/** ʃC[(att0)IuWFNg				*/
		private lvDivPolyUV               divPolyUV			= null;

		/** lv0AttGblElmIuWFNg		*/
		private lv0AttGblElm              attGblElm			= null;
		
		/** ʃC[(geom0)ɑf[^				*/
		private lvDivPolyLow.DownDivPoly  downDivPoly		= null;
		
		/** ʃC[(geom0)瑗f[^		*/
		private lvDivPolyLow.UpDivPoly    upDivPoly			= null;

		/** K͂ DownDivPoly().vtxPos p̃O[of[^		*/
		private lvVector  tmpVtxPos[]						= null;

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  Global( lvGlobal dt )
		{
			divPolyLow  = new lvDivPolyLow( dt );
			divPolyUV   = new lv0DivPolyUV( dt );
			attGblElm	= new lv0AttGblElm( dt );
			downDivPoly = new lvDivPolyLow.DownDivPoly();
			upDivPoly   = new lvDivPolyLow.UpDivPoly();

			tmpVtxPos = new lvVector[ maxNumVtxPos ];
			for( int i=0; i<maxNumVtxPos; i++ )
				tmpVtxPos[ i ] = new lvVector( dt );
		}
	}

	/** NXp̃O[of[^			*/
	private final Global
	Gbl()
	{
		return  ( ( lvTopoGblElm )global.GTopo() ).gDivPoly;
	}
	/** lvPolygonf[^pNXIuWFNg		*/
	private final lvPolygon
	Polygon()
	{
		return  ( ( lvComGblElm )global.GCom() ).gModelPoly.shell[ Gbl().curShellNo ].poly;
	}
	/** DownRoundp̃O[of[^				*/
	private final lvDivPolyLow.DownDivPoly
	DownDivPoly()
	{
		return  Gbl().downDivPoly;
	}
	/** UpRoundp̃O[of[^				*/
	private final lvDivPolyLow.UpDivPoly
	UpDivPoly()
	{
		return  Gbl().upDivPoly;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public  lvDivPoly( lvGlobal dt )
	{
		super( dt );
	}

// -------------------------------------------------------------------

	/**
	 * 1̃|SeZ[V
	 * @param  shellNo		(( I )) lvToKernel.SetNumShell( num ) ƃZbgꍇA0 ` ( num-1 )
	 * @param  gsNo			(( I )) z lvToKernel.gsNumVtx[] ̒ n ̏ꍇA0 ` ( n-1 )
	 * @return				ʃC[(geom0)瑗f[^
	 */
	public final lvDivPolyLow.UpDivPoly
	Exec( int shellNo, int gsNo ) throws lvThrowable
	{
		Gbl().curShellNo = shellNo;
		Gbl().curGsNo    = gsNo;
		
		SetDownDivPoly();
		if( Gbl().attGblElm.IsDmy() == false )
			Gbl().divPolyUV.SetDownDivPolyUV( shellNo, gsNo, DownDivPoly().divPolyUV );
		
		Gbl().divPolyLow.Exec( DownDivPoly(), UpDivPoly() );
		
		if( Gbl().attGblElm.IsDmy() == false )
			Gbl().divPolyUV.SetUpDivPolyUV();
		SetUpDivPoly();
		
		Finish();
		if( Gbl().attGblElm.IsDmy() == false )
			Gbl().divPolyUV.Finish();
		
		return  UpDivPoly();
	}
	
	private final void
	SetDownDivPoly()
	{
		lvRec.SeqPart  face = Polygon().face[ Gbl().curGsNo ];
		NewDownDivPoly( face.num );
		
		for( int i=0; i<face.num; i++ ) {
			lvPolygon.FaceHalf  faceHalfSeq = Polygon().faceHalfSeq[ face.start + i ];
			lvVector            vtxPos      = DownDivPoly().vtxPos[ i ];
			vtxPos.VecDt2Vector( Polygon().vertex[ faceHalfSeq.vtxNo ].pos );
		}
	}
	
	private final void
	NewDownDivPoly( int num )
	{
		DownDivPoly().numVtxPos = num;
		
		if( num > maxNumVtxPos ) {
			DownDivPoly().vtxPos = new lvVector[ num ];
			for( int i=0; i<maxNumVtxPos; i++ )
				DownDivPoly().vtxPos[ i ] = Gbl().tmpVtxPos[ i ];
			for( int i=maxNumVtxPos; i<num; i++ )
				DownDivPoly().vtxPos[ i ] = new lvVector( global );
		}
		else
			DownDivPoly().vtxPos = Gbl().tmpVtxPos;
	}
	
	private final void
	SetUpDivPoly()
	{
		// no process
	}
	
	private final void
	Finish()
	{
		DownDivPoly().vtxPos = null;		// Delete( DownDivPoly().vtxPos );
	}
	
}
