//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lvTessellateLow.java
//

package jp.co.lattice.vKernel.greg.g0g;

import	jp.co.lattice.vKernel.core.g0.*;
import	jp.co.lattice.vKernel.core.c0.*;

import	jp.co.lattice.vKernel.tex.a0g.lvTessellateUV;
import	jp.co.lattice.vKernel.tex.a0g.lv0TessellateUV;


/**
 * 1̖ʂ쐬NX
 * @author	  created by Eishin Matsui (99/10/12-)
 * 
 */
public class lvTessellateLow extends lvRoot {

	/**
	 * 1{̃n[tGbW_ɊւulvTessellate瑗f[^p̓NXv
	 */
	public static class DownHalf {
		
		/** _in[tGbWn_jW							*/
		public lvVector  pos					= null;
		
		/** nhxNgiCfbNX 0:n_A 1:I_j		*/
		public lvVector  handVec[/*2*/]			= null;

		/** CBDu bxNg viCfbNX 0:n_A 1:I_j			*/
		public lvVector  bCbd[/*2*/]			= null;
		
		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  DownHalf( lvGlobal dt )
		{
			pos = new lvVector( dt );
			
			handVec = new lvVector[ 2 ];
			for( int i=0; i<2; i++ )
				handVec[ i ] = new lvVector( dt );
				
			bCbd = new lvVector[ 2 ];
			for( int i=0; i<2; i++ )
				bCbd[ i ] = new lvVector( dt );
		}
	}
	
	/**
	 * lvTessellate瑗f[^p̓NX
	 */
	public static class DownTessellate {
		
		/** vin[tGbWNo0̏I_n_An[tGbWNo2̎n_I_j̕	*/
		public int       numDivV;
		/**uin[tGbWNo1̎n_I_An[tGbWNo3̏I_n_j̕	*/
		public int       numDivU;
		
		/** n[tGbW񕔂̔ziisDegenerate == true ̎́An[tGbWNo3͖j	*/
		public DownHalf  half[/*4*/]					= null;

		/** UVԏ̔z		*/
		public lvTessellateUV.DownTessellateUV  uvInfo	= new lv0TessellateUV.DownTessellateUV();
		
		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  DownTessellate( lvGlobal dt )
		{
			half = new DownHalf[ 4 ];
			for( int i=0; i<4; i++ )
				half[ i ] = new DownHalf( dt );
		}
	}
	
	/**
	 * lvTessellateɑf[^p̓NX
	 */
	public static class UpTessellate {
		
		/** _				*/
		public int             numVertex;
		/**
		 * _W̔ziL͒_̐u 3ȏ vj --- l null									<br>
		 * _͗ŐulvToKAttr.numDiv  lvToKernel.SetAttr() ŃZbgvȂǂňقȂ
		 */
		public lvRec.PosNorHi  vertex[]							= null;
	
		/** Op|S		*/
		public int             numTriIndex;
		/**
		 * 3_No.Index琬Op|S̔ziL͎Op|S̐u 1ȏ vj --- l null	<br>
		 * Op|S͗ŐulvToKAttr.numDiv  lvToKernel.SetAttr() ŃZbgvȂǂňقȂ
		 */
		public lvRec.TriIndex  triIndex[]						= null;

		/** UVԏ̔z		*/
		public lvTessellateUV.UpTessellateUV  uvInfo	= new lv0TessellateUV.UpTessellateUV();
	}
		
// -------------------------------------------------------------------

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		/** ʃC[IuWFNg							*/
		private lvGregoryStd    gregoryStd				= null;

		/** ʃC[ɑf[^			*/
		private lvGregoryStd.DownGregoryStd      downGregoryStd		= null;

		/** JǵuʃC[瑗f[^v		*/
		private DownTessellate  curDownTessellate		= null;
		/** JǵuʃC[ɑf[^v				*/
		private UpTessellate      curUpTessellate		= null;

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  Global( lvGlobal dt )
		{
			gregoryStd        = new lvGregoryStd( dt );
			downGregoryStd    = new lvGregoryStd.DownGregoryStd( dt );
			
			curDownTessellate = new DownTessellate( dt );
			curUpTessellate   = new UpTessellate();
			
			GlobalTmp( dt );
		}
		
		/** [Jϐp new pobt@GA		*/
		private lvVector  tvAryExecMain[/*5*/]				= null;
		/**
		 * [Jϐp new pobt@iRXgN^Ŏgpj
		 * @param  dt		(( I )) O[of[^
		*/
		private final void
		GlobalTmp( lvGlobal dt )
		{
			tvAryExecMain = new lvVector[ 5 ];	for( int i=0; i<5; i++ )	tvAryExecMain[ i ] = new lvVector( dt );
		}

	}

	/** NXp̃O[of[^			*/
	private final Global
	Gbl()
	{
		return  ( ( lv0GeomGGblElm )global.GGeomG() ).gTessellateLow;
	}
	/** DownGregoryStdp̃O[of[^			*/
	private final lvGregoryStd.DownGregoryStd
	DownGregoryStd()
	{
		return  Gbl().downGregoryStd;
	}
	/** DownTessellatep̃O[of[^			*/
	private final lvTessellateLow.DownTessellate
	DownTessellate()
	{
		return  Gbl().curDownTessellate;
	}
	/** UpRoundp̃O[of[^				*/
	private final lvTessellateLow.UpTessellate
	UpTessellate()
	{
		return  Gbl().curUpTessellate;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public	lvTessellateLow( lvGlobal dt )
	{
		super( dt );
	}
 
// -------------------------------------------------------------------

	/**
	 * s֐
	 */
	public final void
	Exec( DownTessellate downTessellate, UpTessellate upTessellate ) throws lvThrowable
	{
		Gbl().curDownTessellate = downTessellate;
		Gbl().curUpTessellate   = upTessellate;
		
		ExecStd();
	}
	
	private final void
	ExecStd() throws lvThrowable
	{
		DownGregoryStd().numDivU = DownTessellate().numDivU;
		DownGregoryStd().numDivV = DownTessellate().numDivV;
		
		for( int i=0; i<4; i++ )
			ExecMain( i, DownGregoryStd().ctlPnt );
			
		DownGregoryStd().uvInfo = DownTessellate().uvInfo;
			
		Gbl().gregoryStd.Exec( DownGregoryStd(), UpTessellate() );
	}
	
	private final void
	ExecMain( int halfNo, double ctlPnt[/*20*/][/*3*/] ) throws lvThrowable
	{
		lvVector  ctl[/*5*/] = Gbl().tvAryExecMain;
		
		int  halfB = ( halfNo + 4 - 1 ) % 4;
		
		ctl[ 2 ].Assign( DownTessellate().half[ halfNo ].pos );
		
		ctl[ 1 ].Assign( DownTessellate().half[ halfB  ].handVec[ 1 ].Add( ctl[ 2 ] ) );
				// ctl[ 1 ] = DownTessellate().half[ halfB  ].handVec[ 1 ] + ctl[ 2 ];
		ctl[ 3 ].Assign( DownTessellate().half[ halfNo ].handVec[ 0 ].Add( ctl[ 2 ] ) );
				// ctl[ 3 ] = DownTessellate().half[ halfNo ].handVec[ 0 ] + ctl[ 2 ];
		
		ctl[ 0 ].Assign( DownTessellate().half[ halfB  ].bCbd[ 1 ].Add( ctl[ 1 ] ) );
				// ctl[ 0 ] = DownTessellate().half[ halfB  ].bCbd[ 1 ] + ctl[ 1 ];
		ctl[ 4 ].Assign( DownTessellate().half[ halfNo ].bCbd[ 0 ].Add( ctl[ 3 ] ) );
				// ctl[ 4 ] = DownTessellate().half[ halfNo ].bCbd[ 0 ] + ctl[ 3 ];
		
		for( int i=0; i<5; i++ ) {
			ctlPnt[ halfNo*5 + i ][ 0 ] = ctl[ i ].x;
			ctlPnt[ halfNo*5 + i ][ 1 ] = ctl[ i ].y;
			ctlPnt[ halfNo*5 + i ][ 2 ] = ctl[ i ].z;
		}
	}

	public static final int
	NumVertexStd( int numDivU, int numDivV )
	{
		return  ( numDivU + 1 ) * ( numDivV + 1 );
	}
	
	public static final int
	NumTriIndexStd( int numDivU, int numDivV )
	{
		return  numDivU * numDivV * 2;
	}

}
