//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lvDivFaceLow.java
//

package jp.co.lattice.vKernel.greg.g0g;

import	jp.co.lattice.vKernel.core.g0.*;
import	jp.co.lattice.vKernel.core.c0.*;
import	jp.co.lattice.vKernel.greg.c0g.*;


/**
 * DivPoly̍쐬NXiʃC[j
 * @author	  created by Eishin Matsui (99/10/12-)
 * 
 */
public class lvDivFaceLow extends lvRoot {

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		/** JǵuʃC[(topo0)瑗f[^v		*/
		private lvDivFaceType.DownDivFace    curDownDivFace		= null;
		
		/** DownDivFacehf[^				*/
		private lvDivFaceType.DeriveDivFace  deriveDivFace		= null;
		
		/** lvMakeInnerEdgeIuWFNg					*/
		private lvMakeInnerEdge  makeInnerEdge		= null;
		
		/** lvTessellateIuWFNg					*/
		private lvTessellate     tessellate			= null;

		/** static֐p̃IuWFNg					*/
		private lvDivFaceLow     local				= null;
		
		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  Global( lvGlobal dt )
		{
			deriveDivFace = new lvDivFaceType.DeriveDivFace( dt );
			makeInnerEdge = new lvMakeInnerEdge( dt );
			tessellate    = new lvTessellate( dt );
			local         = new lvDivFaceLow( dt );
			
			GlobalTmp( dt );
		}

		/** [Jϐp new pobt@GA		*/
		private lvVector  tvAryPosition[]			= null;
		private lvVector  tvAryDerivative[]			= null;
		/**
		 * [Jϐp new pobt@iRXgN^Ŏgpj
		 * @param  dt		(( I )) O[of[^
		*/
		private final void
		GlobalTmp( lvGlobal dt )
		{
			tvAryPosition    = new lvVector[ 4 ];	for( int i=0; i<4; i++ )	tvAryPosition[ i ]    = new lvVector( dt );
			tvAryDerivative  = new lvVector[ 4 ];	for( int i=0; i<4; i++ )	tvAryDerivative[ i ]  = new lvVector( dt );
		}
		
	}

	/** NXp̃O[of[^			*/
	private final Global
	Gbl()
	{
		return  ( ( lv0GeomGGblElm )global.GGeomG() ).gDivFaceLow;
	}
	/** DownDivFacep̃O[of[^				*/
	private final lvDivFaceType.DownDivFace
	DownDivFace()
	{
		return	Gbl().curDownDivFace;
	}
	/** DeriveDivFace0p̃O[of[^		*/
	private final lvDivFaceType.DeriveDivFace
	DeriveDivFace()
	{
		return  Gbl().deriveDivFace;
	}
	/** NXp̃O[of[^		*/
	private static final lvDivFaceLow
	Local( lvGlobal gbl )
	{
		return  ( ( lv0GeomGGblElm )gbl.GGeomG() ).gDivFaceLow.local;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public	lvDivFaceLow( lvGlobal dt )
	{
		super( dt );
	}

// -------------------------------------------------------------------

	/**
	 * 1̖ʂeZ[V
	 * @param  downDivPoly		(( I )) ʃC[(topo0)瑗f[^
	 * @param  upDivPoly		(( O )) ʃC[(topo0)ɑf[^
	 */
	public final void
	Exec( lvDivFaceType.DownDivFace downDivFace, lvDivFaceType.UpDivFace upDivFace ) throws lvThrowable
	{
		Gbl().curDownDivFace = downDivFace;

		if( DownDivFace().numHalf != 4 )
			Gbl().makeInnerEdge.Exec( downDivFace, DeriveDivFace() );
			
		Gbl().tessellate.Exec( downDivFace, DeriveDivFace(), upDivFace );
	
		Finish();
	}
	
	private final void
	Finish()
	{
		Gbl().curDownDivFace      = null;		// Delete( Gbl().curDownDivFace );
		Gbl().deriveDivFace.inner = null;		// Delete( Gbl().deriveDivFace.inner );
	}
	
	/**
	 * tlł̃xWFȐ̈ʒu߂
	 * @param  halfNo	(( I )) n[tGbWNo
	 * @param  t		(( I )) p[^li 0 ` 1 j
	 * @param  result	(( O )) ʒu
	 */
	public static final void
	Position( int halfNo, double t, lvVector result )
	{
		lvGlobal  gbl = result.global;
		Local( gbl ).PositionLocal( halfNo, t, result );
	}
	
	/**
	 * tlł̃xWFȐ̈ʒu߂i[Jj
	 * @param  halfNo	(( I )) n[tGbWNo
	 * @param  t		(( I )) p[^li 0 ` 1 j
	 * @param  result	(( O )) ʒu
	 */
	private final void
	PositionLocal( int halfNo, double t, lvVector result )
	{
		lvVector  ctlPnt[/*4*/] = Gbl().tvAryPosition;					// ctlPnt[] = new lvVector[ 4 ];
		
		ctlPnt[ 0 ].Assign( DownDivFace().half[ halfNo ].pos );
		ctlPnt[ 1 ].Assign( DownDivFace().half[ halfNo ].handVec[ 0 ] );
		ctlPnt[ 2 ].Assign( DownDivFace().half[ halfNo ].handVec[ 1 ] );
		int  halfF = ( halfNo + 1 ) % DownDivFace().numHalf;
		ctlPnt[ 3 ].Assign( DownDivFace().half[ halfF ].pos );
			
		ctlPnt[ 1 ].AddAssign( ctlPnt[ 0 ] );
		ctlPnt[ 2 ].AddAssign( ctlPnt[ 3 ] );
		
		lvBezLine.Position( ctlPnt, t, result );
	}

	/**
	 * tlł̃xWFȐ̔xNg߂
	 * @param  halfNo	(( I )) n[tGbWNo
	 * @param  t		(( I )) p[^li 0 ` 1 j
	 * @param  result	(( O )) xNg
	 */
	public static final void
	Derivative( int halfNo, double t, lvVector result )
	{
		lvGlobal  gbl = result.global;
		Local( gbl ).DerivativeLocal( halfNo, t, result );
	}
	
	/**
	 * tlł̃xWFȐ̔xNg߂i[Jj
	 * @param  halfNo	(( I )) n[tGbWNo
	 * @param  t		(( I )) p[^li 0 ` 1 j
	 * @param  result	(( O )) xNg
	 */
	private final void
	DerivativeLocal( int halfNo, double t, lvVector result )
	{
		lvVector  ctlPnt[/*4*/] = Gbl().tvAryDerivative;					// ctlPnt[] = new lvVector[ 4 ];
		
		ctlPnt[ 0 ].Assign( DownDivFace().half[ halfNo ].pos );
		ctlPnt[ 1 ].Assign( DownDivFace().half[ halfNo ].handVec[ 0 ] );
		ctlPnt[ 2 ].Assign( DownDivFace().half[ halfNo ].handVec[ 1 ] );
		int  halfF = ( halfNo + 1 ) % DownDivFace().numHalf;
		ctlPnt[ 3 ].Assign( DownDivFace().half[ halfF ].pos );
			
		ctlPnt[ 1 ].AddAssign( ctlPnt[ 0 ] );
		ctlPnt[ 2 ].AddAssign( ctlPnt[ 3 ] );
		
		lvBezLine.Derivative( ctlPnt, t, result );
	}
	
}
