//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lvPolyDerive.java
//

package jp.co.lattice.vKernel.greg.c0g;

import	jp.co.lattice.vKernel.core.c0.*;


/**
 * Java Lattice Kernel ̃VFiq̔hNX
 * @author	  created by Eishin Matsui (99/08/17-)
 * 
 */
public class lvPolyDerive {

	/**
	 * iq(GS)NX
	 */
	public static class PolyCenterLattice {
		
		/** iq(GS)̒SʒuWƖʖ@	*/
		public lvRec.PosNorLow  center	= new lvRec.PosNorLow();
		
		/** iq(GS)̖ʐ					*/
		public double           area;
	}
	
	/**
	 * Java Lattice Kernel ̃VFiq̏pNX
	 * @author	  created by Eishin Matsui (99/08/17-)
	 * 
	 */
	public static class PolyCenter {
		
		/**
		 * iq(GS)񕔂̔ziGSʐ݂u 1ȏ vj --- l null
		 */
		public PolyCenterLattice  lattice[]		= null;
		
		/**
		 * NGʂ̒SʒuW̔ziNGʐ݂j		   --- l null			<br>
		 *		{ۂ߃xNǧׂ݊̈ɕKv
		 */
		public lvVecDt            centerNG[]	= null;

	// -------------------------------------------------------------------

		public final void
		NewLattice( int num )
		{
			lattice = new PolyCenterLattice[ num ];
			for( int i=0; i<num; i++ )
				lattice[ i ] = new PolyCenterLattice();
		}
		
		public final void
		NewNG( int num )
		{
			if( num == 0 )
				return;
			
			centerNG = new lvVecDt[ num ];
			for( int i=0; i<num; i++ )
				centerNG[ i ] = new lvVecDt();
		}
	}

// -------------------------------------------------------------------

	/**
	 * _NX
	 */
	public static class BezgonVertex {
	
		/** _W			*/
		public lvVecDt  pos					= new lvVecDt();
	}
	
	/**
	 * ŐNX
	 */
	public static class BezgonEdge {
	
		/** nhxNgiCfbNX 0:Ő̎n_A 1:Ő̏I_j	*/
		public lvVecDt  handVec[/*2*/]		= null;
	
		public  BezgonEdge()
		{
			handVec = new lvVecDt[ 2 ];
			for( int i=0; i<2; i++ )
				handVec[ i ] = new lvVecDt();
		}
	}
	
	/**
	 * ʏNX
	 */
	public static class BezgonFace {
	
		/** ʖ@			*/
		public lvRec.PosNorLow  center		= new lvRec.PosNorLow();
	}
	
	/**
	 * Java Lattice Kernel ̃VF Bezieriqi_jNX
	 * @author	  created by Eishin Matsui (99/08/17-)
	 * 
	 */
	public static class Bezgon {

		/**
		 * _񕔂̔zi_݂u 3ȏ vj --- l null
		 */
		public BezgonVertex  vertex[]		= null;
	
		/**
		 * Ő񕔂̔ziŐ݂u 3ȏ vj --- l null
		 */
		public BezgonEdge    edge[]			= null;

		/**
		 * GSʏ񕔂̔ziGSʐ݂u 1ȏ vj --- l null
		 */
		public BezgonFace    face[]			= null;

	// -------------------------------------------------------------------

		public final void
		NewVertex( int num )
		{
			vertex = new BezgonVertex[ num ];
			for( int i=0; i<num; i++ )
				vertex[ i ] = new BezgonVertex();
		}
		public final void
		NewEdge( int num )
		{
			edge = new BezgonEdge[ num ];
			for( int i=0; i<num; i++ )
				edge[ i ] = new BezgonEdge();
		}
		public final void
		NewFace( int num )
		{
			face = new BezgonFace[ num ];
			for( int i=0; i<num; i++ )
				face[ i ] = new BezgonFace();
		}
	}
	
}
