//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lvVecCalc.java
//

package jp.co.lattice.vKernel.core.c0;


/**
 * Vector^̐lZpNX    iʕj<br>
 * jlvDblCalc,lvDouble,lvVecCalc,lvVector,lvMatCalc,lvMatrixNXȊOł́AlvVecCalcIuWFNg𐶐Ă͂ȂȂ
 * @author	  created by Eishin Matsui (99/08/17-)
 * 
 */
public class lvVecCalc extends lvRoot {
	
	/** 萔 --- ȂƂÃxNg̒ 0 ł		*/
	public static final byte  LV_ANGSTAT_ZEROVEC	= 0;
	/** 萔 --- 2{̃xNg̐px 0 ł					*/
	public static final byte  LV_ANGSTAT_ZEROANG	= 1;
	/** 萔 --- 2{̃xNg G1ڑĂ						*/
	public static final byte  LV_ANGSTAT_G1			= 2;
	/** 萔 --- ̑												*/
	public static final byte  LV_ANGSTAT_OTHER		= 3;
	
// -------------------------------------------------------------------

	/** Xvf */
	public double  x;
	/** Yvf */
	public double  y;
	/** Zvf */
	public double  z;
	
// -------------------------------------------------------------------

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  Global( lvGlobal dt )
		{
			GlobalBuf( dt );
			GlobalTmp( dt );
		}

		/** lvVecCalcresultp new pobt@			*/
		private static final int  num_resultBufV  = 128;
		/** lvVecCalcresultp new pobt@GA		*/
		private lvVecCalc  resultBufV[]    = null;
		/** lvVecCalcresultp new pobt@JE^		*/
		private int		   cnt_resultBufV  = 0;
	
		/** lvDblCalcresultp new pobt@			*/
		private static final int  num_resultBufD  = 128;
		/** lvDblCalcresultp new pobt@GA		*/
		private lvDouble   resultBufD[]	  = null;
		/** lvDblCalcresultp new pobt@JE^		*/
		private int		   cnt_resultBufD  = 0;
		
		/**
		 * resultp new pobt@iRXgN^Ŏgpj
		 * @param  dt		(( I )) O[of[^
		 */
		private final void
		GlobalBuf( lvGlobal dt )
		{
			resultBufV = new lvVecCalc[ num_resultBufV ];
			for( int i=0; i<num_resultBufV; i++ )
				resultBufV[ i ] = new lvVecCalc( dt );

			resultBufD = new lvDouble[ num_resultBufD ];
			for( int i=0; i<num_resultBufD; i++ )
				resultBufD[ i ] = new lvDouble( dt );
		}

		/** [Jϐp new pobt@GA		*/
//		private lvVector  tvOnLine[]      = null;
//		private lvVector  tvOnLnSeg[]     = null;
//		private lvDouble  tdOnLnSeg[]     = null;
		private lvVector  tvAngleStatus[] = null;
		private lvDouble  tdAngleStatus[] = null;
		private lvVector  tvIntersecLinePlane[] = null;

		/** [Jϐp new pobt@GAilvKernelGregpj		*/
//		private lvVector  tvAngle[]       = null;
//		private lvVector  tvDivide[]      = null;
		private lvDouble  tdIsLine[]      = null;
		private lvVector  tvIsLine[]      = null;
		private lvVector  tvIsPlane[]     = null;
		private lvDouble  tdIsPlane[]     = null;

		/**
		 * [Jϐp new pobt@iRXgN^Ŏgpj
		 * @param  dt		(( I )) O[of[^
		*/
		private final void
		GlobalTmp( lvGlobal dt )
		{
//			tvOnLine      = new lvVector[  8 ];		for( int i=0; i<8;  i++ )	tvOnLine[ i ]      = new lvVector( dt );
//			tvOnLnSeg     = new lvVector[  8 ];		for( int i=0; i<8;  i++ )	tvOnLnSeg[ i ]     = new lvVector( dt );
//			tdOnLnSeg     = new lvDouble[  2 ];		for( int i=0; i<2;  i++ )	tdOnLnSeg[ i ]     = new lvDouble( dt );
			tvAngleStatus = new lvVector[ 12 ];		for( int i=0; i<12; i++ )	tvAngleStatus[ i ] = new lvVector( dt );
			tdAngleStatus = new lvDouble[  2 ];		for( int i=0; i<2;  i++ )	tdAngleStatus[ i ] = new lvDouble( dt );
			tvIntersecLinePlane = new lvVector[ 4 ];
												for( int i=0; i<4; i++ )	tvIntersecLinePlane[ i ] = new lvVector( dt );
			
			// [Jϐp new pobt@ilvKernelGregpj
//			tvAngle       = new lvVector[  4 ];		for( int i=0; i<4;  i++ )	tvAngle[ i ]       = new lvVector( dt );
//			tvDivide      = new lvVector[  8 ];		for( int i=0; i<8;  i++ )	tvDivide[ i ]      = new lvVector( dt );
			tdIsLine      = new lvDouble[  2 ];		for( int i=0; i<2;  i++ )	tdIsLine[ i ]      = new lvDouble( dt );
			tvIsLine      = new lvVector[  2 ];		for( int i=0; i<2;  i++ )	tvIsLine[ i ]      = new lvVector( dt );
			tvIsPlane     = new lvVector[  4 ];		for( int i=0; i<4;  i++ )	tvIsPlane[ i ]     = new lvVector( dt );
			tdIsPlane     = new lvDouble[  2 ];		for( int i=0; i<2;  i++ )	tdIsPlane[ i ]     = new lvDouble( dt );
		}
	}

	/** NXp̃O[of[^		*/
	private final Global
	Gbl()
	{
		return  ( ( lvComGblElm )global.GCom() ).gVecCalc;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^BlvVecCalc,lvVectorNXȊOł́AgpĂ͂ȂȂ
	 * @param  dt		(( I )) O[of[^
	 */
	public  lvVecCalc( lvGlobal dt )
	{
		super( dt );
	}
	/**
	 * Rs[RXgN^BlvVecCalc,lvVectorNXȊOł́AgpĂ͂ȂȂ
	 * @param  dt		(( I )) O[of[^
	 * @param  val		(( I )) Rs[BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 */
	public  lvVecCalc( lvGlobal dt, lvVecCalc val )
	{
		super( dt );
		x = val.x;	y = val.y;	z = val.z;
	}
	/**
	 * l x,y,z ̃RXgN^BlvVecCalc,lvVectorNXȊOł́AgpĂ͂ȂȂ
	 * @param  dt		(( I )) O[of[^
	 * @param  x		(( I )) RXgN^̏lX
	 * @param  y		(( I )) RXgN^̏lY
	 * @param  z		(( I )) RXgN^̏lZ
	 */
	public  lvVecCalc( lvGlobal dt, double x, double y, double z )
	{
		super( dt );
		this.x = x;  this.y = y;  this.z = z;
	}

// -------------------------------------------------------------------

	/**
	 * g̃xNglɃRs[BlvDouble,lvVecCalc,lvVector,lvMatCalc,lvMatrixNXȊOł́AgpĂ͂ȂȂ
	 * @param  val		(( I )) Rs[BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			this ̎Q
	 */
	public final lvVecCalc
	Copy_Local( lvVecCalc val )
	{
		x = val.x;	y = val.y;	z = val.z;
		return	this;
	}
	
	/**
	 * gX,Y,ZlZbg
	 * @param  x		(( I )) Xl
	 * @param  y		(( I )) Yl
	 * @param  x		(( I )) Zl
	 * @return			this ̎Q
	 */
	private lvVecCalc
	SetXYZ_Local( double x, double y, double z )
	{
		this.x = x;  this.y = y;  this.z = z;
		return	this;
	}	

	/** lvVecCalcresultp new pobt@̃CNg		*/
	private final void
	IncResultBufV()
	{
		Gbl().cnt_resultBufV = ( Gbl().cnt_resultBufV + 1 ) % Gbl().num_resultBufV;
	}
	/** lvDblCalcresultp new pobt@̃CNg		*/
	private final void
	IncResultBufD()
	{
		Gbl().cnt_resultBufD = ( Gbl().cnt_resultBufD + 1 ) % Gbl().num_resultBufD;
	}
	
	/**
	 * Vector^̉Z֐i񐄏j
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Add( lvVecCalc val, lvVecCalc result )
	{
		result.SetXYZ_Local( ( x + val.x ), ( y + val.y ), ( z + val.z ) );
		return	result;
	}
	/**
	 * Vector^̉Z֐ij
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Add( lvVecCalc val )
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Add( val, result );
	}

	/**
	 * Vector^̌Z֐i񐄏j
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Sub( lvVecCalc val, lvVecCalc result )
	{
		result.SetXYZ_Local( ( x - val.x ), ( y - val.y ), ( z - val.z ) );
		return	result;
	}
	/**
	 * Vector^̌Z֐ij
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Sub( lvVecCalc val )
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Sub( val, result );
	}

	/**
	 * Vector^̃XJ[{֐i񐄏j
	 * @param  k		(( I )) XJ[
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Mul( double k, lvVecCalc result )
	{
		result.SetXYZ_Local( ( x * k ), ( y * k ),	( z * k ) );
		return	result;
	}
	/**
	 * Vector^̃XJ[{֐ij
	 * @param  k		(( I )) XJ[
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Mul( double k )
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Mul( k, result );
	}
	
	/**
	 * Vector^̃XJ[Z֐i񐄏j
	 * @param  k		(( I )) XJ[
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Div( double k, lvVecCalc result ) throws lvThrowable
	{
		Err().Assert( ( k != 0.0 ), "lvVecCalc.Div(0)" );
		result.SetXYZ_Local( ( x / k ), ( y / k ),	( z / k ) );
		return	result;
	}
	/**
	 * Vector^̃XJ[Z֐ij
	 * @param  k		(( I )) XJ[
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Div( double k ) throws lvThrowable
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Div( k, result );
	}

	/**
	 * Vector^̓ϊ֐
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ϒlidouble:{f[^^j
	 */
	public final double
	Dot( lvVecCalc val )
	{
		return	x * val.x + y * val.y + z * val.z;
	}
	/**
	 * Vector^̓ϊ֐i񐄏j
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( I )) Ԃl
	 * @return			ϒlilvDouble:NXj
	 */
	public final lvDouble
	DotR( lvVecCalc val, lvDouble result )
	{
		result.val = Dot( val );
		return	result;
	}
	/**
	 * Vector^̓ϊ֐ij
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ϒlilvDouble:NXjBKl֐ŕނAdouble a = DotR( b ).val; ̂悤ɂB
	 */
	public final lvDouble
	DotR( lvVecCalc val )
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];	// result = new lvDouble();
		IncResultBufD();
		return	DotR( val, result );
	}

	/**
	 * Vector^̊Oϊ֐i񐄏j
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Cross( lvVecCalc val, lvVecCalc result )
	{
		result.SetXYZ_Local( ( y*val.z - z*val.y ), ( z*val.x - x*val.z ), ( x*val.y - y*val.x ) );
		return	result;
	}
	/**
	 * Vector^̊Oϊ֐ij
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Cross( lvVecCalc val )
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Cross( val, result );
	}

	/**
	 * gixNg:lvVectorjɍs m2 ŃAtBϊxNgԂi񐄏j
	 * @param  m0		(( I )) sBK lvMatrix^ϐA܂͐l֐gi lvMatCalc^͎gpȂ j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
/*
	public final lvVecCalc
	MulVec( lvMatCalc m2, lvVecCalc result )
	{
		result.SetXYZ_Local( x * m2.m[0][0] + y * m2.m[1][0] + z * m2.m[2][0],
							 x * m2.m[0][1] + y * m2.m[1][1] + z * m2.m[2][1],
							 x * m2.m[0][2] + y * m2.m[1][2] + z * m2.m[2][2] );
		return	result;
	}
*/
	/**
	 * gixNg:lvVectorjɍs m2 ŃAtBϊxNgԂij
	 * @param  m0		(( I )) sBK lvMatrix^ϐA܂͐l֐gi lvMatCalc^͎gpȂ j
	 * @return			Kl֐ Assignn֐ŕނ
	 */
/*
	public final lvVecCalc
	MulVec( lvMatCalc m2 )
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	MulVec( m2, result );
	}
*/

	/**
	 * gi3WlƂẴxNg:lvVectorjɍs m2 ŃAtBϊxNgԂi񐄏j
	 * @param  m0		(( I )) sBK lvMatrix^ϐA܂͐l֐gi lvMatCalc^͎gpȂ j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
/*
	public final lvVecCalc
	MulPos( lvMatCalc m2, lvVecCalc result )
	{
		result.SetXYZ_Local( x * m2.m[0][0] + y * m2.m[1][0] + z * m2.m[2][0] + m2.m[3][0],
							 x * m2.m[0][1] + y * m2.m[1][1] + z * m2.m[2][1] + m2.m[3][1],
							 x * m2.m[0][2] + y * m2.m[1][2] + z * m2.m[2][2] + m2.m[3][2] );
		return	result;
	}
*/
	/**
	 * gi3WlƂẴxNg:lvVectorjɍs m2 ŃAtBϊxNgԂij
	 * @param  m0		(( I )) sBK lvMatrix^ϐA܂͐l֐gi lvMatCalc^͎gpȂ j
	 * @return			Kl֐ Assignn֐ŕނ
	 */
/*
	public final lvVecCalc
	MulPos( lvMatCalc m2 )
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	MulPos( m2, result );
	}
*/

	/**
	 * Vector^̔]֐i񐄏j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Neg( lvVecCalc result )
	{
		result.SetXYZ_Local( -x, -y, -z );
		return	result;
	}
	/**
	 * Vector^̔]֐ij
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Neg()
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Neg( result );
	}

	/**
	 * gPʃxNgɂi񐄏j
	 * @param  result	(( O )) K lvVector^ϐƂi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			result ̎Q
	 */
	public final lvVecCalc
	Unit( lvVecCalc result, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVector.Unit(0)" );
		double	len2 = Length2();
		
		if( Eps().IsZero2( len2, eps ) )
			result.x = result.y = result.z = 0.0;
		else {
			double  len = Math.sqrt( len2 );
			result.SetXYZ_Local( x/len, y/len, z/len );
		}
			
		return	result;
	}
	/**
	 * gPʃxNgɂi񐄏j
	 * @param  eps		(( I )) e덷
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Unit( double eps ) throws lvThrowable
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Unit( result, eps );
	}
	/**
	 * gPʃxNgɂij
	 * @return			Kl֐ Assignn֐ŕނ
	 */
	public final lvVecCalc
	Unit() throws lvThrowable
	{
		lvVecCalc  result = Gbl().resultBufV[ Gbl().cnt_resultBufV ];	// result = new lvVecCalc();
		IncResultBufV();
		return	Unit( result, lvEps.l1 );
	}

	/**
	 * gixNgj eps ̌덷 0 ǂ肷i񐄏j
	 * @param  eps		(( I )) e덷
	 * @return			0: false,		0: true
	 */
	public final boolean
	IsZero( double eps ) throws lvThrowable
	{
		Err().Assert( ( Dot( this ) >= 0.0 ), "lvVecCalc.IsZero(0)" );
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.IsZero(1)" );

		if( x < -eps || x > eps )
			return	false;

		if( x == 0.0 && y == 0.0 && z == 0.0 )
			return	true;

		if( y < -eps || y > eps )
			return	false;
		if( z < -eps || z > eps )
			return	false;

		Err().Assert( ( eps > 0.0 ), "lvVecCalc.IsZero(2)" );
		double	eps_sqrt1_3 = ( eps == lvEps.l1 )
			? lvEps.l1xSqrt1_3 : eps * lvConst.LV_SQRT1_3;
		if( -eps_sqrt1_3 <= x && x <= eps_sqrt1_3 &&
			-eps_sqrt1_3 <= y && y <= eps_sqrt1_3 &&
			-eps_sqrt1_3 <= z && z <= eps_sqrt1_3 )
		{
			return	true;
		}
	
		return	Eps().IsZero2( Dot( this ), eps );
	}
	/**
	 * gixNgj lvEps.l1 ̌덷 0 ǂ肷ij
	 * @return			0: false,		0: true
	 */
	public final boolean
	IsZero() throws lvThrowable
	{
		return	IsZero( lvEps.l1 );
	}

	/**
	 * gixNgjƃxNg v0  eps ̌덷œǂ肷i񐄏j
	 * @param  v0		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			Ȃ: false,	: true
	 */
	public final boolean
	IsSame( lvVecCalc v0, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.IsSame(0)" );
		return	v0.Sub( this ).IsZero( eps );		// v0.Sub( this ) ... ( v0 - this )
	}
	/**
	 * gixNgjƃxNg v0  lvEps.l1 ̌덷œǂ肷ij
	 * @param  v0		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			Ȃ: false,	: true
	 */
	public final boolean
	IsSame( lvVecCalc v0 ) throws lvThrowable
	{
		return	IsSame( v0, lvEps.l1 );
	}

	/**
	 * giPʃxNgjƒPʃxNg v0  eps ̌덷Őǂ肷i񐄏j
	 * @param  v0		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			łȂ: false,	: true
	 */
/*
	public final boolean
	IsPerp( lvVecCalc u0, double eps ) throws lvThrowable
	{
		Err().Assert( Eps().IsSame21( Length2(), 1.0, lvEps.e0 ), "lvVecCalc.IsPerp(0)" );
		Err().Assert( Eps().IsSame21( u0.Length2(), 1.0, lvEps.e0 ), "lvVecCalc.IsPerp(1)" );
		Err().Assert( ( 0.0 <= eps && eps < 1.0 ), "lvVecCalc.IsPerp(2)" );
		return	( Math.abs( Dot( u0 ) ) <= eps ) ? true : false;		// Dot( u0 ) ... ( this * u0 )
	}
*/
	/**
	 * giPʃxNgjƒPʃxNg v0  lvEps.a0 ̌덷Őǂ肷ij
	 * @param  v0		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			łȂ: false,	: true
	 */
/*
	public final boolean
	IsPerp( lvVecCalc u0 ) throws lvThrowable
	{
		return	IsPerp( u0, lvEps.a0 );
	}
*/

	/**
	 * g̃xNgԂ
	 * @return			xNgidouble:{f[^^j
	 */
	public final double
	Length() throws lvThrowable
	{
		return	Math.sqrt( Length2() );
	}
	/**
	 * g̃xNgԂi񐄏j
	 * @param  result	(( I )) Ԃl
	 * @return			xNgilvDouble:NXj
	 */
/*
	public final lvDouble
	LengthR( lvDouble result ) throws lvThrowable
	{
		result.val = Length();
		return	result;
	}
*/
	/**
	 * g̃xNgԂij
	 * @return			xNgilvDouble:NXjBKl֐ŕނAdouble a = LengthR().val; ̂悤ɂB
	 */
/*
	public final lvDouble
	LengthR() throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];		// result = new lvDouble();
		IncResultBufD();
		return	LengthR( result );
	}
*/
	
	/**
	 * g̃xNg̕Ԃ
	 * @return			xNg̕idouble:{f[^^j
	 */
	public final double
	Length2() throws lvThrowable
	{
		Err().Assert( ( Dot( this ) >= 0.0 ), "lvVecCalc.Length2(0)" );		// Dot( this ) ... ( this * this )
		return	Dot( this );
	}
	/**
	 * g̃xNg̕Ԃi񐄏j
	 * @param  result	(( I )) Ԃl
	 * @return			xNg̕ilvDouble:NXj
	 */
/*
	public final lvDouble
	Length2R( lvDouble result ) throws lvThrowable
	{
		result.val = Length2();
		return	result;
	}
*/
	/**
	 * g̃xNg̕Ԃij
	 * @return			xNg̕ilvDouble:NXjBKl֐ŕނAdouble a = Length2R().val; ̂悤ɂB
	 */
/*
	public final lvDouble
	Length2R() throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];		// result = new lvDouble();
		IncResultBufD();
		return	Length2R( result );
	}
*/

	/**
	 * gixNgjƃxNg val ̋߂
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			idouble:{f[^^j
	 */
/*
	public final double
	Dist( lvVecCalc val ) throws lvThrowable
	{
		return	Math.sqrt( Dist2( val ) );
	}
*/
	/**
	 * gixNgjƃxNg val ̋߂i񐄏j
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( I )) Ԃl
	 * @return			ilvDouble:NXj
	 */
/*
	public final lvDouble
	DistR( lvVecCalc val, lvDouble result ) throws lvThrowable
	{
		result.val = Dist( val );
		return	result;
	}
*/
	/**
	 * gixNgjƃxNg val ̋߂ij
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ilvDouble:NXjBKl֐ŕނAdouble a = DistR( b ).val; ̂悤ɂB
	 */
/*
	public final lvDouble
	DistR( lvVecCalc val ) throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];	// result = new lvDouble();
		IncResultBufD();
		return	DistR( val, result );
	}
*/
	
	/**
	 * gixNgjƃxNg val ̋̕߂
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			̕idouble:{f[^^j
	 */
/*
	public final double
	Dist2( lvVecCalc val ) throws lvThrowable
	{
		return	Sub( val ).Length2();
	}
*/
	/**
	 * gixNgjƃxNg val ̋̕߂i񐄏j
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( I )) Ԃl
	 * @return			̕ilvDouble:NXj
	 */
/*
	public final lvDouble
	Dist2R( lvVecCalc val, lvDouble result ) throws lvThrowable
	{
		result.val = Dist2( val );
		return	result;
	}
*/
	/**
	 * gixNgjƃxNg val ̋̕߂ij
	 * @param  val		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			̕ilvDouble:NXjBKl֐ŕނAdouble a = Dist2R( b ).val; ̂悤ɂB
	 */
/*
	public final lvDouble
	Dist2R( lvVecCalc val ) throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];	// result = new lvDouble();
		IncResultBufD();
		return	Dist2R( val, result );
	}
*/

	/**
	 * g̓_ɂ邩ǂ𒲂ׂi񐄏j
	 * @param  p1		(( I )) ̎n_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) ̏I_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			ɂȂ:false,  :true
	 */
/*
	public final boolean
	OnLine( lvVecCalc p1, lvVecCalc p2, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.OnLine(0)" );

		lvVector  v1 = Gbl().tvOnLine[0];					// v1 = new lvVector();
		v1.Assign( Sub( p1 ) );							// v1 = this - p1;
		if( v1.IsZero( eps ) )
			return	true;
		lvVector  v2 = Gbl().tvOnLine[1];					// v2 = new lvVector();
		v2.Assign( Sub( p2 ) );							// v2 = this - p2;
		if( v2.IsZero( eps ) )
			return	true;
		lvVector  v0 = Gbl().tvOnLine[2];					// v0 = new lvVector();
		v0.Assign( p2.Sub( p1 ) );						// v0 = p2 - p1;
		if( v0.IsZero( eps ) )
			return	false;

		lvVector  n0 = Gbl().tvOnLine[3];					// n0 = new lvVector();
		n0.Assign( v0.Cross( v1 ) );					// n0 = v0 % v1;
		double	  d0 = n0.Dot( n0 ) / v0.Dot( v0 );		// d0 = ( n0 * n0 ) / ( v0 * v0 );
		return	Eps().IsZero2( d0, eps );
	}
*/
	/**
	 * g̓_ɂ邩ǂ𒲂ׂij
	 * @param  p1		(( I )) ̎n_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) ̏I_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ɂȂ:false,  :true
	 */
/*
	public final boolean
	OnLine( lvVecCalc p1, lvVecCalc p2 ) throws lvThrowable
	{
		return	OnLine( p1, p2, lvEps.l1 );
	}
*/

	/**
	 * g̓_ɂ邩ǂ𒲂ׂi񐄏j
	 * @param  p1		(( I )) ̎n_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) ̏I_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			ɂȂ:false,  :true
	 */
/*
	public final boolean
	OnLnSeg( lvVecCalc p1, lvVecCalc p2, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.OnLnSeg(0)" );

		lvVector  v1 = Gbl().tvOnLnSeg[0];			// v1 = new lvVector();
		v1.Assign( Sub( p1 ) );					// v1 = this - p1;
		if( v1.IsZero( eps ) )
			return	true;
		lvVector  v2 = Gbl().tvOnLnSeg[1];			// v2 = new lvVector();
		v2.Assign( Sub( p2 ) );					// v2 = this - p2;
		if( v2.IsZero( eps ) )
			return	true;
		lvVector  v0 = Gbl().tvOnLnSeg[2];			// v0 = new lvVector();
		v0.Assign( p2.Sub( p1 ) );				// v0 = p2 - p1;
		if( v0.IsZero( eps ) )
			return	false;

		double	t0 = v0.Dot( v1 ) / v0.Dot( v0 );	// t0 = ( v0 * v1 ) / ( v0 * v0 );
		if( t0 < 0.0 || 1.0 < t0 )
			return	false;
		lvDouble  t0_r = Gbl().tdOnLnSeg[0];	t0_r.val =  t0;			// t0_r = new lvDouble( t0 );
		lvVector  p0   = Gbl().tvOnLnSeg[3];							// p0	= new lvVector();
		p0.Assign( p1.Add( t0_r.Mul( v0 ) ) );		// p0 = p1 + t0 * v0;
		return	IsSame( p0, eps );
	}
*/
	/**
	 * g̓_ɂ邩ǂ𒲂ׂij
	 * @param  p1		(( I )) ̎n_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) ̏I_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ɂȂ:false,  :true
	 */
/*
	public final boolean
	OnLnSeg( lvVecCalc p1, lvVecCalc p2 ) throws lvThrowable
	{
		return	OnLnSeg( p1, p2, lvEps.l1 );
	}
*/
	
	/**
	 * ug̓_Ɠ_1ȂvƁug̓_Ɠ_2Ȃv̊pxɊւԂ𒲂ׂi񐄏j
	 * @param  p1		(( I )) _1BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) _2BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			LV_ANGSTAT_ZEROVEC, LV_ANGSTAT_ZEROANG, LV_ANGSTAT_G1, LV_ANGSTAT_OTHER ̂Âꂩ
	 */
	public final int
	AngleStatus( lvVecCalc p1, lvVecCalc p2, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.AngleStatus(0)" );

		lvVector  v1 = Gbl().tvAngleStatus[0];				// v1 = new lvVector();
		v1.Assign( Sub( p1 ) );							// v1 = this - p1;
		if( v1.IsZero( eps ) )
			return	LV_ANGSTAT_ZEROVEC;
		lvVector  v2 = Gbl().tvAngleStatus[1];				// v2 = new lvVector();
		v2.Assign( Sub( p2 ) );							// v2 = this - p2;
		if( v2.IsZero( eps ) )
			return	LV_ANGSTAT_ZEROVEC;
		lvVector  v0 = Gbl().tvAngleStatus[2];				// v0 = new lvVector();
		v0.Assign( p2.Sub( p1 ) );						// v0 = p2 - p1;
		if( v0.IsZero( eps ) )
			return	LV_ANGSTAT_ZEROANG;

		double	  t0;
		lvDouble  t0_r = Gbl().tdAngleStatus[0];			// t0_r = new lvDouble( t0 );
		lvVector  p0   = Gbl().tvAngleStatus[3];			// p0	= new lvVector();

		t0 = v0.Dot( v1 ) / v0.Dot( v0 );				// t0 = ( v0 * v1 ) / ( v0 * v0 );
		if( 0.0 <= t0 && t0 <= 1.0 ) {
			t0_r.val =  t0;
			p0.Assign( p1.Add( t0_r.Mul( v0 ) ) );		// p0 = p1 + t0 * v0;
			boolean  same = IsSame( p0, eps );
			if( same == true )
				return  LV_ANGSTAT_G1;
			else
				return  LV_ANGSTAT_OTHER;
		}
		
		lvVector  ps = Gbl().tvAngleStatus[4];				// ps = new lvVector();
		lvVector  pl = Gbl().tvAngleStatus[5];				// pl = new lvVector();
		lvVector  vs, vl;
		if( v1.Length2() >= v2.Length2() ) {
			pl.Assign( p1 );		vl = v1;
			ps.Assign( p2 );		vs = v2;
		}
		else {
			pl.Assign( p2 );		vl = v2;
			ps.Assign( p1 );		vs = v1;
		}
		vl.NegAssign();									// vl = -vl;
		vs.NegAssign();									// vs = -vs;
		
		t0 = vl.Dot( vs ) / vl.Dot( vl );				// t0 = ( vl * vs ) / ( vl * vl );
		if( 0.0 <= t0 && t0 <= 1.0 ) {
			t0_r.val =  t0;
			p0.Assign( Add( t0_r.Mul( vl ) ) );			// p0 = this + t0 * vl;
			boolean  same = ps.IsSame( p0, eps );
			if( same == true )
				return  LV_ANGSTAT_ZEROANG;
			else
				return  LV_ANGSTAT_OTHER;
		}
		
		return  LV_ANGSTAT_OTHER;
	}
	/**
	 * ug̓_Ɠ_1ȂvƁug̓_Ɠ_2Ȃv̊pxɊւԂ𒲂ׂij
	 * @param  p1		(( I )) _1BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) _2BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			LV_ANGSTAT_ZEROVEC, LV_ANGSTAT_ZEROANG, LV_ANGSTAT_G1, LV_ANGSTAT_OTHER ̂Âꂩ
	 */
	public final int
	AngleStatus( lvVecCalc p1, lvVecCalc p2 ) throws lvThrowable
	{
		return	AngleStatus( p1, p2, lvEps.l1 );
	}

	/**
	 * ugn_ƂvƕʂĂ邩ǂׂi񐄏j
	 * @param  lEnd		(( I )) ̏I_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  org		(( I )) ʏ1_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  normal	(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @param  crossPos (( O )) _̈ʒu
	 * @param  crossT   (( O )) _ tl
	 * @return			LV_INTERSEC_PARA, LV_INTERSEC_ON, LV_INTERSEC_CROSS ̂Âꂩ
	 */
	public final int
	IntersecLinePlane( lvVecCalc lEnd, lvVecCalc org, lvVecCalc normal, double eps, lvVector crossPos,
			lvDouble crossT ) throws lvThrowable
	{
		lvVector  vl = Gbl().tvIntersecLinePlane[0];			// vl = new lvVector();
		vl.Assign( lEnd.Sub( this ) );							// vl = lEnd - this;
		
		if( vl.IsZero( eps ) == true ) {
			lvVector  vd = Gbl().tvIntersecLinePlane[1];						// vd = new lvVector();
			vd.Assign( ( ( Add( lEnd ) ).Div( 2.0 ) ).Sub( org ) );				// vd = ( this + lEnd ) / 2.0 - org;
			if( Eps().IsZero( vd.Dot( normal ), eps ) == true )					// vd.Dot( normal ) --- vd * normal
				return  lvVector.LV_INTERSEC_ON;
				
			return  lvVector.LV_INTERSEC_PARA;
		}
		
		double  nor_vl = normal.Dot( vl );										// nor_vl = normal * vl;
		if( Eps().IsZero( nor_vl, eps ) == true ) {
			if( Eps().IsZero( ( Sub( org ) ).Dot( normal ), eps ) == true )		// ( this - org ) * normal
				return  lvVector.LV_INTERSEC_ON;
				
			return  lvVector.LV_INTERSEC_PARA;
		}
		
		crossT.val = -( normal.Dot( Sub( org ) ) ) / ( normal.Dot( vl ) );
									// crossT.val = -( normal * ( this - org ) ) / ( normal * vl );
		crossPos.Assign( Add( vl.Mul( crossT.val ) ) );							// crossPos = this + vl * crossT.val;
		
		return  lvVector.LV_INTERSEC_CROSS;
	}	 
	/**
	 * ugn_ƂvƕʂĂ邩ǂׂij
	 * @param  lEnd		(( I )) ̏I_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  org		(( I )) ʏ1_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  normal	(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  crossPos (( O )) _̈ʒu
	 * @param  crossT   (( O )) _ tl
	 * @return			LV_INTERSEC_PARA, LV_INTERSEC_ON, LV_INTERSEC_CROSS ̂Âꂩ
	 */
	public final int
	IntersecLinePlane( lvVecCalc lEnd, lvVecCalc org, lvVecCalc normal, lvVector crossPos, lvDouble crossT ) throws lvThrowable
	{
		return  IntersecLinePlane( lEnd, org, normal, lvEps.l1, crossPos, crossT );
	}


// -------------------------------------------------------------------
//		lvKernelGregp API
// -------------------------------------------------------------------

	/**
	 * giPʃxNgjƒPʃxNg v0  eps ̌덷ŕsǂ肷i񐄏j
	 * @param  v0		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			słȂ: false,	s: true
	 */
	public final boolean
	IsPara( lvVecCalc u0, double eps ) throws lvThrowable
	{
		Err().Assert( Eps().IsSame21( Length2(), 1.0, lvEps.e0 ), "lvVecCalc.IsPara(0)" );
		Err().Assert( Eps().IsSame21( u0.Length2(), 1.0, lvEps.e0 ), "lvVecCalc.IsPara(1)" );
		Err().Assert( ( 0.0 <= eps && eps < 1.0 ), "lvVecCalc.IsPara(2)" );
		return	( IsSame( u0, eps ) || IsSame( u0.Neg(), eps ) ) ? true : false;	// u0.Neg() ... -u0
	}
	/**
	 * giPʃxNgjƒPʃxNg v0  lvEps.a0 ̌덷ŕsǂ肷ij
	 * @param  v0		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			słȂ: false,	s: true
	 */
	public final boolean
	IsPara( lvVecCalc u0 ) throws lvThrowable
	{
		return	IsPara( u0, lvEps.a0 );
	}
	
	/**
	 * giPʃxNgjƒPʃxNg u1 ̊px߂
	 * @param  u1		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			pxFWAidouble:{f[^^j
	 */
	public final double
	Angle( lvVecCalc u1 ) throws lvThrowable
	{
		Err().Assert( Eps().IsSame21( Length2(), 1.0, lvEps.e0 ), "lvVecCalc.Angle(00)" );
		Err().Assert( Eps().IsSame21( u1.Length2(), 1.0, lvEps.e0 ), "lvVecCalc.Angle(01)" );

		double	f01 = Dot( u1 );

		if( f01 < -( 1.0 - 1.0e-12 ) ) {
			f01 = Add( u1 ).Length() / 2.0;						// Add( u1 ) ... this + u1
			return	lvConst.LV_PI - 2.0 * Math.asin( f01 );
		}

		if( f01 > ( 1.0 - 1.0e-12 ) ) {
			f01 = Sub( u1 ).Length() / 2.0;						// Sub( u1 ) ... this - u1
			return	2.0 * Math.asin( f01 );
		}

		return	Math.acos( f01 );
	}
	/**
	 * giPʃxNgjƒPʃxNg u1 ̊px߂i񐄏j
	 * @param  u1		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( I )) Ԃl
	 * @return			pxFWAilvDouble:NXj
	 */
/*
	public final lvDouble
	AngleR( lvVecCalc u1, lvDouble result ) throws lvThrowable
	{
		result.val = Angle( u1 );
		return	result;
	}
*/
	/**
	 * giPʃxNgjƒPʃxNg u1 ̊px߂ij
	 * @param  u1		(( I )) PʃxNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			pxFWAilvDouble:NXjBKl֐ŕނAdouble a = AngleR( b ).val; ̂悤ɂB
	 */
/*
	public final lvDouble
	AngleR( lvVecCalc u1 ) throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];	// result = new lvDouble();
		IncResultBufD();
		return	AngleR( u1, result );
	}
*/

	/**
	 * ʂɎˉegixNgjƃxNg v1 ̊px߂i񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n0		(( I )) ʂ̖@xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			pxFWAidouble:{f[^^j
	 */
/*
	public final double
	Angle( lvVecCalc v1, lvVecCalc n0, double eps ) throws lvThrowable
	{
		Err().Assert( Eps().IsSame21( n0.Length2(), 1.0, lvEps.e0 ), "lvVecCalc.Angle(10)" );
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.Angle(11)" );

		lvVector  v2 = Gbl().tvAngle[ 0 ];						// v2 = new lvVector();
		v2.Assign( Sub( ( DotR( n0 ) ).Mul( n0 ) ) );			// v2 = this - ( this * n0 ) * n0;
		if( v2.UnitAssign( eps ).IsZero( lvEps.e0 ) )
			return	lvConst.LV_PI_2;

		lvVector  v3 = Gbl().tvAngle[ 1 ];						// v3 = new lvVector();
		v3.Assign( v1.Sub( ( v1.DotR( n0 ) ).Mul( n0 ) ) );		// v3 = v1 - ( v1 * n0 ) * n0;
		if( v3.UnitAssign( eps ).IsZero( lvEps.e0 ) )
			return	lvConst.LV_PI_2;

		double	theta = v2.Angle( v3 );
		Err().Assert( ( 0.0 <= theta && theta <= lvConst.LV_PI ), "lvVecCalc.Angle(12)" );
		theta = ( ( v2.Cross( v3 ) ).Dot( n0 ) >= 0.0 ) ? theta : lvConst.LV_2PI - theta;
					// ( v2.Cross( v3 ) ).Dot( n0 ) ... ( v2 % v3 ) * n0
		Err().Assert( ( 0.0 <= theta && theta <= lvConst.LV_2PI ), "lvVecCalc.Angle(13)" );
		return	( theta < lvConst.LV_2PI ) ? theta : 0.0;
	}
*/
	/**
	 * ʂɎˉegixNgjƃxNg v1 ̊px߂i񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n0		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @param  result	(( I )) Ԃl
	 * @return			pxFWAilvDouble:NXj
	 */
/*
	public final lvDouble
	AngleR( lvVecCalc v1, lvVecCalc n0, double eps, lvDouble result ) throws lvThrowable
	{
		result.val = Angle( v1, n0, eps );
		return	result;
	}
*/
	/**
	 * ʂɎˉegixNgjƃxNg v1 ̊px߂i񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n0		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			pxFWAilvDouble:NXjBKl֐ŕނAdouble a = AngleR( b, c, e ).val; ̂悤ɂB
	 */
/*
	public final lvDouble
	AngleR( lvVecCalc v1, lvVecCalc n0, double eps ) throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];	// result = new lvDouble();
		IncResultBufD();
		return	AngleR( v1, n0, eps, result );
	}
*/

	/**
	 * ʂɎˉegixNgjƃxNg v1 ̊px߂ij
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n0		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			pxFWAidouble:{f[^^j
	 */
/*
	public final double
	Angle( lvVecCalc v1, lvVecCalc n0 ) throws lvThrowable
	{
		return	Angle( v1, n0, lvEps.l1 );
	}
*/
	/**
	 * ʂɎˉegixNgjƃxNg v1 ̊px߂i񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n0		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  result	(( I )) Ԃl
	 * @return			pxFWAilvDouble:NXj
	 */
/*
	public final lvDouble
	AngleR( lvVecCalc v1, lvVecCalc n0, lvDouble result ) throws lvThrowable
	{
		result.val = Angle( v1, n0, lvEps.l1 );
		return	result;
	}
*/
	/**
	 * ʂɎˉegixNgjƃxNg v1 ̊px߂i񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n0		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			pxFWAilvDouble:NXjBKl֐ŕނAdouble a = AngleR( b, c ).val; ̂悤ɂB
	 */
/*
	public final lvDouble
	AngleR( lvVecCalc v1, lvVecCalc n0 ) throws lvThrowable
	{
		lvDouble  result = Gbl().resultBufD[ Gbl().cnt_resultBufD ];	// result = new lvDouble();
		IncResultBufD();
		return	AngleR( v1, n0, lvEps.l1, result );
	}
*/

	/**
	 * g2xNgɕi񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  v2		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  e1p		(( O )) v1̐
	 * @param  e2p		(( O )) v2̐
	 * @param  eps1		(( I ))  0 ƌȂe덷
	 * @param  eps0		(( I )) px^p[^ 0 ƌȂe덷
	 * @return			łH ł:false,  :true
	 */
	public final boolean
	Divide( lvVecCalc v1, lvVecCalc v2, lvDouble e1p, lvDouble e2p, double eps1, double eps0 ) throws lvThrowable
	{
		Err().Assert( ( eps1 >= 0.0 ), "lvVecCalc.Divide(00)" );
		Err().Assert( ( 0.0 <= eps0 && eps0 < 1.0 ), "lvVecCalc.Divide(01)" );

		double	f01 = Dot( v1 );				// f01 = this * v1;
		double	f02 = Dot( v2 );				// f02 = this * v2;
		double	f11 = v1.Dot( v1 );				// f11 = v1 * v1;
		double	f12 = v1.Dot( v2 );				// f12 = v1 * v2;
		double	f22 = v2.Dot( v2 );				// f22 = v2 * v2;
		double	eps2 = ( eps1 == lvEps.l1 ) ? lvEps.l1xl1 : eps1 * eps1;

		if( f11 <= eps2 ) {
			if( f22 <= eps2 ) {
				e1p.val = 0.0;
				e2p.val = 0.0;
				return	false;
			}
			e1p.val = 0.0;
			e2p.val = f02 / f22;
			return	IsSame( ( e1p.Mul( v1 ) ).Add( e2p.Mul( v2 ) ), eps1 );	// e1p * v1 + e2p * v2
		}

		if( f22 <= eps2 ) {
			e1p.val = f01 / f11;
			e2p.val = 0.0;
			return	IsSame( ( e1p.Mul( v1 ) ).Add( e2p.Mul( v2 ) ), eps1 );	// e1p * v1 + e2p * v2
		}

		double	det = f11 * f22 - f12 * f12;
		if( det <= f11 * f22 * eps0 * eps0 ) {
			e1p.val = ( ( f11 >= f22 ) ? f01 / f11 : f02 / f22 );
			e2p.val = 0.0;
			return	IsSame( ( e1p.Mul( v1 ) ).Add( e2p.Mul( v2 ) ), eps1 );	// e1p * v1 + e2p * v2
		}

		e1p.val = ( f01 * f22 - f12 * f02 ) / det;
		e2p.val = ( f11 * f02 - f01 * f12 ) / det;
		return	true;
	}
	/**
	 * g2xNgɕij
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  v2		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  e1p		(( O )) v1̐
	 * @param  e2p		(( O )) v2̐
	 * @return			łH ł:false,  :true
	 */
/*
	public final boolean
	Divide( lvVecCalc v1, lvVecCalc v2, lvDouble e1p, lvDouble e2p ) throws lvThrowable
	{
		return	Divide( v1, v2, e1p, e2p, lvEps.l1, lvEps.a0 );
	}
*/
	
	/**
	 * g3xNgɕi񐄏j
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  v2		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  v3		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  e1p		(( O )) v1̐
	 * @param  e2p		(( O )) v2̐
	 * @param  e2p		(( O )) v3̐
	 * @param  eps1		(( I ))  0 ƌȂe덷
	 * @param  eps0		(( I )) px^p[^ 0 ƌȂe덷
	 * @return			łH ł:false,  :true
	 */
/*
	public final boolean
	Divide( lvVecCalc v1, lvVecCalc v2, lvVecCalc v3, lvDouble e1p, lvDouble e2p, lvDouble e3p, double eps1, double eps0 )
			throws lvThrowable
	{
		Err().Assert( ( eps1 >= 0.0 ), "lvVecCalc.Divide(10)" );
		Err().Assert( ( 0.0 <= eps0 && eps0 < 1.0 ), "lvVecCalc.Divide(11)" );

		lvVector  u1 = Gbl().tvDivide[0];			// u1 = new lvVector();
		u1.Assign( v2.Cross( v3 ) );			// u1 = v2 % v3;
		double	  k1 = v1.Dot( u1 );			// k1 = v1 * u1;
		if( !Eps().IsZero( k1, eps1 ) && !Eps().IsZero( k1, eps0 ) )
			e1p.val = Dot( u1 ) / k1;			// e1p = ( this * u1 ) / k1;
		else
			e1p.val = 0.0;

		lvVector  u2 = Gbl().tvDivide[1];			// u2 = new lvVector();
		u2.Assign( v3.Cross( v1 ) );			// u2 = v3 % v1;
		double	  k2 = v2.Dot( u2 );			// k2 = v2 * u2;
		if( !Eps().IsZero( k2, eps1 ) && !Eps().IsZero( k2, eps0 ) )
			e2p.val =  Dot( u2 ) / k2;			// e2p = ( this * u2 ) / k2;
		else
			e2p.val =  0.0;

		lvVector  u3 = Gbl().tvDivide[2];			// u3 = new lvVector();
		u3.Assign( v1.Cross( v2 ) );			// u3 = v1 % v2;
		double	  k3 = v3.Dot( u3 );			// k3 = v3 * u3;
		if( !Eps().IsZero( k3, eps1 ) && !Eps().IsZero( k3, eps0 ) )
			e3p.val = Dot( u3 ) / k3;			// e3p = ( this * u3 ) / k3;
		else
			e3p.val = 0.0;

		return	IsSame( ( ( e1p.Mul( v1 ) ).Add( e2p.Mul( v2 ) ) ).Add( e3p.Mul( v3 ) ), eps1 );
						// e1p * v1 + e2p * v2 + e3p * v3
	}
*/
	/**
	 * g3xNgɕij
	 * @param  v1		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  v2		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  v3		(( I )) xNgBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  e1p		(( O )) v1̐
	 * @param  e2p		(( O )) v2̐
	 * @param  e2p		(( O )) v3̐
	 * @return			łH ł:false,  :true
	 */
/*
	public final boolean
	Divide( lvVecCalc v1, lvVecCalc v2, lvVecCalc v3, lvDouble e1p, lvDouble e2p, lvDouble e3p ) throws lvThrowable
	{
		return	Divide( v1, v2, v3, e1p, e2p, e3p, lvEps.l1, lvEps.a0 );
	}
*/
	
	/**
	 * g̓_ʏɂ邩ǂ𒲂ׂi񐄏j
	 * @param  p1		(( I )) ʏ1_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n1		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			ɂȂ:false,  :true
	 */
	public final boolean
	OnPlane( lvVecCalc p1, lvVecCalc n1, double eps ) throws lvThrowable
	{
		Err().Assert( Eps().IsSame21( n1.Length2(), 1.0, lvEps.e0 ), "lvVecCalc.OnPlane(0)" );
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.OnPlane(1)" );

		return	( Math.abs( ( Sub( p1 ) ).Dot( n1 ) ) <= eps ) ? true : false;
					// ( Sub( p1 ) ).Dot( n1 ) ... ( this - p1 ) * n1
	}
	/**
	 * g̓_ʏɂ邩ǂ𒲂ׂij
	 * @param  p1		(( I )) ʏ1_BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  n1		(( I )) ʂ̖@xNgiPʃxNgjBK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ɂȂ:false,  :true
	 */
/*
	public final boolean
	OnPlane( lvVecCalc p1, lvVecCalc n1 ) throws lvThrowable
	{
		return	OnPlane( p1, n1, lvEps.l1 );
	}
*/

	/**
	 * g̓_܂߂3_꒼ɂ邩ǂ𒲂ׂi񐄏j
	 * @param  p1		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			꒼ɂȂ:false,  ꒼:true
	 */
	public final boolean
	IsLine( lvVecCalc p1, lvVecCalc p2, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.IsLine(0)" );

		lvDouble  a0 = Gbl().tdIsLine[0];		// a0 = new lvDouble();
		lvVector  p0 = Gbl().tvIsLine[0];		// p0 = new lvVector();
		p0.Assign( this );
		p0.NormalAssign( p1, p2, a0, eps );
		return	( a0.val == 0.0 ) ? true : false;
	}
	/**
	 * g̓_܂߂3_꒼ɂ邩ǂ𒲂ׂij
	 * @param  p1		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			꒼ɂȂ:false,  ꒼:true
	 */
	public final boolean
	IsLine( lvVecCalc p1, lvVecCalc p2 ) throws lvThrowable
	{
		return	IsLine( p1, p2, lvEps.l1 );
	}
	
	/**
	 * g̓_܂߂4_ꕽʏɂ邩ǂ𒲂ׂi񐄏j
	 * @param  p1		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p3		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  eps		(( I )) e덷
	 * @return			ꕽʏɂȂ:false,  ꕽʏ:true
	 */
	public final boolean
	IsPlane( lvVecCalc p1, lvVecCalc p2, lvVecCalc p3, double eps ) throws lvThrowable
	{
		Err().Assert( ( eps >= 0.0 ), "lvVecCalc.IsPlane(0)" );

		lvDouble  a0 = Gbl().tdIsPlane[0];			// a0 = new lvDouble();
		lvVector  n0 = Gbl().tvIsPlane[0];			// n0 = new lvVector();
		n0.Assign( this );
		n0.NormalAssign( p1, p2, p3, a0, eps );
		if( a0.val == 0.0 )
			return	true;

		lvVector  c0 = Gbl().tvIsPlane[1];			// c0 = new lvVector();
		c0.Assign( ( Add( p1 ).Add( p2 ).Add( p3 ) ).Mul( 0.25 ) );
							// c0 = ( this + p1 + p2 + p3 ) * 0.25
		if( !OnPlane( c0, n0, eps ) || !p1.OnPlane( c0, n0, eps )
			|| !p2.OnPlane( c0, n0, eps ) || !p3.OnPlane( c0, n0, eps ) )
		{
			return	false;
		}
		return	true;
	}
	/**
	 * g̓_܂߂4_ꕽʏɂ邩ǂ𒲂ׂij
	 * @param  p1		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p2		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @param  p3		(( I )) _BK lvVector^ϐA܂͐l֐gi lvVecCalc^͎gpȂ j
	 * @return			ꕽʏɂȂ:false,  ꕽʏ:true
	 */
	public final boolean
	IsPlane( lvVecCalc p1, lvVecCalc p2, lvVecCalc p3 ) throws lvThrowable
	{
		return	IsPlane( p1, p2, p3, lvEps.l1 );
	}

}
