//
// Copyright (C) 1998-1999 Lattice Technology, Inc. All rights reserved.
//

//
// lvRec.java
//

package jp.co.lattice.vKernel.core.c0;


/**
 * Java Lattice Kernel ŋʂɈ\̂̃NX
 * @author	  created by Eishin Matsui (99/08/17-)
 * 
 */
public class lvRec {

	/**
	 * 1̒_ɑ΂WʒuƖ@xNg̓NXilvVecDtpj
	 */
	public static class PosNorLow {
	
		/** _ʒu		*/
		public lvVecDt	pos			= new lvVecDt();
	
		/** @xNg	*/
		public lvVecDt	normal		= new lvVecDt();

	// -------------------------------------------------------------------

		/**
		 * Rs[֐
		 * @param  src		(( I )) Rs[
		 * @param  dst		(( O )) Rs[
		 */
/*
		public static final void
		Copy( PosNorLow src, PosNorLow dst )
		{
			lvVecDt.Copy( src.pos,    dst.pos );
			lvVecDt.Copy( src.normal, dst.normal );
		}
*/
	}

	/**
	 * 1̒_ɑ΂WʒuƖ@xNg̓NXilvVectorpj
	 */
	public static class PosNorHi {
	
		/** _ʒu		*/
		public lvVector  pos		= null;
	
		/** @xNg	*/
		public lvVector  normal		= null;

	// -------------------------------------------------------------------

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  PosNorHi( lvGlobal dt )
		{
			pos    = new lvVector( dt );
			normal = new lvVector( dt );
		}

	// -------------------------------------------------------------------

		/**
		 * Rs[֐
		 * @param  src		(( I )) Rs[
		 * @param  dst		(( O )) Rs[
		 */
/*
		public static final void
		Copy( PosNorHi src, PosNorHi dst )
		{
			dst.pos.Assign( src.pos );
			dst.normal.Assign( src.normal );
		}
*/

		/**
		 * PosNorHif[^PosNorLowf[^ɕϊ
		 * @param  src		(( I )) PosNorHif[^
		 * @param  dst		(( O )) PosNorLowf[^
		 */
		public static final void
		HiToLow( PosNorHi src, PosNorLow dst )
		{
			src.pos.Vector2VecDt( dst.pos );
			src.normal.Vector2VecDt( dst.normal );
		}
	}

	/**
	 * `f[^zɑ΂Ĉꕔoۂ́AJn_ƌLqNX
	 */
	public static class SeqPart {
	
		/** Jn_ */
		public int	start;
	
		/**    */
		public int  num;

	// -------------------------------------------------------------------

		/**
		 * Rs[֐
		 * @param  src		(( I )) Rs[
		 * @param  dst		(( O )) Rs[
		 */
		public static final void
		Copy( SeqPart src, SeqPart dst )
		{
			dst.start = src.start;
			dst.num   = src.num;
		}
	}

	/**
	 * 1̎Op|S̒_NoLqNX
	 */
	public static class TriIndex {
	
		/** Op|S̒_No̔zi = 3 j		*/
		public int	vtxNo[/*3*/]	= new int[ 3 ];

	// -------------------------------------------------------------------

		/**
		 * Rs[֐
		 * @param  src		(( I )) Rs[
		 * @param  dst		(( O )) Rs[
		 */
		public static final void
		Copy( TriIndex src, TriIndex dst )
		{
			for( int i=0; i<3; i++ )
				dst.vtxNo[ i ] = src.vtxNo[ i ];
		}
	}
	
	/**
	 * WnLqNX
	 */
	public static class CoordSys {
	
		/** _	*/
		public lvVector  org		= null;
		/** x		*/
		public lvVector	 xAxis		= null;
		/** y		*/
		public lvVector	 yAxis		= null;
		/** z		*/
		public lvVector	 zAxis		= null;

	// -------------------------------------------------------------------

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public  CoordSys( lvGlobal dt )
		{
			org   = new lvVector( dt );
			xAxis = new lvVector( dt );
			yAxis = new lvVector( dt );
			zAxis = new lvVector( dt );
		}

	// -------------------------------------------------------------------

		/**
		 * Rs[֐
		 * @param  src		(( I )) Rs[
		 * @param  dst		(( O )) Rs[
		 */
/*
		public static final void
		Copy( CoordSys src, CoordSys dst )
		{
			dst.org.Assign( src.org );
			dst.xAxis.Assign( src.xAxis );
			dst.yAxis.Assign( src.yAxis );
			dst.zAxis.Assign( src.zAxis );
		}
*/
	}
	
}
