//
// Copyright (C) 1998-2000 Lattice Technology, Inc. All rights reserved.
//

//
// lv0MakeUVspace.java		iŁj
//

package jp.co.lattice.vKernel.tex.a0;

import	jp.co.lattice.vKernel.core.c0.*;
import	jp.co.lattice.vKernel.tex.c0a.*;
import	jp.co.lattice.vKernel.texEx.a0x.lvExecUVcalc;
import	jp.co.lattice.vKernel.texEx.a0x.lv0ExecUVcalc;
import	jp.co.lattice.vKernel.texEx.a0x.lv0UVcalcGblElm;


/**
 * @author	  created by Eishin Matsui (00/04/07-)
 * 
 */
public class lv0MakeUVspace extends lvMakeUVspace {

	/**
	 * staticϐp̂߂̓NX
	 */
	public static class Global {
		
		/** lv0UVcalcGblElmIuWFNg		*/
		private lv0UVcalcGblElm    uvCalcGblElm		= null;
		
		/** lvCheckUVspaceIuWFNg		*/
		private lvCheckUVspace     checkUVspace		= null;

		/** lvMakeUVnonCalcIuWFNg		*/
		private lvMakeUVnonCalc    makeUVnonCalc	= null;

		/** lvExecUVcalcIuWFNg		*/
		private lvExecUVcalc       execUVcalc		= null;

		/**
		 * RXgN^
		 * @param  dt		(( I )) O[of[^
		 */
		public Global( lvGlobal dt )
		{
			uvCalcGblElm  = new lv0UVcalcGblElm( dt );
			checkUVspace  = new lvCheckUVspace( dt );
			makeUVnonCalc = new lvMakeUVnonCalc( dt );
			execUVcalc    = new lv0ExecUVcalc( dt );
		}
	}

	/** NXp̃O[of[^	*/
	private final Global
	Gbl()
	{
		return  ( ( lv0AttGblElm )global.GAtt() ).gMakeUVspace;
	}
	private final lvModelAtt.Global
	ModelAtt()
	{
		return  ( ( lvComAGblElm )global.GComA() ).gModelAtt;
	}

// -------------------------------------------------------------------

	/**
	 * RXgN^
	 * @param  dt		(( I )) O[of[^
	 */
	public lv0MakeUVspace( lvGlobal dt )
	{
		super( dt );
	}

// -------------------------------------------------------------------
	
	public void
	Exec( int shellNo, lvToKernelUV srcUVspace ) throws lvThrowable
	{
		if( srcUVspace == null )
			return;
			
		if( Gbl().checkUVspace.NeedUVcalc( shellNo, srcUVspace ) == false ) {
			ModelAtt().shell[ shellNo ].uvPublic = new lvUVpublic();
			ModelAtt().shell[ shellNo ].uvSpace  = new lvUVspace();

			ExecUVnonCalc( shellNo, srcUVspace );
		}
		else if( Gbl().uvCalcGblElm.IsDmy() == false ) {
			ModelAtt().shell[ shellNo ].uvPublic = new lvUVpublic();
			ModelAtt().shell[ shellNo ].uvSpace  = new lvUVspace();

			ExecUVcalc( shellNo, srcUVspace );
		}
			
		Finish();
	}
	
	private final void
	ExecUVnonCalc( int shellNo, lvToKernelUV srcUVspace ) throws lvThrowable
	{
		Gbl().makeUVnonCalc.Exec( shellNo, srcUVspace );
	}
	
	private final void
	ExecUVcalc( int shellNo, lvToKernelUV srcUVspace ) throws lvThrowable
	{
		Gbl().execUVcalc.Exec( shellNo, srcUVspace );
	}
	
	private final void
	Finish()
	{
		Gbl().execUVcalc.Finish();
	}
	
}
