####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python XvlShellModelStar.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

print('*** Lattice Xvl nodes were an experimental extensibility effort in 2002 and are not supported in ISO-standard X3D. Exiting.')
import sys
sys.exit()
####################################################################################################

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='XvlShellModelStar.x3d',name='title'),
    meta(content='Example XvlShell model.',name='description'),
    meta(content='Marc Jablonski',name='creator'),
    meta(content='24 January 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Test X3D DTD experimental extensions mechanisms, the XVL nodes are not legal X3D',name='error'),
    meta(content='readme.txt',name='reference'),
    meta(content='docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='http://www.xvl3d.com',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/XvlShellModelStar.x3d',name='identifier'),
    meta(content='Lattice XVL parametric geometry X3D VRML',name='subject'),
    meta(content='Xvl3ToX3d, http://www.lattice3d.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='XvlShellModelStar.x3d'),
    Transform(DEF='_G1',
      children=[
      Group(DEF='_S1',
        children=[
        Shape(
          appearance=Appearance(
            material=Material(DEF='SGE_DEF_MATERIAL'),
            texture=ImageTexture(DEF='metal',url=["metal.jpg","https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/metal.jpg"])),
          geometry=XvlShell(faceCoordIndex=[11,9,26,22,-1,67,69,52,56,-1,73,67,56,77,-1,69,73,77,52,-1,66,68,72,-1,70,62,64,-1,6,14,12,-1,8,4,10,-1,13,15,7,-1,9,11,5,-1,73,69,67,-1,63,71,65,-1,46,58,61,39,-1,42,46,39,37,-1,58,42,37,61,-1,59,43,40,61,-1,47,59,61,38,-1,43,47,38,40,-1,45,41,37,38,-1,57,45,38,61,-1,41,57,61,37,-1,31,35,40,38,-1,19,31,38,16,-1,35,19,16,40,-1,29,17,16,38,-1,33,29,38,37,-1,17,33,37,16,-1,20,36,40,16,-1,32,20,16,39,-1,36,32,39,40,-1,18,30,39,16,-1,34,18,16,37,-1,30,34,37,39,-1,48,44,40,39,-1,60,48,39,61,-1,44,60,61,40,-1,54,75,58,46,-1,50,54,46,42,-1,75,50,42,58,-1,76,51,43,59,-1,55,76,59,47,-1,51,55,47,43,-1,53,49,41,45,-1,74,53,45,57,-1,49,74,57,41,-1,23,27,35,31,-1,2,23,31,19,-1,27,2,19,35,-1,21,0,17,29,-1,25,21,29,33,-1,0,25,33,17,-1,3,28,36,20,-1,24,3,20,32,-1,28,24,32,36,-1,1,22,30,18,-1,26,1,18,34,-1,22,26,34,30,-1,56,52,44,48,-1,77,56,48,60,-1,52,77,60,44,-1,65,71,75,54,-1,63,65,54,50,-1,71,63,50,75,-1,72,68,51,76,-1,66,72,76,55,-1,68,66,55,51,-1,64,62,49,53,-1,70,64,53,74,-1,62,70,74,49,-1,12,14,27,23,-1,6,12,23,2,-1,14,6,2,27,-1,10,4,0,21,-1,8,10,21,25,-1,4,8,25,0,-1,7,15,28,3,-1,13,7,3,24,-1,15,13,24,28,-1,5,11,22,1,-1,9,5,1,26,-1],faceTexCoordIndex=[8,28,32,19,-1,32,19,8,28,-1,48,13,0,47,-1,29,1,18,33,-1,41,27,0,-1,11,26,42,-1,41,27,0,-1,26,42,11,-1,41,27,0,-1,26,42,11,-1,41,27,0,-1,26,42,11,-1,14,43,46,7,-1,22,36,30,2,-1,8,28,34,21,-1,35,23,9,28,-1,44,15,0,45,-1,30,3,20,37,-1,8,28,34,21,-1,14,43,46,7,-1,22,36,30,2,-1,35,23,9,28,-1,44,15,0,45,-1,30,3,20,37,-1,14,43,46,7,-1,22,36,30,2,-1,8,28,34,21,-1,35,23,9,28,-1,44,15,0,45,-1,30,3,20,37,-1,14,43,46,7,-1,22,36,30,2,-1,8,28,34,21,-1,35,23,9,28,-1,44,15,0,45,-1,30,3,20,37,-1,0,50,49,17,-1,24,40,31,5,-1,8,28,39,25,-1,38,25,8,28,-1,51,10,16,47,-1,31,4,24,40,-1,8,28,39,25,-1,0,50,49,17,-1,24,40,31,5,-1,38,25,8,28,-1,51,10,16,47,-1,31,4,24,40,-1,0,50,49,17,-1,24,40,31,5,-1,8,28,39,25,-1,38,25,8,28,-1,51,10,16,47,-1,31,4,24,40,-1,0,50,49,17,-1,24,40,31,5,-1,8,28,39,25,-1,38,25,8,28,-1,51,10,16,47,-1,31,4,24,40,-1,12,47,48,6,-1,18,33,29,1,-1,8,28,32,19,-1,32,19,8,28,-1,48,13,0,47,-1,29,1,18,33,-1,8,28,32,19,-1,12,47,48,6,-1,18,33,29,1,-1,32,19,8,28,-1,48,13,0,47,-1,29,1,18,33,-1,12,47,48,6,-1,18,33,29,1,-1,8,28,32,19,-1,32,19,8,28,-1,48,13,0,47,-1,29,1,18,33,-1,12,47,48,6,-1,18,33,29,1,-1],shellType='LATTICE_MESH',vertexRound=[1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.946602,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.946602,0.946602,0.946602,0.946602,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,0.946602,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0,1.0],
            coord=Coordinate(DEF='COORD0',point=[(-3.55104,-0.960228,-0.960231),(-3.55104,-0.960228,0.960231),(-3.55104,0.960228,-0.960231),(-3.55104,0.960228,0.960231),(-3.37616,-1.69009,-1.69009),(-3.37616,-1.69009,1.69009),(-3.37616,1.69009,-1.69009),(-3.37616,1.69009,1.69009),(-1.69009,-3.37616,-1.69009),(-1.69009,-3.37616,1.69009),(-1.69009,-1.69009,-3.37616),(-1.69009,-1.69009,3.37616),(-1.69009,1.69009,-3.37616),(-1.69009,1.69009,3.37616),(-1.69009,3.37616,-1.69009),(-1.69009,3.37616,1.69009),(-1.68607,0,0),(-1.63219,-0.708152,-0.708154),(-1.63219,-0.708152,0.708154),(-1.63219,0.708152,-0.708154),(-1.63219,0.708152,0.708154),(-0.960232,-0.960228,-3.55104),(-0.960232,-0.960228,3.55104),(-0.960232,0.960228,-3.55104),(-0.960232,0.960228,3.55104),(-0.960228,-3.55105,-0.960228),(-0.960228,-3.55105,0.960228),(-0.960228,3.55105,-0.960228),(-0.960228,3.55105,0.960228),(-0.708154,-0.708152,-1.63219),(-0.708154,-0.708152,1.63219),(-0.708154,0.708152,-1.63219),(-0.708154,0.708152,1.63219),(-0.708152,-1.63219,-0.708152),(-0.708152,-1.63219,0.708152),(-0.708152,1.63219,-0.708152),(-0.708152,1.63219,0.708152),(0,-1.68607,0),(0,0,-1.68607),(0,0,1.68607),(0,1.68607,0),(0.708152,-1.63219,-0.708152),(0.708152,-1.63219,0.708152),(0.708152,1.63219,-0.708152),(0.708152,1.63219,0.708152),(0.708154,-0.708152,-1.63219),(0.708154,-0.708152,1.63219),(0.708154,0.708152,-1.63219),(0.708154,0.708152,1.63219),(0.960228,-3.55105,-0.960228),(0.960228,-3.55105,0.960228),(0.960228,3.55105,-0.960228),(0.960228,3.55105,0.960228),(0.960232,-0.960228,-3.55104),(0.960232,-0.960228,3.55104),(0.960232,0.960228,-3.55104),(0.960232,0.960228,3.55104),(1.63219,-0.708152,-0.708154),(1.63219,-0.708152,0.708154),(1.63219,0.708152,-0.708154),(1.63219,0.708152,0.708154),(1.68607,0,0),(1.69009,-3.37616,-1.69009),(1.69009,-3.37616,1.69009),(1.69009,-1.69009,-3.37616),(1.69009,-1.69009,3.37616),(1.69009,1.69009,-3.37616),(1.69009,1.69009,3.37616),(1.69009,3.37616,-1.69009),(1.69009,3.37616,1.69009),(3.37616,-1.69009,-1.69009),(3.37616,-1.69009,1.69009),(3.37616,1.69009,-1.69009),(3.37616,1.69009,1.69009),(3.55104,-0.960228,-0.960231),(3.55104,-0.960228,0.960231),(3.55104,0.960228,-0.960231),(3.55104,0.960228,0.960231)]),
            texCoord=TextureCoordinate(DEF='TEXCOORD0',point=[(0,0),(0,0.513936),(0,0.544969),(0,0.544973),(0,0.969199),(0,0.969203),(0,1.28484),(0,1.36242),(0,2.02328),(0,2.02329),(0,2.42301),(0,2.52911),(8.88178e-016,0),(8.88178e-016,1.28484),(4.89897e-006,0),(4.89897e-006,1.36242),(4.89899e-006,0),(4.89899e-006,2.42301),(0.62944,0),(0.62944,2.53722),(0.66745,0),(0.66745,2.56826),(0.667453,0),(0.667453,2.56826),(1.18702,0),(1.18702,2.99248),(1.46018,0),(1.46018,2.52911),(1.652,0),(1.652,2.53722),(1.652,2.56826),(1.652,2.99248),(2.28144,0.513936),(2.28144,2.02328),(2.31945,0.544969),(2.31945,0.544973),(2.31945,2.02328),(2.31945,2.02329),(2.83903,0.969199),(2.83903,0.969203),(2.83903,2.02328),(2.92036,0),(2.92036,2.52911),(4.12999,0),(4.12999,1.36242),(4.13,0),(4.13,1.36242),(4.13001,0),(4.13001,1.28484),(4.13001,2.42301),(4.13002,0),(4.13002,2.42301)])))])])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for XvlShellModelStar.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python XvlShellModelStar.py load and self-test diagnostics complete.")
