####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python XvlShellModelOctopus.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

print('*** Lattice Xvl nodes were an experimental extensibility effort in 2002 and are not supported in ISO-standard X3D. Exiting.')
import sys
sys.exit()
####################################################################################################

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='XvlShellModelOctopus.x3d',name='title'),
    meta(content='Example XvlShell model.',name='description'),
    meta(content='Marc Jablonski',name='creator'),
    meta(content='24 January 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Test X3D DTD experimental extensions mechanisms, the XVL nodes are not legal X3D',name='error'),
    meta(content='readme.txt',name='reference'),
    meta(content='docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='http://www.xvl3d.com',name='reference'),
    meta(content='Lattice XVL parametric geometry X3D VRML',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/XvlShellModelOctopus.x3d',name='identifier'),
    meta(content='Xvl3ToX3d, http://www.lattice3d.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='XvlShellModelOctopus.x3d'),
    Group(DEF='_S5',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL3',ambientIntensity=0.2801,diffuseColor=(0,0,0),specularColor=(0.6822,0.7154,0.7154))),
        geometry=XvlShell(faceCoordIndex=[3,1,0,2,-1,6,2,0,4,-1,5,1,3,7,-1,5,7,6,4,-1,7,3,2,6,-1,1,5,4,0,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD0',point=[(-1.0028,-0.1284,1.1594),(-1.0028,0.3109,1.201),(-0.9873,-0.1699,1.5985),(-0.9873,0.2694,1.64),(-0.5617,-0.127,1.1441),(-0.5617,0.3123,1.1856),(-0.5463,-0.1685,1.5831),(-0.5463,0.2708,1.6247)])))]),
    Group(DEF='_S1',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL4',ambientIntensity=0.2801,diffuseColor=(0,0,0),specularColor=(0.6822,0.7154,0.7154))),
        geometry=XvlShell(faceCoordIndex=[3,1,0,2,-1,6,2,0,4,-1,5,1,3,7,-1,5,7,6,4,-1,7,3,2,6,-1,1,5,4,0,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD1',point=[(0.0932,-0.1431,1.1521),(0.0932,0.2962,1.1936),(0.1087,-0.1846,1.5911),(0.1087,0.2547,1.6327),(0.5342,-0.1417,1.1367),(0.5342,0.2976,1.1783),(0.5497,-0.1832,1.5758),(0.5497,0.2561,1.6173)])))]),
    Group(DEF='_S2',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL0',diffuseColor=(0.8211,0.4317,0.5051),emissiveColor=(0.2033,0.1068,0.125),specularColor=(0.5447,0.2863,0.335))),
        geometry=XvlShell(faceCoordIndex=[58,35,61,-1,140,145,106,-1,189,145,172,190,-1,172,145,140,-1,165,172,126,137,-1,190,172,165,173,-1,172,140,126,-1,126,140,106,-1,18,58,86,95,77,-1,184,188,183,181,-1,86,61,78,-1,78,61,35,-1,112,103,75,84,-1,70,78,35,41,-1,198,206,205,194,-1,73,133,129,71,-1,184,177,180,188,-1,189,133,73,18,-1,120,189,18,77,-1,120,77,95,-1,173,165,137,139,-1,202,204,197,195,-1,101,123,128,95,-1,144,190,173,-1,99,152,131,109,-1,129,133,189,187,-1,184,181,164,177,-1,205,206,204,202,-1,135,152,99,103,-1,120,95,106,145,189,-1,135,103,112,134,-1,128,126,106,95,-1,109,131,123,101,-1,103,99,59,75,-1,195,197,186,182,-1,139,128,107,144,173,-1,123,102,107,128,-1,170,174,154,144,-1,110,111,152,135,-1,131,105,102,123,-1,131,152,111,105,-1,135,134,114,110,-1,137,126,128,139,-1,168,180,177,164,-1,205,202,195,194,-1,188,180,168,183,-1,86,78,76,95,-1,198,197,204,206,-1,112,84,114,134,-1,84,75,110,114,-1,101,95,76,85,-1,109,101,85,79,-1,76,78,70,69,-1,164,181,166,138,-1,99,109,79,59,-1,110,75,59,111,-1,111,59,79,105,-1,85,102,105,79,-1,121,138,166,156,-1,189,190,171,187,-1,182,186,174,170,-1,69,70,41,32,-1,183,160,166,181,-1,200,203,201,199,-1,200,193,196,203,-1,170,144,125,150,-1,154,175,167,142,-1,107,66,55,91,-1,88,67,68,92,-1,121,107,104,117,-1,91,88,92,94,-1,32,41,35,17,-1,185,175,162,178,-1,104,100,119,125,-1,161,150,125,136,-1,66,32,17,-1,104,83,90,100,-1,124,118,122,136,-1,119,100,90,81,89,97,118,124,-1,66,38,62,83,-1,187,171,23,16,-1,56,66,17,23,63,-1,30,38,66,56,-1,115,96,142,151,-1,122,118,97,98,-1,153,151,141,143,-1,159,147,130,157,-1,116,130,127,113,-1,155,143,113,127,-1,130,147,149,127,-1,141,122,98,108,-1,96,98,93,87,-1,87,93,80,74,-1,64,52,80,93,-1,74,49,26,43,-1,49,37,25,26,-1,25,37,33,22,-1,28,56,63,34,-1,82,72,44,57,-1,57,34,63,82,-1,24,44,28,19,-1,36,57,44,24,-1,19,9,8,24,-1,21,36,11,10,-1,11,8,0,1,-1,90,83,72,81,-1,62,38,29,46,-1,83,62,45,72,-1,20,29,38,30,-1,45,27,20,30,-1,14,7,5,15,-1,15,5,4,12,-1,142,167,148,122,-1,83,65,55,66,-1,92,68,47,60,-1,94,92,60,65,-1,191,201,203,196,-1,167,176,163,148,-1,192,191,163,176,-1,51,67,42,39,-1,182,170,150,169,-1,179,161,174,186,-1,179,169,150,161,-1,198,194,169,179,-1,132,160,183,168,-1,146,160,132,117,-1,50,51,39,40,-1,50,68,67,51,-1,132,138,121,117,-1,156,166,160,146,-1,76,69,32,66,107,-1,18,17,35,58,-1,144,156,146,125,-1,192,193,200,199,-1,154,174,161,136,-1,144,154,142,171,190,-1,162,175,154,136,-1,107,91,94,104,-1,193,185,178,196,-1,192,176,185,193,-1,199,201,191,192,-1,196,178,163,191,-1,148,163,178,162,-1,55,65,60,53,-1,53,60,47,42,-1,83,104,94,65,-1,148,162,136,122,-1,151,142,122,141,-1,45,62,46,27,-1,29,14,15,46,-1,20,13,14,29,-1,6,7,14,13,-1,5,7,6,4,-1,27,46,15,12,-1,20,27,12,13,-1,4,6,13,12,-1,30,56,72,45,-1,89,81,72,82,-1,72,56,28,44,-1,28,34,21,19,-1,57,36,21,34,-1,19,21,10,9,-1,2,9,10,3,-1,36,24,8,11,-1,8,9,2,0,-1,3,10,11,1,-1,2,3,1,0,-1,98,97,89,82,-1,54,63,96,87,-1,64,93,98,82,-1,82,63,54,64,-1,54,87,74,43,-1,54,43,52,64,-1,74,80,48,49,-1,52,43,26,31,-1,80,52,31,48,-1,37,49,48,33,-1,26,25,22,31,-1,48,31,22,33,-1,96,115,108,98,-1,115,151,153,116,-1,141,108,113,143,-1,108,115,116,113,-1,116,153,157,130,-1,153,143,155,157,-1,159,157,155,158,-1,158,149,147,159,-1,158,155,127,149,-1,18,16,23,17,-1,171,142,96,63,23,-1,125,119,124,136,-1,146,117,104,125,-1,40,39,42,47,-1,88,91,55,53,-1,42,67,88,53,-1,50,40,47,68,-1,167,175,185,176,-1,186,197,198,179,-1,168,164,138,132,-1,73,71,16,18,-1,195,182,169,194,-1,129,187,16,71,-1,85,76,107,102,-1,121,156,144,107,-1,86,58,61,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD2',point=[(-3.1842,-2.096,-0.742),(-3.114,-2.1247,-0.9556),(-3.0482,-1.9005,-0.7047),(-3.0041,-1.8866,-0.9347),(-2.9595,-2.2012,1.3093),(-2.8587,-2.2455,1.4811),(-2.837,-2.0013,1.2537),(-2.7579,-2.0023,1.459),(-2.6917,-2.4987,-0.4573),(-2.6165,-2.0229,-0.4344),(-2.5347,-2.0125,-0.8963),(-2.5271,-2.5382,-0.8779),(-2.5146,-2.5808,0.992),(-2.4597,-2.1031,0.9599),(-2.3007,-2.1099,1.3701),(-2.2827,-2.636,1.3232),(-2.0202,1.6614,-1.4713),(-1.9418,-0.7835,0.6433),(-1.9067,1.4966,1.4903),(-1.7783,-1.7269,-0.1308),(-1.7168,-1.7952,0.4978),(-1.6672,-1.7385,-0.7379),(-1.5978,-1.9809,-2.68),(-1.5902,-0.7143,-1.5905),(-1.5814,-2.328,-0.0818),(-1.5547,-1.7486,-2.5657),(-1.512,-1.8872,-2.1226),(-1.5106,-2.3889,0.4155),(-1.5096,-1.1774,-0.084),(-1.5022,-1.8173,1.035),(-1.5011,-1.2117,0.315),(-1.4987,-2.4116,-2.1418),(-1.46,-0.6302,1.6374),(-1.4135,-1.9592,-2.7763),(-1.3754,-1.1826,-0.6865),(-1.3522,0.1862,1.3517),(-1.3454,-2.3416,-0.6295),(-1.3449,-1.7682,-2.6454),(-1.2982,-1.2561,0.8553),(-1.2845,-2.0822,2.7275),(-1.2825,-2.3286,2.8245),(-1.2659,0.0238,1.4214),(-1.2106,-2.1787,2.2721),(-1.2004,-1.6941,-1.301),(-1.1919,-1.7211,-0.0071),(-1.1866,-1.7446,0.1775),(-1.1863,-2.4063,0.8431),(-1.1546,-2.704,2.2321),(-1.1391,-2.3798,-2.3526),(-1.0875,-1.9062,-2.2726),(-1.0825,-2.2718,2.9025),(-1.0601,-2.07,2.7736),(-1.0417,-2.3104,-1.0326),(-1.0325,-1.8678,1.4295),(-1.0221,-1.1492,-1.0393),(-0.9811,-1.2838,1.1718),(-0.9689,-0.9606,0.1001),(-0.9376,-1.7,-0.5462),(-0.8976,0.4551,1.3387),(-0.895,-1.0539,1.9379),(-0.8859,-2.4454,1.0678),(-0.8763,0.1329,0.8147),(-0.8744,-1.752,0.6143),(-0.8274,-0.9402,-0.5004),(-0.8108,-1.684,-0.6567),(-0.8056,-1.7657,0.6998),(-0.7834,-1.0041,0.6467),(-0.7625,-2.1531,2.3681),(-0.7608,-2.6307,2.4241),(-0.7532,-0.7208,1.567),(-0.7301,-0.1377,1.6358),(-0.6929,2.098,-0.1918),(-0.6746,-1.8072,0.0417),(-0.66,2.0502,0.6672),(-0.6412,-1.688,-1.498),(-0.6059,-1.0833,2.005),(-0.5933,-0.6707,1.3739),(-0.5914,0.7924,1.8178),(-0.5906,-0.0336,1.3678),(-0.5815,-0.92,1.5915),(-0.5766,-2.2963,-1.3259),(-0.5273,-1.4101,0.0704),(-0.5219,-1.803,-0.2692),(-0.5001,-1.8346,0.2986),(-0.4921,-0.9035,1.6993),(-0.4917,-0.6256,1.3468),(-0.4614,0.0765,1.2186),(-0.4591,-1.1178,-1.2226),(-0.4453,-1.8263,1.5639),(-0.4274,-1.4073,-0.133),(-0.4131,-1.428,0.2386),(-0.3987,-1.2529,1.3283),(-0.3711,-2.4143,1.3426),(-0.3382,-1.6729,-0.938),(-0.2979,-1.7774,0.9891),(-0.2959,-0.0589,1.3887),(-0.2585,-0.9143,-0.6655),(-0.2449,-1.3917,-0.2338),(-0.2431,-1.7791,-0.4232),(-0.2248,-0.4141,2.0301),(-0.2225,-1.4243,0.3524),(-0.2215,-0.3859,1.5417),(-0.2116,-0.9433,1.0012),(-0.2089,-0.7043,2.0596),(-0.2088,-1.8289,0.4726),(-0.2071,-1.2335,1.3668),(-0.2021,0.0857,1.2208),(-0.202,-0.9964,0.8096),(-0.1928,-1.6656,-0.9314),(-0.1902,-0.6085,1.656),(-0.165,-1.4051,1.7862),(-0.1507,-1.5972,1.5685),(-0.1503,-0.5772,1.7463),(-0.149,-2.2596,-1.3611),(-0.1125,-1.1806,1.5109),(-0.1035,-1.109,-1.2245),(-0.0775,-1.6511,-1.5293),(-0.0756,-1.7831,0.9916),(-0.0552,-1.4046,-0.1471),(-0.041,-1.4253,0.2245),(0.0219,0.8014,1.7699),(0.045,-1.2574,1.3225),(0.0468,-1.7989,-0.2907),(0.0538,-0.6942,1.3162),(0.0599,-1.4059,0.0482),(0.0685,-1.8305,0.2771),(0.0747,-0.0451,1.4286),(0.1525,-2.3502,-2.4912),(0.1626,-0.6886,1.3435),(0.1674,2.1041,-0.2244),(0.1686,-1.8785,-2.3885),(0.1695,-1.0225,1.5751),(0.1999,-2.4432,1.2857),(0.2003,2.0563,0.6345),(0.221,-0.9412,1.6988),(0.2223,-1.127,2.0044),(0.2226,-1.8008,0.0077),(0.2348,-0.1417,1.7567),(0.2542,-1.8563,1.5159),(0.2569,-0.6885,1.5906),(0.2642,0.1396,0.7679),(0.3107,-1.6822,-0.7104),(0.3215,-0.932,-0.544),(0.3601,-2.3115,-1.1595),(0.3655,-0.9959,0.6031),(0.3887,0.4745,1.2863),(0.3926,-1.7491,0.6436),(0.4215,-1.7451,-2.8036),(0.427,-1.6783,-0.5923),(0.4297,-1.9341,-2.9536),(0.4753,-1.752,0.5692),(0.4775,-1.1457,-1.112),(0.5031,-1.1278,1.9369),(0.5067,-1.6974,-1.4395),(0.5084,-0.95,0.0441),(0.5409,-2.4281,-2.3577),(0.605,-1.264,1.0968),(0.6138,-1.9092,-2.326),(0.6256,-1.9872,-2.9039),(0.6444,-1.7597,-2.7744),(0.6585,-2.4137,0.9246),(0.7326,-1.722,0.0989),(0.7439,-1.7188,-0.0886),(0.7548,-2.2989,-0.8779),(0.7714,-2.1522,2.2178),(0.7908,0.0142,1.3951),(0.8096,-1.8332,1.2798),(0.8447,-1.1536,-0.7637),(0.8483,-2.6263,2.2413),(0.885,-2.4091,0.6067),(0.9114,-1.2509,0.7747),(0.9363,-0.6962,-1.6863),(0.9843,0.2233,1.3583),(0.9907,-0.6867,1.5206),(1.0469,-1.184,0.2159),(1.0499,-1.171,-0.1817),(1.0624,-1.6895,-0.9925),(1.0657,-2.0536,2.5755),(1.0854,-2.3319,-0.3825),(1.1263,-2.3396,0.1321),(1.1539,-2.2527,2.6775),(1.1922,-2.1057,2.0404),(1.2047,-1.8197,0.791),(1.2048,-2.6314,1.9764),(1.2723,-2.0177,2.4822),(1.2807,-1.7293,-0.4164),(1.3184,-1.7433,0.2285),(1.3345,1.6972,-1.6115),(1.3383,-2.2639,2.5542),(1.448,1.5324,1.3501),(1.6585,-0.7022,0.5072),(1.8678,-2.4618,-1.3428),(1.8771,-1.936,-1.328),(2.0391,-1.9765,-0.8895),(2.0663,-2.6071,0.8417),(2.0688,-2.087,0.936),(2.1045,-2.4496,-0.9563),(2.1492,-2.0342,0.5067),(2.2306,-2.5084,0.4814),(2.3413,-1.8158,-1.3795),(2.422,-1.8386,-1.1604),(2.4464,-2.0521,-1.4275),(2.5186,-1.9664,1.0087),(2.5503,-2.0315,-1.2271),(2.5569,-1.9407,0.7936),(2.6331,-2.2035,0.9858),(2.6969,-2.1364,0.804)])))]),
    Group(DEF='_S3',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL1',diffuseColor=(0.7829,0.8211,0.8211),emissiveColor=(0.3953,0.4146,0.4146),specularColor=(0.6822,0.7154,0.7154))),
        geometry=XvlShell(faceCoordIndex=[3,1,0,2,-1,6,2,0,4,-1,5,1,3,7,-1,5,7,6,4,-1,7,3,2,6,-1,1,5,4,0,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD3',point=[(-1.4434,-0.3927,0.5697),(-1.4434,0.6178,0.6652),(-1.408,-0.4881,1.5795),(-1.408,0.5223,1.675),(-0.4291,-0.3893,0.5344),(-0.4291,0.6211,0.6299),(-0.3937,-0.4848,1.5442),(-0.3936,0.5257,1.6397)])))]),
    Group(DEF='_S4',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL2',diffuseColor=(0.7829,0.8211,0.8211),emissiveColor=(0.3953,0.4146,0.4146),specularColor=(0.6822,0.7154,0.7154))),
        geometry=XvlShell(faceCoordIndex=[3,1,0,2,-1,6,2,0,4,-1,3,7,5,1,-1,5,7,6,4,-1,7,3,2,6,-1,1,5,4,0,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD4',point=[(-0.0435,-0.3927,0.5797),(-0.0435,0.6178,0.6752),(-0.008,-0.4881,1.5895),(-0.008,0.5223,1.685),(0.9709,-0.3893,0.5444),(0.9709,0.6211,0.6399),(1.0063,-0.4848,1.5542),(1.0064,0.5257,1.6497)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for XvlShellModelOctopus.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python XvlShellModelOctopus.py load and self-test diagnostics complete.")
