####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python XvlShellModelHand.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

print('*** Lattice Xvl nodes were an experimental extensibility effort in 2002 and are not supported in ISO-standard X3D. Exiting.')
import sys
sys.exit()
####################################################################################################

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='XvlShellModelHand.x3d',name='title'),
    meta(content='Example XvlShell model.',name='description'),
    meta(content='Marc Jablonski',name='creator'),
    meta(content='24 January 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Test X3D DTD experimental extensions mechanisms, the XVL nodes are not legal X3D',name='error'),
    meta(content='readme.txt',name='reference'),
    meta(content='docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='http://www.xvl3d.com',name='reference'),
    meta(content='Lattice XVL parametric geometry X3D VRML',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/XvlShellModelHand.x3d',name='identifier'),
    meta(content='Xvl3ToX3d, http://www.lattice3d.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='XvlShellModelHand.x3d'),
    Group(DEF='_S1',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL',diffuseColor=(0.9882,0.8549,0.6549),shininess=0.07,specularColor=(0.12,0.12,0.12))),
        geometry=XvlShell(edgeBeginCoordIndex=[19,19,21,29,65,111,155,214],edgeBeginVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeEndCoordIndex=[21,39,29,39,78,125,174,217],edgeEndVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeRound=[0,0,0,0,0,0,0,0],faceCoordIndex=[214,213,218,217,-1,218,213,202,208,-1,175,173,176,186,187,-1,123,129,121,125,-1,172,187,164,165,-1,186,176,170,-1,109,111,114,101,-1,176,153,159,170,-1,89,76,78,83,-1,211,201,195,192,205,-1,130,128,100,102,-1,71,66,57,-1,188,182,143,138,-1,59,89,88,58,-1,86,74,79,-1,64,57,59,58,56,63,-1,80,63,70,74,-1,63,56,70,-1,171,191,142,117,-1,105,108,107,98,106,104,-1,91,92,106,98,-1,192,171,117,149,-1,47,27,32,-1,117,142,97,94,-1,7,46,32,13,-1,205,180,190,200,-1,96,48,55,85,-1,54,55,48,50,-1,44,50,48,35,-1,6,51,46,7,-1,3,4,43,35,-1,97,49,45,94,-1,13,8,4,3,7,-1,205,192,181,180,-1,2,49,51,6,-1,95,42,48,96,-1,45,49,2,0,-1,93,94,45,52,-1,45,0,10,52,-1,141,190,180,9,1,42,95,-1,163,181,93,52,10,26,-1,9,180,162,25,-1,48,42,1,5,-1,5,6,7,3,-1,53,54,50,51,-1,22,28,34,16,-1,62,70,56,-1,17,19,21,12,-1,203,213,214,204,-1,154,148,147,153,156,-1,127,129,123,124,126,-1,207,212,203,204,-1,202,213,203,197,196,-1,153,147,159,-1,196,197,194,-1,199,196,194,198,-1,218,208,199,201,211,-1,118,127,126,-1,147,152,159,-1,197,193,194,-1,124,110,103,126,-1,82,83,61,60,-1,184,169,177,-1,198,194,193,195,-1,110,109,101,99,103,-1,129,135,108,101,-1,89,83,82,77,87,-1,150,177,169,158,-1,158,145,150,-1,183,185,184,177,182,-1,132,119,131,-1,193,171,192,195,-1,182,177,150,143,-1,130,102,116,119,-1,60,61,59,57,66,-1,104,131,119,116,-1,104,116,105,-1,89,87,81,80,86,88,-1,115,103,99,-1,154,175,174,155,-1,123,125,111,109,-1,124,123,109,110,-1,186,170,179,-1,154,155,157,148,-1,178,169,184,-1,83,78,65,61,-1,178,184,185,187,186,179,-1,115,118,126,103,-1,75,87,77,-1,203,200,171,193,197,-1,82,60,66,77,-1,75,77,66,71,-1,102,105,116,-1,29,39,37,41,-1,183,144,146,185,-1,138,143,140,137,-1,29,41,12,21,-1,41,37,38,34,40,-1,136,137,139,134,-1,79,74,70,62,-1,17,12,11,16,18,-1,16,11,22,-1,36,15,14,33,-1,192,149,181,-1,33,14,20,27,-1,46,51,50,44,-1,20,8,13,-1,47,32,46,44,35,43,-1,51,49,97,92,-1,139,141,95,96,-1,181,149,93,-1,149,117,94,93,-1,35,48,5,3,-1,6,5,1,2,-1,162,180,181,163,-1,2,1,9,10,0,-1,162,163,26,25,-1,10,9,25,26,-1,13,32,27,20,-1,51,92,84,53,-1,14,8,20,-1,11,12,4,8,14,15,-1,56,58,55,54,53,62,-1,91,98,107,96,-1,22,11,15,-1,88,86,79,84,90,85,-1,38,18,16,34,-1,36,40,28,-1,144,139,137,140,-1,64,71,57,-1,115,99,100,-1,211,209,217,218,-1,174,175,187,172,-1,173,156,153,176,-1,165,164,148,157,-1,212,207,209,211,-1,201,199,198,-1,170,159,152,179,-1,201,198,195,-1,178,151,158,169,-1,164,187,185,146,148,-1,128,118,115,100,-1,148,146,145,151,152,147,-1,101,108,105,102,100,99,-1,81,75,71,64,-1,136,133,138,137,-1,145,146,144,140,143,150,-1,191,188,138,142,-1,200,190,191,171,-1,133,131,104,106,-1,183,189,139,144,-1,108,135,134,107,-1,40,34,28,-1,68,76,89,59,-1,156,173,175,154,-1,199,208,202,196,-1,127,118,128,-1,178,179,152,151,-1,61,65,68,59,-1,158,151,145,-1,127,128,130,132,135,129,-1,130,119,132,-1,212,211,205,200,203,-1,81,87,75,-1,183,182,188,189,-1,37,39,19,17,-1,86,80,74,-1,134,135,132,131,133,136,-1,38,37,17,18,-1,81,64,63,80,-1,189,188,191,190,-1,138,133,106,92,-1,84,92,91,90,-1,36,28,22,15,-1,36,33,47,43,41,40,-1,139,189,190,141,-1,97,142,138,92,-1,85,90,91,96,-1,134,139,96,107,-1,88,85,55,58,-1,53,84,79,62,-1,33,27,47,-1,12,41,43,4,-1,121,129,101,114,-1,112,114,111,113,-1,167,161,155,174,-1,219,216,214,217,-1,167,174,172,168,-1,167,168,166,160,161,-1,166,168,172,165,-1,113,120,122,112,-1,166,165,157,160,-1,122,121,114,112,-1,214,216,206,204,-1,204,206,210,207,-1,219,217,209,215,-1,72,73,67,69,-1,29,31,30,39,-1,30,31,23,24,-1,21,23,31,29,-1,68,67,73,76,-1,210,215,209,207,-1,78,76,73,72,-1,78,72,69,65,-1,69,67,68,65,-1,120,125,121,122,-1,155,161,160,157,-1,113,111,125,120,-1,216,219,215,210,206,-1,39,30,24,19,-1,24,23,21,19,-1],faceHidden=[False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD0',point=[(-1.0639,-0.5021,0.4135),(-1.0073,0.1888,-0.2479),(-1.0032,0.072,0.4709),(-0.9966,0.5685,-0.0164),(-0.9906,0.9723,0.361),(-0.9854,0.3847,-0.1321),(-0.9836,0.2625,0.4114),(-0.9713,0.4026,0.5932),(-0.971,0.7513,0.5309),(-0.967,-1.2868,-0.3676),(-0.967,-1.2868,0.3807),(-0.9163,0.8673,0.9102),(-0.9158,1.0775,1.0458),(-0.9083,0.5126,0.5884),(-0.9071,0.5739,0.6509),(-0.8998,0.6366,0.8439),(-0.888,0.6785,0.9377),(-0.8643,0.833,1.4185),(-0.8639,0.6726,1.3336),(-0.8635,0.8642,1.454),(-0.8464,0.6496,0.5323),(-0.8417,1.0265,1.1132),(-0.8322,0.7461,0.8924),(-0.8308,1.0471,1.352),(-0.8017,0.8769,1.5073),(-0.7497,-1.7574,-0.4012),(-0.7497,-1.7574,0.4143),(-0.6363,0.6554,0.5224),(-0.6221,0.7519,0.8825),(-0.6075,1.033,1.1023),(-0.6022,0.8824,1.498),(-0.5971,1.0536,1.341),(-0.562,0.5221,0.5722),(-0.5608,0.5834,0.6347),(-0.5587,0.6876,0.9223),(-0.5547,0.6816,0.0269),(-0.5535,0.6462,0.8277),(-0.5458,0.8417,1.4036),(-0.5454,0.6813,1.3187),(-0.545,0.873,1.4391),(-0.5435,0.8775,0.8927),(-0.5429,1.0878,1.0284),(-0.5383,0.2161,-0.3056),(-0.5379,0.9847,0.3398),(-0.5365,0.5789,0.296),(-0.5319,-0.5021,0.7935),(-0.5183,0.3977,0.5397),(-0.5182,0.7638,0.5097),(-0.518,0.4267,-0.1751),(-0.5166,0.0967,0.5512),(-0.5044,0.4892,0.2071),(-0.4863,0.2887,0.39),(-0.4855,-1.2868,0.3807),(-0.4656,0.6916,0.1987),(-0.4656,0.8693,0.0154),(-0.4656,1.0471,-0.1679),(-0.4656,1.1629,0.3708),(-0.4656,1.2966,0.836),(-0.4656,1.4661,0.2895),(-0.4656,1.6033,0.9029),(-0.4342,1.3221,1.4542),(-0.4342,1.5074,1.3864),(-0.4244,0.8877,0.361),(-0.4244,1.0045,0.5163),(-0.4244,1.0743,0.7232),(-0.4238,1.5061,1.3477),(-0.416,1.157,0.9553),(-0.3964,1.6523,1.1562),(-0.3866,1.5791,1.0481),(-0.3778,1.5634,1.3977),(-0.3656,1.0443,0.3887),(-0.3656,1.1831,0.799),(-0.1604,1.5634,1.3977),(-0.1419,1.6523,1.1562),(-0.1344,1.0443,0.3887),(-0.1344,1.1831,0.799),(-0.1328,1.5791,1.0481),(-0.084,1.157,0.9553),(-0.0768,1.5061,1.3477),(-0.0756,0.8877,0.361),(-0.0756,1.0045,0.5163),(-0.0756,1.0743,0.7232),(-0.0658,1.3221,1.4542),(-0.0658,1.5074,1.3864),(-0.0344,0.6916,0.1987),(-0.0344,1.0471,-0.1679),(-0.0344,1.1629,0.3708),(-0.0344,1.2966,0.836),(-0.0344,1.4661,0.2895),(-0.0344,1.6033,0.9029),(-0.0147,0.8724,0.0171),(-0.0067,0.7646,0.0758),(-0.0058,0.4862,0.4175),(-0.0042,-1.2868,0.3807),(0,-0.5021,0.4135),(0,0.2579,-0.4135),(0,0.7161,-0.2999),(0.0012,0.0408,0.3282),(0.0143,0.8746,0.0289),(0.0238,1.4904,0.8274),(0.0245,1.2237,0.664),(0.0255,1.7967,0.8959),(0.027,1.1663,0.5136),(0.029,1.3065,0.9832),(0.0314,1.0129,0.3531),(0.0332,1.3148,0.2953),(0.0339,0.749,0.263),(0.0344,0.9951,-0.2065),(0.0383,1.6146,0.2026),(0.0434,1.6355,1.454),(0.0446,1.4441,1.3011),(0.0458,1.769,1.39),(0.1036,1.8399,1.1413),(0.116,1.8099,1.4647),(0.1163,1.7627,1.0242),(0.1487,1.3758,0.7917),(0.1568,1.1915,0.3157),(0.1861,-0.0867,0.5928),(0.3292,1.3739,0.7955),(0.3372,1.1897,0.3196),(0.3467,1.81,1.47),(0.3635,1.7629,1.0299),(0.3737,1.8401,1.1475),(0.4117,1.6316,1.4618),(0.4129,1.4402,1.3089),(0.4141,1.7692,1.3984),(0.4392,1.3022,0.9919),(0.4549,1.4859,0.8365),(0.4556,1.2192,0.6731),(0.4566,1.7922,0.905),(0.4581,1.1618,0.5227),(0.4625,1.0099,0.3592),(0.4643,1.3103,0.3044),(0.4651,0.749,0.263),(0.4656,0.9951,-0.2065),(0.4694,1.6101,0.2117),(0.4738,0.8592,0.0346),(0.4991,0.7775,0.0834),(0.5,0.5434,0.4028),(0.5,0.7161,-0.2999),(0.5257,0.8667,0.0133),(0.5319,0.2579,-0.4135),(0.5319,0.2579,0.4135),(0.5344,0.8168,0.2262),(0.5344,0.9474,-0.2262),(0.5344,1.3233,0.2067),(0.5344,1.4798,-0.0654),(0.5344,1.746,0.4382),(0.5344,2.0153,0.277),(0.5357,-0.7547,0.8425),(0.5553,1.1023,0.3039),(0.5553,1.3672,0.4014),(0.5553,1.4892,0.4601),(0.5647,1.7067,0.6559),(0.5747,2.2072,0.8614),(0.5823,2.2955,0.6984),(0.5836,1.9194,0.8742),(0.5904,2.0801,0.3833),(0.6189,1.2731,0.2677),(0.6189,1.6632,0.4579),(0.627,2.2102,0.4293),(0.6449,2.3735,0.7793),(0.7413,-1.7574,-0.4012),(0.7413,-1.7574,0.4143),(0.75,2.0555,0.2325),(0.75,2.1179,0.3367),(0.75,2.2102,0.4293),(0.8551,2.3735,0.7793),(0.873,2.2102,0.4293),(0.8811,1.2731,0.2677),(0.8811,1.6632,0.4579),(0.9035,0.1558,0.7779),(0.9096,2.0801,0.3833),(0.9164,1.9194,0.8742),(0.9177,2.2955,0.6984),(0.9253,2.2072,0.8614),(0.9353,1.7067,0.6559),(0.9447,1.1023,0.3039),(0.9447,1.3672,0.4014),(0.9447,1.4892,0.4601),(0.9585,-1.2868,-0.3676),(0.9585,-1.2868,0.3807),(0.9656,0.8168,0.2262),(0.9656,0.9474,-0.2262),(0.9656,1.3233,0.2067),(0.9656,1.4798,-0.0654),(0.9656,1.746,0.4382),(0.9656,2.0153,0.277),(1,0.5434,0.4028),(1,0.7161,-0.2999),(1.0639,0.2579,-0.4135),(1.0639,0.2579,0.4135),(1.0888,-0.2968,0.9382),(1.1042,0.2448,1.0582),(1.2302,0.3046,1.1685),(1.2309,-0.0648,1.1679),(1.2338,0.3706,1.3535),(1.2792,0.4091,1.0483),(1.3373,0.0428,1.2612),(1.3403,0.1103,1.4457),(1.3712,0.2213,0.4222),(1.458,-0.0459,1.209),(1.4702,0.5912,1.5095),(1.4912,0.4059,0.837),(1.4926,0.3947,0.9527),(1.5565,-0.2313,0.5826),(1.5902,0.4052,0.972),(1.6098,0.2425,0.9702),(1.6201,0.2249,1.6393),(1.6284,0.0719,1.0537),(1.642,0.282,1.0106),(1.6436,-0.0147,0.9862),(1.6553,0.2217,0.8927),(1.6639,0.6263,1.3225),(1.6669,0.5871,1.26),(1.6938,0.1588,1.0491),(1.7731,0.5613,1.3205),(1.7961,0.2803,1.356),(1.8059,0.2572,1.4527),(1.857,0.362,1.3829)]))),
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_tume',diffuseColor=(0.8863,0.7412,0.7216),shininess=0.56,specularColor=(0.38,0.38,0.38))),
        geometry=XvlShell(edgeBeginCoordIndex=[19,19,21,29,65,111,155,214],edgeBeginVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeEndCoordIndex=[21,39,29,39,78,125,174,217],edgeEndVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeRound=[0,0,0,0,0,0,0,0],faceCoordIndex=[214,213,218,217,-1,218,213,202,208,-1,175,173,176,186,187,-1,123,129,121,125,-1,172,187,164,165,-1,186,176,170,-1,109,111,114,101,-1,176,153,159,170,-1,89,76,78,83,-1,211,201,195,192,205,-1,130,128,100,102,-1,71,66,57,-1,188,182,143,138,-1,59,89,88,58,-1,86,74,79,-1,64,57,59,58,56,63,-1,80,63,70,74,-1,63,56,70,-1,171,191,142,117,-1,105,108,107,98,106,104,-1,91,92,106,98,-1,192,171,117,149,-1,47,27,32,-1,117,142,97,94,-1,7,46,32,13,-1,205,180,190,200,-1,96,48,55,85,-1,54,55,48,50,-1,44,50,48,35,-1,6,51,46,7,-1,3,4,43,35,-1,97,49,45,94,-1,13,8,4,3,7,-1,205,192,181,180,-1,2,49,51,6,-1,95,42,48,96,-1,45,49,2,0,-1,93,94,45,52,-1,45,0,10,52,-1,141,190,180,9,1,42,95,-1,163,181,93,52,10,26,-1,9,180,162,25,-1,48,42,1,5,-1,5,6,7,3,-1,53,54,50,51,-1,22,28,34,16,-1,62,70,56,-1,17,19,21,12,-1,203,213,214,204,-1,154,148,147,153,156,-1,127,129,123,124,126,-1,207,212,203,204,-1,202,213,203,197,196,-1,153,147,159,-1,196,197,194,-1,199,196,194,198,-1,218,208,199,201,211,-1,118,127,126,-1,147,152,159,-1,197,193,194,-1,124,110,103,126,-1,82,83,61,60,-1,184,169,177,-1,198,194,193,195,-1,110,109,101,99,103,-1,129,135,108,101,-1,89,83,82,77,87,-1,150,177,169,158,-1,158,145,150,-1,183,185,184,177,182,-1,132,119,131,-1,193,171,192,195,-1,182,177,150,143,-1,130,102,116,119,-1,60,61,59,57,66,-1,104,131,119,116,-1,104,116,105,-1,89,87,81,80,86,88,-1,115,103,99,-1,154,175,174,155,-1,123,125,111,109,-1,124,123,109,110,-1,186,170,179,-1,154,155,157,148,-1,178,169,184,-1,83,78,65,61,-1,178,184,185,187,186,179,-1,115,118,126,103,-1,75,87,77,-1,203,200,171,193,197,-1,82,60,66,77,-1,75,77,66,71,-1,102,105,116,-1,29,39,37,41,-1,183,144,146,185,-1,138,143,140,137,-1,29,41,12,21,-1,41,37,38,34,40,-1,136,137,139,134,-1,79,74,70,62,-1,17,12,11,16,18,-1,16,11,22,-1,36,15,14,33,-1,192,149,181,-1,33,14,20,27,-1,46,51,50,44,-1,20,8,13,-1,47,32,46,44,35,43,-1,51,49,97,92,-1,139,141,95,96,-1,181,149,93,-1,149,117,94,93,-1,35,48,5,3,-1,6,5,1,2,-1,162,180,181,163,-1,2,1,9,10,0,-1,162,163,26,25,-1,10,9,25,26,-1,13,32,27,20,-1,51,92,84,53,-1,14,8,20,-1,11,12,4,8,14,15,-1,56,58,55,54,53,62,-1,91,98,107,96,-1,22,11,15,-1,88,86,79,84,90,85,-1,38,18,16,34,-1,36,40,28,-1,144,139,137,140,-1,64,71,57,-1,115,99,100,-1,211,209,217,218,-1,174,175,187,172,-1,173,156,153,176,-1,165,164,148,157,-1,212,207,209,211,-1,201,199,198,-1,170,159,152,179,-1,201,198,195,-1,178,151,158,169,-1,164,187,185,146,148,-1,128,118,115,100,-1,148,146,145,151,152,147,-1,101,108,105,102,100,99,-1,81,75,71,64,-1,136,133,138,137,-1,145,146,144,140,143,150,-1,191,188,138,142,-1,200,190,191,171,-1,133,131,104,106,-1,183,189,139,144,-1,108,135,134,107,-1,40,34,28,-1,68,76,89,59,-1,156,173,175,154,-1,199,208,202,196,-1,127,118,128,-1,178,179,152,151,-1,61,65,68,59,-1,158,151,145,-1,127,128,130,132,135,129,-1,130,119,132,-1,212,211,205,200,203,-1,81,87,75,-1,183,182,188,189,-1,37,39,19,17,-1,86,80,74,-1,134,135,132,131,133,136,-1,38,37,17,18,-1,81,64,63,80,-1,189,188,191,190,-1,138,133,106,92,-1,84,92,91,90,-1,36,28,22,15,-1,36,33,47,43,41,40,-1,139,189,190,141,-1,97,142,138,92,-1,85,90,91,96,-1,134,139,96,107,-1,88,85,55,58,-1,53,84,79,62,-1,33,27,47,-1,12,41,43,4,-1,121,129,101,114,-1,112,114,111,113,-1,167,161,155,174,-1,219,216,214,217,-1,167,174,172,168,-1,167,168,166,160,161,-1,166,168,172,165,-1,113,120,122,112,-1,166,165,157,160,-1,122,121,114,112,-1,214,216,206,204,-1,204,206,210,207,-1,219,217,209,215,-1,72,73,67,69,-1,29,31,30,39,-1,30,31,23,24,-1,21,23,31,29,-1,68,67,73,76,-1,210,215,209,207,-1,78,76,73,72,-1,78,72,69,65,-1,69,67,68,65,-1,120,125,121,122,-1,155,161,160,157,-1,113,111,125,120,-1,216,219,215,210,206,-1,39,30,24,19,-1,24,23,21,19,-1],faceHidden=[True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False],shellType='LATTICE_MESH',
          coord=Coordinate(USE='COORD0')))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for XvlShellModelHand.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python XvlShellModelHand.py load and self-test diagnostics complete.")
