####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python XvlShellModelDolphin.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

print('*** Lattice Xvl nodes were an experimental extensibility effort in 2002 and are not supported in ISO-standard X3D. Exiting.')
import sys
sys.exit()
####################################################################################################

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='XvlShellModelDolphin.x3d',name='title'),
    meta(content='Example XvlShell model.',name='description'),
    meta(content='Marc Jablonski',name='creator'),
    meta(content='24 January 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Test X3D DTD experimental extensions mechanisms, the XVL nodes are not legal X3D',name='error'),
    meta(content='readme.txt',name='reference'),
    meta(content='docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='http://www.xvl3d.com',name='reference'),
    meta(content='Lattice XVL parametric geometry X3D VRML',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/XvlShellModelDolphin.x3d',name='identifier'),
    meta(content='Xvl3ToX3d, http://www.lattice3d.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='XvlShellModelDolphin.x3d'),
    Group(DEF='_S1',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL0',ambientIntensity=0,diffuseColor=(0.215686,0.337255,0.74902),shininess=0.37,specularColor=(0.52,0.52,0.52))),
        geometry=XvlShell(faceCoordIndex=[183,193,192,184,-1,184,192,186,176,-1,169,177,178,167,-1,160,159,167,-1,122,109,84,75,70,126,-1,122,126,145,138,135,-1,124,126,70,73,-1,150,138,145,154,-1,115,80,81,112,-1,124,125,143,140,-1,77,80,115,117,-1,120,146,156,127,-1,152,140,143,153,-1,75,84,81,62,-1,152,170,154,-1,120,127,67,72,-1,80,63,62,81,-1,157,144,150,177,169,-1,159,157,169,-1,169,167,159,-1,154,170,179,177,150,-1,57,62,63,-1,165,160,167,178,-1,137,121,98,97,-1,70,75,62,57,56,-1,63,61,48,51,-1,47,57,63,51,-1,60,74,69,54,-1,147,137,97,89,-1,156,165,178,180,164,-1,177,179,182,180,178,-1,54,58,46,44,-1,67,127,128,68,-1,48,50,42,31,-1,45,29,46,-1,29,44,46,-1,38,33,39,-1,28,38,39,-1,164,174,130,128,-1,45,47,22,21,29,-1,23,22,28,30,-1,31,42,37,19,23,-1,130,174,173,132,-1,162,158,166,172,-1,132,66,65,130,-1,175,142,141,176,-1,141,166,184,176,-1,191,193,183,175,-1,175,176,186,191,-1,192,193,191,186,-1,174,188,187,173,-1,132,119,79,66,-1,35,40,53,94,-1,19,37,27,11,16,-1,94,92,141,142,-1,95,103,102,96,-1,65,66,26,27,-1,90,83,95,96,-1,96,102,105,90,-1,35,16,11,25,-1,79,83,90,87,-1,105,104,87,90,-1,132,173,163,110,-1,79,87,85,66,-1,87,104,110,85,-1,187,171,161,181,-1,25,11,10,24,-1,26,36,15,10,-1,110,163,148,114,-1,163,181,168,148,-1,36,85,99,59,-1,15,36,59,43,-1,161,93,106,151,-1,15,43,55,34,-1,148,168,139,131,-1,198,194,190,197,-1,196,198,197,195,-1,197,190,185,195,-1,196,195,185,189,-1,106,55,71,107,-1,111,131,118,113,-1,131,139,129,118,-1,78,64,76,86,-1,78,14,8,64,-1,18,82,71,13,-1,18,14,78,82,-1,0,1,13,8,-1,8,14,2,0,-1,3,1,0,2,-1,53,40,12,20,-1,17,20,5,7,-1,7,5,4,6,-1,92,52,32,25,-1,115,112,135,134,-1,135,138,134,-1,109,122,135,112,-1,117,136,146,120,-1,149,146,136,-1,117,115,134,136,-1,69,125,124,73,-1,121,125,69,74,98,-1,84,109,112,81,-1,149,136,134,144,-1,150,144,134,138,-1,145,126,124,140,-1,117,120,72,77,-1,154,145,140,152,-1,149,165,156,146,-1,143,125,121,137,-1,152,153,170,-1,157,160,165,149,144,-1,160,157,159,-1,77,61,63,80,-1,143,137,147,153,-1,77,72,50,61,-1,50,48,61,-1,56,58,73,70,-1,69,73,58,54,-1,98,74,60,97,-1,147,155,179,170,153,-1,72,67,42,50,-1,127,156,164,128,-1,45,56,57,47,-1,45,46,58,56,-1,97,60,49,89,-1,60,54,44,49,-1,51,48,31,33,38,-1,147,89,88,155,-1,39,33,30,-1,179,155,162,182,-1,39,30,28,-1,37,42,67,68,-1,47,51,38,28,22,-1,30,33,31,23,-1,164,180,182,188,174,-1,89,49,41,88,-1,21,41,49,44,29,-1,128,130,65,68,-1,88,94,162,155,-1,162,172,188,182,-1,142,158,162,94,-1,16,21,22,23,19,-1,68,65,27,37,-1,183,158,142,175,-1,21,16,35,41,-1,41,35,94,88,-1,119,116,83,79,-1,95,83,116,103,-1,103,116,105,102,-1,172,171,187,188,-1,94,53,52,92,-1,35,25,32,40,-1,52,53,20,17,-1,12,40,32,9,-1,32,52,17,9,-1,20,12,4,5,-1,9,6,4,12,-1,17,7,6,9,-1,119,104,105,116,-1,163,173,187,181,-1,132,110,104,119,-1,92,91,171,172,-1,27,26,10,11,-1,36,26,66,85,-1,92,25,24,91,-1,171,91,93,161,-1,110,114,99,85,-1,24,10,15,34,-1,91,24,34,93,-1,181,161,151,168,-1,34,55,106,93,-1,114,148,131,111,-1,99,114,111,101,-1,139,168,151,133,-1,190,194,139,133,-1,59,99,101,76,-1,189,194,198,196,-1,59,76,64,43,-1,151,106,107,133,-1,55,43,64,71,-1,139,194,189,129,-1,185,190,133,123,-1,101,111,113,100,-1,86,76,101,100,-1,189,185,123,129,-1,133,107,108,123,-1,107,71,82,108,-1,113,118,129,123,108,82,78,86,100,-1,71,64,8,13,-1,13,1,3,18,-1,3,2,14,18,-1,172,166,141,92,-1,183,184,166,158,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD0',point=[(-1.3985,-0.1221,-5.0371),(-1.3799,-0.1754,-5.0371),(-1.3676,-0.1187,-5.2383),(-1.3569,-0.149,-5.2383),(-1.0261,-1.6339,1.1046),(-0.9782,-1.6715,1.1052),(-0.9435,-1.5376,0.8884),(-0.8941,-1.5702,0.8857),(-0.8754,0.0827,-4.3193),(-0.8654,-1.2336,1.0619),(-0.8648,0.0029,-0.3159),(-0.8648,0.0029,0.9802),(-0.8464,-1.1795,1.6838),(-0.7921,-0.1551,-4.3193),(-0.7874,0.0805,-5.0255),(-0.7818,0.0121,-1.3204),(-0.7818,0.0121,1.9846),(-0.74,-1.3103,1.0496),(-0.74,-0.0549,-5.0255),(-0.7394,0.1947,1.9891),(-0.7197,-1.2629,1.6849),(-0.7017,-0.0191,2.83),(-0.6824,0.071,2.8367),(-0.6795,0.1816,2.5447),(-0.638,-0.6452,-0.3159),(-0.638,-0.6452,0.9802),(-0.638,0.6509,-0.3159),(-0.638,0.6509,0.9802),(-0.6199,0.1206,2.8527),(-0.6193,-0.0272,3.1263),(-0.6002,0.1754,2.7696),(-0.5979,0.339,2.8385),(-0.5941,-0.7109,1.1032),(-0.5776,0.2546,2.8536),(-0.5765,-0.5744,-1.3204),(-0.5765,-0.5744,1.9846),(-0.5765,0.5986,-1.3204),(-0.5765,0.5986,1.9846),(-0.5718,0.1827,2.9404),(-0.5627,0.1837,2.8556),(-0.5473,-0.6571,1.8667),(-0.5426,-0.5054,2.8336),(-0.5326,0.5169,2.8336),(-0.5101,0.0531,-2.7185),(-0.5061,-0.1157,3.443),(-0.4953,-0.0056,3.4396),(-0.4608,-0.0675,3.3951),(-0.4577,0.1738,3.4286),(-0.4227,0.3086,3.3897),(-0.4054,-0.4514,3.4376),(-0.3859,0.4478,3.3302),(-0.3777,0.2082,3.3918),(-0.3752,-0.8409,1.1349),(-0.3752,-0.7735,1.8685),(-0.3662,-0.1431,3.7161),(-0.3639,-0.3647,-2.7185),(-0.3396,-0.0476,3.7161),(-0.3205,0.2111,3.6086),(-0.3088,-0.1043,3.676),(-0.3076,0.4191,-2.7035),(-0.2914,-0.4017,3.7161),(-0.2886,0.308,3.5515),(-0.2648,0.2359,3.6811),(-0.249,0.2448,3.5653),(-0.2397,0.1007,-4.0087),(-0.206,0.8777,0.9802),(-0.1998,0.9898,-0.0584),(-0.1952,0.7864,2.8444),(-0.1855,0.8039,1.9846),(-0.1667,-0.0998,4.3793),(-0.1572,-0.0391,4.3318),(-0.1565,-0.1371,-4.0087),(-0.1413,0.6234,3.4457),(-0.1365,-0.0768,4.2524),(-0.1312,-0.2175,4.3793),(-0.1312,0.0786,4.3318),(-0.1218,0.2659,-4.0504),(-0.101,0.3449,3.7098),(-0.1003,0.1173,-4.9216),(-0.0952,1.0858,-0.2545),(-0.0809,0.2926,3.7161),(-0.0617,0.2716,3.784),(-0.0529,-0.0181,-4.9216),(-0.047,1.7539,-1.0567),(-0.0325,0.1305,4.3318),(-0.0264,0.8781,-1.5779),(-0.0152,0.1832,-4.8132),(-0.0097,1.0018,-1.398),(0.0035,-0.6517,2.8214),(0.0037,-0.5,3.4393),(0.008,1.3386,-1.3326),(0.01,-0.872,-0.3159),(0.01,-0.872,0.9802),(0.01,-0.7797,-1.3204),(0.01,-0.7797,1.9846),(0.0117,1.7886,-1.4927),(0.014,1.7271,-1.5335),(0.0168,-0.4467,3.6994),(0.0168,-0.2693,4.3793),(0.019,0.6172,-2.7185),(0.0325,0.2023,-4.8133),(0.039,0.3759,-4.0602),(0.0478,1.7271,-1.5335),(0.0501,1.7886,-1.4927),(0.0526,1.0018,-1.398),(0.0538,1.3386,-1.3326),(0.0539,-0.511,-2.7185),(0.0566,-0.1937,-4.0602),(0.0566,-0.0135,-4.8235),(0.0662,0.1305,4.3318),(0.0692,0.8781,-1.5779),(0.0743,0.3759,-4.0602),(0.0804,0.2716,3.784),(0.0808,0.2023,-4.8133),(0.0889,0.6172,-2.7185),(0.1046,0.2926,3.7161),(0.1088,1.7539,-1.0567),(0.126,0.3459,3.7094),(0.1285,0.1832,-4.8132),(0.138,1.0858,-0.2545),(0.1489,0.6232,3.446),(0.1649,-0.2175,4.3793),(0.1649,0.0786,4.3318),(0.1662,-0.0181,-4.9216),(0.1762,-0.066,4.2541),(0.1813,-0.0998,4.3793),(0.1908,-0.0391,4.3318),(0.2023,0.7864,2.8445),(0.2055,0.8039,1.9846),(0.2136,0.1173,-4.9216),(0.226,0.8777,0.9802),(0.2351,0.2659,-4.0505),(0.2427,0.9898,-0.0584),(0.2698,-0.1371,-4.0087),(0.2807,0.2471,3.5688),(0.2969,0.2375,3.6814),(0.3183,0.3063,3.5548),(0.325,-0.4017,3.7161),(0.3499,0.2111,3.6086),(0.353,0.1007,-4.0087),(0.3546,-0.086,3.6837),(0.3572,-0.8409,1.1349),(0.3572,-0.7735,1.8685),(0.3581,-0.1431,3.7161),(0.383,0.2095,3.3984),(0.3847,-0.0476,3.7161),(0.3926,0.4454,3.3324),(0.412,-0.452,3.44),(0.4151,0.419,-2.7054),(0.4398,0.3079,3.3918),(0.4664,0.1732,3.431),(0.4718,-0.3647,-2.7185),(0.4959,-0.0562,3.4064),(0.4973,-0.1155,3.445),(0.5054,-0.0058,3.4413),(0.5297,-0.5054,2.8336),(0.5397,0.5169,2.8336),(0.5568,0.1837,2.9088),(0.5635,-0.6571,1.8667),(0.571,0.1774,2.8111),(0.5919,0.2594,2.8264),(0.5965,-0.5744,-1.3204),(0.5965,-0.5744,1.9846),(0.5965,0.5986,-1.3204),(0.5965,0.5986,1.9846),(0.6099,0.3391,2.8385),(0.6103,-0.7109,1.1032),(0.6172,0.1895,2.7476),(0.618,0.0531,-2.7185),(0.6342,0.1255,2.8255),(0.6348,-0.0258,3.1268),(0.6581,-0.6452,-0.3159),(0.6581,-0.6452,0.9802),(0.6581,0.6509,-0.3159),(0.6581,0.6509,0.9802),(0.6703,-1.2842,1.6855),(0.693,-1.3316,1.0502),(0.6945,0.0713,2.8366),(0.699,0.1908,2.5499),(0.7088,-0.0187,2.8298),(0.7697,0.1942,1.9897),(0.8018,0.0121,-1.3204),(0.8018,0.0121,1.9846),(0.8217,-1.2008,1.6844),(0.8385,-1.2549,1.0625),(0.8533,-0.0549,-5.0255),(0.8748,-1.6537,0.8973),(0.8849,0.0029,-0.3159),(0.8849,0.0029,0.9802),(0.9007,0.0805,-5.0255),(0.9054,-0.1551,-4.3193),(0.925,-1.7747,1.1172),(0.9366,-1.6303,0.9021),(0.9882,-1.7461,1.1184),(0.9887,0.0827,-4.3193),(1.5579,-0.149,-5.2383),(1.5685,-0.1187,-5.2383),(1.5808,-0.1754,-5.0371),(1.5995,-0.1221,-5.0371)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for XvlShellModelDolphin.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python XvlShellModelDolphin.py load and self-test diagnostics complete.")
