####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python XvlShellModelBaby.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

print('*** Lattice Xvl nodes were an experimental extensibility effort in 2002 and are not supported in ISO-standard X3D. Exiting.')
import sys
sys.exit()
####################################################################################################

newModel=X3D(profile='Immersive',version='3.0',
  head=head(
    children=[
    meta(content='XvlShellModelBaby.x3d',name='title'),
    meta(content='Example XvlShell model.',name='description'),
    meta(content='Marc Jablonski',name='creator'),
    meta(content='24 January 2002',name='created'),
    meta(content='20 October 2019',name='modified'),
    meta(content='Test X3D DTD experimental extensions mechanisms, the XVL nodes are not legal X3D',name='error'),
    meta(content='readme.txt',name='reference'),
    meta(content='docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/docs/LatticeXvl/LatticeXvlOverview.html',name='reference'),
    meta(content='http://www.xvl3d.com',name='reference'),
    meta(content='Lattice XVL parametric geometry X3D VRML',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/LatticeXvl/XvlShellModelBaby.x3d',name='identifier'),
    meta(content='Xvl3ToX3d, http://www.lattice3d.com',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='XvlShellModelBaby.x3d'),
    Group(DEF='_S4',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_eye_black',diffuseColor=(0,0,0),shininess=0.35,specularColor=(0.99,0.99,0.99))),
        geometry=XvlShell(edgeBeginCoordIndex=[4,4,5,7],edgeBeginVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeEndCoordIndex=[7,5,8,8],edgeEndVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeRound=[0,0,0,0],faceCoordIndex=[5,6,8,-1,7,6,4,-1,8,6,7,-1,6,5,4,-1,9,0,2,11,-1,10,1,0,9,-1,12,3,5,8,-1,11,12,10,9,-1,3,2,0,1,-1,7,4,1,10,-1,12,8,7,10,-1,11,2,3,12,-1,5,3,1,4,-1],faceHidden=[False,False,False,False,True,True,True,True,True,True,True,True,True],shellType='LATTICE_MESH',vertexRound=[1.0,1.0,1.0,1.0,1.0,1.0,1.3058,1.0,1.0,1.0,1.0,1.0,1.0],
          coord=Coordinate(DEF='COORD0',point=[(0.151544,0.257254,1.69907),(0.151544,0.257254,2.31312),(0.151544,1.02212,1.69907),(0.151544,1.02212,2.31312),(0.394187,0.499885,2.46409),(0.394187,0.779494,2.46409),(0.534093,0.639564,2.58911),(0.673762,0.499885,2.46409),(0.673762,0.779494,2.46409),(0.91658,0.257254,1.69907),(0.91658,0.257254,2.31312),(0.91658,1.02212,1.69907),(0.91658,1.02212,2.31312)]))),
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_eye_white',diffuseColor=(1,1,1),specularColor=(0.2,0.2,0.2))),
        geometry=XvlShell(edgeBeginCoordIndex=[4,4,5,7],edgeBeginVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeEndCoordIndex=[7,5,8,8],edgeEndVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeRound=[0,0,0,0],faceCoordIndex=[5,6,8,-1,7,6,4,-1,8,6,7,-1,6,5,4,-1,9,0,2,11,-1,10,1,0,9,-1,12,3,5,8,-1,11,12,10,9,-1,3,2,0,1,-1,7,4,1,10,-1,12,8,7,10,-1,11,2,3,12,-1,5,3,1,4,-1],faceHidden=[True,True,True,True,False,False,False,False,False,False,False,False,False],shellType='LATTICE_MESH',vertexRound=[1.0,1.0,1.0,1.0,1.0,1.0,1.3058,1.0,1.0,1.0,1.0,1.0,1.0],
          coord=Coordinate(USE='COORD0')))]),
    Group(DEF='_S1',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_item',diffuseColor=(0.9529,0.9176,0.8706),specularColor=(0.2,0.2,0.2))),
        geometry=XvlShell(faceCoordIndex=[1,3,2,0,-1,6,1,25,18,-1,9,21,20,8,-1,20,21,19,18,-1,21,9,7,19,-1,20,27,3,8,-1,25,27,20,18,-1,3,27,26,2,-1,26,27,25,24,-1,17,15,13,11,-1,6,8,3,1,-1,25,1,0,24,-1,2,11,10,0,-1,14,12,4,22,-1,5,23,22,4,-1,11,13,12,10,-1,6,18,19,7,-1,26,17,11,2,-1,26,24,16,17,-1,9,8,6,7,-1,17,16,14,15,-1,14,16,10,12,-1,15,23,5,13,-1,15,14,22,23,-1,12,13,5,4,-1,24,0,10,16,-1],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD1',point=[(-0.333237,-0.301696,2.75223),(-0.333237,-0.301696,2.90631),(-0.333237,0.364784,2.75223),(-0.333237,0.364784,2.90631),(-0.261151,-0.229606,2.17814),(-0.261151,0.292695,2.17814),(-0.197429,-0.165886,2.9174),(-0.197429,-0.165886,3.1374),(-0.197429,0.228974,2.9174),(-0.197429,0.228974,3.1374),(-0.189695,-0.158146,2.74114),(-0.189695,0.221244,2.74114),(-0.113288,-0.081746,2.61797),(-0.113288,0.144834,2.61797),(0.113288,-0.081746,2.61797),(0.113288,0.144834,2.61797),(0.189695,-0.158146,2.74114),(0.189695,0.221244,2.74114),(0.197429,-0.165886,2.9174),(0.197429,-0.165886,3.1374),(0.197429,0.228974,2.9174),(0.197429,0.228974,3.1374),(0.261151,-0.229606,2.17814),(0.261151,0.292695,2.17814),(0.333237,-0.301696,2.75223),(0.333237,-0.301696,2.90631),(0.333237,0.364784,2.75223),(0.333237,0.364784,2.90631)])))]),
    Group(DEF='_S2',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_wear',diffuseColor=(0.0588,0.8549,0.9412))),
        geometry=XvlShell(faceCoordIndex=[147,144,210,175,-1,148,147,97,98,-1,134,144,100,111,-1,210,204,214,181,-1,169,158,136,163,-1,177,191,179,226,-1,174,191,53,69,-1,191,177,67,53,-1,232,192,184,179,-1,243,238,186,190,-1,177,226,166,159,-1,67,177,159,86,-1,226,179,184,166,-1,243,232,185,199,-1,199,185,153,150,-1,242,221,238,244,-1,238,243,199,180,-1,199,150,143,180,-1,143,186,178,139,-1,244,238,180,218,-1,170,180,143,139,-1,242,244,218,203,-1,170,203,218,180,-1,53,67,18,65,-1,65,60,52,12,-1,66,58,102,106,-1,12,52,54,1,-1,92,59,45,95,-1,12,1,45,59,-1,102,95,45,64,-1,54,58,6,1,-1,41,26,0,2,-1,95,54,52,92,-1,52,60,108,92,-1,65,18,79,60,-1,18,67,86,79,-1,184,192,153,137,-1,70,69,63,34,-1,76,87,34,40,-1,63,109,82,30,-1,40,34,63,30,-1,144,147,148,145,-1,144,145,101,100,-1,100,101,98,97,-1,175,210,181,174,-1,210,158,169,204,-1,147,175,174,69,70,97,-1,97,70,34,100,-1,158,134,111,87,109,136,-1,111,100,34,87,-1,109,87,76,82,-1,243,190,192,232,-1,179,191,174,181,136,141,-1,232,179,141,185,-1,178,186,238,221,-1,185,141,137,153,-1,141,136,109,104,-1,63,69,53,65,104,109,-1,137,141,104,108,-1,86,159,166,79,-1,108,60,79,166,184,137,-1,102,58,54,95,-1,92,108,104,59,-1,104,65,12,59,-1,45,1,6,64,-1,106,102,64,75,-1,6,58,66,23,-1,106,75,23,66,-1,64,6,0,26,-1,64,26,41,75,-1,0,6,23,2,-1,2,23,75,41,-1,190,186,143,150,-1,170,221,242,203,-1,178,221,170,139,-1,192,190,150,153,-1,181,214,163,136,-1,210,144,134,158,-1,152,156,132,135,-1,151,135,132,160,-1,211,125,124,164,224,-1,152,135,151,176,-1,129,121,120,130,-1,160,132,142,173,-1,114,122,123,113,-1,119,120,115,112,-1,114,112,115,116,-1,195,207,197,216,-1,113,89,93,110,-1,207,173,142,155,198,-1,229,227,239,-1,229,239,230,206,-1,230,217,202,206,-1,142,118,117,155,-1,227,229,206,209,-1,201,217,230,209,-1,85,71,103,113,-1,49,89,81,20,-1,117,90,155,-1,118,103,90,117,-1,71,85,49,37,-1,103,71,37,46,90,-1,198,155,90,46,101,145,-1,27,28,48,43,-1,212,215,193,189,-1,193,215,205,188,-1,189,193,188,187,-1,233,220,200,208,-1,212,189,187,200,-1,222,228,214,204,-1,205,222,204,169,172,188,-1,172,161,165,171,-1,165,161,146,149,-1,146,161,154,138,-1,208,200,187,171,165,157,162,213,223,-1,157,154,163,162,-1,140,149,146,138,-1,138,154,157,140,-1,78,77,61,62,-1,72,84,76,-1,105,88,91,107,-1,73,80,84,72,-1,78,62,57,73,-1,29,51,56,39,-1,29,32,55,51,-1,57,55,32,44,-1,82,91,88,83,-1,44,24,11,36,-1,3,7,22,16,-1,22,40,30,16,-1,21,16,30,31,-1,13,7,3,4,-1,4,21,36,13,-1,61,77,72,56,-1,171,187,182,167,-1,220,225,205,200,-1,205,215,212,200,-1,46,37,47,-1,236,225,220,233,-1,236,222,205,225,-1,241,228,222,237,-1,85,94,68,49,-1,202,197,196,201,-1,118,119,112,103,-1,122,121,129,131,-1,224,164,156,195,-1,195,156,152,176,-1,164,124,123,132,156,-1,160,173,207,195,-1,224,195,216,235,-1,123,122,131,132,-1,131,129,130,133,-1,120,121,116,115,-1,114,116,121,122,-1,130,120,119,133,-1,132,131,133,142,-1,142,133,119,118,-1,211,224,235,234,219,-1,128,125,211,219,-1,197,207,198,-1,114,113,103,112,-1,217,216,197,202,-1,113,110,94,85,-1,196,216,217,201,-1,94,110,93,68,-1,68,93,89,49,-1,196,194,234,235,216,-1,25,33,125,128,-1,197,198,145,148,194,196,-1,128,219,234,127,-1,28,49,20,9,-1,241,237,231,240,-1,233,208,222,236,-1,237,222,208,231,-1,183,188,172,168,-1,183,182,187,188,-1,183,168,167,182,-1,241,240,223,228,-1,223,240,231,208,-1,168,172,171,167,-1,169,161,172,-1,228,223,213,214,-1,107,99,96,105,-1,99,84,80,96,-1,72,77,78,73,-1,105,96,80,88,-1,62,61,56,57,-1,91,82,76,84,-1,56,51,55,57,-1,39,19,24,44,-1,56,72,76,40,22,39,-1,22,8,19,39,-1,36,22,7,13,-1,3,16,21,4,-1,88,80,73,57,44,36,21,31,83,-1,82,83,31,30,-1,24,19,8,11,-1,36,11,8,22,-1,29,39,44,32,-1,107,91,84,99,-1,165,149,140,157,-1,169,163,154,161,-1,214,213,162,163,-1,47,37,49,28,-1,27,42,47,28,-1,48,47,42,43,-1,14,5,15,38,-1,43,42,38,35,-1,15,5,17,-1,38,15,17,35,-1,101,46,47,48,50,74,98,-1,28,9,10,50,48,-1,9,20,33,25,10,-1,234,194,126,127,-1,25,128,127,10,-1,10,127,126,50,-1,50,126,194,148,98,74,-1,27,14,38,42,-1,27,43,35,14,-1,5,14,35,17,-1,230,239,227,209,-1,206,202,201,209,-1,125,33,20,81,124,-1,124,81,89,113,123,-1,160,195,176,151,-1],faceHidden=[False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True],shellType='LATTICE_MESH',
          coord=Coordinate(DEF='COORD2',point=[(-1.71305,-2.07555,-2.3043),(-1.58268,-1.87519,-1.58718),(-1.57656,-1.98758,-2.76055),(-1.54335,-2.23147,1.11629),(-1.47638,-2.44791,1.1134),(-1.45448,0.243514,1.30256),(-1.44765,-1.69498,-2.21264),(-1.44722,-2.20369,1.26351),(-1.44348,-2.18803,1.35371),(-1.41054,1.03343,1.27587),(-1.39227,0.782314,0.120707),(-1.39226,-2.40872,1.35058),(-1.388,-1.72769,-1.1852),(-1.38024,-2.42012,1.26062),(-1.36703,0.478234,1.31424),(-1.33466,-0.115856,1.36224),(-1.32806,-2.1628,0.96273),(-1.32798,-0.019736,1.05623),(-1.298,-0.620669,-1.23283),(-1.29354,-2.15505,1.48202),(-1.28485,1.30641,2.34615),(-1.26109,-2.37924,0.95985),(-1.2602,-2.14719,1.14809),(-1.24232,-1.59424,-2.61678),(-1.24231,-2.37573,1.47889),(-1.23589,2.02923,0.042294),(-1.2268,-2.56065,-2.25236),(-1.22439,0.360364,1.33329),(-1.21963,0.464425,1.36149),(-1.20214,-2.14874,1.57216),(-1.19657,-2.18612,0.67384),(-1.18567,-2.41086,0.70047),(-1.17243,-2.37243,1.55169),(-1.17219,2.44289,2.29118),(-1.16783,-1.28994,1.03359),(-1.16026,-0.014756,1.07863),(-1.15669,-2.34608,1.11543),(-1.14471,0.368634,2.36803),(-1.13764,-0.194756,1.38855),(-1.13318,-2.11823,1.30805),(-1.1326,-2.03764,0.9941),(-1.0903,-2.47268,-2.7086),(-1.08572,-0.052956,1.39548),(-1.08407,0.057594,1.0888),(-1.06447,-2.32846,1.25884),(-1.06427,-2.42622,-1.60132),(-1.03326,-0.408976,2.29152),(-1.02873,-0.104586,1.44711),(-1.02647,0.047604,1.02491),(-1.02576,0.504795,2.22536),(-1.02421,0.199794,0.60271),(-1.00863,-2.12795,1.62584),(-1.00625,-1.30934,-1.74838),(-1,-0.306916,-0.654674),(-0.98225,-1.25663,-1.74857),(-0.978918,-2.35164,1.60537),(-0.935439,-2.09929,1.38803),(-0.913754,-2.31392,1.31875),(-0.912907,-1.2004,-2.03489),(-0.897024,-2.31026,-1.23096),(-0.890776,-1.31638,-1.96343),(-0.879221,-2.12175,1.64385),(-0.875006,-2.34709,1.62065),(-0.872153,-1.3814,0.30344),(-0.853325,-2.28347,-2.15304),(-0.826934,-1.31273,-1.09615),(-0.810228,-1.17817,-2.37521),(-0.802037,0.161034,-1.36658),(-0.79649,0.606764,2.10128),(-0.79313,-0.311506,-0.054199),(-0.79313,0.020774,0.38857),(-0.733158,0.043844,2.51147),(-0.724567,-2.08735,1.33778),(-0.720351,-2.3127,1.31458),(-0.717205,-0.023476,0.67833),(-0.7134,-2.12191,-2.56028),(-0.679859,-2.01271,1.13109),(-0.672959,-2.11387,1.60476),(-0.668743,-2.33921,1.58157),(-0.653218,-1.33473,-2.47747),(-0.636966,-2.29979,1.24893),(-0.629216,1.31642,2.92981),(-0.621262,-2.1535,0.71361),(-0.61036,-2.37824,0.74024),(-0.609074,-2.1091,1.24743),(-0.606963,0.385834,2.52389),(-0.581599,-0.209726,-2.46413),(-0.561704,-1.50942,1.16799),(-0.536132,-2.31593,1.07144),(-0.528925,1.05528,2.53629),(-0.516629,-0.526316,2.36874),(-0.50824,-2.12524,1.06994),(-0.483176,-1.93732,-1.82912),(-0.482392,0.864325,2.31449),(-0.478213,0.491354,2.2035),(-0.455123,-1.78634,-1.74083),(-0.437522,-2.32805,1.36481),(-0.4102,-0.144486,0.71023),(-0.4102,-0.118376,0.80955),(-0.409631,-2.13736,1.36331),(-0.399044,-0.720619,1.18916),(-0.399044,-0.436526,1.48784),(-0.380694,-1.72529,-1.98465),(-0.364775,0.048434,2.5777),(-0.363767,-1.83974,-1.15126),(-0.336689,-2.34419,1.18732),(-0.323972,-1.66327,-2.32327),(-0.308796,-2.15351,1.18582),(-0.291044,-1.72848,-1.88021),(-0.266031,-1.60087,0.58009),(-0.262593,0.681904,2.28362),(-0.257626,-1.05547,1.28294),(-0.211839,0.346584,2.66147),(-0.175408,0.632644,2.5356),(-0.15432,0.551194,2.67786),(-0.116796,0.428445,2.78537),(-0.068174,0.552885,2.7764),(-1e-006,-0.318036,2.6912),(-1e-006,0.069734,2.80639),(-1e-006,0.354814,2.74982),(-1e-006,0.432985,2.83408),(-1e-006,0.588964,2.8039),(-1e-006,0.632874,2.73828),(-1e-006,0.794485,2.69585),(-1e-006,1.37398,2.9602),(-1e-006,2.84403,2.45305),(0,-0.141146,0.36207),(0,0.653835,-0.652758),(0,2.37107,-0.201295),(0.068172,0.552885,2.7764),(0.116794,0.428445,2.78537),(0.154317,0.551194,2.67786),(0.175406,0.632644,2.5356),(0.211837,0.346584,2.66147),(0.257626,-1.05547,1.28294),(0.262589,0.681904,2.28362),(0.26603,-1.60087,0.58009),(0.291044,-1.72848,-1.88021),(0.308796,-2.15351,1.18582),(0.323972,-1.66327,-2.32327),(0.336688,-2.34419,1.18732),(0.363767,-1.83974,-1.15126),(0.364773,0.048434,2.5777),(0.380694,-1.72529,-1.98465),(0.399044,-0.720619,1.18916),(0.399044,-0.436526,1.48784),(0.409631,-2.13736,1.36331),(0.410201,-0.144486,0.71023),(0.410201,-0.118376,0.80955),(0.437522,-2.32805,1.36481),(0.455123,-1.78634,-1.74083),(0.478208,0.491354,2.2035),(0.482387,0.864325,2.31449),(0.483176,-1.93732,-1.82912),(0.508239,-2.12524,1.06994),(0.516627,-0.526316,2.36874),(0.52892,1.05528,2.53629),(0.536132,-2.31593,1.07144),(0.561704,-1.50942,1.16799),(0.581599,-0.209726,-2.46413),(0.606958,0.385834,2.52388),(0.609074,-2.1091,1.24743),(0.61036,-2.37824,0.74024),(0.621262,-2.1535,0.71361),(0.629214,1.31642,2.92981),(0.636966,-2.29979,1.24893),(0.653218,-1.33473,-2.47747),(0.668743,-2.33921,1.58157),(0.672959,-2.11387,1.60476),(0.679859,-2.01271,1.13109),(0.7134,-2.12191,-2.56028),(0.720351,-2.3127,1.31459),(0.724567,-2.08735,1.33778),(0.733154,0.043844,2.51147),(0.79313,-0.311516,-0.054199),(0.79313,0.020774,0.38857),(0.796482,0.606764,2.10128),(0.802037,0.161034,-1.36658),(0.810228,-1.17817,-2.37521),(0.826935,-1.31273,-1.09615),(0.853325,-2.28347,-2.15304),(0.872154,-1.3814,0.30344),(0.875006,-2.34709,1.62065),(0.879221,-2.12175,1.64385),(0.890777,-1.31637,-1.96343),(0.897024,-2.31026,-1.23096),(0.912907,-1.2004,-2.03489),(0.913754,-2.31392,1.31875),(0.935439,-2.09929,1.38803),(0.978918,-2.35164,1.60537),(0.98225,-1.25663,-1.74857),(1,-0.306916,-0.654674),(1.00625,-1.30934,-1.74838),(1.00863,-2.12795,1.62584),(1.02421,0.199794,0.60271),(1.02575,0.504795,2.22536),(1.02647,0.047604,1.02491),(1.02873,-0.104586,1.44712),(1.03325,-0.408976,2.29152),(1.06427,-2.42622,-1.60132),(1.06447,-2.32846,1.25884),(1.08407,0.057594,1.08881),(1.08572,-0.052956,1.39549),(1.0903,-2.47268,-2.7086),(1.1326,-2.03764,0.9941),(1.13318,-2.11823,1.30805),(1.13764,-0.194756,1.38855),(1.14469,0.368634,2.36803),(1.1567,-2.34608,1.11543),(1.16026,-0.014756,1.07863),(1.16783,-1.28995,1.03359),(1.17219,2.44289,2.29118),(1.17243,-2.37243,1.55169),(1.18567,-2.41086,0.70047),(1.19657,-2.18612,0.67384),(1.20214,-2.14874,1.57216),(1.21963,0.464425,1.36149),(1.22438,0.360364,1.33329),(1.2268,-2.56065,-2.25236),(1.23589,2.02922,0.042296),(1.24231,-2.37573,1.47889),(1.24232,-1.59424,-2.61678),(1.2602,-2.14719,1.14809),(1.26109,-2.37924,0.95985),(1.28485,1.30641,2.34616),(1.29354,-2.15505,1.48202),(1.298,-0.620669,-1.23283),(1.32798,-0.019736,1.05624),(1.32806,-2.1628,0.96273),(1.33466,-0.115856,1.36224),(1.36703,0.478234,1.31424),(1.38024,-2.42012,1.26062),(1.388,-1.72769,-1.1852),(1.39226,-2.40872,1.35058),(1.39227,0.782314,0.120709),(1.41054,1.03343,1.27587),(1.44348,-2.18803,1.35371),(1.44722,-2.20369,1.26351),(1.44765,-1.69498,-2.21264),(1.45448,0.243514,1.30256),(1.47638,-2.44791,1.1134),(1.54335,-2.23147,1.11629),(1.57656,-1.98758,-2.76055),(1.58268,-1.87519,-1.58718),(1.71305,-2.07555,-2.3043)]))),
      Shape(
        appearance=Appearance(
          material=Material(DEF='SGE_DEF_MATERIAL',diffuseColor=(0.9569,0.7608,0.6431))),
        geometry=XvlShell(faceCoordIndex=[147,144,210,175,-1,148,147,97,98,-1,134,144,100,111,-1,210,204,214,181,-1,169,158,136,163,-1,177,191,179,226,-1,174,191,53,69,-1,191,177,67,53,-1,232,192,184,179,-1,243,238,186,190,-1,177,226,166,159,-1,67,177,159,86,-1,226,179,184,166,-1,243,232,185,199,-1,199,185,153,150,-1,242,221,238,244,-1,238,243,199,180,-1,199,150,143,180,-1,143,186,178,139,-1,244,238,180,218,-1,170,180,143,139,-1,242,244,218,203,-1,170,203,218,180,-1,53,67,18,65,-1,65,60,52,12,-1,66,58,102,106,-1,12,52,54,1,-1,92,59,45,95,-1,12,1,45,59,-1,102,95,45,64,-1,54,58,6,1,-1,41,26,0,2,-1,95,54,52,92,-1,52,60,108,92,-1,65,18,79,60,-1,18,67,86,79,-1,184,192,153,137,-1,70,69,63,34,-1,76,87,34,40,-1,63,109,82,30,-1,40,34,63,30,-1,144,147,148,145,-1,144,145,101,100,-1,100,101,98,97,-1,175,210,181,174,-1,210,158,169,204,-1,147,175,174,69,70,97,-1,97,70,34,100,-1,158,134,111,87,109,136,-1,111,100,34,87,-1,109,87,76,82,-1,243,190,192,232,-1,179,191,174,181,136,141,-1,232,179,141,185,-1,178,186,238,221,-1,185,141,137,153,-1,141,136,109,104,-1,63,69,53,65,104,109,-1,137,141,104,108,-1,86,159,166,79,-1,108,60,79,166,184,137,-1,102,58,54,95,-1,92,108,104,59,-1,104,65,12,59,-1,45,1,6,64,-1,106,102,64,75,-1,6,58,66,23,-1,106,75,23,66,-1,64,6,0,26,-1,64,26,41,75,-1,0,6,23,2,-1,2,23,75,41,-1,190,186,143,150,-1,170,221,242,203,-1,178,221,170,139,-1,192,190,150,153,-1,181,214,163,136,-1,210,144,134,158,-1,152,156,132,135,-1,151,135,132,160,-1,211,125,124,164,224,-1,152,135,151,176,-1,129,121,120,130,-1,160,132,142,173,-1,114,122,123,113,-1,119,120,115,112,-1,114,112,115,116,-1,195,207,197,216,-1,113,89,93,110,-1,207,173,142,155,198,-1,229,227,239,-1,229,239,230,206,-1,230,217,202,206,-1,142,118,117,155,-1,227,229,206,209,-1,201,217,230,209,-1,85,71,103,113,-1,49,89,81,20,-1,117,90,155,-1,118,103,90,117,-1,71,85,49,37,-1,103,71,37,46,90,-1,198,155,90,46,101,145,-1,27,28,48,43,-1,212,215,193,189,-1,193,215,205,188,-1,189,193,188,187,-1,233,220,200,208,-1,212,189,187,200,-1,222,228,214,204,-1,205,222,204,169,172,188,-1,172,161,165,171,-1,165,161,146,149,-1,146,161,154,138,-1,208,200,187,171,165,157,162,213,223,-1,157,154,163,162,-1,140,149,146,138,-1,138,154,157,140,-1,78,77,61,62,-1,72,84,76,-1,105,88,91,107,-1,73,80,84,72,-1,78,62,57,73,-1,29,51,56,39,-1,29,32,55,51,-1,57,55,32,44,-1,82,91,88,83,-1,44,24,11,36,-1,3,7,22,16,-1,22,40,30,16,-1,21,16,30,31,-1,13,7,3,4,-1,4,21,36,13,-1,61,77,72,56,-1,171,187,182,167,-1,220,225,205,200,-1,205,215,212,200,-1,46,37,47,-1,236,225,220,233,-1,236,222,205,225,-1,241,228,222,237,-1,85,94,68,49,-1,202,197,196,201,-1,118,119,112,103,-1,122,121,129,131,-1,224,164,156,195,-1,195,156,152,176,-1,164,124,123,132,156,-1,160,173,207,195,-1,224,195,216,235,-1,123,122,131,132,-1,131,129,130,133,-1,120,121,116,115,-1,114,116,121,122,-1,130,120,119,133,-1,132,131,133,142,-1,142,133,119,118,-1,211,224,235,234,219,-1,128,125,211,219,-1,197,207,198,-1,114,113,103,112,-1,217,216,197,202,-1,113,110,94,85,-1,196,216,217,201,-1,94,110,93,68,-1,68,93,89,49,-1,196,194,234,235,216,-1,25,33,125,128,-1,197,198,145,148,194,196,-1,128,219,234,127,-1,28,49,20,9,-1,241,237,231,240,-1,233,208,222,236,-1,237,222,208,231,-1,183,188,172,168,-1,183,182,187,188,-1,183,168,167,182,-1,241,240,223,228,-1,223,240,231,208,-1,168,172,171,167,-1,169,161,172,-1,228,223,213,214,-1,107,99,96,105,-1,99,84,80,96,-1,72,77,78,73,-1,105,96,80,88,-1,62,61,56,57,-1,91,82,76,84,-1,56,51,55,57,-1,39,19,24,44,-1,56,72,76,40,22,39,-1,22,8,19,39,-1,36,22,7,13,-1,3,16,21,4,-1,88,80,73,57,44,36,21,31,83,-1,82,83,31,30,-1,24,19,8,11,-1,36,11,8,22,-1,29,39,44,32,-1,107,91,84,99,-1,165,149,140,157,-1,169,163,154,161,-1,214,213,162,163,-1,47,37,49,28,-1,27,42,47,28,-1,48,47,42,43,-1,14,5,15,38,-1,43,42,38,35,-1,15,5,17,-1,38,15,17,35,-1,101,46,47,48,50,74,98,-1,28,9,10,50,48,-1,9,20,33,25,10,-1,234,194,126,127,-1,25,128,127,10,-1,10,127,126,50,-1,50,126,194,148,98,74,-1,27,14,38,42,-1,27,43,35,14,-1,5,14,35,17,-1,230,239,227,209,-1,206,202,201,209,-1,125,33,20,81,124,-1,124,81,89,113,123,-1,160,195,176,151,-1],faceHidden=[True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,True,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False,False],shellType='LATTICE_MESH',
          coord=Coordinate(USE='COORD2')))]),
    Group(DEF='_S3',
      children=[
      Shape(
        appearance=Appearance(
          material=Material(USE='SGE_eye_black')),
        geometry=XvlShell(edgeBeginCoordIndex=[4,4,5,7],edgeBeginVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeEndCoordIndex=[5,7,8,8],edgeEndVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeRound=[0,0,0,0],faceCoordIndex=[6,8,5,-1,6,5,4,-1,8,6,7,-1,7,6,4,-1,9,10,1,0,-1,5,3,1,4,-1,8,7,10,12,-1,11,12,10,9,-1,10,7,4,1,-1,11,9,0,2,-1,3,2,0,1,-1,8,12,3,5,-1,12,11,2,3,-1],faceHidden=[False,False,False,False,True,True,True,True,True,True,True,True,True],shellType='LATTICE_MESH',vertexRound=[1.0,1.0,1.0,1.0,1.0,1.0,1.3058,1.0,1.0,1.0,1.0,1.0,1.0],
          coord=Coordinate(DEF='COORD3',point=[(-0.91658,0.257254,1.69907),(-0.91658,0.257254,2.31312),(-0.91658,1.02212,1.69907),(-0.91658,1.02212,2.31312),(-0.673762,0.499885,2.46409),(-0.673762,0.779494,2.46409),(-0.534093,0.639564,2.58911),(-0.394187,0.499885,2.46409),(-0.394187,0.779494,2.46409),(-0.151544,0.257254,1.69907),(-0.151544,0.257254,2.31312),(-0.151544,1.02212,1.69907),(-0.151544,1.02212,2.31312)]))),
      Shape(
        appearance=Appearance(
          material=Material(USE='SGE_eye_white')),
        geometry=XvlShell(edgeBeginCoordIndex=[4,4,5,7],edgeBeginVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeEndCoordIndex=[5,7,8,8],edgeEndVector=[(0,1,0),(0,1,0),(0,1,0),(0,1,0)],edgeRound=[0,0,0,0],faceCoordIndex=[6,8,5,-1,6,5,4,-1,8,6,7,-1,7,6,4,-1,9,10,1,0,-1,5,3,1,4,-1,8,7,10,12,-1,11,12,10,9,-1,10,7,4,1,-1,11,9,0,2,-1,3,2,0,1,-1,8,12,3,5,-1,12,11,2,3,-1],faceHidden=[True,True,True,True,False,False,False,False,False,False,False,False,False],shellType='LATTICE_MESH',vertexRound=[1.0,1.0,1.0,1.0,1.0,1.0,1.3058,1.0,1.0,1.0,1.0,1.0,1.0],
          coord=Coordinate(USE='COORD3')))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for XvlShellModelBaby.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python XvlShellModelBaby.py load and self-test diagnostics complete.")
