/**
 *<p>
 *	The X3D Geospatial component provides support for geographic and geospatial applications that
 *	includes the ability to utilize double-precision geospatial coordinates and to handle 
 *	large multi-resolution terrain databases. 
 *</p>
 *<p>
 *	These examples
 *	illustrate capabilities provided by the 
 *	<a href="https://www.web3d.org/documents/specifications/19775-1/V4.0/Part01/components/geodata.html" target="_blank">X3D Abstract Specification Geospatial Component</a>.
 *	Significant additional work is being pursued by the
 *	<a href="https://www.web3d.org/working-groups/x3d-earth" target="_blank">X3D Earth Working Group Executive Summary</a>
 *	and is documented on the
 *	<a href="http://web3d.org/x3d/wiki/index.php/X3D_Earth_Working_Group" target="_blank">X3D Earth Working Group Wiki</a>.
 *</p>
 *
 *<p>
 *	The supporting
 *	<a href="https://x3dGraphics.com/slidesets/X3dForAdvancedModeling" target="X3dChapterSlideset">Geospatial Component - X3D Earth chapter slideset</a>
 *	is available online via
 *	<a href="https://x3dGraphics.com">X3dGraphics.com</a>.
 *</p>
 * 
 *<p>
 *	This <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial" target="_blank">X3D Basic: Geospatial</a> examples archive
 *      is online.
 *</p>
 *
 * <p> The X3D Java Scene Access Interface (x3djsail) package provides concrete classes for each X3D node and statement. </p>
 *  
 * <p> Online:
 *     <a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>
 *     and 
 *     <a href="https://www.web3d.org/specifications/java/javadoc" target="_blank">X3DJSAIL Javadoc</a>
 * </p>
 * @see <a href="https://www.web3d.org/x3d/content/examples/Vrml2Sourcebook" target="_blank">X3D VRML 2 Sourcebook Examples Archive</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>
 * @see <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>
 * @see <a href="https://www.web3d.org/x3d/tooltips/X3dTooltips.html" target="_blank">X3D Tooltips</a>
 * @see java.lang.Package
 * @see <a href="https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful" target="_blank">https://stackoverflow.com/questions/22095487/why-is-package-info-java-useful</a>
 * @see <a href="https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java" target="_blank">https://stackoverflow.com/questions/624422/how-do-i-document-packages-in-java</a>
 */

package Basic.Geospatial;

