####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python newGeospatialScene.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='newGeospatialScene.x3d',name='title'),
    meta(content='Don Brutzman',name='creator'),
    meta(content='23 May 2000',name='created'),
    meta(content='26 August 2023',name='modified'),
    meta(content='Sample default scene which shows syntax and provides default relationships among Geospatial nodes.',name='description'),
    meta(content='Empty nodes are provided as informational exampls and fail various diagnostic tests',name='warning'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/newGeospatialScene.x3d',name='identifier'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    #  ExternProtoDeclare statements for Geospatial nodes are no longer needed for backwards compatibility for VRML 97, since X3dToVrml97.xsl now handles that task. 
    #  This scene shows example Geospatial node relationships in a scene graph. 
    children=[
    WorldInfo(info=["WorldInfo contains generic information or metadata about a model, not about the georeferenced information."],title='newGeospatialScene.x3d'),
    GeoMetadata(url=["https://exampleResource.com/ExternalMetadataDescription.x3d"],
      #  original GeoMetadata summary='"title" "example title" "description" "example description"' 
      metadata=MetadataSet(name='GeoMetadata.summary',reference='https://www.web3d.org/specifications/X3Dv4/ISO-IEC19775-1v4-IS/Part01/components/geospatial.html#GeoMetadata',
        value=[
        MetadataString(name='title',value=['TODO']),
        MetadataString(name='description',value=['TODO']),
        MetadataString(name='coordinateSystem',value=['TODO']),
        MetadataString(name='horizontalDatum',value=['TODO']),
        MetadataString(name='verticalDatum',value=['TODO']),
        MetadataString(name='ellipsoid',value=['TODO']),
        MetadataString(name='extent',value=['0']),
        MetadataFloat(name='resolution',value=[0]),
        MetadataString(name='originator',value=['TODO']),
        MetadataString(name='copyright',value=['TODO']),
        MetadataString(name='date',value=['TODO']),
        MetadataString(name='metadataFormat',value=['TODO']),
        MetadataString(name='dataUrl',value=['TODO']),
        MetadataString(name='dataFormat',value=['TODO'])])),
    GeoViewpoint(
      geoOrigin=GeoOrigin(DEF='DefaultGeoOrigin')),
    #  GeoInline replaced by Inline 
    Inline(DEF='GeoInlineReplacedByInline'),
    GeoLocation(
      geoOrigin=GeoOrigin(USE='DefaultGeoOrigin')),
    GeoLOD(center=(10,10,1),child1Url=["https://b"],child2Url=["https://c"],child3Url=["https://d"],child4Url=["https://e"],range=1000,rootUrl=["https://a"],
      rootNode=[
      GeoOrigin(USE='DefaultGeoOrigin'),
      #  Nodes loaded via the 'rootUrl' field appear under 'rootNode' for current GeoLOD level. 
      #  Defining both 'rootUrl' and 'rootNode' is erroneous, use either one or the other. 
      #  rootNode nodes are the default geometry to be shown at this level of detail 
      WorldInfo(),
      Shape(),]),
    Shape(DEF='ExampleGeoSnippet1',
      geometry=GeoElevationGrid(DEF='EmptyGeoElevationGrid',
        geoOrigin=GeoOrigin(USE='DefaultGeoOrigin'),
        color=Color(),
        normal=Normal(),
        texCoord=TextureCoordinate(),)),
    Shape(DEF='ExampleGeoSnippet2',
      geometry=IndexedFaceSet(
        coord=GeoCoordinate(
          geoOrigin=GeoOrigin(USE='DefaultGeoOrigin'))))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for newGeospatialScene.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python newGeospatialScene.py load and self-test diagnostics complete.")
