package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.EnvironmentalEffects.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geometry3D.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.PointingDeviceSensor.*;
import org.web3d.x3d.jsail.Scripting.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> World selector with high vertical exaggeration. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/WorldHighIndex.html" target="_blank">WorldHigh</a>,  source <a href="../../../Geospatial/WorldHigh.java">WorldHigh.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/WorldHigh.x3d">WorldHigh.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> World selector with high vertical exaggeration. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Martin Reddy SRI authored the original scene. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 October 2019 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/WorldHigh.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/WorldHigh.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Martin Reddy SRI authored the original scene.
 */

public class WorldHigh
{
	/** Default constructor to create this object. */
	public WorldHigh ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("WorldHigh.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("World selector with high vertical exaggeration."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Martin Reddy SRI authored the original scene."))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 October 2019"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/WorldHigh.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("WorldHigh.x3d"))
    .addChild(new Group()
      .addChild(new GeoViewpoint().setDescription("Initial GeoViewpoint").setOrientation(1.0,0.0,0.0,-1.57).setPosition(35.0,-70.0,13000000.0))
      .addChild(new Background().setGroundColor(new MFColor(new double[] {0.0,0.0,1.0})).setSkyAngle(new double[] {1.57}).setSkyColor(new MFColor(new double[] {0.0,0.0,1.0,0.0,0.0,0.0})))
      .addChild(new GeoLocation().setGeoCoords(35.0,-70.0,10000000.0)
        .addChild(new Transform().setTranslation(-1000000.0,0.0,-600000.0)
          .addChild(new TouchSensor("Touch1").setDescription("vertical scale times 1"))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setTexture(new ImageTexture().setUrl(new String[] {"images/x1.gif","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/xl.jpg"})))
            .setGeometry(new Box("BOX").setSize(200000.0,200000.0,200000.0))))
        .addChild(new Transform().setTranslation(-1000000.0,0.0,-300000.0)
          .addChild(new TouchSensor("Touch50").setDescription("vertical scale times 50"))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setTexture(new ImageTexture().setUrl(new String[] {"images/x50.gif","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/x50.gif"})))
            .setGeometry(new Box().setUSE("BOX"))))
        .addChild(new Transform().setTranslation(-1000000.0,0.0,-0.0)
          .addChild(new TouchSensor("Touch200").setDescription("vertical scale times 200"))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setTexture(new ImageTexture().setUrl(new String[] {"images/x200.gif","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/x200.gif"})))
            .setGeometry(new Box().setUSE("BOX"))))
        .addChild(new Transform().setTranslation(-1000000.0,0.0,300000.0)
          .addChild(new TouchSensor("TouchShaded").setDescription("simple shading no texture image"))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setTexture(new ImageTexture().setUrl(new String[] {"images/shaded.gif","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/shaded.gif"})))
            .setGeometry(new Box().setUSE("BOX"))))
        .addChild(new Transform().setTranslation(-1000000.0,0.0,600000.0)
          .addChild(new TouchSensor("TouchTextured").setDescription("apply texture image"))
          .addChild(new Shape()
            .setAppearance(new Appearance()
              .setTexture(new ImageTexture().setUrl(new String[] {"images/textured.gif","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/textured.gif"})))
            .setGeometry(new Box().setUSE("BOX")))))
      .addChild(new SphereSensor("GeoSphere").setDescription("click and drag to rotate"))
      .addChild(new Transform("GeoXform")
        .addChild(new Shape()
          .setAppearance(new Appearance()
            .setMaterial(new Material().setDiffuseColor(0.75,0.75,0.75))
            .setTexture(new ImageTexture("TEX")))
          .setGeometry(new GeoElevationGrid("GEOEG").setGeoGridOrigin(-90.0,-180.0,0.0).setSolid(false).setXDimension(168).setXSpacing(2.15568).setYScale(200.0).setZDimension(84).setZSpacing(2.15568).setHeight(getGEOEG_6_53_height())))))
    .addChild(new Script("Return1").setSourceCode("""
ecmascript:

function set_value( value ) { 
           if ( value == true ) value_changed = 1.0;
}
""")
      .addField(new field().setName("value_changed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_value").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new Script("Return50").setSourceCode("""
ecmascript:

function set_value( value ) { 
           if ( value == true ) value_changed = 50.0;
}
""")
      .addField(new field().setName("value_changed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_value").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new Script("Return200").setSourceCode("""
ecmascript:

function set_value( value ) { 
           if ( value == true ) value_changed = 200.0;
}
""")
      .addField(new field().setName("value_changed").setType(field.TYPE_SFFLOAT).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_value").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new Script("ReturnShaded").setSourceCode("""
ecmascript:

function set_value( value ) { 
           if ( value == true ) value_changed = new MFString('');
}
""")
      .addField(new field().setName("value_changed").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_value").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new Script("ReturnTextured").setSourceCode("""
ecmascript:

function set_value( value ) { 
           if ( value == true ) value_changed = new MFString ('images/earth.gif', 'https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/earth.gif'); 
// Browser.println ('value_changed=' + value_changed);
}
""")
      .addField(new field().setName("value_changed").setType(field.TYPE_MFSTRING).setAccessType(field.ACCESSTYPE_OUTPUTONLY))
      .addField(new field().setName("set_value").setType(field.TYPE_SFBOOL).setAccessType(field.ACCESSTYPE_INPUTONLY)))
    .addChild(new ROUTE().setFromNode("GeoSphere").setFromField("rotation_changed").setToNode("GeoXform").setToField("set_rotation"))
    .addChild(new ROUTE().setFromNode("Touch1").setFromField("isActive").setToNode("Return1").setToField("set_value"))
    .addChild(new ROUTE().setFromNode("Return1").setFromField("value_changed").setToNode("GEOEG").setToField("set_yScale"))
    .addChild(new ROUTE().setFromNode("Touch50").setFromField("isActive").setToNode("Return50").setToField("set_value"))
    .addChild(new ROUTE().setFromNode("Return50").setFromField("value_changed").setToNode("GEOEG").setToField("set_yScale"))
    .addChild(new ROUTE().setFromNode("Touch200").setFromField("isActive").setToNode("Return200").setToField("set_value"))
    .addChild(new ROUTE().setFromNode("Return200").setFromField("value_changed").setToNode("GEOEG").setToField("set_yScale"))
    .addChild(new ROUTE().setFromNode("TouchTextured").setFromField("isActive").setToNode("ReturnTextured").setToField("set_value"))
    .addChild(new ROUTE().setFromNode("ReturnTextured").setFromField("value_changed").setToNode("TEX").setToField("set_url"))
    .addChild(new ROUTE().setFromNode("TouchShaded").setFromField("isActive").setToNode("ReturnShaded").setToField("set_value"))
    .addChild(new ROUTE().setFromNode("ReturnShaded").setFromField("value_changed").setToNode("TEX").setToField("set_url")));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGEOEG_6_53_height_1()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_2()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3094.0,3092.0,3089.0,3081.0,3068.0,3045.0,3017.0,2990.0,2971.0,2957.0,2940.0,2927.0,2906.0,2881.0,2851.0,2831.0,2822.0,2819.0,2816.0,2817.0,2824.0,2837.0,2851.0,2861.0,2864.0,2859.0,2845.0,2826.0,2808.0,2798.0,2788.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_3()
		{
			double[] value = {2778.0,2767.0,2753.0,2734.0,2700.0,2643.0,2602.0,2592.0,2587.0,2584.0,2581.0,2577.0,2572.0,2566.0,2560.0,2556.0,2554.0,2555.0,2558.0,2560.0,2562.0,2564.0,2564.0,2564.0,2563.0,2559.0,2549.0,2534.0,2518.0,2501.0,2488.0,2472.0,2458.0,2449.0,2445.0,2445.0,2449.0,2457.0,2469.0,2485.0,2499.0,2510.0,2522.0,2533.0,2544.0,2554.0,2562.0,2570.0,2578.0,2584.0,2591.0,2598.0,2605.0,2621.0,2641.0,2661.0,2682.0,2697.0,2707.0,2715.0,2721.0,2725.0,2728.0,2729.0,2731.0,2735.0,2743.0,2758.0,2783.0,2811.0,2864.0,2914.0,2953.0,2981.0,2999.0,3009.0,3019.0,3031.0,3041.0,3050.0,3058.0,3065.0,3071.0,3076.0,3080.0,3083.0,3086.0,3088.0,3089.0,3090.0,3091.0,3091.0,3091.0,3092.0,3092.0,3092.0,3092.0,3093.0,3093.0,3094.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_4()
		{
			double[] value = {3094.0,3095.0,3095.0,3094.0,3093.0,3092.0,3091.0,3090.0,3089.0,3089.0,3088.0,3088.0,3087.0,3086.0,3086.0,3085.0,3085.0,3085.0,3084.0,3082.0,3080.0,3078.0,3076.0,3075.0,3075.0,3076.0,3077.0,3079.0,3081.0,3083.0,3086.0,3088.0,3090.0,3091.0,3093.0,3094.0,0.0,2466.0,2632.0,2710.0,2777.0,2911.0,2826.0,1997.0,1692.0,2036.0,833.0,1107.0,858.0,653.0,1097.0,901.0,1115.0,1202.0,1255.0,1307.0,1812.0,1280.0,1168.0,1605.0,3404.0,3088.0,2970.0,2670.0,2584.0,2452.0,2389.0,2393.0,2397.0,2429.0,2504.0,2552.0,2550.0,2422.0,2040.0,1949.0,1980.0,1985.0,1913.0,1777.0,1563.0,1595.0,1636.0,1561.0,1389.0,1334.0,1332.0,1377.0,1419.0,1489.0,1562.0,1654.0,1748.0,1760.0,1767.0,1781.0,1788.0,1793.0,1799.0,1821.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_5()
		{
			double[] value = {1854.0,1885.0,1923.0,1983.0,2042.0,2097.0,2126.0,2148.0,2169.0,2216.0,2308.0,2370.0,2405.0,2443.0,2484.0,2510.0,2531.0,2553.0,2576.0,2594.0,2604.0,2618.0,2634.0,2650.0,2666.0,2683.0,2697.0,2704.0,2710.0,2717.0,2727.0,2743.0,2770.0,2802.0,2858.0,2911.0,2968.0,3022.0,3093.0,3127.0,3160.0,3185.0,3202.0,3220.0,3242.0,3262.0,3278.0,3289.0,3296.0,3301.0,3305.0,3309.0,3312.0,3312.0,3309.0,3304.0,3300.0,3297.0,3291.0,3283.0,3274.0,3261.0,3247.0,3232.0,3218.0,3204.0,3186.0,3170.0,3152.0,3132.0,3114.0,3102.0,3098.0,3094.0,3085.0,3069.0,3051.0,3033.0,3017.0,3006.0,2996.0,2970.0,2942.0,2911.0,2893.0,2875.0,2854.0,2833.0,2817.0,2811.0,2807.0,2800.0,2772.0,2719.0,2681.0,2617.0,2543.0,2512.0,2497.0,2400.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_6()
		{
			double[] value = {2401.0,2393.0,2567.0,2621.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,14.0,57.0,122.0,193.0,246.0,317.0,286.0,270.0,315.0,378.0,400.0,413.0,467.0,565.0,657.0,734.0,853.0,931.0,1049.0,1186.0,1312.0,1420.0,1529.0,1634.0,1805.0,1904.0,1974.0,2007.0,1998.0,1959.0,1914.0,1883.0,1750.0,1635.0,1504.0,1377.0,1298.0,1233.0,1107.0,1037.0,961.0,928.0,848.0,661.0,446.0,142.0,108.0,550.0,819.0,1433.0,1379.0,1109.0,1056.0,1061.0,1129.0,1393.0,1492.0,1537.0,1611.0,1666.0,1695.0,1716.0,1753.0,1790.0,1850.0,1912.0,2003.0,2068.0,2106.0,2151.0,2204.0,2285.0,2332.0,2375.0,2407.0,2448.0,2482.0,2503.0,2522.0,2541.0,2557.0,2571.0,2587.0,2601.0,2635.0,2685.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_7()
		{
			double[] value = {2717.0,2756.0,2834.0,2928.0,2970.0,3031.0,3135.0,3260.0,3333.0,3371.0,3395.0,3416.0,3457.0,3494.0,3522.0,3556.0,3593.0,3618.0,3656.0,3694.0,3724.0,3742.0,3736.0,3726.0,3711.0,3693.0,3655.0,3630.0,3603.0,3584.0,3554.0,3514.0,3473.0,3413.0,3383.0,3351.0,3313.0,3280.0,3216.0,3184.0,3152.0,3116.0,3090.0,3052.0,3009.0,2962.0,2901.0,2873.0,2841.0,2803.0,2779.0,2741.0,2694.0,2634.0,2601.0,2560.0,2513.0,2500.0,2488.0,2409.0,2370.0,2229.0,2200.0,1998.0,2778.0,1766.0,1577.0,804.0,1492.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,67.0,400.0,550.0,560.0,435.0,324.0,358.0,396.0,497.0,601.0,677.0,749.0,838.0,925.0,997.0,1101.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_8()
		{
			double[] value = {1189.0,1300.0,1437.0,1545.0,1706.0,1857.0,1996.0,2065.0,2092.0,2186.0,2208.0,2120.0,2070.0,1962.0,1777.0,1695.0,1377.0,1184.0,942.0,709.0,403.0,255.0,259.0,305.0,315.0,144.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,150.0,456.0,712.0,778.0,790.0,839.0,965.0,1069.0,1175.0,1288.0,1470.0,1609.0,1695.0,1800.0,1892.0,1939.0,1979.0,2012.0,2058.0,2114.0,2221.0,2292.0,2400.0,2463.0,2496.0,2524.0,2564.0,2611.0,2698.0,2769.0,2862.0,2968.0,3016.0,3075.0,3165.0,3239.0,3323.0,3411.0,3481.0,3524.0,3577.0,3626.0,3672.0,3700.0,3720.0,3744.0,3770.0,3796.0,3842.0,3891.0,3928.0,3963.0,3986.0,4002.0,4022.0,4031.0,4017.0,3983.0,3921.0,3869.0,3810.0,3755.0,3699.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_9()
		{
			double[] value = {3667.0,3640.0,3598.0,3528.0,3446.0,3400.0,3358.0,3280.0,3236.0,3188.0,3141.0,3099.0,3034.0,2974.0,2914.0,2798.0,2709.0,2663.0,2637.0,2602.0,2524.0,2432.0,2371.0,2314.0,2216.0,2158.0,2044.0,1824.0,1652.0,1559.0,1981.0,1158.0,225.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,211.0,248.0,0.0,0.0,0.0,0.0,355.0,571.0,663.0,606.0,505.0,497.0,559.0,785.0,1000.0,1177.0,1318.0,1415.0,1492.0,1520.0,1560.0,1633.0,1712.0,1765.0,1808.0,1892.0,1909.0,1934.0,1986.0,2033.0,2015.0,1960.0,1960.0,2020.0,2051.0,1832.0,1882.0,1432.0,492.0,261.0,229.0,0.0,0.0,163.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_10()
		{
			double[] value = {0.0,378.0,646.0,711.0,230.0,0.0,0.0,0.0,0.0,0.0,128.0,586.0,734.0,843.0,874.0,895.0,1175.0,1404.0,1533.0,1796.0,2013.0,2183.0,2257.0,2298.0,2357.0,2427.0,2546.0,2665.0,2754.0,2803.0,2917.0,3008.0,3058.0,3110.0,3190.0,3223.0,3295.0,3348.0,3391.0,3445.0,3527.0,3571.0,3594.0,3608.0,3641.0,3668.0,3670.0,3667.0,3655.0,3614.0,3553.0,3501.0,3489.0,3510.0,3573.0,3633.0,3681.0,3708.0,3726.0,3749.0,3769.0,3772.0,3778.0,3773.0,3769.0,3765.0,3787.0,3790.0,3777.0,3751.0,3720.0,3679.0,3600.0,3500.0,3428.0,3389.0,3354.0,3305.0,3235.0,3175.0,3123.0,3030.0,2965.0,2923.0,2895.0,2826.0,2757.0,2620.0,2553.0,2500.0,2392.0,2345.0,2316.0,2298.0,2264.0,2187.0,2138.0,2164.0,2089.0,2096.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_11()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,94.0,322.0,0.0,0.0,0.0,37.0,820.0,1228.0,1501.0,1681.0,1899.0,2041.0,2077.0,2173.0,1974.0,2024.0,2166.0,1885.0,1687.0,1524.0,1388.0,1282.0,1243.0,1221.0,1243.0,1282.0,1311.0,1372.0,1408.0,1435.0,1443.0,1448.0,1427.0,1019.0,729.0,535.0,875.0,717.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,59.0,598.0,1224.0,1404.0,1510.0,1551.0,1667.0,1795.0,1836.0,1945.0,2105.0,2227.0,2285.0,2352.0,2464.0,2553.0,2696.0,2865.0,2933.0,2959.0,3011.0,3173.0,3238.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_12()
		{
			double[] value = {3298.0,3346.0,3383.0,3471.0,3538.0,3584.0,3618.0,3696.0,3718.0,3747.0,3793.0,3800.0,3700.0,3622.0,3562.0,3515.0,3453.0,3374.0,3254.0,3099.0,3007.0,2933.0,2883.0,2840.0,2810.0,2800.0,2857.0,2925.0,2990.0,3056.0,3144.0,3277.0,3427.0,3533.0,3615.0,3682.0,3714.0,3722.0,3697.0,3628.0,3580.0,3540.0,3493.0,3434.0,3377.0,3310.0,3263.0,3211.0,3180.0,3141.0,3101.0,3068.0,3020.0,2951.0,2864.0,2774.0,2706.0,2660.0,2612.0,2583.0,2534.0,2509.0,2504.0,2504.0,2417.0,2408.0,2299.0,2020.0,1341.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,42.0,692.0,943.0,761.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_13()
		{
			double[] value = {791.0,1016.0,993.0,972.0,1051.0,915.0,954.0,345.0,0.0,0.0,0.0,0.0,0.0,0.0,246.0,799.0,820.0,839.0,994.0,1232.0,1308.0,1083.0,926.0,825.0,514.0,686.0,1244.0,1232.0,1527.0,1707.0,613.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,382.0,897.0,1300.0,2126.0,2419.0,2560.0,2714.0,2820.0,2892.0,2933.0,2940.0,3065.0,3224.0,3297.0,3408.0,3446.0,3484.0,3511.0,3530.0,3568.0,3586.0,3570.0,3562.0,3456.0,3430.0,3447.0,3474.0,3509.0,3520.0,3510.0,3500.0,3392.0,3282.0,3145.0,2998.0,2697.0,2437.0,2238.0,2090.0,1915.0,1799.0,1858.0,2030.0,2328.0,2541.0,2727.0,3011.0,3229.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_14()
		{
			double[] value = {3359.0,3398.0,3496.0,3625.0,3665.0,3632.0,3584.0,3522.0,3480.0,3390.0,3288.0,3196.0,3151.0,3109.0,3111.0,3182.0,3201.0,3205.0,3226.0,3243.0,3211.0,3098.0,2989.0,2918.0,2834.0,2767.0,2700.0,2642.0,2581.0,2516.0,2499.0,2444.0,2301.0,1966.0,1690.0,1391.0,818.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,297.0,0.0,0.0,0.0,0.0,0.0,5.0,0.0,0.0,0.0,0.0,0.0,0.0,319.0,0.0,0.0,0.0,577.0,1443.0,1248.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_15()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,39.0,469.0,1220.0,1600.0,2018.0,1567.0,1763.0,2344.0,2713.0,3034.0,3086.0,3097.0,3016.0,2993.0,2961.0,2892.0,2668.0,2776.0,3135.0,3045.0,2431.0,2393.0,2599.0,2779.0,2898.0,2940.0,2976.0,2968.0,2987.0,3087.0,3121.0,3095.0,2927.0,2746.0,2529.0,2000.0,1546.0,714.0,107.0,1193.0,1395.0,1694.0,2135.0,2559.0,2760.0,3011.0,3163.0,3246.0,3367.0,3477.0,3449.0,3399.0,3383.0,3338.0,3249.0,3114.0,2992.0,2918.0,2899.0,2917.0,2957.0,2997.0,3022.0,3050.0,3096.0,3144.0,3190.0,3161.0,3046.0,2956.0,2822.0,2650.0,2622.0,2525.0,2375.0,2317.0,2334.0,2371.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_16()
		{
			double[] value = {2309.0,2292.0,2300.0,2308.0,1847.0,1874.0,2476.0,1337.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,861.0,773.0,2023.0,1162.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,240.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_17()
		{
			double[] value = {398.0,495.0,162.0,343.0,540.0,462.0,0.0,12.0,0.0,0.0,462.0,900.0,1177.0,1582.0,1665.0,1419.0,1855.0,2162.0,2452.0,2465.0,2662.0,2750.0,2913.0,2855.0,2700.0,2437.0,2086.0,1709.0,1056.0,0.0,0.0,1341.0,1765.0,2069.0,2373.0,2578.0,2692.0,2751.0,2782.0,2847.0,2960.0,2935.0,2868.0,2804.0,2781.0,2726.0,2644.0,2598.0,2619.0,2648.0,2545.0,2516.0,2542.0,2620.0,2698.0,2770.0,2801.0,2769.0,2755.0,2723.0,2614.0,2578.0,2425.0,2244.0,2089.0,1969.0,1860.0,1746.0,1711.0,1753.0,1827.0,1868.0,344.0,441.0,1169.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_18()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,56.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,50.0,0.0,0.0,0.0,1003.0,1388.0,1508.0,1348.0,1734.0,2238.0,2013.0,2065.0,2027.0,1826.0,1685.0,1298.0,1091.0,125.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_19()
		{
			double[] value = {0.0,0.0,1257.0,1497.0,1723.0,1849.0,1848.0,2057.0,2153.0,2277.0,2267.0,2156.0,2164.0,2298.0,2236.0,2156.0,2003.0,1782.0,1686.0,1658.0,1641.0,1798.0,2005.0,2094.0,2047.0,1952.0,2054.0,2335.0,2341.0,2328.0,2022.0,1527.0,1226.0,466.0,626.0,629.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_20()
		{
			double[] value = {0.0,0.0,2045.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,256.0,1133.0,1450.0,298.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,20.0,10.0,0.0,937.0,983.0,1056.0,0.0,0.0,1175.0,106.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,869.0,799.0,574.0,416.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_21()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,254.0,1544.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_22()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_23()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_24()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_25()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_26()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_27()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_28()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_29()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_30()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,303.0,211.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_31()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,295.0,152.0,0.0,0.0,0.0,0.0,0.0,18.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_32()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_33()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2290.0,513.0,134.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_34()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,59.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_35()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1225.0,285.0,930.0,173.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_36()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,914.0,382.0,59.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_37()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,273.0,856.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_38()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1221.0,847.0,79.0,9.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_39()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,565.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,620.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_40()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,253.0,1493.0,912.0,702.0,0.0,27.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_41()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,47.0,1650.0,555.0,292.0,152.0,27.0,25.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_42()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,713.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_43()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2003.0,1286.0,283.0,212.0,108.0,129.0,35.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_44()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,13.0,128.0,178.0,293.0,627.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_45()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,313.0,1520.0,401.0,236.0,99.0,60.0,0.0,19.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_46()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,239.0,34.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,151.0,1.0,83.0,69.0,69.0,152.0,343.0,331.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,419.0,2757.0,612.0,1207.0,121.0,28.0,23.0,161.0,108.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_47()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,125.0,1691.0,867.0,894.0,1410.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,304.0,310.0,414.0,281.0,98.0,0.0,0.0,0.0,0.0,282.0,137.0,443.0,71.0,160.0,278.0,277.0,153.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_48()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,894.0,2080.0,542.0,230.0,76.0,41.0,54.0,152.0,92.0,128.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,993.0,929.0,1125.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_49()
		{
			double[] value = {1261.0,1531.0,1427.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,298.0,489.0,511.0,440.0,227.0,234.0,154.0,239.0,201.0,173.0,305.0,6.0,215.0,90.0,185.0,156.0,585.0,570.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_50()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4778.0,841.0,449.0,110.0,51.0,71.0,66.0,399.0,630.0,1245.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,405.0,914.0,753.0,1313.0,1187.0,1335.0,1671.0,752.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_51()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,90.0,361.0,562.0,518.0,427.0,427.0,381.0,464.0,435.0,282.0,108.0,68.0,39.0,69.0,155.0,172.0,196.0,287.0,289.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,3490.0,5367.0,939.0,188.0,104.0,59.0,147.0,276.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_52()
		{
			double[] value = {677.0,824.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1331.0,1029.0,959.0,971.0,1146.0,1614.0,1572.0,1048.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,43.0,395.0,555.0,559.0,486.0,493.0,616.0,932.0,700.0,448.0,168.0,78.0,72.0,113.0,273.0,341.0,504.0,342.0,104.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_53()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2639.0,4181.0,396.0,192.0,110.0,66.0,184.0,219.0,302.0,612.0,901.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_54()
		{
			double[] value = {1351.0,1258.0,1196.0,1111.0,1088.0,863.0,1374.0,404.0,54.0,0.0,0.0,0.0,0.0,143.0,1132.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,163.0,346.0,484.0,520.0,380.0,400.0,459.0,525.0,812.0,623.0,298.0,132.0,116.0,160.0,227.0,373.0,178.0,214.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_55()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2855.0,4108.0,2083.0,274.0,142.0,77.0,392.0,288.0,317.0,446.0,589.0,914.0,792.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,110.0,1320.0,1612.0,1280.0,1030.0,969.0,985.0,655.0,426.0,147.0,4.0,0.0,0.0,0.0,200.0,723.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_56()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,261.0,253.0,334.0,308.0,348.0,495.0,440.0,617.0,496.0,339.0,221.0,298.0,200.0,276.0,306.0,300.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4263.0,3828.0,2490.0,475.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_57()
		{
			double[] value = {176.0,91.0,87.0,498.0,513.0,500.0,917.0,741.0,742.0,325.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1110.0,1224.0,1260.0,1155.0,953.0,978.0,979.0,1304.0,1342.0,476.0,0.0,0.0,0.0,0.0,0.0,914.0,455.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,193.0,228.0,305.0,485.0,283.0,327.0,233.0,253.0,201.0,198.0,928.0,356.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_58()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,549.0,4016.0,4256.0,1245.0,243.0,298.0,156.0,121.0,612.0,800.0,609.0,921.0,614.0,773.0,311.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_59()
		{
			double[] value = {0.0,0.0,460.0,1016.0,1109.0,1140.0,1104.0,996.0,919.0,1202.0,850.0,1272.0,816.0,336.0,7.0,0.0,0.0,9.0,299.0,912.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,133.0,271.0,641.0,290.0,198.0,249.0,235.0,264.0,0.0,79.0,380.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_60()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2380.0,4562.0,3977.0,1144.0,163.0,260.0,202.0,300.0,149.0,564.0,324.0,589.0,971.0,787.0,544.0,710.0,49.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1346.0,1370.0,1324.0,1166.0,1059.0,1144.0,1021.0,1061.0,724.0,507.0,696.0,678.0,597.0,0.0,0.0,0.0,304.0,270.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_61()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,421.0,108.0,239.0,148.0,75.0,0.0,0.0,23.0,74.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4277.0,3058.0,1972.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_62()
		{
			double[] value = {467.0,193.0,139.0,203.0,476.0,491.0,357.0,302.0,359.0,460.0,416.0,767.0,425.0,1216.0,187.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,824.0,1580.0,1358.0,1303.0,1052.0,1125.0,1182.0,1275.0,612.0,1197.0,1153.0,609.0,323.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,167.0,311.0,28.0,0.0,0.0,43.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_63()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,41.0,1061.0,478.0,425.0,298.0,165.0,291.0,219.0,200.0,198.0,362.0,264.0,306.0,213.0,629.0,589.0,426.0,645.0,285.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_64()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,205.0,1639.0,1270.0,1136.0,1138.0,1296.0,1149.0,1271.0,1233.0,1209.0,1070.0,505.0,152.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_65()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,4575.0,516.0,219.0,199.0,203.0,100.0,97.0,100.0,97.0,200.0,200.0,397.0,305.0,166.0,316.0,456.0,560.0,463.0,353.0,391.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,147.0,1120.0,1073.0,934.0,1084.0,1129.0,1388.0,967.0,1545.0,1344.0,973.0,461.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_66()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,465.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,151.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_67()
		{
			double[] value = {2007.0,384.0,189.0,196.0,100.0,81.0,89.0,62.0,60.0,100.0,217.0,200.0,152.0,361.0,227.0,401.0,195.0,340.0,568.0,184.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,445.0,861.0,1022.0,742.0,714.0,801.0,601.0,1234.0,1101.0,1225.0,912.0,581.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,10.0,407.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_68()
		{
			double[] value = {0.0,0.0,1.0,127.0,1032.0,301.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2192.0,320.0,142.0,109.0,99.0,87.0,65.0,72.0,41.0,46.0,99.0,91.0,102.0,192.0,150.0,228.0,179.0,60.0,305.0,220.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_69()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,48.0,411.0,555.0,476.0,609.0,533.0,588.0,876.0,1488.0,1121.0,1229.0,1566.0,771.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,520.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,146.0,0.0,0.0,0.0,0.0,0.0,0.0,172.0,3312.0,368.0,34.0,0.0,0.0,0.0,304.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_70()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,417.0,176.0,121.0,100.0,97.0,60.0,45.0,34.0,88.0,75.0,109.0,21.0,14.0,3.0,55.0,62.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,533.0,679.0,228.0,339.0,426.0,455.0,606.0,724.0,1573.0,1304.0,1153.0,1595.0,1151.0,110.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_71()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1043.0,62.0,0.0,0.0,0.0,106.0,38.0,0.0,0.0,141.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,640.0,151.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_72()
		{
			double[] value = {0.0,0.0,0.0,217.0,1988.0,205.0,153.0,198.0,92.0,57.0,57.0,56.0,100.0,200.0,302.0,294.0,195.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,143.0,520.0,564.0,314.0,492.0,409.0,447.0,457.0,712.0,2134.0,1362.0,1133.0,2438.0,1487.0,169.0,13.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,105.0,0.0,0.0,0.0,318.0,106.0,614.0,81.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_73()
		{
			double[] value = {437.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1273.0,610.0,251.0,199.0,152.0,86.0,400.0,585.0,95.0,504.0,301.0,219.0,141.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_74()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,740.0,520.0,507.0,356.0,381.0,416.0,430.0,457.0,448.0,914.0,618.0,1052.0,1309.0,526.0,268.0,278.0,63.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,913.0,2.0,23.0,0.0,0.0,0.0,549.0,879.0,864.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_75()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2105.0,266.0,151.0,91.0,224.0,1005.0,310.0,174.0,73.0,192.0,156.0,85.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,715.0,610.0,487.0,423.0,456.0,476.0,605.0,625.0,707.0,930.0,847.0,731.0,716.0,976.0,243.0,551.0,177.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_76()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1539.0,0.0,1234.0,0.0,0.0,0.0,0.0,0.0,91.0,337.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_77()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2189.0,1916.0,133.0,103.0,1003.0,800.0,939.0,683.0,50.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,152.0,255.0,78.0,154.0,158.0,0.0,0.0,32.0,122.0,1492.0,913.0,927.0,914.0,470.0,479.0,609.0,608.0,612.0,533.0,427.0,427.0,989.0,1198.0,1145.0,808.0,544.0,298.0,185.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,165.0,0.0,0.0,0.0,0.0,0.0,0.0,2099.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_78()
		{
			double[] value = {0.0,0.0,0.0,200.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,51.0,90.0,1823.0,1175.0,73.0,44.0,143.0,51.0,37.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_79()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,305.0,583.0,375.0,304.0,608.0,96.0,234.0,305.0,263.0,227.0,127.0,627.0,439.0,549.0,376.0,464.0,855.0,893.0,570.0,393.0,395.0,323.0,1738.0,1085.0,2536.0,933.0,1212.0,725.0,751.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,70.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,367.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,148.0,857.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_80()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,352.0,0.0,0.0,0.0,66.0,112.0,99.0,845.0,609.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,131.0,593.0,369.0,434.0,305.0,283.0,149.0,466.0,433.0,236.0,721.0,594.0,602.0,450.0,330.0,364.0,396.0,491.0,493.0,450.0,397.0,422.0,426.0,770.0,2213.0,3266.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_81()
		{
			double[] value = {660.0,263.0,963.0,1152.0,222.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,357.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,22.0,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_82()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,64.0,39.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,49.0,114.0,248.0,301.0,359.0,309.0,238.0,304.0,299.0,212.0,290.0,601.0,360.0,309.0,276.0,293.0,506.0,449.0,605.0,837.0,488.0,590.0,558.0,439.0,523.0,2082.0,1720.0,627.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,880.0,582.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,711.0,0.0,29.0,92.0,600.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_83()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,47.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1719.0,1201.0,621.0,90.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_84()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,29.0,61.0,58.0,278.0,306.0,276.0,263.0,290.0,303.0,250.0,367.0,405.0,572.0,337.0,310.0,304.0,310.0,439.0,877.0,1200.0,656.0,564.0,421.0,404.0,518.0,1078.0,1560.0,0.0,2003.0,1100.0,604.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,608.0,250.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,116.0,528.0,189.0,90.0,643.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_85()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,116.0,1574.0,553.0,2440.0,164.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,32.0,68.0,134.0,183.0,311.0,327.0,248.0,337.0,363.0,356.0,391.0,455.0,517.0,436.0,357.0,256.0,231.0,414.0,1039.0,652.0,607.0,460.0,536.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_86()
		{
			double[] value = {373.0,373.0,499.0,0.0,0.0,1596.0,948.0,1002.0,939.0,923.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,765.0,579.0,525.0,31.0,0.0,0.0,0.0,0.0,0.0,0.0,10.0,0.0,102.0,860.0,207.0,288.0,0.0,0.0,0.0,0.0,0.0,0.0,1517.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_87()
		{
			double[] value = {0.0,0.0,0.0,0.0,1609.0,444.0,1345.0,468.0,0.0,0.0,102.0,19.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,402.0,110.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,10.0,84.0,439.0,380.0,356.0,333.0,264.0,466.0,468.0,405.0,454.0,455.0,644.0,561.0,360.0,418.0,361.0,473.0,649.0,581.0,633.0,381.0,310.0,366.0,508.0,0.0,0.0,372.0,1439.0,762.0,474.0,254.0,269.0,208.0,27.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,611.0,703.0,374.0,128.0,579.0,38.0,0.0,0.0,0.0,0.0,13.0,156.0,490.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_88()
		{
			double[] value = {697.0,331.0,0.0,0.0,317.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,236.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,45.0,1874.0,2098.0,2200.0,0.0,0.0,0.0,0.0,33.0,0.0,0.0,0.0,0.0,50.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_89()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,152.0,145.0,441.0,282.0,299.0,206.0,324.0,363.0,432.0,608.0,547.0,571.0,612.0,559.0,419.0,1135.0,1852.0,573.0,603.0,659.0,462.0,354.0,316.0,329.0,515.0,0.0,117.0,1393.0,778.0,652.0,333.0,208.0,152.0,62.0,143.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,512.0,293.0,296.0,321.0,344.0,157.0,1.0,0.0,0.0,66.0,579.0,1483.0,1103.0,1336.0,893.0,22.0,0.0,7.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_90()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1417.0,2142.0,1879.0,119.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,87.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,156.0,305.0,314.0,247.0,296.0,271.0,214.0,363.0,407.0,551.0,1945.0,1240.0,905.0,820.0,633.0,653.0,574.0,475.0,434.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_91()
		{
			double[] value = {678.0,487.0,232.0,161.0,338.0,58.0,0.0,556.0,920.0,914.0,609.0,342.0,128.0,106.0,136.0,505.0,319.0,0.0,0.0,0.0,0.0,130.0,16.0,201.0,526.0,394.0,559.0,425.0,621.0,154.0,9.0,3.0,1335.0,210.0,796.0,1321.0,1806.0,681.0,860.0,85.0,156.0,188.0,23.0,17.0,0.0,1874.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_92()
		{
			double[] value = {0.0,0.0,0.0,0.0,47.0,0.0,191.0,1989.0,1562.0,1997.0,153.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,202.0,369.0,327.0,420.0,304.0,303.0,317.0,302.0,473.0,901.0,1249.0,888.0,820.0,573.0,608.0,363.0,325.0,301.0,304.0,304.0,216.0,404.0,340.0,0.0,497.0,1057.0,847.0,814.0,840.0,387.0,88.0,0.0,0.0,0.0,0.0,18.0,0.0,0.0,240.0,2.0,44.0,590.0,253.0,399.0,136.0,77.0,66.0,32.0,26.0,258.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_93()
		{
			double[] value = {432.0,132.0,166.0,1804.0,1881.0,2133.0,496.0,775.0,156.0,913.0,142.0,507.0,506.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,72.0,0.0,105.0,2006.0,1522.0,1090.0,342.0,274.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,21.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_94()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,205.0,474.0,322.0,410.0,452.0,261.0,388.0,388.0,464.0,496.0,558.0,520.0,368.0,579.0,308.0,182.0,122.0,166.0,175.0,251.0,92.0,340.0,0.0,1182.0,941.0,994.0,645.0,410.0,101.0,0.0,0.0,444.0,16.0,357.0,1241.0,1223.0,1331.0,59.0,61.0,192.0,294.0,467.0,174.0,140.0,97.0,131.0,1123.0,3641.0,2507.0,921.0,110.0,596.0,3569.0,3747.0,1926.0,2073.0,1031.0,172.0,399.0,478.0,89.0,243.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_95()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,202.0,500.0,1907.0,1484.0,1030.0,323.0,298.0,60.0,1.0,0.0,1.0,0.0,0.0,0.0,46.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1241.0,373.0,597.0,523.0,400.0,359.0,328.0,304.0,385.0,560.0,644.0,453.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_96()
		{
			double[] value = {558.0,309.0,41.0,100.0,6.0,-84.0,208.0,29.0,673.0,1368.0,803.0,685.0,582.0,433.0,277.0,0.0,0.0,1473.0,2354.0,3088.0,468.0,1569.0,1176.0,869.0,343.0,688.0,109.0,171.0,215.0,222.0,878.0,4632.0,4548.0,4565.0,4629.0,3598.0,5201.0,4039.0,4052.0,3739.0,4100.0,402.0,373.0,436.0,529.0,30.0,182.0,40.0,49.0,46.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_97()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,1099.0,2.0,809.0,1324.0,1199.0,1273.0,822.0,790.0,462.0,166.0,92.0,61.0,144.0,28.0,143.0,74.0,19.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,512.0,1052.0,1042.0,813.0,760.0,518.0,537.0,152.0,160.0,316.0,589.0,214.0,0.0,0.0,199.0,161.0,204.0,0.0,0.0,0.0,0.0,-405.0,698.0,805.0,394.0,141.0,8.0,47.0,1056.0,1710.0,1359.0,1230.0,1069.0,614.0,756.0,983.0,1964.0,1375.0,169.0,203.0,438.0,4504.0,5130.0,5215.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_98()
		{
			double[] value = {4869.0,5001.0,4536.0,4641.0,4788.0,4163.0,4965.0,4780.0,4673.0,2166.0,472.0,1152.0,1373.0,68.0,148.0,75.0,4.0,5.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,853.0,346.0,628.0,2499.0,2316.0,1767.0,1250.0,920.0,362.0,200.0,102.0,76.0,39.0,106.0,176.0,279.0,195.0,24.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_99()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,95.0,1343.0,1306.0,1084.0,1400.0,693.0,167.0,23.0,105.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,274.0,796.0,653.0,366.0,35.0,1344.0,1915.0,1763.0,1031.0,872.0,679.0,1866.0,792.0,2290.0,2307.0,3269.0,2616.0,909.0,1562.0,4633.0,5306.0,4397.0,5879.0,4795.0,4849.0,5100.0,4992.0,4767.0,4963.0,4470.0,4274.0,3575.0,3773.0,1189.0,2025.0,717.0,1278.0,45.0,26.0,14.0,0.0,0.0,0.0,0.0,0.0,0.0,400.0,650.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_100()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,614.0,1827.0,835.0,1627.0,2143.0,1833.0,2082.0,2343.0,1363.0,833.0,597.0,304.0,335.0,494.0,70.0,156.0,244.0,285.0,503.0,235.0,30.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,448.0,945.0,910.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_101()
		{
			double[] value = {744.0,139.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,316.0,275.0,296.0,340.0,2381.0,1638.0,1121.0,2705.0,1027.0,1010.0,1305.0,1154.0,518.0,1383.0,2118.0,2407.0,2648.0,4322.0,4973.0,4832.0,5256.0,4815.0,5112.0,4867.0,4935.0,4960.0,5092.0,4337.0,3864.0,3960.0,2876.0,2578.0,1923.0,1239.0,1365.0,993.0,66.0,41.0,189.0,0.0,0.0,0.0,74.0,381.0,0.0,0.0,0.0,1300.0,20.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_102()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,943.0,1639.0,1481.0,2044.0,2986.0,1709.0,3002.0,2628.0,1219.0,899.0,612.0,438.0,243.0,243.0,254.0,122.0,139.0,284.0,436.0,556.0,91.0,6.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,312.0,400.0,1272.0,38.0,0.0,0.0,0.0,0.0,0.0,0.0,370.0,0.0,0.0,0.0,288.0,0.0,0.0,387.0,2019.0,1053.0,1487.0,1569.0,827.0,581.0,2132.0,1510.0,1454.0,-28.0,-28.0,59.0,1100.0,127.0,145.0,190.0,252.0,578.0,832.0,2985.0,4115.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_103()
		{
			double[] value = {2929.0,1267.0,1214.0,1247.0,1252.0,3274.0,3839.0,2848.0,2668.0,3878.0,4832.0,3874.0,2986.0,1485.0,1262.0,1349.0,1107.0,1378.0,69.0,14.0,2.0,0.0,0.0,0.0,119.0,0.0,0.0,0.0,0.0,0.0,300.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,183.0,1218.0,1371.0,1805.0,1902.0,1378.0,1427.0,2675.0,2138.0,1406.0,853.0,609.0,411.0,328.0,276.0,184.0,232.0,281.0,365.0,273.0,342.0,184.0,44.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_104()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,418.0,444.0,841.0,927.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,323.0,62.0,485.0,0.0,0.0,199.0,1056.0,1020.0,1332.0,1010.0,1501.0,1742.0,2212.0,877.0,2068.0,-9.0,-28.0,-28.0,164.0,48.0,138.0,175.0,169.0,338.0,744.0,496.0,1071.0,3538.0,2342.0,1386.0,1035.0,985.0,946.0,916.0,808.0,791.0,842.0,1397.0,1575.0,1190.0,1200.0,1586.0,1036.0,1278.0,1211.0,1404.0,843.0,18.0,98.0,0.0,315.0,484.0,851.0,0.0,0.0,0.0,0.0,0.0,7.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_105()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1463.0,2092.0,1638.0,1768.0,1393.0,1648.0,2042.0,2027.0,2292.0,1313.0,1006.0,667.0,442.0,366.0,304.0,180.0,241.0,206.0,274.0,175.0,198.0,365.0,313.0,270.0,24.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,892.0,770.0,1032.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_106()
		{
			double[] value = {568.0,848.0,0.0,0.0,0.0,0.0,235.0,201.0,0.0,0.0,362.0,556.0,173.0,117.0,0.0,0.0,0.0,0.0,0.0,0.0,13.0,1347.0,3422.0,-28.0,-28.0,6.0,164.0,45.0,52.0,101.0,160.0,260.0,230.0,523.0,2431.0,2291.0,2131.0,2308.0,5436.0,2132.0,2864.0,1051.0,1453.0,941.0,450.0,1224.0,1577.0,1123.0,972.0,1244.0,1081.0,1173.0,1160.0,1257.0,1402.0,1226.0,795.0,383.0,54.0,319.0,581.0,1015.0,0.0,0.0,0.0,0.0,300.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_107()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,559.0,1441.0,1278.0,1456.0,2499.0,1981.0,2714.0,2621.0,1401.0,872.0,640.0,537.0,515.0,255.0,335.0,303.0,218.0,268.0,275.0,176.0,279.0,183.0,122.0,29.0,244.0,65.0,0.0,89.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,42.0,303.0,1079.0,960.0,409.0,360.0,11.0,0.0,985.0,682.0,244.0,84.0,164.0,32.0,0.0,0.0,0.0,0.0,0.0,254.0,481.0,207.0,-16.0,-28.0,66.0,-8.0,125.0,168.0,40.0,59.0,102.0,131.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_108()
		{
			double[] value = {433.0,356.0,314.0,561.0,453.0,933.0,1784.0,807.0,525.0,430.0,547.0,955.0,894.0,1244.0,1792.0,2090.0,1240.0,1061.0,1270.0,1348.0,696.0,1126.0,1084.0,1062.0,1223.0,373.0,152.0,203.0,281.0,407.0,146.0,152.0,33.0,0.0,0.0,496.0,0.0,100.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,473.0,426.0,304.0,1008.0,1768.0,1304.0,1306.0,913.0,721.0,854.0,670.0,550.0,283.0,427.0,344.0,287.0,525.0,276.0,266.0,321.0,292.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_109()
		{
			double[] value = {365.0,286.0,380.0,160.0,365.0,373.0,29.0,0.0,374.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,100.0,146.0,255.0,511.0,1977.0,1709.0,2462.0,485.0,165.0,226.0,88.0,942.0,345.0,147.0,174.0,0.0,31.0,17.0,0.0,47.0,22.0,123.0,1.0,-20.0,-28.0,-28.0,-8.0,11.0,132.0,107.0,95.0,146.0,230.0,335.0,501.0,399.0,325.0,325.0,405.0,662.0,1907.0,777.0,798.0,2281.0,2072.0,1322.0,1822.0,2290.0,2448.0,1936.0,1530.0,1265.0,1256.0,1119.0,1048.0,767.0,979.0,985.0,181.0,139.0,171.0,402.0,136.0,102.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_110()
		{
			double[] value = {340.0,616.0,0.0,170.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,761.0,110.0,1280.0,502.0,853.0,2012.0,1066.0,792.0,823.0,762.0,673.0,457.0,487.0,266.0,338.0,372.0,460.0,355.0,275.0,429.0,301.0,265.0,295.0,404.0,590.0,175.0,0.0,309.0,304.0,0.0,0.0,303.0,161.0,152.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_111()
		{
			double[] value = {0.0,0.0,0.0,64.0,281.0,126.0,167.0,252.0,136.0,645.0,479.0,771.0,193.0,275.0,380.0,266.0,370.0,292.0,211.0,168.0,168.0,69.0,117.0,52.0,146.0,50.0,29.0,13.0,-23.0,1.0,111.0,222.0,350.0,102.0,112.0,256.0,494.0,423.0,488.0,781.0,1051.0,885.0,678.0,561.0,829.0,1286.0,2529.0,2829.0,1060.0,1820.0,1971.0,1664.0,1593.0,1033.0,921.0,2302.0,1106.0,1098.0,664.0,646.0,718.0,966.0,401.0,238.0,363.0,494.0,265.0,48.0,74.0,842.0,321.0,158.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_112()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,106.0,1515.0,687.0,922.0,1205.0,1163.0,1034.0,714.0,676.0,711.0,556.0,578.0,606.0,268.0,216.0,395.0,419.0,381.0,316.0,203.0,127.0,79.0,82.0,232.0,318.0,421.0,449.0,540.0,582.0,609.0,298.0,153.0,0.0,81.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,151.0,16.0,0.0,21.0,96.0,232.0,421.0,310.0,456.0,432.0,260.0,227.0,268.0,225.0,182.0,159.0,103.0,188.0,212.0,146.0,173.0,128.0,157.0,44.0,61.0,27.0,80.0,106.0,246.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_113()
		{
			double[] value = {225.0,306.0,220.0,161.0,321.0,332.0,415.0,374.0,346.0,187.0,342.0,566.0,1986.0,1202.0,1928.0,2340.0,1537.0,1419.0,1746.0,1698.0,1464.0,1317.0,722.0,860.0,1139.0,1354.0,819.0,779.0,767.0,696.0,640.0,591.0,130.0,216.0,728.0,1210.0,588.0,47.0,680.0,275.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,609.0,1638.0,1444.0,728.0,2182.0,1459.0,1185.0,888.0,713.0,701.0,700.0,514.0,536.0,280.0,259.0,249.0,306.0,305.0,301.0,202.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_114()
		{
			double[] value = {153.0,73.0,0.0,0.0,117.0,300.0,467.0,529.0,624.0,603.0,545.0,612.0,305.0,306.0,78.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,47.0,152.0,0.0,76.0,53.0,0.0,0.0,-1.0,23.0,72.0,33.0,4.0,59.0,86.0,127.0,164.0,175.0,141.0,132.0,148.0,158.0,202.0,220.0,140.0,146.0,238.0,217.0,285.0,145.0,152.0,245.0,403.0,313.0,252.0,161.0,228.0,338.0,374.0,218.0,117.0,97.0,139.0,137.0,266.0,250.0,263.0,651.0,808.0,1045.0,1048.0,1519.0,2259.0,1041.0,512.0,910.0,451.0,1708.0,980.0,1192.0,813.0,760.0,628.0,630.0,341.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_115()
		{
			double[] value = {315.0,398.0,589.0,633.0,634.0,200.0,29.0,32.0,0.0,0.0,0.0,0.0,0.0,0.0,120.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,103.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,243.0,487.0,623.0,912.0,1219.0,1250.0,975.0,637.0,754.0,627.0,618.0,594.0,476.0,389.0,366.0,307.0,252.0,226.0,175.0,146.0,126.0,67.0,65.0,14.0,0.0,0.0,152.0,292.0,426.0,478.0,476.0,533.0,512.0,293.0,79.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_116()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,63.0,0.0,0.0,0.0,0.0,0.0,0.0,42.0,0.0,0.0,0.0,0.0,37.0,141.0,160.0,129.0,201.0,206.0,229.0,141.0,119.0,132.0,203.0,134.0,73.0,146.0,228.0,136.0,137.0,530.0,270.0,179.0,155.0,130.0,128.0,112.0,103.0,108.0,113.0,147.0,124.0,201.0,145.0,955.0,442.0,727.0,510.0,684.0,381.0,565.0,562.0,619.0,761.0,973.0,1283.0,1419.0,923.0,1076.0,618.0,1122.0,532.0,460.0,432.0,909.0,808.0,0.0,260.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,407.0,210.0,746.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_117()
		{
			double[] value = {0.0,0.0,0.0,563.0,155.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,762.0,782.0,1378.0,1583.0,1713.0,1787.0,999.0,773.0,727.0,634.0,685.0,300.0,521.0,483.0,489.0,338.0,342.0,271.0,212.0,189.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,211.0,305.0,176.0,305.0,273.0,500.0,547.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,619.0,257.0,0.0,0.0,0.0,0.0,0.0,4.0,0.0,175.0,49.0,20.0,0.0,154.0,84.0,117.0,73.0,62.0,232.0,173.0,131.0,109.0,150.0,136.0,154.0,176.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_118()
		{
			double[] value = {77.0,162.0,96.0,173.0,333.0,244.0,130.0,74.0,65.0,91.0,68.0,53.0,133.0,134.0,135.0,119.0,68.0,125.0,183.0,217.0,244.0,285.0,302.0,428.0,458.0,386.0,640.0,666.0,865.0,655.0,1292.0,803.0,1818.0,1067.0,1072.0,931.0,906.0,1102.0,1082.0,606.0,744.0,876.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,206.0,268.0,161.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,365.0,129.0,53.0,243.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1110.0,310.0,1297.0,1149.0,1872.0,1285.0,596.0,492.0,448.0,440.0,764.0,304.0,264.0,210.0,210.0,304.0,414.0,492.0,305.0,172.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_119()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,9.0,116.0,158.0,233.0,0.0,0.0,79.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,16.0,885.0,220.0,146.0,68.0,24.0,31.0,0.0,0.0,56.0,55.0,98.0,27.0,71.0,146.0,184.0,153.0,121.0,152.0,190.0,175.0,178.0,200.0,201.0,168.0,490.0,69.0,72.0,94.0,46.0,84.0,89.0,57.0,92.0,69.0,33.0,96.0,125.0,135.0,118.0,127.0,477.0,563.0,368.0,271.0,351.0,352.0,655.0,458.0,487.0,294.0,1309.0,953.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_120()
		{
			double[] value = {441.0,496.0,564.0,445.0,497.0,455.0,208.0,418.0,438.0,802.0,693.0,367.0,0.0,0.0,601.0,0.0,175.0,144.0,0.0,0.0,668.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,30.0,11.0,151.0,113.0,424.0,1349.0,29.0,1898.0,1318.0,685.0,3177.0,1221.0,1162.0,887.0,1008.0,1451.0,1234.0,686.0,1800.0,254.0,151.0,143.0,176.0,156.0,268.0,354.0,403.0,376.0,322.0,306.0,303.0,152.0,21.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,311.0,515.0,0.0,0.0,0.0,57.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1213.0,1132.0,976.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_121()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,120.0,1370.0,907.0,675.0,575.0,314.0,0.0,0.0,64.0,146.0,136.0,84.0,1.0,143.0,23.0,211.0,126.0,124.0,214.0,92.0,118.0,121.0,177.0,115.0,166.0,353.0,88.0,99.0,128.0,39.0,38.0,41.0,40.0,113.0,47.0,82.0,99.0,137.0,120.0,143.0,264.0,293.0,375.0,412.0,382.0,390.0,426.0,371.0,267.0,337.0,360.0,326.0,309.0,249.0,332.0,369.0,349.0,280.0,93.0,228.0,263.0,368.0,1320.0,981.0,1505.0,2126.0,843.0,903.0,833.0,495.0,822.0,0.0,0.0,242.0,0.0,126.0,397.0,483.0,721.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_122()
		{
			double[] value = {1.0,0.0,0.0,0.0,0.0,357.0,61.0,225.0,879.0,262.0,1219.0,888.0,706.0,490.0,678.0,727.0,560.0,1187.0,1273.0,1799.0,1896.0,924.0,319.0,294.0,390.0,265.0,283.0,315.0,464.0,540.0,361.0,305.0,320.0,236.0,158.0,82.0,134.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,148.0,198.0,593.0,318.0,0.0,0.0,0.0,0.0,0.0,0.0,1107.0,2120.0,2620.0,2563.0,4.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,17.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,240.0,600.0,390.0,257.0,276.0,0.0,15.0,143.0,120.0,96.0,183.0,157.0,153.0,92.0,95.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_123()
		{
			double[] value = {11.0,201.0,242.0,121.0,197.0,150.0,139.0,110.0,784.0,85.0,143.0,6.0,23.0,76.0,104.0,86.0,88.0,57.0,68.0,41.0,94.0,31.0,273.0,227.0,498.0,467.0,345.0,527.0,451.0,234.0,339.0,342.0,307.0,363.0,347.0,154.0,117.0,98.0,155.0,134.0,108.0,102.0,233.0,414.0,1126.0,850.0,1577.0,673.0,1707.0,935.0,1185.0,665.0,471.0,775.0,1125.0,962.0,576.0,626.0,1009.0,79.0,135.0,223.0,97.0,162.0,133.0,239.0,269.0,238.0,530.0,0.0,68.0,245.0,228.0,88.0,330.0,46.0,109.0,474.0,535.0,365.0,675.0,352.0,523.0,1295.0,535.0,314.0,483.0,522.0,34.0,296.0,200.0,432.0,156.0,156.0,440.0,342.0,555.0,528.0,317.0,276.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_124()
		{
			double[] value = {213.0,151.0,152.0,149.0,301.0,305.0,275.0,188.0,0.0,0.0,0.0,0.0,0.0,0.0,23.0,152.0,304.0,0.0,59.0,313.0,0.0,0.0,0.0,0.0,879.0,1110.0,1976.0,2556.0,2434.0,1337.0,641.0,160.0,0.0,0.0,0.0,0.0,0.0,0.0,482.0,572.0,108.0,683.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,740.0,697.0,413.0,106.0,0.0,37.0,154.0,266.0,126.0,74.0,0.0,0.0,0.0,43.0,28.0,53.0,100.0,142.0,85.0,65.0,52.0,64.0,286.0,214.0,1.0,17.0,38.0,7.0,72.0,66.0,14.0,35.0,35.0,79.0,36.0,105.0,342.0,262.0,499.0,864.0,304.0,608.0,772.0,431.0,417.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_125()
		{
			double[] value = {545.0,478.0,413.0,334.0,229.0,209.0,110.0,104.0,539.0,1197.0,624.0,858.0,612.0,959.0,1410.0,916.0,505.0,621.0,605.0,44.0,455.0,534.0,517.0,288.0,371.0,605.0,1143.0,283.0,392.0,108.0,250.0,173.0,546.0,219.0,0.0,0.0,0.0,0.0,0.0,0.0,164.0,254.0,483.0,511.0,1268.0,511.0,1300.0,676.0,856.0,802.0,490.0,276.0,887.0,1.0,218.0,178.0,158.0,269.0,257.0,387.0,548.0,234.0,173.0,0.0,0.0,0.0,121.0,61.0,24.0,0.0,0.0,28.0,75.0,216.0,189.0,0.0,122.0,421.0,0.0,0.0,0.0,34.0,0.0,196.0,365.0,251.0,0.0,0.0,0.0,0.0,0.0,0.0,21.0,558.0,1168.0,2262.0,2546.0,2778.0,2897.0,2900.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_126()
		{
			double[] value = {2119.0,644.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,517.0,1100.0,432.0,438.0,184.0,259.0,280.0,366.0,159.0,219.0,262.0,250.0,0.0,0.0,50.0,0.0,41.0,40.0,40.0,149.0,151.0,141.0,148.0,163.0,116.0,57.0,29.0,0.0,25.0,15.0,54.0,73.0,117.0,30.0,442.0,448.0,657.0,850.0,911.0,672.0,206.0,376.0,321.0,340.0,400.0,304.0,362.0,65.0,217.0,221.0,52.0,97.0,251.0,895.0,432.0,219.0,156.0,1252.0,316.0,130.0,56.0,72.0,286.0,84.0,38.0,39.0,80.0,340.0,36.0,107.0,203.0,967.0,298.0,247.0,404.0,879.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_127()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,45.0,45.0,52.0,47.0,26.0,122.0,60.0,19.0,30.0,0.0,0.0,0.0,0.0,0.0,1.0,0.0,0.0,37.0,0.0,0.0,0.0,227.0,295.0,183.0,110.0,113.0,152.0,57.0,18.0,0.0,0.0,243.0,18.0,0.0,0.0,0.0,98.0,0.0,45.0,72.0,312.0,1098.0,715.0,466.0,0.0,0.0,0.0,0.0,0.0,0.0,282.0,0.0,657.0,1718.0,2323.0,2566.0,2778.0,2999.0,3070.0,3048.0,2883.0,2015.0,940.0,1613.0,1250.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,520.0,296.0,300.0,188.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_128()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,12.0,0.0,0.0,0.0,10.0,27.0,15.0,21.0,51.0,46.0,74.0,5.0,60.0,69.0,148.0,814.0,1131.0,393.0,507.0,441.0,327.0,277.0,707.0,584.0,504.0,152.0,165.0,137.0,220.0,224.0,133.0,54.0,389.0,851.0,247.0,119.0,71.0,193.0,529.0,94.0,33.0,27.0,187.0,70.0,181.0,7.0,26.0,13.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,151.0,213.0,175.0,251.0,198.0,159.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_129()
		{
			double[] value = {275.0,304.0,81.0,46.0,0.0,0.0,101.0,152.0,313.0,0.0,0.0,274.0,0.0,228.0,152.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,575.0,1857.0,2033.0,2357.0,2590.0,2752.0,2926.0,3054.0,3118.0,3004.0,2628.0,2215.0,1799.0,1577.0,715.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,311.0,0.0,0.0,0.0,0.0,0.0,0.0,23.0,28.0,0.0,0.0,11.0,5.0,0.0,52.0,62.0,18.0,99.0,13.0,122.0,51.0,42.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_130()
		{
			double[] value = {71.0,34.0,155.0,365.0,134.0,116.0,115.0,78.0,49.0,65.0,62.0,248.0,214.0,1.0,0.0,0.0,0.0,0.0,15.0,18.0,13.0,1.0,2.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,1.0,179.0,29.0,62.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,22.0,1243.0,1906.0,2155.0,2439.0,2789.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_131()
		{
			double[] value = {2896.0,2919.0,2917.0,2846.0,2675.0,2404.0,2247.0,1977.0,1229.0,951.0,612.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,642.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,21.0,131.0,158.0,232.0,321.0,225.0,17.0,79.0,48.0,119.0,133.0,0.0,65.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_132()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,77.0,0.0,0.0,0.0,0.0,62.0,0.0,0.0,94.0,0.0,19.0,0.0,100.0,131.0,0.0,344.0,310.0,0.0,0.0,892.0,0.0,0.0,0.0,0.0,278.0,824.0,640.0,1039.0,568.0,866.0,1033.0,1487.0,1747.0,1986.0,2306.0,2437.0,2570.0,2561.0,2481.0,2472.0,2393.0,2287.0,2257.0,2142.0,2345.0,990.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_133()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,199.0,272.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,19.0,11.0,15.0,276.0,128.0,184.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_134()
		{
			double[] value = {0.0,0.0,0.0,0.0,1.0,4.0,0.0,0.0,292.0,163.0,0.0,103.0,0.0,0.0,575.0,756.0,301.0,524.0,260.0,1315.0,1501.0,450.0,0.0,68.0,382.0,743.0,926.0,1058.0,1204.0,1742.0,2094.0,2129.0,2280.0,2248.0,2286.0,2358.0,2445.0,2421.0,2331.0,2282.0,2117.0,1978.0,1799.0,1638.0,1401.0,1273.0,310.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,288.0,0.0,580.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_135()
		{
			double[] value = {0.0,0.0,0.0,0.0,379.0,311.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,538.0,0.0,0.0,181.0,594.0,519.0,0.0,600.0,1191.0,1844.0,1219.0,971.0,0.0,609.0,192.0,378.0,991.0,1194.0,1186.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_136()
		{
			double[] value = {1228.0,1230.0,1152.0,1269.0,1378.0,1682.0,1783.0,1522.0,1183.0,965.0,913.0,862.0,339.0,268.0,967.0,1222.0,745.0,1.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,173.0,276.0,0.0,0.0,146.0,0.0,299.0,41.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,679.0,36.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_137()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,122.0,581.0,288.0,1.0,515.0,597.0,0.0,13.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,270.0,0.0,0.0,1.0,1.0,147.0,8.0,328.0,410.0,579.0,478.0,53.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_138()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_139()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_140()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_141()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}
		private double[] getGEOEG_6_53_height_142()
		{
			double[] value = {0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0};
			return value;
		}

		/** Large attribute array: GeoElevationGrid DEF='GEOEG' height field, scene-graph level=6, element #53, 14112 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGEOEG_6_53_height()
		{
			MFDouble GEOEG_6_53_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGEOEG_6_53_height_1()))
				.append(new MFDouble(getGEOEG_6_53_height_2()))
				.append(new MFDouble(getGEOEG_6_53_height_3()))
				.append(new MFDouble(getGEOEG_6_53_height_4()))
				.append(new MFDouble(getGEOEG_6_53_height_5()))
				.append(new MFDouble(getGEOEG_6_53_height_6()))
				.append(new MFDouble(getGEOEG_6_53_height_7()))
				.append(new MFDouble(getGEOEG_6_53_height_8()))
				.append(new MFDouble(getGEOEG_6_53_height_9()))
				.append(new MFDouble(getGEOEG_6_53_height_10()))
				.append(new MFDouble(getGEOEG_6_53_height_11()))
				.append(new MFDouble(getGEOEG_6_53_height_12()))
				.append(new MFDouble(getGEOEG_6_53_height_13()))
				.append(new MFDouble(getGEOEG_6_53_height_14()))
				.append(new MFDouble(getGEOEG_6_53_height_15()))
				.append(new MFDouble(getGEOEG_6_53_height_16()))
				.append(new MFDouble(getGEOEG_6_53_height_17()))
				.append(new MFDouble(getGEOEG_6_53_height_18()))
				.append(new MFDouble(getGEOEG_6_53_height_19()))
				.append(new MFDouble(getGEOEG_6_53_height_20()))
				.append(new MFDouble(getGEOEG_6_53_height_21()))
				.append(new MFDouble(getGEOEG_6_53_height_22()))
				.append(new MFDouble(getGEOEG_6_53_height_23()))
				.append(new MFDouble(getGEOEG_6_53_height_24()))
				.append(new MFDouble(getGEOEG_6_53_height_25()))
				.append(new MFDouble(getGEOEG_6_53_height_26()))
				.append(new MFDouble(getGEOEG_6_53_height_27()))
				.append(new MFDouble(getGEOEG_6_53_height_28()))
				.append(new MFDouble(getGEOEG_6_53_height_29()))
				.append(new MFDouble(getGEOEG_6_53_height_30()))
				.append(new MFDouble(getGEOEG_6_53_height_31()))
				.append(new MFDouble(getGEOEG_6_53_height_32()))
				.append(new MFDouble(getGEOEG_6_53_height_33()))
				.append(new MFDouble(getGEOEG_6_53_height_34()))
				.append(new MFDouble(getGEOEG_6_53_height_35()))
				.append(new MFDouble(getGEOEG_6_53_height_36()))
				.append(new MFDouble(getGEOEG_6_53_height_37()))
				.append(new MFDouble(getGEOEG_6_53_height_38()))
				.append(new MFDouble(getGEOEG_6_53_height_39()))
				.append(new MFDouble(getGEOEG_6_53_height_40()))
				.append(new MFDouble(getGEOEG_6_53_height_41()))
				.append(new MFDouble(getGEOEG_6_53_height_42()))
				.append(new MFDouble(getGEOEG_6_53_height_43()))
				.append(new MFDouble(getGEOEG_6_53_height_44()))
				.append(new MFDouble(getGEOEG_6_53_height_45()))
				.append(new MFDouble(getGEOEG_6_53_height_46()))
				.append(new MFDouble(getGEOEG_6_53_height_47()))
				.append(new MFDouble(getGEOEG_6_53_height_48()))
				.append(new MFDouble(getGEOEG_6_53_height_49()))
				.append(new MFDouble(getGEOEG_6_53_height_50()))
				.append(new MFDouble(getGEOEG_6_53_height_51()))
				.append(new MFDouble(getGEOEG_6_53_height_52()))
				.append(new MFDouble(getGEOEG_6_53_height_53()))
				.append(new MFDouble(getGEOEG_6_53_height_54()))
				.append(new MFDouble(getGEOEG_6_53_height_55()))
				.append(new MFDouble(getGEOEG_6_53_height_56()))
				.append(new MFDouble(getGEOEG_6_53_height_57()))
				.append(new MFDouble(getGEOEG_6_53_height_58()))
				.append(new MFDouble(getGEOEG_6_53_height_59()))
				.append(new MFDouble(getGEOEG_6_53_height_60()))
				.append(new MFDouble(getGEOEG_6_53_height_61()))
				.append(new MFDouble(getGEOEG_6_53_height_62()))
				.append(new MFDouble(getGEOEG_6_53_height_63()))
				.append(new MFDouble(getGEOEG_6_53_height_64()))
				.append(new MFDouble(getGEOEG_6_53_height_65()))
				.append(new MFDouble(getGEOEG_6_53_height_66()))
				.append(new MFDouble(getGEOEG_6_53_height_67()))
				.append(new MFDouble(getGEOEG_6_53_height_68()))
				.append(new MFDouble(getGEOEG_6_53_height_69()))
				.append(new MFDouble(getGEOEG_6_53_height_70()))
				.append(new MFDouble(getGEOEG_6_53_height_71()))
				.append(new MFDouble(getGEOEG_6_53_height_72()))
				.append(new MFDouble(getGEOEG_6_53_height_73()))
				.append(new MFDouble(getGEOEG_6_53_height_74()))
				.append(new MFDouble(getGEOEG_6_53_height_75()))
				.append(new MFDouble(getGEOEG_6_53_height_76()))
				.append(new MFDouble(getGEOEG_6_53_height_77()))
				.append(new MFDouble(getGEOEG_6_53_height_78()))
				.append(new MFDouble(getGEOEG_6_53_height_79()))
				.append(new MFDouble(getGEOEG_6_53_height_80()))
				.append(new MFDouble(getGEOEG_6_53_height_81()))
				.append(new MFDouble(getGEOEG_6_53_height_82()))
				.append(new MFDouble(getGEOEG_6_53_height_83()))
				.append(new MFDouble(getGEOEG_6_53_height_84()))
				.append(new MFDouble(getGEOEG_6_53_height_85()))
				.append(new MFDouble(getGEOEG_6_53_height_86()))
				.append(new MFDouble(getGEOEG_6_53_height_87()))
				.append(new MFDouble(getGEOEG_6_53_height_88()))
				.append(new MFDouble(getGEOEG_6_53_height_89()))
				.append(new MFDouble(getGEOEG_6_53_height_90()))
				.append(new MFDouble(getGEOEG_6_53_height_91()))
				.append(new MFDouble(getGEOEG_6_53_height_92()))
				.append(new MFDouble(getGEOEG_6_53_height_93()))
				.append(new MFDouble(getGEOEG_6_53_height_94()))
				.append(new MFDouble(getGEOEG_6_53_height_95()))
				.append(new MFDouble(getGEOEG_6_53_height_96()))
				.append(new MFDouble(getGEOEG_6_53_height_97()))
				.append(new MFDouble(getGEOEG_6_53_height_98()))
				.append(new MFDouble(getGEOEG_6_53_height_99()))
				.append(new MFDouble(getGEOEG_6_53_height_100()))
				.append(new MFDouble(getGEOEG_6_53_height_101()))
				.append(new MFDouble(getGEOEG_6_53_height_102()))
				.append(new MFDouble(getGEOEG_6_53_height_103()))
				.append(new MFDouble(getGEOEG_6_53_height_104()))
				.append(new MFDouble(getGEOEG_6_53_height_105()))
				.append(new MFDouble(getGEOEG_6_53_height_106()))
				.append(new MFDouble(getGEOEG_6_53_height_107()))
				.append(new MFDouble(getGEOEG_6_53_height_108()))
				.append(new MFDouble(getGEOEG_6_53_height_109()))
				.append(new MFDouble(getGEOEG_6_53_height_110()))
				.append(new MFDouble(getGEOEG_6_53_height_111()))
				.append(new MFDouble(getGEOEG_6_53_height_112()))
				.append(new MFDouble(getGEOEG_6_53_height_113()))
				.append(new MFDouble(getGEOEG_6_53_height_114()))
				.append(new MFDouble(getGEOEG_6_53_height_115()))
				.append(new MFDouble(getGEOEG_6_53_height_116()))
				.append(new MFDouble(getGEOEG_6_53_height_117()))
				.append(new MFDouble(getGEOEG_6_53_height_118()))
				.append(new MFDouble(getGEOEG_6_53_height_119()))
				.append(new MFDouble(getGEOEG_6_53_height_120()))
				.append(new MFDouble(getGEOEG_6_53_height_121()))
				.append(new MFDouble(getGEOEG_6_53_height_122()))
				.append(new MFDouble(getGEOEG_6_53_height_123()))
				.append(new MFDouble(getGEOEG_6_53_height_124()))
				.append(new MFDouble(getGEOEG_6_53_height_125()))
				.append(new MFDouble(getGEOEG_6_53_height_126()))
				.append(new MFDouble(getGEOEG_6_53_height_127()))
				.append(new MFDouble(getGEOEG_6_53_height_128()))
				.append(new MFDouble(getGEOEG_6_53_height_129()))
				.append(new MFDouble(getGEOEG_6_53_height_130()))
				.append(new MFDouble(getGEOEG_6_53_height_131()))
				.append(new MFDouble(getGEOEG_6_53_height_132()))
				.append(new MFDouble(getGEOEG_6_53_height_133()))
				.append(new MFDouble(getGEOEG_6_53_height_134()))
				.append(new MFDouble(getGEOEG_6_53_height_135()))
				.append(new MFDouble(getGEOEG_6_53_height_136()))
				.append(new MFDouble(getGEOEG_6_53_height_137()))
				.append(new MFDouble(getGEOEG_6_53_height_138()))
				.append(new MFDouble(getGEOEG_6_53_height_139()))
				.append(new MFDouble(getGEOEG_6_53_height_140()))
				.append(new MFDouble(getGEOEG_6_53_height_141()))
				.append(new MFDouble(getGEOEG_6_53_height_142()));
			return GEOEG_6_53_height;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return WorldHigh model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new WorldHigh().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.WorldHigh\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.WorldHigh self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/WorldHigh_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/WorldHigh_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/WorldHigh_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/WorldHigh_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
