####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SriCampus025.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Interactive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SriCampus025.x3d',name='title'),
    meta(content='SRI campus building',name='description'),
    meta(content='Aaron Heller, SRI International',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='1 February 2000',name='created'),
    meta(content='29 April 2003',name='translated'),
    meta(content='20 October 2019',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus025.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SriCampus025.x3d'),
    TouchSensor(DEF='MouseOverPopupDescription',description='$DTM Tri Mesh 21',enabled=False),
    Shape(
      appearance=Appearance(
        material=Material(diffuseColor=(0.75,0.75,0.75)),
        texture=ImageTexture(repeatS=False,repeatT=False,url=["images/tm-25-0.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/tm-25-0.jpg"])),
      geometry=IndexedFaceSet(convex=False,coordIndex=[868,899,898,-1,868,869,899,-1,867,898,897,-1,867,868,898,-1,866,897,896,-1,866,867,897,-1,865,896,895,-1,865,866,896,-1,864,895,894,-1,864,865,895,-1,863,894,893,-1,863,864,894,-1,862,893,892,-1,862,863,893,-1,861,892,891,-1,861,862,892,-1,860,891,890,-1,860,861,891,-1,859,890,889,-1,859,860,890,-1,858,889,888,-1,858,859,889,-1,857,888,887,-1,857,858,888,-1,856,887,886,-1,856,857,887,-1,855,886,885,-1,855,856,886,-1,854,885,884,-1,854,855,885,-1,853,884,883,-1,853,854,884,-1,852,883,882,-1,852,853,883,-1,851,882,881,-1,851,852,882,-1,850,881,880,-1,850,851,881,-1,849,880,879,-1,849,850,880,-1,848,879,878,-1,848,849,879,-1,847,878,877,-1,847,848,878,-1,846,877,876,-1,846,847,877,-1,845,876,875,-1,845,846,876,-1,844,875,874,-1,844,845,875,-1,843,874,873,-1,843,844,874,-1,842,873,872,-1,842,843,873,-1,841,872,871,-1,841,842,872,-1,840,871,870,-1,840,841,871,-1,838,869,868,-1,838,839,869,-1,837,868,867,-1,837,838,868,-1,836,867,866,-1,836,837,867,-1,835,866,865,-1,835,836,866,-1,834,865,864,-1,834,835,865,-1,833,864,863,-1,833,834,864,-1,832,863,862,-1,832,833,863,-1,831,862,861,-1,831,832,862,-1,830,861,860,-1,830,831,861,-1,829,860,859,-1,829,830,860,-1,828,859,858,-1,828,829,859,-1,827,858,857,-1,827,828,858,-1,826,857,856,-1,826,827,857,-1,825,856,855,-1,825,826,856,-1,824,855,854,-1,824,825,855,-1,823,854,853,-1,823,824,854,-1,822,853,852,-1,822,823,853,-1,821,852,851,-1,821,822,852,-1,820,851,850,-1,820,821,851,-1,819,850,849,-1,819,820,850,-1,818,849,848,-1,818,819,849,-1,817,848,847,-1,817,818,848,-1,816,847,846,-1,816,817,847,-1,815,846,845,-1,815,816,846,-1,814,845,844,-1,814,815,845,-1,813,844,843,-1,813,814,844,-1,812,843,842,-1,812,813,843,-1,811,842,841,-1,811,812,842,-1,810,841,840,-1,810,811,841,-1,808,839,838,-1,808,809,839,-1,807,838,837,-1,807,808,838,-1,806,837,836,-1,806,807,837,-1,805,836,835,-1,805,806,836,-1,804,835,834,-1,804,805,835,-1,803,834,833,-1,803,804,834,-1,802,833,832,-1,802,803,833,-1,801,832,831,-1,801,802,832,-1,800,831,830,-1,800,801,831,-1,799,830,829,-1,799,800,830,-1,798,829,828,-1,798,799,829,-1,797,828,827,-1,797,798,828,-1,796,827,826,-1,796,797,827,-1,795,826,825,-1,795,796,826,-1,794,825,824,-1,794,795,825,-1,793,824,823,-1,793,794,824,-1,792,823,822,-1,792,793,823,-1,791,822,821,-1,791,792,822,-1,790,821,820,-1,790,791,821,-1,789,820,819,-1,789,790,820,-1,788,819,818,-1,788,789,819,-1,787,818,817,-1,787,788,818,-1,786,817,816,-1,786,787,817,-1,785,816,815,-1,785,786,816,-1,784,815,814,-1,784,785,815,-1,783,814,813,-1,783,784,814,-1,782,813,812,-1,782,783,813,-1,781,812,811,-1,781,782,812,-1,780,811,810,-1,780,781,811,-1,778,809,808,-1,778,779,809,-1,777,808,807,-1,777,778,808,-1,776,807,806,-1,776,777,807,-1,775,806,805,-1,775,776,806,-1,774,805,804,-1,774,775,805,-1,773,804,803,-1,773,774,804,-1,772,803,802,-1,772,773,803,-1,771,802,801,-1,771,772,802,-1,770,801,800,-1,770,771,801,-1,769,800,799,-1,769,770,800,-1,768,799,798,-1,768,769,799,-1,767,798,797,-1,767,768,798,-1,766,797,796,-1,766,767,797,-1,765,796,795,-1,765,766,796,-1,764,795,794,-1,764,765,795,-1,763,794,793,-1,763,764,794,-1,762,793,792,-1,762,763,793,-1,761,792,791,-1,761,762,792,-1,760,791,790,-1,760,761,791,-1,759,790,789,-1,759,760,790,-1,758,789,788,-1,758,759,789,-1,757,788,787,-1,757,758,788,-1,756,787,786,-1,756,757,787,-1,755,786,785,-1,755,756,786,-1,754,785,784,-1,754,755,785,-1,753,784,783,-1,753,754,784,-1,752,783,782,-1,752,753,783,-1,751,782,781,-1,751,752,782,-1,750,781,780,-1,750,751,781,-1,748,779,778,-1,748,749,779,-1,747,778,777,-1,747,748,778,-1,746,777,776,-1,746,747,777,-1,745,776,775,-1,745,746,776,-1,744,775,774,-1,744,745,775,-1,743,774,773,-1,743,744,774,-1,742,773,772,-1,742,743,773,-1,741,772,771,-1,741,742,772,-1,740,771,770,-1,740,741,771,-1,739,770,769,-1,739,740,770,-1,738,769,768,-1,738,739,769,-1,737,768,767,-1,737,738,768,-1,736,767,766,-1,736,737,767,-1,735,766,765,-1,735,736,766,-1,734,765,764,-1,734,735,765,-1,733,764,763,-1,733,734,764,-1,732,763,762,-1,732,733,763,-1,731,762,761,-1,731,732,762,-1,730,761,760,-1,730,731,761,-1,729,760,759,-1,729,730,760,-1,728,759,758,-1,728,729,759,-1,727,758,757,-1,727,728,758,-1,726,757,756,-1,726,727,757,-1,725,756,755,-1,725,726,756,-1,724,755,754,-1,724,725,755,-1,723,754,753,-1,723,724,754,-1,722,753,752,-1,722,723,753,-1,721,752,751,-1,721,722,752,-1,720,751,750,-1,720,721,751,-1,718,749,748,-1,718,719,749,-1,717,748,747,-1,717,718,748,-1,716,747,746,-1,716,717,747,-1,715,746,745,-1,715,716,746,-1,714,745,744,-1,714,715,745,-1,713,744,743,-1,713,714,744,-1,712,743,742,-1,712,713,743,-1,711,742,741,-1,711,712,742,-1,710,741,740,-1,710,711,741,-1,709,740,739,-1,709,710,740,-1,708,739,738,-1,708,709,739,-1,707,738,737,-1,707,708,738,-1,706,737,736,-1,706,707,737,-1,705,736,735,-1,705,706,736,-1,704,735,734,-1,704,705,735,-1,703,734,733,-1,703,704,734,-1,702,733,732,-1,702,703,733,-1,701,732,731,-1,701,702,732,-1,700,731,730,-1,700,701,731,-1,699,730,729,-1,699,700,730,-1,698,729,728,-1,698,699,729,-1,697,728,727,-1,697,698,728,-1,696,727,726,-1,696,697,727,-1,695,726,725,-1,695,696,726,-1,694,725,724,-1,694,695,725,-1,693,724,723,-1,693,694,724,-1,692,723,722,-1,692,693,723,-1,691,722,721,-1,691,692,722,-1,690,721,720,-1,690,691,721,-1,688,719,718,-1,688,689,719,-1,687,718,717,-1,687,688,718,-1,686,717,716,-1,686,687,717,-1,685,716,715,-1,685,686,716,-1,684,715,714,-1,684,685,715,-1,683,714,713,-1,683,684,714,-1,682,713,712,-1,682,683,713,-1,681,712,711,-1,681,682,712,-1,680,711,710,-1,680,681,711,-1,679,710,709,-1,679,680,710,-1,678,709,708,-1,678,679,709,-1,677,708,707,-1,677,678,708,-1,676,707,706,-1,676,677,707,-1,675,706,705,-1,675,676,706,-1,674,705,704,-1,674,675,705,-1,673,704,703,-1,673,674,704,-1,672,703,702,-1,672,673,703,-1,671,702,701,-1,671,672,702,-1,670,701,700,-1,670,671,701,-1,669,700,699,-1,669,670,700,-1,668,699,698,-1,668,669,699,-1,667,698,697,-1,667,668,698,-1,666,697,696,-1,666,667,697,-1,665,696,695,-1,665,666,696,-1,664,695,694,-1,664,665,695,-1,663,694,693,-1,663,664,694,-1,662,693,692,-1,662,663,693,-1,661,692,691,-1,661,662,692,-1,660,691,690,-1,660,661,691,-1,658,689,688,-1,658,659,689,-1,657,688,687,-1,657,658,688,-1,656,687,686,-1,656,657,687,-1,655,686,685,-1,655,656,686,-1,654,685,684,-1,654,655,685,-1,653,684,683,-1,653,654,684,-1,652,683,682,-1,652,653,683,-1,651,682,681,-1,651,652,682,-1,650,681,680,-1,650,651,681,-1,649,680,679,-1,649,650,680,-1,648,679,678,-1,648,649,679,-1,647,678,677,-1,647,648,678,-1,646,677,676,-1,646,647,677,-1,645,676,675,-1,645,646,676,-1,644,675,674,-1,644,645,675,-1,643,674,673,-1,643,644,674,-1,642,673,672,-1,642,643,673,-1,641,672,671,-1,641,642,672,-1,640,671,670,-1,640,641,671,-1,639,670,669,-1,639,640,670,-1,638,669,668,-1,638,639,669,-1,637,668,667,-1,637,638,668,-1,636,667,666,-1,636,637,667,-1,635,666,665,-1,635,636,666,-1,634,665,664,-1,634,635,665,-1,633,664,663,-1,633,634,664,-1,632,663,662,-1,632,633,663,-1,631,662,661,-1,631,632,662,-1,630,661,660,-1,630,631,661,-1,628,659,658,-1,628,629,659,-1,627,658,657,-1,627,628,658,-1,626,657,656,-1,626,627,657,-1,625,656,655,-1,625,626,656,-1,624,655,654,-1,624,625,655,-1,623,654,653,-1,623,624,654,-1,622,653,652,-1,622,623,653,-1,621,652,651,-1,621,622,652,-1,620,651,650,-1,620,621,651,-1,619,650,649,-1,619,620,650,-1,618,649,648,-1,618,619,649,-1,617,648,647,-1,617,618,648,-1,616,647,646,-1,616,617,647,-1,615,646,645,-1,615,616,646,-1,614,645,644,-1,614,615,645,-1,613,644,643,-1,613,614,644,-1,612,643,642,-1,612,613,643,-1,611,642,641,-1,611,612,642,-1,610,641,640,-1,610,611,641,-1,609,640,639,-1,609,610,640,-1,608,639,638,-1,608,609,639,-1,607,638,637,-1,607,608,638,-1,606,637,636,-1,606,607,637,-1,605,636,635,-1,605,606,636,-1,604,635,634,-1,604,605,635,-1,603,634,633,-1,603,604,634,-1,602,633,632,-1,602,603,633,-1,601,632,631,-1,601,602,632,-1,600,631,630,-1,600,601,631,-1,598,629,628,-1,598,599,629,-1,597,628,627,-1,597,598,628,-1,596,627,626,-1,596,597,627,-1,595,626,625,-1,595,596,626,-1,594,625,624,-1,594,595,625,-1,593,624,623,-1,593,594,624,-1,592,623,622,-1,592,593,623,-1,591,622,621,-1,591,592,622,-1,590,621,620,-1,590,591,621,-1,589,620,619,-1,589,590,620,-1,588,619,618,-1,588,589,619,-1,587,618,617,-1,587,588,618,-1,586,617,616,-1,586,587,617,-1,585,616,615,-1,585,586,616,-1,584,615,614,-1,584,585,615,-1,583,614,613,-1,583,584,614,-1,582,613,612,-1,582,583,613,-1,581,612,611,-1,581,582,612,-1,580,611,610,-1,580,581,611,-1,579,610,609,-1,579,580,610,-1,578,609,608,-1,578,579,609,-1,577,608,607,-1,577,578,608,-1,576,607,606,-1,576,577,607,-1,575,606,605,-1,575,576,606,-1,574,605,604,-1,574,575,605,-1,573,604,603,-1,573,574,604,-1,572,603,602,-1,572,573,603,-1,571,602,601,-1,571,572,602,-1,570,601,600,-1,570,571,601,-1,568,599,598,-1,568,569,599,-1,567,598,597,-1,567,568,598,-1,566,597,596,-1,566,567,597,-1,565,596,595,-1,565,566,596,-1,564,595,594,-1,564,565,595,-1,563,594,593,-1,563,564,594,-1,562,593,592,-1,562,563,593,-1,561,592,591,-1,561,562,592,-1,560,591,590,-1,560,561,591,-1,559,590,589,-1,559,560,590,-1,558,589,588,-1,558,559,589,-1,557,588,587,-1,557,558,588,-1,556,587,586,-1,556,557,587,-1,555,586,585,-1,555,556,586,-1,554,585,584,-1,554,555,585,-1,553,584,583,-1,553,554,584,-1,552,583,582,-1,552,553,583,-1,551,582,581,-1,551,552,582,-1,550,581,580,-1,550,551,581,-1,549,580,579,-1,549,550,580,-1,548,579,578,-1,548,549,579,-1,547,578,577,-1,547,548,578,-1,546,577,576,-1,546,547,577,-1,545,576,575,-1,545,546,576,-1,544,575,574,-1,544,545,575,-1,543,574,573,-1,543,544,574,-1,542,573,572,-1,542,543,573,-1,541,572,571,-1,541,542,572,-1,540,571,570,-1,540,541,571,-1,538,569,568,-1,538,539,569,-1,537,568,567,-1,537,538,568,-1,536,567,566,-1,536,537,567,-1,535,566,565,-1,535,536,566,-1,534,565,564,-1,534,535,565,-1,533,564,563,-1,533,534,564,-1,532,563,562,-1,532,533,563,-1,531,562,561,-1,531,532,562,-1,530,561,560,-1,530,531,561,-1,529,560,559,-1,529,530,560,-1,528,559,558,-1,528,529,559,-1,527,558,557,-1,527,528,558,-1,526,557,556,-1,526,527,557,-1,525,556,555,-1,525,526,556,-1,524,555,554,-1,524,525,555,-1,523,554,553,-1,523,524,554,-1,522,553,552,-1,522,523,553,-1,521,552,551,-1,521,522,552,-1,520,551,550,-1,520,521,551,-1,519,550,549,-1,519,520,550,-1,518,549,548,-1,518,519,549,-1,517,548,547,-1,517,518,548,-1,516,547,546,-1,516,517,547,-1,515,546,545,-1,515,516,546,-1,514,545,544,-1,514,515,545,-1,513,544,543,-1,513,514,544,-1,512,543,542,-1,512,513,543,-1,511,542,541,-1,511,512,542,-1,510,541,540,-1,510,511,541,-1,508,539,538,-1,508,509,539,-1,507,538,537,-1,507,508,538,-1,506,537,536,-1,506,507,537,-1,505,536,535,-1,505,506,536,-1,504,535,534,-1,504,505,535,-1,503,534,533,-1,503,504,534,-1,502,533,532,-1,502,503,533,-1,501,532,531,-1,501,502,532,-1,500,531,530,-1,500,501,531,-1,499,530,529,-1,499,500,530,-1,498,529,528,-1,498,499,529,-1,497,528,527,-1,497,498,528,-1,496,527,526,-1,496,497,527,-1,495,526,525,-1,495,496,526,-1,494,525,524,-1,494,495,525,-1,493,524,523,-1,493,494,524,-1,492,523,522,-1,492,493,523,-1,491,522,521,-1,491,492,522,-1,490,521,520,-1,490,491,521,-1,489,520,519,-1,489,490,520,-1,488,519,518,-1,488,489,519,-1,487,518,517,-1,487,488,518,-1,486,517,516,-1,486,487,517,-1,485,516,515,-1,485,486,516,-1,484,515,514,-1,484,485,515,-1,483,514,513,-1,483,484,514,-1,482,513,512,-1,482,483,513,-1,481,512,511,-1,481,482,512,-1,480,511,510,-1,480,481,511,-1,478,509,508,-1,478,479,509,-1,477,508,507,-1,477,478,508,-1,476,507,506,-1,476,477,507,-1,475,506,505,-1,475,476,506,-1,474,505,504,-1,474,475,505,-1,473,504,503,-1,473,474,504,-1,472,503,502,-1,472,473,503,-1,471,502,501,-1,471,472,502,-1,470,501,500,-1,470,471,501,-1,469,500,499,-1,469,470,500,-1,468,499,498,-1,468,469,499,-1,467,498,497,-1,467,468,498,-1,466,497,496,-1,466,467,497,-1,465,496,495,-1,465,466,496,-1,464,495,494,-1,464,465,495,-1,463,494,493,-1,463,464,494,-1,462,493,492,-1,462,463,493,-1,461,492,491,-1,461,462,492,-1,460,491,490,-1,460,461,491,-1,459,490,489,-1,459,460,490,-1,458,489,488,-1,458,459,489,-1,457,488,487,-1,457,458,488,-1,456,487,486,-1,456,457,487,-1,455,486,485,-1,455,456,486,-1,454,485,484,-1,454,455,485,-1,453,484,483,-1,453,454,484,-1,452,483,482,-1,452,453,483,-1,451,482,481,-1,451,452,482,-1,450,481,480,-1,450,451,481,-1,448,479,478,-1,448,449,479,-1,447,478,477,-1,447,448,478,-1,446,477,476,-1,446,447,477,-1,445,476,475,-1,445,446,476,-1,444,475,474,-1,444,445,475,-1,443,474,473,-1,443,444,474,-1,442,473,472,-1,442,443,473,-1,441,472,471,-1,441,442,472,-1,440,471,470,-1,440,441,471,-1,439,470,469,-1,439,440,470,-1,438,469,468,-1,438,439,469,-1,437,468,467,-1,437,438,468,-1,436,467,466,-1,436,437,467,-1,435,466,465,-1,435,436,466,-1,434,465,464,-1,434,435,465,-1,433,464,463,-1,433,434,464,-1,432,463,462,-1,432,433,463,-1,431,462,461,-1,431,432,462,-1,430,461,460,-1,430,431,461,-1,429,460,459,-1,429,430,460,-1,428,459,458,-1,428,429,459,-1,427,458,457,-1,427,428,458,-1,426,457,456,-1,426,427,457,-1,425,456,455,-1,425,426,456,-1,424,455,454,-1,424,425,455,-1,423,454,453,-1,423,424,454,-1,422,453,452,-1,422,423,453,-1,421,452,451,-1,421,422,452,-1,420,451,450,-1,420,421,451,-1,418,449,448,-1,418,419,449,-1,417,448,447,-1,417,418,448,-1,416,447,446,-1,416,417,447,-1,415,446,445,-1,415,416,446,-1,414,445,444,-1,414,415,445,-1,413,444,443,-1,413,414,444,-1,412,443,442,-1,412,413,443,-1,411,442,441,-1,411,412,442,-1,410,441,440,-1,410,411,441,-1,409,440,439,-1,409,410,440,-1,408,439,438,-1,408,409,439,-1,407,438,437,-1,407,408,438,-1,406,437,436,-1,406,407,437,-1,405,436,435,-1,405,406,436,-1,404,435,434,-1,404,405,435,-1,403,434,433,-1,403,404,434,-1,402,433,432,-1,402,403,433,-1,401,432,431,-1,401,402,432,-1,400,431,430,-1,400,401,431,-1,399,430,429,-1,399,400,430,-1,398,429,428,-1,398,399,429,-1,397,428,427,-1,397,398,428,-1,396,427,426,-1,396,397,427,-1,395,426,425,-1,395,396,426,-1,394,425,424,-1,394,395,425,-1,393,424,423,-1,393,394,424,-1,392,423,422,-1,392,393,423,-1,391,422,421,-1,391,392,422,-1,390,421,420,-1,390,391,421,-1,388,419,418,-1,388,389,419,-1,387,418,417,-1,387,388,418,-1,386,417,416,-1,386,387,417,-1,385,416,415,-1,385,386,416,-1,384,415,414,-1,384,385,415,-1,383,414,413,-1,383,384,414,-1,382,413,412,-1,382,383,413,-1,381,412,411,-1,381,382,412,-1,380,411,410,-1,380,381,411,-1,379,410,409,-1,379,380,410,-1,378,409,408,-1,378,379,409,-1,377,408,407,-1,377,378,408,-1,376,407,406,-1,376,377,407,-1,375,406,405,-1,375,376,406,-1,374,405,404,-1,374,375,405,-1,373,404,403,-1,373,374,404,-1,372,403,402,-1,372,373,403,-1,371,402,401,-1,371,372,402,-1,370,401,400,-1,370,371,401,-1,369,400,399,-1,369,370,400,-1,368,399,398,-1,368,369,399,-1,367,398,397,-1,367,368,398,-1,366,397,396,-1,366,367,397,-1,365,396,395,-1,365,366,396,-1,364,395,394,-1,364,365,395,-1,363,394,393,-1,363,364,394,-1,362,393,392,-1,362,363,393,-1,361,392,391,-1,361,362,392,-1,360,391,390,-1,360,361,391,-1,358,389,388,-1,358,359,389,-1,357,388,387,-1,357,358,388,-1,356,387,386,-1,356,357,387,-1,355,386,385,-1,355,356,386,-1,354,385,384,-1,354,355,385,-1,353,384,383,-1,353,354,384,-1,352,383,382,-1,352,353,383,-1,351,382,381,-1,351,352,382,-1,350,381,380,-1,350,351,381,-1,349,380,379,-1,349,350,380,-1,348,379,378,-1,348,349,379,-1,347,378,377,-1,347,348,378,-1,346,377,376,-1,346,347,377,-1,345,376,375,-1,345,346,376,-1,344,375,374,-1,344,345,375,-1,343,374,373,-1,343,344,374,-1,342,373,372,-1,342,343,373,-1,341,372,371,-1,341,342,372,-1,340,371,370,-1,340,341,371,-1,339,370,369,-1,339,340,370,-1,338,369,368,-1,338,339,369,-1,337,368,367,-1,337,338,368,-1,336,367,366,-1,336,337,367,-1,335,366,365,-1,335,336,366,-1,334,365,364,-1,334,335,365,-1,333,364,363,-1,333,334,364,-1,332,363,362,-1,332,333,363,-1,331,362,361,-1,331,332,362,-1,330,361,360,-1,330,331,361,-1,328,359,358,-1,328,329,359,-1,327,358,357,-1,327,328,358,-1,326,357,356,-1,326,327,357,-1,325,356,355,-1,325,326,356,-1,324,355,354,-1,324,325,355,-1,323,354,353,-1,323,324,354,-1,322,353,352,-1,322,323,353,-1,321,352,351,-1,321,322,352,-1,320,351,350,-1,320,321,351,-1,319,350,349,-1,319,320,350,-1,318,349,348,-1,318,319,349,-1,317,348,347,-1,317,318,348,-1,316,347,346,-1,316,317,347,-1,315,346,345,-1,315,316,346,-1,314,345,344,-1,314,315,345,-1,313,344,343,-1,313,314,344,-1,312,343,342,-1,312,313,343,-1,311,342,341,-1,311,312,342,-1,310,341,340,-1,310,311,341,-1,309,340,339,-1,309,310,340,-1,308,339,338,-1,308,309,339,-1,307,338,337,-1,307,308,338,-1,306,337,336,-1,306,307,337,-1,305,336,335,-1,305,306,336,-1,304,335,334,-1,304,305,335,-1,303,334,333,-1,303,304,334,-1,302,333,332,-1,302,303,333,-1,301,332,331,-1,301,302,332,-1,300,331,330,-1,300,301,331,-1,298,329,328,-1,298,299,329,-1,297,328,327,-1,297,298,328,-1,296,327,326,-1,296,297,327,-1,295,326,325,-1,295,296,326,-1,294,325,324,-1,294,295,325,-1,293,324,323,-1,293,294,324,-1,292,323,322,-1,292,293,323,-1,291,322,321,-1,291,292,322,-1,290,321,320,-1,290,291,321,-1,289,320,319,-1,289,290,320,-1,288,319,318,-1,288,289,319,-1,287,318,317,-1,287,288,318,-1,286,317,316,-1,286,287,317,-1,285,316,315,-1,285,286,316,-1,284,315,314,-1,284,285,315,-1,283,314,313,-1,283,284,314,-1,282,313,312,-1,282,283,313,-1,281,312,311,-1,281,282,312,-1,280,311,310,-1,280,281,311,-1,279,310,309,-1,279,280,310,-1,278,309,308,-1,278,279,309,-1,277,308,307,-1,277,278,308,-1,276,307,306,-1,276,277,307,-1,275,306,305,-1,275,276,306,-1,274,305,304,-1,274,275,305,-1,273,304,303,-1,273,274,304,-1,272,303,302,-1,272,273,303,-1,271,302,301,-1,271,272,302,-1,270,301,300,-1,270,271,301,-1,268,299,298,-1,268,269,299,-1,267,298,297,-1,267,268,298,-1,266,297,296,-1,266,267,297,-1,265,296,295,-1,265,266,296,-1,264,295,294,-1,264,265,295,-1,263,294,293,-1,263,264,294,-1,262,293,292,-1,262,263,293,-1,261,292,291,-1,261,262,292,-1,260,291,290,-1,260,261,291,-1,259,290,289,-1,259,260,290,-1,258,289,288,-1,258,259,289,-1,257,288,287,-1,257,258,288,-1,256,287,286,-1,256,257,287,-1,255,286,285,-1,255,256,286,-1,254,285,284,-1,254,255,285,-1,253,284,283,-1,253,254,284,-1,252,283,282,-1,252,253,283,-1,251,282,281,-1,251,252,282,-1,250,281,280,-1,250,251,281,-1,249,280,279,-1,249,250,280,-1,248,279,278,-1,248,249,279,-1,247,278,277,-1,247,248,278,-1,246,277,276,-1,246,247,277,-1,245,276,275,-1,245,246,276,-1,244,275,274,-1,244,245,275,-1,243,274,273,-1,243,244,274,-1,242,273,272,-1,242,243,273,-1,241,272,271,-1,241,242,272,-1,240,271,270,-1,240,241,271,-1,238,269,268,-1,238,239,269,-1,237,268,267,-1,237,238,268,-1,236,267,266,-1,236,237,267,-1,235,266,265,-1,235,236,266,-1,234,265,264,-1,234,235,265,-1,233,264,263,-1,233,234,264,-1,232,263,262,-1,232,233,263,-1,231,262,261,-1,231,232,262,-1,230,261,260,-1,230,231,261,-1,229,260,259,-1,229,230,260,-1,228,259,258,-1,228,229,259,-1,227,258,257,-1,227,228,258,-1,226,257,256,-1,226,227,257,-1,225,256,255,-1,225,226,256,-1,224,255,254,-1,224,225,255,-1,223,254,253,-1,223,224,254,-1,222,253,252,-1,222,223,253,-1,221,252,251,-1,221,222,252,-1,220,251,250,-1,220,221,251,-1,219,250,249,-1,219,220,250,-1,218,249,248,-1,218,219,249,-1,217,248,247,-1,217,218,248,-1,216,247,246,-1,216,217,247,-1,215,246,245,-1,215,216,246,-1,214,245,244,-1,214,215,245,-1,213,244,243,-1,213,214,244,-1,212,243,242,-1,212,213,243,-1,211,242,241,-1,211,212,242,-1,210,241,240,-1,210,211,241,-1,208,239,238,-1,208,209,239,-1,207,238,237,-1,207,208,238,-1,206,237,236,-1,206,207,237,-1,205,236,235,-1,205,206,236,-1,204,235,234,-1,204,205,235,-1,203,234,233,-1,203,204,234,-1,202,233,232,-1,202,203,233,-1,201,232,231,-1,201,202,232,-1,200,231,230,-1,200,201,231,-1,199,230,229,-1,199,200,230,-1,198,229,228,-1,198,199,229,-1,197,228,227,-1,197,198,228,-1,196,227,226,-1,196,197,227,-1,195,226,225,-1,195,196,226,-1,194,225,224,-1,194,195,225,-1,193,224,223,-1,193,194,224,-1,192,223,222,-1,192,193,223,-1,191,222,221,-1,191,192,222,-1,190,221,220,-1,190,191,221,-1,189,220,219,-1,189,190,220,-1,188,219,218,-1,188,189,219,-1,187,218,217,-1,187,188,218,-1,186,217,216,-1,186,187,217,-1,185,216,215,-1,185,186,216,-1,184,215,214,-1,184,185,215,-1,183,214,213,-1,183,184,214,-1,182,213,212,-1,182,183,213,-1,181,212,211,-1,181,182,212,-1,180,211,210,-1,180,181,211,-1,178,209,208,-1,178,179,209,-1,177,208,207,-1,177,178,208,-1,176,207,206,-1,176,177,207,-1,175,206,205,-1,175,176,206,-1,174,205,204,-1,174,175,205,-1,173,204,203,-1,173,174,204,-1,172,203,202,-1,172,173,203,-1,171,202,201,-1,171,172,202,-1,170,201,200,-1,170,171,201,-1,169,200,199,-1,169,170,200,-1,168,199,198,-1,168,169,199,-1,167,198,197,-1,167,168,198,-1,166,197,196,-1,166,167,197,-1,165,196,195,-1,165,166,196,-1,164,195,194,-1,164,165,195,-1,163,194,193,-1,163,164,194,-1,162,193,192,-1,162,163,193,-1,161,192,191,-1,161,162,192,-1,160,191,190,-1,160,161,191,-1,159,190,189,-1,159,160,190,-1,158,189,188,-1,158,159,189,-1,157,188,187,-1,157,158,188,-1,156,187,186,-1,156,157,187,-1,155,186,185,-1,155,156,186,-1,154,185,184,-1,154,155,185,-1,153,184,183,-1,153,154,184,-1,152,183,182,-1,152,153,183,-1,151,182,181,-1,151,152,182,-1,150,181,180,-1,150,151,181,-1,148,179,178,-1,148,149,179,-1,147,178,177,-1,147,148,178,-1,146,177,176,-1,146,147,177,-1,145,176,175,-1,145,146,176,-1,144,175,174,-1,144,145,175,-1,143,174,173,-1,143,144,174,-1,142,173,172,-1,142,143,173,-1,141,172,171,-1,141,142,172,-1,140,171,170,-1,140,141,171,-1,139,170,169,-1,139,140,170,-1,138,169,168,-1,138,139,169,-1,137,168,167,-1,137,138,168,-1,136,167,166,-1,136,137,167,-1,135,166,165,-1,135,136,166,-1,134,165,164,-1,134,135,165,-1,133,164,163,-1,133,134,164,-1,132,163,162,-1,132,133,163,-1,131,162,161,-1,131,132,162,-1,130,161,160,-1,130,131,161,-1,129,160,159,-1,129,130,160,-1,128,159,158,-1,128,129,159,-1,127,158,157,-1,127,128,158,-1,126,157,156,-1,126,127,157,-1,125,156,155,-1,125,126,156,-1,124,155,154,-1,124,125,155,-1,123,154,153,-1,123,124,154,-1,122,153,152,-1,122,123,153,-1,121,152,151,-1,121,122,152,-1,120,151,150,-1,120,121,151,-1,118,149,148,-1,118,119,149,-1,117,148,147,-1,117,118,148,-1,116,147,146,-1,116,117,147,-1,115,146,145,-1,115,116,146,-1,114,145,144,-1,114,115,145,-1,113,144,143,-1,113,114,144,-1,112,143,142,-1,112,113,143,-1,111,142,141,-1,111,112,142,-1,110,141,140,-1,110,111,141,-1,109,140,139,-1,109,110,140,-1,108,139,138,-1,108,109,139,-1,107,138,137,-1,107,108,138,-1,106,137,136,-1,106,107,137,-1,105,136,135,-1,105,106,136,-1,104,135,134,-1,104,105,135,-1,103,134,133,-1,103,104,134,-1,102,133,132,-1,102,103,133,-1,101,132,131,-1,101,102,132,-1,100,131,130,-1,100,101,131,-1,99,130,129,-1,99,100,130,-1,98,129,128,-1,98,99,129,-1,97,128,127,-1,97,98,128,-1,96,127,126,-1,96,97,127,-1,95,126,125,-1,95,96,126,-1,94,125,124,-1,94,95,125,-1,93,124,123,-1,93,94,124,-1,92,123,122,-1,92,93,123,-1,91,122,121,-1,91,92,122,-1,90,121,120,-1,90,91,121,-1,88,119,118,-1,88,89,119,-1,87,118,117,-1,87,88,118,-1,86,117,116,-1,86,87,117,-1,85,116,115,-1,85,86,116,-1,84,115,114,-1,84,85,115,-1,83,114,113,-1,83,84,114,-1,82,113,112,-1,82,83,113,-1,81,112,111,-1,81,82,112,-1,80,111,110,-1,80,81,111,-1,79,110,109,-1,79,80,110,-1,78,109,108,-1,78,79,109,-1,77,108,107,-1,77,78,108,-1,76,107,106,-1,76,77,107,-1,75,106,105,-1,75,76,106,-1,74,105,104,-1,74,75,105,-1,73,104,103,-1,73,74,104,-1,72,103,102,-1,72,73,103,-1,71,102,101,-1,71,72,102,-1,70,101,100,-1,70,71,101,-1,69,100,99,-1,69,70,100,-1,68,99,98,-1,68,69,99,-1,67,98,97,-1,67,68,98,-1,66,97,96,-1,66,67,97,-1,65,96,95,-1,65,66,96,-1,64,95,94,-1,64,65,95,-1,63,94,93,-1,63,64,94,-1,62,93,92,-1,62,63,93,-1,61,92,91,-1,61,62,92,-1,60,91,90,-1,60,61,91,-1,58,89,88,-1,58,59,89,-1,57,88,87,-1,57,58,88,-1,56,87,86,-1,56,57,87,-1,55,86,85,-1,55,56,86,-1,54,85,84,-1,54,55,85,-1,53,84,83,-1,53,54,84,-1,52,83,82,-1,52,53,83,-1,51,82,81,-1,51,52,82,-1,50,81,80,-1,50,51,81,-1,49,80,79,-1,49,50,80,-1,48,79,78,-1,48,49,79,-1,47,78,77,-1,47,48,78,-1,46,77,76,-1,46,47,77,-1,45,76,75,-1,45,46,76,-1,44,75,74,-1,44,45,75,-1,43,74,73,-1,43,44,74,-1,42,73,72,-1,42,43,73,-1,41,72,71,-1,41,42,72,-1,40,71,70,-1,40,41,71,-1,39,70,69,-1,39,40,70,-1,38,69,68,-1,38,39,69,-1,37,68,67,-1,37,38,68,-1,36,67,66,-1,36,37,67,-1,35,66,65,-1,35,36,66,-1,34,65,64,-1,34,35,65,-1,33,64,63,-1,33,34,64,-1,32,63,62,-1,32,33,63,-1,31,62,61,-1,31,32,62,-1,30,61,60,-1,30,31,61,-1,28,59,58,-1,28,29,59,-1,27,58,57,-1,27,28,58,-1,26,57,56,-1,26,27,57,-1,25,56,55,-1,25,26,56,-1,24,55,54,-1,24,25,55,-1,23,54,53,-1,23,24,54,-1,22,53,52,-1,22,23,53,-1,21,52,51,-1,21,22,52,-1,20,51,50,-1,20,21,51,-1,19,50,49,-1,19,20,50,-1,18,49,48,-1,18,19,49,-1,17,48,47,-1,17,18,48,-1,16,47,46,-1,16,17,47,-1,15,46,45,-1,15,16,46,-1,14,45,44,-1,14,15,45,-1,13,44,43,-1,13,14,44,-1,12,43,42,-1,12,13,43,-1,11,42,41,-1,11,12,42,-1,10,41,40,-1,10,11,41,-1,9,40,39,-1,9,10,40,-1,8,39,38,-1,8,9,39,-1,7,38,37,-1,7,8,38,-1,6,37,36,-1,6,7,37,-1,5,36,35,-1,5,6,36,-1,4,35,34,-1,4,5,35,-1,3,34,33,-1,3,4,34,-1,2,33,32,-1,2,3,33,-1,1,32,31,-1,1,2,32,-1,0,31,30,-1,0,1,31,-1],creaseAngle=4.0,solid=False,texCoordIndex=[899,898,897,-1,899,896,898,-1,895,897,894,-1,895,899,897,-1,893,894,892,-1,893,895,894,-1,891,892,890,-1,891,893,892,-1,889,890,888,-1,889,891,890,-1,887,888,886,-1,887,889,888,-1,885,886,884,-1,885,887,886,-1,883,884,882,-1,883,885,884,-1,881,882,880,-1,881,883,882,-1,879,880,878,-1,879,881,880,-1,877,878,876,-1,877,879,878,-1,875,876,874,-1,875,877,876,-1,873,874,872,-1,873,875,874,-1,871,872,870,-1,871,873,872,-1,869,870,868,-1,869,871,870,-1,867,868,866,-1,867,869,868,-1,865,866,864,-1,865,867,866,-1,863,864,862,-1,863,865,864,-1,861,862,860,-1,861,863,862,-1,859,860,858,-1,859,861,860,-1,857,858,856,-1,857,859,858,-1,855,856,854,-1,855,857,856,-1,853,854,852,-1,853,855,854,-1,851,852,850,-1,851,853,852,-1,849,850,848,-1,849,851,850,-1,847,848,846,-1,847,849,848,-1,845,846,844,-1,845,847,846,-1,843,844,842,-1,843,845,844,-1,841,842,840,-1,841,843,842,-1,839,896,899,-1,839,838,896,-1,837,899,895,-1,837,839,899,-1,836,895,893,-1,836,837,895,-1,835,893,891,-1,835,836,893,-1,834,891,889,-1,834,835,891,-1,833,889,887,-1,833,834,889,-1,832,887,885,-1,832,833,887,-1,831,885,883,-1,831,832,885,-1,830,883,881,-1,830,831,883,-1,829,881,879,-1,829,830,881,-1,828,879,877,-1,828,829,879,-1,827,877,875,-1,827,828,877,-1,826,875,873,-1,826,827,875,-1,825,873,871,-1,825,826,873,-1,824,871,869,-1,824,825,871,-1,823,869,867,-1,823,824,869,-1,822,867,865,-1,822,823,867,-1,821,865,863,-1,821,822,865,-1,820,863,861,-1,820,821,863,-1,819,861,859,-1,819,820,861,-1,818,859,857,-1,818,819,859,-1,817,857,855,-1,817,818,857,-1,816,855,853,-1,816,817,855,-1,815,853,851,-1,815,816,853,-1,814,851,849,-1,814,815,851,-1,813,849,847,-1,813,814,849,-1,812,847,845,-1,812,813,847,-1,811,845,843,-1,811,812,845,-1,810,843,841,-1,810,811,843,-1,809,838,839,-1,809,808,838,-1,807,839,837,-1,807,809,839,-1,806,837,836,-1,806,807,837,-1,805,836,835,-1,805,806,836,-1,804,835,834,-1,804,805,835,-1,803,834,833,-1,803,804,834,-1,802,833,832,-1,802,803,833,-1,801,832,831,-1,801,802,832,-1,800,831,830,-1,800,801,831,-1,799,830,829,-1,799,800,830,-1,798,829,828,-1,798,799,829,-1,797,828,827,-1,797,798,828,-1,796,827,826,-1,796,797,827,-1,795,826,825,-1,795,796,826,-1,794,825,824,-1,794,795,825,-1,793,824,823,-1,793,794,824,-1,792,823,822,-1,792,793,823,-1,791,822,821,-1,791,792,822,-1,790,821,820,-1,790,791,821,-1,789,820,819,-1,789,790,820,-1,788,819,818,-1,788,789,819,-1,787,818,817,-1,787,788,818,-1,786,817,816,-1,786,787,817,-1,785,816,815,-1,785,786,816,-1,784,815,814,-1,784,785,815,-1,783,814,813,-1,783,784,814,-1,782,813,812,-1,782,783,813,-1,781,812,811,-1,781,782,812,-1,780,811,810,-1,780,781,811,-1,779,808,809,-1,779,778,808,-1,777,809,807,-1,777,779,809,-1,776,807,806,-1,776,777,807,-1,775,806,805,-1,775,776,806,-1,774,805,804,-1,774,775,805,-1,773,804,803,-1,773,774,804,-1,772,803,802,-1,772,773,803,-1,771,802,801,-1,771,772,802,-1,770,801,800,-1,770,771,801,-1,769,800,799,-1,769,770,800,-1,768,799,798,-1,768,769,799,-1,767,798,797,-1,767,768,798,-1,766,797,796,-1,766,767,797,-1,765,796,795,-1,765,766,796,-1,764,795,794,-1,764,765,795,-1,763,794,793,-1,763,764,794,-1,762,793,792,-1,762,763,793,-1,761,792,791,-1,761,762,792,-1,760,791,790,-1,760,761,791,-1,759,790,789,-1,759,760,790,-1,758,789,788,-1,758,759,789,-1,757,788,787,-1,757,758,788,-1,756,787,786,-1,756,757,787,-1,755,786,785,-1,755,756,786,-1,754,785,784,-1,754,755,785,-1,753,784,783,-1,753,754,784,-1,752,783,782,-1,752,753,783,-1,751,782,781,-1,751,752,782,-1,750,781,780,-1,750,751,781,-1,749,778,779,-1,749,748,778,-1,747,779,777,-1,747,749,779,-1,746,777,776,-1,746,747,777,-1,745,776,775,-1,745,746,776,-1,744,775,774,-1,744,745,775,-1,743,774,773,-1,743,744,774,-1,742,773,772,-1,742,743,773,-1,741,772,771,-1,741,742,772,-1,740,771,770,-1,740,741,771,-1,739,770,769,-1,739,740,770,-1,738,769,768,-1,738,739,769,-1,737,768,767,-1,737,738,768,-1,736,767,766,-1,736,737,767,-1,735,766,765,-1,735,736,766,-1,734,765,764,-1,734,735,765,-1,733,764,763,-1,733,734,764,-1,732,763,762,-1,732,733,763,-1,731,762,761,-1,731,732,762,-1,730,761,760,-1,730,731,761,-1,729,760,759,-1,729,730,760,-1,728,759,758,-1,728,729,759,-1,727,758,757,-1,727,728,758,-1,726,757,756,-1,726,727,757,-1,725,756,755,-1,725,726,756,-1,724,755,754,-1,724,725,755,-1,723,754,753,-1,723,724,754,-1,722,753,752,-1,722,723,753,-1,721,752,751,-1,721,722,752,-1,720,751,750,-1,720,721,751,-1,719,748,749,-1,719,718,748,-1,717,749,747,-1,717,719,749,-1,716,747,746,-1,716,717,747,-1,715,746,745,-1,715,716,746,-1,714,745,744,-1,714,715,745,-1,713,744,743,-1,713,714,744,-1,712,743,742,-1,712,713,743,-1,711,742,741,-1,711,712,742,-1,710,741,740,-1,710,711,741,-1,709,740,739,-1,709,710,740,-1,708,739,738,-1,708,709,739,-1,707,738,737,-1,707,708,738,-1,706,737,736,-1,706,707,737,-1,705,736,735,-1,705,706,736,-1,704,735,734,-1,704,705,735,-1,703,734,733,-1,703,704,734,-1,702,733,732,-1,702,703,733,-1,701,732,731,-1,701,702,732,-1,700,731,730,-1,700,701,731,-1,699,730,729,-1,699,700,730,-1,698,729,728,-1,698,699,729,-1,697,728,727,-1,697,698,728,-1,696,727,726,-1,696,697,727,-1,695,726,725,-1,695,696,726,-1,694,725,724,-1,694,695,725,-1,693,724,723,-1,693,694,724,-1,692,723,722,-1,692,693,723,-1,691,722,721,-1,691,692,722,-1,690,721,720,-1,690,691,721,-1,689,718,719,-1,689,688,718,-1,687,719,717,-1,687,689,719,-1,686,717,716,-1,686,687,717,-1,685,716,715,-1,685,686,716,-1,684,715,714,-1,684,685,715,-1,683,714,713,-1,683,684,714,-1,682,713,712,-1,682,683,713,-1,681,712,711,-1,681,682,712,-1,680,711,710,-1,680,681,711,-1,679,710,709,-1,679,680,710,-1,678,709,708,-1,678,679,709,-1,677,708,707,-1,677,678,708,-1,676,707,706,-1,676,677,707,-1,675,706,705,-1,675,676,706,-1,674,705,704,-1,674,675,705,-1,673,704,703,-1,673,674,704,-1,672,703,702,-1,672,673,703,-1,671,702,701,-1,671,672,702,-1,670,701,700,-1,670,671,701,-1,669,700,699,-1,669,670,700,-1,668,699,698,-1,668,669,699,-1,667,698,697,-1,667,668,698,-1,666,697,696,-1,666,667,697,-1,665,696,695,-1,665,666,696,-1,664,695,694,-1,664,665,695,-1,663,694,693,-1,663,664,694,-1,662,693,692,-1,662,663,693,-1,661,692,691,-1,661,662,692,-1,660,691,690,-1,660,661,691,-1,659,688,689,-1,659,658,688,-1,657,689,687,-1,657,659,689,-1,656,687,686,-1,656,657,687,-1,655,686,685,-1,655,656,686,-1,654,685,684,-1,654,655,685,-1,653,684,683,-1,653,654,684,-1,652,683,682,-1,652,653,683,-1,651,682,681,-1,651,652,682,-1,650,681,680,-1,650,651,681,-1,649,680,679,-1,649,650,680,-1,648,679,678,-1,648,649,679,-1,647,678,677,-1,647,648,678,-1,646,677,676,-1,646,647,677,-1,645,676,675,-1,645,646,676,-1,644,675,674,-1,644,645,675,-1,643,674,673,-1,643,644,674,-1,642,673,672,-1,642,643,673,-1,641,672,671,-1,641,642,672,-1,640,671,670,-1,640,641,671,-1,639,670,669,-1,639,640,670,-1,638,669,668,-1,638,639,669,-1,637,668,667,-1,637,638,668,-1,636,667,666,-1,636,637,667,-1,635,666,665,-1,635,636,666,-1,634,665,664,-1,634,635,665,-1,633,664,663,-1,633,634,664,-1,632,663,662,-1,632,633,663,-1,631,662,661,-1,631,632,662,-1,630,661,660,-1,630,631,661,-1,629,658,659,-1,629,628,658,-1,627,659,657,-1,627,629,659,-1,626,657,656,-1,626,627,657,-1,625,656,655,-1,625,626,656,-1,624,655,654,-1,624,625,655,-1,623,654,653,-1,623,624,654,-1,622,653,652,-1,622,623,653,-1,621,652,651,-1,621,622,652,-1,620,651,650,-1,620,621,651,-1,619,650,649,-1,619,620,650,-1,618,649,648,-1,618,619,649,-1,617,648,647,-1,617,618,648,-1,616,647,646,-1,616,617,647,-1,615,646,645,-1,615,616,646,-1,614,645,644,-1,614,615,645,-1,613,644,643,-1,613,614,644,-1,612,643,642,-1,612,613,643,-1,611,642,641,-1,611,612,642,-1,610,641,640,-1,610,611,641,-1,609,640,639,-1,609,610,640,-1,608,639,638,-1,608,609,639,-1,607,638,637,-1,607,608,638,-1,606,637,636,-1,606,607,637,-1,605,636,635,-1,605,606,636,-1,604,635,634,-1,604,605,635,-1,603,634,633,-1,603,604,634,-1,602,633,632,-1,602,603,633,-1,601,632,631,-1,601,602,632,-1,600,631,630,-1,600,601,631,-1,599,628,629,-1,599,598,628,-1,597,629,627,-1,597,599,629,-1,596,627,626,-1,596,597,627,-1,595,626,625,-1,595,596,626,-1,594,625,624,-1,594,595,625,-1,593,624,623,-1,593,594,624,-1,592,623,622,-1,592,593,623,-1,591,622,621,-1,591,592,622,-1,590,621,620,-1,590,591,621,-1,589,620,619,-1,589,590,620,-1,588,619,618,-1,588,589,619,-1,587,618,617,-1,587,588,618,-1,586,617,616,-1,586,587,617,-1,585,616,615,-1,585,586,616,-1,584,615,614,-1,584,585,615,-1,583,614,613,-1,583,584,614,-1,582,613,612,-1,582,583,613,-1,581,612,611,-1,581,582,612,-1,580,611,610,-1,580,581,611,-1,579,610,609,-1,579,580,610,-1,578,609,608,-1,578,579,609,-1,577,608,607,-1,577,578,608,-1,576,607,606,-1,576,577,607,-1,575,606,605,-1,575,576,606,-1,574,605,604,-1,574,575,605,-1,573,604,603,-1,573,574,604,-1,572,603,602,-1,572,573,603,-1,571,602,601,-1,571,572,602,-1,570,601,600,-1,570,571,601,-1,569,598,599,-1,569,568,598,-1,567,599,597,-1,567,569,599,-1,566,597,596,-1,566,567,597,-1,565,596,595,-1,565,566,596,-1,564,595,594,-1,564,565,595,-1,563,594,593,-1,563,564,594,-1,562,593,592,-1,562,563,593,-1,561,592,591,-1,561,562,592,-1,560,591,590,-1,560,561,591,-1,559,590,589,-1,559,560,590,-1,558,589,588,-1,558,559,589,-1,557,588,587,-1,557,558,588,-1,556,587,586,-1,556,557,587,-1,555,586,585,-1,555,556,586,-1,554,585,584,-1,554,555,585,-1,553,584,583,-1,553,554,584,-1,552,583,582,-1,552,553,583,-1,551,582,581,-1,551,552,582,-1,550,581,580,-1,550,551,581,-1,549,580,579,-1,549,550,580,-1,548,579,578,-1,548,549,579,-1,547,578,577,-1,547,548,578,-1,546,577,576,-1,546,547,577,-1,545,576,575,-1,545,546,576,-1,544,575,574,-1,544,545,575,-1,543,574,573,-1,543,544,574,-1,542,573,572,-1,542,543,573,-1,541,572,571,-1,541,542,572,-1,540,571,570,-1,540,541,571,-1,539,568,569,-1,539,538,568,-1,537,569,567,-1,537,539,569,-1,536,567,566,-1,536,537,567,-1,535,566,565,-1,535,536,566,-1,534,565,564,-1,534,535,565,-1,533,564,563,-1,533,534,564,-1,532,563,562,-1,532,533,563,-1,531,562,561,-1,531,532,562,-1,530,561,560,-1,530,531,561,-1,529,560,559,-1,529,530,560,-1,528,559,558,-1,528,529,559,-1,527,558,557,-1,527,528,558,-1,526,557,556,-1,526,527,557,-1,525,556,555,-1,525,526,556,-1,524,555,554,-1,524,525,555,-1,523,554,553,-1,523,524,554,-1,522,553,552,-1,522,523,553,-1,521,552,551,-1,521,522,552,-1,520,551,550,-1,520,521,551,-1,519,550,549,-1,519,520,550,-1,518,549,548,-1,518,519,549,-1,517,548,547,-1,517,518,548,-1,516,547,546,-1,516,517,547,-1,515,546,545,-1,515,516,546,-1,514,545,544,-1,514,515,545,-1,513,544,543,-1,513,514,544,-1,512,543,542,-1,512,513,543,-1,511,542,541,-1,511,512,542,-1,510,541,540,-1,510,511,541,-1,509,538,539,-1,509,508,538,-1,507,539,537,-1,507,509,539,-1,506,537,536,-1,506,507,537,-1,505,536,535,-1,505,506,536,-1,504,535,534,-1,504,505,535,-1,503,534,533,-1,503,504,534,-1,502,533,532,-1,502,503,533,-1,501,532,531,-1,501,502,532,-1,500,531,530,-1,500,501,531,-1,499,530,529,-1,499,500,530,-1,498,529,528,-1,498,499,529,-1,497,528,527,-1,497,498,528,-1,496,527,526,-1,496,497,527,-1,495,526,525,-1,495,496,526,-1,494,525,524,-1,494,495,525,-1,493,524,523,-1,493,494,524,-1,492,523,522,-1,492,493,523,-1,491,522,521,-1,491,492,522,-1,490,521,520,-1,490,491,521,-1,489,520,519,-1,489,490,520,-1,488,519,518,-1,488,489,519,-1,487,518,517,-1,487,488,518,-1,486,517,516,-1,486,487,517,-1,485,516,515,-1,485,486,516,-1,484,515,514,-1,484,485,515,-1,483,514,513,-1,483,484,514,-1,482,513,512,-1,482,483,513,-1,481,512,511,-1,481,482,512,-1,480,511,510,-1,480,481,511,-1,479,508,509,-1,479,478,508,-1,477,509,507,-1,477,479,509,-1,476,507,506,-1,476,477,507,-1,475,506,505,-1,475,476,506,-1,474,505,504,-1,474,475,505,-1,473,504,503,-1,473,474,504,-1,472,503,502,-1,472,473,503,-1,471,502,501,-1,471,472,502,-1,470,501,500,-1,470,471,501,-1,469,500,499,-1,469,470,500,-1,468,499,498,-1,468,469,499,-1,467,498,497,-1,467,468,498,-1,466,497,496,-1,466,467,497,-1,465,496,495,-1,465,466,496,-1,464,495,494,-1,464,465,495,-1,463,494,493,-1,463,464,494,-1,462,493,492,-1,462,463,493,-1,461,492,491,-1,461,462,492,-1,460,491,490,-1,460,461,491,-1,459,490,489,-1,459,460,490,-1,458,489,488,-1,458,459,489,-1,457,488,487,-1,457,458,488,-1,456,487,486,-1,456,457,487,-1,455,486,485,-1,455,456,486,-1,454,485,484,-1,454,455,485,-1,453,484,483,-1,453,454,484,-1,452,483,482,-1,452,453,483,-1,451,482,481,-1,451,452,482,-1,450,481,480,-1,450,451,481,-1,449,478,479,-1,449,448,478,-1,447,479,477,-1,447,449,479,-1,446,477,476,-1,446,447,477,-1,445,476,475,-1,445,446,476,-1,444,475,474,-1,444,445,475,-1,443,474,473,-1,443,444,474,-1,442,473,472,-1,442,443,473,-1,441,472,471,-1,441,442,472,-1,440,471,470,-1,440,441,471,-1,439,470,469,-1,439,440,470,-1,438,469,468,-1,438,439,469,-1,437,468,467,-1,437,438,468,-1,436,467,466,-1,436,437,467,-1,435,466,465,-1,435,436,466,-1,434,465,464,-1,434,435,465,-1,433,464,463,-1,433,434,464,-1,432,463,462,-1,432,433,463,-1,431,462,461,-1,431,432,462,-1,430,461,460,-1,430,431,461,-1,429,460,459,-1,429,430,460,-1,428,459,458,-1,428,429,459,-1,427,458,457,-1,427,428,458,-1,426,457,456,-1,426,427,457,-1,425,456,455,-1,425,426,456,-1,424,455,454,-1,424,425,455,-1,423,454,453,-1,423,424,454,-1,422,453,452,-1,422,423,453,-1,421,452,451,-1,421,422,452,-1,420,451,450,-1,420,421,451,-1,419,448,449,-1,419,418,448,-1,417,449,447,-1,417,419,449,-1,416,447,446,-1,416,417,447,-1,415,446,445,-1,415,416,446,-1,414,445,444,-1,414,415,445,-1,413,444,443,-1,413,414,444,-1,412,443,442,-1,412,413,443,-1,411,442,441,-1,411,412,442,-1,410,441,440,-1,410,411,441,-1,409,440,439,-1,409,410,440,-1,408,439,438,-1,408,409,439,-1,407,438,437,-1,407,408,438,-1,406,437,436,-1,406,407,437,-1,405,436,435,-1,405,406,436,-1,404,435,434,-1,404,405,435,-1,403,434,433,-1,403,404,434,-1,402,433,432,-1,402,403,433,-1,401,432,431,-1,401,402,432,-1,400,431,430,-1,400,401,431,-1,399,430,429,-1,399,400,430,-1,398,429,428,-1,398,399,429,-1,397,428,427,-1,397,398,428,-1,396,427,426,-1,396,397,427,-1,395,426,425,-1,395,396,426,-1,394,425,424,-1,394,395,425,-1,393,424,423,-1,393,394,424,-1,392,423,422,-1,392,393,423,-1,391,422,421,-1,391,392,422,-1,390,421,420,-1,390,391,421,-1,389,418,419,-1,389,388,418,-1,387,419,417,-1,387,389,419,-1,386,417,416,-1,386,387,417,-1,385,416,415,-1,385,386,416,-1,384,415,414,-1,384,385,415,-1,383,414,413,-1,383,384,414,-1,382,413,412,-1,382,383,413,-1,381,412,411,-1,381,382,412,-1,380,411,410,-1,380,381,411,-1,379,410,409,-1,379,380,410,-1,378,409,408,-1,378,379,409,-1,377,408,407,-1,377,378,408,-1,376,407,406,-1,376,377,407,-1,375,406,405,-1,375,376,406,-1,374,405,404,-1,374,375,405,-1,373,404,403,-1,373,374,404,-1,372,403,402,-1,372,373,403,-1,371,402,401,-1,371,372,402,-1,370,401,400,-1,370,371,401,-1,369,400,399,-1,369,370,400,-1,368,399,398,-1,368,369,399,-1,367,398,397,-1,367,368,398,-1,366,397,396,-1,366,367,397,-1,365,396,395,-1,365,366,396,-1,364,395,394,-1,364,365,395,-1,363,394,393,-1,363,364,394,-1,362,393,392,-1,362,363,393,-1,361,392,391,-1,361,362,392,-1,360,391,390,-1,360,361,391,-1,359,388,389,-1,359,358,388,-1,357,389,387,-1,357,359,389,-1,356,387,386,-1,356,357,387,-1,355,386,385,-1,355,356,386,-1,354,385,384,-1,354,355,385,-1,353,384,383,-1,353,354,384,-1,352,383,382,-1,352,353,383,-1,351,382,381,-1,351,352,382,-1,350,381,380,-1,350,351,381,-1,349,380,379,-1,349,350,380,-1,348,379,378,-1,348,349,379,-1,347,378,377,-1,347,348,378,-1,346,377,376,-1,346,347,377,-1,345,376,375,-1,345,346,376,-1,344,375,374,-1,344,345,375,-1,343,374,373,-1,343,344,374,-1,342,373,372,-1,342,343,373,-1,341,372,371,-1,341,342,372,-1,340,371,370,-1,340,341,371,-1,339,370,369,-1,339,340,370,-1,338,369,368,-1,338,339,369,-1,337,368,367,-1,337,338,368,-1,336,367,366,-1,336,337,367,-1,335,366,365,-1,335,336,366,-1,334,365,364,-1,334,335,365,-1,333,364,363,-1,333,334,364,-1,332,363,362,-1,332,333,363,-1,331,362,361,-1,331,332,362,-1,330,361,360,-1,330,331,361,-1,329,358,359,-1,329,328,358,-1,327,359,357,-1,327,329,359,-1,326,357,356,-1,326,327,357,-1,325,356,355,-1,325,326,356,-1,324,355,354,-1,324,325,355,-1,323,354,353,-1,323,324,354,-1,322,353,352,-1,322,323,353,-1,321,352,351,-1,321,322,352,-1,320,351,350,-1,320,321,351,-1,319,350,349,-1,319,320,350,-1,318,349,348,-1,318,319,349,-1,317,348,347,-1,317,318,348,-1,316,347,346,-1,316,317,347,-1,315,346,345,-1,315,316,346,-1,314,345,344,-1,314,315,345,-1,313,344,343,-1,313,314,344,-1,312,343,342,-1,312,313,343,-1,311,342,341,-1,311,312,342,-1,310,341,340,-1,310,311,341,-1,309,340,339,-1,309,310,340,-1,308,339,338,-1,308,309,339,-1,307,338,337,-1,307,308,338,-1,306,337,336,-1,306,307,337,-1,305,336,335,-1,305,306,336,-1,304,335,334,-1,304,305,335,-1,303,334,333,-1,303,304,334,-1,302,333,332,-1,302,303,333,-1,301,332,331,-1,301,302,332,-1,300,331,330,-1,300,301,331,-1,299,328,329,-1,299,298,328,-1,297,329,327,-1,297,299,329,-1,296,327,326,-1,296,297,327,-1,295,326,325,-1,295,296,326,-1,294,325,324,-1,294,295,325,-1,293,324,323,-1,293,294,324,-1,292,323,322,-1,292,293,323,-1,291,322,321,-1,291,292,322,-1,290,321,320,-1,290,291,321,-1,289,320,319,-1,289,290,320,-1,288,319,318,-1,288,289,319,-1,287,318,317,-1,287,288,318,-1,286,317,316,-1,286,287,317,-1,285,316,315,-1,285,286,316,-1,284,315,314,-1,284,285,315,-1,283,314,313,-1,283,284,314,-1,282,313,312,-1,282,283,313,-1,281,312,311,-1,281,282,312,-1,280,311,310,-1,280,281,311,-1,279,310,309,-1,279,280,310,-1,278,309,308,-1,278,279,309,-1,277,308,307,-1,277,278,308,-1,276,307,306,-1,276,277,307,-1,275,306,305,-1,275,276,306,-1,274,305,304,-1,274,275,305,-1,273,304,303,-1,273,274,304,-1,272,303,302,-1,272,273,303,-1,271,302,301,-1,271,272,302,-1,270,301,300,-1,270,271,301,-1,269,298,299,-1,269,268,298,-1,267,299,297,-1,267,269,299,-1,266,297,296,-1,266,267,297,-1,265,296,295,-1,265,266,296,-1,264,295,294,-1,264,265,295,-1,263,294,293,-1,263,264,294,-1,262,293,292,-1,262,263,293,-1,261,292,291,-1,261,262,292,-1,260,291,290,-1,260,261,291,-1,259,290,289,-1,259,260,290,-1,258,289,288,-1,258,259,289,-1,257,288,287,-1,257,258,288,-1,256,287,286,-1,256,257,287,-1,255,286,285,-1,255,256,286,-1,254,285,284,-1,254,255,285,-1,253,284,283,-1,253,254,284,-1,252,283,282,-1,252,253,283,-1,251,282,281,-1,251,252,282,-1,250,281,280,-1,250,251,281,-1,249,280,279,-1,249,250,280,-1,248,279,278,-1,248,249,279,-1,247,278,277,-1,247,248,278,-1,246,277,276,-1,246,247,277,-1,245,276,275,-1,245,246,276,-1,244,275,274,-1,244,245,275,-1,243,274,273,-1,243,244,274,-1,242,273,272,-1,242,243,273,-1,241,272,271,-1,241,242,272,-1,240,271,270,-1,240,241,271,-1,239,268,269,-1,239,238,268,-1,237,269,267,-1,237,239,269,-1,236,267,266,-1,236,237,267,-1,235,266,265,-1,235,236,266,-1,234,265,264,-1,234,235,265,-1,233,264,263,-1,233,234,264,-1,232,263,262,-1,232,233,263,-1,231,262,261,-1,231,232,262,-1,230,261,260,-1,230,231,261,-1,229,260,259,-1,229,230,260,-1,228,259,258,-1,228,229,259,-1,227,258,257,-1,227,228,258,-1,226,257,256,-1,226,227,257,-1,225,256,255,-1,225,226,256,-1,224,255,254,-1,224,225,255,-1,223,254,253,-1,223,224,254,-1,222,253,252,-1,222,223,253,-1,221,252,251,-1,221,222,252,-1,220,251,250,-1,220,221,251,-1,219,250,249,-1,219,220,250,-1,218,249,248,-1,218,219,249,-1,217,248,247,-1,217,218,248,-1,216,247,246,-1,216,217,247,-1,215,246,245,-1,215,216,246,-1,214,245,244,-1,214,215,245,-1,213,244,243,-1,213,214,244,-1,212,243,242,-1,212,213,243,-1,211,242,241,-1,211,212,242,-1,210,241,240,-1,210,211,241,-1,209,238,239,-1,209,208,238,-1,207,239,237,-1,207,209,239,-1,206,237,236,-1,206,207,237,-1,205,236,235,-1,205,206,236,-1,204,235,234,-1,204,205,235,-1,203,234,233,-1,203,204,234,-1,202,233,232,-1,202,203,233,-1,201,232,231,-1,201,202,232,-1,200,231,230,-1,200,201,231,-1,199,230,229,-1,199,200,230,-1,198,229,228,-1,198,199,229,-1,197,228,227,-1,197,198,228,-1,196,227,226,-1,196,197,227,-1,195,226,225,-1,195,196,226,-1,194,225,224,-1,194,195,225,-1,193,224,223,-1,193,194,224,-1,192,223,222,-1,192,193,223,-1,191,222,221,-1,191,192,222,-1,190,221,220,-1,190,191,221,-1,189,220,219,-1,189,190,220,-1,188,219,218,-1,188,189,219,-1,187,218,217,-1,187,188,218,-1,186,217,216,-1,186,187,217,-1,185,216,215,-1,185,186,216,-1,184,215,214,-1,184,185,215,-1,183,214,213,-1,183,184,214,-1,182,213,212,-1,182,183,213,-1,181,212,211,-1,181,182,212,-1,180,211,210,-1,180,181,211,-1,179,208,209,-1,179,178,208,-1,177,209,207,-1,177,179,209,-1,176,207,206,-1,176,177,207,-1,175,206,205,-1,175,176,206,-1,174,205,204,-1,174,175,205,-1,173,204,203,-1,173,174,204,-1,172,203,202,-1,172,173,203,-1,171,202,201,-1,171,172,202,-1,170,201,200,-1,170,171,201,-1,169,200,199,-1,169,170,200,-1,168,199,198,-1,168,169,199,-1,167,198,197,-1,167,168,198,-1,166,197,196,-1,166,167,197,-1,165,196,195,-1,165,166,196,-1,164,195,194,-1,164,165,195,-1,163,194,193,-1,163,164,194,-1,162,193,192,-1,162,163,193,-1,161,192,191,-1,161,162,192,-1,160,191,190,-1,160,161,191,-1,159,190,189,-1,159,160,190,-1,158,189,188,-1,158,159,189,-1,157,188,187,-1,157,158,188,-1,156,187,186,-1,156,157,187,-1,155,186,185,-1,155,156,186,-1,154,185,184,-1,154,155,185,-1,153,184,183,-1,153,154,184,-1,152,183,182,-1,152,153,183,-1,151,182,181,-1,151,152,182,-1,150,181,180,-1,150,151,181,-1,149,178,179,-1,149,148,178,-1,147,179,177,-1,147,149,179,-1,146,177,176,-1,146,147,177,-1,145,176,175,-1,145,146,176,-1,144,175,174,-1,144,145,175,-1,143,174,173,-1,143,144,174,-1,142,173,172,-1,142,143,173,-1,141,172,171,-1,141,142,172,-1,140,171,170,-1,140,141,171,-1,139,170,169,-1,139,140,170,-1,138,169,168,-1,138,139,169,-1,137,168,167,-1,137,138,168,-1,136,167,166,-1,136,137,167,-1,135,166,165,-1,135,136,166,-1,134,165,164,-1,134,135,165,-1,133,164,163,-1,133,134,164,-1,132,163,162,-1,132,133,163,-1,131,162,161,-1,131,132,162,-1,130,161,160,-1,130,131,161,-1,129,160,159,-1,129,130,160,-1,128,159,158,-1,128,129,159,-1,127,158,157,-1,127,128,158,-1,126,157,156,-1,126,127,157,-1,125,156,155,-1,125,126,156,-1,124,155,154,-1,124,125,155,-1,123,154,153,-1,123,124,154,-1,122,153,152,-1,122,123,153,-1,121,152,151,-1,121,122,152,-1,120,151,150,-1,120,121,151,-1,119,148,149,-1,119,118,148,-1,117,149,147,-1,117,119,149,-1,116,147,146,-1,116,117,147,-1,115,146,145,-1,115,116,146,-1,114,145,144,-1,114,115,145,-1,113,144,143,-1,113,114,144,-1,112,143,142,-1,112,113,143,-1,111,142,141,-1,111,112,142,-1,110,141,140,-1,110,111,141,-1,109,140,139,-1,109,110,140,-1,108,139,138,-1,108,109,139,-1,107,138,137,-1,107,108,138,-1,106,137,136,-1,106,107,137,-1,105,136,135,-1,105,106,136,-1,104,135,134,-1,104,105,135,-1,103,134,133,-1,103,104,134,-1,102,133,132,-1,102,103,133,-1,101,132,131,-1,101,102,132,-1,100,131,130,-1,100,101,131,-1,99,130,129,-1,99,100,130,-1,98,129,128,-1,98,99,129,-1,97,128,127,-1,97,98,128,-1,96,127,126,-1,96,97,127,-1,95,126,125,-1,95,96,126,-1,94,125,124,-1,94,95,125,-1,93,124,123,-1,93,94,124,-1,92,123,122,-1,92,93,123,-1,91,122,121,-1,91,92,122,-1,90,121,120,-1,90,91,121,-1,89,118,119,-1,89,88,118,-1,87,119,117,-1,87,89,119,-1,86,117,116,-1,86,87,117,-1,85,116,115,-1,85,86,116,-1,84,115,114,-1,84,85,115,-1,83,114,113,-1,83,84,114,-1,82,113,112,-1,82,83,113,-1,81,112,111,-1,81,82,112,-1,80,111,110,-1,80,81,111,-1,79,110,109,-1,79,80,110,-1,78,109,108,-1,78,79,109,-1,77,108,107,-1,77,78,108,-1,76,107,106,-1,76,77,107,-1,75,106,105,-1,75,76,106,-1,74,105,104,-1,74,75,105,-1,73,104,103,-1,73,74,104,-1,72,103,102,-1,72,73,103,-1,71,102,101,-1,71,72,102,-1,70,101,100,-1,70,71,101,-1,69,100,99,-1,69,70,100,-1,68,99,98,-1,68,69,99,-1,67,98,97,-1,67,68,98,-1,66,97,96,-1,66,67,97,-1,65,96,95,-1,65,66,96,-1,64,95,94,-1,64,65,95,-1,63,94,93,-1,63,64,94,-1,62,93,92,-1,62,63,93,-1,61,92,91,-1,61,62,92,-1,60,91,90,-1,60,61,91,-1,59,88,89,-1,59,58,88,-1,57,89,87,-1,57,59,89,-1,56,87,86,-1,56,57,87,-1,55,86,85,-1,55,56,86,-1,54,85,84,-1,54,55,85,-1,53,84,83,-1,53,54,84,-1,52,83,82,-1,52,53,83,-1,51,82,81,-1,51,52,82,-1,50,81,80,-1,50,51,81,-1,49,80,79,-1,49,50,80,-1,48,79,78,-1,48,49,79,-1,47,78,77,-1,47,48,78,-1,46,77,76,-1,46,47,77,-1,45,76,75,-1,45,46,76,-1,44,75,74,-1,44,45,75,-1,43,74,73,-1,43,44,74,-1,42,73,72,-1,42,43,73,-1,41,72,71,-1,41,42,72,-1,40,71,70,-1,40,41,71,-1,39,70,69,-1,39,40,70,-1,38,69,68,-1,38,39,69,-1,37,68,67,-1,37,38,68,-1,36,67,66,-1,36,37,67,-1,35,66,65,-1,35,36,66,-1,34,65,64,-1,34,35,65,-1,33,64,63,-1,33,34,64,-1,32,63,62,-1,32,33,63,-1,31,62,61,-1,31,32,62,-1,30,61,60,-1,30,31,61,-1,29,58,59,-1,29,28,58,-1,27,59,57,-1,27,29,59,-1,26,57,56,-1,26,27,57,-1,25,56,55,-1,25,26,56,-1,24,55,54,-1,24,25,55,-1,23,54,53,-1,23,24,54,-1,22,53,52,-1,22,23,53,-1,21,52,51,-1,21,22,52,-1,20,51,50,-1,20,21,51,-1,19,50,49,-1,19,20,50,-1,18,49,48,-1,18,19,49,-1,17,48,47,-1,17,18,48,-1,16,47,46,-1,16,17,47,-1,15,46,45,-1,15,16,46,-1,14,45,44,-1,14,15,45,-1,13,44,43,-1,13,14,44,-1,12,43,42,-1,12,13,43,-1,11,42,41,-1,11,12,42,-1,10,41,40,-1,10,11,41,-1,9,40,39,-1,9,10,40,-1,8,39,38,-1,8,9,39,-1,7,38,37,-1,7,8,38,-1,6,37,36,-1,6,7,37,-1,5,36,35,-1,5,6,36,-1,4,35,34,-1,4,5,35,-1,3,34,33,-1,3,4,34,-1,2,33,32,-1,2,3,33,-1,1,32,31,-1,1,2,32,-1,0,31,30,-1,0,1,31,-1],
        texCoord=TextureCoordinate(point=[(0.00901068,0.008865899),(0.04283266,0.0088666845),(0.07665464,0.008867471),(0.11047663,0.008868257),(0.14429861,0.008869043),(0.1781206,0.008869828),(0.21194258,0.008870615),(0.24576455,0.0088714),(0.27958652,0.008872186),(0.31340852,0.008872972),(0.3472305,0.008873758),(0.3810525,0.008874544),(0.41487446,0.00887533),(0.44869646,0.008876116),(0.48251843,0.008876903),(0.51634043,0.008877689),(0.5501624,0.008878475),(0.5839844,0.008879261),(0.6178064,0.008880047),(0.6516284,0.008880834),(0.6854503,0.008881621),(0.7192723,0.008882408),(0.7530943,0.008883195),(0.7869163,0.008883981),(0.82073826,0.008884768),(0.85456026,0.008885555),(0.88838226,0.008886342),(0.92220426,0.00888713),(0.9898482,0.008888704),(0.9560262,0.008887917),(0.009009896,0.04268788),(0.042831875,0.042688668),(0.07665386,0.042689454),(0.11047584,0.042690236),(0.14429782,0.042691026),(0.17811981,0.04269181),(0.2119418,0.042692594),(0.24576378,0.04269338),(0.27958575,0.042694166),(0.31340775,0.042694952),(0.34722972,0.04269574),(0.3810517,0.042696524),(0.4148737,0.04269731),(0.44869566,0.042698096),(0.48251766,0.042698883),(0.51633966,0.042699672),(0.5501616,0.04270046),(0.5839836,0.042701244),(0.6178056,0.04270203),(0.65162754,0.042702816),(0.68544954,0.042703602),(0.71927154,0.04270439),(0.75309354,0.04270518),(0.7869155,0.042705964),(0.8207375,0.04270675),(0.8545595,0.042707536),(0.8883815,0.042708326),(0.9222034,0.042709112),(0.9898474,0.042710688),(0.9560254,0.0427099),(0.009009111,0.07650986),(0.04283109,0.076510645),(0.07665308,0.076511435),(0.110475056,0.07651222),(0.14429705,0.07651301),(0.17811902,0.07651379),(0.211941,0.07651458),(0.24576299,0.07651536),(0.27958497,0.07651615),(0.31340694,0.076516934),(0.34722894,0.07651772),(0.3810509,0.076518506),(0.4148729,0.076519296),(0.44869488,0.07652008),(0.48251686,0.07652087),(0.5163388,0.07652165),(0.5501608,0.07652244),(0.5839828,0.07652322),(0.61780477,0.07652401),(0.65162677,0.0765248),(0.68544877,0.076525584),(0.71927077,0.07652637),(0.7530927,0.076527156),(0.7869147,0.076527946),(0.8207367,0.076528735),(0.8545587,0.07652952),(0.8883807,0.07653031),(0.92220265,0.0765311),(0.98984665,0.07653267),(0.95602465,0.07653188),(0.009008326,0.11033184),(0.04283031,0.11033263),(0.07665229,0.11033341),(0.11047427,0.1103342),(0.14429626,0.110334985),(0.17811824,0.110335775),(0.21194023,0.11033656),(0.24576221,0.11033735),(0.2795842,0.11033813),(0.31340617,0.11033892),(0.34722814,0.1103397),(0.38105014,0.11034049),(0.4148721,0.11034127),(0.4486941,0.11034206),(0.48251608,0.110342845),(0.51633805,0.110343635),(0.55016005,0.110344425),(0.58398205,0.11034521),(0.617804,0.110346),(0.651626,0.11034678),(0.685448,0.11034757),(0.71927,0.11034835),(0.75309193,0.11034914),(0.78691393,0.11034993),(0.82073593,0.11035071),(0.85455793,0.1103515),(0.8883799,0.11035229),(0.9222019,0.110353075),(0.9898459,0.110354654),(0.9560239,0.110353865),(0.0090075405,0.14415382),(0.042829525,0.14415461),(0.076651506,0.1441554),(0.11047349,0.14415619),(0.14429547,0.14415696),(0.17811745,0.14415775),(0.21193944,0.14415854),(0.24576142,0.14415933),(0.2795834,0.1441601),(0.3134054,0.1441609),(0.34722736,0.14416169),(0.38104936,0.14416248),(0.41487134,0.14416327),(0.4486933,0.14416404),(0.4825153,0.14416483),(0.5163373,0.14416562),(0.5501593,0.14416641),(0.5839812,0.14416718),(0.6178032,0.14416797),(0.6516252,0.14416876),(0.6854472,0.14416955),(0.71926916,0.14417033),(0.75309116,0.14417112),(0.78691316,0.14417191),(0.82073516,0.1441727),(0.8545571,0.14417349),(0.8883791,0.14417428),(0.9222011,0.14417505),(0.98984504,0.14417663),(0.9560231,0.14417584),(0.009006755,0.1779758),(0.042828735,0.1779766),(0.076650724,0.17797738),(0.11047271,0.17797816),(0.1442947,0.17797895),(0.17811668,0.17797974),(0.21193866,0.17798053),(0.24576065,0.17798132),(0.27958262,0.17798209),(0.31340462,0.17798288),(0.3472266,0.17798367),(0.38104856,0.17798446),(0.41487056,0.17798524),(0.44869253,0.17798603),(0.48251453,0.17798682),(0.5163365,0.1779876),(0.5501585,0.17798838),(0.58398044,0.17798917),(0.61780244,0.17798996),(0.65162444,0.17799075),(0.6854464,0.17799152),(0.7192684,0.17799231),(0.7530904,0.1779931),(0.7869124,0.1779939),(0.8207343,0.17799468),(0.8545563,0.17799547),(0.8883783,0.17799625),(0.9222003,0.17799704),(0.98984426,0.17799862),(0.9560223,0.17799783),(0.009005966,0.21179779),(0.042827953,0.21179858),(0.076649934,0.21179937),(0.11047192,0.21180014),(0.1442939,0.21180093),(0.17811589,0.21180172),(0.21193787,0.21180251),(0.24575986,0.21180329),(0.27958184,0.21180408),(0.31340382,0.21180487),(0.34722582,0.21180566),(0.3810478,0.21180643),(0.4148698,0.21180722),(0.44869176,0.21180801),(0.48251373,0.2118088),(0.5163357,0.21180958),(0.5501577,0.21181037),(0.58397967,0.21181116),(0.61780167,0.21181194),(0.65162367,0.21181273),(0.6854456,0.21181351),(0.7192676,0.2118143),(0.7530896,0.21181509),(0.7869116,0.21181588),(0.82073355,0.21181667),(0.85455555,0.21181744),(0.88837755,0.21181823),(0.92219955,0.21181902),(0.9898435,0.2118206),(0.9560215,0.21181981),(0.009005181,0.24561977),(0.042827167,0.24562056),(0.07664915,0.24562134),(0.11047113,0.24562213),(0.14429311,0.24562292),(0.1781151,0.24562371),(0.21193708,0.24562448),(0.24575907,0.24562527),(0.27958107,0.24562606),(0.31340304,0.24562685),(0.347225,0.24562763),(0.381047,0.24562842),(0.41486898,0.2456292),(0.44869098,0.24563),(0.48251295,0.24563077),(0.51633495,0.24563156),(0.5501569,0.24563235),(0.5839789,0.24563314),(0.6178009,0.24563393),(0.65162283,0.2456347),(0.68544483,0.2456355),(0.71926683,0.24563628),(0.75308883,0.24563707),(0.7869108,0.24563786),(0.8207328,0.24563864),(0.8545548,0.24563943),(0.8883768,0.24564022),(0.9221987,0.24564101),(0.9898427,0.24564259),(0.9560207,0.2456418),(0.009004396,0.27944174),(0.042826377,0.27944255),(0.07664836,0.27944332),(0.11047035,0.2794441),(0.14429232,0.2794449),(0.17811431,0.27944568),(0.21193631,0.27944648),(0.2457583,0.27944726),(0.27958027,0.27944803),(0.31340227,0.27944884),(0.34722424,0.2794496),(0.3810462,0.2794504),(0.4148682,0.2794512),(0.44869018,0.27945197),(0.48251218,0.27945277),(0.5163342,0.27945355),(0.5501561,0.27945432),(0.5839781,0.27945513),(0.6178001,0.2794559),(0.65162206,0.2794567),(0.68544406,0.27945748),(0.71926606,0.27945825),(0.753088,0.27945906),(0.78691,0.27945983),(0.820732,0.27946064),(0.854554,0.2794614),(0.88837594,0.2794622),(0.92219794,0.279463),(0.98984194,0.27946457),(0.95601994,0.27946377),(0.009003607,0.31326374),(0.04282559,0.31326452),(0.07664758,0.3132653),(0.11046956,0.3132661),(0.14429154,0.31326687),(0.17811352,0.31326768),(0.21193552,0.31326845),(0.2457575,0.31326923),(0.2795795,0.31327003),(0.31340146,0.3132708),(0.34722346,0.3132716),(0.38104543,0.3132724),(0.41486743,0.31327316),(0.4486894,0.31327397),(0.48251137,0.31327474),(0.51633334,0.31327552),(0.55015534,0.31327632),(0.58397734,0.3132771),(0.6177993,0.3132779),(0.6516213,0.31327868),(0.6854433,0.31327945),(0.7192653,0.31328025),(0.7530872,0.31328103),(0.7869092,0.31328183),(0.8207312,0.3132826),(0.8545532,0.31328338),(0.88837516,0.3132842),(0.92219716,0.31328496),(0.98984116,0.31328654),(0.95601916,0.31328577),(0.0090028215,0.3470857),(0.0428248,0.3470865),(0.07664679,0.3470873),(0.110468775,0.34708807),(0.14429076,0.34708887),(0.17811275,0.34708965),(0.21193473,0.34709042),(0.24575672,0.34709123),(0.2795787,0.347092),(0.3134007,0.34709278),(0.34722266,0.34709358),(0.38104466,0.34709436),(0.41486663,0.34709516),(0.44868863,0.34709594),(0.4825106,0.3470967),(0.51633257,0.34709752),(0.55015457,0.3470983),(0.58397657,0.3470991),(0.6177985,0.34709987),(0.6516205,0.34710065),(0.6854425,0.34710145),(0.71926445,0.34710222),(0.75308645,0.34710303),(0.78690845,0.3471038),(0.82073045,0.34710458),(0.8545524,0.34710538),(0.8883744,0.34710616),(0.9221964,0.34710696),(0.9898403,0.34710854),(0.9560184,0.34710774),(0.009002032,0.38090768),(0.042824015,0.3809085),(0.076646,0.38090926),(0.110467985,0.38091007),(0.14428997,0.38091084),(0.17811196,0.38091162),(0.21193394,0.38091242),(0.24575593,0.3809132),(0.2795779,0.380914),(0.31339988,0.38091478),(0.34722188,0.38091555),(0.38104385,0.38091636),(0.41486585,0.38091713),(0.44868782,0.3809179),(0.48250982,0.3809187),(0.5163318,0.3809195),(0.5501538,0.3809203),(0.58397573,0.38092107),(0.61779773,0.38092184),(0.65161973,0.38092265),(0.6854417,0.38092342),(0.7192637,0.38092422),(0.7530857,0.380925),(0.7869077,0.38092577),(0.8207296,0.38092658),(0.8545516,0.38092735),(0.8883736,0.38092816),(0.9221956,0.38092893),(0.98983955,0.3809305),(0.95601755,0.38092974),(0.009001247,0.41472968),(0.042823225,0.41473046),(0.07664521,0.41473126),(0.110467196,0.41473204),(0.14428918,0.4147328),(0.17811117,0.41473362),(0.21193315,0.4147344),(0.24575514,0.41473517),(0.2795771,0.41473597),(0.3133991,0.41473675),(0.34722108,0.41473755),(0.38104308,0.41473833),(0.41486505,0.4147391),(0.44868705,0.4147399),(0.48250902,0.41474068),(0.516331,0.4147415),(0.550153,0.41474226),(0.58397496,0.41474304),(0.61779696,0.41474384),(0.65161896,0.41474462),(0.6854409,0.41474542),(0.7192629,0.4147462),(0.7530849,0.41474697),(0.78690684,0.41474777),(0.82072884,0.41474855),(0.85455084,0.41474935),(0.88837284,0.41475013),(0.92219484,0.41475093),(0.9898388,0.41475248),(0.9560168,0.4147517),(0.009000457,0.44855165),(0.042822443,0.44855246),(0.07664443,0.44855323),(0.110466406,0.448554),(0.14428839,0.4485548),(0.17811038,0.4485556),(0.21193236,0.4485564),(0.24575435,0.44855717),(0.27957633,0.44855794),(0.3133983,0.44855875),(0.3472203,0.44855952),(0.38104227,0.4485603),(0.41486427,0.4485611),(0.44868627,0.44856188),(0.48250824,0.44856268),(0.51633024,0.44856346),(0.5501522,0.44856423),(0.5839742,0.44856504),(0.6177962,0.4485658),(0.6516181,0.44856662),(0.6854401,0.4485674),(0.7192621,0.44856817),(0.7530841,0.44856897),(0.78690606,0.44856974),(0.82072806,0.44857055),(0.85455006,0.44857132),(0.88837206,0.44857213),(0.922194,0.4485729),(0.989838,0.44857448),(0.956016,0.44857368),(0.008999667,0.48237365),(0.042821653,0.48237443),(0.07664364,0.4823752),(0.11046562,0.482376),(0.1442876,0.48237678),(0.17810959,0.48237756),(0.21193157,0.48237836),(0.24575356,0.48237914),(0.27957556,0.48237994),(0.31339753,0.48238072),(0.34721953,0.4823815),(0.3810415,0.4823823),(0.41486347,0.48238307),(0.44868547,0.48238388),(0.48250747,0.48238465),(0.51632947,0.48238543),(0.5501514,0.48238623),(0.5839734,0.482387),(0.6177954,0.4823878),(0.65161735,0.4823886),(0.68543935,0.48238936),(0.71926135,0.48239017),(0.7530833,0.48239094),(0.7869053,0.48239174),(0.8207273,0.48239252),(0.8545493,0.48239332),(0.8883712,0.4823941),(0.9221932,0.48239487),(0.9898372,0.48239645),(0.9560152,0.48239568),(0.008998877,0.5161956),(0.042820867,0.5161964),(0.07664285,0.5161972),(0.11046483,0.516198),(0.14428681,0.51619875),(0.1781088,0.5161995),(0.21193078,0.51620036),(0.24575277,0.51620114),(0.27957475,0.5162019),(0.31339675,0.5162027),(0.34721872,0.51620346),(0.38104072,0.5162043),(0.4148627,0.5162051),(0.4486847,0.51620585),(0.48250666,0.5162066),(0.51632863,0.5162074),(0.55015063,0.51620823),(0.58397263,0.516209),(0.6177946,0.5162098),(0.6516166,0.51621056),(0.6854386,0.51621133),(0.7192606,0.51621217),(0.7530825,0.51621294),(0.7869045,0.5162137),(0.8207265,0.5162145),(0.8545485,0.51621526),(0.88837045,0.5162161),(0.92219245,0.5162169),(0.98983645,0.5162184),(0.95601445,0.51621765),(0.008998092,0.5500176),(0.04282008,0.55001837),(0.07664206,0.5500192),(0.110464044,0.55002),(0.14428604,0.55002075),(0.178108,0.5500215),(0.21192999,0.5500223),(0.24575198,0.55002314),(0.27957398,0.5500239),(0.31339595,0.5500247),(0.34721795,0.55002546),(0.38103992,0.55002624),(0.41486192,0.5500271),(0.4486839,0.55002785),(0.4825059,0.5500286),(0.51632786,0.5500294),(0.55014986,0.5500302),(0.5839718,0.550031),(0.6177938,0.5500318),(0.6516158,0.55003256),(0.6854378,0.55003333),(0.71925974,0.5500341),(0.75308174,0.55003494),(0.78690374,0.5500357),(0.82072574,0.5500365),(0.8545477,0.55003726),(0.8883697,0.55003804),(0.9221917,0.5500389),(0.9898356,0.5500404),(0.9560137,0.55003965),(0.008997307,0.5838396),(0.04281929,0.58384037),(0.07664128,0.58384115),(0.11046326,0.5838419),(0.14428525,0.58384275),(0.17810723,0.5838435),(0.2119292,0.5838443),(0.24575119,0.5838451),(0.27957317,0.58384585),(0.31339517,0.5838467),(0.34721714,0.58384746),(0.38103914,0.58384824),(0.4148611,0.583849),(0.4486831,0.5838498),(0.48250508,0.5838506),(0.5163271,0.5838514),(0.5501491,0.5838522),(0.583971,0.58385295),(0.617793,0.5838537),(0.651615,0.58385456),(0.68543696,0.58385533),(0.71925896,0.5838561),(0.75308096,0.5838569),(0.78690296,0.58385766),(0.8207249,0.5838585),(0.8545469,0.58385926),(0.8883689,0.58386004),(0.9221909,0.5838608),(0.98983485,0.5838624),(0.95601285,0.58386165),(0.008996522,0.6176616),(0.04281851,0.6176624),(0.076640494,0.61766315),(0.11046247,0.6176639),(0.14428446,0.6176647),(0.17810644,0.6176655),(0.21192843,0.6176663),(0.24575041,0.6176671),(0.2795724,0.61766785),(0.31339437,0.6176686),(0.34721637,0.61766946),(0.38103834,0.61767024),(0.41486034,0.617671),(0.4486823,0.6176718),(0.4825043,0.61767256),(0.5163263,0.6176734),(0.55014825,0.6176742),(0.58397025,0.61767495),(0.61779225,0.6176757),(0.6516142,0.6176765),(0.6854362,0.61767733),(0.7192582,0.6176781),(0.7530802,0.6176789),(0.7869021,0.61767966),(0.8207241,0.61768043),(0.8545461,0.61768126),(0.8883681,0.61768204),(0.92219007,0.6176828),(0.9898341,0.61768436),(0.95601207,0.6176836),(0.008995737,0.65148354),(0.042817723,0.6514843),(0.076639704,0.65148515),(0.11046169,0.6514859),(0.14428367,0.6514867),(0.17810565,0.65148747),(0.21192764,0.65148824),(0.24574962,0.6514891),(0.2795716,0.65148985),(0.3133936,0.6514906),(0.34721556,0.6514914),(0.38103756,0.6514922),(0.41485953,0.651493),(0.44868153,0.6514938),(0.4825035,0.65149456),(0.5163255,0.65149534),(0.5501475,0.6514961),(0.5839695,0.65149695),(0.6177915,0.6514977),(0.6516134,0.6514985),(0.6854354,0.6514993),(0.7192574,0.65150005),(0.7530794,0.6515009),(0.78690135,0.65150166),(0.82072335,0.65150243),(0.85454535,0.6515032),(0.88836735,0.65150404),(0.9221893,0.6515048),(0.9898333,0.65150636),(0.9560113,0.6515056),(0.008994953,0.68530554),(0.042816933,0.6853063),(0.076638915,0.6853071),(0.1104609,0.6853079),(0.14428288,0.6853087),(0.17810486,0.68530947),(0.21192685,0.68531024),(0.24574883,0.685311),(0.27957082,0.68531185),(0.3133928,0.6853126),(0.3472148,0.6853134),(0.38103676,0.6853142),(0.41485876,0.68531495),(0.44868073,0.6853158),(0.48250273,0.68531656),(0.5163247,0.68531734),(0.5501467,0.6853181),(0.5839687,0.6853189),(0.61779064,0.6853197),(0.65161264,0.6853205),(0.68543464,0.6853213),(0.71925664,0.68532205),(0.7530786,0.6853228),(0.7869006,0.68532366),(0.8207226,0.68532443),(0.8545446,0.6853252),(0.8883665,0.685326),(0.9221885,0.68532676),(0.9898325,0.68532836),(0.9560105,0.6853276),(0.008994163,0.71912754),(0.042816147,0.7191283),(0.07663813,0.7191291),(0.11046011,0.71912986),(0.1442821,0.71913064),(0.17810407,0.71913147),(0.21192606,0.71913224),(0.24574804,0.719133),(0.27957004,0.7191338),(0.313392,0.71913457),(0.34721398,0.7191354),(0.38103598,0.7191362),(0.41485795,0.71913695),(0.44867995,0.7191377),(0.48250192,0.7191385),(0.5163239,0.71913934),(0.5501459,0.7191401),(0.58396786,0.7191409),(0.61778986,0.71914166),(0.65161186,0.71914244),(0.68543386,0.7191433),(0.7192558,0.71914405),(0.7530778,0.7191448),(0.7868998,0.7191456),(0.8207218,0.71914643),(0.85454375,0.7191472),(0.88836575,0.719148),(0.92218775,0.71914876),(0.9898317,0.71915036),(0.95600975,0.71914953),(0.008993378,0.7529495),(0.042815357,0.7529503),(0.07663734,0.7529511),(0.11045933,0.75295186),(0.14428131,0.75295264),(0.17810328,0.7529534),(0.21192527,0.75295424),(0.24574725,0.752955),(0.27956924,0.7529558),(0.31339124,0.75295657),(0.3472132,0.75295734),(0.38103518,0.7529582),(0.41485718,0.75295895),(0.44867915,0.7529597),(0.48250115,0.7529605),(0.51632315,0.7529613),(0.5501451,0.7529621),(0.5839671,0.7529629),(0.6177891,0.75296366),(0.6516111,0.75296444),(0.6854331,0.7529652),(0.71925503,0.75296605),(0.75307703,0.7529668),(0.78689903,0.7529676),(0.82072103,0.7529684),(0.854543,0.75296915),(0.888365,0.75297),(0.922187,0.75297076),(0.9898309,0.7529723),(0.956009,0.75297153),(0.008992588,0.7867715),(0.04281457,0.78677225),(0.07663655,0.786773),(0.11045854,0.78677386),(0.14428052,0.78677464),(0.17810251,0.7867754),(0.21192448,0.7867762),(0.24574646,0.78677696),(0.27956846,0.7867778),(0.31339043,0.78677857),(0.34721243,0.78677934),(0.3810344,0.7867801),(0.4148564,0.7867809),(0.44867837,0.7867817),(0.48250034,0.7867825),(0.5163224,0.7867833),(0.5501443,0.78678405),(0.5839663,0.7867849),(0.6177883,0.78678566),(0.6516103,0.78678644),(0.68543226,0.7867872),(0.71925426,0.786788),(0.75307626,0.7867888),(0.78689826,0.7867896),(0.8207202,0.7867904),(0.8545422,0.78679115),(0.8883642,0.7867919),(0.9221862,0.78679276),(0.98983014,0.7867943),(0.95600814,0.78679353),(0.008991798,0.8205935),(0.04281378,0.82059425),(0.07663577,0.820595),(0.11045775,0.8205958),(0.14427973,0.82059664),(0.17810172,0.8205974),(0.2119237,0.8205982),(0.24574567,0.82059896),(0.27956766,0.82059973),(0.31338966,0.82060057),(0.34721163,0.82060134),(0.38103363,0.8206021),(0.4148556,0.8206029),(0.4486776,0.82060367),(0.48249957,0.8206045),(0.51632154,0.8206053),(0.55014354,0.82060605),(0.58396554,0.8206068),(0.61778754,0.8206076),(0.6516095,0.82060844),(0.6854315,0.8206092),(0.7192535,0.82061),(0.7530755,0.82061076),(0.7868974,0.82061154),(0.8207194,0.8206124),(0.8545414,0.82061315),(0.8883634,0.8206139),(0.92218536,0.8206147),(0.98982936,0.8206163),(0.95600736,0.82061553),(0.008991008,0.8544155),(0.042812992,0.85441625),(0.07663498,0.854417),(0.110456966,0.8544178),(0.14427894,0.8544186),(0.17810093,0.85441935),(0.21192291,0.8544202),(0.2457449,0.85442096),(0.27956688,0.85442173),(0.31338885,0.8544225),(0.34721085,0.8544233),(0.38103282,0.8544241),(0.41485482,0.8544249),(0.4486768,0.85442567),(0.4824988,0.85442644),(0.51632077,0.8544273),(0.55014277,0.85442805),(0.58396477,0.8544288),(0.6177867,0.8544296),(0.6516087,0.8544304),(0.6854307,0.8544312),(0.7192527,0.854432),(0.75307465,0.85443276),(0.78689665,0.85443354),(0.82071865,0.8544343),(0.85454065,0.85443515),(0.8883626,0.8544359),(0.9221846,0.8544367),(0.9898286,0.8544383),(0.9560066,0.8544375),(0.0089902235,0.8882374),(0.04281221,0.8882382),(0.07663419,0.888239),(0.110456176,0.8882398),(0.14427815,0.8882406),(0.17810014,0.88824135),(0.21192212,0.8882421),(0.24574411,0.88824296),(0.27956608,0.88824373),(0.31338808,0.8882445),(0.34721005,0.8882453),(0.38103205,0.88824606),(0.41485402,0.8882469),(0.44867602,0.88824767),(0.482498,0.88824844),(0.51632,0.8882492),(0.550142,0.88825),(0.58396393,0.8882508),(0.61778593,0.8882516),(0.65160793,0.8882524),(0.68542993,0.88825315),(0.7192519,0.888254),(0.7530739,0.88825476),(0.7868959,0.88825554),(0.8207179,0.8882563),(0.8545399,0.8882571),(0.8883618,0.8882579),(0.9221838,0.8882587),(0.9898278,0.88826025),(0.9560058,0.8882595),(0.008989434,0.9220594),(0.042811424,0.9220602),(0.07663341,0.92206097),(0.11045539,0.9220618),(0.14427738,0.9220626),(0.17809935,0.92206335),(0.21192133,0.9220641),(0.24574332,0.9220649),(0.2795653,0.9220657),(0.31338727,0.9220665),(0.34720927,0.9220673),(0.38103124,0.92206806),(0.41485325,0.92206883),(0.44867522,0.92206967),(0.48249722,0.92207044),(0.5163192,0.9220712),(0.55014116,0.922072),(0.58396316,0.92207277),(0.61778516,0.9220736),(0.65160716,0.9220744),(0.6854291,0.92207515),(0.7192511,0.9220759),(0.7530731,0.9220767),(0.7868951,0.92207754),(0.8207171,0.9220783),(0.85453904,0.9220791),(0.88836104,0.92207986),(0.92218304,0.9220807),(0.989827,0.92208225),(0.95600504,0.9220815),(0.008987864,0.98970336),(0.008988649,0.9558814),(0.042809848,0.9897042),(0.042810634,0.9558822),(0.07663184,0.98970497),(0.07663262,0.95588297),(0.11045382,0.98970574),(0.110454604,0.95588374),(0.1442758,0.9897065),(0.14427659,0.9558845),(0.17809778,0.9897073),(0.17809857,0.95588535),(0.21191977,0.9897081),(0.21192054,0.9558861),(0.24574174,0.9897089),(0.24574253,0.9558869),(0.27956372,0.9897097),(0.2795645,0.9558877),(0.3133857,0.98971045),(0.3133865,0.95588845),(0.3472077,0.9897112),(0.34720847,0.9558893),(0.38102967,0.98971206),(0.38103047,0.95589006),(0.41485167,0.98971283),(0.41485244,0.95589083),(0.44867364,0.9897136),(0.44867444,0.9558916),(0.48249564,0.9897144),(0.4824964,0.9558924),(0.5163176,0.98971516),(0.5163184,0.9558932),(0.5501396,0.989716),(0.5501404,0.955894),(0.5839616,0.98971677),(0.5839624,0.95589477),(0.6177836,0.98971754),(0.6177844,0.95589554),(0.65160555,0.9897183),(0.6516063,0.9558964),(0.68542755,0.9897191),(0.6854283,0.95589715),(0.71924955,0.9897199),(0.7192503,0.9558979),(0.75307155,0.9897207),(0.7530723,0.9558987),(0.7868935,0.9897215),(0.7868943,0.9558995),(0.8207155,0.98972225),(0.82071626,0.9559003),(0.8545375,0.9897231),(0.85453826,0.9559011),(0.8883595,0.98972386),(0.88836026,0.95590186),(0.9221814,0.98972464),(0.92218226,0.95590264),(0.9898262,0.95590425),(0.9560034,0.9897254),(0.9898254,0.9897262),(0.9560042,0.9559034)]),
        coord=Coordinate(DEF='OBJECT-25-VERTICES',point=[(-454.11624,2.6765575,446.15088),(-424.10724,2.3767297,446.4165),(-394.09827,2.3815615,446.68195),(-364.08926,2.0814517,446.94754),(-334.08032,2.0860014,447.21298),(-304.07132,1.7856096,447.4786),(-274.06235,1.7898772,447.74405),(-244.05336,1.4892033,448.00964),(-214.04437,1.1883885,448.27527),(-184.03542,1.192233,448.5407),(-154.02644,0.89113605,448.80634),(-124.01746,0.58989805,449.07196),(-94.00849,0.28851902,449.3376),(-63.999554,0.29179943,449.603),(-33.99062,0.2949388,449.86844),(-3.9816575,-0.006863306,450.13406),(26.0273,-0.30880642,450.39966),(56.036255,-0.61089057,450.66528),(86.045204,-0.9131158,450.9309),(116.05412,-0.91068155,451.19635),(146.06305,-0.9083884,451.46176),(176.07196,-0.90623623,451.7272),(206.08089,-0.9042251,451.99265),(236.0898,-0.902355,452.25806),(266.09872,-1.2054263,452.52368),(296.10764,-1.2038383,452.78912),(326.11655,-1.2023913,453.05453),(356.12546,-0.8962849,453.3198),(386.13437,-0.89511997,453.5852),(416.14325,-0.894096,453.85065),(-453.85083,2.6576862,416.1419),(-423.8418,2.3578587,416.40753),(-393.83286,2.3626904,416.67297),(-363.82382,2.0625806,416.9386),(-333.81488,2.0671303,417.20404),(-303.80588,1.7667385,417.46967),(-273.7969,1.7710061,417.73508),(-243.78792,1.4703323,418.0007),(-213.77898,1.4743178,418.26614),(-183.76999,1.1733619,418.53177),(-153.761,0.872265,418.7974),(-123.75203,0.571027,419.06302),(-93.74309,0.5744484,419.32846),(-63.73412,0.2729284,419.5941),(-33.725155,-0.02873268,419.8597),(-3.7162232,-0.02573434,420.12512),(26.292734,-0.32767746,420.39075),(56.30169,-0.62976164,420.65637),(86.31064,-0.9319868,420.922),(116.31956,-0.92955256,421.18744),(146.32848,-0.9272594,421.45288),(176.3374,-0.92510724,421.7183),(206.34631,-0.9230961,421.98373),(236.35522,-0.92122597,422.24918),(266.36417,-1.2242974,422.5148),(296.37308,-1.2227093,422.7802),(326.382,-1.2212623,423.04565),(356.3909,-1.2199563,423.3111),(386.39978,-0.9139909,423.57632),(416.4087,-0.91296697,423.84177),(-453.5854,2.6386735,386.13297),(-423.5764,2.338846,386.3986),(-393.5674,2.3436775,386.66403),(-363.5584,2.043568,386.92966),(-333.54944,2.0481176,387.19507),(-303.54044,1.7477258,387.46072),(-273.5315,1.7519934,387.72614),(-243.52249,1.4513196,387.99176),(-213.51353,1.4553051,388.2572),(-183.50455,1.1543492,388.52283),(-153.4956,1.1580527,388.78827),(-123.486626,0.85681474,389.0539),(-93.47765,0.5554357,389.31952),(-63.468716,0.5587161,389.58496),(-33.45975,0.25705507,389.8506),(-3.4507873,-0.04474701,390.1162),(26.55817,-0.34669012,390.38184),(56.567123,-0.64877427,390.64746),(86.57607,-0.95099944,390.9131),(116.58499,-0.94856524,391.17853),(146.59392,-0.946272,391.44397),(176.60283,-0.9441199,391.70938),(206.61176,-0.9421087,391.97482),(236.62067,-0.9402386,392.24026),(266.6296,-1.24331,392.5059),(296.63852,-1.2417219,392.77133),(326.64743,-1.2402749,393.03674),(356.65634,-1.2389688,393.3022),(386.66522,-1.2378039,393.56763),(416.67413,-0.9319796,393.83286),(-453.31995,2.6195192,356.124),(-423.31097,2.624492,356.38943),(-393.30197,2.3245232,356.65506),(-363.29297,2.0244136,356.9207),(-333.284,2.028963,357.18613),(-303.275,1.7285714,357.45175),(-273.26605,1.732839,357.7172),(-243.2571,1.7369657,357.98264),(-213.24811,1.4361508,358.24826),(-183.23915,1.4399953,358.5137),(-153.23016,1.1388984,358.77933),(-123.22119,0.8376604,359.04495),(-93.21225,0.84108186,359.3104),(-63.203278,0.5395618,359.57602),(-33.194313,0.23790076,359.84164),(-3.1853778,0.24089912,360.1071),(26.823582,-0.061043993,360.3727),(56.832535,-0.36312813,360.63834),(86.841484,-0.6653533,360.904),(116.85043,-0.9677195,361.16962),(146.85936,-0.9654263,361.43506),(176.86827,-0.9632741,361.70047),(206.87718,-0.961263,361.9659),(236.88611,-0.95939285,362.23135),(266.89502,-1.2624642,362.49698),(296.90393,-1.2608762,362.76242),(326.91284,-1.2594291,363.02786),(356.92175,-1.2581232,363.29327),(386.93066,-1.2569581,363.55872),(416.93958,-1.2559342,363.82416),(-453.0545,2.600223,326.11505),(-423.04553,2.605196,326.3805),(-393.03653,2.3052273,326.64612),(-363.02756,2.309918,326.91156),(-333.01855,2.0096672,327.1772),(-303.0096,2.0140758,327.44263),(-273.0006,1.713543,327.70825),(-242.99165,1.7176696,327.9737),(-212.9827,1.7216552,328.23914),(-182.97371,1.4206994,328.50476),(-152.96477,1.4244028,328.7702),(-122.95579,1.1231649,329.03583),(-92.94681,0.82178587,329.30145),(-62.93784,0.5202659,329.5671),(-32.9289,0.52340525,329.83252),(-2.9199386,0.22160317,330.09818),(27.08902,-0.08033992,330.3638),(57.097977,-0.38242406,330.62943),(87.1069,-0.37984878,330.89487),(117.11585,-0.682215,331.1605),(147.12479,-0.9847222,331.42615),(177.13371,-0.98257005,331.69156),(207.14264,-1.2853593,331.9572),(237.15157,-1.2834892,332.22263),(267.16046,-1.2817601,332.48807),(297.16937,-1.280172,332.7535),(327.17828,-1.278725,333.01895),(357.1872,-1.277419,333.2844),(387.1961,-1.276254,333.54984),(417.20502,-1.27523,333.81528),(-452.78906,2.5807855,296.10608),(-422.78006,2.280958,296.3717),(-392.7711,2.2857895,296.63715),(-362.76212,2.2904804,296.9026),(-332.75317,2.2950299,297.16803),(-302.74417,1.9946382,297.43365),(-272.7352,1.9989059,297.6991),(-242.72626,2.0030324,297.96454),(-212.7173,2.007018,298.22998),(-182.70831,1.7060621,298.4956),(-152.69933,1.4049652,298.76126),(-122.690346,1.1037272,299.0269),(-92.681404,1.1071488,299.29233),(-62.67243,0.8056287,299.55795),(-32.66346,0.50396764,299.8236),(-2.6544979,0.2021656,300.08923),(27.354435,0.20502293,300.35468),(57.36339,-0.09706119,300.6203),(87.372345,-0.39928636,300.88596),(117.38129,-0.7016525,301.15158),(147.39023,-1.0041597,301.41724),(177.39915,-1.0020076,301.68265),(207.40807,-0.9999964,301.9481),(237.41698,-0.99812627,302.21353),(267.4259,-1.3011976,302.4792),(297.4348,-1.2996095,302.7446),(327.44373,-1.2981625,303.01004),(357.45264,-1.2968565,303.27548),(387.46155,-1.2956915,303.54092),(417.47046,-1.2946676,303.80637),(-452.5236,2.2564058,266.09732),(-422.51462,2.2613785,266.36276),(-392.50565,2.2662103,266.6282),(-362.49667,2.270901,266.89365),(-332.48773,2.2754507,267.1591),(-302.47876,2.2798593,267.42453),(-272.46976,1.9793266,267.69016),(-242.4608,1.9834532,267.9556),(-212.45186,1.9874388,268.22104),(-182.44287,1.6864829,268.48666),(-152.43391,1.6901864,268.7521),(-122.424934,1.3889484,269.01776),(-92.41596,1.0875695,269.2834),(-62.406986,0.7860495,269.54904),(-32.39805,0.78918886,269.81448),(-2.3890834,0.48738682,270.0801),(27.619877,0.18544373,270.34576),(57.628834,-0.11664038,270.6114),(87.63779,-0.41886553,270.87704),(117.64673,-0.7212317,271.14267),(147.65565,-0.71893847,271.4081),(177.66458,-0.7167863,271.67355),(207.67351,-1.0195756,271.93918),(237.68243,-1.0177054,272.20462),(267.69135,-1.3207768,272.47028),(297.70026,-1.3191887,272.73572),(327.70917,-1.3177416,273.00116),(357.71808,-1.3164356,273.2666),(387.727,-1.3152707,273.53204),(417.7359,-1.3142467,273.7975),(-452.25812,2.2366848,236.08836),(-422.24918,2.2416577,236.3538),(-392.2402,2.2464893,236.61925),(-362.2312,1.9463797,236.88489),(-332.22223,1.9509294,237.15033),(-302.2133,1.955338,237.41577),(-272.2043,1.9596057,237.68121),(-242.19536,1.9637322,237.94666),(-212.18642,1.9677179,238.2121),(-182.17746,1.9715624,238.47754),(-152.16847,1.6704655,238.74318),(-122.15949,1.3692276,239.00882),(-92.15051,1.0678487,239.27446),(-62.141575,1.0711291,239.5399),(-32.132603,0.769468,239.80554),(-2.1236393,0.46766597,240.07118),(27.885294,0.47052333,240.33662),(57.894253,0.16843921,240.60228),(87.903206,-0.13378593,240.86792),(117.91218,-0.74095255,241.13376),(147.9211,-0.7386593,241.3992),(177.93004,-1.0413076,241.66484),(207.93895,-1.0392964,241.93028),(237.94788,-1.0374262,242.19572),(267.9568,-1.3404975,242.46136),(297.9657,-1.3389095,242.7268),(327.9746,-1.3374624,242.99225),(357.98352,-1.3361564,243.25769),(387.99243,-1.3349915,243.52313),(418.00134,-1.3339674,243.78857),(-451.99268,2.2168224,206.0794),(-421.98367,1.9169947,206.34505),(-391.9747,1.9218264,206.61049),(-361.96576,1.9265171,206.87593),(-331.9568,1.9310669,207.14137),(-301.9478,1.9354755,207.40683),(-271.93887,1.9397432,207.67227),(-241.92992,1.9438698,207.93771),(-211.92096,1.9478554,208.20316),(-181.91202,1.9517,208.4686),(-151.90303,1.650603,208.73424),(-121.89404,1.3493651,208.99988),(-91.8851,1.3527865,209.26532),(-61.87613,1.0512666,209.53098),(-31.867159,0.74960554,209.79662),(-1.8582215,0.75260395,210.06206),(28.15074,0.45066085,210.32771),(58.1597,0.14857675,210.59335),(88.16865,-0.15364839,210.859),(118.17762,-0.76081496,211.12485),(148.18657,-1.0633222,211.39049),(178.19548,-1.06117,211.65593),(208.2044,-1.0591588,211.92137),(238.21332,-1.0572886,212.18683),(268.22226,-1.36036,212.45247),(298.23117,-1.3587719,212.71791),(328.24005,-1.3573248,212.98335),(358.24896,-1.3560188,213.2488),(388.25787,-1.3548537,213.51424),(418.26678,-1.3538299,213.77968),(-451.72717,1.8920176,176.07065),(-421.71823,1.8969904,176.33609),(-391.70926,1.9018222,176.60155),(-361.70026,1.6017126,176.86719),(-331.69128,1.6062622,177.13263),(-301.68234,1.6106709,177.39807),(-271.67337,1.6149386,177.66353),(-241.66443,1.6190652,177.92897),(-211.65547,1.6230508,178.19441),(-181.64653,1.6268953,178.45985),(-151.63757,1.6305989,178.7253),(-121.6286,1.329361,178.99095),(-91.61962,1.027982,179.25659),(-61.61068,1.0312624,179.52203),(-31.601711,0.72960144,179.78769),(-1.5927743,0.73259985,180.05313),(28.416187,0.43065676,180.31879),(58.425144,0.12857266,180.58443),(88.4341,-0.17365247,180.85008),(118.44307,-0.78081906,181.11594),(148.45201,-1.0833262,181.38158),(178.46094,-1.081174,181.64703),(208.46985,-1.0791628,181.91248),(238.47878,-1.3820932,182.17812),(268.4877,-1.3803641,182.44356),(298.4966,-1.378776,182.70901),(328.50552,-1.3773289,182.97446),(358.51443,-1.3760228,183.2399),(388.52332,-1.3748578,183.50534),(418.53223,-1.3738339,183.77078),(-451.46173,1.8718718,146.06169),(-421.45273,1.5720443,146.32735),(-391.44376,1.5768759,146.59279),(-361.4348,1.5815667,146.85825),(-331.42584,1.5861164,147.12369),(-301.4169,1.5905252,147.38913),(-271.40793,1.5947927,147.65457),(-241.39899,1.5989194,147.92003),(-211.38998,1.2981045,148.18567),(-181.38104,1.3019491,148.45113),(-151.3721,1.3056527,148.71657),(-121.36315,1.3092152,148.98201),(-91.35417,1.0078362,149.24767),(-61.34523,1.0111167,149.5131),(-31.336262,0.70945567,149.77876),(-1.3273252,0.7124541,150.0442),(28.681637,0.41051102,150.30986),(58.690594,0.10842692,150.57552),(88.69955,-0.1937982,150.84116),(118.70852,-0.8009648,151.10703),(148.71745,-1.103472,151.37267),(178.72638,-1.1013198,151.63812),(208.73529,-1.0993086,151.90356),(238.74423,-1.4022388,152.16922),(268.75314,-1.4005097,152.43466),(298.76205,-1.3989216,152.7001),(328.77097,-1.3974745,152.96556),(358.77988,-1.3961685,153.231),(388.7888,-1.3950036,153.49644),(418.79767,-1.3939795,153.7619),(-451.19623,1.5467839,116.05295),(-421.1873,1.5517567,116.3184),(-391.1783,1.5565885,116.58384),(-361.1693,1.2564789,116.849495),(-331.16034,1.2610285,117.114944),(-301.1514,1.2654372,117.380394),(-271.14246,1.2697049,117.645836),(-241.13348,1.2738316,117.911285),(-211.12454,1.2778171,118.176735),(-181.11555,0.9768613,118.44239),(-151.10661,0.98056483,118.70783),(-121.097664,0.98412734,118.97328),(-91.08872,0.9875488,119.23873),(-61.07975,0.6860289,119.50439),(-31.070812,0.68916833,119.76984),(-1.0618746,0.6921667,120.03528),(28.947086,0.39022365,120.300934),(58.956043,0.08813956,120.56659),(88.965,-0.21408556,120.832245),(118.97397,-0.8212521,121.09811),(148.98291,-1.1237593,121.36376),(178.99184,-1.1216071,121.62921),(209.00075,-1.1195959,121.89466),(239.00967,-1.4225261,122.16031),(269.0186,-1.420797,122.42576),(299.0275,-1.4192089,122.69121),(329.0364,-1.4177618,122.95666),(359.04532,-1.4164559,123.22211),(389.05423,-1.7200912,123.48776),(419.06314,-1.7190672,123.753204),(-450.9308,1.5263548,86.04399),(-420.92178,1.2265272,86.30965),(-390.9128,1.231359,86.575096),(-360.90387,1.2360498,86.840546),(-330.8949,1.2405995,87.105995),(-300.88596,1.2450082,87.371445),(-270.87695,0.9444754,87.6371),(-240.868,0.9486021,87.90255),(-210.85905,0.95258766,88.168),(-180.8501,0.9564323,88.43345),(-150.84116,0.9601358,88.6989),(-120.832214,0.9636983,88.96435),(-90.823235,0.6623194,89.23),(-60.814297,0.6655999,89.49545),(-30.805359,0.66873926,89.7609),(-0.7963944,0.36693725,90.026566),(29.21254,0.36979464,90.292015),(59.221497,0.067710556,90.55767),(89.23048,-0.539315,90.82353),(119.23942,-0.8416811,91.089195),(149.24837,-1.1441883,91.35485),(179.25728,-1.1420361,91.6203),(209.2662,-1.1400249,91.88575),(239.27513,-1.4429551,92.151405),(269.28406,-1.441226,92.416855),(299.29297,-1.4396379,92.682304),(329.30188,-1.4381908,92.947754),(359.31076,-1.4368848,93.2132),(389.3197,-1.7405201,93.47887),(419.32858,-1.7394962,93.744316),(-450.66528,1.2009836,56.035248),(-420.6563,1.2059565,56.300697),(-390.64737,1.2107882,56.566147),(-360.63837,0.9106786,56.83181),(-330.6294,0.91522837,57.09726),(-300.62045,0.9196371,57.36271),(-270.6115,0.9239047,57.628162),(-240.60254,0.9280314,57.893612),(-210.59355,0.6272166,58.15927),(-180.58461,0.63106114,58.42472),(-150.57567,0.63476473,58.690174),(-120.56673,0.63832724,58.955624),(-90.557785,0.6417487,59.221073),(-60.548843,0.6450292,59.486526),(-30.539875,0.3433682,59.752186),(-0.53094053,0.3463666,60.01764),(29.477993,0.349224,60.28309),(59.48695,0.047139924,60.548748),(89.495926,-0.5598856,60.81462),(119.504875,-0.86225176,61.08028),(149.51381,-1.1647589,61.34594),(179.52274,-1.1626067,61.611393),(209.53168,-1.4653959,61.877052),(239.54059,-1.4635258,62.142506),(269.5495,-1.4617966,62.407955),(299.5584,-1.4602084,62.67341),(329.56732,-1.4587613,62.938858),(359.57623,-1.7622558,63.204517),(389.58514,-1.7610908,63.46997),(419.59406,-1.7600667,63.73542),(-450.39978,0.8754709,26.026506),(-420.3908,0.8804437,26.291958),(-390.38187,0.8852755,26.55741),(-360.3729,0.88996625,26.822863),(-330.36395,0.894516,27.088314),(-300.35495,0.5941243,27.353977),(-270.346,0.59839195,27.61943),(-240.33705,0.6025186,27.884882),(-210.32811,0.60650426,28.150333),(-180.31915,0.6103488,28.415787),(-150.31021,0.6140524,28.681238),(-120.30127,0.6176149,28.946692),(-90.2923,0.31623602,29.212355),(-60.283356,0.31951648,29.477808),(-30.27442,0.32265592,29.74326),(-0.26548502,0.32565433,30.008713),(29.743475,0.0237113,30.274376),(59.75243,-0.27837276,30.54004),(89.76138,-0.5805979,30.805704),(119.77033,-0.882964,31.071367),(149.77927,-1.1854712,31.337032),(179.7882,-1.183319,31.602484),(209.79712,-1.4861082,31.868149),(239.80605,-1.4842379,32.133602),(269.81494,-1.4825088,32.39905),(299.82385,-1.4809207,32.664505),(329.83276,-1.4794736,32.92996),(359.8417,-1.7829679,33.19562),(389.8506,-1.7818029,33.461075),(419.8595,-1.7807789,33.72653),(-450.13428,0.5498165,-3.9822328),(-420.12537,0.8595897,-3.7169924),(-390.1164,0.86442155,-3.4515386),(-360.1074,0.56431186,-3.185872),(-330.09845,0.5688616,-2.9204185),(-300.0895,0.5732703,-2.6549647),(-270.0805,0.2727376,-2.389298),(-240.07155,0.27686423,-2.1238444),(-210.0626,0.28084987,-1.8583905),(-180.05367,0.28469446,-1.5929366),(-150.04472,0.28839803,-1.3274827),(-120.03578,0.29196057,-1.0620289),(-90.02684,0.29538208,-0.7965749),(-60.0179,0.29866254,-0.5311209),(-30.008934,-0.0029984198,-0.26545405),(0.0,0.0,0.0),(30.008959,-0.30194303,0.26566687),(60.017914,-0.6040271,0.53133374),(90.02684,-0.60145175,0.79678786),(120.03579,-0.9038179,1.0624548),(150.04472,-1.206325,1.3281217),(180.05365,-1.2041728,1.593576),(210.06256,-1.2021616,1.8590302),(240.0715,-1.5050918,2.1246972),(270.0804,-1.5033627,2.3901515),(300.08932,-1.5017745,2.6556058),(330.09824,-1.5003275,2.9210603),(360.10715,-1.8038218,3.1867273),(390.11606,-1.8026568,3.4521818),(420.12497,-1.8016328,3.7176363),(-449.8688,0.5288208,-33.991184),(-419.8599,0.8385941,-33.72594),(-389.8509,0.5386255,-33.460274),(-359.84195,0.54331625,-33.194817),(-329.83298,0.547866,-32.929363),(-299.824,0.2474743,-32.663692),(-269.81503,0.25174198,-32.39824),(-239.80609,0.25586864,-32.132782),(-209.7971,-0.04494614,-31.867113),(-179.78821,0.26369888,-31.601871),(-149.77927,0.26740244,-31.336416),(-119.77029,-0.033835426,-31.070745),(-89.761345,-0.030413913,-30.80529),(-59.75241,-0.02713343,-30.539835),(-29.743446,-0.3287944,-30.274164),(0.26548663,-0.32579598,-30.008709),(30.274445,-0.627739,-29.74304),(60.28337,-0.62502265,-29.477583),(90.29232,-0.9272477,-29.211914),(120.30125,-0.9248134,-28.946459),(150.31018,-1.2273206,-28.680788),(180.3191,-1.2251683,-28.415333),(210.32805,-1.5279576,-28.149662),(240.33696,-1.5260873,-27.884207),(270.34586,-1.5243582,-27.61875),(300.35477,-1.52277,-27.353294),(330.36368,-1.521323,-27.08784),(360.37262,-1.8248173,-26.822168),(390.3815,-1.8236523,-26.556713),(420.3904,-1.8226283,-26.291256),(-449.60336,0.5076836,-64.00013),(-419.5944,0.5126564,-63.734676),(-389.58545,0.51748824,-63.46922),(-359.57648,0.522179,-63.203762),(-329.56747,0.22192834,-62.93809),(-299.55853,0.22633706,-62.672634),(-269.54953,-0.07419566,-62.40696),(-239.54059,-0.070069,-62.141502),(-209.53165,-0.066083364,-61.876045),(-179.5227,-0.062238757,-61.610588),(-149.51376,-0.05853518,-61.345135),(-119.50482,-0.05497263,-61.079678),(-89.49586,-0.35635152,-60.814003),(-59.48692,-0.35307103,-60.548546),(-29.477985,-0.3499316,-60.28309),(0.53097486,-0.6517336,-60.017414),(30.539904,-0.6488762,-59.751957),(60.54886,-0.9509602,-59.486286),(90.557785,-0.9483849,-59.22083),(120.56673,-1.250751,-58.955154),(150.57565,-1.2484577,-58.689697),(180.58456,-1.2463055,-58.42424),(210.5935,-1.5490947,-58.158566),(240.60242,-1.5472244,-57.89311),(270.61133,-1.5454953,-57.62765),(300.62024,-1.5439072,-57.362194),(330.62915,-1.8472605,-57.096523),(360.63806,-1.8459544,-56.831062),(390.64697,-1.8447894,-56.565605),(420.65588,-1.8437654,-56.300148),(-449.3379,0.48640466,-94.00909),(-419.32892,0.4913775,-93.74362),(-389.31998,0.49620932,-93.478165),(-359.31097,0.1960997,-93.212494),(-329.30203,0.20064946,-92.94703),(-299.29303,-0.099742234,-92.68136),(-269.2841,-0.095474534,-92.4159),(-239.27513,-0.09134786,-92.15044),(-209.26619,-0.08736222,-91.88498),(-179.2572,-0.38831803,-91.61931),(-149.24828,-0.38461444,-91.35384),(-119.23933,-0.3810519,-91.08839),(-89.23039,-0.37763035,-90.82293),(-59.221428,-0.6791503,-90.55725),(-29.212494,-0.67601085,-90.291794),(0.7964369,-0.6730124,-90.02634),(30.805393,-0.9749554,-89.76066),(60.81432,-0.972239,-89.4952),(90.823265,-1.2744641,-89.22952),(120.83219,-1.2720298,-88.964066),(150.84111,-1.2697365,-88.69861),(180.85002,-1.2675842,-88.43315),(210.85896,-1.5703734,-88.16747),(240.86787,-1.5685033,-87.902016),(270.8768,-1.566774,-87.63655),(300.8857,-1.8699863,-87.37088),(330.89462,-1.8685392,-87.105415),(360.90353,-1.8672332,-86.83996),(390.91245,-1.8660681,-86.5745),(420.92133,-1.865044,-86.309044),(-449.07242,0.46498412,-124.018036),(-419.06348,0.46995696,-123.75257),(-389.0545,0.47478878,-123.487114),(-359.0455,0.17467918,-123.221436),(-329.03656,0.17922895,-122.95598),(-299.02756,-0.12116274,-122.6903),(-269.01862,-0.116895035,-122.424835),(-239.00963,-0.41756877,-122.15916),(-209.00069,-0.41358313,-121.8937),(-178.99174,-0.4097385,-121.628235),(-148.98277,-0.71083534,-121.36256),(-118.97383,-0.70727277,-121.0971),(-88.9649,-0.7038513,-120.831635),(-58.955963,-0.70057076,-120.56618),(-28.947,-1.0022317,-120.3005),(1.0619284,-0.99923325,-120.03504),(31.070856,-0.99637586,-119.76958),(61.079807,-1.2984599,-119.5039),(91.08873,-1.2958845,-119.23844),(121.09766,-1.2934502,-118.97298),(151.10657,-1.2911569,-118.70752),(181.11551,-1.5938051,-118.44184),(211.12442,-1.5917938,-118.17638),(241.13335,-1.5899236,-117.91092),(271.14224,-1.5881945,-117.645454),(301.15118,-1.8914068,-117.379776),(331.1601,-1.8899596,-117.11432),(361.169,-1.8886535,-116.848854),(391.1779,-1.8874885,-116.5834),(421.1868,-1.8864645,-116.31793),(-448.80695,0.44342196,-154.02698),(-418.79794,0.1435944,-153.7613),(-388.789,0.14842622,-153.49583),(-358.78003,0.15311702,-153.23038),(-328.77106,-0.14713362,-152.96469),(-298.7621,-0.14272489,-152.69923),(-268.7531,-0.4432576,-152.43355),(-238.74417,-0.4391309,-152.16809),(-208.73518,-0.73994565,-151.9024),(-178.72624,-0.73610103,-151.63695),(-148.7173,-0.73239744,-151.37149),(-118.70837,-0.72883487,-151.10602),(-88.6994,-1.0302138,-150.84035),(-58.690468,-1.0269333,-150.57487),(-28.681536,-1.0237938,-150.30942),(1.3274214,-1.3255957,-150.04373),(31.336348,-1.3227383,-149.77827),(61.345272,-1.320022,-149.51282),(91.354195,-1.3174466,-149.24734),(121.36312,-1.3150122,-148.98189),(151.37206,-1.6175194,-148.7162),(181.38098,-1.6153672,-148.45074),(211.3899,-1.6133559,-148.18529),(241.3988,-1.6114857,-147.91982),(271.40775,-1.9145569,-147.65414),(301.41666,-1.9129688,-147.38867),(331.42554,-1.9115217,-147.12321),(361.43445,-1.9102155,-146.85776),(391.44336,-2.213851,-146.59207),(421.45227,-2.212827,-146.3266),(-448.54144,0.11691773,-184.0357),(-418.53247,0.12189059,-183.77025),(-388.52353,0.12672243,-183.50479),(-358.51453,-0.17338718,-183.2391),(-328.50558,-0.16883741,-182.97363),(-298.49658,-0.46922907,-182.70795),(-268.4876,-0.7697618,-182.44228),(-238.47865,-0.7656351,-182.1768),(-208.46971,-0.7616494,-181.91135),(-178.46074,-1.0626053,-181.64566),(-148.4518,-1.0589017,-181.38019),(-118.44286,-1.0553391,-181.11473),(-88.43393,-1.0519176,-180.84927),(-58.425,-1.048637,-180.5838),(-28.41604,-1.3502979,-180.31812),(1.5928884,-1.3472995,-180.05266),(31.601814,-1.344442,-179.78719),(61.61074,-1.3417257,-179.52173),(91.61969,-1.6439507,-179.25604),(121.62861,-1.6415163,-178.99059),(151.63753,-1.6392231,-178.72511),(181.64644,-1.6370708,-178.45966),(211.65536,-1.6350596,-178.19418),(241.66429,-1.9379897,-177.9285),(271.6732,-1.9362606,-177.66304),(301.6821,-1.9346724,-177.39757),(331.691,-1.9332253,-177.13211),(361.69992,-2.2367196,-176.86642),(391.70883,-2.2355545,-176.60097),(421.71774,-2.2345304,-176.3355),(-448.27597,0.09507229,-214.04466),(-418.26697,-0.20475526,-213.77898),(-388.25803,-0.19992341,-213.5135),(-358.24905,-0.1952326,-213.24805),(-328.24008,-0.49548325,-212.98236),(-298.23108,-0.7958749,-212.71667),(-268.22214,-0.7916072,-212.4512),(-238.21315,-1.0922809,-212.18552),(-208.20421,-1.0882952,-211.92004),(-178.19527,-1.0844506,-211.65459),(-148.1863,-1.3855474,-211.3889),(-118.17737,-1.3819848,-211.12343),(-88.168434,-1.3785633,-210.85797),(-58.1595,-1.3752828,-210.5925),(-28.150572,-1.3721433,-210.32704),(1.858357,-1.3691448,-210.06157),(31.86731,-1.6710879,-209.79588),(61.876232,-1.6683714,-209.53043),(91.885155,-1.665796,-209.26495),(121.89407,-1.6633617,-208.99948),(151.903,-1.6610684,-208.73402),(181.91191,-1.6589161,-208.46855),(211.92085,-1.9617053,-208.20287),(241.92976,-1.959835,-207.93741),(271.93866,-1.9581059,-207.67194),(301.94757,-1.9565177,-207.40648),(331.9565,-2.259871,-207.14078),(361.9654,-2.258565,-206.87532),(391.9743,-2.2573998,-206.60985),(421.98322,-2.2563758,-206.34439),(-448.01047,-0.2317152,-244.05339),(-418.0015,-0.22674233,-243.78792),(-387.9925,-0.52671087,-243.52223),(-357.98355,-0.5220201,-243.25676),(-327.97455,-0.8222707,-242.99107),(-297.9656,-0.817862,-242.7256),(-267.95663,-1.1183946,-242.45992),(-237.94768,-1.114268,-242.19444),(-207.9387,-1.4150827,-241.92876),(-177.92976,-1.4112381,-241.66328),(-147.92082,-1.4075345,-241.39783),(-117.911896,-1.4039719,-241.13235),(-87.90296,-1.4005502,-240.86688),(-57.89403,-1.3972697,-240.60143),(-27.885073,-1.6989307,-240.33574),(2.1238549,-1.6959323,-240.07027),(32.13278,-1.6930748,-239.8048),(62.141705,-1.6903584,-239.53934),(92.15063,-1.687783,-239.27386),(122.159546,-1.6853486,-239.00839),(152.16849,-1.9878558,-238.7427),(182.1774,-1.9857035,-238.47723),(212.18631,-1.9836922,-238.21178),(242.19522,-1.981822,-237.9463),(272.20413,-1.9800928,-237.68083),(302.21307,-2.283305,-237.41515),(332.22195,-2.281858,-237.14967),(362.23087,-2.280552,-236.88422),(392.23978,-2.2793868,-236.61874),(422.2487,-2.2783628,-236.35327),(-447.74493,-0.5586443,-274.0621),(-417.736,-0.5536714,-273.79663),(-387.72702,-0.54883957,-273.53116),(-357.71802,-0.8489492,-273.26547),(-327.70908,-0.8443994,-273.0),(-297.7001,-1.144791,-272.7343),(-267.69116,-1.1405233,-272.46884),(-237.68217,-1.441197,-272.20316),(-207.67323,-1.4372114,-271.93768),(-177.66429,-1.4333667,-271.6722),(-147.65532,-1.7344635,-271.40652),(-117.64639,-1.7309009,-271.14105),(-87.63746,-1.7274793,-270.87558),(-57.62853,-1.7241988,-270.6101),(-27.6196,-1.7210593,-270.34464),(2.3893266,-1.7180609,-270.0792),(32.39825,-1.7152034,-269.81372),(62.4072,-2.0172875,-269.548),(92.41612,-2.014712,-269.28256),(122.42504,-2.0122776,-269.0171),(152.43396,-2.0099843,-268.75162),(182.44287,-2.007832,-268.48615),(212.4518,-2.3106213,-268.22046),(242.46071,-2.308751,-267.955),(272.46964,-2.3070219,-267.6895),(302.47855,-2.3054335,-267.42404),(332.48743,-2.3039865,-267.15857),(362.49634,-2.3026803,-266.8931),(392.50525,-2.3015153,-266.62762),(422.51416,-2.300491,-266.36218),(-447.4794,-0.88571507,-304.07083),(-417.47046,-0.8807422,-303.80536),(-387.46152,-0.87591034,-303.5399),(-357.45255,-0.8712195,-303.2744),(-327.44357,-1.1714702,-303.00873),(-297.43463,-1.1670613,-302.74326),(-267.42563,-1.467594,-302.47754),(-237.4167,-1.4634674,-302.2121),(-207.40771,-1.7642821,-301.94638),(-177.39879,-1.7604374,-301.6809),(-147.38985,-1.7567338,-301.41544),(-117.38088,-2.0579717,-301.14975),(-87.371956,-2.05455,-300.88428),(-57.363026,-2.0512695,-300.6188),(-27.354097,-2.04813,-300.35333),(2.6548278,-2.0451314,-300.08786),(32.66375,-2.042274,-299.8224),(62.672672,-2.0395577,-299.55692),(92.681595,-2.0369823,-299.29147),(122.69054,-2.3393483,-299.02576),(152.69945,-2.337055,-298.76028),(182.70836,-2.3349028,-298.4948),(212.71729,-2.3328915,-298.22934),(242.7262,-2.3310213,-297.96387),(272.7351,-2.329292,-297.69843),(302.74402,-2.3277037,-297.43295),(332.7529,-2.3262568,-297.16748),(362.7618,-2.3249505,-296.902),(392.77072,-2.3237855,-296.63654),(422.77963,-2.3227613,-296.37106),(-447.21393,-0.90812707,-334.07977),(-417.205,-0.90315413,-333.8143),(-387.19604,-0.8983223,-333.54883),(-357.18704,-1.1984318,-333.2831),(-327.1781,-1.1938821,-333.01767),(-297.16916,-1.1894733,-332.7522),(-267.16016,-1.490006,-332.48648),(-237.15118,-1.7906797,-332.2208),(-207.14224,-1.7866939,-331.95532),(-177.13327,-2.0876498,-331.6896),(-147.12434,-2.0839462,-331.42413),(-117.11541,-2.0803835,-331.15866),(-87.106445,-2.3817623,-330.89297),(-57.09752,-2.3784819,-330.6275),(-27.088593,-2.3753424,-330.36203),(2.9203305,-2.3723438,-330.09656),(32.929253,-2.3694863,-329.8311),(62.938175,-2.36677,-329.5656),(92.94709,-2.3641946,-329.30014),(122.95601,-2.3617601,-329.03467),(152.96492,-2.3594668,-328.7692),(182.97385,-2.3573146,-328.50372),(212.98276,-2.3553033,-328.23825),(242.99167,-2.3534331,-327.97278),(273.00058,-2.351704,-327.7073),(303.0095,-2.3501155,-327.44183),(333.0184,-2.3486686,-327.17636),(363.02728,-2.3473623,-326.9109),(393.0362,-2.3461971,-326.64542),(423.0451,-2.3451731,-326.37994),(-446.9484,-1.235481,-364.08847),(-416.9395,-0.92570776,-363.82324),(-386.93054,-0.9208759,-363.55777),(-356.92157,-1.2209854,-363.29205),(-326.9126,-1.2164357,-363.02658),(-296.90363,-1.5168273,-362.7609),(-266.89468,-1.5125595,-362.49542),(-236.88571,-1.8132333,-362.2297),(-206.87672,-2.114048,-361.96402),(-176.86775,-2.4150038,-361.6983),(-146.85883,-2.4113002,-361.43283),(-116.84986,-2.712538,-361.16714),(-86.840935,-2.7091162,-360.90164),(-56.832012,-2.7058358,-360.63617),(-26.823088,-2.7026963,-360.3707),(3.1858072,-2.3948975,-360.10547),(33.194756,-2.6968403,-359.83975),(63.203674,-2.694124,-359.57428),(93.21259,-2.6915486,-359.3088),(123.22149,-2.3843136,-359.04358),(153.23042,-2.6868207,-358.77786),(183.23932,-2.379868,-358.51263),(213.24823,-2.3778567,-358.24716),(243.25714,-2.3759866,-357.9817),(273.26605,-2.3742573,-357.71622),(303.27496,-2.372669,-357.45074),(333.28387,-2.371222,-357.18527),(363.29276,-2.3699157,-356.9198),(393.30167,-2.3687506,-356.65433),(423.31058,-2.672527,-356.3886),(-446.68292,-1.2581763,-394.0974),(-416.67398,-1.2532034,-393.83194),(-386.66504,-1.2483715,-393.56647),(-356.65607,-1.2436807,-393.301),(-326.6471,-1.5439312,-393.0353),(-296.63815,-1.5395225,-392.7698),(-266.62915,-1.8400551,-392.50412),(-236.6202,-2.140729,-392.2384),(-206.6112,-2.4415436,-391.97272),(-176.60225,-2.7424994,-391.707),(-146.5933,-2.7387958,-391.44153),(-116.58435,-3.0400336,-391.1758),(-86.575424,-3.0366118,-390.91034),(-56.566532,-2.728531,-390.6451),(-26.55761,-2.7253914,-390.37964),(3.4513133,-2.722393,-390.11414),(33.460236,-2.7195354,-389.84866),(63.469154,-2.716819,-389.5832),(93.47807,-2.7142437,-389.31772),(123.486984,-2.7118092,-389.05225),(153.4959,-2.7095158,-388.78677),(183.5048,-2.7073636,-388.5213),(213.51373,-2.7053523,-388.25583),(243.52263,-2.7034822,-387.99036),(273.53156,-2.701753,-387.72488),(303.54044,-2.7001646,-387.4594),(333.54935,-2.6987174,-387.19394),(363.55826,-2.6974113,-386.92844),(393.56717,-2.6962461,-386.66296),(423.57605,-2.6952221,-386.3975),(-446.41745,-1.2810133,-424.10635),(-416.4085,-1.2760403,-423.84088),(-386.39954,-1.2712084,-423.5754),(-356.3906,-1.2665175,-423.30994),(-326.38162,-1.5667682,-423.04422),(-296.37268,-1.5623593,-422.77875),(-266.36368,-1.862892,-422.51303),(-236.35466,-2.4683661,-422.2471),(-206.34569,-2.7691808,-421.98138),(-176.33676,-2.765336,-421.7159),(-146.3278,-3.066433,-421.4502),(-116.31887,-3.0628703,-421.18472),(-86.309944,-3.0594487,-420.91925),(-56.301052,-2.7513678,-420.65402),(-26.29213,-2.7482283,-420.38855),(3.7167933,-2.7452297,-420.12305),(33.725716,-2.7423723,-419.85757),(63.734634,-2.7396557,-419.5921),(93.74355,-2.7370803,-419.32663),(123.752464,-2.734646,-419.06116),(153.76138,-2.7323527,-418.7957),(183.7703,-2.7302003,-418.5302),(213.7792,-2.728189,-418.26474),(243.78812,-2.7263188,-417.99924),(273.79703,-2.7245896,-417.73376),(303.80594,-2.7230012,-417.4683),(333.81485,-2.7215543,-417.20282),(363.82373,-2.720248,-416.93735),(393.83264,-2.7190828,-416.67188),(423.84155,-2.7180588,-416.4064)])))])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SriCampus025.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SriCampus025.py load and self-test diagnostics complete.")
