package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Grouping.*;
import org.web3d.x3d.jsail.Navigation.*;
import org.web3d.x3d.jsail.Networking.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> This example shows a 3D model of the SRI International campus in Menlo Park, CA. All of the 152 buildings have been georeferenced to their actual location on the earth using GeoLocation nodes. These have been overlayed directly on a terrain model built using a GeoElevationGrid and 1m resolution USGS imagery. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SriCampusIndex.html" target="_blank">SriCampus</a>,  source <a href="../../../Geospatial/SriCampus.java">SriCampus.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SriCampus.x3d">SriCampus.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> This example shows a 3D model of the SRI International campus in Menlo Park, CA. All of the 152 buildings have been georeferenced to their actual location on the earth using GeoLocation nodes. These have been overlayed directly on a terrain model built using a GeoElevationGrid and 1m resolution USGS imagery. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Aaron Heller, SRI International </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 23 August 2023 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="https://www.ai.sri.com/~reddy/geovrml/examples/sricampus/world.wrl" target="_blank">https://www.ai.sri.com/~reddy/geovrml/examples/sricampus/world.wrl</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Aaron Heller, SRI International
 */

public class SriCampus
{
	/** Default constructor to create this object. */
	public SriCampus ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_INTERACTIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SriCampus.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("This example shows a 3D model of the SRI International campus in Menlo Park, CA. All of the 152 buildings have been georeferenced to their actual location on the earth using GeoLocation nodes. These have been overlayed directly on a terrain model built using a GeoElevationGrid and 1m resolution USGS imagery."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Aaron Heller, SRI International"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("23 August 2023"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("https://www.ai.sri.com/~reddy/geovrml/examples/sricampus/world.wrl"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SriCampus.x3d"))
    .addChild(new GeoViewpoint("martins_office").setDescription("Martin's Office +1000m").setOrientation(1.0,0.0,0.0,-1.5707964).setPosition(37.45657629289387,-122.1772098019601,1000.0)
      .setGeoOrigin(new GeoOrigin("LVCS-ORIGIN").setGeoCoords(37.45657629289387,-122.1772098019601,10.0)))
    .addChild(new Group()
      .addChild(new NavigationInfo().setSpeed(100.0))
      .addChild(new GeoLocation().setGeoCoords(37.4572702942313,-122.17285272090446,13.575352419167757)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus000.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus000.x3d","SriCampus000.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus000.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45855087547784,-122.17299719228962,6.5414795177057386)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.33597755)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus001.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus001.x3d","SriCampus001.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus001.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455090143380325,-122.17577908304841,6.858270224183798)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus002.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus002.x3d","SriCampus002.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus002.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45587247434353,-122.17549681473791,5.48073857370764)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.060658)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus003.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus003.x3d","SriCampus003.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus003.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45696959896483,-122.17349356475092,2.5236815866082907)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.56828195)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus004.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus004.x3d","SriCampus004.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus004.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45752986169077,-122.17255239265335,3.0489128064364195)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.55716646)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus005.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus005.x3d","SriCampus005.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus005.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45508901792349,-122.1744509895613,5.380065024830401)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus006.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus006.x3d","SriCampus006.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus005.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45636316454118,-122.17448723463019,2.573365761898458)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.54725033)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus007.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus007.x3d","SriCampus007.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus007.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45502643073463,-122.17742528313674,3.3866771683096886)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus008.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus008.x3d","SriCampus008.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus008.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45588879799328,-122.17524623801919,4.98465908691287)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-2.1260338)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus009.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus009.x3d","SriCampus009.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus009.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456517519745695,-122.17328336441369,2.713802792131901)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-2.1507866)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus010.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus010.x3d","SriCampus010.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus010.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45600155148939,-122.17599240217978,18.010228152386844)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.21222101)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus011.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus011.x3d","SriCampus011.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus011.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45723685203812,-122.17511987604118,15.92335551790893)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus012.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus012.x3d","SriCampus012.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus012.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45503421704476,-122.17670563469521,3.221325115300715)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus013.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus013.x3d","SriCampus013.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus013.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45660302303386,-122.17497866580095,4.641824320890009)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus014.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus014.x3d","SriCampus014.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus014.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455662812713115,-122.17815579828474,7.127999701537192)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus015.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus015.x3d","SriCampus015.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus015.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.454777118864726,-122.17428652336148,5.93625679705292)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5545655)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus016.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus016.x3d","SriCampus016.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus016.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4586277365655,-122.173191886012,6.549256028607488)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.2557627)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus017.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus017.x3d","SriCampus017.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus017.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456656900883765,-122.17432461409655,4.092642282135785)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus018.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus018.x3d","SriCampus018.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus018.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45589196793829,-122.17661290206827,13.849743553437293)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus019.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus019.x3d","SriCampus019.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus019.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.454742097706344,-122.176075551685,9.548194108530879)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5448796)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus020.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus020.x3d","SriCampus020.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus020.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.459343100583965,-122.17577382427473,2.365921502932906)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,2.5693567)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus021.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus021.x3d","SriCampus021.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus021.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45829026053256,-122.17403444710365,5.760875140316784)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.0156201)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus022.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus022.x3d","SriCampus022.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus022.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45491557328823,-122.17726006224678,3.0214025918394327)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus023.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus023.x3d","SriCampus023.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus023.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45591917814891,-122.17571403160821,8.78000576607883)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.2759828)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus024.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus024.x3d","SriCampus024.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus024.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45657326482748,-122.17430275688713,2.487428056076169)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus025.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus025.x3d","SriCampus025.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus025.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457954698100075,-122.17548056555404,17.594010497443378)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus026.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus026.x3d","SriCampus026.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus026.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45590585076085,-122.1751944596797,3.552113295532763)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.50157756)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus027.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus027.x3d","SriCampus027.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus027.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45610913695282,-122.17399622245125,4.362026927061379)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus028.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus028.x3d","SriCampus028.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus028.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4547116922646,-122.17681020280229,3.355502273887396)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus029.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus029.x3d","SriCampus029.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus029.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45766070886009,-122.17599575766377,5.076752241700888)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus030.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus030.x3d","SriCampus030.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus030.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45796451160252,-122.17613803796557,6.220091599971056)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus031.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus031.x3d","SriCampus031.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus031.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45677350057518,-122.17749573363987,2.197195878252387)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.9981249)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus032.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus032.x3d","SriCampus032.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus032.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45807779112422,-122.17411764890807,5.709648999385536)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.0156201)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus033.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus033.x3d","SriCampus033.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus033.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.454882244588006,-122.17692956544983,4.7519437577575445)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus034.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus034.x3d","SriCampus034.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus034.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45597603145201,-122.17611074695542,18.00964650325477)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.21222101)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus035.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus035.x3d","SriCampus035.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus035.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457230040769886,-122.17267919332014,13.204680165275932)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus036.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus036.x3d","SriCampus036.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus036.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45480613981243,-122.17386945372586,4.2101172199472785)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus037.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus037.x3d","SriCampus037.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus037.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45708528417106,-122.17296111448651,9.479117675684393)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus038.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus038.x3d","SriCampus038.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus038.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4557183207063,-122.17555223488636,3.840058395639062)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus039.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus039.x3d","SriCampus039.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus039.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45634044951326,-122.1756935597244,15.859837665222586)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,3.1311207)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus040.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus040.x3d","SriCampus040.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus040.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45592566042719,-122.17660938487437,13.852261767722667)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus041.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus041.x3d","SriCampus041.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus041.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457529892816005,-122.17256711496873,11.012683819048107)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.53855884)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus042.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus042.x3d","SriCampus042.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus042.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45482242600392,-122.17658734313236,4.471417527645826)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus043.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus043.x3d","SriCampus043.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus043.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45914867841565,-122.17542440073804,2.6793939722701907)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus044.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus044.x3d","SriCampus044.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus044.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45657629289387,-122.1772098019601,17.19216455705464)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5530734)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus045.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus045.x3d","SriCampus045.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus045.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455442192677,-122.17682685627666,8.63792418781668)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus046.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus046.x3d","SriCampus046.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus046.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456380605079986,-122.17571867583752,7.213743315078318)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.54237884)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus047.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus047.x3d","SriCampus047.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus047.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.454818712921295,-122.17585322698553,4.202082556672394)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5448796)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus048.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus048.x3d","SriCampus048.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus048.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4550502471287,-122.17682036348906,3.8518225820735097)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus049.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus049.x3d","SriCampus049.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus049.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45746330669514,-122.17345143211628,2.9129314199090004)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.56828195)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus050.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus050.x3d","SriCampus050.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus050.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.454442875116044,-122.17594377760844,6.156108728609979)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.55922556)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus051.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus051.x3d","SriCampus051.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus051.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45879701654415,-122.17393522056128,6.569330669008195)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.33597755)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus052.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus052.x3d","SriCampus052.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus052.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45582234818999,-122.17715115863376,17.133673508651555)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5530734)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus053.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus053.x3d","SriCampus053.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus053.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45585039052191,-122.17529710799967,6.946160456165671)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.0208304)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus054.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus054.x3d","SriCampus054.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus054.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457508873176856,-122.172491886199,14.514393392950297)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus055.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus055.x3d","SriCampus055.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus055.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45513578302731,-122.17717506959657,3.4812645660713315)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus056.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus056.x3d","SriCampus056.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus056.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45719839591745,-122.17509532185987,7.586426428519189)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.58450484)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus057.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus057.x3d","SriCampus057.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus057.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4569883265308,-122.1729676712078,6.5581301134079695)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.0149409)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus058.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus058.x3d","SriCampus058.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus058.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45456145819844,-122.17689486975709,7.527868615463376)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus059.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus059.x3d","SriCampus059.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus059.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45740319412557,-122.17618841369759,5.0026247035712)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus060.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus060.x3d","SriCampus060.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus060.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455980832229784,-122.1754127566971,5.2845821883529425)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-2.1260338)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus061.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus061.x3d","SriCampus061.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus061.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4572507076156,-122.17266351614355,13.141504678875208)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus062.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus062.x3d","SriCampus062.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus062.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45512771849234,-122.17753368161324,6.1585897551849485)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus063.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus063.x3d","SriCampus063.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus063.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45648897149806,-122.17474510430961,4.042569777928293)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus064.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus064.x3d","SriCampus064.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus064.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457545419520336,-122.17647045693873,6.57679077796638)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus065.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus065.x3d","SriCampus065.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus065.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4567782426038,-122.17300057286778,8.243166682310403)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.60314816)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus066.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus066.x3d","SriCampus066.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus066.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45460042628699,-122.17581565926682,6.317391004413366)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.55802435)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus067.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus067.x3d","SriCampus067.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus067.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45671927239422,-122.17710406092134,17.201877245679498)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5530734)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus068.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus068.x3d","SriCampus068.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus068.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45847639259631,-122.1732855152507,6.537731416523457)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.33597755)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus069.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus069.x3d","SriCampus069.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus069.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455910343615315,-122.17664992226594,13.851592540740967)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus070.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus070.x3d","SriCampus070.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus070.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45579582804456,-122.17533034339407,4.9784933580085635)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.0204762)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus071.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus071.x3d","SriCampus071.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus071.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455199117886465,-122.17701342699323,4.017314109019935)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus072.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus072.x3d","SriCampus072.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus072.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45742307208743,-122.17284002175455,15.32203997951001)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus073.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus073.x3d","SriCampus073.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus073.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455266201390465,-122.17506929403226,6.281517929397523)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus074.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus074.x3d","SriCampus074.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus074.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.458249512657666,-122.17582503824109,13.063681640662253)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus075.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus075.x3d","SriCampus075.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus075.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45703379139092,-122.17608269698909,17.61487079691142)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus076.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus076.x3d","SriCampus076.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus076.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.459349758117824,-122.17577994880299,12.226319789886475)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.52879757)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus077.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus077.x3d","SriCampus077.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus077.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455523631670936,-122.17826624724431,4.396789534017444)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.012785)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus078.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus078.x3d","SriCampus078.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus078.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45748923066822,-122.1757325976501,17.814282183535397)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus079.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus079.x3d","SriCampus079.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus079.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45622632561962,-122.17423430878904,4.528802731074393)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus080.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus080.x3d","SriCampus080.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus080.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45501807177614,-122.17719105822079,4.006106214597821)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus081.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus081.x3d","SriCampus081.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus081.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45465566409258,-122.17698610464193,3.2464131880551577)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus082.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus082.x3d","SriCampus082.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus082.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45712962221045,-122.17265941441853,13.401793683879078)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus083.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus083.x3d","SriCampus083.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus083.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45692498803204,-122.17769601887739,16.93729296978563)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus084.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus084.x3d","SriCampus084.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus084.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456814457875936,-122.1769710991232,2.2080116970464587)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus085.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus085.x3d","SriCampus085.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus085.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45440500608271,-122.17564484966901,5.874921953305602)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.55922556)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus086.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus086.x3d","SriCampus086.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus086.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45887150100618,-122.17364689701467,6.572895417921245)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.33597755)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus087.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus087.x3d","SriCampus087.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus087.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457302044512346,-122.17262076560766,13.290771765634418)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus088.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus088.x3d","SriCampus088.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus088.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45787902024201,-122.17202008954384,4.758735476993024)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.2557627)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus089.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus089.x3d","SriCampus089.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus089.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456270157439285,-122.17655409213578,17.732382902875543)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.21222101)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus090.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus090.x3d","SriCampus090.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus090.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455202658874605,-122.17537929382321,10.800645593553782)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus091.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus091.x3d","SriCampus091.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus091.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45826209565133,-122.17595626355404,11.577650134451688)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus092.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus092.x3d","SriCampus092.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus092.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45544706135105,-122.17542250128548,6.491053903475404)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus093.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus093.x3d","SriCampus093.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus093.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.458398889705016,-122.1730916119198,6.529909424483776)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.2557627)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus094.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus094.x3d","SriCampus094.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus094.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45590814672539,-122.1765990028583,13.850803661160171)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus095.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus095.x3d","SriCampus095.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus095.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456286881934034,-122.17435595010173,2.799916968680918)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5626132)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus096.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus096.x3d","SriCampus096.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus096.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45598740170031,-122.17375297634354,4.297718069516122)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus097.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus097.x3d","SriCampus097.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus097.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45632012788061,-122.17701436276613,8.888750216923654)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.2759828)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus098.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus098.x3d","SriCampus098.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus098.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.456845922281055,-122.17669512470076,5.616073635406792)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus099.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus099.x3d","SriCampus099.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus099.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455818973641165,-122.17500576498591,5.202997267246246)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus100.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus100.x3d","SriCampus100.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus100.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45606574957878,-122.17762711789799,17.579336941242218)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5530734)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus101.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus101.x3d","SriCampus101.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus101.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45679915195322,-122.17630003052214,18.843943851068616)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus102.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus102.x3d","SriCampus102.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus102.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457331549143376,-122.1726072752575,13.708675358444453)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus103.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus103.x3d","SriCampus103.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus103.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45520547056154,-122.17781585094827,3.2565740747377277)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus104.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus104.x3d","SriCampus104.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus104.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.454810121643106,-122.1772881517725,3.4585653822869063)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus105.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus105.x3d","SriCampus105.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus105.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4574835594975,-122.17250934197735,14.512516235001386)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus106.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus106.x3d","SriCampus106.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus106.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457111007051886,-122.17287436027812,7.242378053255379)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.65482974)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus107.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus107.x3d","SriCampus107.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus107.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.458031005215425,-122.1719256683745,4.770276533439755)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.33597755)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus108.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus108.x3d","SriCampus108.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus108.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45515720353775,-122.17406431710244,4.3671683901920915)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus109.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus109.x3d","SriCampus109.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus109.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45934859760897,-122.17577724891385,3.8770384145900607)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-2.1220884)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus110.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus110.x3d","SriCampus110.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus110.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45552187784782,-122.1767457842618,8.714063614606858)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus111.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus111.x3d","SriCampus111.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus111.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45487218593971,-122.177110948491,4.0440065916627646)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus112.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus112.x3d","SriCampus112.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus112.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45714986360583,-122.17352452743129,4.084409800358117)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus113.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus113.x3d","SriCampus113.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus113.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45736742589547,-122.17254854118927,12.031191472895444)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.45392746)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus114.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus114.x3d","SriCampus114.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus114.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45525714274129,-122.17507028895217,6.794414064846933)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus115.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus115.x3d","SriCampus115.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus115.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45527295154821,-122.17532124323364,6.476923021487892)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus116.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus116.x3d","SriCampus116.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus116.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45692705603369,-122.1733747901541,4.366944617591798)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5485743)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus117.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus117.x3d","SriCampus117.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus117.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45785850917333,-122.17548124695458,17.76672370173037)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus118.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus118.x3d","SriCampus118.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus118.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4562485875788,-122.17668959142121,18.037382354959846)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.21222101)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus119.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus119.x3d","SriCampus119.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus119.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45810786809718,-122.17212035970775,4.777719925157726)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.2557627)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus120.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus120.x3d","SriCampus120.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus120.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455266201390465,-122.17506929403226,6.281517929397523)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus121.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus121.x3d","SriCampus121.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus121.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45592875610246,-122.17663227644208,13.852776668034494)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus122.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus122.x3d","SriCampus122.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus122.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45795652492048,-122.17221399048172,4.766224743798375)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.33597755)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus123.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus123.x3d","SriCampus123.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus123.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45714439718839,-122.17676921602542,5.741842704825103)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus124.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus124.x3d","SriCampus124.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus124.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.458446345493876,-122.17621659673107,12.486853444948793)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus125.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus125.x3d","SriCampus125.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus125.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45479119875997,-122.17587485217826,12.241555511020124)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus126.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus126.x3d","SriCampus126.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus126.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455637529653934,-122.17805175366064,9.068381279706955)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus127.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus127.x3d","SriCampus127.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus127.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45763170885517,-122.17283667995618,3.710161382332444)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.51614106)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus128.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus128.x3d","SriCampus128.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus128.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4552030561581,-122.17537929603283,17.37209532316774)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus129.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus129.x3d","SriCampus129.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus129.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45932899377421,-122.17558236032434,6.673216645605862)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus130.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus130.x3d","SriCampus130.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus130.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45589059230768,-122.17663857154662,13.849952574819327)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.06768273)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus131.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus131.x3d","SriCampus131.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus131.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45918042954255,-122.1754082085766,5.576121235266328)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5679538)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus132.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus132.x3d","SriCampus132.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus132.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455131055190136,-122.17542623141605,15.226345616392792)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.6047001)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus133.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus133.x3d","SriCampus133.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus133.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455833276710195,-122.17782281798755,4.371283515356481)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus134.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus134.x3d","SriCampus134.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus134.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455470051193935,-122.1764647666282,4.49514652043581)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-2.1285856)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus135.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus135.x3d","SriCampus135.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus135.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45657234678347,-122.17339401563034,2.7787711387500167)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-2.1507866)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus136.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus136.x3d","SriCampus136.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus136.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45631310248525,-122.17629745601055,23.58098861668259)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus137.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus137.x3d","SriCampus137.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus137.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455171973416775,-122.17478671098695,5.2806648556143045)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus138.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus138.x3d","SriCampus138.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus138.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457562174137806,-122.17653367409845,5.033575700595975)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus139.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus139.x3d","SriCampus139.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus139.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45801521983128,-122.1757853295299,6.195992290042341)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus140.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus140.x3d","SriCampus140.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus140.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45625863524508,-122.17663801938741,9.305874523706735)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.22040787)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus141.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus141.x3d","SriCampus141.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus141.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.457739055012425,-122.1734358580361,5.76438597496599)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,1.0156201)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus142.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus142.x3d","SriCampus142.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus142.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45598818694582,-122.17605942042514,9.153055736795068)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,0.22040787)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus143.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus143.x3d","SriCampus143.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus143.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.4576116909627,-122.17360001041664,5.102806192822754)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus144.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus144.x3d","SriCampus144.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus144.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45894836101852,-122.17384159223147,6.580874713137746)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.2557627)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus145.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus145.x3d","SriCampus145.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus145.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45776336144376,-122.17341476074354,5.653091097250581)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5436424)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus146.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus146.x3d","SriCampus146.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus146.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45516876487382,-122.17770066739573,3.311441686935723)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus147.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus147.x3d","SriCampus147.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus147.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.455490754774395,-122.1758039372311,3.435827133245766)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5448796)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus148.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus148.x3d","SriCampus148.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus148.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45752755262736,-122.17293579558575,11.593646936118603)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform()
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus149.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus149.x3d","SriCampus149.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus149.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45714391701085,-122.17638076991432,4.629718789830804)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-0.5600868)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus150.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus150.x3d","SriCampus150.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus150.x3d"}))))))
      .addChild(new GeoLocation().setGeoCoords(37.45871951472387,-122.1737413157338,6.561306121759117)
        .setGeoOrigin(new GeoOrigin().setUSE("LVCS-ORIGIN"))
        .addChild(new Transform().setRotation(1.0,0.0,0.0,0.0)
          .addChild(new Transform().setRotation(0.0,1.0,0.0,-1.2557627)
            .addChild(new Transform()
              .addChild(new Inline().setUrl(new String[] {"SriCampus151.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus151.x3d","SriCampus151.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SriCampus151.x3d"}))))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SriCampus model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SriCampus().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SriCampus\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SriCampus self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SriCampus_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SriCampus_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SriCampus_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SriCampus_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
