####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD029.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD029.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD029.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD029.x3d'),
    GeoLOD(center=(4344125.917539,743027.217291,2133.000000),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw014.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw014.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4343332.077840,742430.999947,0),geoSystem=["UTM","Z10","N"],height=[2000.4667,2011.1676,2023.0615,2036.2761,2043.6763,2052.6614,2060.9883,2065.8125,2071.4575,2079.1938,2084.952,2088.2036,2089.3333,2090.538,2091.3333,2090.7751,2091.6667,2092.7822,2096.0457,2101.555,2108.7913,2115.313,2122.3425,2128.5002,2135.1577,2141.964,2148.2095,2155.5815,2160.6213,2166.085,2173.2063,2181.4805,2187.731,2194.576,2201.1,2207.3364,2214.573,2219.9365,2222.3486,2224.7607,2226.3394,2228.654,2228.1697,2228.0984,2225.3276,2221.4055,2218.2954,2216.9424,2215.442,2214.0984,2212.7551,1994.8737,2005.7079,2016.8102,2028.716,2038.2583,2047.6804,2054.731,2060.3945,2063.635,2070.4592,2075.2834,2077.8865,2080.2986,2081.684,2083.1228,2084.2488,2086.1145,2088.9316,2093.7349,2099.9712,2107.7507,2113.4438,2120.2397,2125.9165,2133.3281,2139.8018,2146.874,2155.0935,2160.7764,2166.708,2173.1248,2180.0305,2186.0955,2193.5764,2199.5164,2207.3364,2214.791,2219.9365,2222.3486,2225.3445,2228.1729,2229.8271,2230.0,2227.5908,2223.7737,2219.9495,2218.0,2216.0,2215.0,2214.0,2213.1716,1987.4701,1999.3708,2009.5265,2018.6586,2027.303,2035.2062,2045.4341,2051.1216,2055.9402,2059.7703,2064.5706,2067.9524,2069.5938,2071.0059,2072.4233,2074.8386,2079.2449,2084.3652,2090.3086,2098.0217,2104.7712,2110.6685,2115.4993,2121.4788,2128.7068,2135.943,2142.1895,2149.4258,2157.427,2162.8984,2170.0737,2175.9075,2181.7217,2188.1318,2196.7832,2205.3267,2213.092,2219.9358,2222.3486,2226.5212,2229.1826,2231.0059,2230.003,2226.587,2222.3557,2218.7666,2217.3545,2215.9995,2214.5303,2214.0,2214.01,1980.6277,1990.7562,2001.0157,2010.3892,2018.7012,2026.264,2035.3346,2043.7332,2050.091,2053.0886,2055.5007,2057.4768,2059.5317,2061.301,2063.7131,2067.884,2071.6917,2079.21,2086.4463,2093.6826,2099.9885,2106.1553,2111.637,2116.4612,2122.8643,2130.0967,2136.1611,2143.2178,2150.3735,2156.9705,2163.8462,2170.619,2175.8252,2182.7156,2193.364,2201.9636,2210.2249,2218.373,2221.9124,2226.5212,2230.1729,2232.0,2229.006,2225.4124,2221.8206,2218.4324,2217.3545,2215.5315,2214.436,2215.3179,2215.436,1975.0753,1983.5896,1993.9039,2004.7598,2014.1936,2021.4182,2029.7576,2036.9939,2043.3679,2046.33,2047.413,2048.7415,2051.0464,2054.4978,2058.053,2063.747,2068.9834,2075.3154,2082.3645,2088.83,2094.2642,2100.3933,2105.922,2111.609,2117.0698,2123.3938,2130.137,2135.8586,2143.095,2149.3313,2155.6982,2162.804,2169.1646,2179.2893,2189.1719,2197.6118,2205.8481,2215.021,2220.8347,2226.315,2231.1729,2231.4956,2229.0034,2224.3193,2220.4705,2218.0,2216.4434,2215.8623,2216.332,2216.9836,2217.0,1971.2155,1982.4296,1993.5615,2003.6976,2011.7211,2018.7413,2025.1473,2031.5686,2037.393,2040.3911,2042.3678,2043.8689,2046.2391,2050.7896,2055.627,2061.4512,2066.5574,2072.0996,2078.6353,2083.9673,2089.2837,2094.8193,2099.9321,2105.4678,2110.4592,2117.1099,2123.229,2129.58,2135.6545,2141.598,2147.6292,2155.4841,2164.802,2174.8625,2184.523,2192.8716,2201.52,2210.1685,2219.1199,2223.9934,2230.6455,2230.2463,2226.7175,2222.8933,2219.069,2217.7666,2216.934,2218.3052,2218.5771,2218.5771,2218.2039,1972.0144,1983.4008,1994.0492,2002.7732,2009.769,2015.7826,2020.892,2025.8796,2031.5405,2035.3647,2038.3798,2040.3484,2042.6567,2046.6616,2051.9436,2058.932,2064.1343,2069.8713,2074.7827,2079.6072,2083.7463,2088.7856,2094.295,2099.904,2105.443,2110.8352,2118.2065,2124.016,2130.74,2137.843,2144.44,2152.293,2160.7886,2171.2312,2179.6707,2187.939,2196.6677,2205.3162,2213.9646,2221.0918,2226.5073,2227.559,2226.004,2220.1614,2218.1787,2217.948,2220.7898,2222.487,2223.4294,2223.4294,2221.421,1977.5228,1984.7094,1994.1179,2001.643,2007.9622,2013.3563,2017.9015,2021.3717,2025.5492,2028.9742,2033.3595,2035.718,2037.0367,2043.0912,2048.3086,2055.6094,2061.4229,2066.9412,2071.839,2075.7546,2079.7795,2083.2017,2088.982,2095.216,2102.7366,2108.2627,2117.004,2123.7017,2131.6277,2137.0593,2143.1033,2149.8547,2157.504,2166.9702,2174.9592,2182.3079,2192.0972,2201.7456,2209.6936,2218.1409,2222.0317,2224.8005,2226.1401,2224.4636,2222.5261,2225.797,2228.1184,2229.4229,2229.282,2228.282,2225.988,1984.9717,1991.3915,1996.9479,2001.4589,2006.6731,2010.1815,2014.6848,2019.0057,2021.4178,2022.4329,2027.3195,2033.7886,2038.3278,2045.8383,2052.6418,2058.4412,2061.1055,2065.9553,2069.2124,2073.0366,2078.3884,2082.3425,2087.692,2096.162,2104.632,2112.5364,2121.115,2127.9329,2135.022,2140.2087,2145.6704,2150.9583,2156.2483,2164.8638,2172.2332,2181.0796,2193.2314,2202.3489,2209.9612,2217.4177,2221.2708,2225.152,2227.5642,2228.3115,2230.033,2232.6995,2234.1343,2235.1343,2234.7014,2233.2524,2230.6736,1991.0887,1996.2872,2001.5024,2003.9177,2008.33,2010.7421,2015.469,2021.1324,2022.9718,2025.3772,2032.4065,2039.6442,2047.878,2055.1555,2061.8955,2064.8499,2067.982,2070.6763,2072.093,2075.0234,2078.9294,2082.6829,2089.0186,2098.6604,2107.7273,2115.9573,2123.2068,2130.439,2136.4546,2142.9119,2148.0964,2152.921,2157.745,2164.8638,2172.7937,2182.6665,2197.084,2206.7324,2213.686,2219.5146,2223.3389,2226.582,2228.9905,2231.3997,2233.8147,2236.2268,2238.6323,2240.9868,2241.98,2239.2166,2234.401,1995.9587,2000.5198,2003.4442,2007.2684,2010.8973,2016.231,2021.2281,2026.4044,2030.657,2033.6559,2039.4956,2047.1442,2055.9463,2062.9495,2068.174,2072.1284,2074.5405,2077.3723,2080.365,2082.777,2083.839,2085.1816,2091.541,2099.667,2109.3154,2117.3887,2124.2095,2130.6304,2137.6821,2144.338,2149.5227,2154.347,2160.5554,2168.4043,2176.6394,2187.465,2200.261,2210.6216,2218.5361,2222.4993,2226.012,2229.0044,2231.4165,2234.8286,2237.6604,2240.208,2243.065,2244.8726,2245.4197,2241.656,2237.128,2003.4911,2003.7917,2006.358,2008.9127,2013.8553,2020.9375,2028.0197,2034.6172,2038.5223,2041.3315,2045.9944,2054.2356,2062.592,2068.7827,2074.607,2078.297,2081.8628,2085.2314,2086.7976,2088.6172,2089.681,2090.0342,2093.355,2098.9624,2108.826,2117.964,2124.8062,2130.6304,2137.6821,2144.9185,2150.1033,2155.8447,2162.4731,2170.9976,2180.4917,2191.2698,2203.4673,2216.1753,2222.6833,2227.4153,2229.8643,2232.2764,2235.6855,2239.1006,2242.334,2244.9248,2247.337,2249.6917,2249.222,2245.828,2241.1038,2012.388,2010.7157,2009.544,2011.4478,2017.462,2024.7216,2034.0262,2040.1565,2044.7859,2048.2131,2052.4343,2059.208,2066.4443,2073.635,2078.917,2084.2837,2087.3032,2090.4268,2092.922,2094.816,2094.816,2095.544,2095.3386,2098.6216,2107.4646,2116.6921,2124.0996,2130.4458,2136.8477,2144.8203,2150.1548,2156.5369,2163.8994,2172.9421,2183.0723,2194.1865,2206.8936,2219.6995,2227.8433,2232.0327,2233.4448,2236.0159,2239.269,2242.7925,2246.0933,2248.9473,2252.1895,2253.544,2253.544,2251.6943,2245.956,2021.604,2018.6925,2017.4521,2019.6943,2022.0695,2030.3151,2039.5768,2045.9421,2051.0645,2056.19,2058.9038,2063.0603,2070.5986,2077.5332,2084.3118,2088.5288,2092.6782,2096.0903,2098.5024,2100.3962,2100.3962,2101.0945,2101.0945,2102.06,2106.856,2114.964,2122.5112,2128.8765,2135.984,2143.2202,2150.1548,2157.391,2165.239,2174.8499,2184.8003,2196.293,2208.7651,2219.7456,2229.0457,2233.6885,2235.8708,2239.1577,2242.6921,2246.1072,2249.0928,2252.1648,2255.3438,2256.6982,2256.6982,2255.8164,2249.1182,2030.0975,2026.3973,2025.946,2027.2976,2030.0044,2036.2433,2044.8555,2052.0918,2059.2056,2062.5215,2064.058,2067.3457,2071.2668,2079.301,2086.9724,2092.8582,2096.8127,2100.9429,2104.262,2105.3132,2106.3645,2107.373,2107.373,2108.2695,2108.8801,2115.0974,2121.8062,2128.3213,2133.5576,2140.794,2148.0303,2156.2668,2165.379,2175.0273,2184.8003,2195.4365,2208.3728,2219.5576,2228.2698,2233.5212,2237.3455,2240.6577,2244.121,2247.9426,2251.7668,2254.591,2257.0803,2259.007,2259.066,2256.1328,2250.2427,2038.0865,2034.5515,2033.6517,2034.6517,2035.9883,2041.2341,2050.5835,2058.8198,2062.5356,2066.1663,2068.9104,2071.3225,2074.634,2081.6667,2089.3813,2097.2317,2102.2156,2106.4893,2109.2073,2111.3865,2112.6135,2114.2898,2115.0671,2115.6519,2115.6519,2117.5466,2121.8062,2127.5474,2132.6821,2139.368,2145.6042,2153.8406,2162.402,2172.8892,2184.2498,2193.499,2204.7822,2217.5522,2226.394,2233.5212,2238.2678,2242.3984,2246.5447,2250.6343,2254.193,2256.784,2259.8416,2261.5505,2261.0808,2257.6687,2251.8008,2045.5304,2042.9071,2043.4076,2044.81,2045.8917,2046.7137,2054.6162,2062.1091,2065.9468,2069.7617,2073.5764,2077.373,2082.1973,2086.0894,2093.3267,2100.5862,2106.7993,2110.671,2114.0598,2116.978,2119.8608,2121.273,2122.685,2122.9304,2122.519,2122.9304,2123.783,2128.6072,2132.6821,2139.9036,2146.1316,2152.9275,2160.5032,2170.463,2181.1326,2191.472,2202.1204,2213.7053,2224.7578,2233.282,2239.5144,2245.1465,2249.9475,2253.386,2256.798,2259.2102,2261.6304,2264.0344,2264.9658,2261.3286,2255.0786,2051.2268,2048.2688,2050.3184,2051.7607,2053.3445,2055.3606,2059.1587,2063.8909,2068.373,2073.1973,2077.4246,2083.2488,2087.2917,2091.8972,2097.3184,2103.0125,2109.9668,2114.097,2118.552,2121.8425,2125.6667,2127.944,2129.9636,2130.209,2130.612,2130.2126,2129.806,2130.7314,2134.3965,2141.9185,2148.5579,2155.1143,2162.9563,2172.2668,2180.5032,2191.9187,2202.8132,2213.7078,2225.0051,2234.5884,2241.9214,2247.8083,2253.397,2256.812,2259.224,2261.6362,2264.0483,2267.403,2268.403,2267.4736,2259.6301,2057.2583,2054.6584,2055.1707,2057.5828,2059.9949,2061.578,2063.819,2066.8772,2070.799,2075.6235,2081.2568,2086.272,2090.988,2095.9204,2100.2869,2105.5688,2110.7976,2116.9636,2121.8708,2126.695,2131.3604,2134.001,2135.6584,2136.7966,2137.5864,2137.489,2135.9824,2135.456,2138.9812,2143.1082,2149.984,2157.2996,2166.3325,2174.981,2183.6294,2193.4487,2204.532,2214.7456,2225.683,2235.8718,2244.3474,2251.928,2256.8257,2260.0674,2262.4795,2264.0625,2266.4746,2268.8867,2269.9094,2269.098,2264.4827,2062.1108,2058.485,2059.0232,2061.4915,2063.8474,2065.702,2067.4163,2068.9373,2071.9739,2077.3452,2083.4763,2087.698,2092.5222,2097.3806,2102.171,2106.995,2112.0293,2118.1604,2125.2666,2131.5474,2135.1858,2138.1084,2140.7036,2142.6775,2144.1973,2145.5042,2144.26,2142.3025,2143.9934,2147.0452,2152.614,2159.11,2167.535,2176.4072,2185.279,2194.704,2205.0972,2215.6821,2226.394,2237.8032,2247.8179,2255.425,2260.505,2263.92,2265.465,2267.315,2268.901,2270.313,2271.2554,2270.3735,2267.2683,2066.7588,2063.3313,2063.8755,2066.2876,2068.018,2070.1118,2071.4143,2072.2544,2073.6665,2078.6023,2084.3,2088.4426,2093.2668,2098.091,2103.597,2108.7397,2113.564,2118.3882,2126.1062,2134.7183,2138.5425,2142.0242,2145.8726,2148.3633,2149.3633,2149.3633,2148.5532,2146.5479,2149.7456,2153.888,2159.148,2164.4358,2169.9907,2178.06,2187.482,2196.1304,2205.4214,2215.6821,2226.6316,2238.8032,2249.6912,2258.4363,2264.3552,2268.0908,2269.2415,2270.4375,2272.1216,2273.4207,2274.3633,2273.4814,2270.0693,2070.7078,2069.1187,2069.2156,2070.14,2072.4443,2073.8835,2075.108,2075.7268,2077.2007,2080.505,2084.6184,2089.4426,2094.2668,2099.091,2104.4316,2109.8335,2114.564,2119.463,2127.5325,2135.1443,2139.9685,2144.8298,2149.8062,2154.3823,2155.6367,2154.2246,2152.2156,2152.1956,2154.6458,2159.8123,2166.5803,2172.3086,2177.075,2181.2183,2191.7805,2198.6477,2205.732,2215.7524,2226.7427,2238.8032,2251.8638,2259.8625,2267.9883,2270.473,2271.929,2274.341,2275.7915,2277.108,2277.108,2277.108,2275.1838,2075.5496,2073.602,2073.8408,2074.068,2075.534,2076.9338,2078.1428,2079.335,2080.527,2081.9312,2085.1526,2089.5608,2094.2668,2099.091,2104.9155,2110.6094,2115.564,2120.3882,2128.902,2136.0366,2141.8608,2147.868,2155.332,2158.7007,2159.534,2158.077,2156.3462,2155.534,2157.2314,2165.626,2174.2263,2181.0635,2186.3552,2191.8657,2198.3284,2204.3523,2211.1748,2217.9111,2227.742,2238.8032,2251.8638,2261.067,2267.994,2271.943,2275.3552,2277.7673,2279.369,2280.5647,2281.068,2281.068,2279.7742,2083.4807,2080.8203,2079.9,2078.993,2078.9338,2079.7087,2081.1208,2082.943,2083.9453,2084.3574,2085.8093,2090.4426,2094.2668,2098.093,2103.9336,2109.7742,2115.564,2120.3882,2129.3186,2136.555,2142.7913,2149.9878,2157.4995,2160.1667,2161.556,2161.9207,2160.9204,2160.8806,2163.3137,2170.4927,2180.1248,2189.717,2196.5925,2202.693,2207.5288,2211.217,2218.9568,2227.549,2233.9001,2241.2327,2250.698,2260.941,2268.994,2274.3694,2277.7815,2280.4177,2282.6057,2283.9602,2284.9204,2284.9204,2283.6382,2090.1887,2086.6726,2084.2605,2083.0293,2081.2563,2082.2322,2084.3865,2085.3865,2086.3806,2086.7834,2088.2693,2091.2214,2093.6335,2097.1367,2103.1963,2108.7397,2114.7368,2120.3882,2128.9321,2136.555,2144.1777,2151.7566,2158.5093,2161.2312,2163.7417,2164.9944,2166.176,2168.5166,2171.4744,2176.0776,2185.0508,2196.807,2206.173,2213.796,2217.632,2219.882,2228.4402,2236.3547,2242.4565,2248.9744,2254.997,2263.0466,2270.7627,2277.2046,2281.098,2284.006,2286.4182,2287.808,2288.7727,2288.8452,2288.206,2094.4126,2090.7124,2087.3003,2084.137,2083.0,2083.953,2085.1606,2086.573,2087.8003,2088.0745,2088.9966,2090.4087,2092.8208,2096.3157,2102.373,2107.9026,2114.8457,2121.0823,2129.3186,2137.8857,2146.5474,2154.84,2159.5671,2163.0105,2166.204,2167.8037,2169.2158,2173.2556,2177.8926,2183.2363,2192.56,2205.5688,2215.042,2223.1143,2227.9504,2229.7534,2237.3477,2245.0596,2251.296,2257.9143,2263.9238,2270.0828,2277.4282,2281.4434,2285.4465,2288.669,2290.3372,2292.4954,2294.9075,2295.4377,2292.3313,2096.3716,2091.5608,2086.859,2083.8547,2081.7612,2082.5225,2084.5608,2085.7612,2086.5225,2085.9053,2085.7612,2086.7437,2091.0918,2095.3647,2102.4824,2109.155,2117.1519,2124.5598,2132.877,2141.312,2149.03,2157.4243,2160.7546,2164.5723,2168.8176,2170.4753,2173.284,2178.1082,2184.7427,2195.752,2206.6907,2217.177,2225.727,2232.531,2236.4165,2239.8286,2245.528,2252.5408,2258.6787,2264.9983,2272.037,2279.6475,2284.7104,2288.6758,2291.734,2295.0056,2298.755,2302.0127,2304.186,2303.8064,2299.8896,2094.0706,2089.1345,2084.482,2080.1309,2077.67,2077.9207,2079.7239,2081.005,2080.3499,2080.34,2080.34,2082.5564,2088.6567,2096.8018,2104.038,2112.1443,2120.2703,2127.747,2135.9836,2144.22,2150.7913,2157.9053,2161.6724,2166.3335,2170.5789,2172.991,2176.4712,2181.2954,2193.3157,2203.6482,2217.5537,2227.6484,2235.664,2242.0444,2245.36,2248.587,2254.233,2259.868,2264.8088,2270.8513,2277.8484,2285.0847,2291.986,2296.6763,2300.3623,2304.1267,2308.3054,2310.6794,2311.66,2310.1133,2306.1707,2088.7903,2085.6172,2080.2808,2074.8845,2071.7263,2071.7263,2072.8872,2073.7263,2071.7415,2070.7263,2073.3364,2080.593,2088.534,2098.0952,2105.373,2113.4792,2121.937,2129.1733,2136.5063,2144.4636,2150.7063,2157.5938,2160.6633,2164.227,2168.9753,2171.9902,2176.715,2182.3545,2192.727,2203.0479,2215.9844,2228.1785,2241.2437,2248.9812,2254.8826,2257.498,2262.3223,2266.2375,2271.3787,2276.795,2283.0244,2290.9905,2299.262,2305.2205,2311.1733,2316.084,2319.1926,2320.5996,2321.4617,2318.494,2314.0442,2083.3547,2081.7166,2076.458,2069.231,2063.4197,2063.3176,2065.0134,2064.9304,2063.4626,2063.242,2070.3008,2078.7437,2088.3442,2098.1367,2105.373,2113.4792,2122.8457,2130.0823,2137.3186,2143.555,2149.3098,2154.3076,2157.1104,2160.1318,2163.6055,2168.4297,2172.7715,2179.411,2187.8745,2197.0056,2209.215,2221.99,2235.1853,2247.8875,2256.8828,2262.7998,2268.3547,2274.425,2280.5864,2285.591,2290.8145,2296.8918,2307.5386,2317.647,2327.5105,2332.8552,2334.9558,2335.592,2332.8743,2329.2449,2323.1877,2074.8523,2076.1072,2073.0881,2065.415,2058.3833,2055.4062,2056.2256,2056.2256,2057.0986,2057.873,2066.3042,2076.1506,2087.1672,2097.1367,2104.4294,2112.5356,2121.8457,2130.0823,2136.369,2142.582,2147.8647,2150.095,2151.8813,2154.3264,2156.748,2161.1426,2166.3557,2172.6147,2181.8076,2190.0671,2200.5322,2213.4878,2225.6047,2239.937,2251.9695,2261.3992,2270.124,2280.6365,2287.2617,2293.6208,2297.223,2302.09,2311.9287,2327.342,2340.937,2345.7744,2347.3835,2345.7732,2342.3347,2337.0671,2331.243,2065.103,2067.5469,2066.3157,2060.4592,2054.3752,2047.3843,2046.95,2047.6213,2049.6096,2056.5713,2065.1167,2076.1067,2086.534,2096.7668,2103.7148,2111.1577,2119.758,2128.4065,2135.7363,2139.7786,2143.777,2144.8906,2145.6453,2147.594,2151.8394,2155.2456,2160.4697,2166.8909,2174.7158,2183.8184,2192.4993,2204.547,2217.2236,2229.5117,2242.9102,2253.0815,2264.3362,2278.509,2286.4348,2294.063,2300.8882,2307.7559,2314.7307,2326.5244,2337.9968,2348.5996,2355.7314,2354.0881,2351.3438,2345.5298,2337.9666,2054.5159,2056.816,2055.4082,2053.703,2050.0027,2044.162,2039.8159,2042.4369,2047.958,2056.1914,2066.0461,2076.1067,2086.0295,2094.3408,2101.9414,2109.8135,2118.0498,2125.2861,2131.536,2134.5137,2135.612,2136.1584,2139.1213,2143.5376,2147.901,2152.186,2156.214,2162.0007,2167.909,2176.8093,2186.6143,2196.9304,2208.991,2222.0518,2233.2551,2244.2646,2254.02,2267.6384,2280.139,2289.6545,2299.099,2307.9587,2316.9885,2323.4314,2330.897,2340.9827,2352.3977,2356.4421,2356.796,2354.0325,2345.2722,2045.3556,2046.8889,2046.4905,2045.1699,2041.9968,2037.0315,2034.135,2040.4965,2048.94,2056.5002,2066.1946,2076.491,2084.9004,2092.9146,2100.151,2107.3872,2114.561,2120.9436,2124.6382,2126.111,2126.111,2128.8281,2134.2327,2139.8892,2144.7134,2148.7598,2153.0483,2157.186,2163.0103,2169.3318,2179.5398,2190.6519,2201.8367,2214.5508,2225.1335,2234.8694,2245.3247,2255.8074,2269.1248,2281.9143,2292.6677,2302.5806,2311.3242,2318.2424,2324.797,2333.0444,2342.6929,2349.4358,2352.2156,2350.4514,2345.5168,2033.6523,2034.4415,2034.7579,2035.4062,2032.8516,2028.2606,2030.2897,2038.4417,2047.9453,2055.8005,2065.3977,2075.0156,2083.6628,2090.4883,2097.0762,2104.3125,2110.9155,2115.4429,2117.4062,2117.4062,2118.6335,2123.3792,2130.7017,2136.577,2140.8608,2145.685,2149.3677,2153.982,2157.8862,2164.6216,2171.646,2182.5364,2196.0017,2206.3076,2217.101,2226.5034,2235.6877,2247.0884,2259.5713,2271.2095,2283.0974,2292.7458,2302.3953,2310.282,2318.5183,2325.252,2334.0522,2342.17,2344.0547,2343.1729,2339.2185,2022.2747,2023.7196,2024.6268,2022.7024,2021.3406,2021.0371,2027.941,2037.8962,2046.9412,2055.6335,2064.237,2072.606,2080.8257,2087.9453,2094.2644,2100.47,2105.3188,2108.3955,2108.678,2108.3691,2113.7166,2119.953,2127.1147,2132.1968,2137.04,2141.8328,2146.284,2150.495,2154.3801,2159.8438,2167.0762,2175.7056,2187.8508,2199.928,2209.5764,2218.2249,2226.9087,2237.4583,2251.8186,2262.9502,2273.48,2283.7314,2290.9194,2301.606,2313.2715,2324.7175,2330.963,2336.904,2337.3064,2334.8196,2330.7014,2008.4958,2010.4958,2011.4958,2010.9967,2013.3461,2021.8722,2031.1439,2040.5063,2049.4482,2056.6921,2064.3325,2071.664,2078.3997,2084.613,2090.4138,2095.3022,2097.6382,2098.844,2099.2622,2104.5356,2111.2905,2117.3552,2123.0085,2128.3318,2132.5771,2136.9802,2142.0066,2147.1296,2151.4531,2157.4175,2163.6282,2170.1218,2179.5017,2191.1484,2200.2961,2209.4453,2220.3564,2231.1812,2246.6138,2260.8032,2271.278,2282.219,2292.9944,2303.548,2316.108,2326.2004,2329.9983,2330.9983,2330.0278,2325.2332,2321.202,1996.9918,1998.465,1999.8397,2007.7086,2015.8882,2023.173,2033.5701,2043.2185,2050.897,2058.1914,2064.6045,2071.4587,2076.3862,2082.164,2086.564,2090.0063,2090.4802,2091.8623,2094.4568,2101.628,2107.9373,2113.783,2118.6553,2123.4795,2128.3037,2132.128,2137.3552,2142.7764,2146.6006,2152.7302,2159.253,2165.967,2173.7222,2181.1768,2190.041,2200.6594,2212.3367,2229.555,2247.3667,2262.491,2274.7783,2287.406,2298.8423,2308.8997,2319.3777,2323.3794,2324.219,2324.112,2319.917,2314.4187,2310.292,1985.2871,1987.758,1996.877,2008.9486,2017.3628,2025.701,2036.5391,2045.2915,2052.3179,2059.1914,2064.6184,2070.0894,2074.9138,2078.722,2081.7512,2083.8562,2083.5044,2085.2327,2091.5059,2097.0186,2103.13,2109.9785,2114.8027,2119.627,2124.6558,2129.6287,2133.8562,2139.5652,2142.874,2147.332,2154.768,2162.0378,2168.3984,2176.5105,2184.147,2197.2078,2210.317,2229.7212,2247.0864,2262.2107,2275.6833,2288.3645,2300.983,2310.5479,2317.468,2318.2935,2318.2935,2316.8047,2310.5312,2304.5645,2301.7502,1975.6735,1985.4788,1997.9608,2009.6221,2019.2719,2028.774,2037.6075,2045.6244,2053.7227,2060.2642,2064.6184,2068.6145,2071.854,2075.2307,2076.4412,2075.8823,2075.1643,2080.5908,2086.7598,2092.8533,2097.507,2104.4688,2109.9504,2116.684,2123.1577,2128.982,2133.6746,2138.6304,2142.2273,2146.7773,2154.1145,2160.391,2167.6274,2174.0845,2181.3208,2194.002,2206.587,2223.139,2243.1013,2258.4836,2270.833,2283.9097,2294.0896,2304.1096,2309.5247,2311.0642,2311.1587,2308.5466,2302.9849,2298.6775,2296.212,1979.6226,1988.3824,1999.8674,2009.7131,2019.8191,2030.1486,2038.688,2045.9243,2054.1575,2060.9182,2063.8093,2067.0613,2069.2976,2070.383,2069.814,2068.383,2070.3582,2076.8765,2084.2966,2090.0366,2094.8608,2101.822,2107.5093,2115.5002,2123.1577,2129.7603,2135.2803,2138.463,2143.4546,2148.279,2153.144,2159.2957,2166.1174,2172.3704,2178.8328,2189.2617,2202.2102,2216.2073,2235.3403,2252.502,2264.2468,2275.517,2285.1655,2293.4048,2299.7832,2304.411,2305.383,2301.4736,2297.5403,2293.8008,2290.734,1987.6956,1996.2963,2004.9447,2013.621,2022.6097,2032.2583,2040.1733,2047.3505,2055.9495,2061.648,2063.9297,2064.9417,2064.3362,2062.0757,2061.1045,2061.1045,2067.4783,2074.563,2083.0159,2088.7322,2094.817,2100.8113,2107.264,2114.4563,2121.1047,2127.341,2133.7712,2137.1155,2142.5383,2147.4116,2150.872,2155.861,2161.4094,2166.9683,2174.0942,2184.297,2196.882,2210.3782,2224.9124,2241.3167,2256.1636,2265.8123,2275.4607,2282.7,2289.634,2293.792,2296.2485,2295.0469,2292.2666,2289.4116,2287.6282,1992.858,2001.5168,2011.1653,2020.8137,2029.1257,2037.362,2044.589,2050.2039,2057.013,2061.3972,2062.942,2061.7207,2059.2717,2057.884,2056.9685,2058.8193,2064.0698,2071.3704,2080.3186,2087.555,2093.7373,2099.627,2106.162,2111.4907,2117.645,2122.866,2129.0117,2134.4563,2137.3254,2143.0469,2146.8804,2150.3164,2154.7524,2160.7063,2167.9841,2178.3867,2190.9993,2203.5623,2216.8967,2230.3457,2245.5735,2257.0833,2265.7588,2273.3806,2280.4,2284.279,2287.4133,2288.7136,2286.884,2285.0022,2283.884,1995.5842,2006.4209,2016.0177,2025.1819,2033.8303,2041.3441,2048.728,2052.9255,2057.97,2060.708,2060.7065,2058.1045,2054.398,2053.0315,2054.4893,2057.7397,2063.4756,2071.9243,2080.3186,2087.0366,2092.3406,2097.201,2102.5408,2109.279,2113.3933,2117.0225,2121.3535,2124.8782,2128.0334,2132.342,2138.1663,2143.4746,2148.2988,2154.7559,2161.9863,2171.6501,2184.1687,2196.7124,2208.8057,2221.627,2233.4426,2245.5032,2257.051,2263.5764,2269.1292,2275.0454,2279.021,2282.0315,2282.0315,2280.6045,2279.6897,1999.6208,2010.2306,2019.9137,2028.5253,2036.8606,2045.0669,2050.2175,2054.445,2057.0732,2057.728,2055.4595,2051.826,2047.9689,2049.1353,2053.4216,2058.6619,2065.1025,2072.9927,2080.4248,2086.5183,2090.0137,2093.8643,2098.6665,2103.6023,2108.3745,2111.2678,2113.6719,2115.3416,2117.5164,2121.6372,2129.4233,2135.6597,2142.0093,2149.0686,2156.9792,2166.628,2177.8901,2189.0085,2200.0112,2212.1614,2223.0647,2234.3198,2245.4355,2254.5488,2259.9846,2264.825,2269.6492,2273.5054,2274.4058,2272.4763,2276.6511,2004.8099,2014.0403,2023.3859,2031.1099,2039.0194,2047.834,2051.1606,2053.8562,2054.3318,2051.9297,2049.4531,2046.6633,2044.9065,2048.091,2053.5557,2060.0325,2065.8457,2071.8486,2077.946,2083.3633,2086.5938,2089.6692,2092.7446,2095.9868,2099.6162,2102.6414,2105.789,2106.8052,2109.7815,2115.4844,2121.1448,2128.381,2135.6174,2143.951,2152.127,2160.8877,2171.7717,2182.672,2192.3843,2202.696,2213.066,2222.993,2233.6404,2241.9531,2250.1172,2255.7073,2259.516,2262.3167,2263.4749,2265.5054,2276.4697,2010.5546,2017.85,2025.6906,2033.5361,2041.2664,2048.4973,2051.1606,2052.237,2050.2522,2046.7743,2042.9022,2041.7114,2042.8706,2047.1367,2053.9595,2060.7087,2065.564,2069.6252,2074.3684,2078.511,2081.4211,2083.7114,2084.8904,2086.1152,2087.7646,2092.6887,2097.1145,2100.9639,2106.2812,2109.18,2115.6292,2121.9927,2129.1018,2136.1003,2145.5828,2155.1602,2164.8086,2175.3936,2184.1055,2193.9912,2203.2708,2211.5251,2220.411,2228.6501,2236.945,2244.6523,2248.5608,2251.006,2254.4138,2264.4373,2276.4697,2014.7214,2021.6786,2028.726,2035.9766,2042.135,2047.7012,2050.4497,2050.3188,2046.6548,2040.7526,2035.9674,2038.0741,2042.1976,2046.9021,2053.184,2059.715,2064.1462,2068.505,2070.9172,2074.0422,2074.4329,2073.9014,2072.3,2071.7664,2078.468,2089.1423,2098.74,2105.3066,2108.189,2108.189,2111.1965,2118.1733,2122.3735,2128.874,2136.8008,2147.7136,2158.4402,2167.1785,2175.4785,2183.1426,2193.9312,2199.303,2205.0488,2213.093,2220.3293,2227.421,2234.1565,2241.6165,2252.3486,2263.5273,2275.414,2016.9846,2024.9158,2032.1521,2037.8489,2043.0813,2047.0367,2050.0618,2048.239,2042.4205,2035.8225,2033.3848,2036.4427,2041.267,2046.0631,2051.7578,2058.6094,2063.0056,2067.3882,2070.0,2069.57,2067.2239,2064.1965,2061.7844,2063.4111,2075.6638,2088.7244,2100.7852,2109.5137,2110.3496,2110.4678,2110.4363,2113.2332,2116.9822,2120.8408,2129.3853,2140.2612,2150.7756,2159.9634,2167.1997,2172.445,2177.442,2184.4478,2191.3005,2197.2842,2204.7722,2214.9978,2225.7485,2236.708,2251.492,2262.912,2273.6736,2017.8,2026.3047,2034.5369,2038.9244,2043.295,2045.7072,2046.8689,2043.7299,2037.962,2033.52,2032.8013,2036.4427,2041.2932,2046.0475,2051.4146,2058.6147,2062.564,2066.3882,2067.9956,2065.3623,2060.0562,2055.1492,2052.803,2058.751,2070.215,2080.8396,2092.7915,2101.2798,2104.7927,2104.1533,2103.8442,2106.803,2109.8704,2116.0808,2127.5002,2138.2952,2146.034,2153.646,2159.197,2163.3555,2166.1726,2170.9624,2177.7837,2184.9626,2197.9275,2211.9016,2223.846,2236.2856,2249.2686,2260.4907,2270.416,2017.8,2026.3539,2034.5369,2038.889,2041.5323,2041.7146,2039.4363,2037.0242,2032.6271,2028.5713,2032.5293,2037.5463,2042.7346,2047.5802,2053.8408,2059.6704,2062.8997,2065.694,2067.8442,2062.2197,2052.473,2046.7222,2045.0647,2053.8984,2064.9126,2073.561,2081.3386,2090.1074,2094.1294,2093.1294,2094.1162,2097.8098,2102.8245,2112.8809,2126.4053,2135.7043,2140.6455,2145.5037,2149.4778,2152.4224,2155.2102,2159.9365,2170.9866,2182.4546,2197.9275,2211.0576,2223.2273,2236.2305,2246.8809,2258.0596,2267.5706,2019.962,2026.3005,2033.1307,2037.0305,2039.6992,2036.3842,2032.2467,2028.2788,2023.4546,2024.8583,2032.4277,2039.3365,2045.1608,2051.026,2056.7517,2060.856,2064.1758,2066.694,2066.7876,2059.088,2046.3993,2039.3271,2039.5824,2047.9855,2057.634,2065.3965,2072.2307,2078.9568,2084.3425,2083.7852,2086.4216,2091.2458,2097.8267,2109.3945,2120.1187,2128.649,2132.8984,2136.3542,2138.7732,2141.1853,2147.1638,2157.8623,2170.9846,2182.4546,2196.9463,2210.248,2222.8728,2234.3364,2244.9849,2255.5278,2264.019,2021.4,2026.8802,2031.5405,2035.2329,2036.2357,2030.6229,2024.3982,2019.574,2018.035,2023.9984,2033.2369,2040.6641,2047.587,2054.4568,2060.0889,2063.19,2065.0903,2067.486,2064.3613,2055.25,2042.9583,2034.5479,2033.9476,2040.2734,2048.4563,2056.6926,2062.526,2067.35,2070.6997,2073.3591,2079.5146,2086.9226,2093.9873,2103.1917,2111.8198,2117.624,2120.924,2123.3794,2126.4282,2132.048,2146.7463,2158.9243,2171.983,2183.0457,2195.9846,2208.9214,2221.2617,2231.5903,2241.389,2251.807,2259.5618,2019.9075,2024.6077,2027.0198,2029.6855,2028.593,2023.5153,2015.5326,2010.4701,2013.9438,2023.5885,2033.2369,2041.8292,2049.6467,2056.8945,2061.4578,2063.967,2065.282,2068.0,2062.7085,2051.7844,2040.5321,2032.0574,2028.5159,2032.8833,2039.1836,2046.9879,2051.821,2056.037,2059.496,2065.4106,2074.662,2081.6887,2087.735,2094.8787,2100.5928,2105.4092,2108.793,2110.5063,2116.9785,2130.3853,2146.8638,2159.9243,2171.985,2183.3508,2196.2395,2207.4204,2218.8357,2227.6802,2236.856,2247.0347,2254.8623,2013.8826,2017.6656,2020.9949,2022.4696,2019.8096,2014.0642,2005.9769,2005.2013,2011.9524,2022.4845,2032.9066,2041.8854,2049.9004,2057.9265,2061.8364,2064.0198,2065.3306,2066.1863,2060.2783,2047.153,2037.1058,2025.4574,2022.452,2025.8162,2030.6404,2034.472,2038.8744,2043.5637,2049.1646,2058.0405,2067.5076,2074.2375,2078.9106,2083.7136,2088.5378,2092.362,2095.9248,2104.3262,2115.394,2128.3914,2143.6917,2158.5796,2169.8125,2182.2117,2195.9092,2204.223,2213.0645,2221.828,2230.2805,2239.8374,2248.3645,2005.7244,2009.7655,2012.7163,2014.204,2011.3295,2002.2634,1996.7382,2000.6929,2010.946,2020.9897,2031.4475,2040.7529,2048.9004,2056.538,2061.4578,2063.922,2065.113,2063.4146,2054.862,2042.7295,2033.081,2023.1687,2016.899,2017.9388,2022.5308,2025.5927,2028.4115,2033.6497,2041.886,2049.7395,2056.1099,2061.613,2066.1597,2070.8682,2074.9875,2079.7666,2088.615,2101.0198,2114.144,2125.653,2138.6665,2152.948,2165.1907,2176.2495,2187.5493,2196.3054,2202.943,2212.1086,2222.2957,2230.7312,2240.487,1995.9583,2000.9783,2003.4128,2003.8774,1999.5046,1990.6234,1990.5933,1999.2915,2008.9152,2018.5636,2029.0214,2038.6143,2045.8507,2053.0176,2058.8408,2060.947,2060.9185,2057.7935,2046.629,2038.3954,2029.2534,2020.605,2010.9565,2009.2797,2013.4938,2016.8915,2019.7416,2027.2158,2034.3744,2039.1387,2041.9514,2045.7284,2049.5776,2055.7217,2063.0354,2074.536,2086.5967,2098.6572,2111.3606,2120.993,2132.7935,2145.8352,2157.8855,2167.5122,2175.3438,2180.5757,2189.4238,2198.1636,2210.6821,2221.4277,2231.0835,1983.5957,1988.945,1992.4769,1990.8617,1984.8868,1981.1957,1986.7408,1997.3894,2006.0446,2016.1375,2025.7859,2034.762,2040.7125,2046.7379,2050.8599,2052.673,2051.9138,2047.4266,2040.7793,2033.0919,2025.3066,2016.8822,2007.9446,2000.7383,2004.0923,2006.7356,2013.3827,2022.9911,2025.8741,2026.5468,2027.7961,2030.8685,2035.8495,2046.8306,2058.665,2073.1099,2084.646,2094.8435,2107.0408,2116.1404,2125.5105,2137.12,2148.1836,2156.2385,2163.2083,2168.8655,2176.4578,2187.452,2199.5442,2211.6582,2220.984,1973.6277,1978.5911,1980.6136,1978.6892,1974.1945,1972.9022,1981.8885,1991.6073,2001.3081,2012.7112,2022.383,2029.005,2034.6351,2039.4137,2041.9486,2043.4749,2041.297,2038.1028,2034.0497,2026.8132,2019.5769,2012.2179,2003.2268,1993.9088,1993.7003,1997.3502,2008.3342,2014.2607,2015.4142,2014.2974,2016.6393,2024.9775,2036.3806,2046.4397,2057.5002,2071.67,2082.7441,2091.0469,2100.6824,2109.6501,2118.0803,2128.3435,2137.482,2145.7183,2151.256,2156.109,2167.2844,2178.7212,2191.1863,2203.7773,2212.544,1961.2826,1967.956,1970.4825,1968.9143,1963.5516,1967.5627,1976.6206,1984.988,1995.632,2008.0752,2016.8208,2023.5322,2027.6118,2030.8317,2033.1049,2033.4825,2031.5042,2029.1848,2025.5737,2019.2312,2012.2772,2005.062,1996.0709,1985.2263,1985.3751,1992.0625,1999.7146,2004.4727,2004.3242,2005.0651,2011.3096,2024.8549,2035.1998,2044.8483,2056.1968,2067.92,2077.331,2085.8987,2092.7258,2099.367,2109.477,2118.5408,2126.4736,2132.8892,2137.8215,2143.7903,2158.4119,2172.2622,2181.6228,2196.1235,2204.176,1950.8812,1957.2816,1960.5935,1958.2324,1955.6633,1961.9889,1971.9133,1983.1348,1993.2103,2002.3994,2010.2386,2015.0922,2018.6156,2021.0936,2021.622,2022.3516,2021.3516,2019.6575,2016.8689,2011.2561,2005.0009,1997.4408,1987.8586,1978.5809,1978.1252,1985.0543,1990.432,1993.4371,1994.9768,1999.1887,2011.2579,2022.7338,2032.7736,2042.4999,2052.2598,2062.9075,2070.3838,2076.937,2081.303,2089.3633,2098.0894,2107.1062,2115.0723,2121.8994,2125.9941,2136.7705,2150.3293,2163.3115,2172.9602,2183.967,2198.0103,1939.97,1949.1804,1950.3765,1948.8158,1949.5696,1958.9946,1969.4872,1980.6193,1989.7968,1996.8796,2003.1508,2006.7537,2008.3765,2008.3765,2008.3765,2008.3765,2008.6145,2008.6346,2007.2703,2003.4957,1997.4402,1987.3489,1979.4755,1971.1729,1969.7338,1974.3584,1978.6237,1982.134,1987.1013,1997.402,2010.8945,2019.6267,2028.0549,2037.3961,2047.3325,2054.8513,2061.269,2065.0935,2072.431,2081.9329,2090.0505,2097.1958,2103.212,2109.1025,2117.7893,2131.052,2142.815,2154.7627,2164.5671,2176.9607,2191.562,1932.3538,1937.8301,1939.9556,1941.1342,1948.6234,1958.3075,1967.9674,1977.1273,1986.3641,1991.796,1996.8722,1999.3462,1999.4069,1998.6261,1997.9381,1998.6716,1998.6716,1998.6716,1998.5654,1995.1167,1986.4916,1979.2262,1971.9897,1964.3356,1961.2388,1965.2357,1968.9619,1974.8636,1986.7771,1995.1265,2006.5201,2014.957,2022.391,2030.1176,2037.7719,2044.1029,2046.5358,2054.989,2065.7935,2075.3962,2083.1177,2088.4236,2093.2478,2099.2993,2111.2852,2124.5564,2137.6453,2149.7058,2161.2966,2173.1462,2188.0105,1924.6752,1928.067,1929.9957,1937.6893,1947.6743,1956.2377,1963.7955,1974.2832,1981.9385,1986.7777,1989.7926,1989.9733,1988.9698,1988.9668,1988.9706,1989.974,1991.2571,1991.9808,1990.8772,1986.9425,1979.2534,1971.9475,1964.7091,1959.8167,1957.9834,1958.9827,1964.6091,1972.4374,1982.8845,1990.9019,1998.189,2007.3541,2012.7112,2020.0913,2025.342,2029.1755,2034.0242,2046.5222,2057.3665,2066.0115,2072.492,2079.7346,2085.9827,2094.2239,2105.926,2120.6316,2135.219,2148.2795,2159.8706,2171.3926,2184.4531,1917.0924,1919.4492,1925.1024,1935.1876,1945.3903,1953.8114,1962.1177,1970.857,1977.5355,1980.5802,1982.262,1981.262,1980.6965,1980.6965,1980.4977,1980.7539,1983.1095,1985.089,1985.0848,1981.3668,1973.4094,1964.3264,1958.1873,1953.8918,1952.948,1956.5475,1963.3717,1968.7615,1975.9441,1984.4583,1991.3652,1997.4517,2001.6332,2005.5286,2011.7968,2019.5162,2028.2281,2037.9994,2049.9392,2057.9785,2067.159,2076.3396,2084.9893,2094.405,2105.8264,2119.2988,2132.639,2144.419,2157.2139,2167.0928,2179.294,1909.1597,1915.3145,1923.5369,1933.6221,1942.4855,1951.3502,1960.5046,1967.3649,1972.388,1974.418,1972.7214,1971.5573,1972.5061,1972.5573,1972.0995,1970.5573,1973.0818,1977.1119,1978.4031,1976.6881,1967.7561,1957.9562,1950.9086,1948.1118,1948.7181,1953.1213,1957.2241,1962.9348,1968.1,1974.4756,1980.9762,1986.4846,1990.555,1997.1425,2006.6814,2015.4758,2022.8514,2030.2272,2040.2998,2051.8757,2065.1519,2076.3396,2085.988,2095.5542,2106.1062,2116.1052,2128.1514,2140.3777,2151.6926,2162.806,2173.4954,1903.5131,1915.372,1925.0492,1932.7732,1941.0096,1948.1383,1955.9084,1962.285,1966.1243,1965.7422,1963.0432,1961.9159,1962.8524,1963.533,1961.3947,1960.1393,1963.9851,1969.5275,1973.8828,1971.4462,1962.7046,1953.343,1946.742,1943.6653,1943.839,1947.1302,1949.8293,1952.7207,1959.8809,1966.0577,1971.7646,1976.6843,1984.3049,1992.3727,2001.0256,2009.3959,2017.0131,2026.7456,2038.4557,2050.5164,2062.8728,2074.8848,2084.7012,2094.9282,2103.998,2112.6465,2122.008,2134.3696,2145.4878,2156.6665,2167.3152],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD029.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD029.py load and self-test diagnostics complete.")
