package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD028Index.html" target="_blank">SquawLOD028</a>,  source <a href="../../../Geospatial/SquawLOD028.java">SquawLOD028.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD028.x3d">SquawLOD028.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD028.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD028.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD028
{
	/** Default constructor to create this object. */
	public SquawLOD028 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD028.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD028.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD028.x3d"))
    .addChild(new GeoLOD().setCenter(4344113.536173,743014.624947,2137.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(16133.333).setChild1Url(new String[] {"SquawLOD029.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD029.x3d"})
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw014.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw014.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4343332.077840,742430.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(25).setXSpacing(50.750000).setZDimension(33).setZSpacing(50.416667).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {2000.4667,2023.6138,2044.4554,2061.8062,2073.1296,2085.85,2089.8235,2091.4106,2092.104,2098.7234,2112.1528,2126.0732,2139.325,2153.965,2165.0015,2180.88,2194.4504,2207.5962,2220.1724,2225.0242,2229.0198,2227.8918,2219.9226,2215.9934,2213.9868,1987.2188,2009.7742,2027.9541,2046.294,2056.8052,2065.048,2070.0693,2073.0889,2081.0305,2094.5107,2108.023,2118.946,2133.7124,2147.7268,2161.6472,2175.316,2187.7134,2205.5024,2220.1724,2227.1458,2231.0825,2225.7207,2218.0,2215.87,2214.0938,1974.6819,1994.0547,2014.7297,2030.5912,2043.3982,2046.9125,2051.342,2059.8684,2071.8154,2085.149,2097.6504,2108.934,2121.505,2133.7783,2147.6414,2161.5781,2178.7961,2197.49,2215.571,2227.241,2230.8809,2222.9019,2217.9338,2216.0613,2217.059,1972.1486,1994.4818,2010.1827,2021.1152,2032.0135,2038.4681,2043.4292,2054.3425,2066.2874,2076.787,2085.72,2097.6426,2108.6301,2121.89,2136.1062,2150.9827,2170.6326,2187.528,2205.468,2221.4094,2226.9543,2219.0244,2219.228,2224.073,2223.0354};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {1986.3656,1998.2207,2007.1925,2015.144,2021.0104,2030.573,2042.9193,2056.8906,2063.8582,2071.4106,2080.7686,2094.0627,2110.9763,2126.8965,2139.8215,2150.7449,2164.6758,2181.9812,2203.5063,2218.2915,2226.109,2229.0823,2234.0454,2235.9788,2232.9658,1997.5646,2004.2003,2012.1205,2023.5933,2033.3627,2043.4148,2060.3354,2071.792,2077.7192,2083.2754,2085.8818,2097.0732,2115.31,2129.6096,2143.7896,2154.4583,2168.8457,2188.9124,2212.5986,2224.2012,2230.0742,2236.1362,2242.021,2245.9548,2239.941,2014.9806,2010.8403,2019.0804,2036.5496,2047.3037,2055.8352,2070.311,2082.7678,2090.2776,2096.1711,2096.791,2096.6643,2113.4048,2128.9143,2143.1707,2156.4438,2172.883,2195.8499,2220.6753,2233.0542,2237.969,2244.9404,2251.0474,2254.8403,2250.7217,2033.1417,2028.613,2032.3208,2048.3655,2061.3762,2066.2876,2073.4707,2090.2236,2100.6453,2106.7034,2109.111,2109.6973,2113.8792,2126.0288,2138.9492,2154.8699,2174.0156,2195.1084,2219.784,2234.275,2242.0183,2249.9783,2256.893,2259.8855,2253.972};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2047.3014,2047.0255,2048.552,2058.3464,2067.9373,2076.6577,2086.1155,2097.242,2110.2878,2117.112,2123.0283,2125.552,2125.552,2128.7925,2139.6855,2153.3542,2170.1262,2191.795,2214.7146,2234.4373,2247.089,2255.808,2260.917,2265.8845,2260.6616,2059.232,2057.2546,2061.7417,2065.3857,2071.9866,2083.8494,2093.7964,2103.2664,2114.2312,2126.4534,2135.016,2138.9238,2140.7183,2138.448,2143.3726,2157.5713,2175.717,2194.611,2215.8613,2238.399,2254.8923,2261.9087,2265.8823,2270.0325,2267.9844,2068.3157,2066.48,2070.1587,2073.2263,2076.2246,2085.5168,2095.3635,2106.2898,2116.6558,2132.1033,2141.5498,2149.9202,2152.085,2149.4958,2155.8408,2167.6836,2179.1116,2196.795,2216.689,2240.7288,2260.4248,2269.7812,2272.6287,2275.7812,2273.5493,2079.8396,2076.7747,2077.1917,2080.1719,2082.6309,2086.5168,2095.6145,2106.9275,2117.8745,2133.2322,2145.8992,2159.1042,2160.4153,2157.4932,2167.1448,2184.931,2197.2402,2207.836,2222.5466,2241.3665,2263.3577,2273.9321,2279.8127,2282.7466,2282.4832};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2093.0237,2086.089,2082.54,2085.4055,2087.3867,2089.8608,2094.6316,2105.061,2117.7124,2133.0625,2150.1382,2161.2546,2165.9475,2170.0332,2178.7722,2200.106,2218.8113,2226.014,2241.6025,2255.1387,2267.4932,2280.6091,2287.4897,2290.4634,2291.4104,2095.9229,2085.7002,2079.6458,2082.2156,2083.8213,2083.6458,2092.2903,2106.2415,2122.9888,2139.1875,2155.4128,2164.3926,2172.0083,2179.2866,2200.1443,2223.8044,2238.159,2244.499,2257.3757,2269.7915,2284.3083,2294.1868,2301.8408,2308.0312,2305.9958,2085.4153,2077.247,2066.69,2068.2766,2066.2363,2073.908,2091.961,2108.3914,2126.3118,2140.8215,2153.7307,2160.8433,2169.3777,2179.272,2198.186,2223.5835,2249.4033,2261.6821,2272.3823,2282.913,2296.8384,2315.192,2327.5627,2329.8428,2323.1768,2069.0618,2069.0796,2054.8376,2049.4006,2052.3806,2068.5837,2090.6514,2106.7837,2124.704,2138.6245,2146.7847,2148.535,2155.3171,2167.514,2184.29,2206.283,2232.0093,2256.485,2280.5168,2295.2915,2307.573,2330.8926,2352.2815,2351.351,2338.7964};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {2047.8093,2048.9246,2043.8574,2035.7504,2050.4346,2069.5837,2088.1787,2103.8184,2118.7388,2128.1191,2129.9285,2138.7747,2148.3752,2157.1667,2169.8079,2191.4324,2216.4075,2237.6172,2260.169,2285.9265,2306.331,2321.1323,2338.5745,2352.8938,2350.8088,2025.009,2026.8472,2023.251,2029.8488,2048.6296,2066.7888,2083.9326,2097.6035,2108.8228,2109.8472,2118.4077,2131.6392,2141.433,2150.0713,2159.7583,2176.3923,2200.9287,2220.1804,2240.7085,2265.9685,2287.7432,2305.8992,2326.6707,2338.942,2334.8208,1998.6862,2001.7961,2016.0918,2034.7825,2052.403,2066.5503,2079.2205,2088.6902,2092.2102,2098.7288,2112.2651,2122.7085,2131.6555,2142.6025,2152.4644,2165.875,2182.7737,2202.1858,2231.2058,2264.2322,2290.0996,2311.4707,2325.026,2324.423,2313.4697,1976.4812,1998.4056,2020.0682,2038.9763,2055.0984,2066.0334,2073.282,2077.0916,2078.2043,2091.0767,2102.2153,2114.9458,2127.6626,2137.6096,2145.687,2159.7554,2174.207,2195.0562,2226.2249,2260.7913,2287.0708,2307.3105,2312.5938,2307.4746,2298.0493};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1987.102,2004.7931,2023.253,2041.4657,2057.8655,2064.5168,2064.2078,2061.698,2071.1252,2086.3875,2098.1528,2112.0732,2125.5598,2136.4773,2146.965,2156.0588,2167.3738,2185.1257,2212.0906,2244.85,2268.741,2285.5422,2295.896,2294.6357,2288.5603,1995.4993,2016.2897,2034.7843,2049.3113,2058.5432,2060.3943,2053.7112,2055.5718,2067.4863,2084.2322,2095.3691,2107.2747,2116.5327,2124.7075,2131.9592,2143.3057,2154.787,2172.3145,2198.264,2224.1316,2248.6714,2265.5884,2277.0962,2282.2014,2280.196,2004.8938,2023.8556,2040.1141,2051.5698,2053.5295,2048.7542,2045.3044,2056.3914,2068.8745,2081.0923,2088.655,2094.8994,2101.6292,2106.211,2114.5642,2127.6616,2143.664,2161.2646,2183.5952,2204.1248,2225.0945,2244.4893,2257.0146,2262.2168,2269.0796,2014.9608,2029.1981,2042.9219,2051.0935,2045.2538,2035.5107,2043.8187,2056.0613,2066.1675,2072.3562,2073.8835,2070.7986,2085.7656,2104.9216,2108.3298,2117.675,2128.2053,2147.541,2167.6995,2183.9353,2199.7085,2214.299,2229.2195,2244.5652,2269.0662};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {2017.8,2034.8683,2043.3011,2045.9464,2036.3232,2033.5167,2043.131,2054.6863,2064.4373,2067.1729,2056.2327,2054.6511,2077.4397,2098.7336,2103.246,2105.6182,2115.3772,2138.301,2153.3362,2162.965,2170.882,2187.9282,2215.3313,2240.9153,2264.7578,2020.3605,2033.0834,2038.988,2030.5006,2022.1963,2034.6848,2047.7312,2059.3276,2065.4373,2062.5073,2041.2263,2043.6498,2062.2124,2075.5327,2082.5647,2090.0483,2108.3801,2127.0955,2134.87,2140.3257,2160.9448,2186.5564,2214.3313,2237.928,2258.789,2018.9486,2026.1714,2026.7267,2012.5166,2015.9473,2036.067,2052.4707,2063.0486,2066.776,2057.0842,2034.4481,2030.0385,2042.8652,2053.0193,2062.436,2079.8264,2092.7222,2102.8894,2108.7063,2132.9873,2162.5962,2187.5774,2210.88,2229.6987,2249.3657,2003.6361,2010.8589,2008.1426,1995.7268,2012.982,2033.9747,2051.0889,2062.2727,2064.181,2045.4983,2026.272,2014.5939,2022.5674,2030.3995,2046.6017,2057.5613,2067.1567,2077.298,2102.154,2126.4648,2154.1426,2177.6072,2195.9993,2213.8374,2233.289};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1980.775,1989.2188,1981.0894,1986.9666,2007.4751,2027.3185,2041.0817,2049.375,2047.4126,2034.9524,2019.0543,2000.6143,2002.6018,2019.2893,2023.2188,2027.9572,2046.1262,2072.9626,2094.678,2115.9912,2136.9712,2154.6533,2167.372,2189.5737,2213.5823,1957.3138,1966.5896,1960.7079,1976.0359,1997.5287,2017.1229,2026.0042,2029.5139,2027.5823,2019.4032,2005.4827,1986.2479,1987.7507,2000.8186,2001.2257,2023.8855,2043.8069,2066.552,2083.8584,2096.3289,2116.75,2130.4963,2145.2046,2172.7944,2197.675,1936.8396,1946.5659,1949.7887,1970.279,1990.4562,2001.8151,2004.6528,2004.6062,2004.6528,2002.3289,1987.1492,1970.6664,1969.3153,1976.6538,1995.0889,2017.5817,2034.4153,2052.033,2061.3418,2081.1768,2094.8914,2107.1106,2133.0708,2156.112,2182.9915,1921.5437,1926.8162,1947.9292,1964.7894,1980.9823,1987.3019,1984.8438,1985.7916,1988.8438,1987.0743,1971.691,1958.5194,1957.2444,1969.8463,1987.6785,2002.3082,2012.4036,2023.44,2043.8772,2063.281,2079.3057,2095.511,2125.3455,2152.0967,2174.9753};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1904.7826,1924.5084,1942.3746,1960.2344,1969.4991,1967.9216,1967.9305,1966.4495,1970.8224,1976.5546,1959.4282,1946.6075,1949.6221,1957.5348,1969.492,1980.6858,1994.641,2012.5581,2029.6572,2052.872,2077.477,2098.3694,2118.1653,2142.1467,2165.0012};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.04167,0.00391,0.08333,0.00391,0.125,0.00391,0.16667,0.00391,0.20833,0.00391,0.25,0.00391,0.29167,0.00391,0.33333,0.00391,0.375,0.00391,0.41667,0.00391,0.45833,0.00391,0.5,0.00391,0.54167,0.00391,0.58333,0.00391,0.625,0.00391,0.66667,0.00391,0.70833,0.00391,0.75,0.00391,0.79167,0.00391,0.83333,0.00391,0.875,0.00391,0.91667,0.00391,0.95833,0.00391,0.99609,0.00391,0.00391,0.03125,0.04167,0.03125,0.08333,0.03125,0.125,0.03125,0.16667,0.03125,0.20833,0.03125,0.25,0.03125,0.29167,0.03125,0.33333,0.03125,0.375,0.03125,0.41667,0.03125,0.45833,0.03125,0.5,0.03125,0.54167,0.03125,0.58333,0.03125,0.625,0.03125,0.66667,0.03125,0.70833,0.03125,0.75,0.03125,0.79167,0.03125,0.83333,0.03125,0.875,0.03125,0.91667,0.03125,0.95833,0.03125,0.99609,0.03125,0.00391,0.0625,0.04167,0.0625,0.08333,0.0625,0.125,0.0625,0.16667,0.0625,0.20833,0.0625,0.25,0.0625,0.29167,0.0625,0.33333,0.0625,0.375,0.0625,0.41667,0.0625,0.45833,0.0625,0.5,0.0625,0.54167,0.0625,0.58333,0.0625,0.625,0.0625,0.66667,0.0625,0.70833,0.0625,0.75,0.0625,0.79167,0.0625,0.83333,0.0625,0.875,0.0625,0.91667,0.0625,0.95833,0.0625,0.99609,0.0625,0.00391,0.09375,0.04167,0.09375,0.08333,0.09375,0.125,0.09375,0.16667,0.09375,0.20833,0.09375,0.25,0.09375,0.29167,0.09375,0.33333,0.09375,0.375,0.09375,0.41667,0.09375,0.45833,0.09375,0.5,0.09375,0.54167,0.09375,0.58333,0.09375,0.625,0.09375,0.66667,0.09375,0.70833,0.09375,0.75,0.09375,0.79167,0.09375,0.83333,0.09375,0.875,0.09375,0.91667,0.09375,0.95833,0.09375,0.99609,0.09375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.00391,0.125,0.04167,0.125,0.08333,0.125,0.125,0.125,0.16667,0.125,0.20833,0.125,0.25,0.125,0.29167,0.125,0.33333,0.125,0.375,0.125,0.41667,0.125,0.45833,0.125,0.5,0.125,0.54167,0.125,0.58333,0.125,0.625,0.125,0.66667,0.125,0.70833,0.125,0.75,0.125,0.79167,0.125,0.83333,0.125,0.875,0.125,0.91667,0.125,0.95833,0.125,0.99609,0.125,0.00391,0.15625,0.04167,0.15625,0.08333,0.15625,0.125,0.15625,0.16667,0.15625,0.20833,0.15625,0.25,0.15625,0.29167,0.15625,0.33333,0.15625,0.375,0.15625,0.41667,0.15625,0.45833,0.15625,0.5,0.15625,0.54167,0.15625,0.58333,0.15625,0.625,0.15625,0.66667,0.15625,0.70833,0.15625,0.75,0.15625,0.79167,0.15625,0.83333,0.15625,0.875,0.15625,0.91667,0.15625,0.95833,0.15625,0.99609,0.15625,0.00391,0.1875,0.04167,0.1875,0.08333,0.1875,0.125,0.1875,0.16667,0.1875,0.20833,0.1875,0.25,0.1875,0.29167,0.1875,0.33333,0.1875,0.375,0.1875,0.41667,0.1875,0.45833,0.1875,0.5,0.1875,0.54167,0.1875,0.58333,0.1875,0.625,0.1875,0.66667,0.1875,0.70833,0.1875,0.75,0.1875,0.79167,0.1875,0.83333,0.1875,0.875,0.1875,0.91667,0.1875,0.95833,0.1875,0.99609,0.1875,0.00391,0.21875,0.04167,0.21875,0.08333,0.21875,0.125,0.21875,0.16667,0.21875,0.20833,0.21875,0.25,0.21875,0.29167,0.21875,0.33333,0.21875,0.375,0.21875,0.41667,0.21875,0.45833,0.21875,0.5,0.21875,0.54167,0.21875,0.58333,0.21875,0.625,0.21875,0.66667,0.21875,0.70833,0.21875,0.75,0.21875,0.79167,0.21875,0.83333,0.21875,0.875,0.21875,0.91667,0.21875,0.95833,0.21875,0.99609,0.21875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.00391,0.25,0.04167,0.25,0.08333,0.25,0.125,0.25,0.16667,0.25,0.20833,0.25,0.25,0.25,0.29167,0.25,0.33333,0.25,0.375,0.25,0.41667,0.25,0.45833,0.25,0.5,0.25,0.54167,0.25,0.58333,0.25,0.625,0.25,0.66667,0.25,0.70833,0.25,0.75,0.25,0.79167,0.25,0.83333,0.25,0.875,0.25,0.91667,0.25,0.95833,0.25,0.99609,0.25,0.00391,0.28125,0.04167,0.28125,0.08333,0.28125,0.125,0.28125,0.16667,0.28125,0.20833,0.28125,0.25,0.28125,0.29167,0.28125,0.33333,0.28125,0.375,0.28125,0.41667,0.28125,0.45833,0.28125,0.5,0.28125,0.54167,0.28125,0.58333,0.28125,0.625,0.28125,0.66667,0.28125,0.70833,0.28125,0.75,0.28125,0.79167,0.28125,0.83333,0.28125,0.875,0.28125,0.91667,0.28125,0.95833,0.28125,0.99609,0.28125,0.00391,0.3125,0.04167,0.3125,0.08333,0.3125,0.125,0.3125,0.16667,0.3125,0.20833,0.3125,0.25,0.3125,0.29167,0.3125,0.33333,0.3125,0.375,0.3125,0.41667,0.3125,0.45833,0.3125,0.5,0.3125,0.54167,0.3125,0.58333,0.3125,0.625,0.3125,0.66667,0.3125,0.70833,0.3125,0.75,0.3125,0.79167,0.3125,0.83333,0.3125,0.875,0.3125,0.91667,0.3125,0.95833,0.3125,0.99609,0.3125,0.00391,0.34375,0.04167,0.34375,0.08333,0.34375,0.125,0.34375,0.16667,0.34375,0.20833,0.34375,0.25,0.34375,0.29167,0.34375,0.33333,0.34375,0.375,0.34375,0.41667,0.34375,0.45833,0.34375,0.5,0.34375,0.54167,0.34375,0.58333,0.34375,0.625,0.34375,0.66667,0.34375,0.70833,0.34375,0.75,0.34375,0.79167,0.34375,0.83333,0.34375,0.875,0.34375,0.91667,0.34375,0.95833,0.34375,0.99609,0.34375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.00391,0.375,0.04167,0.375,0.08333,0.375,0.125,0.375,0.16667,0.375,0.20833,0.375,0.25,0.375,0.29167,0.375,0.33333,0.375,0.375,0.375,0.41667,0.375,0.45833,0.375,0.5,0.375,0.54167,0.375,0.58333,0.375,0.625,0.375,0.66667,0.375,0.70833,0.375,0.75,0.375,0.79167,0.375,0.83333,0.375,0.875,0.375,0.91667,0.375,0.95833,0.375,0.99609,0.375,0.00391,0.40625,0.04167,0.40625,0.08333,0.40625,0.125,0.40625,0.16667,0.40625,0.20833,0.40625,0.25,0.40625,0.29167,0.40625,0.33333,0.40625,0.375,0.40625,0.41667,0.40625,0.45833,0.40625,0.5,0.40625,0.54167,0.40625,0.58333,0.40625,0.625,0.40625,0.66667,0.40625,0.70833,0.40625,0.75,0.40625,0.79167,0.40625,0.83333,0.40625,0.875,0.40625,0.91667,0.40625,0.95833,0.40625,0.99609,0.40625,0.00391,0.4375,0.04167,0.4375,0.08333,0.4375,0.125,0.4375,0.16667,0.4375,0.20833,0.4375,0.25,0.4375,0.29167,0.4375,0.33333,0.4375,0.375,0.4375,0.41667,0.4375,0.45833,0.4375,0.5,0.4375,0.54167,0.4375,0.58333,0.4375,0.625,0.4375,0.66667,0.4375,0.70833,0.4375,0.75,0.4375,0.79167,0.4375,0.83333,0.4375,0.875,0.4375,0.91667,0.4375,0.95833,0.4375,0.99609,0.4375,0.00391,0.46875,0.04167,0.46875,0.08333,0.46875,0.125,0.46875,0.16667,0.46875,0.20833,0.46875,0.25,0.46875,0.29167,0.46875,0.33333,0.46875,0.375,0.46875,0.41667,0.46875,0.45833,0.46875,0.5,0.46875,0.54167,0.46875,0.58333,0.46875,0.625,0.46875,0.66667,0.46875,0.70833,0.46875,0.75,0.46875,0.79167,0.46875,0.83333,0.46875,0.875,0.46875,0.91667,0.46875,0.95833,0.46875,0.99609,0.46875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.00391,0.5,0.04167,0.5,0.08333,0.5,0.125,0.5,0.16667,0.5,0.20833,0.5,0.25,0.5,0.29167,0.5,0.33333,0.5,0.375,0.5,0.41667,0.5,0.45833,0.5,0.5,0.5,0.54167,0.5,0.58333,0.5,0.625,0.5,0.66667,0.5,0.70833,0.5,0.75,0.5,0.79167,0.5,0.83333,0.5,0.875,0.5,0.91667,0.5,0.95833,0.5,0.99609,0.5,0.00391,0.53125,0.04167,0.53125,0.08333,0.53125,0.125,0.53125,0.16667,0.53125,0.20833,0.53125,0.25,0.53125,0.29167,0.53125,0.33333,0.53125,0.375,0.53125,0.41667,0.53125,0.45833,0.53125,0.5,0.53125,0.54167,0.53125,0.58333,0.53125,0.625,0.53125,0.66667,0.53125,0.70833,0.53125,0.75,0.53125,0.79167,0.53125,0.83333,0.53125,0.875,0.53125,0.91667,0.53125,0.95833,0.53125,0.99609,0.53125,0.00391,0.5625,0.04167,0.5625,0.08333,0.5625,0.125,0.5625,0.16667,0.5625,0.20833,0.5625,0.25,0.5625,0.29167,0.5625,0.33333,0.5625,0.375,0.5625,0.41667,0.5625,0.45833,0.5625,0.5,0.5625,0.54167,0.5625,0.58333,0.5625,0.625,0.5625,0.66667,0.5625,0.70833,0.5625,0.75,0.5625,0.79167,0.5625,0.83333,0.5625,0.875,0.5625,0.91667,0.5625,0.95833,0.5625,0.99609,0.5625,0.00391,0.59375,0.04167,0.59375,0.08333,0.59375,0.125,0.59375,0.16667,0.59375,0.20833,0.59375,0.25,0.59375,0.29167,0.59375,0.33333,0.59375,0.375,0.59375,0.41667,0.59375,0.45833,0.59375,0.5,0.59375,0.54167,0.59375,0.58333,0.59375,0.625,0.59375,0.66667,0.59375,0.70833,0.59375,0.75,0.59375,0.79167,0.59375,0.83333,0.59375,0.875,0.59375,0.91667,0.59375,0.95833,0.59375,0.99609,0.59375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.00391,0.625,0.04167,0.625,0.08333,0.625,0.125,0.625,0.16667,0.625,0.20833,0.625,0.25,0.625,0.29167,0.625,0.33333,0.625,0.375,0.625,0.41667,0.625,0.45833,0.625,0.5,0.625,0.54167,0.625,0.58333,0.625,0.625,0.625,0.66667,0.625,0.70833,0.625,0.75,0.625,0.79167,0.625,0.83333,0.625,0.875,0.625,0.91667,0.625,0.95833,0.625,0.99609,0.625,0.00391,0.65625,0.04167,0.65625,0.08333,0.65625,0.125,0.65625,0.16667,0.65625,0.20833,0.65625,0.25,0.65625,0.29167,0.65625,0.33333,0.65625,0.375,0.65625,0.41667,0.65625,0.45833,0.65625,0.5,0.65625,0.54167,0.65625,0.58333,0.65625,0.625,0.65625,0.66667,0.65625,0.70833,0.65625,0.75,0.65625,0.79167,0.65625,0.83333,0.65625,0.875,0.65625,0.91667,0.65625,0.95833,0.65625,0.99609,0.65625,0.00391,0.6875,0.04167,0.6875,0.08333,0.6875,0.125,0.6875,0.16667,0.6875,0.20833,0.6875,0.25,0.6875,0.29167,0.6875,0.33333,0.6875,0.375,0.6875,0.41667,0.6875,0.45833,0.6875,0.5,0.6875,0.54167,0.6875,0.58333,0.6875,0.625,0.6875,0.66667,0.6875,0.70833,0.6875,0.75,0.6875,0.79167,0.6875,0.83333,0.6875,0.875,0.6875,0.91667,0.6875,0.95833,0.6875,0.99609,0.6875,0.00391,0.71875,0.04167,0.71875,0.08333,0.71875,0.125,0.71875,0.16667,0.71875,0.20833,0.71875,0.25,0.71875,0.29167,0.71875,0.33333,0.71875,0.375,0.71875,0.41667,0.71875,0.45833,0.71875,0.5,0.71875,0.54167,0.71875,0.58333,0.71875,0.625,0.71875,0.66667,0.71875,0.70833,0.71875,0.75,0.71875,0.79167,0.71875,0.83333,0.71875,0.875,0.71875,0.91667,0.71875,0.95833,0.71875,0.99609,0.71875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.00391,0.75,0.04167,0.75,0.08333,0.75,0.125,0.75,0.16667,0.75,0.20833,0.75,0.25,0.75,0.29167,0.75,0.33333,0.75,0.375,0.75,0.41667,0.75,0.45833,0.75,0.5,0.75,0.54167,0.75,0.58333,0.75,0.625,0.75,0.66667,0.75,0.70833,0.75,0.75,0.75,0.79167,0.75,0.83333,0.75,0.875,0.75,0.91667,0.75,0.95833,0.75,0.99609,0.75,0.00391,0.78125,0.04167,0.78125,0.08333,0.78125,0.125,0.78125,0.16667,0.78125,0.20833,0.78125,0.25,0.78125,0.29167,0.78125,0.33333,0.78125,0.375,0.78125,0.41667,0.78125,0.45833,0.78125,0.5,0.78125,0.54167,0.78125,0.58333,0.78125,0.625,0.78125,0.66667,0.78125,0.70833,0.78125,0.75,0.78125,0.79167,0.78125,0.83333,0.78125,0.875,0.78125,0.91667,0.78125,0.95833,0.78125,0.99609,0.78125,0.00391,0.8125,0.04167,0.8125,0.08333,0.8125,0.125,0.8125,0.16667,0.8125,0.20833,0.8125,0.25,0.8125,0.29167,0.8125,0.33333,0.8125,0.375,0.8125,0.41667,0.8125,0.45833,0.8125,0.5,0.8125,0.54167,0.8125,0.58333,0.8125,0.625,0.8125,0.66667,0.8125,0.70833,0.8125,0.75,0.8125,0.79167,0.8125,0.83333,0.8125,0.875,0.8125,0.91667,0.8125,0.95833,0.8125,0.99609,0.8125,0.00391,0.84375,0.04167,0.84375,0.08333,0.84375,0.125,0.84375,0.16667,0.84375,0.20833,0.84375,0.25,0.84375,0.29167,0.84375,0.33333,0.84375,0.375,0.84375,0.41667,0.84375,0.45833,0.84375,0.5,0.84375,0.54167,0.84375,0.58333,0.84375,0.625,0.84375,0.66667,0.84375,0.70833,0.84375,0.75,0.84375,0.79167,0.84375,0.83333,0.84375,0.875,0.84375,0.91667,0.84375,0.95833,0.84375,0.99609,0.84375};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.00391,0.875,0.04167,0.875,0.08333,0.875,0.125,0.875,0.16667,0.875,0.20833,0.875,0.25,0.875,0.29167,0.875,0.33333,0.875,0.375,0.875,0.41667,0.875,0.45833,0.875,0.5,0.875,0.54167,0.875,0.58333,0.875,0.625,0.875,0.66667,0.875,0.70833,0.875,0.75,0.875,0.79167,0.875,0.83333,0.875,0.875,0.875,0.91667,0.875,0.95833,0.875,0.99609,0.875,0.00391,0.90625,0.04167,0.90625,0.08333,0.90625,0.125,0.90625,0.16667,0.90625,0.20833,0.90625,0.25,0.90625,0.29167,0.90625,0.33333,0.90625,0.375,0.90625,0.41667,0.90625,0.45833,0.90625,0.5,0.90625,0.54167,0.90625,0.58333,0.90625,0.625,0.90625,0.66667,0.90625,0.70833,0.90625,0.75,0.90625,0.79167,0.90625,0.83333,0.90625,0.875,0.90625,0.91667,0.90625,0.95833,0.90625,0.99609,0.90625,0.00391,0.9375,0.04167,0.9375,0.08333,0.9375,0.125,0.9375,0.16667,0.9375,0.20833,0.9375,0.25,0.9375,0.29167,0.9375,0.33333,0.9375,0.375,0.9375,0.41667,0.9375,0.45833,0.9375,0.5,0.9375,0.54167,0.9375,0.58333,0.9375,0.625,0.9375,0.66667,0.9375,0.70833,0.9375,0.75,0.9375,0.79167,0.9375,0.83333,0.9375,0.875,0.9375,0.91667,0.9375,0.95833,0.9375,0.99609,0.9375,0.00391,0.96875,0.04167,0.96875,0.08333,0.96875,0.125,0.96875,0.16667,0.96875,0.20833,0.96875,0.25,0.96875,0.29167,0.96875,0.33333,0.96875,0.375,0.96875,0.41667,0.96875,0.45833,0.96875,0.5,0.96875,0.54167,0.96875,0.58333,0.96875,0.625,0.96875,0.66667,0.96875,0.70833,0.96875,0.75,0.96875,0.79167,0.96875,0.83333,0.96875,0.875,0.96875,0.91667,0.96875,0.95833,0.96875,0.99609,0.96875};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.00391,0.99609,0.04167,0.99609,0.08333,0.99609,0.125,0.99609,0.16667,0.99609,0.20833,0.99609,0.25,0.99609,0.29167,0.99609,0.33333,0.99609,0.375,0.99609,0.41667,0.99609,0.45833,0.99609,0.5,0.99609,0.54167,0.99609,0.58333,0.99609,0.625,0.99609,0.66667,0.99609,0.70833,0.99609,0.75,0.99609,0.79167,0.99609,0.83333,0.99609,0.875,0.99609,0.91667,0.99609,0.95833,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 825 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 1650 total numbers made up of 825 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD028 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD028().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD028\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD028 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD028_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD028_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD028_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD028_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
