package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD027Index.html" target="_blank">SquawLOD027</a>,  source <a href="../../../Geospatial/SquawLOD027.java">SquawLOD027.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD027.x3d">SquawLOD027.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD027.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD027.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD027
{
	/** Default constructor to create this object. */
	public SquawLOD027 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD027.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD027.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD027.x3d"))
    .addChild(new GeoLOD().setCenter(4342525.411173,743027.217291,2137.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw013.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw013.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4341718.744506,742430.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(51).setXSpacing(24.360000).setZDimension(67).setZSpacing(24.444444).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {1947.5,1959.5009,1971.993,1985.5465,2001.9147,2018.7775,2034.1254,2048.4373,2064.895,2080.3828,2095.6978,2110.6133,2127.6433,2146.2664,2159.7454,2171.349,2189.2556,2201.8855,2210.5823,2219.3882,2229.026,2235.3428,2242.579,2249.8154,2256.473,2262.288,2267.1213,2272.9165,2278.997,2287.7153,2295.2688,2301.5486,2306.7712,2310.4456,2313.8577,2317.0176,2318.0825,2319.1475,2322.4033,2326.4014,2328.0,2328.4927,2328.8425,2329.0,2328.8706,2328.6458,2328.0,2328.0,2326.6042,2325.1182,2324.706,1946.2222,1958.5009,1972.2161,1985.6221,2002.297,2018.059,2034.9646,2049.5964,2066.1729,2083.168,2099.4639,2114.265,2130.0786,2147.2734,2160.2886,2171.349,2187.539,2198.4417,2206.8396,2214.3472,2221.8884,2229.4866,2236.4307,2243.667,2250.6255,2256.1462,2261.973,2268.25,2275.1265,2283.0024,2291.599,2298.8354,2304.5635,2308.09,2311.4224,2314.8345,2316.868,2317.9824,2320.6003,2325.2434,2327.895,2329.0,2329.0,2329.0,2329.0,2329.0,2328.0,2327.6646,2325.8696};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {2324.1182,2323.2124,1944.4778,1958.5732,1973.0737,1987.7551,2005.4636,2019.1443,2035.0807,2051.7324,2070.3245,2086.7888,2102.7683,2118.0554,2133.523,2148.2734,2160.8308,2170.721,2182.6833,2191.1084,2198.7075,2205.7998,2211.9216,2217.6943,2225.6853,2232.8892,2240.1255,2247.0842,2254.3206,2261.5054,2269.5154,2276.7517,2286.0398,2294.8179,2301.2727,2305.8538,2308.9778,2312.39,2314.802,2317.214,2318.6262,2321.799,2324.7283,2326.5557,2328.2756,2328.2778,2328.2778,2327.2778,2326.3762,2325.2778,2323.9385,2322.396,2321.0654,1944.95,1958.8846,1977.0007,1994.0493,2011.5192,2024.2433,2037.6254,2055.3435,2074.2134,2091.444,2105.213,2122.2734,2135.334,2148.2734,2160.2065,2167.4429,2175.2988,2179.7725,2185.2124,2189.9563,2195.6362,2201.8037,2208.0972,2217.5005,2226.219,2234.9714,2242.376,2251.3967,2261.0762,2269.3584,2277.7063,2288.6519,2296.4182,2303.2905,2306.6501,2309.6853,2312.191,2313.8228,2316.7249,2318.4673,2319.8394,2321.6667,2322.6663,2323.0076,2323.5,2323.3054,2322.6667};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {2322.6187,2321.3635,2319.8333,2319.0,1946.6945,1961.574,1982.609,2002.2286,2018.516,2031.5765,2044.6997,2060.8435,2079.1023,2094.994,2109.1519,2123.9392,2136.3914,2148.1545,2156.151,2161.8557,2166.229,2170.2495,2172.7031,2175.4626,2179.2366,2184.9592,2192.2085,2201.0005,2210.649,2219.3027,2230.1921,2239.8164,2248.7654,2259.1418,2270.3416,2279.874,2290.67,2298.2065,2304.0889,2306.501,2308.302,2309.714,2312.1262,2313.6316,2315.2722,2316.5242,2316.7778,2317.7778,2318.7083,2318.7778,2318.7778,2318.7778,2318.5952,2318.046,2317.8203,1949.3112,1966.213,1989.6947,2009.4551,2025.8125,2039.0502,2050.2366,2066.1768,2084.922,2098.494,2112.911,2125.15,2136.4783,2145.98,2150.7788,2153.7031,2155.7778,2156.7778,2157.8782,2160.2405,2165.4062,2171.7134,2181.028,2189.278,2196.6313,2206.6306,2216.3347,2229.558,2239.4724,2248.391,2259.9802,2271.0962,2282.157,2292.3857,2298.2334,2301.9456,2303.8625,2304.889,2306.8528,2307.6494,2308.8333,2309.8333,2310.8303,2311.8333,2312.8333};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {2313.8333,2313.889,2314.8364,2315.3325,2315.0005,2314.8333,1952.7,1972.0017,1994.1106,2013.4331,2029.351,2041.3689,2055.6252,2072.4373,2088.9026,2102.684,2115.1416,2125.7747,2133.9004,2139.5684,2143.1865,2144.9348,2145.5,2146.5,2147.053,2148.0183,2151.3608,2159.6987,2169.5186,2179.0837,2186.4473,2192.973,2204.0156,2215.5762,2229.1367,2239.5579,2249.2063,2260.3186,2271.9412,2283.1519,2291.7502,2295.612,2298.0244,2299.4365,2300.5,2301.5,2301.5,2301.7925,2302.997,2304.9092,2306.4106,2308.0,2308.5,2309.0,2308.7651,2308.5,2308.353,1955.8445,1976.7458,1997.0157,2015.3953,2030.3092,2043.4363,2059.0698,2076.3818,2092.7847,2105.93,2116.2263,2123.7197,2128.4336,2130.2249,2130.2778,2130.3333,2131.3333,2132.0273,2134.4336,2136.7961,2141.083,2148.5923,2158.2827,2166.7874,2175.07,2183.1953,2190.8572,2202.3643,2214.4397,2229.099,2239.4802,2250.0771,2260.7742,2272.6619,2282.3225,2289.2788,2292.111,2293.051,2293.1667,2293.1667,2292.2222,2291.67,2291.2776};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {2294.096,2297.8745,2301.4,2302.7764,2303.1667,2302.1667,2301.1733,2300.2222,1958.7167,1979.2905,1998.288,2016.3953,2030.477,2044.2405,2059.675,2078.233,2096.8857,2106.5884,2114.0388,2117.9685,2118.8093,2117.889,2117.2778,2117.616,2118.7764,2119.4443,2122.5505,2126.092,2130.3052,2137.4258,2147.0742,2156.1116,2163.6023,2170.4175,2179.668,2190.1318,2200.965,2212.8943,2227.9446,2241.5544,2251.4126,2261.884,2272.6726,2281.4465,2284.7466,2286.1975,2285.6978,2284.5376,2283.2717,2281.6982,2282.4414,2285.0127,2289.1565,2292.0667,2294.4788,2294.387,2292.6506,2291.4443,2290.265,1960.7333,1982.6348,1999.9924,2017.1656,2030.6826,2043.492,2060.9856,2079.0103,2096.895,2103.5908,2108.4758,2107.4275,2104.3665,2102.8333,2103.2148,2104.645,2106.9485,2109.3608,2112.8613,2116.617,2121.5159,2127.6943,2136.0564,2146.167,2154.4033,2161.473,2168.7766,2178.0942,2188.9702,2199.6917,2211.7717,2227.3064,2241.9836,2252.8184,2263.3003,2272.2634,2278.628,2280.3333,2278.2095,2275.906,2275.1895};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {2274.9873,2275.3333,2277.8105,2281.2915,2283.7334,2285.6077,2284.657,2283.197,2281.785,2280.3728,1963.8778,1984.0514,2001.2092,2017.6521,2031.3461,2041.7168,2054.8467,2075.0178,2086.0256,2090.0737,2089.6377,2087.7778,2088.2314,2090.3916,2093.4736,2096.0364,2099.4485,2101.8608,2105.3022,2108.3372,2113.0276,2118.1943,2124.9756,2133.6301,2144.9705,2152.8618,2160.376,2168.561,2177.634,2188.2703,2199.0952,2212.5269,2229.742,2242.8943,2255.1614,2263.862,2269.691,2270.889,2269.0698,2268.1667,2267.4443,2266.7222,2270.4385,2274.1313,2276.3154,2277.3796,2276.9873,2274.8728,2273.4192,2271.007,2269.1667,1966.3223,1985.4513,2002.796,2019.1721,2030.4396,2039.2723,2047.3326,2059.395,2066.9077,2069.509,2069.9443,2070.3274,2072.554,2080.2227,2084.7488,2090.2012,2094.5598,2096.2495,2099.016,2102.7258,2106.486,2110.8608,2117.065,2125.454,2132.8916,2144.7908,2153.0427,2161.683,2169.6797,2178.4739,2190.1284,2202.874,2220.8054,2238.2031,2250.056,2258.78,2262.3577,2263.5557,2262.5557};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {2262.5557,2262.6804,2264.585,2267.9949,2271.687,2272.5059,2271.5352,2268.9102,2266.5396,2266.2778,2265.3105,2264.4739,1969.1666,1986.7013,2003.6674,2020.4708,2028.8429,2035.164,2039.9554,2045.3837,2049.1392,2052.8604,2057.579,2063.701,2071.0671,2077.296,2082.4578,2086.5947,2091.9956,2093.694,2095.851,2098.2712,2102.539,2106.233,2112.6853,2121.5005,2129.833,2139.9565,2149.8489,2160.125,2167.8716,2175.7517,2184.9763,2198.985,2214.5273,2232.2275,2245.417,2254.6309,2257.191,2257.6667,2257.318,2256.6667,2259.3455,2263.5156,2266.828,2269.2424,2270.8213,2268.639,2266.8923,2264.9905,2264.0,2263.853,2262.8333,1972.0945,1988.2511,2004.3868,2018.9353,2026.4674,2030.4287,2033.5497,2035.9623,2040.7386,2048.1914,2056.237,2064.8855,2073.5115,2079.7024,2084.2468,2086.481,2089.843,2092.694,2094.0413,2095.7056,2099.2498,2104.074,2110.114,2119.8337,2130.3154,2139.964,2148.7693,2158.7627,2166.071,2173.3074,2181.0042,2193.7686,2206.8865,2225.1824,2238.9392,2246.391,2250.0798};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {2252.103,2251.9907,2254.5212,2258.24,2262.1697,2264.3877,2266.798,2269.712,2267.9092,2266.9656,2265.611,2264.324,2263.1182,2261.2747,1974.9556,1990.651,2004.0737,2015.7135,2023.5619,2026.6931,2029.2571,2032.5492,2038.0098,2048.1914,2057.237,2068.1624,2076.956,2083.1973,2086.0254,2087.8699,2089.282,2091.6384,2093.0,2094.4895,2095.996,2101.972,2108.9766,2119.6116,2130.2922,2138.973,2147.557,2156.38,2163.6138,2170.8628,2177.9949,2187.6155,2199.3853,2214.9465,2230.2615,2239.0022,2242.3867,2245.8174,2249.661,2254.5212,2258.1729,2261.585,2264.0525,2267.0784,2269.8767,2271.111,2271.0557,2269.0535,2267.085,2264.2854,2261.706,1976.9,1991.5009,2003.0492,2012.7732,2017.8413,2022.1229,2025.3215,2031.9323,2038.94,2048.5884,2058.237,2070.496,2078.717,2085.0457,2086.4578,2088.0,2089.282,2090.694,2092.053,2093.5183,2095.4304,2099.699,2108.264,2118.167,2128.8945,2137.473,2145.7095,2152.9458,2160.0684,2167.238,2174.1548,2181.623,2193.755,2204.4397,2219.3503};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {2231.3364,2237.3108,2243.3093,2248.3713,2253.1409,2257.3455,2262.1697,2266.494,2269.9092,2272.8213,2275.5,2275.1772,2273.9424,2270.2954,2266.1772,2262.412,1973.3112,1989.5564,2000.5924,2007.813,2012.4663,2015.664,2022.4912,2030.7505,2038.9542,2047.644,2059.0461,2070.8855,2079.534,2085.0457,2086.4878,2087.0557,2088.3218,2090.0,2092.0,2093.0,2094.9304,2099.37,2109.0186,2118.667,2127.371,2136.0286,2143.265,2149.7312,2155.5784,2162.0295,2169.2659,2176.5022,2188.076,2203.4238,2217.4836,2227.392,2235.1235,2241.8728,2248.0457,2252.7607,2257.3455,2263.1143,2266.994,2272.7627,2276.7102,2279.1223,2279.889,2278.8313,2274.5059,2267.299,2263.3728,1968.8389,1982.4344,1993.8826,2000.6821,2004.7644,2010.0106,2021.2542,2030.0687,2038.5569,2047.1996,2058.6572,2069.4966,2077.5115,2084.24,2084.433,2085.481,2086.893,2089.694,2092.1062,2093.9072,2095.9304,2101.759,2110.4075,2120.8242,2127.0903,2133.5876,2140.1853,2146.1697,2151.677,2156.5012,2163.397,2174.4263,2191.7085};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {2209.5054,2221.5781,2230.5032,2239.264,2245.6506,2251.8235,2256.5383,2260.1233,2264.5586,2268.7705,2276.3662,2280.599,2283.0112,2283.7778,2282.7554,2279.4495,2273.1323,2267.19,1964.25,1974.1676,1985.6305,1992.2859,1997.6201,2006.9518,2017.9705,2028.3627,2037.1067,2045.7551,2056.5386,2065.8677,2073.5393,2078.538,2079.791,2083.0364,2085.1667,2088.7625,2093.9395,2096.2651,2098.539,2104.8608,2113.6853,2122.3057,2126.7366,2131.982,2136.04,2141.9639,2147.432,2151.6123,2157.9814,2177.99,2196.7974,2212.321,2224.967,2236.1155,2244.3188,2249.706,2256.0732,2260.3547,2264.1501,2268.8364,2274.4915,2280.4849,2285.309,2287.9,2288.0212,2286.561,2282.8054,2278.903,2272.6672,1959.2222,1967.495,1974.5613,1981.919,1990.3285,2002.4655,2014.526,2025.3223,2034.6731,2043.033,2051.6814,2061.5461,2069.0671,2073.49,2075.902,2079.5198,2082.7634,2091.026,2097.4133,2100.0737,2103.4163,2108.4006,2117.5742,2123.1667,2126.576,2129.991,2132.0134,2135.2083,2139.8486,2145.5405,2158.8167};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {2180.7097,2199.1309,2212.7275,2226.2004,2237.8076,2246.1943,2252.827,2258.794,2263.799,2268.6233,2273.1477,2278.2695,2284.947,2290.605,2292.724,2292.3762,2290.1787,2286.3384,2282.5142,2276.396,1958.0167,1962.5782,1970.6724,1977.7522,1986.3461,2000.021,2011.0815,2021.847,2030.5105,2038.747,2046.9833,2055.7188,2062.8225,2067.6138,2070.4944,2077.4792,2084.7717,2095.4136,2100.1829,2103.9626,2106.6526,2113.7195,2121.3406,2124.1667,2126.6958,2127.2778,2127.8467,2129.782,2133.0103,2143.2976,2160.1492,2180.1733,2198.4983,2212.5198,2225.478,2237.9197,2246.9165,2253.8093,2260.7678,2267.0042,2272.79,2277.6143,2282.4385,2290.245,2295.2656,2297.4443,2296.0767,2293.6487,2289.6355,2284.2363,2278.0366,1958.8167,1962.5841,1973.7035,1979.94,1986.4567,1998.4518,2007.3097,2016.9583,2026.6217,2033.858,2041.0944,2048.294,2055.4004,2060.5989,2068.664,2078.3708,2088.1277,2097.2488,2103.3967,2107.938,2113.2913,2119.9614,2122.7957,2124.9724,2124.088,2122.8408,2121.4973,2125.125,2132.4927};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {2143.304,2160.1428,2177.3037,2195.964,2210.321,2223.2837,2236.3584,2246.573,2254.7456,2262.5608,2270.4485,2276.8516,2282.5032,2288.3242,2294.5608,2300.946,2302.9333,2300.5212,2296.1091,2292.0605,2285.3545,2277.8242,1960.3112,1966.1119,1976.0245,1981.4137,1987.2152,1995.5371,2003.4208,2011.7192,2021.1067,2028.7264,2035.2054,2041.966,2049.432,2057.1367,2067.2886,2078.4792,2089.1277,2098.6934,2105.9297,2113.5754,2120.056,2122.7444,2123.9045,2123.2222,2121.6462,2120.3943,2120.4785,2124.9438,2133.0483,2144.8083,2157.6985,2172.7427,2192.5198,2208.2637,2219.8892,2231.563,2245.9617,2254.7456,2265.0051,2273.6538,2281.5679,2287.392,2293.2131,2299.1995,2305.184,2306.5203,2303.5767,2299.4382,2293.0605,2285.4727,2277.8242,1961.7,1968.4507,1976.0245,1981.7732,1986.9908,1993.246,1999.5786,2007.6631,2015.8844,2023.1357,2030.3722,2036.8422,2046.88,2056.1824,2066.8308,2078.2935,2089.4097,2099.8318,2109.486,2119.1555,2123.986,2124.3425,2123.2034,2121.0464,2120.3655,2118.0635,2120.403};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {2126.5012,2134.965,2145.5579,2156.2551,2168.701,2188.8955,2205.289,2216.4448,2227.6113,2243.0347,2254.6821,2266.798,2277.1404,2285.6294,2292.2808,2298.1052,2303.9294,2309.7993,2313.6575,2308.139,2300.8271,2293.5354,2285.3054,2276.4749,1963.25,1970.8005,1976.7684,1981.7732,1986.0048,1991.746,1997.4019,2005.5051,2013.955,2021.6914,2028.9277,2035.8854,2045.8506,2056.228,2066.373,2076.849,2089.0508,2101.1233,2112.084,2122.7957,2128.3608,2127.986,2124.368,2120.8333,2118.4211,2118.0,2121.3062,2128.3533,2137.0232,2146.738,2155.1807,2165.8186,2183.5066,2200.0156,2213.1501,2224.505,2238.6702,2254.0867,2268.417,2281.0425,2290.5183,2296.9622,2302.994,2308.5227,2315.053,2317.4165,2308.9182,2300.7983,2292.356,2282.9727,2274.1772,1966.9889,1974.0948,1977.4852,1981.8489,1985.3365,1990.2599,1997.3215,2004.7505,2013.0105,2020.622,2028.4277,2035.8854,2045.5339,2056.1824,2065.8308,2075.3564,2087.6917,2101.1814,2114.4753,2126.536,2133.8154,2131.6123,2121.8052,2117.9443,2116.0789};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {2118.991,2123.1538,2131.38,2139.6392,2147.279,2154.1548,2163.374,2177.2905,2193.1824,2208.3281,2219.7778,2233.7812,2250.606,2268.4397,2283.7476,2294.29,2301.6436,2306.9385,2311.1719,2314.0913,2313.424,2306.1748,2297.935,2290.1768,2280.4167,2271.88,1969.4889,1975.489,1978.5123,1981.8782,1985.3365,1990.246,1996.4198,2003.7186,2011.5662,2019.9569,2027.4277,2035.7993,2045.145,2054.7935,2063.442,2073.622,2085.193,2099.1997,2114.142,2125.612,2129.4443,2124.8057,2118.6174,2114.287,2116.9326,2120.3765,2126.5981,2133.9065,2140.6821,2147.1387,2153.1348,2160.4658,2171.6013,2186.2842,2201.0337,2214.4377,2229.183,2246.7136,2267.535,2287.0093,2296.9072,2303.1436,2308.7725,2311.4797,2310.2917,2306.7556,2301.286,2293.0496,2285.3435,2276.9197,2269.8435,1970.9333,1976.1002,1979.3456,1982.6947,1985.3365,1989.6221,1995.6222,2002.7186,2010.1217,2018.2576,2026.2687,2034.0521,2043.595,2052.349,2061.5398,2070.646,2080.508,2095.1917,2109.7756,2118.2153,2121.655,2117.187,2110.9907};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {2111.6392,2117.9912,2122.8154,2130.0427,2135.6304,2140.6821,2146.279,2151.3127,2157.635,2167.5664,2179.821,2193.7004,2207.173,2223.607,2241.8777,2264.7605,2287.8857,2299.4956,2308.1855,2313.663,2312.9849,2307.673,2302.6333,2295.456,2288.9458,2280.3662,2274.403,2268.285,1972.9556,1976.4781,1979.79,1982.9244,1985.0587,1988.4275,1994.4823,2001.5596,2008.6772,2015.9136,2024.1499,2032.8854,2041.6227,2049.8918,2058.426,2066.96,2075.776,2087.7244,2100.2075,2106.2258,2107.5193,2105.6187,2106.9644,2113.5466,2120.8535,2125.982,2132.084,2136.093,2140.3916,2144.8235,2149.5103,2154.5007,2163.191,2174.6763,2187.4282,2201.364,2217.4932,2238.2595,2260.678,2286.3608,2303.0845,2317.4475,2317.2808,2313.659,2305.0303,2298.7444,2291.6064,2285.2876,2278.313,2272.0767,2265.8403,1976.4222,1978.8948,1982.2345,1983.0,1984.3365,1986.9567,1992.7601,1999.9965,2006.2328,2012.8662,2021.5677,2030.3795,2039.1782,2047.4146,2054.778,2062.165,2070.4797,2078.9155,2086.263,2090.2222,2093.0962};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {2100.0276,2108.1958,2114.5002,2121.1577,2126.2573,2132.8062,2135.8665,2138.5051,2141.195,2144.922,2149.2244,2158.9346,2170.4111,2184.9004,2200.4487,2213.6702,2235.4453,2256.944,2279.6125,2299.6401,2314.5952,2318.003,2311.2146,2302.814,2295.5776,2288.5208,2282.121,2275.8687,2269.6323,2263.3142,1978.9833,1983.2836,1985.2521,1986.1666,1986.1666,1986.0419,1991.6162,1997.9791,2003.7883,2010.0247,2018.2292,2027.3677,2035.7338,2043.7958,2050.0398,2057.1094,2063.2988,2069.7214,2074.6946,2080.876,2089.71,2100.37,2109.264,2113.4724,2118.8945,2123.6487,2129.1396,2132.1487,2134.7273,2136.1995,2139.6204,2143.9275,2155.255,2171.7556,2189.9338,2202.8943,2215.963,2236.605,2254.7883,2275.806,2294.8699,2309.7607,2318.9966,2310.28,2300.2327,2292.3276,2285.7302,2278.7183,2273.336,2267.1682,2259.9514,1982.4388,1986.7113,1988.1234,1988.6111,1989.2222,1989.0686,1992.0577,1996.9618,2000.742,2007.3375,2014.1313,2022.6632,2032.3116,2038.9146,2044.6932,2049.9062,2056.3416,2060.5547,2068.7075};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {2077.9805,2089.0835,2098.759,2108.6528,2112.4539,2114.3567,2117.1577,2119.9587,2122.5557,2124.1719,2129.808,2136.2063,2144.2107,2157.4014,2176.0618,2193.5115,2206.8953,2221.5718,2239.1023,2255.4397,2274.2346,2293.2527,2304.9297,2311.721,2303.1692,2295.3835,2288.0776,2281.4868,2275.605,2269.6558,2263.7434,2257.0757,1985.4556,1988.1558,1990.0284,1991.0555,1992.0555,1992.8042,1994.2163,1997.0319,2000.0255,2005.7942,2010.5629,2018.6208,2026.4783,2034.0356,2040.343,2046.7396,2053.5796,2059.4268,2067.4187,2076.5627,2086.666,2094.9165,2103.81,2107.787,2108.81,2108.8884,2109.8333,2113.3901,2120.4673,2128.6135,2136.259,2145.3484,2159.255,2178.3591,2195.2393,2209.5608,2223.1943,2241.5469,2256.1274,2271.2268,2288.661,2297.0261,2298.7224,2294.5732,2288.3696,2282.1462,2276.598,2270.7737,2265.9756,2260.2925,2254.0625,1987.05,1990.05,1992.0123,1993.5,1994.0,1994.8743,1996.5803,1998.8594,2002.47,2006.2942,2010.2139,2019.2748,2026.9004,2033.0912,2040.1019,2046.7396,2054.3457};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {2060.8882,2067.7654,2075.055,2083.2913,2090.3564,2095.5093,2099.0835,2100.7896,2103.482,2106.403,2111.3533,2120.9094,2130.5579,2138.1548,2145.8547,2160.1309,2180.0156,2196.2004,2209.117,2223.1943,2241.555,2254.417,2267.564,2280.8638,2288.3774,2289.0,2285.682,2280.8574,2276.0332,2270.8862,2266.9136,2262.7954,2257.7954,2251.6182,1988.3611,1992.1393,1995.4282,1996.8175,1996.8889,1996.9445,1998.1052,2002.0347,2004.9294,2007.3636,2010.7986,2022.7866,2031.4431,2036.9801,2041.8853,2047.6841,2055.1277,2062.371,2068.2124,2074.0654,2080.8467,2085.7961,2089.9077,2093.2778,2096.1812,2101.973,2107.3477,2113.3242,2120.9094,2130.8984,2138.1548,2145.8547,2158.3105,2180.0156,2194.556,2207.5671,2221.7256,2238.614,2250.798,2262.9143,2273.6946,2279.3594,2280.1667,2277.7903,2274.4688,2270.6443,2266.4297,2263.998,2261.0605,2256.292,2250.8406,1989.4,1994.5892,1998.29,2000.7021,2000.1666,2000.7489,2004.753,2009.1284,2011.1666,2011.9526,2015.6686,2025.2743,2034.2893,2040.8689,2045.6932};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {2050.8557,2057.2346,2063.2012,2068.2124,2073.3533,2078.472,2081.9536,2085.5637,2092.3335,2096.7717,2105.7417,2112.7407,2118.7253,2125.6213,2131.0586,2139.1233,2145.8547,2156.5032,2176.6377,2191.5393,2204.2405,2218.7568,2233.4766,2244.4404,2256.2476,2266.03,2271.1646,2272.4443,2270.5833,2268.401,2266.0796,2264.5713,2262.9553,2260.0605,2256.164,2251.801,1990.0333,1996.2003,2001.3456,2004.5911,2006.9471,2010.2487,2014.8215,2018.5503,2022.1392,2023.5638,2025.3015,2029.2009,2037.5671,2044.8035,2050.9634,2056.4062,2062.064,2066.8882,2068.9573,2071.6047,2076.8027,2082.5183,2087.3018,2094.1667,2101.4646,2110.6396,2118.7095,2127.4402,2133.7273,2136.1394,2140.9365,2146.7776,2156.5032,2171.6848,2186.8337,2199.0251,2214.5664,2226.2456,2236.894,2245.836,2257.047,2262.9055,2264.6663,2264.432,2263.3333,2263.1667,2263.7046,2262.8237,2261.6667,2258.903,2255.9612,1990.5945,1997.2281,2002.6724,2008.1266,2012.3221,2018.0792,2023.4326,2028.416,2033.3589,2037.2305,2037.8334,2036.5487,2041.4559};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {2049.3816,2055.9287,2063.3127,2071.3188,2073.5557,2073.5557,2073.5557,2079.069,2084.963,2090.9966,2097.2227,2106.1753,2115.2417,2124.28,2134.0012,2141.1238,2144.6504,2148.177,2152.2446,2157.183,2168.082,2181.5837,2192.7275,2205.656,2217.3108,2228.198,2236.7202,2244.0244,2252.9727,2257.1628,2258.2803,2258.4443,2260.0205,2263.9016,2265.2937,2265.5557,2264.5884,2262.0493,1991.6056,1998.9504,2005.2592,2011.4955,2017.454,2024.6904,2031.6489,2037.3124,2042.1367,2045.8889,2046.8889,2046.1666,2047.5354,2054.2705,2061.1482,2070.8877,2078.3745,2080.1099,2076.047,2077.9626,2082.3247,2087.7498,2094.1633,2101.991,2110.3418,2117.6953,2127.7378,2138.6233,2148.0632,2154.8074,2159.7144,2161.405,2160.3547,2167.1702,2172.8281,2183.6719,2195.7327,2206.1804,2212.905,2220.4377,2227.7405,2235.1394,2242.2131,2248.3713,2253.5254,2257.913,2263.5469,2267.8213,2271.2534,2272.007,2269.0688,1994.0167,2001.217,2007.1913,2013.94,2022.1763,2028.5792,2036.3483,2041.8853,2048.1367,2051.63,2054.2773};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {2055.7214,2058.3,2061.7654,2068.9634,2077.8342,2084.2349,2083.8843,2078.1062,2080.6047,2083.9304,2090.1943,2097.4307,2105.667,2112.807,2119.1472,2129.6125,2140.0762,2151.1746,2164.4297,2172.0,2169.703,2164.3933,2166.0732,2167.7834,2173.7634,2183.1765,2192.6426,2199.7551,2204.688,2210.3455,2216.2957,2225.3208,2238.6138,2249.1182,2257.7,2265.103,2270.2722,2276.0176,2280.0486,2274.285,1996.2833,2002.8505,2009.148,2015.7732,2023.7516,2031.1482,2037.9951,2043.9796,2049.97,2054.648,2059.724,2062.5789,2066.243,2070.9246,2077.2065,2083.3796,2084.0,2082.8818,2079.676,2082.1294,2085.472,2092.0276,2099.725,2107.5002,2113.994,2120.973,2129.6125,2139.578,2150.2983,2159.3337,2167.5872,2167.5227,2164.5613,2162.6768,2164.4778,2166.89,2170.808,2177.7537,2183.555,2190.0972,2195.7844,2205.4485,2218.3738,2234.8435,2247.6042,2257.8428,2266.5818,2271.1152,2276.122,2280.2708,2275.7292,1998.1,2004.2003,2010.0245,2016.7732,2024.0096,2031.246,2038.2749,2044.1221,2049.9692};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {2057.2468,2062.674,2067.4983,2071.689,2075.1924,2082.9456,2084.0,2083.9844,2082.2505,2080.8997,2082.5183,2085.8608,2093.0833,2100.3196,2108.5466,2114.7366,2120.973,2128.59,2137.2053,2145.8413,2152.7717,2156.9893,2158.8591,2159.716,2158.889,2159.55,2160.8333,2162.8528,2167.6506,2172.4556,2178.0598,2185.0981,2202.0386,2217.9236,2233.4219,2247.1062,2257.7,2265.9365,2271.112,2275.4402,2278.8262,2275.1182,1998.1,2003.7505,2010.0245,2016.311,2023.5096,2030.246,2036.5626,2043.9323,2050.4475,2058.6914,2065.1184,2070.9426,2074.1335,2077.614,2081.1865,2082.9348,2082.218,2081.0,2082.0,2083.0,2085.8608,2094.0276,2101.264,2109.3335,2114.7366,2120.973,2127.7095,2134.8533,2142.0684,2147.4592,2151.0515,2152.5,2152.5,2152.5,2152.5,2153.5562,2155.5244,2158.4045,2164.3713,2171.5425,2181.882,2200.5942,2214.9834,2231.5684,2247.1062,2257.7,2265.759,2270.5864,2274.2046,2276.3818,2274.412,1996.4944,2001.4061,2007.1642,2011.0869,2020.4017,2029.9946,2038.3801};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {2045.6631,2052.8994,2060.1357,2068.192,2074.3315,2079.1206,2081.7017,2078.0,2078.877,2080.0557,2080.711,2082.1003,2083.4895,2086.7913,2093.704,2100.306,2108.3892,2114.1577,2119.982,2126.2317,2132.5012,2137.566,2142.7861,2146.111,2146.1667,2145.284,2145.1506,2145.111,2146.2295,2150.1597,2154.044,2160.1206,2169.0981,2180.265,2197.5974,2212.0378,2229.1567,2247.1062,2257.4797,2264.9365,2270.0576,2273.9395,2277.7146,2277.3564,1991.6222,1997.4226,2002.2563,2010.2084,2019.9407,2031.2858,2040.4823,2048.1074,2055.727,2063.0574,2070.7424,2077.442,2083.552,2083.9722,2081.142,2079.9204,2081.1096,2082.27,2083.389,2084.5903,2088.2498,2093.3425,2098.875,2107.0095,2112.994,2118.9785,2124.4172,2129.2417,2133.5886,2136.8616,2138.8333,2139.0137,2140.1738,2141.3342,2141.8833,2143.7668,2147.6597,2151.484,2157.2678,2166.1716,2177.2588,2192.3164,2208.204,2226.1113,2245.7173,2256.6094,2262.9365,2268.0928,2272.2266,2277.7178,2279.801,1987.5167,1995.2003,2001.9679,2012.531,2022.1794};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {2032.9526,2042.3157,2050.552,2058.786,2065.6938,2072.261,2081.3677,2084.3054,2084.0,2083.466,2080.855,2082.2349,2083.5784,2085.773,2089.1047,2091.7522,2094.233,2099.0972,2106.3335,2112.1577,2117.982,2122.4702,2125.982,2129.432,2130.973,2132.4915,2132.8865,2135.939,2138.4546,2140.1167,2142.2788,2144.691,2147.259,2153.0303,2160.376,2171.6807,2187.4275,2204.977,2224.5684,2244.094,2255.5056,2261.3984,2266.2244,2270.106,2275.8318,2279.3337,1988.1,1995.2281,2003.6969,2014.6431,2023.867,2033.9946,2043.527,2052.2915,2060.955,2067.359,2074.8772,2084.2214,2084.3665,2084.0,2083.5422,2081.8699,2083.0784,2085.8586,2090.7678,2094.7258,2096.5361,2097.8982,2102.8196,2107.6113,2111.5789,2116.7068,2120.1252,2122.5374,2124.8865,2126.184,2128.4587,2130.6497,2134.5083,2137.0103,2139.6167,2141.112,2143.0,2144.9365,2152.1423,2161.2922,2173.669,2188.372,2204.979,2224.6821,2242.5205,2254.4224,2259.1116,2263.7798,2266.192,2269.9631,2270.8728,1989.0167,1997.0227,2005.7714};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {2015.3652,2025.8253,2034.9946,2043.6431,2052.2915,2060.955,2068.1914,2077.7683,2085.0,2084.3665,2083.967,2081.6929,2082.8699,2084.4072,2090.5266,2096.5034,2098.2405,2099.6719,2102.1294,2106.4087,2109.889,2111.5789,2115.2664,2118.112,2120.093,2120.7197,2121.5557,2123.6587,2129.205,2133.7517,2136.2878,2138.4834,2141.112,2143.5244,2147.335,2153.8647,2163.7368,2175.9885,2189.9316,2204.982,2225.4043,2241.9275,2251.9778,2257.5686,2261.3354,2263.7476,2264.5557,2264.2454,1990.1,1998.4672,2006.6223,2016.6346,2027.0096,2035.246,2043.6431,2052.6475,2060.776,2068.5222,2076.261,2082.5,2081.2332,2080.0076,2082.6243,2084.3115,2089.1792,2095.3508,2098.1062,2099.5986,2101.0972,2104.8518,2108.5503,2111.0278,2112.5789,2114.826,2116.2366,2117.6487,2118.0,2119.473,2121.0945,2126.1472,2131.585,2135.2878,2138.4001,2141.3723,2144.6116,2150.0396,2155.154,2164.97,2177.8926,2190.9243,2204.9824,2226.273,2241.9275,2250.3389,2256.1243,2258.8909,2260.6667,2259.785,2257.4905,1990.5278};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {1999.3617,2007.5369,2017.6221,2027.0096,2035.246,2043.5448,2051.7188,2059.3381,2066.7346,2074.0073,2075.7778,2076.941,2080.7024,2084.7373,2088.3508,2093.8958,2097.424,2099.1062,2100.3167,2102.9033,2106.087,2108.7546,2111.065,2112.225,2113.389,2115.1567,2116.8152,2117.2273,2118.2488,2120.02,2122.4966,2129.6758,2133.8528,2139.1,2143.6797,2146.98,2153.095,2157.5986,2167.5605,2180.4749,2193.374,2207.204,2227.273,2242.1062,2249.1685,2254.291,2257.0225,2257.1018,2255.85,2253.19,1990.8,2000.3005,2008.5369,2017.749,2027.0096,2034.246,2041.6342,2049.663,2056.8447,2063.058,2067.632,2071.0793,2074.613,2080.1343,2085.4275,2089.684,2095.524,2097.694,2099.1003,2100.5183,2103.809,2105.3425,2107.9863,2109.1575,2109.9443,2110.9995,2115.4255,2117.8708,2119.0557,2119.0557,2120.1626,2124.0127,2128.8071,2133.9033,2140.4556,2147.2861,2153.684,2160.0835,2167.9941,2174.5176,2184.2493,2197.6436,2211.0378,2228.3286,2243.1716,2249.4539,2252.5898,2253.9443,2253.4749,2252.007};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {2248.301,1990.65,2000.8506,2008.5369,2018.6599,2026.8413,2033.246,2039.9823,2046.9323,2051.4775,2056.2942,2059.8093,2066.2747,2072.7668,2078.614,2082.9578,2087.6746,2093.4229,2096.347,2097.5,2100.0366,2103.3955,2104.8425,2106.3774,2107.5,2108.0,2110.982,2117.3062,2119.5,2121.2273,2123.3198,2125.0515,2127.6956,2130.3757,2135.5078,2142.7502,2151.4487,2160.8594,2171.7139,2180.5457,2188.1624,2195.5183,2203.3396,2214.4834,2230.3638,2244.3743,2248.85,2250.9683,2252.5,2251.0303,2247.7363,2244.559,1990.5,2001.3005,2009.0492,2017.6976,2025.7286,2031.3015,2036.4326,2041.8535,2046.0264,2050.644,2057.6184,2064.8855,2072.2466,2078.091,2083.402,2089.5056,2094.2263,2095.9275,2097.0505,2100.0078,2103.9407,2104.9634,2105.9863,2107.1575,2109.1255,2113.926,2118.784,2122.7495,2126.1162,2129.473,2131.8362,2132.8591,2133.7717,2140.4253,2146.989,2156.5496,2170.3992,2181.5234,2191.501,2199.1152,2205.1233,2209.588,2217.877,2231.4546,2244.285,2248.2888,2249.6653,2250.9456};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {2248.586,2245.292,2241.7617,1989.5,2000.9116,2008.85,2016.3844,2023.6207,2029.1084,2033.3215,2039.9414,2046.353,2052.212,2060.2478,2068.139,2074.6558,2080.48,2086.4822,2094.3872,2097.9502,2099.6587,2101.884,2104.1086,2106.3193,2106.389,2107.2935,2108.6206,2113.2893,2118.7598,2122.9487,2127.4082,2131.144,2134.4172,2136.409,2137.7778,2140.1887,2144.2527,2152.3057,2163.451,2177.3992,2187.9512,2197.57,2206.5247,2212.1904,2217.3364,2221.7717,2231.8865,2241.896,2245.9353,2248.7834,2248.9775,2246.5303,2243.7751,2240.0232,1987.9667,1998.6339,2005.789,2012.3362,2020.7291,2028.246,2035.2888,2042.552,2049.6243,2056.858,2064.0945,2072.3308,2078.9336,2082.9246,2089.664,2096.718,2100.1152,2103.1057,2105.773,2107.753,2108.6667,2107.9429,2108.629,2112.306,2117.8245,2122.8154,2126.5723,2131.328,2135.0608,2137.473,2139.885,2142.1304,2143.7092,2147.5784,2155.8835,2167.5063,2181.3755,2191.579,2201.2275,2209.1553,2216.3516,2221.0723,2225.8242,2231.2273,2238.7673,2244.6333};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {2247.7046,2247.9424,2245.5303,2243.1182,2238.412,1986.6555,1995.5505,2004.0492,2012.051,2021.6239,2030.3422,2038.0378,2045.9965,2054.4956,2061.7468,2068.174,2076.441,2084.8225,2088.6467,2093.193,2098.1113,2102.041,2104.972,2108.384,2110.652,2111.2778,2111.2778,2112.3103,2116.8428,2121.2747,2125.2598,2129.5151,2133.9082,2137.7324,2141.657,2143.6216,2146.6318,2150.585,2154.319,2158.739,2168.5608,2182.2778,2192.7456,2202.7427,2210.5212,2218.2207,2221.585,2225.717,2229.7046,2236.186,2243.4019,2246.3677,2246.9424,2244.9133,2241.2363,2236.216,1992.9667,2000.1171,2006.4758,2015.4199,2024.7905,2034.4391,2041.9268,2049.8547,2059.3845,2065.9136,2073.4565,2082.3298,2088.8875,2093.5356,2097.2327,2101.8123,2105.5227,2107.4163,2110.1062,2112.2405,2113.6719,2114.0647,2116.2314,2119.0557,2122.997,2126.7068,2131.5286,2136.3528,2141.1138,2145.0012,2148.496,2152.3718,2157.196,2161.9404,2165.567,2171.6465,2182.0972,2191.0693,2201.9236,2210.282,2218.2207,2221.585,2224.997,2228.687};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {2233.7415,2240.913,2245.3894,2246.0,2244.1912,2239.6323,2234.69,2000.6833,2007.5504,2012.5245,2020.0436,2028.6234,2037.4126,2045.6758,2053.9807,2063.1091,2070.5247,2078.4353,2086.8677,2094.2336,2100.5989,2106.4155,2109.3699,2110.7349,2111.6157,2113.4395,2114.7651,2115.1667,2116.0571,2117.7957,2120.1946,2124.1577,2128.982,2132.973,2138.6123,2143.7502,2147.746,2151.2698,2156.094,2161.815,2167.1973,2172.7334,2177.7244,2183.073,2191.153,2200.091,2210.1152,2216.5183,2221.0723,2224.994,2228.3105,2231.5056,2238.4944,2243.4788,2245.9424,2243.3635,2237.9226,2232.2454,2005.3223,2012.4615,2018.2468,2024.9492,2032.3627,2040.7593,2048.8652,2058.1636,2066.5603,2074.8025,2082.0388,2092.243,2100.7336,2107.9702,2113.7488,2116.7827,2118.5542,2118.8333,2118.611,2117.9055,2117.611,2117.611,2118.4612,2120.8428,2125.1577,2129.5967,2134.2095,2140.5586,2146.2273,2149.4993,2153.6829,2158.2107,2164.3628,2171.363,2178.3225,2185.17,2192.2212,2196.1587,2201.1904,2206.8171,2216.4512,2220.585};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {2223.997,2227.4092,2230.1406,2235.3872,2240.931,2244.3313,2240.6558,2234.1323,2229.3696,2009.8556,2016.4061,2023.1086,2028.833,2035.4573,2044.3431,2052.745,2061.3708,2069.9963,2078.3025,2087.393,2098.7874,2107.0466,2115.306,2122.082,2126.0847,2128.544,2127.5837,2124.9485,2121.564,2120.0557,2119.0366,2119.7683,2122.4446,2127.8157,2131.0466,2135.298,2142.456,2147.24,2150.675,2154.1558,2159.417,2167.5657,2175.9353,2183.2112,2191.4478,2197.1042,2200.984,2203.4597,2207.393,2216.5183,2220.585,2223.997,2227.4092,2229.0,2232.3982,2237.144,2238.7756,2234.9495,2230.1743,2226.3564,2012.6,2019.8005,2026.5245,2032.311,2040.3461,2048.8716,2056.4822,2064.2188,2072.4475,2082.5884,2093.0461,2102.8855,2113.6672,2122.614,2129.1443,2133.8047,2135.8591,2134.5,2130.0752,2123.7227,2122.035,2121.5,2121.7546,2126.3335,2131.4473,2134.991,2139.3062,2144.1304,2148.341,2151.9592,2155.0774,2161.3547,2170.5654,2180.0078,2187.9502,2195.7805,2201.0486,2205.8728,2208.3486,2212.5212};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {2217.3455,2220.585,2223.9956,2227.4092,2228.9106,2230.1167,2232.1455,2232.9712,2230.5303,2227.1772,2223.559,2014.0444,2022.245,2028.5084,2035.7177,2045.235,2052.1904,2059.4268,2066.663,2075.8704,2086.533,2096.9907,2107.9834,2119.4023,2126.0813,2131.4832,2133.111,2131.8447,2129.4727,2128.005,2124.3916,2123.9443,2123.9443,2125.6572,2130.2224,2134.1023,2137.927,2142.7507,2146.7598,2150.1719,2153.2434,2157.0447,2164.7437,2174.4478,2183.8083,2191.7058,2199.2253,2205.9375,2209.7651,2213.2373,2216.4236,2219.1172,2222.0818,2224.9443,2227.3865,2228.8213,2229.013,2229.701,2229.108,2227.586,2224.1738,2220.484,2012.6833,2022.4008,2030.7361,2039.1327,2048.3984,2054.7883,2061.871,2069.6804,2079.323,2089.5803,2099.824,2112.4949,2123.0447,2126.6213,2126.3757,2124.5747,2122.2722,2120.8333,2121.8745,2122.611,2122.6536,2123.9536,2128.1204,2131.6575,2135.5789,2138.9856,2143.8062,2147.8152,2150.8435,2154.8882,2159.964,2169.2437,2179.6216,2187.2527,2194.489,2203.1143,2208.4375,2212.6895};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {2216.7373,2219.1494,2220.7344,2223.9739,2225.997,2227.25,2227.9304,2228.4685,2227.9656,2226.187,2224.1414,2220.7292,2217.8857,2010.6666,2022.5507,2032.0492,2040.7606,2049.673,2056.2458,2063.4822,2070.7188,2080.9375,2091.4219,2103.554,2118.6807,2124.4111,2122.2498,2119.0422,2116.6301,2114.6196,2113.806,2114.6062,2116.0183,2118.4304,2121.5093,2125.676,2131.3335,2135.5789,2139.1562,2143.4702,2147.6614,2152.288,2156.1724,2163.873,2173.5989,2183.3367,2189.6973,2197.5168,2206.0576,2210.8818,2215.706,2219.182,2220.9602,2222.3167,2225.0,2225.9995,2227.0,2227.0,2226.361,2224.8757,2222.3237,2221.0884,2218.3044,2216.706,2008.2222,2020.251,2031.4192,2040.6976,2049.4888,2056.9946,2063.8315,2071.7188,2081.921,2092.818,2104.6306,2115.4932,2112.0664,2109.5781,2107.889,2106.889,2106.1667,2106.1667,2106.5505,2107.9626,2111.3052,2117.4072,2123.0542,2129.3335,2134.1577,2139.2573,2142.972,2147.497,2153.6694,2158.3738,2168.7476,2177.2815,2184.9053,2191.8638,2199.2947,2207.2556};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {2212.705,2217.8904,2220.3486,2221.8271,2223.4504,2225.8625,2226.0,2226.0,2225.7222,2224.8704,2222.0767,2220.6646,2218.383,2217.0854,2215.4282,2004.3556,2016.5067,2029.1171,2039.051,2047.2874,2056.2725,2063.3662,2069.4236,2077.7693,2088.5322,2097.5388,2099.9443,2100.213,2100.0984,2098.984,2097.8694,2096.8333,2097.6123,2100.6912,2104.0737,2108.1387,2116.0276,2122.5093,2128.7317,2134.576,2139.9795,2144.8196,2150.8901,2156.7349,2162.5405,2171.877,2180.2422,2186.717,2193.3782,2200.6057,2207.3364,2213.9165,2218.9187,2221.2517,2223.483,2224.9429,2227.4224,2226.7222,2226.4268,2226.0,2222.811,2219.6323,2218.0,2217.1472,2215.396,2213.7876,2000.4667,2011.1676,2023.0615,2036.2761,2043.6763,2052.6614,2060.9883,2065.8125,2071.4575,2079.1938,2084.952,2088.2036,2089.3333,2090.538,2091.3333,2090.7751,2091.6667,2092.7822,2096.0457,2101.555,2108.7913,2115.313,2122.3425,2128.5002,2135.1577,2141.964,2148.2095,2155.5815,2160.6213,2166.085,2173.2063,2181.4805,2187.731,2194.576};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {2201.1,2207.3364,2214.573,2219.9365,2222.3486,2224.7607,2226.3394,2228.654,2228.1697,2228.0984,2225.3276,2221.4055,2218.2954,2216.9424,2215.442,2214.0984,2212.7551};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.02,0.00391,0.04,0.00391,0.06,0.00391,0.08,0.00391,0.1,0.00391,0.12,0.00391,0.14,0.00391,0.16,0.00391,0.18,0.00391,0.2,0.00391,0.22,0.00391,0.24,0.00391,0.26,0.00391,0.28,0.00391,0.3,0.00391,0.32,0.00391,0.34,0.00391,0.36,0.00391,0.38,0.00391,0.4,0.00391,0.42,0.00391,0.44,0.00391,0.46,0.00391,0.48,0.00391,0.5,0.00391,0.52,0.00391,0.54,0.00391,0.56,0.00391,0.58,0.00391,0.6,0.00391,0.62,0.00391,0.64,0.00391,0.66,0.00391,0.68,0.00391,0.7,0.00391,0.72,0.00391,0.74,0.00391,0.76,0.00391,0.78,0.00391,0.8,0.00391,0.82,0.00391,0.84,0.00391,0.86,0.00391,0.88,0.00391,0.9,0.00391,0.92,0.00391,0.94,0.00391,0.96,0.00391,0.98,0.00391,0.99609,0.00391,0.00391,0.01515,0.02,0.01515,0.04,0.01515,0.06,0.01515,0.08,0.01515,0.1,0.01515,0.12,0.01515,0.14,0.01515,0.16,0.01515,0.18,0.01515,0.2,0.01515,0.22,0.01515,0.24,0.01515,0.26,0.01515,0.28,0.01515,0.3,0.01515,0.32,0.01515,0.34,0.01515,0.36,0.01515,0.38,0.01515,0.4,0.01515,0.42,0.01515,0.44,0.01515,0.46,0.01515,0.48,0.01515,0.5,0.01515,0.52,0.01515,0.54,0.01515,0.56,0.01515,0.58,0.01515,0.6,0.01515,0.62,0.01515,0.64,0.01515,0.66,0.01515,0.68,0.01515,0.7,0.01515,0.72,0.01515,0.74,0.01515,0.76,0.01515,0.78,0.01515,0.8,0.01515,0.82,0.01515,0.84,0.01515,0.86,0.01515,0.88,0.01515,0.9,0.01515,0.92,0.01515,0.94,0.01515,0.96,0.01515};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.98,0.01515,0.99609,0.01515,0.00391,0.0303,0.02,0.0303,0.04,0.0303,0.06,0.0303,0.08,0.0303,0.1,0.0303,0.12,0.0303,0.14,0.0303,0.16,0.0303,0.18,0.0303,0.2,0.0303,0.22,0.0303,0.24,0.0303,0.26,0.0303,0.28,0.0303,0.3,0.0303,0.32,0.0303,0.34,0.0303,0.36,0.0303,0.38,0.0303,0.4,0.0303,0.42,0.0303,0.44,0.0303,0.46,0.0303,0.48,0.0303,0.5,0.0303,0.52,0.0303,0.54,0.0303,0.56,0.0303,0.58,0.0303,0.6,0.0303,0.62,0.0303,0.64,0.0303,0.66,0.0303,0.68,0.0303,0.7,0.0303,0.72,0.0303,0.74,0.0303,0.76,0.0303,0.78,0.0303,0.8,0.0303,0.82,0.0303,0.84,0.0303,0.86,0.0303,0.88,0.0303,0.9,0.0303,0.92,0.0303,0.94,0.0303,0.96,0.0303,0.98,0.0303,0.99609,0.0303,0.00391,0.04545,0.02,0.04545,0.04,0.04545,0.06,0.04545,0.08,0.04545,0.1,0.04545,0.12,0.04545,0.14,0.04545,0.16,0.04545,0.18,0.04545,0.2,0.04545,0.22,0.04545,0.24,0.04545,0.26,0.04545,0.28,0.04545,0.3,0.04545,0.32,0.04545,0.34,0.04545,0.36,0.04545,0.38,0.04545,0.4,0.04545,0.42,0.04545,0.44,0.04545,0.46,0.04545,0.48,0.04545,0.5,0.04545,0.52,0.04545,0.54,0.04545,0.56,0.04545,0.58,0.04545,0.6,0.04545,0.62,0.04545,0.64,0.04545,0.66,0.04545,0.68,0.04545,0.7,0.04545,0.72,0.04545,0.74,0.04545,0.76,0.04545,0.78,0.04545,0.8,0.04545,0.82,0.04545,0.84,0.04545,0.86,0.04545,0.88,0.04545,0.9,0.04545,0.92,0.04545};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.94,0.04545,0.96,0.04545,0.98,0.04545,0.99609,0.04545,0.00391,0.06061,0.02,0.06061,0.04,0.06061,0.06,0.06061,0.08,0.06061,0.1,0.06061,0.12,0.06061,0.14,0.06061,0.16,0.06061,0.18,0.06061,0.2,0.06061,0.22,0.06061,0.24,0.06061,0.26,0.06061,0.28,0.06061,0.3,0.06061,0.32,0.06061,0.34,0.06061,0.36,0.06061,0.38,0.06061,0.4,0.06061,0.42,0.06061,0.44,0.06061,0.46,0.06061,0.48,0.06061,0.5,0.06061,0.52,0.06061,0.54,0.06061,0.56,0.06061,0.58,0.06061,0.6,0.06061,0.62,0.06061,0.64,0.06061,0.66,0.06061,0.68,0.06061,0.7,0.06061,0.72,0.06061,0.74,0.06061,0.76,0.06061,0.78,0.06061,0.8,0.06061,0.82,0.06061,0.84,0.06061,0.86,0.06061,0.88,0.06061,0.9,0.06061,0.92,0.06061,0.94,0.06061,0.96,0.06061,0.98,0.06061,0.99609,0.06061,0.00391,0.07576,0.02,0.07576,0.04,0.07576,0.06,0.07576,0.08,0.07576,0.1,0.07576,0.12,0.07576,0.14,0.07576,0.16,0.07576,0.18,0.07576,0.2,0.07576,0.22,0.07576,0.24,0.07576,0.26,0.07576,0.28,0.07576,0.3,0.07576,0.32,0.07576,0.34,0.07576,0.36,0.07576,0.38,0.07576,0.4,0.07576,0.42,0.07576,0.44,0.07576,0.46,0.07576,0.48,0.07576,0.5,0.07576,0.52,0.07576,0.54,0.07576,0.56,0.07576,0.58,0.07576,0.6,0.07576,0.62,0.07576,0.64,0.07576,0.66,0.07576,0.68,0.07576,0.7,0.07576,0.72,0.07576,0.74,0.07576,0.76,0.07576,0.78,0.07576,0.8,0.07576,0.82,0.07576,0.84,0.07576,0.86,0.07576,0.88,0.07576};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.9,0.07576,0.92,0.07576,0.94,0.07576,0.96,0.07576,0.98,0.07576,0.99609,0.07576,0.00391,0.09091,0.02,0.09091,0.04,0.09091,0.06,0.09091,0.08,0.09091,0.1,0.09091,0.12,0.09091,0.14,0.09091,0.16,0.09091,0.18,0.09091,0.2,0.09091,0.22,0.09091,0.24,0.09091,0.26,0.09091,0.28,0.09091,0.3,0.09091,0.32,0.09091,0.34,0.09091,0.36,0.09091,0.38,0.09091,0.4,0.09091,0.42,0.09091,0.44,0.09091,0.46,0.09091,0.48,0.09091,0.5,0.09091,0.52,0.09091,0.54,0.09091,0.56,0.09091,0.58,0.09091,0.6,0.09091,0.62,0.09091,0.64,0.09091,0.66,0.09091,0.68,0.09091,0.7,0.09091,0.72,0.09091,0.74,0.09091,0.76,0.09091,0.78,0.09091,0.8,0.09091,0.82,0.09091,0.84,0.09091,0.86,0.09091,0.88,0.09091,0.9,0.09091,0.92,0.09091,0.94,0.09091,0.96,0.09091,0.98,0.09091,0.99609,0.09091,0.00391,0.10606,0.02,0.10606,0.04,0.10606,0.06,0.10606,0.08,0.10606,0.1,0.10606,0.12,0.10606,0.14,0.10606,0.16,0.10606,0.18,0.10606,0.2,0.10606,0.22,0.10606,0.24,0.10606,0.26,0.10606,0.28,0.10606,0.3,0.10606,0.32,0.10606,0.34,0.10606,0.36,0.10606,0.38,0.10606,0.4,0.10606,0.42,0.10606,0.44,0.10606,0.46,0.10606,0.48,0.10606,0.5,0.10606,0.52,0.10606,0.54,0.10606,0.56,0.10606,0.58,0.10606,0.6,0.10606,0.62,0.10606,0.64,0.10606,0.66,0.10606,0.68,0.10606,0.7,0.10606,0.72,0.10606,0.74,0.10606,0.76,0.10606,0.78,0.10606,0.8,0.10606,0.82,0.10606,0.84,0.10606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.86,0.10606,0.88,0.10606,0.9,0.10606,0.92,0.10606,0.94,0.10606,0.96,0.10606,0.98,0.10606,0.99609,0.10606,0.00391,0.12121,0.02,0.12121,0.04,0.12121,0.06,0.12121,0.08,0.12121,0.1,0.12121,0.12,0.12121,0.14,0.12121,0.16,0.12121,0.18,0.12121,0.2,0.12121,0.22,0.12121,0.24,0.12121,0.26,0.12121,0.28,0.12121,0.3,0.12121,0.32,0.12121,0.34,0.12121,0.36,0.12121,0.38,0.12121,0.4,0.12121,0.42,0.12121,0.44,0.12121,0.46,0.12121,0.48,0.12121,0.5,0.12121,0.52,0.12121,0.54,0.12121,0.56,0.12121,0.58,0.12121,0.6,0.12121,0.62,0.12121,0.64,0.12121,0.66,0.12121,0.68,0.12121,0.7,0.12121,0.72,0.12121,0.74,0.12121,0.76,0.12121,0.78,0.12121,0.8,0.12121,0.82,0.12121,0.84,0.12121,0.86,0.12121,0.88,0.12121,0.9,0.12121,0.92,0.12121,0.94,0.12121,0.96,0.12121,0.98,0.12121,0.99609,0.12121,0.00391,0.13636,0.02,0.13636,0.04,0.13636,0.06,0.13636,0.08,0.13636,0.1,0.13636,0.12,0.13636,0.14,0.13636,0.16,0.13636,0.18,0.13636,0.2,0.13636,0.22,0.13636,0.24,0.13636,0.26,0.13636,0.28,0.13636,0.3,0.13636,0.32,0.13636,0.34,0.13636,0.36,0.13636,0.38,0.13636,0.4,0.13636,0.42,0.13636,0.44,0.13636,0.46,0.13636,0.48,0.13636,0.5,0.13636,0.52,0.13636,0.54,0.13636,0.56,0.13636,0.58,0.13636,0.6,0.13636,0.62,0.13636,0.64,0.13636,0.66,0.13636,0.68,0.13636,0.7,0.13636,0.72,0.13636,0.74,0.13636,0.76,0.13636,0.78,0.13636,0.8,0.13636};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.82,0.13636,0.84,0.13636,0.86,0.13636,0.88,0.13636,0.9,0.13636,0.92,0.13636,0.94,0.13636,0.96,0.13636,0.98,0.13636,0.99609,0.13636,0.00391,0.15152,0.02,0.15152,0.04,0.15152,0.06,0.15152,0.08,0.15152,0.1,0.15152,0.12,0.15152,0.14,0.15152,0.16,0.15152,0.18,0.15152,0.2,0.15152,0.22,0.15152,0.24,0.15152,0.26,0.15152,0.28,0.15152,0.3,0.15152,0.32,0.15152,0.34,0.15152,0.36,0.15152,0.38,0.15152,0.4,0.15152,0.42,0.15152,0.44,0.15152,0.46,0.15152,0.48,0.15152,0.5,0.15152,0.52,0.15152,0.54,0.15152,0.56,0.15152,0.58,0.15152,0.6,0.15152,0.62,0.15152,0.64,0.15152,0.66,0.15152,0.68,0.15152,0.7,0.15152,0.72,0.15152,0.74,0.15152,0.76,0.15152,0.78,0.15152,0.8,0.15152,0.82,0.15152,0.84,0.15152,0.86,0.15152,0.88,0.15152,0.9,0.15152,0.92,0.15152,0.94,0.15152,0.96,0.15152,0.98,0.15152,0.99609,0.15152,0.00391,0.16667,0.02,0.16667,0.04,0.16667,0.06,0.16667,0.08,0.16667,0.1,0.16667,0.12,0.16667,0.14,0.16667,0.16,0.16667,0.18,0.16667,0.2,0.16667,0.22,0.16667,0.24,0.16667,0.26,0.16667,0.28,0.16667,0.3,0.16667,0.32,0.16667,0.34,0.16667,0.36,0.16667,0.38,0.16667,0.4,0.16667,0.42,0.16667,0.44,0.16667,0.46,0.16667,0.48,0.16667,0.5,0.16667,0.52,0.16667,0.54,0.16667,0.56,0.16667,0.58,0.16667,0.6,0.16667,0.62,0.16667,0.64,0.16667,0.66,0.16667,0.68,0.16667,0.7,0.16667,0.72,0.16667,0.74,0.16667,0.76,0.16667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.78,0.16667,0.8,0.16667,0.82,0.16667,0.84,0.16667,0.86,0.16667,0.88,0.16667,0.9,0.16667,0.92,0.16667,0.94,0.16667,0.96,0.16667,0.98,0.16667,0.99609,0.16667,0.00391,0.18182,0.02,0.18182,0.04,0.18182,0.06,0.18182,0.08,0.18182,0.1,0.18182,0.12,0.18182,0.14,0.18182,0.16,0.18182,0.18,0.18182,0.2,0.18182,0.22,0.18182,0.24,0.18182,0.26,0.18182,0.28,0.18182,0.3,0.18182,0.32,0.18182,0.34,0.18182,0.36,0.18182,0.38,0.18182,0.4,0.18182,0.42,0.18182,0.44,0.18182,0.46,0.18182,0.48,0.18182,0.5,0.18182,0.52,0.18182,0.54,0.18182,0.56,0.18182,0.58,0.18182,0.6,0.18182,0.62,0.18182,0.64,0.18182,0.66,0.18182,0.68,0.18182,0.7,0.18182,0.72,0.18182,0.74,0.18182,0.76,0.18182,0.78,0.18182,0.8,0.18182,0.82,0.18182,0.84,0.18182,0.86,0.18182,0.88,0.18182,0.9,0.18182,0.92,0.18182,0.94,0.18182,0.96,0.18182,0.98,0.18182,0.99609,0.18182,0.00391,0.19697,0.02,0.19697,0.04,0.19697,0.06,0.19697,0.08,0.19697,0.1,0.19697,0.12,0.19697,0.14,0.19697,0.16,0.19697,0.18,0.19697,0.2,0.19697,0.22,0.19697,0.24,0.19697,0.26,0.19697,0.28,0.19697,0.3,0.19697,0.32,0.19697,0.34,0.19697,0.36,0.19697,0.38,0.19697,0.4,0.19697,0.42,0.19697,0.44,0.19697,0.46,0.19697,0.48,0.19697,0.5,0.19697,0.52,0.19697,0.54,0.19697,0.56,0.19697,0.58,0.19697,0.6,0.19697,0.62,0.19697,0.64,0.19697,0.66,0.19697,0.68,0.19697,0.7,0.19697,0.72,0.19697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.74,0.19697,0.76,0.19697,0.78,0.19697,0.8,0.19697,0.82,0.19697,0.84,0.19697,0.86,0.19697,0.88,0.19697,0.9,0.19697,0.92,0.19697,0.94,0.19697,0.96,0.19697,0.98,0.19697,0.99609,0.19697,0.00391,0.21212,0.02,0.21212,0.04,0.21212,0.06,0.21212,0.08,0.21212,0.1,0.21212,0.12,0.21212,0.14,0.21212,0.16,0.21212,0.18,0.21212,0.2,0.21212,0.22,0.21212,0.24,0.21212,0.26,0.21212,0.28,0.21212,0.3,0.21212,0.32,0.21212,0.34,0.21212,0.36,0.21212,0.38,0.21212,0.4,0.21212,0.42,0.21212,0.44,0.21212,0.46,0.21212,0.48,0.21212,0.5,0.21212,0.52,0.21212,0.54,0.21212,0.56,0.21212,0.58,0.21212,0.6,0.21212,0.62,0.21212,0.64,0.21212,0.66,0.21212,0.68,0.21212,0.7,0.21212,0.72,0.21212,0.74,0.21212,0.76,0.21212,0.78,0.21212,0.8,0.21212,0.82,0.21212,0.84,0.21212,0.86,0.21212,0.88,0.21212,0.9,0.21212,0.92,0.21212,0.94,0.21212,0.96,0.21212,0.98,0.21212,0.99609,0.21212,0.00391,0.22727,0.02,0.22727,0.04,0.22727,0.06,0.22727,0.08,0.22727,0.1,0.22727,0.12,0.22727,0.14,0.22727,0.16,0.22727,0.18,0.22727,0.2,0.22727,0.22,0.22727,0.24,0.22727,0.26,0.22727,0.28,0.22727,0.3,0.22727,0.32,0.22727,0.34,0.22727,0.36,0.22727,0.38,0.22727,0.4,0.22727,0.42,0.22727,0.44,0.22727,0.46,0.22727,0.48,0.22727,0.5,0.22727,0.52,0.22727,0.54,0.22727,0.56,0.22727,0.58,0.22727,0.6,0.22727,0.62,0.22727,0.64,0.22727,0.66,0.22727,0.68,0.22727};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.7,0.22727,0.72,0.22727,0.74,0.22727,0.76,0.22727,0.78,0.22727,0.8,0.22727,0.82,0.22727,0.84,0.22727,0.86,0.22727,0.88,0.22727,0.9,0.22727,0.92,0.22727,0.94,0.22727,0.96,0.22727,0.98,0.22727,0.99609,0.22727,0.00391,0.24242,0.02,0.24242,0.04,0.24242,0.06,0.24242,0.08,0.24242,0.1,0.24242,0.12,0.24242,0.14,0.24242,0.16,0.24242,0.18,0.24242,0.2,0.24242,0.22,0.24242,0.24,0.24242,0.26,0.24242,0.28,0.24242,0.3,0.24242,0.32,0.24242,0.34,0.24242,0.36,0.24242,0.38,0.24242,0.4,0.24242,0.42,0.24242,0.44,0.24242,0.46,0.24242,0.48,0.24242,0.5,0.24242,0.52,0.24242,0.54,0.24242,0.56,0.24242,0.58,0.24242,0.6,0.24242,0.62,0.24242,0.64,0.24242,0.66,0.24242,0.68,0.24242,0.7,0.24242,0.72,0.24242,0.74,0.24242,0.76,0.24242,0.78,0.24242,0.8,0.24242,0.82,0.24242,0.84,0.24242,0.86,0.24242,0.88,0.24242,0.9,0.24242,0.92,0.24242,0.94,0.24242,0.96,0.24242,0.98,0.24242,0.99609,0.24242,0.00391,0.25758,0.02,0.25758,0.04,0.25758,0.06,0.25758,0.08,0.25758,0.1,0.25758,0.12,0.25758,0.14,0.25758,0.16,0.25758,0.18,0.25758,0.2,0.25758,0.22,0.25758,0.24,0.25758,0.26,0.25758,0.28,0.25758,0.3,0.25758,0.32,0.25758,0.34,0.25758,0.36,0.25758,0.38,0.25758,0.4,0.25758,0.42,0.25758,0.44,0.25758,0.46,0.25758,0.48,0.25758,0.5,0.25758,0.52,0.25758,0.54,0.25758,0.56,0.25758,0.58,0.25758,0.6,0.25758,0.62,0.25758,0.64,0.25758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.66,0.25758,0.68,0.25758,0.7,0.25758,0.72,0.25758,0.74,0.25758,0.76,0.25758,0.78,0.25758,0.8,0.25758,0.82,0.25758,0.84,0.25758,0.86,0.25758,0.88,0.25758,0.9,0.25758,0.92,0.25758,0.94,0.25758,0.96,0.25758,0.98,0.25758,0.99609,0.25758,0.00391,0.27273,0.02,0.27273,0.04,0.27273,0.06,0.27273,0.08,0.27273,0.1,0.27273,0.12,0.27273,0.14,0.27273,0.16,0.27273,0.18,0.27273,0.2,0.27273,0.22,0.27273,0.24,0.27273,0.26,0.27273,0.28,0.27273,0.3,0.27273,0.32,0.27273,0.34,0.27273,0.36,0.27273,0.38,0.27273,0.4,0.27273,0.42,0.27273,0.44,0.27273,0.46,0.27273,0.48,0.27273,0.5,0.27273,0.52,0.27273,0.54,0.27273,0.56,0.27273,0.58,0.27273,0.6,0.27273,0.62,0.27273,0.64,0.27273,0.66,0.27273,0.68,0.27273,0.7,0.27273,0.72,0.27273,0.74,0.27273,0.76,0.27273,0.78,0.27273,0.8,0.27273,0.82,0.27273,0.84,0.27273,0.86,0.27273,0.88,0.27273,0.9,0.27273,0.92,0.27273,0.94,0.27273,0.96,0.27273,0.98,0.27273,0.99609,0.27273,0.00391,0.28788,0.02,0.28788,0.04,0.28788,0.06,0.28788,0.08,0.28788,0.1,0.28788,0.12,0.28788,0.14,0.28788,0.16,0.28788,0.18,0.28788,0.2,0.28788,0.22,0.28788,0.24,0.28788,0.26,0.28788,0.28,0.28788,0.3,0.28788,0.32,0.28788,0.34,0.28788,0.36,0.28788,0.38,0.28788,0.4,0.28788,0.42,0.28788,0.44,0.28788,0.46,0.28788,0.48,0.28788,0.5,0.28788,0.52,0.28788,0.54,0.28788,0.56,0.28788,0.58,0.28788,0.6,0.28788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.62,0.28788,0.64,0.28788,0.66,0.28788,0.68,0.28788,0.7,0.28788,0.72,0.28788,0.74,0.28788,0.76,0.28788,0.78,0.28788,0.8,0.28788,0.82,0.28788,0.84,0.28788,0.86,0.28788,0.88,0.28788,0.9,0.28788,0.92,0.28788,0.94,0.28788,0.96,0.28788,0.98,0.28788,0.99609,0.28788,0.00391,0.30303,0.02,0.30303,0.04,0.30303,0.06,0.30303,0.08,0.30303,0.1,0.30303,0.12,0.30303,0.14,0.30303,0.16,0.30303,0.18,0.30303,0.2,0.30303,0.22,0.30303,0.24,0.30303,0.26,0.30303,0.28,0.30303,0.3,0.30303,0.32,0.30303,0.34,0.30303,0.36,0.30303,0.38,0.30303,0.4,0.30303,0.42,0.30303,0.44,0.30303,0.46,0.30303,0.48,0.30303,0.5,0.30303,0.52,0.30303,0.54,0.30303,0.56,0.30303,0.58,0.30303,0.6,0.30303,0.62,0.30303,0.64,0.30303,0.66,0.30303,0.68,0.30303,0.7,0.30303,0.72,0.30303,0.74,0.30303,0.76,0.30303,0.78,0.30303,0.8,0.30303,0.82,0.30303,0.84,0.30303,0.86,0.30303,0.88,0.30303,0.9,0.30303,0.92,0.30303,0.94,0.30303,0.96,0.30303,0.98,0.30303,0.99609,0.30303,0.00391,0.31818,0.02,0.31818,0.04,0.31818,0.06,0.31818,0.08,0.31818,0.1,0.31818,0.12,0.31818,0.14,0.31818,0.16,0.31818,0.18,0.31818,0.2,0.31818,0.22,0.31818,0.24,0.31818,0.26,0.31818,0.28,0.31818,0.3,0.31818,0.32,0.31818,0.34,0.31818,0.36,0.31818,0.38,0.31818,0.4,0.31818,0.42,0.31818,0.44,0.31818,0.46,0.31818,0.48,0.31818,0.5,0.31818,0.52,0.31818,0.54,0.31818,0.56,0.31818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.58,0.31818,0.6,0.31818,0.62,0.31818,0.64,0.31818,0.66,0.31818,0.68,0.31818,0.7,0.31818,0.72,0.31818,0.74,0.31818,0.76,0.31818,0.78,0.31818,0.8,0.31818,0.82,0.31818,0.84,0.31818,0.86,0.31818,0.88,0.31818,0.9,0.31818,0.92,0.31818,0.94,0.31818,0.96,0.31818,0.98,0.31818,0.99609,0.31818,0.00391,0.33333,0.02,0.33333,0.04,0.33333,0.06,0.33333,0.08,0.33333,0.1,0.33333,0.12,0.33333,0.14,0.33333,0.16,0.33333,0.18,0.33333,0.2,0.33333,0.22,0.33333,0.24,0.33333,0.26,0.33333,0.28,0.33333,0.3,0.33333,0.32,0.33333,0.34,0.33333,0.36,0.33333,0.38,0.33333,0.4,0.33333,0.42,0.33333,0.44,0.33333,0.46,0.33333,0.48,0.33333,0.5,0.33333,0.52,0.33333,0.54,0.33333,0.56,0.33333,0.58,0.33333,0.6,0.33333,0.62,0.33333,0.64,0.33333,0.66,0.33333,0.68,0.33333,0.7,0.33333,0.72,0.33333,0.74,0.33333,0.76,0.33333,0.78,0.33333,0.8,0.33333,0.82,0.33333,0.84,0.33333,0.86,0.33333,0.88,0.33333,0.9,0.33333,0.92,0.33333,0.94,0.33333,0.96,0.33333,0.98,0.33333,0.99609,0.33333,0.00391,0.34848,0.02,0.34848,0.04,0.34848,0.06,0.34848,0.08,0.34848,0.1,0.34848,0.12,0.34848,0.14,0.34848,0.16,0.34848,0.18,0.34848,0.2,0.34848,0.22,0.34848,0.24,0.34848,0.26,0.34848,0.28,0.34848,0.3,0.34848,0.32,0.34848,0.34,0.34848,0.36,0.34848,0.38,0.34848,0.4,0.34848,0.42,0.34848,0.44,0.34848,0.46,0.34848,0.48,0.34848,0.5,0.34848,0.52,0.34848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.54,0.34848,0.56,0.34848,0.58,0.34848,0.6,0.34848,0.62,0.34848,0.64,0.34848,0.66,0.34848,0.68,0.34848,0.7,0.34848,0.72,0.34848,0.74,0.34848,0.76,0.34848,0.78,0.34848,0.8,0.34848,0.82,0.34848,0.84,0.34848,0.86,0.34848,0.88,0.34848,0.9,0.34848,0.92,0.34848,0.94,0.34848,0.96,0.34848,0.98,0.34848,0.99609,0.34848,0.00391,0.36364,0.02,0.36364,0.04,0.36364,0.06,0.36364,0.08,0.36364,0.1,0.36364,0.12,0.36364,0.14,0.36364,0.16,0.36364,0.18,0.36364,0.2,0.36364,0.22,0.36364,0.24,0.36364,0.26,0.36364,0.28,0.36364,0.3,0.36364,0.32,0.36364,0.34,0.36364,0.36,0.36364,0.38,0.36364,0.4,0.36364,0.42,0.36364,0.44,0.36364,0.46,0.36364,0.48,0.36364,0.5,0.36364,0.52,0.36364,0.54,0.36364,0.56,0.36364,0.58,0.36364,0.6,0.36364,0.62,0.36364,0.64,0.36364,0.66,0.36364,0.68,0.36364,0.7,0.36364,0.72,0.36364,0.74,0.36364,0.76,0.36364,0.78,0.36364,0.8,0.36364,0.82,0.36364,0.84,0.36364,0.86,0.36364,0.88,0.36364,0.9,0.36364,0.92,0.36364,0.94,0.36364,0.96,0.36364,0.98,0.36364,0.99609,0.36364,0.00391,0.37879,0.02,0.37879,0.04,0.37879,0.06,0.37879,0.08,0.37879,0.1,0.37879,0.12,0.37879,0.14,0.37879,0.16,0.37879,0.18,0.37879,0.2,0.37879,0.22,0.37879,0.24,0.37879,0.26,0.37879,0.28,0.37879,0.3,0.37879,0.32,0.37879,0.34,0.37879,0.36,0.37879,0.38,0.37879,0.4,0.37879,0.42,0.37879,0.44,0.37879,0.46,0.37879,0.48,0.37879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.5,0.37879,0.52,0.37879,0.54,0.37879,0.56,0.37879,0.58,0.37879,0.6,0.37879,0.62,0.37879,0.64,0.37879,0.66,0.37879,0.68,0.37879,0.7,0.37879,0.72,0.37879,0.74,0.37879,0.76,0.37879,0.78,0.37879,0.8,0.37879,0.82,0.37879,0.84,0.37879,0.86,0.37879,0.88,0.37879,0.9,0.37879,0.92,0.37879,0.94,0.37879,0.96,0.37879,0.98,0.37879,0.99609,0.37879,0.00391,0.39394,0.02,0.39394,0.04,0.39394,0.06,0.39394,0.08,0.39394,0.1,0.39394,0.12,0.39394,0.14,0.39394,0.16,0.39394,0.18,0.39394,0.2,0.39394,0.22,0.39394,0.24,0.39394,0.26,0.39394,0.28,0.39394,0.3,0.39394,0.32,0.39394,0.34,0.39394,0.36,0.39394,0.38,0.39394,0.4,0.39394,0.42,0.39394,0.44,0.39394,0.46,0.39394,0.48,0.39394,0.5,0.39394,0.52,0.39394,0.54,0.39394,0.56,0.39394,0.58,0.39394,0.6,0.39394,0.62,0.39394,0.64,0.39394,0.66,0.39394,0.68,0.39394,0.7,0.39394,0.72,0.39394,0.74,0.39394,0.76,0.39394,0.78,0.39394,0.8,0.39394,0.82,0.39394,0.84,0.39394,0.86,0.39394,0.88,0.39394,0.9,0.39394,0.92,0.39394,0.94,0.39394,0.96,0.39394,0.98,0.39394,0.99609,0.39394,0.00391,0.40909,0.02,0.40909,0.04,0.40909,0.06,0.40909,0.08,0.40909,0.1,0.40909,0.12,0.40909,0.14,0.40909,0.16,0.40909,0.18,0.40909,0.2,0.40909,0.22,0.40909,0.24,0.40909,0.26,0.40909,0.28,0.40909,0.3,0.40909,0.32,0.40909,0.34,0.40909,0.36,0.40909,0.38,0.40909,0.4,0.40909,0.42,0.40909,0.44,0.40909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.46,0.40909,0.48,0.40909,0.5,0.40909,0.52,0.40909,0.54,0.40909,0.56,0.40909,0.58,0.40909,0.6,0.40909,0.62,0.40909,0.64,0.40909,0.66,0.40909,0.68,0.40909,0.7,0.40909,0.72,0.40909,0.74,0.40909,0.76,0.40909,0.78,0.40909,0.8,0.40909,0.82,0.40909,0.84,0.40909,0.86,0.40909,0.88,0.40909,0.9,0.40909,0.92,0.40909,0.94,0.40909,0.96,0.40909,0.98,0.40909,0.99609,0.40909,0.00391,0.42424,0.02,0.42424,0.04,0.42424,0.06,0.42424,0.08,0.42424,0.1,0.42424,0.12,0.42424,0.14,0.42424,0.16,0.42424,0.18,0.42424,0.2,0.42424,0.22,0.42424,0.24,0.42424,0.26,0.42424,0.28,0.42424,0.3,0.42424,0.32,0.42424,0.34,0.42424,0.36,0.42424,0.38,0.42424,0.4,0.42424,0.42,0.42424,0.44,0.42424,0.46,0.42424,0.48,0.42424,0.5,0.42424,0.52,0.42424,0.54,0.42424,0.56,0.42424,0.58,0.42424,0.6,0.42424,0.62,0.42424,0.64,0.42424,0.66,0.42424,0.68,0.42424,0.7,0.42424,0.72,0.42424,0.74,0.42424,0.76,0.42424,0.78,0.42424,0.8,0.42424,0.82,0.42424,0.84,0.42424,0.86,0.42424,0.88,0.42424,0.9,0.42424,0.92,0.42424,0.94,0.42424,0.96,0.42424,0.98,0.42424,0.99609,0.42424,0.00391,0.43939,0.02,0.43939,0.04,0.43939,0.06,0.43939,0.08,0.43939,0.1,0.43939,0.12,0.43939,0.14,0.43939,0.16,0.43939,0.18,0.43939,0.2,0.43939,0.22,0.43939,0.24,0.43939,0.26,0.43939,0.28,0.43939,0.3,0.43939,0.32,0.43939,0.34,0.43939,0.36,0.43939,0.38,0.43939,0.4,0.43939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.42,0.43939,0.44,0.43939,0.46,0.43939,0.48,0.43939,0.5,0.43939,0.52,0.43939,0.54,0.43939,0.56,0.43939,0.58,0.43939,0.6,0.43939,0.62,0.43939,0.64,0.43939,0.66,0.43939,0.68,0.43939,0.7,0.43939,0.72,0.43939,0.74,0.43939,0.76,0.43939,0.78,0.43939,0.8,0.43939,0.82,0.43939,0.84,0.43939,0.86,0.43939,0.88,0.43939,0.9,0.43939,0.92,0.43939,0.94,0.43939,0.96,0.43939,0.98,0.43939,0.99609,0.43939,0.00391,0.45455,0.02,0.45455,0.04,0.45455,0.06,0.45455,0.08,0.45455,0.1,0.45455,0.12,0.45455,0.14,0.45455,0.16,0.45455,0.18,0.45455,0.2,0.45455,0.22,0.45455,0.24,0.45455,0.26,0.45455,0.28,0.45455,0.3,0.45455,0.32,0.45455,0.34,0.45455,0.36,0.45455,0.38,0.45455,0.4,0.45455,0.42,0.45455,0.44,0.45455,0.46,0.45455,0.48,0.45455,0.5,0.45455,0.52,0.45455,0.54,0.45455,0.56,0.45455,0.58,0.45455,0.6,0.45455,0.62,0.45455,0.64,0.45455,0.66,0.45455,0.68,0.45455,0.7,0.45455,0.72,0.45455,0.74,0.45455,0.76,0.45455,0.78,0.45455,0.8,0.45455,0.82,0.45455,0.84,0.45455,0.86,0.45455,0.88,0.45455,0.9,0.45455,0.92,0.45455,0.94,0.45455,0.96,0.45455,0.98,0.45455,0.99609,0.45455,0.00391,0.4697,0.02,0.4697,0.04,0.4697,0.06,0.4697,0.08,0.4697,0.1,0.4697,0.12,0.4697,0.14,0.4697,0.16,0.4697,0.18,0.4697,0.2,0.4697,0.22,0.4697,0.24,0.4697,0.26,0.4697,0.28,0.4697,0.3,0.4697,0.32,0.4697,0.34,0.4697,0.36,0.4697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.38,0.4697,0.4,0.4697,0.42,0.4697,0.44,0.4697,0.46,0.4697,0.48,0.4697,0.5,0.4697,0.52,0.4697,0.54,0.4697,0.56,0.4697,0.58,0.4697,0.6,0.4697,0.62,0.4697,0.64,0.4697,0.66,0.4697,0.68,0.4697,0.7,0.4697,0.72,0.4697,0.74,0.4697,0.76,0.4697,0.78,0.4697,0.8,0.4697,0.82,0.4697,0.84,0.4697,0.86,0.4697,0.88,0.4697,0.9,0.4697,0.92,0.4697,0.94,0.4697,0.96,0.4697,0.98,0.4697,0.99609,0.4697,0.00391,0.48485,0.02,0.48485,0.04,0.48485,0.06,0.48485,0.08,0.48485,0.1,0.48485,0.12,0.48485,0.14,0.48485,0.16,0.48485,0.18,0.48485,0.2,0.48485,0.22,0.48485,0.24,0.48485,0.26,0.48485,0.28,0.48485,0.3,0.48485,0.32,0.48485,0.34,0.48485,0.36,0.48485,0.38,0.48485,0.4,0.48485,0.42,0.48485,0.44,0.48485,0.46,0.48485,0.48,0.48485,0.5,0.48485,0.52,0.48485,0.54,0.48485,0.56,0.48485,0.58,0.48485,0.6,0.48485,0.62,0.48485,0.64,0.48485,0.66,0.48485,0.68,0.48485,0.7,0.48485,0.72,0.48485,0.74,0.48485,0.76,0.48485,0.78,0.48485,0.8,0.48485,0.82,0.48485,0.84,0.48485,0.86,0.48485,0.88,0.48485,0.9,0.48485,0.92,0.48485,0.94,0.48485,0.96,0.48485,0.98,0.48485,0.99609,0.48485,0.00391,0.5,0.02,0.5,0.04,0.5,0.06,0.5,0.08,0.5,0.1,0.5,0.12,0.5,0.14,0.5,0.16,0.5,0.18,0.5,0.2,0.5,0.22,0.5,0.24,0.5,0.26,0.5,0.28,0.5,0.3,0.5,0.32,0.5};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.34,0.5,0.36,0.5,0.38,0.5,0.4,0.5,0.42,0.5,0.44,0.5,0.46,0.5,0.48,0.5,0.5,0.5,0.52,0.5,0.54,0.5,0.56,0.5,0.58,0.5,0.6,0.5,0.62,0.5,0.64,0.5,0.66,0.5,0.68,0.5,0.7,0.5,0.72,0.5,0.74,0.5,0.76,0.5,0.78,0.5,0.8,0.5,0.82,0.5,0.84,0.5,0.86,0.5,0.88,0.5,0.9,0.5,0.92,0.5,0.94,0.5,0.96,0.5,0.98,0.5,0.99609,0.5,0.00391,0.51515,0.02,0.51515,0.04,0.51515,0.06,0.51515,0.08,0.51515,0.1,0.51515,0.12,0.51515,0.14,0.51515,0.16,0.51515,0.18,0.51515,0.2,0.51515,0.22,0.51515,0.24,0.51515,0.26,0.51515,0.28,0.51515,0.3,0.51515,0.32,0.51515,0.34,0.51515,0.36,0.51515,0.38,0.51515,0.4,0.51515,0.42,0.51515,0.44,0.51515,0.46,0.51515,0.48,0.51515,0.5,0.51515,0.52,0.51515,0.54,0.51515,0.56,0.51515,0.58,0.51515,0.6,0.51515,0.62,0.51515,0.64,0.51515,0.66,0.51515,0.68,0.51515,0.7,0.51515,0.72,0.51515,0.74,0.51515,0.76,0.51515,0.78,0.51515,0.8,0.51515,0.82,0.51515,0.84,0.51515,0.86,0.51515,0.88,0.51515,0.9,0.51515,0.92,0.51515,0.94,0.51515,0.96,0.51515,0.98,0.51515,0.99609,0.51515,0.00391,0.5303,0.02,0.5303,0.04,0.5303,0.06,0.5303,0.08,0.5303,0.1,0.5303,0.12,0.5303,0.14,0.5303,0.16,0.5303,0.18,0.5303,0.2,0.5303,0.22,0.5303,0.24,0.5303,0.26,0.5303,0.28,0.5303};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.3,0.5303,0.32,0.5303,0.34,0.5303,0.36,0.5303,0.38,0.5303,0.4,0.5303,0.42,0.5303,0.44,0.5303,0.46,0.5303,0.48,0.5303,0.5,0.5303,0.52,0.5303,0.54,0.5303,0.56,0.5303,0.58,0.5303,0.6,0.5303,0.62,0.5303,0.64,0.5303,0.66,0.5303,0.68,0.5303,0.7,0.5303,0.72,0.5303,0.74,0.5303,0.76,0.5303,0.78,0.5303,0.8,0.5303,0.82,0.5303,0.84,0.5303,0.86,0.5303,0.88,0.5303,0.9,0.5303,0.92,0.5303,0.94,0.5303,0.96,0.5303,0.98,0.5303,0.99609,0.5303,0.00391,0.54545,0.02,0.54545,0.04,0.54545,0.06,0.54545,0.08,0.54545,0.1,0.54545,0.12,0.54545,0.14,0.54545,0.16,0.54545,0.18,0.54545,0.2,0.54545,0.22,0.54545,0.24,0.54545,0.26,0.54545,0.28,0.54545,0.3,0.54545,0.32,0.54545,0.34,0.54545,0.36,0.54545,0.38,0.54545,0.4,0.54545,0.42,0.54545,0.44,0.54545,0.46,0.54545,0.48,0.54545,0.5,0.54545,0.52,0.54545,0.54,0.54545,0.56,0.54545,0.58,0.54545,0.6,0.54545,0.62,0.54545,0.64,0.54545,0.66,0.54545,0.68,0.54545,0.7,0.54545,0.72,0.54545,0.74,0.54545,0.76,0.54545,0.78,0.54545,0.8,0.54545,0.82,0.54545,0.84,0.54545,0.86,0.54545,0.88,0.54545,0.9,0.54545,0.92,0.54545,0.94,0.54545,0.96,0.54545,0.98,0.54545,0.99609,0.54545,0.00391,0.56061,0.02,0.56061,0.04,0.56061,0.06,0.56061,0.08,0.56061,0.1,0.56061,0.12,0.56061,0.14,0.56061,0.16,0.56061,0.18,0.56061,0.2,0.56061,0.22,0.56061,0.24,0.56061};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.26,0.56061,0.28,0.56061,0.3,0.56061,0.32,0.56061,0.34,0.56061,0.36,0.56061,0.38,0.56061,0.4,0.56061,0.42,0.56061,0.44,0.56061,0.46,0.56061,0.48,0.56061,0.5,0.56061,0.52,0.56061,0.54,0.56061,0.56,0.56061,0.58,0.56061,0.6,0.56061,0.62,0.56061,0.64,0.56061,0.66,0.56061,0.68,0.56061,0.7,0.56061,0.72,0.56061,0.74,0.56061,0.76,0.56061,0.78,0.56061,0.8,0.56061,0.82,0.56061,0.84,0.56061,0.86,0.56061,0.88,0.56061,0.9,0.56061,0.92,0.56061,0.94,0.56061,0.96,0.56061,0.98,0.56061,0.99609,0.56061,0.00391,0.57576,0.02,0.57576,0.04,0.57576,0.06,0.57576,0.08,0.57576,0.1,0.57576,0.12,0.57576,0.14,0.57576,0.16,0.57576,0.18,0.57576,0.2,0.57576,0.22,0.57576,0.24,0.57576,0.26,0.57576,0.28,0.57576,0.3,0.57576,0.32,0.57576,0.34,0.57576,0.36,0.57576,0.38,0.57576,0.4,0.57576,0.42,0.57576,0.44,0.57576,0.46,0.57576,0.48,0.57576,0.5,0.57576,0.52,0.57576,0.54,0.57576,0.56,0.57576,0.58,0.57576,0.6,0.57576,0.62,0.57576,0.64,0.57576,0.66,0.57576,0.68,0.57576,0.7,0.57576,0.72,0.57576,0.74,0.57576,0.76,0.57576,0.78,0.57576,0.8,0.57576,0.82,0.57576,0.84,0.57576,0.86,0.57576,0.88,0.57576,0.9,0.57576,0.92,0.57576,0.94,0.57576,0.96,0.57576,0.98,0.57576,0.99609,0.57576,0.00391,0.59091,0.02,0.59091,0.04,0.59091,0.06,0.59091,0.08,0.59091,0.1,0.59091,0.12,0.59091,0.14,0.59091,0.16,0.59091,0.18,0.59091,0.2,0.59091};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.22,0.59091,0.24,0.59091,0.26,0.59091,0.28,0.59091,0.3,0.59091,0.32,0.59091,0.34,0.59091,0.36,0.59091,0.38,0.59091,0.4,0.59091,0.42,0.59091,0.44,0.59091,0.46,0.59091,0.48,0.59091,0.5,0.59091,0.52,0.59091,0.54,0.59091,0.56,0.59091,0.58,0.59091,0.6,0.59091,0.62,0.59091,0.64,0.59091,0.66,0.59091,0.68,0.59091,0.7,0.59091,0.72,0.59091,0.74,0.59091,0.76,0.59091,0.78,0.59091,0.8,0.59091,0.82,0.59091,0.84,0.59091,0.86,0.59091,0.88,0.59091,0.9,0.59091,0.92,0.59091,0.94,0.59091,0.96,0.59091,0.98,0.59091,0.99609,0.59091,0.00391,0.60606,0.02,0.60606,0.04,0.60606,0.06,0.60606,0.08,0.60606,0.1,0.60606,0.12,0.60606,0.14,0.60606,0.16,0.60606,0.18,0.60606,0.2,0.60606,0.22,0.60606,0.24,0.60606,0.26,0.60606,0.28,0.60606,0.3,0.60606,0.32,0.60606,0.34,0.60606,0.36,0.60606,0.38,0.60606,0.4,0.60606,0.42,0.60606,0.44,0.60606,0.46,0.60606,0.48,0.60606,0.5,0.60606,0.52,0.60606,0.54,0.60606,0.56,0.60606,0.58,0.60606,0.6,0.60606,0.62,0.60606,0.64,0.60606,0.66,0.60606,0.68,0.60606,0.7,0.60606,0.72,0.60606,0.74,0.60606,0.76,0.60606,0.78,0.60606,0.8,0.60606,0.82,0.60606,0.84,0.60606,0.86,0.60606,0.88,0.60606,0.9,0.60606,0.92,0.60606,0.94,0.60606,0.96,0.60606,0.98,0.60606,0.99609,0.60606,0.00391,0.62121,0.02,0.62121,0.04,0.62121,0.06,0.62121,0.08,0.62121,0.1,0.62121,0.12,0.62121,0.14,0.62121,0.16,0.62121};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.18,0.62121,0.2,0.62121,0.22,0.62121,0.24,0.62121,0.26,0.62121,0.28,0.62121,0.3,0.62121,0.32,0.62121,0.34,0.62121,0.36,0.62121,0.38,0.62121,0.4,0.62121,0.42,0.62121,0.44,0.62121,0.46,0.62121,0.48,0.62121,0.5,0.62121,0.52,0.62121,0.54,0.62121,0.56,0.62121,0.58,0.62121,0.6,0.62121,0.62,0.62121,0.64,0.62121,0.66,0.62121,0.68,0.62121,0.7,0.62121,0.72,0.62121,0.74,0.62121,0.76,0.62121,0.78,0.62121,0.8,0.62121,0.82,0.62121,0.84,0.62121,0.86,0.62121,0.88,0.62121,0.9,0.62121,0.92,0.62121,0.94,0.62121,0.96,0.62121,0.98,0.62121,0.99609,0.62121,0.00391,0.63636,0.02,0.63636,0.04,0.63636,0.06,0.63636,0.08,0.63636,0.1,0.63636,0.12,0.63636,0.14,0.63636,0.16,0.63636,0.18,0.63636,0.2,0.63636,0.22,0.63636,0.24,0.63636,0.26,0.63636,0.28,0.63636,0.3,0.63636,0.32,0.63636,0.34,0.63636,0.36,0.63636,0.38,0.63636,0.4,0.63636,0.42,0.63636,0.44,0.63636,0.46,0.63636,0.48,0.63636,0.5,0.63636,0.52,0.63636,0.54,0.63636,0.56,0.63636,0.58,0.63636,0.6,0.63636,0.62,0.63636,0.64,0.63636,0.66,0.63636,0.68,0.63636,0.7,0.63636,0.72,0.63636,0.74,0.63636,0.76,0.63636,0.78,0.63636,0.8,0.63636,0.82,0.63636,0.84,0.63636,0.86,0.63636,0.88,0.63636,0.9,0.63636,0.92,0.63636,0.94,0.63636,0.96,0.63636,0.98,0.63636,0.99609,0.63636,0.00391,0.65152,0.02,0.65152,0.04,0.65152,0.06,0.65152,0.08,0.65152,0.1,0.65152,0.12,0.65152};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.14,0.65152,0.16,0.65152,0.18,0.65152,0.2,0.65152,0.22,0.65152,0.24,0.65152,0.26,0.65152,0.28,0.65152,0.3,0.65152,0.32,0.65152,0.34,0.65152,0.36,0.65152,0.38,0.65152,0.4,0.65152,0.42,0.65152,0.44,0.65152,0.46,0.65152,0.48,0.65152,0.5,0.65152,0.52,0.65152,0.54,0.65152,0.56,0.65152,0.58,0.65152,0.6,0.65152,0.62,0.65152,0.64,0.65152,0.66,0.65152,0.68,0.65152,0.7,0.65152,0.72,0.65152,0.74,0.65152,0.76,0.65152,0.78,0.65152,0.8,0.65152,0.82,0.65152,0.84,0.65152,0.86,0.65152,0.88,0.65152,0.9,0.65152,0.92,0.65152,0.94,0.65152,0.96,0.65152,0.98,0.65152,0.99609,0.65152,0.00391,0.66667,0.02,0.66667,0.04,0.66667,0.06,0.66667,0.08,0.66667,0.1,0.66667,0.12,0.66667,0.14,0.66667,0.16,0.66667,0.18,0.66667,0.2,0.66667,0.22,0.66667,0.24,0.66667,0.26,0.66667,0.28,0.66667,0.3,0.66667,0.32,0.66667,0.34,0.66667,0.36,0.66667,0.38,0.66667,0.4,0.66667,0.42,0.66667,0.44,0.66667,0.46,0.66667,0.48,0.66667,0.5,0.66667,0.52,0.66667,0.54,0.66667,0.56,0.66667,0.58,0.66667,0.6,0.66667,0.62,0.66667,0.64,0.66667,0.66,0.66667,0.68,0.66667,0.7,0.66667,0.72,0.66667,0.74,0.66667,0.76,0.66667,0.78,0.66667,0.8,0.66667,0.82,0.66667,0.84,0.66667,0.86,0.66667,0.88,0.66667,0.9,0.66667,0.92,0.66667,0.94,0.66667,0.96,0.66667,0.98,0.66667,0.99609,0.66667,0.00391,0.68182,0.02,0.68182,0.04,0.68182,0.06,0.68182,0.08,0.68182};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.1,0.68182,0.12,0.68182,0.14,0.68182,0.16,0.68182,0.18,0.68182,0.2,0.68182,0.22,0.68182,0.24,0.68182,0.26,0.68182,0.28,0.68182,0.3,0.68182,0.32,0.68182,0.34,0.68182,0.36,0.68182,0.38,0.68182,0.4,0.68182,0.42,0.68182,0.44,0.68182,0.46,0.68182,0.48,0.68182,0.5,0.68182,0.52,0.68182,0.54,0.68182,0.56,0.68182,0.58,0.68182,0.6,0.68182,0.62,0.68182,0.64,0.68182,0.66,0.68182,0.68,0.68182,0.7,0.68182,0.72,0.68182,0.74,0.68182,0.76,0.68182,0.78,0.68182,0.8,0.68182,0.82,0.68182,0.84,0.68182,0.86,0.68182,0.88,0.68182,0.9,0.68182,0.92,0.68182,0.94,0.68182,0.96,0.68182,0.98,0.68182,0.99609,0.68182,0.00391,0.69697,0.02,0.69697,0.04,0.69697,0.06,0.69697,0.08,0.69697,0.1,0.69697,0.12,0.69697,0.14,0.69697,0.16,0.69697,0.18,0.69697,0.2,0.69697,0.22,0.69697,0.24,0.69697,0.26,0.69697,0.28,0.69697,0.3,0.69697,0.32,0.69697,0.34,0.69697,0.36,0.69697,0.38,0.69697,0.4,0.69697,0.42,0.69697,0.44,0.69697,0.46,0.69697,0.48,0.69697,0.5,0.69697,0.52,0.69697,0.54,0.69697,0.56,0.69697,0.58,0.69697,0.6,0.69697,0.62,0.69697,0.64,0.69697,0.66,0.69697,0.68,0.69697,0.7,0.69697,0.72,0.69697,0.74,0.69697,0.76,0.69697,0.78,0.69697,0.8,0.69697,0.82,0.69697,0.84,0.69697,0.86,0.69697,0.88,0.69697,0.9,0.69697,0.92,0.69697,0.94,0.69697,0.96,0.69697,0.98,0.69697,0.99609,0.69697,0.00391,0.71212,0.02,0.71212,0.04,0.71212};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.06,0.71212,0.08,0.71212,0.1,0.71212,0.12,0.71212,0.14,0.71212,0.16,0.71212,0.18,0.71212,0.2,0.71212,0.22,0.71212,0.24,0.71212,0.26,0.71212,0.28,0.71212,0.3,0.71212,0.32,0.71212,0.34,0.71212,0.36,0.71212,0.38,0.71212,0.4,0.71212,0.42,0.71212,0.44,0.71212,0.46,0.71212,0.48,0.71212,0.5,0.71212,0.52,0.71212,0.54,0.71212,0.56,0.71212,0.58,0.71212,0.6,0.71212,0.62,0.71212,0.64,0.71212,0.66,0.71212,0.68,0.71212,0.7,0.71212,0.72,0.71212,0.74,0.71212,0.76,0.71212,0.78,0.71212,0.8,0.71212,0.82,0.71212,0.84,0.71212,0.86,0.71212,0.88,0.71212,0.9,0.71212,0.92,0.71212,0.94,0.71212,0.96,0.71212,0.98,0.71212,0.99609,0.71212,0.00391,0.72727,0.02,0.72727,0.04,0.72727,0.06,0.72727,0.08,0.72727,0.1,0.72727,0.12,0.72727,0.14,0.72727,0.16,0.72727,0.18,0.72727,0.2,0.72727,0.22,0.72727,0.24,0.72727,0.26,0.72727,0.28,0.72727,0.3,0.72727,0.32,0.72727,0.34,0.72727,0.36,0.72727,0.38,0.72727,0.4,0.72727,0.42,0.72727,0.44,0.72727,0.46,0.72727,0.48,0.72727,0.5,0.72727,0.52,0.72727,0.54,0.72727,0.56,0.72727,0.58,0.72727,0.6,0.72727,0.62,0.72727,0.64,0.72727,0.66,0.72727,0.68,0.72727,0.7,0.72727,0.72,0.72727,0.74,0.72727,0.76,0.72727,0.78,0.72727,0.8,0.72727,0.82,0.72727,0.84,0.72727,0.86,0.72727,0.88,0.72727,0.9,0.72727,0.92,0.72727,0.94,0.72727,0.96,0.72727,0.98,0.72727,0.99609,0.72727,0.00391,0.74242};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.02,0.74242,0.04,0.74242,0.06,0.74242,0.08,0.74242,0.1,0.74242,0.12,0.74242,0.14,0.74242,0.16,0.74242,0.18,0.74242,0.2,0.74242,0.22,0.74242,0.24,0.74242,0.26,0.74242,0.28,0.74242,0.3,0.74242,0.32,0.74242,0.34,0.74242,0.36,0.74242,0.38,0.74242,0.4,0.74242,0.42,0.74242,0.44,0.74242,0.46,0.74242,0.48,0.74242,0.5,0.74242,0.52,0.74242,0.54,0.74242,0.56,0.74242,0.58,0.74242,0.6,0.74242,0.62,0.74242,0.64,0.74242,0.66,0.74242,0.68,0.74242,0.7,0.74242,0.72,0.74242,0.74,0.74242,0.76,0.74242,0.78,0.74242,0.8,0.74242,0.82,0.74242,0.84,0.74242,0.86,0.74242,0.88,0.74242,0.9,0.74242,0.92,0.74242,0.94,0.74242,0.96,0.74242,0.98,0.74242,0.99609,0.74242,0.00391,0.75758,0.02,0.75758,0.04,0.75758,0.06,0.75758,0.08,0.75758,0.1,0.75758,0.12,0.75758,0.14,0.75758,0.16,0.75758,0.18,0.75758,0.2,0.75758,0.22,0.75758,0.24,0.75758,0.26,0.75758,0.28,0.75758,0.3,0.75758,0.32,0.75758,0.34,0.75758,0.36,0.75758,0.38,0.75758,0.4,0.75758,0.42,0.75758,0.44,0.75758,0.46,0.75758,0.48,0.75758,0.5,0.75758,0.52,0.75758,0.54,0.75758,0.56,0.75758,0.58,0.75758,0.6,0.75758,0.62,0.75758,0.64,0.75758,0.66,0.75758,0.68,0.75758,0.7,0.75758,0.72,0.75758,0.74,0.75758,0.76,0.75758,0.78,0.75758,0.8,0.75758,0.82,0.75758,0.84,0.75758,0.86,0.75758,0.88,0.75758,0.9,0.75758,0.92,0.75758,0.94,0.75758,0.96,0.75758,0.98,0.75758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.99609,0.75758,0.00391,0.77273,0.02,0.77273,0.04,0.77273,0.06,0.77273,0.08,0.77273,0.1,0.77273,0.12,0.77273,0.14,0.77273,0.16,0.77273,0.18,0.77273,0.2,0.77273,0.22,0.77273,0.24,0.77273,0.26,0.77273,0.28,0.77273,0.3,0.77273,0.32,0.77273,0.34,0.77273,0.36,0.77273,0.38,0.77273,0.4,0.77273,0.42,0.77273,0.44,0.77273,0.46,0.77273,0.48,0.77273,0.5,0.77273,0.52,0.77273,0.54,0.77273,0.56,0.77273,0.58,0.77273,0.6,0.77273,0.62,0.77273,0.64,0.77273,0.66,0.77273,0.68,0.77273,0.7,0.77273,0.72,0.77273,0.74,0.77273,0.76,0.77273,0.78,0.77273,0.8,0.77273,0.82,0.77273,0.84,0.77273,0.86,0.77273,0.88,0.77273,0.9,0.77273,0.92,0.77273,0.94,0.77273,0.96,0.77273,0.98,0.77273,0.99609,0.77273,0.00391,0.78788,0.02,0.78788,0.04,0.78788,0.06,0.78788,0.08,0.78788,0.1,0.78788,0.12,0.78788,0.14,0.78788,0.16,0.78788,0.18,0.78788,0.2,0.78788,0.22,0.78788,0.24,0.78788,0.26,0.78788,0.28,0.78788,0.3,0.78788,0.32,0.78788,0.34,0.78788,0.36,0.78788,0.38,0.78788,0.4,0.78788,0.42,0.78788,0.44,0.78788,0.46,0.78788,0.48,0.78788,0.5,0.78788,0.52,0.78788,0.54,0.78788,0.56,0.78788,0.58,0.78788,0.6,0.78788,0.62,0.78788,0.64,0.78788,0.66,0.78788,0.68,0.78788,0.7,0.78788,0.72,0.78788,0.74,0.78788,0.76,0.78788,0.78,0.78788,0.8,0.78788,0.82,0.78788,0.84,0.78788,0.86,0.78788,0.88,0.78788,0.9,0.78788,0.92,0.78788,0.94,0.78788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.96,0.78788,0.98,0.78788,0.99609,0.78788,0.00391,0.80303,0.02,0.80303,0.04,0.80303,0.06,0.80303,0.08,0.80303,0.1,0.80303,0.12,0.80303,0.14,0.80303,0.16,0.80303,0.18,0.80303,0.2,0.80303,0.22,0.80303,0.24,0.80303,0.26,0.80303,0.28,0.80303,0.3,0.80303,0.32,0.80303,0.34,0.80303,0.36,0.80303,0.38,0.80303,0.4,0.80303,0.42,0.80303,0.44,0.80303,0.46,0.80303,0.48,0.80303,0.5,0.80303,0.52,0.80303,0.54,0.80303,0.56,0.80303,0.58,0.80303,0.6,0.80303,0.62,0.80303,0.64,0.80303,0.66,0.80303,0.68,0.80303,0.7,0.80303,0.72,0.80303,0.74,0.80303,0.76,0.80303,0.78,0.80303,0.8,0.80303,0.82,0.80303,0.84,0.80303,0.86,0.80303,0.88,0.80303,0.9,0.80303,0.92,0.80303,0.94,0.80303,0.96,0.80303,0.98,0.80303,0.99609,0.80303,0.00391,0.81818,0.02,0.81818,0.04,0.81818,0.06,0.81818,0.08,0.81818,0.1,0.81818,0.12,0.81818,0.14,0.81818,0.16,0.81818,0.18,0.81818,0.2,0.81818,0.22,0.81818,0.24,0.81818,0.26,0.81818,0.28,0.81818,0.3,0.81818,0.32,0.81818,0.34,0.81818,0.36,0.81818,0.38,0.81818,0.4,0.81818,0.42,0.81818,0.44,0.81818,0.46,0.81818,0.48,0.81818,0.5,0.81818,0.52,0.81818,0.54,0.81818,0.56,0.81818,0.58,0.81818,0.6,0.81818,0.62,0.81818,0.64,0.81818,0.66,0.81818,0.68,0.81818,0.7,0.81818,0.72,0.81818,0.74,0.81818,0.76,0.81818,0.78,0.81818,0.8,0.81818,0.82,0.81818,0.84,0.81818,0.86,0.81818,0.88,0.81818,0.9,0.81818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.92,0.81818,0.94,0.81818,0.96,0.81818,0.98,0.81818,0.99609,0.81818,0.00391,0.83333,0.02,0.83333,0.04,0.83333,0.06,0.83333,0.08,0.83333,0.1,0.83333,0.12,0.83333,0.14,0.83333,0.16,0.83333,0.18,0.83333,0.2,0.83333,0.22,0.83333,0.24,0.83333,0.26,0.83333,0.28,0.83333,0.3,0.83333,0.32,0.83333,0.34,0.83333,0.36,0.83333,0.38,0.83333,0.4,0.83333,0.42,0.83333,0.44,0.83333,0.46,0.83333,0.48,0.83333,0.5,0.83333,0.52,0.83333,0.54,0.83333,0.56,0.83333,0.58,0.83333,0.6,0.83333,0.62,0.83333,0.64,0.83333,0.66,0.83333,0.68,0.83333,0.7,0.83333,0.72,0.83333,0.74,0.83333,0.76,0.83333,0.78,0.83333,0.8,0.83333,0.82,0.83333,0.84,0.83333,0.86,0.83333,0.88,0.83333,0.9,0.83333,0.92,0.83333,0.94,0.83333,0.96,0.83333,0.98,0.83333,0.99609,0.83333,0.00391,0.84848,0.02,0.84848,0.04,0.84848,0.06,0.84848,0.08,0.84848,0.1,0.84848,0.12,0.84848,0.14,0.84848,0.16,0.84848,0.18,0.84848,0.2,0.84848,0.22,0.84848,0.24,0.84848,0.26,0.84848,0.28,0.84848,0.3,0.84848,0.32,0.84848,0.34,0.84848,0.36,0.84848,0.38,0.84848,0.4,0.84848,0.42,0.84848,0.44,0.84848,0.46,0.84848,0.48,0.84848,0.5,0.84848,0.52,0.84848,0.54,0.84848,0.56,0.84848,0.58,0.84848,0.6,0.84848,0.62,0.84848,0.64,0.84848,0.66,0.84848,0.68,0.84848,0.7,0.84848,0.72,0.84848,0.74,0.84848,0.76,0.84848,0.78,0.84848,0.8,0.84848,0.82,0.84848,0.84,0.84848,0.86,0.84848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.88,0.84848,0.9,0.84848,0.92,0.84848,0.94,0.84848,0.96,0.84848,0.98,0.84848,0.99609,0.84848,0.00391,0.86364,0.02,0.86364,0.04,0.86364,0.06,0.86364,0.08,0.86364,0.1,0.86364,0.12,0.86364,0.14,0.86364,0.16,0.86364,0.18,0.86364,0.2,0.86364,0.22,0.86364,0.24,0.86364,0.26,0.86364,0.28,0.86364,0.3,0.86364,0.32,0.86364,0.34,0.86364,0.36,0.86364,0.38,0.86364,0.4,0.86364,0.42,0.86364,0.44,0.86364,0.46,0.86364,0.48,0.86364,0.5,0.86364,0.52,0.86364,0.54,0.86364,0.56,0.86364,0.58,0.86364,0.6,0.86364,0.62,0.86364,0.64,0.86364,0.66,0.86364,0.68,0.86364,0.7,0.86364,0.72,0.86364,0.74,0.86364,0.76,0.86364,0.78,0.86364,0.8,0.86364,0.82,0.86364,0.84,0.86364,0.86,0.86364,0.88,0.86364,0.9,0.86364,0.92,0.86364,0.94,0.86364,0.96,0.86364,0.98,0.86364,0.99609,0.86364,0.00391,0.87879,0.02,0.87879,0.04,0.87879,0.06,0.87879,0.08,0.87879,0.1,0.87879,0.12,0.87879,0.14,0.87879,0.16,0.87879,0.18,0.87879,0.2,0.87879,0.22,0.87879,0.24,0.87879,0.26,0.87879,0.28,0.87879,0.3,0.87879,0.32,0.87879,0.34,0.87879,0.36,0.87879,0.38,0.87879,0.4,0.87879,0.42,0.87879,0.44,0.87879,0.46,0.87879,0.48,0.87879,0.5,0.87879,0.52,0.87879,0.54,0.87879,0.56,0.87879,0.58,0.87879,0.6,0.87879,0.62,0.87879,0.64,0.87879,0.66,0.87879,0.68,0.87879,0.7,0.87879,0.72,0.87879,0.74,0.87879,0.76,0.87879,0.78,0.87879,0.8,0.87879,0.82,0.87879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.84,0.87879,0.86,0.87879,0.88,0.87879,0.9,0.87879,0.92,0.87879,0.94,0.87879,0.96,0.87879,0.98,0.87879,0.99609,0.87879,0.00391,0.89394,0.02,0.89394,0.04,0.89394,0.06,0.89394,0.08,0.89394,0.1,0.89394,0.12,0.89394,0.14,0.89394,0.16,0.89394,0.18,0.89394,0.2,0.89394,0.22,0.89394,0.24,0.89394,0.26,0.89394,0.28,0.89394,0.3,0.89394,0.32,0.89394,0.34,0.89394,0.36,0.89394,0.38,0.89394,0.4,0.89394,0.42,0.89394,0.44,0.89394,0.46,0.89394,0.48,0.89394,0.5,0.89394,0.52,0.89394,0.54,0.89394,0.56,0.89394,0.58,0.89394,0.6,0.89394,0.62,0.89394,0.64,0.89394,0.66,0.89394,0.68,0.89394,0.7,0.89394,0.72,0.89394,0.74,0.89394,0.76,0.89394,0.78,0.89394,0.8,0.89394,0.82,0.89394,0.84,0.89394,0.86,0.89394,0.88,0.89394,0.9,0.89394,0.92,0.89394,0.94,0.89394,0.96,0.89394,0.98,0.89394,0.99609,0.89394,0.00391,0.90909,0.02,0.90909,0.04,0.90909,0.06,0.90909,0.08,0.90909,0.1,0.90909,0.12,0.90909,0.14,0.90909,0.16,0.90909,0.18,0.90909,0.2,0.90909,0.22,0.90909,0.24,0.90909,0.26,0.90909,0.28,0.90909,0.3,0.90909,0.32,0.90909,0.34,0.90909,0.36,0.90909,0.38,0.90909,0.4,0.90909,0.42,0.90909,0.44,0.90909,0.46,0.90909,0.48,0.90909,0.5,0.90909,0.52,0.90909,0.54,0.90909,0.56,0.90909,0.58,0.90909,0.6,0.90909,0.62,0.90909,0.64,0.90909,0.66,0.90909,0.68,0.90909,0.7,0.90909,0.72,0.90909,0.74,0.90909,0.76,0.90909,0.78,0.90909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.8,0.90909,0.82,0.90909,0.84,0.90909,0.86,0.90909,0.88,0.90909,0.9,0.90909,0.92,0.90909,0.94,0.90909,0.96,0.90909,0.98,0.90909,0.99609,0.90909,0.00391,0.92424,0.02,0.92424,0.04,0.92424,0.06,0.92424,0.08,0.92424,0.1,0.92424,0.12,0.92424,0.14,0.92424,0.16,0.92424,0.18,0.92424,0.2,0.92424,0.22,0.92424,0.24,0.92424,0.26,0.92424,0.28,0.92424,0.3,0.92424,0.32,0.92424,0.34,0.92424,0.36,0.92424,0.38,0.92424,0.4,0.92424,0.42,0.92424,0.44,0.92424,0.46,0.92424,0.48,0.92424,0.5,0.92424,0.52,0.92424,0.54,0.92424,0.56,0.92424,0.58,0.92424,0.6,0.92424,0.62,0.92424,0.64,0.92424,0.66,0.92424,0.68,0.92424,0.7,0.92424,0.72,0.92424,0.74,0.92424,0.76,0.92424,0.78,0.92424,0.8,0.92424,0.82,0.92424,0.84,0.92424,0.86,0.92424,0.88,0.92424,0.9,0.92424,0.92,0.92424,0.94,0.92424,0.96,0.92424,0.98,0.92424,0.99609,0.92424,0.00391,0.93939,0.02,0.93939,0.04,0.93939,0.06,0.93939,0.08,0.93939,0.1,0.93939,0.12,0.93939,0.14,0.93939,0.16,0.93939,0.18,0.93939,0.2,0.93939,0.22,0.93939,0.24,0.93939,0.26,0.93939,0.28,0.93939,0.3,0.93939,0.32,0.93939,0.34,0.93939,0.36,0.93939,0.38,0.93939,0.4,0.93939,0.42,0.93939,0.44,0.93939,0.46,0.93939,0.48,0.93939,0.5,0.93939,0.52,0.93939,0.54,0.93939,0.56,0.93939,0.58,0.93939,0.6,0.93939,0.62,0.93939,0.64,0.93939,0.66,0.93939,0.68,0.93939,0.7,0.93939,0.72,0.93939,0.74,0.93939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.76,0.93939,0.78,0.93939,0.8,0.93939,0.82,0.93939,0.84,0.93939,0.86,0.93939,0.88,0.93939,0.9,0.93939,0.92,0.93939,0.94,0.93939,0.96,0.93939,0.98,0.93939,0.99609,0.93939,0.00391,0.95455,0.02,0.95455,0.04,0.95455,0.06,0.95455,0.08,0.95455,0.1,0.95455,0.12,0.95455,0.14,0.95455,0.16,0.95455,0.18,0.95455,0.2,0.95455,0.22,0.95455,0.24,0.95455,0.26,0.95455,0.28,0.95455,0.3,0.95455,0.32,0.95455,0.34,0.95455,0.36,0.95455,0.38,0.95455,0.4,0.95455,0.42,0.95455,0.44,0.95455,0.46,0.95455,0.48,0.95455,0.5,0.95455,0.52,0.95455,0.54,0.95455,0.56,0.95455,0.58,0.95455,0.6,0.95455,0.62,0.95455,0.64,0.95455,0.66,0.95455,0.68,0.95455,0.7,0.95455,0.72,0.95455,0.74,0.95455,0.76,0.95455,0.78,0.95455,0.8,0.95455,0.82,0.95455,0.84,0.95455,0.86,0.95455,0.88,0.95455,0.9,0.95455,0.92,0.95455,0.94,0.95455,0.96,0.95455,0.98,0.95455,0.99609,0.95455,0.00391,0.9697,0.02,0.9697,0.04,0.9697,0.06,0.9697,0.08,0.9697,0.1,0.9697,0.12,0.9697,0.14,0.9697,0.16,0.9697,0.18,0.9697,0.2,0.9697,0.22,0.9697,0.24,0.9697,0.26,0.9697,0.28,0.9697,0.3,0.9697,0.32,0.9697,0.34,0.9697,0.36,0.9697,0.38,0.9697,0.4,0.9697,0.42,0.9697,0.44,0.9697,0.46,0.9697,0.48,0.9697,0.5,0.9697,0.52,0.9697,0.54,0.9697,0.56,0.9697,0.58,0.9697,0.6,0.9697,0.62,0.9697,0.64,0.9697,0.66,0.9697,0.68,0.9697,0.7,0.9697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.72,0.9697,0.74,0.9697,0.76,0.9697,0.78,0.9697,0.8,0.9697,0.82,0.9697,0.84,0.9697,0.86,0.9697,0.88,0.9697,0.9,0.9697,0.92,0.9697,0.94,0.9697,0.96,0.9697,0.98,0.9697,0.99609,0.9697,0.00391,0.98485,0.02,0.98485,0.04,0.98485,0.06,0.98485,0.08,0.98485,0.1,0.98485,0.12,0.98485,0.14,0.98485,0.16,0.98485,0.18,0.98485,0.2,0.98485,0.22,0.98485,0.24,0.98485,0.26,0.98485,0.28,0.98485,0.3,0.98485,0.32,0.98485,0.34,0.98485,0.36,0.98485,0.38,0.98485,0.4,0.98485,0.42,0.98485,0.44,0.98485,0.46,0.98485,0.48,0.98485,0.5,0.98485,0.52,0.98485,0.54,0.98485,0.56,0.98485,0.58,0.98485,0.6,0.98485,0.62,0.98485,0.64,0.98485,0.66,0.98485,0.68,0.98485,0.7,0.98485,0.72,0.98485,0.74,0.98485,0.76,0.98485,0.78,0.98485,0.8,0.98485,0.82,0.98485,0.84,0.98485,0.86,0.98485,0.88,0.98485,0.9,0.98485,0.92,0.98485,0.94,0.98485,0.96,0.98485,0.98,0.98485,0.99609,0.98485,0.00391,0.99609,0.02,0.99609,0.04,0.99609,0.06,0.99609,0.08,0.99609,0.1,0.99609,0.12,0.99609,0.14,0.99609,0.16,0.99609,0.18,0.99609,0.2,0.99609,0.22,0.99609,0.24,0.99609,0.26,0.99609,0.28,0.99609,0.3,0.99609,0.32,0.99609,0.34,0.99609,0.36,0.99609,0.38,0.99609,0.4,0.99609,0.42,0.99609,0.44,0.99609,0.46,0.99609,0.48,0.99609,0.5,0.99609,0.52,0.99609,0.54,0.99609,0.56,0.99609,0.58,0.99609,0.6,0.99609,0.62,0.99609,0.64,0.99609,0.66,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.68,0.99609,0.7,0.99609,0.72,0.99609,0.74,0.99609,0.76,0.99609,0.78,0.99609,0.8,0.99609,0.82,0.99609,0.84,0.99609,0.86,0.99609,0.88,0.99609,0.9,0.99609,0.92,0.99609,0.94,0.99609,0.96,0.99609,0.98,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 3417 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 6834 total numbers made up of 3417 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD027 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD027().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD027\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD027 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD027_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD027_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD027_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD027_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
