####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD026.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD026.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD026.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD026.x3d'),
    GeoLOD(center=(4342525.411173,743014.624947,2137.5),child1Url=["SquawLOD027.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD027.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw013.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw013.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4341718.744506,742430.999947,0),geoSystem=["UTM","Z10","N"],height=[1947.5,1972.6565,2003.5256,2036.9883,2068.8027,2100.0383,2133.2402,2164.3188,2196.749,2215.4136,2232.9463,2247.33,2260.2507,2271.777,2286.2415,2300.8838,2310.3538,2317.0256,2319.3008,2327.0173,2328.8716,2329.0,2328.0,2327.9602,2325.0,1944.325,1973.7365,2007.3275,2037.917,2074.5527,2106.4587,2138.8164,2164.855,2186.6165,2201.8572,2214.4417,2229.6982,2244.4937,2259.3274,2275.2097,2293.9739,2305.5754,2312.3237,2317.2756,2322.289,2326.3691,2328.125,2327.0671,2325.0852,2321.125,1947.0917,1984.1407,2020.7312,2047.6462,2083.636,2113.9768,2140.4512,2158.0942,2167.2546,2172.8274,2180.3005,2195.931,2215.438,2236.5522,2255.8079,2277.592,2297.1323,2306.282,2309.3389,2313.3125,2316.1667,2317.2517,2318.1667,2318.1667,2318.0,1953.1583,1995.5631,2030.9645,2059.8633,2093.1763,2118.5837,2135.0842,2142.186,2143.6455,2145.2083,2153.7454,2173.6394,2189.1604,2210.7322,2236.2798,2257.4255,2281.0676,2294.3237,2298.125,2300.125,2300.1667,2304.2139,2307.0862,2308.0833,2307.125,1958.9,1999.3593,2031.9812,2063.558,2099.173,2114.5168,2114.5098,2113.0,2116.4373,2121.4106,2131.7686,2150.431,2165.9937,2184.5237,2206.6694,2237.5105,2259.1262,2280.3975,2284.8276,2281.8542,2279.0,2284.1855,2291.0662,2291.0,2288.0,1964.6417,2002.1396,2032.3682,2056.3677,2081.7114,2082.15,2084.2395,2092.3164,2098.354,2105.303,2113.6436,2127.306,2147.8408,2164.094,2182.2432,2206.6162,2240.3005,2262.5046,2267.875,2265.9167,2266.0825,2274.047,2274.8723,2270.8333,2266.9583,1970.1083,2004.7365,2028.6558,2037.842,2045.3385,2058.5503,2074.0637,2084.0168,2092.354,2095.951,2103.685,2117.3477,2137.325,2157.8562,2173.7515,2196.092,2229.1204,2252.0642,2255.819,2255.2915,2264.036,2269.0095,2267.856,2264.08,2262.9045,1976.025,2004.6587,2021.8921,2028.391,2041.173,2060.7087,2080.5957,2087.0579,2090.0,2093.3594,2098.0278,2115.431,2136.8687,2153.056,2168.5847,2183.3225,2207.89,2235.0474,2245.0688,2255.039,2262.3486,2269.2178,2273.1921,2270.2053,2263.975,1971.1666,1997.991,2008.6925,2023.279,2040.6298,2062.5837,2081.7944,2085.8333,2088.8015,2093.0,2097.3193,2116.4907,2132.8271,2147.2761,2158.455,2173.7996,2205.8516,2227.9297,2243.85,2255.3367,2264.3853,2276.275,2281.3884,2280.254,2267.307,1961.0834,1979.528,1994.76,2017.9811,2038.3263,2056.758,2073.1758,2079.1438,2084.9656,2096.8274,2104.9768,2121.5662,2129.5935,2137.1294,2147.2097,2178.2224,2212.173,2237.8364,2252.725,2262.7083,2272.6304,2284.6216,2291.3503,2287.1687,2279.1687,1958.475,1972.8353,1987.385,2010.779,2030.1298,2045.8003,2060.2305,2072.3914,2092.327,2104.7634,2114.9028,2123.6077,2124.6672,2125.012,2140.8499,2176.8286,2210.8762,2237.7935,2254.7668,2269.9373,2281.7385,2294.7087,2300.4338,2294.1704,2281.9602,1960.9917,1976.2455,1987.7887,2002.2921,2019.5897,2033.6008,2050.6694,2071.3188,2094.749,2113.2263,2123.9075,2122.3506,2119.3772,2124.2058,2143.6018,2168.5754,2205.8345,2229.6091,2255.8613,2277.1663,2291.8567,2303.8616,2310.451,2297.1724,2281.9563,1965.7667,1977.3712,1985.5962,1998.1395,2015.2964,2030.5503,2049.2878,2069.7004,2094.4778,2120.3872,2132.5386,2120.1897,2118.3313,2128.7842,2146.5564,2162.9255,2194.5767,2221.3933,2253.5964,2285.1106,2301.9846,2312.488,2312.757,2295.5474,2277.2847,1970.475,1978.9978,1985.5962,1996.9781,2012.2548,2028.8732,2046.961,2065.48,2087.6624,2116.6206,2121.3374,2111.3843,2121.0376,2134.6096,2145.5564,2157.5376,2180.517,2209.0674,2244.8647,2290.7288,2308.4827,2311.8145,2301.0928,2286.106,2271.5984,1976.1167,1982.0394,1984.5962,1994.2926,2007.9867,2024.6504,2042.0541,2058.5579,2075.499,2091.7336,2096.8962,2112.3408,2124.8557,2135.7102,2141.4448,2149.5054,2170.4807,2200.795,2237.3062,2284.1226,2317.3853,2309.2124,2293.3845,2280.064,2267.5437,1982.1792,1988.081,1988.9166,1993.2151,2002.4188,2016.6335,2035.5541,2047.2621,2058.7573,2073.1846,2095.0786,2111.5515,2116.9563,2123.1667,2129.489,2143.619,2175.3901,2207.1091,2240.664,2277.7078,2308.1765,2301.3467,2285.8845,2273.004,2261.0437,1987.05,1992.1228,1994.0,1996.7849,2003.0432,2012.3086,2029.7158,2043.3912,2057.8118,2071.4377,2087.6528,2098.679,2102.1626,2109.5667,2129.113,2145.007,2179.5767,2209.593,2242.9473,2269.7288,2289.0,2284.3145,2274.3674,2265.4204,2255.4602,1989.4,1998.706,2000.625,2006.6506,2011.9193,2018.4121,2037.0125,2048.0107,2060.4163,2070.8215,2080.8425,2090.0732,2103.4084,2117.858,2130.2256,2145.007,2175.8406,2204.5432,2234.2363,2257.4163,2271.4297,2269.824,2265.4583,2261.8801,2254.5151,1990.8083,2003.0883,2013.707,2025.4728,2035.6863,2038.5347,2044.8417,2059.3647,2073.604,2074.1667,2083.3518,2095.5076,2112.9084,2133.0808,2145.1907,2152.795,2167.4116,2192.2437,2216.7722,2236.4355,2252.7583,2257.8333,2261.1602,2266.1667,2264.729,1994.6125,2007.8705,2023.4137,2037.4956,2049.7114,2056.198,2061.174,2073.73,2084.211,2079.4106,2087.7778,2103.056,2117.8696,2137.5237,2162.2249,2170.3733,2165.4595,2172.171,2190.2495,2203.2212,2215.9026,2241.179,2260.2402,2272.1191,2278.5852,1998.1,2010.2455,2024.7887,2038.8527,2051.992,2064.7002,2073.4836,2084.0,2082.896,2081.2144,2090.409,2106.3118,2118.9937,2134.5522,2150.316,2157.1677,2157.6667,2159.0,2165.6777,2176.722,2205.1284,2237.5564,2260.265,2272.4128,2278.3025,1995.4791,2005.8289,2021.385,2040.4176,2055.3381,2071.2585,2082.2542,2078.7083,2080.3098,2083.0,2091.1528,2105.1775,2118.1887,2129.99,2140.3503,2143.875,2143.5833,2145.4905,2153.6362,2170.0205,2199.2988,2235.0994,2259.218,2271.0513,2279.0056,1987.4,2002.958,2024.135,2044.1366,2061.3796,2075.817,2084.0,2082.4204,2083.328,2089.7634,2094.8843,2104.7156,2116.161,2124.0332,2129.3196,2131.5017,2137.4753,2142.1987,2146.0168,2161.7288,2190.7454,2230.992,2257.1492,2266.3296,2276.7632,1989.1,2006.491,2027.2607,2045.279,2062.6296,2081.5837,2083.6118,2082.2554,2088.895,2098.2024,2102.3518,2109.3577,2114.3313,2118.2717,2120.2083,2127.1194,2135.4336,2141.1987,2149.1362,2166.5508,2193.7156,2231.5564,2253.3933,2261.248,2262.4062,1990.8,2008.3872,2027.7887,2044.3507,2059.7964,2072.85,2077.5557,2086.85,2096.9062,2100.0,2105.2817,2110.0596,2112.1667,2116.884,2118.232,2121.5034,2132.805,2145.1978,2156.0112,2172.253,2198.382,2232.6338,2250.299,2256.1335,2252.32,1990.5,2009.4132,2027.1925,2039.3357,2048.4614,2059.1584,2073.9805,2084.3333,2094.0547,2097.8215,2104.0,2106.438,2110.8274,2120.5332,2126.0283,2130.0017,2137.4539,2154.545,2178.189,2196.8098,2208.227,2235.5564,2250.0,2251.0852,2245.0984,1988.8583,2007.6057,2021.9554,2035.0562,2049.5012,2064.9407,2078.8547,2092.2632,2100.354,2105.2932,2107.9167,2109.6023,2120.4958,2129.1636,2136.1948,2140.1475,2145.7988,2167.026,2191.6057,2209.354,2221.036,2233.4543,2247.0718,2247.0437,2241.057,1990.6875,2005.4493,2024.3434,2041.6676,2059.5464,2073.9836,2089.4272,2096.8857,2105.3955,2110.9753,2112.9583,2117.331,2125.3035,2134.5679,2143.5032,2150.4097,2160.0908,2169.9521,2192.7307,2211.4373,2222.2385,2230.1895,2243.1714,2245.9602,2238.0146,2004.1,2017.2455,2032.385,2049.279,2067.6296,2084.067,2101.4707,2113.4639,2117.0,2117.5894,2117.0,2119.3577,2128.3313,2138.9143,2148.5564,2157.5034,2170.4504,2183.5962,2195.1724,2208.583,2221.2385,2228.0928,2238.1326,2243.9602,2232.9734,2012.1417,2026.2871,2040.4684,2056.7925,2074.2373,2095.1504,2116.086,2130.0525,2135.521,2126.677,2121.0417,2123.7988,2133.4146,2142.6511,2151.2898,2160.0486,2178.9749,2195.4475,2205.2556,2212.3687,2221.1243,2228.0889,2231.0247,2232.917,2225.9446,2012.775,2030.9202,2048.872,2062.7925,2081.7996,2102.7505,2124.1472,2126.7114,2122.3127,2122.8677,2123.301,2130.3875,2137.7183,2147.3047,2154.3015,2168.0903,2186.759,2202.763,2212.4968,2219.0833,2224.1926,2227.9167,2228.0608,2225.877,2219.8914,2008.375,2032.0359,2050.142,2065.2615,2084.173,2108.4587,2111.821,2108.0361,2106.625,2107.75,2115.5667,2127.6353,2137.7039,2146.0012,2156.9946,2176.2256,2191.6758,2207.4224,2218.1724,2222.0183,2226.11,2225.9885,2224.6257,2219.8352,2216.8618,2000.4667,2023.6138,2044.4554,2061.8062,2073.1296,2085.85,2089.8235,2091.4106,2092.104,2098.7234,2112.1528,2126.0732,2139.325,2153.965,2165.0015,2180.88,2194.4504,2207.5962,2220.1724,2225.0242,2229.0198,2227.8918,2219.9226,2215.9934,2213.9868],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD026.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD026.py load and self-test diagnostics complete.")
