####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD025.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD025.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD025.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD025.x3d'),
    GeoLOD(center=(4340924.904807,743027.217291,2111.000000),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw012.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw012.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,742430.999947,0),geoSystem=["UTM","Z10","N"],height=[1907.6606,1899.8998,1896.7747,1894.3624,1892.9503,1891.0721,1888.8392,1888.0,1888.0,1888.0,1888.577,1891.1558,1895.6931,1900.4718,1905.5125,1913.6187,1924.7792,1933.6287,1944.4442,1959.9055,1978.7999,2006.8088,2025.7302,2037.1603,2049.9128,2065.0764,2084.3875,2099.8755,2113.6428,2126.6594,2138.0588,2147.8403,2158.1807,2163.714,2166.2124,2166.7131,2166.7131,2165.7131,2164.4646,2162.9524,2160.7776,2159.1282,2158.4263,2158.7131,2158.7131,2157.7131,2156.7808,2154.6555,2152.9565,2151.4263,2151.4263,1901.6771,1897.7605,1894.8395,1892.9363,1891.5242,1889.8958,1888.7223,1888.0,1888.0,1888.0553,1890.7843,1894.582,1898.4062,1904.4154,1910.791,1921.5156,1932.1637,1942.0275,1954.2274,1967.5947,1986.7415,2007.9711,2028.0372,2044.9963,2056.5354,2072.355,2093.6428,2110.264,2126.9214,2138.4253,2147.5728,2155.2083,2163.028,2168.5264,2170.0,2169.1394,2168.1394,2167.194,2165.7908,2165.1394,2163.9907,2162.2786,2162.1396,2161.2217,2161.1394,2160.1394,2159.1394,2157.0818,2155.074,2154.1394,2154.1802,1897.169,1894.3344,1891.9222,1890.5101,1889.2883,1888.4344,1888.0,1888.0,1888.0,1890.1873,1894.2919,1897.912,1902.2737,1910.4186,1918.3285,1927.5537,1938.5776,1951.7323,1965.7928,1978.2303,1993.6924,2012.9005,2030.1682,2049.2258,2062.17,2079.059,2100.6152,2117.8376,2136.7346,2146.615,2153.8738,2161.5222,2168.7585,2171.1628,2171.5654,2171.502,2170.269,2168.6292,2167.5654,2166.6694,2166.5654,2165.8003,2165.5654,2164.5654,2163.5654,2162.332,2160.92,2158.5078,2156.796,2156.5654,2157.5654,1892.3165,1890.0157,1889.0083,1888.0833,1888.0,1888.0,1888.0,1888.0,1889.9767,1893.3838,1897.6102,1901.8716,1909.8755,1918.1575,1927.34,1935.5835,1945.6667,1960.1395,1976.7092,1991.546,2004.6106,2020.7097,2041.7421,2060.951,2073.6882,2083.9382,2104.2166,2123.322,2143.8865,2152.5413,2160.1382,2166.911,2170.8748,2172.0,2172.9917,2172.9917,2171.9956,2170.063,2168.9917,2168.9917,2168.9917,2168.9917,2167.9946,2167.5776,2166.9849,2164.9917,2163.3462,2160.999,2159.5176,2159.8662,2160.2832,1888.582,1888.0,1888.0,1888.0,1888.0,1888.0,1888.0,1888.9908,1892.3942,1896.2122,1900.5074,1909.1392,1917.3676,1926.0372,1936.3112,1943.8632,1952.9453,1968.24,1984.5791,1999.3635,2015.7957,2034.2477,2055.4421,2074.742,2087.0713,2093.0664,2106.8923,2125.9397,2144.364,2156.9758,2164.9905,2170.8816,2172.366,2173.7058,2174.418,2174.418,2173.8936,2172.4814,2171.418,2171.418,2171.418,2171.418,2171.418,2170.418,2169.418,2168.1846,2166.5662,2164.8118,2163.6394,2163.418,2163.418,1888.0,1888.0,1888.0,1888.0,1888.0,1888.0,1889.0049,1891.417,1894.8291,1898.2412,1903.955,1914.5736,1922.5886,1932.7603,1944.3632,1953.7201,1966.4744,1978.5349,1991.03,2004.8788,2022.9169,2043.2726,2066.1682,2087.3618,2100.3801,2106.048,2116.8562,2131.551,2145.2437,2160.5813,2170.7478,2173.3079,2174.72,2176.7332,2177.435,2176.844,2176.2456,2174.9077,2174.7898,2174.6882,2174.5425,2173.844,2173.844,2172.844,2171.844,2170.6108,2169.1987,2167.7866,2166.844,2166.7065,2166.844,1888.0,1888.0,1888.0,1888.0,1888.0,1888.2024,1890.5918,1893.998,1897.2554,1900.7748,1907.6384,1918.426,1928.2457,1940.7809,1953.0375,1965.0299,1979.8491,1992.0922,2004.636,2014.6238,2032.1715,2051.2363,2073.8481,2098.2124,2114.3257,2121.3335,2131.8228,2141.392,2151.384,2166.581,2173.322,2175.8594,2178.1797,2179.3481,2179.7595,2179.2703,2178.6174,2178.2703,2178.016,2177.335,2177.2703,2176.5405,2176.2703,2175.2703,2174.2703,2173.0369,2171.6248,2170.2126,2168.2703,2169.152,2170.0254,1888.0,1888.0,1888.0,1888.0,1888.0,1889.4452,1893.6025,1897.1398,1899.6815,1906.2809,1913.5172,1922.7361,1933.5604,1946.6348,1957.8462,1972.8237,1989.7596,2005.647,2018.9073,2029.2202,2042.7131,2059.3916,2077.979,2097.3848,2118.3376,2129.3599,2141.1052,2151.103,2159.999,2169.6995,2174.8357,2179.1602,2181.5723,2182.6965,2182.6965,2181.6965,2181.172,2179.76,2180.393,2180.393,2180.2727,2179.6965,2178.6965,2177.6965,2176.6965,2175.534,2174.5007,2172.679,2172.393,2173.275,2175.5977,1888.0,1888.0,1888.0,1888.0,1889.4592,1892.9633,1897.2834,1900.3912,1905.4459,1913.6083,1921.7959,1928.666,1939.0248,1949.6017,1962.0582,1979.3108,1997.219,2013.4098,2026.9922,2040.0232,2054.0732,2068.7915,2084.8035,2099.9272,2118.294,2132.1992,2146.2117,2157.4836,2167.0222,2173.4016,2179.1807,2182.5864,2183.9985,2185.1228,2185.1228,2184.1228,2183.1812,2182.2454,2183.1228,2183.1228,2183.1228,2182.1228,2181.1257,2180.1228,2179.1448,2178.1228,2177.1663,2177.1228,2177.2454,2179.0046,2180.7974,1888.0,1888.0,1888.0,1888.9244,1892.5862,1896.7085,1900.8862,1906.9143,1913.61,1921.8381,1929.6234,1938.2026,1949.2784,1959.9932,1971.0265,1987.0105,2002.0714,2017.7133,2032.7349,2047.4921,2062.74,2080.0444,2094.8342,2111.6536,2123.639,2136.0527,2149.5645,2162.0725,2172.0037,2177.179,2182.6006,2185.0127,2186.5488,2187.2278,2187.5488,2186.5488,2186.0247,2185.5488,2185.5488,2185.5488,2185.5488,2184.964,2184.099,2182.8733,2181.7278,2180.5488,2179.7437,2179.5488,2180.0186,2182.4307,2184.2305,1888.0,1888.0,1888.4995,1891.8009,1895.6482,1900.4475,1908.7212,1916.0605,1921.8804,1928.9161,1938.1422,1951.5065,1959.4343,1970.1284,1983.1506,1996.2432,2008.3173,2021.4302,2037.6908,2053.5654,2068.556,2087.6655,2105.208,2122.7344,2134.216,2143.8892,2154.1548,2165.0513,2173.6765,2180.8777,2186.0032,2189.4006,2190.829,2190.9502,2190.2676,2188.975,2188.975,2188.037,2187.975,2187.975,2187.975,2187.9607,2186.975,2185.975,2185.1494,2183.9692,2182.3296,2181.975,2182.9028,2185.832,2187.269,1888.0,1888.1002,1890.4259,1894.2501,1899.0743,1905.7972,1915.8837,1923.4082,1930.5543,1939.1937,1948.8423,1958.0006,1968.299,1982.2618,1994.3516,2006.0846,2018.015,2030.2588,2046.3485,2061.7954,2073.299,2092.8066,2109.6838,2127.5686,2140.9492,2151.1733,2160.1738,2169.0635,2177.1746,2183.937,2189.9058,2193.0803,2194.4014,2194.1133,2193.1204,2191.4014,2190.686,2190.4014,2190.5413,2191.4014,2191.4014,2190.8027,2190.4026,2189.6384,2188.4731,2187.5693,2186.5437,2185.8604,2187.2725,2189.3306,2191.0967,1888.0,1889.9277,1892.4282,1896.6764,1901.4425,1909.7788,1919.4706,1928.9465,1939.4226,1950.6576,1960.3417,1968.0231,1979.9869,1991.6649,2002.6075,2014.9619,2025.8923,2039.2213,2055.138,2070.074,2085.6506,2101.252,2116.838,2131.5176,2143.722,2155.7825,2164.3704,2172.2732,2180.5095,2186.7458,2193.8792,2195.3838,2195.9785,2195.8276,2195.1274,2193.7346,2192.8276,2192.8276,2193.2883,2193.8276,2193.8276,2193.8276,2193.8276,2192.8276,2192.655,2191.462,2190.655,2190.665,2191.736,2193.5369,2194.8276,1889.1776,1891.3539,1894.2783,1898.1589,1903.0096,1911.0583,1921.6431,1932.4369,1943.1937,1955.0863,1967.696,1979.343,1990.4078,1997.6674,2009.796,2020.8566,2033.1709,2045.9778,2060.2507,2077.7488,2096.2046,2109.9922,2125.5344,2136.1746,2146.255,2157.2178,2165.764,2174.4458,2182.5125,2188.01,2194.0515,2196.4636,2197.2222,2197.2537,2197.0762,2196.2537,2194.8625,2194.5076,2196.2537,2196.4468,2197.2537,2197.2537,2196.5098,2196.4036,2195.6409,2194.4482,2193.3438,2193.3113,2194.858,2196.4775,2198.2537,1890.3799,1892.7802,1895.7045,1898.9244,1904.0096,1911.246,1921.6431,1933.7277,1943.94,1955.7926,1970.4056,1984.2573,1994.8938,2004.2677,2015.0171,2026.4305,2038.7695,2050.83,2065.8171,2083.8586,2101.692,2114.8672,2131.1294,2141.9736,2150.9617,2159.6501,2167.0803,2175.941,2183.4546,2188.279,2194.0515,2196.4636,2198.5955,2199.68,2199.4558,2199.2837,2198.3599,2198.3599,2198.917,2199.68,2199.7974,2200.68,2200.3608,2200.0818,2199.417,2198.3599,2197.3599,2197.4175,2198.8296,2200.2795,2201.3599,1891.8062,1894.2063,1896.5641,1898.9244,1902.3104,1910.9679,1921.6431,1934.3765,1944.8339,1956.3827,1970.8555,1985.3281,1999.2346,2012.3947,2021.6825,2032.5752,2043.3401,2055.6826,2071.8606,2092.0159,2106.9705,2121.3372,2134.9055,2144.791,2155.5278,2164.079,2170.4216,2178.3867,2184.5608,2189.385,2194.0571,2197.513,2200.1858,2202.1367,2202.2122,2202.1062,2202.1062,2202.1062,2202.1062,2202.892,2203.2788,2204.1062,2204.212,2204.2122,2204.1062,2203.1062,2202.2122,2202.2637,2203.2122,2204.1062,2204.2122,1893.8597,1896.5792,1897.772,1898.9646,1901.1573,1909.3447,1920.2715,1932.9049,1943.94,1956.0618,1971.7539,1985.3281,2001.1381,2016.7845,2028.925,2039.0154,2049.539,2062.2302,2076.6091,2098.4675,2113.6797,2126.2449,2138.9526,2149.5088,2160.269,2168.033,2174.5532,2180.978,2187.1082,2192.0032,2194.6082,2198.4597,2202.284,2204.6855,2205.0647,2205.005,2204.5322,2204.5322,2204.7178,2205.5322,2206.6243,2207.5322,2208.0647,2208.0647,2207.6274,2206.9404,2206.0647,2206.0916,2207.002,2207.5322,2207.5322,1896.6586,1898.9213,1899.9384,1900.8829,1901.6451,1908.9841,1917.8453,1931.4788,1942.9814,1955.3827,1971.6647,1985.3281,2001.4343,2021.1906,2035.2056,2046.391,2059.244,2071.3044,2089.642,2103.5085,2117.4995,2129.3157,2141.7317,2153.7925,2162.695,2170.9312,2177.168,2184.3704,2190.631,2195.583,2197.9707,2200.886,2203.8706,2206.9705,2207.9585,2207.9585,2207.917,2206.9585,2208.8901,2209.917,2210.9243,2211.917,2211.9585,2211.9585,2211.917,2210.917,2210.8904,2209.9194,2209.9585,2209.9585,2209.9585,1898.5154,1901.4464,1902.3848,1903.3383,1905.106,1910.0546,1915.4191,1928.0526,1941.5403,1954.1508,1971.4739,1985.3281,2001.4343,2022.3367,2038.6732,2052.6038,2066.4612,2082.0127,2098.235,2109.7598,2124.1643,2136.1199,2146.2673,2156.539,2166.506,2172.7458,2179.594,2186.8306,2193.8394,2197.0242,2200.0515,2202.8484,2206.213,2208.6726,2211.0847,2211.7695,2212.1543,2213.7058,2214.7695,2215.6223,2216.2605,2216.7695,2216.7695,2215.7695,2215.7695,2215.5361,2214.7695,2214.7473,2214.0957,2213.3848,2212.3848,1899.6433,1902.1002,1904.4154,1905.7496,1907.3365,1910.3557,1913.8038,1925.9728,1939.099,1953.3827,1970.4722,1984.37,2001.4343,2023.3647,2040.6597,2056.605,2070.5027,2087.1743,2103.2388,2117.963,2133.0154,2143.8677,2152.8394,2162.424,2171.3586,2177.595,2182.8313,2190.0676,2196.0383,2199.0898,2201.8625,2204.2747,2207.5862,2211.0989,2213.511,2214.9019,2216.721,2218.5583,2219.6218,2220.4277,2220.6218,2220.7004,2220.6218,2220.6218,2219.6558,2219.6218,2219.0984,2217.811,2217.241,2215.9292,2214.5725,1899.7,1901.7628,1903.2751,1904.7449,1907.1792,1910.7487,1915.041,1926.2029,1937.4108,1953.3827,1969.3284,1984.3281,2002.0677,2022.1731,2040.8547,2057.0889,2073.0405,2091.023,2106.9805,2124.2327,2138.1099,2148.8445,2158.6719,2168.9746,2176.211,2182.4563,2187.8252,2193.1047,2197.692,2201.516,2204.301,2206.8108,2210.0183,2213.5251,2216.1033,2218.5864,2220.3616,2221.4592,2222.7402,2224.0544,2224.278,2224.4744,2224.4744,2224.4744,2224.4744,2224.059,2223.4744,2222.193,2220.7673,2218.5925,2216.943,1898.7,1900.3367,1901.1725,1902.2611,1905.0098,1910.4973,1917.4672,1929.2444,1941.5884,1955.5729,1972.6547,1987.3181,2003.6376,2021.4103,2041.204,2058.045,2074.1606,2091.8584,2110.3003,2125.6282,2140.3154,2153.0393,2164.0999,2173.1636,2181.0632,2187.3027,2193.133,2196.4785,2200.1182,2204.3027,2207.7148,2210.483,2213.2026,2215.9512,2219.1646,2221.7756,2224.0112,2225.5999,2226.444,2227.5828,2228.3267,2228.6633,2229.3247,2229.3267,2229.3267,2228.3267,2227.6812,2226.2886,2224.857,2222.4448,2220.0327,1897.0,1898.0912,1899.4664,1900.8417,1902.9502,1911.246,1918.879,1930.4373,1943.0132,1960.2665,1978.0175,1994.5271,2011.7596,2027.8499,2046.0149,2059.4097,2076.0884,2093.3162,2112.6204,2126.7175,2142.5825,2156.2036,2167.8848,2176.5898,2184.4429,2191.1604,2196.4927,2199.9048,2202.6135,2206.3684,2211.1458,2214.5532,2216.9766,2218.755,2222.579,2226.2913,2227.7034,2229.1733,2230.5276,2231.9397,2232.426,2233.2686,2234.1792,2234.1792,2233.4314,2232.9458,2232.1213,2231.037,2228.6672,2226.2974,2223.7957,1896.7,1897.1002,1898.5123,1900.0,1903.8618,1913.1478,1921.0809,1932.5575,1945.4413,1962.6927,1981.5723,1999.6881,2019.0992,2037.8663,2053.8093,2067.349,2082.689,2100.079,2115.6172,2129.125,2143.1318,2158.7126,2170.0186,2179.016,2187.551,2195.4888,2199.322,2203.2415,2205.7432,2209.3105,2214.594,2218.2185,2220.9072,2224.3193,2227.7317,2230.6016,2232.556,2234.4836,2236.2112,2237.4238,2238.6309,2239.0315,2239.5474,2239.0315,2238.2102,2237.798,2236.2031,2234.9739,2232.5618,2230.1497,2227.0796,1896.0,1897.1002,1898.5123,1900.0,1905.6631,1916.8785,1924.7272,1938.7568,1949.824,1964.7449,1981.485,2000.7709,2020.0677,2045.2335,2065.829,2079.8706,2096.0942,2109.238,2122.463,2135.3872,2146.536,2159.6929,2170.7732,2180.6091,2190.8027,2197.924,2202.7483,2206.7466,2210.1245,2213.5605,2218.0422,2221.8425,2225.6428,2229.1885,2232.6245,2234.996,2237.4082,2239.8203,2241.8462,2242.87,2244.0566,2244.884,2244.884,2244.4749,2243.0627,2242.606,2240.276,2238.8264,2236.4143,2233.1714,2230.313,1895.3318,1897.1002,1899.1886,1900.9244,1907.6316,1919.3628,1930.2312,1943.4435,1956.6464,1970.119,1985.7692,2001.8362,2019.7013,2047.7917,2082.4827,2094.3235,2106.4104,2117.5747,2130.6633,2141.8096,2153.3884,2163.1064,2172.5999,2183.2366,2192.4705,2200.338,2206.1743,2210.9985,2214.6792,2218.0154,2221.8396,2226.6638,2229.612,2232.3123,2236.326,2239.5217,2242.2605,2244.696,2246.8647,2248.5852,2249.2136,2249.7363,2249.7363,2249.7363,2248.7363,2246.6504,2245.0908,2242.3318,2239.8984,2236.8545,2233.3342,1893.7617,1897.1798,1900.3066,1902.4686,1911.1405,1922.3837,1933.7589,1948.026,1961.4988,1974.9714,1991.4049,2004.5652,2019.0677,2044.0964,2076.3262,2092.8079,2107.6152,2120.2273,2132.6152,2146.7976,2159.2961,2167.9587,2178.362,2187.4272,2195.3254,2202.7673,2208.921,2213.4248,2218.2024,2221.942,2225.887,2230.6265,2234.4646,2237.8767,2240.2888,2243.7239,2247.113,2250.5251,2252.4548,2253.5886,2254.5886,2255.383,2255.591,2255.383,2253.7676,2251.4033,2248.9434,2246.5312,2243.7458,2240.7312,2237.0613,1891.4795,1897.2003,1900.6252,1908.1976,1916.7872,1925.4357,1937.0244,1950.6578,1964.1306,1978.9128,1995.6945,2009.3761,2023.3817,2043.8313,2063.4763,2080.7205,2099.8716,2116.1968,2132.6523,2149.812,2161.9421,2171.7356,2181.2393,2191.8877,2200.085,2207.1956,2212.0269,2216.851,2221.8958,2226.0806,2229.4927,2233.73,2238.9722,2242.729,2245.141,2248.6655,2252.4897,2255.584,2259.0872,2261.475,2262.6616,2263.2466,2263.6616,2261.5715,2259.6199,2256.377,2253.6533,2250.3708,2247.3848,2244.3386,2240.6975,1889.9473,1896.6184,1902.8682,1912.9423,1922.6396,1931.0237,1940.0974,1951.7135,1965.5568,1980.3827,1998.1206,2013.2612,2030.1376,2047.9203,2061.0422,2077.442,2094.9736,2112.5525,2131.887,2150.9634,2165.9006,2175.321,2183.3987,2193.6082,2203.3367,2210.6199,2216.0999,2220.924,2225.7483,2230.6997,2234.3452,2238.221,2243.0452,2246.8694,2249.9937,2253.5178,2257.9888,2262.8132,2266.4119,2269.0542,2269.2935,2269.6719,2269.9414,2267.8845,2264.4724,2262.06,2258.0027,2254.1987,2251.177,2247.8413,2244.249,1889.6781,1896.3005,1905.0492,1915.7651,1927.107,1936.1405,1944.789,1956.0104,1969.2588,1984.2335,2000.8835,2017.6792,2035.2137,2051.3042,2064.3499,2080.2505,2100.8293,2120.8384,2134.3127,2153.2896,2169.7285,2179.516,2188.4648,2196.813,2205.8096,2213.046,2219.3552,2224.7764,2229.5276,2234.4248,2239.249,2242.6826,2246.9614,2251.722,2254.919,2258.4434,2263.2676,2268.0918,2271.8906,2274.2014,2275.146,2275.146,2275.146,2273.3577,2270.3376,2267.6792,2263.5264,2259.0308,2255.1677,2251.3738,2248.5066,1889.0505,1896.3005,1905.5615,1917.6221,1929.8453,1940.1188,1949.2225,1961.648,1978.4,1994.4746,2008.9473,2023.5461,2040.249,2055.2263,2069.2024,2089.8252,2111.1746,2130.8135,2145.5808,2158.3486,2173.0815,2185.3684,2194.1394,2201.6653,2209.735,2216.9714,2224.7068,2230.2205,2233.8386,2239.2773,2245.1016,2249.4248,2252.812,2257.0735,2262.0479,2265.6096,2269.2844,2273.9028,2278.0205,2279.8784,2280.4976,2280.4976,2280.9968,2279.589,2275.767,2271.765,2268.0308,2263.883,2259.2942,2256.1165,2252.4104,1888.7,1896.3005,1905.525,1918.5465,1931.2966,1942.6686,1953.6545,1967.4657,1984.7468,2003.5264,2019.3804,2036.8223,2050.8416,2062.9004,2079.061,2100.7708,2120.0317,2138.9634,2152.3816,2164.4421,2178.2942,2190.221,2198.8877,2206.351,2214.1978,2222.7407,2231.6125,2235.666,2239.3054,2243.1296,2249.9539,2255.2073,2260.4624,2264.0854,2268.951,2273.0667,2277.265,2279.7236,2283.1992,2284.8328,2285.8508,2286.7761,2286.779,2284.9885,2280.9683,2276.384,2271.608,2267.7356,2263.4207,2259.1528,2256.3374,1888.1539,1896.4359,1907.2292,1919.8981,1932.0342,1944.0948,1955.1554,1969.3617,1989.2316,2007.3889,2026.3008,2043.2526,2059.504,2072.4355,2091.5554,2108.2278,2123.508,2140.8584,2156.303,2169.2947,2181.9585,2194.3792,2201.8809,2210.3115,2219.0188,2229.0156,2235.9126,2242.2139,2246.0105,2249.9822,2254.876,2262.4458,2267.8064,2271.4438,2275.4548,2279.8882,2283.2275,2284.6619,2288.0518,2289.9705,2290.876,2292.5571,2293.3516,2291.0288,2286.0608,2280.1543,2275.0605,2270.2566,2266.412,2261.898,2258.5154,1887.4667,1896.5009,1909.3392,1923.102,1936.7543,1946.7166,1958.2958,1971.788,1991.8917,2009.0887,2028.2941,2046.7217,2062.945,2078.1526,2095.9817,2112.0256,2126.2502,2143.176,2160.11,2172.851,2183.7063,2195.37,2205.6287,2214.4077,2223.871,2232.7578,2239.8975,2246.3672,2251.9597,2256.6123,2261.7505,2268.8435,2274.9883,2279.6213,2282.0334,2285.4705,2288.45,2290.492,2291.9814,2294.5557,2295.594,2295.7778,2295.78,2294.3687,2290.2744,2283.9075,2278.4868,2273.618,2268.8384,2264.2102,2260.19,1886.7,1896.5214,1911.79,1928.8788,1942.754,1953.304,1964.6526,1977.7972,1993.306,2010.2999,2029.5128,2047.9297,2064.1672,2080.3647,2097.7463,2113.219,2128.4595,2147.0,2161.8193,2174.0732,2184.652,2196.0552,2208.3765,2218.871,2228.5195,2236.3809,2244.4133,2250.8538,2257.8625,2262.8909,2267.715,2273.9084,2280.1597,2284.6958,2287.8691,2290.6094,2293.9324,2296.3445,2297.7566,2299.1687,2300.408,2300.408,2300.2046,2296.7114,2292.5615,2286.504,2280.7815,2275.0889,2270.1565,2265.4404,2260.412,1887.5891,1897.5009,1914.7285,1933.6836,1947.8186,1962.0126,1975.4854,1989.2272,2000.4607,2013.2904,2030.925,2047.9103,2065.431,2082.5676,2097.7463,2113.219,2129.2556,2147.8584,2163.0942,2174.0732,2184.652,2196.3977,2210.4941,2221.2974,2230.9458,2240.2278,2248.4697,2255.706,2263.5725,2269.5393,2274.0127,2278.3594,2284.9338,2289.8362,2292.9604,2295.3726,2298.6086,2301.7869,2303.2603,2304.1719,2305.2603,2305.2603,2303.2634,2299.6606,2293.9878,2288.0164,2281.9324,2275.8848,2271.0605,2266.2363,2261.412,1888.4395,1899.6631,1918.1548,1938.3761,1955.1509,1970.4238,1985.1428,2000.09,2011.3322,2027.687,2043.2394,2060.9316,2075.4136,2086.5984,2099.9202,2114.194,2130.3684,2149.6824,2164.5376,2174.7043,2185.8135,2198.168,2211.8296,2223.733,2234.4045,2244.0767,2252.7024,2260.5586,2268.795,2275.4277,2281.1672,2285.0967,2289.038,2293.6724,2296.8127,2300.2249,2302.64,2307.1548,2310.1887,2310.1692,2310.1594,2309.5044,2307.0593,2302.238,2296.3677,2289.3,2282.729,2276.8271,2271.0605,2266.2363,2262.3723,1890.4379,1902.284,1920.8163,1942.2484,1961.6411,1977.457,1993.5731,2009.6442,2026.3152,2042.0725,2059.9507,2075.6265,2087.558,2100.1016,2109.7104,2122.3376,2136.7498,2157.148,2170.9238,2181.771,2195.065,2206.3005,2216.949,2228.1147,2238.7632,2247.9382,2256.383,2265.226,2274.2476,2282.0576,2287.576,2292.1514,2294.841,2298.2532,2301.5205,2305.1548,2309.4963,2315.257,2318.4478,2317.5632,2315.3645,2313.3804,2309.487,2304.4668,2297.5364,2290.3,2283.0635,2276.8271,2270.834,2266.1182,2262.554,1892.4362,1905.7102,1923.9604,1948.8262,1965.2645,1982.0581,2001.7605,2019.7389,2035.5452,2054.0178,2073.0916,2086.9634,2100.3782,2112.772,2123.9587,2132.1262,2147.1726,2165.557,2179.2476,2191.7449,2204.287,2215.0964,2225.6538,2235.3933,2244.5159,2252.7898,2261.3933,2270.0042,2280.4292,2288.6448,2294.7827,2297.7026,2300.6821,2303.1055,2307.1265,2313.9717,2318.1594,2324.359,2327.6353,2326.8745,2322.3965,2317.6477,2311.9177,2306.1445,2298.6987,2290.9966,2283.0635,2276.8271,2270.0605,2265.2363,2263.9087,1895.401,1909.3376,1927.2806,1950.2948,1967.9146,1986.575,2007.8492,2026.8721,2044.9,2062.0488,2080.814,2096.4072,2110.7195,2123.5222,2133.3242,2146.311,2158.456,2171.4753,2185.201,2198.1,2210.322,2221.8198,2231.6885,2240.3372,2249.9856,2257.978,2267.2825,2277.2659,2286.9143,2295.163,2301.0566,2304.289,2306.546,2309.5808,2315.1052,2321.2292,2325.5293,2330.2078,2332.67,2331.0686,2326.8167,2319.3845,2313.009,2306.7727,2298.715,2290.5332,2283.4182,2276.8848,2270.2383,2266.4136,2265.67,1898.4895,1912.4624,1931.274,1950.4708,1970.117,1990.0688,2011.4084,2032.1055,2050.4175,2068.0017,2087.851,2103.6646,2120.5667,2132.5007,2144.3333,2155.425,2168.0684,2178.0598,2189.0786,2203.0266,2215.1912,2225.9744,2236.541,2245.1895,2253.3972,2262.4885,2272.538,2282.7834,2293.3774,2301.441,2307.3474,2310.339,2313.1594,2315.3174,2322.1555,2328.4226,2331.0466,2332.6975,2335.0,2332.4788,2328.243,2319.6604,2313.006,2306.182,2297.9539,2290.3557,2284.0635,2278.646,2274.0671,2271.2837,2270.2837,1902.8748,1917.9758,1936.2643,1955.0189,1972.7305,1991.9723,2012.6343,2034.9163,2053.925,2070.3643,2091.4705,2108.9243,2126.9277,2141.969,2152.8508,2165.0742,2176.69,2186.3384,2195.9868,2206.9663,2219.0269,2231.339,2243.3813,2251.0625,2258.2988,2267.153,2276.8755,2287.601,2298.8838,2308.2932,2313.6138,2316.8384,2319.2507,2322.0842,2326.5874,2331.112,2333.7117,2335.0,2334.2766,2332.052,2328.1538,2319.0579,2311.8215,2304.7727,2296.715,2289.7207,2285.542,2281.083,2279.3748,2278.3748,2277.43,1908.0408,1922.9899,1942.3256,1961.5933,1978.8695,1997.0813,2014.8997,2037.7695,2057.1038,2074.0178,2095.124,2113.2988,2131.2927,2146.824,2158.7253,2171.2988,2183.0774,2193.617,2203.8792,2215.046,2226.493,2240.0283,2251.3225,2258.663,2264.9985,2271.8137,2280.4734,2292.3035,2304.5034,2314.7593,2318.6968,2321.691,2325.103,2327.5151,2329.3137,2331.7258,2334.5244,2335.0,2331.4375,2328.6257,2325.5073,2316.4058,2310.3943,2305.0237,2298.15,2291.147,2288.3643,2285.5337,2283.7576,2282.686,2282.2273,1913.2795,1928.9208,1948.178,1966.5127,1987.8649,2005.6411,2022.4851,2043.2924,2062.9602,2080.6536,2102.8086,2121.934,2133.247,2147.2678,2159.7463,2173.2588,2187.4607,2199.5776,2211.7522,2222.655,2232.8013,2244.7524,2256.0186,2263.5466,2270.8394,2278.0923,2287.732,2299.1956,2311.4653,2318.2932,2322.143,2325.9885,2328.9155,2330.3162,2331.0278,2332.0044,2334.5244,2335.0,2331.317,2328.2488,2322.6545,2316.2454,2310.009,2304.7727,2299.3574,2293.8064,2292.3801,2289.9822,2287.5889,2287.0796,2287.0679,1918.4583,1936.0992,1954.269,1975.2466,1995.2699,2014.8702,2034.0752,2051.675,2067.834,2085.4102,2109.304,2126.1418,2138.5654,2150.16,2161.931,2176.0903,2191.9583,2204.773,2217.4133,2227.539,2237.1877,2247.019,2257.1328,2265.667,2275.2476,2284.896,2294.7324,2305.279,2315.4546,2319.7449,2324.1033,2328.4636,2330.4082,2331.466,2332.0,2332.112,2333.5244,2334.534,2332.4653,2329.3508,2323.4817,2316.2454,2309.5415,2303.9065,2300.1787,2296.2327,2294.466,2292.4353,2291.466,2290.995,2290.932,1923.6844,1942.3855,1961.2872,1980.1797,2000.4767,2022.1631,2041.1437,2059.6868,2074.4805,2093.0557,2115.7896,2131.915,2143.9517,2155.0073,2167.073,2180.0034,2196.302,2208.3625,2220.317,2229.9653,2238.7217,2248.37,2258.0186,2266.816,2277.832,2288.7405,2298.5046,2308.338,2316.4546,2320.279,2325.1033,2328.4636,2329.9836,2331.108,2331.108,2331.2078,2332.108,2333.108,2332.6514,2329.4788,2323.3276,2315.353,2308.1167,2302.6545,2300.0193,2297.7666,2296.3164,2295.7844,2295.3652,2294.892,2294.5222,1930.2368,1947.4382,1966.9044,1985.9565,2004.7994,2024.8179,2043.6045,2064.1926,2082.8699,2103.3552,2120.407,2134.8855,2146.2842,2158.228,2170.4612,2181.4792,2196.1812,2209.4702,2221.4248,2231.2266,2239.744,2248.5793,2258.0186,2267.4019,2278.8945,2289.964,2299.4841,2308.1272,2316.3823,2320.0754,2323.7847,2327.1453,2328.597,2329.0,2329.6816,2329.6816,2329.6816,2330.3633,2330.1257,2328.084,2321.1633,2313.927,2306.011,2302.0396,2301.497,2300.3184,2299.3184,2299.3184,2298.9983,2298.6367,2298.3184,1935.3892,1952.2906,1968.9492,1988.3197,2005.6923,2024.9891,2043.7023,2063.4119,2081.4019,2099.1582,2113.3232,2127.9688,2142.6606,2156.0164,2168.6824,2179.8599,2193.4124,2209.2424,2221.5308,2232.1963,2239.7913,2249.0276,2258.0186,2266.8337,2278.15,2289.217,2297.868,2306.308,2314.7102,2318.8027,2321.32,2324.719,2326.131,2327.2554,2328.0,2328.2554,2328.2554,2328.2554,2327.7405,2324.7341,2318.737,2312.8303,2307.496,2305.4893,2304.535,2302.7446,2302.7446,2302.7446,2302.7446,2302.4893,2302.2703,1939.3708,1955.6011,1969.9862,1984.9713,2001.5642,2020.0975,2037.4421,2055.558,2071.224,2086.6995,2099.5337,2115.499,2130.3965,2143.9084,2159.9849,2174.8145,2189.3982,2207.3816,2221.4248,2231.4727,2239.7793,2248.37,2257.8896,2266.4963,2276.7954,2286.7932,2296.0386,2303.275,2310.6997,2316.407,2319.0427,2321.293,2323.705,2324.8784,2325.829,2326.829,2326.9187,2327.0,2327.0,2324.4788,2317.998,2315.586,2313.1738,2309.9326,2307.5205,2306.3416,2306.3416,2307.171,2306.7812,2306.3416,2306.3416,1941.2,1955.6011,1968.2556,1981.5013,1997.4221,2013.9452,2030.4635,2045.8403,2064.895,2083.0168,2101.4988,2115.2703,2129.7395,2142.8337,2155.9744,2169.349,2185.0872,2203.7727,2219.9338,2230.7637,2239.1663,2248.1655,2256.568,2265.5674,2274.7185,2283.77,2293.0154,2299.8486,2306.9492,2313.4668,2317.4338,2318.8667,2320.9258,2322.691,2324.2822,2325.0452,2325.716,2326.0,2325.403,2324.2393,2320.4243,2318.0122,2316.6,2313.4321,2311.7039,2311.0547,2310.597,2310.597,2310.597,2311.1235,2311.3696,1940.5,1953.557,1967.5382,1982.3738,1997.0038,2013.2173,2030.1254,2045.4373,2067.8958,2088.415,2106.1245,2123.8855,2135.1672,2147.229,2160.7695,2174.3926,2188.4626,2203.8887,2219.4248,2230.0732,2238.7896,2247.362,2256.0186,2264.481,2272.7134,2280.9497,2289.5798,2296.4226,2303.6357,2309.2324,2314.0566,2317.4404,2318.8757,2320.9834,2321.9768,2324.1096,2325.0,2325.0,2324.6597,2323.2393,2321.8313,2320.0232,2318.0261,2316.614,2314.221,2315.0232,2315.0232,2314.0464,2314.0342,2314.9077,2316.0232,1939.1854,1950.1066,1964.1749,1979.572,1995.2716,2009.706,2027.6202,2044.9879,2068.928,2088.524,2105.6763,2120.1873,2133.1038,2147.2734,2162.4097,2177.219,2192.8184,2206.9197,2218.5308,2229.0732,2237.7913,2245.9207,2255.0186,2263.1257,2271.287,2278.5237,2286.76,2293.63,2300.1304,2305.6675,2310.6306,2315.2227,2317.8757,2319.1584,2320.8652,2322.6628,2323.7861,2325.0,2325.0,2323.5813,2322.4495,2321.8645,2320.4524,2318.715,2317.4495,2318.0,2317.4495,2317.4495,2317.4495,2317.4495,2317.4495,1937.6244,1948.6252,1962.01,1975.737,1991.8992,2006.8676,2023.2897,2040.3833,2057.6375,2078.0479,2094.0273,2112.7014,2128.9253,2145.398,2160.8535,2176.349,2192.3447,2208.4702,2218.438,2229.0732,2236.907,2244.452,2253.358,2261.6248,2269.2297,2276.0974,2283.3337,2290.57,2296.6074,2302.4033,2307.2275,2312.0518,2316.0002,2318.036,2319.7373,2321.2227,2323.5244,2325.0,2325.0,2324.9053,2324.1514,2324.2908,2322.8787,2321.8757,2320.8757,2320.5469,2319.3105,2318.8757,2318.8757,2318.8757,2318.8757,1937.5,1948.6011,1963.888,1977.9238,1992.2959,2007.045,2022.729,2038.6138,2054.4883,2073.454,2091.4204,2109.402,2125.3884,2141.67,2157.2217,2174.008,2190.455,2207.6838,2217.155,2227.7712,2235.4895,2242.829,2251.7168,2259.1985,2266.4348,2273.6711,2280.9075,2287.273,2293.3115,2298.8684,2303.8013,2308.4856,2313.148,2316.57,2317.9094,2319.8103,2323.3806,2325.6538,2327.0,2327.3018,2327.3018,2326.427,2326.3018,2325.3018,2324.3018,2323.0684,2321.3018,2321.3018,2321.1602,2320.3018,2320.2131,1938.2,1950.402,1966.8018,1981.2745,1997.5668,2011.7444,2029.3094,2047.7565,2065.9912,2081.1897,2093.3984,2108.8445,2121.9731,2138.5,2153.4758,2170.6328,2187.0046,2205.2136,2215.6968,2225.3452,2233.082,2241.2996,2249.2905,2256.7722,2263.5872,2270.2449,2277.7534,2284.1243,2290.164,2295.551,2300.3752,2305.1995,2309.0574,2313.5598,2315.972,2318.4658,2321.667,2324.9365,2326.3486,2328.0,2328.728,2328.728,2328.728,2327.728,2325.9067,2324.9365,2323.8245,2323.728,2322.8723,2322.728,2321.728,1938.5,1952.7167,1969.228,1983.5581,2001.071,2016.5103,2036.9095,2058.6846,2080.6143,2097.7568,2105.5144,2118.998,2129.9385,2142.6907,2154.8218,2169.5474,2183.9736,2202.137,2213.2705,2222.3264,2230.637,2238.772,2246.1096,2254.346,2260.5825,2266.8188,2273.9631,2281.1372,2286.4927,2292.1248,2296.949,2301.7017,2305.5974,2310.4216,2314.4001,2318.112,2321.37,2323.9365,2326.3486,2328.0,2329.1729,2330.0,2329.003,2328.091,2327.3054,2326.0,2325.0547,2325.0,2324.6028,2324.0,2323.109,1939.5,1952.8014,1970.3711,1989.434,2008.9698,2022.5623,2043.349,2064.8386,2087.9895,2110.2126,2121.6814,2130.7876,2141.436,2153.684,2164.1526,2176.0903,2186.407,2198.505,2210.8442,2219.7725,2228.2107,2236.4473,2243.2456,2250.92,2257.8203,2263.4016,2270.0486,2277.285,2283.4258,2289.1182,2294.5227,2299.1523,2302.8037,2308.1626,2314.4001,2318.112,2320.8286,2323.9365,2326.3486,2328.0,2329.0725,2330.0,2329.5818,2328.8284,2328.0,2327.0,2326.2058,2325.9758,2325.0,2325.0,2324.0,1939.8,1952.8956,1971.5895,1996.9423,2018.3756,2038.039,2051.3284,2069.03,2092.8633,2119.5952,2135.4397,2143.9119,2154.8257,2163.2085,2172.3152,2183.4993,2192.1458,2201.7896,2211.4314,2219.5615,2227.7913,2234.0276,2240.5093,2248.4949,2255.73,2261.973,2266.8062,2274.2556,2279.6755,2286.27,2292.0964,2297.391,2301.7517,2307.8638,2315.0955,2318.112,2321.0002,2323.9365,2326.3552,2328.0051,2329.0012,2330.004,2332.0037,2331.6003,2329.1921,2328.0,2327.0024,2326.9424,2326.0,2325.0,2325.0,1938.9373,1952.0017,1972.1532,1995.6602,2021.7018,2048.8105,2067.9248,2080.6462,2096.7585,2123.175,2136.7214,2149.3281,2161.808,2171.048,2181.364,2190.7778,2198.8335,2206.9478,2214.7515,2221.4695,2227.8213,2234.4604,2240.836,2247.933,2254.7366,2261.973,2267.239,2273.4458,2278.2273,2284.7139,2291.1255,2297.391,2302.7517,2308.172,2314.0972,2318.112,2321.0486,2324.9004,2327.6306,2329.0,2329.1729,2331.3494,2333.9954,2335.0,2332.4348,2328.0,2327.634,2327.0,2326.0,2325.0671,2325.0,1937.2,1952.7748,1971.146,1992.3744,2018.8903,2050.7324,2075.1453,2092.5667,2104.6409,2119.5237,2131.633,2147.0889,2159.5386,2172.3232,2183.365,2195.4502,2204.4626,2210.204,2217.1775,2222.9688,2229.6504,2236.3218,2243.982,2251.2183,2257.0168,2262.973,2268.8062,2273.6045,2278.4546,2286.417,2293.1475,2298.8518,2304.6106,2309.4348,2314.3015,2318.112,2321.4573,2324.9365,2328.3486,2329.0,2329.1729,2330.7258,2333.9944,2335.0,2332.3828,2328.0,2328.0,2326.9504,2326.0,2325.1016,2325.0,1939.7705,1954.1582,1971.5051,1989.4169,2015.6155,2049.7324,2075.2075,2093.5615,2108.0435,2116.018,2126.2449,2139.6938,2153.3115,2167.1,2180.0452,2194.3633,2205.8457,2211.3882,2218.3186,2224.0366,2229.8608,2237.5576,2245.264,2253.5002,2259.1577,2263.982,2268.8062,2273.863,2278.7468,2287.843,2295.118,2301.0596,2306.0369,2311.1492,2315.6853,2318.112,2321.3887,2324.9365,2327.8142,2328.0,2328.7148,2329.2996,2330.4275,2331.4294,2329.0212,2328.0,2327.2534,2326.9424,2326.0,2325.0,2325.0,1943.496,1958.0239,1974.6445,1990.4491,2015.1355,2047.7397,2065.9844,2081.988,2096.3528,2109.6282,2120.0476,2132.969,2147.033,2159.1392,2173.2864,2186.4658,2201.2754,2210.1704,2218.243,2223.6938,2229.8608,2238.0276,2246.193,2253.5002,2259.1577,2263.982,2269.634,2274.6304,2279.6821,2289.2693,2296.1033,2301.7727,2307.4631,2313.2874,2316.7,2318.8237,2320.5244,2324.2065,2326.1006,2327.2195,2327.2886,2328.0,2328.0,2328.0,2328.0,2327.2212,2326.5408,2326.0,2325.5303,2325.0,2325.0,1945.3376,1960.6149,1976.1409,1991.3436,2014.5232,2033.0603,2049.4592,2070.1782,2086.6326,2101.5728,2113.7979,2125.9456,2140.4382,2152.9526,2165.9385,2178.9363,2192.9968,2205.4587,2215.1956,2224.0732,2231.7913,2239.0276,2246.264,2253.5002,2259.7947,2265.1196,2269.9438,2274.9275,2280.7134,2289.6074,2296.2925,2302.9912,2308.6445,2313.962,2317.7,2319.112,2320.5244,2322.8076,2324.3005,2325.0,2325.8623,2325.9429,2326.0,2326.4905,2326.8623,2326.0,2326.0,2326.0,2325.595,2325.0,2325.0,1946.5,1961.6011,1975.9977,1988.4614,2005.0007,2022.2545,2041.2285,2061.7053,2080.2034,2094.031,2107.1638,2119.2969,2134.673,2147.562,2160.161,2173.1646,2186.564,2201.428,2214.5308,2224.3655,2232.8306,2240.0276,2247.264,2254.9702,2260.974,2266.5408,2271.37,2276.1943,2282.2458,2289.9185,2297.1548,2304.189,2308.7517,2314.576,2317.7,2319.0488,2320.5244,2321.9365,2323.3486,2324.3318,2325.0,2325.0,2325.997,2327.0,2326.6418,2326.564,2326.0,2326.0,2326.0,2325.6155,2325.0,1947.5,1961.5018,1974.5615,1985.6228,2001.0387,2020.9891,2036.306,2055.603,2072.9248,2088.0054,2100.0742,2114.129,2128.8208,2143.3381,2158.2886,2171.349,2185.6917,2200.8584,2214.5308,2224.56,2232.7913,2240.0276,2247.264,2255.3335,2261.1577,2267.973,2271.8062,2276.6304,2282.9072,2290.9148,2298.1453,2304.9275,2308.7517,2313.586,2317.007,2318.121,2320.0,2321.0,2323.0034,2324.7607,2325.0,2326.575,2326.99,2327.99,2328.0,2327.99,2327.0,2326.9995,2326.0,2326.0,2325.0,1947.5,1960.5009,1972.8605,1985.5906,2001.3557,2019.5729,2034.9646,2050.1777,2067.4875,2081.9666,2096.1023,2109.7708,2126.1672,2144.7163,2159.2886,2171.349,2187.507,2202.2917,2213.0085,2222.657,2231.7622,2238.754,2245.9497,2254.084,2259.7415,2267.1353,2270.39,2276.0295,2282.2659,2290.1416,2296.76,2303.704,2308.3354,2312.1597,2316.2837,2317.6304,2319.1082,2320.5466,2323.0774,2325.3167,2327.072,2327.4163,2328.0,2328.0,2328.0,2328.0,2328.0,2327.9424,2326.7258,2325.633,2325.0,1947.5,1959.5009,1971.993,1985.5465,2001.9147,2018.7775,2034.1254,2048.4373,2064.895,2080.3828,2095.6978,2110.6133,2127.6433,2146.2664,2159.7454,2171.349,2189.2556,2201.8855,2210.5823,2219.3882,2229.026,2235.3428,2242.579,2249.8154,2256.473,2262.288,2267.1213,2272.9165,2278.997,2287.7153,2295.2688,2301.5486,2306.7712,2310.4456,2313.8577,2317.0176,2318.0825,2319.1475,2322.4033,2326.4014,2328.0,2328.4927,2328.8425,2329.0,2328.8706,2328.6458,2328.0,2328.0,2326.6042,2325.1182,2324.706],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD025.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD025.py load and self-test diagnostics complete.")
