####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD024.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD024.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD024.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD024.x3d'),
    GeoLOD(center=(4340937.286173,743014.624947,2111.5),child1Url=["SquawLOD025.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD025.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw012.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw012.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4340105.411173,742430.999947,0),geoSystem=["UTM","Z10","N"],height=[1904.2451,1895.7653,1892.007,1888.4303,1888.0,1890.4994,1898.9546,1911.3566,1933.2499,1956.4022,1997.8104,2038.7194,2063.6096,2102.0706,2132.0137,2150.9548,2166.1904,2167.9827,2165.997,2163.837,2160.9653,2159.9827,2158.9827,2154.9436,2152.9827,1894.4042,1890.0718,1888.0521,1888.0,1889.4912,1897.4395,1909.3145,1926.6746,1949.4673,1979.7412,2009.8536,2049.2104,2077.1797,2117.3179,2148.9944,2164.3604,2171.9597,2171.9897,2169.7756,2167.948,2167.8958,2165.943,2163.833,2158.9082,2158.8965,1888.0,1888.0,1888.0,1888.5203,1894.4564,1904.8934,1923.2971,1945.0441,1966.7902,1996.2909,2032.1979,2075.7546,2099.839,2124.8992,2157.2803,2172.165,2175.1384,2175.913,2173.913,2172.913,2172.913,2171.8206,2168.913,2165.913,2164.9253,1888.0,1888.0,1888.0,1893.018,1899.965,1913.824,1936.2083,1961.483,1994.0842,2020.2747,2048.6628,2090.1072,2125.7104,2146.4282,2167.1821,2178.0393,2181.7844,2180.8784,2179.0,2178.8784,2178.7593,2176.7856,2174.6987,2170.8735,2172.7703,1888.0,1888.0,1891.9431,1900.2572,1913.161,1929.5175,1949.336,1973.23,2008.7483,2038.9957,2070.5452,2102.0808,2131.3955,2158.2112,2175.244,2184.0955,2186.19,2185.8438,2184.8438,2184.8438,2183.8438,2181.8438,2179.7878,2178.8499,2181.857,1888.0,1890.1266,1898.8877,1916.2185,1929.8658,1949.4019,1970.6874,1997.4525,2021.8596,2053.033,2083.6921,2121.3132,2147.4841,2165.8953,2182.2278,2191.8699,2193.5837,2190.809,2189.809,2190.6182,2189.809,2188.543,2185.809,2185.4346,2189.6206,1888.9323,1894.105,1903.5631,1923.1819,1945.4906,1969.3899,1991.7937,2013.5083,2037.9464,2068.6492,2102.6284,2131.1116,2154.174,2172.6885,2186.8347,2196.1948,2196.9492,2195.7295,2193.9465,2196.1128,2196.7744,2195.5486,2193.708,2193.5576,2196.7847,1891.7,1896.6228,1903.4901,1923.279,1946.5109,1975.1005,2003.4258,2024.6771,2048.2493,2080.6582,2114.364,2141.1707,2161.473,2175.8792,2188.5564,2197.057,2201.7395,2201.6877,2201.4792,2202.517,2203.5103,2203.4792,2202.4128,2202.4792,2203.7395,1896.4049,1899.5935,1901.8406,1920.1439,1945.4681,1976.1005,2007.4318,2039.5916,2064.0056,2097.531,2124.331,2149.4937,2168.5012,2182.529,2194.77,2200.2083,2206.7712,2207.7048,2206.8262,2209.5554,2211.4448,2211.6775,2210.4097,2209.7048,2209.7048,1899.6011,1904.4174,1907.5962,1915.8488,1942.5894,1975.4304,2007.922,2046.4526,2077.5867,2110.4749,2139.1348,2158.7712,2175.334,2188.2546,2198.2266,2203.9219,2210.8955,2214.8032,2218.3972,2220.3403,2220.3403,2220.278,2219.3403,2217.657,2215.657,1898.7,1901.227,1905.5571,1919.4841,1944.3517,1977.0067,2009.8813,2048.0771,2082.8555,2118.2498,2148.4165,2170.4746,2185.5083,2195.9402,2203.9136,2210.3625,2215.8606,2221.8342,2225.7449,2227.728,2228.6355,2229.2708,2228.2708,2225.6208,2221.6174,1896.7,1898.6228,1904.9857,1922.6522,1948.1,1986.6173,2026.4178,2060.0,2091.726,2123.0198,2152.6897,2176.0317,2193.5945,2202.628,2208.7578,2218.0037,2224.4268,2230.8813,2234.8708,2237.8604,2239.273,2239.2014,2237.1616,2234.1616,2228.5874,1895.134,1899.3524,1909.372,1932.7372,1960.3915,1991.0227,2027.9025,2087.7856,2112.1284,2137.4414,2160.0173,2180.563,2198.1812,2210.1755,2217.6885,2226.6355,2232.5825,2239.8772,2245.3042,2249.1318,2250.1318,2250.0393,2246.537,2242.0696,2235.5469,1891.1687,1900.9536,1918.4475,1939.38,1967.7908,2000.6317,2030.5157,2070.1213,2106.467,2143.0935,2168.5996,2188.32,2205.8804,2216.1409,2226.3408,2233.684,2243.2878,2249.46,2256.9382,2262.6711,2264.5938,2261.9697,2255.9963,2249.4915,2243.0422,1889.551,1905.491,1928.5813,1947.2721,1974.746,2006.8502,2042.4248,2071.7722,2112.9182,2146.6575,2176.84,2195.0664,2211.4902,2224.6025,2234.5496,2243.7412,2252.4436,2259.887,2269.7485,2275.563,2275.9932,2273.3967,2266.8936,2257.9336,2250.9731,1888.5614,1906.288,1932.6604,1956.3105,1990.2697,2026.4645,2057.534,2091.98,2130.657,2159.9773,2186.845,2204.5352,2221.2485,2236.3691,2243.942,2256.1406,2265.6106,2274.783,2281.1885,2286.0693,2288.5046,2284.781,2275.3599,2266.3823,2258.4485,1887.1011,1910.3798,1939.6663,1960.8068,1996.2299,2033.8379,2068.1592,2103.4443,2134.352,2167.8916,2190.9211,2212.653,2232.231,2246.1667,2257.5295,2269.6094,2281.0793,2287.053,2291.9277,2296.0,2297.2986,2294.2947,2282.2947,2271.3875,2262.4082,1887.9746,1916.3744,1951.3923,1980.9879,2006.465,2038.0623,2071.723,2104.4565,2138.7188,2169.0537,2191.1628,2218.8232,2239.1096,2256.0913,2270.4504,2279.6807,2291.1467,2296.9834,2303.8523,2306.2656,2306.2732,2299.114,2286.234,2273.9204,2263.9734,1891.1576,1922.7169,1965.1484,1999.0612,2033.1777,2070.5784,2097.2395,2120.5967,2150.7722,2179.8628,2205.572,2227.0913,2247.47,2264.8252,2283.3713,2293.967,2299.9404,2308.5415,2318.4175,2320.285,2314.1619,2303.0793,2287.8013,2273.9062,2263.9868,1896.349,1930.1288,1970.4967,2013.2039,2051.4485,2089.0693,2120.075,2143.2473,2168.3367,2193.6995,2219.1829,2239.5117,2258.3167,2277.8647,2296.8035,2306.3909,2312.0964,2324.3662,2331.495,2331.7085,2317.723,2304.7217,2288.8013,2275.2166,2267.323,1904.9899,1940.5583,1977.0939,2017.2517,2057.6794,2098.422,2135.5178,2161.0288,2184.6135,2204.626,2229.7192,2252.041,2266.57,2287.1,2309.6992,2318.8281,2324.8018,2331.1987,2334.9504,2330.3198,2316.1003,2302.7217,2288.8865,2281.5764,2279.5764,1915.7069,1951.7424,1994.8732,2031.8253,2069.172,2112.2551,2139.9583,2166.036,2195.693,2221.15,2241.3308,2262.1638,2279.5847,2300.207,2318.3489,2327.5051,2331.0,2332.1987,2334.8276,2327.962,2314.7312,2302.8145,2294.1873,2290.2239,2289.2534,1927.4906,1965.7968,2005.2075,2046.1129,2084.221,2124.6968,2149.67,2174.5376,2202.6235,2226.1826,2245.1528,2264.1516,2286.5437,2306.9143,2319.5564,2328.033,2329.7812,2330.1553,2331.7812,2328.344,2313.3303,2301.0203,2299.1526,2297.4375,2296.4375,1938.1393,1970.7365,2004.88,2043.9011,2079.4395,2109.0916,2140.5276,2169.7534,2199.13,2227.5347,2245.1528,2263.431,2285.4114,2302.7302,2317.0942,2322.8838,2325.816,2327.816,2327.816,2324.4055,2313.2488,2307.351,2304.3682,2305.3682,2304.3682,1941.0955,1968.4347,1998.5775,2032.9883,2070.807,2111.2832,2138.1836,2164.6865,2193.3594,2225.555,2244.0608,2261.9773,2279.2756,2296.6157,2309.6438,2317.8882,2321.1917,2324.1987,2325.0,2323.7268,2319.03,2315.0566,2313.2986,2313.1494,2314.1514,1938.3854,1962.185,1995.013,2027.8826,2067.1394,2100.477,2135.261,2168.721,2201.0608,2224.5754,2242.038,2259.39,2274.8792,2289.7996,2302.442,2312.389,2318.1995,2321.9082,2325.0,2324.1145,2323.1145,2321.0217,2319.1145,2318.1145,2318.1145,1938.2,1966.8164,1998.2859,2030.2278,2065.3618,2096.3015,2128.842,2161.593,2197.3833,2221.5632,2238.457,2254.9934,2268.9138,2283.81,2295.4766,2305.4236,2314.1455,2319.1348,2325.1584,2328.0117,2328.0798,2326.987,2324.0745,2323.0767,2321.9878,1939.5,1970.7646,2007.2252,2045.8329,2091.9795,2120.8765,2142.2087,2166.9421,2190.814,2216.2056,2233.492,2248.999,2262.6174,2276.824,2289.4663,2299.218,2308.4155,2318.1987,2324.1724,2328.1458,2330.0,2328.041,2326.9368,2325.0435,2324.0444,1939.4865,1973.3489,2024.5587,2067.4856,2104.1526,2140.5732,2164.9817,2183.8862,2201.7756,2218.2427,2231.163,2245.0837,2259.9937,2271.9143,2283.1206,2296.7554,2307.6838,2318.1987,2325.1724,2329.0,2332.0012,2334.9082,2328.0,2326.9602,2325.0,1939.1514,1971.7365,2019.3816,2079.1277,2110.6187,2130.1282,2159.0144,2186.818,2208.8745,2221.797,2234.1528,2251.0576,2262.6462,2272.6096,2286.1062,2300.4792,2310.6702,2318.1987,2325.3445,2328.1665,2330.0059,2331.9316,2328.0,2326.0,2325.0,1945.1823,1976.7142,2017.4128,2053.3005,2091.0068,2117.7607,2145.6284,2171.9321,2199.8337,2219.6777,2236.0938,2251.0732,2263.643,2274.2637,2288.113,2302.4592,2313.6624,2319.1987,2323.1724,2325.1963,2326.059,2327.0,2326.0552,2326.0,2325.0,1947.5,1975.1138,2003.46,2039.7455,2077.084,2104.285,2134.129,2163.7825,2192.6235,2220.643,2237.1528,2253.0732,2265.9937,2275.6096,2289.767,2304.5034,2313.5442,2318.274,2321.1724,2325.0,2326.9062,2327.915,2327.8462,2326.87,2325.8943,1947.5,1972.6565,2003.5256,2036.9883,2068.8027,2100.0383,2133.2402,2164.3188,2196.749,2215.4136,2232.9463,2247.33,2260.2507,2271.777,2286.2415,2300.8838,2310.3538,2317.0256,2319.3008,2327.0173,2328.8716,2329.0,2328.0,2327.9602,2325.0],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD024.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD024.py load and self-test diagnostics complete.")
