package Basic.Geospatial;

import org.web3d.x3d.jsail.Core.*;
import org.web3d.x3d.jsail.fields.*;
import org.web3d.x3d.jsail.Geospatial.*;
import org.web3d.x3d.jsail.Shape.*;
import org.web3d.x3d.jsail.Texturing.*;

// Javadoc metadata annotations follow, see below for X3DJSAIL Java source code.
/**
 * <p> ESRI GeoVRML export subscene of Squaw Valley California USA. </p>
 <p> Related links: Catalog page <a href="../../../Geospatial/SquawLOD023Index.html" target="_blank">SquawLOD023</a>,  source <a href="../../../Geospatial/SquawLOD023.java">SquawLOD023.java</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dResources.html" target="_blank">X3D Resources</a>, <a href="https://www.web3d.org/x3d/content/examples/X3dSceneAuthoringHints.html" target="_blank">X3D Scene Authoring Hints</a>, and <a href="https://www.web3d.org/x3d/content/X3dTooltips.html" target="_blank">X3D Tooltips</a>. </p>
	<table style="color:black; border:0px solid; border-spacing:10px 0px;">
        <caption>Scene Meta Information</caption>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center; padding:10px 0px;"><i>meta tags</i></td>
			<td style="text-align:left;   padding:10px 0px;">&nbsp; Document Metadata </td>
		</tr>

		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> title </i> </td>
			<td> <a href="../../../Geospatial/SquawLOD023.x3d">SquawLOD023.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> description </i> </td>
			<td> ESRI GeoVRML export subscene of Squaw Valley California USA. </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> creator </i> </td>
			<td> Salvador Bayarri, ESRI </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translator </i> </td>
			<td> Don Brutzman </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> translated </i> </td>
			<td> 22 April 2003 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> modified </i> </td>
			<td> 20 January 2020 </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> reference </i> </td>
			<td> <a href="http://www.geovrml.org/examples" target="_blank">http://www.geovrml.org/examples</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> subject </i> </td>
			<td> X3D geospatial example </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> identifier </i> </td>
			<td> <a href="https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD023.x3d" target="_blank">https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD023.x3d</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> Vrml97ToX3dNist, <a href="http://ovrt.nist.gov/v2_x3d.html" target="_blank">http://ovrt.nist.gov/v2_x3d.html</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> generator </i> </td>
			<td> X3D-Edit 3.3, <a href="https://savage.nps.edu/X3D-Edit" target="_blank">https://savage.nps.edu/X3D-Edit</a> </td>
		</tr>
		<tr>
			<td style="text-align:right; vertical-align: text-top;"> <i> license </i> </td>
			<td> <a href="../../../Geospatial/../license.html">../license.html</a> </td>
		</tr>
		<tr style="background-color:silver; border-color:silver;">
			<td style="text-align:center;" colspan="2">  &nbsp; </td>
		</tr>
	</table>

	<p>
		This program uses the
		<a href="https://www.web3d.org/specifications/java/X3DJSAIL.html" target="_blank">X3D Java Scene Access Interface Library (X3DJSAIL)</a>.
		It has been produced using the 
		<a href="https://www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">X3dToJava.xslt</a>
		stylesheet
	       (<a href="https://sourceforge.net/p/x3d/code/HEAD/tree/www.web3d.org/x3d/stylesheets/X3dToJava.xslt" target="_blank">version control</a>)
                which is used to create Java source code from an original <code>.x3d</code> model.
	</p>

	* @author Salvador Bayarri, ESRI
 */

public class SquawLOD023
{
	/** Default constructor to create this object. */
	public SquawLOD023 ()
	{
	  initialize();
	}

	/** Create and initialize the X3D model for this object. */
	public final void initialize()
	{
            try { // catch-all
  x3dModel = new X3D().setProfile(X3D.PROFILE_IMMERSIVE).setVersion(X3D.VERSION_3_3)
  .setHead(new head()
    .addComponent(new component().setName("Geospatial").setLevel(1))
    .addMeta(new meta().setName(meta.NAME_TITLE      ).setContent("SquawLOD023.x3d"))
    .addMeta(new meta().setName(meta.NAME_DESCRIPTION).setContent("ESRI GeoVRML export subscene of Squaw Valley California USA."))
    .addMeta(new meta().setName(meta.NAME_CREATOR    ).setContent("Salvador Bayarri, ESRI"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATOR ).setContent("Don Brutzman"))
    .addMeta(new meta().setName(meta.NAME_TRANSLATED ).setContent("22 April 2003"))
    .addMeta(new meta().setName(meta.NAME_MODIFIED   ).setContent("20 January 2020"))
    .addMeta(new meta().setName(meta.NAME_REFERENCE  ).setContent("http://www.geovrml.org/examples"))
    .addMeta(new meta().setName(meta.NAME_SUBJECT    ).setContent("X3D geospatial example"))
    .addMeta(new meta().setName(meta.NAME_IDENTIFIER ).setContent("https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD023.x3d"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html"))
    .addMeta(new meta().setName(meta.NAME_GENERATOR  ).setContent("X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit"))
    .addMeta(new meta().setName(meta.NAME_LICENSE    ).setContent("../license.html")))
  .setScene(new Scene()
    .addChild(new WorldInfo().setTitle("SquawLOD023.x3d"))
    .addChild(new GeoLOD().setCenter(4344125.917539,741821.999947,1970.5).setGeoSystem(new String[] {"UTM","Z10","N"}).setRange(0.0)
      .setGeoOrigin(new GeoOrigin("ORIGIN").setGeoCoords(4342525.5,740604.0,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setRotateYUp(true))
      .addRootNode(new Shape()
        .setAppearance(new Appearance()
          .setMaterial(new Material().setAmbientIntensity(0.9).setDiffuseColor(1.0,1.0,1.0).setShininess(1.0))
          .setTexture(new ImageTexture().setUrl(new String[] {"images/squaw011.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw011.jpg"})))
        .setGeometry(new GeoElevationGrid().setCcw(false).setCreaseAngle(0.5).setGeoGridOrigin(4343332.077840,741212.999947,0.0).setGeoSystem(new String[] {"UTM","Z10","N"}).setSolid(false).setXDimension(51).setXSpacing(24.360000).setZDimension(67).setZSpacing(24.444444).setHeight(getGeoElevationGrid_5_20_height())
          .setGeoOrigin(new GeoOrigin().setUSE("ORIGIN"))
          .setTexCoord(new TextureCoordinate().setPoint(getTextureCoordinate_6_21_point()))))));
            }
            catch (Exception ex)
            {       
                System.err.println ("*** Further hints on X3DJSAIL errors and exceptions at");
                System.err.println ("*** https://www.web3d.org/specifications/java/X3DJSAIL.html");
                throw (ex);
            }
	}
	// end of initialize() method

		/** Define subarrays using type double[] */
		private double[] getGeoElevationGrid_5_20_height_1()
		{
			double[] value = {1878.1666,1877.72,1877.1666,1877.0,1876.1666,1876.0,1876.0,1876.0,1875.0,1874.0293,1873.74,1872.2533,1870.7013,1869.8334,1868.834,1869.0,1869.0,1869.26,1869.0,1869.0,1869.0,1869.0,1869.0,1869.0,1868.0,1868.0,1867.0,1866.328,1865.892,1865.0,1864.02,1861.168,1858.148,1854.712,1852.276,1851.0,1851.4967,1857.096,1864.404,1871.712,1882.0967,1895.88,1912.4033,1926.78,1940.3373,1952.9933,1963.6573,1973.2346,1982.0073,1990.7227,2000.4667,1879.6254,1879.5837,1878.6787,1878.4623,1877.2078,1876.9667,1876.2826,1876.0,1876.0,1875.5837,1874.3237,1871.8877,1869.8546,1867.8483,1867.4163,1867.4163,1867.4163,1868.1299,1868.8529,1869.0,1869.0,1869.0,1869.0,1869.0,1868.0,1868.0,1867.0,1866.328,1866.0,1865.0,1864.02,1861.4109,1858.148,1855.4156,1852.276,1851.0,1851.0,1856.1094,1864.404,1871.712,1882.38,1896.88,1911.6882,1923.4246,1937.8712,1950.4325,1960.6565,1969.4005,1977.9003};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_2()
		{
			double[] value = {1985.3048,1994.8737,1881.01,1881.0066,1880.01,1880.0,1879.01,1878.01,1877.4891,1877.01,1877.0,1876.0017,1876.0,1874.304,1871.5953,1866.432,1865.0,1865.4357,1866.0,1867.0,1867.99,1868.0,1868.6139,1868.9906,1869.0,1869.0,1868.636,1868.0,1867.0076,1867.0,1866.0,1865.0,1864.0298,1861.584,1858.1494,1855.712,1852.2787,1851.0,1851.0,1854.0764,1863.394,1871.6061,1881.03,1894.8601,1908.2521,1919.5721,1931.5573,1945.5602,1954.8378,1962.5343,1971.254,1976.7549,1987.4701,1882.4926,1882.4362,1882.0995,1881.4362,1880.6368,1880.4012,1879.4362,1879.4362,1878.4362,1877.4362,1876.4362,1875.6075,1872.6616,1867.6204,1865.0,1865.0,1865.4939,1866.0,1866.8901,1867.0,1867.3496,1868.0,1868.7784,1869.0,1868.636,1868.0,1867.764,1867.0,1866.0,1865.456,1865.0,1861.584,1858.6676,1855.712,1852.552,1851.0,1851.0,1852.5182,1861.404,1869.234,1878.4034,1889.6692,1902.7516,1914.6111,1923.075,1935.4192,1945.6432};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_3()
		{
			double[] value = {1953.8676,1960.7086,1970.1837,1980.6277,1884.0,1883.8623,1883.8623,1883.8623,1882.8623,1882.7823,1881.8623,1880.8623,1879.9465,1879.8623,1878.6023,1877.1664,1874.5984,1870.0989,1865.0,1865.0,1865.0,1865.4067,1866.0,1866.1377,1867.0,1867.1859,1868.0,1868.0,1868.05,1868.0,1867.9675,1867.0,1866.0,1865.456,1865.0,1862.584,1859.148,1856.326,1853.1764,1851.0,1851.0,1854.9308,1860.936,1868.616,1875.1576,1885.0485,1892.7935,1903.3694,1914.875,1924.4269,1936.0614,1947.7057,1957.4496,1966.2949,1975.0753,1886.0288,1886.0,1886.2228,1886.2886,1885.2886,1885.2317,1884.2886,1883.3024,1882.2886,1881.2886,1880.2135,1879.0878,1877.1566,1873.2772,1866.5708,1865.0,1865.0,1865.0,1865.0,1865.7114,1866.0,1866.7277,1867.7114,1867.9792,1868.0,1868.0,1868.0,1867.0,1866.2574,1866.0,1865.0,1862.7526,1859.5419,1856.712,1853.3556,1851.0,1851.0,1854.096,1861.404,1869.0006,1877.7467,1888.4572,1900.0787,1908.0348,1914.6108};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_4()
		{
			double[] value = {1923.1371,1932.7927,1942.6714,1952.8573,1961.6913,1971.2155,1887.7147,1887.7147,1887.7147,1887.7147,1887.7147,1887.7147,1886.7147,1885.7628,1884.6041,1882.8907,1881.5289,1880.2173,1878.868,1875.702,1869.7068,1865.4003,1864.7501,1865.0,1865.0,1865.0,1865.0,1866.016,1866.637,1867.0,1868.0,1868.0,1868.0,1867.0,1866.892,1866.0,1865.0143,1864.0015,1860.296,1856.712,1853.552,1851.2396,1851.0,1853.096,1861.7385,1871.2621,1881.0747,1893.9254,1908.9923,1918.5514,1926.7418,1930.6138,1934.6456,1943.563,1953.7416,1962.2969,1972.0144,1889.282,1890.282,1890.282,1891.141,1890.282,1890.141,1889.141,1888.141,1887.0863,1885.317,1883.1044,1881.304,1879.868,1876.4929,1871.992,1867.261,1865.0,1864.0,1864.6426,1865.0,1865.0,1865.0,1866.0,1866.7972,1867.0,1868.0,1867.764,1867.0,1867.0,1866.0,1865.02,1864.584,1861.148,1856.424,1853.174,1851.0,1851.0,1852.096,1861.872,1871.6024,1882.408,1896.3174,1914.8779};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_5()
		{
			double[] value = {1925.522,1935.7708,1943.8181,1945.8458,1948.2926,1959.5629,1969.6199,1977.5228,1895.1343,1895.1343,1895.1343,1895.0164,1893.9232,1893.4872,1892.0511,1890.5944,1889.1792,1887.0999,1885.1597,1882.304,1879.868,1876.864,1872.992,1868.3695,1865.124,1864.0,1863.3237,1864.0796,1865.0,1865.0,1865.492,1866.0,1866.6393,1867.0,1867.0,1867.0,1867.0,1866.0,1865.5758,1865.0,1861.296,1856.0201,1852.276,1851.0,1851.338,1854.6311,1861.1385,1869.9529,1882.7,1897.984,1916.0511,1930.3743,1943.6383,1953.9492,1957.7859,1959.9646,1966.9391,1977.076,1984.9717,1900.9801,1900.9801,1899.9867,1898.992,1897.9891,1896.9067,1894.4774,1893.0414,1890.612,1889.1693,1886.4751,1883.2994,1879.868,1876.864,1873.9854,1869.5571,1865.2472,1864.0,1863.9934,1863.184,1864.62,1865.0,1865.0,1865.0066,1866.0024,1866.8013,1867.0,1867.9978,1866.8927,1866.0,1866.0,1865.0,1861.443,1855.424,1851.276,1851.0,1852.188,1857.0574,1861.4645,1868.52,1882.7};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_6()
		{
			double[] value = {1898.984,1917.6893,1933.2334,1948.4907,1960.06,1967.8414,1972.7483,1976.6228,1984.0361,1991.0887,1905.8391,1904.6981,1903.9714,1902.7518,1901.569,1899.3396,1897.2031,1895.0681,1892.8688,1890.176,1886.74,1883.9,1880.868,1877.6133,1874.414,1871.3046,1867.6156,1865.2887,1864.4196,1864.0,1863.1594,1864.6039,1865.0,1865.0,1865.0,1865.5804,1867.236,1868.0,1867.0453,1867.0,1866.0,1865.0,1862.296,1855.136,1851.1602,1851.0,1853.192,1858.5156,1864.0468,1872.0355,1883.04,1900.5336,1919.2386,1935.3076,1953.8396,1966.3787,1978.8594,1985.8818,1989.3455,1992.3618,1995.9587,1910.7915,1909.3556,1907.7267,1905.8458,1904.2018,1901.7657,1899.3297,1896.8938,1894.4578,1891.049,1887.74,1885.1967,1881.8477,1878.7974,1875.8418,1873.4058,1870.0938,1867.7976,1866.059,1864.9717,1863.9044,1862.1628,1863.6487,1863.2974,1865.0,1865.0,1866.3903,1868.5684,1868.0,1867.0,1866.0,1865.584,1862.3188,1855.136,1851.0,1851.0,1853.696,1860.9418,1868.1677};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_7()
		{
			double[] value = {1875.4847,1884.5458,1901.8297,1922.2083,1938.3817,1957.2666,1974.0972,1991.7362,2000.4667,2002.2023,2003.2695,2003.4911,1915.6439,1913.1166,1910.5,1908.4874,1906.6279,1904.192,1901.6156,1898.32,1895.496,1892.2239,1888.74,1886.304,1883.14,1880.704,1877.5388,1874.832,1872.396,1870.96,1868.5239,1866.088,1864.38,1862.6465,1860.508,1859.4756,1861.456,1863.2561,1865.1719,1868.1613,1868.9214,1868.124,1867.0,1865.584,1861.444,1854.424,1851.0,1851.0,1854.0599,1862.1047,1872.8839,1883.4319,1891.0844,1908.0369,1925.028,1942.7279,1961.8828,1980.704,2003.4199,2013.3146,2014.3599,2014.2881,2012.388,1921.2247,1917.5239,1913.6244,1911.4902,1909.7523,1907.3164,1904.0265,1900.0815,1897.3102,1894.0502,1890.2566,1887.304,1885.5662,1883.1301,1880.6942,1877.6492,1874.8221,1872.4803,1870.9502,1868.5142,1865.2653,1864.3573,1861.7142,1856.7919,1856.8578,1858.5433,1862.7738,1867.344,1869.9674,1868.456,1866.3158,1865.1763,1860.444,1853.6389,1851.0,1851.3834,1858.1843};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_8()
		{
			double[] value = {1865.2769,1878.4346,1890.6145,1903.4927,1914.9745,1928.3302,1946.2341,1966.127,1987.4395,2011.2756,2022.1522,2025.9225,2024.713,2021.604,1926.5607,1922.0371,1919.4768,1915.2637,1913.2931,1911.1687,1908.2168,1902.5111,1899.7363,1897.3004,1893.6367,1889.5906,1888.0088,1886.5564,1884.2448,1881.2991,1877.4967,1874.8124,1872.3763,1870.7563,1868.4572,1866.1244,1865.0632,1860.5278,1853.6698,1854.5513,1858.6659,1865.0952,1867.9836,1868.5237,1866.02,1864.1162,1858.1716,1852.3354,1851.0,1854.7644,1864.7069,1879.3488,1886.8936,1898.9215,1913.2397,1925.3088,1935.4331,1951.8654,1973.0452,1995.0881,2015.9717,2030.5979,2035.3517,2034.7535,2030.0975,1934.3473,1929.5303,1926.0052,1923.4437,1921.0077,1917.5358,1913.8517,1909.7477,1904.4263,1900.374,1897.8412,1895.4052,1892.9691,1890.5332,1889.095,1885.6611,1882.2252,1877.6174,1874.8026,1872.4492,1870.5505,1868.5198,1867.0586,1864.6226,1855.9954,1851.0,1853.2408,1858.6923,1865.0663,1867.9934,1866.009,1861.3884,1854.8119,1851.0,1851.3986};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_9()
		{
			double[] value = {1858.1906,1870.2732,1885.8118,1897.8352,1909.1814,1924.7819,1934.3063,1945.8129,1959.7739,1981.8365,2003.1466,2024.2162,2037.101,2040.9292,2041.3877,2038.0865,1943.0304,1940.2351,1937.1119,1934.6527,1931.5876,1927.7472,1922.8751,1919.0021,1914.5101,1910.236,1905.37,1901.2344,1898.8215,1896.3856,1893.9495,1891.0605,1886.2045,1882.3296,1877.475,1874.7927,1872.3712,1869.944,1868.4847,1866.072,1863.466,1851.9861,1851.0055,1851.734,1857.4143,1864.145,1863.0664,1857.2145,1852.1549,1851.0,1854.132,1862.2772,1875.1256,1892.1855,1908.2471,1919.4061,1933.6224,1944.7692,1958.1327,1977.0201,1995.5115,2014.016,2030.5793,2042.1205,2047.5903,2048.6663,2045.5304,1953.1149,1950.5436,1947.84,1945.4039,1942.9679,1940.532,1937.1909,1932.3005,1926.8885,1922.367,1918.4949,1913.6229,1909.1539,1903.8789,1900.205,1896.329,1891.1039,1885.5928,1880.0085,1876.219,1873.783,1871.944,1869.508,1867.475,1865.7827,1861.3344,1851.0,1851.0,1852.0645,1854.3351,1855.783,1853.5297,1851.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_10()
		{
			double[] value = {1851.1161,1858.5907,1869.0089,1881.5448,1901.0109,1916.2056,1928.2279,1941.992,1958.3866,1976.2195,1993.618,2010.9382,2024.7635,2042.5306,2052.436,2056.843,2055.2415,2051.2268,1965.3289,1962.3605,1959.3739,1956.73,1953.502,1951.0659,1948.202,1945.3647,1942.37,1937.1864,1931.3287,1926.006,1921.0527,1916.1808,1910.3054,1904.0719,1897.1332,1888.2052,1883.3331,1877.4927,1874.38,1872.0,1870.4213,1868.8414,1866.9379,1865.2,1856.5839,1851.8292,1851.0,1851.1708,1851.1708,1851.0997,1851.0,1851.8148,1862.3256,1875.5911,1888.3657,1907.5408,1925.6459,1936.9327,1954.7117,1977.198,1993.0763,2012.4012,2027.2769,2045.1915,2058.7551,2062.5544,2063.629,2061.52,2057.2583,1978.7068,1975.1105,1971.505,1968.069,1965.6329,1962.1969,1959.6292,1956.3607,1953.8889,1950.584,1945.9459,1939.9626,1934.1364,1927.1062,1920.0056,1911.3337,1902.8828,1892.6954,1884.947,1878.8405,1875.38,1872.944,1870.508,1869.0,1867.4736,1865.2,1860.292,1853.7397,1851.0,1851.0,1851.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_11()
		{
			double[] value = {1851.0,1851.0,1854.4073,1866.2452,1883.7262,1899.1936,1918.5248,1935.2045,1950.4181,1974.7854,1997.6523,2015.0597,2030.7379,2049.1863,2060.357,2066.9336,2068.8662,2068.9382,2066.4348,2062.1108,1991.5079,1988.072,1984.3901,1980.8816,1977.7639,1975.328,1973.5736,1969.8345,1965.4371,1961.76,1957.888,1951.8456,1944.3724,1937.3408,1928.3431,1915.8633,1905.4565,1895.4336,1886.6758,1880.3136,1876.0616,1872.944,1870.508,1868.3674,1866.636,1864.5184,1858.6104,1853.4325,1851.0,1851.0,1851.0,1851.0,1852.5336,1858.5151,1871.691,1889.0197,1909.0903,1929.7178,1950.3661,1970.3009,2000.947,2018.7224,2034.5414,2049.9775,2063.0356,2071.6135,2076.6523,2077.7263,2075.3887,2072.0696,2066.7588,2001.3234,1998.9874,1996.6592,1993.3309,1990.7872,1987.459,1985.023,1982.4791,1978.763,1974.872,1971.0189,1964.3009,1950.8748,1941.7745,1931.0878,1918.4204,1907.496,1896.8262,1887.756,1881.632,1876.38,1872.938,1869.4001,1866.9642,1864.489,1860.1844,1854.4202,1851.2926,1851.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_12()
		{
			double[] value = {1851.0,1851.1056,1852.5686,1856.0516,1861.9408,1875.6536,1891.9584,1915.8358,1945.0288,1964.0604,1986.1685,2011.9855,2031.076,2045.272,2060.348,2071.3599,2078.7756,2084.9854,2086.1733,2082.5596,2076.6875,2070.7078,2008.1213,2006.9565,2005.364,2003.394,2000.958,1999.0187,1996.1539,1992.7404,1989.36,1984.872,1979.1492,1970.054,1955.6715,1942.728,1931.98,1919.36,1907.5623,1897.752,1888.4075,1882.448,1876.76,1871.354,1867.482,1864.538,1860.204,1855.7592,1851.3561,1851.0,1851.0,1851.2905,1852.5233,1854.95,1859.238,1863.11,1877.792,1893.8314,1919.748,1949.59,1966.678,1984.7772,2001.904,2021.1945,2038.814,2056.904,2071.802,2081.08,2088.4226,2090.8853,2087.8542,2082.81,2075.5496,2015.9766,2014.8672,2013.8499,2011.6411,2009.2366,2006.7206,2003.4044,2000.9684,1996.1444,1989.4812,1980.7103,1969.5477,1955.1106,1942.1826,1930.98,1918.8223,1907.62,1897.752,1888.756,1882.448,1876.14,1868.9279,1864.568,1861.1146,1856.3263,1852.2478,1851.0};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_13()
		{
			double[] value = {1851.0,1851.1038,1852.5223,1854.9402,1856.8154,1860.6642,1863.576,1878.057,1892.3262,1914.6915,1937.4615,1953.5304,1972.5745,1988.6052,2004.7017,2026.683,2044.4346,2065.7405,2079.179,2088.9077,2095.713,2094.0593,2089.099,2083.4807,2024.7728,2023.4368,2021.3872,2018.3568,2014.88,2011.6619,2007.3544,2003.0665,1997.836,1989.528,1979.96,1968.947,1953.8217,1941.728,1928.5936,1917.8536,1907.5721,1897.752,1888.756,1881.632,1874.9932,1867.4456,1861.8197,1857.3712,1852.6399,1851.0,1851.0,1851.2596,1852.108,1853.9304,1855.98,1858.416,1860.852,1863.288,1876.299,1890.1873,1905.1482,1921.6857,1937.4896,1951.8784,1970.448,1988.8137,2009.7527,2032.5023,2053.535,2074.9192,2087.3936,2097.176,2098.5583,2095.2449,2090.1887,2028.7252,2027.3522,2025.8553,2023.2092,2018.1686,2013.84,2008.0587,2002.2744,1996.6354,1988.528,1978.96,1967.577,1951.6901,1939.4539,1926.1674,1915.4274,1905.6833,1896.8104,1888.756,1880.7849,1873.6362,1866.832,1861.016,1855.216,1851.636};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_14()
		{
			double[] value = {1851.0,1851.1918,1852.0,1853.108,1854.9146,1856.7926,1859.3065,1861.852,1864.1006,1874.5166,1888.6426,1901.576,1916.3474,1928.0831,1946.2634,1964.6311,1981.8434,2004.2677,2027.194,2050.721,2075.08,2085.824,2098.1025,2100.8125,2098.334,2094.4126,2031.4149,2029.1586,2026.4016,2023.1869,2017.3195,2012.3433,2004.9744,1998.8937,1993.451,1986.2892,1976.659,1964.115,1947.8939,1936.3531,1922.7461,1913.575,1904.2572,1895.5132,1887.5172,1879.404,1872.5212,1865.6066,1860.016,1855.144,1851.636,1851.0,1852.0,1852.7504,1854.321,1855.653,1857.98,1859.832,1862.852,1866.152,1876.8588,1889.1624,1899.5024,1914.6581,1926.1012,1942.6813,1961.4,1982.5786,2006.4094,2030.2681,2054.561,2073.853,2082.8352,2091.2207,2098.0962,2099.5603,2096.3716,2033.1,2028.8865,2025.563,2020.1843,2013.6188,2006.765,1999.457,1994.766,1989.894,1983.039,1973.11,1958.3351,1944.0978,1932.262,1921.319,1911.575,1901.8309,1893.2944,1885.091,1877.783,1870.475,1864.2042,1858.351};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_15()
		{
			double[] value = {1854.407,1851.213,1851.532,1852.157,1853.672,1855.0718,1856.0,1857.98,1860.416,1862.852,1865.199,1875.566,1883.5914,1893.3889,1908.2183,1922.478,1937.9979,1958.6161,1984.945,2008.908,2029.2059,2047.0402,2063.275,2072.5137,2080.243,2088.159,2094.0261,2094.0706,2032.1909,2027.328,2023.3647,2017.1936,2008.9768,2000.5848,1994.8768,1988.918,1984.9503,1978.2544,1967.0752,1951.6139,1940.3688,1928.5132,1919.8932,1910.7489,1900.2921,1892.064,1883.9167,1875.3568,1867.6122,1861.7916,1856.4313,1852.1375,1851.0,1851.8,1853.0,1854.0,1855.0981,1856.0,1856.9982,1859.416,1861.852,1863.935,1867.9487,1875.0609,1885.7239,1900.0387,1917.045,1934.0496,1955.3088,1983.598,2002.5957,2022.8192,2034.1238,2049.354,2058.2808,2068.0564,2077.1035,2085.1873,2088.7903,2030.117,2026.1466,2021.9386,2014.376,2007.3788,1999.316,1992.6855,1985.6034,1978.8011,1971.1517,1959.5306,1947.3945,1938.2717,1926.2106,1918.4706,1909.5103,1899.496,1891.5466,1882.4906,1872.7466,1864.2426};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_16()
		{
			double[] value = {1858.8262,1853.4985,1851.072,1851.0,1851.8,1852.6047,1853.8303,1854.4825,1854.4825,1856.4529,1858.832,1861.4111,1862.6316,1864.2065,1868.1705,1879.7502,1894.6581,1911.434,1929.2932,1952.0466,1979.8411,1994.2958,2009.7319,2021.7141,2033.0155,2044.7756,2055.8691,2066.4143,2075.9863,2083.3547,2026.2128,2024.3844,2020.5123,2014.376,2008.048,2000.7555,1991.936,1984.1976,1977.836,1966.1024,1956.96,1947.1989,1936.3964,1923.7844,1916.0406,1907.2964,1898.5524,1889.8083,1880.0643,1869.3665,1861.8164,1855.9443,1852.508,1851.068,1851.0,1851.0452,1852.0133,1853.0,1853.0,1853.0,1855.0364,1857.4958,1860.8604,1860.3444,1862.724,1864.6964,1876.07,1889.3048,1905.3547,1924.4408,1948.4937,1973.4938,1988.0172,1996.7977,2006.6743,2017.0054,2034.9225,2045.7593,2057.5376,2067.5308,2074.8523,2022.6301,2021.506,2018.8582,2014.0848,2009.3062,2000.76,1992.3058,1984.5138,1977.836,1966.056,1956.96,1947.52,1934.8381,1922.1481,1912.2458,1903.6631,1895.0803,1886.8158,1876.2683};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_17()
		{
			double[] value = {1865.5924,1858.4004,1852.5742,1850.818,1850.0,1849.7648,1850.8,1851.1487,1852.0,1852.0399,1853.544,1855.3624,1857.416,1858.2604,1856.5483,1859.9761,1863.32,1872.0199,1884.0505,1898.8313,1919.5173,1940.5807,1962.0719,1974.4713,1985.2429,1994.4869,2006.2029,2024.185,2039.0754,2049.5088,2058.6826,2065.103,2018.408,2018.3395,2016.432,2014.7495,2011.2246,2003.2883,1995.248,1987.7076,1978.3231,1966.232,1956.22,1945.966,1932.3069,1917.9119,1908.192,1899.5337,1891.7799,1881.3003,1870.62,1860.856,1854.548,1851.796,1850.796,1850.0,1849.1298,1850.0,1851.0,1851.5349,1852.818,1854.34,1855.996,1855.5417,1853.2341,1853.0587,1857.376,1862.1926,1867.1135,1876.7974,1890.9834,1911.9519,1931.4507,1946.8799,1957.08,1969.3317,1984.912,2000.154,2017.1439,2031.5719,2042.752,2050.7795,2054.5159,2014.4556,2014.7778,2014.7778,2013.7778,2011.6329,2003.76,1996.452,1989.144,1978.924,1966.056,1955.7378,1943.7511,1927.7635,1913.8418,1904.5396,1895.1378,1884.7587};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_18()
		{
			double[] value = {1874.0853,1863.4271,1852.7778,1852.1578,1851.7343,1850.8906,1849.056,1849.0,1850.0,1850.4058,1851.7449,1853.3063,1855.1208,1854.7977,1853.0,1853.0,1853.0,1856.2871,1860.32,1864.5062,1874.1528,1886.5858,1904.3857,1920.9288,1931.3893,1945.6525,1962.0916,1980.0596,1994.6755,2013.2378,2024.6506,2034.6454,2041.6392,2045.3556,2010.3516,2011.3516,2011.623,2011.3516,2010.29,2003.76,1995.8036,1988.4956,1978.1964,1965.3457,1953.3115,1939.2825,1923.5596,1910.5116,1900.6831,1889.2947,1877.3667,1868.4552,1854.6553,1850.3516,1850.3516,1850.3516,1848.8596,1848.0253,1848.5876,1849.8704,1851.0,1852.672,1854.038,1854.6472,1853.0071,1853.0,1853.0,1853.0,1855.448,1859.6716,1864.192,1872.5004,1884.6915,1897.6033,1910.7548,1923.165,1939.5387,1957.0109,1975.8011,1989.8231,2006.7028,2019.017,2027.0018,2031.2859,2033.6523,2008.0,2008.9254,2008.9254,2008.7174,2006.2333,2001.7654,1995.3773,1987.9539,1976.9397,1962.9813,1949.5508,1935.7721,1920.2654,1907.043,1894.8307};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_19()
		{
			double[] value = {1884.0907,1873.4214,1861.9554,1851.252,1848.1703,1848.9254,1848.8694,1846.962,1847.8588,1848.364,1849.8,1851.293,1853.0,1854.0,1853.422,1853.0,1853.0,1853.0,1853.0,1854.7034,1859.2454,1863.192,1871.0533,1881.7228,1892.3921,1904.5762,1918.2994,1935.4094,1952.4614,1970.3547,1984.9707,1999.5835,2010.4401,2016.2828,2020.1351,2022.2747,2006.4991,2006.4991,2006.4991,2005.2911,2002.8552,1999.7999,1992.9512,1984.1903,1973.5592,1960.0543,1945.8286,1933.1263,1917.7072,1902.8748,1890.4812,1879.7983,1869.9331,1856.2826,1849.7512,1847.4073,1847.4991,1846.4431,1845.7456,1846.4991,1848.364,1850.3008,1852.236,1853.0,1853.9459,1853.0,1853.0,1853.0,1853.0,1852.6434,1854.448,1858.32,1862.3937,1868.6272,1878.3712,1887.1631,1900.8687,1913.7665,1931.6943,1948.8589,1965.9191,1978.6176,1991.7548,1999.5844,2003.7372,2007.1272,2008.4958,2003.173,2003.3844,2004.0166,2002.865,2001.356,1997.833,1989.5979,1981.265,1969.4583,1953.4509,1942.0869,1928.2739,1914.3539};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_20()
		{
			double[] value = {1899.8325,1888.9763,1876.3539,1866.569,1852.4764,1848.504,1846.6454,1845.073,1844.0688,1844.073,1845.928,1848.364,1850.8,1853.0,1853.9761,1853.0,1853.0,1853.0,1853.0,1853.0,1852.0,1853.724,1857.3813,1861.6395,1867.2009,1876.4381,1885.623,1897.1129,1910.953,1926.6299,1943.0037,1960.5549,1971.781,1983.0719,1988.7125,1992.1199,1994.5559,1996.9918,2000.6467,2000.6467,2001.6467,2001.5122,2000.2302,1994.4067,1986.9165,1977.4855,1962.8285,1948.2874,1937.7335,1923.8135,1911.8547,1898.3748,1887.6228,1873.8867,1862.2667,1851.376,1847.252,1844.4628,1842.8926,1842.056,1843.6714,1845.928,1848.9526,1851.8,1853.1526,1853.672,1853.0,1853.0,1853.0,1852.853,1852.0,1852.0,1852.9025,1856.32,1861.0493,1866.7748,1876.6841,1885.616,1897.0532,1910.656,1926.9851,1940.3059,1952.6838,1961.8367,1972.0294,1977.979,1981.415,1983.4978,1985.2871,1997.2427,1997.703,1999.2206,2000.1747,1997.9326,1990.2634,1982.3771,1971.6812,1955.9457,1943.1451,1932.1411};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_21()
		{
			double[] value = {1920.5037,1908.5605,1896.9486,1886.1957,1872.8,1859.9373,1850.376,1845.7246,1842.2206,1841.2206,1842.056,1844.0,1846.9121,1849.6477,1852.7559,1853.0,1854.0,1853.0,1853.0,1853.0,1852.1288,1851.148,1852.0,1852.724,1854.5405,1859.4126,1864.3236,1874.5605,1884.7617,1896.2606,1908.926,1922.8784,1936.3291,1945.9977,1954.2217,1959.7943,1965.1074,1968.372,1972.1462,1975.6735,1994.7943,1995.7943,1996.7474,1996.5459,1993.0951,1986.2852,1977.5248,1964.4655,1948.5228,1938.2927,1927.5487,1916.2518,1904.2393,1894.3168,1883.7744,1871.8,1858.744,1849.9225,1844.504,1840.0,1840.0,1842.056,1844.492,1847.8708,1850.5696,1853.0,1853.3931,1854.0,1853.0,1853.0,1853.0,1851.584,1851.0,1851.2288,1852.0,1853.16,1857.788,1862.0574,1868.0835,1879.5963,1890.4944,1902.5148,1913.518,1926.3451,1938.1571,1944.6305,1950.3301,1953.8009,1960.9983,1971.2576,1979.6226,1993.2682,1993.3682,1992.8804,1991.4518,1988.7241,1981.4163,1970.6825,1955.4102,1943.1843};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_22()
		{
			double[] value = {1931.9845,1921.8606,1912.1444,1899.8402,1890.4644,1881.3522,1870.6082,1857.2362,1848.7441,1843.8722,1840.0,1840.0,1842.0914,1845.3049,1848.5144,1851.364,1853.0,1854.0,1853.328,1853.0,1853.0,1853.0,1851.0,1851.0,1851.0,1852.0,1852.9518,1858.4198,1862.6958,1870.5077,1883.4155,1894.0126,1903.7139,1912.8217,1921.6848,1930.7041,1938.3685,1946.868,1955.8555,1967.0355,1977.9515,1987.6956,1990.8478,1990.942,1990.2147,1988.734,1984.9146,1975.5012,1961.7018,1948.1211,1937.8859,1925.5879,1917.0889,1906.4039,1896.3635,1887.2379,1878.9838,1868.7095,1855.6787,1848.006,1842.4459,1840.0,1840.0,1843.056,1845.5205,1848.928,1852.364,1853.0,1853.9863,1853.0,1853.0,1853.0,1852.02,1851.0,1850.9915,1851.288,1852.042,1855.378,1860.8114,1866.2441,1877.4252,1889.6361,1902.4761,1912.2781,1920.0221,1928.06,1934.368,1942.224,1950.0396,1962.076,1972.4281,1983.4208,1992.858,1988.9515,1989.5157,1988.5157,1985.999,1978.2831,1967.1472,1953.9673};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_23()
		{
			double[] value = {1942.7625,1931.6073,1921.1345,1912.3732,1901.2476,1893.1198,1885.021,1877.4938,1865.0446,1854.0117,1846.5797,1840.382,1840.0,1840.3003,1843.056,1845.984,1849.3773,1852.364,1853.0,1853.0,1853.0,1853.0,1853.0,1852.02,1850.584,1850.852,1851.288,1852.724,1857.32,1862.6763,1870.5968,1881.0509,1894.0043,1907.3489,1917.6967,1926.5018,1932.5988,1939.2611,1947.7803,1957.2767,1968.0208,1977.3638,1986.5403,1995.5842,1986.0896,1986.149,1985.3175,1980.555,1972.0167,1960.779,1949.0688,1937.4191,1927.1843,1916.883,1906.2053,1897.0911,1889.6936,1882.3855,1874.0696,1862.2794,1852.5856,1845.1536,1840.0,1840.0,1840.62,1843.056,1845.984,1849.856,1852.364,1853.0,1853.0,1853.0,1853.0,1853.0,1851.1095,1850.5317,1850.852,1852.0,1853.724,1858.4657,1864.1558,1872.1251,1882.808,1895.52,1909.0095,1920.0144,1928.6171,1936.7649,1944.0729,1952.9009,1963.6449,1973.424,1982.3049,1990.877,1999.6208,1982.6296,1983.6633,1981.1194,1976.1774,1966.4434};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_24()
		{
			double[] value = {1955.9536,1945.0834,1933.8872,1923.5173,1912.4841,1900.8833,1894.5753,1887.2673,1880.6727,1871.6433,1861.0515,1852.372,1843.959,1840.0,1840.0,1840.62,1843.056,1845.492,1848.928,1852.0273,1853.0,1853.0,1853.0,1853.0,1852.456,1850.6833,1850.0,1851.0,1852.0,1854.448,1859.3739,1864.788,1873.4326,1883.519,1895.424,1907.3634,1918.8046,1929.848,1939.1621,1948.0093,1958.0983,1969.4532,1978.578,1987.9854,1995.7292,2004.8099,1979.2372,1981.2372,1979.2821,1973.4545,1963.5084,1952.1354,1942.1731,1931.4292,1920.3892,1908.9829,1898.6555,1892.1492,1885.604,1878.5332,1869.2212,1860.24,1851.496,1843.99,1840.0,1840.0,1840.62,1843.056,1844.7291,1848.1481,1850.6012,1852.8474,1853.0,1853.0,1852.9176,1850.6931,1849.2524,1850.0,1851.0,1852.0,1854.448,1860.1208,1866.5509,1875.6537,1886.3977,1896.3789,1907.4629,1918.6428,1929.848,1939.6754,1951.0989,1962.1257,1974.2721,1983.0938,1992.0096,2001.1432,2010.5546,1976.7109,1978.2725,1978.228};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_25()
		{
			double[] value = {1972.96,1962.3022,1950.68,1939.8385,1929.012,1916.871,1905.3591,1897.0309,1889.7229,1883.4149,1876.6464,1867.7957,1859.1342,1851.372,1845.1229,1840.0476,1840.0,1840.0,1842.056,1844.0,1846.7389,1849.364,1851.611,1851.8109,1851.8109,1850.5343,1849.0,1849.0,1850.0,1851.0,1852.0,1853.3112,1860.32,1867.4967,1877.349,1889.4406,1899.976,1912.0138,1921.3354,1930.0371,1939.7145,1950.504,1964.6,1975.824,1986.568,1996.1725,2005.6482,2014.7214,1974.2233,1976.7207,1978.0,1972.168,1962.1763,1950.0339,1939.42,1926.2584,1914.6835,1903.2648,1896.22,1888.912,1882.604,1875.0302,1866.988,1859.0245,1851.248,1846.256,1841.1193,1840.0,1840.0,1842.0216,1843.6875,1845.3127,1847.7488,1849.3848,1849.6787,1848.3848,1848.0,1848.0,1848.9877,1850.0,1850.852,1851.288,1852.724,1862.0337,1869.8439,1879.7753,1890.9552,1903.6914,1915.9752,1924.7192,1933.4633,1943.4705,1953.6829,1965.3999,1976.4122,1987.568,1997.312,2007.7728,2016.9846,1971.717};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_26()
		{
			double[] value = {1975.336,1977.2185,1973.168,1962.8066,1951.6,1939.3986,1925.286,1913.4319,1901.88,1895.48,1888.912,1881.604,1874.3196,1867.988,1859.2815,1851.2532,1847.376,1842.535,1840.0,1840.0,1841.0537,1842.9789,1843.9971,1845.6979,1847.7585,1846.7323,1846.0,1847.108,1848.0,1848.9991,1850.0,1851.0,1852.0,1855.926,1866.5629,1875.5084,1887.2523,1896.9963,1907.6444,1918.4015,1927.1455,1936.8894,1948.296,1958.4224,1968.163,1978.8655,1988.0266,1997.3191,2008.056,2017.8,1967.7646,1975.0255,1977.0,1973.168,1963.7668,1952.6375,1939.1453,1925.24,1913.06,1901.88,1895.48,1888.912,1882.604,1875.296,1868.988,1860.5018,1851.372,1847.5219,1843.8538,1840.3816,1840.0,1840.5585,1842.262,1843.494,1844.1937,1845.9065,1845.0,1846.0,1847.108,1848.0,1848.98,1850.0,1851.0,1852.0,1857.473,1870.1825,1881.9153,1893.0953,1904.743,1915.1599,1921.9553,1930.4022,1940.0945,1951.8723,1962.8429,1973.0154,1982.2916,1991.0356,2000.3389,2008.4001};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_27()
		{
			double[] value = {2017.8,1964.7062,1974.0785,1976.2522,1970.5662,1962.4923,1953.6715,1940.3367,1925.288,1913.06,1901.88,1895.2476,1888.912,1882.604,1876.2501,1869.8823,1861.6938,1851.372,1848.376,1844.4773,1841.5454,1840.0,1840.056,1841.492,1842.9357,1843.4315,1844.8212,1845.0,1845.7068,1847.0115,1848.0,1848.9979,1850.0,1851.0,1852.0,1858.2672,1871.8539,1885.4698,1897.0504,1910.5957,1921.3077,1929.5955,1938.6794,1951.1503,1959.5883,1969.0927,1978.7616,1987.5496,1995.5488,2004.8398,2012.5797,2019.962,1961.3799,1971.3679,1973.8159,1967.7358,1959.99,1952.44,1941.1,1925.288,1912.3239,1901.704,1894.3967,1888.3853,1882.604,1876.864,1869.988,1861.8,1852.248,1848.688,1845.3326,1842.0771,1840.0,1840.0,1840.8374,1842.0,1843.2474,1844.0,1844.236,1845.672,1847.0,1848.0,1848.98,1850.0,1851.0,1852.0,1859.6641,1874.28,1887.1093,1900.1703,1914.66,1926.4495,1938.3202,1949.4396,1959.6641,1968.5522,1977.9191,1987.0402,1997.1042,2004.1362};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_28()
		{
			double[] value = {2011.1792,2016.0276,2021.4,1959.7538,1967.011,1968.5653,1963.0914,1956.5754,1949.1875,1938.6737,1924.3002,1911.7704,1900.5726,1893.286,1887.608,1881.9563,1876.864,1869.988,1861.8,1852.248,1848.688,1846.0623,1842.816,1840.2836,1840.0,1840.492,1841.928,1842.5254,1843.8,1844.236,1845.672,1847.0,1848.0,1848.98,1850.0,1851.0,1852.288,1864.0203,1878.3331,1890.8766,1901.2158,1917.4355,1933.4951,1944.5988,1955.4293,1966.3406,1975.3472,1983.7659,1991.8263,2000.868,2007.2755,2012.4202,2015.0355,2019.9075,1955.9999,1965.049,1963.9224,1959.031,1952.8341,1944.3351,1934.0751,1922.0592,1909.8876,1899.3555,1892.22,1886.5555,1881.5863,1876.766,1869.8162,1862.2634,1852.248,1849.4298,1846.633,1843.816,1840.867,1840.0,1840.0,1840.9875,1842.0,1843.0,1844.0,1845.0,1847.0,1848.0,1849.0,1850.0,1851.0,1852.288,1865.344,1878.8151,1892.98,1905.16,1918.808,1937.136,1946.5325,1958.8285,1971.3684,1979.0048,1986.2375,1991.6951};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_29()
		{
			double[] value = {1996.3945,2001.0941,2005.681,2009.6196,2013.8826,1949.704,1958.4785,1959.1222,1954.3866,1947.8706,1939.4827,1929.2227,1918.6125,1906.8627,1897.9293,1890.777,1885.1913,1880.2163,1875.2654,1868.9896,1861.4647,1852.372,1849.688,1847.252,1844.4885,1841.9786,1840.0,1840.0,1840.3724,1841.6193,1842.8802,1844.0,1845.0,1847.0,1848.0,1849.0,1850.249,1851.0,1852.288,1863.7454,1876.7627,1891.7382,1905.16,1918.9958,1935.7294,1946.9648,1960.3446,1973.9523,1978.6973,1982.3217,1985.1254,1986.9626,1990.0253,1995.2614,2000.7319,2005.7244,1942.5254,1950.5974,1952.931,1948.5343,1942.0343,1934.6302,1924.8862,1914.1891,1903.4231,1895.5032,1889.2015,1883.608,1878.736,1873.8499,1867.988,1861.2261,1853.3938,1850.688,1848.252,1845.6366,1843.38,1840.944,1840.0,1840.0,1841.355,1842.8,1844.0,1844.672,1847.0,1848.0135,1849.98,1850.4305,1851.0212,1852.6008,1860.896,1871.9103,1888.0974,1902.1415,1915.7583,1931.4453,1943.6587,1958.3629,1969.5562,1973.5323};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_30()
		{
			double[] value = {1973.8756,1973.8756,1975.8068,1978.6597,1983.5316,1989.4036,1995.9583,1934.2467,1941.8677,1945.544,1943.6819,1937.6799,1928.7778,1919.5828,1910.2898,1900.7208,1894.0769,1887.0289,1882.157,1877.3445,1872.413,1866.992,1861.12,1854.7671,1850.688,1848.252,1845.816,1843.6597,1841.944,1840.0,1840.0,1840.7131,1842.0,1843.236,1844.672,1847.0,1848.544,1849.98,1851.0,1852.3843,1855.869,1861.2965,1867.0479,1881.2228,1895.8387,1910.1627,1924.0708,1938.5001,1951.8768,1962.5033,1963.5477,1961.2936,1960.8135,1962.2495,1965.0775,1971.7776,1977.9877,1983.5957,1926.77,1934.0402,1939.0175,1938.8295,1931.7484,1922.9353,1914.1814,1906.3894,1898.9111,1891.6508,1885.6027,1880.7307,1875.8588,1870.9867,1865.992,1861.12,1855.248,1851.6035,1849.252,1846.816,1844.38,1842.8213,1840.4457,1840.0,1840.364,1841.8246,1843.236,1844.672,1846.108,1848.544,1850.0,1851.416,1853.7292,1857.5406,1861.6902,1868.4142,1878.3345,1890.4655,1904.5854,1918.5735,1933.8645,1945.4447};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_31()
		{
			double[] value = {1951.5168,1949.9656,1947.5295,1946.5547,1947.5696,1950.1764,1955.343,1964.7924,1973.6277,1918.3164,1926.8635,1931.8616,1932.7367,1926.7645,1919.3765,1911.1486,1903.5516,1895.5325,1889.0485,1883.1765,1878.3046,1873.736,1869.7329,1864.9948,1860.9865,1855.5138,1851.688,1849.3285,1847.6879,1845.38,1842.944,1840.508,1840.0,1840.0,1841.0,1843.0,1844.468,1846.108,1848.544,1850.0,1852.1262,1854.852,1858.576,1862.9437,1869.8949,1879.8795,1892.767,1905.7185,1919.7566,1930.8501,1937.1025,1939.2706,1937.638,1934.0951,1932.6991,1936.1217,1937.8746,1941.7153,1950.2899,1961.2826,1908.6813,1918.0892,1924.6252,1926.7548,1923.0785,1917.0303,1909.2063,1900.4623,1892.8232,1886.6223,1881.68,1876.3862,1872.0063,1868.0176,1864.2623,1860.12,1856.124,1852.6036,1850.252,1847.816,1845.38,1842.944,1841.2377,1840.0,1840.0,1840.8,1842.236,1844.0,1846.108,1848.544,1849.98,1852.416,1855.704,1859.4982,1863.448,1871.2529,1881.3057,1894.8983,1910.1322,1919.2968};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_32()
		{
			double[] value = {1925.9725,1926.4545,1926.1969,1923.0691,1920.3289,1920.6013,1923.767,1926.8652,1932.3414,1939.4012,1950.8812,1898.9921,1906.3844,1911.9204,1916.9484,1918.9888,1914.6041,1906.8606,1898.0361,1889.68,1884.1962,1879.2836,1874.4521,1869.7122,1866.2761,1862.8401,1859.12,1856.124,1852.688,1850.252,1847.816,1845.38,1843.944,1841.508,1840.0,1840.0,1840.6753,1842.236,1844.0,1846.108,1848.0,1849.98,1851.9089,1854.829,1859.864,1864.7168,1874.6858,1885.3547,1899.6177,1909.1752,1913.4363,1915.2206,1913.9786,1910.8527,1908.6736,1910.4158,1912.3641,1917.6002,1922.0802,1925.3711,1932.3243,1939.97,1889.4135,1896.3436,1901.9877,1909.6697,1913.6285,1911.7935,1905.1703,1896.6099,1887.642,1881.7699,1876.898,1872.0259,1867.2091,1863.8499,1861.414,1858.56,1855.1758,1852.688,1850.252,1847.816,1845.38,1843.944,1841.508,1840.0,1840.0,1840.0,1842.236,1843.8091,1846.108,1848.0,1849.98,1851.1738,1853.208,1859.4496,1868.4781,1879.1241,1891.5482,1903.4447};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_33()
		{
			double[] value = {1904.2538,1903.7677,1901.1117,1899.1831,1899.8358,1900.213,1903.0878,1910.2406,1914.33,1918.2278,1921.5919,1925.4741,1932.3538,1881.6752,1886.9803,1893.2828,1903.3928,1908.6328,1908.8324,1903.9637,1894.2317,1885.8278,1879.5197,1874.4717,1869.5914,1864.8597,1862.4285,1859.996,1857.5564,1855.1157,1851.688,1850.252,1847.816,1845.38,1843.9362,1841.508,1840.0,1840.0,1840.0,1842.236,1843.672,1845.9926,1847.544,1848.9999,1850.416,1851.852,1858.4318,1869.6177,1881.7904,1891.1622,1891.9666,1889.5071,1887.9751,1886.9862,1889.5437,1894.4258,1899.9469,1905.084,1908.0356,1911.8954,1914.3754,1917.6409,1921.2391,1924.6752,1875.422,1878.744,1884.578,1894.51,1905.063,1906.4855,1902.968,1892.8055,1884.4015,1877.0935,1871.9325,1866.1735,1863.4335,1861.2443,1858.5632,1856.56,1854.124,1851.688,1849.252,1847.816,1845.38,1843.0,1841.508,1840.0,1840.0,1840.3477,1842.236,1843.8145,1845.108,1847.544,1848.98,1850.2352,1851.4818,1856.0055,1868.1855,1879.451};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_34()
		{
			double[] value = {1883.2925,1883.6646,1881.6965,1879.358,1881.1842,1887.5564,1893.2015,1900.791,1904.5656,1904.8596,1906.6716,1910.5231,1912.959,1915.395,1917.0924,1873.1467,1872.6614,1876.9302,1886.4869,1899.6875,1905.8512,1901.1073,1892.1987,1882.5021,1875.2006,1869.6193,1864.705,1862.121,1860.432,1857.996,1855.56,1853.124,1851.0,1849.252,1846.9553,1845.053,1842.944,1841.508,1840.0,1840.0,1840.8,1842.8936,1844.0,1846.0929,1847.544,1848.98,1850.0,1851.0,1853.0435,1862.937,1872.0372,1876.0139,1875.5527,1873.95,1873.292,1876.2512,1883.6066,1889.9146,1897.0099,1901.2786,1900.6918,1902.0953,1906.6707,1908.3939,1908.5573,1909.1597,1879.3894,1871.8054,1872.2571,1878.9713,1891.3593,1900.8983,1899.0262,1891.144,1880.7731,1873.352,1868.1931,1864.0171,1861.581,1859.1451,1856.996,1854.56,1852.124,1850.688,1848.7854,1846.816,1844.38,1842.944,1840.508,1840.0,1840.0,1840.8,1843.0,1844.672,1846.108,1848.1561,1849.2811,1850.1194,1851.0,1851.7958};
			return value;
		}
		private double[] getGeoElevationGrid_5_20_height_35()
		{
			double[] value = {1855.1937,1862.2183,1866.7354,1868.1393,1866.8055,1864.7816,1871.2568,1878.914,1884.5634,1889.7222,1894.3314,1898.04,1901.956,1905.2795,1903.8851,1901.1622,1903.5131};
			return value;
		}


		/** Define subarrays using type double[] */
		private double[] getTextureCoordinate_6_21_point_1()
		{
			double[] value = {0.00391,0.00391,0.02,0.00391,0.04,0.00391,0.06,0.00391,0.08,0.00391,0.1,0.00391,0.12,0.00391,0.14,0.00391,0.16,0.00391,0.18,0.00391,0.2,0.00391,0.22,0.00391,0.24,0.00391,0.26,0.00391,0.28,0.00391,0.3,0.00391,0.32,0.00391,0.34,0.00391,0.36,0.00391,0.38,0.00391,0.4,0.00391,0.42,0.00391,0.44,0.00391,0.46,0.00391,0.48,0.00391,0.5,0.00391,0.52,0.00391,0.54,0.00391,0.56,0.00391,0.58,0.00391,0.6,0.00391,0.62,0.00391,0.64,0.00391,0.66,0.00391,0.68,0.00391,0.7,0.00391,0.72,0.00391,0.74,0.00391,0.76,0.00391,0.78,0.00391,0.8,0.00391,0.82,0.00391,0.84,0.00391,0.86,0.00391,0.88,0.00391,0.9,0.00391,0.92,0.00391,0.94,0.00391,0.96,0.00391,0.98,0.00391,0.99609,0.00391,0.00391,0.01515,0.02,0.01515,0.04,0.01515,0.06,0.01515,0.08,0.01515,0.1,0.01515,0.12,0.01515,0.14,0.01515,0.16,0.01515,0.18,0.01515,0.2,0.01515,0.22,0.01515,0.24,0.01515,0.26,0.01515,0.28,0.01515,0.3,0.01515,0.32,0.01515,0.34,0.01515,0.36,0.01515,0.38,0.01515,0.4,0.01515,0.42,0.01515,0.44,0.01515,0.46,0.01515,0.48,0.01515,0.5,0.01515,0.52,0.01515,0.54,0.01515,0.56,0.01515,0.58,0.01515,0.6,0.01515,0.62,0.01515,0.64,0.01515,0.66,0.01515,0.68,0.01515,0.7,0.01515,0.72,0.01515,0.74,0.01515,0.76,0.01515,0.78,0.01515,0.8,0.01515,0.82,0.01515,0.84,0.01515,0.86,0.01515,0.88,0.01515,0.9,0.01515,0.92,0.01515,0.94,0.01515,0.96,0.01515};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_2()
		{
			double[] value = {0.98,0.01515,0.99609,0.01515,0.00391,0.0303,0.02,0.0303,0.04,0.0303,0.06,0.0303,0.08,0.0303,0.1,0.0303,0.12,0.0303,0.14,0.0303,0.16,0.0303,0.18,0.0303,0.2,0.0303,0.22,0.0303,0.24,0.0303,0.26,0.0303,0.28,0.0303,0.3,0.0303,0.32,0.0303,0.34,0.0303,0.36,0.0303,0.38,0.0303,0.4,0.0303,0.42,0.0303,0.44,0.0303,0.46,0.0303,0.48,0.0303,0.5,0.0303,0.52,0.0303,0.54,0.0303,0.56,0.0303,0.58,0.0303,0.6,0.0303,0.62,0.0303,0.64,0.0303,0.66,0.0303,0.68,0.0303,0.7,0.0303,0.72,0.0303,0.74,0.0303,0.76,0.0303,0.78,0.0303,0.8,0.0303,0.82,0.0303,0.84,0.0303,0.86,0.0303,0.88,0.0303,0.9,0.0303,0.92,0.0303,0.94,0.0303,0.96,0.0303,0.98,0.0303,0.99609,0.0303,0.00391,0.04545,0.02,0.04545,0.04,0.04545,0.06,0.04545,0.08,0.04545,0.1,0.04545,0.12,0.04545,0.14,0.04545,0.16,0.04545,0.18,0.04545,0.2,0.04545,0.22,0.04545,0.24,0.04545,0.26,0.04545,0.28,0.04545,0.3,0.04545,0.32,0.04545,0.34,0.04545,0.36,0.04545,0.38,0.04545,0.4,0.04545,0.42,0.04545,0.44,0.04545,0.46,0.04545,0.48,0.04545,0.5,0.04545,0.52,0.04545,0.54,0.04545,0.56,0.04545,0.58,0.04545,0.6,0.04545,0.62,0.04545,0.64,0.04545,0.66,0.04545,0.68,0.04545,0.7,0.04545,0.72,0.04545,0.74,0.04545,0.76,0.04545,0.78,0.04545,0.8,0.04545,0.82,0.04545,0.84,0.04545,0.86,0.04545,0.88,0.04545,0.9,0.04545,0.92,0.04545};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_3()
		{
			double[] value = {0.94,0.04545,0.96,0.04545,0.98,0.04545,0.99609,0.04545,0.00391,0.06061,0.02,0.06061,0.04,0.06061,0.06,0.06061,0.08,0.06061,0.1,0.06061,0.12,0.06061,0.14,0.06061,0.16,0.06061,0.18,0.06061,0.2,0.06061,0.22,0.06061,0.24,0.06061,0.26,0.06061,0.28,0.06061,0.3,0.06061,0.32,0.06061,0.34,0.06061,0.36,0.06061,0.38,0.06061,0.4,0.06061,0.42,0.06061,0.44,0.06061,0.46,0.06061,0.48,0.06061,0.5,0.06061,0.52,0.06061,0.54,0.06061,0.56,0.06061,0.58,0.06061,0.6,0.06061,0.62,0.06061,0.64,0.06061,0.66,0.06061,0.68,0.06061,0.7,0.06061,0.72,0.06061,0.74,0.06061,0.76,0.06061,0.78,0.06061,0.8,0.06061,0.82,0.06061,0.84,0.06061,0.86,0.06061,0.88,0.06061,0.9,0.06061,0.92,0.06061,0.94,0.06061,0.96,0.06061,0.98,0.06061,0.99609,0.06061,0.00391,0.07576,0.02,0.07576,0.04,0.07576,0.06,0.07576,0.08,0.07576,0.1,0.07576,0.12,0.07576,0.14,0.07576,0.16,0.07576,0.18,0.07576,0.2,0.07576,0.22,0.07576,0.24,0.07576,0.26,0.07576,0.28,0.07576,0.3,0.07576,0.32,0.07576,0.34,0.07576,0.36,0.07576,0.38,0.07576,0.4,0.07576,0.42,0.07576,0.44,0.07576,0.46,0.07576,0.48,0.07576,0.5,0.07576,0.52,0.07576,0.54,0.07576,0.56,0.07576,0.58,0.07576,0.6,0.07576,0.62,0.07576,0.64,0.07576,0.66,0.07576,0.68,0.07576,0.7,0.07576,0.72,0.07576,0.74,0.07576,0.76,0.07576,0.78,0.07576,0.8,0.07576,0.82,0.07576,0.84,0.07576,0.86,0.07576,0.88,0.07576};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_4()
		{
			double[] value = {0.9,0.07576,0.92,0.07576,0.94,0.07576,0.96,0.07576,0.98,0.07576,0.99609,0.07576,0.00391,0.09091,0.02,0.09091,0.04,0.09091,0.06,0.09091,0.08,0.09091,0.1,0.09091,0.12,0.09091,0.14,0.09091,0.16,0.09091,0.18,0.09091,0.2,0.09091,0.22,0.09091,0.24,0.09091,0.26,0.09091,0.28,0.09091,0.3,0.09091,0.32,0.09091,0.34,0.09091,0.36,0.09091,0.38,0.09091,0.4,0.09091,0.42,0.09091,0.44,0.09091,0.46,0.09091,0.48,0.09091,0.5,0.09091,0.52,0.09091,0.54,0.09091,0.56,0.09091,0.58,0.09091,0.6,0.09091,0.62,0.09091,0.64,0.09091,0.66,0.09091,0.68,0.09091,0.7,0.09091,0.72,0.09091,0.74,0.09091,0.76,0.09091,0.78,0.09091,0.8,0.09091,0.82,0.09091,0.84,0.09091,0.86,0.09091,0.88,0.09091,0.9,0.09091,0.92,0.09091,0.94,0.09091,0.96,0.09091,0.98,0.09091,0.99609,0.09091,0.00391,0.10606,0.02,0.10606,0.04,0.10606,0.06,0.10606,0.08,0.10606,0.1,0.10606,0.12,0.10606,0.14,0.10606,0.16,0.10606,0.18,0.10606,0.2,0.10606,0.22,0.10606,0.24,0.10606,0.26,0.10606,0.28,0.10606,0.3,0.10606,0.32,0.10606,0.34,0.10606,0.36,0.10606,0.38,0.10606,0.4,0.10606,0.42,0.10606,0.44,0.10606,0.46,0.10606,0.48,0.10606,0.5,0.10606,0.52,0.10606,0.54,0.10606,0.56,0.10606,0.58,0.10606,0.6,0.10606,0.62,0.10606,0.64,0.10606,0.66,0.10606,0.68,0.10606,0.7,0.10606,0.72,0.10606,0.74,0.10606,0.76,0.10606,0.78,0.10606,0.8,0.10606,0.82,0.10606,0.84,0.10606};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_5()
		{
			double[] value = {0.86,0.10606,0.88,0.10606,0.9,0.10606,0.92,0.10606,0.94,0.10606,0.96,0.10606,0.98,0.10606,0.99609,0.10606,0.00391,0.12121,0.02,0.12121,0.04,0.12121,0.06,0.12121,0.08,0.12121,0.1,0.12121,0.12,0.12121,0.14,0.12121,0.16,0.12121,0.18,0.12121,0.2,0.12121,0.22,0.12121,0.24,0.12121,0.26,0.12121,0.28,0.12121,0.3,0.12121,0.32,0.12121,0.34,0.12121,0.36,0.12121,0.38,0.12121,0.4,0.12121,0.42,0.12121,0.44,0.12121,0.46,0.12121,0.48,0.12121,0.5,0.12121,0.52,0.12121,0.54,0.12121,0.56,0.12121,0.58,0.12121,0.6,0.12121,0.62,0.12121,0.64,0.12121,0.66,0.12121,0.68,0.12121,0.7,0.12121,0.72,0.12121,0.74,0.12121,0.76,0.12121,0.78,0.12121,0.8,0.12121,0.82,0.12121,0.84,0.12121,0.86,0.12121,0.88,0.12121,0.9,0.12121,0.92,0.12121,0.94,0.12121,0.96,0.12121,0.98,0.12121,0.99609,0.12121,0.00391,0.13636,0.02,0.13636,0.04,0.13636,0.06,0.13636,0.08,0.13636,0.1,0.13636,0.12,0.13636,0.14,0.13636,0.16,0.13636,0.18,0.13636,0.2,0.13636,0.22,0.13636,0.24,0.13636,0.26,0.13636,0.28,0.13636,0.3,0.13636,0.32,0.13636,0.34,0.13636,0.36,0.13636,0.38,0.13636,0.4,0.13636,0.42,0.13636,0.44,0.13636,0.46,0.13636,0.48,0.13636,0.5,0.13636,0.52,0.13636,0.54,0.13636,0.56,0.13636,0.58,0.13636,0.6,0.13636,0.62,0.13636,0.64,0.13636,0.66,0.13636,0.68,0.13636,0.7,0.13636,0.72,0.13636,0.74,0.13636,0.76,0.13636,0.78,0.13636,0.8,0.13636};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_6()
		{
			double[] value = {0.82,0.13636,0.84,0.13636,0.86,0.13636,0.88,0.13636,0.9,0.13636,0.92,0.13636,0.94,0.13636,0.96,0.13636,0.98,0.13636,0.99609,0.13636,0.00391,0.15152,0.02,0.15152,0.04,0.15152,0.06,0.15152,0.08,0.15152,0.1,0.15152,0.12,0.15152,0.14,0.15152,0.16,0.15152,0.18,0.15152,0.2,0.15152,0.22,0.15152,0.24,0.15152,0.26,0.15152,0.28,0.15152,0.3,0.15152,0.32,0.15152,0.34,0.15152,0.36,0.15152,0.38,0.15152,0.4,0.15152,0.42,0.15152,0.44,0.15152,0.46,0.15152,0.48,0.15152,0.5,0.15152,0.52,0.15152,0.54,0.15152,0.56,0.15152,0.58,0.15152,0.6,0.15152,0.62,0.15152,0.64,0.15152,0.66,0.15152,0.68,0.15152,0.7,0.15152,0.72,0.15152,0.74,0.15152,0.76,0.15152,0.78,0.15152,0.8,0.15152,0.82,0.15152,0.84,0.15152,0.86,0.15152,0.88,0.15152,0.9,0.15152,0.92,0.15152,0.94,0.15152,0.96,0.15152,0.98,0.15152,0.99609,0.15152,0.00391,0.16667,0.02,0.16667,0.04,0.16667,0.06,0.16667,0.08,0.16667,0.1,0.16667,0.12,0.16667,0.14,0.16667,0.16,0.16667,0.18,0.16667,0.2,0.16667,0.22,0.16667,0.24,0.16667,0.26,0.16667,0.28,0.16667,0.3,0.16667,0.32,0.16667,0.34,0.16667,0.36,0.16667,0.38,0.16667,0.4,0.16667,0.42,0.16667,0.44,0.16667,0.46,0.16667,0.48,0.16667,0.5,0.16667,0.52,0.16667,0.54,0.16667,0.56,0.16667,0.58,0.16667,0.6,0.16667,0.62,0.16667,0.64,0.16667,0.66,0.16667,0.68,0.16667,0.7,0.16667,0.72,0.16667,0.74,0.16667,0.76,0.16667};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_7()
		{
			double[] value = {0.78,0.16667,0.8,0.16667,0.82,0.16667,0.84,0.16667,0.86,0.16667,0.88,0.16667,0.9,0.16667,0.92,0.16667,0.94,0.16667,0.96,0.16667,0.98,0.16667,0.99609,0.16667,0.00391,0.18182,0.02,0.18182,0.04,0.18182,0.06,0.18182,0.08,0.18182,0.1,0.18182,0.12,0.18182,0.14,0.18182,0.16,0.18182,0.18,0.18182,0.2,0.18182,0.22,0.18182,0.24,0.18182,0.26,0.18182,0.28,0.18182,0.3,0.18182,0.32,0.18182,0.34,0.18182,0.36,0.18182,0.38,0.18182,0.4,0.18182,0.42,0.18182,0.44,0.18182,0.46,0.18182,0.48,0.18182,0.5,0.18182,0.52,0.18182,0.54,0.18182,0.56,0.18182,0.58,0.18182,0.6,0.18182,0.62,0.18182,0.64,0.18182,0.66,0.18182,0.68,0.18182,0.7,0.18182,0.72,0.18182,0.74,0.18182,0.76,0.18182,0.78,0.18182,0.8,0.18182,0.82,0.18182,0.84,0.18182,0.86,0.18182,0.88,0.18182,0.9,0.18182,0.92,0.18182,0.94,0.18182,0.96,0.18182,0.98,0.18182,0.99609,0.18182,0.00391,0.19697,0.02,0.19697,0.04,0.19697,0.06,0.19697,0.08,0.19697,0.1,0.19697,0.12,0.19697,0.14,0.19697,0.16,0.19697,0.18,0.19697,0.2,0.19697,0.22,0.19697,0.24,0.19697,0.26,0.19697,0.28,0.19697,0.3,0.19697,0.32,0.19697,0.34,0.19697,0.36,0.19697,0.38,0.19697,0.4,0.19697,0.42,0.19697,0.44,0.19697,0.46,0.19697,0.48,0.19697,0.5,0.19697,0.52,0.19697,0.54,0.19697,0.56,0.19697,0.58,0.19697,0.6,0.19697,0.62,0.19697,0.64,0.19697,0.66,0.19697,0.68,0.19697,0.7,0.19697,0.72,0.19697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_8()
		{
			double[] value = {0.74,0.19697,0.76,0.19697,0.78,0.19697,0.8,0.19697,0.82,0.19697,0.84,0.19697,0.86,0.19697,0.88,0.19697,0.9,0.19697,0.92,0.19697,0.94,0.19697,0.96,0.19697,0.98,0.19697,0.99609,0.19697,0.00391,0.21212,0.02,0.21212,0.04,0.21212,0.06,0.21212,0.08,0.21212,0.1,0.21212,0.12,0.21212,0.14,0.21212,0.16,0.21212,0.18,0.21212,0.2,0.21212,0.22,0.21212,0.24,0.21212,0.26,0.21212,0.28,0.21212,0.3,0.21212,0.32,0.21212,0.34,0.21212,0.36,0.21212,0.38,0.21212,0.4,0.21212,0.42,0.21212,0.44,0.21212,0.46,0.21212,0.48,0.21212,0.5,0.21212,0.52,0.21212,0.54,0.21212,0.56,0.21212,0.58,0.21212,0.6,0.21212,0.62,0.21212,0.64,0.21212,0.66,0.21212,0.68,0.21212,0.7,0.21212,0.72,0.21212,0.74,0.21212,0.76,0.21212,0.78,0.21212,0.8,0.21212,0.82,0.21212,0.84,0.21212,0.86,0.21212,0.88,0.21212,0.9,0.21212,0.92,0.21212,0.94,0.21212,0.96,0.21212,0.98,0.21212,0.99609,0.21212,0.00391,0.22727,0.02,0.22727,0.04,0.22727,0.06,0.22727,0.08,0.22727,0.1,0.22727,0.12,0.22727,0.14,0.22727,0.16,0.22727,0.18,0.22727,0.2,0.22727,0.22,0.22727,0.24,0.22727,0.26,0.22727,0.28,0.22727,0.3,0.22727,0.32,0.22727,0.34,0.22727,0.36,0.22727,0.38,0.22727,0.4,0.22727,0.42,0.22727,0.44,0.22727,0.46,0.22727,0.48,0.22727,0.5,0.22727,0.52,0.22727,0.54,0.22727,0.56,0.22727,0.58,0.22727,0.6,0.22727,0.62,0.22727,0.64,0.22727,0.66,0.22727,0.68,0.22727};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_9()
		{
			double[] value = {0.7,0.22727,0.72,0.22727,0.74,0.22727,0.76,0.22727,0.78,0.22727,0.8,0.22727,0.82,0.22727,0.84,0.22727,0.86,0.22727,0.88,0.22727,0.9,0.22727,0.92,0.22727,0.94,0.22727,0.96,0.22727,0.98,0.22727,0.99609,0.22727,0.00391,0.24242,0.02,0.24242,0.04,0.24242,0.06,0.24242,0.08,0.24242,0.1,0.24242,0.12,0.24242,0.14,0.24242,0.16,0.24242,0.18,0.24242,0.2,0.24242,0.22,0.24242,0.24,0.24242,0.26,0.24242,0.28,0.24242,0.3,0.24242,0.32,0.24242,0.34,0.24242,0.36,0.24242,0.38,0.24242,0.4,0.24242,0.42,0.24242,0.44,0.24242,0.46,0.24242,0.48,0.24242,0.5,0.24242,0.52,0.24242,0.54,0.24242,0.56,0.24242,0.58,0.24242,0.6,0.24242,0.62,0.24242,0.64,0.24242,0.66,0.24242,0.68,0.24242,0.7,0.24242,0.72,0.24242,0.74,0.24242,0.76,0.24242,0.78,0.24242,0.8,0.24242,0.82,0.24242,0.84,0.24242,0.86,0.24242,0.88,0.24242,0.9,0.24242,0.92,0.24242,0.94,0.24242,0.96,0.24242,0.98,0.24242,0.99609,0.24242,0.00391,0.25758,0.02,0.25758,0.04,0.25758,0.06,0.25758,0.08,0.25758,0.1,0.25758,0.12,0.25758,0.14,0.25758,0.16,0.25758,0.18,0.25758,0.2,0.25758,0.22,0.25758,0.24,0.25758,0.26,0.25758,0.28,0.25758,0.3,0.25758,0.32,0.25758,0.34,0.25758,0.36,0.25758,0.38,0.25758,0.4,0.25758,0.42,0.25758,0.44,0.25758,0.46,0.25758,0.48,0.25758,0.5,0.25758,0.52,0.25758,0.54,0.25758,0.56,0.25758,0.58,0.25758,0.6,0.25758,0.62,0.25758,0.64,0.25758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_10()
		{
			double[] value = {0.66,0.25758,0.68,0.25758,0.7,0.25758,0.72,0.25758,0.74,0.25758,0.76,0.25758,0.78,0.25758,0.8,0.25758,0.82,0.25758,0.84,0.25758,0.86,0.25758,0.88,0.25758,0.9,0.25758,0.92,0.25758,0.94,0.25758,0.96,0.25758,0.98,0.25758,0.99609,0.25758,0.00391,0.27273,0.02,0.27273,0.04,0.27273,0.06,0.27273,0.08,0.27273,0.1,0.27273,0.12,0.27273,0.14,0.27273,0.16,0.27273,0.18,0.27273,0.2,0.27273,0.22,0.27273,0.24,0.27273,0.26,0.27273,0.28,0.27273,0.3,0.27273,0.32,0.27273,0.34,0.27273,0.36,0.27273,0.38,0.27273,0.4,0.27273,0.42,0.27273,0.44,0.27273,0.46,0.27273,0.48,0.27273,0.5,0.27273,0.52,0.27273,0.54,0.27273,0.56,0.27273,0.58,0.27273,0.6,0.27273,0.62,0.27273,0.64,0.27273,0.66,0.27273,0.68,0.27273,0.7,0.27273,0.72,0.27273,0.74,0.27273,0.76,0.27273,0.78,0.27273,0.8,0.27273,0.82,0.27273,0.84,0.27273,0.86,0.27273,0.88,0.27273,0.9,0.27273,0.92,0.27273,0.94,0.27273,0.96,0.27273,0.98,0.27273,0.99609,0.27273,0.00391,0.28788,0.02,0.28788,0.04,0.28788,0.06,0.28788,0.08,0.28788,0.1,0.28788,0.12,0.28788,0.14,0.28788,0.16,0.28788,0.18,0.28788,0.2,0.28788,0.22,0.28788,0.24,0.28788,0.26,0.28788,0.28,0.28788,0.3,0.28788,0.32,0.28788,0.34,0.28788,0.36,0.28788,0.38,0.28788,0.4,0.28788,0.42,0.28788,0.44,0.28788,0.46,0.28788,0.48,0.28788,0.5,0.28788,0.52,0.28788,0.54,0.28788,0.56,0.28788,0.58,0.28788,0.6,0.28788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_11()
		{
			double[] value = {0.62,0.28788,0.64,0.28788,0.66,0.28788,0.68,0.28788,0.7,0.28788,0.72,0.28788,0.74,0.28788,0.76,0.28788,0.78,0.28788,0.8,0.28788,0.82,0.28788,0.84,0.28788,0.86,0.28788,0.88,0.28788,0.9,0.28788,0.92,0.28788,0.94,0.28788,0.96,0.28788,0.98,0.28788,0.99609,0.28788,0.00391,0.30303,0.02,0.30303,0.04,0.30303,0.06,0.30303,0.08,0.30303,0.1,0.30303,0.12,0.30303,0.14,0.30303,0.16,0.30303,0.18,0.30303,0.2,0.30303,0.22,0.30303,0.24,0.30303,0.26,0.30303,0.28,0.30303,0.3,0.30303,0.32,0.30303,0.34,0.30303,0.36,0.30303,0.38,0.30303,0.4,0.30303,0.42,0.30303,0.44,0.30303,0.46,0.30303,0.48,0.30303,0.5,0.30303,0.52,0.30303,0.54,0.30303,0.56,0.30303,0.58,0.30303,0.6,0.30303,0.62,0.30303,0.64,0.30303,0.66,0.30303,0.68,0.30303,0.7,0.30303,0.72,0.30303,0.74,0.30303,0.76,0.30303,0.78,0.30303,0.8,0.30303,0.82,0.30303,0.84,0.30303,0.86,0.30303,0.88,0.30303,0.9,0.30303,0.92,0.30303,0.94,0.30303,0.96,0.30303,0.98,0.30303,0.99609,0.30303,0.00391,0.31818,0.02,0.31818,0.04,0.31818,0.06,0.31818,0.08,0.31818,0.1,0.31818,0.12,0.31818,0.14,0.31818,0.16,0.31818,0.18,0.31818,0.2,0.31818,0.22,0.31818,0.24,0.31818,0.26,0.31818,0.28,0.31818,0.3,0.31818,0.32,0.31818,0.34,0.31818,0.36,0.31818,0.38,0.31818,0.4,0.31818,0.42,0.31818,0.44,0.31818,0.46,0.31818,0.48,0.31818,0.5,0.31818,0.52,0.31818,0.54,0.31818,0.56,0.31818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_12()
		{
			double[] value = {0.58,0.31818,0.6,0.31818,0.62,0.31818,0.64,0.31818,0.66,0.31818,0.68,0.31818,0.7,0.31818,0.72,0.31818,0.74,0.31818,0.76,0.31818,0.78,0.31818,0.8,0.31818,0.82,0.31818,0.84,0.31818,0.86,0.31818,0.88,0.31818,0.9,0.31818,0.92,0.31818,0.94,0.31818,0.96,0.31818,0.98,0.31818,0.99609,0.31818,0.00391,0.33333,0.02,0.33333,0.04,0.33333,0.06,0.33333,0.08,0.33333,0.1,0.33333,0.12,0.33333,0.14,0.33333,0.16,0.33333,0.18,0.33333,0.2,0.33333,0.22,0.33333,0.24,0.33333,0.26,0.33333,0.28,0.33333,0.3,0.33333,0.32,0.33333,0.34,0.33333,0.36,0.33333,0.38,0.33333,0.4,0.33333,0.42,0.33333,0.44,0.33333,0.46,0.33333,0.48,0.33333,0.5,0.33333,0.52,0.33333,0.54,0.33333,0.56,0.33333,0.58,0.33333,0.6,0.33333,0.62,0.33333,0.64,0.33333,0.66,0.33333,0.68,0.33333,0.7,0.33333,0.72,0.33333,0.74,0.33333,0.76,0.33333,0.78,0.33333,0.8,0.33333,0.82,0.33333,0.84,0.33333,0.86,0.33333,0.88,0.33333,0.9,0.33333,0.92,0.33333,0.94,0.33333,0.96,0.33333,0.98,0.33333,0.99609,0.33333,0.00391,0.34848,0.02,0.34848,0.04,0.34848,0.06,0.34848,0.08,0.34848,0.1,0.34848,0.12,0.34848,0.14,0.34848,0.16,0.34848,0.18,0.34848,0.2,0.34848,0.22,0.34848,0.24,0.34848,0.26,0.34848,0.28,0.34848,0.3,0.34848,0.32,0.34848,0.34,0.34848,0.36,0.34848,0.38,0.34848,0.4,0.34848,0.42,0.34848,0.44,0.34848,0.46,0.34848,0.48,0.34848,0.5,0.34848,0.52,0.34848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_13()
		{
			double[] value = {0.54,0.34848,0.56,0.34848,0.58,0.34848,0.6,0.34848,0.62,0.34848,0.64,0.34848,0.66,0.34848,0.68,0.34848,0.7,0.34848,0.72,0.34848,0.74,0.34848,0.76,0.34848,0.78,0.34848,0.8,0.34848,0.82,0.34848,0.84,0.34848,0.86,0.34848,0.88,0.34848,0.9,0.34848,0.92,0.34848,0.94,0.34848,0.96,0.34848,0.98,0.34848,0.99609,0.34848,0.00391,0.36364,0.02,0.36364,0.04,0.36364,0.06,0.36364,0.08,0.36364,0.1,0.36364,0.12,0.36364,0.14,0.36364,0.16,0.36364,0.18,0.36364,0.2,0.36364,0.22,0.36364,0.24,0.36364,0.26,0.36364,0.28,0.36364,0.3,0.36364,0.32,0.36364,0.34,0.36364,0.36,0.36364,0.38,0.36364,0.4,0.36364,0.42,0.36364,0.44,0.36364,0.46,0.36364,0.48,0.36364,0.5,0.36364,0.52,0.36364,0.54,0.36364,0.56,0.36364,0.58,0.36364,0.6,0.36364,0.62,0.36364,0.64,0.36364,0.66,0.36364,0.68,0.36364,0.7,0.36364,0.72,0.36364,0.74,0.36364,0.76,0.36364,0.78,0.36364,0.8,0.36364,0.82,0.36364,0.84,0.36364,0.86,0.36364,0.88,0.36364,0.9,0.36364,0.92,0.36364,0.94,0.36364,0.96,0.36364,0.98,0.36364,0.99609,0.36364,0.00391,0.37879,0.02,0.37879,0.04,0.37879,0.06,0.37879,0.08,0.37879,0.1,0.37879,0.12,0.37879,0.14,0.37879,0.16,0.37879,0.18,0.37879,0.2,0.37879,0.22,0.37879,0.24,0.37879,0.26,0.37879,0.28,0.37879,0.3,0.37879,0.32,0.37879,0.34,0.37879,0.36,0.37879,0.38,0.37879,0.4,0.37879,0.42,0.37879,0.44,0.37879,0.46,0.37879,0.48,0.37879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_14()
		{
			double[] value = {0.5,0.37879,0.52,0.37879,0.54,0.37879,0.56,0.37879,0.58,0.37879,0.6,0.37879,0.62,0.37879,0.64,0.37879,0.66,0.37879,0.68,0.37879,0.7,0.37879,0.72,0.37879,0.74,0.37879,0.76,0.37879,0.78,0.37879,0.8,0.37879,0.82,0.37879,0.84,0.37879,0.86,0.37879,0.88,0.37879,0.9,0.37879,0.92,0.37879,0.94,0.37879,0.96,0.37879,0.98,0.37879,0.99609,0.37879,0.00391,0.39394,0.02,0.39394,0.04,0.39394,0.06,0.39394,0.08,0.39394,0.1,0.39394,0.12,0.39394,0.14,0.39394,0.16,0.39394,0.18,0.39394,0.2,0.39394,0.22,0.39394,0.24,0.39394,0.26,0.39394,0.28,0.39394,0.3,0.39394,0.32,0.39394,0.34,0.39394,0.36,0.39394,0.38,0.39394,0.4,0.39394,0.42,0.39394,0.44,0.39394,0.46,0.39394,0.48,0.39394,0.5,0.39394,0.52,0.39394,0.54,0.39394,0.56,0.39394,0.58,0.39394,0.6,0.39394,0.62,0.39394,0.64,0.39394,0.66,0.39394,0.68,0.39394,0.7,0.39394,0.72,0.39394,0.74,0.39394,0.76,0.39394,0.78,0.39394,0.8,0.39394,0.82,0.39394,0.84,0.39394,0.86,0.39394,0.88,0.39394,0.9,0.39394,0.92,0.39394,0.94,0.39394,0.96,0.39394,0.98,0.39394,0.99609,0.39394,0.00391,0.40909,0.02,0.40909,0.04,0.40909,0.06,0.40909,0.08,0.40909,0.1,0.40909,0.12,0.40909,0.14,0.40909,0.16,0.40909,0.18,0.40909,0.2,0.40909,0.22,0.40909,0.24,0.40909,0.26,0.40909,0.28,0.40909,0.3,0.40909,0.32,0.40909,0.34,0.40909,0.36,0.40909,0.38,0.40909,0.4,0.40909,0.42,0.40909,0.44,0.40909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_15()
		{
			double[] value = {0.46,0.40909,0.48,0.40909,0.5,0.40909,0.52,0.40909,0.54,0.40909,0.56,0.40909,0.58,0.40909,0.6,0.40909,0.62,0.40909,0.64,0.40909,0.66,0.40909,0.68,0.40909,0.7,0.40909,0.72,0.40909,0.74,0.40909,0.76,0.40909,0.78,0.40909,0.8,0.40909,0.82,0.40909,0.84,0.40909,0.86,0.40909,0.88,0.40909,0.9,0.40909,0.92,0.40909,0.94,0.40909,0.96,0.40909,0.98,0.40909,0.99609,0.40909,0.00391,0.42424,0.02,0.42424,0.04,0.42424,0.06,0.42424,0.08,0.42424,0.1,0.42424,0.12,0.42424,0.14,0.42424,0.16,0.42424,0.18,0.42424,0.2,0.42424,0.22,0.42424,0.24,0.42424,0.26,0.42424,0.28,0.42424,0.3,0.42424,0.32,0.42424,0.34,0.42424,0.36,0.42424,0.38,0.42424,0.4,0.42424,0.42,0.42424,0.44,0.42424,0.46,0.42424,0.48,0.42424,0.5,0.42424,0.52,0.42424,0.54,0.42424,0.56,0.42424,0.58,0.42424,0.6,0.42424,0.62,0.42424,0.64,0.42424,0.66,0.42424,0.68,0.42424,0.7,0.42424,0.72,0.42424,0.74,0.42424,0.76,0.42424,0.78,0.42424,0.8,0.42424,0.82,0.42424,0.84,0.42424,0.86,0.42424,0.88,0.42424,0.9,0.42424,0.92,0.42424,0.94,0.42424,0.96,0.42424,0.98,0.42424,0.99609,0.42424,0.00391,0.43939,0.02,0.43939,0.04,0.43939,0.06,0.43939,0.08,0.43939,0.1,0.43939,0.12,0.43939,0.14,0.43939,0.16,0.43939,0.18,0.43939,0.2,0.43939,0.22,0.43939,0.24,0.43939,0.26,0.43939,0.28,0.43939,0.3,0.43939,0.32,0.43939,0.34,0.43939,0.36,0.43939,0.38,0.43939,0.4,0.43939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_16()
		{
			double[] value = {0.42,0.43939,0.44,0.43939,0.46,0.43939,0.48,0.43939,0.5,0.43939,0.52,0.43939,0.54,0.43939,0.56,0.43939,0.58,0.43939,0.6,0.43939,0.62,0.43939,0.64,0.43939,0.66,0.43939,0.68,0.43939,0.7,0.43939,0.72,0.43939,0.74,0.43939,0.76,0.43939,0.78,0.43939,0.8,0.43939,0.82,0.43939,0.84,0.43939,0.86,0.43939,0.88,0.43939,0.9,0.43939,0.92,0.43939,0.94,0.43939,0.96,0.43939,0.98,0.43939,0.99609,0.43939,0.00391,0.45455,0.02,0.45455,0.04,0.45455,0.06,0.45455,0.08,0.45455,0.1,0.45455,0.12,0.45455,0.14,0.45455,0.16,0.45455,0.18,0.45455,0.2,0.45455,0.22,0.45455,0.24,0.45455,0.26,0.45455,0.28,0.45455,0.3,0.45455,0.32,0.45455,0.34,0.45455,0.36,0.45455,0.38,0.45455,0.4,0.45455,0.42,0.45455,0.44,0.45455,0.46,0.45455,0.48,0.45455,0.5,0.45455,0.52,0.45455,0.54,0.45455,0.56,0.45455,0.58,0.45455,0.6,0.45455,0.62,0.45455,0.64,0.45455,0.66,0.45455,0.68,0.45455,0.7,0.45455,0.72,0.45455,0.74,0.45455,0.76,0.45455,0.78,0.45455,0.8,0.45455,0.82,0.45455,0.84,0.45455,0.86,0.45455,0.88,0.45455,0.9,0.45455,0.92,0.45455,0.94,0.45455,0.96,0.45455,0.98,0.45455,0.99609,0.45455,0.00391,0.4697,0.02,0.4697,0.04,0.4697,0.06,0.4697,0.08,0.4697,0.1,0.4697,0.12,0.4697,0.14,0.4697,0.16,0.4697,0.18,0.4697,0.2,0.4697,0.22,0.4697,0.24,0.4697,0.26,0.4697,0.28,0.4697,0.3,0.4697,0.32,0.4697,0.34,0.4697,0.36,0.4697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_17()
		{
			double[] value = {0.38,0.4697,0.4,0.4697,0.42,0.4697,0.44,0.4697,0.46,0.4697,0.48,0.4697,0.5,0.4697,0.52,0.4697,0.54,0.4697,0.56,0.4697,0.58,0.4697,0.6,0.4697,0.62,0.4697,0.64,0.4697,0.66,0.4697,0.68,0.4697,0.7,0.4697,0.72,0.4697,0.74,0.4697,0.76,0.4697,0.78,0.4697,0.8,0.4697,0.82,0.4697,0.84,0.4697,0.86,0.4697,0.88,0.4697,0.9,0.4697,0.92,0.4697,0.94,0.4697,0.96,0.4697,0.98,0.4697,0.99609,0.4697,0.00391,0.48485,0.02,0.48485,0.04,0.48485,0.06,0.48485,0.08,0.48485,0.1,0.48485,0.12,0.48485,0.14,0.48485,0.16,0.48485,0.18,0.48485,0.2,0.48485,0.22,0.48485,0.24,0.48485,0.26,0.48485,0.28,0.48485,0.3,0.48485,0.32,0.48485,0.34,0.48485,0.36,0.48485,0.38,0.48485,0.4,0.48485,0.42,0.48485,0.44,0.48485,0.46,0.48485,0.48,0.48485,0.5,0.48485,0.52,0.48485,0.54,0.48485,0.56,0.48485,0.58,0.48485,0.6,0.48485,0.62,0.48485,0.64,0.48485,0.66,0.48485,0.68,0.48485,0.7,0.48485,0.72,0.48485,0.74,0.48485,0.76,0.48485,0.78,0.48485,0.8,0.48485,0.82,0.48485,0.84,0.48485,0.86,0.48485,0.88,0.48485,0.9,0.48485,0.92,0.48485,0.94,0.48485,0.96,0.48485,0.98,0.48485,0.99609,0.48485,0.00391,0.5,0.02,0.5,0.04,0.5,0.06,0.5,0.08,0.5,0.1,0.5,0.12,0.5,0.14,0.5,0.16,0.5,0.18,0.5,0.2,0.5,0.22,0.5,0.24,0.5,0.26,0.5,0.28,0.5,0.3,0.5,0.32,0.5};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_18()
		{
			double[] value = {0.34,0.5,0.36,0.5,0.38,0.5,0.4,0.5,0.42,0.5,0.44,0.5,0.46,0.5,0.48,0.5,0.5,0.5,0.52,0.5,0.54,0.5,0.56,0.5,0.58,0.5,0.6,0.5,0.62,0.5,0.64,0.5,0.66,0.5,0.68,0.5,0.7,0.5,0.72,0.5,0.74,0.5,0.76,0.5,0.78,0.5,0.8,0.5,0.82,0.5,0.84,0.5,0.86,0.5,0.88,0.5,0.9,0.5,0.92,0.5,0.94,0.5,0.96,0.5,0.98,0.5,0.99609,0.5,0.00391,0.51515,0.02,0.51515,0.04,0.51515,0.06,0.51515,0.08,0.51515,0.1,0.51515,0.12,0.51515,0.14,0.51515,0.16,0.51515,0.18,0.51515,0.2,0.51515,0.22,0.51515,0.24,0.51515,0.26,0.51515,0.28,0.51515,0.3,0.51515,0.32,0.51515,0.34,0.51515,0.36,0.51515,0.38,0.51515,0.4,0.51515,0.42,0.51515,0.44,0.51515,0.46,0.51515,0.48,0.51515,0.5,0.51515,0.52,0.51515,0.54,0.51515,0.56,0.51515,0.58,0.51515,0.6,0.51515,0.62,0.51515,0.64,0.51515,0.66,0.51515,0.68,0.51515,0.7,0.51515,0.72,0.51515,0.74,0.51515,0.76,0.51515,0.78,0.51515,0.8,0.51515,0.82,0.51515,0.84,0.51515,0.86,0.51515,0.88,0.51515,0.9,0.51515,0.92,0.51515,0.94,0.51515,0.96,0.51515,0.98,0.51515,0.99609,0.51515,0.00391,0.5303,0.02,0.5303,0.04,0.5303,0.06,0.5303,0.08,0.5303,0.1,0.5303,0.12,0.5303,0.14,0.5303,0.16,0.5303,0.18,0.5303,0.2,0.5303,0.22,0.5303,0.24,0.5303,0.26,0.5303,0.28,0.5303};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_19()
		{
			double[] value = {0.3,0.5303,0.32,0.5303,0.34,0.5303,0.36,0.5303,0.38,0.5303,0.4,0.5303,0.42,0.5303,0.44,0.5303,0.46,0.5303,0.48,0.5303,0.5,0.5303,0.52,0.5303,0.54,0.5303,0.56,0.5303,0.58,0.5303,0.6,0.5303,0.62,0.5303,0.64,0.5303,0.66,0.5303,0.68,0.5303,0.7,0.5303,0.72,0.5303,0.74,0.5303,0.76,0.5303,0.78,0.5303,0.8,0.5303,0.82,0.5303,0.84,0.5303,0.86,0.5303,0.88,0.5303,0.9,0.5303,0.92,0.5303,0.94,0.5303,0.96,0.5303,0.98,0.5303,0.99609,0.5303,0.00391,0.54545,0.02,0.54545,0.04,0.54545,0.06,0.54545,0.08,0.54545,0.1,0.54545,0.12,0.54545,0.14,0.54545,0.16,0.54545,0.18,0.54545,0.2,0.54545,0.22,0.54545,0.24,0.54545,0.26,0.54545,0.28,0.54545,0.3,0.54545,0.32,0.54545,0.34,0.54545,0.36,0.54545,0.38,0.54545,0.4,0.54545,0.42,0.54545,0.44,0.54545,0.46,0.54545,0.48,0.54545,0.5,0.54545,0.52,0.54545,0.54,0.54545,0.56,0.54545,0.58,0.54545,0.6,0.54545,0.62,0.54545,0.64,0.54545,0.66,0.54545,0.68,0.54545,0.7,0.54545,0.72,0.54545,0.74,0.54545,0.76,0.54545,0.78,0.54545,0.8,0.54545,0.82,0.54545,0.84,0.54545,0.86,0.54545,0.88,0.54545,0.9,0.54545,0.92,0.54545,0.94,0.54545,0.96,0.54545,0.98,0.54545,0.99609,0.54545,0.00391,0.56061,0.02,0.56061,0.04,0.56061,0.06,0.56061,0.08,0.56061,0.1,0.56061,0.12,0.56061,0.14,0.56061,0.16,0.56061,0.18,0.56061,0.2,0.56061,0.22,0.56061,0.24,0.56061};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_20()
		{
			double[] value = {0.26,0.56061,0.28,0.56061,0.3,0.56061,0.32,0.56061,0.34,0.56061,0.36,0.56061,0.38,0.56061,0.4,0.56061,0.42,0.56061,0.44,0.56061,0.46,0.56061,0.48,0.56061,0.5,0.56061,0.52,0.56061,0.54,0.56061,0.56,0.56061,0.58,0.56061,0.6,0.56061,0.62,0.56061,0.64,0.56061,0.66,0.56061,0.68,0.56061,0.7,0.56061,0.72,0.56061,0.74,0.56061,0.76,0.56061,0.78,0.56061,0.8,0.56061,0.82,0.56061,0.84,0.56061,0.86,0.56061,0.88,0.56061,0.9,0.56061,0.92,0.56061,0.94,0.56061,0.96,0.56061,0.98,0.56061,0.99609,0.56061,0.00391,0.57576,0.02,0.57576,0.04,0.57576,0.06,0.57576,0.08,0.57576,0.1,0.57576,0.12,0.57576,0.14,0.57576,0.16,0.57576,0.18,0.57576,0.2,0.57576,0.22,0.57576,0.24,0.57576,0.26,0.57576,0.28,0.57576,0.3,0.57576,0.32,0.57576,0.34,0.57576,0.36,0.57576,0.38,0.57576,0.4,0.57576,0.42,0.57576,0.44,0.57576,0.46,0.57576,0.48,0.57576,0.5,0.57576,0.52,0.57576,0.54,0.57576,0.56,0.57576,0.58,0.57576,0.6,0.57576,0.62,0.57576,0.64,0.57576,0.66,0.57576,0.68,0.57576,0.7,0.57576,0.72,0.57576,0.74,0.57576,0.76,0.57576,0.78,0.57576,0.8,0.57576,0.82,0.57576,0.84,0.57576,0.86,0.57576,0.88,0.57576,0.9,0.57576,0.92,0.57576,0.94,0.57576,0.96,0.57576,0.98,0.57576,0.99609,0.57576,0.00391,0.59091,0.02,0.59091,0.04,0.59091,0.06,0.59091,0.08,0.59091,0.1,0.59091,0.12,0.59091,0.14,0.59091,0.16,0.59091,0.18,0.59091,0.2,0.59091};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_21()
		{
			double[] value = {0.22,0.59091,0.24,0.59091,0.26,0.59091,0.28,0.59091,0.3,0.59091,0.32,0.59091,0.34,0.59091,0.36,0.59091,0.38,0.59091,0.4,0.59091,0.42,0.59091,0.44,0.59091,0.46,0.59091,0.48,0.59091,0.5,0.59091,0.52,0.59091,0.54,0.59091,0.56,0.59091,0.58,0.59091,0.6,0.59091,0.62,0.59091,0.64,0.59091,0.66,0.59091,0.68,0.59091,0.7,0.59091,0.72,0.59091,0.74,0.59091,0.76,0.59091,0.78,0.59091,0.8,0.59091,0.82,0.59091,0.84,0.59091,0.86,0.59091,0.88,0.59091,0.9,0.59091,0.92,0.59091,0.94,0.59091,0.96,0.59091,0.98,0.59091,0.99609,0.59091,0.00391,0.60606,0.02,0.60606,0.04,0.60606,0.06,0.60606,0.08,0.60606,0.1,0.60606,0.12,0.60606,0.14,0.60606,0.16,0.60606,0.18,0.60606,0.2,0.60606,0.22,0.60606,0.24,0.60606,0.26,0.60606,0.28,0.60606,0.3,0.60606,0.32,0.60606,0.34,0.60606,0.36,0.60606,0.38,0.60606,0.4,0.60606,0.42,0.60606,0.44,0.60606,0.46,0.60606,0.48,0.60606,0.5,0.60606,0.52,0.60606,0.54,0.60606,0.56,0.60606,0.58,0.60606,0.6,0.60606,0.62,0.60606,0.64,0.60606,0.66,0.60606,0.68,0.60606,0.7,0.60606,0.72,0.60606,0.74,0.60606,0.76,0.60606,0.78,0.60606,0.8,0.60606,0.82,0.60606,0.84,0.60606,0.86,0.60606,0.88,0.60606,0.9,0.60606,0.92,0.60606,0.94,0.60606,0.96,0.60606,0.98,0.60606,0.99609,0.60606,0.00391,0.62121,0.02,0.62121,0.04,0.62121,0.06,0.62121,0.08,0.62121,0.1,0.62121,0.12,0.62121,0.14,0.62121,0.16,0.62121};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_22()
		{
			double[] value = {0.18,0.62121,0.2,0.62121,0.22,0.62121,0.24,0.62121,0.26,0.62121,0.28,0.62121,0.3,0.62121,0.32,0.62121,0.34,0.62121,0.36,0.62121,0.38,0.62121,0.4,0.62121,0.42,0.62121,0.44,0.62121,0.46,0.62121,0.48,0.62121,0.5,0.62121,0.52,0.62121,0.54,0.62121,0.56,0.62121,0.58,0.62121,0.6,0.62121,0.62,0.62121,0.64,0.62121,0.66,0.62121,0.68,0.62121,0.7,0.62121,0.72,0.62121,0.74,0.62121,0.76,0.62121,0.78,0.62121,0.8,0.62121,0.82,0.62121,0.84,0.62121,0.86,0.62121,0.88,0.62121,0.9,0.62121,0.92,0.62121,0.94,0.62121,0.96,0.62121,0.98,0.62121,0.99609,0.62121,0.00391,0.63636,0.02,0.63636,0.04,0.63636,0.06,0.63636,0.08,0.63636,0.1,0.63636,0.12,0.63636,0.14,0.63636,0.16,0.63636,0.18,0.63636,0.2,0.63636,0.22,0.63636,0.24,0.63636,0.26,0.63636,0.28,0.63636,0.3,0.63636,0.32,0.63636,0.34,0.63636,0.36,0.63636,0.38,0.63636,0.4,0.63636,0.42,0.63636,0.44,0.63636,0.46,0.63636,0.48,0.63636,0.5,0.63636,0.52,0.63636,0.54,0.63636,0.56,0.63636,0.58,0.63636,0.6,0.63636,0.62,0.63636,0.64,0.63636,0.66,0.63636,0.68,0.63636,0.7,0.63636,0.72,0.63636,0.74,0.63636,0.76,0.63636,0.78,0.63636,0.8,0.63636,0.82,0.63636,0.84,0.63636,0.86,0.63636,0.88,0.63636,0.9,0.63636,0.92,0.63636,0.94,0.63636,0.96,0.63636,0.98,0.63636,0.99609,0.63636,0.00391,0.65152,0.02,0.65152,0.04,0.65152,0.06,0.65152,0.08,0.65152,0.1,0.65152,0.12,0.65152};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_23()
		{
			double[] value = {0.14,0.65152,0.16,0.65152,0.18,0.65152,0.2,0.65152,0.22,0.65152,0.24,0.65152,0.26,0.65152,0.28,0.65152,0.3,0.65152,0.32,0.65152,0.34,0.65152,0.36,0.65152,0.38,0.65152,0.4,0.65152,0.42,0.65152,0.44,0.65152,0.46,0.65152,0.48,0.65152,0.5,0.65152,0.52,0.65152,0.54,0.65152,0.56,0.65152,0.58,0.65152,0.6,0.65152,0.62,0.65152,0.64,0.65152,0.66,0.65152,0.68,0.65152,0.7,0.65152,0.72,0.65152,0.74,0.65152,0.76,0.65152,0.78,0.65152,0.8,0.65152,0.82,0.65152,0.84,0.65152,0.86,0.65152,0.88,0.65152,0.9,0.65152,0.92,0.65152,0.94,0.65152,0.96,0.65152,0.98,0.65152,0.99609,0.65152,0.00391,0.66667,0.02,0.66667,0.04,0.66667,0.06,0.66667,0.08,0.66667,0.1,0.66667,0.12,0.66667,0.14,0.66667,0.16,0.66667,0.18,0.66667,0.2,0.66667,0.22,0.66667,0.24,0.66667,0.26,0.66667,0.28,0.66667,0.3,0.66667,0.32,0.66667,0.34,0.66667,0.36,0.66667,0.38,0.66667,0.4,0.66667,0.42,0.66667,0.44,0.66667,0.46,0.66667,0.48,0.66667,0.5,0.66667,0.52,0.66667,0.54,0.66667,0.56,0.66667,0.58,0.66667,0.6,0.66667,0.62,0.66667,0.64,0.66667,0.66,0.66667,0.68,0.66667,0.7,0.66667,0.72,0.66667,0.74,0.66667,0.76,0.66667,0.78,0.66667,0.8,0.66667,0.82,0.66667,0.84,0.66667,0.86,0.66667,0.88,0.66667,0.9,0.66667,0.92,0.66667,0.94,0.66667,0.96,0.66667,0.98,0.66667,0.99609,0.66667,0.00391,0.68182,0.02,0.68182,0.04,0.68182,0.06,0.68182,0.08,0.68182};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_24()
		{
			double[] value = {0.1,0.68182,0.12,0.68182,0.14,0.68182,0.16,0.68182,0.18,0.68182,0.2,0.68182,0.22,0.68182,0.24,0.68182,0.26,0.68182,0.28,0.68182,0.3,0.68182,0.32,0.68182,0.34,0.68182,0.36,0.68182,0.38,0.68182,0.4,0.68182,0.42,0.68182,0.44,0.68182,0.46,0.68182,0.48,0.68182,0.5,0.68182,0.52,0.68182,0.54,0.68182,0.56,0.68182,0.58,0.68182,0.6,0.68182,0.62,0.68182,0.64,0.68182,0.66,0.68182,0.68,0.68182,0.7,0.68182,0.72,0.68182,0.74,0.68182,0.76,0.68182,0.78,0.68182,0.8,0.68182,0.82,0.68182,0.84,0.68182,0.86,0.68182,0.88,0.68182,0.9,0.68182,0.92,0.68182,0.94,0.68182,0.96,0.68182,0.98,0.68182,0.99609,0.68182,0.00391,0.69697,0.02,0.69697,0.04,0.69697,0.06,0.69697,0.08,0.69697,0.1,0.69697,0.12,0.69697,0.14,0.69697,0.16,0.69697,0.18,0.69697,0.2,0.69697,0.22,0.69697,0.24,0.69697,0.26,0.69697,0.28,0.69697,0.3,0.69697,0.32,0.69697,0.34,0.69697,0.36,0.69697,0.38,0.69697,0.4,0.69697,0.42,0.69697,0.44,0.69697,0.46,0.69697,0.48,0.69697,0.5,0.69697,0.52,0.69697,0.54,0.69697,0.56,0.69697,0.58,0.69697,0.6,0.69697,0.62,0.69697,0.64,0.69697,0.66,0.69697,0.68,0.69697,0.7,0.69697,0.72,0.69697,0.74,0.69697,0.76,0.69697,0.78,0.69697,0.8,0.69697,0.82,0.69697,0.84,0.69697,0.86,0.69697,0.88,0.69697,0.9,0.69697,0.92,0.69697,0.94,0.69697,0.96,0.69697,0.98,0.69697,0.99609,0.69697,0.00391,0.71212,0.02,0.71212,0.04,0.71212};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_25()
		{
			double[] value = {0.06,0.71212,0.08,0.71212,0.1,0.71212,0.12,0.71212,0.14,0.71212,0.16,0.71212,0.18,0.71212,0.2,0.71212,0.22,0.71212,0.24,0.71212,0.26,0.71212,0.28,0.71212,0.3,0.71212,0.32,0.71212,0.34,0.71212,0.36,0.71212,0.38,0.71212,0.4,0.71212,0.42,0.71212,0.44,0.71212,0.46,0.71212,0.48,0.71212,0.5,0.71212,0.52,0.71212,0.54,0.71212,0.56,0.71212,0.58,0.71212,0.6,0.71212,0.62,0.71212,0.64,0.71212,0.66,0.71212,0.68,0.71212,0.7,0.71212,0.72,0.71212,0.74,0.71212,0.76,0.71212,0.78,0.71212,0.8,0.71212,0.82,0.71212,0.84,0.71212,0.86,0.71212,0.88,0.71212,0.9,0.71212,0.92,0.71212,0.94,0.71212,0.96,0.71212,0.98,0.71212,0.99609,0.71212,0.00391,0.72727,0.02,0.72727,0.04,0.72727,0.06,0.72727,0.08,0.72727,0.1,0.72727,0.12,0.72727,0.14,0.72727,0.16,0.72727,0.18,0.72727,0.2,0.72727,0.22,0.72727,0.24,0.72727,0.26,0.72727,0.28,0.72727,0.3,0.72727,0.32,0.72727,0.34,0.72727,0.36,0.72727,0.38,0.72727,0.4,0.72727,0.42,0.72727,0.44,0.72727,0.46,0.72727,0.48,0.72727,0.5,0.72727,0.52,0.72727,0.54,0.72727,0.56,0.72727,0.58,0.72727,0.6,0.72727,0.62,0.72727,0.64,0.72727,0.66,0.72727,0.68,0.72727,0.7,0.72727,0.72,0.72727,0.74,0.72727,0.76,0.72727,0.78,0.72727,0.8,0.72727,0.82,0.72727,0.84,0.72727,0.86,0.72727,0.88,0.72727,0.9,0.72727,0.92,0.72727,0.94,0.72727,0.96,0.72727,0.98,0.72727,0.99609,0.72727,0.00391,0.74242};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_26()
		{
			double[] value = {0.02,0.74242,0.04,0.74242,0.06,0.74242,0.08,0.74242,0.1,0.74242,0.12,0.74242,0.14,0.74242,0.16,0.74242,0.18,0.74242,0.2,0.74242,0.22,0.74242,0.24,0.74242,0.26,0.74242,0.28,0.74242,0.3,0.74242,0.32,0.74242,0.34,0.74242,0.36,0.74242,0.38,0.74242,0.4,0.74242,0.42,0.74242,0.44,0.74242,0.46,0.74242,0.48,0.74242,0.5,0.74242,0.52,0.74242,0.54,0.74242,0.56,0.74242,0.58,0.74242,0.6,0.74242,0.62,0.74242,0.64,0.74242,0.66,0.74242,0.68,0.74242,0.7,0.74242,0.72,0.74242,0.74,0.74242,0.76,0.74242,0.78,0.74242,0.8,0.74242,0.82,0.74242,0.84,0.74242,0.86,0.74242,0.88,0.74242,0.9,0.74242,0.92,0.74242,0.94,0.74242,0.96,0.74242,0.98,0.74242,0.99609,0.74242,0.00391,0.75758,0.02,0.75758,0.04,0.75758,0.06,0.75758,0.08,0.75758,0.1,0.75758,0.12,0.75758,0.14,0.75758,0.16,0.75758,0.18,0.75758,0.2,0.75758,0.22,0.75758,0.24,0.75758,0.26,0.75758,0.28,0.75758,0.3,0.75758,0.32,0.75758,0.34,0.75758,0.36,0.75758,0.38,0.75758,0.4,0.75758,0.42,0.75758,0.44,0.75758,0.46,0.75758,0.48,0.75758,0.5,0.75758,0.52,0.75758,0.54,0.75758,0.56,0.75758,0.58,0.75758,0.6,0.75758,0.62,0.75758,0.64,0.75758,0.66,0.75758,0.68,0.75758,0.7,0.75758,0.72,0.75758,0.74,0.75758,0.76,0.75758,0.78,0.75758,0.8,0.75758,0.82,0.75758,0.84,0.75758,0.86,0.75758,0.88,0.75758,0.9,0.75758,0.92,0.75758,0.94,0.75758,0.96,0.75758,0.98,0.75758};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_27()
		{
			double[] value = {0.99609,0.75758,0.00391,0.77273,0.02,0.77273,0.04,0.77273,0.06,0.77273,0.08,0.77273,0.1,0.77273,0.12,0.77273,0.14,0.77273,0.16,0.77273,0.18,0.77273,0.2,0.77273,0.22,0.77273,0.24,0.77273,0.26,0.77273,0.28,0.77273,0.3,0.77273,0.32,0.77273,0.34,0.77273,0.36,0.77273,0.38,0.77273,0.4,0.77273,0.42,0.77273,0.44,0.77273,0.46,0.77273,0.48,0.77273,0.5,0.77273,0.52,0.77273,0.54,0.77273,0.56,0.77273,0.58,0.77273,0.6,0.77273,0.62,0.77273,0.64,0.77273,0.66,0.77273,0.68,0.77273,0.7,0.77273,0.72,0.77273,0.74,0.77273,0.76,0.77273,0.78,0.77273,0.8,0.77273,0.82,0.77273,0.84,0.77273,0.86,0.77273,0.88,0.77273,0.9,0.77273,0.92,0.77273,0.94,0.77273,0.96,0.77273,0.98,0.77273,0.99609,0.77273,0.00391,0.78788,0.02,0.78788,0.04,0.78788,0.06,0.78788,0.08,0.78788,0.1,0.78788,0.12,0.78788,0.14,0.78788,0.16,0.78788,0.18,0.78788,0.2,0.78788,0.22,0.78788,0.24,0.78788,0.26,0.78788,0.28,0.78788,0.3,0.78788,0.32,0.78788,0.34,0.78788,0.36,0.78788,0.38,0.78788,0.4,0.78788,0.42,0.78788,0.44,0.78788,0.46,0.78788,0.48,0.78788,0.5,0.78788,0.52,0.78788,0.54,0.78788,0.56,0.78788,0.58,0.78788,0.6,0.78788,0.62,0.78788,0.64,0.78788,0.66,0.78788,0.68,0.78788,0.7,0.78788,0.72,0.78788,0.74,0.78788,0.76,0.78788,0.78,0.78788,0.8,0.78788,0.82,0.78788,0.84,0.78788,0.86,0.78788,0.88,0.78788,0.9,0.78788,0.92,0.78788,0.94,0.78788};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_28()
		{
			double[] value = {0.96,0.78788,0.98,0.78788,0.99609,0.78788,0.00391,0.80303,0.02,0.80303,0.04,0.80303,0.06,0.80303,0.08,0.80303,0.1,0.80303,0.12,0.80303,0.14,0.80303,0.16,0.80303,0.18,0.80303,0.2,0.80303,0.22,0.80303,0.24,0.80303,0.26,0.80303,0.28,0.80303,0.3,0.80303,0.32,0.80303,0.34,0.80303,0.36,0.80303,0.38,0.80303,0.4,0.80303,0.42,0.80303,0.44,0.80303,0.46,0.80303,0.48,0.80303,0.5,0.80303,0.52,0.80303,0.54,0.80303,0.56,0.80303,0.58,0.80303,0.6,0.80303,0.62,0.80303,0.64,0.80303,0.66,0.80303,0.68,0.80303,0.7,0.80303,0.72,0.80303,0.74,0.80303,0.76,0.80303,0.78,0.80303,0.8,0.80303,0.82,0.80303,0.84,0.80303,0.86,0.80303,0.88,0.80303,0.9,0.80303,0.92,0.80303,0.94,0.80303,0.96,0.80303,0.98,0.80303,0.99609,0.80303,0.00391,0.81818,0.02,0.81818,0.04,0.81818,0.06,0.81818,0.08,0.81818,0.1,0.81818,0.12,0.81818,0.14,0.81818,0.16,0.81818,0.18,0.81818,0.2,0.81818,0.22,0.81818,0.24,0.81818,0.26,0.81818,0.28,0.81818,0.3,0.81818,0.32,0.81818,0.34,0.81818,0.36,0.81818,0.38,0.81818,0.4,0.81818,0.42,0.81818,0.44,0.81818,0.46,0.81818,0.48,0.81818,0.5,0.81818,0.52,0.81818,0.54,0.81818,0.56,0.81818,0.58,0.81818,0.6,0.81818,0.62,0.81818,0.64,0.81818,0.66,0.81818,0.68,0.81818,0.7,0.81818,0.72,0.81818,0.74,0.81818,0.76,0.81818,0.78,0.81818,0.8,0.81818,0.82,0.81818,0.84,0.81818,0.86,0.81818,0.88,0.81818,0.9,0.81818};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_29()
		{
			double[] value = {0.92,0.81818,0.94,0.81818,0.96,0.81818,0.98,0.81818,0.99609,0.81818,0.00391,0.83333,0.02,0.83333,0.04,0.83333,0.06,0.83333,0.08,0.83333,0.1,0.83333,0.12,0.83333,0.14,0.83333,0.16,0.83333,0.18,0.83333,0.2,0.83333,0.22,0.83333,0.24,0.83333,0.26,0.83333,0.28,0.83333,0.3,0.83333,0.32,0.83333,0.34,0.83333,0.36,0.83333,0.38,0.83333,0.4,0.83333,0.42,0.83333,0.44,0.83333,0.46,0.83333,0.48,0.83333,0.5,0.83333,0.52,0.83333,0.54,0.83333,0.56,0.83333,0.58,0.83333,0.6,0.83333,0.62,0.83333,0.64,0.83333,0.66,0.83333,0.68,0.83333,0.7,0.83333,0.72,0.83333,0.74,0.83333,0.76,0.83333,0.78,0.83333,0.8,0.83333,0.82,0.83333,0.84,0.83333,0.86,0.83333,0.88,0.83333,0.9,0.83333,0.92,0.83333,0.94,0.83333,0.96,0.83333,0.98,0.83333,0.99609,0.83333,0.00391,0.84848,0.02,0.84848,0.04,0.84848,0.06,0.84848,0.08,0.84848,0.1,0.84848,0.12,0.84848,0.14,0.84848,0.16,0.84848,0.18,0.84848,0.2,0.84848,0.22,0.84848,0.24,0.84848,0.26,0.84848,0.28,0.84848,0.3,0.84848,0.32,0.84848,0.34,0.84848,0.36,0.84848,0.38,0.84848,0.4,0.84848,0.42,0.84848,0.44,0.84848,0.46,0.84848,0.48,0.84848,0.5,0.84848,0.52,0.84848,0.54,0.84848,0.56,0.84848,0.58,0.84848,0.6,0.84848,0.62,0.84848,0.64,0.84848,0.66,0.84848,0.68,0.84848,0.7,0.84848,0.72,0.84848,0.74,0.84848,0.76,0.84848,0.78,0.84848,0.8,0.84848,0.82,0.84848,0.84,0.84848,0.86,0.84848};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_30()
		{
			double[] value = {0.88,0.84848,0.9,0.84848,0.92,0.84848,0.94,0.84848,0.96,0.84848,0.98,0.84848,0.99609,0.84848,0.00391,0.86364,0.02,0.86364,0.04,0.86364,0.06,0.86364,0.08,0.86364,0.1,0.86364,0.12,0.86364,0.14,0.86364,0.16,0.86364,0.18,0.86364,0.2,0.86364,0.22,0.86364,0.24,0.86364,0.26,0.86364,0.28,0.86364,0.3,0.86364,0.32,0.86364,0.34,0.86364,0.36,0.86364,0.38,0.86364,0.4,0.86364,0.42,0.86364,0.44,0.86364,0.46,0.86364,0.48,0.86364,0.5,0.86364,0.52,0.86364,0.54,0.86364,0.56,0.86364,0.58,0.86364,0.6,0.86364,0.62,0.86364,0.64,0.86364,0.66,0.86364,0.68,0.86364,0.7,0.86364,0.72,0.86364,0.74,0.86364,0.76,0.86364,0.78,0.86364,0.8,0.86364,0.82,0.86364,0.84,0.86364,0.86,0.86364,0.88,0.86364,0.9,0.86364,0.92,0.86364,0.94,0.86364,0.96,0.86364,0.98,0.86364,0.99609,0.86364,0.00391,0.87879,0.02,0.87879,0.04,0.87879,0.06,0.87879,0.08,0.87879,0.1,0.87879,0.12,0.87879,0.14,0.87879,0.16,0.87879,0.18,0.87879,0.2,0.87879,0.22,0.87879,0.24,0.87879,0.26,0.87879,0.28,0.87879,0.3,0.87879,0.32,0.87879,0.34,0.87879,0.36,0.87879,0.38,0.87879,0.4,0.87879,0.42,0.87879,0.44,0.87879,0.46,0.87879,0.48,0.87879,0.5,0.87879,0.52,0.87879,0.54,0.87879,0.56,0.87879,0.58,0.87879,0.6,0.87879,0.62,0.87879,0.64,0.87879,0.66,0.87879,0.68,0.87879,0.7,0.87879,0.72,0.87879,0.74,0.87879,0.76,0.87879,0.78,0.87879,0.8,0.87879,0.82,0.87879};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_31()
		{
			double[] value = {0.84,0.87879,0.86,0.87879,0.88,0.87879,0.9,0.87879,0.92,0.87879,0.94,0.87879,0.96,0.87879,0.98,0.87879,0.99609,0.87879,0.00391,0.89394,0.02,0.89394,0.04,0.89394,0.06,0.89394,0.08,0.89394,0.1,0.89394,0.12,0.89394,0.14,0.89394,0.16,0.89394,0.18,0.89394,0.2,0.89394,0.22,0.89394,0.24,0.89394,0.26,0.89394,0.28,0.89394,0.3,0.89394,0.32,0.89394,0.34,0.89394,0.36,0.89394,0.38,0.89394,0.4,0.89394,0.42,0.89394,0.44,0.89394,0.46,0.89394,0.48,0.89394,0.5,0.89394,0.52,0.89394,0.54,0.89394,0.56,0.89394,0.58,0.89394,0.6,0.89394,0.62,0.89394,0.64,0.89394,0.66,0.89394,0.68,0.89394,0.7,0.89394,0.72,0.89394,0.74,0.89394,0.76,0.89394,0.78,0.89394,0.8,0.89394,0.82,0.89394,0.84,0.89394,0.86,0.89394,0.88,0.89394,0.9,0.89394,0.92,0.89394,0.94,0.89394,0.96,0.89394,0.98,0.89394,0.99609,0.89394,0.00391,0.90909,0.02,0.90909,0.04,0.90909,0.06,0.90909,0.08,0.90909,0.1,0.90909,0.12,0.90909,0.14,0.90909,0.16,0.90909,0.18,0.90909,0.2,0.90909,0.22,0.90909,0.24,0.90909,0.26,0.90909,0.28,0.90909,0.3,0.90909,0.32,0.90909,0.34,0.90909,0.36,0.90909,0.38,0.90909,0.4,0.90909,0.42,0.90909,0.44,0.90909,0.46,0.90909,0.48,0.90909,0.5,0.90909,0.52,0.90909,0.54,0.90909,0.56,0.90909,0.58,0.90909,0.6,0.90909,0.62,0.90909,0.64,0.90909,0.66,0.90909,0.68,0.90909,0.7,0.90909,0.72,0.90909,0.74,0.90909,0.76,0.90909,0.78,0.90909};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_32()
		{
			double[] value = {0.8,0.90909,0.82,0.90909,0.84,0.90909,0.86,0.90909,0.88,0.90909,0.9,0.90909,0.92,0.90909,0.94,0.90909,0.96,0.90909,0.98,0.90909,0.99609,0.90909,0.00391,0.92424,0.02,0.92424,0.04,0.92424,0.06,0.92424,0.08,0.92424,0.1,0.92424,0.12,0.92424,0.14,0.92424,0.16,0.92424,0.18,0.92424,0.2,0.92424,0.22,0.92424,0.24,0.92424,0.26,0.92424,0.28,0.92424,0.3,0.92424,0.32,0.92424,0.34,0.92424,0.36,0.92424,0.38,0.92424,0.4,0.92424,0.42,0.92424,0.44,0.92424,0.46,0.92424,0.48,0.92424,0.5,0.92424,0.52,0.92424,0.54,0.92424,0.56,0.92424,0.58,0.92424,0.6,0.92424,0.62,0.92424,0.64,0.92424,0.66,0.92424,0.68,0.92424,0.7,0.92424,0.72,0.92424,0.74,0.92424,0.76,0.92424,0.78,0.92424,0.8,0.92424,0.82,0.92424,0.84,0.92424,0.86,0.92424,0.88,0.92424,0.9,0.92424,0.92,0.92424,0.94,0.92424,0.96,0.92424,0.98,0.92424,0.99609,0.92424,0.00391,0.93939,0.02,0.93939,0.04,0.93939,0.06,0.93939,0.08,0.93939,0.1,0.93939,0.12,0.93939,0.14,0.93939,0.16,0.93939,0.18,0.93939,0.2,0.93939,0.22,0.93939,0.24,0.93939,0.26,0.93939,0.28,0.93939,0.3,0.93939,0.32,0.93939,0.34,0.93939,0.36,0.93939,0.38,0.93939,0.4,0.93939,0.42,0.93939,0.44,0.93939,0.46,0.93939,0.48,0.93939,0.5,0.93939,0.52,0.93939,0.54,0.93939,0.56,0.93939,0.58,0.93939,0.6,0.93939,0.62,0.93939,0.64,0.93939,0.66,0.93939,0.68,0.93939,0.7,0.93939,0.72,0.93939,0.74,0.93939};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_33()
		{
			double[] value = {0.76,0.93939,0.78,0.93939,0.8,0.93939,0.82,0.93939,0.84,0.93939,0.86,0.93939,0.88,0.93939,0.9,0.93939,0.92,0.93939,0.94,0.93939,0.96,0.93939,0.98,0.93939,0.99609,0.93939,0.00391,0.95455,0.02,0.95455,0.04,0.95455,0.06,0.95455,0.08,0.95455,0.1,0.95455,0.12,0.95455,0.14,0.95455,0.16,0.95455,0.18,0.95455,0.2,0.95455,0.22,0.95455,0.24,0.95455,0.26,0.95455,0.28,0.95455,0.3,0.95455,0.32,0.95455,0.34,0.95455,0.36,0.95455,0.38,0.95455,0.4,0.95455,0.42,0.95455,0.44,0.95455,0.46,0.95455,0.48,0.95455,0.5,0.95455,0.52,0.95455,0.54,0.95455,0.56,0.95455,0.58,0.95455,0.6,0.95455,0.62,0.95455,0.64,0.95455,0.66,0.95455,0.68,0.95455,0.7,0.95455,0.72,0.95455,0.74,0.95455,0.76,0.95455,0.78,0.95455,0.8,0.95455,0.82,0.95455,0.84,0.95455,0.86,0.95455,0.88,0.95455,0.9,0.95455,0.92,0.95455,0.94,0.95455,0.96,0.95455,0.98,0.95455,0.99609,0.95455,0.00391,0.9697,0.02,0.9697,0.04,0.9697,0.06,0.9697,0.08,0.9697,0.1,0.9697,0.12,0.9697,0.14,0.9697,0.16,0.9697,0.18,0.9697,0.2,0.9697,0.22,0.9697,0.24,0.9697,0.26,0.9697,0.28,0.9697,0.3,0.9697,0.32,0.9697,0.34,0.9697,0.36,0.9697,0.38,0.9697,0.4,0.9697,0.42,0.9697,0.44,0.9697,0.46,0.9697,0.48,0.9697,0.5,0.9697,0.52,0.9697,0.54,0.9697,0.56,0.9697,0.58,0.9697,0.6,0.9697,0.62,0.9697,0.64,0.9697,0.66,0.9697,0.68,0.9697,0.7,0.9697};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_34()
		{
			double[] value = {0.72,0.9697,0.74,0.9697,0.76,0.9697,0.78,0.9697,0.8,0.9697,0.82,0.9697,0.84,0.9697,0.86,0.9697,0.88,0.9697,0.9,0.9697,0.92,0.9697,0.94,0.9697,0.96,0.9697,0.98,0.9697,0.99609,0.9697,0.00391,0.98485,0.02,0.98485,0.04,0.98485,0.06,0.98485,0.08,0.98485,0.1,0.98485,0.12,0.98485,0.14,0.98485,0.16,0.98485,0.18,0.98485,0.2,0.98485,0.22,0.98485,0.24,0.98485,0.26,0.98485,0.28,0.98485,0.3,0.98485,0.32,0.98485,0.34,0.98485,0.36,0.98485,0.38,0.98485,0.4,0.98485,0.42,0.98485,0.44,0.98485,0.46,0.98485,0.48,0.98485,0.5,0.98485,0.52,0.98485,0.54,0.98485,0.56,0.98485,0.58,0.98485,0.6,0.98485,0.62,0.98485,0.64,0.98485,0.66,0.98485,0.68,0.98485,0.7,0.98485,0.72,0.98485,0.74,0.98485,0.76,0.98485,0.78,0.98485,0.8,0.98485,0.82,0.98485,0.84,0.98485,0.86,0.98485,0.88,0.98485,0.9,0.98485,0.92,0.98485,0.94,0.98485,0.96,0.98485,0.98,0.98485,0.99609,0.98485,0.00391,0.99609,0.02,0.99609,0.04,0.99609,0.06,0.99609,0.08,0.99609,0.1,0.99609,0.12,0.99609,0.14,0.99609,0.16,0.99609,0.18,0.99609,0.2,0.99609,0.22,0.99609,0.24,0.99609,0.26,0.99609,0.28,0.99609,0.3,0.99609,0.32,0.99609,0.34,0.99609,0.36,0.99609,0.38,0.99609,0.4,0.99609,0.42,0.99609,0.44,0.99609,0.46,0.99609,0.48,0.99609,0.5,0.99609,0.52,0.99609,0.54,0.99609,0.56,0.99609,0.58,0.99609,0.6,0.99609,0.62,0.99609,0.64,0.99609,0.66,0.99609};
			return value;
		}
		private double[] getTextureCoordinate_6_21_point_35()
		{
			double[] value = {0.68,0.99609,0.7,0.99609,0.72,0.99609,0.74,0.99609,0.76,0.99609,0.78,0.99609,0.8,0.99609,0.82,0.99609,0.84,0.99609,0.86,0.99609,0.88,0.99609,0.9,0.99609,0.92,0.99609,0.94,0.99609,0.96,0.99609,0.98,0.99609,0.99609,0.99609};
			return value;
		}

		/** Large attribute array: GeoElevationGrid height field, scene-graph level=5, element #20, 3417 total numbers.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFDouble getGeoElevationGrid_5_20_height()
		{
			MFDouble GeoElevationGrid_5_20_height = new MFDouble()/*2.finalize*/
				.append(new MFDouble(getGeoElevationGrid_5_20_height_1()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_2()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_3()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_4()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_5()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_6()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_7()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_8()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_9()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_10()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_11()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_12()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_13()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_14()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_15()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_16()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_17()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_18()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_19()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_20()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_21()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_22()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_23()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_24()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_25()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_26()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_27()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_28()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_29()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_30()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_31()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_32()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_33()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_34()))
				.append(new MFDouble(getGeoElevationGrid_5_20_height_35()));
			return GeoElevationGrid_5_20_height;
		}
		/** Large attribute array: TextureCoordinate point field, scene-graph level=6, element #21, 6834 total numbers made up of 3417 2-tuple values.
		 * Reassemble split array as single method to improve readability and runnability.
		 * Provide large array values via separate methods, hoping to avoid 'code too large' Java compilation errors. 
		 * Individual Java methods (including aggregated initializations) are limited to 64KB.
		 * @see https://stackoverflow.com/questions/2407912/code-too-large-compilation-error-in-java
		 * @see https://stackoverflow.com/questions/11437905/java-too-many-constants-jvm-error
		 */
		private MFVec2f getTextureCoordinate_6_21_point()
		{
			MFVec2f TextureCoordinate_6_21_point = new MFVec2f()/*2.finalize*/
				.append(new MFVec2f(getTextureCoordinate_6_21_point_1()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_2()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_3()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_4()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_5()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_6()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_7()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_8()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_9()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_10()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_11()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_12()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_13()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_14()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_15()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_16()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_17()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_18()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_19()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_20()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_21()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_22()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_23()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_24()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_25()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_26()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_27()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_28()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_29()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_30()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_31()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_32()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_33()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_34()))
				.append(new MFVec2f(getTextureCoordinate_6_21_point_35()));
			return TextureCoordinate_6_21_point;
		}

	/** The initialized model object, created within initialize() method. */
	private X3D x3dModel;

	/** 
	 * Provide a 
	 * <a href="https://dzone.com/articles/java-copy-shallow-vs-deep-in-which-you-will-swim" target="_blank">shallow copy</a>
	 * of the X3D model.
	 * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html">X3D</a>
	 * @return SquawLOD023 model
	 */
	public X3D getX3dModel()
	{	  
		return x3dModel;
	}
	   
    /** 
     * Default main() method provided for test purposes, uses CommandLine to set global ConfigurationProperties for this object.
     * @param args array of input parameters, provided as arguments
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#handleArguments-java.lang.String:A-">X3D.handleArguments(args)</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/Core/X3D.html#validationReport--">X3D.validationReport()</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html">CommandLine</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/CommandLine.html#USAGE">CommandLine.USAGE</a>
     * @see <a href="https://www.web3d.org/specifications/java/javadoc/org/web3d/x3d/jsail/ConfigurationProperties.html">ConfigurationProperties</a>
     */
    public static void main(String args[])
    {
        System.out.println("Build this X3D model, showing validation diagnostics...");
        X3D thisExampleX3dModel = new SquawLOD023().getX3dModel();
//      System.out.println("X3D model construction complete.");
	
        // next handle command line arguments
        boolean hasArguments = (args != null) && (args.length > 0);
        boolean validate = true; // default
        boolean argumentsLoadNewModel = false;
        String  fileName = new String();

        if (args != null)
        {
                for (String arg : args)
                {
                        if (arg.toLowerCase().startsWith("-v") || arg.toLowerCase().contains("validate"))
                        {
                                validate = true; // making sure
                        }
                        if (arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3D) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_CLASSICVRML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_X3DB) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_VRML97) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_EXI) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_GZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_ZIP) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_HTML) ||
                                arg.toLowerCase().endsWith(X3D.FILE_EXTENSION_XHTML))
                        {
                                argumentsLoadNewModel = true;
                                fileName = arg;
                        }
                }
        }
        if      (argumentsLoadNewModel)
                System.out.println("WARNING: \"Basic.Geospatial.SquawLOD023\" model invocation is attempting to load file \"" + fileName + "\" instead of simply validating itself... file loading ignored.");
        else if (hasArguments) // if no arguments provided, this method produces usage warning
                thisExampleX3dModel.handleArguments(args);
	
        if (validate)
        {
            //  System.out.println("--- TODO fix duplicated outputs ---"); // omit when duplicated outputs problem is solved/refactored
		String validationResults = thisExampleX3dModel.validationReport();
            //  System.out.println("-----------------------------------"); // omit when duplicated outputs problem is solved/refactored
                System.out.print("Basic.Geospatial.SquawLOD023 self-validation test confirmation: ");
                if (!validationResults.equals("success"))
                    System.out.println();
                System.out.println(validationResults.trim());

                // experimental: test X3DJSAIL output files
                // Geospatial/SquawLOD023_JavaExport.* file validation is checked when building X3D Example Archives
                String filenameX3D  = "Geospatial/SquawLOD023_JavaExport.x3d"; 
                String filenameX3DV = "Geospatial/SquawLOD023_JavaExport.x3dv"; 
                String filenameJSON = "Geospatial/SquawLOD023_JavaExport.json";
                thisExampleX3dModel.toFileX3D        (filenameX3D);
                thisExampleX3dModel.toFileClassicVRML(filenameX3DV);
// TODO         thisExampleX3dModel.toFileJSON       (filenameJSON);
        }
    }
}
