####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD022.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD022.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD022.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD022.x3d'),
    GeoLOD(center=(4344113.536173,741821.999947,1970),child1Url=["SquawLOD023.x3d","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/squawLOD023.x3d"],geoSystem=["UTM","Z10","N"],range=16133.333,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw011.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw011.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4343332.077840,741212.999947,0),geoSystem=["UTM","Z10","N"],height=[1878.1666,1877.1666,1876.1583,1876.0,1874.8334,1872.9542,1869.8334,1869.0,1869.0,1869.0,1869.0,1869.0,1868.0,1866.125,1865.0,1859.975,1853.9,1851.0,1860.75,1877.3,1906.3667,1936.6833,1962.0333,1981.2291,2000.4667,1881.0938,1880.0938,1879.0891,1877.0938,1876.8187,1875.725,1868.3,1865.0,1866.9531,1867.9602,1868.9062,1869.0,1868.0,1867.0,1865.0,1860.9524,1854.8093,1851.0,1858.1562,1876.2063,1903.8125,1927.6179,1953.3265,1969.9727,1987.2188,1884.0591,1884.0591,1883.0591,1881.9341,1880.0591,1878.0428,1872.7474,1865.0,1865.0,1866.0,1867.0,1868.0,1868.0,1867.0,1865.1061,1861.9514,1854.9,1851.0,1857.75,1872.6692,1889.2826,1912.3069,1933.632,1956.404,1974.6819,1888.0219,1888.0243,1888.0243,1887.0212,1884.8243,1881.0176,1877.65,1867.1743,1864.4878,1865.0,1865.6342,1867.0,1868.0,1867.0,1866.0,1862.975,1855.9,1851.0,1857.0,1877.3243,1905.4437,1926.4979,1934.6472,1953.5486,1972.1486,1895.9791,1895.9791,1893.9896,1891.9883,1888.7896,1883.725,1878.65,1870.15,1864.4948,1864.0,1865.0,1866.0,1867.0,1867.0,1866.0,1864.95,1854.8,1851.0,1857.7422,1877.625,1910.7896,1940.8292,1959.0573,1967.4648,1986.3656,1906.9097,1904.9109,1901.9049,1896.9944,1891.8,1885.725,1879.6342,1872.575,1866.4548,1864.0,1863.6952,1865.0,1865.0452,1868.0,1867.0,1864.975,1852.8046,1851.175,1862.4436,1877.625,1913.1549,1950.2561,1979.0946,1992.3541,1997.5646,1916.9403,1910.9452,1906.8701,1900.865,1894.7201,1887.725,1882.5702,1876.4951,1871.9601,1867.3451,1862.4298,1858.4127,1861.9597,1867.9448,1868.046,1864.975,1852.8,1851.336,1867.4001,1890.9286,1920.6403,1957.7201,2001.7104,2017.6007,2014.9806,1928.7677,1920.7958,1914.7208,1908.5209,1899.6854,1893.4644,1888.4609,1883.9695,1876.3854,1871.9341,1867.2355,1862.6273,1853.0292,1863.9791,1868.8911,1862.0396,1851.0,1859.7404,1885.4062,1911.0894,1934.2562,1969.9313,2014.2078,2037.3242,2033.1417,1946.5028,1940.4277,1936.0542,1926.0221,1917.8535,1907.9374,1900.202,1894.2764,1884.776,1875.9142,1871.2007,1867.1257,1854.7222,1851.1306,1860.6465,1854.2449,1851.185,1868.4789,1904.6901,1930.5021,1958.8445,1996.7549,2031.1855,2050.121,2047.3014,1971.0143,1964.1049,1958.0299,1951.9548,1945.843,1935.3458,1923.3799,1910.0671,1893.132,1879.666,1873.166,1869.0,1865.2,1852.918,1851.0,1851.0,1856.132,1884.4657,1921.1259,1951.7406,1996.1438,2031.2404,2060.8506,2065.6318,2059.232,1996.225,1989.9313,1983.5984,1977.9727,1970.3313,1961.3562,1943.5125,1923.1055,1899.8906,1882.7242,1873.35,1868.275,1862.7937,1852.3438,1851.0,1851.8063,1863.1594,1899.4547,1948.8594,1996.9578,2036.9563,2065.14,2079.8735,2079.3867,2068.3157,2012.0115,2009.2645,2004.8988,2000.0829,1991.6903,1976.511,1947.7648,1924.4458,1901.0,1883.85,1871.3035,1862.9872,1853.8562,1851.0,1851.9873,1856.7778,1865.7,1902.925,1952.2673,1989.8036,2027.2195,2065.965,2088.3965,2091.148,2079.8396,2026.783,2024.4486,2016.338,2006.661,1994.4882,1975.1089,1946.3508,1920.5881,1900.2882,1883.275,1868.05,1856.0339,1851.0,1851.964,1854.95,1859.7368,1864.5,1894.1632,1924.0087,1958.8514,1997.7493,2044.5776,2084.3584,2099.8198,2093.0237,2032.7771,2026.025,2014.2229,2000.3959,1989.7229,1969.2709,1940.2458,1916.6229,1896.8229,1880.5979,1865.813,1855.3638,1851.0,1853.5924,1856.0,1861.025,1868.8906,1889.7872,1917.8959,1952.1409,2000.548,2045.9221,2075.7964,2092.3684,2095.9229,2031.4576,2022.05,2006.8179,1991.3403,1978.6014,1955.8887,1932.6077,1914.3,1894.5,1876.0576,1861.0576,1851.6327,1851.8,1854.0,1855.3577,1860.025,1863.4576,1874.4153,1903.9835,1943.3989,1992.6438,2024.6882,2047.7958,2069.529,2085.4153,2023.7847,2019.4174,2007.4272,1989.5759,1975.0,1953.175,1928.6423,1908.343,1890.8923,1869.4847,1854.4847,1850.0,1850.8784,1852.0,1853.5773,1858.025,1858.8848,1866.336,1892.6771,1934.2296,1975.8757,1995.8618,2024.146,2050.677,2069.0618,2015.3698,2015.4271,2010.85,1994.1979,1975.0,1952.327,1921.4766,1900.1542,1879.2812,1856.8354,1852.0,1849.275,1850.0,1851.875,1854.9786,1853.0,1853.2,1862.35,1880.6771,1917.37,1942.6771,1977.1792,2011.4692,2035.7812,2047.8093,2008.4618,2009.4618,2006.8005,1993.5577,1973.2618,1945.2736,1914.5234,1889.4891,1867.6545,1848.85,1849.4618,1847.852,1849.8,1852.9423,1853.4888,1853.0,1853.1,1861.2559,1876.7118,1900.5486,1930.539,1967.2487,1998.4777,2018.3859,2025.009,2003.5966,2004.0125,2000.95,1988.556,1965.2896,1937.983,1907.5431,1881.5825,1857.493,1847.211,1844.4966,1845.725,1850.8,1853.938,1853.0,1853.0,1852.1,1859.35,1872.3724,1891.7864,1922.0951,1957.8146,1982.7361,1993.6111,1998.6862,1997.5844,1999.5312,1997.3812,1980.5625,1951.4875,1927.6875,1902.7812,1877.875,1852.7656,1843.1555,1841.65,1846.5789,1852.6937,1854.0,1853.0,1852.0,1852.0,1856.8812,1869.1797,1891.4727,1918.4625,1944.4938,1960.225,1970.3438,1976.4812,1993.466,1993.1428,1988.4442,1967.5139,1940.2451,1918.466,1895.364,1875.4409,1850.5659,1840.425,1841.65,1848.0397,1853.0,1853.125,1853.0,1851.0,1851.1,1854.784,1865.0095,1889.4181,1909.468,1928.1688,1945.65,1965.4271,1987.102,1988.9601,1988.6007,1977.0115,1951.227,1927.882,1907.8264,1889.3405,1870.0764,1849.1007,1840.0,1842.65,1849.0145,1853.0,1853.0,1853.0,1850.0,1852.0,1859.4199,1875.0999,1902.0243,1923.3986,1937.2236,1955.398,1976.4484,1995.4993,1982.599,1980.6854,1964.4172,1942.0898,1919.7625,1898.0854,1883.713,1864.9354,1846.8177,1840.0,1842.65,1848.725,1853.0,1853.0,1852.05,1850.025,1852.1,1861.6508,1877.6146,1902.2604,1926.6,1945.9628,1967.4791,1987.2291,2004.8938,1976.5702,1978.025,1960.4202,1937.0864,1912.6702,1893.8451,1879.9701,1862.5848,1847.1649,1840.0,1841.65,1846.3951,1851.4701,1851.6702,1849.0,1850.025,1852.0,1862.525,1883.5798,1907.2847,1927.1278,1947.9,1974.2,1995.2487,2014.9608,1971.2097,1977.0176,1961.0803,1935.9548,1909.7639,1893.175,1877.95,1863.4254,1848.6476,1840.1255,1840.65,1843.9188,1847.5049,1846.0,1848.0,1850.025,1852.1,1870.3419,1892.8854,1914.7943,1933.8951,1956.4902,1977.4951,1996.6107,2017.8,1964.1052,1975.7645,1960.5896,1936.4779,1909.148,1892.3784,1879.3,1865.725,1849.5,1842.5356,1840.0,1842.5363,1844.5917,1845.875,1848.0,1850.025,1852.174,1878.1354,1904.0209,1927.0813,1949.0938,1967.9417,1987.5745,2004.9062,2020.3605,1959.0486,1967.3286,1954.6243,1934.8268,1907.0,1890.388,1879.3,1865.725,1850.1128,1843.6506,1840.0,1841.5614,1843.8,1845.875,1848.0,1850.025,1853.7,1884.2756,1909.9193,1941.4524,1964.0514,1982.2441,1999.4243,2011.605,2018.9486,1947.7552,1957.4473,1945.4585,1925.2852,1902.209,1888.259,1877.8259,1864.725,1850.5955,1845.425,1840.35,1840.0,1842.8,1845.0,1848.0,1851.0,1853.5809,1881.843,1911.2612,1941.9801,1969.209,1979.9021,1983.5951,1992.2952,2003.6361,1931.9906,1943.5062,1934.4875,1915.3125,1897.4437,1884.45,1874.8484,1863.6351,1851.5781,1846.9398,1842.35,1840.0,1842.0,1844.875,1848.95,1851.1774,1858.2,1872.5437,1901.1875,1930.6375,1957.5125,1958.1125,1957.4563,1966.7812,1980.775,1915.1139,1929.7289,1924.613,1908.5034,1892.2784,1880.3285,1871.1785,1862.5233,1853.0608,1848.0516,1843.35,1840.0,1840.9757,1844.0,1848.95,1853.025,1860.2,1873.8003,1900.6216,1926.221,1935.2709,1930.3208,1930.4255,1936.8854,1957.3138,1895.3615,1908.6006,1916.7808,1904.4241,1886.5826,1875.7012,1867.2131,1860.5381,1853.5,1848.425,1844.0,1840.0,1840.0,1844.0,1848.0,1852.0228,1862.2087,1881.1354,1905.5435,1910.5377,1906.1139,1906.1691,1915.0132,1923.5056,1936.8396,1878.5542,1889.7688,1907.9979,1901.5,1882.5896,1871.1229,1862.65,1857.9779,1852.5,1848.425,1843.35,1840.0,1840.0,1843.875,1847.95,1851.0,1861.3531,1884.4117,1886.8307,1884.8086,1892.7479,1903.95,1909.0193,1915.5209,1921.5437,1876.4364,1874.9153,1898.1805,1898.4827,1878.3827,1866.45,1860.65,1855.575,1851.4913,1847.425,1843.35,1840.0,1840.8,1844.0151,1848.0,1850.025,1853.2792,1869.2805,1871.6979,1871.5918,1885.7549,1897.4138,1901.1078,1905.9718,1904.7826],solid=False,xDimension=25,xSpacing=50.750000,zDimension=33,zSpacing=50.416667,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.04167,0.00391),(0.08333,0.00391),(0.125,0.00391),(0.16667,0.00391),(0.20833,0.00391),(0.25,0.00391),(0.29167,0.00391),(0.33333,0.00391),(0.375,0.00391),(0.41667,0.00391),(0.45833,0.00391),(0.5,0.00391),(0.54167,0.00391),(0.58333,0.00391),(0.625,0.00391),(0.66667,0.00391),(0.70833,0.00391),(0.75,0.00391),(0.79167,0.00391),(0.83333,0.00391),(0.875,0.00391),(0.91667,0.00391),(0.95833,0.00391),(0.99609,0.00391),(0.00391,0.03125),(0.04167,0.03125),(0.08333,0.03125),(0.125,0.03125),(0.16667,0.03125),(0.20833,0.03125),(0.25,0.03125),(0.29167,0.03125),(0.33333,0.03125),(0.375,0.03125),(0.41667,0.03125),(0.45833,0.03125),(0.5,0.03125),(0.54167,0.03125),(0.58333,0.03125),(0.625,0.03125),(0.66667,0.03125),(0.70833,0.03125),(0.75,0.03125),(0.79167,0.03125),(0.83333,0.03125),(0.875,0.03125),(0.91667,0.03125),(0.95833,0.03125),(0.99609,0.03125),(0.00391,0.0625),(0.04167,0.0625),(0.08333,0.0625),(0.125,0.0625),(0.16667,0.0625),(0.20833,0.0625),(0.25,0.0625),(0.29167,0.0625),(0.33333,0.0625),(0.375,0.0625),(0.41667,0.0625),(0.45833,0.0625),(0.5,0.0625),(0.54167,0.0625),(0.58333,0.0625),(0.625,0.0625),(0.66667,0.0625),(0.70833,0.0625),(0.75,0.0625),(0.79167,0.0625),(0.83333,0.0625),(0.875,0.0625),(0.91667,0.0625),(0.95833,0.0625),(0.99609,0.0625),(0.00391,0.09375),(0.04167,0.09375),(0.08333,0.09375),(0.125,0.09375),(0.16667,0.09375),(0.20833,0.09375),(0.25,0.09375),(0.29167,0.09375),(0.33333,0.09375),(0.375,0.09375),(0.41667,0.09375),(0.45833,0.09375),(0.5,0.09375),(0.54167,0.09375),(0.58333,0.09375),(0.625,0.09375),(0.66667,0.09375),(0.70833,0.09375),(0.75,0.09375),(0.79167,0.09375),(0.83333,0.09375),(0.875,0.09375),(0.91667,0.09375),(0.95833,0.09375),(0.99609,0.09375),(0.00391,0.125),(0.04167,0.125),(0.08333,0.125),(0.125,0.125),(0.16667,0.125),(0.20833,0.125),(0.25,0.125),(0.29167,0.125),(0.33333,0.125),(0.375,0.125),(0.41667,0.125),(0.45833,0.125),(0.5,0.125),(0.54167,0.125),(0.58333,0.125),(0.625,0.125),(0.66667,0.125),(0.70833,0.125),(0.75,0.125),(0.79167,0.125),(0.83333,0.125),(0.875,0.125),(0.91667,0.125),(0.95833,0.125),(0.99609,0.125),(0.00391,0.15625),(0.04167,0.15625),(0.08333,0.15625),(0.125,0.15625),(0.16667,0.15625),(0.20833,0.15625),(0.25,0.15625),(0.29167,0.15625),(0.33333,0.15625),(0.375,0.15625),(0.41667,0.15625),(0.45833,0.15625),(0.5,0.15625),(0.54167,0.15625),(0.58333,0.15625),(0.625,0.15625),(0.66667,0.15625),(0.70833,0.15625),(0.75,0.15625),(0.79167,0.15625),(0.83333,0.15625),(0.875,0.15625),(0.91667,0.15625),(0.95833,0.15625),(0.99609,0.15625),(0.00391,0.1875),(0.04167,0.1875),(0.08333,0.1875),(0.125,0.1875),(0.16667,0.1875),(0.20833,0.1875),(0.25,0.1875),(0.29167,0.1875),(0.33333,0.1875),(0.375,0.1875),(0.41667,0.1875),(0.45833,0.1875),(0.5,0.1875),(0.54167,0.1875),(0.58333,0.1875),(0.625,0.1875),(0.66667,0.1875),(0.70833,0.1875),(0.75,0.1875),(0.79167,0.1875),(0.83333,0.1875),(0.875,0.1875),(0.91667,0.1875),(0.95833,0.1875),(0.99609,0.1875),(0.00391,0.21875),(0.04167,0.21875),(0.08333,0.21875),(0.125,0.21875),(0.16667,0.21875),(0.20833,0.21875),(0.25,0.21875),(0.29167,0.21875),(0.33333,0.21875),(0.375,0.21875),(0.41667,0.21875),(0.45833,0.21875),(0.5,0.21875),(0.54167,0.21875),(0.58333,0.21875),(0.625,0.21875),(0.66667,0.21875),(0.70833,0.21875),(0.75,0.21875),(0.79167,0.21875),(0.83333,0.21875),(0.875,0.21875),(0.91667,0.21875),(0.95833,0.21875),(0.99609,0.21875),(0.00391,0.25),(0.04167,0.25),(0.08333,0.25),(0.125,0.25),(0.16667,0.25),(0.20833,0.25),(0.25,0.25),(0.29167,0.25),(0.33333,0.25),(0.375,0.25),(0.41667,0.25),(0.45833,0.25),(0.5,0.25),(0.54167,0.25),(0.58333,0.25),(0.625,0.25),(0.66667,0.25),(0.70833,0.25),(0.75,0.25),(0.79167,0.25),(0.83333,0.25),(0.875,0.25),(0.91667,0.25),(0.95833,0.25),(0.99609,0.25),(0.00391,0.28125),(0.04167,0.28125),(0.08333,0.28125),(0.125,0.28125),(0.16667,0.28125),(0.20833,0.28125),(0.25,0.28125),(0.29167,0.28125),(0.33333,0.28125),(0.375,0.28125),(0.41667,0.28125),(0.45833,0.28125),(0.5,0.28125),(0.54167,0.28125),(0.58333,0.28125),(0.625,0.28125),(0.66667,0.28125),(0.70833,0.28125),(0.75,0.28125),(0.79167,0.28125),(0.83333,0.28125),(0.875,0.28125),(0.91667,0.28125),(0.95833,0.28125),(0.99609,0.28125),(0.00391,0.3125),(0.04167,0.3125),(0.08333,0.3125),(0.125,0.3125),(0.16667,0.3125),(0.20833,0.3125),(0.25,0.3125),(0.29167,0.3125),(0.33333,0.3125),(0.375,0.3125),(0.41667,0.3125),(0.45833,0.3125),(0.5,0.3125),(0.54167,0.3125),(0.58333,0.3125),(0.625,0.3125),(0.66667,0.3125),(0.70833,0.3125),(0.75,0.3125),(0.79167,0.3125),(0.83333,0.3125),(0.875,0.3125),(0.91667,0.3125),(0.95833,0.3125),(0.99609,0.3125),(0.00391,0.34375),(0.04167,0.34375),(0.08333,0.34375),(0.125,0.34375),(0.16667,0.34375),(0.20833,0.34375),(0.25,0.34375),(0.29167,0.34375),(0.33333,0.34375),(0.375,0.34375),(0.41667,0.34375),(0.45833,0.34375),(0.5,0.34375),(0.54167,0.34375),(0.58333,0.34375),(0.625,0.34375),(0.66667,0.34375),(0.70833,0.34375),(0.75,0.34375),(0.79167,0.34375),(0.83333,0.34375),(0.875,0.34375),(0.91667,0.34375),(0.95833,0.34375),(0.99609,0.34375),(0.00391,0.375),(0.04167,0.375),(0.08333,0.375),(0.125,0.375),(0.16667,0.375),(0.20833,0.375),(0.25,0.375),(0.29167,0.375),(0.33333,0.375),(0.375,0.375),(0.41667,0.375),(0.45833,0.375),(0.5,0.375),(0.54167,0.375),(0.58333,0.375),(0.625,0.375),(0.66667,0.375),(0.70833,0.375),(0.75,0.375),(0.79167,0.375),(0.83333,0.375),(0.875,0.375),(0.91667,0.375),(0.95833,0.375),(0.99609,0.375),(0.00391,0.40625),(0.04167,0.40625),(0.08333,0.40625),(0.125,0.40625),(0.16667,0.40625),(0.20833,0.40625),(0.25,0.40625),(0.29167,0.40625),(0.33333,0.40625),(0.375,0.40625),(0.41667,0.40625),(0.45833,0.40625),(0.5,0.40625),(0.54167,0.40625),(0.58333,0.40625),(0.625,0.40625),(0.66667,0.40625),(0.70833,0.40625),(0.75,0.40625),(0.79167,0.40625),(0.83333,0.40625),(0.875,0.40625),(0.91667,0.40625),(0.95833,0.40625),(0.99609,0.40625),(0.00391,0.4375),(0.04167,0.4375),(0.08333,0.4375),(0.125,0.4375),(0.16667,0.4375),(0.20833,0.4375),(0.25,0.4375),(0.29167,0.4375),(0.33333,0.4375),(0.375,0.4375),(0.41667,0.4375),(0.45833,0.4375),(0.5,0.4375),(0.54167,0.4375),(0.58333,0.4375),(0.625,0.4375),(0.66667,0.4375),(0.70833,0.4375),(0.75,0.4375),(0.79167,0.4375),(0.83333,0.4375),(0.875,0.4375),(0.91667,0.4375),(0.95833,0.4375),(0.99609,0.4375),(0.00391,0.46875),(0.04167,0.46875),(0.08333,0.46875),(0.125,0.46875),(0.16667,0.46875),(0.20833,0.46875),(0.25,0.46875),(0.29167,0.46875),(0.33333,0.46875),(0.375,0.46875),(0.41667,0.46875),(0.45833,0.46875),(0.5,0.46875),(0.54167,0.46875),(0.58333,0.46875),(0.625,0.46875),(0.66667,0.46875),(0.70833,0.46875),(0.75,0.46875),(0.79167,0.46875),(0.83333,0.46875),(0.875,0.46875),(0.91667,0.46875),(0.95833,0.46875),(0.99609,0.46875),(0.00391,0.5),(0.04167,0.5),(0.08333,0.5),(0.125,0.5),(0.16667,0.5),(0.20833,0.5),(0.25,0.5),(0.29167,0.5),(0.33333,0.5),(0.375,0.5),(0.41667,0.5),(0.45833,0.5),(0.5,0.5),(0.54167,0.5),(0.58333,0.5),(0.625,0.5),(0.66667,0.5),(0.70833,0.5),(0.75,0.5),(0.79167,0.5),(0.83333,0.5),(0.875,0.5),(0.91667,0.5),(0.95833,0.5),(0.99609,0.5),(0.00391,0.53125),(0.04167,0.53125),(0.08333,0.53125),(0.125,0.53125),(0.16667,0.53125),(0.20833,0.53125),(0.25,0.53125),(0.29167,0.53125),(0.33333,0.53125),(0.375,0.53125),(0.41667,0.53125),(0.45833,0.53125),(0.5,0.53125),(0.54167,0.53125),(0.58333,0.53125),(0.625,0.53125),(0.66667,0.53125),(0.70833,0.53125),(0.75,0.53125),(0.79167,0.53125),(0.83333,0.53125),(0.875,0.53125),(0.91667,0.53125),(0.95833,0.53125),(0.99609,0.53125),(0.00391,0.5625),(0.04167,0.5625),(0.08333,0.5625),(0.125,0.5625),(0.16667,0.5625),(0.20833,0.5625),(0.25,0.5625),(0.29167,0.5625),(0.33333,0.5625),(0.375,0.5625),(0.41667,0.5625),(0.45833,0.5625),(0.5,0.5625),(0.54167,0.5625),(0.58333,0.5625),(0.625,0.5625),(0.66667,0.5625),(0.70833,0.5625),(0.75,0.5625),(0.79167,0.5625),(0.83333,0.5625),(0.875,0.5625),(0.91667,0.5625),(0.95833,0.5625),(0.99609,0.5625),(0.00391,0.59375),(0.04167,0.59375),(0.08333,0.59375),(0.125,0.59375),(0.16667,0.59375),(0.20833,0.59375),(0.25,0.59375),(0.29167,0.59375),(0.33333,0.59375),(0.375,0.59375),(0.41667,0.59375),(0.45833,0.59375),(0.5,0.59375),(0.54167,0.59375),(0.58333,0.59375),(0.625,0.59375),(0.66667,0.59375),(0.70833,0.59375),(0.75,0.59375),(0.79167,0.59375),(0.83333,0.59375),(0.875,0.59375),(0.91667,0.59375),(0.95833,0.59375),(0.99609,0.59375),(0.00391,0.625),(0.04167,0.625),(0.08333,0.625),(0.125,0.625),(0.16667,0.625),(0.20833,0.625),(0.25,0.625),(0.29167,0.625),(0.33333,0.625),(0.375,0.625),(0.41667,0.625),(0.45833,0.625),(0.5,0.625),(0.54167,0.625),(0.58333,0.625),(0.625,0.625),(0.66667,0.625),(0.70833,0.625),(0.75,0.625),(0.79167,0.625),(0.83333,0.625),(0.875,0.625),(0.91667,0.625),(0.95833,0.625),(0.99609,0.625),(0.00391,0.65625),(0.04167,0.65625),(0.08333,0.65625),(0.125,0.65625),(0.16667,0.65625),(0.20833,0.65625),(0.25,0.65625),(0.29167,0.65625),(0.33333,0.65625),(0.375,0.65625),(0.41667,0.65625),(0.45833,0.65625),(0.5,0.65625),(0.54167,0.65625),(0.58333,0.65625),(0.625,0.65625),(0.66667,0.65625),(0.70833,0.65625),(0.75,0.65625),(0.79167,0.65625),(0.83333,0.65625),(0.875,0.65625),(0.91667,0.65625),(0.95833,0.65625),(0.99609,0.65625),(0.00391,0.6875),(0.04167,0.6875),(0.08333,0.6875),(0.125,0.6875),(0.16667,0.6875),(0.20833,0.6875),(0.25,0.6875),(0.29167,0.6875),(0.33333,0.6875),(0.375,0.6875),(0.41667,0.6875),(0.45833,0.6875),(0.5,0.6875),(0.54167,0.6875),(0.58333,0.6875),(0.625,0.6875),(0.66667,0.6875),(0.70833,0.6875),(0.75,0.6875),(0.79167,0.6875),(0.83333,0.6875),(0.875,0.6875),(0.91667,0.6875),(0.95833,0.6875),(0.99609,0.6875),(0.00391,0.71875),(0.04167,0.71875),(0.08333,0.71875),(0.125,0.71875),(0.16667,0.71875),(0.20833,0.71875),(0.25,0.71875),(0.29167,0.71875),(0.33333,0.71875),(0.375,0.71875),(0.41667,0.71875),(0.45833,0.71875),(0.5,0.71875),(0.54167,0.71875),(0.58333,0.71875),(0.625,0.71875),(0.66667,0.71875),(0.70833,0.71875),(0.75,0.71875),(0.79167,0.71875),(0.83333,0.71875),(0.875,0.71875),(0.91667,0.71875),(0.95833,0.71875),(0.99609,0.71875),(0.00391,0.75),(0.04167,0.75),(0.08333,0.75),(0.125,0.75),(0.16667,0.75),(0.20833,0.75),(0.25,0.75),(0.29167,0.75),(0.33333,0.75),(0.375,0.75),(0.41667,0.75),(0.45833,0.75),(0.5,0.75),(0.54167,0.75),(0.58333,0.75),(0.625,0.75),(0.66667,0.75),(0.70833,0.75),(0.75,0.75),(0.79167,0.75),(0.83333,0.75),(0.875,0.75),(0.91667,0.75),(0.95833,0.75),(0.99609,0.75),(0.00391,0.78125),(0.04167,0.78125),(0.08333,0.78125),(0.125,0.78125),(0.16667,0.78125),(0.20833,0.78125),(0.25,0.78125),(0.29167,0.78125),(0.33333,0.78125),(0.375,0.78125),(0.41667,0.78125),(0.45833,0.78125),(0.5,0.78125),(0.54167,0.78125),(0.58333,0.78125),(0.625,0.78125),(0.66667,0.78125),(0.70833,0.78125),(0.75,0.78125),(0.79167,0.78125),(0.83333,0.78125),(0.875,0.78125),(0.91667,0.78125),(0.95833,0.78125),(0.99609,0.78125),(0.00391,0.8125),(0.04167,0.8125),(0.08333,0.8125),(0.125,0.8125),(0.16667,0.8125),(0.20833,0.8125),(0.25,0.8125),(0.29167,0.8125),(0.33333,0.8125),(0.375,0.8125),(0.41667,0.8125),(0.45833,0.8125),(0.5,0.8125),(0.54167,0.8125),(0.58333,0.8125),(0.625,0.8125),(0.66667,0.8125),(0.70833,0.8125),(0.75,0.8125),(0.79167,0.8125),(0.83333,0.8125),(0.875,0.8125),(0.91667,0.8125),(0.95833,0.8125),(0.99609,0.8125),(0.00391,0.84375),(0.04167,0.84375),(0.08333,0.84375),(0.125,0.84375),(0.16667,0.84375),(0.20833,0.84375),(0.25,0.84375),(0.29167,0.84375),(0.33333,0.84375),(0.375,0.84375),(0.41667,0.84375),(0.45833,0.84375),(0.5,0.84375),(0.54167,0.84375),(0.58333,0.84375),(0.625,0.84375),(0.66667,0.84375),(0.70833,0.84375),(0.75,0.84375),(0.79167,0.84375),(0.83333,0.84375),(0.875,0.84375),(0.91667,0.84375),(0.95833,0.84375),(0.99609,0.84375),(0.00391,0.875),(0.04167,0.875),(0.08333,0.875),(0.125,0.875),(0.16667,0.875),(0.20833,0.875),(0.25,0.875),(0.29167,0.875),(0.33333,0.875),(0.375,0.875),(0.41667,0.875),(0.45833,0.875),(0.5,0.875),(0.54167,0.875),(0.58333,0.875),(0.625,0.875),(0.66667,0.875),(0.70833,0.875),(0.75,0.875),(0.79167,0.875),(0.83333,0.875),(0.875,0.875),(0.91667,0.875),(0.95833,0.875),(0.99609,0.875),(0.00391,0.90625),(0.04167,0.90625),(0.08333,0.90625),(0.125,0.90625),(0.16667,0.90625),(0.20833,0.90625),(0.25,0.90625),(0.29167,0.90625),(0.33333,0.90625),(0.375,0.90625),(0.41667,0.90625),(0.45833,0.90625),(0.5,0.90625),(0.54167,0.90625),(0.58333,0.90625),(0.625,0.90625),(0.66667,0.90625),(0.70833,0.90625),(0.75,0.90625),(0.79167,0.90625),(0.83333,0.90625),(0.875,0.90625),(0.91667,0.90625),(0.95833,0.90625),(0.99609,0.90625),(0.00391,0.9375),(0.04167,0.9375),(0.08333,0.9375),(0.125,0.9375),(0.16667,0.9375),(0.20833,0.9375),(0.25,0.9375),(0.29167,0.9375),(0.33333,0.9375),(0.375,0.9375),(0.41667,0.9375),(0.45833,0.9375),(0.5,0.9375),(0.54167,0.9375),(0.58333,0.9375),(0.625,0.9375),(0.66667,0.9375),(0.70833,0.9375),(0.75,0.9375),(0.79167,0.9375),(0.83333,0.9375),(0.875,0.9375),(0.91667,0.9375),(0.95833,0.9375),(0.99609,0.9375),(0.00391,0.96875),(0.04167,0.96875),(0.08333,0.96875),(0.125,0.96875),(0.16667,0.96875),(0.20833,0.96875),(0.25,0.96875),(0.29167,0.96875),(0.33333,0.96875),(0.375,0.96875),(0.41667,0.96875),(0.45833,0.96875),(0.5,0.96875),(0.54167,0.96875),(0.58333,0.96875),(0.625,0.96875),(0.66667,0.96875),(0.70833,0.96875),(0.75,0.96875),(0.79167,0.96875),(0.83333,0.96875),(0.875,0.96875),(0.91667,0.96875),(0.95833,0.96875),(0.99609,0.96875),(0.00391,0.99609),(0.04167,0.99609),(0.08333,0.99609),(0.125,0.99609),(0.16667,0.99609),(0.20833,0.99609),(0.25,0.99609),(0.29167,0.99609),(0.33333,0.99609),(0.375,0.99609),(0.41667,0.99609),(0.45833,0.99609),(0.5,0.99609),(0.54167,0.99609),(0.58333,0.99609),(0.625,0.99609),(0.66667,0.99609),(0.70833,0.99609),(0.75,0.99609),(0.79167,0.99609),(0.83333,0.99609),(0.875,0.99609),(0.91667,0.99609),(0.95833,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD022.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD022.py load and self-test diagnostics complete.")
