####################################################################################################
#
# Invoking X3D model self-test:
#
#   $ python SquawLOD021.py
#
# Python package x3d.py package is available on PyPI for import.
#   This approach simplifies Python X3D deployment and use.
#   https://pypi.org/project/x3d
#
# Installation:
#       pip install x3d
# or
#       python -m pip install x3d
#
# Developer options for loading x3d package in other Python programs:
#
#    from x3d import *  # preferred approach, terser source that avoids x3d.* class prefixes
#
# or
#    import x3d         # traditional way to subclass x3d package, all classes require x3d.* prefix,
#                       # but python source is very verbose, for example x3d.Material x3d.Shape etc.
#                       # X3dToPython.xslt stylesheet insertPackagePrefix=true supports this option.
#
####################################################################################################

from x3d import *

newModel=X3D(profile='Immersive',version='3.3',
  head=head(
    children=[
    component(level=1,name='Geospatial'),
    meta(content='SquawLOD021.x3d',name='title'),
    meta(content='ESRI GeoVRML export subscene of Squaw Valley California USA.',name='description'),
    meta(content='Salvador Bayarri, ESRI',name='creator'),
    meta(content='Don Brutzman',name='translator'),
    meta(content='22 April 2003',name='translated'),
    meta(content='20 January 2020',name='modified'),
    meta(content='http://www.geovrml.org/examples',name='reference'),
    meta(content='X3D geospatial example',name='subject'),
    meta(content='https://www.web3d.org/x3d/content/examples/Basic/Geospatial/SquawLOD021.x3d',name='identifier'),
    meta(content='Vrml97ToX3dNist, http://ovrt.nist.gov/v2_x3d.html',name='generator'),
    meta(content='X3D-Edit 3.3, https://savage.nps.edu/X3D-Edit',name='generator'),
    meta(content='../license.html',name='license')]),
  Scene=Scene(
    children=[
    WorldInfo(title='SquawLOD021.x3d'),
    GeoLOD(center=(4342525.411173,741821.999947,1974.5),geoSystem=["UTM","Z10","N"],range=0.0,
      geoOrigin=GeoOrigin(DEF='ORIGIN',geoCoords=(4342525.5,740604,0),geoSystem=["UTM","Z10","N"],rotateYUp=True),
      rootNode=[
      Shape(
        appearance=Appearance(
          material=Material(ambientIntensity=0.9,diffuseColor=(1.0,1.0,1.0),shininess=1.0),
          texture=ImageTexture(url=["images/squaw010.jpg","https://www.web3d.org/x3d/content/examples/Basic/Geospatial/images/squaw010.jpg"])),
        geometry=GeoElevationGrid(ccw=False,creaseAngle=0.5,geoGridOrigin=(4341718.744506,741212.999947,0),geoSystem=["UTM","Z10","N"],height=[2022.8849,2017.1704,2013.1409,2009.4592,2006.5544,2003.7625,2002.0,2001.0404,2000.612,2000.0,1997.3225,1990.608,1988.7104,1984.2554,1971.6576,1956.6425,1946.2145,1937.376,1932.504,1927.6584,1923.9226,1919.7776,1916.3505,1913.9144,1911.4784,1908.3685,1904.7268,1901.328,1899.7345,1897.456,1896.8456,1894.4265,1892.9672,1890.5544,1888.1184,1886.3649,1880.1483,1876.0,1876.0,1876.9191,1878.4976,1880.1223,1882.212,1884.648,1887.084,1890.122,1899.824,1909.568,1921.14,1935.2041,1947.5,2025.5778,2020.0853,2015.2914,2010.792,2007.356,2003.92,2001.2062,1998.7703,1998.0564,1996.3427,1994.1844,1991.0262,1989.4949,1985.4285,1972.972,1958.0778,1947.496,1939.064,1933.7817,1929.816,1926.6578,1923.2218,1919.6492,1916.3497,1913.9138,1910.4,1905.5935,1901.9338,1900.1698,1899.1267,1898.0056,1896.8618,1895.6625,1894.8334,1895.3123,1893.3022,1886.6149,1876.2689,1876.0,1876.0,1877.2456,1878.4982,1880.3651,1883.648,1886.7456,1889.04,1898.8118,1908.8511,1920.968,1934.0422,1946.2222,2028.0222,2021.328,2016.2416,2011.7343,2008.1771,2003.84,1999.6184,1996.3258,1992.7173,1990.6045,1989.2955,1987.5555,1985.3282,1979.8516,1971.2567,1958.4822,1947.496,1938.376,1934.504,1930.7649,1928.38,1925.9285,1921.7383,1915.7316,1913.9138,1910.4,1907.4862,1904.5355,1902.3665,1900.7222,1899.7422,1899.6067,1899.6812,1900.7324,1903.1685,1902.5178,1897.2272,1886.1733,1877.1527,1876.0,1876.0,1876.8383,1879.643,1883.296,1886.084,1888.6644,1897.824,1907.8458,1920.198,1932.3337,1944.4778,2029.3,2022.328,2016.5847,2011.792,2008.356,2003.84,1999.484,1995.096,1990.0574,1985.176,1982.3633,1979.804,1978.258,1974.2693,1965.4846,1956.0734,1946.3293,1937.688,1934.462,1931.816,1929.38,1927.1573,1924.606,1915.6213,1912.106,1911.3334,1910.3334,1909.6614,1908.392,1906.0466,1904.6833,1903.6666,1905.3767,1906.5,1907.2126,1905.1666,1903.5707,1896.34,1884.55,1876.4547,1876.0,1876.776,1879.5553,1882.756,1886.084,1888.52,1896.824,1906.8947,1918.002,1930.2947,1944.95,2029.3,2021.9222,2017.456,2011.792,2008.356,2003.8889,1999.968,1995.096,1990.224,1984.352,1978.6089,1973.3857,1971.0347,1966.2947,1959.7657,1953.0688,1943.8849,1936.688,1934.252,1931.816,1929.38,1927.9783,1926.508,1920.4382,1915.0807,1914.8334,1915.4445,1916.3169,1915.4445,1914.6218,1914.4445,1913.4445,1912.8334,1912.0463,1910.7798,1908.4512,1905.0151,1901.8275,1888.2711,1877.384,1876.0,1877.2502,1880.3416,1883.648,1886.084,1889.04,1896.868,1906.8075,1917.2451,1928.5374,1946.6945,2030.4055,2023.4204,2019.5116,2012.6836,2009.4115,2006.82,2002.0522,1998.159,1993.0027,1986.4271,1979.3722,1972.6804,1967.604,1961.7844,1954.9363,1948.6244,1941.3164,1936.3378,1933.2104,1929.7706,1928.91,1927.8884,1926.4797,1922.1644,1923.8188,1927.9,1927.1111,1926.1294,1926.003,1924.1666,1925.1111,1923.7506,1920.4071,1916.4796,1914.3162,1910.8867,1906.8411,1901.872,1888.634,1876.3787,1876.0,1878.5951,1882.5352,1885.7231,1887.0555,1889.0956,1898.8795,1908.1978,1918.2416,1933.5133,1949.3112,2034.75,2028.328,2022.07,2016.98,2012.534,2009.88,2006.484,2003.048,1999.724,1992.204,1985.22,1976.912,1969.406,1960.364,1952.988,1946.4,1939.372,1935.532,1931.878,1928.224,1926.19,1925.5,1925.008,1923.572,1926.182,1929.1,1931.236,1931.664,1930.892,1930.0,1929.5,1927.168,1923.296,1918.568,1915.776,1912.26,1907.106,1901.84,1887.224,1876.048,1876.17,1880.052,1886.424,1890.324,1891.542,1894.54,1901.346,1910.372,1922.968,1938.452,1952.7,2040.039,2033.1982,2026.5729,2021.4729,2017.2646,2014.7289,2010.8569,2007.9369,2003.1685,1998.4169,1990.15,1982.1049,1973.3608,1962.704,1954.9285,1947.0956,1940.3164,1935.6707,1930.756,1925.8716,1924.4144,1923.9995,1923.0282,1923.928,1926.0,1927.0889,1929.2915,1932.0374,1932.898,1929.9978,1928.0566,1925.6395,1922.3516,1919.0,1916.276,1912.5289,1905.8304,1898.9493,1883.8992,1876.0,1876.34,1882.2725,1888.5804,1895.1849,1899.9127,1901.3534,1906.7013,1914.8608,1927.8569,1941.2644,1955.8445,2045.4277,2038.7698,2032.2338,2025.7506,2022.2722,2019.0555,2015.7457,2011.8738,2007.3757,2001.7408,1994.6089,1986.8756,1977.2498,1967.117,1957.3768,1949.0688,1942.6368,1936.376,1930.756,1925.816,1923.2322,1922.5769,1921.6111,1923.1343,1924.9751,1926.4889,1928.7029,1930.4106,1930.5452,1928.456,1926.0122,1922.779,1919.3702,1916.4991,1914.3296,1908.7422,1901.7985,1892.2969,1878.7782,1876.0,1877.2766,1884.7169,1891.5433,1899.3329,1903.4729,1906.1111,1911.3009,1919.4329,1930.5289,1944.1587,1958.7167,2050.95,2044.548,2037.3507,2032.1187,2028.0227,2024.5867,2020.6346,2016.7627,2011.8906,2005.1947,1997.67,1989.1653,1979.3274,1969.5613,1959.8213,1951.5133,1944.2053,1937.376,1931.3793,1925.816,1922.38,1921.1107,1920.1666,1921.0947,1923.4247,1925.8334,1928.0393,1929.112,1929.1487,1927.532,1925.02,1920.3347,1914.7527,1911.212,1907.822,1902.0466,1894.2827,1885.1787,1876.0886,1876.0,1878.8534,1886.2906,1893.5046,1900.944,1905.084,1908.44,1912.912,1921.0747,1932.1113,1945.54,1960.7333,2056.7556,2050.5476,2043.5173,2036.5675,2033.1893,2030.4177,2026.174,2021.6516,2015.6718,2009.2107,2000.1655,1990.3004,1979.7131,1970.296,1960.988,1952.8356,1945.6154,1939.064,1931.9637,1925.816,1921.9323,1918.6663,1917.7222,1918.98,1921.1874,1924.3223,1926.7877,1927.7222,1927.7222,1926.3293,1923.7678,1919.4684,1915.296,1907.5702,1900.5176,1892.4089,1884.3927,1878.0973,1876.0,1876.2511,1881.2977,1887.7676,1894.424,1900.764,1905.084,1909.04,1914.1776,1922.4537,1933.0157,1946.8618,1963.8778,2062.7166,2056.6792,2050.0652,2043.9707,2039.6216,2036.3422,2032.2692,2026.5751,2020.2804,2013.0214,2002.4222,1991.216,1980.4353,1970.608,1961.988,1954.4022,1947.0942,1939.8729,1933.2963,1926.3542,1921.6544,1916.2218,1915.7698,1917.2578,1918.3789,1920.9333,1923.7915,1925.2778,1926.0,1924.7338,1922.0111,1916.1395,1914.3188,1902.1956,1890.4911,1881.6311,1876.5022,1876.0,1876.0,1877.5569,1883.4022,1888.552,1894.424,1899.296,1904.168,1909.4155,1915.5902,1925.2902,1935.0342,1948.7747,1966.3223,2068.8,2062.772,2056.184,2049.7092,2044.0453,2041.24,2037.8174,2032.4773,2025.1693,2016.184,2004.6067,1991.6866,1981.6387,1972.4626,1964.1547,1956.48,1948.5387,1941.4907,1934.1327,1926.768,1920.8234,1914.888,1913.41,1914.8213,1914.7727,1916.4667,1919.0693,1921.6666,1922.8513,1925.164,1924.3667,1914.0173,1902.4933,1890.32,1878.8627,1876.0,1876.0,1876.0,1876.6346,1880.9746,1885.8467,1889.848,1896.722,1898.9813,1902.4187,1910.04,1916.824,1927.6333,1937.4786,1951.1373,1969.1666,2075.1333,2068.956,2062.6782,2056.2092,2049.763,2046.0623,2042.1902,2037.3182,2029.6702,2019.9946,2007.7633,1995.5564,1984.7456,1975.3391,1967.5991,1959.6333,1951.107,1943.064,1935.3671,1928.1306,1921.9922,1915.4991,1912.0,1912.3169,1912.0,1913.1888,1915.7167,1918.0609,1921.6049,1925.8765,1928.5911,1916.6991,1893.1427,1878.9667,1876.0,1876.0,1876.3643,1877.2543,1880.3651,1885.0303,1889.9022,1895.5502,1901.4342,1903.8702,1905.9827,1911.04,1916.824,1929.1996,1941.7631,1955.5422,1972.0945,2081.4666,2074.476,2068.5671,2063.7507,2059.823,2053.0579,2047.1346,2041.2551,2033.5035,2022.7137,2011.0566,1998.6311,1988.5276,1979.3756,1971.0436,1963.2644,1953.5515,1944.7693,1936.518,1929.5035,1923.1956,1917.8876,1912.5636,1910.1276,1909.9797,1911.7444,1913.1249,1914.9263,1918.0989,1924.4956,1928.9055,1917.0325,1891.4326,1876.0,1876.0,1877.2156,1879.7072,1882.1431,1885.0211,1888.0098,1894.1311,1901.3835,1905.5352,1908.7952,1912.1111,1913.1111,1916.9375,1931.3738,1945.968,1959.3347,1974.9556,2087.3,2080.992,2074.184,2070.188,2066.034,2060.8,2053.694,2045.168,2035.948,2024.38,2013.46,2002.02,1991.972,1982.228,1973.984,1964.68,1955.496,1946.252,1937.256,1931.04,1924.95,1919.388,1914.016,1911.072,1908.818,1908.9,1909.236,1911.0,1912.608,1915.588,1920.97,1911.796,1889.554,1876.0,1876.362,1879.66,1883.394,1887.032,1890.202,1894.808,1899.68,1905.328,1910.318,1913.972,1916.042,1917.52,1922.39,1930.44,1945.968,1959.848,1976.9,2093.0388,2085.8997,2080.345,2075.681,2072.6008,2066.5732,2057.8535,2048.1365,2037.06,2024.88,2013.96,2003.52,1993.4647,1983.136,1973.984,1965.24,1957.3234,1948.9911,1939.9385,1932.6218,1926.7256,1920.8849,1915.016,1912.0,1909.2367,1905.4889,1905.3472,1907.0929,1908.2191,1909.6552,1909.1855,1903.5352,1886.8202,1876.0,1876.724,1881.2644,1886.518,1891.9832,1899.1818,1902.7876,1906.55,1911.3854,1914.1127,1917.5369,1919.9729,1921.4645,1923.9004,1929.1578,1945.968,1959.3347,1973.3112,2096.55,2089.7168,2083.9841,2078.6648,2074.9624,2069.6,2059.452,2049.192,2037.06,2024.88,2013.96,2004.216,1993.34,1982.9489,1973.9856,1965.24,1957.7126,1951.1853,1942.3969,1934.9493,1929.1489,1923.2551,1917.1042,1912.4889,1909.272,1903.4,1902.2222,1903.8942,1904.6111,1904.6111,1903.2422,1890.3364,1883.055,1876.712,1876.724,1883.4445,1889.8126,1896.8738,1903.3248,1907.2343,1912.3256,1915.3018,1917.9073,1920.4258,1923.4729,1925.5911,1927.7338,1932.6693,1942.3622,1956.0924,1968.8389,2097.1833,2091.8254,2084.684,2078.4106,2072.986,2066.2466,2057.6726,2047.3187,2034.3933,2022.9,2013.1267,2003.3827,1993.472,1984.1293,1974.9873,1966.24,1958.372,1952.376,1944.6313,1937.2814,1930.9734,1924.8787,1919.8494,1914.9773,1911.1053,1905.4,1900.6367,1899.8933,1901.3334,1898.596,1888.7267,1884.5013,1880.4626,1876.712,1877.448,1885.4734,1892.958,1900.8973,1905.7693,1910.6414,1915.1733,1917.6094,1920.914,1923.4813,1926.9873,1931.1866,1933.6227,1935.124,1937.8226,1951.6533,1964.25,2097.8223,2091.3782,2083.4695,2074.7627,2064.49,2056.7068,2049.8337,2041.6232,2030.6122,2020.3773,2010.9423,2002.6343,1993.472,1984.296,1975.988,1967.24,1959.372,1952.8729,1945.756,1938.9098,1933.0377,1927.1658,1922.1527,1917.4017,1914.3732,1908.8778,1903.8058,1898.0751,1889.5842,1886.9004,1883.4789,1881.0284,1877.977,1875.5143,1878.4498,1887.5244,1895.0658,1902.0729,1906.936,1912.0858,1916.4344,1919.9916,1922.7018,1927.008,1931.747,1937.4512,1939.5433,1940.9423,1941.9391,1948.792,1959.2222,2092.2888,2088.2698,2080.2532,2068.9436,2057.7017,2047.6511,2042.1509,2036.6516,2026.1113,2017.2595,2008.31,2000.1898,1990.8818,1983.416,1975.9851,1967.24,1958.7394,1951.3418,1945.504,1939.7649,1934.14,1927.888,1923.016,1918.4017,1914.8126,1909.6,1904.528,1897.8267,1888.706,1882.7969,1877.8822,1876.2778,1875.4258,1875.0103,1880.6182,1888.48,1896.2184,1903.064,1907.936,1912.808,1917.5856,1921.7137,1925.1462,1930.4862,1936.6124,1940.2422,1943.6782,1946.8364,1949.9946,1951.9724,1958.0167,2080.2166,2081.5508,2075.3127,2064.9666,2054.4468,2043.58,2035.2853,2029.7627,2021.5027,2013.224,2003.7933,1994.8827,1986.2706,1980.0574,1973.6514,1965.2733,1957.0387,1949.8973,1944.3373,1939.632,1934.14,1928.888,1923.524,1917.204,1913.0447,1907.0667,1902.1553,1893.924,1886.3607,1879.6547,1875.8534,1874.0,1874.3087,1878.316,1884.7814,1890.6466,1897.8553,1904.064,1908.936,1913.9586,1918.8467,1923.7186,1928.5907,1934.1693,1939.2506,1943.12,1947.0786,1950.5587,1952.9946,1955.6506,1958.8167,2071.0278,2072.1667,2069.234,2060.9458,2051.0305,2041.6,2032.968,2025.5328,2017.8369,2008.9854,2000.3489,1989.9089,1981.3818,1975.0306,1969.7643,1961.4111,1952.6145,1945.9631,1941.1278,1937.4098,1932.5377,1928.2769,1922.2234,1915.5328,1908.6858,1902.1777,1894.9918,1888.5613,1882.5198,1877.0222,1874.0278,1875.0271,1878.5044,1884.6974,1890.1205,1894.9312,1900.05,1905.6752,1910.5471,1915.4191,1921.6945,1926.7742,1932.0352,1937.1222,1940.779,1944.6511,1949.5231,1952.1555,1954.506,1957.264,1960.3112,2064.639,2067.2063,2065.3877,2058.4316,2050.4795,2041.7356,2033.4807,2025.2449,2017.5035,2008.5934,2000.0155,1988.52,1978.472,1970.8324,1966.8809,1960.16,1949.4404,1939.9911,1931.7443,1926.6595,1925.8545,1924.6653,1918.3573,1911.0493,1903.7766,1894.5778,1887.0143,1882.1431,1878.7284,1875.4004,1875.0355,1878.9106,1884.6671,1890.6316,1894.5035,1899.3756,1903.866,1908.1752,1913.0211,1918.9138,1924.7911,1930.6506,1936.5233,1939.6676,1942.168,1946.5488,1950.912,1953.392,1955.828,1958.2787,1961.7,2059.3,2062.336,2064.114,2060.584,2053.424,2044.68,2035.194,2027.644,2019.948,2011.204,2001.96,1988.824,1976.972,1968.796,1962.49,1955.46,1946.496,1936.44,1925.382,1920.816,1919.69,1917.416,1912.024,1904.716,1896.362,1886.2,1877.41,1875.0,1875.446,1874.0,1877.47,1882.332,1888.63,1893.076,1897.224,1901.82,1906.692,1911.564,1916.436,1922.212,1928.18,1934.052,1939.212,1940.824,1943.584,1946.78,1950.434,1952.892,1956.242,1959.764,1963.25,2053.8167,2058.7644,2061.883,2062.54,2057.3486,2048.62,2038.3375,2029.1893,2020.8145,2012.6942,2001.7145,1989.4813,1977.2917,1967.1915,1958.0438,1950.7911,1941.607,1931.8458,1922.8115,1914.9827,1914.1111,1911.0547,1904.6907,1897.3827,1889.6552,1880.9111,1874.8196,1872.0929,1871.2131,1873.1133,1877.96,1885.1925,1890.6484,1895.5204,1900.3925,1904.2644,1909.1365,1913.9783,1917.936,1923.7524,1929.0011,1935.328,1939.9562,1941.648,1944.084,1946.52,1948.956,1951.784,1956.656,1961.2085,1966.9889,2048.4944,2053.8943,2058.766,2061.611,2058.5408,2050.149,2041.3248,2031.5809,2021.5989,2012.6355,2000.7,1989.4017,1977.472,1966.992,1956.5911,1945.1666,1934.9128,1925.0187,1917.9783,1911.6729,1906.7411,1902.7213,1897.6677,1891.0054,1883.5189,1876.1333,1872.842,1869.5284,1869.216,1873.5782,1879.9277,1887.864,1893.0929,1897.4,1901.5553,1906.32,1911.3491,1915.0444,1918.936,1923.808,1928.68,1935.328,1939.6936,1941.648,1944.0,1945.8378,1948.912,1952.784,1957.656,1962.1809,1969.4889,2041.1,2049.6147,2053.8774,2057.3333,2054.938,2049.7734,2041.1027,2032.192,2021.55,2011.704,1999.0834,1988.3827,1977.472,1966.728,1955.98,1942.92,1929.7866,1920.804,1913.5027,1909.768,1903.8234,1898.0547,1891.8573,1884.5493,1877.0146,1872.7,1869.9307,1867.4946,1870.9413,1874.8453,1884.4033,1891.596,1895.5374,1899.1213,1902.678,1907.32,1912.5287,1916.032,1918.936,1922.904,1927.13,1932.848,1938.3787,1939.8147,1941.3347,1945.52,1947.956,1952.176,1958.4894,1963.6254,1970.9333,2031.8389,2041.2329,2048.7107,2050.5022,2049.8005,2044.8467,2036.246,2028.5885,2020.1702,2010.4263,1997.6823,1987.216,1976.1942,1966.4502,1955.984,1942.92,1929.62,1918.752,1912.252,1908.4053,1903.76,1897.5138,1889.3873,1878.7324,1873.3583,1869.9222,1867.8951,1869.8995,1874.8015,1882.716,1891.5011,1895.9658,1899.4076,1901.5658,1904.5247,1908.5533,1912.596,1915.7543,1918.468,1921.6262,1925.0623,1929.0587,1933.0873,1936.6244,1939.252,1945.6934,1949.2216,1953.7316,1960.8096,1966.5382,1972.9556,2024.4333,2032.8413,2040.2126,2043.8911,2042.358,2035.9288,2030.5236,2024.6649,2016.0035,2006.2595,1995.2378,1985.4938,1974.7498,1965.0057,1955.2617,1942.92,1929.62,1919.752,1912.434,1907.816,1903.76,1896.7915,1886.8293,1875.4418,1870.5498,1867.3334,1869.3646,1875.0254,1884.0431,1891.5325,1896.4044,1900.976,1902.7222,1904.0103,1906.4462,1909.2045,1911.8738,1914.3098,1916.4078,1919.1124,1922.6178,1925.0538,1929.1327,1936.0182,1940.2286,1946.9066,1951.6343,1958.2284,1964.3304,1971.2365,1976.4222,2017.1,2026.508,2033.044,2035.708,2033.568,2028.34,2023.468,2017.636,2010.5027,2002.508,1992.96,1983.1,1972.472,1962.5613,1952.8167,1941.56,1928.474,1920.064,1912.756,1907.632,1902.76,1894.6094,1881.1514,1872.0493,1867.1053,1864.0333,1871.8767,1882.188,1891.2927,1895.8746,1901.1267,1903.5826,1905.0,1906.288,1907.6034,1908.8334,1909.6666,1911.5054,1912.7446,1915.6573,1920.6233,1923.776,1928.8026,1936.944,1942.3347,1948.1267,1954.0786,1961.3427,1968.6506,1974.6947,1978.9833,2011.3778,2019.9165,2025.7107,2028.1666,2025.8787,2020.3955,2015.1346,2010.8445,2005.8508,1999.3058,1992.1189,1982.9453,1971.472,1961.728,1950.98,1938.6289,1927.5442,1920.064,1913.504,1907.632,1901.9078,1892.7075,1876.7216,1869.6049,1864.8833,1863.0,1878.3191,1886.2991,1892.8271,1898.4204,1902.5911,1904.416,1905.9425,1906.2769,1905.8391,1905.6178,1903.5707,1905.2502,1911.143,1914.904,1919.68,1923.6392,1929.636,1936.944,1943.252,1949.56,1956.4791,1963.7871,1971.0951,1977.1392,1982.4388,2005.4889,2012.8782,2018.39,2020.5258,2017.5255,2012.6777,2009.4016,2006.9396,2002.19,1997.3422,1992.22,1984.5587,1973.3473,1962.728,1951.976,1937.2711,1928.496,1921.064,1913.518,1907.448,1901.14,1891.6609,1875.016,1868.216,1863.636,1866.3,1880.708,1887.7062,1893.3735,1899.632,1902.98,1904.9445,1904.9445,1903.9445,1902.9042,1900.88,1899.922,1903.0103,1910.3484,1914.904,1919.6244,1923.552,1929.636,1936.944,1943.252,1950.56,1957.868,1965.2316,1974.3215,1979.5427,1985.4556,1999.75,2006.508,2011.272,2011.292,2009.178,2007.46,2005.484,2003.548,2000.418,1996.264,1991.98,1986.912,1973.472,1962.728,1951.476,1938.24,1929.372,1921.408,1913.756,1907.04,1900.64,1891.108,1874.524,1867.216,1863.0,1868.5,1880.59,1887.516,1893.162,1898.588,1901.49,1902.5,1902.0,1900.212,1897.776,1895.34,1896.394,1901.564,1907.904,1913.308,1918.35,1923.552,1929.636,1936.296,1943.252,1950.56,1957.868,1966.176,1974.484,1981.16,1987.05,1993.9667,1998.8386,2001.9387,2002.2222,2002.1666,2002.1111,2001.1111,2000.1565,1997.6676,1994.4076,1991.74,1988.5525,1974.2917,1962.1915,1949.98,1938.24,1929.496,1921.752,1913.756,1905.6774,1898.5544,1889.555,1874.524,1867.216,1863.0,1869.0,1879.4851,1886.0342,1891.2716,1894.6298,1897.0911,1896.7506,1895.3147,1893.8787,1891.4426,1889.1111,1892.462,1900.096,1906.4336,1911.808,1918.02,1923.552,1929.636,1936.908,1943.252,1950.56,1957.868,1965.6018,1974.484,1982.7365,1988.3611,1986.6945,1991.1693,1993.7446,1995.3494,1995.8334,1995.8334,1994.9285,1993.1222,1991.4453,1989.7186,1989.6111,1988.4897,1978.1691,1964.9796,1951.538,1939.2356,1931.1498,1922.4529,1914.4651,1904.3765,1895.7511,1886.7742,1874.016,1867.5769,1863.636,1866.5,1877.786,1882.8275,1888.3302,1890.6111,1890.2222,1889.8334,1888.8334,1887.1102,1885.1094,1885.4445,1890.3992,1898.7267,1905.5471,1912.3231,1918.02,1924.328,1931.0249,1939.0809,1944.6083,1950.56,1957.868,1966.176,1974.3789,1983.056,1989.4,1978.45,1983.2827,1987.272,1989.5414,1990.3334,1989.2533,1986.5807,1984.548,1983.5,1983.6373,1984.76,1984.804,1979.8586,1973.3,1962.3053,1947.6666,1936.996,1926.1587,1914.218,1901.584,1893.3066,1881.8307,1874.016,1868.9773,1863.636,1862.2667,1869.65,1877.732,1881.608,1883.5907,1884.32,1883.5,1882.6233,1881.0934,1878.006,1880.7866,1887.1213,1894.456,1902.5707,1910.8787,1917.9634,1924.328,1931.636,1939.296,1946.0013,1952.3933,1959.7013,1967.0747,1974.484,1983.056,1990.0333,1970.3167,1974.0231,1977.8754,1981.0969,1982.6111,1981.831,1979.6506,1977.2147,1975.4445,1975.1666,1975.1666,1976.1666,1976.0713,1973.6205,1964.7073,1953.5178,1942.8633,1931.6836,1916.2495,1903.3578,1891.4534,1882.0693,1875.016,1869.4738,1864.636,1862.0555,1863.9165,1869.4196,1874.2747,1876.7107,1877.4445,1878.1666,1877.2078,1876.2365,1875.1993,1877.48,1885.0658,1893.4058,1903.1498,1912.2408,1918.9578,1924.0453,1931.9138,1939.476,1947.252,1954.1844,1961.1458,1968.3448,1975.3597,1983.2605,1990.5945,1963.3833,1967.1693,1969.77,1972.0414,1972.8334,1973.8334,1972.69,1972.2911,1970.9976,1970.5555,1970.5555,1969.8334,1968.7013,1965.3854,1960.8231,1952.5178,1944.372,1934.816,1920.2343,1906.7511,1894.7922,1885.2765,1877.2462,1871.8662,1866.0953,1862.3445,1862.0656,1863.9498,1866.9413,1869.7067,1870.8278,1871.8334,1871.5555,1872.5555,1874.3236,1878.2467,1886.5103,1895.8822,1906.1262,1914.712,1921.4022,1927.8347,1935.0804,1941.4862,1947.252,1954.9355,1962.8558,1969.6151,1976.2062,1983.792,1991.6056,1955.1333,1959.7253,1963.1053,1964.5347,1965.5,1966.5133,1967.586,1967.6666,1967.3434,1966.696,1965.5734,1963.9707,1961.5347,1958.4586,1954.4927,1948.7866,1942.2053,1932.9613,1920.8413,1909.2467,1898.6866,1887.9987,1880.6907,1874.3107,1868.4387,1863.5333,1862.0,1862.0,1863.8334,1864.8334,1864.8334,1865.8334,1866.6666,1868.4093,1874.0514,1879.78,1887.788,1897.128,1907.4287,1915.9586,1923.02,1930.4946,1939.4594,1945.1107,1950.5013,1957.4133,1964.998,1972.3427,1978.8174,1986.9586,1994.0167,1948.3278,1950.8386,1954.2389,1956.2476,1957.9491,1959.6844,1962.1666,1962.7778,1963.6268,1962.7778,1961.5178,1959.0818,1956.5138,1951.8627,1948.7698,1944.7267,1939.6368,1929.4084,1919.3969,1910.264,1900.2789,1889.4648,1882.6271,1876.7551,1870.6606,1865.0111,1862.764,1862.0,1862.0,1862.2115,1862.3889,1862.7778,1863.3889,1867.2991,1873.8905,1880.5778,1888.3992,1898.128,1908.158,1916.712,1924.02,1932.104,1940.1176,1947.34,1953.8632,1961.1711,1968.4791,1976.3951,1982.2002,1989.4031,1996.2833,1943.789,1945.2249,1946.8762,1948.8448,1949.4971,1950.8334,1951.3207,1953.7297,1955.2213,1956.8334,1956.5878,1955.2316,1952.6322,1947.7213,1942.8296,1940.4244,1934.378,1925.6582,1916.9385,1908.2186,1899.4645,1889.7795,1883.5514,1878.144,1872.3275,1867.4556,1864.0425,1862.3654,1862.0,1862.0,1862.0,1862.0,1862.8993,1868.592,1875.5438,1882.6956,1890.8435,1899.0978,1908.34,1916.8026,1923.9833,1932.104,1940.6243,1946.944,1954.336,1962.56,1970.824,1977.784,1984.484,1990.792,1998.1,1938.9,1940.336,1941.772,1942.604,1943.322,1943.5,1943.5,1944.976,1947.582,1950.736,1951.13,1951.152,1948.104,1941.012,1935.498,1933.12,1927.872,1921.064,1913.756,1905.948,1897.71,1888.416,1884.016,1879.144,1874.272,1869.4,1865.382,1863.828,1862.446,1862.0,1862.0,1862.0,1862.852,1868.508,1877.172,1884.48,1892.086,1899.128,1907.638,1915.76,1922.85,1930.716,1939.136,1946.444,1954.252,1962.56,1970.824,1977.784,1984.484,1990.792,1998.1,1935.9556,1936.3916,1937.0984,1937.1227,1937.1666,1936.1666,1935.2222,1937.1187,1938.6102,1940.268,1942.2222,1942.2391,1940.0829,1935.4626,1929.1587,1925.3112,1921.2489,1915.5254,1909.6151,1902.3751,1893.6311,1886.9965,1883.0715,1879.144,1875.272,1871.1555,1867.4856,1864.9626,1863.8424,1862.9445,1862.0,1862.0,1862.852,1866.2471,1875.0071,1883.4889,1891.788,1899.0978,1906.4596,1913.7676,1921.0756,1928.3835,1936.6915,1944.6476,1953.2567,1961.6156,1969.8795,1977.2097,1983.5396,1990.5427,1996.4944,1932.6111,1932.6111,1932.6111,1932.1414,1930.4398,1927.7533,1926.5376,1926.8334,1927.8324,1930.2684,1931.4445,1931.1738,1928.8429,1924.9196,1918.6617,1916.1755,1913.9573,1909.3307,1904.7262,1897.0973,1889.2234,1885.555,1881.8185,1878.711,1875.636,1871.711,1868.764,1866.328,1864.934,1864.0,1863.0078,1862.227,1862.0,1863.8992,1870.2869,1878.8,1888.242,1896.7391,1905.0151,1912.3231,1919.4989,1925.9391,1934.2471,1942.2031,1950.5068,1958.7822,1966.462,1975.1587,1981.162,1986.7502,1991.6222,1929.1666,1929.1666,1929.1666,1927.9933,1925.986,1922.32,1920.8174,1919.5,1919.888,1920.6666,1920.4933,1919.1373,1916.6793,1912.1707,1908.6627,1907.1333,1905.624,1903.188,1897.5907,1890.1013,1886.5466,1883.1107,1880.5927,1877.2987,1875.3326,1872.2,1868.9607,1867.0,1865.0,1864.38,1864.0,1863.0,1862.858,1862.4066,1864.902,1872.9734,1883.8773,1894.268,1902.1807,1909.0453,1916.1866,1923.308,1930.1813,1938.2773,1946.6693,1953.98,1962.2013,1971.5093,1977.8226,1982.6947,1987.5167,1925.8223,1925.4445,1925.4445,1924.2365,1921.8004,1918.62,1915.0629,1912.4578,1912.3367,1912.1666,1910.9066,1909.1929,1905.6249,1900.4409,1898.6083,1897.6111,1895.7351,1893.0737,1888.6964,1886.5382,1884.1022,1881.6257,1878.2302,1876.052,1874.4594,1872.2,1869.764,1867.328,1865.922,1865.0,1864.0056,1863.6996,1862.7633,1862.0,1862.523,1867.8511,1879.1327,1890.5404,1897.3805,1902.9053,1909.2489,1917.055,1923.9274,1932.9623,1942.336,1951.08,1960.1335,1968.4591,1975.484,1982.3236,1988.1,1921.6833,1920.5555,1919.8334,1919.3475,1917.8126,1915.1978,1911.5236,1906.2284,1905.0033,1905.4285,1904.3678,1901.4413,1897.5693,1892.6974,1888.5526,1887.8334,1886.6796,1885.5555,1884.0154,1883.0938,1880.6578,1879.2218,1876.6447,1875.3298,1873.636,1871.4222,1869.764,1868.0,1866.892,1865.3293,1865.0,1864.0,1863.1069,1862.0,1862.0,1863.8022,1874.5355,1885.6747,1892.1536,1894.7373,1900.9155,1912.7804,1922.636,1932.24,1941.5905,1951.08,1960.824,1968.176,1975.484,1981.792,1989.0167,1916.6666,1914.5,1914.6287,1914.6666,1914.0227,1911.74,1907.8014,1901.9773,1897.704,1897.3334,1896.0734,1892.804,1889.5347,1887.2654,1884.6627,1881.1533,1879.5,1879.6666,1879.6666,1878.8026,1877.8334,1876.7866,1875.4233,1873.9053,1872.53,1871.0333,1869.0,1868.2733,1866.892,1865.5466,1865.0,1864.0,1863.1233,1862.0,1862.0,1862.86,1869.5474,1879.7253,1883.7234,1886.856,1898.5333,1910.7134,1920.8933,1931.3174,1940.336,1949.9133,1958.6647,1966.5027,1974.1793,1981.6693,1990.1,1909.0056,1907.0192,1908.6384,1909.7778,1909.7778,1908.3088,1905.8729,1901.1146,1892.3767,1889.3889,1888.3889,1887.3889,1886.1763,1883.5569,1880.7722,1877.4355,1876.3889,1876.3889,1876.3889,1876.3174,1876.0,1875.3671,1874.1975,1872.4609,1871.2473,1870.0,1868.8558,1867.5894,1866.3469,1865.456,1865.0,1864.0,1863.0575,1862.0,1862.0,1862.4867,1864.8126,1871.607,1874.9207,1883.2977,1895.4778,1907.4929,1917.6257,1927.9808,1938.6736,1947.8578,1956.2568,1963.8014,1971.484,1980.6062,1990.5278,1898.8722,1899.1693,1902.4329,1904.8889,1904.9445,1904.8889,1903.9158,1900.0404,1890.87,1887.176,1886.6989,1885.2484,1882.7568,1880.3209,1877.9407,1876.5289,1876.0,1875.9445,1875.9445,1875.0,1874.9656,1873.997,1872.508,1871.9485,1869.9797,1868.9556,1867.9445,1866.9445,1865.8424,1864.9697,1864.0,1862.9769,1862.9445,1861.712,1861.0,1861.9534,1863.1589,1864.9426,1868.7609,1879.4547,1889.91,1902.7689,1912.9927,1923.4808,1934.174,1943.94,1952.7013,1960.4907,1969.312,1979.32,1990.8,1889.5,1891.004,1895.158,1899.708,1901.0,1901.0,1900.484,1897.572,1891.03,1887.176,1885.37,1882.804,1879.368,1877.216,1876.498,1876.0,1875.124,1875.0,1874.5,1874.408,1874.0,1872.972,1871.754,1870.036,1868.818,1867.6,1866.382,1865.164,1864.946,1863.728,1863.0,1862.0,1861.5,1860.856,1860.5,1860.58,1861.798,1863.016,1866.904,1875.212,1885.2,1898.768,1910.848,1920.592,1929.378,1938.58,1948.346,1959.372,1969.312,1980.056,1990.65,1888.0,1888.0555,1889.1414,1893.3307,1895.7551,1896.1866,1896.0824,1894.1062,1890.258,1887.176,1884.74,1881.608,1877.868,1876.432,1876.0,1875.5845,1875.0,1874.0382,1874.0,1873.0555,1873.0,1871.9471,1870.508,1869.004,1867.6562,1866.2444,1865.0425,1864.3654,1863.898,1862.4862,1862.0011,1861.0325,1860.0555,1859.0555,1859.0555,1860.16,1861.0331,1863.032,1867.9065,1874.712,1885.6444,1897.88,1910.8042,1920.556,1929.336,1938.08,1948.8215,1960.9044,1970.312,1980.056,1990.5,1886.6111,1887.0,1887.6111,1888.8191,1890.8662,1892.2222,1892.2222,1890.6405,1889.2231,1887.1075,1884.1923,1881.304,1879.2568,1877.168,1876.0,1875.56,1875.0,1874.0,1873.154,1872.9285,1872.0,1870.944,1869.3104,1868.072,1866.8584,1865.2,1864.4669,1863.6111,1862.958,1862.0,1861.0,1860.0,1858.7592,1857.6111,1857.8927,1858.7711,1860.0,1862.064,1867.1971,1874.712,1888.4288,1901.5707,1913.5433,1922.3698,1929.7249,1938.7622,1948.824,1960.96,1970.312,1979.5057,1989.5,1885.1666,1885.4467,1886.1666,1887.34,1888.1666,1889.1666,1889.1666,1888.1666,1886.7787,1885.3427,1882.9066,1881.304,1879.868,1878.432,1876.996,1876.0,1875.0,1874.0,1873.0,1872.0,1871.38,1870.0,1869.0,1867.2267,1866.106,1865.0,1864.0,1863.0,1862.0,1861.456,1860.0033,1858.6533,1858.0247,1856.1666,1856.1666,1858.0266,1859.0994,1862.032,1866.482,1875.4653,1889.9833,1902.8427,1915.848,1925.4253,1933.9187,1941.2267,1947.9047,1959.6333,1969.1687,1978.1,1987.9667,1883.9722,1884.2427,1885.5575,1885.78,1886.7222,1886.7222,1886.2062,1885.4578,1884.1642,1882.7222,1881.5344,1880.8066,1880.0,1879.0,1877.0,1876.0,1875.0,1873.9133,1872.7922,1872.0,1870.8278,1869.6818,1868.508,1867.072,1866.0,1865.0,1863.764,1862.328,1861.0,1860.3293,1858.7278,1857.8844,1856.7633,1855.5143,1854.9233,1855.8822,1858.4304,1860.7631,1865.274,1875.5894,1890.04,1903.7183,1916.9069,1927.592,1937.5298,1944.8378,1952.6891,1961.0093,1970.5133,1979.3337,1986.6555,1883.0,1883.0934,1883.8353,1884.2778,1884.2778,1883.5333,1882.9052,1882.2778,1880.8898,1880.2778,1880.0,1879.4973,1879.2411,1878.432,1877.0,1876.0,1875.0,1873.688,1872.252,1871.816,1870.38,1869.0,1868.1411,1867.0,1865.737,1865.0,1863.764,1862.0,1860.922,1859.607,1858.0056,1856.6996,1855.3846,1854.792,1854.0,1855.0444,1857.596,1860.3098,1863.936,1875.4507,1890.7,1904.4404,1917.7822,1929.3142,1939.9742,1948.2822,1959.2245,1967.6205,1975.8806,1984.2365,1992.9667,1881.8334,1882.0,1882.0,1881.8334,1881.8334,1880.8334,1880.4033,1879.8334,1878.3434,1877.8334,1877.8334,1877.8334,1877.7234,1877.0,1876.83,1876.0,1875.0,1873.688,1872.21,1870.9694,1869.8966,1868.9907,1867.918,1867.0,1865.636,1865.0,1863.764,1862.0,1860.892,1859.38,1857.8367,1855.9307,1854.858,1853.5934,1852.8334,1852.9933,1856.192,1860.0587,1863.936,1874.424,1890.04,1905.0093,1918.4387,1932.0547,1942.4326,1951.3334,1962.954,1972.7346,1980.7887,1989.82,2000.6833,1880.45,1881.0,1881.0,1880.3889,1880.0,1879.3889,1878.6847,1877.4182,1876.763,1876.3889,1876.3889,1876.3889,1876.3889,1876.0,1876.0,1875.7311,1875.0,1873.688,1872.252,1870.816,1869.38,1868.944,1867.508,1867.0,1865.636,1865.0,1863.764,1862.0,1860.892,1858.456,1857.02,1855.584,1854.148,1852.712,1852.0,1852.16,1856.192,1860.032,1863.936,1874.424,1889.38,1905.88,1919.9656,1934.4991,1944.8632,1954.8223,1966.418,1976.0266,1984.9231,1995.5422,2005.3223,1880.0,1880.0,1880.0,1879.9445,1879.0,1878.0,1877.4572,1877.0,1876.0,1876.0,1875.9445,1875.9445,1875.9445,1875.9445,1875.0,1875.0,1874.1171,1873.0,1872.238,1870.816,1869.38,1868.944,1867.508,1867.0,1866.0,1865.0,1863.764,1862.0,1860.892,1858.4862,1857.02,1855.584,1854.0082,1852.0,1851.0,1853.16,1856.192,1860.064,1863.936,1872.616,1888.6644,1906.8676,1920.484,1935.9436,1946.3916,1957.6289,1968.824,1978.1978,1987.3676,1999.4165,2009.8556,1879.5,1879.332,1879.0,1878.896,1878.0,1877.0,1876.5,1876.0,1876.0,1875.176,1875.0,1875.0,1874.934,1874.5,1874.002,1874.0,1873.562,1872.844,1872.0,1870.816,1869.38,1868.944,1867.508,1867.0,1866.0,1865.0,1863.764,1862.328,1860.892,1859.228,1857.51,1855.792,1854.148,1852.0,1851.0,1852.74,1856.192,1860.048,1863.936,1872.616,1887.22,1905.768,1920.878,1936.564,1947.336,1958.6,1969.78,1979.568,1989.312,2001.688,2012.6,1878.15,1878.0555,1878.0127,1877.8036,1877.0198,1876.0511,1876.0,1875.1008,1875.6335,1875.0098,1874.0,1874.0,1874.0,1874.0,1873.0555,1873.0555,1873.0,1872.0382,1871.252,1870.816,1869.38,1868.944,1867.508,1867.0,1866.0,1865.0,1864.0,1862.9626,1861.8424,1859.9697,1858.9445,1856.584,1854.9526,1852.6725,1851.2606,1852.16,1855.2145,1859.064,1863.494,1871.6715,1885.4355,1904.4875,1921.272,1935.276,1947.336,1958.1089,1968.8771,1979.568,1990.094,2002.5693,2014.0444,1877.6111,1877.0,1877.0,1876.9191,1876.2175,1876.0,1875.2958,1875.0,1874.237,1875.0,1874.0,1873.0,1873.0,1873.0,1872.6086,1872.2689,1872.0,1872.0,1871.0,1870.0,1869.6211,1869.0,1868.0,1867.028,1866.2473,1865.5111,1865.0,1864.5894,1863.3229,1862.3889,1860.4089,1857.7457,1855.148,1852.824,1851.276,1851.16,1853.9602,1858.064,1862.936,1871.52,1884.7833,1903.208,1920.0127,1933.2471,1946.0637,1957.08,1968.3911,1979.1791,1989.2451,2001.9312,2012.6833,1877.0,1876.1666,1876.038,1876.0,1876.0,1875.1666,1875.0,1874.008,1874.0,1873.8534,1874.0,1873.0,1873.0,1872.5266,1872.0,1872.0,1872.0,1871.74,1871.0,1870.0,1870.0,1869.0,1868.4233,1868.0,1867.8334,1867.0,1866.0,1865.8334,1865.0,1864.2893,1861.8534,1858.584,1856.148,1853.712,1852.0,1851.0,1852.6953,1857.2307,1862.936,1870.536,1882.5466,1901.3746,1918.2267,1930.7587,1941.074,1955.68,1966.9467,1977.568,1986.4786,1999.4867,2010.6666,1876.0278,1876.0,1876.0,1875.22,1875.0,1874.0,1874.7222,1875.0,1874.0,1873.176,1873.1877,1872.4973,1872.0,1872.0,1871.0,1871.0,1871.0,1871.0,1870.7922,1870.0,1870.0,1869.0,1869.0,1869.0,1868.0,1867.2,1867.0,1866.0,1865.892,1865.0,1863.02,1859.7462,1857.148,1854.712,1852.276,1851.0,1851.596,1857.064,1862.936,1870.616,1880.9456,1897.1133,1913.4387,1927.2164,1937.9264,1953.6,1965.5144,1976.2902,1985.4363,1997.0422,2008.2222,1877.0,1876.4796,1876.0,1876.0,1875.7222,1875.0,1875.0,1874.7222,1874.0,1874.0,1873.0,1872.0845,1871.0,1871.12,1870.0,1870.2778,1870.0,1870.1912,1870.0,1870.0,1870.0,1869.2622,1869.0,1869.0,1868.0,1867.7778,1867.0,1866.328,1865.892,1865.0,1863.7478,1860.584,1857.148,1854.712,1852.276,1851.0,1851.596,1857.064,1863.274,1871.3649,1881.5167,1895.5938,1910.9943,1925.888,1939.5647,1953.6,1964.7922,1974.8458,1984.5897,1994.4071,2004.3556,1878.1666,1877.72,1877.1666,1877.0,1876.1666,1876.0,1876.0,1876.0,1875.0,1874.0293,1873.74,1872.2533,1870.7013,1869.8334,1868.834,1869.0,1869.0,1869.26,1869.0,1869.0,1869.0,1869.0,1869.0,1869.0,1868.0,1868.0,1867.0,1866.328,1865.892,1865.0,1864.02,1861.168,1858.148,1854.712,1852.276,1851.0,1851.4967,1857.096,1864.404,1871.712,1882.0967,1895.88,1912.4033,1926.78,1940.3373,1952.9933,1963.6573,1973.2346,1982.0073,1990.7227,2000.4667],solid=False,xDimension=51,xSpacing=24.360000,zDimension=67,zSpacing=24.444444,
          geoOrigin=GeoOrigin(USE='ORIGIN'),
          texCoord=TextureCoordinate(point=[(0.00391,0.00391),(0.02,0.00391),(0.04,0.00391),(0.06,0.00391),(0.08,0.00391),(0.1,0.00391),(0.12,0.00391),(0.14,0.00391),(0.16,0.00391),(0.18,0.00391),(0.2,0.00391),(0.22,0.00391),(0.24,0.00391),(0.26,0.00391),(0.28,0.00391),(0.3,0.00391),(0.32,0.00391),(0.34,0.00391),(0.36,0.00391),(0.38,0.00391),(0.4,0.00391),(0.42,0.00391),(0.44,0.00391),(0.46,0.00391),(0.48,0.00391),(0.5,0.00391),(0.52,0.00391),(0.54,0.00391),(0.56,0.00391),(0.58,0.00391),(0.6,0.00391),(0.62,0.00391),(0.64,0.00391),(0.66,0.00391),(0.68,0.00391),(0.7,0.00391),(0.72,0.00391),(0.74,0.00391),(0.76,0.00391),(0.78,0.00391),(0.8,0.00391),(0.82,0.00391),(0.84,0.00391),(0.86,0.00391),(0.88,0.00391),(0.9,0.00391),(0.92,0.00391),(0.94,0.00391),(0.96,0.00391),(0.98,0.00391),(0.99609,0.00391),(0.00391,0.01515),(0.02,0.01515),(0.04,0.01515),(0.06,0.01515),(0.08,0.01515),(0.1,0.01515),(0.12,0.01515),(0.14,0.01515),(0.16,0.01515),(0.18,0.01515),(0.2,0.01515),(0.22,0.01515),(0.24,0.01515),(0.26,0.01515),(0.28,0.01515),(0.3,0.01515),(0.32,0.01515),(0.34,0.01515),(0.36,0.01515),(0.38,0.01515),(0.4,0.01515),(0.42,0.01515),(0.44,0.01515),(0.46,0.01515),(0.48,0.01515),(0.5,0.01515),(0.52,0.01515),(0.54,0.01515),(0.56,0.01515),(0.58,0.01515),(0.6,0.01515),(0.62,0.01515),(0.64,0.01515),(0.66,0.01515),(0.68,0.01515),(0.7,0.01515),(0.72,0.01515),(0.74,0.01515),(0.76,0.01515),(0.78,0.01515),(0.8,0.01515),(0.82,0.01515),(0.84,0.01515),(0.86,0.01515),(0.88,0.01515),(0.9,0.01515),(0.92,0.01515),(0.94,0.01515),(0.96,0.01515),(0.98,0.01515),(0.99609,0.01515),(0.00391,0.0303),(0.02,0.0303),(0.04,0.0303),(0.06,0.0303),(0.08,0.0303),(0.1,0.0303),(0.12,0.0303),(0.14,0.0303),(0.16,0.0303),(0.18,0.0303),(0.2,0.0303),(0.22,0.0303),(0.24,0.0303),(0.26,0.0303),(0.28,0.0303),(0.3,0.0303),(0.32,0.0303),(0.34,0.0303),(0.36,0.0303),(0.38,0.0303),(0.4,0.0303),(0.42,0.0303),(0.44,0.0303),(0.46,0.0303),(0.48,0.0303),(0.5,0.0303),(0.52,0.0303),(0.54,0.0303),(0.56,0.0303),(0.58,0.0303),(0.6,0.0303),(0.62,0.0303),(0.64,0.0303),(0.66,0.0303),(0.68,0.0303),(0.7,0.0303),(0.72,0.0303),(0.74,0.0303),(0.76,0.0303),(0.78,0.0303),(0.8,0.0303),(0.82,0.0303),(0.84,0.0303),(0.86,0.0303),(0.88,0.0303),(0.9,0.0303),(0.92,0.0303),(0.94,0.0303),(0.96,0.0303),(0.98,0.0303),(0.99609,0.0303),(0.00391,0.04545),(0.02,0.04545),(0.04,0.04545),(0.06,0.04545),(0.08,0.04545),(0.1,0.04545),(0.12,0.04545),(0.14,0.04545),(0.16,0.04545),(0.18,0.04545),(0.2,0.04545),(0.22,0.04545),(0.24,0.04545),(0.26,0.04545),(0.28,0.04545),(0.3,0.04545),(0.32,0.04545),(0.34,0.04545),(0.36,0.04545),(0.38,0.04545),(0.4,0.04545),(0.42,0.04545),(0.44,0.04545),(0.46,0.04545),(0.48,0.04545),(0.5,0.04545),(0.52,0.04545),(0.54,0.04545),(0.56,0.04545),(0.58,0.04545),(0.6,0.04545),(0.62,0.04545),(0.64,0.04545),(0.66,0.04545),(0.68,0.04545),(0.7,0.04545),(0.72,0.04545),(0.74,0.04545),(0.76,0.04545),(0.78,0.04545),(0.8,0.04545),(0.82,0.04545),(0.84,0.04545),(0.86,0.04545),(0.88,0.04545),(0.9,0.04545),(0.92,0.04545),(0.94,0.04545),(0.96,0.04545),(0.98,0.04545),(0.99609,0.04545),(0.00391,0.06061),(0.02,0.06061),(0.04,0.06061),(0.06,0.06061),(0.08,0.06061),(0.1,0.06061),(0.12,0.06061),(0.14,0.06061),(0.16,0.06061),(0.18,0.06061),(0.2,0.06061),(0.22,0.06061),(0.24,0.06061),(0.26,0.06061),(0.28,0.06061),(0.3,0.06061),(0.32,0.06061),(0.34,0.06061),(0.36,0.06061),(0.38,0.06061),(0.4,0.06061),(0.42,0.06061),(0.44,0.06061),(0.46,0.06061),(0.48,0.06061),(0.5,0.06061),(0.52,0.06061),(0.54,0.06061),(0.56,0.06061),(0.58,0.06061),(0.6,0.06061),(0.62,0.06061),(0.64,0.06061),(0.66,0.06061),(0.68,0.06061),(0.7,0.06061),(0.72,0.06061),(0.74,0.06061),(0.76,0.06061),(0.78,0.06061),(0.8,0.06061),(0.82,0.06061),(0.84,0.06061),(0.86,0.06061),(0.88,0.06061),(0.9,0.06061),(0.92,0.06061),(0.94,0.06061),(0.96,0.06061),(0.98,0.06061),(0.99609,0.06061),(0.00391,0.07576),(0.02,0.07576),(0.04,0.07576),(0.06,0.07576),(0.08,0.07576),(0.1,0.07576),(0.12,0.07576),(0.14,0.07576),(0.16,0.07576),(0.18,0.07576),(0.2,0.07576),(0.22,0.07576),(0.24,0.07576),(0.26,0.07576),(0.28,0.07576),(0.3,0.07576),(0.32,0.07576),(0.34,0.07576),(0.36,0.07576),(0.38,0.07576),(0.4,0.07576),(0.42,0.07576),(0.44,0.07576),(0.46,0.07576),(0.48,0.07576),(0.5,0.07576),(0.52,0.07576),(0.54,0.07576),(0.56,0.07576),(0.58,0.07576),(0.6,0.07576),(0.62,0.07576),(0.64,0.07576),(0.66,0.07576),(0.68,0.07576),(0.7,0.07576),(0.72,0.07576),(0.74,0.07576),(0.76,0.07576),(0.78,0.07576),(0.8,0.07576),(0.82,0.07576),(0.84,0.07576),(0.86,0.07576),(0.88,0.07576),(0.9,0.07576),(0.92,0.07576),(0.94,0.07576),(0.96,0.07576),(0.98,0.07576),(0.99609,0.07576),(0.00391,0.09091),(0.02,0.09091),(0.04,0.09091),(0.06,0.09091),(0.08,0.09091),(0.1,0.09091),(0.12,0.09091),(0.14,0.09091),(0.16,0.09091),(0.18,0.09091),(0.2,0.09091),(0.22,0.09091),(0.24,0.09091),(0.26,0.09091),(0.28,0.09091),(0.3,0.09091),(0.32,0.09091),(0.34,0.09091),(0.36,0.09091),(0.38,0.09091),(0.4,0.09091),(0.42,0.09091),(0.44,0.09091),(0.46,0.09091),(0.48,0.09091),(0.5,0.09091),(0.52,0.09091),(0.54,0.09091),(0.56,0.09091),(0.58,0.09091),(0.6,0.09091),(0.62,0.09091),(0.64,0.09091),(0.66,0.09091),(0.68,0.09091),(0.7,0.09091),(0.72,0.09091),(0.74,0.09091),(0.76,0.09091),(0.78,0.09091),(0.8,0.09091),(0.82,0.09091),(0.84,0.09091),(0.86,0.09091),(0.88,0.09091),(0.9,0.09091),(0.92,0.09091),(0.94,0.09091),(0.96,0.09091),(0.98,0.09091),(0.99609,0.09091),(0.00391,0.10606),(0.02,0.10606),(0.04,0.10606),(0.06,0.10606),(0.08,0.10606),(0.1,0.10606),(0.12,0.10606),(0.14,0.10606),(0.16,0.10606),(0.18,0.10606),(0.2,0.10606),(0.22,0.10606),(0.24,0.10606),(0.26,0.10606),(0.28,0.10606),(0.3,0.10606),(0.32,0.10606),(0.34,0.10606),(0.36,0.10606),(0.38,0.10606),(0.4,0.10606),(0.42,0.10606),(0.44,0.10606),(0.46,0.10606),(0.48,0.10606),(0.5,0.10606),(0.52,0.10606),(0.54,0.10606),(0.56,0.10606),(0.58,0.10606),(0.6,0.10606),(0.62,0.10606),(0.64,0.10606),(0.66,0.10606),(0.68,0.10606),(0.7,0.10606),(0.72,0.10606),(0.74,0.10606),(0.76,0.10606),(0.78,0.10606),(0.8,0.10606),(0.82,0.10606),(0.84,0.10606),(0.86,0.10606),(0.88,0.10606),(0.9,0.10606),(0.92,0.10606),(0.94,0.10606),(0.96,0.10606),(0.98,0.10606),(0.99609,0.10606),(0.00391,0.12121),(0.02,0.12121),(0.04,0.12121),(0.06,0.12121),(0.08,0.12121),(0.1,0.12121),(0.12,0.12121),(0.14,0.12121),(0.16,0.12121),(0.18,0.12121),(0.2,0.12121),(0.22,0.12121),(0.24,0.12121),(0.26,0.12121),(0.28,0.12121),(0.3,0.12121),(0.32,0.12121),(0.34,0.12121),(0.36,0.12121),(0.38,0.12121),(0.4,0.12121),(0.42,0.12121),(0.44,0.12121),(0.46,0.12121),(0.48,0.12121),(0.5,0.12121),(0.52,0.12121),(0.54,0.12121),(0.56,0.12121),(0.58,0.12121),(0.6,0.12121),(0.62,0.12121),(0.64,0.12121),(0.66,0.12121),(0.68,0.12121),(0.7,0.12121),(0.72,0.12121),(0.74,0.12121),(0.76,0.12121),(0.78,0.12121),(0.8,0.12121),(0.82,0.12121),(0.84,0.12121),(0.86,0.12121),(0.88,0.12121),(0.9,0.12121),(0.92,0.12121),(0.94,0.12121),(0.96,0.12121),(0.98,0.12121),(0.99609,0.12121),(0.00391,0.13636),(0.02,0.13636),(0.04,0.13636),(0.06,0.13636),(0.08,0.13636),(0.1,0.13636),(0.12,0.13636),(0.14,0.13636),(0.16,0.13636),(0.18,0.13636),(0.2,0.13636),(0.22,0.13636),(0.24,0.13636),(0.26,0.13636),(0.28,0.13636),(0.3,0.13636),(0.32,0.13636),(0.34,0.13636),(0.36,0.13636),(0.38,0.13636),(0.4,0.13636),(0.42,0.13636),(0.44,0.13636),(0.46,0.13636),(0.48,0.13636),(0.5,0.13636),(0.52,0.13636),(0.54,0.13636),(0.56,0.13636),(0.58,0.13636),(0.6,0.13636),(0.62,0.13636),(0.64,0.13636),(0.66,0.13636),(0.68,0.13636),(0.7,0.13636),(0.72,0.13636),(0.74,0.13636),(0.76,0.13636),(0.78,0.13636),(0.8,0.13636),(0.82,0.13636),(0.84,0.13636),(0.86,0.13636),(0.88,0.13636),(0.9,0.13636),(0.92,0.13636),(0.94,0.13636),(0.96,0.13636),(0.98,0.13636),(0.99609,0.13636),(0.00391,0.15152),(0.02,0.15152),(0.04,0.15152),(0.06,0.15152),(0.08,0.15152),(0.1,0.15152),(0.12,0.15152),(0.14,0.15152),(0.16,0.15152),(0.18,0.15152),(0.2,0.15152),(0.22,0.15152),(0.24,0.15152),(0.26,0.15152),(0.28,0.15152),(0.3,0.15152),(0.32,0.15152),(0.34,0.15152),(0.36,0.15152),(0.38,0.15152),(0.4,0.15152),(0.42,0.15152),(0.44,0.15152),(0.46,0.15152),(0.48,0.15152),(0.5,0.15152),(0.52,0.15152),(0.54,0.15152),(0.56,0.15152),(0.58,0.15152),(0.6,0.15152),(0.62,0.15152),(0.64,0.15152),(0.66,0.15152),(0.68,0.15152),(0.7,0.15152),(0.72,0.15152),(0.74,0.15152),(0.76,0.15152),(0.78,0.15152),(0.8,0.15152),(0.82,0.15152),(0.84,0.15152),(0.86,0.15152),(0.88,0.15152),(0.9,0.15152),(0.92,0.15152),(0.94,0.15152),(0.96,0.15152),(0.98,0.15152),(0.99609,0.15152),(0.00391,0.16667),(0.02,0.16667),(0.04,0.16667),(0.06,0.16667),(0.08,0.16667),(0.1,0.16667),(0.12,0.16667),(0.14,0.16667),(0.16,0.16667),(0.18,0.16667),(0.2,0.16667),(0.22,0.16667),(0.24,0.16667),(0.26,0.16667),(0.28,0.16667),(0.3,0.16667),(0.32,0.16667),(0.34,0.16667),(0.36,0.16667),(0.38,0.16667),(0.4,0.16667),(0.42,0.16667),(0.44,0.16667),(0.46,0.16667),(0.48,0.16667),(0.5,0.16667),(0.52,0.16667),(0.54,0.16667),(0.56,0.16667),(0.58,0.16667),(0.6,0.16667),(0.62,0.16667),(0.64,0.16667),(0.66,0.16667),(0.68,0.16667),(0.7,0.16667),(0.72,0.16667),(0.74,0.16667),(0.76,0.16667),(0.78,0.16667),(0.8,0.16667),(0.82,0.16667),(0.84,0.16667),(0.86,0.16667),(0.88,0.16667),(0.9,0.16667),(0.92,0.16667),(0.94,0.16667),(0.96,0.16667),(0.98,0.16667),(0.99609,0.16667),(0.00391,0.18182),(0.02,0.18182),(0.04,0.18182),(0.06,0.18182),(0.08,0.18182),(0.1,0.18182),(0.12,0.18182),(0.14,0.18182),(0.16,0.18182),(0.18,0.18182),(0.2,0.18182),(0.22,0.18182),(0.24,0.18182),(0.26,0.18182),(0.28,0.18182),(0.3,0.18182),(0.32,0.18182),(0.34,0.18182),(0.36,0.18182),(0.38,0.18182),(0.4,0.18182),(0.42,0.18182),(0.44,0.18182),(0.46,0.18182),(0.48,0.18182),(0.5,0.18182),(0.52,0.18182),(0.54,0.18182),(0.56,0.18182),(0.58,0.18182),(0.6,0.18182),(0.62,0.18182),(0.64,0.18182),(0.66,0.18182),(0.68,0.18182),(0.7,0.18182),(0.72,0.18182),(0.74,0.18182),(0.76,0.18182),(0.78,0.18182),(0.8,0.18182),(0.82,0.18182),(0.84,0.18182),(0.86,0.18182),(0.88,0.18182),(0.9,0.18182),(0.92,0.18182),(0.94,0.18182),(0.96,0.18182),(0.98,0.18182),(0.99609,0.18182),(0.00391,0.19697),(0.02,0.19697),(0.04,0.19697),(0.06,0.19697),(0.08,0.19697),(0.1,0.19697),(0.12,0.19697),(0.14,0.19697),(0.16,0.19697),(0.18,0.19697),(0.2,0.19697),(0.22,0.19697),(0.24,0.19697),(0.26,0.19697),(0.28,0.19697),(0.3,0.19697),(0.32,0.19697),(0.34,0.19697),(0.36,0.19697),(0.38,0.19697),(0.4,0.19697),(0.42,0.19697),(0.44,0.19697),(0.46,0.19697),(0.48,0.19697),(0.5,0.19697),(0.52,0.19697),(0.54,0.19697),(0.56,0.19697),(0.58,0.19697),(0.6,0.19697),(0.62,0.19697),(0.64,0.19697),(0.66,0.19697),(0.68,0.19697),(0.7,0.19697),(0.72,0.19697),(0.74,0.19697),(0.76,0.19697),(0.78,0.19697),(0.8,0.19697),(0.82,0.19697),(0.84,0.19697),(0.86,0.19697),(0.88,0.19697),(0.9,0.19697),(0.92,0.19697),(0.94,0.19697),(0.96,0.19697),(0.98,0.19697),(0.99609,0.19697),(0.00391,0.21212),(0.02,0.21212),(0.04,0.21212),(0.06,0.21212),(0.08,0.21212),(0.1,0.21212),(0.12,0.21212),(0.14,0.21212),(0.16,0.21212),(0.18,0.21212),(0.2,0.21212),(0.22,0.21212),(0.24,0.21212),(0.26,0.21212),(0.28,0.21212),(0.3,0.21212),(0.32,0.21212),(0.34,0.21212),(0.36,0.21212),(0.38,0.21212),(0.4,0.21212),(0.42,0.21212),(0.44,0.21212),(0.46,0.21212),(0.48,0.21212),(0.5,0.21212),(0.52,0.21212),(0.54,0.21212),(0.56,0.21212),(0.58,0.21212),(0.6,0.21212),(0.62,0.21212),(0.64,0.21212),(0.66,0.21212),(0.68,0.21212),(0.7,0.21212),(0.72,0.21212),(0.74,0.21212),(0.76,0.21212),(0.78,0.21212),(0.8,0.21212),(0.82,0.21212),(0.84,0.21212),(0.86,0.21212),(0.88,0.21212),(0.9,0.21212),(0.92,0.21212),(0.94,0.21212),(0.96,0.21212),(0.98,0.21212),(0.99609,0.21212),(0.00391,0.22727),(0.02,0.22727),(0.04,0.22727),(0.06,0.22727),(0.08,0.22727),(0.1,0.22727),(0.12,0.22727),(0.14,0.22727),(0.16,0.22727),(0.18,0.22727),(0.2,0.22727),(0.22,0.22727),(0.24,0.22727),(0.26,0.22727),(0.28,0.22727),(0.3,0.22727),(0.32,0.22727),(0.34,0.22727),(0.36,0.22727),(0.38,0.22727),(0.4,0.22727),(0.42,0.22727),(0.44,0.22727),(0.46,0.22727),(0.48,0.22727),(0.5,0.22727),(0.52,0.22727),(0.54,0.22727),(0.56,0.22727),(0.58,0.22727),(0.6,0.22727),(0.62,0.22727),(0.64,0.22727),(0.66,0.22727),(0.68,0.22727),(0.7,0.22727),(0.72,0.22727),(0.74,0.22727),(0.76,0.22727),(0.78,0.22727),(0.8,0.22727),(0.82,0.22727),(0.84,0.22727),(0.86,0.22727),(0.88,0.22727),(0.9,0.22727),(0.92,0.22727),(0.94,0.22727),(0.96,0.22727),(0.98,0.22727),(0.99609,0.22727),(0.00391,0.24242),(0.02,0.24242),(0.04,0.24242),(0.06,0.24242),(0.08,0.24242),(0.1,0.24242),(0.12,0.24242),(0.14,0.24242),(0.16,0.24242),(0.18,0.24242),(0.2,0.24242),(0.22,0.24242),(0.24,0.24242),(0.26,0.24242),(0.28,0.24242),(0.3,0.24242),(0.32,0.24242),(0.34,0.24242),(0.36,0.24242),(0.38,0.24242),(0.4,0.24242),(0.42,0.24242),(0.44,0.24242),(0.46,0.24242),(0.48,0.24242),(0.5,0.24242),(0.52,0.24242),(0.54,0.24242),(0.56,0.24242),(0.58,0.24242),(0.6,0.24242),(0.62,0.24242),(0.64,0.24242),(0.66,0.24242),(0.68,0.24242),(0.7,0.24242),(0.72,0.24242),(0.74,0.24242),(0.76,0.24242),(0.78,0.24242),(0.8,0.24242),(0.82,0.24242),(0.84,0.24242),(0.86,0.24242),(0.88,0.24242),(0.9,0.24242),(0.92,0.24242),(0.94,0.24242),(0.96,0.24242),(0.98,0.24242),(0.99609,0.24242),(0.00391,0.25758),(0.02,0.25758),(0.04,0.25758),(0.06,0.25758),(0.08,0.25758),(0.1,0.25758),(0.12,0.25758),(0.14,0.25758),(0.16,0.25758),(0.18,0.25758),(0.2,0.25758),(0.22,0.25758),(0.24,0.25758),(0.26,0.25758),(0.28,0.25758),(0.3,0.25758),(0.32,0.25758),(0.34,0.25758),(0.36,0.25758),(0.38,0.25758),(0.4,0.25758),(0.42,0.25758),(0.44,0.25758),(0.46,0.25758),(0.48,0.25758),(0.5,0.25758),(0.52,0.25758),(0.54,0.25758),(0.56,0.25758),(0.58,0.25758),(0.6,0.25758),(0.62,0.25758),(0.64,0.25758),(0.66,0.25758),(0.68,0.25758),(0.7,0.25758),(0.72,0.25758),(0.74,0.25758),(0.76,0.25758),(0.78,0.25758),(0.8,0.25758),(0.82,0.25758),(0.84,0.25758),(0.86,0.25758),(0.88,0.25758),(0.9,0.25758),(0.92,0.25758),(0.94,0.25758),(0.96,0.25758),(0.98,0.25758),(0.99609,0.25758),(0.00391,0.27273),(0.02,0.27273),(0.04,0.27273),(0.06,0.27273),(0.08,0.27273),(0.1,0.27273),(0.12,0.27273),(0.14,0.27273),(0.16,0.27273),(0.18,0.27273),(0.2,0.27273),(0.22,0.27273),(0.24,0.27273),(0.26,0.27273),(0.28,0.27273),(0.3,0.27273),(0.32,0.27273),(0.34,0.27273),(0.36,0.27273),(0.38,0.27273),(0.4,0.27273),(0.42,0.27273),(0.44,0.27273),(0.46,0.27273),(0.48,0.27273),(0.5,0.27273),(0.52,0.27273),(0.54,0.27273),(0.56,0.27273),(0.58,0.27273),(0.6,0.27273),(0.62,0.27273),(0.64,0.27273),(0.66,0.27273),(0.68,0.27273),(0.7,0.27273),(0.72,0.27273),(0.74,0.27273),(0.76,0.27273),(0.78,0.27273),(0.8,0.27273),(0.82,0.27273),(0.84,0.27273),(0.86,0.27273),(0.88,0.27273),(0.9,0.27273),(0.92,0.27273),(0.94,0.27273),(0.96,0.27273),(0.98,0.27273),(0.99609,0.27273),(0.00391,0.28788),(0.02,0.28788),(0.04,0.28788),(0.06,0.28788),(0.08,0.28788),(0.1,0.28788),(0.12,0.28788),(0.14,0.28788),(0.16,0.28788),(0.18,0.28788),(0.2,0.28788),(0.22,0.28788),(0.24,0.28788),(0.26,0.28788),(0.28,0.28788),(0.3,0.28788),(0.32,0.28788),(0.34,0.28788),(0.36,0.28788),(0.38,0.28788),(0.4,0.28788),(0.42,0.28788),(0.44,0.28788),(0.46,0.28788),(0.48,0.28788),(0.5,0.28788),(0.52,0.28788),(0.54,0.28788),(0.56,0.28788),(0.58,0.28788),(0.6,0.28788),(0.62,0.28788),(0.64,0.28788),(0.66,0.28788),(0.68,0.28788),(0.7,0.28788),(0.72,0.28788),(0.74,0.28788),(0.76,0.28788),(0.78,0.28788),(0.8,0.28788),(0.82,0.28788),(0.84,0.28788),(0.86,0.28788),(0.88,0.28788),(0.9,0.28788),(0.92,0.28788),(0.94,0.28788),(0.96,0.28788),(0.98,0.28788),(0.99609,0.28788),(0.00391,0.30303),(0.02,0.30303),(0.04,0.30303),(0.06,0.30303),(0.08,0.30303),(0.1,0.30303),(0.12,0.30303),(0.14,0.30303),(0.16,0.30303),(0.18,0.30303),(0.2,0.30303),(0.22,0.30303),(0.24,0.30303),(0.26,0.30303),(0.28,0.30303),(0.3,0.30303),(0.32,0.30303),(0.34,0.30303),(0.36,0.30303),(0.38,0.30303),(0.4,0.30303),(0.42,0.30303),(0.44,0.30303),(0.46,0.30303),(0.48,0.30303),(0.5,0.30303),(0.52,0.30303),(0.54,0.30303),(0.56,0.30303),(0.58,0.30303),(0.6,0.30303),(0.62,0.30303),(0.64,0.30303),(0.66,0.30303),(0.68,0.30303),(0.7,0.30303),(0.72,0.30303),(0.74,0.30303),(0.76,0.30303),(0.78,0.30303),(0.8,0.30303),(0.82,0.30303),(0.84,0.30303),(0.86,0.30303),(0.88,0.30303),(0.9,0.30303),(0.92,0.30303),(0.94,0.30303),(0.96,0.30303),(0.98,0.30303),(0.99609,0.30303),(0.00391,0.31818),(0.02,0.31818),(0.04,0.31818),(0.06,0.31818),(0.08,0.31818),(0.1,0.31818),(0.12,0.31818),(0.14,0.31818),(0.16,0.31818),(0.18,0.31818),(0.2,0.31818),(0.22,0.31818),(0.24,0.31818),(0.26,0.31818),(0.28,0.31818),(0.3,0.31818),(0.32,0.31818),(0.34,0.31818),(0.36,0.31818),(0.38,0.31818),(0.4,0.31818),(0.42,0.31818),(0.44,0.31818),(0.46,0.31818),(0.48,0.31818),(0.5,0.31818),(0.52,0.31818),(0.54,0.31818),(0.56,0.31818),(0.58,0.31818),(0.6,0.31818),(0.62,0.31818),(0.64,0.31818),(0.66,0.31818),(0.68,0.31818),(0.7,0.31818),(0.72,0.31818),(0.74,0.31818),(0.76,0.31818),(0.78,0.31818),(0.8,0.31818),(0.82,0.31818),(0.84,0.31818),(0.86,0.31818),(0.88,0.31818),(0.9,0.31818),(0.92,0.31818),(0.94,0.31818),(0.96,0.31818),(0.98,0.31818),(0.99609,0.31818),(0.00391,0.33333),(0.02,0.33333),(0.04,0.33333),(0.06,0.33333),(0.08,0.33333),(0.1,0.33333),(0.12,0.33333),(0.14,0.33333),(0.16,0.33333),(0.18,0.33333),(0.2,0.33333),(0.22,0.33333),(0.24,0.33333),(0.26,0.33333),(0.28,0.33333),(0.3,0.33333),(0.32,0.33333),(0.34,0.33333),(0.36,0.33333),(0.38,0.33333),(0.4,0.33333),(0.42,0.33333),(0.44,0.33333),(0.46,0.33333),(0.48,0.33333),(0.5,0.33333),(0.52,0.33333),(0.54,0.33333),(0.56,0.33333),(0.58,0.33333),(0.6,0.33333),(0.62,0.33333),(0.64,0.33333),(0.66,0.33333),(0.68,0.33333),(0.7,0.33333),(0.72,0.33333),(0.74,0.33333),(0.76,0.33333),(0.78,0.33333),(0.8,0.33333),(0.82,0.33333),(0.84,0.33333),(0.86,0.33333),(0.88,0.33333),(0.9,0.33333),(0.92,0.33333),(0.94,0.33333),(0.96,0.33333),(0.98,0.33333),(0.99609,0.33333),(0.00391,0.34848),(0.02,0.34848),(0.04,0.34848),(0.06,0.34848),(0.08,0.34848),(0.1,0.34848),(0.12,0.34848),(0.14,0.34848),(0.16,0.34848),(0.18,0.34848),(0.2,0.34848),(0.22,0.34848),(0.24,0.34848),(0.26,0.34848),(0.28,0.34848),(0.3,0.34848),(0.32,0.34848),(0.34,0.34848),(0.36,0.34848),(0.38,0.34848),(0.4,0.34848),(0.42,0.34848),(0.44,0.34848),(0.46,0.34848),(0.48,0.34848),(0.5,0.34848),(0.52,0.34848),(0.54,0.34848),(0.56,0.34848),(0.58,0.34848),(0.6,0.34848),(0.62,0.34848),(0.64,0.34848),(0.66,0.34848),(0.68,0.34848),(0.7,0.34848),(0.72,0.34848),(0.74,0.34848),(0.76,0.34848),(0.78,0.34848),(0.8,0.34848),(0.82,0.34848),(0.84,0.34848),(0.86,0.34848),(0.88,0.34848),(0.9,0.34848),(0.92,0.34848),(0.94,0.34848),(0.96,0.34848),(0.98,0.34848),(0.99609,0.34848),(0.00391,0.36364),(0.02,0.36364),(0.04,0.36364),(0.06,0.36364),(0.08,0.36364),(0.1,0.36364),(0.12,0.36364),(0.14,0.36364),(0.16,0.36364),(0.18,0.36364),(0.2,0.36364),(0.22,0.36364),(0.24,0.36364),(0.26,0.36364),(0.28,0.36364),(0.3,0.36364),(0.32,0.36364),(0.34,0.36364),(0.36,0.36364),(0.38,0.36364),(0.4,0.36364),(0.42,0.36364),(0.44,0.36364),(0.46,0.36364),(0.48,0.36364),(0.5,0.36364),(0.52,0.36364),(0.54,0.36364),(0.56,0.36364),(0.58,0.36364),(0.6,0.36364),(0.62,0.36364),(0.64,0.36364),(0.66,0.36364),(0.68,0.36364),(0.7,0.36364),(0.72,0.36364),(0.74,0.36364),(0.76,0.36364),(0.78,0.36364),(0.8,0.36364),(0.82,0.36364),(0.84,0.36364),(0.86,0.36364),(0.88,0.36364),(0.9,0.36364),(0.92,0.36364),(0.94,0.36364),(0.96,0.36364),(0.98,0.36364),(0.99609,0.36364),(0.00391,0.37879),(0.02,0.37879),(0.04,0.37879),(0.06,0.37879),(0.08,0.37879),(0.1,0.37879),(0.12,0.37879),(0.14,0.37879),(0.16,0.37879),(0.18,0.37879),(0.2,0.37879),(0.22,0.37879),(0.24,0.37879),(0.26,0.37879),(0.28,0.37879),(0.3,0.37879),(0.32,0.37879),(0.34,0.37879),(0.36,0.37879),(0.38,0.37879),(0.4,0.37879),(0.42,0.37879),(0.44,0.37879),(0.46,0.37879),(0.48,0.37879),(0.5,0.37879),(0.52,0.37879),(0.54,0.37879),(0.56,0.37879),(0.58,0.37879),(0.6,0.37879),(0.62,0.37879),(0.64,0.37879),(0.66,0.37879),(0.68,0.37879),(0.7,0.37879),(0.72,0.37879),(0.74,0.37879),(0.76,0.37879),(0.78,0.37879),(0.8,0.37879),(0.82,0.37879),(0.84,0.37879),(0.86,0.37879),(0.88,0.37879),(0.9,0.37879),(0.92,0.37879),(0.94,0.37879),(0.96,0.37879),(0.98,0.37879),(0.99609,0.37879),(0.00391,0.39394),(0.02,0.39394),(0.04,0.39394),(0.06,0.39394),(0.08,0.39394),(0.1,0.39394),(0.12,0.39394),(0.14,0.39394),(0.16,0.39394),(0.18,0.39394),(0.2,0.39394),(0.22,0.39394),(0.24,0.39394),(0.26,0.39394),(0.28,0.39394),(0.3,0.39394),(0.32,0.39394),(0.34,0.39394),(0.36,0.39394),(0.38,0.39394),(0.4,0.39394),(0.42,0.39394),(0.44,0.39394),(0.46,0.39394),(0.48,0.39394),(0.5,0.39394),(0.52,0.39394),(0.54,0.39394),(0.56,0.39394),(0.58,0.39394),(0.6,0.39394),(0.62,0.39394),(0.64,0.39394),(0.66,0.39394),(0.68,0.39394),(0.7,0.39394),(0.72,0.39394),(0.74,0.39394),(0.76,0.39394),(0.78,0.39394),(0.8,0.39394),(0.82,0.39394),(0.84,0.39394),(0.86,0.39394),(0.88,0.39394),(0.9,0.39394),(0.92,0.39394),(0.94,0.39394),(0.96,0.39394),(0.98,0.39394),(0.99609,0.39394),(0.00391,0.40909),(0.02,0.40909),(0.04,0.40909),(0.06,0.40909),(0.08,0.40909),(0.1,0.40909),(0.12,0.40909),(0.14,0.40909),(0.16,0.40909),(0.18,0.40909),(0.2,0.40909),(0.22,0.40909),(0.24,0.40909),(0.26,0.40909),(0.28,0.40909),(0.3,0.40909),(0.32,0.40909),(0.34,0.40909),(0.36,0.40909),(0.38,0.40909),(0.4,0.40909),(0.42,0.40909),(0.44,0.40909),(0.46,0.40909),(0.48,0.40909),(0.5,0.40909),(0.52,0.40909),(0.54,0.40909),(0.56,0.40909),(0.58,0.40909),(0.6,0.40909),(0.62,0.40909),(0.64,0.40909),(0.66,0.40909),(0.68,0.40909),(0.7,0.40909),(0.72,0.40909),(0.74,0.40909),(0.76,0.40909),(0.78,0.40909),(0.8,0.40909),(0.82,0.40909),(0.84,0.40909),(0.86,0.40909),(0.88,0.40909),(0.9,0.40909),(0.92,0.40909),(0.94,0.40909),(0.96,0.40909),(0.98,0.40909),(0.99609,0.40909),(0.00391,0.42424),(0.02,0.42424),(0.04,0.42424),(0.06,0.42424),(0.08,0.42424),(0.1,0.42424),(0.12,0.42424),(0.14,0.42424),(0.16,0.42424),(0.18,0.42424),(0.2,0.42424),(0.22,0.42424),(0.24,0.42424),(0.26,0.42424),(0.28,0.42424),(0.3,0.42424),(0.32,0.42424),(0.34,0.42424),(0.36,0.42424),(0.38,0.42424),(0.4,0.42424),(0.42,0.42424),(0.44,0.42424),(0.46,0.42424),(0.48,0.42424),(0.5,0.42424),(0.52,0.42424),(0.54,0.42424),(0.56,0.42424),(0.58,0.42424),(0.6,0.42424),(0.62,0.42424),(0.64,0.42424),(0.66,0.42424),(0.68,0.42424),(0.7,0.42424),(0.72,0.42424),(0.74,0.42424),(0.76,0.42424),(0.78,0.42424),(0.8,0.42424),(0.82,0.42424),(0.84,0.42424),(0.86,0.42424),(0.88,0.42424),(0.9,0.42424),(0.92,0.42424),(0.94,0.42424),(0.96,0.42424),(0.98,0.42424),(0.99609,0.42424),(0.00391,0.43939),(0.02,0.43939),(0.04,0.43939),(0.06,0.43939),(0.08,0.43939),(0.1,0.43939),(0.12,0.43939),(0.14,0.43939),(0.16,0.43939),(0.18,0.43939),(0.2,0.43939),(0.22,0.43939),(0.24,0.43939),(0.26,0.43939),(0.28,0.43939),(0.3,0.43939),(0.32,0.43939),(0.34,0.43939),(0.36,0.43939),(0.38,0.43939),(0.4,0.43939),(0.42,0.43939),(0.44,0.43939),(0.46,0.43939),(0.48,0.43939),(0.5,0.43939),(0.52,0.43939),(0.54,0.43939),(0.56,0.43939),(0.58,0.43939),(0.6,0.43939),(0.62,0.43939),(0.64,0.43939),(0.66,0.43939),(0.68,0.43939),(0.7,0.43939),(0.72,0.43939),(0.74,0.43939),(0.76,0.43939),(0.78,0.43939),(0.8,0.43939),(0.82,0.43939),(0.84,0.43939),(0.86,0.43939),(0.88,0.43939),(0.9,0.43939),(0.92,0.43939),(0.94,0.43939),(0.96,0.43939),(0.98,0.43939),(0.99609,0.43939),(0.00391,0.45455),(0.02,0.45455),(0.04,0.45455),(0.06,0.45455),(0.08,0.45455),(0.1,0.45455),(0.12,0.45455),(0.14,0.45455),(0.16,0.45455),(0.18,0.45455),(0.2,0.45455),(0.22,0.45455),(0.24,0.45455),(0.26,0.45455),(0.28,0.45455),(0.3,0.45455),(0.32,0.45455),(0.34,0.45455),(0.36,0.45455),(0.38,0.45455),(0.4,0.45455),(0.42,0.45455),(0.44,0.45455),(0.46,0.45455),(0.48,0.45455),(0.5,0.45455),(0.52,0.45455),(0.54,0.45455),(0.56,0.45455),(0.58,0.45455),(0.6,0.45455),(0.62,0.45455),(0.64,0.45455),(0.66,0.45455),(0.68,0.45455),(0.7,0.45455),(0.72,0.45455),(0.74,0.45455),(0.76,0.45455),(0.78,0.45455),(0.8,0.45455),(0.82,0.45455),(0.84,0.45455),(0.86,0.45455),(0.88,0.45455),(0.9,0.45455),(0.92,0.45455),(0.94,0.45455),(0.96,0.45455),(0.98,0.45455),(0.99609,0.45455),(0.00391,0.4697),(0.02,0.4697),(0.04,0.4697),(0.06,0.4697),(0.08,0.4697),(0.1,0.4697),(0.12,0.4697),(0.14,0.4697),(0.16,0.4697),(0.18,0.4697),(0.2,0.4697),(0.22,0.4697),(0.24,0.4697),(0.26,0.4697),(0.28,0.4697),(0.3,0.4697),(0.32,0.4697),(0.34,0.4697),(0.36,0.4697),(0.38,0.4697),(0.4,0.4697),(0.42,0.4697),(0.44,0.4697),(0.46,0.4697),(0.48,0.4697),(0.5,0.4697),(0.52,0.4697),(0.54,0.4697),(0.56,0.4697),(0.58,0.4697),(0.6,0.4697),(0.62,0.4697),(0.64,0.4697),(0.66,0.4697),(0.68,0.4697),(0.7,0.4697),(0.72,0.4697),(0.74,0.4697),(0.76,0.4697),(0.78,0.4697),(0.8,0.4697),(0.82,0.4697),(0.84,0.4697),(0.86,0.4697),(0.88,0.4697),(0.9,0.4697),(0.92,0.4697),(0.94,0.4697),(0.96,0.4697),(0.98,0.4697),(0.99609,0.4697),(0.00391,0.48485),(0.02,0.48485),(0.04,0.48485),(0.06,0.48485),(0.08,0.48485),(0.1,0.48485),(0.12,0.48485),(0.14,0.48485),(0.16,0.48485),(0.18,0.48485),(0.2,0.48485),(0.22,0.48485),(0.24,0.48485),(0.26,0.48485),(0.28,0.48485),(0.3,0.48485),(0.32,0.48485),(0.34,0.48485),(0.36,0.48485),(0.38,0.48485),(0.4,0.48485),(0.42,0.48485),(0.44,0.48485),(0.46,0.48485),(0.48,0.48485),(0.5,0.48485),(0.52,0.48485),(0.54,0.48485),(0.56,0.48485),(0.58,0.48485),(0.6,0.48485),(0.62,0.48485),(0.64,0.48485),(0.66,0.48485),(0.68,0.48485),(0.7,0.48485),(0.72,0.48485),(0.74,0.48485),(0.76,0.48485),(0.78,0.48485),(0.8,0.48485),(0.82,0.48485),(0.84,0.48485),(0.86,0.48485),(0.88,0.48485),(0.9,0.48485),(0.92,0.48485),(0.94,0.48485),(0.96,0.48485),(0.98,0.48485),(0.99609,0.48485),(0.00391,0.5),(0.02,0.5),(0.04,0.5),(0.06,0.5),(0.08,0.5),(0.1,0.5),(0.12,0.5),(0.14,0.5),(0.16,0.5),(0.18,0.5),(0.2,0.5),(0.22,0.5),(0.24,0.5),(0.26,0.5),(0.28,0.5),(0.3,0.5),(0.32,0.5),(0.34,0.5),(0.36,0.5),(0.38,0.5),(0.4,0.5),(0.42,0.5),(0.44,0.5),(0.46,0.5),(0.48,0.5),(0.5,0.5),(0.52,0.5),(0.54,0.5),(0.56,0.5),(0.58,0.5),(0.6,0.5),(0.62,0.5),(0.64,0.5),(0.66,0.5),(0.68,0.5),(0.7,0.5),(0.72,0.5),(0.74,0.5),(0.76,0.5),(0.78,0.5),(0.8,0.5),(0.82,0.5),(0.84,0.5),(0.86,0.5),(0.88,0.5),(0.9,0.5),(0.92,0.5),(0.94,0.5),(0.96,0.5),(0.98,0.5),(0.99609,0.5),(0.00391,0.51515),(0.02,0.51515),(0.04,0.51515),(0.06,0.51515),(0.08,0.51515),(0.1,0.51515),(0.12,0.51515),(0.14,0.51515),(0.16,0.51515),(0.18,0.51515),(0.2,0.51515),(0.22,0.51515),(0.24,0.51515),(0.26,0.51515),(0.28,0.51515),(0.3,0.51515),(0.32,0.51515),(0.34,0.51515),(0.36,0.51515),(0.38,0.51515),(0.4,0.51515),(0.42,0.51515),(0.44,0.51515),(0.46,0.51515),(0.48,0.51515),(0.5,0.51515),(0.52,0.51515),(0.54,0.51515),(0.56,0.51515),(0.58,0.51515),(0.6,0.51515),(0.62,0.51515),(0.64,0.51515),(0.66,0.51515),(0.68,0.51515),(0.7,0.51515),(0.72,0.51515),(0.74,0.51515),(0.76,0.51515),(0.78,0.51515),(0.8,0.51515),(0.82,0.51515),(0.84,0.51515),(0.86,0.51515),(0.88,0.51515),(0.9,0.51515),(0.92,0.51515),(0.94,0.51515),(0.96,0.51515),(0.98,0.51515),(0.99609,0.51515),(0.00391,0.5303),(0.02,0.5303),(0.04,0.5303),(0.06,0.5303),(0.08,0.5303),(0.1,0.5303),(0.12,0.5303),(0.14,0.5303),(0.16,0.5303),(0.18,0.5303),(0.2,0.5303),(0.22,0.5303),(0.24,0.5303),(0.26,0.5303),(0.28,0.5303),(0.3,0.5303),(0.32,0.5303),(0.34,0.5303),(0.36,0.5303),(0.38,0.5303),(0.4,0.5303),(0.42,0.5303),(0.44,0.5303),(0.46,0.5303),(0.48,0.5303),(0.5,0.5303),(0.52,0.5303),(0.54,0.5303),(0.56,0.5303),(0.58,0.5303),(0.6,0.5303),(0.62,0.5303),(0.64,0.5303),(0.66,0.5303),(0.68,0.5303),(0.7,0.5303),(0.72,0.5303),(0.74,0.5303),(0.76,0.5303),(0.78,0.5303),(0.8,0.5303),(0.82,0.5303),(0.84,0.5303),(0.86,0.5303),(0.88,0.5303),(0.9,0.5303),(0.92,0.5303),(0.94,0.5303),(0.96,0.5303),(0.98,0.5303),(0.99609,0.5303),(0.00391,0.54545),(0.02,0.54545),(0.04,0.54545),(0.06,0.54545),(0.08,0.54545),(0.1,0.54545),(0.12,0.54545),(0.14,0.54545),(0.16,0.54545),(0.18,0.54545),(0.2,0.54545),(0.22,0.54545),(0.24,0.54545),(0.26,0.54545),(0.28,0.54545),(0.3,0.54545),(0.32,0.54545),(0.34,0.54545),(0.36,0.54545),(0.38,0.54545),(0.4,0.54545),(0.42,0.54545),(0.44,0.54545),(0.46,0.54545),(0.48,0.54545),(0.5,0.54545),(0.52,0.54545),(0.54,0.54545),(0.56,0.54545),(0.58,0.54545),(0.6,0.54545),(0.62,0.54545),(0.64,0.54545),(0.66,0.54545),(0.68,0.54545),(0.7,0.54545),(0.72,0.54545),(0.74,0.54545),(0.76,0.54545),(0.78,0.54545),(0.8,0.54545),(0.82,0.54545),(0.84,0.54545),(0.86,0.54545),(0.88,0.54545),(0.9,0.54545),(0.92,0.54545),(0.94,0.54545),(0.96,0.54545),(0.98,0.54545),(0.99609,0.54545),(0.00391,0.56061),(0.02,0.56061),(0.04,0.56061),(0.06,0.56061),(0.08,0.56061),(0.1,0.56061),(0.12,0.56061),(0.14,0.56061),(0.16,0.56061),(0.18,0.56061),(0.2,0.56061),(0.22,0.56061),(0.24,0.56061),(0.26,0.56061),(0.28,0.56061),(0.3,0.56061),(0.32,0.56061),(0.34,0.56061),(0.36,0.56061),(0.38,0.56061),(0.4,0.56061),(0.42,0.56061),(0.44,0.56061),(0.46,0.56061),(0.48,0.56061),(0.5,0.56061),(0.52,0.56061),(0.54,0.56061),(0.56,0.56061),(0.58,0.56061),(0.6,0.56061),(0.62,0.56061),(0.64,0.56061),(0.66,0.56061),(0.68,0.56061),(0.7,0.56061),(0.72,0.56061),(0.74,0.56061),(0.76,0.56061),(0.78,0.56061),(0.8,0.56061),(0.82,0.56061),(0.84,0.56061),(0.86,0.56061),(0.88,0.56061),(0.9,0.56061),(0.92,0.56061),(0.94,0.56061),(0.96,0.56061),(0.98,0.56061),(0.99609,0.56061),(0.00391,0.57576),(0.02,0.57576),(0.04,0.57576),(0.06,0.57576),(0.08,0.57576),(0.1,0.57576),(0.12,0.57576),(0.14,0.57576),(0.16,0.57576),(0.18,0.57576),(0.2,0.57576),(0.22,0.57576),(0.24,0.57576),(0.26,0.57576),(0.28,0.57576),(0.3,0.57576),(0.32,0.57576),(0.34,0.57576),(0.36,0.57576),(0.38,0.57576),(0.4,0.57576),(0.42,0.57576),(0.44,0.57576),(0.46,0.57576),(0.48,0.57576),(0.5,0.57576),(0.52,0.57576),(0.54,0.57576),(0.56,0.57576),(0.58,0.57576),(0.6,0.57576),(0.62,0.57576),(0.64,0.57576),(0.66,0.57576),(0.68,0.57576),(0.7,0.57576),(0.72,0.57576),(0.74,0.57576),(0.76,0.57576),(0.78,0.57576),(0.8,0.57576),(0.82,0.57576),(0.84,0.57576),(0.86,0.57576),(0.88,0.57576),(0.9,0.57576),(0.92,0.57576),(0.94,0.57576),(0.96,0.57576),(0.98,0.57576),(0.99609,0.57576),(0.00391,0.59091),(0.02,0.59091),(0.04,0.59091),(0.06,0.59091),(0.08,0.59091),(0.1,0.59091),(0.12,0.59091),(0.14,0.59091),(0.16,0.59091),(0.18,0.59091),(0.2,0.59091),(0.22,0.59091),(0.24,0.59091),(0.26,0.59091),(0.28,0.59091),(0.3,0.59091),(0.32,0.59091),(0.34,0.59091),(0.36,0.59091),(0.38,0.59091),(0.4,0.59091),(0.42,0.59091),(0.44,0.59091),(0.46,0.59091),(0.48,0.59091),(0.5,0.59091),(0.52,0.59091),(0.54,0.59091),(0.56,0.59091),(0.58,0.59091),(0.6,0.59091),(0.62,0.59091),(0.64,0.59091),(0.66,0.59091),(0.68,0.59091),(0.7,0.59091),(0.72,0.59091),(0.74,0.59091),(0.76,0.59091),(0.78,0.59091),(0.8,0.59091),(0.82,0.59091),(0.84,0.59091),(0.86,0.59091),(0.88,0.59091),(0.9,0.59091),(0.92,0.59091),(0.94,0.59091),(0.96,0.59091),(0.98,0.59091),(0.99609,0.59091),(0.00391,0.60606),(0.02,0.60606),(0.04,0.60606),(0.06,0.60606),(0.08,0.60606),(0.1,0.60606),(0.12,0.60606),(0.14,0.60606),(0.16,0.60606),(0.18,0.60606),(0.2,0.60606),(0.22,0.60606),(0.24,0.60606),(0.26,0.60606),(0.28,0.60606),(0.3,0.60606),(0.32,0.60606),(0.34,0.60606),(0.36,0.60606),(0.38,0.60606),(0.4,0.60606),(0.42,0.60606),(0.44,0.60606),(0.46,0.60606),(0.48,0.60606),(0.5,0.60606),(0.52,0.60606),(0.54,0.60606),(0.56,0.60606),(0.58,0.60606),(0.6,0.60606),(0.62,0.60606),(0.64,0.60606),(0.66,0.60606),(0.68,0.60606),(0.7,0.60606),(0.72,0.60606),(0.74,0.60606),(0.76,0.60606),(0.78,0.60606),(0.8,0.60606),(0.82,0.60606),(0.84,0.60606),(0.86,0.60606),(0.88,0.60606),(0.9,0.60606),(0.92,0.60606),(0.94,0.60606),(0.96,0.60606),(0.98,0.60606),(0.99609,0.60606),(0.00391,0.62121),(0.02,0.62121),(0.04,0.62121),(0.06,0.62121),(0.08,0.62121),(0.1,0.62121),(0.12,0.62121),(0.14,0.62121),(0.16,0.62121),(0.18,0.62121),(0.2,0.62121),(0.22,0.62121),(0.24,0.62121),(0.26,0.62121),(0.28,0.62121),(0.3,0.62121),(0.32,0.62121),(0.34,0.62121),(0.36,0.62121),(0.38,0.62121),(0.4,0.62121),(0.42,0.62121),(0.44,0.62121),(0.46,0.62121),(0.48,0.62121),(0.5,0.62121),(0.52,0.62121),(0.54,0.62121),(0.56,0.62121),(0.58,0.62121),(0.6,0.62121),(0.62,0.62121),(0.64,0.62121),(0.66,0.62121),(0.68,0.62121),(0.7,0.62121),(0.72,0.62121),(0.74,0.62121),(0.76,0.62121),(0.78,0.62121),(0.8,0.62121),(0.82,0.62121),(0.84,0.62121),(0.86,0.62121),(0.88,0.62121),(0.9,0.62121),(0.92,0.62121),(0.94,0.62121),(0.96,0.62121),(0.98,0.62121),(0.99609,0.62121),(0.00391,0.63636),(0.02,0.63636),(0.04,0.63636),(0.06,0.63636),(0.08,0.63636),(0.1,0.63636),(0.12,0.63636),(0.14,0.63636),(0.16,0.63636),(0.18,0.63636),(0.2,0.63636),(0.22,0.63636),(0.24,0.63636),(0.26,0.63636),(0.28,0.63636),(0.3,0.63636),(0.32,0.63636),(0.34,0.63636),(0.36,0.63636),(0.38,0.63636),(0.4,0.63636),(0.42,0.63636),(0.44,0.63636),(0.46,0.63636),(0.48,0.63636),(0.5,0.63636),(0.52,0.63636),(0.54,0.63636),(0.56,0.63636),(0.58,0.63636),(0.6,0.63636),(0.62,0.63636),(0.64,0.63636),(0.66,0.63636),(0.68,0.63636),(0.7,0.63636),(0.72,0.63636),(0.74,0.63636),(0.76,0.63636),(0.78,0.63636),(0.8,0.63636),(0.82,0.63636),(0.84,0.63636),(0.86,0.63636),(0.88,0.63636),(0.9,0.63636),(0.92,0.63636),(0.94,0.63636),(0.96,0.63636),(0.98,0.63636),(0.99609,0.63636),(0.00391,0.65152),(0.02,0.65152),(0.04,0.65152),(0.06,0.65152),(0.08,0.65152),(0.1,0.65152),(0.12,0.65152),(0.14,0.65152),(0.16,0.65152),(0.18,0.65152),(0.2,0.65152),(0.22,0.65152),(0.24,0.65152),(0.26,0.65152),(0.28,0.65152),(0.3,0.65152),(0.32,0.65152),(0.34,0.65152),(0.36,0.65152),(0.38,0.65152),(0.4,0.65152),(0.42,0.65152),(0.44,0.65152),(0.46,0.65152),(0.48,0.65152),(0.5,0.65152),(0.52,0.65152),(0.54,0.65152),(0.56,0.65152),(0.58,0.65152),(0.6,0.65152),(0.62,0.65152),(0.64,0.65152),(0.66,0.65152),(0.68,0.65152),(0.7,0.65152),(0.72,0.65152),(0.74,0.65152),(0.76,0.65152),(0.78,0.65152),(0.8,0.65152),(0.82,0.65152),(0.84,0.65152),(0.86,0.65152),(0.88,0.65152),(0.9,0.65152),(0.92,0.65152),(0.94,0.65152),(0.96,0.65152),(0.98,0.65152),(0.99609,0.65152),(0.00391,0.66667),(0.02,0.66667),(0.04,0.66667),(0.06,0.66667),(0.08,0.66667),(0.1,0.66667),(0.12,0.66667),(0.14,0.66667),(0.16,0.66667),(0.18,0.66667),(0.2,0.66667),(0.22,0.66667),(0.24,0.66667),(0.26,0.66667),(0.28,0.66667),(0.3,0.66667),(0.32,0.66667),(0.34,0.66667),(0.36,0.66667),(0.38,0.66667),(0.4,0.66667),(0.42,0.66667),(0.44,0.66667),(0.46,0.66667),(0.48,0.66667),(0.5,0.66667),(0.52,0.66667),(0.54,0.66667),(0.56,0.66667),(0.58,0.66667),(0.6,0.66667),(0.62,0.66667),(0.64,0.66667),(0.66,0.66667),(0.68,0.66667),(0.7,0.66667),(0.72,0.66667),(0.74,0.66667),(0.76,0.66667),(0.78,0.66667),(0.8,0.66667),(0.82,0.66667),(0.84,0.66667),(0.86,0.66667),(0.88,0.66667),(0.9,0.66667),(0.92,0.66667),(0.94,0.66667),(0.96,0.66667),(0.98,0.66667),(0.99609,0.66667),(0.00391,0.68182),(0.02,0.68182),(0.04,0.68182),(0.06,0.68182),(0.08,0.68182),(0.1,0.68182),(0.12,0.68182),(0.14,0.68182),(0.16,0.68182),(0.18,0.68182),(0.2,0.68182),(0.22,0.68182),(0.24,0.68182),(0.26,0.68182),(0.28,0.68182),(0.3,0.68182),(0.32,0.68182),(0.34,0.68182),(0.36,0.68182),(0.38,0.68182),(0.4,0.68182),(0.42,0.68182),(0.44,0.68182),(0.46,0.68182),(0.48,0.68182),(0.5,0.68182),(0.52,0.68182),(0.54,0.68182),(0.56,0.68182),(0.58,0.68182),(0.6,0.68182),(0.62,0.68182),(0.64,0.68182),(0.66,0.68182),(0.68,0.68182),(0.7,0.68182),(0.72,0.68182),(0.74,0.68182),(0.76,0.68182),(0.78,0.68182),(0.8,0.68182),(0.82,0.68182),(0.84,0.68182),(0.86,0.68182),(0.88,0.68182),(0.9,0.68182),(0.92,0.68182),(0.94,0.68182),(0.96,0.68182),(0.98,0.68182),(0.99609,0.68182),(0.00391,0.69697),(0.02,0.69697),(0.04,0.69697),(0.06,0.69697),(0.08,0.69697),(0.1,0.69697),(0.12,0.69697),(0.14,0.69697),(0.16,0.69697),(0.18,0.69697),(0.2,0.69697),(0.22,0.69697),(0.24,0.69697),(0.26,0.69697),(0.28,0.69697),(0.3,0.69697),(0.32,0.69697),(0.34,0.69697),(0.36,0.69697),(0.38,0.69697),(0.4,0.69697),(0.42,0.69697),(0.44,0.69697),(0.46,0.69697),(0.48,0.69697),(0.5,0.69697),(0.52,0.69697),(0.54,0.69697),(0.56,0.69697),(0.58,0.69697),(0.6,0.69697),(0.62,0.69697),(0.64,0.69697),(0.66,0.69697),(0.68,0.69697),(0.7,0.69697),(0.72,0.69697),(0.74,0.69697),(0.76,0.69697),(0.78,0.69697),(0.8,0.69697),(0.82,0.69697),(0.84,0.69697),(0.86,0.69697),(0.88,0.69697),(0.9,0.69697),(0.92,0.69697),(0.94,0.69697),(0.96,0.69697),(0.98,0.69697),(0.99609,0.69697),(0.00391,0.71212),(0.02,0.71212),(0.04,0.71212),(0.06,0.71212),(0.08,0.71212),(0.1,0.71212),(0.12,0.71212),(0.14,0.71212),(0.16,0.71212),(0.18,0.71212),(0.2,0.71212),(0.22,0.71212),(0.24,0.71212),(0.26,0.71212),(0.28,0.71212),(0.3,0.71212),(0.32,0.71212),(0.34,0.71212),(0.36,0.71212),(0.38,0.71212),(0.4,0.71212),(0.42,0.71212),(0.44,0.71212),(0.46,0.71212),(0.48,0.71212),(0.5,0.71212),(0.52,0.71212),(0.54,0.71212),(0.56,0.71212),(0.58,0.71212),(0.6,0.71212),(0.62,0.71212),(0.64,0.71212),(0.66,0.71212),(0.68,0.71212),(0.7,0.71212),(0.72,0.71212),(0.74,0.71212),(0.76,0.71212),(0.78,0.71212),(0.8,0.71212),(0.82,0.71212),(0.84,0.71212),(0.86,0.71212),(0.88,0.71212),(0.9,0.71212),(0.92,0.71212),(0.94,0.71212),(0.96,0.71212),(0.98,0.71212),(0.99609,0.71212),(0.00391,0.72727),(0.02,0.72727),(0.04,0.72727),(0.06,0.72727),(0.08,0.72727),(0.1,0.72727),(0.12,0.72727),(0.14,0.72727),(0.16,0.72727),(0.18,0.72727),(0.2,0.72727),(0.22,0.72727),(0.24,0.72727),(0.26,0.72727),(0.28,0.72727),(0.3,0.72727),(0.32,0.72727),(0.34,0.72727),(0.36,0.72727),(0.38,0.72727),(0.4,0.72727),(0.42,0.72727),(0.44,0.72727),(0.46,0.72727),(0.48,0.72727),(0.5,0.72727),(0.52,0.72727),(0.54,0.72727),(0.56,0.72727),(0.58,0.72727),(0.6,0.72727),(0.62,0.72727),(0.64,0.72727),(0.66,0.72727),(0.68,0.72727),(0.7,0.72727),(0.72,0.72727),(0.74,0.72727),(0.76,0.72727),(0.78,0.72727),(0.8,0.72727),(0.82,0.72727),(0.84,0.72727),(0.86,0.72727),(0.88,0.72727),(0.9,0.72727),(0.92,0.72727),(0.94,0.72727),(0.96,0.72727),(0.98,0.72727),(0.99609,0.72727),(0.00391,0.74242),(0.02,0.74242),(0.04,0.74242),(0.06,0.74242),(0.08,0.74242),(0.1,0.74242),(0.12,0.74242),(0.14,0.74242),(0.16,0.74242),(0.18,0.74242),(0.2,0.74242),(0.22,0.74242),(0.24,0.74242),(0.26,0.74242),(0.28,0.74242),(0.3,0.74242),(0.32,0.74242),(0.34,0.74242),(0.36,0.74242),(0.38,0.74242),(0.4,0.74242),(0.42,0.74242),(0.44,0.74242),(0.46,0.74242),(0.48,0.74242),(0.5,0.74242),(0.52,0.74242),(0.54,0.74242),(0.56,0.74242),(0.58,0.74242),(0.6,0.74242),(0.62,0.74242),(0.64,0.74242),(0.66,0.74242),(0.68,0.74242),(0.7,0.74242),(0.72,0.74242),(0.74,0.74242),(0.76,0.74242),(0.78,0.74242),(0.8,0.74242),(0.82,0.74242),(0.84,0.74242),(0.86,0.74242),(0.88,0.74242),(0.9,0.74242),(0.92,0.74242),(0.94,0.74242),(0.96,0.74242),(0.98,0.74242),(0.99609,0.74242),(0.00391,0.75758),(0.02,0.75758),(0.04,0.75758),(0.06,0.75758),(0.08,0.75758),(0.1,0.75758),(0.12,0.75758),(0.14,0.75758),(0.16,0.75758),(0.18,0.75758),(0.2,0.75758),(0.22,0.75758),(0.24,0.75758),(0.26,0.75758),(0.28,0.75758),(0.3,0.75758),(0.32,0.75758),(0.34,0.75758),(0.36,0.75758),(0.38,0.75758),(0.4,0.75758),(0.42,0.75758),(0.44,0.75758),(0.46,0.75758),(0.48,0.75758),(0.5,0.75758),(0.52,0.75758),(0.54,0.75758),(0.56,0.75758),(0.58,0.75758),(0.6,0.75758),(0.62,0.75758),(0.64,0.75758),(0.66,0.75758),(0.68,0.75758),(0.7,0.75758),(0.72,0.75758),(0.74,0.75758),(0.76,0.75758),(0.78,0.75758),(0.8,0.75758),(0.82,0.75758),(0.84,0.75758),(0.86,0.75758),(0.88,0.75758),(0.9,0.75758),(0.92,0.75758),(0.94,0.75758),(0.96,0.75758),(0.98,0.75758),(0.99609,0.75758),(0.00391,0.77273),(0.02,0.77273),(0.04,0.77273),(0.06,0.77273),(0.08,0.77273),(0.1,0.77273),(0.12,0.77273),(0.14,0.77273),(0.16,0.77273),(0.18,0.77273),(0.2,0.77273),(0.22,0.77273),(0.24,0.77273),(0.26,0.77273),(0.28,0.77273),(0.3,0.77273),(0.32,0.77273),(0.34,0.77273),(0.36,0.77273),(0.38,0.77273),(0.4,0.77273),(0.42,0.77273),(0.44,0.77273),(0.46,0.77273),(0.48,0.77273),(0.5,0.77273),(0.52,0.77273),(0.54,0.77273),(0.56,0.77273),(0.58,0.77273),(0.6,0.77273),(0.62,0.77273),(0.64,0.77273),(0.66,0.77273),(0.68,0.77273),(0.7,0.77273),(0.72,0.77273),(0.74,0.77273),(0.76,0.77273),(0.78,0.77273),(0.8,0.77273),(0.82,0.77273),(0.84,0.77273),(0.86,0.77273),(0.88,0.77273),(0.9,0.77273),(0.92,0.77273),(0.94,0.77273),(0.96,0.77273),(0.98,0.77273),(0.99609,0.77273),(0.00391,0.78788),(0.02,0.78788),(0.04,0.78788),(0.06,0.78788),(0.08,0.78788),(0.1,0.78788),(0.12,0.78788),(0.14,0.78788),(0.16,0.78788),(0.18,0.78788),(0.2,0.78788),(0.22,0.78788),(0.24,0.78788),(0.26,0.78788),(0.28,0.78788),(0.3,0.78788),(0.32,0.78788),(0.34,0.78788),(0.36,0.78788),(0.38,0.78788),(0.4,0.78788),(0.42,0.78788),(0.44,0.78788),(0.46,0.78788),(0.48,0.78788),(0.5,0.78788),(0.52,0.78788),(0.54,0.78788),(0.56,0.78788),(0.58,0.78788),(0.6,0.78788),(0.62,0.78788),(0.64,0.78788),(0.66,0.78788),(0.68,0.78788),(0.7,0.78788),(0.72,0.78788),(0.74,0.78788),(0.76,0.78788),(0.78,0.78788),(0.8,0.78788),(0.82,0.78788),(0.84,0.78788),(0.86,0.78788),(0.88,0.78788),(0.9,0.78788),(0.92,0.78788),(0.94,0.78788),(0.96,0.78788),(0.98,0.78788),(0.99609,0.78788),(0.00391,0.80303),(0.02,0.80303),(0.04,0.80303),(0.06,0.80303),(0.08,0.80303),(0.1,0.80303),(0.12,0.80303),(0.14,0.80303),(0.16,0.80303),(0.18,0.80303),(0.2,0.80303),(0.22,0.80303),(0.24,0.80303),(0.26,0.80303),(0.28,0.80303),(0.3,0.80303),(0.32,0.80303),(0.34,0.80303),(0.36,0.80303),(0.38,0.80303),(0.4,0.80303),(0.42,0.80303),(0.44,0.80303),(0.46,0.80303),(0.48,0.80303),(0.5,0.80303),(0.52,0.80303),(0.54,0.80303),(0.56,0.80303),(0.58,0.80303),(0.6,0.80303),(0.62,0.80303),(0.64,0.80303),(0.66,0.80303),(0.68,0.80303),(0.7,0.80303),(0.72,0.80303),(0.74,0.80303),(0.76,0.80303),(0.78,0.80303),(0.8,0.80303),(0.82,0.80303),(0.84,0.80303),(0.86,0.80303),(0.88,0.80303),(0.9,0.80303),(0.92,0.80303),(0.94,0.80303),(0.96,0.80303),(0.98,0.80303),(0.99609,0.80303),(0.00391,0.81818),(0.02,0.81818),(0.04,0.81818),(0.06,0.81818),(0.08,0.81818),(0.1,0.81818),(0.12,0.81818),(0.14,0.81818),(0.16,0.81818),(0.18,0.81818),(0.2,0.81818),(0.22,0.81818),(0.24,0.81818),(0.26,0.81818),(0.28,0.81818),(0.3,0.81818),(0.32,0.81818),(0.34,0.81818),(0.36,0.81818),(0.38,0.81818),(0.4,0.81818),(0.42,0.81818),(0.44,0.81818),(0.46,0.81818),(0.48,0.81818),(0.5,0.81818),(0.52,0.81818),(0.54,0.81818),(0.56,0.81818),(0.58,0.81818),(0.6,0.81818),(0.62,0.81818),(0.64,0.81818),(0.66,0.81818),(0.68,0.81818),(0.7,0.81818),(0.72,0.81818),(0.74,0.81818),(0.76,0.81818),(0.78,0.81818),(0.8,0.81818),(0.82,0.81818),(0.84,0.81818),(0.86,0.81818),(0.88,0.81818),(0.9,0.81818),(0.92,0.81818),(0.94,0.81818),(0.96,0.81818),(0.98,0.81818),(0.99609,0.81818),(0.00391,0.83333),(0.02,0.83333),(0.04,0.83333),(0.06,0.83333),(0.08,0.83333),(0.1,0.83333),(0.12,0.83333),(0.14,0.83333),(0.16,0.83333),(0.18,0.83333),(0.2,0.83333),(0.22,0.83333),(0.24,0.83333),(0.26,0.83333),(0.28,0.83333),(0.3,0.83333),(0.32,0.83333),(0.34,0.83333),(0.36,0.83333),(0.38,0.83333),(0.4,0.83333),(0.42,0.83333),(0.44,0.83333),(0.46,0.83333),(0.48,0.83333),(0.5,0.83333),(0.52,0.83333),(0.54,0.83333),(0.56,0.83333),(0.58,0.83333),(0.6,0.83333),(0.62,0.83333),(0.64,0.83333),(0.66,0.83333),(0.68,0.83333),(0.7,0.83333),(0.72,0.83333),(0.74,0.83333),(0.76,0.83333),(0.78,0.83333),(0.8,0.83333),(0.82,0.83333),(0.84,0.83333),(0.86,0.83333),(0.88,0.83333),(0.9,0.83333),(0.92,0.83333),(0.94,0.83333),(0.96,0.83333),(0.98,0.83333),(0.99609,0.83333),(0.00391,0.84848),(0.02,0.84848),(0.04,0.84848),(0.06,0.84848),(0.08,0.84848),(0.1,0.84848),(0.12,0.84848),(0.14,0.84848),(0.16,0.84848),(0.18,0.84848),(0.2,0.84848),(0.22,0.84848),(0.24,0.84848),(0.26,0.84848),(0.28,0.84848),(0.3,0.84848),(0.32,0.84848),(0.34,0.84848),(0.36,0.84848),(0.38,0.84848),(0.4,0.84848),(0.42,0.84848),(0.44,0.84848),(0.46,0.84848),(0.48,0.84848),(0.5,0.84848),(0.52,0.84848),(0.54,0.84848),(0.56,0.84848),(0.58,0.84848),(0.6,0.84848),(0.62,0.84848),(0.64,0.84848),(0.66,0.84848),(0.68,0.84848),(0.7,0.84848),(0.72,0.84848),(0.74,0.84848),(0.76,0.84848),(0.78,0.84848),(0.8,0.84848),(0.82,0.84848),(0.84,0.84848),(0.86,0.84848),(0.88,0.84848),(0.9,0.84848),(0.92,0.84848),(0.94,0.84848),(0.96,0.84848),(0.98,0.84848),(0.99609,0.84848),(0.00391,0.86364),(0.02,0.86364),(0.04,0.86364),(0.06,0.86364),(0.08,0.86364),(0.1,0.86364),(0.12,0.86364),(0.14,0.86364),(0.16,0.86364),(0.18,0.86364),(0.2,0.86364),(0.22,0.86364),(0.24,0.86364),(0.26,0.86364),(0.28,0.86364),(0.3,0.86364),(0.32,0.86364),(0.34,0.86364),(0.36,0.86364),(0.38,0.86364),(0.4,0.86364),(0.42,0.86364),(0.44,0.86364),(0.46,0.86364),(0.48,0.86364),(0.5,0.86364),(0.52,0.86364),(0.54,0.86364),(0.56,0.86364),(0.58,0.86364),(0.6,0.86364),(0.62,0.86364),(0.64,0.86364),(0.66,0.86364),(0.68,0.86364),(0.7,0.86364),(0.72,0.86364),(0.74,0.86364),(0.76,0.86364),(0.78,0.86364),(0.8,0.86364),(0.82,0.86364),(0.84,0.86364),(0.86,0.86364),(0.88,0.86364),(0.9,0.86364),(0.92,0.86364),(0.94,0.86364),(0.96,0.86364),(0.98,0.86364),(0.99609,0.86364),(0.00391,0.87879),(0.02,0.87879),(0.04,0.87879),(0.06,0.87879),(0.08,0.87879),(0.1,0.87879),(0.12,0.87879),(0.14,0.87879),(0.16,0.87879),(0.18,0.87879),(0.2,0.87879),(0.22,0.87879),(0.24,0.87879),(0.26,0.87879),(0.28,0.87879),(0.3,0.87879),(0.32,0.87879),(0.34,0.87879),(0.36,0.87879),(0.38,0.87879),(0.4,0.87879),(0.42,0.87879),(0.44,0.87879),(0.46,0.87879),(0.48,0.87879),(0.5,0.87879),(0.52,0.87879),(0.54,0.87879),(0.56,0.87879),(0.58,0.87879),(0.6,0.87879),(0.62,0.87879),(0.64,0.87879),(0.66,0.87879),(0.68,0.87879),(0.7,0.87879),(0.72,0.87879),(0.74,0.87879),(0.76,0.87879),(0.78,0.87879),(0.8,0.87879),(0.82,0.87879),(0.84,0.87879),(0.86,0.87879),(0.88,0.87879),(0.9,0.87879),(0.92,0.87879),(0.94,0.87879),(0.96,0.87879),(0.98,0.87879),(0.99609,0.87879),(0.00391,0.89394),(0.02,0.89394),(0.04,0.89394),(0.06,0.89394),(0.08,0.89394),(0.1,0.89394),(0.12,0.89394),(0.14,0.89394),(0.16,0.89394),(0.18,0.89394),(0.2,0.89394),(0.22,0.89394),(0.24,0.89394),(0.26,0.89394),(0.28,0.89394),(0.3,0.89394),(0.32,0.89394),(0.34,0.89394),(0.36,0.89394),(0.38,0.89394),(0.4,0.89394),(0.42,0.89394),(0.44,0.89394),(0.46,0.89394),(0.48,0.89394),(0.5,0.89394),(0.52,0.89394),(0.54,0.89394),(0.56,0.89394),(0.58,0.89394),(0.6,0.89394),(0.62,0.89394),(0.64,0.89394),(0.66,0.89394),(0.68,0.89394),(0.7,0.89394),(0.72,0.89394),(0.74,0.89394),(0.76,0.89394),(0.78,0.89394),(0.8,0.89394),(0.82,0.89394),(0.84,0.89394),(0.86,0.89394),(0.88,0.89394),(0.9,0.89394),(0.92,0.89394),(0.94,0.89394),(0.96,0.89394),(0.98,0.89394),(0.99609,0.89394),(0.00391,0.90909),(0.02,0.90909),(0.04,0.90909),(0.06,0.90909),(0.08,0.90909),(0.1,0.90909),(0.12,0.90909),(0.14,0.90909),(0.16,0.90909),(0.18,0.90909),(0.2,0.90909),(0.22,0.90909),(0.24,0.90909),(0.26,0.90909),(0.28,0.90909),(0.3,0.90909),(0.32,0.90909),(0.34,0.90909),(0.36,0.90909),(0.38,0.90909),(0.4,0.90909),(0.42,0.90909),(0.44,0.90909),(0.46,0.90909),(0.48,0.90909),(0.5,0.90909),(0.52,0.90909),(0.54,0.90909),(0.56,0.90909),(0.58,0.90909),(0.6,0.90909),(0.62,0.90909),(0.64,0.90909),(0.66,0.90909),(0.68,0.90909),(0.7,0.90909),(0.72,0.90909),(0.74,0.90909),(0.76,0.90909),(0.78,0.90909),(0.8,0.90909),(0.82,0.90909),(0.84,0.90909),(0.86,0.90909),(0.88,0.90909),(0.9,0.90909),(0.92,0.90909),(0.94,0.90909),(0.96,0.90909),(0.98,0.90909),(0.99609,0.90909),(0.00391,0.92424),(0.02,0.92424),(0.04,0.92424),(0.06,0.92424),(0.08,0.92424),(0.1,0.92424),(0.12,0.92424),(0.14,0.92424),(0.16,0.92424),(0.18,0.92424),(0.2,0.92424),(0.22,0.92424),(0.24,0.92424),(0.26,0.92424),(0.28,0.92424),(0.3,0.92424),(0.32,0.92424),(0.34,0.92424),(0.36,0.92424),(0.38,0.92424),(0.4,0.92424),(0.42,0.92424),(0.44,0.92424),(0.46,0.92424),(0.48,0.92424),(0.5,0.92424),(0.52,0.92424),(0.54,0.92424),(0.56,0.92424),(0.58,0.92424),(0.6,0.92424),(0.62,0.92424),(0.64,0.92424),(0.66,0.92424),(0.68,0.92424),(0.7,0.92424),(0.72,0.92424),(0.74,0.92424),(0.76,0.92424),(0.78,0.92424),(0.8,0.92424),(0.82,0.92424),(0.84,0.92424),(0.86,0.92424),(0.88,0.92424),(0.9,0.92424),(0.92,0.92424),(0.94,0.92424),(0.96,0.92424),(0.98,0.92424),(0.99609,0.92424),(0.00391,0.93939),(0.02,0.93939),(0.04,0.93939),(0.06,0.93939),(0.08,0.93939),(0.1,0.93939),(0.12,0.93939),(0.14,0.93939),(0.16,0.93939),(0.18,0.93939),(0.2,0.93939),(0.22,0.93939),(0.24,0.93939),(0.26,0.93939),(0.28,0.93939),(0.3,0.93939),(0.32,0.93939),(0.34,0.93939),(0.36,0.93939),(0.38,0.93939),(0.4,0.93939),(0.42,0.93939),(0.44,0.93939),(0.46,0.93939),(0.48,0.93939),(0.5,0.93939),(0.52,0.93939),(0.54,0.93939),(0.56,0.93939),(0.58,0.93939),(0.6,0.93939),(0.62,0.93939),(0.64,0.93939),(0.66,0.93939),(0.68,0.93939),(0.7,0.93939),(0.72,0.93939),(0.74,0.93939),(0.76,0.93939),(0.78,0.93939),(0.8,0.93939),(0.82,0.93939),(0.84,0.93939),(0.86,0.93939),(0.88,0.93939),(0.9,0.93939),(0.92,0.93939),(0.94,0.93939),(0.96,0.93939),(0.98,0.93939),(0.99609,0.93939),(0.00391,0.95455),(0.02,0.95455),(0.04,0.95455),(0.06,0.95455),(0.08,0.95455),(0.1,0.95455),(0.12,0.95455),(0.14,0.95455),(0.16,0.95455),(0.18,0.95455),(0.2,0.95455),(0.22,0.95455),(0.24,0.95455),(0.26,0.95455),(0.28,0.95455),(0.3,0.95455),(0.32,0.95455),(0.34,0.95455),(0.36,0.95455),(0.38,0.95455),(0.4,0.95455),(0.42,0.95455),(0.44,0.95455),(0.46,0.95455),(0.48,0.95455),(0.5,0.95455),(0.52,0.95455),(0.54,0.95455),(0.56,0.95455),(0.58,0.95455),(0.6,0.95455),(0.62,0.95455),(0.64,0.95455),(0.66,0.95455),(0.68,0.95455),(0.7,0.95455),(0.72,0.95455),(0.74,0.95455),(0.76,0.95455),(0.78,0.95455),(0.8,0.95455),(0.82,0.95455),(0.84,0.95455),(0.86,0.95455),(0.88,0.95455),(0.9,0.95455),(0.92,0.95455),(0.94,0.95455),(0.96,0.95455),(0.98,0.95455),(0.99609,0.95455),(0.00391,0.9697),(0.02,0.9697),(0.04,0.9697),(0.06,0.9697),(0.08,0.9697),(0.1,0.9697),(0.12,0.9697),(0.14,0.9697),(0.16,0.9697),(0.18,0.9697),(0.2,0.9697),(0.22,0.9697),(0.24,0.9697),(0.26,0.9697),(0.28,0.9697),(0.3,0.9697),(0.32,0.9697),(0.34,0.9697),(0.36,0.9697),(0.38,0.9697),(0.4,0.9697),(0.42,0.9697),(0.44,0.9697),(0.46,0.9697),(0.48,0.9697),(0.5,0.9697),(0.52,0.9697),(0.54,0.9697),(0.56,0.9697),(0.58,0.9697),(0.6,0.9697),(0.62,0.9697),(0.64,0.9697),(0.66,0.9697),(0.68,0.9697),(0.7,0.9697),(0.72,0.9697),(0.74,0.9697),(0.76,0.9697),(0.78,0.9697),(0.8,0.9697),(0.82,0.9697),(0.84,0.9697),(0.86,0.9697),(0.88,0.9697),(0.9,0.9697),(0.92,0.9697),(0.94,0.9697),(0.96,0.9697),(0.98,0.9697),(0.99609,0.9697),(0.00391,0.98485),(0.02,0.98485),(0.04,0.98485),(0.06,0.98485),(0.08,0.98485),(0.1,0.98485),(0.12,0.98485),(0.14,0.98485),(0.16,0.98485),(0.18,0.98485),(0.2,0.98485),(0.22,0.98485),(0.24,0.98485),(0.26,0.98485),(0.28,0.98485),(0.3,0.98485),(0.32,0.98485),(0.34,0.98485),(0.36,0.98485),(0.38,0.98485),(0.4,0.98485),(0.42,0.98485),(0.44,0.98485),(0.46,0.98485),(0.48,0.98485),(0.5,0.98485),(0.52,0.98485),(0.54,0.98485),(0.56,0.98485),(0.58,0.98485),(0.6,0.98485),(0.62,0.98485),(0.64,0.98485),(0.66,0.98485),(0.68,0.98485),(0.7,0.98485),(0.72,0.98485),(0.74,0.98485),(0.76,0.98485),(0.78,0.98485),(0.8,0.98485),(0.82,0.98485),(0.84,0.98485),(0.86,0.98485),(0.88,0.98485),(0.9,0.98485),(0.92,0.98485),(0.94,0.98485),(0.96,0.98485),(0.98,0.98485),(0.99609,0.98485),(0.00391,0.99609),(0.02,0.99609),(0.04,0.99609),(0.06,0.99609),(0.08,0.99609),(0.1,0.99609),(0.12,0.99609),(0.14,0.99609),(0.16,0.99609),(0.18,0.99609),(0.2,0.99609),(0.22,0.99609),(0.24,0.99609),(0.26,0.99609),(0.28,0.99609),(0.3,0.99609),(0.32,0.99609),(0.34,0.99609),(0.36,0.99609),(0.38,0.99609),(0.4,0.99609),(0.42,0.99609),(0.44,0.99609),(0.46,0.99609),(0.48,0.99609),(0.5,0.99609),(0.52,0.99609),(0.54,0.99609),(0.56,0.99609),(0.58,0.99609),(0.6,0.99609),(0.62,0.99609),(0.64,0.99609),(0.66,0.99609),(0.68,0.99609),(0.7,0.99609),(0.72,0.99609),(0.74,0.99609),(0.76,0.99609),(0.78,0.99609),(0.8,0.99609),(0.82,0.99609),(0.84,0.99609),(0.86,0.99609),(0.88,0.99609),(0.9,0.99609),(0.92,0.99609),(0.94,0.99609),(0.96,0.99609),(0.98,0.99609),(0.99609,0.99609)])))])])
) # X3D model complete

####################################################################################################
# Self-test diagnostics
####################################################################################################

print('Self-test diagnostics for SquawLOD021.py:')
if        metaDiagnostics(newModel): # built-in utility method in X3D class
    print(metaDiagnostics(newModel)) # display meta info, hint, warning, error, TODO values in this model
# print('check newModel.XML() serialization...')
newModelXML= newModel.XML() # test export method XML() for exceptions during export
newModel.XMLvalidate()
# print(newModelXML) # diagnostic

try:
#   print('check newModel.VRML() serialization...')
    newModelVRML=newModel.VRML() # test export method VRML() for exceptions during export
    # print(prependLineNumbers(newModelVRML)) # debug
    print("Python-to-VRML export of VRML output successful", flush=True)
except Exception as err: # usually BaseException
    # https://stackoverflow.com/questions/18176602/how-to-get-the-name-of-an-exception-that-was-caught-in-python
    print("*** Python-to-VRML export of VRML output failed:", type(err).__name__, err)
    if newModelVRML: # may have failed to generate
        print(prependLineNumbers(newModelVRML, err.lineno))

try:
#   print('check newModel.JSON() serialization...')
    newModelJSON=newModel.JSON() # test export method JSON() for exceptions during export
#   print(prependLineNumbers(newModelJSON)) # debug
    print("Python-to-JSON export of JSON output successful (under development)")
except Exception as err: # usually SyntaxError
    print("*** Python-to-JSON export of JSON output failed:", type(err).__name__, err)
    if newModelJSON: # may have failed to generate
        print(prependLineNumbers(newModelJSON,err.lineno))

print("python SquawLOD021.py load and self-test diagnostics complete.")
